﻿//
//  IGenericDelegateLibrary.cs
//
//  Author:
//       Jarl Gullberg <jarl.gullberg@gmail.com>
//
//  Copyright (c) Jarl Gullberg
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;

#pragma warning disable SA1600, CS1591

namespace AdvancedDLSupport.Tests.Data;

public interface IGenericDelegateLibrary
{
    void ExecuteAction(Action action);

    void ExecuteActionT1(Action<int> action);

    void ExecuteActionT1Nested(Action<Action<int>> action);

    int ExecuteFuncT1(Func<int> func);

    int ExecuteFuncT1T2(Func<int, int> func);

    int ExecuteFuncT1T2Nested(Func<Func<int, int>, int> func);

    Action GetNativeAction();

    Action<int> GetNativeActionT1();

    Action<Action<int>> GetNativeActionT1Nested();

    Func<int> GetNativeFuncT1();

    Func<int, int> GetNativeFuncT1T2();

    Func<Func<int, int>, int> GetNativeFuncT1T2Nested();
}
