﻿//
//  ITest.cs
//
//  Author:
//       Jarl Gullberg <jarl.gullberg@gmail.com>
//
//  Copyright (c) Jarl Gullberg
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using AdvancedDLSupport.Benchmark.Data;
using JetBrains.Annotations;

namespace AdvancedDLSupport.Benchmark.Native;

/// <summary>
/// Represents an interface to a native library, providing <see cref="Matrix2"/> inversion math.
/// </summary>
[PublicAPI]
public interface ITest
{
    /// <summary>
    /// Inverts a given by-reference <see cref="Matrix2"/>.
    /// </summary>
    /// <param name="matrix">The matrix.</param>
    [PublicAPI]
    void InvertMatrixByPtr(ref Matrix2 matrix);

    /// <summary>
    /// Inverts a given by-value <see cref="Matrix2"/>.
    /// </summary>
    /// <param name="matrix">The matrix.</param>
    /// <returns>The inverted matrix.</returns>
    [PublicAPI, Pure]
    Matrix2 InvertMatrixByValue(Matrix2 matrix);
}
