# Wiki Patterns	

*How to wiki*

* If you can edit a word doc, you can edit a wiki page. All the formatting is the same. 
* Wikis give you new formatting to create *blocks of content*, embed widgets, and show links to other wiki pages (docs) automatically.
* Use a wiki page when 
  * the info will be *long lived.*
  * When the information needs to be findable *within context to related info* (e.g. for your department or team).
  * disk or cloud docs have no inherent navigation, like breadcrumbs, and so are often hard to keep track of.

## We are Avoiding This

![](assets/we-are-avoiding-this.png)

## Core Pages

### Finding the Home

There is an overall company home, which you should have received an email about when you joined. Keep it handy, as it is generally the root of all other information in the wiki. 

### Pages for your department, and team

Just like the company having a home, your team in your department will have a single page that is the basis of all related information. It will also include links to important tools, practices, and related resources.  

#### Consider a possible template:

* Team
* Charter
* Resources owned, repos
* OKRs
* Reporting
* Jira / backlogs
* Major wiki points
  * Retrospectives,
  * SOPs, templates, and policies
  * other common page types
* Patents / IP
* Forums / Q&A / unanswered
* Comms channels, internal & external 
  * including social
  * Conferences and presentations


If you notice anything that is important to your work, but it’s not mentioned on your team's pages, you should feel free to add it to an existing page or a new page anytime. You can confirm where it goes, but proactively adding information trumps losing track of an important thought.  Take note of whether a page is a historic record (static) vs. a more-active living document.

### Language for Page Types

![](assets/docs/Writing-Sytle-Guide.jpg)

### Make templates

If many of the same pages will be made, make a template.  Think about RFCs, client overviews, competitive analyses, product planning charters, etc. 

Templates usually capture best-practices around a topic, so it’s good to get people to relate with those structures. 

#### Tech Docs

Remember to include

* Who uses this product/feature?

* What does it do?

* How does it fit in with other products and features that are made by the company?

* What types of information will this product or feature need? Conceptual overviews, Task-based instructions, command or API references?

* Does any other parts of the product require technical information to be authored, such as user interfaces, command interfaces, etc?

* What formats would be useful for the information? Are there standards in place at this company already that can be followed? 

    You might have to contact an entirely different person in the company about this part - another technical writer, or user interface designer would be a good start.

### When to edit the Page, When to Comment

Free free (anytime / future) to make direct additions to the page.  I know there can be a tendency to think that someone else is the author or maintainer of a doc – and it feels polite to not change someone else’s work.  What scales best, though, is when we all edit docs directly, and develop house-rules in the few occasions that an issue occurs.

* Edit when you feel pretty sure that the information is correct for the context. 
* Comment when something requires buy-in.  When discussion or debate confirms that everyone agrees with something that could impact them. This goes for leads and non-leads. 

#### Inline, or Footer

Most wiki pages support either inline comments, or footer ('free') comments.  *Durability* of the comment commonly drives which to use.

> Inline comments often deal with a question, or imperative, that may result in changing the highlighted->commented text.

Many wikis allow the inline comment display to be accompanied by a "`Resolve`" button.  Many comments can be left inline, in a series, like an email thread or text chat.  Resolving a comment implies that the discussion resulted in a completed action, and often Resolving hides the comments in the page's history.

If the text that 'anchors' the comment is removed in an edit, usually the comment automatically is hidden.

![Inline commenting is key](assets/docs/wiki-inline-comments.png)

Footer comments annotate the whole page with an idea.  Often these comments allow a threaded discussion.  In most cases, the comments do not automatically hide, or have a `Resolve` concept.  As such, footer comments often have long durability. 

### Special Elements

In Confluence, there are many blocks that can be added for searched content, code formatting, drive files, and many more.  You can get an autocomplete list by typing `{` anywhere in edit mode.   Double-click its title bar to re-edit one that you've already added.

## Common Edits in Hypermedia 

Use `monospace` font for indicating a symbolic concept.  Think of a 'symbol' as any *noun* or *thing*, particularly those having durability across a broad scope in the system.

![](assets/docs/wiki-monospace-text.png)

## Replace many of your Slacks

*Or emails, if you are a big email person.* 

* If the conversation is about something that perhaps should go into wiki when you are done talking about it, consider starting it on a wiki page. 
* Comments and updates to the wiki page will send an email notification. Your workflow is the same, but creates a meaningful business artifact. 
* Wiki pages are enduring. New hires can be included in discussions without have to retrace knowledge-transfer inconsistently.  
* Executives and administrative assistants take on more of the role of knowledge and practice _curators_, in order to serve the leadership role of the future.


### Follow the main pages for your teams

The wiki will typically have sections for the whole company, each ‘department,' and each team. You can Watch, or subscribe, to these pages and get notified when they are edited.  Far from being noise, these updates are often significant, and link you to new 'top level' things related to your group. 

### Create email rules for Notifications

Avoid notification overload - use folders.  Create an "Updates" folder and create a child within it, "Wiki" or "Team Docs".  When you get email notifications about wiki updates, right-click the email and setup a new rule to organize them into that folder.  You may need help from someone that does IT support. 

### Create slack channels for Notifications

Notifications can go anywhere you focus on the rhythm of the team.  If that's in Slack / etc, then have wiki notifications go there. Use a new channel that's named for the topic of the wiki page, like an RFC, a team's bot channel, etc. 

### Team follows

A wiki admin can add watchers to a page, so a team leader can config these for the team.  Easy peazy. 

