# Distributed Teams

> a.k.a. 'remote work'

While the heading of this section could be 'remote work,' the reality is that it pertains to all work.  The modern workplace operates remotely for all people.  Most businesses operate with support teams and individuals, whether they are full-time or part-time.  This _distributed team_ environment requires social and technical evolution. 

* teams are inherent distributed. No one should hold the pronoun 'remote', as this makes them a second-class citizen in the company culture. This leads to them be left out of discussions, decisions, and other parts of the business. 
* Use the most effective forms of influence for the situation
  * rationale
  * inspirational appeals
  * consultation
  * collaboration

ℹ️ To bootstrap a remote culture, start by [sending everyone home to remote-work for one week with no office time](https://will.koffel.org/post/2020/remote-cultures/).

## Basic Comms Hygiene

* Set working hours

* Have quick calls to resolve confusions.
* Assume positive intent.
* It's impossible to know everything 

* Dress for the day
* Have fun.  It's important to release, and spread the mood.
* Say thanks.

* Don’t mix chat apps, ideally
* Effort on work/life seaparation

### Keep docs as centralized as possible

> 🏮 Document your processes and culture. Develop a mentality that "if it's not documented, it's not actionable" to help your team transition from co-located norms to all-remote norms. 

* No or low search; consistent with company language/terms.
* Team Folders; **Findable**.
* Consistent; no confusion.
* Make roll-up or summary lists of all the things.
* No local file saves.

Can be structured and formatted to showcase a train of thought.   [Remember to write in the tool/app that is best suited for the workflow!](https://newalexandria.github.io/leadership_readme/notification-practices.html)

## Forming teams

Remember to consider also [how teams change and scale](career-coaching-training.html).

### Guilds, Tribes, and Functional areas

1. Usually a toolset, engineering practice, and including engineering-related.
2. Share uncommon insights and learnings about the practice area.  'Head off at the pass'.
3. Birds of a feather.
4. Healthy exchange between teams at same corp, or within city.
5. May be an innovation ecosystem.

### Line of Business teams

1. Generally long-term.
2. Typical daily ops. "BAU".
3. Baselines vs. incidents.  Trending.
4. Reliability and Quality engineering.
5. Knowledgebase for onboarding & x-boarding.

### Project teams

1. Forming a collective purpose-driven identity
1. Moving toward ____
1. Collective action, and engaging in reflexive dialog
2. Maybe be short or medium term.

### Extreme Development

1. Highly purpose-built (even 'scientifically')
2. Very short term (problem specific).
3. Stronger when multi disciplinary / style.
4. Innovation, critical matters, architecture, etc.

## Connecting

Whether in person, or particularly when working as a distributed organization, with distributed leadership, it is important to *practice* communications.  

1. #### Active Listening

    It's simple: pay attention.  *Model* what you're hearing, not just listen for instructions.  Listen for feedback and be aware of your responses. 

2. #### Focus on Behaviour

    In the absence of _body language_, it is critical to focus on the behaviours (decisions and actions) of people. Similarly, no one will interpret your body language. 
    
3. #### Balanced Response

    We all have a tone of signals to interpret. The easiest way to avoid misunderstanding is to have a balanced response.  If the basis of a communication is criticism, make sure to point out the strengths that also exist.  If the basis is praise, be sure to offer support for growth, too.
    
    When writing in text, it can be structured and formatted to showcase a train of thought.

4. #### Cameras On

    Audio is a thin channel.  Maintaining your face on-camera during a call will create trust and bonding. *You will also learn about your facial expressions, which for some people will be an eye-opening lesson.*  There will be some occasions where you cannot have the camera on — in preparation for these times, set your profile's avatar to your face.  This will trigger peoples' memory about who they're speaking with, and still work to reinforce the bonding.  Set the same avatar everywhere, to further reinforce that memory. 


## Meetings

### Meeting Efficiency

Some things happen better in live conversations (F2F or video), and [some things happen better asynchronously](https://about.gitlab.com/company/culture/all-remote/asynchronous/).  Know which, and try to pivot meetings that are pulling in the wrong things. 

#### live
* Reviews
* Assignment
* Prioritization
* Approvals

#### async
* Creating
* Vetting
* Execution
* Measurement

Async relies on the right tools.  [Use the right one for the context.](https://newalexandria.github.io/leadership_readme/notification-practices.html#when-to-use-a-given-tool)

### Accountability

* Don't just talk about ideas.  Talk about specific actions, and who will act.
* Agree on both an action, and a target delivery date.  Or, refine the card for story-point estimation
* Break work into 'MVC' pieces - the [Minimum Viable Change](https://about.gitlab.com/handbook/product/#the-minimally-viable-change-mvc) is always easier to validate, debug, rollback, scale, etc.


#### Critical feedback

* Aim on 1:1, but hold back from starting in text.
* Frame the context.
* Contrast this vs. their strong behaviors.
* There is no easy way, so don't drag it out or meander.

### Conversation Types

|      | Check-in                                                            | Debrief                                                         | Refocus                                                                  |
|------|---------------------------------------------------------------------|-----------------------------------------------------------------|--------------------------------------------------------------------------|
| What | Review progress toward short term goals.                            | Examines performance over time, toward goals.  OKR summaries.   |  Helps an individual understand team goals, and alignment.               |
| When | Tempo-schedule, or ad-hoc as needed.                                |  After a project, or on a tempo during the course of a roadmap. | Anytime necessary.                                                       |
|  Why | Identify progress, roadblocks, and learning/adaptation touchpoints. | Identify learnings that improve macro performance.              |  Improve the contribution to active team or corporate goals, or culture. |

### Influencing

There exists a proposed scale of influencing, within civil and professional environments.  At the core of it: *ensure that those you're speaking with feel the pain of the need*.

#### Most Effective

* Rational Persuasion
* Inspirational Appeals
* Consultation
* Collaboration

#### Moderately Effective

* Apprising
* Ingratiating
* Personal Appeals
* Exchange

#### Least Effective

* Legitimating
* Coalition
* Pressure

*Collaboration* can often be thought of as the most sustainable, trainable, and practicable form of influence for maintaining organizational alignment. 

----

## Teamwork

> 🏮 Create and enforce rules to improve your remote work culture. These can include things like limiting slack conversations to  90 days to ensure projects drive to a close, or requiring everyone to reject meetings without an agenda

#### Multitasking

Multitasking emerges naturally with optimization, and growth of the company.  While it is not ideal, there are a few key mechanisms to understand, talk about, and have clear for all.

> 💡 The tl;dr here is that if many people are not paying attention in a meeting, make the meeting more concise, change its membership, and consider canceling it in favor async status updates.

#### Participation

Participation heals all wounds.  If it won't happen naturally, then there's something to fix with the meeting.  If you're leading the meeting, and it's not getting fixed, invite someone who can help to join the next one.

#### Note taking
Laptops and other devices are a natural part of taking notes, for many people.  The use for notes needs to be reinforced.  People still need to avoid 'banging' on keyboards, and disrupting the flow of presentation and conversation.

Mobile phone use is not exception. Your inattention bring-down the mindset of the meeting.

#### Brief and Focused
Meetings can sometimes ramble, or exercise one person's ability to communicate comfortably at the level of the topic. If the meeting will routinely involve this element of personal support, aim for a smaller audience that can reduce the pressure of public speaking, and also provide feedback intermittently. 

It's also a common dilemma that meetings involve an entire agile team, when the topics of the meeting only involve the judgement of few people.  All of the team should feel comfortable with a limited audience attending the meeting.  Consider dial-in for the rest of the team, or the others can rely on meeting minutes to review the highlights of the discussion. 

#### Auditing
An echo to the last point, often people will want to be aware of what's happening in the meeting, and perhaps inject one or two key insights at the right time.  Consider dial-in, even with your headphones from one's desk in the office.

If in-person attendance of meeting 'auditors' seems important, try to follow these two UX principles:

* Do not type loudly on other work, which disrupts everyone with the awareness you are not paying attention.  Even if this means you must type slowely or delicately, that is the cost of the courtesy, and support of the team.
* Sit at the edges of the room.  Avoid taking a central seat, which will implicitly make you a central member of the meeting.  Aim to be a fly on the wall.

#### Have a Role

For those that are not auditing, it will help to understand their role in the meeting.  If anyone is unsure, look to what assignment they will get as a result of the meeting.  If they won't participate in assignment or prioritization, reconsider 'if' and 'what' the value of them attending.

In an ideal world, each person attending a meeting could have their expected role sketched out in the meeting's agenda.  This generally wouldn't happen for several reasons, but it's a [gedanken](https://en.wikipedia.org/wiki/Thought_experiment) to help refine the efficiency of meetings. 

> Create and enforce rules to improve your remote work culture. These can include things like limiting slack conversations to  90 days to ensure projects drive to a close, or requiring everyone to reject meetings without an agenda

----

## Agenda

Use the calendar invite strategically, as a 'micro-document,' to set the meeting for success.  

1. Almost without exception, use the calendar invite to bullet-point-outline the scope of the meeting.  **This is very important to setting the context and expectations**.  
2. When possible, add *links* to shared docs, for anyone who needs to read more for familiarization with the topics that the meeting needs to discuss. 
3. Follow a minimum-docs principle.  Think of it as the "MVP" of what's needed for the meeting.If you cann't do this with the docs you have, create a list of links that are akin to a slideshow.

Always leave 5 minutes at the end of a meeting, for closure.  Make assignments and other followup tasks.  Set dates, whether specific or rough.  Set a timer, and don't skip this.  Accountability works best when we have involvement in the tasks we need to do.

⏲ And if it's a large office building, leave an additional 5 min so everyone can get to the next meeting on time. 

### Retro

It's important, from time to time, to reflect on whether a meeting still needs to be held.  The best time to do this is _at the start of a meeting series_.  Set a future target date, for when the scope of the meeting may change, and need to be reviewed by all involved. 

## Meeting People in Your Company

Smalltalk can be merciless.  Within your corporation, it becomes easier to turn your questions to the environment and the corporate 'state of the nation.'

* What is your role?
* How will we interact?
* What are you expectations of me / my team?
* What are something I/we can help with?
* What is working well on the team / Recent accomplishments?
* Anything I can tell you?

## Knowledge Flows in the Company

### Top Down

* CKO
* Analyst Days
* Executive Interviews
* Mission / Vision / Strategy


### Bottom Up

* Focus groups
* High-Performer analysis
* Input to VPs
* VP & Director 360s
* External Research

## Culture

> [Values are behaviors. Behaviors are choices.](https://askalmanac.com/articles/652/guide-how-to-create-company-values)

It's a good idea to formally create [informal communications](https://about.gitlab.com/company/culture/all-remote/informal-communication/).  

Coffee 1:1s, open video-call times, happy hours, etc, but can also be unscripted ‘drop in’ times and anyone can state their openness. Social contact cannot be forced, but we can each do our part to make it certain times more enjoyable than others. For fully distributed teams, ensuring these times holds lasting value.


1:1 times are important, too. Team members that collaborate with each other (1:1) should expect a small bit of time will go to just being a normal human with each other. This often appears as 5 (or whatever) minutes of talking before getting down to business. If you can plan for a little bit of this time each week, no one will be surprised.

#### Virtual Gathering spaces

It's not everyone's jame, but 'avatar tools' [like Gather.town](https://www.gather.town/) , or [Kumospace](https://www.builtinnyc.com/2023/08/16/kumospace-acquires-kosy), help to create some of the spatial feel of being around others.

You can also do "Shared space" sessions, where everyone joins a video call while doing quiet solo work.  People can split off if a question gets too distracting to others.  Sometimes these are best done in pairs, since the conversation styles can be aligned.  

Regular collaborative sessions, such as mandatory pair and mob programming, are also effective.

In all cases it's more about finding the right tone to get people to try it and realize the value.  It can help to screen for willingness and receptivity during onboarding.  Find how to get people to take risks and experiment with the changing office landscape, but know the chemistry of your team, too.

### Journaling vs Standup
When time zones and scheduled don't overlap enough, look to use intermittent daily journaling to give value in place of common standup time, and to act a bit like a GTD / pomodoro.

### Re-creating the Office

* happy hour gift boxes
* standing desk options
* second monitors
* ergonomics
* lighting 
* home-workers vs cafe-workers
* food-ordering budget
* listen to people and what they talk about for their space
