
### What is the role of Moderation?

* I think that moderators set precedents, create consistency, and promote things that aid the growth of the community.

* I think we could add more options with flagging a post, to indicate that a post seems to be asking for a common problem (e.g. legal advice, on a Law site, or is worded in a way that encourages getting it). Same for answers that fall into common tropes. We could also change the help pages to reflect these community flags.  

* Ultimately, mods get to see more of these, and can identify these patterns before they affect too many people.


### Mod Visibility
A diamond will be attached to everything you say and have said in the past, including questions, answers and comments and chatroom messages. Everything you will do will be seen under a different light. Do you feel like all the material you've posted on the site reflects that you would be a good moderator? Does becoming a moderator induces significant changes in what you do—and refrain from doing—on the site (outside the obvious addition of moderator duties)?

* I always presume that I'm being viewed in this light; the diamond just makes it more likely that people will read that public history.


### How would you deal with a user who produced a steady stream of valuable answers, but tends to generate a large number of arguments/flags from comments?

* I have tended to see this kind of person wants to contribute, and just needs help to stay golden. With talk in chat or another kind of DM, usually there's a good middle ground. It's important to identify if the arguing is part of their MO/agenda. If it cannot be corrected I do think there has to be a line. An intelligent and argumentative used can scare away others because of the charisma involved.

### How would you handle a situation where another mod closed/deleted/etc a question that you feel shouldn't have been?

* With mod differences, Meta questions can be a great way to clarify what the community feels is best. Ideally no mod has problems discussing things in open forum. Where the issue may be sensitive, chat or other DMs.


### What is your moderation style? 

Do you have any Meta posts that you're particularly proud of, or that you feel best demonstrate your moderation style? (source) Alternatively, do you feel that you've contributed significantly towards some other aspect of site maintenance (e.g. reviews, flags, related/possible-duplicate comments)?

* I like to clean things up; mod status makes this easier. Same as with question #2, I like to post these changes as proposals in meta, to garner feedback. It's a volunteer job, so is best to all be in agreement befofe using the time.





## Sources

**Trust. Support. Agency. Accountability. Autonomy.**

*   Trust people. Nothing else works if you don’t have trust. You can’t grant autonomy if you don’t trust folks, and they won’t be accountable if they don’t trust you. 
*   Supporting people should be your default reaction. This is essential to maintaining trust. We haven’t always held this ideal as highly as we should, but we’re focused on doing a better job going forward. Sometimes supporting people means teaching them what they didn’t see, or how they could have explained their position better. What matters is, when you show up, their default reaction is phew, things just got better. 
*   Give people as much agency as you can. The people closest to the issues tend to be the ones that are best suited to make the best decisions.
*   Require accountability as a tool for success. When you think of accountability, you might think of blame, and that means you’re probably a victim of  bad management. Positive accountability means you’ve created a space where trust, support and agency run freely and people understand what’s their role is, and what success looks like. This means teaching people to learn to embrace mistakes as an opportunity for growth and improvement.
*   Autonomy is critical to a sense of ownership. Folks need high-level direction in order to thrive, but even more essential is the space to interpret goals and distill them out into a strategy that they can act on in their own very unique circumstances. Some people need more help than others, but not getting in someone’s way while serving as a guard rail and a mentor can be really, really, really hard.


## References

* [StackOverflow MetaZoo episode on rating/grading questions](https://meta.stackexchange.com/questions/328475/unicorn-meta-zoo-3-how-do-we-grade-questions?cb=1)