# Measures for Hiring tactics

Some would argue that the core of how to measure hiring efforts include:

* Engagement 
* Time to hire 
* retention rate
* Cost per hire
* Team output; MoM
* Team output; YoY

These can be thought of as KPIs, or, the metrics behind any OKRs that are framed.

### Out of bounds

If the team runs itself for 6 months while you struggle to source/hire, then you can probably promote instead.

## Recruiters

Anyone doing recruiting, internal and external, have a sales-oriented role.  It's critical that they understand this, feel armed to do so, and coordinate their piece of the 'pitch' (branding).

* For external recruiters, think of an office tour. If you don’t have an office, then set up a videoconference meeting and let them meet the team and ask questions. Invite to happy hour.
* Spend at least an hour going over the mission, the company and what you are looking for.  Have them give their pitch back to you to make sure they know the ins and outs.
* Make sure people doing recruiting have the mobile number of a key hiring manager.  It's teamwork end-to-end, and it contributes to the sense of the company that is conveyed.
* Continue to build this aspect of the company's relationship over time.  Don’t assume the job is done because you started off right. Relationships are not a transaction.


## Errata

* sourcing criteria
* matchers per-team per-role
* ATS integration
* screener call, HR
* screener call, team
* code challenge equivalent
* onsite interview dimensions 
* rubric iteration

## Inclusivity

Inclusivity just a part of DEI, and it's important to engineer for it. 

1.  Use regular, searchable titles that stick close to industry norms - do that job seekers can find and recognize them.
2.  Be absolutely clear about the role, the responsibilities, and the requirements.  Give an outline of the process, ask about how they can best engage with each step, and actively listen for where adaptation can help all parties. 
3.  Authentically represent your company and culture.  Diversity statements are just a promise, but commitment comes from realistic self-awareness that allows for active engagment.  Be clear with benefits/perks, too.
4.  Use clear, non-biased language that welcomes job seekers of all backgrounds.
5.  Publish your job ads broadly, job seekers may not have the time or awarness to be looking everywhere.

## References

* [Awesome Engineering Management list](https://github.com/kdeldycke/awesome-engineering-team-management)