    # Team Files and Shares

* You want to think of drive files as a complement to wikis and other docs
* Create online / cloud files first, unless there is a specific need.
* Create offline (MS Office) files in your team’s drive.
* Setup your cloud drive to be integrated with your desktop and mobile.  Make it be the place you create new documents.
* Locate your team share drive, on desktop.
* If needed, create a private folder ('my cloud') for your working drafts. Move them to a team drive instead of sharing from your private cloud.

## Best Practice
This is more than just pedantic process.  It gives us the highest valuation of a future audit / diligence.

The important thing is that we use the team drives for important core files, and arguably any file.  Without that, the team loses files when someone that leaves the company.  Again, we should all think toward future audits and due diligence.

This is all an effort to get us as close as possible to enterprise-grade systems, without the overhead of them at enterprise scale.

> Don’t hesitate in deciding where to create new files in the team share. __Organization can come later, if it inhibits your workflow.__  Ask for help or feedback.

#### Format

Some use the acronym ALCOA, or ALCOA+ to guide the standard of writing for docs:

* Attributable
* Legible
* Contemporaneous
* Original
* Accurate
* with 'plus' ideals of being Consistent and Enduring. 

![visual of the ALCOA meaning](assets/docs/good-docs-acronym-ALCOA.jpg)

### Naming

* Use folders that match the name of your department, team, or project / epic. 
* Avoid duplicating files and giving the name suffixes like “_09-21” or other dates.  Cloud files maintaina. history of edits that you can go back to any time.

### Good habits

#### Make New Things
* create a doc
* create a spreadsheet  
* create a slide set  
* create a collection or folder
* create a diagram  

#### Improve Things
* update another's doc
* update an old doc  
* reorganize collections (get buy-in!)
* add more style/formatting to a doc (readability)  
* use header levels  
* add a TOC  
* add a screenshot/image to a how-to

#### Strengthen Connections
* cross-link docs
* create links to external resources  
* create a team share  
* create selective share  
* create a share with people not in your org/domain

### Consider Your Audience

Regardless of where you are adding a piece of writing, and regardless of its size, there is an audience.  

![Writing audience guides](assets/docs/Writing-Sytle-Guide.jpg)

## Google Team Drives

### Syncing
Google enterprise now uses Google File Stream.  You must first uninstall any existing Google desktop backup and sync utility.  __This is critical__.

Then, [install Google File Stream](https://support.google.com/a/answer/7491144). You can configure it so sync all files and drives, or only some.

### Team Access

Team Drive access permissions are at the drive level.  That means that you typically get 3 kinds of shares:

1. Edit access for the whole team, all others Comment only
2. Company share, with Edit access for all.
3. Private team share, with limited access (usually legal stuff)

#### - sharing team drive files -

Team Drives have a philosophy, that makes sense once you know it.

* Folders in a team drive cannot be shared.  This is to prevent accidental leaks of data.  Only files can be shared, individually.
* Team drives need to be configured to allow any shares outside the org.  If not, then it’s locked.
* If you want to share with an outside vendor (like Pickaxe), then choose what files to share with them. They can manage a folder on their end.  
* If instead, you want make a team drive for that collaboration, then you will copy and move files to that 'collaboration drive'. _This is akin to making a version._ You can do this by download+upload in bulk.
* This is all easiest to do when starting a new vendor relationship, and acting on each file as need arises.

#### Common Usages

This works great for teams that need better control over files, like HR and the exec team.  For other teams, most of their files can be open to the whole company, with optional limitations on to only comment or view.  

Sales may be an exception to this, but ideally legal stuff like raw revenue, and contracts stuff, stays within the exec team, and all other client info remains open.

### Confidential Files 

If you have some kind of legal files, and want to make them available to those that are not part of the confidential team drive, there are good patterns.

Generally these would be individual shares, such as in the case of hiring documents, compensation agreements, etc.  

Bulk shares would occur in cases like all healthcare information being centralized. This would be done via bulk download and upload to a common place, to create a specific version or 'release' of that information.
	