# Career Ladder

Recently there has been more reconsideration of what 'levels' look like for a software engineer.  Where there was formerly more homogeneity across development work, there is recently a huge range of specialization. These many areas of specialty challenge the classical idea of seniority, as a very senior-skilled engineer may lack fluency or capability with a pivotal practice that has been nearly mastered by an otherwise-junior developer.  Conversely, junior developers may overestimate their their vision under the study of average teachers. 

In an ideal sense, and one that is humanly-impractical, there could be a method of scoring and totaling one's abilities across all of these pivotal practice areas, and  totaling and aggregate that equates to skill level.  That is a trend toward excessive accounting, or an AD&D-like role-playing schema for one's life.

Today, at least, that is not our culture.  Yet it is good to remember that Amazon and many other large firms have identified a value with interviewing and reviewing using carefully crafted scoring systems.  'Scout badges' may yet return, [if this is a trend](https://www.vegafactor.com).

This page may move to be a reflection of [the structure that @sarah_edo setup here](https://career-ladders.dev/engineering).  My own history with roles and levels will get worked into that.  In order to try for a general format that can guide ladders at any company, here we will unfold some of a rubric.

## Rubric of Skills

Deeply granular assessments are more ideal for differentiating areas of strength, and giving very targeted mentorship and support.  The same can also cause overload.   

A simplified version of skills assessment usually covers these four areas:

* tech quality
* collaboration
* execution
* org quality

Any organization in a company can reuse these by relating 'tech' quality to any use of tools to speed up workflow and delivery.  All code is essentially tools for automation.

> Above all else, the assessment of career growth should mirror [the assessment during Interviewing](https://newalexandria.github.io/leadership_readme/interviewing.html), including personal/psychological makeup.

## Pivotal Practices

*([compare vs a role like "Principle/Staff Engineer"](https://archive.md/nvvAQ))*

### Architecture

* Designing and Implementing the solution to a large software problem
* Modeling Data for Different Use Cases
* High Level understanding of the entire technical system/architecture
* [Architecture of Web Interfaces](https://newalexandria.github.io/leadership_readme/web-app-anatomy-best-practices.html)

### Code Verification

* Creating and Coding Automated Tests
* Owning and Debugging Production Issues
* Pressure Testing Qualitative Work

### Problem Solving

* Debugging, tracing, and reverse engineering
  * *"you have logs or shut the fuck up" -SGUG*
* Solving a Narrowly Defined Problem
  * [How to Ask a Good Question](https://stackoverflow.com/help/how-to-ask) by StackOverflow.
* Cutting Through Complexity

### Programming

* Implementing Algorithms and Data Structures
* Building Modular/Testable Components
* Functional Programming
* Object Oriented Programming
* Understanding Type Systems
* Understanding Code
* Observability, Instrumentation, and Performance

### Tools to Get Stuff Done

* Building and Using Your Work Process
* The Unix interface

### Devops

* Designing and Developing Tools to Manage Cloud Infrastructure
* Administering Databases

### Users

* Considering the User Experience (HCI)
* Designing API for Public Use
* Behavioral Instrumentation

### Teamwork

* Pulling in Help and Collecting Advice
* Improving a Team's Performance by Reflecting on Outcomes
* Coaching your Team Members
* [Distributed Teams and remote hygiene](https://newalexandria.github.io/leadership_readme/remote-work.html)


## References

An [interesting article discussing many roles and their function](https://medium.com/javascript-scene/software-roles-and-titles-e3f0b69c410c).

As well a [list of books on communicating at the level of a manager](https://github.com/jesselpalmer/the-engineering-managers-booklist).