# Coaching and Training

## Scaling Teams

### Startup company scalings

At small companies the main pain is hiring experienced-enough people that ‘jr’ devs can be hired later, and join a strong set of workflows and relationships.  Sometimes this just isn't in the cards, and the complex job of hiring new managers then occurs. 

Making this happen with stability requires existing people on the team have support to realize which roles fit within their personal ideals and limits — limits which include the likely or demonstrated rate of growth in an area the company needs. 

Approaching starup hires in a bespoke fashion ensures that existing teams stay whole.  Miminizing disruption from turbulence has more value and impact with a startup. Yet, bespoke teams can have additional management 'costs' – either because of the broader range of simultaneous, adaptive, leadership strategies - or the cost of fitting new hires to the structure.  

I find these adaptive strategies preferrable to the typical pattern of team change: 'industry standard' role and team structures get implemented in a forced way.  People identify with betrayal or general mismanagement, and the image of leadership suffers until there is a seachange in the composition of the team or company.  Some startups never recover from this. 

### Larger company scalings

With larger teams and mature companies, the pains are usually onboarding knowledge-transfer (‘all the things’) and balancing who does specialization vs generalist eng. problem solving.  With distributed teams,  all meetings and checking’s need to be slightly more regular more consistent than entirely local offices,  as well as the instigation of shared cultural experiences among the team.

The choice to code-eval during interview is another major cultural pattern.  Consistent interviews, trusting fairness, and strengthening viewpoint diversity also need to be solved.

All of these things cannot be wholly owned by engineering leadership unless  something major is omitted, like more hands-on architectural involvement, or process workflow and coordination, either within engineering or cross-company.  


### Personal Factors


Though this chart can be excessive, most of these pressure exist in people, in the way the react to their job, if not also their life.  While it's important to not over-psychoanalyze anyone, it is important to help them untangle their pressures.  The best professionals will self-manage the differentiation of personal development from work development.



![](assets/career-growth-dimensions.jpg)

### Some Routines for Team Health

* Coach, 
* empower and 
* defined boundaries
* everyone knows what the expected outcome
* get out of the way as necessary
* Create synergy
* chasing information to do work drains motivation and depletes trust between teams
* default open” culture of learning and improvements; ideas, information, and feedback, flow freely 

### Some Routines for Personal-Professional Growth
*([ref](https://dev.to/inovak/7-habits-to-cultivate-for-becoming-a-better-software-engineer-344o))*
* Invest in Your Craft Outside of Work
* Understand the Why, Not Just the How
* Collaborate Intentionally
* Architect with the Future in Mind
* Own Your Code
* Continuously Improve Through Feedback and Reflection
* Bring Passion, Curiosity, and Perspective

#### Trust

Listening.  Really listening to others is the #1 thing that anyone can do to earn trust.  People that are seen, know that their needs are understood.  In the process of being seen, we see others, any know something about how we can trust them.

## The PIP

I generally avoid hosting a PIP, unless HR mandates it.  

I've had to handle situations where someone was in this place.  I've helped a person recover, and I've had to let people go.  I've had to own it when people I report to would not.  I've been a fairly often an ally of HR, since I care about people, team, and orgs, and see dynamics in-formation.

With PIPs, most people change their behavior for the worse, when they're handed a PIP during the 1:1 cycle.  The younger end of people, today, will respond better to constructed learning, feedback, and targeted growth (with returns). I think it's a result of a shift toward ambiguous training and lacking mentorship from schools and parents/community.  

PIPs often read as leadership failed to give direction and coaching to an employee about growth targets — or hired them wrongly. It breeds resentment. The 1:1 cycle should be personable while discussing needed targets, and why, and listening to their POV.  

### Timelines

I generally soft-PIP for 3 months or so, as I see the issue emerging.  Usually that nips it in the bud.  Sometimes it takes longer and I get more repetitive and focal in the latter part, or over a total of max-6 months.  At worst, usually someone will find a new job before they need to be fired.  In the better situations, the separation can be planned openly and supportively. 

In all cases, respect is maintained, brand reputation, and we all have the advance perspective on whatever is coming. 
