# BC & DR Policy Concepts


With business continuity, disaster recovery, and related optics, there are a number of concepts and practice-docs that can 'matrix' into corporate and operational competencies.  It’s worth understanding these, to give a sense of where Even will need to track toward, as it becomes a company of sufficient scale of partner value and operations. 

While the points on can be staged out in several ways, the early-stage options below are the first we would think about.

> A BC DR audit is different in scope and context than a SOC II.

> Especially: no version of a SOC II is considered to be encompassing of a BC/DR review and preparation.

## 📚 Document Types

* Standards
* Policies
* Operating Frameworks
* Playbooks
* RACI
* Testing

*Generally these will document how to practice Governance, Capabilities, and Tools.*


## 👩‍🔬 Scope Areas 👨‍🔬

* Business Continuity
* Disaster Recovery
* Event / Crisis Management
* InfoSec & Physical Security
* Data Controls

*Generally these will define the range and semantics of Governance, Capabilities, and Tools.*

Note that in a SOC II, 70% or so will focus on InfoSec, data, and Recovery, just as we’ve already practiced.  


## Early-Stage options of BC/DR Audit

> Some firms that can do the audit will be highly exposed to our cohort and partners, and can provide guidance that improves our competitiveness.  

> This is one of the major reasons to pay a premium for such companies.

### 📒 Controls audit best-practices

The audit would focus on our existing docs.  The review and feedback would pertain only to the stated and planned scope.   


The costs for kind of audit does not seem to cost any less than audits of lesser scope (‘value’).  It will take less time, though.  

From an outside perspective, this audit conveys that we have insured the minimum feedback needed for comprehensive coverage of topics.  

### 📒 Controls audit with functional practices

This level of audit adds a focus on functional areas of the business, in order to ensure that these operational areas are considered by management in the stability of the services.  The firm doing so would audit in the form of:

* Personal interviews
* Optional on-sites

Based on the these conversations, specific referential guidance would be tailored for our company, and our teams. 

**The costs** for this kind of audit are only slightly more than without functional-area review.  The time may be twice as long (up to 4wk / 80hr)

**From an outside perspective** this audit would convey that each part of the company has undergone reflective consideration of business continuity, and that executive leadership has more that the typical guidance from SME advisors. 

### 📒 BC/DR with Impact Analysis

This level of audit will look beyond functional areas, to the impacts that come with different forms of their change.  Identifying these impacts, and how services and operations can change from them, also helps define the redundancies and failover mechanisms.  Instead of imaging failover practices in a vacuum, they can be planned, sized correctly, and grown in sync with KPIs.

Some typical analyses:

* Data processes.
* Vendor type analysis.
* governance.

**The costs** for this kind of preparation will be a multiple of the businesses operations.  Good prior planning can minimize the discovery phase of the auditor's engagement.  Costs are also implicit with the overhead from knowing (doing business to) offer a stronger industry & cohort comparisons.

**From the outside perspective**, completing this form of audit is a strong signal of business service reliability, necessary with a relationships that are more critical to one's operation.

### 📒 BC/DR practices and outcomes audit

Working with a firm in this capacity differentiates a "controls based audit" vs "practices and outcomes audit."   Outcomes is a kind of code for speaking about 'exercises' that help us ensure we are practicing what we think we are practicing, and that we know how to do that practice sustainably.  Passing this audit more-easily will require we have a well-developed sense of programmes or operating frameworks that we conduct, reschedule, and self-audit (governance).

Some common patterns, which should in-effect via one means or another:

* Detailed Incidence response plans. 
* The spirit of this level of reliability comes from defining codes/types for partners, vendors, data, and customers
* Use of codes to determine notification scope and template. 
* Common tooling or use-of-systems patterns, which span employee tenure via group training, and training certification or internal recognition systems (vega, etc)

**Costs** will be additional to more-simple audits, with the addition of the time spent monitoring each exercise scenario, and any time that was needed for prepare to correctly execute it.  Preparation and demonstration can save time and effort, to avoid discovery.

**From the outside perspective**, these audits are more commonplace with business partnerships where one group bears responsibility to act on another parties behalf.  Activities that are 'typed' by policy likely are part of common operational parlance, and are incorporated into SLAs.

#### Backup DR integrity

An example of 'validating outcomes' includes checks of the recoverability for backup data.

1. Backups can be restored in normal use
2. Backup are maintained with separate permissions that prevent their access by normal users / processes
3. Backups of PII are restricted similarly to the PII DB
4. Backups can be restored in a disaster recovery situation.


## Reference

### [ISO 22301](https://en.wikipedia.org/wiki/ISO_22301)

* Scope
* Normative references
* Terms and definitions
* Context
* Leadership
* Planning
* Support
* Operation
* Performance evaluation
* Improvement

### Articles

* [CotE: Continuity of the economy](https://www.defenseone.com/ideas/2019/08/cyber-continuity-planning/159507/), after a crippling cyber attack