# Charter Types

## 🧭 Biz Charters
### Workflow

Let's choose stages that make sense for incrementally identifying and operationalizing value more-clearly.

Whatever we decide, let's choose stages for a process, where even if there is a mandate to Go, we can still ask for info to fill-in the ‘skipped’ stages.   i.e. they might get skipped because of ‘good gut instinct’, not because the information isn’t available if more time is spent.
### 📒 Requirements

* Motivations
* Product Value
* Financial Model / simulation
* Integration Scope
* Assumptions
* Stakeholders
* Proposal Details
* Timeframe
* Market
* Partnerships
* Associated CharterS
* Related drive and docs

### Motivations

Product Value
Financial Model / sim
Integration Scope
Assumptions
Stakeholders
Proposal Details
Timeframe
Market
Partnerships
Associated CharterS
Related drive and docs


## 🧭 Product Charter

We have seen an emerging need for a Product Charter in the wiki.  This planning doc collects all of the product release pieces.


### 📒 Requirements

Top Box:

1. Initiative
1. Owner
1. Business Sponsor
1. Epic link
1. Retrospective
1. Folders / Docs
2. Monitoring

Outline:

* Motivation
  * Issues
  * Goals
  * Background
  * Requirements
* Requirement Header 1
  * 1: Requirement
* Requirement Header 2
  * 2: Requirement
* Requirement Header 3
  * 3: Requirement
* User Guidance
  * User-flow diagrams
  * Designs, Mocks
  * BDD Stories
* Emails
* Marketing
* Rollout/Rollback Plan
* Monitoring & Dashboard
* Out of Scope
* Open Questions
* Dashboards
  * all tickets
  * unlabeled

![Sample of Storymap construction](assets/Agile-story-mapping.pdf)

## 🧭 Tech Charters
### Workflow

Track potential and complete Charters using tasks that implement a workflow that moves through the following states:

1. **Gathering Requirements** - the task is assigned to a product manager (or an engineer, if the change is eng only) who is actively gathering requirements. Once the requirements have been captured in a partial Charter and linked to the task, it changes state to Triaging Charter.
1. **Triaging Charter** - the task is unassigned until we find a lead engineer, and all stakeholders agree on the requirements as stated, at which point it changes state to Writing Charter.
1. **Writing Charter** - the task is assigned to the lead engineer, although they may be collaborating with other stakeholders (e.g. product) on producing the full Charter. Either way, everyone is actively working on the Charter, which will be continually reviewed in this state. Upon completion, the Charter is circulated across the org, and a final review is scheduled. Once the appropriate stakeholders agree on the proposed work, the task changes state to Build Backlog.
  * Rough skeleton of requirements
  * Requirements iterations with Product
  * Storymap
  * Writing details
1. **Build Backlog** - With a storymap in place, an estimation can get approved by biz-prod-eng stakeholders, and prioritized by [ROI](https://www.investopedia.com/terms/r/returnoninvestment.asp) that mixes the needs of all stakeholders.  Once approved, the Charter is prepared for implementations. The tasks remains assigned to the lead engineer while the associated epic is staffed and scheduled. A full backlog will get built by an agile team that breaks-down the storymap.  Provided no new discovery was made that changes the estimates, boards are built in Jira.  The epic kicks off, and the task changes state to In Progress.
1. **In Progress** - when the corresponding epic is complete, the task is marked complete.  The team will do a retrospective to learn from the Charter and share that knowledge with other teams.

### 📒 Requirements

1. Biz Value
1. User stories
1. KPIs / data / reports
1. Main Reqs (from Biz Charter, or internal)
1. Related research pages
1. Linked docs (widget / macro to google drive)
1. Alerts
1. Runbooks
1. Mocks and Interfaces
  1. API
  1. Embed
  1. Portal
  1. Admin
  1. DW schema

#### Biz Value

This is a 1-3 sentence motto that focuses everyone on the feature's worth to clients and users. Could be a precuros to external-facing slogans, etc, about the feature.

#### User stories

Several on-liner sentences that speak about the things that users will do while interacting with the feature.

#### KPIs / data / reports
#### Main Reqs (from Biz Charter, or internal)
#### Related research pages
#### Linked docs (widget / macro to google drive)
#### Alerts
#### Runbooks
#### Mocks and Interfaces




## 🧭 Launch Charters
### Workflow

This is still TBD, as many variations occur in Launching. Sometimes, no meaningful launch plan will appear, because stakeholder review, and natural discussion, have solved the needs for launch.  Other times, elaborate launch planification documents are needed to ensure the success of Even and its partners.

### 📒 Requirements

* Partner Services / AM docs
* Partner actions matrix
* Press materials
* How-tos
* Onboarding material and updates


#### Partner Services / AM docs

This is any workflow-related information that the PS teams maintain, for handling partner onboarding, basic debugging, and similar.

#### Partner actions matrix

This is a spreadsheet document that timelines which partners get which features. turned on.

#### Press materials

Any information posted to Even's website, as well as communications with news organizations, search engines, etc.

#### How-tos

Instructional material involved in the ongoing use and ownership of the new feature(s).  These may be either more or less technical in nature.

#### Onboarding material and updates

Updates to Even School and other materials used to orient new employees.



# Open Questions

1. How can the contents of the Charter be more flexible to all operations?  Product and technical design, mocks and designs, maybe story mapping and estimates?
1. How does the Partner Services, BizDev, and Marketing teams see the 'prod and live ops' portion of the overall flow? Invariably, this 'stage' is where we see:
  * client services discussions,
  * expanded scope of biz,
  * campaigns
  * tech-ops and saleseng, and
  * BI ad-hoc reporting along with
  * related eng. support.
2. when and where to orthogonal planning techniques, like [Risk Storming](https://archive.md/oYwWW) come into play?

# References

These are evolving lists of other charter formats and templates

* [Lee Nau's PRD from global-linda](https://leenau.bitbucket.io/lynda/product-requirements-document/)
* [collection of charter templates at useFYI.com](https://usefyi.com/templates/product-requirements-document-templates/)