# Agile Anti-patterns

These anti-patterns are a mix of cross-team situations, and inter-team dynamics.  They have been source from [Steve McConnell's "Rapid Development,"](https://dev.to/bosepchuk/the-one-chart-every-developer-must-understand-2db9).  Despite the book being more than 25yr old, these factors have largely not disappeared.  Such shows that the issues are human conditions, and require interpersonal strategies (management) instead of just commitment-to-principle.

1. Undermined motivation
1. Weak personnel
1. Uncontrolled problem employees
1. Heroics
1. Adding people to a late project
1. Noisy, crowded offices
1. Friction between developers and customers
1. Unrealistic expectations
1. Lack of effective project sponsorship
1. Lack of stakeholder buy-in
1. Lack of user input
1. Politics placed over substance
1. Wishful thinking
1. Overly optimistic schedules
1. Insufficient risk management
1. Contractor failure
1. Insufficient planning
1. Abandonment of planning under pressure
1. Wasted time during the fuzzy front end
1. Shortchanged upstream activities
1. Inadequate design
1. Shortchanged quality assurance
1. Insufficient management controls
1. Premature or overly frequent convergence
1. Omitting necessary tasks from estimates
1. Planning to catch up later
1. Code-like-hell programming
1. Requirements gold-plating
1. Feature creep
1. Developer gold-plating
1. Push-me, pull-me negotiation
1. Research-oriented development
1. Silver-bullet syndrome
1. Overestimated savings from new tools or methods
1. Switching tools in the middle of a project