# Agile Practices Roadmap

Thoughts on working together, and supporting organizations.  The growing collection of topics here journals things that come up regularly.  It is far from complete — but it's nice to write sometimes. 


## Practices

* [Docs](/docs-best-practices.md)
* [Wiki](wiki-best-practices.md)
* [Integration patterns](integration-best-practices.md)
* [Ticketing](ticketing-best-practices.md)
* [Anatomy of Web Apps](web-app-anatomy-best-practices.md)
* [Anatomy of CMS Apps](cms-anatomy-best-practices.md)
* [Anatomy of CRM and CX](crm-anatomy-best-practices.md)
* [Anatomy of Email Systems](email-engagement-anatomy.md)
* [Data, Services and Pipelines](data-science.md)
* [Scaling to 500k DAU](questions-and-answers/Scaling-a-Rails-Platform-Services.md)

### Agile Groups
* [QA and Testing](qa-test-framework.md)
* [QA for Event & Distributed Systems](qa-evented-framework.md)
* [Notification](notification-practices.md)
* [An Agile-practice framework (SAFE-like)](agile-planning-practices.md)
* [Types of Agile Charters](agile-charter-types.md)
* [Tooling Configs for Agile Systems](agile-configuration.md)
* [Anti-patterns](agile-anti-patterns.md)
* [Responding to Incidents](incident-response.md)

### Data
* [Anatomy of BI Systems](bi-anatomy-best-practices.md)
* [Naming Conventions for Data Warehouses](data-warehouse-naming-conventions.md)
* [Data Security Guidance](data-security.md)
* [Data Classification and Management](data-classification.md)

### Business Systems
* [Vendor Lifecycle steps](vendor-lifecycle.md)
* [Notes on Managing Partner Relations](partners-and-accounts.md)
* [Meditations on Business Continuity](business-continuity.md)
* [BC / DR Roadmap](business-continuity-disaster-recovery-roadmap.md)


### Teams
* [Onboarding and Ohana](onboarding.md)
* [Coaching Near and Far](career-coaching-training.md)
* [The Structure of Data Science functions](data-science.md)
* [Distributed Teams & Remote Work](remote-work.md)


### Hiring
* [Interviewing](interviewing.md)
* [2-Way Questions in an Interview](interviewing-two-way-questions.md)
* [IP Agreements](ip-agreements.md)
* [Hiring practices](hiring.md)
* [Career Growth](career-ladder.md)



### Personal Style

* [Meetings](questions-and-answers/personal-inventory.md)
* [Common Q&A](questions-and-answers/eng-leadership-questions-answers.md)
* [IDE challenges](ide-anatomy.md)

## The Roadmap

Not everything on here should ever be practiced at the same time.  Each route represents a course toward quality.  

![](assets/Agile-Underground.jpg)

## Contributing

* [Code of Conduct](CODE_OF_CONDUCT.md)
* [Contributing](CONTRIBUTING.md)

Welcome to reach out with thoughts.


Thanks!

<a href="https://stackexchange.com/users/97237"><img src="https://stackexchange.com/users/flair/97237.png" width="208" height="58" alt="profile for New Alexandria on Stack Exchange, a network of free, community-driven Q&amp;A sites" title="profile for New Alexandria on Stack Exchange, a network of free, community-driven Q&amp;A sites"></a>