//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_dyn_slice_ref.py and regenerate this file.
//
// To regenerate:
//
//   $ cd <ngraph source dir>/test
//   $ ./update_dyn_slice_reference.sh
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
//
// clang-format off

#include <algorithm>
#include <cmath>

#include "gtest/gtest.h"

#include "ngraph/ngraph.hpp"
#include "util/test_tools.hpp"
#include "util/autodiff/numeric_compare.hpp"
#include "util/all_close_f.hpp"
#include "util/test_control.hpp"

using namespace std;
using namespace ngraph;

static string s_manifest = "${MANIFEST}";

namespace
{
    template <typename T>
    void check_failure(const element::Type& input_element_type,
                    const Shape& input_shape,
                    const std::vector<int64_t>& lb_values,
                    const std::vector<int64_t>& ub_values,
                    const std::vector<int64_t>& strides_values,
                    const AxisSet& lb_mask,
                    const AxisSet& ub_mask,
                    const AxisSet& new_mask,
                    const AxisSet& shrink_mask,
                    const AxisSet& ellipsis_mask)
    {
        auto arg = std::make_shared<op::v0::Parameter>(input_element_type, input_shape);
        auto lb = std::make_shared<op::v0::Parameter>(element::i64, Shape{lb_values.size()});
        auto ub = std::make_shared<op::v0::Parameter>(element::i64, Shape{ub_values.size()});
        auto strides = std::make_shared<op::v0::Parameter>(element::i64, Shape{strides_values.size()});

        std::vector<T> input_values(shape_size(input_shape));
        std::iota(input_values.begin(), input_values.end(), static_cast<T>(0));

        auto slice = std::make_shared<op::v0::DynSlice>(
            arg, lb, ub, strides, lb_mask, ub_mask, new_mask, shrink_mask, ellipsis_mask);

        auto f = std::make_shared<Function>(OutputVector{slice}, ParameterVector{arg, lb, ub, strides});

        auto backend = runtime::Backend::create("${BACKEND_NAME}", true);
        auto ex = backend->compile(f);

        auto input_arg = backend->create_tensor(input_element_type, input_shape);
        auto input_lb = backend->create_tensor(element::i64, Shape{lb_values.size()});
        auto input_ub = backend->create_tensor(element::i64, Shape{ub_values.size()});
        auto input_strides = backend->create_tensor(element::i64, Shape{strides_values.size()});
        copy_data(input_arg, input_values);
        copy_data(input_lb, lb_values);
        copy_data(input_ub, ub_values);
        copy_data(input_strides, strides_values);

        auto output = backend->create_dynamic_tensor(input_element_type, PartialShape::dynamic());

        try
        {
            ex->call_with_validate({output}, {input_arg, input_lb, input_ub, input_strides});
            FAIL() << "No exception thrown";
        }
        catch (exception& err)
        {
            string s = err.what();
            s = s.substr(0, 5);
            if (s != "Check")
            {
                auto p = std::current_exception();
                rethrow_exception(p);
            }
        }
    }

    template <typename T>
    void check_success(const element::Type& input_element_type,
                    const Shape& input_shape,
                    const std::vector<int64_t>& lb_values,
                    const std::vector<int64_t>& ub_values,
                    const std::vector<int64_t>& strides_values,
                    const AxisSet& lb_mask,
                    const AxisSet& ub_mask,
                    const AxisSet& new_mask,
                    const AxisSet& shrink_mask,
                    const AxisSet& ellipsis_mask,
                    const Shape& expected_output_shape,
                    const std::vector<T>& expected_values)
    {
        auto arg = std::make_shared<op::v0::Parameter>(input_element_type, input_shape);
        auto lb = std::make_shared<op::v0::Parameter>(element::i64, Shape{lb_values.size()});
        auto ub = std::make_shared<op::v0::Parameter>(element::i64, Shape{ub_values.size()});
        auto strides = std::make_shared<op::v0::Parameter>(element::i64, Shape{strides_values.size()});

        std::vector<T> input_values(shape_size(input_shape));
        std::iota(input_values.begin(), input_values.end(), static_cast<T>(0));

        auto slice = std::make_shared<op::v0::DynSlice>(
            arg, lb, ub, strides, lb_mask, ub_mask, new_mask, shrink_mask, ellipsis_mask);

        auto f = std::make_shared<Function>(OutputVector{slice}, ParameterVector{arg, lb, ub, strides});

        auto backend = runtime::Backend::create("${BACKEND_NAME}", true);
        auto ex = backend->compile(f);

        auto input_arg = backend->create_tensor(input_element_type, input_shape);
        auto input_lb = backend->create_tensor(element::i64, Shape{lb_values.size()});
        auto input_ub = backend->create_tensor(element::i64, Shape{ub_values.size()});
        auto input_strides = backend->create_tensor(element::i64, Shape{strides_values.size()});
        copy_data(input_arg, input_values);
        copy_data(input_lb, lb_values);
        copy_data(input_ub, ub_values);
        copy_data(input_strides, strides_values);

        auto output = backend->create_dynamic_tensor(input_element_type, PartialShape::dynamic());

        ex->call_with_validate({output}, {input_arg, input_lb, input_ub, input_strides});

        EXPECT_EQ(output->get_element_type(), input_element_type);
        EXPECT_EQ(output->get_shape(), expected_output_shape);

        auto output_values = read_vector<T>(output);

        EXPECT_EQ(output_values, expected_values);
    }
}

// slices are: [newaxis,3:0:-1]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{1,3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_0)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{0,3},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,3},
                  std::vector<int32_t>{3,2,1});
}

// slices are: [...]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_1)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  Shape{4},
                  std::vector<int32_t>{0,1,2,3});
}

// slices are: [1:3]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_2)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{1,2});
}

// slices are: [2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_3)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  Shape{},
                  std::vector<int32_t>{2});
}

// slices are: [3:0:-2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_4)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{3,1});
}

// slices are: [3::-2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_5)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{3,1});
}

// slices are: [4::-2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_6)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{3,1});
}

// slices are: [5::-2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_7)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{3,1});
}

// slices are: [-9000:-8000:2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_8)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{-8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int32_t>{});
}

// slices are: [-9000:8000:2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_9)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{0,2});
}

// slices are: [-5:5:2]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_10)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{0,2});
}

// slices are: [newaxis]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_11)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,4},
                  std::vector<int32_t>{0,1,2,3});
}

// slices are: [newaxis,newaxis]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{1,1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_12)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,1,4},
                  std::vector<int32_t>{0,1,2,3});
}

// slices are: [newaxis,newaxis,...,newaxis]
// dtype is: int32
// input shape is: Shape{4}
// expected output shape is Shape{1,1,4,1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_13)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{4},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{1,1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1,3},
                  AxisSet{},
                  AxisSet{2},
                  Shape{1,1,4,1},
                  std::vector<int32_t>{0,1,2,3});
}

// slices are: [3:0:-2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_14)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{3,1});
}

// slices are: [0:3:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_15)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{0,2});
}

// slices are: [0:4:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_16)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{0,2});
}

// slices are: [0:5:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_17)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{0,2,4});
}

// slices are: [0:6:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_18)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{0,2,4});
}

// slices are: [0:100:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_19)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{100},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{0,2,4});
}

// slices are: [4:0:-2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_20)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{4,2});
}

// slices are: [4:0:-3]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_21)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{4,1});
}

// slices are: [3:2:1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_22)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int32_t>{});
}

// slices are: [4::-2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_23)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{4,2,0});
}

// slices are: [1:-5:-1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_24)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int32_t>{1});
}

// slices are: [1:-1:-1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_25)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int32_t>{});
}

// slices are: [1:]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_26)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<int32_t>{1,2,3,4});
}

// slices are: [1::-1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_27)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{1,0});
}

// slices are: [-5:5:2]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_28)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{0,2,4});
}

// slices are: [-1:5:1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_29)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int32_t>{4});
}

// slices are: [-1:1:1]
// dtype is: int32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_30)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int32_t>{});
}

// slices are: [5:2:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_31)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int32_t>{5});
}

// slices are: [5:1:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_32)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{5,2});
}

// slices are: [5:0:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_33)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{5,2});
}

// slices are: [5::-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_34)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{5,2});
}

// slices are: [6:3:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_35)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int32_t>{6});
}

// slices are: [6:2:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_36)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{6,3});
}

// slices are: [6:1:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_37)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{6,3});
}

// slices are: [6::-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_38)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{6,3,0});
}

// slices are: [7:1:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_39)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int32_t>{7,4});
}

// slices are: [7:0:-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_40)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{7,4,1});
}

// slices are: [7::-3]
// dtype is: int32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_41)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int32_t>{7,4,1});
}

// slices are: [newaxis,3:0:-1]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1,3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_42)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{0,3},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,3},
                  std::vector<int64_t>{3,2,1});
}

// slices are: [...]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_43)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  Shape{8},
                  std::vector<int64_t>{0,1,2,3,4,5,6,7});
}

// slices are: [1:3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_44)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{1,2});
}

// slices are: [2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_45)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  Shape{},
                  std::vector<int64_t>{2});
}

// slices are: [3:0:-2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_46)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{3,1});
}

// slices are: [3::-2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_47)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{3,1});
}

// slices are: [4::-2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_48)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{4,2,0});
}

// slices are: [5::-2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_49)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{5,3,1});
}

// slices are: [-9000:-8000:2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_50)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{-8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int64_t>{});
}

// slices are: [-9000:8000:2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_51)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<int64_t>{0,2,4,6});
}

// slices are: [-5:5:2]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_52)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int64_t>{3});
}

// slices are: [newaxis]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_53)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,8},
                  std::vector<int64_t>{0,1,2,3,4,5,6,7});
}

// slices are: [newaxis,newaxis]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_54)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,1,8},
                  std::vector<int64_t>{0,1,2,3,4,5,6,7});
}

// slices are: [newaxis,newaxis,...,newaxis]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8,1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_55)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{1,1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1,3},
                  AxisSet{},
                  AxisSet{2},
                  Shape{1,1,8,1},
                  std::vector<int64_t>{0,1,2,3,4,5,6,7});
}

// slices are: [3:0:-2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_56)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{3,1});
}

// slices are: [0:3:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_57)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{0,2});
}

// slices are: [0:4:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_58)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{0,2});
}

// slices are: [0:5:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_59)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{0,2,4});
}

// slices are: [0:6:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_60)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{0,2,4});
}

// slices are: [0:100:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_61)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{100},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{0,2,4});
}

// slices are: [4:0:-2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_62)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{4,2});
}

// slices are: [4:0:-3]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_63)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{4,1});
}

// slices are: [3:2:1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_64)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int64_t>{});
}

// slices are: [4::-2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_65)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{4,2,0});
}

// slices are: [1:-5:-1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_66)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int64_t>{1});
}

// slices are: [1:-1:-1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_67)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int64_t>{});
}

// slices are: [1:]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_68)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<int64_t>{1,2,3,4});
}

// slices are: [1::-1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_69)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{1,0});
}

// slices are: [-5:5:2]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_70)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{0,2,4});
}

// slices are: [-1:5:1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_71)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int64_t>{4});
}

// slices are: [-1:1:1]
// dtype is: int64
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_72)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<int64_t>{});
}

// slices are: [5:2:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_73)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int64_t>{5});
}

// slices are: [5:1:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_74)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{5,2});
}

// slices are: [5:0:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_75)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{5,2});
}

// slices are: [5::-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_76)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{5,2});
}

// slices are: [6:3:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_77)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<int64_t>{6});
}

// slices are: [6:2:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_78)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{6,3});
}

// slices are: [6:1:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_79)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{6,3});
}

// slices are: [6::-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_80)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{6,3,0});
}

// slices are: [7:1:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_81)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<int64_t>{7,4});
}

// slices are: [7:0:-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_82)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{7,4,1});
}

// slices are: [7::-3]
// dtype is: int64
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_83)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<int64_t>{7,4,1});
}

// slices are: [newaxis,3:0:-1]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1,3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_84)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{0,3},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,3},
                  std::vector<float>{3.0,2.0,1.0});
}

// slices are: [...]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_85)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  Shape{8},
                  std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0});
}

// slices are: [1:3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_86)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{1.0,2.0});
}

// slices are: [2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_87)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  Shape{},
                  std::vector<float>{2.0});
}

// slices are: [3:0:-2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_88)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{3.0,1.0});
}

// slices are: [3::-2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_89)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{3.0,1.0});
}

// slices are: [4::-2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_90)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{4.0,2.0,0.0});
}

// slices are: [5::-2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_91)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{5.0,3.0,1.0});
}

// slices are: [-9000:-8000:2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_92)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{-8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<float>{});
}

// slices are: [-9000:8000:2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_93)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<float>{0.0,2.0,4.0,6.0});
}

// slices are: [-5:5:2]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_94)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<float>{3.0});
}

// slices are: [newaxis]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_95)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,8},
                  std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0});
}

// slices are: [newaxis,newaxis]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_96)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,1,8},
                  std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0});
}

// slices are: [newaxis,newaxis,...,newaxis]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8,1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_97)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{1,1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1,3},
                  AxisSet{},
                  AxisSet{2},
                  Shape{1,1,8,1},
                  std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0});
}

// slices are: [3:0:-2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_98)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{3.0,1.0});
}

// slices are: [0:3:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_99)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{0.0,2.0});
}

// slices are: [0:4:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_100)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{0.0,2.0});
}

// slices are: [0:5:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_101)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{0.0,2.0,4.0});
}

// slices are: [0:6:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_102)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{0.0,2.0,4.0});
}

// slices are: [0:100:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_103)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{100},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{0.0,2.0,4.0});
}

// slices are: [4:0:-2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_104)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{4.0,2.0});
}

// slices are: [4:0:-3]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_105)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{4.0,1.0});
}

// slices are: [3:2:1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_106)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<float>{});
}

// slices are: [4::-2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_107)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{4.0,2.0,0.0});
}

// slices are: [1:-5:-1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_108)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<float>{1.0});
}

// slices are: [1:-1:-1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_109)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<float>{});
}

// slices are: [1:]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_110)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<float>{1.0,2.0,3.0,4.0});
}

// slices are: [1::-1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_111)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{1.0,0.0});
}

// slices are: [-5:5:2]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_112)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{0.0,2.0,4.0});
}

// slices are: [-1:5:1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_113)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<float>{4.0});
}

// slices are: [-1:1:1]
// dtype is: float32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_114)
{
    check_success<float>
                 (element::f32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<float>{});
}

// slices are: [5:2:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_115)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<float>{5.0});
}

// slices are: [5:1:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_116)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{5.0,2.0});
}

// slices are: [5:0:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_117)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{5.0,2.0});
}

// slices are: [5::-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_118)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{5.0,2.0});
}

// slices are: [6:3:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_119)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<float>{6.0});
}

// slices are: [6:2:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_120)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{6.0,3.0});
}

// slices are: [6:1:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_121)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{6.0,3.0});
}

// slices are: [6::-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_122)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{6.0,3.0,0.0});
}

// slices are: [7:1:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_123)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<float>{7.0,4.0});
}

// slices are: [7:0:-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_124)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{7.0,4.0,1.0});
}

// slices are: [7::-3]
// dtype is: float32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_125)
{
    check_success<float>
                 (element::f32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<float>{7.0,4.0,1.0});
}

// slices are: [newaxis,3:0:-1]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1,3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_126)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{0,3},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,3},
                  std::vector<uint32_t>{3,2,1});
}

// slices are: [...]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_127)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  Shape{8},
                  std::vector<uint32_t>{0,1,2,3,4,5,6,7});
}

// slices are: [1:3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_128)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{1,2});
}

// slices are: [2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_129)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  Shape{},
                  std::vector<uint32_t>{2});
}

// slices are: [3:0:-2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_130)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{3,1});
}

// slices are: [3::-2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_131)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{3,1});
}

// slices are: [4::-2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_132)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{4,2,0});
}

// slices are: [5::-2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_133)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{5,3,1});
}

// slices are: [-9000:-8000:2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_134)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{-8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<uint32_t>{});
}

// slices are: [-9000:8000:2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_135)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{-9000},
                  std::vector<int64_t>{8000},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<uint32_t>{0,2,4,6});
}

// slices are: [-5:5:2]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_136)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<uint32_t>{3});
}

// slices are: [newaxis]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_137)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,8},
                  std::vector<uint32_t>{0,1,2,3,4,5,6,7});
}

// slices are: [newaxis,newaxis]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_138)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1},
                  AxisSet{},
                  AxisSet{},
                  Shape{1,1,8},
                  std::vector<uint32_t>{0,1,2,3,4,5,6,7});
}

// slices are: [newaxis,newaxis,...,newaxis]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1,1,8,1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_139)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{0,0,0,0},
                  std::vector<int64_t>{1,1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1,3},
                  AxisSet{},
                  AxisSet{2},
                  Shape{1,1,8,1},
                  std::vector<uint32_t>{0,1,2,3,4,5,6,7});
}

// slices are: [3:0:-2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_140)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{3,1});
}

// slices are: [0:3:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_141)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{0,2});
}

// slices are: [0:4:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_142)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{0,2});
}

// slices are: [0:5:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_143)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{0,2,4});
}

// slices are: [0:6:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_144)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{0,2,4});
}

// slices are: [0:100:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_145)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{100},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{0,2,4});
}

// slices are: [4:0:-2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_146)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{4,2});
}

// slices are: [4:0:-3]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_147)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{4,1});
}

// slices are: [3:2:1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_148)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<uint32_t>{});
}

// slices are: [4::-2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_149)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{4},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-2},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{4,2,0});
}

// slices are: [1:-5:-1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_150)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<uint32_t>{1});
}

// slices are: [1:-1:-1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_151)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<uint32_t>{});
}

// slices are: [1:]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_152)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{4},
                  std::vector<uint32_t>{1,2,3,4});
}

// slices are: [1::-1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_153)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-1},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{1,0});
}

// slices are: [-5:5:2]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_154)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{-5},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{0,2,4});
}

// slices are: [-1:5:1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_155)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<uint32_t>{4});
}

// slices are: [-1:1:1]
// dtype is: uint32
// input shape is: Shape{5}
// expected output shape is Shape{0}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_156)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{5},
                  std::vector<int64_t>{-1},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{0},
                  std::vector<uint32_t>{});
}

// slices are: [5:2:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_157)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<uint32_t>{5});
}

// slices are: [5:1:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_158)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{5,2});
}

// slices are: [5:0:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_159)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{5,2});
}

// slices are: [5::-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_160)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{5},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{5,2});
}

// slices are: [6:3:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{1}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_161)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{3},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{1},
                  std::vector<uint32_t>{6});
}

// slices are: [6:2:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_162)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{6,3});
}

// slices are: [6:1:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_163)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{6,3});
}

// slices are: [6::-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_164)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{6},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{6,3,0});
}

// slices are: [7:1:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_165)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{2},
                  std::vector<uint32_t>{7,4});
}

// slices are: [7:0:-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_166)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{7,4,1});
}

// slices are: [7::-3]
// dtype is: uint32
// input shape is: Shape{8}
// expected output shape is Shape{3}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_167)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{8},
                  std::vector<int64_t>{7},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{-3},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  Shape{3},
                  std::vector<uint32_t>{7,4,1});
}

// slices are: [80000]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_168)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{80000},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{});
}

// slices are: [-80000]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_169)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{-80000},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0},
                  AxisSet{});
}

// slices are: [:,:]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_170)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{0,1},
                  AxisSet{0,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{});
}

// slices are: [0:0:0]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_171)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{});
}

// slices are: [0:1:0]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_172)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{1},
                  std::vector<int64_t>{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{});
}

// slices are: [0:2:0]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_173)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{2},
                  std::vector<int64_t>{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{});
}

// slices are: [::0]
// dtype is: int32
// input shape is: Shape{8}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_174)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{8},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  std::vector<int64_t>{0},
                  AxisSet{0},
                  AxisSet{0},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{});
}

// slices are: [1,newaxis]
// dtype is: int32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,3,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_175)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{2,3,4},
                  std::vector<int64_t>{1,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{},
                  Shape{1,3,4},
                  std::vector<int32_t>{12,13,14,15,16,17,18,19,20,21,22,23});
}

// slices are: [-1,-1,newaxis]
// dtype is: int32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_176)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{2,3,4},
                  std::vector<int64_t>{-1,-1,0},
                  std::vector<int64_t>{0,0,0},
                  std::vector<int64_t>{1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{2},
                  AxisSet{0,1},
                  AxisSet{},
                  Shape{1,4},
                  std::vector<int32_t>{20,21,22,23});
}

// slices are: [1,newaxis]
// dtype is: int64
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,3,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_177)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{2,3,4},
                  std::vector<int64_t>{1,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{},
                  Shape{1,3,4},
                  std::vector<int64_t>{12,13,14,15,16,17,18,19,20,21,22,23});
}

// slices are: [-1,-1,newaxis]
// dtype is: int64
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_178)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{2,3,4},
                  std::vector<int64_t>{-1,-1,0},
                  std::vector<int64_t>{0,0,0},
                  std::vector<int64_t>{1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{2},
                  AxisSet{0,1},
                  AxisSet{},
                  Shape{1,4},
                  std::vector<int64_t>{20,21,22,23});
}

// slices are: [1,newaxis]
// dtype is: float32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,3,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_179)
{
    check_success<float>
                 (element::f32,
                  Shape{2,3,4},
                  std::vector<int64_t>{1,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{},
                  Shape{1,3,4},
                  std::vector<float>{12.0,13.0,14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,22.0,23.0});
}

// slices are: [-1,-1,newaxis]
// dtype is: float32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_180)
{
    check_success<float>
                 (element::f32,
                  Shape{2,3,4},
                  std::vector<int64_t>{-1,-1,0},
                  std::vector<int64_t>{0,0,0},
                  std::vector<int64_t>{1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{2},
                  AxisSet{0,1},
                  AxisSet{},
                  Shape{1,4},
                  std::vector<float>{20.0,21.0,22.0,23.0});
}

// slices are: [1,newaxis]
// dtype is: uint32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,3,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_181)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{2,3,4},
                  std::vector<int64_t>{1,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{},
                  Shape{1,3,4},
                  std::vector<uint32_t>{12,13,14,15,16,17,18,19,20,21,22,23});
}

// slices are: [-1,-1,newaxis]
// dtype is: uint32
// input shape is: Shape{2,3,4}
// expected output shape is Shape{1,4}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_182)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{2,3,4},
                  std::vector<int64_t>{-1,-1,0},
                  std::vector<int64_t>{0,0,0},
                  std::vector<int64_t>{1,1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{2},
                  AxisSet{0,1},
                  AxisSet{},
                  Shape{1,4},
                  std::vector<uint32_t>{20,21,22,23});
}

// slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
// dtype is: int32
// input shape is: Shape{2,4,6,8,2,2,2}
// expected output shape is Shape{2,4,2,2,1,2,2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_183)
{
    check_success<int32_t>
                 (element::i32,
                  Shape{2,4,6,8,2,2,2},
                  std::vector<int64_t>{0,0,2,7,0,0,1},
                  std::vector<int64_t>{0,4,6,3,0,0,0},
                  std::vector<int64_t>{1,1,2,-2,1,1,1},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{4},
                  AxisSet{6},
                  AxisSet{5},
                  Shape{2,4,2,2,1,2,2},
                  std::vector<int32_t>{185,187,189,191,169,171,173,175,313,315,317,319,297,299,301,303,569,571,573,575,553,555,557,559,697,699,701,703,681,683,685,687,953,955,957,959,937,939,941,943,1081,1083,1085,1087,1065,1067,1069,1071,1337,1339,1341,1343,1321,1323,1325,1327,1465,1467,1469,1471,1449,1451,1453,1455,1721,1723,1725,1727,1705,1707,1709,1711,1849,1851,1853,1855,1833,1835,1837,1839,2105,2107,2109,2111,2089,2091,2093,2095,2233,2235,2237,2239,2217,2219,2221,2223,2489,2491,2493,2495,2473,2475,2477,2479,2617,2619,2621,2623,2601,2603,2605,2607,2873,2875,2877,2879,2857,2859,2861,2863,3001,3003,3005,3007,2985,2987,2989,2991});
}

// slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
// dtype is: int64
// input shape is: Shape{2,4,6,8,2,2,2}
// expected output shape is Shape{2,4,2,2,1,2,2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_184)
{
    check_success<int64_t>
                 (element::i64,
                  Shape{2,4,6,8,2,2,2},
                  std::vector<int64_t>{0,0,2,7,0,0,1},
                  std::vector<int64_t>{0,4,6,3,0,0,0},
                  std::vector<int64_t>{1,1,2,-2,1,1,1},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{4},
                  AxisSet{6},
                  AxisSet{5},
                  Shape{2,4,2,2,1,2,2},
                  std::vector<int64_t>{185,187,189,191,169,171,173,175,313,315,317,319,297,299,301,303,569,571,573,575,553,555,557,559,697,699,701,703,681,683,685,687,953,955,957,959,937,939,941,943,1081,1083,1085,1087,1065,1067,1069,1071,1337,1339,1341,1343,1321,1323,1325,1327,1465,1467,1469,1471,1449,1451,1453,1455,1721,1723,1725,1727,1705,1707,1709,1711,1849,1851,1853,1855,1833,1835,1837,1839,2105,2107,2109,2111,2089,2091,2093,2095,2233,2235,2237,2239,2217,2219,2221,2223,2489,2491,2493,2495,2473,2475,2477,2479,2617,2619,2621,2623,2601,2603,2605,2607,2873,2875,2877,2879,2857,2859,2861,2863,3001,3003,3005,3007,2985,2987,2989,2991});
}

// slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
// dtype is: float32
// input shape is: Shape{2,4,6,8,2,2,2}
// expected output shape is Shape{2,4,2,2,1,2,2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_185)
{
    check_success<float>
                 (element::f32,
                  Shape{2,4,6,8,2,2,2},
                  std::vector<int64_t>{0,0,2,7,0,0,1},
                  std::vector<int64_t>{0,4,6,3,0,0,0},
                  std::vector<int64_t>{1,1,2,-2,1,1,1},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{4},
                  AxisSet{6},
                  AxisSet{5},
                  Shape{2,4,2,2,1,2,2},
                  std::vector<float>{185.0,187.0,189.0,191.0,169.0,171.0,173.0,175.0,313.0,315.0,317.0,319.0,297.0,299.0,301.0,303.0,569.0,571.0,573.0,575.0,553.0,555.0,557.0,559.0,697.0,699.0,701.0,703.0,681.0,683.0,685.0,687.0,953.0,955.0,957.0,959.0,937.0,939.0,941.0,943.0,1081.0,1083.0,1085.0,1087.0,1065.0,1067.0,1069.0,1071.0,1337.0,1339.0,1341.0,1343.0,1321.0,1323.0,1325.0,1327.0,1465.0,1467.0,1469.0,1471.0,1449.0,1451.0,1453.0,1455.0,1721.0,1723.0,1725.0,1727.0,1705.0,1707.0,1709.0,1711.0,1849.0,1851.0,1853.0,1855.0,1833.0,1835.0,1837.0,1839.0,2105.0,2107.0,2109.0,2111.0,2089.0,2091.0,2093.0,2095.0,2233.0,2235.0,2237.0,2239.0,2217.0,2219.0,2221.0,2223.0,2489.0,2491.0,2493.0,2495.0,2473.0,2475.0,2477.0,2479.0,2617.0,2619.0,2621.0,2623.0,2601.0,2603.0,2605.0,2607.0,2873.0,2875.0,2877.0,2879.0,2857.0,2859.0,2861.0,2863.0,3001.0,3003.0,3005.0,3007.0,2985.0,2987.0,2989.0,2991.0});
}

// slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
// dtype is: uint32
// input shape is: Shape{2,4,6,8,2,2,2}
// expected output shape is Shape{2,4,2,2,1,2,2}
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_186)
{
    check_success<uint32_t>
                 (element::u32,
                  Shape{2,4,6,8,2,2,2},
                  std::vector<int64_t>{0,0,2,7,0,0,1},
                  std::vector<int64_t>{0,4,6,3,0,0,0},
                  std::vector<int64_t>{1,1,2,-2,1,1,1},
                  AxisSet{1},
                  AxisSet{0},
                  AxisSet{4},
                  AxisSet{6},
                  AxisSet{5},
                  Shape{2,4,2,2,1,2,2},
                  std::vector<uint32_t>{185,187,189,191,169,171,173,175,313,315,317,319,297,299,301,303,569,571,573,575,553,555,557,559,697,699,701,703,681,683,685,687,953,955,957,959,937,939,941,943,1081,1083,1085,1087,1065,1067,1069,1071,1337,1339,1341,1343,1321,1323,1325,1327,1465,1467,1469,1471,1449,1451,1453,1455,1721,1723,1725,1727,1705,1707,1709,1711,1849,1851,1853,1855,1833,1835,1837,1839,2105,2107,2109,2111,2089,2091,2093,2095,2233,2235,2237,2239,2217,2219,2221,2223,2489,2491,2493,2495,2473,2475,2477,2479,2617,2619,2621,2623,2601,2603,2605,2607,2873,2875,2877,2879,2857,2859,2861,2863,3001,3003,3005,3007,2985,2987,2989,2991});
}

// slices are: [...,...]
// dtype is: int32
// input shape is: Shape{2,4,6,8,2,2,2}
// failure is expected
NGRAPH_TEST(${BACKEND_NAME}, dyn_slice_187)
{
    check_failure<int32_t>
                 (element::i32,
                  Shape{2,4,6,8,2,2,2},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{0,0},
                  std::vector<int64_t>{1,1},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{},
                  AxisSet{0,1});
}
// clang-format on
