//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_dyn_replace_slice_ref.py and regenerate this file.
//
// To regenerate:
//
//   $ cd <ngraph source dir>/test
//   $ ./update_dyn_replace_slice_reference.sh
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
//
// clang-format off

#include <algorithm>
#include <cmath>

#include "gtest/gtest.h"

#include "ngraph/ngraph.hpp"
#include "util/test_tools.hpp"
#include "util/autodiff/numeric_compare.hpp"
#include "util/all_close_f.hpp"
#include "util/test_control.hpp"

using namespace std;
using namespace ngraph;

static string s_manifest = "${MANIFEST}";

struct DynReplaceSliceTestParamsBase
{
    bool success;
    element::Type input_element_type;
    element::Type replacement_element_type;
    Shape input_shape;
    Shape replacement_shape;
    vector<int64_t> lb_values;
    vector<int64_t> ub_values;
    vector<int64_t> strides_values;
    AxisSet lb_mask;
    AxisSet ub_mask;
    AxisSet new_mask;
    AxisSet shrink_mask;
    AxisSet ellipsis_mask;

    virtual ~DynReplaceSliceTestParamsBase() {}

    virtual void copy_input_values(const shared_ptr<runtime::Tensor>& input_tensor) = 0;
    virtual void copy_replacement_values(const shared_ptr<runtime::Tensor>& replacement_tensor) = 0;
    virtual void check_result_values(const std::shared_ptr<runtime::Tensor>& output_tensor) = 0;
};

template <typename Tinput,typename Treplacement>
struct DynReplaceSliceTestParams : public DynReplaceSliceTestParamsBase
{
    DynReplaceSliceTestParams(
        bool p_success,
        element::Type p_input_element_type,
        element::Type p_replacement_element_type,
        const Shape& p_input_shape,
        const Shape& p_replacement_shape,
        const vector<int64_t>& p_lb_values,
        const vector<int64_t>& p_ub_values,
        const vector<int64_t>& p_strides_values,
        const AxisSet& p_lb_mask,
        const AxisSet& p_ub_mask,
        const AxisSet& p_new_mask,
        const AxisSet& p_shrink_mask,
        const AxisSet& p_ellipsis_mask,
        const vector<Tinput>& p_expected_result_values,
        const vector<Treplacement>& p_replacement_values)
    {
        success = p_success;
        input_element_type = p_input_element_type;
        replacement_element_type = p_replacement_element_type;
        input_shape = p_input_shape;
        replacement_shape = p_replacement_shape;
        lb_values = p_lb_values;
        ub_values = p_ub_values;
        strides_values = p_strides_values;
        lb_mask = p_lb_mask;
        ub_mask = p_ub_mask;
        new_mask = p_new_mask;
        shrink_mask = p_shrink_mask;
        ellipsis_mask = p_ellipsis_mask;

        expected_result_values = p_expected_result_values;
        replacement_values = p_replacement_values;
    }

    vector<Tinput> expected_result_values;
    vector<Treplacement> replacement_values;

    virtual void copy_input_values(const shared_ptr<runtime::Tensor>& input_tensor) override
    {
        std::vector<Tinput> input_values(shape_size(input_shape));
        std::iota(input_values.begin(), input_values.end(), static_cast<Tinput>(0));
        copy_data(input_tensor, input_values);
    }

    virtual void copy_replacement_values(const shared_ptr<runtime::Tensor>& replacement_tensor) override
    {
        copy_data(replacement_tensor, replacement_values);
    }

    virtual void check_result_values(const std::shared_ptr<runtime::Tensor>& output_tensor) override
    {
        vector<Tinput> result_values = read_vector<Tinput>(output_tensor);
        EXPECT_EQ(result_values, expected_result_values);
    }
};

// We use a shared_ptr here because:
//  (1) we cannot use the objects directly, since DynReplaceSliceTestParamsBase is abstract;
//  (2) we cannot use references or raw pointers, since things won't get freed properly;
//  (3) we cannot use unique_ptr, since gtest requires a copy constructor.
struct DynReplaceSliceTest : ::testing::TestWithParam<shared_ptr<DynReplaceSliceTestParamsBase>>
{
};

NGRAPH_TEST_P(${BACKEND_NAME}, DynReplaceSliceTest, dyn_replace_slice)
{
    std::shared_ptr<DynReplaceSliceTestParamsBase> t = GetParam();

    auto backend = runtime::Backend::create("${BACKEND_NAME}",true);
    auto output = backend->create_dynamic_tensor(t->input_element_type, PartialShape::dynamic());

    auto setup = [&t, &backend, &output]() {
        auto arg = std::make_shared<op::v0::Parameter>(t->input_element_type, t->input_shape);
        auto repl = std::make_shared<op::v0::Parameter>(t->replacement_element_type, t->replacement_shape);
        auto lb = std::make_shared<op::v0::Parameter>(element::i64, Shape{t->lb_values.size()});
        auto ub = std::make_shared<op::v0::Parameter>(element::i64, Shape{t->ub_values.size()});
        auto strides = std::make_shared<op::v0::Parameter>(element::i64, Shape{t->strides_values.size()});

        auto rsl = std::make_shared<op::v0::DynReplaceSlice>(arg, repl,
                                                         lb, ub, strides,
                                                         t->lb_mask, t->ub_mask, t->new_mask,
                                                         t->shrink_mask, t->ellipsis_mask);

        auto f = std::make_shared<Function>(OutputVector{rsl}, ParameterVector{arg, repl, lb, ub, strides});

        auto ex = backend->compile(f);

        auto input_arg = backend->create_tensor(t->input_element_type, t->input_shape);
        auto input_repl = backend->create_tensor(t->replacement_element_type, t->replacement_shape);
        auto input_lb = backend->create_tensor(element::i64, Shape{t->lb_values.size()});
        auto input_ub = backend->create_tensor(element::i64, Shape{t->ub_values.size()});
        auto input_strides = backend->create_tensor(element::i64, Shape{t->strides_values.size()});
        t->copy_input_values(input_arg);
        t->copy_replacement_values(input_repl);
        copy_data(input_lb, t->lb_values);
        copy_data(input_ub, t->ub_values);
        copy_data(input_strides, t->strides_values);

        ex->call_with_validate({output}, {input_arg, input_repl, input_lb, input_ub, input_strides});
    };

    if (t->success)
    {
        setup();
        EXPECT_EQ(output->get_element_type(), t->input_element_type);
        EXPECT_EQ(output->get_shape(), t->input_shape);
        t->check_result_values(output);
    }
    else
    {
        EXPECT_ANY_THROW({
            setup();
        });
    }
}

NGRAPH_INSTANTIATE_TEST_SUITE_P(${BACKEND_NAME},
                                dyn_replace_slice,
                                DynReplaceSliceTest,
                                (::testing::ValuesIn(
                                    std::vector<std::shared_ptr<DynReplaceSliceTestParamsBase>>{
                                        // test 0
                                        // slices are: [newaxis,3:0:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{1,3}
                                        // replacement shape is: Shape{1,3}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{1,3},
                                            std::vector<int64_t>{0,3},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,6,5,4},
                                            std::vector<int32_t>{4,5,6}
                                        ),

                                        // test 1
                                        // slices are: [...]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{4}
                                        // replacement shape is: Shape{4}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{4,5,6,7},
                                            std::vector<int32_t>{4,5,6,7}
                                        ),

                                        // test 2
                                        // slices are: [1:3]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,4,5,3},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 3
                                        // slices are: [2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,4,3},
                                            std::vector<int32_t>{4}
                                        ),

                                        // test 4
                                        // slices are: [3:0:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,5,2,4},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 5
                                        // slices are: [3::-2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,5,2,4},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 6
                                        // slices are: [4::-2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,5,2,4},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 7
                                        // slices are: [5::-2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,5,2,4},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 8
                                        // slices are: [-9000:-8000:2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{0},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{-8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 9
                                        // slices are: [-9000:8000:2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{4,1,5,3},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 10
                                        // slices are: [-5:5:2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2},
                                            std::vector<int64_t>{-5},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{4,1,5,3},
                                            std::vector<int32_t>{4,5}
                                        ),

                                        // test 11
                                        // slices are: [newaxis]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{1,4}
                                        // replacement shape is: Shape{1,4}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{1,4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{4,5,6,7},
                                            std::vector<int32_t>{4,5,6,7}
                                        ),

                                        // test 12
                                        // slices are: [newaxis,newaxis]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{1,1,4}
                                        // replacement shape is: Shape{1,1,4}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{1,1,4},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{4,5,6,7},
                                            std::vector<int32_t>{4,5,6,7}
                                        ),

                                        // test 13
                                        // slices are: [newaxis,newaxis,...,newaxis]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{1,1,4,1}
                                        // replacement shape is: Shape{1,1,4,1}
                                        // expected output shape is Shape{4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{1,1,4,1},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{1,1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1,3},
                                            AxisSet{},
                                            AxisSet{2},
                                            std::vector<int32_t>{4,5,6,7},
                                            std::vector<int32_t>{4,5,6,7}
                                        ),

                                        // test 14
                                        // slices are: [2]
                                        // dtype is: int32
                                        // input shape is: Shape{4}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{2,2}
                                        // failure is expected (slice shape and replacement shape do not match,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{4},
                                            Shape{2,2},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{1,1,1,1}
                                        ),

                                        // test 15
                                        // slices are: [3:0:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,6,2,5,4},
                                            std::vector<int32_t>{5,6}
                                        ),

                                        // test 16
                                        // slices are: [0:3:2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{5,1,6,3,4},
                                            std::vector<int32_t>{5,6}
                                        ),

                                        // test 17
                                        // slices are: [0:4:2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{5,1,6,3,4},
                                            std::vector<int32_t>{5,6}
                                        ),

                                        // test 18
                                        // slices are: [0:5:2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{5,1,6,3,7},
                                            std::vector<int32_t>{5,6,7}
                                        ),

                                        // test 19
                                        // slices are: [0:6:2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{5,1,6,3,7},
                                            std::vector<int32_t>{5,6,7}
                                        ),

                                        // test 20
                                        // slices are: [0:100:2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{100},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{5,1,6,3,7},
                                            std::vector<int32_t>{5,6,7}
                                        ),

                                        // test 21
                                        // slices are: [4:0:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,6,3,5},
                                            std::vector<int32_t>{5,6}
                                        ),

                                        // test 22
                                        // slices are: [4:0:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,6,2,3,5},
                                            std::vector<int32_t>{5,6}
                                        ),

                                        // test 23
                                        // slices are: [3:2:1]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,4},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 24
                                        // slices are: [4::-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{7,1,6,3,5},
                                            std::vector<int32_t>{5,6,7}
                                        ),

                                        // test 25
                                        // slices are: [5:2:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,4,8,6,7},
                                            std::vector<int32_t>{8}
                                        ),

                                        // test 26
                                        // slices are: [5:1:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 27
                                        // slices are: [5:0:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 28
                                        // slices are: [5::-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 29
                                        // slices are: [6:3:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,4,5,8,7},
                                            std::vector<int32_t>{8}
                                        ),

                                        // test 30
                                        // slices are: [6:2:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,9,4,5,8,7},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 31
                                        // slices are: [6:1:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,9,4,5,8,7},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 32
                                        // slices are: [6::-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{10,1,2,9,4,5,8,7},
                                            std::vector<int32_t>{8,9,10}
                                        ),

                                        // test 33
                                        // slices are: [7:1:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,9,5,6,8},
                                            std::vector<int32_t>{8,9}
                                        ),

                                        // test 34
                                        // slices are: [7:0:-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,10,2,3,9,5,6,8},
                                            std::vector<int32_t>{8,9,10}
                                        ),

                                        // test 35
                                        // slices are: [7::-3]
                                        // dtype is: int32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{0,10,2,3,9,5,6,8},
                                            std::vector<int32_t>{8,9,10}
                                        ),

                                        // test 36
                                        // slices are: [newaxis,3:0:-1]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,3}
                                        // replacement shape is: Shape{1,3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1,3},
                                            std::vector<int64_t>{0,3},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,10,9,8,4,5,6,7},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 37
                                        // slices are: [...]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{8}
                                        // replacement shape is: Shape{8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 38
                                        // slices are: [1:3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,8,9,3,4,5,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 39
                                        // slices are: [2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,8,3,4,5,6,7},
                                            std::vector<int64_t>{8}
                                        ),

                                        // test 40
                                        // slices are: [3:0:-2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,9,2,8,4,5,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 41
                                        // slices are: [3::-2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,9,2,8,4,5,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 42
                                        // slices are: [4::-2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{10,1,9,3,8,5,6,7},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 43
                                        // slices are: [5::-2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,10,2,9,4,8,6,7},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 44
                                        // slices are: [-9000:-8000:2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{0},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{-8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4,5,6,7},
                                            std::vector<int64_t>{}
                                        ),

                                        // test 45
                                        // slices are: [-9000:8000:2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{4}
                                        // replacement shape is: Shape{4}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{4},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{8,1,9,3,10,5,11,7},
                                            std::vector<int64_t>{8,9,10,11}
                                        ),

                                        // test 46
                                        // slices are: [-5:5:2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{-5},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,8,4,5,6,7},
                                            std::vector<int64_t>{8}
                                        ),

                                        // test 47
                                        // slices are: [newaxis]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,8}
                                        // replacement shape is: Shape{1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1,8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 48
                                        // slices are: [newaxis,newaxis]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8}
                                        // replacement shape is: Shape{1,1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1,1,8},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 49
                                        // slices are: [newaxis,newaxis,...,newaxis]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8,1}
                                        // replacement shape is: Shape{1,1,8,1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1,1,8,1},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{1,1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1,3},
                                            AxisSet{},
                                            AxisSet{2},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15},
                                            std::vector<int64_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 50
                                        // slices are: [2]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{2,2}
                                        // failure is expected (slice shape and replacement shape do not match,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            false,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2,2},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int64_t>{},
                                            std::vector<int64_t>{1,1,1,1}
                                        ),

                                        // test 51
                                        // slices are: [3:0:-2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,6,2,5,4},
                                            std::vector<int64_t>{5,6}
                                        ),

                                        // test 52
                                        // slices are: [0:3:2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{5,1,6,3,4},
                                            std::vector<int64_t>{5,6}
                                        ),

                                        // test 53
                                        // slices are: [0:4:2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{5,1,6,3,4},
                                            std::vector<int64_t>{5,6}
                                        ),

                                        // test 54
                                        // slices are: [0:5:2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{5,1,6,3,7},
                                            std::vector<int64_t>{5,6,7}
                                        ),

                                        // test 55
                                        // slices are: [0:6:2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{5,1,6,3,7},
                                            std::vector<int64_t>{5,6,7}
                                        ),

                                        // test 56
                                        // slices are: [0:100:2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{100},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{5,1,6,3,7},
                                            std::vector<int64_t>{5,6,7}
                                        ),

                                        // test 57
                                        // slices are: [4:0:-2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,6,3,5},
                                            std::vector<int64_t>{5,6}
                                        ),

                                        // test 58
                                        // slices are: [4:0:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,6,2,3,5},
                                            std::vector<int64_t>{5,6}
                                        ),

                                        // test 59
                                        // slices are: [3:2:1]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4},
                                            std::vector<int64_t>{}
                                        ),

                                        // test 60
                                        // slices are: [4::-2]
                                        // dtype is: int64
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{7,1,6,3,5},
                                            std::vector<int64_t>{5,6,7}
                                        ),

                                        // test 61
                                        // slices are: [5:2:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4,8,6,7},
                                            std::vector<int64_t>{8}
                                        ),

                                        // test 62
                                        // slices are: [5:1:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 63
                                        // slices are: [5:0:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 64
                                        // slices are: [5::-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,9,3,4,8,6,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 65
                                        // slices are: [6:3:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4,5,8,7},
                                            std::vector<int64_t>{8}
                                        ),

                                        // test 66
                                        // slices are: [6:2:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,9,4,5,8,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 67
                                        // slices are: [6:1:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,9,4,5,8,7},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 68
                                        // slices are: [6::-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{10,1,2,9,4,5,8,7},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 69
                                        // slices are: [7:1:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,9,5,6,8},
                                            std::vector<int64_t>{8,9}
                                        ),

                                        // test 70
                                        // slices are: [7:0:-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,10,2,3,9,5,6,8},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 71
                                        // slices are: [7::-3]
                                        // dtype is: int64
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int64_t>{0,10,2,3,9,5,6,8},
                                            std::vector<int64_t>{8,9,10}
                                        ),

                                        // test 72
                                        // slices are: [newaxis,3:0:-1]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,3}
                                        // replacement shape is: Shape{1,3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1,3},
                                            std::vector<int64_t>{0,3},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,10.0,9.0,8.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 73
                                        // slices are: [...]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{8}
                                        // replacement shape is: Shape{8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0}
                                        ),

                                        // test 74
                                        // slices are: [1:3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,8.0,9.0,3.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 75
                                        // slices are: [2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,8.0,3.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0}
                                        ),

                                        // test 76
                                        // slices are: [3:0:-2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,9.0,2.0,8.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 77
                                        // slices are: [3::-2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,9.0,2.0,8.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 78
                                        // slices are: [4::-2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{10.0,1.0,9.0,3.0,8.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 79
                                        // slices are: [5::-2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,10.0,2.0,9.0,4.0,8.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 80
                                        // slices are: [-9000:-8000:2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{0},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{-8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{}
                                        ),

                                        // test 81
                                        // slices are: [-9000:8000:2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{4}
                                        // replacement shape is: Shape{4}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{4},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{8.0,1.0,9.0,3.0,10.0,5.0,11.0,7.0},
                                            std::vector<float>{8.0,9.0,10.0,11.0}
                                        ),

                                        // test 82
                                        // slices are: [-5:5:2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{-5},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,8.0,4.0,5.0,6.0,7.0},
                                            std::vector<float>{8.0}
                                        ),

                                        // test 83
                                        // slices are: [newaxis]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,8}
                                        // replacement shape is: Shape{1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1,8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0}
                                        ),

                                        // test 84
                                        // slices are: [newaxis,newaxis]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8}
                                        // replacement shape is: Shape{1,1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1,1,8},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0}
                                        ),

                                        // test 85
                                        // slices are: [newaxis,newaxis,...,newaxis]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8,1}
                                        // replacement shape is: Shape{1,1,8,1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1,1,8,1},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{1,1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1,3},
                                            AxisSet{},
                                            AxisSet{2},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0},
                                            std::vector<float>{8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0}
                                        ),

                                        // test 86
                                        // slices are: [2]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{2,2}
                                        // failure is expected (slice shape and replacement shape do not match,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            false,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2,2},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<float>{},
                                            std::vector<float>{1.0,1.0,1.0,1.0}
                                        ),

                                        // test 87
                                        // slices are: [3:0:-2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,6.0,2.0,5.0,4.0},
                                            std::vector<float>{5.0,6.0}
                                        ),

                                        // test 88
                                        // slices are: [0:3:2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{5.0,1.0,6.0,3.0,4.0},
                                            std::vector<float>{5.0,6.0}
                                        ),

                                        // test 89
                                        // slices are: [0:4:2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{5.0,1.0,6.0,3.0,4.0},
                                            std::vector<float>{5.0,6.0}
                                        ),

                                        // test 90
                                        // slices are: [0:5:2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{5.0,1.0,6.0,3.0,7.0},
                                            std::vector<float>{5.0,6.0,7.0}
                                        ),

                                        // test 91
                                        // slices are: [0:6:2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{5.0,1.0,6.0,3.0,7.0},
                                            std::vector<float>{5.0,6.0,7.0}
                                        ),

                                        // test 92
                                        // slices are: [0:100:2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{100},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{5.0,1.0,6.0,3.0,7.0},
                                            std::vector<float>{5.0,6.0,7.0}
                                        ),

                                        // test 93
                                        // slices are: [4:0:-2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,6.0,3.0,5.0},
                                            std::vector<float>{5.0,6.0}
                                        ),

                                        // test 94
                                        // slices are: [4:0:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,6.0,2.0,3.0,5.0},
                                            std::vector<float>{5.0,6.0}
                                        ),

                                        // test 95
                                        // slices are: [3:2:1]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0},
                                            std::vector<float>{}
                                        ),

                                        // test 96
                                        // slices are: [4::-2]
                                        // dtype is: float32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{7.0,1.0,6.0,3.0,5.0},
                                            std::vector<float>{5.0,6.0,7.0}
                                        ),

                                        // test 97
                                        // slices are: [5:2:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,8.0,6.0,7.0},
                                            std::vector<float>{8.0}
                                        ),

                                        // test 98
                                        // slices are: [5:1:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,9.0,3.0,4.0,8.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 99
                                        // slices are: [5:0:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,9.0,3.0,4.0,8.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 100
                                        // slices are: [5::-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,9.0,3.0,4.0,8.0,6.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 101
                                        // slices are: [6:3:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,8.0,7.0},
                                            std::vector<float>{8.0}
                                        ),

                                        // test 102
                                        // slices are: [6:2:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,9.0,4.0,5.0,8.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 103
                                        // slices are: [6:1:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,9.0,4.0,5.0,8.0,7.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 104
                                        // slices are: [6::-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{10.0,1.0,2.0,9.0,4.0,5.0,8.0,7.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 105
                                        // slices are: [7:1:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,9.0,5.0,6.0,8.0},
                                            std::vector<float>{8.0,9.0}
                                        ),

                                        // test 106
                                        // slices are: [7:0:-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,10.0,2.0,3.0,9.0,5.0,6.0,8.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 107
                                        // slices are: [7::-3]
                                        // dtype is: float32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<float>{0.0,10.0,2.0,3.0,9.0,5.0,6.0,8.0},
                                            std::vector<float>{8.0,9.0,10.0}
                                        ),

                                        // test 108
                                        // slices are: [newaxis,3:0:-1]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,3}
                                        // replacement shape is: Shape{1,3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1,3},
                                            std::vector<int64_t>{0,3},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,10,9,8,4,5,6,7},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 109
                                        // slices are: [...]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{8}
                                        // replacement shape is: Shape{8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 110
                                        // slices are: [1:3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,8,9,3,4,5,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 111
                                        // slices are: [2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,8,3,4,5,6,7},
                                            std::vector<uint32_t>{8}
                                        ),

                                        // test 112
                                        // slices are: [3:0:-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,9,2,8,4,5,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 113
                                        // slices are: [3::-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,9,2,8,4,5,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 114
                                        // slices are: [4::-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{10,1,9,3,8,5,6,7},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 115
                                        // slices are: [5::-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,10,2,9,4,8,6,7},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 116
                                        // slices are: [-9000:-8000:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{0},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{-8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4,5,6,7},
                                            std::vector<uint32_t>{}
                                        ),

                                        // test 117
                                        // slices are: [-9000:8000:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{4}
                                        // replacement shape is: Shape{4}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{4},
                                            std::vector<int64_t>{-9000},
                                            std::vector<int64_t>{8000},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{8,1,9,3,10,5,11,7},
                                            std::vector<uint32_t>{8,9,10,11}
                                        ),

                                        // test 118
                                        // slices are: [-5:5:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{-5},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,8,4,5,6,7},
                                            std::vector<uint32_t>{8}
                                        ),

                                        // test 119
                                        // slices are: [newaxis]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,8}
                                        // replacement shape is: Shape{1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1,8},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 120
                                        // slices are: [newaxis,newaxis]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8}
                                        // replacement shape is: Shape{1,1,8}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1,1,8},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 121
                                        // slices are: [newaxis,newaxis,...,newaxis]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1,1,8,1}
                                        // replacement shape is: Shape{1,1,8,1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1,1,8,1},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{0,0,0,0},
                                            std::vector<int64_t>{1,1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1,3},
                                            AxisSet{},
                                            AxisSet{2},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15},
                                            std::vector<uint32_t>{8,9,10,11,12,13,14,15}
                                        ),

                                        // test 122
                                        // slices are: [2]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{2,2}
                                        // failure is expected (slice shape and replacement shape do not match,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            false,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2,2},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<uint32_t>{},
                                            std::vector<uint32_t>{1,1,1,1}
                                        ),

                                        // test 123
                                        // slices are: [3:0:-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,6,2,5,4},
                                            std::vector<uint32_t>{5,6}
                                        ),

                                        // test 124
                                        // slices are: [0:3:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{5,1,6,3,4},
                                            std::vector<uint32_t>{5,6}
                                        ),

                                        // test 125
                                        // slices are: [0:4:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{5,1,6,3,4},
                                            std::vector<uint32_t>{5,6}
                                        ),

                                        // test 126
                                        // slices are: [0:5:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{5,1,6,3,7},
                                            std::vector<uint32_t>{5,6,7}
                                        ),

                                        // test 127
                                        // slices are: [0:6:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{5,1,6,3,7},
                                            std::vector<uint32_t>{5,6,7}
                                        ),

                                        // test 128
                                        // slices are: [0:100:2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{100},
                                            std::vector<int64_t>{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{5,1,6,3,7},
                                            std::vector<uint32_t>{5,6,7}
                                        ),

                                        // test 129
                                        // slices are: [4:0:-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,6,3,5},
                                            std::vector<uint32_t>{5,6}
                                        ),

                                        // test 130
                                        // slices are: [4:0:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{2},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,6,2,3,5},
                                            std::vector<uint32_t>{5,6}
                                        ),

                                        // test 131
                                        // slices are: [3:2:1]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{0}
                                        // replacement shape is: Shape{0}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{0},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4},
                                            std::vector<uint32_t>{}
                                        ),

                                        // test 132
                                        // slices are: [4::-2]
                                        // dtype is: uint32
                                        // input shape is: Shape{5}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{5}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{5},
                                            Shape{3},
                                            std::vector<int64_t>{4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-2},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{7,1,6,3,5},
                                            std::vector<uint32_t>{5,6,7}
                                        ),

                                        // test 133
                                        // slices are: [5:2:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4,8,6,7},
                                            std::vector<uint32_t>{8}
                                        ),

                                        // test 134
                                        // slices are: [5:1:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 135
                                        // slices are: [5:0:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 136
                                        // slices are: [5::-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{5},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,9,3,4,8,6,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 137
                                        // slices are: [6:3:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{1}
                                        // replacement shape is: Shape{1}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{1},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{3},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4,5,8,7},
                                            std::vector<uint32_t>{8}
                                        ),

                                        // test 138
                                        // slices are: [6:2:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,9,4,5,8,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 139
                                        // slices are: [6:1:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,9,4,5,8,7},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 140
                                        // slices are: [6::-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{6},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{10,1,2,9,4,5,8,7},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 141
                                        // slices are: [7:1:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{2}
                                        // replacement shape is: Shape{2}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{2},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,9,5,6,8},
                                            std::vector<uint32_t>{8,9}
                                        ),

                                        // test 142
                                        // slices are: [7:0:-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,10,2,3,9,5,6,8},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 143
                                        // slices are: [7::-3]
                                        // dtype is: uint32
                                        // input shape is: Shape{8}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{3}
                                        // expected output shape is Shape{8}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{8},
                                            Shape{3},
                                            std::vector<int64_t>{7},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{-3},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,10,2,3,9,5,6,8},
                                            std::vector<uint32_t>{8,9,10}
                                        ),

                                        // test 144
                                        // slices are: [2:4,...]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{2,5}
                                        // replacement shape is: Shape{2,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{2,5},
                                            std::vector<int64_t>{2,0},
                                            std::vector<int64_t>{4,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,20,21,22,23,24,25,26,27,28,29},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29}
                                        ),

                                        // test 145
                                        // slices are: [4:2,...]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{0,5}
                                        // replacement shape is: Shape{0,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{0,5},
                                            std::vector<int64_t>{4,0},
                                            std::vector<int64_t>{2,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 146
                                        // slices are: [4:2:-3,...]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{1,5}
                                        // replacement shape is: Shape{1,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{1,5},
                                            std::vector<int64_t>{4,0},
                                            std::vector<int64_t>{2,0},
                                            std::vector<int64_t>{-3,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,20,21,22,23,24},
                                            std::vector<int32_t>{20,21,22,23,24}
                                        ),

                                        // test 147
                                        // slices are: [-100:100,...]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{4,5}
                                        // replacement shape is: Shape{4,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{4,5},
                                            std::vector<int64_t>{-100,0},
                                            std::vector<int64_t>{100,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39}
                                        ),

                                        // test 148
                                        // slices are: [...,2:]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{4,3}
                                        // replacement shape is: Shape{4,3}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{4,3},
                                            std::vector<int64_t>{0,2},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{0,1,20,21,22,5,6,23,24,25,10,11,26,27,28,15,16,29,30,31},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31}
                                        ),

                                        // test 149
                                        // slices are: [...,2:4]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{4,2}
                                        // replacement shape is: Shape{4,2}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{4,2},
                                            std::vector<int64_t>{0,2},
                                            std::vector<int64_t>{0,4},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{0,1,20,21,4,5,6,22,23,9,10,11,24,25,14,15,16,26,27,19},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27}
                                        ),

                                        // test 150
                                        // slices are: [...,:]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{4,5}
                                        // replacement shape is: Shape{4,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{4,5},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{1},
                                            AxisSet{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39}
                                        ),

                                        // test 151
                                        // slices are: [...,-100:100]
                                        // dtype is: int32
                                        // input shape is: Shape{4,5}
                                        // slice shape is: Shape{4,5}
                                        // replacement shape is: Shape{4,5}
                                        // expected output shape is Shape{4,5}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{4,5},
                                            Shape{4,5},
                                            std::vector<int64_t>{0,-100},
                                            std::vector<int64_t>{0,100},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39},
                                            std::vector<int32_t>{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39}
                                        ),

                                        // test 152
                                        // slices are: [2:4,...,1:7:3,7:2:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5,6,10,8}
                                        // slice shape is: Shape{2,6,2,3}
                                        // replacement shape is: Shape{2,6,2,3}
                                        // expected output shape is Shape{5,6,10,8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5,6,10,8},
                                            Shape{2,6,2,3},
                                            std::vector<int64_t>{2,0,1,7},
                                            std::vector<int64_t>{4,0,7,2},
                                            std::vector<int64_t>{1,1,3,-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,2402,972,2401,974,2400,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,2405,996,2404,998,2403,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,2408,1052,2407,1054,2406,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,2411,1076,2410,1078,2409,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,2414,1132,2413,1134,2412,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,2417,1156,2416,1158,2415,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,2420,1212,2419,1214,2418,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,2423,1236,2422,1238,2421,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,2426,1292,2425,1294,2424,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,2429,1316,2428,1318,2427,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,2432,1372,2431,1374,2430,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,2435,1396,2434,1398,2433,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,2438,1452,2437,1454,2436,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,2441,1476,2440,1478,2439,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,2444,1532,2443,1534,2442,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,2447,1556,2446,1558,2445,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,2450,1612,2449,1614,2448,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,2453,1636,2452,1638,2451,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,2456,1692,2455,1694,2454,1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,2459,1716,2458,1718,2457,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,2462,1772,2461,1774,2460,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,2465,1796,2464,1798,2463,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,2468,1852,2467,1854,2466,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,2471,1876,2470,1878,2469,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2091,2092,2093,2094,2095,2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399},
                                            std::vector<int32_t>{2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471}
                                        ),

                                        // test 153
                                        // slices are: [...,1:7:3,7:2:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5,6,10,8}
                                        // slice shape is: Shape{5,6,2,3}
                                        // replacement shape is: Shape{5,6,2,3}
                                        // expected output shape is Shape{5,6,10,8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5,6,10,8},
                                            Shape{5,6,2,3},
                                            std::vector<int64_t>{0,1,7},
                                            std::vector<int64_t>{0,7,2},
                                            std::vector<int64_t>{1,3,-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,2402,12,2401,14,2400,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,2405,36,2404,38,2403,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,2408,92,2407,94,2406,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,2411,116,2410,118,2409,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,2414,172,2413,174,2412,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,2417,196,2416,198,2415,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,2420,252,2419,254,2418,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,2423,276,2422,278,2421,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,2426,332,2425,334,2424,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,2429,356,2428,358,2427,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,2432,412,2431,414,2430,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,2435,436,2434,438,2433,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,2438,492,2437,494,2436,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,2441,516,2440,518,2439,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,2444,572,2443,574,2442,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,2447,596,2446,598,2445,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,2450,652,2449,654,2448,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,2453,676,2452,678,2451,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,2456,732,2455,734,2454,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,2459,756,2458,758,2457,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,2462,812,2461,814,2460,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,2465,836,2464,838,2463,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,2468,892,2467,894,2466,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,2471,916,2470,918,2469,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,2474,972,2473,974,2472,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,2477,996,2476,998,2475,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,2480,1052,2479,1054,2478,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,2483,1076,2482,1078,2481,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,2486,1132,2485,1134,2484,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,2489,1156,2488,1158,2487,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,2492,1212,2491,1214,2490,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,2495,1236,2494,1238,2493,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,2498,1292,2497,1294,2496,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,2501,1316,2500,1318,2499,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,2504,1372,2503,1374,2502,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,2507,1396,2506,1398,2505,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,2510,1452,2509,1454,2508,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,2513,1476,2512,1478,2511,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,2516,1532,2515,1534,2514,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,2519,1556,2518,1558,2517,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,2522,1612,2521,1614,2520,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,2525,1636,2524,1638,2523,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,2528,1692,2527,1694,2526,1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,2531,1716,2530,1718,2529,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,2534,1772,2533,1774,2532,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,2537,1796,2536,1798,2535,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,2540,1852,2539,1854,2538,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,2543,1876,2542,1878,2541,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,2546,1932,2545,1934,2544,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,2549,1956,2548,1958,2547,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2552,2012,2551,2014,2550,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2555,2036,2554,2038,2553,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2558,2092,2557,2094,2556,2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,2112,2113,2114,2561,2116,2560,2118,2559,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2564,2172,2563,2174,2562,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2567,2196,2566,2198,2565,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2570,2252,2569,2254,2568,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2573,2276,2572,2278,2571,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2576,2332,2575,2334,2574,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2579,2356,2578,2358,2577,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399},
                                            std::vector<int32_t>{2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471,2472,2473,2474,2475,2476,2477,2478,2479,2480,2481,2482,2483,2484,2485,2486,2487,2488,2489,2490,2491,2492,2493,2494,2495,2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,2544,2545,2546,2547,2548,2549,2550,2551,2552,2553,2554,2555,2556,2557,2558,2559,2560,2561,2562,2563,2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,2576,2577,2578,2579}
                                        ),

                                        // test 154
                                        // slices are: [2:4,...,:3,-3:2:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5,6,10,8}
                                        // slice shape is: Shape{2,6,3,2}
                                        // replacement shape is: Shape{2,6,3,2}
                                        // expected output shape is Shape{5,6,10,8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5,6,10,8},
                                            Shape{2,6,3,2},
                                            std::vector<int64_t>{2,0,0,-3},
                                            std::vector<int64_t>{4,0,3,2},
                                            std::vector<int64_t>{1,1,1,-2},
                                            AxisSet{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,2401,964,2400,966,967,968,969,970,2403,972,2402,974,975,976,977,978,2405,980,2404,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,2407,1044,2406,1046,1047,1048,1049,1050,2409,1052,2408,1054,1055,1056,1057,1058,2411,1060,2410,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,2413,1124,2412,1126,1127,1128,1129,1130,2415,1132,2414,1134,1135,1136,1137,1138,2417,1140,2416,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,2419,1204,2418,1206,1207,1208,1209,1210,2421,1212,2420,1214,1215,1216,1217,1218,2423,1220,2422,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,2425,1284,2424,1286,1287,1288,1289,1290,2427,1292,2426,1294,1295,1296,1297,1298,2429,1300,2428,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,2431,1364,2430,1366,1367,1368,1369,1370,2433,1372,2432,1374,1375,1376,1377,1378,2435,1380,2434,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,2437,1444,2436,1446,1447,1448,1449,1450,2439,1452,2438,1454,1455,1456,1457,1458,2441,1460,2440,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,2443,1524,2442,1526,1527,1528,1529,1530,2445,1532,2444,1534,1535,1536,1537,1538,2447,1540,2446,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,2449,1604,2448,1606,1607,1608,1609,1610,2451,1612,2450,1614,1615,1616,1617,1618,2453,1620,2452,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,2455,1684,2454,1686,1687,1688,1689,1690,2457,1692,2456,1694,1695,1696,1697,1698,2459,1700,2458,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,1715,1716,1717,1718,1719,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,2461,1764,2460,1766,1767,1768,1769,1770,2463,1772,2462,1774,1775,1776,1777,1778,2465,1780,2464,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,2467,1844,2466,1846,1847,1848,1849,1850,2469,1852,2468,1854,1855,1856,1857,1858,2471,1860,2470,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2091,2092,2093,2094,2095,2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399},
                                            std::vector<int32_t>{2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471}
                                        ),

                                        // test 155
                                        // slices are: [2:4,...,1:7:-3,7:2:-2]
                                        // dtype is: int32
                                        // input shape is: Shape{5,6,10,8}
                                        // slice shape is: Shape{2,6,0,3}
                                        // replacement shape is: Shape{2,6,0,3}
                                        // expected output shape is Shape{5,6,10,8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5,6,10,8},
                                            Shape{2,6,0,3},
                                            std::vector<int64_t>{2,0,1,7},
                                            std::vector<int64_t>{4,0,7,2},
                                            std::vector<int64_t>{1,1,-3,-2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,1321,1322,1323,1324,1325,1326,1327,1328,1329,1330,1331,1332,1333,1334,1335,1336,1337,1338,1339,1340,1341,1342,1343,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,1712,1713,1714,1715,1716,1717,1718,1719,1720,1721,1722,1723,1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,1851,1852,1853,1854,1855,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2091,2092,2093,2094,2095,2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 156
                                        // slices are: [2:4,...,:,newaxis,0]
                                        // dtype is: int32
                                        // input shape is: Shape{5,6,10,8}
                                        // slice shape is: Shape{2,6,10,1}
                                        // replacement shape is: Shape{2,6,10,1}
                                        // expected output shape is Shape{5,6,10,8}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{5,6,10,8},
                                            Shape{2,6,10,1},
                                            std::vector<int64_t>{2,0,0,0,0},
                                            std::vector<int64_t>{4,0,0,0,0},
                                            std::vector<int64_t>{1,1,1,1,1},
                                            AxisSet{2},
                                            AxisSet{2},
                                            AxisSet{3},
                                            AxisSet{4},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,937,938,939,940,941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,2400,961,962,963,964,965,966,967,2401,969,970,971,972,973,974,975,2402,977,978,979,980,981,982,983,2403,985,986,987,988,989,990,991,2404,993,994,995,996,997,998,999,2405,1001,1002,1003,1004,1005,1006,1007,2406,1009,1010,1011,1012,1013,1014,1015,2407,1017,1018,1019,1020,1021,1022,1023,2408,1025,1026,1027,1028,1029,1030,1031,2409,1033,1034,1035,1036,1037,1038,1039,2410,1041,1042,1043,1044,1045,1046,1047,2411,1049,1050,1051,1052,1053,1054,1055,2412,1057,1058,1059,1060,1061,1062,1063,2413,1065,1066,1067,1068,1069,1070,1071,2414,1073,1074,1075,1076,1077,1078,1079,2415,1081,1082,1083,1084,1085,1086,1087,2416,1089,1090,1091,1092,1093,1094,1095,2417,1097,1098,1099,1100,1101,1102,1103,2418,1105,1106,1107,1108,1109,1110,1111,2419,1113,1114,1115,1116,1117,1118,1119,2420,1121,1122,1123,1124,1125,1126,1127,2421,1129,1130,1131,1132,1133,1134,1135,2422,1137,1138,1139,1140,1141,1142,1143,2423,1145,1146,1147,1148,1149,1150,1151,2424,1153,1154,1155,1156,1157,1158,1159,2425,1161,1162,1163,1164,1165,1166,1167,2426,1169,1170,1171,1172,1173,1174,1175,2427,1177,1178,1179,1180,1181,1182,1183,2428,1185,1186,1187,1188,1189,1190,1191,2429,1193,1194,1195,1196,1197,1198,1199,2430,1201,1202,1203,1204,1205,1206,1207,2431,1209,1210,1211,1212,1213,1214,1215,2432,1217,1218,1219,1220,1221,1222,1223,2433,1225,1226,1227,1228,1229,1230,1231,2434,1233,1234,1235,1236,1237,1238,1239,2435,1241,1242,1243,1244,1245,1246,1247,2436,1249,1250,1251,1252,1253,1254,1255,2437,1257,1258,1259,1260,1261,1262,1263,2438,1265,1266,1267,1268,1269,1270,1271,2439,1273,1274,1275,1276,1277,1278,1279,2440,1281,1282,1283,1284,1285,1286,1287,2441,1289,1290,1291,1292,1293,1294,1295,2442,1297,1298,1299,1300,1301,1302,1303,2443,1305,1306,1307,1308,1309,1310,1311,2444,1313,1314,1315,1316,1317,1318,1319,2445,1321,1322,1323,1324,1325,1326,1327,2446,1329,1330,1331,1332,1333,1334,1335,2447,1337,1338,1339,1340,1341,1342,1343,2448,1345,1346,1347,1348,1349,1350,1351,2449,1353,1354,1355,1356,1357,1358,1359,2450,1361,1362,1363,1364,1365,1366,1367,2451,1369,1370,1371,1372,1373,1374,1375,2452,1377,1378,1379,1380,1381,1382,1383,2453,1385,1386,1387,1388,1389,1390,1391,2454,1393,1394,1395,1396,1397,1398,1399,2455,1401,1402,1403,1404,1405,1406,1407,2456,1409,1410,1411,1412,1413,1414,1415,2457,1417,1418,1419,1420,1421,1422,1423,2458,1425,1426,1427,1428,1429,1430,1431,2459,1433,1434,1435,1436,1437,1438,1439,2460,1441,1442,1443,1444,1445,1446,1447,2461,1449,1450,1451,1452,1453,1454,1455,2462,1457,1458,1459,1460,1461,1462,1463,2463,1465,1466,1467,1468,1469,1470,1471,2464,1473,1474,1475,1476,1477,1478,1479,2465,1481,1482,1483,1484,1485,1486,1487,2466,1489,1490,1491,1492,1493,1494,1495,2467,1497,1498,1499,1500,1501,1502,1503,2468,1505,1506,1507,1508,1509,1510,1511,2469,1513,1514,1515,1516,1517,1518,1519,2470,1521,1522,1523,1524,1525,1526,1527,2471,1529,1530,1531,1532,1533,1534,1535,2472,1537,1538,1539,1540,1541,1542,1543,2473,1545,1546,1547,1548,1549,1550,1551,2474,1553,1554,1555,1556,1557,1558,1559,2475,1561,1562,1563,1564,1565,1566,1567,2476,1569,1570,1571,1572,1573,1574,1575,2477,1577,1578,1579,1580,1581,1582,1583,2478,1585,1586,1587,1588,1589,1590,1591,2479,1593,1594,1595,1596,1597,1598,1599,2480,1601,1602,1603,1604,1605,1606,1607,2481,1609,1610,1611,1612,1613,1614,1615,2482,1617,1618,1619,1620,1621,1622,1623,2483,1625,1626,1627,1628,1629,1630,1631,2484,1633,1634,1635,1636,1637,1638,1639,2485,1641,1642,1643,1644,1645,1646,1647,2486,1649,1650,1651,1652,1653,1654,1655,2487,1657,1658,1659,1660,1661,1662,1663,2488,1665,1666,1667,1668,1669,1670,1671,2489,1673,1674,1675,1676,1677,1678,1679,2490,1681,1682,1683,1684,1685,1686,1687,2491,1689,1690,1691,1692,1693,1694,1695,2492,1697,1698,1699,1700,1701,1702,1703,2493,1705,1706,1707,1708,1709,1710,1711,2494,1713,1714,1715,1716,1717,1718,1719,2495,1721,1722,1723,1724,1725,1726,1727,2496,1729,1730,1731,1732,1733,1734,1735,2497,1737,1738,1739,1740,1741,1742,1743,2498,1745,1746,1747,1748,1749,1750,1751,2499,1753,1754,1755,1756,1757,1758,1759,2500,1761,1762,1763,1764,1765,1766,1767,2501,1769,1770,1771,1772,1773,1774,1775,2502,1777,1778,1779,1780,1781,1782,1783,2503,1785,1786,1787,1788,1789,1790,1791,2504,1793,1794,1795,1796,1797,1798,1799,2505,1801,1802,1803,1804,1805,1806,1807,2506,1809,1810,1811,1812,1813,1814,1815,2507,1817,1818,1819,1820,1821,1822,1823,2508,1825,1826,1827,1828,1829,1830,1831,2509,1833,1834,1835,1836,1837,1838,1839,2510,1841,1842,1843,1844,1845,1846,1847,2511,1849,1850,1851,1852,1853,1854,1855,2512,1857,1858,1859,1860,1861,1862,1863,2513,1865,1866,1867,1868,1869,1870,1871,2514,1873,1874,1875,1876,1877,1878,1879,2515,1881,1882,1883,1884,1885,1886,1887,2516,1889,1890,1891,1892,1893,1894,1895,2517,1897,1898,1899,1900,1901,1902,1903,2518,1905,1906,1907,1908,1909,1910,1911,2519,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2091,2092,2093,2094,2095,2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399},
                                            std::vector<int32_t>{2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471,2472,2473,2474,2475,2476,2477,2478,2479,2480,2481,2482,2483,2484,2485,2486,2487,2488,2489,2490,2491,2492,2493,2494,2495,2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519}
                                        ),

                                        // test 157
                                        // slices are: [2:6:2,...,:,2:1:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{2,2,3,2,3,3}
                                        // slice shape is: Shape{0,2,3,2,3,1}
                                        // replacement shape is: Shape{0,2,3,2,3,1}
                                        // expected output shape is Shape{2,2,3,2,3,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,2,3,2,3,3},
                                            Shape{0,2,3,2,3,1},
                                            std::vector<int64_t>{2,0,0,2},
                                            std::vector<int64_t>{6,0,0,1},
                                            std::vector<int64_t>{2,1,1,-1},
                                            AxisSet{2},
                                            AxisSet{2},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 158
                                        // slices are: [newaxis,1,...,newaxis,2:1:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{2,2,3,2,3,3}
                                        // slice shape is: Shape{1,2,3,2,3,1,1}
                                        // replacement shape is: Shape{1,2,3,2,3,1,1}
                                        // expected output shape is Shape{2,2,3,2,3,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,2,3,2,3,3},
                                            Shape{1,2,3,2,3,1,1},
                                            std::vector<int64_t>{0,1,0,0,2},
                                            std::vector<int64_t>{0,0,0,0,1},
                                            std::vector<int64_t>{1,1,1,1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,3},
                                            AxisSet{1},
                                            AxisSet{2},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,216,111,112,217,114,115,218,117,118,219,120,121,220,123,124,221,126,127,222,129,130,223,132,133,224,135,136,225,138,139,226,141,142,227,144,145,228,147,148,229,150,151,230,153,154,231,156,157,232,159,160,233,162,163,234,165,166,235,168,169,236,171,172,237,174,175,238,177,178,239,180,181,240,183,184,241,186,187,242,189,190,243,192,193,244,195,196,245,198,199,246,201,202,247,204,205,248,207,208,249,210,211,250,213,214,251},
                                            std::vector<int32_t>{216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251}
                                        ),

                                        // test 159
                                        // slices are: [1,...,newaxis,2:1:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{2,2,3,2,3,3}
                                        // slice shape is: Shape{2,3,2,3,1,1}
                                        // replacement shape is: Shape{2,3,2,3,1,1}
                                        // expected output shape is Shape{2,2,3,2,3,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,2,3,2,3,3},
                                            Shape{2,3,2,3,1,1},
                                            std::vector<int64_t>{1,0,0,2},
                                            std::vector<int64_t>{0,0,0,1},
                                            std::vector<int64_t>{1,1,1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{2},
                                            AxisSet{0},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,216,111,112,217,114,115,218,117,118,219,120,121,220,123,124,221,126,127,222,129,130,223,132,133,224,135,136,225,138,139,226,141,142,227,144,145,228,147,148,229,150,151,230,153,154,231,156,157,232,159,160,233,162,163,234,165,166,235,168,169,236,171,172,237,174,175,238,177,178,239,180,181,240,183,184,241,186,187,242,189,190,243,192,193,244,195,196,245,198,199,246,201,202,247,204,205,248,207,208,249,210,211,250,213,214,251},
                                            std::vector<int32_t>{216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251}
                                        ),

                                        // test 160
                                        // slices are: [newaxis,newaxis,2:1:-1,...]
                                        // dtype is: int32
                                        // input shape is: Shape{2,2,3,2,3,3}
                                        // slice shape is: Shape{1,1,0,2,3,2,3,3}
                                        // replacement shape is: Shape{1,1,0,2,3,2,3,3}
                                        // expected output shape is Shape{2,2,3,2,3,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,2,3,2,3,3},
                                            Shape{1,1,0,2,3,2,3,3},
                                            std::vector<int64_t>{0,0,2,0},
                                            std::vector<int64_t>{0,0,1,0},
                                            std::vector<int64_t>{1,1,-1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{3},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215},
                                            std::vector<int32_t>{}
                                        ),

                                        // test 161
                                        // slices are: [6:1:-2,...,1:2,2:1:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{1,3,3,1,1}
                                        // replacement shape is: Shape{1,3,3,1,1}
                                        // expected output shape is Shape{3,3,3,2,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{1,3,3,1,1},
                                            std::vector<int64_t>{6,0,1,2},
                                            std::vector<int64_t>{1,0,2,1},
                                            std::vector<int64_t>{-2,1,1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,162,114,115,116,117,118,163,120,121,122,123,124,164,126,127,128,129,130,165,132,133,134,135,136,166,138,139,140,141,142,167,144,145,146,147,148,168,150,151,152,153,154,169,156,157,158,159,160,170},
                                            std::vector<int32_t>{162,163,164,165,166,167,168,169,170}
                                        ),

                                        // test 162
                                        // slices are: [...,1:2,2:1:-1]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{3,3,3,1,1}
                                        // replacement shape is: Shape{3,3,3,1,1}
                                        // expected output shape is Shape{3,3,3,2,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{3,3,3,1,1},
                                            std::vector<int64_t>{0,1,2},
                                            std::vector<int64_t>{0,2,1},
                                            std::vector<int64_t>{1,1,-1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{0,1,2,3,4,162,6,7,8,9,10,163,12,13,14,15,16,164,18,19,20,21,22,165,24,25,26,27,28,166,30,31,32,33,34,167,36,37,38,39,40,168,42,43,44,45,46,169,48,49,50,51,52,170,54,55,56,57,58,171,60,61,62,63,64,172,66,67,68,69,70,173,72,73,74,75,76,174,78,79,80,81,82,175,84,85,86,87,88,176,90,91,92,93,94,177,96,97,98,99,100,178,102,103,104,105,106,179,108,109,110,111,112,180,114,115,116,117,118,181,120,121,122,123,124,182,126,127,128,129,130,183,132,133,134,135,136,184,138,139,140,141,142,185,144,145,146,147,148,186,150,151,152,153,154,187,156,157,158,159,160,188},
                                            std::vector<int32_t>{162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188}
                                        ),

                                        // test 163
                                        // slices are: [80000]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{80000},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 164
                                        // slices are: [-80000]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{-80000},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 165
                                        // slices are: [:,:]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{3,3,3,2,3}
                                        // replacement shape is: Shape{3,3,3,2,3}
                                        // expected output shape is Shape{3,3,3,2,3}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{3,3,3,2,3},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{0,1},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323},
                                            std::vector<int32_t>{162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323}
                                        ),

                                        // test 166
                                        // slices are: [0:0:0]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 167
                                        // slices are: [0:1:0]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            std::vector<int64_t>{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 168
                                        // slices are: [0:2:0]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{2},
                                            std::vector<int64_t>{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 169
                                        // slices are: [::0]
                                        // dtype is: int32
                                        // input shape is: Shape{3,3,3,2,3}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{3,3,3,2,3},
                                            Shape{},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            AxisSet{0},
                                            AxisSet{0},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{162}
                                        ),

                                        // test 170
                                        // slices are: [...]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{2,3,4}
                                        // replacement shape is: Shape{2,3,4}
                                        // failure is expected (dtype mismatch)
                                        make_shared<DynReplaceSliceTestParams<int32_t,float>>(
                                            false,
                                            element::i32,
                                            element::f32,
                                            Shape{2,3,4},
                                            Shape{2,3,4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{},
                                            std::vector<float>{1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0}
                                        ),

                                        // test 171
                                        // slices are: [...]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{2,3,4}
                                        // replacement shape is: Shape{1,3,4}
                                        // failure is expected (slice shape and replacement shape do not match)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{2,3,4},
                                            Shape{1,3,4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{1,1,1,1,1,1,1,1,1,1,1,1}
                                        ),

                                        // test 172
                                        // slices are: [...]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{2,3,4}
                                        // replacement shape is: Shape{3,4}
                                        // failure is expected (slice shape and replacement shape do not match)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{2,3,4},
                                            Shape{3,4},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{0},
                                            std::vector<int64_t>{1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{1,1,1,1,1,1,1,1,1,1,1,1}
                                        ),

                                        // test 173
                                        // slices are: [0,...,0]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{3}
                                        // replacement shape is: Shape{1}
                                        // failure is expected (slice shape and replacement shape do not match)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{2,3,4},
                                            Shape{1},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,2},
                                            AxisSet{1},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{1}
                                        ),

                                        // test 174
                                        // slices are: [1,newaxis]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,3,4}
                                        // replacement shape is: Shape{1,3,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,3,4},
                                            Shape{1,3,4},
                                            std::vector<int64_t>{1,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,24,25,26,27,28,29,30,31,32,33,34,35},
                                            std::vector<int32_t>{24,25,26,27,28,29,30,31,32,33,34,35}
                                        ),

                                        // test 175
                                        // slices are: [-1,-1,newaxis]
                                        // dtype is: int32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,4}
                                        // replacement shape is: Shape{1,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,3,4},
                                            Shape{1,4},
                                            std::vector<int64_t>{-1,-1,0},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{2},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,24,25,26,27},
                                            std::vector<int32_t>{24,25,26,27}
                                        ),

                                        // test 176
                                        // slices are: [1,newaxis]
                                        // dtype is: int64
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,3,4}
                                        // replacement shape is: Shape{1,3,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{2,3,4},
                                            Shape{1,3,4},
                                            std::vector<int64_t>{1,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4,5,6,7,8,9,10,11,24,25,26,27,28,29,30,31,32,33,34,35},
                                            std::vector<int64_t>{24,25,26,27,28,29,30,31,32,33,34,35}
                                        ),

                                        // test 177
                                        // slices are: [-1,-1,newaxis]
                                        // dtype is: int64
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,4}
                                        // replacement shape is: Shape{1,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{2,3,4},
                                            Shape{1,4},
                                            std::vector<int64_t>{-1,-1,0},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{2},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            std::vector<int64_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,24,25,26,27},
                                            std::vector<int64_t>{24,25,26,27}
                                        ),

                                        // test 178
                                        // slices are: [1,newaxis]
                                        // dtype is: float32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,3,4}
                                        // replacement shape is: Shape{1,3,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{2,3,4},
                                            Shape{1,3,4},
                                            std::vector<int64_t>{1,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,11.0,24.0,25.0,26.0,27.0,28.0,29.0,30.0,31.0,32.0,33.0,34.0,35.0},
                                            std::vector<float>{24.0,25.0,26.0,27.0,28.0,29.0,30.0,31.0,32.0,33.0,34.0,35.0}
                                        ),

                                        // test 179
                                        // slices are: [-1,-1,newaxis]
                                        // dtype is: float32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,4}
                                        // replacement shape is: Shape{1,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{2,3,4},
                                            Shape{1,4},
                                            std::vector<int64_t>{-1,-1,0},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{2},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0,16.0,17.0,18.0,19.0,24.0,25.0,26.0,27.0},
                                            std::vector<float>{24.0,25.0,26.0,27.0}
                                        ),

                                        // test 180
                                        // slices are: [1,newaxis]
                                        // dtype is: uint32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,3,4}
                                        // replacement shape is: Shape{1,3,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{2,3,4},
                                            Shape{1,3,4},
                                            std::vector<int64_t>{1,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4,5,6,7,8,9,10,11,24,25,26,27,28,29,30,31,32,33,34,35},
                                            std::vector<uint32_t>{24,25,26,27,28,29,30,31,32,33,34,35}
                                        ),

                                        // test 181
                                        // slices are: [-1,-1,newaxis]
                                        // dtype is: uint32
                                        // input shape is: Shape{2,3,4}
                                        // slice shape is: Shape{1,4}
                                        // replacement shape is: Shape{1,4}
                                        // expected output shape is Shape{2,3,4}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{2,3,4},
                                            Shape{1,4},
                                            std::vector<int64_t>{-1,-1,0},
                                            std::vector<int64_t>{0,0,0},
                                            std::vector<int64_t>{1,1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{2},
                                            AxisSet{0,1},
                                            AxisSet{},
                                            std::vector<uint32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,24,25,26,27},
                                            std::vector<uint32_t>{24,25,26,27}
                                        ),

                                        // test 182
                                        // slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
                                        // dtype is: int32
                                        // input shape is: Shape{2,4,6,8,2,2,2}
                                        // slice shape is: Shape{2,4,2,2,1,2,2}
                                        // replacement shape is: Shape{2,4,2,2,1,2,2}
                                        // expected output shape is Shape{2,4,6,8,2,2,2}
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            true,
                                            element::i32,
                                            element::i32,
                                            Shape{2,4,6,8,2,2,2},
                                            Shape{2,4,2,2,1,2,2},
                                            std::vector<int64_t>{0,0,2,7,0,0,1},
                                            std::vector<int64_t>{0,4,6,3,0,0,0},
                                            std::vector<int64_t>{1,1,2,-2,1,1,1},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{4},
                                            AxisSet{6},
                                            AxisSet{5},
                                            std::vector<int32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,3076,170,3077,172,3078,174,3079,176,177,178,179,180,181,182,183,184,3072,186,3073,188,3074,190,3075,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,3084,298,3085,300,3086,302,3087,304,305,306,307,308,309,310,311,312,3080,314,3081,316,3082,318,3083,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,3092,554,3093,556,3094,558,3095,560,561,562,563,564,565,566,567,568,3088,570,3089,572,3090,574,3091,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,3100,682,3101,684,3102,686,3103,688,689,690,691,692,693,694,695,696,3096,698,3097,700,3098,702,3099,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,3108,938,3109,940,3110,942,3111,944,945,946,947,948,949,950,951,952,3104,954,3105,956,3106,958,3107,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,3116,1066,3117,1068,3118,1070,3119,1072,1073,1074,1075,1076,1077,1078,1079,1080,3112,1082,3113,1084,3114,1086,3115,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,3124,1322,3125,1324,3126,1326,3127,1328,1329,1330,1331,1332,1333,1334,1335,1336,3120,1338,3121,1340,3122,1342,3123,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,3132,1450,3133,1452,3134,1454,3135,1456,1457,1458,1459,1460,1461,1462,1463,1464,3128,1466,3129,1468,3130,1470,3131,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,3140,1706,3141,1708,3142,1710,3143,1712,1713,1714,1715,1716,1717,1718,1719,1720,3136,1722,3137,1724,3138,1726,3139,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,3148,1834,3149,1836,3150,1838,3151,1840,1841,1842,1843,1844,1845,1846,1847,1848,3144,1850,3145,1852,3146,1854,3147,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,3156,2090,3157,2092,3158,2094,3159,2096,2097,2098,2099,2100,2101,2102,2103,2104,3152,2106,3153,2108,3154,2110,3155,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,3164,2218,3165,2220,3166,2222,3167,2224,2225,2226,2227,2228,2229,2230,2231,2232,3160,2234,3161,2236,3162,2238,3163,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399,2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471,2472,3172,2474,3173,2476,3174,2478,3175,2480,2481,2482,2483,2484,2485,2486,2487,2488,3168,2490,3169,2492,3170,2494,3171,2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,2544,2545,2546,2547,2548,2549,2550,2551,2552,2553,2554,2555,2556,2557,2558,2559,2560,2561,2562,2563,2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,2576,2577,2578,2579,2580,2581,2582,2583,2584,2585,2586,2587,2588,2589,2590,2591,2592,2593,2594,2595,2596,2597,2598,2599,2600,3180,2602,3181,2604,3182,2606,3183,2608,2609,2610,2611,2612,2613,2614,2615,2616,3176,2618,3177,2620,3178,2622,3179,2624,2625,2626,2627,2628,2629,2630,2631,2632,2633,2634,2635,2636,2637,2638,2639,2640,2641,2642,2643,2644,2645,2646,2647,2648,2649,2650,2651,2652,2653,2654,2655,2656,2657,2658,2659,2660,2661,2662,2663,2664,2665,2666,2667,2668,2669,2670,2671,2672,2673,2674,2675,2676,2677,2678,2679,2680,2681,2682,2683,2684,2685,2686,2687,2688,2689,2690,2691,2692,2693,2694,2695,2696,2697,2698,2699,2700,2701,2702,2703,2704,2705,2706,2707,2708,2709,2710,2711,2712,2713,2714,2715,2716,2717,2718,2719,2720,2721,2722,2723,2724,2725,2726,2727,2728,2729,2730,2731,2732,2733,2734,2735,2736,2737,2738,2739,2740,2741,2742,2743,2744,2745,2746,2747,2748,2749,2750,2751,2752,2753,2754,2755,2756,2757,2758,2759,2760,2761,2762,2763,2764,2765,2766,2767,2768,2769,2770,2771,2772,2773,2774,2775,2776,2777,2778,2779,2780,2781,2782,2783,2784,2785,2786,2787,2788,2789,2790,2791,2792,2793,2794,2795,2796,2797,2798,2799,2800,2801,2802,2803,2804,2805,2806,2807,2808,2809,2810,2811,2812,2813,2814,2815,2816,2817,2818,2819,2820,2821,2822,2823,2824,2825,2826,2827,2828,2829,2830,2831,2832,2833,2834,2835,2836,2837,2838,2839,2840,2841,2842,2843,2844,2845,2846,2847,2848,2849,2850,2851,2852,2853,2854,2855,2856,3188,2858,3189,2860,3190,2862,3191,2864,2865,2866,2867,2868,2869,2870,2871,2872,3184,2874,3185,2876,3186,2878,3187,2880,2881,2882,2883,2884,2885,2886,2887,2888,2889,2890,2891,2892,2893,2894,2895,2896,2897,2898,2899,2900,2901,2902,2903,2904,2905,2906,2907,2908,2909,2910,2911,2912,2913,2914,2915,2916,2917,2918,2919,2920,2921,2922,2923,2924,2925,2926,2927,2928,2929,2930,2931,2932,2933,2934,2935,2936,2937,2938,2939,2940,2941,2942,2943,2944,2945,2946,2947,2948,2949,2950,2951,2952,2953,2954,2955,2956,2957,2958,2959,2960,2961,2962,2963,2964,2965,2966,2967,2968,2969,2970,2971,2972,2973,2974,2975,2976,2977,2978,2979,2980,2981,2982,2983,2984,3196,2986,3197,2988,3198,2990,3199,2992,2993,2994,2995,2996,2997,2998,2999,3000,3192,3002,3193,3004,3194,3006,3195,3008,3009,3010,3011,3012,3013,3014,3015,3016,3017,3018,3019,3020,3021,3022,3023,3024,3025,3026,3027,3028,3029,3030,3031,3032,3033,3034,3035,3036,3037,3038,3039,3040,3041,3042,3043,3044,3045,3046,3047,3048,3049,3050,3051,3052,3053,3054,3055,3056,3057,3058,3059,3060,3061,3062,3063,3064,3065,3066,3067,3068,3069,3070,3071},
                                            std::vector<int32_t>{3072,3073,3074,3075,3076,3077,3078,3079,3080,3081,3082,3083,3084,3085,3086,3087,3088,3089,3090,3091,3092,3093,3094,3095,3096,3097,3098,3099,3100,3101,3102,3103,3104,3105,3106,3107,3108,3109,3110,3111,3112,3113,3114,3115,3116,3117,3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,3128,3129,3130,3131,3132,3133,3134,3135,3136,3137,3138,3139,3140,3141,3142,3143,3144,3145,3146,3147,3148,3149,3150,3151,3152,3153,3154,3155,3156,3157,3158,3159,3160,3161,3162,3163,3164,3165,3166,3167,3168,3169,3170,3171,3172,3173,3174,3175,3176,3177,3178,3179,3180,3181,3182,3183,3184,3185,3186,3187,3188,3189,3190,3191,3192,3193,3194,3195,3196,3197,3198,3199}
                                        ),

                                        // test 183
                                        // slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
                                        // dtype is: int64
                                        // input shape is: Shape{2,4,6,8,2,2,2}
                                        // slice shape is: Shape{2,4,2,2,1,2,2}
                                        // replacement shape is: Shape{2,4,2,2,1,2,2}
                                        // expected output shape is Shape{2,4,6,8,2,2,2}
                                        make_shared<DynReplaceSliceTestParams<int64_t,int64_t>>(
                                            true,
                                            element::i64,
                                            element::i64,
                                            Shape{2,4,6,8,2,2,2},
                                            Shape{2,4,2,2,1,2,2},
                                            std::vector<int64_t>{0,0,2,7,0,0,1},
                                            std::vector<int64_t>{0,4,6,3,0,0,0},
                                            std::vector<int64_t>{1,1,2,-2,1,1,1},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{4},
                                            AxisSet{6},
                                            AxisSet{5},
                                            std::vector<int64_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,3076,170,3077,172,3078,174,3079,176,177,178,179,180,181,182,183,184,3072,186,3073,188,3074,190,3075,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,3084,298,3085,300,3086,302,3087,304,305,306,307,308,309,310,311,312,3080,314,3081,316,3082,318,3083,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,3092,554,3093,556,3094,558,3095,560,561,562,563,564,565,566,567,568,3088,570,3089,572,3090,574,3091,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,3100,682,3101,684,3102,686,3103,688,689,690,691,692,693,694,695,696,3096,698,3097,700,3098,702,3099,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,3108,938,3109,940,3110,942,3111,944,945,946,947,948,949,950,951,952,3104,954,3105,956,3106,958,3107,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,3116,1066,3117,1068,3118,1070,3119,1072,1073,1074,1075,1076,1077,1078,1079,1080,3112,1082,3113,1084,3114,1086,3115,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,3124,1322,3125,1324,3126,1326,3127,1328,1329,1330,1331,1332,1333,1334,1335,1336,3120,1338,3121,1340,3122,1342,3123,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,3132,1450,3133,1452,3134,1454,3135,1456,1457,1458,1459,1460,1461,1462,1463,1464,3128,1466,3129,1468,3130,1470,3131,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,3140,1706,3141,1708,3142,1710,3143,1712,1713,1714,1715,1716,1717,1718,1719,1720,3136,1722,3137,1724,3138,1726,3139,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,3148,1834,3149,1836,3150,1838,3151,1840,1841,1842,1843,1844,1845,1846,1847,1848,3144,1850,3145,1852,3146,1854,3147,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,3156,2090,3157,2092,3158,2094,3159,2096,2097,2098,2099,2100,2101,2102,2103,2104,3152,2106,3153,2108,3154,2110,3155,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,3164,2218,3165,2220,3166,2222,3167,2224,2225,2226,2227,2228,2229,2230,2231,2232,3160,2234,3161,2236,3162,2238,3163,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399,2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471,2472,3172,2474,3173,2476,3174,2478,3175,2480,2481,2482,2483,2484,2485,2486,2487,2488,3168,2490,3169,2492,3170,2494,3171,2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,2544,2545,2546,2547,2548,2549,2550,2551,2552,2553,2554,2555,2556,2557,2558,2559,2560,2561,2562,2563,2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,2576,2577,2578,2579,2580,2581,2582,2583,2584,2585,2586,2587,2588,2589,2590,2591,2592,2593,2594,2595,2596,2597,2598,2599,2600,3180,2602,3181,2604,3182,2606,3183,2608,2609,2610,2611,2612,2613,2614,2615,2616,3176,2618,3177,2620,3178,2622,3179,2624,2625,2626,2627,2628,2629,2630,2631,2632,2633,2634,2635,2636,2637,2638,2639,2640,2641,2642,2643,2644,2645,2646,2647,2648,2649,2650,2651,2652,2653,2654,2655,2656,2657,2658,2659,2660,2661,2662,2663,2664,2665,2666,2667,2668,2669,2670,2671,2672,2673,2674,2675,2676,2677,2678,2679,2680,2681,2682,2683,2684,2685,2686,2687,2688,2689,2690,2691,2692,2693,2694,2695,2696,2697,2698,2699,2700,2701,2702,2703,2704,2705,2706,2707,2708,2709,2710,2711,2712,2713,2714,2715,2716,2717,2718,2719,2720,2721,2722,2723,2724,2725,2726,2727,2728,2729,2730,2731,2732,2733,2734,2735,2736,2737,2738,2739,2740,2741,2742,2743,2744,2745,2746,2747,2748,2749,2750,2751,2752,2753,2754,2755,2756,2757,2758,2759,2760,2761,2762,2763,2764,2765,2766,2767,2768,2769,2770,2771,2772,2773,2774,2775,2776,2777,2778,2779,2780,2781,2782,2783,2784,2785,2786,2787,2788,2789,2790,2791,2792,2793,2794,2795,2796,2797,2798,2799,2800,2801,2802,2803,2804,2805,2806,2807,2808,2809,2810,2811,2812,2813,2814,2815,2816,2817,2818,2819,2820,2821,2822,2823,2824,2825,2826,2827,2828,2829,2830,2831,2832,2833,2834,2835,2836,2837,2838,2839,2840,2841,2842,2843,2844,2845,2846,2847,2848,2849,2850,2851,2852,2853,2854,2855,2856,3188,2858,3189,2860,3190,2862,3191,2864,2865,2866,2867,2868,2869,2870,2871,2872,3184,2874,3185,2876,3186,2878,3187,2880,2881,2882,2883,2884,2885,2886,2887,2888,2889,2890,2891,2892,2893,2894,2895,2896,2897,2898,2899,2900,2901,2902,2903,2904,2905,2906,2907,2908,2909,2910,2911,2912,2913,2914,2915,2916,2917,2918,2919,2920,2921,2922,2923,2924,2925,2926,2927,2928,2929,2930,2931,2932,2933,2934,2935,2936,2937,2938,2939,2940,2941,2942,2943,2944,2945,2946,2947,2948,2949,2950,2951,2952,2953,2954,2955,2956,2957,2958,2959,2960,2961,2962,2963,2964,2965,2966,2967,2968,2969,2970,2971,2972,2973,2974,2975,2976,2977,2978,2979,2980,2981,2982,2983,2984,3196,2986,3197,2988,3198,2990,3199,2992,2993,2994,2995,2996,2997,2998,2999,3000,3192,3002,3193,3004,3194,3006,3195,3008,3009,3010,3011,3012,3013,3014,3015,3016,3017,3018,3019,3020,3021,3022,3023,3024,3025,3026,3027,3028,3029,3030,3031,3032,3033,3034,3035,3036,3037,3038,3039,3040,3041,3042,3043,3044,3045,3046,3047,3048,3049,3050,3051,3052,3053,3054,3055,3056,3057,3058,3059,3060,3061,3062,3063,3064,3065,3066,3067,3068,3069,3070,3071},
                                            std::vector<int64_t>{3072,3073,3074,3075,3076,3077,3078,3079,3080,3081,3082,3083,3084,3085,3086,3087,3088,3089,3090,3091,3092,3093,3094,3095,3096,3097,3098,3099,3100,3101,3102,3103,3104,3105,3106,3107,3108,3109,3110,3111,3112,3113,3114,3115,3116,3117,3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,3128,3129,3130,3131,3132,3133,3134,3135,3136,3137,3138,3139,3140,3141,3142,3143,3144,3145,3146,3147,3148,3149,3150,3151,3152,3153,3154,3155,3156,3157,3158,3159,3160,3161,3162,3163,3164,3165,3166,3167,3168,3169,3170,3171,3172,3173,3174,3175,3176,3177,3178,3179,3180,3181,3182,3183,3184,3185,3186,3187,3188,3189,3190,3191,3192,3193,3194,3195,3196,3197,3198,3199}
                                        ),

                                        // test 184
                                        // slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
                                        // dtype is: float32
                                        // input shape is: Shape{2,4,6,8,2,2,2}
                                        // slice shape is: Shape{2,4,2,2,1,2,2}
                                        // replacement shape is: Shape{2,4,2,2,1,2,2}
                                        // expected output shape is Shape{2,4,6,8,2,2,2}
                                        make_shared<DynReplaceSliceTestParams<float,float>>(
                                            true,
                                            element::f32,
                                            element::f32,
                                            Shape{2,4,6,8,2,2,2},
                                            Shape{2,4,2,2,1,2,2},
                                            std::vector<int64_t>{0,0,2,7,0,0,1},
                                            std::vector<int64_t>{0,4,6,3,0,0,0},
                                            std::vector<int64_t>{1,1,2,-2,1,1,1},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{4},
                                            AxisSet{6},
                                            AxisSet{5},
                                            std::vector<float>{0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,11.0,12.0,13.0,14.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0,22.0,23.0,24.0,25.0,26.0,27.0,28.0,29.0,30.0,31.0,32.0,33.0,34.0,35.0,36.0,37.0,38.0,39.0,40.0,41.0,42.0,43.0,44.0,45.0,46.0,47.0,48.0,49.0,50.0,51.0,52.0,53.0,54.0,55.0,56.0,57.0,58.0,59.0,60.0,61.0,62.0,63.0,64.0,65.0,66.0,67.0,68.0,69.0,70.0,71.0,72.0,73.0,74.0,75.0,76.0,77.0,78.0,79.0,80.0,81.0,82.0,83.0,84.0,85.0,86.0,87.0,88.0,89.0,90.0,91.0,92.0,93.0,94.0,95.0,96.0,97.0,98.0,99.0,100.0,101.0,102.0,103.0,104.0,105.0,106.0,107.0,108.0,109.0,110.0,111.0,112.0,113.0,114.0,115.0,116.0,117.0,118.0,119.0,120.0,121.0,122.0,123.0,124.0,125.0,126.0,127.0,128.0,129.0,130.0,131.0,132.0,133.0,134.0,135.0,136.0,137.0,138.0,139.0,140.0,141.0,142.0,143.0,144.0,145.0,146.0,147.0,148.0,149.0,150.0,151.0,152.0,153.0,154.0,155.0,156.0,157.0,158.0,159.0,160.0,161.0,162.0,163.0,164.0,165.0,166.0,167.0,168.0,3076.0,170.0,3077.0,172.0,3078.0,174.0,3079.0,176.0,177.0,178.0,179.0,180.0,181.0,182.0,183.0,184.0,3072.0,186.0,3073.0,188.0,3074.0,190.0,3075.0,192.0,193.0,194.0,195.0,196.0,197.0,198.0,199.0,200.0,201.0,202.0,203.0,204.0,205.0,206.0,207.0,208.0,209.0,210.0,211.0,212.0,213.0,214.0,215.0,216.0,217.0,218.0,219.0,220.0,221.0,222.0,223.0,224.0,225.0,226.0,227.0,228.0,229.0,230.0,231.0,232.0,233.0,234.0,235.0,236.0,237.0,238.0,239.0,240.0,241.0,242.0,243.0,244.0,245.0,246.0,247.0,248.0,249.0,250.0,251.0,252.0,253.0,254.0,255.0,256.0,257.0,258.0,259.0,260.0,261.0,262.0,263.0,264.0,265.0,266.0,267.0,268.0,269.0,270.0,271.0,272.0,273.0,274.0,275.0,276.0,277.0,278.0,279.0,280.0,281.0,282.0,283.0,284.0,285.0,286.0,287.0,288.0,289.0,290.0,291.0,292.0,293.0,294.0,295.0,296.0,3084.0,298.0,3085.0,300.0,3086.0,302.0,3087.0,304.0,305.0,306.0,307.0,308.0,309.0,310.0,311.0,312.0,3080.0,314.0,3081.0,316.0,3082.0,318.0,3083.0,320.0,321.0,322.0,323.0,324.0,325.0,326.0,327.0,328.0,329.0,330.0,331.0,332.0,333.0,334.0,335.0,336.0,337.0,338.0,339.0,340.0,341.0,342.0,343.0,344.0,345.0,346.0,347.0,348.0,349.0,350.0,351.0,352.0,353.0,354.0,355.0,356.0,357.0,358.0,359.0,360.0,361.0,362.0,363.0,364.0,365.0,366.0,367.0,368.0,369.0,370.0,371.0,372.0,373.0,374.0,375.0,376.0,377.0,378.0,379.0,380.0,381.0,382.0,383.0,384.0,385.0,386.0,387.0,388.0,389.0,390.0,391.0,392.0,393.0,394.0,395.0,396.0,397.0,398.0,399.0,400.0,401.0,402.0,403.0,404.0,405.0,406.0,407.0,408.0,409.0,410.0,411.0,412.0,413.0,414.0,415.0,416.0,417.0,418.0,419.0,420.0,421.0,422.0,423.0,424.0,425.0,426.0,427.0,428.0,429.0,430.0,431.0,432.0,433.0,434.0,435.0,436.0,437.0,438.0,439.0,440.0,441.0,442.0,443.0,444.0,445.0,446.0,447.0,448.0,449.0,450.0,451.0,452.0,453.0,454.0,455.0,456.0,457.0,458.0,459.0,460.0,461.0,462.0,463.0,464.0,465.0,466.0,467.0,468.0,469.0,470.0,471.0,472.0,473.0,474.0,475.0,476.0,477.0,478.0,479.0,480.0,481.0,482.0,483.0,484.0,485.0,486.0,487.0,488.0,489.0,490.0,491.0,492.0,493.0,494.0,495.0,496.0,497.0,498.0,499.0,500.0,501.0,502.0,503.0,504.0,505.0,506.0,507.0,508.0,509.0,510.0,511.0,512.0,513.0,514.0,515.0,516.0,517.0,518.0,519.0,520.0,521.0,522.0,523.0,524.0,525.0,526.0,527.0,528.0,529.0,530.0,531.0,532.0,533.0,534.0,535.0,536.0,537.0,538.0,539.0,540.0,541.0,542.0,543.0,544.0,545.0,546.0,547.0,548.0,549.0,550.0,551.0,552.0,3092.0,554.0,3093.0,556.0,3094.0,558.0,3095.0,560.0,561.0,562.0,563.0,564.0,565.0,566.0,567.0,568.0,3088.0,570.0,3089.0,572.0,3090.0,574.0,3091.0,576.0,577.0,578.0,579.0,580.0,581.0,582.0,583.0,584.0,585.0,586.0,587.0,588.0,589.0,590.0,591.0,592.0,593.0,594.0,595.0,596.0,597.0,598.0,599.0,600.0,601.0,602.0,603.0,604.0,605.0,606.0,607.0,608.0,609.0,610.0,611.0,612.0,613.0,614.0,615.0,616.0,617.0,618.0,619.0,620.0,621.0,622.0,623.0,624.0,625.0,626.0,627.0,628.0,629.0,630.0,631.0,632.0,633.0,634.0,635.0,636.0,637.0,638.0,639.0,640.0,641.0,642.0,643.0,644.0,645.0,646.0,647.0,648.0,649.0,650.0,651.0,652.0,653.0,654.0,655.0,656.0,657.0,658.0,659.0,660.0,661.0,662.0,663.0,664.0,665.0,666.0,667.0,668.0,669.0,670.0,671.0,672.0,673.0,674.0,675.0,676.0,677.0,678.0,679.0,680.0,3100.0,682.0,3101.0,684.0,3102.0,686.0,3103.0,688.0,689.0,690.0,691.0,692.0,693.0,694.0,695.0,696.0,3096.0,698.0,3097.0,700.0,3098.0,702.0,3099.0,704.0,705.0,706.0,707.0,708.0,709.0,710.0,711.0,712.0,713.0,714.0,715.0,716.0,717.0,718.0,719.0,720.0,721.0,722.0,723.0,724.0,725.0,726.0,727.0,728.0,729.0,730.0,731.0,732.0,733.0,734.0,735.0,736.0,737.0,738.0,739.0,740.0,741.0,742.0,743.0,744.0,745.0,746.0,747.0,748.0,749.0,750.0,751.0,752.0,753.0,754.0,755.0,756.0,757.0,758.0,759.0,760.0,761.0,762.0,763.0,764.0,765.0,766.0,767.0,768.0,769.0,770.0,771.0,772.0,773.0,774.0,775.0,776.0,777.0,778.0,779.0,780.0,781.0,782.0,783.0,784.0,785.0,786.0,787.0,788.0,789.0,790.0,791.0,792.0,793.0,794.0,795.0,796.0,797.0,798.0,799.0,800.0,801.0,802.0,803.0,804.0,805.0,806.0,807.0,808.0,809.0,810.0,811.0,812.0,813.0,814.0,815.0,816.0,817.0,818.0,819.0,820.0,821.0,822.0,823.0,824.0,825.0,826.0,827.0,828.0,829.0,830.0,831.0,832.0,833.0,834.0,835.0,836.0,837.0,838.0,839.0,840.0,841.0,842.0,843.0,844.0,845.0,846.0,847.0,848.0,849.0,850.0,851.0,852.0,853.0,854.0,855.0,856.0,857.0,858.0,859.0,860.0,861.0,862.0,863.0,864.0,865.0,866.0,867.0,868.0,869.0,870.0,871.0,872.0,873.0,874.0,875.0,876.0,877.0,878.0,879.0,880.0,881.0,882.0,883.0,884.0,885.0,886.0,887.0,888.0,889.0,890.0,891.0,892.0,893.0,894.0,895.0,896.0,897.0,898.0,899.0,900.0,901.0,902.0,903.0,904.0,905.0,906.0,907.0,908.0,909.0,910.0,911.0,912.0,913.0,914.0,915.0,916.0,917.0,918.0,919.0,920.0,921.0,922.0,923.0,924.0,925.0,926.0,927.0,928.0,929.0,930.0,931.0,932.0,933.0,934.0,935.0,936.0,3108.0,938.0,3109.0,940.0,3110.0,942.0,3111.0,944.0,945.0,946.0,947.0,948.0,949.0,950.0,951.0,952.0,3104.0,954.0,3105.0,956.0,3106.0,958.0,3107.0,960.0,961.0,962.0,963.0,964.0,965.0,966.0,967.0,968.0,969.0,970.0,971.0,972.0,973.0,974.0,975.0,976.0,977.0,978.0,979.0,980.0,981.0,982.0,983.0,984.0,985.0,986.0,987.0,988.0,989.0,990.0,991.0,992.0,993.0,994.0,995.0,996.0,997.0,998.0,999.0,1000.0,1001.0,1002.0,1003.0,1004.0,1005.0,1006.0,1007.0,1008.0,1009.0,1010.0,1011.0,1012.0,1013.0,1014.0,1015.0,1016.0,1017.0,1018.0,1019.0,1020.0,1021.0,1022.0,1023.0,1024.0,1025.0,1026.0,1027.0,1028.0,1029.0,1030.0,1031.0,1032.0,1033.0,1034.0,1035.0,1036.0,1037.0,1038.0,1039.0,1040.0,1041.0,1042.0,1043.0,1044.0,1045.0,1046.0,1047.0,1048.0,1049.0,1050.0,1051.0,1052.0,1053.0,1054.0,1055.0,1056.0,1057.0,1058.0,1059.0,1060.0,1061.0,1062.0,1063.0,1064.0,3116.0,1066.0,3117.0,1068.0,3118.0,1070.0,3119.0,1072.0,1073.0,1074.0,1075.0,1076.0,1077.0,1078.0,1079.0,1080.0,3112.0,1082.0,3113.0,1084.0,3114.0,1086.0,3115.0,1088.0,1089.0,1090.0,1091.0,1092.0,1093.0,1094.0,1095.0,1096.0,1097.0,1098.0,1099.0,1100.0,1101.0,1102.0,1103.0,1104.0,1105.0,1106.0,1107.0,1108.0,1109.0,1110.0,1111.0,1112.0,1113.0,1114.0,1115.0,1116.0,1117.0,1118.0,1119.0,1120.0,1121.0,1122.0,1123.0,1124.0,1125.0,1126.0,1127.0,1128.0,1129.0,1130.0,1131.0,1132.0,1133.0,1134.0,1135.0,1136.0,1137.0,1138.0,1139.0,1140.0,1141.0,1142.0,1143.0,1144.0,1145.0,1146.0,1147.0,1148.0,1149.0,1150.0,1151.0,1152.0,1153.0,1154.0,1155.0,1156.0,1157.0,1158.0,1159.0,1160.0,1161.0,1162.0,1163.0,1164.0,1165.0,1166.0,1167.0,1168.0,1169.0,1170.0,1171.0,1172.0,1173.0,1174.0,1175.0,1176.0,1177.0,1178.0,1179.0,1180.0,1181.0,1182.0,1183.0,1184.0,1185.0,1186.0,1187.0,1188.0,1189.0,1190.0,1191.0,1192.0,1193.0,1194.0,1195.0,1196.0,1197.0,1198.0,1199.0,1200.0,1201.0,1202.0,1203.0,1204.0,1205.0,1206.0,1207.0,1208.0,1209.0,1210.0,1211.0,1212.0,1213.0,1214.0,1215.0,1216.0,1217.0,1218.0,1219.0,1220.0,1221.0,1222.0,1223.0,1224.0,1225.0,1226.0,1227.0,1228.0,1229.0,1230.0,1231.0,1232.0,1233.0,1234.0,1235.0,1236.0,1237.0,1238.0,1239.0,1240.0,1241.0,1242.0,1243.0,1244.0,1245.0,1246.0,1247.0,1248.0,1249.0,1250.0,1251.0,1252.0,1253.0,1254.0,1255.0,1256.0,1257.0,1258.0,1259.0,1260.0,1261.0,1262.0,1263.0,1264.0,1265.0,1266.0,1267.0,1268.0,1269.0,1270.0,1271.0,1272.0,1273.0,1274.0,1275.0,1276.0,1277.0,1278.0,1279.0,1280.0,1281.0,1282.0,1283.0,1284.0,1285.0,1286.0,1287.0,1288.0,1289.0,1290.0,1291.0,1292.0,1293.0,1294.0,1295.0,1296.0,1297.0,1298.0,1299.0,1300.0,1301.0,1302.0,1303.0,1304.0,1305.0,1306.0,1307.0,1308.0,1309.0,1310.0,1311.0,1312.0,1313.0,1314.0,1315.0,1316.0,1317.0,1318.0,1319.0,1320.0,3124.0,1322.0,3125.0,1324.0,3126.0,1326.0,3127.0,1328.0,1329.0,1330.0,1331.0,1332.0,1333.0,1334.0,1335.0,1336.0,3120.0,1338.0,3121.0,1340.0,3122.0,1342.0,3123.0,1344.0,1345.0,1346.0,1347.0,1348.0,1349.0,1350.0,1351.0,1352.0,1353.0,1354.0,1355.0,1356.0,1357.0,1358.0,1359.0,1360.0,1361.0,1362.0,1363.0,1364.0,1365.0,1366.0,1367.0,1368.0,1369.0,1370.0,1371.0,1372.0,1373.0,1374.0,1375.0,1376.0,1377.0,1378.0,1379.0,1380.0,1381.0,1382.0,1383.0,1384.0,1385.0,1386.0,1387.0,1388.0,1389.0,1390.0,1391.0,1392.0,1393.0,1394.0,1395.0,1396.0,1397.0,1398.0,1399.0,1400.0,1401.0,1402.0,1403.0,1404.0,1405.0,1406.0,1407.0,1408.0,1409.0,1410.0,1411.0,1412.0,1413.0,1414.0,1415.0,1416.0,1417.0,1418.0,1419.0,1420.0,1421.0,1422.0,1423.0,1424.0,1425.0,1426.0,1427.0,1428.0,1429.0,1430.0,1431.0,1432.0,1433.0,1434.0,1435.0,1436.0,1437.0,1438.0,1439.0,1440.0,1441.0,1442.0,1443.0,1444.0,1445.0,1446.0,1447.0,1448.0,3132.0,1450.0,3133.0,1452.0,3134.0,1454.0,3135.0,1456.0,1457.0,1458.0,1459.0,1460.0,1461.0,1462.0,1463.0,1464.0,3128.0,1466.0,3129.0,1468.0,3130.0,1470.0,3131.0,1472.0,1473.0,1474.0,1475.0,1476.0,1477.0,1478.0,1479.0,1480.0,1481.0,1482.0,1483.0,1484.0,1485.0,1486.0,1487.0,1488.0,1489.0,1490.0,1491.0,1492.0,1493.0,1494.0,1495.0,1496.0,1497.0,1498.0,1499.0,1500.0,1501.0,1502.0,1503.0,1504.0,1505.0,1506.0,1507.0,1508.0,1509.0,1510.0,1511.0,1512.0,1513.0,1514.0,1515.0,1516.0,1517.0,1518.0,1519.0,1520.0,1521.0,1522.0,1523.0,1524.0,1525.0,1526.0,1527.0,1528.0,1529.0,1530.0,1531.0,1532.0,1533.0,1534.0,1535.0,1536.0,1537.0,1538.0,1539.0,1540.0,1541.0,1542.0,1543.0,1544.0,1545.0,1546.0,1547.0,1548.0,1549.0,1550.0,1551.0,1552.0,1553.0,1554.0,1555.0,1556.0,1557.0,1558.0,1559.0,1560.0,1561.0,1562.0,1563.0,1564.0,1565.0,1566.0,1567.0,1568.0,1569.0,1570.0,1571.0,1572.0,1573.0,1574.0,1575.0,1576.0,1577.0,1578.0,1579.0,1580.0,1581.0,1582.0,1583.0,1584.0,1585.0,1586.0,1587.0,1588.0,1589.0,1590.0,1591.0,1592.0,1593.0,1594.0,1595.0,1596.0,1597.0,1598.0,1599.0,1600.0,1601.0,1602.0,1603.0,1604.0,1605.0,1606.0,1607.0,1608.0,1609.0,1610.0,1611.0,1612.0,1613.0,1614.0,1615.0,1616.0,1617.0,1618.0,1619.0,1620.0,1621.0,1622.0,1623.0,1624.0,1625.0,1626.0,1627.0,1628.0,1629.0,1630.0,1631.0,1632.0,1633.0,1634.0,1635.0,1636.0,1637.0,1638.0,1639.0,1640.0,1641.0,1642.0,1643.0,1644.0,1645.0,1646.0,1647.0,1648.0,1649.0,1650.0,1651.0,1652.0,1653.0,1654.0,1655.0,1656.0,1657.0,1658.0,1659.0,1660.0,1661.0,1662.0,1663.0,1664.0,1665.0,1666.0,1667.0,1668.0,1669.0,1670.0,1671.0,1672.0,1673.0,1674.0,1675.0,1676.0,1677.0,1678.0,1679.0,1680.0,1681.0,1682.0,1683.0,1684.0,1685.0,1686.0,1687.0,1688.0,1689.0,1690.0,1691.0,1692.0,1693.0,1694.0,1695.0,1696.0,1697.0,1698.0,1699.0,1700.0,1701.0,1702.0,1703.0,1704.0,3140.0,1706.0,3141.0,1708.0,3142.0,1710.0,3143.0,1712.0,1713.0,1714.0,1715.0,1716.0,1717.0,1718.0,1719.0,1720.0,3136.0,1722.0,3137.0,1724.0,3138.0,1726.0,3139.0,1728.0,1729.0,1730.0,1731.0,1732.0,1733.0,1734.0,1735.0,1736.0,1737.0,1738.0,1739.0,1740.0,1741.0,1742.0,1743.0,1744.0,1745.0,1746.0,1747.0,1748.0,1749.0,1750.0,1751.0,1752.0,1753.0,1754.0,1755.0,1756.0,1757.0,1758.0,1759.0,1760.0,1761.0,1762.0,1763.0,1764.0,1765.0,1766.0,1767.0,1768.0,1769.0,1770.0,1771.0,1772.0,1773.0,1774.0,1775.0,1776.0,1777.0,1778.0,1779.0,1780.0,1781.0,1782.0,1783.0,1784.0,1785.0,1786.0,1787.0,1788.0,1789.0,1790.0,1791.0,1792.0,1793.0,1794.0,1795.0,1796.0,1797.0,1798.0,1799.0,1800.0,1801.0,1802.0,1803.0,1804.0,1805.0,1806.0,1807.0,1808.0,1809.0,1810.0,1811.0,1812.0,1813.0,1814.0,1815.0,1816.0,1817.0,1818.0,1819.0,1820.0,1821.0,1822.0,1823.0,1824.0,1825.0,1826.0,1827.0,1828.0,1829.0,1830.0,1831.0,1832.0,3148.0,1834.0,3149.0,1836.0,3150.0,1838.0,3151.0,1840.0,1841.0,1842.0,1843.0,1844.0,1845.0,1846.0,1847.0,1848.0,3144.0,1850.0,3145.0,1852.0,3146.0,1854.0,3147.0,1856.0,1857.0,1858.0,1859.0,1860.0,1861.0,1862.0,1863.0,1864.0,1865.0,1866.0,1867.0,1868.0,1869.0,1870.0,1871.0,1872.0,1873.0,1874.0,1875.0,1876.0,1877.0,1878.0,1879.0,1880.0,1881.0,1882.0,1883.0,1884.0,1885.0,1886.0,1887.0,1888.0,1889.0,1890.0,1891.0,1892.0,1893.0,1894.0,1895.0,1896.0,1897.0,1898.0,1899.0,1900.0,1901.0,1902.0,1903.0,1904.0,1905.0,1906.0,1907.0,1908.0,1909.0,1910.0,1911.0,1912.0,1913.0,1914.0,1915.0,1916.0,1917.0,1918.0,1919.0,1920.0,1921.0,1922.0,1923.0,1924.0,1925.0,1926.0,1927.0,1928.0,1929.0,1930.0,1931.0,1932.0,1933.0,1934.0,1935.0,1936.0,1937.0,1938.0,1939.0,1940.0,1941.0,1942.0,1943.0,1944.0,1945.0,1946.0,1947.0,1948.0,1949.0,1950.0,1951.0,1952.0,1953.0,1954.0,1955.0,1956.0,1957.0,1958.0,1959.0,1960.0,1961.0,1962.0,1963.0,1964.0,1965.0,1966.0,1967.0,1968.0,1969.0,1970.0,1971.0,1972.0,1973.0,1974.0,1975.0,1976.0,1977.0,1978.0,1979.0,1980.0,1981.0,1982.0,1983.0,1984.0,1985.0,1986.0,1987.0,1988.0,1989.0,1990.0,1991.0,1992.0,1993.0,1994.0,1995.0,1996.0,1997.0,1998.0,1999.0,2000.0,2001.0,2002.0,2003.0,2004.0,2005.0,2006.0,2007.0,2008.0,2009.0,2010.0,2011.0,2012.0,2013.0,2014.0,2015.0,2016.0,2017.0,2018.0,2019.0,2020.0,2021.0,2022.0,2023.0,2024.0,2025.0,2026.0,2027.0,2028.0,2029.0,2030.0,2031.0,2032.0,2033.0,2034.0,2035.0,2036.0,2037.0,2038.0,2039.0,2040.0,2041.0,2042.0,2043.0,2044.0,2045.0,2046.0,2047.0,2048.0,2049.0,2050.0,2051.0,2052.0,2053.0,2054.0,2055.0,2056.0,2057.0,2058.0,2059.0,2060.0,2061.0,2062.0,2063.0,2064.0,2065.0,2066.0,2067.0,2068.0,2069.0,2070.0,2071.0,2072.0,2073.0,2074.0,2075.0,2076.0,2077.0,2078.0,2079.0,2080.0,2081.0,2082.0,2083.0,2084.0,2085.0,2086.0,2087.0,2088.0,3156.0,2090.0,3157.0,2092.0,3158.0,2094.0,3159.0,2096.0,2097.0,2098.0,2099.0,2100.0,2101.0,2102.0,2103.0,2104.0,3152.0,2106.0,3153.0,2108.0,3154.0,2110.0,3155.0,2112.0,2113.0,2114.0,2115.0,2116.0,2117.0,2118.0,2119.0,2120.0,2121.0,2122.0,2123.0,2124.0,2125.0,2126.0,2127.0,2128.0,2129.0,2130.0,2131.0,2132.0,2133.0,2134.0,2135.0,2136.0,2137.0,2138.0,2139.0,2140.0,2141.0,2142.0,2143.0,2144.0,2145.0,2146.0,2147.0,2148.0,2149.0,2150.0,2151.0,2152.0,2153.0,2154.0,2155.0,2156.0,2157.0,2158.0,2159.0,2160.0,2161.0,2162.0,2163.0,2164.0,2165.0,2166.0,2167.0,2168.0,2169.0,2170.0,2171.0,2172.0,2173.0,2174.0,2175.0,2176.0,2177.0,2178.0,2179.0,2180.0,2181.0,2182.0,2183.0,2184.0,2185.0,2186.0,2187.0,2188.0,2189.0,2190.0,2191.0,2192.0,2193.0,2194.0,2195.0,2196.0,2197.0,2198.0,2199.0,2200.0,2201.0,2202.0,2203.0,2204.0,2205.0,2206.0,2207.0,2208.0,2209.0,2210.0,2211.0,2212.0,2213.0,2214.0,2215.0,2216.0,3164.0,2218.0,3165.0,2220.0,3166.0,2222.0,3167.0,2224.0,2225.0,2226.0,2227.0,2228.0,2229.0,2230.0,2231.0,2232.0,3160.0,2234.0,3161.0,2236.0,3162.0,2238.0,3163.0,2240.0,2241.0,2242.0,2243.0,2244.0,2245.0,2246.0,2247.0,2248.0,2249.0,2250.0,2251.0,2252.0,2253.0,2254.0,2255.0,2256.0,2257.0,2258.0,2259.0,2260.0,2261.0,2262.0,2263.0,2264.0,2265.0,2266.0,2267.0,2268.0,2269.0,2270.0,2271.0,2272.0,2273.0,2274.0,2275.0,2276.0,2277.0,2278.0,2279.0,2280.0,2281.0,2282.0,2283.0,2284.0,2285.0,2286.0,2287.0,2288.0,2289.0,2290.0,2291.0,2292.0,2293.0,2294.0,2295.0,2296.0,2297.0,2298.0,2299.0,2300.0,2301.0,2302.0,2303.0,2304.0,2305.0,2306.0,2307.0,2308.0,2309.0,2310.0,2311.0,2312.0,2313.0,2314.0,2315.0,2316.0,2317.0,2318.0,2319.0,2320.0,2321.0,2322.0,2323.0,2324.0,2325.0,2326.0,2327.0,2328.0,2329.0,2330.0,2331.0,2332.0,2333.0,2334.0,2335.0,2336.0,2337.0,2338.0,2339.0,2340.0,2341.0,2342.0,2343.0,2344.0,2345.0,2346.0,2347.0,2348.0,2349.0,2350.0,2351.0,2352.0,2353.0,2354.0,2355.0,2356.0,2357.0,2358.0,2359.0,2360.0,2361.0,2362.0,2363.0,2364.0,2365.0,2366.0,2367.0,2368.0,2369.0,2370.0,2371.0,2372.0,2373.0,2374.0,2375.0,2376.0,2377.0,2378.0,2379.0,2380.0,2381.0,2382.0,2383.0,2384.0,2385.0,2386.0,2387.0,2388.0,2389.0,2390.0,2391.0,2392.0,2393.0,2394.0,2395.0,2396.0,2397.0,2398.0,2399.0,2400.0,2401.0,2402.0,2403.0,2404.0,2405.0,2406.0,2407.0,2408.0,2409.0,2410.0,2411.0,2412.0,2413.0,2414.0,2415.0,2416.0,2417.0,2418.0,2419.0,2420.0,2421.0,2422.0,2423.0,2424.0,2425.0,2426.0,2427.0,2428.0,2429.0,2430.0,2431.0,2432.0,2433.0,2434.0,2435.0,2436.0,2437.0,2438.0,2439.0,2440.0,2441.0,2442.0,2443.0,2444.0,2445.0,2446.0,2447.0,2448.0,2449.0,2450.0,2451.0,2452.0,2453.0,2454.0,2455.0,2456.0,2457.0,2458.0,2459.0,2460.0,2461.0,2462.0,2463.0,2464.0,2465.0,2466.0,2467.0,2468.0,2469.0,2470.0,2471.0,2472.0,3172.0,2474.0,3173.0,2476.0,3174.0,2478.0,3175.0,2480.0,2481.0,2482.0,2483.0,2484.0,2485.0,2486.0,2487.0,2488.0,3168.0,2490.0,3169.0,2492.0,3170.0,2494.0,3171.0,2496.0,2497.0,2498.0,2499.0,2500.0,2501.0,2502.0,2503.0,2504.0,2505.0,2506.0,2507.0,2508.0,2509.0,2510.0,2511.0,2512.0,2513.0,2514.0,2515.0,2516.0,2517.0,2518.0,2519.0,2520.0,2521.0,2522.0,2523.0,2524.0,2525.0,2526.0,2527.0,2528.0,2529.0,2530.0,2531.0,2532.0,2533.0,2534.0,2535.0,2536.0,2537.0,2538.0,2539.0,2540.0,2541.0,2542.0,2543.0,2544.0,2545.0,2546.0,2547.0,2548.0,2549.0,2550.0,2551.0,2552.0,2553.0,2554.0,2555.0,2556.0,2557.0,2558.0,2559.0,2560.0,2561.0,2562.0,2563.0,2564.0,2565.0,2566.0,2567.0,2568.0,2569.0,2570.0,2571.0,2572.0,2573.0,2574.0,2575.0,2576.0,2577.0,2578.0,2579.0,2580.0,2581.0,2582.0,2583.0,2584.0,2585.0,2586.0,2587.0,2588.0,2589.0,2590.0,2591.0,2592.0,2593.0,2594.0,2595.0,2596.0,2597.0,2598.0,2599.0,2600.0,3180.0,2602.0,3181.0,2604.0,3182.0,2606.0,3183.0,2608.0,2609.0,2610.0,2611.0,2612.0,2613.0,2614.0,2615.0,2616.0,3176.0,2618.0,3177.0,2620.0,3178.0,2622.0,3179.0,2624.0,2625.0,2626.0,2627.0,2628.0,2629.0,2630.0,2631.0,2632.0,2633.0,2634.0,2635.0,2636.0,2637.0,2638.0,2639.0,2640.0,2641.0,2642.0,2643.0,2644.0,2645.0,2646.0,2647.0,2648.0,2649.0,2650.0,2651.0,2652.0,2653.0,2654.0,2655.0,2656.0,2657.0,2658.0,2659.0,2660.0,2661.0,2662.0,2663.0,2664.0,2665.0,2666.0,2667.0,2668.0,2669.0,2670.0,2671.0,2672.0,2673.0,2674.0,2675.0,2676.0,2677.0,2678.0,2679.0,2680.0,2681.0,2682.0,2683.0,2684.0,2685.0,2686.0,2687.0,2688.0,2689.0,2690.0,2691.0,2692.0,2693.0,2694.0,2695.0,2696.0,2697.0,2698.0,2699.0,2700.0,2701.0,2702.0,2703.0,2704.0,2705.0,2706.0,2707.0,2708.0,2709.0,2710.0,2711.0,2712.0,2713.0,2714.0,2715.0,2716.0,2717.0,2718.0,2719.0,2720.0,2721.0,2722.0,2723.0,2724.0,2725.0,2726.0,2727.0,2728.0,2729.0,2730.0,2731.0,2732.0,2733.0,2734.0,2735.0,2736.0,2737.0,2738.0,2739.0,2740.0,2741.0,2742.0,2743.0,2744.0,2745.0,2746.0,2747.0,2748.0,2749.0,2750.0,2751.0,2752.0,2753.0,2754.0,2755.0,2756.0,2757.0,2758.0,2759.0,2760.0,2761.0,2762.0,2763.0,2764.0,2765.0,2766.0,2767.0,2768.0,2769.0,2770.0,2771.0,2772.0,2773.0,2774.0,2775.0,2776.0,2777.0,2778.0,2779.0,2780.0,2781.0,2782.0,2783.0,2784.0,2785.0,2786.0,2787.0,2788.0,2789.0,2790.0,2791.0,2792.0,2793.0,2794.0,2795.0,2796.0,2797.0,2798.0,2799.0,2800.0,2801.0,2802.0,2803.0,2804.0,2805.0,2806.0,2807.0,2808.0,2809.0,2810.0,2811.0,2812.0,2813.0,2814.0,2815.0,2816.0,2817.0,2818.0,2819.0,2820.0,2821.0,2822.0,2823.0,2824.0,2825.0,2826.0,2827.0,2828.0,2829.0,2830.0,2831.0,2832.0,2833.0,2834.0,2835.0,2836.0,2837.0,2838.0,2839.0,2840.0,2841.0,2842.0,2843.0,2844.0,2845.0,2846.0,2847.0,2848.0,2849.0,2850.0,2851.0,2852.0,2853.0,2854.0,2855.0,2856.0,3188.0,2858.0,3189.0,2860.0,3190.0,2862.0,3191.0,2864.0,2865.0,2866.0,2867.0,2868.0,2869.0,2870.0,2871.0,2872.0,3184.0,2874.0,3185.0,2876.0,3186.0,2878.0,3187.0,2880.0,2881.0,2882.0,2883.0,2884.0,2885.0,2886.0,2887.0,2888.0,2889.0,2890.0,2891.0,2892.0,2893.0,2894.0,2895.0,2896.0,2897.0,2898.0,2899.0,2900.0,2901.0,2902.0,2903.0,2904.0,2905.0,2906.0,2907.0,2908.0,2909.0,2910.0,2911.0,2912.0,2913.0,2914.0,2915.0,2916.0,2917.0,2918.0,2919.0,2920.0,2921.0,2922.0,2923.0,2924.0,2925.0,2926.0,2927.0,2928.0,2929.0,2930.0,2931.0,2932.0,2933.0,2934.0,2935.0,2936.0,2937.0,2938.0,2939.0,2940.0,2941.0,2942.0,2943.0,2944.0,2945.0,2946.0,2947.0,2948.0,2949.0,2950.0,2951.0,2952.0,2953.0,2954.0,2955.0,2956.0,2957.0,2958.0,2959.0,2960.0,2961.0,2962.0,2963.0,2964.0,2965.0,2966.0,2967.0,2968.0,2969.0,2970.0,2971.0,2972.0,2973.0,2974.0,2975.0,2976.0,2977.0,2978.0,2979.0,2980.0,2981.0,2982.0,2983.0,2984.0,3196.0,2986.0,3197.0,2988.0,3198.0,2990.0,3199.0,2992.0,2993.0,2994.0,2995.0,2996.0,2997.0,2998.0,2999.0,3000.0,3192.0,3002.0,3193.0,3004.0,3194.0,3006.0,3195.0,3008.0,3009.0,3010.0,3011.0,3012.0,3013.0,3014.0,3015.0,3016.0,3017.0,3018.0,3019.0,3020.0,3021.0,3022.0,3023.0,3024.0,3025.0,3026.0,3027.0,3028.0,3029.0,3030.0,3031.0,3032.0,3033.0,3034.0,3035.0,3036.0,3037.0,3038.0,3039.0,3040.0,3041.0,3042.0,3043.0,3044.0,3045.0,3046.0,3047.0,3048.0,3049.0,3050.0,3051.0,3052.0,3053.0,3054.0,3055.0,3056.0,3057.0,3058.0,3059.0,3060.0,3061.0,3062.0,3063.0,3064.0,3065.0,3066.0,3067.0,3068.0,3069.0,3070.0,3071.0},
                                            std::vector<float>{3072.0,3073.0,3074.0,3075.0,3076.0,3077.0,3078.0,3079.0,3080.0,3081.0,3082.0,3083.0,3084.0,3085.0,3086.0,3087.0,3088.0,3089.0,3090.0,3091.0,3092.0,3093.0,3094.0,3095.0,3096.0,3097.0,3098.0,3099.0,3100.0,3101.0,3102.0,3103.0,3104.0,3105.0,3106.0,3107.0,3108.0,3109.0,3110.0,3111.0,3112.0,3113.0,3114.0,3115.0,3116.0,3117.0,3118.0,3119.0,3120.0,3121.0,3122.0,3123.0,3124.0,3125.0,3126.0,3127.0,3128.0,3129.0,3130.0,3131.0,3132.0,3133.0,3134.0,3135.0,3136.0,3137.0,3138.0,3139.0,3140.0,3141.0,3142.0,3143.0,3144.0,3145.0,3146.0,3147.0,3148.0,3149.0,3150.0,3151.0,3152.0,3153.0,3154.0,3155.0,3156.0,3157.0,3158.0,3159.0,3160.0,3161.0,3162.0,3163.0,3164.0,3165.0,3166.0,3167.0,3168.0,3169.0,3170.0,3171.0,3172.0,3173.0,3174.0,3175.0,3176.0,3177.0,3178.0,3179.0,3180.0,3181.0,3182.0,3183.0,3184.0,3185.0,3186.0,3187.0,3188.0,3189.0,3190.0,3191.0,3192.0,3193.0,3194.0,3195.0,3196.0,3197.0,3198.0,3199.0}
                                        ),

                                        // test 185
                                        // slices are: [0:,:4,2:6:2,7:3:-2,newaxis,...,1]
                                        // dtype is: uint32
                                        // input shape is: Shape{2,4,6,8,2,2,2}
                                        // slice shape is: Shape{2,4,2,2,1,2,2}
                                        // replacement shape is: Shape{2,4,2,2,1,2,2}
                                        // expected output shape is Shape{2,4,6,8,2,2,2}
                                        make_shared<DynReplaceSliceTestParams<uint32_t,uint32_t>>(
                                            true,
                                            element::u32,
                                            element::u32,
                                            Shape{2,4,6,8,2,2,2},
                                            Shape{2,4,2,2,1,2,2},
                                            std::vector<int64_t>{0,0,2,7,0,0,1},
                                            std::vector<int64_t>{0,4,6,3,0,0,0},
                                            std::vector<int64_t>{1,1,2,-2,1,1,1},
                                            AxisSet{1},
                                            AxisSet{0},
                                            AxisSet{4},
                                            AxisSet{6},
                                            AxisSet{5},
                                            std::vector<uint32_t>{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,3076,170,3077,172,3078,174,3079,176,177,178,179,180,181,182,183,184,3072,186,3073,188,3074,190,3075,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,293,294,295,296,3084,298,3085,300,3086,302,3087,304,305,306,307,308,309,310,311,312,3080,314,3081,316,3082,318,3083,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,541,542,543,544,545,546,547,548,549,550,551,552,3092,554,3093,556,3094,558,3095,560,561,562,563,564,565,566,567,568,3088,570,3089,572,3090,574,3091,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,3100,682,3101,684,3102,686,3103,688,689,690,691,692,693,694,695,696,3096,698,3097,700,3098,702,3099,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,930,931,932,933,934,935,936,3108,938,3109,940,3110,942,3111,944,945,946,947,948,949,950,951,952,3104,954,3105,956,3106,958,3107,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,991,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1037,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,3116,1066,3117,1068,3118,1070,3119,1072,1073,1074,1075,1076,1077,1078,1079,1080,3112,1082,3113,1084,3114,1086,3115,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,1120,1121,1122,1123,1124,1125,1126,1127,1128,1129,1130,1131,1132,1133,1134,1135,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1151,1152,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1171,1172,1173,1174,1175,1176,1177,1178,1179,1180,1181,1182,1183,1184,1185,1186,1187,1188,1189,1190,1191,1192,1193,1194,1195,1196,1197,1198,1199,1200,1201,1202,1203,1204,1205,1206,1207,1208,1209,1210,1211,1212,1213,1214,1215,1216,1217,1218,1219,1220,1221,1222,1223,1224,1225,1226,1227,1228,1229,1230,1231,1232,1233,1234,1235,1236,1237,1238,1239,1240,1241,1242,1243,1244,1245,1246,1247,1248,1249,1250,1251,1252,1253,1254,1255,1256,1257,1258,1259,1260,1261,1262,1263,1264,1265,1266,1267,1268,1269,1270,1271,1272,1273,1274,1275,1276,1277,1278,1279,1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,1312,1313,1314,1315,1316,1317,1318,1319,1320,3124,1322,3125,1324,3126,1326,3127,1328,1329,1330,1331,1332,1333,1334,1335,1336,3120,1338,3121,1340,3122,1342,3123,1344,1345,1346,1347,1348,1349,1350,1351,1352,1353,1354,1355,1356,1357,1358,1359,1360,1361,1362,1363,1364,1365,1366,1367,1368,1369,1370,1371,1372,1373,1374,1375,1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,1440,1441,1442,1443,1444,1445,1446,1447,1448,3132,1450,3133,1452,3134,1454,3135,1456,1457,1458,1459,1460,1461,1462,1463,1464,3128,1466,3129,1468,3130,1470,3131,1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,1702,1703,1704,3140,1706,3141,1708,3142,1710,3143,1712,1713,1714,1715,1716,1717,1718,1719,1720,3136,1722,3137,1724,3138,1726,3139,1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,1824,1825,1826,1827,1828,1829,1830,1831,1832,3148,1834,3149,1836,3150,1838,3151,1840,1841,1842,1843,1844,1845,1846,1847,1848,3144,1850,3145,1852,3146,1854,3147,1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,2080,2081,2082,2083,2084,2085,2086,2087,2088,3156,2090,3157,2092,3158,2094,3159,2096,2097,2098,2099,2100,2101,2102,2103,2104,3152,2106,3153,2108,3154,2110,3155,2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,2208,2209,2210,2211,2212,2213,2214,2215,2216,3164,2218,3165,2220,3166,2222,3167,2224,2225,2226,2227,2228,2229,2230,2231,2232,3160,2234,3161,2236,3162,2238,3163,2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399,2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,2464,2465,2466,2467,2468,2469,2470,2471,2472,3172,2474,3173,2476,3174,2478,3175,2480,2481,2482,2483,2484,2485,2486,2487,2488,3168,2490,3169,2492,3170,2494,3171,2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,2544,2545,2546,2547,2548,2549,2550,2551,2552,2553,2554,2555,2556,2557,2558,2559,2560,2561,2562,2563,2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,2576,2577,2578,2579,2580,2581,2582,2583,2584,2585,2586,2587,2588,2589,2590,2591,2592,2593,2594,2595,2596,2597,2598,2599,2600,3180,2602,3181,2604,3182,2606,3183,2608,2609,2610,2611,2612,2613,2614,2615,2616,3176,2618,3177,2620,3178,2622,3179,2624,2625,2626,2627,2628,2629,2630,2631,2632,2633,2634,2635,2636,2637,2638,2639,2640,2641,2642,2643,2644,2645,2646,2647,2648,2649,2650,2651,2652,2653,2654,2655,2656,2657,2658,2659,2660,2661,2662,2663,2664,2665,2666,2667,2668,2669,2670,2671,2672,2673,2674,2675,2676,2677,2678,2679,2680,2681,2682,2683,2684,2685,2686,2687,2688,2689,2690,2691,2692,2693,2694,2695,2696,2697,2698,2699,2700,2701,2702,2703,2704,2705,2706,2707,2708,2709,2710,2711,2712,2713,2714,2715,2716,2717,2718,2719,2720,2721,2722,2723,2724,2725,2726,2727,2728,2729,2730,2731,2732,2733,2734,2735,2736,2737,2738,2739,2740,2741,2742,2743,2744,2745,2746,2747,2748,2749,2750,2751,2752,2753,2754,2755,2756,2757,2758,2759,2760,2761,2762,2763,2764,2765,2766,2767,2768,2769,2770,2771,2772,2773,2774,2775,2776,2777,2778,2779,2780,2781,2782,2783,2784,2785,2786,2787,2788,2789,2790,2791,2792,2793,2794,2795,2796,2797,2798,2799,2800,2801,2802,2803,2804,2805,2806,2807,2808,2809,2810,2811,2812,2813,2814,2815,2816,2817,2818,2819,2820,2821,2822,2823,2824,2825,2826,2827,2828,2829,2830,2831,2832,2833,2834,2835,2836,2837,2838,2839,2840,2841,2842,2843,2844,2845,2846,2847,2848,2849,2850,2851,2852,2853,2854,2855,2856,3188,2858,3189,2860,3190,2862,3191,2864,2865,2866,2867,2868,2869,2870,2871,2872,3184,2874,3185,2876,3186,2878,3187,2880,2881,2882,2883,2884,2885,2886,2887,2888,2889,2890,2891,2892,2893,2894,2895,2896,2897,2898,2899,2900,2901,2902,2903,2904,2905,2906,2907,2908,2909,2910,2911,2912,2913,2914,2915,2916,2917,2918,2919,2920,2921,2922,2923,2924,2925,2926,2927,2928,2929,2930,2931,2932,2933,2934,2935,2936,2937,2938,2939,2940,2941,2942,2943,2944,2945,2946,2947,2948,2949,2950,2951,2952,2953,2954,2955,2956,2957,2958,2959,2960,2961,2962,2963,2964,2965,2966,2967,2968,2969,2970,2971,2972,2973,2974,2975,2976,2977,2978,2979,2980,2981,2982,2983,2984,3196,2986,3197,2988,3198,2990,3199,2992,2993,2994,2995,2996,2997,2998,2999,3000,3192,3002,3193,3004,3194,3006,3195,3008,3009,3010,3011,3012,3013,3014,3015,3016,3017,3018,3019,3020,3021,3022,3023,3024,3025,3026,3027,3028,3029,3030,3031,3032,3033,3034,3035,3036,3037,3038,3039,3040,3041,3042,3043,3044,3045,3046,3047,3048,3049,3050,3051,3052,3053,3054,3055,3056,3057,3058,3059,3060,3061,3062,3063,3064,3065,3066,3067,3068,3069,3070,3071},
                                            std::vector<uint32_t>{3072,3073,3074,3075,3076,3077,3078,3079,3080,3081,3082,3083,3084,3085,3086,3087,3088,3089,3090,3091,3092,3093,3094,3095,3096,3097,3098,3099,3100,3101,3102,3103,3104,3105,3106,3107,3108,3109,3110,3111,3112,3113,3114,3115,3116,3117,3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,3128,3129,3130,3131,3132,3133,3134,3135,3136,3137,3138,3139,3140,3141,3142,3143,3144,3145,3146,3147,3148,3149,3150,3151,3152,3153,3154,3155,3156,3157,3158,3159,3160,3161,3162,3163,3164,3165,3166,3167,3168,3169,3170,3171,3172,3173,3174,3175,3176,3177,3178,3179,3180,3181,3182,3183,3184,3185,3186,3187,3188,3189,3190,3191,3192,3193,3194,3195,3196,3197,3198,3199}
                                        ),

                                        // test 186
                                        // slices are: [...,...]
                                        // dtype is: int32
                                        // input shape is: Shape{2,4,6,8,2,2,2}
                                        // slice shape is: Shape{}
                                        // replacement shape is: Shape{}
                                        // failure is expected (numpy getitem failed,numpy setitem failed)
                                        make_shared<DynReplaceSliceTestParams<int32_t,int32_t>>(
                                            false,
                                            element::i32,
                                            element::i32,
                                            Shape{2,4,6,8,2,2,2},
                                            Shape{},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{0,0},
                                            std::vector<int64_t>{1,1},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{},
                                            AxisSet{0,1},
                                            std::vector<int32_t>{},
                                            std::vector<int32_t>{3072}
                                        ),
                                    })));
// clang-format on
