//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// It takes quite a while to compute the results.
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// To regenerate:
//
//   $ cd <ngraph source dir>/test
//   $ ./update_convolution_reference.sh
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
//
// clang-format off

#include <cmath>

#include "gtest/gtest.h"

#include "ngraph/ngraph.hpp"
#include "util/test_tools.hpp"
#include "util/autodiff/numeric_compare.hpp"
#include "util/all_close_f.hpp"
#include "util/test_control.hpp"

using namespace std;
using namespace ngraph;

static string s_manifest = "${MANIFEST}";

// for float this will be 18 bits matching
// for bfloat this will be 6 bits matching
constexpr int three_quarters_of_available_bits = (MAX_FLOAT_BITS * 3) / 4;
constexpr int tolerance = FLOAT_MANTISSA_BITS - three_quarters_of_available_bits;


// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_1item)
{
    Shape shape_a{1,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{1,2,2,4};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0}, // below_pads
                                                                  CoordinateDiff{0,0}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.63940430f,0.04736328f,-1.37304688f,-0.56201172f,-0.46606445f,0.48364258f,1.40625000f,0.15795898f,-0.55004883f,0.73339844f,0.10668945f,-0.95751953f,-0.96679688f,-0.21215820f,1.21826172f,-0.91894531f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_1item_padded_1_1x1_1)
{
    Shape shape_a{1,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{1,2,4,6};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{1,1}, // below_pads
                                                                  CoordinateDiff{1,1}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{-0.24145508f,-0.57446289f,-0.10546875f,0.44555664f,0.23583984f,0.05273438f,0.17089844f,0.63940430f,0.04736328f,-1.37304688f,-0.56201172f,0.24462891f,-0.06030273f,-0.46606445f,0.48364258f,1.40625000f,0.15795898f,-0.16528320f,0.54687500f,0.62915039f,-0.53955078f,-0.37622070f,0.07641602f,-0.24145508f,0.59838867f,0.11962891f,-0.80004883f,-0.01245117f,0.11303711f,0.05126953f,0.85449219f,-0.55004883f,0.73339844f,0.10668945f,-0.95751953f,0.30786133f,1.18969727f,-0.96679688f,-0.21215820f,1.21826172f,-0.91894531f,0.24780273f,0.54687500f,-0.13647461f,-0.47973633f,0.30566406f,-0.23461914f,0.03369141f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_1item_padded_2_3x4_5)
{
    Shape shape_a{1,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{1,2,8,12};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{2,3}, // below_pads
                                                                  CoordinateDiff{4,5}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.24145508f,-0.57446289f,-0.10546875f,0.44555664f,0.23583984f,0.05273438f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.17089844f,0.63940430f,0.04736328f,-1.37304688f,-0.56201172f,0.24462891f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.06030273f,-0.46606445f,0.48364258f,1.40625000f,0.15795898f,-0.16528320f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.54687500f,0.62915039f,-0.53955078f,-0.37622070f,0.07641602f,-0.24145508f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.59838867f,0.11962891f,-0.80004883f,-0.01245117f,0.11303711f,0.05126953f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.85449219f,-0.55004883f,0.73339844f,0.10668945f,-0.95751953f,0.30786133f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,1.18969727f,-0.96679688f,-0.21215820f,1.21826172f,-0.91894531f,0.24780273f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.54687500f,-0.13647461f,-0.47973633f,0.30566406f,-0.23461914f,0.03369141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,2,4};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0}, // below_pads
                                                                  CoordinateDiff{0,0}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.63940430f,0.04736328f,-1.37304688f,-0.56201172f,-0.46606445f,0.48364258f,1.40625000f,0.15795898f,-0.55004883f,0.73339844f,0.10668945f,-0.95751953f,-0.96679688f,-0.21215820f,1.21826172f,-0.91894531f,0.12402344f,0.76953125f,1.20581055f,0.65917969f,0.62841797f,-0.46386719f,-0.68554688f,-0.82348633f,0.22509766f,-0.60864258f,-0.45166016f,-0.05249023f,0.99462891f,-1.09497070f,-0.75244141f,0.56250000f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items_strided)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,1,2};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{2,2},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0}, // below_pads
                                                                  CoordinateDiff{0,0}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.63940430f,-1.37304688f,-0.55004883f,0.10668945f,0.12402344f,1.20581055f,0.22509766f,-0.45166016f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items_strided_padded)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,6,7};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{2,2},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{4,2}, // below_pads
                                                                  CoordinateDiff{5,7}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.63940430f,-1.37304688f,0.24462891f,0.0f,0.0f,0.0f,0.0f,0.62915039f,-0.37622070f,-0.24145508f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.55004883f,0.10668945f,0.30786133f,0.0f,0.0f,0.0f,0.0f,-0.13647461f,0.30566406f,0.03369141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.12402344f,1.20581055f,0.13427734f,0.0f,0.0f,0.0f,0.0f,0.21923828f,-0.45190430f,0.35693359f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.22509766f,-0.45166016f,0.29394531f,0.0f,0.0f,0.0f,0.0f,0.44653320f,-0.24853516f,-0.04980469f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items_strided_padded_same)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,3,4};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{2,2},        // move_strides
                                                                  Strides{1,1},        // filter_dilation
                                                                  CoordinateDiff{2,2}, // below_pads
                                                                  CoordinateDiff{2,2}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.0f,0.0f,0.0f,0.0f,0.0f,0.63940430f,-1.37304688f,0.24462891f,0.0f,0.62915039f,-0.37622070f,-0.24145508f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.55004883f,0.10668945f,0.30786133f,0.0f,-0.13647461f,0.30566406f,0.03369141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.12402344f,1.20581055f,0.13427734f,0.0f,0.21923828f,-0.45190430f,0.35693359f,0.0f,0.0f,0.0f,0.0f,0.0f,0.22509766f,-0.45166016f,0.29394531f,0.0f,0.44653320f,-0.24853516f,-0.04980469f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items_dilated)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,1,3};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{2,2},        // filter_dilation
                                                                  CoordinateDiff{0,0}, // below_pads
                                                                  CoordinateDiff{0,0}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{-0.09863281f,0.06884766f,0.20092773f,-1.71069336f,0.15673828f,0.16845703f,0.95458984f,0.20971680f,0.23779297f,0.19921875f,-0.86987305f,0.44311523f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_2d_2items_dilated_padded)
{
    Shape shape_a{2,1,3,5};
    Shape shape_b{2,1,2,2};
    Shape shape_r{2,2,10,12};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1},        // move_strides
                                                                  Strides{2,2},        // filter_dilation
                                                                  CoordinateDiff{4,2}, // below_pads
                                                                  CoordinateDiff{5,7}, // above_pads
                                                                  Strides{1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.24145508f,-0.19653320f,-0.17578125f,-0.17846680f,0.35009766f,0.20214844f,0.05273438f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.19653320f,0.19653320f,-0.62768555f,0.01000977f,-0.30444336f,-0.46582031f,0.30761719f,0.0f,0.0f,0.0f,0.0f,0.0f,0.00805664f,0.32714844f,-0.09863281f,0.06884766f,0.20092773f,-0.46997070f,0.13916016f,0.0f,0.0f,0.0f,0.0f,0.0f,0.29907227f,-0.29907227f,0.85449219f,0.08544922f,0.29931641f,0.55639648f,-0.36743164f,0.0f,0.0f,0.0f,0.0f,0.0f,0.54687500f,-0.04272461f,0.18481445f,0.16967773f,-0.79492188f,0.27294922f,-0.24145508f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.59838867f,0.48706055f,-0.86840820f,-0.61914062f,0.22412109f,0.19653320f,0.05126953f,0.0f,0.0f,0.0f,0.0f,0.0f,0.48706055f,-0.48706055f,0.49414062f,1.03662109f,-0.97412109f,-0.45288086f,0.29907227f,0.0f,0.0f,0.0f,0.0f,0.0f,1.25805664f,0.22949219f,-1.71069336f,0.15673828f,0.16845703f,-0.18847656f,0.20532227f,0.0f,0.0f,0.0f,0.0f,0.0f,0.29907227f,-0.29907227f,0.43579102f,0.50415039f,-0.38256836f,-0.07763672f,0.05126953f,0.0f,0.0f,0.0f,0.0f,0.0f,0.54687500f,-0.04272461f,-0.58081055f,0.22949219f,-0.11303711f,-0.03808594f,0.03369141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.19653320f,-0.21899414f,-0.52099609f,-0.37646484f,-0.25537109f,-0.05273438f,0.12304688f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.27514648f,-0.14599609f,-0.16674805f,0.11401367f,0.59277344f,0.53613281f,0.28125000f,0.0f,0.0f,0.0f,0.0f,0.0f,0.40576172f,0.05810547f,0.95458984f,0.20971680f,0.23779297f,0.34423828f,-0.44580078f,0.0f,0.0f,0.0f,0.0f,0.0f,0.41870117f,0.22216797f,0.11279297f,-0.24829102f,-0.76684570f,-0.64038086f,-0.33593750f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.16235352f,0.41870117f,-0.34472656f,0.24096680f,0.11206055f,-0.33593750f,0.35693359f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.48706055f,0.54272461f,0.22973633f,-0.24975586f,-0.51953125f,-0.05126953f,0.11962891f,0.0f,0.0f,0.0f,0.0f,0.0f,0.68188477f,0.36181641f,-1.07275391f,-1.07104492f,-0.04370117f,0.52124023f,0.27343750f,0.0f,0.0f,0.0f,0.0f,0.0f,0.03466797f,1.01513672f,0.19921875f,-0.86987305f,0.44311523f,0.26464844f,-0.27001953f,0.0f,0.0f,0.0f,0.0f,0.0f,0.41870117f,0.22216797f,-0.47338867f,-0.55932617f,-0.20458984f,0.08935547f,0.04687500f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.16235352f,0.41870117f,-0.11743164f,-0.34521484f,0.31542969f,0.04687500f,-0.04980469f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_3d_2items)
{
    Shape shape_a{2,1,3,5,8};
    Shape shape_b{2,1,2,2,3};
    Shape shape_r{2,2,2,4,6};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1,1},        // move_strides
                                                                  Strides{1,1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0}, // above_pads
                                                                  Strides{1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{-0.76611328f,-0.37377930f,0.05419922f,-1.46704102f,1.40869141f,0.15820312f,-1.23657227f,0.38818359f,1.42211914f,-0.11767578f,0.81152344f,-1.07055664f,3.22143555f,0.13281250f,-0.63159180f,1.78173828f,3.11206055f,0.34912109f,-0.57080078f,-0.22802734f,0.51318359f,-1.12841797f,1.09692383f,-0.96557617f,-0.77368164f,-0.38989258f,-0.64208984f,-1.57104492f,1.82055664f,-0.52197266f,2.91577148f,-1.57250977f,0.90087891f,0.23559570f,0.04711914f,1.46191406f,1.23217773f,-0.93408203f,2.12255859f,1.10644531f,0.44970703f,0.18383789f,0.31860352f,-1.31811523f,-0.19506836f,-0.89013672f,0.26708984f,-0.59594727f,1.67333984f,-0.38427734f,0.24902344f,-0.10449219f,-1.65893555f,0.61254883f,-2.50073242f,1.25170898f,-1.70629883f,-0.48510742f,0.54565430f,-3.04125977f,0.75122070f,0.91699219f,0.76977539f,0.08471680f,-0.00561523f,0.63964844f,-1.52880859f,-0.52319336f,-0.85375977f,-0.00415039f,-0.93139648f,-1.01831055f,-2.26000977f,-1.10961914f,-0.60253906f,-0.19189453f,-0.01928711f,-0.18530273f,0.59814453f,1.95849609f,1.08593750f,0.51855469f,2.62377930f,0.93969727f,-1.34863281f,-0.60693359f,-2.68676758f,-0.85766602f,-0.33374023f,-0.03344727f,1.85034180f,3.02880859f,2.55957031f,1.70117188f,0.78881836f,0.54052734f,-0.42114258f,-0.85791016f,-0.70190430f,0.78466797f,0.63037109f,-1.91748047f,3.03222656f,0.75244141f,-1.20092773f,0.05493164f,-0.63378906f,1.19799805f,-0.21215820f,-0.46508789f,1.04589844f,1.54492188f,1.10473633f,-0.52636719f,0.01684570f,0.37817383f,0.21118164f,1.35327148f,0.18115234f,-0.10961914f,-0.33496094f,-0.71020508f,1.62011719f,0.65502930f,-1.64843750f,0.08471680f,-0.16943359f,2.75341797f,0.91308594f,-0.70410156f,-0.24804688f,-1.36669922f,-0.67114258f,-0.60498047f,0.28002930f,-0.31640625f,-3.03247070f,0.29589844f,-0.43310547f,0.45874023f,1.15478516f,0.78247070f,0.13134766f,1.35888672f,-0.03295898f,-1.05541992f,1.11718750f,-1.75048828f,1.37475586f,-0.46411133f,-0.33178711f,0.35083008f,0.30932617f,1.63867188f,-2.34960938f,0.08154297f,-2.11035156f,-0.04125977f,-1.25683594f,-0.55102539f,2.52856445f,1.39160156f,0.54125977f,-1.18896484f,0.64282227f,-3.41772461f,-0.38769531f,0.40527344f,-1.01757812f,0.58227539f,-0.73730469f,1.31420898f,0.30200195f,1.88549805f,0.05712891f,0.60278320f,-0.28051758f,0.27856445f,1.75756836f,-0.73510742f,1.60791016f,-1.01855469f,0.01855469f,0.62988281f,0.17065430f,-1.33496094f,-0.29711914f,0.80639648f,0.93774414f,0.37817383f,-0.29516602f,1.05224609f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_2items)
{
    Shape shape_a{2,1,3,5,8,7};
    Shape shape_b{2,1,2,2,3,1};
    Shape shape_r{2,2,2,4,6,7};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1,1,1},        // move_strides
                                                                  Strides{1,1,1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0,0}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{1.29785156f,0.55981445f,-1.20166016f,-1.23828125f,-0.33911133f,0.71533203f,-0.68969727f,-0.46899414f,2.65209961f,1.97753906f,2.05615234f,-0.27368164f,-0.08959961f,-1.13964844f,-0.26782227f,0.07910156f,-1.02856445f,0.03320312f,-1.25634766f,0.70507812f,1.62988281f,-2.58081055f,0.43212891f,-0.69091797f,1.39184570f,2.00683594f,1.54394531f,1.97509766f,-0.67797852f,1.69311523f,0.30688477f,0.01635742f,0.91088867f,-0.95947266f,-3.15405273f,1.59692383f,-0.85961914f,-1.61206055f,0.45385742f,-0.68432617f,-1.06103516f,-0.15747070f,0.33349609f,0.61181641f,0.17285156f,-0.87939453f,0.06347656f,-1.91381836f,0.38964844f,1.26196289f,1.44189453f,-1.35205078f,0.73632812f,-1.43627930f,1.13525391f,-0.38012695f,0.50585938f,0.69018555f,-2.17944336f,1.95849609f,0.10424805f,0.53320312f,0.31835938f,-1.94311523f,-0.10498047f,2.24169922f,0.89355469f,1.73046875f,1.78076172f,-0.27368164f,-0.59301758f,0.15820312f,-1.04614258f,-0.43725586f,0.64062500f,-0.68457031f,1.46850586f,1.58349609f,-0.31860352f,1.26098633f,-0.30664062f,-1.64892578f,1.17114258f,1.04052734f,-0.16162109f,0.43945312f,-2.62426758f,-1.36352539f,0.53808594f,-1.84155273f,-0.65185547f,0.07714844f,-2.80444336f,0.90283203f,0.86596680f,-0.51391602f,-1.20117188f,-2.43017578f,-2.32226562f,-0.13696289f,0.32202148f,-0.06689453f,2.04248047f,-1.74584961f,2.82519531f,-1.48559570f,0.82421875f,1.29150391f,0.86596680f,-0.63842773f,1.70532227f,2.37426758f,1.10424805f,2.09814453f,0.31176758f,2.46582031f,-0.87939453f,-0.73266602f,-2.09082031f,1.38476562f,-2.14404297f,-0.52050781f,0.28662109f,-1.48071289f,-1.76953125f,2.33618164f,0.02148438f,-0.50268555f,1.06152344f,-0.98461914f,-0.79516602f,2.15405273f,-1.21020508f,2.42236328f,-1.57592773f,1.88110352f,0.29760742f,1.36889648f,-0.11962891f,0.05151367f,-2.50341797f,-1.51000977f,0.67675781f,0.77539062f,0.81152344f,-1.33691406f,2.49902344f,2.36499023f,1.10449219f,-0.23925781f,1.49829102f,-0.77514648f,0.00097656f,-0.91821289f,1.46801758f,1.12768555f,-0.25048828f,-0.27368164f,1.26098633f,0.93164062f,-0.95117188f,0.18579102f,-0.26879883f,0.27685547f,0.29443359f,-0.38354492f,-1.12060547f,1.02270508f,-0.86621094f,2.05004883f,-1.72192383f,-0.48876953f,-0.73901367f,-1.06567383f,0.44238281f,-0.54003906f,2.60180664f,-0.41748047f,-1.20190430f,-1.64208984f,-1.92138672f,1.25634766f,-1.35009766f,-1.65869141f,2.16455078f,-0.12646484f,0.06445312f,1.25488281f,-1.04174805f,-1.20947266f,-0.49707031f,-1.78173828f,-0.22485352f,0.14941406f,0.54443359f,-0.10449219f,-0.43798828f,-0.20751953f,0.87524414f,2.68994141f,0.22192383f,-0.48950195f,0.23291016f,-0.12084961f,0.60791016f,2.52197266f,-1.16186523f,2.59472656f,2.02050781f,-0.15795898f,-0.00244141f,-0.15673828f,1.49316406f,-0.99218750f,0.36010742f,-2.36035156f,2.31787109f,1.12646484f,-0.65136719f,0.08447266f,-1.82031250f,-1.20092773f,-0.37939453f,0.29248047f,0.50219727f,0.17358398f,-1.28173828f,-0.44921875f,-0.14111328f,0.35351562f,-0.29028320f,1.01660156f,0.76977539f,-0.25610352f,0.23291016f,-0.01928711f,0.14843750f,2.52685547f,-1.49780273f,-0.90747070f,1.30615234f,-0.02026367f,1.84692383f,0.23852539f,0.57543945f,1.09326172f,1.00805664f,-0.81738281f,0.39819336f,0.15112305f,-1.10668945f,-0.17602539f,-1.08325195f,1.23168945f,1.35400391f,0.47387695f,0.07324219f,1.06420898f,-0.93017578f,2.04516602f,-2.17138672f,-0.26171875f,0.44531250f,0.09790039f,-1.36157227f,-2.91821289f,1.41723633f,0.03564453f,-0.70507812f,0.76953125f,0.83178711f,-1.80615234f,-0.43359375f,-1.16967773f,0.62280273f,0.49755859f,-1.00244141f,1.18945312f,2.63916016f,0.44653320f,-1.15942383f,0.99902344f,0.53320312f,-0.17138672f,2.48706055f,-0.95898438f,0.64770508f,-0.51586914f,0.23193359f,-0.76269531f,1.80590820f,-1.70214844f,1.70776367f,2.15820312f,-2.48095703f,-0.54296875f,-0.79736328f,-1.19824219f,-0.45336914f,-2.20532227f,-0.98608398f,0.73217773f,-0.91040039f,-0.07250977f,-1.51684570f,0.61157227f,1.23901367f,-1.61206055f,0.98193359f,0.22070312f,0.35107422f,1.93676758f,0.18774414f,1.70361328f,0.11181641f,-1.84106445f,-0.54956055f,0.27001953f,-0.19140625f,1.11279297f,-0.59448242f,0.08984375f,-1.63647461f,0.75195312f,0.32666016f,0.24658203f,0.22778320f,1.17675781f,-1.09545898f,0.66845703f,1.83203125f,0.83203125f,0.40136719f,-1.00512695f,-0.33056641f,-0.38525391f,-0.93212891f,-0.34350586f,1.87744141f,1.14233398f,-0.58935547f,0.87036133f,0.90722656f,-1.45336914f,-2.60180664f,3.31250000f,-0.85058594f,1.00732422f,-0.20385742f,1.47851562f,0.11816406f,-1.13891602f,-0.74731445f,-0.72851562f,-0.27148438f,1.24511719f,-0.73925781f,0.64892578f,-0.20288086f,3.02465820f,1.16625977f,0.44580078f,-2.06445312f,1.92163086f,0.01000977f,-0.79272461f,1.49658203f,0.52807617f,0.51025391f,0.37792969f,-0.32714844f,-1.71069336f,-0.34741211f,-0.70947266f,1.79711914f,0.23315430f,-1.53637695f,1.15429688f,0.22583008f,-0.70336914f,-1.41674805f,-2.10644531f,-0.78710938f,-0.23266602f,-0.33862305f,-0.95166016f,1.51977539f,-0.56567383f,0.42602539f,0.01123047f,1.44506836f,-0.68945312f,1.02807617f,-0.08666992f,-0.05541992f,-0.05175781f,-1.19360352f,-1.15502930f,-1.27636719f,-0.46240234f,0.16967773f,-2.53100586f,-0.42871094f,-2.39794922f,0.69531250f,-2.37426758f,2.02001953f,-0.58276367f,-0.28808594f,0.24560547f,-0.88037109f,-0.82885742f,-0.98437500f,-2.81274414f,1.43090820f,0.74682617f,-1.93603516f,0.14648438f,1.43212891f,-2.02270508f,0.34765625f,-0.07177734f,0.56127930f,0.44165039f,2.17309570f,-0.22290039f,-0.13500977f,0.60888672f,1.95874023f,-1.05126953f,-0.48779297f,-0.48999023f,-0.13452148f,1.61425781f,1.29077148f,2.00561523f,-0.72778320f,0.08837891f,0.57031250f,2.77709961f,-0.79760742f,-0.90625000f,0.15307617f,-1.02001953f,-1.07958984f,1.54028320f,-0.32031250f,-0.58959961f,-0.32104492f,-0.35839844f,1.77734375f,-1.30029297f,-1.15112305f,-0.02880859f,0.24658203f,-0.32666016f,1.33886719f,0.30932617f,-1.28222656f,2.34790039f,0.50024414f,0.50488281f,1.34350586f,-2.43090820f,-1.70458984f,0.73242188f,-1.23535156f,-0.91870117f,-0.91918945f,0.68481445f,1.73022461f,-1.32299805f,0.54150391f,-0.33081055f,0.65112305f,0.41430664f,-0.40771484f,-3.04418945f,-0.73461914f,0.02050781f,-2.10498047f,0.22045898f,-2.17895508f,0.57006836f,0.54736328f,2.30712891f,1.34472656f,1.91381836f,-0.16992188f,-1.12207031f,0.62231445f,-1.73681641f,1.30151367f,0.57397461f,-1.36401367f,-0.65502930f,2.04077148f,-0.82104492f,-0.10009766f,0.65625000f,1.09472656f,-0.75805664f,-0.47924805f,0.67260742f,1.36718750f,0.09204102f,-1.68652344f,-0.38842773f,2.14941406f,-0.00927734f,1.05151367f,0.43188477f,-1.44580078f,0.42626953f,1.76953125f,0.27880859f,0.27270508f,-1.03076172f,1.63012695f,0.73974609f,0.02978516f,1.47875977f,2.11401367f,-0.69653320f,0.01440430f,-1.21850586f,2.28222656f,-2.89257812f,0.78002930f,0.62670898f,1.37792969f,-1.82861328f,0.00732422f,-0.79077148f,-0.51074219f,0.85986328f,-0.26611328f,1.62719727f,-1.67163086f,1.53857422f,1.22338867f,-1.79614258f,-0.02514648f,0.22607422f,0.29003906f,-0.46850586f,-0.38989258f,0.24365234f,0.23266602f,-0.35839844f,0.01928711f,-1.52612305f,-0.58984375f,-2.65771484f,2.45898438f,-1.68334961f,-0.06030273f,0.45263672f,-0.39135742f,-0.35424805f,-0.93139648f,-1.60717773f,-0.40917969f,0.13549805f,-2.09179688f,-1.21679688f,1.29077148f,-0.96191406f,-0.97949219f,2.22265625f,3.01025391f,1.09912109f,-2.28076172f,1.83911133f,-0.99658203f,0.90087891f,0.99169922f,-0.89453125f,-0.85839844f,-0.17236328f,0.62231445f,-0.09497070f,-0.57885742f,0.84179688f,0.46630859f,-0.13232422f,-2.66088867f,0.93212891f,1.02172852f,0.30859375f,-1.03808594f,0.26904297f,-2.62475586f,0.97705078f,0.19482422f,-0.65283203f,-1.37622070f,3.02319336f,0.23779297f,-0.03149414f,0.62255859f,0.89746094f,-0.23730469f,-0.47924805f,-0.59326172f,-1.11035156f,-1.02416992f,-0.29174805f,1.37670898f,1.16064453f,-1.77246094f,0.66992188f,0.49853516f,-0.27636719f,0.69653320f,-0.03393555f,2.47778320f,-0.55639648f,-0.80664062f,1.12939453f,0.17944336f,-1.73095703f,-0.41040039f,2.87988281f,-1.23583984f,-0.40625000f,-0.86596680f,-0.22583008f,-0.45532227f,-1.34545898f,1.37744141f,0.24584961f,-0.36035156f,-1.09985352f,1.61718750f,-1.21655273f,1.48535156f,2.03417969f,0.25341797f,0.30322266f,1.44287109f,-0.41088867f,-1.45556641f,-0.93237305f,-0.65625000f,0.34472656f,0.76391602f,-1.84155273f,2.43017578f,-1.06982422f,1.30004883f,0.31103516f,0.98291016f,1.52294922f,-1.72851562f,-0.99121094f,-0.14672852f,1.71240234f,0.60839844f,1.46777344f,0.04492188f,1.19799805f,1.59790039f,2.69238281f,0.80004883f,-0.71313477f,-0.90258789f,-1.99609375f,-1.71362305f,0.08691406f,1.59472656f,-0.58569336f,-0.79687500f,-1.18505859f,-0.29394531f,0.72290039f,-0.54614258f,0.44116211f,-1.60083008f,-0.52539062f,-2.47265625f,0.60571289f,1.07763672f,-0.77050781f,-0.84863281f,-1.16748047f,-1.96240234f,0.02050781f,2.52490234f,-1.59838867f,-0.18237305f,-1.07250977f,-0.22851562f,0.71826172f,0.22241211f,0.33715820f,-0.39379883f,0.73706055f,-1.10986328f,1.13427734f,1.39624023f,2.31933594f,0.02905273f,1.94433594f,-1.17382812f,1.33984375f,-0.85717773f,-1.77270508f,0.85595703f,1.98120117f,0.14379883f,-1.10864258f,-0.29296875f,0.05883789f,-1.19213867f,-1.38647461f,-1.47753906f,-1.19848633f,-0.86230469f,0.68090820f,-2.12866211f,-0.48950195f,-1.05981445f,1.72167969f,1.04467773f,0.16259766f,0.46191406f,-1.02514648f,1.64916992f,-0.43261719f,1.25903320f,-1.35571289f,1.79882812f,2.56225586f,0.92626953f,0.86108398f,2.23461914f,-0.03442383f,-1.09179688f,-0.66821289f,1.34008789f,-1.46264648f,-0.13476562f,-1.53320312f,-0.56787109f,1.44360352f,-0.84619141f,-2.58081055f,1.23291016f,-0.02001953f,-1.45654297f,0.50366211f,1.08715820f,1.41796875f,-2.37402344f,0.63964844f,2.24462891f,-0.51098633f,0.59326172f,-0.32226562f,-0.83349609f,2.11157227f,-1.22558594f,0.73461914f,-0.60937500f,-0.68066406f,0.91821289f,-1.27490234f,-0.66235352f,-0.51391602f,0.08642578f,0.23925781f,-1.21582031f,-1.97338867f,1.85180664f,0.79980469f,-0.43237305f,1.97583008f,2.67407227f,1.15087891f,-0.06616211f,1.34008789f,0.11767578f,-0.83642578f,-0.34863281f,-0.54003906f,-0.03540039f,-0.13281250f,0.10839844f,-0.56420898f,0.72656250f,0.17822266f,-0.42919922f,-1.66113281f,-1.57031250f,-2.17065430f,1.01953125f,-1.39916992f,-0.57885742f,-2.04003906f,2.02392578f,1.13085938f,-2.17358398f,-0.50976562f,-0.46191406f,-0.09692383f,-0.18896484f,0.93383789f,1.80810547f,-0.98193359f,0.44262695f,0.14843750f,0.38769531f,0.69824219f,-2.67651367f,-0.73828125f,-0.18920898f,-1.60278320f,1.56689453f,1.70312500f,1.83642578f,-0.13696289f,-0.25878906f,-1.88403320f,0.89306641f,-1.71850586f,0.29931641f,-1.22338867f,-0.01464844f,1.02099609f,1.64599609f,-1.75219727f,1.60180664f,-0.89477539f,2.23608398f,0.00122070f,-1.00317383f,-0.76464844f,-0.14746094f,2.10864258f,-0.64355469f,-1.75683594f,1.52050781f,-0.58984375f,0.93457031f,0.06201172f,0.96215820f,-3.10253906f,-1.08789062f,0.50634766f,1.79638672f,2.40893555f,0.29248047f,0.60107422f,0.92163086f,-0.98046875f,0.65869141f,-1.27587891f,-0.63281250f,1.53857422f,-0.20654297f,0.10986328f,1.52905273f,-0.62817383f,0.79296875f,0.14892578f,-0.02514648f,-0.22021484f,0.03149414f,-2.26586914f,1.11816406f,-0.58862305f,-2.04296875f,-1.90380859f,2.66455078f,1.52734375f,0.42089844f,0.52490234f,-0.80297852f,-0.48950195f,-1.50463867f,-0.32104492f,-0.05444336f,1.87451172f,0.63403320f,-0.57958984f,1.39038086f,-0.29785156f,1.06787109f,0.69848633f,0.12402344f,-0.22460938f,0.12329102f,-1.49804688f,-1.20849609f,-0.64086914f,-0.33007812f,-0.19262695f,0.80786133f,1.60473633f,1.03564453f,-0.06762695f,-2.23437500f,-0.01391602f,-0.42749023f,-0.74316406f,-1.20141602f,1.69238281f,3.07006836f,0.83593750f,-0.80053711f,0.29833984f,1.18652344f,0.50903320f,-1.90576172f,-1.05053711f,1.15844727f,2.78906250f,-0.87841797f,-0.04858398f,-0.92114258f,0.08837891f,1.25073242f,0.21899414f,0.60351562f,-1.56933594f,-0.63671875f,-1.10351562f,1.32641602f,-1.54785156f,2.63183594f,-0.25756836f,1.26953125f,-0.67382812f,-1.11328125f,-2.23925781f,0.23315430f,-0.79199219f,1.12866211f,0.29760742f,0.24731445f,2.09155273f,0.04345703f,-0.55468750f,-1.52465820f,-0.09008789f,-1.92431641f,-0.33300781f,-0.63940430f,2.81250000f,0.74096680f,-0.16455078f,0.31494141f,0.89550781f,0.17797852f,-0.82983398f,0.32202148f,0.52172852f,1.91479492f,0.06054688f,-1.71752930f,-2.71435547f,-0.96313477f,0.71484375f,-0.39331055f,1.80126953f,-0.87084961f,-0.29248047f,-1.81713867f,0.68994141f,-0.85791016f,-0.95849609f,-2.99780273f,-2.92138672f,0.34643555f,2.03662109f,-2.38012695f,-0.02563477f,0.75415039f,0.09570312f,1.13037109f,-2.02832031f,-0.50903320f,1.06787109f,0.86865234f,1.37817383f,1.02441406f,-0.46337891f,0.02954102f,1.11743164f,-1.81274414f,-2.37011719f,1.96289062f,-0.42602539f,0.41503906f,0.68212891f,-0.78808594f,1.49658203f,-0.90283203f,-0.27661133f,1.04614258f,0.39184570f,0.13256836f,0.52392578f,-0.83496094f,2.09472656f,-1.80639648f,-0.98144531f,0.87255859f,-1.68701172f,-0.82934570f,-0.49047852f,1.02490234f,0.70532227f,0.03173828f,2.86108398f,1.09667969f,-0.97192383f,-0.57666016f,-1.98413086f,0.01513672f,0.11401367f,0.37475586f,-2.02807617f,0.98999023f,2.24707031f,-0.78100586f,-2.14208984f,0.49536133f,0.02563477f,-2.21679688f,-0.75854492f,-0.87841797f,0.82812500f,-2.17089844f,0.91748047f,-1.21484375f,0.04809570f,1.25634766f,0.44824219f,0.06054688f,0.64038086f,-1.69409180f,0.42065430f,0.46801758f,0.52246094f,-1.48095703f,-1.30151367f,0.00268555f,-1.40380859f,-0.19213867f,-0.62011719f,0.61840820f,0.31372070f,0.03295898f,0.10229492f,0.95190430f,-2.80395508f,-0.82104492f,1.27026367f,0.21777344f,2.20288086f,0.78247070f,0.37548828f,-1.26367188f,0.34228516f,1.86694336f,-0.53027344f,-0.32519531f,0.63989258f,-0.40991211f,-2.17749023f,-1.94018555f,1.91992188f,-0.55712891f,-1.20092773f,-0.09252930f,-1.90649414f,1.31054688f,-1.20556641f,0.22705078f,-0.53320312f,1.50244141f,0.35351562f,-0.31079102f,-1.99584961f,0.59033203f,1.83618164f,-1.59277344f,0.38281250f,0.78002930f,0.18969727f,0.71704102f,1.86206055f,-2.71313477f,2.12695312f,-1.90966797f,-1.47534180f,-0.59887695f,-0.22094727f,0.79809570f,-0.37500000f,-1.66381836f,-0.48608398f,-1.47021484f,-0.60034180f,-0.18750000f,1.82788086f,0.40161133f,0.53002930f,-1.04785156f,-0.06127930f,0.48168945f,1.66503906f,-0.27905273f,-0.19287109f,-0.70556641f,-1.08056641f,1.19482422f,2.54150391f,-0.65332031f,2.70581055f,0.78027344f,0.32495117f,-1.16162109f,0.52856445f,1.01049805f,3.30957031f,1.39501953f,1.04370117f,1.32446289f,0.01367188f,1.38623047f,-0.88330078f,0.51464844f,-1.83471680f,0.52685547f,-2.20654297f,2.10205078f,-0.26586914f,-0.10839844f,1.15527344f,-0.43847656f,-2.43286133f,0.37060547f,0.77050781f,0.94750977f,-0.77490234f,-0.83105469f,-1.17358398f,1.13525391f,0.45288086f,1.28515625f,-0.34887695f,-3.27905273f,-0.20947266f,-0.38378906f,1.28198242f,3.42407227f,2.14550781f,-0.24121094f,-2.57397461f,0.87036133f,-1.95434570f,-1.17333984f,-0.74536133f,1.98266602f,0.05859375f,-1.64648438f,-0.90844727f,-1.28466797f,-1.44580078f,0.04833984f,-0.55444336f,-0.16528320f,-1.55615234f,1.13964844f,-1.20849609f,0.87158203f,0.22753906f,-0.85302734f,-0.79882812f,-0.98583984f,0.09619141f,0.32080078f,0.03930664f,0.01879883f,-1.84130859f,0.64257812f,1.76391602f,-0.45117188f,0.78198242f,1.95581055f,-0.66381836f,0.34692383f,0.09619141f,1.20800781f,-1.73168945f,-0.15698242f,1.06665039f,-0.36596680f,1.90454102f,0.45092773f,1.66650391f,1.50952148f,1.60620117f,0.00024414f,-0.75781250f,0.15429688f,1.76220703f,-1.16430664f,-0.06030273f,-0.35571289f,-0.87500000f,2.23950195f,0.43872070f,-0.92578125f,-1.82226562f,-1.82519531f,0.96069336f,-0.81884766f,0.42773438f,0.13647461f,0.10937500f,-2.87866211f,0.76025391f,-3.42919922f,-0.03222656f,-0.65478516f,2.02758789f,0.83886719f,-1.32470703f,1.20556641f,2.23266602f,-1.92163086f,-1.81933594f,0.31933594f,0.26977539f,-0.84204102f,2.01318359f,1.01074219f,-0.85083008f,-0.82128906f,-2.20166016f,-0.58911133f,-1.60473633f,0.28857422f,1.36376953f,-1.39453125f,-0.11450195f,-1.18920898f,-0.80126953f,-1.33154297f,0.96459961f,2.23168945f,0.43969727f,-0.51025391f,-0.24536133f,-1.06835938f,0.04931641f,0.95166016f,-1.27001953f,1.04296875f,-0.24072266f,-1.61254883f,1.37377930f,0.57250977f,0.07275391f,0.33911133f,1.95068359f,2.48754883f,-1.00732422f,-1.11572266f,0.69262695f,-0.12744141f,-1.25610352f,0.25195312f,-1.38989258f,-0.10864258f,0.19433594f,1.88305664f,1.43164062f,1.94897461f,-1.06347656f,1.35742188f,1.21362305f,-2.27099609f,0.17382812f,1.19750977f,-1.63427734f,0.09960938f,0.23852539f,0.48193359f,0.65942383f,0.98095703f,-1.59277344f,-1.07690430f,0.27685547f,1.80688477f,-0.71362305f,-1.38647461f,0.49511719f,0.76733398f,1.91406250f,0.19335938f,-1.47631836f,-0.72924805f,3.32934570f,0.00292969f,0.99462891f,1.03247070f,-1.61303711f,2.10205078f,-2.05102539f,-0.80322266f,-0.28417969f,-1.04492188f,-0.10620117f,-2.36279297f,-0.90234375f,0.11352539f,1.56860352f,1.27587891f,-1.86791992f,1.47607422f,1.02929688f,0.31958008f,-0.01708984f,-0.31665039f,0.74340820f,-0.80419922f,0.83789062f,-1.13476562f,0.17041016f,0.87890625f,0.06054688f,0.14746094f,-1.80541992f,-1.14599609f,-1.13818359f,-0.15795898f,-2.04443359f,2.66870117f,1.85327148f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    // EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_4items)
{
    Shape shape_a{4,3,3,5,8,7};
    Shape shape_b{4,3,2,2,3,1};
    Shape shape_r{4,4,2,4,6,7};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1,1,1},        // move_strides
                                                                  Strides{1,1,1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0,0}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f,-0.60937500f,-0.15625000f,0.20312500f,-0.37500000f,-0.75000000f,-0.17187500f,-0.67187500f,-0.75000000f,0.31250000f,-0.26562500f,-0.78125000f,-0.87500000f,-0.28125000f,-0.92187500f,0.96875000f,0.43750000f,-0.32812500f,-0.23437500f,0.04687500f,-0.90625000f,-0.14062500f,-0.89062500f,0.18750000f,-0.46875000f,-0.18750000f,-0.53125000f,0.43750000f,-0.73437500f,-0.98437500f,0.82812500f,0.15625000f,-0.51562500f,-0.46875000f,-0.53125000f,-0.07812500f,-0.23437500f,0.04687500f,-0.64062500f,0.18750000f,0.90625000f,-0.12500000f,-0.18750000f,0.93750000f,-0.98437500f,0.07812500f,-0.43750000f,0.51562500f,1.00000000f,-0.43750000f,0.31250000f,-0.98437500f,-0.34375000f,0.87500000f,-0.62500000f,1.00000000f,0.73437500f,-0.37500000f,0.85937500f,-0.70312500f,0.82812500f,0.18750000f,0.23437500f,0.07812500f,-0.67187500f,-0.93750000f,0.32812500f,0.89062500f,0.06250000f,-0.79687500f,-0.18750000f,0.65625000f,-0.92187500f,0.07812500f,-0.84375000f,0.15625000f,-0.32812500f,-0.43750000f,0.87500000f,0.87500000f,-0.70312500f,0.82812500f,-0.67187500f,-0.75000000f,-0.01562500f,-0.79687500f,0.15625000f,-0.21875000f,-0.31250000f,-0.48437500f,0.48437500f,-0.85937500f,-0.18750000f,-0.20312500f,0.45312500f,-0.87500000f,0.28125000f,0.81250000f,-0.56250000f,-0.12500000f,-0.06250000f,0.03125000f,-0.82812500f,0.56250000f,0.01562500f,-0.59375000f,-0.76562500f,0.70312500f,-1.00000000f,-0.87500000f,-0.68750000f,-0.64062500f,0.93750000f,-0.50000000f,0.73437500f,0.92187500f,-0.95312500f,-0.45312500f,-0.06250000f,-0.06250000f,-0.60937500f,-0.01562500f,-0.17187500f,0.34375000f,-0.95312500f,-0.01562500f,-0.85937500f,-0.85937500f,0.42187500f,-0.57812500f,-0.67187500f,0.35937500f,-0.06250000f,0.78125000f,-0.26562500f,-0.10937500f,0.92187500f,0.17187500f,0.46875000f,0.56250000f,0.20312500f,-0.42187500f,0.00000000f,0.12500000f,-0.92187500f,-0.14062500f,0.48437500f,-0.60937500f,0.50000000f,0.87500000f,0.25000000f,-0.59375000f,-0.04687500f,0.29687500f,0.31250000f,0.45312500f,-0.96875000f,-0.70312500f,0.87500000f,0.62500000f,-0.34375000f,-0.90625000f,0.07812500f,0.51562500f,0.35937500f,0.40625000f,-0.62500000f,0.48437500f,-0.50000000f,-0.23437500f,0.68750000f,-0.23437500f,-0.85937500f,0.95312500f,0.51562500f,-0.15625000f,0.35937500f,0.50000000f,0.73437500f,0.71875000f,-0.62500000f,0.45312500f,0.40625000f,-0.18750000f,-0.85937500f,0.42187500f,-0.67187500f,0.62500000f,-0.60937500f,-0.54687500f,0.21875000f,0.50000000f,0.65625000f,0.32812500f,0.87500000f,-0.01562500f,0.40625000f,0.17187500f,0.93750000f,-0.95312500f,-0.20312500f,-0.73437500f,0.40625000f,-0.20312500f,0.20312500f,-0.04687500f,-0.65625000f,0.64062500f,0.65625000f,-0.71875000f,0.31250000f,-0.35937500f,-0.28125000f,0.15625000f,1.00000000f,1.00000000f,0.43750000f,-0.20312500f,-0.53125000f,0.92187500f,0.90625000f,0.07812500f,0.50000000f,0.43750000f,-0.57812500f,0.84375000f,-0.67187500f,0.09375000f,-0.17187500f,-0.64062500f,0.14062500f,-0.67187500f,1.00000000f,-0.48437500f,-0.37500000f,0.00000000f,0.21875000f,0.96875000f,0.06250000f,-0.81250000f,0.78125000f,0.87500000f,0.67187500f,0.45312500f,-0.96875000f,-0.29687500f,-0.60937500f,0.70312500f,0.56250000f,0.59375000f,0.87500000f,0.95312500f,0.03125000f,-0.64062500f,-0.62500000f,-0.43750000f,0.51562500f,-0.17187500f,-0.06250000f,0.03125000f,-0.48437500f,-0.95312500f,-0.31250000f,-0.40625000f,-0.89062500f,-0.64062500f,0.23437500f,0.87500000f,0.48437500f,0.54687500f,0.82812500f,0.70312500f,-0.68750000f,0.87500000f,0.93750000f,0.92187500f,-0.03125000f,0.65625000f,0.04687500f,-0.25000000f,0.10937500f,-0.57812500f,-0.21875000f,0.25000000f,-0.15625000f,0.89062500f,0.35937500f,0.96875000f,-0.31250000f,-0.04687500f,-0.04687500f,0.46875000f,-0.51562500f,-0.25000000f,0.67187500f,-0.70312500f,0.28125000f,-0.48437500f,0.71875000f,-0.43750000f,-0.28125000f,-0.81250000f,0.70312500f,0.95312500f,0.31250000f,-0.31250000f,-0.29687500f,0.20312500f,-0.95312500f,0.64062500f,-0.87500000f,-0.42187500f,0.90625000f,-0.65625000f,-0.85937500f,-0.84375000f,0.50000000f,0.17187500f,-0.37500000f,-1.00000000f,-0.89062500f,-0.68750000f,0.53125000f,0.95312500f,0.17187500f,-0.70312500f,0.46875000f,0.53125000f,-0.31250000f,0.67187500f,0.89062500f,0.32812500f,-0.53125000f,-0.57812500f,0.54687500f,-0.98437500f,0.23437500f,0.01562500f,0.65625000f,-0.43750000f,-0.54687500f,0.93750000f,-0.71875000f,-0.84375000f,0.18750000f,0.59375000f,-0.95312500f,-0.50000000f,0.93750000f,-0.07812500f,-0.68750000f,0.85937500f,-0.35937500f,-0.26562500f,-0.79687500f,-0.95312500f,-0.90625000f,-0.50000000f,0.56250000f,0.85937500f,0.50000000f,-0.04687500f,0.35937500f,-0.78125000f,0.50000000f,-0.93750000f,-0.40625000f,-0.70312500f,0.15625000f,-0.07812500f,0.40625000f,0.70312500f,0.46875000f,-0.71875000f,-0.03125000f,-0.87500000f,-0.84375000f,-0.34375000f,0.00000000f,0.17187500f,-0.93750000f,0.62500000f,-0.76562500f,-0.26562500f,0.98437500f,0.40625000f,1.00000000f,-0.90625000f,-0.23437500f,0.50000000f,0.53125000f,-0.90625000f,-0.62500000f,0.96875000f,-0.59375000f,-0.10937500f,0.89062500f,-1.00000000f,0.70312500f,0.98437500f,0.15625000f,-0.26562500f,0.50000000f,0.56250000f,-0.26562500f,0.10937500f,0.78125000f,0.70312500f,0.20312500f,-0.84375000f,0.50000000f,0.96875000f,0.57812500f,-0.18750000f,0.03125000f,0.68750000f,-0.64062500f,-0.29687500f,-0.62500000f,0.32812500f,-0.90625000f,-0.39062500f,0.17187500f,0.73437500f,-0.65625000f,-0.10937500f,0.76562500f,0.59375000f,0.65625000f,-0.43750000f,0.39062500f,-0.18750000f,0.09375000f,0.07812500f,0.35937500f,0.15625000f,0.18750000f,-0.35937500f,0.78125000f,-0.45312500f,-0.87500000f,-0.50000000f,-0.60937500f,0.37500000f,-0.64062500f,0.32812500f,0.81250000f,-0.96875000f,-0.92187500f,-0.73437500f,0.07812500f,0.00000000f,-0.56250000f,-0.20312500f,0.32812500f,0.78125000f,0.78125000f,-0.32812500f,0.68750000f,-0.23437500f,-0.57812500f,-0.76562500f,-0.35937500f,-0.53125000f,0.04687500f,-0.45312500f,-0.04687500f,0.00000000f,0.48437500f,-0.59375000f,0.37500000f,0.81250000f,0.95312500f,-0.48437500f,0.20312500f,0.01562500f,-0.62500000f,-0.75000000f,-0.64062500f,0.65625000f,-0.50000000f,-0.18750000f,-0.84375000f,-0.14062500f,0.51562500f,0.03125000f,-0.50000000f,0.51562500f,-0.98437500f,0.93750000f,0.78125000f,-0.96875000f,-0.57812500f,0.31250000f,0.10937500f,0.92187500f,-0.92187500f,0.25000000f,-0.31250000f,-0.15625000f,0.09375000f,0.43750000f,-0.76562500f,-0.14062500f,-0.68750000f,-0.14062500f,-0.03125000f,0.90625000f,-0.71875000f,-0.56250000f,0.64062500f,0.76562500f,0.60937500f,0.81250000f,-0.48437500f,0.46875000f,0.65625000f,-0.29687500f,0.48437500f,-0.43750000f,0.82812500f,-0.26562500f,0.64062500f,-0.01562500f,0.35937500f,-0.29687500f,-0.84375000f,-0.92187500f,-0.84375000f,0.73437500f,0.09375000f,-0.53125000f,-0.15625000f,0.12500000f,0.84375000f,-0.78125000f,-0.51562500f,0.42187500f,0.25000000f,0.37500000f,0.18750000f,0.18750000f,0.67187500f,0.96875000f,0.62500000f,0.23437500f,0.57812500f,0.10937500f,-0.31250000f,-0.78125000f,0.79687500f,0.29687500f,0.96875000f,-0.70312500f,-0.96875000f,-0.75000000f,-0.01562500f,-0.37500000f,0.03125000f,0.10937500f,0.95312500f,-0.59375000f,0.78125000f,-0.20312500f,-0.15625000f,0.15625000f,-0.82812500f,0.60937500f,0.26562500f,0.32812500f,-0.90625000f,0.21875000f,-0.37500000f,0.37500000f,0.03125000f,-0.37500000f,-0.81250000f,0.81250000f,-0.89062500f,-0.75000000f,-0.96875000f,0.76562500f,0.43750000f,0.35937500f,-0.89062500f,0.75000000f,-0.04687500f,-1.00000000f,0.98437500f,0.70312500f,-0.85937500f,-0.17187500f,0.46875000f,0.56250000f,-0.25000000f,0.60937500f,-0.92187500f,-0.57812500f,0.89062500f,-0.29687500f,0.84375000f,-0.09375000f,0.28125000f,-0.06250000f,0.87500000f,0.12500000f,-0.25000000f,-0.96875000f,0.10937500f,-0.53125000f,0.89062500f,-0.62500000f,-0.57812500f,0.18750000f,0.07812500f,0.28125000f,-0.06250000f,0.34375000f,-0.46875000f,-0.35937500f,0.50000000f,-0.07812500f,1.00000000f,1.00000000f,0.45312500f,-0.82812500f,-0.59375000f,-0.90625000f,0.06250000f,-0.93750000f,0.85937500f,0.43750000f,0.89062500f,0.32812500f,-0.92187500f,0.87500000f,-0.62500000f,-0.62500000f,-0.25000000f,-0.70312500f,0.87500000f,0.57812500f,0.93750000f,0.84375000f,-0.48437500f,-0.40625000f,-0.90625000f,-0.48437500f,0.95312500f,-0.57812500f,0.40625000f,-0.90625000f,0.26562500f,-0.76562500f,-0.51562500f,0.85937500f,0.84375000f,0.45312500f,-0.76562500f,-0.12500000f,-0.03125000f,-1.00000000f,-0.65625000f,0.17187500f,0.12500000f,0.40625000f,1.00000000f,0.17187500f,-0.37500000f,0.48437500f,0.06250000f,-0.68750000f,-0.84375000f,0.35937500f,-0.14062500f,-0.12500000f,0.60937500f,-0.51562500f,1.00000000f,-0.25000000f,-0.81250000f,0.29687500f,-0.54687500f,0.35937500f,-0.60937500f,-0.98437500f,-0.12500000f,-0.31250000f,0.64062500f,-0.03125000f,0.46875000f,0.37500000f,0.53125000f,0.09375000f,-0.09375000f,0.60937500f,-0.56250000f,0.18750000f,-0.76562500f,0.00000000f,-0.15625000f,0.79687500f,0.53125000f,-0.46875000f,1.00000000f,-0.78125000f,0.39062500f,0.45312500f,0.35937500f,0.15625000f,-0.20312500f,-0.07812500f,-0.96875000f,0.71875000f,0.90625000f,-0.35937500f,-0.32812500f,0.79687500f,-0.57812500f,0.01562500f,-0.92187500f,0.46875000f,-0.15625000f,-0.53125000f,-0.56250000f,-0.42187500f,-0.26562500f,0.51562500f,-0.65625000f,0.60937500f,0.35937500f,-0.28125000f,-0.76562500f,0.12500000f,0.73437500f,0.25000000f,0.71875000f,-0.57812500f,-0.54687500f,-0.01562500f,0.89062500f,-0.85937500f,0.20312500f,-0.64062500f,-0.95312500f,0.35937500f,-0.82812500f,-0.75000000f,0.92187500f,-0.65625000f,-0.09375000f,-0.37500000f,0.78125000f,-0.81250000f,0.60937500f,0.76562500f,-0.48437500f,-0.32812500f,-0.75000000f,0.59375000f,-0.21875000f,0.98437500f,-0.45312500f,-0.35937500f,-0.48437500f,0.14062500f,-0.12500000f,-0.12500000f,0.48437500f,0.14062500f,0.21875000f,0.42187500f,1.00000000f,-0.95312500f,-0.28125000f,-0.54687500f,-1.00000000f,0.92187500f,0.35937500f,0.76562500f,0.79687500f,-0.71875000f,-0.46875000f,-0.32812500f,-0.17187500f,-0.46875000f,0.64062500f,-0.92187500f,-0.70312500f,-0.48437500f,-0.96875000f,0.76562500f,0.73437500f,0.28125000f,0.31250000f,-0.57812500f,-0.45312500f,-0.46875000f,-0.14062500f,-0.10937500f,0.48437500f,-0.39062500f,-0.21875000f,-0.04687500f,0.53125000f,-0.51562500f,-0.37500000f,-0.18750000f,0.53125000f,0.92187500f,-0.84375000f,-0.45312500f,0.34375000f,0.48437500f,-0.71875000f,0.46875000f,-0.04687500f,-0.96875000f,-0.56250000f,0.48437500f,-0.79687500f,-0.57812500f,0.64062500f,-0.50000000f,-0.64062500f,-0.64062500f,-0.92187500f,-0.82812500f,0.10937500f,-0.98437500f,0.90625000f,0.28125000f,-0.81250000f,-0.35937500f,0.50000000f,-0.73437500f,-0.62500000f,-0.76562500f,-0.71875000f,-0.17187500f,-0.21875000f,-0.51562500f,-0.73437500f,0.64062500f,0.90625000f,0.79687500f,0.96875000f,0.71875000f,0.23437500f,0.03125000f,0.98437500f,0.25000000f,0.62500000f,0.54687500f,0.20312500f,-0.87500000f,-0.25000000f,-0.82812500f,0.68750000f,-0.29687500f,0.12500000f,0.14062500f,0.14062500f,0.65625000f,-0.35937500f,0.84375000f,-0.78125000f,-0.64062500f,0.70312500f,-0.87500000f,-0.31250000f,-0.43750000f,0.15625000f,-0.07812500f,-0.96875000f,0.39062500f,-0.95312500f,0.17187500f,0.14062500f,0.32812500f,-0.81250000f,-0.25000000f,0.71875000f,0.82812500f,0.50000000f,-0.17187500f,0.17187500f,-0.15625000f,0.57812500f,0.18750000f,0.84375000f,0.48437500f,0.75000000f,0.85937500f,-0.20312500f,-0.71875000f,-0.37500000f,0.29687500f,0.90625000f,0.06250000f,-0.59375000f,-0.15625000f,0.70312500f,-0.23437500f,0.73437500f,0.03125000f,-0.37500000f,0.89062500f,0.20312500f,-0.89062500f,0.18750000f,0.82812500f,0.46875000f,0.85937500f,0.81250000f,-0.23437500f,0.76562500f,0.48437500f,0.87500000f,0.12500000f,-0.39062500f,0.29687500f,-0.14062500f,-0.07812500f,0.53125000f,0.17187500f,0.45312500f,0.82812500f,-0.45312500f,-0.68750000f,0.87500000f,-0.43750000f,0.15625000f,0.43750000f,0.65625000f,-0.26562500f,0.18750000f,0.79687500f,0.45312500f,-0.57812500f,0.62500000f,0.76562500f,0.45312500f,0.96875000f,0.65625000f,-0.82812500f,-0.28125000f,-0.31250000f,0.93750000f,0.17187500f,0.92187500f,0.07812500f,0.12500000f,0.56250000f,-0.39062500f,-0.40625000f,-0.32812500f,0.40625000f,-0.71875000f,-0.23437500f,0.17187500f,0.40625000f,0.59375000f,0.59375000f,-0.75000000f,-0.10937500f,-0.21875000f,-0.46875000f,-0.17187500f,0.56250000f,-0.32812500f,-0.01562500f,0.31250000f,-0.40625000f,0.01562500f,0.23437500f,0.51562500f,0.25000000f,0.09375000f,0.12500000f,0.79687500f,-0.65625000f,-0.40625000f,0.57812500f,-0.23437500f,0.34375000f,0.96875000f,-0.34375000f,-0.85937500f,-0.28125000f,-0.76562500f,-0.04687500f,0.84375000f,0.82812500f,-0.59375000f,-0.20312500f,-0.48437500f,0.32812500f,-0.54687500f,-0.46875000f,0.29687500f,0.64062500f,0.39062500f,0.14062500f,0.17187500f,-0.87500000f,0.43750000f,-0.82812500f,-0.43750000f,0.84375000f,0.01562500f,0.54687500f,-0.92187500f,-0.01562500f,-0.35937500f,-0.93750000f,-0.98437500f,0.60937500f,-0.43750000f,-0.87500000f,0.85937500f,-0.60937500f,0.40625000f,-0.10937500f,0.23437500f,0.32812500f,-0.92187500f,-0.57812500f,-0.45312500f,-0.73437500f,0.18750000f,-0.96875000f,-0.56250000f,0.12500000f,0.06250000f,-0.03125000f,-0.32812500f,0.32812500f,-0.67187500f,0.29687500f,-0.67187500f,0.42187500f,0.09375000f,-0.15625000f,-0.95312500f,0.79687500f,-0.32812500f,0.46875000f,-0.90625000f,0.32812500f,-0.92187500f,-0.21875000f,0.65625000f,-0.68750000f,-0.75000000f,-0.67187500f,-0.04687500f,-0.04687500f,0.43750000f,0.90625000f,0.23437500f,0.59375000f,0.62500000f,0.68750000f,-0.48437500f,0.95312500f,-0.51562500f,0.00000000f,0.31250000f,0.65625000f,-0.84375000f,-0.14062500f,-0.90625000f,0.29687500f,0.96875000f,-0.53125000f,0.06250000f,-0.28125000f,-0.26562500f,-0.96875000f,0.25000000f,0.96875000f,-0.23437500f,0.70312500f,0.96875000f,0.01562500f,0.59375000f,0.95312500f,-0.03125000f,-0.34375000f,0.96875000f,-0.56250000f,-0.57812500f,0.06250000f,0.65625000f,0.40625000f,-0.48437500f,-0.40625000f,-0.59375000f,-0.34375000f,-0.73437500f,-0.46875000f,-0.54687500f,0.29687500f,-0.31250000f,-0.23437500f,-0.62500000f,-0.54687500f,-0.60937500f,0.03125000f,0.40625000f,0.92187500f,-0.15625000f,0.43750000f,-0.59375000f,0.01562500f,-0.32812500f,0.93750000f,-0.96875000f,-0.79687500f,-0.76562500f,-0.85937500f,-1.00000000f,0.04687500f,0.29687500f,0.09375000f,0.79687500f,-0.93750000f,0.62500000f,0.06250000f,0.25000000f,-0.60937500f,0.50000000f,-0.31250000f,0.31250000f,-0.07812500f,0.93750000f,0.48437500f,-0.37500000f,-0.67187500f,0.06250000f,0.06250000f,0.67187500f,0.70312500f,0.20312500f,0.68750000f,-0.21875000f,0.03125000f,0.68750000f,-0.79687500f,-0.03125000f,0.21875000f,0.25000000f,0.20312500f,-0.92187500f,0.71875000f,0.37500000f,-0.96875000f,0.10937500f,0.39062500f,-0.67187500f,0.01562500f,-0.43750000f,0.93750000f,0.87500000f,0.56250000f,-0.60937500f,0.68750000f,0.12500000f,-0.12500000f,-0.51562500f,-0.56250000f,-0.18750000f,-0.04687500f,-0.29687500f,0.45312500f,-0.09375000f,-0.64062500f,0.93750000f,-0.59375000f,-0.37500000f,0.62500000f,0.09375000f,-0.60937500f,-0.76562500f,-0.71875000f,0.01562500f,0.59375000f,-0.54687500f,0.82812500f,0.15625000f,0.84375000f,-0.37500000f,-0.54687500f,-0.39062500f,-0.54687500f,-0.42187500f,0.14062500f,-0.79687500f,0.85937500f,-0.68750000f,-0.51562500f,-0.64062500f,-0.70312500f,-0.56250000f,-0.75000000f,0.85937500f,-0.81250000f,-0.84375000f,0.12500000f,0.23437500f,0.79687500f,-0.21875000f,-0.93750000f,0.46875000f,0.75000000f,0.43750000f,-0.53125000f,0.15625000f,0.37500000f,0.50000000f,0.51562500f,0.76562500f,-0.14062500f,0.45312500f,-0.87500000f,-0.71875000f,-0.40625000f,-0.92187500f,0.50000000f,-0.68750000f,-0.71875000f,-0.43750000f,0.79687500f,-0.01562500f,-0.95312500f,-0.31250000f,-0.51562500f,-0.28125000f,0.56250000f,-0.51562500f,0.59375000f,0.65625000f,0.21875000f,-0.56250000f,0.28125000f,0.01562500f,-0.56250000f,-0.59375000f,0.12500000f,-0.75000000f,0.03125000f,-0.53125000f,-0.50000000f,0.00000000f,0.04687500f,0.01562500f,-0.43750000f,-0.48437500f,-0.79687500f,0.50000000f,0.65625000f,-0.04687500f,-0.96875000f,-0.56250000f,-0.29687500f,0.18750000f,-0.01562500f,0.15625000f,0.10937500f,-0.62500000f,-0.18750000f,-0.93750000f,0.28125000f,0.32812500f,-0.12500000f,0.76562500f,0.31250000f,-0.59375000f,0.51562500f,-0.09375000f,-0.65625000f,0.95312500f,-0.78125000f,0.31250000f,-0.40625000f,-0.53125000f,0.56250000f,0.31250000f,0.14062500f,-0.65625000f,-0.65625000f,0.10937500f,0.42187500f,-0.25000000f,-0.01562500f,0.75000000f,0.92187500f,0.04687500f,0.17187500f,-0.59375000f,-0.56250000f,-0.10937500f,-0.40625000f,-0.84375000f,-0.87500000f,-0.50000000f,0.71875000f,-0.60937500f,0.20312500f,0.78125000f,-0.12500000f,0.62500000f,-0.12500000f,-0.50000000f,0.54687500f,-0.87500000f,-0.67187500f,-0.35937500f,-0.15625000f,0.64062500f,0.71875000f,0.42187500f,-0.12500000f,0.96875000f,0.87500000f,-0.57812500f,-0.10937500f,-0.23437500f,-0.85937500f,-0.73437500f,-0.40625000f,-0.90625000f,0.92187500f,-0.48437500f,0.06250000f,-0.21875000f,-0.42187500f,-0.39062500f,-0.59375000f,0.89062500f,-0.92187500f,0.04687500f,-0.40625000f,-0.15625000f,0.23437500f,-0.84375000f,-0.76562500f,-0.18750000f,0.98437500f,0.06250000f,0.85937500f,-0.07812500f,-0.95312500f,0.04687500f,0.43750000f,-0.93750000f,0.37500000f,-0.78125000f,0.46875000f,0.09375000f,0.64062500f,0.07812500f,-0.54687500f,-0.59375000f,-0.95312500f,-0.35937500f,0.70312500f,-0.45312500f,-0.39062500f,-0.60937500f,-0.67187500f,-0.14062500f,-0.82812500f,0.78125000f,0.23437500f,0.89062500f,-0.06250000f,-0.03125000f,0.45312500f,-0.54687500f,-0.37500000f,0.87500000f,0.09375000f,-0.79687500f,0.68750000f,-0.31250000f,0.70312500f,0.39062500f,-0.68750000f,-0.42187500f,0.32812500f,0.56250000f,0.76562500f,1.00000000f,0.54687500f,-0.70312500f,-0.06250000f,-0.10937500f,-0.56250000f,-0.68750000f,0.43750000f,0.87500000f,-0.39062500f,-0.59375000f,0.29687500f,-0.46875000f,-0.60937500f,-0.23437500f,0.68750000f,-0.60937500f,-0.32812500f,0.42187500f,0.56250000f,0.31250000f,0.31250000f,0.06250000f,-0.21875000f,-0.04687500f,-0.39062500f,-0.85937500f,0.96875000f,0.21875000f,0.51562500f,-0.79687500f,0.35937500f,-0.93750000f,0.39062500f,0.25000000f,0.01562500f,-0.89062500f,-0.26562500f,-0.79687500f,-0.46875000f,-0.79687500f,-0.25000000f,0.43750000f,0.56250000f,0.20312500f,1.00000000f,-0.56250000f,0.62500000f,0.12500000f,-0.29687500f,0.17187500f,-0.20312500f,-0.20312500f,-0.85937500f,-0.89062500f,0.57812500f,-0.68750000f,-0.87500000f,-0.71875000f,0.71875000f,-0.06250000f,-0.29687500f,-0.35937500f,-0.01562500f,-0.67187500f,0.00000000f,-0.29687500f,-0.82812500f,-0.56250000f,-0.04687500f,-0.81250000f,-0.23437500f,0.12500000f,-0.20312500f,-0.42187500f,0.89062500f,0.34375000f,0.00000000f,0.06250000f,-0.64062500f,-0.18750000f,0.18750000f,0.87500000f,-0.96875000f,-0.40625000f,-0.46875000f,-0.57812500f,-0.65625000f,-0.75000000f,-1.00000000f,0.64062500f,-0.57812500f,-0.56250000f,0.89062500f,0.67187500f,-0.29687500f,0.68750000f,-0.45312500f,0.68750000f,0.07812500f,-0.40625000f,0.39062500f,0.09375000f,-0.68750000f,-0.57812500f,-0.46875000f,-0.51562500f,0.60937500f,-0.32812500f,0.12500000f,0.26562500f,0.93750000f,-0.84375000f,0.12500000f,0.17187500f,-0.78125000f,-0.90625000f,-0.98437500f,-0.51562500f,-0.84375000f,-0.29687500f,-0.78125000f,-0.32812500f,-0.18750000f,0.23437500f,0.53125000f,-0.48437500f,0.67187500f,0.68750000f,0.62500000f,0.67187500f,-0.09375000f,-0.96875000f,-0.15625000f,-0.48437500f,-0.84375000f,-0.62500000f,-0.46875000f,-0.14062500f,0.81250000f,-0.64062500f,-0.46875000f,-0.20312500f,0.51562500f,-0.60937500f,0.95312500f,0.81250000f,-0.31250000f,-0.68750000f,0.40625000f,-0.90625000f,-0.10937500f,0.76562500f,-0.03125000f,-0.26562500f,-0.53125000f,-0.56250000f,-1.00000000f,-0.25000000f,-0.85937500f,0.09375000f,0.73437500f,-0.96875000f,0.01562500f,-0.57812500f,-0.95312500f,-0.01562500f,-0.84375000f,-0.45312500f,0.06250000f,-0.50000000f,-0.62500000f,0.71875000f,0.78125000f,0.79687500f,-0.46875000f,-0.84375000f,-0.50000000f,0.84375000f,0.73437500f,-0.93750000f,-0.10937500f,0.20312500f,-0.15625000f,-0.64062500f,-0.03125000f,0.75000000f,-0.65625000f,-0.54687500f,0.09375000f,-0.57812500f,0.29687500f,0.34375000f,-0.20312500f,-0.92187500f,-0.78125000f,-0.60937500f,-0.96875000f,-0.89062500f,0.57812500f,0.32812500f,-0.17187500f,0.59375000f,-0.40625000f,-0.25000000f,-0.39062500f,0.93750000f,0.00000000f,-0.98437500f,-0.39062500f,0.98437500f,0.96875000f,0.62500000f,-0.29687500f,0.43750000f,0.89062500f,0.84375000f,0.39062500f,-0.57812500f,-0.07812500f,0.68750000f,-0.29687500f,-0.54687500f,-1.00000000f,0.12500000f,-0.45312500f,-0.85937500f,-0.29687500f,-0.68750000f,0.39062500f,-0.28125000f,-0.70312500f,0.00000000f,-0.68750000f,-0.39062500f,0.00000000f,0.48437500f,0.28125000f,-0.89062500f,0.29687500f,0.45312500f,0.96875000f,0.65625000f,-0.89062500f,-0.26562500f,-0.25000000f,0.25000000f,-0.46875000f,0.95312500f,-0.17187500f,0.29687500f,-0.64062500f,0.50000000f,0.29687500f,-0.70312500f,0.53125000f,-0.04687500f,0.60937500f,0.10937500f,0.42187500f,0.45312500f,-0.34375000f,-0.48437500f,-0.67187500f,-0.25000000f,0.40625000f,0.56250000f,-0.82812500f,0.87500000f,-0.35937500f,0.75000000f,-0.43750000f,-0.29687500f,-0.43750000f,0.26562500f,-0.45312500f,-0.59375000f,0.00000000f,-0.06250000f,-0.70312500f,-0.59375000f,0.35937500f,-0.25000000f,-0.64062500f,0.32812500f,-0.12500000f,0.15625000f,0.53125000f,-0.75000000f,-0.50000000f,0.42187500f,-0.75000000f,0.43750000f,0.87500000f,0.57812500f,-0.10937500f,-0.81250000f,0.20312500f,-0.67187500f,-0.43750000f,-0.14062500f,0.21875000f,-0.81250000f,0.50000000f,0.59375000f,-0.32812500f,-0.60937500f,0.57812500f,0.46875000f,0.28125000f,-0.31250000f,1.00000000f,-0.31250000f,0.32812500f,0.98437500f,0.82812500f,-0.73437500f,0.07812500f,-1.00000000f,-1.00000000f,0.15625000f,0.45312500f,0.09375000f,0.60937500f,0.28125000f,-0.92187500f,-0.60937500f,0.42187500f,-0.85937500f,0.09375000f,-0.42187500f,-0.90625000f,0.96875000f,-0.50000000f,-0.39062500f,-0.12500000f,0.10937500f,-0.76562500f,0.71875000f,0.62500000f,0.71875000f,0.29687500f,0.14062500f,0.39062500f,0.89062500f,-0.01562500f,0.42187500f,0.39062500f,-0.48437500f,-0.46875000f,-0.34375000f,0.59375000f,-0.79687500f,0.06250000f,0.57812500f,0.26562500f,-1.00000000f,0.59375000f,-0.25000000f,-0.42187500f,-0.71875000f,-0.60937500f,0.09375000f,-0.65625000f,-0.20312500f,0.76562500f,-0.56250000f,0.15625000f,0.29687500f,0.60937500f,-0.78125000f,-0.73437500f,-0.26562500f,-0.43750000f,-0.60937500f,-0.20312500f,-0.82812500f,-0.51562500f,-0.92187500f,-0.46875000f,-0.62500000f,0.21875000f,0.04687500f,-0.62500000f,-0.85937500f,-0.98437500f,-0.18750000f,0.40625000f,-0.04687500f,0.48437500f,0.92187500f,0.53125000f,-0.59375000f,-0.42187500f,-0.95312500f,-0.75000000f,-0.04687500f,0.98437500f,0.92187500f,-0.39062500f,0.82812500f,0.20312500f,0.45312500f,-0.68750000f,0.54687500f,0.39062500f,0.84375000f,-0.90625000f,-0.35937500f,-0.07812500f,0.73437500f,-0.53125000f,-0.06250000f,-0.18750000f,-0.04687500f,-0.84375000f,0.65625000f,0.70312500f,-0.93750000f,0.76562500f,0.68750000f,0.39062500f,0.10937500f,-0.70312500f,-0.34375000f,-0.21875000f,0.32812500f,0.43750000f,-0.48437500f,0.37500000f,-0.20312500f,-0.85937500f,-0.90625000f,0.25000000f,-0.76562500f,-0.59375000f,-0.21875000f,0.82812500f,0.53125000f,-0.35937500f,0.01562500f,-0.43750000f,0.81250000f,0.25000000f,-0.32812500f,-0.21875000f,-0.42187500f,-0.23437500f,-0.34375000f,0.25000000f,-0.81250000f,-0.31250000f,0.71875000f,0.64062500f,-0.71875000f,0.76562500f,0.26562500f,0.01562500f,0.46875000f,0.82812500f,0.81250000f,-0.96875000f,0.96875000f,0.85937500f,0.82812500f,0.85937500f,-0.89062500f,0.18750000f,-0.87500000f,-0.78125000f,-0.59375000f,-0.84375000f,-0.57812500f,-0.21875000f,-0.10937500f,0.93750000f,0.20312500f,0.32812500f,0.04687500f,-0.18750000f,0.60937500f,0.31250000f,0.23437500f,0.03125000f,0.68750000f,-0.32812500f,-0.89062500f,-0.23437500f,-0.67187500f,0.15625000f,0.73437500f,-0.48437500f,0.56250000f,0.31250000f,0.39062500f,-0.65625000f,-0.67187500f,-0.90625000f,-0.43750000f,0.98437500f,-0.25000000f,-0.50000000f,-0.78125000f,0.06250000f,0.32812500f,-0.45312500f,-0.12500000f,0.17187500f,0.92187500f,-0.31250000f,0.01562500f,-0.70312500f,0.76562500f,0.53125000f,0.06250000f,0.95312500f,-0.46875000f,-0.39062500f,1.00000000f,0.59375000f,-0.20312500f,0.93750000f,-0.92187500f,-0.68750000f,-0.28125000f,0.18750000f,0.71875000f,0.18750000f,0.25000000f,-0.48437500f,0.01562500f,0.35937500f,0.48437500f,-0.54687500f,0.29687500f,0.73437500f,-0.51562500f,0.57812500f,-0.26562500f,0.46875000f,0.62500000f,0.62500000f,0.81250000f,0.17187500f,0.28125000f,-0.75000000f,-0.45312500f,-0.29687500f,0.37500000f,-0.71875000f,0.71875000f,0.93750000f,-0.42187500f,0.31250000f,-0.26562500f,0.81250000f,-0.15625000f,-0.62500000f,0.53125000f,0.12500000f,0.60937500f,0.60937500f,-0.04687500f,-0.90625000f,0.40625000f,0.12500000f,0.89062500f,0.09375000f,-0.14062500f,0.29687500f,-0.03125000f,-0.62500000f,0.17187500f,-0.67187500f,0.79687500f,0.53125000f,0.54687500f,-0.54687500f,0.71875000f,-0.03125000f,-0.14062500f,-0.56250000f,0.15625000f,0.90625000f,0.65625000f,0.00000000f,-0.35937500f,0.43750000f,-0.40625000f,0.57812500f,-0.25000000f,0.03125000f,0.04687500f,-0.42187500f,0.76562500f,0.85937500f,0.81250000f,-0.87500000f,-0.85937500f,0.14062500f,0.26562500f,0.03125000f,0.28125000f,0.17187500f,-0.50000000f,0.53125000f,-0.32812500f,-0.15625000f,0.18750000f,-0.92187500f,0.59375000f,0.34375000f,0.85937500f,-0.73437500f,0.28125000f,0.37500000f,0.62500000f,-0.92187500f,-0.09375000f,-0.31250000f,-0.51562500f,-0.68750000f,0.45312500f,0.01562500f,0.10937500f,0.42187500f,-0.15625000f,-0.28125000f,0.75000000f,-0.20312500f,0.45312500f,-0.85937500f,-0.85937500f,-0.23437500f,-0.54687500f,-0.51562500f,-0.71875000f,0.82812500f,0.93750000f,-0.62500000f,0.48437500f,-0.18750000f,0.60937500f,-0.39062500f,-0.21875000f,-0.79687500f,0.14062500f,0.93750000f,-0.32812500f,0.29687500f,0.15625000f,0.26562500f,-0.43750000f,-0.21875000f,0.28125000f,-0.17187500f,0.07812500f,0.31250000f,-0.68750000f,-0.03125000f,-0.14062500f,0.29687500f,0.01562500f,-0.90625000f,0.26562500f,0.26562500f,0.95312500f,0.81250000f,-0.03125000f,0.73437500f,0.06250000f,0.64062500f,-0.56250000f,-0.87500000f,0.65625000f,-0.85937500f,0.67187500f,-0.34375000f,-0.23437500f,-0.01562500f,-0.14062500f,0.78125000f,0.00000000f,-0.62500000f,0.62500000f,0.45312500f,-0.37500000f,0.32812500f,0.53125000f,0.85937500f,0.59375000f,0.98437500f,0.10937500f,0.32812500f,0.73437500f,-0.01562500f,-0.34375000f,-0.45312500f,-0.34375000f,-0.68750000f,-0.09375000f,-0.45312500f,0.23437500f,-0.14062500f,-0.21875000f,-0.70312500f,-0.26562500f,-0.35937500f,-0.14062500f,0.75000000f,-0.45312500f,-0.68750000f,-0.56250000f,0.03125000f,-0.71875000f,-0.09375000f,0.42187500f,0.68750000f,0.56250000f,0.34375000f,-0.32812500f,-0.29687500f,0.73437500f,0.18750000f,-0.23437500f,-0.25000000f,0.57812500f,-0.70312500f,0.90625000f,-0.78125000f,-0.57812500f,-0.75000000f,-0.70312500f,0.50000000f,-0.40625000f,-0.87500000f,0.28125000f,0.68750000f,-0.03125000f,-0.15625000f,-0.68750000f,-0.62500000f,-0.84375000f,-0.03125000f,0.98437500f,0.64062500f,-0.07812500f,-0.53125000f,0.92187500f,-0.78125000f,-0.23437500f,0.84375000f,-0.37500000f,-0.31250000f,-0.28125000f,-0.10937500f,0.76562500f,0.34375000f,0.92187500f,0.82812500f,-0.35937500f,-0.84375000f,-0.04687500f,-0.53125000f,-0.87500000f,0.81250000f,-0.53125000f,-0.39062500f,0.64062500f,0.04687500f,0.65625000f,0.31250000f,-0.46875000f,0.35937500f,0.15625000f,0.42187500f,-0.51562500f,0.64062500f,0.59375000f,-0.10937500f,-0.56250000f,-0.82812500f,-0.17187500f,-0.89062500f,-0.79687500f,-0.70312500f,-0.96875000f,-0.85937500f,0.57812500f,-0.29687500f,-0.34375000f,-0.14062500f,0.28125000f,0.04687500f,-0.81250000f,-0.17187500f,0.68750000f,0.56250000f,0.37500000f,0.50000000f,0.57812500f,0.62500000f,-0.46875000f,-0.76562500f,0.42187500f,0.76562500f,-0.45312500f,0.28125000f,-0.95312500f,-0.21875000f,-0.98437500f,-0.31250000f,-0.68750000f,0.62500000f,-0.23437500f,0.92187500f,0.65625000f,0.10937500f,-0.12500000f,0.93750000f,-0.53125000f,-0.87500000f,0.53125000f,-0.50000000f,-0.75000000f,0.54687500f,-0.17187500f,-0.81250000f,-0.39062500f,-0.17187500f,-0.31250000f,-0.39062500f,0.70312500f,0.25000000f,0.78125000f,0.85937500f,-0.87500000f,-0.98437500f,-0.10937500f,0.32812500f,0.21875000f,-0.46875000f,-0.28125000f,-0.28125000f,0.32812500f,-0.10937500f,-0.21875000f,-0.71875000f,0.79687500f,0.14062500f,0.68750000f,0.78125000f,0.56250000f,0.40625000f,0.32812500f,-0.51562500f,0.40625000f,0.12500000f,0.54687500f,0.42187500f,-0.82812500f,0.68750000f,0.07812500f,-0.73437500f,0.87500000f,0.68750000f,-0.96875000f,0.40625000f,0.95312500f,0.62500000f,0.20312500f,0.73437500f,0.79687500f,0.32812500f,-0.85937500f,0.10937500f,-0.95312500f,-0.73437500f,0.51562500f,0.46875000f,0.51562500f,-0.95312500f,0.34375000f,-0.46875000f,-0.40625000f,0.15625000f,-0.93750000f,0.42187500f,0.59375000f,0.12500000f,0.57812500f,-0.06250000f,0.62500000f,-0.43750000f,0.79687500f,-0.81250000f,-0.40625000f,-0.71875000f,-0.56250000f,-0.70312500f,-0.15625000f,-0.85937500f,0.93750000f,0.53125000f,-0.21875000f,-0.07812500f,-0.75000000f,0.43750000f,-0.96875000f,0.14062500f,-0.64062500f,-0.15625000f,-0.34375000f,-0.29687500f,0.40625000f,-0.03125000f,0.03125000f,-0.50000000f,0.75000000f,-0.48437500f,0.14062500f,0.45312500f,-0.40625000f,0.39062500f,0.65625000f,-0.23437500f,-0.98437500f,0.12500000f,0.62500000f,0.29687500f,-0.50000000f,0.10937500f,-0.75000000f,0.75000000f,-0.26562500f,-0.20312500f,-0.42187500f,0.07812500f,0.67187500f,0.37500000f,-0.14062500f,0.04687500f,0.54687500f,0.09375000f,-0.68750000f,0.60937500f,0.60937500f,-0.60937500f,0.67187500f,-0.31250000f,0.37500000f,0.93750000f,-0.32812500f,-0.51562500f,-0.96875000f,0.96875000f,1.00000000f,0.10937500f,0.95312500f,-0.42187500f,0.65625000f,0.25000000f,-0.18750000f,-0.42187500f,0.64062500f,-0.10937500f,-0.45312500f,-0.96875000f,0.32812500f,0.00000000f,0.35937500f,0.48437500f,-0.20312500f,-0.40625000f,0.12500000f,-0.06250000f,0.62500000f,0.45312500f,0.06250000f,-0.29687500f,0.50000000f,-0.06250000f,-0.39062500f,-0.40625000f,-1.00000000f,0.67187500f,0.45312500f,-0.68750000f,0.26562500f,0.48437500f,0.18750000f,-0.96875000f,0.67187500f,-0.98437500f,0.98437500f,0.17187500f,0.76562500f,-0.26562500f,-0.60937500f,0.40625000f,0.48437500f,0.46875000f,0.48437500f,0.68750000f,0.89062500f,0.39062500f,0.18750000f,0.06250000f,-0.95312500f,0.46875000f,0.23437500f,-0.73437500f,-0.98437500f,0.06250000f,-0.68750000f,-0.20312500f,0.65625000f,0.96875000f,0.25000000f,0.42187500f,-0.01562500f,0.43750000f,0.89062500f,0.00000000f,0.87500000f,0.57812500f,0.42187500f,0.56250000f,-0.20312500f,0.42187500f,0.76562500f,-0.67187500f,0.89062500f,-0.12500000f,-0.04687500f,0.40625000f,-0.70312500f,0.26562500f,-0.09375000f,0.87500000f,-1.00000000f,-0.78125000f,0.48437500f,-0.84375000f,-0.79687500f,0.90625000f,-0.89062500f,-0.46875000f,0.07812500f,0.23437500f,-0.18750000f,-0.51562500f,-0.39062500f,0.29687500f,0.35937500f,0.82812500f,-0.37500000f,0.40625000f,-0.60937500f,0.06250000f,-0.67187500f,0.68750000f,0.12500000f,-0.56250000f,0.50000000f,-0.43750000f,0.10937500f,0.42187500f,-0.84375000f,0.56250000f,-0.28125000f,-0.50000000f,0.50000000f,-0.96875000f,0.98437500f,-0.07812500f,0.62500000f,0.17187500f,0.71875000f,-0.26562500f,-0.07812500f,-0.42187500f,0.87500000f,-0.56250000f,-0.67187500f,0.78125000f,-0.78125000f,0.82812500f,0.14062500f,-0.92187500f,0.01562500f,0.95312500f,-0.54687500f,-0.46875000f,-0.17187500f,0.85937500f,0.00000000f,0.18750000f,-0.48437500f,0.98437500f,-0.51562500f,-0.68750000f,0.81250000f,-0.82812500f,-0.12500000f,0.04687500f,-0.45312500f,-0.48437500f,-0.32812500f,-0.56250000f,-0.20312500f,0.67187500f,-0.17187500f,-0.51562500f,-0.48437500f,0.07812500f,-0.56250000f,-0.67187500f,0.18750000f,1.00000000f,-0.21875000f,-0.12500000f,-0.07812500f,0.51562500f,-0.10937500f,-0.18750000f,-0.82812500f,0.70312500f,1.00000000f,0.25000000f,-0.39062500f,-0.20312500f,0.21875000f,0.39062500f,-0.40625000f,-0.73437500f,0.46875000f,-0.95312500f,-0.31250000f,-0.64062500f,-0.48437500f,0.23437500f,-0.23437500f,-0.21875000f,0.90625000f,-0.87500000f,-0.06250000f,0.79687500f,0.35937500f,0.67187500f,0.12500000f,-0.71875000f,0.75000000f,-0.78125000f,0.37500000f,0.73437500f,-0.79687500f,0.84375000f,-0.79687500f,0.29687500f,-0.42187500f,0.60937500f,0.23437500f,0.67187500f,0.01562500f,-0.68750000f,-0.09375000f,-0.96875000f,0.01562500f,-0.60937500f,0.35937500f,-0.46875000f,-0.34375000f,0.95312500f,-1.00000000f,0.54687500f,0.84375000f,-0.50000000f,-0.57812500f,-0.15625000f,0.53125000f,-0.40625000f,-0.31250000f,0.26562500f,-0.26562500f,-0.85937500f,-0.06250000f,-0.93750000f,-0.96875000f,0.31250000f,-0.59375000f,0.87500000f,0.98437500f,0.82812500f,-0.23437500f,-0.10937500f,0.45312500f,0.73437500f,-0.90625000f,0.64062500f,-0.81250000f,0.79687500f,-0.79687500f,0.71875000f,-0.78125000f,-0.76562500f,0.48437500f,0.18750000f,0.09375000f,-0.06250000f,-0.65625000f,-0.67187500f,0.21875000f,-1.00000000f,-0.89062500f,0.01562500f,-0.75000000f,-0.18750000f,0.57812500f,-0.45312500f,0.17187500f,0.81250000f,0.65625000f,-0.26562500f,-0.90625000f,-0.78125000f,0.82812500f,-0.78125000f,0.07812500f,0.39062500f,0.75000000f,-0.76562500f,0.71875000f,-0.98437500f,-0.51562500f,0.78125000f,-0.46875000f,0.90625000f,-0.57812500f,0.09375000f,-0.81250000f,-0.10937500f,-0.96875000f,-0.68750000f,-0.87500000f,-0.15625000f,-0.17187500f,-0.35937500f,-0.23437500f,-0.98437500f,1.00000000f,0.96875000f,-0.50000000f,0.95312500f,-0.14062500f,-0.93750000f,0.73437500f,-0.59375000f,-0.45312500f,0.18750000f,-0.93750000f,-0.64062500f,-0.89062500f,-0.23437500f,0.76562500f,-0.54687500f,-0.42187500f,0.78125000f,-0.60937500f,0.65625000f,-0.51562500f,-0.95312500f,0.46875000f,0.14062500f,-0.31250000f,-0.96875000f,-0.92187500f,-0.65625000f,0.10937500f,-0.84375000f,-0.70312500f,0.76562500f,0.18750000f,0.84375000f,-1.00000000f,0.90625000f,0.15625000f,-0.93750000f,-0.98437500f,0.59375000f,0.56250000f,-0.93750000f,-0.62500000f,0.07812500f,0.48437500f,-0.56250000f,-0.34375000f,-0.84375000f,-0.56250000f,-0.42187500f,0.75000000f,-0.54687500f,-0.18750000f,0.92187500f,-0.85937500f,0.45312500f,0.78125000f,-0.92187500f,-0.89062500f,-0.95312500f,-0.35937500f,-0.35937500f,0.84375000f,0.60937500f,-0.64062500f,-0.56250000f,0.15625000f,0.54687500f,0.00000000f,0.90625000f,0.43750000f,0.92187500f,0.81250000f,-0.79687500f,0.79687500f,0.60937500f,-0.76562500f,0.53125000f,0.67187500f,0.93750000f,-0.46875000f,0.00000000f,0.57812500f,-0.32812500f,-0.82812500f,0.42187500f,-0.21875000f,-0.09375000f,0.92187500f,-0.98437500f,-0.95312500f,0.06250000f,0.59375000f,0.89062500f,0.32812500f,0.59375000f,0.45312500f,-0.57812500f,-0.09375000f,0.43750000f,-0.32812500f,0.37500000f,-0.06250000f,0.87500000f,0.68750000f,0.59375000f,0.79687500f,0.85937500f,0.35937500f,0.68750000f,0.89062500f,0.57812500f,-0.12500000f,0.20312500f,0.48437500f,-0.84375000f,-0.95312500f,0.68750000f,0.65625000f,-0.87500000f,0.82812500f,0.23437500f,0.15625000f,0.32812500f,0.64062500f,-0.26562500f,-0.39062500f,0.45312500f,-0.85937500f,-0.70312500f,-0.31250000f,-0.64062500f,0.34375000f,0.23437500f,-0.71875000f,0.51562500f,0.37500000f,-0.39062500f,0.04687500f,0.25000000f,0.98437500f,-0.56250000f,0.67187500f,0.04687500f,-0.76562500f,-0.45312500f,0.15625000f,0.75000000f,-0.23437500f,-0.98437500f,0.54687500f,-0.79687500f,-0.64062500f,-0.50000000f,-0.84375000f,0.78125000f,-0.31250000f,0.79687500f,0.31250000f,0.34375000f,0.64062500f,0.59375000f,0.07812500f,0.68750000f,0.06250000f,-0.09375000f,0.01562500f,-0.35937500f,-0.37500000f,-0.46875000f,0.18750000f,0.53125000f,-0.35937500f,-0.98437500f,0.51562500f,-0.28125000f,0.95312500f,0.28125000f,0.46875000f,0.00000000f,-0.34375000f,-0.64062500f,0.18750000f,0.48437500f,-0.32812500f,-0.23437500f,-0.31250000f,-0.28125000f,-0.70312500f,0.25000000f,0.56250000f,-0.17187500f,-0.06250000f,0.39062500f,-0.84375000f,-0.85937500f,0.57812500f,-0.31250000f,0.48437500f,1.00000000f,0.57812500f,-1.00000000f,0.60937500f,0.84375000f,-0.62500000f,0.64062500f,0.07812500f,-0.98437500f,-0.12500000f,-0.85937500f,-0.53125000f,-0.62500000f,-0.79687500f,0.60937500f,0.31250000f,0.25000000f,0.20312500f,0.26562500f,-0.89062500f,0.15625000f,0.68750000f,0.68750000f,0.42187500f,-0.79687500f,0.34375000f,0.67187500f,-0.42187500f,0.84375000f,-0.42187500f,0.70312500f,0.10937500f,0.92187500f,0.29687500f,0.87500000f,-0.79687500f,0.29687500f,-0.09375000f,-0.14062500f,-0.35937500f,0.92187500f,0.03125000f,-0.12500000f,0.92187500f,-0.92187500f,-0.14062500f,-0.15625000f,0.87500000f,-0.71875000f,-0.42187500f,-0.17187500f,-0.87500000f,0.50000000f,0.15625000f,0.42187500f,0.03125000f,0.54687500f,-0.90625000f,0.06250000f,0.12500000f,-0.75000000f,0.06250000f,0.39062500f,-0.81250000f,0.03125000f,-0.50000000f,-0.21875000f,0.64062500f,0.67187500f,-0.67187500f,-0.62500000f,-0.40625000f,-0.04687500f,-0.76562500f,0.81250000f,0.53125000f,-0.43750000f,-0.37500000f,-0.59375000f,-0.57812500f,-0.50000000f,0.15625000f,0.92187500f,-0.23437500f,0.25000000f,-0.53125000f,-0.84375000f,-0.35937500f,-1.00000000f,0.75000000f,0.14062500f,0.34375000f,0.39062500f,0.67187500f,-0.42187500f,-0.82812500f,-0.45312500f,0.98437500f,-0.35937500f,0.81250000f,-0.56250000f,0.76562500f,0.67187500f,-0.81250000f,0.20312500f,-0.67187500f,-0.10937500f,-0.57812500f,-0.95312500f,-0.54687500f,0.23437500f,-0.20312500f,-0.20312500f,-0.04687500f,-0.93750000f,-0.75000000f,-0.32812500f,0.62500000f,0.15625000f,0.51562500f,-0.98437500f,0.32812500f,0.18750000f,0.03125000f,-0.23437500f,0.67187500f,-0.39062500f,-0.60937500f,-0.48437500f,0.92187500f,0.90625000f,0.00000000f,-0.64062500f,0.03125000f,-0.84375000f,0.12500000f,0.57812500f,0.04687500f,-1.00000000f,-0.43750000f,0.03125000f,0.06250000f,0.45312500f,0.67187500f,0.06250000f,-0.43750000f,-0.25000000f,-0.48437500f,0.01562500f,0.31250000f,0.75000000f,0.46875000f,0.37500000f,-0.40625000f,0.57812500f,0.98437500f,-0.65625000f,-0.17187500f,-0.84375000f,-0.23437500f,0.20312500f,0.81250000f,-0.37500000f,0.48437500f,-0.87500000f,-0.54687500f,0.34375000f,-1.00000000f,-0.06250000f,0.31250000f,0.57812500f,0.35937500f,0.37500000f,-0.20312500f,-0.18750000f,-0.85937500f,0.53125000f,0.48437500f,0.29687500f,-0.73437500f,-0.14062500f,0.28125000f,0.20312500f,0.98437500f,0.12500000f,-0.64062500f,0.18750000f,-0.15625000f,0.31250000f,0.03125000f,0.03125000f,-0.76562500f,-0.81250000f,0.15625000f,0.20312500f,0.95312500f,-0.31250000f,0.20312500f,-0.62500000f,-0.73437500f,-0.92187500f,0.93750000f,-0.79687500f,0.14062500f,0.64062500f,-0.32812500f,0.29687500f,0.20312500f,0.71875000f,0.12500000f,-0.90625000f,0.39062500f,0.25000000f,0.95312500f,-0.51562500f,0.73437500f,0.04687500f,-0.78125000f,-0.34375000f,0.09375000f,-0.28125000f,-0.07812500f,-0.50000000f,0.87500000f,0.93750000f,-0.12500000f,0.53125000f,0.70312500f,0.37500000f,0.10937500f,-0.12500000f,0.12500000f,-0.01562500f,-0.01562500f,0.54687500f,-0.26562500f,0.20312500f,0.40625000f,0.70312500f,-0.53125000f,-0.40625000f,0.64062500f,0.21875000f,-0.04687500f,-0.39062500f,0.25000000f,0.37500000f,0.76562500f,-0.46875000f,-0.26562500f,-0.82812500f,-0.31250000f,-0.23437500f,-0.95312500f,-0.84375000f,-0.15625000f,-0.09375000f,-0.98437500f,0.46875000f,-0.62500000f,0.84375000f,0.92187500f,0.01562500f,-0.17187500f,0.64062500f,-0.68750000f,-0.25000000f,0.90625000f,0.79687500f,-0.68750000f,-0.42187500f,0.65625000f,0.98437500f,0.31250000f,-0.43750000f,-0.14062500f,0.26562500f,0.90625000f,0.31250000f,0.40625000f,0.95312500f,-0.43750000f,0.70312500f,-0.81250000f,0.75000000f,0.34375000f,-0.59375000f,-0.15625000f,0.04687500f,0.89062500f,0.57812500f,-0.35937500f,-0.68750000f,0.82812500f,-0.87500000f,0.21875000f,-0.53125000f,0.54687500f,-0.28125000f,-0.45312500f,0.96875000f,0.93750000f,0.15625000f,-0.32812500f,-0.10937500f,-0.09375000f,-0.68750000f,0.21875000f,-0.87500000f,-0.82812500f,0.01562500f,-0.89062500f,0.32812500f,0.35937500f,0.21875000f,0.82812500f,-0.21875000f,0.42187500f,-0.21875000f,0.93750000f,0.51562500f,-0.65625000f,-0.89062500f,-0.75000000f,-0.64062500f,-0.81250000f,0.92187500f,-0.56250000f,0.43750000f,0.84375000f,0.76562500f,0.37500000f,0.60937500f,0.23437500f,-0.60937500f,-0.98437500f,0.21875000f,0.15625000f,0.23437500f,-0.82812500f,0.92187500f,-0.85937500f,0.76562500f,-0.28125000f,0.48437500f,0.18750000f,-0.54687500f,0.68750000f,0.09375000f,0.20312500f,-0.76562500f,-0.78125000f,1.00000000f,0.48437500f,0.50000000f,-0.67187500f,-0.42187500f,0.75000000f,0.20312500f,0.76562500f,0.31250000f,0.06250000f,-0.07812500f,-0.71875000f,0.96875000f,0.45312500f,0.00000000f,0.01562500f,0.48437500f,0.57812500f,-0.32812500f,-0.93750000f,0.48437500f,0.20312500f,-0.87500000f,-0.73437500f,-0.62500000f,-0.82812500f,-0.84375000f,-0.46875000f,0.42187500f,0.23437500f,-0.35937500f,0.09375000f,0.60937500f,-0.96875000f,-0.12500000f,-0.46875000f,-0.31250000f,0.07812500f,-0.46875000f,0.93750000f,-0.20312500f,0.75000000f,-0.81250000f,0.76562500f,0.70312500f,0.53125000f,-0.04687500f,0.00000000f,-0.76562500f,0.85937500f,-0.06250000f,0.84375000f,-0.67187500f,-0.59375000f,-0.90625000f,0.00000000f,-0.29687500f,0.81250000f,0.79687500f,-0.76562500f,-0.87500000f,0.34375000f,-0.76562500f,-0.14062500f,-0.87500000f,0.78125000f,-0.51562500f,0.96875000f,0.18750000f,0.32812500f,-1.00000000f,0.92187500f,-0.32812500f,-0.18750000f,-0.35937500f,-0.03125000f,-0.23437500f,0.39062500f,-0.23437500f,-0.89062500f,-0.79687500f,-0.89062500f,-1.00000000f,-0.12500000f,0.18750000f,0.90625000f,0.56250000f,-0.98437500f,-0.65625000f,0.65625000f,0.28125000f,0.32812500f,0.76562500f,0.96875000f,-0.31250000f,0.12500000f,0.90625000f,0.34375000f,0.42187500f,-0.39062500f,0.53125000f,0.70312500f,0.07812500f,0.46875000f,-0.42187500f,0.50000000f,0.28125000f,0.23437500f,0.70312500f,0.10937500f,-0.45312500f,0.31250000f,0.15625000f,-0.71875000f,-0.76562500f,-0.57812500f,0.75000000f,0.92187500f,0.14062500f,0.46875000f,0.06250000f,0.25000000f,-0.31250000f,-0.59375000f,0.03125000f,0.37500000f,-0.35937500f,0.90625000f,0.23437500f,-0.96875000f,-0.87500000f,0.70312500f,0.95312500f,-0.29687500f,-0.09375000f,-0.39062500f,-0.31250000f,-0.50000000f,-0.53125000f,-0.95312500f,-0.23437500f,-0.01562500f,-0.53125000f,-0.71875000f,-0.56250000f,-0.54687500f,-0.98437500f,-0.21875000f,-0.46875000f,0.98437500f,0.46875000f,0.20312500f,-0.45312500f,-0.32812500f,0.64062500f,-0.76562500f,-0.43750000f,0.56250000f,0.35937500f,-0.76562500f,0.60937500f,0.68750000f,0.96875000f,-0.50000000f,0.48437500f,-0.87500000f,-0.29687500f,-0.01562500f,0.93750000f,0.81250000f,-0.32812500f,0.93750000f,0.79687500f,-0.45312500f,0.64062500f,0.48437500f,-0.87500000f,-0.67187500f,0.78125000f,0.43750000f,-0.15625000f,-0.85937500f,0.42187500f,-0.42187500f,-0.31250000f,0.60937500f,0.12500000f,-0.85937500f,0.34375000f,0.25000000f,-0.85937500f,-0.45312500f,-0.56250000f,-0.84375000f,-0.28125000f,0.87500000f,-0.14062500f,0.95312500f,-0.59375000f,0.43750000f,0.90625000f,-1.00000000f,0.04687500f,-0.60937500f,-0.54687500f,-0.15625000f,0.51562500f,-0.29687500f,-0.40625000f,0.81250000f,-0.67187500f,-0.51562500f,0.15625000f,-0.79687500f,0.04687500f,0.71875000f,-0.79687500f,-0.70312500f,-0.89062500f,0.18750000f,-1.00000000f,-0.98437500f,-0.04687500f,-0.46875000f,-0.09375000f,-0.62500000f,-0.48437500f,-0.29687500f,0.96875000f,0.71875000f,-0.46875000f,0.45312500f,-0.79687500f,0.23437500f,-0.23437500f,0.25000000f,0.20312500f,0.71875000f,-0.20312500f,-0.43750000f,0.48437500f,0.31250000f,-0.89062500f,-0.15625000f,0.98437500f,-0.15625000f,0.56250000f,-0.06250000f,0.85937500f,0.82812500f,-0.32812500f,0.40625000f,0.73437500f,-0.53125000f,-0.82812500f,-0.37500000f,0.70312500f,0.31250000f,-0.56250000f,0.28125000f,-0.20312500f,-0.09375000f,0.98437500f,0.70312500f,0.01562500f,0.25000000f,0.10937500f,0.34375000f,0.14062500f,-0.98437500f,0.79687500f,-0.54687500f,-0.12500000f,0.48437500f,-0.95312500f,-0.21875000f,0.25000000f,0.03125000f,-0.28125000f,-0.17187500f,0.20312500f,0.68750000f,0.48437500f,0.00000000f,0.35937500f,-0.73437500f,0.14062500f,-0.40625000f,-0.96875000f,-0.12500000f,0.12500000f,0.23437500f,0.95312500f,0.39062500f,0.25000000f,-0.96875000f,0.73437500f,-0.96875000f,0.18750000f,0.81250000f,0.90625000f,-0.70312500f,0.84375000f,-0.59375000f,0.32812500f,1.00000000f,0.89062500f,-0.57812500f,-0.43750000f,0.37500000f,0.23437500f,-0.57812500f,-0.34375000f,-0.37500000f,0.85937500f,-0.04687500f,0.29687500f,-0.40625000f,-0.65625000f,-0.85937500f,0.07812500f,-0.75000000f,-0.35937500f,-0.34375000f,0.85937500f,0.18750000f,0.78125000f,-0.25000000f,0.37500000f,0.65625000f,0.03125000f,0.64062500f,0.70312500f,0.37500000f,0.14062500f,0.57812500f,0.84375000f,0.89062500f,0.93750000f,0.51562500f,-0.67187500f,0.32812500f,0.12500000f,0.31250000f,0.70312500f,0.81250000f,-0.96875000f,0.07812500f,0.60937500f,-0.32812500f,-0.71875000f,0.14062500f,0.75000000f,-0.35937500f,-0.90625000f,-0.71875000f,-0.23437500f,-0.75000000f,-0.56250000f,-0.95312500f,0.28125000f,-0.62500000f,0.96875000f,0.65625000f,-0.21875000f,0.67187500f,-0.01562500f,0.85937500f,-0.76562500f,0.75000000f,-0.39062500f,0.76562500f,0.03125000f,0.92187500f,-0.50000000f,0.95312500f,-0.87500000f,-0.01562500f,0.06250000f,-0.03125000f,0.35937500f,-0.81250000f,-0.76562500f,0.87500000f,0.07812500f,0.79687500f,0.85937500f,0.14062500f,0.93750000f,-0.29687500f,-0.98437500f,0.84375000f,-0.06250000f,-0.71875000f,0.03125000f,-0.10937500f,0.42187500f,-0.85937500f,-0.40625000f,-0.96875000f,0.28125000f,0.31250000f,0.98437500f,0.29687500f,-0.46875000f,0.57812500f,-0.54687500f,0.78125000f,0.64062500f,-0.18750000f,0.14062500f,-0.81250000f,-0.75000000f,0.00000000f,-0.56250000f,0.98437500f,0.57812500f,-0.34375000f,0.84375000f,-0.32812500f,-0.57812500f,0.57812500f,0.57812500f,-0.15625000f,-0.15625000f,-0.65625000f,0.73437500f,0.71875000f,-0.04687500f,0.64062500f,-0.71875000f,-0.95312500f,-0.53125000f,-0.64062500f,-0.78125000f,-0.53125000f,-0.34375000f,0.21875000f,0.15625000f,0.21875000f,-0.35937500f,0.71875000f,0.70312500f,-0.07812500f,0.15625000f,0.45312500f,-0.70312500f,0.40625000f,-0.60937500f,-0.95312500f,0.71875000f,-0.60937500f,-0.90625000f,-0.14062500f,0.15625000f,0.75000000f,0.67187500f,-0.67187500f,0.89062500f,-0.82812500f,0.01562500f,-0.54687500f,0.48437500f,0.64062500f,-0.92187500f,0.35937500f,0.62500000f,0.35937500f,0.75000000f,0.29687500f,0.04687500f,-0.64062500f,-0.96875000f,0.29687500f,-0.42187500f,0.90625000f,-0.42187500f,-0.70312500f,0.07812500f,0.73437500f,0.89062500f,-0.70312500f,0.00000000f,-0.70312500f,0.64062500f,0.67187500f,0.43750000f,-0.90625000f,-0.46875000f,0.84375000f,0.01562500f,0.85937500f,-0.23437500f,0.75000000f,-0.23437500f,0.87500000f,-0.39062500f,0.12500000f,0.06250000f,-0.12500000f,-0.71875000f,0.71875000f,-0.48437500f,0.67187500f,0.79687500f,0.01562500f,-0.50000000f,-0.81250000f,0.12500000f,0.15625000f,0.82812500f,0.15625000f,-1.00000000f,0.07812500f,-0.46875000f,0.07812500f,0.85937500f,-0.17187500f,0.50000000f,0.23437500f,-0.26562500f,0.53125000f,-0.40625000f,0.65625000f,0.45312500f,1.00000000f,0.31250000f,-0.51562500f,0.43750000f,0.90625000f,-0.23437500f,0.96875000f,0.85937500f,-0.73437500f,-0.03125000f,0.92187500f,0.54687500f,0.15625000f,-0.57812500f,-0.51562500f,-0.18750000f,-0.92187500f,0.06250000f,0.20312500f,-0.98437500f,0.79687500f,0.82812500f,0.09375000f,0.76562500f,-0.85937500f,0.10937500f,0.10937500f,-0.92187500f,0.45312500f,-0.39062500f,0.01562500f,-0.60937500f,0.79687500f,0.21875000f,-0.50000000f,0.39062500f,-0.35937500f,0.03125000f,0.43750000f,0.14062500f,0.70312500f,0.81250000f,-0.64062500f,-0.25000000f,0.59375000f,0.96875000f,-0.45312500f,-0.89062500f,0.51562500f,0.46875000f,-0.18750000f,0.59375000f,0.75000000f,0.26562500f,0.54687500f,-0.56250000f,-0.23437500f,-0.73437500f,-0.37500000f,0.67187500f,-0.03125000f,-0.29687500f,-0.26562500f,-0.79687500f,0.51562500f,-0.23437500f,-0.53125000f,0.90625000f,-0.59375000f,-0.10937500f,0.78125000f,0.40625000f,-0.85937500f,0.23437500f,0.62500000f,0.71875000f,-0.75000000f,-0.59375000f,0.62500000f,-1.00000000f,0.90625000f,-0.65625000f,-0.71875000f,-0.95312500f,0.25000000f,-0.23437500f,0.23437500f,-0.92187500f,0.07812500f,-0.10937500f,0.43750000f,0.35937500f,-0.10937500f,0.89062500f,-0.09375000f,0.03125000f,-0.92187500f,0.45312500f,0.34375000f,-0.23437500f,0.56250000f,0.28125000f,0.23437500f,-0.32812500f,-0.82812500f,-0.42187500f,-0.53125000f,-0.95312500f,-0.32812500f,0.53125000f,0.29687500f,0.18750000f,-0.14062500f,-0.93750000f,-0.07812500f,-0.06250000f,-0.17187500f,0.42187500f,0.32812500f,-0.39062500f,0.46875000f,0.35937500f,0.67187500f,0.23437500f,0.76562500f,-0.07812500f,-0.25000000f,0.78125000f,-0.64062500f,-0.43750000f,-0.03125000f,-0.48437500f,-0.81250000f,0.18750000f,0.37500000f,0.35937500f,-0.89062500f,1.00000000f,-0.75000000f,-0.93750000f,-0.76562500f,-0.31250000f,-0.93750000f,-0.14062500f,-0.81250000f,-0.95312500f,0.98437500f,0.06250000f,0.76562500f,0.35937500f,0.59375000f,-0.79687500f,-0.07812500f,0.59375000f,0.64062500f,-0.90625000f,0.90625000f,-0.29687500f,-0.37500000f,0.96875000f,-0.39062500f,-0.51562500f,-0.10937500f,0.20312500f,-0.70312500f,-0.85937500f,0.79687500f,-0.20312500f,-0.84375000f,0.84375000f,-0.78125000f,-0.10937500f,0.20312500f,0.78125000f,0.78125000f,0.12500000f,0.14062500f,0.50000000f,0.90625000f,-0.34375000f,-0.43750000f,0.90625000f,0.28125000f,-0.73437500f,0.90625000f,-0.79687500f,-0.71875000f,-0.26562500f,0.40625000f,-0.50000000f,-0.04687500f,0.29687500f,-0.71875000f,-0.60937500f,0.34375000f,-0.93750000f,0.79687500f,0.48437500f,-0.65625000f,0.87500000f,-0.89062500f,-0.82812500f,-0.53125000f,0.60937500f,0.48437500f,-0.67187500f,-0.67187500f,-0.79687500f,-0.06250000f,0.98437500f,0.18750000f,0.56250000f,-0.60937500f,0.87500000f,0.93750000f,-0.17187500f,-0.31250000f,0.92187500f,-0.40625000f,0.48437500f,-0.73437500f,-0.32812500f,-0.31250000f,0.64062500f,-0.23437500f,-0.84375000f,-0.29687500f,0.62500000f,0.90625000f,0.15625000f,-0.65625000f,0.71875000f,0.57812500f,0.20312500f,0.43750000f,0.42187500f,-0.04687500f,0.39062500f,-0.51562500f,-0.79687500f,0.07812500f,-0.10937500f,0.92187500f,-0.32812500f,0.15625000f,-0.59375000f,0.03125000f,0.34375000f,0.95312500f,0.31250000f,-0.56250000f,-0.50000000f,0.28125000f,-0.89062500f,0.06250000f,0.56250000f,-0.15625000f,0.32812500f,-0.37500000f,-0.46875000f,-0.31250000f,-0.95312500f,0.15625000f,0.64062500f,0.59375000f,-0.98437500f,-0.51562500f,-0.12500000f,-0.57812500f,0.37500000f,-0.37500000f,-0.56250000f,-0.32812500f,0.93750000f,-0.03125000f,-0.45312500f,0.48437500f,-0.96875000f,0.53125000f,-0.67187500f,1.00000000f,0.14062500f,-0.62500000f,0.54687500f,0.53125000f,-0.18750000f,0.59375000f,-0.67187500f,-0.23437500f,0.03125000f,0.95312500f,0.17187500f,0.64062500f,0.31250000f,0.98437500f,-0.17187500f,-0.82812500f,-0.60937500f,-0.45312500f,0.67187500f,0.54687500f,-0.06250000f,0.71875000f,-0.92187500f,-0.79687500f,-0.68750000f,0.31250000f,0.29687500f,0.07812500f,-0.26562500f,-0.21875000f,-0.14062500f,0.40625000f,-0.10937500f,0.79687500f,-0.28125000f,0.93750000f,0.26562500f,-0.75000000f,-0.32812500f,-0.35937500f,-0.70312500f,0.84375000f,-0.37500000f,-0.07812500f,0.39062500f,-0.84375000f,0.60937500f,0.40625000f,0.50000000f,0.81250000f,0.12500000f,0.82812500f,0.89062500f,0.84375000f,-0.64062500f,0.81250000f,-0.18750000f,0.85937500f,-0.14062500f,0.35937500f,-0.09375000f,-0.60937500f,0.40625000f,-0.14062500f,0.37500000f,0.37500000f,0.84375000f,0.03125000f,0.54687500f,0.60937500f,0.32812500f,-0.53125000f,-0.04687500f,-0.75000000f,0.37500000f,0.59375000f,-0.42187500f,-0.26562500f,-0.25000000f,0.78125000f,0.29687500f,0.04687500f,0.20312500f,0.26562500f,0.35937500f,-0.76562500f,0.81250000f,-0.01562500f,-1.00000000f,0.90625000f,-0.73437500f,-0.29687500f,0.21875000f,0.01562500f,0.00000000f,-0.28125000f,0.85937500f,0.23437500f,0.54687500f,-0.90625000f,0.90625000f,-0.92187500f,-0.85937500f,0.73437500f,-0.34375000f,-0.04687500f,-0.53125000f,0.42187500f,-0.95312500f,0.23437500f,0.12500000f,0.92187500f,0.32812500f,-0.62500000f,-0.45312500f,-0.57812500f,-0.35937500f,0.35937500f,0.84375000f,-0.54687500f,-0.23437500f,-0.84375000f,-0.34375000f,0.20312500f,-0.39062500f,-0.46875000f,-0.43750000f,0.10937500f,-0.95312500f,0.64062500f,-0.32812500f,0.09375000f,0.00000000f,-0.65625000f,0.42187500f,-0.07812500f,-0.54687500f,0.17187500f,0.35937500f,0.28125000f,-0.46875000f,0.45312500f,-0.23437500f,0.12500000f,-0.96875000f,0.84375000f,-0.37500000f,0.31250000f,0.68750000f,-0.01562500f,-0.79687500f,0.85937500f,0.06250000f,-0.06250000f,-0.85937500f,0.54687500f,-0.03125000f,0.37500000f,-0.06250000f,0.40625000f,0.20312500f,-0.59375000f,0.07812500f,-0.87500000f,0.07812500f,0.65625000f,0.17187500f,0.70312500f,-0.03125000f,-0.79687500f,0.01562500f,-0.60937500f,0.35937500f,0.04687500f,0.37500000f,-0.45312500f,-0.82812500f,0.18750000f,-0.37500000f,-0.53125000f,0.00000000f,-0.06250000f,-0.57812500f,0.00000000f,-0.10937500f,-0.45312500f,0.32812500f,0.93750000f,0.48437500f,0.00000000f,-0.96875000f,0.98437500f,0.95312500f,-0.29687500f,0.98437500f,-0.92187500f,0.39062500f,-0.26562500f,-0.73437500f,-0.85937500f,0.12500000f,0.20312500f,0.29687500f,-0.46875000f,0.03125000f,0.25000000f,-0.32812500f,0.68750000f,-0.37500000f,0.39062500f,-0.75000000f,-0.07812500f,-0.48437500f,-0.32812500f,-0.43750000f,-0.75000000f,0.04687500f,0.06250000f,0.07812500f,-0.65625000f,-0.67187500f,-0.85937500f,-0.23437500f,-0.78125000f,0.48437500f,-0.76562500f,0.76562500f,-0.85937500f,0.35937500f,0.42187500f,1.00000000f,0.20312500f,0.84375000f,0.82812500f,-0.15625000f,0.96875000f,0.12500000f,0.82812500f,-0.03125000f,0.10937500f,-0.68750000f,-0.04687500f,-0.59375000f,0.73437500f,0.78125000f,0.81250000f,0.06250000f,-0.20312500f,-0.50000000f,-0.43750000f,-0.04687500f,-0.81250000f,0.96875000f,-0.71875000f,0.95312500f,0.18750000f,-0.62500000f,0.43750000f,0.00000000f,-0.76562500f,0.64062500f,-0.12500000f,-0.73437500f,-0.28125000f,0.64062500f,-0.96875000f,-0.85937500f,0.65625000f,-0.10937500f,-0.54687500f,0.15625000f,-0.39062500f,-0.25000000f,-0.81250000f,0.73437500f,-0.50000000f,-0.32812500f,0.93750000f,0.35937500f,-0.25000000f,0.73437500f,0.34375000f,-0.46875000f,0.57812500f,-0.04687500f,-0.96875000f,-0.92187500f,0.03125000f,-0.68750000f,0.43750000f,0.12500000f,0.68750000f,-0.28125000f,-0.78125000f,-0.17187500f,0.40625000f,0.57812500f,-0.53125000f,0.06250000f,0.87500000f,-0.70312500f,-0.39062500f,0.60937500f,-0.42187500f,0.60937500f,-0.53125000f,0.98437500f,0.17187500f,-0.32812500f,0.93750000f,-0.14062500f,0.56250000f,-0.12500000f,-0.85937500f,-0.23437500f,-0.10937500f,0.06250000f,0.95312500f,-0.59375000f,-0.46875000f,0.92187500f,0.23437500f,0.10937500f,0.98437500f,0.01562500f,-0.32812500f,0.07812500f,0.03125000f,0.09375000f,0.56250000f,0.32812500f,-0.25000000f,-0.60937500f,-0.90625000f,0.14062500f,-0.45312500f,0.42187500f,-0.62500000f,0.12500000f,0.93750000f,0.92187500f,0.26562500f,0.04687500f,-0.26562500f,0.18750000f,0.81250000f,0.26562500f,0.51562500f,0.28125000f,-0.59375000f,0.20312500f,0.17187500f,0.95312500f,-0.71875000f,-0.23437500f,0.68750000f,0.62500000f,-0.51562500f,-0.12500000f,-0.76562500f,0.53125000f,0.37500000f,-0.46875000f,-0.40625000f,0.51562500f,-0.78125000f,-0.42187500f,0.10937500f,-0.87500000f,0.45312500f,0.06250000f,0.84375000f,-0.64062500f,0.17187500f,0.03125000f,0.43750000f,0.73437500f,0.15625000f,0.45312500f,0.39062500f,0.96875000f,0.82812500f,-0.68750000f,0.68750000f,-0.89062500f,-0.46875000f,0.48437500f,-0.21875000f,-0.92187500f,0.20312500f,0.84375000f,0.28125000f,0.56250000f,0.85937500f,0.43750000f,-0.51562500f,0.65625000f,0.65625000f,0.57812500f,0.03125000f,-0.35937500f,-0.35937500f,0.84375000f,0.48437500f,0.03125000f,0.15625000f,-0.32812500f,-0.32812500f,-0.96875000f,0.46875000f,-0.73437500f,-0.39062500f,0.67187500f,-0.90625000f,-0.15625000f,0.06250000f,-0.39062500f,0.12500000f,-0.84375000f,0.59375000f,0.95312500f,-0.75000000f,0.54687500f,-0.17187500f,-0.31250000f,-0.06250000f,0.68750000f,0.26562500f,-0.51562500f,-0.70312500f,-0.09375000f,0.26562500f,-0.56250000f,0.18750000f,0.64062500f,0.48437500f,0.20312500f,-0.65625000f,0.21875000f,1.00000000f,0.15625000f,-1.00000000f,0.07812500f,0.18750000f,0.29687500f,0.79687500f,-0.23437500f,0.03125000f,0.75000000f,0.62500000f,0.32812500f,0.84375000f,-0.59375000f,-0.25000000f,-0.68750000f,0.68750000f,-0.96875000f,0.84375000f,-0.82812500f,0.78125000f,0.34375000f,-0.76562500f,0.28125000f,-0.34375000f,0.29687500f,-0.06250000f,-0.81250000f,-0.45312500f,-0.54687500f,-0.87500000f,0.62500000f,0.28125000f,0.92187500f,-0.89062500f,0.09375000f,0.65625000f,0.73437500f,-0.29687500f,-0.76562500f,0.25000000f,-0.23437500f,0.14062500f,-0.03125000f,0.84375000f,-0.96875000f,-0.82812500f,0.79687500f,-0.26562500f,0.93750000f,-0.12500000f,0.03125000f,-0.32812500f,-1.00000000f,-0.85937500f,-0.45312500f,0.79687500f,0.46875000f,-0.82812500f,-0.84375000f,0.45312500f,0.82812500f,-0.46875000f,-0.09375000f,-0.62500000f,0.14062500f,0.45312500f,-0.89062500f,-0.56250000f,0.54687500f,0.06250000f,-0.53125000f,-0.98437500f,0.59375000f,-0.01562500f,0.78125000f,-0.04687500f,0.03125000f,-0.09375000f,-0.07812500f,0.03125000f,0.48437500f,-0.42187500f,-0.07812500f,0.09375000f,0.29687500f,-0.89062500f,-0.81250000f,0.76562500f,-0.01562500f,0.28125000f,-0.14062500f,-0.09375000f,0.56250000f,0.78125000f,0.96875000f,-0.78125000f,-0.48437500f,-0.65625000f,0.79687500f,-0.59375000f,-0.76562500f,0.07812500f,0.43750000f,-0.45312500f,-0.79687500f,0.09375000f,0.48437500f,-0.04687500f,-0.73437500f,-0.89062500f,0.14062500f,-0.90625000f,0.10937500f,-0.42187500f,-0.56250000f,-0.15625000f,-0.26562500f,-0.40625000f,-0.95312500f,-0.56250000f,0.85937500f,0.64062500f,0.32812500f,-0.68750000f,-0.46875000f,0.92187500f,-0.82812500f,0.59375000f,0.85937500f,-0.18750000f,-0.23437500f,-0.03125000f,-0.67187500f,0.48437500f,0.59375000f,0.95312500f,-0.18750000f,-0.87500000f,0.71875000f,0.35937500f,-0.65625000f,0.39062500f,0.10937500f,0.06250000f,0.56250000f,-0.23437500f,-0.46875000f,-0.20312500f,0.59375000f,0.39062500f,-0.96875000f,-0.26562500f,-0.93750000f,-0.06250000f,0.15625000f,-0.65625000f,0.03125000f,-0.01562500f,-0.51562500f,-0.68750000f,-0.01562500f,0.89062500f,-0.31250000f,0.79687500f,-0.31250000f,0.89062500f,0.31250000f,-0.12500000f,0.18750000f,-0.43750000f,0.62500000f,0.12500000f,-0.82812500f,-0.81250000f,-0.46875000f,-0.51562500f,0.40625000f,-0.07812500f,0.25000000f,-1.00000000f,0.43750000f,0.76562500f,0.60937500f,0.67187500f,0.40625000f,-0.42187500f,-0.73437500f,-0.56250000f,-0.12500000f,-0.50000000f,0.46875000f,0.06250000f,0.87500000f,-0.68750000f,0.65625000f,-0.35937500f,0.51562500f,0.03125000f,-0.54687500f,0.37500000f,-0.78125000f,0.43750000f,0.14062500f,0.15625000f,-0.07812500f,0.25000000f,0.68750000f,0.31250000f,0.37500000f,-0.78125000f,-0.73437500f,-0.68750000f,-0.40625000f,0.95312500f,-0.75000000f,-0.89062500f,-0.73437500f,0.48437500f,-0.17187500f,0.32812500f,0.71875000f,-0.62500000f,-0.25000000f,-0.04687500f,0.28125000f,-0.81250000f,-0.25000000f,0.03125000f,0.29687500f,-0.40625000f,0.64062500f,0.84375000f,-0.40625000f,0.92187500f,-0.35937500f,0.87500000f,0.25000000f,0.34375000f,-0.04687500f,0.85937500f,0.81250000f,0.84375000f,-0.70312500f,0.10937500f,-0.21875000f,-0.48437500f,0.50000000f,-0.29687500f,0.75000000f,-0.50000000f,0.23437500f,0.03125000f,0.37500000f,0.60937500f,0.34375000f,0.79687500f,-0.71875000f,-0.50000000f,0.84375000f,-0.29687500f,0.40625000f,-0.85937500f,-0.29687500f,0.98437500f,0.14062500f,0.48437500f,-0.75000000f,0.18750000f,-0.75000000f,-0.62500000f,-0.18750000f,-0.92187500f,0.81250000f,-0.64062500f,0.71875000f,-0.82812500f,-0.53125000f,-0.70312500f,0.15625000f,-0.53125000f,0.09375000f,-0.45312500f,0.79687500f,0.14062500f,0.96875000f,-0.28125000f,0.32812500f,0.92187500f,0.78125000f,-0.07812500f,0.79687500f,0.85937500f,0.06250000f,0.98437500f,-0.14062500f,-0.53125000f,-0.92187500f,0.01562500f,-0.20312500f,0.25000000f,-0.70312500f,-0.89062500f,0.84375000f,-0.64062500f,0.67187500f,0.75000000f,-0.35937500f,-0.59375000f,0.68750000f,0.71875000f,-0.45312500f,0.45312500f,0.31250000f,0.37500000f,0.53125000f,-0.68750000f,0.12500000f,0.73437500f,-0.67187500f,0.84375000f,0.90625000f,0.01562500f,-0.15625000f,-0.07812500f,-0.73437500f,-0.73437500f,0.54687500f,0.34375000f,-0.68750000f,0.56250000f,-1.00000000f,0.00000000f,0.32812500f,-0.95312500f,0.34375000f,0.43750000f,0.70312500f,-0.93750000f,-0.40625000f,0.00000000f,0.06250000f,0.26562500f,0.20312500f,0.09375000f,-0.15625000f,0.18750000f,-0.51562500f,0.84375000f,0.07812500f,-0.29687500f,-0.03125000f,0.84375000f,0.20312500f,-0.57812500f,0.45312500f,-0.35937500f,-0.54687500f,-0.37500000f,0.43750000f,0.34375000f,0.43750000f,-0.93750000f,-0.18750000f,-0.42187500f,-0.75000000f,-0.15625000f,-0.43750000f,-0.92187500f,-0.12500000f,-0.56250000f,-0.92187500f,0.54687500f,0.84375000f,0.39062500f,0.23437500f,-0.37500000f,0.67187500f,-0.65625000f,0.76562500f,0.92187500f,-0.18750000f,-0.90625000f,-0.34375000f,0.87500000f,-0.46875000f,0.20312500f,-0.67187500f,-0.15625000f,0.75000000f,-0.23437500f,0.40625000f,0.10937500f,0.37500000f,-0.93750000f,-0.75000000f,-0.07812500f,-0.76562500f,-0.95312500f,0.28125000f,-0.26562500f,-0.98437500f,0.04687500f,-0.76562500f,-0.39062500f,-0.03125000f,0.79687500f,0.87500000f,0.96875000f,-0.04687500f,-0.50000000f,0.31250000f,0.06250000f,-0.70312500f,-0.25000000f,-0.12500000f,-0.64062500f,-0.01562500f,0.40625000f,0.62500000f,0.78125000f,-0.10937500f,0.54687500f,0.67187500f,0.73437500f,0.71875000f,-0.76562500f,0.70312500f,0.26562500f,-0.09375000f,0.12500000f,0.26562500f,-0.12500000f,-0.54687500f,0.46875000f,0.25000000f,0.81250000f,0.10937500f,0.78125000f,-0.40625000f,-0.04687500f,0.18750000f,-0.10937500f,0.71875000f,0.03125000f,0.18750000f,0.90625000f,-0.93750000f,-0.87500000f,-0.60937500f,0.84375000f,0.68750000f,0.68750000f,-0.56250000f,0.87500000f,-0.09375000f,-0.23437500f,-0.92187500f,-0.89062500f,-0.59375000f,0.23437500f,0.23437500f,0.64062500f,-0.71875000f,0.65625000f,0.45312500f,-0.25000000f,0.60937500f,0.35937500f,-0.95312500f,1.00000000f,0.60937500f,0.62500000f,0.00000000f,0.85937500f,0.75000000f,0.60937500f,0.76562500f,-0.48437500f,0.73437500f,0.34375000f,-0.04687500f,-0.96875000f,0.81250000f,0.35937500f,0.73437500f,0.04687500f,0.54687500f,-0.14062500f,0.56250000f,-0.62500000f,0.35937500f,-0.06250000f,0.15625000f,0.14062500f,0.06250000f,0.60937500f,-0.17187500f,0.07812500f,0.50000000f,0.65625000f,-0.71875000f,0.53125000f,0.17187500f,-0.45312500f,0.90625000f,0.50000000f,-0.56250000f,0.37500000f,-0.20312500f,-0.78125000f,0.79687500f,0.82812500f,0.79687500f,-0.67187500f,-0.96875000f,0.43750000f,0.00000000f,0.95312500f,-0.96875000f,-0.23437500f,-0.21875000f,0.48437500f,0.87500000f,0.85937500f,-0.09375000f,0.84375000f,-0.48437500f,-0.96875000f,0.43750000f,0.28125000f,0.78125000f,-0.62500000f,-0.79687500f,-0.35937500f,-0.04687500f,-0.81250000f,-0.01562500f,0.07812500f,-0.17187500f,0.70312500f,0.01562500f,0.85937500f,-0.18750000f,0.17187500f,-0.98437500f,0.07812500f,-0.62500000f,0.34375000f,-0.32812500f,-0.42187500f,0.42187500f,0.17187500f,0.50000000f,0.07812500f,-0.18750000f,0.50000000f,-0.82812500f,0.17187500f,-0.67187500f,0.03125000f,-0.35937500f,0.12500000f,-0.71875000f,-0.25000000f,0.21875000f,0.50000000f,0.28125000f,0.57812500f,-0.54687500f,-0.15625000f,0.03125000f,0.15625000f,-0.45312500f,0.40625000f,-1.00000000f,-0.42187500f,-0.40625000f,0.65625000f,-0.62500000f,-0.95312500f,0.56250000f,0.42187500f,-0.15625000f,0.79687500f,1.00000000f,0.00000000f,-0.79687500f,0.84375000f,0.89062500f,-0.26562500f,0.03125000f,-0.54687500f,0.15625000f,-0.31250000f,-0.53125000f,0.51562500f,-0.09375000f,-0.40625000f,0.26562500f,-0.48437500f,-0.53125000f,0.06250000f,0.42187500f,-0.93750000f,-0.34375000f,-0.34375000f,0.23437500f,0.01562500f,-0.20312500f,-0.21875000f,-0.04687500f,0.85937500f,0.21875000f,-0.79687500f,-0.92187500f,-0.89062500f,0.21875000f,-0.59375000f,-0.71875000f,0.12500000f,0.20312500f,-0.48437500f,0.62500000f,0.90625000f,0.01562500f,-0.71875000f,-0.95312500f,-0.90625000f,0.01562500f,-0.31250000f,0.96875000f,-0.39062500f,0.07812500f,0.53125000f,0.96875000f,0.26562500f,0.20312500f,0.40625000f,-0.56250000f,-1.00000000f,0.37500000f,0.75000000f,0.09375000f,0.81250000f,0.90625000f,-0.57812500f,0.23437500f,0.92187500f,0.12500000f,-0.25000000f,-0.07812500f,-0.03125000f,-0.85937500f,-0.90625000f,-0.35937500f,0.89062500f,-0.70312500f,0.96875000f,-1.00000000f,0.84375000f,0.03125000f,-0.84375000f,0.89062500f,-0.92187500f,0.04687500f,0.20312500f,0.17187500f,0.51562500f,-0.34375000f,0.04687500f,0.89062500f,0.07812500f,0.26562500f,0.29687500f,0.65625000f,0.73437500f,-0.29687500f,0.96875000f,0.50000000f,-0.95312500f,0.92187500f,0.98437500f,0.73437500f,-0.59375000f,-0.76562500f,-0.50000000f,-0.65625000f,-0.37500000f,-0.89062500f,-0.29687500f,-0.15625000f,0.51562500f,-0.53125000f,-0.56250000f,-0.28125000f,-0.35937500f,-0.10937500f,-0.29687500f,-0.34375000f,-0.35937500f,-0.65625000f,-0.07812500f,0.89062500f,0.75000000f,-0.37500000f,0.15625000f,0.34375000f,-0.06250000f,0.01562500f,0.23437500f,0.56250000f,0.89062500f,0.65625000f,0.17187500f,0.87500000f,-0.39062500f,-0.17187500f,0.57812500f,0.56250000f,0.75000000f,0.32812500f,0.50000000f,-0.51562500f,-0.09375000f,0.00000000f,0.48437500f,0.67187500f,-0.46875000f,-0.65625000f,0.53125000f,0.12500000f,-0.31250000f,-0.40625000f,-0.84375000f,0.53125000f,-0.04687500f,0.43750000f,-0.73437500f,-0.03125000f,0.31250000f,0.81250000f,0.23437500f,0.23437500f,-0.03125000f,-0.46875000f,-0.23437500f,-0.15625000f,0.09375000f,-0.62500000f,0.65625000f,-0.42187500f,0.18750000f,-0.64062500f,-0.76562500f,0.98437500f,-0.35937500f,-0.28125000f,-0.70312500f,-0.73437500f,-0.85937500f,-0.57812500f,-0.50000000f,-0.35937500f,0.07812500f,-0.87500000f,0.04687500f,-0.26562500f,0.73437500f,-0.87500000f,-0.42187500f,0.54687500f,0.65625000f,0.84375000f,0.64062500f,-0.85937500f,-0.89062500f,-0.14062500f,-0.64062500f,-0.03125000f,-0.28125000f,0.82812500f,-0.70312500f,0.81250000f,0.93750000f,0.96875000f,-0.17187500f,-0.01562500f,0.65625000f,0.87500000f,-0.23437500f,-0.81250000f,0.39062500f,-0.45312500f,-0.75000000f,-0.96875000f,1.00000000f,0.62500000f,-0.32812500f,-0.73437500f,-0.50000000f,0.76562500f,-0.76562500f,0.32812500f,0.95312500f,-0.50000000f,0.70312500f,-0.31250000f,0.15625000f,-0.54687500f,-0.35937500f,0.89062500f,0.09375000f,-0.96875000f,0.84375000f,-0.06250000f,0.31250000f,-0.50000000f,0.85937500f,0.67187500f,0.67187500f,0.76562500f,0.25000000f,0.48437500f,0.09375000f,-0.26562500f,0.43750000f,-0.04687500f,-0.87500000f,0.76562500f,-0.40625000f,0.21875000f,-0.82812500f,0.56250000f,-0.23437500f,-0.48437500f,0.85937500f,-0.37500000f,0.96875000f,-0.71875000f,0.62500000f,0.42187500f,0.29687500f,-0.96875000f,-0.73437500f,-0.87500000f,-1.00000000f,-0.51562500f,0.90625000f,0.95312500f,-0.96875000f,0.85937500f,-0.09375000f,-0.87500000f,-0.46875000f,-0.76562500f,-0.57812500f,-0.20312500f,0.32812500f,-0.01562500f,0.96875000f,0.45312500f,-0.35937500f,0.03125000f,0.76562500f,-0.93750000f,0.79687500f,0.95312500f,0.28125000f,0.45312500f,-0.10937500f,-0.56250000f,-0.56250000f,0.01562500f,0.03125000f,0.00000000f,-0.18750000f,-0.93750000f,-0.31250000f,-0.34375000f,-0.32812500f,0.26562500f,-0.42187500f,0.34375000f,0.76562500f,0.68750000f,0.96875000f,0.84375000f,0.76562500f,0.39062500f,-0.31250000f,0.29687500f,0.54687500f,0.29687500f,0.89062500f,-0.95312500f,-0.48437500f,-0.15625000f,-0.64062500f,-0.84375000f,0.42187500f,-0.81250000f,0.93750000f,0.73437500f,-0.64062500f,-0.26562500f,0.45312500f,-0.95312500f,0.93750000f,0.40625000f,-0.45312500f,-0.93750000f,-0.15625000f,-0.73437500f,0.01562500f,0.50000000f,-0.12500000f,-0.96875000f,0.37500000f,0.79687500f,0.92187500f,-0.10937500f,-0.90625000f,-0.62500000f,0.53125000f,0.39062500f,0.92187500f,-0.95312500f,0.65625000f,-0.17187500f,0.93750000f,-0.64062500f,0.37500000f,0.26562500f,-0.62500000f,-0.75000000f,-0.81250000f,0.37500000f,-0.20312500f,0.00000000f,0.79687500f,-0.56250000f,0.59375000f,1.00000000f,-0.50000000f,0.40625000f,-0.95312500f,-0.87500000f,0.92187500f,0.28125000f,0.98437500f,0.70312500f,-0.95312500f,-0.35937500f,-0.96875000f,0.51562500f,-0.04687500f,-0.78125000f,-0.93750000f,0.06250000f,-0.70312500f,0.06250000f,-0.42187500f,-0.51562500f,-0.65625000f,-1.00000000f,-0.01562500f,0.54687500f,-0.25000000f,0.09375000f,0.87500000f,0.07812500f,0.68750000f,0.20312500f,0.31250000f,-0.28125000f,0.57812500f,-0.14062500f,-0.93750000f,-0.78125000f,0.35937500f,-0.18750000f,-0.07812500f,0.60937500f,-0.18750000f,-0.90625000f,0.35937500f,-0.28125000f,0.23437500f,-0.87500000f,-0.93750000f,-0.06250000f,-0.18750000f,0.12500000f,0.96875000f,-0.01562500f,-0.85937500f,0.29687500f,-0.42187500f,-0.43750000f,-0.56250000f,-0.93750000f,0.96875000f,-0.29687500f,0.29687500f,0.73437500f,0.01562500f,-0.35937500f,0.28125000f,-0.65625000f,-0.18750000f,-0.43750000f,-0.10937500f,0.35937500f,-0.01562500f,-0.84375000f,0.28125000f,0.67187500f,0.25000000f,0.50000000f,0.23437500f,-0.81250000f,0.10937500f,-0.56250000f,0.54687500f,0.07812500f,-0.76562500f,0.14062500f,-0.17187500f,0.93750000f,-0.28125000f,-0.78125000f,-0.68750000f,0.45312500f,0.09375000f,0.75000000f,0.50000000f,0.01562500f,-0.23437500f,-0.68750000f,0.57812500f,0.73437500f,-0.46875000f,-0.82812500f,0.40625000f,-0.15625000f,0.81250000f,-0.40625000f,-0.25000000f,-0.85937500f,-0.71875000f,0.71875000f,0.78125000f,0.90625000f,0.87500000f,-0.90625000f,0.64062500f,0.40625000f,-0.34375000f,0.17187500f,0.06250000f,0.87500000f,0.48437500f,-0.34375000f,1.00000000f,0.10937500f,-0.51562500f,-0.73437500f,0.81250000f,-0.95312500f,0.53125000f,-0.46875000f,0.20312500f,0.75000000f,-0.87500000f,-0.85937500f,0.71875000f,0.37500000f,-0.59375000f,-0.06250000f,-0.64062500f,-0.70312500f,0.40625000f,-0.12500000f,0.98437500f,0.03125000f,-0.93750000f,-0.23437500f,-0.20312500f,0.34375000f,0.10937500f,0.43750000f,-0.34375000f,-0.26562500f,-0.75000000f,0.48437500f,0.01562500f,0.81250000f,0.62500000f,0.31250000f,-0.60937500f,-0.40625000f,-0.87500000f,-0.87500000f,-0.42187500f,-0.70312500f,-0.89062500f,0.50000000f,-0.21875000f,0.50000000f,-0.87500000f,-0.82812500f,-0.31250000f,0.71875000f,0.90625000f,0.17187500f,0.45312500f,-0.67187500f,-0.54687500f,-0.64062500f,0.79687500f,-0.71875000f,0.73437500f,0.45312500f,-0.32812500f,-0.67187500f,0.98437500f,-0.85937500f,-0.01562500f,0.75000000f,-0.40625000f,-0.84375000f,0.04687500f,0.70312500f,0.45312500f,-0.89062500f,-0.54687500f,-0.17187500f,-0.59375000f,0.85937500f,-0.31250000f,0.46875000f,-0.29687500f,0.26562500f,-0.06250000f,-0.70312500f,0.79687500f,0.62500000f,-0.84375000f,0.07812500f,0.96875000f,0.59375000f,-0.65625000f,0.26562500f,0.01562500f,0.23437500f,-0.50000000f,-0.32812500f,-0.78125000f,-0.59375000f,0.76562500f,-0.60937500f,0.10937500f,0.35937500f,-0.62500000f,0.17187500f,0.67187500f,-0.10937500f,0.25000000f,0.21875000f,0.82812500f,0.84375000f,0.92187500f,0.42187500f,-0.57812500f,0.39062500f,0.78125000f,-0.71875000f,0.32812500f,0.64062500f,-0.64062500f,-0.59375000f,0.48437500f,0.82812500f,-0.87500000f,0.40625000f,0.37500000f,-0.57812500f,0.12500000f,-0.10937500f,-0.03125000f,-0.68750000f,-0.70312500f,0.48437500f,0.14062500f,-0.78125000f,0.60937500f,0.23437500f,0.79687500f,0.14062500f,-0.68750000f,0.95312500f,0.14062500f,0.01562500f,-0.84375000f,-0.76562500f,-0.15625000f,-0.23437500f,0.59375000f,-0.14062500f,-0.75000000f,0.25000000f,0.04687500f,-0.28125000f,-0.03125000f,0.75000000f,-0.34375000f,-0.42187500f,-0.34375000f,-0.20312500f,0.17187500f,0.64062500f,-0.43750000f,0.79687500f,-0.25000000f,-0.03125000f,-0.56250000f,0.23437500f,0.32812500f,-0.03125000f,-0.01562500f,0.87500000f,-1.00000000f,-0.54687500f,-0.43750000f,0.07812500f,-0.82812500f,-0.48437500f,-0.82812500f,0.04687500f,-0.76562500f,-0.45312500f,0.65625000f,0.10937500f,-0.20312500f,0.21875000f,0.32812500f,0.96875000f,0.04687500f,0.87500000f,-0.35937500f,0.31250000f,-0.85937500f,0.29687500f,0.56250000f,-0.17187500f,0.76562500f,0.09375000f,0.09375000f,0.75000000f,0.45312500f,0.64062500f,-0.04687500f,-0.90625000f,0.87500000f,0.20312500f,-0.12500000f,0.87500000f,-0.20312500f,0.48437500f,0.35937500f,0.32812500f,0.03125000f,0.76562500f,-0.57812500f,-0.59375000f,0.82812500f,0.51562500f,-0.68750000f,-0.62500000f,-0.31250000f,-0.35937500f,0.95312500f,-0.40625000f,-0.03125000f,-0.96875000f,-1.00000000f,0.01562500f,0.09375000f,0.84375000f,-0.87500000f,-0.81250000f,0.31250000f,-0.51562500f,-0.51562500f,0.54687500f,-0.23437500f,0.17187500f,-0.04687500f,0.56250000f,-0.32812500f,-0.89062500f,0.10937500f,0.43750000f,-0.23437500f,-0.67187500f,-0.78125000f,-0.60937500f,-0.23437500f,0.31250000f,-0.95312500f,0.98437500f,-0.96875000f,0.75000000f,0.70312500f,0.70312500f,-0.96875000f,-0.14062500f,0.93750000f,0.48437500f,-0.82812500f,0.84375000f,0.84375000f,-0.06250000f,0.42187500f,-0.01562500f,0.23437500f,-0.84375000f,1.00000000f,-0.84375000f,0.57812500f,-0.54687500f,0.17187500f,0.73437500f,0.87500000f,-0.45312500f,-0.04687500f,-0.39062500f,0.60937500f,0.34375000f,0.76562500f,-0.62500000f,0.43750000f,0.96875000f,0.84375000f,-0.62500000f,0.51562500f,-0.21875000f,0.65625000f,-0.59375000f,-0.18750000f,0.90625000f,0.45312500f,0.89062500f,0.04687500f,-0.17187500f,-0.28125000f,0.14062500f,0.29687500f,-0.46875000f,-0.43750000f,0.57812500f,-0.96875000f,0.28125000f,-0.20312500f,-0.62500000f,-0.68750000f,0.31250000f,0.39062500f,0.98437500f,0.57812500f,-0.57812500f,-0.78125000f,0.42187500f,0.81250000f,-0.95312500f,-0.25000000f,-0.50000000f,-0.18750000f,-0.39062500f,-0.40625000f,-0.29687500f,-0.70312500f,0.84375000f,0.40625000f,-0.06250000f,0.60937500f,-0.12500000f,-0.20312500f,0.84375000f,-0.53125000f,0.85937500f,-0.96875000f,0.84375000f,-0.03125000f,0.29687500f,-0.53125000f,-0.40625000f,0.92187500f,-0.48437500f,0.07812500f,0.98437500f,0.76562500f,0.79687500f,-0.81250000f,0.54687500f,0.01562500f,0.03125000f,0.34375000f,0.06250000f,-0.73437500f,0.01562500f,0.09375000f,-0.92187500f,-0.35937500f,-0.64062500f,-0.64062500f,0.10937500f,-0.82812500f,0.39062500f,-0.20312500f,-0.20312500f,0.15625000f,0.09375000f,-0.70312500f,0.26562500f,-0.28125000f,-0.46875000f,0.40625000f,0.64062500f,0.67187500f,0.12500000f,-0.68750000f,0.50000000f,-0.50000000f,0.79687500f,-0.15625000f,-0.26562500f,0.73437500f,0.92187500f,-0.48437500f,0.15625000f,-0.93750000f,-0.21875000f,0.95312500f,-0.37500000f,-0.45312500f,0.78125000f,0.78125000f,-0.70312500f,0.48437500f,-0.75000000f,0.89062500f,-0.14062500f,-0.23437500f,-0.17187500f,0.54687500f,-0.81250000f,0.01562500f,-0.78125000f,0.26562500f,-0.85937500f,-0.75000000f,0.40625000f,-0.93750000f,0.79687500f,-0.09375000f,-0.35937500f,-0.43750000f,-0.15625000f,0.50000000f,-0.06250000f,-0.59375000f,0.85937500f,0.39062500f,-0.06250000f,0.37500000f,-0.64062500f,-0.68750000f,0.31250000f,0.96875000f,0.56250000f,0.25000000f,0.48437500f,-0.14062500f,0.20312500f,1.00000000f,-0.67187500f,-0.46875000f,0.17187500f,0.09375000f,0.10937500f,0.85937500f,-0.10937500f,-0.71875000f,-0.51562500f,0.85937500f,-0.26562500f,0.71875000f,0.81250000f,-0.93750000f,-0.50000000f,-0.54687500f,0.84375000f,-0.60937500f,-0.62500000f,0.51562500f,0.93750000f,-0.26562500f,0.15625000f,0.56250000f,0.71875000f,0.51562500f,-0.84375000f,-0.50000000f,-0.28125000f,-0.81250000f,-0.34375000f,-0.09375000f,-0.03125000f,-0.25000000f,0.07812500f,-0.07812500f,0.78125000f,0.90625000f,-0.14062500f,0.17187500f,-0.95312500f,-0.21875000f,0.67187500f,-0.96875000f,0.25000000f,1.00000000f,0.07812500f,0.15625000f,-0.06250000f,0.71875000f,-0.87500000f,-0.12500000f,0.07812500f,-0.35937500f,-0.39062500f,0.17187500f,-0.57812500f,-0.46875000f,0.76562500f,-0.46875000f,0.57812500f,-0.65625000f,0.00000000f,-0.40625000f,0.34375000f,-0.48437500f,0.12500000f,0.75000000f,-0.04687500f,0.23437500f,0.42187500f,0.50000000f,0.67187500f,0.68750000f,0.73437500f,0.95312500f,-0.71875000f,-0.10937500f,-0.87500000f,-0.42187500f,0.48437500f,0.60937500f,-0.12500000f,-0.67187500f,-0.31250000f,-0.65625000f,-0.95312500f,-0.51562500f,0.10937500f,0.81250000f,0.54687500f,0.59375000f,-0.48437500f,-0.81250000f,-0.54687500f,0.07812500f,-0.82812500f,0.07812500f,1.00000000f,-0.67187500f,0.20312500f,0.59375000f,-0.18750000f,-0.50000000f,-0.46875000f,0.25000000f,0.20312500f,0.37500000f,-0.85937500f,0.46875000f,-0.79687500f,0.57812500f,0.71875000f,-0.07812500f,-0.79687500f,-0.29687500f,0.78125000f,0.64062500f,-0.15625000f,-0.32812500f,-0.62500000f,0.40625000f,-0.71875000f,-0.46875000f,0.14062500f,0.20312500f,-0.78125000f,0.43750000f,0.01562500f,0.60937500f,-0.82812500f,-0.50000000f,-0.34375000f,0.26562500f,-0.84375000f,-0.32812500f,0.01562500f,-0.76562500f,-0.84375000f,-0.25000000f,-0.34375000f,-0.51562500f,0.57812500f,0.14062500f,-0.26562500f,-0.43750000f,-0.31250000f,0.73437500f,0.62500000f,0.76562500f,-0.53125000f,-0.29687500f,-0.82812500f,-0.60937500f,-0.03125000f,-0.32812500f,-0.76562500f,0.09375000f,0.76562500f,0.92187500f,0.35937500f,0.29687500f,0.75000000f,-0.98437500f,-0.10937500f,-0.73437500f,0.10937500f,-0.53125000f,-0.56250000f,0.35937500f,0.71875000f,-0.26562500f,-0.68750000f,0.28125000f,0.15625000f,0.10937500f,-0.62500000f,0.65625000f,-0.21875000f,0.81250000f,-0.10937500f,0.25000000f,0.68750000f,-0.81250000f,-0.64062500f,0.35937500f,0.01562500f,-0.43750000f,0.76562500f,0.34375000f,-0.57812500f,0.40625000f,0.56250000f,-0.65625000f,0.98437500f,-0.68750000f,0.56250000f,0.46875000f,0.90625000f,0.06250000f,0.68750000f,0.75000000f,0.26562500f,0.14062500f,0.34375000f,-0.81250000f,0.25000000f,0.76562500f,0.85937500f,0.31250000f,-0.34375000f,0.95312500f,-0.95312500f,-0.09375000f,-0.78125000f,-0.89062500f,0.17187500f,-0.57812500f,0.82812500f,0.25000000f,-0.98437500f,0.68750000f,0.92187500f,-0.15625000f,0.46875000f,-0.18750000f,-0.93750000f,0.42187500f,0.85937500f,0.01562500f,0.78125000f,0.60937500f,-0.78125000f,-0.28125000f,-0.89062500f,0.56250000f,0.34375000f,0.70312500f,0.89062500f,0.25000000f,0.21875000f,0.14062500f,-1.00000000f,-0.17187500f,0.25000000f,-0.21875000f,-0.89062500f,0.79687500f,-0.82812500f,0.76562500f,0.42187500f,0.73437500f,0.51562500f,-0.17187500f,-0.01562500f,-0.20312500f,0.01562500f,-0.04687500f,0.03125000f,0.42187500f,0.29687500f,-0.25000000f,0.31250000f,0.04687500f,-0.23437500f,0.14062500f,0.26562500f,-0.68750000f,-0.60937500f,-0.82812500f,0.18750000f,0.14062500f,0.53125000f,-0.42187500f,-0.01562500f,-0.18750000f,-0.26562500f,0.62500000f,0.26562500f,0.98437500f,0.93750000f,0.06250000f,0.81250000f,0.15625000f,-0.21875000f,-0.78125000f,0.18750000f,-0.17187500f,0.21875000f,-0.28125000f,-0.06250000f,0.06250000f,0.46875000f,-0.82812500f,0.96875000f,-0.14062500f,0.18750000f,0.84375000f,0.01562500f,-0.81250000f,0.26562500f,0.10937500f,-0.71875000f,0.45312500f,0.67187500f,0.67187500f,0.48437500f,-0.17187500f,0.98437500f,-0.17187500f,-0.35937500f,-0.50000000f,0.70312500f,-0.18750000f,0.89062500f,-0.50000000f,0.89062500f,0.84375000f,-0.03125000f,0.40625000f,-0.68750000f,-0.10937500f,-0.68750000f,0.62500000f,0.35937500f,0.92187500f,-0.68750000f,-0.17187500f,0.68750000f,0.17187500f,0.57812500f,0.34375000f,0.96875000f,-0.43750000f,0.50000000f,0.89062500f,0.75000000f,0.20312500f,-0.14062500f,-0.84375000f,-0.07812500f,-0.89062500f,0.45312500f,-0.53125000f,0.82812500f,-0.60937500f,-0.34375000f,-0.37500000f,0.12500000f,0.45312500f,-0.76562500f,-0.17187500f,0.78125000f,0.12500000f,0.76562500f,0.29687500f,0.42187500f,0.57812500f,-0.12500000f,-0.09375000f,0.29687500f,-0.35937500f,-0.98437500f,-0.54687500f,-1.00000000f,-0.85937500f,0.56250000f,0.20312500f,-0.82812500f,-0.26562500f,0.20312500f,0.71875000f,-0.50000000f,-0.32812500f,0.92187500f,0.20312500f,-0.81250000f,-0.59375000f,0.98437500f,0.78125000f,0.82812500f,-0.98437500f,-0.21875000f,0.10937500f,-0.37500000f,0.21875000f,0.45312500f,-0.95312500f,0.46875000f,0.64062500f,-0.62500000f,0.50000000f,-0.01562500f,-0.01562500f,-0.90625000f,-0.68750000f,0.85937500f,0.43750000f,-0.34375000f,-0.90625000f,0.68750000f,-0.76562500f,-0.95312500f,0.73437500f,-0.06250000f,-0.96875000f,0.79687500f,-0.68750000f,0.56250000f,0.12500000f,0.53125000f,-0.42187500f,-0.18750000f,-0.10937500f,-0.82812500f,0.85937500f,-0.37500000f,-0.73437500f,0.28125000f,-0.60937500f,-0.04687500f,0.45312500f,0.60937500f,0.79687500f,0.07812500f,-0.50000000f,0.90625000f,0.10937500f,-0.65625000f,-0.10937500f,0.75000000f,-0.64062500f,-0.18750000f,0.64062500f,0.18750000f,-0.64062500f,0.35937500f,0.85937500f,0.12500000f,0.70312500f,-0.56250000f,-0.04687500f,-0.70312500f,-0.43750000f,0.71875000f,0.85937500f,-0.96875000f,-0.96875000f,-0.71875000f,-0.64062500f,-0.17187500f,-0.28125000f,0.45312500f,0.03125000f,-0.17187500f,0.39062500f,-0.17187500f,0.43750000f,0.20312500f,-0.40625000f,-0.79687500f,0.21875000f,-0.82812500f,-0.81250000f,-0.53125000f,-0.64062500f,0.51562500f,-0.14062500f,0.67187500f,-0.60937500f,0.62500000f,-0.14062500f,-0.92187500f,-0.75000000f,-0.18750000f,0.48437500f,-0.62500000f,0.01562500f,-0.90625000f,0.03125000f,-0.87500000f,-0.76562500f,0.00000000f,-0.95312500f,0.00000000f,-0.93750000f,0.12500000f,-0.20312500f,-0.81250000f,0.57812500f,-0.21875000f,-0.34375000f,-0.87500000f,-0.14062500f,-0.76562500f,0.95312500f,0.25000000f,-0.67187500f,0.17187500f,0.17187500f,-0.43750000f,0.68750000f,0.35937500f,0.75000000f,0.10937500f,-0.07812500f,0.95312500f,0.45312500f,0.87500000f,0.71875000f,-0.03125000f,-0.43750000f,0.01562500f,-0.89062500f,-0.14062500f,0.59375000f,0.53125000f,0.46875000f,0.20312500f,0.01562500f,0.92187500f,0.96875000f,0.98437500f,0.89062500f,0.62500000f,0.42187500f,0.78125000f,0.79687500f,-0.37500000f,0.50000000f,-0.37500000f,-0.14062500f,0.25000000f,0.82812500f,-0.34375000f,0.85937500f,0.65625000f,-0.25000000f,0.09375000f,0.54687500f,-0.75000000f,-0.92187500f,0.12500000f,-0.82812500f,-0.39062500f,0.92187500f,0.07812500f,0.42187500f,0.82812500f,-0.09375000f,0.01562500f,-0.76562500f,0.09375000f,-0.65625000f,0.42187500f,-0.18750000f,0.59375000f,-0.75000000f,-1.00000000f,-0.09375000f,-0.71875000f,-0.96875000f,-0.01562500f,0.71875000f,-1.00000000f,0.03125000f,-0.01562500f,-0.45312500f,0.68750000f,0.95312500f,-0.90625000f,0.82812500f,0.26562500f,-0.15625000f,0.35937500f,-0.70312500f,0.01562500f,1.00000000f,0.90625000f,0.87500000f,0.39062500f,0.67187500f,-0.96875000f,0.56250000f,-0.53125000f,0.06250000f,0.85937500f,0.48437500f,-0.39062500f,-0.25000000f,0.81250000f,-0.31250000f,0.62500000f,-0.48437500f,0.50000000f,0.10937500f,0.15625000f,0.82812500f,0.95312500f,0.40625000f,0.96875000f,-0.17187500f,-0.79687500f,0.95312500f,-0.07812500f,0.26562500f,-0.39062500f,0.78125000f,0.57812500f,-0.53125000f,-0.15625000f,-0.57812500f,-0.45312500f,-0.59375000f,-0.14062500f,-0.65625000f,0.57812500f,-0.68750000f,-0.07812500f,0.37500000f,-0.85937500f,0.54687500f,-0.20312500f,-0.95312500f,-0.14062500f,0.81250000f,-0.12500000f,0.20312500f,0.81250000f,0.65625000f,-1.00000000f,0.85937500f,-0.32812500f,0.35937500f,-0.56250000f,0.82812500f,0.65625000f,-0.84375000f,-0.17187500f,-0.03125000f,-0.18750000f,0.56250000f,-0.32812500f,-0.85937500f,0.26562500f,-0.01562500f,0.90625000f,0.48437500f,0.21875000f,0.85937500f,-0.60937500f,-0.28125000f,0.70312500f,0.68750000f,-0.65625000f,0.70312500f,-0.26562500f,-0.48437500f,0.62500000f,0.85937500f,-0.56250000f,-0.59375000f,-0.46875000f,0.92187500f,0.29687500f,-0.53125000f,-0.48437500f,0.45312500f,0.25000000f,-0.87500000f,-0.15625000f,-0.48437500f,-0.04687500f,-0.78125000f,0.29687500f,-0.84375000f,-0.17187500f,-0.78125000f,0.50000000f,0.46875000f,-0.32812500f,-0.35937500f,0.48437500f,-0.12500000f,-0.76562500f,0.67187500f,0.85937500f,0.18750000f,0.42187500f,1.00000000f,0.75000000f,0.53125000f,0.98437500f,-0.73437500f,0.17187500f,-0.45312500f,-0.65625000f,-0.03125000f,0.00000000f,0.96875000f,0.92187500f,0.29687500f,-0.96875000f,-0.95312500f,0.23437500f,0.73437500f,-0.54687500f,0.78125000f,-0.85937500f,-0.53125000f,-0.64062500f,0.00000000f,0.73437500f,-0.03125000f,0.85937500f,0.10937500f,-0.26562500f,-0.70312500f,0.04687500f,-0.03125000f,0.76562500f,-0.04687500f,-0.81250000f,-0.71875000f,0.10937500f,-0.84375000f,0.39062500f,0.21875000f,0.43750000f,-0.40625000f,1.00000000f,0.92187500f,-0.21875000f,-0.85937500f,-0.32812500f,0.34375000f,0.84375000f,-0.45312500f,-0.31250000f,-0.56250000f,-0.90625000f,0.87500000f,-0.43750000f,0.48437500f,0.62500000f,-0.06250000f,-0.57812500f,0.28125000f,-0.45312500f,0.54687500f,0.01562500f,-0.20312500f,-0.92187500f,0.76562500f,0.89062500f,-0.90625000f,0.87500000f,-0.96875000f,-0.15625000f,0.90625000f,0.43750000f,-0.07812500f,-0.70312500f,-0.35937500f,-0.53125000f,0.14062500f,0.92187500f,-0.18750000f,-0.15625000f,0.73437500f,-0.59375000f,-0.75000000f,0.76562500f,-0.01562500f,0.96875000f,0.53125000f,0.64062500f,0.82812500f,0.57812500f,-0.34375000f,-0.65625000f,0.39062500f,0.96875000f,-0.54687500f,-0.09375000f,0.76562500f,-0.84375000f,0.51562500f,0.28125000f,-0.57812500f,0.54687500f,0.32812500f,-0.65625000f,0.10937500f,0.14062500f,0.32812500f,0.53125000f,0.84375000f,0.04687500f,-0.23437500f,-0.76562500f,-0.48437500f,0.53125000f,-0.95312500f,-0.34375000f,0.70312500f,0.67187500f,-0.31250000f,-0.23437500f,0.39062500f,-0.50000000f,0.73437500f,0.09375000f,-0.57812500f,0.76562500f,0.96875000f,-0.60937500f,0.42187500f,0.25000000f,0.60937500f,0.64062500f,0.51562500f,-0.85937500f,-0.98437500f,0.75000000f,-0.45312500f,-0.93750000f,-0.62500000f,0.95312500f,-0.59375000f,0.51562500f,-0.14062500f,-0.68750000f,0.79687500f,0.28125000f,-0.01562500f,-0.28125000f,-0.78125000f,0.15625000f,-0.85937500f,0.76562500f,0.07812500f,-0.50000000f,-0.60937500f,-0.81250000f,0.56250000f,0.12500000f,-0.14062500f,-0.78125000f,0.35937500f,-0.32812500f,-0.84375000f,-0.37500000f,0.98437500f,-0.23437500f,0.06250000f,-0.82812500f,0.46875000f,0.46875000f,-0.60937500f,0.54687500f,-0.93750000f,-0.25000000f,0.93750000f,0.32812500f,0.92187500f,0.12500000f,0.39062500f,0.00000000f,-0.09375000f,-0.68750000f,-0.28125000f,0.95312500f,-0.06250000f,-0.68750000f,0.62500000f,-0.06250000f,-0.31250000f,-0.56250000f,-0.12500000f,0.56250000f,0.03125000f,-0.20312500f,-0.31250000f,0.37500000f,-0.04687500f,0.53125000f,0.82812500f,0.43750000f,0.53125000f,-0.12500000f,-0.29687500f,-0.37500000f,-0.26562500f,-0.10937500f,-0.39062500f,-0.18750000f,0.65625000f,-0.12500000f,0.37500000f,0.78125000f,-0.45312500f,-0.48437500f,-0.10937500f,0.06250000f,0.73437500f,0.89062500f,0.42187500f,0.40625000f,0.81250000f,-0.90625000f,-0.70312500f,0.20312500f,-0.70312500f,0.21875000f,-0.46875000f,0.85937500f,-0.90625000f,0.45312500f,-0.09375000f,0.87500000f,0.78125000f,-0.25000000f,0.21875000f,-0.15625000f,-0.01562500f,-0.67187500f,-0.04687500f,0.34375000f,-0.51562500f,0.95312500f,-0.64062500f,-0.26562500f,-0.51562500f,-0.92187500f,0.70312500f,-0.68750000f,-0.64062500f,-0.20312500f,-0.64062500f,-0.14062500f,0.42187500f,-0.23437500f,0.40625000f,-0.51562500f,0.40625000f,-0.45312500f,-0.53125000f,-0.35937500f,0.82812500f,-0.57812500f,0.56250000f,-0.07812500f,0.54687500f,0.15625000f,0.76562500f,-0.98437500f,-0.87500000f,0.87500000f,-0.89062500f,0.90625000f,0.56250000f,-0.35937500f,0.75000000f,0.95312500f,-0.95312500f,-0.32812500f,-0.48437500f,0.64062500f,0.23437500f,0.14062500f,-0.21875000f,-0.04687500f,-0.81250000f,0.21875000f,0.45312500f,-0.06250000f,-0.34375000f,-0.79687500f,0.67187500f,0.84375000f,0.40625000f,0.87500000f,0.68750000f,0.68750000f,0.07812500f,0.67187500f,-0.18750000f,-0.82812500f,-0.85937500f,-0.34375000f,0.81250000f,0.71875000f,-0.57812500f,-0.70312500f,0.68750000f,-0.03125000f,0.54687500f,-0.17187500f,0.15625000f,0.01562500f,-0.45312500f,-0.29687500f,-0.64062500f,0.06250000f,0.21875000f,0.45312500f,0.39062500f,0.51562500f,-0.67187500f,-0.42187500f,-0.82812500f,-0.89062500f,-0.51562500f,0.75000000f,0.82812500f,0.15625000f,-0.25000000f,-0.92187500f,0.25000000f,0.56250000f,-0.85937500f,0.18750000f,-0.06250000f,-1.00000000f,-0.82812500f,-0.89062500f,0.76562500f,-0.42187500f,-0.06250000f,-0.81250000f,0.34375000f,0.04687500f,0.50000000f,-0.15625000f,0.79687500f,0.10937500f,0.53125000f,0.78125000f,0.81250000f,0.20312500f,-1.00000000f,-0.53125000f,0.37500000f,0.34375000f,0.10937500f,0.79687500f,0.71875000f,0.35937500f,0.81250000f,-0.96875000f,-0.07812500f,-0.68750000f,-0.98437500f,0.43750000f,0.59375000f,0.25000000f,0.25000000f,-0.18750000f,-0.75000000f,-0.12500000f,0.28125000f,0.25000000f,-0.21875000f,0.15625000f,0.01562500f,-0.92187500f,-0.18750000f,-0.32812500f,-0.42187500f,0.48437500f,-0.40625000f,-0.29687500f,-0.75000000f,1.00000000f,0.20312500f,-0.25000000f,-0.32812500f,0.75000000f,0.03125000f,0.87500000f,-0.07812500f,0.23437500f,-0.37500000f,-0.34375000f,0.48437500f,0.29687500f,-0.14062500f,0.06250000f,0.84375000f,-0.12500000f,0.93750000f,0.06250000f,-0.96875000f,-0.42187500f,-1.00000000f,-1.00000000f,0.09375000f,0.93750000f,-0.76562500f,-0.48437500f,-0.15625000f,0.67187500f,0.28125000f,0.53125000f,0.59375000f,-0.73437500f,-0.68750000f,0.50000000f,-0.32812500f,-0.06250000f,0.70312500f,-0.45312500f,-0.60937500f,-0.56250000f,-0.18750000f,-0.78125000f,-0.06250000f,-0.73437500f,-0.25000000f,0.15625000f,0.37500000f,-0.10937500f,-0.57812500f,-0.57812500f,-0.71875000f,0.32812500f,-0.98437500f,-0.70312500f,-0.76562500f,-0.18750000f,-0.96875000f,0.28125000f,-0.35937500f,0.25000000f,-0.96875000f,0.71875000f,-0.70312500f,-0.06250000f,0.70312500f,0.37500000f,-0.03125000f,0.29687500f,0.26562500f,-0.68750000f,-0.76562500f,-0.90625000f,0.14062500f,0.06250000f,-0.84375000f,0.37500000f,0.37500000f,-0.98437500f,0.01562500f,0.50000000f,-0.62500000f,-0.62500000f,0.37500000f,-0.79687500f,0.79687500f,0.70312500f,-0.09375000f,0.50000000f,-0.23437500f,0.12500000f,-0.93750000f,-0.31250000f,0.79687500f,-0.48437500f,0.59375000f,0.54687500f,0.95312500f,0.51562500f,0.57812500f,0.92187500f,0.15625000f,-0.79687500f,-0.81250000f,0.46875000f,-0.70312500f,-0.56250000f,-0.84375000f,-0.92187500f,-0.12500000f,0.00000000f,-0.78125000f,0.34375000f,-0.82812500f,-0.26562500f,0.93750000f,-0.95312500f,-0.42187500f,0.95312500f,0.35937500f,-0.87500000f,0.29687500f,0.51562500f,0.25000000f,0.14062500f,-0.71875000f,-0.62500000f,-0.35937500f,0.29687500f,-0.56250000f,-0.34375000f,0.81250000f,-0.90625000f,-0.75000000f,0.53125000f,-0.10937500f,0.92187500f,0.57812500f,0.29687500f,0.39062500f,0.18750000f,-0.84375000f,0.65625000f,0.93750000f,-0.71875000f,-0.43750000f,-0.42187500f,0.25000000f,0.15625000f,-0.96875000f,-0.93750000f,-0.12500000f,-0.40625000f,0.53125000f,0.26562500f,-0.21875000f,0.51562500f,0.37500000f,-0.57812500f,0.26562500f,-0.17187500f,0.35937500f,0.79687500f,-0.75000000f,-0.07812500f,0.21875000f,-0.98437500f,-0.03125000f,-0.26562500f,0.31250000f,-0.03125000f,-0.40625000f,-0.76562500f,-0.37500000f,0.81250000f,-0.17187500f,0.29687500f,0.62500000f,0.40625000f,0.20312500f,0.40625000f,-0.79687500f,-0.53125000f,-0.71875000f,-0.70312500f,-0.23437500f,0.95312500f,0.84375000f,0.29687500f,0.40625000f,0.96875000f,0.93750000f,-0.03125000f,0.01562500f,0.60937500f,-0.28125000f,-0.85937500f,0.29687500f,0.68750000f,0.73437500f,0.56250000f,-0.67187500f,0.50000000f,-0.04687500f,0.09375000f,-0.48437500f,-0.43750000f,0.17187500f,0.57812500f,0.25000000f,-0.15625000f,0.32812500f,-0.84375000f,-0.28125000f,0.81250000f,0.65625000f,-0.65625000f,-0.70312500f,0.67187500f,-0.48437500f,0.65625000f,1.00000000f,-0.15625000f,-0.23437500f,0.23437500f,0.25000000f,-0.53125000f,0.48437500f,-0.73437500f,0.17187500f,0.28125000f,0.29687500f,0.12500000f,0.09375000f,0.31250000f,0.31250000f,-0.18750000f,-0.25000000f,-0.42187500f,-0.45312500f,-0.40625000f,0.82812500f,-0.90625000f,0.73437500f,0.56250000f,-0.09375000f,0.34375000f,-0.26562500f,0.29687500f,0.50000000f,0.46875000f,0.23437500f,0.43750000f,0.37500000f,-0.26562500f,0.60937500f,0.53125000f,0.53125000f,0.25000000f,-0.45312500f,0.51562500f,-0.64062500f,0.79687500f,-0.12500000f,0.93750000f,-0.45312500f,0.92187500f,0.64062500f,0.37500000f,0.06250000f,0.23437500f,-0.45312500f,0.50000000f,-0.09375000f,-0.79687500f,-0.95312500f,0.51562500f,-0.84375000f,-0.14062500f,0.93750000f,-0.82812500f,-0.62500000f,0.87500000f,0.03125000f,-0.53125000f,-0.09375000f,-0.96875000f,-0.28125000f,0.90625000f,0.56250000f,-0.35937500f,-0.37500000f,-0.29687500f,0.25000000f,0.71875000f,-0.75000000f,0.14062500f,-0.34375000f,0.12500000f,-0.01562500f,0.73437500f,-0.51562500f,-0.10937500f,-0.14062500f,0.82812500f,-0.89062500f,0.15625000f,-0.90625000f,-0.31250000f,-0.20312500f,-0.28125000f,-0.98437500f,-0.71875000f,-0.51562500f,-0.07812500f,-0.32812500f,0.76562500f,-0.37500000f,0.79687500f,-0.35937500f,0.39062500f,0.70312500f,-0.14062500f,0.65625000f,0.18750000f,0.04687500f,-0.54687500f,0.82812500f,-0.35937500f,0.43750000f,0.59375000f,-0.98437500f,0.60937500f,-0.60937500f,0.51562500f,-0.06250000f,-0.68750000f,0.50000000f,-0.04687500f,0.62500000f,0.45312500f,0.43750000f,0.70312500f,0.75000000f,-0.06250000f,-0.89062500f,0.85937500f,0.84375000f,-0.07812500f,0.67187500f,0.59375000f,0.59375000f,-1.00000000f,0.46875000f,0.65625000f,0.07812500f,0.43750000f,0.09375000f,0.82812500f,1.00000000f,0.12500000f,0.65625000f,-0.42187500f,-0.31250000f,-0.59375000f,0.51562500f,0.53125000f,0.23437500f,0.85937500f,-0.34375000f,-0.12500000f,-0.28125000f,0.78125000f,0.57812500f,1.00000000f,-0.53125000f,-0.56250000f,-0.64062500f,0.46875000f,-1.00000000f,-1.00000000f,0.87500000f,-0.56250000f,-0.84375000f,0.18750000f,0.18750000f,0.84375000f,0.15625000f,0.67187500f,0.29687500f,0.34375000f,0.73437500f,-0.90625000f,0.75000000f,0.95312500f,-0.39062500f,-0.75000000f,-0.43750000f,0.75000000f,0.42187500f,-0.53125000f,0.59375000f,-0.75000000f,-0.96875000f,0.85937500f,0.09375000f,0.82812500f,-0.45312500f,0.23437500f,-0.71875000f,0.29687500f,0.96875000f,-0.23437500f,0.12500000f,0.98437500f,-0.54687500f,-0.59375000f,-0.76562500f,-0.34375000f,-0.45312500f,0.67187500f,0.35937500f,0.82812500f,-0.17187500f,-0.71875000f,-1.00000000f,-0.65625000f,0.93750000f,0.82812500f,0.92187500f,-0.32812500f,0.62500000f,0.21875000f,-0.70312500f,0.45312500f,-0.28125000f,-0.31250000f,0.98437500f,-0.40625000f,-0.09375000f,-0.53125000f,0.62500000f,0.50000000f,0.32812500f,0.09375000f,-0.20312500f,0.29687500f,-0.43750000f,-0.70312500f,-0.92187500f,-0.60937500f,0.23437500f,0.57812500f,-0.92187500f,-0.64062500f,0.04687500f,0.92187500f,0.46875000f,0.12500000f,-0.37500000f,-0.04687500f,0.01562500f,0.93750000f,0.06250000f,-0.09375000f,-0.67187500f,1.00000000f,0.31250000f,0.43750000f,0.00000000f,-0.51562500f,0.60937500f,0.71875000f,0.26562500f,0.62500000f,0.81250000f,0.82812500f,0.95312500f,0.37500000f,0.39062500f,-0.67187500f,0.43750000f,-0.07812500f,0.48437500f,-0.34375000f,-0.15625000f,0.60937500f,0.67187500f,-0.68750000f,-0.10937500f,-0.46875000f,-0.31250000f,0.23437500f,-0.85937500f,-0.57812500f,0.56250000f,0.82812500f,-0.40625000f,0.71875000f,0.21875000f,-0.01562500f,-0.01562500f,0.04687500f,-0.57812500f,0.81250000f,0.37500000f,-0.45312500f,0.00000000f,-0.34375000f,-0.64062500f,0.10937500f,-0.90625000f,0.71875000f,-0.03125000f,-0.75000000f,-0.90625000f,-0.70312500f,0.70312500f,-0.40625000f,0.29687500f,-0.54687500f,0.65625000f,-0.42187500f,0.96875000f,0.78125000f,-0.89062500f,-0.92187500f,0.85937500f,0.59375000f,0.78125000f,-0.20312500f,-0.68750000f,-0.75000000f,0.06250000f,-0.57812500f,-0.98437500f,0.50000000f,0.35937500f,-0.43750000f,-0.92187500f,0.82812500f,0.35937500f,-0.59375000f,-0.46875000f,-0.51562500f,-0.42187500f,0.39062500f,-0.35937500f,-0.39062500f,0.23437500f,0.57812500f,-0.29687500f,-0.81250000f,-0.82812500f,-0.79687500f,-0.20312500f,-0.76562500f,0.79687500f,0.62500000f,-0.60937500f,0.96875000f,-0.43750000f,0.70312500f,-0.65625000f,-0.65625000f,-0.09375000f,-0.65625000f,0.00000000f,0.40625000f,-0.84375000f,-0.92187500f,0.04687500f,0.89062500f,-0.17187500f,-0.81250000f,-0.10937500f,0.14062500f,-0.85937500f,-1.00000000f,0.70312500f,-0.25000000f,-0.70312500f,-0.31250000f,0.82812500f,0.82812500f,0.71875000f,0.43750000f,-0.48437500f,0.34375000f,-0.25000000f,-0.28125000f,0.53125000f,-0.12500000f,0.56250000f,0.82812500f,0.01562500f,-0.60937500f,0.57812500f,0.93750000f,-0.73437500f,0.31250000f,0.79687500f,-0.54687500f,0.14062500f,0.42187500f,0.34375000f,0.31250000f,-0.39062500f,-0.10937500f,0.85937500f,-0.56250000f,-0.84375000f,-0.40625000f,-0.26562500f,0.28125000f,-0.93750000f,-0.09375000f,0.62500000f,-0.29687500f,-0.25000000f,-0.18750000f,0.28125000f,-0.51562500f,-0.43750000f,0.39062500f,-0.18750000f,-0.82812500f,0.15625000f,-0.82812500f,0.89062500f,-0.29687500f,-0.75000000f,-0.45312500f,0.59375000f,-0.78125000f,0.14062500f,-0.53125000f,0.07812500f,-0.98437500f,0.60937500f,0.21875000f,-0.68750000f,-0.35937500f,-0.20312500f,0.48437500f,-0.56250000f,0.76562500f,0.48437500f,-0.78125000f,0.03125000f,0.65625000f,-0.96875000f,0.54687500f,0.60937500f,0.78125000f,0.42187500f,-0.56250000f,-0.34375000f,0.64062500f,-1.00000000f,0.17187500f,0.71875000f,-0.68750000f,-0.96875000f,0.45312500f,-0.60937500f,0.31250000f,0.92187500f,0.98437500f,0.25000000f,-0.37500000f,0.21875000f,0.73437500f,-0.04687500f,-0.18750000f,-0.35937500f,-0.59375000f,0.98437500f,-0.29687500f,0.45312500f,-0.26562500f,0.45312500f,0.70312500f,-0.75000000f,0.37500000f,-0.03125000f,-0.03125000f,-0.64062500f,-0.71875000f,0.15625000f,-0.84375000f,-0.62500000f,-0.81250000f,0.70312500f,0.31250000f,0.04687500f,0.67187500f,0.09375000f,0.53125000f,0.87500000f,-0.54687500f,0.87500000f,0.81250000f,0.84375000f,-0.50000000f,0.65625000f,-0.26562500f,0.37500000f,0.42187500f,-0.53125000f,0.60937500f,0.64062500f,0.85937500f,0.18750000f,0.87500000f,-0.76562500f,-0.67187500f,0.51562500f,0.75000000f,-0.78125000f,0.04687500f,-0.50000000f,0.56250000f,0.42187500f,0.48437500f,-0.81250000f,-0.45312500f,-0.51562500f,-0.35937500f,-0.70312500f,0.04687500f,0.73437500f,0.71875000f,-0.54687500f,-0.98437500f,-0.25000000f,0.35937500f,0.00000000f,0.43750000f,0.00000000f,-0.01562500f,-0.12500000f,0.73437500f,-0.93750000f,0.71875000f,0.59375000f,-1.00000000f,-0.75000000f,0.26562500f,0.28125000f,-0.87500000f,0.18750000f,0.75000000f,0.40625000f,-0.67187500f,-0.31250000f,-0.46875000f,-0.59375000f,-0.42187500f,-0.35937500f,0.84375000f,-0.28125000f,0.34375000f,-0.45312500f,0.48437500f,-0.57812500f,-0.79687500f,-0.82812500f,0.92187500f,-0.56250000f,0.25000000f,-0.48437500f,0.96875000f,0.50000000f,0.56250000f,-0.57812500f,-0.78125000f,0.65625000f,-0.75000000f,-0.51562500f,0.79687500f,-0.60937500f,0.10937500f,-0.32812500f,0.10937500f,-0.71875000f,0.21875000f,0.67187500f,-0.50000000f,-0.28125000f,0.90625000f,0.57812500f,-0.81250000f,-0.68750000f,-0.75000000f,-0.29687500f,0.18750000f,-0.81250000f,-0.45312500f,-0.87500000f,0.85937500f,0.73437500f,-0.42187500f,-0.92187500f,0.50000000f,-0.59375000f,0.07812500f,-0.29687500f,0.65625000f,-0.23437500f,0.98437500f,-0.26562500f,0.62500000f,-0.43750000f,-0.85937500f,0.70312500f,0.07812500f,-0.31250000f,0.51562500f,-0.23437500f,0.82812500f,-0.65625000f,0.46875000f,0.67187500f,0.31250000f,-0.29687500f,-0.17187500f,-0.79687500f,-0.70312500f,0.65625000f,0.68750000f,0.96875000f,0.04687500f,-0.03125000f,0.79687500f,0.82812500f,0.98437500f,-0.67187500f,-0.54687500f,-0.51562500f,-0.67187500f,-0.78125000f,-0.93750000f,0.46875000f,0.46875000f,-0.29687500f,-0.96875000f,-0.84375000f,-0.98437500f,-0.57812500f,-0.85937500f,-0.68750000f,-0.84375000f,0.43750000f,0.46875000f,-0.50000000f,-0.98437500f,0.34375000f,-0.01562500f,-0.93750000f,-0.51562500f,-0.17187500f,0.10937500f,0.32812500f,-0.96875000f,-0.07812500f,0.56250000f,0.87500000f,-0.01562500f,-0.25000000f,-0.59375000f,-0.20312500f,0.23437500f,0.09375000f,0.75000000f,-0.68750000f,-0.42187500f,-1.00000000f,0.79687500f,0.25000000f,0.31250000f,0.01562500f,-0.93750000f,0.40625000f,-0.20312500f,-0.93750000f,-0.75000000f,-0.82812500f,-0.75000000f,-0.21875000f,0.17187500f,-0.85937500f,-0.64062500f,-0.09375000f,0.35937500f,0.06250000f,-0.84375000f,0.01562500f,0.21875000f,0.81250000f,-0.60937500f,-0.67187500f,-0.93750000f,0.71875000f,0.07812500f,0.01562500f,0.53125000f,0.18750000f,-0.98437500f,-0.07812500f,0.17187500f,0.90625000f,-0.21875000f,-0.15625000f,-0.70312500f,-0.89062500f,-0.67187500f,0.85937500f,-0.82812500f,0.29687500f,0.73437500f,-0.51562500f,0.87500000f,0.53125000f,0.68750000f,0.60937500f,-0.96875000f,-0.50000000f,0.56250000f,-0.82812500f,0.31250000f,-0.48437500f,0.93750000f,0.12500000f,0.03125000f,0.28125000f,-0.60937500f,-0.20312500f,0.26562500f,-0.50000000f,0.06250000f,0.40625000f,-0.53125000f,0.29687500f,0.92187500f,0.60937500f,-0.75000000f,-0.64062500f,-0.26562500f,0.45312500f,0.03125000f,-0.29687500f,0.34375000f,-0.07812500f,-0.68750000f,0.60937500f,-0.73437500f,-0.45312500f,0.89062500f,-0.39062500f,-0.70312500f,-0.90625000f,-0.92187500f,-0.87500000f,0.39062500f,0.73437500f,0.01562500f,-0.07812500f,-0.51562500f,0.79687500f,0.32812500f,0.20312500f,-0.95312500f,-0.26562500f,-0.31250000f,1.00000000f,-0.93750000f,-0.32812500f,-0.26562500f,0.51562500f,0.76562500f,-0.65625000f,0.51562500f,0.06250000f,-0.54687500f,-0.12500000f,0.57812500f,0.82812500f,-0.67187500f,0.39062500f,0.32812500f,0.28125000f,0.96875000f,0.45312500f,0.59375000f,-0.35937500f,-0.37500000f,0.12500000f,0.76562500f,0.43750000f,0.89062500f,-0.25000000f,0.84375000f,-0.89062500f,-0.03125000f,0.57812500f,-0.67187500f,-0.21875000f,0.23437500f,-0.25000000f,0.39062500f,-0.79687500f,-0.17187500f,-0.92187500f,-0.65625000f,0.73437500f,-0.70312500f,-0.65625000f,-0.25000000f,-0.70312500f,0.64062500f,0.31250000f,0.87500000f,-0.93750000f,0.21875000f,0.57812500f,0.39062500f,0.93750000f,0.40625000f,0.87500000f,-0.18750000f,-0.23437500f,0.96875000f,-0.79687500f,0.39062500f,-0.85937500f,-0.79687500f,-0.40625000f,-0.92187500f,-0.12500000f,0.76562500f,0.09375000f,-0.40625000f,-0.84375000f,-0.95312500f,-0.71875000f,-0.17187500f,-0.62500000f,-0.78125000f,0.10937500f,-0.45312500f,-0.65625000f,-0.59375000f,0.98437500f,0.73437500f,0.85937500f,-0.87500000f,-0.67187500f,-0.98437500f,-0.17187500f,0.95312500f,-0.81250000f,0.84375000f,-0.90625000f,0.92187500f,-0.85937500f,-0.82812500f,0.54687500f,0.21875000f,0.09375000f,-0.15625000f,0.45312500f,0.28125000f,-0.96875000f,0.45312500f,0.62500000f,0.56250000f,-0.31250000f,-0.31250000f,0.57812500f,0.14062500f,0.34375000f,0.09375000f,-0.21875000f,0.57812500f,-0.82812500f,0.96875000f,-0.75000000f,0.60937500f,-0.92187500f,-0.07812500f,0.89062500f,0.43750000f,0.23437500f,0.15625000f,0.12500000f,-0.78125000f,-0.46875000f,0.03125000f,0.62500000f,0.53125000f,-0.85937500f,-0.78125000f,0.60937500f,0.15625000f,0.68750000f,0.87500000f,0.93750000f,0.53125000f,-0.93750000f,-0.48437500f,-0.23437500f,-0.45312500f,0.39062500f,0.10937500f,-0.14062500f,0.93750000f,0.64062500f,0.95312500f,0.96875000f,0.73437500f,-0.12500000f,0.75000000f,-0.64062500f,0.04687500f,-0.51562500f,-0.39062500f,-0.10937500f,0.62500000f,0.85937500f,0.46875000f,0.04687500f,0.42187500f,-0.96875000f,0.71875000f,-0.85937500f,-0.45312500f,0.46875000f,0.07812500f,-0.56250000f,-0.64062500f,-0.68750000f,0.04687500f,0.25000000f,-0.64062500f,-0.23437500f,0.03125000f,-0.45312500f,0.12500000f,0.93750000f,-0.35937500f,0.23437500f,0.96875000f,0.48437500f,0.56250000f,0.09375000f,-0.57812500f,-0.42187500f,0.53125000f,-0.25000000f,-0.87500000f,-0.54687500f,0.64062500f,0.00000000f,0.03125000f,0.10937500f,-0.67187500f,-0.32812500f,-0.10937500f,-0.59375000f,0.87500000f,-0.43750000f,0.96875000f,0.48437500f,0.59375000f,-0.18750000f,-0.85937500f,0.89062500f,-0.20312500f,0.07812500f,-0.98437500f,0.01562500f,0.18750000f,0.39062500f,0.96875000f,0.15625000f,-0.82812500f,0.93750000f,0.17187500f,0.39062500f,-0.40625000f,0.89062500f,-0.59375000f,0.40625000f,0.78125000f,-0.10937500f,0.79687500f,0.56250000f,-0.28125000f,-0.48437500f,-0.82812500f,-0.70312500f,0.34375000f,0.57812500f,0.00000000f,0.28125000f,0.70312500f,0.39062500f,-0.29687500f,-0.25000000f,-0.90625000f,-0.32812500f,-0.85937500f,0.37500000f,0.93750000f,-0.20312500f,-0.48437500f,0.92187500f,0.79687500f,-0.29687500f,0.06250000f,-0.31250000f,0.34375000f,0.67187500f,0.57812500f,0.25000000f,-0.56250000f,0.92187500f,-0.26562500f,-0.71875000f,0.68750000f,0.65625000f,0.46875000f,0.09375000f,0.39062500f,-0.39062500f,0.75000000f,0.70312500f,-0.89062500f,-0.56250000f,0.40625000f,0.95312500f,0.10937500f,-0.26562500f,-0.73437500f,0.20312500f,0.06250000f,-0.68750000f,-0.60937500f,-0.71875000f,0.40625000f,0.75000000f,-0.46875000f,0.57812500f,-0.29687500f,0.37500000f,0.51562500f,-0.73437500f,0.90625000f,0.75000000f,-0.64062500f,0.71875000f,0.62500000f,0.70312500f,0.32812500f,0.81250000f,0.57812500f,0.71875000f,-0.67187500f,-0.56250000f,-0.07812500f,-1.00000000f,-0.48437500f,0.32812500f,0.98437500f,0.98437500f,-0.98437500f,-0.56250000f,0.68750000f,-0.95312500f,-0.37500000f,0.82812500f,0.67187500f,0.28125000f,0.51562500f,0.46875000f,-0.56250000f,-0.32812500f,-0.56250000f,-0.31250000f,-0.29687500f,0.18750000f,-0.17187500f,1.00000000f,0.96875000f,0.50000000f,-0.68750000f,0.75000000f,-0.39062500f,-0.28125000f,-0.90625000f,0.40625000f,0.96875000f,-0.03125000f,0.32812500f,0.67187500f,-0.60937500f,-0.25000000f,-0.57812500f,0.06250000f,0.56250000f,0.76562500f,-0.65625000f,-0.45312500f,0.54687500f,-0.92187500f,-0.39062500f,0.15625000f,0.71875000f,-0.29687500f,0.67187500f,-0.03125000f,0.40625000f,-0.79687500f,-0.90625000f,0.59375000f,0.39062500f,-0.25000000f,-0.04687500f,-0.07812500f,-0.06250000f,0.04687500f,0.59375000f,0.98437500f,0.59375000f,0.48437500f,-0.43750000f,0.03125000f,0.25000000f,0.96875000f,-0.07812500f,0.56250000f,-0.03125000f,0.20312500f,0.87500000f,-0.26562500f,-0.48437500f,-0.42187500f,0.39062500f,-0.10937500f,-0.81250000f,-0.31250000f,-0.18750000f,0.73437500f,-0.75000000f,-0.40625000f,0.56250000f,-0.90625000f,0.68750000f,0.31250000f,0.48437500f,0.23437500f,0.65625000f,-0.50000000f,0.76562500f,0.42187500f,0.37500000f,0.57812500f,0.60937500f,-0.46875000f,0.28125000f,0.85937500f,0.34375000f,0.65625000f,0.82812500f,-0.54687500f,-0.92187500f,-0.89062500f,-0.28125000f,-0.98437500f,-0.54687500f,-0.37500000f,-0.06250000f,0.48437500f,0.60937500f,-0.95312500f,0.32812500f,0.45312500f,0.50000000f,-0.42187500f,-0.98437500f,0.81250000f,-0.59375000f,0.73437500f,0.92187500f,-0.60937500f,-0.65625000f,0.46875000f,-1.00000000f,-0.68750000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{4.00073242f,-1.29516602f,-2.86596680f,-2.22265625f,0.43212891f,1.10888672f,-0.91430664f,3.49194336f,5.32177734f,1.80932617f,2.03686523f,-4.15185547f,0.08642578f,-0.73852539f,-2.61572266f,-2.20605469f,0.12841797f,3.64428711f,-1.86035156f,-1.13745117f,2.35351562f,-2.23144531f,-3.21557617f,-2.22485352f,-1.26513672f,2.95874023f,-0.01123047f,3.72607422f,1.75756836f,0.03466797f,1.84814453f,0.40502930f,1.75610352f,-0.14184570f,-5.03344727f,2.66870117f,-0.37939453f,-1.89111328f,-0.42016602f,-2.71337891f,-1.75708008f,0.22167969f,1.34472656f,-0.69287109f,0.49487305f,-3.21093750f,1.16406250f,-3.29223633f,0.80029297f,0.29614258f,3.55346680f,-0.85156250f,1.39331055f,1.78540039f,2.01660156f,-0.63793945f,-3.53466797f,0.80981445f,-0.63940430f,0.00659180f,-2.55200195f,2.36181641f,-0.72998047f,-2.94848633f,-3.34008789f,6.21020508f,-1.63208008f,0.98901367f,1.79687500f,-0.70141602f,1.76562500f,-3.16015625f,-1.54760742f,0.25976562f,3.01855469f,-1.19897461f,0.77661133f,-0.97143555f,1.36132812f,1.28247070f,-0.69580078f,-2.24194336f,-0.87231445f,0.72412109f,1.79833984f,1.29467773f,-7.14746094f,1.04370117f,0.49169922f,-3.76977539f,-2.20654297f,-0.62084961f,-0.35791016f,0.78002930f,-0.67846680f,-0.28344727f,-0.89794922f,-3.23657227f,-2.21337891f,2.05688477f,1.84082031f,-0.94848633f,-0.10961914f,-1.25512695f,3.18798828f,1.07885742f,-0.74096680f,-0.02832031f,0.63549805f,-2.26196289f,2.06738281f,6.25341797f,0.86254883f,4.09985352f,0.07714844f,5.81518555f,-1.45336914f,-0.21850586f,-1.57470703f,2.58959961f,-0.05541992f,1.69628906f,1.17749023f,-0.56005859f,-1.93969727f,-0.71557617f,-1.45458984f,-1.62817383f,0.56982422f,-1.97045898f,2.76904297f,0.20996094f,-2.68945312f,2.93872070f,-1.58886719f,0.54077148f,0.48657227f,2.61474609f,1.38916016f,-1.50561523f,-3.93725586f,-4.25341797f,-0.39355469f,0.28076172f,0.34179688f,-2.51977539f,-0.41430664f,4.12963867f,1.56591797f,0.64575195f,4.76171875f,0.61157227f,0.44726562f,-2.00439453f,1.54785156f,-2.16284180f,1.21606445f,1.37475586f,6.28369141f,0.29833984f,-2.82299805f,-1.43505859f,-0.92382812f,-1.54809570f,-0.32275391f,-2.93579102f,0.35278320f,-2.50048828f,0.02392578f,0.25439453f,0.32983398f,-2.16748047f,-3.49194336f,-5.41357422f,-1.45117188f,0.56591797f,5.61376953f,0.50366211f,0.33935547f,-1.95361328f,-0.50097656f,2.28637695f,-2.43652344f,-5.30004883f,3.58593750f,1.60961914f,0.02734375f,2.65869141f,0.82617188f,-3.39160156f,-1.57788086f,-1.42626953f,-1.86718750f,1.12280273f,-0.14990234f,2.13452148f,2.26440430f,3.14257812f,0.69287109f,1.31225586f,1.65869141f,2.25268555f,0.05639648f,1.15844727f,0.30981445f,0.58251953f,1.17749023f,4.28320312f,-0.57934570f,-2.14550781f,-1.72485352f,2.03857422f,0.53613281f,-1.66821289f,1.10595703f,-3.76293945f,-1.49243164f,1.86328125f,-4.06787109f,1.77075195f,-1.94702148f,1.22021484f,2.00341797f,-0.75683594f,0.39843750f,1.22802734f,-3.97802734f,-1.35449219f,-1.28808594f,1.41699219f,-0.50927734f,4.92187500f,-0.43896484f,-1.14501953f,0.02832031f,-1.71240234f,0.22167969f,0.83081055f,-1.91552734f,-0.16137695f,-0.04931641f,-1.78515625f,0.49707031f,-0.98413086f,-0.70092773f,2.45092773f,2.82543945f,-0.86767578f,1.20507812f,2.42309570f,-4.57495117f,-3.11352539f,-1.09545898f,0.06469727f,1.33203125f,1.02661133f,0.52246094f,3.43994141f,-1.95166016f,0.88256836f,-0.40478516f,2.15673828f,1.41503906f,-3.19213867f,-1.22094727f,-4.17285156f,1.30224609f,-1.35107422f,0.78027344f,-0.02197266f,1.18334961f,-2.16943359f,3.35229492f,1.18432617f,2.13134766f,-1.68066406f,1.45117188f,1.62353516f,0.67480469f,2.91528320f,-0.42504883f,0.41870117f,-0.23730469f,0.66723633f,2.86938477f,-3.14892578f,1.82543945f,-1.88745117f,0.18286133f,-1.85424805f,3.11547852f,-3.76831055f,0.07788086f,0.83349609f,-2.42993164f,0.62158203f,-0.02880859f,-2.81201172f,-1.88037109f,3.97900391f,-4.00878906f,0.73510742f,-0.55029297f,-1.04150391f,0.61425781f,-0.10864258f,1.06176758f,-2.28076172f,-0.17407227f,-1.70434570f,-0.18310547f,0.49291992f,0.01489258f,1.22045898f,2.64965820f,-3.22216797f,0.44335938f,1.17285156f,0.11840820f,0.67773438f,0.44970703f,1.62719727f,-3.81860352f,2.16040039f,-2.64794922f,0.62109375f,2.18359375f,-0.34423828f,-2.02368164f,-1.29296875f,1.14233398f,-0.24584961f,-0.67480469f,-3.52441406f,1.63940430f,1.34472656f,1.90039062f,2.20678711f,-1.76000977f,-2.55029297f,-1.03369141f,-3.01367188f,-1.44799805f,-1.87866211f,1.71728516f,-0.15527344f,-1.41723633f,0.75366211f,0.30053711f,-2.53564453f,-3.04785156f,-4.88549805f,-0.28222656f,-2.27294922f,-0.41967773f,-0.82739258f,-1.53100586f,-1.48950195f,1.96069336f,-0.79907227f,0.22583008f,3.16015625f,0.26391602f,-0.57983398f,0.46411133f,1.07421875f,-0.24682617f,-1.05053711f,1.32983398f,2.45410156f,-1.93164062f,-0.96044922f,-0.45996094f,0.71313477f,1.11621094f,-1.02514648f,2.64916992f,-0.33178711f,-1.98950195f,-2.89135742f,3.09985352f,-2.02612305f,1.37280273f,-2.51879883f,0.19287109f,-1.61767578f,0.96508789f,-0.76074219f,1.48950195f,-3.91113281f,0.40966797f,-1.72460938f,4.11596680f,-0.70898438f,-2.79150391f,0.65478516f,-0.62670898f,0.96289062f,-1.85327148f,-2.61572266f,3.21240234f,-2.24755859f,-1.56176758f,2.11328125f,2.46826172f,-3.43237305f,1.67993164f,0.89208984f,0.00415039f,-2.52197266f,-1.34350586f,0.44824219f,-3.23559570f,-0.07202148f,4.21826172f,-1.65747070f,-2.60888672f,3.89770508f,0.20776367f,4.74462891f,-3.58105469f,0.72607422f,-1.12817383f,-2.34887695f,-1.74755859f,-0.90673828f,-0.73266602f,-1.07324219f,-0.71093750f,4.44824219f,-1.22045898f,-1.55126953f,0.05932617f,2.18139648f,-3.56591797f,-2.17114258f,0.02929688f,-0.21728516f,-2.16625977f,0.47485352f,2.26147461f,1.14501953f,2.02099609f,2.55419922f,-0.39770508f,4.57617188f,0.07836914f,1.11523438f,1.55810547f,0.47045898f,-0.20581055f,-0.22192383f,-2.31665039f,-0.59741211f,-2.34692383f,3.10473633f,-1.29833984f,-1.53808594f,-0.29589844f,0.97485352f,0.98193359f,1.32592773f,-1.78491211f,-0.41943359f,0.88110352f,-1.12670898f,2.00488281f,-0.68286133f,-0.19458008f,0.18041992f,0.65112305f,2.68994141f,1.45703125f,1.48974609f,0.91064453f,0.85937500f,0.58740234f,1.48193359f,-1.49145508f,1.01831055f,0.42114258f,-1.17651367f,1.86474609f,-3.39331055f,-1.02880859f,-4.83959961f,0.49511719f,-1.06274414f,0.05688477f,1.71704102f,1.72460938f,2.05834961f,-4.74975586f,2.98754883f,1.10620117f,2.78491211f,0.21630859f,-0.27172852f,0.06738281f,-1.27490234f,-0.26660156f,2.66186523f,0.49487305f,-2.07788086f,1.19189453f,0.54418945f,2.20996094f,0.36010742f,2.47314453f,0.57397461f,3.32983398f,-2.67871094f,4.01586914f,-1.23291016f,-0.68334961f,2.49487305f,2.03295898f,-2.21118164f,1.27734375f,-2.10131836f,-1.12158203f,1.62036133f,-1.05444336f,-0.56347656f,-7.02612305f,5.36254883f,-0.89208984f,2.76293945f,-0.18359375f,1.06201172f,-0.08471680f,-4.52490234f,-0.60449219f,0.01538086f,-3.01611328f,-1.66699219f,-1.72900391f,0.53002930f,0.44799805f,4.60473633f,-1.68969727f,-1.15771484f,-1.29248047f,-1.38769531f,-4.23168945f,0.56787109f,1.05297852f,-0.16723633f,-1.69555664f,0.22094727f,-2.01025391f,-2.29174805f,-2.49096680f,2.27075195f,-0.56420898f,0.78100586f,-2.58569336f,-1.59521484f,-1.20458984f,1.07446289f,2.60351562f,2.61474609f,-3.57470703f,1.50463867f,-3.72070312f,-2.60546875f,1.66674805f,-0.23876953f,-2.68261719f,1.38720703f,-1.97949219f,-0.83593750f,-2.49047852f,3.34399414f,0.05517578f,2.72338867f,0.20361328f,-1.68994141f,1.45581055f,0.59594727f,0.80957031f,3.64941406f,-3.09716797f,-0.70898438f,-3.49633789f,-2.30981445f,4.73339844f,1.05590820f,0.60229492f,0.84326172f,-1.33813477f,-0.09399414f,1.44287109f,0.87475586f,2.91381836f,4.53784180f,-2.15454102f,-0.34033203f,0.90991211f,1.35693359f,3.13769531f,-1.71875000f,-2.62255859f,-0.13745117f,-1.39550781f,-2.31738281f,0.79321289f,1.55932617f,-1.06152344f,-0.22045898f,-0.64306641f,1.81884766f,-2.61401367f,-1.03466797f,1.72534180f,-2.77734375f,-2.72851562f,-0.72412109f,2.03393555f,-3.54516602f,2.08398438f,2.07666016f,-3.84179688f,-2.31884766f,0.40966797f,0.57348633f,0.73559570f,-0.74511719f,-1.95678711f,-0.50805664f,-2.10327148f,0.31567383f,-0.03784180f,-0.00708008f,-1.13989258f,1.16943359f,-0.05541992f,3.55908203f,1.63696289f,0.35131836f,1.43872070f,-1.06127930f,-4.22753906f,-0.49536133f,-1.99194336f,4.35009766f,0.78002930f,0.22558594f,0.84399414f,0.51196289f,-1.84008789f,-1.14379883f,-2.12036133f,-0.68310547f,0.27270508f,-4.66552734f,-1.40405273f,2.03027344f,1.03198242f,0.95996094f,-0.45776367f,-1.54687500f,-4.97167969f,-0.37060547f,-0.77563477f,0.79589844f,-4.83984375f,4.50415039f,2.57446289f,-1.51538086f,1.89111328f,1.62207031f,-0.49877930f,2.60717773f,0.08398438f,1.60913086f,1.07055664f,2.06127930f,1.42529297f,2.71411133f,-3.30639648f,3.66455078f,2.12841797f,0.19824219f,-1.10961914f,2.68945312f,-3.31958008f,-4.09521484f,-0.24121094f,-0.06665039f,1.67138672f,2.43090820f,1.52758789f,0.19262695f,0.87548828f,3.83325195f,-2.15893555f,-0.47241211f,-2.18237305f,0.86450195f,-3.42626953f,-2.25708008f,3.96899414f,-1.20068359f,0.76513672f,1.48461914f,-1.57934570f,1.32788086f,-2.08911133f,1.45190430f,-0.67700195f,0.35839844f,-1.23095703f,-4.45434570f,0.08911133f,-1.48608398f,1.28979492f,0.11694336f,-0.67919922f,0.10400391f,0.46166992f,-3.26782227f,0.20922852f,-1.59008789f,-1.30322266f,0.15527344f,0.97485352f,-2.44799805f,0.05468750f,-1.09643555f,3.96484375f,1.63745117f,-0.88330078f,-1.18627930f,-0.70361328f,-1.19433594f,-0.56030273f,0.81420898f,-1.02148438f,1.66137695f,1.41088867f,-1.73510742f,0.33862305f,4.37695312f,-0.40478516f,-2.06176758f,-0.64111328f,3.83569336f,-1.43603516f,0.29760742f,1.45654297f,1.44531250f,-0.34960938f,0.06958008f,-2.24145508f,-3.74218750f,-2.31298828f,1.05493164f,-0.72167969f,-0.48022461f,-1.19433594f,-0.17211914f,-2.47045898f,-0.70971680f,-1.71533203f,1.81665039f,-2.49365234f,-1.24096680f,-3.40380859f,1.27148438f,2.90502930f,0.10034180f,0.35839844f,2.81982422f,-0.41040039f,1.09057617f,1.58642578f,2.05126953f,3.33691406f,-2.30712891f,0.19482422f,-1.89233398f,2.48022461f,-2.44946289f,0.30053711f,4.97558594f,0.64233398f,-2.51855469f,1.23339844f,-3.21118164f,0.83251953f,1.85009766f,-1.74121094f,0.32495117f,0.84667969f,0.62133789f,1.42822266f,2.75463867f,4.20385742f,-0.76904297f,-2.11840820f,-0.95532227f,-0.37011719f,2.63183594f,1.19628906f,0.81127930f,-2.65771484f,0.01025391f,0.65820312f,-1.23657227f,-0.42065430f,-2.22729492f,-0.01098633f,-0.25268555f,1.27392578f,2.43090820f,2.89282227f,2.10351562f,-0.28417969f,2.50122070f,0.87548828f,0.84497070f,0.72583008f,0.63891602f,2.29516602f,-3.31909180f,0.63671875f,-1.26611328f,-0.41528320f,-1.74926758f,-0.49877930f,-1.39233398f,-1.29418945f,1.69311523f,-1.10424805f,-1.06713867f,0.86425781f,-1.55541992f,-1.54394531f,2.51074219f,1.48315430f,4.64575195f,-0.02661133f,-0.93164062f,-0.67309570f,2.00805664f,-0.14184570f,-0.98144531f,-1.32202148f,1.21557617f,-0.72216797f,-0.74780273f,0.14038086f,0.26562500f,-1.98291016f,2.69726562f,3.49023438f,-3.01928711f,3.29248047f,0.45532227f,1.82690430f,-0.37231445f,3.74243164f,-2.90625000f,2.97412109f,1.02270508f,3.26074219f,-1.50122070f,-1.56469727f,0.12792969f,-2.26562500f,2.17138672f,1.0f,1.21801758f,-0.47265625f,-1.20654297f,-0.31030273f,0.89746094f,0.95874023f,0.62231445f,2.63232422f,-0.30029297f,1.04638672f,-2.27539062f,0.52514648f,2.26123047f,0.55761719f,3.07470703f,-0.47778320f,0.67089844f,1.90380859f,-3.44970703f,-2.08081055f,-0.52490234f,-2.74047852f,2.13818359f,1.94458008f,5.67700195f,-0.32666016f,-1.31518555f,1.10473633f,-0.37280273f,0.73193359f,-2.77514648f,1.65283203f,-2.63671875f,0.65063477f,0.85546875f,-0.02929688f,0.67651367f,0.98852539f,-0.01245117f,1.29589844f,3.10107422f,-1.41601562f,-2.23095703f,1.24780273f,0.00463867f,0.74072266f,0.40600586f,-1.19897461f,0.21801758f,2.04101562f,1.38427734f,1.41650391f,-0.40161133f,2.79638672f,1.77880859f,-2.94482422f,2.47851562f,-2.88940430f,0.60351562f,-2.44848633f,-1.81787109f,0.02172852f,2.70800781f,-2.86035156f,2.39868164f,-1.04907227f,0.88549805f,1.00341797f,-0.73413086f,-1.87646484f,-0.60815430f,-0.43530273f,-2.07226562f,1.95849609f,2.61694336f,1.22363281f,3.48364258f,-0.28125000f,0.41235352f,-0.38574219f,-3.83569336f,-0.03198242f,3.21679688f,-1.25366211f,-0.44897461f,3.26293945f,2.24658203f,-0.08959961f,1.44165039f,2.57592773f,0.82690430f,-0.42260742f,1.29614258f,4.25292969f,-0.29418945f,1.16064453f,1.77685547f,-1.05981445f,-1.61938477f,0.70288086f,0.40405273f,0.44995117f,-2.97729492f,3.39038086f,0.23486328f,-2.46826172f,1.14550781f,1.94482422f,2.19580078f,-1.10498047f,-0.14624023f,0.93725586f,-1.60937500f,0.71142578f,-2.77416992f,-0.82470703f,1.82031250f,-1.32714844f,1.35449219f,-0.83520508f,-1.40234375f,2.35864258f,0.89770508f,1.11572266f,1.99096680f,-0.58715820f,3.55493164f,3.62158203f,-0.42089844f,-2.38159180f,-1.06054688f,-1.63232422f,-1.45556641f,2.77832031f,1.22412109f,1.59667969f,-2.28686523f,0.40747070f,-0.94628906f,-1.65332031f,-2.49121094f,2.22802734f,0.70239258f,0.78710938f,-0.47558594f,-1.32348633f,0.93603516f,0.30541992f,1.27197266f,3.64404297f,-1.45483398f,-1.59179688f,0.92480469f,-0.10791016f,-2.60107422f,1.99340820f,2.03442383f,-2.94580078f,-1.08715820f,-2.56127930f,-1.16796875f,-2.49169922f,-0.88085938f,1.30908203f,-2.30102539f,1.29663086f,-0.61914062f,-1.51513672f,-2.35571289f,-0.79760742f,3.57128906f,-1.65942383f,-2.69335938f,1.97778320f,2.77270508f,-1.95434570f,0.37963867f,-0.35498047f,0.64697266f,-0.04541016f,1.17431641f,1.18579102f,0.73095703f,0.52661133f,-1.51733398f,1.23510742f,1.34643555f,0.35180664f,-1.59423828f,0.35229492f,2.10668945f,-0.62817383f,0.48291016f,0.14990234f,-1.95092773f,-0.04052734f,0.18945312f,1.89892578f,0.87768555f,-1.66967773f,0.47558594f,0.71435547f,-1.79492188f,-1.16503906f,-1.96655273f,1.82836914f,-0.81323242f,2.24389648f,-1.00878906f,-0.47998047f,-1.70605469f,2.28076172f,-4.51440430f,-4.63452148f,-0.39746094f,-1.97192383f,2.47631836f,1.23608398f,3.39819336f,-0.21093750f,0.03613281f,-2.54492188f,1.50122070f,-0.95898438f,0.71508789f,2.89233398f,2.77929688f,1.09570312f,2.74316406f,-1.35644531f,0.49218750f,0.29833984f,-0.44995117f,0.22998047f,1.49877930f,-4.88696289f,-0.86938477f,-0.19262695f,0.05957031f,0.29248047f,0.72802734f,0.87695312f,-3.94506836f,-2.68896484f,-5.58789062f,3.49389648f,1.76879883f,-1.30297852f,-1.63720703f,-0.11010742f,2.01074219f,-0.30078125f,-2.20410156f,-1.83789062f,2.46777344f,0.72143555f,-0.77807617f,1.60107422f,-1.94750977f,2.46972656f,-2.33154297f,-1.04077148f,0.14648438f,2.04272461f,-3.44482422f,2.93603516f,1.38891602f,0.77343750f,2.94921875f,-0.54394531f,-3.32714844f,-1.53076172f,1.16821289f,1.57958984f,-0.74316406f,0.44604492f,2.09448242f,-1.38403320f,-2.06469727f,2.57617188f,1.79980469f,-2.28344727f,-2.84008789f,-0.83007812f,0.88232422f,4.27636719f,1.58374023f,-3.31787109f,-2.09619141f,-1.51562500f,-2.50244141f,-3.96923828f,-3.21118164f,0.36767578f,1.77612305f,-3.65502930f,-4.65112305f,-2.12719727f,0.72851562f,-2.41088867f,-0.46875000f,-0.82177734f,1.64575195f,1.98144531f,1.45678711f,1.00610352f,-0.50219727f,3.30371094f,1.69897461f,-1.11303711f,2.03125000f,1.05053711f,-2.23999023f,1.12841797f,-2.39013672f,1.11865234f,0.56933594f,1.81250000f,0.99047852f,-0.41284180f,4.65795898f,-1.76586914f,-1.29541016f,-1.14501953f,-2.58325195f,-0.14355469f,-1.97729492f,0.60839844f,5.20556641f,2.63452148f,1.20117188f,1.25170898f,3.46118164f,-2.30786133f,-2.94555664f,-1.40454102f,2.55126953f,-1.15405273f,2.34887695f,0.89257812f,-1.57373047f,1.61108398f,-1.62866211f,1.25390625f,-1.73974609f,-2.64916992f,0.80346680f,1.45019531f,0.11718750f,3.65283203f,-2.14404297f,0.12377930f,0.66137695f,-1.53857422f,-1.03247070f,-0.81518555f,4.42138672f,0.89892578f,-0.50073242f,0.43261719f,0.88989258f,-2.00708008f,4.55200195f,-1.70263672f,-1.24804688f,-2.51611328f,0.40722656f,-1.93847656f,0.81201172f,2.96166992f,-2.94140625f,-0.50292969f,-1.51635742f,-1.84375000f,0.39648438f,-0.60791016f,-0.21923828f,1.44140625f,-0.71801758f,-3.60131836f,0.40429688f,0.12939453f,-2.33959961f,-0.21093750f,-0.90478516f,2.16186523f,0.66430664f,0.27319336f,2.17651367f,-0.94921875f,2.11328125f,-1.23950195f,-0.21069336f,1.32153320f,-3.55615234f,2.33398438f,2.98095703f,2.89868164f,-1.25756836f,0.04785156f,-0.02832031f,-3.47656250f,-1.89819336f,0.97241211f,1.53222656f,1.90942383f,-2.41943359f,4.01806641f,-1.42016602f,-1.65991211f,-2.10278320f,1.65649414f,-3.26367188f,-0.49853516f,3.63623047f,2.86352539f,0.74365234f,0.64428711f,2.22851562f,-3.09692383f,0.76611328f,0.02441406f,-0.65380859f,-2.29174805f,2.63989258f,2.06689453f,0.74072266f,-2.48022461f,0.67114258f,0.26855469f,2.25878906f,-3.41088867f,-0.43261719f,3.55126953f,0.79467773f,2.01440430f,1.58227539f,2.56445312f,0.42578125f,-0.80859375f,-1.82299805f,-0.79370117f,-0.88989258f,-2.36401367f,-3.06079102f,1.26367188f,-0.02197266f,0.22216797f,1.35253906f,-0.55712891f,-3.34375000f,0.78710938f,3.08935547f,-0.23364258f,-0.92163086f,-1.00585938f,0.50976562f,-0.76977539f,-2.07348633f,-1.72631836f,0.89721680f,1.89160156f,-0.62207031f,-0.22241211f,3.46313477f,-1.59082031f,-3.35375977f,-0.41137695f,-2.10546875f,1.23608398f,-1.40307617f,0.83056641f,-0.55004883f,3.17993164f,0.91235352f,1.59301758f,3.06445312f,2.07763672f,-0.15820312f,1.48266602f,-0.65185547f,-2.60058594f,1.21118164f,0.04907227f,-0.57470703f,-2.44165039f,5.34497070f,-4.45483398f,-2.55541992f,-0.99096680f,1.05371094f,-2.98632812f,-0.80737305f,-0.31933594f,-2.52880859f,-0.40795898f,0.79882812f,-1.33984375f,-0.97509766f,-3.17724609f,-1.81518555f,-0.61303711f,3.16015625f,1.41113281f,-0.90307617f,-0.98706055f,0.52148438f,-3.12524414f,-2.28466797f,-0.52758789f,-2.12377930f,1.12304688f,-0.00537109f,1.55151367f,-2.35888672f,-0.04614258f,1.93750000f,-1.00952148f,0.89892578f,3.39306641f,-0.23535156f,-1.89550781f,-0.60595703f,-0.79638672f,-0.88452148f,-1.92285156f,1.46850586f,0.37207031f,5.94946289f,-2.07592773f,0.92773438f,0.50048828f,-0.28320312f,2.77148438f,0.44042969f,-2.16406250f,-4.12597656f,0.81494141f,1.55810547f,-1.37280273f,0.28906250f,2.69335938f,-0.78833008f,2.79833984f,-0.09887695f,-3.24584961f,1.49194336f,1.21337891f,-2.30200195f,2.07104492f,1.62158203f,1.25000000f,2.06982422f,0.78247070f,-0.84301758f,3.52612305f,1.14038086f,0.06542969f,0.39184570f,-3.38159180f,-1.52807617f,-2.45776367f,-2.74145508f,-1.39355469f,-0.73730469f,-0.99975586f,-0.02026367f,0.17407227f,1.91943359f,1.34277344f,2.81835938f,0.25634766f,-4.00585938f,-2.04321289f,1.72680664f,0.81127930f,-0.16113281f,0.24877930f,-1.13671875f,-1.32250977f,-2.71606445f,-1.00927734f,-0.73193359f,-1.47460938f,1.65478516f,0.01416016f,-1.82763672f,2.77807617f,0.56323242f,-2.09155273f,0.02050781f,-1.65698242f,5.49707031f,1.04272461f,0.50659180f,1.13110352f,2.14086914f,-3.43261719f,0.22314453f,0.76171875f,1.20556641f,-2.18041992f,0.51855469f,-1.83691406f,1.25537109f,0.96777344f,0.77465820f,-0.10424805f,-0.29516602f,-0.08935547f,-0.71044922f,0.91992188f,2.63867188f,2.57202148f,-0.56372070f,-1.73413086f,0.86914062f,-0.61645508f,-1.01977539f,-1.14721680f,1.61523438f,1.20654297f,0.75708008f,0.98754883f,-3.18237305f,2.86645508f,-1.99682617f,0.92163086f,0.44482422f,1.30297852f,0.58178711f,-4.12817383f,-1.98291016f,-0.41650391f,0.20458984f,-2.32299805f,-2.13476562f,2.05688477f,0.57958984f,2.99218750f,-4.15356445f,-3.17285156f,-0.26098633f,0.58520508f,1.21630859f,1.68310547f,-1.50122070f,1.15014648f,0.88183594f,-0.44165039f,-2.21459961f,1.97583008f,-4.00341797f,-0.34838867f,1.77587891f,-2.87670898f,-0.99023438f,-2.08374023f,0.02783203f,1.22534180f,-0.72094727f,-2.32812500f,0.27880859f,3.34594727f,0.76635742f,-0.78955078f,2.21264648f,2.96655273f,0.21972656f,3.49096680f,3.81787109f,-1.38916016f,-3.10522461f,-0.90087891f,-4.68041992f,-2.21093750f,3.04418945f,-4.27270508f,-0.40600586f,-2.84155273f,1.10131836f,-1.55346680f,2.05834961f,0.48925781f,-0.23901367f,0.74975586f,2.83227539f,-0.78784180f,0.62695312f,-0.32104492f,-1.53930664f,-1.51513672f,0.17382812f,-0.41186523f,0.62792969f,-5.09008789f,-2.78198242f,-0.12377930f,-0.30200195f,-1.11499023f,-4.78369141f,0.46728516f,0.78906250f,0.30395508f,-1.12792969f,-0.38891602f,1.61450195f,0.76416016f,-2.27368164f,-2.44360352f,-0.54638672f,-2.25268555f,-2.91650391f,1.28540039f,-3.71386719f,2.30078125f,2.51586914f,-1.67407227f,3.41210938f,0.53881836f,2.23999023f,2.83300781f,-1.47753906f,-0.14550781f,1.50390625f,0.21337891f,-1.01000977f,-0.21557617f,-0.51586914f,1.24780273f,-0.83862305f,-0.54248047f,3.19726562f,-1.88330078f,-5.23657227f,-0.27392578f,-1.48144531f,-3.04907227f,-1.41967773f,1.86865234f,1.96044922f,1.42016602f,0.88256836f,0.81298828f,1.03930664f,0.58837891f,-0.60913086f,-2.20336914f,-0.13281250f,-3.00903320f,-0.17358398f,3.58886719f,1.06201172f,-0.27001953f,-0.92333984f,-1.04003906f,3.15649414f,1.94067383f,-1.79785156f,-1.27172852f,0.34082031f,-1.99414062f,-1.32055664f,-1.05419922f,-1.81323242f,1.65112305f,3.85961914f,-0.72338867f,4.94287109f,-0.92968750f,-2.13842773f,-3.98974609f,-1.25073242f,1.58374023f,-2.47705078f,-0.07885742f,-0.16748047f,-3.02001953f,-1.21997070f,-0.06079102f,-0.08837891f,-1.78857422f,0.11010742f,0.15771484f,-1.80541992f,2.71826172f,-0.73364258f,-3.36132812f,1.75781250f,-1.02685547f,1.43164062f,0.68115234f,0.72485352f,6.38696289f,0.98217773f,0.92773438f,0.80395508f,4.76733398f,0.63452148f,-0.20922852f,0.36352539f,1.32958984f,-1.29565430f,1.15625000f,-4.76049805f,-0.95214844f,-2.08520508f,3.37695312f,-1.25878906f,-1.93212891f,-3.44946289f,-3.36865234f,-3.71972656f,-0.82446289f,-2.87060547f,3.43164062f,-0.72338867f,-2.09692383f,-0.14648438f,1.56909180f,-5.36254883f,2.28344727f,-2.12500000f,1.62646484f,-0.33251953f,2.31909180f,-3.25927734f,2.13500977f,-1.59960938f,-3.16943359f,3.01611328f,4.14233398f,2.37890625f,-1.75708008f,-0.42675781f,0.09594727f,0.11889648f,0.59228516f,-3.85766602f,-0.06835938f,-1.51513672f,2.31030273f,-1.31298828f,0.42309570f,-2.94482422f,-2.71166992f,1.24438477f,-3.16552734f,-0.96289062f,-3.78027344f,-0.74047852f,2.01757812f,1.56665039f,-2.45922852f,-1.97167969f,3.58666992f,-2.52075195f,-1.68115234f,2.69921875f,-3.13671875f,1.61010742f,-1.40893555f,-1.06079102f,2.33227539f,-1.14550781f,-2.80468750f,-0.07739258f,-0.87524414f,-4.86791992f,0.27319336f,-0.84545898f,-1.99707031f,1.51782227f,0.53076172f,0.97827148f,-2.61010742f,-1.00073242f,2.28710938f,1.25781250f,0.92260742f,-0.60742188f,-0.72314453f,-3.65136719f,-1.35693359f,0.72802734f,-1.83178711f,-3.05517578f,2.44921875f,-2.91528320f,-0.62084961f,-3.86645508f,-3.84399414f,-2.18847656f,-0.45092773f,-0.17065430f,-0.71166992f,0.12646484f,2.59619141f,1.67822266f,-0.30688477f,2.69604492f,2.14453125f,1.57421875f,0.09228516f,-4.09497070f,-1.12451172f,-0.51245117f,-2.76611328f,3.75170898f,0.93286133f,-3.33251953f,-0.09570312f,4.44995117f,-2.15185547f,1.34521484f,0.32153320f,1.04223633f,0.08764648f,-2.74975586f,1.12890625f,-1.27343750f,3.16918945f,-2.14306641f,-1.74804688f,-0.34228516f,0.00610352f,2.41967773f,-2.78979492f,2.52954102f,0.11352539f,1.13842773f,-2.22070312f,-1.65991211f,-1.24951172f,3.82373047f,-0.50463867f,-1.61743164f,1.18774414f,1.25927734f,-0.53588867f,1.90625000f,2.94213867f,-1.14135742f,2.67382812f,0.09204102f,-0.39965820f,0.98828125f,-3.10888672f,0.61206055f,-1.09008789f,2.83374023f,0.08715820f,1.53100586f,1.78320312f,-0.30566406f,-0.09375000f,1.35717773f,0.02539062f,0.45556641f,3.23437500f,4.26342773f,-0.84130859f,0.86279297f,-1.67138672f,0.18847656f,-1.57568359f,1.91992188f,4.67163086f,0.21948242f,0.59765625f,-0.12622070f,-3.29003906f,1.03222656f,0.79858398f,5.54858398f,-0.91625977f,0.02563477f,-1.66723633f,2.25781250f,0.29101562f,1.81396484f,2.96191406f,1.46679688f,-3.13647461f,-1.82836914f,-2.89404297f,-0.19140625f,0.13989258f,-1.45556641f,1.44287109f,-2.34570312f,-0.51196289f,1.61401367f,2.58837891f,3.12084961f,-1.83618164f,1.04345703f,-0.82568359f,-0.23730469f,-2.22827148f,3.79296875f,-1.52270508f,-0.05395508f,1.05688477f,-1.73071289f,-1.84619141f,-1.83422852f,3.76635742f,0.03125000f,-0.34643555f,0.68994141f,3.03833008f,-4.11718750f,-2.12573242f,1.29589844f,-2.60327148f,-1.61572266f,0.20971680f,0.25219727f,5.42749023f,-1.18237305f,1.88159180f,1.35839844f,0.24658203f,-0.31079102f,-2.61010742f,2.76953125f,0.55395508f,3.58276367f,2.73144531f,-1.07446289f,1.52172852f,3.33251953f,1.17456055f,1.31079102f,-1.60522461f,2.61572266f,-0.27026367f,-0.99902344f,2.22973633f,-1.71728516f,-0.14184570f,-2.91381836f,5.54833984f,-1.93652344f,0.99121094f,-1.31079102f,0.09057617f,1.33593750f,-5.30102539f,2.29809570f,-0.19555664f,-2.01000977f,-1.10668945f,-0.22436523f,-0.24584961f,0.67407227f,2.76464844f,0.71093750f,-0.21435547f,1.96044922f,0.71044922f,0.29003906f,-1.15771484f,3.12792969f,-1.24340820f,-0.38574219f,-4.12060547f,-2.78149414f,1.09106445f,1.45605469f,2.14111328f,5.47827148f,-0.61108398f,2.37719727f,0.21264648f,3.86816406f,-1.52001953f,-0.89575195f,0.50781250f,1.82519531f,0.86425781f,0.45874023f,0.95483398f,2.38916016f,-0.93334961f,2.20605469f,-1.15087891f,-0.50170898f,-2.77587891f,-0.26123047f,-3.01049805f,-3.13208008f,-1.36157227f,-0.87182617f,-3.21289062f,-1.15942383f,-0.59594727f,1.51977539f,2.93750000f,-0.10693359f,0.68188477f,2.08081055f,0.33642578f,-0.17871094f,-2.07617188f,1.61962891f,-2.69213867f,0.08691406f,-0.32641602f,2.19750977f,2.80566406f,3.49682617f,0.57446289f,2.36352539f,2.99902344f,-0.38208008f,-1.41479492f,-2.36889648f,-2.02832031f,-0.13793945f,1.27294922f,1.58935547f,0.88452148f,-0.25341797f,1.87646484f,1.41186523f,1.19433594f,0.58251953f,0.70581055f,0.50170898f,0.10253906f,-2.81176758f,-6.15551758f,1.88745117f,-0.07226562f,-4.51464844f,-2.38232422f,-2.31958008f,0.50122070f,-0.81127930f,0.65600586f,2.09545898f,0.48681641f,1.85424805f,3.83935547f,-1.50537109f,1.16870117f,-1.11962891f,-1.59814453f,0.70605469f,3.32177734f,-0.65673828f,3.02807617f,-1.66333008f,-0.21850586f,1.07348633f,0.80566406f,2.17187500f,2.00170898f,1.93994141f,0.42504883f,-0.32177734f,0.80029297f,-2.19238281f,-2.61669922f,0.73510742f,0.11230469f,-0.92358398f,-1.36596680f,0.04125977f,-0.48999023f,1.52050781f,-0.02758789f,1.07177734f,-1.69775391f,1.74975586f,-3.14379883f,-3.35937500f,3.44018555f,1.09448242f,1.62890625f,4.49975586f,2.70751953f,3.57812500f,-0.03369141f,-3.22241211f,0.44873047f,0.60498047f,-0.87646484f,0.30371094f,0.33886719f,5.38208008f,2.48706055f,0.09472656f,0.83935547f,-0.50341797f,-1.09448242f,2.21923828f,-1.62280273f,-0.98876953f,0.30688477f,1.47851562f,0.25048828f,0.40625000f,-1.86791992f,-1.04321289f,-2.22143555f,2.72607422f,-2.10131836f,-2.29003906f,0.41235352f,3.02783203f,-0.43457031f,-1.61621094f,4.24658203f,2.77343750f,2.50805664f,1.03198242f,0.19995117f,-1.92382812f,3.53125000f,0.62182617f,-0.53100586f,3.30444336f,0.53857422f,-1.67919922f,-2.84350586f,1.55419922f,3.70434570f,-0.60009766f,2.01293945f,0.86303711f,-2.73852539f,-2.80981445f,0.73754883f,0.22460938f,0.31420898f,0.17089844f,-0.38476562f,-0.43994141f,-0.66137695f,0.03955078f,0.56323242f,-2.41088867f,-0.30419922f,-1.23486328f,-1.42114258f,-0.41845703f,-1.49096680f,3.35522461f,0.28344727f,-1.32934570f,2.45971680f,-1.27392578f,-4.18798828f,-0.57519531f,1.06958008f,-0.01074219f,1.21557617f,-0.18457031f,0.15869141f,1.23852539f,4.52294922f,1.33715820f,-1.19482422f,0.07714844f,3.10498047f,-3.56591797f,-1.65161133f,4.24633789f,1.07397461f,-1.02636719f,1.36010742f,-2.59082031f,2.70019531f,-1.77050781f,-2.55004883f,2.03979492f,-1.95190430f,0.89550781f,-2.44116211f,1.39526367f,1.07763672f,-0.23413086f,5.59667969f,1.19970703f,-0.94873047f,2.03662109f,-3.65917969f,-1.53662109f,-0.40576172f,0.42114258f,0.69726562f,2.79150391f,-1.53173828f,-1.99023438f,-0.66137695f,-1.17407227f,-0.30810547f,1.73120117f,-1.54980469f,-0.26586914f,-0.59252930f,-0.75048828f,0.19628906f,-2.60791016f,-1.45581055f,-1.44506836f,-0.12207031f,-0.39208984f,-0.62524414f,1.72412109f,-0.75878906f,-1.75610352f,1.08789062f,-0.26953125f,-0.42993164f,1.44726562f,1.14404297f,-1.57104492f,3.03735352f,-1.71459961f,-0.52685547f,2.26171875f,1.76977539f,-0.00830078f,-4.58886719f,0.10058594f,1.43579102f,-0.79052734f,1.17602539f,0.19702148f,-1.47167969f,0.22875977f,2.44873047f,-0.67211914f,-1.48925781f,-4.35351562f,-3.66723633f,0.68164062f,0.24072266f,-0.07226562f,-0.80615234f,1.21020508f,1.58837891f,2.18847656f,-0.35864258f,-1.67822266f,2.16430664f,-0.16943359f,-0.39916992f,-1.39306641f,-1.27246094f,-0.45361328f,-2.07177734f,-2.15673828f,-0.33813477f,2.25512695f,-0.13623047f,-2.32104492f,0.18286133f,0.58959961f,0.41772461f,-1.23876953f,-3.08520508f,0.41088867f,-1.41601562f,-0.10351562f,-1.68334961f,-2.77514648f,-2.18481445f,-1.65576172f,1.51953125f,-0.91259766f,2.22192383f,-1.13598633f,-0.74389648f,-1.19506836f,-1.19067383f,-0.23095703f,-0.51464844f,0.78540039f,1.16552734f,0.55200195f,0.98364258f,2.11791992f,-2.87670898f,3.08593750f,-1.87036133f,0.67285156f,-1.03051758f,-4.54663086f,1.72485352f,0.01977539f,-4.21826172f,-1.80957031f,0.77490234f,1.03466797f,0.67773438f,-2.24218750f,-1.93969727f,2.21118164f,-2.85375977f,1.25097656f,-0.67700195f,-1.25317383f,-1.26000977f,0.30517578f,0.42553711f,-0.14111328f,-0.07177734f,2.49731445f,1.17285156f,0.56152344f,2.09960938f,2.97656250f,2.40136719f,-1.29663086f,-0.92944336f,-2.44995117f,1.83056641f,-2.52392578f,-0.88476562f,-2.30102539f,0.71093750f,-3.22363281f,-4.37841797f,1.27465820f,-4.06176758f,3.44262695f,0.10229492f,-0.40356445f,-3.68847656f,-0.46655273f,0.43041992f,-0.43359375f,2.26147461f,0.01562500f,-0.61108398f,-1.95825195f,0.75756836f,-2.01733398f,0.11035156f,3.88867188f,-0.87011719f,-0.45629883f,-2.27832031f,-0.29614258f,0.34716797f,-0.32592773f,-1.44360352f,-0.71606445f,-1.28662109f,4.02758789f,0.04833984f,1.74414062f,0.32519531f,-0.48779297f,1.84765625f,-2.65991211f,1.03540039f,-3.39184570f,0.09472656f,0.45214844f,-0.75195312f,0.72290039f,-0.50292969f,-1.15795898f,-3.96020508f,-0.51196289f,-0.11425781f,-1.94824219f,-3.59594727f,0.89648438f,-0.44238281f,1.19604492f,-1.45751953f,-1.34521484f,-2.26879883f,2.48242188f,3.82592773f,3.88183594f,4.15844727f,-0.84765625f,2.70385742f,-2.22387695f,-0.67578125f,-0.61889648f,-2.61303711f,2.32568359f,2.24267578f,-0.56347656f,2.62060547f,-0.00781250f,-2.29223633f,-0.43945312f,0.79711914f,3.28710938f,-4.30224609f,-0.19824219f,2.75268555f,-1.51904297f,-1.82885742f,1.33959961f,2.82592773f,-0.72241211f,-1.15307617f,-1.71923828f,-0.18676758f,0.36059570f,-0.09667969f,-1.71752930f,1.70556641f,-0.66894531f,3.15869141f,-1.82983398f,-0.47021484f,1.78955078f,-2.63647461f,0.05126953f,0.77124023f,1.93408203f,2.51733398f,0.44921875f,-1.17163086f,3.73706055f,1.96118164f,2.05395508f,-1.17700195f,4.86645508f,3.55029297f,1.71655273f,1.03271484f,3.77490234f,-1.71459961f,-0.14892578f,0.50488281f,5.33154297f,6.22094727f,1.22778320f,2.89746094f,4.15405273f,1.40893555f,3.18798828f,-1.91113281f,-1.63476562f,3.84423828f,1.00903320f,2.78320312f,-0.22998047f,-2.32250977f,0.45654297f,-0.90209961f,0.11254883f,3.13500977f,3.27075195f,-1.08178711f,4.21044922f,1.71630859f,1.25756836f,-1.86059570f,2.04980469f,2.59155273f,2.69311523f,0.36791992f,0.39941406f,1.49462891f,1.79638672f,-2.76269531f,-1.04785156f,-1.43798828f,0.38793945f,0.19580078f,-2.43676758f,2.74707031f,-3.44775391f,1.58740234f,0.15356445f,-0.35400391f,1.48681641f,-2.49267578f,1.90942383f,1.77905273f,-3.68432617f,0.15185547f,2.02124023f,0.32836914f,4.29687500f,2.52416992f,0.05029297f,-1.23461914f,2.15258789f,-1.45117188f,2.35668945f,0.85839844f,2.66455078f,-0.21850586f,1.93359375f,-0.20776367f,-2.30004883f,0.34326172f,-2.33251953f,0.77197266f,2.20458984f,-4.80395508f,0.59204102f,0.99023438f,-2.09301758f,1.55810547f,1.04101562f,-1.08569336f,0.26367188f,-0.28222656f,-0.47949219f,1.30102539f,2.02319336f,-1.03686523f,1.33496094f,0.35229492f,0.97021484f,2.01562500f,-1.11450195f,-1.03833008f,0.62866211f,-2.14257812f,-0.30712891f,-0.82104492f,-2.74926758f,0.70678711f,-1.78491211f,-0.02124023f,2.00512695f,2.44189453f,1.93969727f,-1.25292969f,2.79150391f,0.43457031f,2.04223633f,-1.84252930f,-5.24755859f,0.36132812f,-0.92773438f,1.26879883f,0.23779297f,2.77880859f,0.13500977f,-1.44799805f,-4.22314453f,1.38378906f,0.37500000f,-0.87475586f,0.87646484f,0.48339844f,3.10717773f,-1.88354492f,1.35327148f,-1.05664062f,1.07543945f,-2.63012695f,-3.10668945f,-2.69116211f,1.57690430f,-1.04394531f,-0.55322266f,0.85986328f,1.88037109f,-2.69970703f,-0.04052734f,-0.02343750f,3.80883789f,-0.40625000f,-0.16113281f,2.01342773f,1.28784180f,-0.79370117f,-3.43994141f,1.35595703f,0.35424805f,2.69897461f,0.03613281f,-1.41650391f,2.25390625f,0.59667969f,1.64965820f,-2.99609375f,1.13793945f,0.36767578f,-1.74926758f,-0.85791016f,1.47631836f,2.40869141f,1.80590820f,1.97729492f,-1.70385742f,3.03906250f,-0.64086914f,0.75634766f,1.42285156f,-0.49536133f,3.57080078f,-0.51513672f,-1.51049805f,3.15307617f,0.55493164f,1.75195312f,-1.01928711f,2.63891602f,-2.28369141f,1.57641602f,0.43725586f,2.59887695f,-2.45532227f,-1.38281250f,3.88281250f,0.04443359f,-0.89135742f,0.24047852f,1.72534180f,-1.97656250f,-0.15234375f,-0.36010742f,-0.43237305f,0.49414062f,0.06909180f,-0.04321289f,0.66845703f,3.80981445f,4.42675781f,-0.21362305f,0.00463867f,1.57617188f,1.44458008f,-0.71972656f,0.29663086f,-0.46752930f,-0.89233398f,-1.90502930f,1.65209961f,-0.03857422f,0.55590820f,-4.65551758f,0.33032227f,1.14624023f,0.41210938f,-0.64404297f,2.46679688f,0.37158203f,1.33129883f,2.43261719f,1.42626953f,-3.12597656f,2.35034180f,2.71679688f,0.16967773f,1.18383789f,-0.16235352f,-3.20947266f,2.38110352f,-0.11425781f,0.68823242f,-0.43310547f,1.09887695f,1.54028320f,0.28417969f,4.56079102f,-1.99926758f,2.37963867f,1.75415039f,3.46044922f,2.41210938f,-0.86401367f,1.77124023f,0.88305664f,1.71606445f,-3.63842773f,-0.08007812f,0.40185547f,3.42163086f,1.67065430f,1.28051758f,2.36645508f,-0.77905273f,-2.72778320f,-2.70581055f,-0.75830078f,0.14111328f,-0.60498047f,-0.37402344f,1.24047852f,-5.40332031f,1.52685547f,-0.43896484f,-0.69506836f,-3.24487305f,1.52514648f,0.78735352f,1.42944336f,3.28027344f,2.88842773f,-2.94506836f,0.92578125f,-0.34350586f,-1.72412109f,1.28833008f,2.53759766f,-1.58081055f,0.98437500f,1.54589844f,0.49243164f,1.46752930f,2.57812500f,0.15356445f,0.03808594f,1.17724609f,-0.75585938f,1.63793945f,0.96899414f,-3.43676758f,-0.81567383f,4.08178711f,-0.19897461f,2.62304688f,2.50830078f,-0.45825195f,2.11206055f,-0.79125977f,-2.93774414f,1.18676758f,-0.91088867f,0.23608398f,0.65747070f,-4.43603516f,-5.04541016f,-0.00097656f,5.10351562f,1.30297852f,-0.34155273f,0.78979492f,-1.61499023f,1.98095703f,4.07714844f,1.18188477f,-0.81518555f,0.98730469f,-4.00195312f,1.57250977f,-1.85742188f,1.21093750f,-1.89648438f,-3.04711914f,2.54272461f,1.21557617f,-0.57275391f,1.12207031f,-0.82080078f,0.27539062f,4.23168945f,-3.03393555f,-1.31030273f,-0.74218750f,-0.72119141f,2.36303711f,-1.55419922f,-0.65063477f,1.28442383f,0.44238281f,3.55004883f,-0.64648438f,0.51220703f,2.00048828f,0.35937500f,0.73901367f,0.73242188f,-0.59985352f,-0.62011719f,2.75756836f,2.28881836f,-2.56323242f,0.36303711f,-0.88061523f,-2.63476562f,-1.65454102f,-1.59082031f,-0.62988281f,0.17504883f,2.77856445f,1.48437500f,-1.80468750f,0.75610352f,1.94506836f,1.90771484f,-0.51757812f,-0.99853516f,1.47216797f,1.48779297f,1.01367188f,-1.68872070f,2.93188477f,0.54321289f,5.73852539f,-4.37670898f,-0.13647461f,0.03344727f,0.58129883f,0.66479492f,-3.45678711f,-4.33862305f,-0.70947266f,-0.74316406f,-3.07299805f,0.25048828f,-2.27929688f,2.67138672f,1.46997070f,-2.02612305f,-1.01049805f,-1.43725586f,-2.76660156f,1.93872070f,2.47827148f,0.63598633f,1.66503906f,-0.80957031f,1.43286133f,0.44702148f,2.50463867f,1.53857422f,0.21069336f,-0.43432617f,1.17211914f,-3.84521484f,-2.40917969f,-1.05200195f,-2.62011719f,-3.42602539f,1.96118164f,-1.65112305f,1.34985352f,-1.92993164f,1.06689453f,2.25585938f,3.46972656f,3.42846680f,-1.00415039f,-1.28979492f,0.33740234f,0.08569336f,3.02001953f,-4.39794922f,-2.26806641f,0.43676758f,-1.13012695f,-5.31860352f,-0.46752930f,4.30419922f,-3.51782227f,-4.00366211f,-0.95703125f,1.48779297f,1.45996094f,-0.12475586f,2.90820312f,3.48535156f,-1.34130859f,1.57666016f,0.24609375f,1.90185547f,-0.99487305f,0.20581055f,-0.23437500f,-0.43212891f,0.41943359f,0.47338867f,-0.67480469f,-1.28149414f,-2.83911133f,-1.69921875f,-2.20312500f,-0.60620117f,-1.66674805f,-1.05932617f,0.50952148f,0.40576172f,-0.94628906f,-0.62158203f,-1.51562500f,0.31567383f,-1.21997070f,-5.99072266f,0.15942383f,-2.16430664f,2.22412109f,1.81079102f,0.08203125f,1.18774414f,1.01464844f,0.21655273f,-1.80297852f,-0.08007812f,2.09692383f,0.53784180f,2.63867188f,1.36157227f,1.08154297f,0.19213867f,0.98925781f,0.53662109f,2.49682617f,1.53955078f,-0.96972656f,-3.21850586f,1.33715820f,-1.72119141f,0.73608398f,-0.55493164f,-1.68652344f,-2.10644531f,0.38427734f,-1.98388672f,-0.25488281f,1.40795898f,-2.46826172f,0.96801758f,-1.59521484f,-0.94555664f,-0.29663086f,3.37402344f,-5.42749023f,-0.76611328f,-2.12158203f,-5.05029297f,-1.72338867f,2.14331055f,1.59375000f,0.05761719f,-0.26416016f,2.43334961f,0.88305664f,-0.11914062f,-0.40576172f,2.55541992f,3.80419922f,2.14794922f,0.13403320f,-0.15234375f,-0.87109375f,4.20507812f,0.99438477f,-2.92065430f,-2.60083008f,1.32568359f,-0.48535156f,4.82519531f,0.93554688f,0.64648438f,3.00488281f,-4.72583008f,1.63452148f,-2.66625977f,0.71508789f,-0.98852539f,-1.20776367f,-1.04687500f,0.16796875f,-1.58691406f,1.39599609f,1.45190430f,-2.14526367f,0.43115234f,-1.07861328f,-3.72485352f,3.44848633f,-1.09082031f,3.32690430f,1.91137695f,-2.00927734f,-0.39941406f,1.74658203f,1.16967773f,0.24291992f,-1.24853516f,-2.33642578f,3.51220703f,-0.84472656f,2.95654297f,-0.66918945f,-0.28979492f,0.42553711f,0.97094727f,-0.94360352f,0.46093750f,0.89892578f,0.27221680f,1.74023438f,-1.26977539f,-0.39526367f,-0.19311523f,2.33447266f,0.82788086f,1.84033203f,2.45190430f,-1.27490234f,0.97631836f,1.69067383f,1.52929688f,-4.71337891f,2.03662109f,-1.55908203f,0.69726562f,3.25683594f,0.02685547f,1.70043945f,-2.17089844f,2.11083984f,-2.32934570f,-0.54150391f,-0.64672852f,1.65698242f,3.72045898f,-1.93579102f,-4.48999023f,1.81469727f,1.41772461f,0.13452148f,0.41577148f,-3.07617188f,-2.03857422f,-0.81713867f,2.47314453f,0.36914062f,-0.31176758f,-0.58129883f,-1.66699219f,-0.32836914f,0.56542969f,0.76098633f,1.52978516f,-3.00708008f,-2.95166016f,1.35620117f,-2.21020508f,-1.67822266f,-0.44921875f,1.47583008f,1.43798828f,1.13549805f,0.85375977f,0.46679688f,2.47656250f,3.15698242f,-0.26245117f,-1.94921875f,1.15258789f,1.23046875f,-2.26953125f,-0.98095703f,0.18798828f,-1.13183594f,-0.86059570f,0.09033203f,0.82373047f,1.10034180f,-3.47167969f,-0.55664062f,-1.68286133f,-4.21557617f,2.49218750f,-3.48852539f,0.26611328f,-0.03906250f,-1.08691406f,-1.04956055f,-0.42114258f,-0.80737305f,3.14550781f,0.42626953f,-0.76342773f,-3.80444336f,-1.75000000f,-0.05566406f,2.21533203f,-1.15112305f,3.20800781f,2.04248047f,1.32861328f,3.89746094f,0.84667969f,1.86352539f,-2.29199219f,-0.53686523f,-1.76489258f,3.51269531f,-3.69555664f,0.44213867f,1.95117188f,0.74682617f,-0.61132812f,0.95288086f,0.86938477f,-0.73364258f,-1.09082031f,3.35913086f,0.75317383f,2.00537109f,1.31884766f,-1.93725586f,1.15356445f,0.45751953f,-1.55029297f,1.73071289f,1.80346680f,0.97241211f,-1.93994141f,-1.51391602f,-1.63110352f,-0.40747070f,2.24707031f,0.37304688f,-0.51928711f,-2.54296875f,-0.41455078f,-0.51806641f,-3.01953125f,1.74194336f,-3.85351562f,0.54467773f,-1.66064453f,0.12011719f,-4.58911133f,-1.33422852f,2.03369141f,0.89331055f,2.54565430f,-2.02685547f,-1.42285156f,-4.27856445f,-1.33471680f,-0.14135742f,-3.91674805f,1.90698242f,-2.00610352f,0.19165039f,0.18530273f,1.90039062f,-0.61450195f,1.45092773f,0.45605469f,-0.21679688f,0.06591797f,2.88769531f,2.32104492f,-1.84277344f,-1.25537109f,0.63037109f,0.33569336f,-1.47338867f,-0.67944336f,1.96508789f,1.44018555f,-1.06005859f,-2.46386719f,0.82543945f,1.62988281f,-1.81616211f,2.83740234f,-1.25463867f,0.57666016f,-0.20263672f,-0.95556641f,0.58178711f,-3.01538086f,-3.11352539f,-0.50756836f,-1.06225586f,-0.77563477f,-4.73510742f,0.30712891f,-0.82299805f,-0.93872070f,-0.20898438f,-4.89306641f,-1.68627930f,-0.34008789f,1.61181641f,-1.98510742f,1.44018555f,2.96606445f,0.28784180f,-1.09301758f,3.99389648f,-2.26049805f,0.73266602f,0.49340820f,-3.98559570f,0.68872070f,-0.47216797f,0.87841797f,0.26391602f,0.84936523f,1.72290039f,1.26171875f,0.18188477f,-1.49243164f,1.60058594f,-0.72924805f,0.15380859f,-1.22631836f,0.82739258f,-0.62573242f,0.04760742f,0.90820312f,0.71899414f,-0.28881836f,-1.44604492f,2.56176758f,-1.34838867f,-0.35424805f,1.53637695f,2.99218750f,-3.03588867f,-0.22436523f,1.57226562f,-0.85009766f,1.21435547f,3.43334961f,-0.24755859f,-3.51025391f,-2.55322266f,-0.82714844f,1.07421875f,1.57495117f,-0.37304688f,0.41943359f,-0.73950195f,-0.32275391f,-3.57885742f,-3.38110352f,-0.46972656f,-1.07910156f,-0.67309570f,-2.28222656f,1.42065430f,0.27441406f,0.20776367f,-4.92700195f,-1.74829102f,1.49755859f,-0.60595703f,-2.14941406f,3.30151367f,-1.60131836f,-3.33618164f,3.51831055f,-1.35009766f,0.21704102f,2.63623047f,2.96630859f,3.43066406f,-1.14306641f,-2.57519531f,1.35351562f,3.54125977f,-2.68237305f,2.23437500f,1.33154297f,1.01318359f,0.57934570f,-4.64086914f,-1.87084961f,1.10766602f,0.56469727f,3.07153320f,-1.06396484f,0.40795898f,2.29052734f,-1.46948242f,0.03076172f,-2.73022461f,-3.15869141f,-0.44726562f,-1.07128906f,-1.27001953f,-0.04125977f,-3.36572266f,-0.27099609f,-0.91455078f,0.91333008f,-2.69360352f,-0.10327148f,-0.14746094f,1.40502930f,0.67431641f,1.31347656f,-1.86596680f,-1.51855469f,0.08837891f,0.29052734f,-0.93090820f,-0.46313477f,0.85717773f,2.37792969f,-3.27099609f,-0.94995117f,0.04931641f,-1.09887695f,-1.43847656f,-0.84008789f,1.56030273f,-1.14721680f,1.14355469f,-1.20141602f,2.87500000f,4.50268555f,1.69384766f,-2.00463867f,6.94213867f,-1.37524414f,0.70703125f,-0.48217773f,0.61450195f,1.13232422f,1.42407227f,-2.53515625f,-1.12524414f,0.36206055f,-1.24804688f,0.26269531f,-0.87133789f,-2.02758789f,3.32177734f,0.07519531f,5.44140625f,0.44702148f,-2.99682617f,0.19628906f,-1.11572266f,-0.64892578f,0.30273438f,0.93603516f,-1.72851562f,-2.48291016f,-0.18261719f,1.19458008f,2.14257812f,1.29589844f,-1.42651367f,0.91284180f,-1.27954102f,0.61450195f,0.05297852f,0.96826172f,-0.32055664f,0.32495117f,-0.62622070f,1.75561523f,-3.62353516f,0.10961914f,-0.06542969f,-2.05566406f,-2.11669922f,0.41748047f,-3.84130859f,-3.57373047f,-0.83520508f,0.61523438f,-0.73779297f,-3.11889648f,2.18359375f,-0.58837891f,-1.27172852f,0.92700195f,1.82934570f,-0.36840820f,2.69824219f,-1.26489258f,-3.77368164f,-1.16845703f,2.35009766f,1.15625000f,0.89331055f,4.66113281f,-1.75366211f,-2.29785156f,1.15698242f,-0.32202148f,0.50683594f,-0.88256836f,-0.76123047f,0.32836914f,2.78002930f,-0.67480469f,-0.62426758f,-0.73510742f,-2.67504883f,0.92236328f,0.61840820f,-0.58227539f,-2.26904297f,0.80175781f,3.46386719f,0.24023438f,3.22656250f,1.64355469f,-1.09375000f,0.34472656f,0.33764648f,-2.47094727f,0.47583008f,0.70117188f,-4.59594727f,0.11206055f,1.63061523f,1.05566406f,3.05078125f,-3.07519531f,1.53222656f,-3.85522461f,-1.43969727f,-0.20141602f,-2.35644531f,0.58837891f,0.66723633f,-0.36132812f,-1.94970703f,-3.30322266f,1.23486328f,3.77783203f,0.52221680f,0.18994141f,0.28344727f,3.88110352f,-0.62280273f,0.02905273f,-2.83569336f,1.49072266f,3.27612305f,-0.32153320f,2.32543945f,2.22778320f,-0.91772461f,2.00830078f,2.55029297f,0.97802734f,0.76904297f,-1.57788086f,0.69848633f,-0.33862305f,0.07666016f,1.02490234f,-1.06640625f,2.33813477f,-0.39941406f,-0.53051758f,-2.80688477f,1.83276367f,-0.70971680f,1.49975586f,-0.45214844f,0.09033203f,1.79541016f,3.27832031f,-2.54711914f,1.14160156f,-2.92480469f,1.39086914f,3.16503906f,0.74926758f,2.61547852f,-2.93872070f,-1.23486328f,-1.23242188f,1.58007812f,-0.01611328f,-1.15942383f,3.00561523f,0.54248047f,-3.89843750f,1.06518555f,-0.15795898f,0.11083984f,-0.40283203f,1.70239258f,-0.00341797f,0.52124023f,2.06518555f,1.66113281f,-0.33496094f,-1.47851562f,-0.84985352f,2.29565430f,-0.11694336f,2.43212891f,-0.76538086f,0.78198242f,1.21679688f,1.36279297f,-4.14135742f,-0.01733398f,-3.41723633f,-0.98510742f,2.23950195f,0.67675781f,2.17822266f,-2.19262695f,-3.38842773f,4.20239258f,-2.23583984f,-0.55395508f,2.32568359f,-1.51611328f,2.78540039f,-3.43066406f,-3.42431641f,-1.27294922f,-4.70532227f,-0.56103516f,1.67773438f,-1.96972656f,-2.22534180f,-0.89819336f,-1.13964844f,-0.03198242f,-2.35180664f,1.40454102f,1.37573242f,-0.28198242f,-2.23071289f,0.88940430f,0.88305664f,1.07226562f,0.17895508f,1.06274414f,1.63378906f,-2.68041992f,-0.00756836f,0.88159180f,1.99047852f,1.78076172f,-0.01660156f,-1.06079102f,0.63256836f,-3.18017578f,-1.61425781f,0.73901367f,0.52856445f,0.54394531f,-0.55322266f,-2.13916016f,-0.95800781f,0.67480469f,4.12036133f,-0.36352539f,2.53637695f,-0.68212891f,1.96142578f,-0.83813477f,2.93896484f,-0.63061523f,-1.44433594f,1.30493164f,2.44970703f,0.03149414f,-3.34643555f,2.84643555f,-3.47119141f,-1.09033203f,2.52587891f,-1.00366211f,2.80957031f,2.75195312f,0.34033203f,-2.07714844f,1.11791992f,-1.08276367f,1.04223633f,-2.31347656f,0.40649414f,-0.39648438f,1.26416016f,-1.21264648f,0.33642578f,2.05078125f,-2.06811523f,1.41967773f,2.03149414f,2.11132812f,3.33593750f,0.09619141f,-1.62231445f,-0.92504883f,-0.47216797f,-1.62255859f,1.93701172f,1.02709961f,-0.04223633f,1.72973633f,0.48193359f,1.97338867f,1.79736328f,-0.70458984f,2.42675781f,2.58349609f,1.56884766f,2.51074219f,-1.03149414f,1.12573242f,-0.11523438f,0.30981445f,4.44140625f,-2.66796875f,-1.99584961f,2.00439453f,-0.33105469f,-0.22509766f,-2.98828125f,0.16284180f,0.43969727f,-0.37207031f,2.07250977f,-0.19018555f,-0.73364258f,-2.95703125f,2.07788086f,1.03906250f,2.28857422f,-2.53515625f,-0.49829102f,1.32202148f,-2.52783203f,-3.49853516f,0.69824219f,-1.76220703f,-0.34667969f,1.97143555f,-0.27734375f,-0.71313477f,-1.54370117f,2.77563477f,1.08862305f,-1.24804688f,-0.70581055f,1.31127930f,2.98803711f,4.33520508f,1.24365234f,-0.75366211f,0.81860352f,-0.08398438f,0.09692383f,1.80419922f,0.80468750f,2.06494141f,2.46850586f,-2.95458984f,0.37768555f,0.70605469f,-0.06176758f,1.11083984f,2.61083984f,0.32324219f,0.57202148f,-2.04272461f,2.06762695f,-1.77709961f,-0.16333008f,1.87768555f,0.48291016f,0.94555664f,1.20092773f,-0.11279297f,-3.06518555f,2.25000000f,-0.18505859f,3.42578125f,-1.06835938f,-2.11132812f,-0.29516602f,-2.85278320f,3.04101562f,2.76391602f,-1.07446289f,1.52783203f,0.46655273f,1.23828125f,1.74243164f,-2.60375977f,0.68481445f,-0.67456055f,1.18994141f,-0.49682617f,-1.33081055f,-0.43432617f,-0.76977539f,0.53466797f,2.42993164f,-0.33837891f,1.50903320f,4.10083008f,-0.10375977f,-1.74584961f,-0.43237305f,1.78051758f,1.88378906f,-1.93090820f,0.75952148f,-4.19140625f,-0.95947266f,-0.77001953f,1.50805664f,2.47534180f,-2.70532227f,-0.11865234f,0.08032227f,-0.83203125f,2.99633789f,-1.29833984f,-0.94555664f,1.35571289f,-1.74023438f,2.93261719f,-1.82910156f,0.53417969f,-0.41430664f,1.52246094f,0.88891602f,-0.57128906f,0.41577148f,2.09960938f,2.75122070f,-3.33203125f,2.18798828f,-2.72729492f,-2.99389648f,1.53613281f,0.26928711f,-0.50170898f,1.73657227f,-1.45556641f,-0.10498047f,-2.97631836f,2.80249023f,-1.33276367f,1.41650391f,0.60937500f,0.62646484f,1.55737305f,-1.34985352f,-1.96972656f,-3.67407227f,1.78100586f,-0.09350586f,-5.40771484f,-0.51391602f,-0.61596680f,-3.57714844f,1.15869141f,-0.38549805f,0.66723633f,-1.41186523f,-0.77832031f,-1.57763672f,-1.86987305f,1.93603516f,-2.22290039f,0.64208984f,-2.26196289f,-3.60351562f,0.29296875f,-3.76660156f,0.80126953f,3.66918945f,0.38452148f,-2.51440430f,0.41918945f,1.24316406f,3.61840820f,-0.23974609f,-1.68872070f,-5.03369141f,1.95849609f,-2.29223633f,1.26855469f,0.54565430f,-1.66015625f,-2.06176758f,-2.09008789f,0.43408203f,1.34082031f,-1.45263672f,1.44067383f,-2.10595703f,-0.72143555f,-0.15673828f,0.36840820f,1.56005859f,0.35131836f,1.66137695f,0.54980469f,1.28955078f,0.36987305f,-0.35620117f,-0.89843750f,1.47705078f,1.04223633f,1.48486328f,-2.48657227f,-0.03442383f,-1.09375000f,-0.04565430f,1.38378906f,-2.74365234f,-2.45996094f,-0.55517578f,2.17944336f,-2.67456055f,-0.62036133f,1.82299805f,-2.73437500f,-0.75463867f,1.15795898f,-1.86132812f,-1.32397461f,-0.42333984f,-1.75561523f,-2.12426758f,-1.71289062f,-3.17724609f,-0.86108398f,1.91577148f,-0.86010742f,1.38720703f,4.46313477f,0.40209961f,-1.92382812f,0.03271484f,1.02075195f,1.73022461f,-2.49243164f,-0.19726562f,-1.98730469f,0.91186523f,1.07104492f,3.49365234f,-1.55371094f,-2.63623047f,1.96191406f,-1.39257812f,0.24902344f,0.80883789f,-1.90917969f,0.83056641f,2.97656250f,-0.17749023f,0.74682617f,0.94458008f,1.30273438f,-1.64208984f,1.03588867f,-0.08129883f,-0.62451172f,-3.85961914f,-3.02416992f,0.66430664f,-1.32519531f,1.20458984f,-0.81298828f,1.82226562f,-0.36865234f,0.76342773f,-1.51831055f,-3.55395508f,-0.02221680f,0.20166016f,-1.20507812f,0.70703125f,-0.53857422f,1.32080078f,0.00708008f,-0.62036133f,1.37695312f,0.62231445f,2.30590820f,-3.32617188f,1.44677734f,3.36474609f,-2.22558594f,-2.37670898f,-0.15820312f,1.67895508f,2.35009766f,0.62768555f,0.49951172f,-1.19042969f,-1.55102539f,4.66381836f,1.86132812f,0.71777344f,2.88842773f,-0.65209961f,-0.22265625f,3.83178711f,2.56958008f,0.30761719f,0.26000977f,2.15014648f,-1.90039062f,0.33715820f,2.88232422f,-2.33984375f,-2.51855469f,-0.58081055f,-2.20581055f,-0.58032227f,-0.92382812f,0.69140625f,0.85961914f,2.19335938f,-1.73999023f,-0.00024414f,-0.52661133f,-1.13134766f,0.14550781f,-2.51220703f,-1.76123047f,-1.57543945f,-2.03881836f,-1.44335938f,1.30786133f,3.58959961f,3.04785156f,-1.79467773f,-1.46313477f,0.15869141f,3.83251953f,-1.00366211f,-1.54907227f,0.38134766f,-0.32519531f,-0.07275391f,-3.26123047f,6.55468750f,-2.05468750f,-1.72216797f,1.78002930f,-3.24804688f,3.62329102f,1.94360352f,-0.70898438f,1.62036133f,-1.84423828f,-0.37133789f,-1.28637695f,-0.06738281f,-0.73901367f,0.52539062f,-2.73022461f,-0.68627930f,-1.39355469f,-1.22021484f,2.95556641f,-1.99365234f,-1.61816406f,2.27612305f,-1.29345703f,1.76171875f,-0.42431641f,1.61694336f,-0.93237305f,0.38183594f,-1.52832031f,-1.89526367f,-0.35009766f,1.71435547f,0.50390625f,3.57861328f,-1.13476562f,-5.48559570f,-0.26831055f,-0.81469727f,-0.54882812f,0.12133789f,0.01220703f,-0.86059570f,-2.55517578f,-2.76049805f,-2.02343750f,0.80761719f,-2.50097656f,-0.29125977f,0.30322266f,-2.98168945f,-2.07055664f,-1.13525391f,-2.03027344f,1.93432617f,-2.46313477f,-0.33691406f,1.24121094f,-0.32763672f,1.69873047f,0.75903320f,2.79418945f,-1.99780273f,0.66943359f,0.20922852f,2.07934570f,-1.08178711f,-2.23486328f,1.45629883f,-2.83300781f,-2.25195312f,-1.48510742f,0.58764648f,1.21875000f,-0.05322266f,1.77148438f,3.27416992f,-0.84277344f,3.57812500f,2.23291016f,2.02172852f,-1.83203125f,1.38232422f,0.03881836f,0.18505859f,-5.96215820f,2.21948242f,-1.62768555f,-1.57006836f,0.13354492f,0.42089844f,-3.06665039f,-2.94409180f,0.64135742f,2.31323242f,-0.07641602f,3.45483398f,2.27441406f,0.32641602f,1.39672852f,-0.74243164f,0.23559570f,1.78417969f,0.50415039f,-0.26123047f,-0.43115234f,-2.11914062f,-1.82299805f,0.27246094f,-3.48217773f,0.24902344f,0.81079102f,-3.67138672f,0.14941406f,1.81494141f,0.70727539f,2.54736328f,-1.00952148f,4.01220703f,-1.37377930f,-3.46508789f,2.42041016f,-0.72827148f,-2.92993164f,0.03198242f,-1.06884766f,2.78784180f,4.85522461f,-0.40869141f,1.00976562f,2.50170898f,-0.82006836f,2.37988281f,0.08764648f,-3.39843750f,2.13085938f,0.36645508f,1.40112305f,1.56518555f,-2.62500000f,2.86425781f,-2.26049805f,-0.06176758f,-1.81494141f,-5.35278320f,-3.15966797f,-2.33398438f,0.93798828f,-0.83618164f,0.94897461f,2.05468750f,1.84741211f,-1.47656250f,2.14331055f,-1.56616211f,-3.04711914f,1.76440430f,2.06396484f,3.61499023f,-0.41479492f,0.65429688f,2.14990234f,-1.67382812f,1.26953125f,-1.62231445f,-3.63232422f,0.35156250f,2.86083984f,-1.48217773f,2.30688477f,3.98071289f,-1.06225586f,-0.14404297f,-1.06079102f,-1.16845703f,3.03710938f,-1.10253906f,-2.73120117f,-0.28857422f,0.31958008f,2.47192383f,0.20410156f,0.47143555f,-2.95800781f,0.86596680f,1.83764648f,3.05541992f,2.59790039f,2.05834961f,-1.52343750f,-0.10327148f,2.53173828f,2.73095703f,-2.02075195f,-1.86059570f,-0.70019531f,-0.27734375f,-2.71850586f,-0.19702148f,-0.13452148f,-0.42578125f,-1.34863281f,1.03051758f,-0.04321289f,-2.35595703f,0.81811523f,-1.86987305f,-0.82836914f,2.93334961f,1.78173828f,-0.97070312f,0.41333008f,-1.56201172f,1.23291016f,-1.26147461f,2.10156250f,0.92041016f,-0.19628906f,-1.30395508f,1.39013672f,0.49438477f,0.34130859f,-3.16577148f,-0.95629883f,1.43676758f,-0.26416016f,-3.11401367f,1.39135742f,1.69067383f,-0.83691406f,3.17480469f,-3.38281250f,4.61572266f,1.59594727f,-0.50097656f,-3.29785156f,-0.81054688f,0.13330078f,2.49487305f,-3.26977539f,1.50170898f,-2.16308594f,-0.68310547f,-1.72021484f,-0.63842773f,-1.35742188f,2.67504883f,0.03222656f,-0.44726562f,1.80273438f,2.63085938f,0.04321289f,-1.25268555f,0.69921875f,0.63134766f,-0.38403320f,-1.01660156f,-2.18017578f,1.69311523f,-0.38476562f,-3.60742188f,1.15966797f,-0.69238281f,-2.38769531f,-0.39135742f,0.66137695f,-1.37890625f,-1.82446289f,-4.62744141f,-0.83740234f,0.00268555f,0.23120117f,0.01586914f,-0.22290039f,1.35620117f,-0.77612305f,2.42846680f,0.01855469f,-5.27343750f,-1.98754883f,4.00366211f,1.32861328f,2.87866211f,-0.71533203f,-0.31176758f,-2.74780273f,2.27954102f,-1.59960938f,1.89135742f,-0.48193359f,1.58203125f,-0.49584961f,0.46459961f,-3.88842773f,-1.97094727f,0.08618164f,2.11303711f,-3.55859375f,1.61645508f,1.05957031f,0.13256836f,-1.86352539f,-3.99218750f,-0.61767578f,-0.22143555f,0.59252930f,2.55834961f,0.75561523f,-1.85400391f,0.60766602f,2.51171875f,0.24536133f,1.12524414f,-0.04565430f,-0.66162109f,-0.81347656f,2.02465820f,-2.61010742f,-1.27832031f,-0.12915039f,-0.77856445f,-1.00122070f,0.64257812f,-1.92260742f,-2.35156250f,1.52880859f,2.04345703f,0.01904297f,-0.32836914f,2.35327148f,-0.30395508f,3.36450195f,-0.60253906f,-2.93115234f,1.71679688f,0.40014648f,-2.46191406f,-0.48315430f,-1.70385742f,1.39794922f,2.22583008f,2.41479492f,1.94067383f,1.77880859f,3.30712891f,3.42187500f,2.20507812f,4.26782227f,1.85668945f,-4.65747070f,2.96655273f,-1.08422852f,1.59887695f,-1.10473633f,1.03540039f,-1.38061523f,1.15136719f,-5.16308594f,-2.49218750f,-0.33740234f,-3.43383789f,-2.59716797f,1.36645508f,3.40795898f,1.05200195f,0.37695312f,-1.60888672f,1.29003906f,-2.63281250f,1.22363281f,1.14843750f,-1.25659180f,2.41235352f,0.96728516f,1.91870117f,1.13696289f,-3.85913086f,-1.42114258f,5.19677734f,0.85693359f,-1.20874023f,-2.01269531f,1.10034180f,-1.58959961f,-2.78369141f,1.33203125f,1.61621094f,-2.91308594f,3.28540039f,-2.09594727f,1.39550781f,0.37280273f,-2.52734375f,1.33789062f,-0.19482422f,1.16210938f,0.57983398f,1.51220703f,0.15844727f,2.05102539f,-3.27954102f,0.46899414f,1.76489258f,-0.64990234f,-0.81542969f,1.05688477f,0.73046875f,-0.92651367f,2.37280273f,3.98706055f,-0.63403320f,-1.38378906f,1.57177734f,0.82568359f,3.59790039f,2.79370117f,1.84936523f,0.26684570f,-2.26611328f,-2.51196289f,1.40454102f,-0.00463867f,-1.31884766f,0.40234375f,-2.27172852f,2.00708008f,2.32299805f,3.02001953f,0.98388672f,-0.78149414f,-2.39770508f,-0.25561523f,0.46215820f,-1.20361328f,-4.52319336f,-0.91015625f,5.02661133f,2.09350586f,-1.99047852f,0.80493164f,0.33178711f,0.14477539f,1.70117188f,2.96289062f,2.12500000f,4.82836914f,0.22851562f,3.43188477f,2.40722656f,2.12890625f,-0.12255859f,-2.83837891f,0.26733398f,0.16259766f,1.25610352f,-1.39404297f,5.63549805f,-0.64624023f,-0.33056641f,2.87500000f,-3.12841797f,-1.93188477f,2.78759766f,-0.22021484f,-3.18652344f,0.59472656f,3.14501953f,0.37011719f,-0.99243164f,0.07128906f,-0.35644531f,2.24169922f,-2.14672852f,0.88964844f,-0.57104492f,0.78100586f,-1.79541016f,2.99023438f,4.16577148f,0.03271484f,0.26440430f,-2.01977539f,1.28076172f,-1.10668945f,3.94970703f,1.19311523f,-1.96093750f,2.10864258f,3.97778320f,-0.20971680f,3.18334961f,2.28051758f,0.44604492f,0.01757812f,0.86621094f,0.60864258f,1.48510742f,-4.74926758f,-1.63305664f,-0.33984375f,-1.47534180f,0.37597656f,0.78833008f,-3.10131836f,-3.93090820f,0.78173828f,0.14770508f,-2.10864258f,3.09472656f,0.10498047f,-2.18725586f,-3.25634766f,0.28247070f,1.71484375f,-2.08227539f,3.57250977f,-1.53125000f,-0.76977539f,-3.99023438f,1.12060547f,1.16528320f,-2.44799805f,-0.97485352f,-1.52563477f,1.01489258f,-0.59301758f,2.95922852f,2.82446289f,-4.68310547f,-0.87329102f,-0.20068359f,-1.80737305f,-1.68847656f,3.29492188f,2.01342773f,0.18676758f,0.68872070f,-0.64697266f,0.42504883f,-1.72290039f,2.98559570f,-0.51635742f,2.02001953f,-0.05395508f,-0.54907227f,1.54003906f,0.76196289f,-0.97094727f,2.69409180f,-2.08178711f,1.27392578f,-0.31811523f,1.64965820f,-0.47973633f,3.98388672f,0.58984375f,-0.12011719f,6.26049805f,1.63891602f,1.03540039f,4.01342773f,0.21655273f,5.84033203f,-1.10180664f,0.33300781f,-1.61865234f,-2.35864258f,2.09448242f,1.57568359f,2.76342773f,1.32885742f,-0.74755859f,-0.53588867f,-2.01123047f,-0.45410156f,-4.15820312f,-2.10864258f,0.57592773f,-0.30541992f,-0.66088867f,-0.06176758f,0.93017578f,0.93579102f,4.53784180f,-1.98217773f,-1.07031250f,-0.73876953f,-0.38110352f,-1.12329102f,0.56445312f,-1.41333008f,-2.57250977f,-0.63598633f,-2.69384766f,-1.16284180f,-1.61938477f,-0.35034180f,4.66577148f,0.34448242f,-3.66992188f,2.59204102f,-2.17675781f,0.45385742f,-0.39843750f,-1.32885742f,1.69799805f,1.26074219f,2.14404297f,1.82080078f,2.29589844f,0.18286133f,1.53857422f,-1.16333008f,0.30517578f,2.07641602f,2.55981445f,4.28955078f,0.56542969f,-1.41870117f,-2.33471680f,0.87744141f,-0.92163086f,-3.08422852f,-5.64135742f,-6.40771484f,1.09252930f,-2.84667969f,-1.03491211f,1.55810547f,1.16235352f,0.34790039f,-2.06933594f,-3.25585938f,1.98217773f,-0.01000977f,2.57006836f,-0.18823242f,3.36547852f,-0.11132812f,-2.12329102f,2.44238281f,-0.81762695f,1.96606445f,-0.84399414f,-4.26318359f,0.71508789f,0.95410156f,0.42431641f,1.88574219f,1.93432617f,-0.08300781f,0.33911133f,0.17016602f,-2.49780273f,-1.31469727f,-4.16601562f,-2.33837891f,-2.47827148f,0.07788086f,1.69824219f,-1.24243164f,0.93041992f,-2.26831055f,1.57641602f,0.54272461f,0.12304688f,2.04296875f,-0.69067383f,-2.58325195f,0.28149414f,-1.90747070f,1.48022461f,-2.68164062f,2.83154297f,-1.14111328f,-4.15673828f,1.55834961f,-0.43457031f,1.62304688f,-1.76928711f,-3.05346680f,-0.15429688f,-0.00488281f,0.78198242f,-6.09228516f,3.03247070f,2.37182617f,-0.72973633f,-2.26831055f,-2.47143555f,-2.76049805f,0.48168945f,-1.28833008f,1.31567383f,0.51953125f,-1.18579102f,0.52294922f,-2.87109375f,-1.83666992f,2.06372070f,3.21899414f,-0.76611328f,0.06030273f,2.72973633f,-1.85546875f,-0.30224609f,-1.99658203f,0.19799805f,-3.76342773f,2.88378906f,0.88037109f,-3.01806641f,2.43652344f,0.32543945f,0.85668945f,1.91918945f,-4.09155273f,-2.23339844f,-0.07885742f,0.18212891f,0.08984375f,-2.59057617f,2.66479492f,1.30908203f,2.32031250f,0.21386719f,-0.03564453f,1.51660156f,0.81250000f,0.83544922f,0.73364258f,-1.48657227f,2.67138672f,0.24926758f,0.59667969f,-3.11401367f,4.15991211f,1.78442383f,1.86425781f,0.18969727f,2.13842773f,-0.19799805f,-1.67578125f,-1.52685547f,-1.49731445f,2.31127930f,1.58715820f,3.38330078f,1.62255859f,0.68725586f,-0.69628906f,-1.12060547f,-2.63061523f,-2.55834961f,0.68969727f,-0.18823242f,-0.73193359f,-1.76733398f,-0.46362305f,-0.84960938f,2.53735352f,-0.37060547f,1.12426758f,-2.55737305f,-2.44091797f,-0.07324219f,1.63354492f,1.94531250f,1.82177734f,-3.75122070f,-0.23779297f,-3.59448242f,2.55273438f,1.58422852f,3.20166016f,-0.47607422f,-1.86450195f,-0.54150391f,1.96069336f,-1.08715820f,-2.79101562f,-1.15454102f,-1.28442383f,-1.19287109f,-3.58642578f,-7.10400391f,1.76489258f,0.02954102f,-0.16210938f,-0.40087891f,0.12402344f,2.97119141f,-0.23852539f,-3.27221680f,0.30810547f,-0.72290039f,2.32958984f,-2.49047852f,-0.13745117f,-0.00195312f,2.40893555f,-1.54052734f,1.18750000f,0.29223633f,-1.87719727f,-0.42724609f,-2.50439453f,0.04565430f,0.87084961f,-6.87353516f,-4.80322266f,1.31494141f,0.18627930f,1.73095703f,1.48095703f,-0.52880859f,-0.99243164f,0.55615234f,0.46020508f,-0.25415039f,0.84790039f,2.19848633f,0.82690430f,-0.33447266f,2.45605469f,-0.20727539f,1.48266602f,1.88574219f,1.97534180f,-0.31396484f,-3.11035156f,1.85302734f,1.54467773f,0.85571289f,0.97412109f,1.64648438f,0.25903320f,-1.04150391f,1.93603516f,-1.55322266f,-0.10913086f,1.66625977f,-1.13330078f,0.67309570f,-0.47265625f,-3.56567383f,-2.44873047f,-0.61889648f,-3.73486328f,1.05053711f,-1.60888672f,-1.08081055f,1.05419922f,0.89501953f,-1.73730469f,2.25683594f,2.68115234f,-0.53833008f,-0.47827148f,-0.22265625f,-1.07885742f,1.87402344f,-2.33984375f,0.83154297f,4.53833008f,-1.00439453f,-0.29663086f,1.53955078f,-0.41625977f,-1.09716797f,-0.20434570f,-2.38183594f,-0.49365234f,3.69653320f,0.77539062f,-0.12646484f,1.76879883f,0.74853516f,-0.01196289f,-1.85327148f,0.06030273f,1.01171875f,-3.08984375f,-3.24731445f,-0.80590820f,-0.28125000f,-3.01953125f,-3.35546875f,-2.76806641f,-1.16015625f,-1.39819336f,-1.32983398f,4.34887695f,1.17504883f,-0.07788086f,-1.48461914f,1.32250977f,3.36035156f,0.16625977f,1.44873047f,0.90795898f,-0.92480469f,-2.11401367f,-0.43066406f,-2.59082031f,0.46142578f,-0.23315430f,1.51147461f,-1.36791992f,-0.32055664f,-2.34521484f,1.12304688f,1.33984375f,-0.42285156f,0.11767578f,-0.86572266f,0.75341797f,-0.46679688f,-0.77734375f,-0.97241211f,1.25244141f,-2.77343750f,0.69287109f,1.08789062f,-0.88989258f,-0.80395508f,0.53100586f,0.30029297f,-0.65332031f,0.79345703f,1.78735352f,0.41284180f,3.02587891f,-0.46508789f,0.77929688f,3.24633789f,-0.08544922f,0.47729492f,0.92871094f,1.24975586f,1.28076172f,1.67358398f,1.75952148f,0.61889648f,-1.25537109f,5.43603516f,1.86718750f,0.02343750f,-0.12036133f,1.20947266f,-3.58764648f,-0.07641602f,-0.77148438f,-3.13793945f,-0.04321289f,3.34790039f,0.85009766f,1.83764648f,-4.40356445f,0.48364258f,2.20410156f,0.67163086f,-0.95117188f,-1.58911133f,1.16943359f,2.14355469f,0.63574219f,-3.05615234f,2.26708984f,-0.00830078f,-1.70068359f,0.56347656f,2.99707031f,0.23706055f,2.20703125f,0.63134766f,0.26147461f,0.51611328f,-0.20776367f,-0.96069336f,-0.54028320f,-1.04956055f,-0.59594727f,0.90283203f,1.09472656f,2.68554688f,-2.22558594f,3.61621094f,-1.38476562f,0.66137695f,2.52197266f,2.40747070f,0.30078125f,-0.17236328f,-1.02514648f,-0.51074219f,3.14599609f,-4.19067383f,-1.28613281f,0.14453125f,1.96875000f,-1.47900391f,-2.45385742f,-0.11401367f,-1.62866211f,0.11767578f,2.24951172f,0.94262695f,1.45849609f,0.37768555f,2.91723633f,1.00415039f,0.76416016f,-0.98876953f,0.36523438f,2.23461914f,-1.90161133f,0.63867188f,1.73559570f,4.13696289f,2.41992188f,2.65063477f,-1.00610352f,-0.68798828f,-3.18627930f,-1.32128906f,-1.21264648f,-0.80786133f,3.21923828f,3.60253906f,0.86401367f,1.31176758f,2.04833984f,-0.20507812f,-3.44287109f,-0.57958984f,-1.63745117f,-0.74096680f,3.26000977f,-2.01220703f,0.89038086f,-2.69165039f,-3.99145508f,0.42236328f,-0.24804688f,-4.68676758f,-0.37548828f,0.93017578f,1.36596680f,2.53588867f,1.95751953f,-1.35986328f,-1.51147461f,1.34521484f,-1.15332031f,2.56665039f,4.04956055f,-3.03613281f,0.43286133f,-1.03540039f,1.37304688f,0.13647461f,2.08691406f,2.21215820f,1.43725586f,-1.48486328f,-1.48510742f,-1.25097656f,-0.40795898f,-1.79809570f,1.34497070f,1.55224609f,0.97900391f,-0.34228516f,0.83447266f,0.83056641f,-1.44262695f,-0.48461914f,-0.16943359f,-0.86669922f,0.08813477f,1.16601562f,-0.19213867f,-1.79052734f,-0.48901367f,-0.94091797f,-4.82885742f,2.06982422f,-1.02734375f,-0.82348633f,-0.19018555f,-0.89550781f,-0.08764648f,-1.49609375f,0.86206055f,-1.28686523f,1.89550781f,2.04101562f,-0.08349609f,-0.27343750f,-0.78857422f,5.04931641f,-0.53027344f,-2.84130859f,-0.62109375f,-0.45166016f,-2.11474609f,-1.52124023f,1.31079102f,0.43139648f,2.98852539f,-1.23608398f,3.13574219f,3.04541016f,-1.87280273f,-1.97216797f,-3.80957031f,-3.78613281f,0.64477539f,2.50561523f,0.62304688f,-0.92944336f,-0.29077148f,0.03051758f,-3.08105469f,0.54956055f,-0.23876953f,-3.95263672f,0.22973633f,-1.46069336f,-3.07226562f,-0.60864258f,-1.51660156f,2.25366211f,-2.83349609f,-1.04223633f,-0.11499023f,-3.04760742f,-0.03149414f,-1.38549805f,2.51977539f,1.36889648f,-1.94775391f,-2.36108398f,-0.43896484f,0.37231445f,-1.39770508f,0.48486328f,2.53393555f,-2.18334961f,-2.42333984f,-0.74780273f,-1.39404297f,-1.69702148f,-0.77124023f,0.37646484f,-4.06372070f,-0.69970703f,0.73828125f,2.30737305f,-0.58422852f,3.04174805f,-1.42626953f,-1.23754883f,0.48461914f,-2.00122070f,-1.28881836f,-1.24243164f,-0.99609375f,-0.25097656f,2.50390625f,1.87963867f,0.48950195f,-1.68750000f,0.42944336f,-1.81005859f,-3.60302734f,1.33203125f,-3.76464844f,-2.62231445f,-1.89257812f,-0.20947266f,2.44189453f,-2.00439453f,1.60327148f,0.85302734f,0.50024414f,0.91088867f,0.71972656f,-0.51904297f,-1.15966797f,-0.55029297f,0.29418945f,-0.04492188f,-0.37475586f,0.61596680f,0.24072266f,0.88256836f,-1.09936523f,-3.29516602f,-0.60986328f,-3.45532227f,1.76660156f,-1.80737305f,-1.12304688f,0.34155273f,-2.75341797f,2.27294922f,-4.85595703f,-1.56616211f,-0.72167969f,1.20825195f,1.82739258f,-4.74096680f,1.81738281f,0.93652344f,-1.86962891f,-1.47802734f,-0.13183594f,0.76074219f,-2.70410156f,-1.69238281f,2.14819336f,2.32104492f,-2.10302734f,-2.49658203f,1.56860352f,0.01879883f,1.72827148f,1.73315430f,-0.49804688f,0.40087891f,-0.81274414f,-0.11718750f,0.60449219f,-1.40942383f,-2.11059570f,2.28637695f,0.30468750f,-1.43261719f,4.24096680f,2.21948242f,-2.07055664f,4.47778320f,2.29223633f,2.11718750f,-1.72705078f,1.71142578f,-0.92651367f,-1.03002930f,-2.06005859f,2.90722656f,2.42895508f,-1.48950195f,-0.45068359f,-2.13989258f,1.79345703f,1.24096680f,-4.74365234f,-1.59863281f,-0.94604492f,5.05712891f,-1.96093750f,0.32373047f,-0.61425781f,0.77954102f,-1.94067383f,0.88964844f,2.37304688f,-1.02832031f,-0.21093750f,0.57592773f,-0.21655273f,-0.35620117f,-2.47680664f,-5.14111328f,-4.67871094f,2.59912109f,2.00170898f,3.86425781f,-1.58959961f,-1.86376953f,-2.26269531f,-0.80761719f,-0.49877930f,0.88330078f,-1.54541016f,-3.49975586f,-0.73999023f,-0.08325195f,1.15307617f,3.41625977f,3.72680664f,1.24121094f,1.03466797f,-4.12036133f,-0.14941406f,-0.95361328f,-0.60522461f,-0.27758789f,-0.89746094f,-1.86035156f,-2.14575195f,0.94995117f,-3.38964844f,-2.29882812f,1.89282227f,-1.99804688f,-2.88867188f,-3.31372070f,-1.88159180f,-1.51831055f,-1.05322266f,1.28027344f,-0.54907227f,1.69140625f,-0.37060547f,-3.99951172f,-2.17016602f,2.24389648f,0.89331055f,2.73852539f,-0.30541992f,3.01635742f,1.91064453f,-1.04052734f,3.63232422f,3.29418945f,-3.25659180f,-0.15844727f,1.83056641f,2.87573242f,1.92553711f,2.67944336f,2.36645508f,1.13793945f,2.62011719f,1.28857422f,-3.87011719f,-0.62329102f,0.33349609f,1.57446289f,-0.96362305f,2.57104492f,-0.54296875f,-0.28710938f,1.08349609f,1.60229492f,-0.29418945f,-3.09204102f,-1.59130859f,0.93872070f,-0.57519531f,-2.82275391f,3.35522461f,1.51440430f,-1.48730469f,-0.30053711f,0.92846680f,-4.23950195f,1.87426758f,-1.35888672f,0.60034180f,-1.23535156f,-0.60644531f,-0.98486328f,-3.92187500f,2.31372070f,-0.16650391f,-0.38232422f,-1.68579102f,2.87524414f,1.39428711f,-0.76586914f,0.98413086f,1.54711914f,2.20385742f,2.18261719f,1.31640625f,2.58422852f,-0.96801758f,-0.35986328f,-1.47436523f,-1.84667969f,0.63525391f,-1.03027344f,1.05126953f,-2.15332031f,-2.66552734f,-0.97875977f,-1.66674805f,-0.80346680f,3.13867188f,-2.06762695f,-3.39184570f,1.25122070f,-1.67773438f,-3.24145508f,0.12377930f,2.07080078f,0.46752930f,2.17260742f,-1.26538086f,1.48901367f,2.80371094f,-0.35131836f,1.11254883f,2.58569336f,0.62597656f,1.30859375f,-0.37792969f,-0.94140625f,0.47119141f,2.19653320f,1.80371094f,0.95166016f,-1.34619141f,-0.04150391f,1.21142578f,0.57373047f,3.38354492f,0.59204102f,0.99951172f,-2.53808594f,0.48071289f,-1.61425781f,1.52929688f,2.07495117f,-3.39160156f,-0.10913086f,-1.03979492f,-2.98071289f,-1.51049805f,1.84301758f,2.39697266f,-0.13330078f,-0.75170898f,-1.43359375f,-6.43896484f,0.32153320f,-0.61230469f,2.91357422f,-4.68969727f,-1.61645508f,0.52465820f,-0.21435547f,-0.59130859f,0.22534180f,0.87817383f,-2.49609375f,0.31713867f,-0.92431641f,-2.39770508f,2.04516602f,2.99462891f,-0.50585938f,2.95678711f,2.95703125f,-0.54296875f,-2.82934570f,-1.63964844f,-2.39306641f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    // EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_4items_padded_neg)
{
    Shape shape_a{4,3,3,5,8,7};
    Shape shape_b{4,3,2,2,3,1};
    Shape shape_r{4,4,2,6,3,6};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1,1,1},        // move_strides
                                                                  Strides{1,1,1,1},        // filter_dilation
                                                                  CoordinateDiff{-1,2,-3,2}, // below_pads
                                                                  CoordinateDiff{1,0,0,-3}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f,-0.60937500f,-0.15625000f,0.20312500f,-0.37500000f,-0.75000000f,-0.17187500f,-0.67187500f,-0.75000000f,0.31250000f,-0.26562500f,-0.78125000f,-0.87500000f,-0.28125000f,-0.92187500f,0.96875000f,0.43750000f,-0.32812500f,-0.23437500f,0.04687500f,-0.90625000f,-0.14062500f,-0.89062500f,0.18750000f,-0.46875000f,-0.18750000f,-0.53125000f,0.43750000f,-0.73437500f,-0.98437500f,0.82812500f,0.15625000f,-0.51562500f,-0.46875000f,-0.53125000f,-0.07812500f,-0.23437500f,0.04687500f,-0.64062500f,0.18750000f,0.90625000f,-0.12500000f,-0.18750000f,0.93750000f,-0.98437500f,0.07812500f,-0.43750000f,0.51562500f,1.00000000f,-0.43750000f,0.31250000f,-0.98437500f,-0.34375000f,0.87500000f,-0.62500000f,1.00000000f,0.73437500f,-0.37500000f,0.85937500f,-0.70312500f,0.82812500f,0.18750000f,0.23437500f,0.07812500f,-0.67187500f,-0.93750000f,0.32812500f,0.89062500f,0.06250000f,-0.79687500f,-0.18750000f,0.65625000f,-0.92187500f,0.07812500f,-0.84375000f,0.15625000f,-0.32812500f,-0.43750000f,0.87500000f,0.87500000f,-0.70312500f,0.82812500f,-0.67187500f,-0.75000000f,-0.01562500f,-0.79687500f,0.15625000f,-0.21875000f,-0.31250000f,-0.48437500f,0.48437500f,-0.85937500f,-0.18750000f,-0.20312500f,0.45312500f,-0.87500000f,0.28125000f,0.81250000f,-0.56250000f,-0.12500000f,-0.06250000f,0.03125000f,-0.82812500f,0.56250000f,0.01562500f,-0.59375000f,-0.76562500f,0.70312500f,-1.00000000f,-0.87500000f,-0.68750000f,-0.64062500f,0.93750000f,-0.50000000f,0.73437500f,0.92187500f,-0.95312500f,-0.45312500f,-0.06250000f,-0.06250000f,-0.60937500f,-0.01562500f,-0.17187500f,0.34375000f,-0.95312500f,-0.01562500f,-0.85937500f,-0.85937500f,0.42187500f,-0.57812500f,-0.67187500f,0.35937500f,-0.06250000f,0.78125000f,-0.26562500f,-0.10937500f,0.92187500f,0.17187500f,0.46875000f,0.56250000f,0.20312500f,-0.42187500f,0.00000000f,0.12500000f,-0.92187500f,-0.14062500f,0.48437500f,-0.60937500f,0.50000000f,0.87500000f,0.25000000f,-0.59375000f,-0.04687500f,0.29687500f,0.31250000f,0.45312500f,-0.96875000f,-0.70312500f,0.87500000f,0.62500000f,-0.34375000f,-0.90625000f,0.07812500f,0.51562500f,0.35937500f,0.40625000f,-0.62500000f,0.48437500f,-0.50000000f,-0.23437500f,0.68750000f,-0.23437500f,-0.85937500f,0.95312500f,0.51562500f,-0.15625000f,0.35937500f,0.50000000f,0.73437500f,0.71875000f,-0.62500000f,0.45312500f,0.40625000f,-0.18750000f,-0.85937500f,0.42187500f,-0.67187500f,0.62500000f,-0.60937500f,-0.54687500f,0.21875000f,0.50000000f,0.65625000f,0.32812500f,0.87500000f,-0.01562500f,0.40625000f,0.17187500f,0.93750000f,-0.95312500f,-0.20312500f,-0.73437500f,0.40625000f,-0.20312500f,0.20312500f,-0.04687500f,-0.65625000f,0.64062500f,0.65625000f,-0.71875000f,0.31250000f,-0.35937500f,-0.28125000f,0.15625000f,1.00000000f,1.00000000f,0.43750000f,-0.20312500f,-0.53125000f,0.92187500f,0.90625000f,0.07812500f,0.50000000f,0.43750000f,-0.57812500f,0.84375000f,-0.67187500f,0.09375000f,-0.17187500f,-0.64062500f,0.14062500f,-0.67187500f,1.00000000f,-0.48437500f,-0.37500000f,0.00000000f,0.21875000f,0.96875000f,0.06250000f,-0.81250000f,0.78125000f,0.87500000f,0.67187500f,0.45312500f,-0.96875000f,-0.29687500f,-0.60937500f,0.70312500f,0.56250000f,0.59375000f,0.87500000f,0.95312500f,0.03125000f,-0.64062500f,-0.62500000f,-0.43750000f,0.51562500f,-0.17187500f,-0.06250000f,0.03125000f,-0.48437500f,-0.95312500f,-0.31250000f,-0.40625000f,-0.89062500f,-0.64062500f,0.23437500f,0.87500000f,0.48437500f,0.54687500f,0.82812500f,0.70312500f,-0.68750000f,0.87500000f,0.93750000f,0.92187500f,-0.03125000f,0.65625000f,0.04687500f,-0.25000000f,0.10937500f,-0.57812500f,-0.21875000f,0.25000000f,-0.15625000f,0.89062500f,0.35937500f,0.96875000f,-0.31250000f,-0.04687500f,-0.04687500f,0.46875000f,-0.51562500f,-0.25000000f,0.67187500f,-0.70312500f,0.28125000f,-0.48437500f,0.71875000f,-0.43750000f,-0.28125000f,-0.81250000f,0.70312500f,0.95312500f,0.31250000f,-0.31250000f,-0.29687500f,0.20312500f,-0.95312500f,0.64062500f,-0.87500000f,-0.42187500f,0.90625000f,-0.65625000f,-0.85937500f,-0.84375000f,0.50000000f,0.17187500f,-0.37500000f,-1.00000000f,-0.89062500f,-0.68750000f,0.53125000f,0.95312500f,0.17187500f,-0.70312500f,0.46875000f,0.53125000f,-0.31250000f,0.67187500f,0.89062500f,0.32812500f,-0.53125000f,-0.57812500f,0.54687500f,-0.98437500f,0.23437500f,0.01562500f,0.65625000f,-0.43750000f,-0.54687500f,0.93750000f,-0.71875000f,-0.84375000f,0.18750000f,0.59375000f,-0.95312500f,-0.50000000f,0.93750000f,-0.07812500f,-0.68750000f,0.85937500f,-0.35937500f,-0.26562500f,-0.79687500f,-0.95312500f,-0.90625000f,-0.50000000f,0.56250000f,0.85937500f,0.50000000f,-0.04687500f,0.35937500f,-0.78125000f,0.50000000f,-0.93750000f,-0.40625000f,-0.70312500f,0.15625000f,-0.07812500f,0.40625000f,0.70312500f,0.46875000f,-0.71875000f,-0.03125000f,-0.87500000f,-0.84375000f,-0.34375000f,0.00000000f,0.17187500f,-0.93750000f,0.62500000f,-0.76562500f,-0.26562500f,0.98437500f,0.40625000f,1.00000000f,-0.90625000f,-0.23437500f,0.50000000f,0.53125000f,-0.90625000f,-0.62500000f,0.96875000f,-0.59375000f,-0.10937500f,0.89062500f,-1.00000000f,0.70312500f,0.98437500f,0.15625000f,-0.26562500f,0.50000000f,0.56250000f,-0.26562500f,0.10937500f,0.78125000f,0.70312500f,0.20312500f,-0.84375000f,0.50000000f,0.96875000f,0.57812500f,-0.18750000f,0.03125000f,0.68750000f,-0.64062500f,-0.29687500f,-0.62500000f,0.32812500f,-0.90625000f,-0.39062500f,0.17187500f,0.73437500f,-0.65625000f,-0.10937500f,0.76562500f,0.59375000f,0.65625000f,-0.43750000f,0.39062500f,-0.18750000f,0.09375000f,0.07812500f,0.35937500f,0.15625000f,0.18750000f,-0.35937500f,0.78125000f,-0.45312500f,-0.87500000f,-0.50000000f,-0.60937500f,0.37500000f,-0.64062500f,0.32812500f,0.81250000f,-0.96875000f,-0.92187500f,-0.73437500f,0.07812500f,0.00000000f,-0.56250000f,-0.20312500f,0.32812500f,0.78125000f,0.78125000f,-0.32812500f,0.68750000f,-0.23437500f,-0.57812500f,-0.76562500f,-0.35937500f,-0.53125000f,0.04687500f,-0.45312500f,-0.04687500f,0.00000000f,0.48437500f,-0.59375000f,0.37500000f,0.81250000f,0.95312500f,-0.48437500f,0.20312500f,0.01562500f,-0.62500000f,-0.75000000f,-0.64062500f,0.65625000f,-0.50000000f,-0.18750000f,-0.84375000f,-0.14062500f,0.51562500f,0.03125000f,-0.50000000f,0.51562500f,-0.98437500f,0.93750000f,0.78125000f,-0.96875000f,-0.57812500f,0.31250000f,0.10937500f,0.92187500f,-0.92187500f,0.25000000f,-0.31250000f,-0.15625000f,0.09375000f,0.43750000f,-0.76562500f,-0.14062500f,-0.68750000f,-0.14062500f,-0.03125000f,0.90625000f,-0.71875000f,-0.56250000f,0.64062500f,0.76562500f,0.60937500f,0.81250000f,-0.48437500f,0.46875000f,0.65625000f,-0.29687500f,0.48437500f,-0.43750000f,0.82812500f,-0.26562500f,0.64062500f,-0.01562500f,0.35937500f,-0.29687500f,-0.84375000f,-0.92187500f,-0.84375000f,0.73437500f,0.09375000f,-0.53125000f,-0.15625000f,0.12500000f,0.84375000f,-0.78125000f,-0.51562500f,0.42187500f,0.25000000f,0.37500000f,0.18750000f,0.18750000f,0.67187500f,0.96875000f,0.62500000f,0.23437500f,0.57812500f,0.10937500f,-0.31250000f,-0.78125000f,0.79687500f,0.29687500f,0.96875000f,-0.70312500f,-0.96875000f,-0.75000000f,-0.01562500f,-0.37500000f,0.03125000f,0.10937500f,0.95312500f,-0.59375000f,0.78125000f,-0.20312500f,-0.15625000f,0.15625000f,-0.82812500f,0.60937500f,0.26562500f,0.32812500f,-0.90625000f,0.21875000f,-0.37500000f,0.37500000f,0.03125000f,-0.37500000f,-0.81250000f,0.81250000f,-0.89062500f,-0.75000000f,-0.96875000f,0.76562500f,0.43750000f,0.35937500f,-0.89062500f,0.75000000f,-0.04687500f,-1.00000000f,0.98437500f,0.70312500f,-0.85937500f,-0.17187500f,0.46875000f,0.56250000f,-0.25000000f,0.60937500f,-0.92187500f,-0.57812500f,0.89062500f,-0.29687500f,0.84375000f,-0.09375000f,0.28125000f,-0.06250000f,0.87500000f,0.12500000f,-0.25000000f,-0.96875000f,0.10937500f,-0.53125000f,0.89062500f,-0.62500000f,-0.57812500f,0.18750000f,0.07812500f,0.28125000f,-0.06250000f,0.34375000f,-0.46875000f,-0.35937500f,0.50000000f,-0.07812500f,1.00000000f,1.00000000f,0.45312500f,-0.82812500f,-0.59375000f,-0.90625000f,0.06250000f,-0.93750000f,0.85937500f,0.43750000f,0.89062500f,0.32812500f,-0.92187500f,0.87500000f,-0.62500000f,-0.62500000f,-0.25000000f,-0.70312500f,0.87500000f,0.57812500f,0.93750000f,0.84375000f,-0.48437500f,-0.40625000f,-0.90625000f,-0.48437500f,0.95312500f,-0.57812500f,0.40625000f,-0.90625000f,0.26562500f,-0.76562500f,-0.51562500f,0.85937500f,0.84375000f,0.45312500f,-0.76562500f,-0.12500000f,-0.03125000f,-1.00000000f,-0.65625000f,0.17187500f,0.12500000f,0.40625000f,1.00000000f,0.17187500f,-0.37500000f,0.48437500f,0.06250000f,-0.68750000f,-0.84375000f,0.35937500f,-0.14062500f,-0.12500000f,0.60937500f,-0.51562500f,1.00000000f,-0.25000000f,-0.81250000f,0.29687500f,-0.54687500f,0.35937500f,-0.60937500f,-0.98437500f,-0.12500000f,-0.31250000f,0.64062500f,-0.03125000f,0.46875000f,0.37500000f,0.53125000f,0.09375000f,-0.09375000f,0.60937500f,-0.56250000f,0.18750000f,-0.76562500f,0.00000000f,-0.15625000f,0.79687500f,0.53125000f,-0.46875000f,1.00000000f,-0.78125000f,0.39062500f,0.45312500f,0.35937500f,0.15625000f,-0.20312500f,-0.07812500f,-0.96875000f,0.71875000f,0.90625000f,-0.35937500f,-0.32812500f,0.79687500f,-0.57812500f,0.01562500f,-0.92187500f,0.46875000f,-0.15625000f,-0.53125000f,-0.56250000f,-0.42187500f,-0.26562500f,0.51562500f,-0.65625000f,0.60937500f,0.35937500f,-0.28125000f,-0.76562500f,0.12500000f,0.73437500f,0.25000000f,0.71875000f,-0.57812500f,-0.54687500f,-0.01562500f,0.89062500f,-0.85937500f,0.20312500f,-0.64062500f,-0.95312500f,0.35937500f,-0.82812500f,-0.75000000f,0.92187500f,-0.65625000f,-0.09375000f,-0.37500000f,0.78125000f,-0.81250000f,0.60937500f,0.76562500f,-0.48437500f,-0.32812500f,-0.75000000f,0.59375000f,-0.21875000f,0.98437500f,-0.45312500f,-0.35937500f,-0.48437500f,0.14062500f,-0.12500000f,-0.12500000f,0.48437500f,0.14062500f,0.21875000f,0.42187500f,1.00000000f,-0.95312500f,-0.28125000f,-0.54687500f,-1.00000000f,0.92187500f,0.35937500f,0.76562500f,0.79687500f,-0.71875000f,-0.46875000f,-0.32812500f,-0.17187500f,-0.46875000f,0.64062500f,-0.92187500f,-0.70312500f,-0.48437500f,-0.96875000f,0.76562500f,0.73437500f,0.28125000f,0.31250000f,-0.57812500f,-0.45312500f,-0.46875000f,-0.14062500f,-0.10937500f,0.48437500f,-0.39062500f,-0.21875000f,-0.04687500f,0.53125000f,-0.51562500f,-0.37500000f,-0.18750000f,0.53125000f,0.92187500f,-0.84375000f,-0.45312500f,0.34375000f,0.48437500f,-0.71875000f,0.46875000f,-0.04687500f,-0.96875000f,-0.56250000f,0.48437500f,-0.79687500f,-0.57812500f,0.64062500f,-0.50000000f,-0.64062500f,-0.64062500f,-0.92187500f,-0.82812500f,0.10937500f,-0.98437500f,0.90625000f,0.28125000f,-0.81250000f,-0.35937500f,0.50000000f,-0.73437500f,-0.62500000f,-0.76562500f,-0.71875000f,-0.17187500f,-0.21875000f,-0.51562500f,-0.73437500f,0.64062500f,0.90625000f,0.79687500f,0.96875000f,0.71875000f,0.23437500f,0.03125000f,0.98437500f,0.25000000f,0.62500000f,0.54687500f,0.20312500f,-0.87500000f,-0.25000000f,-0.82812500f,0.68750000f,-0.29687500f,0.12500000f,0.14062500f,0.14062500f,0.65625000f,-0.35937500f,0.84375000f,-0.78125000f,-0.64062500f,0.70312500f,-0.87500000f,-0.31250000f,-0.43750000f,0.15625000f,-0.07812500f,-0.96875000f,0.39062500f,-0.95312500f,0.17187500f,0.14062500f,0.32812500f,-0.81250000f,-0.25000000f,0.71875000f,0.82812500f,0.50000000f,-0.17187500f,0.17187500f,-0.15625000f,0.57812500f,0.18750000f,0.84375000f,0.48437500f,0.75000000f,0.85937500f,-0.20312500f,-0.71875000f,-0.37500000f,0.29687500f,0.90625000f,0.06250000f,-0.59375000f,-0.15625000f,0.70312500f,-0.23437500f,0.73437500f,0.03125000f,-0.37500000f,0.89062500f,0.20312500f,-0.89062500f,0.18750000f,0.82812500f,0.46875000f,0.85937500f,0.81250000f,-0.23437500f,0.76562500f,0.48437500f,0.87500000f,0.12500000f,-0.39062500f,0.29687500f,-0.14062500f,-0.07812500f,0.53125000f,0.17187500f,0.45312500f,0.82812500f,-0.45312500f,-0.68750000f,0.87500000f,-0.43750000f,0.15625000f,0.43750000f,0.65625000f,-0.26562500f,0.18750000f,0.79687500f,0.45312500f,-0.57812500f,0.62500000f,0.76562500f,0.45312500f,0.96875000f,0.65625000f,-0.82812500f,-0.28125000f,-0.31250000f,0.93750000f,0.17187500f,0.92187500f,0.07812500f,0.12500000f,0.56250000f,-0.39062500f,-0.40625000f,-0.32812500f,0.40625000f,-0.71875000f,-0.23437500f,0.17187500f,0.40625000f,0.59375000f,0.59375000f,-0.75000000f,-0.10937500f,-0.21875000f,-0.46875000f,-0.17187500f,0.56250000f,-0.32812500f,-0.01562500f,0.31250000f,-0.40625000f,0.01562500f,0.23437500f,0.51562500f,0.25000000f,0.09375000f,0.12500000f,0.79687500f,-0.65625000f,-0.40625000f,0.57812500f,-0.23437500f,0.34375000f,0.96875000f,-0.34375000f,-0.85937500f,-0.28125000f,-0.76562500f,-0.04687500f,0.84375000f,0.82812500f,-0.59375000f,-0.20312500f,-0.48437500f,0.32812500f,-0.54687500f,-0.46875000f,0.29687500f,0.64062500f,0.39062500f,0.14062500f,0.17187500f,-0.87500000f,0.43750000f,-0.82812500f,-0.43750000f,0.84375000f,0.01562500f,0.54687500f,-0.92187500f,-0.01562500f,-0.35937500f,-0.93750000f,-0.98437500f,0.60937500f,-0.43750000f,-0.87500000f,0.85937500f,-0.60937500f,0.40625000f,-0.10937500f,0.23437500f,0.32812500f,-0.92187500f,-0.57812500f,-0.45312500f,-0.73437500f,0.18750000f,-0.96875000f,-0.56250000f,0.12500000f,0.06250000f,-0.03125000f,-0.32812500f,0.32812500f,-0.67187500f,0.29687500f,-0.67187500f,0.42187500f,0.09375000f,-0.15625000f,-0.95312500f,0.79687500f,-0.32812500f,0.46875000f,-0.90625000f,0.32812500f,-0.92187500f,-0.21875000f,0.65625000f,-0.68750000f,-0.75000000f,-0.67187500f,-0.04687500f,-0.04687500f,0.43750000f,0.90625000f,0.23437500f,0.59375000f,0.62500000f,0.68750000f,-0.48437500f,0.95312500f,-0.51562500f,0.00000000f,0.31250000f,0.65625000f,-0.84375000f,-0.14062500f,-0.90625000f,0.29687500f,0.96875000f,-0.53125000f,0.06250000f,-0.28125000f,-0.26562500f,-0.96875000f,0.25000000f,0.96875000f,-0.23437500f,0.70312500f,0.96875000f,0.01562500f,0.59375000f,0.95312500f,-0.03125000f,-0.34375000f,0.96875000f,-0.56250000f,-0.57812500f,0.06250000f,0.65625000f,0.40625000f,-0.48437500f,-0.40625000f,-0.59375000f,-0.34375000f,-0.73437500f,-0.46875000f,-0.54687500f,0.29687500f,-0.31250000f,-0.23437500f,-0.62500000f,-0.54687500f,-0.60937500f,0.03125000f,0.40625000f,0.92187500f,-0.15625000f,0.43750000f,-0.59375000f,0.01562500f,-0.32812500f,0.93750000f,-0.96875000f,-0.79687500f,-0.76562500f,-0.85937500f,-1.00000000f,0.04687500f,0.29687500f,0.09375000f,0.79687500f,-0.93750000f,0.62500000f,0.06250000f,0.25000000f,-0.60937500f,0.50000000f,-0.31250000f,0.31250000f,-0.07812500f,0.93750000f,0.48437500f,-0.37500000f,-0.67187500f,0.06250000f,0.06250000f,0.67187500f,0.70312500f,0.20312500f,0.68750000f,-0.21875000f,0.03125000f,0.68750000f,-0.79687500f,-0.03125000f,0.21875000f,0.25000000f,0.20312500f,-0.92187500f,0.71875000f,0.37500000f,-0.96875000f,0.10937500f,0.39062500f,-0.67187500f,0.01562500f,-0.43750000f,0.93750000f,0.87500000f,0.56250000f,-0.60937500f,0.68750000f,0.12500000f,-0.12500000f,-0.51562500f,-0.56250000f,-0.18750000f,-0.04687500f,-0.29687500f,0.45312500f,-0.09375000f,-0.64062500f,0.93750000f,-0.59375000f,-0.37500000f,0.62500000f,0.09375000f,-0.60937500f,-0.76562500f,-0.71875000f,0.01562500f,0.59375000f,-0.54687500f,0.82812500f,0.15625000f,0.84375000f,-0.37500000f,-0.54687500f,-0.39062500f,-0.54687500f,-0.42187500f,0.14062500f,-0.79687500f,0.85937500f,-0.68750000f,-0.51562500f,-0.64062500f,-0.70312500f,-0.56250000f,-0.75000000f,0.85937500f,-0.81250000f,-0.84375000f,0.12500000f,0.23437500f,0.79687500f,-0.21875000f,-0.93750000f,0.46875000f,0.75000000f,0.43750000f,-0.53125000f,0.15625000f,0.37500000f,0.50000000f,0.51562500f,0.76562500f,-0.14062500f,0.45312500f,-0.87500000f,-0.71875000f,-0.40625000f,-0.92187500f,0.50000000f,-0.68750000f,-0.71875000f,-0.43750000f,0.79687500f,-0.01562500f,-0.95312500f,-0.31250000f,-0.51562500f,-0.28125000f,0.56250000f,-0.51562500f,0.59375000f,0.65625000f,0.21875000f,-0.56250000f,0.28125000f,0.01562500f,-0.56250000f,-0.59375000f,0.12500000f,-0.75000000f,0.03125000f,-0.53125000f,-0.50000000f,0.00000000f,0.04687500f,0.01562500f,-0.43750000f,-0.48437500f,-0.79687500f,0.50000000f,0.65625000f,-0.04687500f,-0.96875000f,-0.56250000f,-0.29687500f,0.18750000f,-0.01562500f,0.15625000f,0.10937500f,-0.62500000f,-0.18750000f,-0.93750000f,0.28125000f,0.32812500f,-0.12500000f,0.76562500f,0.31250000f,-0.59375000f,0.51562500f,-0.09375000f,-0.65625000f,0.95312500f,-0.78125000f,0.31250000f,-0.40625000f,-0.53125000f,0.56250000f,0.31250000f,0.14062500f,-0.65625000f,-0.65625000f,0.10937500f,0.42187500f,-0.25000000f,-0.01562500f,0.75000000f,0.92187500f,0.04687500f,0.17187500f,-0.59375000f,-0.56250000f,-0.10937500f,-0.40625000f,-0.84375000f,-0.87500000f,-0.50000000f,0.71875000f,-0.60937500f,0.20312500f,0.78125000f,-0.12500000f,0.62500000f,-0.12500000f,-0.50000000f,0.54687500f,-0.87500000f,-0.67187500f,-0.35937500f,-0.15625000f,0.64062500f,0.71875000f,0.42187500f,-0.12500000f,0.96875000f,0.87500000f,-0.57812500f,-0.10937500f,-0.23437500f,-0.85937500f,-0.73437500f,-0.40625000f,-0.90625000f,0.92187500f,-0.48437500f,0.06250000f,-0.21875000f,-0.42187500f,-0.39062500f,-0.59375000f,0.89062500f,-0.92187500f,0.04687500f,-0.40625000f,-0.15625000f,0.23437500f,-0.84375000f,-0.76562500f,-0.18750000f,0.98437500f,0.06250000f,0.85937500f,-0.07812500f,-0.95312500f,0.04687500f,0.43750000f,-0.93750000f,0.37500000f,-0.78125000f,0.46875000f,0.09375000f,0.64062500f,0.07812500f,-0.54687500f,-0.59375000f,-0.95312500f,-0.35937500f,0.70312500f,-0.45312500f,-0.39062500f,-0.60937500f,-0.67187500f,-0.14062500f,-0.82812500f,0.78125000f,0.23437500f,0.89062500f,-0.06250000f,-0.03125000f,0.45312500f,-0.54687500f,-0.37500000f,0.87500000f,0.09375000f,-0.79687500f,0.68750000f,-0.31250000f,0.70312500f,0.39062500f,-0.68750000f,-0.42187500f,0.32812500f,0.56250000f,0.76562500f,1.00000000f,0.54687500f,-0.70312500f,-0.06250000f,-0.10937500f,-0.56250000f,-0.68750000f,0.43750000f,0.87500000f,-0.39062500f,-0.59375000f,0.29687500f,-0.46875000f,-0.60937500f,-0.23437500f,0.68750000f,-0.60937500f,-0.32812500f,0.42187500f,0.56250000f,0.31250000f,0.31250000f,0.06250000f,-0.21875000f,-0.04687500f,-0.39062500f,-0.85937500f,0.96875000f,0.21875000f,0.51562500f,-0.79687500f,0.35937500f,-0.93750000f,0.39062500f,0.25000000f,0.01562500f,-0.89062500f,-0.26562500f,-0.79687500f,-0.46875000f,-0.79687500f,-0.25000000f,0.43750000f,0.56250000f,0.20312500f,1.00000000f,-0.56250000f,0.62500000f,0.12500000f,-0.29687500f,0.17187500f,-0.20312500f,-0.20312500f,-0.85937500f,-0.89062500f,0.57812500f,-0.68750000f,-0.87500000f,-0.71875000f,0.71875000f,-0.06250000f,-0.29687500f,-0.35937500f,-0.01562500f,-0.67187500f,0.00000000f,-0.29687500f,-0.82812500f,-0.56250000f,-0.04687500f,-0.81250000f,-0.23437500f,0.12500000f,-0.20312500f,-0.42187500f,0.89062500f,0.34375000f,0.00000000f,0.06250000f,-0.64062500f,-0.18750000f,0.18750000f,0.87500000f,-0.96875000f,-0.40625000f,-0.46875000f,-0.57812500f,-0.65625000f,-0.75000000f,-1.00000000f,0.64062500f,-0.57812500f,-0.56250000f,0.89062500f,0.67187500f,-0.29687500f,0.68750000f,-0.45312500f,0.68750000f,0.07812500f,-0.40625000f,0.39062500f,0.09375000f,-0.68750000f,-0.57812500f,-0.46875000f,-0.51562500f,0.60937500f,-0.32812500f,0.12500000f,0.26562500f,0.93750000f,-0.84375000f,0.12500000f,0.17187500f,-0.78125000f,-0.90625000f,-0.98437500f,-0.51562500f,-0.84375000f,-0.29687500f,-0.78125000f,-0.32812500f,-0.18750000f,0.23437500f,0.53125000f,-0.48437500f,0.67187500f,0.68750000f,0.62500000f,0.67187500f,-0.09375000f,-0.96875000f,-0.15625000f,-0.48437500f,-0.84375000f,-0.62500000f,-0.46875000f,-0.14062500f,0.81250000f,-0.64062500f,-0.46875000f,-0.20312500f,0.51562500f,-0.60937500f,0.95312500f,0.81250000f,-0.31250000f,-0.68750000f,0.40625000f,-0.90625000f,-0.10937500f,0.76562500f,-0.03125000f,-0.26562500f,-0.53125000f,-0.56250000f,-1.00000000f,-0.25000000f,-0.85937500f,0.09375000f,0.73437500f,-0.96875000f,0.01562500f,-0.57812500f,-0.95312500f,-0.01562500f,-0.84375000f,-0.45312500f,0.06250000f,-0.50000000f,-0.62500000f,0.71875000f,0.78125000f,0.79687500f,-0.46875000f,-0.84375000f,-0.50000000f,0.84375000f,0.73437500f,-0.93750000f,-0.10937500f,0.20312500f,-0.15625000f,-0.64062500f,-0.03125000f,0.75000000f,-0.65625000f,-0.54687500f,0.09375000f,-0.57812500f,0.29687500f,0.34375000f,-0.20312500f,-0.92187500f,-0.78125000f,-0.60937500f,-0.96875000f,-0.89062500f,0.57812500f,0.32812500f,-0.17187500f,0.59375000f,-0.40625000f,-0.25000000f,-0.39062500f,0.93750000f,0.00000000f,-0.98437500f,-0.39062500f,0.98437500f,0.96875000f,0.62500000f,-0.29687500f,0.43750000f,0.89062500f,0.84375000f,0.39062500f,-0.57812500f,-0.07812500f,0.68750000f,-0.29687500f,-0.54687500f,-1.00000000f,0.12500000f,-0.45312500f,-0.85937500f,-0.29687500f,-0.68750000f,0.39062500f,-0.28125000f,-0.70312500f,0.00000000f,-0.68750000f,-0.39062500f,0.00000000f,0.48437500f,0.28125000f,-0.89062500f,0.29687500f,0.45312500f,0.96875000f,0.65625000f,-0.89062500f,-0.26562500f,-0.25000000f,0.25000000f,-0.46875000f,0.95312500f,-0.17187500f,0.29687500f,-0.64062500f,0.50000000f,0.29687500f,-0.70312500f,0.53125000f,-0.04687500f,0.60937500f,0.10937500f,0.42187500f,0.45312500f,-0.34375000f,-0.48437500f,-0.67187500f,-0.25000000f,0.40625000f,0.56250000f,-0.82812500f,0.87500000f,-0.35937500f,0.75000000f,-0.43750000f,-0.29687500f,-0.43750000f,0.26562500f,-0.45312500f,-0.59375000f,0.00000000f,-0.06250000f,-0.70312500f,-0.59375000f,0.35937500f,-0.25000000f,-0.64062500f,0.32812500f,-0.12500000f,0.15625000f,0.53125000f,-0.75000000f,-0.50000000f,0.42187500f,-0.75000000f,0.43750000f,0.87500000f,0.57812500f,-0.10937500f,-0.81250000f,0.20312500f,-0.67187500f,-0.43750000f,-0.14062500f,0.21875000f,-0.81250000f,0.50000000f,0.59375000f,-0.32812500f,-0.60937500f,0.57812500f,0.46875000f,0.28125000f,-0.31250000f,1.00000000f,-0.31250000f,0.32812500f,0.98437500f,0.82812500f,-0.73437500f,0.07812500f,-1.00000000f,-1.00000000f,0.15625000f,0.45312500f,0.09375000f,0.60937500f,0.28125000f,-0.92187500f,-0.60937500f,0.42187500f,-0.85937500f,0.09375000f,-0.42187500f,-0.90625000f,0.96875000f,-0.50000000f,-0.39062500f,-0.12500000f,0.10937500f,-0.76562500f,0.71875000f,0.62500000f,0.71875000f,0.29687500f,0.14062500f,0.39062500f,0.89062500f,-0.01562500f,0.42187500f,0.39062500f,-0.48437500f,-0.46875000f,-0.34375000f,0.59375000f,-0.79687500f,0.06250000f,0.57812500f,0.26562500f,-1.00000000f,0.59375000f,-0.25000000f,-0.42187500f,-0.71875000f,-0.60937500f,0.09375000f,-0.65625000f,-0.20312500f,0.76562500f,-0.56250000f,0.15625000f,0.29687500f,0.60937500f,-0.78125000f,-0.73437500f,-0.26562500f,-0.43750000f,-0.60937500f,-0.20312500f,-0.82812500f,-0.51562500f,-0.92187500f,-0.46875000f,-0.62500000f,0.21875000f,0.04687500f,-0.62500000f,-0.85937500f,-0.98437500f,-0.18750000f,0.40625000f,-0.04687500f,0.48437500f,0.92187500f,0.53125000f,-0.59375000f,-0.42187500f,-0.95312500f,-0.75000000f,-0.04687500f,0.98437500f,0.92187500f,-0.39062500f,0.82812500f,0.20312500f,0.45312500f,-0.68750000f,0.54687500f,0.39062500f,0.84375000f,-0.90625000f,-0.35937500f,-0.07812500f,0.73437500f,-0.53125000f,-0.06250000f,-0.18750000f,-0.04687500f,-0.84375000f,0.65625000f,0.70312500f,-0.93750000f,0.76562500f,0.68750000f,0.39062500f,0.10937500f,-0.70312500f,-0.34375000f,-0.21875000f,0.32812500f,0.43750000f,-0.48437500f,0.37500000f,-0.20312500f,-0.85937500f,-0.90625000f,0.25000000f,-0.76562500f,-0.59375000f,-0.21875000f,0.82812500f,0.53125000f,-0.35937500f,0.01562500f,-0.43750000f,0.81250000f,0.25000000f,-0.32812500f,-0.21875000f,-0.42187500f,-0.23437500f,-0.34375000f,0.25000000f,-0.81250000f,-0.31250000f,0.71875000f,0.64062500f,-0.71875000f,0.76562500f,0.26562500f,0.01562500f,0.46875000f,0.82812500f,0.81250000f,-0.96875000f,0.96875000f,0.85937500f,0.82812500f,0.85937500f,-0.89062500f,0.18750000f,-0.87500000f,-0.78125000f,-0.59375000f,-0.84375000f,-0.57812500f,-0.21875000f,-0.10937500f,0.93750000f,0.20312500f,0.32812500f,0.04687500f,-0.18750000f,0.60937500f,0.31250000f,0.23437500f,0.03125000f,0.68750000f,-0.32812500f,-0.89062500f,-0.23437500f,-0.67187500f,0.15625000f,0.73437500f,-0.48437500f,0.56250000f,0.31250000f,0.39062500f,-0.65625000f,-0.67187500f,-0.90625000f,-0.43750000f,0.98437500f,-0.25000000f,-0.50000000f,-0.78125000f,0.06250000f,0.32812500f,-0.45312500f,-0.12500000f,0.17187500f,0.92187500f,-0.31250000f,0.01562500f,-0.70312500f,0.76562500f,0.53125000f,0.06250000f,0.95312500f,-0.46875000f,-0.39062500f,1.00000000f,0.59375000f,-0.20312500f,0.93750000f,-0.92187500f,-0.68750000f,-0.28125000f,0.18750000f,0.71875000f,0.18750000f,0.25000000f,-0.48437500f,0.01562500f,0.35937500f,0.48437500f,-0.54687500f,0.29687500f,0.73437500f,-0.51562500f,0.57812500f,-0.26562500f,0.46875000f,0.62500000f,0.62500000f,0.81250000f,0.17187500f,0.28125000f,-0.75000000f,-0.45312500f,-0.29687500f,0.37500000f,-0.71875000f,0.71875000f,0.93750000f,-0.42187500f,0.31250000f,-0.26562500f,0.81250000f,-0.15625000f,-0.62500000f,0.53125000f,0.12500000f,0.60937500f,0.60937500f,-0.04687500f,-0.90625000f,0.40625000f,0.12500000f,0.89062500f,0.09375000f,-0.14062500f,0.29687500f,-0.03125000f,-0.62500000f,0.17187500f,-0.67187500f,0.79687500f,0.53125000f,0.54687500f,-0.54687500f,0.71875000f,-0.03125000f,-0.14062500f,-0.56250000f,0.15625000f,0.90625000f,0.65625000f,0.00000000f,-0.35937500f,0.43750000f,-0.40625000f,0.57812500f,-0.25000000f,0.03125000f,0.04687500f,-0.42187500f,0.76562500f,0.85937500f,0.81250000f,-0.87500000f,-0.85937500f,0.14062500f,0.26562500f,0.03125000f,0.28125000f,0.17187500f,-0.50000000f,0.53125000f,-0.32812500f,-0.15625000f,0.18750000f,-0.92187500f,0.59375000f,0.34375000f,0.85937500f,-0.73437500f,0.28125000f,0.37500000f,0.62500000f,-0.92187500f,-0.09375000f,-0.31250000f,-0.51562500f,-0.68750000f,0.45312500f,0.01562500f,0.10937500f,0.42187500f,-0.15625000f,-0.28125000f,0.75000000f,-0.20312500f,0.45312500f,-0.85937500f,-0.85937500f,-0.23437500f,-0.54687500f,-0.51562500f,-0.71875000f,0.82812500f,0.93750000f,-0.62500000f,0.48437500f,-0.18750000f,0.60937500f,-0.39062500f,-0.21875000f,-0.79687500f,0.14062500f,0.93750000f,-0.32812500f,0.29687500f,0.15625000f,0.26562500f,-0.43750000f,-0.21875000f,0.28125000f,-0.17187500f,0.07812500f,0.31250000f,-0.68750000f,-0.03125000f,-0.14062500f,0.29687500f,0.01562500f,-0.90625000f,0.26562500f,0.26562500f,0.95312500f,0.81250000f,-0.03125000f,0.73437500f,0.06250000f,0.64062500f,-0.56250000f,-0.87500000f,0.65625000f,-0.85937500f,0.67187500f,-0.34375000f,-0.23437500f,-0.01562500f,-0.14062500f,0.78125000f,0.00000000f,-0.62500000f,0.62500000f,0.45312500f,-0.37500000f,0.32812500f,0.53125000f,0.85937500f,0.59375000f,0.98437500f,0.10937500f,0.32812500f,0.73437500f,-0.01562500f,-0.34375000f,-0.45312500f,-0.34375000f,-0.68750000f,-0.09375000f,-0.45312500f,0.23437500f,-0.14062500f,-0.21875000f,-0.70312500f,-0.26562500f,-0.35937500f,-0.14062500f,0.75000000f,-0.45312500f,-0.68750000f,-0.56250000f,0.03125000f,-0.71875000f,-0.09375000f,0.42187500f,0.68750000f,0.56250000f,0.34375000f,-0.32812500f,-0.29687500f,0.73437500f,0.18750000f,-0.23437500f,-0.25000000f,0.57812500f,-0.70312500f,0.90625000f,-0.78125000f,-0.57812500f,-0.75000000f,-0.70312500f,0.50000000f,-0.40625000f,-0.87500000f,0.28125000f,0.68750000f,-0.03125000f,-0.15625000f,-0.68750000f,-0.62500000f,-0.84375000f,-0.03125000f,0.98437500f,0.64062500f,-0.07812500f,-0.53125000f,0.92187500f,-0.78125000f,-0.23437500f,0.84375000f,-0.37500000f,-0.31250000f,-0.28125000f,-0.10937500f,0.76562500f,0.34375000f,0.92187500f,0.82812500f,-0.35937500f,-0.84375000f,-0.04687500f,-0.53125000f,-0.87500000f,0.81250000f,-0.53125000f,-0.39062500f,0.64062500f,0.04687500f,0.65625000f,0.31250000f,-0.46875000f,0.35937500f,0.15625000f,0.42187500f,-0.51562500f,0.64062500f,0.59375000f,-0.10937500f,-0.56250000f,-0.82812500f,-0.17187500f,-0.89062500f,-0.79687500f,-0.70312500f,-0.96875000f,-0.85937500f,0.57812500f,-0.29687500f,-0.34375000f,-0.14062500f,0.28125000f,0.04687500f,-0.81250000f,-0.17187500f,0.68750000f,0.56250000f,0.37500000f,0.50000000f,0.57812500f,0.62500000f,-0.46875000f,-0.76562500f,0.42187500f,0.76562500f,-0.45312500f,0.28125000f,-0.95312500f,-0.21875000f,-0.98437500f,-0.31250000f,-0.68750000f,0.62500000f,-0.23437500f,0.92187500f,0.65625000f,0.10937500f,-0.12500000f,0.93750000f,-0.53125000f,-0.87500000f,0.53125000f,-0.50000000f,-0.75000000f,0.54687500f,-0.17187500f,-0.81250000f,-0.39062500f,-0.17187500f,-0.31250000f,-0.39062500f,0.70312500f,0.25000000f,0.78125000f,0.85937500f,-0.87500000f,-0.98437500f,-0.10937500f,0.32812500f,0.21875000f,-0.46875000f,-0.28125000f,-0.28125000f,0.32812500f,-0.10937500f,-0.21875000f,-0.71875000f,0.79687500f,0.14062500f,0.68750000f,0.78125000f,0.56250000f,0.40625000f,0.32812500f,-0.51562500f,0.40625000f,0.12500000f,0.54687500f,0.42187500f,-0.82812500f,0.68750000f,0.07812500f,-0.73437500f,0.87500000f,0.68750000f,-0.96875000f,0.40625000f,0.95312500f,0.62500000f,0.20312500f,0.73437500f,0.79687500f,0.32812500f,-0.85937500f,0.10937500f,-0.95312500f,-0.73437500f,0.51562500f,0.46875000f,0.51562500f,-0.95312500f,0.34375000f,-0.46875000f,-0.40625000f,0.15625000f,-0.93750000f,0.42187500f,0.59375000f,0.12500000f,0.57812500f,-0.06250000f,0.62500000f,-0.43750000f,0.79687500f,-0.81250000f,-0.40625000f,-0.71875000f,-0.56250000f,-0.70312500f,-0.15625000f,-0.85937500f,0.93750000f,0.53125000f,-0.21875000f,-0.07812500f,-0.75000000f,0.43750000f,-0.96875000f,0.14062500f,-0.64062500f,-0.15625000f,-0.34375000f,-0.29687500f,0.40625000f,-0.03125000f,0.03125000f,-0.50000000f,0.75000000f,-0.48437500f,0.14062500f,0.45312500f,-0.40625000f,0.39062500f,0.65625000f,-0.23437500f,-0.98437500f,0.12500000f,0.62500000f,0.29687500f,-0.50000000f,0.10937500f,-0.75000000f,0.75000000f,-0.26562500f,-0.20312500f,-0.42187500f,0.07812500f,0.67187500f,0.37500000f,-0.14062500f,0.04687500f,0.54687500f,0.09375000f,-0.68750000f,0.60937500f,0.60937500f,-0.60937500f,0.67187500f,-0.31250000f,0.37500000f,0.93750000f,-0.32812500f,-0.51562500f,-0.96875000f,0.96875000f,1.00000000f,0.10937500f,0.95312500f,-0.42187500f,0.65625000f,0.25000000f,-0.18750000f,-0.42187500f,0.64062500f,-0.10937500f,-0.45312500f,-0.96875000f,0.32812500f,0.00000000f,0.35937500f,0.48437500f,-0.20312500f,-0.40625000f,0.12500000f,-0.06250000f,0.62500000f,0.45312500f,0.06250000f,-0.29687500f,0.50000000f,-0.06250000f,-0.39062500f,-0.40625000f,-1.00000000f,0.67187500f,0.45312500f,-0.68750000f,0.26562500f,0.48437500f,0.18750000f,-0.96875000f,0.67187500f,-0.98437500f,0.98437500f,0.17187500f,0.76562500f,-0.26562500f,-0.60937500f,0.40625000f,0.48437500f,0.46875000f,0.48437500f,0.68750000f,0.89062500f,0.39062500f,0.18750000f,0.06250000f,-0.95312500f,0.46875000f,0.23437500f,-0.73437500f,-0.98437500f,0.06250000f,-0.68750000f,-0.20312500f,0.65625000f,0.96875000f,0.25000000f,0.42187500f,-0.01562500f,0.43750000f,0.89062500f,0.00000000f,0.87500000f,0.57812500f,0.42187500f,0.56250000f,-0.20312500f,0.42187500f,0.76562500f,-0.67187500f,0.89062500f,-0.12500000f,-0.04687500f,0.40625000f,-0.70312500f,0.26562500f,-0.09375000f,0.87500000f,-1.00000000f,-0.78125000f,0.48437500f,-0.84375000f,-0.79687500f,0.90625000f,-0.89062500f,-0.46875000f,0.07812500f,0.23437500f,-0.18750000f,-0.51562500f,-0.39062500f,0.29687500f,0.35937500f,0.82812500f,-0.37500000f,0.40625000f,-0.60937500f,0.06250000f,-0.67187500f,0.68750000f,0.12500000f,-0.56250000f,0.50000000f,-0.43750000f,0.10937500f,0.42187500f,-0.84375000f,0.56250000f,-0.28125000f,-0.50000000f,0.50000000f,-0.96875000f,0.98437500f,-0.07812500f,0.62500000f,0.17187500f,0.71875000f,-0.26562500f,-0.07812500f,-0.42187500f,0.87500000f,-0.56250000f,-0.67187500f,0.78125000f,-0.78125000f,0.82812500f,0.14062500f,-0.92187500f,0.01562500f,0.95312500f,-0.54687500f,-0.46875000f,-0.17187500f,0.85937500f,0.00000000f,0.18750000f,-0.48437500f,0.98437500f,-0.51562500f,-0.68750000f,0.81250000f,-0.82812500f,-0.12500000f,0.04687500f,-0.45312500f,-0.48437500f,-0.32812500f,-0.56250000f,-0.20312500f,0.67187500f,-0.17187500f,-0.51562500f,-0.48437500f,0.07812500f,-0.56250000f,-0.67187500f,0.18750000f,1.00000000f,-0.21875000f,-0.12500000f,-0.07812500f,0.51562500f,-0.10937500f,-0.18750000f,-0.82812500f,0.70312500f,1.00000000f,0.25000000f,-0.39062500f,-0.20312500f,0.21875000f,0.39062500f,-0.40625000f,-0.73437500f,0.46875000f,-0.95312500f,-0.31250000f,-0.64062500f,-0.48437500f,0.23437500f,-0.23437500f,-0.21875000f,0.90625000f,-0.87500000f,-0.06250000f,0.79687500f,0.35937500f,0.67187500f,0.12500000f,-0.71875000f,0.75000000f,-0.78125000f,0.37500000f,0.73437500f,-0.79687500f,0.84375000f,-0.79687500f,0.29687500f,-0.42187500f,0.60937500f,0.23437500f,0.67187500f,0.01562500f,-0.68750000f,-0.09375000f,-0.96875000f,0.01562500f,-0.60937500f,0.35937500f,-0.46875000f,-0.34375000f,0.95312500f,-1.00000000f,0.54687500f,0.84375000f,-0.50000000f,-0.57812500f,-0.15625000f,0.53125000f,-0.40625000f,-0.31250000f,0.26562500f,-0.26562500f,-0.85937500f,-0.06250000f,-0.93750000f,-0.96875000f,0.31250000f,-0.59375000f,0.87500000f,0.98437500f,0.82812500f,-0.23437500f,-0.10937500f,0.45312500f,0.73437500f,-0.90625000f,0.64062500f,-0.81250000f,0.79687500f,-0.79687500f,0.71875000f,-0.78125000f,-0.76562500f,0.48437500f,0.18750000f,0.09375000f,-0.06250000f,-0.65625000f,-0.67187500f,0.21875000f,-1.00000000f,-0.89062500f,0.01562500f,-0.75000000f,-0.18750000f,0.57812500f,-0.45312500f,0.17187500f,0.81250000f,0.65625000f,-0.26562500f,-0.90625000f,-0.78125000f,0.82812500f,-0.78125000f,0.07812500f,0.39062500f,0.75000000f,-0.76562500f,0.71875000f,-0.98437500f,-0.51562500f,0.78125000f,-0.46875000f,0.90625000f,-0.57812500f,0.09375000f,-0.81250000f,-0.10937500f,-0.96875000f,-0.68750000f,-0.87500000f,-0.15625000f,-0.17187500f,-0.35937500f,-0.23437500f,-0.98437500f,1.00000000f,0.96875000f,-0.50000000f,0.95312500f,-0.14062500f,-0.93750000f,0.73437500f,-0.59375000f,-0.45312500f,0.18750000f,-0.93750000f,-0.64062500f,-0.89062500f,-0.23437500f,0.76562500f,-0.54687500f,-0.42187500f,0.78125000f,-0.60937500f,0.65625000f,-0.51562500f,-0.95312500f,0.46875000f,0.14062500f,-0.31250000f,-0.96875000f,-0.92187500f,-0.65625000f,0.10937500f,-0.84375000f,-0.70312500f,0.76562500f,0.18750000f,0.84375000f,-1.00000000f,0.90625000f,0.15625000f,-0.93750000f,-0.98437500f,0.59375000f,0.56250000f,-0.93750000f,-0.62500000f,0.07812500f,0.48437500f,-0.56250000f,-0.34375000f,-0.84375000f,-0.56250000f,-0.42187500f,0.75000000f,-0.54687500f,-0.18750000f,0.92187500f,-0.85937500f,0.45312500f,0.78125000f,-0.92187500f,-0.89062500f,-0.95312500f,-0.35937500f,-0.35937500f,0.84375000f,0.60937500f,-0.64062500f,-0.56250000f,0.15625000f,0.54687500f,0.00000000f,0.90625000f,0.43750000f,0.92187500f,0.81250000f,-0.79687500f,0.79687500f,0.60937500f,-0.76562500f,0.53125000f,0.67187500f,0.93750000f,-0.46875000f,0.00000000f,0.57812500f,-0.32812500f,-0.82812500f,0.42187500f,-0.21875000f,-0.09375000f,0.92187500f,-0.98437500f,-0.95312500f,0.06250000f,0.59375000f,0.89062500f,0.32812500f,0.59375000f,0.45312500f,-0.57812500f,-0.09375000f,0.43750000f,-0.32812500f,0.37500000f,-0.06250000f,0.87500000f,0.68750000f,0.59375000f,0.79687500f,0.85937500f,0.35937500f,0.68750000f,0.89062500f,0.57812500f,-0.12500000f,0.20312500f,0.48437500f,-0.84375000f,-0.95312500f,0.68750000f,0.65625000f,-0.87500000f,0.82812500f,0.23437500f,0.15625000f,0.32812500f,0.64062500f,-0.26562500f,-0.39062500f,0.45312500f,-0.85937500f,-0.70312500f,-0.31250000f,-0.64062500f,0.34375000f,0.23437500f,-0.71875000f,0.51562500f,0.37500000f,-0.39062500f,0.04687500f,0.25000000f,0.98437500f,-0.56250000f,0.67187500f,0.04687500f,-0.76562500f,-0.45312500f,0.15625000f,0.75000000f,-0.23437500f,-0.98437500f,0.54687500f,-0.79687500f,-0.64062500f,-0.50000000f,-0.84375000f,0.78125000f,-0.31250000f,0.79687500f,0.31250000f,0.34375000f,0.64062500f,0.59375000f,0.07812500f,0.68750000f,0.06250000f,-0.09375000f,0.01562500f,-0.35937500f,-0.37500000f,-0.46875000f,0.18750000f,0.53125000f,-0.35937500f,-0.98437500f,0.51562500f,-0.28125000f,0.95312500f,0.28125000f,0.46875000f,0.00000000f,-0.34375000f,-0.64062500f,0.18750000f,0.48437500f,-0.32812500f,-0.23437500f,-0.31250000f,-0.28125000f,-0.70312500f,0.25000000f,0.56250000f,-0.17187500f,-0.06250000f,0.39062500f,-0.84375000f,-0.85937500f,0.57812500f,-0.31250000f,0.48437500f,1.00000000f,0.57812500f,-1.00000000f,0.60937500f,0.84375000f,-0.62500000f,0.64062500f,0.07812500f,-0.98437500f,-0.12500000f,-0.85937500f,-0.53125000f,-0.62500000f,-0.79687500f,0.60937500f,0.31250000f,0.25000000f,0.20312500f,0.26562500f,-0.89062500f,0.15625000f,0.68750000f,0.68750000f,0.42187500f,-0.79687500f,0.34375000f,0.67187500f,-0.42187500f,0.84375000f,-0.42187500f,0.70312500f,0.10937500f,0.92187500f,0.29687500f,0.87500000f,-0.79687500f,0.29687500f,-0.09375000f,-0.14062500f,-0.35937500f,0.92187500f,0.03125000f,-0.12500000f,0.92187500f,-0.92187500f,-0.14062500f,-0.15625000f,0.87500000f,-0.71875000f,-0.42187500f,-0.17187500f,-0.87500000f,0.50000000f,0.15625000f,0.42187500f,0.03125000f,0.54687500f,-0.90625000f,0.06250000f,0.12500000f,-0.75000000f,0.06250000f,0.39062500f,-0.81250000f,0.03125000f,-0.50000000f,-0.21875000f,0.64062500f,0.67187500f,-0.67187500f,-0.62500000f,-0.40625000f,-0.04687500f,-0.76562500f,0.81250000f,0.53125000f,-0.43750000f,-0.37500000f,-0.59375000f,-0.57812500f,-0.50000000f,0.15625000f,0.92187500f,-0.23437500f,0.25000000f,-0.53125000f,-0.84375000f,-0.35937500f,-1.00000000f,0.75000000f,0.14062500f,0.34375000f,0.39062500f,0.67187500f,-0.42187500f,-0.82812500f,-0.45312500f,0.98437500f,-0.35937500f,0.81250000f,-0.56250000f,0.76562500f,0.67187500f,-0.81250000f,0.20312500f,-0.67187500f,-0.10937500f,-0.57812500f,-0.95312500f,-0.54687500f,0.23437500f,-0.20312500f,-0.20312500f,-0.04687500f,-0.93750000f,-0.75000000f,-0.32812500f,0.62500000f,0.15625000f,0.51562500f,-0.98437500f,0.32812500f,0.18750000f,0.03125000f,-0.23437500f,0.67187500f,-0.39062500f,-0.60937500f,-0.48437500f,0.92187500f,0.90625000f,0.00000000f,-0.64062500f,0.03125000f,-0.84375000f,0.12500000f,0.57812500f,0.04687500f,-1.00000000f,-0.43750000f,0.03125000f,0.06250000f,0.45312500f,0.67187500f,0.06250000f,-0.43750000f,-0.25000000f,-0.48437500f,0.01562500f,0.31250000f,0.75000000f,0.46875000f,0.37500000f,-0.40625000f,0.57812500f,0.98437500f,-0.65625000f,-0.17187500f,-0.84375000f,-0.23437500f,0.20312500f,0.81250000f,-0.37500000f,0.48437500f,-0.87500000f,-0.54687500f,0.34375000f,-1.00000000f,-0.06250000f,0.31250000f,0.57812500f,0.35937500f,0.37500000f,-0.20312500f,-0.18750000f,-0.85937500f,0.53125000f,0.48437500f,0.29687500f,-0.73437500f,-0.14062500f,0.28125000f,0.20312500f,0.98437500f,0.12500000f,-0.64062500f,0.18750000f,-0.15625000f,0.31250000f,0.03125000f,0.03125000f,-0.76562500f,-0.81250000f,0.15625000f,0.20312500f,0.95312500f,-0.31250000f,0.20312500f,-0.62500000f,-0.73437500f,-0.92187500f,0.93750000f,-0.79687500f,0.14062500f,0.64062500f,-0.32812500f,0.29687500f,0.20312500f,0.71875000f,0.12500000f,-0.90625000f,0.39062500f,0.25000000f,0.95312500f,-0.51562500f,0.73437500f,0.04687500f,-0.78125000f,-0.34375000f,0.09375000f,-0.28125000f,-0.07812500f,-0.50000000f,0.87500000f,0.93750000f,-0.12500000f,0.53125000f,0.70312500f,0.37500000f,0.10937500f,-0.12500000f,0.12500000f,-0.01562500f,-0.01562500f,0.54687500f,-0.26562500f,0.20312500f,0.40625000f,0.70312500f,-0.53125000f,-0.40625000f,0.64062500f,0.21875000f,-0.04687500f,-0.39062500f,0.25000000f,0.37500000f,0.76562500f,-0.46875000f,-0.26562500f,-0.82812500f,-0.31250000f,-0.23437500f,-0.95312500f,-0.84375000f,-0.15625000f,-0.09375000f,-0.98437500f,0.46875000f,-0.62500000f,0.84375000f,0.92187500f,0.01562500f,-0.17187500f,0.64062500f,-0.68750000f,-0.25000000f,0.90625000f,0.79687500f,-0.68750000f,-0.42187500f,0.65625000f,0.98437500f,0.31250000f,-0.43750000f,-0.14062500f,0.26562500f,0.90625000f,0.31250000f,0.40625000f,0.95312500f,-0.43750000f,0.70312500f,-0.81250000f,0.75000000f,0.34375000f,-0.59375000f,-0.15625000f,0.04687500f,0.89062500f,0.57812500f,-0.35937500f,-0.68750000f,0.82812500f,-0.87500000f,0.21875000f,-0.53125000f,0.54687500f,-0.28125000f,-0.45312500f,0.96875000f,0.93750000f,0.15625000f,-0.32812500f,-0.10937500f,-0.09375000f,-0.68750000f,0.21875000f,-0.87500000f,-0.82812500f,0.01562500f,-0.89062500f,0.32812500f,0.35937500f,0.21875000f,0.82812500f,-0.21875000f,0.42187500f,-0.21875000f,0.93750000f,0.51562500f,-0.65625000f,-0.89062500f,-0.75000000f,-0.64062500f,-0.81250000f,0.92187500f,-0.56250000f,0.43750000f,0.84375000f,0.76562500f,0.37500000f,0.60937500f,0.23437500f,-0.60937500f,-0.98437500f,0.21875000f,0.15625000f,0.23437500f,-0.82812500f,0.92187500f,-0.85937500f,0.76562500f,-0.28125000f,0.48437500f,0.18750000f,-0.54687500f,0.68750000f,0.09375000f,0.20312500f,-0.76562500f,-0.78125000f,1.00000000f,0.48437500f,0.50000000f,-0.67187500f,-0.42187500f,0.75000000f,0.20312500f,0.76562500f,0.31250000f,0.06250000f,-0.07812500f,-0.71875000f,0.96875000f,0.45312500f,0.00000000f,0.01562500f,0.48437500f,0.57812500f,-0.32812500f,-0.93750000f,0.48437500f,0.20312500f,-0.87500000f,-0.73437500f,-0.62500000f,-0.82812500f,-0.84375000f,-0.46875000f,0.42187500f,0.23437500f,-0.35937500f,0.09375000f,0.60937500f,-0.96875000f,-0.12500000f,-0.46875000f,-0.31250000f,0.07812500f,-0.46875000f,0.93750000f,-0.20312500f,0.75000000f,-0.81250000f,0.76562500f,0.70312500f,0.53125000f,-0.04687500f,0.00000000f,-0.76562500f,0.85937500f,-0.06250000f,0.84375000f,-0.67187500f,-0.59375000f,-0.90625000f,0.00000000f,-0.29687500f,0.81250000f,0.79687500f,-0.76562500f,-0.87500000f,0.34375000f,-0.76562500f,-0.14062500f,-0.87500000f,0.78125000f,-0.51562500f,0.96875000f,0.18750000f,0.32812500f,-1.00000000f,0.92187500f,-0.32812500f,-0.18750000f,-0.35937500f,-0.03125000f,-0.23437500f,0.39062500f,-0.23437500f,-0.89062500f,-0.79687500f,-0.89062500f,-1.00000000f,-0.12500000f,0.18750000f,0.90625000f,0.56250000f,-0.98437500f,-0.65625000f,0.65625000f,0.28125000f,0.32812500f,0.76562500f,0.96875000f,-0.31250000f,0.12500000f,0.90625000f,0.34375000f,0.42187500f,-0.39062500f,0.53125000f,0.70312500f,0.07812500f,0.46875000f,-0.42187500f,0.50000000f,0.28125000f,0.23437500f,0.70312500f,0.10937500f,-0.45312500f,0.31250000f,0.15625000f,-0.71875000f,-0.76562500f,-0.57812500f,0.75000000f,0.92187500f,0.14062500f,0.46875000f,0.06250000f,0.25000000f,-0.31250000f,-0.59375000f,0.03125000f,0.37500000f,-0.35937500f,0.90625000f,0.23437500f,-0.96875000f,-0.87500000f,0.70312500f,0.95312500f,-0.29687500f,-0.09375000f,-0.39062500f,-0.31250000f,-0.50000000f,-0.53125000f,-0.95312500f,-0.23437500f,-0.01562500f,-0.53125000f,-0.71875000f,-0.56250000f,-0.54687500f,-0.98437500f,-0.21875000f,-0.46875000f,0.98437500f,0.46875000f,0.20312500f,-0.45312500f,-0.32812500f,0.64062500f,-0.76562500f,-0.43750000f,0.56250000f,0.35937500f,-0.76562500f,0.60937500f,0.68750000f,0.96875000f,-0.50000000f,0.48437500f,-0.87500000f,-0.29687500f,-0.01562500f,0.93750000f,0.81250000f,-0.32812500f,0.93750000f,0.79687500f,-0.45312500f,0.64062500f,0.48437500f,-0.87500000f,-0.67187500f,0.78125000f,0.43750000f,-0.15625000f,-0.85937500f,0.42187500f,-0.42187500f,-0.31250000f,0.60937500f,0.12500000f,-0.85937500f,0.34375000f,0.25000000f,-0.85937500f,-0.45312500f,-0.56250000f,-0.84375000f,-0.28125000f,0.87500000f,-0.14062500f,0.95312500f,-0.59375000f,0.43750000f,0.90625000f,-1.00000000f,0.04687500f,-0.60937500f,-0.54687500f,-0.15625000f,0.51562500f,-0.29687500f,-0.40625000f,0.81250000f,-0.67187500f,-0.51562500f,0.15625000f,-0.79687500f,0.04687500f,0.71875000f,-0.79687500f,-0.70312500f,-0.89062500f,0.18750000f,-1.00000000f,-0.98437500f,-0.04687500f,-0.46875000f,-0.09375000f,-0.62500000f,-0.48437500f,-0.29687500f,0.96875000f,0.71875000f,-0.46875000f,0.45312500f,-0.79687500f,0.23437500f,-0.23437500f,0.25000000f,0.20312500f,0.71875000f,-0.20312500f,-0.43750000f,0.48437500f,0.31250000f,-0.89062500f,-0.15625000f,0.98437500f,-0.15625000f,0.56250000f,-0.06250000f,0.85937500f,0.82812500f,-0.32812500f,0.40625000f,0.73437500f,-0.53125000f,-0.82812500f,-0.37500000f,0.70312500f,0.31250000f,-0.56250000f,0.28125000f,-0.20312500f,-0.09375000f,0.98437500f,0.70312500f,0.01562500f,0.25000000f,0.10937500f,0.34375000f,0.14062500f,-0.98437500f,0.79687500f,-0.54687500f,-0.12500000f,0.48437500f,-0.95312500f,-0.21875000f,0.25000000f,0.03125000f,-0.28125000f,-0.17187500f,0.20312500f,0.68750000f,0.48437500f,0.00000000f,0.35937500f,-0.73437500f,0.14062500f,-0.40625000f,-0.96875000f,-0.12500000f,0.12500000f,0.23437500f,0.95312500f,0.39062500f,0.25000000f,-0.96875000f,0.73437500f,-0.96875000f,0.18750000f,0.81250000f,0.90625000f,-0.70312500f,0.84375000f,-0.59375000f,0.32812500f,1.00000000f,0.89062500f,-0.57812500f,-0.43750000f,0.37500000f,0.23437500f,-0.57812500f,-0.34375000f,-0.37500000f,0.85937500f,-0.04687500f,0.29687500f,-0.40625000f,-0.65625000f,-0.85937500f,0.07812500f,-0.75000000f,-0.35937500f,-0.34375000f,0.85937500f,0.18750000f,0.78125000f,-0.25000000f,0.37500000f,0.65625000f,0.03125000f,0.64062500f,0.70312500f,0.37500000f,0.14062500f,0.57812500f,0.84375000f,0.89062500f,0.93750000f,0.51562500f,-0.67187500f,0.32812500f,0.12500000f,0.31250000f,0.70312500f,0.81250000f,-0.96875000f,0.07812500f,0.60937500f,-0.32812500f,-0.71875000f,0.14062500f,0.75000000f,-0.35937500f,-0.90625000f,-0.71875000f,-0.23437500f,-0.75000000f,-0.56250000f,-0.95312500f,0.28125000f,-0.62500000f,0.96875000f,0.65625000f,-0.21875000f,0.67187500f,-0.01562500f,0.85937500f,-0.76562500f,0.75000000f,-0.39062500f,0.76562500f,0.03125000f,0.92187500f,-0.50000000f,0.95312500f,-0.87500000f,-0.01562500f,0.06250000f,-0.03125000f,0.35937500f,-0.81250000f,-0.76562500f,0.87500000f,0.07812500f,0.79687500f,0.85937500f,0.14062500f,0.93750000f,-0.29687500f,-0.98437500f,0.84375000f,-0.06250000f,-0.71875000f,0.03125000f,-0.10937500f,0.42187500f,-0.85937500f,-0.40625000f,-0.96875000f,0.28125000f,0.31250000f,0.98437500f,0.29687500f,-0.46875000f,0.57812500f,-0.54687500f,0.78125000f,0.64062500f,-0.18750000f,0.14062500f,-0.81250000f,-0.75000000f,0.00000000f,-0.56250000f,0.98437500f,0.57812500f,-0.34375000f,0.84375000f,-0.32812500f,-0.57812500f,0.57812500f,0.57812500f,-0.15625000f,-0.15625000f,-0.65625000f,0.73437500f,0.71875000f,-0.04687500f,0.64062500f,-0.71875000f,-0.95312500f,-0.53125000f,-0.64062500f,-0.78125000f,-0.53125000f,-0.34375000f,0.21875000f,0.15625000f,0.21875000f,-0.35937500f,0.71875000f,0.70312500f,-0.07812500f,0.15625000f,0.45312500f,-0.70312500f,0.40625000f,-0.60937500f,-0.95312500f,0.71875000f,-0.60937500f,-0.90625000f,-0.14062500f,0.15625000f,0.75000000f,0.67187500f,-0.67187500f,0.89062500f,-0.82812500f,0.01562500f,-0.54687500f,0.48437500f,0.64062500f,-0.92187500f,0.35937500f,0.62500000f,0.35937500f,0.75000000f,0.29687500f,0.04687500f,-0.64062500f,-0.96875000f,0.29687500f,-0.42187500f,0.90625000f,-0.42187500f,-0.70312500f,0.07812500f,0.73437500f,0.89062500f,-0.70312500f,0.00000000f,-0.70312500f,0.64062500f,0.67187500f,0.43750000f,-0.90625000f,-0.46875000f,0.84375000f,0.01562500f,0.85937500f,-0.23437500f,0.75000000f,-0.23437500f,0.87500000f,-0.39062500f,0.12500000f,0.06250000f,-0.12500000f,-0.71875000f,0.71875000f,-0.48437500f,0.67187500f,0.79687500f,0.01562500f,-0.50000000f,-0.81250000f,0.12500000f,0.15625000f,0.82812500f,0.15625000f,-1.00000000f,0.07812500f,-0.46875000f,0.07812500f,0.85937500f,-0.17187500f,0.50000000f,0.23437500f,-0.26562500f,0.53125000f,-0.40625000f,0.65625000f,0.45312500f,1.00000000f,0.31250000f,-0.51562500f,0.43750000f,0.90625000f,-0.23437500f,0.96875000f,0.85937500f,-0.73437500f,-0.03125000f,0.92187500f,0.54687500f,0.15625000f,-0.57812500f,-0.51562500f,-0.18750000f,-0.92187500f,0.06250000f,0.20312500f,-0.98437500f,0.79687500f,0.82812500f,0.09375000f,0.76562500f,-0.85937500f,0.10937500f,0.10937500f,-0.92187500f,0.45312500f,-0.39062500f,0.01562500f,-0.60937500f,0.79687500f,0.21875000f,-0.50000000f,0.39062500f,-0.35937500f,0.03125000f,0.43750000f,0.14062500f,0.70312500f,0.81250000f,-0.64062500f,-0.25000000f,0.59375000f,0.96875000f,-0.45312500f,-0.89062500f,0.51562500f,0.46875000f,-0.18750000f,0.59375000f,0.75000000f,0.26562500f,0.54687500f,-0.56250000f,-0.23437500f,-0.73437500f,-0.37500000f,0.67187500f,-0.03125000f,-0.29687500f,-0.26562500f,-0.79687500f,0.51562500f,-0.23437500f,-0.53125000f,0.90625000f,-0.59375000f,-0.10937500f,0.78125000f,0.40625000f,-0.85937500f,0.23437500f,0.62500000f,0.71875000f,-0.75000000f,-0.59375000f,0.62500000f,-1.00000000f,0.90625000f,-0.65625000f,-0.71875000f,-0.95312500f,0.25000000f,-0.23437500f,0.23437500f,-0.92187500f,0.07812500f,-0.10937500f,0.43750000f,0.35937500f,-0.10937500f,0.89062500f,-0.09375000f,0.03125000f,-0.92187500f,0.45312500f,0.34375000f,-0.23437500f,0.56250000f,0.28125000f,0.23437500f,-0.32812500f,-0.82812500f,-0.42187500f,-0.53125000f,-0.95312500f,-0.32812500f,0.53125000f,0.29687500f,0.18750000f,-0.14062500f,-0.93750000f,-0.07812500f,-0.06250000f,-0.17187500f,0.42187500f,0.32812500f,-0.39062500f,0.46875000f,0.35937500f,0.67187500f,0.23437500f,0.76562500f,-0.07812500f,-0.25000000f,0.78125000f,-0.64062500f,-0.43750000f,-0.03125000f,-0.48437500f,-0.81250000f,0.18750000f,0.37500000f,0.35937500f,-0.89062500f,1.00000000f,-0.75000000f,-0.93750000f,-0.76562500f,-0.31250000f,-0.93750000f,-0.14062500f,-0.81250000f,-0.95312500f,0.98437500f,0.06250000f,0.76562500f,0.35937500f,0.59375000f,-0.79687500f,-0.07812500f,0.59375000f,0.64062500f,-0.90625000f,0.90625000f,-0.29687500f,-0.37500000f,0.96875000f,-0.39062500f,-0.51562500f,-0.10937500f,0.20312500f,-0.70312500f,-0.85937500f,0.79687500f,-0.20312500f,-0.84375000f,0.84375000f,-0.78125000f,-0.10937500f,0.20312500f,0.78125000f,0.78125000f,0.12500000f,0.14062500f,0.50000000f,0.90625000f,-0.34375000f,-0.43750000f,0.90625000f,0.28125000f,-0.73437500f,0.90625000f,-0.79687500f,-0.71875000f,-0.26562500f,0.40625000f,-0.50000000f,-0.04687500f,0.29687500f,-0.71875000f,-0.60937500f,0.34375000f,-0.93750000f,0.79687500f,0.48437500f,-0.65625000f,0.87500000f,-0.89062500f,-0.82812500f,-0.53125000f,0.60937500f,0.48437500f,-0.67187500f,-0.67187500f,-0.79687500f,-0.06250000f,0.98437500f,0.18750000f,0.56250000f,-0.60937500f,0.87500000f,0.93750000f,-0.17187500f,-0.31250000f,0.92187500f,-0.40625000f,0.48437500f,-0.73437500f,-0.32812500f,-0.31250000f,0.64062500f,-0.23437500f,-0.84375000f,-0.29687500f,0.62500000f,0.90625000f,0.15625000f,-0.65625000f,0.71875000f,0.57812500f,0.20312500f,0.43750000f,0.42187500f,-0.04687500f,0.39062500f,-0.51562500f,-0.79687500f,0.07812500f,-0.10937500f,0.92187500f,-0.32812500f,0.15625000f,-0.59375000f,0.03125000f,0.34375000f,0.95312500f,0.31250000f,-0.56250000f,-0.50000000f,0.28125000f,-0.89062500f,0.06250000f,0.56250000f,-0.15625000f,0.32812500f,-0.37500000f,-0.46875000f,-0.31250000f,-0.95312500f,0.15625000f,0.64062500f,0.59375000f,-0.98437500f,-0.51562500f,-0.12500000f,-0.57812500f,0.37500000f,-0.37500000f,-0.56250000f,-0.32812500f,0.93750000f,-0.03125000f,-0.45312500f,0.48437500f,-0.96875000f,0.53125000f,-0.67187500f,1.00000000f,0.14062500f,-0.62500000f,0.54687500f,0.53125000f,-0.18750000f,0.59375000f,-0.67187500f,-0.23437500f,0.03125000f,0.95312500f,0.17187500f,0.64062500f,0.31250000f,0.98437500f,-0.17187500f,-0.82812500f,-0.60937500f,-0.45312500f,0.67187500f,0.54687500f,-0.06250000f,0.71875000f,-0.92187500f,-0.79687500f,-0.68750000f,0.31250000f,0.29687500f,0.07812500f,-0.26562500f,-0.21875000f,-0.14062500f,0.40625000f,-0.10937500f,0.79687500f,-0.28125000f,0.93750000f,0.26562500f,-0.75000000f,-0.32812500f,-0.35937500f,-0.70312500f,0.84375000f,-0.37500000f,-0.07812500f,0.39062500f,-0.84375000f,0.60937500f,0.40625000f,0.50000000f,0.81250000f,0.12500000f,0.82812500f,0.89062500f,0.84375000f,-0.64062500f,0.81250000f,-0.18750000f,0.85937500f,-0.14062500f,0.35937500f,-0.09375000f,-0.60937500f,0.40625000f,-0.14062500f,0.37500000f,0.37500000f,0.84375000f,0.03125000f,0.54687500f,0.60937500f,0.32812500f,-0.53125000f,-0.04687500f,-0.75000000f,0.37500000f,0.59375000f,-0.42187500f,-0.26562500f,-0.25000000f,0.78125000f,0.29687500f,0.04687500f,0.20312500f,0.26562500f,0.35937500f,-0.76562500f,0.81250000f,-0.01562500f,-1.00000000f,0.90625000f,-0.73437500f,-0.29687500f,0.21875000f,0.01562500f,0.00000000f,-0.28125000f,0.85937500f,0.23437500f,0.54687500f,-0.90625000f,0.90625000f,-0.92187500f,-0.85937500f,0.73437500f,-0.34375000f,-0.04687500f,-0.53125000f,0.42187500f,-0.95312500f,0.23437500f,0.12500000f,0.92187500f,0.32812500f,-0.62500000f,-0.45312500f,-0.57812500f,-0.35937500f,0.35937500f,0.84375000f,-0.54687500f,-0.23437500f,-0.84375000f,-0.34375000f,0.20312500f,-0.39062500f,-0.46875000f,-0.43750000f,0.10937500f,-0.95312500f,0.64062500f,-0.32812500f,0.09375000f,0.00000000f,-0.65625000f,0.42187500f,-0.07812500f,-0.54687500f,0.17187500f,0.35937500f,0.28125000f,-0.46875000f,0.45312500f,-0.23437500f,0.12500000f,-0.96875000f,0.84375000f,-0.37500000f,0.31250000f,0.68750000f,-0.01562500f,-0.79687500f,0.85937500f,0.06250000f,-0.06250000f,-0.85937500f,0.54687500f,-0.03125000f,0.37500000f,-0.06250000f,0.40625000f,0.20312500f,-0.59375000f,0.07812500f,-0.87500000f,0.07812500f,0.65625000f,0.17187500f,0.70312500f,-0.03125000f,-0.79687500f,0.01562500f,-0.60937500f,0.35937500f,0.04687500f,0.37500000f,-0.45312500f,-0.82812500f,0.18750000f,-0.37500000f,-0.53125000f,0.00000000f,-0.06250000f,-0.57812500f,0.00000000f,-0.10937500f,-0.45312500f,0.32812500f,0.93750000f,0.48437500f,0.00000000f,-0.96875000f,0.98437500f,0.95312500f,-0.29687500f,0.98437500f,-0.92187500f,0.39062500f,-0.26562500f,-0.73437500f,-0.85937500f,0.12500000f,0.20312500f,0.29687500f,-0.46875000f,0.03125000f,0.25000000f,-0.32812500f,0.68750000f,-0.37500000f,0.39062500f,-0.75000000f,-0.07812500f,-0.48437500f,-0.32812500f,-0.43750000f,-0.75000000f,0.04687500f,0.06250000f,0.07812500f,-0.65625000f,-0.67187500f,-0.85937500f,-0.23437500f,-0.78125000f,0.48437500f,-0.76562500f,0.76562500f,-0.85937500f,0.35937500f,0.42187500f,1.00000000f,0.20312500f,0.84375000f,0.82812500f,-0.15625000f,0.96875000f,0.12500000f,0.82812500f,-0.03125000f,0.10937500f,-0.68750000f,-0.04687500f,-0.59375000f,0.73437500f,0.78125000f,0.81250000f,0.06250000f,-0.20312500f,-0.50000000f,-0.43750000f,-0.04687500f,-0.81250000f,0.96875000f,-0.71875000f,0.95312500f,0.18750000f,-0.62500000f,0.43750000f,0.00000000f,-0.76562500f,0.64062500f,-0.12500000f,-0.73437500f,-0.28125000f,0.64062500f,-0.96875000f,-0.85937500f,0.65625000f,-0.10937500f,-0.54687500f,0.15625000f,-0.39062500f,-0.25000000f,-0.81250000f,0.73437500f,-0.50000000f,-0.32812500f,0.93750000f,0.35937500f,-0.25000000f,0.73437500f,0.34375000f,-0.46875000f,0.57812500f,-0.04687500f,-0.96875000f,-0.92187500f,0.03125000f,-0.68750000f,0.43750000f,0.12500000f,0.68750000f,-0.28125000f,-0.78125000f,-0.17187500f,0.40625000f,0.57812500f,-0.53125000f,0.06250000f,0.87500000f,-0.70312500f,-0.39062500f,0.60937500f,-0.42187500f,0.60937500f,-0.53125000f,0.98437500f,0.17187500f,-0.32812500f,0.93750000f,-0.14062500f,0.56250000f,-0.12500000f,-0.85937500f,-0.23437500f,-0.10937500f,0.06250000f,0.95312500f,-0.59375000f,-0.46875000f,0.92187500f,0.23437500f,0.10937500f,0.98437500f,0.01562500f,-0.32812500f,0.07812500f,0.03125000f,0.09375000f,0.56250000f,0.32812500f,-0.25000000f,-0.60937500f,-0.90625000f,0.14062500f,-0.45312500f,0.42187500f,-0.62500000f,0.12500000f,0.93750000f,0.92187500f,0.26562500f,0.04687500f,-0.26562500f,0.18750000f,0.81250000f,0.26562500f,0.51562500f,0.28125000f,-0.59375000f,0.20312500f,0.17187500f,0.95312500f,-0.71875000f,-0.23437500f,0.68750000f,0.62500000f,-0.51562500f,-0.12500000f,-0.76562500f,0.53125000f,0.37500000f,-0.46875000f,-0.40625000f,0.51562500f,-0.78125000f,-0.42187500f,0.10937500f,-0.87500000f,0.45312500f,0.06250000f,0.84375000f,-0.64062500f,0.17187500f,0.03125000f,0.43750000f,0.73437500f,0.15625000f,0.45312500f,0.39062500f,0.96875000f,0.82812500f,-0.68750000f,0.68750000f,-0.89062500f,-0.46875000f,0.48437500f,-0.21875000f,-0.92187500f,0.20312500f,0.84375000f,0.28125000f,0.56250000f,0.85937500f,0.43750000f,-0.51562500f,0.65625000f,0.65625000f,0.57812500f,0.03125000f,-0.35937500f,-0.35937500f,0.84375000f,0.48437500f,0.03125000f,0.15625000f,-0.32812500f,-0.32812500f,-0.96875000f,0.46875000f,-0.73437500f,-0.39062500f,0.67187500f,-0.90625000f,-0.15625000f,0.06250000f,-0.39062500f,0.12500000f,-0.84375000f,0.59375000f,0.95312500f,-0.75000000f,0.54687500f,-0.17187500f,-0.31250000f,-0.06250000f,0.68750000f,0.26562500f,-0.51562500f,-0.70312500f,-0.09375000f,0.26562500f,-0.56250000f,0.18750000f,0.64062500f,0.48437500f,0.20312500f,-0.65625000f,0.21875000f,1.00000000f,0.15625000f,-1.00000000f,0.07812500f,0.18750000f,0.29687500f,0.79687500f,-0.23437500f,0.03125000f,0.75000000f,0.62500000f,0.32812500f,0.84375000f,-0.59375000f,-0.25000000f,-0.68750000f,0.68750000f,-0.96875000f,0.84375000f,-0.82812500f,0.78125000f,0.34375000f,-0.76562500f,0.28125000f,-0.34375000f,0.29687500f,-0.06250000f,-0.81250000f,-0.45312500f,-0.54687500f,-0.87500000f,0.62500000f,0.28125000f,0.92187500f,-0.89062500f,0.09375000f,0.65625000f,0.73437500f,-0.29687500f,-0.76562500f,0.25000000f,-0.23437500f,0.14062500f,-0.03125000f,0.84375000f,-0.96875000f,-0.82812500f,0.79687500f,-0.26562500f,0.93750000f,-0.12500000f,0.03125000f,-0.32812500f,-1.00000000f,-0.85937500f,-0.45312500f,0.79687500f,0.46875000f,-0.82812500f,-0.84375000f,0.45312500f,0.82812500f,-0.46875000f,-0.09375000f,-0.62500000f,0.14062500f,0.45312500f,-0.89062500f,-0.56250000f,0.54687500f,0.06250000f,-0.53125000f,-0.98437500f,0.59375000f,-0.01562500f,0.78125000f,-0.04687500f,0.03125000f,-0.09375000f,-0.07812500f,0.03125000f,0.48437500f,-0.42187500f,-0.07812500f,0.09375000f,0.29687500f,-0.89062500f,-0.81250000f,0.76562500f,-0.01562500f,0.28125000f,-0.14062500f,-0.09375000f,0.56250000f,0.78125000f,0.96875000f,-0.78125000f,-0.48437500f,-0.65625000f,0.79687500f,-0.59375000f,-0.76562500f,0.07812500f,0.43750000f,-0.45312500f,-0.79687500f,0.09375000f,0.48437500f,-0.04687500f,-0.73437500f,-0.89062500f,0.14062500f,-0.90625000f,0.10937500f,-0.42187500f,-0.56250000f,-0.15625000f,-0.26562500f,-0.40625000f,-0.95312500f,-0.56250000f,0.85937500f,0.64062500f,0.32812500f,-0.68750000f,-0.46875000f,0.92187500f,-0.82812500f,0.59375000f,0.85937500f,-0.18750000f,-0.23437500f,-0.03125000f,-0.67187500f,0.48437500f,0.59375000f,0.95312500f,-0.18750000f,-0.87500000f,0.71875000f,0.35937500f,-0.65625000f,0.39062500f,0.10937500f,0.06250000f,0.56250000f,-0.23437500f,-0.46875000f,-0.20312500f,0.59375000f,0.39062500f,-0.96875000f,-0.26562500f,-0.93750000f,-0.06250000f,0.15625000f,-0.65625000f,0.03125000f,-0.01562500f,-0.51562500f,-0.68750000f,-0.01562500f,0.89062500f,-0.31250000f,0.79687500f,-0.31250000f,0.89062500f,0.31250000f,-0.12500000f,0.18750000f,-0.43750000f,0.62500000f,0.12500000f,-0.82812500f,-0.81250000f,-0.46875000f,-0.51562500f,0.40625000f,-0.07812500f,0.25000000f,-1.00000000f,0.43750000f,0.76562500f,0.60937500f,0.67187500f,0.40625000f,-0.42187500f,-0.73437500f,-0.56250000f,-0.12500000f,-0.50000000f,0.46875000f,0.06250000f,0.87500000f,-0.68750000f,0.65625000f,-0.35937500f,0.51562500f,0.03125000f,-0.54687500f,0.37500000f,-0.78125000f,0.43750000f,0.14062500f,0.15625000f,-0.07812500f,0.25000000f,0.68750000f,0.31250000f,0.37500000f,-0.78125000f,-0.73437500f,-0.68750000f,-0.40625000f,0.95312500f,-0.75000000f,-0.89062500f,-0.73437500f,0.48437500f,-0.17187500f,0.32812500f,0.71875000f,-0.62500000f,-0.25000000f,-0.04687500f,0.28125000f,-0.81250000f,-0.25000000f,0.03125000f,0.29687500f,-0.40625000f,0.64062500f,0.84375000f,-0.40625000f,0.92187500f,-0.35937500f,0.87500000f,0.25000000f,0.34375000f,-0.04687500f,0.85937500f,0.81250000f,0.84375000f,-0.70312500f,0.10937500f,-0.21875000f,-0.48437500f,0.50000000f,-0.29687500f,0.75000000f,-0.50000000f,0.23437500f,0.03125000f,0.37500000f,0.60937500f,0.34375000f,0.79687500f,-0.71875000f,-0.50000000f,0.84375000f,-0.29687500f,0.40625000f,-0.85937500f,-0.29687500f,0.98437500f,0.14062500f,0.48437500f,-0.75000000f,0.18750000f,-0.75000000f,-0.62500000f,-0.18750000f,-0.92187500f,0.81250000f,-0.64062500f,0.71875000f,-0.82812500f,-0.53125000f,-0.70312500f,0.15625000f,-0.53125000f,0.09375000f,-0.45312500f,0.79687500f,0.14062500f,0.96875000f,-0.28125000f,0.32812500f,0.92187500f,0.78125000f,-0.07812500f,0.79687500f,0.85937500f,0.06250000f,0.98437500f,-0.14062500f,-0.53125000f,-0.92187500f,0.01562500f,-0.20312500f,0.25000000f,-0.70312500f,-0.89062500f,0.84375000f,-0.64062500f,0.67187500f,0.75000000f,-0.35937500f,-0.59375000f,0.68750000f,0.71875000f,-0.45312500f,0.45312500f,0.31250000f,0.37500000f,0.53125000f,-0.68750000f,0.12500000f,0.73437500f,-0.67187500f,0.84375000f,0.90625000f,0.01562500f,-0.15625000f,-0.07812500f,-0.73437500f,-0.73437500f,0.54687500f,0.34375000f,-0.68750000f,0.56250000f,-1.00000000f,0.00000000f,0.32812500f,-0.95312500f,0.34375000f,0.43750000f,0.70312500f,-0.93750000f,-0.40625000f,0.00000000f,0.06250000f,0.26562500f,0.20312500f,0.09375000f,-0.15625000f,0.18750000f,-0.51562500f,0.84375000f,0.07812500f,-0.29687500f,-0.03125000f,0.84375000f,0.20312500f,-0.57812500f,0.45312500f,-0.35937500f,-0.54687500f,-0.37500000f,0.43750000f,0.34375000f,0.43750000f,-0.93750000f,-0.18750000f,-0.42187500f,-0.75000000f,-0.15625000f,-0.43750000f,-0.92187500f,-0.12500000f,-0.56250000f,-0.92187500f,0.54687500f,0.84375000f,0.39062500f,0.23437500f,-0.37500000f,0.67187500f,-0.65625000f,0.76562500f,0.92187500f,-0.18750000f,-0.90625000f,-0.34375000f,0.87500000f,-0.46875000f,0.20312500f,-0.67187500f,-0.15625000f,0.75000000f,-0.23437500f,0.40625000f,0.10937500f,0.37500000f,-0.93750000f,-0.75000000f,-0.07812500f,-0.76562500f,-0.95312500f,0.28125000f,-0.26562500f,-0.98437500f,0.04687500f,-0.76562500f,-0.39062500f,-0.03125000f,0.79687500f,0.87500000f,0.96875000f,-0.04687500f,-0.50000000f,0.31250000f,0.06250000f,-0.70312500f,-0.25000000f,-0.12500000f,-0.64062500f,-0.01562500f,0.40625000f,0.62500000f,0.78125000f,-0.10937500f,0.54687500f,0.67187500f,0.73437500f,0.71875000f,-0.76562500f,0.70312500f,0.26562500f,-0.09375000f,0.12500000f,0.26562500f,-0.12500000f,-0.54687500f,0.46875000f,0.25000000f,0.81250000f,0.10937500f,0.78125000f,-0.40625000f,-0.04687500f,0.18750000f,-0.10937500f,0.71875000f,0.03125000f,0.18750000f,0.90625000f,-0.93750000f,-0.87500000f,-0.60937500f,0.84375000f,0.68750000f,0.68750000f,-0.56250000f,0.87500000f,-0.09375000f,-0.23437500f,-0.92187500f,-0.89062500f,-0.59375000f,0.23437500f,0.23437500f,0.64062500f,-0.71875000f,0.65625000f,0.45312500f,-0.25000000f,0.60937500f,0.35937500f,-0.95312500f,1.00000000f,0.60937500f,0.62500000f,0.00000000f,0.85937500f,0.75000000f,0.60937500f,0.76562500f,-0.48437500f,0.73437500f,0.34375000f,-0.04687500f,-0.96875000f,0.81250000f,0.35937500f,0.73437500f,0.04687500f,0.54687500f,-0.14062500f,0.56250000f,-0.62500000f,0.35937500f,-0.06250000f,0.15625000f,0.14062500f,0.06250000f,0.60937500f,-0.17187500f,0.07812500f,0.50000000f,0.65625000f,-0.71875000f,0.53125000f,0.17187500f,-0.45312500f,0.90625000f,0.50000000f,-0.56250000f,0.37500000f,-0.20312500f,-0.78125000f,0.79687500f,0.82812500f,0.79687500f,-0.67187500f,-0.96875000f,0.43750000f,0.00000000f,0.95312500f,-0.96875000f,-0.23437500f,-0.21875000f,0.48437500f,0.87500000f,0.85937500f,-0.09375000f,0.84375000f,-0.48437500f,-0.96875000f,0.43750000f,0.28125000f,0.78125000f,-0.62500000f,-0.79687500f,-0.35937500f,-0.04687500f,-0.81250000f,-0.01562500f,0.07812500f,-0.17187500f,0.70312500f,0.01562500f,0.85937500f,-0.18750000f,0.17187500f,-0.98437500f,0.07812500f,-0.62500000f,0.34375000f,-0.32812500f,-0.42187500f,0.42187500f,0.17187500f,0.50000000f,0.07812500f,-0.18750000f,0.50000000f,-0.82812500f,0.17187500f,-0.67187500f,0.03125000f,-0.35937500f,0.12500000f,-0.71875000f,-0.25000000f,0.21875000f,0.50000000f,0.28125000f,0.57812500f,-0.54687500f,-0.15625000f,0.03125000f,0.15625000f,-0.45312500f,0.40625000f,-1.00000000f,-0.42187500f,-0.40625000f,0.65625000f,-0.62500000f,-0.95312500f,0.56250000f,0.42187500f,-0.15625000f,0.79687500f,1.00000000f,0.00000000f,-0.79687500f,0.84375000f,0.89062500f,-0.26562500f,0.03125000f,-0.54687500f,0.15625000f,-0.31250000f,-0.53125000f,0.51562500f,-0.09375000f,-0.40625000f,0.26562500f,-0.48437500f,-0.53125000f,0.06250000f,0.42187500f,-0.93750000f,-0.34375000f,-0.34375000f,0.23437500f,0.01562500f,-0.20312500f,-0.21875000f,-0.04687500f,0.85937500f,0.21875000f,-0.79687500f,-0.92187500f,-0.89062500f,0.21875000f,-0.59375000f,-0.71875000f,0.12500000f,0.20312500f,-0.48437500f,0.62500000f,0.90625000f,0.01562500f,-0.71875000f,-0.95312500f,-0.90625000f,0.01562500f,-0.31250000f,0.96875000f,-0.39062500f,0.07812500f,0.53125000f,0.96875000f,0.26562500f,0.20312500f,0.40625000f,-0.56250000f,-1.00000000f,0.37500000f,0.75000000f,0.09375000f,0.81250000f,0.90625000f,-0.57812500f,0.23437500f,0.92187500f,0.12500000f,-0.25000000f,-0.07812500f,-0.03125000f,-0.85937500f,-0.90625000f,-0.35937500f,0.89062500f,-0.70312500f,0.96875000f,-1.00000000f,0.84375000f,0.03125000f,-0.84375000f,0.89062500f,-0.92187500f,0.04687500f,0.20312500f,0.17187500f,0.51562500f,-0.34375000f,0.04687500f,0.89062500f,0.07812500f,0.26562500f,0.29687500f,0.65625000f,0.73437500f,-0.29687500f,0.96875000f,0.50000000f,-0.95312500f,0.92187500f,0.98437500f,0.73437500f,-0.59375000f,-0.76562500f,-0.50000000f,-0.65625000f,-0.37500000f,-0.89062500f,-0.29687500f,-0.15625000f,0.51562500f,-0.53125000f,-0.56250000f,-0.28125000f,-0.35937500f,-0.10937500f,-0.29687500f,-0.34375000f,-0.35937500f,-0.65625000f,-0.07812500f,0.89062500f,0.75000000f,-0.37500000f,0.15625000f,0.34375000f,-0.06250000f,0.01562500f,0.23437500f,0.56250000f,0.89062500f,0.65625000f,0.17187500f,0.87500000f,-0.39062500f,-0.17187500f,0.57812500f,0.56250000f,0.75000000f,0.32812500f,0.50000000f,-0.51562500f,-0.09375000f,0.00000000f,0.48437500f,0.67187500f,-0.46875000f,-0.65625000f,0.53125000f,0.12500000f,-0.31250000f,-0.40625000f,-0.84375000f,0.53125000f,-0.04687500f,0.43750000f,-0.73437500f,-0.03125000f,0.31250000f,0.81250000f,0.23437500f,0.23437500f,-0.03125000f,-0.46875000f,-0.23437500f,-0.15625000f,0.09375000f,-0.62500000f,0.65625000f,-0.42187500f,0.18750000f,-0.64062500f,-0.76562500f,0.98437500f,-0.35937500f,-0.28125000f,-0.70312500f,-0.73437500f,-0.85937500f,-0.57812500f,-0.50000000f,-0.35937500f,0.07812500f,-0.87500000f,0.04687500f,-0.26562500f,0.73437500f,-0.87500000f,-0.42187500f,0.54687500f,0.65625000f,0.84375000f,0.64062500f,-0.85937500f,-0.89062500f,-0.14062500f,-0.64062500f,-0.03125000f,-0.28125000f,0.82812500f,-0.70312500f,0.81250000f,0.93750000f,0.96875000f,-0.17187500f,-0.01562500f,0.65625000f,0.87500000f,-0.23437500f,-0.81250000f,0.39062500f,-0.45312500f,-0.75000000f,-0.96875000f,1.00000000f,0.62500000f,-0.32812500f,-0.73437500f,-0.50000000f,0.76562500f,-0.76562500f,0.32812500f,0.95312500f,-0.50000000f,0.70312500f,-0.31250000f,0.15625000f,-0.54687500f,-0.35937500f,0.89062500f,0.09375000f,-0.96875000f,0.84375000f,-0.06250000f,0.31250000f,-0.50000000f,0.85937500f,0.67187500f,0.67187500f,0.76562500f,0.25000000f,0.48437500f,0.09375000f,-0.26562500f,0.43750000f,-0.04687500f,-0.87500000f,0.76562500f,-0.40625000f,0.21875000f,-0.82812500f,0.56250000f,-0.23437500f,-0.48437500f,0.85937500f,-0.37500000f,0.96875000f,-0.71875000f,0.62500000f,0.42187500f,0.29687500f,-0.96875000f,-0.73437500f,-0.87500000f,-1.00000000f,-0.51562500f,0.90625000f,0.95312500f,-0.96875000f,0.85937500f,-0.09375000f,-0.87500000f,-0.46875000f,-0.76562500f,-0.57812500f,-0.20312500f,0.32812500f,-0.01562500f,0.96875000f,0.45312500f,-0.35937500f,0.03125000f,0.76562500f,-0.93750000f,0.79687500f,0.95312500f,0.28125000f,0.45312500f,-0.10937500f,-0.56250000f,-0.56250000f,0.01562500f,0.03125000f,0.00000000f,-0.18750000f,-0.93750000f,-0.31250000f,-0.34375000f,-0.32812500f,0.26562500f,-0.42187500f,0.34375000f,0.76562500f,0.68750000f,0.96875000f,0.84375000f,0.76562500f,0.39062500f,-0.31250000f,0.29687500f,0.54687500f,0.29687500f,0.89062500f,-0.95312500f,-0.48437500f,-0.15625000f,-0.64062500f,-0.84375000f,0.42187500f,-0.81250000f,0.93750000f,0.73437500f,-0.64062500f,-0.26562500f,0.45312500f,-0.95312500f,0.93750000f,0.40625000f,-0.45312500f,-0.93750000f,-0.15625000f,-0.73437500f,0.01562500f,0.50000000f,-0.12500000f,-0.96875000f,0.37500000f,0.79687500f,0.92187500f,-0.10937500f,-0.90625000f,-0.62500000f,0.53125000f,0.39062500f,0.92187500f,-0.95312500f,0.65625000f,-0.17187500f,0.93750000f,-0.64062500f,0.37500000f,0.26562500f,-0.62500000f,-0.75000000f,-0.81250000f,0.37500000f,-0.20312500f,0.00000000f,0.79687500f,-0.56250000f,0.59375000f,1.00000000f,-0.50000000f,0.40625000f,-0.95312500f,-0.87500000f,0.92187500f,0.28125000f,0.98437500f,0.70312500f,-0.95312500f,-0.35937500f,-0.96875000f,0.51562500f,-0.04687500f,-0.78125000f,-0.93750000f,0.06250000f,-0.70312500f,0.06250000f,-0.42187500f,-0.51562500f,-0.65625000f,-1.00000000f,-0.01562500f,0.54687500f,-0.25000000f,0.09375000f,0.87500000f,0.07812500f,0.68750000f,0.20312500f,0.31250000f,-0.28125000f,0.57812500f,-0.14062500f,-0.93750000f,-0.78125000f,0.35937500f,-0.18750000f,-0.07812500f,0.60937500f,-0.18750000f,-0.90625000f,0.35937500f,-0.28125000f,0.23437500f,-0.87500000f,-0.93750000f,-0.06250000f,-0.18750000f,0.12500000f,0.96875000f,-0.01562500f,-0.85937500f,0.29687500f,-0.42187500f,-0.43750000f,-0.56250000f,-0.93750000f,0.96875000f,-0.29687500f,0.29687500f,0.73437500f,0.01562500f,-0.35937500f,0.28125000f,-0.65625000f,-0.18750000f,-0.43750000f,-0.10937500f,0.35937500f,-0.01562500f,-0.84375000f,0.28125000f,0.67187500f,0.25000000f,0.50000000f,0.23437500f,-0.81250000f,0.10937500f,-0.56250000f,0.54687500f,0.07812500f,-0.76562500f,0.14062500f,-0.17187500f,0.93750000f,-0.28125000f,-0.78125000f,-0.68750000f,0.45312500f,0.09375000f,0.75000000f,0.50000000f,0.01562500f,-0.23437500f,-0.68750000f,0.57812500f,0.73437500f,-0.46875000f,-0.82812500f,0.40625000f,-0.15625000f,0.81250000f,-0.40625000f,-0.25000000f,-0.85937500f,-0.71875000f,0.71875000f,0.78125000f,0.90625000f,0.87500000f,-0.90625000f,0.64062500f,0.40625000f,-0.34375000f,0.17187500f,0.06250000f,0.87500000f,0.48437500f,-0.34375000f,1.00000000f,0.10937500f,-0.51562500f,-0.73437500f,0.81250000f,-0.95312500f,0.53125000f,-0.46875000f,0.20312500f,0.75000000f,-0.87500000f,-0.85937500f,0.71875000f,0.37500000f,-0.59375000f,-0.06250000f,-0.64062500f,-0.70312500f,0.40625000f,-0.12500000f,0.98437500f,0.03125000f,-0.93750000f,-0.23437500f,-0.20312500f,0.34375000f,0.10937500f,0.43750000f,-0.34375000f,-0.26562500f,-0.75000000f,0.48437500f,0.01562500f,0.81250000f,0.62500000f,0.31250000f,-0.60937500f,-0.40625000f,-0.87500000f,-0.87500000f,-0.42187500f,-0.70312500f,-0.89062500f,0.50000000f,-0.21875000f,0.50000000f,-0.87500000f,-0.82812500f,-0.31250000f,0.71875000f,0.90625000f,0.17187500f,0.45312500f,-0.67187500f,-0.54687500f,-0.64062500f,0.79687500f,-0.71875000f,0.73437500f,0.45312500f,-0.32812500f,-0.67187500f,0.98437500f,-0.85937500f,-0.01562500f,0.75000000f,-0.40625000f,-0.84375000f,0.04687500f,0.70312500f,0.45312500f,-0.89062500f,-0.54687500f,-0.17187500f,-0.59375000f,0.85937500f,-0.31250000f,0.46875000f,-0.29687500f,0.26562500f,-0.06250000f,-0.70312500f,0.79687500f,0.62500000f,-0.84375000f,0.07812500f,0.96875000f,0.59375000f,-0.65625000f,0.26562500f,0.01562500f,0.23437500f,-0.50000000f,-0.32812500f,-0.78125000f,-0.59375000f,0.76562500f,-0.60937500f,0.10937500f,0.35937500f,-0.62500000f,0.17187500f,0.67187500f,-0.10937500f,0.25000000f,0.21875000f,0.82812500f,0.84375000f,0.92187500f,0.42187500f,-0.57812500f,0.39062500f,0.78125000f,-0.71875000f,0.32812500f,0.64062500f,-0.64062500f,-0.59375000f,0.48437500f,0.82812500f,-0.87500000f,0.40625000f,0.37500000f,-0.57812500f,0.12500000f,-0.10937500f,-0.03125000f,-0.68750000f,-0.70312500f,0.48437500f,0.14062500f,-0.78125000f,0.60937500f,0.23437500f,0.79687500f,0.14062500f,-0.68750000f,0.95312500f,0.14062500f,0.01562500f,-0.84375000f,-0.76562500f,-0.15625000f,-0.23437500f,0.59375000f,-0.14062500f,-0.75000000f,0.25000000f,0.04687500f,-0.28125000f,-0.03125000f,0.75000000f,-0.34375000f,-0.42187500f,-0.34375000f,-0.20312500f,0.17187500f,0.64062500f,-0.43750000f,0.79687500f,-0.25000000f,-0.03125000f,-0.56250000f,0.23437500f,0.32812500f,-0.03125000f,-0.01562500f,0.87500000f,-1.00000000f,-0.54687500f,-0.43750000f,0.07812500f,-0.82812500f,-0.48437500f,-0.82812500f,0.04687500f,-0.76562500f,-0.45312500f,0.65625000f,0.10937500f,-0.20312500f,0.21875000f,0.32812500f,0.96875000f,0.04687500f,0.87500000f,-0.35937500f,0.31250000f,-0.85937500f,0.29687500f,0.56250000f,-0.17187500f,0.76562500f,0.09375000f,0.09375000f,0.75000000f,0.45312500f,0.64062500f,-0.04687500f,-0.90625000f,0.87500000f,0.20312500f,-0.12500000f,0.87500000f,-0.20312500f,0.48437500f,0.35937500f,0.32812500f,0.03125000f,0.76562500f,-0.57812500f,-0.59375000f,0.82812500f,0.51562500f,-0.68750000f,-0.62500000f,-0.31250000f,-0.35937500f,0.95312500f,-0.40625000f,-0.03125000f,-0.96875000f,-1.00000000f,0.01562500f,0.09375000f,0.84375000f,-0.87500000f,-0.81250000f,0.31250000f,-0.51562500f,-0.51562500f,0.54687500f,-0.23437500f,0.17187500f,-0.04687500f,0.56250000f,-0.32812500f,-0.89062500f,0.10937500f,0.43750000f,-0.23437500f,-0.67187500f,-0.78125000f,-0.60937500f,-0.23437500f,0.31250000f,-0.95312500f,0.98437500f,-0.96875000f,0.75000000f,0.70312500f,0.70312500f,-0.96875000f,-0.14062500f,0.93750000f,0.48437500f,-0.82812500f,0.84375000f,0.84375000f,-0.06250000f,0.42187500f,-0.01562500f,0.23437500f,-0.84375000f,1.00000000f,-0.84375000f,0.57812500f,-0.54687500f,0.17187500f,0.73437500f,0.87500000f,-0.45312500f,-0.04687500f,-0.39062500f,0.60937500f,0.34375000f,0.76562500f,-0.62500000f,0.43750000f,0.96875000f,0.84375000f,-0.62500000f,0.51562500f,-0.21875000f,0.65625000f,-0.59375000f,-0.18750000f,0.90625000f,0.45312500f,0.89062500f,0.04687500f,-0.17187500f,-0.28125000f,0.14062500f,0.29687500f,-0.46875000f,-0.43750000f,0.57812500f,-0.96875000f,0.28125000f,-0.20312500f,-0.62500000f,-0.68750000f,0.31250000f,0.39062500f,0.98437500f,0.57812500f,-0.57812500f,-0.78125000f,0.42187500f,0.81250000f,-0.95312500f,-0.25000000f,-0.50000000f,-0.18750000f,-0.39062500f,-0.40625000f,-0.29687500f,-0.70312500f,0.84375000f,0.40625000f,-0.06250000f,0.60937500f,-0.12500000f,-0.20312500f,0.84375000f,-0.53125000f,0.85937500f,-0.96875000f,0.84375000f,-0.03125000f,0.29687500f,-0.53125000f,-0.40625000f,0.92187500f,-0.48437500f,0.07812500f,0.98437500f,0.76562500f,0.79687500f,-0.81250000f,0.54687500f,0.01562500f,0.03125000f,0.34375000f,0.06250000f,-0.73437500f,0.01562500f,0.09375000f,-0.92187500f,-0.35937500f,-0.64062500f,-0.64062500f,0.10937500f,-0.82812500f,0.39062500f,-0.20312500f,-0.20312500f,0.15625000f,0.09375000f,-0.70312500f,0.26562500f,-0.28125000f,-0.46875000f,0.40625000f,0.64062500f,0.67187500f,0.12500000f,-0.68750000f,0.50000000f,-0.50000000f,0.79687500f,-0.15625000f,-0.26562500f,0.73437500f,0.92187500f,-0.48437500f,0.15625000f,-0.93750000f,-0.21875000f,0.95312500f,-0.37500000f,-0.45312500f,0.78125000f,0.78125000f,-0.70312500f,0.48437500f,-0.75000000f,0.89062500f,-0.14062500f,-0.23437500f,-0.17187500f,0.54687500f,-0.81250000f,0.01562500f,-0.78125000f,0.26562500f,-0.85937500f,-0.75000000f,0.40625000f,-0.93750000f,0.79687500f,-0.09375000f,-0.35937500f,-0.43750000f,-0.15625000f,0.50000000f,-0.06250000f,-0.59375000f,0.85937500f,0.39062500f,-0.06250000f,0.37500000f,-0.64062500f,-0.68750000f,0.31250000f,0.96875000f,0.56250000f,0.25000000f,0.48437500f,-0.14062500f,0.20312500f,1.00000000f,-0.67187500f,-0.46875000f,0.17187500f,0.09375000f,0.10937500f,0.85937500f,-0.10937500f,-0.71875000f,-0.51562500f,0.85937500f,-0.26562500f,0.71875000f,0.81250000f,-0.93750000f,-0.50000000f,-0.54687500f,0.84375000f,-0.60937500f,-0.62500000f,0.51562500f,0.93750000f,-0.26562500f,0.15625000f,0.56250000f,0.71875000f,0.51562500f,-0.84375000f,-0.50000000f,-0.28125000f,-0.81250000f,-0.34375000f,-0.09375000f,-0.03125000f,-0.25000000f,0.07812500f,-0.07812500f,0.78125000f,0.90625000f,-0.14062500f,0.17187500f,-0.95312500f,-0.21875000f,0.67187500f,-0.96875000f,0.25000000f,1.00000000f,0.07812500f,0.15625000f,-0.06250000f,0.71875000f,-0.87500000f,-0.12500000f,0.07812500f,-0.35937500f,-0.39062500f,0.17187500f,-0.57812500f,-0.46875000f,0.76562500f,-0.46875000f,0.57812500f,-0.65625000f,0.00000000f,-0.40625000f,0.34375000f,-0.48437500f,0.12500000f,0.75000000f,-0.04687500f,0.23437500f,0.42187500f,0.50000000f,0.67187500f,0.68750000f,0.73437500f,0.95312500f,-0.71875000f,-0.10937500f,-0.87500000f,-0.42187500f,0.48437500f,0.60937500f,-0.12500000f,-0.67187500f,-0.31250000f,-0.65625000f,-0.95312500f,-0.51562500f,0.10937500f,0.81250000f,0.54687500f,0.59375000f,-0.48437500f,-0.81250000f,-0.54687500f,0.07812500f,-0.82812500f,0.07812500f,1.00000000f,-0.67187500f,0.20312500f,0.59375000f,-0.18750000f,-0.50000000f,-0.46875000f,0.25000000f,0.20312500f,0.37500000f,-0.85937500f,0.46875000f,-0.79687500f,0.57812500f,0.71875000f,-0.07812500f,-0.79687500f,-0.29687500f,0.78125000f,0.64062500f,-0.15625000f,-0.32812500f,-0.62500000f,0.40625000f,-0.71875000f,-0.46875000f,0.14062500f,0.20312500f,-0.78125000f,0.43750000f,0.01562500f,0.60937500f,-0.82812500f,-0.50000000f,-0.34375000f,0.26562500f,-0.84375000f,-0.32812500f,0.01562500f,-0.76562500f,-0.84375000f,-0.25000000f,-0.34375000f,-0.51562500f,0.57812500f,0.14062500f,-0.26562500f,-0.43750000f,-0.31250000f,0.73437500f,0.62500000f,0.76562500f,-0.53125000f,-0.29687500f,-0.82812500f,-0.60937500f,-0.03125000f,-0.32812500f,-0.76562500f,0.09375000f,0.76562500f,0.92187500f,0.35937500f,0.29687500f,0.75000000f,-0.98437500f,-0.10937500f,-0.73437500f,0.10937500f,-0.53125000f,-0.56250000f,0.35937500f,0.71875000f,-0.26562500f,-0.68750000f,0.28125000f,0.15625000f,0.10937500f,-0.62500000f,0.65625000f,-0.21875000f,0.81250000f,-0.10937500f,0.25000000f,0.68750000f,-0.81250000f,-0.64062500f,0.35937500f,0.01562500f,-0.43750000f,0.76562500f,0.34375000f,-0.57812500f,0.40625000f,0.56250000f,-0.65625000f,0.98437500f,-0.68750000f,0.56250000f,0.46875000f,0.90625000f,0.06250000f,0.68750000f,0.75000000f,0.26562500f,0.14062500f,0.34375000f,-0.81250000f,0.25000000f,0.76562500f,0.85937500f,0.31250000f,-0.34375000f,0.95312500f,-0.95312500f,-0.09375000f,-0.78125000f,-0.89062500f,0.17187500f,-0.57812500f,0.82812500f,0.25000000f,-0.98437500f,0.68750000f,0.92187500f,-0.15625000f,0.46875000f,-0.18750000f,-0.93750000f,0.42187500f,0.85937500f,0.01562500f,0.78125000f,0.60937500f,-0.78125000f,-0.28125000f,-0.89062500f,0.56250000f,0.34375000f,0.70312500f,0.89062500f,0.25000000f,0.21875000f,0.14062500f,-1.00000000f,-0.17187500f,0.25000000f,-0.21875000f,-0.89062500f,0.79687500f,-0.82812500f,0.76562500f,0.42187500f,0.73437500f,0.51562500f,-0.17187500f,-0.01562500f,-0.20312500f,0.01562500f,-0.04687500f,0.03125000f,0.42187500f,0.29687500f,-0.25000000f,0.31250000f,0.04687500f,-0.23437500f,0.14062500f,0.26562500f,-0.68750000f,-0.60937500f,-0.82812500f,0.18750000f,0.14062500f,0.53125000f,-0.42187500f,-0.01562500f,-0.18750000f,-0.26562500f,0.62500000f,0.26562500f,0.98437500f,0.93750000f,0.06250000f,0.81250000f,0.15625000f,-0.21875000f,-0.78125000f,0.18750000f,-0.17187500f,0.21875000f,-0.28125000f,-0.06250000f,0.06250000f,0.46875000f,-0.82812500f,0.96875000f,-0.14062500f,0.18750000f,0.84375000f,0.01562500f,-0.81250000f,0.26562500f,0.10937500f,-0.71875000f,0.45312500f,0.67187500f,0.67187500f,0.48437500f,-0.17187500f,0.98437500f,-0.17187500f,-0.35937500f,-0.50000000f,0.70312500f,-0.18750000f,0.89062500f,-0.50000000f,0.89062500f,0.84375000f,-0.03125000f,0.40625000f,-0.68750000f,-0.10937500f,-0.68750000f,0.62500000f,0.35937500f,0.92187500f,-0.68750000f,-0.17187500f,0.68750000f,0.17187500f,0.57812500f,0.34375000f,0.96875000f,-0.43750000f,0.50000000f,0.89062500f,0.75000000f,0.20312500f,-0.14062500f,-0.84375000f,-0.07812500f,-0.89062500f,0.45312500f,-0.53125000f,0.82812500f,-0.60937500f,-0.34375000f,-0.37500000f,0.12500000f,0.45312500f,-0.76562500f,-0.17187500f,0.78125000f,0.12500000f,0.76562500f,0.29687500f,0.42187500f,0.57812500f,-0.12500000f,-0.09375000f,0.29687500f,-0.35937500f,-0.98437500f,-0.54687500f,-1.00000000f,-0.85937500f,0.56250000f,0.20312500f,-0.82812500f,-0.26562500f,0.20312500f,0.71875000f,-0.50000000f,-0.32812500f,0.92187500f,0.20312500f,-0.81250000f,-0.59375000f,0.98437500f,0.78125000f,0.82812500f,-0.98437500f,-0.21875000f,0.10937500f,-0.37500000f,0.21875000f,0.45312500f,-0.95312500f,0.46875000f,0.64062500f,-0.62500000f,0.50000000f,-0.01562500f,-0.01562500f,-0.90625000f,-0.68750000f,0.85937500f,0.43750000f,-0.34375000f,-0.90625000f,0.68750000f,-0.76562500f,-0.95312500f,0.73437500f,-0.06250000f,-0.96875000f,0.79687500f,-0.68750000f,0.56250000f,0.12500000f,0.53125000f,-0.42187500f,-0.18750000f,-0.10937500f,-0.82812500f,0.85937500f,-0.37500000f,-0.73437500f,0.28125000f,-0.60937500f,-0.04687500f,0.45312500f,0.60937500f,0.79687500f,0.07812500f,-0.50000000f,0.90625000f,0.10937500f,-0.65625000f,-0.10937500f,0.75000000f,-0.64062500f,-0.18750000f,0.64062500f,0.18750000f,-0.64062500f,0.35937500f,0.85937500f,0.12500000f,0.70312500f,-0.56250000f,-0.04687500f,-0.70312500f,-0.43750000f,0.71875000f,0.85937500f,-0.96875000f,-0.96875000f,-0.71875000f,-0.64062500f,-0.17187500f,-0.28125000f,0.45312500f,0.03125000f,-0.17187500f,0.39062500f,-0.17187500f,0.43750000f,0.20312500f,-0.40625000f,-0.79687500f,0.21875000f,-0.82812500f,-0.81250000f,-0.53125000f,-0.64062500f,0.51562500f,-0.14062500f,0.67187500f,-0.60937500f,0.62500000f,-0.14062500f,-0.92187500f,-0.75000000f,-0.18750000f,0.48437500f,-0.62500000f,0.01562500f,-0.90625000f,0.03125000f,-0.87500000f,-0.76562500f,0.00000000f,-0.95312500f,0.00000000f,-0.93750000f,0.12500000f,-0.20312500f,-0.81250000f,0.57812500f,-0.21875000f,-0.34375000f,-0.87500000f,-0.14062500f,-0.76562500f,0.95312500f,0.25000000f,-0.67187500f,0.17187500f,0.17187500f,-0.43750000f,0.68750000f,0.35937500f,0.75000000f,0.10937500f,-0.07812500f,0.95312500f,0.45312500f,0.87500000f,0.71875000f,-0.03125000f,-0.43750000f,0.01562500f,-0.89062500f,-0.14062500f,0.59375000f,0.53125000f,0.46875000f,0.20312500f,0.01562500f,0.92187500f,0.96875000f,0.98437500f,0.89062500f,0.62500000f,0.42187500f,0.78125000f,0.79687500f,-0.37500000f,0.50000000f,-0.37500000f,-0.14062500f,0.25000000f,0.82812500f,-0.34375000f,0.85937500f,0.65625000f,-0.25000000f,0.09375000f,0.54687500f,-0.75000000f,-0.92187500f,0.12500000f,-0.82812500f,-0.39062500f,0.92187500f,0.07812500f,0.42187500f,0.82812500f,-0.09375000f,0.01562500f,-0.76562500f,0.09375000f,-0.65625000f,0.42187500f,-0.18750000f,0.59375000f,-0.75000000f,-1.00000000f,-0.09375000f,-0.71875000f,-0.96875000f,-0.01562500f,0.71875000f,-1.00000000f,0.03125000f,-0.01562500f,-0.45312500f,0.68750000f,0.95312500f,-0.90625000f,0.82812500f,0.26562500f,-0.15625000f,0.35937500f,-0.70312500f,0.01562500f,1.00000000f,0.90625000f,0.87500000f,0.39062500f,0.67187500f,-0.96875000f,0.56250000f,-0.53125000f,0.06250000f,0.85937500f,0.48437500f,-0.39062500f,-0.25000000f,0.81250000f,-0.31250000f,0.62500000f,-0.48437500f,0.50000000f,0.10937500f,0.15625000f,0.82812500f,0.95312500f,0.40625000f,0.96875000f,-0.17187500f,-0.79687500f,0.95312500f,-0.07812500f,0.26562500f,-0.39062500f,0.78125000f,0.57812500f,-0.53125000f,-0.15625000f,-0.57812500f,-0.45312500f,-0.59375000f,-0.14062500f,-0.65625000f,0.57812500f,-0.68750000f,-0.07812500f,0.37500000f,-0.85937500f,0.54687500f,-0.20312500f,-0.95312500f,-0.14062500f,0.81250000f,-0.12500000f,0.20312500f,0.81250000f,0.65625000f,-1.00000000f,0.85937500f,-0.32812500f,0.35937500f,-0.56250000f,0.82812500f,0.65625000f,-0.84375000f,-0.17187500f,-0.03125000f,-0.18750000f,0.56250000f,-0.32812500f,-0.85937500f,0.26562500f,-0.01562500f,0.90625000f,0.48437500f,0.21875000f,0.85937500f,-0.60937500f,-0.28125000f,0.70312500f,0.68750000f,-0.65625000f,0.70312500f,-0.26562500f,-0.48437500f,0.62500000f,0.85937500f,-0.56250000f,-0.59375000f,-0.46875000f,0.92187500f,0.29687500f,-0.53125000f,-0.48437500f,0.45312500f,0.25000000f,-0.87500000f,-0.15625000f,-0.48437500f,-0.04687500f,-0.78125000f,0.29687500f,-0.84375000f,-0.17187500f,-0.78125000f,0.50000000f,0.46875000f,-0.32812500f,-0.35937500f,0.48437500f,-0.12500000f,-0.76562500f,0.67187500f,0.85937500f,0.18750000f,0.42187500f,1.00000000f,0.75000000f,0.53125000f,0.98437500f,-0.73437500f,0.17187500f,-0.45312500f,-0.65625000f,-0.03125000f,0.00000000f,0.96875000f,0.92187500f,0.29687500f,-0.96875000f,-0.95312500f,0.23437500f,0.73437500f,-0.54687500f,0.78125000f,-0.85937500f,-0.53125000f,-0.64062500f,0.00000000f,0.73437500f,-0.03125000f,0.85937500f,0.10937500f,-0.26562500f,-0.70312500f,0.04687500f,-0.03125000f,0.76562500f,-0.04687500f,-0.81250000f,-0.71875000f,0.10937500f,-0.84375000f,0.39062500f,0.21875000f,0.43750000f,-0.40625000f,1.00000000f,0.92187500f,-0.21875000f,-0.85937500f,-0.32812500f,0.34375000f,0.84375000f,-0.45312500f,-0.31250000f,-0.56250000f,-0.90625000f,0.87500000f,-0.43750000f,0.48437500f,0.62500000f,-0.06250000f,-0.57812500f,0.28125000f,-0.45312500f,0.54687500f,0.01562500f,-0.20312500f,-0.92187500f,0.76562500f,0.89062500f,-0.90625000f,0.87500000f,-0.96875000f,-0.15625000f,0.90625000f,0.43750000f,-0.07812500f,-0.70312500f,-0.35937500f,-0.53125000f,0.14062500f,0.92187500f,-0.18750000f,-0.15625000f,0.73437500f,-0.59375000f,-0.75000000f,0.76562500f,-0.01562500f,0.96875000f,0.53125000f,0.64062500f,0.82812500f,0.57812500f,-0.34375000f,-0.65625000f,0.39062500f,0.96875000f,-0.54687500f,-0.09375000f,0.76562500f,-0.84375000f,0.51562500f,0.28125000f,-0.57812500f,0.54687500f,0.32812500f,-0.65625000f,0.10937500f,0.14062500f,0.32812500f,0.53125000f,0.84375000f,0.04687500f,-0.23437500f,-0.76562500f,-0.48437500f,0.53125000f,-0.95312500f,-0.34375000f,0.70312500f,0.67187500f,-0.31250000f,-0.23437500f,0.39062500f,-0.50000000f,0.73437500f,0.09375000f,-0.57812500f,0.76562500f,0.96875000f,-0.60937500f,0.42187500f,0.25000000f,0.60937500f,0.64062500f,0.51562500f,-0.85937500f,-0.98437500f,0.75000000f,-0.45312500f,-0.93750000f,-0.62500000f,0.95312500f,-0.59375000f,0.51562500f,-0.14062500f,-0.68750000f,0.79687500f,0.28125000f,-0.01562500f,-0.28125000f,-0.78125000f,0.15625000f,-0.85937500f,0.76562500f,0.07812500f,-0.50000000f,-0.60937500f,-0.81250000f,0.56250000f,0.12500000f,-0.14062500f,-0.78125000f,0.35937500f,-0.32812500f,-0.84375000f,-0.37500000f,0.98437500f,-0.23437500f,0.06250000f,-0.82812500f,0.46875000f,0.46875000f,-0.60937500f,0.54687500f,-0.93750000f,-0.25000000f,0.93750000f,0.32812500f,0.92187500f,0.12500000f,0.39062500f,0.00000000f,-0.09375000f,-0.68750000f,-0.28125000f,0.95312500f,-0.06250000f,-0.68750000f,0.62500000f,-0.06250000f,-0.31250000f,-0.56250000f,-0.12500000f,0.56250000f,0.03125000f,-0.20312500f,-0.31250000f,0.37500000f,-0.04687500f,0.53125000f,0.82812500f,0.43750000f,0.53125000f,-0.12500000f,-0.29687500f,-0.37500000f,-0.26562500f,-0.10937500f,-0.39062500f,-0.18750000f,0.65625000f,-0.12500000f,0.37500000f,0.78125000f,-0.45312500f,-0.48437500f,-0.10937500f,0.06250000f,0.73437500f,0.89062500f,0.42187500f,0.40625000f,0.81250000f,-0.90625000f,-0.70312500f,0.20312500f,-0.70312500f,0.21875000f,-0.46875000f,0.85937500f,-0.90625000f,0.45312500f,-0.09375000f,0.87500000f,0.78125000f,-0.25000000f,0.21875000f,-0.15625000f,-0.01562500f,-0.67187500f,-0.04687500f,0.34375000f,-0.51562500f,0.95312500f,-0.64062500f,-0.26562500f,-0.51562500f,-0.92187500f,0.70312500f,-0.68750000f,-0.64062500f,-0.20312500f,-0.64062500f,-0.14062500f,0.42187500f,-0.23437500f,0.40625000f,-0.51562500f,0.40625000f,-0.45312500f,-0.53125000f,-0.35937500f,0.82812500f,-0.57812500f,0.56250000f,-0.07812500f,0.54687500f,0.15625000f,0.76562500f,-0.98437500f,-0.87500000f,0.87500000f,-0.89062500f,0.90625000f,0.56250000f,-0.35937500f,0.75000000f,0.95312500f,-0.95312500f,-0.32812500f,-0.48437500f,0.64062500f,0.23437500f,0.14062500f,-0.21875000f,-0.04687500f,-0.81250000f,0.21875000f,0.45312500f,-0.06250000f,-0.34375000f,-0.79687500f,0.67187500f,0.84375000f,0.40625000f,0.87500000f,0.68750000f,0.68750000f,0.07812500f,0.67187500f,-0.18750000f,-0.82812500f,-0.85937500f,-0.34375000f,0.81250000f,0.71875000f,-0.57812500f,-0.70312500f,0.68750000f,-0.03125000f,0.54687500f,-0.17187500f,0.15625000f,0.01562500f,-0.45312500f,-0.29687500f,-0.64062500f,0.06250000f,0.21875000f,0.45312500f,0.39062500f,0.51562500f,-0.67187500f,-0.42187500f,-0.82812500f,-0.89062500f,-0.51562500f,0.75000000f,0.82812500f,0.15625000f,-0.25000000f,-0.92187500f,0.25000000f,0.56250000f,-0.85937500f,0.18750000f,-0.06250000f,-1.00000000f,-0.82812500f,-0.89062500f,0.76562500f,-0.42187500f,-0.06250000f,-0.81250000f,0.34375000f,0.04687500f,0.50000000f,-0.15625000f,0.79687500f,0.10937500f,0.53125000f,0.78125000f,0.81250000f,0.20312500f,-1.00000000f,-0.53125000f,0.37500000f,0.34375000f,0.10937500f,0.79687500f,0.71875000f,0.35937500f,0.81250000f,-0.96875000f,-0.07812500f,-0.68750000f,-0.98437500f,0.43750000f,0.59375000f,0.25000000f,0.25000000f,-0.18750000f,-0.75000000f,-0.12500000f,0.28125000f,0.25000000f,-0.21875000f,0.15625000f,0.01562500f,-0.92187500f,-0.18750000f,-0.32812500f,-0.42187500f,0.48437500f,-0.40625000f,-0.29687500f,-0.75000000f,1.00000000f,0.20312500f,-0.25000000f,-0.32812500f,0.75000000f,0.03125000f,0.87500000f,-0.07812500f,0.23437500f,-0.37500000f,-0.34375000f,0.48437500f,0.29687500f,-0.14062500f,0.06250000f,0.84375000f,-0.12500000f,0.93750000f,0.06250000f,-0.96875000f,-0.42187500f,-1.00000000f,-1.00000000f,0.09375000f,0.93750000f,-0.76562500f,-0.48437500f,-0.15625000f,0.67187500f,0.28125000f,0.53125000f,0.59375000f,-0.73437500f,-0.68750000f,0.50000000f,-0.32812500f,-0.06250000f,0.70312500f,-0.45312500f,-0.60937500f,-0.56250000f,-0.18750000f,-0.78125000f,-0.06250000f,-0.73437500f,-0.25000000f,0.15625000f,0.37500000f,-0.10937500f,-0.57812500f,-0.57812500f,-0.71875000f,0.32812500f,-0.98437500f,-0.70312500f,-0.76562500f,-0.18750000f,-0.96875000f,0.28125000f,-0.35937500f,0.25000000f,-0.96875000f,0.71875000f,-0.70312500f,-0.06250000f,0.70312500f,0.37500000f,-0.03125000f,0.29687500f,0.26562500f,-0.68750000f,-0.76562500f,-0.90625000f,0.14062500f,0.06250000f,-0.84375000f,0.37500000f,0.37500000f,-0.98437500f,0.01562500f,0.50000000f,-0.62500000f,-0.62500000f,0.37500000f,-0.79687500f,0.79687500f,0.70312500f,-0.09375000f,0.50000000f,-0.23437500f,0.12500000f,-0.93750000f,-0.31250000f,0.79687500f,-0.48437500f,0.59375000f,0.54687500f,0.95312500f,0.51562500f,0.57812500f,0.92187500f,0.15625000f,-0.79687500f,-0.81250000f,0.46875000f,-0.70312500f,-0.56250000f,-0.84375000f,-0.92187500f,-0.12500000f,0.00000000f,-0.78125000f,0.34375000f,-0.82812500f,-0.26562500f,0.93750000f,-0.95312500f,-0.42187500f,0.95312500f,0.35937500f,-0.87500000f,0.29687500f,0.51562500f,0.25000000f,0.14062500f,-0.71875000f,-0.62500000f,-0.35937500f,0.29687500f,-0.56250000f,-0.34375000f,0.81250000f,-0.90625000f,-0.75000000f,0.53125000f,-0.10937500f,0.92187500f,0.57812500f,0.29687500f,0.39062500f,0.18750000f,-0.84375000f,0.65625000f,0.93750000f,-0.71875000f,-0.43750000f,-0.42187500f,0.25000000f,0.15625000f,-0.96875000f,-0.93750000f,-0.12500000f,-0.40625000f,0.53125000f,0.26562500f,-0.21875000f,0.51562500f,0.37500000f,-0.57812500f,0.26562500f,-0.17187500f,0.35937500f,0.79687500f,-0.75000000f,-0.07812500f,0.21875000f,-0.98437500f,-0.03125000f,-0.26562500f,0.31250000f,-0.03125000f,-0.40625000f,-0.76562500f,-0.37500000f,0.81250000f,-0.17187500f,0.29687500f,0.62500000f,0.40625000f,0.20312500f,0.40625000f,-0.79687500f,-0.53125000f,-0.71875000f,-0.70312500f,-0.23437500f,0.95312500f,0.84375000f,0.29687500f,0.40625000f,0.96875000f,0.93750000f,-0.03125000f,0.01562500f,0.60937500f,-0.28125000f,-0.85937500f,0.29687500f,0.68750000f,0.73437500f,0.56250000f,-0.67187500f,0.50000000f,-0.04687500f,0.09375000f,-0.48437500f,-0.43750000f,0.17187500f,0.57812500f,0.25000000f,-0.15625000f,0.32812500f,-0.84375000f,-0.28125000f,0.81250000f,0.65625000f,-0.65625000f,-0.70312500f,0.67187500f,-0.48437500f,0.65625000f,1.00000000f,-0.15625000f,-0.23437500f,0.23437500f,0.25000000f,-0.53125000f,0.48437500f,-0.73437500f,0.17187500f,0.28125000f,0.29687500f,0.12500000f,0.09375000f,0.31250000f,0.31250000f,-0.18750000f,-0.25000000f,-0.42187500f,-0.45312500f,-0.40625000f,0.82812500f,-0.90625000f,0.73437500f,0.56250000f,-0.09375000f,0.34375000f,-0.26562500f,0.29687500f,0.50000000f,0.46875000f,0.23437500f,0.43750000f,0.37500000f,-0.26562500f,0.60937500f,0.53125000f,0.53125000f,0.25000000f,-0.45312500f,0.51562500f,-0.64062500f,0.79687500f,-0.12500000f,0.93750000f,-0.45312500f,0.92187500f,0.64062500f,0.37500000f,0.06250000f,0.23437500f,-0.45312500f,0.50000000f,-0.09375000f,-0.79687500f,-0.95312500f,0.51562500f,-0.84375000f,-0.14062500f,0.93750000f,-0.82812500f,-0.62500000f,0.87500000f,0.03125000f,-0.53125000f,-0.09375000f,-0.96875000f,-0.28125000f,0.90625000f,0.56250000f,-0.35937500f,-0.37500000f,-0.29687500f,0.25000000f,0.71875000f,-0.75000000f,0.14062500f,-0.34375000f,0.12500000f,-0.01562500f,0.73437500f,-0.51562500f,-0.10937500f,-0.14062500f,0.82812500f,-0.89062500f,0.15625000f,-0.90625000f,-0.31250000f,-0.20312500f,-0.28125000f,-0.98437500f,-0.71875000f,-0.51562500f,-0.07812500f,-0.32812500f,0.76562500f,-0.37500000f,0.79687500f,-0.35937500f,0.39062500f,0.70312500f,-0.14062500f,0.65625000f,0.18750000f,0.04687500f,-0.54687500f,0.82812500f,-0.35937500f,0.43750000f,0.59375000f,-0.98437500f,0.60937500f,-0.60937500f,0.51562500f,-0.06250000f,-0.68750000f,0.50000000f,-0.04687500f,0.62500000f,0.45312500f,0.43750000f,0.70312500f,0.75000000f,-0.06250000f,-0.89062500f,0.85937500f,0.84375000f,-0.07812500f,0.67187500f,0.59375000f,0.59375000f,-1.00000000f,0.46875000f,0.65625000f,0.07812500f,0.43750000f,0.09375000f,0.82812500f,1.00000000f,0.12500000f,0.65625000f,-0.42187500f,-0.31250000f,-0.59375000f,0.51562500f,0.53125000f,0.23437500f,0.85937500f,-0.34375000f,-0.12500000f,-0.28125000f,0.78125000f,0.57812500f,1.00000000f,-0.53125000f,-0.56250000f,-0.64062500f,0.46875000f,-1.00000000f,-1.00000000f,0.87500000f,-0.56250000f,-0.84375000f,0.18750000f,0.18750000f,0.84375000f,0.15625000f,0.67187500f,0.29687500f,0.34375000f,0.73437500f,-0.90625000f,0.75000000f,0.95312500f,-0.39062500f,-0.75000000f,-0.43750000f,0.75000000f,0.42187500f,-0.53125000f,0.59375000f,-0.75000000f,-0.96875000f,0.85937500f,0.09375000f,0.82812500f,-0.45312500f,0.23437500f,-0.71875000f,0.29687500f,0.96875000f,-0.23437500f,0.12500000f,0.98437500f,-0.54687500f,-0.59375000f,-0.76562500f,-0.34375000f,-0.45312500f,0.67187500f,0.35937500f,0.82812500f,-0.17187500f,-0.71875000f,-1.00000000f,-0.65625000f,0.93750000f,0.82812500f,0.92187500f,-0.32812500f,0.62500000f,0.21875000f,-0.70312500f,0.45312500f,-0.28125000f,-0.31250000f,0.98437500f,-0.40625000f,-0.09375000f,-0.53125000f,0.62500000f,0.50000000f,0.32812500f,0.09375000f,-0.20312500f,0.29687500f,-0.43750000f,-0.70312500f,-0.92187500f,-0.60937500f,0.23437500f,0.57812500f,-0.92187500f,-0.64062500f,0.04687500f,0.92187500f,0.46875000f,0.12500000f,-0.37500000f,-0.04687500f,0.01562500f,0.93750000f,0.06250000f,-0.09375000f,-0.67187500f,1.00000000f,0.31250000f,0.43750000f,0.00000000f,-0.51562500f,0.60937500f,0.71875000f,0.26562500f,0.62500000f,0.81250000f,0.82812500f,0.95312500f,0.37500000f,0.39062500f,-0.67187500f,0.43750000f,-0.07812500f,0.48437500f,-0.34375000f,-0.15625000f,0.60937500f,0.67187500f,-0.68750000f,-0.10937500f,-0.46875000f,-0.31250000f,0.23437500f,-0.85937500f,-0.57812500f,0.56250000f,0.82812500f,-0.40625000f,0.71875000f,0.21875000f,-0.01562500f,-0.01562500f,0.04687500f,-0.57812500f,0.81250000f,0.37500000f,-0.45312500f,0.00000000f,-0.34375000f,-0.64062500f,0.10937500f,-0.90625000f,0.71875000f,-0.03125000f,-0.75000000f,-0.90625000f,-0.70312500f,0.70312500f,-0.40625000f,0.29687500f,-0.54687500f,0.65625000f,-0.42187500f,0.96875000f,0.78125000f,-0.89062500f,-0.92187500f,0.85937500f,0.59375000f,0.78125000f,-0.20312500f,-0.68750000f,-0.75000000f,0.06250000f,-0.57812500f,-0.98437500f,0.50000000f,0.35937500f,-0.43750000f,-0.92187500f,0.82812500f,0.35937500f,-0.59375000f,-0.46875000f,-0.51562500f,-0.42187500f,0.39062500f,-0.35937500f,-0.39062500f,0.23437500f,0.57812500f,-0.29687500f,-0.81250000f,-0.82812500f,-0.79687500f,-0.20312500f,-0.76562500f,0.79687500f,0.62500000f,-0.60937500f,0.96875000f,-0.43750000f,0.70312500f,-0.65625000f,-0.65625000f,-0.09375000f,-0.65625000f,0.00000000f,0.40625000f,-0.84375000f,-0.92187500f,0.04687500f,0.89062500f,-0.17187500f,-0.81250000f,-0.10937500f,0.14062500f,-0.85937500f,-1.00000000f,0.70312500f,-0.25000000f,-0.70312500f,-0.31250000f,0.82812500f,0.82812500f,0.71875000f,0.43750000f,-0.48437500f,0.34375000f,-0.25000000f,-0.28125000f,0.53125000f,-0.12500000f,0.56250000f,0.82812500f,0.01562500f,-0.60937500f,0.57812500f,0.93750000f,-0.73437500f,0.31250000f,0.79687500f,-0.54687500f,0.14062500f,0.42187500f,0.34375000f,0.31250000f,-0.39062500f,-0.10937500f,0.85937500f,-0.56250000f,-0.84375000f,-0.40625000f,-0.26562500f,0.28125000f,-0.93750000f,-0.09375000f,0.62500000f,-0.29687500f,-0.25000000f,-0.18750000f,0.28125000f,-0.51562500f,-0.43750000f,0.39062500f,-0.18750000f,-0.82812500f,0.15625000f,-0.82812500f,0.89062500f,-0.29687500f,-0.75000000f,-0.45312500f,0.59375000f,-0.78125000f,0.14062500f,-0.53125000f,0.07812500f,-0.98437500f,0.60937500f,0.21875000f,-0.68750000f,-0.35937500f,-0.20312500f,0.48437500f,-0.56250000f,0.76562500f,0.48437500f,-0.78125000f,0.03125000f,0.65625000f,-0.96875000f,0.54687500f,0.60937500f,0.78125000f,0.42187500f,-0.56250000f,-0.34375000f,0.64062500f,-1.00000000f,0.17187500f,0.71875000f,-0.68750000f,-0.96875000f,0.45312500f,-0.60937500f,0.31250000f,0.92187500f,0.98437500f,0.25000000f,-0.37500000f,0.21875000f,0.73437500f,-0.04687500f,-0.18750000f,-0.35937500f,-0.59375000f,0.98437500f,-0.29687500f,0.45312500f,-0.26562500f,0.45312500f,0.70312500f,-0.75000000f,0.37500000f,-0.03125000f,-0.03125000f,-0.64062500f,-0.71875000f,0.15625000f,-0.84375000f,-0.62500000f,-0.81250000f,0.70312500f,0.31250000f,0.04687500f,0.67187500f,0.09375000f,0.53125000f,0.87500000f,-0.54687500f,0.87500000f,0.81250000f,0.84375000f,-0.50000000f,0.65625000f,-0.26562500f,0.37500000f,0.42187500f,-0.53125000f,0.60937500f,0.64062500f,0.85937500f,0.18750000f,0.87500000f,-0.76562500f,-0.67187500f,0.51562500f,0.75000000f,-0.78125000f,0.04687500f,-0.50000000f,0.56250000f,0.42187500f,0.48437500f,-0.81250000f,-0.45312500f,-0.51562500f,-0.35937500f,-0.70312500f,0.04687500f,0.73437500f,0.71875000f,-0.54687500f,-0.98437500f,-0.25000000f,0.35937500f,0.00000000f,0.43750000f,0.00000000f,-0.01562500f,-0.12500000f,0.73437500f,-0.93750000f,0.71875000f,0.59375000f,-1.00000000f,-0.75000000f,0.26562500f,0.28125000f,-0.87500000f,0.18750000f,0.75000000f,0.40625000f,-0.67187500f,-0.31250000f,-0.46875000f,-0.59375000f,-0.42187500f,-0.35937500f,0.84375000f,-0.28125000f,0.34375000f,-0.45312500f,0.48437500f,-0.57812500f,-0.79687500f,-0.82812500f,0.92187500f,-0.56250000f,0.25000000f,-0.48437500f,0.96875000f,0.50000000f,0.56250000f,-0.57812500f,-0.78125000f,0.65625000f,-0.75000000f,-0.51562500f,0.79687500f,-0.60937500f,0.10937500f,-0.32812500f,0.10937500f,-0.71875000f,0.21875000f,0.67187500f,-0.50000000f,-0.28125000f,0.90625000f,0.57812500f,-0.81250000f,-0.68750000f,-0.75000000f,-0.29687500f,0.18750000f,-0.81250000f,-0.45312500f,-0.87500000f,0.85937500f,0.73437500f,-0.42187500f,-0.92187500f,0.50000000f,-0.59375000f,0.07812500f,-0.29687500f,0.65625000f,-0.23437500f,0.98437500f,-0.26562500f,0.62500000f,-0.43750000f,-0.85937500f,0.70312500f,0.07812500f,-0.31250000f,0.51562500f,-0.23437500f,0.82812500f,-0.65625000f,0.46875000f,0.67187500f,0.31250000f,-0.29687500f,-0.17187500f,-0.79687500f,-0.70312500f,0.65625000f,0.68750000f,0.96875000f,0.04687500f,-0.03125000f,0.79687500f,0.82812500f,0.98437500f,-0.67187500f,-0.54687500f,-0.51562500f,-0.67187500f,-0.78125000f,-0.93750000f,0.46875000f,0.46875000f,-0.29687500f,-0.96875000f,-0.84375000f,-0.98437500f,-0.57812500f,-0.85937500f,-0.68750000f,-0.84375000f,0.43750000f,0.46875000f,-0.50000000f,-0.98437500f,0.34375000f,-0.01562500f,-0.93750000f,-0.51562500f,-0.17187500f,0.10937500f,0.32812500f,-0.96875000f,-0.07812500f,0.56250000f,0.87500000f,-0.01562500f,-0.25000000f,-0.59375000f,-0.20312500f,0.23437500f,0.09375000f,0.75000000f,-0.68750000f,-0.42187500f,-1.00000000f,0.79687500f,0.25000000f,0.31250000f,0.01562500f,-0.93750000f,0.40625000f,-0.20312500f,-0.93750000f,-0.75000000f,-0.82812500f,-0.75000000f,-0.21875000f,0.17187500f,-0.85937500f,-0.64062500f,-0.09375000f,0.35937500f,0.06250000f,-0.84375000f,0.01562500f,0.21875000f,0.81250000f,-0.60937500f,-0.67187500f,-0.93750000f,0.71875000f,0.07812500f,0.01562500f,0.53125000f,0.18750000f,-0.98437500f,-0.07812500f,0.17187500f,0.90625000f,-0.21875000f,-0.15625000f,-0.70312500f,-0.89062500f,-0.67187500f,0.85937500f,-0.82812500f,0.29687500f,0.73437500f,-0.51562500f,0.87500000f,0.53125000f,0.68750000f,0.60937500f,-0.96875000f,-0.50000000f,0.56250000f,-0.82812500f,0.31250000f,-0.48437500f,0.93750000f,0.12500000f,0.03125000f,0.28125000f,-0.60937500f,-0.20312500f,0.26562500f,-0.50000000f,0.06250000f,0.40625000f,-0.53125000f,0.29687500f,0.92187500f,0.60937500f,-0.75000000f,-0.64062500f,-0.26562500f,0.45312500f,0.03125000f,-0.29687500f,0.34375000f,-0.07812500f,-0.68750000f,0.60937500f,-0.73437500f,-0.45312500f,0.89062500f,-0.39062500f,-0.70312500f,-0.90625000f,-0.92187500f,-0.87500000f,0.39062500f,0.73437500f,0.01562500f,-0.07812500f,-0.51562500f,0.79687500f,0.32812500f,0.20312500f,-0.95312500f,-0.26562500f,-0.31250000f,1.00000000f,-0.93750000f,-0.32812500f,-0.26562500f,0.51562500f,0.76562500f,-0.65625000f,0.51562500f,0.06250000f,-0.54687500f,-0.12500000f,0.57812500f,0.82812500f,-0.67187500f,0.39062500f,0.32812500f,0.28125000f,0.96875000f,0.45312500f,0.59375000f,-0.35937500f,-0.37500000f,0.12500000f,0.76562500f,0.43750000f,0.89062500f,-0.25000000f,0.84375000f,-0.89062500f,-0.03125000f,0.57812500f,-0.67187500f,-0.21875000f,0.23437500f,-0.25000000f,0.39062500f,-0.79687500f,-0.17187500f,-0.92187500f,-0.65625000f,0.73437500f,-0.70312500f,-0.65625000f,-0.25000000f,-0.70312500f,0.64062500f,0.31250000f,0.87500000f,-0.93750000f,0.21875000f,0.57812500f,0.39062500f,0.93750000f,0.40625000f,0.87500000f,-0.18750000f,-0.23437500f,0.96875000f,-0.79687500f,0.39062500f,-0.85937500f,-0.79687500f,-0.40625000f,-0.92187500f,-0.12500000f,0.76562500f,0.09375000f,-0.40625000f,-0.84375000f,-0.95312500f,-0.71875000f,-0.17187500f,-0.62500000f,-0.78125000f,0.10937500f,-0.45312500f,-0.65625000f,-0.59375000f,0.98437500f,0.73437500f,0.85937500f,-0.87500000f,-0.67187500f,-0.98437500f,-0.17187500f,0.95312500f,-0.81250000f,0.84375000f,-0.90625000f,0.92187500f,-0.85937500f,-0.82812500f,0.54687500f,0.21875000f,0.09375000f,-0.15625000f,0.45312500f,0.28125000f,-0.96875000f,0.45312500f,0.62500000f,0.56250000f,-0.31250000f,-0.31250000f,0.57812500f,0.14062500f,0.34375000f,0.09375000f,-0.21875000f,0.57812500f,-0.82812500f,0.96875000f,-0.75000000f,0.60937500f,-0.92187500f,-0.07812500f,0.89062500f,0.43750000f,0.23437500f,0.15625000f,0.12500000f,-0.78125000f,-0.46875000f,0.03125000f,0.62500000f,0.53125000f,-0.85937500f,-0.78125000f,0.60937500f,0.15625000f,0.68750000f,0.87500000f,0.93750000f,0.53125000f,-0.93750000f,-0.48437500f,-0.23437500f,-0.45312500f,0.39062500f,0.10937500f,-0.14062500f,0.93750000f,0.64062500f,0.95312500f,0.96875000f,0.73437500f,-0.12500000f,0.75000000f,-0.64062500f,0.04687500f,-0.51562500f,-0.39062500f,-0.10937500f,0.62500000f,0.85937500f,0.46875000f,0.04687500f,0.42187500f,-0.96875000f,0.71875000f,-0.85937500f,-0.45312500f,0.46875000f,0.07812500f,-0.56250000f,-0.64062500f,-0.68750000f,0.04687500f,0.25000000f,-0.64062500f,-0.23437500f,0.03125000f,-0.45312500f,0.12500000f,0.93750000f,-0.35937500f,0.23437500f,0.96875000f,0.48437500f,0.56250000f,0.09375000f,-0.57812500f,-0.42187500f,0.53125000f,-0.25000000f,-0.87500000f,-0.54687500f,0.64062500f,0.00000000f,0.03125000f,0.10937500f,-0.67187500f,-0.32812500f,-0.10937500f,-0.59375000f,0.87500000f,-0.43750000f,0.96875000f,0.48437500f,0.59375000f,-0.18750000f,-0.85937500f,0.89062500f,-0.20312500f,0.07812500f,-0.98437500f,0.01562500f,0.18750000f,0.39062500f,0.96875000f,0.15625000f,-0.82812500f,0.93750000f,0.17187500f,0.39062500f,-0.40625000f,0.89062500f,-0.59375000f,0.40625000f,0.78125000f,-0.10937500f,0.79687500f,0.56250000f,-0.28125000f,-0.48437500f,-0.82812500f,-0.70312500f,0.34375000f,0.57812500f,0.00000000f,0.28125000f,0.70312500f,0.39062500f,-0.29687500f,-0.25000000f,-0.90625000f,-0.32812500f,-0.85937500f,0.37500000f,0.93750000f,-0.20312500f,-0.48437500f,0.92187500f,0.79687500f,-0.29687500f,0.06250000f,-0.31250000f,0.34375000f,0.67187500f,0.57812500f,0.25000000f,-0.56250000f,0.92187500f,-0.26562500f,-0.71875000f,0.68750000f,0.65625000f,0.46875000f,0.09375000f,0.39062500f,-0.39062500f,0.75000000f,0.70312500f,-0.89062500f,-0.56250000f,0.40625000f,0.95312500f,0.10937500f,-0.26562500f,-0.73437500f,0.20312500f,0.06250000f,-0.68750000f,-0.60937500f,-0.71875000f,0.40625000f,0.75000000f,-0.46875000f,0.57812500f,-0.29687500f,0.37500000f,0.51562500f,-0.73437500f,0.90625000f,0.75000000f,-0.64062500f,0.71875000f,0.62500000f,0.70312500f,0.32812500f,0.81250000f,0.57812500f,0.71875000f,-0.67187500f,-0.56250000f,-0.07812500f,-1.00000000f,-0.48437500f,0.32812500f,0.98437500f,0.98437500f,-0.98437500f,-0.56250000f,0.68750000f,-0.95312500f,-0.37500000f,0.82812500f,0.67187500f,0.28125000f,0.51562500f,0.46875000f,-0.56250000f,-0.32812500f,-0.56250000f,-0.31250000f,-0.29687500f,0.18750000f,-0.17187500f,1.00000000f,0.96875000f,0.50000000f,-0.68750000f,0.75000000f,-0.39062500f,-0.28125000f,-0.90625000f,0.40625000f,0.96875000f,-0.03125000f,0.32812500f,0.67187500f,-0.60937500f,-0.25000000f,-0.57812500f,0.06250000f,0.56250000f,0.76562500f,-0.65625000f,-0.45312500f,0.54687500f,-0.92187500f,-0.39062500f,0.15625000f,0.71875000f,-0.29687500f,0.67187500f,-0.03125000f,0.40625000f,-0.79687500f,-0.90625000f,0.59375000f,0.39062500f,-0.25000000f,-0.04687500f,-0.07812500f,-0.06250000f,0.04687500f,0.59375000f,0.98437500f,0.59375000f,0.48437500f,-0.43750000f,0.03125000f,0.25000000f,0.96875000f,-0.07812500f,0.56250000f,-0.03125000f,0.20312500f,0.87500000f,-0.26562500f,-0.48437500f,-0.42187500f,0.39062500f,-0.10937500f,-0.81250000f,-0.31250000f,-0.18750000f,0.73437500f,-0.75000000f,-0.40625000f,0.56250000f,-0.90625000f,0.68750000f,0.31250000f,0.48437500f,0.23437500f,0.65625000f,-0.50000000f,0.76562500f,0.42187500f,0.37500000f,0.57812500f,0.60937500f,-0.46875000f,0.28125000f,0.85937500f,0.34375000f,0.65625000f,0.82812500f,-0.54687500f,-0.92187500f,-0.89062500f,-0.28125000f,-0.98437500f,-0.54687500f,-0.37500000f,-0.06250000f,0.48437500f,0.60937500f,-0.95312500f,0.32812500f,0.45312500f,0.50000000f,-0.42187500f,-0.98437500f,0.81250000f,-0.59375000f,0.73437500f,0.92187500f,-0.60937500f,-0.65625000f,0.46875000f,-1.00000000f,-0.68750000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.82617188f,-1.34399414f,2.22192383f,-2.34570312f,0.0f,0.0f,-2.83374023f,2.06518555f,0.46069336f,1.98046875f,0.0f,0.0f,0.00366211f,-1.09399414f,0.56079102f,0.12475586f,0.0f,0.0f,-3.39160156f,-1.57788086f,-1.42626953f,-1.86718750f,0.0f,0.0f,2.26440430f,3.14257812f,0.69287109f,1.31225586f,0.0f,0.0f,1.15844727f,0.30981445f,0.58251953f,1.17749023f,0.0f,0.0f,4.92187500f,-0.43896484f,-1.14501953f,0.02832031f,0.0f,0.0f,-1.91552734f,-0.16137695f,-0.04931641f,-1.78515625f,0.0f,0.0f,2.45092773f,2.82543945f,-0.86767578f,1.20507812f,0.0f,0.0f,1.18432617f,2.13134766f,-1.68066406f,1.45117188f,0.0f,0.0f,-0.42504883f,0.41870117f,-0.23730469f,0.66723633f,0.0f,0.0f,-1.88745117f,0.18286133f,-1.85424805f,3.11547852f,0.0f,0.0f,-3.22216797f,0.44335938f,1.17285156f,0.11840820f,0.0f,0.0f,-3.81860352f,2.16040039f,-2.64794922f,0.62109375f,0.0f,0.0f,-1.29296875f,1.14233398f,-0.24584961f,-0.67480469f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.60668945f,0.01049805f,0.76513672f,-0.09252930f,0.0f,0.0f,0.19165039f,0.97070312f,0.35131836f,0.27319336f,0.0f,0.0f,1.96411133f,0.08520508f,-0.29003906f,-0.58837891f,0.0f,0.0f,-0.31860352f,-0.25048828f,1.35327148f,0.11474609f,0.0f,0.0f,-0.30175781f,0.78930664f,-0.28051758f,-2.02148438f,0.0f,0.0f,1.71801758f,-0.15112305f,-0.01245117f,1.51123047f,0.0f,0.0f,-1.00585938f,0.86767578f,-2.15478516f,-2.08789062f,0.0f,0.0f,0.19018555f,-1.91406250f,-0.35888672f,-0.17016602f,0.0f,0.0f,1.10815430f,-1.03662109f,-0.91308594f,0.16162109f,0.0f,0.0f,0.47460938f,-0.46850586f,-0.07006836f,-0.80371094f,0.0f,0.0f,-2.45288086f,1.76806641f,0.64575195f,-1.94458008f,0.0f,0.0f,-0.83276367f,-1.41308594f,0.20092773f,-0.77807617f,0.0f,0.0f,0.22631836f,-0.76220703f,-1.63818359f,0.17846680f,0.0f,0.0f,1.71411133f,2.07177734f,-0.05834961f,-0.25781250f,0.0f,0.0f,4.16918945f,0.44677734f,1.56689453f,-2.60058594f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.43017578f,1.55126953f,-0.50830078f,-0.64697266f,0.0f,0.0f,0.73364258f,-2.26586914f,1.84960938f,2.96459961f,0.0f,0.0f,0.30224609f,0.94506836f,1.06005859f,-4.25244141f,0.0f,0.0f,5.36254883f,-0.89208984f,2.76293945f,-0.18359375f,0.0f,0.0f,-0.60449219f,0.01538086f,-3.01611328f,-1.66699219f,0.0f,0.0f,4.60473633f,-1.68969727f,-1.15771484f,-1.29248047f,0.0f,0.0f,-0.23876953f,-2.68261719f,1.38720703f,-1.97949219f,0.0f,0.0f,0.05517578f,2.72338867f,0.20361328f,-1.68994141f,0.0f,0.0f,3.64941406f,-3.09716797f,-0.70898438f,-3.49633789f,0.0f,0.0f,-0.22045898f,-0.64306641f,1.81884766f,-2.61401367f,0.0f,0.0f,-2.72851562f,-0.72412109f,2.03393555f,-3.54516602f,0.0f,0.0f,-2.31884766f,0.40966797f,0.57348633f,0.73559570f,0.0f,0.0f,-1.14379883f,-2.12036133f,-0.68310547f,0.27270508f,0.0f,0.0f,1.03198242f,0.95996094f,-0.45776367f,-1.54687500f,0.0f,0.0f,0.79589844f,-4.83984375f,4.50415039f,2.57446289f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,1.63964844f,-0.32763672f,0.14135742f,-0.90380859f,0.0f,0.0f,1.29663086f,2.02441406f,-1.81445312f,0.25610352f,0.0f,0.0f,-0.51831055f,-2.41503906f,2.05419922f,0.87719727f,0.0f,0.0f,1.77490234f,-2.38427734f,1.60839844f,-0.53051758f,0.0f,0.0f,-0.69213867f,1.68798828f,-0.19042969f,0.32373047f,0.0f,0.0f,-1.77661133f,-2.86206055f,1.43994141f,1.47070312f,0.0f,0.0f,-2.49291992f,0.31469727f,0.43969727f,1.63256836f,0.0f,0.0f,0.79101562f,-1.88427734f,-3.29785156f,2.24658203f,0.0f,0.0f,-0.63476562f,0.00903320f,-3.77319336f,4.27172852f,0.0f,0.0f,0.87133789f,3.22290039f,-0.16845703f,2.00927734f,0.0f,0.0f,0.90380859f,-1.06347656f,-0.22558594f,-1.82299805f,0.0f,0.0f,-2.20483398f,-0.16064453f,1.46240234f,0.70312500f,0.0f,0.0f,0.81347656f,-1.24389648f,-1.07128906f,0.76098633f,0.0f,0.0f,2.31811523f,-0.56835938f,1.19238281f,-1.37573242f,0.0f,0.0f,1.45678711f,1.64233398f,0.49218750f,-1.23144531f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-2.11889648f,1.10913086f,2.09497070f,0.70239258f,0.0f,0.0f,0.33813477f,1.22387695f,-1.05053711f,0.66406250f,0.0f,0.0f,-1.14111328f,-0.46484375f,-0.44848633f,0.28906250f,0.0f,0.0f,-0.37231445f,3.74243164f,-2.90625000f,2.97412109f,0.0f,0.0f,-1.56469727f,0.12792969f,-2.26562500f,2.17138672f,0.0f,0.0f,-1.20654297f,-0.31030273f,0.89746094f,0.95874023f,0.0f,0.0f,-2.77514648f,1.65283203f,-2.63671875f,0.65063477f,0.0f,0.0f,0.98852539f,-0.01245117f,1.29589844f,3.10107422f,0.0f,0.0f,0.00463867f,0.74072266f,0.40600586f,-1.19897461f,0.0f,0.0f,-2.07226562f,1.95849609f,2.61694336f,1.22363281f,0.0f,0.0f,-0.38574219f,-3.83569336f,-0.03198242f,3.21679688f,0.0f,0.0f,2.24658203f,-0.08959961f,1.44165039f,2.57592773f,0.0f,0.0f,-2.77416992f,-0.82470703f,1.82031250f,-1.32714844f,0.0f,0.0f,2.35864258f,0.89770508f,1.11572266f,1.99096680f,0.0f,0.0f,-0.42089844f,-2.38159180f,-1.06054688f,-1.63232422f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.58569336f,-0.58642578f,-0.61035156f,1.67260742f,0.0f,0.0f,0.29321289f,-2.27783203f,1.64672852f,0.47119141f,0.0f,0.0f,-0.32714844f,2.11279297f,-0.51000977f,-0.32592773f,0.0f,0.0f,0.90258789f,-1.64453125f,-0.67138672f,1.73583984f,0.0f,0.0f,-1.13134766f,-3.02368164f,0.31005859f,-0.46166992f,0.0f,0.0f,1.36596680f,1.90576172f,0.93212891f,0.29565430f,0.0f,0.0f,-0.12011719f,-2.04931641f,-1.16113281f,0.54003906f,0.0f,0.0f,2.25854492f,-0.26293945f,0.97387695f,1.11718750f,0.0f,0.0f,-0.83056641f,-0.43481445f,0.54956055f,-3.89941406f,0.0f,0.0f,0.07202148f,0.25732422f,0.68139648f,-0.73852539f,0.0f,0.0f,-1.62451172f,0.13452148f,0.23046875f,-0.16601562f,0.0f,0.0f,-1.07202148f,1.22143555f,0.64746094f,-0.50366211f,0.0f,0.0f,-0.82641602f,-1.74316406f,1.71899414f,-0.32104492f,0.0f,0.0f,-0.35375977f,0.59570312f,0.67285156f,-1.54760742f,0.0f,0.0f,-0.59082031f,0.27661133f,-0.89086914f,0.16796875f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.45654297f,-0.53027344f,0.03466797f,-0.11132812f,0.0f,0.0f,-1.66796875f,1.45483398f,0.04785156f,-2.23437500f,0.0f,0.0f,0.11816406f,-3.24633789f,-0.85278320f,0.95507812f,0.0f,0.0f,-2.58325195f,-0.14355469f,-1.97729492f,0.60839844f,0.0f,0.0f,1.25170898f,3.46118164f,-2.30786133f,-2.94555664f,0.0f,0.0f,2.34887695f,0.89257812f,-1.57373047f,1.61108398f,0.0f,0.0f,0.40722656f,-1.93847656f,0.81201172f,2.96166992f,0.0f,0.0f,-1.84375000f,0.39648438f,-0.60791016f,-0.21923828f,0.0f,0.0f,0.40429688f,0.12939453f,-2.33959961f,-0.21093750f,0.0f,0.0f,-1.42016602f,-1.65991211f,-2.10278320f,1.65649414f,0.0f,0.0f,2.86352539f,0.74365234f,0.64428711f,2.22851562f,0.0f,0.0f,-0.65380859f,-2.29174805f,2.63989258f,2.06689453f,0.0f,0.0f,-3.34375000f,0.78710938f,3.08935547f,-0.23364258f,0.0f,0.0f,-0.76977539f,-2.07348633f,-1.72631836f,0.89721680f,0.0f,0.0f,3.46313477f,-1.59082031f,-3.35375977f,-0.41137695f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,2.08715820f,-0.20532227f,-0.13281250f,-0.65258789f,0.0f,0.0f,-2.57763672f,0.44653320f,-0.37475586f,1.26513672f,0.0f,0.0f,-1.08593750f,-0.72070312f,0.67944336f,-0.57324219f,0.0f,0.0f,-0.35986328f,-0.10375977f,-0.39233398f,-1.02026367f,0.0f,0.0f,1.39843750f,1.33691406f,0.26342773f,1.70825195f,0.0f,0.0f,-3.03686523f,-1.07055664f,-1.17309570f,-0.57348633f,0.0f,0.0f,-0.41088867f,1.96948242f,0.31054688f,-0.49145508f,0.0f,0.0f,-1.67431641f,-0.99340820f,-0.13842773f,-0.38061523f,0.0f,0.0f,0.23925781f,2.11572266f,1.56909180f,1.35278320f,0.0f,0.0f,1.66796875f,-0.10083008f,-0.98754883f,-0.90820312f,0.0f,0.0f,-1.23535156f,1.07592773f,1.27612305f,-0.13500977f,0.0f,0.0f,0.14160156f,1.14819336f,0.50610352f,1.03027344f,0.0f,0.0f,0.73559570f,0.77636719f,-0.58837891f,0.77026367f,0.0f,0.0f,0.11206055f,1.46191406f,0.81250000f,-0.37133789f,0.0f,0.0f,0.75952148f,0.05029297f,-0.93554688f,2.27709961f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.91088867f,0.15234375f,-0.56274414f,-1.71972656f,0.0f,0.0f,2.47583008f,0.83935547f,-0.42675781f,2.15966797f,0.0f,0.0f,-0.90551758f,-0.84497070f,1.43994141f,-0.91943359f,0.0f,0.0f,-0.72094727f,-2.32812500f,0.27880859f,3.34594727f,0.0f,0.0f,2.96655273f,0.21972656f,3.49096680f,3.81787109f,0.0f,0.0f,-4.68041992f,-2.21093750f,3.04418945f,-4.27270508f,0.0f,0.0f,0.78906250f,0.30395508f,-1.12792969f,-0.38891602f,0.0f,0.0f,-2.44360352f,-0.54638672f,-2.25268555f,-2.91650391f,0.0f,0.0f,2.51586914f,-1.67407227f,3.41210938f,0.53881836f,0.0f,0.0f,1.03930664f,0.58837891f,-0.60913086f,-2.20336914f,0.0f,0.0f,3.58886719f,1.06201172f,-0.27001953f,-0.92333984f,0.0f,0.0f,-1.79785156f,-1.27172852f,0.34082031f,-1.99414062f,0.0f,0.0f,-0.73364258f,-3.36132812f,1.75781250f,-1.02685547f,0.0f,0.0f,6.38696289f,0.98217773f,0.92773438f,0.80395508f,0.0f,0.0f,0.36352539f,1.32958984f,-1.29565430f,1.15625000f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,1.40820312f,-1.22119141f,-0.87329102f,1.78173828f,0.0f,0.0f,0.55102539f,-0.35668945f,-0.48876953f,0.44799805f,0.0f,0.0f,-1.12500000f,-0.66772461f,-0.88232422f,0.74438477f,0.0f,0.0f,1.68164062f,-1.51708984f,-1.78857422f,0.25097656f,0.0f,0.0f,1.82495117f,-0.60253906f,0.86108398f,-1.55590820f,0.0f,0.0f,-0.75341797f,2.59399414f,0.55395508f,1.51000977f,0.0f,0.0f,-0.55151367f,0.23242188f,1.57495117f,-0.67578125f,0.0f,0.0f,2.21166992f,1.71362305f,0.66137695f,1.52856445f,0.0f,0.0f,0.14086914f,-0.02441406f,1.96728516f,-0.37182617f,0.0f,0.0f,-0.91040039f,0.04003906f,1.03027344f,0.74536133f,0.0f,0.0f,0.98120117f,-1.05639648f,-0.76074219f,-2.33300781f,0.0f,0.0f,0.42041016f,-3.71850586f,-0.27172852f,0.13159180f,0.0f,0.0f,-0.11108398f,-3.09765625f,-0.43579102f,0.32739258f,0.0f,0.0f,1.26025391f,1.41479492f,-0.95703125f,-0.26098633f,0.0f,0.0f,-0.49389648f,0.97705078f,0.80419922f,0.11523438f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.21166992f,0.77099609f,0.17333984f,2.88793945f,0.0f,0.0f,-0.49682617f,-1.27954102f,-0.44775391f,-0.58374023f,0.0f,0.0f,0.80834961f,-0.61669922f,-1.35253906f,-0.38085938f,0.0f,0.0f,1.04345703f,-0.82568359f,-0.23730469f,-2.22827148f,0.0f,0.0f,1.05688477f,-1.73071289f,-1.84619141f,-1.83422852f,0.0f,0.0f,0.68994141f,3.03833008f,-4.11718750f,-2.12573242f,0.0f,0.0f,-0.99902344f,2.22973633f,-1.71728516f,-0.14184570f,0.0f,0.0f,0.99121094f,-1.31079102f,0.09057617f,1.33593750f,0.0f,0.0f,-2.01000977f,-1.10668945f,-0.22436523f,-0.24584961f,0.0f,0.0f,1.82519531f,0.86425781f,0.45874023f,0.95483398f,0.0f,0.0f,-1.15087891f,-0.50170898f,-2.77587891f,-0.26123047f,0.0f,0.0f,-0.87182617f,-3.21289062f,-1.15942383f,-0.59594727f,0.0f,0.0f,1.58935547f,0.88452148f,-0.25341797f,1.87646484f,0.0f,0.0f,0.70581055f,0.50170898f,0.10253906f,-2.81176758f,0.0f,0.0f,-4.51464844f,-2.38232422f,-2.31958008f,0.50122070f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.06127930f,-0.25097656f,0.97680664f,-0.56030273f,0.0f,0.0f,-0.29150391f,2.05834961f,0.89770508f,1.06567383f,0.0f,0.0f,-0.65527344f,-1.13256836f,-1.03564453f,-1.50244141f,0.0f,0.0f,0.74121094f,3.03100586f,2.90332031f,-0.30737305f,0.0f,0.0f,0.43090820f,-0.90600586f,-0.44506836f,-1.87548828f,0.0f,0.0f,1.82250977f,-0.65869141f,2.25195312f,0.58398438f,0.0f,0.0f,2.02368164f,1.00610352f,0.33691406f,-1.79321289f,0.0f,0.0f,-1.29492188f,0.55664062f,0.31225586f,0.46777344f,0.0f,0.0f,1.19116211f,0.90747070f,2.73657227f,-2.20654297f,0.0f,0.0f,-1.41235352f,0.74145508f,-1.06298828f,0.30566406f,0.0f,0.0f,-4.61157227f,0.88354492f,-0.27832031f,-1.30322266f,0.0f,0.0f,-0.61596680f,-1.42529297f,-0.32080078f,3.48437500f,0.0f,0.0f,-1.76757812f,2.00537109f,0.25878906f,1.02001953f,0.0f,0.0f,0.00439453f,0.38623047f,2.33105469f,1.59570312f,0.0f,0.0f,0.22631836f,0.86010742f,-0.32788086f,2.37719727f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,2.25195312f,0.23120117f,-0.71557617f,2.14990234f,0.0f,0.0f,-0.70971680f,0.37792969f,0.30859375f,-1.89990234f,0.0f,0.0f,0.24609375f,-0.69677734f,-0.95141602f,2.79663086f,0.0f,0.0f,0.19702148f,-1.47167969f,0.22875977f,2.44873047f,0.0f,0.0f,-3.66723633f,0.68164062f,0.24072266f,-0.07226562f,0.0f,0.0f,2.18847656f,-0.35864258f,-1.67822266f,2.16430664f,0.0f,0.0f,-0.91259766f,2.22192383f,-1.13598633f,-0.74389648f,0.0f,0.0f,-0.51464844f,0.78540039f,1.16552734f,0.55200195f,0.0f,0.0f,3.08593750f,-1.87036133f,0.67285156f,-1.03051758f,0.0f,0.0f,2.97656250f,2.40136719f,-1.29663086f,-0.92944336f,0.0f,0.0f,-0.88476562f,-2.30102539f,0.71093750f,-3.22363281f,0.0f,0.0f,3.44262695f,0.10229492f,-0.40356445f,-3.68847656f,0.0f,0.0f,-0.48779297f,1.84765625f,-2.65991211f,1.03540039f,0.0f,0.0f,-0.75195312f,0.72290039f,-0.50292969f,-1.15795898f,0.0f,0.0f,-1.94824219f,-3.59594727f,0.89648438f,-0.44238281f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.36962891f,1.26879883f,-0.34179688f,1.19433594f,0.0f,0.0f,-0.16162109f,-0.52929688f,-0.65966797f,-0.56713867f,0.0f,0.0f,0.36718750f,-0.77319336f,-0.55468750f,1.05834961f,0.0f,0.0f,-0.28515625f,-1.29467773f,-0.75366211f,-2.81103516f,0.0f,0.0f,-0.28906250f,1.02221680f,0.98852539f,2.50659180f,0.0f,0.0f,0.02441406f,-0.34375000f,-1.11694336f,-1.43310547f,0.0f,0.0f,-3.29541016f,-1.28076172f,0.22705078f,-0.48120117f,0.0f,0.0f,1.67944336f,-0.06176758f,0.90454102f,0.69799805f,0.0f,0.0f,-3.59472656f,-0.98168945f,-0.97705078f,-2.42578125f,0.0f,0.0f,-0.61083984f,-2.35961914f,1.17895508f,-0.24438477f,0.0f,0.0f,0.16992188f,-2.61035156f,-1.75903320f,0.90698242f,0.0f,0.0f,1.31103516f,0.69580078f,-1.85522461f,-1.37841797f,0.0f,0.0f,1.33447266f,-0.91479492f,-1.22998047f,1.33178711f,0.0f,0.0f,1.62670898f,0.67797852f,-1.36938477f,-1.02563477f,0.0f,0.0f,0.13354492f,-1.28369141f,0.59936523f,-1.91772461f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-2.53344727f,-1.31494141f,1.31933594f,-0.01513672f,0.0f,0.0f,2.26831055f,-0.88159180f,0.63671875f,-3.63305664f,0.0f,0.0f,0.99267578f,3.68798828f,1.33251953f,1.86914062f,0.0f,0.0f,-0.04052734f,-0.02343750f,3.80883789f,-0.40625000f,0.0f,0.0f,-0.79370117f,-3.43994141f,1.35595703f,0.35424805f,0.0f,0.0f,2.25390625f,0.59667969f,1.64965820f,-2.99609375f,0.0f,0.0f,0.43725586f,2.59887695f,-2.45532227f,-1.38281250f,0.0f,0.0f,0.24047852f,1.72534180f,-1.97656250f,-0.15234375f,0.0f,0.0f,0.06909180f,-0.04321289f,0.66845703f,3.80981445f,0.0f,0.0f,2.35034180f,2.71679688f,0.16967773f,1.18383789f,0.0f,0.0f,-0.11425781f,0.68823242f,-0.43310547f,1.09887695f,0.0f,0.0f,-1.99926758f,2.37963867f,1.75415039f,3.46044922f,0.0f,0.0f,-3.24487305f,1.52514648f,0.78735352f,1.42944336f,0.0f,0.0f,0.92578125f,-0.34350586f,-1.72412109f,1.28833008f,0.0f,0.0f,1.54589844f,0.49243164f,1.46752930f,2.57812500f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.52026367f,0.97021484f,1.08666992f,-0.63403320f,0.0f,0.0f,-0.36938477f,-0.87402344f,-1.20581055f,1.75952148f,0.0f,0.0f,0.50732422f,-0.24121094f,-0.35156250f,-0.85449219f,0.0f,0.0f,-2.71606445f,-0.71801758f,-0.87597656f,-0.82299805f,0.0f,0.0f,0.20507812f,0.23876953f,2.48657227f,-1.33593750f,0.0f,0.0f,-0.29663086f,0.58764648f,2.28002930f,-1.32177734f,0.0f,0.0f,-0.11889648f,-0.47241211f,0.24511719f,-0.02758789f,0.0f,0.0f,-2.70874023f,-1.16357422f,-1.14453125f,-1.91699219f,0.0f,0.0f,2.20410156f,-0.10791016f,1.27685547f,-0.13159180f,0.0f,0.0f,-1.93627930f,1.18457031f,-0.84033203f,1.24829102f,0.0f,0.0f,-0.92480469f,-0.37915039f,-0.20239258f,-1.83886719f,0.0f,0.0f,-1.96972656f,-2.11303711f,-2.53735352f,-0.59375000f,0.0f,0.0f,0.54150391f,0.26684570f,0.32519531f,0.69970703f,0.0f,0.0f,2.42651367f,1.76635742f,-0.88891602f,3.21508789f,0.0f,0.0f,0.00683594f,1.90112305f,-0.49218750f,-1.24267578f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.41796875f,-1.70996094f,1.82153320f,-0.26293945f,0.0f,0.0f,0.59838867f,2.27978516f,1.10083008f,-0.62182617f,0.0f,0.0f,1.05322266f,-0.22875977f,-1.26464844f,-1.38549805f,0.0f,0.0f,1.08154297f,0.19213867f,0.98925781f,0.53662109f,0.0f,0.0f,-3.21850586f,1.33715820f,-1.72119141f,0.73608398f,0.0f,0.0f,0.38427734f,-1.98388672f,-0.25488281f,1.40795898f,0.0f,0.0f,-0.87109375f,4.20507812f,0.99438477f,-2.92065430f,0.0f,0.0f,4.82519531f,0.93554688f,0.64648438f,3.00488281f,0.0f,0.0f,0.71508789f,-0.98852539f,-1.20776367f,-1.04687500f,0.0f,0.0f,0.42553711f,0.97094727f,-0.94360352f,0.46093750f,0.0f,0.0f,-1.26977539f,-0.39526367f,-0.19311523f,2.33447266f,0.0f,0.0f,-1.27490234f,0.97631836f,1.69067383f,1.52929688f,0.0f,0.0f,0.36914062f,-0.31176758f,-0.58129883f,-1.66699219f,0.0f,0.0f,1.52978516f,-3.00708008f,-2.95166016f,1.35620117f,0.0f,0.0f,1.47583008f,1.43798828f,1.13549805f,0.85375977f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.30126953f,-0.42944336f,0.54394531f,0.82006836f,0.0f,0.0f,-0.78613281f,-1.01855469f,-1.84814453f,0.55273438f,0.0f,0.0f,-1.47290039f,-1.03955078f,0.25341797f,0.33276367f,0.0f,0.0f,-0.58911133f,0.08129883f,2.31518555f,0.49633789f,0.0f,0.0f,1.53833008f,-0.28857422f,0.37890625f,0.92797852f,0.0f,0.0f,-0.70703125f,2.26806641f,-2.06030273f,-0.62817383f,0.0f,0.0f,1.41406250f,0.45556641f,0.32641602f,2.57128906f,0.0f,0.0f,2.15063477f,-0.99536133f,-0.35766602f,-1.38891602f,0.0f,0.0f,1.42333984f,1.97949219f,1.77929688f,1.10400391f,0.0f,0.0f,0.04272461f,-0.50415039f,-1.31420898f,1.06616211f,0.0f,0.0f,1.13940430f,-2.63989258f,1.51562500f,0.24780273f,0.0f,0.0f,2.37451172f,1.60888672f,0.63330078f,-3.07202148f,0.0f,0.0f,-0.64965820f,-0.07568359f,-0.75634766f,-1.09741211f,0.0f,0.0f,-1.43432617f,0.72631836f,3.37133789f,0.86523438f,0.0f,0.0f,-1.65795898f,0.95434570f,-1.78588867f,-1.11767578f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.24267578f,1.56127930f,-0.86303711f,0.16284180f,0.0f,0.0f,0.41870117f,-1.94677734f,-2.26855469f,-0.62084961f,0.0f,0.0f,-0.17944336f,-1.76245117f,0.39599609f,0.37817383f,0.0f,0.0f,-0.67309570f,-2.28222656f,1.42065430f,0.27441406f,0.0f,0.0f,1.49755859f,-0.60595703f,-2.14941406f,3.30151367f,0.0f,0.0f,-1.35009766f,0.21704102f,2.63623047f,2.96630859f,0.0f,0.0f,-1.27001953f,-0.04125977f,-3.36572266f,-0.27099609f,0.0f,0.0f,-0.10327148f,-0.14746094f,1.40502930f,0.67431641f,0.0f,0.0f,0.08837891f,0.29052734f,-0.93090820f,-0.46313477f,0.0f,0.0f,-1.12524414f,0.36206055f,-1.24804688f,0.26269531f,0.0f,0.0f,0.07519531f,5.44140625f,0.44702148f,-2.99682617f,0.0f,0.0f,0.30273438f,0.93603516f,-1.72851562f,-2.48291016f,0.0f,0.0f,-0.73779297f,-3.11889648f,2.18359375f,-0.58837891f,0.0f,0.0f,-0.36840820f,2.69824219f,-1.26489258f,-3.77368164f,0.0f,0.0f,0.89331055f,4.66113281f,-1.75366211f,-2.29785156f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.53979492f,-0.39624023f,0.29516602f,1.67993164f,0.0f,0.0f,-0.25854492f,0.40600586f,-1.64868164f,-1.33081055f,0.0f,0.0f,0.31054688f,0.12890625f,1.94824219f,2.38647461f,0.0f,0.0f,-0.63452148f,0.49414062f,-3.72949219f,-1.85449219f,0.0f,0.0f,2.11791992f,0.95336914f,2.31469727f,0.25659180f,0.0f,0.0f,-1.66625977f,-0.06420898f,-0.76245117f,0.37402344f,0.0f,0.0f,-2.53027344f,-0.29638672f,-1.44921875f,-1.92626953f,0.0f,0.0f,-1.33984375f,2.22363281f,3.33422852f,-1.60742188f,0.0f,0.0f,-2.35986328f,-0.41284180f,-0.98486328f,0.87329102f,0.0f,0.0f,-2.14721680f,1.23193359f,0.39062500f,0.11181641f,0.0f,0.0f,-0.82885742f,0.08349609f,-4.34912109f,1.99609375f,0.0f,0.0f,1.20922852f,-1.90600586f,-0.40307617f,1.43530273f,0.0f,0.0f,-1.09619141f,1.20019531f,1.71606445f,2.66235352f,0.0f,0.0f,-2.49145508f,-0.32128906f,-2.83691406f,1.06884766f,0.0f,0.0f,-0.37524414f,-2.75341797f,-0.02075195f,1.21801758f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,1.36669922f,2.01245117f,-1.39013672f,0.24853516f,0.0f,0.0f,-1.19677734f,-0.24877930f,-1.02124023f,0.73461914f,0.0f,0.0f,-0.23779297f,0.27124023f,0.31225586f,1.02319336f,0.0f,0.0f,-2.31347656f,0.40649414f,-0.39648438f,1.26416016f,0.0f,0.0f,-2.06811523f,1.41967773f,2.03149414f,2.11132812f,0.0f,0.0f,-0.92504883f,-0.47216797f,-1.62255859f,1.93701172f,0.0f,0.0f,-0.37207031f,2.07250977f,-0.19018555f,-0.73364258f,0.0f,0.0f,2.28857422f,-2.53515625f,-0.49829102f,1.32202148f,0.0f,0.0f,-1.76220703f,-0.34667969f,1.97143555f,-0.27734375f,0.0f,0.0f,0.32324219f,0.57202148f,-2.04272461f,2.06762695f,0.0f,0.0f,0.48291016f,0.94555664f,1.20092773f,-0.11279297f,0.0f,0.0f,3.42578125f,-1.06835938f,-2.11132812f,-0.29516602f,0.0f,0.0f,1.78051758f,1.88378906f,-1.93090820f,0.75952148f,0.0f,0.0f,1.50805664f,2.47534180f,-2.70532227f,-0.11865234f,0.0f,0.0f,-1.29833984f,-0.94555664f,1.35571289f,-1.74023438f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.58666992f,0.78808594f,-1.90844727f,-1.30151367f,0.0f,0.0f,-0.10009766f,-0.69604492f,0.05468750f,0.66503906f,0.0f,0.0f,-0.55151367f,-1.30834961f,-0.49682617f,-1.28784180f,0.0f,0.0f,0.32055664f,-1.41552734f,2.08251953f,-0.52807617f,0.0f,0.0f,0.50097656f,2.62548828f,-0.03784180f,-0.53955078f,0.0f,0.0f,0.60034180f,0.60327148f,1.35131836f,-0.83251953f,0.0f,0.0f,2.52612305f,-0.23144531f,2.53540039f,0.90917969f,0.0f,0.0f,0.21044922f,0.62426758f,0.25610352f,-0.39843750f,0.0f,0.0f,1.17529297f,1.91503906f,1.65112305f,1.68530273f,0.0f,0.0f,-0.13012695f,-0.49829102f,2.90161133f,-0.50805664f,0.0f,0.0f,0.38452148f,1.64624023f,-0.05200195f,-2.11474609f,0.0f,0.0f,-0.13232422f,-0.62866211f,-1.25610352f,0.15429688f,0.0f,0.0f,0.00048828f,-0.61279297f,0.14868164f,-3.70727539f,0.0f,0.0f,-0.54663086f,-0.34765625f,0.36425781f,-1.15698242f,0.0f,0.0f,-3.18652344f,1.43017578f,1.40063477f,0.69702148f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.53686523f,0.55859375f,0.59057617f,0.48681641f,0.0f,0.0f,0.78417969f,-1.39355469f,-0.36230469f,0.25292969f,0.0f,0.0f,-0.36816406f,3.59057617f,0.11767578f,-0.38159180f,0.0f,0.0f,-2.20581055f,-0.58032227f,-0.92382812f,0.69140625f,0.0f,0.0f,-0.00024414f,-0.52661133f,-1.13134766f,0.14550781f,0.0f,0.0f,-2.03881836f,-1.44335938f,1.30786133f,3.58959961f,0.0f,0.0f,-0.73901367f,0.52539062f,-2.73022461f,-0.68627930f,0.0f,0.0f,-1.99365234f,-1.61816406f,2.27612305f,-1.29345703f,0.0f,0.0f,-0.93237305f,0.38183594f,-1.52832031f,-1.89526367f,0.0f,0.0f,-2.46313477f,-0.33691406f,1.24121094f,-0.32763672f,0.0f,0.0f,-1.99780273f,0.66943359f,0.20922852f,2.07934570f,0.0f,0.0f,-2.83300781f,-2.25195312f,-1.48510742f,0.58764648f,0.0f,0.0f,2.27441406f,0.32641602f,1.39672852f,-0.74243164f,0.0f,0.0f,-0.26123047f,-0.43115234f,-2.11914062f,-1.82299805f,0.0f,0.0f,0.81079102f,-3.67138672f,0.14941406f,1.81494141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.08569336f,-0.40698242f,0.62963867f,-0.87548828f,0.0f,0.0f,0.56542969f,1.59814453f,1.37670898f,0.60815430f,0.0f,0.0f,0.26245117f,-0.20190430f,-1.31469727f,0.09082031f,0.0f,0.0f,0.05126953f,1.88378906f,-0.26489258f,-1.57592773f,0.0f,0.0f,-0.90136719f,0.49951172f,1.69311523f,-0.74047852f,0.0f,0.0f,2.32739258f,-0.00512695f,-0.44604492f,-1.16748047f,0.0f,0.0f,0.45434570f,-0.26611328f,-0.66406250f,-2.43066406f,0.0f,0.0f,-0.70678711f,1.23510742f,-2.58447266f,-0.53198242f,0.0f,0.0f,0.94604492f,-2.61816406f,0.27807617f,-0.33862305f,0.0f,0.0f,-2.50463867f,0.64501953f,0.22900391f,-0.00122070f,0.0f,0.0f,-1.88720703f,0.53466797f,-1.43261719f,-0.56787109f,0.0f,0.0f,0.09106445f,1.43017578f,-0.26196289f,-0.99169922f,0.0f,0.0f,1.03662109f,-1.58789062f,-0.07470703f,-0.46655273f,0.0f,0.0f,-0.15917969f,-0.92871094f,-0.98339844f,0.36596680f,0.0f,0.0f,-0.90527344f,1.44091797f,-1.43115234f,0.97241211f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.31298828f,-2.11035156f,0.27270508f,3.79394531f,0.0f,0.0f,-0.33349609f,-1.02636719f,0.68701172f,-1.82470703f,0.0f,0.0f,0.03320312f,-1.10766602f,-0.83105469f,-0.85351562f,0.0f,0.0f,0.75561523f,-1.85400391f,0.60766602f,2.51171875f,0.0f,0.0f,-0.66162109f,-0.81347656f,2.02465820f,-2.61010742f,0.0f,0.0f,-1.00122070f,0.64257812f,-1.92260742f,-2.35156250f,0.0f,0.0f,-4.65747070f,2.96655273f,-1.08422852f,1.59887695f,0.0f,0.0f,1.15136719f,-5.16308594f,-2.49218750f,-0.33740234f,0.0f,0.0f,3.40795898f,1.05200195f,0.37695312f,-1.60888672f,0.0f,0.0f,0.37280273f,-2.52734375f,1.33789062f,-0.19482422f,0.0f,0.0f,0.15844727f,2.05102539f,-3.27954102f,0.46899414f,0.0f,0.0f,1.05688477f,0.73046875f,-0.92651367f,2.37280273f,0.0f,0.0f,-1.20361328f,-4.52319336f,-0.91015625f,5.02661133f,0.0f,0.0f,0.33178711f,0.14477539f,1.70117188f,2.96289062f,0.0f,0.0f,3.43188477f,2.40722656f,2.12890625f,-0.12255859f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.86914062f,-0.66699219f,-0.87402344f,0.59252930f,0.0f,0.0f,0.09448242f,0.67114258f,-0.28271484f,-0.68603516f,0.0f,0.0f,-0.29492188f,1.30737305f,-0.42529297f,1.11157227f,0.0f,0.0f,0.89404297f,-0.79321289f,1.55419922f,1.22827148f,0.0f,0.0f,0.04882812f,-0.23950195f,-0.54931641f,1.88305664f,0.0f,0.0f,-0.53955078f,0.61596680f,-0.25830078f,0.54223633f,0.0f,0.0f,0.55151367f,-0.33715820f,-0.53491211f,-0.17041016f,0.0f,0.0f,3.96386719f,1.01293945f,1.20825195f,-0.53466797f,0.0f,0.0f,0.85742188f,-0.64379883f,0.21850586f,0.05200195f,0.0f,0.0f,1.14233398f,-1.48535156f,-0.52612305f,1.35058594f,0.0f,0.0f,0.86865234f,1.51635742f,-0.70703125f,-0.44335938f,0.0f,0.0f,0.06347656f,-0.82910156f,0.44824219f,-0.39965820f,0.0f,0.0f,-3.67724609f,-0.22290039f,0.33422852f,-0.81542969f,0.0f,0.0f,-1.71826172f,0.70629883f,0.13403320f,-0.16235352f,0.0f,0.0f,-0.88720703f,0.18286133f,-0.13378906f,-1.25244141f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.92089844f,-0.60839844f,0.04931641f,-1.97631836f,0.0f,0.0f,0.36743164f,0.56420898f,-1.57031250f,-0.78857422f,0.0f,0.0f,0.47216797f,-0.19433594f,0.16479492f,2.54467773f,0.0f,0.0f,-0.84399414f,-4.26318359f,0.71508789f,0.95410156f,0.0f,0.0f,-0.08300781f,0.33911133f,0.17016602f,-2.49780273f,0.0f,0.0f,-2.47827148f,0.07788086f,1.69824219f,-1.24243164f,0.0f,0.0f,3.03247070f,2.37182617f,-0.72973633f,-2.26831055f,0.0f,0.0f,-1.28833008f,1.31567383f,0.51953125f,-1.18579102f,0.0f,0.0f,2.06372070f,3.21899414f,-0.76611328f,0.06030273f,0.0f,0.0f,1.51660156f,0.81250000f,0.83544922f,0.73364258f,0.0f,0.0f,0.59667969f,-3.11401367f,4.15991211f,1.78442383f,0.0f,0.0f,-0.19799805f,-1.67578125f,-1.52685547f,-1.49731445f,0.0f,0.0f,-3.75122070f,-0.23779297f,-3.59448242f,2.55273438f,0.0f,0.0f,-1.86450195f,-0.54150391f,1.96069336f,-1.08715820f,0.0f,0.0f,-1.19287109f,-3.58642578f,-7.10400391f,1.76489258f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.47534180f,-0.71704102f,0.87255859f,1.27783203f,0.0f,0.0f,-0.52172852f,1.97143555f,0.96948242f,-1.99291992f,0.0f,0.0f,-0.24536133f,0.18652344f,-1.06518555f,0.98022461f,0.0f,0.0f,0.66870117f,-0.28857422f,0.77661133f,-0.86157227f,0.0f,0.0f,0.23730469f,-0.04467773f,-0.69775391f,-0.20727539f,0.0f,0.0f,-2.72998047f,2.62866211f,0.35864258f,1.94458008f,0.0f,0.0f,1.57885742f,-0.59960938f,-2.25024414f,-1.73388672f,0.0f,0.0f,-0.90356445f,0.40991211f,2.55810547f,2.55004883f,0.0f,0.0f,0.91845703f,-0.14404297f,2.09277344f,-1.43383789f,0.0f,0.0f,0.94921875f,-1.39794922f,-2.72094727f,1.19677734f,0.0f,0.0f,0.29516602f,3.21289062f,-0.59814453f,-1.18139648f,0.0f,0.0f,2.64648438f,0.88305664f,0.25219727f,-1.34350586f,0.0f,0.0f,-1.68261719f,-1.86718750f,2.50854492f,0.41186523f,0.0f,0.0f,0.66723633f,1.42016602f,0.79541016f,0.76928711f,0.0f,0.0f,-3.46118164f,-2.44653320f,2.21118164f,0.28540039f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-1.37573242f,-0.40771484f,1.06127930f,-1.21557617f,0.0f,0.0f,-0.70825195f,0.85620117f,-0.64965820f,0.83056641f,0.0f,0.0f,-3.56909180f,0.76708984f,-1.29541016f,1.34179688f,0.0f,0.0f,-0.96069336f,-0.54028320f,-1.04956055f,-0.59594727f,0.0f,0.0f,-2.22558594f,3.61621094f,-1.38476562f,0.66137695f,0.0f,0.0f,-0.17236328f,-1.02514648f,-0.51074219f,3.14599609f,0.0f,0.0f,2.65063477f,-1.00610352f,-0.68798828f,-3.18627930f,0.0f,0.0f,3.21923828f,3.60253906f,0.86401367f,1.31176758f,0.0f,0.0f,-0.57958984f,-1.63745117f,-0.74096680f,3.26000977f,0.0f,0.0f,2.21215820f,1.43725586f,-1.48486328f,-1.48510742f,0.0f,0.0f,1.34497070f,1.55224609f,0.97900391f,-0.34228516f,0.0f,0.0f,-0.48461914f,-0.16943359f,-0.86669922f,0.08813477f,0.0f,0.0f,-0.45166016f,-2.11474609f,-1.52124023f,1.31079102f,0.0f,0.0f,3.13574219f,3.04541016f,-1.87280273f,-1.97216797f,0.0f,0.0f,2.50561523f,0.62304688f,-0.92944336f,-0.29077148f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.27416992f,1.79028320f,-1.32666016f,-0.25122070f,0.0f,0.0f,0.43164062f,-0.82495117f,-1.71484375f,1.70825195f,0.0f,0.0f,1.28222656f,-0.62377930f,-1.01269531f,0.39672852f,0.0f,0.0f,0.49291992f,2.09765625f,-0.00634766f,2.77099609f,0.0f,0.0f,0.56250000f,-1.98657227f,0.07202148f,1.61572266f,0.0f,0.0f,3.65063477f,-3.59155273f,0.21679688f,0.19946289f,0.0f,0.0f,1.30200195f,1.05322266f,4.44946289f,0.93530273f,0.0f,0.0f,0.50610352f,-3.04882812f,-1.03930664f,0.25903320f,0.0f,0.0f,0.46215820f,-0.38085938f,-1.06494141f,-1.35961914f,0.0f,0.0f,-2.98071289f,1.89379883f,2.63720703f,0.83789062f,0.0f,0.0f,-1.73803711f,-5.02026367f,0.51586914f,0.48876953f,0.0f,0.0f,-1.50317383f,-0.28808594f,-2.06396484f,-0.34936523f,0.0f,0.0f,-0.54418945f,2.62231445f,0.73315430f,-1.35229492f,0.0f,0.0f,-2.66772461f,-2.05737305f,0.56176758f,-0.44067383f,0.0f,0.0f,0.77075195f,0.83227539f,-0.47875977f,1.40649414f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.09179688f,-2.26684570f,0.33325195f,0.61572266f,0.0f,0.0f,1.54882812f,0.59204102f,2.40502930f,2.01904297f,0.0f,0.0f,-0.71142578f,1.97314453f,3.36279297f,-0.47729492f,0.0f,0.0f,1.69140625f,-0.37060547f,-3.99951172f,-2.17016602f,0.0f,0.0f,-0.30541992f,3.01635742f,1.91064453f,-1.04052734f,0.0f,0.0f,-0.15844727f,1.83056641f,2.87573242f,1.92553711f,0.0f,0.0f,-0.30053711f,0.92846680f,-4.23950195f,1.87426758f,0.0f,0.0f,-0.60644531f,-0.98486328f,-3.92187500f,2.31372070f,0.0f,0.0f,2.87524414f,1.39428711f,-0.76586914f,0.98413086f,0.0f,0.0f,2.07080078f,0.46752930f,2.17260742f,-1.26538086f,0.0f,0.0f,1.11254883f,2.58569336f,0.62597656f,1.30859375f,0.0f,0.0f,2.19653320f,1.80371094f,0.95166016f,-1.34619141f,0.0f,0.0f,2.91357422f,-4.68969727f,-1.61645508f,0.52465820f,0.0f,0.0f,0.87817383f,-2.49609375f,0.31713867f,-0.92431641f,0.0f,0.0f,-0.50585938f,2.95678711f,2.95703125f,-0.54296875f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,0.0f,-0.05249023f,-0.81762695f,0.24023438f,1.01367188f,0.0f,0.0f,-0.54614258f,-1.55004883f,-0.52026367f,-1.82128906f,0.0f,0.0f,0.31127930f,-0.87670898f,0.92651367f,-0.84863281f,0.0f,0.0f,2.30859375f,-0.26928711f,1.90722656f,-1.88232422f,0.0f,0.0f,-1.26904297f,-0.24829102f,1.00146484f,0.15112305f,0.0f,0.0f,-0.92163086f,-0.71752930f,-0.09228516f,-2.17382812f,0.0f,0.0f,-1.98852539f,-0.60742188f,-3.98266602f,-1.33471680f,0.0f,0.0f,0.83666992f,-1.53002930f,1.99267578f,-2.30322266f,0.0f,0.0f,-0.75805664f,-0.61376953f,0.31713867f,-3.45971680f,0.0f,0.0f,-1.20239258f,-2.27856445f,-0.95800781f,0.70996094f,0.0f,0.0f,-1.31835938f,1.04272461f,-1.51855469f,0.68750000f,0.0f,0.0f,0.34277344f,-2.71337891f,-1.40429688f,0.53613281f,0.0f,0.0f,-0.44848633f,-1.46777344f,0.86230469f,0.12939453f,0.0f,0.0f,-2.99707031f,-0.12011719f,-0.96997070f,-0.35546875f,0.0f,0.0f,-0.71386719f,0.84082031f,1.89477539f,0.05664062f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    // EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_4items_strided)
{
    Shape shape_a{4,3,3,5,8,7};
    Shape shape_b{4,3,2,2,3,1};
    Shape shape_r{4,4,1,4,2,4};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{2,1,3,2},        // move_strides
                                                                  Strides{1,1,1,1},        // filter_dilation
                                                                  CoordinateDiff{0,0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0,0}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f,-0.60937500f,-0.15625000f,0.20312500f,-0.37500000f,-0.75000000f,-0.17187500f,-0.67187500f,-0.75000000f,0.31250000f,-0.26562500f,-0.78125000f,-0.87500000f,-0.28125000f,-0.92187500f,0.96875000f,0.43750000f,-0.32812500f,-0.23437500f,0.04687500f,-0.90625000f,-0.14062500f,-0.89062500f,0.18750000f,-0.46875000f,-0.18750000f,-0.53125000f,0.43750000f,-0.73437500f,-0.98437500f,0.82812500f,0.15625000f,-0.51562500f,-0.46875000f,-0.53125000f,-0.07812500f,-0.23437500f,0.04687500f,-0.64062500f,0.18750000f,0.90625000f,-0.12500000f,-0.18750000f,0.93750000f,-0.98437500f,0.07812500f,-0.43750000f,0.51562500f,1.00000000f,-0.43750000f,0.31250000f,-0.98437500f,-0.34375000f,0.87500000f,-0.62500000f,1.00000000f,0.73437500f,-0.37500000f,0.85937500f,-0.70312500f,0.82812500f,0.18750000f,0.23437500f,0.07812500f,-0.67187500f,-0.93750000f,0.32812500f,0.89062500f,0.06250000f,-0.79687500f,-0.18750000f,0.65625000f,-0.92187500f,0.07812500f,-0.84375000f,0.15625000f,-0.32812500f,-0.43750000f,0.87500000f,0.87500000f,-0.70312500f,0.82812500f,-0.67187500f,-0.75000000f,-0.01562500f,-0.79687500f,0.15625000f,-0.21875000f,-0.31250000f,-0.48437500f,0.48437500f,-0.85937500f,-0.18750000f,-0.20312500f,0.45312500f,-0.87500000f,0.28125000f,0.81250000f,-0.56250000f,-0.12500000f,-0.06250000f,0.03125000f,-0.82812500f,0.56250000f,0.01562500f,-0.59375000f,-0.76562500f,0.70312500f,-1.00000000f,-0.87500000f,-0.68750000f,-0.64062500f,0.93750000f,-0.50000000f,0.73437500f,0.92187500f,-0.95312500f,-0.45312500f,-0.06250000f,-0.06250000f,-0.60937500f,-0.01562500f,-0.17187500f,0.34375000f,-0.95312500f,-0.01562500f,-0.85937500f,-0.85937500f,0.42187500f,-0.57812500f,-0.67187500f,0.35937500f,-0.06250000f,0.78125000f,-0.26562500f,-0.10937500f,0.92187500f,0.17187500f,0.46875000f,0.56250000f,0.20312500f,-0.42187500f,0.00000000f,0.12500000f,-0.92187500f,-0.14062500f,0.48437500f,-0.60937500f,0.50000000f,0.87500000f,0.25000000f,-0.59375000f,-0.04687500f,0.29687500f,0.31250000f,0.45312500f,-0.96875000f,-0.70312500f,0.87500000f,0.62500000f,-0.34375000f,-0.90625000f,0.07812500f,0.51562500f,0.35937500f,0.40625000f,-0.62500000f,0.48437500f,-0.50000000f,-0.23437500f,0.68750000f,-0.23437500f,-0.85937500f,0.95312500f,0.51562500f,-0.15625000f,0.35937500f,0.50000000f,0.73437500f,0.71875000f,-0.62500000f,0.45312500f,0.40625000f,-0.18750000f,-0.85937500f,0.42187500f,-0.67187500f,0.62500000f,-0.60937500f,-0.54687500f,0.21875000f,0.50000000f,0.65625000f,0.32812500f,0.87500000f,-0.01562500f,0.40625000f,0.17187500f,0.93750000f,-0.95312500f,-0.20312500f,-0.73437500f,0.40625000f,-0.20312500f,0.20312500f,-0.04687500f,-0.65625000f,0.64062500f,0.65625000f,-0.71875000f,0.31250000f,-0.35937500f,-0.28125000f,0.15625000f,1.00000000f,1.00000000f,0.43750000f,-0.20312500f,-0.53125000f,0.92187500f,0.90625000f,0.07812500f,0.50000000f,0.43750000f,-0.57812500f,0.84375000f,-0.67187500f,0.09375000f,-0.17187500f,-0.64062500f,0.14062500f,-0.67187500f,1.00000000f,-0.48437500f,-0.37500000f,0.00000000f,0.21875000f,0.96875000f,0.06250000f,-0.81250000f,0.78125000f,0.87500000f,0.67187500f,0.45312500f,-0.96875000f,-0.29687500f,-0.60937500f,0.70312500f,0.56250000f,0.59375000f,0.87500000f,0.95312500f,0.03125000f,-0.64062500f,-0.62500000f,-0.43750000f,0.51562500f,-0.17187500f,-0.06250000f,0.03125000f,-0.48437500f,-0.95312500f,-0.31250000f,-0.40625000f,-0.89062500f,-0.64062500f,0.23437500f,0.87500000f,0.48437500f,0.54687500f,0.82812500f,0.70312500f,-0.68750000f,0.87500000f,0.93750000f,0.92187500f,-0.03125000f,0.65625000f,0.04687500f,-0.25000000f,0.10937500f,-0.57812500f,-0.21875000f,0.25000000f,-0.15625000f,0.89062500f,0.35937500f,0.96875000f,-0.31250000f,-0.04687500f,-0.04687500f,0.46875000f,-0.51562500f,-0.25000000f,0.67187500f,-0.70312500f,0.28125000f,-0.48437500f,0.71875000f,-0.43750000f,-0.28125000f,-0.81250000f,0.70312500f,0.95312500f,0.31250000f,-0.31250000f,-0.29687500f,0.20312500f,-0.95312500f,0.64062500f,-0.87500000f,-0.42187500f,0.90625000f,-0.65625000f,-0.85937500f,-0.84375000f,0.50000000f,0.17187500f,-0.37500000f,-1.00000000f,-0.89062500f,-0.68750000f,0.53125000f,0.95312500f,0.17187500f,-0.70312500f,0.46875000f,0.53125000f,-0.31250000f,0.67187500f,0.89062500f,0.32812500f,-0.53125000f,-0.57812500f,0.54687500f,-0.98437500f,0.23437500f,0.01562500f,0.65625000f,-0.43750000f,-0.54687500f,0.93750000f,-0.71875000f,-0.84375000f,0.18750000f,0.59375000f,-0.95312500f,-0.50000000f,0.93750000f,-0.07812500f,-0.68750000f,0.85937500f,-0.35937500f,-0.26562500f,-0.79687500f,-0.95312500f,-0.90625000f,-0.50000000f,0.56250000f,0.85937500f,0.50000000f,-0.04687500f,0.35937500f,-0.78125000f,0.50000000f,-0.93750000f,-0.40625000f,-0.70312500f,0.15625000f,-0.07812500f,0.40625000f,0.70312500f,0.46875000f,-0.71875000f,-0.03125000f,-0.87500000f,-0.84375000f,-0.34375000f,0.00000000f,0.17187500f,-0.93750000f,0.62500000f,-0.76562500f,-0.26562500f,0.98437500f,0.40625000f,1.00000000f,-0.90625000f,-0.23437500f,0.50000000f,0.53125000f,-0.90625000f,-0.62500000f,0.96875000f,-0.59375000f,-0.10937500f,0.89062500f,-1.00000000f,0.70312500f,0.98437500f,0.15625000f,-0.26562500f,0.50000000f,0.56250000f,-0.26562500f,0.10937500f,0.78125000f,0.70312500f,0.20312500f,-0.84375000f,0.50000000f,0.96875000f,0.57812500f,-0.18750000f,0.03125000f,0.68750000f,-0.64062500f,-0.29687500f,-0.62500000f,0.32812500f,-0.90625000f,-0.39062500f,0.17187500f,0.73437500f,-0.65625000f,-0.10937500f,0.76562500f,0.59375000f,0.65625000f,-0.43750000f,0.39062500f,-0.18750000f,0.09375000f,0.07812500f,0.35937500f,0.15625000f,0.18750000f,-0.35937500f,0.78125000f,-0.45312500f,-0.87500000f,-0.50000000f,-0.60937500f,0.37500000f,-0.64062500f,0.32812500f,0.81250000f,-0.96875000f,-0.92187500f,-0.73437500f,0.07812500f,0.00000000f,-0.56250000f,-0.20312500f,0.32812500f,0.78125000f,0.78125000f,-0.32812500f,0.68750000f,-0.23437500f,-0.57812500f,-0.76562500f,-0.35937500f,-0.53125000f,0.04687500f,-0.45312500f,-0.04687500f,0.00000000f,0.48437500f,-0.59375000f,0.37500000f,0.81250000f,0.95312500f,-0.48437500f,0.20312500f,0.01562500f,-0.62500000f,-0.75000000f,-0.64062500f,0.65625000f,-0.50000000f,-0.18750000f,-0.84375000f,-0.14062500f,0.51562500f,0.03125000f,-0.50000000f,0.51562500f,-0.98437500f,0.93750000f,0.78125000f,-0.96875000f,-0.57812500f,0.31250000f,0.10937500f,0.92187500f,-0.92187500f,0.25000000f,-0.31250000f,-0.15625000f,0.09375000f,0.43750000f,-0.76562500f,-0.14062500f,-0.68750000f,-0.14062500f,-0.03125000f,0.90625000f,-0.71875000f,-0.56250000f,0.64062500f,0.76562500f,0.60937500f,0.81250000f,-0.48437500f,0.46875000f,0.65625000f,-0.29687500f,0.48437500f,-0.43750000f,0.82812500f,-0.26562500f,0.64062500f,-0.01562500f,0.35937500f,-0.29687500f,-0.84375000f,-0.92187500f,-0.84375000f,0.73437500f,0.09375000f,-0.53125000f,-0.15625000f,0.12500000f,0.84375000f,-0.78125000f,-0.51562500f,0.42187500f,0.25000000f,0.37500000f,0.18750000f,0.18750000f,0.67187500f,0.96875000f,0.62500000f,0.23437500f,0.57812500f,0.10937500f,-0.31250000f,-0.78125000f,0.79687500f,0.29687500f,0.96875000f,-0.70312500f,-0.96875000f,-0.75000000f,-0.01562500f,-0.37500000f,0.03125000f,0.10937500f,0.95312500f,-0.59375000f,0.78125000f,-0.20312500f,-0.15625000f,0.15625000f,-0.82812500f,0.60937500f,0.26562500f,0.32812500f,-0.90625000f,0.21875000f,-0.37500000f,0.37500000f,0.03125000f,-0.37500000f,-0.81250000f,0.81250000f,-0.89062500f,-0.75000000f,-0.96875000f,0.76562500f,0.43750000f,0.35937500f,-0.89062500f,0.75000000f,-0.04687500f,-1.00000000f,0.98437500f,0.70312500f,-0.85937500f,-0.17187500f,0.46875000f,0.56250000f,-0.25000000f,0.60937500f,-0.92187500f,-0.57812500f,0.89062500f,-0.29687500f,0.84375000f,-0.09375000f,0.28125000f,-0.06250000f,0.87500000f,0.12500000f,-0.25000000f,-0.96875000f,0.10937500f,-0.53125000f,0.89062500f,-0.62500000f,-0.57812500f,0.18750000f,0.07812500f,0.28125000f,-0.06250000f,0.34375000f,-0.46875000f,-0.35937500f,0.50000000f,-0.07812500f,1.00000000f,1.00000000f,0.45312500f,-0.82812500f,-0.59375000f,-0.90625000f,0.06250000f,-0.93750000f,0.85937500f,0.43750000f,0.89062500f,0.32812500f,-0.92187500f,0.87500000f,-0.62500000f,-0.62500000f,-0.25000000f,-0.70312500f,0.87500000f,0.57812500f,0.93750000f,0.84375000f,-0.48437500f,-0.40625000f,-0.90625000f,-0.48437500f,0.95312500f,-0.57812500f,0.40625000f,-0.90625000f,0.26562500f,-0.76562500f,-0.51562500f,0.85937500f,0.84375000f,0.45312500f,-0.76562500f,-0.12500000f,-0.03125000f,-1.00000000f,-0.65625000f,0.17187500f,0.12500000f,0.40625000f,1.00000000f,0.17187500f,-0.37500000f,0.48437500f,0.06250000f,-0.68750000f,-0.84375000f,0.35937500f,-0.14062500f,-0.12500000f,0.60937500f,-0.51562500f,1.00000000f,-0.25000000f,-0.81250000f,0.29687500f,-0.54687500f,0.35937500f,-0.60937500f,-0.98437500f,-0.12500000f,-0.31250000f,0.64062500f,-0.03125000f,0.46875000f,0.37500000f,0.53125000f,0.09375000f,-0.09375000f,0.60937500f,-0.56250000f,0.18750000f,-0.76562500f,0.00000000f,-0.15625000f,0.79687500f,0.53125000f,-0.46875000f,1.00000000f,-0.78125000f,0.39062500f,0.45312500f,0.35937500f,0.15625000f,-0.20312500f,-0.07812500f,-0.96875000f,0.71875000f,0.90625000f,-0.35937500f,-0.32812500f,0.79687500f,-0.57812500f,0.01562500f,-0.92187500f,0.46875000f,-0.15625000f,-0.53125000f,-0.56250000f,-0.42187500f,-0.26562500f,0.51562500f,-0.65625000f,0.60937500f,0.35937500f,-0.28125000f,-0.76562500f,0.12500000f,0.73437500f,0.25000000f,0.71875000f,-0.57812500f,-0.54687500f,-0.01562500f,0.89062500f,-0.85937500f,0.20312500f,-0.64062500f,-0.95312500f,0.35937500f,-0.82812500f,-0.75000000f,0.92187500f,-0.65625000f,-0.09375000f,-0.37500000f,0.78125000f,-0.81250000f,0.60937500f,0.76562500f,-0.48437500f,-0.32812500f,-0.75000000f,0.59375000f,-0.21875000f,0.98437500f,-0.45312500f,-0.35937500f,-0.48437500f,0.14062500f,-0.12500000f,-0.12500000f,0.48437500f,0.14062500f,0.21875000f,0.42187500f,1.00000000f,-0.95312500f,-0.28125000f,-0.54687500f,-1.00000000f,0.92187500f,0.35937500f,0.76562500f,0.79687500f,-0.71875000f,-0.46875000f,-0.32812500f,-0.17187500f,-0.46875000f,0.64062500f,-0.92187500f,-0.70312500f,-0.48437500f,-0.96875000f,0.76562500f,0.73437500f,0.28125000f,0.31250000f,-0.57812500f,-0.45312500f,-0.46875000f,-0.14062500f,-0.10937500f,0.48437500f,-0.39062500f,-0.21875000f,-0.04687500f,0.53125000f,-0.51562500f,-0.37500000f,-0.18750000f,0.53125000f,0.92187500f,-0.84375000f,-0.45312500f,0.34375000f,0.48437500f,-0.71875000f,0.46875000f,-0.04687500f,-0.96875000f,-0.56250000f,0.48437500f,-0.79687500f,-0.57812500f,0.64062500f,-0.50000000f,-0.64062500f,-0.64062500f,-0.92187500f,-0.82812500f,0.10937500f,-0.98437500f,0.90625000f,0.28125000f,-0.81250000f,-0.35937500f,0.50000000f,-0.73437500f,-0.62500000f,-0.76562500f,-0.71875000f,-0.17187500f,-0.21875000f,-0.51562500f,-0.73437500f,0.64062500f,0.90625000f,0.79687500f,0.96875000f,0.71875000f,0.23437500f,0.03125000f,0.98437500f,0.25000000f,0.62500000f,0.54687500f,0.20312500f,-0.87500000f,-0.25000000f,-0.82812500f,0.68750000f,-0.29687500f,0.12500000f,0.14062500f,0.14062500f,0.65625000f,-0.35937500f,0.84375000f,-0.78125000f,-0.64062500f,0.70312500f,-0.87500000f,-0.31250000f,-0.43750000f,0.15625000f,-0.07812500f,-0.96875000f,0.39062500f,-0.95312500f,0.17187500f,0.14062500f,0.32812500f,-0.81250000f,-0.25000000f,0.71875000f,0.82812500f,0.50000000f,-0.17187500f,0.17187500f,-0.15625000f,0.57812500f,0.18750000f,0.84375000f,0.48437500f,0.75000000f,0.85937500f,-0.20312500f,-0.71875000f,-0.37500000f,0.29687500f,0.90625000f,0.06250000f,-0.59375000f,-0.15625000f,0.70312500f,-0.23437500f,0.73437500f,0.03125000f,-0.37500000f,0.89062500f,0.20312500f,-0.89062500f,0.18750000f,0.82812500f,0.46875000f,0.85937500f,0.81250000f,-0.23437500f,0.76562500f,0.48437500f,0.87500000f,0.12500000f,-0.39062500f,0.29687500f,-0.14062500f,-0.07812500f,0.53125000f,0.17187500f,0.45312500f,0.82812500f,-0.45312500f,-0.68750000f,0.87500000f,-0.43750000f,0.15625000f,0.43750000f,0.65625000f,-0.26562500f,0.18750000f,0.79687500f,0.45312500f,-0.57812500f,0.62500000f,0.76562500f,0.45312500f,0.96875000f,0.65625000f,-0.82812500f,-0.28125000f,-0.31250000f,0.93750000f,0.17187500f,0.92187500f,0.07812500f,0.12500000f,0.56250000f,-0.39062500f,-0.40625000f,-0.32812500f,0.40625000f,-0.71875000f,-0.23437500f,0.17187500f,0.40625000f,0.59375000f,0.59375000f,-0.75000000f,-0.10937500f,-0.21875000f,-0.46875000f,-0.17187500f,0.56250000f,-0.32812500f,-0.01562500f,0.31250000f,-0.40625000f,0.01562500f,0.23437500f,0.51562500f,0.25000000f,0.09375000f,0.12500000f,0.79687500f,-0.65625000f,-0.40625000f,0.57812500f,-0.23437500f,0.34375000f,0.96875000f,-0.34375000f,-0.85937500f,-0.28125000f,-0.76562500f,-0.04687500f,0.84375000f,0.82812500f,-0.59375000f,-0.20312500f,-0.48437500f,0.32812500f,-0.54687500f,-0.46875000f,0.29687500f,0.64062500f,0.39062500f,0.14062500f,0.17187500f,-0.87500000f,0.43750000f,-0.82812500f,-0.43750000f,0.84375000f,0.01562500f,0.54687500f,-0.92187500f,-0.01562500f,-0.35937500f,-0.93750000f,-0.98437500f,0.60937500f,-0.43750000f,-0.87500000f,0.85937500f,-0.60937500f,0.40625000f,-0.10937500f,0.23437500f,0.32812500f,-0.92187500f,-0.57812500f,-0.45312500f,-0.73437500f,0.18750000f,-0.96875000f,-0.56250000f,0.12500000f,0.06250000f,-0.03125000f,-0.32812500f,0.32812500f,-0.67187500f,0.29687500f,-0.67187500f,0.42187500f,0.09375000f,-0.15625000f,-0.95312500f,0.79687500f,-0.32812500f,0.46875000f,-0.90625000f,0.32812500f,-0.92187500f,-0.21875000f,0.65625000f,-0.68750000f,-0.75000000f,-0.67187500f,-0.04687500f,-0.04687500f,0.43750000f,0.90625000f,0.23437500f,0.59375000f,0.62500000f,0.68750000f,-0.48437500f,0.95312500f,-0.51562500f,0.00000000f,0.31250000f,0.65625000f,-0.84375000f,-0.14062500f,-0.90625000f,0.29687500f,0.96875000f,-0.53125000f,0.06250000f,-0.28125000f,-0.26562500f,-0.96875000f,0.25000000f,0.96875000f,-0.23437500f,0.70312500f,0.96875000f,0.01562500f,0.59375000f,0.95312500f,-0.03125000f,-0.34375000f,0.96875000f,-0.56250000f,-0.57812500f,0.06250000f,0.65625000f,0.40625000f,-0.48437500f,-0.40625000f,-0.59375000f,-0.34375000f,-0.73437500f,-0.46875000f,-0.54687500f,0.29687500f,-0.31250000f,-0.23437500f,-0.62500000f,-0.54687500f,-0.60937500f,0.03125000f,0.40625000f,0.92187500f,-0.15625000f,0.43750000f,-0.59375000f,0.01562500f,-0.32812500f,0.93750000f,-0.96875000f,-0.79687500f,-0.76562500f,-0.85937500f,-1.00000000f,0.04687500f,0.29687500f,0.09375000f,0.79687500f,-0.93750000f,0.62500000f,0.06250000f,0.25000000f,-0.60937500f,0.50000000f,-0.31250000f,0.31250000f,-0.07812500f,0.93750000f,0.48437500f,-0.37500000f,-0.67187500f,0.06250000f,0.06250000f,0.67187500f,0.70312500f,0.20312500f,0.68750000f,-0.21875000f,0.03125000f,0.68750000f,-0.79687500f,-0.03125000f,0.21875000f,0.25000000f,0.20312500f,-0.92187500f,0.71875000f,0.37500000f,-0.96875000f,0.10937500f,0.39062500f,-0.67187500f,0.01562500f,-0.43750000f,0.93750000f,0.87500000f,0.56250000f,-0.60937500f,0.68750000f,0.12500000f,-0.12500000f,-0.51562500f,-0.56250000f,-0.18750000f,-0.04687500f,-0.29687500f,0.45312500f,-0.09375000f,-0.64062500f,0.93750000f,-0.59375000f,-0.37500000f,0.62500000f,0.09375000f,-0.60937500f,-0.76562500f,-0.71875000f,0.01562500f,0.59375000f,-0.54687500f,0.82812500f,0.15625000f,0.84375000f,-0.37500000f,-0.54687500f,-0.39062500f,-0.54687500f,-0.42187500f,0.14062500f,-0.79687500f,0.85937500f,-0.68750000f,-0.51562500f,-0.64062500f,-0.70312500f,-0.56250000f,-0.75000000f,0.85937500f,-0.81250000f,-0.84375000f,0.12500000f,0.23437500f,0.79687500f,-0.21875000f,-0.93750000f,0.46875000f,0.75000000f,0.43750000f,-0.53125000f,0.15625000f,0.37500000f,0.50000000f,0.51562500f,0.76562500f,-0.14062500f,0.45312500f,-0.87500000f,-0.71875000f,-0.40625000f,-0.92187500f,0.50000000f,-0.68750000f,-0.71875000f,-0.43750000f,0.79687500f,-0.01562500f,-0.95312500f,-0.31250000f,-0.51562500f,-0.28125000f,0.56250000f,-0.51562500f,0.59375000f,0.65625000f,0.21875000f,-0.56250000f,0.28125000f,0.01562500f,-0.56250000f,-0.59375000f,0.12500000f,-0.75000000f,0.03125000f,-0.53125000f,-0.50000000f,0.00000000f,0.04687500f,0.01562500f,-0.43750000f,-0.48437500f,-0.79687500f,0.50000000f,0.65625000f,-0.04687500f,-0.96875000f,-0.56250000f,-0.29687500f,0.18750000f,-0.01562500f,0.15625000f,0.10937500f,-0.62500000f,-0.18750000f,-0.93750000f,0.28125000f,0.32812500f,-0.12500000f,0.76562500f,0.31250000f,-0.59375000f,0.51562500f,-0.09375000f,-0.65625000f,0.95312500f,-0.78125000f,0.31250000f,-0.40625000f,-0.53125000f,0.56250000f,0.31250000f,0.14062500f,-0.65625000f,-0.65625000f,0.10937500f,0.42187500f,-0.25000000f,-0.01562500f,0.75000000f,0.92187500f,0.04687500f,0.17187500f,-0.59375000f,-0.56250000f,-0.10937500f,-0.40625000f,-0.84375000f,-0.87500000f,-0.50000000f,0.71875000f,-0.60937500f,0.20312500f,0.78125000f,-0.12500000f,0.62500000f,-0.12500000f,-0.50000000f,0.54687500f,-0.87500000f,-0.67187500f,-0.35937500f,-0.15625000f,0.64062500f,0.71875000f,0.42187500f,-0.12500000f,0.96875000f,0.87500000f,-0.57812500f,-0.10937500f,-0.23437500f,-0.85937500f,-0.73437500f,-0.40625000f,-0.90625000f,0.92187500f,-0.48437500f,0.06250000f,-0.21875000f,-0.42187500f,-0.39062500f,-0.59375000f,0.89062500f,-0.92187500f,0.04687500f,-0.40625000f,-0.15625000f,0.23437500f,-0.84375000f,-0.76562500f,-0.18750000f,0.98437500f,0.06250000f,0.85937500f,-0.07812500f,-0.95312500f,0.04687500f,0.43750000f,-0.93750000f,0.37500000f,-0.78125000f,0.46875000f,0.09375000f,0.64062500f,0.07812500f,-0.54687500f,-0.59375000f,-0.95312500f,-0.35937500f,0.70312500f,-0.45312500f,-0.39062500f,-0.60937500f,-0.67187500f,-0.14062500f,-0.82812500f,0.78125000f,0.23437500f,0.89062500f,-0.06250000f,-0.03125000f,0.45312500f,-0.54687500f,-0.37500000f,0.87500000f,0.09375000f,-0.79687500f,0.68750000f,-0.31250000f,0.70312500f,0.39062500f,-0.68750000f,-0.42187500f,0.32812500f,0.56250000f,0.76562500f,1.00000000f,0.54687500f,-0.70312500f,-0.06250000f,-0.10937500f,-0.56250000f,-0.68750000f,0.43750000f,0.87500000f,-0.39062500f,-0.59375000f,0.29687500f,-0.46875000f,-0.60937500f,-0.23437500f,0.68750000f,-0.60937500f,-0.32812500f,0.42187500f,0.56250000f,0.31250000f,0.31250000f,0.06250000f,-0.21875000f,-0.04687500f,-0.39062500f,-0.85937500f,0.96875000f,0.21875000f,0.51562500f,-0.79687500f,0.35937500f,-0.93750000f,0.39062500f,0.25000000f,0.01562500f,-0.89062500f,-0.26562500f,-0.79687500f,-0.46875000f,-0.79687500f,-0.25000000f,0.43750000f,0.56250000f,0.20312500f,1.00000000f,-0.56250000f,0.62500000f,0.12500000f,-0.29687500f,0.17187500f,-0.20312500f,-0.20312500f,-0.85937500f,-0.89062500f,0.57812500f,-0.68750000f,-0.87500000f,-0.71875000f,0.71875000f,-0.06250000f,-0.29687500f,-0.35937500f,-0.01562500f,-0.67187500f,0.00000000f,-0.29687500f,-0.82812500f,-0.56250000f,-0.04687500f,-0.81250000f,-0.23437500f,0.12500000f,-0.20312500f,-0.42187500f,0.89062500f,0.34375000f,0.00000000f,0.06250000f,-0.64062500f,-0.18750000f,0.18750000f,0.87500000f,-0.96875000f,-0.40625000f,-0.46875000f,-0.57812500f,-0.65625000f,-0.75000000f,-1.00000000f,0.64062500f,-0.57812500f,-0.56250000f,0.89062500f,0.67187500f,-0.29687500f,0.68750000f,-0.45312500f,0.68750000f,0.07812500f,-0.40625000f,0.39062500f,0.09375000f,-0.68750000f,-0.57812500f,-0.46875000f,-0.51562500f,0.60937500f,-0.32812500f,0.12500000f,0.26562500f,0.93750000f,-0.84375000f,0.12500000f,0.17187500f,-0.78125000f,-0.90625000f,-0.98437500f,-0.51562500f,-0.84375000f,-0.29687500f,-0.78125000f,-0.32812500f,-0.18750000f,0.23437500f,0.53125000f,-0.48437500f,0.67187500f,0.68750000f,0.62500000f,0.67187500f,-0.09375000f,-0.96875000f,-0.15625000f,-0.48437500f,-0.84375000f,-0.62500000f,-0.46875000f,-0.14062500f,0.81250000f,-0.64062500f,-0.46875000f,-0.20312500f,0.51562500f,-0.60937500f,0.95312500f,0.81250000f,-0.31250000f,-0.68750000f,0.40625000f,-0.90625000f,-0.10937500f,0.76562500f,-0.03125000f,-0.26562500f,-0.53125000f,-0.56250000f,-1.00000000f,-0.25000000f,-0.85937500f,0.09375000f,0.73437500f,-0.96875000f,0.01562500f,-0.57812500f,-0.95312500f,-0.01562500f,-0.84375000f,-0.45312500f,0.06250000f,-0.50000000f,-0.62500000f,0.71875000f,0.78125000f,0.79687500f,-0.46875000f,-0.84375000f,-0.50000000f,0.84375000f,0.73437500f,-0.93750000f,-0.10937500f,0.20312500f,-0.15625000f,-0.64062500f,-0.03125000f,0.75000000f,-0.65625000f,-0.54687500f,0.09375000f,-0.57812500f,0.29687500f,0.34375000f,-0.20312500f,-0.92187500f,-0.78125000f,-0.60937500f,-0.96875000f,-0.89062500f,0.57812500f,0.32812500f,-0.17187500f,0.59375000f,-0.40625000f,-0.25000000f,-0.39062500f,0.93750000f,0.00000000f,-0.98437500f,-0.39062500f,0.98437500f,0.96875000f,0.62500000f,-0.29687500f,0.43750000f,0.89062500f,0.84375000f,0.39062500f,-0.57812500f,-0.07812500f,0.68750000f,-0.29687500f,-0.54687500f,-1.00000000f,0.12500000f,-0.45312500f,-0.85937500f,-0.29687500f,-0.68750000f,0.39062500f,-0.28125000f,-0.70312500f,0.00000000f,-0.68750000f,-0.39062500f,0.00000000f,0.48437500f,0.28125000f,-0.89062500f,0.29687500f,0.45312500f,0.96875000f,0.65625000f,-0.89062500f,-0.26562500f,-0.25000000f,0.25000000f,-0.46875000f,0.95312500f,-0.17187500f,0.29687500f,-0.64062500f,0.50000000f,0.29687500f,-0.70312500f,0.53125000f,-0.04687500f,0.60937500f,0.10937500f,0.42187500f,0.45312500f,-0.34375000f,-0.48437500f,-0.67187500f,-0.25000000f,0.40625000f,0.56250000f,-0.82812500f,0.87500000f,-0.35937500f,0.75000000f,-0.43750000f,-0.29687500f,-0.43750000f,0.26562500f,-0.45312500f,-0.59375000f,0.00000000f,-0.06250000f,-0.70312500f,-0.59375000f,0.35937500f,-0.25000000f,-0.64062500f,0.32812500f,-0.12500000f,0.15625000f,0.53125000f,-0.75000000f,-0.50000000f,0.42187500f,-0.75000000f,0.43750000f,0.87500000f,0.57812500f,-0.10937500f,-0.81250000f,0.20312500f,-0.67187500f,-0.43750000f,-0.14062500f,0.21875000f,-0.81250000f,0.50000000f,0.59375000f,-0.32812500f,-0.60937500f,0.57812500f,0.46875000f,0.28125000f,-0.31250000f,1.00000000f,-0.31250000f,0.32812500f,0.98437500f,0.82812500f,-0.73437500f,0.07812500f,-1.00000000f,-1.00000000f,0.15625000f,0.45312500f,0.09375000f,0.60937500f,0.28125000f,-0.92187500f,-0.60937500f,0.42187500f,-0.85937500f,0.09375000f,-0.42187500f,-0.90625000f,0.96875000f,-0.50000000f,-0.39062500f,-0.12500000f,0.10937500f,-0.76562500f,0.71875000f,0.62500000f,0.71875000f,0.29687500f,0.14062500f,0.39062500f,0.89062500f,-0.01562500f,0.42187500f,0.39062500f,-0.48437500f,-0.46875000f,-0.34375000f,0.59375000f,-0.79687500f,0.06250000f,0.57812500f,0.26562500f,-1.00000000f,0.59375000f,-0.25000000f,-0.42187500f,-0.71875000f,-0.60937500f,0.09375000f,-0.65625000f,-0.20312500f,0.76562500f,-0.56250000f,0.15625000f,0.29687500f,0.60937500f,-0.78125000f,-0.73437500f,-0.26562500f,-0.43750000f,-0.60937500f,-0.20312500f,-0.82812500f,-0.51562500f,-0.92187500f,-0.46875000f,-0.62500000f,0.21875000f,0.04687500f,-0.62500000f,-0.85937500f,-0.98437500f,-0.18750000f,0.40625000f,-0.04687500f,0.48437500f,0.92187500f,0.53125000f,-0.59375000f,-0.42187500f,-0.95312500f,-0.75000000f,-0.04687500f,0.98437500f,0.92187500f,-0.39062500f,0.82812500f,0.20312500f,0.45312500f,-0.68750000f,0.54687500f,0.39062500f,0.84375000f,-0.90625000f,-0.35937500f,-0.07812500f,0.73437500f,-0.53125000f,-0.06250000f,-0.18750000f,-0.04687500f,-0.84375000f,0.65625000f,0.70312500f,-0.93750000f,0.76562500f,0.68750000f,0.39062500f,0.10937500f,-0.70312500f,-0.34375000f,-0.21875000f,0.32812500f,0.43750000f,-0.48437500f,0.37500000f,-0.20312500f,-0.85937500f,-0.90625000f,0.25000000f,-0.76562500f,-0.59375000f,-0.21875000f,0.82812500f,0.53125000f,-0.35937500f,0.01562500f,-0.43750000f,0.81250000f,0.25000000f,-0.32812500f,-0.21875000f,-0.42187500f,-0.23437500f,-0.34375000f,0.25000000f,-0.81250000f,-0.31250000f,0.71875000f,0.64062500f,-0.71875000f,0.76562500f,0.26562500f,0.01562500f,0.46875000f,0.82812500f,0.81250000f,-0.96875000f,0.96875000f,0.85937500f,0.82812500f,0.85937500f,-0.89062500f,0.18750000f,-0.87500000f,-0.78125000f,-0.59375000f,-0.84375000f,-0.57812500f,-0.21875000f,-0.10937500f,0.93750000f,0.20312500f,0.32812500f,0.04687500f,-0.18750000f,0.60937500f,0.31250000f,0.23437500f,0.03125000f,0.68750000f,-0.32812500f,-0.89062500f,-0.23437500f,-0.67187500f,0.15625000f,0.73437500f,-0.48437500f,0.56250000f,0.31250000f,0.39062500f,-0.65625000f,-0.67187500f,-0.90625000f,-0.43750000f,0.98437500f,-0.25000000f,-0.50000000f,-0.78125000f,0.06250000f,0.32812500f,-0.45312500f,-0.12500000f,0.17187500f,0.92187500f,-0.31250000f,0.01562500f,-0.70312500f,0.76562500f,0.53125000f,0.06250000f,0.95312500f,-0.46875000f,-0.39062500f,1.00000000f,0.59375000f,-0.20312500f,0.93750000f,-0.92187500f,-0.68750000f,-0.28125000f,0.18750000f,0.71875000f,0.18750000f,0.25000000f,-0.48437500f,0.01562500f,0.35937500f,0.48437500f,-0.54687500f,0.29687500f,0.73437500f,-0.51562500f,0.57812500f,-0.26562500f,0.46875000f,0.62500000f,0.62500000f,0.81250000f,0.17187500f,0.28125000f,-0.75000000f,-0.45312500f,-0.29687500f,0.37500000f,-0.71875000f,0.71875000f,0.93750000f,-0.42187500f,0.31250000f,-0.26562500f,0.81250000f,-0.15625000f,-0.62500000f,0.53125000f,0.12500000f,0.60937500f,0.60937500f,-0.04687500f,-0.90625000f,0.40625000f,0.12500000f,0.89062500f,0.09375000f,-0.14062500f,0.29687500f,-0.03125000f,-0.62500000f,0.17187500f,-0.67187500f,0.79687500f,0.53125000f,0.54687500f,-0.54687500f,0.71875000f,-0.03125000f,-0.14062500f,-0.56250000f,0.15625000f,0.90625000f,0.65625000f,0.00000000f,-0.35937500f,0.43750000f,-0.40625000f,0.57812500f,-0.25000000f,0.03125000f,0.04687500f,-0.42187500f,0.76562500f,0.85937500f,0.81250000f,-0.87500000f,-0.85937500f,0.14062500f,0.26562500f,0.03125000f,0.28125000f,0.17187500f,-0.50000000f,0.53125000f,-0.32812500f,-0.15625000f,0.18750000f,-0.92187500f,0.59375000f,0.34375000f,0.85937500f,-0.73437500f,0.28125000f,0.37500000f,0.62500000f,-0.92187500f,-0.09375000f,-0.31250000f,-0.51562500f,-0.68750000f,0.45312500f,0.01562500f,0.10937500f,0.42187500f,-0.15625000f,-0.28125000f,0.75000000f,-0.20312500f,0.45312500f,-0.85937500f,-0.85937500f,-0.23437500f,-0.54687500f,-0.51562500f,-0.71875000f,0.82812500f,0.93750000f,-0.62500000f,0.48437500f,-0.18750000f,0.60937500f,-0.39062500f,-0.21875000f,-0.79687500f,0.14062500f,0.93750000f,-0.32812500f,0.29687500f,0.15625000f,0.26562500f,-0.43750000f,-0.21875000f,0.28125000f,-0.17187500f,0.07812500f,0.31250000f,-0.68750000f,-0.03125000f,-0.14062500f,0.29687500f,0.01562500f,-0.90625000f,0.26562500f,0.26562500f,0.95312500f,0.81250000f,-0.03125000f,0.73437500f,0.06250000f,0.64062500f,-0.56250000f,-0.87500000f,0.65625000f,-0.85937500f,0.67187500f,-0.34375000f,-0.23437500f,-0.01562500f,-0.14062500f,0.78125000f,0.00000000f,-0.62500000f,0.62500000f,0.45312500f,-0.37500000f,0.32812500f,0.53125000f,0.85937500f,0.59375000f,0.98437500f,0.10937500f,0.32812500f,0.73437500f,-0.01562500f,-0.34375000f,-0.45312500f,-0.34375000f,-0.68750000f,-0.09375000f,-0.45312500f,0.23437500f,-0.14062500f,-0.21875000f,-0.70312500f,-0.26562500f,-0.35937500f,-0.14062500f,0.75000000f,-0.45312500f,-0.68750000f,-0.56250000f,0.03125000f,-0.71875000f,-0.09375000f,0.42187500f,0.68750000f,0.56250000f,0.34375000f,-0.32812500f,-0.29687500f,0.73437500f,0.18750000f,-0.23437500f,-0.25000000f,0.57812500f,-0.70312500f,0.90625000f,-0.78125000f,-0.57812500f,-0.75000000f,-0.70312500f,0.50000000f,-0.40625000f,-0.87500000f,0.28125000f,0.68750000f,-0.03125000f,-0.15625000f,-0.68750000f,-0.62500000f,-0.84375000f,-0.03125000f,0.98437500f,0.64062500f,-0.07812500f,-0.53125000f,0.92187500f,-0.78125000f,-0.23437500f,0.84375000f,-0.37500000f,-0.31250000f,-0.28125000f,-0.10937500f,0.76562500f,0.34375000f,0.92187500f,0.82812500f,-0.35937500f,-0.84375000f,-0.04687500f,-0.53125000f,-0.87500000f,0.81250000f,-0.53125000f,-0.39062500f,0.64062500f,0.04687500f,0.65625000f,0.31250000f,-0.46875000f,0.35937500f,0.15625000f,0.42187500f,-0.51562500f,0.64062500f,0.59375000f,-0.10937500f,-0.56250000f,-0.82812500f,-0.17187500f,-0.89062500f,-0.79687500f,-0.70312500f,-0.96875000f,-0.85937500f,0.57812500f,-0.29687500f,-0.34375000f,-0.14062500f,0.28125000f,0.04687500f,-0.81250000f,-0.17187500f,0.68750000f,0.56250000f,0.37500000f,0.50000000f,0.57812500f,0.62500000f,-0.46875000f,-0.76562500f,0.42187500f,0.76562500f,-0.45312500f,0.28125000f,-0.95312500f,-0.21875000f,-0.98437500f,-0.31250000f,-0.68750000f,0.62500000f,-0.23437500f,0.92187500f,0.65625000f,0.10937500f,-0.12500000f,0.93750000f,-0.53125000f,-0.87500000f,0.53125000f,-0.50000000f,-0.75000000f,0.54687500f,-0.17187500f,-0.81250000f,-0.39062500f,-0.17187500f,-0.31250000f,-0.39062500f,0.70312500f,0.25000000f,0.78125000f,0.85937500f,-0.87500000f,-0.98437500f,-0.10937500f,0.32812500f,0.21875000f,-0.46875000f,-0.28125000f,-0.28125000f,0.32812500f,-0.10937500f,-0.21875000f,-0.71875000f,0.79687500f,0.14062500f,0.68750000f,0.78125000f,0.56250000f,0.40625000f,0.32812500f,-0.51562500f,0.40625000f,0.12500000f,0.54687500f,0.42187500f,-0.82812500f,0.68750000f,0.07812500f,-0.73437500f,0.87500000f,0.68750000f,-0.96875000f,0.40625000f,0.95312500f,0.62500000f,0.20312500f,0.73437500f,0.79687500f,0.32812500f,-0.85937500f,0.10937500f,-0.95312500f,-0.73437500f,0.51562500f,0.46875000f,0.51562500f,-0.95312500f,0.34375000f,-0.46875000f,-0.40625000f,0.15625000f,-0.93750000f,0.42187500f,0.59375000f,0.12500000f,0.57812500f,-0.06250000f,0.62500000f,-0.43750000f,0.79687500f,-0.81250000f,-0.40625000f,-0.71875000f,-0.56250000f,-0.70312500f,-0.15625000f,-0.85937500f,0.93750000f,0.53125000f,-0.21875000f,-0.07812500f,-0.75000000f,0.43750000f,-0.96875000f,0.14062500f,-0.64062500f,-0.15625000f,-0.34375000f,-0.29687500f,0.40625000f,-0.03125000f,0.03125000f,-0.50000000f,0.75000000f,-0.48437500f,0.14062500f,0.45312500f,-0.40625000f,0.39062500f,0.65625000f,-0.23437500f,-0.98437500f,0.12500000f,0.62500000f,0.29687500f,-0.50000000f,0.10937500f,-0.75000000f,0.75000000f,-0.26562500f,-0.20312500f,-0.42187500f,0.07812500f,0.67187500f,0.37500000f,-0.14062500f,0.04687500f,0.54687500f,0.09375000f,-0.68750000f,0.60937500f,0.60937500f,-0.60937500f,0.67187500f,-0.31250000f,0.37500000f,0.93750000f,-0.32812500f,-0.51562500f,-0.96875000f,0.96875000f,1.00000000f,0.10937500f,0.95312500f,-0.42187500f,0.65625000f,0.25000000f,-0.18750000f,-0.42187500f,0.64062500f,-0.10937500f,-0.45312500f,-0.96875000f,0.32812500f,0.00000000f,0.35937500f,0.48437500f,-0.20312500f,-0.40625000f,0.12500000f,-0.06250000f,0.62500000f,0.45312500f,0.06250000f,-0.29687500f,0.50000000f,-0.06250000f,-0.39062500f,-0.40625000f,-1.00000000f,0.67187500f,0.45312500f,-0.68750000f,0.26562500f,0.48437500f,0.18750000f,-0.96875000f,0.67187500f,-0.98437500f,0.98437500f,0.17187500f,0.76562500f,-0.26562500f,-0.60937500f,0.40625000f,0.48437500f,0.46875000f,0.48437500f,0.68750000f,0.89062500f,0.39062500f,0.18750000f,0.06250000f,-0.95312500f,0.46875000f,0.23437500f,-0.73437500f,-0.98437500f,0.06250000f,-0.68750000f,-0.20312500f,0.65625000f,0.96875000f,0.25000000f,0.42187500f,-0.01562500f,0.43750000f,0.89062500f,0.00000000f,0.87500000f,0.57812500f,0.42187500f,0.56250000f,-0.20312500f,0.42187500f,0.76562500f,-0.67187500f,0.89062500f,-0.12500000f,-0.04687500f,0.40625000f,-0.70312500f,0.26562500f,-0.09375000f,0.87500000f,-1.00000000f,-0.78125000f,0.48437500f,-0.84375000f,-0.79687500f,0.90625000f,-0.89062500f,-0.46875000f,0.07812500f,0.23437500f,-0.18750000f,-0.51562500f,-0.39062500f,0.29687500f,0.35937500f,0.82812500f,-0.37500000f,0.40625000f,-0.60937500f,0.06250000f,-0.67187500f,0.68750000f,0.12500000f,-0.56250000f,0.50000000f,-0.43750000f,0.10937500f,0.42187500f,-0.84375000f,0.56250000f,-0.28125000f,-0.50000000f,0.50000000f,-0.96875000f,0.98437500f,-0.07812500f,0.62500000f,0.17187500f,0.71875000f,-0.26562500f,-0.07812500f,-0.42187500f,0.87500000f,-0.56250000f,-0.67187500f,0.78125000f,-0.78125000f,0.82812500f,0.14062500f,-0.92187500f,0.01562500f,0.95312500f,-0.54687500f,-0.46875000f,-0.17187500f,0.85937500f,0.00000000f,0.18750000f,-0.48437500f,0.98437500f,-0.51562500f,-0.68750000f,0.81250000f,-0.82812500f,-0.12500000f,0.04687500f,-0.45312500f,-0.48437500f,-0.32812500f,-0.56250000f,-0.20312500f,0.67187500f,-0.17187500f,-0.51562500f,-0.48437500f,0.07812500f,-0.56250000f,-0.67187500f,0.18750000f,1.00000000f,-0.21875000f,-0.12500000f,-0.07812500f,0.51562500f,-0.10937500f,-0.18750000f,-0.82812500f,0.70312500f,1.00000000f,0.25000000f,-0.39062500f,-0.20312500f,0.21875000f,0.39062500f,-0.40625000f,-0.73437500f,0.46875000f,-0.95312500f,-0.31250000f,-0.64062500f,-0.48437500f,0.23437500f,-0.23437500f,-0.21875000f,0.90625000f,-0.87500000f,-0.06250000f,0.79687500f,0.35937500f,0.67187500f,0.12500000f,-0.71875000f,0.75000000f,-0.78125000f,0.37500000f,0.73437500f,-0.79687500f,0.84375000f,-0.79687500f,0.29687500f,-0.42187500f,0.60937500f,0.23437500f,0.67187500f,0.01562500f,-0.68750000f,-0.09375000f,-0.96875000f,0.01562500f,-0.60937500f,0.35937500f,-0.46875000f,-0.34375000f,0.95312500f,-1.00000000f,0.54687500f,0.84375000f,-0.50000000f,-0.57812500f,-0.15625000f,0.53125000f,-0.40625000f,-0.31250000f,0.26562500f,-0.26562500f,-0.85937500f,-0.06250000f,-0.93750000f,-0.96875000f,0.31250000f,-0.59375000f,0.87500000f,0.98437500f,0.82812500f,-0.23437500f,-0.10937500f,0.45312500f,0.73437500f,-0.90625000f,0.64062500f,-0.81250000f,0.79687500f,-0.79687500f,0.71875000f,-0.78125000f,-0.76562500f,0.48437500f,0.18750000f,0.09375000f,-0.06250000f,-0.65625000f,-0.67187500f,0.21875000f,-1.00000000f,-0.89062500f,0.01562500f,-0.75000000f,-0.18750000f,0.57812500f,-0.45312500f,0.17187500f,0.81250000f,0.65625000f,-0.26562500f,-0.90625000f,-0.78125000f,0.82812500f,-0.78125000f,0.07812500f,0.39062500f,0.75000000f,-0.76562500f,0.71875000f,-0.98437500f,-0.51562500f,0.78125000f,-0.46875000f,0.90625000f,-0.57812500f,0.09375000f,-0.81250000f,-0.10937500f,-0.96875000f,-0.68750000f,-0.87500000f,-0.15625000f,-0.17187500f,-0.35937500f,-0.23437500f,-0.98437500f,1.00000000f,0.96875000f,-0.50000000f,0.95312500f,-0.14062500f,-0.93750000f,0.73437500f,-0.59375000f,-0.45312500f,0.18750000f,-0.93750000f,-0.64062500f,-0.89062500f,-0.23437500f,0.76562500f,-0.54687500f,-0.42187500f,0.78125000f,-0.60937500f,0.65625000f,-0.51562500f,-0.95312500f,0.46875000f,0.14062500f,-0.31250000f,-0.96875000f,-0.92187500f,-0.65625000f,0.10937500f,-0.84375000f,-0.70312500f,0.76562500f,0.18750000f,0.84375000f,-1.00000000f,0.90625000f,0.15625000f,-0.93750000f,-0.98437500f,0.59375000f,0.56250000f,-0.93750000f,-0.62500000f,0.07812500f,0.48437500f,-0.56250000f,-0.34375000f,-0.84375000f,-0.56250000f,-0.42187500f,0.75000000f,-0.54687500f,-0.18750000f,0.92187500f,-0.85937500f,0.45312500f,0.78125000f,-0.92187500f,-0.89062500f,-0.95312500f,-0.35937500f,-0.35937500f,0.84375000f,0.60937500f,-0.64062500f,-0.56250000f,0.15625000f,0.54687500f,0.00000000f,0.90625000f,0.43750000f,0.92187500f,0.81250000f,-0.79687500f,0.79687500f,0.60937500f,-0.76562500f,0.53125000f,0.67187500f,0.93750000f,-0.46875000f,0.00000000f,0.57812500f,-0.32812500f,-0.82812500f,0.42187500f,-0.21875000f,-0.09375000f,0.92187500f,-0.98437500f,-0.95312500f,0.06250000f,0.59375000f,0.89062500f,0.32812500f,0.59375000f,0.45312500f,-0.57812500f,-0.09375000f,0.43750000f,-0.32812500f,0.37500000f,-0.06250000f,0.87500000f,0.68750000f,0.59375000f,0.79687500f,0.85937500f,0.35937500f,0.68750000f,0.89062500f,0.57812500f,-0.12500000f,0.20312500f,0.48437500f,-0.84375000f,-0.95312500f,0.68750000f,0.65625000f,-0.87500000f,0.82812500f,0.23437500f,0.15625000f,0.32812500f,0.64062500f,-0.26562500f,-0.39062500f,0.45312500f,-0.85937500f,-0.70312500f,-0.31250000f,-0.64062500f,0.34375000f,0.23437500f,-0.71875000f,0.51562500f,0.37500000f,-0.39062500f,0.04687500f,0.25000000f,0.98437500f,-0.56250000f,0.67187500f,0.04687500f,-0.76562500f,-0.45312500f,0.15625000f,0.75000000f,-0.23437500f,-0.98437500f,0.54687500f,-0.79687500f,-0.64062500f,-0.50000000f,-0.84375000f,0.78125000f,-0.31250000f,0.79687500f,0.31250000f,0.34375000f,0.64062500f,0.59375000f,0.07812500f,0.68750000f,0.06250000f,-0.09375000f,0.01562500f,-0.35937500f,-0.37500000f,-0.46875000f,0.18750000f,0.53125000f,-0.35937500f,-0.98437500f,0.51562500f,-0.28125000f,0.95312500f,0.28125000f,0.46875000f,0.00000000f,-0.34375000f,-0.64062500f,0.18750000f,0.48437500f,-0.32812500f,-0.23437500f,-0.31250000f,-0.28125000f,-0.70312500f,0.25000000f,0.56250000f,-0.17187500f,-0.06250000f,0.39062500f,-0.84375000f,-0.85937500f,0.57812500f,-0.31250000f,0.48437500f,1.00000000f,0.57812500f,-1.00000000f,0.60937500f,0.84375000f,-0.62500000f,0.64062500f,0.07812500f,-0.98437500f,-0.12500000f,-0.85937500f,-0.53125000f,-0.62500000f,-0.79687500f,0.60937500f,0.31250000f,0.25000000f,0.20312500f,0.26562500f,-0.89062500f,0.15625000f,0.68750000f,0.68750000f,0.42187500f,-0.79687500f,0.34375000f,0.67187500f,-0.42187500f,0.84375000f,-0.42187500f,0.70312500f,0.10937500f,0.92187500f,0.29687500f,0.87500000f,-0.79687500f,0.29687500f,-0.09375000f,-0.14062500f,-0.35937500f,0.92187500f,0.03125000f,-0.12500000f,0.92187500f,-0.92187500f,-0.14062500f,-0.15625000f,0.87500000f,-0.71875000f,-0.42187500f,-0.17187500f,-0.87500000f,0.50000000f,0.15625000f,0.42187500f,0.03125000f,0.54687500f,-0.90625000f,0.06250000f,0.12500000f,-0.75000000f,0.06250000f,0.39062500f,-0.81250000f,0.03125000f,-0.50000000f,-0.21875000f,0.64062500f,0.67187500f,-0.67187500f,-0.62500000f,-0.40625000f,-0.04687500f,-0.76562500f,0.81250000f,0.53125000f,-0.43750000f,-0.37500000f,-0.59375000f,-0.57812500f,-0.50000000f,0.15625000f,0.92187500f,-0.23437500f,0.25000000f,-0.53125000f,-0.84375000f,-0.35937500f,-1.00000000f,0.75000000f,0.14062500f,0.34375000f,0.39062500f,0.67187500f,-0.42187500f,-0.82812500f,-0.45312500f,0.98437500f,-0.35937500f,0.81250000f,-0.56250000f,0.76562500f,0.67187500f,-0.81250000f,0.20312500f,-0.67187500f,-0.10937500f,-0.57812500f,-0.95312500f,-0.54687500f,0.23437500f,-0.20312500f,-0.20312500f,-0.04687500f,-0.93750000f,-0.75000000f,-0.32812500f,0.62500000f,0.15625000f,0.51562500f,-0.98437500f,0.32812500f,0.18750000f,0.03125000f,-0.23437500f,0.67187500f,-0.39062500f,-0.60937500f,-0.48437500f,0.92187500f,0.90625000f,0.00000000f,-0.64062500f,0.03125000f,-0.84375000f,0.12500000f,0.57812500f,0.04687500f,-1.00000000f,-0.43750000f,0.03125000f,0.06250000f,0.45312500f,0.67187500f,0.06250000f,-0.43750000f,-0.25000000f,-0.48437500f,0.01562500f,0.31250000f,0.75000000f,0.46875000f,0.37500000f,-0.40625000f,0.57812500f,0.98437500f,-0.65625000f,-0.17187500f,-0.84375000f,-0.23437500f,0.20312500f,0.81250000f,-0.37500000f,0.48437500f,-0.87500000f,-0.54687500f,0.34375000f,-1.00000000f,-0.06250000f,0.31250000f,0.57812500f,0.35937500f,0.37500000f,-0.20312500f,-0.18750000f,-0.85937500f,0.53125000f,0.48437500f,0.29687500f,-0.73437500f,-0.14062500f,0.28125000f,0.20312500f,0.98437500f,0.12500000f,-0.64062500f,0.18750000f,-0.15625000f,0.31250000f,0.03125000f,0.03125000f,-0.76562500f,-0.81250000f,0.15625000f,0.20312500f,0.95312500f,-0.31250000f,0.20312500f,-0.62500000f,-0.73437500f,-0.92187500f,0.93750000f,-0.79687500f,0.14062500f,0.64062500f,-0.32812500f,0.29687500f,0.20312500f,0.71875000f,0.12500000f,-0.90625000f,0.39062500f,0.25000000f,0.95312500f,-0.51562500f,0.73437500f,0.04687500f,-0.78125000f,-0.34375000f,0.09375000f,-0.28125000f,-0.07812500f,-0.50000000f,0.87500000f,0.93750000f,-0.12500000f,0.53125000f,0.70312500f,0.37500000f,0.10937500f,-0.12500000f,0.12500000f,-0.01562500f,-0.01562500f,0.54687500f,-0.26562500f,0.20312500f,0.40625000f,0.70312500f,-0.53125000f,-0.40625000f,0.64062500f,0.21875000f,-0.04687500f,-0.39062500f,0.25000000f,0.37500000f,0.76562500f,-0.46875000f,-0.26562500f,-0.82812500f,-0.31250000f,-0.23437500f,-0.95312500f,-0.84375000f,-0.15625000f,-0.09375000f,-0.98437500f,0.46875000f,-0.62500000f,0.84375000f,0.92187500f,0.01562500f,-0.17187500f,0.64062500f,-0.68750000f,-0.25000000f,0.90625000f,0.79687500f,-0.68750000f,-0.42187500f,0.65625000f,0.98437500f,0.31250000f,-0.43750000f,-0.14062500f,0.26562500f,0.90625000f,0.31250000f,0.40625000f,0.95312500f,-0.43750000f,0.70312500f,-0.81250000f,0.75000000f,0.34375000f,-0.59375000f,-0.15625000f,0.04687500f,0.89062500f,0.57812500f,-0.35937500f,-0.68750000f,0.82812500f,-0.87500000f,0.21875000f,-0.53125000f,0.54687500f,-0.28125000f,-0.45312500f,0.96875000f,0.93750000f,0.15625000f,-0.32812500f,-0.10937500f,-0.09375000f,-0.68750000f,0.21875000f,-0.87500000f,-0.82812500f,0.01562500f,-0.89062500f,0.32812500f,0.35937500f,0.21875000f,0.82812500f,-0.21875000f,0.42187500f,-0.21875000f,0.93750000f,0.51562500f,-0.65625000f,-0.89062500f,-0.75000000f,-0.64062500f,-0.81250000f,0.92187500f,-0.56250000f,0.43750000f,0.84375000f,0.76562500f,0.37500000f,0.60937500f,0.23437500f,-0.60937500f,-0.98437500f,0.21875000f,0.15625000f,0.23437500f,-0.82812500f,0.92187500f,-0.85937500f,0.76562500f,-0.28125000f,0.48437500f,0.18750000f,-0.54687500f,0.68750000f,0.09375000f,0.20312500f,-0.76562500f,-0.78125000f,1.00000000f,0.48437500f,0.50000000f,-0.67187500f,-0.42187500f,0.75000000f,0.20312500f,0.76562500f,0.31250000f,0.06250000f,-0.07812500f,-0.71875000f,0.96875000f,0.45312500f,0.00000000f,0.01562500f,0.48437500f,0.57812500f,-0.32812500f,-0.93750000f,0.48437500f,0.20312500f,-0.87500000f,-0.73437500f,-0.62500000f,-0.82812500f,-0.84375000f,-0.46875000f,0.42187500f,0.23437500f,-0.35937500f,0.09375000f,0.60937500f,-0.96875000f,-0.12500000f,-0.46875000f,-0.31250000f,0.07812500f,-0.46875000f,0.93750000f,-0.20312500f,0.75000000f,-0.81250000f,0.76562500f,0.70312500f,0.53125000f,-0.04687500f,0.00000000f,-0.76562500f,0.85937500f,-0.06250000f,0.84375000f,-0.67187500f,-0.59375000f,-0.90625000f,0.00000000f,-0.29687500f,0.81250000f,0.79687500f,-0.76562500f,-0.87500000f,0.34375000f,-0.76562500f,-0.14062500f,-0.87500000f,0.78125000f,-0.51562500f,0.96875000f,0.18750000f,0.32812500f,-1.00000000f,0.92187500f,-0.32812500f,-0.18750000f,-0.35937500f,-0.03125000f,-0.23437500f,0.39062500f,-0.23437500f,-0.89062500f,-0.79687500f,-0.89062500f,-1.00000000f,-0.12500000f,0.18750000f,0.90625000f,0.56250000f,-0.98437500f,-0.65625000f,0.65625000f,0.28125000f,0.32812500f,0.76562500f,0.96875000f,-0.31250000f,0.12500000f,0.90625000f,0.34375000f,0.42187500f,-0.39062500f,0.53125000f,0.70312500f,0.07812500f,0.46875000f,-0.42187500f,0.50000000f,0.28125000f,0.23437500f,0.70312500f,0.10937500f,-0.45312500f,0.31250000f,0.15625000f,-0.71875000f,-0.76562500f,-0.57812500f,0.75000000f,0.92187500f,0.14062500f,0.46875000f,0.06250000f,0.25000000f,-0.31250000f,-0.59375000f,0.03125000f,0.37500000f,-0.35937500f,0.90625000f,0.23437500f,-0.96875000f,-0.87500000f,0.70312500f,0.95312500f,-0.29687500f,-0.09375000f,-0.39062500f,-0.31250000f,-0.50000000f,-0.53125000f,-0.95312500f,-0.23437500f,-0.01562500f,-0.53125000f,-0.71875000f,-0.56250000f,-0.54687500f,-0.98437500f,-0.21875000f,-0.46875000f,0.98437500f,0.46875000f,0.20312500f,-0.45312500f,-0.32812500f,0.64062500f,-0.76562500f,-0.43750000f,0.56250000f,0.35937500f,-0.76562500f,0.60937500f,0.68750000f,0.96875000f,-0.50000000f,0.48437500f,-0.87500000f,-0.29687500f,-0.01562500f,0.93750000f,0.81250000f,-0.32812500f,0.93750000f,0.79687500f,-0.45312500f,0.64062500f,0.48437500f,-0.87500000f,-0.67187500f,0.78125000f,0.43750000f,-0.15625000f,-0.85937500f,0.42187500f,-0.42187500f,-0.31250000f,0.60937500f,0.12500000f,-0.85937500f,0.34375000f,0.25000000f,-0.85937500f,-0.45312500f,-0.56250000f,-0.84375000f,-0.28125000f,0.87500000f,-0.14062500f,0.95312500f,-0.59375000f,0.43750000f,0.90625000f,-1.00000000f,0.04687500f,-0.60937500f,-0.54687500f,-0.15625000f,0.51562500f,-0.29687500f,-0.40625000f,0.81250000f,-0.67187500f,-0.51562500f,0.15625000f,-0.79687500f,0.04687500f,0.71875000f,-0.79687500f,-0.70312500f,-0.89062500f,0.18750000f,-1.00000000f,-0.98437500f,-0.04687500f,-0.46875000f,-0.09375000f,-0.62500000f,-0.48437500f,-0.29687500f,0.96875000f,0.71875000f,-0.46875000f,0.45312500f,-0.79687500f,0.23437500f,-0.23437500f,0.25000000f,0.20312500f,0.71875000f,-0.20312500f,-0.43750000f,0.48437500f,0.31250000f,-0.89062500f,-0.15625000f,0.98437500f,-0.15625000f,0.56250000f,-0.06250000f,0.85937500f,0.82812500f,-0.32812500f,0.40625000f,0.73437500f,-0.53125000f,-0.82812500f,-0.37500000f,0.70312500f,0.31250000f,-0.56250000f,0.28125000f,-0.20312500f,-0.09375000f,0.98437500f,0.70312500f,0.01562500f,0.25000000f,0.10937500f,0.34375000f,0.14062500f,-0.98437500f,0.79687500f,-0.54687500f,-0.12500000f,0.48437500f,-0.95312500f,-0.21875000f,0.25000000f,0.03125000f,-0.28125000f,-0.17187500f,0.20312500f,0.68750000f,0.48437500f,0.00000000f,0.35937500f,-0.73437500f,0.14062500f,-0.40625000f,-0.96875000f,-0.12500000f,0.12500000f,0.23437500f,0.95312500f,0.39062500f,0.25000000f,-0.96875000f,0.73437500f,-0.96875000f,0.18750000f,0.81250000f,0.90625000f,-0.70312500f,0.84375000f,-0.59375000f,0.32812500f,1.00000000f,0.89062500f,-0.57812500f,-0.43750000f,0.37500000f,0.23437500f,-0.57812500f,-0.34375000f,-0.37500000f,0.85937500f,-0.04687500f,0.29687500f,-0.40625000f,-0.65625000f,-0.85937500f,0.07812500f,-0.75000000f,-0.35937500f,-0.34375000f,0.85937500f,0.18750000f,0.78125000f,-0.25000000f,0.37500000f,0.65625000f,0.03125000f,0.64062500f,0.70312500f,0.37500000f,0.14062500f,0.57812500f,0.84375000f,0.89062500f,0.93750000f,0.51562500f,-0.67187500f,0.32812500f,0.12500000f,0.31250000f,0.70312500f,0.81250000f,-0.96875000f,0.07812500f,0.60937500f,-0.32812500f,-0.71875000f,0.14062500f,0.75000000f,-0.35937500f,-0.90625000f,-0.71875000f,-0.23437500f,-0.75000000f,-0.56250000f,-0.95312500f,0.28125000f,-0.62500000f,0.96875000f,0.65625000f,-0.21875000f,0.67187500f,-0.01562500f,0.85937500f,-0.76562500f,0.75000000f,-0.39062500f,0.76562500f,0.03125000f,0.92187500f,-0.50000000f,0.95312500f,-0.87500000f,-0.01562500f,0.06250000f,-0.03125000f,0.35937500f,-0.81250000f,-0.76562500f,0.87500000f,0.07812500f,0.79687500f,0.85937500f,0.14062500f,0.93750000f,-0.29687500f,-0.98437500f,0.84375000f,-0.06250000f,-0.71875000f,0.03125000f,-0.10937500f,0.42187500f,-0.85937500f,-0.40625000f,-0.96875000f,0.28125000f,0.31250000f,0.98437500f,0.29687500f,-0.46875000f,0.57812500f,-0.54687500f,0.78125000f,0.64062500f,-0.18750000f,0.14062500f,-0.81250000f,-0.75000000f,0.00000000f,-0.56250000f,0.98437500f,0.57812500f,-0.34375000f,0.84375000f,-0.32812500f,-0.57812500f,0.57812500f,0.57812500f,-0.15625000f,-0.15625000f,-0.65625000f,0.73437500f,0.71875000f,-0.04687500f,0.64062500f,-0.71875000f,-0.95312500f,-0.53125000f,-0.64062500f,-0.78125000f,-0.53125000f,-0.34375000f,0.21875000f,0.15625000f,0.21875000f,-0.35937500f,0.71875000f,0.70312500f,-0.07812500f,0.15625000f,0.45312500f,-0.70312500f,0.40625000f,-0.60937500f,-0.95312500f,0.71875000f,-0.60937500f,-0.90625000f,-0.14062500f,0.15625000f,0.75000000f,0.67187500f,-0.67187500f,0.89062500f,-0.82812500f,0.01562500f,-0.54687500f,0.48437500f,0.64062500f,-0.92187500f,0.35937500f,0.62500000f,0.35937500f,0.75000000f,0.29687500f,0.04687500f,-0.64062500f,-0.96875000f,0.29687500f,-0.42187500f,0.90625000f,-0.42187500f,-0.70312500f,0.07812500f,0.73437500f,0.89062500f,-0.70312500f,0.00000000f,-0.70312500f,0.64062500f,0.67187500f,0.43750000f,-0.90625000f,-0.46875000f,0.84375000f,0.01562500f,0.85937500f,-0.23437500f,0.75000000f,-0.23437500f,0.87500000f,-0.39062500f,0.12500000f,0.06250000f,-0.12500000f,-0.71875000f,0.71875000f,-0.48437500f,0.67187500f,0.79687500f,0.01562500f,-0.50000000f,-0.81250000f,0.12500000f,0.15625000f,0.82812500f,0.15625000f,-1.00000000f,0.07812500f,-0.46875000f,0.07812500f,0.85937500f,-0.17187500f,0.50000000f,0.23437500f,-0.26562500f,0.53125000f,-0.40625000f,0.65625000f,0.45312500f,1.00000000f,0.31250000f,-0.51562500f,0.43750000f,0.90625000f,-0.23437500f,0.96875000f,0.85937500f,-0.73437500f,-0.03125000f,0.92187500f,0.54687500f,0.15625000f,-0.57812500f,-0.51562500f,-0.18750000f,-0.92187500f,0.06250000f,0.20312500f,-0.98437500f,0.79687500f,0.82812500f,0.09375000f,0.76562500f,-0.85937500f,0.10937500f,0.10937500f,-0.92187500f,0.45312500f,-0.39062500f,0.01562500f,-0.60937500f,0.79687500f,0.21875000f,-0.50000000f,0.39062500f,-0.35937500f,0.03125000f,0.43750000f,0.14062500f,0.70312500f,0.81250000f,-0.64062500f,-0.25000000f,0.59375000f,0.96875000f,-0.45312500f,-0.89062500f,0.51562500f,0.46875000f,-0.18750000f,0.59375000f,0.75000000f,0.26562500f,0.54687500f,-0.56250000f,-0.23437500f,-0.73437500f,-0.37500000f,0.67187500f,-0.03125000f,-0.29687500f,-0.26562500f,-0.79687500f,0.51562500f,-0.23437500f,-0.53125000f,0.90625000f,-0.59375000f,-0.10937500f,0.78125000f,0.40625000f,-0.85937500f,0.23437500f,0.62500000f,0.71875000f,-0.75000000f,-0.59375000f,0.62500000f,-1.00000000f,0.90625000f,-0.65625000f,-0.71875000f,-0.95312500f,0.25000000f,-0.23437500f,0.23437500f,-0.92187500f,0.07812500f,-0.10937500f,0.43750000f,0.35937500f,-0.10937500f,0.89062500f,-0.09375000f,0.03125000f,-0.92187500f,0.45312500f,0.34375000f,-0.23437500f,0.56250000f,0.28125000f,0.23437500f,-0.32812500f,-0.82812500f,-0.42187500f,-0.53125000f,-0.95312500f,-0.32812500f,0.53125000f,0.29687500f,0.18750000f,-0.14062500f,-0.93750000f,-0.07812500f,-0.06250000f,-0.17187500f,0.42187500f,0.32812500f,-0.39062500f,0.46875000f,0.35937500f,0.67187500f,0.23437500f,0.76562500f,-0.07812500f,-0.25000000f,0.78125000f,-0.64062500f,-0.43750000f,-0.03125000f,-0.48437500f,-0.81250000f,0.18750000f,0.37500000f,0.35937500f,-0.89062500f,1.00000000f,-0.75000000f,-0.93750000f,-0.76562500f,-0.31250000f,-0.93750000f,-0.14062500f,-0.81250000f,-0.95312500f,0.98437500f,0.06250000f,0.76562500f,0.35937500f,0.59375000f,-0.79687500f,-0.07812500f,0.59375000f,0.64062500f,-0.90625000f,0.90625000f,-0.29687500f,-0.37500000f,0.96875000f,-0.39062500f,-0.51562500f,-0.10937500f,0.20312500f,-0.70312500f,-0.85937500f,0.79687500f,-0.20312500f,-0.84375000f,0.84375000f,-0.78125000f,-0.10937500f,0.20312500f,0.78125000f,0.78125000f,0.12500000f,0.14062500f,0.50000000f,0.90625000f,-0.34375000f,-0.43750000f,0.90625000f,0.28125000f,-0.73437500f,0.90625000f,-0.79687500f,-0.71875000f,-0.26562500f,0.40625000f,-0.50000000f,-0.04687500f,0.29687500f,-0.71875000f,-0.60937500f,0.34375000f,-0.93750000f,0.79687500f,0.48437500f,-0.65625000f,0.87500000f,-0.89062500f,-0.82812500f,-0.53125000f,0.60937500f,0.48437500f,-0.67187500f,-0.67187500f,-0.79687500f,-0.06250000f,0.98437500f,0.18750000f,0.56250000f,-0.60937500f,0.87500000f,0.93750000f,-0.17187500f,-0.31250000f,0.92187500f,-0.40625000f,0.48437500f,-0.73437500f,-0.32812500f,-0.31250000f,0.64062500f,-0.23437500f,-0.84375000f,-0.29687500f,0.62500000f,0.90625000f,0.15625000f,-0.65625000f,0.71875000f,0.57812500f,0.20312500f,0.43750000f,0.42187500f,-0.04687500f,0.39062500f,-0.51562500f,-0.79687500f,0.07812500f,-0.10937500f,0.92187500f,-0.32812500f,0.15625000f,-0.59375000f,0.03125000f,0.34375000f,0.95312500f,0.31250000f,-0.56250000f,-0.50000000f,0.28125000f,-0.89062500f,0.06250000f,0.56250000f,-0.15625000f,0.32812500f,-0.37500000f,-0.46875000f,-0.31250000f,-0.95312500f,0.15625000f,0.64062500f,0.59375000f,-0.98437500f,-0.51562500f,-0.12500000f,-0.57812500f,0.37500000f,-0.37500000f,-0.56250000f,-0.32812500f,0.93750000f,-0.03125000f,-0.45312500f,0.48437500f,-0.96875000f,0.53125000f,-0.67187500f,1.00000000f,0.14062500f,-0.62500000f,0.54687500f,0.53125000f,-0.18750000f,0.59375000f,-0.67187500f,-0.23437500f,0.03125000f,0.95312500f,0.17187500f,0.64062500f,0.31250000f,0.98437500f,-0.17187500f,-0.82812500f,-0.60937500f,-0.45312500f,0.67187500f,0.54687500f,-0.06250000f,0.71875000f,-0.92187500f,-0.79687500f,-0.68750000f,0.31250000f,0.29687500f,0.07812500f,-0.26562500f,-0.21875000f,-0.14062500f,0.40625000f,-0.10937500f,0.79687500f,-0.28125000f,0.93750000f,0.26562500f,-0.75000000f,-0.32812500f,-0.35937500f,-0.70312500f,0.84375000f,-0.37500000f,-0.07812500f,0.39062500f,-0.84375000f,0.60937500f,0.40625000f,0.50000000f,0.81250000f,0.12500000f,0.82812500f,0.89062500f,0.84375000f,-0.64062500f,0.81250000f,-0.18750000f,0.85937500f,-0.14062500f,0.35937500f,-0.09375000f,-0.60937500f,0.40625000f,-0.14062500f,0.37500000f,0.37500000f,0.84375000f,0.03125000f,0.54687500f,0.60937500f,0.32812500f,-0.53125000f,-0.04687500f,-0.75000000f,0.37500000f,0.59375000f,-0.42187500f,-0.26562500f,-0.25000000f,0.78125000f,0.29687500f,0.04687500f,0.20312500f,0.26562500f,0.35937500f,-0.76562500f,0.81250000f,-0.01562500f,-1.00000000f,0.90625000f,-0.73437500f,-0.29687500f,0.21875000f,0.01562500f,0.00000000f,-0.28125000f,0.85937500f,0.23437500f,0.54687500f,-0.90625000f,0.90625000f,-0.92187500f,-0.85937500f,0.73437500f,-0.34375000f,-0.04687500f,-0.53125000f,0.42187500f,-0.95312500f,0.23437500f,0.12500000f,0.92187500f,0.32812500f,-0.62500000f,-0.45312500f,-0.57812500f,-0.35937500f,0.35937500f,0.84375000f,-0.54687500f,-0.23437500f,-0.84375000f,-0.34375000f,0.20312500f,-0.39062500f,-0.46875000f,-0.43750000f,0.10937500f,-0.95312500f,0.64062500f,-0.32812500f,0.09375000f,0.00000000f,-0.65625000f,0.42187500f,-0.07812500f,-0.54687500f,0.17187500f,0.35937500f,0.28125000f,-0.46875000f,0.45312500f,-0.23437500f,0.12500000f,-0.96875000f,0.84375000f,-0.37500000f,0.31250000f,0.68750000f,-0.01562500f,-0.79687500f,0.85937500f,0.06250000f,-0.06250000f,-0.85937500f,0.54687500f,-0.03125000f,0.37500000f,-0.06250000f,0.40625000f,0.20312500f,-0.59375000f,0.07812500f,-0.87500000f,0.07812500f,0.65625000f,0.17187500f,0.70312500f,-0.03125000f,-0.79687500f,0.01562500f,-0.60937500f,0.35937500f,0.04687500f,0.37500000f,-0.45312500f,-0.82812500f,0.18750000f,-0.37500000f,-0.53125000f,0.00000000f,-0.06250000f,-0.57812500f,0.00000000f,-0.10937500f,-0.45312500f,0.32812500f,0.93750000f,0.48437500f,0.00000000f,-0.96875000f,0.98437500f,0.95312500f,-0.29687500f,0.98437500f,-0.92187500f,0.39062500f,-0.26562500f,-0.73437500f,-0.85937500f,0.12500000f,0.20312500f,0.29687500f,-0.46875000f,0.03125000f,0.25000000f,-0.32812500f,0.68750000f,-0.37500000f,0.39062500f,-0.75000000f,-0.07812500f,-0.48437500f,-0.32812500f,-0.43750000f,-0.75000000f,0.04687500f,0.06250000f,0.07812500f,-0.65625000f,-0.67187500f,-0.85937500f,-0.23437500f,-0.78125000f,0.48437500f,-0.76562500f,0.76562500f,-0.85937500f,0.35937500f,0.42187500f,1.00000000f,0.20312500f,0.84375000f,0.82812500f,-0.15625000f,0.96875000f,0.12500000f,0.82812500f,-0.03125000f,0.10937500f,-0.68750000f,-0.04687500f,-0.59375000f,0.73437500f,0.78125000f,0.81250000f,0.06250000f,-0.20312500f,-0.50000000f,-0.43750000f,-0.04687500f,-0.81250000f,0.96875000f,-0.71875000f,0.95312500f,0.18750000f,-0.62500000f,0.43750000f,0.00000000f,-0.76562500f,0.64062500f,-0.12500000f,-0.73437500f,-0.28125000f,0.64062500f,-0.96875000f,-0.85937500f,0.65625000f,-0.10937500f,-0.54687500f,0.15625000f,-0.39062500f,-0.25000000f,-0.81250000f,0.73437500f,-0.50000000f,-0.32812500f,0.93750000f,0.35937500f,-0.25000000f,0.73437500f,0.34375000f,-0.46875000f,0.57812500f,-0.04687500f,-0.96875000f,-0.92187500f,0.03125000f,-0.68750000f,0.43750000f,0.12500000f,0.68750000f,-0.28125000f,-0.78125000f,-0.17187500f,0.40625000f,0.57812500f,-0.53125000f,0.06250000f,0.87500000f,-0.70312500f,-0.39062500f,0.60937500f,-0.42187500f,0.60937500f,-0.53125000f,0.98437500f,0.17187500f,-0.32812500f,0.93750000f,-0.14062500f,0.56250000f,-0.12500000f,-0.85937500f,-0.23437500f,-0.10937500f,0.06250000f,0.95312500f,-0.59375000f,-0.46875000f,0.92187500f,0.23437500f,0.10937500f,0.98437500f,0.01562500f,-0.32812500f,0.07812500f,0.03125000f,0.09375000f,0.56250000f,0.32812500f,-0.25000000f,-0.60937500f,-0.90625000f,0.14062500f,-0.45312500f,0.42187500f,-0.62500000f,0.12500000f,0.93750000f,0.92187500f,0.26562500f,0.04687500f,-0.26562500f,0.18750000f,0.81250000f,0.26562500f,0.51562500f,0.28125000f,-0.59375000f,0.20312500f,0.17187500f,0.95312500f,-0.71875000f,-0.23437500f,0.68750000f,0.62500000f,-0.51562500f,-0.12500000f,-0.76562500f,0.53125000f,0.37500000f,-0.46875000f,-0.40625000f,0.51562500f,-0.78125000f,-0.42187500f,0.10937500f,-0.87500000f,0.45312500f,0.06250000f,0.84375000f,-0.64062500f,0.17187500f,0.03125000f,0.43750000f,0.73437500f,0.15625000f,0.45312500f,0.39062500f,0.96875000f,0.82812500f,-0.68750000f,0.68750000f,-0.89062500f,-0.46875000f,0.48437500f,-0.21875000f,-0.92187500f,0.20312500f,0.84375000f,0.28125000f,0.56250000f,0.85937500f,0.43750000f,-0.51562500f,0.65625000f,0.65625000f,0.57812500f,0.03125000f,-0.35937500f,-0.35937500f,0.84375000f,0.48437500f,0.03125000f,0.15625000f,-0.32812500f,-0.32812500f,-0.96875000f,0.46875000f,-0.73437500f,-0.39062500f,0.67187500f,-0.90625000f,-0.15625000f,0.06250000f,-0.39062500f,0.12500000f,-0.84375000f,0.59375000f,0.95312500f,-0.75000000f,0.54687500f,-0.17187500f,-0.31250000f,-0.06250000f,0.68750000f,0.26562500f,-0.51562500f,-0.70312500f,-0.09375000f,0.26562500f,-0.56250000f,0.18750000f,0.64062500f,0.48437500f,0.20312500f,-0.65625000f,0.21875000f,1.00000000f,0.15625000f,-1.00000000f,0.07812500f,0.18750000f,0.29687500f,0.79687500f,-0.23437500f,0.03125000f,0.75000000f,0.62500000f,0.32812500f,0.84375000f,-0.59375000f,-0.25000000f,-0.68750000f,0.68750000f,-0.96875000f,0.84375000f,-0.82812500f,0.78125000f,0.34375000f,-0.76562500f,0.28125000f,-0.34375000f,0.29687500f,-0.06250000f,-0.81250000f,-0.45312500f,-0.54687500f,-0.87500000f,0.62500000f,0.28125000f,0.92187500f,-0.89062500f,0.09375000f,0.65625000f,0.73437500f,-0.29687500f,-0.76562500f,0.25000000f,-0.23437500f,0.14062500f,-0.03125000f,0.84375000f,-0.96875000f,-0.82812500f,0.79687500f,-0.26562500f,0.93750000f,-0.12500000f,0.03125000f,-0.32812500f,-1.00000000f,-0.85937500f,-0.45312500f,0.79687500f,0.46875000f,-0.82812500f,-0.84375000f,0.45312500f,0.82812500f,-0.46875000f,-0.09375000f,-0.62500000f,0.14062500f,0.45312500f,-0.89062500f,-0.56250000f,0.54687500f,0.06250000f,-0.53125000f,-0.98437500f,0.59375000f,-0.01562500f,0.78125000f,-0.04687500f,0.03125000f,-0.09375000f,-0.07812500f,0.03125000f,0.48437500f,-0.42187500f,-0.07812500f,0.09375000f,0.29687500f,-0.89062500f,-0.81250000f,0.76562500f,-0.01562500f,0.28125000f,-0.14062500f,-0.09375000f,0.56250000f,0.78125000f,0.96875000f,-0.78125000f,-0.48437500f,-0.65625000f,0.79687500f,-0.59375000f,-0.76562500f,0.07812500f,0.43750000f,-0.45312500f,-0.79687500f,0.09375000f,0.48437500f,-0.04687500f,-0.73437500f,-0.89062500f,0.14062500f,-0.90625000f,0.10937500f,-0.42187500f,-0.56250000f,-0.15625000f,-0.26562500f,-0.40625000f,-0.95312500f,-0.56250000f,0.85937500f,0.64062500f,0.32812500f,-0.68750000f,-0.46875000f,0.92187500f,-0.82812500f,0.59375000f,0.85937500f,-0.18750000f,-0.23437500f,-0.03125000f,-0.67187500f,0.48437500f,0.59375000f,0.95312500f,-0.18750000f,-0.87500000f,0.71875000f,0.35937500f,-0.65625000f,0.39062500f,0.10937500f,0.06250000f,0.56250000f,-0.23437500f,-0.46875000f,-0.20312500f,0.59375000f,0.39062500f,-0.96875000f,-0.26562500f,-0.93750000f,-0.06250000f,0.15625000f,-0.65625000f,0.03125000f,-0.01562500f,-0.51562500f,-0.68750000f,-0.01562500f,0.89062500f,-0.31250000f,0.79687500f,-0.31250000f,0.89062500f,0.31250000f,-0.12500000f,0.18750000f,-0.43750000f,0.62500000f,0.12500000f,-0.82812500f,-0.81250000f,-0.46875000f,-0.51562500f,0.40625000f,-0.07812500f,0.25000000f,-1.00000000f,0.43750000f,0.76562500f,0.60937500f,0.67187500f,0.40625000f,-0.42187500f,-0.73437500f,-0.56250000f,-0.12500000f,-0.50000000f,0.46875000f,0.06250000f,0.87500000f,-0.68750000f,0.65625000f,-0.35937500f,0.51562500f,0.03125000f,-0.54687500f,0.37500000f,-0.78125000f,0.43750000f,0.14062500f,0.15625000f,-0.07812500f,0.25000000f,0.68750000f,0.31250000f,0.37500000f,-0.78125000f,-0.73437500f,-0.68750000f,-0.40625000f,0.95312500f,-0.75000000f,-0.89062500f,-0.73437500f,0.48437500f,-0.17187500f,0.32812500f,0.71875000f,-0.62500000f,-0.25000000f,-0.04687500f,0.28125000f,-0.81250000f,-0.25000000f,0.03125000f,0.29687500f,-0.40625000f,0.64062500f,0.84375000f,-0.40625000f,0.92187500f,-0.35937500f,0.87500000f,0.25000000f,0.34375000f,-0.04687500f,0.85937500f,0.81250000f,0.84375000f,-0.70312500f,0.10937500f,-0.21875000f,-0.48437500f,0.50000000f,-0.29687500f,0.75000000f,-0.50000000f,0.23437500f,0.03125000f,0.37500000f,0.60937500f,0.34375000f,0.79687500f,-0.71875000f,-0.50000000f,0.84375000f,-0.29687500f,0.40625000f,-0.85937500f,-0.29687500f,0.98437500f,0.14062500f,0.48437500f,-0.75000000f,0.18750000f,-0.75000000f,-0.62500000f,-0.18750000f,-0.92187500f,0.81250000f,-0.64062500f,0.71875000f,-0.82812500f,-0.53125000f,-0.70312500f,0.15625000f,-0.53125000f,0.09375000f,-0.45312500f,0.79687500f,0.14062500f,0.96875000f,-0.28125000f,0.32812500f,0.92187500f,0.78125000f,-0.07812500f,0.79687500f,0.85937500f,0.06250000f,0.98437500f,-0.14062500f,-0.53125000f,-0.92187500f,0.01562500f,-0.20312500f,0.25000000f,-0.70312500f,-0.89062500f,0.84375000f,-0.64062500f,0.67187500f,0.75000000f,-0.35937500f,-0.59375000f,0.68750000f,0.71875000f,-0.45312500f,0.45312500f,0.31250000f,0.37500000f,0.53125000f,-0.68750000f,0.12500000f,0.73437500f,-0.67187500f,0.84375000f,0.90625000f,0.01562500f,-0.15625000f,-0.07812500f,-0.73437500f,-0.73437500f,0.54687500f,0.34375000f,-0.68750000f,0.56250000f,-1.00000000f,0.00000000f,0.32812500f,-0.95312500f,0.34375000f,0.43750000f,0.70312500f,-0.93750000f,-0.40625000f,0.00000000f,0.06250000f,0.26562500f,0.20312500f,0.09375000f,-0.15625000f,0.18750000f,-0.51562500f,0.84375000f,0.07812500f,-0.29687500f,-0.03125000f,0.84375000f,0.20312500f,-0.57812500f,0.45312500f,-0.35937500f,-0.54687500f,-0.37500000f,0.43750000f,0.34375000f,0.43750000f,-0.93750000f,-0.18750000f,-0.42187500f,-0.75000000f,-0.15625000f,-0.43750000f,-0.92187500f,-0.12500000f,-0.56250000f,-0.92187500f,0.54687500f,0.84375000f,0.39062500f,0.23437500f,-0.37500000f,0.67187500f,-0.65625000f,0.76562500f,0.92187500f,-0.18750000f,-0.90625000f,-0.34375000f,0.87500000f,-0.46875000f,0.20312500f,-0.67187500f,-0.15625000f,0.75000000f,-0.23437500f,0.40625000f,0.10937500f,0.37500000f,-0.93750000f,-0.75000000f,-0.07812500f,-0.76562500f,-0.95312500f,0.28125000f,-0.26562500f,-0.98437500f,0.04687500f,-0.76562500f,-0.39062500f,-0.03125000f,0.79687500f,0.87500000f,0.96875000f,-0.04687500f,-0.50000000f,0.31250000f,0.06250000f,-0.70312500f,-0.25000000f,-0.12500000f,-0.64062500f,-0.01562500f,0.40625000f,0.62500000f,0.78125000f,-0.10937500f,0.54687500f,0.67187500f,0.73437500f,0.71875000f,-0.76562500f,0.70312500f,0.26562500f,-0.09375000f,0.12500000f,0.26562500f,-0.12500000f,-0.54687500f,0.46875000f,0.25000000f,0.81250000f,0.10937500f,0.78125000f,-0.40625000f,-0.04687500f,0.18750000f,-0.10937500f,0.71875000f,0.03125000f,0.18750000f,0.90625000f,-0.93750000f,-0.87500000f,-0.60937500f,0.84375000f,0.68750000f,0.68750000f,-0.56250000f,0.87500000f,-0.09375000f,-0.23437500f,-0.92187500f,-0.89062500f,-0.59375000f,0.23437500f,0.23437500f,0.64062500f,-0.71875000f,0.65625000f,0.45312500f,-0.25000000f,0.60937500f,0.35937500f,-0.95312500f,1.00000000f,0.60937500f,0.62500000f,0.00000000f,0.85937500f,0.75000000f,0.60937500f,0.76562500f,-0.48437500f,0.73437500f,0.34375000f,-0.04687500f,-0.96875000f,0.81250000f,0.35937500f,0.73437500f,0.04687500f,0.54687500f,-0.14062500f,0.56250000f,-0.62500000f,0.35937500f,-0.06250000f,0.15625000f,0.14062500f,0.06250000f,0.60937500f,-0.17187500f,0.07812500f,0.50000000f,0.65625000f,-0.71875000f,0.53125000f,0.17187500f,-0.45312500f,0.90625000f,0.50000000f,-0.56250000f,0.37500000f,-0.20312500f,-0.78125000f,0.79687500f,0.82812500f,0.79687500f,-0.67187500f,-0.96875000f,0.43750000f,0.00000000f,0.95312500f,-0.96875000f,-0.23437500f,-0.21875000f,0.48437500f,0.87500000f,0.85937500f,-0.09375000f,0.84375000f,-0.48437500f,-0.96875000f,0.43750000f,0.28125000f,0.78125000f,-0.62500000f,-0.79687500f,-0.35937500f,-0.04687500f,-0.81250000f,-0.01562500f,0.07812500f,-0.17187500f,0.70312500f,0.01562500f,0.85937500f,-0.18750000f,0.17187500f,-0.98437500f,0.07812500f,-0.62500000f,0.34375000f,-0.32812500f,-0.42187500f,0.42187500f,0.17187500f,0.50000000f,0.07812500f,-0.18750000f,0.50000000f,-0.82812500f,0.17187500f,-0.67187500f,0.03125000f,-0.35937500f,0.12500000f,-0.71875000f,-0.25000000f,0.21875000f,0.50000000f,0.28125000f,0.57812500f,-0.54687500f,-0.15625000f,0.03125000f,0.15625000f,-0.45312500f,0.40625000f,-1.00000000f,-0.42187500f,-0.40625000f,0.65625000f,-0.62500000f,-0.95312500f,0.56250000f,0.42187500f,-0.15625000f,0.79687500f,1.00000000f,0.00000000f,-0.79687500f,0.84375000f,0.89062500f,-0.26562500f,0.03125000f,-0.54687500f,0.15625000f,-0.31250000f,-0.53125000f,0.51562500f,-0.09375000f,-0.40625000f,0.26562500f,-0.48437500f,-0.53125000f,0.06250000f,0.42187500f,-0.93750000f,-0.34375000f,-0.34375000f,0.23437500f,0.01562500f,-0.20312500f,-0.21875000f,-0.04687500f,0.85937500f,0.21875000f,-0.79687500f,-0.92187500f,-0.89062500f,0.21875000f,-0.59375000f,-0.71875000f,0.12500000f,0.20312500f,-0.48437500f,0.62500000f,0.90625000f,0.01562500f,-0.71875000f,-0.95312500f,-0.90625000f,0.01562500f,-0.31250000f,0.96875000f,-0.39062500f,0.07812500f,0.53125000f,0.96875000f,0.26562500f,0.20312500f,0.40625000f,-0.56250000f,-1.00000000f,0.37500000f,0.75000000f,0.09375000f,0.81250000f,0.90625000f,-0.57812500f,0.23437500f,0.92187500f,0.12500000f,-0.25000000f,-0.07812500f,-0.03125000f,-0.85937500f,-0.90625000f,-0.35937500f,0.89062500f,-0.70312500f,0.96875000f,-1.00000000f,0.84375000f,0.03125000f,-0.84375000f,0.89062500f,-0.92187500f,0.04687500f,0.20312500f,0.17187500f,0.51562500f,-0.34375000f,0.04687500f,0.89062500f,0.07812500f,0.26562500f,0.29687500f,0.65625000f,0.73437500f,-0.29687500f,0.96875000f,0.50000000f,-0.95312500f,0.92187500f,0.98437500f,0.73437500f,-0.59375000f,-0.76562500f,-0.50000000f,-0.65625000f,-0.37500000f,-0.89062500f,-0.29687500f,-0.15625000f,0.51562500f,-0.53125000f,-0.56250000f,-0.28125000f,-0.35937500f,-0.10937500f,-0.29687500f,-0.34375000f,-0.35937500f,-0.65625000f,-0.07812500f,0.89062500f,0.75000000f,-0.37500000f,0.15625000f,0.34375000f,-0.06250000f,0.01562500f,0.23437500f,0.56250000f,0.89062500f,0.65625000f,0.17187500f,0.87500000f,-0.39062500f,-0.17187500f,0.57812500f,0.56250000f,0.75000000f,0.32812500f,0.50000000f,-0.51562500f,-0.09375000f,0.00000000f,0.48437500f,0.67187500f,-0.46875000f,-0.65625000f,0.53125000f,0.12500000f,-0.31250000f,-0.40625000f,-0.84375000f,0.53125000f,-0.04687500f,0.43750000f,-0.73437500f,-0.03125000f,0.31250000f,0.81250000f,0.23437500f,0.23437500f,-0.03125000f,-0.46875000f,-0.23437500f,-0.15625000f,0.09375000f,-0.62500000f,0.65625000f,-0.42187500f,0.18750000f,-0.64062500f,-0.76562500f,0.98437500f,-0.35937500f,-0.28125000f,-0.70312500f,-0.73437500f,-0.85937500f,-0.57812500f,-0.50000000f,-0.35937500f,0.07812500f,-0.87500000f,0.04687500f,-0.26562500f,0.73437500f,-0.87500000f,-0.42187500f,0.54687500f,0.65625000f,0.84375000f,0.64062500f,-0.85937500f,-0.89062500f,-0.14062500f,-0.64062500f,-0.03125000f,-0.28125000f,0.82812500f,-0.70312500f,0.81250000f,0.93750000f,0.96875000f,-0.17187500f,-0.01562500f,0.65625000f,0.87500000f,-0.23437500f,-0.81250000f,0.39062500f,-0.45312500f,-0.75000000f,-0.96875000f,1.00000000f,0.62500000f,-0.32812500f,-0.73437500f,-0.50000000f,0.76562500f,-0.76562500f,0.32812500f,0.95312500f,-0.50000000f,0.70312500f,-0.31250000f,0.15625000f,-0.54687500f,-0.35937500f,0.89062500f,0.09375000f,-0.96875000f,0.84375000f,-0.06250000f,0.31250000f,-0.50000000f,0.85937500f,0.67187500f,0.67187500f,0.76562500f,0.25000000f,0.48437500f,0.09375000f,-0.26562500f,0.43750000f,-0.04687500f,-0.87500000f,0.76562500f,-0.40625000f,0.21875000f,-0.82812500f,0.56250000f,-0.23437500f,-0.48437500f,0.85937500f,-0.37500000f,0.96875000f,-0.71875000f,0.62500000f,0.42187500f,0.29687500f,-0.96875000f,-0.73437500f,-0.87500000f,-1.00000000f,-0.51562500f,0.90625000f,0.95312500f,-0.96875000f,0.85937500f,-0.09375000f,-0.87500000f,-0.46875000f,-0.76562500f,-0.57812500f,-0.20312500f,0.32812500f,-0.01562500f,0.96875000f,0.45312500f,-0.35937500f,0.03125000f,0.76562500f,-0.93750000f,0.79687500f,0.95312500f,0.28125000f,0.45312500f,-0.10937500f,-0.56250000f,-0.56250000f,0.01562500f,0.03125000f,0.00000000f,-0.18750000f,-0.93750000f,-0.31250000f,-0.34375000f,-0.32812500f,0.26562500f,-0.42187500f,0.34375000f,0.76562500f,0.68750000f,0.96875000f,0.84375000f,0.76562500f,0.39062500f,-0.31250000f,0.29687500f,0.54687500f,0.29687500f,0.89062500f,-0.95312500f,-0.48437500f,-0.15625000f,-0.64062500f,-0.84375000f,0.42187500f,-0.81250000f,0.93750000f,0.73437500f,-0.64062500f,-0.26562500f,0.45312500f,-0.95312500f,0.93750000f,0.40625000f,-0.45312500f,-0.93750000f,-0.15625000f,-0.73437500f,0.01562500f,0.50000000f,-0.12500000f,-0.96875000f,0.37500000f,0.79687500f,0.92187500f,-0.10937500f,-0.90625000f,-0.62500000f,0.53125000f,0.39062500f,0.92187500f,-0.95312500f,0.65625000f,-0.17187500f,0.93750000f,-0.64062500f,0.37500000f,0.26562500f,-0.62500000f,-0.75000000f,-0.81250000f,0.37500000f,-0.20312500f,0.00000000f,0.79687500f,-0.56250000f,0.59375000f,1.00000000f,-0.50000000f,0.40625000f,-0.95312500f,-0.87500000f,0.92187500f,0.28125000f,0.98437500f,0.70312500f,-0.95312500f,-0.35937500f,-0.96875000f,0.51562500f,-0.04687500f,-0.78125000f,-0.93750000f,0.06250000f,-0.70312500f,0.06250000f,-0.42187500f,-0.51562500f,-0.65625000f,-1.00000000f,-0.01562500f,0.54687500f,-0.25000000f,0.09375000f,0.87500000f,0.07812500f,0.68750000f,0.20312500f,0.31250000f,-0.28125000f,0.57812500f,-0.14062500f,-0.93750000f,-0.78125000f,0.35937500f,-0.18750000f,-0.07812500f,0.60937500f,-0.18750000f,-0.90625000f,0.35937500f,-0.28125000f,0.23437500f,-0.87500000f,-0.93750000f,-0.06250000f,-0.18750000f,0.12500000f,0.96875000f,-0.01562500f,-0.85937500f,0.29687500f,-0.42187500f,-0.43750000f,-0.56250000f,-0.93750000f,0.96875000f,-0.29687500f,0.29687500f,0.73437500f,0.01562500f,-0.35937500f,0.28125000f,-0.65625000f,-0.18750000f,-0.43750000f,-0.10937500f,0.35937500f,-0.01562500f,-0.84375000f,0.28125000f,0.67187500f,0.25000000f,0.50000000f,0.23437500f,-0.81250000f,0.10937500f,-0.56250000f,0.54687500f,0.07812500f,-0.76562500f,0.14062500f,-0.17187500f,0.93750000f,-0.28125000f,-0.78125000f,-0.68750000f,0.45312500f,0.09375000f,0.75000000f,0.50000000f,0.01562500f,-0.23437500f,-0.68750000f,0.57812500f,0.73437500f,-0.46875000f,-0.82812500f,0.40625000f,-0.15625000f,0.81250000f,-0.40625000f,-0.25000000f,-0.85937500f,-0.71875000f,0.71875000f,0.78125000f,0.90625000f,0.87500000f,-0.90625000f,0.64062500f,0.40625000f,-0.34375000f,0.17187500f,0.06250000f,0.87500000f,0.48437500f,-0.34375000f,1.00000000f,0.10937500f,-0.51562500f,-0.73437500f,0.81250000f,-0.95312500f,0.53125000f,-0.46875000f,0.20312500f,0.75000000f,-0.87500000f,-0.85937500f,0.71875000f,0.37500000f,-0.59375000f,-0.06250000f,-0.64062500f,-0.70312500f,0.40625000f,-0.12500000f,0.98437500f,0.03125000f,-0.93750000f,-0.23437500f,-0.20312500f,0.34375000f,0.10937500f,0.43750000f,-0.34375000f,-0.26562500f,-0.75000000f,0.48437500f,0.01562500f,0.81250000f,0.62500000f,0.31250000f,-0.60937500f,-0.40625000f,-0.87500000f,-0.87500000f,-0.42187500f,-0.70312500f,-0.89062500f,0.50000000f,-0.21875000f,0.50000000f,-0.87500000f,-0.82812500f,-0.31250000f,0.71875000f,0.90625000f,0.17187500f,0.45312500f,-0.67187500f,-0.54687500f,-0.64062500f,0.79687500f,-0.71875000f,0.73437500f,0.45312500f,-0.32812500f,-0.67187500f,0.98437500f,-0.85937500f,-0.01562500f,0.75000000f,-0.40625000f,-0.84375000f,0.04687500f,0.70312500f,0.45312500f,-0.89062500f,-0.54687500f,-0.17187500f,-0.59375000f,0.85937500f,-0.31250000f,0.46875000f,-0.29687500f,0.26562500f,-0.06250000f,-0.70312500f,0.79687500f,0.62500000f,-0.84375000f,0.07812500f,0.96875000f,0.59375000f,-0.65625000f,0.26562500f,0.01562500f,0.23437500f,-0.50000000f,-0.32812500f,-0.78125000f,-0.59375000f,0.76562500f,-0.60937500f,0.10937500f,0.35937500f,-0.62500000f,0.17187500f,0.67187500f,-0.10937500f,0.25000000f,0.21875000f,0.82812500f,0.84375000f,0.92187500f,0.42187500f,-0.57812500f,0.39062500f,0.78125000f,-0.71875000f,0.32812500f,0.64062500f,-0.64062500f,-0.59375000f,0.48437500f,0.82812500f,-0.87500000f,0.40625000f,0.37500000f,-0.57812500f,0.12500000f,-0.10937500f,-0.03125000f,-0.68750000f,-0.70312500f,0.48437500f,0.14062500f,-0.78125000f,0.60937500f,0.23437500f,0.79687500f,0.14062500f,-0.68750000f,0.95312500f,0.14062500f,0.01562500f,-0.84375000f,-0.76562500f,-0.15625000f,-0.23437500f,0.59375000f,-0.14062500f,-0.75000000f,0.25000000f,0.04687500f,-0.28125000f,-0.03125000f,0.75000000f,-0.34375000f,-0.42187500f,-0.34375000f,-0.20312500f,0.17187500f,0.64062500f,-0.43750000f,0.79687500f,-0.25000000f,-0.03125000f,-0.56250000f,0.23437500f,0.32812500f,-0.03125000f,-0.01562500f,0.87500000f,-1.00000000f,-0.54687500f,-0.43750000f,0.07812500f,-0.82812500f,-0.48437500f,-0.82812500f,0.04687500f,-0.76562500f,-0.45312500f,0.65625000f,0.10937500f,-0.20312500f,0.21875000f,0.32812500f,0.96875000f,0.04687500f,0.87500000f,-0.35937500f,0.31250000f,-0.85937500f,0.29687500f,0.56250000f,-0.17187500f,0.76562500f,0.09375000f,0.09375000f,0.75000000f,0.45312500f,0.64062500f,-0.04687500f,-0.90625000f,0.87500000f,0.20312500f,-0.12500000f,0.87500000f,-0.20312500f,0.48437500f,0.35937500f,0.32812500f,0.03125000f,0.76562500f,-0.57812500f,-0.59375000f,0.82812500f,0.51562500f,-0.68750000f,-0.62500000f,-0.31250000f,-0.35937500f,0.95312500f,-0.40625000f,-0.03125000f,-0.96875000f,-1.00000000f,0.01562500f,0.09375000f,0.84375000f,-0.87500000f,-0.81250000f,0.31250000f,-0.51562500f,-0.51562500f,0.54687500f,-0.23437500f,0.17187500f,-0.04687500f,0.56250000f,-0.32812500f,-0.89062500f,0.10937500f,0.43750000f,-0.23437500f,-0.67187500f,-0.78125000f,-0.60937500f,-0.23437500f,0.31250000f,-0.95312500f,0.98437500f,-0.96875000f,0.75000000f,0.70312500f,0.70312500f,-0.96875000f,-0.14062500f,0.93750000f,0.48437500f,-0.82812500f,0.84375000f,0.84375000f,-0.06250000f,0.42187500f,-0.01562500f,0.23437500f,-0.84375000f,1.00000000f,-0.84375000f,0.57812500f,-0.54687500f,0.17187500f,0.73437500f,0.87500000f,-0.45312500f,-0.04687500f,-0.39062500f,0.60937500f,0.34375000f,0.76562500f,-0.62500000f,0.43750000f,0.96875000f,0.84375000f,-0.62500000f,0.51562500f,-0.21875000f,0.65625000f,-0.59375000f,-0.18750000f,0.90625000f,0.45312500f,0.89062500f,0.04687500f,-0.17187500f,-0.28125000f,0.14062500f,0.29687500f,-0.46875000f,-0.43750000f,0.57812500f,-0.96875000f,0.28125000f,-0.20312500f,-0.62500000f,-0.68750000f,0.31250000f,0.39062500f,0.98437500f,0.57812500f,-0.57812500f,-0.78125000f,0.42187500f,0.81250000f,-0.95312500f,-0.25000000f,-0.50000000f,-0.18750000f,-0.39062500f,-0.40625000f,-0.29687500f,-0.70312500f,0.84375000f,0.40625000f,-0.06250000f,0.60937500f,-0.12500000f,-0.20312500f,0.84375000f,-0.53125000f,0.85937500f,-0.96875000f,0.84375000f,-0.03125000f,0.29687500f,-0.53125000f,-0.40625000f,0.92187500f,-0.48437500f,0.07812500f,0.98437500f,0.76562500f,0.79687500f,-0.81250000f,0.54687500f,0.01562500f,0.03125000f,0.34375000f,0.06250000f,-0.73437500f,0.01562500f,0.09375000f,-0.92187500f,-0.35937500f,-0.64062500f,-0.64062500f,0.10937500f,-0.82812500f,0.39062500f,-0.20312500f,-0.20312500f,0.15625000f,0.09375000f,-0.70312500f,0.26562500f,-0.28125000f,-0.46875000f,0.40625000f,0.64062500f,0.67187500f,0.12500000f,-0.68750000f,0.50000000f,-0.50000000f,0.79687500f,-0.15625000f,-0.26562500f,0.73437500f,0.92187500f,-0.48437500f,0.15625000f,-0.93750000f,-0.21875000f,0.95312500f,-0.37500000f,-0.45312500f,0.78125000f,0.78125000f,-0.70312500f,0.48437500f,-0.75000000f,0.89062500f,-0.14062500f,-0.23437500f,-0.17187500f,0.54687500f,-0.81250000f,0.01562500f,-0.78125000f,0.26562500f,-0.85937500f,-0.75000000f,0.40625000f,-0.93750000f,0.79687500f,-0.09375000f,-0.35937500f,-0.43750000f,-0.15625000f,0.50000000f,-0.06250000f,-0.59375000f,0.85937500f,0.39062500f,-0.06250000f,0.37500000f,-0.64062500f,-0.68750000f,0.31250000f,0.96875000f,0.56250000f,0.25000000f,0.48437500f,-0.14062500f,0.20312500f,1.00000000f,-0.67187500f,-0.46875000f,0.17187500f,0.09375000f,0.10937500f,0.85937500f,-0.10937500f,-0.71875000f,-0.51562500f,0.85937500f,-0.26562500f,0.71875000f,0.81250000f,-0.93750000f,-0.50000000f,-0.54687500f,0.84375000f,-0.60937500f,-0.62500000f,0.51562500f,0.93750000f,-0.26562500f,0.15625000f,0.56250000f,0.71875000f,0.51562500f,-0.84375000f,-0.50000000f,-0.28125000f,-0.81250000f,-0.34375000f,-0.09375000f,-0.03125000f,-0.25000000f,0.07812500f,-0.07812500f,0.78125000f,0.90625000f,-0.14062500f,0.17187500f,-0.95312500f,-0.21875000f,0.67187500f,-0.96875000f,0.25000000f,1.00000000f,0.07812500f,0.15625000f,-0.06250000f,0.71875000f,-0.87500000f,-0.12500000f,0.07812500f,-0.35937500f,-0.39062500f,0.17187500f,-0.57812500f,-0.46875000f,0.76562500f,-0.46875000f,0.57812500f,-0.65625000f,0.00000000f,-0.40625000f,0.34375000f,-0.48437500f,0.12500000f,0.75000000f,-0.04687500f,0.23437500f,0.42187500f,0.50000000f,0.67187500f,0.68750000f,0.73437500f,0.95312500f,-0.71875000f,-0.10937500f,-0.87500000f,-0.42187500f,0.48437500f,0.60937500f,-0.12500000f,-0.67187500f,-0.31250000f,-0.65625000f,-0.95312500f,-0.51562500f,0.10937500f,0.81250000f,0.54687500f,0.59375000f,-0.48437500f,-0.81250000f,-0.54687500f,0.07812500f,-0.82812500f,0.07812500f,1.00000000f,-0.67187500f,0.20312500f,0.59375000f,-0.18750000f,-0.50000000f,-0.46875000f,0.25000000f,0.20312500f,0.37500000f,-0.85937500f,0.46875000f,-0.79687500f,0.57812500f,0.71875000f,-0.07812500f,-0.79687500f,-0.29687500f,0.78125000f,0.64062500f,-0.15625000f,-0.32812500f,-0.62500000f,0.40625000f,-0.71875000f,-0.46875000f,0.14062500f,0.20312500f,-0.78125000f,0.43750000f,0.01562500f,0.60937500f,-0.82812500f,-0.50000000f,-0.34375000f,0.26562500f,-0.84375000f,-0.32812500f,0.01562500f,-0.76562500f,-0.84375000f,-0.25000000f,-0.34375000f,-0.51562500f,0.57812500f,0.14062500f,-0.26562500f,-0.43750000f,-0.31250000f,0.73437500f,0.62500000f,0.76562500f,-0.53125000f,-0.29687500f,-0.82812500f,-0.60937500f,-0.03125000f,-0.32812500f,-0.76562500f,0.09375000f,0.76562500f,0.92187500f,0.35937500f,0.29687500f,0.75000000f,-0.98437500f,-0.10937500f,-0.73437500f,0.10937500f,-0.53125000f,-0.56250000f,0.35937500f,0.71875000f,-0.26562500f,-0.68750000f,0.28125000f,0.15625000f,0.10937500f,-0.62500000f,0.65625000f,-0.21875000f,0.81250000f,-0.10937500f,0.25000000f,0.68750000f,-0.81250000f,-0.64062500f,0.35937500f,0.01562500f,-0.43750000f,0.76562500f,0.34375000f,-0.57812500f,0.40625000f,0.56250000f,-0.65625000f,0.98437500f,-0.68750000f,0.56250000f,0.46875000f,0.90625000f,0.06250000f,0.68750000f,0.75000000f,0.26562500f,0.14062500f,0.34375000f,-0.81250000f,0.25000000f,0.76562500f,0.85937500f,0.31250000f,-0.34375000f,0.95312500f,-0.95312500f,-0.09375000f,-0.78125000f,-0.89062500f,0.17187500f,-0.57812500f,0.82812500f,0.25000000f,-0.98437500f,0.68750000f,0.92187500f,-0.15625000f,0.46875000f,-0.18750000f,-0.93750000f,0.42187500f,0.85937500f,0.01562500f,0.78125000f,0.60937500f,-0.78125000f,-0.28125000f,-0.89062500f,0.56250000f,0.34375000f,0.70312500f,0.89062500f,0.25000000f,0.21875000f,0.14062500f,-1.00000000f,-0.17187500f,0.25000000f,-0.21875000f,-0.89062500f,0.79687500f,-0.82812500f,0.76562500f,0.42187500f,0.73437500f,0.51562500f,-0.17187500f,-0.01562500f,-0.20312500f,0.01562500f,-0.04687500f,0.03125000f,0.42187500f,0.29687500f,-0.25000000f,0.31250000f,0.04687500f,-0.23437500f,0.14062500f,0.26562500f,-0.68750000f,-0.60937500f,-0.82812500f,0.18750000f,0.14062500f,0.53125000f,-0.42187500f,-0.01562500f,-0.18750000f,-0.26562500f,0.62500000f,0.26562500f,0.98437500f,0.93750000f,0.06250000f,0.81250000f,0.15625000f,-0.21875000f,-0.78125000f,0.18750000f,-0.17187500f,0.21875000f,-0.28125000f,-0.06250000f,0.06250000f,0.46875000f,-0.82812500f,0.96875000f,-0.14062500f,0.18750000f,0.84375000f,0.01562500f,-0.81250000f,0.26562500f,0.10937500f,-0.71875000f,0.45312500f,0.67187500f,0.67187500f,0.48437500f,-0.17187500f,0.98437500f,-0.17187500f,-0.35937500f,-0.50000000f,0.70312500f,-0.18750000f,0.89062500f,-0.50000000f,0.89062500f,0.84375000f,-0.03125000f,0.40625000f,-0.68750000f,-0.10937500f,-0.68750000f,0.62500000f,0.35937500f,0.92187500f,-0.68750000f,-0.17187500f,0.68750000f,0.17187500f,0.57812500f,0.34375000f,0.96875000f,-0.43750000f,0.50000000f,0.89062500f,0.75000000f,0.20312500f,-0.14062500f,-0.84375000f,-0.07812500f,-0.89062500f,0.45312500f,-0.53125000f,0.82812500f,-0.60937500f,-0.34375000f,-0.37500000f,0.12500000f,0.45312500f,-0.76562500f,-0.17187500f,0.78125000f,0.12500000f,0.76562500f,0.29687500f,0.42187500f,0.57812500f,-0.12500000f,-0.09375000f,0.29687500f,-0.35937500f,-0.98437500f,-0.54687500f,-1.00000000f,-0.85937500f,0.56250000f,0.20312500f,-0.82812500f,-0.26562500f,0.20312500f,0.71875000f,-0.50000000f,-0.32812500f,0.92187500f,0.20312500f,-0.81250000f,-0.59375000f,0.98437500f,0.78125000f,0.82812500f,-0.98437500f,-0.21875000f,0.10937500f,-0.37500000f,0.21875000f,0.45312500f,-0.95312500f,0.46875000f,0.64062500f,-0.62500000f,0.50000000f,-0.01562500f,-0.01562500f,-0.90625000f,-0.68750000f,0.85937500f,0.43750000f,-0.34375000f,-0.90625000f,0.68750000f,-0.76562500f,-0.95312500f,0.73437500f,-0.06250000f,-0.96875000f,0.79687500f,-0.68750000f,0.56250000f,0.12500000f,0.53125000f,-0.42187500f,-0.18750000f,-0.10937500f,-0.82812500f,0.85937500f,-0.37500000f,-0.73437500f,0.28125000f,-0.60937500f,-0.04687500f,0.45312500f,0.60937500f,0.79687500f,0.07812500f,-0.50000000f,0.90625000f,0.10937500f,-0.65625000f,-0.10937500f,0.75000000f,-0.64062500f,-0.18750000f,0.64062500f,0.18750000f,-0.64062500f,0.35937500f,0.85937500f,0.12500000f,0.70312500f,-0.56250000f,-0.04687500f,-0.70312500f,-0.43750000f,0.71875000f,0.85937500f,-0.96875000f,-0.96875000f,-0.71875000f,-0.64062500f,-0.17187500f,-0.28125000f,0.45312500f,0.03125000f,-0.17187500f,0.39062500f,-0.17187500f,0.43750000f,0.20312500f,-0.40625000f,-0.79687500f,0.21875000f,-0.82812500f,-0.81250000f,-0.53125000f,-0.64062500f,0.51562500f,-0.14062500f,0.67187500f,-0.60937500f,0.62500000f,-0.14062500f,-0.92187500f,-0.75000000f,-0.18750000f,0.48437500f,-0.62500000f,0.01562500f,-0.90625000f,0.03125000f,-0.87500000f,-0.76562500f,0.00000000f,-0.95312500f,0.00000000f,-0.93750000f,0.12500000f,-0.20312500f,-0.81250000f,0.57812500f,-0.21875000f,-0.34375000f,-0.87500000f,-0.14062500f,-0.76562500f,0.95312500f,0.25000000f,-0.67187500f,0.17187500f,0.17187500f,-0.43750000f,0.68750000f,0.35937500f,0.75000000f,0.10937500f,-0.07812500f,0.95312500f,0.45312500f,0.87500000f,0.71875000f,-0.03125000f,-0.43750000f,0.01562500f,-0.89062500f,-0.14062500f,0.59375000f,0.53125000f,0.46875000f,0.20312500f,0.01562500f,0.92187500f,0.96875000f,0.98437500f,0.89062500f,0.62500000f,0.42187500f,0.78125000f,0.79687500f,-0.37500000f,0.50000000f,-0.37500000f,-0.14062500f,0.25000000f,0.82812500f,-0.34375000f,0.85937500f,0.65625000f,-0.25000000f,0.09375000f,0.54687500f,-0.75000000f,-0.92187500f,0.12500000f,-0.82812500f,-0.39062500f,0.92187500f,0.07812500f,0.42187500f,0.82812500f,-0.09375000f,0.01562500f,-0.76562500f,0.09375000f,-0.65625000f,0.42187500f,-0.18750000f,0.59375000f,-0.75000000f,-1.00000000f,-0.09375000f,-0.71875000f,-0.96875000f,-0.01562500f,0.71875000f,-1.00000000f,0.03125000f,-0.01562500f,-0.45312500f,0.68750000f,0.95312500f,-0.90625000f,0.82812500f,0.26562500f,-0.15625000f,0.35937500f,-0.70312500f,0.01562500f,1.00000000f,0.90625000f,0.87500000f,0.39062500f,0.67187500f,-0.96875000f,0.56250000f,-0.53125000f,0.06250000f,0.85937500f,0.48437500f,-0.39062500f,-0.25000000f,0.81250000f,-0.31250000f,0.62500000f,-0.48437500f,0.50000000f,0.10937500f,0.15625000f,0.82812500f,0.95312500f,0.40625000f,0.96875000f,-0.17187500f,-0.79687500f,0.95312500f,-0.07812500f,0.26562500f,-0.39062500f,0.78125000f,0.57812500f,-0.53125000f,-0.15625000f,-0.57812500f,-0.45312500f,-0.59375000f,-0.14062500f,-0.65625000f,0.57812500f,-0.68750000f,-0.07812500f,0.37500000f,-0.85937500f,0.54687500f,-0.20312500f,-0.95312500f,-0.14062500f,0.81250000f,-0.12500000f,0.20312500f,0.81250000f,0.65625000f,-1.00000000f,0.85937500f,-0.32812500f,0.35937500f,-0.56250000f,0.82812500f,0.65625000f,-0.84375000f,-0.17187500f,-0.03125000f,-0.18750000f,0.56250000f,-0.32812500f,-0.85937500f,0.26562500f,-0.01562500f,0.90625000f,0.48437500f,0.21875000f,0.85937500f,-0.60937500f,-0.28125000f,0.70312500f,0.68750000f,-0.65625000f,0.70312500f,-0.26562500f,-0.48437500f,0.62500000f,0.85937500f,-0.56250000f,-0.59375000f,-0.46875000f,0.92187500f,0.29687500f,-0.53125000f,-0.48437500f,0.45312500f,0.25000000f,-0.87500000f,-0.15625000f,-0.48437500f,-0.04687500f,-0.78125000f,0.29687500f,-0.84375000f,-0.17187500f,-0.78125000f,0.50000000f,0.46875000f,-0.32812500f,-0.35937500f,0.48437500f,-0.12500000f,-0.76562500f,0.67187500f,0.85937500f,0.18750000f,0.42187500f,1.00000000f,0.75000000f,0.53125000f,0.98437500f,-0.73437500f,0.17187500f,-0.45312500f,-0.65625000f,-0.03125000f,0.00000000f,0.96875000f,0.92187500f,0.29687500f,-0.96875000f,-0.95312500f,0.23437500f,0.73437500f,-0.54687500f,0.78125000f,-0.85937500f,-0.53125000f,-0.64062500f,0.00000000f,0.73437500f,-0.03125000f,0.85937500f,0.10937500f,-0.26562500f,-0.70312500f,0.04687500f,-0.03125000f,0.76562500f,-0.04687500f,-0.81250000f,-0.71875000f,0.10937500f,-0.84375000f,0.39062500f,0.21875000f,0.43750000f,-0.40625000f,1.00000000f,0.92187500f,-0.21875000f,-0.85937500f,-0.32812500f,0.34375000f,0.84375000f,-0.45312500f,-0.31250000f,-0.56250000f,-0.90625000f,0.87500000f,-0.43750000f,0.48437500f,0.62500000f,-0.06250000f,-0.57812500f,0.28125000f,-0.45312500f,0.54687500f,0.01562500f,-0.20312500f,-0.92187500f,0.76562500f,0.89062500f,-0.90625000f,0.87500000f,-0.96875000f,-0.15625000f,0.90625000f,0.43750000f,-0.07812500f,-0.70312500f,-0.35937500f,-0.53125000f,0.14062500f,0.92187500f,-0.18750000f,-0.15625000f,0.73437500f,-0.59375000f,-0.75000000f,0.76562500f,-0.01562500f,0.96875000f,0.53125000f,0.64062500f,0.82812500f,0.57812500f,-0.34375000f,-0.65625000f,0.39062500f,0.96875000f,-0.54687500f,-0.09375000f,0.76562500f,-0.84375000f,0.51562500f,0.28125000f,-0.57812500f,0.54687500f,0.32812500f,-0.65625000f,0.10937500f,0.14062500f,0.32812500f,0.53125000f,0.84375000f,0.04687500f,-0.23437500f,-0.76562500f,-0.48437500f,0.53125000f,-0.95312500f,-0.34375000f,0.70312500f,0.67187500f,-0.31250000f,-0.23437500f,0.39062500f,-0.50000000f,0.73437500f,0.09375000f,-0.57812500f,0.76562500f,0.96875000f,-0.60937500f,0.42187500f,0.25000000f,0.60937500f,0.64062500f,0.51562500f,-0.85937500f,-0.98437500f,0.75000000f,-0.45312500f,-0.93750000f,-0.62500000f,0.95312500f,-0.59375000f,0.51562500f,-0.14062500f,-0.68750000f,0.79687500f,0.28125000f,-0.01562500f,-0.28125000f,-0.78125000f,0.15625000f,-0.85937500f,0.76562500f,0.07812500f,-0.50000000f,-0.60937500f,-0.81250000f,0.56250000f,0.12500000f,-0.14062500f,-0.78125000f,0.35937500f,-0.32812500f,-0.84375000f,-0.37500000f,0.98437500f,-0.23437500f,0.06250000f,-0.82812500f,0.46875000f,0.46875000f,-0.60937500f,0.54687500f,-0.93750000f,-0.25000000f,0.93750000f,0.32812500f,0.92187500f,0.12500000f,0.39062500f,0.00000000f,-0.09375000f,-0.68750000f,-0.28125000f,0.95312500f,-0.06250000f,-0.68750000f,0.62500000f,-0.06250000f,-0.31250000f,-0.56250000f,-0.12500000f,0.56250000f,0.03125000f,-0.20312500f,-0.31250000f,0.37500000f,-0.04687500f,0.53125000f,0.82812500f,0.43750000f,0.53125000f,-0.12500000f,-0.29687500f,-0.37500000f,-0.26562500f,-0.10937500f,-0.39062500f,-0.18750000f,0.65625000f,-0.12500000f,0.37500000f,0.78125000f,-0.45312500f,-0.48437500f,-0.10937500f,0.06250000f,0.73437500f,0.89062500f,0.42187500f,0.40625000f,0.81250000f,-0.90625000f,-0.70312500f,0.20312500f,-0.70312500f,0.21875000f,-0.46875000f,0.85937500f,-0.90625000f,0.45312500f,-0.09375000f,0.87500000f,0.78125000f,-0.25000000f,0.21875000f,-0.15625000f,-0.01562500f,-0.67187500f,-0.04687500f,0.34375000f,-0.51562500f,0.95312500f,-0.64062500f,-0.26562500f,-0.51562500f,-0.92187500f,0.70312500f,-0.68750000f,-0.64062500f,-0.20312500f,-0.64062500f,-0.14062500f,0.42187500f,-0.23437500f,0.40625000f,-0.51562500f,0.40625000f,-0.45312500f,-0.53125000f,-0.35937500f,0.82812500f,-0.57812500f,0.56250000f,-0.07812500f,0.54687500f,0.15625000f,0.76562500f,-0.98437500f,-0.87500000f,0.87500000f,-0.89062500f,0.90625000f,0.56250000f,-0.35937500f,0.75000000f,0.95312500f,-0.95312500f,-0.32812500f,-0.48437500f,0.64062500f,0.23437500f,0.14062500f,-0.21875000f,-0.04687500f,-0.81250000f,0.21875000f,0.45312500f,-0.06250000f,-0.34375000f,-0.79687500f,0.67187500f,0.84375000f,0.40625000f,0.87500000f,0.68750000f,0.68750000f,0.07812500f,0.67187500f,-0.18750000f,-0.82812500f,-0.85937500f,-0.34375000f,0.81250000f,0.71875000f,-0.57812500f,-0.70312500f,0.68750000f,-0.03125000f,0.54687500f,-0.17187500f,0.15625000f,0.01562500f,-0.45312500f,-0.29687500f,-0.64062500f,0.06250000f,0.21875000f,0.45312500f,0.39062500f,0.51562500f,-0.67187500f,-0.42187500f,-0.82812500f,-0.89062500f,-0.51562500f,0.75000000f,0.82812500f,0.15625000f,-0.25000000f,-0.92187500f,0.25000000f,0.56250000f,-0.85937500f,0.18750000f,-0.06250000f,-1.00000000f,-0.82812500f,-0.89062500f,0.76562500f,-0.42187500f,-0.06250000f,-0.81250000f,0.34375000f,0.04687500f,0.50000000f,-0.15625000f,0.79687500f,0.10937500f,0.53125000f,0.78125000f,0.81250000f,0.20312500f,-1.00000000f,-0.53125000f,0.37500000f,0.34375000f,0.10937500f,0.79687500f,0.71875000f,0.35937500f,0.81250000f,-0.96875000f,-0.07812500f,-0.68750000f,-0.98437500f,0.43750000f,0.59375000f,0.25000000f,0.25000000f,-0.18750000f,-0.75000000f,-0.12500000f,0.28125000f,0.25000000f,-0.21875000f,0.15625000f,0.01562500f,-0.92187500f,-0.18750000f,-0.32812500f,-0.42187500f,0.48437500f,-0.40625000f,-0.29687500f,-0.75000000f,1.00000000f,0.20312500f,-0.25000000f,-0.32812500f,0.75000000f,0.03125000f,0.87500000f,-0.07812500f,0.23437500f,-0.37500000f,-0.34375000f,0.48437500f,0.29687500f,-0.14062500f,0.06250000f,0.84375000f,-0.12500000f,0.93750000f,0.06250000f,-0.96875000f,-0.42187500f,-1.00000000f,-1.00000000f,0.09375000f,0.93750000f,-0.76562500f,-0.48437500f,-0.15625000f,0.67187500f,0.28125000f,0.53125000f,0.59375000f,-0.73437500f,-0.68750000f,0.50000000f,-0.32812500f,-0.06250000f,0.70312500f,-0.45312500f,-0.60937500f,-0.56250000f,-0.18750000f,-0.78125000f,-0.06250000f,-0.73437500f,-0.25000000f,0.15625000f,0.37500000f,-0.10937500f,-0.57812500f,-0.57812500f,-0.71875000f,0.32812500f,-0.98437500f,-0.70312500f,-0.76562500f,-0.18750000f,-0.96875000f,0.28125000f,-0.35937500f,0.25000000f,-0.96875000f,0.71875000f,-0.70312500f,-0.06250000f,0.70312500f,0.37500000f,-0.03125000f,0.29687500f,0.26562500f,-0.68750000f,-0.76562500f,-0.90625000f,0.14062500f,0.06250000f,-0.84375000f,0.37500000f,0.37500000f,-0.98437500f,0.01562500f,0.50000000f,-0.62500000f,-0.62500000f,0.37500000f,-0.79687500f,0.79687500f,0.70312500f,-0.09375000f,0.50000000f,-0.23437500f,0.12500000f,-0.93750000f,-0.31250000f,0.79687500f,-0.48437500f,0.59375000f,0.54687500f,0.95312500f,0.51562500f,0.57812500f,0.92187500f,0.15625000f,-0.79687500f,-0.81250000f,0.46875000f,-0.70312500f,-0.56250000f,-0.84375000f,-0.92187500f,-0.12500000f,0.00000000f,-0.78125000f,0.34375000f,-0.82812500f,-0.26562500f,0.93750000f,-0.95312500f,-0.42187500f,0.95312500f,0.35937500f,-0.87500000f,0.29687500f,0.51562500f,0.25000000f,0.14062500f,-0.71875000f,-0.62500000f,-0.35937500f,0.29687500f,-0.56250000f,-0.34375000f,0.81250000f,-0.90625000f,-0.75000000f,0.53125000f,-0.10937500f,0.92187500f,0.57812500f,0.29687500f,0.39062500f,0.18750000f,-0.84375000f,0.65625000f,0.93750000f,-0.71875000f,-0.43750000f,-0.42187500f,0.25000000f,0.15625000f,-0.96875000f,-0.93750000f,-0.12500000f,-0.40625000f,0.53125000f,0.26562500f,-0.21875000f,0.51562500f,0.37500000f,-0.57812500f,0.26562500f,-0.17187500f,0.35937500f,0.79687500f,-0.75000000f,-0.07812500f,0.21875000f,-0.98437500f,-0.03125000f,-0.26562500f,0.31250000f,-0.03125000f,-0.40625000f,-0.76562500f,-0.37500000f,0.81250000f,-0.17187500f,0.29687500f,0.62500000f,0.40625000f,0.20312500f,0.40625000f,-0.79687500f,-0.53125000f,-0.71875000f,-0.70312500f,-0.23437500f,0.95312500f,0.84375000f,0.29687500f,0.40625000f,0.96875000f,0.93750000f,-0.03125000f,0.01562500f,0.60937500f,-0.28125000f,-0.85937500f,0.29687500f,0.68750000f,0.73437500f,0.56250000f,-0.67187500f,0.50000000f,-0.04687500f,0.09375000f,-0.48437500f,-0.43750000f,0.17187500f,0.57812500f,0.25000000f,-0.15625000f,0.32812500f,-0.84375000f,-0.28125000f,0.81250000f,0.65625000f,-0.65625000f,-0.70312500f,0.67187500f,-0.48437500f,0.65625000f,1.00000000f,-0.15625000f,-0.23437500f,0.23437500f,0.25000000f,-0.53125000f,0.48437500f,-0.73437500f,0.17187500f,0.28125000f,0.29687500f,0.12500000f,0.09375000f,0.31250000f,0.31250000f,-0.18750000f,-0.25000000f,-0.42187500f,-0.45312500f,-0.40625000f,0.82812500f,-0.90625000f,0.73437500f,0.56250000f,-0.09375000f,0.34375000f,-0.26562500f,0.29687500f,0.50000000f,0.46875000f,0.23437500f,0.43750000f,0.37500000f,-0.26562500f,0.60937500f,0.53125000f,0.53125000f,0.25000000f,-0.45312500f,0.51562500f,-0.64062500f,0.79687500f,-0.12500000f,0.93750000f,-0.45312500f,0.92187500f,0.64062500f,0.37500000f,0.06250000f,0.23437500f,-0.45312500f,0.50000000f,-0.09375000f,-0.79687500f,-0.95312500f,0.51562500f,-0.84375000f,-0.14062500f,0.93750000f,-0.82812500f,-0.62500000f,0.87500000f,0.03125000f,-0.53125000f,-0.09375000f,-0.96875000f,-0.28125000f,0.90625000f,0.56250000f,-0.35937500f,-0.37500000f,-0.29687500f,0.25000000f,0.71875000f,-0.75000000f,0.14062500f,-0.34375000f,0.12500000f,-0.01562500f,0.73437500f,-0.51562500f,-0.10937500f,-0.14062500f,0.82812500f,-0.89062500f,0.15625000f,-0.90625000f,-0.31250000f,-0.20312500f,-0.28125000f,-0.98437500f,-0.71875000f,-0.51562500f,-0.07812500f,-0.32812500f,0.76562500f,-0.37500000f,0.79687500f,-0.35937500f,0.39062500f,0.70312500f,-0.14062500f,0.65625000f,0.18750000f,0.04687500f,-0.54687500f,0.82812500f,-0.35937500f,0.43750000f,0.59375000f,-0.98437500f,0.60937500f,-0.60937500f,0.51562500f,-0.06250000f,-0.68750000f,0.50000000f,-0.04687500f,0.62500000f,0.45312500f,0.43750000f,0.70312500f,0.75000000f,-0.06250000f,-0.89062500f,0.85937500f,0.84375000f,-0.07812500f,0.67187500f,0.59375000f,0.59375000f,-1.00000000f,0.46875000f,0.65625000f,0.07812500f,0.43750000f,0.09375000f,0.82812500f,1.00000000f,0.12500000f,0.65625000f,-0.42187500f,-0.31250000f,-0.59375000f,0.51562500f,0.53125000f,0.23437500f,0.85937500f,-0.34375000f,-0.12500000f,-0.28125000f,0.78125000f,0.57812500f,1.00000000f,-0.53125000f,-0.56250000f,-0.64062500f,0.46875000f,-1.00000000f,-1.00000000f,0.87500000f,-0.56250000f,-0.84375000f,0.18750000f,0.18750000f,0.84375000f,0.15625000f,0.67187500f,0.29687500f,0.34375000f,0.73437500f,-0.90625000f,0.75000000f,0.95312500f,-0.39062500f,-0.75000000f,-0.43750000f,0.75000000f,0.42187500f,-0.53125000f,0.59375000f,-0.75000000f,-0.96875000f,0.85937500f,0.09375000f,0.82812500f,-0.45312500f,0.23437500f,-0.71875000f,0.29687500f,0.96875000f,-0.23437500f,0.12500000f,0.98437500f,-0.54687500f,-0.59375000f,-0.76562500f,-0.34375000f,-0.45312500f,0.67187500f,0.35937500f,0.82812500f,-0.17187500f,-0.71875000f,-1.00000000f,-0.65625000f,0.93750000f,0.82812500f,0.92187500f,-0.32812500f,0.62500000f,0.21875000f,-0.70312500f,0.45312500f,-0.28125000f,-0.31250000f,0.98437500f,-0.40625000f,-0.09375000f,-0.53125000f,0.62500000f,0.50000000f,0.32812500f,0.09375000f,-0.20312500f,0.29687500f,-0.43750000f,-0.70312500f,-0.92187500f,-0.60937500f,0.23437500f,0.57812500f,-0.92187500f,-0.64062500f,0.04687500f,0.92187500f,0.46875000f,0.12500000f,-0.37500000f,-0.04687500f,0.01562500f,0.93750000f,0.06250000f,-0.09375000f,-0.67187500f,1.00000000f,0.31250000f,0.43750000f,0.00000000f,-0.51562500f,0.60937500f,0.71875000f,0.26562500f,0.62500000f,0.81250000f,0.82812500f,0.95312500f,0.37500000f,0.39062500f,-0.67187500f,0.43750000f,-0.07812500f,0.48437500f,-0.34375000f,-0.15625000f,0.60937500f,0.67187500f,-0.68750000f,-0.10937500f,-0.46875000f,-0.31250000f,0.23437500f,-0.85937500f,-0.57812500f,0.56250000f,0.82812500f,-0.40625000f,0.71875000f,0.21875000f,-0.01562500f,-0.01562500f,0.04687500f,-0.57812500f,0.81250000f,0.37500000f,-0.45312500f,0.00000000f,-0.34375000f,-0.64062500f,0.10937500f,-0.90625000f,0.71875000f,-0.03125000f,-0.75000000f,-0.90625000f,-0.70312500f,0.70312500f,-0.40625000f,0.29687500f,-0.54687500f,0.65625000f,-0.42187500f,0.96875000f,0.78125000f,-0.89062500f,-0.92187500f,0.85937500f,0.59375000f,0.78125000f,-0.20312500f,-0.68750000f,-0.75000000f,0.06250000f,-0.57812500f,-0.98437500f,0.50000000f,0.35937500f,-0.43750000f,-0.92187500f,0.82812500f,0.35937500f,-0.59375000f,-0.46875000f,-0.51562500f,-0.42187500f,0.39062500f,-0.35937500f,-0.39062500f,0.23437500f,0.57812500f,-0.29687500f,-0.81250000f,-0.82812500f,-0.79687500f,-0.20312500f,-0.76562500f,0.79687500f,0.62500000f,-0.60937500f,0.96875000f,-0.43750000f,0.70312500f,-0.65625000f,-0.65625000f,-0.09375000f,-0.65625000f,0.00000000f,0.40625000f,-0.84375000f,-0.92187500f,0.04687500f,0.89062500f,-0.17187500f,-0.81250000f,-0.10937500f,0.14062500f,-0.85937500f,-1.00000000f,0.70312500f,-0.25000000f,-0.70312500f,-0.31250000f,0.82812500f,0.82812500f,0.71875000f,0.43750000f,-0.48437500f,0.34375000f,-0.25000000f,-0.28125000f,0.53125000f,-0.12500000f,0.56250000f,0.82812500f,0.01562500f,-0.60937500f,0.57812500f,0.93750000f,-0.73437500f,0.31250000f,0.79687500f,-0.54687500f,0.14062500f,0.42187500f,0.34375000f,0.31250000f,-0.39062500f,-0.10937500f,0.85937500f,-0.56250000f,-0.84375000f,-0.40625000f,-0.26562500f,0.28125000f,-0.93750000f,-0.09375000f,0.62500000f,-0.29687500f,-0.25000000f,-0.18750000f,0.28125000f,-0.51562500f,-0.43750000f,0.39062500f,-0.18750000f,-0.82812500f,0.15625000f,-0.82812500f,0.89062500f,-0.29687500f,-0.75000000f,-0.45312500f,0.59375000f,-0.78125000f,0.14062500f,-0.53125000f,0.07812500f,-0.98437500f,0.60937500f,0.21875000f,-0.68750000f,-0.35937500f,-0.20312500f,0.48437500f,-0.56250000f,0.76562500f,0.48437500f,-0.78125000f,0.03125000f,0.65625000f,-0.96875000f,0.54687500f,0.60937500f,0.78125000f,0.42187500f,-0.56250000f,-0.34375000f,0.64062500f,-1.00000000f,0.17187500f,0.71875000f,-0.68750000f,-0.96875000f,0.45312500f,-0.60937500f,0.31250000f,0.92187500f,0.98437500f,0.25000000f,-0.37500000f,0.21875000f,0.73437500f,-0.04687500f,-0.18750000f,-0.35937500f,-0.59375000f,0.98437500f,-0.29687500f,0.45312500f,-0.26562500f,0.45312500f,0.70312500f,-0.75000000f,0.37500000f,-0.03125000f,-0.03125000f,-0.64062500f,-0.71875000f,0.15625000f,-0.84375000f,-0.62500000f,-0.81250000f,0.70312500f,0.31250000f,0.04687500f,0.67187500f,0.09375000f,0.53125000f,0.87500000f,-0.54687500f,0.87500000f,0.81250000f,0.84375000f,-0.50000000f,0.65625000f,-0.26562500f,0.37500000f,0.42187500f,-0.53125000f,0.60937500f,0.64062500f,0.85937500f,0.18750000f,0.87500000f,-0.76562500f,-0.67187500f,0.51562500f,0.75000000f,-0.78125000f,0.04687500f,-0.50000000f,0.56250000f,0.42187500f,0.48437500f,-0.81250000f,-0.45312500f,-0.51562500f,-0.35937500f,-0.70312500f,0.04687500f,0.73437500f,0.71875000f,-0.54687500f,-0.98437500f,-0.25000000f,0.35937500f,0.00000000f,0.43750000f,0.00000000f,-0.01562500f,-0.12500000f,0.73437500f,-0.93750000f,0.71875000f,0.59375000f,-1.00000000f,-0.75000000f,0.26562500f,0.28125000f,-0.87500000f,0.18750000f,0.75000000f,0.40625000f,-0.67187500f,-0.31250000f,-0.46875000f,-0.59375000f,-0.42187500f,-0.35937500f,0.84375000f,-0.28125000f,0.34375000f,-0.45312500f,0.48437500f,-0.57812500f,-0.79687500f,-0.82812500f,0.92187500f,-0.56250000f,0.25000000f,-0.48437500f,0.96875000f,0.50000000f,0.56250000f,-0.57812500f,-0.78125000f,0.65625000f,-0.75000000f,-0.51562500f,0.79687500f,-0.60937500f,0.10937500f,-0.32812500f,0.10937500f,-0.71875000f,0.21875000f,0.67187500f,-0.50000000f,-0.28125000f,0.90625000f,0.57812500f,-0.81250000f,-0.68750000f,-0.75000000f,-0.29687500f,0.18750000f,-0.81250000f,-0.45312500f,-0.87500000f,0.85937500f,0.73437500f,-0.42187500f,-0.92187500f,0.50000000f,-0.59375000f,0.07812500f,-0.29687500f,0.65625000f,-0.23437500f,0.98437500f,-0.26562500f,0.62500000f,-0.43750000f,-0.85937500f,0.70312500f,0.07812500f,-0.31250000f,0.51562500f,-0.23437500f,0.82812500f,-0.65625000f,0.46875000f,0.67187500f,0.31250000f,-0.29687500f,-0.17187500f,-0.79687500f,-0.70312500f,0.65625000f,0.68750000f,0.96875000f,0.04687500f,-0.03125000f,0.79687500f,0.82812500f,0.98437500f,-0.67187500f,-0.54687500f,-0.51562500f,-0.67187500f,-0.78125000f,-0.93750000f,0.46875000f,0.46875000f,-0.29687500f,-0.96875000f,-0.84375000f,-0.98437500f,-0.57812500f,-0.85937500f,-0.68750000f,-0.84375000f,0.43750000f,0.46875000f,-0.50000000f,-0.98437500f,0.34375000f,-0.01562500f,-0.93750000f,-0.51562500f,-0.17187500f,0.10937500f,0.32812500f,-0.96875000f,-0.07812500f,0.56250000f,0.87500000f,-0.01562500f,-0.25000000f,-0.59375000f,-0.20312500f,0.23437500f,0.09375000f,0.75000000f,-0.68750000f,-0.42187500f,-1.00000000f,0.79687500f,0.25000000f,0.31250000f,0.01562500f,-0.93750000f,0.40625000f,-0.20312500f,-0.93750000f,-0.75000000f,-0.82812500f,-0.75000000f,-0.21875000f,0.17187500f,-0.85937500f,-0.64062500f,-0.09375000f,0.35937500f,0.06250000f,-0.84375000f,0.01562500f,0.21875000f,0.81250000f,-0.60937500f,-0.67187500f,-0.93750000f,0.71875000f,0.07812500f,0.01562500f,0.53125000f,0.18750000f,-0.98437500f,-0.07812500f,0.17187500f,0.90625000f,-0.21875000f,-0.15625000f,-0.70312500f,-0.89062500f,-0.67187500f,0.85937500f,-0.82812500f,0.29687500f,0.73437500f,-0.51562500f,0.87500000f,0.53125000f,0.68750000f,0.60937500f,-0.96875000f,-0.50000000f,0.56250000f,-0.82812500f,0.31250000f,-0.48437500f,0.93750000f,0.12500000f,0.03125000f,0.28125000f,-0.60937500f,-0.20312500f,0.26562500f,-0.50000000f,0.06250000f,0.40625000f,-0.53125000f,0.29687500f,0.92187500f,0.60937500f,-0.75000000f,-0.64062500f,-0.26562500f,0.45312500f,0.03125000f,-0.29687500f,0.34375000f,-0.07812500f,-0.68750000f,0.60937500f,-0.73437500f,-0.45312500f,0.89062500f,-0.39062500f,-0.70312500f,-0.90625000f,-0.92187500f,-0.87500000f,0.39062500f,0.73437500f,0.01562500f,-0.07812500f,-0.51562500f,0.79687500f,0.32812500f,0.20312500f,-0.95312500f,-0.26562500f,-0.31250000f,1.00000000f,-0.93750000f,-0.32812500f,-0.26562500f,0.51562500f,0.76562500f,-0.65625000f,0.51562500f,0.06250000f,-0.54687500f,-0.12500000f,0.57812500f,0.82812500f,-0.67187500f,0.39062500f,0.32812500f,0.28125000f,0.96875000f,0.45312500f,0.59375000f,-0.35937500f,-0.37500000f,0.12500000f,0.76562500f,0.43750000f,0.89062500f,-0.25000000f,0.84375000f,-0.89062500f,-0.03125000f,0.57812500f,-0.67187500f,-0.21875000f,0.23437500f,-0.25000000f,0.39062500f,-0.79687500f,-0.17187500f,-0.92187500f,-0.65625000f,0.73437500f,-0.70312500f,-0.65625000f,-0.25000000f,-0.70312500f,0.64062500f,0.31250000f,0.87500000f,-0.93750000f,0.21875000f,0.57812500f,0.39062500f,0.93750000f,0.40625000f,0.87500000f,-0.18750000f,-0.23437500f,0.96875000f,-0.79687500f,0.39062500f,-0.85937500f,-0.79687500f,-0.40625000f,-0.92187500f,-0.12500000f,0.76562500f,0.09375000f,-0.40625000f,-0.84375000f,-0.95312500f,-0.71875000f,-0.17187500f,-0.62500000f,-0.78125000f,0.10937500f,-0.45312500f,-0.65625000f,-0.59375000f,0.98437500f,0.73437500f,0.85937500f,-0.87500000f,-0.67187500f,-0.98437500f,-0.17187500f,0.95312500f,-0.81250000f,0.84375000f,-0.90625000f,0.92187500f,-0.85937500f,-0.82812500f,0.54687500f,0.21875000f,0.09375000f,-0.15625000f,0.45312500f,0.28125000f,-0.96875000f,0.45312500f,0.62500000f,0.56250000f,-0.31250000f,-0.31250000f,0.57812500f,0.14062500f,0.34375000f,0.09375000f,-0.21875000f,0.57812500f,-0.82812500f,0.96875000f,-0.75000000f,0.60937500f,-0.92187500f,-0.07812500f,0.89062500f,0.43750000f,0.23437500f,0.15625000f,0.12500000f,-0.78125000f,-0.46875000f,0.03125000f,0.62500000f,0.53125000f,-0.85937500f,-0.78125000f,0.60937500f,0.15625000f,0.68750000f,0.87500000f,0.93750000f,0.53125000f,-0.93750000f,-0.48437500f,-0.23437500f,-0.45312500f,0.39062500f,0.10937500f,-0.14062500f,0.93750000f,0.64062500f,0.95312500f,0.96875000f,0.73437500f,-0.12500000f,0.75000000f,-0.64062500f,0.04687500f,-0.51562500f,-0.39062500f,-0.10937500f,0.62500000f,0.85937500f,0.46875000f,0.04687500f,0.42187500f,-0.96875000f,0.71875000f,-0.85937500f,-0.45312500f,0.46875000f,0.07812500f,-0.56250000f,-0.64062500f,-0.68750000f,0.04687500f,0.25000000f,-0.64062500f,-0.23437500f,0.03125000f,-0.45312500f,0.12500000f,0.93750000f,-0.35937500f,0.23437500f,0.96875000f,0.48437500f,0.56250000f,0.09375000f,-0.57812500f,-0.42187500f,0.53125000f,-0.25000000f,-0.87500000f,-0.54687500f,0.64062500f,0.00000000f,0.03125000f,0.10937500f,-0.67187500f,-0.32812500f,-0.10937500f,-0.59375000f,0.87500000f,-0.43750000f,0.96875000f,0.48437500f,0.59375000f,-0.18750000f,-0.85937500f,0.89062500f,-0.20312500f,0.07812500f,-0.98437500f,0.01562500f,0.18750000f,0.39062500f,0.96875000f,0.15625000f,-0.82812500f,0.93750000f,0.17187500f,0.39062500f,-0.40625000f,0.89062500f,-0.59375000f,0.40625000f,0.78125000f,-0.10937500f,0.79687500f,0.56250000f,-0.28125000f,-0.48437500f,-0.82812500f,-0.70312500f,0.34375000f,0.57812500f,0.00000000f,0.28125000f,0.70312500f,0.39062500f,-0.29687500f,-0.25000000f,-0.90625000f,-0.32812500f,-0.85937500f,0.37500000f,0.93750000f,-0.20312500f,-0.48437500f,0.92187500f,0.79687500f,-0.29687500f,0.06250000f,-0.31250000f,0.34375000f,0.67187500f,0.57812500f,0.25000000f,-0.56250000f,0.92187500f,-0.26562500f,-0.71875000f,0.68750000f,0.65625000f,0.46875000f,0.09375000f,0.39062500f,-0.39062500f,0.75000000f,0.70312500f,-0.89062500f,-0.56250000f,0.40625000f,0.95312500f,0.10937500f,-0.26562500f,-0.73437500f,0.20312500f,0.06250000f,-0.68750000f,-0.60937500f,-0.71875000f,0.40625000f,0.75000000f,-0.46875000f,0.57812500f,-0.29687500f,0.37500000f,0.51562500f,-0.73437500f,0.90625000f,0.75000000f,-0.64062500f,0.71875000f,0.62500000f,0.70312500f,0.32812500f,0.81250000f,0.57812500f,0.71875000f,-0.67187500f,-0.56250000f,-0.07812500f,-1.00000000f,-0.48437500f,0.32812500f,0.98437500f,0.98437500f,-0.98437500f,-0.56250000f,0.68750000f,-0.95312500f,-0.37500000f,0.82812500f,0.67187500f,0.28125000f,0.51562500f,0.46875000f,-0.56250000f,-0.32812500f,-0.56250000f,-0.31250000f,-0.29687500f,0.18750000f,-0.17187500f,1.00000000f,0.96875000f,0.50000000f,-0.68750000f,0.75000000f,-0.39062500f,-0.28125000f,-0.90625000f,0.40625000f,0.96875000f,-0.03125000f,0.32812500f,0.67187500f,-0.60937500f,-0.25000000f,-0.57812500f,0.06250000f,0.56250000f,0.76562500f,-0.65625000f,-0.45312500f,0.54687500f,-0.92187500f,-0.39062500f,0.15625000f,0.71875000f,-0.29687500f,0.67187500f,-0.03125000f,0.40625000f,-0.79687500f,-0.90625000f,0.59375000f,0.39062500f,-0.25000000f,-0.04687500f,-0.07812500f,-0.06250000f,0.04687500f,0.59375000f,0.98437500f,0.59375000f,0.48437500f,-0.43750000f,0.03125000f,0.25000000f,0.96875000f,-0.07812500f,0.56250000f,-0.03125000f,0.20312500f,0.87500000f,-0.26562500f,-0.48437500f,-0.42187500f,0.39062500f,-0.10937500f,-0.81250000f,-0.31250000f,-0.18750000f,0.73437500f,-0.75000000f,-0.40625000f,0.56250000f,-0.90625000f,0.68750000f,0.31250000f,0.48437500f,0.23437500f,0.65625000f,-0.50000000f,0.76562500f,0.42187500f,0.37500000f,0.57812500f,0.60937500f,-0.46875000f,0.28125000f,0.85937500f,0.34375000f,0.65625000f,0.82812500f,-0.54687500f,-0.92187500f,-0.89062500f,-0.28125000f,-0.98437500f,-0.54687500f,-0.37500000f,-0.06250000f,0.48437500f,0.60937500f,-0.95312500f,0.32812500f,0.45312500f,0.50000000f,-0.42187500f,-0.98437500f,0.81250000f,-0.59375000f,0.73437500f,0.92187500f,-0.60937500f,-0.65625000f,0.46875000f,-1.00000000f,-0.68750000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{4.00073242f,-2.86596680f,0.43212891f,-0.91430664f,-2.23144531f,-2.22485352f,2.95874023f,3.72607422f,1.34472656f,0.49487305f,1.16406250f,0.80029297f,-2.94848633f,6.21020508f,0.98901367f,-0.70141602f,1.79833984f,-7.14746094f,0.49169922f,-2.20654297f,1.07885742f,-0.02832031f,-2.26196289f,6.25341797f,-1.45458984f,0.56982422f,2.76904297f,-2.68945312f,4.12963867f,0.64575195f,0.61157227f,-2.00439453f,1.90039062f,-1.76000977f,-1.03369141f,-1.44799805f,-1.48950195f,-0.79907227f,3.16015625f,-0.57983398f,-1.98950195f,3.09985352f,1.37280273f,0.19287109f,-2.61572266f,-2.24755859f,2.11328125f,-3.43237305f,-3.58105469f,-1.12817383f,-1.74755859f,-0.73266602f,1.14501953f,2.55419922f,4.57617188f,1.11523438f,-1.78491211f,0.88110352f,2.00488281f,-0.19458008f,-3.39331055f,-4.83959961f,-1.06274414f,1.71704102f,-0.49877930f,0.08398438f,1.07055664f,1.42529297f,0.19262695f,3.83325195f,-0.47241211f,0.86450195f,0.08911133f,1.28979492f,-0.67919922f,0.46166992f,-1.19433594f,0.81420898f,1.66137695f,-1.73510742f,-2.31298828f,-0.72167969f,-1.19433594f,-2.47045898f,2.05126953f,-2.30712891f,-1.89233398f,-2.44946289f,4.20385742f,-2.11840820f,-0.37011719f,1.19628906f,2.50122070f,0.84497070f,0.63891602f,-3.31909180f,1.59667969f,0.40747070f,-1.65332031f,2.22802734f,2.03442383f,-1.08715820f,-1.16796875f,-0.88085938f,-0.35498047f,-0.04541016f,1.18579102f,0.52661133f,0.87768555f,0.47558594f,-1.79492188f,-1.96655273f,-0.21093750f,-2.54492188f,-0.95898438f,2.89233398f,0.72802734f,-3.94506836f,-5.58789062f,1.76879883f,-1.04077148f,2.04272461f,2.93603516f,0.77343750f,-2.84008789f,0.88232422f,1.58374023f,-2.09619141f,0.83056641f,3.17993164f,1.59301758f,2.07763672f,-0.80737305f,-2.52880859f,0.79882812f,-0.97509766f,1.55151367f,-0.04614258f,-1.00952148f,3.39306641f,0.44042969f,-4.12597656f,1.55810547f,0.28906250f,3.52612305f,0.06542969f,-3.38159180f,-2.45776367f,-0.16113281f,-1.13671875f,-2.71606445f,-0.73193359f,-3.43261719f,0.76171875f,-2.18041992f,-1.83691406f,-1.01977539f,1.61523438f,0.75708008f,-3.18237305f,3.37695312f,-1.93212891f,-3.36865234f,-0.82446289f,-1.59960938f,3.01611328f,2.37890625f,-0.42675781f,-3.78027344f,2.01757812f,-2.45922852f,3.58666992f,-0.84545898f,1.51782227f,0.97827148f,-1.00073242f,-3.84399414f,-0.45092773f,-0.71166992f,2.59619141f,4.44995117f,1.34521484f,1.04223633f,-2.74975586f,-1.24951172f,-0.50463867f,1.18774414f,-0.53588867f,-0.30566406f,1.35717773f,0.45556641f,4.26342773f,0.48681641f,3.83935547f,1.16870117f,-1.59814453f,-2.19238281f,0.73510742f,-0.92358398f,0.04125977f,-0.03369141f,0.44873047f,-0.87646484f,0.33886719f,-1.04321289f,2.72607422f,-2.29003906f,3.02783203f,-2.84350586f,3.70434570f,2.01293945f,-2.73852539f,-0.41845703f,3.35522461f,-1.32934570f,-1.27392578f,-1.65161133f,1.07397461f,1.36010742f,2.70019531f,-1.53662109f,0.42114258f,2.79150391f,-1.99023438f,-2.26879883f,3.82592773f,4.15844727f,2.70385742f,-0.19824219f,-1.51904297f,1.33959961f,-0.72241211f,0.77124023f,2.51733398f,-1.17163086f,1.96118164f,4.15405273f,3.18798828f,-1.63476562f,1.00903320f,2.59155273f,0.36791992f,1.49462891f,-2.76269531f,-3.68432617f,2.02124023f,4.29687500f,0.05029297f,-4.80395508f,0.99023438f,1.55810547f,-1.08569336f,-0.30712891f,-2.74926758f,-1.78491211f,2.00512695f,-0.75585938f,0.96899414f,-0.81567383f,-0.19897461f,1.30297852f,0.78979492f,1.98095703f,1.18188477f,4.23168945f,-1.31030273f,-0.72119141f,-1.55419922f,-2.56323242f,-0.88061523f,-1.65454102f,-0.62988281f,0.54321289f,-4.37670898f,0.03344727f,0.66479492f,2.47827148f,1.66503906f,1.43286133f,2.50463867f,2.25585938f,3.42846680f,-1.28979492f,0.08569336f,2.90820312f,-1.34130859f,0.24609375f,-0.99487305f,-0.26245117f,1.15258789f,-2.26953125f,0.18798828f,-1.04956055f,-0.80737305f,0.42626953f,-3.80444336f,-3.69555664f,1.95117188f,-0.61132812f,0.86938477f,-1.51391602f,-0.40747070f,0.37304688f,-2.54296875f,-1.42285156f,-1.33471680f,-3.91674805f,-2.00610352f,-1.47338867f,1.96508789f,-1.06005859f,0.82543945f,0.30712891f,-0.93872070f,-4.89306641f,-0.34008789f,0.26391602f,1.72290039f,0.18188477f,1.60058594f,-0.88256836f,0.32836914f,-0.67480469f,-0.73510742f,0.47583008f,-4.59594727f,1.63061523f,3.05078125f,0.18994141f,3.88110352f,0.02905273f,1.49072266f,-1.06640625f,-0.39941406f,-2.80688477f,-0.70971680f,-1.23242188f,-0.01611328f,3.00561523f,-3.89843750f,2.43212891f,0.78198242f,1.36279297f,-0.01733398f,-3.42431641f,-4.70532227f,1.67773438f,-2.22534180f,-2.68041992f,0.88159180f,1.78076172f,-1.06079102f,-0.41430664f,0.88891602f,0.41577148f,2.75122070f,0.60937500f,1.55737305f,-1.96972656f,1.78100586f,0.64208984f,-3.60351562f,-3.76660156f,3.66918945f,-2.09008789f,1.34082031f,1.44067383f,-0.72143555f,-0.03442383f,-0.04565430f,-2.74365234f,-0.55517578f,-0.86108398f,-0.86010742f,4.46313477f,-1.92382812f,0.80883789f,0.83056641f,-0.17749023f,0.94458008f,-1.51831055f,-0.02221680f,-1.20507812f,-0.53857422f,4.01220703f,-3.46508789f,-0.72827148f,0.03198242f,-2.62500000f,-2.26049805f,-1.81494141f,-3.15966797f,0.65429688f,-1.67382812f,-1.62231445f,0.35156250f,0.20410156f,-2.95800781f,1.83764648f,2.59790039f,1.03051758f,-2.35595703f,-1.86987305f,2.93334961f,-0.95629883f,-0.26416016f,1.39135742f,-0.83691406f,-0.63842773f,2.67504883f,-0.44726562f,2.63085938f,0.66137695f,-1.82446289f,-0.83740234f,0.23120117f,1.25610352f,5.63549805f,-0.33056641f,-3.12841797f,0.78100586f,2.99023438f,0.03271484f,-2.01977539f,1.48510742f,-1.63305664f,-1.47534180f,0.78833008f,-0.76977539f,1.12060547f,-2.44799805f,-1.52563477f,0.42504883f,2.98559570f,2.02001953f,-0.54907227f,1.03540039f,0.21655273f,-1.10180664f,-1.61865234f,-0.06176758f,0.93579102f,-1.98217773f,-0.73876953f,-2.17675781f,-0.39843750f,1.69799805f,2.14404297f,0.12402344f,-0.23852539f,0.30810547f,2.32958984f,1.31494141f,1.73095703f,-0.52880859f,0.55615234f,1.54467773f,0.97412109f,0.25903320f,1.93603516f,0.89501953f,2.25683594f,-0.53833008f,-0.22265625f,0.77539062f,1.76879883f,-0.01196289f,0.06030273f,-1.48461914f,3.36035156f,1.44873047f,-0.92480469f,0.75341797f,-0.77734375f,1.25244141f,0.69287109f,0.47729492f,1.24975586f,1.67358398f,0.61889648f,-0.23876953f,0.22973633f,-3.07226562f,-1.51660156f,0.48486328f,-2.18334961f,-0.74780273f,-1.69702148f,-0.99609375f,2.50390625f,0.48950195f,0.42944336f,-0.51904297f,-0.55029297f,-0.04492188f,0.61596680f,-0.72167969f,1.82739258f,1.81738281f,-1.86962891f,0.40087891f,-0.11718750f,-1.40942383f,2.28637695f,2.42895508f,-0.45068359f,1.79345703f,-4.74365234f,-0.35620117f,-5.14111328f,2.59912109f,3.86425781f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    // EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_4items_dilated)
{
    Shape shape_a{4,3,3,5,8,7};
    Shape shape_b{4,3,2,2,3,1};
    Shape shape_r{4,4,1,4,2,7};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{1,1,1,1},        // move_strides
                                                                  Strides{2,1,3,2},        // filter_dilation
                                                                  CoordinateDiff{0,0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0,0}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f,-0.60937500f,-0.15625000f,0.20312500f,-0.37500000f,-0.75000000f,-0.17187500f,-0.67187500f,-0.75000000f,0.31250000f,-0.26562500f,-0.78125000f,-0.87500000f,-0.28125000f,-0.92187500f,0.96875000f,0.43750000f,-0.32812500f,-0.23437500f,0.04687500f,-0.90625000f,-0.14062500f,-0.89062500f,0.18750000f,-0.46875000f,-0.18750000f,-0.53125000f,0.43750000f,-0.73437500f,-0.98437500f,0.82812500f,0.15625000f,-0.51562500f,-0.46875000f,-0.53125000f,-0.07812500f,-0.23437500f,0.04687500f,-0.64062500f,0.18750000f,0.90625000f,-0.12500000f,-0.18750000f,0.93750000f,-0.98437500f,0.07812500f,-0.43750000f,0.51562500f,1.00000000f,-0.43750000f,0.31250000f,-0.98437500f,-0.34375000f,0.87500000f,-0.62500000f,1.00000000f,0.73437500f,-0.37500000f,0.85937500f,-0.70312500f,0.82812500f,0.18750000f,0.23437500f,0.07812500f,-0.67187500f,-0.93750000f,0.32812500f,0.89062500f,0.06250000f,-0.79687500f,-0.18750000f,0.65625000f,-0.92187500f,0.07812500f,-0.84375000f,0.15625000f,-0.32812500f,-0.43750000f,0.87500000f,0.87500000f,-0.70312500f,0.82812500f,-0.67187500f,-0.75000000f,-0.01562500f,-0.79687500f,0.15625000f,-0.21875000f,-0.31250000f,-0.48437500f,0.48437500f,-0.85937500f,-0.18750000f,-0.20312500f,0.45312500f,-0.87500000f,0.28125000f,0.81250000f,-0.56250000f,-0.12500000f,-0.06250000f,0.03125000f,-0.82812500f,0.56250000f,0.01562500f,-0.59375000f,-0.76562500f,0.70312500f,-1.00000000f,-0.87500000f,-0.68750000f,-0.64062500f,0.93750000f,-0.50000000f,0.73437500f,0.92187500f,-0.95312500f,-0.45312500f,-0.06250000f,-0.06250000f,-0.60937500f,-0.01562500f,-0.17187500f,0.34375000f,-0.95312500f,-0.01562500f,-0.85937500f,-0.85937500f,0.42187500f,-0.57812500f,-0.67187500f,0.35937500f,-0.06250000f,0.78125000f,-0.26562500f,-0.10937500f,0.92187500f,0.17187500f,0.46875000f,0.56250000f,0.20312500f,-0.42187500f,0.00000000f,0.12500000f,-0.92187500f,-0.14062500f,0.48437500f,-0.60937500f,0.50000000f,0.87500000f,0.25000000f,-0.59375000f,-0.04687500f,0.29687500f,0.31250000f,0.45312500f,-0.96875000f,-0.70312500f,0.87500000f,0.62500000f,-0.34375000f,-0.90625000f,0.07812500f,0.51562500f,0.35937500f,0.40625000f,-0.62500000f,0.48437500f,-0.50000000f,-0.23437500f,0.68750000f,-0.23437500f,-0.85937500f,0.95312500f,0.51562500f,-0.15625000f,0.35937500f,0.50000000f,0.73437500f,0.71875000f,-0.62500000f,0.45312500f,0.40625000f,-0.18750000f,-0.85937500f,0.42187500f,-0.67187500f,0.62500000f,-0.60937500f,-0.54687500f,0.21875000f,0.50000000f,0.65625000f,0.32812500f,0.87500000f,-0.01562500f,0.40625000f,0.17187500f,0.93750000f,-0.95312500f,-0.20312500f,-0.73437500f,0.40625000f,-0.20312500f,0.20312500f,-0.04687500f,-0.65625000f,0.64062500f,0.65625000f,-0.71875000f,0.31250000f,-0.35937500f,-0.28125000f,0.15625000f,1.00000000f,1.00000000f,0.43750000f,-0.20312500f,-0.53125000f,0.92187500f,0.90625000f,0.07812500f,0.50000000f,0.43750000f,-0.57812500f,0.84375000f,-0.67187500f,0.09375000f,-0.17187500f,-0.64062500f,0.14062500f,-0.67187500f,1.00000000f,-0.48437500f,-0.37500000f,0.00000000f,0.21875000f,0.96875000f,0.06250000f,-0.81250000f,0.78125000f,0.87500000f,0.67187500f,0.45312500f,-0.96875000f,-0.29687500f,-0.60937500f,0.70312500f,0.56250000f,0.59375000f,0.87500000f,0.95312500f,0.03125000f,-0.64062500f,-0.62500000f,-0.43750000f,0.51562500f,-0.17187500f,-0.06250000f,0.03125000f,-0.48437500f,-0.95312500f,-0.31250000f,-0.40625000f,-0.89062500f,-0.64062500f,0.23437500f,0.87500000f,0.48437500f,0.54687500f,0.82812500f,0.70312500f,-0.68750000f,0.87500000f,0.93750000f,0.92187500f,-0.03125000f,0.65625000f,0.04687500f,-0.25000000f,0.10937500f,-0.57812500f,-0.21875000f,0.25000000f,-0.15625000f,0.89062500f,0.35937500f,0.96875000f,-0.31250000f,-0.04687500f,-0.04687500f,0.46875000f,-0.51562500f,-0.25000000f,0.67187500f,-0.70312500f,0.28125000f,-0.48437500f,0.71875000f,-0.43750000f,-0.28125000f,-0.81250000f,0.70312500f,0.95312500f,0.31250000f,-0.31250000f,-0.29687500f,0.20312500f,-0.95312500f,0.64062500f,-0.87500000f,-0.42187500f,0.90625000f,-0.65625000f,-0.85937500f,-0.84375000f,0.50000000f,0.17187500f,-0.37500000f,-1.00000000f,-0.89062500f,-0.68750000f,0.53125000f,0.95312500f,0.17187500f,-0.70312500f,0.46875000f,0.53125000f,-0.31250000f,0.67187500f,0.89062500f,0.32812500f,-0.53125000f,-0.57812500f,0.54687500f,-0.98437500f,0.23437500f,0.01562500f,0.65625000f,-0.43750000f,-0.54687500f,0.93750000f,-0.71875000f,-0.84375000f,0.18750000f,0.59375000f,-0.95312500f,-0.50000000f,0.93750000f,-0.07812500f,-0.68750000f,0.85937500f,-0.35937500f,-0.26562500f,-0.79687500f,-0.95312500f,-0.90625000f,-0.50000000f,0.56250000f,0.85937500f,0.50000000f,-0.04687500f,0.35937500f,-0.78125000f,0.50000000f,-0.93750000f,-0.40625000f,-0.70312500f,0.15625000f,-0.07812500f,0.40625000f,0.70312500f,0.46875000f,-0.71875000f,-0.03125000f,-0.87500000f,-0.84375000f,-0.34375000f,0.00000000f,0.17187500f,-0.93750000f,0.62500000f,-0.76562500f,-0.26562500f,0.98437500f,0.40625000f,1.00000000f,-0.90625000f,-0.23437500f,0.50000000f,0.53125000f,-0.90625000f,-0.62500000f,0.96875000f,-0.59375000f,-0.10937500f,0.89062500f,-1.00000000f,0.70312500f,0.98437500f,0.15625000f,-0.26562500f,0.50000000f,0.56250000f,-0.26562500f,0.10937500f,0.78125000f,0.70312500f,0.20312500f,-0.84375000f,0.50000000f,0.96875000f,0.57812500f,-0.18750000f,0.03125000f,0.68750000f,-0.64062500f,-0.29687500f,-0.62500000f,0.32812500f,-0.90625000f,-0.39062500f,0.17187500f,0.73437500f,-0.65625000f,-0.10937500f,0.76562500f,0.59375000f,0.65625000f,-0.43750000f,0.39062500f,-0.18750000f,0.09375000f,0.07812500f,0.35937500f,0.15625000f,0.18750000f,-0.35937500f,0.78125000f,-0.45312500f,-0.87500000f,-0.50000000f,-0.60937500f,0.37500000f,-0.64062500f,0.32812500f,0.81250000f,-0.96875000f,-0.92187500f,-0.73437500f,0.07812500f,0.00000000f,-0.56250000f,-0.20312500f,0.32812500f,0.78125000f,0.78125000f,-0.32812500f,0.68750000f,-0.23437500f,-0.57812500f,-0.76562500f,-0.35937500f,-0.53125000f,0.04687500f,-0.45312500f,-0.04687500f,0.00000000f,0.48437500f,-0.59375000f,0.37500000f,0.81250000f,0.95312500f,-0.48437500f,0.20312500f,0.01562500f,-0.62500000f,-0.75000000f,-0.64062500f,0.65625000f,-0.50000000f,-0.18750000f,-0.84375000f,-0.14062500f,0.51562500f,0.03125000f,-0.50000000f,0.51562500f,-0.98437500f,0.93750000f,0.78125000f,-0.96875000f,-0.57812500f,0.31250000f,0.10937500f,0.92187500f,-0.92187500f,0.25000000f,-0.31250000f,-0.15625000f,0.09375000f,0.43750000f,-0.76562500f,-0.14062500f,-0.68750000f,-0.14062500f,-0.03125000f,0.90625000f,-0.71875000f,-0.56250000f,0.64062500f,0.76562500f,0.60937500f,0.81250000f,-0.48437500f,0.46875000f,0.65625000f,-0.29687500f,0.48437500f,-0.43750000f,0.82812500f,-0.26562500f,0.64062500f,-0.01562500f,0.35937500f,-0.29687500f,-0.84375000f,-0.92187500f,-0.84375000f,0.73437500f,0.09375000f,-0.53125000f,-0.15625000f,0.12500000f,0.84375000f,-0.78125000f,-0.51562500f,0.42187500f,0.25000000f,0.37500000f,0.18750000f,0.18750000f,0.67187500f,0.96875000f,0.62500000f,0.23437500f,0.57812500f,0.10937500f,-0.31250000f,-0.78125000f,0.79687500f,0.29687500f,0.96875000f,-0.70312500f,-0.96875000f,-0.75000000f,-0.01562500f,-0.37500000f,0.03125000f,0.10937500f,0.95312500f,-0.59375000f,0.78125000f,-0.20312500f,-0.15625000f,0.15625000f,-0.82812500f,0.60937500f,0.26562500f,0.32812500f,-0.90625000f,0.21875000f,-0.37500000f,0.37500000f,0.03125000f,-0.37500000f,-0.81250000f,0.81250000f,-0.89062500f,-0.75000000f,-0.96875000f,0.76562500f,0.43750000f,0.35937500f,-0.89062500f,0.75000000f,-0.04687500f,-1.00000000f,0.98437500f,0.70312500f,-0.85937500f,-0.17187500f,0.46875000f,0.56250000f,-0.25000000f,0.60937500f,-0.92187500f,-0.57812500f,0.89062500f,-0.29687500f,0.84375000f,-0.09375000f,0.28125000f,-0.06250000f,0.87500000f,0.12500000f,-0.25000000f,-0.96875000f,0.10937500f,-0.53125000f,0.89062500f,-0.62500000f,-0.57812500f,0.18750000f,0.07812500f,0.28125000f,-0.06250000f,0.34375000f,-0.46875000f,-0.35937500f,0.50000000f,-0.07812500f,1.00000000f,1.00000000f,0.45312500f,-0.82812500f,-0.59375000f,-0.90625000f,0.06250000f,-0.93750000f,0.85937500f,0.43750000f,0.89062500f,0.32812500f,-0.92187500f,0.87500000f,-0.62500000f,-0.62500000f,-0.25000000f,-0.70312500f,0.87500000f,0.57812500f,0.93750000f,0.84375000f,-0.48437500f,-0.40625000f,-0.90625000f,-0.48437500f,0.95312500f,-0.57812500f,0.40625000f,-0.90625000f,0.26562500f,-0.76562500f,-0.51562500f,0.85937500f,0.84375000f,0.45312500f,-0.76562500f,-0.12500000f,-0.03125000f,-1.00000000f,-0.65625000f,0.17187500f,0.12500000f,0.40625000f,1.00000000f,0.17187500f,-0.37500000f,0.48437500f,0.06250000f,-0.68750000f,-0.84375000f,0.35937500f,-0.14062500f,-0.12500000f,0.60937500f,-0.51562500f,1.00000000f,-0.25000000f,-0.81250000f,0.29687500f,-0.54687500f,0.35937500f,-0.60937500f,-0.98437500f,-0.12500000f,-0.31250000f,0.64062500f,-0.03125000f,0.46875000f,0.37500000f,0.53125000f,0.09375000f,-0.09375000f,0.60937500f,-0.56250000f,0.18750000f,-0.76562500f,0.00000000f,-0.15625000f,0.79687500f,0.53125000f,-0.46875000f,1.00000000f,-0.78125000f,0.39062500f,0.45312500f,0.35937500f,0.15625000f,-0.20312500f,-0.07812500f,-0.96875000f,0.71875000f,0.90625000f,-0.35937500f,-0.32812500f,0.79687500f,-0.57812500f,0.01562500f,-0.92187500f,0.46875000f,-0.15625000f,-0.53125000f,-0.56250000f,-0.42187500f,-0.26562500f,0.51562500f,-0.65625000f,0.60937500f,0.35937500f,-0.28125000f,-0.76562500f,0.12500000f,0.73437500f,0.25000000f,0.71875000f,-0.57812500f,-0.54687500f,-0.01562500f,0.89062500f,-0.85937500f,0.20312500f,-0.64062500f,-0.95312500f,0.35937500f,-0.82812500f,-0.75000000f,0.92187500f,-0.65625000f,-0.09375000f,-0.37500000f,0.78125000f,-0.81250000f,0.60937500f,0.76562500f,-0.48437500f,-0.32812500f,-0.75000000f,0.59375000f,-0.21875000f,0.98437500f,-0.45312500f,-0.35937500f,-0.48437500f,0.14062500f,-0.12500000f,-0.12500000f,0.48437500f,0.14062500f,0.21875000f,0.42187500f,1.00000000f,-0.95312500f,-0.28125000f,-0.54687500f,-1.00000000f,0.92187500f,0.35937500f,0.76562500f,0.79687500f,-0.71875000f,-0.46875000f,-0.32812500f,-0.17187500f,-0.46875000f,0.64062500f,-0.92187500f,-0.70312500f,-0.48437500f,-0.96875000f,0.76562500f,0.73437500f,0.28125000f,0.31250000f,-0.57812500f,-0.45312500f,-0.46875000f,-0.14062500f,-0.10937500f,0.48437500f,-0.39062500f,-0.21875000f,-0.04687500f,0.53125000f,-0.51562500f,-0.37500000f,-0.18750000f,0.53125000f,0.92187500f,-0.84375000f,-0.45312500f,0.34375000f,0.48437500f,-0.71875000f,0.46875000f,-0.04687500f,-0.96875000f,-0.56250000f,0.48437500f,-0.79687500f,-0.57812500f,0.64062500f,-0.50000000f,-0.64062500f,-0.64062500f,-0.92187500f,-0.82812500f,0.10937500f,-0.98437500f,0.90625000f,0.28125000f,-0.81250000f,-0.35937500f,0.50000000f,-0.73437500f,-0.62500000f,-0.76562500f,-0.71875000f,-0.17187500f,-0.21875000f,-0.51562500f,-0.73437500f,0.64062500f,0.90625000f,0.79687500f,0.96875000f,0.71875000f,0.23437500f,0.03125000f,0.98437500f,0.25000000f,0.62500000f,0.54687500f,0.20312500f,-0.87500000f,-0.25000000f,-0.82812500f,0.68750000f,-0.29687500f,0.12500000f,0.14062500f,0.14062500f,0.65625000f,-0.35937500f,0.84375000f,-0.78125000f,-0.64062500f,0.70312500f,-0.87500000f,-0.31250000f,-0.43750000f,0.15625000f,-0.07812500f,-0.96875000f,0.39062500f,-0.95312500f,0.17187500f,0.14062500f,0.32812500f,-0.81250000f,-0.25000000f,0.71875000f,0.82812500f,0.50000000f,-0.17187500f,0.17187500f,-0.15625000f,0.57812500f,0.18750000f,0.84375000f,0.48437500f,0.75000000f,0.85937500f,-0.20312500f,-0.71875000f,-0.37500000f,0.29687500f,0.90625000f,0.06250000f,-0.59375000f,-0.15625000f,0.70312500f,-0.23437500f,0.73437500f,0.03125000f,-0.37500000f,0.89062500f,0.20312500f,-0.89062500f,0.18750000f,0.82812500f,0.46875000f,0.85937500f,0.81250000f,-0.23437500f,0.76562500f,0.48437500f,0.87500000f,0.12500000f,-0.39062500f,0.29687500f,-0.14062500f,-0.07812500f,0.53125000f,0.17187500f,0.45312500f,0.82812500f,-0.45312500f,-0.68750000f,0.87500000f,-0.43750000f,0.15625000f,0.43750000f,0.65625000f,-0.26562500f,0.18750000f,0.79687500f,0.45312500f,-0.57812500f,0.62500000f,0.76562500f,0.45312500f,0.96875000f,0.65625000f,-0.82812500f,-0.28125000f,-0.31250000f,0.93750000f,0.17187500f,0.92187500f,0.07812500f,0.12500000f,0.56250000f,-0.39062500f,-0.40625000f,-0.32812500f,0.40625000f,-0.71875000f,-0.23437500f,0.17187500f,0.40625000f,0.59375000f,0.59375000f,-0.75000000f,-0.10937500f,-0.21875000f,-0.46875000f,-0.17187500f,0.56250000f,-0.32812500f,-0.01562500f,0.31250000f,-0.40625000f,0.01562500f,0.23437500f,0.51562500f,0.25000000f,0.09375000f,0.12500000f,0.79687500f,-0.65625000f,-0.40625000f,0.57812500f,-0.23437500f,0.34375000f,0.96875000f,-0.34375000f,-0.85937500f,-0.28125000f,-0.76562500f,-0.04687500f,0.84375000f,0.82812500f,-0.59375000f,-0.20312500f,-0.48437500f,0.32812500f,-0.54687500f,-0.46875000f,0.29687500f,0.64062500f,0.39062500f,0.14062500f,0.17187500f,-0.87500000f,0.43750000f,-0.82812500f,-0.43750000f,0.84375000f,0.01562500f,0.54687500f,-0.92187500f,-0.01562500f,-0.35937500f,-0.93750000f,-0.98437500f,0.60937500f,-0.43750000f,-0.87500000f,0.85937500f,-0.60937500f,0.40625000f,-0.10937500f,0.23437500f,0.32812500f,-0.92187500f,-0.57812500f,-0.45312500f,-0.73437500f,0.18750000f,-0.96875000f,-0.56250000f,0.12500000f,0.06250000f,-0.03125000f,-0.32812500f,0.32812500f,-0.67187500f,0.29687500f,-0.67187500f,0.42187500f,0.09375000f,-0.15625000f,-0.95312500f,0.79687500f,-0.32812500f,0.46875000f,-0.90625000f,0.32812500f,-0.92187500f,-0.21875000f,0.65625000f,-0.68750000f,-0.75000000f,-0.67187500f,-0.04687500f,-0.04687500f,0.43750000f,0.90625000f,0.23437500f,0.59375000f,0.62500000f,0.68750000f,-0.48437500f,0.95312500f,-0.51562500f,0.00000000f,0.31250000f,0.65625000f,-0.84375000f,-0.14062500f,-0.90625000f,0.29687500f,0.96875000f,-0.53125000f,0.06250000f,-0.28125000f,-0.26562500f,-0.96875000f,0.25000000f,0.96875000f,-0.23437500f,0.70312500f,0.96875000f,0.01562500f,0.59375000f,0.95312500f,-0.03125000f,-0.34375000f,0.96875000f,-0.56250000f,-0.57812500f,0.06250000f,0.65625000f,0.40625000f,-0.48437500f,-0.40625000f,-0.59375000f,-0.34375000f,-0.73437500f,-0.46875000f,-0.54687500f,0.29687500f,-0.31250000f,-0.23437500f,-0.62500000f,-0.54687500f,-0.60937500f,0.03125000f,0.40625000f,0.92187500f,-0.15625000f,0.43750000f,-0.59375000f,0.01562500f,-0.32812500f,0.93750000f,-0.96875000f,-0.79687500f,-0.76562500f,-0.85937500f,-1.00000000f,0.04687500f,0.29687500f,0.09375000f,0.79687500f,-0.93750000f,0.62500000f,0.06250000f,0.25000000f,-0.60937500f,0.50000000f,-0.31250000f,0.31250000f,-0.07812500f,0.93750000f,0.48437500f,-0.37500000f,-0.67187500f,0.06250000f,0.06250000f,0.67187500f,0.70312500f,0.20312500f,0.68750000f,-0.21875000f,0.03125000f,0.68750000f,-0.79687500f,-0.03125000f,0.21875000f,0.25000000f,0.20312500f,-0.92187500f,0.71875000f,0.37500000f,-0.96875000f,0.10937500f,0.39062500f,-0.67187500f,0.01562500f,-0.43750000f,0.93750000f,0.87500000f,0.56250000f,-0.60937500f,0.68750000f,0.12500000f,-0.12500000f,-0.51562500f,-0.56250000f,-0.18750000f,-0.04687500f,-0.29687500f,0.45312500f,-0.09375000f,-0.64062500f,0.93750000f,-0.59375000f,-0.37500000f,0.62500000f,0.09375000f,-0.60937500f,-0.76562500f,-0.71875000f,0.01562500f,0.59375000f,-0.54687500f,0.82812500f,0.15625000f,0.84375000f,-0.37500000f,-0.54687500f,-0.39062500f,-0.54687500f,-0.42187500f,0.14062500f,-0.79687500f,0.85937500f,-0.68750000f,-0.51562500f,-0.64062500f,-0.70312500f,-0.56250000f,-0.75000000f,0.85937500f,-0.81250000f,-0.84375000f,0.12500000f,0.23437500f,0.79687500f,-0.21875000f,-0.93750000f,0.46875000f,0.75000000f,0.43750000f,-0.53125000f,0.15625000f,0.37500000f,0.50000000f,0.51562500f,0.76562500f,-0.14062500f,0.45312500f,-0.87500000f,-0.71875000f,-0.40625000f,-0.92187500f,0.50000000f,-0.68750000f,-0.71875000f,-0.43750000f,0.79687500f,-0.01562500f,-0.95312500f,-0.31250000f,-0.51562500f,-0.28125000f,0.56250000f,-0.51562500f,0.59375000f,0.65625000f,0.21875000f,-0.56250000f,0.28125000f,0.01562500f,-0.56250000f,-0.59375000f,0.12500000f,-0.75000000f,0.03125000f,-0.53125000f,-0.50000000f,0.00000000f,0.04687500f,0.01562500f,-0.43750000f,-0.48437500f,-0.79687500f,0.50000000f,0.65625000f,-0.04687500f,-0.96875000f,-0.56250000f,-0.29687500f,0.18750000f,-0.01562500f,0.15625000f,0.10937500f,-0.62500000f,-0.18750000f,-0.93750000f,0.28125000f,0.32812500f,-0.12500000f,0.76562500f,0.31250000f,-0.59375000f,0.51562500f,-0.09375000f,-0.65625000f,0.95312500f,-0.78125000f,0.31250000f,-0.40625000f,-0.53125000f,0.56250000f,0.31250000f,0.14062500f,-0.65625000f,-0.65625000f,0.10937500f,0.42187500f,-0.25000000f,-0.01562500f,0.75000000f,0.92187500f,0.04687500f,0.17187500f,-0.59375000f,-0.56250000f,-0.10937500f,-0.40625000f,-0.84375000f,-0.87500000f,-0.50000000f,0.71875000f,-0.60937500f,0.20312500f,0.78125000f,-0.12500000f,0.62500000f,-0.12500000f,-0.50000000f,0.54687500f,-0.87500000f,-0.67187500f,-0.35937500f,-0.15625000f,0.64062500f,0.71875000f,0.42187500f,-0.12500000f,0.96875000f,0.87500000f,-0.57812500f,-0.10937500f,-0.23437500f,-0.85937500f,-0.73437500f,-0.40625000f,-0.90625000f,0.92187500f,-0.48437500f,0.06250000f,-0.21875000f,-0.42187500f,-0.39062500f,-0.59375000f,0.89062500f,-0.92187500f,0.04687500f,-0.40625000f,-0.15625000f,0.23437500f,-0.84375000f,-0.76562500f,-0.18750000f,0.98437500f,0.06250000f,0.85937500f,-0.07812500f,-0.95312500f,0.04687500f,0.43750000f,-0.93750000f,0.37500000f,-0.78125000f,0.46875000f,0.09375000f,0.64062500f,0.07812500f,-0.54687500f,-0.59375000f,-0.95312500f,-0.35937500f,0.70312500f,-0.45312500f,-0.39062500f,-0.60937500f,-0.67187500f,-0.14062500f,-0.82812500f,0.78125000f,0.23437500f,0.89062500f,-0.06250000f,-0.03125000f,0.45312500f,-0.54687500f,-0.37500000f,0.87500000f,0.09375000f,-0.79687500f,0.68750000f,-0.31250000f,0.70312500f,0.39062500f,-0.68750000f,-0.42187500f,0.32812500f,0.56250000f,0.76562500f,1.00000000f,0.54687500f,-0.70312500f,-0.06250000f,-0.10937500f,-0.56250000f,-0.68750000f,0.43750000f,0.87500000f,-0.39062500f,-0.59375000f,0.29687500f,-0.46875000f,-0.60937500f,-0.23437500f,0.68750000f,-0.60937500f,-0.32812500f,0.42187500f,0.56250000f,0.31250000f,0.31250000f,0.06250000f,-0.21875000f,-0.04687500f,-0.39062500f,-0.85937500f,0.96875000f,0.21875000f,0.51562500f,-0.79687500f,0.35937500f,-0.93750000f,0.39062500f,0.25000000f,0.01562500f,-0.89062500f,-0.26562500f,-0.79687500f,-0.46875000f,-0.79687500f,-0.25000000f,0.43750000f,0.56250000f,0.20312500f,1.00000000f,-0.56250000f,0.62500000f,0.12500000f,-0.29687500f,0.17187500f,-0.20312500f,-0.20312500f,-0.85937500f,-0.89062500f,0.57812500f,-0.68750000f,-0.87500000f,-0.71875000f,0.71875000f,-0.06250000f,-0.29687500f,-0.35937500f,-0.01562500f,-0.67187500f,0.00000000f,-0.29687500f,-0.82812500f,-0.56250000f,-0.04687500f,-0.81250000f,-0.23437500f,0.12500000f,-0.20312500f,-0.42187500f,0.89062500f,0.34375000f,0.00000000f,0.06250000f,-0.64062500f,-0.18750000f,0.18750000f,0.87500000f,-0.96875000f,-0.40625000f,-0.46875000f,-0.57812500f,-0.65625000f,-0.75000000f,-1.00000000f,0.64062500f,-0.57812500f,-0.56250000f,0.89062500f,0.67187500f,-0.29687500f,0.68750000f,-0.45312500f,0.68750000f,0.07812500f,-0.40625000f,0.39062500f,0.09375000f,-0.68750000f,-0.57812500f,-0.46875000f,-0.51562500f,0.60937500f,-0.32812500f,0.12500000f,0.26562500f,0.93750000f,-0.84375000f,0.12500000f,0.17187500f,-0.78125000f,-0.90625000f,-0.98437500f,-0.51562500f,-0.84375000f,-0.29687500f,-0.78125000f,-0.32812500f,-0.18750000f,0.23437500f,0.53125000f,-0.48437500f,0.67187500f,0.68750000f,0.62500000f,0.67187500f,-0.09375000f,-0.96875000f,-0.15625000f,-0.48437500f,-0.84375000f,-0.62500000f,-0.46875000f,-0.14062500f,0.81250000f,-0.64062500f,-0.46875000f,-0.20312500f,0.51562500f,-0.60937500f,0.95312500f,0.81250000f,-0.31250000f,-0.68750000f,0.40625000f,-0.90625000f,-0.10937500f,0.76562500f,-0.03125000f,-0.26562500f,-0.53125000f,-0.56250000f,-1.00000000f,-0.25000000f,-0.85937500f,0.09375000f,0.73437500f,-0.96875000f,0.01562500f,-0.57812500f,-0.95312500f,-0.01562500f,-0.84375000f,-0.45312500f,0.06250000f,-0.50000000f,-0.62500000f,0.71875000f,0.78125000f,0.79687500f,-0.46875000f,-0.84375000f,-0.50000000f,0.84375000f,0.73437500f,-0.93750000f,-0.10937500f,0.20312500f,-0.15625000f,-0.64062500f,-0.03125000f,0.75000000f,-0.65625000f,-0.54687500f,0.09375000f,-0.57812500f,0.29687500f,0.34375000f,-0.20312500f,-0.92187500f,-0.78125000f,-0.60937500f,-0.96875000f,-0.89062500f,0.57812500f,0.32812500f,-0.17187500f,0.59375000f,-0.40625000f,-0.25000000f,-0.39062500f,0.93750000f,0.00000000f,-0.98437500f,-0.39062500f,0.98437500f,0.96875000f,0.62500000f,-0.29687500f,0.43750000f,0.89062500f,0.84375000f,0.39062500f,-0.57812500f,-0.07812500f,0.68750000f,-0.29687500f,-0.54687500f,-1.00000000f,0.12500000f,-0.45312500f,-0.85937500f,-0.29687500f,-0.68750000f,0.39062500f,-0.28125000f,-0.70312500f,0.00000000f,-0.68750000f,-0.39062500f,0.00000000f,0.48437500f,0.28125000f,-0.89062500f,0.29687500f,0.45312500f,0.96875000f,0.65625000f,-0.89062500f,-0.26562500f,-0.25000000f,0.25000000f,-0.46875000f,0.95312500f,-0.17187500f,0.29687500f,-0.64062500f,0.50000000f,0.29687500f,-0.70312500f,0.53125000f,-0.04687500f,0.60937500f,0.10937500f,0.42187500f,0.45312500f,-0.34375000f,-0.48437500f,-0.67187500f,-0.25000000f,0.40625000f,0.56250000f,-0.82812500f,0.87500000f,-0.35937500f,0.75000000f,-0.43750000f,-0.29687500f,-0.43750000f,0.26562500f,-0.45312500f,-0.59375000f,0.00000000f,-0.06250000f,-0.70312500f,-0.59375000f,0.35937500f,-0.25000000f,-0.64062500f,0.32812500f,-0.12500000f,0.15625000f,0.53125000f,-0.75000000f,-0.50000000f,0.42187500f,-0.75000000f,0.43750000f,0.87500000f,0.57812500f,-0.10937500f,-0.81250000f,0.20312500f,-0.67187500f,-0.43750000f,-0.14062500f,0.21875000f,-0.81250000f,0.50000000f,0.59375000f,-0.32812500f,-0.60937500f,0.57812500f,0.46875000f,0.28125000f,-0.31250000f,1.00000000f,-0.31250000f,0.32812500f,0.98437500f,0.82812500f,-0.73437500f,0.07812500f,-1.00000000f,-1.00000000f,0.15625000f,0.45312500f,0.09375000f,0.60937500f,0.28125000f,-0.92187500f,-0.60937500f,0.42187500f,-0.85937500f,0.09375000f,-0.42187500f,-0.90625000f,0.96875000f,-0.50000000f,-0.39062500f,-0.12500000f,0.10937500f,-0.76562500f,0.71875000f,0.62500000f,0.71875000f,0.29687500f,0.14062500f,0.39062500f,0.89062500f,-0.01562500f,0.42187500f,0.39062500f,-0.48437500f,-0.46875000f,-0.34375000f,0.59375000f,-0.79687500f,0.06250000f,0.57812500f,0.26562500f,-1.00000000f,0.59375000f,-0.25000000f,-0.42187500f,-0.71875000f,-0.60937500f,0.09375000f,-0.65625000f,-0.20312500f,0.76562500f,-0.56250000f,0.15625000f,0.29687500f,0.60937500f,-0.78125000f,-0.73437500f,-0.26562500f,-0.43750000f,-0.60937500f,-0.20312500f,-0.82812500f,-0.51562500f,-0.92187500f,-0.46875000f,-0.62500000f,0.21875000f,0.04687500f,-0.62500000f,-0.85937500f,-0.98437500f,-0.18750000f,0.40625000f,-0.04687500f,0.48437500f,0.92187500f,0.53125000f,-0.59375000f,-0.42187500f,-0.95312500f,-0.75000000f,-0.04687500f,0.98437500f,0.92187500f,-0.39062500f,0.82812500f,0.20312500f,0.45312500f,-0.68750000f,0.54687500f,0.39062500f,0.84375000f,-0.90625000f,-0.35937500f,-0.07812500f,0.73437500f,-0.53125000f,-0.06250000f,-0.18750000f,-0.04687500f,-0.84375000f,0.65625000f,0.70312500f,-0.93750000f,0.76562500f,0.68750000f,0.39062500f,0.10937500f,-0.70312500f,-0.34375000f,-0.21875000f,0.32812500f,0.43750000f,-0.48437500f,0.37500000f,-0.20312500f,-0.85937500f,-0.90625000f,0.25000000f,-0.76562500f,-0.59375000f,-0.21875000f,0.82812500f,0.53125000f,-0.35937500f,0.01562500f,-0.43750000f,0.81250000f,0.25000000f,-0.32812500f,-0.21875000f,-0.42187500f,-0.23437500f,-0.34375000f,0.25000000f,-0.81250000f,-0.31250000f,0.71875000f,0.64062500f,-0.71875000f,0.76562500f,0.26562500f,0.01562500f,0.46875000f,0.82812500f,0.81250000f,-0.96875000f,0.96875000f,0.85937500f,0.82812500f,0.85937500f,-0.89062500f,0.18750000f,-0.87500000f,-0.78125000f,-0.59375000f,-0.84375000f,-0.57812500f,-0.21875000f,-0.10937500f,0.93750000f,0.20312500f,0.32812500f,0.04687500f,-0.18750000f,0.60937500f,0.31250000f,0.23437500f,0.03125000f,0.68750000f,-0.32812500f,-0.89062500f,-0.23437500f,-0.67187500f,0.15625000f,0.73437500f,-0.48437500f,0.56250000f,0.31250000f,0.39062500f,-0.65625000f,-0.67187500f,-0.90625000f,-0.43750000f,0.98437500f,-0.25000000f,-0.50000000f,-0.78125000f,0.06250000f,0.32812500f,-0.45312500f,-0.12500000f,0.17187500f,0.92187500f,-0.31250000f,0.01562500f,-0.70312500f,0.76562500f,0.53125000f,0.06250000f,0.95312500f,-0.46875000f,-0.39062500f,1.00000000f,0.59375000f,-0.20312500f,0.93750000f,-0.92187500f,-0.68750000f,-0.28125000f,0.18750000f,0.71875000f,0.18750000f,0.25000000f,-0.48437500f,0.01562500f,0.35937500f,0.48437500f,-0.54687500f,0.29687500f,0.73437500f,-0.51562500f,0.57812500f,-0.26562500f,0.46875000f,0.62500000f,0.62500000f,0.81250000f,0.17187500f,0.28125000f,-0.75000000f,-0.45312500f,-0.29687500f,0.37500000f,-0.71875000f,0.71875000f,0.93750000f,-0.42187500f,0.31250000f,-0.26562500f,0.81250000f,-0.15625000f,-0.62500000f,0.53125000f,0.12500000f,0.60937500f,0.60937500f,-0.04687500f,-0.90625000f,0.40625000f,0.12500000f,0.89062500f,0.09375000f,-0.14062500f,0.29687500f,-0.03125000f,-0.62500000f,0.17187500f,-0.67187500f,0.79687500f,0.53125000f,0.54687500f,-0.54687500f,0.71875000f,-0.03125000f,-0.14062500f,-0.56250000f,0.15625000f,0.90625000f,0.65625000f,0.00000000f,-0.35937500f,0.43750000f,-0.40625000f,0.57812500f,-0.25000000f,0.03125000f,0.04687500f,-0.42187500f,0.76562500f,0.85937500f,0.81250000f,-0.87500000f,-0.85937500f,0.14062500f,0.26562500f,0.03125000f,0.28125000f,0.17187500f,-0.50000000f,0.53125000f,-0.32812500f,-0.15625000f,0.18750000f,-0.92187500f,0.59375000f,0.34375000f,0.85937500f,-0.73437500f,0.28125000f,0.37500000f,0.62500000f,-0.92187500f,-0.09375000f,-0.31250000f,-0.51562500f,-0.68750000f,0.45312500f,0.01562500f,0.10937500f,0.42187500f,-0.15625000f,-0.28125000f,0.75000000f,-0.20312500f,0.45312500f,-0.85937500f,-0.85937500f,-0.23437500f,-0.54687500f,-0.51562500f,-0.71875000f,0.82812500f,0.93750000f,-0.62500000f,0.48437500f,-0.18750000f,0.60937500f,-0.39062500f,-0.21875000f,-0.79687500f,0.14062500f,0.93750000f,-0.32812500f,0.29687500f,0.15625000f,0.26562500f,-0.43750000f,-0.21875000f,0.28125000f,-0.17187500f,0.07812500f,0.31250000f,-0.68750000f,-0.03125000f,-0.14062500f,0.29687500f,0.01562500f,-0.90625000f,0.26562500f,0.26562500f,0.95312500f,0.81250000f,-0.03125000f,0.73437500f,0.06250000f,0.64062500f,-0.56250000f,-0.87500000f,0.65625000f,-0.85937500f,0.67187500f,-0.34375000f,-0.23437500f,-0.01562500f,-0.14062500f,0.78125000f,0.00000000f,-0.62500000f,0.62500000f,0.45312500f,-0.37500000f,0.32812500f,0.53125000f,0.85937500f,0.59375000f,0.98437500f,0.10937500f,0.32812500f,0.73437500f,-0.01562500f,-0.34375000f,-0.45312500f,-0.34375000f,-0.68750000f,-0.09375000f,-0.45312500f,0.23437500f,-0.14062500f,-0.21875000f,-0.70312500f,-0.26562500f,-0.35937500f,-0.14062500f,0.75000000f,-0.45312500f,-0.68750000f,-0.56250000f,0.03125000f,-0.71875000f,-0.09375000f,0.42187500f,0.68750000f,0.56250000f,0.34375000f,-0.32812500f,-0.29687500f,0.73437500f,0.18750000f,-0.23437500f,-0.25000000f,0.57812500f,-0.70312500f,0.90625000f,-0.78125000f,-0.57812500f,-0.75000000f,-0.70312500f,0.50000000f,-0.40625000f,-0.87500000f,0.28125000f,0.68750000f,-0.03125000f,-0.15625000f,-0.68750000f,-0.62500000f,-0.84375000f,-0.03125000f,0.98437500f,0.64062500f,-0.07812500f,-0.53125000f,0.92187500f,-0.78125000f,-0.23437500f,0.84375000f,-0.37500000f,-0.31250000f,-0.28125000f,-0.10937500f,0.76562500f,0.34375000f,0.92187500f,0.82812500f,-0.35937500f,-0.84375000f,-0.04687500f,-0.53125000f,-0.87500000f,0.81250000f,-0.53125000f,-0.39062500f,0.64062500f,0.04687500f,0.65625000f,0.31250000f,-0.46875000f,0.35937500f,0.15625000f,0.42187500f,-0.51562500f,0.64062500f,0.59375000f,-0.10937500f,-0.56250000f,-0.82812500f,-0.17187500f,-0.89062500f,-0.79687500f,-0.70312500f,-0.96875000f,-0.85937500f,0.57812500f,-0.29687500f,-0.34375000f,-0.14062500f,0.28125000f,0.04687500f,-0.81250000f,-0.17187500f,0.68750000f,0.56250000f,0.37500000f,0.50000000f,0.57812500f,0.62500000f,-0.46875000f,-0.76562500f,0.42187500f,0.76562500f,-0.45312500f,0.28125000f,-0.95312500f,-0.21875000f,-0.98437500f,-0.31250000f,-0.68750000f,0.62500000f,-0.23437500f,0.92187500f,0.65625000f,0.10937500f,-0.12500000f,0.93750000f,-0.53125000f,-0.87500000f,0.53125000f,-0.50000000f,-0.75000000f,0.54687500f,-0.17187500f,-0.81250000f,-0.39062500f,-0.17187500f,-0.31250000f,-0.39062500f,0.70312500f,0.25000000f,0.78125000f,0.85937500f,-0.87500000f,-0.98437500f,-0.10937500f,0.32812500f,0.21875000f,-0.46875000f,-0.28125000f,-0.28125000f,0.32812500f,-0.10937500f,-0.21875000f,-0.71875000f,0.79687500f,0.14062500f,0.68750000f,0.78125000f,0.56250000f,0.40625000f,0.32812500f,-0.51562500f,0.40625000f,0.12500000f,0.54687500f,0.42187500f,-0.82812500f,0.68750000f,0.07812500f,-0.73437500f,0.87500000f,0.68750000f,-0.96875000f,0.40625000f,0.95312500f,0.62500000f,0.20312500f,0.73437500f,0.79687500f,0.32812500f,-0.85937500f,0.10937500f,-0.95312500f,-0.73437500f,0.51562500f,0.46875000f,0.51562500f,-0.95312500f,0.34375000f,-0.46875000f,-0.40625000f,0.15625000f,-0.93750000f,0.42187500f,0.59375000f,0.12500000f,0.57812500f,-0.06250000f,0.62500000f,-0.43750000f,0.79687500f,-0.81250000f,-0.40625000f,-0.71875000f,-0.56250000f,-0.70312500f,-0.15625000f,-0.85937500f,0.93750000f,0.53125000f,-0.21875000f,-0.07812500f,-0.75000000f,0.43750000f,-0.96875000f,0.14062500f,-0.64062500f,-0.15625000f,-0.34375000f,-0.29687500f,0.40625000f,-0.03125000f,0.03125000f,-0.50000000f,0.75000000f,-0.48437500f,0.14062500f,0.45312500f,-0.40625000f,0.39062500f,0.65625000f,-0.23437500f,-0.98437500f,0.12500000f,0.62500000f,0.29687500f,-0.50000000f,0.10937500f,-0.75000000f,0.75000000f,-0.26562500f,-0.20312500f,-0.42187500f,0.07812500f,0.67187500f,0.37500000f,-0.14062500f,0.04687500f,0.54687500f,0.09375000f,-0.68750000f,0.60937500f,0.60937500f,-0.60937500f,0.67187500f,-0.31250000f,0.37500000f,0.93750000f,-0.32812500f,-0.51562500f,-0.96875000f,0.96875000f,1.00000000f,0.10937500f,0.95312500f,-0.42187500f,0.65625000f,0.25000000f,-0.18750000f,-0.42187500f,0.64062500f,-0.10937500f,-0.45312500f,-0.96875000f,0.32812500f,0.00000000f,0.35937500f,0.48437500f,-0.20312500f,-0.40625000f,0.12500000f,-0.06250000f,0.62500000f,0.45312500f,0.06250000f,-0.29687500f,0.50000000f,-0.06250000f,-0.39062500f,-0.40625000f,-1.00000000f,0.67187500f,0.45312500f,-0.68750000f,0.26562500f,0.48437500f,0.18750000f,-0.96875000f,0.67187500f,-0.98437500f,0.98437500f,0.17187500f,0.76562500f,-0.26562500f,-0.60937500f,0.40625000f,0.48437500f,0.46875000f,0.48437500f,0.68750000f,0.89062500f,0.39062500f,0.18750000f,0.06250000f,-0.95312500f,0.46875000f,0.23437500f,-0.73437500f,-0.98437500f,0.06250000f,-0.68750000f,-0.20312500f,0.65625000f,0.96875000f,0.25000000f,0.42187500f,-0.01562500f,0.43750000f,0.89062500f,0.00000000f,0.87500000f,0.57812500f,0.42187500f,0.56250000f,-0.20312500f,0.42187500f,0.76562500f,-0.67187500f,0.89062500f,-0.12500000f,-0.04687500f,0.40625000f,-0.70312500f,0.26562500f,-0.09375000f,0.87500000f,-1.00000000f,-0.78125000f,0.48437500f,-0.84375000f,-0.79687500f,0.90625000f,-0.89062500f,-0.46875000f,0.07812500f,0.23437500f,-0.18750000f,-0.51562500f,-0.39062500f,0.29687500f,0.35937500f,0.82812500f,-0.37500000f,0.40625000f,-0.60937500f,0.06250000f,-0.67187500f,0.68750000f,0.12500000f,-0.56250000f,0.50000000f,-0.43750000f,0.10937500f,0.42187500f,-0.84375000f,0.56250000f,-0.28125000f,-0.50000000f,0.50000000f,-0.96875000f,0.98437500f,-0.07812500f,0.62500000f,0.17187500f,0.71875000f,-0.26562500f,-0.07812500f,-0.42187500f,0.87500000f,-0.56250000f,-0.67187500f,0.78125000f,-0.78125000f,0.82812500f,0.14062500f,-0.92187500f,0.01562500f,0.95312500f,-0.54687500f,-0.46875000f,-0.17187500f,0.85937500f,0.00000000f,0.18750000f,-0.48437500f,0.98437500f,-0.51562500f,-0.68750000f,0.81250000f,-0.82812500f,-0.12500000f,0.04687500f,-0.45312500f,-0.48437500f,-0.32812500f,-0.56250000f,-0.20312500f,0.67187500f,-0.17187500f,-0.51562500f,-0.48437500f,0.07812500f,-0.56250000f,-0.67187500f,0.18750000f,1.00000000f,-0.21875000f,-0.12500000f,-0.07812500f,0.51562500f,-0.10937500f,-0.18750000f,-0.82812500f,0.70312500f,1.00000000f,0.25000000f,-0.39062500f,-0.20312500f,0.21875000f,0.39062500f,-0.40625000f,-0.73437500f,0.46875000f,-0.95312500f,-0.31250000f,-0.64062500f,-0.48437500f,0.23437500f,-0.23437500f,-0.21875000f,0.90625000f,-0.87500000f,-0.06250000f,0.79687500f,0.35937500f,0.67187500f,0.12500000f,-0.71875000f,0.75000000f,-0.78125000f,0.37500000f,0.73437500f,-0.79687500f,0.84375000f,-0.79687500f,0.29687500f,-0.42187500f,0.60937500f,0.23437500f,0.67187500f,0.01562500f,-0.68750000f,-0.09375000f,-0.96875000f,0.01562500f,-0.60937500f,0.35937500f,-0.46875000f,-0.34375000f,0.95312500f,-1.00000000f,0.54687500f,0.84375000f,-0.50000000f,-0.57812500f,-0.15625000f,0.53125000f,-0.40625000f,-0.31250000f,0.26562500f,-0.26562500f,-0.85937500f,-0.06250000f,-0.93750000f,-0.96875000f,0.31250000f,-0.59375000f,0.87500000f,0.98437500f,0.82812500f,-0.23437500f,-0.10937500f,0.45312500f,0.73437500f,-0.90625000f,0.64062500f,-0.81250000f,0.79687500f,-0.79687500f,0.71875000f,-0.78125000f,-0.76562500f,0.48437500f,0.18750000f,0.09375000f,-0.06250000f,-0.65625000f,-0.67187500f,0.21875000f,-1.00000000f,-0.89062500f,0.01562500f,-0.75000000f,-0.18750000f,0.57812500f,-0.45312500f,0.17187500f,0.81250000f,0.65625000f,-0.26562500f,-0.90625000f,-0.78125000f,0.82812500f,-0.78125000f,0.07812500f,0.39062500f,0.75000000f,-0.76562500f,0.71875000f,-0.98437500f,-0.51562500f,0.78125000f,-0.46875000f,0.90625000f,-0.57812500f,0.09375000f,-0.81250000f,-0.10937500f,-0.96875000f,-0.68750000f,-0.87500000f,-0.15625000f,-0.17187500f,-0.35937500f,-0.23437500f,-0.98437500f,1.00000000f,0.96875000f,-0.50000000f,0.95312500f,-0.14062500f,-0.93750000f,0.73437500f,-0.59375000f,-0.45312500f,0.18750000f,-0.93750000f,-0.64062500f,-0.89062500f,-0.23437500f,0.76562500f,-0.54687500f,-0.42187500f,0.78125000f,-0.60937500f,0.65625000f,-0.51562500f,-0.95312500f,0.46875000f,0.14062500f,-0.31250000f,-0.96875000f,-0.92187500f,-0.65625000f,0.10937500f,-0.84375000f,-0.70312500f,0.76562500f,0.18750000f,0.84375000f,-1.00000000f,0.90625000f,0.15625000f,-0.93750000f,-0.98437500f,0.59375000f,0.56250000f,-0.93750000f,-0.62500000f,0.07812500f,0.48437500f,-0.56250000f,-0.34375000f,-0.84375000f,-0.56250000f,-0.42187500f,0.75000000f,-0.54687500f,-0.18750000f,0.92187500f,-0.85937500f,0.45312500f,0.78125000f,-0.92187500f,-0.89062500f,-0.95312500f,-0.35937500f,-0.35937500f,0.84375000f,0.60937500f,-0.64062500f,-0.56250000f,0.15625000f,0.54687500f,0.00000000f,0.90625000f,0.43750000f,0.92187500f,0.81250000f,-0.79687500f,0.79687500f,0.60937500f,-0.76562500f,0.53125000f,0.67187500f,0.93750000f,-0.46875000f,0.00000000f,0.57812500f,-0.32812500f,-0.82812500f,0.42187500f,-0.21875000f,-0.09375000f,0.92187500f,-0.98437500f,-0.95312500f,0.06250000f,0.59375000f,0.89062500f,0.32812500f,0.59375000f,0.45312500f,-0.57812500f,-0.09375000f,0.43750000f,-0.32812500f,0.37500000f,-0.06250000f,0.87500000f,0.68750000f,0.59375000f,0.79687500f,0.85937500f,0.35937500f,0.68750000f,0.89062500f,0.57812500f,-0.12500000f,0.20312500f,0.48437500f,-0.84375000f,-0.95312500f,0.68750000f,0.65625000f,-0.87500000f,0.82812500f,0.23437500f,0.15625000f,0.32812500f,0.64062500f,-0.26562500f,-0.39062500f,0.45312500f,-0.85937500f,-0.70312500f,-0.31250000f,-0.64062500f,0.34375000f,0.23437500f,-0.71875000f,0.51562500f,0.37500000f,-0.39062500f,0.04687500f,0.25000000f,0.98437500f,-0.56250000f,0.67187500f,0.04687500f,-0.76562500f,-0.45312500f,0.15625000f,0.75000000f,-0.23437500f,-0.98437500f,0.54687500f,-0.79687500f,-0.64062500f,-0.50000000f,-0.84375000f,0.78125000f,-0.31250000f,0.79687500f,0.31250000f,0.34375000f,0.64062500f,0.59375000f,0.07812500f,0.68750000f,0.06250000f,-0.09375000f,0.01562500f,-0.35937500f,-0.37500000f,-0.46875000f,0.18750000f,0.53125000f,-0.35937500f,-0.98437500f,0.51562500f,-0.28125000f,0.95312500f,0.28125000f,0.46875000f,0.00000000f,-0.34375000f,-0.64062500f,0.18750000f,0.48437500f,-0.32812500f,-0.23437500f,-0.31250000f,-0.28125000f,-0.70312500f,0.25000000f,0.56250000f,-0.17187500f,-0.06250000f,0.39062500f,-0.84375000f,-0.85937500f,0.57812500f,-0.31250000f,0.48437500f,1.00000000f,0.57812500f,-1.00000000f,0.60937500f,0.84375000f,-0.62500000f,0.64062500f,0.07812500f,-0.98437500f,-0.12500000f,-0.85937500f,-0.53125000f,-0.62500000f,-0.79687500f,0.60937500f,0.31250000f,0.25000000f,0.20312500f,0.26562500f,-0.89062500f,0.15625000f,0.68750000f,0.68750000f,0.42187500f,-0.79687500f,0.34375000f,0.67187500f,-0.42187500f,0.84375000f,-0.42187500f,0.70312500f,0.10937500f,0.92187500f,0.29687500f,0.87500000f,-0.79687500f,0.29687500f,-0.09375000f,-0.14062500f,-0.35937500f,0.92187500f,0.03125000f,-0.12500000f,0.92187500f,-0.92187500f,-0.14062500f,-0.15625000f,0.87500000f,-0.71875000f,-0.42187500f,-0.17187500f,-0.87500000f,0.50000000f,0.15625000f,0.42187500f,0.03125000f,0.54687500f,-0.90625000f,0.06250000f,0.12500000f,-0.75000000f,0.06250000f,0.39062500f,-0.81250000f,0.03125000f,-0.50000000f,-0.21875000f,0.64062500f,0.67187500f,-0.67187500f,-0.62500000f,-0.40625000f,-0.04687500f,-0.76562500f,0.81250000f,0.53125000f,-0.43750000f,-0.37500000f,-0.59375000f,-0.57812500f,-0.50000000f,0.15625000f,0.92187500f,-0.23437500f,0.25000000f,-0.53125000f,-0.84375000f,-0.35937500f,-1.00000000f,0.75000000f,0.14062500f,0.34375000f,0.39062500f,0.67187500f,-0.42187500f,-0.82812500f,-0.45312500f,0.98437500f,-0.35937500f,0.81250000f,-0.56250000f,0.76562500f,0.67187500f,-0.81250000f,0.20312500f,-0.67187500f,-0.10937500f,-0.57812500f,-0.95312500f,-0.54687500f,0.23437500f,-0.20312500f,-0.20312500f,-0.04687500f,-0.93750000f,-0.75000000f,-0.32812500f,0.62500000f,0.15625000f,0.51562500f,-0.98437500f,0.32812500f,0.18750000f,0.03125000f,-0.23437500f,0.67187500f,-0.39062500f,-0.60937500f,-0.48437500f,0.92187500f,0.90625000f,0.00000000f,-0.64062500f,0.03125000f,-0.84375000f,0.12500000f,0.57812500f,0.04687500f,-1.00000000f,-0.43750000f,0.03125000f,0.06250000f,0.45312500f,0.67187500f,0.06250000f,-0.43750000f,-0.25000000f,-0.48437500f,0.01562500f,0.31250000f,0.75000000f,0.46875000f,0.37500000f,-0.40625000f,0.57812500f,0.98437500f,-0.65625000f,-0.17187500f,-0.84375000f,-0.23437500f,0.20312500f,0.81250000f,-0.37500000f,0.48437500f,-0.87500000f,-0.54687500f,0.34375000f,-1.00000000f,-0.06250000f,0.31250000f,0.57812500f,0.35937500f,0.37500000f,-0.20312500f,-0.18750000f,-0.85937500f,0.53125000f,0.48437500f,0.29687500f,-0.73437500f,-0.14062500f,0.28125000f,0.20312500f,0.98437500f,0.12500000f,-0.64062500f,0.18750000f,-0.15625000f,0.31250000f,0.03125000f,0.03125000f,-0.76562500f,-0.81250000f,0.15625000f,0.20312500f,0.95312500f,-0.31250000f,0.20312500f,-0.62500000f,-0.73437500f,-0.92187500f,0.93750000f,-0.79687500f,0.14062500f,0.64062500f,-0.32812500f,0.29687500f,0.20312500f,0.71875000f,0.12500000f,-0.90625000f,0.39062500f,0.25000000f,0.95312500f,-0.51562500f,0.73437500f,0.04687500f,-0.78125000f,-0.34375000f,0.09375000f,-0.28125000f,-0.07812500f,-0.50000000f,0.87500000f,0.93750000f,-0.12500000f,0.53125000f,0.70312500f,0.37500000f,0.10937500f,-0.12500000f,0.12500000f,-0.01562500f,-0.01562500f,0.54687500f,-0.26562500f,0.20312500f,0.40625000f,0.70312500f,-0.53125000f,-0.40625000f,0.64062500f,0.21875000f,-0.04687500f,-0.39062500f,0.25000000f,0.37500000f,0.76562500f,-0.46875000f,-0.26562500f,-0.82812500f,-0.31250000f,-0.23437500f,-0.95312500f,-0.84375000f,-0.15625000f,-0.09375000f,-0.98437500f,0.46875000f,-0.62500000f,0.84375000f,0.92187500f,0.01562500f,-0.17187500f,0.64062500f,-0.68750000f,-0.25000000f,0.90625000f,0.79687500f,-0.68750000f,-0.42187500f,0.65625000f,0.98437500f,0.31250000f,-0.43750000f,-0.14062500f,0.26562500f,0.90625000f,0.31250000f,0.40625000f,0.95312500f,-0.43750000f,0.70312500f,-0.81250000f,0.75000000f,0.34375000f,-0.59375000f,-0.15625000f,0.04687500f,0.89062500f,0.57812500f,-0.35937500f,-0.68750000f,0.82812500f,-0.87500000f,0.21875000f,-0.53125000f,0.54687500f,-0.28125000f,-0.45312500f,0.96875000f,0.93750000f,0.15625000f,-0.32812500f,-0.10937500f,-0.09375000f,-0.68750000f,0.21875000f,-0.87500000f,-0.82812500f,0.01562500f,-0.89062500f,0.32812500f,0.35937500f,0.21875000f,0.82812500f,-0.21875000f,0.42187500f,-0.21875000f,0.93750000f,0.51562500f,-0.65625000f,-0.89062500f,-0.75000000f,-0.64062500f,-0.81250000f,0.92187500f,-0.56250000f,0.43750000f,0.84375000f,0.76562500f,0.37500000f,0.60937500f,0.23437500f,-0.60937500f,-0.98437500f,0.21875000f,0.15625000f,0.23437500f,-0.82812500f,0.92187500f,-0.85937500f,0.76562500f,-0.28125000f,0.48437500f,0.18750000f,-0.54687500f,0.68750000f,0.09375000f,0.20312500f,-0.76562500f,-0.78125000f,1.00000000f,0.48437500f,0.50000000f,-0.67187500f,-0.42187500f,0.75000000f,0.20312500f,0.76562500f,0.31250000f,0.06250000f,-0.07812500f,-0.71875000f,0.96875000f,0.45312500f,0.00000000f,0.01562500f,0.48437500f,0.57812500f,-0.32812500f,-0.93750000f,0.48437500f,0.20312500f,-0.87500000f,-0.73437500f,-0.62500000f,-0.82812500f,-0.84375000f,-0.46875000f,0.42187500f,0.23437500f,-0.35937500f,0.09375000f,0.60937500f,-0.96875000f,-0.12500000f,-0.46875000f,-0.31250000f,0.07812500f,-0.46875000f,0.93750000f,-0.20312500f,0.75000000f,-0.81250000f,0.76562500f,0.70312500f,0.53125000f,-0.04687500f,0.00000000f,-0.76562500f,0.85937500f,-0.06250000f,0.84375000f,-0.67187500f,-0.59375000f,-0.90625000f,0.00000000f,-0.29687500f,0.81250000f,0.79687500f,-0.76562500f,-0.87500000f,0.34375000f,-0.76562500f,-0.14062500f,-0.87500000f,0.78125000f,-0.51562500f,0.96875000f,0.18750000f,0.32812500f,-1.00000000f,0.92187500f,-0.32812500f,-0.18750000f,-0.35937500f,-0.03125000f,-0.23437500f,0.39062500f,-0.23437500f,-0.89062500f,-0.79687500f,-0.89062500f,-1.00000000f,-0.12500000f,0.18750000f,0.90625000f,0.56250000f,-0.98437500f,-0.65625000f,0.65625000f,0.28125000f,0.32812500f,0.76562500f,0.96875000f,-0.31250000f,0.12500000f,0.90625000f,0.34375000f,0.42187500f,-0.39062500f,0.53125000f,0.70312500f,0.07812500f,0.46875000f,-0.42187500f,0.50000000f,0.28125000f,0.23437500f,0.70312500f,0.10937500f,-0.45312500f,0.31250000f,0.15625000f,-0.71875000f,-0.76562500f,-0.57812500f,0.75000000f,0.92187500f,0.14062500f,0.46875000f,0.06250000f,0.25000000f,-0.31250000f,-0.59375000f,0.03125000f,0.37500000f,-0.35937500f,0.90625000f,0.23437500f,-0.96875000f,-0.87500000f,0.70312500f,0.95312500f,-0.29687500f,-0.09375000f,-0.39062500f,-0.31250000f,-0.50000000f,-0.53125000f,-0.95312500f,-0.23437500f,-0.01562500f,-0.53125000f,-0.71875000f,-0.56250000f,-0.54687500f,-0.98437500f,-0.21875000f,-0.46875000f,0.98437500f,0.46875000f,0.20312500f,-0.45312500f,-0.32812500f,0.64062500f,-0.76562500f,-0.43750000f,0.56250000f,0.35937500f,-0.76562500f,0.60937500f,0.68750000f,0.96875000f,-0.50000000f,0.48437500f,-0.87500000f,-0.29687500f,-0.01562500f,0.93750000f,0.81250000f,-0.32812500f,0.93750000f,0.79687500f,-0.45312500f,0.64062500f,0.48437500f,-0.87500000f,-0.67187500f,0.78125000f,0.43750000f,-0.15625000f,-0.85937500f,0.42187500f,-0.42187500f,-0.31250000f,0.60937500f,0.12500000f,-0.85937500f,0.34375000f,0.25000000f,-0.85937500f,-0.45312500f,-0.56250000f,-0.84375000f,-0.28125000f,0.87500000f,-0.14062500f,0.95312500f,-0.59375000f,0.43750000f,0.90625000f,-1.00000000f,0.04687500f,-0.60937500f,-0.54687500f,-0.15625000f,0.51562500f,-0.29687500f,-0.40625000f,0.81250000f,-0.67187500f,-0.51562500f,0.15625000f,-0.79687500f,0.04687500f,0.71875000f,-0.79687500f,-0.70312500f,-0.89062500f,0.18750000f,-1.00000000f,-0.98437500f,-0.04687500f,-0.46875000f,-0.09375000f,-0.62500000f,-0.48437500f,-0.29687500f,0.96875000f,0.71875000f,-0.46875000f,0.45312500f,-0.79687500f,0.23437500f,-0.23437500f,0.25000000f,0.20312500f,0.71875000f,-0.20312500f,-0.43750000f,0.48437500f,0.31250000f,-0.89062500f,-0.15625000f,0.98437500f,-0.15625000f,0.56250000f,-0.06250000f,0.85937500f,0.82812500f,-0.32812500f,0.40625000f,0.73437500f,-0.53125000f,-0.82812500f,-0.37500000f,0.70312500f,0.31250000f,-0.56250000f,0.28125000f,-0.20312500f,-0.09375000f,0.98437500f,0.70312500f,0.01562500f,0.25000000f,0.10937500f,0.34375000f,0.14062500f,-0.98437500f,0.79687500f,-0.54687500f,-0.12500000f,0.48437500f,-0.95312500f,-0.21875000f,0.25000000f,0.03125000f,-0.28125000f,-0.17187500f,0.20312500f,0.68750000f,0.48437500f,0.00000000f,0.35937500f,-0.73437500f,0.14062500f,-0.40625000f,-0.96875000f,-0.12500000f,0.12500000f,0.23437500f,0.95312500f,0.39062500f,0.25000000f,-0.96875000f,0.73437500f,-0.96875000f,0.18750000f,0.81250000f,0.90625000f,-0.70312500f,0.84375000f,-0.59375000f,0.32812500f,1.00000000f,0.89062500f,-0.57812500f,-0.43750000f,0.37500000f,0.23437500f,-0.57812500f,-0.34375000f,-0.37500000f,0.85937500f,-0.04687500f,0.29687500f,-0.40625000f,-0.65625000f,-0.85937500f,0.07812500f,-0.75000000f,-0.35937500f,-0.34375000f,0.85937500f,0.18750000f,0.78125000f,-0.25000000f,0.37500000f,0.65625000f,0.03125000f,0.64062500f,0.70312500f,0.37500000f,0.14062500f,0.57812500f,0.84375000f,0.89062500f,0.93750000f,0.51562500f,-0.67187500f,0.32812500f,0.12500000f,0.31250000f,0.70312500f,0.81250000f,-0.96875000f,0.07812500f,0.60937500f,-0.32812500f,-0.71875000f,0.14062500f,0.75000000f,-0.35937500f,-0.90625000f,-0.71875000f,-0.23437500f,-0.75000000f,-0.56250000f,-0.95312500f,0.28125000f,-0.62500000f,0.96875000f,0.65625000f,-0.21875000f,0.67187500f,-0.01562500f,0.85937500f,-0.76562500f,0.75000000f,-0.39062500f,0.76562500f,0.03125000f,0.92187500f,-0.50000000f,0.95312500f,-0.87500000f,-0.01562500f,0.06250000f,-0.03125000f,0.35937500f,-0.81250000f,-0.76562500f,0.87500000f,0.07812500f,0.79687500f,0.85937500f,0.14062500f,0.93750000f,-0.29687500f,-0.98437500f,0.84375000f,-0.06250000f,-0.71875000f,0.03125000f,-0.10937500f,0.42187500f,-0.85937500f,-0.40625000f,-0.96875000f,0.28125000f,0.31250000f,0.98437500f,0.29687500f,-0.46875000f,0.57812500f,-0.54687500f,0.78125000f,0.64062500f,-0.18750000f,0.14062500f,-0.81250000f,-0.75000000f,0.00000000f,-0.56250000f,0.98437500f,0.57812500f,-0.34375000f,0.84375000f,-0.32812500f,-0.57812500f,0.57812500f,0.57812500f,-0.15625000f,-0.15625000f,-0.65625000f,0.73437500f,0.71875000f,-0.04687500f,0.64062500f,-0.71875000f,-0.95312500f,-0.53125000f,-0.64062500f,-0.78125000f,-0.53125000f,-0.34375000f,0.21875000f,0.15625000f,0.21875000f,-0.35937500f,0.71875000f,0.70312500f,-0.07812500f,0.15625000f,0.45312500f,-0.70312500f,0.40625000f,-0.60937500f,-0.95312500f,0.71875000f,-0.60937500f,-0.90625000f,-0.14062500f,0.15625000f,0.75000000f,0.67187500f,-0.67187500f,0.89062500f,-0.82812500f,0.01562500f,-0.54687500f,0.48437500f,0.64062500f,-0.92187500f,0.35937500f,0.62500000f,0.35937500f,0.75000000f,0.29687500f,0.04687500f,-0.64062500f,-0.96875000f,0.29687500f,-0.42187500f,0.90625000f,-0.42187500f,-0.70312500f,0.07812500f,0.73437500f,0.89062500f,-0.70312500f,0.00000000f,-0.70312500f,0.64062500f,0.67187500f,0.43750000f,-0.90625000f,-0.46875000f,0.84375000f,0.01562500f,0.85937500f,-0.23437500f,0.75000000f,-0.23437500f,0.87500000f,-0.39062500f,0.12500000f,0.06250000f,-0.12500000f,-0.71875000f,0.71875000f,-0.48437500f,0.67187500f,0.79687500f,0.01562500f,-0.50000000f,-0.81250000f,0.12500000f,0.15625000f,0.82812500f,0.15625000f,-1.00000000f,0.07812500f,-0.46875000f,0.07812500f,0.85937500f,-0.17187500f,0.50000000f,0.23437500f,-0.26562500f,0.53125000f,-0.40625000f,0.65625000f,0.45312500f,1.00000000f,0.31250000f,-0.51562500f,0.43750000f,0.90625000f,-0.23437500f,0.96875000f,0.85937500f,-0.73437500f,-0.03125000f,0.92187500f,0.54687500f,0.15625000f,-0.57812500f,-0.51562500f,-0.18750000f,-0.92187500f,0.06250000f,0.20312500f,-0.98437500f,0.79687500f,0.82812500f,0.09375000f,0.76562500f,-0.85937500f,0.10937500f,0.10937500f,-0.92187500f,0.45312500f,-0.39062500f,0.01562500f,-0.60937500f,0.79687500f,0.21875000f,-0.50000000f,0.39062500f,-0.35937500f,0.03125000f,0.43750000f,0.14062500f,0.70312500f,0.81250000f,-0.64062500f,-0.25000000f,0.59375000f,0.96875000f,-0.45312500f,-0.89062500f,0.51562500f,0.46875000f,-0.18750000f,0.59375000f,0.75000000f,0.26562500f,0.54687500f,-0.56250000f,-0.23437500f,-0.73437500f,-0.37500000f,0.67187500f,-0.03125000f,-0.29687500f,-0.26562500f,-0.79687500f,0.51562500f,-0.23437500f,-0.53125000f,0.90625000f,-0.59375000f,-0.10937500f,0.78125000f,0.40625000f,-0.85937500f,0.23437500f,0.62500000f,0.71875000f,-0.75000000f,-0.59375000f,0.62500000f,-1.00000000f,0.90625000f,-0.65625000f,-0.71875000f,-0.95312500f,0.25000000f,-0.23437500f,0.23437500f,-0.92187500f,0.07812500f,-0.10937500f,0.43750000f,0.35937500f,-0.10937500f,0.89062500f,-0.09375000f,0.03125000f,-0.92187500f,0.45312500f,0.34375000f,-0.23437500f,0.56250000f,0.28125000f,0.23437500f,-0.32812500f,-0.82812500f,-0.42187500f,-0.53125000f,-0.95312500f,-0.32812500f,0.53125000f,0.29687500f,0.18750000f,-0.14062500f,-0.93750000f,-0.07812500f,-0.06250000f,-0.17187500f,0.42187500f,0.32812500f,-0.39062500f,0.46875000f,0.35937500f,0.67187500f,0.23437500f,0.76562500f,-0.07812500f,-0.25000000f,0.78125000f,-0.64062500f,-0.43750000f,-0.03125000f,-0.48437500f,-0.81250000f,0.18750000f,0.37500000f,0.35937500f,-0.89062500f,1.00000000f,-0.75000000f,-0.93750000f,-0.76562500f,-0.31250000f,-0.93750000f,-0.14062500f,-0.81250000f,-0.95312500f,0.98437500f,0.06250000f,0.76562500f,0.35937500f,0.59375000f,-0.79687500f,-0.07812500f,0.59375000f,0.64062500f,-0.90625000f,0.90625000f,-0.29687500f,-0.37500000f,0.96875000f,-0.39062500f,-0.51562500f,-0.10937500f,0.20312500f,-0.70312500f,-0.85937500f,0.79687500f,-0.20312500f,-0.84375000f,0.84375000f,-0.78125000f,-0.10937500f,0.20312500f,0.78125000f,0.78125000f,0.12500000f,0.14062500f,0.50000000f,0.90625000f,-0.34375000f,-0.43750000f,0.90625000f,0.28125000f,-0.73437500f,0.90625000f,-0.79687500f,-0.71875000f,-0.26562500f,0.40625000f,-0.50000000f,-0.04687500f,0.29687500f,-0.71875000f,-0.60937500f,0.34375000f,-0.93750000f,0.79687500f,0.48437500f,-0.65625000f,0.87500000f,-0.89062500f,-0.82812500f,-0.53125000f,0.60937500f,0.48437500f,-0.67187500f,-0.67187500f,-0.79687500f,-0.06250000f,0.98437500f,0.18750000f,0.56250000f,-0.60937500f,0.87500000f,0.93750000f,-0.17187500f,-0.31250000f,0.92187500f,-0.40625000f,0.48437500f,-0.73437500f,-0.32812500f,-0.31250000f,0.64062500f,-0.23437500f,-0.84375000f,-0.29687500f,0.62500000f,0.90625000f,0.15625000f,-0.65625000f,0.71875000f,0.57812500f,0.20312500f,0.43750000f,0.42187500f,-0.04687500f,0.39062500f,-0.51562500f,-0.79687500f,0.07812500f,-0.10937500f,0.92187500f,-0.32812500f,0.15625000f,-0.59375000f,0.03125000f,0.34375000f,0.95312500f,0.31250000f,-0.56250000f,-0.50000000f,0.28125000f,-0.89062500f,0.06250000f,0.56250000f,-0.15625000f,0.32812500f,-0.37500000f,-0.46875000f,-0.31250000f,-0.95312500f,0.15625000f,0.64062500f,0.59375000f,-0.98437500f,-0.51562500f,-0.12500000f,-0.57812500f,0.37500000f,-0.37500000f,-0.56250000f,-0.32812500f,0.93750000f,-0.03125000f,-0.45312500f,0.48437500f,-0.96875000f,0.53125000f,-0.67187500f,1.00000000f,0.14062500f,-0.62500000f,0.54687500f,0.53125000f,-0.18750000f,0.59375000f,-0.67187500f,-0.23437500f,0.03125000f,0.95312500f,0.17187500f,0.64062500f,0.31250000f,0.98437500f,-0.17187500f,-0.82812500f,-0.60937500f,-0.45312500f,0.67187500f,0.54687500f,-0.06250000f,0.71875000f,-0.92187500f,-0.79687500f,-0.68750000f,0.31250000f,0.29687500f,0.07812500f,-0.26562500f,-0.21875000f,-0.14062500f,0.40625000f,-0.10937500f,0.79687500f,-0.28125000f,0.93750000f,0.26562500f,-0.75000000f,-0.32812500f,-0.35937500f,-0.70312500f,0.84375000f,-0.37500000f,-0.07812500f,0.39062500f,-0.84375000f,0.60937500f,0.40625000f,0.50000000f,0.81250000f,0.12500000f,0.82812500f,0.89062500f,0.84375000f,-0.64062500f,0.81250000f,-0.18750000f,0.85937500f,-0.14062500f,0.35937500f,-0.09375000f,-0.60937500f,0.40625000f,-0.14062500f,0.37500000f,0.37500000f,0.84375000f,0.03125000f,0.54687500f,0.60937500f,0.32812500f,-0.53125000f,-0.04687500f,-0.75000000f,0.37500000f,0.59375000f,-0.42187500f,-0.26562500f,-0.25000000f,0.78125000f,0.29687500f,0.04687500f,0.20312500f,0.26562500f,0.35937500f,-0.76562500f,0.81250000f,-0.01562500f,-1.00000000f,0.90625000f,-0.73437500f,-0.29687500f,0.21875000f,0.01562500f,0.00000000f,-0.28125000f,0.85937500f,0.23437500f,0.54687500f,-0.90625000f,0.90625000f,-0.92187500f,-0.85937500f,0.73437500f,-0.34375000f,-0.04687500f,-0.53125000f,0.42187500f,-0.95312500f,0.23437500f,0.12500000f,0.92187500f,0.32812500f,-0.62500000f,-0.45312500f,-0.57812500f,-0.35937500f,0.35937500f,0.84375000f,-0.54687500f,-0.23437500f,-0.84375000f,-0.34375000f,0.20312500f,-0.39062500f,-0.46875000f,-0.43750000f,0.10937500f,-0.95312500f,0.64062500f,-0.32812500f,0.09375000f,0.00000000f,-0.65625000f,0.42187500f,-0.07812500f,-0.54687500f,0.17187500f,0.35937500f,0.28125000f,-0.46875000f,0.45312500f,-0.23437500f,0.12500000f,-0.96875000f,0.84375000f,-0.37500000f,0.31250000f,0.68750000f,-0.01562500f,-0.79687500f,0.85937500f,0.06250000f,-0.06250000f,-0.85937500f,0.54687500f,-0.03125000f,0.37500000f,-0.06250000f,0.40625000f,0.20312500f,-0.59375000f,0.07812500f,-0.87500000f,0.07812500f,0.65625000f,0.17187500f,0.70312500f,-0.03125000f,-0.79687500f,0.01562500f,-0.60937500f,0.35937500f,0.04687500f,0.37500000f,-0.45312500f,-0.82812500f,0.18750000f,-0.37500000f,-0.53125000f,0.00000000f,-0.06250000f,-0.57812500f,0.00000000f,-0.10937500f,-0.45312500f,0.32812500f,0.93750000f,0.48437500f,0.00000000f,-0.96875000f,0.98437500f,0.95312500f,-0.29687500f,0.98437500f,-0.92187500f,0.39062500f,-0.26562500f,-0.73437500f,-0.85937500f,0.12500000f,0.20312500f,0.29687500f,-0.46875000f,0.03125000f,0.25000000f,-0.32812500f,0.68750000f,-0.37500000f,0.39062500f,-0.75000000f,-0.07812500f,-0.48437500f,-0.32812500f,-0.43750000f,-0.75000000f,0.04687500f,0.06250000f,0.07812500f,-0.65625000f,-0.67187500f,-0.85937500f,-0.23437500f,-0.78125000f,0.48437500f,-0.76562500f,0.76562500f,-0.85937500f,0.35937500f,0.42187500f,1.00000000f,0.20312500f,0.84375000f,0.82812500f,-0.15625000f,0.96875000f,0.12500000f,0.82812500f,-0.03125000f,0.10937500f,-0.68750000f,-0.04687500f,-0.59375000f,0.73437500f,0.78125000f,0.81250000f,0.06250000f,-0.20312500f,-0.50000000f,-0.43750000f,-0.04687500f,-0.81250000f,0.96875000f,-0.71875000f,0.95312500f,0.18750000f,-0.62500000f,0.43750000f,0.00000000f,-0.76562500f,0.64062500f,-0.12500000f,-0.73437500f,-0.28125000f,0.64062500f,-0.96875000f,-0.85937500f,0.65625000f,-0.10937500f,-0.54687500f,0.15625000f,-0.39062500f,-0.25000000f,-0.81250000f,0.73437500f,-0.50000000f,-0.32812500f,0.93750000f,0.35937500f,-0.25000000f,0.73437500f,0.34375000f,-0.46875000f,0.57812500f,-0.04687500f,-0.96875000f,-0.92187500f,0.03125000f,-0.68750000f,0.43750000f,0.12500000f,0.68750000f,-0.28125000f,-0.78125000f,-0.17187500f,0.40625000f,0.57812500f,-0.53125000f,0.06250000f,0.87500000f,-0.70312500f,-0.39062500f,0.60937500f,-0.42187500f,0.60937500f,-0.53125000f,0.98437500f,0.17187500f,-0.32812500f,0.93750000f,-0.14062500f,0.56250000f,-0.12500000f,-0.85937500f,-0.23437500f,-0.10937500f,0.06250000f,0.95312500f,-0.59375000f,-0.46875000f,0.92187500f,0.23437500f,0.10937500f,0.98437500f,0.01562500f,-0.32812500f,0.07812500f,0.03125000f,0.09375000f,0.56250000f,0.32812500f,-0.25000000f,-0.60937500f,-0.90625000f,0.14062500f,-0.45312500f,0.42187500f,-0.62500000f,0.12500000f,0.93750000f,0.92187500f,0.26562500f,0.04687500f,-0.26562500f,0.18750000f,0.81250000f,0.26562500f,0.51562500f,0.28125000f,-0.59375000f,0.20312500f,0.17187500f,0.95312500f,-0.71875000f,-0.23437500f,0.68750000f,0.62500000f,-0.51562500f,-0.12500000f,-0.76562500f,0.53125000f,0.37500000f,-0.46875000f,-0.40625000f,0.51562500f,-0.78125000f,-0.42187500f,0.10937500f,-0.87500000f,0.45312500f,0.06250000f,0.84375000f,-0.64062500f,0.17187500f,0.03125000f,0.43750000f,0.73437500f,0.15625000f,0.45312500f,0.39062500f,0.96875000f,0.82812500f,-0.68750000f,0.68750000f,-0.89062500f,-0.46875000f,0.48437500f,-0.21875000f,-0.92187500f,0.20312500f,0.84375000f,0.28125000f,0.56250000f,0.85937500f,0.43750000f,-0.51562500f,0.65625000f,0.65625000f,0.57812500f,0.03125000f,-0.35937500f,-0.35937500f,0.84375000f,0.48437500f,0.03125000f,0.15625000f,-0.32812500f,-0.32812500f,-0.96875000f,0.46875000f,-0.73437500f,-0.39062500f,0.67187500f,-0.90625000f,-0.15625000f,0.06250000f,-0.39062500f,0.12500000f,-0.84375000f,0.59375000f,0.95312500f,-0.75000000f,0.54687500f,-0.17187500f,-0.31250000f,-0.06250000f,0.68750000f,0.26562500f,-0.51562500f,-0.70312500f,-0.09375000f,0.26562500f,-0.56250000f,0.18750000f,0.64062500f,0.48437500f,0.20312500f,-0.65625000f,0.21875000f,1.00000000f,0.15625000f,-1.00000000f,0.07812500f,0.18750000f,0.29687500f,0.79687500f,-0.23437500f,0.03125000f,0.75000000f,0.62500000f,0.32812500f,0.84375000f,-0.59375000f,-0.25000000f,-0.68750000f,0.68750000f,-0.96875000f,0.84375000f,-0.82812500f,0.78125000f,0.34375000f,-0.76562500f,0.28125000f,-0.34375000f,0.29687500f,-0.06250000f,-0.81250000f,-0.45312500f,-0.54687500f,-0.87500000f,0.62500000f,0.28125000f,0.92187500f,-0.89062500f,0.09375000f,0.65625000f,0.73437500f,-0.29687500f,-0.76562500f,0.25000000f,-0.23437500f,0.14062500f,-0.03125000f,0.84375000f,-0.96875000f,-0.82812500f,0.79687500f,-0.26562500f,0.93750000f,-0.12500000f,0.03125000f,-0.32812500f,-1.00000000f,-0.85937500f,-0.45312500f,0.79687500f,0.46875000f,-0.82812500f,-0.84375000f,0.45312500f,0.82812500f,-0.46875000f,-0.09375000f,-0.62500000f,0.14062500f,0.45312500f,-0.89062500f,-0.56250000f,0.54687500f,0.06250000f,-0.53125000f,-0.98437500f,0.59375000f,-0.01562500f,0.78125000f,-0.04687500f,0.03125000f,-0.09375000f,-0.07812500f,0.03125000f,0.48437500f,-0.42187500f,-0.07812500f,0.09375000f,0.29687500f,-0.89062500f,-0.81250000f,0.76562500f,-0.01562500f,0.28125000f,-0.14062500f,-0.09375000f,0.56250000f,0.78125000f,0.96875000f,-0.78125000f,-0.48437500f,-0.65625000f,0.79687500f,-0.59375000f,-0.76562500f,0.07812500f,0.43750000f,-0.45312500f,-0.79687500f,0.09375000f,0.48437500f,-0.04687500f,-0.73437500f,-0.89062500f,0.14062500f,-0.90625000f,0.10937500f,-0.42187500f,-0.56250000f,-0.15625000f,-0.26562500f,-0.40625000f,-0.95312500f,-0.56250000f,0.85937500f,0.64062500f,0.32812500f,-0.68750000f,-0.46875000f,0.92187500f,-0.82812500f,0.59375000f,0.85937500f,-0.18750000f,-0.23437500f,-0.03125000f,-0.67187500f,0.48437500f,0.59375000f,0.95312500f,-0.18750000f,-0.87500000f,0.71875000f,0.35937500f,-0.65625000f,0.39062500f,0.10937500f,0.06250000f,0.56250000f,-0.23437500f,-0.46875000f,-0.20312500f,0.59375000f,0.39062500f,-0.96875000f,-0.26562500f,-0.93750000f,-0.06250000f,0.15625000f,-0.65625000f,0.03125000f,-0.01562500f,-0.51562500f,-0.68750000f,-0.01562500f,0.89062500f,-0.31250000f,0.79687500f,-0.31250000f,0.89062500f,0.31250000f,-0.12500000f,0.18750000f,-0.43750000f,0.62500000f,0.12500000f,-0.82812500f,-0.81250000f,-0.46875000f,-0.51562500f,0.40625000f,-0.07812500f,0.25000000f,-1.00000000f,0.43750000f,0.76562500f,0.60937500f,0.67187500f,0.40625000f,-0.42187500f,-0.73437500f,-0.56250000f,-0.12500000f,-0.50000000f,0.46875000f,0.06250000f,0.87500000f,-0.68750000f,0.65625000f,-0.35937500f,0.51562500f,0.03125000f,-0.54687500f,0.37500000f,-0.78125000f,0.43750000f,0.14062500f,0.15625000f,-0.07812500f,0.25000000f,0.68750000f,0.31250000f,0.37500000f,-0.78125000f,-0.73437500f,-0.68750000f,-0.40625000f,0.95312500f,-0.75000000f,-0.89062500f,-0.73437500f,0.48437500f,-0.17187500f,0.32812500f,0.71875000f,-0.62500000f,-0.25000000f,-0.04687500f,0.28125000f,-0.81250000f,-0.25000000f,0.03125000f,0.29687500f,-0.40625000f,0.64062500f,0.84375000f,-0.40625000f,0.92187500f,-0.35937500f,0.87500000f,0.25000000f,0.34375000f,-0.04687500f,0.85937500f,0.81250000f,0.84375000f,-0.70312500f,0.10937500f,-0.21875000f,-0.48437500f,0.50000000f,-0.29687500f,0.75000000f,-0.50000000f,0.23437500f,0.03125000f,0.37500000f,0.60937500f,0.34375000f,0.79687500f,-0.71875000f,-0.50000000f,0.84375000f,-0.29687500f,0.40625000f,-0.85937500f,-0.29687500f,0.98437500f,0.14062500f,0.48437500f,-0.75000000f,0.18750000f,-0.75000000f,-0.62500000f,-0.18750000f,-0.92187500f,0.81250000f,-0.64062500f,0.71875000f,-0.82812500f,-0.53125000f,-0.70312500f,0.15625000f,-0.53125000f,0.09375000f,-0.45312500f,0.79687500f,0.14062500f,0.96875000f,-0.28125000f,0.32812500f,0.92187500f,0.78125000f,-0.07812500f,0.79687500f,0.85937500f,0.06250000f,0.98437500f,-0.14062500f,-0.53125000f,-0.92187500f,0.01562500f,-0.20312500f,0.25000000f,-0.70312500f,-0.89062500f,0.84375000f,-0.64062500f,0.67187500f,0.75000000f,-0.35937500f,-0.59375000f,0.68750000f,0.71875000f,-0.45312500f,0.45312500f,0.31250000f,0.37500000f,0.53125000f,-0.68750000f,0.12500000f,0.73437500f,-0.67187500f,0.84375000f,0.90625000f,0.01562500f,-0.15625000f,-0.07812500f,-0.73437500f,-0.73437500f,0.54687500f,0.34375000f,-0.68750000f,0.56250000f,-1.00000000f,0.00000000f,0.32812500f,-0.95312500f,0.34375000f,0.43750000f,0.70312500f,-0.93750000f,-0.40625000f,0.00000000f,0.06250000f,0.26562500f,0.20312500f,0.09375000f,-0.15625000f,0.18750000f,-0.51562500f,0.84375000f,0.07812500f,-0.29687500f,-0.03125000f,0.84375000f,0.20312500f,-0.57812500f,0.45312500f,-0.35937500f,-0.54687500f,-0.37500000f,0.43750000f,0.34375000f,0.43750000f,-0.93750000f,-0.18750000f,-0.42187500f,-0.75000000f,-0.15625000f,-0.43750000f,-0.92187500f,-0.12500000f,-0.56250000f,-0.92187500f,0.54687500f,0.84375000f,0.39062500f,0.23437500f,-0.37500000f,0.67187500f,-0.65625000f,0.76562500f,0.92187500f,-0.18750000f,-0.90625000f,-0.34375000f,0.87500000f,-0.46875000f,0.20312500f,-0.67187500f,-0.15625000f,0.75000000f,-0.23437500f,0.40625000f,0.10937500f,0.37500000f,-0.93750000f,-0.75000000f,-0.07812500f,-0.76562500f,-0.95312500f,0.28125000f,-0.26562500f,-0.98437500f,0.04687500f,-0.76562500f,-0.39062500f,-0.03125000f,0.79687500f,0.87500000f,0.96875000f,-0.04687500f,-0.50000000f,0.31250000f,0.06250000f,-0.70312500f,-0.25000000f,-0.12500000f,-0.64062500f,-0.01562500f,0.40625000f,0.62500000f,0.78125000f,-0.10937500f,0.54687500f,0.67187500f,0.73437500f,0.71875000f,-0.76562500f,0.70312500f,0.26562500f,-0.09375000f,0.12500000f,0.26562500f,-0.12500000f,-0.54687500f,0.46875000f,0.25000000f,0.81250000f,0.10937500f,0.78125000f,-0.40625000f,-0.04687500f,0.18750000f,-0.10937500f,0.71875000f,0.03125000f,0.18750000f,0.90625000f,-0.93750000f,-0.87500000f,-0.60937500f,0.84375000f,0.68750000f,0.68750000f,-0.56250000f,0.87500000f,-0.09375000f,-0.23437500f,-0.92187500f,-0.89062500f,-0.59375000f,0.23437500f,0.23437500f,0.64062500f,-0.71875000f,0.65625000f,0.45312500f,-0.25000000f,0.60937500f,0.35937500f,-0.95312500f,1.00000000f,0.60937500f,0.62500000f,0.00000000f,0.85937500f,0.75000000f,0.60937500f,0.76562500f,-0.48437500f,0.73437500f,0.34375000f,-0.04687500f,-0.96875000f,0.81250000f,0.35937500f,0.73437500f,0.04687500f,0.54687500f,-0.14062500f,0.56250000f,-0.62500000f,0.35937500f,-0.06250000f,0.15625000f,0.14062500f,0.06250000f,0.60937500f,-0.17187500f,0.07812500f,0.50000000f,0.65625000f,-0.71875000f,0.53125000f,0.17187500f,-0.45312500f,0.90625000f,0.50000000f,-0.56250000f,0.37500000f,-0.20312500f,-0.78125000f,0.79687500f,0.82812500f,0.79687500f,-0.67187500f,-0.96875000f,0.43750000f,0.00000000f,0.95312500f,-0.96875000f,-0.23437500f,-0.21875000f,0.48437500f,0.87500000f,0.85937500f,-0.09375000f,0.84375000f,-0.48437500f,-0.96875000f,0.43750000f,0.28125000f,0.78125000f,-0.62500000f,-0.79687500f,-0.35937500f,-0.04687500f,-0.81250000f,-0.01562500f,0.07812500f,-0.17187500f,0.70312500f,0.01562500f,0.85937500f,-0.18750000f,0.17187500f,-0.98437500f,0.07812500f,-0.62500000f,0.34375000f,-0.32812500f,-0.42187500f,0.42187500f,0.17187500f,0.50000000f,0.07812500f,-0.18750000f,0.50000000f,-0.82812500f,0.17187500f,-0.67187500f,0.03125000f,-0.35937500f,0.12500000f,-0.71875000f,-0.25000000f,0.21875000f,0.50000000f,0.28125000f,0.57812500f,-0.54687500f,-0.15625000f,0.03125000f,0.15625000f,-0.45312500f,0.40625000f,-1.00000000f,-0.42187500f,-0.40625000f,0.65625000f,-0.62500000f,-0.95312500f,0.56250000f,0.42187500f,-0.15625000f,0.79687500f,1.00000000f,0.00000000f,-0.79687500f,0.84375000f,0.89062500f,-0.26562500f,0.03125000f,-0.54687500f,0.15625000f,-0.31250000f,-0.53125000f,0.51562500f,-0.09375000f,-0.40625000f,0.26562500f,-0.48437500f,-0.53125000f,0.06250000f,0.42187500f,-0.93750000f,-0.34375000f,-0.34375000f,0.23437500f,0.01562500f,-0.20312500f,-0.21875000f,-0.04687500f,0.85937500f,0.21875000f,-0.79687500f,-0.92187500f,-0.89062500f,0.21875000f,-0.59375000f,-0.71875000f,0.12500000f,0.20312500f,-0.48437500f,0.62500000f,0.90625000f,0.01562500f,-0.71875000f,-0.95312500f,-0.90625000f,0.01562500f,-0.31250000f,0.96875000f,-0.39062500f,0.07812500f,0.53125000f,0.96875000f,0.26562500f,0.20312500f,0.40625000f,-0.56250000f,-1.00000000f,0.37500000f,0.75000000f,0.09375000f,0.81250000f,0.90625000f,-0.57812500f,0.23437500f,0.92187500f,0.12500000f,-0.25000000f,-0.07812500f,-0.03125000f,-0.85937500f,-0.90625000f,-0.35937500f,0.89062500f,-0.70312500f,0.96875000f,-1.00000000f,0.84375000f,0.03125000f,-0.84375000f,0.89062500f,-0.92187500f,0.04687500f,0.20312500f,0.17187500f,0.51562500f,-0.34375000f,0.04687500f,0.89062500f,0.07812500f,0.26562500f,0.29687500f,0.65625000f,0.73437500f,-0.29687500f,0.96875000f,0.50000000f,-0.95312500f,0.92187500f,0.98437500f,0.73437500f,-0.59375000f,-0.76562500f,-0.50000000f,-0.65625000f,-0.37500000f,-0.89062500f,-0.29687500f,-0.15625000f,0.51562500f,-0.53125000f,-0.56250000f,-0.28125000f,-0.35937500f,-0.10937500f,-0.29687500f,-0.34375000f,-0.35937500f,-0.65625000f,-0.07812500f,0.89062500f,0.75000000f,-0.37500000f,0.15625000f,0.34375000f,-0.06250000f,0.01562500f,0.23437500f,0.56250000f,0.89062500f,0.65625000f,0.17187500f,0.87500000f,-0.39062500f,-0.17187500f,0.57812500f,0.56250000f,0.75000000f,0.32812500f,0.50000000f,-0.51562500f,-0.09375000f,0.00000000f,0.48437500f,0.67187500f,-0.46875000f,-0.65625000f,0.53125000f,0.12500000f,-0.31250000f,-0.40625000f,-0.84375000f,0.53125000f,-0.04687500f,0.43750000f,-0.73437500f,-0.03125000f,0.31250000f,0.81250000f,0.23437500f,0.23437500f,-0.03125000f,-0.46875000f,-0.23437500f,-0.15625000f,0.09375000f,-0.62500000f,0.65625000f,-0.42187500f,0.18750000f,-0.64062500f,-0.76562500f,0.98437500f,-0.35937500f,-0.28125000f,-0.70312500f,-0.73437500f,-0.85937500f,-0.57812500f,-0.50000000f,-0.35937500f,0.07812500f,-0.87500000f,0.04687500f,-0.26562500f,0.73437500f,-0.87500000f,-0.42187500f,0.54687500f,0.65625000f,0.84375000f,0.64062500f,-0.85937500f,-0.89062500f,-0.14062500f,-0.64062500f,-0.03125000f,-0.28125000f,0.82812500f,-0.70312500f,0.81250000f,0.93750000f,0.96875000f,-0.17187500f,-0.01562500f,0.65625000f,0.87500000f,-0.23437500f,-0.81250000f,0.39062500f,-0.45312500f,-0.75000000f,-0.96875000f,1.00000000f,0.62500000f,-0.32812500f,-0.73437500f,-0.50000000f,0.76562500f,-0.76562500f,0.32812500f,0.95312500f,-0.50000000f,0.70312500f,-0.31250000f,0.15625000f,-0.54687500f,-0.35937500f,0.89062500f,0.09375000f,-0.96875000f,0.84375000f,-0.06250000f,0.31250000f,-0.50000000f,0.85937500f,0.67187500f,0.67187500f,0.76562500f,0.25000000f,0.48437500f,0.09375000f,-0.26562500f,0.43750000f,-0.04687500f,-0.87500000f,0.76562500f,-0.40625000f,0.21875000f,-0.82812500f,0.56250000f,-0.23437500f,-0.48437500f,0.85937500f,-0.37500000f,0.96875000f,-0.71875000f,0.62500000f,0.42187500f,0.29687500f,-0.96875000f,-0.73437500f,-0.87500000f,-1.00000000f,-0.51562500f,0.90625000f,0.95312500f,-0.96875000f,0.85937500f,-0.09375000f,-0.87500000f,-0.46875000f,-0.76562500f,-0.57812500f,-0.20312500f,0.32812500f,-0.01562500f,0.96875000f,0.45312500f,-0.35937500f,0.03125000f,0.76562500f,-0.93750000f,0.79687500f,0.95312500f,0.28125000f,0.45312500f,-0.10937500f,-0.56250000f,-0.56250000f,0.01562500f,0.03125000f,0.00000000f,-0.18750000f,-0.93750000f,-0.31250000f,-0.34375000f,-0.32812500f,0.26562500f,-0.42187500f,0.34375000f,0.76562500f,0.68750000f,0.96875000f,0.84375000f,0.76562500f,0.39062500f,-0.31250000f,0.29687500f,0.54687500f,0.29687500f,0.89062500f,-0.95312500f,-0.48437500f,-0.15625000f,-0.64062500f,-0.84375000f,0.42187500f,-0.81250000f,0.93750000f,0.73437500f,-0.64062500f,-0.26562500f,0.45312500f,-0.95312500f,0.93750000f,0.40625000f,-0.45312500f,-0.93750000f,-0.15625000f,-0.73437500f,0.01562500f,0.50000000f,-0.12500000f,-0.96875000f,0.37500000f,0.79687500f,0.92187500f,-0.10937500f,-0.90625000f,-0.62500000f,0.53125000f,0.39062500f,0.92187500f,-0.95312500f,0.65625000f,-0.17187500f,0.93750000f,-0.64062500f,0.37500000f,0.26562500f,-0.62500000f,-0.75000000f,-0.81250000f,0.37500000f,-0.20312500f,0.00000000f,0.79687500f,-0.56250000f,0.59375000f,1.00000000f,-0.50000000f,0.40625000f,-0.95312500f,-0.87500000f,0.92187500f,0.28125000f,0.98437500f,0.70312500f,-0.95312500f,-0.35937500f,-0.96875000f,0.51562500f,-0.04687500f,-0.78125000f,-0.93750000f,0.06250000f,-0.70312500f,0.06250000f,-0.42187500f,-0.51562500f,-0.65625000f,-1.00000000f,-0.01562500f,0.54687500f,-0.25000000f,0.09375000f,0.87500000f,0.07812500f,0.68750000f,0.20312500f,0.31250000f,-0.28125000f,0.57812500f,-0.14062500f,-0.93750000f,-0.78125000f,0.35937500f,-0.18750000f,-0.07812500f,0.60937500f,-0.18750000f,-0.90625000f,0.35937500f,-0.28125000f,0.23437500f,-0.87500000f,-0.93750000f,-0.06250000f,-0.18750000f,0.12500000f,0.96875000f,-0.01562500f,-0.85937500f,0.29687500f,-0.42187500f,-0.43750000f,-0.56250000f,-0.93750000f,0.96875000f,-0.29687500f,0.29687500f,0.73437500f,0.01562500f,-0.35937500f,0.28125000f,-0.65625000f,-0.18750000f,-0.43750000f,-0.10937500f,0.35937500f,-0.01562500f,-0.84375000f,0.28125000f,0.67187500f,0.25000000f,0.50000000f,0.23437500f,-0.81250000f,0.10937500f,-0.56250000f,0.54687500f,0.07812500f,-0.76562500f,0.14062500f,-0.17187500f,0.93750000f,-0.28125000f,-0.78125000f,-0.68750000f,0.45312500f,0.09375000f,0.75000000f,0.50000000f,0.01562500f,-0.23437500f,-0.68750000f,0.57812500f,0.73437500f,-0.46875000f,-0.82812500f,0.40625000f,-0.15625000f,0.81250000f,-0.40625000f,-0.25000000f,-0.85937500f,-0.71875000f,0.71875000f,0.78125000f,0.90625000f,0.87500000f,-0.90625000f,0.64062500f,0.40625000f,-0.34375000f,0.17187500f,0.06250000f,0.87500000f,0.48437500f,-0.34375000f,1.00000000f,0.10937500f,-0.51562500f,-0.73437500f,0.81250000f,-0.95312500f,0.53125000f,-0.46875000f,0.20312500f,0.75000000f,-0.87500000f,-0.85937500f,0.71875000f,0.37500000f,-0.59375000f,-0.06250000f,-0.64062500f,-0.70312500f,0.40625000f,-0.12500000f,0.98437500f,0.03125000f,-0.93750000f,-0.23437500f,-0.20312500f,0.34375000f,0.10937500f,0.43750000f,-0.34375000f,-0.26562500f,-0.75000000f,0.48437500f,0.01562500f,0.81250000f,0.62500000f,0.31250000f,-0.60937500f,-0.40625000f,-0.87500000f,-0.87500000f,-0.42187500f,-0.70312500f,-0.89062500f,0.50000000f,-0.21875000f,0.50000000f,-0.87500000f,-0.82812500f,-0.31250000f,0.71875000f,0.90625000f,0.17187500f,0.45312500f,-0.67187500f,-0.54687500f,-0.64062500f,0.79687500f,-0.71875000f,0.73437500f,0.45312500f,-0.32812500f,-0.67187500f,0.98437500f,-0.85937500f,-0.01562500f,0.75000000f,-0.40625000f,-0.84375000f,0.04687500f,0.70312500f,0.45312500f,-0.89062500f,-0.54687500f,-0.17187500f,-0.59375000f,0.85937500f,-0.31250000f,0.46875000f,-0.29687500f,0.26562500f,-0.06250000f,-0.70312500f,0.79687500f,0.62500000f,-0.84375000f,0.07812500f,0.96875000f,0.59375000f,-0.65625000f,0.26562500f,0.01562500f,0.23437500f,-0.50000000f,-0.32812500f,-0.78125000f,-0.59375000f,0.76562500f,-0.60937500f,0.10937500f,0.35937500f,-0.62500000f,0.17187500f,0.67187500f,-0.10937500f,0.25000000f,0.21875000f,0.82812500f,0.84375000f,0.92187500f,0.42187500f,-0.57812500f,0.39062500f,0.78125000f,-0.71875000f,0.32812500f,0.64062500f,-0.64062500f,-0.59375000f,0.48437500f,0.82812500f,-0.87500000f,0.40625000f,0.37500000f,-0.57812500f,0.12500000f,-0.10937500f,-0.03125000f,-0.68750000f,-0.70312500f,0.48437500f,0.14062500f,-0.78125000f,0.60937500f,0.23437500f,0.79687500f,0.14062500f,-0.68750000f,0.95312500f,0.14062500f,0.01562500f,-0.84375000f,-0.76562500f,-0.15625000f,-0.23437500f,0.59375000f,-0.14062500f,-0.75000000f,0.25000000f,0.04687500f,-0.28125000f,-0.03125000f,0.75000000f,-0.34375000f,-0.42187500f,-0.34375000f,-0.20312500f,0.17187500f,0.64062500f,-0.43750000f,0.79687500f,-0.25000000f,-0.03125000f,-0.56250000f,0.23437500f,0.32812500f,-0.03125000f,-0.01562500f,0.87500000f,-1.00000000f,-0.54687500f,-0.43750000f,0.07812500f,-0.82812500f,-0.48437500f,-0.82812500f,0.04687500f,-0.76562500f,-0.45312500f,0.65625000f,0.10937500f,-0.20312500f,0.21875000f,0.32812500f,0.96875000f,0.04687500f,0.87500000f,-0.35937500f,0.31250000f,-0.85937500f,0.29687500f,0.56250000f,-0.17187500f,0.76562500f,0.09375000f,0.09375000f,0.75000000f,0.45312500f,0.64062500f,-0.04687500f,-0.90625000f,0.87500000f,0.20312500f,-0.12500000f,0.87500000f,-0.20312500f,0.48437500f,0.35937500f,0.32812500f,0.03125000f,0.76562500f,-0.57812500f,-0.59375000f,0.82812500f,0.51562500f,-0.68750000f,-0.62500000f,-0.31250000f,-0.35937500f,0.95312500f,-0.40625000f,-0.03125000f,-0.96875000f,-1.00000000f,0.01562500f,0.09375000f,0.84375000f,-0.87500000f,-0.81250000f,0.31250000f,-0.51562500f,-0.51562500f,0.54687500f,-0.23437500f,0.17187500f,-0.04687500f,0.56250000f,-0.32812500f,-0.89062500f,0.10937500f,0.43750000f,-0.23437500f,-0.67187500f,-0.78125000f,-0.60937500f,-0.23437500f,0.31250000f,-0.95312500f,0.98437500f,-0.96875000f,0.75000000f,0.70312500f,0.70312500f,-0.96875000f,-0.14062500f,0.93750000f,0.48437500f,-0.82812500f,0.84375000f,0.84375000f,-0.06250000f,0.42187500f,-0.01562500f,0.23437500f,-0.84375000f,1.00000000f,-0.84375000f,0.57812500f,-0.54687500f,0.17187500f,0.73437500f,0.87500000f,-0.45312500f,-0.04687500f,-0.39062500f,0.60937500f,0.34375000f,0.76562500f,-0.62500000f,0.43750000f,0.96875000f,0.84375000f,-0.62500000f,0.51562500f,-0.21875000f,0.65625000f,-0.59375000f,-0.18750000f,0.90625000f,0.45312500f,0.89062500f,0.04687500f,-0.17187500f,-0.28125000f,0.14062500f,0.29687500f,-0.46875000f,-0.43750000f,0.57812500f,-0.96875000f,0.28125000f,-0.20312500f,-0.62500000f,-0.68750000f,0.31250000f,0.39062500f,0.98437500f,0.57812500f,-0.57812500f,-0.78125000f,0.42187500f,0.81250000f,-0.95312500f,-0.25000000f,-0.50000000f,-0.18750000f,-0.39062500f,-0.40625000f,-0.29687500f,-0.70312500f,0.84375000f,0.40625000f,-0.06250000f,0.60937500f,-0.12500000f,-0.20312500f,0.84375000f,-0.53125000f,0.85937500f,-0.96875000f,0.84375000f,-0.03125000f,0.29687500f,-0.53125000f,-0.40625000f,0.92187500f,-0.48437500f,0.07812500f,0.98437500f,0.76562500f,0.79687500f,-0.81250000f,0.54687500f,0.01562500f,0.03125000f,0.34375000f,0.06250000f,-0.73437500f,0.01562500f,0.09375000f,-0.92187500f,-0.35937500f,-0.64062500f,-0.64062500f,0.10937500f,-0.82812500f,0.39062500f,-0.20312500f,-0.20312500f,0.15625000f,0.09375000f,-0.70312500f,0.26562500f,-0.28125000f,-0.46875000f,0.40625000f,0.64062500f,0.67187500f,0.12500000f,-0.68750000f,0.50000000f,-0.50000000f,0.79687500f,-0.15625000f,-0.26562500f,0.73437500f,0.92187500f,-0.48437500f,0.15625000f,-0.93750000f,-0.21875000f,0.95312500f,-0.37500000f,-0.45312500f,0.78125000f,0.78125000f,-0.70312500f,0.48437500f,-0.75000000f,0.89062500f,-0.14062500f,-0.23437500f,-0.17187500f,0.54687500f,-0.81250000f,0.01562500f,-0.78125000f,0.26562500f,-0.85937500f,-0.75000000f,0.40625000f,-0.93750000f,0.79687500f,-0.09375000f,-0.35937500f,-0.43750000f,-0.15625000f,0.50000000f,-0.06250000f,-0.59375000f,0.85937500f,0.39062500f,-0.06250000f,0.37500000f,-0.64062500f,-0.68750000f,0.31250000f,0.96875000f,0.56250000f,0.25000000f,0.48437500f,-0.14062500f,0.20312500f,1.00000000f,-0.67187500f,-0.46875000f,0.17187500f,0.09375000f,0.10937500f,0.85937500f,-0.10937500f,-0.71875000f,-0.51562500f,0.85937500f,-0.26562500f,0.71875000f,0.81250000f,-0.93750000f,-0.50000000f,-0.54687500f,0.84375000f,-0.60937500f,-0.62500000f,0.51562500f,0.93750000f,-0.26562500f,0.15625000f,0.56250000f,0.71875000f,0.51562500f,-0.84375000f,-0.50000000f,-0.28125000f,-0.81250000f,-0.34375000f,-0.09375000f,-0.03125000f,-0.25000000f,0.07812500f,-0.07812500f,0.78125000f,0.90625000f,-0.14062500f,0.17187500f,-0.95312500f,-0.21875000f,0.67187500f,-0.96875000f,0.25000000f,1.00000000f,0.07812500f,0.15625000f,-0.06250000f,0.71875000f,-0.87500000f,-0.12500000f,0.07812500f,-0.35937500f,-0.39062500f,0.17187500f,-0.57812500f,-0.46875000f,0.76562500f,-0.46875000f,0.57812500f,-0.65625000f,0.00000000f,-0.40625000f,0.34375000f,-0.48437500f,0.12500000f,0.75000000f,-0.04687500f,0.23437500f,0.42187500f,0.50000000f,0.67187500f,0.68750000f,0.73437500f,0.95312500f,-0.71875000f,-0.10937500f,-0.87500000f,-0.42187500f,0.48437500f,0.60937500f,-0.12500000f,-0.67187500f,-0.31250000f,-0.65625000f,-0.95312500f,-0.51562500f,0.10937500f,0.81250000f,0.54687500f,0.59375000f,-0.48437500f,-0.81250000f,-0.54687500f,0.07812500f,-0.82812500f,0.07812500f,1.00000000f,-0.67187500f,0.20312500f,0.59375000f,-0.18750000f,-0.50000000f,-0.46875000f,0.25000000f,0.20312500f,0.37500000f,-0.85937500f,0.46875000f,-0.79687500f,0.57812500f,0.71875000f,-0.07812500f,-0.79687500f,-0.29687500f,0.78125000f,0.64062500f,-0.15625000f,-0.32812500f,-0.62500000f,0.40625000f,-0.71875000f,-0.46875000f,0.14062500f,0.20312500f,-0.78125000f,0.43750000f,0.01562500f,0.60937500f,-0.82812500f,-0.50000000f,-0.34375000f,0.26562500f,-0.84375000f,-0.32812500f,0.01562500f,-0.76562500f,-0.84375000f,-0.25000000f,-0.34375000f,-0.51562500f,0.57812500f,0.14062500f,-0.26562500f,-0.43750000f,-0.31250000f,0.73437500f,0.62500000f,0.76562500f,-0.53125000f,-0.29687500f,-0.82812500f,-0.60937500f,-0.03125000f,-0.32812500f,-0.76562500f,0.09375000f,0.76562500f,0.92187500f,0.35937500f,0.29687500f,0.75000000f,-0.98437500f,-0.10937500f,-0.73437500f,0.10937500f,-0.53125000f,-0.56250000f,0.35937500f,0.71875000f,-0.26562500f,-0.68750000f,0.28125000f,0.15625000f,0.10937500f,-0.62500000f,0.65625000f,-0.21875000f,0.81250000f,-0.10937500f,0.25000000f,0.68750000f,-0.81250000f,-0.64062500f,0.35937500f,0.01562500f,-0.43750000f,0.76562500f,0.34375000f,-0.57812500f,0.40625000f,0.56250000f,-0.65625000f,0.98437500f,-0.68750000f,0.56250000f,0.46875000f,0.90625000f,0.06250000f,0.68750000f,0.75000000f,0.26562500f,0.14062500f,0.34375000f,-0.81250000f,0.25000000f,0.76562500f,0.85937500f,0.31250000f,-0.34375000f,0.95312500f,-0.95312500f,-0.09375000f,-0.78125000f,-0.89062500f,0.17187500f,-0.57812500f,0.82812500f,0.25000000f,-0.98437500f,0.68750000f,0.92187500f,-0.15625000f,0.46875000f,-0.18750000f,-0.93750000f,0.42187500f,0.85937500f,0.01562500f,0.78125000f,0.60937500f,-0.78125000f,-0.28125000f,-0.89062500f,0.56250000f,0.34375000f,0.70312500f,0.89062500f,0.25000000f,0.21875000f,0.14062500f,-1.00000000f,-0.17187500f,0.25000000f,-0.21875000f,-0.89062500f,0.79687500f,-0.82812500f,0.76562500f,0.42187500f,0.73437500f,0.51562500f,-0.17187500f,-0.01562500f,-0.20312500f,0.01562500f,-0.04687500f,0.03125000f,0.42187500f,0.29687500f,-0.25000000f,0.31250000f,0.04687500f,-0.23437500f,0.14062500f,0.26562500f,-0.68750000f,-0.60937500f,-0.82812500f,0.18750000f,0.14062500f,0.53125000f,-0.42187500f,-0.01562500f,-0.18750000f,-0.26562500f,0.62500000f,0.26562500f,0.98437500f,0.93750000f,0.06250000f,0.81250000f,0.15625000f,-0.21875000f,-0.78125000f,0.18750000f,-0.17187500f,0.21875000f,-0.28125000f,-0.06250000f,0.06250000f,0.46875000f,-0.82812500f,0.96875000f,-0.14062500f,0.18750000f,0.84375000f,0.01562500f,-0.81250000f,0.26562500f,0.10937500f,-0.71875000f,0.45312500f,0.67187500f,0.67187500f,0.48437500f,-0.17187500f,0.98437500f,-0.17187500f,-0.35937500f,-0.50000000f,0.70312500f,-0.18750000f,0.89062500f,-0.50000000f,0.89062500f,0.84375000f,-0.03125000f,0.40625000f,-0.68750000f,-0.10937500f,-0.68750000f,0.62500000f,0.35937500f,0.92187500f,-0.68750000f,-0.17187500f,0.68750000f,0.17187500f,0.57812500f,0.34375000f,0.96875000f,-0.43750000f,0.50000000f,0.89062500f,0.75000000f,0.20312500f,-0.14062500f,-0.84375000f,-0.07812500f,-0.89062500f,0.45312500f,-0.53125000f,0.82812500f,-0.60937500f,-0.34375000f,-0.37500000f,0.12500000f,0.45312500f,-0.76562500f,-0.17187500f,0.78125000f,0.12500000f,0.76562500f,0.29687500f,0.42187500f,0.57812500f,-0.12500000f,-0.09375000f,0.29687500f,-0.35937500f,-0.98437500f,-0.54687500f,-1.00000000f,-0.85937500f,0.56250000f,0.20312500f,-0.82812500f,-0.26562500f,0.20312500f,0.71875000f,-0.50000000f,-0.32812500f,0.92187500f,0.20312500f,-0.81250000f,-0.59375000f,0.98437500f,0.78125000f,0.82812500f,-0.98437500f,-0.21875000f,0.10937500f,-0.37500000f,0.21875000f,0.45312500f,-0.95312500f,0.46875000f,0.64062500f,-0.62500000f,0.50000000f,-0.01562500f,-0.01562500f,-0.90625000f,-0.68750000f,0.85937500f,0.43750000f,-0.34375000f,-0.90625000f,0.68750000f,-0.76562500f,-0.95312500f,0.73437500f,-0.06250000f,-0.96875000f,0.79687500f,-0.68750000f,0.56250000f,0.12500000f,0.53125000f,-0.42187500f,-0.18750000f,-0.10937500f,-0.82812500f,0.85937500f,-0.37500000f,-0.73437500f,0.28125000f,-0.60937500f,-0.04687500f,0.45312500f,0.60937500f,0.79687500f,0.07812500f,-0.50000000f,0.90625000f,0.10937500f,-0.65625000f,-0.10937500f,0.75000000f,-0.64062500f,-0.18750000f,0.64062500f,0.18750000f,-0.64062500f,0.35937500f,0.85937500f,0.12500000f,0.70312500f,-0.56250000f,-0.04687500f,-0.70312500f,-0.43750000f,0.71875000f,0.85937500f,-0.96875000f,-0.96875000f,-0.71875000f,-0.64062500f,-0.17187500f,-0.28125000f,0.45312500f,0.03125000f,-0.17187500f,0.39062500f,-0.17187500f,0.43750000f,0.20312500f,-0.40625000f,-0.79687500f,0.21875000f,-0.82812500f,-0.81250000f,-0.53125000f,-0.64062500f,0.51562500f,-0.14062500f,0.67187500f,-0.60937500f,0.62500000f,-0.14062500f,-0.92187500f,-0.75000000f,-0.18750000f,0.48437500f,-0.62500000f,0.01562500f,-0.90625000f,0.03125000f,-0.87500000f,-0.76562500f,0.00000000f,-0.95312500f,0.00000000f,-0.93750000f,0.12500000f,-0.20312500f,-0.81250000f,0.57812500f,-0.21875000f,-0.34375000f,-0.87500000f,-0.14062500f,-0.76562500f,0.95312500f,0.25000000f,-0.67187500f,0.17187500f,0.17187500f,-0.43750000f,0.68750000f,0.35937500f,0.75000000f,0.10937500f,-0.07812500f,0.95312500f,0.45312500f,0.87500000f,0.71875000f,-0.03125000f,-0.43750000f,0.01562500f,-0.89062500f,-0.14062500f,0.59375000f,0.53125000f,0.46875000f,0.20312500f,0.01562500f,0.92187500f,0.96875000f,0.98437500f,0.89062500f,0.62500000f,0.42187500f,0.78125000f,0.79687500f,-0.37500000f,0.50000000f,-0.37500000f,-0.14062500f,0.25000000f,0.82812500f,-0.34375000f,0.85937500f,0.65625000f,-0.25000000f,0.09375000f,0.54687500f,-0.75000000f,-0.92187500f,0.12500000f,-0.82812500f,-0.39062500f,0.92187500f,0.07812500f,0.42187500f,0.82812500f,-0.09375000f,0.01562500f,-0.76562500f,0.09375000f,-0.65625000f,0.42187500f,-0.18750000f,0.59375000f,-0.75000000f,-1.00000000f,-0.09375000f,-0.71875000f,-0.96875000f,-0.01562500f,0.71875000f,-1.00000000f,0.03125000f,-0.01562500f,-0.45312500f,0.68750000f,0.95312500f,-0.90625000f,0.82812500f,0.26562500f,-0.15625000f,0.35937500f,-0.70312500f,0.01562500f,1.00000000f,0.90625000f,0.87500000f,0.39062500f,0.67187500f,-0.96875000f,0.56250000f,-0.53125000f,0.06250000f,0.85937500f,0.48437500f,-0.39062500f,-0.25000000f,0.81250000f,-0.31250000f,0.62500000f,-0.48437500f,0.50000000f,0.10937500f,0.15625000f,0.82812500f,0.95312500f,0.40625000f,0.96875000f,-0.17187500f,-0.79687500f,0.95312500f,-0.07812500f,0.26562500f,-0.39062500f,0.78125000f,0.57812500f,-0.53125000f,-0.15625000f,-0.57812500f,-0.45312500f,-0.59375000f,-0.14062500f,-0.65625000f,0.57812500f,-0.68750000f,-0.07812500f,0.37500000f,-0.85937500f,0.54687500f,-0.20312500f,-0.95312500f,-0.14062500f,0.81250000f,-0.12500000f,0.20312500f,0.81250000f,0.65625000f,-1.00000000f,0.85937500f,-0.32812500f,0.35937500f,-0.56250000f,0.82812500f,0.65625000f,-0.84375000f,-0.17187500f,-0.03125000f,-0.18750000f,0.56250000f,-0.32812500f,-0.85937500f,0.26562500f,-0.01562500f,0.90625000f,0.48437500f,0.21875000f,0.85937500f,-0.60937500f,-0.28125000f,0.70312500f,0.68750000f,-0.65625000f,0.70312500f,-0.26562500f,-0.48437500f,0.62500000f,0.85937500f,-0.56250000f,-0.59375000f,-0.46875000f,0.92187500f,0.29687500f,-0.53125000f,-0.48437500f,0.45312500f,0.25000000f,-0.87500000f,-0.15625000f,-0.48437500f,-0.04687500f,-0.78125000f,0.29687500f,-0.84375000f,-0.17187500f,-0.78125000f,0.50000000f,0.46875000f,-0.32812500f,-0.35937500f,0.48437500f,-0.12500000f,-0.76562500f,0.67187500f,0.85937500f,0.18750000f,0.42187500f,1.00000000f,0.75000000f,0.53125000f,0.98437500f,-0.73437500f,0.17187500f,-0.45312500f,-0.65625000f,-0.03125000f,0.00000000f,0.96875000f,0.92187500f,0.29687500f,-0.96875000f,-0.95312500f,0.23437500f,0.73437500f,-0.54687500f,0.78125000f,-0.85937500f,-0.53125000f,-0.64062500f,0.00000000f,0.73437500f,-0.03125000f,0.85937500f,0.10937500f,-0.26562500f,-0.70312500f,0.04687500f,-0.03125000f,0.76562500f,-0.04687500f,-0.81250000f,-0.71875000f,0.10937500f,-0.84375000f,0.39062500f,0.21875000f,0.43750000f,-0.40625000f,1.00000000f,0.92187500f,-0.21875000f,-0.85937500f,-0.32812500f,0.34375000f,0.84375000f,-0.45312500f,-0.31250000f,-0.56250000f,-0.90625000f,0.87500000f,-0.43750000f,0.48437500f,0.62500000f,-0.06250000f,-0.57812500f,0.28125000f,-0.45312500f,0.54687500f,0.01562500f,-0.20312500f,-0.92187500f,0.76562500f,0.89062500f,-0.90625000f,0.87500000f,-0.96875000f,-0.15625000f,0.90625000f,0.43750000f,-0.07812500f,-0.70312500f,-0.35937500f,-0.53125000f,0.14062500f,0.92187500f,-0.18750000f,-0.15625000f,0.73437500f,-0.59375000f,-0.75000000f,0.76562500f,-0.01562500f,0.96875000f,0.53125000f,0.64062500f,0.82812500f,0.57812500f,-0.34375000f,-0.65625000f,0.39062500f,0.96875000f,-0.54687500f,-0.09375000f,0.76562500f,-0.84375000f,0.51562500f,0.28125000f,-0.57812500f,0.54687500f,0.32812500f,-0.65625000f,0.10937500f,0.14062500f,0.32812500f,0.53125000f,0.84375000f,0.04687500f,-0.23437500f,-0.76562500f,-0.48437500f,0.53125000f,-0.95312500f,-0.34375000f,0.70312500f,0.67187500f,-0.31250000f,-0.23437500f,0.39062500f,-0.50000000f,0.73437500f,0.09375000f,-0.57812500f,0.76562500f,0.96875000f,-0.60937500f,0.42187500f,0.25000000f,0.60937500f,0.64062500f,0.51562500f,-0.85937500f,-0.98437500f,0.75000000f,-0.45312500f,-0.93750000f,-0.62500000f,0.95312500f,-0.59375000f,0.51562500f,-0.14062500f,-0.68750000f,0.79687500f,0.28125000f,-0.01562500f,-0.28125000f,-0.78125000f,0.15625000f,-0.85937500f,0.76562500f,0.07812500f,-0.50000000f,-0.60937500f,-0.81250000f,0.56250000f,0.12500000f,-0.14062500f,-0.78125000f,0.35937500f,-0.32812500f,-0.84375000f,-0.37500000f,0.98437500f,-0.23437500f,0.06250000f,-0.82812500f,0.46875000f,0.46875000f,-0.60937500f,0.54687500f,-0.93750000f,-0.25000000f,0.93750000f,0.32812500f,0.92187500f,0.12500000f,0.39062500f,0.00000000f,-0.09375000f,-0.68750000f,-0.28125000f,0.95312500f,-0.06250000f,-0.68750000f,0.62500000f,-0.06250000f,-0.31250000f,-0.56250000f,-0.12500000f,0.56250000f,0.03125000f,-0.20312500f,-0.31250000f,0.37500000f,-0.04687500f,0.53125000f,0.82812500f,0.43750000f,0.53125000f,-0.12500000f,-0.29687500f,-0.37500000f,-0.26562500f,-0.10937500f,-0.39062500f,-0.18750000f,0.65625000f,-0.12500000f,0.37500000f,0.78125000f,-0.45312500f,-0.48437500f,-0.10937500f,0.06250000f,0.73437500f,0.89062500f,0.42187500f,0.40625000f,0.81250000f,-0.90625000f,-0.70312500f,0.20312500f,-0.70312500f,0.21875000f,-0.46875000f,0.85937500f,-0.90625000f,0.45312500f,-0.09375000f,0.87500000f,0.78125000f,-0.25000000f,0.21875000f,-0.15625000f,-0.01562500f,-0.67187500f,-0.04687500f,0.34375000f,-0.51562500f,0.95312500f,-0.64062500f,-0.26562500f,-0.51562500f,-0.92187500f,0.70312500f,-0.68750000f,-0.64062500f,-0.20312500f,-0.64062500f,-0.14062500f,0.42187500f,-0.23437500f,0.40625000f,-0.51562500f,0.40625000f,-0.45312500f,-0.53125000f,-0.35937500f,0.82812500f,-0.57812500f,0.56250000f,-0.07812500f,0.54687500f,0.15625000f,0.76562500f,-0.98437500f,-0.87500000f,0.87500000f,-0.89062500f,0.90625000f,0.56250000f,-0.35937500f,0.75000000f,0.95312500f,-0.95312500f,-0.32812500f,-0.48437500f,0.64062500f,0.23437500f,0.14062500f,-0.21875000f,-0.04687500f,-0.81250000f,0.21875000f,0.45312500f,-0.06250000f,-0.34375000f,-0.79687500f,0.67187500f,0.84375000f,0.40625000f,0.87500000f,0.68750000f,0.68750000f,0.07812500f,0.67187500f,-0.18750000f,-0.82812500f,-0.85937500f,-0.34375000f,0.81250000f,0.71875000f,-0.57812500f,-0.70312500f,0.68750000f,-0.03125000f,0.54687500f,-0.17187500f,0.15625000f,0.01562500f,-0.45312500f,-0.29687500f,-0.64062500f,0.06250000f,0.21875000f,0.45312500f,0.39062500f,0.51562500f,-0.67187500f,-0.42187500f,-0.82812500f,-0.89062500f,-0.51562500f,0.75000000f,0.82812500f,0.15625000f,-0.25000000f,-0.92187500f,0.25000000f,0.56250000f,-0.85937500f,0.18750000f,-0.06250000f,-1.00000000f,-0.82812500f,-0.89062500f,0.76562500f,-0.42187500f,-0.06250000f,-0.81250000f,0.34375000f,0.04687500f,0.50000000f,-0.15625000f,0.79687500f,0.10937500f,0.53125000f,0.78125000f,0.81250000f,0.20312500f,-1.00000000f,-0.53125000f,0.37500000f,0.34375000f,0.10937500f,0.79687500f,0.71875000f,0.35937500f,0.81250000f,-0.96875000f,-0.07812500f,-0.68750000f,-0.98437500f,0.43750000f,0.59375000f,0.25000000f,0.25000000f,-0.18750000f,-0.75000000f,-0.12500000f,0.28125000f,0.25000000f,-0.21875000f,0.15625000f,0.01562500f,-0.92187500f,-0.18750000f,-0.32812500f,-0.42187500f,0.48437500f,-0.40625000f,-0.29687500f,-0.75000000f,1.00000000f,0.20312500f,-0.25000000f,-0.32812500f,0.75000000f,0.03125000f,0.87500000f,-0.07812500f,0.23437500f,-0.37500000f,-0.34375000f,0.48437500f,0.29687500f,-0.14062500f,0.06250000f,0.84375000f,-0.12500000f,0.93750000f,0.06250000f,-0.96875000f,-0.42187500f,-1.00000000f,-1.00000000f,0.09375000f,0.93750000f,-0.76562500f,-0.48437500f,-0.15625000f,0.67187500f,0.28125000f,0.53125000f,0.59375000f,-0.73437500f,-0.68750000f,0.50000000f,-0.32812500f,-0.06250000f,0.70312500f,-0.45312500f,-0.60937500f,-0.56250000f,-0.18750000f,-0.78125000f,-0.06250000f,-0.73437500f,-0.25000000f,0.15625000f,0.37500000f,-0.10937500f,-0.57812500f,-0.57812500f,-0.71875000f,0.32812500f,-0.98437500f,-0.70312500f,-0.76562500f,-0.18750000f,-0.96875000f,0.28125000f,-0.35937500f,0.25000000f,-0.96875000f,0.71875000f,-0.70312500f,-0.06250000f,0.70312500f,0.37500000f,-0.03125000f,0.29687500f,0.26562500f,-0.68750000f,-0.76562500f,-0.90625000f,0.14062500f,0.06250000f,-0.84375000f,0.37500000f,0.37500000f,-0.98437500f,0.01562500f,0.50000000f,-0.62500000f,-0.62500000f,0.37500000f,-0.79687500f,0.79687500f,0.70312500f,-0.09375000f,0.50000000f,-0.23437500f,0.12500000f,-0.93750000f,-0.31250000f,0.79687500f,-0.48437500f,0.59375000f,0.54687500f,0.95312500f,0.51562500f,0.57812500f,0.92187500f,0.15625000f,-0.79687500f,-0.81250000f,0.46875000f,-0.70312500f,-0.56250000f,-0.84375000f,-0.92187500f,-0.12500000f,0.00000000f,-0.78125000f,0.34375000f,-0.82812500f,-0.26562500f,0.93750000f,-0.95312500f,-0.42187500f,0.95312500f,0.35937500f,-0.87500000f,0.29687500f,0.51562500f,0.25000000f,0.14062500f,-0.71875000f,-0.62500000f,-0.35937500f,0.29687500f,-0.56250000f,-0.34375000f,0.81250000f,-0.90625000f,-0.75000000f,0.53125000f,-0.10937500f,0.92187500f,0.57812500f,0.29687500f,0.39062500f,0.18750000f,-0.84375000f,0.65625000f,0.93750000f,-0.71875000f,-0.43750000f,-0.42187500f,0.25000000f,0.15625000f,-0.96875000f,-0.93750000f,-0.12500000f,-0.40625000f,0.53125000f,0.26562500f,-0.21875000f,0.51562500f,0.37500000f,-0.57812500f,0.26562500f,-0.17187500f,0.35937500f,0.79687500f,-0.75000000f,-0.07812500f,0.21875000f,-0.98437500f,-0.03125000f,-0.26562500f,0.31250000f,-0.03125000f,-0.40625000f,-0.76562500f,-0.37500000f,0.81250000f,-0.17187500f,0.29687500f,0.62500000f,0.40625000f,0.20312500f,0.40625000f,-0.79687500f,-0.53125000f,-0.71875000f,-0.70312500f,-0.23437500f,0.95312500f,0.84375000f,0.29687500f,0.40625000f,0.96875000f,0.93750000f,-0.03125000f,0.01562500f,0.60937500f,-0.28125000f,-0.85937500f,0.29687500f,0.68750000f,0.73437500f,0.56250000f,-0.67187500f,0.50000000f,-0.04687500f,0.09375000f,-0.48437500f,-0.43750000f,0.17187500f,0.57812500f,0.25000000f,-0.15625000f,0.32812500f,-0.84375000f,-0.28125000f,0.81250000f,0.65625000f,-0.65625000f,-0.70312500f,0.67187500f,-0.48437500f,0.65625000f,1.00000000f,-0.15625000f,-0.23437500f,0.23437500f,0.25000000f,-0.53125000f,0.48437500f,-0.73437500f,0.17187500f,0.28125000f,0.29687500f,0.12500000f,0.09375000f,0.31250000f,0.31250000f,-0.18750000f,-0.25000000f,-0.42187500f,-0.45312500f,-0.40625000f,0.82812500f,-0.90625000f,0.73437500f,0.56250000f,-0.09375000f,0.34375000f,-0.26562500f,0.29687500f,0.50000000f,0.46875000f,0.23437500f,0.43750000f,0.37500000f,-0.26562500f,0.60937500f,0.53125000f,0.53125000f,0.25000000f,-0.45312500f,0.51562500f,-0.64062500f,0.79687500f,-0.12500000f,0.93750000f,-0.45312500f,0.92187500f,0.64062500f,0.37500000f,0.06250000f,0.23437500f,-0.45312500f,0.50000000f,-0.09375000f,-0.79687500f,-0.95312500f,0.51562500f,-0.84375000f,-0.14062500f,0.93750000f,-0.82812500f,-0.62500000f,0.87500000f,0.03125000f,-0.53125000f,-0.09375000f,-0.96875000f,-0.28125000f,0.90625000f,0.56250000f,-0.35937500f,-0.37500000f,-0.29687500f,0.25000000f,0.71875000f,-0.75000000f,0.14062500f,-0.34375000f,0.12500000f,-0.01562500f,0.73437500f,-0.51562500f,-0.10937500f,-0.14062500f,0.82812500f,-0.89062500f,0.15625000f,-0.90625000f,-0.31250000f,-0.20312500f,-0.28125000f,-0.98437500f,-0.71875000f,-0.51562500f,-0.07812500f,-0.32812500f,0.76562500f,-0.37500000f,0.79687500f,-0.35937500f,0.39062500f,0.70312500f,-0.14062500f,0.65625000f,0.18750000f,0.04687500f,-0.54687500f,0.82812500f,-0.35937500f,0.43750000f,0.59375000f,-0.98437500f,0.60937500f,-0.60937500f,0.51562500f,-0.06250000f,-0.68750000f,0.50000000f,-0.04687500f,0.62500000f,0.45312500f,0.43750000f,0.70312500f,0.75000000f,-0.06250000f,-0.89062500f,0.85937500f,0.84375000f,-0.07812500f,0.67187500f,0.59375000f,0.59375000f,-1.00000000f,0.46875000f,0.65625000f,0.07812500f,0.43750000f,0.09375000f,0.82812500f,1.00000000f,0.12500000f,0.65625000f,-0.42187500f,-0.31250000f,-0.59375000f,0.51562500f,0.53125000f,0.23437500f,0.85937500f,-0.34375000f,-0.12500000f,-0.28125000f,0.78125000f,0.57812500f,1.00000000f,-0.53125000f,-0.56250000f,-0.64062500f,0.46875000f,-1.00000000f,-1.00000000f,0.87500000f,-0.56250000f,-0.84375000f,0.18750000f,0.18750000f,0.84375000f,0.15625000f,0.67187500f,0.29687500f,0.34375000f,0.73437500f,-0.90625000f,0.75000000f,0.95312500f,-0.39062500f,-0.75000000f,-0.43750000f,0.75000000f,0.42187500f,-0.53125000f,0.59375000f,-0.75000000f,-0.96875000f,0.85937500f,0.09375000f,0.82812500f,-0.45312500f,0.23437500f,-0.71875000f,0.29687500f,0.96875000f,-0.23437500f,0.12500000f,0.98437500f,-0.54687500f,-0.59375000f,-0.76562500f,-0.34375000f,-0.45312500f,0.67187500f,0.35937500f,0.82812500f,-0.17187500f,-0.71875000f,-1.00000000f,-0.65625000f,0.93750000f,0.82812500f,0.92187500f,-0.32812500f,0.62500000f,0.21875000f,-0.70312500f,0.45312500f,-0.28125000f,-0.31250000f,0.98437500f,-0.40625000f,-0.09375000f,-0.53125000f,0.62500000f,0.50000000f,0.32812500f,0.09375000f,-0.20312500f,0.29687500f,-0.43750000f,-0.70312500f,-0.92187500f,-0.60937500f,0.23437500f,0.57812500f,-0.92187500f,-0.64062500f,0.04687500f,0.92187500f,0.46875000f,0.12500000f,-0.37500000f,-0.04687500f,0.01562500f,0.93750000f,0.06250000f,-0.09375000f,-0.67187500f,1.00000000f,0.31250000f,0.43750000f,0.00000000f,-0.51562500f,0.60937500f,0.71875000f,0.26562500f,0.62500000f,0.81250000f,0.82812500f,0.95312500f,0.37500000f,0.39062500f,-0.67187500f,0.43750000f,-0.07812500f,0.48437500f,-0.34375000f,-0.15625000f,0.60937500f,0.67187500f,-0.68750000f,-0.10937500f,-0.46875000f,-0.31250000f,0.23437500f,-0.85937500f,-0.57812500f,0.56250000f,0.82812500f,-0.40625000f,0.71875000f,0.21875000f,-0.01562500f,-0.01562500f,0.04687500f,-0.57812500f,0.81250000f,0.37500000f,-0.45312500f,0.00000000f,-0.34375000f,-0.64062500f,0.10937500f,-0.90625000f,0.71875000f,-0.03125000f,-0.75000000f,-0.90625000f,-0.70312500f,0.70312500f,-0.40625000f,0.29687500f,-0.54687500f,0.65625000f,-0.42187500f,0.96875000f,0.78125000f,-0.89062500f,-0.92187500f,0.85937500f,0.59375000f,0.78125000f,-0.20312500f,-0.68750000f,-0.75000000f,0.06250000f,-0.57812500f,-0.98437500f,0.50000000f,0.35937500f,-0.43750000f,-0.92187500f,0.82812500f,0.35937500f,-0.59375000f,-0.46875000f,-0.51562500f,-0.42187500f,0.39062500f,-0.35937500f,-0.39062500f,0.23437500f,0.57812500f,-0.29687500f,-0.81250000f,-0.82812500f,-0.79687500f,-0.20312500f,-0.76562500f,0.79687500f,0.62500000f,-0.60937500f,0.96875000f,-0.43750000f,0.70312500f,-0.65625000f,-0.65625000f,-0.09375000f,-0.65625000f,0.00000000f,0.40625000f,-0.84375000f,-0.92187500f,0.04687500f,0.89062500f,-0.17187500f,-0.81250000f,-0.10937500f,0.14062500f,-0.85937500f,-1.00000000f,0.70312500f,-0.25000000f,-0.70312500f,-0.31250000f,0.82812500f,0.82812500f,0.71875000f,0.43750000f,-0.48437500f,0.34375000f,-0.25000000f,-0.28125000f,0.53125000f,-0.12500000f,0.56250000f,0.82812500f,0.01562500f,-0.60937500f,0.57812500f,0.93750000f,-0.73437500f,0.31250000f,0.79687500f,-0.54687500f,0.14062500f,0.42187500f,0.34375000f,0.31250000f,-0.39062500f,-0.10937500f,0.85937500f,-0.56250000f,-0.84375000f,-0.40625000f,-0.26562500f,0.28125000f,-0.93750000f,-0.09375000f,0.62500000f,-0.29687500f,-0.25000000f,-0.18750000f,0.28125000f,-0.51562500f,-0.43750000f,0.39062500f,-0.18750000f,-0.82812500f,0.15625000f,-0.82812500f,0.89062500f,-0.29687500f,-0.75000000f,-0.45312500f,0.59375000f,-0.78125000f,0.14062500f,-0.53125000f,0.07812500f,-0.98437500f,0.60937500f,0.21875000f,-0.68750000f,-0.35937500f,-0.20312500f,0.48437500f,-0.56250000f,0.76562500f,0.48437500f,-0.78125000f,0.03125000f,0.65625000f,-0.96875000f,0.54687500f,0.60937500f,0.78125000f,0.42187500f,-0.56250000f,-0.34375000f,0.64062500f,-1.00000000f,0.17187500f,0.71875000f,-0.68750000f,-0.96875000f,0.45312500f,-0.60937500f,0.31250000f,0.92187500f,0.98437500f,0.25000000f,-0.37500000f,0.21875000f,0.73437500f,-0.04687500f,-0.18750000f,-0.35937500f,-0.59375000f,0.98437500f,-0.29687500f,0.45312500f,-0.26562500f,0.45312500f,0.70312500f,-0.75000000f,0.37500000f,-0.03125000f,-0.03125000f,-0.64062500f,-0.71875000f,0.15625000f,-0.84375000f,-0.62500000f,-0.81250000f,0.70312500f,0.31250000f,0.04687500f,0.67187500f,0.09375000f,0.53125000f,0.87500000f,-0.54687500f,0.87500000f,0.81250000f,0.84375000f,-0.50000000f,0.65625000f,-0.26562500f,0.37500000f,0.42187500f,-0.53125000f,0.60937500f,0.64062500f,0.85937500f,0.18750000f,0.87500000f,-0.76562500f,-0.67187500f,0.51562500f,0.75000000f,-0.78125000f,0.04687500f,-0.50000000f,0.56250000f,0.42187500f,0.48437500f,-0.81250000f,-0.45312500f,-0.51562500f,-0.35937500f,-0.70312500f,0.04687500f,0.73437500f,0.71875000f,-0.54687500f,-0.98437500f,-0.25000000f,0.35937500f,0.00000000f,0.43750000f,0.00000000f,-0.01562500f,-0.12500000f,0.73437500f,-0.93750000f,0.71875000f,0.59375000f,-1.00000000f,-0.75000000f,0.26562500f,0.28125000f,-0.87500000f,0.18750000f,0.75000000f,0.40625000f,-0.67187500f,-0.31250000f,-0.46875000f,-0.59375000f,-0.42187500f,-0.35937500f,0.84375000f,-0.28125000f,0.34375000f,-0.45312500f,0.48437500f,-0.57812500f,-0.79687500f,-0.82812500f,0.92187500f,-0.56250000f,0.25000000f,-0.48437500f,0.96875000f,0.50000000f,0.56250000f,-0.57812500f,-0.78125000f,0.65625000f,-0.75000000f,-0.51562500f,0.79687500f,-0.60937500f,0.10937500f,-0.32812500f,0.10937500f,-0.71875000f,0.21875000f,0.67187500f,-0.50000000f,-0.28125000f,0.90625000f,0.57812500f,-0.81250000f,-0.68750000f,-0.75000000f,-0.29687500f,0.18750000f,-0.81250000f,-0.45312500f,-0.87500000f,0.85937500f,0.73437500f,-0.42187500f,-0.92187500f,0.50000000f,-0.59375000f,0.07812500f,-0.29687500f,0.65625000f,-0.23437500f,0.98437500f,-0.26562500f,0.62500000f,-0.43750000f,-0.85937500f,0.70312500f,0.07812500f,-0.31250000f,0.51562500f,-0.23437500f,0.82812500f,-0.65625000f,0.46875000f,0.67187500f,0.31250000f,-0.29687500f,-0.17187500f,-0.79687500f,-0.70312500f,0.65625000f,0.68750000f,0.96875000f,0.04687500f,-0.03125000f,0.79687500f,0.82812500f,0.98437500f,-0.67187500f,-0.54687500f,-0.51562500f,-0.67187500f,-0.78125000f,-0.93750000f,0.46875000f,0.46875000f,-0.29687500f,-0.96875000f,-0.84375000f,-0.98437500f,-0.57812500f,-0.85937500f,-0.68750000f,-0.84375000f,0.43750000f,0.46875000f,-0.50000000f,-0.98437500f,0.34375000f,-0.01562500f,-0.93750000f,-0.51562500f,-0.17187500f,0.10937500f,0.32812500f,-0.96875000f,-0.07812500f,0.56250000f,0.87500000f,-0.01562500f,-0.25000000f,-0.59375000f,-0.20312500f,0.23437500f,0.09375000f,0.75000000f,-0.68750000f,-0.42187500f,-1.00000000f,0.79687500f,0.25000000f,0.31250000f,0.01562500f,-0.93750000f,0.40625000f,-0.20312500f,-0.93750000f,-0.75000000f,-0.82812500f,-0.75000000f,-0.21875000f,0.17187500f,-0.85937500f,-0.64062500f,-0.09375000f,0.35937500f,0.06250000f,-0.84375000f,0.01562500f,0.21875000f,0.81250000f,-0.60937500f,-0.67187500f,-0.93750000f,0.71875000f,0.07812500f,0.01562500f,0.53125000f,0.18750000f,-0.98437500f,-0.07812500f,0.17187500f,0.90625000f,-0.21875000f,-0.15625000f,-0.70312500f,-0.89062500f,-0.67187500f,0.85937500f,-0.82812500f,0.29687500f,0.73437500f,-0.51562500f,0.87500000f,0.53125000f,0.68750000f,0.60937500f,-0.96875000f,-0.50000000f,0.56250000f,-0.82812500f,0.31250000f,-0.48437500f,0.93750000f,0.12500000f,0.03125000f,0.28125000f,-0.60937500f,-0.20312500f,0.26562500f,-0.50000000f,0.06250000f,0.40625000f,-0.53125000f,0.29687500f,0.92187500f,0.60937500f,-0.75000000f,-0.64062500f,-0.26562500f,0.45312500f,0.03125000f,-0.29687500f,0.34375000f,-0.07812500f,-0.68750000f,0.60937500f,-0.73437500f,-0.45312500f,0.89062500f,-0.39062500f,-0.70312500f,-0.90625000f,-0.92187500f,-0.87500000f,0.39062500f,0.73437500f,0.01562500f,-0.07812500f,-0.51562500f,0.79687500f,0.32812500f,0.20312500f,-0.95312500f,-0.26562500f,-0.31250000f,1.00000000f,-0.93750000f,-0.32812500f,-0.26562500f,0.51562500f,0.76562500f,-0.65625000f,0.51562500f,0.06250000f,-0.54687500f,-0.12500000f,0.57812500f,0.82812500f,-0.67187500f,0.39062500f,0.32812500f,0.28125000f,0.96875000f,0.45312500f,0.59375000f,-0.35937500f,-0.37500000f,0.12500000f,0.76562500f,0.43750000f,0.89062500f,-0.25000000f,0.84375000f,-0.89062500f,-0.03125000f,0.57812500f,-0.67187500f,-0.21875000f,0.23437500f,-0.25000000f,0.39062500f,-0.79687500f,-0.17187500f,-0.92187500f,-0.65625000f,0.73437500f,-0.70312500f,-0.65625000f,-0.25000000f,-0.70312500f,0.64062500f,0.31250000f,0.87500000f,-0.93750000f,0.21875000f,0.57812500f,0.39062500f,0.93750000f,0.40625000f,0.87500000f,-0.18750000f,-0.23437500f,0.96875000f,-0.79687500f,0.39062500f,-0.85937500f,-0.79687500f,-0.40625000f,-0.92187500f,-0.12500000f,0.76562500f,0.09375000f,-0.40625000f,-0.84375000f,-0.95312500f,-0.71875000f,-0.17187500f,-0.62500000f,-0.78125000f,0.10937500f,-0.45312500f,-0.65625000f,-0.59375000f,0.98437500f,0.73437500f,0.85937500f,-0.87500000f,-0.67187500f,-0.98437500f,-0.17187500f,0.95312500f,-0.81250000f,0.84375000f,-0.90625000f,0.92187500f,-0.85937500f,-0.82812500f,0.54687500f,0.21875000f,0.09375000f,-0.15625000f,0.45312500f,0.28125000f,-0.96875000f,0.45312500f,0.62500000f,0.56250000f,-0.31250000f,-0.31250000f,0.57812500f,0.14062500f,0.34375000f,0.09375000f,-0.21875000f,0.57812500f,-0.82812500f,0.96875000f,-0.75000000f,0.60937500f,-0.92187500f,-0.07812500f,0.89062500f,0.43750000f,0.23437500f,0.15625000f,0.12500000f,-0.78125000f,-0.46875000f,0.03125000f,0.62500000f,0.53125000f,-0.85937500f,-0.78125000f,0.60937500f,0.15625000f,0.68750000f,0.87500000f,0.93750000f,0.53125000f,-0.93750000f,-0.48437500f,-0.23437500f,-0.45312500f,0.39062500f,0.10937500f,-0.14062500f,0.93750000f,0.64062500f,0.95312500f,0.96875000f,0.73437500f,-0.12500000f,0.75000000f,-0.64062500f,0.04687500f,-0.51562500f,-0.39062500f,-0.10937500f,0.62500000f,0.85937500f,0.46875000f,0.04687500f,0.42187500f,-0.96875000f,0.71875000f,-0.85937500f,-0.45312500f,0.46875000f,0.07812500f,-0.56250000f,-0.64062500f,-0.68750000f,0.04687500f,0.25000000f,-0.64062500f,-0.23437500f,0.03125000f,-0.45312500f,0.12500000f,0.93750000f,-0.35937500f,0.23437500f,0.96875000f,0.48437500f,0.56250000f,0.09375000f,-0.57812500f,-0.42187500f,0.53125000f,-0.25000000f,-0.87500000f,-0.54687500f,0.64062500f,0.00000000f,0.03125000f,0.10937500f,-0.67187500f,-0.32812500f,-0.10937500f,-0.59375000f,0.87500000f,-0.43750000f,0.96875000f,0.48437500f,0.59375000f,-0.18750000f,-0.85937500f,0.89062500f,-0.20312500f,0.07812500f,-0.98437500f,0.01562500f,0.18750000f,0.39062500f,0.96875000f,0.15625000f,-0.82812500f,0.93750000f,0.17187500f,0.39062500f,-0.40625000f,0.89062500f,-0.59375000f,0.40625000f,0.78125000f,-0.10937500f,0.79687500f,0.56250000f,-0.28125000f,-0.48437500f,-0.82812500f,-0.70312500f,0.34375000f,0.57812500f,0.00000000f,0.28125000f,0.70312500f,0.39062500f,-0.29687500f,-0.25000000f,-0.90625000f,-0.32812500f,-0.85937500f,0.37500000f,0.93750000f,-0.20312500f,-0.48437500f,0.92187500f,0.79687500f,-0.29687500f,0.06250000f,-0.31250000f,0.34375000f,0.67187500f,0.57812500f,0.25000000f,-0.56250000f,0.92187500f,-0.26562500f,-0.71875000f,0.68750000f,0.65625000f,0.46875000f,0.09375000f,0.39062500f,-0.39062500f,0.75000000f,0.70312500f,-0.89062500f,-0.56250000f,0.40625000f,0.95312500f,0.10937500f,-0.26562500f,-0.73437500f,0.20312500f,0.06250000f,-0.68750000f,-0.60937500f,-0.71875000f,0.40625000f,0.75000000f,-0.46875000f,0.57812500f,-0.29687500f,0.37500000f,0.51562500f,-0.73437500f,0.90625000f,0.75000000f,-0.64062500f,0.71875000f,0.62500000f,0.70312500f,0.32812500f,0.81250000f,0.57812500f,0.71875000f,-0.67187500f,-0.56250000f,-0.07812500f,-1.00000000f,-0.48437500f,0.32812500f,0.98437500f,0.98437500f,-0.98437500f,-0.56250000f,0.68750000f,-0.95312500f,-0.37500000f,0.82812500f,0.67187500f,0.28125000f,0.51562500f,0.46875000f,-0.56250000f,-0.32812500f,-0.56250000f,-0.31250000f,-0.29687500f,0.18750000f,-0.17187500f,1.00000000f,0.96875000f,0.50000000f,-0.68750000f,0.75000000f,-0.39062500f,-0.28125000f,-0.90625000f,0.40625000f,0.96875000f,-0.03125000f,0.32812500f,0.67187500f,-0.60937500f,-0.25000000f,-0.57812500f,0.06250000f,0.56250000f,0.76562500f,-0.65625000f,-0.45312500f,0.54687500f,-0.92187500f,-0.39062500f,0.15625000f,0.71875000f,-0.29687500f,0.67187500f,-0.03125000f,0.40625000f,-0.79687500f,-0.90625000f,0.59375000f,0.39062500f,-0.25000000f,-0.04687500f,-0.07812500f,-0.06250000f,0.04687500f,0.59375000f,0.98437500f,0.59375000f,0.48437500f,-0.43750000f,0.03125000f,0.25000000f,0.96875000f,-0.07812500f,0.56250000f,-0.03125000f,0.20312500f,0.87500000f,-0.26562500f,-0.48437500f,-0.42187500f,0.39062500f,-0.10937500f,-0.81250000f,-0.31250000f,-0.18750000f,0.73437500f,-0.75000000f,-0.40625000f,0.56250000f,-0.90625000f,0.68750000f,0.31250000f,0.48437500f,0.23437500f,0.65625000f,-0.50000000f,0.76562500f,0.42187500f,0.37500000f,0.57812500f,0.60937500f,-0.46875000f,0.28125000f,0.85937500f,0.34375000f,0.65625000f,0.82812500f,-0.54687500f,-0.92187500f,-0.89062500f,-0.28125000f,-0.98437500f,-0.54687500f,-0.37500000f,-0.06250000f,0.48437500f,0.60937500f,-0.95312500f,0.32812500f,0.45312500f,0.50000000f,-0.42187500f,-0.98437500f,0.81250000f,-0.59375000f,0.73437500f,0.92187500f,-0.60937500f,-0.65625000f,0.46875000f,-1.00000000f,-0.68750000f});
    auto b = backend->create_tensor(element::f32, shape_b);
    copy_data(b, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f});
    auto result = backend->create_tensor(element::f32, shape_r);

    vector<float> expected_result{1.60595703f,0.84790039f,1.90112305f,-2.31103516f,0.29687500f,2.05883789f,-4.57641602f,2.64184570f,0.64331055f,-1.77783203f,1.57275391f,-2.06469727f,-1.06298828f,0.76806641f,-0.59716797f,-0.96972656f,1.10424805f,-2.77929688f,2.63818359f,-2.48657227f,0.51782227f,4.47290039f,2.51293945f,2.43725586f,-2.33666992f,-1.29248047f,-0.38940430f,1.80371094f,0.96313477f,-2.38354492f,-0.59448242f,3.34643555f,-2.08862305f,-1.62597656f,-1.39453125f,0.47509766f,-0.19824219f,1.69555664f,-0.45898438f,0.29760742f,1.09155273f,-1.43408203f,-0.38232422f,-0.91528320f,-1.16113281f,3.31127930f,-0.58007812f,1.52392578f,0.01684570f,0.10546875f,0.04882812f,-0.63037109f,1.46313477f,3.44750977f,3.12646484f,-2.13989258f,-1.73632812f,-3.35888672f,-0.85913086f,-2.22998047f,1.25537109f,3.07299805f,-2.33764648f,-2.26196289f,1.88354492f,2.09057617f,-1.97216797f,-2.07202148f,-1.38647461f,-2.31054688f,0.87841797f,3.90209961f,-2.12500000f,2.98681641f,-3.09716797f,-4.10522461f,-0.85400391f,-1.53271484f,1.40747070f,-1.09716797f,1.69140625f,0.13330078f,0.88134766f,3.16699219f,0.62011719f,0.74487305f,0.18457031f,-0.39990234f,0.53930664f,2.81152344f,0.10327148f,0.35717773f,-1.40283203f,1.18725586f,0.98657227f,-0.48803711f,-0.64086914f,-1.58862305f,-0.15991211f,-1.92749023f,-1.92944336f,2.34155273f,2.15966797f,-1.24877930f,-0.60888672f,2.38281250f,2.83862305f,0.35449219f,2.03076172f,-2.04418945f,1.03881836f,-3.01782227f,-0.94360352f,0.08032227f,-0.19213867f,-0.65087891f,0.15893555f,1.87744141f,2.19335938f,-1.71386719f,1.41040039f,2.85522461f,-3.56420898f,0.76611328f,-3.00634766f,-0.55712891f,-0.55273438f,1.37768555f,2.55712891f,-0.86645508f,-1.71704102f,-1.12329102f,-0.17456055f,-2.65893555f,-0.62768555f,1.76684570f,-5.04785156f,2.87817383f,1.21606445f,-2.80761719f,-0.02124023f,4.30639648f,0.73022461f,1.06640625f,-2.18115234f,1.61425781f,-0.65649414f,1.62817383f,0.84912109f,-1.55639648f,-2.14575195f,0.56958008f,0.22656250f,1.98095703f,2.57543945f,1.19287109f,0.30029297f,3.47021484f,1.91748047f,0.71069336f,-1.23168945f,1.69189453f,-1.70263672f,-5.29809570f,-0.46020508f,0.28662109f,1.44970703f,-1.59033203f,4.20336914f,1.37280273f,-5.33959961f,-0.17309570f,-1.76000977f,-0.54687500f,0.16259766f,2.47216797f,-0.38159180f,-0.61669922f,3.63525391f,-0.08764648f,0.50048828f,0.10229492f,-0.78247070f,-0.51806641f,2.66015625f,0.91870117f,2.13134766f,-0.56713867f,2.51342773f,0.95971680f,-0.91650391f,0.13623047f,3.30102539f,0.35644531f,1.80859375f,1.84594727f,1.06030273f,-0.61523438f,-4.01977539f,1.67602539f,-2.61865234f,-1.39501953f,0.70361328f,-1.55761719f,0.65014648f,-4.63085938f,2.44360352f,-4.82617188f,-3.76635742f,0.41406250f,-2.34399414f,0.30053711f,-2.15112305f,-2.65844727f,5.34326172f,3.20263672f,-2.26416016f,-2.81591797f,-2.33447266f,-4.10449219f,-2.54003906f,-0.45605469f,-1.42358398f,-0.42944336f,-2.11791992f,0.73681641f,1.39794922f,-0.83422852f,2.82519531f,-0.16259766f,-1.01562500f,-3.24096680f,-3.47705078f,0.03271484f,-1.28149414f,0.47534180f,-0.08496094f,-0.78491211f,-0.79638672f,3.82299805f,-1.30444336f,-2.78881836f,-1.84643555f,2.03857422f,3.82714844f,1.07617188f,-3.93994141f,-0.84106445f,-0.65576172f,0.96191406f,-1.77099609f,1.66577148f,3.23168945f,0.88574219f,1.11279297f,-0.32885742f,1.58374023f,2.43994141f,0.72753906f,-1.08911133f,1.95751953f,3.00146484f,2.02807617f,-1.90649414f,0.38549805f,-1.60595703f,3.26220703f,-0.59375000f,-0.85937500f,0.45727539f,2.92065430f,1.23803711f,-1.29760742f,0.96826172f,-1.47045898f,-1.64575195f,-3.11645508f,-2.98095703f,1.41894531f,1.09057617f,-1.12841797f,-0.57641602f,-1.15014648f,-2.94213867f,0.72167969f,-4.03637695f,6.36547852f,-0.65966797f,-1.03735352f,-1.09887695f,-2.92651367f,-0.65209961f,-0.09082031f,-0.35791016f,0.43603516f,0.04052734f,0.53271484f,-0.08032227f,-4.61425781f,-1.89892578f,-1.32788086f,-1.71850586f,1.73608398f,-1.80346680f,1.91699219f,2.40551758f,4.01025391f,-4.31054688f,-1.18872070f,-1.51586914f,0.42333984f,1.97875977f,0.73217773f,-1.43310547f,-3.12304688f,2.90014648f,-4.92285156f,-0.47241211f,-1.19067383f,-0.36938477f,2.79614258f,1.43017578f,-1.26098633f,2.73876953f,-1.10986328f,-0.75854492f,0.76171875f,5.70581055f,2.82690430f,4.18994141f,3.73706055f,0.51879883f,0.66992188f,-1.08618164f,1.56567383f,-0.47314453f,-1.57763672f,2.72680664f,-0.66748047f,1.75463867f,1.51977539f,-0.58862305f,-0.77124023f,-0.03027344f,-1.36230469f,0.72094727f,0.46020508f,2.60668945f,-2.58447266f,-1.33129883f,-1.20190430f,-3.37500000f,-0.28881836f,-1.47460938f,0.43774414f,-0.80664062f,1.20336914f,2.03417969f,-0.95410156f,2.74951172f,-1.70947266f,-1.15844727f,-0.98535156f,-2.22827148f,-1.43554688f,0.32714844f,1.30029297f,-0.25976562f,-0.60815430f,0.74975586f,1.05786133f,-0.10156250f,1.57543945f,1.01293945f,-3.47265625f,1.99462891f,4.38232422f,0.85571289f,-3.04711914f,-2.50048828f,1.83691406f,4.01269531f,-0.93164062f,-1.52709961f,2.45288086f,-1.18872070f,-0.55957031f,2.49316406f,-0.05834961f,2.43066406f,0.39770508f,1.28637695f,-0.13867188f,0.33764648f,4.06079102f,-0.26220703f,2.04541016f,-1.69116211f,-3.10375977f,-0.24560547f,5.17553711f,2.58715820f,-2.30346680f,1.00732422f,0.22705078f,-0.43286133f,0.36791992f,2.17846680f,-2.44311523f,4.48339844f,1.15185547f,2.89526367f,2.72753906f,6.54931641f,-2.55151367f,0.84790039f,4.41064453f,3.68383789f,-3.27734375f,1.92358398f,3.00585938f,1.32763672f,1.38720703f,2.84887695f,4.71093750f,0.72412109f,-0.70996094f,0.04125977f,1.86572266f,3.70214844f,1.28222656f,-3.31372070f,1.96362305f,1.08544922f,-0.66625977f,2.23876953f,0.72070312f,-4.29663086f,0.06420898f,-0.67089844f,-1.34106445f,-1.72778320f,-0.09985352f,0.45776367f,2.15307617f,-0.77294922f,-0.67236328f,-0.02856445f,0.14794922f,-1.50781250f,0.35937500f,-0.94824219f,-1.04858398f,4.11132812f,0.63208008f,-2.19213867f,1.20361328f,1.47729492f,-1.38549805f,0.85229492f,4.82202148f,2.15551758f,1.82836914f,-2.52246094f,2.47753906f,1.27172852f,-1.53540039f,3.55175781f,2.57885742f,1.64721680f,0.58569336f,-0.05883789f,0.06860352f,-0.00341797f,2.37377930f,5.02709961f,4.01977539f,-0.55029297f,2.21630859f,2.63403320f,-0.37182617f,-0.84277344f,-0.32617188f,1.50854492f,-0.78637695f,1.65502930f,0.07788086f,-2.27368164f,0.70922852f,2.78442383f,5.13549805f,-3.47070312f,-1.15332031f,1.54370117f,-2.42480469f,0.19702148f,-2.15478516f,1.92236328f,-0.33276367f,3.66333008f,0.15405273f,0.77563477f,-3.24707031f,-0.89208984f,-0.18994141f,2.08227539f,1.91821289f,-2.37353516f,-0.86132812f,-2.49829102f,-0.57495117f,-0.09863281f,1.82617188f,2.28710938f,-1.85961914f,1.30786133f,-2.21582031f,1.33740234f,3.01831055f,0.95751953f,0.01171875f,1.16479492f,0.00122070f,2.41699219f,-4.41796875f,0.08398438f,0.13769531f,-1.50268555f,2.12744141f,-0.80590820f,-1.44799805f,-0.55834961f,-2.74243164f,-0.63330078f,1.33740234f,-1.86840820f,-2.68261719f,3.42675781f,-2.04736328f,-0.16479492f,0.54785156f,-1.92138672f,0.05053711f,-0.20336914f,3.03198242f,2.09838867f,2.17456055f,-1.75927734f,-0.73291016f,-1.70068359f,0.19018555f,-0.49902344f,3.48120117f,-0.90283203f,2.96533203f,-1.82055664f,-1.09985352f,2.90112305f,-3.46948242f,-0.48535156f,0.55053711f,3.11499023f,0.24023438f,0.21411133f,-0.50976562f,-5.68969727f,2.63208008f,0.13500977f,-2.90917969f,0.37622070f,0.19970703f,-1.38183594f,-0.09594727f,1.41040039f,0.05810547f,-0.66406250f,0.03710938f,3.38403320f,-0.13818359f,-2.12524414f,2.44091797f,1.53198242f,0.94409180f,1.50732422f,-1.47656250f,-2.01831055f,0.05615234f,2.27343750f,-2.35351562f,1.50854492f,1.83691406f,0.49072266f,1.19140625f,-0.00512695f,0.46508789f,3.07031250f,-1.68408203f,-1.13793945f,4.64477539f,-0.43261719f,0.89404297f,1.59130859f,-3.74145508f,-1.52758789f,-0.48510742f,-4.09350586f,-0.04467773f,-1.67993164f,3.56811523f,-0.83886719f,0.02001953f,-1.30175781f,2.03833008f,1.65869141f,-0.15478516f,0.48144531f,1.22753906f,-1.25146484f,1.39746094f,-1.45141602f,0.23315430f,0.74072266f,-0.64233398f,-1.35058594f,-0.08398438f,-3.20507812f,0.30371094f,-0.36865234f,-1.87133789f,-3.18750000f,-2.70092773f,-2.78735352f,-2.52636719f,2.51000977f,1.92236328f,2.25805664f,0.69604492f,1.03100586f,0.65893555f,3.43432617f,1.87158203f,3.61645508f,-3.03393555f,-0.36450195f,-0.04223633f,-0.75537109f,-0.26440430f,0.12036133f,-2.63305664f,-0.08984375f,1.15991211f,-1.74951172f,0.51489258f,-2.32934570f,-1.34350586f,-1.05224609f,0.03833008f,-0.44018555f,1.44946289f,-3.15307617f,-1.51391602f,3.52709961f,0.84741211f,-0.67773438f,-2.15917969f,2.08471680f,-1.93725586f,-0.55834961f,-0.09863281f,4.36791992f,0.44433594f,-0.83862305f,2.16967773f,-1.14843750f,-3.73388672f,0.23242188f,0.14892578f,0.70874023f,1.44628906f,1.51660156f,-2.93920898f,-1.28393555f,1.62451172f,-3.80126953f,2.35888672f,-1.55664062f,0.78149414f,0.46484375f,-0.85424805f,-0.11743164f,0.36279297f,-2.30444336f,5.29858398f,-2.16577148f,-1.46606445f,0.02832031f,0.45385742f,0.06835938f,4.31420898f,2.10815430f,1.53149414f,1.57861328f,1.70166016f,-2.36889648f,3.64746094f,-6.09326172f,-4.24584961f,-2.72192383f,1.66552734f,-0.01953125f,-1.71313477f,4.54052734f,-0.98071289f,-1.40332031f,-0.19702148f,1.62426758f,2.07934570f,-1.80786133f,-0.44116211f,0.75927734f,0.60107422f,2.64331055f,2.58178711f,1.46337891f,1.59350586f,-1.85766602f,-4.27880859f,-1.03906250f,-2.75805664f,0.77026367f,0.21386719f,1.23559570f,1.91235352f,1.54833984f,-3.08447266f,2.42138672f,1.83374023f,-6.72998047f,-2.88769531f,3.11767578f,0.46557617f,0.81860352f,1.27270508f,-2.40844727f,0.66479492f,0.50634766f,-1.96411133f,-1.29443359f,-2.83520508f,1.83471680f,-5.62426758f,-1.72949219f,3.33398438f,-3.16650391f,-0.20263672f,1.49560547f,0.87768555f,-3.88281250f,1.49414062f,-0.00292969f,2.09594727f,-0.93627930f,5.00219727f,0.81274414f,0.74414062f,-1.22485352f,2.27148438f,-1.95947266f,4.26440430f,-1.84887695f,-0.89208984f,-2.95678711f,2.40527344f,-0.26879883f,1.21899414f,-3.95556641f,-4.57104492f,-3.87158203f,-1.11401367f,-3.05541992f,-4.43530273f,-0.36474609f,1.61181641f,-2.37280273f,-3.59521484f,0.80908203f,1.00585938f,-0.00415039f,-0.02636719f,-1.31152344f,-1.62768555f,-0.82470703f,-1.94677734f,1.81738281f,0.07055664f,-1.18041992f,-1.88256836f,4.43212891f,-2.88012695f,4.39306641f,-0.91650391f,1.02075195f,1.05395508f,0.37768555f,0.96313477f,2.74609375f,0.73754883f,0.72753906f,-1.02246094f,-1.60180664f,-1.83715820f,-0.42138672f,-3.41162109f,-1.40161133f,0.80493164f,1.94238281f,1.17016602f,0.52490234f,1.16748047f,0.54101562f,-1.48315430f,0.32714844f,-1.36987305f,0.06933594f,-1.14038086f,0.98779297f,-2.36206055f,-2.16479492f,-1.29956055f,0.30639648f,2.57592773f,-0.60424805f,-0.74121094f,-0.57177734f,-0.61596680f,-3.48706055f,0.19116211f,2.69604492f,-2.11694336f,-1.37280273f,-1.03857422f,0.59130859f,0.00024414f,0.56225586f,-1.39355469f,3.37670898f,-0.08227539f,2.02221680f,1.38378906f,-3.98046875f,-0.91015625f,0.49829102f,0.98828125f,-4.12622070f,2.91308594f,0.49316406f,0.74023438f,-0.97216797f,-1.23266602f,-2.04980469f,0.62524414f,-3.22167969f,0.41210938f,-0.53295898f,0.20068359f,3.66894531f,-0.34960938f,-1.98901367f,0.79541016f,-0.33740234f,-1.83886719f,-1.11767578f,2.01831055f,2.15405273f,0.45971680f,1.36547852f,1.65869141f,3.14306641f,-2.18408203f,1.29736328f,-2.22778320f,2.20581055f,-1.46508789f,0.66235352f,0.38574219f,-2.92480469f,-4.08349609f,4.48315430f,-0.59008789f,-1.14697266f,-0.22070312f,1.31054688f,-2.46923828f,1.67602539f,-1.81420898f,1.38793945f};

    auto handle = backend->compile(function);
    handle->call_with_validate({result}, {a, b});
    EXPECT_TRUE(test::all_close_f(vector<float>{expected_result}, read_vector<float>(result), tolerance));
    // only test backprop for certain cases as it takes significant compute resources
    // EXPECT_TRUE(autodiff_numeric_compare<float>(backend.get(), make_graph, {a, b}, .01f, .01f));
}

// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// DO NOT EDIT THIS FILE. If you want to add new tests, you should edit
//  test/ref_generators/generate_convolution_ref.py and regenerate this file.
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! DO NOT EDIT THIS FILE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!! THIS FILE IS AUTOGENERATED OUTSIDE OF THE BUILD PROCESS !!!!!!!!!!!!!!
NGRAPH_TEST (${BACKEND_NAME}, convolution_4d_4items_strided_dilated)
{
    Shape shape_a{4,3,8,8,8,8};
    Shape shape_b{4,3,2,2,3,1};
    Shape shape_r{4,4,2,4,1,3};
    auto make_graph = [shape_a, shape_b] {
        auto A = make_shared<op::v0::Parameter>(element::f32, shape_a);
        auto B = make_shared<op::v0::Parameter>(element::f32, shape_b);
        return make_shared<Function>(make_shared<op::v0::Convolution>(A, B,
                                                                  Strides{3,2,2,3},        // move_strides
                                                                  Strides{2,1,3,2},        // filter_dilation
                                                                  CoordinateDiff{0,0,0,0}, // below_pads
                                                                  CoordinateDiff{0,0,0,0}, // above_pads
                                                                  Strides{1,1,1,1}),       // data_dilation
                                     ParameterVector{A, B});
    };

    auto backend = runtime::Backend::create("${BACKEND_NAME}");
    auto function = make_graph();

    // Create some tensors for input/output
    auto a = backend->create_tensor(element::f32, shape_a);
    copy_data(a, vector<float>{0.67187500f,0.54687500f,-0.56250000f,-0.35937500f,-0.09375000f,0.54687500f,-0.54687500f,0.89062500f,0.82812500f,-0.54687500f,1.00000000f,-0.07812500f,-0.89062500f,0.40625000f,-0.35937500f,0.54687500f,0.60937500f,0.59375000f,0.09375000f,-0.21875000f,0.76562500f,0.40625000f,-0.73437500f,-0.95312500f,-0.50000000f,-0.29687500f,0.76562500f,-0.26562500f,-0.50000000f,0.53125000f,0.23437500f,-0.29687500f,0.98437500f,-0.92187500f,0.51562500f,0.50000000f,-0.32812500f,-0.01562500f,-0.95312500f,-0.81250000f,0.31250000f,-0.59375000f,-0.65625000f,0.06250000f,-0.06250000f,0.03125000f,-0.46875000f,0.79687500f,0.51562500f,-0.67187500f,-0.81250000f,0.54687500f,-0.78125000f,0.71875000f,0.51562500f,-0.71875000f,-0.15625000f,0.82812500f,0.87500000f,0.15625000f,0.96875000f,0.79687500f,0.78125000f,0.73437500f,-0.68750000f,-0.07812500f,-0.87500000f,-0.59375000f,-0.40625000f,0.64062500f,-0.18750000f,0.17187500f,-0.04687500f,0.78125000f,0.57812500f,0.96875000f,-0.10937500f,0.95312500f,-0.32812500f,0.56250000f,0.35937500f,0.09375000f,-0.64062500f,0.00000000f,-0.84375000f,-0.53125000f,0.50000000f,-0.07812500f,0.53125000f,0.53125000f,0.75000000f,0.65625000f,-0.23437500f,0.59375000f,0.48437500f,-0.39062500f,-0.53125000f,0.89062500f,-0.48437500f,0.31250000f,0.64062500f,-0.21875000f,0.31250000f,-0.45312500f,-0.71875000f,0.46875000f,-0.71875000f,0.40625000f,0.34375000f,0.28125000f,-0.15625000f,-0.51562500f,0.51562500f,0.07812500f,-0.76562500f,-0.67187500f,-0.78125000f,-0.06250000f,-0.20312500f,-0.84375000f,-0.90625000f,-0.70312500f,-0.82812500f,0.96875000f,-0.46875000f,-0.96875000f,-0.40625000f,-0.12500000f,0.92187500f,-0.06250000f,-0.23437500f,-0.79687500f,0.28125000f,-0.29687500f,0.17187500f,-0.56250000f,0.35937500f,-0.67187500f,0.25000000f,0.71875000f,0.03125000f,0.10937500f,-0.51562500f,0.81250000f,-0.62500000f,0.39062500f,-0.75000000f,0.37500000f,-0.18750000f,0.82812500f,0.50000000f,-0.90625000f,-0.76562500f,-0.75000000f,-0.79687500f,-0.79687500f,0.10937500f,-0.67187500f,0.89062500f,0.14062500f,0.96875000f,-0.32812500f,0.45312500f,-0.06250000f,-0.31250000f,-0.15625000f,0.85937500f,-0.75000000f,-0.37500000f,0.87500000f,0.93750000f,-0.17187500f,0.06250000f,0.45312500f,-0.81250000f,0.85937500f,-0.89062500f,-0.03125000f,-0.35937500f,0.10937500f,0.01562500f,0.12500000f,0.93750000f,0.96875000f,-0.01562500f,0.14062500f,0.43750000f,0.37500000f,0.92187500f,0.04687500f,-0.62500000f,-0.78125000f,0.15625000f,-0.53125000f,-0.15625000f,-0.90625000f,0.68750000f,0.98437500f,0.04687500f,-0.46875000f,0.75000000f,0.01562500f,-0.73437500f,0.17187500f,0.17187500f,0.70312500f,-0.34375000f,-0.23437500f,0.18750000f,0.01562500f,0.32812500f,0.96875000f,0.32812500f,-0.46875000f,-0.51562500f,-0.75000000f,-0.81250000f,-0.62500000f,-0.03125000f,-0.70312500f,-0.20312500f,-0.62500000f,-0.60937500f,0.62500000f,0.76562500f,0.06250000f,-0.06250000f,0.95312500f,0.65625000f,-0.59375000f,0.04687500f,0.75000000f,-0.90625000f,-0.26562500f,-0.29687500f,-1.00000000f,-0.87500000f,-0.12500000f,0.71875000f,-0.89062500f,-0.62500000f,-0.81250000f,0.26562500f,0.31250000f,-0.48437500f,0.37500000f,0.65625000f,0.07812500f,-0.57812500f,0.35937500f,0.73437500f,-0.37500000f,-0.92187500f,-0.65625000f,0.09375000f,0.26562500f,0.26562500f,0.48437500f,0.34375000f,0.42187500f,-0.62500000f,0.45312500f,0.96875000f,-0.28125000f,0.18750000f,-0.40625000f,-0.20312500f,-0.70312500f,0.93750000f,-0.26562500f,0.79687500f,0.53125000f,0.79687500f,-0.53125000f,0.06250000f,-0.09375000f,-0.26562500f,0.01562500f,0.32812500f,0.96875000f,-0.85937500f,0.26562500f,0.60937500f,0.37500000f,-0.64062500f,-0.34375000f,-0.56250000f,-0.23437500f,0.81250000f,-0.82812500f,-0.73437500f,0.10937500f,-0.26562500f,0.46875000f,-0.51562500f,0.48437500f,0.96875000f,-0.17187500f,-0.82812500f,0.96875000f,-0.73437500f,-0.54687500f,0.01562500f,0.85937500f,-0.21875000f,-0.06250000f,-0.04687500f,0.09375000f,-0.84375000f,0.75000000f,-0.87500000f,0.03125000f,-0.10937500f,0.65625000f,0.60937500f,-0.95312500f,0.25000000f,0.53125000f,0.65625000f,0.25000000f,0.71875000f,0.03125000f,-0.17187500f,0.57812500f,-0.20312500f,0.78125000f,0.95312500f,-0.12500000f,-0.93750000f,-0.48437500f,-0.42187500f,-0.79687500f,0.10937500f,-0.48437500f,-0.48437500f,0.48437500f,0.43750000f,-0.28125000f,0.10937500f,0.04687500f,0.65625000f,-0.31250000f,0.89062500f,0.70312500f,-0.87500000f,0.42187500f,-0.64062500f,0.42187500f,-0.48437500f,0.60937500f,0.32812500f,0.92187500f,-0.73437500f,-0.06250000f,0.37500000f,0.12500000f,-0.60937500f,0.98437500f,0.87500000f,-0.93750000f,0.18750000f,-0.70312500f,0.06250000f,-0.18750000f,-0.67187500f,0.09375000f,-0.03125000f,0.62500000f,0.96875000f,0.68750000f,0.43750000f,-0.73437500f,0.90625000f,-0.82812500f,0.03125000f,-0.14062500f,0.50000000f,-0.81250000f,0.82812500f,-0.26562500f,-0.45312500f,0.15625000f,-0.15625000f,-0.31250000f,0.07812500f,0.26562500f,0.76562500f,0.98437500f,-0.46875000f,-0.32812500f,0.93750000f,-0.23437500f,-0.04687500f,0.89062500f,0.34375000f,-0.15625000f,0.96875000f,0.90625000f,-0.46875000f,-0.40625000f,0.85937500f,-0.73437500f,0.23437500f,0.20312500f,-0.71875000f,-0.73437500f,0.23437500f,-0.37500000f,0.37500000f,0.29687500f,0.00000000f,-0.75000000f,-0.79687500f,-0.62500000f,-0.18750000f,-0.87500000f,0.25000000f,0.21875000f,-0.85937500f,0.50000000f,-0.73437500f,0.04687500f,0.95312500f,0.59375000f,0.40625000f,0.67187500f,0.92187500f,-0.96875000f,0.71875000f,0.12500000f,0.48437500f,0.82812500f,-0.42187500f,0.67187500f,0.09375000f,-0.60937500f,0.28125000f,0.53125000f,-0.70312500f,0.45312500f,0.84375000f,0.92187500f,0.32812500f,-0.06250000f,0.40625000f,0.84375000f,-0.60937500f,0.25000000f,-0.46875000f,0.51562500f,-0.40625000f,0.48437500f,-0.62500000f,0.34375000f,-0.15625000f,-0.90625000f,0.78125000f,-0.50000000f,-0.89062500f,0.12500000f,-0.03125000f,0.29687500f,0.64062500f,-0.59375000f,0.70312500f,0.65625000f,-0.98437500f,0.71875000f,-0.81250000f,-0.26562500f,-0.79687500f,0.23437500f,0.37500000f,0.78125000f,-0.85937500f,0.42187500f,-0.06250000f,-0.78125000f,0.50000000f,0.14062500f,-0.79687500f,-0.45312500f,0.53125000f,0.93750000f,0.98437500f,0.59375000f,0.85937500f,0.65625000f,0.00000000f,-0.92187500f,0.95312500f,0.03125000f,-0.34375000f,0.06250000f,-0.53125000f,-0.71875000f,0.39062500f,-0.01562500f,-0.17187500f,-0.43750000f,0.65625000f,-0.42187500f,-0.90625000f,0.12500000f,-0.17187500f,-0.46875000f,0.45312500f,-0.89062500f,-0.34375000f,-0.43750000f,0.67187500f,0.26562500f,0.10937500f,0.67187500f,0.14062500f,-0.45312500f,0.92187500f,0.75000000f,0.71875000f,-1.00000000f,0.62500000f,-0.67187500f,0.34375000f,-0.57812500f,0.04687500f,-0.90625000f,-0.62500000f,0.98437500f,-0.64062500f,0.85937500f,-0.34375000f,0.40625000f,0.46875000f,0.70312500f,0.10937500f,-0.28125000f,0.40625000f,0.21875000f,0.96875000f,-0.53125000f,0.01562500f,-0.82812500f,-0.54687500f,-0.06250000f,0.81250000f,0.06250000f,-0.57812500f,-0.59375000f,0.01562500f,0.64062500f,0.85937500f,0.60937500f,0.23437500f,0.93750000f,0.01562500f,-0.71875000f,-0.85937500f,0.54687500f,0.20312500f,-0.65625000f,-0.28125000f,-0.06250000f,-0.04687500f,0.48437500f,0.01562500f,-1.00000000f,0.23437500f,0.12500000f,0.51562500f,0.20312500f,-0.09375000f,-0.23437500f,0.82812500f,0.21875000f,-0.39062500f,0.98437500f,-0.48437500f,-0.32812500f,-0.45312500f,-0.87500000f,0.82812500f,-0.93750000f,-0.43750000f,0.50000000f,-0.09375000f,-0.20312500f,-0.85937500f,0.48437500f,0.26562500f,-0.50000000f,0.04687500f,-0.04687500f,0.26562500f,0.35937500f,-0.03125000f,-0.93750000f,0.07812500f,-0.60937500f,0.95312500f,0.43750000f,-0.34375000f,-0.60937500f,-0.03125000f,-0.82812500f,0.81250000f,0.95312500f,0.70312500f,0.59375000f,-0.48437500f,0.23437500f,0.90625000f,-0.51562500f,-1.00000000f,0.71875000f,-0.21875000f,0.01562500f,-0.31250000f,-0.73437500f,-0.96875000f,-0.42187500f,-0.40625000f,0.98437500f,0.64062500f,-0.50000000f,-0.65625000f,-0.96875000f,-0.12500000f,-0.43750000f,-0.45312500f,0.53125000f,0.25000000f,0.53125000f,0.25000000f,-0.89062500f,-0.56250000f,-0.78125000f,0.92187500f,-0.07812500f,0.37500000f,-0.46875000f,-0.82812500f,-0.51562500f,0.23437500f,-0.12500000f,-0.18750000f,-0.62500000f,-0.93750000f,-0.81250000f,-0.68750000f,-0.01562500f,0.71875000f,0.67187500f,-0.28125000f,0.65625000f,0.71875000f,-0.03125000f,-0.93750000f,0.70312500f,-0.28125000f,-0.29687500f,0.71875000f,-0.82812500f,0.71875000f,-0.14062500f,0.84375000f,0.26562500f,0.75000000f,0.51562500f,-0.45312500f,-0.37500000f,-0.81250000f,-0.96875000f,0.64062500f,-0.85937500f,-0.57812500f,-0.59375000f,0.03125000f,-0.32812500f,0.93750000f,-0.20312500f,0.87500000f,0.42187500f,-0.62500000f,0.84375000f,0.29687500f,0.82812500f,0.75000000f,-0.42187500f,-0.17187500f,-0.17187500f,-0.93750000f,0.43750000f,-0.51562500f,0.59375000f,-0.75000000f,0.46875000f,0.43750000f,0.56250000f,-0.42187500f,-0.51562500f,0.37500000f,0.71875000f,-0.07812500f,-0.50000000f,0.25000000f,0.73437500f,0.28125000f,-0.81250000f,-0.64062500f,-0.01562500f,-1.00000000f,1.00000000f,0.64062500f,-0.01562500f,0.45312500f,0.12500000f,-0.07812500f,0.93750000f,0.17187500f,0.18750000f,0.76562500f,0.76562500f,-0.14062500f,-0.09375000f,-0.65625000f,0.70312500f,0.92187500f,-0.51562500f,0.93750000f,0.65625000f,-0.26562500f,-0.92187500f,0.14062500f,0.71875000f,0.14062500f,-0.87500000f,-0.04687500f,0.42187500f,0.17187500f,-0.21875000f,-0.29687500f,-0.01562500f,0.04687500f,-0.53125000f,-0.53125000f,-0.60937500f,0.32812500f,-0.48437500f,-0.62500000f,1.00000000f,0.09375000f,-0.64062500f,0.57812500f,0.09375000f,-0.23437500f,-0.60937500f,-0.31250000f,-0.17187500f,0.48437500f,0.25000000f,0.50000000f,0.67187500f,-0.20312500f,-0.20312500f,0.85937500f,0.70312500f,-0.43750000f,0.75000000f,-0.57812500f,-0.51562500f,-0.59375000f,0.85937500f,-0.04687500f,0.31250000f,-0.75000000f,0.93750000f,0.45312500f,-0.48437500f,0.21875000f,0.57812500f,0.20312500f,0.14062500f,0.06250000f,-0.31250000f,-0.79687500f,0.93750000f,-0.87500000f,0.95312500f,0.96875000f,-0.48437500f,0.75000000f,-0.95312500f,0.01562500f,-0.46875000f,-0.29687500f,-0.46875000f,-0.90625000f,-0.20312500f,-0.39062500f,-0.96875000f,0.79687500f,-0.75000000f,0.14062500f,0.89062500f,-0.09375000f,-0.26562500f,-0.96875000f,0.59375000f,-0.21875000f,-0.23437500f,0.95312500f,0.54687500f,-0.31250000f,-0.26562500f,-0.12500000f,0.31250000f,0.65625000f,0.03125000f,-0.28125000f,-0.87500000f,-0.35937500f,-0.96875000f,-0.37500000f,0.32812500f,0.95312500f,-0.70312500f,-0.89062500f,0.28125000f,-0.04687500f,-0.35937500f,-0.42187500f,-0.87500000f,-0.25000000f,0.23437500f,-0.56250000f,0.81250000f,0.50000000f,0.90625000f,0.20312500f,0.85937500f,-0.95312500f,0.39062500f,0.17187500f,0.09375000f,0.18750000f,-0.29687500f,0.28125000f,-0.40625000f,-0.89062500f,-0.51562500f,-0.31250000f,0.48437500f,-0.29687500f,-0.92187500f,-0.62500000f,0.31250000f,-0.57812500f,0.43750000f,-0.85937500f,-0.12500000f,-0.82812500f,0.04687500f,0.06250000f,0.98437500f,0.95312500f,-0.25000000f,-0.31250000f,-0.26562500f,0.82812500f,0.62500000f,-0.65625000f,0.04687500f,0.71875000f,0.39062500f,0.82812500f,-0.53125000f,0.85937500f,0.62500000f,0.62500000f,-0.85937500f,0.96875000f,0.54687500f,0.00000000f,-0.71875000f,0.70312500f,-0.85937500f,-0.50000000f,-1.00000000f,0.20312500f,0.71875000f,-0.21875000f,-0.75000000f,0.14062500f,0.34375000f,-0.35937500f,0.09375000f,-0.40625000f,-0.51562500f,0.37500000f,-0.67187500f,0.06250000f,-0.79687500f,-0.50000000f,0.51562500f,-0.18750000f,-0.84375000f,-0.60937500f,-0.50000000f,0.71875000f,-0.25000000f,0.75000000f,-0.98437500f,0.12500000f,0.96875000f,0.23437500f,0.31250000f,-0.06250000f,0.59375000f,0.09375000f,0.39062500f,0.40625000f,0.00000000f,0.17187500f,0.15625000f,-0.90625000f,-0.95312500f,0.59375000f,-0.31250000f,-0.39062500f,-0.95312500f,-0.54687500f,0.70312500f,-0.96875000f,-0.10937500f,0.56250000f,0.73437500f,-0.68750000f,0.46875000f,-0.06250000f,0.48437500f,0.50000000f,-0.64062500f,-0.40625000f,0.68750000f,-0.95312500f,-0.73437500f,0.42187500f,0.45312500f,-0.62500000f,-0.84375000f,-0.31250000f,-0.84375000f,0.37500000f,-0.43750000f,0.71875000f,-0.37500000f,0.46875000f,-0.57812500f,0.26562500f,0.54687500f,-0.45312500f,-0.28125000f,0.54687500f,-0.50000000f,0.46875000f,-0.42187500f,-0.76562500f,-0.51562500f,-0.28125000f,-0.43750000f,0.65625000f,-0.01562500f,-0.64062500f,-0.95312500f,-0.01562500f,0.90625000f,-0.46875000f,0.26562500f,-0.03125000f,-0.60937500f,0.93750000f,-0.82812500f,0.79687500f,-0.23437500f,0.04687500f,0.39062500f,-0.67187500f,-0.76562500f,0.01562500f,-0.04687500f,-0.96875000f,-0.15625000f,0.43750000f,-0.20312500f,0.07812500f,-0.04687500f,-0.51562500f,0.18750000f,-0.53125000f,-0.46875000f,-0.96875000f,0.01562500f,0.59375000f,0.81250000f,-0.31250000f,0.57812500f,-0.93750000f,0.04687500f,-0.92187500f,-0.32812500f,-0.12500000f,0.60937500f,-0.57812500f,-0.82812500f,-0.26562500f,0.14062500f,-0.35937500f,0.76562500f,-0.20312500f,-0.76562500f,-0.95312500f,-0.10937500f,0.43750000f,0.82812500f,-1.00000000f,0.57812500f,-0.89062500f,0.01562500f,0.48437500f,-0.46875000f,0.01562500f,-0.51562500f,-0.67187500f,-0.90625000f,-0.56250000f,0.07812500f,0.45312500f,0.95312500f,1.00000000f,0.76562500f,-0.40625000f,0.64062500f,0.21875000f,0.81250000f,0.50000000f,0.62500000f,-0.01562500f,0.96875000f,-0.32812500f,0.71875000f,-0.20312500f,0.87500000f,0.95312500f,-0.85937500f,-0.79687500f,0.34375000f,0.71875000f,0.89062500f,-0.48437500f,0.84375000f,-0.90625000f,0.17187500f,0.21875000f,0.00000000f,-0.23437500f,0.82812500f,0.06250000f,-0.67187500f,0.76562500f,0.10937500f,-0.54687500f,0.57812500f,-0.89062500f,-0.95312500f,-0.93750000f,-0.75000000f,-0.84375000f,-1.00000000f,0.32812500f,-0.85937500f,-0.85937500f,0.62500000f,0.40625000f,0.46875000f,-0.35937500f,-0.90625000f,0.18750000f,0.45312500f,1.00000000f,-0.14062500f,-0.96875000f,-0.70312500f,0.57812500f,-0.10937500f,-0.09375000f,-0.10937500f,0.85937500f,0.50000000f,-0.59375000f,0.54687500f,-0.76562500f,0.28125000f,-0.29687500f,-0.34375000f,0.67187500f,-1.00000000f,0.31250000f,-0.35937500f,-0.10937500f,0.76562500f,0.12500000f,-0.25000000f,0.34375000f,-0.18750000f,-0.03125000f,-0.50000000f,0.48437500f,0.43750000f,0.90625000f,-0.96875000f,-1.00000000f,-0.54687500f,-0.75000000f,0.45312500f,0.75000000f,0.26562500f,1.00000000f,-0.28125000f,-0.64062500f,0.43750000f,-0.18750000f,0.18750000f,0.06250000f,-0.96875000f,-1.00000000f,-0.81250000f,-0.28125000f,0.92187500f,-0.43750000f,0.23437500f,-0.26562500f,0.76562500f,-0.60937500f,1.00000000f,-0.73437500f,-0.42187500f,-0.50000000f,-0.37500000f,-0.62500000f,0.10937500f,0.46875000f,-0.04687500f,0.21875000f,-0.32812500f,0.93750000f,0.01562500f,-0.14062500f,0.67187500f,-0.46875000f,-0.90625000f,-0.76562500f,0.20312500f,0.28125000f,0.26562500f,0.29687500f,1.00000000f,0.45312500f,-0.43750000f,-0.68750000f,-0.64062500f,0.87500000f,0.84375000f,-0.26562500f,-0.96875000f,0.78125000f,0.53125000f,0.14062500f,0.43750000f,1.00000000f,-0.21875000f,0.48437500f,-0.56250000f,0.20312500f,-0.18750000f,0.65625000f,-0.42187500f,-0.15625000f,-0.73437500f,-0.09375000f,-0.21875000f,-0.03125000f,-1.00000000f,0.81250000f,0.81250000f,-0.40625000f,-0.31250000f,-0.50000000f,-1.00000000f,-0.20312500f,0.82812500f,-0.26562500f,1.00000000f,0.79687500f,0.35937500f,0.12500000f,0.40625000f,0.68750000f,-0.98437500f,0.42187500f,0.90625000f,-0.12500000f,0.39062500f,0.45312500f,0.25000000f,0.40625000f,-0.51562500f,0.48437500f,-0.37500000f,0.07812500f,-0.78125000f,0.10937500f,0.03125000f,0.25000000f,-1.00000000f,0.28125000f,-0.78125000f,-0.07812500f,0.68750000f,-0.26562500f,0.07812500f,0.28125000f,0.37500000f,-0.25000000f,0.01562500f,0.26562500f,-0.93750000f,-0.04687500f,-0.95312500f,0.00000000f,0.00000000f,-0.89062500f,-0.42187500f,-0.84375000f,0.45312500f,0.34375000f,-0.64062500f,0.53125000f,0.34375000f,-0.06250000f,0.45312500f,-0.51562500f,-0.17187500f,-0.96875000f,0.56250000f,-0.53125000f,-0.10937500f,-0.78125000f,-0.03125000f,-0.20312500f,-0.42187500f,0.87500000f,0.96875000f,-0.71875000f,-0.60937500f,0.71875000f,0.28125000f,-0.73437500f,0.40625000f,0.65625000f,-0.45312500f,-0.50000000f,-0.07812500f,0.25000000f,0.68750000f,-0.06250000f,0.28125000f,-0.78125000f,0.65625000f,-0.42187500f,-0.71875000f,-0.26562500f,0.92187500f,0.90625000f,-0.67187500f,-0.42187500f,-0.76562500f,0.76562500f,-0.73437500f,-0.54687500f,0.15625000f,-0.71875000f,0.15625000f,-0.20312500f,-0.48437500f,-0.29687500f,-0.20312500f,-0.31250000f,0.93750000f,-0.76562500f,-0.45312500f,0.89062500f,-0.67187500f,-0.42187500f,-0.65625000f,1.00000000f,0.21875000f,-0.53125000f,0.01562500f,0.28125000f,0.39062500f,-0.51562500f,-0.81250000f,-0.25000000f,-0.06250000f,0.50000000f,0.59375000f,0.53125000f,1.00000000f,0.14062500f,0.14062500f,-0.40625000f,-0.15625000f,-0.37500000f,0.29687500f,0.14062500f,-0.21875000f,0.98437500f,0.84375000f,-0.89062500f,-0.45312500f,0.04687500f,-0.14062500f,-0.18750000f,-0.82812500f,0.12500000f,-0.17187500f,0.62500000f,-0.95312500f,-0.28125000f,-0.43750000f,-0.89062500f,-0.42187500f,-0.98437500f,0.42187500f,0.18750000f,0.50000000f,0.26562500f,-0.98437500f,0.65625000f,0.56250000f,0.73437500f,0.34375000f,0.73437500f,-0.37500000f,0.56250000f,-0.85937500f,-0.42187500f,0.50000000f,0.12500000f,0.34375000f,0.07812500f,0.35937500f,-0.84375000f,0.78125000f,-0.76562500f,-0.56250000f,-0.04687500f,-0.21875000f,0.42187500f,-0.07812500f,-0.96875000f,1.00000000f,0.84375000f,0.70312500f,-0.51562500f,-0.64062500f,-0.73437500f,0.67187500f,0.40625000f,0.00000000f,-0.56250000f,-0.28125000f,-0.90625000f,-0.39062500f,-0.20312500f,0.93750000f,0.34375000f,0.95312500f,0.17187500f,0.15625000f,-0.78125000f,0.12500000f,0.81250000f,-0.84375000f,-0.40625000f,0.21875000f,-0.37500000f,-0.42187500f,0.31250000f,0.23437500f,-0.03125000f,-0.15625000f,-0.48437500f,-0.50000000f,-0.04687500f,0.70312500f,0.51562500f,-0.34375000f,-0.73437500f,0.35937500f,-0.78125000f,-0.75000000f,-0.28125000f,0.67187500f,-0.76562500f,-0.87500000f,0.25000000f,0.51562500f,0.92187500f,-0.09375000f,0.81250000f,0.26562500f,-0.46875000f,0.64062500f,-0.54687500f,-0.31250000f,-0.06250000f,0.89062500f,-0.59375000f,0.73437500f,-0.17187500f,0.42187500f,0.20312500f,0.57812500f,0.65625000f,-0.39062500f,-0.76562500f,0.40625000f,-0.03125000f,-0.01562500f,-0.95312500f,0.81250000f,0.90625000f,0.56250000f,0.07812500f,-0.46875000f,-0.37500000f,0.70312500f,0.46875000f,0.68750000f,0.39062500f,0.31250000f,0.65625000f,-0.79687500f,-0.89062500f,-0.42187500f,-0.31250000f,0.28125000f,0.35937500f,0.15625000f,-0.21875000f,-0.50000000f,0.84375000f,0.34375000f,0.78125000f,0.93750000f,-0.70312500f,0.21875000f,0.34375000f,0.46875000f,-1.00000000f,0.82812500f,0.39062500f,0.34375000f,0.64062500f,-0.46875000f,0.00000000f,-0.03125000f,-0.79687500f,0.43750000f,-0.10937500f,0.73437500f,0.25000000f,-0.34375000f,0.37500000f,0.76562500f,-0.54687500f,-0.03125000f,0.48437500f,0.56250000f,-1.00000000f,0.12500000f,-0.50000000f,0.00000000f,0.50000000f,-0.79687500f,0.25000000f,0.03125000f,0.09375000f,-0.50000000f,0.07812500f,-0.75000000f,-0.31250000f,-0.60937500f,0.35937500f,0.48437500f,0.28125000f,0.95312500f,0.12500000f,0.20312500f,0.62500000f,0.79687500f,-0.34375000f,-0.10937500f,-0.28125000f,0.06250000f,-0.01562500f,0.46875000f,-0.95312500f,-0.20312500f,-0.89062500f,-0.40625000f,-0.15625000f,0.62500000f,-0.20312500f,0.82812500f,1.00000000f,0.04687500f,-0.39062500f,-0.81250000f,-0.85937500f,-0.09375000f,0.84375000f,-0.18750000f,0.84375000f,0.59375000f,0.92187500f,-0.68750000f,-0.93750000f,-0.53125000f,0.28125000f,-0.93750000f,-0.32812500f,-0.23437500f,0.89062500f,0.98437500f,0.31250000f,-0.42187500f,0.28125000f,0.18750000f,0.35937500f,0.48437500f,-0.76562500f,0.90625000f,0.96875000f,-1.00000000f,-0.57812500f,-0.15625000f,0.62500000f,0.96875000f,0.71875000f,-0.82812500f,-0.76562500f,-0.81250000f,0.73437500f,-0.09375000f,-0.10937500f,0.43750000f,0.96875000f,-0.12500000f,0.34375000f,0.07812500f,-0.50000000f,0.48437500f,-0.62500000f,0.70312500f,0.14062500f,-0.64062500f,0.92187500f,0.84375000f,-0.46875000f,-0.23437500f,-0.98437500f,0.35937500f,-0.29687500f,-0.95312500f,-0.31250000f,0.54687500f,-0.62500000f,0.45312500f,0.26562500f,-0.48437500f,0.25000000f,0.09375000f,0.31250000f,-0.37500000f,-0.51562500f,-0.67187500f,-0.03125000f,-0.09375000f,0.29687500f,0.98437500f,-0.18750000f,-0.89062500f,0.20312500f,0.67187500f,0.40625000f,-0.75000000f,0.67187500f,0.04687500f,0.01562500f,0.15625000f,-0.57812500f,-0.53125000f,0.51562500f,-0.39062500f,0.21875000f,-0.79687500f,-0.28125000f,-0.23437500f,-0.26562500f,0.34375000f,-0.40625000f,-0.46875000f,0.79687500f,0.28125000f,-0.17187500f,0.54687500f,0.07812500f,0.64062500f,0.21875000f,0.50000000f,-0.87500000f,-0.31250000f,0.90625000f,-0.84375000f,-0.84375000f,-1.00000000f,-0.71875000f,-0.03125000f,0.56250000f,-0.42187500f,0.45312500f,-0.60937500f,0.50000000f,0.17187500f,-0.46875000f,0.29687500f,0.73437500f,0.81250000f,-0.32812500f,0.25000000f,0.64062500f,0.51562500f,0.79687500f,-0.31250000f,-0.73437500f,-0.37500000f,-0.85937500f,0.95312500f,-0.87500000f,-0.79687500f,-0.21875000f,-0.92187500f,0.37500000f,0.90625000f,0.85937500f,-0.15625000f,1.00000000f,-0.92187500f,-0.37500000f,-0.71875000f,0.18750000f,0.70312500f,0.65625000f,0.46875000f,-0.85937500f,0.56250000f,-0.96875000f,-0.39062500f,-0.60937500f,-0.15625000f,0.20312500f,-0.37500000f,-0.75000000f,-0.17187500f,-0.67187500f,-0.75000000f,0.31250000f,-0.26562500f,-0.78125000f,-0.87500000f,-0.28125000f,-0.92187500f,0.96875000f,0.43750000f,-0.32812500f,-0.23437500f,0.04687500f,-0.90625000f,-0.14062500f,-0.89062500f,0.18750000f,-0.46875000f,-0.18750000f,-0.53125000f,0.43750000f,-0.73437500f,-0.98437500f,0.82812500f,0.15625000f,-0.51562500f,-0.46875000f,-0.53125000f,-0.07812500f,-0.23437500f,0.04687500f,-0.64062500f,0.18750000f,0.90625000f,-0.12500000f,-0.18750000f,0.93750000f,-0.98437500f,0.07812500f,-0.43750000f,0.51562500f,1.00000000f,-0.43750000f,0.31250000f,-0.98437500f,-0.34375000f,0.87500000f,-0.62500000f,1.00000000f,0.73437500f,-0.37500000f,0.85937500f,-0.70312500f,0.82812500f,0.18750000f,0.23437500f,0.07812500f,-0.67187500f,-0.93750000f,0.32812500f,0.89062500f,0.06250000f,-0.79687500f,-0.18750000f,0.65625000f,-0.92187500f,0.07812500f,-0.84375000f,0.15625000f,-0.32812500f,-0.43750000f,0.87500000f,0.87500000f,-0.70312500f,0.82812500f,-0.67187500f,-0.75000000f,-0.01562500f,-0.79687500f,0.15625000f,-0.21875000f,-0.31250000f,-0.48437500f,0.48437500f,-0.85937500f,-0.18750000f,-0.20312500f,0.45312500f,-0.87500000f,0.28125000f,0.81250000f,-0.56250000f,-0.12500000f,-0.06250000f,0.03125000f,-0.82812500f,0.56250000f,0.01562500f,-0.59375000f,-0.76562500f,0.70312500f,-1.00000000f,-0.87500000f,-0.68750000f,-0.64062500f,0.93750000f,-0.50000000f,0.73437500f,0.92187500f,-0.95312500f,-0.45312500f,-0.06250000f,-0.06250000f,-0.60937500f,-0.01562500f,-0.17187500f,0.34375000f,-0.95312500f,-0.01562500f,-0.85937500f,-0.85937500f,0.42187500f,-0.57812500f,-0.67187500f,0.35937500f,-0.06250000f,0.78125000f,-0.26562500f,-0.10937500f,0.92187500f,0.17187500f,0.46875000f,0.56250000f,0.20312500f,-0.42187500f,0.00000000f,0.12500000f,-0.92187500f,-0.14062500f,0.48437500f,-0.60937500f,0.50000000f,0.87500000f,0.25000000f,-0.59375000f,-0.04687500f,0.29687500f,0.31250000f,0.45312500f,-0.96875000f,-0.70312500f,0.87500000f,0.62500000f,-0.34375000f,-0.90625000f,0.07812500f,0.51562500f,0.35937500f,0.40625000f,-0.62500000f,0.48437500f,-0.50000000f,-0.23437500f,0.68750000f,-0.23437500f,-0.85937500f,0.95312500f,0.51562500f,-0.15625000f,0.35937500f,0.50000000f,0.73437500f,0.71875000f,-0.62500000f,0.45312500f,0.40625000f,-0.18750000f,-0.85937500f,0.42187500f,-0.67187500f,0.62500000f,-0.60937500f,-0.54687500f,0.21875000f,0.50000000f,0.65625000f,0.32812500f,0.87500000f,-0.01562500f,0.40625000f,0.17187500f,0.93750000f,-0.95312500f,-0.20312500f,-0.73437500f,0.40625000f,-0.20312500f,0.20312500f,-0.04687500f,-0.65625000f,0.64062500f,0.65625000f,-0.71875000f,0.31250000f,-0.35937500f,-0.28125000f,0.15625000f,1.00000000f,1.00000000f,0.43750000f,-0.20312500f,-0.53125000f,0.92187500f,0.90625000f,0.07812500f,0.50000000f,0.43750000f,-0.57812500f,0.84375000f,-0.67187500f,0.09375000f,-0.17187500f,-0.64062500f,0.14062500f,-0.67187500f,1.00000000f,-0.48437500f,-0.37500000f,0.00000000f,0.21875000f,0.96875000f,0.06250000f,-0.81250000f,0.78125000f,0.87500000f,0.67187500f,0.45312500f,-0.96875000f,-0.29687500f,-0.60937500f,0.70312500f,0.56250000f,0.59375000f,0.87500000f,0.95312500f,0.03125000f,-0.64062500f,-0.62500000f,-0.43750000f,0.51562500f,-0.17187500f,-0.06250000f,0.03125000f,-0.48437500f,-0.95312500f,-0.31250000f,-0.40625000f,-0.89062500f,-0.64062500f,0.23437500f,0.87500000f,0.48437500f,0.54687500f,0.82812500f,0.70312500f,-0.68750000f,0.87500000f,0.93750000f,0.92187500f,-0.03125000f,0.65625000f,0.04687500f,-0.25000000f,0.10937500f,-0.57812500f,-0.21875000f,0.25000000f,-0.15625000f,0.89062500f,0.35937500f,0.96875000f,-0.31250000f,-0.04687500f,-0.04687500f,0.46875000f,-0.51562500f,-0.25000000f,0.67187500f,-0.70312500f,0.28125000f,-0.48437500f,0.71875000f,-0.43750000f,-0.28125000f,-0.81250000f,0.70312500f,0.95312500f,0.31250000f,-0.31250000f,-0.29687500f,0.20312500f,-0.95312500f,0.64062500f,-0.87500000f,-0.42187500f,0.90625000f,-0.65625000f,-0.85937500f,-0.84375000f,0.50000000f,0.17187500f,-0.37500000f,-1.00000000f,-0.89062500f,-0.68750000f,0.53125000f,0.95312500f,0.17187500f,-0.70312500f,0.46875000f,0.53125000f,-0.31250000f,0.67187500f,0.89062500f,0.32812500f,-0.53125000f,-0.57812500f,0.54687500f,-0.98437500f,0.23437500f,0.01562500f,0.65625000f,-0.43750000f,-0.54687500f,0.93750000f,-0.71875000f,-0.84375000f,0.18750000f,0.59375000f,-0.95312500f,-0.50000000f,0.93750000f,-0.07812500f,-0.68750000f,0.85937500f,-0.35937500f,-0.26562500f,-0.79687500f,-0.95312500f,-0.90625000f,-0.50000000f,0.56250000f,0.85937500f,0.50000000f,-0.04687500f,0.35937500f,-0.78125000f,0.50000000f,-0.93750000f,-0.40625000f,-0.70312500f,0.15625000f,-0.07812500f,0.40625000f,0.70312500f,0.46875000f,-0.71875000f,-0.03125000f,-0.87500000f,-0.84375000f,-0.34375000f,0.00000000f,0.17187500f,-0.93750000f,0.62500000f,-0.76562500f,-0.26562500f,0.98437500f,0.40625000f,1.00000000f,-0.90625000f,-0.23437500f,0.50000000f,0.53125000f,-0.90625000f,-0.62500000f,0.96875000f,-0.59375000f,-0.10937500f,0.89062500f,-1.00000000f,0.70312500f,0.98437500f,0.15625000f,-0.26562500f,0.50000000f,0.56250000f,-0.26562500f,0.10937500f,0.78125000f,0.70312500f,0.20312500f,-0.84375000f,0.50000000f,0.96875000f,0.57812500f,-0.18750000f,0.03125000f,0.68750000f,-0.64062500f,-0.29687500f,-0.62500000f,0.32812500f,-0.90625000f,-0.39062500f,0.17187500f,0.73437500f,-0.65625000f,-0.10937500f,0.76562500f,0.59375000f,0.65625000f,-0.43750000f,0.39062500f,-0.18750000f,0.09375000f,0.07812500f,0.35937500f,0.15625000f,0.18750000f,-0.35937500f,0.78125000f,-0.45312500f,-0.87500000f,-0.50000000f,-0.60937500f,0.37500000f,-0.64062500f,0.32812500f,0.81250000f,-0.96875000f,-0.92187500f,-0.73437500f,0.07812500f,0.00000000f,-0.56250000f,-0.20312500f,0.32812500f,0.78125000f,0.78125000f,-0.32812500f,0.68750000f,-0.23437500f,-0.57812500f,-0.76562500f,-0.35937500f,-0.53125000f,0.04687500f,-0.45312500f,-0.04687500f,0.00000000f,0.48437500f,-0.59375000f,0.37500000f,0.81250000f,0.95312500f,-0.48437500f,0.20312500f,0.01562500f,-0.62500000f,-0.75000000f,-0.64062500f,0.65625000f,-0.50000000f,-0.18750000f,-0.84375000f,-0.14062500f,0.51562500f,0.03125000f,-0.50000000f,0.51562500f,-0.98437500f,0.93750000f,0.78125000f,-0.96875000f,-0.57812500f,0.31250000f,0.10937500f,0.92187500f,-0.92187500f,0.25000000f,-0.31250000f,-0.15625000f,0.09375000f,0.43750000f,-0.76562500f,-0.14062500f,-0.68750000f,-0.14062500f,-0.03125000f,0.90625000f,-0.71875000f,-0.56250000f,0.64062500f,0.76562500f,0.60937500f,0.81250000f,-0.48437500f,0.46875000f,0.65625000f,-0.29687500f,0.48437500f,-0.43750000f,0.82812500f,-0.26562500f,0.64062500f,-0.01562500f,0.35937500f,-0.29687500f,-0.84375000f,-0.92187500f,-0.84375000f,0.73437500f,0.09375000f,-0.53125000f,-0.15625000f,0.12500000f,0.84375000f,-0.78125000f,-0.51562500f,0.42187500f,0.25000000f,0.37500000f,0.18750000f,0.18750000f,0.67187500f,0.96875000f,0.62500000f,0.23437500f,0.57812500f,0.10937500f,-0.31250000f,-0.78125000f,0.79687500f,0.29687500f,0.96875000f,-0.70312500f,-0.96875000f,-0.75000000f,-0.01562500f,-0.37500000f,0.03125000f,0.10937500f,0.95312500f,-0.59375000f,0.78125000f,-0.20312500f,-0.15625000f,0.15625000f,-0.82812500f,0.60937500f,0.26562500f,0.32812500f,-0.90625000f,0.21875000f,-0.37500000f,0.37500000f,0.03125000f,-0.37500000f,-0.81250000f,0.81250000f,-0.89062500f,-0.75000000f,-0.96875000f,0.76562500f,0.43750000f,0.35937500f,-0.89062500f,0.75000000f,-0.04687500f,-1.00000000f,0.98437500f,0.70312500f,-0.85937500f,-0.17187500f,0.46875000f,0.56250000f,-0.25000000f,0.60937500f,-0.92187500f,-0.57812500f,0.89062500f,-0.29687500f,0.84375000f,-0.09375000f,0.28125000f,-0.06250000f,0.87500000f,0.12500000f,-0.25000000f,-0.96875000f,0.10937500f,-0.53125000f,0.89062500f,-0.62500000f,-0.57812500f,0.18750000f,0.07812500f,0.28125000f,-0.06250000f,0.34375000f,-0.46875000f,-0.35937500f,0.50000000f,-0.07812500f,1.00000000f,1.00000000f,0.45312500f,-0.82812500f,-0.59375000f,-0.90625000f,0.06250000f,-0.93750000f,0.85937500f,0.43750000f,0.89062500f,0.32812500f,-0.92187500f,0.87500000f,-0.62500000f,-0.62500000f,-0.25000000f,-0.70312500f,0.87500000f,0.57812500f,0.93750000f,0.84375000f,-0.48437500f,-0.40625000f,-0.90625000f,-0.48437500f,0.95312500f,-0.57812500f,0.40625000f,-0.90625000f,0.26562500f,-0.76562500f,-0.51562500f,0.85937500f,0.84375000f,0.45312500f,-0.76562500f,-0.12500000f,-0.03125000f,-1.00000000f,-0.65625000f,0.17187500f,0.12500000f,0.40625000f,1.00000000f,0.17187500f,-0.37500000f,0.48437500f,0.06250000f,-0.68750000f,-0.84375000f,0.35937500f,-0.14062500f,-0.12500000f,0.60937500f,-0.51562500f,1.00000000f,-0.25000000f,-0.81250000f,0.29687500f,-0.54687500f,0.35937500f,-0.60937500f,-0.98437500f,-0.12500000f,-0.31250000f,0.64062500f,-0.03125000f,0.46875000f,0.37500000f,0.53125000f,0.09375000f,-0.09375000f,0.60937500f,-0.56250000f,0.18750000f,-0.76562500f,0.00000000f,-0.15625000f,0.79687500f,0.53125000f,-0.46875000f,1.00000000f,-0.78125000f,0.39062500f,0.45312500f,0.35937500f,0.15625000f,-0.20312500f,-0.07812500f,-0.96875000f,0.71875000f,0.90625000f,-0.35937500f,-0.32812500f,0.79687500f,-0.57812500f,0.01562500f,-0.92187500f,0.46875000f,-0.15625000f,-0.53125000f,-0.56250000f,-0.42187500f,-0.26562500f,0.51562500f,-0.65625000f,0.60937500f,0.35937500f,-0.28125000f,-0.76562500f,0.12500000f,0.73437500f,0.25000000f,0.71875000f,-0.57812500f,-0.54687500f,-0.01562500f,0.89062500f,-0.85937500f,0.20312500f,-0.64062500f,-0.95312500f,0.35937500f,-0.82812500f,-0.75000000f,0.92187500f,-0.65625000f,-0.09375000f,-0.37500000f,0.78125000f,-0.81250000f,0.60937500f,0.76562500f,-0.48437500f,-0.32812500f,-0.75000000f,0.59375000f,-0.21875000f,0.98437500f,-0.45312500f,-0.35937500f,-0.48437500f,0.14062500f,-0.12500000f,-0.12500000f,0.48437500f,0.14062500f,0.21875000f,0.42187500f,1.00000000f,-0.95312500f,-0.28125000f,-0.54687500f,-1.00000000f,0.92187500f,0.35937500f,0.76562500f,0.79687500f,-0.71875000f,-0.46875000f,-0.32812500f,-0.17187500f,-0.46875000f,0.64062500f,-0.92187500f,-0.70312500f,-0.48437500f,-0.96875000f,0.76562500f,0.73437500f,0.28125000f,0.31250000f,-0.57812500f,-0.45312500f,-0.46875000f,-0.14062500f,-0.10937500f,0.48437500f,-0.39062500f,-0.21875000f,-0.04687500f,0.53125000f,-0.51562500f,-0.37500000f,-0.18750000f,0.53125000f,0.92187500f,-0.84375000f,-0.45312500f,0.34375000f,0.48437500f,-0.71875000f,0.46875000f,-0.04687500f,-0.96875000f,-0.56250000f,0.48437500f,-0.79687500f,-0.57812500f,0.64062500f,-0.50000000f,-0.64062500f,-0.64062500f,-0.92187500f,-0.82812500f,0.10937500f,-0.98437500f,0.90625000f,0.28125000f,-0.81250000f,-0.35937500f,0.50000000f,-0.73437500f,-0.62500000f,-0.76562500f,-0.71875000f,-0.17187500f,-0.21875000f,-0.51562500f,-0.73437500f,0.64062500f,0.90625000f,0.79687500f,0.96875000f,0.71875000f,0.23437500f,0.03125000f,0.98437500f,0.25000000f,0.62500000f,0.54687500f,0.20312500f,-0.87500000f,-0.25000000f,-0.82812500f,0.68750000f,-0.29687500f,0.12500000f,0.14062500f,0.14062500f,0.65625000f,-0.35937500f,0.84375000f,-0.78125000f,-0.64062500f,0.70312500f,-0.87500000f,-0.31250000f,-0.43750000f,0.15625000f,-0.07812500f,-0.96875000f,0.39062500f,-0.95312500f,0.17187500f,0.14062500f,0.32812500f,-0.81250000f,-0.25000000f,0.71875000f,0.82812500f,0.50000000f,-0.17187500f,0.17187500f,-0.15625000f,0.57812500f,0.18750000f,0.84375000f,0.48437500f,0.75000000f,0.85937500f,-0.20312500f,-0.71875000f,-0.37500000f,0.29687500f,0.90625000f,0.06250000f,-0.59375000f,-0.15625000f,0.70312500f,-0.23437500f,0.73437500f,0.03125000f,-0.37500000f,0.89062500f,0.20312500f,-0.89062500f,0.18750000f,0.82812500f,0.46875000f,0.85937500f,0.81250000f,-0.23437500f,0.76562500f,0.48437500f,0.87500000f,0.12500000f,-0.39062500f,0.29687500f,-0.14062500f,-0.07812500f,0.53125000f,0.17187500f,0.45312500f,0.82812500f,-0.45312500f,-0.68750000f,0.87500000f,-0.43750000f,0.15625000f,0.43750000f,0.65625000f,-0.26562500f,0.18750000f,0.79687500f,0.45312500f,-0.57812500f,0.62500000f,0.76562500f,0.45312500f,0.96875000f,0.65625000f,-0.82812500f,-0.28125000f,-0.31250000f,0.93750000f,0.17187500f,0.92187500f,0.07812500f,0.12500000f,0.56250000f,-0.39062500f,-0.40625000f,-0.32812500f,0.40625000f,-0.71875000f,-0.23437500f,0.17187500f,0.40625000f,0.59375000f,0.59375000f,-0.75000000f,-0.10937500f,-0.21875000f,-0.46875000f,-0.17187500f,0.56250000f,-0.32812500f,-0.01562500f,0.31250000f,-0.40625000f,0.01562500f,0.23437500f,0.51562500f,0.25000000f,0.09375000f,0.12500000f,0.79687500f,-0.65625000f,-0.40625000f,0.57812500f,-0.23437500f,0.34375000f,0.96875000f,-0.34375000f,-0.85937500f,-0.28125000f,-0.76562500f,-0.04687500f,0.84375000f,0.82812500f,-0.59375000f,-0.20312500f,-0.48437500f,0.32812500f,-0.54687500f,-0.46875000f,0.29687500f,0.64062500f,0.39062500f,0.14062500f,0.17187500f,-0.87500000f,0.43750000f,-0.82812500f,-0.43750000f,0.84375000f,0.01562500f,0.54687500f,-0.92187500f,-0.01562500f,-0.35937500f,-0.93750000f,-0.98437500f,0.60937500f,-0.43750000f,-0.87500000f,0.85937500f,-0.60937500f,0.40625000f,-0.10937500f,0.23437500f,0.32812500f,-0.92187500f,-0.57812500f,-0.45312500f,-0.73437500f,0.18750000f,-0.96875000f,-0.56250000f,0.12500000f,0.06250000f,-0.03125000f,-0.32812500f,0.32812500f,-0.67187500f,0.29687500f,-0.67187500f,0.42187500f,0.09375000f,-0.15625000f,-0.95312500f,0.79687500f,-0.32812500f,0.46875000f,-0.90625000f,0.32812500f,-0.92187500f,-0.21875000f,0.65625000f,-0.68750000f,-0.75000000f,-0.67187500f,-0.04687500f,-0.04687500f,0.43750000f,0.90625000f,0.23437500f,0.59375000f,0.62500000f,0.68750000f,-0.48437500f,0.95312500f,-0.51562500f,0.00000000f,0.31250000f,0.65625000f,-0.84375000f,-0.14062500f,-0.90625000f,0.29687500f,0.96875000f,-0.53125000f,0.06250000f,-0.28125000f,-0.26562500f,-0.96875000f,0.25000000f,0.96875000f,-0.23437500f,0.70312500f,0.96875000f,0.01562500f,0.59375000f,0.95312500f,-0.03125000f,-0.34375000f,0.96875000f,-0.56250000f,-0.57812500f,0.06250000f,0.65625000f,0.40625000f,-0.48437500f,-0.40625000f,-0.59375000f,-0.34375000f,-0.73437500f,-0.46875000f,-0.54687500f,0.29687500f,-0.31250000f,-0.23437500f,-0.62500000f,-0.54687500f,-0.60937500f,0.03125000f,0.40625000f,0.92187500f,-0.15625000f,0.43750000f,-0.59375000f,0.01562500f,-0.32812500f,0.93750000f,-0.96875000f,-0.79687500f,-0.76562500f,-0.85937500f,-1.00000000f,0.04687500f,0.29687500f,0.09375000f,0.79687500f,-0.93750000f,0.62500000f,0.06250000f,0.25000000f,-0.60937500f,0.50000000f,-0.31250000f,0.31250000f,-0.07812500f,0.93750000f,0.48437500f,-0.37500000f,-0.67187500f,0.06250000f,0.06250000f,0.67187500f,0.70312500f,0.20312500f,0.68750000f,-0.21875000f,0.03125000f,0.68750000f,-0.79687500f,-0.03125000f,0.21875000f,0.25000000f,0.20312500f,-0.92187500f,0.71875000f,0.37500000f,-0.96875000f,0.10937500f,0.39062500f,-0.67187500f,0.01562500f,-0.43750000f,0.93750000f,0.87500000f,0.56250000f,-0.60937500f,0.68750000f,0.12500000f,-0.12500000f,-0.51562500f,-0.56250000f,-0.18750000f,-0.04687500f,-0.29687500f,0.45312500f,-0.09375000f,-0.64062500f,0.93750000f,-0.59375000f,-0.37500000f,0.62500000f,0.09375000f,-0.60937500f,-0.76562500f,-0.71875000f,0.01562500f,0.59375000f,-0.54687500f,0.82812500f,0.15625000f,0.84375000f,-0.37500000f,-0.54687500f,-0.39062500f,-0.54687500f,-0.42187500f,0.14062500f,-0.79687500f,0.85937500f,-0.68750000f,-0.51562500f,-0.64062500f,-0.70312500f,-0.56250000f,-0.75000000f,0.85937500f,-0.81250000f,-0.84375000f,0.12500000f,0.23437500f,0.79687500f,-0.21875000f,-0.93750000f,0.46875000f,0.75000000f,0.43750000f,-0.53125000f,0.15625000f,0.37500000f,0.50000000f,0.51562500f,0.76562500f,-0.14062500f,0.45312500f,-0.87500000f,-0.71875000f,-0.40625000f,-0.92187500f,0.50000000f,-0.68750000f,-0.71875000f,-0.43750000f,0.79687500f,-0.01562500f,-0.95312500f,-0.31250000f,-0.51562500f,-0.28125000f,0.56250000f,-0.51562500f,0.59375000f,0.65625000f,0.21875000f,-0.56250000f,0.28125000f,0.01562500f,-0.56250000f,-0.59375000f,0.12500000f,-0.75000000f,0.03125000f,-0.53125000f,-0.50000000f,0.00000000f,0.04687500f,0.01562500f,-0.43750000f,-0.48437500f,-0.79687500f,0.50000000f,0.65625000f,-0.04687500f,-0.96875000f,-0.56250000f,-0.29687500f,0.18750000f,-0.01562500f,0.15625000f,0.10937500f,-0.62500000f,-0.18750000f,-0.93750000f,0.28125000f,0.32812500f,-0.12500000f,0.76562500f,0.31250000f,-0.59375000f,0.51562500f,-0.09375000f,-0.65625000f,0.95312500f,-0.78125000f,0.31250000f,-0.40625000f,-0.53125000f,0.56250000f,0.31250000f,0.14062500f,-0.65625000f,-0.65625000f,0.10937500f,0.42187500f,-0.25000000f,-0.01562500f,0.75000000f,0.92187500f,0.04687500f,0.17187500f,-0.59375000f,-0.56250000f,-0.10937500f,-0.40625000f,-0.84375000f,-0.87500000f,-0.50000000f,0.71875000f,-0.60937500f,0.20312500f,0.78125000f,-0.12500000f,0.62500000f,-0.12500000f,-0.50000000f,0.54687500f,-0.87500000f,-0.67187500f,-0.35937500f,-0.15625000f,0.64062500f,0.71875000f,0.42187500f,-0.12500000f,0.96875000f,0.87500000f,-0.57812500f,-0.10937500f,-0.23437500f,-0.85937500f,-0.73437500f,-0.40625000f,-0.90625000f,0.92187500f,-0.48437500f,0.06250000f,-0.21875000f,-0.42187500f,-0.39062500f,-0.59375000f,0.89062500f,-0.92187500f,0.04687500f,-0.40625000f,-0.15625000f,0.23437500f,-0.84375000f,-0.76562500f,-0.18750000f,0.98437500f,0.06250000f,0.85937500f,-0.07812500f,-0.95312500f,0.04687500f,0.43750000f,-0.93750000f,0.37500000f,-0.78125000f,0.46875000f,0.09375000f,0.64062500f,0.07812500f,-0.54687500f,-0.59375000f,-0.95312500f,-0.35937500f,0.70312500f,-0.45312500f,-0.39062500f,-0.60937500f,-0.67187500f,-0.14062500f,-0.82812500f,0.78125000f,0.23437500f,0.89062500f,-0.06250000f,-0.03125000f,0.45312500f,-0.54687500f,-0.37500000f,0.87500000f,0.09375000f,-0.79687500f,0.68750000f,-0.31250000f,0.70312500f,0.39062500f,-0.68750000f,-0.42187500f,0.32812500f,0.56250000f,0.76562500f,1.00000000f,0.54687500f,-0.70312500f,-0.06250000f,-0.10937500f,-0.56250000f,-0.68750000f,0.43750000f,0.87500000f,-0.39062500f,-0.59375000f,0.29687500f,-0.46875000f,-0.60937500f,-0.23437500f,0.68750000f,-0.60937500f,-0.32812500f,0.42187500f,0.56250000f,0.31250000f,0.31250000f,0.06250000f,-0.21875000f,-0.04687500f,-0.39062500f,-0.85937500f,0.96875000f,0.21875000f,0.51562500f,-0.79687500f,0.35937500f,-0.93750000f,0.39062500f,0.25000000f,0.01562500f,-0.89062500f,-0.26562500f,-0.79687500f,-0.46875000f,-0.79687500f,-0.25000000f,0.43750000f,0.56250000f,0.20312500f,1.00000000f,-0.56250000f,0.62500000f,0.12500000f,-0.29687500f,0.17187500f,-0.20312500f,-0.20312500f,-0.85937500f,-0.89062500f,0.57812500f,-0.68750000f,-0.87500000f,-0.71875000f,0.71875000f,-0.06250000f,-0.29687500f,-0.35937500f,-0.01562500f,-0.67187500f,0.00000000f,-0.29687500f,-0.82812500f,-0.56250000f,-0.04687500f,-0.81250000f,-0.23437500f,0.12500000f,-0.20312500f,-0.42187500f,0.89062500f,0.34375000f,0.00000000f,0.06250000f,-0.64062500f,-0.18750000f,0.18750000f,0.87500000f,-0.96875000f,-0.40625000f,-0.46875000f,-0.57812500f,-0.65625000f,-0.75000000f,-1.00000000f,0.64062500f,-0.57812500f,-0.56250000f,0.89062500f,0.67187500f,-0.29687500f,0.68750000f,-0.45312500f,0.68750000f,0.07812500f,-0.40625000f,0.39062500f,0.09375000f,-0.68750000f,-0.57812500f,-0.46875000f,-0.51562500f,0.60937500f,-0.32812500f,0.12500000f,0.26562500f,0.93750000f,-0.84375000f,0.12500000f,0.17187500f,-0.78125000f,-0.90625000f,-0.98437500f,-0.51562500f,-0.84375000f,-0.29687500f,-0.78125000f,-0.32812500f,-0.18750000f,0.23437500f,0.53125000f,-0.48437500f,0.67187500f,0.68750000f,0.62500000f,0.67187500f,-0.09375000f,-0.96875000f,-0.15625000f,-0.48437500f,-0.84375000f,-0.62500000f,-0.46875000f,-0.14062500f,0.81250000f,-0.64062500f,-0.46875000f,-0.20312500f,0.51562500f,-0.60937500f,0.95312500f,0.81250000f,-0.31250000f,-0.68750000f,0.40625000f,-0.90625000f,-0.10937500f,0.76562500f,-0.03125000f,-0.26562500f,-0.53125000f,-0.56250000f,-1.00000000f,-0.25000000f,-0.85937500f,0.09375000f,0.73437500f,-0.96875000f,0.01562500f,-0.57812500f,-0.95312500f,-0.01562500f,-0.84375000f,-0.45312500f,0.06250000f,-0.50000000f,-0.62500000f,0.71875000f,0.78125000f,0.79687500f,-0.46875000f,-0.84375000f,-0.50000000f,0.84375000f,0.73437500f,-0.93750000f,-0.10937500f,0.20312500f,-0.15625000f,-0.64062500f,-0.03125000f,0.75000000f,-0.65625000f,-0.54687500f,0.09375000f,-0.57812500f,0.29687500f,0.34375000f,-0.20312500f,-0.92187500f,-0.78125000f,-0.60937500f,-0.96875000f,-0.89062500f,0.57812500f,0.32812500f,-0.17187500f,0.59375000f,-0.40625000f,-0.25000000f,-0.39062500f,0.93750000f,0.00000000f,-0.98437500f,-0.39062500f,0.98437500f,0.96875000f,0.62500000f,-0.29687500f,0.43750000f,0.89062500f,0.84375000f,0.39062500f,-0.57812500f,-0.07812500f,0.68750000f,-0.29687500f,-0.54687500f,-1.00000000f,0.12500000f,-0.45312500f,-0.85937500f,-0.29687500f,-0.68750000f,0.39062500f,-0.28125000f,-0.70312500f,0.00000000f,-0.68750000f,-0.39062500f,0.00000000f,0.48437500f,0.28125000f,-0.89062500f,0.29687500f,0.45312500f,0.96875000f,0.65625000f,-0.89062500f,-0.26562500f,-0.25000000f,0.25000000f,-0.46875000f,0.95312500f,-0.17187500f,0.29687500f,-0.64062500f,0.50000000f,0.29687500f,-0.70312500f,0.53125000f,-0.04687500f,0.60937500f,0.10937500f,0.42187500f,0.45312500f,-0.34375000f,-0.48437500f,-0.67187500f,-0.25000000f,0.40625000f,0.56250000f,-0.82812500f,0.87500000f,-0.35937500f,0.75000000f,-0.43750000f,-0.29687500f,-0.43750000f,0.26562500f,-0.45312500f,-0.59375000f,0.00000000f,-0.06250000f,-0.70312500f,-0.59375000f,0.35937500f,-0.25000000f,-0.64062500f,0.32812500f,-0.12500000f,0.15625000f,0.53125000f,-0.75000000f,-0.50000000f,0.42187500f,-0.75000000f,0.43750000f,0.87500000f,0.57812500f,-0.10937500f,-0.81250000f,0.20312500f,-0.67187500f,-0.43750000f,-0.14062500f,0.21875000f,-0.81250000f,0.50000000f,0.59375000f,-0.32812500f,-0.60937500f,0.57812500f,0.46875000f,0.28125000f,-0.31250000f,1.00000000f,-0.31250000f,0.32812500f,0.98437500f,0.82812500f,-0.73437500f,0.07812500f,-1.00000000f,-1.00000000f,0.15625000f,0.45312500f,0.09375000f,0.60937500f,0.28125000f,-0.92187500f,-0.60937500f,0.42187500f,-0.85937500f,0.09375000f,-0.42187500f,-0.90625000f,0.96875000f,-0.50000000f,-0.39062500f,-0.12500000f,0.10937500f,-0.76562500f,0.71875000f,0.62500000f,0.71875000f,0.29687500f,0.14062500f,0.39062500f,0.89062500f,-0.01562500f,0.42187500f,0.39062500f,-0.48437500f,-0.46875000f,-0.34375000f,0.59375000f,-0.79687500f,0.06250000f,0.57812500f,0.26562500f,-1.00000000f,0.59375000f,-0.25000000f,-0.42187500f,-0.71875000f,-0.60937500f,0.09375000f,-0.65625000f,-0.20312500f,0.76562500f,-0.56250000f,0.15625000f,0.29687500f,0.60937500f,-0.78125000f,-0.73437500f,-0.26562500f,-0.43750000f,-0.60937500f,-0.20312500f,-0.82812500f,-0.51562500f,-0.92187500f,-0.46875000f,-0.62500000f,0.21875000f,0.04687500f,-0.62500000f,-0.85937500f,-0.98437500f,-0.18750000f,0.40625000f,-0.04687500f,0.48437500f,0.92187500f,0.53125000f,-0.59375000f,-0.42187500f,-0.95312500f,-0.75000000f,-0.04687500f,0.98437500f,0.92187500f,-0.39062500f,0.82812500f,0.20312500f,0.45312500f,-0.68750000f,0.54687500f,0.39062500f,0.84375000f,-0.90625000f,-0.35937500f,-0.07812500f,0.73437500f,-0.53125000f,-0.06250000f,-0.18750000f,-0.04687500f,-0.84375000f,0.65625000f,0.70312500f,-0.93750000f,0.76562500f,0.68750000f,0.39062500f,0.10937500f,-0.70312500f,-0.34375000f,-0.21875000f,0.32812500f,0.43750000f,-0.48437500f,0.37500000f,-0.20312500f,-0.85937500f,-0.90625000f,0.25000000f,-0.76562500f,-0.59375000f,-0.21875000f,0.82812500f,0.53125000f,-0.35937500f,0.01562500f,-0.43750000f,0.81250000f,0.25000000f,-0.32812500f,-0.21875000f,-0.42187500f,-0.23437500f,-0.34375000f,0.25000000f,-0.81250000f,-0.31250000f,0.71875000f,0.64062500f,-0.71875000f,0.76562500f,0.26562500f,0.01562500f,0.46875000f,0.82812500f,0.81250000f,-0.96875000f,0.96875000f,0.85937500f,0.82812500f,0.85937500f,-0.89062500f,0.18750000f,-0.87500000f,-0.78125000f,-0.59375000f,-0.84375000f,-0.57812500f,-0.21875000f,-0.10937500f,0.93750000f,0.20312500f,0.32812500f,0.04687500f,-0.18750000f,0.60937500f,0.31250000f,0.23437500f,0.03125000f,0.68750000f,-0.32812500f,-0.89062500f,-0.23437500f,-0.67187500f,0.15625000f,0.73437500f,-0.48437500f,0.56250000f,0.31250000f,0.39062500f,-0.65625000f,-0.67187500f,-0.90625000f,-0.43750000f,0.98437500f,-0.25000000f,-0.50000000f,-0.78125000f,0.06250000f,0.32812500f,-0.45312500f,-0.12500000f,0.17187500f,0.92187500f,-0.31250000f,0.01562500f,-0.70312500f,0.76562500f,0.53125000f,0.06250000f,0.95312500f,-0.46875000f,-0.39062500f,1.00000000f,0.59375000f,-0.20312500f,0.93750000f,-0.92187500f,-0.68750000f,-0.28125000f,0.18750000f,0.71875000f,0.18750000f,0.25000000f,-0.48437500f,0.01562500f,0.35937500f,0.48437500f,-0.54687500f,0.29687500f,0.73437500f,-0.51562500f,0.57812500f,-0.26562500f,0.46875000f,0.62500000f,0.62500000f,0.81250000f,0.17187500f,0.28125000f,-0.75000000f,-0.45312500f,-0.29687500f,0.37500000f,-0.71875000f,0.71875000f,0.93750000f,-0.42187500f,0.31250000f,-0.26562500f,0.81250000f,-0.15625000f,-0.62500000f,0.53125000f,0.12500000f,0.60937500f,0.60937500f,-0.04687500f,-0.90625000f,0.40625000f,0.12500000f,0.89062500f,0.09375000f,-0.14062500f,0.29687500f,-0.03125000f,-0.62500000f,0.17187500f,-0.67187500f,0.79687500f,0.53125000f,0.54687500f,-0.54687500f,0.71875000f,-0.03125000f,-0.14062500f,-0.56250000f,0.15625000f,0.90625000f,0.65625000f,0.00000000f,-0.35937500f,0.43750000f,-0.40625000f,0.57812500f,-0.25000000f,0.03125000f,0.04687500f,-0.42187500f,0.76562500f,0.85937500f,0.81250000f,-0.87500000f,-0.85937500f,0.14062500f,0.26562500f,0.03125000f,0.28125000f,0.17187500f,-0.50000000f,0.53125000f,-0.32812500f,-0.15625000f,0.18750000f,-0.92187500f,0.59375000f,0.34375000f,0.85937500f,-0.73437500f,0.28125000f,0.37500000f,0.62500000f,-0.92187500f,-0.09375000f,-0.31250000f,-0.51562500f,-0.68750000f,0.45312500f,0.01562500f,0.10937500f,0.42187500f,-0.15625000f,-0.28125000f,0.75000000f,-0.20312500f,0.45312500f,-0.85937500f,-0.85937500f,-0.23437500f,-0.54687500f,-0.51562500f,-0.71875000f,0.82812500f,0.93750000f,-0.62500000f,0.48437500f,-0.18750000f,0.60937500f,-0.39062500f,-0.21875000f,-0.79687500f,0.14062500f,0.93750000f,-0.32812500f,0.29687500f,0.15625000f,0.26562500f,-0.43750000f,-0.21875000f,0.28125000f,-0.17187500f,0.07812500f,0.31250000f,-0.68750000f,-0.03125000f,-0.14062500f,0.29687500f,0.01562500f,-0.90625000f,0.26562500f,0.26562500f,0.95312500f,0.81250000f,-0.03125000f,0.73437500f,0.06250000f,0.64062500f,-0.56250000f,-0.87500000f,0.65625000f,-0.85937500f,0.67187500f,-0.34375000f,-0.23437500f,-0.01562500f,-0.14062500f,0.78125000f,0.00000000f,-0.62500000f,0.62500000f,0.45312500f,-0.37500000f,0.32812500f,0.53125000f,0.85937500f,0.59375000f,0.98437500f,0.10937500f,0.32812500f,0.73437500f,-0.01562500f,-0.34375000f,-0.45312500f,-0.34375000f,-0.68750000f,-0.09375000f,-0.45312500f,0.23437500f,-0.14062500f,-0.21875000f,-0.70312500f,-0.26562500f,-0.35937500f,-0.14062500f,0.75000000f,-0.45312500f,-0.68750000f,-0.56250000f,0.03125000f,-0.71875000f,-0.09375000f,0.42187500f,0.68750000f,0.56250000f,0.34375000f,-0.32812500f,-0.29687500f,0.73437500f,0.18750000f,-0.23437500f,-0.25000000f,0.57812500f,-0.70312500f,0.90625000f,-0.78125000f,-0.57812500f,-0.75000000f,-0.70312500f,0.50000000f,-0.40625000f,-0.87500000f,0.28125000f,0.68750000f,-0.03125000f,-0.15625000f,-0.68750000f,-0.62500000f,-0.84375000f,-0.03125000f,0.98437500f,0.64062500f,-0.07812500f,-0.53125000f,0.92187500f,-0.78125000f,-0.23437500f,0.84375000f,-0.37500000f,-0.31250000f,-0.28125000f,-0.10937500f,0.76562500f,0.34375000f,0.92187500f,0.82812500f,-0.35937500f,-0.84375000f,-0.04687500f,-0.53125000f,-0.87500000f,0.81250000f,-0.53125000f,-0.39062500f,0.64062500f,0.04687500f,0.65625000f,0.31250000f,-0.46875000f,0.35937500f,0.15625000f,0.42187500f,-0.51562500f,0.64062500f,0.59375000f,-0.10937500f,-0.56250000f,-0.82812500f,-0.17187500f,-0.89062500f,-0.79687500f,-0.70312500f,-0.96875000f,-0.85937500f,0.57812500f,-0.29687500f,-0.34375000f,-0.14062500f,0.28125000f,0.04687500f,-0.81250000f,-0.17187500f,0.68750000f,0.56250000f,0.37500000f,0.50000000f,0.57812500f,0.62500000f,-0.46875000f,-0.76562500f,0.42187500f,0.76562500f,-0.45312500f,0.28125000f,-0.95312500f,-0.21875000f,-0.98437500f,-0.31250000f,-0.68750000f,0.62500000f,-0.23437500f,0.92187500f,0.65625000f,0.10937500f,-0.12500000f,0.93750000f,-0.53125000f,-0.87500000f,0.53125000f,-0.50000000f,-0.75000000f,0.54687500f,-0.17187500f,-0.81250000f,-0.39062500f,-0.17187500f,-0.31250000f,-0.39062500f,0.70312500f,0.25000000f,0.78125000f,0.85937500f,-0.87500000f,-0.98437500f,-0.10937500f,0.32812500f,0.21875000f,-0.46875000f,-0.28125000f,-0.28125000f,0.32812500f,-0.10937500f,-0.21875000f,-0.71875000f,0.79687500f,0.14062500f,0.68750000f,0.78125000f,0.56250000f,0.40625000f,0.32812500f,-0.51562500f,0.40625000f,0.12500000f,0.54687500f,0.42187500f,-0.82812500f,0.68750000f,0.07812500f,-0.73437500f,0.87500000f,0.68750000f,-0.96875000f,0.40625000f,0.95312500f,0.62500000f,0.20312500f,0.73437500f,0.79687500f,0.32812500f,-0.85937500f,0.10937500f,-0.95312500f,-0.73437500f,0.51562500f,0.46875000f,0.51562500f,-0.95312500f,0.34375000f,-0.46875000f,-0.40625000f,0.15625000f,-0.93750000f,0.42187500f,0.59375000f,0.12500000f,0.57812500f,-0.06250000f,0.62500000f,-0.43750000f,0.79687500f,-0.81250000f,-0.40625000f,-0.71875000f,-0.56250000f,-0.70312500f,-0.15625000f,-0.85937500f,0.93750000f,0.53125000f,-0.21875000f,-0.07812500f,-0.75000000f,0.43750000f,-0.96875000f,0.14062500f,-0.64062500f,-0.15625000f,-0.34375000f,-0.29687500f,0.40625000f,-0.03125000f,0.03125000f,-0.50000000f,0.75000000f,-0.48437500f,0.14062500f,0.45312500f,-0.40625000f,0.39062500f,0.65625000f,-0.23437500f,-0.98437500f,0.12500000f,0.62500000f,0.29687500f,-0.50000000f,0.10937500f,-0.75000000f,0.75000000f,-0.26562500f,-0.20312500f,-0.42187500f,0.07812500f,0.67187500f,0.37500000f,-0.14062500f,0.04687500f,0.54687500f,0.09375000f,-0.68750000f,0.60937500f,0.60937500f,-0.60937500f,0.67187500f,-0.31250000f,0.37500000f,0.93750000f,-0.32812500f,-0.51562500f,-0.96875000f,0.96875000f,1.00000000f,0.10937500f,0.95312500f,-0.42187500f,0.65625000f,0.25000000f,-0.18750000f,-0.42187500f,0.64062500f,-0.10937500f,-0.45312500f,-0.96875000f,0.32812500f,0.00000000f,0.35937500f,0.48437500f,-0.20312500f,-0.40625000f,0.12500000f,-0.06250000f,0.62500000f,0.45312500f,0.06250000f,-0.29687500f,0.50000000f,-0.06250000f,-0.39062500f,-0.40625000f,-1.00000000f,0.67187500f,0.45312500f,-0.68750000f,0.26562500f,0.48437500f,0.18750000f,-0.96875000f,0.67187500f,-0.98437500f,0.98437500f,0.17187500f,0.76562500f,-0.26562500f,-0.60937500f,0.40625000f,0.48437500f,0.46875000f,0.48437500f,0.68750000f,0.89062500f,0.39062500f,0.18750000f,0.06250000f,-0.95312500f,0.46875000f,0.23437500f,-0.73437500f,-0.98437500f,0.06250000f,-0.68750000f,-0.20312500f,0.65625000f,0.96875000f,0.25000000f,0.42187500f,-0.01562500f,0.43750000f,0.89062500f,0.00000000f,0.87500000f,0.57812500f,0.42187500f,0.56250000f,-0.20312500f,0.42187500f,0.76562500f,-0.67187500f,0.89062500f,-0.12500000f,-0.04687500f,0.40625000f,-0.70312500f,0.26562500f,-0.09375000f,0.87500000f,-1.00000000f,-0.78125000f,0.48437500f,-0.84375000f,-0.79687500f,0.90625000f,-0.89062500f,-0.46875000f,0.07812500f,0.23437500f,-0.18750000f,-0.51562500f,-0.39062500f,0.29687500f,0.35937500f,0.82812500f,-0.37500000f,0.40625000f,-0.60937500f,0.06250000f,-0.67187500f,0.68750000f,0.12500000f,-0.56250000f,0.50000000f,-0.43750000f,0.10937500f,0.42187500f,-0.84375000f,0.56250000f,-0.28125000f,-0.50000000f,0.50000000f,-0.96875000f,0.98437500f,-0.07812500f,0.62500000f,0.17187500f,0.71875000f,-0.26562500f,-0.07812500f,-0.42187500f,0.87500000f,-0.56250000f,-0.67187500f,0.78125000f,-0.78125000f,0.82812500f,0.14062500f,-0.92187500f,0.01562500f,0.95312500f,-0.54687500f,-0.46875000f,-0.17187500f,0.85937500f,0.00000000f,0.18750000f,-0.48437500f,0.98437500f,-0.51562500f,-0.68750000f,0.81250000f,-0.82812500f,-0.12500000f,0.04687500f,-0.45312500f,-0.48437500f,-0.32812500f,-0.56250000f,-0.20312500f,0.67187500f,-0.17187500f,-0.51562500f,-0.48437500f,0.07812500f,-0.56250000f,-0.67187500f,0.18750000f,1.00000000f,-0.21875000f,-0.12500000f,-0.07812500f,0.51562500f,-0.10937500f,-0.18750000f,-0.82812500f,0.70312500f,1.00000000f,0.25000000f,-0.39062500f,-0.20312500f,0.21875000f,0.39062500f,-0.40625000f,-0.73437500f,0.46875000f,-0.95312500f,-0.31250000f,-0.64062500f,-0.48437500f,0.23437500f,-0.23437500f,-0.21875000f,0.90625000f,-0.87500000f,-0.06250000f,0.79687500f,0.35937500f,0.67187500f,0.12500000f,-0.71875000f,0.75000000f,-0.78125000f,0.37500000f,0.73437500f,-0.79687500f,0.84375000f,-0.79687500f,0.29687500f,-0.42187500f,0.60937500f,0.23437500f,0.67187500f,0.01562500f,-0.68750000f,-0.09375000f,-0.96875000f,0.01562500f,-0.60937500f,0.35937500f,-0.46875000f,-0.34375000f,0.95312500f,-1.00000000f,0.54687500f,0.84375000f,-0.50000000f,-0.57812500f,-0.15625000f,0.53125000f,-0.40625000f,-0.31250000f,0.26562500f,-0.26562500f,-0.85937500f,-0.06250000f,-0.93750000f,-0.96875000f,0.31250000f,-0.59375000f,0.87500000f,0.98437500f,0.82812500f,-0.23437500f,-0.10937500f,0.45312500f,0.73437500f,-0.90625000f,0.64062500f,-0.81250000f,0.79687500f,-0.79687500f,0.71875000f,-0.78125000f,-0.76562500f,0.48437500f,0.18750000f,0.09375000f,-0.06250000f,-0.65625000f,-0.67187500f,0.21875000f,-1.00000000f,-0.89062500f,0.01562500f,-0.75000000f,-0.18750000f,0.57812500f,-0.45312500f,0.17187500f,0.81250000f,0.65625000f,-0.26562500f,-0.90625000f,-0.78125000f,0.82812500f,-0.78125000f,0.07812500f,0.39062500f,0.75000000f,-0.76562500f,0.71875000f,-0.98437500f,-0.51562500f,0.78125000f,-0.46875000f,0.90625000f,-0.57812500f,0.09375000f,-0.81250000f,-0.10937500f,-0.96875000f,-0.68750000f,-0.87500000f,-0.15625000f,-0.17187500f,-0.35937500f,-0.23437500f,-0.98437500f,1.00000000f,0.96875000f,-0.50000000f,0.95312500f,-0.14062500f,-0.93750000f,0.73437500f,-0.59375000f,-0.45312500f,0.18750000f,-0.93750000f,-0.64062500f,-0.89062500f,-0.23437500f,0.76562500f,-0.54687500f,-0.42187500f,0.78125000f,-0.60937500f,0.65625000f,-0.51562500f,-0.95312500f,0.46875000f,0.14062500f,-0.31250000f,-0.96875000f,-0.92187500f,-0.65625000f,0.10937500f,-0.84375000f,-0.70312500f,0.76562500f,0.18750000f,0.84375000f,-1.00000000f,0.90625000f,0.15625000f,-0.93750000f,-0.98437500f,0.59375000f,0.56250000f,-0.93750000f,-0.62500000f,0.07812500f,0.48437500f,-0.56250000f,-0.34375000f,-0.84375000f,-0.56250000f,-0.42187500f,0.75000000f,-0.54687500f,-0.18750000f,0.92187500f,-0.85937500f,0.45312500f,0.78125000f,-0.92187500f,-0.89062500f,-0.95312500f,-0.35937500f,-0.35937500f,0.84375000f,0.60937500f,-0.64062500f,-0.56250000f,0.15625000f,0.54687500f,0.00000000f,0.90625000f,0.43750000f,0.92187500f,0.81250000f,-0.79687500f,0.79687500f,0.60937500f,-0.76562500f,0.53125000f,0.67187500f,0.93750000f,-0.46875000f,0.00000000f,0.57812500f,-0.32812500f,-0.82812500f,0.42187500f,-0.21875000f,-0.09375000f,0.92187500f,-0.98437500f,-0.95312500f,0.06250000f,0.59375000f,0.89062500f,0.32812500f,0.59375000f,0.45312500f,-0.57812500f,-0.09375000f,0.43750000f,-0.32812500f,0.37500000f,-0.06250000f,0.87500000f,0.68750000f,0.59375000f,0.79687500f,0.85937500f,0.35937500f,0.68750000f,0.89062500f,0.57812500f,-0.12500000f,0.20312500f,0.48437500f,-0.84375000f,-0.95312500f,0.68750000f,0.65625000f,-0.87500000f,0.82812500f,0.23437500f,0.15625000f,0.32812500f,0.64062500f,-0.26562500f,-0.39062500f,0.45312500f,-0.85937500f,-0.70312500f,-0.31250000f,-0.64062500f,0.34375000f,0.23437500f,-0.71875000f,0.51562500f,0.37500000f,-0.39062500f,0.04687500f,0.25000000f,0.98437500f,-0.56250000f,0.67187500f,0.04687500f,-0.76562500f,-0.45312500f,0.15625000f,0.75000000f,-0.23437500f,-0.98437500f,0.54687500f,-0.79687500f,-0.64062500f,-0.50000000f,-0.84375000f,0.78125000f,-0.31250000f,0.79687500f,0.31250000f,0.34375000f,0.64062500f,0.59375000f,0.07812500f,0.68750000f,0.06250000f,-0.09375000f,0.01562500f,-0.35937500f,-0.37500000f,-0.46875000f,0.18750000f,0.53125000f,-0.35937500f,-0.98437500f,0.51562500f,-0.28125000f,0.95312500f,0.28125000f,0.46875000f,0.00000000f,-0.34375000f,-0.64062500f,0.18750000f,0.48437500f,-0.32812500f,-0.23437500f,-0.31250000f,-0.28125000f,-0.70312500f,0.25000000f,0.56250000f,-0.17187500f,-0.06250000f,0.39062500f,-0.84375000f,-0.85937500f,0.57812500f,-0.31250000f,0.48437500f,1.00000000f,0.57812500f,-1.00000000f,0.60937500f,0.84375000f,-0.62500000f,0.64062500f,0.07812500f,-0.98437500f,-0.12500000f,-0.85937500f,-0.53125000f,-0.62500000f,-0.79687500f,0.60937500f,0.31250000f,0.25000000f,0.20312500f,0.26562500f,-0.89062500f,0.15625000f,0.68750000f,0.68750000f,0.42187500f,-0.79687500f,0.34375000f,0.67187500f,-0.42187500f,0.84375000f,-0.42187500f,0.70312500f,0.10937500f,0.92187500f,0.29687500f,0.87500000f,-0.79687500f,0.29687500f,-0.09375000f,-0.14062500f,-0.35937500f,0.92187500f,0.03125000f,-0.12500000f,0.92187500f,-0.92187500f,-0.14062500f,-0.15625000f,0.87500000f,-0.71875000f,-0.42187500f,-0.17187500f,-0.87500000f,0.50000000f,0.15625000f,0.42187500f,0.03125000f,0.54687500f,-0.90625000f,0.06250000f,0.12500000f,-0.75000000f,0.06250000f,0.39062500f,-0.81250000f,0.03125000f,-0.50000000f,-0.21875000f,0.64062500f,0.67187500f,-0.67187500f,-0.62500000f,-0.40625000f,-0.04687500f,-0.76562500f,0.81250000f,0.53125000f,-0.43750000f,-0.37500000f,-0.59375000f,-0.57812500f,-0.50000000f,0.15625000f,0.92187500f,-0.23437500f,0.25000000f,-0.53125000f,-0.84375000f,-0.35937500f,-1.00000000f,0.75000000f,0.14062500f,0.34375000f,0.39062500f,0.67187500f,-0.42187500f,-0.82812500f,-0.45312500f,0.98437500f,-0.35937500f,0.81250000f,-0.56250000f,0.76562500f,0.67187500f,-0.81250000f,0.20312500f,-0.67187500f,-0.10937500f,-0.57812500f,-0.95312500f,-0.54687500f,0.23437500f,-0.20312500f,-0.20312500f,-0.04687500f,-0.93750000f,-0.75000000f,-0.32812500f,0.62500000f,0.15625000f,0.51562500f,-0.98437500f,0.32812500f,0.18750000f,0.03125000f,-0.23437500f,0.67187500f,-0.39062500f,-0.60937500f,-0.48437500f,0.92187500f,0.90625000f,0.00000000f,-0.64062500f,0.03125000f,-0.84375000f,0.12500000f,0.57812500f,0.04687500f,-1.00000000f,-0.43750000f,0.03125000f,0.06250000f,0.45312500f,0.67187500f,0.06250000f,-0.43750000f,-0.25000000f,-0.48437500f,0.01562500f,0.31250000f,0.75000000f,0.46875000f,0.37500000f,-0.40625000f,0.57812500f,0.98437500f,-0.65625000f,-0.17187500f,-0.84375000f,-0.23437500f,0.20312500f,0.81250000f,-0.37500000f,0.48437500f,-0.87500000f,-0.54687500f,0.34375000f,-1.00000000f,-0.06250000f,0.31250000f,0.57812500f,0.35937500f,0.37500000f,-0.20312500f,-0.18750000f,-0.85937500f,0.53125000f,0.48437500f,0.29687500f,-0.73437500f,-0.14062500f,0.28125000f,0.20312500f,0.98437500f,0.12500000f,-0.64062500f,0.18750000f,-0.15625000f,0.31250000f,0.03125000f,0.03125000f,-0.76562500f,-0.81250000f,0.15625000f,0.20312500f,0.95312500f,-0.31250000f,0.20312500f,-0.62500000f,-0.73437500f,-0.92187500f,0.93750000f,-0.79687500f,0.14062500f,0.64062500f,-0.32812500f,0.29687500f,0.20312500f,0.71875000f,0.12500000f,-0.90625000f,0.39062500f,0.25000000f,0.95312500f,-0.51562500f,0.73437500f,0.04687500f,-0.78125000f,-0.34375000f,0.09375000f,-0.28125000f,-0.07812500f,-0.50000000f,0.87500000f,0.93750000f,-0.12500000f,0.53125000f,0.70312500f,0.37500000f,0.10937500f,-0.12500000f,0.12500000f,-0.01562500f,-0.01562500f,0.54687500f,-0.26562500f,0.20312500f,0.40625000f,0.70312500f,-0.53125000f,-0.40625000f,0.64062500f,0.21875000f,-0.04687500f,-0.39062500f,0.25000000f,0.37500000f,0.76562500f,-0.46875000f,-0.26562500f,-0.82812500f,-0.31250000f,-0.23437500f,-0.95312500f,-0.84375000f,-0.15625000f,-0.09375000f,-0.98437500f,0.46875000f,-0.62500000f,0.84375000f,0.92187500f,0.01562500f,-0.17187500f,0.64062500f,-0.68750000f,-0.25000000f,0.90625000f,0.79687500f,-0.68750000f,-0.42187500f,0.65625000f,0.98437500f,0.31250000f,-0.43750000f,-0.14062500f,0.26562500f,0.90625000f,0.31250000f,0.40625000f,0.95312500f,-0.43750000f,0.70312500f,-0.81250000f,0.75000000f,0.34375000f,-0.59375000f,-0.15625000f,0.04687500f,0.89062500f,0.57812500f,-0.35937500f,-0.68750000f,0.82812500f,-0.87500000f,0.21875000f,-0.53125000f,0.54687500f,-0.28125000f,-0.45312500f,0.96875000f,0.93750000f,0.15625000f,-0.32812500f,-0.10937500f,-0.09375000f,-0.68750000f,0.21875000f,-0.87500000f,-0.82812500f,0.01562500f,-0.89062500f,0.32812500f,0.35937500f,0.21875000f,0.82812500f,-0.21875000f,0.42187500f,-0.21875000f,0.93750000f,0.51562500f,-0.65625000f,-0.89062500f,-0.75000000f,-0.64062500f,-0.81250000f,0.92187500f,-0.56250000f,0.43750000f,0.84375000f,0.76562500f,0.37500000f,0.60937500f,0.23437500f,-0.60937500f,-0.98437500f,0.21875000f,0.15625000f,0.23437500f,-0.82812500f,0.92187500f,-0.85937500f,0.76562500f,-0.28125000f,0.48437500f,0.18750000f,-0.54687500f,0.68750000f,0.09375000f,0.20312500f,-0.76562500f,-0.78125000f,1.00000000f,0.48437500f,0.50000000f,-0.67187500f,-0.42187500f,0.75000000f,0.20312500f,0.76562500f,0.31250000f,0.06250000f,-0.07812500f,-0.71875000f,0.96875000f,0.45312500f,0.00000000f,0.01562500f,0.48437500f,0.57812500f,-0.32812500f,-0.93750000f,0.48437500f,0.20312500f,-0.87500000f,-0.73437500f,-0.62500000f,-0.82812500f,-0.84375000f,-0.46875000f,0.42187500f,0.23437500f,-0.35937500f,0.09375000f,0.60937500f,-0.96875000f,-0.12500000f,-0.46875000f,-0.31250000f,0.07812500f,-0.46875000f,0.93750000f,-0.20312500f,0.75000000f,-0.81250000f,0.76562500f,0.70312500f,0.53125000f,-0.04687500f,0.00000000f,-0.76562500f,0.85937500f,-0.06250000f,0.84375000f,-0.67187500f,-0.59375000f,-0.90625000f,0.00000000f,-0.29687500f,0.81250000f,0.79687500f,-0.76562500f,-0.87500000f,0.34375000f,-0.76562500f,-0.14062500f,-0.87500000f,0.78125000f,-0.51562500f,0.96875000f,0.18750000f,0.32812500f,-1.00000000f,0.92187500f,-0.32812500f,-0.18750000f,-0.35937500f,-0.03125000f,-0.23437500f,0.39062500f,-0.23437500f,-0.89062500f,-0.79687500f,-0.89062500f,-1.00000000f,-0.12500000f,0.18750000f,0.90625000f,0.56250000f,-0.98437500f,-0.65625000f,0.65625000f,0.28125000f,0.32812500f,0.76562500f,0.96875000f,-0.31250000f,0.12500000f,0.90625000f,0.34375000f,0.42187500f,-0.39062500f,0.53125000f,0.70312500f,0.07812500f,0.46875000f,-0.42187500f,0.50000000f,0.28125000f,0.23437500f,0.70312500f,0.10937500f,-0.45312500f,0.31250000f,0.15625000f,-0.71875000f,-0.76562500f,-0.57812500f,0.75000000f,0.92187500f,0.14062500f,0.46875000f,0.06250000f,0.25000000f,-0.31250000f,-0.59375000f,0.03125000f,0.37500000f,-0.35937500f,0.90625000f,0.23437500f,-0.96875000f,-0.87500000f,0.70312500f,0.95312500f,-0.29687500f,-0.09375000f,-0.39062500f,-0.31250000f,-0.50000000f,-0.53125000f,-0.95312500f,-0.23437500f,-0.01562500f,-0.53125000f,-0.71875000f,-0.56250000f,-0.54687500f,-0.98437500f,-0.21875000f,-0.46875000f,0.98437500f,0.46875000f,0.20312500f,-0.45312500f,-0.32812500f,0.64062500f,-0.76562500f,-0.43750000f,0.56250000f,0.35937500f,-0.76562500f,0.60937500f,0.68750000f,0.96875000f,-0.50000000f,0.48437500f,-0.87500000f,-0.29687500f,-0.01562500f,0.93750000f,0.81250000f,-0.32812500f,0.93750000f,0.79687500f,-0.45312500f,0.64062500f,0.48437500f,-0.87500000f,-0.67187500f,0.78125000f,0.43750000f,-0.15625000f,-0.85937500f,0.42187500f,-0.42187500f,-0.31250000f,0.60937500f,0.12500000f,-0.85937500f,0.34375000f,0.25000000f,-0.85937500f,-0.45312500f,-0.56250000f,-0.84375000f,-0.28125000f,0.87500000f,-0.14062500f,0.95312500f,-0.59375000f,0.43750000f,0.90625000f,-1.00000000f,0.04687500f,-0.60937500f,-0.54687500f,-0.15625000f,0.51562500f,-0.29687500f,-0.40625000f,0.81250000f,-0.67187500f,-0.51562500f,0.15625000f,-0.79687500f,0.04687500f,0.71875000f,-0.79687500f,-0.70312500f,-0.89062500f,0.18750000f,-1.00000000f,-0.98437500f,-0.04687500f,-0.46875000f,-0.09375000f,-0.62500000f,-0.48437500f,-0.29687500f,0.96875000f,0.71875000f,-0.46875000f,0.45312500f,-0.79687500f,0.23437500f,-0.23437500f,0.25000000f,0.20312500f,0.71875000f,-0.20312500f,-0.43750000f,0.48437500f,0.31250000f,-0.89062500f,-0.15625000f,0.98437500f,-0.15625000f,0.56250000f,-0.06250000f,0.85937500f,0.82812500f,-0.32812500f,0.40625000f,0.73437500f,-0.53125000f,-0.82812500f,-0.37500000f,0.70312500f,0.31250000f,-0.56250000f,0.28125000f,-0.20312500f,-0.09375000f,0.98437500f,0.70312500f,0.01562500f,0.25000000f,0.10937500f,0.34375000f,0.14062500f,-0.98437500f,0.79687500f,-0.54687500f,-0.12500000f,0.48437500f,-0.95312500f,-0.21875000f,0.25000000f,0.03125000f,-0.28125000f,-0.17187500f,0.20312500f,0.68750000f,0.48437500f,0.00000000f,0.35937500f,-0.73437500f,0.14062500f,-0.40625000f,-0.96875000f,-0.12500000f,0.12500000f,0.23437500f,0.95312500f,0.39062500f,0.25000000f,-0.96875000f,0.73437500f,-0.96875000f,0.18750000f,0.81250000f,0.90625000f,-0.70312500f,0.84375000f,-0.59375000f,0.32812500f,1.00000000f,0.89062500f,-0.57812500f,-0.43750000f,0.37500000f,0.23437500f,-0.57812500f,-0.34375000f,-0.37500000f,0.85937500f,-0.04687500f,0.29687500f,-0.40625000f,-0.65625000f,-0.85937500f,0.07812500f,-0.75000000f,-0.35937500f,-0.34375000f,0.85937500f,0.18750000f,0.78125000f,-0.25000000f,0.37500000f,0.65625000f,0.03125000f,0.64062500f,0.70312500f,0.37500000f,0.14062500f,0.57812500f,0.84375000f,0.89062500f,0.93750000f,0.51562500f,-0.67187500f,0.32812500f,0.12500000f,0.31250000f,0.70312500f,0.81250000f,-0.96875000f,0.07812500f,0.60937500f,-0.32812500f,-0.71875000f,0.14062500f,0.75000000f,-0.35937500f,-0.90625000f,-0.71875000f,-0.23437500f,-0.75000000f,-0.56250000f,-0.95312500f,0.28125000f,-0.62500000f,0.96875000f,0.65625000f,-0.21875000f,0.67187500f,-0.01562500f,0.85937500f,-0.76562500f,0.75000000f,-0.39062500f,0.76562500f,0.03125000f,0.92187500f,-0.50000000f,0.95312500f,-0.87500000f,-0.01562500f,0.06250000f,-0.03125000f,0.35937500f,-0.81250000f,-0.76562500f,0.87500000f,0.07812500f,0.79687500f,0.85937500f,0.14062500f,0.93750000f,-0.29687500f,-0.98437500f,0.84375000f,-0.06250000f,-0.71875000f,0.03125000f,-0.10937500f,0.42187500f,-0.85937500f,-0.40625000f,-0.96875000f,0.28125000f,0.31250000f,0.98437500f,0.29687500f,-0.46875000f,0.57812500f,-0.54687500f,0.78125000f,0.64062500f,-0.18750000f,0.14062500f,-0.81250000f,-0.75000000f,0.00000000f,-0.56250000f,0.98437500f,0.57812500f,-0.34375000f,0.84375000f,-0.32812500f,-0.57812500f,0.57812500f,0.57812500f,-0.15625000f,-0.15625000f,-0.65625000f,0.73437500f,0.71875000f,-0.04687500f,0.64062500f,-0.71875000f,-0.95312500f,-0.53125000f,-0.64062500f,-0.78125000f,-0.53125000f,-0.34375000f,0.21875000f,0.15625000f,0.21875000f,-0.35937500f,0.71875000f,0.70312500f,-0.07812500f,0.15625000f,0.45312500f,-0.70312500f,0.40625000f,-0.60937500f,-0.95312500f,0.71875000f,-0.60937500f,-0.90625000f,-0.14062500f,0.15625000f,0.75000000f,0.67187500f,-0.67187500f,0.89062500f,-0.82812500f,0.01562500f,-0.54687500f,0.48437500f,0.64062500f,-0.92187500f,0.35937500f,0.62500000f,0.35937500f,0.75000000f,0.29687500f,0.04687500f,-0.64062500f,-0.96875000f,0.29687500f,-0.42187500f,0.90625000f,-0.42187500f,-0.70312500f,0.07812500f,0.73437500f,0.89062500f,-0.70312500f,0.00000000f,-0.70312500f,0.64062500f,0.67187500f,0.43750000f,-0.90625000f,-0.46875000f,0.84375000f,0.01562500f,0.85937500f,-0.23437500f,0.75000000f,-0.23437500f,0.87500000f,-0.39062500f,0.12500000f,0.06250000f,-0.12500000f,-0.71875000f,0.71875000f,-0.48437500f,0.67187500f,0.79687500f,0.01562500f,-0.50000000f,-0.81250000f,0.12500000f,0.15625000f,0.82812500f,0.15625000f,-1.00000000f,0.07812500f,-0.46875000f,0.07812500f,0.85937500f,-0.17187500f,0.50000000f,0.23437500f,-0.26562500f,0.53125000f,-0.40625000f,0.65625000f,0.45312500f,1.00000000f,0.31250000f,-0.51562500f,0.43750000f,0.90625000f,-0.23437500f,0.96875000f,0.85937500f,-0.73437500f,-0.03125000f,0.92187500f,0.54687500f,0.15625000f,-0.57812500f,-0.51562500f,-0.18750000f,-0.92187500f,0.06250000f,0.20312500f,-0.98437500f,0.79687500f,0.82812500f,0.09375000f,0.76562500f,-0.85937500f,0.10937500f,0.10937500f,-0.92187500f,0.45312500f,-0.39062500f,0.01562500f,-0.60937500f,0.79687500f,0.21875000f,-0.50000000f,0.39062500f,-0.35937500f,0.03125000f,0.43750000f,0.14062500f,0.70312500f,0.81250000f,-0.64062500f,-0.25000000f,0.59375000f,0.96875000f,-0.45312500f,-0.89062500f,0.51562500f,0.46875000f,-0.18750000f,0.59375000f,0.75000000f,0.26562500f,0.54687500f,-0.56250000f,-0.23437500f,-0.73437500f,-0.37500000f,0.67187500f,-0.03125000f,-0.29687500f,-0.26562500f,-0.79687500f,0.51562500f,-0.23437500f,-0.53125000f,0.90625000f,-0.59375000f,-0.10937500f,0.78125000f,0.40625000f,-0.85937500f,0.23437500f,0.62500000f,0.71875000f,-0.75000000f,-0.59375000f,0.62500000f,-1.00000000f,0.90625000f,-0.65625000f,-0.71875000f,-0.95312500f,0.25000000f,-0.23437500f,0.23437500f,-0.92187500f,0.07812500f,-0.10937500f,0.43750000f,0.35937500f,-0.10937500f,0.89062500f,-0.09375000f,0.03125000f,-0.92187500f,0.45312500f,0.34375000f,-0.23437500f,0.56250000f,0.28125000f,0.23437500f,-0.32812500f,-0.82812500f,-0.42187500f,-0.53125000f,-0.95312500f,-0.32812500f,0.53125000f,0.29687500f,0.18750000f,-0.14062500f,-0.93750000f,-0.07812500f,-0.06250000f,-0.17187500f,0.42187500f,0.32812500f,-0.39062500f,0.46875000f,0.35937500f,0.67187500f,0.23437500f,0.76562500f,-0.07812500f,-0.25000000f,0.78125000f,-0.64062500f,-0.43750000f,-0.03125000f,-0.48437500f,-0.81250000f,0.18750000f,0.37500000f,0.35937500f,-0.89062500f,1.00000000f,-0.75000000f,-0.93750000f,-0.76562500f,-0.31250000f,-0.93750000f,-0.14062500f,-0.81250000f,-0.95312500f,0.98437500f,0.06250000f,0.76562500f,0.35937500f,0.59375000f,-0.79687500f,-0.07812500f,0.59375000f,0.64062500f,-0.90625000f,0.90625000f,-0.29687500f,-0.37500000f,0.96875000f,-0.39062500f,-0.51562500f,-0.10937500f,0.20312500f,-0.70312500f,-0.85937500f,0.79687500f,-0.20312500f,-0.84375000f,0.84375000f,-0.78125000f,-0.10937500f,0.20312500f,0.78125000f,0.78125000f,0.12500000f,0.14062500f,0.50000000f,0.90625000f,-0.34375000f,-0.43750000f,0.90625000f,0.28125000f,-0.73437500f,0.90625000f,-0.79687500f,-0.71875000f,-0.26562500f,0.40625000f,-0.50000000f,-0.04687500f,0.29687500f,-0.71875000f,-0.60937500f,0.34375000f,-0.93750000f,0.79687500f,0.48437500f,-0.65625000f,0.87500000f,-0.89062500f,-0.82812500f,-0.53125000f,0.60937500f,0.48437500f,-0.67187500f,-0.67187500f,-0.79687500f,-0.06250000f,0.98437500f,0.18750000f,0.56250000f,-0.60937500f,0.87500000f,0.93750000f,-0.17187500f,-0.31250000f,0.92187500f,-0.40625000f,0.48437500f,-0.73437500f,-0.32812500f,-0.31250000f,0.64062500f,-0.23437500f,-0.84375000f,-0.29687500f,0.62500000f,0.90625000f,0.15625000f,-0.65625000f,0.71875000f,0.57812500f,0.20312500f,0.43750000f,0.42187500f,-0.04687500f,0.39062500f,-0.51562500f,-0.79687500f,0.07812500f,-0.10937500f,0.92187500f,-0.32812500f,0.15625000f,-0.59375000f,0.03125000f,0.34375000f,0.95312500f,0.31250000f,-0.56250000f,-0.50000000f,0.28125000f,-0.89062500f,0.06250000f,0.56250000f,-0.15625000f,0.32812500f,-0.37500000f,-0.46875000f,-0.31250000f,-0.95312500f,0.15625000f,0.64062500f,0.59375000f,-0.98437500f,-0.51562500f,-0.12500000f,-0.57812500f,0.37500000f,-0.37500000f,-0.56250000f,-0.32812500f,0.93750000f,-0.03125000f,-0.45312500f,0.48437500f,-0.96875000f,0.53125000f,-0.67187500f,1.00000000f,0.14062500f,-0.62500000f,0.54687500f,0.53125000f,-0.18750000f,0.59375000f,-0.67187500f,-0.23437500f,0.03125000f,0.95312500f,0.17187500f,0.64062500f,0.31250000f,0.98437500f,-0.17187500f,-0.82812500f,-0.60937500f,-0.45312500f,0.67187500f,0.54687500f,-0.06250000f,0.71875000f,-0.92187500f,-0.79687500f,-0.68750000f,0.31250000f,0.29687500f,0.07812500f,-0.26562500f,-0.21875000f,-0.14062500f,0.40625000f,-0.10937500f,0.79687500f,-0.28125000f,0.93750000f,0.26562500f,-0.75000000f,-0.32812500f,-0.35937500f,-0.70312500f,0.84375000f,-0.37500000f,-0.07812500f,0.39062500f,-0.84375000f,0.60937500f,0.40625000f,0.50000000f,0.81250000f,0.12500000f,0.82812500f,0.89062500f,0.84375000f,-0.64062500f,0.81250000f,-0.18750000f,0.85937500f,-0.14062500f,0.35937500f,-0.09375000f,-0.60937500f,0.40625000f,-0.14062500f,0.37500000f,0.37500000f,0.84375000f,0.03125000f,0.54687500f,0.60937500f,0.32812500f,-0.53125000f,-0.04687500f,-0.75000000f,0.37500000f,0.59375000f,-0.42187500f,-0.26562500f,-0.25000000f,0.78125000f,0.29687500f,0.04687500f,0.20312500f,0.26562500f,0.35937500f,-0.76562500f,0.81250000f,-0.01562500f,-1.00000000f,0.90625000f,-0.73437500f,-0.29687500f,0.21875000f,0.01562500f,0.00000000f,-0.28125000f,0.85937500f,0.23437500f,0.54687500f,-0.90625000f,0.90625000f,-0.92187500f,-0.85937500f,0.73437500f,-0.34375000f,-0.04687500f,-0.53125000f,0.42187500f,-0.95312500f,0.23437500f,0.12500000f,0.92187500f,0.32812500f,-0.62500000f,-0.45312500f,-0.57812500f,-0.35937500f,0.35937500f,0.84375000f,-0.54687500f,-0.23437500f,-0.84375000f,-0.34375000f,0.20312500f,-0.39062500f,-0.46875000f,-0.43750000f,0.10937500f,-0.95312500f,0.64062500f,-0.32812500f,0.09375000f,0.00000000f,-0.65625000f,0.42187500f,-0.07812500f,-0.54687500f,0.17187500f,0.35937500f,0.28125000f,-0.46875000f,0.45312500f,-0.23437500f,0.12500000f,-0.96875000f,0.84375000f,-0.37500000f,0.31250000f,0.68750000f,-0.01562500f,-0.79687500f,0.85937500f,0.06250000f,-0.06250000f,-0.85937500f,0.54687500f,-0.03125000f,0.37500000f,-0.06250000f,0.40625000f,0.20312500f,-0.59375000f,0.07812500f,-0.87500000f,0.07812500f,0.65625000f,0.17187500f,0.70312500f,-0.03125000f,-0.79687500f,0.01562500f,-0.60937500f,0.35937500f,0.04687500f,0.37500000f,-0.45312500f,-0.82812500f,0.18750000f,-0.37500000f,-0.53125000f,0.00000000f,-0.06250000f,-0.57812500f,0.00000000f,-0.10937500f,-0.45312500f,0.32812500f,0.93750000f,0.48437500f,0.00000000f,-0.96875000f,0.98437500f,0.95312500f,-0.29687500f,0.98437500f,-0.92187500f,0.39062500f,-0.26562500f,-0.73437500f,-0.85937500f,0.12500000f,0.20312500f,0.29687500f,-0.46875000f,0.03125000f,0.25000000f,-0.32812500f,0.68750000f,-0.37500000f,0.39062500f,-0.75000000f,-0.07812500f,-0.48437500f,-0.32812500f,-0.43750000f,-0.75000000f,0.04687500f,0.06250000f,0.07812500f,-0.65625000f,-0.67187500f,-0.85937500f,-0.23437500f,-0.78125000f,0.48437500f,-0.76562500f,0.76562500f,-0.85937500f,0.35937500f,0.42187500f,1.00000000f,0.20312500f,0.84375000f,0.82812500f,-0.15625000f,0.96875000f,0.12500000f,0.82812500f,-0.03125000f,0.10937500f,-0.68750000f,-0.04687500f,-0.59375000f,0.73437500f,0.78125000f,0.81250000f,0.06250000f,-0.20312500f,-0.50000000f,-0.43750000f,-0.04687500f,-0.81250000f,0.96875000f,-0.71875000f,0.95312500f,0.18750000f,-0.62500000f,0.43750000f,0.00000000f,-0.76562500f,0.64062500f,-0.12500000f,-0.73437500f,-0.28125000f,0.64062500f,-0.96875000f,-0.85937500f,0.65625000f,-0.10937500f,-0.54687500f,0.15625000f,-0.39062500f,-0.25000000f,-0.81250000f,0.73437500f,-0.50000000f,-0.32812500f,0.93750000f,0.35937500f,-0.25000000f,0.73437500f,0.34375000f,-0.46875000f,0.57812500f,-0.04687500f,-0.96875000f,-0.92187500f,0.03125000f,-0.68750000f,0.43750000f,0.12500000f,0.68750000f,-0.28125000f,-0.78125000f,-0.17187500f,0.40625000f,0.57812500f,-0.53125000f,0.06250000f,0.87500000f,-0.70312500f,-0.39062500f,0.60937500f,-0.42187500f,0.60937500f,-0.53125000f,0.98437500f,0.17187500f,-0.32812500f,0.93750000f,-0.14062500f,0.56250000f,-0.12500000f,-0.85937500f,-0.23437500f,-0.10937500f,0.06250000f,0.95312500f,-0.59375000f,-0.46875000f,0.92187500f,0.23437500f,0.10937500f,0.98437500f,0.01562500f,-0.32812500f,0.07812500f,0.03125000f,0.09375000f,0.56250000f,0.32812500f,-0.25000000f,-0.60937500f,-0.90625000f,0.14062500f,-0.45312500f,0.42187500f,-0.62500000f,0.12500000f,0.93750000f,0.92187500f,0.26562500f,0.04687500f,-0.26562500f,0.18750000f,0.81250000f,0.26562500f,0.51562500f,0.28125000f,-0.59375000f,0.20312500f,0.17187500f,0.95312500f,-0.71875000f,-0.23437500f,0.68750000f,0.62500000f,-0.51562500f,-0.12500000f,-0.76562500f,0.53125000f,0.37500000f,-0.46875000f,-0.40625000f,0.51562500f,-0.78125000f,-0.42187500f,0.10937500f,-0.87500000f,0.45312500f,0.06250000f,0.84375000f,-0.64062500f,0.17187500f,0.03125000f,0.43750000f,0.73437500f,0.15625000f,0.45312500f,0.39062500f,0.96875000f,0.82812500f,-0.68750000f,0.68750000f,-0.89062500f,-0.46875000f,0.48437500f,-0.21875000f,-0.92187500f,0.20312500f,0.84375000f,0.28125000f,0.56250000f,0.85937500f,0.43750000f,-0.51562500f,0.65625000f,0.65625000f,0.57812500f,0.03125000f,-0.35937500f,-0.35937500f,0.84375000f,0.48437500f,0.03125000f,0.15625000f,-0.32812500f,-0.32812500f,-0.96875000f,0.46875000f,-0.73437500f,-0.39062500f,0.67187500f,-0.90625000f,-0.15625000f,0.06250000f,-0.39062500f,0.12500000f,-0.84375000f,0.59375000f,0.95312500f,-0.75000000f,0.54687500f,-0.17187500f,-0.31250000f,-0.06250000f,0.68750000f,0.26562500f,-0.51562500f,-0.70312500f,-0.09375000f,0.26562500f,-0.56250000f,0.18750000f,0.64062500f,0.48437500f,0.20312500f,-0.65625000f,0.21875000f,1.00000000f,0.15625000f,-1.00000000f,0.07812500f,0.18750000f,0.29687500f,0.79687500f,-0.23437500f,0.03125000f,0.75000000f,0.62500000f,0.32812500f,0.84375000f,-0.59375000f,-0.25000000f,-0.68750000f,0.68750000f,-0.96875000f,0.84375000f,-0.82812500f,0.78125000f,0.34375000f,-0.76562500f,0.28125000f,-0.34375000f,0.29687500f,-0.06250000f,-0.81250000f,-0.45312500f,-0.54687500f,-0.87500000f,0.62500000f,0.28125000f,0.92187500f,-0.89062500f,0.09375000f,0.65625000f,0.73437500f,-0.29687500f,-0.76562500f,0.25000000f,-0.23437500f,0.14062500f,-0.03125000f,0.84375000f,-0.96875000f,-0.82812500f,0.79687500f,-0.26562500f,0.93750000f,-0.12500000f,0.03125000f,-0.32812500f,-1.00000000f,-0.85937500f,-0.45312500f,0.79687500f,0.46875000f,-0.82812500f,-0.84375000f,0.45312500f,0.82812500f,-0.46875000f,-0.09375000f,-0.62500000f,0.14062500f,0.45312500f,-0.89062500f,-0.56250000f,0.54687500f,0.06250000f,-0.53125000f,-0.98437500f,0.59375000f,-0.01562500f,0.78125000f,-0.04687500f,0.03125000f,-0.09375000f,-0.07812500f,0.03125000f,0.48437500f,-0.42187500f,-0.07812500f,0.09375000f,0.29687500f,-0.89062500f,-0.81250000f,0.76562500f,-0.01562500f,0.28125000f,-0.14062500f,-0.09375000f,0.56250000f,0.78125000f,0.96875000f,-0.78125000f,-0.48437500f,-0.65625000f,0.79687500f,-0.59375000f,-0.76562500f,0.07812500f,0.43750000f,-0.45312500f,-0.79687500f,0.09375000f,0.48437500f,-0.04687500f,-0.73437500f,-0.89062500f,0.14062500f,-0.90625000f,0.10937500f,-0.42187500f,-0.56250000f,-0.15625000f,-0.26562500f,-0.40625000f,-0.95312500f,-0.56250000f,0.85937500f,0.64062500f,0.32812500f,-0.68750000f,-0.46875000f,0.92187500f,-0.82812500f,0.59375000f,0.85937500f,-0.18750000f,-0.23437500f,-0.03125000f,-0.67187500f,0.48437500f,0.59375000f,0.95312500f,-0.18750000f,-0.87500000f,0.71875000f,0.35937500f,-0.65625000f,0.39062500f,0.10937500f,0.06250000f,0.56250000f,-0.23437500f,-0.46875000f,-0.20312500f,0.59375000f,0.39062500f,-0.96875000f,-0.26562500f,-0.93750000f,-0.06250000f,0.15625000f,-0.65625000f,0.03125000f,-0.01562500f,-0.51562500f,-0.68750000f,-0.01562500f,0.89062500f,-0.31250000f,0.79687500f,-0.31250000f,0.89062500f,0.31250000f,-0.12500000f,0.18750000f,-0.43750000f,0.62500000f,0.12500000f,-0.82812500f,-0.81250000f,-0.46875000f,-0.51562500f,0.40625000f,-0.07812500f,0.25000000f,-1.00000000f,0.43750000f,0.76562500f,0.60937500f,0.67187500f,0.40625000f,-0.42187500f,-0.73437500f,-0.56250000f,-0.12500000f,-0.50000000f,0.46875000f,0.06250000f,0.87500000f,-0.68750000f,0.65625000f,-0.35937500f,0.51562500f,0.03125000f,-0.54687500f,0.37500000f,-0.78125000f,0.43750000f,0.14062500f,0.15625000f,-0.07812500f,0.25000000f,0.68750000f,0.31250000f,0.37500000f,-0.78125000f,-0.73437500f,-0.68750000f,-0.40625000f,0.95312500f,-0.75000000f,-0.89062500f,-0.73437500f,0.48437500f,-0.17187500f,0.32812500f,0.71875000f,-0.62500000f,-0.25000000f,-0.04687500f,0.28125000f,-0.81250000f,-0.25000000f,0.03125000f,0.29687500f,-0.40625000f,0.64062500f,0.84375000f,-0.40625000f,0.92187500f,-0.35937500f,0.87500000f,0.25000000f,0.34375000f,-0.04687500f,0.85937500f,0.81250000f,0.84375000f,-0.70312500f,0.10937500f,-0.21875000f,-0.48437500f,0.50000000f,-0.29687500f,0.75000000f,-0.50000000f,0.23437500f,0.03125000f,0.37500000f,0.60937500f,0.34375000f,0.79687500f,-0.71875000f,-0.50000000f,0.84375000f,-0.29687500f,0.40625000f,-0.85937500f,-0.29687500f,0.98437500f,0.14062500f,0.48437500f,-0.75000000f,0.18750000f,-0.75000000f,-0.62500000f,-0.18750000f,-0.92187500f,0.81250000f,-0.64062500f,0.71875000f,-0.82812500f,-0.53125000f,-0.70312500f,0.15625000f,-0.53125000f,0.09375000f,-0.45312500f,0.79687500f,0.14062500f,0.96875000f,-0.28125000f,0.32812500f,0.92187500f,0.78125000f,-0.07812500f,0.79687500f,0.85937500f,0.06250000f,0.98437500f,-0.14062500f,-0.53125000f,-0.92187500f,0.01562500f,-0.20312500f,0.25000000f,-0.70312500f,-0.89062500f,0.84375000f,-0.64062500f,0.67187500f,0.75000000f,-0.35937500f,-0.59375000f,0.68750000f,0.71875000f,-0.45312500f,0.45312500f,0.31250000f,0.37500000f,0.53125000f,-0.68750000f,0.12500000f,0.73437500f,-0.67187500f,0.84375000f,0.90625000f,0.01562500f,-0.15625000f,-0.07812500f,-0.73437500f,-0.73437500f,0.54687500f,0.34375000f,-0.68750000f,0.56250000f,-1.00000000f,0.00000000f,0.32812500f,-0.95312500f,0.34375000f,0.43750000f,0.70312500f,-0.93750000f,-0.40625000f,0.00000000f,0.06250000f,0.26562500f,0.20312500f,0.09375000f,-0.15625000f,0.18750000f,-0.51562500f,0.84375000f,0.07812500f,-0.29687500f,-0.03125000f,0.84375000f,0.20312500f,-0.57812500f,0.45312500f,-0.35937500f,-0.54687500f,-0.37500000f,0.43750000f,0.34375000f,0.43750000f,-0.93750000f,-0.18750000f,-0.42187500f,-0.75000000f,-0.15625000f,-0.43750000f,-0.92187500f,-0.12500000f,-0.56250000f,-0.92187500f,0.54687500f,0.84375000f,0.39062500f,0.23437500f,-0.37500000f,0.67187500f,-0.65625000f,0.76562500f,0.92187500f,-0.18750000f,-0.90625000f,-0.34375000f,0.87500000f,-0.46875000f,0.20312500f,-0.67187500f,-0.15625000f,0.75000000f,-0.23437500f,0.40625000f,0.10937500f,0.37500000f,-0.93750000f,-0.75000000f,-0.07812500f,-0.76562500f,-0.95312500f,0.28125000f,-0.26562500f,-0.98437500f,0.04687500f,-0.76562500f,-0.39062500f,-0.03125000f,0.79687500f,0.87500000f,0.96875000f,-0.04687500f,-0.50000000f,0.31250000f,0.06250000f,-0.70312500f,-0.25000000f,-0.12500000f,-0.64062500f,-0.01562500f,0.40625000f,0.62500000f,0.78125000f,-0.10937500f,0.54687500f,0.67187500f,0.73437500f,0.71875000f,-0.76562500f,0.70312500f,0.26562500f,-0.09375000f,0.12500000f,0.26562500f,-0.12500000f,-0.54687500f,0.46875000f,0.25000000f,0.81250000f,0.10937500f,0.78125000f,-0.40625000f,-0.04687500f,0.18750000f,-0.10937500f,0.71875000f,0.03125000f,0.18750000f,0.90625000f,-0.93750000f,-0.87500000f,-0.60937500f,0.84375000f,0.68750000f,0.68750000f,-0.56250000f,0.87500000f,-0.09375000f,-0.23437500f,-0.92187500f,-0.89062500f,-0.59375000f,0.23437500f,0.23437500f,0.64062500f,-0.71875000f,0.65625000f,0.45312500f,-0.25000000f,0.60937500f,0.35937500f,-0.95312500f,1.00000000f,0.60937500f,0.62500000f,0.00000000f,0.85937500f,0.75000000f,0.60937500f,0.76562500f,-0.48437500f,0.73437500f,0.34375000f,-0.04687500f,-0.96875000f,0.81250000f,0.35937500f,0.73437500f,0.04687500f,0.54687500f,-0.14062500f,0.56250000f,-0.62500000f,0.35937500f,-0.06250000f,0.15625000f,0.14062500f,0.06250000f,0.60937500f,-0.17187500f,0.07812500f,0.50000000f,0.65625000f,-0.71875000f,0.53125000f,0.17187500f,-0.45312500f,0.90625000f,0.50000000f,-0.56250000f,0.37500000f,-0.20312500f,-0.78125000f,0.79687500f,0.82812500f,0.79687500f,-0.67187500f,-0.96875000f,0.43750000f,0.00000000f,0.95312500f,-0.96875000f,-0.23437500f,-0.21875000f,0.48437500f,0.87500000f,0.85937500f,-0.09375000f,0.84375000f,-0.48437500f,-0.96875000f,0.43750000f,0.28125000f,0.78125000f,-0.62500000f,-0.79687500f,-0.35937500f,-0.04687500f,-0.81250000f,-0.01562500f,0.07812500f,-0.17187500f,0.70312500f,0.01562500f,0.85937500f,-0.18750000f,0.17187500f,-0.98437500f,0.07812500f,-0.62500000f,0.34375000f,-0.32812500f,-0.42187500f,0.42187500f,0.17187500f,0.50000000f,0.07812500f,-0.18750000f,0.50000000f,-0.82812500f,0.17187500f,-0.67187500f,0.03125000f,-0.35937500f,0.12500000f,-0.71875000f,-0.25000000f,0.21875000f,0.50000000f,0.28125000f,0.57812500f,-0.54687500f,-0.15625000f,0.03125000f,0.15625000f,-0.45312500f,0.40625000f,-1.00000000f,-0.42187500f,-0.40625000f,0.65625000f,-0.62500000f,-0.95312500f,0.56250000f,0.42187500f,-0.15625000f,0.79687500f,1.00000000f,0.00000000f,-0.79687500f,0.84375000f,0.89062500f,-0.26562500f,0.03125000f,-0.54687500f,0.15625000f,-0.31250000f,-0.53125000f,0.51562500f,-0.09375000f,-0.40625000f,0.26562500f,-0.48437500f,-0.53125000f,0.06250000f,0.42187500f,-0.93750000f,-0.34375000f,-0.34375000f,0.23437500f,0.01562500f,-0.20312500f,-0.21875000f,-0.04687500f,0.85937500f,0.21875000f,-0.79687500f,-0.92187500f,-0.89062500f,0.21875000f,-0.59375000f,-0.71875000f,0.12500000f,0.20312500f,-0.48437500f,0.62500000f,0.90625000f,0.01562500f,-0.71875000f,-0.95312500f,-0.90625000f,0.01562500f,-0.31250000f,0.96875000f,-0.39062500f,0.07812500f,0.53125000f,0.96875000f,0.26562500f,0.20312500f,0.40625000f,-0.56250000f,-1.00000000f,0.37500000f,0.75000000f,0.09375000f,0.81250000f,0.90625000f,-0.57812500f,0.23437500f,0.92187500f,0.12500000f,-0.25000000f,-0.07812500f,-0.03125000f,-0.85937500f,-0.90625000f,-0.35937500f,0.89062500f,-0.70312500f,0.96875000f,-1.00000000f,0.84375000f,0.03125000f,-0.84375000f,0.89062500f,-0.92187500f,0.04687500f,0.20312500f,0.17187500f,0.51562500f,-0.34375000f,0.04687500f,0.89062500f,0.07812500f,0.26562500f,0.29687500f,0.65625000f,0.73437500f,-0.29687500f,0.96875000f,0.50000000f,-0.95312500f,0.92187500f,0.98437500f,0.73437500f,-0.59375000f,-0.76562500f,-0.50000000f,-0.65625000f,-0.37500000f,-0.89062500f,-0.29687500f,-0.15625000f,0.51562500f,-0.53125000f,-0.56250000f,-0.28125000f,-0.35937500f,-0.10937500f,-0.29687500f,-0.34375000f,-0.35937500f,-0.65625000f,-0.07812500f,0.89062500f,0.75000000f,-0.37500000f,0.15625000f,0.34375000f,-0.06250000f,0.01562500f,0.23437500f,0.56250000f,0.89062500f,0.65625000f,0.17187500f,0.87500000f,-0.39062500f,-0.17187500f,0.57812500f,0.56250000f,0.75000000f,0.32812500f,0.50000000f,-0.51562500f,-0.09375000f,0.00000000f,0.48437500f,0.67187500f,-0.46875000f,-0.65625000f,0.53125000f,0.12500000f,-0.31250000f,-0.40625000f,-0.84375000f,0.53125000f,-0.04687500f,0.43750000f,-0.73437500f,-0.03125000f,0.31250000f,0.81250000f,0.23437500f,0.23437500f,-0.03125000f,-0.46875000f,-0.23437500f,-0.15625000f,0.09375000f,-0.62500000f,0.65625000f,-0.42187500f,0.18750000f,-0.64062500f,-0.76562500f,0.98437500f,-0.35937500f,-0.28125000f,-0.70312500f,-0.73437500f,-0.85937500f,-0.57812500f,-0.50000000f,-0.35937500f,0.07812500f,-0.87500000f,0.04687500f,-0.26562500f,0.73437500f,-0.87500000f,-0.42187500f,0.54687500f,0.65625000f,0.84375000f,0.64062500f,-0.85937500f,-0.89062500f,-0.14062500f,-0.64062500f,-0.03125000f,-0.28125000f,0.82812500f,-0.70312500f,0.81250000f,0.93750000f,0.96875000f,-0.17187500f,-0.01562500f,0.65625000f,0.87500000f,-0.23437500f,-0.81250000f,0.39062500f,-0.45312500f,-0.75000000f,-0.96875000f,1.00000000f,0.62500000f,-0.32812500f,-0.73437500f,-0.50000000f,0.76562500f,-0.76562500f,0.32812500f,0.95312500f,-0.50000000f,0.70312500f,-0.31250000f,0.15625000f,-0.54687500f,-0.35937500f,0.89062500f,0.09375000f,-0.96875000f,0.84375000f,-0.06250000f,0.31250000f,-0.50000000f,0.85937500f,0.67187500f,0.67187500f,0.76562500f,0.25000000f,0.48437500f,0.09375000f,-0.26562500f,0.43750000f,-0.04687500f,-0.87500000f,0.76562500f,-0.40625000f,0.21875000f,-0.82812500f,0.56250000f,-0.23437500f,-0.48437500f,0.85937500f,-0.37500000f,0.96875000f,-0.71875000f,0.62500000f,0.42187500f,0.29687500f,-0.96875000f,-0.73437500f,-0.87500000f,-1.00000000f,-0.51562500f,0.90625000f,0.95312500f,-0.96875000f,0.85937500f,-0.09375000f,-0.87500000f,-0.46875000f,-0.76562500f,-0.57812500f,-0.20312500f,0.32812500f,-0.01562500f,0.96875000f,0.45312500f,-0.35937500f,0.03125000f,0.76562500f,-0.93750000f,0.79687500f,0.95312500f,0.28125000f,0.45312500f,-0.10937500f,-0.56250000f,-0.56250000f,0.01562500f,0.03125000f,0.00000000f,-0.18750000f,-0.93750000f,-0.31250000f,-0.34375000f,-0.32812500f,0.26562500f,-0.42187500f,0.34375000f,0.76562500f,0.68750000f,0.96875000f,0.84375000f,0.76562500f,0.39062500f,-0.31250000f,0.29687500f,0.54687500f,0.29687500f,0.89062500f,-0.95312500f,-0.48437500f,-0.15625000f,-0.64062500f,-0.84375000f,0.42187500f,-0.81250000f,0.93750000f,0.73437500f,-0.64062500f,-0.26562500f,0.45312500f,-0.95312500f,0.93750000f,0.40625000f,-0.45312500f,-0.93750000f,-0.15625000f,-0.73437500f,0.01562500f,0.50000000f,-0.12500000f,-0.96875000f,0.37500000f,0.79687500f,0.92187500f,-0.10937500f,-0.90625000f,-0.62500000f,0.53125000f,0.39062500f,0.92187500f,-0.95312500f,0.65625000f,-0.17187500f,0.93750000f,-0.64062500f,0.37500000f,0.26562500f,-0.62500000f,-0.75000000f,-0.81250000f,0.37500000f,-0.20312500f,0.00000000f,0.79687500f,-0.56250000f,0.59375000f,1.00000000f,-0.50000000f,0.40625000f,-0.95312500f,-0.87500000f,0.92187500f,0.28125000f,0.98437500f,0.70312500f,-0.95312500f,-0.35937500f,-0.96875000f,0.51562500f,-0.04687500f,-0.78125000f,-0.93750000f,0.06250000f,-0.70312500f,0.06250000f,-0.42187500f,-0.51562500f,-0.65625000f,-1.00000000f,-0.01562500f,0.54687500f,-0.25000000f,0.09375000f,0.87500000f,0.07812500f,0.68750000f,0.20312500f,0.31250000f,-0.28125000f,0.57812500f,-0.14062500f,-0.93750000f,-0.78125000f,0.35937500f,-0.18750000f,-0.07812500f,0.60937500f,-0.18750000f,-0.90625000f,0.35937500f,-0.28125000f,0.23437500f,-0.87500000f,-0.93750000f,-0.06250000f,-0.18750000f,0.12500000f,0.96875000f,-0.01562500f,-0.85937500f,0.29687500f,-0.42187500f,-0.43750000f,-0.56250000f,-0.93750000f,0.96875000f,-0.29687500f,0.29687500f,0.73437500f,0.01562500f,-0.35937500f,0.28125000f,-0.65625000f,-0.18750000f,-0.43750000f,-0.10937500f,0.35937500f,-0.01562500f,-0.84375000f,0.28125000f,0.67187500f,0.25000000f,0.50000000f,0.23437500f,-0.81250000f,0.10937500f,-0.56250000f,0.54687500f,0.07812500f,-0.76562500f,0.14062500f,-0.17187500f,0.93750000f,-0.28125000f,-0.78125000f,-0.68750000f,0.45312500f,0.09375000f,0.75000000f,0.50000000f,0.01562500f,-0.23437500f,-0.68750000f,0.57812500f,0.73437500f,-0.46875000f,-0.82812500f,0.40625000f,-0.15625000f,0.81250000f,-0.40625000f,-0.25000000f,-0.85937500f,-0.71875000f,0.71875000f,0.78125000f,0.90625000f,0.87500000f,-0.90625000f,0.64062500f,0.40625000f,-0.34375000f,0.17187500f,0.06250000f,0.87500000f,0.48437500f,-0.34375000f,1.00000000f,0.10937500f,-0.51562500f,-0.73437500f,0.81250000f,-0.95312500f,0.53125000f,-0.46875000f,0.20312500f,0.75000000f,-0.87500000f,-0.85937500f,0.71875000f,0.37500000f,-0.59375000f,-0.06250000f,-0.64062500f,-0.70312500f,0.40625000f,-0.12500000f,0.98437500f,0.03125000f,-0.93750000f,-0.23437500f,-0.20312500f,0.34375000f,0.10937500f,0.43750000f,-0.34375000f,-0.26562500f,-0.75000000f,0.48437500f,0.01562500f,0.81250000f,0.62500000f,0.31250000f,-0.60937500f,-0.40625000f,-0.87500000f,-0.87500000f,-0.42187500f,-0.70312500f,-0.89062500f,0.50000000f,-0.21875000f,0.50000000f,-0.87500000f,-0.82812500f,-0.31250000f,0.71875000f,0.90625000f,0.17187500f,0.45312500f,-0.67187500f,-0.54687500f,-0.64062500f,0.79687500f,-0.71875000f,0.73437500f,0.45312500f,-0.32812500f,-0.67187500f,0.98437500f,-0.85937500f,-0.01562500f,0.75000000f,-0.40625000f,-0.84375000f,0.04687500f,0.70312500f,0.45312500f,-0.89062500f,-0.54687500f,-0.17187500f,-0.59375000f,0.85937500f,-0.31250000f,0.46875000f,-0.29687500f,0.26562500f,-0.06250000f,-0.70312500f,0.79687500f,0.62500000f,-0.84375000f,0.07812500f,0.96875000f,0.59375000f,-0.65625000f,0.26562500f,0.01562500f,0.23437500f,-0.50000000f,-0.32812500f,-0.78125000f,-0.59375000f,0.76562500f,-0.60937500f,0.10937500f,0.35937500f,-0.62500000f,0.17187500f,0.67187500f,-0.10937500f,0.25000000f,0.21875000f,0.82812500f,0.84375000f,0.92187500f,0.42187500f,-0.57812500f,0.39062500f,0.78125000f,-0.71875000f,0.32812500f,0.64062500f,-0.64062500f,-0.59375000f,0.48437500f,0.82812500f,-0.87500000f,0.40625000f,0.37500000f,-0.57812500f,0.12500000f,-0.10937500f,-0.03125000f,-0.68750000f,-0.70312500f,0.48437500f,0.14062500f,-0.78125000f,0.60937500f,0.23437500f,0.79687500f,0.14062500f,-0.68750000f,0.95312500f,0.14062500f,0.01562500f,-0.84375000f,-0.76562500f,-0.15625000f,-0.23437500f,0.59375000f,-0.14062500f,-0.75000000f,0.25000000f,0.04687500f,-0.28125000f,-0.03125000f,0.75000000f,-0.34375000f,-0.42187500f,-0.34375000f,-0.20312500f,0.17187500f,0.64062500f,-0.43750000f,0.79687500f,-0.25000000f,-0.03125000f,-0.56250000f,0.23437500f,0.32812500f,-0.03125000f,-0.01562500f,0.87500000f,-1.00000000f,-0.54687500f,-0.43750000f,0.07812500f,-0.82812500f,-0.48437500f,-0.82812500f,0.04687500f,-0.76562500f,-0.45312500f,0.65625000f,0.10937500f,-0.20312500f,0.21875000f,0.32812500f,0.96875000f,0.04687500f,0.87500000f,-0.35937500f,0.31250000f,-0.85937500f,0.29687500f,0.56250000f,-0.17187500f,0.76562500f,0.09375000f,0.09375000f,0.75000000f,0.45312500f,0.64062500f,-0.04687500f,-0.90625000f,0.87500000f,0.20312500f,-0.12500000f,0.87500000f,-0.20312500f,0.48437500f,0.35937500f,0.32812500f,0.03125000f,0.76562500f,-0.57812500f,-0.59375000f,0.82812500f,0.51562500f,-0.68750000f,-0.62500000f,-0.31250000f,-0.35937500f,0.95312500f,-0.40625000f,-0.03125000f,-0.96875000f,-1.00000000f,0.01562500f,0.09375000f,0.84375000f,-0.87500000f,-0.81250000f,0.31250000f,-0.51562500f,-0.51562500f,0.54687500f,-0.23437500f,0.17187500f,-0.04687500f,0.56250000f,-0.32812500f,-0.89062500f,0.10937500f,0.43750000f,-0.23437500f,-0.67187500f,-0.78125000f,-0.60937500f,-0.23437500f,0.31250000f,-0.95312500f,0.98437500f,-0.96875000f,0.75000000f,0.70312500f,0.70312500f,-0.96875000f,-0.14062500f,0.93750000f,0.48437500f,-0.82812500f,0.84375000f,0.84375000f,-0.06250000f,0.42187500f,-0.01562500f,0.23437500f,-0.84375000f,1.00000000f,-0.84375000f,0.57812500f,-0.54687500f,0.17187500f,0.73437500f,0.87500000f,-0.45312500f,-0.04687500f,-0.39062500f,0.60937500f,0.34375000f,0.76562500f,-0.62500000f,0.43750000f,0.96875000f,0.84375000f,-0.62500000f,0.51562500f,-0.21875000f,0.65625000f,-0.59375000f,-0.18750000f,0.90625000f,0.45312500f,0.89062500f,0.04687500f,-0.17187500f,-0.28125000f,0.14062500f,0.29687500f,-0.46875000f,-0.43750000f,0.57812500f,-0.96875000f,0.28125000f,-0.20312500f,-0.62500000f,-0.68750000f,0.31250000f,0.39062500f,0.98437500f,0.57812500f,-0.57812500f,-0.78125000f,0.42187500f,0.81250000f,-0.95312500f,-0.25000000f,-0.50000000f,-0.18750000f,-0.39062500f,-0.40625000f,-0.29687500f,-0.70312500f,0.84375000f,0.40625000f,-0.06250000f,0.60937500f,-0.12500000f,-0.20312500f,0.84375000f,-0.53125000f,0.85937500f,-0.96875000f,0.84375000f,-0.03125000f,0.29687500f,-0.53125000f,-0.40625000f,0.92187500f,-0.48437500f,0.07812500f,0.98437500f,0.76562500f,0.79687500f,-0.81250000f,0.54687500f,0.01562500f,0.03125000f,0.34375000f,0.06250000f,-0.73437500f,0.01562500f,0.09375000f,-0.92187500f,-0.35937500f,-0.64062500f,-0.64062500f,0.10937500f,-0.82812500f,0.39062500f,-0.20312500f,-0.20312500f,0.15625000f,0.09375000f,-0.70312500f,0.26562500f,-0.28125000f,-0.46875000f,0.40625000f,0.64062500f,0.67187500f,0.12500000f,-0.68750000f,0.50000000f,-0.50000000f,0.79687500f,-0.15625000f,-0.26562500f,0.73437500f,0.92187500f,-0.48437500f,0.15625000f,-0.93750000f,-0.21875000f,0.95312500f,-0.37500000f,-0.45312500f,0.78125000f,0.78125000f,-0.70312500f,0.48437500f,-0.75000000f,0.89062500f,-0.14062500f,-0.23437500f,-0.17187500f,0.54687500f,-0.81250000f,0.01562500f,-0.78125000f,0.26562500f,-0.85937500f,-0.75000000f,0.40625000f,-0.93750000f,0.79687500f,-0.09375000f,-0.35937500f,-0.43750000f,-0.15625000f,0.50000000f,-0.06250000f,-0.59375000f,0.85937500f,0.39062500f,-0.06250000f,0.37500000f,-0.64062500f,-0.68750000f,0.31250000f,0.96875000f,0.56250000f,0.25000000f,0.48437500f,-0.14062500f,0.20312500f,1.00000000f,-0.67187500f,-0.46875000f,0.17187500f,0.09375000f,0.10937500f,0.85937500f,-0.10937500f,-0.71875000f,-0.51562500f,0.85937500f,-0.26562500f,0.71875000f,0.81250000f,-0.93750000f,-0.50000000f,-0.54687500f,0.84375000f,-0.60937500f,-0.62500000f,0.51562500f,0.93750000f,-0.26562500f,0.15625000f,0.56250000f,0.71875000f,0.51562500f,-0.84375000f,-0.50000000f,-0.28125000f,-0.81250000f,-0.34375000f,-0.09375000f,-0.03125000f,-0.25000000f,0.07812500f,-0.07812500f,0.78125000f,0.90625000f,-0.14062500f,0.17187500f,-0.95312500f,-0.21875000f,0.67187500f,-0.96875000f,0.25000000f,1.00000000f,0.07812500f,0.15625000f,-0.06250000f,0.71875000f,-0.87500000f,-0.12500000f,0.07812500f,-0.35937500f,-0.39062500f,0.17187500f,-0.57812500f,-0.46875000f,0.76562500f,-0.46875000f,0.57812500f,-0.65625000f,0.00000000f,-0.40625000f,0.34375000f,-0.48437500f,0.12500000f,0.75000000f,-0.04687500f,0.23437500f,0.42187500f,0.50000000f,0.67187500f,0.68750000f,0.73437500f,0.95312500f,-0.71875000f,-0.10937500f,-0.87500000f,-0.42187500f,0.48437500f,0.60937500f,-0.12500000f,-0.67187500f,-0.31250000f,-0.65625000f,-0.95312500f,-0.51562500f,0.10937500f,0.81250000f,0.54687500f,0.59375000f,-0.48437500f,-0.81250000f,-0.54687500f,0.07812500f,-0.82812500f,0.07812500f,1.00000000f,-0.67187500f,0.20312500f,0.59375000f,-0.18750000f,-0.50000000f,-0.46875000f,0.25000000f,0.20312500f,0.37500000f,-0.85937500f,0.46875000f,-0.79687500f,0.57812500f,0.71875000f,-0.07812500f,-0.79687500f,-0.29687500f,0.78125000f,0.64062500f,-0.15625000f,-0.32812500f,-0.62500000f,0.40625000f,-0.71875000f,-0.46875000f,0.14062500f,0.20312500f,-0.78125000f,0.43750000f,0.01562500f,0.60937500f,-0.82812500f,-0.50000000f,-0.34375000f,0.26562500f,-0.84375000f,-0.32812500f,0.01562500f,-0.76562500f,-0.84375000f,-0.25000000f,-0.34375000f,-0.51562500f,0.57812500f,0.14062500f,-0.26562500f,-0.43750000f,-0.31250000f,0.73437500f,0.62500000f,0.76562500f,-0.53125000f,-0.29687500f,-0.82812500f,-0.60937500f,-0.03125000f,-0.32812500f,-0.76562500f,0.09375000f,0.76562500f,0.92187500f,0.35937500f,0.29687500f,0.75000000f,-0.98437500f,-0.10937500f,-0.73437500f,0.10937500f,-0.53125000f,-0.56250000f,0.35937500f,0.71875000f,-0.26562500f,-0.68750000f,0.28125000f,0.15625000f,0.10937500f,-0.62500000f,0.65625000f,-0.21875000f,0.81250000f,-0.10937500f,0.25000000f,0.68750000f,-0.81250000f,-0.64062500f,0.35937500f,0.01562500f,-0.43750000f,0.76562500f,0.34375000f,-0.57812500f,0.40625000f,0.56250000f,-0.65625000f,0.98437500f,-0.68750000f,0.56250000f,0.46875000f,0.90625000f,0.06250000f,0.68750000f,0.75000000f,0.26562500f,0.14062500f,0.34375000f,-0.81250000f,0.25000000f,0.76562500f,0.85937500f,0.31250000f,-0.34375000f,0.95312500f,-0.95312500f,-0.09375000f,-0.78125000f,-0.89062500f,0.17187500f,-0.57812500f,0.82812500f,0.25000000f,-0.98437500f,0.68750000f,0.92187500f,-0.15625000f,0.46875000f,-0.18750000f,-0.93750000f,0.42187500f,0.85937500f,0.01562500f,0.78125000f,0.60937500f,-0.78125000f,-0.28125000f,-0.89062500f,0.56250000f,0.34375000f,0.70312500f,0.89062500f,0.25000000f,0.21875000f,0.14062500f,-1.00000000f,-0.17187500f,0.25000000f,-0.21875000f,-0.89062500f,0.79687500f,-0.82812500f,0.76562500f,0.42187500f,0.73437500f,0.51562500f,-0.17187500f,-0.01562500f,-0.20312500f,0.01562500f,-0.04687500f,0.03125000f,0.42187500f,0.29687500f,-0.25000000f,0.31250000f,0.04687500f,-0.23437500f,0.14062500f,0.26562500f,-0.68750000f,-0.60937500f,-0.82812500f,0.18750000f,0.14062500f,0.53125000f,-0.42187500f,-0.01562500f,-0.18750000f,-0.26562500f,0.62500000f,0.26562500f,0.98437500f,0.93750000f,0.06250000f,0.81250000f,0.15625000f,-0.21875000f,-0.78125000f,0.18750000f,-0.17187500f,0.21875000f,-0.28125000f,-0.06250000f,0.06250000f,0.46875000f,-0.82812500f,0.96875000f,-0.14062500f,0.18750000f,0.84375000f,0.01562500f,-0.81250000f,0.26562500f,0.10937500f,-0.71875000f,0.45312500f,0.67187500f,0.67187500f,0.48437500f,-0.17187500f,0.98437500f,-0.17187500f,-0.35937500f,-0.50000000f,0.70312500f,-0.18750000f,0.89062500f,-0.50000000f,0.89062500f,0.84375000f,-0.03125000f,0.40625000f,-0.68750000f,-0.10937500f,-0.68750000f,0.62500000f,0.35937500f,0.92187500f,-0.68750000f,-0.17187500f,0.68750000f,0.17187500f,0.57812500f,0.34375000f,0.96875000f,-0.43750000f,0.50000000f,0.89062500f,0.75000000f,0.20312500f,-0.14062500f,-0.84375000f,-0.07812500f,-0.89062500f,0.45312500f,-0.53125000f,0.82812500f,-0.60937500f,-0.34375000f,-0.37500000f,0.12500000f,0.45312500f,-0.76562500f,-0.17187500f,0.78125000f,0.12500000f,0.76562500f,0.29687500f,0.42187500f,0.57812500f,-0.12500000f,-0.09375000f,0.29687500f,-0.35937500f,-0.98437500f,-0.54687500f,-1.00000000f,-0.85937500f,0.56250000f,0.20312500f,-0.82812500f,-0.26562500f,0.20312500f,0.71875000f,-0.50000000f,-0.32812500f,0.92187500f,0.20312500f,-0.81250000f,-0.59375000f,0.98437500f,0.78125000f,0.82812500f,-0.98437500f,-0.21875000f,0.10937500f,-0.37500000f,0.21875000f,0.45312500f,-0.95312500f,0.46875000f,0.64062500f,-0.62500000f,0.50000000f,-0.01562500f,-0.01562500f,-0.90625000f,-0.68750000f,0.85937500f,0.43750000f,-0.34375000f,-0.90625000f,0.68750000f,-0.76562500f,-0.95312500f,0.73437500f,-0.06250000f,-0.96875000f,0.79687500f,-0.68750000f,0.56250000f,0.12500000f,0.53125000f,-0.42187500f,-0.18750000f,-0.10937500f,-0.82812500f,0.85937500f,-0.37500000f,-0.73437500f,0.28125000f,-0.60937500f,-0.04687500f,0.45312500f,0.60937500f,0.79687500f,0.07812500f,-0.50000000f,0.90625000f,0.10937500f,-0.65625000f,-0.10937500f,0.75000000f,-0.64062500f,-0.18750000f,0.64062500f,0.18750000f,-0.64062500f,0.35937500f,0.85937500f,0.12500000f,0.70312500f,-0.56250000f,-0.04687500f,-0.70312500f,-0.43750000f,0.71875000f,0.85937500f,-0.96875000f,-0.96875000f,-0.71875000f,-0.64062500f,-0.17187500f,-0.28125000f,0.45312500f,0.03125000f,-0.17187500f,0.39062500f,-0.17187500f,0.43750000f,0.20312500f,-0.40625000f,-0.79687500f,0.21875000f,-0.82812500f,-0.81250000f,-0.53125000f,-0.64062500f,0.51562500f,-0.14062500f,0.67187500f,-0.60937500f,0.62500000f,-0.14062500f,-0.92187500f,-0.75000000f,-0.18750000f,0.48437500f,-0.62500000f,0.01562500f,-0.90625000f,0.03125000f,-0.87500000f,-0.76562500f,0.00000000f,-0.95312500f,0.00000000f,-0.93750000f,0.12500000f,-0.20312500f,-0.81250000f,0.57812500f,-0.21875000f,-0.34375000f,-0.87500000f,-0.14062500f,-0.76562500f,0.95312500f,0.25000000f,-0.67187500f,0.17187500f,0.17187500f,-0.43750000f,0.68750000f,0.35937500f,0.75000000f,0.10937500f,-0.07812500f,0.95312500f,0.45312500f,0.87500000f,0.71875000f,-0.03125000f,-0.43750000f,0.01562500f,-0.89062500f,-0.14062500f,0.59375000f,0.53125000f,0.46875000f,0.20312500f,0.01562500f,0.92187500f,0.96875000f,0.98437500f,0.89062500f,0.62500000f,0.42187500f,0.78125000f,0.79687500f,-0.37500000f,0.50000000f,-0.37500000f,-0.14062500f,0.25000000f,0.82812500f,-0.34375000f,0.85937500f,0.65625000f,-0.25000000f,0.09375000f,0.54687500f,-0.75000000f,-0.92187500f,0.12500000f,-0.82812500f,-0.39062500f,0.92187500f,0.07812500f,0.42187500f,0.82812500f,-0.09375000f,0.01562500f,-0.76562500f,0.09375000f,-0.65625000f,0.42187500f,-0.18750000f,0.59375000f,-0.75000000f,-1.00000000f,-0.09375000f,-0.71875000f,-0.96875000f,-0.01562500f,0.71875000f,-1.00000000f,0.03125000f,-0.01562500f,-0.45312500f,0.68750000f,0.95312500f,-0.90625000f,0.82812500f,0.26562500f,-0.15625000f,0.35937500f,-0.70312500f,0.01562500f,1.00000000f,0.90625000f,0.87500000f,0.39062500f,0.67187500f,-0.96875000f,0.56250000f,-0.53125000f,0.06250000f,0.85937500f,0.48437500f,-0.39062500f,-0.25000000f,0.81250000f,-0.31250000f,0.62500000f,-0.48437500f,0.50000000f,0.10937500f,0.15625000f,0.82812500f,0.95312500f,0.40625000f,0.96875000f,-0.17187500f,-0.79687500f,0.95312500f,-0.07812500f,0.26562500f,-0.39062500f,0.78125000f,0.57812500f,-0.53125000f,-0.15625000f,-0.57812500f,-0.45312500f,-0.59375000f,-0.14062500f,-0.65625000f,0.57812500f,-0.68750000f,-0.07812500f,0.37500000f,-0.85937500f,0.54687500f,-0.20312500f,-0.95312500f,-0.14062500f,0.81250000f,-0.12500000f,0.20312500f,0.81250000f,0.65625000f,-1.00000000f,0.85937500f,-0.32812500f,0.35937500f,-0.56250000f,0.82812500f,0.65625000f,-0.84375000f,-0.17187500f,-0.03125000f,-0.18750000f,0.56250000f,-0.32812500f,-0.85937500f,0.26562500f,-0.01562500f,0.90625000f,0.48437500f,0.21875000f,0.85937500f,-0.60937500f,-0.28125000f,0.70312500f,0.68750000f,-0.65625000f,0.70312500f,-0.26562500f,-0.48437500f,0.62500000f,0.85937500f,-0.56250000f,-0.59375000f,-0.46875000f,0.92187500f,0.29687500f,-0.53125000f,-0.48437500f,0.45312500f,0.25000000f,-0.87500000f,-0.15625000f,-0.48437500f,-0.04687500f,-0.78125000f,0.29687500f,-0.84375000f,-0.17187500f,-0.78125000f,0.50000000f,0.46875000f,-0.32812500f,-0.35937500f,0.48437500f,-0.12500000f,-0.76562500f,0.67187500f,0.85937500f,0.18750000f,0.42187500f,1.00000000f,0.75000000f,0.53125000f,0.98437500f,-0.73437500f,0.17187500f,-0.45312500f,-0.65625000f,-0.03125000f,0.00000000f,0.96875000f,0.92187500f,0.29687500f,-0.96875000f,-0.95312500f,0.23437500f,0.73437500f,-0.54687500f,0.78125000f,-0.85937500f,-0.53125000f,-0.64062500f,0.00000000f,0.73437500f,-0.03125000f,0.85937500f,0.10937500f,-0.26562500f,-0.70312500f,0.04687500f,-0.03125000f,0.76562500f,-0.04687500f,-0.81250000f,-0.71875000f,0.10937500f,-0.84375000f,0.39062500f,0.21875000f,0.43750000f,-0.40625000f,1.00000000f,0.92187500f,-0.21875000f,-0.85937500f,-0.32812500f,0.34375000f,0.84375000f,-0.45312500f,-0.31250000f,-0.56250000f,-0.90625000f,0.87500000f,-0.43750000f,0.48437500f,0.62500000f,-0.06250000f,-0.57812500f,0.28125000f,-0.45312500f,0.54687500f,0.01562500f,-0.20312500f,-0.92187500f,0.76562500f,0.89062500f,-0.90625000f,0.87500000f,-0.96875000f,-0.15625000f,0.90625000f,0.43750000f,-0.07812500f,-0.70312500f,-0.35937500f,-0.53125000f,0.14062500f,0.92187500f,-0.18750000f,-0.15625000f,0.73437500f,-0.59375000f,-0.75000000f,0.76562500f,-0.01562500f,0.96875000f,0.53125000f,0.64062500f,0.82812500f,0.57812500f,-0.34375000f,-0.65625000f,0.39062500f,0.96875000f,-0.54687500f,-0.09375000f,0.76562500f,-0.84375000f,0.51562500f,0.28125000f,-0.57812500f,0.54687500f,0.32812500f,-0.65625000f,0.10937500f,0.14062500f,0.32812500f,0.53125000f,0.84375000f,0.04687500f,-0.23437500f,-0.76562500f,-0.48437500f,0.53125000f,-0.95312500f,-0.34375000f,0.70312500f,0.67187500f,-0.31250000f,-0.23437500f,0.39062500f,-0.50000000f,0.73437500f,0.09375000f,-0.57812500f,0.76562500f,0.96875000f,-0.60937500f,0.42187500f,0.25000000f,0.60937500f,0.64062500f,0.51562500f,-0.85937500f,-0.98437500f,0.75000000f,-0.45312500f,-0.93750000f,-0.62500000f,0.95312500f,-0.59375000f,0.51562500f,-0.14062500f,-0.68750000f,0.79687500f,0.28125000f,-0.01562500f,-0.28125000f,-0.78125000f,0.15625000f,-0.85937500f,0.76562500f,0.07812500f,-0.50000000f,-0.60937500f,-0.81250000f,0.56250000f,0.12500000f,-0.14062500f,-0.78125000f,0.35937500f,-0.32812500f,-0.84375000f,-0.37500000f,0.98437500f,-0.23437500f,0.06250000f,-0.82812500f,0.46875000f,0.46875000f,-0.60937500f,0.54687500f,-0.93750000f,-0.25000000f,0.93750000f,0.32812500f,0.92187500f,0.12500000f,0.39062500f,0.00000000f,-0.09375000f,-0.68750000f,-0.28125000f,0.95312500f,-0.06250000f,-0.68750000f,0.62500000f,-0.06250000f,-0.31250000f,-0.56250000f,-0.12500000f,0.56250000f,0.03125000f,-0.20312500f,-0.31250000f,0.37500000f,-0.04687500f,0.53125000f,0.82812500f,0.43750000f,0.53125000f,-0.12500000f,-0.29687500f,-0.37500000f,-0.26562500f,-0.10937500f,-0.39062500f,-0.18750000f,0.65625000f,-0.12500000f,0.37500000f,0.78125000f,-0.45312500f,-0.48437500f,-0.10937500f,0.06250000f,0.73437500f,0.89062500f,0.42187500f,0.40625000f,0.81250000f,-0.90625000f,-0.70312500f,0.20312500f,-0.70312500f,0.21875000f,-0.46875000f,0.85937500f,-0.90625000f,0.45312500f,-0.09375000f,0.87500000f,0.78125000f,-0.25000000f,0.21875000f,-0.15625000f,-0.01562500f,-0.67187500f,-0.04687500f,0.34375000f,-0.51562500f,0.95312500f,-0.64062500f,-0.26562500f,-0.51562500f,-0.92187500f,0.70312500f,-0.68750000f,-0.64062500f,-0.20312500f,-0.64062500f,-0.14062500f,0.42187500f,-0.23437500f,0.40625000f,-0.51562500f,0.40625000f,-0.45312500f,-0.53125000f,-0.35937500f,0.82812500f,-0.57812500f,0.56250000f,-0.07812500f,0.54687500f,0.15625000f,0.76562500f,-0.98437500f,-0.87500000f,0.87500000f,-0.89062500f,0.90625000f,0.56250000f,-0.35937500f,0.75000000f,0.95312500f,-0.95312500f,-0.32812500f,-0.48437500f,0.64062500f,0.23437500f,0.14062500f,-0.21875000f,-0.04687500f,-0.81250000f,0.21875000f,0.45312500f,-0.06250000f,-0.34375000f,-0.79687500f,0.67187500f,0.84375000f,0.40625000f,0.87500000f,0.68750000f,0.68750000f,0.07812500f,0.67187500f,-0.18750000f,-0.82812500f,-0.85937500f,-0.34375000f,0.81250000f,0.71875000f,-0.57812500f,-0.70312500f,0.68750000f,-0.03125000f,0.54687500f,-0.17187500f,0.15625000f,0.01562500f,-0.45312500f,-0.29687500f,-0.64062500f,0.06250000f,0.21875000f,0.45312500f,0.39062500f,0.51562500f,-0.67187500f,-0.42187500f,-0.82812500f,-0.89062500f,-0.51562500f,0.75000000f,0.82812500f,0.15625000f,-0.25000000f,-0.92187500f,0.25000000f,0.56250000f,-0.85937500f,0.18750000f,-0.06250000f,-1.00000000f,-0.82812500f,-0.89062500f,0.76562500f,-0.42187500f,-0.06250000f,-0.81250000f,0.34375000f,0.04687500f,0.50000000f,-0.15625000f,0.79687500f,0.10937500f,0.53125000f,0.78125000f,0.81250000f,0.20312500f,-1.00000000f,-0.53125000f,0.37500000f,0.34375000f,0.10937500f,0.79687500f,0.71875000f,0.35937500f,0.81250000f,-0.96875000f,-0.07812500f,-0.68750000f,-0.98437500f,0.43750000f,0.59375000f,0.25000000f,0.25000000f,-0.18750000f,-0.75000000f,-0.12500000f,0.28125000f,0.25000000f,-0.21875000f,0.15625000f,0.01562500f,-0.92187500f,-0.18750000f,-0.32812500f,-0.42187500f,0.48437500f,-0.40625000f,-0.29687500f,-0.75000000f,1.00000000f,0.20312500f,-0.25000000f,-0.32812500f,0.75000000f,0.03125000f,0.87500000f,-0.07812500f,0.23437500f,-0.37500000f,-0.34375000f,0.48437500f,0.29687500f,-0.14062500f,0.06250000f,0.84375000f,-0.12500000f,0.93750000f,0.06250000f,-0.96875000f,-0.42187500f,-1.00000000f,-1.00000000f,0.09375000f,0.93750000f,-0.76562500f,-0.48437500f,-0.15625000f,0.67187500f,0.28125000f,0.53125000f,0.59375000f,-0.73437500f,-0.68750000f,0.50000000f,-0.32812500f,-0.06250000f,0.70312500f,-0.45312500f,-0.60937500f,-0.56250000f,-0.18750000f,-0.78125000f,-0.06250000f,-0.73437500f,-0.25000000f,0.15625000f,0.37500000f,-0.10937500f,-0.57812500f,-0.57812500f,-0.71875000f,0.32812500f,-0.98437500f,-0.70312500f,-0.76562500f,-0.18750000f,-0.96875000f,0.28125000f,-0.35937500f,0.25000000f,-0.96875000f,0.71875000f,-0.70312500f,-0.06250000f,0.70312500f,0.37500000f,-0.03125000f,0.29687500f,0.26562500f,-0.68750000f,-0.76562500f,-0.90625000f,0.14062500f,0.06250000f,-0.84375000f,0.37500000f,0.37500000f,-0.98437500f,0.01562500f,0.50000000f,-0.62500000f,-0.62500000f,0.37500000f,-0.79687500f,0.79687500f,0.70312500f,-0.09375000f,0.50000000f,-0.23437500f,0.12500000f,-0.93750000f,-0.31250000f,0.79687500f,-0.48437500f,0.59375000f,0.54687500f,0.95312500f,0.51562500f,0.57812500f,0.92187500f,0.15625000f,-0.79687500f,-0.81250000f,0.46875000f,-0.70312500f,-0.56250000f,-0.84375000f,-0.92187500f,-0.12500000f,0.00000000f,-0.78125000f,0.34375000f,-0.82812500f,-0.26562500f,0.93750000f,-0.95312500f,-0.42187500f,0.95312500f,0.35937500f,-0.87500000f,0.29687500f,0.51562500f,0.25000000f,0.14062500f,-0.71875000f,-0.62500000f,-0.35937500f,0.29687500f,-0.56250000f,-0.34375000f,0.81250000f,-0.90625000f,-0.75000000f,0.53125000f,-0.10937500f,0.92187500f,0.57812500f,0.29687500f,0.39062500f,0.18750000f,-0.84375000f,0.65625000f,0.93750000f,-0.71875000f,-0.43750000f,-0.42187500f,0.25000000f,0.15625000f,-0.96875000f,-0.93750000f,-0.12500000f,-0.40625000f,0.53125000f,0.26562500f,-0.21875000f,0.51562500f,0.37500000f,-0.57812500f,0.26562500f,-0.17187500f,0.35937500f,0.79687500f,-0.75000000f,-0.07812500f,0.21875000f,-0.98437500f,-0.03125000f,-0.26562500f,0.31250000f,-0.03125000f,-0.40625000f,-0.76562500f,-0.37500000f,0.81250000f,-0.17187500f,0.29687500f,0.62500000f,0.40625000f,0.20312500f,0.40625000f,-0.79687500f,-0.53125000f,-0.71875000f,-0.70312500f,-0.23437500f,0.95312500f,0.84375000f,0.29687500f,0.40625000f,0.96875000f,0.93750000f,-0.03125000f,0.01562500f,0.60937500f,-0.28125000f,-0.85937500f,0.29687500f,0.68750000f,0.73437500f,0.56250000f,-0.67187500f,0.50000000f,-0.04687500f,0.09375000f,-0.48437500f,-0.43750000f,0.17187500f,0.57812500f,0.25000000f,-0.15625000f,0.32812500f,-0.84375000f,-0.28125000f,0.81250000f,0.65625000f,-0.65625000f,-0.70312500f,0.67187500f,-0.48437500f,0.65625000f,1.00000000f,-0.15625000f,-0.23437500f,0.23437500f,0.25000000f,-0.53125000f,0.48437500f,-0.73437500f,0.17187500f,0.28125000f,0.29687500f,0.12500000f,0.09375000f,0.31250000f,0.31250000f,-0.18750000f,-0.25000000f,-0.42187500f,-0.45312500f,-0.40625000f,0.82812500f,-0.90625000f,0.73437500f,0.56250000f,-0.09375000f,0.34375000f,-0.26562500f,0.29687500f,0.50000000f,0.46875000f,0.23437500f,0.43750000f,0.37500000f,-0.26562500f,0.60937500f,0.53125000f,0.53125000f,0.25000000f,-0.45312500f,0.51562500f,-0.64062500f,0.79687500f,-0.12500000f,0.93750000f,-0.45312500f,0.92187500f,0.64062500f,0.37500000f,0.06250000f,0.23437500f,-0.45312500f,0.50000000f,-0.09375000f,-0.79687500f,-0.95312500f,0.51562500f,-0.84375000f,-0.14062500f,0.93750000f,-0.82812500f,-0.62500000f,0.87500000f,0.03125000f,-0.53125000f,-0.09375000f,-0.96875000f,-0.28125000f,0.90625000f,0.56250000f,-0.35937500f,-0.37500000f,-0.29687500f,0.25000000f,0.71875000f,-0.75000000f,0.14062500f,-0.34375000f,0.12500000f,-0.01562500f,0.73437500f,-0.51562500f,-0.10937500f,-0.14062500f,0.82812500f,-0.89062500f,0.15625000f,-0.90625000f,-0.31250000f,-0.20312500f,-0.28125000f,-0.98437500f,-0.71875000f,-0.51562500f,-0.07812500f,-0.32812500f,0.76562500f,-0.37500000f,0.79687500f,-0.35937500f,0.39062500f,0.70312500f,-0.14062500f,0.65625000f,0.18750000f,0.04687500f,-0.54687500f,0.82812500f,-0.35937500f,0.43750000f,0.59375000f,-0.98437500f,0.60937500f,-0.60937500f,0.51562500f,-0.06250000f,-0.68750000f,0.50000000f,-0.04687500f,0.62500000f,0.45312500f,0.43750000f,0.70312500f,0.75000000f,-0.06250000f,-0.89062500f,0.85937500f,0.84375000f,-0.07812500f,0.67187500f,0.59375000f,0.59375000f,-1.00000000f,0.46875000f,0.65625000f,0.07812500f,0.43750000f,0.09375000f,0.82812500f,1.00000000f,0.12500000f,0.65625000f,-0.42187500f,-0.31250000f,-0.59375000f,0.51562500f,0.53125000f,0.23437500f,0.85937500f,-0.34375000f,-0.12500000f,-0.28125000f,0.78125000f,0.57812500f,1.00000000f,-0.53125000f,-0.56250000f,-0.64062500f,0.46875000f,-1.00000000f,-1.00000000f,0.87500000f,-0.56250000f,-0.84375000f,0.18750000f,0.18750000f,0.84375000f,0.15625000f,0.67187500f,0.29687500f,0.34375000f,0.73437500f,-0.90625000f,0.75000000f,0.95312500f,-0.39062500f,-0.75000000f,-0.43750000f,0.75000000f,0.42187500f,-0.53125000f,0.59375000f,-0.75000000f,-0.96875000f,0.85937500f,0.09375000f,0.82812500f,-0.45312500f,0.23437500f,-0.71875000f,0.29687500f,0.96875000f,-0.23437500f,0.12500000f,0.98437500f,-0.54687500f,-0.59375000f,-0.76562500f,-0.34375000f,-0.45312500f,0.67187500f,0.35937500f,0.82812500f,-0.17187500f,-0.71875000f,-1.00000000f,-0.65625000f,0.93750000f,0.82812500f,0.92187500f,-0.32812500f,0.62500000f,0.21875000f,-0.70312500f,0.45312500f,-0.28125000f,-0.31250000f,0.98437500f,-0.40625000f,-0.09375000f,-0.53125000f,0.62500000f,0.50000000f,0.32812500f,0.09375000f,-0.20312500f,0.29687500f,-0.43750000f,-0.70312500f,-0.92187500f,-0.60937500f,0.23437500f,0.57812500f,-0.92187500f,-0.64062500f,0.04687500f,0.92187500f,0.46875000f,0.12500000f,-0.37500000f,-0.04687500f,0.01562500f,0.93750000f,0.06250000f,-0.09375000f,-0.67187500f,1.00000000f,0.31250000f,0.43750000f,0.00000000f,-0.51562500f,0.60937500f,0.71875000f,0.26562500f,0.62500000f,0.81250000f,0.82812500f,0.95312500f,0.37500000f,0.39062500f,-0.67187500f,0.43750000f,-0.07812500f,0.48437500f,-0.34375000f,-0.15625000f,0.60937500f,0.67187500f,-0.68750000f,-0.10937500f,-0.46875000f,-0.31250000f,0.23437500f,-0.85937500f,-0.57812500f,0.56250000f,0.82812500f,-0.40625000f,0.71875000f,0.21875000f,-0.01562500f,-0.01562500f,0.04687500f,-0.57812500f,0.81250000f,0.37500000f,-0.45312500f,0.00000000f,-0.34375000f,-0.64062500f,0.10937500f,-0.90625000f,0.71875000f,-0.03125000f,-0.75000000f,-0.90625000f,-0.70312500f,0.70312500f,-0.40625000f,0.29687500f,-0.54687500f,0.65625000f,-0.42187500f,0.96875000f,0.78125000f,-0.89062500f,-0.92187500f,0.85937500f,0.59375000f,0.78125000f,-0.20312500f,-0.68750000f,-0.75000000f,0.06250000f,-0.57812500f,-0.98437500f,0.50000000f,0.35937500f,-0.43750000f,-0.92187500f,0.82812500f,0.35937500f,-0.59375000f,-0.46875000f,-0.51562500f,-0.42187500f,0.39062500f,-0.35937500f,-0.39062500f,0.23437500f,0.57812500f,-0.29687500f,-0.81250000f,-0.82812500f,-0.79687500f,-0.20312500f,-0.76562500f,0.79687500f,0.62500000f,-0.60937500f,0.96875000f,-0.43750000f,0.70312500f,-0.65625000f,-0.65625000f,-0.09375000f,-0.65625000f,0.00000000f,0.40625000f,-0.84375000f,-0.92187500f,0.04687500f,0.89062500f,-0.17187500f,-0.81250000f,-0.10937500f,0.14062500f,-0.85937500f,-1.00000000f,0.70312500f,-0.25000000f,-0.70312500f,-0.31250000f,0.82812500f,0.82812500f,0.71875000f,0.43750000f,-0.48437500f,0.34375000f,-0.25000000f,-0.28125000f,0.53125000f,-0.12500000f,0.56250000f,0.82812500f,0.01562500f,-0.60937500f,0.57812500f,0.93750000f,-0.73437500f,0.31250000f,0.79687500f,-0.54687500f,0.14062500f,0.42187500f,0.34375000f,0.31250000f,-0.39062500f,-0.10937500f,0.85937500f,-0.56250000f,-0.84375000f,-0.40625000f,-0.26562500f,0.28125000f,-0.93750000f,-0.09375000f,0.62500000f,-0.29687500f,-0.25000000f,-0.18750000f,0.28125000f,-0.51562500f,-0.43750000f,0.39062500f,-0.18750000f,-0.82812500f,0.15625000f,-0.82812500f,0.89062500f,-0.29687500f,-0.75000000f,-0.45312500f,0.59375000f,-0.78125000f,0.14062500f,-0.53125000f,0.07812500f,-0.98437500f,0.60937500f,0.21875000f,-0.68750000f,-0.35937500f,-0.20312500f,0.48437500f,-0.56250000f,0.76562500f,0.48437500f,-0.78125000f,0.03125000f,0.65625000f,-0.96875000f,0.54687500f,0.60937500f,0.78125000f,0.42187500f,-0.56250000f,-0.34375000f,0.64062500f,-1.00000000f,0.17187500f,0.71875000f,-0.68750000f,-0.96875000f,0.45312500f,-0.60937500f,0.31250000f,0.92187500f,0.98437500f,0.25000000f,-0.37500000f,0.21875000f,0.73437500f,-0.04687500f,-0.18750000f,-0.35937500f,-0.59375000f,0.98437500f,-0.29687500f,0.45312500f,-0.26562500f,0.45312500f,0.70312500f,-0.75000000f,0.37500000f,-0.03125000f,-0.03125000f,-0.64062500f,-0.71875000f,0.15625000f,-0.84375000f,-0.62500000f,-0.81250000f,0.70312500f,0.31250000f,0.04687500f,0.67187500f,0.09375000f,0.53125000f,0.87500000f,-0.54687500f,0.87500000f,0.81250000f,0.84375000f,-0.50000000f,0.65625000f,-0.26562500f,0.37500000f,0.42187500f,-0.53125000f,0.60937500f,0.64062500f,0.85937500f,0.18750000f,0.87500000f,-0.76562500f,-0.67187500f,0.51562500f,0.75000000f,-0.78125000f,0.04687500f,-0.50000000f,0.56250000f,0.42187500f,0.48437500f,-0.81250000f,-0.45312500f,-0.51562500f,-0.35937500f,-0.70312500f,0.04687500f,0.73437500f,0.71875000f,-0.54687500f,-0.98437500f,-0.25000000f,0.35937500f,0.00000000f,0.43750000f,0.00000000f,-0.01562500f,-0.12500000f,0.73437500f,-0.93750000f,0.71875000f,0.59375000f,-1.00000000f,-0.75000000f,0.26562500f,0.28125000f,-0.87500000f,0.18750000f,0.75000000f,0.40625000f,-0.67187500f,-0.31250000f,-0.46875000f,-0.59375000f,-0.42187500f,-0.35937500f,0.84375000f,-0.28125000f,0.34375000f,-0.45312500f,0.48437500f,-0.57812500f,-0.79687500f,-0.82812500f,0.92187500f,-0.56250000f,0.25000000f,-0.48437500f,0.96875000f,0.50000000f,0.56250000f,-0.57812500f,-0.78125000f,0.65625000f,-0.75000000f,-0.51562500f,0.79687500f,-0.60937500f,0.10937500f,-0.32812500f,0.10937500f,-0.71875000f,0.21875000f,0.67187500f,-0.50000000f,-0.28125000f,0.90625000f,0.57812500f,-0.81250000f,-0.68750000f,-0.75000000f,-0.29687500f,0.18750000f,-0.81250000f,-0.45312500f,-0.87500000f,0.85937500f,0.73437500f,-0.42187500f,-0.92187500f,0.50000000f,-0.59375000f,0.07812500f,-0.29687500f,0.65625000f,-0.23437500f,0.98437500f,-0.26562500f,0.62500000f,-0.43750000f,-0.85937500f,0.70312500f,0.07812500f,-0.31250000f,0.51562500f,-0.23437500f,0.82812500f,-0.65625000f,0.46875000f,0.67187500f,0.31250000f,-0.29687500f,-0.17187500f,-0.79687500f,-0.70312500f,0.65625000f,0.68750000f,0.96875000f,0.04687500f,-0.03125000f,0.79687500f,0.82812500f,0.98437500f,-0.67187500f,-0.54687500f,-0.51562500f,-0.67187500f,-0.78125000f,-0.93750000f,0.46875000f,0.46875000f,-0.29687500f,-0.96875000f,-0.84375000f,-0.98437500f,-0.57812500f,-0.85937500f,-0.68750000f,-0.84375000f,0.43750000f,0.46875000f,-0.50000000f,-0.98437500f,0.34375000f,-0.01562500f,-0.93750000f,-0.51562500f,-0.17187500f,0.10937500f,0.32812500f,-0.96875000f,-0.07812500f,0.56250000f,0.87500000f,-0.01562500f,-0.25000000f,-0.59375000f,-0.20312500f,0.23437500f,0.09375000f,0.75000000f,-0.68750000f,-0.42187500f,-1.00000000f,0.79687500f,0.25000000f,0.31250000f,0.01562500f,-0.93750000f,0.40625000f,-0.20312500f,-0.93750000f,-0.75000000f,-0.82812500f,-0.75000000f,-0.21875000f,0.17187500f,-0.85937500f,-0.64062500f,-0.09375000f,0.35937500f,0.06250000f,-0.84375000f,0.01562500f,0.21875000f,0.81250000f,-0.60937500f,-0.67187500f,-0.93750000f,0.71875000f,0.07812500f,0.01562500f,0.53125000f,0.18750000f,-0.98437500f,-0.07812500f,0.17187500f,0.90625000f,-0.21875000f,-0.15625000f,-0.70312500f,-0.89062500f,-0.67187500f,0.85937500f,-0.82812500f,0.29687500f,0.73437500f,-0.51562500f,0.87500000f,0.53125000f,0.68750000f,0.60937500f,-0.96875000f,-0.50000000f,0.56250000f,-0.82812500f,0.31250000f,-0.48437500f,0.93750000f,0.12500000f,0.03125000f,0.28125000f,-0.60937500f,-0.20312500f,0.26562500f,-0.50000000f,0.06250000f,0.40625000f,-0.53125000f,0.29687500f,0.92187500f,0.60937500f,-0.75000000f,-0.64062500f,-0.26562500f,0.45312500f,0.03125000f,-0.29687500f,0.34375000f,-0.07812500f,-0.68750000f,0.60937500f,-0.73437500f,-0.45312500f,0.89062500f,-0.39062500f,-0.70312500f,-0.90625000f,-0.92187500f,-0.87500000f,0.39062500f,0.73437500f,0.01562500f,-0.07812500f,-0.51562500f,0.79687500f,0.32812500f,0.20312500f,-0.95312500f,-0.26562500f,-0.31250000f,1.00000000f,-0.93750000f,-0.32812500f,-0.26562500f,0.51562500f,0.76562500f,-0.65625000f,0.51562500f,0.06250000f,-0.54687500f,-0.12500000f,0.57812500f,0.82812500f,-0.67187500f,0.39062500f,0.32812500f,0.28125000f,0.96875000f,0.45312500f,0.59375000f,-0.35937500f,-0.37500000f,0.12500000f,0.76562500f,0.43750000f,0.89062500f,-0.25000000f,0.84375000f,-0.89062500f,-0.03125000f,0.57812500f,-0.67187500f,-0.21875000f,0.23437500f,-0.25000000f,0.39062500f,-0.79687500f,-0.17187500f,-0.92187500f,-0.65625000f,0.73437500f,-0.70312500f,-0.65625000f,-0.25000000f,-0.70312500f,0.64062500f,0.31250000f,0.87500000f,-0.93750000f,0.21875000f,0.57812500f,0.39062500f,0.93750000f,0.40625000f,0.87500000f,-0.18750000f,-0.23437500f,0.96875000f,-0.79687500f,0.39062500f,-0.85937500f,-0.79687500f,-0.40625000f,-0.92187500f,-0.12500000f,0.76562500f,0.09375000f,-0.40625000f,-0.84375000f,-0.95312500f,-0.71875000f,-0.17187500f,-0.62500000f,-0.78125000f,0.10937500f,-0.45312500f,-0.65625000f,-0.59375000f,0.98437500f,0.73437500f,0.85937500f,-0.87500000f,-0.67187500f,-0.98437500f,-0.17187500f,0.95312500f,-0.81250000f,0.84375000f,-0.90625000f,0.92187500f,-0.85937500f,-0.82812500f,0.54687500f,0.21875000f,0.09375000f,-0.15625000f,0.45312500f,0.28125000f,-0.96875000f,0.45312500f,0.62500000f,0.56250000f,-0.31250000f,-0.31250000f,0.57812500f,0.14062500f,0.34375000f,0.09375000f,-0.21875000f,0.57812500f,-0.82812500f,0.96875000f,-0.75000000f,0.60937500f,-0.92187500f,-0.07812500f,0.89062500f,0.43750000f,0.23437500f,0.15625000f,0.12500000f,-0.78125000f,-0.46875000f,0.03125000f,0.62500000f,0.53125000f,-0.85937500f,-0.78125000f,0.60937500f,0.15625000f,0.68750000f,0.87500000f,0.93750000f,0.53125000f,-0.93750000f,-0.48437500f,-0.23437500f,-0.45312500f,0.39062500f,0.10937500f,-0.14062500f,0.93750000f,0.64062500f,0.95312500f,0.96875000f,0.73437500f,-0.12500000f,0.75000000f,-0.64062500f,0.04687500f,-0.51562500f,-0.39062500f,-0.10937500f,0.62500000f,0.85937500f,0.46875000f,0.04687500f,0.42187500f,-0.96875000f,0.71875000f,-0.85937500f,-0.45312500f,0.46875000f,0.07812500f,-0.56250000f,-0.64062500f,-0.68750000f,0.04687500f,0.25000000f,-0.64062500f,-0.23437500f,0.03125000f,-0.45312500f,0.12500000f,0.93750000f,-0.35937500f,0.23437500f,0.96875000f,0.48437500f,0.56250000f,0.09375000f,-0.57812500f,-0.42187500f,0.53125000f,-0.25000000f,-0.87500000f,-0.54687500f,0.64062500f,0.00000000f,0.03125000f,0.10937500f,-0.67187500f,-0.32812500f,-0.10937500f,-0.59375000f,0.87500000f,-0.43750000f,0.96875000f,0.48437500f,0.59375000f,-0.18750000f,-0.85937500f,0.89062500f,-0.20312500f,0.07812500f,-0.98437500f,0.01562500f,0.18750000f,0.39062500f,0.96875000f,0.15625000f,-0.82812500f,0.93750000f,0.17187500f,0.39062500f,-0.40625000f,0.89062500f,-0.59375000f,0.40625000f,0.78125000f,-0.10937500f,0.79687500f,0.56250000f,-0.28125000f,-0.48437500f,-0.82812500f,-0.70312500f,0.34375000f,0.57812500f,0.00000000f,0.28125000f,0.70312500f,0.39062500f,-0.29687500f,-0.25000000f,-0.90625000f,-0.32812500f,-0.85937500f,0.37500000f,0.93750000f,-0.20312500f,-0.48437500f,0.92187500f,0.79687500f,-0.29687500f,0.06250000f,-0.31250000f,0.34375000f,0.67187500f,0.57812500f,0.25000000f,-0.56250000f,0.92187500f,-0.26562500f,-0.71875000f,0.68750000f,0.65625000f,0.46875000f,0.09375000f,0.39062500f,-0.39062500f,0.75000000f,0.70312500f,-0.89062500f,-0.56250000f,0.40625000f,0.95312500f,0.10937500f,-0.26562500f,-0.73437500f,0.20312500f,0.06250000f,-0.68750000f,-0.60937500f,-0.71875000f,0.40625000f,0.75000000f,-0.46875000f,0.57812500f,-0.29687500f,0.37500000f,0.51562500f,-0.73437500f,0.90625000f,0.75000000f,-0.64062500f,0.71875000f,0.62500000f,0.70312500f,0.32812500f,0.81250000f,0.57812500f,0.71875000f,-0.67187500f,-0.56250000f,-0.07812500f,-1.00000000f,-0.48437500f,0.32812500f,0.98437500f,0.98437500f,-0.98437500f,-0.56250000f,0.68750000f,-0.95312500f,-0.37500000f,0.82812500f,0.67187500f,0.28125000f,0.51562500f,0.46875000f,-0.56250000f,-0.32812500f,-0.56250000f,-0.31250000f,-0.29687500f,0.18750000f,-0.17187500f,1.00000000f,0.96875000f,0.50000000f,-0.68750000f,0.75000000f,-0.39062500f,-0.28125000f,-0.90625000f,0.40625000f,0.96875000f,-0.03125000f,0.32812500f,0.67187500f,-0.60937500f,-0.25000000f,-0.57812500f,0.06250000f,0.56250000f,0.76562500f,-0.65625000f,-0.45312500f,0.54687500f,-0.92187500f,-0.39062500f,0.15625000f,0.71875000f,-0.29687500f,0.67187500f,-0.03125000f,0.40625000f,-0.79687500f,-0.90625000f,0.59375000f,0.39062500f,-0.25000000f,-0.04687500f,-0.07812500f,-0.06250000f,0.04687500f,0.59375000f,0.98437500f,0.59375000f,0.48437500f,-0.43750000f,0.03125000f,0.25000000f,0.96875000f,-0.07812500f,0.56250000f,-0.03125000f,0.20312500f,0.87500000f,-0.26562500f,-0.48437500f,-0.42187500f,0.39062500f,-0.10937500f,-0.81250000f,-0.31250000f,-0.18750000f,0.73437500f,-0.75000000f,-0.40625000f,0.56250000f,-0.90625000f,0.68750000f,0.31250000f,0.48437500f,0.23437500f,0.65625000f,-0.50000000f,0.76562500f,0.42187500f,0.37500000f,0.57812500f,0.60937500f,-0.46875000f,0.28125000f,0.85937500f,0.34375000f,0.65625000f,0.82812500f,-0.54687500f,-0.92187500f,-0.89062500f,-0.28125000f,-0.98437500f,-0.54687500f,-0.37500000f,-0.06250000f,0.48437500f,0.60937500f,-0.95312500f,0.32812500f,0.45312500f,0.50000000f,-0.42187500f,-0.98437500f,0.81250000f,-0.59375000f,0.73437500f,0.92187500f,-0.60937500f,-0.65625000f,0.46875000f,-1.00000000f,-0.68750000f,0.48437500f,0.07812500f,-0.06250000f,-0.32812500f,-0.18750000f,-0.53125000f,0.18750000f,0.12500000f,0.07812500f,-0.48437500f,-0.93750000f,-0.31250000f,-0.95312500f,-0.42187500f,0.62500000f,0.35937500f,-0.81250000f,-0.53125000f,0.37500000f,0.03125000f,0.26562500f,0.31250000f,-0.50000000f,-0.45312500f,-0.40625000f,0.93750000f,0.29687500f,0.03125000f,0.31250000f,-0.85937500f,-0.03125000f,-0.10937500f,0.98437500f,0.53125000f,-0.04687500f,-0.60937500f,0.93750000f,-0.31250000f,0.71875000f,0.12500000f,0.37500000f,-0.28125000f,-0.89062500f,0.31250000f,0.59375000f,-0.62500000f,0.96875000f,-0.46875000f,-0.48437500f,0.29687500f,0.29687500f,0.82812500f,-0.62500000f,-0.25000000f,0.68750000f,-0.51562500f,0.68750000f,-0.15625000f,-0.39062500f,0.20312500f,0.78125000f,0.18750000f,-0.87500000f,-0.23437500f,0.75000000f,0.70312500f,0.25000000f,-0.09375000f,0.35937500f,0.68750000f,-0.01562500f,0.21875000f,0.90625000f,-0.75000000f,-0.43750000f,-0.51562500f,-0.04687500f,-0.79687500f,-0.12500000f,-0.01562500f,0.18750000f,-0.56250000f,-0.87500000f,-0.10937500f,0.82812500f,-0.29687500f,-0.06250000f,0.70312500f,0.70312500f,-1.00000000f,0.68750000f,-0.18750000f,-0.56250000f,0.46875000f,0.67187500f,0.45312500f,-0.07812500f,0.62500000f,-0.87500000f,0.14062500f,0.92187500f,-0.71875000f,0.84375000f,0.25000000f,0.04687500f,-0.26562500f,0.00000000f,-0.78125000f,0.95312500f,-0.09375000f,0.78125000f,0.51562500f,-0.84375000f,-0.06250000f,0.39062500f,-0.12500000f,-0.39062500f,-0.85937500f,-0.34375000f,-0.21875000f,-0.29687500f,0.73437500f,0.06250000f,-0.81250000f,-0.81250000f,0.90625000f,0.82812500f,0.59375000f,-0.25000000f,0.65625000f,0.35937500f,-0.35937500f,-0.90625000f,-0.76562500f,-0.25000000f,-0.93750000f,0.34375000f,-0.95312500f,-0.78125000f,-0.54687500f,0.17187500f,0.26562500f,-0.53125000f,0.64062500f,0.04687500f,0.23437500f,-0.14062500f,-0.01562500f,0.25000000f,-0.95312500f,-0.34375000f,0.81250000f,0.75000000f,-0.90625000f,0.10937500f,-0.32812500f,0.70312500f,0.09375000f,0.95312500f,-0.85937500f,-0.20312500f,-0.43750000f,-0.68750000f,0.39062500f,-0.87500000f,0.56250000f,-0.45312500f,0.18750000f,0.42187500f,0.43750000f,0.28125000f,-0.37500000f,0.35937500f,-0.59375000f,0.51562500f,-0.28125000f,-0.73437500f,0.39062500f,0.98437500f,0.57812500f,0.50000000f,-0.81250000f,-0.73437500f,-0.85937500f,-0.48437500f,-0.35937500f,0.20312500f,-0.37500000f,-0.20312500f,0.70312500f,-0.67187500f,-0.04687500f,-0.09375000f,0.40625000f,-0.85937500f,0.98437500f,-0.26562500f,0.60937500f,-0.85937500f,0.93750000f,0.00000000f,-0.70312500f,0.95312500f,0.79687500f,0.10937500f,0.76562500f,0.54687500f,0.39062500f,0.46875000f,0.70312500f,0.32812500f,-0.46875000f,0.62500000f,-0.34375000f,0.82812500f,0.37500000f,-0.09375000f,0.46875000f,0.71875000f,-0.57812500f,0.39062500f,-0.46875000f,-0.81250000f,-0.03125000f,-0.64062500f,-0.20312500f,0.85937500f,0.20312500f,0.21875000f,-0.79687500f,1.00000000f,-0.25000000f,0.62500000f,-0.82812500f,-0.40625000f,0.42187500f,-0.35937500f,0.73437500f,-0.75000000f,0.71875000f,-0.76562500f,-0.56250000f,0.01562500f,-0.59375000f,0.43750000f,-0.17187500f,-0.46875000f,0.59375000f,1.00000000f,0.07812500f,0.40625000f,-0.40625000f,0.42187500f,0.43750000f,-0.57812500f,-0.06250000f,0.70312500f,-0.75000000f,-0.45312500f,-0.18750000f,-0.62500000f,0.29687500f,0.50000000f,0.32812500f,0.31250000f,0.65625000f,-0.54687500f,-0.78125000f,1.00000000f,0.54687500f,-0.20312500f,-0.96875000f,0.67187500f,-0.42187500f,-0.54687500f,1.00000000f,0.62500000f,-0.35937500f,0.75000000f,-0.50000000f,0.07812500f,-0.50000000f,0.23437500f,-0.76562500f,-0.89062500f,-0.56250000f,-0.20312500f,0.57812500f,0.81250000f,-0.31250000f,0.04687500f,-0.73437500f,-0.53125000f,-0.31250000f,-0.92187500f,-0.37500000f,0.84375000f,0.84375000f,-0.92187500f,0.64062500f,0.00000000f,0.93750000f,-0.67187500f,0.04687500f,0.81250000f,-0.35937500f,-0.56250000f,0.42187500f,0.54687500f,-0.28125000f,-0.85937500f,0.65625000f,0.81250000f,-0.82812500f,-0.65625000f,0.48437500f,0.78125000f,-0.35937500f,-0.81250000f,0.71875000f,0.79687500f,0.25000000f,0.31250000f,-0.87500000f,0.50000000f,0.95312500f,0.62500000f,0.85937500f,-0.10937500f,-0.76562500f,-0.04687500f,-0.26562500f,-0.23437500f,0.25000000f,-0.32812500f,0.82812500f,-0.31250000f,-0.56250000f,-0.25000000f,0.04687500f,-0.70312500f,0.48437500f,-0.09375000f,-0.48437500f,-0.87500000f,-0.15625000f,-0.10937500f,-0.48437500f,0.64062500f,-0.54687500f,0.68750000f,-0.82812500f,0.89062500f,0.43750000f,0.29687500f,0.29687500f,0.50000000f,-0.93750000f,-0.98437500f,0.79687500f,-0.34375000f,0.56250000f,-0.28125000f,0.85937500f,-0.87500000f,-0.51562500f,-0.78125000f,-0.39062500f,0.90625000f,0.78125000f,-0.67187500f,0.28125000f,-0.51562500f,0.35937500f,-0.59375000f,0.65625000f,0.93750000f,0.09375000f,0.01562500f,-0.67187500f,-0.03125000f,-0.96875000f,-1.00000000f,0.95312500f,0.37500000f,0.96875000f,0.15625000f,-0.82812500f,0.17187500f,0.15625000f,-0.51562500f,-0.54687500f,0.17187500f,0.17187500f,-0.20312500f,0.76562500f,0.06250000f,-0.54687500f,0.76562500f,-0.06250000f,0.95312500f,0.20312500f,-0.93750000f,-0.15625000f,0.51562500f,-0.87500000f,-0.54687500f,-0.82812500f,-0.71875000f,-0.37500000f,0.48437500f,0.64062500f,0.71875000f,0.65625000f,-0.64062500f,-0.67187500f,0.26562500f,0.29687500f,0.25000000f,-0.57812500f,0.62500000f,0.04687500f,0.53125000f,-0.50000000f,0.26562500f,-0.95312500f,-0.23437500f,0.23437500f,-0.84375000f,-0.29687500f,-0.15625000f,-0.34375000f,-0.79687500f,0.06250000f,-0.92187500f,-0.34375000f,0.62500000f,-0.93750000f,0.79687500f,0.96875000f,-0.31250000f,0.53125000f,-0.89062500f,-0.01562500f,0.42187500f,0.57812500f,-0.62500000f,-0.21875000f,-0.79687500f,0.60937500f,0.98437500f,0.28125000f,-0.09375000f,0.51562500f,0.70312500f,-0.31250000f,0.34375000f,0.64062500f,-0.85937500f,0.06250000f,0.70312500f,0.60937500f,-0.28125000f,0.48437500f,0.60937500f,0.18750000f,0.25000000f,0.54687500f,0.54687500f,-0.06250000f,0.90625000f,0.93750000f,-0.73437500f,0.62500000f,0.59375000f,0.01562500f,-0.48437500f,0.87500000f,0.23437500f,-0.10937500f,0.26562500f,0.00000000f,-0.17187500f,-0.85937500f,0.59375000f,-0.64062500f,0.78125000f,-0.21875000f,0.75000000f,-0.84375000f,-0.23437500f,0.21875000f,0.54687500f,0.17187500f,-0.46875000f,0.34375000f,-0.82812500f,0.45312500f,-0.42187500f,0.93750000f,0.70312500f,0.35937500f,0.09375000f,0.10937500f,0.35937500f,0.46875000f,0.06250000f,0.03125000f,-0.60937500f,-0.29687500f,-0.15625000f,-0.79687500f,-0.85937500f,-0.85937500f,-0.29687500f,-0.75000000f,0.50000000f,0.76562500f,-0.54687500f,-0.46875000f,-0.81250000f,0.26562500f,-0.03125000f,-0.03125000f,-0.31250000f,0.96875000f,0.62500000f,0.57812500f,0.20312500f,0.35937500f,0.93750000f,-0.56250000f,-0.81250000f,0.98437500f,0.43750000f,0.64062500f,-0.06250000f,1.00000000f,0.64062500f,0.62500000f,-0.67187500f,0.73437500f,0.37500000f,0.75000000f,-0.29687500f,0.90625000f,0.26562500f,-0.39062500f,0.00000000f,0.73437500f,0.53125000f,0.87500000f,-0.21875000f,0.14062500f,0.23437500f,-0.53125000f,0.09375000f,-0.07812500f,-0.14062500f,-0.67187500f,0.28125000f,0.10937500f,0.37500000f,0.64062500f,-0.14062500f,0.21875000f,0.09375000f,-1.00000000f,0.42187500f,0.18750000f,-0.20312500f,-0.54687500f,0.14062500f,0.35937500f,0.98437500f,0.31250000f,0.25000000f,0.81250000f,-0.82812500f,0.39062500f,1.00000000f,0.06250000f,0.62500000f,-0.15625000f,-0.17187500f,-0.29687500f,0.60937500f,0.12500000f,0.06250000f,-0.85937500f,0.12500000f,-0.48437500f,-0.28125000f,-0.46875000f,0.67187500f,0.93750000f,1.00000000f,0.89062500f,0.01562500f,-0.65625000f,0.90625000f,0.78125000f,-0.92187500f,-0.82812500f,-0.25000000f,-0.28125000f,-0.35937500f,-0.31250000f,0.82812500f,0.71875000f,0.28125000f,0.89062500f,-0.90625000f,-0.46875000f,-0.04687500f,0.57812500f,-0.10937500f,-0.90625000f,0.32812500f,-0.73437500f,-0.76562500f,0.29687500f,-0.95312500f,0.89062500f,-0.28125000f,0.45312500f,0.89062500f,-0.85937500f,0.09375000f,0.20312500f,-0.67187500f,0.09375000f,0.98437500f,-0.43750000f,-1.00000000f,-0.64062500f,0.87500000f,0.75000000f,-0.32812500f,0.43750000f,-0.32812500f,-0.89062500f,-0.09375000f,-0.51562500f,-0.50000000f,0.98437500f,0.95312500f,0.17187500f,0.53125000f,0.12500000f,0.32812500f,0.29687500f,0.54687500f,-0.17187500f,-0.29687500f,0.50000000f,0.85937500f,0.20312500f,0.96875000f,0.23437500f,-0.98437500f,-0.28125000f,0.04687500f,0.34375000f,-0.53125000f,0.10937500f,-0.17187500f,-0.71875000f,0.31250000f,-0.45312500f,-0.78125000f,-0.73437500f,0.43750000f,-0.40625000f,0.70312500f,-0.56250000f,0.67187500f,-0.40625000f,-0.23437500f,0.54687500f,0.96875000f,0.42187500f,0.57812500f,0.42187500f,-0.53125000f,0.14062500f,0.59375000f,0.35937500f,0.90625000f,0.12500000f,0.03125000f,-0.43750000f,0.68750000f,-0.78125000f,0.75000000f,0.56250000f,-0.25000000f,-0.01562500f,-0.07812500f,0.18750000f,0.76562500f,0.90625000f,0.04687500f,0.73437500f,-0.60937500f,0.59375000f,-0.73437500f,-0.82812500f,-0.46875000f,0.20312500f,-0.79687500f,0.12500000f,0.46875000f,-0.21875000f,-0.75000000f,-0.06250000f,0.43750000f,0.43750000f,0.73437500f,0.26562500f,0.65625000f,0.20312500f,-0.70312500f,0.00000000f,-0.57812500f,0.12500000f,-0.67187500f,-0.20312500f,0.18750000f,0.84375000f,0.28125000f,-0.87500000f,-0.20312500f,-0.35937500f,-0.82812500f,0.40625000f,-0.76562500f,0.32812500f,0.98437500f,0.90625000f,0.48437500f,0.43750000f,0.10937500f,-0.40625000f,0.39062500f,0.43750000f,-1.00000000f,-0.06250000f,0.62500000f,0.96875000f,-0.48437500f,0.96875000f,0.87500000f,0.64062500f,0.17187500f,0.53125000f,-0.95312500f,0.84375000f,-1.00000000f,-0.57812500f,-0.23437500f,-0.51562500f,-0.04687500f,0.81250000f,-0.37500000f,-1.00000000f,0.96875000f,0.35937500f,0.79687500f,-0.06250000f,-0.03125000f,-0.50000000f,-0.67187500f,0.32812500f,-0.31250000f,0.82812500f,-0.12500000f,-0.25000000f,0.25000000f,0.48437500f,-0.35937500f,-0.17187500f,-0.06250000f,0.04687500f,0.46875000f,0.37500000f,0.89062500f,-0.03125000f,0.50000000f,-0.96875000f,-0.32812500f,0.06250000f,0.14062500f,0.01562500f,-0.82812500f,-0.25000000f,0.54687500f,-0.14062500f,0.73437500f,0.90625000f,-0.84375000f,-0.79687500f,-0.15625000f,0.57812500f,-0.93750000f,0.48437500f,0.64062500f,-0.01562500f,0.75000000f,0.93750000f,0.87500000f,0.67187500f,0.00000000f,-0.29687500f,-0.42187500f,-0.84375000f,-0.50000000f,-0.93750000f,-0.12500000f,-0.40625000f,0.98437500f,-0.43750000f,0.87500000f,0.00000000f,0.31250000f,0.10937500f,-0.35937500f,0.45312500f,0.32812500f,-0.32812500f,0.12500000f,-0.35937500f,-0.45312500f,-0.79687500f,0.96875000f,-0.04687500f,0.29687500f,-0.73437500f,-0.70312500f,-0.28125000f,-0.79687500f,-0.64062500f,-0.90625000f,-0.17187500f,-0.25000000f,-0.03125000f,-0.50000000f,0.43750000f,0.85937500f,-0.98437500f,0.59375000f,0.29687500f,0.40625000f,-0.62500000f,0.28125000f,0.84375000f,-0.01562500f,0.95312500f,-0.14062500f,-0.32812500f,0.04687500f,-0.25000000f,0.56250000f,-0.28125000f,0.48437500f,0.07812500f,0.57812500f,0.67187500f,0.31250000f,0.71875000f,0.59375000f,0.17187500f,-0.39062500f,-0.01562500f,0.46875000f,-0.28125000f,-0.40625000f,-0.89062500f,0.20312500f,0.45312500f,0.89062500f,-0.68750000f,0.54687500f,-0.06250000f,0.82812500f,-0.70312500f,0.03125000f,-0.71875000f,0.14062500f,0.75000000f,-0.95312500f,0.03125000f,0.06250000f,-0.93750000f,0.93750000f,-0.15625000f,0.43750000f,-0.25000000f,0.48437500f,0.40625000f,0.00000000f,0.01562500f,0.98437500f,0.82812500f,0.62500000f,-0.60937500f,0.64062500f,0.26562500f,0.73437500f,0.45312500f,0.28125000f,-0.34375000f,0.09375000f,-0.95312500f,-0.18750000f,0.32812500f,-0.21875000f,0.25000000f,0.07812500f,-0.93750000f,0.57812500f,-0.07812500f,0.95312500f,-0.51562500f,0.89062500f,0.32812500f,0.48437500f,0.48437500f,-0.35937500f,-1.00000000f,-0.39062500f,0.82812500f,0.23437500f,0.85937500f,-0.07812500f,0.89062500f,-0.37500000f,-0.25000000f,0.53125000f,-0.20312500f,0.98437500f,-0.06250000f,0.54687500f,0.51562500f,-0.89062500f,0.10937500f,-0.07812500f,0.92187500f,0.51562500f,0.51562500f,-0.18750000f,0.60937500f,-0.71875000f,-0.20312500f,-0.84375000f,-0.71875000f,-0.39062500f,-0.90625000f,0.70312500f,-0.67187500f,-0.64062500f,-0.82812500f,0.67187500f,0.37500000f,0.45312500f,0.21875000f,0.89062500f,0.98437500f,-0.43750000f,0.50000000f,0.29687500f,0.90625000f,-0.26562500f,0.07812500f,0.12500000f,0.70312500f,0.64062500f,0.78125000f,0.89062500f,-0.25000000f,0.17187500f,-0.90625000f,0.04687500f,0.65625000f,-0.04687500f,-0.15625000f,0.75000000f,0.65625000f,-0.54687500f,-0.20312500f,0.21875000f,-0.35937500f,-0.50000000f,0.60937500f,-0.10937500f,0.35937500f,-0.95312500f,-0.25000000f,-0.64062500f,0.95312500f,-0.59375000f,0.68750000f,0.18750000f,0.60937500f,0.84375000f,-0.93750000f,0.42187500f,0.31250000f,0.18750000f,-0.54687500f,-0.56250000f,0.09375000f,0.28125000f,0.03125000f,-0.18750000f,-0.67187500f,0.62500000f,-0.07812500f,-0.09375000f,-0.76562500f,-0.76562500f,-0.64062500f,-0.01562500f,0.09375000f,0.75000000f,-0.75000000f,-0.51562500f,0.90625000f,0.03125000f,0.84375000f,0.25000000f,0.93750000f,0.23437500f,-0.15625000f,0.87500000f,-0.40625000f,-0.43750000f,0.65625000f,0.54687500f,0.79687500f,0.21875000f,0.21875000f,-0.71875000f,-0.96875000f,0.71875000f,0.68750000f,-0.04687500f,-0.15625000f,0.34375000f,0.32812500f,0.29687500f,-0.45312500f,-0.21875000f,0.73437500f,0.79687500f,-0.42187500f,0.54687500f,-0.12500000f,-0.56250000f,-0.84375000f,0.81250000f,0.32812500f,-0.03125000f,0.09375000f,-0.51562500f,0.60937500f,0.07812500f,-0.87500000f,-0.29687500f,-0.31250000f,0.40625000f,-0.90625000f,0.93750000f,-0.39062500f,-0.68750000f,-0.04687500f,-0.07812500f,-0.96875000f,0.43750000f,0.21875000f,0.79687500f,-0.62500000f,0.96875000f,-0.89062500f,0.95312500f,0.96875000f,-0.56250000f,0.50000000f,0.87500000f,-0.75000000f,0.45312500f,0.73437500f,-0.42187500f,0.43750000f,0.45312500f,0.35937500f,0.09375000f,-0.48437500f,-0.53125000f,-0.92187500f,-1.00000000f,-0.23437500f,0.34375000f,-0.28125000f,-0.43750000f,0.32812500f,0.62500000f,-0.57812500f,-0.89062500f,0.45312500f,-0.51562500f,-0.67187500f,0.42187500f,-0.64062500f,-0.09375000f,0.87500000f,-0.82812500f,0.46875000f,0.23437500f,0.06250000f,0.56250000f,-0.89062500f,0.18750000f,-0.79687500f,0.87500000f,-0.01562500f,0.68750000f,-0.62500000f,0.48437500f,0.89062500f,-0.35937500f,-0.42187500f,-0.25000000f,-1.00000000f,-0.85937500f,-0.53125000f,0.71875000f,0.98437500f,0.18750000f,0.39062500f,-0.79687500f,-0.31250000f,-0.90625000f,-0.03125000f,0.79687500f,0.42187500f,-0.18750000f,-0.78125000f,0.95312500f,0.79687500f,-0.37500000f,-0.48437500f,0.25000000f,0.53125000f,-0.51562500f,-0.09375000f,0.29687500f,0.64062500f,0.07812500f,0.46875000f,-0.46875000f,0.87500000f,0.29687500f,0.06250000f,0.00000000f,-0.29687500f,-0.40625000f,-0.70312500f,0.20312500f,-0.43750000f,-0.43750000f,0.98437500f,0.62500000f,0.98437500f,-0.01562500f,0.26562500f,0.28125000f,0.84375000f,0.70312500f,-0.98437500f,0.34375000f,-0.79687500f,0.53125000f,-0.29687500f,-0.18750000f,-0.57812500f,0.23437500f,-1.00000000f,-0.96875000f,-0.82812500f,0.32812500f,0.67187500f,-0.90625000f,0.18750000f,-0.68750000f,-0.57812500f,0.09375000f,-0.29687500f,0.35937500f,0.60937500f,0.56250000f,-0.10937500f,0.00000000f,0.76562500f,-0.31250000f,-0.95312500f,-0.76562500f,0.03125000f,-0.51562500f,-0.14062500f,0.84375000f,-0.92187500f,0.40625000f,-0.14062500f,-0.25000000f,0.56250000f,-0.92187500f,-0.76562500f,0.40625000f,-0.15625000f,0.12500000f,-0.31250000f,0.53125000f,0.26562500f,-0.25000000f,0.67187500f,-0.78125000f,-0.73437500f,0.34375000f,-0.04687500f,0.53125000f,-0.51562500f,0.23437500f,0.48437500f,-0.10937500f,0.56250000f,0.78125000f,0.26562500f,-0.09375000f,-0.18750000f,-0.96875000f,0.82812500f,-0.21875000f,-0.31250000f,-0.29687500f,-0.93750000f,-0.40625000f,0.23437500f,-0.23437500f,-0.56250000f,0.90625000f,-0.78125000f,0.76562500f,-0.67187500f,0.43750000f,0.95312500f,0.43750000f,-0.85937500f,0.48437500f,-0.43750000f,0.62500000f,0.56250000f,-0.03125000f,-0.25000000f,0.62500000f,0.10937500f,0.82812500f,1.00000000f,-0.62500000f,-0.03125000f,-0.96875000f,0.65625000f,0.28125000f,-0.62500000f,0.67187500f,-0.04687500f,0.95312500f,0.25000000f,0.01562500f,0.62500000f,-0.12500000f,0.57812500f,0.68750000f,-0.64062500f,0.84375000f,0.75000000f,-0.62500000f,0.95312500f,0.01562500f,-0.96875000f,-1.00000000f,1.00000000f,-0.48437500f,0.57812500f,-0.92187500f,0.82812500f,0.01562500f,-0.28125000f,-0.98437500f,-0.07812500f,-0.15625000f,0.50000000f,0.51562500f,0.57812500f,-0.65625000f,0.62500000f,-0.43750000f,0.48437500f,-0.26562500f,-0.81250000f,0.32812500f,-0.46875000f,-0.04687500f,0.65625000f,-0.98437500f,-0.95312500f,-0.50000000f,-0.35937500f,-0.09375000f,0.06250000f,-0.78125000f,0.00000000f,0.65625000f,-0.98437500f,-0.96875000f,0.76562500f,-0.62500000f,0.84375000f,0.62500000f,-0.92187500f,0.79687500f,-0.79687500f,0.09375000f,0.60937500f,-0.28125000f,-0.14062500f,-0.12500000f,-0.70312500f,-0.84375000f,-0.35937500f,-0.79687500f,0.92187500f,0.18750000f,0.29687500f,0.98437500f,-0.68750000f,0.76562500f,-0.67187500f,-0.09375000f,-0.59375000f,0.92187500f,0.59375000f,-0.64062500f,0.32812500f,-0.29687500f,-0.45312500f,0.82812500f,-0.43750000f,-0.25000000f,-0.95312500f,0.54687500f,0.87500000f,-0.34375000f,0.70312500f,0.32812500f,-0.71875000f,0.21875000f,-0.76562500f,0.79687500f,-0.07812500f,-0.96875000f,0.14062500f,-0.06250000f,0.37500000f,0.46875000f,-0.92187500f,-0.79687500f,-0.71875000f,0.67187500f,-0.12500000f,-0.57812500f,-0.70312500f,-0.79687500f,0.39062500f,-0.20312500f,0.73437500f,0.28125000f,0.50000000f,0.34375000f,0.26562500f,-0.35937500f,-0.01562500f,-0.57812500f,-0.71875000f,0.31250000f,0.17187500f,-0.10937500f,0.07812500f,0.92187500f,-0.40625000f,-0.10937500f,-0.59375000f,-0.35937500f,0.45312500f,-1.00000000f,0.31250000f,-0.68750000f,0.12500000f,-0.18750000f,0.60937500f,-0.18750000f,-0.20312500f,0.60937500f,0.62500000f,0.32812500f,0.21875000f,-0.39062500f,-0.93750000f,0.56250000f,-0.93750000f,0.06250000f,0.65625000f,0.37500000f,-0.31250000f,-0.50000000f,0.40625000f,0.07812500f,-0.20312500f,0.48437500f,0.04687500f,-0.92187500f,-0.68750000f,0.10937500f,-0.37500000f,-0.73437500f,-0.82812500f,0.35937500f,-0.79687500f,-0.48437500f,-0.75000000f,0.93750000f,-0.06250000f,-0.64062500f,0.39062500f,0.62500000f,-0.21875000f,0.90625000f,0.50000000f,0.50000000f,0.93750000f,-0.20312500f,0.17187500f,0.79687500f,-0.65625000f,0.21875000f,-0.98437500f,-0.71875000f,-0.21875000f,-0.65625000f,-0.39062500f,0.04687500f,0.64062500f,0.96875000f,-0.78125000f,-0.95312500f,0.57812500f,0.37500000f,0.76562500f,-0.89062500f,-0.96875000f,-0.21875000f,-0.03125000f,-0.12500000f,-0.89062500f,0.15625000f,0.29687500f,-0.79687500f,-0.32812500f,-0.04687500f,-1.00000000f,0.87500000f,-0.79687500f,0.82812500f,-0.03125000f,-0.79687500f,-0.06250000f,0.75000000f,0.06250000f,0.59375000f,0.70312500f,-0.81250000f,-0.32812500f,0.60937500f,0.76562500f,-0.75000000f,0.68750000f,0.17187500f,-0.25000000f,0.84375000f,-0.34375000f,-0.28125000f,0.37500000f,-0.56250000f,0.15625000f,0.34375000f,-0.35937500f,0.21875000f,-0.93750000f,-0.14062500f,-0.57812500f,-0.50000000f,-0.62500000f,0.70312500f,-0.23437500f,-0.40625000f,-0.34375000f,0.43750000f,-0.59375000f,-0.79687500f,0.67187500f,-0.32812500f,-0.54687500f,-0.57812500f,0.46875000f,-0.85937500f,-0.17187500f,1.00000000f,0.84375000f,0.76562500f,-0.18750000f,-0.64062500f,-0.92187500f,0.89062500f,0.90625000f,-0.75000000f,0.78125000f,-0.68750000f,0.15625000f,-1.00000000f,-0.21875000f,-0.09375000f,-0.89062500f,-0.29687500f,0.76562500f,0.31250000f,-0.54687500f,0.26562500f,0.37500000f,-0.51562500f,-0.75000000f,-0.96875000f,-0.04687500f,0.29687500f,0.81250000f,0.18750000f,-0.40625000f,-0.70312500f,0.98437500f,-0.65625000f,0.73437500f,0.51562500f,-0.14062500f,-0.95312500f,0.89062500f,-1.00000000f,-0.54687500f,0.90625000f,-0.39062500f,0.07812500f,-0.31250000f,-0.73437500f,-0.17187500f,-0.50000000f,-0.82812500f,-0.93750000f,-0.37500000f,-0.17187500f,0.54687500f,0.90625000f,0.43750000f,-0.67187500f,-0.01562500f,-0.26562500f,-0.23437500f,-0.64062500f,-0.71875000f,-0.45312500f,-0.10937500f,-0.65625000f,0.35937500f,-0.15625000f,-0.18750000f,-0.51562500f,-0.93750000f,0.64062500f,-1.00000000f,-0.60937500f,0.26562500f,0.98437500f,0.90625000f,-0.04687500f,-0.57812500f,-0.71875000f,-0.78125000f,0.42187500f,0.54687500f,-0.76562500f,0.85937500f,-0.56250000f,0.21875000f,0.98437500f,0.46875000f,0.67187500f,-0.40625000f,0.93750000f,-0.98437500f,0.34375000f,0.45312500f,-0.14062500f,-0.07812500f,0.25000000f,-0.40625000f,0.39062500f,0.87500000f,-0.35937500f,0.53125000f,-0.07812500f,-0.39062500f,0.00000000f,0.89062500f,0.07812500f,-0.01562500f,0.82812500f,-0.15625000f,-0.67187500f,-0.32812500f,-0.29687500f,0.00000000f,-0.01562500f,0.10937500f,0.10937500f,-0.56250000f,-0.39062500f,0.12500000f,-0.31250000f,-0.32812500f,-1.00000000f,-0.87500000f,0.51562500f,0.59375000f,-0.65625000f,-0.96875000f,-0.56250000f,-0.26562500f,-0.67187500f,0.04687500f,-1.00000000f,-0.98437500f,0.12500000f,-1.00000000f,-0.14062500f,0.62500000f,-0.25000000f,-0.76562500f,0.35937500f,-0.25000000f,0.75000000f,-0.45312500f,0.42187500f,-0.75000000f,0.34375000f,-0.17187500f,0.76562500f,0.17187500f,0.32812500f,0.75000000f,0.96875000f,-0.32812500f,0.60937500f,0.53125000f,0.75000000f,0.76562500f,-0.65625000f,0.60937500f,-0.57812500f,-0.68750000f,-0.15625000f,-0.62500000f,0.50000000f,-0.92187500f,-0.56250000f,0.26562500f,-0.28125000f,0.78125000f,0.01562500f,0.60937500f,-0.64062500f,0.85937500f,0.87500000f,0.10937500f,-0.40625000f,-0.48437500f,0.70312500f,0.21875000f,0.07812500f,-0.12500000f,-0.40625000f,0.25000000f,-0.76562500f,-0.96875000f,-0.62500000f,-0.76562500f,-0.50000000f,-0.93750000f,0.10937500f,-0.45312500f,-0.81250000f,-0.76562500f,-0.64062500f,-0.54687500f,-0.93750000f,-0.71875000f,-0.96875000f,0.45312500f,0.51562500f,-0.31250000f,0.43750000f,0.35937500f,0.78125000f,-0.21875000f,-0.76562500f,0.53125000f,0.84375000f,0.64062500f,-0.34375000f,-0.43750000f,0.85937500f,-0.07812500f,0.46875000f,-0.15625000f,0.25000000f,-0.67187500f,0.03125000f,0.76562500f,0.12500000f,-0.53125000f,-0.18750000f,-0.09375000f,0.96875000f,-0.54687500f,0.20312500f,0.14062500f,-0.01562500f,0.96875000f,-0.46875000f,-0.71875000f,-0.26562500f,0.04687500f,-0.15625000f,0.64062500f,-0.46875000f,0.07812500f,0.15625000f,0.39062500f,-0.17187500f,-0.18750000f,0.95312500f,-0.67187500f,0.12500000f,-0.85937500f,0.92187500f,0.93750000f,0.03125000f,-0.43750000f,-0.42187500f,-0.04687500f,0.93750000f,-1.00000000f,0.10937500f,0.09375000f,-0.14062500f,-0.89062500f,0.90625000f,-0.95312500f,0.31250000f,0.54687500f,-0.42187500f,0.90625000f,-0.98437500f,-0.37500000f,0.01562500f,-0.03125000f,0.00000000f,0.81250000f,0.18750000f,-0.60937500f,-0.73437500f,-0.70312500f,-0.46875000f,-0.39062500f,0.14062500f,0.85937500f,-0.28125000f,-0.67187500f,-0.39062500f,-0.42187500f,-0.31250000f,0.62500000f,0.21875000f,-0.95312500f,0.28125000f,-0.70312500f,0.64062500f,0.25000000f,0.59375000f,0.32812500f,0.73437500f,-0.57812500f,0.64062500f,0.09375000f,-0.51562500f,-0.78125000f,0.54687500f,0.23437500f,-0.64062500f,0.10937500f,0.35937500f,0.25000000f,-0.32812500f,-0.73437500f,0.92187500f,0.93750000f,-0.35937500f,-0.43750000f,-0.68750000f,0.04687500f,0.04687500f,-0.14062500f,0.70312500f,-0.92187500f,0.57812500f,-0.57812500f,0.15625000f,-0.21875000f,0.01562500f,0.07812500f,0.46875000f,-0.78125000f,-0.09375000f,0.60937500f,0.37500000f,-0.23437500f,-0.28125000f,-0.48437500f,0.84375000f,0.89062500f,-0.73437500f,0.65625000f,0.03125000f,-0.26562500f,-0.18750000f,-0.82812500f,-0.84375000f,-0.42187500f,0.14062500f,-0.81250000f,0.73437500f,-0.68750000f,-0.87500000f,-0.96875000f,0.26562500f,-0.59375000f,-0.40625000f,0.64062500f,0.79687500f,0.70312500f,-0.57812500f,-0.79687500f,0.78125000f,-0.73437500f,-0.60937500f,-0.29687500f,0.93750000f,-0.40625000f,-0.65625000f,0.76562500f,-0.56250000f,-0.84375000f,0.03125000f,-0.10937500f,-0.65625000f,-1.00000000f,0.28125000f,-0.96875000f,-0.78125000f,-0.87500000f,0.39062500f,0.56250000f,-0.71875000f,0.65625000f,-0.75000000f,-0.34375000f,-0.43750000f,-0.32812500f,0.03125000f,0.06250000f,-0.39062500f,-0.21875000f,-0.48437500f,0.79687500f,-0.51562500f,0.01562500f,-0.07812500f,-0.32812500f,-0.35937500f,-0.23437500f,-0.56250000f,0.21875000f,0.57812500f,-0.53125000f,-0.64062500f,-0.59375000f,0.56250000f,1.00000000f,0.21875000f,-0.78125000f,-0.82812500f,0.20312500f,-0.28125000f,0.31250000f,-0.28125000f,0.21875000f,0.90625000f,0.93750000f,-0.15625000f,-0.90625000f,-0.21875000f,0.67187500f,0.76562500f,-0.29687500f,-0.93750000f,-0.59375000f,-0.53125000f,-0.29687500f,-0.28125000f,0.23437500f,0.34375000f,-0.17187500f,0.14062500f,0.60937500f,0.06250000f,0.23437500f,0.56250000f,-0.71875000f,-0.95312500f,-0.34375000f,0.50000000f,0.57812500f,0.32812500f,0.75000000f,0.14062500f,-0.15625000f,0.42187500f,-0.10937500f,0.73437500f,-0.81250000f,0.17187500f,-0.03125000f,-0.89062500f,-0.07812500f,0.56250000f,-0.81250000f,0.20312500f,0.14062500f,0.40625000f,-0.90625000f,0.60937500f,0.73437500f,-0.60937500f,0.12500000f,0.29687500f,0.17187500f,-0.42187500f,-0.53125000f,-0.10937500f,-0.56250000f,0.68750000f,-0.15625000f,-0.76562500f,-0.73437500f,0.42187500f,0.84375000f,0.29687500f,0.14062500f,-0.43750000f,-0.65625000f,-0.26562500f,-0.37500000f,-0.67187500f,-0.42187500f,0.25000000f,0.90625000f,0.00000000f,-0.03125000f,-0.32812500f,-0.98437500f,-0.95312500f,0.18750000f,-0.67187500f,-1.00000000f,-0.20312500f,0.56250000f,0.56250000f,-0.10937500f,-0.18750000f,0.26562500f,-0.70312500f,0.46875000f,0.59375000f,-0.14062500f,-0.93750000f,-0.56250000f,-0.65625000f,-0.39062500f,-0.10937500f,0.10937500f,0.53125000f,0.42187500f,-0.95312500f,0.53125000f,0.68750000f,-0.04687500f,1.00000000f,0.17187500f,-0.56250000f,-0.43750000f,0.96875000f,0.40625000f,0.85937500f,0.04687500f,-0.76562500f,-0.95312500f,0.89062500f,0.60937500f,-0.48437500f,-0.42187500f,-0.68750000f,-1.00000000f,-0.57812500f,-0.03125000f,0.98437500f,-0.79687500f,-0.17187500f,0.87500000f,-0.12500000f,0.01562500f,0.06250000f,0.32812500f,0.50000000f,-0.84375000f,0.68750000f,-0.75000000f,0.51562500f,-0.03125000f,0.71875000f,0.57812500f,0.03125000f,0.56250000f,0.32812500f,0.48437500f,-0.25000000f,0.34375000f,0.98437500f,-0.14062500f,-0.68750000f,-0.81250000f,0.34375000f,0.14062500f,0.68750000f,0.28125000f,0.81250000f,0.84375000f,0.00000000f,0.67187500f,0.04687500f,0.70312500f,0.78125000f,0.15625000f,-0.46875000f,-0.81250000f,0.15625000f,0.40625000f,-0.68750000f,0.65625000f,-0.95312500f,-0.14062500f,-0.45312500f,-0.85937500f,-0.85937500f,0.53125000f,-0.18750000f,-0.46875000f,0.45312500f,0.82812500f,-0.18750000f,-0.71875000f,-0.90625000f,-0.03125000f,-0.03125000f,0.21875000f,0.17187500f,0.96875000f,0.98437500f,-0.23437500f,-0.67187500f,-0.03125000f,0.68750000f,0.59375000f,-0.32812500f,0.92187500f,0.87500000f,1.00000000f,-0.98437500f,-0.84375000f,-0.85937500f,0.73437500f,-0.78125000f,1.00000000f,0.51562500f,-0.35937500f,0.54687500f,-0.85937500f,0.95312500f,0.57812500f,-0.75000000f,0.75000000f,-0.92187500f,0.82812500f,0.85937500f,-0.79687500f,-0.29687500f,-0.35937500f,0.81250000f,-0.60937500f,0.00000000f,0.64062500f,-0.87500000f,-0.62500000f,-0.73437500f,-0.95312500f,0.34375000f,0.65625000f,0.31250000f,0.04687500f,-0.15625000f,-0.42187500f,-0.70312500f,-0.70312500f,-0.35937500f,-0.07812500f,0.62500000f,-0.59375000f,-0.31250000f,0.35937500f,-0.48437500f,0.14062500f,-0.25000000f,0.62500000f,0.03125000f,-0.68750000f,-0.46875000f,-0.21875000f,-0.12500000f,0.04687500f,0.07812500f,0.59375000f,-0.09375000f,-0.28125000f,0.35937500f,-0.96875000f,-0.25000000f,-0.50000000f,0.31250000f,-0.51562500f,-0.53125000f,-0.73437500f,0.71875000f,0.48437500f,0.14062500f,0.21875000f,-0.18750000f,-0.09375000f,0.67187500f,0.14062500f,-0.65625000f,-0.92187500f,0.50000000f,-0.50000000f,0.71875000f,0.93750000f,-0.70312500f,0.04687500f,0.64062500f,0.73437500f,-0.17187500f,-0.42187500f,0.73437500f,-0.34375000f,0.23437500f,-0.96875000f,-0.65625000f,-0.79687500f,0.84375000f,0.03125000f,-0.03125000f,0.32812500f,-0.03125000f,0.92187500f,-0.75000000f,-0.34375000f,-0.62500000f,0.18750000f,-0.84375000f,-0.85937500f,-0.67187500f,0.90625000f,0.07812500f,-0.45312500f,-0.59375000f,0.12500000f,-0.84375000f,0.26562500f,-0.62500000f,-0.09375000f,0.64062500f,0.10937500f,0.14062500f,-0.42187500f,0.04687500f,0.15625000f,-0.35937500f,-0.71875000f,-0.25000000f,0.17187500f,-0.65625000f,0.25000000f,-0.07812500f,0.39062500f,-0.31250000f,0.39062500f,0.71875000f,-0.62500000f,-0.76562500f,-0.21875000f,-0.79687500f,0.68750000f,0.98437500f,-0.56250000f,-0.56250000f,0.46875000f,0.37500000f,-0.81250000f,0.96875000f,-0.25000000f,0.87500000f,0.81250000f,0.85937500f,0.01562500f,-0.35937500f,-0.59375000f,-0.60937500f,0.89062500f,0.21875000f,0.42187500f,0.87500000f,-0.71875000f,0.07812500f,-0.01562500f,0.51562500f,0.95312500f,0.28125000f,-0.28125000f,-0.23437500f,-0.68750000f,0.39062500f,-0.67187500f,-0.95312500f,0.29687500f,-0.62500000f,-0.78125000f,-0.23437500f,0.81250000f,-0.10937500f,0.62500000f,0.00000000f,-0.50000000f,0.25000000f,0.04687500f,-0.17187500f,0.75000000f,0.68750000f,0.73437500f,0.87500000f,-0.75000000f,0.50000000f,0.51562500f,0.15625000f,0.76562500f,-0.25000000f,-0.93750000f,0.71875000f,0.04687500f,-0.98437500f,0.21875000f,0.18750000f,-0.85937500f,-0.75000000f,-0.78125000f,-0.15625000f,0.31250000f,0.37500000f,-0.57812500f,-0.89062500f,0.20312500f,-0.65625000f,-0.89062500f,-0.81250000f,-0.89062500f,0.34375000f,0.06250000f,-0.76562500f,-0.40625000f,-0.35937500f,1.00000000f,-0.82812500f,-0.90625000f,-0.40625000f,0.96875000f,0.20312500f,-0.85937500f,0.39062500f,-0.43750000f,-0.92187500f,-0.84375000f,0.71875000f,-0.85937500f,-0.06250000f,-0.50000000f,-0.17187500f,-0.09375000f,0.56250000f,0.56250000f,0.96875000f,0.31250000f,0.00000000f,-0.53125000f,0.93750000f,0.96875000f,0.23437500f,0.20312500f,0.17187500f,0.95312500f,-1.00000000f,-0.57812500f,0.64062500f,-0.70312500f,-0.50000000f,0.12500000f,0.48437500f,0.45312500f,-0.06250000f,0.21875000f,-0.68750000f,0.93750000f,-0.35937500f,-0.60937500f,0.12500000f,-0.84375000f,-0.90625000f,0.90625000f,0.76562500f,0.75000000f,0.18750000f,-0.06250000f,-0.84375000f,-0.59375000f,-0.20312500f,0.67187500f,0.35937500f,-0.45312500f,0.90625000f,-0.95312500f,0.40625000f,-0.90625000f,-1.00000000f,-0.67187500f,0.15625000f,0.57812500f,0.70312500f,-0.18750000f,-0.71875000f,0.76562500f,-0.45312500f,0.37500000f,0.28125000f,0.35937500f,0.51562500f,0.28125000f,0.23437500f,-0.84375000f,-0.75000000f,0.34375000f,0.37500000f,0.48437500f,0.67187500f,0.82812500f,-0.76562500f,-0.68750000f,0.90625000f,-0.01562500f,-0.07812500f,0.25000000f,-0.45312500f,-0.18750000f,-0.70312500f,0.53125000f,0.93750000f,0.53125000f,-0.67187500f,-0.79687500f,0.14062500f,0.71875000f,0.85937500f,-0.62500000f,-0.51562500f,0.79687500f,-0.82812500f,-0.20312500f,0.21875000f,-0.87500000f,-0.53125000f,-0.87500000f,-0.71875000f,1.00000000f,-0.43750000f,0.78125000f,-0.70312500f,-0.35937500f,-0.60937500f,0.40625000f,-1.00000000f,-0.21875000f,0.14062500f,0.06250000f,-0.64062500f,-0.32812500f,-0.15625000f,-0.64062500f,-0.65625000f,-0.26562500f,0.43750000f,-0.01562500f,0.10937500f,0.37500000f,0.81250000f,-0.46875000f,-0.46875000f,-0.71875000f,0.35937500f,0.98437500f,0.37500000f,-0.07812500f,0.51562500f,0.12500000f,0.25000000f,0.53125000f,0.25000000f,-0.37500000f,-0.67187500f,0.43750000f,0.39062500f,0.26562500f,0.93750000f,0.45312500f,-0.50000000f,0.04687500f,-1.00000000f,-1.00000000f,0.26562500f,-0.15625000f,0.92187500f,0.28125000f,1.00000000f,0.10937500f,-0.87500000f,-0.14062500f,-0.95312500f,-0.03125000f,-0.92187500f,0.48437500f,0.90625000f,-0.23437500f,0.98437500f,-0.71875000f,-0.73437500f,-0.53125000f,0.93750000f,-0.39062500f,-0.56250000f,0.85937500f,-0.50000000f,0.78125000f,0.56250000f,0.56250000f,-0.95312500f,0.01562500f,-0.07812500f,0.78125000f,-0.43750000f,-0.70312500f,0.23437500f,0.54687500f,0.14062500f,0.56250000f,0.32812500f,0.15625000f,-0.53125000f,0.45312500f,-0.17187500f,0.59375000f,0.56250000f,-0.53125000f,-0.06250000f,0.03125000f,-0.10937500f,-0.85937500f,-0.68750000f,-0.82812500f,-0.06250000f,-0.57812500f,0.82812500f,0.90625000f,-0.50000000f,0.06250000f,0.64062500f,-0.92187500f,-0.42187500f,-0.92187500f,-0.20312500f,-0.42187500f,0.12500000f,-0.23437500f,0.25000000f,-0.35937500f,0.26562500f,0.04687500f,0.73437500f,0.34375000f,0.95312500f,0.81250000f,-0.56250000f,-0.67187500f,0.17187500f,0.39062500f,-0.89062500f,-0.20312500f,0.06250000f,-0.31250000f,-0.23437500f,0.07812500f,0.59375000f,-0.09375000f,0.20312500f,-0.96875000f,0.28125000f,0.81250000f,-0.64062500f,0.59375000f,0.25000000f,-0.31250000f,-0.25000000f,0.81250000f,-0.03125000f,-0.45312500f,0.75000000f,-0.15625000f,0.40625000f,-0.92187500f,0.04687500f,0.89062500f,-0.20312500f,0.82812500f,-0.10937500f,0.12500000f,0.39062500f,0.93750000f,-0.15625000f,-0.79687500f,0.39062500f,0.93750000f,-0.04687500f,-0.35937500f,0.40625000f,-0.98437500f,0.73437500f,0.40625000f,0.81250000f,0.48437500f,0.39062500f,-0.87500000f,-0.82812500f,-0.04687500f,-0.31250000f,1.00000000f,0.73437500f,0.50000000f,0.32812500f,-0.65625000f,0.23437500f,-0.42187500f,-0.06250000f,-0.51562500f,-0.56250000f,0.04687500f,0.03125000f,0.23437500f,-0.40625000f,0.56250000f,0.92187500f,-0.15625000f,-0.40625000f,0.90625000f,-0.18750000f,0.23437500f,0.71875000f,-0.12500000f,-0.73437500f,0.75000000f,0.40625000f,-0.28125000f,0.01562500f,0.57812500f,-0.89062500f,0.71875000f,0.01562500f,0.70312500f,-0.42187500f,0.45312500f,-0.10937500f,0.57812500f,-0.32812500f,-0.50000000f,-0.84375000f,0.01562500f,0.76562500f,0.07812500f,0.29687500f,0.85937500f,-0.51562500f,-0.45312500f,0.03125000f,0.85937500f,0.35937500f,-0.64062500f,-0.18750000f,0.10937500f,-0.03125000f,-0.82812500f,0.84375000f,-0.81250000f,0.29687500f,0.35937500f,-0.15625000f,0.10937500f,0.26562500f,0.59375000f,0.54687500f,0.15625000f,-0.31250000f,-0.59375000f,-0.42187500f,-0.65625000f,0.00000000f,-0.20312500f,0.65625000f,-0.40625000f,-0.39062500f,0.35937500f,-0.20312500f,0.17187500f,-0.45312500f,-0.15625000f,0.23437500f,-0.35937500f,0.50000000f,0.75000000f,-0.15625000f,0.00000000f,0.39062500f,-0.17187500f,-0.07812500f,-0.25000000f,-0.17187500f,-0.78125000f,-0.03125000f,-0.40625000f,-0.71875000f,-0.34375000f,0.73437500f,-0.42187500f,-0.07812500f,0.34375000f,0.76562500f,0.67187500f,-0.59375000f,0.73437500f,-0.81250000f,0.15625000f,-0.79687500f,0.01562500f,0.42187500f,-0.78125000f,0.95312500f,-0.56250000f,1.00000000f,0.32812500f,0.07812500f,-0.10937500f,0.01562500f,0.23437500f,0.40625000f,0.15625000f,0.93750000f,0.42187500f,0.73437500f,-0.18750000f,-0.10937500f,0.59375000f,0.34375000f,0.53125000f,-0.42187500f,0.17187500f,-0.84375000f,-0.50000000f,-0.14062500f,-0.46875000f,-0.09375000f,0.29687500f,0.46875000f,0.85937500f,1.00000000f,0.45312500f,-0.34375000f,0.50000000f,-0.20312500f,-0.71875000f,0.73437500f,0.20312500f,0.70312500f,0.32812500f,-0.87500000f,0.37500000f,0.54687500f,-0.89062500f,0.93750000f,-0.90625000f,-0.87500000f,0.03125000f,-0.51562500f,-0.14062500f,-0.57812500f,-0.39062500f,-0.45312500f,-0.95312500f,-0.57812500f,0.85937500f,-0.98437500f,0.65625000f,-0.68750000f,-0.21875000f,-0.18750000f,-0.93750000f,-0.87500000f,-0.40625000f,0.23437500f,0.42187500f,0.32812500f,0.75000000f,0.53125000f,-0.62500000f,-0.12500000f,-0.90625000f,-1.00000000f,-0.06250000f,-0.25000000f,-0.57812500f,0.40625000f,-0.53125000f,0.53125000f,0.29687500f,0.01562500f,-0.37500000f,-0.23437500f,0.39062500f,-0.50000000f,0.51562500f,0.62500000f,0.56250000f,0.34375000f,0.73437500f,-0.82812500f,-0.37500000f,0.40625000f,0.59375000f,0.68750000f,-0.85937500f,0.18750000f,-0.87500000f,-0.21875000f,0.75000000f,-0.57812500f,0.17187500f,0.70312500f,-0.37500000f,-0.64062500f,0.67187500f,0.01562500f,-0.89062500f,-0.03125000f,0.64062500f,-0.85937500f,0.53125000f,0.09375000f,0.76562500f,-0.67187500f,0.35937500f,1.00000000f,-0.64062500f,-0.42187500f,-0.51562500f,-0.42187500f,-0.89062500f,0.37500000f,0.92187500f,-0.01562500f,0.87500000f,-0.62500000f,0.10937500f,-0.18750000f,0.95312500f,0.92187500f,-0.71875000f,0.43750000f,-0.46875000f,-0.46875000f,0.60937500f,-0.14062500f,0.20312500f,-0.45312500f,0.35937500f,-0.21875000f,-0.60937500f,-0.04687500f,0.25000000f,-0.51562500f,-0.14062500f,-0.23437500f,0.25000000f,-0.40625000f,-0.04687500f,-0.31250000f,-0.98437500f,-0.39062500f,0.48437500f,0.29687500f,0.23437500f,-0.45312500f,0.64062500f,-0.43750000f,0.39062500f,0.90625000f,0.39062500f,-0.48437500f,-0.81250000f,0.04687500f,-0.06250000f,0.85937500f,-0.98437500f,0.06250000f,-0.50000000f,0.60937500f,0.56250000f,-0.37500000f,-0.64062500f,-0.42187500f,-0.79687500f,-0.68750000f,-0.45312500f,-0.04687500f,0.79687500f,0.21875000f,-0.64062500f,-0.06250000f,-0.31250000f,0.50000000f,0.64062500f,0.78125000f,0.82812500f,0.92187500f,-0.75000000f,-0.34375000f,-0.96875000f,0.96875000f,0.56250000f,-0.93750000f,0.40625000f,-0.12500000f,-0.15625000f,-0.70312500f,-0.07812500f,0.46875000f,-0.71875000f,0.95312500f,-0.54687500f,-0.96875000f,0.07812500f,-0.07812500f,-0.06250000f,0.62500000f,-0.54687500f,0.54687500f,-0.76562500f,-0.09375000f,-0.71875000f,-0.67187500f,-0.01562500f,0.32812500f,0.62500000f,-0.40625000f,0.07812500f,-0.53125000f,0.48437500f,-0.34375000f,-0.53125000f,-0.56250000f,-0.14062500f,-0.81250000f,0.45312500f,0.31250000f,-0.34375000f,-0.06250000f,0.60937500f,0.31250000f,-0.34375000f,-0.96875000f,0.98437500f,0.23437500f,-0.43750000f,-0.76562500f,0.50000000f,-0.26562500f,-0.42187500f,-0.40625000f,-0.31250000f,0.75000000f,0.73437500f,-0.98437500f,0.06250000f,-0.43750000f,0.14062500f,0.92187500f,0.62500000f,-0.25000000f,-0.95312500f,0.46875000f,-0.81250000f,1.00000000f,0.15625000f,-0.04687500f,-0.48437500f,0.39062500f,0.10937500f,-0.35937500f,0.46875000f,0.34375000f,-0.17187500f,0.56250000f,0.56250000f,0.54687500f,0.42187500f,-0.15625000f,0.23437500f,0.92187500f,-0.60937500f,0.21875000f,-0.06250000f,0.04687500f,-0.07812500f,0.71875000f,-0.84375000f,0.78125000f,1.00000000f,0.95312500f,-0.26562500f,0.09375000f,-0.68750000f,0.06250000f,-0.60937500f,0.75000000f,-0.25000000f,0.28125000f,0.40625000f,0.25000000f,0.68750000f,0.40625000f,-0.75000000f,-0.76562500f,0.03125000f,0.89062500f,-0.68750000f,0.06250000f,0.51562500f,-0.84375000f,0.93750000f,-0.95312500f,-0.98437500f,-0.45312500f,-0.67187500f,-0.39062500f,0.29687500f,0.25000000f,0.14062500f,-1.00000000f,-1.00000000f,0.53125000f,-0.95312500f,-0.75000000f,-0.68750000f,0.67187500f,0.48437500f,0.20312500f,0.07812500f,0.90625000f,0.06250000f,0.03125000f,-0.90625000f,0.71875000f,-0.64062500f,-0.45312500f,0.89062500f,0.67187500f,0.29687500f,-0.59375000f,0.34375000f,-0.07812500f,0.93750000f,-0.43750000f,-0.82812500f,-0.82812500f,0.39062500f,-0.40625000f,-0.76562500f,-0.31250000f,0.67187500f,-0.23437500f,0.70312500f,0.04687500f,0.35937500f,-0.12500000f,0.00000000f,0.46875000f,0.46875000f,0.21875000f,0.01562500f,0.79687500f,0.51562500f,-0.70312500f,-0.90625000f,-0.75000000f,0.14062500f,0.92187500f,-0.76562500f,0.95312500f,-0.60937500f,-0.12500000f,0.96875000f,0.71875000f,-0.46875000f,-0.14062500f,-0.76562500f,-0.29687500f,0.12500000f,-0.09375000f,0.39062500f,0.70312500f,-0.95312500f,0.90625000f,-0.67187500f,0.60937500f,-0.90625000f,0.78125000f,0.18750000f,0.48437500f,0.53125000f,-0.51562500f,0.53125000f,0.87500000f,-0.17187500f,0.56250000f,-0.85937500f,-0.68750000f,-0.75000000f,0.28125000f,0.79687500f,0.70312500f,-0.81250000f,0.40625000f,-0.87500000f,-0.51562500f,0.75000000f,-0.98437500f,0.90625000f,0.28125000f,0.53125000f,-0.10937500f,-0.48437500f,0.00000000f,-0.23437500f,-0.42187500f,0.53125000f,-0.45312500f,0.37500000f,0.29687500f,-0.42187500f,-0.43750000f,-0.70312500f,-0.64062500f,0.57812500f,0.81250000f,-0.01562500f,0.75000000f,0.26562500f,0.73437500f,0.15625000f,-0.50000000f,0.45312500f,0.32812500f,-0.57812500f,0.00000000f,0.53125000f,0.75000000f,-0.32812500f,-0.60937500f,-0.89062500f,0.14062500f,-0.65625000f,-0.64062500f,0.62500000f,-0.50000000f,0.51562500f,-0.34375000f,0.45312500f,-0.81250000f,0.92187500f,0.67187500f,-0.20312500f,-0.50000000f,-0.48437500f,0.85937500f,-0.62500000f,-0.70312500f,-0.28125000f,0.43750000f,-0.28125000f,0.84375000f,0.85937500f,0.73437500f,-0.46875000f,0.42187500f,0.96875000f,-0.89062500f,-0.39062500f,-0.53125000f,0.81250000f,-0.62500000f,-0.64062500f,-0.35937500f,-0.84375000f,0.48437500f,-0.46875000f,0.59375000f,0.50000000f,0.65625000f,0.31250000f,-0.12500000f,-0.46875000f,0.82812500f,0.60937500f,0.23437500f,0.31250000f,1.00000000f,0.54687500f,0.21875000f,-0.29687500f,-0.60937500f,0.06250000f,-0.70312500f,-0.67187500f,-0.07812500f,0.17187500f,-0.32812500f,0.50000000f,0.87500000f,-0.82812500f,-0.42187500f,-0.26562500f,0.35937500f,-0.82812500f,-0.09375000f,0.37500000f,-0.04687500f,-0.46875000f,-0.60937500f,-0.67187500f,-0.01562500f,0.32812500f,-0.93750000f,-0.71875000f,-0.78125000f,0.93750000f,0.46875000f,-0.51562500f,1.00000000f,0.23437500f,0.43750000f,-0.09375000f,0.17187500f,0.01562500f,-0.09375000f,-0.32812500f,0.67187500f,0.84375000f,-0.85937500f,-0.54687500f,0.17187500f,-0.06250000f,-0.95312500f,-0.18750000f,0.20312500f,-0.87500000f,0.43750000f,-0.39062500f,0.51562500f,-0.25000000f,-0.26562500f,0.85937500f,-0.62500000f,-0.54687500f,0.85937500f,-0.39062500f,0.81250000f,0.29687500f,0.34375000f,0.48437500f,0.14062500f,-0.89062500f,-0.23437500f,-0.64062500f,0.71875000f,0.00000000f,0.23437500f,-0.70312500f,-0.37500000f,-0.20312500f,-0.04687500f,-0.04687500f,-0.71875000f,0.89062500f,-0.70312500f,1.00000000f,-0.45312500f,-0.70312500f,-0.04687500f,-0.04687500f,-0.12500000f,-0.70312500f,-0.09375000f,0.96875000f,0.68750000f,0.60937500f,-0.76562500f,-1.00000000f,0.93750000f,-0.95312500f,-0.23437500f,0.12500000f,-0.76562500f,0.40625000f,0.45312500f,0.84375000f,-0.85937500f,-0.31250000f,-0.79687500f,0.21875000f,0.25000000f,0.76562500f,-0.57812500f,-0.15625000f,-0.32812500f,0.35937500f,-0.64062500f,-0.98437500f,-0.62500000f,-0.89062500f,0.01562500f,0.62500000f,-0.70312500f,-0.53125000f,-0.23437500f,-0.29687500f,-0.40625000f,-0.40625000f,0.35937500f,0.01562500f,-0.67187500f,0.85937500f,0.21875000f,0.67187500f,-0.26562500f,-0.01562500f,0.01562500f,0.01562500f,0.75000000f,0.04687500f,-0.15625000f,-0.59375000f,-0.17187500f,-0.70312500f,-0.93750000f,-0.40625000f,0.42187500f,-0.82812500f,0.51562500f,-0.96875000f,-0.96875000f,0.68750000f,-0.75000000f,-0.07812500f,0.89062500f,-0.29687500f,0.01562500f,-0.93750000f,0.73437500f,0.31250000f,-0.14062500f,0.89062500f,0.95312500f,0.51562500f,-0.67187500f,-0.71875000f,0.90625000f,0.29687500f,-0.57812500f,0.96875000f,-0.68750000f,0.43750000f,-0.14062500f,0.79687500f,0.07812500f,-0.67187500f,-0.65625000f,-0.92187500f,-0.64062500f,-0.96875000f,-0.75000000f,-0.70312500f,0.53125000f,0.00000000f,0.12500000f,-0.57812500f,0.43750000f,0.98437500f,-0.50000000f,-0.31250000f,-0.95312500f,0.42187500f,0.90625000f,0.18750000f,0.31250000f,-0.96875000f,-0.76562500f,-0.48437500f,-0.42187500f,-0.07812500f,-0.71875000f,-0.06250000f,-0.92187500f,-0.40625000f,-0.95312500f,-0.03125000f,-0.60937500f,0.89062500f,-0.21875000f,0.34375000f,-0.53125000f,-0.84375000f,0.18750000f,-0.81250000f,-0.85937500f,-0.20312500f,0.48437500f,-0.29687500f,0.51562500f,0.26562500f,0.35937500f,-0.29687500f,0.43750000f,-0.54687500f,-0.78125000f,0.15625000f,-0.39062500f,0.75000000f,-0.46875000f,-0.35937500f,0.87500000f,0.43750000f,-0.96875000f,0.79687500f,-0.62500000f,-0.35937500f,-0.92187500f,0.79687500f,0.48437500f,0.28125000f,0.23437500f,0.87500000f,-0.85937500f,0.75000000f,-1.00000000f,-0.29687500f,0.37500000f,0.14062500f,0.18750000f,0.64062500f,0.90625000f,0.70312500f,0.03125000f,1.00000000f,0.37500000f,-1.00000000f,0.75000000f,0.09375000f,-0.85937500f,-0.12500000f,-0.57812500f,-0.53125000f,0.75000000f,-0.10937500f,0.29687500f,-0.03125000f,0.79687500f,1.00000000f,0.14062500f,-0.82812500f,-0.01562500f,0.17187500f,0.07812500f,-0.17187500f,-0.28125000f,0.70312500f,0.23437500f,0.82812500f,0.10937500f,0.57812500f,0.25000000f,-0.53125000f,0.17187500f,-0.31250000f,0.39062500f,0.43750000f,0.04687500f,0.45312500f,-0.32812500f,-0.37500000f,-0.95312500f,-0.98437500f,0.50000000f,-0.76562500f,-0.93750000f,-0.65625000f,-0.09375000f,-1.00000000f,0.68750000f,-0.60937500f,0.82812500f,0.31250000f,-0.95312500f,0.60937500f,0.07812500f,0.46875000f,0.12500000f,-0.84375000f,-0.51562500f,0.85937500f,0.26562500f,-0.81250000f,-0.37500000f,-0.78125000f,0.34375000f,0.42187500f,0.03125000f,-0.65625000f,0.35937500f,-0.95312500f,0.71875000f,-0.89062500f,0.37500000f,-0.40625000f,0.23437500f,-0.45312500f,-0.92187500f,-0.21875000f,-0.81250000f,-0.26562500f,0.42187500f,-0.60937500f,-0.29687500f,-0.35937500f,-0.89062500f,0.20312500f,-0.87500000f,0.14062500f,-0.01562500f,0.79687500f,0.64062500f,-0.79687500f,-0.51562500f,0.73437500f,0.40625000f,0.32812500f,-0.10937500f,-0.85937500f,-0.64062500f,-0.79687500f,-0.75000000f,-0.84375000f,-0.67187500f,-0.48437500f,-0.42187500f,-0.09375000f,-0.46875000f,-1.00000000f,0.62500000f,-0.35937500f,-0.53125000f,0.17187500f,0.29687500f,0.35937500f,-0.35937500f,-0.23437500f,-0.01562500f,-0.70312500f,-0.87500000f,0.45312500f,-0.73437500f,-0.43750000f,0.14062500f,-0.32812500f,-0.65625000f,0.42187500f,-0.43750000f,0.18750000f,0.01562500f,0.50000000f,0.79687500f,-0.85937500f,-0.59375000f,0.48437500f,-0.31250000f,0.78125000f,-0.89062500f,-0.35937500f,0.43750000f,-0.65625000f,-0.81250000f,0.51562500f,-0.95312500f,-0.07812500f,-0.14062500f,0.40625000f,-1.00000000f,0.71875000f,-0.85937500f,0.92187500f,-0.48437500f,-0.95312500f,0.62500000f,-0.46875000f,-0.62500000f,-0.67187500f,-0.25000000f,0.31250000f,-0.67187500f,0.67187500f,-0.15625000f,0.76562500f,-0.34375000f,-0.37500000f,0.53125000f,-0.79687500f,0.62500000f,0.59375000f,0.57812500f,-0.14062500f,0.76562500f,-0.42187500f,0.25000000f,0.89062500f,-0.01562500f,0.20312500f,0.59375000f,0.20312500f,-0.67187500f,-0.79687500f,-0.62500000f,-0.65625000f,-0.25000000f,-0.70312500f,0.25000000f,0.84375000f,0.43750000f,0.78125000f,-0.26562500f,0.21875000f,-0.20312500f,-0.20312500f,0.70312500f,0.39062500f,-0.73437500f,0.04687500f,-0.57812500f,-0.10937500f,0.78125000f,-0.40625000f,0.62500000f,0.85937500f,-0.89062500f,1.00000000f,-0.43750000f,-0.23437500f,-0.73437500f,0.64062500f,0.67187500f,0.95312500f,0.82812500f,0.31250000f,-0.20312500f,0.32812500f,-0.62500000f,-0.09375000f,0.43750000f,0.04687500f,-0.84375000f,0.96875000f,0.93750000f,-0.73437500f,0.78125000f,-0.79687500f,0.21875000f,0.82812500f,0.60937500f,0.06250000f,-0.73437500f,0.10937500f,-1.00000000f,0.51562500f,-0.93750000f,-0.62500000f,0.95312500f,-0.32812500f,0.40625000f,-0.50000000f,0.92187500f,0.53125000f,0.01562500f,0.85937500f,-0.21875000f,0.71875000f,-0.73437500f,-0.04687500f,-0.81250000f,-0.82812500f,-0.40625000f,-0.31250000f,-0.12500000f,0.51562500f,-0.18750000f,0.68750000f,0.68750000f,0.20312500f,0.03125000f,-0.78125000f,-0.34375000f,0.56250000f,0.07812500f,0.84375000f,-0.85937500f,-0.51562500f,-0.28125000f,-0.60937500f,-0.12500000f,-0.32812500f,0.32812500f,0.18750000f,0.89062500f,0.45312500f,-0.18750000f,-0.03125000f,0.20312500f,0.54687500f,0.60937500f,-0.03125000f,-0.70312500f,0.40625000f,-0.56250000f,0.25000000f,0.12500000f,-0.45312500f,0.81250000f,-0.65625000f,0.65625000f,0.04687500f,0.48437500f,0.14062500f,-0.90625000f,-0.39062500f,-0.50000000f,0.42187500f,0.95312500f,0.12500000f,0.93750000f,-0.87500000f,0.57812500f,-0.75000000f,-0.40625000f,-0.84375000f,-0.10937500f,1.00000000f,0.25000000f,-0.40625000f,0.84375000f,-0.14062500f,-0.90625000f,-0.17187500f,0.48437500f,0.76562500f,-0.01562500f,0.75000000f,-0.50000000f,0.15625000f,-0.31250000f,-0.78125000f,1.00000000f,0.95312500f,0.57812500f,-0.14062500f,0.29687500f,0.93750000f,-0.81250000f,-0.95312500f,0.03125000f,0.10937500f,1.00000000f,-0.62500000f,-0.59375000f,0.21875000f,0.90625000f,-0.96875000f,-0.73437500f,-0.26562500f,-0.10937500f,0.06250000f,0.81250000f,0.93750000f,0.65625000f,0.64062500f,0.70312500f,-0.40625000f,-0.48437500f,-0.68750000f,0.81250000f,0.34375000f,0.96875000f,-0.98437500f,-0.81250000f,0.54687500f,-0.09375000f,-0.82812500f,0.00000000f,0.64062500f,-0.40625000f,-0.37500000f,-0.73437500f,-0.21875000f,-0.25000000f,-0.85937500f,-0.93750000f,0.17187500f,-0.18750000f,0.00000000f,-0.06250000f,0.35937500f,-0.50000000f,-0.35937500f,-0.12500000f,-0.51562500f,-0.37500000f,-0.15625000f,0.45312500f,-0.85937500f,-0.82812500f,-0.31250000f,0.34375000f,-0.42187500f,0.53125000f,-0.50000000f,0.57812500f,0.84375000f,1.00000000f,0.98437500f,0.25000000f,-0.39062500f,0.42187500f,0.09375000f,-0.85937500f,0.79687500f,0.28125000f,-0.42187500f,-0.96875000f,0.09375000f,-0.43750000f,0.00000000f,-0.96875000f,0.53125000f,0.98437500f,-0.18750000f,-0.42187500f,-0.79687500f,-0.04687500f,-0.43750000f,-0.01562500f,0.18750000f,-0.34375000f,-0.23437500f,-0.76562500f,0.90625000f,-0.09375000f,0.54687500f,-0.26562500f,-0.50000000f,0.17187500f,0.01562500f,0.65625000f,0.17187500f,-0.53125000f,0.65625000f,0.12500000f,0.85937500f,0.23437500f,0.35937500f,0.76562500f,0.64062500f,0.93750000f,0.59375000f,-0.31250000f,0.23437500f,-0.93750000f,0.17187500f,-0.68750000f,0.32812500f,-0.68750000f,0.17187500f,-0.39062500f,0.37500000f,0.06250000f,0.95312500f,0.67187500f,-0.57812500f,-0.59375000f,-0.28125000f,-0.60937500f,0.62500000f,-0.62500000f,0.46875000f,-0.53125000f,-0.40625000f,-0.07812500f,-0.17187500f,0.01562500f,-0.39062500f,0.35937500f,0.15625000f,0.43750000f,-0.39062500f,0.96875000f,0.12500000f,-0.15625000f,-0.14062500f,-0.32812500f,0.39062500f,0.76562500f,0.70312500f,0.12500000f,-0.37500000f,0.56250000f,-0.42187500f,-0.82812500f,0.26562500f,-0.67187500f,-0.93750000f,0.54687500f,-0.39062500f,0.92187500f,-0.59375000f,0.60937500f,1.00000000f,0.45312500f,0.45312500f,-0.54687500f,-0.57812500f,-0.20312500f,-0.40625000f,0.45312500f,0.70312500f,-0.70312500f,0.48437500f,0.59375000f,0.28125000f,0.95312500f,0.20312500f,0.95312500f,-0.28125000f,-0.60937500f,0.79687500f,0.12500000f,0.09375000f,0.92187500f,0.73437500f,0.31250000f,0.85937500f,0.43750000f,-0.20312500f,-0.15625000f,0.92187500f,-0.78125000f,-0.85937500f,0.17187500f,0.25000000f,-0.71875000f,0.65625000f,-0.21875000f,-0.40625000f,0.92187500f,0.45312500f,0.43750000f,0.96875000f,0.35937500f,0.14062500f,0.26562500f,-0.56250000f,-0.78125000f,0.73437500f,-0.76562500f,0.84375000f,0.54687500f,0.03125000f,-0.39062500f,0.40625000f,0.26562500f,0.96875000f,0.26562500f,-0.06250000f,-0.78125000f,0.65625000f,-0.03125000f,0.93750000f,-0.26562500f,-0.31250000f,-0.84375000f,0.68750000f,0.46875000f,-0.18750000f,0.70312500f,0.81250000f,-0.85937500f,0.37500000f,0.65625000f,0.46875000f,0.87500000f,0.17187500f,0.26562500f,-0.12500000f,-0.65625000f,-0.75000000f,0.17187500f,0.85937500f,-0.65625000f,0.03125000f,0.67187500f,-0.85937500f,0.56250000f,-0.42187500f,-0.01562500f,0.18750000f,-0.17187500f,0.07812500f,-0.40625000f,-0.01562500f,0.81250000f,0.21875000f,0.57812500f,-0.48437500f,0.96875000f,0.39062500f,0.35937500f,0.09375000f,-0.04687500f,-0.93750000f,0.28125000f,-0.34375000f,0.14062500f,0.78125000f,0.79687500f,-0.09375000f,-0.42187500f,-0.92187500f,-0.51562500f,0.75000000f,0.51562500f,-0.50000000f,0.23437500f,-0.53125000f,-0.07812500f,-0.03125000f,-0.15625000f,-0.67187500f,-0.67187500f,-0.37500000f,0.51562500f,1.00000000f,-0.37500000f,-0.07812500f,0.32812500f,-0.56250000f,-0.92187500f,0.81250000f,-0.78125000f,-0.18750000f,-0.56250000f,0.65625000f,0.26562500f,0.42187500f,0.62500000f,0.54687500f,-0.03125000f,-0.53125000f,-0.18750000f,-0.37500000f,-0.12500000f,1.00000000f,-0.25000000f,-0.07812500f,0.17187500f,-0.18750000f,-0.62500000f,-0.23437500f,-0.45312500f,-0.06250000f,0.68750000f,0.35937500f,-0.37500000f,-0.48437500f,0.35937500f,-0.98437500f,-0.53125000f,0.40625000f,0.48437500f,-0.75000000f,0.75000000f,-0.93750000f,0.21875000f,0.73437500f,0.81250000f,0.23437500f,-0.12500000f,0.00000000f,-0.85937500f,-0.67187500f,0.17187500f,0.50000000f,-0.98437500f,0.20312500f,-0.89062500f,-0.04687500f,0.15625000f,0.03125000f,-0.03125000f,0.90625000f,0.60937500f,0.15625000f,-0.40625000f,-0.62500000f,0.40625000f,0.14062500f,-0.25000000f,0.79687500f,-0.09375000f,-0.51562500f,0.71875000f,-0.48437500f,-0.65625000f,0.34375000f,0.70312500f,-0.42187500f,0.73437500f,0.70312500f,-0.28125000f,-0.03125000f,-0.39062500f,-0.73437500f,-0.01562500f,-0.95312500f,-0.60937500f,-0.15625000f,-0.18750000f,0.89062500f,0.37500000f,0.42187500f,0.00000000f,0.76562500f,0.23437500f,-0.42187500f,-0.85937500f,1.00000000f,-0.50000000f,-0.70312500f,0.70312500f,0.68750000f,-0.15625000f,-0.65625000f,-0.54687500f,0.10937500f,-0.42187500f,0.57812500f,0.75000000f,-0.14062500f,-0.26562500f,0.53125000f,-0.73437500f,-0.79687500f,-0.42187500f,0.12500000f,0.87500000f,0.37500000f,-0.43750000f,0.01562500f,-0.53125000f,-0.45312500f,-0.50000000f,-0.46875000f,0.75000000f,-0.35937500f,-0.34375000f,-1.00000000f,0.51562500f,-0.50000000f,0.51562500f,-0.75000000f,0.21875000f,0.65625000f,-0.12500000f,-0.59375000f,-0.81250000f,-0.39062500f,-0.51562500f,-0.87500000f,0.60937500f,0.67187500f,-0.31250000f,0.98437500f,0.29687500f,0.89062500f,-0.50000000f,-0.90625000f,-0.85937500f,0.09375000f,0.57812500f,-0.37500000f,-0.42187500f,-0.82812500f,-0.75000000f,-0.90625000f,-0.42187500f,-0.48437500f,0.45312500f,0.56250000f,0.45312500f,0.34375000f,0.42187500f,0.82812500f,-0.53125000f,-0.21875000f,-0.39062500f,0.42187500f,-0.85937500f,0.60937500f,0.89062500f,0.50000000f,0.95312500f,-0.93750000f,-0.84375000f,-0.28125000f,0.95312500f,0.03125000f,-0.59375000f,-0.14062500f,0.40625000f,-0.03125000f,-0.23437500f,-0.67187500f,0.85937500f,-0.43750000f,0.84375000f,0.62500000f,0.87500000f,0.62500000f,-0.73437500f,0.32812500f,-0.89062500f,-0.85937500f,0.12500000f,0.98437500f,-0.68750000f,-0.98437500f,-0.09375000f,0.15625000f,-0.21875000f,0.85937500f,0.07812500f,0.34375000f,-0.50000000f,-0.23437500f,0.48437500f,-0.03125000f,0.71875000f,-0.31250000f,0.82812500f,-0.18750000f,-0.50000000f,-0.68750000f,0.50000000f,-0.59375000f,-0.35937500f,-0.50000000f,0.75000000f,-0.21875000f,1.00000000f,-0.70312500f,0.68750000f,-0.18750000f,-0.67187500f,-0.15625000f,-0.21875000f,-0.70312500f,-0.67187500f,-0.51562500f,-0.46875000f,-0.03125000f,-0.25000000f,-0.90625000f,-0.17187500f,-0.71875000f,-0.28125000f,0.85937500f,-0.98437500f,0.18750000f,-0.81250000f,0.23437500f,0.42187500f,-0.03125000f,-0.20312500f,0.39062500f,-0.70312500f,-0.39062500f,0.53125000f,-0.92187500f,-0.65625000f,0.51562500f,-0.18750000f,-0.04687500f,-0.87500000f,0.87500000f,-0.71875000f,-0.59375000f,0.00000000f,-0.71875000f,0.84375000f,0.85937500f,-0.10937500f,-0.89062500f,-0.87500000f,-0.65625000f,-0.39062500f,-0.71875000f,0.73437500f,-0.78125000f,-0.09375000f,-0.23437500f,0.78125000f,0.78125000f,-0.89062500f,0.26562500f,0.85937500f,-0.71875000f,-0.21875000f,0.53125000f,0.68750000f,-0.46875000f,-0.90625000f,-0.14062500f,-0.92187500f,0.09375000f,0.40625000f,-0.15625000f,1.00000000f,-0.48437500f,0.93750000f,0.82812500f,-0.96875000f,-0.90625000f,-0.09375000f,0.75000000f,-0.06250000f,-0.73437500f,0.42187500f,-0.68750000f,0.00000000f,0.14062500f,-0.84375000f,-0.04687500f,0.96875000f,-0.96875000f,-0.39062500f,-0.89062500f,0.20312500f,0.81250000f,0.34375000f,0.15625000f,0.34375000f,-0.10937500f,0.03125000f,0.93750000f,0.73437500f,0.14062500f,0.07812500f,-0.32812500f,0.01562500f,-0.14062500f,-0.28125000f,0.79687500f,-0.03125000f,0.29687500f,0.18750000f,-0.04687500f,0.87500000f,0.70312500f,0.28125000f,-0.12500000f,0.00000000f,-0.73437500f,-0.54687500f,-0.84375000f,0.45312500f,0.03125000f,0.65625000f,-0.67187500f,0.62500000f,0.26562500f,0.03125000f,0.51562500f,-0.85937500f,0.12500000f,0.17187500f,-0.98437500f,-0.09375000f,-0.51562500f,-0.17187500f,0.84375000f,0.20312500f,0.17187500f,-0.84375000f,0.84375000f,-0.84375000f,0.37500000f,-0.04687500f,-0.10937500f,-0.03125000f,0.62500000f,0.70312500f,-0.12500000f,-0.26562500f,0.68750000f,0.84375000f,0.98437500f,-0.01562500f,-0.92187500f,-0.28125000f,0.17187500f,-0.82812500f,0.54687500f,-0.81250000f,-0.37500000f,0.15625000f,0.71875000f,0.96875000f,0.01562500f,0.35937500f,-0.60937500f,0.07812500f,0.79687500f,0.01562500f,-0.73437500f,-0.76562500f,0.78125000f,0.25000000f,0.87500000f,0.71875000f,0.03125000f,-0.25000000f,-0.95312500f,0.96875000f,0.50000000f,0.12500000f,-0.89062500f,0.31250000f,-0.37500000f,0.03125000f,-0.89062500f,0.09375000f,-0.85937500f,0.46875000f,-0.23437500f,0.79687500f,0.35937500f,-0.85937500f,-0.06250000f,0.06250000f,-0.89062500f,0.85937500f,-0.56250000f,-0.46875000f,0.01562500f,0.89062500f,0.78125000f,0.67187500f,0.35937500f,0.51562500f,-0.59375000f,0.93750000f,-0.01562500f,-0.48437500f,-0.67187500f,-0.57812500f,0.60937500f,-0.18750000f,0.50000000f,0.78125000f,0.87500000f,-0.23437500f,0.85937500f,-0.57812500f,0.60937500f,-0.14062500f,0.14062500f,0.56250000f,0.67187500f,-0.04687500f,-0.20312500f,0.90625000f,0.78125000f,-0.18750000f,-0.01562500f,-0.12500000f,-0.79687500f,-0.51562500f,0.73437500f,0.45312500f,0.51562500f,0.00000000f,-0.20312500f,0.57812500f,0.21875000f,0.67187500f,-0.70312500f,-0.56250000f,0.03125000f,-0.68750000f,0.57812500f,0.14062500f,0.29687500f,0.89062500f,0.84375000f,0.04687500f,0.12500000f,-0.79687500f,0.23437500f,-0.26562500f,-0.40625000f,0.37500000f,-0.92187500f,0.56250000f,0.34375000f,-0.81250000f,-0.70312500f,-0.70312500f,0.37500000f,0.12500000f,0.23437500f,-0.56250000f,-0.67187500f,-0.78125000f,0.18750000f,0.06250000f,-0.92187500f,-0.53125000f,0.09375000f,0.71875000f,0.09375000f,0.01562500f,0.10937500f,0.32812500f,-0.82812500f,-0.10937500f,-0.64062500f,-0.06250000f,-0.64062500f,0.21875000f,-0.71875000f,-0.56250000f,-0.89062500f,0.60937500f,-0.45312500f,0.43750000f,-0.81250000f,0.82812500f,0.23437500f,0.42187500f,-0.25000000f,-0.76562500f,0.14062500f,0.56250000f,0.09375000f,-0.09375000f,-0.54687500f,-0.18750000f,0.92187500f,0.64062500f,-0.76562500f,-0.45312500f,-0.03125000f,-0.21875000f,-0.35937500f,0.75000000f,-0.71875000f,-0.53125000f,0.09375000f,-0.25000000f,0.56250000f,0.57812500f,0.87500000f,-0.60937500f,0.56250000f,-0.07812500f,-0.98437500f,-0.42187500f,-0.67187500f,-0.09375000f,0.76562500f,-0.39062500f,0.10937500f,-0.65625000f,-0.53125000f,0.42187500f,0.89062500f,-0.81250000f,-0.67187500f,0.71875000f,0.98437500f,0.34375000f,0.56250000f,-0.17187500f,-0.12500000f,-0.26562500f,-0.89062500f,-0.75000000f,0.64062500f,0.67187500f,-0.23437500f,0.85937500f,-0.65625000f,0.42187500f,-0.92187500f,-0.53125000f,0.95312500f,0.25000000f,-0.12500000f,0.70312500f,-0.42187500f,-0.73437500f,-0.70312500f,-0.26562500f,0.56250000f,0.51562500f,-0.71875000f,-0.04687500f,0.75000000f,0.87500000f,0.29687500f,-0.98437500f,-0.07812500f,0.42187500f,0.06250000f,-0.56250000f,-0.92187500f,-0.73437500f,0.57812500f,-0.60937500f,0.15625000f,-0.93750000f,0.37500000f,0.90625000f,0.46875000f,0.14062500f,0.10937500f,0.76562500f,0.81250000f,-0.45312500f,0.18750000f,-0.03125000f,0.35937500f,0.98437500f,-0.15625000f,0.46875000f,-0.82812500f,0.75000000f,-0.79687500f,-0.79687500f,-0.84375000f,-0.90625000f,-0.39062500f,-0.31250000f,-0.90625000f,0.03125000f,-0.76562500f,0.90625000f,0.50000000f,0.70312500f,-0.32812500f,-0.64062500f,-0.90625000f,-0.73437500f,-0.95312500f,-0.20312500f,0.40625000f,-0.26562500f,-0.56250000f,0.79687500f,-0.03125000f,-0.92187500f,0.17187500f,0.06250000f,0.37500000f,-0.23437500f,0.12500000f,-1.00000000f,-0.56250000f,-1.00000000f,0.21875000f,0.45312500f,-0.09375000f,-0.82812500f,-0.40625000f,-0.35937500f,-0.82812500f,0.40625000f,-0.26562500f,0.60937500f,-0.50000000f,-1.00000000f,-0.60937500f,-0.76562500f,0.90625000f,0.59375000f,0.12500000f,0.50000000f,0.56250000f,-0.92187500f,-0.96875000f,-0.09375000f,0.60937500f,-0.84375000f,-0.62500000f,0.93750000f,0.32812500f,0.92187500f,0.78125000f,-0.12500000f,0.14062500f,0.96875000f,-0.42187500f,-0.79687500f,-0.73437500f,-0.43750000f,0.32812500f,1.00000000f,-0.85937500f,-0.85937500f,0.31250000f,0.06250000f,-0.34375000f,0.73437500f,0.34375000f,-0.98437500f,0.89062500f,-0.42187500f,-0.21875000f,0.57812500f,0.07812500f,-0.96875000f,0.59375000f,-0.54687500f,-0.67187500f,-0.62500000f,-0.54687500f,-0.51562500f,0.98437500f,0.79687500f,0.29687500f,-0.76562500f,-0.35937500f,0.35937500f,0.81250000f,-0.87500000f,-0.84375000f,-0.95312500f,0.03125000f,-0.17187500f,0.82812500f,-0.98437500f,0.32812500f,0.82812500f,-0.34375000f,-0.18750000f,-0.54687500f,-0.59375000f,0.51562500f,-0.48437500f,-0.10937500f,-0.82812500f,0.37500000f,-0.92187500f,-0.84375000f,-0.14062500f,-0.46875000f,-0.20312500f,-0.89062500f,-0.21875000f,-0.57812500f,-0.56250000f,0.48437500f,-0.53125000f,0.53125000f,-0.42187500f,-0.18750000f,-0.03125000f,-0.93750000f,0.45312500f,0.85937500f,0.71875000f,0.43750000f,-0.54687500f,0.54687500f,0.39062500f,-0.96875000f,-0.48437500f,0.20312500f,0.71875000f,0.76562500f,0.14062500f,0.54687500f,0.60937500f,-0.18750000f,0.84375000f,0.28125000f,0.39062500f,-0.12500000f,0.40625000f,0.07812500f,0.73437500f,-0.14062500f,0.90625000f,0.00000000f,0.75000000f,-0.89062500f,-0.04687500f,0.56250000f,-0.40625000f,-0.82812500f,0.03125000f,0.98437500f,0.04687500f,0.82812500f,0.50000000f,-0.35937500f,-0.14062500f,0.25000000f,-0.93750000f,-0.92187500f,0.60937500f,0.98437500f,0.53125000f,-0.87500000f,-0.20312500f,-0.21875000f,-0.98437500f,-0.85937500f,-0.34375000f,-0.35937500f,-0.12500000f,0.18750000f,-0.14062500f,0.85937500f,-0.45312500f,0.76562500f,-0.84375000f,-0.31250000f,-0.59375000f,0.12500000f,-0.64062500f,-0.25000000f,-0.98437500f,-0.68750000f,-0.75000000f,0.82812500f,-0.54687500f,0.35937500f,0.28125000f,0.59375000f,0.12500000f,0.54687500f,0.43750000f,-0.98437500f,-0.78125000f,0.42187500f,0.06250000f,1.00000000f,-0.54687500f,0.40625000f,0.87500000f,-0.37500000f,-0.21875000f,-0.90625000f,-0.71875000f,-0.29687500f,-0.53125000f,-0.03125000f,0.62500000f,-0.31250000f,-0.25000000f,0.95312500f,0.04687500f,-0.96875000f,-0.79687500f,0.92187500f,-0.68750000f,0.48437500f,0.81250000f,0.34375000f,-0.29687500f,-0.71875000f,-0.64062500f,-0.89062500f,0.79687500f,0.40625000f,0.45312500f,-0.50000000f,0.84375000f,-0.65625000f,-0.93750000f,0.67187500f,0.34375000f,0.34375000f,-0.12500000f,-0.31250000f,0.95312500f,-0.34375000f,-0.35937500f,0.71875000f,-0.20312500f,0.20312500f,0.71875000f,-0.21875000f,-0.48437500f,0.21875000f,0.42187500f,-0.90625000f,0.21875000f,0.82812500f,0.42187500f,-0.68750000f,0.70312500f,-0.07812500f,-0.59375000f,-0.48437500f,0.95312500f,0.34375000f,0.32812500f,0.71875000f,-0.64062500f,-0.78125000f,0.42187500f,-0.59375000f,-0.42187500f,0.00000000f,0.46875000f,0.76562500f,0.25000000f,-0.35937500f,0.53125000f,-0.14062500f,-0.76562500f,0.54687500f,0.60937500f,0.07812500f,0.23437500f,-0.84375000f,-0.23437500f,-0.96875000f,0.48437500f,-0.45312500f,-0.12500000f,-0.03125000f,0.20312500f,-0.68750000f,-0.53125000f,-0.57812500f,-0.78125000f,-0.26562500f,-0.87500000f,0.56250000f,-0.82812500f,0.35937500f,-0.32812500f,0.10937500f,-0.23437500f,0.84375000f,-0.65625000f,-0.46875000f,0.15625000f,-0.29687500f,0.82812500f,-0.26562500f,0.68750000f,-0.14062500f,0.79687500f,-0.18750000f,0.76562500f,-0.67187500f,0.68750000f,-0.26562500f,0.42187500f,-0.95312500f,0.96875000f,-0.57812500f,0.87500000f,-0.18750000f,-0.53125000f,-0.40625000f,-0.28125000f,0.37500000f,-0.57812500f,0.20312500f,0.54687500f,0.12500000f,-0.71875000f,-0.46875000f,0.04687500f,-0.23437500f,-0.03125000f,0.56250000f,-0.57812500f,0.34375000f,0.73437500f,0.15625000f,-0.21875000f,0.37500000f,0.37500000f,-0.50000000f,-0.07812500f,-0.54687500f,-0.03125000f,-0.92187500f,-0.81250000f,-0.25000000f,-0.78125000f,0.90625000f,0.67187500f,-0.14062500f,0.28125000f,-0.62500000f,0.06250000f,-0.78125000f,-0.18750000f,-0.18750000f,-0.90625000f,-0.20312500f,0.85937500f,0.06250000f,0.23437500f,-0.37500000f,-0.53125000f,-0.76562500f,-0.54687500f,-0.67187500f,0.00000000f,0.90625000f,-0.76562500f,0.96875000f,0.76562500f,0.73437500f,-0.93750000f,0.07812500f,0.00000000f,-0.59375000f,-0.45312500f,0.73437500f,-0.10937500f,-0.78125000f,0.18750000f,0.62500000f,0.01562500f,0.12500000f,0.87500000f,-0.29687500f,0.04687500f,0.10937500f,-0.87500000f,0.76562500f,-0.96875000f,0.65625000f,0.15625000f,-0.46875000f,0.51562500f,-0.29687500f,0.12500000f,-0.40625000f,-0.31250000f,-0.84375000f,0.43750000f,0.51562500f,-0.92187500f,0.31250000f,-0.50000000f,0.25000000f,0.62500000f,-0.79687500f,0.56250000f,-0.01562500f,-0.18750000f,0.48437500f,0.40625000f,-0.95312500f,-0.46875000f,-0.51562500f,0.75000000f,-0.31250000f,-0.35937500f,-0.82812500f,0.39062500f,-0.20312500f,0.29687500f,0.48437500f,0.51562500f,0.29687500f,0.46875000f,-0.37500000f,-0.18750000f,0.60937500f,0.14062500f,0.06250000f,0.92187500f,-0.96875000f,-0.93750000f,-0.07812500f,0.04687500f,0.23437500f,-0.70312500f,-0.09375000f,-0.50000000f,0.29687500f,0.75000000f,-0.21875000f,-0.53125000f,-0.64062500f,0.23437500f,0.00000000f,-0.26562500f,0.43750000f,-0.10937500f,0.06250000f,-0.92187500f,0.51562500f,0.68750000f,0.87500000f,-0.85937500f,0.04687500f,-0.45312500f,-0.57812500f,-0.34375000f,0.60937500f,0.35937500f,-0.32812500f,0.18750000f,0.39062500f,-0.35937500f,-0.20312500f,-0.87500000f,-0.65625000f,0.62500000f,0.65625000f,-0.06250000f,0.21875000f,-0.82812500f,-0.29687500f,0.23437500f,0.43750000f,0.70312500f,0.62500000f,0.54687500f,0.31250000f,0.57812500f,-0.54687500f,0.73437500f,-0.59375000f,0.50000000f,0.14062500f,-0.09375000f,0.42187500f,-0.79687500f,0.68750000f,0.37500000f,0.26562500f,-0.40625000f,0.65625000f,-0.18750000f,0.46875000f,0.67187500f,-0.29687500f,0.25000000f,-0.84375000f,0.96875000f,-0.54687500f,0.43750000f,0.82812500f,0.00000000f,-0.12500000f,-0.68750000f,0.75000000f,-0.87500000f,0.31250000f,1.00000000f,-0.51562500f,0.35937500f,-0.64062500f,-0.07812500f,0.82812500f,0.64062500f,-0.34375000f,0.65625000f,0.35937500f,0.76562500f,-0.34375000f,0.31250000f,0.50000000f,0.35937500f,0.51562500f,0.96875000f,0.59375000f,0.37500000f,-0.57812500f,0.29687500f,-0.71875000f,-0.62500000f,-0.45312500f,-0.53125000f,-0.70312500f,0.04687500f,-0.59375000f,0.93750000f,0.81250000f,-0.67187500f,-0.09375000f,-0.90625000f,-0.60937500f,0.65625000f,-0.23437500f,0.40625000f,0.78125000f,-0.82812500f,-0.81250000f,-0.73437500f,0.03125000f,0.60937500f,-0.64062500f,0.76562500f,-0.87500000f,-0.04687500f,0.00000000f,-0.45312500f,-0.54687500f,-0.23437500f,-0.79687500f,-0.45312500f,-0.07812500f,0.23437500f,0.18750000f,0.28125000f,0.28125000f,0.20312500f,-0.10937500f,0.82812500f,-0.90625000f,-0.95312500f,0.57812500f,0.31250000f,0.79687500f,-0.46875000f,0.92187500f,0.18750000f,0.14062500f,-0.84375000f,0.98437500f,-1.00000000f,0.92187500f,0.12500000f,-0.53125000f,-0.39062500f,0.09375000f,-0.43750000f,-0.71875000f,0.64062500f,0.40625000f,-0.34375000f,-0.46875000f,0.85937500f,0.32812500f,-0.32812500f,0.26562500f,0.10937500f,-0.67187500f,-0.50000000f,-0.15625000f,-0.07812500f,0.42187500f,0.87500000f,-0.59375000f,-0.31250000f,-0.43750000f,0.39062500f,-0.15625000f,0.20312500f,0.68750000f,0.59375000f,0.00000000f,0.92187500f,-0.01562500f,0.96875000f,-0.89062500f,0.84375000f,-0.68750000f,0.06250000f,0.68750000f,0.79687500f,-0.29687500f,-0.40625000f,-0.18750000f,-0.53125000f,0.43750000f,0.00000000f,0.20312500f,-0.71875000f,-0.46875000f,0.07812500f,0.59375000f,-0.54687500f,-0.37500000f,0.76562500f,-0.85937500f,-0.78125000f,-0.25000000f,-0.14062500f,-0.40625000f,-0.37500000f,-0.67187500f,0.98437500f,-0.68750000f,-0.62500000f,0.26562500f,0.79687500f,0.28125000f,0.98437500f,0.25000000f,-0.59375000f,0.92187500f,-0.37500000f,-0.85937500f,0.09375000f,0.73437500f,-0.35937500f,-0.67187500f,-0.71875000f,0.51562500f,-0.67187500f,-0.09375000f,-0.51562500f,0.21875000f,0.56250000f,0.15625000f,-0.68750000f,-0.46875000f,0.54687500f,-1.00000000f,0.62500000f,-0.56250000f,0.40625000f,-0.90625000f,0.87500000f,-0.71875000f,0.10937500f,0.62500000f,-0.50000000f,-0.62500000f,-0.21875000f,-0.60937500f,-0.67187500f,-0.18750000f,0.62500000f,0.14062500f,0.28125000f,0.73437500f,0.03125000f,0.96875000f,-0.01562500f,0.62500000f,0.51562500f,-0.07812500f,0.01562500f,-0.79687500f,-0.62500000f,-0.73437500f,-0.14062500f,0.96875000f,-0.14062500f,0.53125000f,0.51562500f,-0.54687500f,-0.87500000f,-0.45312500f,0.23437500f,-0.73437500f,0.51562500f,0.87500000f,0.31250000f,-0.01562500f,-0.46875000f,-1.00000000f,0.45312500f,0.14062500f,-0.60937500f,0.53125000f,0.62500000f,-0.85937500f,-0.39062500f,-0.31250000f,-0.31250000f,0.35937500f,-0.23437500f,0.54687500f,0.14062500f,0.98437500f,-0.70312500f,0.04687500f,-0.23437500f,0.92187500f,-0.23437500f,-0.89062500f,0.68750000f,-0.10937500f,0.53125000f,0.04687500f,-1.00000000f,0.89062500f,0.92187500f,0.04687500f,0.98437500f,-0.57812500f,0.03125000f,0.35937500f,-0.89062500f,0.71875000f,-0.04687500f,0.09375000f,0.84375000f,-0.10937500f,-0.92187500f,-1.00000000f,0.06250000f,-0.93750000f,0.34375000f,0.39062500f,0.46875000f,-0.21875000f,0.18750000f,-0.87500000f,-0.34375000f,0.96875000f,0.95312500f,0.84375000f,-0.17187500f,-0.45312500f,-0.26562500f,0.87500000f,-0.50000000f,-0.81250000f,0.56250000f,-0.20312500f,-0.18750000f,0.92187500f,-0.98437500f,0.82812500f,0.92187500f,0.32812500f,0.54687500f,-0.53125000f,-0.37500000f,0.01562500f,1.00000000f,0.17187500f,-0.53125000f,0.95312500f,-0.23437500f,0.95312500f,0.56250000f,0.17187500f,-0.68750000f,0.39062500f,0.50000000f,0.01562500f,0.59375000f,0.03125000f,0.71875000f,-0.20312500f,0.12500000f,0.48437500f,0.60937500f,0.70312500f,-0.68750000f,-0.70312500f,0.51562500f,-0.39062500f,0.39062500f,-0.92187500f,0.40625000f,0.82812500f,0.45312500f,0.29687500f,0.67187500f,0.17187500f,-0.67187500f,-0.78125000f,0.67187500f,-0.04687500f,0.92187500f,-0.17187500f,-0.32812500f,0.62500000f,-0.67187500f,0.12500000f,0.12500000f,0.57812500f,-0.28125000f,0.85937500f,0.90625000f,0.45312500f,-0.25000000f,-0.62500000f,0.03125000f,-0.79687500f,0.92187500f,0.10937500f,0.85937500f,-0.75000000f,0.73437500f,0.59375000f,0.76562500f,-0.34375000f,0.26562500f,0.29687500f,0.54687500f,-0.28125000f,-0.75000000f,-0.92187500f,0.07812500f,-0.75000000f,1.00000000f,-0.39062500f,-0.84375000f,-0.39062500f,-0.23437500f,-0.06250000f,-0.14062500f,0.87500000f,0.73437500f,-0.79687500f,-0.73437500f,0.79687500f,-0.07812500f,-0.06250000f,0.51562500f,-0.40625000f,-0.79687500f,-0.07812500f,0.12500000f,-0.35937500f,0.56250000f,-0.37500000f,-0.89062500f,-0.84375000f,0.87500000f,0.35937500f,0.56250000f,-0.21875000f,-0.04687500f,0.40625000f,0.75000000f,-0.01562500f,-0.32812500f,0.87500000f,-0.31250000f,0.89062500f,0.23437500f,-0.20312500f,-0.75000000f,-0.17187500f,0.14062500f,0.65625000f,0.29687500f,-0.87500000f,0.15625000f,-0.46875000f,0.12500000f,0.45312500f,-0.35937500f,-1.00000000f,-0.98437500f,-0.23437500f,-0.29687500f,0.48437500f,-0.79687500f,-0.53125000f,0.18750000f,-0.57812500f,-0.20312500f,0.45312500f,-0.60937500f,-0.45312500f,-0.95312500f,0.60937500f,0.06250000f,0.32812500f,0.75000000f,-0.06250000f,-0.37500000f,0.67187500f,-0.20312500f,0.42187500f,0.62500000f,-0.98437500f,0.06250000f,0.46875000f,0.70312500f,-0.78125000f,0.39062500f,-0.39062500f,-0.31250000f,-0.90625000f,-0.07812500f,-0.78125000f,0.23437500f,-0.92187500f,-0.23437500f,0.73437500f,0.70312500f,-0.17187500f,-0.23437500f,0.56250000f,0.81250000f,0.23437500f,0.15625000f,0.40625000f,0.50000000f,-0.23437500f,-0.56250000f,-0.20312500f,-0.73437500f,-0.37500000f,0.76562500f,0.34375000f,0.15625000f,0.53125000f,0.64062500f,0.29687500f,0.51562500f,0.87500000f,-0.70312500f,0.29687500f,1.00000000f,-0.21875000f,-0.01562500f,0.85937500f,0.31250000f,0.89062500f,0.21875000f,-0.59375000f,0.17187500f,0.39062500f,-0.90625000f,0.34375000f,0.26562500f,0.34375000f,0.93750000f,0.07812500f,0.51562500f,0.76562500f,0.35937500f,0.04687500f,0.45312500f,0.48437500f,-0.34375000f,0.18750000f,0.01562500f,-0.85937500f,-0.98437500f,0.00000000f,0.28125000f,-0.43750000f,0.96875000f,-0.79687500f,-0.84375000f,0.98437500f,-0.31250000f,0.68750000f,0.70312500f,0.60937500f,-0.23437500f,-0.46875000f,-0.67187500f,0.79687500f,-0.15625000f,-0.60937500f,0.93750000f,-0.85937500f,0.62500000f,-1.00000000f,0.06250000f,0.81250000f,0.06250000f,-0.42187500f,0.03125000f,-0.09375000f,0.56250000f,-0.25000000f,-0.90625000f,0.01562500f,-0.87500000f,0.89062500f,0.31250000f,-0.09375000f,0.45312500f,-0.20312500f,0.65625000f,-0.81250000f,0.54687500f,-0.10937500f,0.07812500f,0.51562500f,0.32812500f,0.82812500f,-0.12500000f,0.60937500f,0.90625000f,-0.75000000f,-0.60937500f,-0.60937500f,-0.70312500f,-0.82812500f,-0.43750000f,0.53125000f,-0.73437500f,0.78125000f,-0.20312500f,-0.23437500f,0.54687500f,0.03125000f,-0.85937500f,-0.57812500f,-0.70312500f,0.93750000f,0.87500000f,-0.64062500f,0.40625000f,-0.31250000f,-0.92187500f,0.73437500f,0.79687500f,-0.89062500f,0.03125000f,-0.81250000f,-0.20312500f,0.26562500f,0.37500000f,0.59375000f,-0.14062500f,-0.53125000f,-0.07812500f,0.03125000f,0.01562500f,0.50000000f,-0.68750000f,-0.42187500f,0.62500000f,0.31250000f,-0.35937500f,-0.57812500f,-0.79687500f,0.90625000f,-0.46875000f,-0.62500000f,-0.79687500f,0.12500000f,-0.29687500f,-0.76562500f,-0.32812500f,0.90625000f,0.40625000f,-0.26562500f,-0.28125000f,0.25000000f,0.59375000f,-0.25000000f,0.96875000f,-0.34375000f,-0.98437500f,-0.07812500f,0.54687500f,0.28125000f,-0.10937500f,0.93750000f,-0.50000000f,0.53125000f,0.87500000f,0.06250000f,-0.56250000f,-0.57812500f,0.50000000f,0.70312500f,0.29687500f,0.18750000f,-0.50000000f,0.21875000f,0.81250000f,0.14062500f,-0.48437500f,0.18750000f,0.29687500f,-0.75000000f,-0.32812500f,0.25000000f,0.65625000f,-0.43750000f,-0.75000000f,0.29687500f,0.14062500f,-0.15625000f,-0.64062500f,0.60937500f,0.57812500f,0.70312500f,0.65625000f,0.34375000f,-0.57812500f,0.56250000f,0.68750000f,0.37500000f,0.64062500f,0.65625000f,-0.48437500f,0.10937500f,-0.59375000f,-0.32812500f,0.48437500f,-0.98437500f,0.12500000f,1.00000000f,0.73437500f,-0.93750000f,-0.65625000f,0.96875000f,-0.28125000f,0.73437500f,-0.96875000f,0.70312500f,-0.67187500f,0.31250000f,-0.57812500f,-0.25000000f,0.21875000f,-0.73437500f,0.31250000f,0.00000000f,-0.03125000f,0.71875000f,-0.92187500f,-0.07812500f,-0.23437500f,0.20312500f,-0.35937500f,-0.51562500f,0.45312500f,0.73437500f,-0.54687500f,-0.48437500f,-0.67187500f,0.23437500f,-0.10937500f,-0.43750000f,-0.50000000f,-0.98437500f,0.03125000f,0.64062500f,0.29687500f,0.25000000f,-0.12500000f,-0.89062500f,0.45312500f,-0.39062500f,0.78125000f,0.25000000f,0.95312500f,-0.70312500f,-0.45312500f,0.17187500f,-0.20312500f,-0.12500000f,-0.28125000f,-0.03125000f,0.00000000f,-0.81250000f,-0.23437500f,-0.98437500f,0.06250000f,0.64062500f,-0.82812500f,0.21875000f,-0.87500000f,0.85937500f,0.39062500f,-0.18750000f,-0.45312500f,0.70312500f,-0.89062500f,-0.35937500f,0.45312500f,-0.57812500f,-0.03125000f,0.64062500f,0.48437500f,-0.70312500f,0.60937500f,-0.67187500f,-0.54687500f,-0.15625000f,-0.98437500f,-0.28125000f,-0.01562500f,0.21875000f,0.71875000f,0.29687500f,-0.40625000f,0.32812500f,-0.12500000f,0.09375000f,-0.71875000f,-0.04687500f,-0.89062500f,0.92187500f,-0.93750000f,-0.82812500f,0.68750000f,0.31250000f,0.84375000f,-0.81250000f,0.46875000f,0.37500000f,-0.45312500f,-0.87500000f,-0.15625000f,-0.04687500f,0.26562500f,0.96875000f,0.09375000f,0.25000000f,0.85937500f,-0.07812500f,0.76562500f,0.89062500f,0.00000000f,0.65625000f,-0.18750000f,-0.90625000f,0.21875000f,-0.57812500f,-0.51562500f,1.00000000f,0.32812500f,-0.57812500f,0.31250000f,0.96875000f,0.34375000f,0.56250000f,-0.68750000f,-0.03125000f,0.42187500f,-0.39062500f,0.79687500f,-0.46875000f,-0.73437500f,0.14062500f,0.64062500f,-0.10937500f,0.04687500f,0.73437500f,0.67187500f,0.90625000f,0.17187500f,0.15625000f,-0.59375000f,0.29687500f,-0.84375000f,-0.23437500f,0.03125000f,0.00000000f,-0.64062500f,-0.04687500f,1.00000000f,-0.79687500f,0.60937500f,0.64062500f,-0.54687500f,-0.03125000f,-0.65625000f,0.50000000f,0.45312500f,0.01562500f,0.45312500f,0.82812500f,-0.21875000f,-0.31250000f,0.64062500f,-0.32812500f,-0.26562500f,0.67187500f,0.85937500f,-0.26562500f,0.26562500f,0.57812500f,-0.26562500f,-0.75000000f,-0.56250000f,-0.71875000f,-1.00000000f,0.00000000f,-0.45312500f,0.70312500f,0.43750000f,0.59375000f,-0.04687500f,0.10937500f,0.39062500f,0.42187500f,0.87500000f,-0.89062500f,0.21875000f,0.40625000f,0.98437500f,-0.98437500f,-0.43750000f,0.75000000f,0.40625000f,0.64062500f,-0.51562500f,-0.53125000f,-0.35937500f,0.17187500f,-0.73437500f,0.62500000f,-0.25000000f,0.15625000f,0.32812500f,-0.31250000f,0.37500000f,0.98437500f,0.65625000f,-0.60937500f,-0.53125000f,-0.51562500f,-0.09375000f,0.15625000f,-0.60937500f,-0.07812500f,-0.95312500f,0.75000000f,0.81250000f,-0.15625000f,0.54687500f,0.56250000f,0.75000000f,0.12500000f,0.89062500f,-0.79687500f,0.07812500f,0.25000000f,0.92187500f,-0.78125000f,0.82812500f,-0.25000000f,-0.65625000f,-0.62500000f,0.60937500f,-0.75000000f,0.75000000f,0.43750000f,0.35937500f,-0.07812500f,0.17187500f,-0.42187500f,-0.45312500f,0.60937500f,0.75000000f,0.50000000f,-0.70312500f,1.00000000f,1.00000000f,-0.50000000f,0.32812500f,1.00000000f,-0.82812500f,-0.31250000f,-0.32812500f,-0.28125000f,-0.07812500f,0.89062500f,0.90625000f,0.81250000f,0.56250000f,-0.82812500f,-0.79687500f,-0.71875000f,0.90625000f,0.20312500f,0.09375000f,-0.45312500f,-0.06250000f,-0.65625000f,0.79687500f,-0.07812500f,-0.96875000f,-0.18750000f,-0.32812500f,0.34375000f,-0.12500000f,-0.25000000f,-0.60937500f,0.89062500f,0.75000000f,0.62500000f,-0.26562500f,-0.06250000f,0.70312500f,-0.62500000f,0.42187500f,-0.51562500f,0.87500000f,0.71875000f,0.92187500f,0.35937500f,0.75000000f,-0.15625000f,-0.34375000f,0.79687500f,0.21875000f,0.18750000f,-0.37500000f,-0.60937500f,0.42187500f,-0.93750000f,-0.20312500f,0.84375000f,-0.98437500f,-0.20312500f,-0.14062500f,0.82812500f,-0.78125000f,0.53125000f,-0.14062500f,0.04687500f,0.53125000f,0.21875000f,0.46875000f,-0.78125000f,-0.32812500f,-0.07812500f,-0.18750000f,-0.28125000f,-0.12500000f,-0.60937500f,-0.62500000f,0.06250000f,-0.01562500f,0.01562500f,-0.50000000f,-0.03125000f,-0.09375000f,0.45312500f,-0.95312500f,0.17187500f,-0.76562500f,0.45312500f,0.01562500f,0.73437500f,0.48437500f,0.04687500f,0.07812500f,0.35937500f,-0.81250000f,-0.39062500f,-0.20312500f,-0.56250000f,0.07812500f,-0.67187500f,-0.95312500f,-0.50000000f,-0.70312500f,-0.31250000f,-0.18750000f,-0.15625000f,0.64062500f,0.10937500f,-0.42187500f,0.46875000f,-0.35937500f,0.56250000f,-1.00000000f,0.03125000f,0.03125000f,-0.78125000f,0.09375000f,-0.37500000f,-0.75000000f,0.14062500f,-0.39062500f,0.54687500f,0.96875000f,-0.09375000f,-0.92187500f,0.54687500f,-0.15625000f,0.81250000f,0.93750000f,0.01562500f,-0.21875000f,0.10937500f,0.64062500f,-0.45312500f,0.87500000f,-0.42187500f,0.10937500f,0.95312500f,-0.06250000f,-0.87500000f,0.59375000f,0.35937500f,1.00000000f,0.95312500f,0.07812500f,0.39062500f,-1.00000000f,-0.89062500f,-0.42187500f,0.96875000f,-0.84375000f,-0.31250000f,-0.56250000f,-0.82812500f,-0.32812500f,-0.23437500f,-0.93750000f,-0.46875000f,0.79687500f,0.21875000f,-0.26562500f,-0.84375000f,0.60937500f,-0.07812500f,0.37500000f,0.29687500f,0.00000000f,-0.90625000f,-0.82812500f,0.62500000f,-0.92187500f,-0.09375000f,0.96875000f,-0.57812500f,-0.26562500f,0.06250000f,0.95312500f,0.31250000f,-0.07812500f,-1.00000000f,-0.95312500f,0.53125000f,-0.59375000f,0.78125000f,0.34375000f,-0.84375000f,0.34375000f,0.59375000f,0.17187500f,-0.92187500f,-0.07812500f,-0.62500000f,-0.71875000f,0.06250000f,0.50000000f,0.25000000f,0.37500000f,0.98437500f,-0.56250000f,0.51562500f,0.87500000f,-0.56250000f,0.73437500f,0.18750000f,0.17187500f,0.39062500f,0.32812500f,-0.48437500f,-0.92187500f,0.42187500f,-0.20312500f,-0.18750000f,0.20312500f,-0.51562500f,0.31250000f,0.50000000f,-0.60937500f,-0.17187500f,0.93750000f,-0.10937500f,-0.90625000f,0.42187500f,0.82812500f,-0.54687500f,0.92187500f,-0.62500000f,-0.60937500f,0.79687500f,-0.92187500f,-0.34375000f,0.79687500f,-0.26562500f,0.42187500f,-0.81250000f,0.98437500f,0.92187500f,-0.46875000f,-0.84375000f,0.10937500f,0.64062500f,0.60937500f,-0.45312500f,1.00000000f,-0.28125000f,0.89062500f,-0.60937500f,-0.68750000f,0.34375000f,-0.68750000f,0.00000000f,0.48437500f,-0.17187500f,0.68750000f,0.15625000f,0.84375000f,0.18750000f,-0.68750000f,0.60937500f,0.40625000f,-0.81250000f,0.90625000f,-0.76562500f,-0.62500000f,0.76562500f,0.45312500f,0.25000000f,-0.53125000f,-0.57812500f,0.96875000f,-0.76562500f,0.54687500f,0.48437500f,0.17187500f,0.53125000f,0.95312500f,0.25000000f,-0.60937500f,-0.20312500f,0.79687500f,0.89062500f,0.89062500f,-0.50000000f,0.92187500f,0.73437500f,0.57812500f,-0.92187500f,-0.65625000f,-0.92187500f,0.03125000f,-0.01562500f,0.82812500f,-0.78125000f,0.18750000f,0.96875000f,0.81250000f,0.18750000f,-0.03125000f,0.53125000f,-0.93750000f,-0.54687500f,-0.89062500f,-0.34375000f,0.17187500f,0.70312500f,0.34375000f,-0.28125000f,0.40625000f,-0.64062500f,0.37500000f,0.73437500f,-0.73437500f,-0.59375000f,-0.96875000f,0.73437500f,-0.92187500f,-0.26562500f,-0.32812500f,0.71875000f,0.28125000f,-0.12500000f,0.45312500f,0.32812500f,-0.96875000f,-0.29687500f,0.42187500f,-0.29687500f,-0.25000000f,-0.39062500f,-0.39062500f,-0.37500000f,-0.21875000f,0.65625000f,0.84375000f,-0.34375000f,-0.62500000f,-0.87500000f,-0.31250000f,0.03125000f,-0.09375000f,-0.98437500f,0.37500000f,0.39062500f,-0.46875000f,0.40625000f,0.57812500f,0.03125000f,0.50000000f,0.42187500f,-0.12500000f,-0.82812500f,-0.90625000f,0.29687500f,-0.42187500f,0.31250000f,0.98437500f,0.26562500f,-0.84375000f,0.14062500f,0.23437500f,-0.57812500f,0.87500000f,0.81250000f,-0.90625000f,-0.04687500f,-0.10937500f,0.10937500f,-0.10937500f,-0.73437500f,0.79687500f,-0.60937500f,-0.84375000f,0.10937500f,-0.62500000f,-0.14062500f,0.92187500f,-0.78125000f,0.81250000f,-0.32812500f,0.28125000f,-0.79687500f,-0.50000000f,-1.00000000f,-0.81250000f,-0.96875000f,0.81250000f,-0.04687500f,0.34375000f,0.04687500f,0.25000000f,-0.25000000f,0.45312500f,-0.17187500f,-0.42187500f,0.21875000f,0.54687500f,-0.42187500f,0.82812500f,0.43750000f,-0.25000000f,-0.78125000f,-0.48437500f,0.78125000f,0.20312500f,-0.43750000f,0.85937500f,-0.25000000f,0.51562500f,0.92187500f,0.75000000f,-0.14062500f,0.59375000f,0.93750000f,-0.65625000f,-0.28125000f,-0.78125000f,0.64062500f,-0.57812500f,0.67187500f,1.00000000f,0.50000000f,-0.17187500f,0.87500000f,-0.62500000f,-0.95312500f,0.20312500f,0.84375000f,-0.90625000f,0.53125000f,0.85937500f,-0.54687500f,-0.59375000f,0.90625000f,0.65625000f,0.14062500f,0.40625000f,-0.73437500f,-0.64062500f,-0.14062500f,-0.82812500f,0.89062500f,-0.90625000f,-0.32812500f,0.70312500f,-0.59375000f,-0.03125000f,0.62500000f,-0.06250000f,0.14062500f,0.89062500f,0.48437500f,0.10937500f,0.32812500f,0.28125000f,-0.68750000f,-0.79687500f,-0.89062500f,0.48437500f,0.46875000f,0.32812500f,0.87500000f,-0.67187500f,0.42187500f,0.06250000f,-0.53125000f,-0.32812500f,-0.95312500f,-0.17187500f,0.23437500f,-0.50000000f,-0.93750000f,0.89062500f,-0.85937500f,-0.54687500f,-0.70312500f,-0.92187500f,0.46875000f,0.82812500f,0.56250000f,0.84375000f,-0.09375000f,-0.73437500f,-0.53125000f,-0.07812500f,-0.43750000f,-0.62500000f,-0.93750000f,-0.34375000f,0.20312500f,-0.01562500f,0.14062500f,0.85937500f,0.48437500f,0.09375000f,0.60937500f,0.81250000f,0.67187500f,-0.59375000f,0.60937500f,0.15625000f,-0.14062500f,-0.09375000f,0.60937500f,0.06250000f,0.84375000f,0.01562500f,0.34375000f,-0.15625000f,0.51562500f,-0.64062500f,0.57812500f,0.00000000f,0.25000000f,0.42187500f,0.57812500f,0.23437500f,-0.50000000f,-0.35937500f,0.35937500f,0.65625000f,-0.50000000f,-0.64062500f,0.37500000f,0.65625000f,0.57812500f,-0.25000000f,-0.60937500f,0.46875000f,0.21875000f,-0.56250000f,0.09375000f,0.95312500f,-0.71875000f,0.57812500f,-0.50000000f,-0.12500000f,-0.01562500f,0.50000000f,-0.09375000f,0.64062500f,-0.17187500f,0.76562500f,0.48437500f,-0.70312500f,-0.20312500f,-0.92187500f,-0.26562500f,0.00000000f,-0.51562500f,-0.57812500f,0.87500000f,-0.21875000f,0.21875000f,0.26562500f,-0.26562500f,-0.09375000f,0.65625000f,-0.20312500f,0.04687500f,-0.31250000f,-0.42187500f,-0.60937500f,-0.29687500f,-0.06250000f,0.37500000f,-0.51562500f,0.84375000f,-0.10937500f,0.28125000f,0.65625000f,0.79687500f,0.26562500f,-0.37500000f,-0.26562500f,0.39062500f,-0.93750000f,0.46875000f,-0.59375000f,0.18750000f,-0.37500000f,0.25000000f,0.03125000f,0.37500000f,-0.12500000f,0.68750000f,-0.93750000f,-0.12500000f,-0.42187500f,0.20312500f,0.73437500f,-0.46875000f,0.98437500f,0.42187500f,0.34375000f,-0.51562500f,-0.98437500f,0.82812500f,-0.25000000f,-0.48437500f,0.17187500f,0.04687500f,0.67187500f,-0.35937500f,0.43750000f,0.18750000f,0.76562500f,-0.68750000f,0.90625000f,-0.31250000f,0.95312500f,0.78125000f,-0.95312500f,0.09375000f,0.06250000f,-0.89062500f,-0.04687500f,0.40625000f,-0.14062500f,-0.17187500f,-0.09375000f,-0.76562500f,0.32812500f,-0.35937500f,-0.17187500f,0.60937500f,-0.98437500f,-0.28125000f,0.32812500f,-0.51562500f,0.46875000f,0.87500000f,0.98437500f,-0.93750000f,0.03125000f,0.37500000f,-0.48437500f,0.17187500f,-0.79687500f,-0.92187500f,0.73437500f,-0.85937500f,0.21875000f,0.95312500f,-0.23437500f,0.26562500f,-0.51562500f,-0.64062500f,-0.25000000f,0.21875000f,0.53125000f,0.57812500f,-0.79687500f,-0.10937500f,-0.17187500f,-0.60937500f,-0.20312500f,0.93750000f,-0.09375000f,-0.76562500f,0.89062500f,0.64062500f,-0.87500000f,-0.28125000f,-0.31250000f,0.35937500f,0.56250000f,0.84375000f,-0.01562500f,0.40625000f,-0.78125000f,-0.14062500f,0.20312500f,-0.32812500f,0.18750000f,-0.70312500f,-0.62500000f,0.73437500f,-0.42187500f,0.40625000f,-0.67187500f,-0.53125000f,0.32812500f,-0.65625000f,0.60937500f,0.25000000f,-0.37500000f,-0.89062500f,-0.70312500f,0.48437500f,-0.26562500f,0.35937500f,-0.43750000f,-0.35937500f,0.67187500f,0.06250000f,-0.20312500f,0.32812500f,0.59375000f,-0.68750000f,0.59375000f,0.50000000f,-0.98437500f,-0.60937500f,-0.79687500f,0.32812500f,0.79687500f,0.76562500f,0.79687500f,-0.45312500f,0.46875000f,0.78125000f,0.89062500f,0.28125000f,-0.50000000f,0.98437500f,0.82812500f,-0.06250000f,-0.95312500f,-0.51562500f,0.75000000f,-0.25000000f,0.43750000f,0.89062500f,-0.70312500f,-0.95312500f,-0.98437500f,-0.73437500f,-0.71875000f,-0.98437500f,-0.34375000f,-0.45312500f,0.40625000f,-0.60937500f,-0.53125000f,0.68750000f,-0.37500000f,-0.18750000f,-0.04687500f,-0.45312500f,1.00000000f,0.92187500f,0.50000000f,-0.50000000f,0.89062500f,0.34375000f,-0.64062500f,0.48437500f,-0.40625000f,-0.51562500f,0.48437500f,-0.39062500f,-0.15625000f,-0.34375000f,0.26562500f,0.26562500f,0.10937500f,0.85937500f,-0.53125000f,0.03125000f,0.84375000f,0.93750000f,0.67187500f,0.29687500f,-0.92187500f,0.23437500f,0.25000000f,-0.23437500f,-0.57812500f,0.68750000f,-0.62500000f,-0.68750000f,0.09375000f,-0.25000000f,-0.79687500f,-0.51562500f,-0.96875000f,-0.78125000f,0.14062500f,0.62500000f,-0.59375000f,-0.45312500f,-0.45312500f,0.00000000f,0.90625000f,-0.85937500f,0.45312500f,0.68750000f,0.62500000f,0.78125000f,-0.26562500f,0.92187500f,-0.90625000f,-0.89062500f,-0.29687500f,-0.48437500f,-0.14062500f,0.76562500f,0.48437500f,-0.59375000f,0.93750000f,-0.29687500f,-0.21875000f,0.79687500f,-0.50000000f,0.87500000f,0.70312500f,-0.65625000f,0.93750000f,0.45312500f,0.26562500f,-0.43750000f,-0.57812500f,0.65625000f,-0.23437500f,-0.67187500f,-0.82812500f,-0.20312500f,-0.40625000f,0.92187500f,0.93750000f,0.20312500f,0.26562500f,-0.50000000f,0.04687500f,-0.43750000f,0.76562500f,-0.37500000f,-0.51562500f,-0.31250000f,-0.59375000f,-0.60937500f,0.98437500f,1.00000000f,-0.62500000f,0.12500000f,0.46875000f,-0.37500000f,0.85937500f,0.62500000f,-0.46875000f,0.01562500f,0.96875000f,-0.17187500f,-0.54687500f,-0.29687500f,-0.95312500f,-0.76562500f,0.12500000f,0.75000000f,0.35937500f,0.81250000f,0.68750000f,-0.54687500f,0.62500000f,-0.12500000f,1.00000000f,0.60937500f,0.81250000f,-0.71875000f,-0.84375000f,-0.82812500f,0.09375000f,-0.85937500f,-0.14062500f,0.93750000f,-0.75000000f,-0.12500000f,0.23437500f,-0.39062500f,-0.26562500f,0.10937500f,-0.32812500f,0.87500000f,0.92187500f,-0.15625000f,0.54687500f,-0.15625000f,0.95312500f,0.26562500f,0.39062500f,-0.42187500f,-0.92187500f,0.32812500f,-0.34375000f,-0.39062500f,-0.90625000f,0.32812500f,-0.23437500f,-0.59375000f,-0.73437500f,0.85937500f,0.35937500f,0.40625000f,-0.42187500f,0.29687500f,0.57812500f,-0.03125000f,-0.01562500f,-0.48437500f,-0.87500000f,-0.76562500f,0.60937500f,0.93750000f,-0.76562500f,0.37500000f,0.35937500f,-0.23437500f,-0.56250000f,-0.84375000f,0.54687500f,0.37500000f,-0.39062500f,0.78125000f,0.57812500f,0.10937500f,-0.29687500f,-0.56250000f,0.29687500f,-0.21875000f,-0.71875000f,0.21875000f,0.12500000f,0.43750000f,-0.98437500f,-0.75000000f,0.35937500f,0.04687500f,0.46875000f,0.51562500f,-1.00000000f,0.37500000f,-0.01562500f,-0.04687500f,0.00000000f,-0.12500000f,-0.03125000f,0.51562500f,0.23437500f,0.15625000f,0.87500000f,-0.92187500f,-0.89062500f,1.00000000f,-0.71875000f,-0.12500000f,-0.06250000f,-0.45312500f,-0.85937500f,0.25000000f,0.67187500f,-0.89062500f,0.95312500f,-0.10937500f,-0.85937500f,-0.29687500f,-0.17187500f,0.95312500f,-0.60937500f,0.00000000f,-0.65625000f,-0.34375000f,0.25000000f,-0.37500000f,0.17187500f,-0.73437500f,-0.25000000f,0.48437500f,-0.03125000f,-0.60937500f,0.26562500f,0.64062500f,-0.26562500f,0.28125000f,0.90625000f,-0.25000000f,-0.84375000f,-0.84375000f,0.67187500f,0.67187500f,-0.01562500f,-0.14062500f,0.62500000f,0.39062500f,0.56250000f,0.14062500f,-0.56250000f,0.14062500f,-0.68750000f,-0.78125000f,-0.03125000f,0.59375000f,0.31250000f,0.98437500f,0.78125000f,-0.21875000f,0.17187500f,-0.90625000f,0.48437500f,-0.81250000f,0.76562500f,0.04687500f,0.57812500f,0.57812500f,0.42187500f,-0.17187500f,-0.64062500f,0.60937500f,-0.25000000f,-0.96875000f,0.68750000f,0.29687500f,-0.01562500f,0.54687500f,-0.21875000f,0.37500000f,0.98437500f,-0.59375000f,-0.87500000f,-0.95312500f,-0.48437500f,-0.18750000f,0.95312500f,-0.23437500f,-0.21875000f,-0.68750000f,-0.21875000f,-0.42187500f,0.34375000f,0.03125000f,0.06250000f,0.95312500f,0.31250000f,-0.34375000f,0.32812500f,0.84375000f,0.06250000f,0.06250000f,-0.23437500f,-0.90625000f,-0.39062500f,0.54687500f,0.03125000f,0.53125000f,-0.85937500f,-0.92187500f,-0.85937500f,0.64062500f,-0.96875000f,-0.29687500f,0.46875000f,-0.42187500f,-0.23437500f,-0.81250000f,-0.04687500f,-0.82812500f,0.14062500f,0.93750000f,-0.10937500f,-0.01562500f,0.56250000f,-0.03125000f,0.96875000f,0.50000000f,0.98437500f,0.18750000f,-0.37500000f,0.06250000f,0.46875000f,0.81250000f,0.82812500f,-0.67187500f,-0.62500000f,-0.15625000f,0.70312500f,0.46875000f,-0.18750000f,0.06250000f,0.06250000f,0.04687500f,-0.32812500f,-0.28125000f,-0.73437500f,-0.89062500f,-0.26562500f,-0.14062500f,-0.98437500f,-0.07812500f,0.64062500f,-0.07812500f,-0.98437500f,-0.01562500f,-0.60937500f,0.28125000f,-0.96875000f,0.93750000f,0.46875000f,0.62500000f,0.31250000f,-0.76562500f,0.68750000f,-0.89062500f,-0.96875000f,0.92187500f,-0.68750000f,-0.50000000f,-0.84375000f,0.15625000f,0.28125000f,-0.92187500f,-0.54687500f,-0.67187500f,-0.89062500f,-0.06250000f,0.00000000f,-0.14062500f,-0.43750000f,0.95312500f,0.70312500f,0.42187500f,0.64062500f,-0.14062500f,0.89062500f,0.25000000f,-0.34375000f,-0.64062500f,-0.84375000f,0.96875000f,-0.81250000f,-0.84375000f,0.92187500f,-0.26562500f,1.00000000f,-0.03125000f,0.12500000f,0.04687500f,0.29687500f,0.00000000f,0.68750000f,-0.34375000f,0.03125000f,-0.89062500f,0.89062500f,0.04687500f,-0.64062500f,-0.87500000f,0.01562500f,0.18750000f,-0.23437500f,-0.64062500f,-0.84375000f,0.43750000f,0.87500000f,-0.29687500f,0.26562500f,-0.68750000f,-0.40625000f,0.78125000f,0.76562500f,-0.92187500f,-0.92187500f,0.14062500f,0.26562500f,-0.46875000f,0.40625000f,-0.01562500f,0.53125000f,0.57812500f,-0.96875000f,-0.93750000f,-0.96875000f,-0.60937500f,0.76562500f,0.79687500f,0.26562500f,0.25000000f,-0.62500000f,0.87500000f,-0.39062500f,0.04687500f,-0.03125000f,0.14062500f,-0.15625000f,0.18750000f,0.87500000f,-0.04687500f,-0.96875000f,-1.00000000f,-0.28125000f,-0.96875000f,0.95312500f,-0.09375000f,-0.48437500f,0.92187500f,0.87500000f,-0.65625000f,-0.67187500f,-0.32812500f,-0.07812500f,-0.31250000f,-0.37500000f,0.75000000f,-0.35937500f,0.20312500f,-0.59375000f,-0.87500000f,-0.12500000f,-0.59375000f,0.87500000f,0.81250000f,-0.81250000f,-0.37500000f,0.96875000f,-0.31250000f,0.06250000f,-0.65625000f,0.73437500f,0.59375000f,-0.34375000f,0.31250000f,0.54687500f,-0.12500000f,0.17187500f,-0.42187500f,-0.76562500f,0.50000000f,0.10937500f,-0.21875000f,0.89062500f,-0.56250000f,-0.15625000f,0.06250000f,-0.01562500f,0.40625000f,-0.89062500f,-0.37500000f,-0.70312500f,-0.82812500f,0.17187500f,-0.09375000f,0.18750000f,0.67187500f,-0.17187500f,0.62500000f,0.07812500f,0.62500000f,-0.90625000f,-0.71875000f,0.95312500f,-0.23437500f,-1.00000000f,-0.20312500f,0.20312500f,-0.54687500f,0.12500000f,-0.54687500f,-0.64062500f,0.89062500f,-0.01562500f,-0.71875000f,-0.10937500f,0.89062500f,-0.04687500f,-0.29687500f,0.34375000f,0.46875000f,0.71875000f,0.64062500f,0.82812500f,-0.54687500f,-0.43750000f,0.53125000f,-0.64062500f,0.56250000f,0.25000000f,-0.51562500f,0.93750000f,0.21875000f,0.62500000f,-0.10937500f,-0.75000000f,-0.29687500f,0.07812500f,-0.14062500f,0.06250000f,0.15625000f,-0.76562500f,0.75000000f,-0.43750000f,0.20312500f,0.65625000f,-0.89062500f,-0.95312500f,-0.26562500f,-0.76562500f,0.76562500f,0.03125000f,0.28125000f,-0.09375000f,0.92187500f,-0.59375000f,-0.12500000f,0.39062500f,-0.79687500f,-0.85937500f,-0.25000000f,-0.03125000f,-0.26562500f,-0.01562500f,0.31250000f,-0.96875000f,0.20312500f,-0.32812500f,-0.34375000f,0.29687500f,-0.12500000f,-0.70312500f,-0.31250000f,0.60937500f,0.54687500f,-0.78125000f,0.25000000f,-0.42187500f,-0.90625000f,-0.03125000f,-1.00000000f,0.18750000f,-0.09375000f,0.92187500f,-0.53125000f,0.79687500f,0.35937500f,-0.98437500f,-0.26562500f,-0.67187500f,0.59375000f,0.32812500f,0.26562500f,0.84375000f,0.43750000f,0.78125000f,-0.54687500f,-0.32812500f,0.26562500f,0.01562500f,-0.48437500f,-0.43750000f,0.23437500f,-0.84375000f,-0.18750000f,0.48437500f,0.09375000f,-0.40625000f,-0.14062500f,-0.96875000f,0.75000000f,0.37500000f,-0.60937500f,-0.70312500f,-0.23437500f,0.92187500f,-0.31250000f,-0.57812500f,-0.78125000f,0.17187500f,0.51562500f,-0.78125000f,0.90625000f,0.29687500f,-0.31250000f,0.48437500f,-0.59375000f,0.75000000f,-0.07812500f,0.93750000f,0.95312500f,0.29687500f,0.10937500f,0.20312500f,0.03125000f,0.59375000f,0.23437500f,-0.29687500f,-0.82812500f,0.09375000f,0.85937500f,0.31250000f,0.17187500f,-0.70312500f,-0.84375000f,-0.03125000f,0.31250000f,-0.96875000f,-1.00000000f,-0.28125000f,-0.48437500f,-0.09375000f,0.95312500f,-0.85937500f,-0.10937500f,0.17187500f,-0.67187500f,0.25000000f,-0.78125000f,0.46875000f,-0.23437500f,0.84375000f,0.00000000f,0.43750000f,-0.84375000f,0.48437500f,1.00000000f,0.17187500f,0.21875000f,-0.79687500f,0.54687500f,0.92187500f,-0.01562500f,0.64062500f,0.12500000f,-0.89062500f,-0.06250000f,-0.18750000f,0.81250000f,0.42187500f,0.03125000f,-0.93750000f,-0.59375000f,-0.07812500f,0.28125000f,0.78125000f,-0.26562500f,0.79687500f,0.28125000f,-0.25000000f,-0.40625000f,-0.39062500f,0.01562500f,-0.26562500f,0.34375000f,-0.85937500f,-0.85937500f,-0.42187500f,-0.68750000f,-0.76562500f,0.54687500f,-0.21875000f,0.20312500f,-0.35937500f,-0.50000000f,0.57812500f,-0.17187500f,-0.57812500f,-0.51562500f,-0.12500000f,-0.76562500f,0.56250000f,-0.92187500f,0.14062500f,0.45312500f,-0.18750000f,-0.40625000f,0.87500000f,0.51562500f,-0.67187500f,-0.81250000f,0.32812500f,0.42187500f,0.34375000f,0.31250000f,0.65625000f,0.57812500f,-0.75000000f,0.06250000f,0.40625000f,0.48437500f,0.56250000f,-0.85937500f,0.09375000f,-0.17187500f,0.40625000f,-0.73437500f,0.09375000f,0.32812500f,-0.40625000f,-0.68750000f,0.54687500f,0.06250000f,-0.70312500f,-0.75000000f,-0.48437500f,-0.75000000f,-0.70312500f,0.35937500f,0.96875000f,0.18750000f,-0.28125000f,-0.57812500f,-0.98437500f,-0.26562500f,-0.64062500f,0.73437500f,-0.85937500f,0.68750000f,-0.48437500f,0.35937500f,-0.50000000f,-0.78125000f,-0.39062500f,0.28125000f,0.06250000f,0.18750000f,0.59375000f,-0.48437500f,-0.82812500f,-0.48437500f,0.60937500f,0.93750000f,-0.90625000f,0.46875000f,0.76562500f,0.53125000f,-0.56250000f,-0.26562500f,-0.29687500f,-0.18750000f,-0.34375000f,-0.56250000f,-0.81250000f,-0.96875000f,-0.10937500f,0.82812500f,0.64062500f,0.43750000f,0.54687500f,-0.48437500f,-0.65625000f,0.23437500f,-0.04687500f,-0.56250000f,0.79687500f,0.12500000f,0.67187500f,0.26562500f,-0.32812500f,-0.39062500f,-0.59375000f,-0.93750000f,0.87500000f,-0.98437500f,-0.10937500f,0.60937500f,0.79687500f,-0.68750000f,-0.45312500f,0.39062500f,0.92187500f,0.79687500f,-0.93750000f,-0.15625000f,-0.53125000f,0.25000000f,-0.31250000f,-0.56250000f,-0.28125000f,-0.78125000f,-0.56250000f,0.21875000f,0.14062500f,-0.96875000f,-0.28125000f,0.78125000f,-0.59375000f,-0.68750000f,0.73437500f,-0.62500000f,-0.64062500f,0.32812500f,-0.76562500f,0.98437500f,-0.43750000f,0.28125000f,0.75000000f,0.12500000f,0.06250000f,0.85937500f,0.71875000f,0.39062500f,0.43750000f,1.00000000f,-0.85937500f,0.18750000f,-0.14062500f,0.34375000f,0.46875000f,0.42187500f,0.45312500f,0.43750000f,-0.09375000f,0.29687500f,-0.57812500f,-0.73437500f,-0.54687500f,-0.17187500f,-0.29687500f,-0.82812500f,0.35937500f,0.18750000f,-0.06250000f,-0.54687500f,-0.65625000f,0.71875000f,0.46875000f,0.70312500f,-0.03125000f,1.00000000f,0.29687500f,-0.85937500f,0.35937500f,-0.29687500f,-0.87500000f,0.25000000f,0.21875000f,0.14062500f,0.65625000f,0.70312500f,0.70312500f,-0.09375000f,-0.68750000f,-0.40625000f,0.00000000f,-0.51562500f,-0.68750000f,0.51562500f,0.14062500f,0.12500000f,-0.68750000f,0.85937500f,0.73437500f,0.17187500f,-0.90625000f,-0.07812500f,0.84375000f,0.98437500f,-0.96875000f,0.78125000f,-0.78125000f,-0.70312500f,0.82812500f,-0.42187500f,0.29687500f,-0.43750000f,0.37500000f,0.00000000f,0.87500000f,-0.37500000f,-0.48437500f,0.04687500f,-0.07812500f,0.07812500f,0.42187500f,-0.37500000f,0.76562500f,-0.76562500f,0.95312500f,-0.76562500f,0.53125000f,0.46875000f,0.46875000f,-0.87500000f,0.40625000f,0.23437500f,0.26562500f,-0.79687500f,-0.82812500f,0.23437500f,0.89062500f,-0.25000000f,0.68750000f,-0.42187500f,0.12500000f,0.78125000f,-0.42187500f,-0.34375000f,0.51562500f,0.21875000f,-0.62500000f,0.50000000f,-0.68750000f,-0.29687500f,-0.15625000f,-0.76562500f,-0.32812500f,-0.26562500f,0.64062500f,-0.15625000f,0.92187500f,0.42187500f,-0.75000000f,0.43750000f,-0.04687500f,0.40625000f,-0.62500000f,-0.01562500f,-0.76562500f,0.34375000f,0.00000000f,0.98437500f,-0.29687500f,-0.93750000f,-0.53125000f,-0.25000000f,-0.28125000f,-0.96875000f,0.01562500f,-0.01562500f,-0.09375000f,0.64062500f,0.95312500f,0.00000000f,-0.81250000f,-0.73437500f,-0.04687500f,0.75000000f,0.09375000f,-0.21875000f,-0.35937500f,-0.67187500f,-0.07812500f,-0.87500000f,0.81250000f,-0.28125000f,0.17187500f,0.34375000f,0.75000000f,0.75000000f,-0.03125000f,0.25000000f,0.82812500f,0.12500000f,0.45312500f,0.57812500f,-0.60937500f,0.15625000f,0.87500000f,0.73437500f,-0.39062500f,-0.56250000f,0.84375000f,-0.82812500f,0.57812500f,0.81250000f,-0.06250000f,1.00000000f,-0.60937500f,-0.85937500f,0.81250000f,-0.70312500f,-0.54687500f,0.10937500f,-0.12500000f,0.73437500f,0.14062500f,-0.65625000f,-0.15625000f,0.06250000f,1.00000000f,-0.07812500f,-0.07812500f,0.48437500f,-0.64062500f,-0.82812500f,0.51562500f,0.96875000f,0.56250000f,0.28125000f,0.71875000f,-0.87500000f,1.00000000f,0.90625000f,-0.79687500f,-0.81250000f,0.85937500f,0.35937500f,0.35937500f,-0.75000000f,-0.84375000f,0.39062500f,0.62500000f,0.51562500f,0.14062500f,0.32812500f,0.15625000f,0.48437500f,-0.37500000f,0.40625000f,0.48437500f,-0.79687500f,-0.96875000f,0.43750000f,-0.21875000f,-0.26562500f,-1.00000000f,-0.53125000f,-0.89062500f,-0.84375000f,0.71875000f,0.17187500f,-0.43750000f,0.09375000f,0.84375000f,-0.14062500f,0.57812500f,0.90625000f,0.07812500f,-0.23437500f,-0.95312500f,-0.53125000f,-0.75000000f,0.21875000f,0.82812500f,0.23437500f,-0.57812500f,-0.90625000f,-0.56250000f,0.59375000f,-0.98437500f,0.68750000f,0.76562500f,0.04687500f,-0.09375000f,-0.45312500f,-0.25000000f,0.03125000f,-0.81250000f,-0.04687500f,0.82812500f,-0.10937500f,-0.70312500f,-0.68750000f,-0.71875000f,0.82812500f,0.34375000f,-0.42187500f,-0.35937500f,-0.43750000f,-0.62500000f,-0.21875000f,0.75000000f,-0.06250000f,0.50000000f,-0.06250000f,-0.29687500f,0.93750000f,0.92187500f,-0.60937500f,-0.54687500f,-0.62500000f,0.79687500f,0.15625000f,0.62500000f,0.68750000f,0.92187500f,-0.50000000f,0.93750000f,-0.23437500f,-0.12500000f,0.68750000f,0.15625000f,-0.18750000f,-0.67187500f,0.60937500f,0.64062500f,0.04687500f,-1.00000000f,0.32812500f,0.29687500f,0.79687500f,-0.64062500f,-0.65625000f,-0.98437500f,-0.59375000f,-0.60937500f,-0.73437500f,0.82812500f,0.75000000f,0.10937500f,0.68750000f,-0.35937500f,-0.23437500f,-0.15625000f,-0.90625000f,-0.15625000f,0.84375000f,-0.37500000f,0.37500000f,-0.35937500f,0.89062500f,0.31250000f,0.28125000f,-0.82812500f,-0.89062500f,0.54687500f,-0.62500000f,-0.51562500f,-0.60937500f,-0.48437500f,0.01562500f,-0.21875000f,-0.76562500f,0.45312500f,0.85937500f,0.50000000f,-0.98437500f,0.00000000f,0.39062500f,-0.60937500f,-0.89062500f,0.17187500f,-0.28125000f,0.12500000f,-0.21875000f,0.43750000f,0.29687500f,-0.75000000f,0.50000000f,0.92187500f,0.00000000f,0.57812500f,0.95312500f,0.46875000f,-0.89062500f,-0.79687500f,-0.10937500f,-0.37500000f,0.57812500f,-0.50000000f,-0.40625000f,0.57812500f,-0.75000000f,0.40625000f,0.59375000f,-0.78125000f,0.26562500f,0.75000000f,0.70312500f,-1.00000000f,0.32812500f,0.34375000f,-0.45312500f,-0.48437500f,-0.21875000f,0.60937500f,-0.03125000f,-0.57812500f,0.26562500f,0.89062500f,0.84375000f,1.00000000f,0.67187500f,0.89062500f,-0.06250000f,0.56250000f,-0.68750000f,0.95312500f,-0.85937500f,-0.17187500f,0.28125000f,-0.45312500f,0.00000000f,-0.54687500f,-0.35937500f,-0.59375000f,0.29687500f,-0.35937500f,0.09375000f,0.73437500f,0.70312500f,0.04687500f,-0.10937500f,0.34375000f,-0.92187500f,0.92187500f,-0.98437500f,0.42187500f,-0.67187500f,0.28125000f,0.25000000f,-0.46875000f,0.26562500f,-0.59375000f,0.12500000f,0.59375000f,-0.31250000f,-0.31250000f,-0.18750000f,-0.14062500f,-0.31250000f,-0.46875000f,-0.31250000f,0.00000000f,0.10937500f,1.00000000f,-0.50000000f,0.18750000f,-0.70312500f,-0.81250000f,0.50000000f,-0.53125000f,0.18750000f,-0.79687500f,0.42187500f,-0.78125000f,-1.00000000f,-0.25000000f,0.46875000f,1.00000000f,0.76562500f,0.48437500f,-0.40625000f,0.64062500f,-0.81250000f,-0.23437500f,0.56250000f,0.14062500f,0.04687500f,0.81250000f,-0.51562500f,0.71875000f,-0.04687500f,-0.57812500f,0.64062500f,0.48437500f,1.00000000f,0.50000000f,-0.93750000f,-0.14062500f,-0.09375000f,0.56250000f,0.64062500f,-0.92187500f,0.75000000f,-0.67187500f,-0.82812500f,0.78125000f,-0.39062500f,-0.45312500f,0.15625000f,-0.29687500f,0.12500000f,0.67187500f,0.21875000f,0.84375000f,0.14062500f,-0.04687500f,0.00000000f,-0.64062500f,-0.82812500f,-0.87500000f,0.89062500f,-0.20312500f,-0.73437500f,-0.78125000f,0.42187500f,0.48437500f,1.00000000f,-0.07812500f,0.90625000f,-0.50000000f,0.68750000f,-0.45312500f,0.28125000f,-0.10937500f,0.00000000f,-0.01562500f,0.29687500f,0.92187500f,0.09375000f,-0.07812500f,0.87500000f,-0.76562500f,0.43750000f,0.53125000f,-0.90625000f,0.51562500f,-0.85937500f,-0.76562500f,0.45312500f,0.92187500f,0.56250000f,0.07812500f,-0.04687500f,-1.00000000f,-0.96875000f,-0.46875000f,0.76562500f,0.62500000f,-0.68750000f,0.59375000f,-0.62500000f,0.34375000f,-0.12500000f,-0.59375000f,-0.32812500f,0.39062500f,-0.18750000f,0.37500000f,-0.96875000f,-0.98437500f,-0.62500000f,-0.65625000f,-0.42187500f,0.68750000f,0.96875000f,-0.42187500f,0.09375000f,-0.89062500f,0.17187500f,-0.01562500f,-0.54687500f,-0.81250000f,-0.43750000f,-0.75000000f,-0.01562500f,-0.39062500f,0.51562500f,-0.95312500f,0.04687500f,-0.95312500f,0.70312500f,0.25000000f,0.73437500f,-0.75000000f,0.12500000f,0.53125000f,-0.62500000f,-0.51562500f,0.20312500f,0.73437500f,-0.39062500f,-0.26562500f,-0.60937500f,-0.28125000f,-0.78125000f,-0.50000000f,-0.53125000f,-0.31250000f,0.43750000f,0.14062500f,0.48437500f,0.85937500f,-0.98437500f,0.45312500f,0.89062500f,-0.89062500f,-0.79687500f,0.54687500f,-0.67187500f,-0.26562500f,0.90625000f,0.07812500f,0.71875000f,-0.93750000f,0.95312500f,0.34375000f,0.90625000f,0.92187500f,0.40625000f,0.06250000f,-0.06250000f,0.75000000f,-0.50000000f,-0.78125000f,-0.68750000f,-0.65625000f,-0.48437500f,0.76562500f,0.70312500f,-0.25000000f,0.70312500f,-0.73437500f,0.51562500f,-0.64062500f,-0.85937500f,-0.92187500f,-0.81250000f,0.01562500f,-0.78125000f,0.20312500f,-0.46875000f,-0.70312500f,0.32812500f,-0.26562500f,-0.34375000f,0.43750000f,-0.60937500f,0.00000000f,-0.09375000f,0.25000000f,-0.07812500f,-0.75000000f,0.71875000f,0.39062500f,0.64062500f,-0.68750000f,-0.03125000f,0.62500000f,-0.68750000f,0.28125000f,-0.35937500f,0.95312500f,0.00000000f,-0.60937500f,-0.34375000f,0.18750000f,-0.62500000f,-0.23437500f,-0.25000000f,-0.70312500f,0.17187500f,0.45312500f,0.31250000f,0.43750000f,0.71875000f,-0.84375000f,0.75000000f,-0.28125000f,0.62500000f,-0.54687500f,0.28125000f,0.14062500f,-0.75000000f,-0.29687500f,-0.65625000f,-0.71875000f,-0.50000000f,0.37500000f,-0.93750000f,0.82812500f,0.53125000f,-0.70312500f,0.73437500f,-0.34375000f,-0.60937500f,-0.84375000f,-0.62500000f,0.75000000f,0.84375000f,0.79687500f,0.56250000f,0.87500000f,0.25000000f,-0.21875000f,-0.82812500f,-0.39062500f,-0.18750000f,0.07812500f,-0.90625000f,0.73437500f,0.00000000f,-0.34375000f,0.76562500f,-0.09375000f,0.45312500f,-0.81250000f,0.75000000f,-0.79687500f,0.28125000f,-0.25000000f,-0.57812500f,-0.64062500f,-0.31250000f,0.68750000f,0.35937500f,-0.21875000f,0.82812500f,0.06250000f,0.54687500f,0.34375000f,0.14062500f,0.96875000f,-0.50000000f,-0.40625000f,0.54687500f,-0.93750000f,0.23437500f,-0.39062500f,0.57812500f,0.82812500f,-0.28125000f,0.17187500f,0.82812500f,-0.21875000f,-0.96875000f,-0.42187500f,1.00000000f,-0.79687500f,-0.95312500f,-0.76562500f,-0.68750000f,-0.92187500f,-0.10937500f,0.60937500f,-0.78125000f,-0.56250000f,-0.90625000f,-0.84375000f,-1.00000000f,-1.00000000f,-0.96875000f,0.01562500f,-0.75000000f,-0.50000000f,0.26562500f,0.51562500f,-0.17187500f,-0.46875000f,-0.26562500f,-0.43750000f,-0.48437500f,-0.46875000f,-0.21875000f,0.18750000f,0.43750000f,0.12500000f,-0.10937500f,0.37500000f,-0.54687500f,-0.95312500f,-0.75000000f,0.10937500f,-0.84375000f,0.64062500f,0.00000000f,0.56250000f,0.12500000f,-0.71875000f,-0.95312500f,0.81250000f,-0.18750000f,-0.70312500f,0.79687500f,-0.03125000f,-0.84375000f,0.50000000f,0.28125000f,0.23437500f,0.54687500f,-0.37500000f,-0.17187500f,0.45312500f,-0.90625000f,0.65625000f,0.73437500f,-0.43750000f,-0.06250000f,-0.46875000f,-0.54687500f,0.65625000f,-0.07812500f,0.35937500f,0.84375000f,0.82812500f,-0.64062500f,0.78125000f,0.20312500f,0.14062500f,-0.35937500f,-0.40625000f,1.00000000f,-0.89062500f,-1.00000000f,-0.07812500f,0.54687500f,0.34375000f,-0.56250000f,-0.57812500f,0.03125000f,-0.32812500f,0.76562500f,-0.43750000f,-0.56250000f,-0.12500000f,-0.17187500f,0.92187500f,0.56250000f,0.78125000f,-0.75000000f,0.95312500f,-0.23437500f,-0.15625000f,-0.37500000f,0.35937500f,0.06250000f,-0.39062500f,-0.14062500f,-0.92187500f,-0.12500000f,0.56250000f,0.79687500f,-0.70312500f,-0.92187500f,0.35937500f,0.71875000f,0.93750000f,0.57812500f,-0.96875000f,-0.03125000f,0.85937500f,0.48437500f,0.10937500f,0.68750000f,-0.10937500f,-0.45312500f,0.40625000f,0.07812500f,0.40625000f,0.35937500f,-0.25000000f,-0.14062500f,-0.84375000f,0.31250000f,-0.20312500f,-0.98437500f,-0.75000000f,0.15625000f,-0.46875000f,1.00000000f,0.43750000f,0.35937500f,-0.87500000f,-0.84375000f,-0.43750000f,-0.81250000f,0.84375000f,-0.12500000f,0.59375000f,0.39062500f,0.65625000f,0.37500000f,0.04687500f,-0.73437500f,-0.46875000f,-0.70312500f,-0.56250000f,0.23437500f,0.65625000f,-0.42187500f,-0.01562500f,0.70312500f,0.78125000f,-0.23437500f,-0.04687500f,-0.25000000f,-0.09375000f,-0.71875000f,-0.37500000f,-0.40625000f,-0.10937500f,-0.03125000f,0.98437500f,0.10937500f,-0.53125000f,0.64062500f,-0.10937500f,-0.81250000f,-0.75000000f,-0.37500000f,0.21875000f,-0.82812500f,-0.59375000f,0.14062500f,-0.53125000f,0.64062500f,0.23437500f,0.32812500f,-0.31250000f,0.17187500f,-0.28125000f,-0.04687500f,0.12500000f,-0.04687500f,-0.67187500f,0.48437500f,0.15625000f,-0.92187500f,-0.07812500f,0.12500000f,0.12500000f,0.37500000f,0.84375000f,0.32812500f,-0.37500000f,0.28125000f,0.95312500f,-0.15625000f,-0.50000000f,0.31250000f,-0.03125000f,0.90625000f,0.90625000f,0.15625000f,0.48437500f,-0.46875000f,-0.95312500f,-0.56250000f,0.23437500f,0.75000000f,0.43750000f,0.68750000f,0.14062500f,-1.00000000f,0.54687500f,-0.82812500f,-0.34375000f,-0.87500000f,0.04687500f,0.73437500f,-0.23437500f,-0.43750000f,0.57812500f,-0.64062500f,0.59375000f,0.29687500f,-0.59375000f,-0.18750000f,0.06250000f,0.60937500f,-0.10937500f,-0.87500000f,-0.09375000f,0.23437500f,-0.26562500f,0.25000000f,0.89062500f,0.75000000f,0.34375000f,0.60937500f,-0.82812500f,0.07812500f,0.51562500f,0.15625000f,0.70312500f,0.37500000f,0.67187500f,0.07812500f,0.45312500f,0.71875000f,-0.21875000f,-0.76562500f,-0.34375000f,-0.12500000f,0.75000000f,0.10937500f,0.17187500f,-0.54687500f,-0.04687500f,0.84375000f,-0.84375000f,-0.39062500f,-0.84375000f,-0.04687500f,0.10937500f,0.15625000f,-0.56250000f,-0.09375000f,0.26562500f,-0.71875000f,-0.57812500f,-0.96875000f,-0.70312500f,0.53125000f,-0.84375000f,-0.04687500f,0.59375000f,0.35937500f,-0.15625000f,0.82812500f,0.00000000f,-0.42187500f,0.79687500f,0.42187500f,-0.70312500f,-0.75000000f,-0.51562500f,0.79687500f,-0.15625000f,0.43750000f,-0.31250000f,-0.82812500f,-0.59375000f,0.28125000f,-0.46875000f,0.93750000f,0.82812500f,-0.29687500f,0.98437500f,-0.95312500f,0.79687500f,-0.78125000f,0.46875000f,0.09375000f,-0.56250000f,0.17187500f,0.46875000f,0.90625000f,-0.28125000f,-0.15625000f,0.03125000f,0.82812500f,0.14062500f,-0.87500000f,0.34375000f,0.87500000f,0.31250000f,-0.85937500f,0.65625000f,-0.06250000f,-0.20312500f,-0.73437500f,-0.64062500f,-0.10937500f,0.54687500f,-0.98437500f,-0.46875000f,0.84375000f,0.51562500f,0.37500000f,0.67187500f,0.79687500f,0.89062500f,0.96875000f,-0.90625000f,0.62500000f,0.60937500f,0.25000000f,0.78125000f,0.96875000f,0.37500000f,-0.96875000f,-0.01562500f,0.76562500f,0.00000000f,0.26562500f,0.51562500f,-0.92187500f,-0.56250000f,-0.78125000f,0.76562500f,-0.26562500f,-0.87500000f,0.90625000f,-0.20312500f,-0.51562500f,-0.20312500f,0.87500000f,-0.73437500f,0.76562500f,-0.64062500f,-0.17187500f,-0.98437500f,0.54687500f,-0.18750000f,0.34375000f,0.51562500f,-0.50000000f,-0.15625000f,-0.42187500f,0.56250000f,-0.93750000f,-0.43750000f,-0.78125000f,-0.17187500f,0.09375000f,-0.75000000f,-0.18750000f,0.10937500f,-0.68750000f,0.43750000f,-0.84375000f,-0.04687500f,0.89062500f,0.43750000f,0.79687500f,0.51562500f,-0.23437500f,-0.64062500f,0.68750000f,0.03125000f,0.01562500f,0.10937500f,-0.87500000f,-0.29687500f,-0.73437500f,0.15625000f,-0.14062500f,-0.93750000f,-0.79687500f,0.73437500f,-0.48437500f,0.04687500f,-0.29687500f,0.42187500f,-0.84375000f,0.00000000f,-0.15625000f,-0.50000000f,0.57812500f,0.68750000f,-0.78125000f,0.15625000f,-0.59375000f,0.03125000f,0.82812500f,0.62500000f,-0.14062500f,-0.93750000f,-0.79687500f,0.64062500f,0.85937500f,0.57812500f,0.28125000f,0.40625000f,0.23437500f,-0.46875000f,-0.20312500f,0.12500000f,-0.73437500f,0.26562500f,-0.10937500f,0.10937500f,-1.00000000f,0.35937500f,-0.48437500f,-0.89062500f,0.92187500f,0.48437500f,0.03125000f,-0.43750000f,0.53125000f,-0.51562500f,-0.01562500f,-0.32812500f,0.73437500f,0.18750000f,-0.50000000f,0.79687500f,0.82812500f,0.57812500f,-0.40625000f,0.82812500f,0.20312500f,0.56250000f,0.54687500f,-0.76562500f,-0.53125000f,0.48437500f,0.23437500f,0.14062500f,-0.90625000f,-0.46875000f,0.35937500f,-0.50000000f,0.59375000f,0.60937500f,0.00000000f,-0.04687500f,-0.60937500f,-0.82812500f,0.53125000f,0.43750000f,-0.85937500f,-0.68750000f,-0.98437500f,0.14062500f,-0.57812500f,-0.45312500f,-0.81250000f,-0.78125000f,-0.07812500f,-0.43750000f,0.92187500f,0.40625000f,0.20312500f,-0.09375000f,-0.12500000f,-0.54687500f,-0.68750000f,0.75000000f,-0.70312500f,-0.29687500f,0.65625000f,-0.37500000f,0.46875000f,0.46875000f,-0.32812500f,-0.39062500f,0.98437500f,0.31250000f,0.20312500f,-0.26562500f,-0.50000000f,0.04687500f,-0.64062500f,0.60937500f,0.96875000f,0.25000000f,-0.90625000f,-0.50000000f,-0.07812500f,-0.37500000f,-0.75000000f,-0.14062500f,0.01562500f,-0.35937500f,1.00000000f,0.68750000f,-0.17187500f,0.18750000f,0.84375000f,-0.54687500f,0.51562500f,0.21875000f,0.50000000f,-0.29687500f,0.04687500f,0.20312500f,0.14062500f,0.79687500f,0.25000000f,-0.07812500f,0.04687500f,-0.23437500f,0.87500000f,0.39062500f,0.23437500f,1.00000000f,0.68750000f,0.75000000f,-0.71875000f,-0.92187500f,0.29687500f,-0.04687500f,-0.71875000f,-0.37500000f,-0.65625000f,-0.85937500f,0.53125000f,0.29687500f,0.32812500f,-0.39062500f,-0.46875000f,-0.81250000f,0.95312500f,0.15625000f,0.82812500f,-0.43750000f,-0.07812500f,-0.20312500f,-0.48437500f,0.51562500f,-0.56250000f,-0.10937500f,0.82812500f,0.00000000f,0.56250000f,0.95312500f,-0.10937500f,0.48437500f,-0.07812500f,0.73437500f,0.98437500f,0.18750000f,-0.17187500f,-0.43750000f,-0.40625000f,-0.03125000f,0.12500000f,0.93750000f,0.90625000f,0.20312500f,-0.12500000f,-0.65625000f,-0.10937500f,-0.12500000f,-0.39062500f,0.68750000f,-0.21875000f,0.60937500f,0.75000000f,-0.71875000f,-0.15625000f,-0.79687500f,-0.18750000f,-0.48437500f,0.01562500f,1.00000000f,0.90625000f,0.79687500f,0.93750000f,-0.75000000f,-0.98437500f,0.34375000f,0.95312500f,-0.51562500f,0.15625000f,0.31250000f,-0.37500000f,-0.59375000f,0.43750000f,0.46875000f,0.00000000f,0.32812500f,-0.25000000f,0.60937500f,-0.20312500f,-0.06250000f,0.50000000f,-0.34375000f,0.18750000f,0.21875000f,0.48437500f,0.60937500f,-0.04687500f,1.00000000f,0.34375000f,-0.56250000f,-0.43750000f,-0.39062500f,-0.92187500f,-0.32812500f,0.04687500f,-0.01562500f,-0.14062500f,0.42187500f,-0.84375000f,0.18750000f,0.04687500f,-0.04687500f,0.53125000f,-0.28125000f,0.12500000f,0.87500000f,-0.87500000f,0.35937500f,-0.68750000f,0.32812500f,0.51562500f,-0.03125000f,0.68750000f,-0.92187500f,-0.71875000f,-0.76562500f,0.68750000f,-0.54687500f,-0.32812500f,0.12500000f,-0.07812500f,-0.37500000f,-0.56250000f,-0.46875000f,-0.26562500f,-0.65625000f,-0.46875000f,-0.75000000f,0.53125000f,-0.20312500f,-0.54687500f,-0.18750000f,-0.51562500f,-0.75000000f,0.25000000f,-0.10937500f,-0.87500000f,-0.28125000f,0.98437500f,0.64062500f,-0.56250000f,0.40625000f,-0.28125000f,-0.04687500f,0.35937500f,-0.85937500f,0.46875000f,0.89062500f,0.21875000f,-0.87500000f,0.65625000f,-0.09375000f,-0.37500000f,-0.04687500f,0.67187500f,-0.76562500f,-0.14062500f,-0.39062500f,-0.46875000f,0.64062500f,-0.37500000f,0.01562500f,1.00000000f,0.28125000f,-0.95312500f,0.14062500f,-0.12500000f,-0.96875000f,0.89062500f,-0.12500000f,-0.65625000f,-0.51562500f,0.84375000f,-0.09375000f,-0.82812500f,-0.39062500f,0.87500000f,0.12500000f,-0.79687500f,-0.73437500f,0.21875000f,-0.10937500f,-0.31250000f,-0.65625000f,0.01562500f,-0.65625000f,-0.01562500f,0.53125000f,-0.67187500f,-0.35937500f,0.79687500f,-0.01562500f,0.84375000f,-0.73437500f,0.28125000f,-0.84375000f,-0.56250000f,-0.14062500f,0.01562500f,0.01562500f,0.17187500f,0.60937500f,0.71875000f,-0.85937500f,0.89062500f,-0.75000000f,0.50000000f,0.87500000f,-0.57812500f,-0.73437500f,-0.12500000f,-0.42187500f,1.00000000f,-0.21875000f,0.60937500f,0.07812500f,-0.35937500f,0.79687500f,0.26562500f,0.34375000f,-0.93750000f,-0.48437500f,-0.67187500f,-0.15625000f,-0.09375000f,-0.42187500f,0.25000000f,-0.03125000f,-0.18750000f,-0.25000000f,0.67187500f,0.98437500f,-0.26562500f,0.98437500f,-0.79687500f,-0.75000000f,0.79687500f,-0.26562500f,-0.81250000f,0.29687500f,-0.89062500f,0.57812500f,0.56250000f,0.71875000f,-0.95312500f,0.95312500f,0.32812500f,-0.98437500f,0.59375000f,0.03125000f,0.85937500f,0.09375000f,0.87500000f,-0.96875000f,0.23437500f,0.57812500f,0.56250000f,0.40625000f,0.29687500f,0.21875000f,0.56250000f,-0.51562500f,-0.35937500f,-0.75000000f,0.09375000f,0.65625000f,-0.37500000f,-0.64062500f,-0.45312500f,0.82812500f,0.09375000f,0.68750000f,0.85937500f,0.82812500f,0.56250000f,-0.34375000f,0.12500000f,-0.71875000f,0.75000000f,0.03125000f,-0.93750000f,-0.89062500f,-0.76562500f,0.28125000f,0.03125000f,-0.01562500f,-0.60937500f,0.15625000f,-0.81250000f,-0.37500000f,0.65625000f,0.95312500f,0.51562500f,0.56250000f,-0.85937500f,-0.04687500f,0.48437500f,-0.89062500f,-0.90625000f,0.51562500f,0.26562500f,0.46875000f,0.82812500f,-0.04687500f,-0.71875000f,0.10937500f,0.28125000f,-0.60937500f,-0.09375000f,0.53125000f,0.18750000f,-0.21875000f,-1.00000000f,-0.87500000f,0.45312500f,0.32812500f,0.51562500f,-0.59375000f,-0.29687500f,0.71875000f,0.20312500f,-0.82812500f,0.79687500f,0.54687500f,0.95312500f,0.70312500f,0.09375000f,-0.81250000f,-0.75000000f,0.48437500f,-0.73437500f,-0.81250000f,0.92187500f,0.51562500f,0.95312500f,0.39062500f,0.09375000f,-0.64062500f,-0.14062500f,-0.45312500f,-0.12500000f,0.50000000f,-0.92187500f,0.46875000f,-0.56250000f,-0.42187500f,-0.51562500f,0.42187500f,-0.81250000f,0.20312500f,0.59375000f,0.84375000f,-0.35937500f,0.89062500f,-0.31250000f,0.68750000f,-0.98437500f,-0.18750000f,-0.15625000f,0.75000000f,0.03125000f,-0.42187500f,0.70312500f,0.87500000f,0.81250000f,-0.32812500f,0.64062500f,0.78125000f,-0.68750000f,0.90625000f,0.32812500f,0.62500000f,0.56250000f,0.42187500f,0.04687500f,0.93750000f,-0.23437500f,-0.26562500f,0.18750000f,-0.20312500f,0.71875000f,-0.53125000f,0.17187500f,-0.82812500f,-0.95312500f,0.43750000f,-0.43750000f,-0.64062500f,0.89062500f,-0.54687500f,-0.18750000f,0.23437500f,-0.65625000f,-0.90625000f,-0.01562500f,-0.60937500f,-0.04687500f,-0.60937500f,0.57812500f,0.62500000f,0.90625000f,-0.90625000f,0.14062500f,0.28125000f,-0.59375000f,0.70312500f,-0.39062500f,-0.75000000f,0.20312500f,-0.32812500f,0.18750000f,-0.45312500f,-0.25000000f,-0.01562500f,-0.32812500f,-0.42187500f,0.10937500f,-0.39062500f,0.06250000f,0.40625000f,-0.01562500f,0.65625000f,0.82812500f,0.20312500f,0.21875000f,0.18750000f,-0.51562500f,-0.42187500f,0.62500000f,-0.79687500f,-0.01562500f,-0.51562500f,0.28125000f,-0.73437500f,-0.43750000f,0.71875000f,-0.75000000f,0.09375000f,0.54687500f,0.26562500f,0.40625000f,0.32812500f,-0.60937500f,-0.87500000f,0.25000000f,0.20312500f,0.03125000f,0.95312500f,0.57812500f,-0.26562500f,0.53125000f,-0.18750000f,0.46875000f,-0.29687500f,0.46875000f,0.68750000f,-0.40625000f,-0.48437500f,0.92187500f,0.56250000f,-0.25000000f,-0.56250000f,-0.75000000f,0.75000000f,-0.39062500f,0.82812500f,-0.78125000f,0.57812500f,0.31250000f,0.48437500f,-0.73437500f,-0.73437500f,0.26562500f,-0.73437500f,-0.42187500f,-0.85937500f,-0.29687500f,-0.70312500f,-0.50000000f,0.85937500f,-0.70312500f,-0.65625000f,-0.60937500f,0.03125000f,0.70312500f,-0.89062500f,-0.57812500f,0.60937500f,-0.82812500f,0.03125000f,0.70312500f,0.54687500f,0.07812500f,-0.62500000f,0.18750000f,-0.56250000f,0.23437500f,0.50000000f,-0.17187500f,-0.35937500f,0.28125000f,-0.37500000f,1.00000000f,-0.82812500f,0.12500000f,0.50000000f,-0.62500000f,0.95312500f,0.29687500f,0.18750000f,0.42187500f,-0.20312500f,-0.23437500f,0.17187500f,0.57812500f,0.40625000f,0.71875000f,-0.40625000f,0.54687500f,-0.10937500f,-0.17187500f,0.42187500f,0.37500000f,0.56250000f,0.59375000f,0.67187500f,0.12500000f,-0.65625000f,-0.25000000f,0.10937500f,0.28125000f,-0.06250000f,0.98437500f,0.98437500f,-0.65625000f,0.50000000f,-0.59375000f,-0.92187500f,0.57812500f,0.15625000f,-0.09375000f,-0.89062500f,-0.87500000f,0.29687500f,-0.15625000f,0.06250000f,0.15625000f,-0.53125000f,0.07812500f,-0.68750000f,0.48437500f,0.75000000f,-1.00000000f,0.75000000f,0.42187500f,-0.09375000f,-0.67187500f,0.01562500f,-0.73437500f,0.17187500f,0.96875000f,-0.28125000f,-0.96875000f,0.79687500f,0.62500000f,0.18750000f,-0.28125000f,-0.29687500f,0.87500000f,-0.75000000f,0.40625000f,0.12500000f,0.14062500f,-0.82812500f,0.54687500f,0.87500000f,-0.29687500f,0.87500000f,-0.93750000f,-0.45312500f,-0.45312500f,0.20312500f,0.53125000f,-0.87500000f,-0.67187500f,-0.04687500f,-0.03125000f,-0.56250000f,-0.06250000f,-0.01562500f,-0.79687500f,0.34375000f,-0.01562500f,-0.39062500f,0.31250000f,0.67187500f,-0.57812500f,-0.73437500f,0.42187500f,0.71875000f,-0.01562500f,0.75000000f,0.29687500f,0.59375000f,0.25000000f,-0.18750000f,0.96875000f,-0.39062500f,-0.46875000f,0.12500000f,-0.17187500f,0.76562500f,-0.75000000f,-0.65625000f,-0.46875000f,-0.20312500f,-0.50000000f,0.70312500f,0.37500000f,0.68750000f,-0.81250000f,-0.62500000f,0.48437500f,0.90625000f,-0.37500000f,-0.65625000f,0.67187500f,0.04687500f,0.31250000f,-0.71875000f,-0.37500000f,-0.92187500f,-0.21875000f,0.93750000f,-0.25000000f,-0.56250000f,-0.45312500f,-0.14062500f,0.25000000f,0.85937500f,-0.79687500f,-0.34375000f,-0.57812500f,-0.50000000f,0.00000000f,-0.78125000f,0.75000000f,-0.48437500f,-0.40625000f,0.21875000f,0.32812500f,0.37500000f,0.32812500f,0.84375000f,-0.25000000f,-0.25000000f,0.96875000f,-0.78125000f,-0.51562500f,0.53125000f,-0.67187500f,-0.37500000f,-0.42187500f,-0.21875000f,-0.93750000f,-0.48437500f,1.00000000f,-0.79687500f,0.28125000f,0.28125000f,-0.62500000f,-0.59375000f,-0.39062500f,0.67187500f,-0.40625000f,-0.01562500f,0.56250000f,0.43750000f,-0.51562500f,-0.15625000f,-0.21875000f,-0.96875000f,0.03125000f,-0.68750000f,-0.87500000f,-0.04687500f,0.90625000f,-0.73437500f,0.12500000f,0.39062500f,0.34375000f,-0.65625000f,-0.21875000f,0.81250000f,-0.14062500f,-0.56250000f,0.71875000f,-0.71875000f,-0.18750000f,0.20312500f,-0.15625000f,-0.20312500f,-0.92187500f,-0.67187500f,0.26562500f,-0.53125000f,-0.26562500f,-0.34375000f,0.01562500f,0.78125000f,-0.46875000f,0.56250000f,0.68750000f,0.75000000f,0.93750000f,-0.70312500f,-0.07812500f,0.37500000f,0.70312500f,0.06250000f,-0.71875000f,-0.78125000f,0.87500000f,-0.12500000f,-0.09375000f,0.09375000f,0.90625000f,0.14062500f,0.26562500f,0.75000000f,-0.57812500f,0.62500000f,-0.89062500f,-0.73437500f,-0.07812500f,-0.85937500f,0.65625000f,-0.64062500f,-0.46875000f,-0.35937500f,0.64062500f,0.70312500f,0.57812500f,-0.28125000f,-0.71875000f,-0.35937500f,0.82812500f,0.51562500f,-0.71875000f,0.62500000f,0.85937500f,0.59375000f,-0.93750000f,-0.75000000f,0.31250000f,0.09375000f,-0.92187500f,-0.87500000f,-0.59375000f,0.92187500f,0.51562500f,0.00000000f,-0.87500000f,0.98437500f,-0.54687500f,0.76562500f,0.93750000f,0.51562500f,-1.00000000f,0.39062500f,0.65625000f,-0.54687500f,0.18750000f,0.07812500f,0.84375000f,0.87500000f,-0.29687500f,0.15625000f,0.87500000f,-0.42187500f,-0.84375000f,0.17187500f,-0.14062500f,-0.14062500f,0.70312500f,0.51562500f,-0.01562500f,0.85937500f,0.73437500f,-0.73437500f,0.89062500f,-0.67187500f,0.45312500f,-0.42187500f,-0.82812500f,0.81250000f,0.01562500f,-0.67187500f,0.17187500f,0.50000000f,0.17187500f,0.12500000f,0.73437500f,1.00000000f,-0.57812500f,0.65625000f,0.64062500f,-0.51562500f,0.01562500f,-0.12500000f,0.87500000f,0.04687500f,0.07812500f,-0.09375000f,0.03125000f,-0.95312500f,0.26562500f,0.42187500f,0.26562500f,-0.46875000f,0.17187500f,0.48437500f,-0.54687500f,-0.57812500f,-0.18750000f,0.96875000f,-0.71875000f,-0.81250000f,0.15625000f,0.31250000f,0.85937500f,-0.62500000f,0.15625000f,-0.85937500f,0.06250000f,0.20312500f,0.81250000f,0.09375000f,-0.25000000f,0.53125000f,0.96875000f,-0.53125000f,-0.23437500f,-0.57812500f,-0.93750000f,-0.10937500f,-0.92187500f,-0.89062500f,-0.07812500f,0.62500000f,1.00000000f,0.76562500f,0.12500000f,-0.73437500f,0.31250000f,0.84375000f,-0.64062500f,0.95312500f,-0.60937500f,-0.90625000f,0.51562500f,-0.29687500f,-0.23437500f,-0.12500000f,0.21875000f,-1.00000000f,0.21875000f,0.57812500f,0.07812500f,0.09375000f,0.29687500f,0.82812500f,0.84375000f,-0.62500000f,-0.18750000f,0.95312500f,-0.53125000f,0.21875000f,0.78125000f,-0.28125000f,-0.35937500f,0.28125000f,0.73437500f,0.70312500f,0.48437500f,-0.48437500f,-0.50000000f,0.81250000f,-0.54687500f,-0.65625000f,-0.82812500f,-0.46875000f,0.81250000f,0.65625000f,0.10937500f,0.20312500f,-0.26562500f,0.25000000f,0.71875000f,-0.71875000f,0.06250000f,-0.17187500f,-0.12500000f,0.25000000f,-0.43750000f,0.82812500f,-0.04687500f,0.46875000f,0.73437500f,0.25000000f,-0.78125000f,0.75000000f,-0.51562500f,0.01562500f,-0.60937500f,0.10937500f,-0.12500000f,0.45312500f,0.60937500f,-1.00000000f,-0.96875000f,-0.60937500f,0.67187500f,0.81250000f,-0.20312500f,-0.39062500f,-0.09375000f,-0.81250000f,-0.18750000f,-0.81250000f,0.76562500f,0.81250000f,0.56250000f,0.32812500f,-0.09375000f,0.56250000f,-0.20312500f,0.28125000f,-0.39062500f,-0.85937500f,0.37500000f,0.85937500f,0.53125000f,0.26562500f,0.78125000f,0.71875000f,0.81250000f,-0.84375000f,0.62500000f,-0.82812500f,-0.50000000f,-0.23437500f,-0.15625000f,0.17187500f,-0.43750000f,0.53125000f,-0.25000000f,0.96875000f,0.01562500f,0.67187500f,-0.59375000f,-0.89062500f,0.98437500f,-0.25000000f,0.35937500f,0.04687500f,-0.65625000f,0.15625000f,0.26562500f,-0.35937500f,0.84375000f,-0.06250000f,0.51562500f,-0.01562500f,0.50000000f,-0.14062500f,-0.12500000f,-0.75000000f,0.59375000f,0.57812500f,0.31250000f,0.20312500f,-0.85937500f,-0.82812500f,0.78125000f,-0.75000000f,0.95312500f,0.29687500f,-0.78125000f,-0.04687500f,0.85937500f,0.59375000f,-0.92187500f,-0.54687500f,-0.03125000f,0.42187500f,-0.17187500f,0.40625000f,-0.98437500f,0.57812500f,-0.96875000f,-0.50000000f,0.46875000f,-0.89062500f,0.07812500f,-0.04687500f,-0.85937500f,-0.71875000f,-0.89062500f,0.71875000f,0.95312500f,0.01562500f,-0.98437500f,0.73437500f,0.95312500f,-0.35937500f,-0.12500000f,0.21875000f,-0.15625000f,0.45312500f,-0.90625000f,0.65625000f,-0.96875000f,-0.06250000f,0.65625000f,0.31250000f,0.29687500f,0.07812500f,0.79687500f,-0.46875000f,-0.26562500f,-0.65625000f,-0.75000000f,-0.96875000f,0.98437500f,-0.03125000f,0.09375000f,-0.28125000f,-0.48437500f,0.28125000f,0.25000000f,0.68750000f,-0.04687500f,0.25000000f,-0.53125000f,0.18750000f,-0.25000000f,0.50000000f,0.87500000f,-1.00000000f,-0.39062500f,-0.07812500f,-0.48437500f,-0.82812500f,-0.37500000f,0.09375000f,0.39062500f,-0.31250000f,0.85937500f,0.59375000f,-0.43750000f,-0.23437500f,-0.43750000f,-0.65625000f,0.14062500f,-0.17187500f,-0.20312500f,-0.39062500f,-0.03125000f,-0.87500000f,-0.67187500f,-0.54687500f,-0.60937500f,0.18750000f,-0.43750000f,-0.54687500f,-0.98437500f,-0.28125000f,0.98437500f,0.71875000f,-0.46875000f,-1.00000000f,0.79687500f,0.87500000f,0.82812500f,0.48437500f,-0.75000000f,-0.87500000f,-0.06250000f,1.00000000f,0.17187500f,-0.87500000f,0.35937500f,-0.01562500f,0.37500000f,-0.45312500f,-0.09375000f,0.96875000f,0.10937500f,-0.09375000f,0.53125000f,-0.75000000f,0.31250000f,-0.07812500f,-0.20312500f,0.26562500f,0.04687500f,0.15625000f,0.10937500f,0.98437500f,0.17187500f,0.45312500f,-0.65625000f,0.18750000f,-0.96875000f,0.62500000f,0.26562500f,0.92187500f,-0.78125000f,0.29687500f,-0.56250000f,0.20312500f,0.00000000f,-0.73437500f,-0.37500000f,0.60937500f,0.32812500f,-0.12500000f,-0.15625000f,-0.53125000f,-0.81250000f,0.32812500f,0.54687500f,0.48437500f,0.73437500f,0.04687500f,0.56250000f,-0.20312500f,-0.31250000f,0.21875000f,0.48437500f,0.85937500f,0.06250000f,0.00000000f,-0.42187500f,-0.93750000f,-0.28125000f,0.68750000f,-0.78125000f,0.45312500f,0.46875000f,0.96875000f,0.81250000f,0.62500000f,0.01562500f,-0.64062500f,-0.15625000f,0.59375000f,-0.34375000f,0.40625000f,-0.35937500f,0.32812500f,0.28125000f,-0.76562500f,-0.25000000f,-0.18750000f,-0.78125000f,-0.25000000f,0.10937500f,-0.07812500f,-0.59375000f,0.50000000f,0.98437500f,0.00000000f,0.85937500f,0.62500000f,-0.92187500f,0.81250000f,0.92187500f,0.32812500f,-0.17187500f,-0.87500000f,0.04687500f,-0.15625000f,0.93750000f,-0.04687500f,-0.46875000f,-0.76562500f,-0.29687500f,0.18750000f,-0.95312500f,-0.48437500f,0.75000000f,-0.76562500f,-0.82812500f,0.87500000f,0.70312500f,0.23437500f,-0.29687500f,-0.60937500f,0.93750000f,0.92187500f,0.65625000f,0.26562500f,0.01562500f,0.75000000f,0.76562500f,0.93750000f,0.31250000f,-0.34375000f,-0.78125000f,0.60937500f,0.12500000f,-0.37500000f,0.57812500f,-0.56250000f,0.42187500f,0.46875000f,0.25000000f,-0.21875000f,0.45312500f,0.39062500f,-0.56250000f,0.18750000f,0.62500000f,-0.65625000f,-0.26562500f,-0.51562500f,0.81250000f,0.50000000f,-0.85937500f,0.23437500f,0.81250000f,0.81250000f,0.54687500f,-0.54687500f,-0.93750000f,0.51562500f,-0.62500000f,0.03125000f,0.62500000f,-0.82812500f,0.04687500f,-0.04687500f,0.10937500f,-0.25000000f,-0.98437500f,-0.39062500f,0.82812500f,-0.26562500f,-0.06250000f,0.51562500f,-0.43750000f,0.87500000f,-0.29687500f,0.96875000f,-0.54687500f,0.06250000f,-0.64062500f,0.29687500f,-0.06250000f,0.96875000f,-0.84375000f,-0.89062500f,0.34375000f,-0.31250000f,-0.09375000f,0.34375000f,0.42187500f,0.20312500f,-0.54687500f,-0.10937500f,-0.65625000f,-0.03125000f,-0.60937500f,0.06250000f,-0.17187500f,0.23437500f,0.18750000f,0.15625000f,0.43750000f,-0.62500000f,-0.81250000f,-0.42187500f,0.68750000f,0.62500000f,-0.79687500f,-0.71875000f,-0.48437500f,-0.35937500f,-0.18750000f,0.07812500f,0.45312500f,0.12500000f,0.57812500f,-0.03125000f,-0.85937500f,-0.42187500f,-0.60937500f,0.71875000f,0.84375000f,-0.90625000f,0.67187500f,-0.75000000f,0.06250000f,0.95312500f,0.06250000f,0.75000000f,-0.68750000f,0.65625000f,0.51562500f,-0.32812500f,0.60937500f,0.51562500f,0.15625000f,0.35937500f,-0.87500000f,-0.90625000f,0.59375000f,0.67187500f,-0.96875000f,-0.70312500f,-0.54687500f,0.68750000f,-0.70312500f,-0.06250000f,0.98437500f,-0.48437500f,-0.84375000f,0.06250000f,0.53125000f,-0.03125000f,0.43750000f,0.73437500f,0.60937500f,-0.70312500f,-0.43750000f,-0.60937500f,-0.78125000f,-0.07812500f,0.71875000f,-0.01562500f,0.10937500f,-0.34375000f,0.79687500f,0.96875000f,0.53125000f,0.23437500f,0.45312500f,-0.75000000f,-0.31250000f,0.68750000f,-0.32812500f,-0.07812500f,0.93750000f,0.57812500f,-0.29687500f,-0.68750000f,-0.64062500f,0.06250000f,0.26562500f,-0.25000000f,-0.29687500f,-0.85937500f,-0.34375000f,0.98437500f,0.64062500f,0.57812500f,-0.10937500f,0.82812500f,-0.18750000f,-0.46875000f,0.29687500f,-0.39062500f,0.23437500f,-0.79687500f,-0.46875000f,0.85937500f,0.09375000f,-0.64062500f,-0.34375000f,-0.79687500f,-0.45312500f,-0.10937500f,-0.39062500f,-0.37500000f,0.59375000f,0.00000000f,0.70312500f,0.70312500f,0.12500000f,-0.42187500f,0.71875000f,0.71875000f,-0.70312500f,-0.04687500f,0.71875000f,-0.73437500f,-0.87500000f,0.20312500f,0.07812500f,0.43750000f,0.76562500f,-0.29687500f,-0.42187500f,-0.21875000f,-0.76562500f,0.46875000f,0.51562500f,-0.07812500f,0.89062500f,0.32812500f,0.35937500f,-0.10937500f,-0.70312500f,0.92187500f,-0.70312500f,-0.81250000f,-0.70312500f,-0.79687500f,0.37500000f,0.62500000f,-1.00000000f,-0.25000000f,-0.17187500f,0.65625000f,1.00000000f,-0.53125000f,-0.21875000f,0.15625000f,0.42187500f,0.59375000f,0.31250000f,0.23437500f,-0.17187500f,0.48437500f,0.45312500f,-0.09375000f,-0.59375000f,0.53125000f,0.45312500f,0.10937500f,0.87500000f,-0.87500000f,0.26562500f,0.20312500f,0.65625000f,-0.90625000f,0.60937500f,-0.15625000f,-0.45312500f,-0.82812500f,-0.53125000f,0.01562500f,0.07812500f,0.76562500f,0.84375000f,0.07812500f,0.21875000f,-0.50000000f,0.76562500f,0.01562500f,-0.21875000f,-0.71875000f,0.26562500f,0.57812500f,-0.40625000f,-0.87500000f,-0.89062500f,-0.12500000f,-0.59375000f,-0.18750000f,0.78125000f,-0.78125000f,-0.20312500f,-0.04687500f,0.71875000f,-0.26562500f,-0.14062500f,-0.53125000f,-0.26562500f,-0.75000000f,-0.26562500f,-0.01562500f,-0.64062500f,-0.20312500f,0.90625000f,-0.21875000f,0.51562500f,-0.07812500f,-0.87500000f,0.48437500f,-1.00000000f,1.00000000f,0.32812500f,-0.56250000f,0.75000000f,-0.93750000f,-0.70312500f,0.71875000f,-0.43750000f,0.18750000f,-0.23437500f,0.34375000f,-0.37500000f,-0.70312500f,-0.95312500f,0.50000000f,-0.14062500f,-0.31250000f,-0.09375000f,0.00000000f,0.71875000f,0.18750000f,0.25000000f,0.64062500f,0.60937500f,0.65625000f,0.64062500f,0.21875000f,-0.56250000f,-0.75000000f,-0.29687500f,0.23437500f,0.89062500f,-0.60937500f,0.09375000f,0.04687500f,-0.93750000f,-0.35937500f,0.09375000f,0.93750000f,-0.23437500f,-0.06250000f,-0.60937500f,0.92187500f,-0.60937500f,-0.45312500f,-0.56250000f,0.95312500f,-0.43750000f,-0.96875000f,0.95312500f,-0.64062500f,-0.20312500f,0.64062500f,-0.04687500f,0.10937500f,0.46875000f,-0.90625000f,-0.90625000f,0.54687500f,0.73437500f,0.48437500f,0.23437500f,-0.84375000f,-0.03125000f,0.17187500f,-0.06250000f,0.54687500f,0.14062500f,-0.12500000f,-0.32812500f,0.10937500f,0.87500000f,0.57812500f,0.96875000f,-0.25000000f,-0.89062500f,-0.21875000f,-0.98437500f,-0.25000000f,0.15625000f,-0.93750000f,0.14062500f,0.51562500f,0.89062500f,-0.06250000f,0.71875000f,0.93750000f,-0.89062500f,0.01562500f,-0.25000000f,0.10937500f,-0.56250000f,0.64062500f,0.32812500f,-0.20312500f,-0.21875000f,0.09375000f,0.59375000f,-0.14062500f,-0.46875000f,0.84375000f,0.68750000f,-0.18750000f,0.78125000f,-0.35937500f,-0.65625000f,-0.67187500f,-0.78125000f,0.76562500f,0.01562500f,0.17187500f,0.68750000f,-0.17187500f,-0.65625000f,-0.37500000f,0.48437500f,0.50000000f,0.75000000f,-0.28125000f,0.81250000f,-0.62500000f,-0.60937500f,-1.00000000f,-0.92187500f,-0.35937500f,-0.10937500f,-0.35937500f,-0.92187500f,-0.20312500f,-0.20312500f,0.82812500f,0.73437500f,0.01562500f,-0.70312500f,0.51562500f,-0.10937500f,-0.23437500f,-0.12500000f,0.20312500f,-0.65625000f,-0.76562500f,-0.42187500f,0.12500000f,0.09375000f,0.21875000f,-0.50000000f,0.84375000f,0.73437500f,-0.23437500f,-0.64062500f,-0.79687500f,-0.68750000f,-0.39062500f,0.43750000f,-0.14062500f,0.15625000f,-0.29687500f,-0.67187500f,0.03125000f,0.39062500f,0.17187500f,-0.84375000f,0.70312500f,-0.39062500f,-0.25000000f,0.76562500f,-1.00000000f,0.03125000f,0.65625000f,-0.59375000f,-0.68750000f,-0.34375000f,0.65625000f,-0.28125000f,0.79687500f,0.23437500f,-0.31250000f,-0.98437500f,-0.40625000f,-0.12500000f,-0.09375000f,0.12500000f,-0.35937500f,0.57812500f,0.09375000f,0.31250000f,-0.96875000f,-0.42187500f,0.39062500f,0.01562500f,-0.70312500f,-0.59375000f,0.56250000f,0.79687500f,-0.70312500f,0.31250000f,0.79687500f,1.00000000f,-0.62500000f,0.45312500f,-0.93750000f,0.75000000f,-0.15625000f,0.48437500f,-0.57812500f,-0.07812500f,-0.43750000f,0.90625000f,0.20312500f,0.04687500f,-0.48437500f,-1.00000000f,-0.64062500f,0.82812500f,0.64062500f,-0.85937500f,-0.23437500f,0.62500000f,-0.60937500f,0.46875000f,-0.50000000f,0.59375000f,-0.62500000f,0.93750000f,0.71875000f,0.03125000f,0.78125000f,-0.42187500f,-0.95312500f,0.64062500f,0.95312500f,-0.68750000f,0.26562500f,-0.87500000f,0.96875000f,1.00000000f,0.28125000f,-0.07812500f,-0.26562500f,-0.23437500f,-0.75000000f,0.07812500f,0.87500000f,0.31250000f,0.70312500f,0.95312500f,0.28125000f,-0.39062500f,0.76562500f,-0.32812500f,-0.64062500f,0.76562500f,-0.31250000f,0.54687500f,0.45312500f,0.37500000f,0.28125000f,-0.39062500f,-0.73437500f,-0.42187500f,-0.89062500f,0.21875000f,0.14062500f,0.87500000f,0.62500000f,-0.26562500f,-0.60937500f,0.50000000f,0.81250000f,0.89062500f,0.21875000f,-0.64062500f,0.43750000f,-0.09375000f,-0.54687500f,-0.54687500f,-0.09375000f,0.00000000f,-0.10937500f,0.84375000f,0.79687500f,-0.67187500f,0.34375000f,-0.14062500f,-0.04687500f,-0.50000000f,0.71875000f,-0.07812500f,0.01562500f,0.03125000f,-0.93750000f,1.00000000f,0.48437500f,0.51562500f,-0.57812500f,-0.68750000f,0.73437500f,0.46875000f,0.42187500f,-0.53125000f,-0.76562500f,0.78125000f,-0.68750000f,0.67187500f,0.00000000f,-0.95312500f,-0.04687500f,-0.42187500f,0.90625000f,0.09375000f,-0.25000000f,0.12500000f,0.64062500f,-0.95312500f,0.71875000f,-0.39062500f,0.39062500f,-0.20312500f,-0.07812500f,-0.75000000f,0.54687500f,0.37500000f,-0.50000000f,-0.18750000f,-0.70312500f,-0.04687500f,-0.81250000f,-0.42187500f,-0.76562500f,0.68750000f,-0.35937500f,0.28125000f,0.87500000f,-0.18750000f,-0.92187500f,0.95312500f,0.32812500f,0.64062500f,-0.17187500f,0.98437500f,0.82812500f,0.26562500f,0.68750000f,0.90625000f,-0.34375000f,0.73437500f,0.03125000f,0.25000000f,0.31250000f,-0.42187500f,-0.82812500f,-0.17187500f,-0.64062500f,0.96875000f,0.60937500f,-0.21875000f,0.10937500f,-0.21875000f,-0.39062500f,0.40625000f,0.12500000f,-1.00000000f,-0.54687500f,-0.48437500f,-0.43750000f,-0.85937500f,-0.03125000f,0.87500000f,0.23437500f,0.62500000f,-0.70312500f,0.54687500f,0.31250000f,0.57812500f,-0.23437500f,0.32812500f,-0.93750000f,-0.12500000f,0.67187500f,0.81250000f,0.23437500f,-0.06250000f,0.68750000f,-0.03125000f,-0.71875000f,0.59375000f,-0.21875000f,-0.14062500f,-0.10937500f,0.25000000f,-0.01562500f,0.54687500f,0.40625000f,0.57812500f,-0.29687500f,-0.84375000f,0.45312500f,0.26562500f,0.03125000f,-0.25000000f,-0.82812500f,-0.89062500f,-0.37500000f,-0.09375000f,0.98437500f,-0.53125000f,0.26562500f,-0.06250000f,0.48437500f,-0.56250000f,-0.50000000f,-0.64062500f,-0.39062500f,0.75000000f,-0.59375000f,-0.31250000f,-0.82812500f,-0.48437500f,0.64062500f,-0.18750000f,0.39062500f,-0.42187500f,-0.67187500f,-0.78125000f,0.71875000f,1.00000000f,0.39062500f,-0.67187500f,-0.59375000f,-0.12500000f,0.35937500f,0.26562500f,1.00000000f,-0.85937500f,-0.70312500f,-0.25000000f,0.31250000f,0.43750000f,-0.57812500f,0.48437500f,-0.93750000f,-0.53125000f,-0.87500000f,-0.67187500f,-0.67187500f,0.56250000f,0.60937500f,-0.92187500f,0.92187500f,-0.76562500f,0.82812500f,0.00000000f,-0.73437500f,0.95312500f,-0.90625000f,-0.10937500f,0.68750000f,-0.53125000f,0.14062500f,-0.39062500f,-0.14062500f,0.90625000f,0.17187500f,0.84375000f,-0.95312500f,-0.96875000f,-0.68750000f,0.68750000f,0.37500000f,0.06250000f,-0.93750000f,-0.46875000f,0.90625000f,-0.39062500f,-0.59375000f,0.40625000f,0.98437500f,0.81250000f,1.00000000f,-0.09375000f,-0.59375000f,0.29687500f,0.40625000f,0.79687500f,-0.50000000f,-0.89062500f,-1.00000000f,0.90625000f,0.10937500f,-0.23437500f,-0.78125000f,0.85937500f,0.50000000f,-0.46875000f,0.93750000f,-0.79687500f,-0.75000000f,0.54687500f,0.00000000f,0.26562500f,0.62500000f,-0.59375000f,0.95312500f,-0.85937500f,0.12500000f,0.03125000f,-0.20312500f,-0.53125000f,0.89062500f,-0.71875000f,-0.29687500f,-0.73437500f,0.98437500f,0.96875000f,-0.92187500f,0.46875000f,-0.09375000f,0.60937500f,0.78125000f,0.51562500f,-0.90625000f,0.39062500f,-0.85937500f,0.64062500f,-0.29687500f,0.15625000f,0.15625000f,-0.73437500f,0.06250000f,0.32812500f,0.71875000f,-0.53125000f,0.89062500f,-0.35937500f,0.85937500f,0.09375000f,-0.07812500f,0.75000000f,0.01562500f,0.65625000f,-0.39062500f,0.79687500f,0.96875000f,0.71875000f,-0.90625000f,-0.68750000f,-0.09375000f,-0.96875000f,-0.82812500f,0.23437500f,0.06250000f,-0.14062500f,0.56250000f,0.75000000f,-0.14062500f,-0.84375000f,0.81250000f,-0.70312500f,-0.01562500f,0.89062500f,-0.37500000f,0.40625000f,0.68750000f,0.46875000f,0.40625000f,0.14062500f,0.59375000f,0.10937500f,-0.34375000f,0.01562500f,-0.73437500f,-0.21875000f,0.37500000f,-0.39062500f,-0.10937500f,0.64062500f,-0.57812500f,-0.03125000f,0.25000000f,-0.09375000f,0.48437500f,-0.79687500f,-0.70312500f,-0.20312500f,0.45312500f,-0.51562500f,-0.35937500f,-0.42187500f,-0.57812500f,-0.01562500f,0.57812500f,0.92187500f,0.79687500f,1.00000000f,0.93750000f,0.98437500f,0.39062500f,0.29687500f,-0.75000000f,-0.42187500f,-0.09375000f,-0.37500000f,-0.06250000f,0.40625000f,0.84375000f,0.06250000f,-0.32812500f,0.54687500f,0.51562500f,-0.31250000f,0.76562500f,-0.98437500f,-0.28125000f,-0.70312500f,-0.34375000f,0.23437500f,-0.82812500f,-0.51562500f,-0.31250000f,-0.64062500f,0.87500000f,0.18750000f,0.12500000f,-0.95312500f,-0.39062500f,0.82812500f,0.87500000f,-0.25000000f,0.20312500f,-0.10937500f,-0.87500000f,0.54687500f,0.79687500f,-0.96875000f,0.68750000f,0.53125000f,-0.31250000f,0.15625000f,0.18750000f,-0.39062500f,-0.59375000f,-0.68750000f,0.28125000f,0.43750000f,-0.20312500f,1.00000000f,-0.79687500f,-0.17187500f,-0.04687500f,0.29687500f,0.59375000f,0.07812500f,-0.89062500f,0.17187500f,-0.42187500f,0.90625000f,0.95312500f,0.25000000f,0.37500000f,-0.53125000f,0.18750000f,-0.42187500f,0.92187500f,0.23437500f,-0.35937500f,0.01562500f,-0.82812500f,-0.75000000f,-0.71875000f,0.71875000f,-0.59375000f,-0.65625000f,0.73437500f,-0.67187500f,-0.32812500f,-0.85937500f,-0.45312500f,0.79687500f,0.25000000f,0.93750000f,1.00000000f,-0.20312500f,0.12500000f,0.37500000f,0.76562500f,-0.17187500f,0.53125000f,0.53125000f,0.06250000f,0.96875000f,0.75000000f,-0.56250000f,-0.10937500f,0.45312500f,-0.21875000f,0.54687500f,-0.39062500f,0.54687500f,0.48437500f,0.51562500f,0.90625000f,0.03125000f,-0.60937500f,0.04687500f,-0.68750000f,-0.65625000f,-0.68750000f,0.20312500f,0.75000000f,0.64062500f,-0.17187500f,0.45312500f,0.54687500f,-0.76562500f,-0.20312500f,0.50000000f,0.82812500f,-0.14062500f,-0.81250000f,0.12500000f,0.34375000f,-0.04687500f,-0.43750000f,0.65625000f,0.64062500f,0.85937500f,0.34375000f,-0.73437500f,0.95312500f,0.06250000f,-0.57812500f,0.78125000f,-0.84375000f,0.09375000f,0.15625000f,0.96875000f,0.60937500f,0.20312500f,-0.84375000f,-0.82812500f,0.75000000f,0.73437500f,0.89062500f,0.37500000f,-0.32812500f,0.95312500f,-0.14062500f,0.85937500f,0.26562500f,0.68750000f,0.04687500f,-0.06250000f,0.48437500f,0.10937500f,-0.85937500f,0.23437500f,-0.65625000f,0.84375000f,0.51562500f,-0.32812500f,-0.81250000f,-0.15625000f,0.95312500f,-0.98437500f,0.40625000f,-0.96875000f,-0.96875000f,0.92187500f,-0.73437500f,-0.25000000f,-0.43750000f,-0.98437500f,0.18750000f,0.87500000f,-0.48437500f,0.04687500f,-0.21875000f,-0.42187500f,-0.12500000f,-0.39062500f,-0.64062500f,-0.95312500f,-0.23437500f,-0.79687500f,0.92187500f,0.34375000f,0.87500000f,-0.03125000f,0.60937500f,0.60937500f,-0.25000000f,-0.29687500f,-0.84375000f,-0.90625000f,-0.14062500f,-0.81250000f,0.70312500f,0.95312500f,-0.90625000f,1.00000000f,-0.57812500f,-0.62500000f,0.93750000f,-0.85937500f,0.89062500f,-0.12500000f,0.20312500f,0.23437500f,0.95312500f,-0.15625000f,0.01562500f,0.78125000f,-0.65625000f,-0.84375000f,0.50000000f,0.90625000f,-0.04687500f,-0.31250000f,-0.68750000f,0.34375000f,-0.89062500f,0.75000000f,-0.26562500f,0.50000000f,-0.07812500f,0.09375000f,0.25000000f,0.23437500f,0.90625000f,-0.96875000f,-0.10937500f,-0.15625000f,-0.09375000f,0.78125000f,-0.14062500f,-0.45312500f,-0.37500000f,0.04687500f,0.59375000f,-0.68750000f,-0.23437500f,-0.20312500f,-0.57812500f,0.96875000f,0.57812500f,0.75000000f,-0.84375000f,0.85937500f,0.42187500f,0.04687500f,0.67187500f,0.03125000f,-0.95312500f,-0.95312500f,-0.79687500f,-0.31250000f,-0.07812500f,0.60937500f,-0.75000000f,0.18750000f,-0.09375000f,0.18750000f,0.82812500f,0.70312500f,0.90625000f,-0.48437500f,0.21875000f,-0.15625000f,-0.32812500f,-0.29687500f,-0.23437500f,0.14062500f,-0.54687500f,0.64062500f,-0.26562500f,-0.87500000f,-0.92187500f,-0.31250000f,-0.57812500f,0.82812500f,0.26562500f,0.53125000f,-0.81250000f,-0.96875000f,0.23437500f,-0.29687500f,0.54687500f,0.07812500f,-0.03125000f,0.53125000f,-0.09375000f,0.75000000f,-0.46875000f,-0.09375000f,0.93750000f,-0.39062500f,0.51562500f,-0.39062500f,-0.81250000f,-0.23437500f,0.56250000f,-0.95312500f,0.98437500f,-0.71875000f,-0.28125000f,0.65625000f,0.64062500f,-0.32812500f,0.90625000f,-0.20312500f,-0.71875000f,-0.48437500f,-0.17187500f,0.64062500f,0.09375000f,0.90625000f,-0.12500000f,0.42187500f,-0.50000000f,-0.89062500f,-0.28125000f,-0.98437500f,0.21875000f,0.85937500f,-0.76562500f,0.43750000f,0.67187500f,-0.92187500f,-0.70312500f,-0.57812500f,0.14062500f,-0.17187500f,-0.15625000f,0.29687500f,0.62500000f,-0.64062500f,-0.29687500f,-0.92187500f,-0.76562500f,-0.37500000f,0.01562500f,0.60937500f,0.35937500f,0.42187500f,-0.43750000f,0.12500000f,-0.90625000f,-0.73437500f,0.09375000f,-0.40625000f,-0.98437500f,0.57812500f,0.50000000f,0.57812500f,-0.60937500f,0.23437500f,0.84375000f,0.67187500f,0.73437500f,-0.78125000f,-0.89062500f,0.51562500f,-0.62500000f,-0.90625000f,0.43750000f,0.39062500f,-0.56250000f,0.60937500f,-0.21875000f,-0.84375000f,0.96875000f,-0.46875000f,-0.82812500f,-0.75000000f,0.85937500f,-0.81250000f,-0.26562500f,0.89062500f,-0.42187500f,-0.78125000f,-0.82812500f,-0.46875000f,1.00000000f,-0.57812500f,-0.35937500f,0.92187500f,0.89062500f,0.34375000f,-0.25000000f,0.29687500f,-0.65625000f,-0.87500000f,-0.18750000f,-0.45312500f,-0.15625000f,-0.78125000f,0.15625000f,0.25000000f,0.14062500f,0.84375000f,-0.90625000f,0.18750000f,0.78125000f,-0.26562500f,-0.62500000f,-0.87500000f,0.84375000f,-0.32812500f,-0.31250000f,-0.95312500f,-0.85937500f,-0.48437500f,-0.21875000f,-0.29687500f,0.12500000f,0.57812500f,0.53125000f,-0.67187500f,0.75000000f,-0.56250000f,0.65625000f,0.92187500f,0.60937500f,-0.54687500f,-0.40625000f,0.45312500f,-0.40625000f,-0.76562500f,0.59375000f,-0.84375000f,-1.00000000f,1.00000000f,0.37500000f,0.68750000f,-0.56250000f,-0.89062500f,0.51562500f,-0.90625000f,-0.40625000f,0.76562500f,0.85937500f,0.10937500f,0.14062500f,0.79687500f,0.76562500f,-0.92187500f,0.57812500f,0.68750000f,1.00000000f,0.25000000f,0.78125000f,-0.50000000f,-0.31250000f,-0.54687500f,0.65625000f,-0.95312500f,0.75000000f,-0.37500000f,-0.65625000f,0.25000000f,0.60937500f,-0.20312500f,-0.76562500f,-0.07812500f,-0.15625000f,-0.23437500f,0.00000000f,0.84375000f,-0.53125000f,-0.56250000f,0.68750000f,-0.57812500f,-0.48437500f,-0.50000000f,0.54687500f,-0.01562500f,0.25000000f,-1.00000000f,0.64062500f,0.95312500f,-0.51562500f,0.06250000f,-0.04687500f,-0.25000000f,-0.01562500f,0.53125000f,-0.07812500f,0.23437500f,-0.87500000f,-0.96875000f,-0.23437500f,0.51562500f,-0.98437500f,0.96875000f,-0.68750000f,-0.06250000f,-0.67187500f,0.78125000f,0.28125000f,0.32812500f,-0.50000000f,0.54687500f,1.00000000f,0.28125000f,-0.51562500f,-0.20312500f,0.70312500f,-0.12500000f,0.39062500f,0.43750000f,-0.25000000f,0.67187500f,-0.43750000f,0.76562500f,-0.98437500f,-0.01562500f,-0.56250000f,0.79687500f,0.46875000f,-0.67187500f,0.26562500f,-0.95312500f,-0.03125000f,0.20312500f,0.75000000f,-0.04687500f,0.82812500f,-0.90625000f,0.29687500f,0.70312500f,0.35937500f,-0.84375000f,0.20312500f,-0.32812500f,-0.78125000f,-0.51562500f,0.67187500f,0.23437500f,-0.65625000f,-0.71875000f,0.76562500f,-0.62500000f,0.78125000f,0.26562500f,0.53125000f,-0.53125000f,0.71875000f,1.00000000f,-0.59375000f,0.82812500f,0.89062500f,-0.40625000f,0.42187500f,-0.79687500f,-0.67187500f,-1.00000000f,-0.18750000f,0.39062500f,0.46875000f,0.92187500f,0.82812500f,-0.32812500f,0.23437500f,-0.78125000f,0.79687500f,-0.82812500f,0.46875000f,0.25000000f,0.59375000f,-0.03125000f,-0.03125000f,0.35937500f,-0.62500000f,0.90625000f,0.48437500f,-0.39062500f,0.29687500f,-0.46875000f,0.50000000f,0.50000000f,0.79687500f,0.29687500f,0.70312500f,0.60937500f,-0.43750000f,0.10937500f,-1.00000000f,0.17187500f,-0.09375000f,-0.71875000f,0.00000000f,-0.89062500f,0.57812500f,-0.70312500f,0.68750000f,-0.60937500f,0.07812500f,0.25000000f,0.34375000f,-0.57812500f,0.34375000f,-0.70312500f,0.17187500f,0.31250000f,0.34375000f,0.18750000f,-0.81250000f,-0.12500000f,0.87500000f,0.65625000f,0.00000000f,0.75000000f,0.43750000f,0.96875000f,0.14062500f,0.51562500f,-0.12500000f,-0.14062500f,-0.60937500f,0.70312500f,-0.14062500f,-0.29687500f,0.31250000f,0.84375000f,0.64062500f,0.79687500f,-0.25000000f,-0.06250000f,-0.57812500f,-0.51562500f,0.65625000f,0.90625000f,-0.68750000f,0.76562500f,0.68750000f,-0.59375000f,-0.90625000f,-0.23437500f,0.03125000f,-0.12500000f,-0.32812500f,-0.95312500f,-0.14062500f,0.56250000f,-0.10937500f,-0.51562500f,0.65625000f,0.07812500f,0.85937500f,0.00000000f,-0.32812500f,0.93750000f,0.85937500f,0.92187500f,0.53125000f,-0.59375000f,-0.32812500f,0.78125000f,0.67187500f,-1.00000000f,-0.56250000f,0.73437500f,-0.50000000f,0.20312500f,-0.43750000f,-0.15625000f,0.56250000f,-0.56250000f,0.42187500f,-0.04687500f,-0.92187500f,-0.79687500f,0.31250000f,-0.37500000f,-0.10937500f,1.00000000f,-0.42187500f,-0.65625000f,0.21875000f,0.17187500f,0.71875000f,0.28125000f,-0.48437500f,-0.53125000f,0.73437500f,0.23437500f,-0.17187500f,-0.60937500f,-0.95312500f,-0.43750000f,-0.10937500f,0.00000000f,0.87500000f,-0.96875000f,-0.45312500f,-0.21875000f,0.59375000f,0.00000000f,0.20312500f,0.17187500f,0.82812500f,-0.62500000f,-0.50000000f,0.96875000f,0.85937500f,0.35937500f,-0.73437500f,-0.21875000f,0.75000000f,-0.45312500f,-0.40625000f,0.26562500f,0.79687500f,0.50000000f,0.14062500f,0.76562500f,0.84375000f,0.26562500f,0.92187500f,0.64062500f,0.45312500f,0.78125000f,0.25000000f,0.81250000f,1.00000000f,0.89062500f,0.78125000f,0.67187500f,0.79687500f,0.21875000f,0.29687500f,-0.93750000f,-0.84375000f,0.46875000f,0.42187500f,-0.56250000f,0.57812500f,0.01562500f,0.64062500f,-0.01562500f,0.09375000f,0.62500000f,0.96875000f,-0.01562500f,-0.46875000f,0.15625000f,-0.75000000f,-0.56250000f,-0.06250000f,0.00000000f,-0.46875000f,0.00000000f,-0.06250000f,0.18750000f,0.31250000f,0.15625000f,-0.90625000f,-0.76562500f,0.01562500f,0.93750000f,-0.32812500f,-0.90625000f,0.56250000f,0.39062500f,0.09375000f,0.73437500f,-0.40625000f,0.81250000f,-0.73437500f,-0.57812500f,-0.62500000f,-0.51562500f,-0.96875000f,-0.18750000f,0.54687500f,0.71875000f,-0.59375000f,0.32812500f,0.98437500f,0.12500000f,-0.12500000f,-0.15625000f,-0.25000000f,-0.65625000f,0.62500000f,-0.70312500f,0.95312500f,0.68750000f,1.00000000f,0.95312500f,0.34375000f,0.45312500f,0.10937500f,-1.00000000f,0.70312500f,-0.57812500f,-0.09375000f,-0.67187500f,0.17187500f,-0.40625000f,-0.42187500f,0.98437500f,0.09375000f,0.26562500f,0.90625000f,0.87500000f,-0.17187500f,-0.65625000f,-0.71875000f,-0.95312500f,0.68750000f,0.54687500f,-0.73437500f,-0.96875000f,-0.87500000f,-0.73437500f,-0.25000000f,-0.59375000f,-0.53125000f,-0.17187500f,0.53125000f,-0.84375000f,0.76562500f,-0.59375000f,-0.76562500f,-0.85937500f,0.68750000f,0.76562500f,0.06250000f,0.14062500f,-0.48437500f,0.53125000f,-0.48437500f,-0.81250000f,0.34375000f,-0.67187500f,-0.51562500f,0.10937500f,0.53125000f,-0.23437500f,0.53125000f,-0.87500000f,-0.76562500f,-0.03125000f,-0.73437500f,0.82812500f,-0.89062500f,0.23437500f,-0.76562500f,0.25000000f,0.85937500f,-0.96875000f,-0.18750000f,-0.71875000f,0.37500000f,0.29687500f,0.37500000f,-0.78125000f,-0.98437500f,-0.50000000f,-0.60937500f,-0.26562500f,0.45312500f,0.90625000f,-0.87500000f,-0.18750000f,0.32812500f,0.92187500f,0.10937500f,-0.03125000f,0.56250000f,-0.26562500f,0.43750000f,0.53125000f,0.68750000f,0.00000000f,0.18750000f,-0.87500000f,-0.70312500f,-0.14062500f,-0.45312500f,-0.06250000f,-0.21875000f,-0.28125000f,1.00000000f,0.64062500f,-0.93750000f,0.45312500f,0.31250000f,-0.76562500f,0.90625000f,0.65625000f,0.10937500f,-0.64062500f,0.03125000f,0.20312500f,-0.18750000f,-0.17187500f,-0.34375000f,-0.09375000f,-0.32812500f,-0.81250000f,0.87500000f,0.76562500f,-0.01562500f,-0.79687500f,0.67187500f,-0.26562500f,0.98437500f,-0.26562500f,-0.35937500f,-0.34375000f,-0.09375000f,0.43750000f,-0.35937500f,-0.21875000f,-0.56250000f,0.04687500f,-0.25000000f,-0.76562500f,-0.29687500f,0.62500000f,-0.40625000f,0.87500000f,0.28125000f,0.32812500f,0.45312500f,0.57812500f,0.73437500f,-0.93750000f,0.92187500f,0.40625000f,0.40625000f,-0.21875000f,-0.10937500f,-0.10937500f,-0.75000000f,-0.90625000f,0.34375000f,0.70312500f,-0.21875000f,-0.71875000f,0.35937500f,-0.17187500f,0.12500000f,0.15625000f,-0.48437500f,0.90625000f,0.29687500f,0.96875000f,-0.70312500f,0.98437500f,-0.32812500f,-0.87500000f,-0.25000000f,-0.20312500f,-0.46875000f,0.67187500f,0.31250000f,-0.68750000f,-0.73437500f,-0.82812500f,0.98437500f,0.18750000f,-0.45312500f,0.56250000f,0.89062500f,0.42187500f,0.81250000f,-0.45312500f,-0.39062500f,0.92187500f,-0.28125000f,0.75000000f,-0.50000000f,-0.35937500f,-0.59375000f,-0.51562500f,0.89062500f,0.98437500f,-0.51562500f,-0.43750000f,-0.64062500f,0.79687500f,0.62500000f,0.98437500f,-0.51562500f,-0.95312500f,0.85937500f,-0.51562500f,0.64062500f,0.54687500f,0.23437500f,0.20312500f,-0.90625000f,-0.90625000f,0.45312500f,0.53125000f,-0.76562500f,-0.70312500f,0.90625000f,-0.95312500f,-0.84375000f,0.98437500f,-0.92187500f,0.04687500f,0.48437500f,-0.42187500f,-0.79687500f,0.93750000f,-0.85937500f,0.93750000f,0.10937500f,0.96875000f,-0.85937500f,0.01562500f,-0.57812500f,-0.37500000f,0.56250000f,0.37500000f,0.59375000f,0.70312500f,0.04687500f,-0.20312500f,0.53125000f,0.82812500f,-0.95312500f,0.06250000f,-0.62500000f,0.25000000f,0.76562500f,1.00000000f,0.53125000f,0.37500000f,0.57812500f,-0.04687500f,0.48437500f,0.78125000f,-0.54687500f,0.78125000f,-0.48437500f,-0.92187500f,0.03125000f,0.35937500f,0.82812500f,-0.53125000f,-0.32812500f,-0.26562500f,0.65625000f,-0.84375000f,0.34375000f,-0.21875000f,0.79687500f,-0.65625000f,0.14062500f,0.37500000f,-0.06250000f,-0.50000000f,-0.39062500f,0.54687500f,-0.87500000f,-0.26562500f,-0.07812500f,-0.28125000f,-0.20312500f,-0.34375000f,-0.32812500f,-0.21875000f,-0.26562500f,-0.01562500f,-0.75000000f,0.20312500f,0.62500000f,-0.53125000f,-0.07812500f,0.34375000f,0.39062500f,-0.28125000f,0.20312500f,-0.76562500f,0.92187500f,-0.60937500f,0.40625000f,-0.71875000f,0.71875000f,0.64062500f,-0.67187500f,0.84375000f,-0.10937500f,0.62500000f,-0.73437500f,0.75000000f,0.18750000f,0.68750000f,0.87500000f,0.96875000f,-0.90625000f,-0.93750000f,0.03125000f,-0.51562500f,-0.96875000f,0.70312500f,0.59375000f,-0.04687500f,-0.28125000f,0.28125000f,-0.43750000f,-0.48437500f,0.48437500f,-0.93750000f,0.34375000f,-0.82812500f,0.23437500f,-0.95312500f,0.34375000f,0.96875000f,0.95312500f,0.46875000f,-0.96875000f,0.76562500f,0.57812500f,-0.73437500f,0.90625000f,0.60937500f,-0.78125000f,-0.59375000f,-0.29687500f,0.35937500f,-0.09375000f,0.75000000f,-0.45312500f,0.00000000f,0.03125000f,-0.15625000f,-0.85937500f,-0.40625000f,-0.31250000f,0.06250000f,-0.06250000f,-0.35937500f,0.70312500f,-0.75000000f,-0.48437500f,0.92187500f,0.68750000f,-0.42187500f,-0.20312500f,-0.23437500f,0.35937500f,0.34375000f,0.34375000f,0.68750000f,0.78125000f,0.67187500f,0.45312500f,-0.31250000f,0.04687500f,0.92187500f,-0.07812500f,0.70312500f,-0.62500000f,0.95312500f,0.84375000f,-1.00000000f,-0.81250000f,-0.14062500f,0.12500000f,0.57812500f,-0.68750000f,-0.14062500f,-0.98437500f,-0.51562500f,-0.40625000f,0.67187500f,0.73437500f,-0.45312500f,-0.89062500f,0.09375000f,0.00000000f,-0.56250000f,0.98437500f,0.75000000f,0.98437500f,-0.48437500f,-0.48437500f,0.50000000f,-0.57812500f,-0.65625000f,0.04687500f,0.85937500f,-0.09375000f,0.50000000f,-0.85937500f,-0.81250000f,0.95312500f,-0.26562500f,0.26562500f,-0.45312500f,0.03125000f,-0.50000000f,0.82812500f