//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

#include <algorithm>
#include <cinttypes>
#include <cmath>
#include <cstdlib>
#include <random>
#include <string>

// clang-format off
#ifdef ${BACKEND_NAME}_FLOAT_TOLERANCE_BITS
#define DEFAULT_FLOAT_TOLERANCE_BITS ${BACKEND_NAME}_FLOAT_TOLERANCE_BITS
#endif

#ifdef ${BACKEND_NAME}_DOUBLE_TOLERANCE_BITS
#define DEFAULT_DOUBLE_TOLERANCE_BITS ${BACKEND_NAME}_DOUBLE_TOLERANCE_BITS
#endif
// clang-format on

#include "gtest/gtest.h"
#include "ngraph/ngraph.hpp"
#include "util/all_close.hpp"
#include "util/all_close_f.hpp"
#include "util/ndarray.hpp"
#include "util/test_control.hpp"
#include "util/test_tools.hpp"

using namespace std;
using namespace ngraph;

static string s_manifest = "${MANIFEST}";

NGRAPH_TEST(${BACKEND_NAME}, atan2)
{
    Shape shape{30};
    auto X = make_shared<op::v0::Parameter>(element::f32, shape);
    auto Y = make_shared<op::v0::Parameter>(element::f32, shape);
    auto f = make_shared<Function>(make_shared<op::v0::Atan2>(Y, X), ParameterVector{X, Y});

    auto backend = runtime::Backend::create("${BACKEND_NAME}");

    // Create some tensors for input/output
    shared_ptr<runtime::Tensor> x = backend->create_tensor(element::f32, shape);
    shared_ptr<runtime::Tensor> y = backend->create_tensor(element::f32, shape);
    shared_ptr<runtime::Tensor> result = backend->create_tensor(element::f32, shape);

    std::vector<float> xref;
    std::vector<float> yref;
    std::vector<float> zref;
    int halfelts = shape.at(0) / 2;
    float scale = 1.0 / (halfelts * 4.0 * std::atan(1.0));
    for (int i = 0; i < halfelts; ++i)
    {
        float theta = i * scale;
        zref.push_back(theta);
        xref.push_back(static_cast<float>((i + 1) * std::cos(theta)));
        yref.push_back(static_cast<float>((i + 1) * std::sin(theta)));
        zref.push_back(-theta);
        xref.push_back(static_cast<float>((i + 1) * std::cos(-theta)));
        yref.push_back(static_cast<float>((i + 1) * std::sin(-theta)));
    }

    copy_data(x, xref);
    copy_data(y, yref);

    auto handle = backend->compile(f);
    handle->call_with_validate({result}, {x, y});
    EXPECT_TRUE(test::all_close_f(read_vector<float>(result), (zref)));
}
