//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

#pragma once

#include <memory>

#include "ngraph/runtime/backend.hpp"
#include "ngraph/runtime/tensor.hpp"
#include "ngraph/type/element_type.hpp"

namespace ngraph
{
    namespace runtime
    {
        namespace gpu
        {
            class GPUTensor;
        }
    }
}

class ngraph::runtime::gpu::GPUTensor : public ngraph::runtime::Tensor
{
public:
    GPUTensor(const ngraph::element::Type& element_type, const Shape& shape);
    GPUTensor(const ngraph::element::Type& element_type, const Shape& shape, void* memory_pointer);
    virtual ~GPUTensor() override;

    /// \brief Write bytes directly into the tensor
    /// \param p Pointer to source of data
    /// \param n_bytes Number of bytes to write, must be integral number of elements.
    void write(const void* p, size_t n_bytes) override;

    /// \brief Read bytes directly from the tensor
    /// \param p Pointer to destination for data
    /// \param n_bytes Number of bytes to read, must be integral number of elements.
    void read(void* p, size_t n_bytes) const override;

    /// \brief Copy directly from the another GPU tensor
    /// \param source Another GPU tensor
    void copy_from(const runtime::Tensor& source) override;

    void* m_allocated_buffer_pool = nullptr;
    size_t m_buffer_size;
    bool m_custom_memory;

private:
    GPUTensor(const GPUTensor&) = delete;
    GPUTensor(GPUTensor&&) = delete;
    GPUTensor& operator=(const GPUTensor&) = delete;
};
