//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

#pragma once

#include "ngraph/op/util/op_annotations.hpp"

namespace ngraph
{
    namespace runtime
    {
        namespace gpu
        {
            /// \brief Annotations added to graph ops by GPU backend passes
            class GPUOpAnnotations : public ngraph::op::util::OpAnnotations
            {
            public:
                virtual ~GPUOpAnnotations() = default;
            };

            class BatchNormBackpropAnnotations : public GPUOpAnnotations
            {
            public:
                ~BatchNormBackpropAnnotations() = default;
                bool has_inverted_variance() { return m_inv_variance; }
                void set_inverted_variance(bool b) { m_inv_variance = b; }

            private:
                bool m_inv_variance = false;
            };
        }
    }
}
