//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

#include "ngraph/runtime/cpu/cpu_op_annotations.hpp"
#include "ngraph/op/util/op_annotations.hpp"

namespace ngraph
{
    namespace runtime
    {
        namespace cpu
        {
            std::function<std::shared_ptr<ngraph::op::util::OpAnnotations>(void)>
                get_annotations_factory()
            {
                std::function<std::shared_ptr<ngraph::op::util::OpAnnotations>(void)> func =
                    []() -> std::shared_ptr<ngraph::op::util::OpAnnotations> {
                    auto op_annotations =
                        std::make_shared<ngraph::runtime::cpu::CPUOpAnnotations>();
                    return std::move(op_annotations);
                };
                return func;
            }
        }
    }
}
