
/*
Code for Import https://scriptui.joonas.me — (Triple click to select): 
{"activeId":23,"items":{"item-0":{"id":0,"type":"Dialog","parentId":false,"style":{"enabled":true,"varName":null,"windowType":"Dialog","creationProps":{"su1PanelCoordinates":false,"maximizeButton":false,"minimizeButton":false,"independent":false,"closeButton":true,"borderless":false,"resizeable":false},"text":"MKFont Artboard Creation","preferredSize":[0,0],"margins":16,"orientation":"column","spacing":10,"alignChildren":["center","top"]}},"item-1":{"id":1,"type":"Group","parentId":6,"style":{"enabled":true,"varName":"aparams","preferredSize":[0,50],"margins":0,"orientation":"row","spacing":10,"alignChildren":["center","center"],"alignment":"center"}},"item-2":{"id":2,"type":"StaticText","parentId":1,"style":{"enabled":true,"varName":null,"creationProps":{"truncate":"none","multiline":false,"scrolling":false},"softWrap":false,"text":"Width","justify":"left","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-3":{"id":3,"type":"EditText","parentId":1,"style":{"enabled":true,"varName":"aWidth","creationProps":{"noecho":false,"readonly":false,"multiline":false,"scrollable":false,"borderless":false,"enterKeySignalsOnChange":false},"softWrap":false,"text":"100","justify":"left","preferredSize":[50,0],"alignment":null,"helpTip":""}},"item-4":{"id":4,"type":"EditText","parentId":1,"style":{"enabled":true,"varName":"aHeight","creationProps":{"noecho":false,"readonly":false,"multiline":false,"scrollable":false,"borderless":false,"enterKeySignalsOnChange":false},"softWrap":false,"text":"100","justify":"left","preferredSize":[50,0],"alignment":null,"helpTip":null}},"item-5":{"id":5,"type":"StaticText","parentId":1,"style":{"enabled":true,"varName":null,"creationProps":{"truncate":"none","multiline":false,"scrolling":false},"softWrap":false,"text":"Height","justify":"left","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-6":{"id":6,"type":"Panel","parentId":8,"style":{"enabled":true,"varName":null,"creationProps":{"borderStyle":"etched","su1PanelCoordinates":false},"text":"Artboard settings","preferredSize":[450,0],"margins":10,"orientation":"column","spacing":10,"alignChildren":["left","top"],"alignment":null}},"item-8":{"id":8,"type":"Group","parentId":0,"style":{"enabled":true,"varName":null,"preferredSize":[0,0],"margins":0,"orientation":"row","spacing":10,"alignChildren":["left","top"],"alignment":null}},"item-9":{"id":9,"type":"StaticText","parentId":1,"style":{"enabled":true,"varName":null,"creationProps":{"truncate":"none","multiline":false,"scrolling":false},"softWrap":false,"text":"Spacing","justify":"left","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-10":{"id":10,"type":"EditText","parentId":1,"style":{"enabled":true,"varName":"aSpace","creationProps":{"noecho":false,"readonly":false,"multiline":false,"scrollable":false,"borderless":false,"enterKeySignalsOnChange":false},"softWrap":false,"text":"50","justify":"left","preferredSize":[50,0],"alignment":null,"helpTip":null}},"item-11":{"id":11,"type":"Checkbox","parentId":24,"style":{"enabled":true,"varName":"doAddLabel","text":"Add character label","preferredSize":[0,0],"alignment":"center","helpTip":"Adds a textfield with the character associated to the artboard","checked":true}},"item-12":{"id":12,"type":"Divider","parentId":6,"style":{"enabled":true,"varName":null}},"item-13":{"id":13,"type":"EditText","parentId":0,"style":{"enabled":true,"varName":"uList","creationProps":{"noecho":false,"readonly":false,"multiline":true,"scrollable":true,"borderless":false,"enterKeySignalsOnChange":false},"softWrap":false,"text":"","justify":"left","preferredSize":[450,100],"alignment":"center","helpTip":null}},"item-14":{"id":14,"type":"StaticText","parentId":0,"style":{"enabled":true,"varName":null,"creationProps":{"truncate":"none","multiline":false,"scrolling":false},"softWrap":false,"text":"Unicode values (U+0000...)","justify":"left","preferredSize":[0,0],"alignment":null,"helpTip":"Comma (,) or New line (\\n) -separated unicode hex values. There's a button for that in MKFont!"}},"item-15":{"id":15,"type":"Divider","parentId":0,"style":{"enabled":true,"varName":null}},"item-16":{"id":16,"type":"Button","parentId":17,"style":{"enabled":true,"varName":"ok","text":"Generate!","justify":"center","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-17":{"id":17,"type":"Group","parentId":0,"style":{"enabled":true,"varName":"actions","preferredSize":[0,0],"margins":0,"orientation":"row","spacing":10,"alignChildren":["left","center"],"alignment":null}},"item-18":{"id":18,"type":"Button","parentId":17,"style":{"enabled":true,"varName":"cancel","text":"Cancel","justify":"center","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-19":{"id":19,"type":"Divider","parentId":6,"style":{"enabled":true,"varName":null}},"item-20":{"id":20,"type":"Group","parentId":6,"style":{"enabled":true,"varName":null,"preferredSize":[0,0],"margins":0,"orientation":"row","spacing":10,"alignChildren":["center","center"],"alignment":"center"}},"item-21":{"id":21,"type":"StaticText","parentId":20,"style":{"enabled":true,"varName":null,"creationProps":{"truncate":"none","multiline":false,"scrolling":false},"softWrap":false,"text":"Desired # of artboard per row","justify":"left","preferredSize":[0,0],"alignment":null,"helpTip":null}},"item-22":{"id":22,"type":"EditText","parentId":20,"style":{"enabled":true,"varName":null,"creationProps":{"noecho":false,"readonly":false,"multiline":false,"scrollable":false,"borderless":false,"enterKeySignalsOnChange":false},"softWrap":false,"text":"50","justify":"left","preferredSize":[50,0],"alignment":null,"helpTip":null}},"item-23":{"id":23,"type":"Checkbox","parentId":24,"style":{"enabled":true,"varName":"doAddOutlines","text":"Add character outlines","preferredSize":[0,0],"alignment":null,"helpTip":null,"checked":true}},"item-24":{"id":24,"type":"Group","parentId":6,"style":{"enabled":true,"varName":"options","preferredSize":[0,0],"margins":0,"orientation":"row","spacing":10,"alignChildren":["left","center"],"alignment":"center"}}},"order":[0,8,6,1,2,3,5,4,9,10,19,20,21,22,12,24,11,23,14,13,15,17,16,18],"settings":{"importJSON":true,"indentSize":false,"cepExport":false,"includeCSSJS":true,"showDialog":true,"functionWrapper":false,"afterEffectsDockable":false,"itemReferenceList":"None"}}
*/

// DIALOG
// ======
var dialog = new Window("dialog");
dialog.text = "MKFont Artboard Creation";
dialog.orientation = "column";
dialog.alignChildren = ["center", "top"];
dialog.spacing = 10;
dialog.margins = 16;

// GROUP1
// ======
var group1 = dialog.add("group", undefined, { name: "group1" });
group1.orientation = "row";
group1.alignChildren = ["left", "top"];
group1.spacing = 10;
group1.margins = 0;

// PANEL1
// ======
var panel1 = group1.add("panel", undefined, undefined, { name: "panel1" });
panel1.text = "Artboard settings";
panel1.preferredSize.width = 450;
panel1.orientation = "column";
panel1.alignChildren = ["left", "top"];
panel1.spacing = 10;
panel1.margins = 10;

// APARAMS
// =======
var aparams = panel1.add("group", undefined, { name: "aparams" });
aparams.preferredSize.height = 50;
aparams.orientation = "row";
aparams.alignChildren = ["center", "center"];
aparams.spacing = 10;
aparams.margins = 0;
aparams.alignment = ["center", "top"];

var statictext1 = aparams.add("statictext", undefined, undefined, { name: "statictext1" });
statictext1.text = "Width";

var aWidth = aparams.add('edittext {properties: {name: "aWidth"}}');
aWidth.text = "100";
aWidth.preferredSize.width = 50;

var statictext2 = aparams.add("statictext", undefined, undefined, { name: "statictext2" });
statictext2.text = "Height";

var aHeight = aparams.add('edittext {properties: {name: "aHeight"}}');
aHeight.text = "100";
aHeight.preferredSize.width = 50;

var statictext3 = aparams.add("statictext", undefined, undefined, { name: "statictext3" });
statictext3.text = "Spacing";

var aSpace = aparams.add('edittext {properties: {name: "aSpace"}}');
aSpace.text = "50";
aSpace.preferredSize.width = 50;

// PANEL1
// ======
var divider1 = panel1.add("panel", undefined, undefined, { name: "divider1" });
divider1.alignment = "fill";

// GROUP2
// ======
var group2 = panel1.add("group", undefined, { name: "group2" });
group2.orientation = "row";
group2.alignChildren = ["center", "center"];
group2.spacing = 10;
group2.margins = 0;
group2.alignment = ["center", "top"];

var statictext4 = group2.add("statictext", undefined, undefined, { name: "statictext4" });
statictext4.text = "Desired # of artboard per row";

var edittext1 = group2.add('edittext {properties: {name: "edittext1"}}');
edittext1.text = "50";
edittext1.preferredSize.width = 50;

// PANEL1
// ======
var divider2 = panel1.add("panel", undefined, undefined, { name: "divider2" });
divider2.alignment = "fill";

// OPTIONS
// =======
var options = panel1.add("group", undefined, { name: "options" });
options.orientation = "row";
options.alignChildren = ["left", "center"];
options.spacing = 10;
options.margins = 0;
options.alignment = ["center", "top"];

var doAddLabel = options.add("checkbox", undefined, undefined, { name: "doAddLabel" });
doAddLabel.helpTip = "Adds a textfield with the character associated to the artboard";
doAddLabel.text = "Add character label";
doAddLabel.value = true;
doAddLabel.alignment = ["left", "center"];

var doAddOutlines = options.add("checkbox", undefined, undefined, { name: "doAddOutlines" });
doAddOutlines.text = "Add character outlines";
doAddOutlines.value = true;

// DIALOG
// ======
var statictext5 = dialog.add("statictext", undefined, undefined, { name: "statictext5" });
statictext5.helpTip = "Comma (,) or New line (\n) -separated unicode hex values. There's a button for that in MKFont!";
statictext5.text = "Unicode values (U+0000...)";

var uList = dialog.add('edittext {properties: {name: "uList", multiline: true, scrollable: true}}');
uList.preferredSize.width = 450;
uList.preferredSize.height = 100;
uList.alignment = ["center", "top"];

var divider3 = dialog.add("panel", undefined, undefined, { name: "divider3" });
divider3.alignment = "fill";

// ACTIONS
// =======
var actions = dialog.add("group", undefined, { name: "actions" });
actions.orientation = "row";
actions.alignChildren = ["left", "center"];
actions.spacing = 10;
actions.margins = 0;

var ok = actions.add("button", undefined, undefined, { name: "ok" });
ok.text = "Generate!";

var cancel = actions.add("button", undefined, undefined, { name: "cancel" });
cancel.text = "Cancel";

dialog.actions.ok.onClick = OnOk;
dialog.actions.cancel.onClick = OnCancel;

function OnOk() {
    if (ParseList()) {
        GenerateArtboards();
        dialog.close();
    } else {
        alert("Unicode list is empty.");
    }
}

function OnCancel() {
    dialog.close();
}

/*************/

function trim(str) { return str.replace(/^\s+/, '').replace(/\s+$/, ''); }
function substr(str, start, end) {
    var result = "";
    for (var i = start; i < end; i++) { result += str[i]; }
    return result;
}
function substring(str, start, length) {
    var result = "";
    if (!length) { length = str.length - start; }
    for (var i = start; i < start + length; i++) { result += str[i]; }
    return result;
}
/*************/

var unicodeList = [];
var unicodeChars = [];

function ParseList() {

    var uinput = uList.text;
    if (uinput == "" || !uinput) { return false; }
    unicodeList = uinput.split("\n");
    if (unicodeList.length <= 1) { unicodeList = uinput.split(","); }
    if (unicodeList.length <= 1) { return false; }

    for (var i = 0; i < unicodeList.length; i++) {
        var u = trim(unicodeList[i]);
        unicodeList[i] = u;
        if (substr(u, 0, 2) == "U+") {
            var n = parseInt(u.substring(2), 16);
            unicodeChars.push(String.fromCharCode(n));
        } else {
            unicodeChars.push(u);
        }

    }

    return true;

}

function GenerateArtboards() {

    var codes = unicodeList;
    var w = Math.max(Param(aparams.aWidth, 100), 100);
    var h = Math.max(Param(aparams.aHeight, 100), 100);
    var sp = Math.max(Param(aparams.aSpace, 50), 50);
    var perRow = Math.min(16383 / (w + sp), 20);

    var docRef = app.documents.add(DocumentColorSpace.RGB, w, h, codes.length, DocumentArtboardLayout.GridByRow, sp, perRow);
    var layerLabels = docRef.layers.add();
    layerLabels.name = "labels";

    var layerOutlines = docRef.layers.add();
    layerOutlines.name = "reference outlines";

    for (var i = 0; i < codes.length; i++) {

        var artbrd = docRef.artboards[i];
        var text = unicodeChars[i];
        artbrd.name = unicodeList[i];

        AddLabel(text, layerLabels, artbrd);
        AddOutline(text, layerOutlines, artbrd, h);

    }

    layerLabels.locked = true;
    layerOutlines.locked = true;
}

function AddLabel(text, layer, artbrd) {

    var aRect = artbrd.artboardRect;
    var aX = aRect[0];
    var aY = aRect[3];

    var label = layer.textFrames.add();
    label.paragraphs.add(text);

    var tt = label.textRange.characters.length;
    for (var c = 0; c < tt; c++) {
        var tf = label.textRange.characters[c].characterAttributes;
        tf.size = 10;
    }

    var labelP = label.paragraphs[0].paragraphAttributes;
    labelP.justification = Justification.RIGHT;

    label.left = aX - (5 + label.width);
    label.top = aY + label.height;

}

function AddOutline(text, layer, artbrd, h) {

    var aRect = artbrd.artboardRect;
    var aX = aRect[0];
    var aY = aRect[3];

    var outline = layer.textFrames.add();
    outline.paragraphs.add(text);

    var _o = 0.25;
    var _r = (1/(1-_o));
    var _h = h * _r;

    var tt = outline.textRange.characters.length;
    for (var c = 0; c < tt; c++) {
        var ch = outline.textRange.characters[c];
        var tf = ch.characterAttributes;
        tf.size = _h;
    }

    var labelP = outline.paragraphs[0].paragraphAttributes;
    labelP.justification = Justification.LEFT;

    outline.left = aX;
    outline.top = (aY + (outline.height));
    outline.opacity = 25;

    for (var c = 0; c < tt; c++) {
        var ch = outline.textRange.characters[c];
        ch.baselineShift = -(_h * _o);
    }

    outline.createOutline();

}

function Param(input, fallback) {

    var num = Number(input.text);
    if (Number.isNaN(num)) { return fallback; }
    return num;

}


dialog.show();