'use strict';

const nkm = require(`@nkmjs/core`);
const u = nkm.u;
const CmdSetActiveRange = require(`./operations/commands/cmd-set-active-range`);
const UniBlock = require(`./catalogs/definition-uni-block`);
const UniCategory = require(`./catalogs/definition-uni-cat`);
const UniCategoryGroup = require(`./catalogs/definition-uni-cat-group`);

const _setActivateRangeCMD = new CmdSetActiveRange();

class UNICODE extends nkm.com.Observable {
    constructor() { super(); }

    get SetActiveRange() { return _setActivateRangeCMD; }

    get MAX_GLYPH_COUNT() { return 65534; }

    _Init() {

        super._Init();

        let c = {

			'Lu':{ name:'Uppercase', id:'Lu', col:'letter', count:1831, imin:33, imax:30814, icon:'directory', includes:[[33,58],[127,149],[151,157],191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,248,250,252,254,256,258,260,262,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,[311,312],314,316,[320,321],323,[325,326],[328,330],[333,336],[338,339],[341,343],[347,348],[350,351],353,355,[357,358],360,363,[365,366],[368,370],372,[374,375],379,387,390,393,396,398,400,402,404,406,408,410,413,415,417,419,421,423,425,427,429,432,435,[437,439],441,443,445,447,449,451,453,455,457,459,461,463,465,467,469,471,473,475,477,479,481,483,485,487,489,491,493,495,497,[505,506],[508,509],512,[514,517],519,521,523,525,815,817,821,828,831,[833,838],[840,865],901,[904,906],910,912,914,916,918,920,922,924,926,928,930,932,938,941,[943,944],[947,997],1046,1048,1050,1052,1054,1056,1058,1060,1062,1064,1066,1068,1070,1072,1074,1076,1078,1088,1090,1092,1094,1096,1098,1100,1102,1104,1106,1108,1110,1112,1114,1116,1118,1120,1122,1124,1126,1128,1130,1132,1134,1136,1138,1140,[1142,1143],1145,1147,1149,1151,1153,1155,1158,1160,1162,1164,1166,1168,1170,1172,1174,1176,1178,1180,1182,1184,1186,1188,1190,1192,1194,1196,1198,1200,1202,1204,1206,1208,1210,1212,1214,1216,1218,1220,1222,1224,1226,1228,1230,1232,1234,1236,1238,1240,1242,1244,1246,1248,1250,1252,[1254,1291],[3661,3700],[4389,4474],[6446,6491],6799,6801,6803,6805,6807,6809,6811,6813,6815,6817,6819,6821,6823,6825,6827,6829,6831,6833,6835,6837,6839,6841,6843,6845,6847,6849,6851,6853,6855,6857,6859,6861,6863,6865,6867,6869,6871,6873,6875,6877,6879,6881,6883,6885,6887,6889,6891,6893,6895,6897,6899,6901,6903,6905,6907,6909,6911,6913,6915,6917,6919,6921,6923,6925,6927,6929,6931,6933,6935,6937,6939,6941,6943,6945,6947,6957,6959,6961,6963,6965,6967,6969,6971,6973,6975,6977,6979,6981,6983,6985,6987,6989,6991,6993,6995,6997,6999,7001,7003,7005,7007,7009,7011,7013,7015,7017,7019,7021,7023,7025,7027,7029,7031,7033,7035,7037,7039,7041,7043,7045,7047,7049,7051,7053,[7063,7070],[7077,7082],[7091,7098],[7107,7114],[7121,7126],[7135,7138],[7147,7154],[7224,7227],[7239,7242],[7253,7256],[7268,7272],[7281,7284],7509,7514,[7518,7520],[7523,7525],7528,[7532,7536],7543,7545,7547,[7549,7552],[7555,7558],[7569,7570],7576,7638,[10270,10317],10366,[10368,10370],10373,10375,10377,[10379,10382],10384,10387,[10396,10398],10400,10402,10404,10406,10408,10410,10412,10414,10416,10418,10420,10422,10424,10426,10428,10430,10432,10434,10436,10438,10440,10442,10444,10446,10448,10450,10452,10454,10456,10458,10460,10462,10464,10466,10468,10470,10472,10474,10476,10478,10480,10482,10484,10486,10488,10490,10492,10494,10496,10505,10507,10512,13803,13805,13807,13809,13811,13813,13815,13817,13819,13821,13823,13825,13827,13829,13831,13833,13835,13837,13839,13841,13843,13845,13847,13867,13869,13871,13873,13875,13877,13879,13881,13883,13885,13887,13889,13891,13893,14021,14023,14025,14027,14029,14031,14033,14037,14039,14041,14043,14045,14047,14049,14051,14053,14055,14057,14059,14061,14063,14065,14067,14069,14071,14073,14075,14077,14079,14081,14083,14085,14087,14089,14091,14093,14095,14097,14108,14110,[14112,14113],14115,14117,14119,14121,14126,14128,14131,14133,14137,14139,14141,14143,14145,14147,14149,14151,14153,14155,[14157,14161],[14163,14167],14169,14171,14173,14175,14177,14179,14181,[14183,14186],14188,14190,14194,14196,14201,[16627,16652],[17528,17567],[17696,17731],[17861,17895],[19094,19144],[20744,20775],[25433,25464],[28642,28667],[28694,28719],[28745,28770],[28797,28814],[28838,28863],[28890,28910],[28937,28955],[28982,29007],[29034,29059],[29086,29111],[29138,29163],[29190,29215],[29242,29267],[29296,29320],[29354,29378],[29412,29436],[29470,29494],[29528,29552],29586,[30781,30814]] },
			'Ll':{ name:'Lowercase', id:'Ll', col:'letter', count:2227, imin:65, imax:30848, icon:'directory', includes:[[65,90],116,[158,181],[183,190],192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,[246,247],249,251,253,255,257,259,261,[263,264],266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,313,315,[317,319],322,324,327,[331,332],337,340,[344,346],349,352,354,356,359,[361,362],364,367,371,373,[376,377],[380,382],389,392,395,397,399,401,403,405,407,409,[411,412],414,416,418,420,422,424,426,428,[430,431],434,436,440,442,444,446,448,450,452,454,456,458,460,462,464,466,468,470,472,474,476,478,480,482,484,486,488,490,492,494,496,[498,504],507,[510,511],513,518,520,522,524,[526,594],[596,622],816,818,822,[824,826],839,[866,900],[902,903],[907,909],911,913,915,917,919,921,923,925,927,929,931,[933,937],939,942,[945,946],[998,1045],1047,1049,1051,1053,1055,1057,1059,1061,1063,1065,1067,1069,1071,1073,1075,1077,1079,1089,1091,1093,1095,1097,1099,1101,1103,1105,1107,1109,1111,1113,1115,1117,1119,1121,1123,1125,1127,1129,1131,1133,1135,1137,1139,1141,1144,1146,1148,1150,1152,1154,[1156,1157],1159,1161,1163,1165,1167,1169,1171,1173,1175,1177,1179,1181,1183,1185,1187,1189,1191,1193,1195,1197,1199,1201,1203,1205,1207,1209,1211,1213,1215,1217,1219,1221,1223,1225,1227,1229,1231,1233,1235,1237,1239,1241,1243,1245,1247,1249,1251,1253,[1299,1339],[3701,3743],[3746,3748],[4475,4480],[6437,6445],[6543,6586],[6650,6662],[6664,6697],6800,6802,6804,6806,6808,6810,6812,6814,6816,6818,6820,6822,6824,6826,6828,6830,6832,6834,6836,6838,6840,6842,6844,6846,6848,6850,6852,6854,6856,6858,6860,6862,6864,6866,6868,6870,6872,6874,6876,6878,6880,6882,6884,6886,6888,6890,6892,6894,6896,6898,6900,6902,6904,6906,6908,6910,6912,6914,6916,6918,6920,6922,6924,6926,6928,6930,6932,6934,6936,6938,6940,6942,6944,6946,[6948,6956],6958,6960,6962,6964,6966,6968,6970,6972,6974,6976,6978,6980,6982,6984,6986,6988,6990,6992,6994,6996,6998,7000,7002,7004,7006,7008,7010,7012,7014,7016,7018,7020,7022,7024,7026,7028,7030,7032,7034,7036,7038,7040,7042,7044,7046,7048,7050,7052,[7054,7062],[7071,7076],[7083,7090],[7099,7106],[7115,7120],[7127,7134],[7139,7146],[7155,7176],[7185,7192],[7201,7208],[7217,7223],7230,[7234,7238],[7247,7252],[7260,7267],[7276,7280],7517,[7521,7522],7526,7554,7559,7564,[7567,7568],[7577,7580],7585,7639,[10318,10365],10367,[10371,10372],10374,10376,10378,10383,[10385,10386],[10388,10393],10399,10401,10403,10405,10407,10409,10411,10413,10415,10417,10419,10421,10423,10425,10427,10429,10431,10433,10435,10437,10439,10441,10443,10445,10447,10449,10451,10453,10455,10457,10459,10461,10463,10465,10467,10469,10471,10473,10475,10477,10479,10481,10483,10485,10487,10489,10491,10493,10495,[10497,10498],10506,10508,10513,[10521,10560],13804,13806,13808,13810,13812,13814,13816,13818,13820,13822,13824,13826,13828,13830,13832,13834,13836,13838,13840,13842,13844,13846,13848,13868,13870,13872,13874,13876,13878,13880,13882,13884,13886,13888,13890,13892,13894,14022,14024,14026,14028,14030,14032,[14034,14036],14038,14040,14042,14044,14046,14048,14050,14052,14054,14056,14058,14060,14062,14064,14066,14068,14070,14072,14074,14076,14078,14080,14082,14084,14086,14088,14090,14092,14094,14096,14098,[14100,14107],14109,14111,14114,14116,14118,14120,14122,14127,14129,14132,[14134,14136],14138,14140,14142,14144,14146,14148,14150,14152,14154,14156,14162,14168,14170,14172,14174,14176,14178,14180,14182,14187,14189,[14191,14193],14195,14197,14202,14206,[14915,14957],[14963,14971],[14975,15054],[15665,15676],[16659,16684],[17568,17607],[17732,17767],[17896,17930],[19145,19195],[20776,20807],[25465,25496],[28668,28693],[28720,28744],[28771,28796],[28815,28837],[28864,28889],[28911,28936],[28956,28981],[29008,29033],[29060,29085],[29112,29137],[29164,29189],[29216,29241],[29268,29295],[29322,29346],[29348,29353],[29380,29404],[29406,29411],[29438,29462],[29464,29469],[29496,29520],[29522,29527],[29554,29578],[29580,29585],29587,[30310,30319],[30321,30340],[30815,30848]] },
			'Lt':{ name:'Titlecase', id:'Lt', col:'letter', count:31, imin:388, imax:7285, icon:'directory', includes:[388,391,394,433,[7177,7184],[7193,7200],[7209,7216],7228,7243,7285] },
			'Mn':{ name:'Non-Spacing', id:'Mn', col:'mark', count:1950, imin:703, imax:34556, icon:'directory', includes:[[703,814],[1081,1085],[1345,1389],1391,[1393,1394],[1396,1397],1399,[1449,1459],[1508,1528],1545,[1647,1653],[1656,1661],[1664,1665],[1667,1670],1705,[1736,1762],[1852,1862],[1907,1915],1923,[1948,1951],[1953,1961],[1963,1965],[1967,1971],[2012,2014],[2060,2067],[2110,2133],[2135,2166],2222,2224,[2229,2236],2241,[2245,2251],[2262,2263],2293,2340,[2345,2348],2353,[2361,2362],[2387,2389],2434,[2438,2445],[2461,2462],2466,[2468,2469],2519,[2524,2530],2534,[2538,2539],[2553,2559],2608,2611,[2613,2616],[2621,2623],[2630,2631],2650,2689,2698,2722,2726,2777,[2779,2781],[2786,2794],[2801,2802],2823,2876,2879,2885,[2890,2891],[2898,2899],[2912,2913],[2969,2970],[2975,2978],2985,[3002,3003],3030,3092,[3096,3099],3169,[3172,3178],[3187,3194],3251,[3254,3262],[3270,3275],[3314,3315],3343,3345,3347,[3398,3411],[3413,3417],[3419,3420],[3426,3472],3481,[3546,3549],[3551,3556],[3558,3559],[3562,3563],[3589,3590],[3595,3597],[3614,3617],3631,[3634,3635],3642,3658,[4331,4333],[5257,5259],[5280,5281],[5303,5304],[5321,5322],[5375,5376],[5378,5384],5393,[5396,5406],5416,[5448,5450],5452,[5557,5558],5593,[5696,5698],[5703,5704],5710,[5717,5719],[5906,5907],5910,5967,[5969,5976],5978,[5981,5988],[5995,6005],[6040,6053],[6055,6074],6123,[6125,6129],6131,6137,[6175,6183],[6195,6196],[6229,6232],[6235,6236],[6238,6240],6297,[6299,6300],6304,[6306,6308],[6359,6366],[6369,6370],[6500,6502],[6504,6516],[6518,6524],6529,6536,[6540,6541],[6735,6798],[7474,7486],7491,[7495,7506],[10509,10511],10619,[10699,10730],[11208,11211],[11316,11317],13850,[13855,13864],[13897,13898],[13979,13980],14214,14218,14223,[14249,14250],14256,[14391,14392],[14405,14422],14436,[14475,14482],[14508,14518],[14551,14553],14602,[14605,14608],[14611,14612],14647,[14714,14719],[14722,14723],[14726,14727],14731,14740,14784,14836,[14838,14840],[14843,14844],[14850,14851],14853,[14872,14873],14882,15092,15095,15100,15678,[16354,16369],[16380,16395],17231,17310,[17442,17446],[18692,18700],[18737,18740],[18860,18861],[19238,19241],[19325,19326],[19392,19402],[19430,19433],19490,[19545,19559],19597,[19600,19601],[19603,19605],[19655,19658],[19661,19662],19670,[19707,19709],[19746,19750],[19752,19759],19813,[19817,19818],[19871,19879],[19890,19893],19896,[19979,19981],19984,[19986,19987],19994,20080,[20084,20091],[20102,20103],[20152,20153],20157,[20176,20187],[20244,20251],[20254,20256],20258,20281,[20336,20341],20343,[20348,20349],[20351,20352],[20417,20420],[20425,20426],[20428,20429],[20457,20458],[20510,20517],20520,[20522,20523],20594,20596,[20599,20604],20606,[20646,20648],[20651,20654],[20656,20660],[20731,20739],[20741,20742],[20878,20879],20881,20886,[20950,20955],20960,[20966,20975],[21016,21021],[21024,21027],21036,[21038,21043],[21046,21048],[21095,21107],[21109,21110],[21240,21252],21254,[21322,21343],[21345,21351],[21353,21354],[21356,21357],[21405,21420],21422,[21478,21479],21482,21484,[21515,21516],[25300,25304],[25354,25360],25599,[25656,25659],25677,[27769,27770],[27776,27844],[28308,28310],[28328,28335],[28338,28344],[28375,28378],[28506,28508],[30150,30204],[30209,30258],30267,30282,[30290,30309],[30341,30378],[30424,30430],30480,[30525,30528],[30774,30780],[30849,30855],[34317,34556]] },
			'Mc':{ name:'Spacing Combining', id:'Mc', col:'mark', count:445, imin:2167, imax:28319, icon:'directory', includes:[2167,2223,[2226,2228],[2237,2240],[2242,2243],[2294,2295],[2342,2344],[2349,2352],2355,2390,[2435,2437],2470,[2521,2523],[2531,2533],[2560,2561],2610,2612,[2617,2620],2624,[2687,2688],[2690,2697],2700,[2723,2725],[2782,2785],[2824,2825],2878,[2880,2884],[2886,2889],[2892,2893],[2914,2915],[2972,2974],[2979,2984],2991,[3031,3032],[3093,3095],[3100,3107],[3118,3119],[3352,3353],3412,[3544,3545],3550,3557,[3560,3561],[3587,3588],[3599,3601],[3604,3610],[3632,3633],[3636,3641],3644,[3655,3657],5260,5282,5377,[5385,5392],[5394,5395],[5699,5702],[5705,5709],[5711,5716],[5908,5909],5966,5968,5977,[5979,5980],[5989,5994],6075,6124,6130,[6132,6136],[6138,6139],6197,6228,[6233,6234],6237,6298,[6301,6303],6305,[6309,6310],[6351,6358],[6367,6368],6517,6539,[11212,11213],[14247,14248],14251,[14323,14324],[14375,14390],[14519,14520],14554,[14603,14604],[14609,14610],[14613,14615],[14720,14721],[14724,14725],14741,14783,14785,14871,[14874,14875],14881,[15090,15091],[15093,15094],[15096,15097],15099,19489,19491,19606,[19652,19654],[19659,19660],19751,[19775,19776],19819,[19868,19870],[19880,19881],19895,[19976,19978],[19982,19983],19985,[20081,20083],[20104,20105],[20155,20156],[20158,20166],20168,[20174,20175],[20241,20243],[20252,20253],20257,[20333,20335],20342,[20344,20347],20350,[20414,20416],[20421,20424],20427,[20507,20509],[20518,20519],20521,20595,[20597,20598],20605,[20649,20650],20655,[20728,20730],20740,[20870,20877],20880,20883,20885,[20947,20949],[20956,20959],20964,21022,[21044,21045],21108,21239,21253,21344,21352,21355,[21473,21477],[21480,21481],21483,[21517,21518],[25601,25655],[25678,25679],[28306,28307],[28314,28319]] },
			'Me':{ name:'Enclosing', id:'Me', col:'mark', count:13, imin:1086, imax:13853, icon:'directory', includes:[[1086,1087],6054,[7487,7490],[7492,7494],[13851,13853]] },
			'Nd':{ name:'Decimal Digit', id:'Nd', col:'number', count:660, imin:16, imax:33665, icon:'directory', includes:[[16,25],[1529,1538],[1673,1682],[1864,1873],[2266,2275],[2363,2372],[2451,2460],[2540,2549],[2632,2641],[2701,2710],[2803,2812],[2900,2909],[3004,3013],[3108,3117],[3196,3205],[3276,3285],[3322,3331],[3565,3574],[3645,3654],[5417,5426],[5453,5462],[5723,5732],[5838,5847],[6006,6025],[6148,6157],[6243,6252],[6376,6385],[6389,6398],[13791,13800],[14395,14404],[14437,14446],[14630,14639],[14658,14667],[14742,14751],[15101,15110],[16610,16619],[17686,17695],[19242,19251],[19587,19596],[19697,19706],[19760,19769],[19897,19906],[20092,20101],[20268,20277],[20357,20366],[20528,20537],[20609,20618],[20661,20670],[20808,20817],[20890,20899],[21261,21270],[21423,21432],[21486,21495],[25169,25178],[25260,25269],[25376,25385],[29588,29637],[30438,30447],[30529,30538],[30857,30866],[33656,33665]] },
			'Nl':{ name:'Letter', id:'Nl', col:'number', count:236, imin:5228, imax:22605, icon:'directory', includes:[[5228,5230],[7603,7637],[7640,7643],11173,[11199,11207],[11222,11224],[13969,13978],[17093,17145],17394,17403,[17523,17527],[22495,22605]] },
			'No':{ name:'Other', id:'No', col:'number', count:895, imin:113, imax:31379, icon:'directory', includes:[[113,114],120,[123,125],[2377,2382],[2644,2649],[2711,2713],[2814,2820],[2992,2998],[3014,3022],[3332,3341],[4343,4362],[5427,5436],5848,7399,[7401,7406],[7413,7422],[7587,7602],7644,[8321,8380],[8459,8480],[9111,9140],10518,[11558,11561],[11687,11696],[11727,11734],[11736,11750],[11783,11792],[11832,11846],[14257,14262],[17039,17083],[17146,17149],[17167,17168],[17311,17337],[17370,17373],[18407,18414],[18440,18446],[18478,18486],[18508,18512],[18535,18540],[18625,18626],[18629,18690],[18741,18749],[18788,18789],[18820,18822],[18862,18866],[18957,18964],[18984,18991],[19014,19020],[19196,19201],[19252,19282],[19359,19368],[19403,19406],[19459,19465],[19567,19586],[19913,19932],[20671,20672],[20818,20826],[21271,21289],[21522,21542],[25386,25392],[25497,25519],[28510,28529],[28617,28641],[30765,30773],[30869,30927],[30929,30931],[30933,30981],[30983,30997],[31367,31379]] },
			'Zs':{ name:'Space', id:'Zs', col:'separator', count:17, imin:0, imax:11166, icon:'directory', includes:[0,95,5121,[7288,7298],7335,7383,11166] },
			'Zl':{ name:'Line', id:'Zl', col:'separator', count:1, imin:7328, imax:7328, icon:'directory', includes:[7328] },
			'Zp':{ name:'Paragraph', id:'Zp', col:'separator', count:1, imin:7329, imax:7329, icon:'directory', includes:[7329] },
			'Cf':{ name:'Format', id:'Cf', col:'other', count:163, imin:108, imax:34316, icon:'directory', includes:[108,[1433,1438],1461,1654,1703,[2058,2059],2134,5451,[7299,7303],[7330,7334],[7384,7398],16594,[16820,16822],19665,19671,[23977,23985],[27772,27775],[28320,28327],[34220,34316]] },
			'Cs':{ name:'Surrogate', id:'Cs', col:'other', count:6, imin:15185, imax:15190, icon:'directory', includes:[[15185,15190]] },
			'Co':{ name:'Private Use', id:'Co', col:'other', count:6, imin:15191, imax:34560, icon:'directory', includes:[[15191,15192],[34557,34560]] },
			'Lm':{ name:'Modifier', id:'Lm', col:'modifier', count:334, imin:623, imax:30856, icon:'directory', includes:[[623,640],[645,656],[671,675],683,685,819,823,1292,1497,[1662,1663],[1916,1917],1922,1952,1962,1966,2109,2277,3186,3269,3745,5410,5498,6033,[6429,6434],[6587,6649],6663,[6698,6734],7400,7412,[7428,7440],[10394,10395],10617,10778,11171,[11215,11219],11225,[11320,11321],[11415,11417],12256,[13495,13500],13771,13866,[13895,13896],[14010,14018],14099,14123,[14198,14200],[14204,14205],14629,14648,14772,14857,[14879,14880],[14959,14962],14972,16706,[16752,16753],[18272,18328],[25370,25373],[25660,25674],25676,[26922,26934],[30431,30437],30856] },
			'Lo':{ name:'Other', id:'Lo', col:'modifier', count:17185, imin:105, imax:34219, icon:'directory', includes:[105,121,378,[383,386],595,[1400,1430],[1465,1496],[1498,1507],[1543,1544],[1546,1644],1646,[1671,1672],[1683,1685],1688,1704,[1706,1735],[1763,1851],1863,[1874,1906],[1926,1947],[1987,2011],[2016,2050],[2052,2057],[2068,2108],[2168,2221],2225,2244,[2252,2261],[2278,2292],[2296,2339],2341,2354,[2356,2360],[2373,2374],2385,[2391,2433],[2446,2450],[2463,2465],[2471,2518],2520,[2535,2537],2552,[2562,2607],2609,[2625,2629],2643,[2651,2686],2699,[2727,2776],2778,[2795,2800],2822,[2827,2875],2877,[2894,2897],[2910,2911],[2916,2968],2971,2986,[2988,2990],[2999,3001],[3024,3029],[3033,3091],[3121,3168],[3170,3171],[3180,3185],[3208,3250],[3252,3253],[3263,3268],[3286,3290],[3354,3397],[3421,3425],[3501,3543],3564,[3581,3586],[3591,3594],3598,[3602,3603],[3611,3613],[3618,3630],3643,[3749,4330],[4363,4378],[4482,5101],[5104,5120],[5122,5147],[5150,5224],[5231,5256],[5261,5279],[5285,5302],[5305,5320],[5323,5374],5415,[5463,5497],[5499,5556],[5559,5592],[5594,5695],[5733,5837],[5883,5905],[5913,5965],[6076,6122],[6140,6147],[6198,6227],[6241,6242],[6253,6296],[6315,6350],[6386,6388],[6399,6428],[6525,6528],[6530,6535],[6537,6538],6542,[7560,7563],[10561,10616],[10620,10698],11172,11226,[11230,11315],11322,[11324,11413],[11418,11555],[11572,11603],[11640,11655],[12167,12168],[12233,12255],[12257,13399],[13455,13494],[13503,13770],[13775,13790],[13801,13802],13849,[13899,13968],14130,14203,[14207,14213],[14215,14217],[14219,14222],[14224,14246],[14267,14318],[14325,14374],[14423,14428],14432,[14434,14435],[14447,14474],[14485,14507],[14522,14550],[14555,14601],[14642,14646],[14649,14657],[14668,14713],[14728,14730],[14732,14739],[14756,14771],[14773,14778],14782,[14786,14835],14837,[14841,14842],[14845,14849],14852,[14854,14856],[14860,14870],14878,[14883,14914],[15055,15089],[15111,15184],[15193,15664],15677,[15679,15688],[15690,15820],[15838,16200],[16219,16336],[16338,16349],[16454,16593],[16696,16705],[16707,16751],[16754,16805],[16825,17035],[17232,17309],[17338,17369],[17374,17393],[17395,17402],[17404,17441],[17447,17476],[17478,17521],[17608,17685],[17768,17859],[17931,18271],[18329,18405],[18415,18437],[18447,18477],[18487,18507],[18513,18534],[18542,18567],[18569,18624],[18627,18628],18691,[18701,18736],[18759,18787],[18791,18819],[18823,18830],[18832,18859],[18874,18927],[18935,18956],[18965,18983],[18992,19009],[19021,19093],[19202,19237],[19283,19324],[19328,19358],[19369,19391],[19412,19429],[19438,19458],[19466,19488],[19492,19544],[19598,19599],19602,[19607,19651],[19672,19696],[19710,19745],19774,[19777,19812],19816,[19820,19867],[19882,19885],19907,19909,[19933,19975],[19995,20031],[20033,20079],[20106,20151],20154,20167,[20169,20173],[20188,20240],[20259,20262],[20282,20332],[20353,20354],20356,[20367,20413],[20453,20456],[20459,20506],20527,[20551,20593],20607,[20619,20645],[20677,20727],[20827,20869],20882,20884,[20900,20946],20961,20963,20965,[20976,21015],21023,21037,[21049,21094],21114,[21120,21238],21255,[21292,21321],[21358,21404],21421,[21433,21472],21485,[21496,21514],21521,[21573,22494],[22611,22903],[22906,23976],[23986,25168],[25181,25259],[25270,25299],[25306,25353],[25393,25432],[25524,25598],25600,[25680,26921],[26935,27767],30320,[30379,30423],30448,[30450,30479],[30481,30524],[30540,30764],[30998,31138],[33666,34219]] },
			'Pc':{ name:'Connector', id:'Pc', col:'punctuation', count:10, imin:63, imax:16657, icon:'directory', includes:[63,[7351,7352],7372,[16399,16400],[16425,16427],16657] },
			'Pd':{ name:'Dash', id:'Pd', col:'punctuation', count:26, imin:13, imax:19327, icon:'directory', includes:[13,1341,1390,4481,5443,[7304,7309],10754,10757,[10789,10790],10795,10824,11194,11214,11323,[16397,16398],16435,16446,16607,19327] },
			'Ps':{ name:'Open', id:'Ps', col:'punctuation', count:79, imin:8, imax:16692, icon:'directory', includes:[8,59,91,3348,3350,5148,7314,7318,7357,7410,7426,8023,8025,8056,9097,9099,9101,9103,9105,9107,9109,9190,9223,9225,9227,9229,9231,9636,9638,9640,9642,9644,9646,9648,9650,9652,9654,9656,9721,9723,9757,10765,10767,10769,10771,10797,10816,10818,10820,10822,11174,11176,11178,11180,11182,11186,11188,11190,11192,11195,16202,16377,16401,16403,16405,16407,16409,16411,16413,16415,16419,16436,16438,16440,16602,16653,16685,16689,16692] },
			'Pe':{ name:'Close', id:'Pe', col:'punctuation', count:77, imin:9, imax:16693, icon:'directory', includes:[9,61,93,3349,3351,5149,7358,7411,7427,8024,8026,8057,9098,9100,9102,9104,9106,9108,9110,9191,9224,9226,9228,9230,9232,9637,9639,9641,9643,9645,9647,9649,9651,9653,9655,9657,9722,9724,9758,10766,10768,10770,10772,10817,10819,10821,10823,11175,11177,11179,11181,11183,11187,11189,11191,11193,[11196,11197],16201,16378,16402,16404,16406,16408,16410,16412,16414,16416,16420,16437,16439,16441,16603,16655,16687,16690,16693] },
			'Pi':{ name:'Initial quote', id:'Pi', col:'punctuation', count:12, imin:106, imax:10763, icon:'directory', includes:[106,7312,[7315,7316],7319,7345,10733,10735,10740,10743,10759,10763] },
			'Pf':{ name:'Final quote', id:'Pf', col:'punctuation', count:10, imin:122, imax:10764, icon:'directory', includes:[122,7313,7317,7346,10734,10736,10741,10744,10760,10764] },
			'Po':{ name:'Other', id:'Po', col:'punctuation', count:605, imin:1, imax:30868, icon:'directory', includes:[[1,3],[5,7],10,12,[14,15],[26,27],[31,32],60,96,102,[117,118],126,827,832,[1293,1298],1340,1392,1395,1398,[1431,1432],[1442,1443],[1445,1446],1460,[1462,1464],[1539,1542],1645,[1689,1702],[1919,1921],[1972,1986],2015,[2264,2265],2276,2386,2467,2550,2813,2826,3120,3195,[3206,3207],[3294,3308],3310,3418,[3490,3494],[3499,3500],[3575,3580],3744,[4334,4342],5103,[5225,5227],[5283,5284],[5407,5409],[5411,5413],[5437,5442],[5444,5447],[5721,5722],[5911,5912],[6026,6032],[6034,6039],[6158,6164],[6193,6194],[6311,6314],[6371,6375],[6435,6436],[6492,6499],6503,[7310,7311],[7320,7327],[7336,7344],[7347,7350],[7353,7355],[7359,7369],7371,[7373,7382],[10514,10517],[10519,10520],10618,[10731,10732],[10737,10739],10742,[10745,10753],[10755,10756],10758,[10761,10762],[10773,10777],[10779,10788],[10791,10794],10796,[10798,10810],[10813,10815],[11167,11169],11227,11414,[13501,13502],[13772,13774],13854,13865,[13981,13986],[14319,14322],[14393,14394],[14429,14431],14433,[14483,14484],14521,[14616,14628],[14640,14641],[14752,14755],[14858,14859],[14876,14877],15098,[16370,16376],16379,16396,[16417,16418],[16421,16424],[16428,16434],[16442,16444],16450,[16452,16453],[16595,16597],[16599,16601],16604,16606,[16608,16609],[16620,16621],[16625,16626],16654,16691,[16694,16695],[17036,17038],17477,17522,17860,18406,18541,18568,[18750,18758],18790,[18867,18873],[18928,18934],[19010,19013],[19407,19411],[19434,19437],[19560,19566],[19663,19664],[19666,19669],[19770,19773],[19814,19815],[19886,19889],19894,19908,[19910,19912],[19988,19993],20032,[20263,20267],[20278,20280],20355,[20430,20452],[20524,20526],[20538,20550],20608,[20673,20675],20743,[20887,20889],20962,[21028,21035],[21111,21113],[21115,21119],[21256,21260],[21290,21291],[21519,21520],21572,[22606,22610],[22904,22905],[25179,25180],25305,[25361,25365],25374,[25520,25523],25675,27771,[30285,30289],[30867,30868]] },
			'Sm':{ name:'Math', id:'Sm', col:'symbol', count:948, imin:11, imax:31140, icon:'directory', includes:[11,[28,30],92,94,107,112,150,182,940,[1439,1441],7356,7370,[7407,7409],[7423,7425],7531,[7571,7575],7582,[7647,7651],[7657,7658],7663,7666,7669,7677,[7709,7710],7713,7715,[7747,8014],[8047,8048],8139,[8170,8194],[8235,8240],8664,8674,[8729,8736],8848,[9185,9189],[9192,9222],[9233,9248],[9505,9635],[9658,9720],[9725,9756],[9759,10016],[10065,10085],[10088,10093],15689,16445,[16447,16449],16605,[16622,16624],16686,16688,16808,[16814,16817],29321,29347,29379,29405,29437,29463,29495,29521,29553,29579,[31139,31140]] },
			'Sc':{ name:'Currency', id:'Sc', col:'symbol', count:63, imin:4, imax:30932, icon:'directory', includes:[4,[97,100],1344,1444,[1924,1925],[2375,2376],2384,2551,2720,3179,5414,[7441,7473],14265,16350,16451,16598,[16806,16807],[16811,16812],[21551,21554],30539,30932] },
			'Sk':{ name:'Modifier', id:'Sk', col:'symbol', count:125, imin:62, imax:31886, icon:'directory', includes:[62,64,103,110,115,119,[641,644],[657,670],[676,682],684,[686,702],820,[829,830],2051,7229,[7231,7233],[7244,7246],[7257,7259],[7273,7275],[7286,7287],[11318,11319],[13987,14009],[14019,14020],[14124,14125],14958,[14973,14974],[15821,15837],16656,16658,16809,[31882,31886]] },
			'So':{ name:'Other', id:'So', col:'symbol', count:6605, imin:101, imax:33655, icon:'directory', includes:[101,104,109,111,1080,[1342,1343],[1447,1448],1655,1666,[1686,1687],1918,2383,2642,[2714,2719],2721,2821,2987,3023,[3291,3293],3309,[3311,3313],[3316,3321],3342,3344,3346,[3473,3480],[3482,3489],[3495,3498],[3659,3660],[4379,4388],5102,5720,[5849,5882],[6165,6174],[6184,6192],[7507,7508],[7510,7513],[7515,7516],7527,[7529,7530],[7537,7542],7544,7546,7548,7553,[7565,7566],7581,[7583,7584],7586,[7645,7646],[7652,7656],[7659,7662],[7664,7665],[7667,7668],[7670,7676],[7678,7708],[7711,7712],7714,[7716,7746],[8015,8022],[8027,8046],[8049,8055],[8058,8138],[8140,8169],[8195,8234],[8241,8320],[8381,8458],[8481,8663],[8665,8673],[8675,8728],[8737,8847],[8849,9096],[9141,9184],[9249,9504],[10017,10064],[10086,10087],[10094,10269],[10499,10504],[10811,10812],[10825,11165],11170,[11184,11185],11198,[11220,11221],[11228,11229],[11556,11557],[11562,11571],[11604,11639],[11656,11686],[11697,11726],11735,[11751,11782],[11793,11831],[11847,12166],[12169,12232],[13400,13454],[14252,14255],[14263,14264],14266,[14779,14781],[16203,16218],16337,[16351,16353],16810,16813,[16818,16819],[16823,16824],[17084,17092],[17150,17166],[17169,17230],[18438,18439],18831,20676,[21543,21550],[21555,21571],[25366,25369],25375,27768,[27845,28305],[28311,28313],[28336,28337],[28345,28374],[28379,28505],28509,[28530,28616],[29638,30149],[30205,30208],[30259,30266],[30268,30281],[30283,30284],30449,30928,30982,[31141,31366],[31380,31881],[31887,33655]] },
			'Liga':{ name:'Ligatures', id:'Liga', col:'ligature', count:0, imin:9999999999, imax:-1, icon:'directory', includes:[] },
			};
        this._categories = c;

        let gc = {

			'Letter':{ name:'Letter', count:21608, subs:[c.Lu, c.Ll, c.Lt, c.Lm, c.Lo] },
			'Mark':{ name:'Mark', count:2408, subs:[c.Mn, c.Mc, c.Me] },
			'Number':{ name:'Number', count:1791, subs:[c.Nd, c.Nl, c.No] },
			'Separator':{ name:'Separator', count:19, subs:[c.Zs, c.Zl, c.Zp] },
			'Other':{ name:'Other', count:175, subs:[c.Cf, c.Cs, c.Co] },
			'Punctuation':{ name:'Punctuation', count:819, subs:[c.Pc, c.Pd, c.Ps, c.Pe, c.Pi, c.Pf, c.Po] },
			'Symbol':{ name:'Symbol', count:7741, subs:[c.Sm, c.Sc, c.Sk, c.So] },
			'Custom':{ name:'Custom', count:0, subs:[c.Liga] },
			};
        this._generalCategories = gc;

        let mgc = [];
        for (let p in gc) {
            let lgc = gc[p], subs = lgc.subs,
                cgc = { name: lgc.name, itemClass: UniCategoryGroup, autoSort: false, content: [] };
            for (let i = 0; i < subs.length; i++) {
                let lcgc = subs[i];
                lcgc.parent = lgc;
                lcgc.primaryCommand = this.SetActiveRange;
                lcgc.itemClass = UniCategory;
                cgc.content.push(lcgc);
            }
            mgc.push(cgc);
        }

        let b = [

			{ name:'Basic Latin', count:95, icon:'view-grid', cats:[c.Zs,c.Po,c.Sc,c.Ps,c.Pe,c.Sm,c.Pd,c.Nd,c.Lu,c.Sk,c.Pc,c.Ll], start:32},
			{ name:'Latin-1 Supplement', count:95, icon:'view-grid', cats:[c.Zs,c.Po,c.Sc,c.So,c.Sk,c.Lo,c.Pi,c.Sm,c.Cf,c.No,c.Ll,c.Pf,c.Lu], start:160},
			{ name:'Latin Extended-A', count:127, icon:'view-grid', cats:[c.Lu,c.Ll], start:256},
			{ name:'Latin Extended-B', count:207, icon:'view-grid', cats:[c.Ll,c.Lu,c.Lo,c.Lt], start:384},
			{ name:'IPA Extensions', count:95, icon:'view-grid', cats:[c.Ll,c.Lo], start:592},
			{ name:'Spacing Modifier Letters', count:79, icon:'view-grid', cats:[c.Lm,c.Sk], start:688},
			{ name:'Combining Diacritical Marks', count:111, icon:'view-grid', cats:[c.Mn], start:768},
			{ name:'Greek and Coptic', count:143, icon:'view-grid', cats:[c.Lu,c.Ll,c.Lm,c.Sk,c.Po,c.Sm], start:880},
			{ name:'Cyrillic', count:255, icon:'view-grid', cats:[c.Lu,c.Ll,c.So,c.Mn,c.Me], start:1024},
			{ name:'Cyrillic Supplement', count:47, icon:'view-grid', cats:[c.Lu,c.Ll], start:1280},
			{ name:'Armenian', count:95, icon:'view-grid', cats:[c.Lu,c.Lm,c.Po,c.Ll,c.Pd,c.So,c.Sc], start:1328},
			{ name:'Hebrew', count:111, icon:'view-grid', cats:[c.Mn,c.Pd,c.Po,c.Lo], start:1424},
			{ name:'Arabic', count:255, icon:'view-grid', cats:[c.Cf,c.Sm,c.Po,c.Sc,c.So,c.Mn,c.Lo,c.Lm,c.Nd], start:1536},
			{ name:'Syriac', count:79, icon:'view-grid', cats:[c.Po,c.Cf,c.Lo,c.Mn], start:1792},
			{ name:'Arabic Supplement', count:47, icon:'view-grid', cats:[c.Lo], start:1872},
			{ name:'Thaana', count:63, icon:'view-grid', cats:[c.Lo,c.Mn], start:1920},
			{ name:'NKo', count:63, icon:'view-grid', cats:[c.Nd,c.Lo,c.Mn,c.Lm,c.So,c.Po,c.Sc], start:1984},
			{ name:'Samaritan', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Lm,c.Po], start:2048},
			{ name:'Mandaic', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po], start:2112},
			{ name:'Syriac Supplement', count:15, icon:'view-grid', cats:[c.Lo], start:2144},
			{ name:'Arabic Extended-B', count:47, icon:'view-grid', cats:[c.Lo,c.Sk,c.Cf,c.Mn], start:2160},
			{ name:'Arabic Extended-A', count:95, icon:'view-grid', cats:[c.Lo,c.Lm,c.Mn,c.Cf], start:2208},
			{ name:'Devanagari', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Po,c.Nd,c.Lm], start:2304},
			{ name:'Bengali', count:127, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Nd,c.Sc,c.No,c.So,c.Po], start:2432},
			{ name:'Gurmukhi', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.Po], start:2560},
			{ name:'Gujarati', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.Po,c.Sc], start:2688},
			{ name:'Oriya', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.So,c.No], start:2816},
			{ name:'Tamil', count:127, icon:'view-grid', cats:[c.Mn,c.Lo,c.Mc,c.Nd,c.No,c.So,c.Sc], start:2944},
			{ name:'Telugu', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.Po,c.No,c.So], start:3072},
			{ name:'Kannada', count:127, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po,c.Nd], start:3200},
			{ name:'Malayalam', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.So,c.No,c.Nd], start:3328},
			{ name:'Sinhala', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.Po], start:3456},
			{ name:'Thai', count:127, icon:'view-grid', cats:[c.Lo,c.Mn,c.Sc,c.Lm,c.Po,c.Nd], start:3584},
			{ name:'Lao', count:127, icon:'view-grid', cats:[c.Lo,c.Mn,c.Lm,c.Nd], start:3712},
			{ name:'Tibetan', count:255, icon:'view-grid', cats:[c.Lo,c.So,c.Po,c.Mn,c.Nd,c.No,c.Ps,c.Pe,c.Mc], start:3840},
			{ name:'Myanmar', count:159, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Nd,c.Po,c.So], start:4096},
			{ name:'Georgian', count:95, icon:'view-grid', cats:[c.Lu,c.Ll,c.Po,c.Lm], start:4256},
			{ name:'Hangul Jamo', count:255, icon:'view-grid', cats:[c.Lo], start:4352},
			{ name:'Ethiopic', count:383, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po,c.No], start:4608},
			{ name:'Ethiopic Supplement', count:31, icon:'view-grid', cats:[c.Lo,c.So], start:4992},
			{ name:'Cherokee', count:95, icon:'view-grid', cats:[c.Lu,c.Ll], start:5024},
			{ name:'Unified Canadian Aboriginal Syllabics', count:639, icon:'view-grid', cats:[c.Pd,c.Lo,c.So,c.Po], start:5120},
			{ name:'Ogham', count:31, icon:'view-grid', cats:[c.Zs,c.Lo,c.Ps,c.Pe], start:5760},
			{ name:'Runic', count:95, icon:'view-grid', cats:[c.Lo,c.Po,c.Nl], start:5792},
			{ name:'Tagalog', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc], start:5888},
			{ name:'Hanunoo', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:5920},
			{ name:'Buhid', count:31, icon:'view-grid', cats:[c.Lo,c.Mn], start:5952},
			{ name:'Tagbanwa', count:31, icon:'view-grid', cats:[c.Lo,c.Mn], start:5984},
			{ name:'Khmer', count:127, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po,c.Lm,c.Sc,c.Nd,c.No], start:6016},
			{ name:'Mongolian', count:175, icon:'view-grid', cats:[c.Po,c.Pd,c.Mn,c.Cf,c.Nd,c.Lo,c.Lm], start:6144},
			{ name:'Unified Canadian Aboriginal Syllabics Extended', count:79, icon:'view-grid', cats:[c.Lo], start:6320},
			{ name:'Limbu', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.So,c.Po,c.Nd], start:6400},
			{ name:'Tai Le', count:47, icon:'view-grid', cats:[c.Lo], start:6480},
			{ name:'New Tai Lue', count:95, icon:'view-grid', cats:[c.Lo,c.Nd,c.No,c.So], start:6528},
			{ name:'Khmer Symbols', count:31, icon:'view-grid', cats:[c.So], start:6624},
			{ name:'Buginese', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:6656},
			{ name:'Tai Tham', count:143, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Nd,c.Po,c.Lm], start:6688},
			{ name:'Combining Diacritical Marks Extended', count:79, icon:'view-grid', cats:[c.Mn,c.Me], start:6832},
			{ name:'Balinese', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd,c.Po,c.So], start:6912},
			{ name:'Sundanese', count:63, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Nd], start:7040},
			{ name:'Batak', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:7104},
			{ name:'Lepcha', count:79, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:7168},
			{ name:'Ol Chiki', count:47, icon:'view-grid', cats:[c.Nd,c.Lo,c.Lm,c.Po], start:7248},
			{ name:'Cyrillic Extended-C', count:15, icon:'view-grid', cats:[c.Ll], start:7296},
			{ name:'Georgian Extended', count:47, icon:'view-grid', cats:[c.Lu], start:7312},
			{ name:'Sundanese Supplement', count:15, icon:'view-grid', cats:[c.Po], start:7360},
			{ name:'Vedic Extensions', count:47, icon:'view-grid', cats:[c.Mn,c.Po,c.Mc,c.Lo], start:7376},
			{ name:'Phonetic Extensions', count:127, icon:'view-grid', cats:[c.Ll,c.Lm], start:7424},
			{ name:'Phonetic Extensions Supplement', count:63, icon:'view-grid', cats:[c.Ll,c.Lm], start:7552},
			{ name:'Combining Diacritical Marks Supplement', count:63, icon:'view-grid', cats:[c.Mn], start:7616},
			{ name:'Latin Extended Additional', count:255, icon:'view-grid', cats:[c.Lu,c.Ll], start:7680},
			{ name:'Greek Extended', count:255, icon:'view-grid', cats:[c.Ll,c.Lu,c.Lt,c.Sk], start:7936},
			{ name:'General Punctuation', count:111, icon:'view-grid', cats:[c.Zs,c.Cf,c.Pd,c.Po,c.Pi,c.Pf,c.Ps,c.Zl,c.Zp,c.Pc,c.Sm,c.Pe], start:8192},
			{ name:'Superscripts and Subscripts', count:47, icon:'view-grid', cats:[c.No,c.Lm,c.Sm,c.Ps,c.Pe], start:8304},
			{ name:'Currency Symbols', count:47, icon:'view-grid', cats:[c.Sc], start:8352},
			{ name:'Combining Diacritical Marks for Symbols', count:47, icon:'view-grid', cats:[c.Mn,c.Me], start:8400},
			{ name:'Letterlike Symbols', count:79, icon:'view-grid', cats:[c.So,c.Lu,c.Ll,c.Sm,c.Lo], start:8448},
			{ name:'Number Forms', count:63, icon:'view-grid', cats:[c.No,c.Nl,c.Lu,c.Ll,c.So], start:8528},
			{ name:'Arrows', count:111, icon:'view-grid', cats:[c.Sm,c.So], start:8592},
			{ name:'Mathematical Operators', count:255, icon:'view-grid', cats:[c.Sm], start:8704},
			{ name:'Miscellaneous Technical', count:255, icon:'view-grid', cats:[c.So,c.Ps,c.Pe,c.Sm], start:8960},
			{ name:'Control Pictures', count:63, icon:'view-grid', cats:[c.So], start:9216},
			{ name:'Optical Character Recognition', count:31, icon:'view-grid', cats:[c.So], start:9280},
			{ name:'Enclosed Alphanumerics', count:159, icon:'view-grid', cats:[c.No,c.So], start:9312},
			{ name:'Box Drawing', count:127, icon:'view-grid', cats:[c.So], start:9472},
			{ name:'Block Elements', count:31, icon:'view-grid', cats:[c.So], start:9600},
			{ name:'Geometric Shapes', count:95, icon:'view-grid', cats:[c.So,c.Sm], start:9632},
			{ name:'Miscellaneous Symbols', count:255, icon:'view-grid', cats:[c.So,c.Sm], start:9728},
			{ name:'Dingbats', count:191, icon:'view-grid', cats:[c.So,c.Ps,c.Pe,c.No], start:9984},
			{ name:'Miscellaneous Mathematical Symbols-A', count:47, icon:'view-grid', cats:[c.Sm,c.Ps,c.Pe], start:10176},
			{ name:'Supplemental Arrows-A', count:15, icon:'view-grid', cats:[c.Sm], start:10224},
			{ name:'Braille Patterns', count:255, icon:'view-grid', cats:[c.So], start:10240},
			{ name:'Supplemental Arrows-B', count:127, icon:'view-grid', cats:[c.Sm], start:10496},
			{ name:'Miscellaneous Mathematical Symbols-B', count:127, icon:'view-grid', cats:[c.Sm,c.Ps,c.Pe], start:10624},
			{ name:'Supplemental Mathematical Operators', count:255, icon:'view-grid', cats:[c.Sm], start:10752},
			{ name:'Miscellaneous Symbols and Arrows', count:255, icon:'view-grid', cats:[c.So,c.Sm], start:11008},
			{ name:'Glagolitic', count:95, icon:'view-grid', cats:[c.Lu,c.Ll], start:11264},
			{ name:'Latin Extended-C', count:31, icon:'view-grid', cats:[c.Lu,c.Ll,c.Lm], start:11360},
			{ name:'Coptic', count:127, icon:'view-grid', cats:[c.Lu,c.Ll,c.So,c.Mn,c.Po,c.No], start:11392},
			{ name:'Georgian Supplement', count:47, icon:'view-grid', cats:[c.Ll], start:11520},
			{ name:'Tifinagh', count:79, icon:'view-grid', cats:[c.Lo,c.Lm,c.Po,c.Mn], start:11568},
			{ name:'Ethiopic Extended', count:95, icon:'view-grid', cats:[c.Lo], start:11648},
			{ name:'Cyrillic Extended-A', count:31, icon:'view-grid', cats:[c.Mn], start:11744},
			{ name:'Supplemental Punctuation', count:127, icon:'view-grid', cats:[c.Po,c.Pi,c.Pf,c.Pd,c.Ps,c.Pe,c.Lm,c.So], start:11776},
			{ name:'CJK Radicals Supplement', count:127, icon:'view-grid', cats:[c.So], start:11904},
			{ name:'Kangxi Radicals', count:223, icon:'view-grid', cats:[c.So], start:12032},
			{ name:'Ideographic Description Characters', count:15, icon:'view-grid', cats:[c.So], start:12272},
			{ name:'CJK Symbols and Punctuation', count:63, icon:'view-grid', cats:[c.Zs,c.Po,c.So,c.Lm,c.Lo,c.Nl,c.Ps,c.Pe,c.Pd,c.Mn,c.Mc], start:12288},
			{ name:'Hiragana', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.Sk,c.Lm], start:12352},
			{ name:'Katakana', count:95, icon:'view-grid', cats:[c.Pd,c.Lo,c.Po,c.Lm], start:12448},
			{ name:'Bopomofo', count:47, icon:'view-grid', cats:[c.Lo], start:12544},
			{ name:'Hangul Compatibility Jamo', count:95, icon:'view-grid', cats:[c.Lo], start:12592},
			{ name:'Kanbun', count:15, icon:'view-grid', cats:[c.So,c.No], start:12688},
			{ name:'Bopomofo Extended', count:31, icon:'view-grid', cats:[c.Lo], start:12704},
			{ name:'CJK Strokes', count:47, icon:'view-grid', cats:[c.So], start:12736},
			{ name:'Katakana Phonetic Extensions', count:15, icon:'view-grid', cats:[c.Lo], start:12784},
			{ name:'Enclosed CJK Letters and Months', count:255, icon:'view-grid', cats:[c.So,c.No], start:12800},
			{ name:'CJK Compatibility', count:255, icon:'view-grid', cats:[c.So], start:13056},
			{ name:'CJK Unified Ideographs Extension A', count:6591, icon:'view-grid', cats:[c.Lo], start:13312},
			{ name:'Yijing Hexagram Symbols', count:63, icon:'view-grid', cats:[c.So], start:19904},
			{ name:'CJK Unified Ideographs', count:20991, icon:'view-grid', cats:[c.Lo], start:19968},
			{ name:'Yi Syllables', count:1167, icon:'view-grid', cats:[c.Lo,c.Lm], start:40960},
			{ name:'Yi Radicals', count:63, icon:'view-grid', cats:[c.So], start:42128},
			{ name:'Lisu', count:47, icon:'view-grid', cats:[c.Lo,c.Lm,c.Po], start:42192},
			{ name:'Vai', count:319, icon:'view-grid', cats:[c.Lo,c.Lm,c.Po,c.Nd], start:42240},
			{ name:'Cyrillic Extended-B', count:95, icon:'view-grid', cats:[c.Lu,c.Ll,c.Lo,c.Mn,c.Me,c.Po,c.Lm], start:42560},
			{ name:'Bamum', count:95, icon:'view-grid', cats:[c.Lo,c.Nl,c.Mn,c.Po], start:42656},
			{ name:'Modifier Tone Letters', count:31, icon:'view-grid', cats:[c.Sk,c.Lm], start:42752},
			{ name:'Latin Extended-D', count:223, icon:'view-grid', cats:[c.Sk,c.Lu,c.Ll,c.Lm,c.Lo], start:42784},
			{ name:'Syloti Nagri', count:47, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.So], start:43008},
			{ name:'Common Indic Number Forms', count:15, icon:'view-grid', cats:[c.No,c.So,c.Sc], start:43056},
			{ name:'Phags-pa', count:63, icon:'view-grid', cats:[c.Lo,c.Po], start:43072},
			{ name:'Saurashtra', count:95, icon:'view-grid', cats:[c.Mc,c.Lo,c.Mn,c.Po,c.Nd], start:43136},
			{ name:'Devanagari Extended', count:31, icon:'view-grid', cats:[c.Mn,c.Lo,c.Po], start:43232},
			{ name:'Kayah Li', count:47, icon:'view-grid', cats:[c.Nd,c.Lo,c.Mn,c.Po], start:43264},
			{ name:'Rejang', count:47, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:43312},
			{ name:'Hangul Jamo Extended-A', count:31, icon:'view-grid', cats:[c.Lo], start:43360},
			{ name:'Javanese', count:95, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Po,c.Lm,c.Nd], start:43392},
			{ name:'Myanmar Extended-B', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Lm,c.Nd], start:43488},
			{ name:'Cham', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Nd,c.Po], start:43520},
			{ name:'Myanmar Extended-A', count:31, icon:'view-grid', cats:[c.Lo,c.Lm,c.So,c.Mc,c.Mn], start:43616},
			{ name:'Tai Viet', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.Lm,c.Po], start:43648},
			{ name:'Meetei Mayek Extensions', count:31, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Lm], start:43744},
			{ name:'Ethiopic Extended-A', count:47, icon:'view-grid', cats:[c.Lo], start:43776},
			{ name:'Latin Extended-E', count:63, icon:'view-grid', cats:[c.Ll,c.Sk,c.Lm], start:43824},
			{ name:'Cherokee Supplement', count:79, icon:'view-grid', cats:[c.Ll], start:43888},
			{ name:'Meetei Mayek', count:63, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:43968},
			{ name:'Hangul Syllables', count:11183, icon:'view-grid', cats:[c.Lo], start:44032},
			{ name:'Hangul Jamo Extended-B', count:79, icon:'view-grid', cats:[c.Lo], start:55216},
			{ name:'High Surrogates', count:895, icon:'view-grid', cats:[c.Cs], start:55296},
			{ name:'High Private Use Surrogates', count:127, icon:'view-grid', cats:[c.Cs], start:56192},
			{ name:'Low Surrogates', count:1023, icon:'view-grid', cats:[c.Cs], start:56320},
			{ name:'Private Use Area', count:6399, icon:'view-grid', cats:[c.Co], start:57344},
			{ name:'CJK Compatibility Ideographs', count:511, icon:'view-grid', cats:[c.Lo], start:63744},
			{ name:'Alphabetic Presentation Forms', count:79, icon:'view-grid', cats:[c.Ll,c.Lo,c.Mn,c.Sm], start:64256},
			{ name:'Arabic Presentation Forms-A', count:687, icon:'view-grid', cats:[c.Lo,c.Sk,c.Pe,c.Ps,c.So,c.Sc], start:64336},
			{ name:'Variation Selectors', count:15, icon:'view-grid', cats:[c.Mn], start:65024},
			{ name:'Vertical Forms', count:15, icon:'view-grid', cats:[c.Po,c.Ps,c.Pe], start:65040},
			{ name:'Combining Half Marks', count:15, icon:'view-grid', cats:[c.Mn], start:65056},
			{ name:'CJK Compatibility Forms', count:31, icon:'view-grid', cats:[c.Po,c.Pd,c.Pc,c.Ps,c.Pe], start:65072},
			{ name:'Small Form Variants', count:31, icon:'view-grid', cats:[c.Po,c.Pd,c.Ps,c.Pe,c.Sm,c.Sc], start:65104},
			{ name:'Arabic Presentation Forms-B', count:143, icon:'view-grid', cats:[c.Lo,c.Cf], start:65136},
			{ name:'Halfwidth and Fullwidth Forms', count:239, icon:'view-grid', cats:[c.Po,c.Sc,c.Ps,c.Pe,c.Sm,c.Pd,c.Nd,c.Lu,c.Sk,c.Pc,c.Ll,c.Lo,c.Lm,c.So], start:65280},
			{ name:'Specials', count:15, icon:'view-grid', cats:[c.Cf,c.So], start:65520},
			{ name:'Linear B Syllabary', count:127, icon:'view-grid', cats:[c.Lo], start:65536},
			{ name:'Linear B Ideograms', count:127, icon:'view-grid', cats:[c.Lo], start:65664},
			{ name:'Aegean Numbers', count:63, icon:'view-grid', cats:[c.Po,c.No,c.So], start:65792},
			{ name:'Ancient Greek Numbers', count:79, icon:'view-grid', cats:[c.Nl,c.No,c.So], start:65856},
			{ name:'Ancient Symbols', count:63, icon:'view-grid', cats:[c.So], start:65936},
			{ name:'Phaistos Disc', count:47, icon:'view-grid', cats:[c.So,c.Mn], start:66000},
			{ name:'Lycian', count:31, icon:'view-grid', cats:[c.Lo], start:66176},
			{ name:'Carian', count:63, icon:'view-grid', cats:[c.Lo], start:66208},
			{ name:'Coptic Epact Numbers', count:31, icon:'view-grid', cats:[c.Mn,c.No], start:66272},
			{ name:'Old Italic', count:47, icon:'view-grid', cats:[c.Lo,c.No], start:66304},
			{ name:'Gothic', count:31, icon:'view-grid', cats:[c.Lo,c.Nl], start:66352},
			{ name:'Old Permic', count:47, icon:'view-grid', cats:[c.Lo,c.Mn], start:66384},
			{ name:'Ugaritic', count:31, icon:'view-grid', cats:[c.Lo,c.Po], start:66432},
			{ name:'Old Persian', count:63, icon:'view-grid', cats:[c.Lo,c.Po,c.Nl], start:66464},
			{ name:'Deseret', count:79, icon:'view-grid', cats:[c.Lu,c.Ll], start:66560},
			{ name:'Shavian', count:47, icon:'view-grid', cats:[c.Lo], start:66640},
			{ name:'Osmanya', count:47, icon:'view-grid', cats:[c.Lo,c.Nd], start:66688},
			{ name:'Osage', count:79, icon:'view-grid', cats:[c.Lu,c.Ll], start:66736},
			{ name:'Elbasan', count:47, icon:'view-grid', cats:[c.Lo], start:66816},
			{ name:'Caucasian Albanian', count:63, icon:'view-grid', cats:[c.Lo,c.Po], start:66864},
			{ name:'Vithkuqi', count:79, icon:'view-grid', cats:[c.Lu,c.Ll], start:66928},
			{ name:'Linear A', count:383, icon:'view-grid', cats:[c.Lo], start:67072},
			{ name:'Latin Extended-F', count:63, icon:'view-grid', cats:[c.Lm], start:67456},
			{ name:'Cypriot Syllabary', count:63, icon:'view-grid', cats:[c.Lo], start:67584},
			{ name:'Imperial Aramaic', count:31, icon:'view-grid', cats:[c.Lo,c.Po,c.No], start:67648},
			{ name:'Palmyrene', count:31, icon:'view-grid', cats:[c.Lo,c.So,c.No], start:67680},
			{ name:'Nabataean', count:47, icon:'view-grid', cats:[c.Lo,c.No], start:67712},
			{ name:'Hatran', count:31, icon:'view-grid', cats:[c.Lo,c.No], start:67808},
			{ name:'Phoenician', count:31, icon:'view-grid', cats:[c.Lo,c.No,c.Po], start:67840},
			{ name:'Lydian', count:31, icon:'view-grid', cats:[c.Lo,c.Po], start:67872},
			{ name:'Meroitic Hieroglyphs', count:31, icon:'view-grid', cats:[c.Lo], start:67968},
			{ name:'Meroitic Cursive', count:95, icon:'view-grid', cats:[c.Lo,c.No], start:68000},
			{ name:'Kharoshthi', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.No,c.Po], start:68096},
			{ name:'Old South Arabian', count:31, icon:'view-grid', cats:[c.Lo,c.No,c.Po], start:68192},
			{ name:'Old North Arabian', count:31, icon:'view-grid', cats:[c.Lo,c.No], start:68224},
			{ name:'Manichaean', count:63, icon:'view-grid', cats:[c.Lo,c.So,c.Mn,c.No,c.Po], start:68288},
			{ name:'Avestan', count:63, icon:'view-grid', cats:[c.Lo,c.Po], start:68352},
			{ name:'Inscriptional Parthian', count:31, icon:'view-grid', cats:[c.Lo,c.No], start:68416},
			{ name:'Inscriptional Pahlavi', count:31, icon:'view-grid', cats:[c.Lo,c.No], start:68448},
			{ name:'Psalter Pahlavi', count:47, icon:'view-grid', cats:[c.Lo,c.Po,c.No], start:68480},
			{ name:'Old Turkic', count:79, icon:'view-grid', cats:[c.Lo], start:68608},
			{ name:'Old Hungarian', count:127, icon:'view-grid', cats:[c.Lu,c.Ll,c.No], start:68736},
			{ name:'Hanifi Rohingya', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Nd], start:68864},
			{ name:'Rumi Numeral Symbols', count:31, icon:'view-grid', cats:[c.No], start:69216},
			{ name:'Yezidi', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Pd], start:69248},
			{ name:'Old Sogdian', count:47, icon:'view-grid', cats:[c.Lo,c.No], start:69376},
			{ name:'Sogdian', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.No,c.Po], start:69424},
			{ name:'Old Uyghur', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po], start:69488},
			{ name:'Chorasmian', count:47, icon:'view-grid', cats:[c.Lo,c.No], start:69552},
			{ name:'Elymaic', count:31, icon:'view-grid', cats:[c.Lo], start:69600},
			{ name:'Brahmi', count:127, icon:'view-grid', cats:[c.Mc,c.Mn,c.Lo,c.Po,c.No,c.Nd], start:69632},
			{ name:'Kaithi', count:79, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Po,c.Cf], start:69760},
			{ name:'Sora Sompeng', count:47, icon:'view-grid', cats:[c.Lo,c.Nd], start:69840},
			{ name:'Chakma', count:79, icon:'view-grid', cats:[c.Mn,c.Lo,c.Mc,c.Nd,c.Po], start:69888},
			{ name:'Mahajani', count:47, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po], start:69968},
			{ name:'Sharada', count:95, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo,c.Po,c.Nd], start:70016},
			{ name:'Sinhala Archaic Numbers', count:31, icon:'view-grid', cats:[c.No], start:70112},
			{ name:'Khojki', count:79, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po], start:70144},
			{ name:'Multani', count:47, icon:'view-grid', cats:[c.Lo,c.Po], start:70272},
			{ name:'Khudawadi', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Nd], start:70320},
			{ name:'Grantha', count:127, icon:'view-grid', cats:[c.Mn,c.Mc,c.Lo], start:70400},
			{ name:'Newa', count:127, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:70656},
			{ name:'Tirhuta', count:95, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:70784},
			{ name:'Siddham', count:127, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po], start:71040},
			{ name:'Modi', count:95, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:71168},
			{ name:'Mongolian Supplement', count:31, icon:'view-grid', cats:[c.Po], start:71264},
			{ name:'Takri', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po,c.Nd], start:71296},
			{ name:'Ahom', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Nd,c.No,c.Po,c.So], start:71424},
			{ name:'Dogra', count:79, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po], start:71680},
			{ name:'Warang Citi', count:95, icon:'view-grid', cats:[c.Lu,c.Ll,c.Nd,c.No,c.Lo], start:71840},
			{ name:'Dives Akuru', count:95, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd], start:71936},
			{ name:'Nandinagari', count:95, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po], start:72096},
			{ name:'Zanabazar Square', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:72192},
			{ name:'Soyombo', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:72272},
			{ name:'Unified Canadian Aboriginal Syllabics Extended-A', count:15, icon:'view-grid', cats:[c.Lo], start:72368},
			{ name:'Pau Cin Hau', count:63, icon:'view-grid', cats:[c.Lo], start:72384},
			{ name:'Bhaiksuki', count:111, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Po,c.Nd,c.No], start:72704},
			{ name:'Marchen', count:79, icon:'view-grid', cats:[c.Po,c.Lo,c.Mn,c.Mc], start:72816},
			{ name:'Masaram Gondi', count:95, icon:'view-grid', cats:[c.Lo,c.Mn,c.Nd], start:72960},
			{ name:'Gunjala Gondi', count:79, icon:'view-grid', cats:[c.Lo,c.Mc,c.Mn,c.Nd], start:73056},
			{ name:'Makasar', count:31, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Po], start:73440},
			{ name:'Lisu Supplement', count:15, icon:'view-grid', cats:[c.Lo], start:73648},
			{ name:'Tamil Supplement', count:63, icon:'view-grid', cats:[c.No,c.So,c.Sc,c.Po], start:73664},
			{ name:'Cuneiform', count:1023, icon:'view-grid', cats:[c.Lo], start:73728},
			{ name:'Cuneiform Numbers and Punctuation', count:127, icon:'view-grid', cats:[c.Nl,c.Po], start:74752},
			{ name:'Early Dynastic Cuneiform', count:207, icon:'view-grid', cats:[c.Lo], start:74880},
			{ name:'Cypro-Minoan', count:111, icon:'view-grid', cats:[c.Lo,c.Po], start:77712},
			{ name:'Egyptian Hieroglyphs', count:1071, icon:'view-grid', cats:[c.Lo], start:77824},
			{ name:'Egyptian Hieroglyph Format Controls', count:15, icon:'view-grid', cats:[c.Cf], start:78896},
			{ name:'Anatolian Hieroglyphs', count:639, icon:'view-grid', cats:[c.Lo], start:82944},
			{ name:'Bamum Supplement', count:575, icon:'view-grid', cats:[c.Lo], start:92160},
			{ name:'Mro', count:47, icon:'view-grid', cats:[c.Lo,c.Nd,c.Po], start:92736},
			{ name:'Tangsa', count:95, icon:'view-grid', cats:[c.Lo,c.Nd], start:92784},
			{ name:'Bassa Vah', count:47, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po], start:92880},
			{ name:'Pahawh Hmong', count:143, icon:'view-grid', cats:[c.Lo,c.Mn,c.Po,c.So,c.Lm,c.Nd,c.No], start:92928},
			{ name:'Medefaidrin', count:95, icon:'view-grid', cats:[c.Lu,c.Ll,c.No,c.Po], start:93760},
			{ name:'Miao', count:159, icon:'view-grid', cats:[c.Lo,c.Mn,c.Mc,c.Lm], start:93952},
			{ name:'Ideographic Symbols and Punctuation', count:31, icon:'view-grid', cats:[c.Lm,c.Po,c.Mn,c.Mc], start:94176},
			{ name:'Tangut', count:6143, icon:'view-grid', cats:[c.Lo], start:94208},
			{ name:'Tangut Components', count:767, icon:'view-grid', cats:[c.Lo], start:100352},
			{ name:'Khitan Small Script', count:511, icon:'view-grid', cats:[c.Lo], start:101120},
			{ name:'Tangut Supplement', count:127, icon:'view-grid', cats:[c.Lo], start:101632},
			{ name:'Kana Extended-B', count:15, icon:'view-grid', cats:[c.Lm], start:110576},
			{ name:'Kana Supplement', count:255, icon:'view-grid', cats:[c.Lo], start:110592},
			{ name:'Kana Extended-A', count:47, icon:'view-grid', cats:[c.Lo], start:110848},
			{ name:'Small Kana Extension', count:63, icon:'view-grid', cats:[c.Lo], start:110896},
			{ name:'Nushu', count:399, icon:'view-grid', cats:[c.Lo], start:110960},
			{ name:'Duployan', count:159, icon:'view-grid', cats:[c.Lo,c.So,c.Mn,c.Po], start:113664},
			{ name:'Shorthand Format Controls', count:15, icon:'view-grid', cats:[c.Cf], start:113824},
			{ name:'Znamenny Musical Notation', count:207, icon:'view-grid', cats:[c.Mn,c.So], start:118528},
			{ name:'Byzantine Musical Symbols', count:255, icon:'view-grid', cats:[c.So], start:118784},
			{ name:'Musical Symbols', count:255, icon:'view-grid', cats:[c.So,c.Mc,c.Mn,c.Cf], start:119040},
			{ name:'Ancient Greek Musical Notation', count:79, icon:'view-grid', cats:[c.So,c.Mn], start:119296},
			{ name:'Mayan Numerals', count:31, icon:'view-grid', cats:[c.No], start:119520},
			{ name:'Tai Xuan Jing Symbols', count:95, icon:'view-grid', cats:[c.So], start:119552},
			{ name:'Counting Rod Numerals', count:31, icon:'view-grid', cats:[c.No], start:119648},
			{ name:'Mathematical Alphanumeric Symbols', count:1023, icon:'view-grid', cats:[c.Lu,c.Ll,c.Sm,c.Nd], start:119808},
			{ name:'Sutton SignWriting', count:687, icon:'view-grid', cats:[c.So,c.Mn,c.Po], start:120832},
			{ name:'Latin Extended-G', count:255, icon:'view-grid', cats:[c.Ll,c.Lo], start:122624},
			{ name:'Glagolitic Supplement', count:47, icon:'view-grid', cats:[c.Mn], start:122880},
			{ name:'Nyiakeng Puachue Hmong', count:79, icon:'view-grid', cats:[c.Lo,c.Mn,c.Lm,c.Nd,c.So], start:123136},
			{ name:'Toto', count:47, icon:'view-grid', cats:[c.Lo,c.Mn], start:123536},
			{ name:'Wancho', count:63, icon:'view-grid', cats:[c.Lo,c.Mn,c.Nd,c.Sc], start:123584},
			{ name:'Ethiopic Extended-B', count:31, icon:'view-grid', cats:[c.Lo], start:124896},
			{ name:'Mende Kikakui', count:223, icon:'view-grid', cats:[c.Lo,c.No,c.Mn], start:124928},
			{ name:'Adlam', count:95, icon:'view-grid', cats:[c.Lu,c.Ll,c.Mn,c.Lm,c.Nd,c.Po], start:125184},
			{ name:'Indic Siyaq Numbers', count:79, icon:'view-grid', cats:[c.No,c.So,c.Sc], start:126064},
			{ name:'Ottoman Siyaq Numbers', count:79, icon:'view-grid', cats:[c.No,c.So], start:126208},
			{ name:'Arabic Mathematical Alphabetic Symbols', count:255, icon:'view-grid', cats:[c.Lo,c.Sm], start:126464},
			{ name:'Mahjong Tiles', count:47, icon:'view-grid', cats:[c.So], start:126976},
			{ name:'Domino Tiles', count:111, icon:'view-grid', cats:[c.So], start:127024},
			{ name:'Playing Cards', count:95, icon:'view-grid', cats:[c.So], start:127136},
			{ name:'Enclosed Alphanumeric Supplement', count:255, icon:'view-grid', cats:[c.No,c.So], start:127232},
			{ name:'Enclosed Ideographic Supplement', count:255, icon:'view-grid', cats:[c.So], start:127488},
			{ name:'Miscellaneous Symbols and Pictographs', count:767, icon:'view-grid', cats:[c.So,c.Sk], start:127744},
			{ name:'Emoticons', count:79, icon:'view-grid', cats:[c.So], start:128512},
			{ name:'Ornamental Dingbats', count:47, icon:'view-grid', cats:[c.So], start:128592},
			{ name:'Transport and Map Symbols', count:127, icon:'view-grid', cats:[c.So], start:128640},
			{ name:'Alchemical Symbols', count:127, icon:'view-grid', cats:[c.So], start:128768},
			{ name:'Geometric Shapes Extended', count:127, icon:'view-grid', cats:[c.So], start:128896},
			{ name:'Supplemental Arrows-C', count:255, icon:'view-grid', cats:[c.So], start:129024},
			{ name:'Supplemental Symbols and Pictographs', count:255, icon:'view-grid', cats:[c.So], start:129280},
			{ name:'Chess Symbols', count:111, icon:'view-grid', cats:[c.So], start:129536},
			{ name:'Symbols and Pictographs Extended-A', count:143, icon:'view-grid', cats:[c.So], start:129648},
			{ name:'Symbols for Legacy Computing', count:255, icon:'view-grid', cats:[c.So,c.Nd], start:129792},
			{ name:'CJK Unified Ideographs Extension B', count:42719, icon:'view-grid', cats:[c.Lo], start:131072},
			{ name:'CJK Unified Ideographs Extension C', count:4159, icon:'view-grid', cats:[c.Lo], start:173824},
			{ name:'CJK Unified Ideographs Extension D', count:223, icon:'view-grid', cats:[c.Lo], start:177984},
			{ name:'CJK Unified Ideographs Extension E', count:5775, icon:'view-grid', cats:[c.Lo], start:178208},
			{ name:'CJK Unified Ideographs Extension F', count:7487, icon:'view-grid', cats:[c.Lo], start:183984},
			{ name:'CJK Compatibility Ideographs Supplement', count:543, icon:'view-grid', cats:[c.Lo], start:194560},
			{ name:'CJK Unified Ideographs Extension G', count:4943, icon:'view-grid', cats:[c.Lo], start:196608},
			{ name:'Tags', count:127, icon:'view-grid', cats:[c.Cf], start:917504},
			{ name:'Variation Selectors Supplement', count:239, icon:'view-grid', cats:[c.Mn], start:917760},
			{ name:'Supplementary Private Use Area-A', count:65535, icon:'view-grid', cats:[c.Co], start:983040},
			{ name:'Supplementary Private Use Area-B', count:65535, icon:'view-grid', cats:[c.Co], start:1048576}
			];

        b.forEach((obj) => {
            obj.itemClass = UniBlock;
            obj.primaryCommand = this.SetActiveRange;
        });

        this._blocks = b;
        this._blockCatalog = nkm.data.catalogs.CreateFrom({ name: `Unicode blocks`, autoSort: false }, b);
        this._blockCatalog.expanded = true;

        this._categoriesCatalog = nkm.data.catalogs.CreateFrom({ name: `Categories`, autoSort: false }, mgc);
        this._categoriesCatalog.expanded = true;

        for (var g in gc) {
            let gCat = gc[g], subs = gCat.subs;
            for (let i = 0; i < subs.length; i++) { subs[i].general = gCat; }
        }

        let k = {

			_0:{ name:'Spacing, split, enclosing, reordrant, and Tibetan subjoined', count:33649 },
			_1:{ name:'Overlays and interior', count:32 },
			_7:{ name:'Nuktas', count:27 },
			_8:{ name:'Hiragana/Katakana voicing marks', count:2 },
			_9:{ name:'Viramas', count:63 },
			_10:{ name:'Start of fixed position classes', count:1 },
			_199:{ name:'End of fixed position classes', count:0 },
			_200:{ name:'Below left attached', count:0 },
			_202:{ name:'Below attached', count:5 },
			_204:{ name:'Below right attached', count:0 },
			_208:{ name:'Left attached (reordrant around single base character)', count:0 },
			_210:{ name:'Right attached', count:0 },
			_212:{ name:'Above left attached', count:0 },
			_214:{ name:'Above attached', count:1 },
			_216:{ name:'Above right attached', count:9 },
			_218:{ name:'Below left', count:2 },
			_220:{ name:'Below', count:177 },
			_222:{ name:'Below right', count:4 },
			_224:{ name:'Left (reordrant around single base character)', count:2 },
			_226:{ name:'Right', count:1 },
			_228:{ name:'Above left', count:5 },
			_230:{ name:'Above', count:508 },
			_232:{ name:'Above right', count:5 },
			_233:{ name:'Double below', count:4 },
			_234:{ name:'Double above', count:5 },
			_240:{ name:'Below (iota subscript)', count:1 },
			};
        this._canonicalClasses = k;

        let cMap = {

			'1000':{ u:'1000', i:3501, name:'MYANMAR LETTER KA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1001':{ u:'1001', i:3502, name:'MYANMAR LETTER KHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1002':{ u:'1002', i:3503, name:'MYANMAR LETTER GA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1003':{ u:'1003', i:3504, name:'MYANMAR LETTER GHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1004':{ u:'1004', i:3505, name:'MYANMAR LETTER NGA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1005':{ u:'1005', i:3506, name:'MYANMAR LETTER CA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1006':{ u:'1006', i:3507, name:'MYANMAR LETTER CHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1007':{ u:'1007', i:3508, name:'MYANMAR LETTER JA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1008':{ u:'1008', i:3509, name:'MYANMAR LETTER JHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1009':{ u:'1009', i:3510, name:'MYANMAR LETTER NYA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1010':{ u:'1010', i:3517, name:'MYANMAR LETTER TA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1011':{ u:'1011', i:3518, name:'MYANMAR LETTER THA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1012':{ u:'1012', i:3519, name:'MYANMAR LETTER DA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1013':{ u:'1013', i:3520, name:'MYANMAR LETTER DHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1014':{ u:'1014', i:3521, name:'MYANMAR LETTER NA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1015':{ u:'1015', i:3522, name:'MYANMAR LETTER PA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1016':{ u:'1016', i:3523, name:'MYANMAR LETTER PHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1017':{ u:'1017', i:3524, name:'MYANMAR LETTER BA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1018':{ u:'1018', i:3525, name:'MYANMAR LETTER BHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1019':{ u:'1019', i:3526, name:'MYANMAR LETTER MA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1020':{ u:'1020', i:3533, name:'MYANMAR LETTER LLA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1021':{ u:'1021', i:3534, name:'MYANMAR LETTER A', cat:c.Lo,   canon:k._0, block:b[35], indexed:["A"]},
			'1022':{ u:'1022', i:3535, name:'MYANMAR LETTER SHAN A', cat:c.Lo,   canon:k._0, block:b[35], indexed:["A"]},
			'1023':{ u:'1023', i:3536, name:'MYANMAR LETTER I', cat:c.Lo,   canon:k._0, block:b[35], indexed:["I"]},
			'1024':{ u:'1024', i:3537, name:'MYANMAR LETTER II', cat:c.Lo,   canon:k._0, block:b[35]},
			'1025':{ u:'1025', i:3538, name:'MYANMAR LETTER U', cat:c.Lo,  relatives:['1026'],  canon:k._0, block:b[35], indexed:["U"]},
			'1026':{ u:'1026', i:3539, name:'MYANMAR LETTER UU', cat:c.Lo,  relatives:['1025', '102e'], comp:['1025','102e'], canon:k._0, block:b[35]},
			'1027':{ u:'1027', i:3540, name:'MYANMAR LETTER E', cat:c.Lo,   canon:k._0, block:b[35], indexed:["E"]},
			'1028':{ u:'1028', i:3541, name:'MYANMAR LETTER MON E', cat:c.Lo,   canon:k._0, block:b[35], indexed:["E"]},
			'1029':{ u:'1029', i:3542, name:'MYANMAR LETTER O', cat:c.Lo,   canon:k._0, block:b[35], indexed:["O"]},
			'1030':{ u:'1030', i:3549, name:'MYANMAR VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[35]},
			'1031':{ u:'1031', i:3550, name:'MYANMAR VOWEL SIGN E', cat:c.Mc,   canon:k._0, block:b[35], indexed:["E"]},
			'1032':{ u:'1032', i:3551, name:'MYANMAR VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[35]},
			'1033':{ u:'1033', i:3552, name:'MYANMAR VOWEL SIGN MON II', cat:c.Mn,   canon:k._0, block:b[35]},
			'1034':{ u:'1034', i:3553, name:'MYANMAR VOWEL SIGN MON O', cat:c.Mn,   canon:k._0, block:b[35], indexed:["O"]},
			'1035':{ u:'1035', i:3554, name:'MYANMAR VOWEL SIGN E ABOVE', cat:c.Mn,   canon:k._0, block:b[35], indexed:["E"]},
			'1036':{ u:'1036', i:3555, name:'MYANMAR SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[35]},
			'1037':{ u:'1037', i:3556, name:'MYANMAR SIGN DOT BELOW', cat:c.Mn,   canon:k._7, block:b[35]},
			'1038':{ u:'1038', i:3557, name:'MYANMAR SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[35]},
			'1039':{ u:'1039', i:3558, name:'MYANMAR SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[35]},
			'1040':{ u:'1040', i:3565, name:'MYANMAR DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[35]},
			'1041':{ u:'1041', i:3566, name:'MYANMAR DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1042':{ u:'1042', i:3567, name:'MYANMAR DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[35]},
			'1043':{ u:'1043', i:3568, name:'MYANMAR DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1044':{ u:'1044', i:3569, name:'MYANMAR DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[35]},
			'1045':{ u:'1045', i:3570, name:'MYANMAR DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1046':{ u:'1046', i:3571, name:'MYANMAR DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[35]},
			'1047':{ u:'1047', i:3572, name:'MYANMAR DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[35]},
			'1048':{ u:'1048', i:3573, name:'MYANMAR DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[35]},
			'1049':{ u:'1049', i:3574, name:'MYANMAR DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1050':{ u:'1050', i:3581, name:'MYANMAR LETTER SHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1051':{ u:'1051', i:3582, name:'MYANMAR LETTER SSA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1052':{ u:'1052', i:3583, name:'MYANMAR LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[35], indexed:["R"]},
			'1053':{ u:'1053', i:3584, name:'MYANMAR LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[35]},
			'1054':{ u:'1054', i:3585, name:'MYANMAR LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[35], indexed:["L"]},
			'1055':{ u:'1055', i:3586, name:'MYANMAR LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[35]},
			'1056':{ u:'1056', i:3587, name:'MYANMAR VOWEL SIGN VOCALIC R', cat:c.Mc,   canon:k._0, block:b[35], indexed:["R"]},
			'1057':{ u:'1057', i:3588, name:'MYANMAR VOWEL SIGN VOCALIC RR', cat:c.Mc,   canon:k._0, block:b[35]},
			'1058':{ u:'1058', i:3589, name:'MYANMAR VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[35], indexed:["L"]},
			'1059':{ u:'1059', i:3590, name:'MYANMAR VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[35]},
			'1060':{ u:'1060', i:3597, name:'MYANMAR CONSONANT SIGN MON MEDIAL LA', cat:c.Mn,   canon:k._0, block:b[35]},
			'1061':{ u:'1061', i:3598, name:'MYANMAR LETTER SGAW KAREN SHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1062':{ u:'1062', i:3599, name:'MYANMAR VOWEL SIGN SGAW KAREN EU', cat:c.Mc,   canon:k._0, block:b[35]},
			'1063':{ u:'1063', i:3600, name:'MYANMAR TONE MARK SGAW KAREN HATHI', cat:c.Mc,   canon:k._0, block:b[35]},
			'1064':{ u:'1064', i:3601, name:'MYANMAR TONE MARK SGAW KAREN KE PHO', cat:c.Mc,   canon:k._0, block:b[35]},
			'1065':{ u:'1065', i:3602, name:'MYANMAR LETTER WESTERN PWO KAREN THA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1066':{ u:'1066', i:3603, name:'MYANMAR LETTER WESTERN PWO KAREN PWA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1067':{ u:'1067', i:3604, name:'MYANMAR VOWEL SIGN WESTERN PWO KAREN EU', cat:c.Mc,   canon:k._0, block:b[35]},
			'1068':{ u:'1068', i:3605, name:'MYANMAR VOWEL SIGN WESTERN PWO KAREN UE', cat:c.Mc,   canon:k._0, block:b[35]},
			'1069':{ u:'1069', i:3606, name:'MYANMAR SIGN WESTERN PWO KAREN TONE-1', cat:c.Mc,   canon:k._0, block:b[35]},
			'1070':{ u:'1070', i:3613, name:'MYANMAR LETTER EASTERN PWO KAREN GHWA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1071':{ u:'1071', i:3614, name:'MYANMAR VOWEL SIGN GEBA KAREN I', cat:c.Mn,   canon:k._0, block:b[35], indexed:["I"]},
			'1072':{ u:'1072', i:3615, name:'MYANMAR VOWEL SIGN KAYAH OE', cat:c.Mn,   canon:k._0, block:b[35]},
			'1073':{ u:'1073', i:3616, name:'MYANMAR VOWEL SIGN KAYAH U', cat:c.Mn,   canon:k._0, block:b[35], indexed:["U"]},
			'1074':{ u:'1074', i:3617, name:'MYANMAR VOWEL SIGN KAYAH EE', cat:c.Mn,   canon:k._0, block:b[35]},
			'1075':{ u:'1075', i:3618, name:'MYANMAR LETTER SHAN KA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1076':{ u:'1076', i:3619, name:'MYANMAR LETTER SHAN KHA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1077':{ u:'1077', i:3620, name:'MYANMAR LETTER SHAN GA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1078':{ u:'1078', i:3621, name:'MYANMAR LETTER SHAN CA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1079':{ u:'1079', i:3622, name:'MYANMAR LETTER SHAN ZA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1080':{ u:'1080', i:3629, name:'MYANMAR LETTER SHAN THA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1081':{ u:'1081', i:3630, name:'MYANMAR LETTER SHAN HA', cat:c.Lo,   canon:k._0, block:b[35]},
			'1082':{ u:'1082', i:3631, name:'MYANMAR CONSONANT SIGN SHAN MEDIAL WA', cat:c.Mn,   canon:k._0, block:b[35]},
			'1083':{ u:'1083', i:3632, name:'MYANMAR VOWEL SIGN SHAN AA', cat:c.Mc,   canon:k._0, block:b[35]},
			'1084':{ u:'1084', i:3633, name:'MYANMAR VOWEL SIGN SHAN E', cat:c.Mc,   canon:k._0, block:b[35], indexed:["E"]},
			'1085':{ u:'1085', i:3634, name:'MYANMAR VOWEL SIGN SHAN E ABOVE', cat:c.Mn,   canon:k._0, block:b[35], indexed:["E"]},
			'1086':{ u:'1086', i:3635, name:'MYANMAR VOWEL SIGN SHAN FINAL Y', cat:c.Mn,   canon:k._0, block:b[35], indexed:["Y"]},
			'1087':{ u:'1087', i:3636, name:'MYANMAR SIGN SHAN TONE-2', cat:c.Mc,   canon:k._0, block:b[35]},
			'1088':{ u:'1088', i:3637, name:'MYANMAR SIGN SHAN TONE-3', cat:c.Mc,   canon:k._0, block:b[35]},
			'1089':{ u:'1089', i:3638, name:'MYANMAR SIGN SHAN TONE-5', cat:c.Mc,   canon:k._0, block:b[35]},
			'1090':{ u:'1090', i:3645, name:'MYANMAR SHAN DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[35]},
			'1091':{ u:'1091', i:3646, name:'MYANMAR SHAN DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1092':{ u:'1092', i:3647, name:'MYANMAR SHAN DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[35]},
			'1093':{ u:'1093', i:3648, name:'MYANMAR SHAN DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1094':{ u:'1094', i:3649, name:'MYANMAR SHAN DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[35]},
			'1095':{ u:'1095', i:3650, name:'MYANMAR SHAN DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1096':{ u:'1096', i:3651, name:'MYANMAR SHAN DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[35]},
			'1097':{ u:'1097', i:3652, name:'MYANMAR SHAN DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[35]},
			'1098':{ u:'1098', i:3653, name:'MYANMAR SHAN DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[35]},
			'1099':{ u:'1099', i:3654, name:'MYANMAR SHAN DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[35]},
			'1100':{ u:'1100', i:3749, name:'HANGUL CHOSEONG KIYEOK', cat:c.Lo,  relatives:['3131', '3200', '320e', '3260', '326e', '327c'],  canon:k._0, block:b[37]},
			'1101':{ u:'1101', i:3750, name:'HANGUL CHOSEONG SSANGKIYEOK', cat:c.Lo,  relatives:['3132'],  canon:k._0, block:b[37]},
			'1102':{ u:'1102', i:3751, name:'HANGUL CHOSEONG NIEUN', cat:c.Lo,  relatives:['3134', '3201', '320f', '3261', '326f'],  canon:k._0, block:b[37]},
			'1103':{ u:'1103', i:3752, name:'HANGUL CHOSEONG TIKEUT', cat:c.Lo,  relatives:['3137', '3202', '3210', '3262', '3270'],  canon:k._0, block:b[37]},
			'1104':{ u:'1104', i:3753, name:'HANGUL CHOSEONG SSANGTIKEUT', cat:c.Lo,  relatives:['3138'],  canon:k._0, block:b[37]},
			'1105':{ u:'1105', i:3754, name:'HANGUL CHOSEONG RIEUL', cat:c.Lo,  relatives:['3139', '3203', '3211', '3263', '3271'],  canon:k._0, block:b[37]},
			'1106':{ u:'1106', i:3755, name:'HANGUL CHOSEONG MIEUM', cat:c.Lo,  relatives:['3141', '3204', '3212', '3264', '3272'],  canon:k._0, block:b[37]},
			'1107':{ u:'1107', i:3756, name:'HANGUL CHOSEONG PIEUP', cat:c.Lo,  relatives:['3142', '3205', '3213', '3265', '3273'],  canon:k._0, block:b[37]},
			'1108':{ u:'1108', i:3757, name:'HANGUL CHOSEONG SSANGPIEUP', cat:c.Lo,  relatives:['3143'],  canon:k._0, block:b[37]},
			'1109':{ u:'1109', i:3758, name:'HANGUL CHOSEONG SIOS', cat:c.Lo,  relatives:['3145', '3206', '3214', '3266', '3274'],  canon:k._0, block:b[37]},
			'1110':{ u:'1110', i:3765, name:'HANGUL CHOSEONG THIEUTH', cat:c.Lo,  relatives:['314c', '320b', '3219', '326b', '3279'],  canon:k._0, block:b[37]},
			'1111':{ u:'1111', i:3766, name:'HANGUL CHOSEONG PHIEUPH', cat:c.Lo,  relatives:['314d', '320c', '321a', '326c', '327a'],  canon:k._0, block:b[37]},
			'1112':{ u:'1112', i:3767, name:'HANGUL CHOSEONG HIEUH', cat:c.Lo,  relatives:['314e', '320d', '321b', '321e', '326d', '327b'],  canon:k._0, block:b[37]},
			'1113':{ u:'1113', i:3768, name:'HANGUL CHOSEONG NIEUN-KIYEOK', cat:c.Lo,   canon:k._0, block:b[37]},
			'1114':{ u:'1114', i:3769, name:'HANGUL CHOSEONG SSANGNIEUN', cat:c.Lo,  relatives:['3165'],  canon:k._0, block:b[37]},
			'1115':{ u:'1115', i:3770, name:'HANGUL CHOSEONG NIEUN-TIKEUT', cat:c.Lo,  relatives:['3166'],  canon:k._0, block:b[37]},
			'1116':{ u:'1116', i:3771, name:'HANGUL CHOSEONG NIEUN-PIEUP', cat:c.Lo,   canon:k._0, block:b[37]},
			'1117':{ u:'1117', i:3772, name:'HANGUL CHOSEONG TIKEUT-KIYEOK', cat:c.Lo,   canon:k._0, block:b[37]},
			'1118':{ u:'1118', i:3773, name:'HANGUL CHOSEONG RIEUL-NIEUN', cat:c.Lo,   canon:k._0, block:b[37]},
			'1119':{ u:'1119', i:3774, name:'HANGUL CHOSEONG SSANGRIEUL', cat:c.Lo,   canon:k._0, block:b[37]},
			'1120':{ u:'1120', i:3781, name:'HANGUL CHOSEONG PIEUP-TIKEUT', cat:c.Lo,  relatives:['3173'],  canon:k._0, block:b[37]},
			'1121':{ u:'1121', i:3782, name:'HANGUL CHOSEONG PIEUP-SIOS', cat:c.Lo,  relatives:['3144'],  canon:k._0, block:b[37]},
			'1122':{ u:'1122', i:3783, name:'HANGUL CHOSEONG PIEUP-SIOS-KIYEOK', cat:c.Lo,  relatives:['3174'],  canon:k._0, block:b[37]},
			'1123':{ u:'1123', i:3784, name:'HANGUL CHOSEONG PIEUP-SIOS-TIKEUT', cat:c.Lo,  relatives:['3175'],  canon:k._0, block:b[37]},
			'1124':{ u:'1124', i:3785, name:'HANGUL CHOSEONG PIEUP-SIOS-PIEUP', cat:c.Lo,   canon:k._0, block:b[37]},
			'1125':{ u:'1125', i:3786, name:'HANGUL CHOSEONG PIEUP-SSANGSIOS', cat:c.Lo,   canon:k._0, block:b[37]},
			'1126':{ u:'1126', i:3787, name:'HANGUL CHOSEONG PIEUP-SIOS-CIEUC', cat:c.Lo,   canon:k._0, block:b[37]},
			'1127':{ u:'1127', i:3788, name:'HANGUL CHOSEONG PIEUP-CIEUC', cat:c.Lo,  relatives:['3176'],  canon:k._0, block:b[37]},
			'1128':{ u:'1128', i:3789, name:'HANGUL CHOSEONG PIEUP-CHIEUCH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1129':{ u:'1129', i:3790, name:'HANGUL CHOSEONG PIEUP-THIEUTH', cat:c.Lo,  relatives:['3177'],  canon:k._0, block:b[37]},
			'1130':{ u:'1130', i:3797, name:'HANGUL CHOSEONG SIOS-RIEUL', cat:c.Lo,   canon:k._0, block:b[37]},
			'1131':{ u:'1131', i:3798, name:'HANGUL CHOSEONG SIOS-MIEUM', cat:c.Lo,   canon:k._0, block:b[37]},
			'1132':{ u:'1132', i:3799, name:'HANGUL CHOSEONG SIOS-PIEUP', cat:c.Lo,  relatives:['317d'],  canon:k._0, block:b[37]},
			'1133':{ u:'1133', i:3800, name:'HANGUL CHOSEONG SIOS-PIEUP-KIYEOK', cat:c.Lo,   canon:k._0, block:b[37]},
			'1134':{ u:'1134', i:3801, name:'HANGUL CHOSEONG SIOS-SSANGSIOS', cat:c.Lo,   canon:k._0, block:b[37]},
			'1135':{ u:'1135', i:3802, name:'HANGUL CHOSEONG SIOS-IEUNG', cat:c.Lo,   canon:k._0, block:b[37]},
			'1136':{ u:'1136', i:3803, name:'HANGUL CHOSEONG SIOS-CIEUC', cat:c.Lo,  relatives:['317e'],  canon:k._0, block:b[37]},
			'1137':{ u:'1137', i:3804, name:'HANGUL CHOSEONG SIOS-CHIEUCH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1138':{ u:'1138', i:3805, name:'HANGUL CHOSEONG SIOS-KHIEUKH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1139':{ u:'1139', i:3806, name:'HANGUL CHOSEONG SIOS-THIEUTH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1140':{ u:'1140', i:3813, name:'HANGUL CHOSEONG PANSIOS', cat:c.Lo,  relatives:['317f'],  canon:k._0, block:b[37]},
			'1141':{ u:'1141', i:3814, name:'HANGUL CHOSEONG IEUNG-KIYEOK', cat:c.Lo,   canon:k._0, block:b[37]},
			'1142':{ u:'1142', i:3815, name:'HANGUL CHOSEONG IEUNG-TIKEUT', cat:c.Lo,   canon:k._0, block:b[37]},
			'1143':{ u:'1143', i:3816, name:'HANGUL CHOSEONG IEUNG-MIEUM', cat:c.Lo,   canon:k._0, block:b[37]},
			'1144':{ u:'1144', i:3817, name:'HANGUL CHOSEONG IEUNG-PIEUP', cat:c.Lo,   canon:k._0, block:b[37]},
			'1145':{ u:'1145', i:3818, name:'HANGUL CHOSEONG IEUNG-SIOS', cat:c.Lo,   canon:k._0, block:b[37]},
			'1146':{ u:'1146', i:3819, name:'HANGUL CHOSEONG IEUNG-PANSIOS', cat:c.Lo,   canon:k._0, block:b[37]},
			'1147':{ u:'1147', i:3820, name:'HANGUL CHOSEONG SSANGIEUNG', cat:c.Lo,  relatives:['3180'],  canon:k._0, block:b[37]},
			'1148':{ u:'1148', i:3821, name:'HANGUL CHOSEONG IEUNG-CIEUC', cat:c.Lo,   canon:k._0, block:b[37]},
			'1149':{ u:'1149', i:3822, name:'HANGUL CHOSEONG IEUNG-CHIEUCH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1150':{ u:'1150', i:3829, name:'HANGUL CHOSEONG CEONGCHIEUMCIEUC', cat:c.Lo,   canon:k._0, block:b[37]},
			'1151':{ u:'1151', i:3830, name:'HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC', cat:c.Lo,   canon:k._0, block:b[37]},
			'1152':{ u:'1152', i:3831, name:'HANGUL CHOSEONG CHIEUCH-KHIEUKH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1153':{ u:'1153', i:3832, name:'HANGUL CHOSEONG CHIEUCH-HIEUH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1154':{ u:'1154', i:3833, name:'HANGUL CHOSEONG CHITUEUMCHIEUCH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1155':{ u:'1155', i:3834, name:'HANGUL CHOSEONG CEONGCHIEUMCHIEUCH', cat:c.Lo,   canon:k._0, block:b[37]},
			'1156':{ u:'1156', i:3835, name:'HANGUL CHOSEONG PHIEUPH-PIEUP', cat:c.Lo,   canon:k._0, block:b[37]},
			'1157':{ u:'1157', i:3836, name:'HANGUL CHOSEONG KAPYEOUNPHIEUPH', cat:c.Lo,  relatives:['3184'],  canon:k._0, block:b[37]},
			'1158':{ u:'1158', i:3837, name:'HANGUL CHOSEONG SSANGHIEUH', cat:c.Lo,  relatives:['3185'],  canon:k._0, block:b[37]},
			'1159':{ u:'1159', i:3838, name:'HANGUL CHOSEONG YEORINHIEUH', cat:c.Lo,  relatives:['3186'],  canon:k._0, block:b[37]},
			'1160':{ u:'1160', i:3845, name:'HANGUL JUNGSEONG FILLER', cat:c.Lo,  relatives:['3164'],  canon:k._0, block:b[37]},
			'1161':{ u:'1161', i:3846, name:'HANGUL JUNGSEONG A', cat:c.Lo,  relatives:['314f', '320e', '320f', '3210', '3211', '3212', '3213', '3214', '3215', '3216', '3217', '3218', '3219', '321a', '321b', '326e', '326f', '3270', '3271', '3272', '3273', '3274', '3275', '3276', '3277', '3278', '3279', '327a', '327b', '327c'],  canon:k._0, block:b[37], indexed:["A"]},
			'1162':{ u:'1162', i:3847, name:'HANGUL JUNGSEONG AE', cat:c.Lo,  relatives:['3150'],  canon:k._0, block:b[37]},
			'1163':{ u:'1163', i:3848, name:'HANGUL JUNGSEONG YA', cat:c.Lo,  relatives:['3151'],  canon:k._0, block:b[37]},
			'1164':{ u:'1164', i:3849, name:'HANGUL JUNGSEONG YAE', cat:c.Lo,  relatives:['3152'],  canon:k._0, block:b[37]},
			'1165':{ u:'1165', i:3850, name:'HANGUL JUNGSEONG EO', cat:c.Lo,  relatives:['3153', '321d'],  canon:k._0, block:b[37]},
			'1166':{ u:'1166', i:3851, name:'HANGUL JUNGSEONG E', cat:c.Lo,  relatives:['3154'],  canon:k._0, block:b[37], indexed:["E"]},
			'1167':{ u:'1167', i:3852, name:'HANGUL JUNGSEONG YEO', cat:c.Lo,  relatives:['3155'],  canon:k._0, block:b[37]},
			'1168':{ u:'1168', i:3853, name:'HANGUL JUNGSEONG YE', cat:c.Lo,  relatives:['3156'],  canon:k._0, block:b[37]},
			'1169':{ u:'1169', i:3854, name:'HANGUL JUNGSEONG O', cat:c.Lo,  relatives:['3157', '321d', '321e', '327c'],  canon:k._0, block:b[37], indexed:["O"]},
			'1170':{ u:'1170', i:3861, name:'HANGUL JUNGSEONG WE', cat:c.Lo,  relatives:['315e'],  canon:k._0, block:b[37]},
			'1171':{ u:'1171', i:3862, name:'HANGUL JUNGSEONG WI', cat:c.Lo,  relatives:['315f'],  canon:k._0, block:b[37]},
			'1172':{ u:'1172', i:3863, name:'HANGUL JUNGSEONG YU', cat:c.Lo,  relatives:['3160'],  canon:k._0, block:b[37]},
			'1173':{ u:'1173', i:3864, name:'HANGUL JUNGSEONG EU', cat:c.Lo,  relatives:['3161'],  canon:k._0, block:b[37]},
			'1174':{ u:'1174', i:3865, name:'HANGUL JUNGSEONG YI', cat:c.Lo,  relatives:['3162', '327d'],  canon:k._0, block:b[37]},
			'1175':{ u:'1175', i:3866, name:'HANGUL JUNGSEONG I', cat:c.Lo,  relatives:['3163'],  canon:k._0, block:b[37], indexed:["I"]},
			'1176':{ u:'1176', i:3867, name:'HANGUL JUNGSEONG A-O', cat:c.Lo,   canon:k._0, block:b[37]},
			'1177':{ u:'1177', i:3868, name:'HANGUL JUNGSEONG A-U', cat:c.Lo,   canon:k._0, block:b[37]},
			'1178':{ u:'1178', i:3869, name:'HANGUL JUNGSEONG YA-O', cat:c.Lo,   canon:k._0, block:b[37]},
			'1179':{ u:'1179', i:3870, name:'HANGUL JUNGSEONG YA-YO', cat:c.Lo,   canon:k._0, block:b[37]},
			'1180':{ u:'1180', i:3877, name:'HANGUL JUNGSEONG O-E', cat:c.Lo,   canon:k._0, block:b[37]},
			'1181':{ u:'1181', i:3878, name:'HANGUL JUNGSEONG O-YE', cat:c.Lo,   canon:k._0, block:b[37]},
			'1182':{ u:'1182', i:3879, name:'HANGUL JUNGSEONG O-O', cat:c.Lo,   canon:k._0, block:b[37]},
			'1183':{ u:'1183', i:3880, name:'HANGUL JUNGSEONG O-U', cat:c.Lo,   canon:k._0, block:b[37]},
			'1184':{ u:'1184', i:3881, name:'HANGUL JUNGSEONG YO-YA', cat:c.Lo,  relatives:['3187'],  canon:k._0, block:b[37]},
			'1185':{ u:'1185', i:3882, name:'HANGUL JUNGSEONG YO-YAE', cat:c.Lo,  relatives:['3188'],  canon:k._0, block:b[37]},
			'1186':{ u:'1186', i:3883, name:'HANGUL JUNGSEONG YO-YEO', cat:c.Lo,   canon:k._0, block:b[37]},
			'1187':{ u:'1187', i:3884, name:'HANGUL JUNGSEONG YO-O', cat:c.Lo,   canon:k._0, block:b[37]},
			'1188':{ u:'1188', i:3885, name:'HANGUL JUNGSEONG YO-I', cat:c.Lo,  relatives:['3189'],  canon:k._0, block:b[37]},
			'1189':{ u:'1189', i:3886, name:'HANGUL JUNGSEONG U-A', cat:c.Lo,   canon:k._0, block:b[37]},
			'1190':{ u:'1190', i:3893, name:'HANGUL JUNGSEONG YU-E', cat:c.Lo,   canon:k._0, block:b[37]},
			'1191':{ u:'1191', i:3894, name:'HANGUL JUNGSEONG YU-YEO', cat:c.Lo,  relatives:['318a'],  canon:k._0, block:b[37]},
			'1192':{ u:'1192', i:3895, name:'HANGUL JUNGSEONG YU-YE', cat:c.Lo,  relatives:['318b'],  canon:k._0, block:b[37]},
			'1193':{ u:'1193', i:3896, name:'HANGUL JUNGSEONG YU-U', cat:c.Lo,   canon:k._0, block:b[37]},
			'1194':{ u:'1194', i:3897, name:'HANGUL JUNGSEONG YU-I', cat:c.Lo,  relatives:['318c'],  canon:k._0, block:b[37]},
			'1195':{ u:'1195', i:3898, name:'HANGUL JUNGSEONG EU-U', cat:c.Lo,   canon:k._0, block:b[37]},
			'1196':{ u:'1196', i:3899, name:'HANGUL JUNGSEONG EU-EU', cat:c.Lo,   canon:k._0, block:b[37]},
			'1197':{ u:'1197', i:3900, name:'HANGUL JUNGSEONG YI-U', cat:c.Lo,   canon:k._0, block:b[37]},
			'1198':{ u:'1198', i:3901, name:'HANGUL JUNGSEONG I-A', cat:c.Lo,   canon:k._0, block:b[37]},
			'1199':{ u:'1199', i:3902, name:'HANGUL JUNGSEONG I-YA', cat:c.Lo,   canon:k._0, block:b[37]},
			'1200':{ u:'1200', i:4005, name:'ETHIOPIC SYLLABLE HA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1201':{ u:'1201', i:4006, name:'ETHIOPIC SYLLABLE HU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1202':{ u:'1202', i:4007, name:'ETHIOPIC SYLLABLE HI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1203':{ u:'1203', i:4008, name:'ETHIOPIC SYLLABLE HAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1204':{ u:'1204', i:4009, name:'ETHIOPIC SYLLABLE HEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1205':{ u:'1205', i:4010, name:'ETHIOPIC SYLLABLE HE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1206':{ u:'1206', i:4011, name:'ETHIOPIC SYLLABLE HO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1207':{ u:'1207', i:4012, name:'ETHIOPIC SYLLABLE HOA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1208':{ u:'1208', i:4013, name:'ETHIOPIC SYLLABLE LA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1209':{ u:'1209', i:4014, name:'ETHIOPIC SYLLABLE LU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1210':{ u:'1210', i:4021, name:'ETHIOPIC SYLLABLE HHA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1211':{ u:'1211', i:4022, name:'ETHIOPIC SYLLABLE HHU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1212':{ u:'1212', i:4023, name:'ETHIOPIC SYLLABLE HHI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1213':{ u:'1213', i:4024, name:'ETHIOPIC SYLLABLE HHAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1214':{ u:'1214', i:4025, name:'ETHIOPIC SYLLABLE HHEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1215':{ u:'1215', i:4026, name:'ETHIOPIC SYLLABLE HHE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1216':{ u:'1216', i:4027, name:'ETHIOPIC SYLLABLE HHO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1217':{ u:'1217', i:4028, name:'ETHIOPIC SYLLABLE HHWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1218':{ u:'1218', i:4029, name:'ETHIOPIC SYLLABLE MA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1219':{ u:'1219', i:4030, name:'ETHIOPIC SYLLABLE MU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1220':{ u:'1220', i:4037, name:'ETHIOPIC SYLLABLE SZA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1221':{ u:'1221', i:4038, name:'ETHIOPIC SYLLABLE SZU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1222':{ u:'1222', i:4039, name:'ETHIOPIC SYLLABLE SZI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1223':{ u:'1223', i:4040, name:'ETHIOPIC SYLLABLE SZAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1224':{ u:'1224', i:4041, name:'ETHIOPIC SYLLABLE SZEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1225':{ u:'1225', i:4042, name:'ETHIOPIC SYLLABLE SZE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1226':{ u:'1226', i:4043, name:'ETHIOPIC SYLLABLE SZO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1227':{ u:'1227', i:4044, name:'ETHIOPIC SYLLABLE SZWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1228':{ u:'1228', i:4045, name:'ETHIOPIC SYLLABLE RA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1229':{ u:'1229', i:4046, name:'ETHIOPIC SYLLABLE RU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1230':{ u:'1230', i:4053, name:'ETHIOPIC SYLLABLE SA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1231':{ u:'1231', i:4054, name:'ETHIOPIC SYLLABLE SU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1232':{ u:'1232', i:4055, name:'ETHIOPIC SYLLABLE SI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1233':{ u:'1233', i:4056, name:'ETHIOPIC SYLLABLE SAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1234':{ u:'1234', i:4057, name:'ETHIOPIC SYLLABLE SEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1235':{ u:'1235', i:4058, name:'ETHIOPIC SYLLABLE SE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1236':{ u:'1236', i:4059, name:'ETHIOPIC SYLLABLE SO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1237':{ u:'1237', i:4060, name:'ETHIOPIC SYLLABLE SWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1238':{ u:'1238', i:4061, name:'ETHIOPIC SYLLABLE SHA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1239':{ u:'1239', i:4062, name:'ETHIOPIC SYLLABLE SHU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1240':{ u:'1240', i:4069, name:'ETHIOPIC SYLLABLE QA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1241':{ u:'1241', i:4070, name:'ETHIOPIC SYLLABLE QU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1242':{ u:'1242', i:4071, name:'ETHIOPIC SYLLABLE QI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1243':{ u:'1243', i:4072, name:'ETHIOPIC SYLLABLE QAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1244':{ u:'1244', i:4073, name:'ETHIOPIC SYLLABLE QEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1245':{ u:'1245', i:4074, name:'ETHIOPIC SYLLABLE QE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1246':{ u:'1246', i:4075, name:'ETHIOPIC SYLLABLE QO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1247':{ u:'1247', i:4076, name:'ETHIOPIC SYLLABLE QOA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1248':{ u:'1248', i:4077, name:'ETHIOPIC SYLLABLE QWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1250':{ u:'1250', i:4082, name:'ETHIOPIC SYLLABLE QHA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1251':{ u:'1251', i:4083, name:'ETHIOPIC SYLLABLE QHU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1252':{ u:'1252', i:4084, name:'ETHIOPIC SYLLABLE QHI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1253':{ u:'1253', i:4085, name:'ETHIOPIC SYLLABLE QHAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1254':{ u:'1254', i:4086, name:'ETHIOPIC SYLLABLE QHEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1255':{ u:'1255', i:4087, name:'ETHIOPIC SYLLABLE QHE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1256':{ u:'1256', i:4088, name:'ETHIOPIC SYLLABLE QHO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1258':{ u:'1258', i:4089, name:'ETHIOPIC SYLLABLE QHWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1260':{ u:'1260', i:4094, name:'ETHIOPIC SYLLABLE BA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1261':{ u:'1261', i:4095, name:'ETHIOPIC SYLLABLE BU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1262':{ u:'1262', i:4096, name:'ETHIOPIC SYLLABLE BI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1263':{ u:'1263', i:4097, name:'ETHIOPIC SYLLABLE BAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1264':{ u:'1264', i:4098, name:'ETHIOPIC SYLLABLE BEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1265':{ u:'1265', i:4099, name:'ETHIOPIC SYLLABLE BE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1266':{ u:'1266', i:4100, name:'ETHIOPIC SYLLABLE BO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1267':{ u:'1267', i:4101, name:'ETHIOPIC SYLLABLE BWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1268':{ u:'1268', i:4102, name:'ETHIOPIC SYLLABLE VA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1269':{ u:'1269', i:4103, name:'ETHIOPIC SYLLABLE VU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1270':{ u:'1270', i:4110, name:'ETHIOPIC SYLLABLE TA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1271':{ u:'1271', i:4111, name:'ETHIOPIC SYLLABLE TU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1272':{ u:'1272', i:4112, name:'ETHIOPIC SYLLABLE TI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1273':{ u:'1273', i:4113, name:'ETHIOPIC SYLLABLE TAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1274':{ u:'1274', i:4114, name:'ETHIOPIC SYLLABLE TEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1275':{ u:'1275', i:4115, name:'ETHIOPIC SYLLABLE TE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1276':{ u:'1276', i:4116, name:'ETHIOPIC SYLLABLE TO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1277':{ u:'1277', i:4117, name:'ETHIOPIC SYLLABLE TWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1278':{ u:'1278', i:4118, name:'ETHIOPIC SYLLABLE CA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1279':{ u:'1279', i:4119, name:'ETHIOPIC SYLLABLE CU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1280':{ u:'1280', i:4126, name:'ETHIOPIC SYLLABLE XA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1281':{ u:'1281', i:4127, name:'ETHIOPIC SYLLABLE XU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1282':{ u:'1282', i:4128, name:'ETHIOPIC SYLLABLE XI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1283':{ u:'1283', i:4129, name:'ETHIOPIC SYLLABLE XAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1284':{ u:'1284', i:4130, name:'ETHIOPIC SYLLABLE XEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1285':{ u:'1285', i:4131, name:'ETHIOPIC SYLLABLE XE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1286':{ u:'1286', i:4132, name:'ETHIOPIC SYLLABLE XO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1287':{ u:'1287', i:4133, name:'ETHIOPIC SYLLABLE XOA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1288':{ u:'1288', i:4134, name:'ETHIOPIC SYLLABLE XWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1290':{ u:'1290', i:4139, name:'ETHIOPIC SYLLABLE NA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1291':{ u:'1291', i:4140, name:'ETHIOPIC SYLLABLE NU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1292':{ u:'1292', i:4141, name:'ETHIOPIC SYLLABLE NI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1293':{ u:'1293', i:4142, name:'ETHIOPIC SYLLABLE NAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1294':{ u:'1294', i:4143, name:'ETHIOPIC SYLLABLE NEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1295':{ u:'1295', i:4144, name:'ETHIOPIC SYLLABLE NE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1296':{ u:'1296', i:4145, name:'ETHIOPIC SYLLABLE NO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1297':{ u:'1297', i:4146, name:'ETHIOPIC SYLLABLE NWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1298':{ u:'1298', i:4147, name:'ETHIOPIC SYLLABLE NYA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1299':{ u:'1299', i:4148, name:'ETHIOPIC SYLLABLE NYU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1300':{ u:'1300', i:4243, name:'ETHIOPIC SYLLABLE JA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1301':{ u:'1301', i:4244, name:'ETHIOPIC SYLLABLE JU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1302':{ u:'1302', i:4245, name:'ETHIOPIC SYLLABLE JI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1303':{ u:'1303', i:4246, name:'ETHIOPIC SYLLABLE JAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1304':{ u:'1304', i:4247, name:'ETHIOPIC SYLLABLE JEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1305':{ u:'1305', i:4248, name:'ETHIOPIC SYLLABLE JE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1306':{ u:'1306', i:4249, name:'ETHIOPIC SYLLABLE JO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1307':{ u:'1307', i:4250, name:'ETHIOPIC SYLLABLE JWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1308':{ u:'1308', i:4251, name:'ETHIOPIC SYLLABLE GA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1309':{ u:'1309', i:4252, name:'ETHIOPIC SYLLABLE GU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1310':{ u:'1310', i:4259, name:'ETHIOPIC SYLLABLE GWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1312':{ u:'1312', i:4260, name:'ETHIOPIC SYLLABLE GWI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1313':{ u:'1313', i:4261, name:'ETHIOPIC SYLLABLE GWAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1314':{ u:'1314', i:4262, name:'ETHIOPIC SYLLABLE GWEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1315':{ u:'1315', i:4263, name:'ETHIOPIC SYLLABLE GWE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1318':{ u:'1318', i:4264, name:'ETHIOPIC SYLLABLE GGA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1319':{ u:'1319', i:4265, name:'ETHIOPIC SYLLABLE GGU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1320':{ u:'1320', i:4272, name:'ETHIOPIC SYLLABLE THA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1321':{ u:'1321', i:4273, name:'ETHIOPIC SYLLABLE THU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1322':{ u:'1322', i:4274, name:'ETHIOPIC SYLLABLE THI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1323':{ u:'1323', i:4275, name:'ETHIOPIC SYLLABLE THAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1324':{ u:'1324', i:4276, name:'ETHIOPIC SYLLABLE THEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1325':{ u:'1325', i:4277, name:'ETHIOPIC SYLLABLE THE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1326':{ u:'1326', i:4278, name:'ETHIOPIC SYLLABLE THO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1327':{ u:'1327', i:4279, name:'ETHIOPIC SYLLABLE THWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1328':{ u:'1328', i:4280, name:'ETHIOPIC SYLLABLE CHA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1329':{ u:'1329', i:4281, name:'ETHIOPIC SYLLABLE CHU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1330':{ u:'1330', i:4288, name:'ETHIOPIC SYLLABLE PHA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1331':{ u:'1331', i:4289, name:'ETHIOPIC SYLLABLE PHU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1332':{ u:'1332', i:4290, name:'ETHIOPIC SYLLABLE PHI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1333':{ u:'1333', i:4291, name:'ETHIOPIC SYLLABLE PHAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1334':{ u:'1334', i:4292, name:'ETHIOPIC SYLLABLE PHEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1335':{ u:'1335', i:4293, name:'ETHIOPIC SYLLABLE PHE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1336':{ u:'1336', i:4294, name:'ETHIOPIC SYLLABLE PHO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1337':{ u:'1337', i:4295, name:'ETHIOPIC SYLLABLE PHWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1338':{ u:'1338', i:4296, name:'ETHIOPIC SYLLABLE TSA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1339':{ u:'1339', i:4297, name:'ETHIOPIC SYLLABLE TSU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1340':{ u:'1340', i:4304, name:'ETHIOPIC SYLLABLE TZA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1341':{ u:'1341', i:4305, name:'ETHIOPIC SYLLABLE TZU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1342':{ u:'1342', i:4306, name:'ETHIOPIC SYLLABLE TZI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1343':{ u:'1343', i:4307, name:'ETHIOPIC SYLLABLE TZAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1344':{ u:'1344', i:4308, name:'ETHIOPIC SYLLABLE TZEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1345':{ u:'1345', i:4309, name:'ETHIOPIC SYLLABLE TZE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1346':{ u:'1346', i:4310, name:'ETHIOPIC SYLLABLE TZO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1347':{ u:'1347', i:4311, name:'ETHIOPIC SYLLABLE TZOA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1348':{ u:'1348', i:4312, name:'ETHIOPIC SYLLABLE FA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1349':{ u:'1349', i:4313, name:'ETHIOPIC SYLLABLE FU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1350':{ u:'1350', i:4320, name:'ETHIOPIC SYLLABLE PA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1351':{ u:'1351', i:4321, name:'ETHIOPIC SYLLABLE PU', cat:c.Lo,   canon:k._0, block:b[38]},
			'1352':{ u:'1352', i:4322, name:'ETHIOPIC SYLLABLE PI', cat:c.Lo,   canon:k._0, block:b[38]},
			'1353':{ u:'1353', i:4323, name:'ETHIOPIC SYLLABLE PAA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1354':{ u:'1354', i:4324, name:'ETHIOPIC SYLLABLE PEE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1355':{ u:'1355', i:4325, name:'ETHIOPIC SYLLABLE PE', cat:c.Lo,   canon:k._0, block:b[38]},
			'1356':{ u:'1356', i:4326, name:'ETHIOPIC SYLLABLE PO', cat:c.Lo,   canon:k._0, block:b[38]},
			'1357':{ u:'1357', i:4327, name:'ETHIOPIC SYLLABLE PWA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1358':{ u:'1358', i:4328, name:'ETHIOPIC SYLLABLE RYA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1359':{ u:'1359', i:4329, name:'ETHIOPIC SYLLABLE MYA', cat:c.Lo,   canon:k._0, block:b[38]},
			'1360':{ u:'1360', i:4334, name:'ETHIOPIC SECTION MARK', cat:c.Po,   canon:k._0, block:b[38]},
			'1361':{ u:'1361', i:4335, name:'ETHIOPIC WORDSPACE', cat:c.Po,   canon:k._0, block:b[38]},
			'1362':{ u:'1362', i:4336, name:'ETHIOPIC FULL STOP', cat:c.Po,   canon:k._0, block:b[38]},
			'1363':{ u:'1363', i:4337, name:'ETHIOPIC COMMA', cat:c.Po,   canon:k._0, block:b[38]},
			'1364':{ u:'1364', i:4338, name:'ETHIOPIC SEMICOLON', cat:c.Po,   canon:k._0, block:b[38]},
			'1365':{ u:'1365', i:4339, name:'ETHIOPIC COLON', cat:c.Po,   canon:k._0, block:b[38]},
			'1366':{ u:'1366', i:4340, name:'ETHIOPIC PREFACE COLON', cat:c.Po,   canon:k._0, block:b[38]},
			'1367':{ u:'1367', i:4341, name:'ETHIOPIC QUESTION MARK', cat:c.Po,   canon:k._0, block:b[38]},
			'1368':{ u:'1368', i:4342, name:'ETHIOPIC PARAGRAPH SEPARATOR', cat:c.Po,   canon:k._0, block:b[38]},
			'1369':{ u:'1369', i:4343, name:'ETHIOPIC DIGIT ONE', cat:c.No,   canon:k._0, block:b[38]},
			'1370':{ u:'1370', i:4350, name:'ETHIOPIC DIGIT EIGHT', cat:c.No,   canon:k._0, block:b[38]},
			'1371':{ u:'1371', i:4351, name:'ETHIOPIC DIGIT NINE', cat:c.No,   canon:k._0, block:b[38]},
			'1372':{ u:'1372', i:4352, name:'ETHIOPIC NUMBER TEN', cat:c.No,   canon:k._0, block:b[38]},
			'1373':{ u:'1373', i:4353, name:'ETHIOPIC NUMBER TWENTY', cat:c.No,   canon:k._0, block:b[38]},
			'1374':{ u:'1374', i:4354, name:'ETHIOPIC NUMBER THIRTY', cat:c.No,   canon:k._0, block:b[38]},
			'1375':{ u:'1375', i:4355, name:'ETHIOPIC NUMBER FORTY', cat:c.No,   canon:k._0, block:b[38]},
			'1376':{ u:'1376', i:4356, name:'ETHIOPIC NUMBER FIFTY', cat:c.No,   canon:k._0, block:b[38]},
			'1377':{ u:'1377', i:4357, name:'ETHIOPIC NUMBER SIXTY', cat:c.No,   canon:k._0, block:b[38]},
			'1378':{ u:'1378', i:4358, name:'ETHIOPIC NUMBER SEVENTY', cat:c.No,   canon:k._0, block:b[38]},
			'1379':{ u:'1379', i:4359, name:'ETHIOPIC NUMBER EIGHTY', cat:c.No,   canon:k._0, block:b[38]},
			'1380':{ u:'1380', i:4363, name:'ETHIOPIC SYLLABLE SEBATBEIT MWA', cat:c.Lo,   canon:k._0, block:b[39]},
			'1381':{ u:'1381', i:4364, name:'ETHIOPIC SYLLABLE MWI', cat:c.Lo,   canon:k._0, block:b[39]},
			'1382':{ u:'1382', i:4365, name:'ETHIOPIC SYLLABLE MWEE', cat:c.Lo,   canon:k._0, block:b[39]},
			'1383':{ u:'1383', i:4366, name:'ETHIOPIC SYLLABLE MWE', cat:c.Lo,   canon:k._0, block:b[39]},
			'1384':{ u:'1384', i:4367, name:'ETHIOPIC SYLLABLE SEBATBEIT BWA', cat:c.Lo,   canon:k._0, block:b[39]},
			'1385':{ u:'1385', i:4368, name:'ETHIOPIC SYLLABLE BWI', cat:c.Lo,   canon:k._0, block:b[39]},
			'1386':{ u:'1386', i:4369, name:'ETHIOPIC SYLLABLE BWEE', cat:c.Lo,   canon:k._0, block:b[39]},
			'1387':{ u:'1387', i:4370, name:'ETHIOPIC SYLLABLE BWE', cat:c.Lo,   canon:k._0, block:b[39]},
			'1388':{ u:'1388', i:4371, name:'ETHIOPIC SYLLABLE SEBATBEIT FWA', cat:c.Lo,   canon:k._0, block:b[39]},
			'1389':{ u:'1389', i:4372, name:'ETHIOPIC SYLLABLE FWI', cat:c.Lo,   canon:k._0, block:b[39]},
			'1390':{ u:'1390', i:4379, name:'ETHIOPIC TONAL MARK YIZET', cat:c.So,   canon:k._0, block:b[39]},
			'1391':{ u:'1391', i:4380, name:'ETHIOPIC TONAL MARK DERET', cat:c.So,   canon:k._0, block:b[39]},
			'1392':{ u:'1392', i:4381, name:'ETHIOPIC TONAL MARK RIKRIK', cat:c.So,   canon:k._0, block:b[39]},
			'1393':{ u:'1393', i:4382, name:'ETHIOPIC TONAL MARK SHORT RIKRIK', cat:c.So,   canon:k._0, block:b[39]},
			'1394':{ u:'1394', i:4383, name:'ETHIOPIC TONAL MARK DIFAT', cat:c.So,   canon:k._0, block:b[39]},
			'1395':{ u:'1395', i:4384, name:'ETHIOPIC TONAL MARK KENAT', cat:c.So,   canon:k._0, block:b[39]},
			'1396':{ u:'1396', i:4385, name:'ETHIOPIC TONAL MARK CHIRET', cat:c.So,   canon:k._0, block:b[39]},
			'1397':{ u:'1397', i:4386, name:'ETHIOPIC TONAL MARK HIDET', cat:c.So,   canon:k._0, block:b[39]},
			'1398':{ u:'1398', i:4387, name:'ETHIOPIC TONAL MARK DERET-HIDET', cat:c.So,   canon:k._0, block:b[39]},
			'1399':{ u:'1399', i:4388, name:'ETHIOPIC TONAL MARK KURT', cat:c.So,   canon:k._0, block:b[39]},
			'1400':{ u:'1400', i:4481, name:'CANADIAN SYLLABICS HYPHEN', cat:c.Pd,   canon:k._0, block:b[41]},
			'1401':{ u:'1401', i:4482, name:'CANADIAN SYLLABICS E', cat:c.Lo,   canon:k._0, block:b[41], indexed:["E"]},
			'1402':{ u:'1402', i:4483, name:'CANADIAN SYLLABICS AAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1403':{ u:'1403', i:4484, name:'CANADIAN SYLLABICS I', cat:c.Lo,   canon:k._0, block:b[41], indexed:["I"]},
			'1404':{ u:'1404', i:4485, name:'CANADIAN SYLLABICS II', cat:c.Lo,   canon:k._0, block:b[41]},
			'1405':{ u:'1405', i:4486, name:'CANADIAN SYLLABICS O', cat:c.Lo,   canon:k._0, block:b[41], indexed:["O"]},
			'1406':{ u:'1406', i:4487, name:'CANADIAN SYLLABICS OO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1407':{ u:'1407', i:4488, name:'CANADIAN SYLLABICS Y-CREE OO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1408':{ u:'1408', i:4489, name:'CANADIAN SYLLABICS CARRIER EE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1409':{ u:'1409', i:4490, name:'CANADIAN SYLLABICS CARRIER I', cat:c.Lo,   canon:k._0, block:b[41], indexed:["I"]},
			'1410':{ u:'1410', i:4497, name:'CANADIAN SYLLABICS WII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1411':{ u:'1411', i:4498, name:'CANADIAN SYLLABICS WEST-CREE WII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1412':{ u:'1412', i:4499, name:'CANADIAN SYLLABICS WO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1413':{ u:'1413', i:4500, name:'CANADIAN SYLLABICS WEST-CREE WO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1414':{ u:'1414', i:4501, name:'CANADIAN SYLLABICS WOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1415':{ u:'1415', i:4502, name:'CANADIAN SYLLABICS WEST-CREE WOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1416':{ u:'1416', i:4503, name:'CANADIAN SYLLABICS NASKAPI WOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1417':{ u:'1417', i:4504, name:'CANADIAN SYLLABICS WA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1418':{ u:'1418', i:4505, name:'CANADIAN SYLLABICS WEST-CREE WA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1419':{ u:'1419', i:4506, name:'CANADIAN SYLLABICS WAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1420':{ u:'1420', i:4513, name:'CANADIAN SYLLABICS FINAL GRAVE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1421':{ u:'1421', i:4514, name:'CANADIAN SYLLABICS FINAL BOTTOM HALF RING', cat:c.Lo,   canon:k._0, block:b[41]},
			'1422':{ u:'1422', i:4515, name:'CANADIAN SYLLABICS FINAL TOP HALF RING', cat:c.Lo,   canon:k._0, block:b[41]},
			'1423':{ u:'1423', i:4516, name:'CANADIAN SYLLABICS FINAL RIGHT HALF RING', cat:c.Lo,   canon:k._0, block:b[41]},
			'1424':{ u:'1424', i:4517, name:'CANADIAN SYLLABICS FINAL RING', cat:c.Lo,   canon:k._0, block:b[41]},
			'1425':{ u:'1425', i:4518, name:'CANADIAN SYLLABICS FINAL DOUBLE ACUTE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1426':{ u:'1426', i:4519, name:'CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES', cat:c.Lo,   canon:k._0, block:b[41]},
			'1427':{ u:'1427', i:4520, name:'CANADIAN SYLLABICS FINAL MIDDLE DOT', cat:c.Lo,   canon:k._0, block:b[41]},
			'1428':{ u:'1428', i:4521, name:'CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1429':{ u:'1429', i:4522, name:'CANADIAN SYLLABICS FINAL PLUS', cat:c.Lo,   canon:k._0, block:b[41]},
			'1430':{ u:'1430', i:4529, name:'CANADIAN SYLLABICS PAAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1431':{ u:'1431', i:4530, name:'CANADIAN SYLLABICS PI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1432':{ u:'1432', i:4531, name:'CANADIAN SYLLABICS PII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1433':{ u:'1433', i:4532, name:'CANADIAN SYLLABICS PO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1434':{ u:'1434', i:4533, name:'CANADIAN SYLLABICS POO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1435':{ u:'1435', i:4534, name:'CANADIAN SYLLABICS Y-CREE POO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1436':{ u:'1436', i:4535, name:'CANADIAN SYLLABICS CARRIER HEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1437':{ u:'1437', i:4536, name:'CANADIAN SYLLABICS CARRIER HI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1438':{ u:'1438', i:4537, name:'CANADIAN SYLLABICS PA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1439':{ u:'1439', i:4538, name:'CANADIAN SYLLABICS PAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1440':{ u:'1440', i:4545, name:'CANADIAN SYLLABICS PWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1441':{ u:'1441', i:4546, name:'CANADIAN SYLLABICS WEST-CREE PWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1442':{ u:'1442', i:4547, name:'CANADIAN SYLLABICS PWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1443':{ u:'1443', i:4548, name:'CANADIAN SYLLABICS WEST-CREE PWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1444':{ u:'1444', i:4549, name:'CANADIAN SYLLABICS PWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1445':{ u:'1445', i:4550, name:'CANADIAN SYLLABICS WEST-CREE PWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1446':{ u:'1446', i:4551, name:'CANADIAN SYLLABICS PWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1447':{ u:'1447', i:4552, name:'CANADIAN SYLLABICS WEST-CREE PWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1448':{ u:'1448', i:4553, name:'CANADIAN SYLLABICS Y-CREE PWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1449':{ u:'1449', i:4554, name:'CANADIAN SYLLABICS P', cat:c.Lo,   canon:k._0, block:b[41], indexed:["P"]},
			'1450':{ u:'1450', i:4561, name:'CANADIAN SYLLABICS TO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1451':{ u:'1451', i:4562, name:'CANADIAN SYLLABICS TOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1452':{ u:'1452', i:4563, name:'CANADIAN SYLLABICS Y-CREE TOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1453':{ u:'1453', i:4564, name:'CANADIAN SYLLABICS CARRIER DEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1454':{ u:'1454', i:4565, name:'CANADIAN SYLLABICS CARRIER DI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1455':{ u:'1455', i:4566, name:'CANADIAN SYLLABICS TA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1456':{ u:'1456', i:4567, name:'CANADIAN SYLLABICS TAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1457':{ u:'1457', i:4568, name:'CANADIAN SYLLABICS TWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1458':{ u:'1458', i:4569, name:'CANADIAN SYLLABICS WEST-CREE TWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1459':{ u:'1459', i:4570, name:'CANADIAN SYLLABICS TWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1460':{ u:'1460', i:4577, name:'CANADIAN SYLLABICS WEST-CREE TWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1461':{ u:'1461', i:4578, name:'CANADIAN SYLLABICS TWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1462':{ u:'1462', i:4579, name:'CANADIAN SYLLABICS WEST-CREE TWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1463':{ u:'1463', i:4580, name:'CANADIAN SYLLABICS TWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1464':{ u:'1464', i:4581, name:'CANADIAN SYLLABICS WEST-CREE TWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1465':{ u:'1465', i:4582, name:'CANADIAN SYLLABICS NASKAPI TWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1466':{ u:'1466', i:4583, name:'CANADIAN SYLLABICS T', cat:c.Lo,   canon:k._0, block:b[41], indexed:["T"]},
			'1467':{ u:'1467', i:4584, name:'CANADIAN SYLLABICS TTE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1468':{ u:'1468', i:4585, name:'CANADIAN SYLLABICS TTI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1469':{ u:'1469', i:4586, name:'CANADIAN SYLLABICS TTO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1470':{ u:'1470', i:4593, name:'CANADIAN SYLLABICS KOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1471':{ u:'1471', i:4594, name:'CANADIAN SYLLABICS Y-CREE KOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1472':{ u:'1472', i:4595, name:'CANADIAN SYLLABICS KA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1473':{ u:'1473', i:4596, name:'CANADIAN SYLLABICS KAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1474':{ u:'1474', i:4597, name:'CANADIAN SYLLABICS KWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1475':{ u:'1475', i:4598, name:'CANADIAN SYLLABICS WEST-CREE KWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1476':{ u:'1476', i:4599, name:'CANADIAN SYLLABICS KWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1477':{ u:'1477', i:4600, name:'CANADIAN SYLLABICS WEST-CREE KWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1478':{ u:'1478', i:4601, name:'CANADIAN SYLLABICS KWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1479':{ u:'1479', i:4602, name:'CANADIAN SYLLABICS WEST-CREE KWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1480':{ u:'1480', i:4609, name:'CANADIAN SYLLABICS KWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1481':{ u:'1481', i:4610, name:'CANADIAN SYLLABICS WEST-CREE KWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1482':{ u:'1482', i:4611, name:'CANADIAN SYLLABICS NASKAPI KWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1483':{ u:'1483', i:4612, name:'CANADIAN SYLLABICS K', cat:c.Lo,   canon:k._0, block:b[41], indexed:["K"]},
			'1484':{ u:'1484', i:4613, name:'CANADIAN SYLLABICS KW', cat:c.Lo,   canon:k._0, block:b[41]},
			'1485':{ u:'1485', i:4614, name:'CANADIAN SYLLABICS SOUTH-SLAVEY KEH', cat:c.Lo,   canon:k._0, block:b[41]},
			'1486':{ u:'1486', i:4615, name:'CANADIAN SYLLABICS SOUTH-SLAVEY KIH', cat:c.Lo,   canon:k._0, block:b[41]},
			'1487':{ u:'1487', i:4616, name:'CANADIAN SYLLABICS SOUTH-SLAVEY KOH', cat:c.Lo,   canon:k._0, block:b[41]},
			'1488':{ u:'1488', i:4617, name:'CANADIAN SYLLABICS SOUTH-SLAVEY KAH', cat:c.Lo,   canon:k._0, block:b[41]},
			'1489':{ u:'1489', i:4618, name:'CANADIAN SYLLABICS CE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1490':{ u:'1490', i:4625, name:'CANADIAN SYLLABICS CA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1491':{ u:'1491', i:4626, name:'CANADIAN SYLLABICS CAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1492':{ u:'1492', i:4627, name:'CANADIAN SYLLABICS CWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1493':{ u:'1493', i:4628, name:'CANADIAN SYLLABICS WEST-CREE CWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1494':{ u:'1494', i:4629, name:'CANADIAN SYLLABICS CWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1495':{ u:'1495', i:4630, name:'CANADIAN SYLLABICS WEST-CREE CWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1496':{ u:'1496', i:4631, name:'CANADIAN SYLLABICS CWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1497':{ u:'1497', i:4632, name:'CANADIAN SYLLABICS WEST-CREE CWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1498':{ u:'1498', i:4633, name:'CANADIAN SYLLABICS CWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1499':{ u:'1499', i:4634, name:'CANADIAN SYLLABICS WEST-CREE CWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1500':{ u:'1500', i:4737, name:'CANADIAN SYLLABICS SWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1501':{ u:'1501', i:4738, name:'CANADIAN SYLLABICS WEST-CREE SWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1502':{ u:'1502', i:4739, name:'CANADIAN SYLLABICS SWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1503':{ u:'1503', i:4740, name:'CANADIAN SYLLABICS WEST-CREE SWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1504':{ u:'1504', i:4741, name:'CANADIAN SYLLABICS NASKAPI SWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1505':{ u:'1505', i:4742, name:'CANADIAN SYLLABICS S', cat:c.Lo,   canon:k._0, block:b[41], indexed:["S"]},
			'1506':{ u:'1506', i:4743, name:'CANADIAN SYLLABICS ATHAPASCAN S', cat:c.Lo,   canon:k._0, block:b[41], indexed:["S"]},
			'1507':{ u:'1507', i:4744, name:'CANADIAN SYLLABICS SW', cat:c.Lo,   canon:k._0, block:b[41]},
			'1508':{ u:'1508', i:4745, name:'CANADIAN SYLLABICS BLACKFOOT S', cat:c.Lo,   canon:k._0, block:b[41], indexed:["S"]},
			'1509':{ u:'1509', i:4746, name:'CANADIAN SYLLABICS MOOSE-CREE SK', cat:c.Lo,   canon:k._0, block:b[41]},
			'1510':{ u:'1510', i:4753, name:'CANADIAN SYLLABICS SHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1511':{ u:'1511', i:4754, name:'CANADIAN SYLLABICS SHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1512':{ u:'1512', i:4755, name:'CANADIAN SYLLABICS SHII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1513':{ u:'1513', i:4756, name:'CANADIAN SYLLABICS SHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1514':{ u:'1514', i:4757, name:'CANADIAN SYLLABICS SHOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1515':{ u:'1515', i:4758, name:'CANADIAN SYLLABICS SHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1516':{ u:'1516', i:4759, name:'CANADIAN SYLLABICS SHAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1517':{ u:'1517', i:4760, name:'CANADIAN SYLLABICS SHWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1518':{ u:'1518', i:4761, name:'CANADIAN SYLLABICS WEST-CREE SHWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1519':{ u:'1519', i:4762, name:'CANADIAN SYLLABICS SHWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1520':{ u:'1520', i:4769, name:'CANADIAN SYLLABICS WEST-CREE SHWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1521':{ u:'1521', i:4770, name:'CANADIAN SYLLABICS SHWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1522':{ u:'1522', i:4771, name:'CANADIAN SYLLABICS WEST-CREE SHWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1523':{ u:'1523', i:4772, name:'CANADIAN SYLLABICS SHWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1524':{ u:'1524', i:4773, name:'CANADIAN SYLLABICS WEST-CREE SHWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1525':{ u:'1525', i:4774, name:'CANADIAN SYLLABICS SH', cat:c.Lo,   canon:k._0, block:b[41]},
			'1526':{ u:'1526', i:4775, name:'CANADIAN SYLLABICS YE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1527':{ u:'1527', i:4776, name:'CANADIAN SYLLABICS YAAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1528':{ u:'1528', i:4777, name:'CANADIAN SYLLABICS YI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1529':{ u:'1529', i:4778, name:'CANADIAN SYLLABICS YII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1530':{ u:'1530', i:4785, name:'CANADIAN SYLLABICS WEST-CREE YWE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1531':{ u:'1531', i:4786, name:'CANADIAN SYLLABICS YWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1532':{ u:'1532', i:4787, name:'CANADIAN SYLLABICS WEST-CREE YWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1533':{ u:'1533', i:4788, name:'CANADIAN SYLLABICS YWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1534':{ u:'1534', i:4789, name:'CANADIAN SYLLABICS WEST-CREE YWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1535':{ u:'1535', i:4790, name:'CANADIAN SYLLABICS YWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1536':{ u:'1536', i:4791, name:'CANADIAN SYLLABICS WEST-CREE YWO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1537':{ u:'1537', i:4792, name:'CANADIAN SYLLABICS YWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1538':{ u:'1538', i:4793, name:'CANADIAN SYLLABICS WEST-CREE YWOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1539':{ u:'1539', i:4794, name:'CANADIAN SYLLABICS YWA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1540':{ u:'1540', i:4801, name:'CANADIAN SYLLABICS WEST-CREE Y', cat:c.Lo,   canon:k._0, block:b[41], indexed:["Y"]},
			'1541':{ u:'1541', i:4802, name:'CANADIAN SYLLABICS SAYISI YI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1542':{ u:'1542', i:4803, name:'CANADIAN SYLLABICS RE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1543':{ u:'1543', i:4804, name:'CANADIAN SYLLABICS R-CREE RE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1544':{ u:'1544', i:4805, name:'CANADIAN SYLLABICS WEST-CREE LE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1545':{ u:'1545', i:4806, name:'CANADIAN SYLLABICS RAAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1546':{ u:'1546', i:4807, name:'CANADIAN SYLLABICS RI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1547':{ u:'1547', i:4808, name:'CANADIAN SYLLABICS RII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1548':{ u:'1548', i:4809, name:'CANADIAN SYLLABICS RO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1549':{ u:'1549', i:4810, name:'CANADIAN SYLLABICS ROO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1550':{ u:'1550', i:4817, name:'CANADIAN SYLLABICS R', cat:c.Lo,   canon:k._0, block:b[41], indexed:["R"]},
			'1551':{ u:'1551', i:4818, name:'CANADIAN SYLLABICS WEST-CREE R', cat:c.Lo,   canon:k._0, block:b[41], indexed:["R"]},
			'1552':{ u:'1552', i:4819, name:'CANADIAN SYLLABICS MEDIAL R', cat:c.Lo,   canon:k._0, block:b[41], indexed:["R"]},
			'1553':{ u:'1553', i:4820, name:'CANADIAN SYLLABICS FE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1554':{ u:'1554', i:4821, name:'CANADIAN SYLLABICS FAAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1555':{ u:'1555', i:4822, name:'CANADIAN SYLLABICS FI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1556':{ u:'1556', i:4823, name:'CANADIAN SYLLABICS FII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1557':{ u:'1557', i:4824, name:'CANADIAN SYLLABICS FO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1558':{ u:'1558', i:4825, name:'CANADIAN SYLLABICS FOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1559':{ u:'1559', i:4826, name:'CANADIAN SYLLABICS FA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1560':{ u:'1560', i:4833, name:'CANADIAN SYLLABICS THI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1561':{ u:'1561', i:4834, name:'CANADIAN SYLLABICS N-CREE THI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1562':{ u:'1562', i:4835, name:'CANADIAN SYLLABICS THII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1563':{ u:'1563', i:4836, name:'CANADIAN SYLLABICS N-CREE THII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1564':{ u:'1564', i:4837, name:'CANADIAN SYLLABICS THO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1565':{ u:'1565', i:4838, name:'CANADIAN SYLLABICS THOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1566':{ u:'1566', i:4839, name:'CANADIAN SYLLABICS THA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1567':{ u:'1567', i:4840, name:'CANADIAN SYLLABICS THAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1568':{ u:'1568', i:4841, name:'CANADIAN SYLLABICS THWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1569':{ u:'1569', i:4842, name:'CANADIAN SYLLABICS WEST-CREE THWAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1570':{ u:'1570', i:4849, name:'CANADIAN SYLLABICS TYE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1571':{ u:'1571', i:4850, name:'CANADIAN SYLLABICS TYI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1572':{ u:'1572', i:4851, name:'CANADIAN SYLLABICS TYO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1573':{ u:'1573', i:4852, name:'CANADIAN SYLLABICS TYA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1574':{ u:'1574', i:4853, name:'CANADIAN SYLLABICS NUNAVIK HE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1575':{ u:'1575', i:4854, name:'CANADIAN SYLLABICS NUNAVIK HI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1576':{ u:'1576', i:4855, name:'CANADIAN SYLLABICS NUNAVIK HII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1577':{ u:'1577', i:4856, name:'CANADIAN SYLLABICS NUNAVIK HO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1578':{ u:'1578', i:4857, name:'CANADIAN SYLLABICS NUNAVIK HOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1579':{ u:'1579', i:4858, name:'CANADIAN SYLLABICS NUNAVIK HA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1580':{ u:'1580', i:4865, name:'CANADIAN SYLLABICS QII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1581':{ u:'1581', i:4866, name:'CANADIAN SYLLABICS QO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1582':{ u:'1582', i:4867, name:'CANADIAN SYLLABICS QOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1583':{ u:'1583', i:4868, name:'CANADIAN SYLLABICS QA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1584':{ u:'1584', i:4869, name:'CANADIAN SYLLABICS QAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1585':{ u:'1585', i:4870, name:'CANADIAN SYLLABICS Q', cat:c.Lo,   canon:k._0, block:b[41], indexed:["Q"]},
			'1586':{ u:'1586', i:4871, name:'CANADIAN SYLLABICS TLHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1587':{ u:'1587', i:4872, name:'CANADIAN SYLLABICS TLHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1588':{ u:'1588', i:4873, name:'CANADIAN SYLLABICS TLHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1589':{ u:'1589', i:4874, name:'CANADIAN SYLLABICS TLHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1590':{ u:'1590', i:4881, name:'CANADIAN SYLLABICS NGII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1591':{ u:'1591', i:4882, name:'CANADIAN SYLLABICS NGO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1592':{ u:'1592', i:4883, name:'CANADIAN SYLLABICS NGOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1593':{ u:'1593', i:4884, name:'CANADIAN SYLLABICS NGA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1594':{ u:'1594', i:4885, name:'CANADIAN SYLLABICS NGAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1595':{ u:'1595', i:4886, name:'CANADIAN SYLLABICS NG', cat:c.Lo,   canon:k._0, block:b[41]},
			'1596':{ u:'1596', i:4887, name:'CANADIAN SYLLABICS NNG', cat:c.Lo,   canon:k._0, block:b[41]},
			'1597':{ u:'1597', i:4888, name:'CANADIAN SYLLABICS SAYISI SHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1598':{ u:'1598', i:4889, name:'CANADIAN SYLLABICS SAYISI SHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1599':{ u:'1599', i:4890, name:'CANADIAN SYLLABICS SAYISI SHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1600':{ u:'1600', i:4993, name:'CANADIAN SYLLABICS CARRIER KKA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1601':{ u:'1601', i:4994, name:'CANADIAN SYLLABICS CARRIER KK', cat:c.Lo,   canon:k._0, block:b[41]},
			'1602':{ u:'1602', i:4995, name:'CANADIAN SYLLABICS CARRIER NU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1603':{ u:'1603', i:4996, name:'CANADIAN SYLLABICS CARRIER NO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1604':{ u:'1604', i:4997, name:'CANADIAN SYLLABICS CARRIER NE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1605':{ u:'1605', i:4998, name:'CANADIAN SYLLABICS CARRIER NEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1606':{ u:'1606', i:4999, name:'CANADIAN SYLLABICS CARRIER NI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1607':{ u:'1607', i:5000, name:'CANADIAN SYLLABICS CARRIER NA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1608':{ u:'1608', i:5001, name:'CANADIAN SYLLABICS CARRIER MU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1609':{ u:'1609', i:5002, name:'CANADIAN SYLLABICS CARRIER MO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1610':{ u:'1610', i:5009, name:'CANADIAN SYLLABICS CARRIER YE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1611':{ u:'1611', i:5010, name:'CANADIAN SYLLABICS CARRIER YEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1612':{ u:'1612', i:5011, name:'CANADIAN SYLLABICS CARRIER YI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1613':{ u:'1613', i:5012, name:'CANADIAN SYLLABICS CARRIER YA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1614':{ u:'1614', i:5013, name:'CANADIAN SYLLABICS CARRIER JU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1615':{ u:'1615', i:5014, name:'CANADIAN SYLLABICS SAYISI JU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1616':{ u:'1616', i:5015, name:'CANADIAN SYLLABICS CARRIER JO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1617':{ u:'1617', i:5016, name:'CANADIAN SYLLABICS CARRIER JE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1618':{ u:'1618', i:5017, name:'CANADIAN SYLLABICS CARRIER JEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1619':{ u:'1619', i:5018, name:'CANADIAN SYLLABICS CARRIER JI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1620':{ u:'1620', i:5025, name:'CANADIAN SYLLABICS CARRIER JJI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1621':{ u:'1621', i:5026, name:'CANADIAN SYLLABICS CARRIER JJA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1622':{ u:'1622', i:5027, name:'CANADIAN SYLLABICS CARRIER LU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1623':{ u:'1623', i:5028, name:'CANADIAN SYLLABICS CARRIER LO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1624':{ u:'1624', i:5029, name:'CANADIAN SYLLABICS CARRIER LE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1625':{ u:'1625', i:5030, name:'CANADIAN SYLLABICS CARRIER LEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1626':{ u:'1626', i:5031, name:'CANADIAN SYLLABICS CARRIER LI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1627':{ u:'1627', i:5032, name:'CANADIAN SYLLABICS CARRIER LA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1628':{ u:'1628', i:5033, name:'CANADIAN SYLLABICS CARRIER DLU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1629':{ u:'1629', i:5034, name:'CANADIAN SYLLABICS CARRIER DLO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1630':{ u:'1630', i:5041, name:'CANADIAN SYLLABICS CARRIER LHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1631':{ u:'1631', i:5042, name:'CANADIAN SYLLABICS CARRIER LHEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1632':{ u:'1632', i:5043, name:'CANADIAN SYLLABICS CARRIER LHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1633':{ u:'1633', i:5044, name:'CANADIAN SYLLABICS CARRIER LHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1634':{ u:'1634', i:5045, name:'CANADIAN SYLLABICS CARRIER TLHU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1635':{ u:'1635', i:5046, name:'CANADIAN SYLLABICS CARRIER TLHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1636':{ u:'1636', i:5047, name:'CANADIAN SYLLABICS CARRIER TLHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1637':{ u:'1637', i:5048, name:'CANADIAN SYLLABICS CARRIER TLHEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1638':{ u:'1638', i:5049, name:'CANADIAN SYLLABICS CARRIER TLHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1639':{ u:'1639', i:5050, name:'CANADIAN SYLLABICS CARRIER TLHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1640':{ u:'1640', i:5057, name:'CANADIAN SYLLABICS CARRIER ZU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1641':{ u:'1641', i:5058, name:'CANADIAN SYLLABICS CARRIER ZO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1642':{ u:'1642', i:5059, name:'CANADIAN SYLLABICS CARRIER ZE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1643':{ u:'1643', i:5060, name:'CANADIAN SYLLABICS CARRIER ZEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1644':{ u:'1644', i:5061, name:'CANADIAN SYLLABICS CARRIER ZI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1645':{ u:'1645', i:5062, name:'CANADIAN SYLLABICS CARRIER ZA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1646':{ u:'1646', i:5063, name:'CANADIAN SYLLABICS CARRIER Z', cat:c.Lo,   canon:k._0, block:b[41], indexed:["Z"]},
			'1647':{ u:'1647', i:5064, name:'CANADIAN SYLLABICS CARRIER INITIAL Z', cat:c.Lo,   canon:k._0, block:b[41], indexed:["Z"]},
			'1648':{ u:'1648', i:5065, name:'CANADIAN SYLLABICS CARRIER DZU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1649':{ u:'1649', i:5066, name:'CANADIAN SYLLABICS CARRIER DZO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1650':{ u:'1650', i:5073, name:'CANADIAN SYLLABICS CARRIER SE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1651':{ u:'1651', i:5074, name:'CANADIAN SYLLABICS CARRIER SEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1652':{ u:'1652', i:5075, name:'CANADIAN SYLLABICS CARRIER SI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1653':{ u:'1653', i:5076, name:'CANADIAN SYLLABICS CARRIER SA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1654':{ u:'1654', i:5077, name:'CANADIAN SYLLABICS CARRIER SHU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1655':{ u:'1655', i:5078, name:'CANADIAN SYLLABICS CARRIER SHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1656':{ u:'1656', i:5079, name:'CANADIAN SYLLABICS CARRIER SHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1657':{ u:'1657', i:5080, name:'CANADIAN SYLLABICS CARRIER SHEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1658':{ u:'1658', i:5081, name:'CANADIAN SYLLABICS CARRIER SHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1659':{ u:'1659', i:5082, name:'CANADIAN SYLLABICS CARRIER SHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1660':{ u:'1660', i:5089, name:'CANADIAN SYLLABICS CARRIER TSA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1661':{ u:'1661', i:5090, name:'CANADIAN SYLLABICS CARRIER CHU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1662':{ u:'1662', i:5091, name:'CANADIAN SYLLABICS CARRIER CHO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1663':{ u:'1663', i:5092, name:'CANADIAN SYLLABICS CARRIER CHE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1664':{ u:'1664', i:5093, name:'CANADIAN SYLLABICS CARRIER CHEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1665':{ u:'1665', i:5094, name:'CANADIAN SYLLABICS CARRIER CHI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1666':{ u:'1666', i:5095, name:'CANADIAN SYLLABICS CARRIER CHA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1667':{ u:'1667', i:5096, name:'CANADIAN SYLLABICS CARRIER TTSU', cat:c.Lo,   canon:k._0, block:b[41]},
			'1668':{ u:'1668', i:5097, name:'CANADIAN SYLLABICS CARRIER TTSO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1669':{ u:'1669', i:5098, name:'CANADIAN SYLLABICS CARRIER TTSE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1670':{ u:'1670', i:5105, name:'CANADIAN SYLLABICS NGAI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1671':{ u:'1671', i:5106, name:'CANADIAN SYLLABICS NNGI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1672':{ u:'1672', i:5107, name:'CANADIAN SYLLABICS NNGII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1673':{ u:'1673', i:5108, name:'CANADIAN SYLLABICS NNGO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1674':{ u:'1674', i:5109, name:'CANADIAN SYLLABICS NNGOO', cat:c.Lo,   canon:k._0, block:b[41]},
			'1675':{ u:'1675', i:5110, name:'CANADIAN SYLLABICS NNGA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1676':{ u:'1676', i:5111, name:'CANADIAN SYLLABICS NNGAA', cat:c.Lo,   canon:k._0, block:b[41]},
			'1677':{ u:'1677', i:5112, name:'CANADIAN SYLLABICS WOODS-CREE THWEE', cat:c.Lo,   canon:k._0, block:b[41]},
			'1678':{ u:'1678', i:5113, name:'CANADIAN SYLLABICS WOODS-CREE THWI', cat:c.Lo,   canon:k._0, block:b[41]},
			'1679':{ u:'1679', i:5114, name:'CANADIAN SYLLABICS WOODS-CREE THWII', cat:c.Lo,   canon:k._0, block:b[41]},
			'1680':{ u:'1680', i:5121, name:'OGHAM SPACE MARK', cat:c.Zs,   canon:k._0, block:b[42]},
			'1681':{ u:'1681', i:5122, name:'OGHAM LETTER BEITH', cat:c.Lo,   canon:k._0, block:b[42]},
			'1682':{ u:'1682', i:5123, name:'OGHAM LETTER LUIS', cat:c.Lo,   canon:k._0, block:b[42]},
			'1683':{ u:'1683', i:5124, name:'OGHAM LETTER FEARN', cat:c.Lo,   canon:k._0, block:b[42]},
			'1684':{ u:'1684', i:5125, name:'OGHAM LETTER SAIL', cat:c.Lo,   canon:k._0, block:b[42]},
			'1685':{ u:'1685', i:5126, name:'OGHAM LETTER NION', cat:c.Lo,   canon:k._0, block:b[42]},
			'1686':{ u:'1686', i:5127, name:'OGHAM LETTER UATH', cat:c.Lo,   canon:k._0, block:b[42]},
			'1687':{ u:'1687', i:5128, name:'OGHAM LETTER DAIR', cat:c.Lo,   canon:k._0, block:b[42]},
			'1688':{ u:'1688', i:5129, name:'OGHAM LETTER TINNE', cat:c.Lo,   canon:k._0, block:b[42]},
			'1689':{ u:'1689', i:5130, name:'OGHAM LETTER COLL', cat:c.Lo,   canon:k._0, block:b[42]},
			'1690':{ u:'1690', i:5137, name:'OGHAM LETTER AILM', cat:c.Lo,   canon:k._0, block:b[42]},
			'1691':{ u:'1691', i:5138, name:'OGHAM LETTER ONN', cat:c.Lo,   canon:k._0, block:b[42]},
			'1692':{ u:'1692', i:5139, name:'OGHAM LETTER UR', cat:c.Lo,   canon:k._0, block:b[42]},
			'1693':{ u:'1693', i:5140, name:'OGHAM LETTER EADHADH', cat:c.Lo,   canon:k._0, block:b[42]},
			'1694':{ u:'1694', i:5141, name:'OGHAM LETTER IODHADH', cat:c.Lo,   canon:k._0, block:b[42]},
			'1695':{ u:'1695', i:5142, name:'OGHAM LETTER EABHADH', cat:c.Lo,   canon:k._0, block:b[42]},
			'1696':{ u:'1696', i:5143, name:'OGHAM LETTER OR', cat:c.Lo,   canon:k._0, block:b[42]},
			'1697':{ u:'1697', i:5144, name:'OGHAM LETTER UILLEANN', cat:c.Lo,   canon:k._0, block:b[42]},
			'1698':{ u:'1698', i:5145, name:'OGHAM LETTER IFIN', cat:c.Lo,   canon:k._0, block:b[42]},
			'1699':{ u:'1699', i:5146, name:'OGHAM LETTER EAMHANCHOLL', cat:c.Lo,   canon:k._0, block:b[42]},
			'1700':{ u:'1700', i:5239, name:'TAGALOG LETTER A', cat:c.Lo,   canon:k._0, block:b[44], indexed:["A"]},
			'1701':{ u:'1701', i:5240, name:'TAGALOG LETTER I', cat:c.Lo,   canon:k._0, block:b[44], indexed:["I"]},
			'1702':{ u:'1702', i:5241, name:'TAGALOG LETTER U', cat:c.Lo,   canon:k._0, block:b[44], indexed:["U"]},
			'1703':{ u:'1703', i:5242, name:'TAGALOG LETTER KA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1704':{ u:'1704', i:5243, name:'TAGALOG LETTER GA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1705':{ u:'1705', i:5244, name:'TAGALOG LETTER NGA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1706':{ u:'1706', i:5245, name:'TAGALOG LETTER TA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1707':{ u:'1707', i:5246, name:'TAGALOG LETTER DA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1708':{ u:'1708', i:5247, name:'TAGALOG LETTER NA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1709':{ u:'1709', i:5248, name:'TAGALOG LETTER PA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1710':{ u:'1710', i:5255, name:'TAGALOG LETTER SA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1711':{ u:'1711', i:5256, name:'TAGALOG LETTER HA', cat:c.Lo,   canon:k._0, block:b[44]},
			'1712':{ u:'1712', i:5257, name:'TAGALOG VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[44], indexed:["I"]},
			'1713':{ u:'1713', i:5258, name:'TAGALOG VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[44], indexed:["U"]},
			'1714':{ u:'1714', i:5259, name:'TAGALOG SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[44]},
			'1715':{ u:'1715', i:5260, name:'TAGALOG SIGN PAMUDPOD', cat:c.Mc,   canon:k._9, block:b[44]},
			'1720':{ u:'1720', i:5262, name:'HANUNOO LETTER A', cat:c.Lo,   canon:k._0, block:b[45], indexed:["A"]},
			'1721':{ u:'1721', i:5263, name:'HANUNOO LETTER I', cat:c.Lo,   canon:k._0, block:b[45], indexed:["I"]},
			'1722':{ u:'1722', i:5264, name:'HANUNOO LETTER U', cat:c.Lo,   canon:k._0, block:b[45], indexed:["U"]},
			'1723':{ u:'1723', i:5265, name:'HANUNOO LETTER KA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1724':{ u:'1724', i:5266, name:'HANUNOO LETTER GA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1725':{ u:'1725', i:5267, name:'HANUNOO LETTER NGA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1726':{ u:'1726', i:5268, name:'HANUNOO LETTER TA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1727':{ u:'1727', i:5269, name:'HANUNOO LETTER DA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1728':{ u:'1728', i:5270, name:'HANUNOO LETTER NA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1729':{ u:'1729', i:5271, name:'HANUNOO LETTER PA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1730':{ u:'1730', i:5278, name:'HANUNOO LETTER SA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1731':{ u:'1731', i:5279, name:'HANUNOO LETTER HA', cat:c.Lo,   canon:k._0, block:b[45]},
			'1732':{ u:'1732', i:5280, name:'HANUNOO VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[45], indexed:["I"]},
			'1733':{ u:'1733', i:5281, name:'HANUNOO VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[45], indexed:["U"]},
			'1734':{ u:'1734', i:5282, name:'HANUNOO SIGN PAMUDPOD', cat:c.Mc,   canon:k._9, block:b[45]},
			'1735':{ u:'1735', i:5283, name:'PHILIPPINE SINGLE PUNCTUATION', cat:c.Po,   canon:k._0, block:b[45]},
			'1736':{ u:'1736', i:5284, name:'PHILIPPINE DOUBLE PUNCTUATION', cat:c.Po,   canon:k._0, block:b[45]},
			'1740':{ u:'1740', i:5285, name:'BUHID LETTER A', cat:c.Lo,   canon:k._0, block:b[46], indexed:["A"]},
			'1741':{ u:'1741', i:5286, name:'BUHID LETTER I', cat:c.Lo,   canon:k._0, block:b[46], indexed:["I"]},
			'1742':{ u:'1742', i:5287, name:'BUHID LETTER U', cat:c.Lo,   canon:k._0, block:b[46], indexed:["U"]},
			'1743':{ u:'1743', i:5288, name:'BUHID LETTER KA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1744':{ u:'1744', i:5289, name:'BUHID LETTER GA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1745':{ u:'1745', i:5290, name:'BUHID LETTER NGA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1746':{ u:'1746', i:5291, name:'BUHID LETTER TA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1747':{ u:'1747', i:5292, name:'BUHID LETTER DA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1748':{ u:'1748', i:5293, name:'BUHID LETTER NA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1749':{ u:'1749', i:5294, name:'BUHID LETTER PA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1750':{ u:'1750', i:5301, name:'BUHID LETTER SA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1751':{ u:'1751', i:5302, name:'BUHID LETTER HA', cat:c.Lo,   canon:k._0, block:b[46]},
			'1752':{ u:'1752', i:5303, name:'BUHID VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[46], indexed:["I"]},
			'1753':{ u:'1753', i:5304, name:'BUHID VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[46], indexed:["U"]},
			'1760':{ u:'1760', i:5305, name:'TAGBANWA LETTER A', cat:c.Lo,   canon:k._0, block:b[47], indexed:["A"]},
			'1761':{ u:'1761', i:5306, name:'TAGBANWA LETTER I', cat:c.Lo,   canon:k._0, block:b[47], indexed:["I"]},
			'1762':{ u:'1762', i:5307, name:'TAGBANWA LETTER U', cat:c.Lo,   canon:k._0, block:b[47], indexed:["U"]},
			'1763':{ u:'1763', i:5308, name:'TAGBANWA LETTER KA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1764':{ u:'1764', i:5309, name:'TAGBANWA LETTER GA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1765':{ u:'1765', i:5310, name:'TAGBANWA LETTER NGA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1766':{ u:'1766', i:5311, name:'TAGBANWA LETTER TA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1767':{ u:'1767', i:5312, name:'TAGBANWA LETTER DA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1768':{ u:'1768', i:5313, name:'TAGBANWA LETTER NA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1769':{ u:'1769', i:5314, name:'TAGBANWA LETTER PA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1770':{ u:'1770', i:5320, name:'TAGBANWA LETTER SA', cat:c.Lo,   canon:k._0, block:b[47]},
			'1772':{ u:'1772', i:5321, name:'TAGBANWA VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[47], indexed:["I"]},
			'1773':{ u:'1773', i:5322, name:'TAGBANWA VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[47], indexed:["U"]},
			'1780':{ u:'1780', i:5323, name:'KHMER LETTER KA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1781':{ u:'1781', i:5324, name:'KHMER LETTER KHA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1782':{ u:'1782', i:5325, name:'KHMER LETTER KO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1783':{ u:'1783', i:5326, name:'KHMER LETTER KHO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1784':{ u:'1784', i:5327, name:'KHMER LETTER NGO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1785':{ u:'1785', i:5328, name:'KHMER LETTER CA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1786':{ u:'1786', i:5329, name:'KHMER LETTER CHA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1787':{ u:'1787', i:5330, name:'KHMER LETTER CO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1788':{ u:'1788', i:5331, name:'KHMER LETTER CHO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1789':{ u:'1789', i:5332, name:'KHMER LETTER NYO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1790':{ u:'1790', i:5339, name:'KHMER LETTER THA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1791':{ u:'1791', i:5340, name:'KHMER LETTER TO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1792':{ u:'1792', i:5341, name:'KHMER LETTER THO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1793':{ u:'1793', i:5342, name:'KHMER LETTER NO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1794':{ u:'1794', i:5343, name:'KHMER LETTER BA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1795':{ u:'1795', i:5344, name:'KHMER LETTER PHA', cat:c.Lo,   canon:k._0, block:b[48]},
			'1796':{ u:'1796', i:5345, name:'KHMER LETTER PO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1797':{ u:'1797', i:5346, name:'KHMER LETTER PHO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1798':{ u:'1798', i:5347, name:'KHMER LETTER MO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1799':{ u:'1799', i:5348, name:'KHMER LETTER YO', cat:c.Lo,   canon:k._0, block:b[48]},
			'1800':{ u:'1800', i:5437, name:'MONGOLIAN BIRGA', cat:c.Po,   canon:k._0, block:b[49]},
			'1801':{ u:'1801', i:5438, name:'MONGOLIAN ELLIPSIS', cat:c.Po,   canon:k._0, block:b[49]},
			'1802':{ u:'1802', i:5439, name:'MONGOLIAN COMMA', cat:c.Po,   canon:k._0, block:b[49]},
			'1803':{ u:'1803', i:5440, name:'MONGOLIAN FULL STOP', cat:c.Po,   canon:k._0, block:b[49]},
			'1804':{ u:'1804', i:5441, name:'MONGOLIAN COLON', cat:c.Po,   canon:k._0, block:b[49]},
			'1805':{ u:'1805', i:5442, name:'MONGOLIAN FOUR DOTS', cat:c.Po,   canon:k._0, block:b[49]},
			'1806':{ u:'1806', i:5443, name:'MONGOLIAN TODO SOFT HYPHEN', cat:c.Pd,   canon:k._0, block:b[49]},
			'1807':{ u:'1807', i:5444, name:'MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER', cat:c.Po,   canon:k._0, block:b[49]},
			'1808':{ u:'1808', i:5445, name:'MONGOLIAN MANCHU COMMA', cat:c.Po,   canon:k._0, block:b[49]},
			'1809':{ u:'1809', i:5446, name:'MONGOLIAN MANCHU FULL STOP', cat:c.Po,   canon:k._0, block:b[49]},
			'1810':{ u:'1810', i:5453, name:'MONGOLIAN DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[49]},
			'1811':{ u:'1811', i:5454, name:'MONGOLIAN DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[49]},
			'1812':{ u:'1812', i:5455, name:'MONGOLIAN DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[49]},
			'1813':{ u:'1813', i:5456, name:'MONGOLIAN DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[49]},
			'1814':{ u:'1814', i:5457, name:'MONGOLIAN DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[49]},
			'1815':{ u:'1815', i:5458, name:'MONGOLIAN DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[49]},
			'1816':{ u:'1816', i:5459, name:'MONGOLIAN DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[49]},
			'1817':{ u:'1817', i:5460, name:'MONGOLIAN DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[49]},
			'1818':{ u:'1818', i:5461, name:'MONGOLIAN DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[49]},
			'1819':{ u:'1819', i:5462, name:'MONGOLIAN DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[49]},
			'1820':{ u:'1820', i:5463, name:'MONGOLIAN LETTER A', cat:c.Lo,   canon:k._0, block:b[49], indexed:["A"]},
			'1821':{ u:'1821', i:5464, name:'MONGOLIAN LETTER E', cat:c.Lo,   canon:k._0, block:b[49], indexed:["E"]},
			'1822':{ u:'1822', i:5465, name:'MONGOLIAN LETTER I', cat:c.Lo,   canon:k._0, block:b[49], indexed:["I"]},
			'1823':{ u:'1823', i:5466, name:'MONGOLIAN LETTER O', cat:c.Lo,   canon:k._0, block:b[49], indexed:["O"]},
			'1824':{ u:'1824', i:5467, name:'MONGOLIAN LETTER U', cat:c.Lo,   canon:k._0, block:b[49], indexed:["U"]},
			'1825':{ u:'1825', i:5468, name:'MONGOLIAN LETTER OE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1826':{ u:'1826', i:5469, name:'MONGOLIAN LETTER UE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1827':{ u:'1827', i:5470, name:'MONGOLIAN LETTER EE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1828':{ u:'1828', i:5471, name:'MONGOLIAN LETTER NA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1829':{ u:'1829', i:5472, name:'MONGOLIAN LETTER ANG', cat:c.Lo,   canon:k._0, block:b[49]},
			'1830':{ u:'1830', i:5479, name:'MONGOLIAN LETTER SA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1831':{ u:'1831', i:5480, name:'MONGOLIAN LETTER SHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1832':{ u:'1832', i:5481, name:'MONGOLIAN LETTER TA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1833':{ u:'1833', i:5482, name:'MONGOLIAN LETTER DA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1834':{ u:'1834', i:5483, name:'MONGOLIAN LETTER CHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1835':{ u:'1835', i:5484, name:'MONGOLIAN LETTER JA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1836':{ u:'1836', i:5485, name:'MONGOLIAN LETTER YA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1837':{ u:'1837', i:5486, name:'MONGOLIAN LETTER RA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1838':{ u:'1838', i:5487, name:'MONGOLIAN LETTER WA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1839':{ u:'1839', i:5488, name:'MONGOLIAN LETTER FA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1840':{ u:'1840', i:5495, name:'MONGOLIAN LETTER LHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1841':{ u:'1841', i:5496, name:'MONGOLIAN LETTER ZHI', cat:c.Lo,   canon:k._0, block:b[49]},
			'1842':{ u:'1842', i:5497, name:'MONGOLIAN LETTER CHI', cat:c.Lo,   canon:k._0, block:b[49]},
			'1843':{ u:'1843', i:5498, name:'MONGOLIAN LETTER TODO LONG VOWEL SIGN', cat:c.Lm,   canon:k._0, block:b[49]},
			'1844':{ u:'1844', i:5499, name:'MONGOLIAN LETTER TODO E', cat:c.Lo,   canon:k._0, block:b[49], indexed:["E"]},
			'1845':{ u:'1845', i:5500, name:'MONGOLIAN LETTER TODO I', cat:c.Lo,   canon:k._0, block:b[49], indexed:["I"]},
			'1846':{ u:'1846', i:5501, name:'MONGOLIAN LETTER TODO O', cat:c.Lo,   canon:k._0, block:b[49], indexed:["O"]},
			'1847':{ u:'1847', i:5502, name:'MONGOLIAN LETTER TODO U', cat:c.Lo,   canon:k._0, block:b[49], indexed:["U"]},
			'1848':{ u:'1848', i:5503, name:'MONGOLIAN LETTER TODO OE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1849':{ u:'1849', i:5504, name:'MONGOLIAN LETTER TODO UE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1850':{ u:'1850', i:5511, name:'MONGOLIAN LETTER TODO TA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1851':{ u:'1851', i:5512, name:'MONGOLIAN LETTER TODO DA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1852':{ u:'1852', i:5513, name:'MONGOLIAN LETTER TODO CHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1853':{ u:'1853', i:5514, name:'MONGOLIAN LETTER TODO JA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1854':{ u:'1854', i:5515, name:'MONGOLIAN LETTER TODO TSA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1855':{ u:'1855', i:5516, name:'MONGOLIAN LETTER TODO YA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1856':{ u:'1856', i:5517, name:'MONGOLIAN LETTER TODO WA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1857':{ u:'1857', i:5518, name:'MONGOLIAN LETTER TODO KA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1858':{ u:'1858', i:5519, name:'MONGOLIAN LETTER TODO GAA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1859':{ u:'1859', i:5520, name:'MONGOLIAN LETTER TODO HAA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1860':{ u:'1860', i:5527, name:'MONGOLIAN LETTER SIBE UE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1861':{ u:'1861', i:5528, name:'MONGOLIAN LETTER SIBE U', cat:c.Lo,   canon:k._0, block:b[49], indexed:["U"]},
			'1862':{ u:'1862', i:5529, name:'MONGOLIAN LETTER SIBE ANG', cat:c.Lo,   canon:k._0, block:b[49]},
			'1863':{ u:'1863', i:5530, name:'MONGOLIAN LETTER SIBE KA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1864':{ u:'1864', i:5531, name:'MONGOLIAN LETTER SIBE GA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1865':{ u:'1865', i:5532, name:'MONGOLIAN LETTER SIBE HA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1866':{ u:'1866', i:5533, name:'MONGOLIAN LETTER SIBE PA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1867':{ u:'1867', i:5534, name:'MONGOLIAN LETTER SIBE SHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1868':{ u:'1868', i:5535, name:'MONGOLIAN LETTER SIBE TA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1869':{ u:'1869', i:5536, name:'MONGOLIAN LETTER SIBE DA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1870':{ u:'1870', i:5543, name:'MONGOLIAN LETTER SIBE RAA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1871':{ u:'1871', i:5544, name:'MONGOLIAN LETTER SIBE CHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1872':{ u:'1872', i:5545, name:'MONGOLIAN LETTER SIBE ZHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1873':{ u:'1873', i:5546, name:'MONGOLIAN LETTER MANCHU I', cat:c.Lo,   canon:k._0, block:b[49], indexed:["I"]},
			'1874':{ u:'1874', i:5547, name:'MONGOLIAN LETTER MANCHU KA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1875':{ u:'1875', i:5548, name:'MONGOLIAN LETTER MANCHU RA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1876':{ u:'1876', i:5549, name:'MONGOLIAN LETTER MANCHU FA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1877':{ u:'1877', i:5550, name:'MONGOLIAN LETTER MANCHU ZHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1878':{ u:'1878', i:5551, name:'MONGOLIAN LETTER CHA WITH TWO DOTS', cat:c.Lo,   canon:k._0, block:b[49]},
			'1880':{ u:'1880', i:5552, name:'MONGOLIAN LETTER ALI GALI ANUSVARA ONE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1881':{ u:'1881', i:5553, name:'MONGOLIAN LETTER ALI GALI VISARGA ONE', cat:c.Lo,   canon:k._0, block:b[49]},
			'1882':{ u:'1882', i:5554, name:'MONGOLIAN LETTER ALI GALI DAMARU', cat:c.Lo,   canon:k._0, block:b[49]},
			'1883':{ u:'1883', i:5555, name:'MONGOLIAN LETTER ALI GALI UBADAMA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1884':{ u:'1884', i:5556, name:'MONGOLIAN LETTER ALI GALI INVERTED UBADAMA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1885':{ u:'1885', i:5557, name:'MONGOLIAN LETTER ALI GALI BALUDA', cat:c.Mn,   canon:k._0, block:b[49]},
			'1886':{ u:'1886', i:5558, name:'MONGOLIAN LETTER ALI GALI THREE BALUDA', cat:c.Mn,   canon:k._0, block:b[49]},
			'1887':{ u:'1887', i:5559, name:'MONGOLIAN LETTER ALI GALI A', cat:c.Lo,   canon:k._0, block:b[49], indexed:["A"]},
			'1888':{ u:'1888', i:5560, name:'MONGOLIAN LETTER ALI GALI I', cat:c.Lo,   canon:k._0, block:b[49], indexed:["I"]},
			'1889':{ u:'1889', i:5561, name:'MONGOLIAN LETTER ALI GALI KA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1890':{ u:'1890', i:5568, name:'MONGOLIAN LETTER ALI GALI TA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1891':{ u:'1891', i:5569, name:'MONGOLIAN LETTER ALI GALI DA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1892':{ u:'1892', i:5570, name:'MONGOLIAN LETTER ALI GALI PA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1893':{ u:'1893', i:5571, name:'MONGOLIAN LETTER ALI GALI PHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1894':{ u:'1894', i:5572, name:'MONGOLIAN LETTER ALI GALI SSA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1895':{ u:'1895', i:5573, name:'MONGOLIAN LETTER ALI GALI ZHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1896':{ u:'1896', i:5574, name:'MONGOLIAN LETTER ALI GALI ZA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1897':{ u:'1897', i:5575, name:'MONGOLIAN LETTER ALI GALI AH', cat:c.Lo,   canon:k._0, block:b[49]},
			'1898':{ u:'1898', i:5576, name:'MONGOLIAN LETTER TODO ALI GALI TA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1899':{ u:'1899', i:5577, name:'MONGOLIAN LETTER TODO ALI GALI ZHA', cat:c.Lo,   canon:k._0, block:b[49]},
			'1900':{ u:'1900', i:5665, name:'LIMBU VOWEL-CARRIER LETTER', cat:c.Lo,   canon:k._0, block:b[51]},
			'1901':{ u:'1901', i:5666, name:'LIMBU LETTER KA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1902':{ u:'1902', i:5667, name:'LIMBU LETTER KHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1903':{ u:'1903', i:5668, name:'LIMBU LETTER GA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1904':{ u:'1904', i:5669, name:'LIMBU LETTER GHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1905':{ u:'1905', i:5670, name:'LIMBU LETTER NGA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1906':{ u:'1906', i:5671, name:'LIMBU LETTER CA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1907':{ u:'1907', i:5672, name:'LIMBU LETTER CHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1908':{ u:'1908', i:5673, name:'LIMBU LETTER JA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1909':{ u:'1909', i:5674, name:'LIMBU LETTER JHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1910':{ u:'1910', i:5681, name:'LIMBU LETTER PA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1911':{ u:'1911', i:5682, name:'LIMBU LETTER PHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1912':{ u:'1912', i:5683, name:'LIMBU LETTER BA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1913':{ u:'1913', i:5684, name:'LIMBU LETTER BHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1914':{ u:'1914', i:5685, name:'LIMBU LETTER MA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1915':{ u:'1915', i:5686, name:'LIMBU LETTER YA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1916':{ u:'1916', i:5687, name:'LIMBU LETTER RA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1917':{ u:'1917', i:5688, name:'LIMBU LETTER LA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1918':{ u:'1918', i:5689, name:'LIMBU LETTER WA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1919':{ u:'1919', i:5690, name:'LIMBU LETTER SHA', cat:c.Lo,   canon:k._0, block:b[51]},
			'1920':{ u:'1920', i:5696, name:'LIMBU VOWEL SIGN A', cat:c.Mn,   canon:k._0, block:b[51], indexed:["A"]},
			'1921':{ u:'1921', i:5697, name:'LIMBU VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[51], indexed:["I"]},
			'1922':{ u:'1922', i:5698, name:'LIMBU VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[51], indexed:["U"]},
			'1923':{ u:'1923', i:5699, name:'LIMBU VOWEL SIGN EE', cat:c.Mc,   canon:k._0, block:b[51]},
			'1924':{ u:'1924', i:5700, name:'LIMBU VOWEL SIGN AI', cat:c.Mc,   canon:k._0, block:b[51]},
			'1925':{ u:'1925', i:5701, name:'LIMBU VOWEL SIGN OO', cat:c.Mc,   canon:k._0, block:b[51]},
			'1926':{ u:'1926', i:5702, name:'LIMBU VOWEL SIGN AU', cat:c.Mc,   canon:k._0, block:b[51]},
			'1927':{ u:'1927', i:5703, name:'LIMBU VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[51], indexed:["E"]},
			'1928':{ u:'1928', i:5704, name:'LIMBU VOWEL SIGN O', cat:c.Mn,   canon:k._0, block:b[51], indexed:["O"]},
			'1929':{ u:'1929', i:5705, name:'LIMBU SUBJOINED LETTER YA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1930':{ u:'1930', i:5708, name:'LIMBU SMALL LETTER KA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1931':{ u:'1931', i:5709, name:'LIMBU SMALL LETTER NGA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1932':{ u:'1932', i:5710, name:'LIMBU SMALL LETTER ANUSVARA', cat:c.Mn,   canon:k._0, block:b[51]},
			'1933':{ u:'1933', i:5711, name:'LIMBU SMALL LETTER TA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1934':{ u:'1934', i:5712, name:'LIMBU SMALL LETTER NA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1935':{ u:'1935', i:5713, name:'LIMBU SMALL LETTER PA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1936':{ u:'1936', i:5714, name:'LIMBU SMALL LETTER MA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1937':{ u:'1937', i:5715, name:'LIMBU SMALL LETTER RA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1938':{ u:'1938', i:5716, name:'LIMBU SMALL LETTER LA', cat:c.Mc,   canon:k._0, block:b[51]},
			'1939':{ u:'1939', i:5717, name:'LIMBU SIGN MUKPHRENG', cat:c.Mn,   canon:k._222, block:b[51]},
			'1940':{ u:'1940', i:5720, name:'LIMBU SIGN LOO', cat:c.So,   canon:k._0, block:b[51]},
			'1944':{ u:'1944', i:5721, name:'LIMBU EXCLAMATION MARK', cat:c.Po,   canon:k._0, block:b[51]},
			'1945':{ u:'1945', i:5722, name:'LIMBU QUESTION MARK', cat:c.Po,   canon:k._0, block:b[51]},
			'1946':{ u:'1946', i:5723, name:'LIMBU DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[51]},
			'1947':{ u:'1947', i:5724, name:'LIMBU DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[51]},
			'1948':{ u:'1948', i:5725, name:'LIMBU DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[51]},
			'1949':{ u:'1949', i:5726, name:'LIMBU DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[51]},
			'1950':{ u:'1950', i:5733, name:'TAI LE LETTER KA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1951':{ u:'1951', i:5734, name:'TAI LE LETTER XA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1952':{ u:'1952', i:5735, name:'TAI LE LETTER NGA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1953':{ u:'1953', i:5736, name:'TAI LE LETTER TSA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1954':{ u:'1954', i:5737, name:'TAI LE LETTER SA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1955':{ u:'1955', i:5738, name:'TAI LE LETTER YA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1956':{ u:'1956', i:5739, name:'TAI LE LETTER TA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1957':{ u:'1957', i:5740, name:'TAI LE LETTER THA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1958':{ u:'1958', i:5741, name:'TAI LE LETTER LA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1959':{ u:'1959', i:5742, name:'TAI LE LETTER PA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1960':{ u:'1960', i:5749, name:'TAI LE LETTER KHA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1961':{ u:'1961', i:5750, name:'TAI LE LETTER TSHA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1962':{ u:'1962', i:5751, name:'TAI LE LETTER NA', cat:c.Lo,   canon:k._0, block:b[52]},
			'1963':{ u:'1963', i:5752, name:'TAI LE LETTER A', cat:c.Lo,   canon:k._0, block:b[52], indexed:["A"]},
			'1964':{ u:'1964', i:5753, name:'TAI LE LETTER I', cat:c.Lo,   canon:k._0, block:b[52], indexed:["I"]},
			'1965':{ u:'1965', i:5754, name:'TAI LE LETTER EE', cat:c.Lo,   canon:k._0, block:b[52]},
			'1966':{ u:'1966', i:5755, name:'TAI LE LETTER EH', cat:c.Lo,   canon:k._0, block:b[52]},
			'1967':{ u:'1967', i:5756, name:'TAI LE LETTER U', cat:c.Lo,   canon:k._0, block:b[52], indexed:["U"]},
			'1968':{ u:'1968', i:5757, name:'TAI LE LETTER OO', cat:c.Lo,   canon:k._0, block:b[52]},
			'1969':{ u:'1969', i:5758, name:'TAI LE LETTER O', cat:c.Lo,   canon:k._0, block:b[52], indexed:["O"]},
			'1970':{ u:'1970', i:5763, name:'TAI LE LETTER TONE-2', cat:c.Lo,   canon:k._0, block:b[52]},
			'1971':{ u:'1971', i:5764, name:'TAI LE LETTER TONE-3', cat:c.Lo,   canon:k._0, block:b[52]},
			'1972':{ u:'1972', i:5765, name:'TAI LE LETTER TONE-4', cat:c.Lo,   canon:k._0, block:b[52]},
			'1973':{ u:'1973', i:5766, name:'TAI LE LETTER TONE-5', cat:c.Lo,   canon:k._0, block:b[52]},
			'1974':{ u:'1974', i:5767, name:'TAI LE LETTER TONE-6', cat:c.Lo,   canon:k._0, block:b[52]},
			'1980':{ u:'1980', i:5768, name:'NEW TAI LUE LETTER HIGH QA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1981':{ u:'1981', i:5769, name:'NEW TAI LUE LETTER LOW QA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1982':{ u:'1982', i:5770, name:'NEW TAI LUE LETTER HIGH KA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1983':{ u:'1983', i:5771, name:'NEW TAI LUE LETTER HIGH XA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1984':{ u:'1984', i:5772, name:'NEW TAI LUE LETTER HIGH NGA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1985':{ u:'1985', i:5773, name:'NEW TAI LUE LETTER LOW KA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1986':{ u:'1986', i:5774, name:'NEW TAI LUE LETTER LOW XA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1987':{ u:'1987', i:5775, name:'NEW TAI LUE LETTER LOW NGA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1988':{ u:'1988', i:5776, name:'NEW TAI LUE LETTER HIGH TSA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1989':{ u:'1989', i:5777, name:'NEW TAI LUE LETTER HIGH SA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1990':{ u:'1990', i:5784, name:'NEW TAI LUE LETTER HIGH NA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1991':{ u:'1991', i:5785, name:'NEW TAI LUE LETTER LOW TA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1992':{ u:'1992', i:5786, name:'NEW TAI LUE LETTER LOW THA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1993':{ u:'1993', i:5787, name:'NEW TAI LUE LETTER LOW NA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1994':{ u:'1994', i:5788, name:'NEW TAI LUE LETTER HIGH PA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1995':{ u:'1995', i:5789, name:'NEW TAI LUE LETTER HIGH PHA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1996':{ u:'1996', i:5790, name:'NEW TAI LUE LETTER HIGH MA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1997':{ u:'1997', i:5791, name:'NEW TAI LUE LETTER LOW PA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1998':{ u:'1998', i:5792, name:'NEW TAI LUE LETTER LOW PHA', cat:c.Lo,   canon:k._0, block:b[53]},
			'1999':{ u:'1999', i:5793, name:'NEW TAI LUE LETTER LOW MA', cat:c.Lo,   canon:k._0, block:b[53]},
			'2000':{ u:'2000', i:7288, name:'EN QUAD', cat:c.Zs,  relatives:['2002'],  canon:k._0, block:b[72]},
			'2001':{ u:'2001', i:7289, name:'EM QUAD', cat:c.Zs,  relatives:['2003'],  canon:k._0, block:b[72]},
			'2002':{ u:'2002', i:7290, name:'EN SPACE', cat:c.Zs,  relatives:['2000', '0020'],  canon:k._0, block:b[72]},
			'2003':{ u:'2003', i:7291, name:'EM SPACE', cat:c.Zs,  relatives:['2001', '0020'],  canon:k._0, block:b[72]},
			'2004':{ u:'2004', i:7292, name:'THREE-PER-EM SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2005':{ u:'2005', i:7293, name:'FOUR-PER-EM SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2006':{ u:'2006', i:7294, name:'SIX-PER-EM SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2007':{ u:'2007', i:7295, name:'FIGURE SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2008':{ u:'2008', i:7296, name:'PUNCTUATION SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2009':{ u:'2009', i:7297, name:'THIN SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[72]},
			'2010':{ u:'2010', i:7304, name:'HYPHEN', cat:c.Pd,  relatives:['2011'],  canon:k._0, block:b[72]},
			'2011':{ u:'2011', i:7305, name:'NON-BREAKING HYPHEN', cat:c.Pd,  relatives:['2010'],  canon:k._0, block:b[72]},
			'2012':{ u:'2012', i:7306, name:'FIGURE DASH', cat:c.Pd,   canon:k._0, block:b[72]},
			'2013':{ u:'2013', i:7307, name:'EN DASH', cat:c.Pd,  relatives:['fe32'],  canon:k._0, block:b[72]},
			'2014':{ u:'2014', i:7308, name:'EM DASH', cat:c.Pd,  relatives:['fe31', 'fe58'],  canon:k._0, block:b[72]},
			'2015':{ u:'2015', i:7309, name:'HORIZONTAL BAR', cat:c.Pd,   canon:k._0, block:b[72]},
			'2016':{ u:'2016', i:7310, name:'DOUBLE VERTICAL LINE', cat:c.Po,   canon:k._0, block:b[72]},
			'2017':{ u:'2017', i:7311, name:'DOUBLE LOW LINE', cat:c.Po,  relatives:['0020', '0333'], comp:['0020','0333'], canon:k._0, block:b[72]},
			'2018':{ u:'2018', i:7312, name:'LEFT SINGLE QUOTATION MARK', cat:c.Pi,   canon:k._0, block:b[72]},
			'2019':{ u:'2019', i:7313, name:'RIGHT SINGLE QUOTATION MARK', cat:c.Pf,   canon:k._0, block:b[72]},
			'2020':{ u:'2020', i:7320, name:'DAGGER', cat:c.Po,   canon:k._0, block:b[72]},
			'2021':{ u:'2021', i:7321, name:'DOUBLE DAGGER', cat:c.Po,   canon:k._0, block:b[72]},
			'2022':{ u:'2022', i:7322, name:'BULLET', cat:c.Po,   canon:k._0, block:b[72]},
			'2023':{ u:'2023', i:7323, name:'TRIANGULAR BULLET', cat:c.Po,   canon:k._0, block:b[72]},
			'2024':{ u:'2024', i:7324, name:'ONE DOT LEADER', cat:c.Po,  relatives:['002e'],  canon:k._0, block:b[72]},
			'2025':{ u:'2025', i:7325, name:'TWO DOT LEADER', cat:c.Po,  relatives:['002e', 'fe30'], comp:['002e','002e'], canon:k._0, block:b[72]},
			'2026':{ u:'2026', i:7326, name:'HORIZONTAL ELLIPSIS', cat:c.Po,  relatives:['002e', 'fe19'], comp:['002e','002e','002e'], canon:k._0, block:b[72]},
			'2027':{ u:'2027', i:7327, name:'HYPHENATION POINT', cat:c.Po,   canon:k._0, block:b[72]},
			'2028':{ u:'2028', i:7328, name:'LINE SEPARATOR', cat:c.Zl,   canon:k._0, block:b[72]},
			'2029':{ u:'2029', i:7329, name:'PARAGRAPH SEPARATOR', cat:c.Zp,   canon:k._0, block:b[72]},
			'2030':{ u:'2030', i:7336, name:'PER MILLE SIGN', cat:c.Po,   canon:k._0, block:b[72]},
			'2031':{ u:'2031', i:7337, name:'PER TEN THOUSAND SIGN', cat:c.Po,   canon:k._0, block:b[72]},
			'2032':{ u:'2032', i:7338, name:'PRIME', cat:c.Po,  relatives:['2033', '2034', '2057'],  canon:k._0, block:b[72]},
			'2033':{ u:'2033', i:7339, name:'DOUBLE PRIME', cat:c.Po,  relatives:['2032'], comp:['2032','2032'], canon:k._0, block:b[72]},
			'2034':{ u:'2034', i:7340, name:'TRIPLE PRIME', cat:c.Po,  relatives:['2032'], comp:['2032','2032','2032'], canon:k._0, block:b[72]},
			'2035':{ u:'2035', i:7341, name:'REVERSED PRIME', cat:c.Po,  relatives:['2036', '2037'],  canon:k._0, block:b[72]},
			'2036':{ u:'2036', i:7342, name:'REVERSED DOUBLE PRIME', cat:c.Po,  relatives:['2035'], comp:['2035','2035'], canon:k._0, block:b[72]},
			'2037':{ u:'2037', i:7343, name:'REVERSED TRIPLE PRIME', cat:c.Po,  relatives:['2035'], comp:['2035','2035','2035'], canon:k._0, block:b[72]},
			'2038':{ u:'2038', i:7344, name:'CARET', cat:c.Po,   canon:k._0, block:b[72]},
			'2039':{ u:'2039', i:7345, name:'SINGLE LEFT-POINTING ANGLE QUOTATION MARK', cat:c.Pi,   canon:k._0, block:b[72]},
			'2040':{ u:'2040', i:7352, name:'CHARACTER TIE', cat:c.Pc,   canon:k._0, block:b[72]},
			'2041':{ u:'2041', i:7353, name:'CARET INSERTION POINT', cat:c.Po,   canon:k._0, block:b[72]},
			'2042':{ u:'2042', i:7354, name:'ASTERISM', cat:c.Po,   canon:k._0, block:b[72]},
			'2043':{ u:'2043', i:7355, name:'HYPHEN BULLET', cat:c.Po,   canon:k._0, block:b[72]},
			'2044':{ u:'2044', i:7356, name:'FRACTION SLASH', cat:c.Sm,  relatives:['00bc', '00bd', '00be', '2150', '2151', '2152', '2153', '2154', '2155', '2156', '2157', '2158', '2159', '215a', '215b', '215c', '215d', '215e', '215f', '2189'],  canon:k._0, block:b[72]},
			'2045':{ u:'2045', i:7357, name:'LEFT SQUARE BRACKET WITH QUILL', cat:c.Ps,   canon:k._0, block:b[72]},
			'2046':{ u:'2046', i:7358, name:'RIGHT SQUARE BRACKET WITH QUILL', cat:c.Pe,   canon:k._0, block:b[72]},
			'2047':{ u:'2047', i:7359, name:'DOUBLE QUESTION MARK', cat:c.Po,  relatives:['003f'], comp:['003f','003f'], canon:k._0, block:b[72]},
			'2048':{ u:'2048', i:7360, name:'QUESTION EXCLAMATION MARK', cat:c.Po,  relatives:['003f', '0021'], comp:['003f','0021'], canon:k._0, block:b[72]},
			'2049':{ u:'2049', i:7361, name:'EXCLAMATION QUESTION MARK', cat:c.Po,  relatives:['0021', '003f'], comp:['0021','003f'], canon:k._0, block:b[72]},
			'2050':{ u:'2050', i:7368, name:'CLOSE UP', cat:c.Po,   canon:k._0, block:b[72]},
			'2051':{ u:'2051', i:7369, name:'TWO ASTERISKS ALIGNED VERTICALLY', cat:c.Po,   canon:k._0, block:b[72]},
			'2052':{ u:'2052', i:7370, name:'COMMERCIAL MINUS SIGN', cat:c.Sm,   canon:k._0, block:b[72]},
			'2053':{ u:'2053', i:7371, name:'SWUNG DASH', cat:c.Po,   canon:k._0, block:b[72]},
			'2054':{ u:'2054', i:7372, name:'INVERTED UNDERTIE', cat:c.Pc,   canon:k._0, block:b[72]},
			'2055':{ u:'2055', i:7373, name:'FLOWER PUNCTUATION MARK', cat:c.Po,   canon:k._0, block:b[72]},
			'2056':{ u:'2056', i:7374, name:'THREE DOT PUNCTUATION', cat:c.Po,   canon:k._0, block:b[72]},
			'2057':{ u:'2057', i:7375, name:'QUADRUPLE PRIME', cat:c.Po,  relatives:['2032'], comp:['2032','2032','2032','2032'], canon:k._0, block:b[72]},
			'2058':{ u:'2058', i:7376, name:'FOUR DOT PUNCTUATION', cat:c.Po,   canon:k._0, block:b[72]},
			'2059':{ u:'2059', i:7377, name:'FIVE DOT PUNCTUATION', cat:c.Po,   canon:k._0, block:b[72]},
			'2060':{ u:'2060', i:7384, name:'WORD JOINER', cat:c.Cf,   canon:k._0, block:b[72]},
			'2061':{ u:'2061', i:7385, name:'FUNCTION APPLICATION', cat:c.Cf,   canon:k._0, block:b[72]},
			'2062':{ u:'2062', i:7386, name:'INVISIBLE TIMES', cat:c.Cf,   canon:k._0, block:b[72]},
			'2063':{ u:'2063', i:7387, name:'INVISIBLE SEPARATOR', cat:c.Cf,   canon:k._0, block:b[72]},
			'2064':{ u:'2064', i:7388, name:'INVISIBLE PLUS', cat:c.Cf,   canon:k._0, block:b[72]},
			'2066':{ u:'2066', i:7389, name:'LEFT-TO-RIGHT ISOLATE', cat:c.Cf,   canon:k._0, block:b[72]},
			'2067':{ u:'2067', i:7390, name:'RIGHT-TO-LEFT ISOLATE', cat:c.Cf,   canon:k._0, block:b[72]},
			'2068':{ u:'2068', i:7391, name:'FIRST STRONG ISOLATE', cat:c.Cf,   canon:k._0, block:b[72]},
			'2069':{ u:'2069', i:7392, name:'POP DIRECTIONAL ISOLATE', cat:c.Cf,   canon:k._0, block:b[72]},
			'2070':{ u:'2070', i:7399, name:'SUPERSCRIPT ZERO', cat:c.No,  relatives:['0030'],  canon:k._0, block:b[73]},
			'2071':{ u:'2071', i:7400, name:'SUPERSCRIPT LATIN SMALL LETTER I', cat:c.Lm,  relatives:['0069'],  canon:k._0, block:b[73], indexed:["I"]},
			'2074':{ u:'2074', i:7401, name:'SUPERSCRIPT FOUR', cat:c.No,  relatives:['0034'],  canon:k._0, block:b[73]},
			'2075':{ u:'2075', i:7402, name:'SUPERSCRIPT FIVE', cat:c.No,  relatives:['0035'],  canon:k._0, block:b[73]},
			'2076':{ u:'2076', i:7403, name:'SUPERSCRIPT SIX', cat:c.No,  relatives:['0036'],  canon:k._0, block:b[73]},
			'2077':{ u:'2077', i:7404, name:'SUPERSCRIPT SEVEN', cat:c.No,  relatives:['0037'],  canon:k._0, block:b[73]},
			'2078':{ u:'2078', i:7405, name:'SUPERSCRIPT EIGHT', cat:c.No,  relatives:['0038'],  canon:k._0, block:b[73]},
			'2079':{ u:'2079', i:7406, name:'SUPERSCRIPT NINE', cat:c.No,  relatives:['0039'],  canon:k._0, block:b[73]},
			'2080':{ u:'2080', i:7413, name:'SUBSCRIPT ZERO', cat:c.No,  relatives:['0030'],  canon:k._0, block:b[73]},
			'2081':{ u:'2081', i:7414, name:'SUBSCRIPT ONE', cat:c.No,  relatives:['0031'],  canon:k._0, block:b[73]},
			'2082':{ u:'2082', i:7415, name:'SUBSCRIPT TWO', cat:c.No,  relatives:['0032'],  canon:k._0, block:b[73]},
			'2083':{ u:'2083', i:7416, name:'SUBSCRIPT THREE', cat:c.No,  relatives:['0033'],  canon:k._0, block:b[73]},
			'2084':{ u:'2084', i:7417, name:'SUBSCRIPT FOUR', cat:c.No,  relatives:['0034'],  canon:k._0, block:b[73]},
			'2085':{ u:'2085', i:7418, name:'SUBSCRIPT FIVE', cat:c.No,  relatives:['0035'],  canon:k._0, block:b[73]},
			'2086':{ u:'2086', i:7419, name:'SUBSCRIPT SIX', cat:c.No,  relatives:['0036'],  canon:k._0, block:b[73]},
			'2087':{ u:'2087', i:7420, name:'SUBSCRIPT SEVEN', cat:c.No,  relatives:['0037'],  canon:k._0, block:b[73]},
			'2088':{ u:'2088', i:7421, name:'SUBSCRIPT EIGHT', cat:c.No,  relatives:['0038'],  canon:k._0, block:b[73]},
			'2089':{ u:'2089', i:7422, name:'SUBSCRIPT NINE', cat:c.No,  relatives:['0039'],  canon:k._0, block:b[73]},
			'2090':{ u:'2090', i:7428, name:'LATIN SUBSCRIPT SMALL LETTER A', cat:c.Lm,  relatives:['0061'],  canon:k._0, block:b[73], indexed:["A"]},
			'2091':{ u:'2091', i:7429, name:'LATIN SUBSCRIPT SMALL LETTER E', cat:c.Lm,  relatives:['0065'],  canon:k._0, block:b[73], indexed:["E"]},
			'2092':{ u:'2092', i:7430, name:'LATIN SUBSCRIPT SMALL LETTER O', cat:c.Lm,  relatives:['006f'],  canon:k._0, block:b[73], indexed:["O"]},
			'2093':{ u:'2093', i:7431, name:'LATIN SUBSCRIPT SMALL LETTER X', cat:c.Lm,  relatives:['0078'],  canon:k._0, block:b[73], indexed:["X"]},
			'2094':{ u:'2094', i:7432, name:'LATIN SUBSCRIPT SMALL LETTER SCHWA', cat:c.Lm,  relatives:['0259'],  canon:k._0, block:b[73]},
			'2095':{ u:'2095', i:7433, name:'LATIN SUBSCRIPT SMALL LETTER H', cat:c.Lm,  relatives:['0068'],  canon:k._0, block:b[73], indexed:["H"]},
			'2096':{ u:'2096', i:7434, name:'LATIN SUBSCRIPT SMALL LETTER K', cat:c.Lm,  relatives:['006b'],  canon:k._0, block:b[73], indexed:["K"]},
			'2097':{ u:'2097', i:7435, name:'LATIN SUBSCRIPT SMALL LETTER L', cat:c.Lm,  relatives:['006c'],  canon:k._0, block:b[73], indexed:["L"]},
			'2098':{ u:'2098', i:7436, name:'LATIN SUBSCRIPT SMALL LETTER M', cat:c.Lm,  relatives:['006d'],  canon:k._0, block:b[73], indexed:["M"]},
			'2099':{ u:'2099', i:7437, name:'LATIN SUBSCRIPT SMALL LETTER N', cat:c.Lm,  relatives:['006e'],  canon:k._0, block:b[73], indexed:["N"]},
			'2100':{ u:'2100', i:7507, name:'ACCOUNT OF', cat:c.So,  relatives:['0061', '002f', '0063'], comp:['0061','002f','0063'], canon:k._0, block:b[76]},
			'2101':{ u:'2101', i:7508, name:'ADDRESSED TO THE SUBJECT', cat:c.So,  relatives:['0061', '002f', '0073'], comp:['0061','002f','0073'], canon:k._0, block:b[76]},
			'2102':{ u:'2102', i:7509, name:'DOUBLE-STRUCK CAPITAL C', cat:c.Lu,  relatives:['0043'],  canon:k._0, block:b[76], indexed:["C"]},
			'2103':{ u:'2103', i:7510, name:'DEGREE CELSIUS', cat:c.So,  relatives:['00b0', '0043'], comp:['00b0','0043'], canon:k._0, block:b[76]},
			'2104':{ u:'2104', i:7511, name:'CENTRE LINE SYMBOL', cat:c.So,   canon:k._0, block:b[76]},
			'2105':{ u:'2105', i:7512, name:'CARE OF', cat:c.So,  relatives:['0063', '002f', '006f'], comp:['0063','002f','006f'], canon:k._0, block:b[76]},
			'2106':{ u:'2106', i:7513, name:'CADA UNA', cat:c.So,  relatives:['0063', '002f', '0075'], comp:['0063','002f','0075'], canon:k._0, block:b[76]},
			'2107':{ u:'2107', i:7514, name:'EULER CONSTANT', cat:c.Lu,  relatives:['0190'],  canon:k._0, block:b[76]},
			'2108':{ u:'2108', i:7515, name:'SCRUPLE', cat:c.So,   canon:k._0, block:b[76]},
			'2109':{ u:'2109', i:7516, name:'DEGREE FAHRENHEIT', cat:c.So,  relatives:['00b0', '0046'], comp:['00b0','0046'], canon:k._0, block:b[76]},
			'2110':{ u:'2110', i:7523, name:'SCRIPT CAPITAL I', cat:c.Lu,  relatives:['0049'],  canon:k._0, block:b[76], indexed:["I"]},
			'2111':{ u:'2111', i:7524, name:'BLACK-LETTER CAPITAL I', cat:c.Lu,  relatives:['0049'],  canon:k._0, block:b[76], indexed:["I"]},
			'2112':{ u:'2112', i:7525, name:'SCRIPT CAPITAL L', cat:c.Lu,  relatives:['004c'],  canon:k._0, block:b[76], indexed:["L"]},
			'2113':{ u:'2113', i:7526, name:'SCRIPT SMALL L', cat:c.Ll,  relatives:['006c', '3395', '3396', '3397', '3398'],  canon:k._0, block:b[76], indexed:["L"]},
			'2114':{ u:'2114', i:7527, name:'L B BAR SYMBOL', cat:c.So,   canon:k._0, block:b[76], indexed:["L","B"]},
			'2115':{ u:'2115', i:7528, name:'DOUBLE-STRUCK CAPITAL N', cat:c.Lu,  relatives:['004e'],  canon:k._0, block:b[76], indexed:["N"]},
			'2116':{ u:'2116', i:7529, name:'NUMERO SIGN', cat:c.So,  relatives:['004e', '006f'], comp:['004e','006f'], canon:k._0, block:b[76]},
			'2117':{ u:'2117', i:7530, name:'SOUND RECORDING COPYRIGHT', cat:c.So,   canon:k._0, block:b[76]},
			'2118':{ u:'2118', i:7531, name:'SCRIPT CAPITAL P', cat:c.Sm,   canon:k._0, block:b[76], indexed:["P"]},
			'2119':{ u:'2119', i:7532, name:'DOUBLE-STRUCK CAPITAL P', cat:c.Lu,  relatives:['0050'],  canon:k._0, block:b[76], indexed:["P"]},
			'2120':{ u:'2120', i:7539, name:'SERVICE MARK', cat:c.So,  relatives:['0053', '004d'], comp:['0053','004d'], canon:k._0, block:b[76]},
			'2121':{ u:'2121', i:7540, name:'TELEPHONE SIGN', cat:c.So,  relatives:['0054', '0045', '004c'], comp:['0054','0045','004c'], canon:k._0, block:b[76]},
			'2122':{ u:'2122', i:7541, name:'TRADE MARK SIGN', cat:c.So,  relatives:['0054', '004d'], comp:['0054','004d'], canon:k._0, block:b[76]},
			'2123':{ u:'2123', i:7542, name:'VERSICLE', cat:c.So,   canon:k._0, block:b[76]},
			'2124':{ u:'2124', i:7543, name:'DOUBLE-STRUCK CAPITAL Z', cat:c.Lu,  relatives:['005a'],  canon:k._0, block:b[76], indexed:["Z"]},
			'2125':{ u:'2125', i:7544, name:'OUNCE SIGN', cat:c.So,   canon:k._0, block:b[76]},
			'2126':{ u:'2126', i:7545, name:'OHM SIGN', cat:c.Lu,  relatives:['03a9'],  canon:k._0, block:b[76]},
			'2127':{ u:'2127', i:7546, name:'INVERTED OHM SIGN', cat:c.So,   canon:k._0, block:b[76]},
			'2128':{ u:'2128', i:7547, name:'BLACK-LETTER CAPITAL Z', cat:c.Lu,  relatives:['005a'],  canon:k._0, block:b[76], indexed:["Z"]},
			'2129':{ u:'2129', i:7548, name:'TURNED GREEK SMALL LETTER IOTA', cat:c.So,   canon:k._0, block:b[76]},
			'2130':{ u:'2130', i:7555, name:'SCRIPT CAPITAL E', cat:c.Lu,  relatives:['0045'],  canon:k._0, block:b[76], indexed:["E"]},
			'2131':{ u:'2131', i:7556, name:'SCRIPT CAPITAL F', cat:c.Lu,  relatives:['0046'],  canon:k._0, block:b[76], indexed:["F"]},
			'2132':{ u:'2132', i:7557, name:'TURNED CAPITAL F', cat:c.Lu,   canon:k._0, block:b[76], indexed:["F"]},
			'2133':{ u:'2133', i:7558, name:'SCRIPT CAPITAL M', cat:c.Lu,  relatives:['004d'],  canon:k._0, block:b[76], indexed:["M"]},
			'2134':{ u:'2134', i:7559, name:'SCRIPT SMALL O', cat:c.Ll,  relatives:['006f'],  canon:k._0, block:b[76], indexed:["O"]},
			'2135':{ u:'2135', i:7560, name:'ALEF SYMBOL', cat:c.Lo,  relatives:['05d0'],  canon:k._0, block:b[76]},
			'2136':{ u:'2136', i:7561, name:'BET SYMBOL', cat:c.Lo,  relatives:['05d1'],  canon:k._0, block:b[76]},
			'2137':{ u:'2137', i:7562, name:'GIMEL SYMBOL', cat:c.Lo,  relatives:['05d2'],  canon:k._0, block:b[76]},
			'2138':{ u:'2138', i:7563, name:'DALET SYMBOL', cat:c.Lo,  relatives:['05d3'],  canon:k._0, block:b[76]},
			'2139':{ u:'2139', i:7564, name:'INFORMATION SOURCE', cat:c.Ll,  relatives:['0069'],  canon:k._0, block:b[76]},
			'2140':{ u:'2140', i:7571, name:'DOUBLE-STRUCK N-ARY SUMMATION', cat:c.Sm,  relatives:['2211'],  canon:k._0, block:b[76]},
			'2141':{ u:'2141', i:7572, name:'TURNED SANS-SERIF CAPITAL G', cat:c.Sm,   canon:k._0, block:b[76], indexed:["G"]},
			'2142':{ u:'2142', i:7573, name:'TURNED SANS-SERIF CAPITAL L', cat:c.Sm,   canon:k._0, block:b[76], indexed:["L"]},
			'2143':{ u:'2143', i:7574, name:'REVERSED SANS-SERIF CAPITAL L', cat:c.Sm,   canon:k._0, block:b[76], indexed:["L"]},
			'2144':{ u:'2144', i:7575, name:'TURNED SANS-SERIF CAPITAL Y', cat:c.Sm,   canon:k._0, block:b[76], indexed:["Y"]},
			'2145':{ u:'2145', i:7576, name:'DOUBLE-STRUCK ITALIC CAPITAL D', cat:c.Lu,  relatives:['0044'],  canon:k._0, block:b[76], indexed:["D"]},
			'2146':{ u:'2146', i:7577, name:'DOUBLE-STRUCK ITALIC SMALL D', cat:c.Ll,  relatives:['0064'],  canon:k._0, block:b[76], indexed:["D"]},
			'2147':{ u:'2147', i:7578, name:'DOUBLE-STRUCK ITALIC SMALL E', cat:c.Ll,  relatives:['0065'],  canon:k._0, block:b[76], indexed:["E"]},
			'2148':{ u:'2148', i:7579, name:'DOUBLE-STRUCK ITALIC SMALL I', cat:c.Ll,  relatives:['0069'],  canon:k._0, block:b[76], indexed:["I"]},
			'2149':{ u:'2149', i:7580, name:'DOUBLE-STRUCK ITALIC SMALL J', cat:c.Ll,  relatives:['006a'],  canon:k._0, block:b[76], indexed:["J"]},
			'2150':{ u:'2150', i:7587, name:'VULGAR FRACTION ONE SEVENTH', cat:c.No,  relatives:['0031', '2044', '0037'], comp:['0031','2044','0037'], canon:k._0, block:b[77]},
			'2151':{ u:'2151', i:7588, name:'VULGAR FRACTION ONE NINTH', cat:c.No,  relatives:['0031', '2044', '0039'], comp:['0031','2044','0039'], canon:k._0, block:b[77]},
			'2152':{ u:'2152', i:7589, name:'VULGAR FRACTION ONE TENTH', cat:c.No,  relatives:['0031', '2044', '0030'], comp:['0031','2044','0031','0030'], canon:k._0, block:b[77]},
			'2153':{ u:'2153', i:7590, name:'VULGAR FRACTION ONE THIRD', cat:c.No,  relatives:['0031', '2044', '0033'], comp:['0031','2044','0033'], canon:k._0, block:b[77]},
			'2154':{ u:'2154', i:7591, name:'VULGAR FRACTION TWO THIRDS', cat:c.No,  relatives:['0032', '2044', '0033'], comp:['0032','2044','0033'], canon:k._0, block:b[77]},
			'2155':{ u:'2155', i:7592, name:'VULGAR FRACTION ONE FIFTH', cat:c.No,  relatives:['0031', '2044', '0035'], comp:['0031','2044','0035'], canon:k._0, block:b[77]},
			'2156':{ u:'2156', i:7593, name:'VULGAR FRACTION TWO FIFTHS', cat:c.No,  relatives:['0032', '2044', '0035'], comp:['0032','2044','0035'], canon:k._0, block:b[77]},
			'2157':{ u:'2157', i:7594, name:'VULGAR FRACTION THREE FIFTHS', cat:c.No,  relatives:['0033', '2044', '0035'], comp:['0033','2044','0035'], canon:k._0, block:b[77]},
			'2158':{ u:'2158', i:7595, name:'VULGAR FRACTION FOUR FIFTHS', cat:c.No,  relatives:['0034', '2044', '0035'], comp:['0034','2044','0035'], canon:k._0, block:b[77]},
			'2159':{ u:'2159', i:7596, name:'VULGAR FRACTION ONE SIXTH', cat:c.No,  relatives:['0031', '2044', '0036'], comp:['0031','2044','0036'], canon:k._0, block:b[77]},
			'2160':{ u:'2160', i:7603, name:'ROMAN NUMERAL ONE', cat:c.Nl,  relatives:['0049'],  canon:k._0, block:b[77]},
			'2161':{ u:'2161', i:7604, name:'ROMAN NUMERAL TWO', cat:c.Nl,  relatives:['0049'], comp:['0049','0049'], canon:k._0, block:b[77]},
			'2162':{ u:'2162', i:7605, name:'ROMAN NUMERAL THREE', cat:c.Nl,  relatives:['0049'], comp:['0049','0049','0049'], canon:k._0, block:b[77]},
			'2163':{ u:'2163', i:7606, name:'ROMAN NUMERAL FOUR', cat:c.Nl,  relatives:['0049', '0056'], comp:['0049','0056'], canon:k._0, block:b[77]},
			'2164':{ u:'2164', i:7607, name:'ROMAN NUMERAL FIVE', cat:c.Nl,  relatives:['0056'],  canon:k._0, block:b[77]},
			'2165':{ u:'2165', i:7608, name:'ROMAN NUMERAL SIX', cat:c.Nl,  relatives:['0056', '0049'], comp:['0056','0049'], canon:k._0, block:b[77]},
			'2166':{ u:'2166', i:7609, name:'ROMAN NUMERAL SEVEN', cat:c.Nl,  relatives:['0056', '0049'], comp:['0056','0049','0049'], canon:k._0, block:b[77]},
			'2167':{ u:'2167', i:7610, name:'ROMAN NUMERAL EIGHT', cat:c.Nl,  relatives:['0056', '0049'], comp:['0056','0049','0049','0049'], canon:k._0, block:b[77]},
			'2168':{ u:'2168', i:7611, name:'ROMAN NUMERAL NINE', cat:c.Nl,  relatives:['0049', '0058'], comp:['0049','0058'], canon:k._0, block:b[77]},
			'2169':{ u:'2169', i:7612, name:'ROMAN NUMERAL TEN', cat:c.Nl,  relatives:['0058'],  canon:k._0, block:b[77]},
			'2170':{ u:'2170', i:7619, name:'SMALL ROMAN NUMERAL ONE', cat:c.Nl,  relatives:['0069'],  canon:k._0, block:b[77]},
			'2171':{ u:'2171', i:7620, name:'SMALL ROMAN NUMERAL TWO', cat:c.Nl,  relatives:['0069'], comp:['0069','0069'], canon:k._0, block:b[77]},
			'2172':{ u:'2172', i:7621, name:'SMALL ROMAN NUMERAL THREE', cat:c.Nl,  relatives:['0069'], comp:['0069','0069','0069'], canon:k._0, block:b[77]},
			'2173':{ u:'2173', i:7622, name:'SMALL ROMAN NUMERAL FOUR', cat:c.Nl,  relatives:['0069', '0076'], comp:['0069','0076'], canon:k._0, block:b[77]},
			'2174':{ u:'2174', i:7623, name:'SMALL ROMAN NUMERAL FIVE', cat:c.Nl,  relatives:['0076'],  canon:k._0, block:b[77]},
			'2175':{ u:'2175', i:7624, name:'SMALL ROMAN NUMERAL SIX', cat:c.Nl,  relatives:['0076', '0069'], comp:['0076','0069'], canon:k._0, block:b[77]},
			'2176':{ u:'2176', i:7625, name:'SMALL ROMAN NUMERAL SEVEN', cat:c.Nl,  relatives:['0076', '0069'], comp:['0076','0069','0069'], canon:k._0, block:b[77]},
			'2177':{ u:'2177', i:7626, name:'SMALL ROMAN NUMERAL EIGHT', cat:c.Nl,  relatives:['0076', '0069'], comp:['0076','0069','0069','0069'], canon:k._0, block:b[77]},
			'2178':{ u:'2178', i:7627, name:'SMALL ROMAN NUMERAL NINE', cat:c.Nl,  relatives:['0069', '0078'], comp:['0069','0078'], canon:k._0, block:b[77]},
			'2179':{ u:'2179', i:7628, name:'SMALL ROMAN NUMERAL TEN', cat:c.Nl,  relatives:['0078'],  canon:k._0, block:b[77]},
			'2180':{ u:'2180', i:7635, name:'ROMAN NUMERAL ONE THOUSAND C D', cat:c.Nl,   canon:k._0, block:b[77], indexed:["C","D"]},
			'2181':{ u:'2181', i:7636, name:'ROMAN NUMERAL FIVE THOUSAND', cat:c.Nl,   canon:k._0, block:b[77]},
			'2182':{ u:'2182', i:7637, name:'ROMAN NUMERAL TEN THOUSAND', cat:c.Nl,   canon:k._0, block:b[77]},
			'2183':{ u:'2183', i:7638, name:'ROMAN NUMERAL REVERSED ONE HUNDRED', cat:c.Lu,   canon:k._0, block:b[77]},
			'2184':{ u:'2184', i:7639, name:'LATIN SMALL LETTER REVERSED C', cat:c.Ll,   canon:k._0, block:b[77], indexed:["C"]},
			'2185':{ u:'2185', i:7640, name:'ROMAN NUMERAL SIX LATE FORM', cat:c.Nl,   canon:k._0, block:b[77]},
			'2186':{ u:'2186', i:7641, name:'ROMAN NUMERAL FIFTY EARLY FORM', cat:c.Nl,   canon:k._0, block:b[77]},
			'2187':{ u:'2187', i:7642, name:'ROMAN NUMERAL FIFTY THOUSAND', cat:c.Nl,   canon:k._0, block:b[77]},
			'2188':{ u:'2188', i:7643, name:'ROMAN NUMERAL ONE HUNDRED THOUSAND', cat:c.Nl,   canon:k._0, block:b[77]},
			'2189':{ u:'2189', i:7644, name:'VULGAR FRACTION ZERO THIRDS', cat:c.No,  relatives:['0030', '2044', '0033'], comp:['0030','2044','0033'], canon:k._0, block:b[77]},
			'2190':{ u:'2190', i:7647, name:'LEFTWARDS ARROW', cat:c.Sm,  relatives:['219a', 'ffe9'],  canon:k._0, block:b[78]},
			'2191':{ u:'2191', i:7648, name:'UPWARDS ARROW', cat:c.Sm,  relatives:['ffea'],  canon:k._0, block:b[78]},
			'2192':{ u:'2192', i:7649, name:'RIGHTWARDS ARROW', cat:c.Sm,  relatives:['219b', 'ffeb'],  canon:k._0, block:b[78]},
			'2193':{ u:'2193', i:7650, name:'DOWNWARDS ARROW', cat:c.Sm,  relatives:['ffec'],  canon:k._0, block:b[78]},
			'2194':{ u:'2194', i:7651, name:'LEFT RIGHT ARROW', cat:c.Sm,  relatives:['21ae'],  canon:k._0, block:b[78]},
			'2195':{ u:'2195', i:7652, name:'UP DOWN ARROW', cat:c.So,   canon:k._0, block:b[78]},
			'2196':{ u:'2196', i:7653, name:'NORTH WEST ARROW', cat:c.So,   canon:k._0, block:b[78]},
			'2197':{ u:'2197', i:7654, name:'NORTH EAST ARROW', cat:c.So,   canon:k._0, block:b[78]},
			'2198':{ u:'2198', i:7655, name:'SOUTH EAST ARROW', cat:c.So,   canon:k._0, block:b[78]},
			'2199':{ u:'2199', i:7656, name:'SOUTH WEST ARROW', cat:c.So,   canon:k._0, block:b[78]},
			'2200':{ u:'2200', i:7759, name:'FOR ALL', cat:c.Sm,   canon:k._0, block:b[79]},
			'2201':{ u:'2201', i:7760, name:'COMPLEMENT', cat:c.Sm,   canon:k._0, block:b[79]},
			'2202':{ u:'2202', i:7761, name:'PARTIAL DIFFERENTIAL', cat:c.Sm,  relatives:['1d6db', '1d715', '1d74f', '1d789', '1d7c3'],  canon:k._0, block:b[79]},
			'2203':{ u:'2203', i:7762, name:'THERE EXISTS', cat:c.Sm,  relatives:['2204'],  canon:k._0, block:b[79]},
			'2204':{ u:'2204', i:7763, name:'THERE DOES NOT EXIST', cat:c.Sm,  relatives:['2203', '0338'], comp:['2203','0338'], canon:k._0, block:b[79]},
			'2205':{ u:'2205', i:7764, name:'EMPTY SET', cat:c.Sm,   canon:k._0, block:b[79]},
			'2206':{ u:'2206', i:7765, name:'INCREMENT', cat:c.Sm,   canon:k._0, block:b[79]},
			'2207':{ u:'2207', i:7766, name:'NABLA', cat:c.Sm,  relatives:['1d6c1', '1d6fb', '1d735', '1d76f', '1d7a9'],  canon:k._0, block:b[79]},
			'2208':{ u:'2208', i:7767, name:'ELEMENT OF', cat:c.Sm,  relatives:['2209'],  canon:k._0, block:b[79]},
			'2209':{ u:'2209', i:7768, name:'NOT AN ELEMENT OF', cat:c.Sm,  relatives:['2208', '0338'], comp:['2208','0338'], canon:k._0, block:b[79]},
			'2210':{ u:'2210', i:7775, name:'N-ARY COPRODUCT', cat:c.Sm,   canon:k._0, block:b[79]},
			'2211':{ u:'2211', i:7776, name:'N-ARY SUMMATION', cat:c.Sm,  relatives:['2140'],  canon:k._0, block:b[79]},
			'2212':{ u:'2212', i:7777, name:'MINUS SIGN', cat:c.Sm,  relatives:['207b', '208b'],  canon:k._0, block:b[79]},
			'2213':{ u:'2213', i:7778, name:'MINUS-OR-PLUS SIGN', cat:c.Sm,   canon:k._0, block:b[79]},
			'2214':{ u:'2214', i:7779, name:'DOT PLUS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2215':{ u:'2215', i:7780, name:'DIVISION SLASH', cat:c.Sm,  relatives:['33a7', '33a8', '33ae', '33af', '33c6', '33de', '33df'],  canon:k._0, block:b[79]},
			'2216':{ u:'2216', i:7781, name:'SET MINUS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2217':{ u:'2217', i:7782, name:'ASTERISK OPERATOR', cat:c.Sm,   canon:k._0, block:b[79]},
			'2218':{ u:'2218', i:7783, name:'RING OPERATOR', cat:c.Sm,   canon:k._0, block:b[79]},
			'2219':{ u:'2219', i:7784, name:'BULLET OPERATOR', cat:c.Sm,   canon:k._0, block:b[79]},
			'2220':{ u:'2220', i:7791, name:'ANGLE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2221':{ u:'2221', i:7792, name:'MEASURED ANGLE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2222':{ u:'2222', i:7793, name:'SPHERICAL ANGLE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2223':{ u:'2223', i:7794, name:'DIVIDES', cat:c.Sm,  relatives:['2224'],  canon:k._0, block:b[79]},
			'2224':{ u:'2224', i:7795, name:'DOES NOT DIVIDE', cat:c.Sm,  relatives:['2223', '0338'], comp:['2223','0338'], canon:k._0, block:b[79]},
			'2225':{ u:'2225', i:7796, name:'PARALLEL TO', cat:c.Sm,  relatives:['2226'],  canon:k._0, block:b[79]},
			'2226':{ u:'2226', i:7797, name:'NOT PARALLEL TO', cat:c.Sm,  relatives:['2225', '0338'], comp:['2225','0338'], canon:k._0, block:b[79]},
			'2227':{ u:'2227', i:7798, name:'LOGICAL AND', cat:c.Sm,   canon:k._0, block:b[79]},
			'2228':{ u:'2228', i:7799, name:'LOGICAL OR', cat:c.Sm,   canon:k._0, block:b[79]},
			'2229':{ u:'2229', i:7800, name:'INTERSECTION', cat:c.Sm,   canon:k._0, block:b[79]},
			'2230':{ u:'2230', i:7807, name:'VOLUME INTEGRAL', cat:c.Sm,  relatives:['222e'], comp:['222e','222e','222e'], canon:k._0, block:b[79]},
			'2231':{ u:'2231', i:7808, name:'CLOCKWISE INTEGRAL', cat:c.Sm,   canon:k._0, block:b[79]},
			'2232':{ u:'2232', i:7809, name:'CLOCKWISE CONTOUR INTEGRAL', cat:c.Sm,   canon:k._0, block:b[79]},
			'2233':{ u:'2233', i:7810, name:'ANTICLOCKWISE CONTOUR INTEGRAL', cat:c.Sm,   canon:k._0, block:b[79]},
			'2234':{ u:'2234', i:7811, name:'THEREFORE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2235':{ u:'2235', i:7812, name:'BECAUSE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2236':{ u:'2236', i:7813, name:'RATIO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2237':{ u:'2237', i:7814, name:'PROPORTION', cat:c.Sm,   canon:k._0, block:b[79]},
			'2238':{ u:'2238', i:7815, name:'DOT MINUS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2239':{ u:'2239', i:7816, name:'EXCESS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2240':{ u:'2240', i:7823, name:'WREATH PRODUCT', cat:c.Sm,   canon:k._0, block:b[79]},
			'2241':{ u:'2241', i:7824, name:'NOT TILDE', cat:c.Sm,  relatives:['223c', '0338'], comp:['223c','0338'], canon:k._0, block:b[79]},
			'2242':{ u:'2242', i:7825, name:'MINUS TILDE', cat:c.Sm,   canon:k._0, block:b[79]},
			'2243':{ u:'2243', i:7826, name:'ASYMPTOTICALLY EQUAL TO', cat:c.Sm,  relatives:['2244'],  canon:k._0, block:b[79]},
			'2244':{ u:'2244', i:7827, name:'NOT ASYMPTOTICALLY EQUAL TO', cat:c.Sm,  relatives:['2243', '0338'], comp:['2243','0338'], canon:k._0, block:b[79]},
			'2245':{ u:'2245', i:7828, name:'APPROXIMATELY EQUAL TO', cat:c.Sm,  relatives:['2247'],  canon:k._0, block:b[79]},
			'2246':{ u:'2246', i:7829, name:'APPROXIMATELY BUT NOT ACTUALLY EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2247':{ u:'2247', i:7830, name:'NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO', cat:c.Sm,  relatives:['2245', '0338'], comp:['2245','0338'], canon:k._0, block:b[79]},
			'2248':{ u:'2248', i:7831, name:'ALMOST EQUAL TO', cat:c.Sm,  relatives:['2249'],  canon:k._0, block:b[79]},
			'2249':{ u:'2249', i:7832, name:'NOT ALMOST EQUAL TO', cat:c.Sm,  relatives:['2248', '0338'], comp:['2248','0338'], canon:k._0, block:b[79]},
			'2250':{ u:'2250', i:7839, name:'APPROACHES THE LIMIT', cat:c.Sm,   canon:k._0, block:b[79]},
			'2251':{ u:'2251', i:7840, name:'GEOMETRICALLY EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2252':{ u:'2252', i:7841, name:'APPROXIMATELY EQUAL TO OR THE IMAGE OF', cat:c.Sm,   canon:k._0, block:b[79]},
			'2253':{ u:'2253', i:7842, name:'IMAGE OF OR APPROXIMATELY EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2254':{ u:'2254', i:7843, name:'COLON EQUALS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2255':{ u:'2255', i:7844, name:'EQUALS COLON', cat:c.Sm,   canon:k._0, block:b[79]},
			'2256':{ u:'2256', i:7845, name:'RING IN EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2257':{ u:'2257', i:7846, name:'RING EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2258':{ u:'2258', i:7847, name:'CORRESPONDS TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2259':{ u:'2259', i:7848, name:'ESTIMATES', cat:c.Sm,   canon:k._0, block:b[79]},
			'2260':{ u:'2260', i:7855, name:'NOT EQUAL TO', cat:c.Sm,  relatives:['003d', '0338'], comp:['003d','0338'], canon:k._0, block:b[79]},
			'2261':{ u:'2261', i:7856, name:'IDENTICAL TO', cat:c.Sm,  relatives:['2262'],  canon:k._0, block:b[79]},
			'2262':{ u:'2262', i:7857, name:'NOT IDENTICAL TO', cat:c.Sm,  relatives:['2261', '0338'], comp:['2261','0338'], canon:k._0, block:b[79]},
			'2263':{ u:'2263', i:7858, name:'STRICTLY EQUIVALENT TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2264':{ u:'2264', i:7859, name:'LESS-THAN OR EQUAL TO', cat:c.Sm,  relatives:['2270'],  canon:k._0, block:b[79]},
			'2265':{ u:'2265', i:7860, name:'GREATER-THAN OR EQUAL TO', cat:c.Sm,  relatives:['2271'],  canon:k._0, block:b[79]},
			'2266':{ u:'2266', i:7861, name:'LESS-THAN OVER EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2267':{ u:'2267', i:7862, name:'GREATER-THAN OVER EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2268':{ u:'2268', i:7863, name:'LESS-THAN BUT NOT EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2269':{ u:'2269', i:7864, name:'GREATER-THAN BUT NOT EQUAL TO', cat:c.Sm,   canon:k._0, block:b[79]},
			'2270':{ u:'2270', i:7871, name:'NEITHER LESS-THAN NOR EQUAL TO', cat:c.Sm,  relatives:['2264', '0338'], comp:['2264','0338'], canon:k._0, block:b[79]},
			'2271':{ u:'2271', i:7872, name:'NEITHER GREATER-THAN NOR EQUAL TO', cat:c.Sm,  relatives:['2265', '0338'], comp:['2265','0338'], canon:k._0, block:b[79]},
			'2272':{ u:'2272', i:7873, name:'LESS-THAN OR EQUIVALENT TO', cat:c.Sm,  relatives:['2274'],  canon:k._0, block:b[79]},
			'2273':{ u:'2273', i:7874, name:'GREATER-THAN OR EQUIVALENT TO', cat:c.Sm,  relatives:['2275'],  canon:k._0, block:b[79]},
			'2274':{ u:'2274', i:7875, name:'NEITHER LESS-THAN NOR EQUIVALENT TO', cat:c.Sm,  relatives:['2272', '0338'], comp:['2272','0338'], canon:k._0, block:b[79]},
			'2275':{ u:'2275', i:7876, name:'NEITHER GREATER-THAN NOR EQUIVALENT TO', cat:c.Sm,  relatives:['2273', '0338'], comp:['2273','0338'], canon:k._0, block:b[79]},
			'2276':{ u:'2276', i:7877, name:'LESS-THAN OR GREATER-THAN', cat:c.Sm,  relatives:['2278'],  canon:k._0, block:b[79]},
			'2277':{ u:'2277', i:7878, name:'GREATER-THAN OR LESS-THAN', cat:c.Sm,  relatives:['2279'],  canon:k._0, block:b[79]},
			'2278':{ u:'2278', i:7879, name:'NEITHER LESS-THAN NOR GREATER-THAN', cat:c.Sm,  relatives:['2276', '0338'], comp:['2276','0338'], canon:k._0, block:b[79]},
			'2279':{ u:'2279', i:7880, name:'NEITHER GREATER-THAN NOR LESS-THAN', cat:c.Sm,  relatives:['2277', '0338'], comp:['2277','0338'], canon:k._0, block:b[79]},
			'2280':{ u:'2280', i:7887, name:'DOES NOT PRECEDE', cat:c.Sm,  relatives:['227a', '0338'], comp:['227a','0338'], canon:k._0, block:b[79]},
			'2281':{ u:'2281', i:7888, name:'DOES NOT SUCCEED', cat:c.Sm,  relatives:['227b', '0338'], comp:['227b','0338'], canon:k._0, block:b[79]},
			'2282':{ u:'2282', i:7889, name:'SUBSET OF', cat:c.Sm,  relatives:['2284'],  canon:k._0, block:b[79]},
			'2283':{ u:'2283', i:7890, name:'SUPERSET OF', cat:c.Sm,  relatives:['2285'],  canon:k._0, block:b[79]},
			'2284':{ u:'2284', i:7891, name:'NOT A SUBSET OF', cat:c.Sm,  relatives:['2282', '0338'], comp:['2282','0338'], canon:k._0, block:b[79], indexed:["A"]},
			'2285':{ u:'2285', i:7892, name:'NOT A SUPERSET OF', cat:c.Sm,  relatives:['2283', '0338'], comp:['2283','0338'], canon:k._0, block:b[79], indexed:["A"]},
			'2286':{ u:'2286', i:7893, name:'SUBSET OF OR EQUAL TO', cat:c.Sm,  relatives:['2288'],  canon:k._0, block:b[79]},
			'2287':{ u:'2287', i:7894, name:'SUPERSET OF OR EQUAL TO', cat:c.Sm,  relatives:['2289'],  canon:k._0, block:b[79]},
			'2288':{ u:'2288', i:7895, name:'NEITHER A SUBSET OF NOR EQUAL TO', cat:c.Sm,  relatives:['2286', '0338'], comp:['2286','0338'], canon:k._0, block:b[79], indexed:["A"]},
			'2289':{ u:'2289', i:7896, name:'NEITHER A SUPERSET OF NOR EQUAL TO', cat:c.Sm,  relatives:['2287', '0338'], comp:['2287','0338'], canon:k._0, block:b[79], indexed:["A"]},
			'2290':{ u:'2290', i:7903, name:'SQUARE ORIGINAL OF', cat:c.Sm,   canon:k._0, block:b[79]},
			'2291':{ u:'2291', i:7904, name:'SQUARE IMAGE OF OR EQUAL TO', cat:c.Sm,  relatives:['22e2'],  canon:k._0, block:b[79]},
			'2292':{ u:'2292', i:7905, name:'SQUARE ORIGINAL OF OR EQUAL TO', cat:c.Sm,  relatives:['22e3'],  canon:k._0, block:b[79]},
			'2293':{ u:'2293', i:7906, name:'SQUARE CAP', cat:c.Sm,   canon:k._0, block:b[79]},
			'2294':{ u:'2294', i:7907, name:'SQUARE CUP', cat:c.Sm,   canon:k._0, block:b[79]},
			'2295':{ u:'2295', i:7908, name:'CIRCLED PLUS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2296':{ u:'2296', i:7909, name:'CIRCLED MINUS', cat:c.Sm,   canon:k._0, block:b[79]},
			'2297':{ u:'2297', i:7910, name:'CIRCLED TIMES', cat:c.Sm,   canon:k._0, block:b[79]},
			'2298':{ u:'2298', i:7911, name:'CIRCLED DIVISION SLASH', cat:c.Sm,   canon:k._0, block:b[79]},
			'2299':{ u:'2299', i:7912, name:'CIRCLED DOT OPERATOR', cat:c.Sm,   canon:k._0, block:b[79]},
			'2300':{ u:'2300', i:8015, name:'DIAMETER SIGN', cat:c.So,   canon:k._0, block:b[80]},
			'2301':{ u:'2301', i:8016, name:'ELECTRIC ARROW', cat:c.So,   canon:k._0, block:b[80]},
			'2302':{ u:'2302', i:8017, name:'HOUSE', cat:c.So,   canon:k._0, block:b[80]},
			'2303':{ u:'2303', i:8018, name:'UP ARROWHEAD', cat:c.So,   canon:k._0, block:b[80]},
			'2304':{ u:'2304', i:8019, name:'DOWN ARROWHEAD', cat:c.So,   canon:k._0, block:b[80]},
			'2305':{ u:'2305', i:8020, name:'PROJECTIVE', cat:c.So,   canon:k._0, block:b[80]},
			'2306':{ u:'2306', i:8021, name:'PERSPECTIVE', cat:c.So,   canon:k._0, block:b[80]},
			'2307':{ u:'2307', i:8022, name:'WAVY LINE', cat:c.So,   canon:k._0, block:b[80]},
			'2308':{ u:'2308', i:8023, name:'LEFT CEILING', cat:c.Ps,   canon:k._0, block:b[80]},
			'2309':{ u:'2309', i:8024, name:'RIGHT CEILING', cat:c.Pe,   canon:k._0, block:b[80]},
			'2310':{ u:'2310', i:8031, name:'REVERSED NOT SIGN', cat:c.So,   canon:k._0, block:b[80]},
			'2311':{ u:'2311', i:8032, name:'SQUARE LOZENGE', cat:c.So,   canon:k._0, block:b[80]},
			'2312':{ u:'2312', i:8033, name:'ARC', cat:c.So,   canon:k._0, block:b[80]},
			'2313':{ u:'2313', i:8034, name:'SEGMENT', cat:c.So,   canon:k._0, block:b[80]},
			'2314':{ u:'2314', i:8035, name:'SECTOR', cat:c.So,   canon:k._0, block:b[80]},
			'2315':{ u:'2315', i:8036, name:'TELEPHONE RECORDER', cat:c.So,   canon:k._0, block:b[80]},
			'2316':{ u:'2316', i:8037, name:'POSITION INDICATOR', cat:c.So,   canon:k._0, block:b[80]},
			'2317':{ u:'2317', i:8038, name:'VIEWDATA SQUARE', cat:c.So,   canon:k._0, block:b[80]},
			'2318':{ u:'2318', i:8039, name:'PLACE OF INTEREST SIGN', cat:c.So,   canon:k._0, block:b[80]},
			'2319':{ u:'2319', i:8040, name:'TURNED NOT SIGN', cat:c.So,   canon:k._0, block:b[80]},
			'2320':{ u:'2320', i:8047, name:'TOP HALF INTEGRAL', cat:c.Sm,   canon:k._0, block:b[80]},
			'2321':{ u:'2321', i:8048, name:'BOTTOM HALF INTEGRAL', cat:c.Sm,   canon:k._0, block:b[80]},
			'2322':{ u:'2322', i:8049, name:'FROWN', cat:c.So,   canon:k._0, block:b[80]},
			'2323':{ u:'2323', i:8050, name:'SMILE', cat:c.So,   canon:k._0, block:b[80]},
			'2324':{ u:'2324', i:8051, name:'UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS', cat:c.So,   canon:k._0, block:b[80]},
			'2325':{ u:'2325', i:8052, name:'OPTION KEY', cat:c.So,   canon:k._0, block:b[80]},
			'2326':{ u:'2326', i:8053, name:'ERASE TO THE RIGHT', cat:c.So,   canon:k._0, block:b[80]},
			'2327':{ u:'2327', i:8054, name:'X IN A RECTANGLE BOX', cat:c.So,   canon:k._0, block:b[80], indexed:["X","A"]},
			'2328':{ u:'2328', i:8055, name:'KEYBOARD', cat:c.So,   canon:k._0, block:b[80]},
			'2329':{ u:'2329', i:8056, name:'LEFT-POINTING ANGLE BRACKET', cat:c.Ps,  relatives:['3008'],  canon:k._0, block:b[80]},
			'2330':{ u:'2330', i:8063, name:'TOTAL RUNOUT', cat:c.So,   canon:k._0, block:b[80]},
			'2331':{ u:'2331', i:8064, name:'DIMENSION ORIGIN', cat:c.So,   canon:k._0, block:b[80]},
			'2332':{ u:'2332', i:8065, name:'CONICAL TAPER', cat:c.So,   canon:k._0, block:b[80]},
			'2333':{ u:'2333', i:8066, name:'SLOPE', cat:c.So,   canon:k._0, block:b[80]},
			'2334':{ u:'2334', i:8067, name:'COUNTERBORE', cat:c.So,   canon:k._0, block:b[80]},
			'2335':{ u:'2335', i:8068, name:'COUNTERSINK', cat:c.So,   canon:k._0, block:b[80]},
			'2336':{ u:'2336', i:8069, name:'APL FUNCTIONAL SYMBOL I-BEAM', cat:c.So,   canon:k._0, block:b[80]},
			'2337':{ u:'2337', i:8070, name:'APL FUNCTIONAL SYMBOL SQUISH QUAD', cat:c.So,   canon:k._0, block:b[80]},
			'2338':{ u:'2338', i:8071, name:'APL FUNCTIONAL SYMBOL QUAD EQUAL', cat:c.So,   canon:k._0, block:b[80]},
			'2339':{ u:'2339', i:8072, name:'APL FUNCTIONAL SYMBOL QUAD DIVIDE', cat:c.So,   canon:k._0, block:b[80]},
			'2340':{ u:'2340', i:8079, name:'APL FUNCTIONAL SYMBOL BACKSLASH BAR', cat:c.So,   canon:k._0, block:b[80]},
			'2341':{ u:'2341', i:8080, name:'APL FUNCTIONAL SYMBOL QUAD SLASH', cat:c.So,   canon:k._0, block:b[80]},
			'2342':{ u:'2342', i:8081, name:'APL FUNCTIONAL SYMBOL QUAD BACKSLASH', cat:c.So,   canon:k._0, block:b[80]},
			'2343':{ u:'2343', i:8082, name:'APL FUNCTIONAL SYMBOL QUAD LESS-THAN', cat:c.So,   canon:k._0, block:b[80]},
			'2344':{ u:'2344', i:8083, name:'APL FUNCTIONAL SYMBOL QUAD GREATER-THAN', cat:c.So,   canon:k._0, block:b[80]},
			'2345':{ u:'2345', i:8084, name:'APL FUNCTIONAL SYMBOL LEFTWARDS VANE', cat:c.So,   canon:k._0, block:b[80]},
			'2346':{ u:'2346', i:8085, name:'APL FUNCTIONAL SYMBOL RIGHTWARDS VANE', cat:c.So,   canon:k._0, block:b[80]},
			'2347':{ u:'2347', i:8086, name:'APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW', cat:c.So,   canon:k._0, block:b[80]},
			'2348':{ u:'2348', i:8087, name:'APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW', cat:c.So,   canon:k._0, block:b[80]},
			'2349':{ u:'2349', i:8088, name:'APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH', cat:c.So,   canon:k._0, block:b[80]},
			'2350':{ u:'2350', i:8095, name:'APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW', cat:c.So,   canon:k._0, block:b[80]},
			'2351':{ u:'2351', i:8096, name:'APL FUNCTIONAL SYMBOL UP TACK OVERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2352':{ u:'2352', i:8097, name:'APL FUNCTIONAL SYMBOL DEL STILE', cat:c.So,   canon:k._0, block:b[80]},
			'2353':{ u:'2353', i:8098, name:'APL FUNCTIONAL SYMBOL QUAD UP CARET', cat:c.So,   canon:k._0, block:b[80]},
			'2354':{ u:'2354', i:8099, name:'APL FUNCTIONAL SYMBOL QUAD DEL', cat:c.So,   canon:k._0, block:b[80]},
			'2355':{ u:'2355', i:8100, name:'APL FUNCTIONAL SYMBOL UP TACK JOT', cat:c.So,   canon:k._0, block:b[80]},
			'2356':{ u:'2356', i:8101, name:'APL FUNCTIONAL SYMBOL DOWNWARDS VANE', cat:c.So,   canon:k._0, block:b[80]},
			'2357':{ u:'2357', i:8102, name:'APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW', cat:c.So,   canon:k._0, block:b[80]},
			'2358':{ u:'2358', i:8103, name:'APL FUNCTIONAL SYMBOL QUOTE UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2359':{ u:'2359', i:8104, name:'APL FUNCTIONAL SYMBOL DELTA UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2360':{ u:'2360', i:8111, name:'APL FUNCTIONAL SYMBOL QUAD COLON', cat:c.So,   canon:k._0, block:b[80]},
			'2361':{ u:'2361', i:8112, name:'APL FUNCTIONAL SYMBOL UP TACK DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2362':{ u:'2362', i:8113, name:'APL FUNCTIONAL SYMBOL DEL DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2363':{ u:'2363', i:8114, name:'APL FUNCTIONAL SYMBOL STAR DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2364':{ u:'2364', i:8115, name:'APL FUNCTIONAL SYMBOL JOT DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2365':{ u:'2365', i:8116, name:'APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2366':{ u:'2366', i:8117, name:'APL FUNCTIONAL SYMBOL DOWN SHOE STILE', cat:c.So,   canon:k._0, block:b[80]},
			'2367':{ u:'2367', i:8118, name:'APL FUNCTIONAL SYMBOL LEFT SHOE STILE', cat:c.So,   canon:k._0, block:b[80]},
			'2368':{ u:'2368', i:8119, name:'APL FUNCTIONAL SYMBOL TILDE DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2369':{ u:'2369', i:8120, name:'APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS', cat:c.So,   canon:k._0, block:b[80]},
			'2370':{ u:'2370', i:8127, name:'APL FUNCTIONAL SYMBOL QUAD QUESTION', cat:c.So,   canon:k._0, block:b[80]},
			'2371':{ u:'2371', i:8128, name:'APL FUNCTIONAL SYMBOL DOWN CARET TILDE', cat:c.So,   canon:k._0, block:b[80]},
			'2372':{ u:'2372', i:8129, name:'APL FUNCTIONAL SYMBOL UP CARET TILDE', cat:c.So,   canon:k._0, block:b[80]},
			'2373':{ u:'2373', i:8130, name:'APL FUNCTIONAL SYMBOL IOTA', cat:c.So,   canon:k._0, block:b[80]},
			'2374':{ u:'2374', i:8131, name:'APL FUNCTIONAL SYMBOL RHO', cat:c.So,   canon:k._0, block:b[80]},
			'2375':{ u:'2375', i:8132, name:'APL FUNCTIONAL SYMBOL OMEGA', cat:c.So,   canon:k._0, block:b[80]},
			'2376':{ u:'2376', i:8133, name:'APL FUNCTIONAL SYMBOL ALPHA UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2377':{ u:'2377', i:8134, name:'APL FUNCTIONAL SYMBOL EPSILON UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2378':{ u:'2378', i:8135, name:'APL FUNCTIONAL SYMBOL IOTA UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2379':{ u:'2379', i:8136, name:'APL FUNCTIONAL SYMBOL OMEGA UNDERBAR', cat:c.So,   canon:k._0, block:b[80]},
			'2380':{ u:'2380', i:8143, name:'INSERTION SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2381':{ u:'2381', i:8144, name:'CONTINUOUS UNDERLINE SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2382':{ u:'2382', i:8145, name:'DISCONTINUOUS UNDERLINE SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2383':{ u:'2383', i:8146, name:'EMPHASIS SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2384':{ u:'2384', i:8147, name:'COMPOSITION SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2385':{ u:'2385', i:8148, name:'WHITE SQUARE WITH CENTRE VERTICAL LINE', cat:c.So,   canon:k._0, block:b[80]},
			'2386':{ u:'2386', i:8149, name:'ENTER SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2387':{ u:'2387', i:8150, name:'ALTERNATIVE KEY SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2388':{ u:'2388', i:8151, name:'HELM SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2389':{ u:'2389', i:8152, name:'CIRCLED HORIZONTAL BAR WITH NOTCH', cat:c.So,   canon:k._0, block:b[80]},
			'2390':{ u:'2390', i:8159, name:'OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2391':{ u:'2391', i:8160, name:'PASSIVE-PULL-DOWN-OUTPUT SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2392':{ u:'2392', i:8161, name:'PASSIVE-PULL-UP-OUTPUT SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2393':{ u:'2393', i:8162, name:'DIRECT CURRENT SYMBOL FORM TWO', cat:c.So,   canon:k._0, block:b[80]},
			'2394':{ u:'2394', i:8163, name:'SOFTWARE-FUNCTION SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2395':{ u:'2395', i:8164, name:'APL FUNCTIONAL SYMBOL QUAD', cat:c.So,   canon:k._0, block:b[80]},
			'2396':{ u:'2396', i:8165, name:'DECIMAL SEPARATOR KEY SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2397':{ u:'2397', i:8166, name:'PREVIOUS PAGE', cat:c.So,   canon:k._0, block:b[80]},
			'2398':{ u:'2398', i:8167, name:'NEXT PAGE', cat:c.So,   canon:k._0, block:b[80]},
			'2399':{ u:'2399', i:8168, name:'PRINT SCREEN SYMBOL', cat:c.So,   canon:k._0, block:b[80]},
			'2400':{ u:'2400', i:8271, name:'SYMBOL FOR NULL', cat:c.So,   canon:k._0, block:b[81]},
			'2401':{ u:'2401', i:8272, name:'SYMBOL FOR START OF HEADING', cat:c.So,   canon:k._0, block:b[81]},
			'2402':{ u:'2402', i:8273, name:'SYMBOL FOR START OF TEXT', cat:c.So,   canon:k._0, block:b[81]},
			'2403':{ u:'2403', i:8274, name:'SYMBOL FOR END OF TEXT', cat:c.So,   canon:k._0, block:b[81]},
			'2404':{ u:'2404', i:8275, name:'SYMBOL FOR END OF TRANSMISSION', cat:c.So,   canon:k._0, block:b[81]},
			'2405':{ u:'2405', i:8276, name:'SYMBOL FOR ENQUIRY', cat:c.So,   canon:k._0, block:b[81]},
			'2406':{ u:'2406', i:8277, name:'SYMBOL FOR ACKNOWLEDGE', cat:c.So,   canon:k._0, block:b[81]},
			'2407':{ u:'2407', i:8278, name:'SYMBOL FOR BELL', cat:c.So,   canon:k._0, block:b[81]},
			'2408':{ u:'2408', i:8279, name:'SYMBOL FOR BACKSPACE', cat:c.So,   canon:k._0, block:b[81]},
			'2409':{ u:'2409', i:8280, name:'SYMBOL FOR HORIZONTAL TABULATION', cat:c.So,   canon:k._0, block:b[81]},
			'2410':{ u:'2410', i:8287, name:'SYMBOL FOR DATA LINK ESCAPE', cat:c.So,   canon:k._0, block:b[81]},
			'2411':{ u:'2411', i:8288, name:'SYMBOL FOR DEVICE CONTROL ONE', cat:c.So,   canon:k._0, block:b[81]},
			'2412':{ u:'2412', i:8289, name:'SYMBOL FOR DEVICE CONTROL TWO', cat:c.So,   canon:k._0, block:b[81]},
			'2413':{ u:'2413', i:8290, name:'SYMBOL FOR DEVICE CONTROL THREE', cat:c.So,   canon:k._0, block:b[81]},
			'2414':{ u:'2414', i:8291, name:'SYMBOL FOR DEVICE CONTROL FOUR', cat:c.So,   canon:k._0, block:b[81]},
			'2415':{ u:'2415', i:8292, name:'SYMBOL FOR NEGATIVE ACKNOWLEDGE', cat:c.So,   canon:k._0, block:b[81]},
			'2416':{ u:'2416', i:8293, name:'SYMBOL FOR SYNCHRONOUS IDLE', cat:c.So,   canon:k._0, block:b[81]},
			'2417':{ u:'2417', i:8294, name:'SYMBOL FOR END OF TRANSMISSION BLOCK', cat:c.So,   canon:k._0, block:b[81]},
			'2418':{ u:'2418', i:8295, name:'SYMBOL FOR CANCEL', cat:c.So,   canon:k._0, block:b[81]},
			'2419':{ u:'2419', i:8296, name:'SYMBOL FOR END OF MEDIUM', cat:c.So,   canon:k._0, block:b[81]},
			'2420':{ u:'2420', i:8303, name:'SYMBOL FOR SPACE', cat:c.So,   canon:k._0, block:b[81]},
			'2421':{ u:'2421', i:8304, name:'SYMBOL FOR DELETE', cat:c.So,   canon:k._0, block:b[81]},
			'2422':{ u:'2422', i:8305, name:'BLANK SYMBOL', cat:c.So,   canon:k._0, block:b[81]},
			'2423':{ u:'2423', i:8306, name:'OPEN BOX', cat:c.So,   canon:k._0, block:b[81]},
			'2424':{ u:'2424', i:8307, name:'SYMBOL FOR NEWLINE', cat:c.So,   canon:k._0, block:b[81]},
			'2425':{ u:'2425', i:8308, name:'SYMBOL FOR DELETE FORM TWO', cat:c.So,   canon:k._0, block:b[81]},
			'2426':{ u:'2426', i:8309, name:'SYMBOL FOR SUBSTITUTE FORM TWO', cat:c.So,   canon:k._0, block:b[81]},
			'2440':{ u:'2440', i:8310, name:'OCR HOOK', cat:c.So,   canon:k._0, block:b[82]},
			'2441':{ u:'2441', i:8311, name:'OCR CHAIR', cat:c.So,   canon:k._0, block:b[82]},
			'2442':{ u:'2442', i:8312, name:'OCR FORK', cat:c.So,   canon:k._0, block:b[82]},
			'2443':{ u:'2443', i:8313, name:'OCR INVERTED FORK', cat:c.So,   canon:k._0, block:b[82]},
			'2444':{ u:'2444', i:8314, name:'OCR BELT BUCKLE', cat:c.So,   canon:k._0, block:b[82]},
			'2445':{ u:'2445', i:8315, name:'OCR BOW TIE', cat:c.So,   canon:k._0, block:b[82]},
			'2446':{ u:'2446', i:8316, name:'OCR BRANCH BANK IDENTIFICATION', cat:c.So,   canon:k._0, block:b[82]},
			'2447':{ u:'2447', i:8317, name:'OCR AMOUNT OF CHECK', cat:c.So,   canon:k._0, block:b[82]},
			'2448':{ u:'2448', i:8318, name:'OCR DASH', cat:c.So,   canon:k._0, block:b[82]},
			'2449':{ u:'2449', i:8319, name:'OCR CUSTOMER ACCOUNT NUMBER', cat:c.So,   canon:k._0, block:b[82]},
			'2460':{ u:'2460', i:8321, name:'CIRCLED DIGIT ONE', cat:c.No,  relatives:['0031'],  canon:k._0, block:b[83]},
			'2461':{ u:'2461', i:8322, name:'CIRCLED DIGIT TWO', cat:c.No,  relatives:['0032'],  canon:k._0, block:b[83]},
			'2462':{ u:'2462', i:8323, name:'CIRCLED DIGIT THREE', cat:c.No,  relatives:['0033'],  canon:k._0, block:b[83]},
			'2463':{ u:'2463', i:8324, name:'CIRCLED DIGIT FOUR', cat:c.No,  relatives:['0034'],  canon:k._0, block:b[83]},
			'2464':{ u:'2464', i:8325, name:'CIRCLED DIGIT FIVE', cat:c.No,  relatives:['0035'],  canon:k._0, block:b[83]},
			'2465':{ u:'2465', i:8326, name:'CIRCLED DIGIT SIX', cat:c.No,  relatives:['0036'],  canon:k._0, block:b[83]},
			'2466':{ u:'2466', i:8327, name:'CIRCLED DIGIT SEVEN', cat:c.No,  relatives:['0037'],  canon:k._0, block:b[83]},
			'2467':{ u:'2467', i:8328, name:'CIRCLED DIGIT EIGHT', cat:c.No,  relatives:['0038'],  canon:k._0, block:b[83]},
			'2468':{ u:'2468', i:8329, name:'CIRCLED DIGIT NINE', cat:c.No,  relatives:['0039'],  canon:k._0, block:b[83]},
			'2469':{ u:'2469', i:8330, name:'CIRCLED NUMBER TEN', cat:c.No,  relatives:['0031', '0030'], comp:['0031','0030'], canon:k._0, block:b[83]},
			'2470':{ u:'2470', i:8337, name:'CIRCLED NUMBER SEVENTEEN', cat:c.No,  relatives:['0031', '0037'], comp:['0031','0037'], canon:k._0, block:b[83]},
			'2471':{ u:'2471', i:8338, name:'CIRCLED NUMBER EIGHTEEN', cat:c.No,  relatives:['0031', '0038'], comp:['0031','0038'], canon:k._0, block:b[83]},
			'2472':{ u:'2472', i:8339, name:'CIRCLED NUMBER NINETEEN', cat:c.No,  relatives:['0031', '0039'], comp:['0031','0039'], canon:k._0, block:b[83]},
			'2473':{ u:'2473', i:8340, name:'CIRCLED NUMBER TWENTY', cat:c.No,  relatives:['0032', '0030'], comp:['0032','0030'], canon:k._0, block:b[83]},
			'2474':{ u:'2474', i:8341, name:'PARENTHESIZED DIGIT ONE', cat:c.No,  relatives:['0028', '0031', '0029'], comp:['0028','0031','0029'], canon:k._0, block:b[83]},
			'2475':{ u:'2475', i:8342, name:'PARENTHESIZED DIGIT TWO', cat:c.No,  relatives:['0028', '0032', '0029'], comp:['0028','0032','0029'], canon:k._0, block:b[83]},
			'2476':{ u:'2476', i:8343, name:'PARENTHESIZED DIGIT THREE', cat:c.No,  relatives:['0028', '0033', '0029'], comp:['0028','0033','0029'], canon:k._0, block:b[83]},
			'2477':{ u:'2477', i:8344, name:'PARENTHESIZED DIGIT FOUR', cat:c.No,  relatives:['0028', '0034', '0029'], comp:['0028','0034','0029'], canon:k._0, block:b[83]},
			'2478':{ u:'2478', i:8345, name:'PARENTHESIZED DIGIT FIVE', cat:c.No,  relatives:['0028', '0035', '0029'], comp:['0028','0035','0029'], canon:k._0, block:b[83]},
			'2479':{ u:'2479', i:8346, name:'PARENTHESIZED DIGIT SIX', cat:c.No,  relatives:['0028', '0036', '0029'], comp:['0028','0036','0029'], canon:k._0, block:b[83]},
			'2480':{ u:'2480', i:8353, name:'PARENTHESIZED NUMBER THIRTEEN', cat:c.No,  relatives:['0028', '0031', '0033', '0029'], comp:['0028','0031','0033','0029'], canon:k._0, block:b[83]},
			'2481':{ u:'2481', i:8354, name:'PARENTHESIZED NUMBER FOURTEEN', cat:c.No,  relatives:['0028', '0031', '0034', '0029'], comp:['0028','0031','0034','0029'], canon:k._0, block:b[83]},
			'2482':{ u:'2482', i:8355, name:'PARENTHESIZED NUMBER FIFTEEN', cat:c.No,  relatives:['0028', '0031', '0035', '0029'], comp:['0028','0031','0035','0029'], canon:k._0, block:b[83]},
			'2483':{ u:'2483', i:8356, name:'PARENTHESIZED NUMBER SIXTEEN', cat:c.No,  relatives:['0028', '0031', '0036', '0029'], comp:['0028','0031','0036','0029'], canon:k._0, block:b[83]},
			'2484':{ u:'2484', i:8357, name:'PARENTHESIZED NUMBER SEVENTEEN', cat:c.No,  relatives:['0028', '0031', '0037', '0029'], comp:['0028','0031','0037','0029'], canon:k._0, block:b[83]},
			'2485':{ u:'2485', i:8358, name:'PARENTHESIZED NUMBER EIGHTEEN', cat:c.No,  relatives:['0028', '0031', '0038', '0029'], comp:['0028','0031','0038','0029'], canon:k._0, block:b[83]},
			'2486':{ u:'2486', i:8359, name:'PARENTHESIZED NUMBER NINETEEN', cat:c.No,  relatives:['0028', '0031', '0039', '0029'], comp:['0028','0031','0039','0029'], canon:k._0, block:b[83]},
			'2487':{ u:'2487', i:8360, name:'PARENTHESIZED NUMBER TWENTY', cat:c.No,  relatives:['0028', '0032', '0030', '0029'], comp:['0028','0032','0030','0029'], canon:k._0, block:b[83]},
			'2488':{ u:'2488', i:8361, name:'DIGIT ONE FULL STOP', cat:c.No,  relatives:['0031', '002e'], comp:['0031','002e'], canon:k._0, block:b[83]},
			'2489':{ u:'2489', i:8362, name:'DIGIT TWO FULL STOP', cat:c.No,  relatives:['0032', '002e'], comp:['0032','002e'], canon:k._0, block:b[83]},
			'2490':{ u:'2490', i:8369, name:'DIGIT NINE FULL STOP', cat:c.No,  relatives:['0039', '002e'], comp:['0039','002e'], canon:k._0, block:b[83]},
			'2491':{ u:'2491', i:8370, name:'NUMBER TEN FULL STOP', cat:c.No,  relatives:['0031', '0030', '002e'], comp:['0031','0030','002e'], canon:k._0, block:b[83]},
			'2492':{ u:'2492', i:8371, name:'NUMBER ELEVEN FULL STOP', cat:c.No,  relatives:['0031', '002e'], comp:['0031','0031','002e'], canon:k._0, block:b[83]},
			'2493':{ u:'2493', i:8372, name:'NUMBER TWELVE FULL STOP', cat:c.No,  relatives:['0031', '0032', '002e'], comp:['0031','0032','002e'], canon:k._0, block:b[83]},
			'2494':{ u:'2494', i:8373, name:'NUMBER THIRTEEN FULL STOP', cat:c.No,  relatives:['0031', '0033', '002e'], comp:['0031','0033','002e'], canon:k._0, block:b[83]},
			'2495':{ u:'2495', i:8374, name:'NUMBER FOURTEEN FULL STOP', cat:c.No,  relatives:['0031', '0034', '002e'], comp:['0031','0034','002e'], canon:k._0, block:b[83]},
			'2496':{ u:'2496', i:8375, name:'NUMBER FIFTEEN FULL STOP', cat:c.No,  relatives:['0031', '0035', '002e'], comp:['0031','0035','002e'], canon:k._0, block:b[83]},
			'2497':{ u:'2497', i:8376, name:'NUMBER SIXTEEN FULL STOP', cat:c.No,  relatives:['0031', '0036', '002e'], comp:['0031','0036','002e'], canon:k._0, block:b[83]},
			'2498':{ u:'2498', i:8377, name:'NUMBER SEVENTEEN FULL STOP', cat:c.No,  relatives:['0031', '0037', '002e'], comp:['0031','0037','002e'], canon:k._0, block:b[83]},
			'2499':{ u:'2499', i:8378, name:'NUMBER EIGHTEEN FULL STOP', cat:c.No,  relatives:['0031', '0038', '002e'], comp:['0031','0038','002e'], canon:k._0, block:b[83]},
			'2500':{ u:'2500', i:8481, name:'BOX DRAWINGS LIGHT HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2501':{ u:'2501', i:8482, name:'BOX DRAWINGS HEAVY HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2502':{ u:'2502', i:8483, name:'BOX DRAWINGS LIGHT VERTICAL', cat:c.So,  relatives:['ffe8'],  canon:k._0, block:b[84]},
			'2503':{ u:'2503', i:8484, name:'BOX DRAWINGS HEAVY VERTICAL', cat:c.So,   canon:k._0, block:b[84]},
			'2504':{ u:'2504', i:8485, name:'BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2505':{ u:'2505', i:8486, name:'BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2506':{ u:'2506', i:8487, name:'BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL', cat:c.So,   canon:k._0, block:b[84]},
			'2507':{ u:'2507', i:8488, name:'BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL', cat:c.So,   canon:k._0, block:b[84]},
			'2508':{ u:'2508', i:8489, name:'BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2509':{ u:'2509', i:8490, name:'BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2510':{ u:'2510', i:8497, name:'BOX DRAWINGS LIGHT DOWN AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2511':{ u:'2511', i:8498, name:'BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2512':{ u:'2512', i:8499, name:'BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2513':{ u:'2513', i:8500, name:'BOX DRAWINGS HEAVY DOWN AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2514':{ u:'2514', i:8501, name:'BOX DRAWINGS LIGHT UP AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2515':{ u:'2515', i:8502, name:'BOX DRAWINGS UP LIGHT AND RIGHT HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2516':{ u:'2516', i:8503, name:'BOX DRAWINGS UP HEAVY AND RIGHT LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2517':{ u:'2517', i:8504, name:'BOX DRAWINGS HEAVY UP AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2518':{ u:'2518', i:8505, name:'BOX DRAWINGS LIGHT UP AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2519':{ u:'2519', i:8506, name:'BOX DRAWINGS UP LIGHT AND LEFT HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2520':{ u:'2520', i:8513, name:'BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2521':{ u:'2521', i:8514, name:'BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2522':{ u:'2522', i:8515, name:'BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2523':{ u:'2523', i:8516, name:'BOX DRAWINGS HEAVY VERTICAL AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2524':{ u:'2524', i:8517, name:'BOX DRAWINGS LIGHT VERTICAL AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2525':{ u:'2525', i:8518, name:'BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2526':{ u:'2526', i:8519, name:'BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2527':{ u:'2527', i:8520, name:'BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2528':{ u:'2528', i:8521, name:'BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2529':{ u:'2529', i:8522, name:'BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2530':{ u:'2530', i:8529, name:'BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2531':{ u:'2531', i:8530, name:'BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2532':{ u:'2532', i:8531, name:'BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2533':{ u:'2533', i:8532, name:'BOX DRAWINGS HEAVY DOWN AND HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2534':{ u:'2534', i:8533, name:'BOX DRAWINGS LIGHT UP AND HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2535':{ u:'2535', i:8534, name:'BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2536':{ u:'2536', i:8535, name:'BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2537':{ u:'2537', i:8536, name:'BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2538':{ u:'2538', i:8537, name:'BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2539':{ u:'2539', i:8538, name:'BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2540':{ u:'2540', i:8545, name:'BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2541':{ u:'2541', i:8546, name:'BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2542':{ u:'2542', i:8547, name:'BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2543':{ u:'2543', i:8548, name:'BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2544':{ u:'2544', i:8549, name:'BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2545':{ u:'2545', i:8550, name:'BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2546':{ u:'2546', i:8551, name:'BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2547':{ u:'2547', i:8552, name:'BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2548':{ u:'2548', i:8553, name:'BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2549':{ u:'2549', i:8554, name:'BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY', cat:c.So,   canon:k._0, block:b[84]},
			'2550':{ u:'2550', i:8561, name:'BOX DRAWINGS DOUBLE HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2551':{ u:'2551', i:8562, name:'BOX DRAWINGS DOUBLE VERTICAL', cat:c.So,   canon:k._0, block:b[84]},
			'2552':{ u:'2552', i:8563, name:'BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2553':{ u:'2553', i:8564, name:'BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2554':{ u:'2554', i:8565, name:'BOX DRAWINGS DOUBLE DOWN AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2555':{ u:'2555', i:8566, name:'BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2556':{ u:'2556', i:8567, name:'BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2557':{ u:'2557', i:8568, name:'BOX DRAWINGS DOUBLE DOWN AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2558':{ u:'2558', i:8569, name:'BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2559':{ u:'2559', i:8570, name:'BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2560':{ u:'2560', i:8577, name:'BOX DRAWINGS DOUBLE VERTICAL AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2561':{ u:'2561', i:8578, name:'BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2562':{ u:'2562', i:8579, name:'BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2563':{ u:'2563', i:8580, name:'BOX DRAWINGS DOUBLE VERTICAL AND LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2564':{ u:'2564', i:8581, name:'BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2565':{ u:'2565', i:8582, name:'BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2566':{ u:'2566', i:8583, name:'BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2567':{ u:'2567', i:8584, name:'BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE', cat:c.So,   canon:k._0, block:b[84]},
			'2568':{ u:'2568', i:8585, name:'BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE', cat:c.So,   canon:k._0, block:b[84]},
			'2569':{ u:'2569', i:8586, name:'BOX DRAWINGS DOUBLE UP AND HORIZONTAL', cat:c.So,   canon:k._0, block:b[84]},
			'2570':{ u:'2570', i:8593, name:'BOX DRAWINGS LIGHT ARC UP AND RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2571':{ u:'2571', i:8594, name:'BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2572':{ u:'2572', i:8595, name:'BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2573':{ u:'2573', i:8596, name:'BOX DRAWINGS LIGHT DIAGONAL CROSS', cat:c.So,   canon:k._0, block:b[84]},
			'2574':{ u:'2574', i:8597, name:'BOX DRAWINGS LIGHT LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2575':{ u:'2575', i:8598, name:'BOX DRAWINGS LIGHT UP', cat:c.So,   canon:k._0, block:b[84]},
			'2576':{ u:'2576', i:8599, name:'BOX DRAWINGS LIGHT RIGHT', cat:c.So,   canon:k._0, block:b[84]},
			'2577':{ u:'2577', i:8600, name:'BOX DRAWINGS LIGHT DOWN', cat:c.So,   canon:k._0, block:b[84]},
			'2578':{ u:'2578', i:8601, name:'BOX DRAWINGS HEAVY LEFT', cat:c.So,   canon:k._0, block:b[84]},
			'2579':{ u:'2579', i:8602, name:'BOX DRAWINGS HEAVY UP', cat:c.So,   canon:k._0, block:b[84]},
			'2580':{ u:'2580', i:8609, name:'UPPER HALF BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2581':{ u:'2581', i:8610, name:'LOWER ONE EIGHTH BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2582':{ u:'2582', i:8611, name:'LOWER ONE QUARTER BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2583':{ u:'2583', i:8612, name:'LOWER THREE EIGHTHS BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2584':{ u:'2584', i:8613, name:'LOWER HALF BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2585':{ u:'2585', i:8614, name:'LOWER FIVE EIGHTHS BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2586':{ u:'2586', i:8615, name:'LOWER THREE QUARTERS BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2587':{ u:'2587', i:8616, name:'LOWER SEVEN EIGHTHS BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2588':{ u:'2588', i:8617, name:'FULL BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2589':{ u:'2589', i:8618, name:'LEFT SEVEN EIGHTHS BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2590':{ u:'2590', i:8625, name:'RIGHT HALF BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2591':{ u:'2591', i:8626, name:'LIGHT SHADE', cat:c.So,   canon:k._0, block:b[85]},
			'2592':{ u:'2592', i:8627, name:'MEDIUM SHADE', cat:c.So,   canon:k._0, block:b[85]},
			'2593':{ u:'2593', i:8628, name:'DARK SHADE', cat:c.So,   canon:k._0, block:b[85]},
			'2594':{ u:'2594', i:8629, name:'UPPER ONE EIGHTH BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2595':{ u:'2595', i:8630, name:'RIGHT ONE EIGHTH BLOCK', cat:c.So,   canon:k._0, block:b[85]},
			'2596':{ u:'2596', i:8631, name:'QUADRANT LOWER LEFT', cat:c.So,   canon:k._0, block:b[85]},
			'2597':{ u:'2597', i:8632, name:'QUADRANT LOWER RIGHT', cat:c.So,   canon:k._0, block:b[85]},
			'2598':{ u:'2598', i:8633, name:'QUADRANT UPPER LEFT', cat:c.So,   canon:k._0, block:b[85]},
			'2599':{ u:'2599', i:8634, name:'QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT', cat:c.So,   canon:k._0, block:b[85]},
			'2600':{ u:'2600', i:8737, name:'BLACK SUN WITH RAYS', cat:c.So,   canon:k._0, block:b[87]},
			'2601':{ u:'2601', i:8738, name:'CLOUD', cat:c.So,   canon:k._0, block:b[87]},
			'2602':{ u:'2602', i:8739, name:'UMBRELLA', cat:c.So,   canon:k._0, block:b[87]},
			'2603':{ u:'2603', i:8740, name:'SNOWMAN', cat:c.So,   canon:k._0, block:b[87]},
			'2604':{ u:'2604', i:8741, name:'COMET', cat:c.So,   canon:k._0, block:b[87]},
			'2605':{ u:'2605', i:8742, name:'BLACK STAR', cat:c.So,   canon:k._0, block:b[87]},
			'2606':{ u:'2606', i:8743, name:'WHITE STAR', cat:c.So,   canon:k._0, block:b[87]},
			'2607':{ u:'2607', i:8744, name:'LIGHTNING', cat:c.So,   canon:k._0, block:b[87]},
			'2608':{ u:'2608', i:8745, name:'THUNDERSTORM', cat:c.So,   canon:k._0, block:b[87]},
			'2609':{ u:'2609', i:8746, name:'SUN', cat:c.So,   canon:k._0, block:b[87]},
			'2610':{ u:'2610', i:8753, name:'BALLOT BOX', cat:c.So,   canon:k._0, block:b[87]},
			'2611':{ u:'2611', i:8754, name:'BALLOT BOX WITH CHECK', cat:c.So,   canon:k._0, block:b[87]},
			'2612':{ u:'2612', i:8755, name:'BALLOT BOX WITH X', cat:c.So,   canon:k._0, block:b[87], indexed:["X"]},
			'2613':{ u:'2613', i:8756, name:'SALTIRE', cat:c.So,   canon:k._0, block:b[87]},
			'2614':{ u:'2614', i:8757, name:'UMBRELLA WITH RAIN DROPS', cat:c.So,   canon:k._0, block:b[87]},
			'2615':{ u:'2615', i:8758, name:'HOT BEVERAGE', cat:c.So,   canon:k._0, block:b[87]},
			'2616':{ u:'2616', i:8759, name:'WHITE SHOGI PIECE', cat:c.So,   canon:k._0, block:b[87]},
			'2617':{ u:'2617', i:8760, name:'BLACK SHOGI PIECE', cat:c.So,   canon:k._0, block:b[87]},
			'2618':{ u:'2618', i:8761, name:'SHAMROCK', cat:c.So,   canon:k._0, block:b[87]},
			'2619':{ u:'2619', i:8762, name:'REVERSED ROTATED FLORAL HEART BULLET', cat:c.So,   canon:k._0, block:b[87]},
			'2620':{ u:'2620', i:8769, name:'SKULL AND CROSSBONES', cat:c.So,   canon:k._0, block:b[87]},
			'2621':{ u:'2621', i:8770, name:'CAUTION SIGN', cat:c.So,   canon:k._0, block:b[87]},
			'2622':{ u:'2622', i:8771, name:'RADIOACTIVE SIGN', cat:c.So,   canon:k._0, block:b[87]},
			'2623':{ u:'2623', i:8772, name:'BIOHAZARD SIGN', cat:c.So,   canon:k._0, block:b[87]},
			'2624':{ u:'2624', i:8773, name:'CADUCEUS', cat:c.So,   canon:k._0, block:b[87]},
			'2625':{ u:'2625', i:8774, name:'ANKH', cat:c.So,   canon:k._0, block:b[87]},
			'2626':{ u:'2626', i:8775, name:'ORTHODOX CROSS', cat:c.So,   canon:k._0, block:b[87]},
			'2627':{ u:'2627', i:8776, name:'CHI RHO', cat:c.So,   canon:k._0, block:b[87]},
			'2628':{ u:'2628', i:8777, name:'CROSS OF LORRAINE', cat:c.So,   canon:k._0, block:b[87]},
			'2629':{ u:'2629', i:8778, name:'CROSS OF JERUSALEM', cat:c.So,   canon:k._0, block:b[87]},
			'2630':{ u:'2630', i:8785, name:'TRIGRAM FOR HEAVEN', cat:c.So,   canon:k._0, block:b[87]},
			'2631':{ u:'2631', i:8786, name:'TRIGRAM FOR LAKE', cat:c.So,   canon:k._0, block:b[87]},
			'2632':{ u:'2632', i:8787, name:'TRIGRAM FOR FIRE', cat:c.So,   canon:k._0, block:b[87]},
			'2633':{ u:'2633', i:8788, name:'TRIGRAM FOR THUNDER', cat:c.So,   canon:k._0, block:b[87]},
			'2634':{ u:'2634', i:8789, name:'TRIGRAM FOR WIND', cat:c.So,   canon:k._0, block:b[87]},
			'2635':{ u:'2635', i:8790, name:'TRIGRAM FOR WATER', cat:c.So,   canon:k._0, block:b[87]},
			'2636':{ u:'2636', i:8791, name:'TRIGRAM FOR MOUNTAIN', cat:c.So,   canon:k._0, block:b[87]},
			'2637':{ u:'2637', i:8792, name:'TRIGRAM FOR EARTH', cat:c.So,   canon:k._0, block:b[87]},
			'2638':{ u:'2638', i:8793, name:'WHEEL OF DHARMA', cat:c.So,   canon:k._0, block:b[87]},
			'2639':{ u:'2639', i:8794, name:'WHITE FROWNING FACE', cat:c.So,   canon:k._0, block:b[87]},
			'2640':{ u:'2640', i:8801, name:'FEMALE SIGN', cat:c.So,   canon:k._0, block:b[87]},
			'2641':{ u:'2641', i:8802, name:'EARTH', cat:c.So,   canon:k._0, block:b[87]},
			'2642':{ u:'2642', i:8803, name:'MALE SIGN', cat:c.So,   canon:k._0, block:b[87]},
			'2643':{ u:'2643', i:8804, name:'JUPITER', cat:c.So,   canon:k._0, block:b[87]},
			'2644':{ u:'2644', i:8805, name:'SATURN', cat:c.So,   canon:k._0, block:b[87]},
			'2645':{ u:'2645', i:8806, name:'URANUS', cat:c.So,   canon:k._0, block:b[87]},
			'2646':{ u:'2646', i:8807, name:'NEPTUNE', cat:c.So,   canon:k._0, block:b[87]},
			'2647':{ u:'2647', i:8808, name:'PLUTO', cat:c.So,   canon:k._0, block:b[87]},
			'2648':{ u:'2648', i:8809, name:'ARIES', cat:c.So,   canon:k._0, block:b[87]},
			'2649':{ u:'2649', i:8810, name:'TAURUS', cat:c.So,   canon:k._0, block:b[87]},
			'2650':{ u:'2650', i:8817, name:'SAGITTARIUS', cat:c.So,   canon:k._0, block:b[87]},
			'2651':{ u:'2651', i:8818, name:'CAPRICORN', cat:c.So,   canon:k._0, block:b[87]},
			'2652':{ u:'2652', i:8819, name:'AQUARIUS', cat:c.So,   canon:k._0, block:b[87]},
			'2653':{ u:'2653', i:8820, name:'PISCES', cat:c.So,   canon:k._0, block:b[87]},
			'2654':{ u:'2654', i:8821, name:'WHITE CHESS KING', cat:c.So,   canon:k._0, block:b[87]},
			'2655':{ u:'2655', i:8822, name:'WHITE CHESS QUEEN', cat:c.So,   canon:k._0, block:b[87]},
			'2656':{ u:'2656', i:8823, name:'WHITE CHESS ROOK', cat:c.So,   canon:k._0, block:b[87]},
			'2657':{ u:'2657', i:8824, name:'WHITE CHESS BISHOP', cat:c.So,   canon:k._0, block:b[87]},
			'2658':{ u:'2658', i:8825, name:'WHITE CHESS KNIGHT', cat:c.So,   canon:k._0, block:b[87]},
			'2659':{ u:'2659', i:8826, name:'WHITE CHESS PAWN', cat:c.So,   canon:k._0, block:b[87]},
			'2660':{ u:'2660', i:8833, name:'BLACK SPADE SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2661':{ u:'2661', i:8834, name:'WHITE HEART SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2662':{ u:'2662', i:8835, name:'WHITE DIAMOND SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2663':{ u:'2663', i:8836, name:'BLACK CLUB SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2664':{ u:'2664', i:8837, name:'WHITE SPADE SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2665':{ u:'2665', i:8838, name:'BLACK HEART SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2666':{ u:'2666', i:8839, name:'BLACK DIAMOND SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2667':{ u:'2667', i:8840, name:'WHITE CLUB SUIT', cat:c.So,   canon:k._0, block:b[87]},
			'2668':{ u:'2668', i:8841, name:'HOT SPRINGS', cat:c.So,   canon:k._0, block:b[87]},
			'2669':{ u:'2669', i:8842, name:'QUARTER NOTE', cat:c.So,   canon:k._0, block:b[87]},
			'2670':{ u:'2670', i:8849, name:'WEST SYRIAC CROSS', cat:c.So,   canon:k._0, block:b[87]},
			'2671':{ u:'2671', i:8850, name:'EAST SYRIAC CROSS', cat:c.So,   canon:k._0, block:b[87]},
			'2672':{ u:'2672', i:8851, name:'UNIVERSAL RECYCLING SYMBOL', cat:c.So,   canon:k._0, block:b[87]},
			'2673':{ u:'2673', i:8852, name:'RECYCLING SYMBOL FOR TYPE-1 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2674':{ u:'2674', i:8853, name:'RECYCLING SYMBOL FOR TYPE-2 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2675':{ u:'2675', i:8854, name:'RECYCLING SYMBOL FOR TYPE-3 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2676':{ u:'2676', i:8855, name:'RECYCLING SYMBOL FOR TYPE-4 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2677':{ u:'2677', i:8856, name:'RECYCLING SYMBOL FOR TYPE-5 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2678':{ u:'2678', i:8857, name:'RECYCLING SYMBOL FOR TYPE-6 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2679':{ u:'2679', i:8858, name:'RECYCLING SYMBOL FOR TYPE-7 PLASTICS', cat:c.So,   canon:k._0, block:b[87]},
			'2680':{ u:'2680', i:8865, name:'DIE FACE-1', cat:c.So,   canon:k._0, block:b[87]},
			'2681':{ u:'2681', i:8866, name:'DIE FACE-2', cat:c.So,   canon:k._0, block:b[87]},
			'2682':{ u:'2682', i:8867, name:'DIE FACE-3', cat:c.So,   canon:k._0, block:b[87]},
			'2683':{ u:'2683', i:8868, name:'DIE FACE-4', cat:c.So,   canon:k._0, block:b[87]},
			'2684':{ u:'2684', i:8869, name:'DIE FACE-5', cat:c.So,   canon:k._0, block:b[87]},
			'2685':{ u:'2685', i:8870, name:'DIE FACE-6', cat:c.So,   canon:k._0, block:b[87]},
			'2686':{ u:'2686', i:8871, name:'WHITE CIRCLE WITH DOT RIGHT', cat:c.So,   canon:k._0, block:b[87]},
			'2687':{ u:'2687', i:8872, name:'WHITE CIRCLE WITH TWO DOTS', cat:c.So,   canon:k._0, block:b[87]},
			'2688':{ u:'2688', i:8873, name:'BLACK CIRCLE WITH WHITE DOT RIGHT', cat:c.So,   canon:k._0, block:b[87]},
			'2689':{ u:'2689', i:8874, name:'BLACK CIRCLE WITH TWO WHITE DOTS', cat:c.So,   canon:k._0, block:b[87]},
			'2690':{ u:'2690', i:8881, name:'WHITE FLAG', cat:c.So,   canon:k._0, block:b[87]},
			'2691':{ u:'2691', i:8882, name:'BLACK FLAG', cat:c.So,   canon:k._0, block:b[87]},
			'2692':{ u:'2692', i:8883, name:'HAMMER AND PICK', cat:c.So,   canon:k._0, block:b[87]},
			'2693':{ u:'2693', i:8884, name:'ANCHOR', cat:c.So,   canon:k._0, block:b[87]},
			'2694':{ u:'2694', i:8885, name:'CROSSED SWORDS', cat:c.So,   canon:k._0, block:b[87]},
			'2695':{ u:'2695', i:8886, name:'STAFF OF AESCULAPIUS', cat:c.So,   canon:k._0, block:b[87]},
			'2696':{ u:'2696', i:8887, name:'SCALES', cat:c.So,   canon:k._0, block:b[87]},
			'2697':{ u:'2697', i:8888, name:'ALEMBIC', cat:c.So,   canon:k._0, block:b[87]},
			'2698':{ u:'2698', i:8889, name:'FLOWER', cat:c.So,   canon:k._0, block:b[87]},
			'2699':{ u:'2699', i:8890, name:'GEAR', cat:c.So,   canon:k._0, block:b[87]},
			'2700':{ u:'2700', i:8993, name:'BLACK SAFETY SCISSORS', cat:c.So,   canon:k._0, block:b[88]},
			'2701':{ u:'2701', i:8994, name:'UPPER BLADE SCISSORS', cat:c.So,   canon:k._0, block:b[88]},
			'2702':{ u:'2702', i:8995, name:'BLACK SCISSORS', cat:c.So,   canon:k._0, block:b[88]},
			'2703':{ u:'2703', i:8996, name:'LOWER BLADE SCISSORS', cat:c.So,   canon:k._0, block:b[88]},
			'2704':{ u:'2704', i:8997, name:'WHITE SCISSORS', cat:c.So,   canon:k._0, block:b[88]},
			'2705':{ u:'2705', i:8998, name:'WHITE HEAVY CHECK MARK', cat:c.So,   canon:k._0, block:b[88]},
			'2706':{ u:'2706', i:8999, name:'TELEPHONE LOCATION SIGN', cat:c.So,   canon:k._0, block:b[88]},
			'2707':{ u:'2707', i:9000, name:'TAPE DRIVE', cat:c.So,   canon:k._0, block:b[88]},
			'2708':{ u:'2708', i:9001, name:'AIRPLANE', cat:c.So,   canon:k._0, block:b[88]},
			'2709':{ u:'2709', i:9002, name:'ENVELOPE', cat:c.So,   canon:k._0, block:b[88]},
			'2710':{ u:'2710', i:9009, name:'UPPER RIGHT PENCIL', cat:c.So,   canon:k._0, block:b[88]},
			'2711':{ u:'2711', i:9010, name:'WHITE NIB', cat:c.So,   canon:k._0, block:b[88]},
			'2712':{ u:'2712', i:9011, name:'BLACK NIB', cat:c.So,   canon:k._0, block:b[88]},
			'2713':{ u:'2713', i:9012, name:'CHECK MARK', cat:c.So,   canon:k._0, block:b[88]},
			'2714':{ u:'2714', i:9013, name:'HEAVY CHECK MARK', cat:c.So,   canon:k._0, block:b[88]},
			'2715':{ u:'2715', i:9014, name:'MULTIPLICATION X', cat:c.So,   canon:k._0, block:b[88], indexed:["X"]},
			'2716':{ u:'2716', i:9015, name:'HEAVY MULTIPLICATION X', cat:c.So,   canon:k._0, block:b[88], indexed:["X"]},
			'2717':{ u:'2717', i:9016, name:'BALLOT X', cat:c.So,   canon:k._0, block:b[88], indexed:["X"]},
			'2718':{ u:'2718', i:9017, name:'HEAVY BALLOT X', cat:c.So,   canon:k._0, block:b[88], indexed:["X"]},
			'2719':{ u:'2719', i:9018, name:'OUTLINED GREEK CROSS', cat:c.So,   canon:k._0, block:b[88]},
			'2720':{ u:'2720', i:9025, name:'MALTESE CROSS', cat:c.So,   canon:k._0, block:b[88]},
			'2721':{ u:'2721', i:9026, name:'STAR OF DAVID', cat:c.So,   canon:k._0, block:b[88]},
			'2722':{ u:'2722', i:9027, name:'FOUR TEARDROP-SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2723':{ u:'2723', i:9028, name:'FOUR BALLOON-SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2724':{ u:'2724', i:9029, name:'HEAVY FOUR BALLOON-SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2725':{ u:'2725', i:9030, name:'FOUR CLUB-SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2726':{ u:'2726', i:9031, name:'BLACK FOUR POINTED STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2727':{ u:'2727', i:9032, name:'WHITE FOUR POINTED STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2728':{ u:'2728', i:9033, name:'SPARKLES', cat:c.So,   canon:k._0, block:b[88]},
			'2729':{ u:'2729', i:9034, name:'STRESS OUTLINED WHITE STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2730':{ u:'2730', i:9041, name:'SHADOWED WHITE STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2731':{ u:'2731', i:9042, name:'HEAVY ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2732':{ u:'2732', i:9043, name:'OPEN CENTRE ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2733':{ u:'2733', i:9044, name:'EIGHT SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2734':{ u:'2734', i:9045, name:'EIGHT POINTED BLACK STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2735':{ u:'2735', i:9046, name:'EIGHT POINTED PINWHEEL STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2736':{ u:'2736', i:9047, name:'SIX POINTED BLACK STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2737':{ u:'2737', i:9048, name:'EIGHT POINTED RECTILINEAR BLACK STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2738':{ u:'2738', i:9049, name:'HEAVY EIGHT POINTED RECTILINEAR BLACK STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2739':{ u:'2739', i:9050, name:'TWELVE POINTED BLACK STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2740':{ u:'2740', i:9057, name:'WHITE FLORETTE', cat:c.So,   canon:k._0, block:b[88]},
			'2741':{ u:'2741', i:9058, name:'EIGHT PETALLED OUTLINED BLACK FLORETTE', cat:c.So,   canon:k._0, block:b[88]},
			'2742':{ u:'2742', i:9059, name:'CIRCLED OPEN CENTRE EIGHT POINTED STAR', cat:c.So,   canon:k._0, block:b[88]},
			'2743':{ u:'2743', i:9060, name:'HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2744':{ u:'2744', i:9061, name:'SNOWFLAKE', cat:c.So,   canon:k._0, block:b[88]},
			'2745':{ u:'2745', i:9062, name:'TIGHT TRIFOLIATE SNOWFLAKE', cat:c.So,   canon:k._0, block:b[88]},
			'2746':{ u:'2746', i:9063, name:'HEAVY CHEVRON SNOWFLAKE', cat:c.So,   canon:k._0, block:b[88]},
			'2747':{ u:'2747', i:9064, name:'SPARKLE', cat:c.So,   canon:k._0, block:b[88]},
			'2748':{ u:'2748', i:9065, name:'HEAVY SPARKLE', cat:c.So,   canon:k._0, block:b[88]},
			'2749':{ u:'2749', i:9066, name:'BALLOON-SPOKED ASTERISK', cat:c.So,   canon:k._0, block:b[88]},
			'2750':{ u:'2750', i:9073, name:'UPPER RIGHT DROP-SHADOWED WHITE SQUARE', cat:c.So,   canon:k._0, block:b[88]},
			'2751':{ u:'2751', i:9074, name:'LOWER RIGHT SHADOWED WHITE SQUARE', cat:c.So,   canon:k._0, block:b[88]},
			'2752':{ u:'2752', i:9075, name:'UPPER RIGHT SHADOWED WHITE SQUARE', cat:c.So,   canon:k._0, block:b[88]},
			'2753':{ u:'2753', i:9076, name:'BLACK QUESTION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2754':{ u:'2754', i:9077, name:'WHITE QUESTION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2755':{ u:'2755', i:9078, name:'WHITE EXCLAMATION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2756':{ u:'2756', i:9079, name:'BLACK DIAMOND MINUS WHITE X', cat:c.So,   canon:k._0, block:b[88], indexed:["X"]},
			'2757':{ u:'2757', i:9080, name:'HEAVY EXCLAMATION MARK SYMBOL', cat:c.So,   canon:k._0, block:b[88]},
			'2758':{ u:'2758', i:9081, name:'LIGHT VERTICAL BAR', cat:c.So,   canon:k._0, block:b[88]},
			'2759':{ u:'2759', i:9082, name:'MEDIUM VERTICAL BAR', cat:c.So,   canon:k._0, block:b[88]},
			'2760':{ u:'2760', i:9089, name:'HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2761':{ u:'2761', i:9090, name:'CURVED STEM PARAGRAPH SIGN ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2762':{ u:'2762', i:9091, name:'HEAVY EXCLAMATION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2763':{ u:'2763', i:9092, name:'HEAVY HEART EXCLAMATION MARK ORNAMENT', cat:c.So,   canon:k._0, block:b[88]},
			'2764':{ u:'2764', i:9093, name:'HEAVY BLACK HEART', cat:c.So,   canon:k._0, block:b[88]},
			'2765':{ u:'2765', i:9094, name:'ROTATED HEAVY BLACK HEART BULLET', cat:c.So,   canon:k._0, block:b[88]},
			'2766':{ u:'2766', i:9095, name:'FLORAL HEART', cat:c.So,   canon:k._0, block:b[88]},
			'2767':{ u:'2767', i:9096, name:'ROTATED FLORAL HEART BULLET', cat:c.So,   canon:k._0, block:b[88]},
			'2768':{ u:'2768', i:9097, name:'MEDIUM LEFT PARENTHESIS ORNAMENT', cat:c.Ps,   canon:k._0, block:b[88]},
			'2769':{ u:'2769', i:9098, name:'MEDIUM RIGHT PARENTHESIS ORNAMENT', cat:c.Pe,   canon:k._0, block:b[88]},
			'2770':{ u:'2770', i:9105, name:'HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT', cat:c.Ps,   canon:k._0, block:b[88]},
			'2771':{ u:'2771', i:9106, name:'HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT', cat:c.Pe,   canon:k._0, block:b[88]},
			'2772':{ u:'2772', i:9107, name:'LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT', cat:c.Ps,   canon:k._0, block:b[88]},
			'2773':{ u:'2773', i:9108, name:'LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT', cat:c.Pe,   canon:k._0, block:b[88]},
			'2774':{ u:'2774', i:9109, name:'MEDIUM LEFT CURLY BRACKET ORNAMENT', cat:c.Ps,   canon:k._0, block:b[88]},
			'2775':{ u:'2775', i:9110, name:'MEDIUM RIGHT CURLY BRACKET ORNAMENT', cat:c.Pe,   canon:k._0, block:b[88]},
			'2776':{ u:'2776', i:9111, name:'DINGBAT NEGATIVE CIRCLED DIGIT ONE', cat:c.No,   canon:k._0, block:b[88]},
			'2777':{ u:'2777', i:9112, name:'DINGBAT NEGATIVE CIRCLED DIGIT TWO', cat:c.No,   canon:k._0, block:b[88]},
			'2778':{ u:'2778', i:9113, name:'DINGBAT NEGATIVE CIRCLED DIGIT THREE', cat:c.No,   canon:k._0, block:b[88]},
			'2779':{ u:'2779', i:9114, name:'DINGBAT NEGATIVE CIRCLED DIGIT FOUR', cat:c.No,   canon:k._0, block:b[88]},
			'2780':{ u:'2780', i:9121, name:'DINGBAT CIRCLED SANS-SERIF DIGIT ONE', cat:c.No,   canon:k._0, block:b[88]},
			'2781':{ u:'2781', i:9122, name:'DINGBAT CIRCLED SANS-SERIF DIGIT TWO', cat:c.No,   canon:k._0, block:b[88]},
			'2782':{ u:'2782', i:9123, name:'DINGBAT CIRCLED SANS-SERIF DIGIT THREE', cat:c.No,   canon:k._0, block:b[88]},
			'2783':{ u:'2783', i:9124, name:'DINGBAT CIRCLED SANS-SERIF DIGIT FOUR', cat:c.No,   canon:k._0, block:b[88]},
			'2784':{ u:'2784', i:9125, name:'DINGBAT CIRCLED SANS-SERIF DIGIT FIVE', cat:c.No,   canon:k._0, block:b[88]},
			'2785':{ u:'2785', i:9126, name:'DINGBAT CIRCLED SANS-SERIF DIGIT SIX', cat:c.No,   canon:k._0, block:b[88]},
			'2786':{ u:'2786', i:9127, name:'DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN', cat:c.No,   canon:k._0, block:b[88]},
			'2787':{ u:'2787', i:9128, name:'DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT', cat:c.No,   canon:k._0, block:b[88]},
			'2788':{ u:'2788', i:9129, name:'DINGBAT CIRCLED SANS-SERIF DIGIT NINE', cat:c.No,   canon:k._0, block:b[88]},
			'2789':{ u:'2789', i:9130, name:'DINGBAT CIRCLED SANS-SERIF NUMBER TEN', cat:c.No,   canon:k._0, block:b[88]},
			'2790':{ u:'2790', i:9137, name:'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN', cat:c.No,   canon:k._0, block:b[88]},
			'2791':{ u:'2791', i:9138, name:'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT', cat:c.No,   canon:k._0, block:b[88]},
			'2792':{ u:'2792', i:9139, name:'DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE', cat:c.No,   canon:k._0, block:b[88]},
			'2793':{ u:'2793', i:9140, name:'DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN', cat:c.No,   canon:k._0, block:b[88]},
			'2794':{ u:'2794', i:9141, name:'HEAVY WIDE-HEADED RIGHTWARDS ARROW', cat:c.So,   canon:k._0, block:b[88]},
			'2795':{ u:'2795', i:9142, name:'HEAVY PLUS SIGN', cat:c.So,   canon:k._0, block:b[88]},
			'2796':{ u:'2796', i:9143, name:'HEAVY MINUS SIGN', cat:c.So,   canon:k._0, block:b[88]},
			'2797':{ u:'2797', i:9144, name:'HEAVY DIVISION SIGN', cat:c.So,   canon:k._0, block:b[88]},
			'2798':{ u:'2798', i:9145, name:'HEAVY SOUTH EAST ARROW', cat:c.So,   canon:k._0, block:b[88]},
			'2799':{ u:'2799', i:9146, name:'HEAVY RIGHTWARDS ARROW', cat:c.So,   canon:k._0, block:b[88]},
			'2800':{ u:'2800', i:9249, name:'BRAILLE PATTERN BLANK', cat:c.So,   canon:k._0, block:b[91]},
			'2801':{ u:'2801', i:9250, name:'BRAILLE PATTERN DOTS-1', cat:c.So,   canon:k._0, block:b[91]},
			'2802':{ u:'2802', i:9251, name:'BRAILLE PATTERN DOTS-2', cat:c.So,   canon:k._0, block:b[91]},
			'2803':{ u:'2803', i:9252, name:'BRAILLE PATTERN DOTS-12', cat:c.So,   canon:k._0, block:b[91]},
			'2804':{ u:'2804', i:9253, name:'BRAILLE PATTERN DOTS-3', cat:c.So,   canon:k._0, block:b[91]},
			'2805':{ u:'2805', i:9254, name:'BRAILLE PATTERN DOTS-13', cat:c.So,   canon:k._0, block:b[91]},
			'2806':{ u:'2806', i:9255, name:'BRAILLE PATTERN DOTS-23', cat:c.So,   canon:k._0, block:b[91]},
			'2807':{ u:'2807', i:9256, name:'BRAILLE PATTERN DOTS-123', cat:c.So,   canon:k._0, block:b[91]},
			'2808':{ u:'2808', i:9257, name:'BRAILLE PATTERN DOTS-4', cat:c.So,   canon:k._0, block:b[91]},
			'2809':{ u:'2809', i:9258, name:'BRAILLE PATTERN DOTS-14', cat:c.So,   canon:k._0, block:b[91]},
			'2810':{ u:'2810', i:9265, name:'BRAILLE PATTERN DOTS-5', cat:c.So,   canon:k._0, block:b[91]},
			'2811':{ u:'2811', i:9266, name:'BRAILLE PATTERN DOTS-15', cat:c.So,   canon:k._0, block:b[91]},
			'2812':{ u:'2812', i:9267, name:'BRAILLE PATTERN DOTS-25', cat:c.So,   canon:k._0, block:b[91]},
			'2813':{ u:'2813', i:9268, name:'BRAILLE PATTERN DOTS-125', cat:c.So,   canon:k._0, block:b[91]},
			'2814':{ u:'2814', i:9269, name:'BRAILLE PATTERN DOTS-35', cat:c.So,   canon:k._0, block:b[91]},
			'2815':{ u:'2815', i:9270, name:'BRAILLE PATTERN DOTS-135', cat:c.So,   canon:k._0, block:b[91]},
			'2816':{ u:'2816', i:9271, name:'BRAILLE PATTERN DOTS-235', cat:c.So,   canon:k._0, block:b[91]},
			'2817':{ u:'2817', i:9272, name:'BRAILLE PATTERN DOTS-1235', cat:c.So,   canon:k._0, block:b[91]},
			'2818':{ u:'2818', i:9273, name:'BRAILLE PATTERN DOTS-45', cat:c.So,   canon:k._0, block:b[91]},
			'2819':{ u:'2819', i:9274, name:'BRAILLE PATTERN DOTS-145', cat:c.So,   canon:k._0, block:b[91]},
			'2820':{ u:'2820', i:9281, name:'BRAILLE PATTERN DOTS-6', cat:c.So,   canon:k._0, block:b[91]},
			'2821':{ u:'2821', i:9282, name:'BRAILLE PATTERN DOTS-16', cat:c.So,   canon:k._0, block:b[91]},
			'2822':{ u:'2822', i:9283, name:'BRAILLE PATTERN DOTS-26', cat:c.So,   canon:k._0, block:b[91]},
			'2823':{ u:'2823', i:9284, name:'BRAILLE PATTERN DOTS-126', cat:c.So,   canon:k._0, block:b[91]},
			'2824':{ u:'2824', i:9285, name:'BRAILLE PATTERN DOTS-36', cat:c.So,   canon:k._0, block:b[91]},
			'2825':{ u:'2825', i:9286, name:'BRAILLE PATTERN DOTS-136', cat:c.So,   canon:k._0, block:b[91]},
			'2826':{ u:'2826', i:9287, name:'BRAILLE PATTERN DOTS-236', cat:c.So,   canon:k._0, block:b[91]},
			'2827':{ u:'2827', i:9288, name:'BRAILLE PATTERN DOTS-1236', cat:c.So,   canon:k._0, block:b[91]},
			'2828':{ u:'2828', i:9289, name:'BRAILLE PATTERN DOTS-46', cat:c.So,   canon:k._0, block:b[91]},
			'2829':{ u:'2829', i:9290, name:'BRAILLE PATTERN DOTS-146', cat:c.So,   canon:k._0, block:b[91]},
			'2830':{ u:'2830', i:9297, name:'BRAILLE PATTERN DOTS-56', cat:c.So,   canon:k._0, block:b[91]},
			'2831':{ u:'2831', i:9298, name:'BRAILLE PATTERN DOTS-156', cat:c.So,   canon:k._0, block:b[91]},
			'2832':{ u:'2832', i:9299, name:'BRAILLE PATTERN DOTS-256', cat:c.So,   canon:k._0, block:b[91]},
			'2833':{ u:'2833', i:9300, name:'BRAILLE PATTERN DOTS-1256', cat:c.So,   canon:k._0, block:b[91]},
			'2834':{ u:'2834', i:9301, name:'BRAILLE PATTERN DOTS-356', cat:c.So,   canon:k._0, block:b[91]},
			'2835':{ u:'2835', i:9302, name:'BRAILLE PATTERN DOTS-1356', cat:c.So,   canon:k._0, block:b[91]},
			'2836':{ u:'2836', i:9303, name:'BRAILLE PATTERN DOTS-2356', cat:c.So,   canon:k._0, block:b[91]},
			'2837':{ u:'2837', i:9304, name:'BRAILLE PATTERN DOTS-12356', cat:c.So,   canon:k._0, block:b[91]},
			'2838':{ u:'2838', i:9305, name:'BRAILLE PATTERN DOTS-456', cat:c.So,   canon:k._0, block:b[91]},
			'2839':{ u:'2839', i:9306, name:'BRAILLE PATTERN DOTS-1456', cat:c.So,   canon:k._0, block:b[91]},
			'2840':{ u:'2840', i:9313, name:'BRAILLE PATTERN DOTS-7', cat:c.So,   canon:k._0, block:b[91]},
			'2841':{ u:'2841', i:9314, name:'BRAILLE PATTERN DOTS-17', cat:c.So,   canon:k._0, block:b[91]},
			'2842':{ u:'2842', i:9315, name:'BRAILLE PATTERN DOTS-27', cat:c.So,   canon:k._0, block:b[91]},
			'2843':{ u:'2843', i:9316, name:'BRAILLE PATTERN DOTS-127', cat:c.So,   canon:k._0, block:b[91]},
			'2844':{ u:'2844', i:9317, name:'BRAILLE PATTERN DOTS-37', cat:c.So,   canon:k._0, block:b[91]},
			'2845':{ u:'2845', i:9318, name:'BRAILLE PATTERN DOTS-137', cat:c.So,   canon:k._0, block:b[91]},
			'2846':{ u:'2846', i:9319, name:'BRAILLE PATTERN DOTS-237', cat:c.So,   canon:k._0, block:b[91]},
			'2847':{ u:'2847', i:9320, name:'BRAILLE PATTERN DOTS-1237', cat:c.So,   canon:k._0, block:b[91]},
			'2848':{ u:'2848', i:9321, name:'BRAILLE PATTERN DOTS-47', cat:c.So,   canon:k._0, block:b[91]},
			'2849':{ u:'2849', i:9322, name:'BRAILLE PATTERN DOTS-147', cat:c.So,   canon:k._0, block:b[91]},
			'2850':{ u:'2850', i:9329, name:'BRAILLE PATTERN DOTS-57', cat:c.So,   canon:k._0, block:b[91]},
			'2851':{ u:'2851', i:9330, name:'BRAILLE PATTERN DOTS-157', cat:c.So,   canon:k._0, block:b[91]},
			'2852':{ u:'2852', i:9331, name:'BRAILLE PATTERN DOTS-257', cat:c.So,   canon:k._0, block:b[91]},
			'2853':{ u:'2853', i:9332, name:'BRAILLE PATTERN DOTS-1257', cat:c.So,   canon:k._0, block:b[91]},
			'2854':{ u:'2854', i:9333, name:'BRAILLE PATTERN DOTS-357', cat:c.So,   canon:k._0, block:b[91]},
			'2855':{ u:'2855', i:9334, name:'BRAILLE PATTERN DOTS-1357', cat:c.So,   canon:k._0, block:b[91]},
			'2856':{ u:'2856', i:9335, name:'BRAILLE PATTERN DOTS-2357', cat:c.So,   canon:k._0, block:b[91]},
			'2857':{ u:'2857', i:9336, name:'BRAILLE PATTERN DOTS-12357', cat:c.So,   canon:k._0, block:b[91]},
			'2858':{ u:'2858', i:9337, name:'BRAILLE PATTERN DOTS-457', cat:c.So,   canon:k._0, block:b[91]},
			'2859':{ u:'2859', i:9338, name:'BRAILLE PATTERN DOTS-1457', cat:c.So,   canon:k._0, block:b[91]},
			'2860':{ u:'2860', i:9345, name:'BRAILLE PATTERN DOTS-67', cat:c.So,   canon:k._0, block:b[91]},
			'2861':{ u:'2861', i:9346, name:'BRAILLE PATTERN DOTS-167', cat:c.So,   canon:k._0, block:b[91]},
			'2862':{ u:'2862', i:9347, name:'BRAILLE PATTERN DOTS-267', cat:c.So,   canon:k._0, block:b[91]},
			'2863':{ u:'2863', i:9348, name:'BRAILLE PATTERN DOTS-1267', cat:c.So,   canon:k._0, block:b[91]},
			'2864':{ u:'2864', i:9349, name:'BRAILLE PATTERN DOTS-367', cat:c.So,   canon:k._0, block:b[91]},
			'2865':{ u:'2865', i:9350, name:'BRAILLE PATTERN DOTS-1367', cat:c.So,   canon:k._0, block:b[91]},
			'2866':{ u:'2866', i:9351, name:'BRAILLE PATTERN DOTS-2367', cat:c.So,   canon:k._0, block:b[91]},
			'2867':{ u:'2867', i:9352, name:'BRAILLE PATTERN DOTS-12367', cat:c.So,   canon:k._0, block:b[91]},
			'2868':{ u:'2868', i:9353, name:'BRAILLE PATTERN DOTS-467', cat:c.So,   canon:k._0, block:b[91]},
			'2869':{ u:'2869', i:9354, name:'BRAILLE PATTERN DOTS-1467', cat:c.So,   canon:k._0, block:b[91]},
			'2870':{ u:'2870', i:9361, name:'BRAILLE PATTERN DOTS-567', cat:c.So,   canon:k._0, block:b[91]},
			'2871':{ u:'2871', i:9362, name:'BRAILLE PATTERN DOTS-1567', cat:c.So,   canon:k._0, block:b[91]},
			'2872':{ u:'2872', i:9363, name:'BRAILLE PATTERN DOTS-2567', cat:c.So,   canon:k._0, block:b[91]},
			'2873':{ u:'2873', i:9364, name:'BRAILLE PATTERN DOTS-12567', cat:c.So,   canon:k._0, block:b[91]},
			'2874':{ u:'2874', i:9365, name:'BRAILLE PATTERN DOTS-3567', cat:c.So,   canon:k._0, block:b[91]},
			'2875':{ u:'2875', i:9366, name:'BRAILLE PATTERN DOTS-13567', cat:c.So,   canon:k._0, block:b[91]},
			'2876':{ u:'2876', i:9367, name:'BRAILLE PATTERN DOTS-23567', cat:c.So,   canon:k._0, block:b[91]},
			'2877':{ u:'2877', i:9368, name:'BRAILLE PATTERN DOTS-123567', cat:c.So,   canon:k._0, block:b[91]},
			'2878':{ u:'2878', i:9369, name:'BRAILLE PATTERN DOTS-4567', cat:c.So,   canon:k._0, block:b[91]},
			'2879':{ u:'2879', i:9370, name:'BRAILLE PATTERN DOTS-14567', cat:c.So,   canon:k._0, block:b[91]},
			'2880':{ u:'2880', i:9377, name:'BRAILLE PATTERN DOTS-8', cat:c.So,   canon:k._0, block:b[91]},
			'2881':{ u:'2881', i:9378, name:'BRAILLE PATTERN DOTS-18', cat:c.So,   canon:k._0, block:b[91]},
			'2882':{ u:'2882', i:9379, name:'BRAILLE PATTERN DOTS-28', cat:c.So,   canon:k._0, block:b[91]},
			'2883':{ u:'2883', i:9380, name:'BRAILLE PATTERN DOTS-128', cat:c.So,   canon:k._0, block:b[91]},
			'2884':{ u:'2884', i:9381, name:'BRAILLE PATTERN DOTS-38', cat:c.So,   canon:k._0, block:b[91]},
			'2885':{ u:'2885', i:9382, name:'BRAILLE PATTERN DOTS-138', cat:c.So,   canon:k._0, block:b[91]},
			'2886':{ u:'2886', i:9383, name:'BRAILLE PATTERN DOTS-238', cat:c.So,   canon:k._0, block:b[91]},
			'2887':{ u:'2887', i:9384, name:'BRAILLE PATTERN DOTS-1238', cat:c.So,   canon:k._0, block:b[91]},
			'2888':{ u:'2888', i:9385, name:'BRAILLE PATTERN DOTS-48', cat:c.So,   canon:k._0, block:b[91]},
			'2889':{ u:'2889', i:9386, name:'BRAILLE PATTERN DOTS-148', cat:c.So,   canon:k._0, block:b[91]},
			'2890':{ u:'2890', i:9393, name:'BRAILLE PATTERN DOTS-58', cat:c.So,   canon:k._0, block:b[91]},
			'2891':{ u:'2891', i:9394, name:'BRAILLE PATTERN DOTS-158', cat:c.So,   canon:k._0, block:b[91]},
			'2892':{ u:'2892', i:9395, name:'BRAILLE PATTERN DOTS-258', cat:c.So,   canon:k._0, block:b[91]},
			'2893':{ u:'2893', i:9396, name:'BRAILLE PATTERN DOTS-1258', cat:c.So,   canon:k._0, block:b[91]},
			'2894':{ u:'2894', i:9397, name:'BRAILLE PATTERN DOTS-358', cat:c.So,   canon:k._0, block:b[91]},
			'2895':{ u:'2895', i:9398, name:'BRAILLE PATTERN DOTS-1358', cat:c.So,   canon:k._0, block:b[91]},
			'2896':{ u:'2896', i:9399, name:'BRAILLE PATTERN DOTS-2358', cat:c.So,   canon:k._0, block:b[91]},
			'2897':{ u:'2897', i:9400, name:'BRAILLE PATTERN DOTS-12358', cat:c.So,   canon:k._0, block:b[91]},
			'2898':{ u:'2898', i:9401, name:'BRAILLE PATTERN DOTS-458', cat:c.So,   canon:k._0, block:b[91]},
			'2899':{ u:'2899', i:9402, name:'BRAILLE PATTERN DOTS-1458', cat:c.So,   canon:k._0, block:b[91]},
			'2900':{ u:'2900', i:9505, name:'RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2901':{ u:'2901', i:9506, name:'RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2902':{ u:'2902', i:9507, name:'LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2903':{ u:'2903', i:9508, name:'RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2904':{ u:'2904', i:9509, name:'LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2905':{ u:'2905', i:9510, name:'RIGHTWARDS TWO-HEADED ARROW FROM BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2906':{ u:'2906', i:9511, name:'LEFTWARDS DOUBLE ARROW FROM BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2907':{ u:'2907', i:9512, name:'RIGHTWARDS DOUBLE ARROW FROM BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2908':{ u:'2908', i:9513, name:'DOWNWARDS ARROW WITH HORIZONTAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2909':{ u:'2909', i:9514, name:'UPWARDS ARROW WITH HORIZONTAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2910':{ u:'2910', i:9521, name:'RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2911':{ u:'2911', i:9522, name:'RIGHTWARDS ARROW WITH DOTTED STEM', cat:c.Sm,   canon:k._0, block:b[92]},
			'2912':{ u:'2912', i:9523, name:'UPWARDS ARROW TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2913':{ u:'2913', i:9524, name:'DOWNWARDS ARROW TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2914':{ u:'2914', i:9525, name:'RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2915':{ u:'2915', i:9526, name:'RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2916':{ u:'2916', i:9527, name:'RIGHTWARDS TWO-HEADED ARROW WITH TAIL', cat:c.Sm,   canon:k._0, block:b[92]},
			'2917':{ u:'2917', i:9528, name:'RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2918':{ u:'2918', i:9529, name:'RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2919':{ u:'2919', i:9530, name:'LEFTWARDS ARROW-TAIL', cat:c.Sm,   canon:k._0, block:b[92]},
			'2920':{ u:'2920', i:9537, name:'RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND', cat:c.Sm,   canon:k._0, block:b[92]},
			'2921':{ u:'2921', i:9538, name:'NORTH WEST AND SOUTH EAST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2922':{ u:'2922', i:9539, name:'NORTH EAST AND SOUTH WEST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2923':{ u:'2923', i:9540, name:'NORTH WEST ARROW WITH HOOK', cat:c.Sm,   canon:k._0, block:b[92]},
			'2924':{ u:'2924', i:9541, name:'NORTH EAST ARROW WITH HOOK', cat:c.Sm,   canon:k._0, block:b[92]},
			'2925':{ u:'2925', i:9542, name:'SOUTH EAST ARROW WITH HOOK', cat:c.Sm,   canon:k._0, block:b[92]},
			'2926':{ u:'2926', i:9543, name:'SOUTH WEST ARROW WITH HOOK', cat:c.Sm,   canon:k._0, block:b[92]},
			'2927':{ u:'2927', i:9544, name:'NORTH WEST ARROW AND NORTH EAST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2928':{ u:'2928', i:9545, name:'NORTH EAST ARROW AND SOUTH EAST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2929':{ u:'2929', i:9546, name:'SOUTH EAST ARROW AND SOUTH WEST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2930':{ u:'2930', i:9553, name:'RISING DIAGONAL CROSSING SOUTH EAST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2931':{ u:'2931', i:9554, name:'NORTH EAST ARROW CROSSING NORTH WEST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2932':{ u:'2932', i:9555, name:'NORTH WEST ARROW CROSSING NORTH EAST ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2933':{ u:'2933', i:9556, name:'WAVE ARROW POINTING DIRECTLY RIGHT', cat:c.Sm,   canon:k._0, block:b[92]},
			'2934':{ u:'2934', i:9557, name:'ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS', cat:c.Sm,   canon:k._0, block:b[92]},
			'2935':{ u:'2935', i:9558, name:'ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS', cat:c.Sm,   canon:k._0, block:b[92]},
			'2936':{ u:'2936', i:9559, name:'ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS', cat:c.Sm,   canon:k._0, block:b[92]},
			'2937':{ u:'2937', i:9560, name:'ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS', cat:c.Sm,   canon:k._0, block:b[92]},
			'2938':{ u:'2938', i:9561, name:'RIGHT-SIDE ARC CLOCKWISE ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2939':{ u:'2939', i:9562, name:'LEFT-SIDE ARC ANTICLOCKWISE ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2940':{ u:'2940', i:9569, name:'ANTICLOCKWISE CLOSED CIRCLE ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2941':{ u:'2941', i:9570, name:'CLOCKWISE CLOSED CIRCLE ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2942':{ u:'2942', i:9571, name:'RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2943':{ u:'2943', i:9572, name:'LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2944':{ u:'2944', i:9573, name:'SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2945':{ u:'2945', i:9574, name:'RIGHTWARDS ARROW WITH PLUS BELOW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2946':{ u:'2946', i:9575, name:'LEFTWARDS ARROW WITH PLUS BELOW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2947':{ u:'2947', i:9576, name:'RIGHTWARDS ARROW THROUGH X', cat:c.Sm,   canon:k._0, block:b[92], indexed:["X"]},
			'2948':{ u:'2948', i:9577, name:'LEFT RIGHT ARROW THROUGH SMALL CIRCLE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2949':{ u:'2949', i:9578, name:'UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE', cat:c.Sm,   canon:k._0, block:b[92]},
			'2950':{ u:'2950', i:9585, name:'LEFT BARB DOWN RIGHT BARB DOWN HARPOON', cat:c.Sm,   canon:k._0, block:b[92]},
			'2951':{ u:'2951', i:9586, name:'UP BARB LEFT DOWN BARB LEFT HARPOON', cat:c.Sm,   canon:k._0, block:b[92]},
			'2952':{ u:'2952', i:9587, name:'LEFTWARDS HARPOON WITH BARB UP TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2953':{ u:'2953', i:9588, name:'RIGHTWARDS HARPOON WITH BARB UP TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2954':{ u:'2954', i:9589, name:'UPWARDS HARPOON WITH BARB RIGHT TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2955':{ u:'2955', i:9590, name:'DOWNWARDS HARPOON WITH BARB RIGHT TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2956':{ u:'2956', i:9591, name:'LEFTWARDS HARPOON WITH BARB DOWN TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2957':{ u:'2957', i:9592, name:'RIGHTWARDS HARPOON WITH BARB DOWN TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2958':{ u:'2958', i:9593, name:'UPWARDS HARPOON WITH BARB LEFT TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2959':{ u:'2959', i:9594, name:'DOWNWARDS HARPOON WITH BARB LEFT TO BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2960':{ u:'2960', i:9601, name:'UPWARDS HARPOON WITH BARB LEFT FROM BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2961':{ u:'2961', i:9602, name:'DOWNWARDS HARPOON WITH BARB LEFT FROM BAR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2962':{ u:'2962', i:9603, name:'LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN', cat:c.Sm,   canon:k._0, block:b[92]},
			'2963':{ u:'2963', i:9604, name:'UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT', cat:c.Sm,   canon:k._0, block:b[92]},
			'2964':{ u:'2964', i:9605, name:'RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN', cat:c.Sm,   canon:k._0, block:b[92]},
			'2965':{ u:'2965', i:9606, name:'DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT', cat:c.Sm,   canon:k._0, block:b[92]},
			'2966':{ u:'2966', i:9607, name:'LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP', cat:c.Sm,   canon:k._0, block:b[92]},
			'2967':{ u:'2967', i:9608, name:'LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN', cat:c.Sm,   canon:k._0, block:b[92]},
			'2968':{ u:'2968', i:9609, name:'RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP', cat:c.Sm,   canon:k._0, block:b[92]},
			'2969':{ u:'2969', i:9610, name:'RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN', cat:c.Sm,   canon:k._0, block:b[92]},
			'2970':{ u:'2970', i:9617, name:'RIGHT DOUBLE ARROW WITH ROUNDED HEAD', cat:c.Sm,   canon:k._0, block:b[92]},
			'2971':{ u:'2971', i:9618, name:'EQUALS SIGN ABOVE RIGHTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2972':{ u:'2972', i:9619, name:'TILDE OPERATOR ABOVE RIGHTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2973':{ u:'2973', i:9620, name:'LEFTWARDS ARROW ABOVE TILDE OPERATOR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2974':{ u:'2974', i:9621, name:'RIGHTWARDS ARROW ABOVE TILDE OPERATOR', cat:c.Sm,   canon:k._0, block:b[92]},
			'2975':{ u:'2975', i:9622, name:'RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO', cat:c.Sm,   canon:k._0, block:b[92]},
			'2976':{ u:'2976', i:9623, name:'LESS-THAN ABOVE LEFTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2977':{ u:'2977', i:9624, name:'LEFTWARDS ARROW THROUGH LESS-THAN', cat:c.Sm,   canon:k._0, block:b[92]},
			'2978':{ u:'2978', i:9625, name:'GREATER-THAN ABOVE RIGHTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2979':{ u:'2979', i:9626, name:'SUBSET ABOVE RIGHTWARDS ARROW', cat:c.Sm,   canon:k._0, block:b[92]},
			'2980':{ u:'2980', i:9633, name:'TRIPLE VERTICAL BAR DELIMITER', cat:c.Sm,   canon:k._0, block:b[93]},
			'2981':{ u:'2981', i:9634, name:'Z NOTATION SPOT', cat:c.Sm,   canon:k._0, block:b[93], indexed:["Z"]},
			'2982':{ u:'2982', i:9635, name:'Z NOTATION TYPE COLON', cat:c.Sm,   canon:k._0, block:b[93], indexed:["Z"]},
			'2983':{ u:'2983', i:9636, name:'LEFT WHITE CURLY BRACKET', cat:c.Ps,   canon:k._0, block:b[93]},
			'2984':{ u:'2984', i:9637, name:'RIGHT WHITE CURLY BRACKET', cat:c.Pe,   canon:k._0, block:b[93]},
			'2985':{ u:'2985', i:9638, name:'LEFT WHITE PARENTHESIS', cat:c.Ps,  relatives:['ff5f'],  canon:k._0, block:b[93]},
			'2986':{ u:'2986', i:9639, name:'RIGHT WHITE PARENTHESIS', cat:c.Pe,  relatives:['ff60'],  canon:k._0, block:b[93]},
			'2987':{ u:'2987', i:9640, name:'Z NOTATION LEFT IMAGE BRACKET', cat:c.Ps,   canon:k._0, block:b[93], indexed:["Z"]},
			'2988':{ u:'2988', i:9641, name:'Z NOTATION RIGHT IMAGE BRACKET', cat:c.Pe,   canon:k._0, block:b[93], indexed:["Z"]},
			'2989':{ u:'2989', i:9642, name:'Z NOTATION LEFT BINDING BRACKET', cat:c.Ps,   canon:k._0, block:b[93], indexed:["Z"]},
			'2990':{ u:'2990', i:9649, name:'RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER', cat:c.Pe,   canon:k._0, block:b[93]},
			'2991':{ u:'2991', i:9650, name:'LEFT ANGLE BRACKET WITH DOT', cat:c.Ps,   canon:k._0, block:b[93]},
			'2992':{ u:'2992', i:9651, name:'RIGHT ANGLE BRACKET WITH DOT', cat:c.Pe,   canon:k._0, block:b[93]},
			'2993':{ u:'2993', i:9652, name:'LEFT ARC LESS-THAN BRACKET', cat:c.Ps,   canon:k._0, block:b[93]},
			'2994':{ u:'2994', i:9653, name:'RIGHT ARC GREATER-THAN BRACKET', cat:c.Pe,   canon:k._0, block:b[93]},
			'2995':{ u:'2995', i:9654, name:'DOUBLE LEFT ARC GREATER-THAN BRACKET', cat:c.Ps,   canon:k._0, block:b[93]},
			'2996':{ u:'2996', i:9655, name:'DOUBLE RIGHT ARC LESS-THAN BRACKET', cat:c.Pe,   canon:k._0, block:b[93]},
			'2997':{ u:'2997', i:9656, name:'LEFT BLACK TORTOISE SHELL BRACKET', cat:c.Ps,   canon:k._0, block:b[93]},
			'2998':{ u:'2998', i:9657, name:'RIGHT BLACK TORTOISE SHELL BRACKET', cat:c.Pe,   canon:k._0, block:b[93]},
			'2999':{ u:'2999', i:9658, name:'DOTTED FENCE', cat:c.Sm,   canon:k._0, block:b[93]},
			'3000':{ u:'3000', i:11166, name:'IDEOGRAPHIC SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[107]},
			'3001':{ u:'3001', i:11167, name:'IDEOGRAPHIC COMMA', cat:c.Po,  relatives:['fe11', 'fe51', 'ff64'],  canon:k._0, block:b[107]},
			'3002':{ u:'3002', i:11168, name:'IDEOGRAPHIC FULL STOP', cat:c.Po,  relatives:['fe12', 'ff61'],  canon:k._0, block:b[107]},
			'3003':{ u:'3003', i:11169, name:'DITTO MARK', cat:c.Po,   canon:k._0, block:b[107]},
			'3004':{ u:'3004', i:11170, name:'JAPANESE INDUSTRIAL STANDARD SYMBOL', cat:c.So,   canon:k._0, block:b[107]},
			'3005':{ u:'3005', i:11171, name:'IDEOGRAPHIC ITERATION MARK', cat:c.Lm,   canon:k._0, block:b[107]},
			'3006':{ u:'3006', i:11172, name:'IDEOGRAPHIC CLOSING MARK', cat:c.Lo,   canon:k._0, block:b[107]},
			'3007':{ u:'3007', i:11173, name:'IDEOGRAPHIC NUMBER ZERO', cat:c.Nl,   canon:k._0, block:b[107]},
			'3008':{ u:'3008', i:11174, name:'LEFT ANGLE BRACKET', cat:c.Ps,  relatives:['2329', 'fe3f'],  canon:k._0, block:b[107]},
			'3009':{ u:'3009', i:11175, name:'RIGHT ANGLE BRACKET', cat:c.Pe,  relatives:['232a', 'fe40'],  canon:k._0, block:b[107]},
			'3010':{ u:'3010', i:11182, name:'LEFT BLACK LENTICULAR BRACKET', cat:c.Ps,  relatives:['fe3b'],  canon:k._0, block:b[107]},
			'3011':{ u:'3011', i:11183, name:'RIGHT BLACK LENTICULAR BRACKET', cat:c.Pe,  relatives:['fe3c'],  canon:k._0, block:b[107]},
			'3012':{ u:'3012', i:11184, name:'POSTAL MARK', cat:c.So,  relatives:['3036'],  canon:k._0, block:b[107]},
			'3013':{ u:'3013', i:11185, name:'GETA MARK', cat:c.So,   canon:k._0, block:b[107]},
			'3014':{ u:'3014', i:11186, name:'LEFT TORTOISE SHELL BRACKET', cat:c.Ps,  relatives:['fe39', 'fe5d', '1f12a', '1f240', '1f241', '1f242', '1f243', '1f244', '1f245', '1f246', '1f247', '1f248'],  canon:k._0, block:b[107]},
			'3015':{ u:'3015', i:11187, name:'RIGHT TORTOISE SHELL BRACKET', cat:c.Pe,  relatives:['fe3a', 'fe5e', '1f12a', '1f240', '1f241', '1f242', '1f243', '1f244', '1f245', '1f246', '1f247', '1f248'],  canon:k._0, block:b[107]},
			'3016':{ u:'3016', i:11188, name:'LEFT WHITE LENTICULAR BRACKET', cat:c.Ps,  relatives:['fe17'],  canon:k._0, block:b[107]},
			'3017':{ u:'3017', i:11189, name:'RIGHT WHITE LENTICULAR BRACKET', cat:c.Pe,  relatives:['fe18'],  canon:k._0, block:b[107]},
			'3018':{ u:'3018', i:11190, name:'LEFT WHITE TORTOISE SHELL BRACKET', cat:c.Ps,   canon:k._0, block:b[107]},
			'3019':{ u:'3019', i:11191, name:'RIGHT WHITE TORTOISE SHELL BRACKET', cat:c.Pe,   canon:k._0, block:b[107]},
			'3020':{ u:'3020', i:11198, name:'POSTAL MARK FACE', cat:c.So,   canon:k._0, block:b[107]},
			'3021':{ u:'3021', i:11199, name:'HANGZHOU NUMERAL ONE', cat:c.Nl,   canon:k._0, block:b[107]},
			'3022':{ u:'3022', i:11200, name:'HANGZHOU NUMERAL TWO', cat:c.Nl,   canon:k._0, block:b[107]},
			'3023':{ u:'3023', i:11201, name:'HANGZHOU NUMERAL THREE', cat:c.Nl,   canon:k._0, block:b[107]},
			'3024':{ u:'3024', i:11202, name:'HANGZHOU NUMERAL FOUR', cat:c.Nl,   canon:k._0, block:b[107]},
			'3025':{ u:'3025', i:11203, name:'HANGZHOU NUMERAL FIVE', cat:c.Nl,   canon:k._0, block:b[107]},
			'3026':{ u:'3026', i:11204, name:'HANGZHOU NUMERAL SIX', cat:c.Nl,   canon:k._0, block:b[107]},
			'3027':{ u:'3027', i:11205, name:'HANGZHOU NUMERAL SEVEN', cat:c.Nl,   canon:k._0, block:b[107]},
			'3028':{ u:'3028', i:11206, name:'HANGZHOU NUMERAL EIGHT', cat:c.Nl,   canon:k._0, block:b[107]},
			'3029':{ u:'3029', i:11207, name:'HANGZHOU NUMERAL NINE', cat:c.Nl,   canon:k._0, block:b[107]},
			'3030':{ u:'3030', i:11214, name:'WAVY DASH', cat:c.Pd,   canon:k._0, block:b[107]},
			'3031':{ u:'3031', i:11215, name:'VERTICAL KANA REPEAT MARK', cat:c.Lm,   canon:k._0, block:b[107]},
			'3032':{ u:'3032', i:11216, name:'VERTICAL KANA REPEAT WITH VOICED SOUND MARK', cat:c.Lm,   canon:k._0, block:b[107]},
			'3033':{ u:'3033', i:11217, name:'VERTICAL KANA REPEAT MARK UPPER HALF', cat:c.Lm,   canon:k._0, block:b[107]},
			'3034':{ u:'3034', i:11218, name:'VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF', cat:c.Lm,   canon:k._0, block:b[107]},
			'3035':{ u:'3035', i:11219, name:'VERTICAL KANA REPEAT MARK LOWER HALF', cat:c.Lm,   canon:k._0, block:b[107]},
			'3036':{ u:'3036', i:11220, name:'CIRCLED POSTAL MARK', cat:c.So,  relatives:['3012'],  canon:k._0, block:b[107]},
			'3037':{ u:'3037', i:11221, name:'IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL', cat:c.So,   canon:k._0, block:b[107]},
			'3038':{ u:'3038', i:11222, name:'HANGZHOU NUMERAL TEN', cat:c.Nl,  relatives:['5341'],  canon:k._0, block:b[107]},
			'3039':{ u:'3039', i:11223, name:'HANGZHOU NUMERAL TWENTY', cat:c.Nl,  relatives:['5344'],  canon:k._0, block:b[107]},
			'3041':{ u:'3041', i:11230, name:'HIRAGANA LETTER SMALL A', cat:c.Lo,   canon:k._0, block:b[108], indexed:["A"]},
			'3042':{ u:'3042', i:11231, name:'HIRAGANA LETTER A', cat:c.Lo,   canon:k._0, block:b[108], indexed:["A"]},
			'3043':{ u:'3043', i:11232, name:'HIRAGANA LETTER SMALL I', cat:c.Lo,   canon:k._0, block:b[108], indexed:["I"]},
			'3044':{ u:'3044', i:11233, name:'HIRAGANA LETTER I', cat:c.Lo,   canon:k._0, block:b[108], indexed:["I"]},
			'3045':{ u:'3045', i:11234, name:'HIRAGANA LETTER SMALL U', cat:c.Lo,   canon:k._0, block:b[108], indexed:["U"]},
			'3046':{ u:'3046', i:11235, name:'HIRAGANA LETTER U', cat:c.Lo,  relatives:['3094'],  canon:k._0, block:b[108], indexed:["U"]},
			'3047':{ u:'3047', i:11236, name:'HIRAGANA LETTER SMALL E', cat:c.Lo,   canon:k._0, block:b[108], indexed:["E"]},
			'3048':{ u:'3048', i:11237, name:'HIRAGANA LETTER E', cat:c.Lo,   canon:k._0, block:b[108], indexed:["E"]},
			'3049':{ u:'3049', i:11238, name:'HIRAGANA LETTER SMALL O', cat:c.Lo,   canon:k._0, block:b[108], indexed:["O"]},
			'3050':{ u:'3050', i:11245, name:'HIRAGANA LETTER GU', cat:c.Lo,  relatives:['304f', '3099'], comp:['304f','3099'], canon:k._0, block:b[108]},
			'3051':{ u:'3051', i:11246, name:'HIRAGANA LETTER KE', cat:c.Lo,  relatives:['3052'],  canon:k._0, block:b[108]},
			'3052':{ u:'3052', i:11247, name:'HIRAGANA LETTER GE', cat:c.Lo,  relatives:['3051', '3099'], comp:['3051','3099'], canon:k._0, block:b[108]},
			'3053':{ u:'3053', i:11248, name:'HIRAGANA LETTER KO', cat:c.Lo,  relatives:['3054'],  canon:k._0, block:b[108]},
			'3054':{ u:'3054', i:11249, name:'HIRAGANA LETTER GO', cat:c.Lo,  relatives:['3053', '3099'], comp:['3053','3099'], canon:k._0, block:b[108]},
			'3055':{ u:'3055', i:11250, name:'HIRAGANA LETTER SA', cat:c.Lo,  relatives:['3056'],  canon:k._0, block:b[108]},
			'3056':{ u:'3056', i:11251, name:'HIRAGANA LETTER ZA', cat:c.Lo,  relatives:['3055', '3099'], comp:['3055','3099'], canon:k._0, block:b[108]},
			'3057':{ u:'3057', i:11252, name:'HIRAGANA LETTER SI', cat:c.Lo,  relatives:['3058'],  canon:k._0, block:b[108]},
			'3058':{ u:'3058', i:11253, name:'HIRAGANA LETTER ZI', cat:c.Lo,  relatives:['3057', '3099'], comp:['3057','3099'], canon:k._0, block:b[108]},
			'3059':{ u:'3059', i:11254, name:'HIRAGANA LETTER SU', cat:c.Lo,  relatives:['305a'],  canon:k._0, block:b[108]},
			'3060':{ u:'3060', i:11261, name:'HIRAGANA LETTER DA', cat:c.Lo,  relatives:['305f', '3099'], comp:['305f','3099'], canon:k._0, block:b[108]},
			'3061':{ u:'3061', i:11262, name:'HIRAGANA LETTER TI', cat:c.Lo,  relatives:['3062'],  canon:k._0, block:b[108]},
			'3062':{ u:'3062', i:11263, name:'HIRAGANA LETTER DI', cat:c.Lo,  relatives:['3061', '3099'], comp:['3061','3099'], canon:k._0, block:b[108]},
			'3063':{ u:'3063', i:11264, name:'HIRAGANA LETTER SMALL TU', cat:c.Lo,   canon:k._0, block:b[108]},
			'3064':{ u:'3064', i:11265, name:'HIRAGANA LETTER TU', cat:c.Lo,  relatives:['3065'],  canon:k._0, block:b[108]},
			'3065':{ u:'3065', i:11266, name:'HIRAGANA LETTER DU', cat:c.Lo,  relatives:['3064', '3099'], comp:['3064','3099'], canon:k._0, block:b[108]},
			'3066':{ u:'3066', i:11267, name:'HIRAGANA LETTER TE', cat:c.Lo,  relatives:['3067'],  canon:k._0, block:b[108]},
			'3067':{ u:'3067', i:11268, name:'HIRAGANA LETTER DE', cat:c.Lo,  relatives:['3066', '3099'], comp:['3066','3099'], canon:k._0, block:b[108]},
			'3068':{ u:'3068', i:11269, name:'HIRAGANA LETTER TO', cat:c.Lo,  relatives:['3069'],  canon:k._0, block:b[108]},
			'3069':{ u:'3069', i:11270, name:'HIRAGANA LETTER DO', cat:c.Lo,  relatives:['3068', '3099'], comp:['3068','3099'], canon:k._0, block:b[108]},
			'3070':{ u:'3070', i:11277, name:'HIRAGANA LETTER BA', cat:c.Lo,  relatives:['306f', '3099'], comp:['306f','3099'], canon:k._0, block:b[108]},
			'3071':{ u:'3071', i:11278, name:'HIRAGANA LETTER PA', cat:c.Lo,  relatives:['306f', '309a'], comp:['306f','309a'], canon:k._0, block:b[108]},
			'3072':{ u:'3072', i:11279, name:'HIRAGANA LETTER HI', cat:c.Lo,  relatives:['3073', '3074'],  canon:k._0, block:b[108]},
			'3073':{ u:'3073', i:11280, name:'HIRAGANA LETTER BI', cat:c.Lo,  relatives:['3072', '3099'], comp:['3072','3099'], canon:k._0, block:b[108]},
			'3074':{ u:'3074', i:11281, name:'HIRAGANA LETTER PI', cat:c.Lo,  relatives:['3072', '309a'], comp:['3072','309a'], canon:k._0, block:b[108]},
			'3075':{ u:'3075', i:11282, name:'HIRAGANA LETTER HU', cat:c.Lo,  relatives:['3076', '3077'],  canon:k._0, block:b[108]},
			'3076':{ u:'3076', i:11283, name:'HIRAGANA LETTER BU', cat:c.Lo,  relatives:['3075', '3099'], comp:['3075','3099'], canon:k._0, block:b[108]},
			'3077':{ u:'3077', i:11284, name:'HIRAGANA LETTER PU', cat:c.Lo,  relatives:['3075', '309a'], comp:['3075','309a'], canon:k._0, block:b[108]},
			'3078':{ u:'3078', i:11285, name:'HIRAGANA LETTER HE', cat:c.Lo,  relatives:['3079', '307a'],  canon:k._0, block:b[108]},
			'3079':{ u:'3079', i:11286, name:'HIRAGANA LETTER BE', cat:c.Lo,  relatives:['3078', '3099'], comp:['3078','3099'], canon:k._0, block:b[108]},
			'3080':{ u:'3080', i:11293, name:'HIRAGANA LETTER MU', cat:c.Lo,   canon:k._0, block:b[108]},
			'3081':{ u:'3081', i:11294, name:'HIRAGANA LETTER ME', cat:c.Lo,   canon:k._0, block:b[108]},
			'3082':{ u:'3082', i:11295, name:'HIRAGANA LETTER MO', cat:c.Lo,   canon:k._0, block:b[108]},
			'3083':{ u:'3083', i:11296, name:'HIRAGANA LETTER SMALL YA', cat:c.Lo,   canon:k._0, block:b[108]},
			'3084':{ u:'3084', i:11297, name:'HIRAGANA LETTER YA', cat:c.Lo,   canon:k._0, block:b[108]},
			'3085':{ u:'3085', i:11298, name:'HIRAGANA LETTER SMALL YU', cat:c.Lo,   canon:k._0, block:b[108]},
			'3086':{ u:'3086', i:11299, name:'HIRAGANA LETTER YU', cat:c.Lo,   canon:k._0, block:b[108]},
			'3087':{ u:'3087', i:11300, name:'HIRAGANA LETTER SMALL YO', cat:c.Lo,   canon:k._0, block:b[108]},
			'3088':{ u:'3088', i:11301, name:'HIRAGANA LETTER YO', cat:c.Lo,  relatives:['309f'],  canon:k._0, block:b[108]},
			'3089':{ u:'3089', i:11302, name:'HIRAGANA LETTER RA', cat:c.Lo,   canon:k._0, block:b[108]},
			'3090':{ u:'3090', i:11309, name:'HIRAGANA LETTER WI', cat:c.Lo,   canon:k._0, block:b[108]},
			'3091':{ u:'3091', i:11310, name:'HIRAGANA LETTER WE', cat:c.Lo,   canon:k._0, block:b[108]},
			'3092':{ u:'3092', i:11311, name:'HIRAGANA LETTER WO', cat:c.Lo,   canon:k._0, block:b[108]},
			'3093':{ u:'3093', i:11312, name:'HIRAGANA LETTER N', cat:c.Lo,   canon:k._0, block:b[108], indexed:["N"]},
			'3094':{ u:'3094', i:11313, name:'HIRAGANA LETTER VU', cat:c.Lo,  relatives:['3046', '3099'], comp:['3046','3099'], canon:k._0, block:b[108]},
			'3095':{ u:'3095', i:11314, name:'HIRAGANA LETTER SMALL KA', cat:c.Lo,   canon:k._0, block:b[108]},
			'3096':{ u:'3096', i:11315, name:'HIRAGANA LETTER SMALL KE', cat:c.Lo,   canon:k._0, block:b[108]},
			'3099':{ u:'3099', i:11316, name:'COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK', cat:c.Mn,  relatives:['304c', '304e', '3050', '3052', '3054', '3056', '3058', '305a', '305c', '305e', '3060', '3062', '3065', '3067', '3069', '3070', '3073', '3076', '3079', '307c', '3094', '309b', '309e', '30ac', '30ae', '30b0', '30b2', '30b4', '30b6', '30b8', '30ba', '30bc', '30be', '30c0', '30c2', '30c5', '30c7', '30c9', '30d0', '30d3', '30d6', '30d9', '30dc', '30f4', '30f7', '30f8', '30f9', '30fa', '30fe', 'ff9e'],  canon:k._8, block:b[108]},
			'3105':{ u:'3105', i:11419, name:'BOPOMOFO LETTER B', cat:c.Lo,   canon:k._0, block:b[110], indexed:["B"]},
			'3106':{ u:'3106', i:11420, name:'BOPOMOFO LETTER P', cat:c.Lo,   canon:k._0, block:b[110], indexed:["P"]},
			'3107':{ u:'3107', i:11421, name:'BOPOMOFO LETTER M', cat:c.Lo,   canon:k._0, block:b[110], indexed:["M"]},
			'3108':{ u:'3108', i:11422, name:'BOPOMOFO LETTER F', cat:c.Lo,   canon:k._0, block:b[110], indexed:["F"]},
			'3109':{ u:'3109', i:11423, name:'BOPOMOFO LETTER D', cat:c.Lo,   canon:k._0, block:b[110], indexed:["D"]},
			'3110':{ u:'3110', i:11430, name:'BOPOMOFO LETTER J', cat:c.Lo,   canon:k._0, block:b[110], indexed:["J"]},
			'3111':{ u:'3111', i:11431, name:'BOPOMOFO LETTER Q', cat:c.Lo,   canon:k._0, block:b[110], indexed:["Q"]},
			'3112':{ u:'3112', i:11432, name:'BOPOMOFO LETTER X', cat:c.Lo,   canon:k._0, block:b[110], indexed:["X"]},
			'3113':{ u:'3113', i:11433, name:'BOPOMOFO LETTER ZH', cat:c.Lo,   canon:k._0, block:b[110]},
			'3114':{ u:'3114', i:11434, name:'BOPOMOFO LETTER CH', cat:c.Lo,   canon:k._0, block:b[110]},
			'3115':{ u:'3115', i:11435, name:'BOPOMOFO LETTER SH', cat:c.Lo,   canon:k._0, block:b[110]},
			'3116':{ u:'3116', i:11436, name:'BOPOMOFO LETTER R', cat:c.Lo,   canon:k._0, block:b[110], indexed:["R"]},
			'3117':{ u:'3117', i:11437, name:'BOPOMOFO LETTER Z', cat:c.Lo,   canon:k._0, block:b[110], indexed:["Z"]},
			'3118':{ u:'3118', i:11438, name:'BOPOMOFO LETTER C', cat:c.Lo,   canon:k._0, block:b[110], indexed:["C"]},
			'3119':{ u:'3119', i:11439, name:'BOPOMOFO LETTER S', cat:c.Lo,   canon:k._0, block:b[110], indexed:["S"]},
			'3120':{ u:'3120', i:11446, name:'BOPOMOFO LETTER AU', cat:c.Lo,   canon:k._0, block:b[110]},
			'3121':{ u:'3121', i:11447, name:'BOPOMOFO LETTER OU', cat:c.Lo,   canon:k._0, block:b[110]},
			'3122':{ u:'3122', i:11448, name:'BOPOMOFO LETTER AN', cat:c.Lo,   canon:k._0, block:b[110]},
			'3123':{ u:'3123', i:11449, name:'BOPOMOFO LETTER EN', cat:c.Lo,   canon:k._0, block:b[110]},
			'3124':{ u:'3124', i:11450, name:'BOPOMOFO LETTER ANG', cat:c.Lo,   canon:k._0, block:b[110]},
			'3125':{ u:'3125', i:11451, name:'BOPOMOFO LETTER ENG', cat:c.Lo,   canon:k._0, block:b[110]},
			'3126':{ u:'3126', i:11452, name:'BOPOMOFO LETTER ER', cat:c.Lo,   canon:k._0, block:b[110]},
			'3127':{ u:'3127', i:11453, name:'BOPOMOFO LETTER I', cat:c.Lo,   canon:k._0, block:b[110], indexed:["I"]},
			'3128':{ u:'3128', i:11454, name:'BOPOMOFO LETTER U', cat:c.Lo,   canon:k._0, block:b[110], indexed:["U"]},
			'3129':{ u:'3129', i:11455, name:'BOPOMOFO LETTER IU', cat:c.Lo,   canon:k._0, block:b[110]},
			'3131':{ u:'3131', i:11462, name:'HANGUL LETTER KIYEOK', cat:c.Lo,  relatives:['1100', 'ffa1'],  canon:k._0, block:b[111]},
			'3132':{ u:'3132', i:11463, name:'HANGUL LETTER SSANGKIYEOK', cat:c.Lo,  relatives:['1101', 'ffa2'],  canon:k._0, block:b[111]},
			'3133':{ u:'3133', i:11464, name:'HANGUL LETTER KIYEOK-SIOS', cat:c.Lo,  relatives:['11aa', 'ffa3'],  canon:k._0, block:b[111]},
			'3134':{ u:'3134', i:11465, name:'HANGUL LETTER NIEUN', cat:c.Lo,  relatives:['1102', 'ffa4'],  canon:k._0, block:b[111]},
			'3135':{ u:'3135', i:11466, name:'HANGUL LETTER NIEUN-CIEUC', cat:c.Lo,  relatives:['11ac', 'ffa5'],  canon:k._0, block:b[111]},
			'3136':{ u:'3136', i:11467, name:'HANGUL LETTER NIEUN-HIEUH', cat:c.Lo,  relatives:['11ad', 'ffa6'],  canon:k._0, block:b[111]},
			'3137':{ u:'3137', i:11468, name:'HANGUL LETTER TIKEUT', cat:c.Lo,  relatives:['1103', 'ffa7'],  canon:k._0, block:b[111]},
			'3138':{ u:'3138', i:11469, name:'HANGUL LETTER SSANGTIKEUT', cat:c.Lo,  relatives:['1104', 'ffa8'],  canon:k._0, block:b[111]},
			'3139':{ u:'3139', i:11470, name:'HANGUL LETTER RIEUL', cat:c.Lo,  relatives:['1105', 'ffa9'],  canon:k._0, block:b[111]},
			'3140':{ u:'3140', i:11477, name:'HANGUL LETTER RIEUL-HIEUH', cat:c.Lo,  relatives:['111a', 'ffb0'],  canon:k._0, block:b[111]},
			'3141':{ u:'3141', i:11478, name:'HANGUL LETTER MIEUM', cat:c.Lo,  relatives:['1106', 'ffb1'],  canon:k._0, block:b[111]},
			'3142':{ u:'3142', i:11479, name:'HANGUL LETTER PIEUP', cat:c.Lo,  relatives:['1107', 'ffb2'],  canon:k._0, block:b[111]},
			'3143':{ u:'3143', i:11480, name:'HANGUL LETTER SSANGPIEUP', cat:c.Lo,  relatives:['1108', 'ffb3'],  canon:k._0, block:b[111]},
			'3144':{ u:'3144', i:11481, name:'HANGUL LETTER PIEUP-SIOS', cat:c.Lo,  relatives:['1121', 'ffb4'],  canon:k._0, block:b[111]},
			'3145':{ u:'3145', i:11482, name:'HANGUL LETTER SIOS', cat:c.Lo,  relatives:['1109', 'ffb5'],  canon:k._0, block:b[111]},
			'3146':{ u:'3146', i:11483, name:'HANGUL LETTER SSANGSIOS', cat:c.Lo,  relatives:['110a', 'ffb6'],  canon:k._0, block:b[111]},
			'3147':{ u:'3147', i:11484, name:'HANGUL LETTER IEUNG', cat:c.Lo,  relatives:['110b', 'ffb7'],  canon:k._0, block:b[111]},
			'3148':{ u:'3148', i:11485, name:'HANGUL LETTER CIEUC', cat:c.Lo,  relatives:['110c', 'ffb8'],  canon:k._0, block:b[111]},
			'3149':{ u:'3149', i:11486, name:'HANGUL LETTER SSANGCIEUC', cat:c.Lo,  relatives:['110d', 'ffb9'],  canon:k._0, block:b[111]},
			'3150':{ u:'3150', i:11493, name:'HANGUL LETTER AE', cat:c.Lo,  relatives:['1162', 'ffc3'],  canon:k._0, block:b[111]},
			'3151':{ u:'3151', i:11494, name:'HANGUL LETTER YA', cat:c.Lo,  relatives:['1163', 'ffc4'],  canon:k._0, block:b[111]},
			'3152':{ u:'3152', i:11495, name:'HANGUL LETTER YAE', cat:c.Lo,  relatives:['1164', 'ffc5'],  canon:k._0, block:b[111]},
			'3153':{ u:'3153', i:11496, name:'HANGUL LETTER EO', cat:c.Lo,  relatives:['1165', 'ffc6'],  canon:k._0, block:b[111]},
			'3154':{ u:'3154', i:11497, name:'HANGUL LETTER E', cat:c.Lo,  relatives:['1166', 'ffc7'],  canon:k._0, block:b[111], indexed:["E"]},
			'3155':{ u:'3155', i:11498, name:'HANGUL LETTER YEO', cat:c.Lo,  relatives:['1167', 'ffca'],  canon:k._0, block:b[111]},
			'3156':{ u:'3156', i:11499, name:'HANGUL LETTER YE', cat:c.Lo,  relatives:['1168', 'ffcb'],  canon:k._0, block:b[111]},
			'3157':{ u:'3157', i:11500, name:'HANGUL LETTER O', cat:c.Lo,  relatives:['1169', 'ffcc'],  canon:k._0, block:b[111], indexed:["O"]},
			'3158':{ u:'3158', i:11501, name:'HANGUL LETTER WA', cat:c.Lo,  relatives:['116a', 'ffcd'],  canon:k._0, block:b[111]},
			'3159':{ u:'3159', i:11502, name:'HANGUL LETTER WAE', cat:c.Lo,  relatives:['116b', 'ffce'],  canon:k._0, block:b[111]},
			'3160':{ u:'3160', i:11509, name:'HANGUL LETTER YU', cat:c.Lo,  relatives:['1172', 'ffd7'],  canon:k._0, block:b[111]},
			'3161':{ u:'3161', i:11510, name:'HANGUL LETTER EU', cat:c.Lo,  relatives:['1173', 'ffda'],  canon:k._0, block:b[111]},
			'3162':{ u:'3162', i:11511, name:'HANGUL LETTER YI', cat:c.Lo,  relatives:['1174', 'ffdb'],  canon:k._0, block:b[111]},
			'3163':{ u:'3163', i:11512, name:'HANGUL LETTER I', cat:c.Lo,  relatives:['1175', 'ffdc'],  canon:k._0, block:b[111], indexed:["I"]},
			'3164':{ u:'3164', i:11513, name:'HANGUL FILLER', cat:c.Lo,  relatives:['1160', 'ffa0'],  canon:k._0, block:b[111]},
			'3165':{ u:'3165', i:11514, name:'HANGUL LETTER SSANGNIEUN', cat:c.Lo,  relatives:['1114'],  canon:k._0, block:b[111]},
			'3166':{ u:'3166', i:11515, name:'HANGUL LETTER NIEUN-TIKEUT', cat:c.Lo,  relatives:['1115'],  canon:k._0, block:b[111]},
			'3167':{ u:'3167', i:11516, name:'HANGUL LETTER NIEUN-SIOS', cat:c.Lo,  relatives:['11c7'],  canon:k._0, block:b[111]},
			'3168':{ u:'3168', i:11517, name:'HANGUL LETTER NIEUN-PANSIOS', cat:c.Lo,  relatives:['11c8'],  canon:k._0, block:b[111]},
			'3169':{ u:'3169', i:11518, name:'HANGUL LETTER RIEUL-KIYEOK-SIOS', cat:c.Lo,  relatives:['11cc'],  canon:k._0, block:b[111]},
			'3170':{ u:'3170', i:11525, name:'HANGUL LETTER MIEUM-PANSIOS', cat:c.Lo,  relatives:['11df'],  canon:k._0, block:b[111]},
			'3171':{ u:'3171', i:11526, name:'HANGUL LETTER KAPYEOUNMIEUM', cat:c.Lo,  relatives:['111d'],  canon:k._0, block:b[111]},
			'3172':{ u:'3172', i:11527, name:'HANGUL LETTER PIEUP-KIYEOK', cat:c.Lo,  relatives:['111e'],  canon:k._0, block:b[111]},
			'3173':{ u:'3173', i:11528, name:'HANGUL LETTER PIEUP-TIKEUT', cat:c.Lo,  relatives:['1120'],  canon:k._0, block:b[111]},
			'3174':{ u:'3174', i:11529, name:'HANGUL LETTER PIEUP-SIOS-KIYEOK', cat:c.Lo,  relatives:['1122'],  canon:k._0, block:b[111]},
			'3175':{ u:'3175', i:11530, name:'HANGUL LETTER PIEUP-SIOS-TIKEUT', cat:c.Lo,  relatives:['1123'],  canon:k._0, block:b[111]},
			'3176':{ u:'3176', i:11531, name:'HANGUL LETTER PIEUP-CIEUC', cat:c.Lo,  relatives:['1127'],  canon:k._0, block:b[111]},
			'3177':{ u:'3177', i:11532, name:'HANGUL LETTER PIEUP-THIEUTH', cat:c.Lo,  relatives:['1129'],  canon:k._0, block:b[111]},
			'3178':{ u:'3178', i:11533, name:'HANGUL LETTER KAPYEOUNPIEUP', cat:c.Lo,  relatives:['112b'],  canon:k._0, block:b[111]},
			'3179':{ u:'3179', i:11534, name:'HANGUL LETTER KAPYEOUNSSANGPIEUP', cat:c.Lo,  relatives:['112c'],  canon:k._0, block:b[111]},
			'3180':{ u:'3180', i:11541, name:'HANGUL LETTER SSANGIEUNG', cat:c.Lo,  relatives:['1147'],  canon:k._0, block:b[111]},
			'3181':{ u:'3181', i:11542, name:'HANGUL LETTER YESIEUNG', cat:c.Lo,  relatives:['114c'],  canon:k._0, block:b[111]},
			'3182':{ u:'3182', i:11543, name:'HANGUL LETTER YESIEUNG-SIOS', cat:c.Lo,  relatives:['11f1'],  canon:k._0, block:b[111]},
			'3183':{ u:'3183', i:11544, name:'HANGUL LETTER YESIEUNG-PANSIOS', cat:c.Lo,  relatives:['11f2'],  canon:k._0, block:b[111]},
			'3184':{ u:'3184', i:11545, name:'HANGUL LETTER KAPYEOUNPHIEUPH', cat:c.Lo,  relatives:['1157'],  canon:k._0, block:b[111]},
			'3185':{ u:'3185', i:11546, name:'HANGUL LETTER SSANGHIEUH', cat:c.Lo,  relatives:['1158'],  canon:k._0, block:b[111]},
			'3186':{ u:'3186', i:11547, name:'HANGUL LETTER YEORINHIEUH', cat:c.Lo,  relatives:['1159'],  canon:k._0, block:b[111]},
			'3187':{ u:'3187', i:11548, name:'HANGUL LETTER YO-YA', cat:c.Lo,  relatives:['1184'],  canon:k._0, block:b[111]},
			'3188':{ u:'3188', i:11549, name:'HANGUL LETTER YO-YAE', cat:c.Lo,  relatives:['1185'],  canon:k._0, block:b[111]},
			'3189':{ u:'3189', i:11550, name:'HANGUL LETTER YO-I', cat:c.Lo,  relatives:['1188'],  canon:k._0, block:b[111]},
			'3190':{ u:'3190', i:11556, name:'IDEOGRAPHIC ANNOTATION LINKING MARK', cat:c.So,   canon:k._0, block:b[112]},
			'3191':{ u:'3191', i:11557, name:'IDEOGRAPHIC ANNOTATION REVERSE MARK', cat:c.So,   canon:k._0, block:b[112]},
			'3192':{ u:'3192', i:11558, name:'IDEOGRAPHIC ANNOTATION ONE MARK', cat:c.No,  relatives:['4e00'],  canon:k._0, block:b[112]},
			'3193':{ u:'3193', i:11559, name:'IDEOGRAPHIC ANNOTATION TWO MARK', cat:c.No,  relatives:['4e8c'],  canon:k._0, block:b[112]},
			'3194':{ u:'3194', i:11560, name:'IDEOGRAPHIC ANNOTATION THREE MARK', cat:c.No,  relatives:['4e09'],  canon:k._0, block:b[112]},
			'3195':{ u:'3195', i:11561, name:'IDEOGRAPHIC ANNOTATION FOUR MARK', cat:c.No,  relatives:['56db'],  canon:k._0, block:b[112]},
			'3196':{ u:'3196', i:11562, name:'IDEOGRAPHIC ANNOTATION TOP MARK', cat:c.So,  relatives:['4e0a'],  canon:k._0, block:b[112]},
			'3197':{ u:'3197', i:11563, name:'IDEOGRAPHIC ANNOTATION MIDDLE MARK', cat:c.So,  relatives:['4e2d'],  canon:k._0, block:b[112]},
			'3198':{ u:'3198', i:11564, name:'IDEOGRAPHIC ANNOTATION BOTTOM MARK', cat:c.So,  relatives:['4e0b'],  canon:k._0, block:b[112]},
			'3199':{ u:'3199', i:11565, name:'IDEOGRAPHIC ANNOTATION FIRST MARK', cat:c.So,  relatives:['7532'],  canon:k._0, block:b[112]},
			'3200':{ u:'3200', i:11656, name:'PARENTHESIZED HANGUL KIYEOK', cat:c.So,  relatives:['0028', '1100', '0029'], comp:['0028','1100','0029'], canon:k._0, block:b[116]},
			'3201':{ u:'3201', i:11657, name:'PARENTHESIZED HANGUL NIEUN', cat:c.So,  relatives:['0028', '1102', '0029'], comp:['0028','1102','0029'], canon:k._0, block:b[116]},
			'3202':{ u:'3202', i:11658, name:'PARENTHESIZED HANGUL TIKEUT', cat:c.So,  relatives:['0028', '1103', '0029'], comp:['0028','1103','0029'], canon:k._0, block:b[116]},
			'3203':{ u:'3203', i:11659, name:'PARENTHESIZED HANGUL RIEUL', cat:c.So,  relatives:['0028', '1105', '0029'], comp:['0028','1105','0029'], canon:k._0, block:b[116]},
			'3204':{ u:'3204', i:11660, name:'PARENTHESIZED HANGUL MIEUM', cat:c.So,  relatives:['0028', '1106', '0029'], comp:['0028','1106','0029'], canon:k._0, block:b[116]},
			'3205':{ u:'3205', i:11661, name:'PARENTHESIZED HANGUL PIEUP', cat:c.So,  relatives:['0028', '1107', '0029'], comp:['0028','1107','0029'], canon:k._0, block:b[116]},
			'3206':{ u:'3206', i:11662, name:'PARENTHESIZED HANGUL SIOS', cat:c.So,  relatives:['0028', '1109', '0029'], comp:['0028','1109','0029'], canon:k._0, block:b[116]},
			'3207':{ u:'3207', i:11663, name:'PARENTHESIZED HANGUL IEUNG', cat:c.So,  relatives:['0028', '110b', '0029'], comp:['0028','110b','0029'], canon:k._0, block:b[116]},
			'3208':{ u:'3208', i:11664, name:'PARENTHESIZED HANGUL CIEUC', cat:c.So,  relatives:['0028', '110c', '0029'], comp:['0028','110c','0029'], canon:k._0, block:b[116]},
			'3209':{ u:'3209', i:11665, name:'PARENTHESIZED HANGUL CHIEUCH', cat:c.So,  relatives:['0028', '110e', '0029'], comp:['0028','110e','0029'], canon:k._0, block:b[116]},
			'3210':{ u:'3210', i:11672, name:'PARENTHESIZED HANGUL TIKEUT A', cat:c.So,  relatives:['0028', '1103', '1161', '0029'], comp:['0028','1103','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3211':{ u:'3211', i:11673, name:'PARENTHESIZED HANGUL RIEUL A', cat:c.So,  relatives:['0028', '1105', '1161', '0029'], comp:['0028','1105','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3212':{ u:'3212', i:11674, name:'PARENTHESIZED HANGUL MIEUM A', cat:c.So,  relatives:['0028', '1106', '1161', '0029'], comp:['0028','1106','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3213':{ u:'3213', i:11675, name:'PARENTHESIZED HANGUL PIEUP A', cat:c.So,  relatives:['0028', '1107', '1161', '0029'], comp:['0028','1107','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3214':{ u:'3214', i:11676, name:'PARENTHESIZED HANGUL SIOS A', cat:c.So,  relatives:['0028', '1109', '1161', '0029'], comp:['0028','1109','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3215':{ u:'3215', i:11677, name:'PARENTHESIZED HANGUL IEUNG A', cat:c.So,  relatives:['0028', '110b', '1161', '0029'], comp:['0028','110b','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3216':{ u:'3216', i:11678, name:'PARENTHESIZED HANGUL CIEUC A', cat:c.So,  relatives:['0028', '110c', '1161', '0029'], comp:['0028','110c','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3217':{ u:'3217', i:11679, name:'PARENTHESIZED HANGUL CHIEUCH A', cat:c.So,  relatives:['0028', '110e', '1161', '0029'], comp:['0028','110e','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3218':{ u:'3218', i:11680, name:'PARENTHESIZED HANGUL KHIEUKH A', cat:c.So,  relatives:['0028', '110f', '1161', '0029'], comp:['0028','110f','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3219':{ u:'3219', i:11681, name:'PARENTHESIZED HANGUL THIEUTH A', cat:c.So,  relatives:['0028', '1110', '1161', '0029'], comp:['0028','1110','1161','0029'], canon:k._0, block:b[116], indexed:["A"]},
			'3220':{ u:'3220', i:11687, name:'PARENTHESIZED IDEOGRAPH ONE', cat:c.No,  relatives:['0028', '4e00', '0029'], comp:['0028','4e00','0029'], canon:k._0, block:b[116]},
			'3221':{ u:'3221', i:11688, name:'PARENTHESIZED IDEOGRAPH TWO', cat:c.No,  relatives:['0028', '4e8c', '0029'], comp:['0028','4e8c','0029'], canon:k._0, block:b[116]},
			'3222':{ u:'3222', i:11689, name:'PARENTHESIZED IDEOGRAPH THREE', cat:c.No,  relatives:['0028', '4e09', '0029'], comp:['0028','4e09','0029'], canon:k._0, block:b[116]},
			'3223':{ u:'3223', i:11690, name:'PARENTHESIZED IDEOGRAPH FOUR', cat:c.No,  relatives:['0028', '56db', '0029'], comp:['0028','56db','0029'], canon:k._0, block:b[116]},
			'3224':{ u:'3224', i:11691, name:'PARENTHESIZED IDEOGRAPH FIVE', cat:c.No,  relatives:['0028', '4e94', '0029'], comp:['0028','4e94','0029'], canon:k._0, block:b[116]},
			'3225':{ u:'3225', i:11692, name:'PARENTHESIZED IDEOGRAPH SIX', cat:c.No,  relatives:['0028', '516d', '0029'], comp:['0028','516d','0029'], canon:k._0, block:b[116]},
			'3226':{ u:'3226', i:11693, name:'PARENTHESIZED IDEOGRAPH SEVEN', cat:c.No,  relatives:['0028', '4e03', '0029'], comp:['0028','4e03','0029'], canon:k._0, block:b[116]},
			'3227':{ u:'3227', i:11694, name:'PARENTHESIZED IDEOGRAPH EIGHT', cat:c.No,  relatives:['0028', '516b', '0029'], comp:['0028','516b','0029'], canon:k._0, block:b[116]},
			'3228':{ u:'3228', i:11695, name:'PARENTHESIZED IDEOGRAPH NINE', cat:c.No,  relatives:['0028', '4e5d', '0029'], comp:['0028','4e5d','0029'], canon:k._0, block:b[116]},
			'3229':{ u:'3229', i:11696, name:'PARENTHESIZED IDEOGRAPH TEN', cat:c.No,  relatives:['0028', '5341', '0029'], comp:['0028','5341','0029'], canon:k._0, block:b[116]},
			'3230':{ u:'3230', i:11703, name:'PARENTHESIZED IDEOGRAPH SUN', cat:c.So,  relatives:['0028', '65e5', '0029'], comp:['0028','65e5','0029'], canon:k._0, block:b[116]},
			'3231':{ u:'3231', i:11704, name:'PARENTHESIZED IDEOGRAPH STOCK', cat:c.So,  relatives:['0028', '682a', '0029'], comp:['0028','682a','0029'], canon:k._0, block:b[116]},
			'3232':{ u:'3232', i:11705, name:'PARENTHESIZED IDEOGRAPH HAVE', cat:c.So,  relatives:['0028', '6709', '0029'], comp:['0028','6709','0029'], canon:k._0, block:b[116]},
			'3233':{ u:'3233', i:11706, name:'PARENTHESIZED IDEOGRAPH SOCIETY', cat:c.So,  relatives:['0028', '793e', '0029'], comp:['0028','793e','0029'], canon:k._0, block:b[116]},
			'3234':{ u:'3234', i:11707, name:'PARENTHESIZED IDEOGRAPH NAME', cat:c.So,  relatives:['0028', '540d', '0029'], comp:['0028','540d','0029'], canon:k._0, block:b[116]},
			'3235':{ u:'3235', i:11708, name:'PARENTHESIZED IDEOGRAPH SPECIAL', cat:c.So,  relatives:['0028', '7279', '0029'], comp:['0028','7279','0029'], canon:k._0, block:b[116]},
			'3236':{ u:'3236', i:11709, name:'PARENTHESIZED IDEOGRAPH FINANCIAL', cat:c.So,  relatives:['0028', '8ca1', '0029'], comp:['0028','8ca1','0029'], canon:k._0, block:b[116]},
			'3237':{ u:'3237', i:11710, name:'PARENTHESIZED IDEOGRAPH CONGRATULATION', cat:c.So,  relatives:['0028', '795d', '0029'], comp:['0028','795d','0029'], canon:k._0, block:b[116]},
			'3238':{ u:'3238', i:11711, name:'PARENTHESIZED IDEOGRAPH LABOR', cat:c.So,  relatives:['0028', '52b4', '0029'], comp:['0028','52b4','0029'], canon:k._0, block:b[116]},
			'3239':{ u:'3239', i:11712, name:'PARENTHESIZED IDEOGRAPH REPRESENT', cat:c.So,  relatives:['0028', '4ee3', '0029'], comp:['0028','4ee3','0029'], canon:k._0, block:b[116]},
			'3240':{ u:'3240', i:11719, name:'PARENTHESIZED IDEOGRAPH FESTIVAL', cat:c.So,  relatives:['0028', '796d', '0029'], comp:['0028','796d','0029'], canon:k._0, block:b[116]},
			'3241':{ u:'3241', i:11720, name:'PARENTHESIZED IDEOGRAPH REST', cat:c.So,  relatives:['0028', '4f11', '0029'], comp:['0028','4f11','0029'], canon:k._0, block:b[116]},
			'3242':{ u:'3242', i:11721, name:'PARENTHESIZED IDEOGRAPH SELF', cat:c.So,  relatives:['0028', '81ea', '0029'], comp:['0028','81ea','0029'], canon:k._0, block:b[116]},
			'3243':{ u:'3243', i:11722, name:'PARENTHESIZED IDEOGRAPH REACH', cat:c.So,  relatives:['0028', '81f3', '0029'], comp:['0028','81f3','0029'], canon:k._0, block:b[116]},
			'3244':{ u:'3244', i:11723, name:'CIRCLED IDEOGRAPH QUESTION', cat:c.So,  relatives:['554f'],  canon:k._0, block:b[116]},
			'3245':{ u:'3245', i:11724, name:'CIRCLED IDEOGRAPH KINDERGARTEN', cat:c.So,  relatives:['5e7c'],  canon:k._0, block:b[116]},
			'3246':{ u:'3246', i:11725, name:'CIRCLED IDEOGRAPH SCHOOL', cat:c.So,  relatives:['6587'],  canon:k._0, block:b[116]},
			'3247':{ u:'3247', i:11726, name:'CIRCLED IDEOGRAPH KOTO', cat:c.So,  relatives:['7b8f'],  canon:k._0, block:b[116]},
			'3248':{ u:'3248', i:11727, name:'CIRCLED NUMBER TEN ON BLACK SQUARE', cat:c.No,   canon:k._0, block:b[116]},
			'3249':{ u:'3249', i:11728, name:'CIRCLED NUMBER TWENTY ON BLACK SQUARE', cat:c.No,   canon:k._0, block:b[116]},
			'3250':{ u:'3250', i:11735, name:'PARTNERSHIP SIGN', cat:c.So,  relatives:['0050', '0054', '0045'], comp:['0050','0054','0045'], canon:k._0, block:b[116]},
			'3251':{ u:'3251', i:11736, name:'CIRCLED NUMBER TWENTY ONE', cat:c.No,  relatives:['0032', '0031'], comp:['0032','0031'], canon:k._0, block:b[116]},
			'3252':{ u:'3252', i:11737, name:'CIRCLED NUMBER TWENTY TWO', cat:c.No,  relatives:['0032'], comp:['0032','0032'], canon:k._0, block:b[116]},
			'3253':{ u:'3253', i:11738, name:'CIRCLED NUMBER TWENTY THREE', cat:c.No,  relatives:['0032', '0033'], comp:['0032','0033'], canon:k._0, block:b[116]},
			'3254':{ u:'3254', i:11739, name:'CIRCLED NUMBER TWENTY FOUR', cat:c.No,  relatives:['0032', '0034'], comp:['0032','0034'], canon:k._0, block:b[116]},
			'3255':{ u:'3255', i:11740, name:'CIRCLED NUMBER TWENTY FIVE', cat:c.No,  relatives:['0032', '0035'], comp:['0032','0035'], canon:k._0, block:b[116]},
			'3256':{ u:'3256', i:11741, name:'CIRCLED NUMBER TWENTY SIX', cat:c.No,  relatives:['0032', '0036'], comp:['0032','0036'], canon:k._0, block:b[116]},
			'3257':{ u:'3257', i:11742, name:'CIRCLED NUMBER TWENTY SEVEN', cat:c.No,  relatives:['0032', '0037'], comp:['0032','0037'], canon:k._0, block:b[116]},
			'3258':{ u:'3258', i:11743, name:'CIRCLED NUMBER TWENTY EIGHT', cat:c.No,  relatives:['0032', '0038'], comp:['0032','0038'], canon:k._0, block:b[116]},
			'3259':{ u:'3259', i:11744, name:'CIRCLED NUMBER TWENTY NINE', cat:c.No,  relatives:['0032', '0039'], comp:['0032','0039'], canon:k._0, block:b[116]},
			'3260':{ u:'3260', i:11751, name:'CIRCLED HANGUL KIYEOK', cat:c.So,  relatives:['1100'],  canon:k._0, block:b[116]},
			'3261':{ u:'3261', i:11752, name:'CIRCLED HANGUL NIEUN', cat:c.So,  relatives:['1102'],  canon:k._0, block:b[116]},
			'3262':{ u:'3262', i:11753, name:'CIRCLED HANGUL TIKEUT', cat:c.So,  relatives:['1103'],  canon:k._0, block:b[116]},
			'3263':{ u:'3263', i:11754, name:'CIRCLED HANGUL RIEUL', cat:c.So,  relatives:['1105'],  canon:k._0, block:b[116]},
			'3264':{ u:'3264', i:11755, name:'CIRCLED HANGUL MIEUM', cat:c.So,  relatives:['1106'],  canon:k._0, block:b[116]},
			'3265':{ u:'3265', i:11756, name:'CIRCLED HANGUL PIEUP', cat:c.So,  relatives:['1107'],  canon:k._0, block:b[116]},
			'3266':{ u:'3266', i:11757, name:'CIRCLED HANGUL SIOS', cat:c.So,  relatives:['1109'],  canon:k._0, block:b[116]},
			'3267':{ u:'3267', i:11758, name:'CIRCLED HANGUL IEUNG', cat:c.So,  relatives:['110b'],  canon:k._0, block:b[116]},
			'3268':{ u:'3268', i:11759, name:'CIRCLED HANGUL CIEUC', cat:c.So,  relatives:['110c'],  canon:k._0, block:b[116]},
			'3269':{ u:'3269', i:11760, name:'CIRCLED HANGUL CHIEUCH', cat:c.So,  relatives:['110e'],  canon:k._0, block:b[116]},
			'3270':{ u:'3270', i:11767, name:'CIRCLED HANGUL TIKEUT A', cat:c.So,  relatives:['1103', '1161'], comp:['1103','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3271':{ u:'3271', i:11768, name:'CIRCLED HANGUL RIEUL A', cat:c.So,  relatives:['1105', '1161'], comp:['1105','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3272':{ u:'3272', i:11769, name:'CIRCLED HANGUL MIEUM A', cat:c.So,  relatives:['1106', '1161'], comp:['1106','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3273':{ u:'3273', i:11770, name:'CIRCLED HANGUL PIEUP A', cat:c.So,  relatives:['1107', '1161'], comp:['1107','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3274':{ u:'3274', i:11771, name:'CIRCLED HANGUL SIOS A', cat:c.So,  relatives:['1109', '1161'], comp:['1109','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3275':{ u:'3275', i:11772, name:'CIRCLED HANGUL IEUNG A', cat:c.So,  relatives:['110b', '1161'], comp:['110b','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3276':{ u:'3276', i:11773, name:'CIRCLED HANGUL CIEUC A', cat:c.So,  relatives:['110c', '1161'], comp:['110c','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3277':{ u:'3277', i:11774, name:'CIRCLED HANGUL CHIEUCH A', cat:c.So,  relatives:['110e', '1161'], comp:['110e','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3278':{ u:'3278', i:11775, name:'CIRCLED HANGUL KHIEUKH A', cat:c.So,  relatives:['110f', '1161'], comp:['110f','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3279':{ u:'3279', i:11776, name:'CIRCLED HANGUL THIEUTH A', cat:c.So,  relatives:['1110', '1161'], comp:['1110','1161'], canon:k._0, block:b[116], indexed:["A"]},
			'3280':{ u:'3280', i:11783, name:'CIRCLED IDEOGRAPH ONE', cat:c.No,  relatives:['4e00'],  canon:k._0, block:b[116]},
			'3281':{ u:'3281', i:11784, name:'CIRCLED IDEOGRAPH TWO', cat:c.No,  relatives:['4e8c'],  canon:k._0, block:b[116]},
			'3282':{ u:'3282', i:11785, name:'CIRCLED IDEOGRAPH THREE', cat:c.No,  relatives:['4e09'],  canon:k._0, block:b[116]},
			'3283':{ u:'3283', i:11786, name:'CIRCLED IDEOGRAPH FOUR', cat:c.No,  relatives:['56db'],  canon:k._0, block:b[116]},
			'3284':{ u:'3284', i:11787, name:'CIRCLED IDEOGRAPH FIVE', cat:c.No,  relatives:['4e94'],  canon:k._0, block:b[116]},
			'3285':{ u:'3285', i:11788, name:'CIRCLED IDEOGRAPH SIX', cat:c.No,  relatives:['516d'],  canon:k._0, block:b[116]},
			'3286':{ u:'3286', i:11789, name:'CIRCLED IDEOGRAPH SEVEN', cat:c.No,  relatives:['4e03'],  canon:k._0, block:b[116]},
			'3287':{ u:'3287', i:11790, name:'CIRCLED IDEOGRAPH EIGHT', cat:c.No,  relatives:['516b'],  canon:k._0, block:b[116]},
			'3288':{ u:'3288', i:11791, name:'CIRCLED IDEOGRAPH NINE', cat:c.No,  relatives:['4e5d'],  canon:k._0, block:b[116]},
			'3289':{ u:'3289', i:11792, name:'CIRCLED IDEOGRAPH TEN', cat:c.No,  relatives:['5341'],  canon:k._0, block:b[116]},
			'3290':{ u:'3290', i:11799, name:'CIRCLED IDEOGRAPH SUN', cat:c.So,  relatives:['65e5'],  canon:k._0, block:b[116]},
			'3291':{ u:'3291', i:11800, name:'CIRCLED IDEOGRAPH STOCK', cat:c.So,  relatives:['682a'],  canon:k._0, block:b[116]},
			'3292':{ u:'3292', i:11801, name:'CIRCLED IDEOGRAPH HAVE', cat:c.So,  relatives:['6709'],  canon:k._0, block:b[116]},
			'3293':{ u:'3293', i:11802, name:'CIRCLED IDEOGRAPH SOCIETY', cat:c.So,  relatives:['793e'],  canon:k._0, block:b[116]},
			'3294':{ u:'3294', i:11803, name:'CIRCLED IDEOGRAPH NAME', cat:c.So,  relatives:['540d'],  canon:k._0, block:b[116]},
			'3295':{ u:'3295', i:11804, name:'CIRCLED IDEOGRAPH SPECIAL', cat:c.So,  relatives:['7279'],  canon:k._0, block:b[116]},
			'3296':{ u:'3296', i:11805, name:'CIRCLED IDEOGRAPH FINANCIAL', cat:c.So,  relatives:['8ca1'],  canon:k._0, block:b[116]},
			'3297':{ u:'3297', i:11806, name:'CIRCLED IDEOGRAPH CONGRATULATION', cat:c.So,  relatives:['795d'],  canon:k._0, block:b[116]},
			'3298':{ u:'3298', i:11807, name:'CIRCLED IDEOGRAPH LABOR', cat:c.So,  relatives:['52b4'],  canon:k._0, block:b[116]},
			'3299':{ u:'3299', i:11808, name:'CIRCLED IDEOGRAPH SECRET', cat:c.So,  relatives:['79d8'],  canon:k._0, block:b[116]},
			'3300':{ u:'3300', i:11911, name:'SQUARE APAATO', cat:c.So,  relatives:['30a2', '30d1', '30fc', '30c8'], comp:['30a2','30d1','30fc','30c8'], canon:k._0, block:b[117]},
			'3301':{ u:'3301', i:11912, name:'SQUARE ARUHUA', cat:c.So,  relatives:['30a2', '30eb', '30d5', '30a1'], comp:['30a2','30eb','30d5','30a1'], canon:k._0, block:b[117]},
			'3302':{ u:'3302', i:11913, name:'SQUARE ANPEA', cat:c.So,  relatives:['30a2', '30f3', '30da'], comp:['30a2','30f3','30da','30a2'], canon:k._0, block:b[117]},
			'3303':{ u:'3303', i:11914, name:'SQUARE AARU', cat:c.So,  relatives:['30a2', '30fc', '30eb'], comp:['30a2','30fc','30eb'], canon:k._0, block:b[117]},
			'3304':{ u:'3304', i:11915, name:'SQUARE ININGU', cat:c.So,  relatives:['30a4', '30cb', '30f3', '30b0'], comp:['30a4','30cb','30f3','30b0'], canon:k._0, block:b[117]},
			'3305':{ u:'3305', i:11916, name:'SQUARE INTI', cat:c.So,  relatives:['30a4', '30f3', '30c1'], comp:['30a4','30f3','30c1'], canon:k._0, block:b[117]},
			'3306':{ u:'3306', i:11917, name:'SQUARE UON', cat:c.So,  relatives:['30a6', '30a9', '30f3'], comp:['30a6','30a9','30f3'], canon:k._0, block:b[117]},
			'3307':{ u:'3307', i:11918, name:'SQUARE ESUKUUDO', cat:c.So,  relatives:['30a8', '30b9', '30af', '30fc', '30c9'], comp:['30a8','30b9','30af','30fc','30c9'], canon:k._0, block:b[117]},
			'3308':{ u:'3308', i:11919, name:'SQUARE EEKAA', cat:c.So,  relatives:['30a8', '30fc', '30ab'], comp:['30a8','30fc','30ab','30fc'], canon:k._0, block:b[117]},
			'3309':{ u:'3309', i:11920, name:'SQUARE ONSU', cat:c.So,  relatives:['30aa', '30f3', '30b9'], comp:['30aa','30f3','30b9'], canon:k._0, block:b[117]},
			'3310':{ u:'3310', i:11927, name:'SQUARE GIGA', cat:c.So,  relatives:['30ae', '30ac'], comp:['30ae','30ac'], canon:k._0, block:b[117]},
			'3311':{ u:'3311', i:11928, name:'SQUARE GINII', cat:c.So,  relatives:['30ae', '30cb', '30fc'], comp:['30ae','30cb','30fc'], canon:k._0, block:b[117]},
			'3312':{ u:'3312', i:11929, name:'SQUARE KYURII', cat:c.So,  relatives:['30ad', '30e5', '30ea', '30fc'], comp:['30ad','30e5','30ea','30fc'], canon:k._0, block:b[117]},
			'3313':{ u:'3313', i:11930, name:'SQUARE GIRUDAA', cat:c.So,  relatives:['30ae', '30eb', '30c0', '30fc'], comp:['30ae','30eb','30c0','30fc'], canon:k._0, block:b[117]},
			'3314':{ u:'3314', i:11931, name:'SQUARE KIRO', cat:c.So,  relatives:['30ad', '30ed'], comp:['30ad','30ed'], canon:k._0, block:b[117]},
			'3315':{ u:'3315', i:11932, name:'SQUARE KIROGURAMU', cat:c.So,  relatives:['30ad', '30ed', '30b0', '30e9', '30e0'], comp:['30ad','30ed','30b0','30e9','30e0'], canon:k._0, block:b[117]},
			'3316':{ u:'3316', i:11933, name:'SQUARE KIROMEETORU', cat:c.So,  relatives:['30ad', '30ed', '30e1', '30fc', '30c8', '30eb'], comp:['30ad','30ed','30e1','30fc','30c8','30eb'], canon:k._0, block:b[117]},
			'3317':{ u:'3317', i:11934, name:'SQUARE KIROWATTO', cat:c.So,  relatives:['30ad', '30ed', '30ef', '30c3', '30c8'], comp:['30ad','30ed','30ef','30c3','30c8'], canon:k._0, block:b[117]},
			'3318':{ u:'3318', i:11935, name:'SQUARE GURAMU', cat:c.So,  relatives:['30b0', '30e9', '30e0'], comp:['30b0','30e9','30e0'], canon:k._0, block:b[117]},
			'3319':{ u:'3319', i:11936, name:'SQUARE GURAMUTON', cat:c.So,  relatives:['30b0', '30e9', '30e0', '30c8', '30f3'], comp:['30b0','30e9','30e0','30c8','30f3'], canon:k._0, block:b[117]},
			'3320':{ u:'3320', i:11943, name:'SQUARE SANTIIMU', cat:c.So,  relatives:['30b5', '30f3', '30c1', '30fc', '30e0'], comp:['30b5','30f3','30c1','30fc','30e0'], canon:k._0, block:b[117]},
			'3321':{ u:'3321', i:11944, name:'SQUARE SIRINGU', cat:c.So,  relatives:['30b7', '30ea', '30f3', '30b0'], comp:['30b7','30ea','30f3','30b0'], canon:k._0, block:b[117]},
			'3322':{ u:'3322', i:11945, name:'SQUARE SENTI', cat:c.So,  relatives:['30bb', '30f3', '30c1'], comp:['30bb','30f3','30c1'], canon:k._0, block:b[117]},
			'3323':{ u:'3323', i:11946, name:'SQUARE SENTO', cat:c.So,  relatives:['30bb', '30f3', '30c8'], comp:['30bb','30f3','30c8'], canon:k._0, block:b[117]},
			'3324':{ u:'3324', i:11947, name:'SQUARE DAASU', cat:c.So,  relatives:['30c0', '30fc', '30b9'], comp:['30c0','30fc','30b9'], canon:k._0, block:b[117]},
			'3325':{ u:'3325', i:11948, name:'SQUARE DESI', cat:c.So,  relatives:['30c7', '30b7'], comp:['30c7','30b7'], canon:k._0, block:b[117]},
			'3326':{ u:'3326', i:11949, name:'SQUARE DORU', cat:c.So,  relatives:['30c9', '30eb'], comp:['30c9','30eb'], canon:k._0, block:b[117]},
			'3327':{ u:'3327', i:11950, name:'SQUARE TON', cat:c.So,  relatives:['30c8', '30f3'], comp:['30c8','30f3'], canon:k._0, block:b[117]},
			'3328':{ u:'3328', i:11951, name:'SQUARE NANO', cat:c.So,  relatives:['30ca', '30ce'], comp:['30ca','30ce'], canon:k._0, block:b[117]},
			'3329':{ u:'3329', i:11952, name:'SQUARE NOTTO', cat:c.So,  relatives:['30ce', '30c3', '30c8'], comp:['30ce','30c3','30c8'], canon:k._0, block:b[117]},
			'3330':{ u:'3330', i:11959, name:'SQUARE PIKO', cat:c.So,  relatives:['30d4', '30b3'], comp:['30d4','30b3'], canon:k._0, block:b[117]},
			'3331':{ u:'3331', i:11960, name:'SQUARE BIRU', cat:c.So,  relatives:['30d3', '30eb'], comp:['30d3','30eb'], canon:k._0, block:b[117]},
			'3332':{ u:'3332', i:11961, name:'SQUARE HUARADDO', cat:c.So,  relatives:['30d5', '30a1', '30e9', '30c3', '30c9'], comp:['30d5','30a1','30e9','30c3','30c9'], canon:k._0, block:b[117]},
			'3333':{ u:'3333', i:11962, name:'SQUARE HUIITO', cat:c.So,  relatives:['30d5', '30a3', '30fc', '30c8'], comp:['30d5','30a3','30fc','30c8'], canon:k._0, block:b[117]},
			'3334':{ u:'3334', i:11963, name:'SQUARE BUSSYERU', cat:c.So,  relatives:['30d6', '30c3', '30b7', '30a7', '30eb'], comp:['30d6','30c3','30b7','30a7','30eb'], canon:k._0, block:b[117]},
			'3335':{ u:'3335', i:11964, name:'SQUARE HURAN', cat:c.So,  relatives:['30d5', '30e9', '30f3'], comp:['30d5','30e9','30f3'], canon:k._0, block:b[117]},
			'3336':{ u:'3336', i:11965, name:'SQUARE HEKUTAARU', cat:c.So,  relatives:['30d8', '30af', '30bf', '30fc', '30eb'], comp:['30d8','30af','30bf','30fc','30eb'], canon:k._0, block:b[117]},
			'3337':{ u:'3337', i:11966, name:'SQUARE PESO', cat:c.So,  relatives:['30da', '30bd'], comp:['30da','30bd'], canon:k._0, block:b[117]},
			'3338':{ u:'3338', i:11967, name:'SQUARE PENIHI', cat:c.So,  relatives:['30da', '30cb', '30d2'], comp:['30da','30cb','30d2'], canon:k._0, block:b[117]},
			'3339':{ u:'3339', i:11968, name:'SQUARE HERUTU', cat:c.So,  relatives:['30d8', '30eb', '30c4'], comp:['30d8','30eb','30c4'], canon:k._0, block:b[117]},
			'3340':{ u:'3340', i:11975, name:'SQUARE PONDO', cat:c.So,  relatives:['30dd', '30f3', '30c9'], comp:['30dd','30f3','30c9'], canon:k._0, block:b[117]},
			'3341':{ u:'3341', i:11976, name:'SQUARE HOORU', cat:c.So,  relatives:['30db', '30fc', '30eb'], comp:['30db','30fc','30eb'], canon:k._0, block:b[117]},
			'3342':{ u:'3342', i:11977, name:'SQUARE HOON', cat:c.So,  relatives:['30db', '30fc', '30f3'], comp:['30db','30fc','30f3'], canon:k._0, block:b[117]},
			'3343':{ u:'3343', i:11978, name:'SQUARE MAIKURO', cat:c.So,  relatives:['30de', '30a4', '30af', '30ed'], comp:['30de','30a4','30af','30ed'], canon:k._0, block:b[117]},
			'3344':{ u:'3344', i:11979, name:'SQUARE MAIRU', cat:c.So,  relatives:['30de', '30a4', '30eb'], comp:['30de','30a4','30eb'], canon:k._0, block:b[117]},
			'3345':{ u:'3345', i:11980, name:'SQUARE MAHHA', cat:c.So,  relatives:['30de', '30c3', '30cf'], comp:['30de','30c3','30cf'], canon:k._0, block:b[117]},
			'3346':{ u:'3346', i:11981, name:'SQUARE MARUKU', cat:c.So,  relatives:['30de', '30eb', '30af'], comp:['30de','30eb','30af'], canon:k._0, block:b[117]},
			'3347':{ u:'3347', i:11982, name:'SQUARE MANSYON', cat:c.So,  relatives:['30de', '30f3', '30b7', '30e7'], comp:['30de','30f3','30b7','30e7','30f3'], canon:k._0, block:b[117]},
			'3348':{ u:'3348', i:11983, name:'SQUARE MIKURON', cat:c.So,  relatives:['30df', '30af', '30ed', '30f3'], comp:['30df','30af','30ed','30f3'], canon:k._0, block:b[117]},
			'3349':{ u:'3349', i:11984, name:'SQUARE MIRI', cat:c.So,  relatives:['30df', '30ea'], comp:['30df','30ea'], canon:k._0, block:b[117]},
			'3350':{ u:'3350', i:11991, name:'SQUARE YUAN', cat:c.So,  relatives:['30e6', '30a2', '30f3'], comp:['30e6','30a2','30f3'], canon:k._0, block:b[117]},
			'3351':{ u:'3351', i:11992, name:'SQUARE RITTORU', cat:c.So,  relatives:['30ea', '30c3', '30c8', '30eb'], comp:['30ea','30c3','30c8','30eb'], canon:k._0, block:b[117]},
			'3352':{ u:'3352', i:11993, name:'SQUARE RIRA', cat:c.So,  relatives:['30ea', '30e9'], comp:['30ea','30e9'], canon:k._0, block:b[117]},
			'3353':{ u:'3353', i:11994, name:'SQUARE RUPII', cat:c.So,  relatives:['30eb', '30d4', '30fc'], comp:['30eb','30d4','30fc'], canon:k._0, block:b[117]},
			'3354':{ u:'3354', i:11995, name:'SQUARE RUUBURU', cat:c.So,  relatives:['30eb', '30fc', '30d6'], comp:['30eb','30fc','30d6','30eb'], canon:k._0, block:b[117]},
			'3355':{ u:'3355', i:11996, name:'SQUARE REMU', cat:c.So,  relatives:['30ec', '30e0'], comp:['30ec','30e0'], canon:k._0, block:b[117]},
			'3356':{ u:'3356', i:11997, name:'SQUARE RENTOGEN', cat:c.So,  relatives:['30ec', '30f3', '30c8', '30b2'], comp:['30ec','30f3','30c8','30b2','30f3'], canon:k._0, block:b[117]},
			'3357':{ u:'3357', i:11998, name:'SQUARE WATTO', cat:c.So,  relatives:['30ef', '30c3', '30c8'], comp:['30ef','30c3','30c8'], canon:k._0, block:b[117]},
			'3358':{ u:'3358', i:11999, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO', cat:c.So,  relatives:['0030', '70b9'], comp:['0030','70b9'], canon:k._0, block:b[117]},
			'3359':{ u:'3359', i:12000, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE', cat:c.So,  relatives:['0031', '70b9'], comp:['0031','70b9'], canon:k._0, block:b[117]},
			'3360':{ u:'3360', i:12007, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT', cat:c.So,  relatives:['0038', '70b9'], comp:['0038','70b9'], canon:k._0, block:b[117]},
			'3361':{ u:'3361', i:12008, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE', cat:c.So,  relatives:['0039', '70b9'], comp:['0039','70b9'], canon:k._0, block:b[117]},
			'3362':{ u:'3362', i:12009, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN', cat:c.So,  relatives:['0031', '0030', '70b9'], comp:['0031','0030','70b9'], canon:k._0, block:b[117]},
			'3363':{ u:'3363', i:12010, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN', cat:c.So,  relatives:['0031', '70b9'], comp:['0031','0031','70b9'], canon:k._0, block:b[117]},
			'3364':{ u:'3364', i:12011, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE', cat:c.So,  relatives:['0031', '0032', '70b9'], comp:['0031','0032','70b9'], canon:k._0, block:b[117]},
			'3365':{ u:'3365', i:12012, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN', cat:c.So,  relatives:['0031', '0033', '70b9'], comp:['0031','0033','70b9'], canon:k._0, block:b[117]},
			'3366':{ u:'3366', i:12013, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN', cat:c.So,  relatives:['0031', '0034', '70b9'], comp:['0031','0034','70b9'], canon:k._0, block:b[117]},
			'3367':{ u:'3367', i:12014, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN', cat:c.So,  relatives:['0031', '0035', '70b9'], comp:['0031','0035','70b9'], canon:k._0, block:b[117]},
			'3368':{ u:'3368', i:12015, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN', cat:c.So,  relatives:['0031', '0036', '70b9'], comp:['0031','0036','70b9'], canon:k._0, block:b[117]},
			'3369':{ u:'3369', i:12016, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN', cat:c.So,  relatives:['0031', '0037', '70b9'], comp:['0031','0037','70b9'], canon:k._0, block:b[117]},
			'3370':{ u:'3370', i:12023, name:'IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR', cat:c.So,  relatives:['0032', '0034', '70b9'], comp:['0032','0034','70b9'], canon:k._0, block:b[117]},
			'3371':{ u:'3371', i:12024, name:'SQUARE HPA', cat:c.So,  relatives:['0068', '0050', '0061'], comp:['0068','0050','0061'], canon:k._0, block:b[117]},
			'3372':{ u:'3372', i:12025, name:'SQUARE DA', cat:c.So,  relatives:['0064', '0061'], comp:['0064','0061'], canon:k._0, block:b[117]},
			'3373':{ u:'3373', i:12026, name:'SQUARE AU', cat:c.So,  relatives:['0041', '0055'], comp:['0041','0055'], canon:k._0, block:b[117]},
			'3374':{ u:'3374', i:12027, name:'SQUARE BAR', cat:c.So,  relatives:['0062', '0061', '0072'], comp:['0062','0061','0072'], canon:k._0, block:b[117]},
			'3375':{ u:'3375', i:12028, name:'SQUARE OV', cat:c.So,  relatives:['006f', '0056'], comp:['006f','0056'], canon:k._0, block:b[117]},
			'3376':{ u:'3376', i:12029, name:'SQUARE PC', cat:c.So,  relatives:['0070', '0063'], comp:['0070','0063'], canon:k._0, block:b[117]},
			'3377':{ u:'3377', i:12030, name:'SQUARE DM', cat:c.So,  relatives:['0064', '006d'], comp:['0064','006d'], canon:k._0, block:b[117]},
			'3378':{ u:'3378', i:12031, name:'SQUARE DM SQUARED', cat:c.So,  relatives:['0064', '006d', '00b2'], comp:['0064','006d','00b2'], canon:k._0, block:b[117]},
			'3379':{ u:'3379', i:12032, name:'SQUARE DM CUBED', cat:c.So,  relatives:['0064', '006d', '00b3'], comp:['0064','006d','00b3'], canon:k._0, block:b[117]},
			'3380':{ u:'3380', i:12039, name:'SQUARE PA AMPS', cat:c.So,  relatives:['0070', '0041'], comp:['0070','0041'], canon:k._0, block:b[117]},
			'3381':{ u:'3381', i:12040, name:'SQUARE NA', cat:c.So,  relatives:['006e', '0041'], comp:['006e','0041'], canon:k._0, block:b[117]},
			'3382':{ u:'3382', i:12041, name:'SQUARE MU A', cat:c.So,  relatives:['03bc', '0041'], comp:['03bc','0041'], canon:k._0, block:b[117], indexed:["A"]},
			'3383':{ u:'3383', i:12042, name:'SQUARE MA', cat:c.So,  relatives:['006d', '0041'], comp:['006d','0041'], canon:k._0, block:b[117]},
			'3384':{ u:'3384', i:12043, name:'SQUARE KA', cat:c.So,  relatives:['006b', '0041'], comp:['006b','0041'], canon:k._0, block:b[117]},
			'3385':{ u:'3385', i:12044, name:'SQUARE KB', cat:c.So,  relatives:['004b', '0042'], comp:['004b','0042'], canon:k._0, block:b[117]},
			'3386':{ u:'3386', i:12045, name:'SQUARE MB', cat:c.So,  relatives:['004d', '0042'], comp:['004d','0042'], canon:k._0, block:b[117]},
			'3387':{ u:'3387', i:12046, name:'SQUARE GB', cat:c.So,  relatives:['0047', '0042'], comp:['0047','0042'], canon:k._0, block:b[117]},
			'3388':{ u:'3388', i:12047, name:'SQUARE CAL', cat:c.So,  relatives:['0063', '0061', '006c'], comp:['0063','0061','006c'], canon:k._0, block:b[117]},
			'3389':{ u:'3389', i:12048, name:'SQUARE KCAL', cat:c.So,  relatives:['006b', '0063', '0061', '006c'], comp:['006b','0063','0061','006c'], canon:k._0, block:b[117]},
			'3390':{ u:'3390', i:12055, name:'SQUARE HZ', cat:c.So,  relatives:['0048', '007a'], comp:['0048','007a'], canon:k._0, block:b[117]},
			'3391':{ u:'3391', i:12056, name:'SQUARE KHZ', cat:c.So,  relatives:['006b', '0048', '007a'], comp:['006b','0048','007a'], canon:k._0, block:b[117]},
			'3392':{ u:'3392', i:12057, name:'SQUARE MHZ', cat:c.So,  relatives:['004d', '0048', '007a'], comp:['004d','0048','007a'], canon:k._0, block:b[117]},
			'3393':{ u:'3393', i:12058, name:'SQUARE GHZ', cat:c.So,  relatives:['0047', '0048', '007a'], comp:['0047','0048','007a'], canon:k._0, block:b[117]},
			'3394':{ u:'3394', i:12059, name:'SQUARE THZ', cat:c.So,  relatives:['0054', '0048', '007a'], comp:['0054','0048','007a'], canon:k._0, block:b[117]},
			'3395':{ u:'3395', i:12060, name:'SQUARE MU L', cat:c.So,  relatives:['03bc', '2113'], comp:['03bc','2113'], canon:k._0, block:b[117], indexed:["L"]},
			'3396':{ u:'3396', i:12061, name:'SQUARE ML', cat:c.So,  relatives:['006d', '2113'], comp:['006d','2113'], canon:k._0, block:b[117]},
			'3397':{ u:'3397', i:12062, name:'SQUARE DL', cat:c.So,  relatives:['0064', '2113'], comp:['0064','2113'], canon:k._0, block:b[117]},
			'3398':{ u:'3398', i:12063, name:'SQUARE KL', cat:c.So,  relatives:['006b', '2113'], comp:['006b','2113'], canon:k._0, block:b[117]},
			'3399':{ u:'3399', i:12064, name:'SQUARE FM', cat:c.So,  relatives:['0066', '006d'], comp:['0066','006d'], canon:k._0, block:b[117]},
			'3400':{ u:'3400', i:12167, name:'<CJK Ideograph Extension A, First>', cat:c.Lo,   canon:k._0, block:b[118]},
			'10000':{ u:'10000', i:16825, name:'LINEAR B SYLLABLE B008 A', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B","A"]},
			'10001':{ u:'10001', i:16826, name:'LINEAR B SYLLABLE B038 E', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B","E"]},
			'10002':{ u:'10002', i:16827, name:'LINEAR B SYLLABLE B028 I', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B","I"]},
			'10003':{ u:'10003', i:16828, name:'LINEAR B SYLLABLE B061 O', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B","O"]},
			'10004':{ u:'10004', i:16829, name:'LINEAR B SYLLABLE B010 U', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B","U"]},
			'10005':{ u:'10005', i:16830, name:'LINEAR B SYLLABLE B001 DA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10006':{ u:'10006', i:16831, name:'LINEAR B SYLLABLE B045 DE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10007':{ u:'10007', i:16832, name:'LINEAR B SYLLABLE B007 DI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10008':{ u:'10008', i:16833, name:'LINEAR B SYLLABLE B014 DO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10009':{ u:'10009', i:16834, name:'LINEAR B SYLLABLE B051 DU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10010':{ u:'10010', i:16840, name:'LINEAR B SYLLABLE B044 KE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10011':{ u:'10011', i:16841, name:'LINEAR B SYLLABLE B067 KI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10012':{ u:'10012', i:16842, name:'LINEAR B SYLLABLE B070 KO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10013':{ u:'10013', i:16843, name:'LINEAR B SYLLABLE B081 KU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10014':{ u:'10014', i:16844, name:'LINEAR B SYLLABLE B080 MA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10015':{ u:'10015', i:16845, name:'LINEAR B SYLLABLE B013 ME', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10016':{ u:'10016', i:16846, name:'LINEAR B SYLLABLE B073 MI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10017':{ u:'10017', i:16847, name:'LINEAR B SYLLABLE B015 MO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10018':{ u:'10018', i:16848, name:'LINEAR B SYLLABLE B023 MU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10019':{ u:'10019', i:16849, name:'LINEAR B SYLLABLE B006 NA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10020':{ u:'10020', i:16856, name:'LINEAR B SYLLABLE B039 PI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10021':{ u:'10021', i:16857, name:'LINEAR B SYLLABLE B011 PO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10022':{ u:'10022', i:16858, name:'LINEAR B SYLLABLE B050 PU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10023':{ u:'10023', i:16859, name:'LINEAR B SYLLABLE B016 QA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10024':{ u:'10024', i:16860, name:'LINEAR B SYLLABLE B078 QE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10025':{ u:'10025', i:16861, name:'LINEAR B SYLLABLE B021 QI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10026':{ u:'10026', i:16862, name:'LINEAR B SYLLABLE B032 QO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10028':{ u:'10028', i:16863, name:'LINEAR B SYLLABLE B060 RA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10029':{ u:'10029', i:16864, name:'LINEAR B SYLLABLE B027 RE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10030':{ u:'10030', i:16871, name:'LINEAR B SYLLABLE B012 SO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10031':{ u:'10031', i:16872, name:'LINEAR B SYLLABLE B058 SU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10032':{ u:'10032', i:16873, name:'LINEAR B SYLLABLE B059 TA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10033':{ u:'10033', i:16874, name:'LINEAR B SYLLABLE B004 TE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10034':{ u:'10034', i:16875, name:'LINEAR B SYLLABLE B037 TI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10035':{ u:'10035', i:16876, name:'LINEAR B SYLLABLE B005 TO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10036':{ u:'10036', i:16877, name:'LINEAR B SYLLABLE B069 TU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10037':{ u:'10037', i:16878, name:'LINEAR B SYLLABLE B054 WA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10038':{ u:'10038', i:16879, name:'LINEAR B SYLLABLE B075 WE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10039':{ u:'10039', i:16880, name:'LINEAR B SYLLABLE B040 WI', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10040':{ u:'10040', i:16885, name:'LINEAR B SYLLABLE B025 A2', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10041':{ u:'10041', i:16886, name:'LINEAR B SYLLABLE B043 A3', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10042':{ u:'10042', i:16887, name:'LINEAR B SYLLABLE B085 AU', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10043':{ u:'10043', i:16888, name:'LINEAR B SYLLABLE B071 DWE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10044':{ u:'10044', i:16889, name:'LINEAR B SYLLABLE B090 DWO', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10045':{ u:'10045', i:16890, name:'LINEAR B SYLLABLE B048 NWA', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10046':{ u:'10046', i:16891, name:'LINEAR B SYLLABLE B029 PU2', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10047':{ u:'10047', i:16892, name:'LINEAR B SYLLABLE B062 PTE', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10048':{ u:'10048', i:16893, name:'LINEAR B SYLLABLE B076 RA2', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10049':{ u:'10049', i:16894, name:'LINEAR B SYLLABLE B033 RA3', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10050':{ u:'10050', i:16899, name:'LINEAR B SYMBOL B018', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10051':{ u:'10051', i:16900, name:'LINEAR B SYMBOL B019', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10052':{ u:'10052', i:16901, name:'LINEAR B SYMBOL B022', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10053':{ u:'10053', i:16902, name:'LINEAR B SYMBOL B034', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10054':{ u:'10054', i:16903, name:'LINEAR B SYMBOL B047', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10055':{ u:'10055', i:16904, name:'LINEAR B SYMBOL B049', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10056':{ u:'10056', i:16905, name:'LINEAR B SYMBOL B056', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10057':{ u:'10057', i:16906, name:'LINEAR B SYMBOL B063', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10058':{ u:'10058', i:16907, name:'LINEAR B SYMBOL B064', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10059':{ u:'10059', i:16908, name:'LINEAR B SYMBOL B079', cat:c.Lo,   canon:k._0, block:b[164], indexed:["B"]},
			'10080':{ u:'10080', i:16913, name:'LINEAR B IDEOGRAM B100 MAN', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10081':{ u:'10081', i:16914, name:'LINEAR B IDEOGRAM B102 WOMAN', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10082':{ u:'10082', i:16915, name:'LINEAR B IDEOGRAM B104 DEER', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10083':{ u:'10083', i:16916, name:'LINEAR B IDEOGRAM B105 EQUID', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10084':{ u:'10084', i:16917, name:'LINEAR B IDEOGRAM B105F MARE', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10085':{ u:'10085', i:16918, name:'LINEAR B IDEOGRAM B105M STALLION', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10086':{ u:'10086', i:16919, name:'LINEAR B IDEOGRAM B106F EWE', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10087':{ u:'10087', i:16920, name:'LINEAR B IDEOGRAM B106M RAM', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10088':{ u:'10088', i:16921, name:'LINEAR B IDEOGRAM B107F SHE-GOAT', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10089':{ u:'10089', i:16922, name:'LINEAR B IDEOGRAM B107M HE-GOAT', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10090':{ u:'10090', i:16929, name:'LINEAR B IDEOGRAM B122 OLIVE', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10091':{ u:'10091', i:16930, name:'LINEAR B IDEOGRAM B123 SPICE', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10092':{ u:'10092', i:16931, name:'LINEAR B IDEOGRAM B125 CYPERUS', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10093':{ u:'10093', i:16932, name:'LINEAR B MONOGRAM B127 KAPO', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10094':{ u:'10094', i:16933, name:'LINEAR B MONOGRAM B128 KANAKO', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10095':{ u:'10095', i:16934, name:'LINEAR B IDEOGRAM B130 OIL', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10096':{ u:'10096', i:16935, name:'LINEAR B IDEOGRAM B131 WINE', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10097':{ u:'10097', i:16936, name:'LINEAR B IDEOGRAM B132', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10098':{ u:'10098', i:16937, name:'LINEAR B MONOGRAM B133 AREPA', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10099':{ u:'10099', i:16938, name:'LINEAR B MONOGRAM B135 MERI', cat:c.Lo,   canon:k._0, block:b[165], indexed:["B"]},
			'10100':{ u:'10100', i:17036, name:'AEGEAN WORD SEPARATOR LINE', cat:c.Po,   canon:k._0, block:b[166]},
			'10101':{ u:'10101', i:17037, name:'AEGEAN WORD SEPARATOR DOT', cat:c.Po,   canon:k._0, block:b[166]},
			'10102':{ u:'10102', i:17038, name:'AEGEAN CHECK MARK', cat:c.Po,   canon:k._0, block:b[166]},
			'10107':{ u:'10107', i:17039, name:'AEGEAN NUMBER ONE', cat:c.No,   canon:k._0, block:b[166]},
			'10108':{ u:'10108', i:17040, name:'AEGEAN NUMBER TWO', cat:c.No,   canon:k._0, block:b[166]},
			'10109':{ u:'10109', i:17041, name:'AEGEAN NUMBER THREE', cat:c.No,   canon:k._0, block:b[166]},
			'10110':{ u:'10110', i:17048, name:'AEGEAN NUMBER TEN', cat:c.No,   canon:k._0, block:b[166]},
			'10111':{ u:'10111', i:17049, name:'AEGEAN NUMBER TWENTY', cat:c.No,   canon:k._0, block:b[166]},
			'10112':{ u:'10112', i:17050, name:'AEGEAN NUMBER THIRTY', cat:c.No,   canon:k._0, block:b[166]},
			'10113':{ u:'10113', i:17051, name:'AEGEAN NUMBER FORTY', cat:c.No,   canon:k._0, block:b[166]},
			'10114':{ u:'10114', i:17052, name:'AEGEAN NUMBER FIFTY', cat:c.No,   canon:k._0, block:b[166]},
			'10115':{ u:'10115', i:17053, name:'AEGEAN NUMBER SIXTY', cat:c.No,   canon:k._0, block:b[166]},
			'10116':{ u:'10116', i:17054, name:'AEGEAN NUMBER SEVENTY', cat:c.No,   canon:k._0, block:b[166]},
			'10117':{ u:'10117', i:17055, name:'AEGEAN NUMBER EIGHTY', cat:c.No,   canon:k._0, block:b[166]},
			'10118':{ u:'10118', i:17056, name:'AEGEAN NUMBER NINETY', cat:c.No,   canon:k._0, block:b[166]},
			'10119':{ u:'10119', i:17057, name:'AEGEAN NUMBER ONE HUNDRED', cat:c.No,   canon:k._0, block:b[166]},
			'10120':{ u:'10120', i:17064, name:'AEGEAN NUMBER EIGHT HUNDRED', cat:c.No,   canon:k._0, block:b[166]},
			'10121':{ u:'10121', i:17065, name:'AEGEAN NUMBER NINE HUNDRED', cat:c.No,   canon:k._0, block:b[166]},
			'10122':{ u:'10122', i:17066, name:'AEGEAN NUMBER ONE THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10123':{ u:'10123', i:17067, name:'AEGEAN NUMBER TWO THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10124':{ u:'10124', i:17068, name:'AEGEAN NUMBER THREE THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10125':{ u:'10125', i:17069, name:'AEGEAN NUMBER FOUR THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10126':{ u:'10126', i:17070, name:'AEGEAN NUMBER FIVE THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10127':{ u:'10127', i:17071, name:'AEGEAN NUMBER SIX THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10128':{ u:'10128', i:17072, name:'AEGEAN NUMBER SEVEN THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10129':{ u:'10129', i:17073, name:'AEGEAN NUMBER EIGHT THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10130':{ u:'10130', i:17080, name:'AEGEAN NUMBER SIXTY THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10131':{ u:'10131', i:17081, name:'AEGEAN NUMBER SEVENTY THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10132':{ u:'10132', i:17082, name:'AEGEAN NUMBER EIGHTY THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10133':{ u:'10133', i:17083, name:'AEGEAN NUMBER NINETY THOUSAND', cat:c.No,   canon:k._0, block:b[166]},
			'10137':{ u:'10137', i:17084, name:'AEGEAN WEIGHT BASE UNIT', cat:c.So,   canon:k._0, block:b[166]},
			'10138':{ u:'10138', i:17085, name:'AEGEAN WEIGHT FIRST SUBUNIT', cat:c.So,   canon:k._0, block:b[166]},
			'10139':{ u:'10139', i:17086, name:'AEGEAN WEIGHT SECOND SUBUNIT', cat:c.So,   canon:k._0, block:b[166]},
			'10140':{ u:'10140', i:17093, name:'GREEK ACROPHONIC ATTIC ONE QUARTER', cat:c.Nl,   canon:k._0, block:b[167]},
			'10141':{ u:'10141', i:17094, name:'GREEK ACROPHONIC ATTIC ONE HALF', cat:c.Nl,   canon:k._0, block:b[167]},
			'10142':{ u:'10142', i:17095, name:'GREEK ACROPHONIC ATTIC ONE DRACHMA', cat:c.Nl,   canon:k._0, block:b[167]},
			'10143':{ u:'10143', i:17096, name:'GREEK ACROPHONIC ATTIC FIVE', cat:c.Nl,   canon:k._0, block:b[167]},
			'10144':{ u:'10144', i:17097, name:'GREEK ACROPHONIC ATTIC FIFTY', cat:c.Nl,   canon:k._0, block:b[167]},
			'10145':{ u:'10145', i:17098, name:'GREEK ACROPHONIC ATTIC FIVE HUNDRED', cat:c.Nl,   canon:k._0, block:b[167]},
			'10146':{ u:'10146', i:17099, name:'GREEK ACROPHONIC ATTIC FIVE THOUSAND', cat:c.Nl,   canon:k._0, block:b[167]},
			'10147':{ u:'10147', i:17100, name:'GREEK ACROPHONIC ATTIC FIFTY THOUSAND', cat:c.Nl,   canon:k._0, block:b[167]},
			'10148':{ u:'10148', i:17101, name:'GREEK ACROPHONIC ATTIC FIVE TALENTS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10149':{ u:'10149', i:17102, name:'GREEK ACROPHONIC ATTIC TEN TALENTS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10150':{ u:'10150', i:17109, name:'GREEK ACROPHONIC ATTIC TEN STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10151':{ u:'10151', i:17110, name:'GREEK ACROPHONIC ATTIC FIFTY STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10152':{ u:'10152', i:17111, name:'GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10153':{ u:'10153', i:17112, name:'GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10154':{ u:'10154', i:17113, name:'GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10155':{ u:'10155', i:17114, name:'GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10156':{ u:'10156', i:17115, name:'GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10157':{ u:'10157', i:17116, name:'GREEK ACROPHONIC ATTIC TEN MNAS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10158':{ u:'10158', i:17117, name:'GREEK ACROPHONIC HERAEUM ONE PLETHRON', cat:c.Nl,   canon:k._0, block:b[167]},
			'10159':{ u:'10159', i:17118, name:'GREEK ACROPHONIC THESPIAN ONE', cat:c.Nl,   canon:k._0, block:b[167]},
			'10160':{ u:'10160', i:17125, name:'GREEK ACROPHONIC TROEZENIAN TEN', cat:c.Nl,   canon:k._0, block:b[167]},
			'10161':{ u:'10161', i:17126, name:'GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM', cat:c.Nl,   canon:k._0, block:b[167]},
			'10162':{ u:'10162', i:17127, name:'GREEK ACROPHONIC HERMIONIAN TEN', cat:c.Nl,   canon:k._0, block:b[167]},
			'10163':{ u:'10163', i:17128, name:'GREEK ACROPHONIC MESSENIAN TEN', cat:c.Nl,   canon:k._0, block:b[167]},
			'10164':{ u:'10164', i:17129, name:'GREEK ACROPHONIC THESPIAN TEN', cat:c.Nl,   canon:k._0, block:b[167]},
			'10165':{ u:'10165', i:17130, name:'GREEK ACROPHONIC THESPIAN THIRTY', cat:c.Nl,   canon:k._0, block:b[167]},
			'10166':{ u:'10166', i:17131, name:'GREEK ACROPHONIC TROEZENIAN FIFTY', cat:c.Nl,   canon:k._0, block:b[167]},
			'10167':{ u:'10167', i:17132, name:'GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM', cat:c.Nl,   canon:k._0, block:b[167]},
			'10168':{ u:'10168', i:17133, name:'GREEK ACROPHONIC HERMIONIAN FIFTY', cat:c.Nl,   canon:k._0, block:b[167]},
			'10169':{ u:'10169', i:17134, name:'GREEK ACROPHONIC THESPIAN FIFTY', cat:c.Nl,   canon:k._0, block:b[167]},
			'10170':{ u:'10170', i:17141, name:'GREEK ACROPHONIC NAXIAN FIVE HUNDRED', cat:c.Nl,   canon:k._0, block:b[167]},
			'10171':{ u:'10171', i:17142, name:'GREEK ACROPHONIC THESPIAN ONE THOUSAND', cat:c.Nl,   canon:k._0, block:b[167]},
			'10172':{ u:'10172', i:17143, name:'GREEK ACROPHONIC THESPIAN FIVE THOUSAND', cat:c.Nl,   canon:k._0, block:b[167]},
			'10173':{ u:'10173', i:17144, name:'GREEK ACROPHONIC DELPHIC FIVE MNAS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10174':{ u:'10174', i:17145, name:'GREEK ACROPHONIC STRATIAN FIFTY MNAS', cat:c.Nl,   canon:k._0, block:b[167]},
			'10175':{ u:'10175', i:17146, name:'GREEK ONE HALF SIGN', cat:c.No,   canon:k._0, block:b[167]},
			'10176':{ u:'10176', i:17147, name:'GREEK ONE HALF SIGN ALTERNATE FORM', cat:c.No,   canon:k._0, block:b[167]},
			'10177':{ u:'10177', i:17148, name:'GREEK TWO THIRDS SIGN', cat:c.No,   canon:k._0, block:b[167]},
			'10178':{ u:'10178', i:17149, name:'GREEK THREE QUARTERS SIGN', cat:c.No,   canon:k._0, block:b[167]},
			'10179':{ u:'10179', i:17150, name:'GREEK YEAR SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10180':{ u:'10180', i:17157, name:'GREEK FIVE OBOLS SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10181':{ u:'10181', i:17158, name:'GREEK METRETES SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10182':{ u:'10182', i:17159, name:'GREEK KYATHOS BASE SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10183':{ u:'10183', i:17160, name:'GREEK LITRA SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10184':{ u:'10184', i:17161, name:'GREEK OUNKIA SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10185':{ u:'10185', i:17162, name:'GREEK XESTES SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10186':{ u:'10186', i:17163, name:'GREEK ARTABE SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10187':{ u:'10187', i:17164, name:'GREEK AROURA SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10188':{ u:'10188', i:17165, name:'GREEK GRAMMA SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10189':{ u:'10189', i:17166, name:'GREEK TRYBLION BASE SIGN', cat:c.So,   canon:k._0, block:b[167]},
			'10190':{ u:'10190', i:17172, name:'ROMAN SEXTANS SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10191':{ u:'10191', i:17173, name:'ROMAN UNCIA SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10192':{ u:'10192', i:17174, name:'ROMAN SEMUNCIA SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10193':{ u:'10193', i:17175, name:'ROMAN SEXTULA SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10194':{ u:'10194', i:17176, name:'ROMAN DIMIDIA SEXTULA SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10195':{ u:'10195', i:17177, name:'ROMAN SILIQUA SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10196':{ u:'10196', i:17178, name:'ROMAN DENARIUS SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10197':{ u:'10197', i:17179, name:'ROMAN QUINARIUS SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10198':{ u:'10198', i:17180, name:'ROMAN SESTERTIUS SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10199':{ u:'10199', i:17181, name:'ROMAN DUPONDIUS SIGN', cat:c.So,   canon:k._0, block:b[168]},
			'10280':{ u:'10280', i:17232, name:'LYCIAN LETTER A', cat:c.Lo,   canon:k._0, block:b[170], indexed:["A"]},
			'10281':{ u:'10281', i:17233, name:'LYCIAN LETTER E', cat:c.Lo,   canon:k._0, block:b[170], indexed:["E"]},
			'10282':{ u:'10282', i:17234, name:'LYCIAN LETTER B', cat:c.Lo,   canon:k._0, block:b[170], indexed:["B"]},
			'10283':{ u:'10283', i:17235, name:'LYCIAN LETTER BH', cat:c.Lo,   canon:k._0, block:b[170]},
			'10284':{ u:'10284', i:17236, name:'LYCIAN LETTER G', cat:c.Lo,   canon:k._0, block:b[170], indexed:["G"]},
			'10285':{ u:'10285', i:17237, name:'LYCIAN LETTER D', cat:c.Lo,   canon:k._0, block:b[170], indexed:["D"]},
			'10286':{ u:'10286', i:17238, name:'LYCIAN LETTER I', cat:c.Lo,   canon:k._0, block:b[170], indexed:["I"]},
			'10287':{ u:'10287', i:17239, name:'LYCIAN LETTER W', cat:c.Lo,   canon:k._0, block:b[170], indexed:["W"]},
			'10288':{ u:'10288', i:17240, name:'LYCIAN LETTER Z', cat:c.Lo,   canon:k._0, block:b[170], indexed:["Z"]},
			'10289':{ u:'10289', i:17241, name:'LYCIAN LETTER TH', cat:c.Lo,   canon:k._0, block:b[170]},
			'10290':{ u:'10290', i:17248, name:'LYCIAN LETTER MM', cat:c.Lo,   canon:k._0, block:b[170]},
			'10291':{ u:'10291', i:17249, name:'LYCIAN LETTER NN', cat:c.Lo,   canon:k._0, block:b[170]},
			'10292':{ u:'10292', i:17250, name:'LYCIAN LETTER U', cat:c.Lo,   canon:k._0, block:b[170], indexed:["U"]},
			'10293':{ u:'10293', i:17251, name:'LYCIAN LETTER P', cat:c.Lo,   canon:k._0, block:b[170], indexed:["P"]},
			'10294':{ u:'10294', i:17252, name:'LYCIAN LETTER KK', cat:c.Lo,   canon:k._0, block:b[170]},
			'10295':{ u:'10295', i:17253, name:'LYCIAN LETTER R', cat:c.Lo,   canon:k._0, block:b[170], indexed:["R"]},
			'10296':{ u:'10296', i:17254, name:'LYCIAN LETTER S', cat:c.Lo,   canon:k._0, block:b[170], indexed:["S"]},
			'10297':{ u:'10297', i:17255, name:'LYCIAN LETTER T', cat:c.Lo,   canon:k._0, block:b[170], indexed:["T"]},
			'10298':{ u:'10298', i:17256, name:'LYCIAN LETTER TT', cat:c.Lo,   canon:k._0, block:b[170]},
			'10299':{ u:'10299', i:17257, name:'LYCIAN LETTER AN', cat:c.Lo,   canon:k._0, block:b[170]},
			'10300':{ u:'10300', i:17338, name:'OLD ITALIC LETTER A', cat:c.Lo,   canon:k._0, block:b[173], indexed:["A"]},
			'10301':{ u:'10301', i:17339, name:'OLD ITALIC LETTER BE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10302':{ u:'10302', i:17340, name:'OLD ITALIC LETTER KE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10303':{ u:'10303', i:17341, name:'OLD ITALIC LETTER DE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10304':{ u:'10304', i:17342, name:'OLD ITALIC LETTER E', cat:c.Lo,   canon:k._0, block:b[173], indexed:["E"]},
			'10305':{ u:'10305', i:17343, name:'OLD ITALIC LETTER VE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10306':{ u:'10306', i:17344, name:'OLD ITALIC LETTER ZE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10307':{ u:'10307', i:17345, name:'OLD ITALIC LETTER HE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10308':{ u:'10308', i:17346, name:'OLD ITALIC LETTER THE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10309':{ u:'10309', i:17347, name:'OLD ITALIC LETTER I', cat:c.Lo,   canon:k._0, block:b[173], indexed:["I"]},
			'10310':{ u:'10310', i:17354, name:'OLD ITALIC LETTER PE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10311':{ u:'10311', i:17355, name:'OLD ITALIC LETTER SHE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10312':{ u:'10312', i:17356, name:'OLD ITALIC LETTER KU', cat:c.Lo,   canon:k._0, block:b[173]},
			'10313':{ u:'10313', i:17357, name:'OLD ITALIC LETTER ER', cat:c.Lo,   canon:k._0, block:b[173]},
			'10314':{ u:'10314', i:17358, name:'OLD ITALIC LETTER ES', cat:c.Lo,   canon:k._0, block:b[173]},
			'10315':{ u:'10315', i:17359, name:'OLD ITALIC LETTER TE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10316':{ u:'10316', i:17360, name:'OLD ITALIC LETTER U', cat:c.Lo,   canon:k._0, block:b[173], indexed:["U"]},
			'10317':{ u:'10317', i:17361, name:'OLD ITALIC LETTER EKS', cat:c.Lo,   canon:k._0, block:b[173]},
			'10318':{ u:'10318', i:17362, name:'OLD ITALIC LETTER PHE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10319':{ u:'10319', i:17363, name:'OLD ITALIC LETTER KHE', cat:c.Lo,   canon:k._0, block:b[173]},
			'10320':{ u:'10320', i:17370, name:'OLD ITALIC NUMERAL ONE', cat:c.No,   canon:k._0, block:b[173]},
			'10321':{ u:'10321', i:17371, name:'OLD ITALIC NUMERAL FIVE', cat:c.No,   canon:k._0, block:b[173]},
			'10322':{ u:'10322', i:17372, name:'OLD ITALIC NUMERAL TEN', cat:c.No,   canon:k._0, block:b[173]},
			'10323':{ u:'10323', i:17373, name:'OLD ITALIC NUMERAL FIFTY', cat:c.No,   canon:k._0, block:b[173]},
			'10330':{ u:'10330', i:17377, name:'GOTHIC LETTER AHSA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10331':{ u:'10331', i:17378, name:'GOTHIC LETTER BAIRKAN', cat:c.Lo,   canon:k._0, block:b[174]},
			'10332':{ u:'10332', i:17379, name:'GOTHIC LETTER GIBA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10333':{ u:'10333', i:17380, name:'GOTHIC LETTER DAGS', cat:c.Lo,   canon:k._0, block:b[174]},
			'10334':{ u:'10334', i:17381, name:'GOTHIC LETTER AIHVUS', cat:c.Lo,   canon:k._0, block:b[174]},
			'10335':{ u:'10335', i:17382, name:'GOTHIC LETTER QAIRTHRA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10336':{ u:'10336', i:17383, name:'GOTHIC LETTER IUJA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10337':{ u:'10337', i:17384, name:'GOTHIC LETTER HAGL', cat:c.Lo,   canon:k._0, block:b[174]},
			'10338':{ u:'10338', i:17385, name:'GOTHIC LETTER THIUTH', cat:c.Lo,   canon:k._0, block:b[174]},
			'10339':{ u:'10339', i:17386, name:'GOTHIC LETTER EIS', cat:c.Lo,   canon:k._0, block:b[174]},
			'10340':{ u:'10340', i:17393, name:'GOTHIC LETTER PAIRTHRA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10341':{ u:'10341', i:17394, name:'GOTHIC LETTER NINETY', cat:c.Nl,   canon:k._0, block:b[174]},
			'10342':{ u:'10342', i:17395, name:'GOTHIC LETTER RAIDA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10343':{ u:'10343', i:17396, name:'GOTHIC LETTER SAUIL', cat:c.Lo,   canon:k._0, block:b[174]},
			'10344':{ u:'10344', i:17397, name:'GOTHIC LETTER TEIWS', cat:c.Lo,   canon:k._0, block:b[174]},
			'10345':{ u:'10345', i:17398, name:'GOTHIC LETTER WINJA', cat:c.Lo,   canon:k._0, block:b[174]},
			'10346':{ u:'10346', i:17399, name:'GOTHIC LETTER FAIHU', cat:c.Lo,   canon:k._0, block:b[174]},
			'10347':{ u:'10347', i:17400, name:'GOTHIC LETTER IGGWS', cat:c.Lo,   canon:k._0, block:b[174]},
			'10348':{ u:'10348', i:17401, name:'GOTHIC LETTER HWAIR', cat:c.Lo,   canon:k._0, block:b[174]},
			'10349':{ u:'10349', i:17402, name:'GOTHIC LETTER OTHAL', cat:c.Lo,   canon:k._0, block:b[174]},
			'10350':{ u:'10350', i:17404, name:'OLD PERMIC LETTER AN', cat:c.Lo,   canon:k._0, block:b[175]},
			'10351':{ u:'10351', i:17405, name:'OLD PERMIC LETTER BUR', cat:c.Lo,   canon:k._0, block:b[175]},
			'10352':{ u:'10352', i:17406, name:'OLD PERMIC LETTER GAI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10353':{ u:'10353', i:17407, name:'OLD PERMIC LETTER DOI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10354':{ u:'10354', i:17408, name:'OLD PERMIC LETTER E', cat:c.Lo,   canon:k._0, block:b[175], indexed:["E"]},
			'10355':{ u:'10355', i:17409, name:'OLD PERMIC LETTER ZHOI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10356':{ u:'10356', i:17410, name:'OLD PERMIC LETTER DZHOI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10357':{ u:'10357', i:17411, name:'OLD PERMIC LETTER ZATA', cat:c.Lo,   canon:k._0, block:b[175]},
			'10358':{ u:'10358', i:17412, name:'OLD PERMIC LETTER DZITA', cat:c.Lo,   canon:k._0, block:b[175]},
			'10359':{ u:'10359', i:17413, name:'OLD PERMIC LETTER I', cat:c.Lo,   canon:k._0, block:b[175], indexed:["I"]},
			'10360':{ u:'10360', i:17420, name:'OLD PERMIC LETTER REI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10361':{ u:'10361', i:17421, name:'OLD PERMIC LETTER SII', cat:c.Lo,   canon:k._0, block:b[175]},
			'10362':{ u:'10362', i:17422, name:'OLD PERMIC LETTER TAI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10363':{ u:'10363', i:17423, name:'OLD PERMIC LETTER U', cat:c.Lo,   canon:k._0, block:b[175], indexed:["U"]},
			'10364':{ u:'10364', i:17424, name:'OLD PERMIC LETTER CHERY', cat:c.Lo,   canon:k._0, block:b[175]},
			'10365':{ u:'10365', i:17425, name:'OLD PERMIC LETTER SHOOI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10366':{ u:'10366', i:17426, name:'OLD PERMIC LETTER SHCHOOI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10367':{ u:'10367', i:17427, name:'OLD PERMIC LETTER YRY', cat:c.Lo,   canon:k._0, block:b[175]},
			'10368':{ u:'10368', i:17428, name:'OLD PERMIC LETTER YERU', cat:c.Lo,   canon:k._0, block:b[175]},
			'10369':{ u:'10369', i:17429, name:'OLD PERMIC LETTER O', cat:c.Lo,   canon:k._0, block:b[175], indexed:["O"]},
			'10370':{ u:'10370', i:17436, name:'OLD PERMIC LETTER YERI', cat:c.Lo,   canon:k._0, block:b[175]},
			'10371':{ u:'10371', i:17437, name:'OLD PERMIC LETTER YAT', cat:c.Lo,   canon:k._0, block:b[175]},
			'10372':{ u:'10372', i:17438, name:'OLD PERMIC LETTER IE', cat:c.Lo,   canon:k._0, block:b[175]},
			'10373':{ u:'10373', i:17439, name:'OLD PERMIC LETTER YU', cat:c.Lo,   canon:k._0, block:b[175]},
			'10374':{ u:'10374', i:17440, name:'OLD PERMIC LETTER YA', cat:c.Lo,   canon:k._0, block:b[175]},
			'10375':{ u:'10375', i:17441, name:'OLD PERMIC LETTER IA', cat:c.Lo,   canon:k._0, block:b[175]},
			'10376':{ u:'10376', i:17442, name:'COMBINING OLD PERMIC LETTER AN', cat:c.Mn,   canon:k._230, block:b[175]},
			'10377':{ u:'10377', i:17443, name:'COMBINING OLD PERMIC LETTER DOI', cat:c.Mn,   canon:k._230, block:b[175]},
			'10378':{ u:'10378', i:17444, name:'COMBINING OLD PERMIC LETTER ZATA', cat:c.Mn,   canon:k._230, block:b[175]},
			'10379':{ u:'10379', i:17445, name:'COMBINING OLD PERMIC LETTER NENOE', cat:c.Mn,   canon:k._230, block:b[175]},
			'10380':{ u:'10380', i:17447, name:'UGARITIC LETTER ALPA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10381':{ u:'10381', i:17448, name:'UGARITIC LETTER BETA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10382':{ u:'10382', i:17449, name:'UGARITIC LETTER GAMLA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10383':{ u:'10383', i:17450, name:'UGARITIC LETTER KHA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10384':{ u:'10384', i:17451, name:'UGARITIC LETTER DELTA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10385':{ u:'10385', i:17452, name:'UGARITIC LETTER HO', cat:c.Lo,   canon:k._0, block:b[176]},
			'10386':{ u:'10386', i:17453, name:'UGARITIC LETTER WO', cat:c.Lo,   canon:k._0, block:b[176]},
			'10387':{ u:'10387', i:17454, name:'UGARITIC LETTER ZETA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10388':{ u:'10388', i:17455, name:'UGARITIC LETTER HOTA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10389':{ u:'10389', i:17456, name:'UGARITIC LETTER TET', cat:c.Lo,   canon:k._0, block:b[176]},
			'10390':{ u:'10390', i:17463, name:'UGARITIC LETTER NUN', cat:c.Lo,   canon:k._0, block:b[176]},
			'10391':{ u:'10391', i:17464, name:'UGARITIC LETTER ZU', cat:c.Lo,   canon:k._0, block:b[176]},
			'10392':{ u:'10392', i:17465, name:'UGARITIC LETTER SAMKA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10393':{ u:'10393', i:17466, name:'UGARITIC LETTER AIN', cat:c.Lo,   canon:k._0, block:b[176]},
			'10394':{ u:'10394', i:17467, name:'UGARITIC LETTER PU', cat:c.Lo,   canon:k._0, block:b[176]},
			'10395':{ u:'10395', i:17468, name:'UGARITIC LETTER SADE', cat:c.Lo,   canon:k._0, block:b[176]},
			'10396':{ u:'10396', i:17469, name:'UGARITIC LETTER QOPA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10397':{ u:'10397', i:17470, name:'UGARITIC LETTER RASHA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10398':{ u:'10398', i:17471, name:'UGARITIC LETTER THANNA', cat:c.Lo,   canon:k._0, block:b[176]},
			'10399':{ u:'10399', i:17472, name:'UGARITIC LETTER GHAIN', cat:c.Lo,   canon:k._0, block:b[176]},
			'10400':{ u:'10400', i:17528, name:'DESERET CAPITAL LETTER LONG I', cat:c.Lu,   canon:k._0, block:b[178], indexed:["I"]},
			'10401':{ u:'10401', i:17529, name:'DESERET CAPITAL LETTER LONG E', cat:c.Lu,   canon:k._0, block:b[178], indexed:["E"]},
			'10402':{ u:'10402', i:17530, name:'DESERET CAPITAL LETTER LONG A', cat:c.Lu,   canon:k._0, block:b[178], indexed:["A"]},
			'10403':{ u:'10403', i:17531, name:'DESERET CAPITAL LETTER LONG AH', cat:c.Lu,   canon:k._0, block:b[178]},
			'10404':{ u:'10404', i:17532, name:'DESERET CAPITAL LETTER LONG O', cat:c.Lu,   canon:k._0, block:b[178], indexed:["O"]},
			'10405':{ u:'10405', i:17533, name:'DESERET CAPITAL LETTER LONG OO', cat:c.Lu,   canon:k._0, block:b[178]},
			'10406':{ u:'10406', i:17534, name:'DESERET CAPITAL LETTER SHORT I', cat:c.Lu,   canon:k._0, block:b[178], indexed:["I"]},
			'10407':{ u:'10407', i:17535, name:'DESERET CAPITAL LETTER SHORT E', cat:c.Lu,   canon:k._0, block:b[178], indexed:["E"]},
			'10408':{ u:'10408', i:17536, name:'DESERET CAPITAL LETTER SHORT A', cat:c.Lu,   canon:k._0, block:b[178], indexed:["A"]},
			'10409':{ u:'10409', i:17537, name:'DESERET CAPITAL LETTER SHORT AH', cat:c.Lu,   canon:k._0, block:b[178]},
			'10410':{ u:'10410', i:17544, name:'DESERET CAPITAL LETTER H', cat:c.Lu,   canon:k._0, block:b[178], indexed:["H"]},
			'10411':{ u:'10411', i:17545, name:'DESERET CAPITAL LETTER PEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10412':{ u:'10412', i:17546, name:'DESERET CAPITAL LETTER BEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10413':{ u:'10413', i:17547, name:'DESERET CAPITAL LETTER TEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10414':{ u:'10414', i:17548, name:'DESERET CAPITAL LETTER DEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10415':{ u:'10415', i:17549, name:'DESERET CAPITAL LETTER CHEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10416':{ u:'10416', i:17550, name:'DESERET CAPITAL LETTER JEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10417':{ u:'10417', i:17551, name:'DESERET CAPITAL LETTER KAY', cat:c.Lu,   canon:k._0, block:b[178]},
			'10418':{ u:'10418', i:17552, name:'DESERET CAPITAL LETTER GAY', cat:c.Lu,   canon:k._0, block:b[178]},
			'10419':{ u:'10419', i:17553, name:'DESERET CAPITAL LETTER EF', cat:c.Lu,   canon:k._0, block:b[178]},
			'10420':{ u:'10420', i:17560, name:'DESERET CAPITAL LETTER ZHEE', cat:c.Lu,   canon:k._0, block:b[178]},
			'10421':{ u:'10421', i:17561, name:'DESERET CAPITAL LETTER ER', cat:c.Lu,   canon:k._0, block:b[178]},
			'10422':{ u:'10422', i:17562, name:'DESERET CAPITAL LETTER EL', cat:c.Lu,   canon:k._0, block:b[178]},
			'10423':{ u:'10423', i:17563, name:'DESERET CAPITAL LETTER EM', cat:c.Lu,   canon:k._0, block:b[178]},
			'10424':{ u:'10424', i:17564, name:'DESERET CAPITAL LETTER EN', cat:c.Lu,   canon:k._0, block:b[178]},
			'10425':{ u:'10425', i:17565, name:'DESERET CAPITAL LETTER ENG', cat:c.Lu,   canon:k._0, block:b[178]},
			'10426':{ u:'10426', i:17566, name:'DESERET CAPITAL LETTER OI', cat:c.Lu,   canon:k._0, block:b[178]},
			'10427':{ u:'10427', i:17567, name:'DESERET CAPITAL LETTER EW', cat:c.Lu,   canon:k._0, block:b[178]},
			'10428':{ u:'10428', i:17568, name:'DESERET SMALL LETTER LONG I', cat:c.Ll,   canon:k._0, block:b[178], indexed:["I"]},
			'10429':{ u:'10429', i:17569, name:'DESERET SMALL LETTER LONG E', cat:c.Ll,   canon:k._0, block:b[178], indexed:["E"]},
			'10430':{ u:'10430', i:17576, name:'DESERET SMALL LETTER SHORT A', cat:c.Ll,   canon:k._0, block:b[178], indexed:["A"]},
			'10431':{ u:'10431', i:17577, name:'DESERET SMALL LETTER SHORT AH', cat:c.Ll,   canon:k._0, block:b[178]},
			'10432':{ u:'10432', i:17578, name:'DESERET SMALL LETTER SHORT O', cat:c.Ll,   canon:k._0, block:b[178], indexed:["O"]},
			'10433':{ u:'10433', i:17579, name:'DESERET SMALL LETTER SHORT OO', cat:c.Ll,   canon:k._0, block:b[178]},
			'10434':{ u:'10434', i:17580, name:'DESERET SMALL LETTER AY', cat:c.Ll,   canon:k._0, block:b[178]},
			'10435':{ u:'10435', i:17581, name:'DESERET SMALL LETTER OW', cat:c.Ll,   canon:k._0, block:b[178]},
			'10436':{ u:'10436', i:17582, name:'DESERET SMALL LETTER WU', cat:c.Ll,   canon:k._0, block:b[178]},
			'10437':{ u:'10437', i:17583, name:'DESERET SMALL LETTER YEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10438':{ u:'10438', i:17584, name:'DESERET SMALL LETTER H', cat:c.Ll,   canon:k._0, block:b[178], indexed:["H"]},
			'10439':{ u:'10439', i:17585, name:'DESERET SMALL LETTER PEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10440':{ u:'10440', i:17592, name:'DESERET SMALL LETTER GAY', cat:c.Ll,   canon:k._0, block:b[178]},
			'10441':{ u:'10441', i:17593, name:'DESERET SMALL LETTER EF', cat:c.Ll,   canon:k._0, block:b[178]},
			'10442':{ u:'10442', i:17594, name:'DESERET SMALL LETTER VEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10443':{ u:'10443', i:17595, name:'DESERET SMALL LETTER ETH', cat:c.Ll,   canon:k._0, block:b[178]},
			'10444':{ u:'10444', i:17596, name:'DESERET SMALL LETTER THEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10445':{ u:'10445', i:17597, name:'DESERET SMALL LETTER ES', cat:c.Ll,   canon:k._0, block:b[178]},
			'10446':{ u:'10446', i:17598, name:'DESERET SMALL LETTER ZEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10447':{ u:'10447', i:17599, name:'DESERET SMALL LETTER ESH', cat:c.Ll,   canon:k._0, block:b[178]},
			'10448':{ u:'10448', i:17600, name:'DESERET SMALL LETTER ZHEE', cat:c.Ll,   canon:k._0, block:b[178]},
			'10449':{ u:'10449', i:17601, name:'DESERET SMALL LETTER ER', cat:c.Ll,   canon:k._0, block:b[178]},
			'10450':{ u:'10450', i:17608, name:'SHAVIAN LETTER PEEP', cat:c.Lo,   canon:k._0, block:b[179]},
			'10451':{ u:'10451', i:17609, name:'SHAVIAN LETTER TOT', cat:c.Lo,   canon:k._0, block:b[179]},
			'10452':{ u:'10452', i:17610, name:'SHAVIAN LETTER KICK', cat:c.Lo,   canon:k._0, block:b[179]},
			'10453':{ u:'10453', i:17611, name:'SHAVIAN LETTER FEE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10454':{ u:'10454', i:17612, name:'SHAVIAN LETTER THIGH', cat:c.Lo,   canon:k._0, block:b[179]},
			'10455':{ u:'10455', i:17613, name:'SHAVIAN LETTER SO', cat:c.Lo,   canon:k._0, block:b[179]},
			'10456':{ u:'10456', i:17614, name:'SHAVIAN LETTER SURE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10457':{ u:'10457', i:17615, name:'SHAVIAN LETTER CHURCH', cat:c.Lo,   canon:k._0, block:b[179]},
			'10458':{ u:'10458', i:17616, name:'SHAVIAN LETTER YEA', cat:c.Lo,   canon:k._0, block:b[179]},
			'10459':{ u:'10459', i:17617, name:'SHAVIAN LETTER HUNG', cat:c.Lo,   canon:k._0, block:b[179]},
			'10460':{ u:'10460', i:17624, name:'SHAVIAN LETTER MEASURE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10461':{ u:'10461', i:17625, name:'SHAVIAN LETTER JUDGE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10462':{ u:'10462', i:17626, name:'SHAVIAN LETTER WOE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10463':{ u:'10463', i:17627, name:'SHAVIAN LETTER HA-HA', cat:c.Lo,   canon:k._0, block:b[179]},
			'10464':{ u:'10464', i:17628, name:'SHAVIAN LETTER LOLL', cat:c.Lo,   canon:k._0, block:b[179]},
			'10465':{ u:'10465', i:17629, name:'SHAVIAN LETTER MIME', cat:c.Lo,   canon:k._0, block:b[179]},
			'10466':{ u:'10466', i:17630, name:'SHAVIAN LETTER IF', cat:c.Lo,   canon:k._0, block:b[179]},
			'10467':{ u:'10467', i:17631, name:'SHAVIAN LETTER EGG', cat:c.Lo,   canon:k._0, block:b[179]},
			'10468':{ u:'10468', i:17632, name:'SHAVIAN LETTER ASH', cat:c.Lo,   canon:k._0, block:b[179]},
			'10469':{ u:'10469', i:17633, name:'SHAVIAN LETTER ADO', cat:c.Lo,   canon:k._0, block:b[179]},
			'10470':{ u:'10470', i:17640, name:'SHAVIAN LETTER EAT', cat:c.Lo,   canon:k._0, block:b[179]},
			'10471':{ u:'10471', i:17641, name:'SHAVIAN LETTER AGE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10472':{ u:'10472', i:17642, name:'SHAVIAN LETTER ICE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10473':{ u:'10473', i:17643, name:'SHAVIAN LETTER UP', cat:c.Lo,   canon:k._0, block:b[179]},
			'10474':{ u:'10474', i:17644, name:'SHAVIAN LETTER OAK', cat:c.Lo,   canon:k._0, block:b[179]},
			'10475':{ u:'10475', i:17645, name:'SHAVIAN LETTER OOZE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10476':{ u:'10476', i:17646, name:'SHAVIAN LETTER OIL', cat:c.Lo,   canon:k._0, block:b[179]},
			'10477':{ u:'10477', i:17647, name:'SHAVIAN LETTER AWE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10478':{ u:'10478', i:17648, name:'SHAVIAN LETTER ARE', cat:c.Lo,   canon:k._0, block:b[179]},
			'10479':{ u:'10479', i:17649, name:'SHAVIAN LETTER OR', cat:c.Lo,   canon:k._0, block:b[179]},
			'10480':{ u:'10480', i:17656, name:'OSMANYA LETTER ALEF', cat:c.Lo,   canon:k._0, block:b[180]},
			'10481':{ u:'10481', i:17657, name:'OSMANYA LETTER BA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10482':{ u:'10482', i:17658, name:'OSMANYA LETTER TA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10483':{ u:'10483', i:17659, name:'OSMANYA LETTER JA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10484':{ u:'10484', i:17660, name:'OSMANYA LETTER XA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10485':{ u:'10485', i:17661, name:'OSMANYA LETTER KHA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10486':{ u:'10486', i:17662, name:'OSMANYA LETTER DEEL', cat:c.Lo,   canon:k._0, block:b[180]},
			'10487':{ u:'10487', i:17663, name:'OSMANYA LETTER RA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10488':{ u:'10488', i:17664, name:'OSMANYA LETTER SA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10489':{ u:'10489', i:17665, name:'OSMANYA LETTER SHIIN', cat:c.Lo,   canon:k._0, block:b[180]},
			'10490':{ u:'10490', i:17672, name:'OSMANYA LETTER LAAN', cat:c.Lo,   canon:k._0, block:b[180]},
			'10491':{ u:'10491', i:17673, name:'OSMANYA LETTER MIIN', cat:c.Lo,   canon:k._0, block:b[180]},
			'10492':{ u:'10492', i:17674, name:'OSMANYA LETTER NUUN', cat:c.Lo,   canon:k._0, block:b[180]},
			'10493':{ u:'10493', i:17675, name:'OSMANYA LETTER WAW', cat:c.Lo,   canon:k._0, block:b[180]},
			'10494':{ u:'10494', i:17676, name:'OSMANYA LETTER HA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10495':{ u:'10495', i:17677, name:'OSMANYA LETTER YA', cat:c.Lo,   canon:k._0, block:b[180]},
			'10496':{ u:'10496', i:17678, name:'OSMANYA LETTER A', cat:c.Lo,   canon:k._0, block:b[180], indexed:["A"]},
			'10497':{ u:'10497', i:17679, name:'OSMANYA LETTER E', cat:c.Lo,   canon:k._0, block:b[180], indexed:["E"]},
			'10498':{ u:'10498', i:17680, name:'OSMANYA LETTER I', cat:c.Lo,   canon:k._0, block:b[180], indexed:["I"]},
			'10499':{ u:'10499', i:17681, name:'OSMANYA LETTER O', cat:c.Lo,   canon:k._0, block:b[180], indexed:["O"]},
			'10500':{ u:'10500', i:17768, name:'ELBASAN LETTER A', cat:c.Lo,   canon:k._0, block:b[182], indexed:["A"]},
			'10501':{ u:'10501', i:17769, name:'ELBASAN LETTER BE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10502':{ u:'10502', i:17770, name:'ELBASAN LETTER CE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10503':{ u:'10503', i:17771, name:'ELBASAN LETTER CHE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10504':{ u:'10504', i:17772, name:'ELBASAN LETTER DE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10505':{ u:'10505', i:17773, name:'ELBASAN LETTER NDE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10506':{ u:'10506', i:17774, name:'ELBASAN LETTER DHE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10507':{ u:'10507', i:17775, name:'ELBASAN LETTER EI', cat:c.Lo,   canon:k._0, block:b[182]},
			'10508':{ u:'10508', i:17776, name:'ELBASAN LETTER E', cat:c.Lo,   canon:k._0, block:b[182], indexed:["E"]},
			'10509':{ u:'10509', i:17777, name:'ELBASAN LETTER FE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10510':{ u:'10510', i:17784, name:'ELBASAN LETTER LE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10511':{ u:'10511', i:17785, name:'ELBASAN LETTER LLE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10512':{ u:'10512', i:17786, name:'ELBASAN LETTER ME', cat:c.Lo,   canon:k._0, block:b[182]},
			'10513':{ u:'10513', i:17787, name:'ELBASAN LETTER NE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10514':{ u:'10514', i:17788, name:'ELBASAN LETTER NA', cat:c.Lo,   canon:k._0, block:b[182]},
			'10515':{ u:'10515', i:17789, name:'ELBASAN LETTER NJE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10516':{ u:'10516', i:17790, name:'ELBASAN LETTER O', cat:c.Lo,   canon:k._0, block:b[182], indexed:["O"]},
			'10517':{ u:'10517', i:17791, name:'ELBASAN LETTER PE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10518':{ u:'10518', i:17792, name:'ELBASAN LETTER QE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10519':{ u:'10519', i:17793, name:'ELBASAN LETTER RE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10520':{ u:'10520', i:17800, name:'ELBASAN LETTER VE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10521':{ u:'10521', i:17801, name:'ELBASAN LETTER XE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10522':{ u:'10522', i:17802, name:'ELBASAN LETTER Y', cat:c.Lo,   canon:k._0, block:b[182], indexed:["Y"]},
			'10523':{ u:'10523', i:17803, name:'ELBASAN LETTER ZE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10524':{ u:'10524', i:17804, name:'ELBASAN LETTER ZHE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10525':{ u:'10525', i:17805, name:'ELBASAN LETTER GHE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10526':{ u:'10526', i:17806, name:'ELBASAN LETTER GHAMMA', cat:c.Lo,   canon:k._0, block:b[182]},
			'10527':{ u:'10527', i:17807, name:'ELBASAN LETTER KHE', cat:c.Lo,   canon:k._0, block:b[182]},
			'10530':{ u:'10530', i:17808, name:'CAUCASIAN ALBANIAN LETTER ALT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10531':{ u:'10531', i:17809, name:'CAUCASIAN ALBANIAN LETTER BET', cat:c.Lo,   canon:k._0, block:b[183]},
			'10532':{ u:'10532', i:17810, name:'CAUCASIAN ALBANIAN LETTER GIM', cat:c.Lo,   canon:k._0, block:b[183]},
			'10533':{ u:'10533', i:17811, name:'CAUCASIAN ALBANIAN LETTER DAT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10534':{ u:'10534', i:17812, name:'CAUCASIAN ALBANIAN LETTER EB', cat:c.Lo,   canon:k._0, block:b[183]},
			'10535':{ u:'10535', i:17813, name:'CAUCASIAN ALBANIAN LETTER ZARL', cat:c.Lo,   canon:k._0, block:b[183]},
			'10536':{ u:'10536', i:17814, name:'CAUCASIAN ALBANIAN LETTER EYN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10537':{ u:'10537', i:17815, name:'CAUCASIAN ALBANIAN LETTER ZHIL', cat:c.Lo,   canon:k._0, block:b[183]},
			'10538':{ u:'10538', i:17816, name:'CAUCASIAN ALBANIAN LETTER TAS', cat:c.Lo,   canon:k._0, block:b[183]},
			'10539':{ u:'10539', i:17817, name:'CAUCASIAN ALBANIAN LETTER CHA', cat:c.Lo,   canon:k._0, block:b[183]},
			'10540':{ u:'10540', i:17824, name:'CAUCASIAN ALBANIAN LETTER XEYN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10541':{ u:'10541', i:17825, name:'CAUCASIAN ALBANIAN LETTER DYAN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10542':{ u:'10542', i:17826, name:'CAUCASIAN ALBANIAN LETTER CAR', cat:c.Lo,   canon:k._0, block:b[183]},
			'10543':{ u:'10543', i:17827, name:'CAUCASIAN ALBANIAN LETTER JHOX', cat:c.Lo,   canon:k._0, block:b[183]},
			'10544':{ u:'10544', i:17828, name:'CAUCASIAN ALBANIAN LETTER KAR', cat:c.Lo,   canon:k._0, block:b[183]},
			'10545':{ u:'10545', i:17829, name:'CAUCASIAN ALBANIAN LETTER LYIT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10546':{ u:'10546', i:17830, name:'CAUCASIAN ALBANIAN LETTER HEYT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10547':{ u:'10547', i:17831, name:'CAUCASIAN ALBANIAN LETTER QAY', cat:c.Lo,   canon:k._0, block:b[183]},
			'10548':{ u:'10548', i:17832, name:'CAUCASIAN ALBANIAN LETTER AOR', cat:c.Lo,   canon:k._0, block:b[183]},
			'10549':{ u:'10549', i:17833, name:'CAUCASIAN ALBANIAN LETTER CHOY', cat:c.Lo,   canon:k._0, block:b[183]},
			'10550':{ u:'10550', i:17840, name:'CAUCASIAN ALBANIAN LETTER SHAK', cat:c.Lo,   canon:k._0, block:b[183]},
			'10551':{ u:'10551', i:17841, name:'CAUCASIAN ALBANIAN LETTER JAYN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10552':{ u:'10552', i:17842, name:'CAUCASIAN ALBANIAN LETTER ON', cat:c.Lo,   canon:k._0, block:b[183]},
			'10553':{ u:'10553', i:17843, name:'CAUCASIAN ALBANIAN LETTER TYAY', cat:c.Lo,   canon:k._0, block:b[183]},
			'10554':{ u:'10554', i:17844, name:'CAUCASIAN ALBANIAN LETTER FAM', cat:c.Lo,   canon:k._0, block:b[183]},
			'10555':{ u:'10555', i:17845, name:'CAUCASIAN ALBANIAN LETTER DZAY', cat:c.Lo,   canon:k._0, block:b[183]},
			'10556':{ u:'10556', i:17846, name:'CAUCASIAN ALBANIAN LETTER CHAT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10557':{ u:'10557', i:17847, name:'CAUCASIAN ALBANIAN LETTER PEN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10558':{ u:'10558', i:17848, name:'CAUCASIAN ALBANIAN LETTER GHEYS', cat:c.Lo,   canon:k._0, block:b[183]},
			'10559':{ u:'10559', i:17849, name:'CAUCASIAN ALBANIAN LETTER RAT', cat:c.Lo,   canon:k._0, block:b[183]},
			'10560':{ u:'10560', i:17856, name:'CAUCASIAN ALBANIAN LETTER CAYN', cat:c.Lo,   canon:k._0, block:b[183]},
			'10561':{ u:'10561', i:17857, name:'CAUCASIAN ALBANIAN LETTER YAYD', cat:c.Lo,   canon:k._0, block:b[183]},
			'10562':{ u:'10562', i:17858, name:'CAUCASIAN ALBANIAN LETTER PIWR', cat:c.Lo,   canon:k._0, block:b[183]},
			'10563':{ u:'10563', i:17859, name:'CAUCASIAN ALBANIAN LETTER KIW', cat:c.Lo,   canon:k._0, block:b[183]},
			'10570':{ u:'10570', i:17861, name:'VITHKUQI CAPITAL LETTER A', cat:c.Lu,   canon:k._0, block:b[184], indexed:["A"]},
			'10571':{ u:'10571', i:17862, name:'VITHKUQI CAPITAL LETTER BBE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10572':{ u:'10572', i:17863, name:'VITHKUQI CAPITAL LETTER BE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10573':{ u:'10573', i:17864, name:'VITHKUQI CAPITAL LETTER CE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10574':{ u:'10574', i:17865, name:'VITHKUQI CAPITAL LETTER CHE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10575':{ u:'10575', i:17866, name:'VITHKUQI CAPITAL LETTER DE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10576':{ u:'10576', i:17867, name:'VITHKUQI CAPITAL LETTER DHE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10577':{ u:'10577', i:17868, name:'VITHKUQI CAPITAL LETTER EI', cat:c.Lu,   canon:k._0, block:b[184]},
			'10578':{ u:'10578', i:17869, name:'VITHKUQI CAPITAL LETTER E', cat:c.Lu,   canon:k._0, block:b[184], indexed:["E"]},
			'10579':{ u:'10579', i:17870, name:'VITHKUQI CAPITAL LETTER FE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10580':{ u:'10580', i:17876, name:'VITHKUQI CAPITAL LETTER JE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10581':{ u:'10581', i:17877, name:'VITHKUQI CAPITAL LETTER KA', cat:c.Lu,   canon:k._0, block:b[184]},
			'10582':{ u:'10582', i:17878, name:'VITHKUQI CAPITAL LETTER LA', cat:c.Lu,   canon:k._0, block:b[184]},
			'10583':{ u:'10583', i:17879, name:'VITHKUQI CAPITAL LETTER LLA', cat:c.Lu,   canon:k._0, block:b[184]},
			'10584':{ u:'10584', i:17880, name:'VITHKUQI CAPITAL LETTER ME', cat:c.Lu,   canon:k._0, block:b[184]},
			'10585':{ u:'10585', i:17881, name:'VITHKUQI CAPITAL LETTER NE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10586':{ u:'10586', i:17882, name:'VITHKUQI CAPITAL LETTER NJE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10587':{ u:'10587', i:17883, name:'VITHKUQI CAPITAL LETTER O', cat:c.Lu,   canon:k._0, block:b[184], indexed:["O"]},
			'10588':{ u:'10588', i:17884, name:'VITHKUQI CAPITAL LETTER PE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10589':{ u:'10589', i:17885, name:'VITHKUQI CAPITAL LETTER QA', cat:c.Lu,   canon:k._0, block:b[184]},
			'10590':{ u:'10590', i:17891, name:'VITHKUQI CAPITAL LETTER U', cat:c.Lu,   canon:k._0, block:b[184], indexed:["U"]},
			'10591':{ u:'10591', i:17892, name:'VITHKUQI CAPITAL LETTER VE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10592':{ u:'10592', i:17893, name:'VITHKUQI CAPITAL LETTER XE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10594':{ u:'10594', i:17894, name:'VITHKUQI CAPITAL LETTER Y', cat:c.Lu,   canon:k._0, block:b[184], indexed:["Y"]},
			'10595':{ u:'10595', i:17895, name:'VITHKUQI CAPITAL LETTER ZE', cat:c.Lu,   canon:k._0, block:b[184]},
			'10597':{ u:'10597', i:17896, name:'VITHKUQI SMALL LETTER A', cat:c.Ll,   canon:k._0, block:b[184], indexed:["A"]},
			'10598':{ u:'10598', i:17897, name:'VITHKUQI SMALL LETTER BBE', cat:c.Ll,   canon:k._0, block:b[184]},
			'10599':{ u:'10599', i:17898, name:'VITHKUQI SMALL LETTER BE', cat:c.Ll,   canon:k._0, block:b[184]},
			'10600':{ u:'10600', i:17931, name:'LINEAR A SIGN AB001', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10601':{ u:'10601', i:17932, name:'LINEAR A SIGN AB002', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10602':{ u:'10602', i:17933, name:'LINEAR A SIGN AB003', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10603':{ u:'10603', i:17934, name:'LINEAR A SIGN AB004', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10604':{ u:'10604', i:17935, name:'LINEAR A SIGN AB005', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10605':{ u:'10605', i:17936, name:'LINEAR A SIGN AB006', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10606':{ u:'10606', i:17937, name:'LINEAR A SIGN AB007', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10607':{ u:'10607', i:17938, name:'LINEAR A SIGN AB008', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10608':{ u:'10608', i:17939, name:'LINEAR A SIGN AB009', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10609':{ u:'10609', i:17940, name:'LINEAR A SIGN AB010', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10610':{ u:'10610', i:17947, name:'LINEAR A SIGN AB021F', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10611':{ u:'10611', i:17948, name:'LINEAR A SIGN AB021M', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10612':{ u:'10612', i:17949, name:'LINEAR A SIGN AB022', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10613':{ u:'10613', i:17950, name:'LINEAR A SIGN AB022F', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10614':{ u:'10614', i:17951, name:'LINEAR A SIGN AB022M', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10615':{ u:'10615', i:17952, name:'LINEAR A SIGN AB023', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10616':{ u:'10616', i:17953, name:'LINEAR A SIGN AB023M', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10617':{ u:'10617', i:17954, name:'LINEAR A SIGN AB024', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10618':{ u:'10618', i:17955, name:'LINEAR A SIGN AB026', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10619':{ u:'10619', i:17956, name:'LINEAR A SIGN AB027', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10620':{ u:'10620', i:17963, name:'LINEAR A SIGN AB037', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10621':{ u:'10621', i:17964, name:'LINEAR A SIGN AB038', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10622':{ u:'10622', i:17965, name:'LINEAR A SIGN AB039', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10623':{ u:'10623', i:17966, name:'LINEAR A SIGN AB040', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10624':{ u:'10624', i:17967, name:'LINEAR A SIGN AB041', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10625':{ u:'10625', i:17968, name:'LINEAR A SIGN AB044', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10626':{ u:'10626', i:17969, name:'LINEAR A SIGN AB045', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10627':{ u:'10627', i:17970, name:'LINEAR A SIGN AB046', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10628':{ u:'10628', i:17971, name:'LINEAR A SIGN AB047', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10629':{ u:'10629', i:17972, name:'LINEAR A SIGN AB048', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10630':{ u:'10630', i:17979, name:'LINEAR A SIGN AB056', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10631':{ u:'10631', i:17980, name:'LINEAR A SIGN AB057', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10632':{ u:'10632', i:17981, name:'LINEAR A SIGN AB058', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10633':{ u:'10633', i:17982, name:'LINEAR A SIGN AB059', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10634':{ u:'10634', i:17983, name:'LINEAR A SIGN AB060', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10635':{ u:'10635', i:17984, name:'LINEAR A SIGN AB061', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10636':{ u:'10636', i:17985, name:'LINEAR A SIGN AB065', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10637':{ u:'10637', i:17986, name:'LINEAR A SIGN AB066', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10638':{ u:'10638', i:17987, name:'LINEAR A SIGN AB067', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10639':{ u:'10639', i:17988, name:'LINEAR A SIGN AB069', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10640':{ u:'10640', i:17995, name:'LINEAR A SIGN AB079', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10641':{ u:'10641', i:17996, name:'LINEAR A SIGN AB080', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10642':{ u:'10642', i:17997, name:'LINEAR A SIGN AB081', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10643':{ u:'10643', i:17998, name:'LINEAR A SIGN AB082', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10644':{ u:'10644', i:17999, name:'LINEAR A SIGN AB085', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10645':{ u:'10645', i:18000, name:'LINEAR A SIGN AB086', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10646':{ u:'10646', i:18001, name:'LINEAR A SIGN AB087', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10647':{ u:'10647', i:18002, name:'LINEAR A SIGN A100-102', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10648':{ u:'10648', i:18003, name:'LINEAR A SIGN AB118', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10649':{ u:'10649', i:18004, name:'LINEAR A SIGN AB120', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10650':{ u:'10650', i:18011, name:'LINEAR A SIGN AB164', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10651':{ u:'10651', i:18012, name:'LINEAR A SIGN AB171', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10652':{ u:'10652', i:18013, name:'LINEAR A SIGN AB180', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10653':{ u:'10653', i:18014, name:'LINEAR A SIGN AB188', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10654':{ u:'10654', i:18015, name:'LINEAR A SIGN AB191', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10655':{ u:'10655', i:18016, name:'LINEAR A SIGN A301', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10656':{ u:'10656', i:18017, name:'LINEAR A SIGN A302', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10657':{ u:'10657', i:18018, name:'LINEAR A SIGN A303', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10658':{ u:'10658', i:18019, name:'LINEAR A SIGN A304', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10659':{ u:'10659', i:18020, name:'LINEAR A SIGN A305', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10660':{ u:'10660', i:18027, name:'LINEAR A SIGN A310', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10661':{ u:'10661', i:18028, name:'LINEAR A SIGN A311', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10662':{ u:'10662', i:18029, name:'LINEAR A SIGN A312', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10663':{ u:'10663', i:18030, name:'LINEAR A SIGN A313A', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10664':{ u:'10664', i:18031, name:'LINEAR A SIGN A313B', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10665':{ u:'10665', i:18032, name:'LINEAR A SIGN A313C', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10666':{ u:'10666', i:18033, name:'LINEAR A SIGN A314', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10667':{ u:'10667', i:18034, name:'LINEAR A SIGN A315', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10668':{ u:'10668', i:18035, name:'LINEAR A SIGN A316', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10669':{ u:'10669', i:18036, name:'LINEAR A SIGN A317', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10670':{ u:'10670', i:18043, name:'LINEAR A SIGN A324', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10671':{ u:'10671', i:18044, name:'LINEAR A SIGN A325', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10672':{ u:'10672', i:18045, name:'LINEAR A SIGN A326', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10673':{ u:'10673', i:18046, name:'LINEAR A SIGN A327', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10674':{ u:'10674', i:18047, name:'LINEAR A SIGN A328', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10675':{ u:'10675', i:18048, name:'LINEAR A SIGN A329', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10676':{ u:'10676', i:18049, name:'LINEAR A SIGN A330', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10677':{ u:'10677', i:18050, name:'LINEAR A SIGN A331', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10678':{ u:'10678', i:18051, name:'LINEAR A SIGN A332', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10679':{ u:'10679', i:18052, name:'LINEAR A SIGN A333', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10680':{ u:'10680', i:18059, name:'LINEAR A SIGN A340', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10681':{ u:'10681', i:18060, name:'LINEAR A SIGN A341', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10682':{ u:'10682', i:18061, name:'LINEAR A SIGN A342', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10683':{ u:'10683', i:18062, name:'LINEAR A SIGN A343', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10684':{ u:'10684', i:18063, name:'LINEAR A SIGN A344', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10685':{ u:'10685', i:18064, name:'LINEAR A SIGN A345', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10686':{ u:'10686', i:18065, name:'LINEAR A SIGN A346', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10687':{ u:'10687', i:18066, name:'LINEAR A SIGN A347', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10688':{ u:'10688', i:18067, name:'LINEAR A SIGN A348', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10689':{ u:'10689', i:18068, name:'LINEAR A SIGN A349', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10690':{ u:'10690', i:18075, name:'LINEAR A SIGN A356', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10691':{ u:'10691', i:18076, name:'LINEAR A SIGN A357', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10692':{ u:'10692', i:18077, name:'LINEAR A SIGN A358', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10693':{ u:'10693', i:18078, name:'LINEAR A SIGN A359', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10694':{ u:'10694', i:18079, name:'LINEAR A SIGN A360', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10695':{ u:'10695', i:18080, name:'LINEAR A SIGN A361', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10696':{ u:'10696', i:18081, name:'LINEAR A SIGN A362', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10697':{ u:'10697', i:18082, name:'LINEAR A SIGN A363', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10698':{ u:'10698', i:18083, name:'LINEAR A SIGN A364', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10699':{ u:'10699', i:18084, name:'LINEAR A SIGN A365', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10700':{ u:'10700', i:18187, name:'LINEAR A SIGN A595', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10701':{ u:'10701', i:18188, name:'LINEAR A SIGN A596', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10702':{ u:'10702', i:18189, name:'LINEAR A SIGN A598', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10703':{ u:'10703', i:18190, name:'LINEAR A SIGN A600', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10704':{ u:'10704', i:18191, name:'LINEAR A SIGN A601', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10705':{ u:'10705', i:18192, name:'LINEAR A SIGN A602', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10706':{ u:'10706', i:18193, name:'LINEAR A SIGN A603', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10707':{ u:'10707', i:18194, name:'LINEAR A SIGN A604', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10708':{ u:'10708', i:18195, name:'LINEAR A SIGN A606', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10709':{ u:'10709', i:18196, name:'LINEAR A SIGN A608', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10710':{ u:'10710', i:18203, name:'LINEAR A SIGN A615', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10711':{ u:'10711', i:18204, name:'LINEAR A SIGN A616', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10712':{ u:'10712', i:18205, name:'LINEAR A SIGN A617', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10713':{ u:'10713', i:18206, name:'LINEAR A SIGN A618', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10714':{ u:'10714', i:18207, name:'LINEAR A SIGN A619', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10715':{ u:'10715', i:18208, name:'LINEAR A SIGN A620', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10716':{ u:'10716', i:18209, name:'LINEAR A SIGN A621', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10717':{ u:'10717', i:18210, name:'LINEAR A SIGN A622', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10718':{ u:'10718', i:18211, name:'LINEAR A SIGN A623', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10719':{ u:'10719', i:18212, name:'LINEAR A SIGN A624', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10720':{ u:'10720', i:18219, name:'LINEAR A SIGN A638', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10721':{ u:'10721', i:18220, name:'LINEAR A SIGN A640', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10722':{ u:'10722', i:18221, name:'LINEAR A SIGN A642', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10723':{ u:'10723', i:18222, name:'LINEAR A SIGN A643', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10724':{ u:'10724', i:18223, name:'LINEAR A SIGN A644', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10725':{ u:'10725', i:18224, name:'LINEAR A SIGN A645', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10726':{ u:'10726', i:18225, name:'LINEAR A SIGN A646', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10727':{ u:'10727', i:18226, name:'LINEAR A SIGN A648', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10728':{ u:'10728', i:18227, name:'LINEAR A SIGN A649', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10729':{ u:'10729', i:18228, name:'LINEAR A SIGN A651', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10730':{ u:'10730', i:18235, name:'LINEAR A SIGN A658', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10731':{ u:'10731', i:18236, name:'LINEAR A SIGN A659', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10732':{ u:'10732', i:18237, name:'LINEAR A SIGN A660', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10733':{ u:'10733', i:18238, name:'LINEAR A SIGN A661', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10734':{ u:'10734', i:18239, name:'LINEAR A SIGN A662', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10735':{ u:'10735', i:18240, name:'LINEAR A SIGN A663', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10736':{ u:'10736', i:18241, name:'LINEAR A SIGN A664', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10740':{ u:'10740', i:18242, name:'LINEAR A SIGN A701 A', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","A"]},
			'10741':{ u:'10741', i:18243, name:'LINEAR A SIGN A702 B', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","B"]},
			'10742':{ u:'10742', i:18244, name:'LINEAR A SIGN A703 D', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","D"]},
			'10743':{ u:'10743', i:18245, name:'LINEAR A SIGN A704 E', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","E"]},
			'10744':{ u:'10744', i:18246, name:'LINEAR A SIGN A705 F', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","F"]},
			'10745':{ u:'10745', i:18247, name:'LINEAR A SIGN A706 H', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","H"]},
			'10746':{ u:'10746', i:18248, name:'LINEAR A SIGN A707 J', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","J"]},
			'10747':{ u:'10747', i:18249, name:'LINEAR A SIGN A708 K', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","K"]},
			'10748':{ u:'10748', i:18250, name:'LINEAR A SIGN A709 L', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A","L"]},
			'10749':{ u:'10749', i:18251, name:'LINEAR A SIGN A709-2 L2', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10750':{ u:'10750', i:18258, name:'LINEAR A SIGN A713 OMEGA', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10751':{ u:'10751', i:18259, name:'LINEAR A SIGN A714 ABB', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10752':{ u:'10752', i:18260, name:'LINEAR A SIGN A715 BB', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10753':{ u:'10753', i:18261, name:'LINEAR A SIGN A717 DD', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10754':{ u:'10754', i:18262, name:'LINEAR A SIGN A726 EYYY', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10755':{ u:'10755', i:18263, name:'LINEAR A SIGN A732 JE', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10760':{ u:'10760', i:18264, name:'LINEAR A SIGN A800', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10761':{ u:'10761', i:18265, name:'LINEAR A SIGN A801', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10762':{ u:'10762', i:18266, name:'LINEAR A SIGN A802', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10763':{ u:'10763', i:18267, name:'LINEAR A SIGN A803', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10764':{ u:'10764', i:18268, name:'LINEAR A SIGN A804', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10765':{ u:'10765', i:18269, name:'LINEAR A SIGN A805', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10766':{ u:'10766', i:18270, name:'LINEAR A SIGN A806', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10767':{ u:'10767', i:18271, name:'LINEAR A SIGN A807', cat:c.Lo,   canon:k._0, block:b[185], indexed:["A"]},
			'10780':{ u:'10780', i:18272, name:'MODIFIER LETTER SMALL CAPITAL AA', cat:c.Lm,   canon:k._0, block:b[186]},
			'10781':{ u:'10781', i:18273, name:'MODIFIER LETTER SUPERSCRIPT TRIANGULAR COLON', cat:c.Lm,  relatives:['02d0'],  canon:k._0, block:b[186]},
			'10782':{ u:'10782', i:18274, name:'MODIFIER LETTER SUPERSCRIPT HALF TRIANGULAR COLON', cat:c.Lm,  relatives:['02d1'],  canon:k._0, block:b[186]},
			'10783':{ u:'10783', i:18275, name:'MODIFIER LETTER SMALL AE', cat:c.Lm,  relatives:['00e6'],  canon:k._0, block:b[186]},
			'10784':{ u:'10784', i:18276, name:'MODIFIER LETTER SMALL CAPITAL B', cat:c.Lm,  relatives:['0299'],  canon:k._0, block:b[186], indexed:["B"]},
			'10785':{ u:'10785', i:18277, name:'MODIFIER LETTER SMALL B WITH HOOK', cat:c.Lm,  relatives:['0253'],  canon:k._0, block:b[186], indexed:["B"]},
			'10787':{ u:'10787', i:18278, name:'MODIFIER LETTER SMALL DZ DIGRAPH', cat:c.Lm,  relatives:['02a3'],  canon:k._0, block:b[186]},
			'10788':{ u:'10788', i:18279, name:'MODIFIER LETTER SMALL DZ DIGRAPH WITH RETROFLEX HOOK', cat:c.Lm,  relatives:['ab66'],  canon:k._0, block:b[186]},
			'10789':{ u:'10789', i:18280, name:'MODIFIER LETTER SMALL DZ DIGRAPH WITH CURL', cat:c.Lm,  relatives:['02a5'],  canon:k._0, block:b[186]},
			'10790':{ u:'10790', i:18287, name:'MODIFIER LETTER SMALL FENG DIGRAPH', cat:c.Lm,  relatives:['02a9'],  canon:k._0, block:b[186]},
			'10791':{ u:'10791', i:18288, name:'MODIFIER LETTER SMALL RAMS HORN', cat:c.Lm,  relatives:['0264'],  canon:k._0, block:b[186]},
			'10792':{ u:'10792', i:18289, name:'MODIFIER LETTER SMALL CAPITAL G', cat:c.Lm,  relatives:['0262'],  canon:k._0, block:b[186], indexed:["G"]},
			'10793':{ u:'10793', i:18290, name:'MODIFIER LETTER SMALL G WITH HOOK', cat:c.Lm,  relatives:['0260'],  canon:k._0, block:b[186], indexed:["G"]},
			'10794':{ u:'10794', i:18291, name:'MODIFIER LETTER SMALL CAPITAL G WITH HOOK', cat:c.Lm,  relatives:['029b'],  canon:k._0, block:b[186], indexed:["G"]},
			'10795':{ u:'10795', i:18292, name:'MODIFIER LETTER SMALL H WITH STROKE', cat:c.Lm,  relatives:['0127'],  canon:k._0, block:b[186], indexed:["H"]},
			'10796':{ u:'10796', i:18293, name:'MODIFIER LETTER SMALL CAPITAL H', cat:c.Lm,  relatives:['029c'],  canon:k._0, block:b[186], indexed:["H"]},
			'10797':{ u:'10797', i:18294, name:'MODIFIER LETTER SMALL HENG WITH HOOK', cat:c.Lm,  relatives:['0267'],  canon:k._0, block:b[186]},
			'10798':{ u:'10798', i:18295, name:'MODIFIER LETTER SMALL DOTLESS J WITH STROKE AND HOOK', cat:c.Lm,  relatives:['0284'],  canon:k._0, block:b[186], indexed:["J"]},
			'10799':{ u:'10799', i:18296, name:'MODIFIER LETTER SMALL LS DIGRAPH', cat:c.Lm,  relatives:['02aa'],  canon:k._0, block:b[186]},
			'10800':{ u:'10800', i:18329, name:'CYPRIOT SYLLABLE A', cat:c.Lo,   canon:k._0, block:b[187], indexed:["A"]},
			'10801':{ u:'10801', i:18330, name:'CYPRIOT SYLLABLE E', cat:c.Lo,   canon:k._0, block:b[187], indexed:["E"]},
			'10802':{ u:'10802', i:18331, name:'CYPRIOT SYLLABLE I', cat:c.Lo,   canon:k._0, block:b[187], indexed:["I"]},
			'10803':{ u:'10803', i:18332, name:'CYPRIOT SYLLABLE O', cat:c.Lo,   canon:k._0, block:b[187], indexed:["O"]},
			'10804':{ u:'10804', i:18333, name:'CYPRIOT SYLLABLE U', cat:c.Lo,   canon:k._0, block:b[187], indexed:["U"]},
			'10805':{ u:'10805', i:18334, name:'CYPRIOT SYLLABLE JA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10808':{ u:'10808', i:18335, name:'CYPRIOT SYLLABLE JO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10810':{ u:'10810', i:18342, name:'CYPRIOT SYLLABLE LE', cat:c.Lo,   canon:k._0, block:b[187]},
			'10811':{ u:'10811', i:18343, name:'CYPRIOT SYLLABLE LI', cat:c.Lo,   canon:k._0, block:b[187]},
			'10812':{ u:'10812', i:18344, name:'CYPRIOT SYLLABLE LO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10813':{ u:'10813', i:18345, name:'CYPRIOT SYLLABLE LU', cat:c.Lo,   canon:k._0, block:b[187]},
			'10814':{ u:'10814', i:18346, name:'CYPRIOT SYLLABLE MA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10815':{ u:'10815', i:18347, name:'CYPRIOT SYLLABLE ME', cat:c.Lo,   canon:k._0, block:b[187]},
			'10816':{ u:'10816', i:18348, name:'CYPRIOT SYLLABLE MI', cat:c.Lo,   canon:k._0, block:b[187]},
			'10817':{ u:'10817', i:18349, name:'CYPRIOT SYLLABLE MO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10818':{ u:'10818', i:18350, name:'CYPRIOT SYLLABLE MU', cat:c.Lo,   canon:k._0, block:b[187]},
			'10819':{ u:'10819', i:18351, name:'CYPRIOT SYLLABLE NA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10820':{ u:'10820', i:18358, name:'CYPRIOT SYLLABLE PI', cat:c.Lo,   canon:k._0, block:b[187]},
			'10821':{ u:'10821', i:18359, name:'CYPRIOT SYLLABLE PO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10822':{ u:'10822', i:18360, name:'CYPRIOT SYLLABLE PU', cat:c.Lo,   canon:k._0, block:b[187]},
			'10823':{ u:'10823', i:18361, name:'CYPRIOT SYLLABLE RA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10824':{ u:'10824', i:18362, name:'CYPRIOT SYLLABLE RE', cat:c.Lo,   canon:k._0, block:b[187]},
			'10825':{ u:'10825', i:18363, name:'CYPRIOT SYLLABLE RI', cat:c.Lo,   canon:k._0, block:b[187]},
			'10826':{ u:'10826', i:18364, name:'CYPRIOT SYLLABLE RO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10827':{ u:'10827', i:18365, name:'CYPRIOT SYLLABLE RU', cat:c.Lo,   canon:k._0, block:b[187]},
			'10828':{ u:'10828', i:18366, name:'CYPRIOT SYLLABLE SA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10829':{ u:'10829', i:18367, name:'CYPRIOT SYLLABLE SE', cat:c.Lo,   canon:k._0, block:b[187]},
			'10830':{ u:'10830', i:18374, name:'CYPRIOT SYLLABLE TO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10831':{ u:'10831', i:18375, name:'CYPRIOT SYLLABLE TU', cat:c.Lo,   canon:k._0, block:b[187]},
			'10832':{ u:'10832', i:18376, name:'CYPRIOT SYLLABLE WA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10833':{ u:'10833', i:18377, name:'CYPRIOT SYLLABLE WE', cat:c.Lo,   canon:k._0, block:b[187]},
			'10834':{ u:'10834', i:18378, name:'CYPRIOT SYLLABLE WI', cat:c.Lo,   canon:k._0, block:b[187]},
			'10835':{ u:'10835', i:18379, name:'CYPRIOT SYLLABLE WO', cat:c.Lo,   canon:k._0, block:b[187]},
			'10837':{ u:'10837', i:18380, name:'CYPRIOT SYLLABLE XA', cat:c.Lo,   canon:k._0, block:b[187]},
			'10838':{ u:'10838', i:18381, name:'CYPRIOT SYLLABLE XE', cat:c.Lo,   canon:k._0, block:b[187]},
			'10840':{ u:'10840', i:18384, name:'IMPERIAL ARAMAIC LETTER ALEPH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10841':{ u:'10841', i:18385, name:'IMPERIAL ARAMAIC LETTER BETH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10842':{ u:'10842', i:18386, name:'IMPERIAL ARAMAIC LETTER GIMEL', cat:c.Lo,   canon:k._0, block:b[188]},
			'10843':{ u:'10843', i:18387, name:'IMPERIAL ARAMAIC LETTER DALETH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10844':{ u:'10844', i:18388, name:'IMPERIAL ARAMAIC LETTER HE', cat:c.Lo,   canon:k._0, block:b[188]},
			'10845':{ u:'10845', i:18389, name:'IMPERIAL ARAMAIC LETTER WAW', cat:c.Lo,   canon:k._0, block:b[188]},
			'10846':{ u:'10846', i:18390, name:'IMPERIAL ARAMAIC LETTER ZAYIN', cat:c.Lo,   canon:k._0, block:b[188]},
			'10847':{ u:'10847', i:18391, name:'IMPERIAL ARAMAIC LETTER HETH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10848':{ u:'10848', i:18392, name:'IMPERIAL ARAMAIC LETTER TETH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10849':{ u:'10849', i:18393, name:'IMPERIAL ARAMAIC LETTER YODH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10850':{ u:'10850', i:18400, name:'IMPERIAL ARAMAIC LETTER PE', cat:c.Lo,   canon:k._0, block:b[188]},
			'10851':{ u:'10851', i:18401, name:'IMPERIAL ARAMAIC LETTER SADHE', cat:c.Lo,   canon:k._0, block:b[188]},
			'10852':{ u:'10852', i:18402, name:'IMPERIAL ARAMAIC LETTER QOPH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10853':{ u:'10853', i:18403, name:'IMPERIAL ARAMAIC LETTER RESH', cat:c.Lo,   canon:k._0, block:b[188]},
			'10854':{ u:'10854', i:18404, name:'IMPERIAL ARAMAIC LETTER SHIN', cat:c.Lo,   canon:k._0, block:b[188]},
			'10855':{ u:'10855', i:18405, name:'IMPERIAL ARAMAIC LETTER TAW', cat:c.Lo,   canon:k._0, block:b[188]},
			'10857':{ u:'10857', i:18406, name:'IMPERIAL ARAMAIC SECTION SIGN', cat:c.Po,   canon:k._0, block:b[188]},
			'10858':{ u:'10858', i:18407, name:'IMPERIAL ARAMAIC NUMBER ONE', cat:c.No,   canon:k._0, block:b[188]},
			'10859':{ u:'10859', i:18408, name:'IMPERIAL ARAMAIC NUMBER TWO', cat:c.No,   canon:k._0, block:b[188]},
			'10860':{ u:'10860', i:18415, name:'PALMYRENE LETTER ALEPH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10861':{ u:'10861', i:18416, name:'PALMYRENE LETTER BETH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10862':{ u:'10862', i:18417, name:'PALMYRENE LETTER GIMEL', cat:c.Lo,   canon:k._0, block:b[189]},
			'10863':{ u:'10863', i:18418, name:'PALMYRENE LETTER DALETH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10864':{ u:'10864', i:18419, name:'PALMYRENE LETTER HE', cat:c.Lo,   canon:k._0, block:b[189]},
			'10865':{ u:'10865', i:18420, name:'PALMYRENE LETTER WAW', cat:c.Lo,   canon:k._0, block:b[189]},
			'10866':{ u:'10866', i:18421, name:'PALMYRENE LETTER ZAYIN', cat:c.Lo,   canon:k._0, block:b[189]},
			'10867':{ u:'10867', i:18422, name:'PALMYRENE LETTER HETH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10868':{ u:'10868', i:18423, name:'PALMYRENE LETTER TETH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10869':{ u:'10869', i:18424, name:'PALMYRENE LETTER YODH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10870':{ u:'10870', i:18431, name:'PALMYRENE LETTER AYIN', cat:c.Lo,   canon:k._0, block:b[189]},
			'10871':{ u:'10871', i:18432, name:'PALMYRENE LETTER PE', cat:c.Lo,   canon:k._0, block:b[189]},
			'10872':{ u:'10872', i:18433, name:'PALMYRENE LETTER SADHE', cat:c.Lo,   canon:k._0, block:b[189]},
			'10873':{ u:'10873', i:18434, name:'PALMYRENE LETTER QOPH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10874':{ u:'10874', i:18435, name:'PALMYRENE LETTER RESH', cat:c.Lo,   canon:k._0, block:b[189]},
			'10875':{ u:'10875', i:18436, name:'PALMYRENE LETTER SHIN', cat:c.Lo,   canon:k._0, block:b[189]},
			'10876':{ u:'10876', i:18437, name:'PALMYRENE LETTER TAW', cat:c.Lo,   canon:k._0, block:b[189]},
			'10877':{ u:'10877', i:18438, name:'PALMYRENE LEFT-POINTING FLEURON', cat:c.So,   canon:k._0, block:b[189]},
			'10878':{ u:'10878', i:18439, name:'PALMYRENE RIGHT-POINTING FLEURON', cat:c.So,   canon:k._0, block:b[189]},
			'10879':{ u:'10879', i:18440, name:'PALMYRENE NUMBER ONE', cat:c.No,   canon:k._0, block:b[189]},
			'10880':{ u:'10880', i:18447, name:'NABATAEAN LETTER FINAL ALEPH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10881':{ u:'10881', i:18448, name:'NABATAEAN LETTER ALEPH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10882':{ u:'10882', i:18449, name:'NABATAEAN LETTER FINAL BETH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10883':{ u:'10883', i:18450, name:'NABATAEAN LETTER BETH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10884':{ u:'10884', i:18451, name:'NABATAEAN LETTER GIMEL', cat:c.Lo,   canon:k._0, block:b[190]},
			'10885':{ u:'10885', i:18452, name:'NABATAEAN LETTER DALETH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10886':{ u:'10886', i:18453, name:'NABATAEAN LETTER FINAL HE', cat:c.Lo,   canon:k._0, block:b[190]},
			'10887':{ u:'10887', i:18454, name:'NABATAEAN LETTER HE', cat:c.Lo,   canon:k._0, block:b[190]},
			'10888':{ u:'10888', i:18455, name:'NABATAEAN LETTER WAW', cat:c.Lo,   canon:k._0, block:b[190]},
			'10889':{ u:'10889', i:18456, name:'NABATAEAN LETTER ZAYIN', cat:c.Lo,   canon:k._0, block:b[190]},
			'10890':{ u:'10890', i:18463, name:'NABATAEAN LETTER FINAL LAMEDH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10891':{ u:'10891', i:18464, name:'NABATAEAN LETTER LAMEDH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10892':{ u:'10892', i:18465, name:'NABATAEAN LETTER FINAL MEM', cat:c.Lo,   canon:k._0, block:b[190]},
			'10893':{ u:'10893', i:18466, name:'NABATAEAN LETTER MEM', cat:c.Lo,   canon:k._0, block:b[190]},
			'10894':{ u:'10894', i:18467, name:'NABATAEAN LETTER FINAL NUN', cat:c.Lo,   canon:k._0, block:b[190]},
			'10895':{ u:'10895', i:18468, name:'NABATAEAN LETTER NUN', cat:c.Lo,   canon:k._0, block:b[190]},
			'10896':{ u:'10896', i:18469, name:'NABATAEAN LETTER SAMEKH', cat:c.Lo,   canon:k._0, block:b[190]},
			'10897':{ u:'10897', i:18470, name:'NABATAEAN LETTER AYIN', cat:c.Lo,   canon:k._0, block:b[190]},
			'10898':{ u:'10898', i:18471, name:'NABATAEAN LETTER PE', cat:c.Lo,   canon:k._0, block:b[190]},
			'10899':{ u:'10899', i:18472, name:'NABATAEAN LETTER SADHE', cat:c.Lo,   canon:k._0, block:b[190]},
			'10900':{ u:'10900', i:18513, name:'PHOENICIAN LETTER ALF', cat:c.Lo,   canon:k._0, block:b[192]},
			'10901':{ u:'10901', i:18514, name:'PHOENICIAN LETTER BET', cat:c.Lo,   canon:k._0, block:b[192]},
			'10902':{ u:'10902', i:18515, name:'PHOENICIAN LETTER GAML', cat:c.Lo,   canon:k._0, block:b[192]},
			'10903':{ u:'10903', i:18516, name:'PHOENICIAN LETTER DELT', cat:c.Lo,   canon:k._0, block:b[192]},
			'10904':{ u:'10904', i:18517, name:'PHOENICIAN LETTER HE', cat:c.Lo,   canon:k._0, block:b[192]},
			'10905':{ u:'10905', i:18518, name:'PHOENICIAN LETTER WAU', cat:c.Lo,   canon:k._0, block:b[192]},
			'10906':{ u:'10906', i:18519, name:'PHOENICIAN LETTER ZAI', cat:c.Lo,   canon:k._0, block:b[192]},
			'10907':{ u:'10907', i:18520, name:'PHOENICIAN LETTER HET', cat:c.Lo,   canon:k._0, block:b[192]},
			'10908':{ u:'10908', i:18521, name:'PHOENICIAN LETTER TET', cat:c.Lo,   canon:k._0, block:b[192]},
			'10909':{ u:'10909', i:18522, name:'PHOENICIAN LETTER YOD', cat:c.Lo,   canon:k._0, block:b[192]},
			'10910':{ u:'10910', i:18529, name:'PHOENICIAN LETTER PE', cat:c.Lo,   canon:k._0, block:b[192]},
			'10911':{ u:'10911', i:18530, name:'PHOENICIAN LETTER SADE', cat:c.Lo,   canon:k._0, block:b[192]},
			'10912':{ u:'10912', i:18531, name:'PHOENICIAN LETTER QOF', cat:c.Lo,   canon:k._0, block:b[192]},
			'10913':{ u:'10913', i:18532, name:'PHOENICIAN LETTER ROSH', cat:c.Lo,   canon:k._0, block:b[192]},
			'10914':{ u:'10914', i:18533, name:'PHOENICIAN LETTER SHIN', cat:c.Lo,   canon:k._0, block:b[192]},
			'10915':{ u:'10915', i:18534, name:'PHOENICIAN LETTER TAU', cat:c.Lo,   canon:k._0, block:b[192]},
			'10916':{ u:'10916', i:18535, name:'PHOENICIAN NUMBER ONE', cat:c.No,   canon:k._0, block:b[192]},
			'10917':{ u:'10917', i:18536, name:'PHOENICIAN NUMBER TEN', cat:c.No,   canon:k._0, block:b[192]},
			'10918':{ u:'10918', i:18537, name:'PHOENICIAN NUMBER TWENTY', cat:c.No,   canon:k._0, block:b[192]},
			'10919':{ u:'10919', i:18538, name:'PHOENICIAN NUMBER ONE HUNDRED', cat:c.No,   canon:k._0, block:b[192]},
			'10920':{ u:'10920', i:18542, name:'LYDIAN LETTER A', cat:c.Lo,   canon:k._0, block:b[193], indexed:["A"]},
			'10921':{ u:'10921', i:18543, name:'LYDIAN LETTER B', cat:c.Lo,   canon:k._0, block:b[193], indexed:["B"]},
			'10922':{ u:'10922', i:18544, name:'LYDIAN LETTER G', cat:c.Lo,   canon:k._0, block:b[193], indexed:["G"]},
			'10923':{ u:'10923', i:18545, name:'LYDIAN LETTER D', cat:c.Lo,   canon:k._0, block:b[193], indexed:["D"]},
			'10924':{ u:'10924', i:18546, name:'LYDIAN LETTER E', cat:c.Lo,   canon:k._0, block:b[193], indexed:["E"]},
			'10925':{ u:'10925', i:18547, name:'LYDIAN LETTER V', cat:c.Lo,   canon:k._0, block:b[193], indexed:["V"]},
			'10926':{ u:'10926', i:18548, name:'LYDIAN LETTER I', cat:c.Lo,   canon:k._0, block:b[193], indexed:["I"]},
			'10927':{ u:'10927', i:18549, name:'LYDIAN LETTER Y', cat:c.Lo,   canon:k._0, block:b[193], indexed:["Y"]},
			'10928':{ u:'10928', i:18550, name:'LYDIAN LETTER K', cat:c.Lo,   canon:k._0, block:b[193], indexed:["K"]},
			'10929':{ u:'10929', i:18551, name:'LYDIAN LETTER L', cat:c.Lo,   canon:k._0, block:b[193], indexed:["L"]},
			'10930':{ u:'10930', i:18558, name:'LYDIAN LETTER U', cat:c.Lo,   canon:k._0, block:b[193], indexed:["U"]},
			'10931':{ u:'10931', i:18559, name:'LYDIAN LETTER F', cat:c.Lo,   canon:k._0, block:b[193], indexed:["F"]},
			'10932':{ u:'10932', i:18560, name:'LYDIAN LETTER Q', cat:c.Lo,   canon:k._0, block:b[193], indexed:["Q"]},
			'10933':{ u:'10933', i:18561, name:'LYDIAN LETTER S', cat:c.Lo,   canon:k._0, block:b[193], indexed:["S"]},
			'10934':{ u:'10934', i:18562, name:'LYDIAN LETTER TT', cat:c.Lo,   canon:k._0, block:b[193]},
			'10935':{ u:'10935', i:18563, name:'LYDIAN LETTER AN', cat:c.Lo,   canon:k._0, block:b[193]},
			'10936':{ u:'10936', i:18564, name:'LYDIAN LETTER EN', cat:c.Lo,   canon:k._0, block:b[193]},
			'10937':{ u:'10937', i:18565, name:'LYDIAN LETTER LY', cat:c.Lo,   canon:k._0, block:b[193]},
			'10938':{ u:'10938', i:18566, name:'LYDIAN LETTER NN', cat:c.Lo,   canon:k._0, block:b[193]},
			'10939':{ u:'10939', i:18567, name:'LYDIAN LETTER C', cat:c.Lo,   canon:k._0, block:b[193], indexed:["C"]},
			'10980':{ u:'10980', i:18569, name:'MEROITIC HIEROGLYPHIC LETTER A', cat:c.Lo,   canon:k._0, block:b[194], indexed:["A"]},
			'10981':{ u:'10981', i:18570, name:'MEROITIC HIEROGLYPHIC LETTER E', cat:c.Lo,   canon:k._0, block:b[194], indexed:["E"]},
			'10982':{ u:'10982', i:18571, name:'MEROITIC HIEROGLYPHIC LETTER I', cat:c.Lo,   canon:k._0, block:b[194], indexed:["I"]},
			'10983':{ u:'10983', i:18572, name:'MEROITIC HIEROGLYPHIC LETTER O', cat:c.Lo,   canon:k._0, block:b[194], indexed:["O"]},
			'10984':{ u:'10984', i:18573, name:'MEROITIC HIEROGLYPHIC LETTER YA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10985':{ u:'10985', i:18574, name:'MEROITIC HIEROGLYPHIC LETTER WA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10986':{ u:'10986', i:18575, name:'MEROITIC HIEROGLYPHIC LETTER BA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10987':{ u:'10987', i:18576, name:'MEROITIC HIEROGLYPHIC LETTER BA-2', cat:c.Lo,   canon:k._0, block:b[194]},
			'10988':{ u:'10988', i:18577, name:'MEROITIC HIEROGLYPHIC LETTER PA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10989':{ u:'10989', i:18578, name:'MEROITIC HIEROGLYPHIC LETTER MA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10990':{ u:'10990', i:18585, name:'MEROITIC HIEROGLYPHIC LETTER LA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10991':{ u:'10991', i:18586, name:'MEROITIC HIEROGLYPHIC LETTER KHA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10992':{ u:'10992', i:18587, name:'MEROITIC HIEROGLYPHIC LETTER HHA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10993':{ u:'10993', i:18588, name:'MEROITIC HIEROGLYPHIC LETTER SA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10994':{ u:'10994', i:18589, name:'MEROITIC HIEROGLYPHIC LETTER SA-2', cat:c.Lo,   canon:k._0, block:b[194]},
			'10995':{ u:'10995', i:18590, name:'MEROITIC HIEROGLYPHIC LETTER SE', cat:c.Lo,   canon:k._0, block:b[194]},
			'10996':{ u:'10996', i:18591, name:'MEROITIC HIEROGLYPHIC LETTER KA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10997':{ u:'10997', i:18592, name:'MEROITIC HIEROGLYPHIC LETTER QA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10998':{ u:'10998', i:18593, name:'MEROITIC HIEROGLYPHIC LETTER TA', cat:c.Lo,   canon:k._0, block:b[194]},
			'10999':{ u:'10999', i:18594, name:'MEROITIC HIEROGLYPHIC LETTER TA-2', cat:c.Lo,   canon:k._0, block:b[194]},
			'11000':{ u:'11000', i:19489, name:'BRAHMI SIGN CANDRABINDU', cat:c.Mc,   canon:k._0, block:b[214]},
			'11001':{ u:'11001', i:19490, name:'BRAHMI SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[214]},
			'11002':{ u:'11002', i:19491, name:'BRAHMI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[214]},
			'11003':{ u:'11003', i:19492, name:'BRAHMI SIGN JIHVAMULIYA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11004':{ u:'11004', i:19493, name:'BRAHMI SIGN UPADHMANIYA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11005':{ u:'11005', i:19494, name:'BRAHMI LETTER A', cat:c.Lo,   canon:k._0, block:b[214], indexed:["A"]},
			'11006':{ u:'11006', i:19495, name:'BRAHMI LETTER AA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11007':{ u:'11007', i:19496, name:'BRAHMI LETTER I', cat:c.Lo,   canon:k._0, block:b[214], indexed:["I"]},
			'11008':{ u:'11008', i:19497, name:'BRAHMI LETTER II', cat:c.Lo,   canon:k._0, block:b[214]},
			'11009':{ u:'11009', i:19498, name:'BRAHMI LETTER U', cat:c.Lo,   canon:k._0, block:b[214], indexed:["U"]},
			'11010':{ u:'11010', i:19505, name:'BRAHMI LETTER AI', cat:c.Lo,   canon:k._0, block:b[214]},
			'11011':{ u:'11011', i:19506, name:'BRAHMI LETTER O', cat:c.Lo,   canon:k._0, block:b[214], indexed:["O"]},
			'11012':{ u:'11012', i:19507, name:'BRAHMI LETTER AU', cat:c.Lo,   canon:k._0, block:b[214]},
			'11013':{ u:'11013', i:19508, name:'BRAHMI LETTER KA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11014':{ u:'11014', i:19509, name:'BRAHMI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11015':{ u:'11015', i:19510, name:'BRAHMI LETTER GA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11016':{ u:'11016', i:19511, name:'BRAHMI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11017':{ u:'11017', i:19512, name:'BRAHMI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11018':{ u:'11018', i:19513, name:'BRAHMI LETTER CA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11019':{ u:'11019', i:19514, name:'BRAHMI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11020':{ u:'11020', i:19521, name:'BRAHMI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11021':{ u:'11021', i:19522, name:'BRAHMI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11022':{ u:'11022', i:19523, name:'BRAHMI LETTER TA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11023':{ u:'11023', i:19524, name:'BRAHMI LETTER THA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11024':{ u:'11024', i:19525, name:'BRAHMI LETTER DA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11025':{ u:'11025', i:19526, name:'BRAHMI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11026':{ u:'11026', i:19527, name:'BRAHMI LETTER NA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11027':{ u:'11027', i:19528, name:'BRAHMI LETTER PA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11028':{ u:'11028', i:19529, name:'BRAHMI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11029':{ u:'11029', i:19530, name:'BRAHMI LETTER BA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11030':{ u:'11030', i:19537, name:'BRAHMI LETTER SHA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11031':{ u:'11031', i:19538, name:'BRAHMI LETTER SSA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11032':{ u:'11032', i:19539, name:'BRAHMI LETTER SA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11033':{ u:'11033', i:19540, name:'BRAHMI LETTER HA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11034':{ u:'11034', i:19541, name:'BRAHMI LETTER LLA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11035':{ u:'11035', i:19542, name:'BRAHMI LETTER OLD TAMIL LLLA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11036':{ u:'11036', i:19543, name:'BRAHMI LETTER OLD TAMIL RRA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11037':{ u:'11037', i:19544, name:'BRAHMI LETTER OLD TAMIL NNNA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11038':{ u:'11038', i:19545, name:'BRAHMI VOWEL SIGN AA', cat:c.Mn,   canon:k._0, block:b[214]},
			'11039':{ u:'11039', i:19546, name:'BRAHMI VOWEL SIGN BHATTIPROLU AA', cat:c.Mn,   canon:k._0, block:b[214]},
			'11040':{ u:'11040', i:19553, name:'BRAHMI VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[214], indexed:["L"]},
			'11041':{ u:'11041', i:19554, name:'BRAHMI VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[214]},
			'11042':{ u:'11042', i:19555, name:'BRAHMI VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[214], indexed:["E"]},
			'11043':{ u:'11043', i:19556, name:'BRAHMI VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[214]},
			'11044':{ u:'11044', i:19557, name:'BRAHMI VOWEL SIGN O', cat:c.Mn,   canon:k._0, block:b[214], indexed:["O"]},
			'11045':{ u:'11045', i:19558, name:'BRAHMI VOWEL SIGN AU', cat:c.Mn,   canon:k._0, block:b[214]},
			'11046':{ u:'11046', i:19559, name:'BRAHMI VIRAMA', cat:c.Mn,   canon:k._9, block:b[214]},
			'11047':{ u:'11047', i:19560, name:'BRAHMI DANDA', cat:c.Po,   canon:k._0, block:b[214]},
			'11048':{ u:'11048', i:19561, name:'BRAHMI DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[214]},
			'11049':{ u:'11049', i:19562, name:'BRAHMI PUNCTUATION DOT', cat:c.Po,   canon:k._0, block:b[214]},
			'11052':{ u:'11052', i:19567, name:'BRAHMI NUMBER ONE', cat:c.No,   canon:k._0, block:b[214]},
			'11053':{ u:'11053', i:19568, name:'BRAHMI NUMBER TWO', cat:c.No,   canon:k._0, block:b[214]},
			'11054':{ u:'11054', i:19569, name:'BRAHMI NUMBER THREE', cat:c.No,   canon:k._0, block:b[214]},
			'11055':{ u:'11055', i:19570, name:'BRAHMI NUMBER FOUR', cat:c.No,   canon:k._0, block:b[214]},
			'11056':{ u:'11056', i:19571, name:'BRAHMI NUMBER FIVE', cat:c.No,   canon:k._0, block:b[214]},
			'11057':{ u:'11057', i:19572, name:'BRAHMI NUMBER SIX', cat:c.No,   canon:k._0, block:b[214]},
			'11058':{ u:'11058', i:19573, name:'BRAHMI NUMBER SEVEN', cat:c.No,   canon:k._0, block:b[214]},
			'11059':{ u:'11059', i:19574, name:'BRAHMI NUMBER EIGHT', cat:c.No,   canon:k._0, block:b[214]},
			'11060':{ u:'11060', i:19581, name:'BRAHMI NUMBER SIXTY', cat:c.No,   canon:k._0, block:b[214]},
			'11061':{ u:'11061', i:19582, name:'BRAHMI NUMBER SEVENTY', cat:c.No,   canon:k._0, block:b[214]},
			'11062':{ u:'11062', i:19583, name:'BRAHMI NUMBER EIGHTY', cat:c.No,   canon:k._0, block:b[214]},
			'11063':{ u:'11063', i:19584, name:'BRAHMI NUMBER NINETY', cat:c.No,   canon:k._0, block:b[214]},
			'11064':{ u:'11064', i:19585, name:'BRAHMI NUMBER ONE HUNDRED', cat:c.No,   canon:k._0, block:b[214]},
			'11065':{ u:'11065', i:19586, name:'BRAHMI NUMBER ONE THOUSAND', cat:c.No,   canon:k._0, block:b[214]},
			'11066':{ u:'11066', i:19587, name:'BRAHMI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[214]},
			'11067':{ u:'11067', i:19588, name:'BRAHMI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[214]},
			'11068':{ u:'11068', i:19589, name:'BRAHMI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[214]},
			'11069':{ u:'11069', i:19590, name:'BRAHMI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[214]},
			'11070':{ u:'11070', i:19597, name:'BRAHMI SIGN OLD TAMIL VIRAMA', cat:c.Mn,   canon:k._9, block:b[214]},
			'11071':{ u:'11071', i:19598, name:'BRAHMI LETTER OLD TAMIL SHORT E', cat:c.Lo,   canon:k._0, block:b[214], indexed:["E"]},
			'11072':{ u:'11072', i:19599, name:'BRAHMI LETTER OLD TAMIL SHORT O', cat:c.Lo,   canon:k._0, block:b[214], indexed:["O"]},
			'11073':{ u:'11073', i:19600, name:'BRAHMI VOWEL SIGN OLD TAMIL SHORT E', cat:c.Mn,   canon:k._0, block:b[214], indexed:["E"]},
			'11074':{ u:'11074', i:19601, name:'BRAHMI VOWEL SIGN OLD TAMIL SHORT O', cat:c.Mn,   canon:k._0, block:b[214], indexed:["O"]},
			'11075':{ u:'11075', i:19602, name:'BRAHMI LETTER OLD TAMIL LLA', cat:c.Lo,   canon:k._0, block:b[214]},
			'11080':{ u:'11080', i:19604, name:'KAITHI SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[215]},
			'11081':{ u:'11081', i:19605, name:'KAITHI SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[215]},
			'11082':{ u:'11082', i:19606, name:'KAITHI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[215]},
			'11083':{ u:'11083', i:19607, name:'KAITHI LETTER A', cat:c.Lo,   canon:k._0, block:b[215], indexed:["A"]},
			'11084':{ u:'11084', i:19608, name:'KAITHI LETTER AA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11085':{ u:'11085', i:19609, name:'KAITHI LETTER I', cat:c.Lo,   canon:k._0, block:b[215], indexed:["I"]},
			'11086':{ u:'11086', i:19610, name:'KAITHI LETTER II', cat:c.Lo,   canon:k._0, block:b[215]},
			'11087':{ u:'11087', i:19611, name:'KAITHI LETTER U', cat:c.Lo,   canon:k._0, block:b[215], indexed:["U"]},
			'11088':{ u:'11088', i:19612, name:'KAITHI LETTER UU', cat:c.Lo,   canon:k._0, block:b[215]},
			'11089':{ u:'11089', i:19613, name:'KAITHI LETTER E', cat:c.Lo,   canon:k._0, block:b[215], indexed:["E"]},
			'11090':{ u:'11090', i:19620, name:'KAITHI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11091':{ u:'11091', i:19621, name:'KAITHI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11092':{ u:'11092', i:19622, name:'KAITHI LETTER CA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11093':{ u:'11093', i:19623, name:'KAITHI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11094':{ u:'11094', i:19624, name:'KAITHI LETTER JA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11095':{ u:'11095', i:19625, name:'KAITHI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11096':{ u:'11096', i:19626, name:'KAITHI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11097':{ u:'11097', i:19627, name:'KAITHI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11098':{ u:'11098', i:19628, name:'KAITHI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[215]},
			'11099':{ u:'11099', i:19629, name:'KAITHI LETTER DDA', cat:c.Lo,  relatives:['1109a'],  canon:k._0, block:b[215]},
			'11100':{ u:'11100', i:19707, name:'CHAKMA SIGN CANDRABINDU', cat:c.Mn,   canon:k._230, block:b[217]},
			'11101':{ u:'11101', i:19708, name:'CHAKMA SIGN ANUSVARA', cat:c.Mn,   canon:k._230, block:b[217]},
			'11102':{ u:'11102', i:19709, name:'CHAKMA SIGN VISARGA', cat:c.Mn,   canon:k._230, block:b[217]},
			'11103':{ u:'11103', i:19710, name:'CHAKMA LETTER AA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11104':{ u:'11104', i:19711, name:'CHAKMA LETTER I', cat:c.Lo,   canon:k._0, block:b[217], indexed:["I"]},
			'11105':{ u:'11105', i:19712, name:'CHAKMA LETTER U', cat:c.Lo,   canon:k._0, block:b[217], indexed:["U"]},
			'11106':{ u:'11106', i:19713, name:'CHAKMA LETTER E', cat:c.Lo,   canon:k._0, block:b[217], indexed:["E"]},
			'11107':{ u:'11107', i:19714, name:'CHAKMA LETTER KAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11108':{ u:'11108', i:19715, name:'CHAKMA LETTER KHAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11109':{ u:'11109', i:19716, name:'CHAKMA LETTER GAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11110':{ u:'11110', i:19723, name:'CHAKMA LETTER NYAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11111':{ u:'11111', i:19724, name:'CHAKMA LETTER TTAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11112':{ u:'11112', i:19725, name:'CHAKMA LETTER TTHAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11113':{ u:'11113', i:19726, name:'CHAKMA LETTER DDAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11114':{ u:'11114', i:19727, name:'CHAKMA LETTER DDHAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11115':{ u:'11115', i:19728, name:'CHAKMA LETTER NNAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11116':{ u:'11116', i:19729, name:'CHAKMA LETTER TAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11117':{ u:'11117', i:19730, name:'CHAKMA LETTER THAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11118':{ u:'11118', i:19731, name:'CHAKMA LETTER DAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11119':{ u:'11119', i:19732, name:'CHAKMA LETTER DHAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11120':{ u:'11120', i:19739, name:'CHAKMA LETTER YYAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11121':{ u:'11121', i:19740, name:'CHAKMA LETTER YAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11122':{ u:'11122', i:19741, name:'CHAKMA LETTER RAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11123':{ u:'11123', i:19742, name:'CHAKMA LETTER LAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11124':{ u:'11124', i:19743, name:'CHAKMA LETTER WAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11125':{ u:'11125', i:19744, name:'CHAKMA LETTER SAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11126':{ u:'11126', i:19745, name:'CHAKMA LETTER HAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11127':{ u:'11127', i:19746, name:'CHAKMA VOWEL SIGN A', cat:c.Mn,  relatives:['1112e', '1112f'],  canon:k._0, block:b[217], indexed:["A"]},
			'11128':{ u:'11128', i:19747, name:'CHAKMA VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[217], indexed:["I"]},
			'11129':{ u:'11129', i:19748, name:'CHAKMA VOWEL SIGN II', cat:c.Mn,   canon:k._0, block:b[217]},
			'11130':{ u:'11130', i:19755, name:'CHAKMA VOWEL SIGN OI', cat:c.Mn,   canon:k._0, block:b[217]},
			'11131':{ u:'11131', i:19756, name:'CHAKMA O MARK', cat:c.Mn,  relatives:['1112e'],  canon:k._0, block:b[217], indexed:["O"]},
			'11132':{ u:'11132', i:19757, name:'CHAKMA AU MARK', cat:c.Mn,  relatives:['1112f'],  canon:k._0, block:b[217]},
			'11133':{ u:'11133', i:19758, name:'CHAKMA VIRAMA', cat:c.Mn,   canon:k._9, block:b[217]},
			'11134':{ u:'11134', i:19759, name:'CHAKMA MAAYYAA', cat:c.Mn,   canon:k._9, block:b[217]},
			'11136':{ u:'11136', i:19760, name:'CHAKMA DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[217]},
			'11137':{ u:'11137', i:19761, name:'CHAKMA DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[217]},
			'11138':{ u:'11138', i:19762, name:'CHAKMA DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[217]},
			'11139':{ u:'11139', i:19763, name:'CHAKMA DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[217]},
			'11140':{ u:'11140', i:19770, name:'CHAKMA SECTION MARK', cat:c.Po,   canon:k._0, block:b[217]},
			'11141':{ u:'11141', i:19771, name:'CHAKMA DANDA', cat:c.Po,   canon:k._0, block:b[217]},
			'11142':{ u:'11142', i:19772, name:'CHAKMA DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[217]},
			'11143':{ u:'11143', i:19773, name:'CHAKMA QUESTION MARK', cat:c.Po,   canon:k._0, block:b[217]},
			'11144':{ u:'11144', i:19774, name:'CHAKMA LETTER LHAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11145':{ u:'11145', i:19775, name:'CHAKMA VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[217]},
			'11146':{ u:'11146', i:19776, name:'CHAKMA VOWEL SIGN EI', cat:c.Mc,   canon:k._0, block:b[217]},
			'11147':{ u:'11147', i:19777, name:'CHAKMA LETTER VAA', cat:c.Lo,   canon:k._0, block:b[217]},
			'11150':{ u:'11150', i:19778, name:'MAHAJANI LETTER A', cat:c.Lo,   canon:k._0, block:b[218], indexed:["A"]},
			'11151':{ u:'11151', i:19779, name:'MAHAJANI LETTER I', cat:c.Lo,   canon:k._0, block:b[218], indexed:["I"]},
			'11152':{ u:'11152', i:19780, name:'MAHAJANI LETTER U', cat:c.Lo,   canon:k._0, block:b[218], indexed:["U"]},
			'11153':{ u:'11153', i:19781, name:'MAHAJANI LETTER E', cat:c.Lo,   canon:k._0, block:b[218], indexed:["E"]},
			'11154':{ u:'11154', i:19782, name:'MAHAJANI LETTER O', cat:c.Lo,   canon:k._0, block:b[218], indexed:["O"]},
			'11155':{ u:'11155', i:19783, name:'MAHAJANI LETTER KA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11156':{ u:'11156', i:19784, name:'MAHAJANI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11157':{ u:'11157', i:19785, name:'MAHAJANI LETTER GA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11158':{ u:'11158', i:19786, name:'MAHAJANI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11159':{ u:'11159', i:19787, name:'MAHAJANI LETTER CA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11160':{ u:'11160', i:19794, name:'MAHAJANI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11161':{ u:'11161', i:19795, name:'MAHAJANI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11162':{ u:'11162', i:19796, name:'MAHAJANI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11163':{ u:'11163', i:19797, name:'MAHAJANI LETTER TA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11164':{ u:'11164', i:19798, name:'MAHAJANI LETTER THA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11165':{ u:'11165', i:19799, name:'MAHAJANI LETTER DA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11166':{ u:'11166', i:19800, name:'MAHAJANI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11167':{ u:'11167', i:19801, name:'MAHAJANI LETTER NA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11168':{ u:'11168', i:19802, name:'MAHAJANI LETTER PA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11169':{ u:'11169', i:19803, name:'MAHAJANI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11170':{ u:'11170', i:19810, name:'MAHAJANI LETTER SA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11171':{ u:'11171', i:19811, name:'MAHAJANI LETTER HA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11172':{ u:'11172', i:19812, name:'MAHAJANI LETTER RRA', cat:c.Lo,   canon:k._0, block:b[218]},
			'11173':{ u:'11173', i:19813, name:'MAHAJANI SIGN NUKTA', cat:c.Mn,   canon:k._7, block:b[218]},
			'11174':{ u:'11174', i:19814, name:'MAHAJANI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[218]},
			'11175':{ u:'11175', i:19815, name:'MAHAJANI SECTION MARK', cat:c.Po,   canon:k._0, block:b[218]},
			'11176':{ u:'11176', i:19816, name:'MAHAJANI LIGATURE SHRI', cat:c.Lo,   canon:k._0, block:b[218]},
			'11180':{ u:'11180', i:19817, name:'SHARADA SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[219]},
			'11181':{ u:'11181', i:19818, name:'SHARADA SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[219]},
			'11182':{ u:'11182', i:19819, name:'SHARADA SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[219]},
			'11183':{ u:'11183', i:19820, name:'SHARADA LETTER A', cat:c.Lo,   canon:k._0, block:b[219], indexed:["A"]},
			'11184':{ u:'11184', i:19821, name:'SHARADA LETTER AA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11185':{ u:'11185', i:19822, name:'SHARADA LETTER I', cat:c.Lo,   canon:k._0, block:b[219], indexed:["I"]},
			'11186':{ u:'11186', i:19823, name:'SHARADA LETTER II', cat:c.Lo,   canon:k._0, block:b[219]},
			'11187':{ u:'11187', i:19824, name:'SHARADA LETTER U', cat:c.Lo,   canon:k._0, block:b[219], indexed:["U"]},
			'11188':{ u:'11188', i:19825, name:'SHARADA LETTER UU', cat:c.Lo,   canon:k._0, block:b[219]},
			'11189':{ u:'11189', i:19826, name:'SHARADA LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[219], indexed:["R"]},
			'11190':{ u:'11190', i:19833, name:'SHARADA LETTER AU', cat:c.Lo,   canon:k._0, block:b[219]},
			'11191':{ u:'11191', i:19834, name:'SHARADA LETTER KA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11192':{ u:'11192', i:19835, name:'SHARADA LETTER KHA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11193':{ u:'11193', i:19836, name:'SHARADA LETTER GA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11194':{ u:'11194', i:19837, name:'SHARADA LETTER GHA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11195':{ u:'11195', i:19838, name:'SHARADA LETTER NGA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11196':{ u:'11196', i:19839, name:'SHARADA LETTER CA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11197':{ u:'11197', i:19840, name:'SHARADA LETTER CHA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11198':{ u:'11198', i:19841, name:'SHARADA LETTER JA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11199':{ u:'11199', i:19842, name:'SHARADA LETTER JHA', cat:c.Lo,   canon:k._0, block:b[219]},
			'11200':{ u:'11200', i:19933, name:'KHOJKI LETTER A', cat:c.Lo,   canon:k._0, block:b[221], indexed:["A"]},
			'11201':{ u:'11201', i:19934, name:'KHOJKI LETTER AA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11202':{ u:'11202', i:19935, name:'KHOJKI LETTER I', cat:c.Lo,   canon:k._0, block:b[221], indexed:["I"]},
			'11203':{ u:'11203', i:19936, name:'KHOJKI LETTER U', cat:c.Lo,   canon:k._0, block:b[221], indexed:["U"]},
			'11204':{ u:'11204', i:19937, name:'KHOJKI LETTER E', cat:c.Lo,   canon:k._0, block:b[221], indexed:["E"]},
			'11205':{ u:'11205', i:19938, name:'KHOJKI LETTER AI', cat:c.Lo,   canon:k._0, block:b[221]},
			'11206':{ u:'11206', i:19939, name:'KHOJKI LETTER O', cat:c.Lo,   canon:k._0, block:b[221], indexed:["O"]},
			'11207':{ u:'11207', i:19940, name:'KHOJKI LETTER AU', cat:c.Lo,   canon:k._0, block:b[221]},
			'11208':{ u:'11208', i:19941, name:'KHOJKI LETTER KA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11209':{ u:'11209', i:19942, name:'KHOJKI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11210':{ u:'11210', i:19949, name:'KHOJKI LETTER JA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11211':{ u:'11211', i:19950, name:'KHOJKI LETTER JJA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11213':{ u:'11213', i:19951, name:'KHOJKI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11214':{ u:'11214', i:19952, name:'KHOJKI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11215':{ u:'11215', i:19953, name:'KHOJKI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11216':{ u:'11216', i:19954, name:'KHOJKI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11217':{ u:'11217', i:19955, name:'KHOJKI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11218':{ u:'11218', i:19956, name:'KHOJKI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11219':{ u:'11219', i:19957, name:'KHOJKI LETTER TA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11220':{ u:'11220', i:19964, name:'KHOJKI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11221':{ u:'11221', i:19965, name:'KHOJKI LETTER BA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11222':{ u:'11222', i:19966, name:'KHOJKI LETTER BBA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11223':{ u:'11223', i:19967, name:'KHOJKI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11224':{ u:'11224', i:19968, name:'KHOJKI LETTER MA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11225':{ u:'11225', i:19969, name:'KHOJKI LETTER YA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11226':{ u:'11226', i:19970, name:'KHOJKI LETTER RA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11227':{ u:'11227', i:19971, name:'KHOJKI LETTER LA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11228':{ u:'11228', i:19972, name:'KHOJKI LETTER VA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11229':{ u:'11229', i:19973, name:'KHOJKI LETTER SA', cat:c.Lo,   canon:k._0, block:b[221]},
			'11230':{ u:'11230', i:19980, name:'KHOJKI VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[221], indexed:["E"]},
			'11231':{ u:'11231', i:19981, name:'KHOJKI VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[221]},
			'11232':{ u:'11232', i:19982, name:'KHOJKI VOWEL SIGN O', cat:c.Mc,   canon:k._0, block:b[221], indexed:["O"]},
			'11233':{ u:'11233', i:19983, name:'KHOJKI VOWEL SIGN AU', cat:c.Mc,   canon:k._0, block:b[221]},
			'11234':{ u:'11234', i:19984, name:'KHOJKI SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[221]},
			'11235':{ u:'11235', i:19985, name:'KHOJKI SIGN VIRAMA', cat:c.Mc,   canon:k._9, block:b[221]},
			'11236':{ u:'11236', i:19986, name:'KHOJKI SIGN NUKTA', cat:c.Mn,   canon:k._7, block:b[221]},
			'11237':{ u:'11237', i:19987, name:'KHOJKI SIGN SHADDA', cat:c.Mn,   canon:k._0, block:b[221]},
			'11238':{ u:'11238', i:19988, name:'KHOJKI DANDA', cat:c.Po,   canon:k._0, block:b[221]},
			'11239':{ u:'11239', i:19989, name:'KHOJKI DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[221]},
			'11280':{ u:'11280', i:19995, name:'MULTANI LETTER A', cat:c.Lo,   canon:k._0, block:b[222], indexed:["A"]},
			'11281':{ u:'11281', i:19996, name:'MULTANI LETTER I', cat:c.Lo,   canon:k._0, block:b[222], indexed:["I"]},
			'11282':{ u:'11282', i:19997, name:'MULTANI LETTER U', cat:c.Lo,   canon:k._0, block:b[222], indexed:["U"]},
			'11283':{ u:'11283', i:19998, name:'MULTANI LETTER E', cat:c.Lo,   canon:k._0, block:b[222], indexed:["E"]},
			'11284':{ u:'11284', i:19999, name:'MULTANI LETTER KA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11285':{ u:'11285', i:20000, name:'MULTANI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11286':{ u:'11286', i:20001, name:'MULTANI LETTER GA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11288':{ u:'11288', i:20002, name:'MULTANI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11290':{ u:'11290', i:20008, name:'MULTANI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11291':{ u:'11291', i:20009, name:'MULTANI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11292':{ u:'11292', i:20010, name:'MULTANI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11293':{ u:'11293', i:20011, name:'MULTANI LETTER DDDA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11294':{ u:'11294', i:20012, name:'MULTANI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11295':{ u:'11295', i:20013, name:'MULTANI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11296':{ u:'11296', i:20014, name:'MULTANI LETTER TA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11297':{ u:'11297', i:20015, name:'MULTANI LETTER THA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11298':{ u:'11298', i:20016, name:'MULTANI LETTER DA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11299':{ u:'11299', i:20017, name:'MULTANI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[222]},
			'11300':{ u:'11300', i:20102, name:'GRANTHA SIGN COMBINING ANUSVARA ABOVE', cat:c.Mn,   canon:k._0, block:b[224]},
			'11301':{ u:'11301', i:20103, name:'GRANTHA SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[224]},
			'11302':{ u:'11302', i:20104, name:'GRANTHA SIGN ANUSVARA', cat:c.Mc,   canon:k._0, block:b[224]},
			'11303':{ u:'11303', i:20105, name:'GRANTHA SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[224]},
			'11305':{ u:'11305', i:20106, name:'GRANTHA LETTER A', cat:c.Lo,   canon:k._0, block:b[224], indexed:["A"]},
			'11306':{ u:'11306', i:20107, name:'GRANTHA LETTER AA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11307':{ u:'11307', i:20108, name:'GRANTHA LETTER I', cat:c.Lo,   canon:k._0, block:b[224], indexed:["I"]},
			'11308':{ u:'11308', i:20109, name:'GRANTHA LETTER II', cat:c.Lo,   canon:k._0, block:b[224]},
			'11309':{ u:'11309', i:20110, name:'GRANTHA LETTER U', cat:c.Lo,   canon:k._0, block:b[224], indexed:["U"]},
			'11310':{ u:'11310', i:20115, name:'GRANTHA LETTER AI', cat:c.Lo,   canon:k._0, block:b[224]},
			'11313':{ u:'11313', i:20116, name:'GRANTHA LETTER OO', cat:c.Lo,   canon:k._0, block:b[224]},
			'11314':{ u:'11314', i:20117, name:'GRANTHA LETTER AU', cat:c.Lo,   canon:k._0, block:b[224]},
			'11315':{ u:'11315', i:20118, name:'GRANTHA LETTER KA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11316':{ u:'11316', i:20119, name:'GRANTHA LETTER KHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11317':{ u:'11317', i:20120, name:'GRANTHA LETTER GA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11318':{ u:'11318', i:20121, name:'GRANTHA LETTER GHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11319':{ u:'11319', i:20122, name:'GRANTHA LETTER NGA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11320':{ u:'11320', i:20129, name:'GRANTHA LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11321':{ u:'11321', i:20130, name:'GRANTHA LETTER DDA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11322':{ u:'11322', i:20131, name:'GRANTHA LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11323':{ u:'11323', i:20132, name:'GRANTHA LETTER NNA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11324':{ u:'11324', i:20133, name:'GRANTHA LETTER TA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11325':{ u:'11325', i:20134, name:'GRANTHA LETTER THA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11326':{ u:'11326', i:20135, name:'GRANTHA LETTER DA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11327':{ u:'11327', i:20136, name:'GRANTHA LETTER DHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11328':{ u:'11328', i:20137, name:'GRANTHA LETTER NA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11330':{ u:'11330', i:20144, name:'GRANTHA LETTER RA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11332':{ u:'11332', i:20145, name:'GRANTHA LETTER LA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11333':{ u:'11333', i:20146, name:'GRANTHA LETTER LLA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11335':{ u:'11335', i:20147, name:'GRANTHA LETTER VA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11336':{ u:'11336', i:20148, name:'GRANTHA LETTER SHA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11337':{ u:'11337', i:20149, name:'GRANTHA LETTER SSA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11338':{ u:'11338', i:20150, name:'GRANTHA LETTER SA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11339':{ u:'11339', i:20151, name:'GRANTHA LETTER HA', cat:c.Lo,   canon:k._0, block:b[224]},
			'11340':{ u:'11340', i:20157, name:'GRANTHA VOWEL SIGN II', cat:c.Mn,   canon:k._0, block:b[224]},
			'11341':{ u:'11341', i:20158, name:'GRANTHA VOWEL SIGN U', cat:c.Mc,   canon:k._0, block:b[224], indexed:["U"]},
			'11342':{ u:'11342', i:20159, name:'GRANTHA VOWEL SIGN UU', cat:c.Mc,   canon:k._0, block:b[224]},
			'11343':{ u:'11343', i:20160, name:'GRANTHA VOWEL SIGN VOCALIC R', cat:c.Mc,   canon:k._0, block:b[224], indexed:["R"]},
			'11344':{ u:'11344', i:20161, name:'GRANTHA VOWEL SIGN VOCALIC RR', cat:c.Mc,   canon:k._0, block:b[224]},
			'11347':{ u:'11347', i:20162, name:'GRANTHA VOWEL SIGN EE', cat:c.Mc,  relatives:['1134b', '1134c'],  canon:k._0, block:b[224]},
			'11348':{ u:'11348', i:20163, name:'GRANTHA VOWEL SIGN AI', cat:c.Mc,   canon:k._0, block:b[224]},
			'11350':{ u:'11350', i:20167, name:'GRANTHA OM', cat:c.Lo,   canon:k._0, block:b[224]},
			'11357':{ u:'11357', i:20168, name:'GRANTHA AU LENGTH MARK', cat:c.Mc,  relatives:['1134c'],  canon:k._0, block:b[224]},
			'11360':{ u:'11360', i:20172, name:'GRANTHA LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[224]},
			'11361':{ u:'11361', i:20173, name:'GRANTHA LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[224]},
			'11362':{ u:'11362', i:20174, name:'GRANTHA VOWEL SIGN VOCALIC L', cat:c.Mc,   canon:k._0, block:b[224], indexed:["L"]},
			'11363':{ u:'11363', i:20175, name:'GRANTHA VOWEL SIGN VOCALIC LL', cat:c.Mc,   canon:k._0, block:b[224]},
			'11366':{ u:'11366', i:20176, name:'COMBINING GRANTHA DIGIT ZERO', cat:c.Mn,   canon:k._230, block:b[224]},
			'11367':{ u:'11367', i:20177, name:'COMBINING GRANTHA DIGIT ONE', cat:c.Mn,   canon:k._230, block:b[224]},
			'11368':{ u:'11368', i:20178, name:'COMBINING GRANTHA DIGIT TWO', cat:c.Mn,   canon:k._230, block:b[224]},
			'11369':{ u:'11369', i:20179, name:'COMBINING GRANTHA DIGIT THREE', cat:c.Mn,   canon:k._230, block:b[224]},
			'11370':{ u:'11370', i:20183, name:'COMBINING GRANTHA LETTER A', cat:c.Mn,   canon:k._230, block:b[224], indexed:["A"]},
			'11371':{ u:'11371', i:20184, name:'COMBINING GRANTHA LETTER KA', cat:c.Mn,   canon:k._230, block:b[224]},
			'11372':{ u:'11372', i:20185, name:'COMBINING GRANTHA LETTER NA', cat:c.Mn,   canon:k._230, block:b[224]},
			'11373':{ u:'11373', i:20186, name:'COMBINING GRANTHA LETTER VI', cat:c.Mn,   canon:k._230, block:b[224]},
			'11374':{ u:'11374', i:20187, name:'COMBINING GRANTHA LETTER PA', cat:c.Mn,   canon:k._230, block:b[224]},
			'11400':{ u:'11400', i:20188, name:'NEWA LETTER A', cat:c.Lo,   canon:k._0, block:b[225], indexed:["A"]},
			'11401':{ u:'11401', i:20189, name:'NEWA LETTER AA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11402':{ u:'11402', i:20190, name:'NEWA LETTER I', cat:c.Lo,   canon:k._0, block:b[225], indexed:["I"]},
			'11403':{ u:'11403', i:20191, name:'NEWA LETTER II', cat:c.Lo,   canon:k._0, block:b[225]},
			'11404':{ u:'11404', i:20192, name:'NEWA LETTER U', cat:c.Lo,   canon:k._0, block:b[225], indexed:["U"]},
			'11405':{ u:'11405', i:20193, name:'NEWA LETTER UU', cat:c.Lo,   canon:k._0, block:b[225]},
			'11406':{ u:'11406', i:20194, name:'NEWA LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[225], indexed:["R"]},
			'11407':{ u:'11407', i:20195, name:'NEWA LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[225]},
			'11408':{ u:'11408', i:20196, name:'NEWA LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[225], indexed:["L"]},
			'11409':{ u:'11409', i:20197, name:'NEWA LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[225]},
			'11410':{ u:'11410', i:20204, name:'NEWA LETTER GA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11411':{ u:'11411', i:20205, name:'NEWA LETTER GHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11412':{ u:'11412', i:20206, name:'NEWA LETTER NGA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11413':{ u:'11413', i:20207, name:'NEWA LETTER NGHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11414':{ u:'11414', i:20208, name:'NEWA LETTER CA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11415':{ u:'11415', i:20209, name:'NEWA LETTER CHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11416':{ u:'11416', i:20210, name:'NEWA LETTER JA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11417':{ u:'11417', i:20211, name:'NEWA LETTER JHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11418':{ u:'11418', i:20212, name:'NEWA LETTER NYA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11419':{ u:'11419', i:20213, name:'NEWA LETTER NYHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11420':{ u:'11420', i:20220, name:'NEWA LETTER THA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11421':{ u:'11421', i:20221, name:'NEWA LETTER DA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11422':{ u:'11422', i:20222, name:'NEWA LETTER DHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11423':{ u:'11423', i:20223, name:'NEWA LETTER NA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11424':{ u:'11424', i:20224, name:'NEWA LETTER NHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11425':{ u:'11425', i:20225, name:'NEWA LETTER PA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11426':{ u:'11426', i:20226, name:'NEWA LETTER PHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11427':{ u:'11427', i:20227, name:'NEWA LETTER BA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11428':{ u:'11428', i:20228, name:'NEWA LETTER BHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11429':{ u:'11429', i:20229, name:'NEWA LETTER MA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11430':{ u:'11430', i:20236, name:'NEWA LETTER WA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11431':{ u:'11431', i:20237, name:'NEWA LETTER SHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11432':{ u:'11432', i:20238, name:'NEWA LETTER SSA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11433':{ u:'11433', i:20239, name:'NEWA LETTER SA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11434':{ u:'11434', i:20240, name:'NEWA LETTER HA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11435':{ u:'11435', i:20241, name:'NEWA VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[225]},
			'11436':{ u:'11436', i:20242, name:'NEWA VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[225], indexed:["I"]},
			'11437':{ u:'11437', i:20243, name:'NEWA VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[225]},
			'11438':{ u:'11438', i:20244, name:'NEWA VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[225], indexed:["U"]},
			'11439':{ u:'11439', i:20245, name:'NEWA VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[225]},
			'11440':{ u:'11440', i:20252, name:'NEWA VOWEL SIGN O', cat:c.Mc,   canon:k._0, block:b[225], indexed:["O"]},
			'11441':{ u:'11441', i:20253, name:'NEWA VOWEL SIGN AU', cat:c.Mc,   canon:k._0, block:b[225]},
			'11442':{ u:'11442', i:20254, name:'NEWA SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[225]},
			'11443':{ u:'11443', i:20255, name:'NEWA SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[225]},
			'11444':{ u:'11444', i:20256, name:'NEWA SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[225]},
			'11445':{ u:'11445', i:20257, name:'NEWA SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[225]},
			'11446':{ u:'11446', i:20258, name:'NEWA SIGN NUKTA', cat:c.Mn,   canon:k._7, block:b[225]},
			'11447':{ u:'11447', i:20259, name:'NEWA SIGN AVAGRAHA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11448':{ u:'11448', i:20260, name:'NEWA SIGN FINAL ANUSVARA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11449':{ u:'11449', i:20261, name:'NEWA OM', cat:c.Lo,   canon:k._0, block:b[225]},
			'11450':{ u:'11450', i:20268, name:'NEWA DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[225]},
			'11451':{ u:'11451', i:20269, name:'NEWA DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[225]},
			'11452':{ u:'11452', i:20270, name:'NEWA DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[225]},
			'11453':{ u:'11453', i:20271, name:'NEWA DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[225]},
			'11454':{ u:'11454', i:20272, name:'NEWA DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[225]},
			'11455':{ u:'11455', i:20273, name:'NEWA DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[225]},
			'11456':{ u:'11456', i:20274, name:'NEWA DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[225]},
			'11457':{ u:'11457', i:20275, name:'NEWA DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[225]},
			'11458':{ u:'11458', i:20276, name:'NEWA DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[225]},
			'11459':{ u:'11459', i:20277, name:'NEWA DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[225]},
			'11460':{ u:'11460', i:20283, name:'NEWA SIGN JIHVAMULIYA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11461':{ u:'11461', i:20284, name:'NEWA SIGN UPADHMANIYA', cat:c.Lo,   canon:k._0, block:b[225]},
			'11480':{ u:'11480', i:20285, name:'TIRHUTA ANJI', cat:c.Lo,   canon:k._0, block:b[226]},
			'11481':{ u:'11481', i:20286, name:'TIRHUTA LETTER A', cat:c.Lo,   canon:k._0, block:b[226], indexed:["A"]},
			'11482':{ u:'11482', i:20287, name:'TIRHUTA LETTER AA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11483':{ u:'11483', i:20288, name:'TIRHUTA LETTER I', cat:c.Lo,   canon:k._0, block:b[226], indexed:["I"]},
			'11484':{ u:'11484', i:20289, name:'TIRHUTA LETTER II', cat:c.Lo,   canon:k._0, block:b[226]},
			'11485':{ u:'11485', i:20290, name:'TIRHUTA LETTER U', cat:c.Lo,   canon:k._0, block:b[226], indexed:["U"]},
			'11486':{ u:'11486', i:20291, name:'TIRHUTA LETTER UU', cat:c.Lo,   canon:k._0, block:b[226]},
			'11487':{ u:'11487', i:20292, name:'TIRHUTA LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[226], indexed:["R"]},
			'11488':{ u:'11488', i:20293, name:'TIRHUTA LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[226]},
			'11489':{ u:'11489', i:20294, name:'TIRHUTA LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[226], indexed:["L"]},
			'11490':{ u:'11490', i:20301, name:'TIRHUTA LETTER KHA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11491':{ u:'11491', i:20302, name:'TIRHUTA LETTER GA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11492':{ u:'11492', i:20303, name:'TIRHUTA LETTER GHA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11493':{ u:'11493', i:20304, name:'TIRHUTA LETTER NGA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11494':{ u:'11494', i:20305, name:'TIRHUTA LETTER CA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11495':{ u:'11495', i:20306, name:'TIRHUTA LETTER CHA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11496':{ u:'11496', i:20307, name:'TIRHUTA LETTER JA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11497':{ u:'11497', i:20308, name:'TIRHUTA LETTER JHA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11498':{ u:'11498', i:20309, name:'TIRHUTA LETTER NYA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11499':{ u:'11499', i:20310, name:'TIRHUTA LETTER TTA', cat:c.Lo,   canon:k._0, block:b[226]},
			'11580':{ u:'11580', i:20367, name:'SIDDHAM LETTER A', cat:c.Lo,   canon:k._0, block:b[227], indexed:["A"]},
			'11581':{ u:'11581', i:20368, name:'SIDDHAM LETTER AA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11582':{ u:'11582', i:20369, name:'SIDDHAM LETTER I', cat:c.Lo,   canon:k._0, block:b[227], indexed:["I"]},
			'11583':{ u:'11583', i:20370, name:'SIDDHAM LETTER II', cat:c.Lo,   canon:k._0, block:b[227]},
			'11584':{ u:'11584', i:20371, name:'SIDDHAM LETTER U', cat:c.Lo,   canon:k._0, block:b[227], indexed:["U"]},
			'11585':{ u:'11585', i:20372, name:'SIDDHAM LETTER UU', cat:c.Lo,   canon:k._0, block:b[227]},
			'11586':{ u:'11586', i:20373, name:'SIDDHAM LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[227], indexed:["R"]},
			'11587':{ u:'11587', i:20374, name:'SIDDHAM LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[227]},
			'11588':{ u:'11588', i:20375, name:'SIDDHAM LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[227], indexed:["L"]},
			'11589':{ u:'11589', i:20376, name:'SIDDHAM LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[227]},
			'11590':{ u:'11590', i:20383, name:'SIDDHAM LETTER GA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11591':{ u:'11591', i:20384, name:'SIDDHAM LETTER GHA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11592':{ u:'11592', i:20385, name:'SIDDHAM LETTER NGA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11593':{ u:'11593', i:20386, name:'SIDDHAM LETTER CA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11594':{ u:'11594', i:20387, name:'SIDDHAM LETTER CHA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11595':{ u:'11595', i:20388, name:'SIDDHAM LETTER JA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11596':{ u:'11596', i:20389, name:'SIDDHAM LETTER JHA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11597':{ u:'11597', i:20390, name:'SIDDHAM LETTER NYA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11598':{ u:'11598', i:20391, name:'SIDDHAM LETTER TTA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11599':{ u:'11599', i:20392, name:'SIDDHAM LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[227]},
			'11600':{ u:'11600', i:20459, name:'MODI LETTER A', cat:c.Lo,   canon:k._0, block:b[228], indexed:["A"]},
			'11601':{ u:'11601', i:20460, name:'MODI LETTER AA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11602':{ u:'11602', i:20461, name:'MODI LETTER I', cat:c.Lo,   canon:k._0, block:b[228], indexed:["I"]},
			'11603':{ u:'11603', i:20462, name:'MODI LETTER II', cat:c.Lo,   canon:k._0, block:b[228]},
			'11604':{ u:'11604', i:20463, name:'MODI LETTER U', cat:c.Lo,   canon:k._0, block:b[228], indexed:["U"]},
			'11605':{ u:'11605', i:20464, name:'MODI LETTER UU', cat:c.Lo,   canon:k._0, block:b[228]},
			'11606':{ u:'11606', i:20465, name:'MODI LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[228], indexed:["R"]},
			'11607':{ u:'11607', i:20466, name:'MODI LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[228]},
			'11608':{ u:'11608', i:20467, name:'MODI LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[228], indexed:["L"]},
			'11609':{ u:'11609', i:20468, name:'MODI LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[228]},
			'11610':{ u:'11610', i:20475, name:'MODI LETTER GA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11611':{ u:'11611', i:20476, name:'MODI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11612':{ u:'11612', i:20477, name:'MODI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11613':{ u:'11613', i:20478, name:'MODI LETTER CA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11614':{ u:'11614', i:20479, name:'MODI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11615':{ u:'11615', i:20480, name:'MODI LETTER JA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11616':{ u:'11616', i:20481, name:'MODI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11617':{ u:'11617', i:20482, name:'MODI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11618':{ u:'11618', i:20483, name:'MODI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11619':{ u:'11619', i:20484, name:'MODI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11620':{ u:'11620', i:20491, name:'MODI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11621':{ u:'11621', i:20492, name:'MODI LETTER NA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11622':{ u:'11622', i:20493, name:'MODI LETTER PA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11623':{ u:'11623', i:20494, name:'MODI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11624':{ u:'11624', i:20495, name:'MODI LETTER BA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11625':{ u:'11625', i:20496, name:'MODI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11626':{ u:'11626', i:20497, name:'MODI LETTER MA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11627':{ u:'11627', i:20498, name:'MODI LETTER YA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11628':{ u:'11628', i:20499, name:'MODI LETTER RA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11629':{ u:'11629', i:20500, name:'MODI LETTER LA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11630':{ u:'11630', i:20507, name:'MODI VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[228]},
			'11631':{ u:'11631', i:20508, name:'MODI VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[228], indexed:["I"]},
			'11632':{ u:'11632', i:20509, name:'MODI VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[228]},
			'11633':{ u:'11633', i:20510, name:'MODI VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[228], indexed:["U"]},
			'11634':{ u:'11634', i:20511, name:'MODI VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[228]},
			'11635':{ u:'11635', i:20512, name:'MODI VOWEL SIGN VOCALIC R', cat:c.Mn,   canon:k._0, block:b[228], indexed:["R"]},
			'11636':{ u:'11636', i:20513, name:'MODI VOWEL SIGN VOCALIC RR', cat:c.Mn,   canon:k._0, block:b[228]},
			'11637':{ u:'11637', i:20514, name:'MODI VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[228], indexed:["L"]},
			'11638':{ u:'11638', i:20515, name:'MODI VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[228]},
			'11639':{ u:'11639', i:20516, name:'MODI VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[228], indexed:["E"]},
			'11640':{ u:'11640', i:20523, name:'MODI SIGN ARDHACANDRA', cat:c.Mn,   canon:k._0, block:b[228]},
			'11641':{ u:'11641', i:20524, name:'MODI DANDA', cat:c.Po,   canon:k._0, block:b[228]},
			'11642':{ u:'11642', i:20525, name:'MODI DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[228]},
			'11643':{ u:'11643', i:20526, name:'MODI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[228]},
			'11644':{ u:'11644', i:20527, name:'MODI SIGN HUVA', cat:c.Lo,   canon:k._0, block:b[228]},
			'11650':{ u:'11650', i:20528, name:'MODI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[228]},
			'11651':{ u:'11651', i:20529, name:'MODI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[228]},
			'11652':{ u:'11652', i:20530, name:'MODI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[228]},
			'11653':{ u:'11653', i:20531, name:'MODI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[228]},
			'11654':{ u:'11654', i:20532, name:'MODI DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[228]},
			'11655':{ u:'11655', i:20533, name:'MODI DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[228]},
			'11656':{ u:'11656', i:20534, name:'MODI DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[228]},
			'11657':{ u:'11657', i:20535, name:'MODI DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[228]},
			'11658':{ u:'11658', i:20536, name:'MODI DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[228]},
			'11659':{ u:'11659', i:20537, name:'MODI DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[228]},
			'11660':{ u:'11660', i:20538, name:'MONGOLIAN BIRGA WITH ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11661':{ u:'11661', i:20539, name:'MONGOLIAN ROTATED BIRGA', cat:c.Po,   canon:k._0, block:b[229]},
			'11662':{ u:'11662', i:20540, name:'MONGOLIAN DOUBLE BIRGA WITH ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11663':{ u:'11663', i:20541, name:'MONGOLIAN TRIPLE BIRGA WITH ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11664':{ u:'11664', i:20542, name:'MONGOLIAN BIRGA WITH DOUBLE ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11665':{ u:'11665', i:20543, name:'MONGOLIAN ROTATED BIRGA WITH ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11666':{ u:'11666', i:20544, name:'MONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11667':{ u:'11667', i:20545, name:'MONGOLIAN INVERTED BIRGA', cat:c.Po,   canon:k._0, block:b[229]},
			'11668':{ u:'11668', i:20546, name:'MONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENT', cat:c.Po,   canon:k._0, block:b[229]},
			'11669':{ u:'11669', i:20547, name:'MONGOLIAN SWIRL BIRGA', cat:c.Po,   canon:k._0, block:b[229]},
			'11680':{ u:'11680', i:20551, name:'TAKRI LETTER A', cat:c.Lo,   canon:k._0, block:b[230], indexed:["A"]},
			'11681':{ u:'11681', i:20552, name:'TAKRI LETTER AA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11682':{ u:'11682', i:20553, name:'TAKRI LETTER I', cat:c.Lo,   canon:k._0, block:b[230], indexed:["I"]},
			'11683':{ u:'11683', i:20554, name:'TAKRI LETTER II', cat:c.Lo,   canon:k._0, block:b[230]},
			'11684':{ u:'11684', i:20555, name:'TAKRI LETTER U', cat:c.Lo,   canon:k._0, block:b[230], indexed:["U"]},
			'11685':{ u:'11685', i:20556, name:'TAKRI LETTER UU', cat:c.Lo,   canon:k._0, block:b[230]},
			'11686':{ u:'11686', i:20557, name:'TAKRI LETTER E', cat:c.Lo,   canon:k._0, block:b[230], indexed:["E"]},
			'11687':{ u:'11687', i:20558, name:'TAKRI LETTER AI', cat:c.Lo,   canon:k._0, block:b[230]},
			'11688':{ u:'11688', i:20559, name:'TAKRI LETTER O', cat:c.Lo,   canon:k._0, block:b[230], indexed:["O"]},
			'11689':{ u:'11689', i:20560, name:'TAKRI LETTER AU', cat:c.Lo,   canon:k._0, block:b[230]},
			'11690':{ u:'11690', i:20567, name:'TAKRI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11691':{ u:'11691', i:20568, name:'TAKRI LETTER JA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11692':{ u:'11692', i:20569, name:'TAKRI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11693':{ u:'11693', i:20570, name:'TAKRI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11694':{ u:'11694', i:20571, name:'TAKRI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11695':{ u:'11695', i:20572, name:'TAKRI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11696':{ u:'11696', i:20573, name:'TAKRI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11697':{ u:'11697', i:20574, name:'TAKRI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11698':{ u:'11698', i:20575, name:'TAKRI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11699':{ u:'11699', i:20576, name:'TAKRI LETTER TA', cat:c.Lo,   canon:k._0, block:b[230]},
			'11700':{ u:'11700', i:20619, name:'AHOM LETTER KA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11701':{ u:'11701', i:20620, name:'AHOM LETTER KHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11702':{ u:'11702', i:20621, name:'AHOM LETTER NGA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11703':{ u:'11703', i:20622, name:'AHOM LETTER NA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11704':{ u:'11704', i:20623, name:'AHOM LETTER TA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11705':{ u:'11705', i:20624, name:'AHOM LETTER ALTERNATE TA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11706':{ u:'11706', i:20625, name:'AHOM LETTER PA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11707':{ u:'11707', i:20626, name:'AHOM LETTER PHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11708':{ u:'11708', i:20627, name:'AHOM LETTER BA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11709':{ u:'11709', i:20628, name:'AHOM LETTER MA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11710':{ u:'11710', i:20635, name:'AHOM LETTER NYA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11711':{ u:'11711', i:20636, name:'AHOM LETTER HA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11712':{ u:'11712', i:20637, name:'AHOM LETTER A', cat:c.Lo,   canon:k._0, block:b[231], indexed:["A"]},
			'11713':{ u:'11713', i:20638, name:'AHOM LETTER DA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11714':{ u:'11714', i:20639, name:'AHOM LETTER DHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11715':{ u:'11715', i:20640, name:'AHOM LETTER GA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11716':{ u:'11716', i:20641, name:'AHOM LETTER ALTERNATE GA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11717':{ u:'11717', i:20642, name:'AHOM LETTER GHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11718':{ u:'11718', i:20643, name:'AHOM LETTER BHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11719':{ u:'11719', i:20644, name:'AHOM LETTER JHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11720':{ u:'11720', i:20649, name:'AHOM VOWEL SIGN A', cat:c.Mc,   canon:k._0, block:b[231], indexed:["A"]},
			'11721':{ u:'11721', i:20650, name:'AHOM VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[231]},
			'11722':{ u:'11722', i:20651, name:'AHOM VOWEL SIGN I', cat:c.Mn,   canon:k._0, block:b[231], indexed:["I"]},
			'11723':{ u:'11723', i:20652, name:'AHOM VOWEL SIGN II', cat:c.Mn,   canon:k._0, block:b[231]},
			'11724':{ u:'11724', i:20653, name:'AHOM VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[231], indexed:["U"]},
			'11725':{ u:'11725', i:20654, name:'AHOM VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[231]},
			'11726':{ u:'11726', i:20655, name:'AHOM VOWEL SIGN E', cat:c.Mc,   canon:k._0, block:b[231], indexed:["E"]},
			'11727':{ u:'11727', i:20656, name:'AHOM VOWEL SIGN AW', cat:c.Mn,   canon:k._0, block:b[231]},
			'11728':{ u:'11728', i:20657, name:'AHOM VOWEL SIGN O', cat:c.Mn,   canon:k._0, block:b[231], indexed:["O"]},
			'11729':{ u:'11729', i:20658, name:'AHOM VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[231]},
			'11730':{ u:'11730', i:20661, name:'AHOM DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[231]},
			'11731':{ u:'11731', i:20662, name:'AHOM DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[231]},
			'11732':{ u:'11732', i:20663, name:'AHOM DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[231]},
			'11733':{ u:'11733', i:20664, name:'AHOM DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[231]},
			'11734':{ u:'11734', i:20665, name:'AHOM DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[231]},
			'11735':{ u:'11735', i:20666, name:'AHOM DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[231]},
			'11736':{ u:'11736', i:20667, name:'AHOM DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[231]},
			'11737':{ u:'11737', i:20668, name:'AHOM DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[231]},
			'11738':{ u:'11738', i:20669, name:'AHOM DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[231]},
			'11739':{ u:'11739', i:20670, name:'AHOM DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[231]},
			'11740':{ u:'11740', i:20677, name:'AHOM LETTER CA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11741':{ u:'11741', i:20678, name:'AHOM LETTER TTA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11742':{ u:'11742', i:20679, name:'AHOM LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11743':{ u:'11743', i:20680, name:'AHOM LETTER DDA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11744':{ u:'11744', i:20681, name:'AHOM LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11745':{ u:'11745', i:20682, name:'AHOM LETTER NNA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11746':{ u:'11746', i:20683, name:'AHOM LETTER LLA', cat:c.Lo,   canon:k._0, block:b[231]},
			'11800':{ u:'11800', i:20684, name:'DOGRA LETTER A', cat:c.Lo,   canon:k._0, block:b[232], indexed:["A"]},
			'11801':{ u:'11801', i:20685, name:'DOGRA LETTER AA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11802':{ u:'11802', i:20686, name:'DOGRA LETTER I', cat:c.Lo,   canon:k._0, block:b[232], indexed:["I"]},
			'11803':{ u:'11803', i:20687, name:'DOGRA LETTER II', cat:c.Lo,   canon:k._0, block:b[232]},
			'11804':{ u:'11804', i:20688, name:'DOGRA LETTER U', cat:c.Lo,   canon:k._0, block:b[232], indexed:["U"]},
			'11805':{ u:'11805', i:20689, name:'DOGRA LETTER UU', cat:c.Lo,   canon:k._0, block:b[232]},
			'11806':{ u:'11806', i:20690, name:'DOGRA LETTER E', cat:c.Lo,   canon:k._0, block:b[232], indexed:["E"]},
			'11807':{ u:'11807', i:20691, name:'DOGRA LETTER AI', cat:c.Lo,   canon:k._0, block:b[232]},
			'11808':{ u:'11808', i:20692, name:'DOGRA LETTER O', cat:c.Lo,   canon:k._0, block:b[232], indexed:["O"]},
			'11809':{ u:'11809', i:20693, name:'DOGRA LETTER AU', cat:c.Lo,   canon:k._0, block:b[232]},
			'11810':{ u:'11810', i:20700, name:'DOGRA LETTER CHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11811':{ u:'11811', i:20701, name:'DOGRA LETTER JA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11812':{ u:'11812', i:20702, name:'DOGRA LETTER JHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11813':{ u:'11813', i:20703, name:'DOGRA LETTER NYA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11814':{ u:'11814', i:20704, name:'DOGRA LETTER TTA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11815':{ u:'11815', i:20705, name:'DOGRA LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11816':{ u:'11816', i:20706, name:'DOGRA LETTER DDA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11817':{ u:'11817', i:20707, name:'DOGRA LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11818':{ u:'11818', i:20708, name:'DOGRA LETTER NNA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11819':{ u:'11819', i:20709, name:'DOGRA LETTER TA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11820':{ u:'11820', i:20716, name:'DOGRA LETTER BA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11821':{ u:'11821', i:20717, name:'DOGRA LETTER BHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11822':{ u:'11822', i:20718, name:'DOGRA LETTER MA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11823':{ u:'11823', i:20719, name:'DOGRA LETTER YA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11824':{ u:'11824', i:20720, name:'DOGRA LETTER RA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11825':{ u:'11825', i:20721, name:'DOGRA LETTER LA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11826':{ u:'11826', i:20722, name:'DOGRA LETTER VA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11827':{ u:'11827', i:20723, name:'DOGRA LETTER SHA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11828':{ u:'11828', i:20724, name:'DOGRA LETTER SSA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11829':{ u:'11829', i:20725, name:'DOGRA LETTER SA', cat:c.Lo,   canon:k._0, block:b[232]},
			'11830':{ u:'11830', i:20732, name:'DOGRA VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[232]},
			'11831':{ u:'11831', i:20733, name:'DOGRA VOWEL SIGN VOCALIC R', cat:c.Mn,   canon:k._0, block:b[232], indexed:["R"]},
			'11832':{ u:'11832', i:20734, name:'DOGRA VOWEL SIGN VOCALIC RR', cat:c.Mn,   canon:k._0, block:b[232]},
			'11833':{ u:'11833', i:20735, name:'DOGRA VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[232], indexed:["E"]},
			'11834':{ u:'11834', i:20736, name:'DOGRA VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[232]},
			'11835':{ u:'11835', i:20737, name:'DOGRA VOWEL SIGN O', cat:c.Mn,   canon:k._0, block:b[232], indexed:["O"]},
			'11836':{ u:'11836', i:20738, name:'DOGRA VOWEL SIGN AU', cat:c.Mn,   canon:k._0, block:b[232]},
			'11837':{ u:'11837', i:20739, name:'DOGRA SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[232]},
			'11838':{ u:'11838', i:20740, name:'DOGRA SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[232]},
			'11839':{ u:'11839', i:20741, name:'DOGRA SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[232]},
			'11900':{ u:'11900', i:20828, name:'DIVES AKURU LETTER A', cat:c.Lo,   canon:k._0, block:b[234], indexed:["A"]},
			'11901':{ u:'11901', i:20829, name:'DIVES AKURU LETTER AA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11902':{ u:'11902', i:20830, name:'DIVES AKURU LETTER I', cat:c.Lo,   canon:k._0, block:b[234], indexed:["I"]},
			'11903':{ u:'11903', i:20831, name:'DIVES AKURU LETTER II', cat:c.Lo,   canon:k._0, block:b[234]},
			'11904':{ u:'11904', i:20832, name:'DIVES AKURU LETTER U', cat:c.Lo,   canon:k._0, block:b[234], indexed:["U"]},
			'11905':{ u:'11905', i:20833, name:'DIVES AKURU LETTER UU', cat:c.Lo,   canon:k._0, block:b[234]},
			'11906':{ u:'11906', i:20834, name:'DIVES AKURU LETTER E', cat:c.Lo,   canon:k._0, block:b[234], indexed:["E"]},
			'11909':{ u:'11909', i:20835, name:'DIVES AKURU LETTER O', cat:c.Lo,   canon:k._0, block:b[234], indexed:["O"]},
			'11910':{ u:'11910', i:20840, name:'DIVES AKURU LETTER NGA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11911':{ u:'11911', i:20841, name:'DIVES AKURU LETTER CA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11912':{ u:'11912', i:20842, name:'DIVES AKURU LETTER CHA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11913':{ u:'11913', i:20843, name:'DIVES AKURU LETTER JA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11915':{ u:'11915', i:20844, name:'DIVES AKURU LETTER NYA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11916':{ u:'11916', i:20845, name:'DIVES AKURU LETTER TTA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11918':{ u:'11918', i:20846, name:'DIVES AKURU LETTER DDA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11919':{ u:'11919', i:20847, name:'DIVES AKURU LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11920':{ u:'11920', i:20854, name:'DIVES AKURU LETTER PA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11921':{ u:'11921', i:20855, name:'DIVES AKURU LETTER PHA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11922':{ u:'11922', i:20856, name:'DIVES AKURU LETTER BA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11923':{ u:'11923', i:20857, name:'DIVES AKURU LETTER BHA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11924':{ u:'11924', i:20858, name:'DIVES AKURU LETTER MA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11925':{ u:'11925', i:20859, name:'DIVES AKURU LETTER YA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11926':{ u:'11926', i:20860, name:'DIVES AKURU LETTER YYA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11927':{ u:'11927', i:20861, name:'DIVES AKURU LETTER RA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11928':{ u:'11928', i:20862, name:'DIVES AKURU LETTER LA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11929':{ u:'11929', i:20863, name:'DIVES AKURU LETTER VA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11930':{ u:'11930', i:20870, name:'DIVES AKURU VOWEL SIGN AA', cat:c.Mc,  relatives:['11938'],  canon:k._0, block:b[234]},
			'11931':{ u:'11931', i:20871, name:'DIVES AKURU VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[234], indexed:["I"]},
			'11932':{ u:'11932', i:20872, name:'DIVES AKURU VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[234]},
			'11933':{ u:'11933', i:20873, name:'DIVES AKURU VOWEL SIGN U', cat:c.Mc,   canon:k._0, block:b[234], indexed:["U"]},
			'11934':{ u:'11934', i:20874, name:'DIVES AKURU VOWEL SIGN UU', cat:c.Mc,   canon:k._0, block:b[234]},
			'11935':{ u:'11935', i:20875, name:'DIVES AKURU VOWEL SIGN E', cat:c.Mc,  relatives:['11938'],  canon:k._0, block:b[234], indexed:["E"]},
			'11937':{ u:'11937', i:20876, name:'DIVES AKURU VOWEL SIGN AI', cat:c.Mc,   canon:k._0, block:b[234]},
			'11938':{ u:'11938', i:20877, name:'DIVES AKURU VOWEL SIGN O', cat:c.Mc,  relatives:['11935', '11930'], comp:['11935','11930'], canon:k._0, block:b[234], indexed:["O"]},
			'11940':{ u:'11940', i:20883, name:'DIVES AKURU MEDIAL YA', cat:c.Mc,   canon:k._0, block:b[234]},
			'11941':{ u:'11941', i:20884, name:'DIVES AKURU INITIAL RA', cat:c.Lo,   canon:k._0, block:b[234]},
			'11942':{ u:'11942', i:20885, name:'DIVES AKURU MEDIAL RA', cat:c.Mc,   canon:k._0, block:b[234]},
			'11943':{ u:'11943', i:20886, name:'DIVES AKURU SIGN NUKTA', cat:c.Mn,   canon:k._7, block:b[234]},
			'11944':{ u:'11944', i:20887, name:'DIVES AKURU DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[234]},
			'11945':{ u:'11945', i:20888, name:'DIVES AKURU GAP FILLER', cat:c.Po,   canon:k._0, block:b[234]},
			'11946':{ u:'11946', i:20889, name:'DIVES AKURU END OF TEXT MARK', cat:c.Po,   canon:k._0, block:b[234]},
			'11950':{ u:'11950', i:20890, name:'DIVES AKURU DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[234]},
			'11951':{ u:'11951', i:20891, name:'DIVES AKURU DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[234]},
			'11952':{ u:'11952', i:20892, name:'DIVES AKURU DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[234]},
			'11953':{ u:'11953', i:20893, name:'DIVES AKURU DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[234]},
			'11954':{ u:'11954', i:20894, name:'DIVES AKURU DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[234]},
			'11955':{ u:'11955', i:20895, name:'DIVES AKURU DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[234]},
			'11956':{ u:'11956', i:20896, name:'DIVES AKURU DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[234]},
			'11957':{ u:'11957', i:20897, name:'DIVES AKURU DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[234]},
			'11958':{ u:'11958', i:20898, name:'DIVES AKURU DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[234]},
			'11959':{ u:'11959', i:20899, name:'DIVES AKURU DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[234]},
			'12000':{ u:'12000', i:21573, name:'CUNEIFORM SIGN A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12001':{ u:'12001', i:21574, name:'CUNEIFORM SIGN A TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A","A"]},
			'12002':{ u:'12002', i:21575, name:'CUNEIFORM SIGN A TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12003':{ u:'12003', i:21576, name:'CUNEIFORM SIGN A TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12004':{ u:'12004', i:21577, name:'CUNEIFORM SIGN A TIMES HA', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12005':{ u:'12005', i:21578, name:'CUNEIFORM SIGN A TIMES IGI', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12006':{ u:'12006', i:21579, name:'CUNEIFORM SIGN A TIMES LAGAR GUNU', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12007':{ u:'12007', i:21580, name:'CUNEIFORM SIGN A TIMES MUSH', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12008':{ u:'12008', i:21581, name:'CUNEIFORM SIGN A TIMES SAG', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12009':{ u:'12009', i:21582, name:'CUNEIFORM SIGN A2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12010':{ u:'12010', i:21589, name:'CUNEIFORM SIGN AB TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12011':{ u:'12011', i:21590, name:'CUNEIFORM SIGN AB TIMES IMIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12012':{ u:'12012', i:21591, name:'CUNEIFORM SIGN AB TIMES LAGAB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12013':{ u:'12013', i:21592, name:'CUNEIFORM SIGN AB TIMES SHESH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12014':{ u:'12014', i:21593, name:'CUNEIFORM SIGN AB TIMES U PLUS U PLUS U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U","U","U"]},
			'12015':{ u:'12015', i:21594, name:'CUNEIFORM SIGN AB GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12016':{ u:'12016', i:21595, name:'CUNEIFORM SIGN AB2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12017':{ u:'12017', i:21596, name:'CUNEIFORM SIGN AB2 TIMES BALAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12018':{ u:'12018', i:21597, name:'CUNEIFORM SIGN AB2 TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12019':{ u:'12019', i:21598, name:'CUNEIFORM SIGN AB2 TIMES ME PLUS EN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12020':{ u:'12020', i:21605, name:'CUNEIFORM SIGN AL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12021':{ u:'12021', i:21606, name:'CUNEIFORM SIGN AL TIMES AL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12022':{ u:'12022', i:21607, name:'CUNEIFORM SIGN AL TIMES DIM2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12023':{ u:'12023', i:21608, name:'CUNEIFORM SIGN AL TIMES GISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12024':{ u:'12024', i:21609, name:'CUNEIFORM SIGN AL TIMES HA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12025':{ u:'12025', i:21610, name:'CUNEIFORM SIGN AL TIMES KAD3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12026':{ u:'12026', i:21611, name:'CUNEIFORM SIGN AL TIMES KI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12027':{ u:'12027', i:21612, name:'CUNEIFORM SIGN AL TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12028':{ u:'12028', i:21613, name:'CUNEIFORM SIGN AL TIMES USH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12029':{ u:'12029', i:21614, name:'CUNEIFORM SIGN ALAN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12030':{ u:'12030', i:21621, name:'CUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12031':{ u:'12031', i:21622, name:'CUNEIFORM SIGN AN PLUS NAGA SQUARED', cat:c.Lo,   canon:k._0, block:b[247]},
			'12032':{ u:'12032', i:21623, name:'CUNEIFORM SIGN ANSHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12033':{ u:'12033', i:21624, name:'CUNEIFORM SIGN APIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12034':{ u:'12034', i:21625, name:'CUNEIFORM SIGN ARAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12035':{ u:'12035', i:21626, name:'CUNEIFORM SIGN ARAD TIMES KUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12036':{ u:'12036', i:21627, name:'CUNEIFORM SIGN ARKAB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12037':{ u:'12037', i:21628, name:'CUNEIFORM SIGN ASAL2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12038':{ u:'12038', i:21629, name:'CUNEIFORM SIGN ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12039':{ u:'12039', i:21630, name:'CUNEIFORM SIGN ASH ZIDA TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12040':{ u:'12040', i:21637, name:'CUNEIFORM SIGN BA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12041':{ u:'12041', i:21638, name:'CUNEIFORM SIGN BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12042':{ u:'12042', i:21639, name:'CUNEIFORM SIGN BAG3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12043':{ u:'12043', i:21640, name:'CUNEIFORM SIGN BAHAR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12044':{ u:'12044', i:21641, name:'CUNEIFORM SIGN BAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12045':{ u:'12045', i:21642, name:'CUNEIFORM SIGN BAL OVER BAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12046':{ u:'12046', i:21643, name:'CUNEIFORM SIGN BALAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12047':{ u:'12047', i:21644, name:'CUNEIFORM SIGN BAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12048':{ u:'12048', i:21645, name:'CUNEIFORM SIGN BARA2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12049':{ u:'12049', i:21646, name:'CUNEIFORM SIGN BI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12050':{ u:'12050', i:21653, name:'CUNEIFORM SIGN BU CROSSING BU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12051':{ u:'12051', i:21654, name:'CUNEIFORM SIGN BULUG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12052':{ u:'12052', i:21655, name:'CUNEIFORM SIGN BULUG OVER BULUG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12053':{ u:'12053', i:21656, name:'CUNEIFORM SIGN BUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12054':{ u:'12054', i:21657, name:'CUNEIFORM SIGN BUR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12055':{ u:'12055', i:21658, name:'CUNEIFORM SIGN DA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12056':{ u:'12056', i:21659, name:'CUNEIFORM SIGN DAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12057':{ u:'12057', i:21660, name:'CUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASH', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12058':{ u:'12058', i:21661, name:'CUNEIFORM SIGN DAG KISIM5 TIMES AMAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12059':{ u:'12059', i:21662, name:'CUNEIFORM SIGN DAG KISIM5 TIMES BALAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12060':{ u:'12060', i:21669, name:'CUNEIFORM SIGN DAG KISIM5 TIMES HA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12061':{ u:'12061', i:21670, name:'CUNEIFORM SIGN DAG KISIM5 TIMES IR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12062':{ u:'12062', i:21671, name:'CUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12063':{ u:'12063', i:21672, name:'CUNEIFORM SIGN DAG KISIM5 TIMES KAK', cat:c.Lo,   canon:k._0, block:b[247]},
			'12064':{ u:'12064', i:21673, name:'CUNEIFORM SIGN DAG KISIM5 TIMES LA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12065':{ u:'12065', i:21674, name:'CUNEIFORM SIGN DAG KISIM5 TIMES LU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12066':{ u:'12066', i:21675, name:'CUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12067':{ u:'12067', i:21676, name:'CUNEIFORM SIGN DAG KISIM5 TIMES LUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12068':{ u:'12068', i:21677, name:'CUNEIFORM SIGN DAG KISIM5 TIMES NE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12069':{ u:'12069', i:21678, name:'CUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAP', cat:c.Lo,   canon:k._0, block:b[247]},
			'12070':{ u:'12070', i:21685, name:'CUNEIFORM SIGN DARA3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12071':{ u:'12071', i:21686, name:'CUNEIFORM SIGN DARA4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12072':{ u:'12072', i:21687, name:'CUNEIFORM SIGN DI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12073':{ u:'12073', i:21688, name:'CUNEIFORM SIGN DIB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12074':{ u:'12074', i:21689, name:'CUNEIFORM SIGN DIM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12075':{ u:'12075', i:21690, name:'CUNEIFORM SIGN DIM TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12076':{ u:'12076', i:21691, name:'CUNEIFORM SIGN DIM2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12077':{ u:'12077', i:21692, name:'CUNEIFORM SIGN DIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12078':{ u:'12078', i:21693, name:'CUNEIFORM SIGN DIN KASKAL U GUNU DISH', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12079':{ u:'12079', i:21694, name:'CUNEIFORM SIGN DISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12080':{ u:'12080', i:21701, name:'CUNEIFORM SIGN DUB2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12081':{ u:'12081', i:21702, name:'CUNEIFORM SIGN DUG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12082':{ u:'12082', i:21703, name:'CUNEIFORM SIGN DUGUD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12083':{ u:'12083', i:21704, name:'CUNEIFORM SIGN DUH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12084':{ u:'12084', i:21705, name:'CUNEIFORM SIGN DUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12085':{ u:'12085', i:21706, name:'CUNEIFORM SIGN DUN3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12086':{ u:'12086', i:21707, name:'CUNEIFORM SIGN DUN3 GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12087':{ u:'12087', i:21708, name:'CUNEIFORM SIGN DUN3 GUNU GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12088':{ u:'12088', i:21709, name:'CUNEIFORM SIGN DUN4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12089':{ u:'12089', i:21710, name:'CUNEIFORM SIGN DUR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12090':{ u:'12090', i:21717, name:'CUNEIFORM SIGN E2 TIMES MI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12091':{ u:'12091', i:21718, name:'CUNEIFORM SIGN E2 TIMES SAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12092':{ u:'12092', i:21719, name:'CUNEIFORM SIGN E2 TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12093':{ u:'12093', i:21720, name:'CUNEIFORM SIGN E2 TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12094':{ u:'12094', i:21721, name:'CUNEIFORM SIGN EDIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12095':{ u:'12095', i:21722, name:'CUNEIFORM SIGN EGIR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12096':{ u:'12096', i:21723, name:'CUNEIFORM SIGN EL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12097':{ u:'12097', i:21724, name:'CUNEIFORM SIGN EN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12098':{ u:'12098', i:21725, name:'CUNEIFORM SIGN EN TIMES GAN2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12099':{ u:'12099', i:21726, name:'CUNEIFORM SIGN EN TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12100':{ u:'12100', i:21829, name:'CUNEIFORM SIGN GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12101':{ u:'12101', i:21830, name:'CUNEIFORM SIGN GI TIMES E', cat:c.Lo,   canon:k._0, block:b[247], indexed:["E"]},
			'12102':{ u:'12102', i:21831, name:'CUNEIFORM SIGN GI TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12103':{ u:'12103', i:21832, name:'CUNEIFORM SIGN GI CROSSING GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12104':{ u:'12104', i:21833, name:'CUNEIFORM SIGN GI4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12105':{ u:'12105', i:21834, name:'CUNEIFORM SIGN GI4 OVER GI4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12106':{ u:'12106', i:21835, name:'CUNEIFORM SIGN GI4 CROSSING GI4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12107':{ u:'12107', i:21836, name:'CUNEIFORM SIGN GIDIM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12108':{ u:'12108', i:21837, name:'CUNEIFORM SIGN GIR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12109':{ u:'12109', i:21838, name:'CUNEIFORM SIGN GIR2 GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12110':{ u:'12110', i:21845, name:'CUNEIFORM SIGN GISAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12111':{ u:'12111', i:21846, name:'CUNEIFORM SIGN GISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12112':{ u:'12112', i:21847, name:'CUNEIFORM SIGN GISH CROSSING GISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12113':{ u:'12113', i:21848, name:'CUNEIFORM SIGN GISH TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12114':{ u:'12114', i:21849, name:'CUNEIFORM SIGN GISH TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12115':{ u:'12115', i:21850, name:'CUNEIFORM SIGN GISH TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12116':{ u:'12116', i:21851, name:'CUNEIFORM SIGN GU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12117':{ u:'12117', i:21852, name:'CUNEIFORM SIGN GU CROSSING GU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12118':{ u:'12118', i:21853, name:'CUNEIFORM SIGN GU2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12119':{ u:'12119', i:21854, name:'CUNEIFORM SIGN GU2 TIMES KAK', cat:c.Lo,   canon:k._0, block:b[247]},
			'12120':{ u:'12120', i:21861, name:'CUNEIFORM SIGN GUD TIMES KUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12121':{ u:'12121', i:21862, name:'CUNEIFORM SIGN GUD OVER GUD LUGAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12122':{ u:'12122', i:21863, name:'CUNEIFORM SIGN GUL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12123':{ u:'12123', i:21864, name:'CUNEIFORM SIGN GUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12124':{ u:'12124', i:21865, name:'CUNEIFORM SIGN GUM TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12125':{ u:'12125', i:21866, name:'CUNEIFORM SIGN GUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12126':{ u:'12126', i:21867, name:'CUNEIFORM SIGN GUR7', cat:c.Lo,   canon:k._0, block:b[247]},
			'12127':{ u:'12127', i:21868, name:'CUNEIFORM SIGN GURUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12128':{ u:'12128', i:21869, name:'CUNEIFORM SIGN GURUSH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12129':{ u:'12129', i:21870, name:'CUNEIFORM SIGN HA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12130':{ u:'12130', i:21877, name:'CUNEIFORM SIGN HI TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12131':{ u:'12131', i:21878, name:'CUNEIFORM SIGN HI TIMES DISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12132':{ u:'12132', i:21879, name:'CUNEIFORM SIGN HI TIMES GAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12133':{ u:'12133', i:21880, name:'CUNEIFORM SIGN HI TIMES KIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12134':{ u:'12134', i:21881, name:'CUNEIFORM SIGN HI TIMES NUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12135':{ u:'12135', i:21882, name:'CUNEIFORM SIGN HI TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12136':{ u:'12136', i:21883, name:'CUNEIFORM SIGN HI TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12137':{ u:'12137', i:21884, name:'CUNEIFORM SIGN HU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12138':{ u:'12138', i:21885, name:'CUNEIFORM SIGN HUB2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12139':{ u:'12139', i:21886, name:'CUNEIFORM SIGN HUB2 TIMES AN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12140':{ u:'12140', i:21893, name:'CUNEIFORM SIGN I A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["I","A"]},
			'12141':{ u:'12141', i:21894, name:'CUNEIFORM SIGN IB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12142':{ u:'12142', i:21895, name:'CUNEIFORM SIGN IDIM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12143':{ u:'12143', i:21896, name:'CUNEIFORM SIGN IDIM OVER IDIM BUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12144':{ u:'12144', i:21897, name:'CUNEIFORM SIGN IDIM OVER IDIM SQUARED', cat:c.Lo,   canon:k._0, block:b[247]},
			'12145':{ u:'12145', i:21898, name:'CUNEIFORM SIGN IG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12146':{ u:'12146', i:21899, name:'CUNEIFORM SIGN IGI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12147':{ u:'12147', i:21900, name:'CUNEIFORM SIGN IGI DIB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12148':{ u:'12148', i:21901, name:'CUNEIFORM SIGN IGI RI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12149':{ u:'12149', i:21902, name:'CUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12150':{ u:'12150', i:21909, name:'CUNEIFORM SIGN IM CROSSING IM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12151':{ u:'12151', i:21910, name:'CUNEIFORM SIGN IM OPPOSING IM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12152':{ u:'12152', i:21911, name:'CUNEIFORM SIGN IM SQUARED', cat:c.Lo,   canon:k._0, block:b[247]},
			'12153':{ u:'12153', i:21912, name:'CUNEIFORM SIGN IMIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12154':{ u:'12154', i:21913, name:'CUNEIFORM SIGN IN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12155':{ u:'12155', i:21914, name:'CUNEIFORM SIGN IR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12156':{ u:'12156', i:21915, name:'CUNEIFORM SIGN ISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12157':{ u:'12157', i:21916, name:'CUNEIFORM SIGN KA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12158':{ u:'12158', i:21917, name:'CUNEIFORM SIGN KA TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12159':{ u:'12159', i:21918, name:'CUNEIFORM SIGN KA TIMES AD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12160':{ u:'12160', i:21925, name:'CUNEIFORM SIGN KA TIMES ERIN2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12161':{ u:'12161', i:21926, name:'CUNEIFORM SIGN KA TIMES ESH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12162':{ u:'12162', i:21927, name:'CUNEIFORM SIGN KA TIMES GA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12163':{ u:'12163', i:21928, name:'CUNEIFORM SIGN KA TIMES GAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12164':{ u:'12164', i:21929, name:'CUNEIFORM SIGN KA TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12165':{ u:'12165', i:21930, name:'CUNEIFORM SIGN KA TIMES GAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12166':{ u:'12166', i:21931, name:'CUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12167':{ u:'12167', i:21932, name:'CUNEIFORM SIGN KA TIMES GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12168':{ u:'12168', i:21933, name:'CUNEIFORM SIGN KA TIMES GIR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12169':{ u:'12169', i:21934, name:'CUNEIFORM SIGN KA TIMES GISH PLUS SAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12170':{ u:'12170', i:21941, name:'CUNEIFORM SIGN KA TIMES KI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12171':{ u:'12171', i:21942, name:'CUNEIFORM SIGN KA TIMES KID', cat:c.Lo,   canon:k._0, block:b[247]},
			'12172':{ u:'12172', i:21943, name:'CUNEIFORM SIGN KA TIMES LI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12173':{ u:'12173', i:21944, name:'CUNEIFORM SIGN KA TIMES LU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12174':{ u:'12174', i:21945, name:'CUNEIFORM SIGN KA TIMES ME', cat:c.Lo,   canon:k._0, block:b[247]},
			'12175':{ u:'12175', i:21946, name:'CUNEIFORM SIGN KA TIMES ME PLUS DU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12176':{ u:'12176', i:21947, name:'CUNEIFORM SIGN KA TIMES ME PLUS GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12177':{ u:'12177', i:21948, name:'CUNEIFORM SIGN KA TIMES ME PLUS TE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12178':{ u:'12178', i:21949, name:'CUNEIFORM SIGN KA TIMES MI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12179':{ u:'12179', i:21950, name:'CUNEIFORM SIGN KA TIMES MI PLUS NUNUZ', cat:c.Lo,   canon:k._0, block:b[247]},
			'12180':{ u:'12180', i:21957, name:'CUNEIFORM SIGN KA TIMES SHA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12181':{ u:'12181', i:21958, name:'CUNEIFORM SIGN KA TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12182':{ u:'12182', i:21959, name:'CUNEIFORM SIGN KA TIMES SHID', cat:c.Lo,   canon:k._0, block:b[247]},
			'12183':{ u:'12183', i:21960, name:'CUNEIFORM SIGN KA TIMES SHU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12184':{ u:'12184', i:21961, name:'CUNEIFORM SIGN KA TIMES SIG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12185':{ u:'12185', i:21962, name:'CUNEIFORM SIGN KA TIMES SUHUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12186':{ u:'12186', i:21963, name:'CUNEIFORM SIGN KA TIMES TAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12187':{ u:'12187', i:21964, name:'CUNEIFORM SIGN KA TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12188':{ u:'12188', i:21965, name:'CUNEIFORM SIGN KA TIMES U2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12189':{ u:'12189', i:21966, name:'CUNEIFORM SIGN KA TIMES UD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12190':{ u:'12190', i:21973, name:'CUNEIFORM SIGN KAD2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12191':{ u:'12191', i:21974, name:'CUNEIFORM SIGN KAD3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12192':{ u:'12192', i:21975, name:'CUNEIFORM SIGN KAD4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12193':{ u:'12193', i:21976, name:'CUNEIFORM SIGN KAD5', cat:c.Lo,   canon:k._0, block:b[247]},
			'12194':{ u:'12194', i:21977, name:'CUNEIFORM SIGN KAD5 OVER KAD5', cat:c.Lo,   canon:k._0, block:b[247]},
			'12195':{ u:'12195', i:21978, name:'CUNEIFORM SIGN KAK', cat:c.Lo,   canon:k._0, block:b[247]},
			'12196':{ u:'12196', i:21979, name:'CUNEIFORM SIGN KAK TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12197':{ u:'12197', i:21980, name:'CUNEIFORM SIGN KAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12198':{ u:'12198', i:21981, name:'CUNEIFORM SIGN KAL TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12199':{ u:'12199', i:21982, name:'CUNEIFORM SIGN KAL CROSSING KAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12200':{ u:'12200', i:22085, name:'CUNEIFORM SIGN LU2 TIMES ESH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12201':{ u:'12201', i:22086, name:'CUNEIFORM SIGN LU2 TIMES ESH2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12202':{ u:'12202', i:22087, name:'CUNEIFORM SIGN LU2 TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12203':{ u:'12203', i:22088, name:'CUNEIFORM SIGN LU2 TIMES HI TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12204':{ u:'12204', i:22089, name:'CUNEIFORM SIGN LU2 TIMES IM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12205':{ u:'12205', i:22090, name:'CUNEIFORM SIGN LU2 TIMES KAD2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12206':{ u:'12206', i:22091, name:'CUNEIFORM SIGN LU2 TIMES KAD3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12207':{ u:'12207', i:22092, name:'CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12208':{ u:'12208', i:22093, name:'CUNEIFORM SIGN LU2 TIMES KI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12209':{ u:'12209', i:22094, name:'CUNEIFORM SIGN LU2 TIMES LA PLUS ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12210':{ u:'12210', i:22101, name:'CUNEIFORM SIGN LU2 TIMES TUG2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12211':{ u:'12211', i:22102, name:'CUNEIFORM SIGN LU2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12212':{ u:'12212', i:22103, name:'CUNEIFORM SIGN LU2 CROSSING LU2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12213':{ u:'12213', i:22104, name:'CUNEIFORM SIGN LU2 OPPOSING LU2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12214':{ u:'12214', i:22105, name:'CUNEIFORM SIGN LU2 SQUARED', cat:c.Lo,   canon:k._0, block:b[247]},
			'12215':{ u:'12215', i:22106, name:'CUNEIFORM SIGN LU2 SHESHIG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12216':{ u:'12216', i:22107, name:'CUNEIFORM SIGN LU3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12217':{ u:'12217', i:22108, name:'CUNEIFORM SIGN LUGAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12218':{ u:'12218', i:22109, name:'CUNEIFORM SIGN LUGAL OVER LUGAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12219':{ u:'12219', i:22110, name:'CUNEIFORM SIGN LUGAL OPPOSING LUGAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12220':{ u:'12220', i:22117, name:'CUNEIFORM SIGN MA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12221':{ u:'12221', i:22118, name:'CUNEIFORM SIGN MA TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12222':{ u:'12222', i:22119, name:'CUNEIFORM SIGN MA GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12223':{ u:'12223', i:22120, name:'CUNEIFORM SIGN MA2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12224':{ u:'12224', i:22121, name:'CUNEIFORM SIGN MAH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12225':{ u:'12225', i:22122, name:'CUNEIFORM SIGN MAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12226':{ u:'12226', i:22123, name:'CUNEIFORM SIGN MASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12227':{ u:'12227', i:22124, name:'CUNEIFORM SIGN MASH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12228':{ u:'12228', i:22125, name:'CUNEIFORM SIGN ME', cat:c.Lo,   canon:k._0, block:b[247]},
			'12229':{ u:'12229', i:22126, name:'CUNEIFORM SIGN MES', cat:c.Lo,   canon:k._0, block:b[247]},
			'12230':{ u:'12230', i:22133, name:'CUNEIFORM SIGN MUNSUB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12231':{ u:'12231', i:22134, name:'CUNEIFORM SIGN MURGU2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12232':{ u:'12232', i:22135, name:'CUNEIFORM SIGN MUSH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12233':{ u:'12233', i:22136, name:'CUNEIFORM SIGN MUSH TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12234':{ u:'12234', i:22137, name:'CUNEIFORM SIGN MUSH TIMES KUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12235':{ u:'12235', i:22138, name:'CUNEIFORM SIGN MUSH TIMES ZA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12236':{ u:'12236', i:22139, name:'CUNEIFORM SIGN MUSH OVER MUSH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12237':{ u:'12237', i:22140, name:'CUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NA', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12238':{ u:'12238', i:22141, name:'CUNEIFORM SIGN MUSH CROSSING MUSH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12239':{ u:'12239', i:22142, name:'CUNEIFORM SIGN MUSH3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12240':{ u:'12240', i:22149, name:'CUNEIFORM SIGN NAGA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12241':{ u:'12241', i:22150, name:'CUNEIFORM SIGN NAGA INVERTED', cat:c.Lo,   canon:k._0, block:b[247]},
			'12242':{ u:'12242', i:22151, name:'CUNEIFORM SIGN NAGA TIMES SHU TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12243':{ u:'12243', i:22152, name:'CUNEIFORM SIGN NAGA OPPOSING NAGA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12244':{ u:'12244', i:22153, name:'CUNEIFORM SIGN NAGAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12245':{ u:'12245', i:22154, name:'CUNEIFORM SIGN NAM NUTILLU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12246':{ u:'12246', i:22155, name:'CUNEIFORM SIGN NAM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12247':{ u:'12247', i:22156, name:'CUNEIFORM SIGN NAM2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12248':{ u:'12248', i:22157, name:'CUNEIFORM SIGN NE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12249':{ u:'12249', i:22158, name:'CUNEIFORM SIGN NE TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12250':{ u:'12250', i:22165, name:'CUNEIFORM SIGN NIM TIMES GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12251':{ u:'12251', i:22166, name:'CUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12252':{ u:'12252', i:22167, name:'CUNEIFORM SIGN NINDA2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12253':{ u:'12253', i:22168, name:'CUNEIFORM SIGN NINDA2 TIMES AN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12254':{ u:'12254', i:22169, name:'CUNEIFORM SIGN NINDA2 TIMES ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12255':{ u:'12255', i:22170, name:'CUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12256':{ u:'12256', i:22171, name:'CUNEIFORM SIGN NINDA2 TIMES GUD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12257':{ u:'12257', i:22172, name:'CUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12258':{ u:'12258', i:22173, name:'CUNEIFORM SIGN NINDA2 TIMES NE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12259':{ u:'12259', i:22174, name:'CUNEIFORM SIGN NINDA2 TIMES NUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12260':{ u:'12260', i:22181, name:'CUNEIFORM SIGN NISAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12261':{ u:'12261', i:22182, name:'CUNEIFORM SIGN NU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12262':{ u:'12262', i:22183, name:'CUNEIFORM SIGN NU11', cat:c.Lo,   canon:k._0, block:b[247]},
			'12263':{ u:'12263', i:22184, name:'CUNEIFORM SIGN NUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12264':{ u:'12264', i:22185, name:'CUNEIFORM SIGN NUN LAGAR TIMES GAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12265':{ u:'12265', i:22186, name:'CUNEIFORM SIGN NUN LAGAR TIMES MASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12266':{ u:'12266', i:22187, name:'CUNEIFORM SIGN NUN LAGAR TIMES SAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12267':{ u:'12267', i:22188, name:'CUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12268':{ u:'12268', i:22189, name:'CUNEIFORM SIGN NUN LAGAR TIMES USH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12269':{ u:'12269', i:22190, name:'CUNEIFORM SIGN NUN TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12270':{ u:'12270', i:22197, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES DUG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12271':{ u:'12271', i:22198, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES GUD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12272':{ u:'12272', i:22199, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12273':{ u:'12273', i:22200, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12274':{ u:'12274', i:22201, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES LA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12275':{ u:'12275', i:22202, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES NE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12276':{ u:'12276', i:22203, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12277':{ u:'12277', i:22204, name:'CUNEIFORM SIGN NUNUZ AB2 TIMES U2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12278':{ u:'12278', i:22205, name:'CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12279':{ u:'12279', i:22206, name:'CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12280':{ u:'12280', i:22213, name:'CUNEIFORM SIGN PI TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12281':{ u:'12281', i:22214, name:'CUNEIFORM SIGN PI TIMES AB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12282':{ u:'12282', i:22215, name:'CUNEIFORM SIGN PI TIMES BI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12283':{ u:'12283', i:22216, name:'CUNEIFORM SIGN PI TIMES BU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12284':{ u:'12284', i:22217, name:'CUNEIFORM SIGN PI TIMES E', cat:c.Lo,   canon:k._0, block:b[247], indexed:["E"]},
			'12285':{ u:'12285', i:22218, name:'CUNEIFORM SIGN PI TIMES I', cat:c.Lo,   canon:k._0, block:b[247], indexed:["I"]},
			'12286':{ u:'12286', i:22219, name:'CUNEIFORM SIGN PI TIMES IB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12287':{ u:'12287', i:22220, name:'CUNEIFORM SIGN PI TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12288':{ u:'12288', i:22221, name:'CUNEIFORM SIGN PI TIMES U2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12289':{ u:'12289', i:22222, name:'CUNEIFORM SIGN PI CROSSING PI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12290':{ u:'12290', i:22229, name:'CUNEIFORM SIGN RAB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12291':{ u:'12291', i:22230, name:'CUNEIFORM SIGN RI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12292':{ u:'12292', i:22231, name:'CUNEIFORM SIGN RU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12293':{ u:'12293', i:22232, name:'CUNEIFORM SIGN SA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12294':{ u:'12294', i:22233, name:'CUNEIFORM SIGN SAG NUTILLU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12295':{ u:'12295', i:22234, name:'CUNEIFORM SIGN SAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12296':{ u:'12296', i:22235, name:'CUNEIFORM SIGN SAG TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12297':{ u:'12297', i:22236, name:'CUNEIFORM SIGN SAG TIMES DU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12298':{ u:'12298', i:22237, name:'CUNEIFORM SIGN SAG TIMES DUB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12299':{ u:'12299', i:22238, name:'CUNEIFORM SIGN SAG TIMES HA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12300':{ u:'12300', i:22341, name:'CUNEIFORM SIGN TIL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12301':{ u:'12301', i:22342, name:'CUNEIFORM SIGN TIR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12302':{ u:'12302', i:22343, name:'CUNEIFORM SIGN TIR TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12303':{ u:'12303', i:22344, name:'CUNEIFORM SIGN TIR OVER TIR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12304':{ u:'12304', i:22345, name:'CUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GAR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12305':{ u:'12305', i:22346, name:'CUNEIFORM SIGN TU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12306':{ u:'12306', i:22347, name:'CUNEIFORM SIGN TUG2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12307':{ u:'12307', i:22348, name:'CUNEIFORM SIGN TUK', cat:c.Lo,   canon:k._0, block:b[247]},
			'12308':{ u:'12308', i:22349, name:'CUNEIFORM SIGN TUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12309':{ u:'12309', i:22350, name:'CUNEIFORM SIGN TUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12310':{ u:'12310', i:22357, name:'CUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSED', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U","U","U","U"]},
			'12311':{ u:'12311', i:22358, name:'CUNEIFORM SIGN U2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12312':{ u:'12312', i:22359, name:'CUNEIFORM SIGN UB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12313':{ u:'12313', i:22360, name:'CUNEIFORM SIGN UD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12314':{ u:'12314', i:22361, name:'CUNEIFORM SIGN UD KUSHU2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12315':{ u:'12315', i:22362, name:'CUNEIFORM SIGN UD TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12316':{ u:'12316', i:22363, name:'CUNEIFORM SIGN UD TIMES MI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12317':{ u:'12317', i:22364, name:'CUNEIFORM SIGN UD TIMES U PLUS U PLUS U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U","U","U"]},
			'12318':{ u:'12318', i:22365, name:'CUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNU', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U","U","U"]},
			'12319':{ u:'12319', i:22366, name:'CUNEIFORM SIGN UD GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12320':{ u:'12320', i:22373, name:'CUNEIFORM SIGN UM TIMES SHA3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12321':{ u:'12321', i:22374, name:'CUNEIFORM SIGN UM TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12322':{ u:'12322', i:22375, name:'CUNEIFORM SIGN UMBIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12323':{ u:'12323', i:22376, name:'CUNEIFORM SIGN UMUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12324':{ u:'12324', i:22377, name:'CUNEIFORM SIGN UMUM TIMES KASKAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12325':{ u:'12325', i:22378, name:'CUNEIFORM SIGN UMUM TIMES PA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12326':{ u:'12326', i:22379, name:'CUNEIFORM SIGN UN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12327':{ u:'12327', i:22380, name:'CUNEIFORM SIGN UN GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12328':{ u:'12328', i:22381, name:'CUNEIFORM SIGN UR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12329':{ u:'12329', i:22382, name:'CUNEIFORM SIGN UR CROSSING UR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12330':{ u:'12330', i:22389, name:'CUNEIFORM SIGN UR2 TIMES NUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12331':{ u:'12331', i:22390, name:'CUNEIFORM SIGN UR2 TIMES U2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12332':{ u:'12332', i:22391, name:'CUNEIFORM SIGN UR2 TIMES U2 PLUS ASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12333':{ u:'12333', i:22392, name:'CUNEIFORM SIGN UR2 TIMES U2 PLUS BI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12334':{ u:'12334', i:22393, name:'CUNEIFORM SIGN UR4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12335':{ u:'12335', i:22394, name:'CUNEIFORM SIGN URI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12336':{ u:'12336', i:22395, name:'CUNEIFORM SIGN URI3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12337':{ u:'12337', i:22396, name:'CUNEIFORM SIGN URU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12338':{ u:'12338', i:22397, name:'CUNEIFORM SIGN URU TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12339':{ u:'12339', i:22398, name:'CUNEIFORM SIGN URU TIMES ASHGAB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12340':{ u:'12340', i:22405, name:'CUNEIFORM SIGN URU TIMES GU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12341':{ u:'12341', i:22406, name:'CUNEIFORM SIGN URU TIMES HA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12342':{ u:'12342', i:22407, name:'CUNEIFORM SIGN URU TIMES IGI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12343':{ u:'12343', i:22408, name:'CUNEIFORM SIGN URU TIMES IM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12344':{ u:'12344', i:22409, name:'CUNEIFORM SIGN URU TIMES ISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12345':{ u:'12345', i:22410, name:'CUNEIFORM SIGN URU TIMES KI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12346':{ u:'12346', i:22411, name:'CUNEIFORM SIGN URU TIMES LUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12347':{ u:'12347', i:22412, name:'CUNEIFORM SIGN URU TIMES MIN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12348':{ u:'12348', i:22413, name:'CUNEIFORM SIGN URU TIMES PA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12349':{ u:'12349', i:22414, name:'CUNEIFORM SIGN URU TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12350':{ u:'12350', i:22421, name:'CUNEIFORM SIGN URUDA TIMES U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U"]},
			'12351':{ u:'12351', i:22422, name:'CUNEIFORM SIGN USH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12352':{ u:'12352', i:22423, name:'CUNEIFORM SIGN USH TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12353':{ u:'12353', i:22424, name:'CUNEIFORM SIGN USH TIMES KU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12354':{ u:'12354', i:22425, name:'CUNEIFORM SIGN USH TIMES KUR', cat:c.Lo,   canon:k._0, block:b[247]},
			'12355':{ u:'12355', i:22426, name:'CUNEIFORM SIGN USH TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[247]},
			'12356':{ u:'12356', i:22427, name:'CUNEIFORM SIGN USHX', cat:c.Lo,   canon:k._0, block:b[247]},
			'12357':{ u:'12357', i:22428, name:'CUNEIFORM SIGN USH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12358':{ u:'12358', i:22429, name:'CUNEIFORM SIGN USHUMX', cat:c.Lo,   canon:k._0, block:b[247]},
			'12359':{ u:'12359', i:22430, name:'CUNEIFORM SIGN UTUKI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12360':{ u:'12360', i:22437, name:'CUNEIFORM SIGN ZAG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12361':{ u:'12361', i:22438, name:'CUNEIFORM SIGN ZAMX', cat:c.Lo,   canon:k._0, block:b[247]},
			'12362':{ u:'12362', i:22439, name:'CUNEIFORM SIGN ZE2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12363':{ u:'12363', i:22440, name:'CUNEIFORM SIGN ZI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12364':{ u:'12364', i:22441, name:'CUNEIFORM SIGN ZI OVER ZI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12365':{ u:'12365', i:22442, name:'CUNEIFORM SIGN ZI3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12366':{ u:'12366', i:22443, name:'CUNEIFORM SIGN ZIB', cat:c.Lo,   canon:k._0, block:b[247]},
			'12367':{ u:'12367', i:22444, name:'CUNEIFORM SIGN ZIB KABA TENU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12368':{ u:'12368', i:22445, name:'CUNEIFORM SIGN ZIG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12369':{ u:'12369', i:22446, name:'CUNEIFORM SIGN ZIZ2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12370':{ u:'12370', i:22453, name:'CUNEIFORM SIGN AB TIMES NUN', cat:c.Lo,   canon:k._0, block:b[247]},
			'12371':{ u:'12371', i:22454, name:'CUNEIFORM SIGN AB2 TIMES A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12372':{ u:'12372', i:22455, name:'CUNEIFORM SIGN AMAR TIMES KUG', cat:c.Lo,   canon:k._0, block:b[247]},
			'12373':{ u:'12373', i:22456, name:'CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS MASH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12374':{ u:'12374', i:22457, name:'CUNEIFORM SIGN DAG3', cat:c.Lo,   canon:k._0, block:b[247]},
			'12375':{ u:'12375', i:22458, name:'CUNEIFORM SIGN DISH PLUS SHU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12376':{ u:'12376', i:22459, name:'CUNEIFORM SIGN DUB TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12377':{ u:'12377', i:22460, name:'CUNEIFORM SIGN EZEN TIMES GUD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12378':{ u:'12378', i:22461, name:'CUNEIFORM SIGN EZEN TIMES SHE', cat:c.Lo,   canon:k._0, block:b[247]},
			'12379':{ u:'12379', i:22462, name:'CUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS A', cat:c.Lo,   canon:k._0, block:b[247], indexed:["A"]},
			'12380':{ u:'12380', i:22469, name:'CUNEIFORM SIGN KA TIMES GISH', cat:c.Lo,   canon:k._0, block:b[247]},
			'12381':{ u:'12381', i:22470, name:'CUNEIFORM SIGN KA TIMES GUD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12382':{ u:'12382', i:22471, name:'CUNEIFORM SIGN KA TIMES HI TIMES ASH2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12383':{ u:'12383', i:22472, name:'CUNEIFORM SIGN KA TIMES LUM', cat:c.Lo,   canon:k._0, block:b[247]},
			'12384':{ u:'12384', i:22473, name:'CUNEIFORM SIGN KA TIMES PA', cat:c.Lo,   canon:k._0, block:b[247]},
			'12385':{ u:'12385', i:22474, name:'CUNEIFORM SIGN KA TIMES SHUL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12386':{ u:'12386', i:22475, name:'CUNEIFORM SIGN KA TIMES TU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12387':{ u:'12387', i:22476, name:'CUNEIFORM SIGN KA TIMES UR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12388':{ u:'12388', i:22477, name:'CUNEIFORM SIGN LAGAB TIMES GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12389':{ u:'12389', i:22478, name:'CUNEIFORM SIGN LU2 SHESHIG TIMES BAD', cat:c.Lo,   canon:k._0, block:b[247]},
			'12390':{ u:'12390', i:22485, name:'CUNEIFORM SIGN NIN9', cat:c.Lo,   canon:k._0, block:b[247]},
			'12391':{ u:'12391', i:22486, name:'CUNEIFORM SIGN NINDA2 TIMES BAL', cat:c.Lo,   canon:k._0, block:b[247]},
			'12392':{ u:'12392', i:22487, name:'CUNEIFORM SIGN NINDA2 TIMES GI', cat:c.Lo,   canon:k._0, block:b[247]},
			'12393':{ u:'12393', i:22488, name:'CUNEIFORM SIGN NU11 ROTATED NINETY DEGREES', cat:c.Lo,   canon:k._0, block:b[247]},
			'12394':{ u:'12394', i:22489, name:'CUNEIFORM SIGN PESH2 ASTERISK', cat:c.Lo,   canon:k._0, block:b[247]},
			'12395':{ u:'12395', i:22490, name:'CUNEIFORM SIGN PIR2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12396':{ u:'12396', i:22491, name:'CUNEIFORM SIGN SAG TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[247]},
			'12397':{ u:'12397', i:22492, name:'CUNEIFORM SIGN TI2', cat:c.Lo,   canon:k._0, block:b[247]},
			'12398':{ u:'12398', i:22493, name:'CUNEIFORM SIGN UM TIMES ME', cat:c.Lo,   canon:k._0, block:b[247]},
			'12399':{ u:'12399', i:22494, name:'CUNEIFORM SIGN U U', cat:c.Lo,   canon:k._0, block:b[247], indexed:["U","U"]},
			'12400':{ u:'12400', i:22495, name:'CUNEIFORM NUMERIC SIGN TWO ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12401':{ u:'12401', i:22496, name:'CUNEIFORM NUMERIC SIGN THREE ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12402':{ u:'12402', i:22497, name:'CUNEIFORM NUMERIC SIGN FOUR ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12403':{ u:'12403', i:22498, name:'CUNEIFORM NUMERIC SIGN FIVE ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12404':{ u:'12404', i:22499, name:'CUNEIFORM NUMERIC SIGN SIX ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12405':{ u:'12405', i:22500, name:'CUNEIFORM NUMERIC SIGN SEVEN ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12406':{ u:'12406', i:22501, name:'CUNEIFORM NUMERIC SIGN EIGHT ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12407':{ u:'12407', i:22502, name:'CUNEIFORM NUMERIC SIGN NINE ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12408':{ u:'12408', i:22503, name:'CUNEIFORM NUMERIC SIGN THREE DISH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12409':{ u:'12409', i:22504, name:'CUNEIFORM NUMERIC SIGN FOUR DISH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12410':{ u:'12410', i:22511, name:'CUNEIFORM NUMERIC SIGN FIVE U', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12411':{ u:'12411', i:22512, name:'CUNEIFORM NUMERIC SIGN SIX U', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12412':{ u:'12412', i:22513, name:'CUNEIFORM NUMERIC SIGN SEVEN U', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12413':{ u:'12413', i:22514, name:'CUNEIFORM NUMERIC SIGN EIGHT U', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12414':{ u:'12414', i:22515, name:'CUNEIFORM NUMERIC SIGN NINE U', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12415':{ u:'12415', i:22516, name:'CUNEIFORM NUMERIC SIGN ONE GESH2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12416':{ u:'12416', i:22517, name:'CUNEIFORM NUMERIC SIGN TWO GESH2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12417':{ u:'12417', i:22518, name:'CUNEIFORM NUMERIC SIGN THREE GESH2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12418':{ u:'12418', i:22519, name:'CUNEIFORM NUMERIC SIGN FOUR GESH2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12419':{ u:'12419', i:22520, name:'CUNEIFORM NUMERIC SIGN FIVE GESH2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12420':{ u:'12420', i:22527, name:'CUNEIFORM NUMERIC SIGN THREE GESHU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12421':{ u:'12421', i:22528, name:'CUNEIFORM NUMERIC SIGN FOUR GESHU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12422':{ u:'12422', i:22529, name:'CUNEIFORM NUMERIC SIGN FIVE GESHU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12423':{ u:'12423', i:22530, name:'CUNEIFORM NUMERIC SIGN TWO SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12424':{ u:'12424', i:22531, name:'CUNEIFORM NUMERIC SIGN THREE SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12425':{ u:'12425', i:22532, name:'CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORM', cat:c.Nl,   canon:k._0, block:b[248]},
			'12426':{ u:'12426', i:22533, name:'CUNEIFORM NUMERIC SIGN FOUR SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12427':{ u:'12427', i:22534, name:'CUNEIFORM NUMERIC SIGN FIVE SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12428':{ u:'12428', i:22535, name:'CUNEIFORM NUMERIC SIGN SIX SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12429':{ u:'12429', i:22536, name:'CUNEIFORM NUMERIC SIGN SEVEN SHAR2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12430':{ u:'12430', i:22543, name:'CUNEIFORM NUMERIC SIGN FOUR SHARU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12431':{ u:'12431', i:22544, name:'CUNEIFORM NUMERIC SIGN FIVE SHARU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12432':{ u:'12432', i:22545, name:'CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12433':{ u:'12433', i:22546, name:'CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MIN', cat:c.Nl,   canon:k._0, block:b[248]},
			'12434':{ u:'12434', i:22547, name:'CUNEIFORM NUMERIC SIGN ONE BURU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12435':{ u:'12435', i:22548, name:'CUNEIFORM NUMERIC SIGN TWO BURU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12436':{ u:'12436', i:22549, name:'CUNEIFORM NUMERIC SIGN THREE BURU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12437':{ u:'12437', i:22550, name:'CUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORM', cat:c.Nl,   canon:k._0, block:b[248]},
			'12438':{ u:'12438', i:22551, name:'CUNEIFORM NUMERIC SIGN FOUR BURU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12439':{ u:'12439', i:22552, name:'CUNEIFORM NUMERIC SIGN FIVE BURU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12440':{ u:'12440', i:22559, name:'CUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9', cat:c.Nl,   canon:k._0, block:b[248]},
			'12441':{ u:'12441', i:22560, name:'CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3', cat:c.Nl,   canon:k._0, block:b[248]},
			'12442':{ u:'12442', i:22561, name:'CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN A', cat:c.Nl,   canon:k._0, block:b[248], indexed:["A"]},
			'12443':{ u:'12443', i:22562, name:'CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN B', cat:c.Nl,   canon:k._0, block:b[248], indexed:["B"]},
			'12444':{ u:'12444', i:22563, name:'CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12445':{ u:'12445', i:22564, name:'CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3', cat:c.Nl,   canon:k._0, block:b[248]},
			'12446':{ u:'12446', i:22565, name:'CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU', cat:c.Nl,   canon:k._0, block:b[248]},
			'12447':{ u:'12447', i:22566, name:'CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3', cat:c.Nl,   canon:k._0, block:b[248]},
			'12448':{ u:'12448', i:22567, name:'CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4', cat:c.Nl,   canon:k._0, block:b[248]},
			'12449':{ u:'12449', i:22568, name:'CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU A', cat:c.Nl,   canon:k._0, block:b[248], indexed:["A"]},
			'12450':{ u:'12450', i:22575, name:'CUNEIFORM NUMERIC SIGN TWO BAN2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12451':{ u:'12451', i:22576, name:'CUNEIFORM NUMERIC SIGN THREE BAN2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12452':{ u:'12452', i:22577, name:'CUNEIFORM NUMERIC SIGN FOUR BAN2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12453':{ u:'12453', i:22578, name:'CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORM', cat:c.Nl,   canon:k._0, block:b[248]},
			'12454':{ u:'12454', i:22579, name:'CUNEIFORM NUMERIC SIGN FIVE BAN2', cat:c.Nl,   canon:k._0, block:b[248]},
			'12455':{ u:'12455', i:22580, name:'CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM', cat:c.Nl,   canon:k._0, block:b[248]},
			'12456':{ u:'12456', i:22581, name:'CUNEIFORM NUMERIC SIGN NIGIDAMIN', cat:c.Nl,   canon:k._0, block:b[248]},
			'12457':{ u:'12457', i:22582, name:'CUNEIFORM NUMERIC SIGN NIGIDAESH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12458':{ u:'12458', i:22583, name:'CUNEIFORM NUMERIC SIGN ONE ESHE3', cat:c.Nl,   canon:k._0, block:b[248]},
			'12459':{ u:'12459', i:22584, name:'CUNEIFORM NUMERIC SIGN TWO ESHE3', cat:c.Nl,   canon:k._0, block:b[248]},
			'12460':{ u:'12460', i:22591, name:'CUNEIFORM NUMERIC SIGN ONE QUARTER ASH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12461':{ u:'12461', i:22592, name:'CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTH', cat:c.Nl,   canon:k._0, block:b[248]},
			'12462':{ u:'12462', i:22593, name:'CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER', cat:c.Nl,   canon:k._0, block:b[248]},
			'12463':{ u:'12463', i:22594, name:'CUNEIFORM NUMERIC SIGN ONE QUARTER GUR', cat:c.Nl,   canon:k._0, block:b[248]},
			'12464':{ u:'12464', i:22595, name:'CUNEIFORM NUMERIC SIGN ONE HALF GUR', cat:c.Nl,   canon:k._0, block:b[248]},
			'12465':{ u:'12465', i:22596, name:'CUNEIFORM NUMERIC SIGN ELAMITE ONE THIRD', cat:c.Nl,   canon:k._0, block:b[248]},
			'12466':{ u:'12466', i:22597, name:'CUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDS', cat:c.Nl,   canon:k._0, block:b[248]},
			'12467':{ u:'12467', i:22598, name:'CUNEIFORM NUMERIC SIGN ELAMITE FORTY', cat:c.Nl,   canon:k._0, block:b[248]},
			'12468':{ u:'12468', i:22599, name:'CUNEIFORM NUMERIC SIGN ELAMITE FIFTY', cat:c.Nl,   canon:k._0, block:b[248]},
			'12469':{ u:'12469', i:22600, name:'CUNEIFORM NUMERIC SIGN FOUR U VARIANT FORM', cat:c.Nl,   canon:k._0, block:b[248], indexed:["U"]},
			'12470':{ u:'12470', i:22606, name:'CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER', cat:c.Po,   canon:k._0, block:b[248]},
			'12471':{ u:'12471', i:22607, name:'CUNEIFORM PUNCTUATION SIGN VERTICAL COLON', cat:c.Po,   canon:k._0, block:b[248]},
			'12472':{ u:'12472', i:22608, name:'CUNEIFORM PUNCTUATION SIGN DIAGONAL COLON', cat:c.Po,   canon:k._0, block:b[248]},
			'12473':{ u:'12473', i:22609, name:'CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON', cat:c.Po,   canon:k._0, block:b[248]},
			'12474':{ u:'12474', i:22610, name:'CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLON', cat:c.Po,   canon:k._0, block:b[248]},
			'12480':{ u:'12480', i:22611, name:'CUNEIFORM SIGN AB TIMES NUN TENU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12481':{ u:'12481', i:22612, name:'CUNEIFORM SIGN AB TIMES SHU2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12482':{ u:'12482', i:22613, name:'CUNEIFORM SIGN AD TIMES ESH2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12483':{ u:'12483', i:22614, name:'CUNEIFORM SIGN BAD TIMES DISH TENU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12484':{ u:'12484', i:22615, name:'CUNEIFORM SIGN BAHAR2 TIMES AB2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12485':{ u:'12485', i:22616, name:'CUNEIFORM SIGN BAHAR2 TIMES NI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12486':{ u:'12486', i:22617, name:'CUNEIFORM SIGN BAHAR2 TIMES ZA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12487':{ u:'12487', i:22618, name:'CUNEIFORM SIGN BU OVER BU TIMES NA2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12488':{ u:'12488', i:22619, name:'CUNEIFORM SIGN DA TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[249]},
			'12489':{ u:'12489', i:22620, name:'CUNEIFORM SIGN DAG TIMES KUR', cat:c.Lo,   canon:k._0, block:b[249]},
			'12490':{ u:'12490', i:22627, name:'CUNEIFORM SIGN DUG TIMES DIN', cat:c.Lo,   canon:k._0, block:b[249]},
			'12491':{ u:'12491', i:22628, name:'CUNEIFORM SIGN DUG TIMES DUN', cat:c.Lo,   canon:k._0, block:b[249]},
			'12492':{ u:'12492', i:22629, name:'CUNEIFORM SIGN DUG TIMES ERIN2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12493':{ u:'12493', i:22630, name:'CUNEIFORM SIGN DUG TIMES GA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12494':{ u:'12494', i:22631, name:'CUNEIFORM SIGN DUG TIMES GI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12495':{ u:'12495', i:22632, name:'CUNEIFORM SIGN DUG TIMES GIR2 GUNU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12496':{ u:'12496', i:22633, name:'CUNEIFORM SIGN DUG TIMES GISH', cat:c.Lo,   canon:k._0, block:b[249]},
			'12497':{ u:'12497', i:22634, name:'CUNEIFORM SIGN DUG TIMES HA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12498':{ u:'12498', i:22635, name:'CUNEIFORM SIGN DUG TIMES HI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12499':{ u:'12499', i:22636, name:'CUNEIFORM SIGN DUG TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12500':{ u:'12500', i:22739, name:'CUNEIFORM SIGN LAK-608', cat:c.Lo,   canon:k._0, block:b[249]},
			'12501':{ u:'12501', i:22740, name:'CUNEIFORM SIGN LAK-617', cat:c.Lo,   canon:k._0, block:b[249]},
			'12502':{ u:'12502', i:22741, name:'CUNEIFORM SIGN LAK-617 TIMES ASH', cat:c.Lo,   canon:k._0, block:b[249]},
			'12503':{ u:'12503', i:22742, name:'CUNEIFORM SIGN LAK-617 TIMES BAD', cat:c.Lo,   canon:k._0, block:b[249]},
			'12504':{ u:'12504', i:22743, name:'CUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12505':{ u:'12505', i:22744, name:'CUNEIFORM SIGN LAK-617 TIMES KU3', cat:c.Lo,   canon:k._0, block:b[249]},
			'12506':{ u:'12506', i:22745, name:'CUNEIFORM SIGN LAK-617 TIMES LA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12507':{ u:'12507', i:22746, name:'CUNEIFORM SIGN LAK-617 TIMES TAR', cat:c.Lo,   canon:k._0, block:b[249]},
			'12508':{ u:'12508', i:22747, name:'CUNEIFORM SIGN LAK-617 TIMES TE', cat:c.Lo,   canon:k._0, block:b[249]},
			'12509':{ u:'12509', i:22748, name:'CUNEIFORM SIGN LAK-617 TIMES U2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12510':{ u:'12510', i:22755, name:'CUNEIFORM SIGN LAK-648 TIMES IGI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12511':{ u:'12511', i:22756, name:'CUNEIFORM SIGN LAK-648 TIMES IGI GUNU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12512':{ u:'12512', i:22757, name:'CUNEIFORM SIGN LAK-648 TIMES NI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12513':{ u:'12513', i:22758, name:'CUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3', cat:c.Lo,   canon:k._0, block:b[249]},
			'12514':{ u:'12514', i:22759, name:'CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12515':{ u:'12515', i:22760, name:'CUNEIFORM SIGN LAK-648 TIMES UD', cat:c.Lo,   canon:k._0, block:b[249]},
			'12516':{ u:'12516', i:22761, name:'CUNEIFORM SIGN LAK-648 TIMES URUDA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12517':{ u:'12517', i:22762, name:'CUNEIFORM SIGN LAK-724', cat:c.Lo,   canon:k._0, block:b[249]},
			'12518':{ u:'12518', i:22763, name:'CUNEIFORM SIGN LAK-749', cat:c.Lo,   canon:k._0, block:b[249]},
			'12519':{ u:'12519', i:22764, name:'CUNEIFORM SIGN LU2 GUNU TIMES ASH', cat:c.Lo,   canon:k._0, block:b[249]},
			'12520':{ u:'12520', i:22771, name:'CUNEIFORM SIGN MUSH OVER MUSH TIMES GA', cat:c.Lo,   canon:k._0, block:b[249]},
			'12521':{ u:'12521', i:22772, name:'CUNEIFORM SIGN MUSH OVER MUSH TIMES KAK', cat:c.Lo,   canon:k._0, block:b[249]},
			'12522':{ u:'12522', i:22773, name:'CUNEIFORM SIGN NINDA2 TIMES DIM GUNU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12523':{ u:'12523', i:22774, name:'CUNEIFORM SIGN NINDA2 TIMES GISH', cat:c.Lo,   canon:k._0, block:b[249]},
			'12524':{ u:'12524', i:22775, name:'CUNEIFORM SIGN NINDA2 TIMES GUL', cat:c.Lo,   canon:k._0, block:b[249]},
			'12525':{ u:'12525', i:22776, name:'CUNEIFORM SIGN NINDA2 TIMES HI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12526':{ u:'12526', i:22777, name:'CUNEIFORM SIGN NINDA2 TIMES KESH2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12527':{ u:'12527', i:22778, name:'CUNEIFORM SIGN NINDA2 TIMES LAK-050', cat:c.Lo,   canon:k._0, block:b[249]},
			'12528':{ u:'12528', i:22779, name:'CUNEIFORM SIGN NINDA2 TIMES MASH', cat:c.Lo,   canon:k._0, block:b[249]},
			'12529':{ u:'12529', i:22780, name:'CUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAP', cat:c.Lo,   canon:k._0, block:b[249]},
			'12530':{ u:'12530', i:22787, name:'CUNEIFORM SIGN SAG TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[249]},
			'12531':{ u:'12531', i:22788, name:'CUNEIFORM SIGN SHA6 TENU', cat:c.Lo,   canon:k._0, block:b[249]},
			'12532':{ u:'12532', i:22789, name:'CUNEIFORM SIGN SHE OVER SHE', cat:c.Lo,   canon:k._0, block:b[249]},
			'12533':{ u:'12533', i:22790, name:'CUNEIFORM SIGN SHE PLUS HUB2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12534':{ u:'12534', i:22791, name:'CUNEIFORM SIGN SHE PLUS NAM2', cat:c.Lo,   canon:k._0, block:b[249]},
			'12535':{ u:'12535', i:22792, name:'CUNEIFORM SIGN SHE PLUS SAR', cat:c.Lo,   canon:k._0, block:b[249]},
			'12536':{ u:'12536', i:22793, name:'CUNEIFORM SIGN SHU2 PLUS DUG TIMES NI', cat:c.Lo,   canon:k._0, block:b[249]},
			'12537':{ u:'12537', i:22794, name:'CUNEIFORM SIGN SHU2 PLUS E2 TIMES AN', cat:c.Lo,   canon:k._0, block:b[249]},
			'12538':{ u:'12538', i:22795, name:'CUNEIFORM SIGN SI TIMES TAK4', cat:c.Lo,   canon:k._0, block:b[249]},
			'12539':{ u:'12539', i:22796, name:'CUNEIFORM SIGN TAK4 PLUS SAG', cat:c.Lo,   canon:k._0, block:b[249]},
			'12540':{ u:'12540', i:22803, name:'CUNEIFORM SIGN URU TIMES LU3', cat:c.Lo,   canon:k._0, block:b[249]},
			'12541':{ u:'12541', i:22804, name:'CUNEIFORM SIGN ZA7', cat:c.Lo,   canon:k._0, block:b[249]},
			'12542':{ u:'12542', i:22805, name:'CUNEIFORM SIGN ZU OVER ZU PLUS SAR', cat:c.Lo,   canon:k._0, block:b[249]},
			'12543':{ u:'12543', i:22806, name:'CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU', cat:c.Lo,   canon:k._0, block:b[249]},
			'13000':{ u:'13000', i:22906, name:'EGYPTIAN HIEROGLYPH A001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13001':{ u:'13001', i:22907, name:'EGYPTIAN HIEROGLYPH A002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13002':{ u:'13002', i:22908, name:'EGYPTIAN HIEROGLYPH A003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13003':{ u:'13003', i:22909, name:'EGYPTIAN HIEROGLYPH A004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13004':{ u:'13004', i:22910, name:'EGYPTIAN HIEROGLYPH A005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13005':{ u:'13005', i:22911, name:'EGYPTIAN HIEROGLYPH A005A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13006':{ u:'13006', i:22912, name:'EGYPTIAN HIEROGLYPH A006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13007':{ u:'13007', i:22913, name:'EGYPTIAN HIEROGLYPH A006A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13008':{ u:'13008', i:22914, name:'EGYPTIAN HIEROGLYPH A006B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13009':{ u:'13009', i:22915, name:'EGYPTIAN HIEROGLYPH A007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13010':{ u:'13010', i:22922, name:'EGYPTIAN HIEROGLYPH A014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13011':{ u:'13011', i:22923, name:'EGYPTIAN HIEROGLYPH A014A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13012':{ u:'13012', i:22924, name:'EGYPTIAN HIEROGLYPH A015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13013':{ u:'13013', i:22925, name:'EGYPTIAN HIEROGLYPH A016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13014':{ u:'13014', i:22926, name:'EGYPTIAN HIEROGLYPH A017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13015':{ u:'13015', i:22927, name:'EGYPTIAN HIEROGLYPH A017A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13016':{ u:'13016', i:22928, name:'EGYPTIAN HIEROGLYPH A018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13017':{ u:'13017', i:22929, name:'EGYPTIAN HIEROGLYPH A019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13018':{ u:'13018', i:22930, name:'EGYPTIAN HIEROGLYPH A020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13019':{ u:'13019', i:22931, name:'EGYPTIAN HIEROGLYPH A021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13020':{ u:'13020', i:22938, name:'EGYPTIAN HIEROGLYPH A028', cat:c.Lo,   canon:k._0, block:b[251]},
			'13021':{ u:'13021', i:22939, name:'EGYPTIAN HIEROGLYPH A029', cat:c.Lo,   canon:k._0, block:b[251]},
			'13022':{ u:'13022', i:22940, name:'EGYPTIAN HIEROGLYPH A030', cat:c.Lo,   canon:k._0, block:b[251]},
			'13023':{ u:'13023', i:22941, name:'EGYPTIAN HIEROGLYPH A031', cat:c.Lo,   canon:k._0, block:b[251]},
			'13024':{ u:'13024', i:22942, name:'EGYPTIAN HIEROGLYPH A032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13025':{ u:'13025', i:22943, name:'EGYPTIAN HIEROGLYPH A032A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13026':{ u:'13026', i:22944, name:'EGYPTIAN HIEROGLYPH A033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13027':{ u:'13027', i:22945, name:'EGYPTIAN HIEROGLYPH A034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13028':{ u:'13028', i:22946, name:'EGYPTIAN HIEROGLYPH A035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13029':{ u:'13029', i:22947, name:'EGYPTIAN HIEROGLYPH A036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13030':{ u:'13030', i:22954, name:'EGYPTIAN HIEROGLYPH A042', cat:c.Lo,   canon:k._0, block:b[251]},
			'13031':{ u:'13031', i:22955, name:'EGYPTIAN HIEROGLYPH A042A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13032':{ u:'13032', i:22956, name:'EGYPTIAN HIEROGLYPH A043', cat:c.Lo,   canon:k._0, block:b[251]},
			'13033':{ u:'13033', i:22957, name:'EGYPTIAN HIEROGLYPH A043A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13034':{ u:'13034', i:22958, name:'EGYPTIAN HIEROGLYPH A044', cat:c.Lo,   canon:k._0, block:b[251]},
			'13035':{ u:'13035', i:22959, name:'EGYPTIAN HIEROGLYPH A045', cat:c.Lo,   canon:k._0, block:b[251]},
			'13036':{ u:'13036', i:22960, name:'EGYPTIAN HIEROGLYPH A045A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13037':{ u:'13037', i:22961, name:'EGYPTIAN HIEROGLYPH A046', cat:c.Lo,   canon:k._0, block:b[251]},
			'13038':{ u:'13038', i:22962, name:'EGYPTIAN HIEROGLYPH A047', cat:c.Lo,   canon:k._0, block:b[251]},
			'13039':{ u:'13039', i:22963, name:'EGYPTIAN HIEROGLYPH A048', cat:c.Lo,   canon:k._0, block:b[251]},
			'13040':{ u:'13040', i:22970, name:'EGYPTIAN HIEROGLYPH A055', cat:c.Lo,   canon:k._0, block:b[251]},
			'13041':{ u:'13041', i:22971, name:'EGYPTIAN HIEROGLYPH A056', cat:c.Lo,   canon:k._0, block:b[251]},
			'13042':{ u:'13042', i:22972, name:'EGYPTIAN HIEROGLYPH A057', cat:c.Lo,   canon:k._0, block:b[251]},
			'13043':{ u:'13043', i:22973, name:'EGYPTIAN HIEROGLYPH A058', cat:c.Lo,   canon:k._0, block:b[251]},
			'13044':{ u:'13044', i:22974, name:'EGYPTIAN HIEROGLYPH A059', cat:c.Lo,   canon:k._0, block:b[251]},
			'13045':{ u:'13045', i:22975, name:'EGYPTIAN HIEROGLYPH A060', cat:c.Lo,   canon:k._0, block:b[251]},
			'13046':{ u:'13046', i:22976, name:'EGYPTIAN HIEROGLYPH A061', cat:c.Lo,   canon:k._0, block:b[251]},
			'13047':{ u:'13047', i:22977, name:'EGYPTIAN HIEROGLYPH A062', cat:c.Lo,   canon:k._0, block:b[251]},
			'13048':{ u:'13048', i:22978, name:'EGYPTIAN HIEROGLYPH A063', cat:c.Lo,   canon:k._0, block:b[251]},
			'13049':{ u:'13049', i:22979, name:'EGYPTIAN HIEROGLYPH A064', cat:c.Lo,   canon:k._0, block:b[251]},
			'13050':{ u:'13050', i:22986, name:'EGYPTIAN HIEROGLYPH B001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13051':{ u:'13051', i:22987, name:'EGYPTIAN HIEROGLYPH B002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13052':{ u:'13052', i:22988, name:'EGYPTIAN HIEROGLYPH B003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13053':{ u:'13053', i:22989, name:'EGYPTIAN HIEROGLYPH B004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13054':{ u:'13054', i:22990, name:'EGYPTIAN HIEROGLYPH B005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13055':{ u:'13055', i:22991, name:'EGYPTIAN HIEROGLYPH B005A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13056':{ u:'13056', i:22992, name:'EGYPTIAN HIEROGLYPH B006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13057':{ u:'13057', i:22993, name:'EGYPTIAN HIEROGLYPH B007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13058':{ u:'13058', i:22994, name:'EGYPTIAN HIEROGLYPH B008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13059':{ u:'13059', i:22995, name:'EGYPTIAN HIEROGLYPH B009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13060':{ u:'13060', i:23002, name:'EGYPTIAN HIEROGLYPH C004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13061':{ u:'13061', i:23003, name:'EGYPTIAN HIEROGLYPH C005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13062':{ u:'13062', i:23004, name:'EGYPTIAN HIEROGLYPH C006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13063':{ u:'13063', i:23005, name:'EGYPTIAN HIEROGLYPH C007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13064':{ u:'13064', i:23006, name:'EGYPTIAN HIEROGLYPH C008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13065':{ u:'13065', i:23007, name:'EGYPTIAN HIEROGLYPH C009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13066':{ u:'13066', i:23008, name:'EGYPTIAN HIEROGLYPH C010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13067':{ u:'13067', i:23009, name:'EGYPTIAN HIEROGLYPH C010A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13068':{ u:'13068', i:23010, name:'EGYPTIAN HIEROGLYPH C011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13069':{ u:'13069', i:23011, name:'EGYPTIAN HIEROGLYPH C012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13070':{ u:'13070', i:23018, name:'EGYPTIAN HIEROGLYPH C019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13071':{ u:'13071', i:23019, name:'EGYPTIAN HIEROGLYPH C020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13072':{ u:'13072', i:23020, name:'EGYPTIAN HIEROGLYPH C021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13073':{ u:'13073', i:23021, name:'EGYPTIAN HIEROGLYPH C022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13074':{ u:'13074', i:23022, name:'EGYPTIAN HIEROGLYPH C023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13075':{ u:'13075', i:23023, name:'EGYPTIAN HIEROGLYPH C024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13076':{ u:'13076', i:23024, name:'EGYPTIAN HIEROGLYPH D001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13077':{ u:'13077', i:23025, name:'EGYPTIAN HIEROGLYPH D002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13078':{ u:'13078', i:23026, name:'EGYPTIAN HIEROGLYPH D003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13079':{ u:'13079', i:23027, name:'EGYPTIAN HIEROGLYPH D004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13080':{ u:'13080', i:23034, name:'EGYPTIAN HIEROGLYPH D010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13081':{ u:'13081', i:23035, name:'EGYPTIAN HIEROGLYPH D011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13082':{ u:'13082', i:23036, name:'EGYPTIAN HIEROGLYPH D012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13083':{ u:'13083', i:23037, name:'EGYPTIAN HIEROGLYPH D013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13084':{ u:'13084', i:23038, name:'EGYPTIAN HIEROGLYPH D014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13085':{ u:'13085', i:23039, name:'EGYPTIAN HIEROGLYPH D015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13086':{ u:'13086', i:23040, name:'EGYPTIAN HIEROGLYPH D016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13087':{ u:'13087', i:23041, name:'EGYPTIAN HIEROGLYPH D017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13088':{ u:'13088', i:23042, name:'EGYPTIAN HIEROGLYPH D018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13089':{ u:'13089', i:23043, name:'EGYPTIAN HIEROGLYPH D019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13090':{ u:'13090', i:23050, name:'EGYPTIAN HIEROGLYPH D026', cat:c.Lo,   canon:k._0, block:b[251]},
			'13091':{ u:'13091', i:23051, name:'EGYPTIAN HIEROGLYPH D027', cat:c.Lo,   canon:k._0, block:b[251]},
			'13092':{ u:'13092', i:23052, name:'EGYPTIAN HIEROGLYPH D027A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13093':{ u:'13093', i:23053, name:'EGYPTIAN HIEROGLYPH D028', cat:c.Lo,   canon:k._0, block:b[251]},
			'13094':{ u:'13094', i:23054, name:'EGYPTIAN HIEROGLYPH D029', cat:c.Lo,   canon:k._0, block:b[251]},
			'13095':{ u:'13095', i:23055, name:'EGYPTIAN HIEROGLYPH D030', cat:c.Lo,   canon:k._0, block:b[251]},
			'13096':{ u:'13096', i:23056, name:'EGYPTIAN HIEROGLYPH D031', cat:c.Lo,   canon:k._0, block:b[251]},
			'13097':{ u:'13097', i:23057, name:'EGYPTIAN HIEROGLYPH D031A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13098':{ u:'13098', i:23058, name:'EGYPTIAN HIEROGLYPH D032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13099':{ u:'13099', i:23059, name:'EGYPTIAN HIEROGLYPH D033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13100':{ u:'13100', i:23162, name:'EGYPTIAN HIEROGLYPH F002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13101':{ u:'13101', i:23163, name:'EGYPTIAN HIEROGLYPH F003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13102':{ u:'13102', i:23164, name:'EGYPTIAN HIEROGLYPH F004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13103':{ u:'13103', i:23165, name:'EGYPTIAN HIEROGLYPH F005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13104':{ u:'13104', i:23166, name:'EGYPTIAN HIEROGLYPH F006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13105':{ u:'13105', i:23167, name:'EGYPTIAN HIEROGLYPH F007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13106':{ u:'13106', i:23168, name:'EGYPTIAN HIEROGLYPH F008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13107':{ u:'13107', i:23169, name:'EGYPTIAN HIEROGLYPH F009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13108':{ u:'13108', i:23170, name:'EGYPTIAN HIEROGLYPH F010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13109':{ u:'13109', i:23171, name:'EGYPTIAN HIEROGLYPH F011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13110':{ u:'13110', i:23178, name:'EGYPTIAN HIEROGLYPH F017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13111':{ u:'13111', i:23179, name:'EGYPTIAN HIEROGLYPH F018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13112':{ u:'13112', i:23180, name:'EGYPTIAN HIEROGLYPH F019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13113':{ u:'13113', i:23181, name:'EGYPTIAN HIEROGLYPH F020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13114':{ u:'13114', i:23182, name:'EGYPTIAN HIEROGLYPH F021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13115':{ u:'13115', i:23183, name:'EGYPTIAN HIEROGLYPH F021A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13116':{ u:'13116', i:23184, name:'EGYPTIAN HIEROGLYPH F022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13117':{ u:'13117', i:23185, name:'EGYPTIAN HIEROGLYPH F023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13118':{ u:'13118', i:23186, name:'EGYPTIAN HIEROGLYPH F024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13119':{ u:'13119', i:23187, name:'EGYPTIAN HIEROGLYPH F025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13120':{ u:'13120', i:23194, name:'EGYPTIAN HIEROGLYPH F031A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13121':{ u:'13121', i:23195, name:'EGYPTIAN HIEROGLYPH F032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13122':{ u:'13122', i:23196, name:'EGYPTIAN HIEROGLYPH F033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13123':{ u:'13123', i:23197, name:'EGYPTIAN HIEROGLYPH F034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13124':{ u:'13124', i:23198, name:'EGYPTIAN HIEROGLYPH F035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13125':{ u:'13125', i:23199, name:'EGYPTIAN HIEROGLYPH F036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13126':{ u:'13126', i:23200, name:'EGYPTIAN HIEROGLYPH F037', cat:c.Lo,   canon:k._0, block:b[251]},
			'13127':{ u:'13127', i:23201, name:'EGYPTIAN HIEROGLYPH F037A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13128':{ u:'13128', i:23202, name:'EGYPTIAN HIEROGLYPH F038', cat:c.Lo,   canon:k._0, block:b[251]},
			'13129':{ u:'13129', i:23203, name:'EGYPTIAN HIEROGLYPH F038A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13130':{ u:'13130', i:23210, name:'EGYPTIAN HIEROGLYPH F045', cat:c.Lo,   canon:k._0, block:b[251]},
			'13131':{ u:'13131', i:23211, name:'EGYPTIAN HIEROGLYPH F045A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13132':{ u:'13132', i:23212, name:'EGYPTIAN HIEROGLYPH F046', cat:c.Lo,   canon:k._0, block:b[251]},
			'13133':{ u:'13133', i:23213, name:'EGYPTIAN HIEROGLYPH F046A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13134':{ u:'13134', i:23214, name:'EGYPTIAN HIEROGLYPH F047', cat:c.Lo,   canon:k._0, block:b[251]},
			'13135':{ u:'13135', i:23215, name:'EGYPTIAN HIEROGLYPH F047A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13136':{ u:'13136', i:23216, name:'EGYPTIAN HIEROGLYPH F048', cat:c.Lo,   canon:k._0, block:b[251]},
			'13137':{ u:'13137', i:23217, name:'EGYPTIAN HIEROGLYPH F049', cat:c.Lo,   canon:k._0, block:b[251]},
			'13138':{ u:'13138', i:23218, name:'EGYPTIAN HIEROGLYPH F050', cat:c.Lo,   canon:k._0, block:b[251]},
			'13139':{ u:'13139', i:23219, name:'EGYPTIAN HIEROGLYPH F051', cat:c.Lo,   canon:k._0, block:b[251]},
			'13140':{ u:'13140', i:23226, name:'EGYPTIAN HIEROGLYPH G002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13141':{ u:'13141', i:23227, name:'EGYPTIAN HIEROGLYPH G003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13142':{ u:'13142', i:23228, name:'EGYPTIAN HIEROGLYPH G004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13143':{ u:'13143', i:23229, name:'EGYPTIAN HIEROGLYPH G005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13144':{ u:'13144', i:23230, name:'EGYPTIAN HIEROGLYPH G006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13145':{ u:'13145', i:23231, name:'EGYPTIAN HIEROGLYPH G006A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13146':{ u:'13146', i:23232, name:'EGYPTIAN HIEROGLYPH G007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13147':{ u:'13147', i:23233, name:'EGYPTIAN HIEROGLYPH G007A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13148':{ u:'13148', i:23234, name:'EGYPTIAN HIEROGLYPH G007B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13149':{ u:'13149', i:23235, name:'EGYPTIAN HIEROGLYPH G008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13150':{ u:'13150', i:23242, name:'EGYPTIAN HIEROGLYPH G014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13151':{ u:'13151', i:23243, name:'EGYPTIAN HIEROGLYPH G015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13152':{ u:'13152', i:23244, name:'EGYPTIAN HIEROGLYPH G016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13153':{ u:'13153', i:23245, name:'EGYPTIAN HIEROGLYPH G017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13154':{ u:'13154', i:23246, name:'EGYPTIAN HIEROGLYPH G018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13155':{ u:'13155', i:23247, name:'EGYPTIAN HIEROGLYPH G019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13156':{ u:'13156', i:23248, name:'EGYPTIAN HIEROGLYPH G020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13157':{ u:'13157', i:23249, name:'EGYPTIAN HIEROGLYPH G020A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13158':{ u:'13158', i:23250, name:'EGYPTIAN HIEROGLYPH G021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13159':{ u:'13159', i:23251, name:'EGYPTIAN HIEROGLYPH G022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13160':{ u:'13160', i:23258, name:'EGYPTIAN HIEROGLYPH G028', cat:c.Lo,   canon:k._0, block:b[251]},
			'13161':{ u:'13161', i:23259, name:'EGYPTIAN HIEROGLYPH G029', cat:c.Lo,   canon:k._0, block:b[251]},
			'13162':{ u:'13162', i:23260, name:'EGYPTIAN HIEROGLYPH G030', cat:c.Lo,   canon:k._0, block:b[251]},
			'13163':{ u:'13163', i:23261, name:'EGYPTIAN HIEROGLYPH G031', cat:c.Lo,   canon:k._0, block:b[251]},
			'13164':{ u:'13164', i:23262, name:'EGYPTIAN HIEROGLYPH G032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13165':{ u:'13165', i:23263, name:'EGYPTIAN HIEROGLYPH G033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13166':{ u:'13166', i:23264, name:'EGYPTIAN HIEROGLYPH G034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13167':{ u:'13167', i:23265, name:'EGYPTIAN HIEROGLYPH G035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13168':{ u:'13168', i:23266, name:'EGYPTIAN HIEROGLYPH G036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13169':{ u:'13169', i:23267, name:'EGYPTIAN HIEROGLYPH G036A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13170':{ u:'13170', i:23274, name:'EGYPTIAN HIEROGLYPH G042', cat:c.Lo,   canon:k._0, block:b[251]},
			'13171':{ u:'13171', i:23275, name:'EGYPTIAN HIEROGLYPH G043', cat:c.Lo,   canon:k._0, block:b[251]},
			'13172':{ u:'13172', i:23276, name:'EGYPTIAN HIEROGLYPH G043A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13173':{ u:'13173', i:23277, name:'EGYPTIAN HIEROGLYPH G044', cat:c.Lo,   canon:k._0, block:b[251]},
			'13174':{ u:'13174', i:23278, name:'EGYPTIAN HIEROGLYPH G045', cat:c.Lo,   canon:k._0, block:b[251]},
			'13175':{ u:'13175', i:23279, name:'EGYPTIAN HIEROGLYPH G045A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13176':{ u:'13176', i:23280, name:'EGYPTIAN HIEROGLYPH G046', cat:c.Lo,   canon:k._0, block:b[251]},
			'13177':{ u:'13177', i:23281, name:'EGYPTIAN HIEROGLYPH G047', cat:c.Lo,   canon:k._0, block:b[251]},
			'13178':{ u:'13178', i:23282, name:'EGYPTIAN HIEROGLYPH G048', cat:c.Lo,   canon:k._0, block:b[251]},
			'13179':{ u:'13179', i:23283, name:'EGYPTIAN HIEROGLYPH G049', cat:c.Lo,   canon:k._0, block:b[251]},
			'13180':{ u:'13180', i:23290, name:'EGYPTIAN HIEROGLYPH H002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13181':{ u:'13181', i:23291, name:'EGYPTIAN HIEROGLYPH H003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13182':{ u:'13182', i:23292, name:'EGYPTIAN HIEROGLYPH H004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13183':{ u:'13183', i:23293, name:'EGYPTIAN HIEROGLYPH H005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13184':{ u:'13184', i:23294, name:'EGYPTIAN HIEROGLYPH H006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13185':{ u:'13185', i:23295, name:'EGYPTIAN HIEROGLYPH H006A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13186':{ u:'13186', i:23296, name:'EGYPTIAN HIEROGLYPH H007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13187':{ u:'13187', i:23297, name:'EGYPTIAN HIEROGLYPH H008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13188':{ u:'13188', i:23298, name:'EGYPTIAN HIEROGLYPH I001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13189':{ u:'13189', i:23299, name:'EGYPTIAN HIEROGLYPH I002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13190':{ u:'13190', i:23306, name:'EGYPTIAN HIEROGLYPH I008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13191':{ u:'13191', i:23307, name:'EGYPTIAN HIEROGLYPH I009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13192':{ u:'13192', i:23308, name:'EGYPTIAN HIEROGLYPH I009A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13193':{ u:'13193', i:23309, name:'EGYPTIAN HIEROGLYPH I010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13194':{ u:'13194', i:23310, name:'EGYPTIAN HIEROGLYPH I010A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13195':{ u:'13195', i:23311, name:'EGYPTIAN HIEROGLYPH I011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13196':{ u:'13196', i:23312, name:'EGYPTIAN HIEROGLYPH I011A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13197':{ u:'13197', i:23313, name:'EGYPTIAN HIEROGLYPH I012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13198':{ u:'13198', i:23314, name:'EGYPTIAN HIEROGLYPH I013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13199':{ u:'13199', i:23315, name:'EGYPTIAN HIEROGLYPH I014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13200':{ u:'13200', i:23418, name:'EGYPTIAN HIEROGLYPH N018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13201':{ u:'13201', i:23419, name:'EGYPTIAN HIEROGLYPH N018A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13202':{ u:'13202', i:23420, name:'EGYPTIAN HIEROGLYPH N018B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13203':{ u:'13203', i:23421, name:'EGYPTIAN HIEROGLYPH N019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13204':{ u:'13204', i:23422, name:'EGYPTIAN HIEROGLYPH N020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13205':{ u:'13205', i:23423, name:'EGYPTIAN HIEROGLYPH N021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13206':{ u:'13206', i:23424, name:'EGYPTIAN HIEROGLYPH N022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13207':{ u:'13207', i:23425, name:'EGYPTIAN HIEROGLYPH N023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13208':{ u:'13208', i:23426, name:'EGYPTIAN HIEROGLYPH N024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13209':{ u:'13209', i:23427, name:'EGYPTIAN HIEROGLYPH N025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13210':{ u:'13210', i:23434, name:'EGYPTIAN HIEROGLYPH N031', cat:c.Lo,   canon:k._0, block:b[251]},
			'13211':{ u:'13211', i:23435, name:'EGYPTIAN HIEROGLYPH N032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13212':{ u:'13212', i:23436, name:'EGYPTIAN HIEROGLYPH N033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13213':{ u:'13213', i:23437, name:'EGYPTIAN HIEROGLYPH N033A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13214':{ u:'13214', i:23438, name:'EGYPTIAN HIEROGLYPH N034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13215':{ u:'13215', i:23439, name:'EGYPTIAN HIEROGLYPH N034A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13216':{ u:'13216', i:23440, name:'EGYPTIAN HIEROGLYPH N035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13217':{ u:'13217', i:23441, name:'EGYPTIAN HIEROGLYPH N035A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13218':{ u:'13218', i:23442, name:'EGYPTIAN HIEROGLYPH N036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13219':{ u:'13219', i:23443, name:'EGYPTIAN HIEROGLYPH N037', cat:c.Lo,   canon:k._0, block:b[251]},
			'13220':{ u:'13220', i:23450, name:'EGYPTIAN HIEROGLYPH NL001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13221':{ u:'13221', i:23451, name:'EGYPTIAN HIEROGLYPH NL002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13222':{ u:'13222', i:23452, name:'EGYPTIAN HIEROGLYPH NL003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13223':{ u:'13223', i:23453, name:'EGYPTIAN HIEROGLYPH NL004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13224':{ u:'13224', i:23454, name:'EGYPTIAN HIEROGLYPH NL005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13225':{ u:'13225', i:23455, name:'EGYPTIAN HIEROGLYPH NL005A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13226':{ u:'13226', i:23456, name:'EGYPTIAN HIEROGLYPH NL006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13227':{ u:'13227', i:23457, name:'EGYPTIAN HIEROGLYPH NL007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13228':{ u:'13228', i:23458, name:'EGYPTIAN HIEROGLYPH NL008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13229':{ u:'13229', i:23459, name:'EGYPTIAN HIEROGLYPH NL009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13230':{ u:'13230', i:23466, name:'EGYPTIAN HIEROGLYPH NL016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13231':{ u:'13231', i:23467, name:'EGYPTIAN HIEROGLYPH NL017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13232':{ u:'13232', i:23468, name:'EGYPTIAN HIEROGLYPH NL017A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13233':{ u:'13233', i:23469, name:'EGYPTIAN HIEROGLYPH NL018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13234':{ u:'13234', i:23470, name:'EGYPTIAN HIEROGLYPH NL019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13235':{ u:'13235', i:23471, name:'EGYPTIAN HIEROGLYPH NL020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13236':{ u:'13236', i:23472, name:'EGYPTIAN HIEROGLYPH NU001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13237':{ u:'13237', i:23473, name:'EGYPTIAN HIEROGLYPH NU002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13238':{ u:'13238', i:23474, name:'EGYPTIAN HIEROGLYPH NU003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13239':{ u:'13239', i:23475, name:'EGYPTIAN HIEROGLYPH NU004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13240':{ u:'13240', i:23482, name:'EGYPTIAN HIEROGLYPH NU010A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13241':{ u:'13241', i:23483, name:'EGYPTIAN HIEROGLYPH NU011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13242':{ u:'13242', i:23484, name:'EGYPTIAN HIEROGLYPH NU011A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13243':{ u:'13243', i:23485, name:'EGYPTIAN HIEROGLYPH NU012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13244':{ u:'13244', i:23486, name:'EGYPTIAN HIEROGLYPH NU013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13245':{ u:'13245', i:23487, name:'EGYPTIAN HIEROGLYPH NU014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13246':{ u:'13246', i:23488, name:'EGYPTIAN HIEROGLYPH NU015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13247':{ u:'13247', i:23489, name:'EGYPTIAN HIEROGLYPH NU016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13248':{ u:'13248', i:23490, name:'EGYPTIAN HIEROGLYPH NU017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13249':{ u:'13249', i:23491, name:'EGYPTIAN HIEROGLYPH NU018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13250':{ u:'13250', i:23498, name:'EGYPTIAN HIEROGLYPH O001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13251':{ u:'13251', i:23499, name:'EGYPTIAN HIEROGLYPH O001A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13252':{ u:'13252', i:23500, name:'EGYPTIAN HIEROGLYPH O002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13253':{ u:'13253', i:23501, name:'EGYPTIAN HIEROGLYPH O003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13254':{ u:'13254', i:23502, name:'EGYPTIAN HIEROGLYPH O004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13255':{ u:'13255', i:23503, name:'EGYPTIAN HIEROGLYPH O005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13256':{ u:'13256', i:23504, name:'EGYPTIAN HIEROGLYPH O005A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13257':{ u:'13257', i:23505, name:'EGYPTIAN HIEROGLYPH O006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13258':{ u:'13258', i:23506, name:'EGYPTIAN HIEROGLYPH O006A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13259':{ u:'13259', i:23507, name:'EGYPTIAN HIEROGLYPH O006B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13260':{ u:'13260', i:23514, name:'EGYPTIAN HIEROGLYPH O009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13261':{ u:'13261', i:23515, name:'EGYPTIAN HIEROGLYPH O010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13262':{ u:'13262', i:23516, name:'EGYPTIAN HIEROGLYPH O010A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13263':{ u:'13263', i:23517, name:'EGYPTIAN HIEROGLYPH O010B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13264':{ u:'13264', i:23518, name:'EGYPTIAN HIEROGLYPH O010C', cat:c.Lo,   canon:k._0, block:b[251]},
			'13265':{ u:'13265', i:23519, name:'EGYPTIAN HIEROGLYPH O011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13266':{ u:'13266', i:23520, name:'EGYPTIAN HIEROGLYPH O012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13267':{ u:'13267', i:23521, name:'EGYPTIAN HIEROGLYPH O013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13268':{ u:'13268', i:23522, name:'EGYPTIAN HIEROGLYPH O014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13269':{ u:'13269', i:23523, name:'EGYPTIAN HIEROGLYPH O015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13270':{ u:'13270', i:23530, name:'EGYPTIAN HIEROGLYPH O020A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13271':{ u:'13271', i:23531, name:'EGYPTIAN HIEROGLYPH O021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13272':{ u:'13272', i:23532, name:'EGYPTIAN HIEROGLYPH O022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13273':{ u:'13273', i:23533, name:'EGYPTIAN HIEROGLYPH O023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13274':{ u:'13274', i:23534, name:'EGYPTIAN HIEROGLYPH O024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13275':{ u:'13275', i:23535, name:'EGYPTIAN HIEROGLYPH O024A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13276':{ u:'13276', i:23536, name:'EGYPTIAN HIEROGLYPH O025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13277':{ u:'13277', i:23537, name:'EGYPTIAN HIEROGLYPH O025A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13278':{ u:'13278', i:23538, name:'EGYPTIAN HIEROGLYPH O026', cat:c.Lo,   canon:k._0, block:b[251]},
			'13279':{ u:'13279', i:23539, name:'EGYPTIAN HIEROGLYPH O027', cat:c.Lo,   canon:k._0, block:b[251]},
			'13280':{ u:'13280', i:23546, name:'EGYPTIAN HIEROGLYPH O032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13281':{ u:'13281', i:23547, name:'EGYPTIAN HIEROGLYPH O033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13282':{ u:'13282', i:23548, name:'EGYPTIAN HIEROGLYPH O033A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13283':{ u:'13283', i:23549, name:'EGYPTIAN HIEROGLYPH O034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13284':{ u:'13284', i:23550, name:'EGYPTIAN HIEROGLYPH O035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13285':{ u:'13285', i:23551, name:'EGYPTIAN HIEROGLYPH O036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13286':{ u:'13286', i:23552, name:'EGYPTIAN HIEROGLYPH O036A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13287':{ u:'13287', i:23553, name:'EGYPTIAN HIEROGLYPH O036B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13288':{ u:'13288', i:23554, name:'EGYPTIAN HIEROGLYPH O036C', cat:c.Lo,   canon:k._0, block:b[251]},
			'13289':{ u:'13289', i:23555, name:'EGYPTIAN HIEROGLYPH O036D', cat:c.Lo,   canon:k._0, block:b[251]},
			'13290':{ u:'13290', i:23562, name:'EGYPTIAN HIEROGLYPH O043', cat:c.Lo,   canon:k._0, block:b[251]},
			'13291':{ u:'13291', i:23563, name:'EGYPTIAN HIEROGLYPH O044', cat:c.Lo,   canon:k._0, block:b[251]},
			'13292':{ u:'13292', i:23564, name:'EGYPTIAN HIEROGLYPH O045', cat:c.Lo,   canon:k._0, block:b[251]},
			'13293':{ u:'13293', i:23565, name:'EGYPTIAN HIEROGLYPH O046', cat:c.Lo,   canon:k._0, block:b[251]},
			'13294':{ u:'13294', i:23566, name:'EGYPTIAN HIEROGLYPH O047', cat:c.Lo,   canon:k._0, block:b[251]},
			'13295':{ u:'13295', i:23567, name:'EGYPTIAN HIEROGLYPH O048', cat:c.Lo,   canon:k._0, block:b[251]},
			'13296':{ u:'13296', i:23568, name:'EGYPTIAN HIEROGLYPH O049', cat:c.Lo,   canon:k._0, block:b[251]},
			'13297':{ u:'13297', i:23569, name:'EGYPTIAN HIEROGLYPH O050', cat:c.Lo,   canon:k._0, block:b[251]},
			'13298':{ u:'13298', i:23570, name:'EGYPTIAN HIEROGLYPH O050A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13299':{ u:'13299', i:23571, name:'EGYPTIAN HIEROGLYPH O050B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13300':{ u:'13300', i:23674, name:'EGYPTIAN HIEROGLYPH S040', cat:c.Lo,   canon:k._0, block:b[251]},
			'13301':{ u:'13301', i:23675, name:'EGYPTIAN HIEROGLYPH S041', cat:c.Lo,   canon:k._0, block:b[251]},
			'13302':{ u:'13302', i:23676, name:'EGYPTIAN HIEROGLYPH S042', cat:c.Lo,   canon:k._0, block:b[251]},
			'13303':{ u:'13303', i:23677, name:'EGYPTIAN HIEROGLYPH S043', cat:c.Lo,   canon:k._0, block:b[251]},
			'13304':{ u:'13304', i:23678, name:'EGYPTIAN HIEROGLYPH S044', cat:c.Lo,   canon:k._0, block:b[251]},
			'13305':{ u:'13305', i:23679, name:'EGYPTIAN HIEROGLYPH S045', cat:c.Lo,   canon:k._0, block:b[251]},
			'13306':{ u:'13306', i:23680, name:'EGYPTIAN HIEROGLYPH S046', cat:c.Lo,   canon:k._0, block:b[251]},
			'13307':{ u:'13307', i:23681, name:'EGYPTIAN HIEROGLYPH T001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13308':{ u:'13308', i:23682, name:'EGYPTIAN HIEROGLYPH T002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13309':{ u:'13309', i:23683, name:'EGYPTIAN HIEROGLYPH T003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13310':{ u:'13310', i:23690, name:'EGYPTIAN HIEROGLYPH T008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13311':{ u:'13311', i:23691, name:'EGYPTIAN HIEROGLYPH T008A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13312':{ u:'13312', i:23692, name:'EGYPTIAN HIEROGLYPH T009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13313':{ u:'13313', i:23693, name:'EGYPTIAN HIEROGLYPH T009A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13314':{ u:'13314', i:23694, name:'EGYPTIAN HIEROGLYPH T010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13315':{ u:'13315', i:23695, name:'EGYPTIAN HIEROGLYPH T011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13316':{ u:'13316', i:23696, name:'EGYPTIAN HIEROGLYPH T011A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13317':{ u:'13317', i:23697, name:'EGYPTIAN HIEROGLYPH T012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13318':{ u:'13318', i:23698, name:'EGYPTIAN HIEROGLYPH T013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13319':{ u:'13319', i:23699, name:'EGYPTIAN HIEROGLYPH T014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13320':{ u:'13320', i:23706, name:'EGYPTIAN HIEROGLYPH T020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13321':{ u:'13321', i:23707, name:'EGYPTIAN HIEROGLYPH T021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13322':{ u:'13322', i:23708, name:'EGYPTIAN HIEROGLYPH T022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13323':{ u:'13323', i:23709, name:'EGYPTIAN HIEROGLYPH T023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13324':{ u:'13324', i:23710, name:'EGYPTIAN HIEROGLYPH T024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13325':{ u:'13325', i:23711, name:'EGYPTIAN HIEROGLYPH T025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13326':{ u:'13326', i:23712, name:'EGYPTIAN HIEROGLYPH T026', cat:c.Lo,   canon:k._0, block:b[251]},
			'13327':{ u:'13327', i:23713, name:'EGYPTIAN HIEROGLYPH T027', cat:c.Lo,   canon:k._0, block:b[251]},
			'13328':{ u:'13328', i:23714, name:'EGYPTIAN HIEROGLYPH T028', cat:c.Lo,   canon:k._0, block:b[251]},
			'13329':{ u:'13329', i:23715, name:'EGYPTIAN HIEROGLYPH T029', cat:c.Lo,   canon:k._0, block:b[251]},
			'13330':{ u:'13330', i:23722, name:'EGYPTIAN HIEROGLYPH T034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13331':{ u:'13331', i:23723, name:'EGYPTIAN HIEROGLYPH T035', cat:c.Lo,   canon:k._0, block:b[251]},
			'13332':{ u:'13332', i:23724, name:'EGYPTIAN HIEROGLYPH T036', cat:c.Lo,   canon:k._0, block:b[251]},
			'13333':{ u:'13333', i:23725, name:'EGYPTIAN HIEROGLYPH U001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13334':{ u:'13334', i:23726, name:'EGYPTIAN HIEROGLYPH U002', cat:c.Lo,   canon:k._0, block:b[251]},
			'13335':{ u:'13335', i:23727, name:'EGYPTIAN HIEROGLYPH U003', cat:c.Lo,   canon:k._0, block:b[251]},
			'13336':{ u:'13336', i:23728, name:'EGYPTIAN HIEROGLYPH U004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13337':{ u:'13337', i:23729, name:'EGYPTIAN HIEROGLYPH U005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13338':{ u:'13338', i:23730, name:'EGYPTIAN HIEROGLYPH U006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13339':{ u:'13339', i:23731, name:'EGYPTIAN HIEROGLYPH U006A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13340':{ u:'13340', i:23738, name:'EGYPTIAN HIEROGLYPH U012', cat:c.Lo,   canon:k._0, block:b[251]},
			'13341':{ u:'13341', i:23739, name:'EGYPTIAN HIEROGLYPH U013', cat:c.Lo,   canon:k._0, block:b[251]},
			'13342':{ u:'13342', i:23740, name:'EGYPTIAN HIEROGLYPH U014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13343':{ u:'13343', i:23741, name:'EGYPTIAN HIEROGLYPH U015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13344':{ u:'13344', i:23742, name:'EGYPTIAN HIEROGLYPH U016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13345':{ u:'13345', i:23743, name:'EGYPTIAN HIEROGLYPH U017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13346':{ u:'13346', i:23744, name:'EGYPTIAN HIEROGLYPH U018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13347':{ u:'13347', i:23745, name:'EGYPTIAN HIEROGLYPH U019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13348':{ u:'13348', i:23746, name:'EGYPTIAN HIEROGLYPH U020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13349':{ u:'13349', i:23747, name:'EGYPTIAN HIEROGLYPH U021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13350':{ u:'13350', i:23754, name:'EGYPTIAN HIEROGLYPH U027', cat:c.Lo,   canon:k._0, block:b[251]},
			'13351':{ u:'13351', i:23755, name:'EGYPTIAN HIEROGLYPH U028', cat:c.Lo,   canon:k._0, block:b[251]},
			'13352':{ u:'13352', i:23756, name:'EGYPTIAN HIEROGLYPH U029', cat:c.Lo,   canon:k._0, block:b[251]},
			'13353':{ u:'13353', i:23757, name:'EGYPTIAN HIEROGLYPH U029A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13354':{ u:'13354', i:23758, name:'EGYPTIAN HIEROGLYPH U030', cat:c.Lo,   canon:k._0, block:b[251]},
			'13355':{ u:'13355', i:23759, name:'EGYPTIAN HIEROGLYPH U031', cat:c.Lo,   canon:k._0, block:b[251]},
			'13356':{ u:'13356', i:23760, name:'EGYPTIAN HIEROGLYPH U032', cat:c.Lo,   canon:k._0, block:b[251]},
			'13357':{ u:'13357', i:23761, name:'EGYPTIAN HIEROGLYPH U032A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13358':{ u:'13358', i:23762, name:'EGYPTIAN HIEROGLYPH U033', cat:c.Lo,   canon:k._0, block:b[251]},
			'13359':{ u:'13359', i:23763, name:'EGYPTIAN HIEROGLYPH U034', cat:c.Lo,   canon:k._0, block:b[251]},
			'13360':{ u:'13360', i:23770, name:'EGYPTIAN HIEROGLYPH U041', cat:c.Lo,   canon:k._0, block:b[251]},
			'13361':{ u:'13361', i:23771, name:'EGYPTIAN HIEROGLYPH U042', cat:c.Lo,   canon:k._0, block:b[251]},
			'13362':{ u:'13362', i:23772, name:'EGYPTIAN HIEROGLYPH V001', cat:c.Lo,   canon:k._0, block:b[251]},
			'13363':{ u:'13363', i:23773, name:'EGYPTIAN HIEROGLYPH V001A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13364':{ u:'13364', i:23774, name:'EGYPTIAN HIEROGLYPH V001B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13365':{ u:'13365', i:23775, name:'EGYPTIAN HIEROGLYPH V001C', cat:c.Lo,   canon:k._0, block:b[251]},
			'13366':{ u:'13366', i:23776, name:'EGYPTIAN HIEROGLYPH V001D', cat:c.Lo,   canon:k._0, block:b[251]},
			'13367':{ u:'13367', i:23777, name:'EGYPTIAN HIEROGLYPH V001E', cat:c.Lo,   canon:k._0, block:b[251]},
			'13368':{ u:'13368', i:23778, name:'EGYPTIAN HIEROGLYPH V001F', cat:c.Lo,   canon:k._0, block:b[251]},
			'13369':{ u:'13369', i:23779, name:'EGYPTIAN HIEROGLYPH V001G', cat:c.Lo,   canon:k._0, block:b[251]},
			'13370':{ u:'13370', i:23786, name:'EGYPTIAN HIEROGLYPH V005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13371':{ u:'13371', i:23787, name:'EGYPTIAN HIEROGLYPH V006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13372':{ u:'13372', i:23788, name:'EGYPTIAN HIEROGLYPH V007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13373':{ u:'13373', i:23789, name:'EGYPTIAN HIEROGLYPH V007A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13374':{ u:'13374', i:23790, name:'EGYPTIAN HIEROGLYPH V007B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13375':{ u:'13375', i:23791, name:'EGYPTIAN HIEROGLYPH V008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13376':{ u:'13376', i:23792, name:'EGYPTIAN HIEROGLYPH V009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13377':{ u:'13377', i:23793, name:'EGYPTIAN HIEROGLYPH V010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13378':{ u:'13378', i:23794, name:'EGYPTIAN HIEROGLYPH V011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13379':{ u:'13379', i:23795, name:'EGYPTIAN HIEROGLYPH V011A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13380':{ u:'13380', i:23802, name:'EGYPTIAN HIEROGLYPH V014', cat:c.Lo,   canon:k._0, block:b[251]},
			'13381':{ u:'13381', i:23803, name:'EGYPTIAN HIEROGLYPH V015', cat:c.Lo,   canon:k._0, block:b[251]},
			'13382':{ u:'13382', i:23804, name:'EGYPTIAN HIEROGLYPH V016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13383':{ u:'13383', i:23805, name:'EGYPTIAN HIEROGLYPH V017', cat:c.Lo,   canon:k._0, block:b[251]},
			'13384':{ u:'13384', i:23806, name:'EGYPTIAN HIEROGLYPH V018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13385':{ u:'13385', i:23807, name:'EGYPTIAN HIEROGLYPH V019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13386':{ u:'13386', i:23808, name:'EGYPTIAN HIEROGLYPH V020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13387':{ u:'13387', i:23809, name:'EGYPTIAN HIEROGLYPH V020A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13388':{ u:'13388', i:23810, name:'EGYPTIAN HIEROGLYPH V020B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13389':{ u:'13389', i:23811, name:'EGYPTIAN HIEROGLYPH V020C', cat:c.Lo,   canon:k._0, block:b[251]},
			'13390':{ u:'13390', i:23818, name:'EGYPTIAN HIEROGLYPH V020J', cat:c.Lo,   canon:k._0, block:b[251]},
			'13391':{ u:'13391', i:23819, name:'EGYPTIAN HIEROGLYPH V020K', cat:c.Lo,   canon:k._0, block:b[251]},
			'13392':{ u:'13392', i:23820, name:'EGYPTIAN HIEROGLYPH V020L', cat:c.Lo,   canon:k._0, block:b[251]},
			'13393':{ u:'13393', i:23821, name:'EGYPTIAN HIEROGLYPH V021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13394':{ u:'13394', i:23822, name:'EGYPTIAN HIEROGLYPH V022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13395':{ u:'13395', i:23823, name:'EGYPTIAN HIEROGLYPH V023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13396':{ u:'13396', i:23824, name:'EGYPTIAN HIEROGLYPH V023A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13397':{ u:'13397', i:23825, name:'EGYPTIAN HIEROGLYPH V024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13398':{ u:'13398', i:23826, name:'EGYPTIAN HIEROGLYPH V025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13399':{ u:'13399', i:23827, name:'EGYPTIAN HIEROGLYPH V026', cat:c.Lo,   canon:k._0, block:b[251]},
			'13400':{ u:'13400', i:23930, name:'EGYPTIAN HIEROGLYPH Z015F', cat:c.Lo,   canon:k._0, block:b[251]},
			'13401':{ u:'13401', i:23931, name:'EGYPTIAN HIEROGLYPH Z015G', cat:c.Lo,   canon:k._0, block:b[251]},
			'13402':{ u:'13402', i:23932, name:'EGYPTIAN HIEROGLYPH Z015H', cat:c.Lo,   canon:k._0, block:b[251]},
			'13403':{ u:'13403', i:23933, name:'EGYPTIAN HIEROGLYPH Z015I', cat:c.Lo,   canon:k._0, block:b[251]},
			'13404':{ u:'13404', i:23934, name:'EGYPTIAN HIEROGLYPH Z016', cat:c.Lo,   canon:k._0, block:b[251]},
			'13405':{ u:'13405', i:23935, name:'EGYPTIAN HIEROGLYPH Z016A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13406':{ u:'13406', i:23936, name:'EGYPTIAN HIEROGLYPH Z016B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13407':{ u:'13407', i:23937, name:'EGYPTIAN HIEROGLYPH Z016C', cat:c.Lo,   canon:k._0, block:b[251]},
			'13408':{ u:'13408', i:23938, name:'EGYPTIAN HIEROGLYPH Z016D', cat:c.Lo,   canon:k._0, block:b[251]},
			'13409':{ u:'13409', i:23939, name:'EGYPTIAN HIEROGLYPH Z016E', cat:c.Lo,   canon:k._0, block:b[251]},
			'13410':{ u:'13410', i:23946, name:'EGYPTIAN HIEROGLYPH AA004', cat:c.Lo,   canon:k._0, block:b[251]},
			'13411':{ u:'13411', i:23947, name:'EGYPTIAN HIEROGLYPH AA005', cat:c.Lo,   canon:k._0, block:b[251]},
			'13412':{ u:'13412', i:23948, name:'EGYPTIAN HIEROGLYPH AA006', cat:c.Lo,   canon:k._0, block:b[251]},
			'13413':{ u:'13413', i:23949, name:'EGYPTIAN HIEROGLYPH AA007', cat:c.Lo,   canon:k._0, block:b[251]},
			'13414':{ u:'13414', i:23950, name:'EGYPTIAN HIEROGLYPH AA007A', cat:c.Lo,   canon:k._0, block:b[251]},
			'13415':{ u:'13415', i:23951, name:'EGYPTIAN HIEROGLYPH AA007B', cat:c.Lo,   canon:k._0, block:b[251]},
			'13416':{ u:'13416', i:23952, name:'EGYPTIAN HIEROGLYPH AA008', cat:c.Lo,   canon:k._0, block:b[251]},
			'13417':{ u:'13417', i:23953, name:'EGYPTIAN HIEROGLYPH AA009', cat:c.Lo,   canon:k._0, block:b[251]},
			'13418':{ u:'13418', i:23954, name:'EGYPTIAN HIEROGLYPH AA010', cat:c.Lo,   canon:k._0, block:b[251]},
			'13419':{ u:'13419', i:23955, name:'EGYPTIAN HIEROGLYPH AA011', cat:c.Lo,   canon:k._0, block:b[251]},
			'13420':{ u:'13420', i:23962, name:'EGYPTIAN HIEROGLYPH AA018', cat:c.Lo,   canon:k._0, block:b[251]},
			'13421':{ u:'13421', i:23963, name:'EGYPTIAN HIEROGLYPH AA019', cat:c.Lo,   canon:k._0, block:b[251]},
			'13422':{ u:'13422', i:23964, name:'EGYPTIAN HIEROGLYPH AA020', cat:c.Lo,   canon:k._0, block:b[251]},
			'13423':{ u:'13423', i:23965, name:'EGYPTIAN HIEROGLYPH AA021', cat:c.Lo,   canon:k._0, block:b[251]},
			'13424':{ u:'13424', i:23966, name:'EGYPTIAN HIEROGLYPH AA022', cat:c.Lo,   canon:k._0, block:b[251]},
			'13425':{ u:'13425', i:23967, name:'EGYPTIAN HIEROGLYPH AA023', cat:c.Lo,   canon:k._0, block:b[251]},
			'13426':{ u:'13426', i:23968, name:'EGYPTIAN HIEROGLYPH AA024', cat:c.Lo,   canon:k._0, block:b[251]},
			'13427':{ u:'13427', i:23969, name:'EGYPTIAN HIEROGLYPH AA025', cat:c.Lo,   canon:k._0, block:b[251]},
			'13428':{ u:'13428', i:23970, name:'EGYPTIAN HIEROGLYPH AA026', cat:c.Lo,   canon:k._0, block:b[251]},
			'13429':{ u:'13429', i:23971, name:'EGYPTIAN HIEROGLYPH AA027', cat:c.Lo,   canon:k._0, block:b[251]},
			'13430':{ u:'13430', i:23977, name:'EGYPTIAN HIEROGLYPH VERTICAL JOINER', cat:c.Cf,   canon:k._0, block:b[252]},
			'13431':{ u:'13431', i:23978, name:'EGYPTIAN HIEROGLYPH HORIZONTAL JOINER', cat:c.Cf,   canon:k._0, block:b[252]},
			'13432':{ u:'13432', i:23979, name:'EGYPTIAN HIEROGLYPH INSERT AT TOP START', cat:c.Cf,   canon:k._0, block:b[252]},
			'13433':{ u:'13433', i:23980, name:'EGYPTIAN HIEROGLYPH INSERT AT BOTTOM START', cat:c.Cf,   canon:k._0, block:b[252]},
			'13434':{ u:'13434', i:23981, name:'EGYPTIAN HIEROGLYPH INSERT AT TOP END', cat:c.Cf,   canon:k._0, block:b[252]},
			'13435':{ u:'13435', i:23982, name:'EGYPTIAN HIEROGLYPH INSERT AT BOTTOM END', cat:c.Cf,   canon:k._0, block:b[252]},
			'13436':{ u:'13436', i:23983, name:'EGYPTIAN HIEROGLYPH OVERLAY MIDDLE', cat:c.Cf,   canon:k._0, block:b[252]},
			'13437':{ u:'13437', i:23984, name:'EGYPTIAN HIEROGLYPH BEGIN SEGMENT', cat:c.Cf,   canon:k._0, block:b[252]},
			'13438':{ u:'13438', i:23985, name:'EGYPTIAN HIEROGLYPH END SEGMENT', cat:c.Cf,   canon:k._0, block:b[252]},
			'14400':{ u:'14400', i:23986, name:'ANATOLIAN HIEROGLYPH A001', cat:c.Lo,   canon:k._0, block:b[253]},
			'14401':{ u:'14401', i:23987, name:'ANATOLIAN HIEROGLYPH A002', cat:c.Lo,   canon:k._0, block:b[253]},
			'14402':{ u:'14402', i:23988, name:'ANATOLIAN HIEROGLYPH A003', cat:c.Lo,   canon:k._0, block:b[253]},
			'14403':{ u:'14403', i:23989, name:'ANATOLIAN HIEROGLYPH A004', cat:c.Lo,   canon:k._0, block:b[253]},
			'14404':{ u:'14404', i:23990, name:'ANATOLIAN HIEROGLYPH A005', cat:c.Lo,   canon:k._0, block:b[253]},
			'14405':{ u:'14405', i:23991, name:'ANATOLIAN HIEROGLYPH A006', cat:c.Lo,   canon:k._0, block:b[253]},
			'14406':{ u:'14406', i:23992, name:'ANATOLIAN HIEROGLYPH A007', cat:c.Lo,   canon:k._0, block:b[253]},
			'14407':{ u:'14407', i:23993, name:'ANATOLIAN HIEROGLYPH A008', cat:c.Lo,   canon:k._0, block:b[253]},
			'14408':{ u:'14408', i:23994, name:'ANATOLIAN HIEROGLYPH A009', cat:c.Lo,   canon:k._0, block:b[253]},
			'14409':{ u:'14409', i:23995, name:'ANATOLIAN HIEROGLYPH A010', cat:c.Lo,   canon:k._0, block:b[253]},
			'14410':{ u:'14410', i:24002, name:'ANATOLIAN HIEROGLYPH A016', cat:c.Lo,   canon:k._0, block:b[253]},
			'14411':{ u:'14411', i:24003, name:'ANATOLIAN HIEROGLYPH A017', cat:c.Lo,   canon:k._0, block:b[253]},
			'14412':{ u:'14412', i:24004, name:'ANATOLIAN HIEROGLYPH A018', cat:c.Lo,   canon:k._0, block:b[253]},
			'14413':{ u:'14413', i:24005, name:'ANATOLIAN HIEROGLYPH A019', cat:c.Lo,   canon:k._0, block:b[253]},
			'14414':{ u:'14414', i:24006, name:'ANATOLIAN HIEROGLYPH A020', cat:c.Lo,   canon:k._0, block:b[253]},
			'14415':{ u:'14415', i:24007, name:'ANATOLIAN HIEROGLYPH A021', cat:c.Lo,   canon:k._0, block:b[253]},
			'14416':{ u:'14416', i:24008, name:'ANATOLIAN HIEROGLYPH A022', cat:c.Lo,   canon:k._0, block:b[253]},
			'14417':{ u:'14417', i:24009, name:'ANATOLIAN HIEROGLYPH A023', cat:c.Lo,   canon:k._0, block:b[253]},
			'14418':{ u:'14418', i:24010, name:'ANATOLIAN HIEROGLYPH A024', cat:c.Lo,   canon:k._0, block:b[253]},
			'14419':{ u:'14419', i:24011, name:'ANATOLIAN HIEROGLYPH A025', cat:c.Lo,   canon:k._0, block:b[253]},
			'14420':{ u:'14420', i:24018, name:'ANATOLIAN HIEROGLYPH A031', cat:c.Lo,   canon:k._0, block:b[253]},
			'14421':{ u:'14421', i:24019, name:'ANATOLIAN HIEROGLYPH A032', cat:c.Lo,   canon:k._0, block:b[253]},
			'14422':{ u:'14422', i:24020, name:'ANATOLIAN HIEROGLYPH A033', cat:c.Lo,   canon:k._0, block:b[253]},
			'14423':{ u:'14423', i:24021, name:'ANATOLIAN HIEROGLYPH A034', cat:c.Lo,   canon:k._0, block:b[253]},
			'14424':{ u:'14424', i:24022, name:'ANATOLIAN HIEROGLYPH A035', cat:c.Lo,   canon:k._0, block:b[253]},
			'14425':{ u:'14425', i:24023, name:'ANATOLIAN HIEROGLYPH A036', cat:c.Lo,   canon:k._0, block:b[253]},
			'14426':{ u:'14426', i:24024, name:'ANATOLIAN HIEROGLYPH A037', cat:c.Lo,   canon:k._0, block:b[253]},
			'14427':{ u:'14427', i:24025, name:'ANATOLIAN HIEROGLYPH A038', cat:c.Lo,   canon:k._0, block:b[253]},
			'14428':{ u:'14428', i:24026, name:'ANATOLIAN HIEROGLYPH A039', cat:c.Lo,   canon:k._0, block:b[253]},
			'14429':{ u:'14429', i:24027, name:'ANATOLIAN HIEROGLYPH A039A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14430':{ u:'14430', i:24034, name:'ANATOLIAN HIEROGLYPH A045', cat:c.Lo,   canon:k._0, block:b[253]},
			'14431':{ u:'14431', i:24035, name:'ANATOLIAN HIEROGLYPH A045A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14432':{ u:'14432', i:24036, name:'ANATOLIAN HIEROGLYPH A046', cat:c.Lo,   canon:k._0, block:b[253]},
			'14433':{ u:'14433', i:24037, name:'ANATOLIAN HIEROGLYPH A046A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14434':{ u:'14434', i:24038, name:'ANATOLIAN HIEROGLYPH A046B', cat:c.Lo,   canon:k._0, block:b[253]},
			'14435':{ u:'14435', i:24039, name:'ANATOLIAN HIEROGLYPH A047', cat:c.Lo,   canon:k._0, block:b[253]},
			'14436':{ u:'14436', i:24040, name:'ANATOLIAN HIEROGLYPH A048', cat:c.Lo,   canon:k._0, block:b[253]},
			'14437':{ u:'14437', i:24041, name:'ANATOLIAN HIEROGLYPH A049', cat:c.Lo,   canon:k._0, block:b[253]},
			'14438':{ u:'14438', i:24042, name:'ANATOLIAN HIEROGLYPH A050', cat:c.Lo,   canon:k._0, block:b[253]},
			'14439':{ u:'14439', i:24043, name:'ANATOLIAN HIEROGLYPH A051', cat:c.Lo,   canon:k._0, block:b[253]},
			'14440':{ u:'14440', i:24050, name:'ANATOLIAN HIEROGLYPH A058', cat:c.Lo,   canon:k._0, block:b[253]},
			'14441':{ u:'14441', i:24051, name:'ANATOLIAN HIEROGLYPH A059', cat:c.Lo,   canon:k._0, block:b[253]},
			'14442':{ u:'14442', i:24052, name:'ANATOLIAN HIEROGLYPH A060', cat:c.Lo,   canon:k._0, block:b[253]},
			'14443':{ u:'14443', i:24053, name:'ANATOLIAN HIEROGLYPH A061', cat:c.Lo,   canon:k._0, block:b[253]},
			'14444':{ u:'14444', i:24054, name:'ANATOLIAN HIEROGLYPH A062', cat:c.Lo,   canon:k._0, block:b[253]},
			'14445':{ u:'14445', i:24055, name:'ANATOLIAN HIEROGLYPH A063', cat:c.Lo,   canon:k._0, block:b[253]},
			'14446':{ u:'14446', i:24056, name:'ANATOLIAN HIEROGLYPH A064', cat:c.Lo,   canon:k._0, block:b[253]},
			'14447':{ u:'14447', i:24057, name:'ANATOLIAN HIEROGLYPH A065', cat:c.Lo,   canon:k._0, block:b[253]},
			'14448':{ u:'14448', i:24058, name:'ANATOLIAN HIEROGLYPH A066', cat:c.Lo,   canon:k._0, block:b[253]},
			'14449':{ u:'14449', i:24059, name:'ANATOLIAN HIEROGLYPH A066A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14450':{ u:'14450', i:24066, name:'ANATOLIAN HIEROGLYPH A071', cat:c.Lo,   canon:k._0, block:b[253]},
			'14451':{ u:'14451', i:24067, name:'ANATOLIAN HIEROGLYPH A072', cat:c.Lo,   canon:k._0, block:b[253]},
			'14452':{ u:'14452', i:24068, name:'ANATOLIAN HIEROGLYPH A073', cat:c.Lo,   canon:k._0, block:b[253]},
			'14453':{ u:'14453', i:24069, name:'ANATOLIAN HIEROGLYPH A074', cat:c.Lo,   canon:k._0, block:b[253]},
			'14454':{ u:'14454', i:24070, name:'ANATOLIAN HIEROGLYPH A075', cat:c.Lo,   canon:k._0, block:b[253]},
			'14455':{ u:'14455', i:24071, name:'ANATOLIAN HIEROGLYPH A076', cat:c.Lo,   canon:k._0, block:b[253]},
			'14456':{ u:'14456', i:24072, name:'ANATOLIAN HIEROGLYPH A077', cat:c.Lo,   canon:k._0, block:b[253]},
			'14457':{ u:'14457', i:24073, name:'ANATOLIAN HIEROGLYPH A078', cat:c.Lo,   canon:k._0, block:b[253]},
			'14458':{ u:'14458', i:24074, name:'ANATOLIAN HIEROGLYPH A079', cat:c.Lo,   canon:k._0, block:b[253]},
			'14459':{ u:'14459', i:24075, name:'ANATOLIAN HIEROGLYPH A080', cat:c.Lo,   canon:k._0, block:b[253]},
			'14460':{ u:'14460', i:24082, name:'ANATOLIAN HIEROGLYPH A087', cat:c.Lo,   canon:k._0, block:b[253]},
			'14461':{ u:'14461', i:24083, name:'ANATOLIAN HIEROGLYPH A088', cat:c.Lo,   canon:k._0, block:b[253]},
			'14462':{ u:'14462', i:24084, name:'ANATOLIAN HIEROGLYPH A089', cat:c.Lo,   canon:k._0, block:b[253]},
			'14463':{ u:'14463', i:24085, name:'ANATOLIAN HIEROGLYPH A090', cat:c.Lo,   canon:k._0, block:b[253]},
			'14464':{ u:'14464', i:24086, name:'ANATOLIAN HIEROGLYPH A091', cat:c.Lo,   canon:k._0, block:b[253]},
			'14465':{ u:'14465', i:24087, name:'ANATOLIAN HIEROGLYPH A092', cat:c.Lo,   canon:k._0, block:b[253]},
			'14466':{ u:'14466', i:24088, name:'ANATOLIAN HIEROGLYPH A093', cat:c.Lo,   canon:k._0, block:b[253]},
			'14467':{ u:'14467', i:24089, name:'ANATOLIAN HIEROGLYPH A094', cat:c.Lo,   canon:k._0, block:b[253]},
			'14468':{ u:'14468', i:24090, name:'ANATOLIAN HIEROGLYPH A095', cat:c.Lo,   canon:k._0, block:b[253]},
			'14469':{ u:'14469', i:24091, name:'ANATOLIAN HIEROGLYPH A096', cat:c.Lo,   canon:k._0, block:b[253]},
			'14470':{ u:'14470', i:24098, name:'ANATOLIAN HIEROGLYPH A100A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14471':{ u:'14471', i:24099, name:'ANATOLIAN HIEROGLYPH A101', cat:c.Lo,   canon:k._0, block:b[253]},
			'14472':{ u:'14472', i:24100, name:'ANATOLIAN HIEROGLYPH A101A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14473':{ u:'14473', i:24101, name:'ANATOLIAN HIEROGLYPH A102', cat:c.Lo,   canon:k._0, block:b[253]},
			'14474':{ u:'14474', i:24102, name:'ANATOLIAN HIEROGLYPH A102A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14475':{ u:'14475', i:24103, name:'ANATOLIAN HIEROGLYPH A103', cat:c.Lo,   canon:k._0, block:b[253]},
			'14476':{ u:'14476', i:24104, name:'ANATOLIAN HIEROGLYPH A104', cat:c.Lo,   canon:k._0, block:b[253]},
			'14477':{ u:'14477', i:24105, name:'ANATOLIAN HIEROGLYPH A104A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14478':{ u:'14478', i:24106, name:'ANATOLIAN HIEROGLYPH A104B', cat:c.Lo,   canon:k._0, block:b[253]},
			'14479':{ u:'14479', i:24107, name:'ANATOLIAN HIEROGLYPH A104C', cat:c.Lo,   canon:k._0, block:b[253]},
			'14480':{ u:'14480', i:24114, name:'ANATOLIAN HIEROGLYPH A107B', cat:c.Lo,   canon:k._0, block:b[253]},
			'14481':{ u:'14481', i:24115, name:'ANATOLIAN HIEROGLYPH A107C', cat:c.Lo,   canon:k._0, block:b[253]},
			'14482':{ u:'14482', i:24116, name:'ANATOLIAN HIEROGLYPH A108', cat:c.Lo,   canon:k._0, block:b[253]},
			'14483':{ u:'14483', i:24117, name:'ANATOLIAN HIEROGLYPH A109', cat:c.Lo,   canon:k._0, block:b[253]},
			'14484':{ u:'14484', i:24118, name:'ANATOLIAN HIEROGLYPH A110', cat:c.Lo,   canon:k._0, block:b[253]},
			'14485':{ u:'14485', i:24119, name:'ANATOLIAN HIEROGLYPH A110A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14486':{ u:'14486', i:24120, name:'ANATOLIAN HIEROGLYPH A110B', cat:c.Lo,   canon:k._0, block:b[253]},
			'14487':{ u:'14487', i:24121, name:'ANATOLIAN HIEROGLYPH A111', cat:c.Lo,   canon:k._0, block:b[253]},
			'14488':{ u:'14488', i:24122, name:'ANATOLIAN HIEROGLYPH A112', cat:c.Lo,   canon:k._0, block:b[253]},
			'14489':{ u:'14489', i:24123, name:'ANATOLIAN HIEROGLYPH A113', cat:c.Lo,   canon:k._0, block:b[253]},
			'14490':{ u:'14490', i:24130, name:'ANATOLIAN HIEROGLYPH A119', cat:c.Lo,   canon:k._0, block:b[253]},
			'14491':{ u:'14491', i:24131, name:'ANATOLIAN HIEROGLYPH A120', cat:c.Lo,   canon:k._0, block:b[253]},
			'14492':{ u:'14492', i:24132, name:'ANATOLIAN HIEROGLYPH A121', cat:c.Lo,   canon:k._0, block:b[253]},
			'14493':{ u:'14493', i:24133, name:'ANATOLIAN HIEROGLYPH A122', cat:c.Lo,   canon:k._0, block:b[253]},
			'14494':{ u:'14494', i:24134, name:'ANATOLIAN HIEROGLYPH A123', cat:c.Lo,   canon:k._0, block:b[253]},
			'14495':{ u:'14495', i:24135, name:'ANATOLIAN HIEROGLYPH A124', cat:c.Lo,   canon:k._0, block:b[253]},
			'14496':{ u:'14496', i:24136, name:'ANATOLIAN HIEROGLYPH A125', cat:c.Lo,   canon:k._0, block:b[253]},
			'14497':{ u:'14497', i:24137, name:'ANATOLIAN HIEROGLYPH A125A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14498':{ u:'14498', i:24138, name:'ANATOLIAN HIEROGLYPH A126', cat:c.Lo,   canon:k._0, block:b[253]},
			'14499':{ u:'14499', i:24139, name:'ANATOLIAN HIEROGLYPH A127', cat:c.Lo,   canon:k._0, block:b[253]},
			'14500':{ u:'14500', i:24242, name:'ANATOLIAN HIEROGLYPH A223', cat:c.Lo,   canon:k._0, block:b[253]},
			'14501':{ u:'14501', i:24243, name:'ANATOLIAN HIEROGLYPH A224', cat:c.Lo,   canon:k._0, block:b[253]},
			'14502':{ u:'14502', i:24244, name:'ANATOLIAN HIEROGLYPH A225', cat:c.Lo,   canon:k._0, block:b[253]},
			'14503':{ u:'14503', i:24245, name:'ANATOLIAN HIEROGLYPH A226', cat:c.Lo,   canon:k._0, block:b[253]},
			'14504':{ u:'14504', i:24246, name:'ANATOLIAN HIEROGLYPH A227', cat:c.Lo,   canon:k._0, block:b[253]},
			'14505':{ u:'14505', i:24247, name:'ANATOLIAN HIEROGLYPH A227A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14506':{ u:'14506', i:24248, name:'ANATOLIAN HIEROGLYPH A228', cat:c.Lo,   canon:k._0, block:b[253]},
			'14507':{ u:'14507', i:24249, name:'ANATOLIAN HIEROGLYPH A229', cat:c.Lo,   canon:k._0, block:b[253]},
			'14508':{ u:'14508', i:24250, name:'ANATOLIAN HIEROGLYPH A230', cat:c.Lo,   canon:k._0, block:b[253]},
			'14509':{ u:'14509', i:24251, name:'ANATOLIAN HIEROGLYPH A231', cat:c.Lo,   canon:k._0, block:b[253]},
			'14510':{ u:'14510', i:24258, name:'ANATOLIAN HIEROGLYPH A238', cat:c.Lo,   canon:k._0, block:b[253]},
			'14511':{ u:'14511', i:24259, name:'ANATOLIAN HIEROGLYPH A239', cat:c.Lo,   canon:k._0, block:b[253]},
			'14512':{ u:'14512', i:24260, name:'ANATOLIAN HIEROGLYPH A240', cat:c.Lo,   canon:k._0, block:b[253]},
			'14513':{ u:'14513', i:24261, name:'ANATOLIAN HIEROGLYPH A241', cat:c.Lo,   canon:k._0, block:b[253]},
			'14514':{ u:'14514', i:24262, name:'ANATOLIAN HIEROGLYPH A242', cat:c.Lo,   canon:k._0, block:b[253]},
			'14515':{ u:'14515', i:24263, name:'ANATOLIAN HIEROGLYPH A243', cat:c.Lo,   canon:k._0, block:b[253]},
			'14516':{ u:'14516', i:24264, name:'ANATOLIAN HIEROGLYPH A244', cat:c.Lo,   canon:k._0, block:b[253]},
			'14517':{ u:'14517', i:24265, name:'ANATOLIAN HIEROGLYPH A245', cat:c.Lo,   canon:k._0, block:b[253]},
			'14518':{ u:'14518', i:24266, name:'ANATOLIAN HIEROGLYPH A246', cat:c.Lo,   canon:k._0, block:b[253]},
			'14519':{ u:'14519', i:24267, name:'ANATOLIAN HIEROGLYPH A247', cat:c.Lo,   canon:k._0, block:b[253]},
			'14520':{ u:'14520', i:24274, name:'ANATOLIAN HIEROGLYPH A254', cat:c.Lo,   canon:k._0, block:b[253]},
			'14521':{ u:'14521', i:24275, name:'ANATOLIAN HIEROGLYPH A255', cat:c.Lo,   canon:k._0, block:b[253]},
			'14522':{ u:'14522', i:24276, name:'ANATOLIAN HIEROGLYPH A256', cat:c.Lo,   canon:k._0, block:b[253]},
			'14523':{ u:'14523', i:24277, name:'ANATOLIAN HIEROGLYPH A257', cat:c.Lo,   canon:k._0, block:b[253]},
			'14524':{ u:'14524', i:24278, name:'ANATOLIAN HIEROGLYPH A258', cat:c.Lo,   canon:k._0, block:b[253]},
			'14525':{ u:'14525', i:24279, name:'ANATOLIAN HIEROGLYPH A259', cat:c.Lo,   canon:k._0, block:b[253]},
			'14526':{ u:'14526', i:24280, name:'ANATOLIAN HIEROGLYPH A260', cat:c.Lo,   canon:k._0, block:b[253]},
			'14527':{ u:'14527', i:24281, name:'ANATOLIAN HIEROGLYPH A261', cat:c.Lo,   canon:k._0, block:b[253]},
			'14528':{ u:'14528', i:24282, name:'ANATOLIAN HIEROGLYPH A262', cat:c.Lo,   canon:k._0, block:b[253]},
			'14529':{ u:'14529', i:24283, name:'ANATOLIAN HIEROGLYPH A263', cat:c.Lo,   canon:k._0, block:b[253]},
			'14530':{ u:'14530', i:24290, name:'ANATOLIAN HIEROGLYPH A269', cat:c.Lo,   canon:k._0, block:b[253]},
			'14531':{ u:'14531', i:24291, name:'ANATOLIAN HIEROGLYPH A270', cat:c.Lo,   canon:k._0, block:b[253]},
			'14532':{ u:'14532', i:24292, name:'ANATOLIAN HIEROGLYPH A271', cat:c.Lo,   canon:k._0, block:b[253]},
			'14533':{ u:'14533', i:24293, name:'ANATOLIAN HIEROGLYPH A272', cat:c.Lo,   canon:k._0, block:b[253]},
			'14534':{ u:'14534', i:24294, name:'ANATOLIAN HIEROGLYPH A273', cat:c.Lo,   canon:k._0, block:b[253]},
			'14535':{ u:'14535', i:24295, name:'ANATOLIAN HIEROGLYPH A274', cat:c.Lo,   canon:k._0, block:b[253]},
			'14536':{ u:'14536', i:24296, name:'ANATOLIAN HIEROGLYPH A275', cat:c.Lo,   canon:k._0, block:b[253]},
			'14537':{ u:'14537', i:24297, name:'ANATOLIAN HIEROGLYPH A276', cat:c.Lo,   canon:k._0, block:b[253]},
			'14538':{ u:'14538', i:24298, name:'ANATOLIAN HIEROGLYPH A277', cat:c.Lo,   canon:k._0, block:b[253]},
			'14539':{ u:'14539', i:24299, name:'ANATOLIAN HIEROGLYPH A278', cat:c.Lo,   canon:k._0, block:b[253]},
			'14540':{ u:'14540', i:24306, name:'ANATOLIAN HIEROGLYPH A285', cat:c.Lo,   canon:k._0, block:b[253]},
			'14541':{ u:'14541', i:24307, name:'ANATOLIAN HIEROGLYPH A286', cat:c.Lo,   canon:k._0, block:b[253]},
			'14542':{ u:'14542', i:24308, name:'ANATOLIAN HIEROGLYPH A287', cat:c.Lo,   canon:k._0, block:b[253]},
			'14543':{ u:'14543', i:24309, name:'ANATOLIAN HIEROGLYPH A288', cat:c.Lo,   canon:k._0, block:b[253]},
			'14544':{ u:'14544', i:24310, name:'ANATOLIAN HIEROGLYPH A289', cat:c.Lo,   canon:k._0, block:b[253]},
			'14545':{ u:'14545', i:24311, name:'ANATOLIAN HIEROGLYPH A289A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14546':{ u:'14546', i:24312, name:'ANATOLIAN HIEROGLYPH A290', cat:c.Lo,   canon:k._0, block:b[253]},
			'14547':{ u:'14547', i:24313, name:'ANATOLIAN HIEROGLYPH A291', cat:c.Lo,   canon:k._0, block:b[253]},
			'14548':{ u:'14548', i:24314, name:'ANATOLIAN HIEROGLYPH A292', cat:c.Lo,   canon:k._0, block:b[253]},
			'14549':{ u:'14549', i:24315, name:'ANATOLIAN HIEROGLYPH A293', cat:c.Lo,   canon:k._0, block:b[253]},
			'14550':{ u:'14550', i:24322, name:'ANATOLIAN HIEROGLYPH A299', cat:c.Lo,   canon:k._0, block:b[253]},
			'14551':{ u:'14551', i:24323, name:'ANATOLIAN HIEROGLYPH A299A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14552':{ u:'14552', i:24324, name:'ANATOLIAN HIEROGLYPH A300', cat:c.Lo,   canon:k._0, block:b[253]},
			'14553':{ u:'14553', i:24325, name:'ANATOLIAN HIEROGLYPH A301', cat:c.Lo,   canon:k._0, block:b[253]},
			'14554':{ u:'14554', i:24326, name:'ANATOLIAN HIEROGLYPH A302', cat:c.Lo,   canon:k._0, block:b[253]},
			'14555':{ u:'14555', i:24327, name:'ANATOLIAN HIEROGLYPH A303', cat:c.Lo,   canon:k._0, block:b[253]},
			'14556':{ u:'14556', i:24328, name:'ANATOLIAN HIEROGLYPH A304', cat:c.Lo,   canon:k._0, block:b[253]},
			'14557':{ u:'14557', i:24329, name:'ANATOLIAN HIEROGLYPH A305', cat:c.Lo,   canon:k._0, block:b[253]},
			'14558':{ u:'14558', i:24330, name:'ANATOLIAN HIEROGLYPH A306', cat:c.Lo,   canon:k._0, block:b[253]},
			'14559':{ u:'14559', i:24331, name:'ANATOLIAN HIEROGLYPH A307', cat:c.Lo,   canon:k._0, block:b[253]},
			'14560':{ u:'14560', i:24338, name:'ANATOLIAN HIEROGLYPH A313', cat:c.Lo,   canon:k._0, block:b[253]},
			'14561':{ u:'14561', i:24339, name:'ANATOLIAN HIEROGLYPH A314', cat:c.Lo,   canon:k._0, block:b[253]},
			'14562':{ u:'14562', i:24340, name:'ANATOLIAN HIEROGLYPH A315', cat:c.Lo,   canon:k._0, block:b[253]},
			'14563':{ u:'14563', i:24341, name:'ANATOLIAN HIEROGLYPH A316', cat:c.Lo,   canon:k._0, block:b[253]},
			'14564':{ u:'14564', i:24342, name:'ANATOLIAN HIEROGLYPH A317', cat:c.Lo,   canon:k._0, block:b[253]},
			'14565':{ u:'14565', i:24343, name:'ANATOLIAN HIEROGLYPH A318', cat:c.Lo,   canon:k._0, block:b[253]},
			'14566':{ u:'14566', i:24344, name:'ANATOLIAN HIEROGLYPH A319', cat:c.Lo,   canon:k._0, block:b[253]},
			'14567':{ u:'14567', i:24345, name:'ANATOLIAN HIEROGLYPH A320', cat:c.Lo,   canon:k._0, block:b[253]},
			'14568':{ u:'14568', i:24346, name:'ANATOLIAN HIEROGLYPH A321', cat:c.Lo,   canon:k._0, block:b[253]},
			'14569':{ u:'14569', i:24347, name:'ANATOLIAN HIEROGLYPH A322', cat:c.Lo,   canon:k._0, block:b[253]},
			'14570':{ u:'14570', i:24354, name:'ANATOLIAN HIEROGLYPH A329', cat:c.Lo,   canon:k._0, block:b[253]},
			'14571':{ u:'14571', i:24355, name:'ANATOLIAN HIEROGLYPH A329A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14572':{ u:'14572', i:24356, name:'ANATOLIAN HIEROGLYPH A330', cat:c.Lo,   canon:k._0, block:b[253]},
			'14573':{ u:'14573', i:24357, name:'ANATOLIAN HIEROGLYPH A331', cat:c.Lo,   canon:k._0, block:b[253]},
			'14574':{ u:'14574', i:24358, name:'ANATOLIAN HIEROGLYPH A332A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14575':{ u:'14575', i:24359, name:'ANATOLIAN HIEROGLYPH A332B', cat:c.Lo,   canon:k._0, block:b[253]},
			'14576':{ u:'14576', i:24360, name:'ANATOLIAN HIEROGLYPH A332C', cat:c.Lo,   canon:k._0, block:b[253]},
			'14577':{ u:'14577', i:24361, name:'ANATOLIAN HIEROGLYPH A333', cat:c.Lo,   canon:k._0, block:b[253]},
			'14578':{ u:'14578', i:24362, name:'ANATOLIAN HIEROGLYPH A334', cat:c.Lo,   canon:k._0, block:b[253]},
			'14579':{ u:'14579', i:24363, name:'ANATOLIAN HIEROGLYPH A335', cat:c.Lo,   canon:k._0, block:b[253]},
			'14580':{ u:'14580', i:24370, name:'ANATOLIAN HIEROGLYPH A339', cat:c.Lo,   canon:k._0, block:b[253]},
			'14581':{ u:'14581', i:24371, name:'ANATOLIAN HIEROGLYPH A340', cat:c.Lo,   canon:k._0, block:b[253]},
			'14582':{ u:'14582', i:24372, name:'ANATOLIAN HIEROGLYPH A341', cat:c.Lo,   canon:k._0, block:b[253]},
			'14583':{ u:'14583', i:24373, name:'ANATOLIAN HIEROGLYPH A342', cat:c.Lo,   canon:k._0, block:b[253]},
			'14584':{ u:'14584', i:24374, name:'ANATOLIAN HIEROGLYPH A343', cat:c.Lo,   canon:k._0, block:b[253]},
			'14585':{ u:'14585', i:24375, name:'ANATOLIAN HIEROGLYPH A344', cat:c.Lo,   canon:k._0, block:b[253]},
			'14586':{ u:'14586', i:24376, name:'ANATOLIAN HIEROGLYPH A345', cat:c.Lo,   canon:k._0, block:b[253]},
			'14587':{ u:'14587', i:24377, name:'ANATOLIAN HIEROGLYPH A346', cat:c.Lo,   canon:k._0, block:b[253]},
			'14588':{ u:'14588', i:24378, name:'ANATOLIAN HIEROGLYPH A347', cat:c.Lo,   canon:k._0, block:b[253]},
			'14589':{ u:'14589', i:24379, name:'ANATOLIAN HIEROGLYPH A348', cat:c.Lo,   canon:k._0, block:b[253]},
			'14590':{ u:'14590', i:24386, name:'ANATOLIAN HIEROGLYPH A355', cat:c.Lo,   canon:k._0, block:b[253]},
			'14591':{ u:'14591', i:24387, name:'ANATOLIAN HIEROGLYPH A356', cat:c.Lo,   canon:k._0, block:b[253]},
			'14592':{ u:'14592', i:24388, name:'ANATOLIAN HIEROGLYPH A357', cat:c.Lo,   canon:k._0, block:b[253]},
			'14593':{ u:'14593', i:24389, name:'ANATOLIAN HIEROGLYPH A358', cat:c.Lo,   canon:k._0, block:b[253]},
			'14594':{ u:'14594', i:24390, name:'ANATOLIAN HIEROGLYPH A359', cat:c.Lo,   canon:k._0, block:b[253]},
			'14595':{ u:'14595', i:24391, name:'ANATOLIAN HIEROGLYPH A359A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14596':{ u:'14596', i:24392, name:'ANATOLIAN HIEROGLYPH A360', cat:c.Lo,   canon:k._0, block:b[253]},
			'14597':{ u:'14597', i:24393, name:'ANATOLIAN HIEROGLYPH A361', cat:c.Lo,   canon:k._0, block:b[253]},
			'14598':{ u:'14598', i:24394, name:'ANATOLIAN HIEROGLYPH A362', cat:c.Lo,   canon:k._0, block:b[253]},
			'14599':{ u:'14599', i:24395, name:'ANATOLIAN HIEROGLYPH A363', cat:c.Lo,   canon:k._0, block:b[253]},
			'14600':{ u:'14600', i:24498, name:'ANATOLIAN HIEROGLYPH A457A', cat:c.Lo,   canon:k._0, block:b[253]},
			'14601':{ u:'14601', i:24499, name:'ANATOLIAN HIEROGLYPH A458', cat:c.Lo,   canon:k._0, block:b[253]},
			'14602':{ u:'14602', i:24500, name:'ANATOLIAN HIEROGLYPH A459', cat:c.Lo,   canon:k._0, block:b[253]},
			'14603':{ u:'14603', i:24501, name:'ANATOLIAN HIEROGLYPH A460', cat:c.Lo,   canon:k._0, block:b[253]},
			'14604':{ u:'14604', i:24502, name:'ANATOLIAN HIEROGLYPH A461', cat:c.Lo,   canon:k._0, block:b[253]},
			'14605':{ u:'14605', i:24503, name:'ANATOLIAN HIEROGLYPH A462', cat:c.Lo,   canon:k._0, block:b[253]},
			'14606':{ u:'14606', i:24504, name:'ANATOLIAN HIEROGLYPH A463', cat:c.Lo,   canon:k._0, block:b[253]},
			'14607':{ u:'14607', i:24505, name:'ANATOLIAN HIEROGLYPH A464', cat:c.Lo,   canon:k._0, block:b[253]},
			'14608':{ u:'14608', i:24506, name:'ANATOLIAN HIEROGLYPH A465', cat:c.Lo,   canon:k._0, block:b[253]},
			'14609':{ u:'14609', i:24507, name:'ANATOLIAN HIEROGLYPH A466', cat:c.Lo,   canon:k._0, block:b[253]},
			'14610':{ u:'14610', i:24514, name:'ANATOLIAN HIEROGLYPH A473', cat:c.Lo,   canon:k._0, block:b[253]},
			'14611':{ u:'14611', i:24515, name:'ANATOLIAN HIEROGLYPH A474', cat:c.Lo,   canon:k._0, block:b[253]},
			'14612':{ u:'14612', i:24516, name:'ANATOLIAN HIEROGLYPH A475', cat:c.Lo,   canon:k._0, block:b[253]},
			'14613':{ u:'14613', i:24517, name:'ANATOLIAN HIEROGLYPH A476', cat:c.Lo,   canon:k._0, block:b[253]},
			'14614':{ u:'14614', i:24518, name:'ANATOLIAN HIEROGLYPH A477', cat:c.Lo,   canon:k._0, block:b[253]},
			'14615':{ u:'14615', i:24519, name:'ANATOLIAN HIEROGLYPH A478', cat:c.Lo,   canon:k._0, block:b[253]},
			'14616':{ u:'14616', i:24520, name:'ANATOLIAN HIEROGLYPH A479', cat:c.Lo,   canon:k._0, block:b[253]},
			'14617':{ u:'14617', i:24521, name:'ANATOLIAN HIEROGLYPH A480', cat:c.Lo,   canon:k._0, block:b[253]},
			'14618':{ u:'14618', i:24522, name:'ANATOLIAN HIEROGLYPH A481', cat:c.Lo,   canon:k._0, block:b[253]},
			'14619':{ u:'14619', i:24523, name:'ANATOLIAN HIEROGLYPH A482', cat:c.Lo,   canon:k._0, block:b[253]},
			'14620':{ u:'14620', i:24530, name:'ANATOLIAN HIEROGLYPH A489', cat:c.Lo,   canon:k._0, block:b[253]},
			'14621':{ u:'14621', i:24531, name:'ANATOLIAN HIEROGLYPH A490', cat:c.Lo,   canon:k._0, block:b[253]},
			'14622':{ u:'14622', i:24532, name:'ANATOLIAN HIEROGLYPH A491', cat:c.Lo,   canon:k._0, block:b[253]},
			'14623':{ u:'14623', i:24533, name:'ANATOLIAN HIEROGLYPH A492', cat:c.Lo,   canon:k._0, block:b[253]},
			'14624':{ u:'14624', i:24534, name:'ANATOLIAN HIEROGLYPH A493', cat:c.Lo,   canon:k._0, block:b[253]},
			'14625':{ u:'14625', i:24535, name:'ANATOLIAN HIEROGLYPH A494', cat:c.Lo,   canon:k._0, block:b[253]},
			'14626':{ u:'14626', i:24536, name:'ANATOLIAN HIEROGLYPH A495', cat:c.Lo,   canon:k._0, block:b[253]},
			'14627':{ u:'14627', i:24537, name:'ANATOLIAN HIEROGLYPH A496', cat:c.Lo,   canon:k._0, block:b[253]},
			'14628':{ u:'14628', i:24538, name:'ANATOLIAN HIEROGLYPH A497', cat:c.Lo,   canon:k._0, block:b[253]},
			'14629':{ u:'14629', i:24539, name:'ANATOLIAN HIEROGLYPH A501', cat:c.Lo,   canon:k._0, block:b[253]},
			'14630':{ u:'14630', i:24546, name:'ANATOLIAN HIEROGLYPH A508', cat:c.Lo,   canon:k._0, block:b[253]},
			'14631':{ u:'14631', i:24547, name:'ANATOLIAN HIEROGLYPH A509', cat:c.Lo,   canon:k._0, block:b[253]},
			'14632':{ u:'14632', i:24548, name:'ANATOLIAN HIEROGLYPH A510', cat:c.Lo,   canon:k._0, block:b[253]},
			'14633':{ u:'14633', i:24549, name:'ANATOLIAN HIEROGLYPH A511', cat:c.Lo,   canon:k._0, block:b[253]},
			'14634':{ u:'14634', i:24550, name:'ANATOLIAN HIEROGLYPH A512', cat:c.Lo,   canon:k._0, block:b[253]},
			'14635':{ u:'14635', i:24551, name:'ANATOLIAN HIEROGLYPH A513', cat:c.Lo,   canon:k._0, block:b[253]},
			'14636':{ u:'14636', i:24552, name:'ANATOLIAN HIEROGLYPH A514', cat:c.Lo,   canon:k._0, block:b[253]},
			'14637':{ u:'14637', i:24553, name:'ANATOLIAN HIEROGLYPH A515', cat:c.Lo,   canon:k._0, block:b[253]},
			'14638':{ u:'14638', i:24554, name:'ANATOLIAN HIEROGLYPH A516', cat:c.Lo,   canon:k._0, block:b[253]},
			'14639':{ u:'14639', i:24555, name:'ANATOLIAN HIEROGLYPH A517', cat:c.Lo,   canon:k._0, block:b[253]},
			'14640':{ u:'14640', i:24562, name:'ANATOLIAN HIEROGLYPH A524', cat:c.Lo,   canon:k._0, block:b[253]},
			'14641':{ u:'14641', i:24563, name:'ANATOLIAN HIEROGLYPH A525', cat:c.Lo,   canon:k._0, block:b[253]},
			'14642':{ u:'14642', i:24564, name:'ANATOLIAN HIEROGLYPH A526', cat:c.Lo,   canon:k._0, block:b[253]},
			'14643':{ u:'14643', i:24565, name:'ANATOLIAN HIEROGLYPH A527', cat:c.Lo,   canon:k._0, block:b[253]},
			'14644':{ u:'14644', i:24566, name:'ANATOLIAN HIEROGLYPH A528', cat:c.Lo,   canon:k._0, block:b[253]},
			'14645':{ u:'14645', i:24567, name:'ANATOLIAN HIEROGLYPH A529', cat:c.Lo,   canon:k._0, block:b[253]},
			'14646':{ u:'14646', i:24568, name:'ANATOLIAN HIEROGLYPH A530', cat:c.Lo,   canon:k._0, block:b[253]},
			'16800':{ u:'16800', i:24569, name:'BAMUM LETTER PHASE-A NGKUE MFON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16801':{ u:'16801', i:24570, name:'BAMUM LETTER PHASE-A GBIEE FON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16802':{ u:'16802', i:24571, name:'BAMUM LETTER PHASE-A PON MFON PIPAEMGBIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16803':{ u:'16803', i:24572, name:'BAMUM LETTER PHASE-A PON MFON PIPAEMBA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16804':{ u:'16804', i:24573, name:'BAMUM LETTER PHASE-A NAA MFON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16805':{ u:'16805', i:24574, name:'BAMUM LETTER PHASE-A SHUENSHUET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16806':{ u:'16806', i:24575, name:'BAMUM LETTER PHASE-A TITA MFON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16807':{ u:'16807', i:24576, name:'BAMUM LETTER PHASE-A NZA MFON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16808':{ u:'16808', i:24577, name:'BAMUM LETTER PHASE-A SHINDA PA NJI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16809':{ u:'16809', i:24578, name:'BAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16810':{ u:'16810', i:24585, name:'BAMUM LETTER PHASE-A MVEUAENGAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16811':{ u:'16811', i:24586, name:'BAMUM LETTER PHASE-A SEUNYAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16812':{ u:'16812', i:24587, name:'BAMUM LETTER PHASE-A NTOQPEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16813':{ u:'16813', i:24588, name:'BAMUM LETTER PHASE-A KEUKEUTNDA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16814':{ u:'16814', i:24589, name:'BAMUM LETTER PHASE-A NKINDI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16815':{ u:'16815', i:24590, name:'BAMUM LETTER PHASE-A SUU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16816':{ u:'16816', i:24591, name:'BAMUM LETTER PHASE-A NGKUENZEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16817':{ u:'16817', i:24592, name:'BAMUM LETTER PHASE-A LAPAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16818':{ u:'16818', i:24593, name:'BAMUM LETTER PHASE-A LET KUT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16819':{ u:'16819', i:24594, name:'BAMUM LETTER PHASE-A NTAP MFAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16820':{ u:'16820', i:24601, name:'BAMUM LETTER PHASE-A U YUQ NAE', cat:c.Lo,   canon:k._0, block:b[254], indexed:["U"]},
			'16821':{ u:'16821', i:24602, name:'BAMUM LETTER PHASE-A GHEUAEGHEUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16822':{ u:'16822', i:24603, name:'BAMUM LETTER PHASE-A NTAP NTAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16823':{ u:'16823', i:24604, name:'BAMUM LETTER PHASE-A SISA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16824':{ u:'16824', i:24605, name:'BAMUM LETTER PHASE-A MGBASA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16825':{ u:'16825', i:24606, name:'BAMUM LETTER PHASE-A MEUNJOMNDEUQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16826':{ u:'16826', i:24607, name:'BAMUM LETTER PHASE-A MOOMPUQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16827':{ u:'16827', i:24608, name:'BAMUM LETTER PHASE-A KAFA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16828':{ u:'16828', i:24609, name:'BAMUM LETTER PHASE-A PA LEERAEWA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16829':{ u:'16829', i:24610, name:'BAMUM LETTER PHASE-A NDA LEERAEWA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16830':{ u:'16830', i:24617, name:'BAMUM LETTER PHASE-A SONJAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16831':{ u:'16831', i:24618, name:'BAMUM LETTER PHASE-A TEUTEUWEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16832':{ u:'16832', i:24619, name:'BAMUM LETTER PHASE-A MAENYI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16833':{ u:'16833', i:24620, name:'BAMUM LETTER PHASE-A KET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16834':{ u:'16834', i:24621, name:'BAMUM LETTER PHASE-A NDAANGGEUAET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16835':{ u:'16835', i:24622, name:'BAMUM LETTER PHASE-A KUOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16836':{ u:'16836', i:24623, name:'BAMUM LETTER PHASE-A MOOMEUT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16837':{ u:'16837', i:24624, name:'BAMUM LETTER PHASE-A SHUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16838':{ u:'16838', i:24625, name:'BAMUM LETTER PHASE-A LOMMAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16839':{ u:'16839', i:24626, name:'BAMUM LETTER PHASE-A FIRI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16840':{ u:'16840', i:24633, name:'BAMUM LETTER PHASE-A SHOQ NSHUT YUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16841':{ u:'16841', i:24634, name:'BAMUM LETTER PHASE-A NYIT MONGKEUAEQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16842':{ u:'16842', i:24635, name:'BAMUM LETTER PHASE-A PAARAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16843':{ u:'16843', i:24636, name:'BAMUM LETTER PHASE-A NKAARAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16844':{ u:'16844', i:24637, name:'BAMUM LETTER PHASE-A UNKNOWN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16845':{ u:'16845', i:24638, name:'BAMUM LETTER PHASE-A NGGEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16846':{ u:'16846', i:24639, name:'BAMUM LETTER PHASE-A MAESI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16847':{ u:'16847', i:24640, name:'BAMUM LETTER PHASE-A NJAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16848':{ u:'16848', i:24641, name:'BAMUM LETTER PHASE-A MBANYI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16849':{ u:'16849', i:24642, name:'BAMUM LETTER PHASE-A NYET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16850':{ u:'16850', i:24649, name:'BAMUM LETTER PHASE-A KAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16851':{ u:'16851', i:24650, name:'BAMUM LETTER PHASE-A NSHA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16852':{ u:'16852', i:24651, name:'BAMUM LETTER PHASE-A VEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16853':{ u:'16853', i:24652, name:'BAMUM LETTER PHASE-A LU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16854':{ u:'16854', i:24653, name:'BAMUM LETTER PHASE-A NEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16855':{ u:'16855', i:24654, name:'BAMUM LETTER PHASE-A NAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16856':{ u:'16856', i:24655, name:'BAMUM LETTER PHASE-A MBAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16857':{ u:'16857', i:24656, name:'BAMUM LETTER PHASE-B NSHUET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16858':{ u:'16858', i:24657, name:'BAMUM LETTER PHASE-B TU MAEMGBIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16859':{ u:'16859', i:24658, name:'BAMUM LETTER PHASE-B SIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16860':{ u:'16860', i:24665, name:'BAMUM LETTER PHASE-B KAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16861':{ u:'16861', i:24666, name:'BAMUM LETTER PHASE-B PEESHI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16862':{ u:'16862', i:24667, name:'BAMUM LETTER PHASE-B YAFU LEERAEWA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16863':{ u:'16863', i:24668, name:'BAMUM LETTER PHASE-B LAM NSHUT NYAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16864':{ u:'16864', i:24669, name:'BAMUM LETTER PHASE-B NTIEE SHEUOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16865':{ u:'16865', i:24670, name:'BAMUM LETTER PHASE-B NDU NJAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16866':{ u:'16866', i:24671, name:'BAMUM LETTER PHASE-B GHEUGHEUAEM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16867':{ u:'16867', i:24672, name:'BAMUM LETTER PHASE-B PIT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16868':{ u:'16868', i:24673, name:'BAMUM LETTER PHASE-B TU NSIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16869':{ u:'16869', i:24674, name:'BAMUM LETTER PHASE-B SHET NJAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16870':{ u:'16870', i:24681, name:'BAMUM LETTER PHASE-B KEUYEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16871':{ u:'16871', i:24682, name:'BAMUM LETTER PHASE-B LAANAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16872':{ u:'16872', i:24683, name:'BAMUM LETTER PHASE-B PARUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16873':{ u:'16873', i:24684, name:'BAMUM LETTER PHASE-B VEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16874':{ u:'16874', i:24685, name:'BAMUM LETTER PHASE-B NGKINDI MVOP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16875':{ u:'16875', i:24686, name:'BAMUM LETTER PHASE-B NGGEU MBU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16876':{ u:'16876', i:24687, name:'BAMUM LETTER PHASE-B WUAET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16877':{ u:'16877', i:24688, name:'BAMUM LETTER PHASE-B SAKEUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16878':{ u:'16878', i:24689, name:'BAMUM LETTER PHASE-B TAAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16879':{ u:'16879', i:24690, name:'BAMUM LETTER PHASE-B MEUQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16880':{ u:'16880', i:24697, name:'BAMUM LETTER PHASE-B NYAEMAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16881':{ u:'16881', i:24698, name:'BAMUM LETTER PHASE-B PUNGAAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16882':{ u:'16882', i:24699, name:'BAMUM LETTER PHASE-B MEUT NGGEET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16883':{ u:'16883', i:24700, name:'BAMUM LETTER PHASE-B FEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16884':{ u:'16884', i:24701, name:'BAMUM LETTER PHASE-B MBUOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16885':{ u:'16885', i:24702, name:'BAMUM LETTER PHASE-B FEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16886':{ u:'16886', i:24703, name:'BAMUM LETTER PHASE-B KEUAEM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16887':{ u:'16887', i:24704, name:'BAMUM LETTER PHASE-B MA NJEUAENA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16888':{ u:'16888', i:24705, name:'BAMUM LETTER PHASE-B MA NJUQA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16889':{ u:'16889', i:24706, name:'BAMUM LETTER PHASE-B LET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16890':{ u:'16890', i:24713, name:'BAMUM LETTER PHASE-C NZA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16891':{ u:'16891', i:24714, name:'BAMUM LETTER PHASE-C YUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16892':{ u:'16892', i:24715, name:'BAMUM LETTER PHASE-C WANGKUOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16893':{ u:'16893', i:24716, name:'BAMUM LETTER PHASE-C NGGEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16894':{ u:'16894', i:24717, name:'BAMUM LETTER PHASE-C NDEUAEREE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16895':{ u:'16895', i:24718, name:'BAMUM LETTER PHASE-C NGKAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16896':{ u:'16896', i:24719, name:'BAMUM LETTER PHASE-C GHARAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16897':{ u:'16897', i:24720, name:'BAMUM LETTER PHASE-C MBEEKEET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16898':{ u:'16898', i:24721, name:'BAMUM LETTER PHASE-C GBAYI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16899':{ u:'16899', i:24722, name:'BAMUM LETTER PHASE-C NYIR MKPARAQ MEUN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16900':{ u:'16900', i:24825, name:'BAMUM LETTER PHASE-D TEUT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16901':{ u:'16901', i:24826, name:'BAMUM LETTER PHASE-D SHEUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16902':{ u:'16902', i:24827, name:'BAMUM LETTER PHASE-D NJAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16903':{ u:'16903', i:24828, name:'BAMUM LETTER PHASE-D SUE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16904':{ u:'16904', i:24829, name:'BAMUM LETTER PHASE-D KET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16905':{ u:'16905', i:24830, name:'BAMUM LETTER PHASE-D YAEMMAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16906':{ u:'16906', i:24831, name:'BAMUM LETTER PHASE-D KUOM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16907':{ u:'16907', i:24832, name:'BAMUM LETTER PHASE-D SAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16908':{ u:'16908', i:24833, name:'BAMUM LETTER PHASE-D MFEUT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16909':{ u:'16909', i:24834, name:'BAMUM LETTER PHASE-D NDEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16910':{ u:'16910', i:24841, name:'BAMUM LETTER PHASE-D NGKEURI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16911':{ u:'16911', i:24842, name:'BAMUM LETTER PHASE-D TU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16912':{ u:'16912', i:24843, name:'BAMUM LETTER PHASE-D GHAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16913':{ u:'16913', i:24844, name:'BAMUM LETTER PHASE-D NGKYEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16914':{ u:'16914', i:24845, name:'BAMUM LETTER PHASE-D FEUFEUAET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16915':{ u:'16915', i:24846, name:'BAMUM LETTER PHASE-D NDEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16916':{ u:'16916', i:24847, name:'BAMUM LETTER PHASE-D MGBOFUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16917':{ u:'16917', i:24848, name:'BAMUM LETTER PHASE-D LEUAEP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16918':{ u:'16918', i:24849, name:'BAMUM LETTER PHASE-D NDON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16919':{ u:'16919', i:24850, name:'BAMUM LETTER PHASE-D MONI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16920':{ u:'16920', i:24857, name:'BAMUM LETTER PHASE-D MBAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16921':{ u:'16921', i:24858, name:'BAMUM LETTER PHASE-D KWAET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16922':{ u:'16922', i:24859, name:'BAMUM LETTER PHASE-D NYET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16923':{ u:'16923', i:24860, name:'BAMUM LETTER PHASE-D TEUAEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16924':{ u:'16924', i:24861, name:'BAMUM LETTER PHASE-D SOT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16925':{ u:'16925', i:24862, name:'BAMUM LETTER PHASE-D YUWOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16926':{ u:'16926', i:24863, name:'BAMUM LETTER PHASE-D KEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16927':{ u:'16927', i:24864, name:'BAMUM LETTER PHASE-D RAEM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16928':{ u:'16928', i:24865, name:'BAMUM LETTER PHASE-D TEEEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16929':{ u:'16929', i:24866, name:'BAMUM LETTER PHASE-D NGKEUAEQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16930':{ u:'16930', i:24873, name:'BAMUM LETTER PHASE-D LET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16931':{ u:'16931', i:24874, name:'BAMUM LETTER PHASE-D NGGAAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16932':{ u:'16932', i:24875, name:'BAMUM LETTER PHASE-D MFIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16933':{ u:'16933', i:24876, name:'BAMUM LETTER PHASE-D NGGWAEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16934':{ u:'16934', i:24877, name:'BAMUM LETTER PHASE-D YUOM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16935':{ u:'16935', i:24878, name:'BAMUM LETTER PHASE-D PAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16936':{ u:'16936', i:24879, name:'BAMUM LETTER PHASE-D YUOP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16937':{ u:'16937', i:24880, name:'BAMUM LETTER PHASE-D NDAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16938':{ u:'16938', i:24881, name:'BAMUM LETTER PHASE-D NTEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16939':{ u:'16939', i:24882, name:'BAMUM LETTER PHASE-D SUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16940':{ u:'16940', i:24889, name:'BAMUM LETTER PHASE-D NSUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16941':{ u:'16941', i:24890, name:'BAMUM LETTER PHASE-D TEUN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16942':{ u:'16942', i:24891, name:'BAMUM LETTER PHASE-D MAENJET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16943':{ u:'16943', i:24892, name:'BAMUM LETTER PHASE-D NGGAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16944':{ u:'16944', i:24893, name:'BAMUM LETTER PHASE-D LEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16945':{ u:'16945', i:24894, name:'BAMUM LETTER PHASE-D NGGUOM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16946':{ u:'16946', i:24895, name:'BAMUM LETTER PHASE-D NSHUT', cat:c.Lo,   canon:k._0, block:b[254]},
			'16947':{ u:'16947', i:24896, name:'BAMUM LETTER PHASE-D NJUEQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16948':{ u:'16948', i:24897, name:'BAMUM LETTER PHASE-D GHEUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16949':{ u:'16949', i:24898, name:'BAMUM LETTER PHASE-D KU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16950':{ u:'16950', i:24905, name:'BAMUM LETTER PHASE-D MEEEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16951':{ u:'16951', i:24906, name:'BAMUM LETTER PHASE-D M', cat:c.Lo,   canon:k._0, block:b[254], indexed:["M"]},
			'16952':{ u:'16952', i:24907, name:'BAMUM LETTER PHASE-D SUU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16953':{ u:'16953', i:24908, name:'BAMUM LETTER PHASE-D MU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16954':{ u:'16954', i:24909, name:'BAMUM LETTER PHASE-D SHII', cat:c.Lo,   canon:k._0, block:b[254]},
			'16955':{ u:'16955', i:24910, name:'BAMUM LETTER PHASE-D SHEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16956':{ u:'16956', i:24911, name:'BAMUM LETTER PHASE-D KYEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16957':{ u:'16957', i:24912, name:'BAMUM LETTER PHASE-D NU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16958':{ u:'16958', i:24913, name:'BAMUM LETTER PHASE-D SHU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16959':{ u:'16959', i:24914, name:'BAMUM LETTER PHASE-D NTEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16960':{ u:'16960', i:24921, name:'BAMUM LETTER PHASE-D REN MUCH', cat:c.Lo,   canon:k._0, block:b[254]},
			'16961':{ u:'16961', i:24922, name:'BAMUM LETTER PHASE-D TI', cat:c.Lo,   canon:k._0, block:b[254]},
			'16962':{ u:'16962', i:24923, name:'BAMUM LETTER PHASE-D NTUU', cat:c.Lo,   canon:k._0, block:b[254]},
			'16963':{ u:'16963', i:24924, name:'BAMUM LETTER PHASE-D MBAA SEVEN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16964':{ u:'16964', i:24925, name:'BAMUM LETTER PHASE-D SAQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16965':{ u:'16965', i:24926, name:'BAMUM LETTER PHASE-D FAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16966':{ u:'16966', i:24927, name:'BAMUM LETTER PHASE-E NDAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16967':{ u:'16967', i:24928, name:'BAMUM LETTER PHASE-E TOON', cat:c.Lo,   canon:k._0, block:b[254]},
			'16968':{ u:'16968', i:24929, name:'BAMUM LETTER PHASE-E MBEUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16969':{ u:'16969', i:24930, name:'BAMUM LETTER PHASE-E LAP', cat:c.Lo,   canon:k._0, block:b[254]},
			'16970':{ u:'16970', i:24937, name:'BAMUM LETTER PHASE-E NDUN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16971':{ u:'16971', i:24938, name:'BAMUM LETTER PHASE-E PUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16972':{ u:'16972', i:24939, name:'BAMUM LETTER PHASE-E TAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16973':{ u:'16973', i:24940, name:'BAMUM LETTER PHASE-E NGKA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16974':{ u:'16974', i:24941, name:'BAMUM LETTER PHASE-E KPEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16975':{ u:'16975', i:24942, name:'BAMUM LETTER PHASE-E WUO', cat:c.Lo,   canon:k._0, block:b[254]},
			'16976':{ u:'16976', i:24943, name:'BAMUM LETTER PHASE-E SEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16977':{ u:'16977', i:24944, name:'BAMUM LETTER PHASE-E NGGEUAET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16978':{ u:'16978', i:24945, name:'BAMUM LETTER PHASE-E PAAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16979':{ u:'16979', i:24946, name:'BAMUM LETTER PHASE-E TOO', cat:c.Lo,   canon:k._0, block:b[254]},
			'16980':{ u:'16980', i:24953, name:'BAMUM LETTER PHASE-E NGOQ', cat:c.Lo,   canon:k._0, block:b[254]},
			'16981':{ u:'16981', i:24954, name:'BAMUM LETTER PHASE-E NSHUE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16982':{ u:'16982', i:24955, name:'BAMUM LETTER PHASE-E RIMGBA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16983':{ u:'16983', i:24956, name:'BAMUM LETTER PHASE-E NJEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16984':{ u:'16984', i:24957, name:'BAMUM LETTER PHASE-E PEEM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16985':{ u:'16985', i:24958, name:'BAMUM LETTER PHASE-E SAA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16986':{ u:'16986', i:24959, name:'BAMUM LETTER PHASE-E NGGURAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16987':{ u:'16987', i:24960, name:'BAMUM LETTER PHASE-E MGBA', cat:c.Lo,   canon:k._0, block:b[254]},
			'16988':{ u:'16988', i:24961, name:'BAMUM LETTER PHASE-E GHEUX', cat:c.Lo,   canon:k._0, block:b[254]},
			'16989':{ u:'16989', i:24962, name:'BAMUM LETTER PHASE-E NGKEUAEM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16990':{ u:'16990', i:24969, name:'BAMUM LETTER PHASE-E SET', cat:c.Lo,   canon:k._0, block:b[254]},
			'16991':{ u:'16991', i:24970, name:'BAMUM LETTER PHASE-E PUM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16992':{ u:'16992', i:24971, name:'BAMUM LETTER PHASE-E NDAA SOFTNESS', cat:c.Lo,   canon:k._0, block:b[254]},
			'16993':{ u:'16993', i:24972, name:'BAMUM LETTER PHASE-E NGGUAESHAE NYAM', cat:c.Lo,   canon:k._0, block:b[254]},
			'16994':{ u:'16994', i:24973, name:'BAMUM LETTER PHASE-E YIEE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16995':{ u:'16995', i:24974, name:'BAMUM LETTER PHASE-E GHEUN', cat:c.Lo,   canon:k._0, block:b[254]},
			'16996':{ u:'16996', i:24975, name:'BAMUM LETTER PHASE-E TUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16997':{ u:'16997', i:24976, name:'BAMUM LETTER PHASE-E YEUAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'16998':{ u:'16998', i:24977, name:'BAMUM LETTER PHASE-E PO', cat:c.Lo,   canon:k._0, block:b[254]},
			'16999':{ u:'16999', i:24978, name:'BAMUM LETTER PHASE-E TUMAE', cat:c.Lo,   canon:k._0, block:b[254]},
			'17000':{ u:'17000', i:25680, name:'<Tangut Ideograph, First>', cat:c.Lo,   canon:k._0, block:b[262]},
			'18800':{ u:'18800', i:25682, name:'TANGUT COMPONENT-001', cat:c.Lo,   canon:k._0, block:b[263]},
			'18801':{ u:'18801', i:25683, name:'TANGUT COMPONENT-002', cat:c.Lo,   canon:k._0, block:b[263]},
			'18802':{ u:'18802', i:25684, name:'TANGUT COMPONENT-003', cat:c.Lo,   canon:k._0, block:b[263]},
			'18803':{ u:'18803', i:25685, name:'TANGUT COMPONENT-004', cat:c.Lo,   canon:k._0, block:b[263]},
			'18804':{ u:'18804', i:25686, name:'TANGUT COMPONENT-005', cat:c.Lo,   canon:k._0, block:b[263]},
			'18805':{ u:'18805', i:25687, name:'TANGUT COMPONENT-006', cat:c.Lo,   canon:k._0, block:b[263]},
			'18806':{ u:'18806', i:25688, name:'TANGUT COMPONENT-007', cat:c.Lo,   canon:k._0, block:b[263]},
			'18807':{ u:'18807', i:25689, name:'TANGUT COMPONENT-008', cat:c.Lo,   canon:k._0, block:b[263]},
			'18808':{ u:'18808', i:25690, name:'TANGUT COMPONENT-009', cat:c.Lo,   canon:k._0, block:b[263]},
			'18809':{ u:'18809', i:25691, name:'TANGUT COMPONENT-010', cat:c.Lo,   canon:k._0, block:b[263]},
			'18810':{ u:'18810', i:25698, name:'TANGUT COMPONENT-017', cat:c.Lo,   canon:k._0, block:b[263]},
			'18811':{ u:'18811', i:25699, name:'TANGUT COMPONENT-018', cat:c.Lo,   canon:k._0, block:b[263]},
			'18812':{ u:'18812', i:25700, name:'TANGUT COMPONENT-019', cat:c.Lo,   canon:k._0, block:b[263]},
			'18813':{ u:'18813', i:25701, name:'TANGUT COMPONENT-020', cat:c.Lo,   canon:k._0, block:b[263]},
			'18814':{ u:'18814', i:25702, name:'TANGUT COMPONENT-021', cat:c.Lo,   canon:k._0, block:b[263]},
			'18815':{ u:'18815', i:25703, name:'TANGUT COMPONENT-022', cat:c.Lo,   canon:k._0, block:b[263]},
			'18816':{ u:'18816', i:25704, name:'TANGUT COMPONENT-023', cat:c.Lo,   canon:k._0, block:b[263]},
			'18817':{ u:'18817', i:25705, name:'TANGUT COMPONENT-024', cat:c.Lo,   canon:k._0, block:b[263]},
			'18818':{ u:'18818', i:25706, name:'TANGUT COMPONENT-025', cat:c.Lo,   canon:k._0, block:b[263]},
			'18819':{ u:'18819', i:25707, name:'TANGUT COMPONENT-026', cat:c.Lo,   canon:k._0, block:b[263]},
			'18820':{ u:'18820', i:25714, name:'TANGUT COMPONENT-033', cat:c.Lo,   canon:k._0, block:b[263]},
			'18821':{ u:'18821', i:25715, name:'TANGUT COMPONENT-034', cat:c.Lo,   canon:k._0, block:b[263]},
			'18822':{ u:'18822', i:25716, name:'TANGUT COMPONENT-035', cat:c.Lo,   canon:k._0, block:b[263]},
			'18823':{ u:'18823', i:25717, name:'TANGUT COMPONENT-036', cat:c.Lo,   canon:k._0, block:b[263]},
			'18824':{ u:'18824', i:25718, name:'TANGUT COMPONENT-037', cat:c.Lo,   canon:k._0, block:b[263]},
			'18825':{ u:'18825', i:25719, name:'TANGUT COMPONENT-038', cat:c.Lo,   canon:k._0, block:b[263]},
			'18826':{ u:'18826', i:25720, name:'TANGUT COMPONENT-039', cat:c.Lo,   canon:k._0, block:b[263]},
			'18827':{ u:'18827', i:25721, name:'TANGUT COMPONENT-040', cat:c.Lo,   canon:k._0, block:b[263]},
			'18828':{ u:'18828', i:25722, name:'TANGUT COMPONENT-041', cat:c.Lo,   canon:k._0, block:b[263]},
			'18829':{ u:'18829', i:25723, name:'TANGUT COMPONENT-042', cat:c.Lo,   canon:k._0, block:b[263]},
			'18830':{ u:'18830', i:25730, name:'TANGUT COMPONENT-049', cat:c.Lo,   canon:k._0, block:b[263]},
			'18831':{ u:'18831', i:25731, name:'TANGUT COMPONENT-050', cat:c.Lo,   canon:k._0, block:b[263]},
			'18832':{ u:'18832', i:25732, name:'TANGUT COMPONENT-051', cat:c.Lo,   canon:k._0, block:b[263]},
			'18833':{ u:'18833', i:25733, name:'TANGUT COMPONENT-052', cat:c.Lo,   canon:k._0, block:b[263]},
			'18834':{ u:'18834', i:25734, name:'TANGUT COMPONENT-053', cat:c.Lo,   canon:k._0, block:b[263]},
			'18835':{ u:'18835', i:25735, name:'TANGUT COMPONENT-054', cat:c.Lo,   canon:k._0, block:b[263]},
			'18836':{ u:'18836', i:25736, name:'TANGUT COMPONENT-055', cat:c.Lo,   canon:k._0, block:b[263]},
			'18837':{ u:'18837', i:25737, name:'TANGUT COMPONENT-056', cat:c.Lo,   canon:k._0, block:b[263]},
			'18838':{ u:'18838', i:25738, name:'TANGUT COMPONENT-057', cat:c.Lo,   canon:k._0, block:b[263]},
			'18839':{ u:'18839', i:25739, name:'TANGUT COMPONENT-058', cat:c.Lo,   canon:k._0, block:b[263]},
			'18840':{ u:'18840', i:25746, name:'TANGUT COMPONENT-065', cat:c.Lo,   canon:k._0, block:b[263]},
			'18841':{ u:'18841', i:25747, name:'TANGUT COMPONENT-066', cat:c.Lo,   canon:k._0, block:b[263]},
			'18842':{ u:'18842', i:25748, name:'TANGUT COMPONENT-067', cat:c.Lo,   canon:k._0, block:b[263]},
			'18843':{ u:'18843', i:25749, name:'TANGUT COMPONENT-068', cat:c.Lo,   canon:k._0, block:b[263]},
			'18844':{ u:'18844', i:25750, name:'TANGUT COMPONENT-069', cat:c.Lo,   canon:k._0, block:b[263]},
			'18845':{ u:'18845', i:25751, name:'TANGUT COMPONENT-070', cat:c.Lo,   canon:k._0, block:b[263]},
			'18846':{ u:'18846', i:25752, name:'TANGUT COMPONENT-071', cat:c.Lo,   canon:k._0, block:b[263]},
			'18847':{ u:'18847', i:25753, name:'TANGUT COMPONENT-072', cat:c.Lo,   canon:k._0, block:b[263]},
			'18848':{ u:'18848', i:25754, name:'TANGUT COMPONENT-073', cat:c.Lo,   canon:k._0, block:b[263]},
			'18849':{ u:'18849', i:25755, name:'TANGUT COMPONENT-074', cat:c.Lo,   canon:k._0, block:b[263]},
			'18850':{ u:'18850', i:25762, name:'TANGUT COMPONENT-081', cat:c.Lo,   canon:k._0, block:b[263]},
			'18851':{ u:'18851', i:25763, name:'TANGUT COMPONENT-082', cat:c.Lo,   canon:k._0, block:b[263]},
			'18852':{ u:'18852', i:25764, name:'TANGUT COMPONENT-083', cat:c.Lo,   canon:k._0, block:b[263]},
			'18853':{ u:'18853', i:25765, name:'TANGUT COMPONENT-084', cat:c.Lo,   canon:k._0, block:b[263]},
			'18854':{ u:'18854', i:25766, name:'TANGUT COMPONENT-085', cat:c.Lo,   canon:k._0, block:b[263]},
			'18855':{ u:'18855', i:25767, name:'TANGUT COMPONENT-086', cat:c.Lo,   canon:k._0, block:b[263]},
			'18856':{ u:'18856', i:25768, name:'TANGUT COMPONENT-087', cat:c.Lo,   canon:k._0, block:b[263]},
			'18857':{ u:'18857', i:25769, name:'TANGUT COMPONENT-088', cat:c.Lo,   canon:k._0, block:b[263]},
			'18858':{ u:'18858', i:25770, name:'TANGUT COMPONENT-089', cat:c.Lo,   canon:k._0, block:b[263]},
			'18859':{ u:'18859', i:25771, name:'TANGUT COMPONENT-090', cat:c.Lo,   canon:k._0, block:b[263]},
			'18860':{ u:'18860', i:25778, name:'TANGUT COMPONENT-097', cat:c.Lo,   canon:k._0, block:b[263]},
			'18861':{ u:'18861', i:25779, name:'TANGUT COMPONENT-098', cat:c.Lo,   canon:k._0, block:b[263]},
			'18862':{ u:'18862', i:25780, name:'TANGUT COMPONENT-099', cat:c.Lo,   canon:k._0, block:b[263]},
			'18863':{ u:'18863', i:25781, name:'TANGUT COMPONENT-100', cat:c.Lo,   canon:k._0, block:b[263]},
			'18864':{ u:'18864', i:25782, name:'TANGUT COMPONENT-101', cat:c.Lo,   canon:k._0, block:b[263]},
			'18865':{ u:'18865', i:25783, name:'TANGUT COMPONENT-102', cat:c.Lo,   canon:k._0, block:b[263]},
			'18866':{ u:'18866', i:25784, name:'TANGUT COMPONENT-103', cat:c.Lo,   canon:k._0, block:b[263]},
			'18867':{ u:'18867', i:25785, name:'TANGUT COMPONENT-104', cat:c.Lo,   canon:k._0, block:b[263]},
			'18868':{ u:'18868', i:25786, name:'TANGUT COMPONENT-105', cat:c.Lo,   canon:k._0, block:b[263]},
			'18869':{ u:'18869', i:25787, name:'TANGUT COMPONENT-106', cat:c.Lo,   canon:k._0, block:b[263]},
			'18870':{ u:'18870', i:25794, name:'TANGUT COMPONENT-113', cat:c.Lo,   canon:k._0, block:b[263]},
			'18871':{ u:'18871', i:25795, name:'TANGUT COMPONENT-114', cat:c.Lo,   canon:k._0, block:b[263]},
			'18872':{ u:'18872', i:25796, name:'TANGUT COMPONENT-115', cat:c.Lo,   canon:k._0, block:b[263]},
			'18873':{ u:'18873', i:25797, name:'TANGUT COMPONENT-116', cat:c.Lo,   canon:k._0, block:b[263]},
			'18874':{ u:'18874', i:25798, name:'TANGUT COMPONENT-117', cat:c.Lo,   canon:k._0, block:b[263]},
			'18875':{ u:'18875', i:25799, name:'TANGUT COMPONENT-118', cat:c.Lo,   canon:k._0, block:b[263]},
			'18876':{ u:'18876', i:25800, name:'TANGUT COMPONENT-119', cat:c.Lo,   canon:k._0, block:b[263]},
			'18877':{ u:'18877', i:25801, name:'TANGUT COMPONENT-120', cat:c.Lo,   canon:k._0, block:b[263]},
			'18878':{ u:'18878', i:25802, name:'TANGUT COMPONENT-121', cat:c.Lo,   canon:k._0, block:b[263]},
			'18879':{ u:'18879', i:25803, name:'TANGUT COMPONENT-122', cat:c.Lo,   canon:k._0, block:b[263]},
			'18880':{ u:'18880', i:25810, name:'TANGUT COMPONENT-129', cat:c.Lo,   canon:k._0, block:b[263]},
			'18881':{ u:'18881', i:25811, name:'TANGUT COMPONENT-130', cat:c.Lo,   canon:k._0, block:b[263]},
			'18882':{ u:'18882', i:25812, name:'TANGUT COMPONENT-131', cat:c.Lo,   canon:k._0, block:b[263]},
			'18883':{ u:'18883', i:25813, name:'TANGUT COMPONENT-132', cat:c.Lo,   canon:k._0, block:b[263]},
			'18884':{ u:'18884', i:25814, name:'TANGUT COMPONENT-133', cat:c.Lo,   canon:k._0, block:b[263]},
			'18885':{ u:'18885', i:25815, name:'TANGUT COMPONENT-134', cat:c.Lo,   canon:k._0, block:b[263]},
			'18886':{ u:'18886', i:25816, name:'TANGUT COMPONENT-135', cat:c.Lo,   canon:k._0, block:b[263]},
			'18887':{ u:'18887', i:25817, name:'TANGUT COMPONENT-136', cat:c.Lo,   canon:k._0, block:b[263]},
			'18888':{ u:'18888', i:25818, name:'TANGUT COMPONENT-137', cat:c.Lo,   canon:k._0, block:b[263]},
			'18889':{ u:'18889', i:25819, name:'TANGUT COMPONENT-138', cat:c.Lo,   canon:k._0, block:b[263]},
			'18890':{ u:'18890', i:25826, name:'TANGUT COMPONENT-145', cat:c.Lo,   canon:k._0, block:b[263]},
			'18891':{ u:'18891', i:25827, name:'TANGUT COMPONENT-146', cat:c.Lo,   canon:k._0, block:b[263]},
			'18892':{ u:'18892', i:25828, name:'TANGUT COMPONENT-147', cat:c.Lo,   canon:k._0, block:b[263]},
			'18893':{ u:'18893', i:25829, name:'TANGUT COMPONENT-148', cat:c.Lo,   canon:k._0, block:b[263]},
			'18894':{ u:'18894', i:25830, name:'TANGUT COMPONENT-149', cat:c.Lo,   canon:k._0, block:b[263]},
			'18895':{ u:'18895', i:25831, name:'TANGUT COMPONENT-150', cat:c.Lo,   canon:k._0, block:b[263]},
			'18896':{ u:'18896', i:25832, name:'TANGUT COMPONENT-151', cat:c.Lo,   canon:k._0, block:b[263]},
			'18897':{ u:'18897', i:25833, name:'TANGUT COMPONENT-152', cat:c.Lo,   canon:k._0, block:b[263]},
			'18898':{ u:'18898', i:25834, name:'TANGUT COMPONENT-153', cat:c.Lo,   canon:k._0, block:b[263]},
			'18899':{ u:'18899', i:25835, name:'TANGUT COMPONENT-154', cat:c.Lo,   canon:k._0, block:b[263]},
			'18900':{ u:'18900', i:25938, name:'TANGUT COMPONENT-257', cat:c.Lo,   canon:k._0, block:b[263]},
			'18901':{ u:'18901', i:25939, name:'TANGUT COMPONENT-258', cat:c.Lo,   canon:k._0, block:b[263]},
			'18902':{ u:'18902', i:25940, name:'TANGUT COMPONENT-259', cat:c.Lo,   canon:k._0, block:b[263]},
			'18903':{ u:'18903', i:25941, name:'TANGUT COMPONENT-260', cat:c.Lo,   canon:k._0, block:b[263]},
			'18904':{ u:'18904', i:25942, name:'TANGUT COMPONENT-261', cat:c.Lo,   canon:k._0, block:b[263]},
			'18905':{ u:'18905', i:25943, name:'TANGUT COMPONENT-262', cat:c.Lo,   canon:k._0, block:b[263]},
			'18906':{ u:'18906', i:25944, name:'TANGUT COMPONENT-263', cat:c.Lo,   canon:k._0, block:b[263]},
			'18907':{ u:'18907', i:25945, name:'TANGUT COMPONENT-264', cat:c.Lo,   canon:k._0, block:b[263]},
			'18908':{ u:'18908', i:25946, name:'TANGUT COMPONENT-265', cat:c.Lo,   canon:k._0, block:b[263]},
			'18909':{ u:'18909', i:25947, name:'TANGUT COMPONENT-266', cat:c.Lo,   canon:k._0, block:b[263]},
			'18910':{ u:'18910', i:25954, name:'TANGUT COMPONENT-273', cat:c.Lo,   canon:k._0, block:b[263]},
			'18911':{ u:'18911', i:25955, name:'TANGUT COMPONENT-274', cat:c.Lo,   canon:k._0, block:b[263]},
			'18912':{ u:'18912', i:25956, name:'TANGUT COMPONENT-275', cat:c.Lo,   canon:k._0, block:b[263]},
			'18913':{ u:'18913', i:25957, name:'TANGUT COMPONENT-276', cat:c.Lo,   canon:k._0, block:b[263]},
			'18914':{ u:'18914', i:25958, name:'TANGUT COMPONENT-277', cat:c.Lo,   canon:k._0, block:b[263]},
			'18915':{ u:'18915', i:25959, name:'TANGUT COMPONENT-278', cat:c.Lo,   canon:k._0, block:b[263]},
			'18916':{ u:'18916', i:25960, name:'TANGUT COMPONENT-279', cat:c.Lo,   canon:k._0, block:b[263]},
			'18917':{ u:'18917', i:25961, name:'TANGUT COMPONENT-280', cat:c.Lo,   canon:k._0, block:b[263]},
			'18918':{ u:'18918', i:25962, name:'TANGUT COMPONENT-281', cat:c.Lo,   canon:k._0, block:b[263]},
			'18919':{ u:'18919', i:25963, name:'TANGUT COMPONENT-282', cat:c.Lo,   canon:k._0, block:b[263]},
			'18920':{ u:'18920', i:25970, name:'TANGUT COMPONENT-289', cat:c.Lo,   canon:k._0, block:b[263]},
			'18921':{ u:'18921', i:25971, name:'TANGUT COMPONENT-290', cat:c.Lo,   canon:k._0, block:b[263]},
			'18922':{ u:'18922', i:25972, name:'TANGUT COMPONENT-291', cat:c.Lo,   canon:k._0, block:b[263]},
			'18923':{ u:'18923', i:25973, name:'TANGUT COMPONENT-292', cat:c.Lo,   canon:k._0, block:b[263]},
			'18924':{ u:'18924', i:25974, name:'TANGUT COMPONENT-293', cat:c.Lo,   canon:k._0, block:b[263]},
			'18925':{ u:'18925', i:25975, name:'TANGUT COMPONENT-294', cat:c.Lo,   canon:k._0, block:b[263]},
			'18926':{ u:'18926', i:25976, name:'TANGUT COMPONENT-295', cat:c.Lo,   canon:k._0, block:b[263]},
			'18927':{ u:'18927', i:25977, name:'TANGUT COMPONENT-296', cat:c.Lo,   canon:k._0, block:b[263]},
			'18928':{ u:'18928', i:25978, name:'TANGUT COMPONENT-297', cat:c.Lo,   canon:k._0, block:b[263]},
			'18929':{ u:'18929', i:25979, name:'TANGUT COMPONENT-298', cat:c.Lo,   canon:k._0, block:b[263]},
			'18930':{ u:'18930', i:25986, name:'TANGUT COMPONENT-305', cat:c.Lo,   canon:k._0, block:b[263]},
			'18931':{ u:'18931', i:25987, name:'TANGUT COMPONENT-306', cat:c.Lo,   canon:k._0, block:b[263]},
			'18932':{ u:'18932', i:25988, name:'TANGUT COMPONENT-307', cat:c.Lo,   canon:k._0, block:b[263]},
			'18933':{ u:'18933', i:25989, name:'TANGUT COMPONENT-308', cat:c.Lo,   canon:k._0, block:b[263]},
			'18934':{ u:'18934', i:25990, name:'TANGUT COMPONENT-309', cat:c.Lo,   canon:k._0, block:b[263]},
			'18935':{ u:'18935', i:25991, name:'TANGUT COMPONENT-310', cat:c.Lo,   canon:k._0, block:b[263]},
			'18936':{ u:'18936', i:25992, name:'TANGUT COMPONENT-311', cat:c.Lo,   canon:k._0, block:b[263]},
			'18937':{ u:'18937', i:25993, name:'TANGUT COMPONENT-312', cat:c.Lo,   canon:k._0, block:b[263]},
			'18938':{ u:'18938', i:25994, name:'TANGUT COMPONENT-313', cat:c.Lo,   canon:k._0, block:b[263]},
			'18939':{ u:'18939', i:25995, name:'TANGUT COMPONENT-314', cat:c.Lo,   canon:k._0, block:b[263]},
			'18940':{ u:'18940', i:26002, name:'TANGUT COMPONENT-321', cat:c.Lo,   canon:k._0, block:b[263]},
			'18941':{ u:'18941', i:26003, name:'TANGUT COMPONENT-322', cat:c.Lo,   canon:k._0, block:b[263]},
			'18942':{ u:'18942', i:26004, name:'TANGUT COMPONENT-323', cat:c.Lo,   canon:k._0, block:b[263]},
			'18943':{ u:'18943', i:26005, name:'TANGUT COMPONENT-324', cat:c.Lo,   canon:k._0, block:b[263]},
			'18944':{ u:'18944', i:26006, name:'TANGUT COMPONENT-325', cat:c.Lo,   canon:k._0, block:b[263]},
			'18945':{ u:'18945', i:26007, name:'TANGUT COMPONENT-326', cat:c.Lo,   canon:k._0, block:b[263]},
			'18946':{ u:'18946', i:26008, name:'TANGUT COMPONENT-327', cat:c.Lo,   canon:k._0, block:b[263]},
			'18947':{ u:'18947', i:26009, name:'TANGUT COMPONENT-328', cat:c.Lo,   canon:k._0, block:b[263]},
			'18948':{ u:'18948', i:26010, name:'TANGUT COMPONENT-329', cat:c.Lo,   canon:k._0, block:b[263]},
			'18949':{ u:'18949', i:26011, name:'TANGUT COMPONENT-330', cat:c.Lo,   canon:k._0, block:b[263]},
			'18950':{ u:'18950', i:26018, name:'TANGUT COMPONENT-337', cat:c.Lo,   canon:k._0, block:b[263]},
			'18951':{ u:'18951', i:26019, name:'TANGUT COMPONENT-338', cat:c.Lo,   canon:k._0, block:b[263]},
			'18952':{ u:'18952', i:26020, name:'TANGUT COMPONENT-339', cat:c.Lo,   canon:k._0, block:b[263]},
			'18953':{ u:'18953', i:26021, name:'TANGUT COMPONENT-340', cat:c.Lo,   canon:k._0, block:b[263]},
			'18954':{ u:'18954', i:26022, name:'TANGUT COMPONENT-341', cat:c.Lo,   canon:k._0, block:b[263]},
			'18955':{ u:'18955', i:26023, name:'TANGUT COMPONENT-342', cat:c.Lo,   canon:k._0, block:b[263]},
			'18956':{ u:'18956', i:26024, name:'TANGUT COMPONENT-343', cat:c.Lo,   canon:k._0, block:b[263]},
			'18957':{ u:'18957', i:26025, name:'TANGUT COMPONENT-344', cat:c.Lo,   canon:k._0, block:b[263]},
			'18958':{ u:'18958', i:26026, name:'TANGUT COMPONENT-345', cat:c.Lo,   canon:k._0, block:b[263]},
			'18959':{ u:'18959', i:26027, name:'TANGUT COMPONENT-346', cat:c.Lo,   canon:k._0, block:b[263]},
			'18960':{ u:'18960', i:26034, name:'TANGUT COMPONENT-353', cat:c.Lo,   canon:k._0, block:b[263]},
			'18961':{ u:'18961', i:26035, name:'TANGUT COMPONENT-354', cat:c.Lo,   canon:k._0, block:b[263]},
			'18962':{ u:'18962', i:26036, name:'TANGUT COMPONENT-355', cat:c.Lo,   canon:k._0, block:b[263]},
			'18963':{ u:'18963', i:26037, name:'TANGUT COMPONENT-356', cat:c.Lo,   canon:k._0, block:b[263]},
			'18964':{ u:'18964', i:26038, name:'TANGUT COMPONENT-357', cat:c.Lo,   canon:k._0, block:b[263]},
			'18965':{ u:'18965', i:26039, name:'TANGUT COMPONENT-358', cat:c.Lo,   canon:k._0, block:b[263]},
			'18966':{ u:'18966', i:26040, name:'TANGUT COMPONENT-359', cat:c.Lo,   canon:k._0, block:b[263]},
			'18967':{ u:'18967', i:26041, name:'TANGUT COMPONENT-360', cat:c.Lo,   canon:k._0, block:b[263]},
			'18968':{ u:'18968', i:26042, name:'TANGUT COMPONENT-361', cat:c.Lo,   canon:k._0, block:b[263]},
			'18969':{ u:'18969', i:26043, name:'TANGUT COMPONENT-362', cat:c.Lo,   canon:k._0, block:b[263]},
			'18970':{ u:'18970', i:26050, name:'TANGUT COMPONENT-369', cat:c.Lo,   canon:k._0, block:b[263]},
			'18971':{ u:'18971', i:26051, name:'TANGUT COMPONENT-370', cat:c.Lo,   canon:k._0, block:b[263]},
			'18972':{ u:'18972', i:26052, name:'TANGUT COMPONENT-371', cat:c.Lo,   canon:k._0, block:b[263]},
			'18973':{ u:'18973', i:26053, name:'TANGUT COMPONENT-372', cat:c.Lo,   canon:k._0, block:b[263]},
			'18974':{ u:'18974', i:26054, name:'TANGUT COMPONENT-373', cat:c.Lo,   canon:k._0, block:b[263]},
			'18975':{ u:'18975', i:26055, name:'TANGUT COMPONENT-374', cat:c.Lo,   canon:k._0, block:b[263]},
			'18976':{ u:'18976', i:26056, name:'TANGUT COMPONENT-375', cat:c.Lo,   canon:k._0, block:b[263]},
			'18977':{ u:'18977', i:26057, name:'TANGUT COMPONENT-376', cat:c.Lo,   canon:k._0, block:b[263]},
			'18978':{ u:'18978', i:26058, name:'TANGUT COMPONENT-377', cat:c.Lo,   canon:k._0, block:b[263]},
			'18979':{ u:'18979', i:26059, name:'TANGUT COMPONENT-378', cat:c.Lo,   canon:k._0, block:b[263]},
			'18980':{ u:'18980', i:26066, name:'TANGUT COMPONENT-385', cat:c.Lo,   canon:k._0, block:b[263]},
			'18981':{ u:'18981', i:26067, name:'TANGUT COMPONENT-386', cat:c.Lo,   canon:k._0, block:b[263]},
			'18982':{ u:'18982', i:26068, name:'TANGUT COMPONENT-387', cat:c.Lo,   canon:k._0, block:b[263]},
			'18983':{ u:'18983', i:26069, name:'TANGUT COMPONENT-388', cat:c.Lo,   canon:k._0, block:b[263]},
			'18984':{ u:'18984', i:26070, name:'TANGUT COMPONENT-389', cat:c.Lo,   canon:k._0, block:b[263]},
			'18985':{ u:'18985', i:26071, name:'TANGUT COMPONENT-390', cat:c.Lo,   canon:k._0, block:b[263]},
			'18986':{ u:'18986', i:26072, name:'TANGUT COMPONENT-391', cat:c.Lo,   canon:k._0, block:b[263]},
			'18987':{ u:'18987', i:26073, name:'TANGUT COMPONENT-392', cat:c.Lo,   canon:k._0, block:b[263]},
			'18988':{ u:'18988', i:26074, name:'TANGUT COMPONENT-393', cat:c.Lo,   canon:k._0, block:b[263]},
			'18989':{ u:'18989', i:26075, name:'TANGUT COMPONENT-394', cat:c.Lo,   canon:k._0, block:b[263]},
			'18990':{ u:'18990', i:26082, name:'TANGUT COMPONENT-401', cat:c.Lo,   canon:k._0, block:b[263]},
			'18991':{ u:'18991', i:26083, name:'TANGUT COMPONENT-402', cat:c.Lo,   canon:k._0, block:b[263]},
			'18992':{ u:'18992', i:26084, name:'TANGUT COMPONENT-403', cat:c.Lo,   canon:k._0, block:b[263]},
			'18993':{ u:'18993', i:26085, name:'TANGUT COMPONENT-404', cat:c.Lo,   canon:k._0, block:b[263]},
			'18994':{ u:'18994', i:26086, name:'TANGUT COMPONENT-405', cat:c.Lo,   canon:k._0, block:b[263]},
			'18995':{ u:'18995', i:26087, name:'TANGUT COMPONENT-406', cat:c.Lo,   canon:k._0, block:b[263]},
			'18996':{ u:'18996', i:26088, name:'TANGUT COMPONENT-407', cat:c.Lo,   canon:k._0, block:b[263]},
			'18997':{ u:'18997', i:26089, name:'TANGUT COMPONENT-408', cat:c.Lo,   canon:k._0, block:b[263]},
			'18998':{ u:'18998', i:26090, name:'TANGUT COMPONENT-409', cat:c.Lo,   canon:k._0, block:b[263]},
			'18999':{ u:'18999', i:26091, name:'TANGUT COMPONENT-410', cat:c.Lo,   canon:k._0, block:b[263]},
			'20000':{ u:'20000', i:33666, name:'<CJK Ideograph Extension B, First>', cat:c.Lo,   canon:k._0, block:b[309]},
			'30000':{ u:'30000', i:34218, name:'<CJK Ideograph Extension G, First>', cat:c.Lo,   canon:k._0, block:b[315]},
			'100000':{ u:'100000', i:34559, name:'<Plane 16 Private Use, First>', cat:c.Co,   canon:k._0, block:b[319]},
			'0020':{ u:'0020', i:0, name:'SPACE', cat:c.Zs,  relatives:['00a0', '00a8', '00af', '00b4', '00b8', '02d8', '02d9', '02da', '02db', '02dc', '02dd', '037a', '0384', '1fbd', '1fbf', '1fc0', '1ffe', '2002', '2003', '2004', '2005', '2006', '2007', '2008', '2009', '200a', '2017', '202f', '203e', '205f', '3000', '309b', '309c', 'fc5e', 'fc5f', 'fc60', 'fc61', 'fc62', 'fc63', 'fdfa', 'fdfb', 'fe70', 'fe72', 'fe74', 'fe76', 'fe78', 'fe7a', 'fe7c', 'fe7e'],  canon:k._0, block:b[0]},
			'0021':{ u:'0021', i:1, name:'EXCLAMATION MARK', cat:c.Po,  relatives:['203c', '2048', '2049', 'fe15', 'fe57', 'ff01'],  canon:k._0, block:b[0]},
			'0022':{ u:'0022', i:2, name:'QUOTATION MARK', cat:c.Po,  relatives:['ff02'],  canon:k._0, block:b[0]},
			'0023':{ u:'0023', i:3, name:'NUMBER SIGN', cat:c.Po,  relatives:['fe5f', 'ff03'],  canon:k._0, block:b[0]},
			'0024':{ u:'0024', i:4, name:'DOLLAR SIGN', cat:c.Sc,  relatives:['fe69', 'ff04'],  canon:k._0, block:b[0]},
			'0025':{ u:'0025', i:5, name:'PERCENT SIGN', cat:c.Po,  relatives:['fe6a', 'ff05'],  canon:k._0, block:b[0]},
			'0026':{ u:'0026', i:6, name:'AMPERSAND', cat:c.Po,  relatives:['fe60', 'ff06'],  canon:k._0, block:b[0]},
			'0027':{ u:'0027', i:7, name:'APOSTROPHE', cat:c.Po,  relatives:['ff07'],  canon:k._0, block:b[0]},
			'0028':{ u:'0028', i:8, name:'LEFT PARENTHESIS', cat:c.Ps,  relatives:['207d', '208d', '2474', '2475', '2476', '2477', '2478', '2479', '247a', '247b', '247c', '247d', '247e', '247f', '2480', '2481', '2482', '2483', '2484', '2485', '2486', '2487', '249c', '249d', '249e', '249f', '24a0', '24a1', '24a2', '24a3', '24a4', '24a5', '24a6', '24a7', '24a8', '24a9', '24aa', '24ab', '24ac', '24ad', '24ae', '24af', '24b0', '24b1', '24b2', '24b3', '24b4', '24b5', '3200', '3201', '3202', '3203', '3204', '3205', '3206', '3207', '3208', '3209', '320a', '320b', '320c', '320d', '320e', '320f', '3210', '3211', '3212', '3213', '3214', '3215', '3216', '3217', '3218', '3219', '321a', '321b', '321c', '321d', '321e', '3220', '3221', '3222', '3223', '3224', '3225', '3226', '3227', '3228', '3229', '322a', '322b', '322c', '322d', '322e', '322f', '3230', '3231', '3232', '3233', '3234', '3235', '3236', '3237', '3238', '3239', '323a', '323b', '323c', '323d', '323e', '323f', '3240', '3241', '3242', '3243', 'fe35', 'fe59', 'ff08', '1f110', '1f111', '1f112', '1f113', '1f114', '1f115', '1f116', '1f117', '1f118', '1f119', '1f11a', '1f11b', '1f11c', '1f11d', '1f11e', '1f11f', '1f120', '1f121', '1f122', '1f123', '1f124', '1f125', '1f126', '1f127', '1f128', '1f129'],  canon:k._0, block:b[0]},
			'0029':{ u:'0029', i:9, name:'RIGHT PARENTHESIS', cat:c.Pe,  relatives:['207e', '208e', '2474', '2475', '2476', '2477', '2478', '2479', '247a', '247b', '247c', '247d', '247e', '247f', '2480', '2481', '2482', '2483', '2484', '2485', '2486', '2487', '249c', '249d', '249e', '249f', '24a0', '24a1', '24a2', '24a3', '24a4', '24a5', '24a6', '24a7', '24a8', '24a9', '24aa', '24ab', '24ac', '24ad', '24ae', '24af', '24b0', '24b1', '24b2', '24b3', '24b4', '24b5', '3200', '3201', '3202', '3203', '3204', '3205', '3206', '3207', '3208', '3209', '320a', '320b', '320c', '320d', '320e', '320f', '3210', '3211', '3212', '3213', '3214', '3215', '3216', '3217', '3218', '3219', '321a', '321b', '321c', '321d', '321e', '3220', '3221', '3222', '3223', '3224', '3225', '3226', '3227', '3228', '3229', '322a', '322b', '322c', '322d', '322e', '322f', '3230', '3231', '3232', '3233', '3234', '3235', '3236', '3237', '3238', '3239', '323a', '323b', '323c', '323d', '323e', '323f', '3240', '3241', '3242', '3243', 'fe36', 'fe5a', 'ff09', '1f110', '1f111', '1f112', '1f113', '1f114', '1f115', '1f116', '1f117', '1f118', '1f119', '1f11a', '1f11b', '1f11c', '1f11d', '1f11e', '1f11f', '1f120', '1f121', '1f122', '1f123', '1f124', '1f125', '1f126', '1f127', '1f128', '1f129'],  canon:k._0, block:b[0]},
			'002a':{ u:'002a', i:10, name:'ASTERISK', cat:c.Po,  relatives:['fe61', 'ff0a'],  canon:k._0, block:b[0]},
			'002b':{ u:'002b', i:11, name:'PLUS SIGN', cat:c.Sm,  relatives:['207a', '208a', 'fb29', 'fe62', 'ff0b'],  canon:k._0, block:b[0]},
			'002c':{ u:'002c', i:12, name:'COMMA', cat:c.Po,  relatives:['fe10', 'fe50', 'ff0c', '1f101', '1f102', '1f103', '1f104', '1f105', '1f106', '1f107', '1f108', '1f109', '1f10a'],  canon:k._0, block:b[0]},
			'002d':{ u:'002d', i:13, name:'HYPHEN-MINUS', cat:c.Pd,  relatives:['fe63', 'ff0d'],  canon:k._0, block:b[0]},
			'002e':{ u:'002e', i:14, name:'FULL STOP', cat:c.Po,  relatives:['2024', '2025', '2026', '2488', '2489', '248a', '248b', '248c', '248d', '248e', '248f', '2490', '2491', '2492', '2493', '2494', '2495', '2496', '2497', '2498', '2499', '249a', '249b', '33c2', '33c7', '33d8', 'fe52', 'ff0e', '1f100'],  canon:k._0, block:b[0]},
			'002f':{ u:'002f', i:15, name:'SOLIDUS', cat:c.Po,  relatives:['2100', '2101', '2105', '2106', 'ff0f'],  canon:k._0, block:b[0]},
			'0030':{ u:'0030', i:16, name:'DIGIT ZERO', cat:c.Nd,  relatives:['2070', '2080', '2152', '2189', '2469', '2473', '247d', '2487', '2491', '249b', '24ea', '325a', '32b5', '32bf', '32c9', '3358', '3362', '336c', '33e9', '33f3', '33fd', 'ff10', '1d7ce', '1d7d8', '1d7e2', '1d7ec', '1d7f6', '1f100', '1f101', '1fbf0'],  canon:k._0, block:b[0]},
			'0031':{ u:'0031', i:17, name:'DIGIT ONE', cat:c.Nd,  relatives:['00b9', '00bc', '00bd', '2081', '2150', '2151', '2152', '2153', '2155', '2159', '215b', '215f', '2460', '2469', '246a', '246b', '246c', '246d', '246e', '246f', '2470', '2471', '2472', '2474', '247d', '247e', '247f', '2480', '2481', '2482', '2483', '2484', '2485', '2486', '2488', '2491', '2492', '2493', '2494', '2495', '2496', '2497', '2498', '2499', '249a', '3251', '325b', '32b6', '32c0', '32c9', '32ca', '32cb', '3359', '3362', '3363', '3364', '3365', '3366', '3367', '3368', '3369', '336a', '336b', '336d', '33e0', '33e9', '33ea', '33eb', '33ec', '33ed', '33ee', '33ef', '33f0', '33f1', '33f2', '33f4', '33fe', 'ff11', '1d7cf', '1d7d9', '1d7e3', '1d7ed', '1d7f7', '1f102', '1fbf1'],  canon:k._0, block:b[0]},
			'0032':{ u:'0032', i:18, name:'DIGIT TWO', cat:c.Nd,  relatives:['00b2', '00bd', '2082', '2154', '2156', '2461', '246b', '2473', '2475', '247f', '2487', '2489', '2493', '249b', '3251', '3252', '3253', '3254', '3255', '3256', '3257', '3258', '3259', '325c', '32b7', '32c1', '32cb', '335a', '3364', '336c', '336d', '336e', '336f', '3370', '33e1', '33eb', '33f3', '33f4', '33f5', '33f6', '33f7', '33f8', '33f9', '33fa', '33fb', '33fc', 'ff12', '1d7d0', '1d7da', '1d7e4', '1d7ee', '1d7f8', '1f103', '1fbf2'],  canon:k._0, block:b[0]},
			'0033':{ u:'0033', i:19, name:'DIGIT THREE', cat:c.Nd,  relatives:['00b3', '00be', '2083', '2153', '2154', '2157', '215c', '2189', '2462', '246c', '2476', '2480', '248a', '2494', '3253', '325a', '325b', '325c', '325d', '325e', '325f', '32b1', '32b2', '32b3', '32b4', '32b8', '32c2', '335b', '3365', '336f', '33e2', '33ec', '33f6', '33fd', '33fe', 'ff13', '1d7d1', '1d7db', '1d7e5', '1d7ef', '1d7f9', '1f104', '1fbf3'],  canon:k._0, block:b[0]},
			'0034':{ u:'0034', i:20, name:'DIGIT FOUR', cat:c.Nd,  relatives:['00bc', '00be', '2074', '2084', '2158', '2463', '246d', '2477', '2481', '248b', '2495', '3254', '325e', '32b5', '32b6', '32b7', '32b8', '32b9', '32ba', '32bb', '32bc', '32bd', '32be', '32c3', '335c', '3366', '3370', '33e3', '33ed', '33f7', 'ff14', '1d7d2', '1d7dc', '1d7e6', '1d7f0', '1d7fa', '1f105', '1fbf4'],  canon:k._0, block:b[0]},
			'0035':{ u:'0035', i:21, name:'DIGIT FIVE', cat:c.Nd,  relatives:['2075', '2085', '2155', '2156', '2157', '2158', '215a', '215d', '2464', '246e', '2478', '2482', '248c', '2496', '3255', '325f', '32ba', '32bf', '32c4', '335d', '3367', '33e4', '33ee', '33f8', 'ff15', '1d7d3', '1d7dd', '1d7e7', '1d7f1', '1d7fb', '1f106', '1fbf5'],  canon:k._0, block:b[0]},
			'0036':{ u:'0036', i:22, name:'DIGIT SIX', cat:c.Nd,  relatives:['2076', '2086', '2159', '215a', '2465', '246f', '2479', '2483', '248d', '2497', '3256', '32b1', '32bb', '32c5', '335e', '3368', '33e5', '33ef', '33f9', 'ff16', '1d7d4', '1d7de', '1d7e8', '1d7f2', '1d7fc', '1f107', '1fbf6'],  canon:k._0, block:b[0]},
			'0037':{ u:'0037', i:23, name:'DIGIT SEVEN', cat:c.Nd,  relatives:['2077', '2087', '2150', '215e', '2466', '2470', '247a', '2484', '248e', '2498', '3257', '32b2', '32bc', '32c6', '335f', '3369', '33e6', '33f0', '33fa', 'ff17', '1d7d5', '1d7df', '1d7e9', '1d7f3', '1d7fd', '1f108', '1fbf7'],  canon:k._0, block:b[0]},
			'0038':{ u:'0038', i:24, name:'DIGIT EIGHT', cat:c.Nd,  relatives:['2078', '2088', '215b', '215c', '215d', '215e', '2467', '2471', '247b', '2485', '248f', '2499', '3258', '32b3', '32bd', '32c7', '3360', '336a', '33e7', '33f1', '33fb', 'ff18', '1d7d6', '1d7e0', '1d7ea', '1d7f4', '1d7fe', '1f109', '1fbf8'],  canon:k._0, block:b[0]},
			'0039':{ u:'0039', i:25, name:'DIGIT NINE', cat:c.Nd,  relatives:['2079', '2089', '2151', '2468', '2472', '247c', '2486', '2490', '249a', '3259', '32b4', '32be', '32c8', '3361', '336b', '33e8', '33f2', '33fc', 'ff19', '1d7d7', '1d7e1', '1d7eb', '1d7f5', '1d7ff', '1f10a', '1fbf9'],  canon:k._0, block:b[0]},
			'003a':{ u:'003a', i:26, name:'COLON', cat:c.Po,  relatives:['2a74', 'fe13', 'fe55', 'ff1a'],  canon:k._0, block:b[0]},
			'003b':{ u:'003b', i:27, name:'SEMICOLON', cat:c.Po,  relatives:['037e', 'fe14', 'fe54', 'ff1b'],  canon:k._0, block:b[0]},
			'003c':{ u:'003c', i:28, name:'LESS-THAN SIGN', cat:c.Sm,  relatives:['226e', 'fe64', 'ff1c'],  canon:k._0, block:b[0]},
			'003d':{ u:'003d', i:29, name:'EQUALS SIGN', cat:c.Sm,  relatives:['207c', '208c', '2260', '2a74', '2a75', '2a76', 'fe66', 'ff1d'],  canon:k._0, block:b[0]},
			'003e':{ u:'003e', i:30, name:'GREATER-THAN SIGN', cat:c.Sm,  relatives:['226f', 'fe65', 'ff1e'],  canon:k._0, block:b[0]},
			'003f':{ u:'003f', i:31, name:'QUESTION MARK', cat:c.Po,  relatives:['2047', '2048', '2049', 'fe16', 'fe56', 'ff1f'],  canon:k._0, block:b[0]},
			'0040':{ u:'0040', i:32, name:'COMMERCIAL AT', cat:c.Po,  relatives:['fe6b', 'ff20'],  canon:k._0, block:b[0]},
			'0041':{ u:'0041', i:33, name:'LATIN CAPITAL LETTER A', cat:c.Lu,  relatives:['00c0', '00c1', '00c2', '00c3', '00c4', '00c5', '0100', '0102', '0104', '01cd', '0200', '0202', '0226', '1d2c', '1e00', '1ea0', '1ea2', '213b', '24b6', '3373', '3380', '3381', '3382', '3383', '3384', '33df', 'ff21', '1d400', '1d434', '1d468', '1d49c', '1d4d0', '1d504', '1d538', '1d56c', '1d5a0', '1d5d4', '1d608', '1d63c', '1d670', '1f110', '1f130'],  canon:k._0, block:b[0], indexed:["A"]},
			'0042':{ u:'0042', i:34, name:'LATIN CAPITAL LETTER B', cat:c.Lu,  relatives:['1d2e', '1e02', '1e04', '1e06', '212c', '24b7', '3385', '3386', '3387', '33c3', '33c8', 'ff22', '1d401', '1d435', '1d469', '1d4d1', '1d505', '1d539', '1d56d', '1d5a1', '1d5d5', '1d609', '1d63d', '1d671', '1f111', '1f131'],  canon:k._0, block:b[0], indexed:["B"]},
			'0043':{ u:'0043', i:35, name:'LATIN CAPITAL LETTER C', cat:c.Lu,  relatives:['00c7', '0106', '0108', '010a', '010c', '2102', '2103', '212d', '216d', '24b8', '33c6', '33c7', 'a7f2', 'ff23', '1d402', '1d436', '1d46a', '1d49e', '1d4d2', '1d56e', '1d5a2', '1d5d6', '1d60a', '1d63e', '1d672', '1f112', '1f12b', '1f12d', '1f132', '1f14f', '1f16a'],  canon:k._0, block:b[0], indexed:["C"]},
			'0044':{ u:'0044', i:36, name:'LATIN CAPITAL LETTER D', cat:c.Lu,  relatives:['010e', '01c4', '01c5', '01f1', '01f2', '1d30', '1e0a', '1e0c', '1e0e', '1e10', '1e12', '2145', '216e', '24b9', '32cf', 'ff24', '1d403', '1d437', '1d46b', '1d49f', '1d4d3', '1d507', '1d53b', '1d56f', '1d5a3', '1d5d7', '1d60b', '1d63f', '1d673', '1f113', '1f12d', '1f133', '1f14c', '1f16b', '1f190'],  canon:k._0, block:b[0], indexed:["D"]},
			'0045':{ u:'0045', i:37, name:'LATIN CAPITAL LETTER E', cat:c.Lu,  relatives:['00c8', '00c9', '00ca', '00cb', '0112', '0114', '0116', '0118', '011a', '0204', '0206', '0228', '1d31', '1e18', '1e1a', '1eb8', '1eba', '1ebc', '2121', '2130', '24ba', '3250', 'ff25', '1d404', '1d438', '1d46c', '1d4d4', '1d508', '1d53c', '1d570', '1d5a4', '1d5d8', '1d60c', '1d640', '1d674', '1f114', '1f134'],  canon:k._0, block:b[0], indexed:["E"]},
			'0046':{ u:'0046', i:38, name:'LATIN CAPITAL LETTER F', cat:c.Lu,  relatives:['1e1e', '2109', '2131', '213b', '24bb', '338a', '338b', '338c', 'a7f3', 'ff26', '1d405', '1d439', '1d46d', '1d4d5', '1d509', '1d53d', '1d571', '1d5a5', '1d5d9', '1d60d', '1d641', '1d675', '1f115', '1f135'],  canon:k._0, block:b[0], indexed:["F"]},
			'0047':{ u:'0047', i:39, name:'LATIN CAPITAL LETTER G', cat:c.Lu,  relatives:['011c', '011e', '0120', '0122', '01e6', '01f4', '1d33', '1e20', '24bc', '3387', '3393', '33ac', '33c9', 'ff27', '1d406', '1d43a', '1d46e', '1d4a2', '1d4d6', '1d50a', '1d53e', '1d572', '1d5a6', '1d5da', '1d60e', '1d642', '1d676', '1f116', '1f136'],  canon:k._0, block:b[0], indexed:["G"]},
			'0048':{ u:'0048', i:40, name:'LATIN CAPITAL LETTER H', cat:c.Lu,  relatives:['0124', '021e', '1d34', '1e22', '1e24', '1e26', '1e28', '1e2a', '210b', '210c', '210d', '24bd', '32cc', '3390', '3391', '3392', '3393', '3394', '33cb', '33d7', 'ff28', '1d407', '1d43b', '1d46f', '1d4d7', '1d573', '1d5a7', '1d5db', '1d60f', '1d643', '1d677', '1f117', '1f137', '1f14a'],  canon:k._0, block:b[0], indexed:["H"]},
			'0049':{ u:'0049', i:41, name:'LATIN CAPITAL LETTER I', cat:c.Lu,  relatives:['00cc', '00cd', '00ce', '00cf', '0128', '012a', '012c', '012e', '0130', '0132', '01cf', '0208', '020a', '1d35', '1e2c', '1ec8', '1eca', '2110', '2111', '2160', '2161', '2162', '2163', '2165', '2166', '2167', '2168', '216a', '216b', '24be', '337a', 'ff29', '1d408', '1d43c', '1d470', '1d4d8', '1d540', '1d574', '1d5a8', '1d5dc', '1d610', '1d644', '1d678', '1f118', '1f138'],  canon:k._0, block:b[0], indexed:["I"]},
			'004a':{ u:'004a', i:42, name:'LATIN CAPITAL LETTER J', cat:c.Lu,  relatives:['0132', '0134', '01c7', '01ca', '1d36', '24bf', 'ff2a', '1d409', '1d43d', '1d471', '1d4a5', '1d4d9', '1d50d', '1d541', '1d575', '1d5a9', '1d5dd', '1d611', '1d645', '1d679', '1f119', '1f139', '1f190'],  canon:k._0, block:b[0], indexed:["J"]},
			'004b':{ u:'004b', i:43, name:'LATIN CAPITAL LETTER K', cat:c.Lu,  relatives:['0136', '01e8', '1d37', '1e30', '1e32', '1e34', '212a', '24c0', '3385', '33cd', '33ce', 'ff2b', '1d40a', '1d43e', '1d472', '1d4a6', '1d4da', '1d50e', '1d542', '1d576', '1d5aa', '1d5de', '1d612', '1d646', '1d67a', '1f11a', '1f13a'],  canon:k._0, block:b[0], indexed:["K"]},
			'004c':{ u:'004c', i:44, name:'LATIN CAPITAL LETTER L', cat:c.Lu,  relatives:['0139', '013b', '013d', '013f', '01c7', '01c8', '1d38', '1e36', '1e3a', '1e3c', '2112', '2121', '216c', '24c1', '32cf', 'ff2c', '1d40b', '1d43f', '1d473', '1d4db', '1d50f', '1d543', '1d577', '1d5ab', '1d5df', '1d613', '1d647', '1d67b', '1f11b', '1f13b'],  canon:k._0, block:b[0], indexed:["L"]},
			'004d':{ u:'004d', i:45, name:'LATIN CAPITAL LETTER M', cat:c.Lu,  relatives:['1d39', '1e3e', '1e40', '1e42', '2120', '2122', '2133', '216f', '24c2', '3386', '3392', '33ab', '33b9', '33bf', '33c1', '33ce', '33d9', 'ff2d', '1d40c', '1d440', '1d474', '1d4dc', '1d510', '1d544', '1d578', '1d5ac', '1d5e0', '1d614', '1d648', '1d67c', '1f11c', '1f13c', '1f14b', '1f16a', '1f16b', '1f16c'],  canon:k._0, block:b[0], indexed:["M"]},
			'004e':{ u:'004e', i:46, name:'LATIN CAPITAL LETTER N', cat:c.Lu,  relatives:['00d1', '0143', '0145', '0147', '01ca', '01cb', '01f8', '1d3a', '1e44', '1e46', '1e48', '1e4a', '2115', '2116', '24c3', 'ff2e', '1d40d', '1d441', '1d475', '1d4a9', '1d4dd', '1d511', '1d579', '1d5ad', '1d5e1', '1d615', '1d649', '1d67d', '1f11d', '1f13d'],  canon:k._0, block:b[0], indexed:["N"]},
			'004f':{ u:'004f', i:47, name:'LATIN CAPITAL LETTER O', cat:c.Lu,  relatives:['00d2', '00d3', '00d4', '00d5', '00d6', '014c', '014e', '0150', '01a0', '01d1', '01ea', '020c', '020e', '022e', '1d3c', '1ecc', '1ece', '24c4', 'ff2f', '1d40e', '1d442', '1d476', '1d4aa', '1d4de', '1d512', '1d546', '1d57a', '1d5ae', '1d5e2', '1d616', '1d64a', '1d67e', '1f11e', '1f13e'],  canon:k._0, block:b[0], indexed:["O"]},
			'0050':{ u:'0050', i:48, name:'LATIN CAPITAL LETTER P', cat:c.Lu,  relatives:['1d3e', '1e54', '1e56', '2119', '24c5', '3250', '3371', '33a9', '33aa', '33ab', '33ac', '33cb', '33d7', '33d9', '33da', 'ff30', '1d40f', '1d443', '1d477', '1d4ab', '1d4df', '1d513', '1d57b', '1d5af', '1d5e3', '1d617', '1d64b', '1d67f', '1f11f', '1f13f', '1f14e'],  canon:k._0, block:b[0], indexed:["P"]},
			'0051':{ u:'0051', i:49, name:'LATIN CAPITAL LETTER Q', cat:c.Lu,  relatives:['211a', '24c6', 'a7f4', 'ff31', '1d410', '1d444', '1d478', '1d4ac', '1d4e0', '1d514', '1d57c', '1d5b0', '1d5e4', '1d618', '1d64c', '1d680', '1f120', '1f140'],  canon:k._0, block:b[0], indexed:["Q"]},
			'0052':{ u:'0052', i:50, name:'LATIN CAPITAL LETTER R', cat:c.Lu,  relatives:['0154', '0156', '0158', '0210', '0212', '1d3f', '1e58', '1e5a', '1e5e', '20a8', '211b', '211c', '211d', '24c7', '33da', 'ff32', '1d411', '1d445', '1d479', '1d4e1', '1d57d', '1d5b1', '1d5e5', '1d619', '1d64d', '1d681', '1f121', '1f12c', '1f141', '1f16c'],  canon:k._0, block:b[0], indexed:["R"]},
			'0053':{ u:'0053', i:51, name:'LATIN CAPITAL LETTER S', cat:c.Lu,  relatives:['015a', '015c', '015e', '0160', '0218', '1e60', '1e62', '2120', '24c8', '33dc', 'ff33', '1d412', '1d446', '1d47a', '1d4ae', '1d4e2', '1d516', '1d54a', '1d57e', '1d5b2', '1d5e6', '1d61a', '1d64e', '1d682', '1f122', '1f12a', '1f142', '1f14c', '1f14d'],  canon:k._0, block:b[0], indexed:["S"]},
			'0054':{ u:'0054', i:52, name:'LATIN CAPITAL LETTER T', cat:c.Lu,  relatives:['0162', '0164', '021a', '1d40', '1e6a', '1e6c', '1e6e', '1e70', '2121', '2122', '24c9', '3250', '32cf', '3394', 'ff34', '1d413', '1d447', '1d47b', '1d4af', '1d4e3', '1d517', '1d54b', '1d57f', '1d5b3', '1d5e7', '1d61b', '1d64f', '1d683', '1f123', '1f143'],  canon:k._0, block:b[0], indexed:["T"]},
			'0055':{ u:'0055', i:53, name:'LATIN CAPITAL LETTER U', cat:c.Lu,  relatives:['00d9', '00da', '00db', '00dc', '0168', '016a', '016c', '016e', '0170', '0172', '01af', '01d3', '0214', '0216', '1d41', '1e72', '1e74', '1e76', '1ee4', '1ee6', '24ca', '3373', '337a', 'ff35', '1d414', '1d448', '1d47c', '1d4b0', '1d4e4', '1d518', '1d54c', '1d580', '1d5b4', '1d5e8', '1d61c', '1d650', '1d684', '1f124', '1f144'],  canon:k._0, block:b[0], indexed:["U"]},
			'0056':{ u:'0056', i:54, name:'LATIN CAPITAL LETTER V', cat:c.Lu,  relatives:['1e7c', '1e7e', '2163', '2164', '2165', '2166', '2167', '24cb', '2c7d', '32ce', '3375', '33b4', '33b5', '33b6', '33b7', '33b8', '33b9', '33de', 'ff36', '1d415', '1d449', '1d47d', '1d4b1', '1d4e5', '1d519', '1d54d', '1d581', '1d5b5', '1d5e9', '1d61d', '1d651', '1d685', '1f125', '1f145', '1f14a', '1f14b', '1f14e'],  canon:k._0, block:b[0], indexed:["V"]},
			'0057':{ u:'0057', i:55, name:'LATIN CAPITAL LETTER W', cat:c.Lu,  relatives:['0174', '1d42', '1e80', '1e82', '1e84', '1e86', '1e88', '24cc', '33ba', '33bb', '33bc', '33bd', '33be', '33bf', '33dd', 'ff37', '1d416', '1d44a', '1d47e', '1d4b2', '1d4e6', '1d51a', '1d54e', '1d582', '1d5b6', '1d5ea', '1d61e', '1d652', '1d686', '1f126', '1f12e', '1f146', '1f14f'],  canon:k._0, block:b[0], indexed:["W"]},
			'0058':{ u:'0058', i:56, name:'LATIN CAPITAL LETTER X', cat:c.Lu,  relatives:['1e8a', '1e8c', '213b', '2168', '2169', '216a', '216b', '24cd', 'ff38', '1d417', '1d44b', '1d47f', '1d4b3', '1d4e7', '1d51b', '1d54f', '1d583', '1d5b7', '1d5eb', '1d61f', '1d653', '1d687', '1f127', '1f147'],  canon:k._0, block:b[0], indexed:["X"]},
			'0059':{ u:'0059', i:57, name:'LATIN CAPITAL LETTER Y', cat:c.Lu,  relatives:['00dd', '0176', '0178', '0232', '1e8e', '1ef2', '1ef4', '1ef6', '1ef8', '24ce', 'ff39', '1d418', '1d44c', '1d480', '1d4b4', '1d4e8', '1d51c', '1d550', '1d584', '1d5b8', '1d5ec', '1d620', '1d654', '1d688', '1f128', '1f148'],  canon:k._0, block:b[0], indexed:["Y"]},
			'005a':{ u:'005a', i:58, name:'LATIN CAPITAL LETTER Z', cat:c.Lu,  relatives:['0179', '017b', '017d', '01f1', '1e90', '1e92', '1e94', '2124', '2128', '24cf', 'ff3a', '1d419', '1d44d', '1d481', '1d4b5', '1d4e9', '1d585', '1d5b9', '1d5ed', '1d621', '1d655', '1d689', '1f129', '1f12e', '1f149'],  canon:k._0, block:b[0], indexed:["Z"]},
			'005b':{ u:'005b', i:59, name:'LEFT SQUARE BRACKET', cat:c.Ps,  relatives:['fe47', 'ff3b'],  canon:k._0, block:b[0]},
			'005c':{ u:'005c', i:60, name:'REVERSE SOLIDUS', cat:c.Po,  relatives:['fe68', 'ff3c'],  canon:k._0, block:b[0]},
			'005d':{ u:'005d', i:61, name:'RIGHT SQUARE BRACKET', cat:c.Pe,  relatives:['fe48', 'ff3d'],  canon:k._0, block:b[0]},
			'005e':{ u:'005e', i:62, name:'CIRCUMFLEX ACCENT', cat:c.Sk,  relatives:['ff3e'],  canon:k._0, block:b[0]},
			'005f':{ u:'005f', i:63, name:'LOW LINE', cat:c.Pc,  relatives:['fe33', 'fe34', 'fe4d', 'fe4e', 'fe4f', 'ff3f'],  canon:k._0, block:b[0]},
			'0060':{ u:'0060', i:64, name:'GRAVE ACCENT', cat:c.Sk,  relatives:['1fef', 'ff40'],  canon:k._0, block:b[0]},
			'0061':{ u:'0061', i:65, name:'LATIN SMALL LETTER A', cat:c.Ll,  relatives:['00aa', '00e0', '00e1', '00e2', '00e3', '00e4', '00e5', '0101', '0103', '0105', '01ce', '0201', '0203', '0227', '1d43', '1e01', '1e9a', '1ea1', '1ea3', '2090', '2100', '2101', '249c', '24d0', '3371', '3372', '3374', '3388', '3389', '33a9', '33aa', '33ab', '33ac', '33ad', '33ae', '33af', '33c2', '33ca', '33ff', 'ff41', '1d41a', '1d44e', '1d482', '1d4b6', '1d4ea', '1d51e', '1d552', '1d586', '1d5ba', '1d5ee', '1d622', '1d656', '1d68a'],  canon:k._0, block:b[0], indexed:["A"]},
			'0062':{ u:'0062', i:66, name:'LATIN SMALL LETTER B', cat:c.Ll,  relatives:['1d47', '1e03', '1e05', '1e07', '249d', '24d1', '3374', '33d4', '33dd', 'ff42', '1d41b', '1d44f', '1d483', '1d4b7', '1d4eb', '1d51f', '1d553', '1d587', '1d5bb', '1d5ef', '1d623', '1d657', '1d68b'],  canon:k._0, block:b[0], indexed:["B"]},
			'0063':{ u:'0063', i:67, name:'LATIN SMALL LETTER C', cat:c.Ll,  relatives:['00e7', '0107', '0109', '010b', '010d', '1d9c', '2100', '2105', '2106', '217d', '249e', '24d2', '3376', '3388', '3389', '339d', '33a0', '33a4', '33c4', '33c5', 'ff43', '1d41c', '1d450', '1d484', '1d4b8', '1d4ec', '1d520', '1d554', '1d588', '1d5bc', '1d5f0', '1d624', '1d658', '1d68c'],  canon:k._0, block:b[0], indexed:["C"]},
			'0064':{ u:'0064', i:68, name:'LATIN SMALL LETTER D', cat:c.Ll,  relatives:['010f', '01c6', '01f3', '1d48', '1e0b', '1e0d', '1e0f', '1e11', '1e13', '2146', '217e', '249f', '24d3', '3372', '3377', '3378', '3379', '3397', '33ad', '33ae', '33af', '33c5', '33c8', 'ff44', '1d41d', '1d451', '1d485', '1d4b9', '1d4ed', '1d521', '1d555', '1d589', '1d5bd', '1d5f1', '1d625', '1d659', '1d68d'],  canon:k._0, block:b[0], indexed:["D"]},
			'0065':{ u:'0065', i:69, name:'LATIN SMALL LETTER E', cat:c.Ll,  relatives:['00e8', '00e9', '00ea', '00eb', '0113', '0115', '0117', '0119', '011b', '0205', '0207', '0229', '1d49', '1e19', '1e1b', '1eb9', '1ebb', '1ebd', '2091', '212f', '2147', '24a0', '24d4', '32cd', '32ce', 'ff45', '1d41e', '1d452', '1d486', '1d4ee', '1d522', '1d556', '1d58a', '1d5be', '1d5f2', '1d626', '1d65a', '1d68e'],  canon:k._0, block:b[0], indexed:["E"]},
			'0066':{ u:'0066', i:70, name:'LATIN SMALL LETTER F', cat:c.Ll,  relatives:['1da0', '1e1f', '24a1', '24d5', '3399', 'fb00', 'fb01', 'fb02', 'fb03', 'fb04', 'ff46', '1d41f', '1d453', '1d487', '1d4bb', '1d4ef', '1d523', '1d557', '1d58b', '1d5bf', '1d5f3', '1d627', '1d65b', '1d68f'],  canon:k._0, block:b[0], indexed:["F"]},
			'0067':{ u:'0067', i:71, name:'LATIN SMALL LETTER G', cat:c.Ll,  relatives:['011d', '011f', '0121', '0123', '01e7', '01f5', '1d4d', '1e21', '210a', '24a2', '24d6', '32cc', '32cd', '338d', '338e', '338f', '33c6', '33d2', '33ff', 'ff47', '1d420', '1d454', '1d488', '1d4f0', '1d524', '1d558', '1d58c', '1d5c0', '1d5f4', '1d628', '1d65c', '1d690'],  canon:k._0, block:b[0], indexed:["G"]},
			'0068':{ u:'0068', i:72, name:'LATIN SMALL LETTER H', cat:c.Ll,  relatives:['0125', '021f', '02b0', '1e23', '1e25', '1e27', '1e29', '1e2b', '1e96', '2095', '210e', '24a3', '24d7', '3371', '33ca', 'ff48', '1d421', '1d489', '1d4bd', '1d4f1', '1d525', '1d559', '1d58d', '1d5c1', '1d5f5', '1d629', '1d65d', '1d691'],  canon:k._0, block:b[0], indexed:["H"]},
			'0069':{ u:'0069', i:73, name:'LATIN SMALL LETTER I', cat:c.Ll,  relatives:['00ec', '00ed', '00ee', '00ef', '0129', '012b', '012d', '012f', '0133', '01d0', '0209', '020b', '1d62', '1e2d', '1ec9', '1ecb', '2071', '2139', '2148', '2170', '2171', '2172', '2173', '2175', '2176', '2177', '2178', '217a', '217b', '24a4', '24d8', '33cc', '33d5', 'fb01', 'fb03', 'ff49', '1d422', '1d456', '1d48a', '1d4be', '1d4f2', '1d526', '1d55a', '1d58e', '1d5c2', '1d5f6', '1d62a', '1d65e', '1d692'],  canon:k._0, block:b[0], indexed:["I"]},
			'006a':{ u:'006a', i:74, name:'LATIN SMALL LETTER J', cat:c.Ll,  relatives:['0133', '0135', '01c8', '01c9', '01cb', '01cc', '01f0', '02b2', '2149', '24a5', '24d9', '2c7c', 'ff4a', '1d423', '1d457', '1d48b', '1d4bf', '1d4f3', '1d527', '1d55b', '1d58f', '1d5c3', '1d5f7', '1d62b', '1d65f', '1d693'],  canon:k._0, block:b[0], indexed:["J"]},
			'006b':{ u:'006b', i:75, name:'LATIN SMALL LETTER K', cat:c.Ll,  relatives:['0137', '01e9', '1d4f', '1e31', '1e33', '1e35', '2096', '24a6', '24da', '3384', '3389', '338f', '3391', '3398', '339e', '33a2', '33a6', '33aa', '33b8', '33be', '33c0', '33c6', '33cf', 'ff4b', '1d424', '1d458', '1d48c', '1d4c0', '1d4f4', '1d528', '1d55c', '1d590', '1d5c4', '1d5f8', '1d62c', '1d660', '1d694'],  canon:k._0, block:b[0], indexed:["K"]},
			'006c':{ u:'006c', i:76, name:'LATIN SMALL LETTER L', cat:c.Ll,  relatives:['013a', '013c', '013e', '0140', '01c9', '02e1', '1e37', '1e3b', '1e3d', '2097', '2113', '217c', '24a7', '24db', '3388', '3389', '33d0', '33d1', '33d2', '33d3', '33d5', '33d6', '33ff', 'fb02', 'fb04', 'ff4c', '1d425', '1d459', '1d48d', '1d4c1', '1d4f5', '1d529', '1d55d', '1d591', '1d5c5', '1d5f9', '1d62d', '1d661', '1d695'],  canon:k._0, block:b[0], indexed:["L"]},
			'006d':{ u:'006d', i:77, name:'LATIN SMALL LETTER M', cat:c.Ll,  relatives:['1d50', '1e3f', '1e41', '1e43', '2098', '217f', '24a8', '24dc', '3377', '3378', '3379', '3383', '338e', '3396', '3399', '339a', '339b', '339c', '339d', '339e', '339f', '33a0', '33a1', '33a2', '33a3', '33a4', '33a5', '33a6', '33a7', '33a8', '33b3', '33b7', '33bd', '33c2', '33d0', '33d4', '33d5', '33d6', '33d8', '33de', '33df', 'ff4d', '1d426', '1d45a', '1d48e', '1d4c2', '1d4f6', '1d52a', '1d55e', '1d592', '1d5c6', '1d5fa', '1d62e', '1d662', '1d696'],  canon:k._0, block:b[0], indexed:["M"]},
			'006e':{ u:'006e', i:78, name:'LATIN SMALL LETTER N', cat:c.Ll,  relatives:['00f1', '0144', '0146', '0148', '0149', '01cc', '01f9', '1e45', '1e47', '1e49', '1e4b', '207f', '2099', '24a9', '24dd', '3381', '338b', '339a', '33b1', '33b5', '33bb', '33cc', '33d1', 'ff4e', '1d427', '1d45b', '1d48f', '1d4c3', '1d4f7', '1d52b', '1d55f', '1d593', '1d5c7', '1d5fb', '1d62f', '1d663', '1d697'],  canon:k._0, block:b[0], indexed:["N"]},
			'006f':{ u:'006f', i:79, name:'LATIN SMALL LETTER O', cat:c.Ll,  relatives:['00ba', '00f2', '00f3', '00f4', '00f5', '00f6', '014d', '014f', '0151', '01a1', '01d2', '01eb', '020d', '020f', '022f', '1d52', '1ecd', '1ecf', '2092', '2105', '2116', '2134', '24aa', '24de', '3375', '33c7', '33d2', '33d6', 'ff4f', '1d428', '1d45c', '1d490', '1d4f8', '1d52c', '1d560', '1d594', '1d5c8', '1d5fc', '1d630', '1d664', '1d698'],  canon:k._0, block:b[0], indexed:["O"]},
			'0070':{ u:'0070', i:80, name:'LATIN SMALL LETTER P', cat:c.Ll,  relatives:['1d56', '1e55', '1e57', '209a', '24ab', '24df', '3376', '3380', '338a', '33b0', '33b4', '33ba', '33d8', 'ff50', '1d429', '1d45d', '1d491', '1d4c5', '1d4f9', '1d52d', '1d561', '1d595', '1d5c9', '1d5fd', '1d631', '1d665', '1d699'],  canon:k._0, block:b[0], indexed:["P"]},
			'0071':{ u:'0071', i:81, name:'LATIN SMALL LETTER Q', cat:c.Ll,  relatives:['24ac', '24e0', '33c3', 'ff51', '107a5', '1d42a', '1d45e', '1d492', '1d4c6', '1d4fa', '1d52e', '1d562', '1d596', '1d5ca', '1d5fe', '1d632', '1d666', '1d69a'],  canon:k._0, block:b[0], indexed:["Q"]},
			'0072':{ u:'0072', i:82, name:'LATIN SMALL LETTER R', cat:c.Ll,  relatives:['0155', '0157', '0159', '0211', '0213', '02b3', '1d63', '1e59', '1e5b', '1e5f', '24ad', '24e1', '32cd', '3374', '33ad', '33ae', '33af', '33db', 'ff52', '1d42b', '1d45f', '1d493', '1d4c7', '1d4fb', '1d52f', '1d563', '1d597', '1d5cb', '1d5ff', '1d633', '1d667', '1d69b'],  canon:k._0, block:b[0], indexed:["R"]},
			'0073':{ u:'0073', i:83, name:'LATIN SMALL LETTER S', cat:c.Ll,  relatives:['015b', '015d', '015f', '0161', '017f', '0219', '02e2', '1e61', '1e63', '209b', '20a8', '2101', '24ae', '24e2', '33a7', '33a8', '33ae', '33af', '33b0', '33b1', '33b2', '33b3', '33db', 'fb06', 'ff53', '1d42c', '1d460', '1d494', '1d4c8', '1d4fc', '1d530', '1d564', '1d598', '1d5cc', '1d600', '1d634', '1d668', '1d69c'],  canon:k._0, block:b[0], indexed:["S"]},
			'0074':{ u:'0074', i:84, name:'LATIN SMALL LETTER T', cat:c.Ll,  relatives:['0163', '0165', '021b', '1d57', '1e6b', '1e6d', '1e6f', '1e71', '1e97', '209c', '24af', '24e3', '33cf', 'fb05', 'fb06', 'ff54', '1d42d', '1d461', '1d495', '1d4c9', '1d4fd', '1d531', '1d565', '1d599', '1d5cd', '1d601', '1d635', '1d669', '1d69d'],  canon:k._0, block:b[0], indexed:["T"]},
			'0075':{ u:'0075', i:85, name:'LATIN SMALL LETTER U', cat:c.Ll,  relatives:['00f9', '00fa', '00fb', '00fc', '0169', '016b', '016d', '016f', '0171', '0173', '01b0', '01d4', '0215', '0217', '1d58', '1d64', '1e73', '1e75', '1e77', '1ee5', '1ee7', '2106', '24b0', '24e4', 'ff55', '1d42e', '1d462', '1d496', '1d4ca', '1d4fe', '1d532', '1d566', '1d59a', '1d5ce', '1d602', '1d636', '1d66a', '1d69e'],  canon:k._0, block:b[0], indexed:["U"]},
			'0076':{ u:'0076', i:86, name:'LATIN SMALL LETTER V', cat:c.Ll,  relatives:['1d5b', '1d65', '1e7d', '1e7f', '2173', '2174', '2175', '2176', '2177', '24b1', '24e5', '33dc', 'ff56', '1d42f', '1d463', '1d497', '1d4cb', '1d4ff', '1d533', '1d567', '1d59b', '1d5cf', '1d603', '1d637', '1d66b', '1d69f'],  canon:k._0, block:b[0], indexed:["V"]},
			'0077':{ u:'0077', i:87, name:'LATIN SMALL LETTER W', cat:c.Ll,  relatives:['0175', '02b7', '1e81', '1e83', '1e85', '1e87', '1e89', '1e98', '24b2', '24e6', 'ff57', '1d430', '1d464', '1d498', '1d4cc', '1d500', '1d534', '1d568', '1d59c', '1d5d0', '1d604', '1d638', '1d66c', '1d6a0'],  canon:k._0, block:b[0], indexed:["W"]},
			'0078':{ u:'0078', i:88, name:'LATIN SMALL LETTER X', cat:c.Ll,  relatives:['02e3', '1e8b', '1e8d', '2093', '2178', '2179', '217a', '217b', '24b3', '24e7', '33d3', 'ff58', '1d431', '1d465', '1d499', '1d4cd', '1d501', '1d535', '1d569', '1d59d', '1d5d1', '1d605', '1d639', '1d66d', '1d6a1'],  canon:k._0, block:b[0], indexed:["X"]},
			'0079':{ u:'0079', i:89, name:'LATIN SMALL LETTER Y', cat:c.Ll,  relatives:['00fd', '00ff', '0177', '0233', '02b8', '1e8f', '1e99', '1ef3', '1ef5', '1ef7', '1ef9', '24b4', '24e8', '33c9', 'ff59', '1d432', '1d466', '1d49a', '1d4ce', '1d502', '1d536', '1d56a', '1d59e', '1d5d2', '1d606', '1d63a', '1d66e', '1d6a2'],  canon:k._0, block:b[0], indexed:["Y"]},
			'007a':{ u:'007a', i:90, name:'LATIN SMALL LETTER Z', cat:c.Ll,  relatives:['017a', '017c', '017e', '01f2', '01f3', '1dbb', '1e91', '1e93', '1e95', '24b5', '24e9', '3390', '3391', '3392', '3393', '3394', 'ff5a', '1d433', '1d467', '1d49b', '1d4cf', '1d503', '1d537', '1d56b', '1d59f', '1d5d3', '1d607', '1d63b', '1d66f', '1d6a3'],  canon:k._0, block:b[0], indexed:["Z"]},
			'007b':{ u:'007b', i:91, name:'LEFT CURLY BRACKET', cat:c.Ps,  relatives:['fe37', 'fe5b', 'ff5b'],  canon:k._0, block:b[0]},
			'007c':{ u:'007c', i:92, name:'VERTICAL LINE', cat:c.Sm,  relatives:['ff5c'],  canon:k._0, block:b[0]},
			'007d':{ u:'007d', i:93, name:'RIGHT CURLY BRACKET', cat:c.Pe,  relatives:['fe38', 'fe5c', 'ff5d'],  canon:k._0, block:b[0]},
			'007e':{ u:'007e', i:94, name:'TILDE', cat:c.Sm,  relatives:['ff5e'],  canon:k._0, block:b[0]},
			'00a0':{ u:'00a0', i:95, name:'NO-BREAK SPACE', cat:c.Zs,  relatives:['0020'],  canon:k._0, block:b[1]},
			'00a1':{ u:'00a1', i:96, name:'INVERTED EXCLAMATION MARK', cat:c.Po,   canon:k._0, block:b[1]},
			'00a2':{ u:'00a2', i:97, name:'CENT SIGN', cat:c.Sc,  relatives:['ffe0'],  canon:k._0, block:b[1]},
			'00a3':{ u:'00a3', i:98, name:'POUND SIGN', cat:c.Sc,  relatives:['ffe1'],  canon:k._0, block:b[1]},
			'00a4':{ u:'00a4', i:99, name:'CURRENCY SIGN', cat:c.Sc,   canon:k._0, block:b[1]},
			'00a5':{ u:'00a5', i:100, name:'YEN SIGN', cat:c.Sc,  relatives:['ffe5'],  canon:k._0, block:b[1]},
			'00a6':{ u:'00a6', i:101, name:'BROKEN BAR', cat:c.So,  relatives:['ffe4'],  canon:k._0, block:b[1]},
			'00a7':{ u:'00a7', i:102, name:'SECTION SIGN', cat:c.Po,   canon:k._0, block:b[1]},
			'00a8':{ u:'00a8', i:103, name:'DIAERESIS', cat:c.Sk,  relatives:['0020', '0308', '0385', '1fc1', '1fed'], comp:['0020','0308'], canon:k._0, block:b[1]},
			'00a9':{ u:'00a9', i:104, name:'COPYRIGHT SIGN', cat:c.So,   canon:k._0, block:b[1]},
			'00aa':{ u:'00aa', i:105, name:'FEMININE ORDINAL INDICATOR', cat:c.Lo,  relatives:['0061'],  canon:k._0, block:b[1]},
			'00ab':{ u:'00ab', i:106, name:'LEFT-POINTING DOUBLE ANGLE QUOTATION MARK', cat:c.Pi,   canon:k._0, block:b[1]},
			'00ac':{ u:'00ac', i:107, name:'NOT SIGN', cat:c.Sm,  relatives:['ffe2'],  canon:k._0, block:b[1]},
			'00ad':{ u:'00ad', i:108, name:'SOFT HYPHEN', cat:c.Cf,   canon:k._0, block:b[1]},
			'00ae':{ u:'00ae', i:109, name:'REGISTERED SIGN', cat:c.So,   canon:k._0, block:b[1]},
			'00af':{ u:'00af', i:110, name:'MACRON', cat:c.Sk,  relatives:['0020', '0304', 'ffe3'], comp:['0020','0304'], canon:k._0, block:b[1]},
			'00b0':{ u:'00b0', i:111, name:'DEGREE SIGN', cat:c.So,  relatives:['2103', '2109'],  canon:k._0, block:b[1]},
			'00b1':{ u:'00b1', i:112, name:'PLUS-MINUS SIGN', cat:c.Sm,   canon:k._0, block:b[1]},
			'00b2':{ u:'00b2', i:113, name:'SUPERSCRIPT TWO', cat:c.No,  relatives:['0032', '3378', '339f', '33a0', '33a1', '33a2', '33a8', '33af'],  canon:k._0, block:b[1]},
			'00b3':{ u:'00b3', i:114, name:'SUPERSCRIPT THREE', cat:c.No,  relatives:['0033', '3379', '33a3', '33a4', '33a5', '33a6'],  canon:k._0, block:b[1]},
			'00b4':{ u:'00b4', i:115, name:'ACUTE ACCENT', cat:c.Sk,  relatives:['0020', '0301', '1ffd'], comp:['0020','0301'], canon:k._0, block:b[1]},
			'00b5':{ u:'00b5', i:116, name:'MICRO SIGN', cat:c.Ll,  relatives:['03bc'],  canon:k._0, block:b[1]},
			'00b6':{ u:'00b6', i:117, name:'PILCROW SIGN', cat:c.Po,   canon:k._0, block:b[1]},
			'00b7':{ u:'00b7', i:118, name:'MIDDLE DOT', cat:c.Po,  relatives:['013f', '0140', '0387'],  canon:k._0, block:b[1]},
			'00b8':{ u:'00b8', i:119, name:'CEDILLA', cat:c.Sk,  relatives:['0020', '0327'], comp:['0020','0327'], canon:k._0, block:b[1]},
			'00b9':{ u:'00b9', i:120, name:'SUPERSCRIPT ONE', cat:c.No,  relatives:['0031'],  canon:k._0, block:b[1]},
			'00ba':{ u:'00ba', i:121, name:'MASCULINE ORDINAL INDICATOR', cat:c.Lo,  relatives:['006f'],  canon:k._0, block:b[1]},
			'00bb':{ u:'00bb', i:122, name:'RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK', cat:c.Pf,   canon:k._0, block:b[1]},
			'00bc':{ u:'00bc', i:123, name:'VULGAR FRACTION ONE QUARTER', cat:c.No,  relatives:['0031', '2044', '0034'], comp:['0031','2044','0034'], canon:k._0, block:b[1]},
			'00bd':{ u:'00bd', i:124, name:'VULGAR FRACTION ONE HALF', cat:c.No,  relatives:['0031', '2044', '0032'], comp:['0031','2044','0032'], canon:k._0, block:b[1]},
			'00be':{ u:'00be', i:125, name:'VULGAR FRACTION THREE QUARTERS', cat:c.No,  relatives:['0033', '2044', '0034'], comp:['0033','2044','0034'], canon:k._0, block:b[1]},
			'00bf':{ u:'00bf', i:126, name:'INVERTED QUESTION MARK', cat:c.Po,   canon:k._0, block:b[1]},
			'00c0':{ u:'00c0', i:127, name:'LATIN CAPITAL LETTER A WITH GRAVE', cat:c.Lu,  relatives:['0041', '0300'], comp:['0041','0300'], canon:k._0, block:b[1], indexed:["A"]},
			'00c1':{ u:'00c1', i:128, name:'LATIN CAPITAL LETTER A WITH ACUTE', cat:c.Lu,  relatives:['0041', '0301'], comp:['0041','0301'], canon:k._0, block:b[1], indexed:["A"]},
			'00c2':{ u:'00c2', i:129, name:'LATIN CAPITAL LETTER A WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0041', '0302', '1ea4', '1ea6', '1ea8', '1eaa'], comp:['0041','0302'], canon:k._0, block:b[1], indexed:["A"]},
			'00c3':{ u:'00c3', i:130, name:'LATIN CAPITAL LETTER A WITH TILDE', cat:c.Lu,  relatives:['0041', '0303'], comp:['0041','0303'], canon:k._0, block:b[1], indexed:["A"]},
			'00c4':{ u:'00c4', i:131, name:'LATIN CAPITAL LETTER A WITH DIAERESIS', cat:c.Lu,  relatives:['0041', '0308', '01de'], comp:['0041','0308'], canon:k._0, block:b[1], indexed:["A"]},
			'00c5':{ u:'00c5', i:132, name:'LATIN CAPITAL LETTER A WITH RING ABOVE', cat:c.Lu,  relatives:['0041', '030a', '01fa', '212b'], comp:['0041','030a'], canon:k._0, block:b[1], indexed:["A"]},
			'00c6':{ u:'00c6', i:133, name:'LATIN CAPITAL LETTER AE', cat:c.Lu,  relatives:['01e2', '01fc', '1d2d'],  canon:k._0, block:b[1]},
			'00c7':{ u:'00c7', i:134, name:'LATIN CAPITAL LETTER C WITH CEDILLA', cat:c.Lu,  relatives:['0043', '0327', '1e08'], comp:['0043','0327'], canon:k._0, block:b[1], indexed:["C"]},
			'00c8':{ u:'00c8', i:135, name:'LATIN CAPITAL LETTER E WITH GRAVE', cat:c.Lu,  relatives:['0045', '0300'], comp:['0045','0300'], canon:k._0, block:b[1], indexed:["E"]},
			'00c9':{ u:'00c9', i:136, name:'LATIN CAPITAL LETTER E WITH ACUTE', cat:c.Lu,  relatives:['0045', '0301'], comp:['0045','0301'], canon:k._0, block:b[1], indexed:["E"]},
			'00ca':{ u:'00ca', i:137, name:'LATIN CAPITAL LETTER E WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0045', '0302', '1ebe', '1ec0', '1ec2', '1ec4'], comp:['0045','0302'], canon:k._0, block:b[1], indexed:["E"]},
			'00cb':{ u:'00cb', i:138, name:'LATIN CAPITAL LETTER E WITH DIAERESIS', cat:c.Lu,  relatives:['0045', '0308'], comp:['0045','0308'], canon:k._0, block:b[1], indexed:["E"]},
			'00cc':{ u:'00cc', i:139, name:'LATIN CAPITAL LETTER I WITH GRAVE', cat:c.Lu,  relatives:['0049', '0300'], comp:['0049','0300'], canon:k._0, block:b[1], indexed:["I"]},
			'00cd':{ u:'00cd', i:140, name:'LATIN CAPITAL LETTER I WITH ACUTE', cat:c.Lu,  relatives:['0049', '0301'], comp:['0049','0301'], canon:k._0, block:b[1], indexed:["I"]},
			'00ce':{ u:'00ce', i:141, name:'LATIN CAPITAL LETTER I WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0049', '0302'], comp:['0049','0302'], canon:k._0, block:b[1], indexed:["I"]},
			'00cf':{ u:'00cf', i:142, name:'LATIN CAPITAL LETTER I WITH DIAERESIS', cat:c.Lu,  relatives:['0049', '0308', '1e2e'], comp:['0049','0308'], canon:k._0, block:b[1], indexed:["I"]},
			'00d0':{ u:'00d0', i:143, name:'LATIN CAPITAL LETTER ETH', cat:c.Lu,   canon:k._0, block:b[1]},
			'00d1':{ u:'00d1', i:144, name:'LATIN CAPITAL LETTER N WITH TILDE', cat:c.Lu,  relatives:['004e', '0303'], comp:['004e','0303'], canon:k._0, block:b[1], indexed:["N"]},
			'00d2':{ u:'00d2', i:145, name:'LATIN CAPITAL LETTER O WITH GRAVE', cat:c.Lu,  relatives:['004f', '0300'], comp:['004f','0300'], canon:k._0, block:b[1], indexed:["O"]},
			'00d3':{ u:'00d3', i:146, name:'LATIN CAPITAL LETTER O WITH ACUTE', cat:c.Lu,  relatives:['004f', '0301'], comp:['004f','0301'], canon:k._0, block:b[1], indexed:["O"]},
			'00d4':{ u:'00d4', i:147, name:'LATIN CAPITAL LETTER O WITH CIRCUMFLEX', cat:c.Lu,  relatives:['004f', '0302', '1ed0', '1ed2', '1ed4', '1ed6'], comp:['004f','0302'], canon:k._0, block:b[1], indexed:["O"]},
			'00d5':{ u:'00d5', i:148, name:'LATIN CAPITAL LETTER O WITH TILDE', cat:c.Lu,  relatives:['004f', '0303', '022c', '1e4c', '1e4e'], comp:['004f','0303'], canon:k._0, block:b[1], indexed:["O"]},
			'00d6':{ u:'00d6', i:149, name:'LATIN CAPITAL LETTER O WITH DIAERESIS', cat:c.Lu,  relatives:['004f', '0308', '022a'], comp:['004f','0308'], canon:k._0, block:b[1], indexed:["O"]},
			'00d7':{ u:'00d7', i:150, name:'MULTIPLICATION SIGN', cat:c.Sm,   canon:k._0, block:b[1]},
			'00d8':{ u:'00d8', i:151, name:'LATIN CAPITAL LETTER O WITH STROKE', cat:c.Lu,  relatives:['01fe'],  canon:k._0, block:b[1], indexed:["O"]},
			'00d9':{ u:'00d9', i:152, name:'LATIN CAPITAL LETTER U WITH GRAVE', cat:c.Lu,  relatives:['0055', '0300'], comp:['0055','0300'], canon:k._0, block:b[1], indexed:["U"]},
			'00da':{ u:'00da', i:153, name:'LATIN CAPITAL LETTER U WITH ACUTE', cat:c.Lu,  relatives:['0055', '0301'], comp:['0055','0301'], canon:k._0, block:b[1], indexed:["U"]},
			'00db':{ u:'00db', i:154, name:'LATIN CAPITAL LETTER U WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0055', '0302'], comp:['0055','0302'], canon:k._0, block:b[1], indexed:["U"]},
			'00dc':{ u:'00dc', i:155, name:'LATIN CAPITAL LETTER U WITH DIAERESIS', cat:c.Lu,  relatives:['0055', '0308', '01d5', '01d7', '01d9', '01db'], comp:['0055','0308'], canon:k._0, block:b[1], indexed:["U"]},
			'00dd':{ u:'00dd', i:156, name:'LATIN CAPITAL LETTER Y WITH ACUTE', cat:c.Lu,  relatives:['0059', '0301'], comp:['0059','0301'], canon:k._0, block:b[1], indexed:["Y"]},
			'00de':{ u:'00de', i:157, name:'LATIN CAPITAL LETTER THORN', cat:c.Lu,   canon:k._0, block:b[1]},
			'00df':{ u:'00df', i:158, name:'LATIN SMALL LETTER SHARP S', cat:c.Ll,   canon:k._0, block:b[1], indexed:["S"]},
			'00e0':{ u:'00e0', i:159, name:'LATIN SMALL LETTER A WITH GRAVE', cat:c.Ll,  relatives:['0061', '0300'], comp:['0061','0300'], canon:k._0, block:b[1], indexed:["A"]},
			'00e1':{ u:'00e1', i:160, name:'LATIN SMALL LETTER A WITH ACUTE', cat:c.Ll,  relatives:['0061', '0301'], comp:['0061','0301'], canon:k._0, block:b[1], indexed:["A"]},
			'00e2':{ u:'00e2', i:161, name:'LATIN SMALL LETTER A WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0061', '0302', '1ea5', '1ea7', '1ea9', '1eab'], comp:['0061','0302'], canon:k._0, block:b[1], indexed:["A"]},
			'00e3':{ u:'00e3', i:162, name:'LATIN SMALL LETTER A WITH TILDE', cat:c.Ll,  relatives:['0061', '0303'], comp:['0061','0303'], canon:k._0, block:b[1], indexed:["A"]},
			'00e4':{ u:'00e4', i:163, name:'LATIN SMALL LETTER A WITH DIAERESIS', cat:c.Ll,  relatives:['0061', '0308', '01df'], comp:['0061','0308'], canon:k._0, block:b[1], indexed:["A"]},
			'00e5':{ u:'00e5', i:164, name:'LATIN SMALL LETTER A WITH RING ABOVE', cat:c.Ll,  relatives:['0061', '030a', '01fb'], comp:['0061','030a'], canon:k._0, block:b[1], indexed:["A"]},
			'00e6':{ u:'00e6', i:165, name:'LATIN SMALL LETTER AE', cat:c.Ll,  relatives:['01e3', '01fd', '10783'],  canon:k._0, block:b[1]},
			'00e7':{ u:'00e7', i:166, name:'LATIN SMALL LETTER C WITH CEDILLA', cat:c.Ll,  relatives:['0063', '0327', '1e09'], comp:['0063','0327'], canon:k._0, block:b[1], indexed:["C"]},
			'00e8':{ u:'00e8', i:167, name:'LATIN SMALL LETTER E WITH GRAVE', cat:c.Ll,  relatives:['0065', '0300'], comp:['0065','0300'], canon:k._0, block:b[1], indexed:["E"]},
			'00e9':{ u:'00e9', i:168, name:'LATIN SMALL LETTER E WITH ACUTE', cat:c.Ll,  relatives:['0065', '0301'], comp:['0065','0301'], canon:k._0, block:b[1], indexed:["E"]},
			'00ea':{ u:'00ea', i:169, name:'LATIN SMALL LETTER E WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0065', '0302', '1ebf', '1ec1', '1ec3', '1ec5'], comp:['0065','0302'], canon:k._0, block:b[1], indexed:["E"]},
			'00eb':{ u:'00eb', i:170, name:'LATIN SMALL LETTER E WITH DIAERESIS', cat:c.Ll,  relatives:['0065', '0308'], comp:['0065','0308'], canon:k._0, block:b[1], indexed:["E"]},
			'00ec':{ u:'00ec', i:171, name:'LATIN SMALL LETTER I WITH GRAVE', cat:c.Ll,  relatives:['0069', '0300'], comp:['0069','0300'], canon:k._0, block:b[1], indexed:["I"]},
			'00ed':{ u:'00ed', i:172, name:'LATIN SMALL LETTER I WITH ACUTE', cat:c.Ll,  relatives:['0069', '0301'], comp:['0069','0301'], canon:k._0, block:b[1], indexed:["I"]},
			'00ee':{ u:'00ee', i:173, name:'LATIN SMALL LETTER I WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0069', '0302'], comp:['0069','0302'], canon:k._0, block:b[1], indexed:["I"]},
			'00ef':{ u:'00ef', i:174, name:'LATIN SMALL LETTER I WITH DIAERESIS', cat:c.Ll,  relatives:['0069', '0308', '1e2f'], comp:['0069','0308'], canon:k._0, block:b[1], indexed:["I"]},
			'00f0':{ u:'00f0', i:175, name:'LATIN SMALL LETTER ETH', cat:c.Ll,  relatives:['1d9e'],  canon:k._0, block:b[1]},
			'00f1':{ u:'00f1', i:176, name:'LATIN SMALL LETTER N WITH TILDE', cat:c.Ll,  relatives:['006e', '0303'], comp:['006e','0303'], canon:k._0, block:b[1], indexed:["N"]},
			'00f2':{ u:'00f2', i:177, name:'LATIN SMALL LETTER O WITH GRAVE', cat:c.Ll,  relatives:['006f', '0300'], comp:['006f','0300'], canon:k._0, block:b[1], indexed:["O"]},
			'00f3':{ u:'00f3', i:178, name:'LATIN SMALL LETTER O WITH ACUTE', cat:c.Ll,  relatives:['006f', '0301'], comp:['006f','0301'], canon:k._0, block:b[1], indexed:["O"]},
			'00f4':{ u:'00f4', i:179, name:'LATIN SMALL LETTER O WITH CIRCUMFLEX', cat:c.Ll,  relatives:['006f', '0302', '1ed1', '1ed3', '1ed5', '1ed7'], comp:['006f','0302'], canon:k._0, block:b[1], indexed:["O"]},
			'00f5':{ u:'00f5', i:180, name:'LATIN SMALL LETTER O WITH TILDE', cat:c.Ll,  relatives:['006f', '0303', '022d', '1e4d', '1e4f'], comp:['006f','0303'], canon:k._0, block:b[1], indexed:["O"]},
			'00f6':{ u:'00f6', i:181, name:'LATIN SMALL LETTER O WITH DIAERESIS', cat:c.Ll,  relatives:['006f', '0308', '022b'], comp:['006f','0308'], canon:k._0, block:b[1], indexed:["O"]},
			'00f7':{ u:'00f7', i:182, name:'DIVISION SIGN', cat:c.Sm,   canon:k._0, block:b[1]},
			'00f8':{ u:'00f8', i:183, name:'LATIN SMALL LETTER O WITH STROKE', cat:c.Ll,  relatives:['01ff', '107a2'],  canon:k._0, block:b[1], indexed:["O"]},
			'00f9':{ u:'00f9', i:184, name:'LATIN SMALL LETTER U WITH GRAVE', cat:c.Ll,  relatives:['0075', '0300'], comp:['0075','0300'], canon:k._0, block:b[1], indexed:["U"]},
			'00fa':{ u:'00fa', i:185, name:'LATIN SMALL LETTER U WITH ACUTE', cat:c.Ll,  relatives:['0075', '0301'], comp:['0075','0301'], canon:k._0, block:b[1], indexed:["U"]},
			'00fb':{ u:'00fb', i:186, name:'LATIN SMALL LETTER U WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0075', '0302'], comp:['0075','0302'], canon:k._0, block:b[1], indexed:["U"]},
			'00fc':{ u:'00fc', i:187, name:'LATIN SMALL LETTER U WITH DIAERESIS', cat:c.Ll,  relatives:['0075', '0308', '01d6', '01d8', '01da', '01dc'], comp:['0075','0308'], canon:k._0, block:b[1], indexed:["U"]},
			'00fd':{ u:'00fd', i:188, name:'LATIN SMALL LETTER Y WITH ACUTE', cat:c.Ll,  relatives:['0079', '0301'], comp:['0079','0301'], canon:k._0, block:b[1], indexed:["Y"]},
			'00fe':{ u:'00fe', i:189, name:'LATIN SMALL LETTER THORN', cat:c.Ll,   canon:k._0, block:b[1]},
			'00ff':{ u:'00ff', i:190, name:'LATIN SMALL LETTER Y WITH DIAERESIS', cat:c.Ll,  relatives:['0079', '0308'], comp:['0079','0308'], canon:k._0, block:b[1], indexed:["Y"]},
			'0100':{ u:'0100', i:191, name:'LATIN CAPITAL LETTER A WITH MACRON', cat:c.Lu,  relatives:['0041', '0304'], comp:['0041','0304'], canon:k._0, block:b[2], indexed:["A"]},
			'0101':{ u:'0101', i:192, name:'LATIN SMALL LETTER A WITH MACRON', cat:c.Ll,  relatives:['0061', '0304'], comp:['0061','0304'], canon:k._0, block:b[2], indexed:["A"]},
			'0102':{ u:'0102', i:193, name:'LATIN CAPITAL LETTER A WITH BREVE', cat:c.Lu,  relatives:['0041', '0306', '1eae', '1eb0', '1eb2', '1eb4'], comp:['0041','0306'], canon:k._0, block:b[2], indexed:["A"]},
			'0103':{ u:'0103', i:194, name:'LATIN SMALL LETTER A WITH BREVE', cat:c.Ll,  relatives:['0061', '0306', '1eaf', '1eb1', '1eb3', '1eb5'], comp:['0061','0306'], canon:k._0, block:b[2], indexed:["A"]},
			'0104':{ u:'0104', i:195, name:'LATIN CAPITAL LETTER A WITH OGONEK', cat:c.Lu,  relatives:['0041', '0328'], comp:['0041','0328'], canon:k._0, block:b[2], indexed:["A"]},
			'0105':{ u:'0105', i:196, name:'LATIN SMALL LETTER A WITH OGONEK', cat:c.Ll,  relatives:['0061', '0328'], comp:['0061','0328'], canon:k._0, block:b[2], indexed:["A"]},
			'0106':{ u:'0106', i:197, name:'LATIN CAPITAL LETTER C WITH ACUTE', cat:c.Lu,  relatives:['0043', '0301'], comp:['0043','0301'], canon:k._0, block:b[2], indexed:["C"]},
			'0107':{ u:'0107', i:198, name:'LATIN SMALL LETTER C WITH ACUTE', cat:c.Ll,  relatives:['0063', '0301'], comp:['0063','0301'], canon:k._0, block:b[2], indexed:["C"]},
			'0108':{ u:'0108', i:199, name:'LATIN CAPITAL LETTER C WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0043', '0302'], comp:['0043','0302'], canon:k._0, block:b[2], indexed:["C"]},
			'0109':{ u:'0109', i:200, name:'LATIN SMALL LETTER C WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0063', '0302'], comp:['0063','0302'], canon:k._0, block:b[2], indexed:["C"]},
			'010a':{ u:'010a', i:201, name:'LATIN CAPITAL LETTER C WITH DOT ABOVE', cat:c.Lu,  relatives:['0043', '0307'], comp:['0043','0307'], canon:k._0, block:b[2], indexed:["C"]},
			'010b':{ u:'010b', i:202, name:'LATIN SMALL LETTER C WITH DOT ABOVE', cat:c.Ll,  relatives:['0063', '0307'], comp:['0063','0307'], canon:k._0, block:b[2], indexed:["C"]},
			'010c':{ u:'010c', i:203, name:'LATIN CAPITAL LETTER C WITH CARON', cat:c.Lu,  relatives:['0043', '030c'], comp:['0043','030c'], canon:k._0, block:b[2], indexed:["C"]},
			'010d':{ u:'010d', i:204, name:'LATIN SMALL LETTER C WITH CARON', cat:c.Ll,  relatives:['0063', '030c'], comp:['0063','030c'], canon:k._0, block:b[2], indexed:["C"]},
			'010e':{ u:'010e', i:205, name:'LATIN CAPITAL LETTER D WITH CARON', cat:c.Lu,  relatives:['0044', '030c'], comp:['0044','030c'], canon:k._0, block:b[2], indexed:["D"]},
			'010f':{ u:'010f', i:206, name:'LATIN SMALL LETTER D WITH CARON', cat:c.Ll,  relatives:['0064', '030c'], comp:['0064','030c'], canon:k._0, block:b[2], indexed:["D"]},
			'0110':{ u:'0110', i:207, name:'LATIN CAPITAL LETTER D WITH STROKE', cat:c.Lu,   canon:k._0, block:b[2], indexed:["D"]},
			'0111':{ u:'0111', i:208, name:'LATIN SMALL LETTER D WITH STROKE', cat:c.Ll,   canon:k._0, block:b[2], indexed:["D"]},
			'0112':{ u:'0112', i:209, name:'LATIN CAPITAL LETTER E WITH MACRON', cat:c.Lu,  relatives:['0045', '0304', '1e14', '1e16'], comp:['0045','0304'], canon:k._0, block:b[2], indexed:["E"]},
			'0113':{ u:'0113', i:210, name:'LATIN SMALL LETTER E WITH MACRON', cat:c.Ll,  relatives:['0065', '0304', '1e15', '1e17'], comp:['0065','0304'], canon:k._0, block:b[2], indexed:["E"]},
			'0114':{ u:'0114', i:211, name:'LATIN CAPITAL LETTER E WITH BREVE', cat:c.Lu,  relatives:['0045', '0306'], comp:['0045','0306'], canon:k._0, block:b[2], indexed:["E"]},
			'0115':{ u:'0115', i:212, name:'LATIN SMALL LETTER E WITH BREVE', cat:c.Ll,  relatives:['0065', '0306'], comp:['0065','0306'], canon:k._0, block:b[2], indexed:["E"]},
			'0116':{ u:'0116', i:213, name:'LATIN CAPITAL LETTER E WITH DOT ABOVE', cat:c.Lu,  relatives:['0045', '0307'], comp:['0045','0307'], canon:k._0, block:b[2], indexed:["E"]},
			'0117':{ u:'0117', i:214, name:'LATIN SMALL LETTER E WITH DOT ABOVE', cat:c.Ll,  relatives:['0065', '0307'], comp:['0065','0307'], canon:k._0, block:b[2], indexed:["E"]},
			'0118':{ u:'0118', i:215, name:'LATIN CAPITAL LETTER E WITH OGONEK', cat:c.Lu,  relatives:['0045', '0328'], comp:['0045','0328'], canon:k._0, block:b[2], indexed:["E"]},
			'0119':{ u:'0119', i:216, name:'LATIN SMALL LETTER E WITH OGONEK', cat:c.Ll,  relatives:['0065', '0328'], comp:['0065','0328'], canon:k._0, block:b[2], indexed:["E"]},
			'011a':{ u:'011a', i:217, name:'LATIN CAPITAL LETTER E WITH CARON', cat:c.Lu,  relatives:['0045', '030c'], comp:['0045','030c'], canon:k._0, block:b[2], indexed:["E"]},
			'011b':{ u:'011b', i:218, name:'LATIN SMALL LETTER E WITH CARON', cat:c.Ll,  relatives:['0065', '030c'], comp:['0065','030c'], canon:k._0, block:b[2], indexed:["E"]},
			'011c':{ u:'011c', i:219, name:'LATIN CAPITAL LETTER G WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0047', '0302'], comp:['0047','0302'], canon:k._0, block:b[2], indexed:["G"]},
			'011d':{ u:'011d', i:220, name:'LATIN SMALL LETTER G WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0067', '0302'], comp:['0067','0302'], canon:k._0, block:b[2], indexed:["G"]},
			'011e':{ u:'011e', i:221, name:'LATIN CAPITAL LETTER G WITH BREVE', cat:c.Lu,  relatives:['0047', '0306'], comp:['0047','0306'], canon:k._0, block:b[2], indexed:["G"]},
			'011f':{ u:'011f', i:222, name:'LATIN SMALL LETTER G WITH BREVE', cat:c.Ll,  relatives:['0067', '0306'], comp:['0067','0306'], canon:k._0, block:b[2], indexed:["G"]},
			'0120':{ u:'0120', i:223, name:'LATIN CAPITAL LETTER G WITH DOT ABOVE', cat:c.Lu,  relatives:['0047', '0307'], comp:['0047','0307'], canon:k._0, block:b[2], indexed:["G"]},
			'0121':{ u:'0121', i:224, name:'LATIN SMALL LETTER G WITH DOT ABOVE', cat:c.Ll,  relatives:['0067', '0307'], comp:['0067','0307'], canon:k._0, block:b[2], indexed:["G"]},
			'0122':{ u:'0122', i:225, name:'LATIN CAPITAL LETTER G WITH CEDILLA', cat:c.Lu,  relatives:['0047', '0327'], comp:['0047','0327'], canon:k._0, block:b[2], indexed:["G"]},
			'0123':{ u:'0123', i:226, name:'LATIN SMALL LETTER G WITH CEDILLA', cat:c.Ll,  relatives:['0067', '0327'], comp:['0067','0327'], canon:k._0, block:b[2], indexed:["G"]},
			'0124':{ u:'0124', i:227, name:'LATIN CAPITAL LETTER H WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0048', '0302'], comp:['0048','0302'], canon:k._0, block:b[2], indexed:["H"]},
			'0125':{ u:'0125', i:228, name:'LATIN SMALL LETTER H WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0068', '0302'], comp:['0068','0302'], canon:k._0, block:b[2], indexed:["H"]},
			'0126':{ u:'0126', i:229, name:'LATIN CAPITAL LETTER H WITH STROKE', cat:c.Lu,  relatives:['a7f8'],  canon:k._0, block:b[2], indexed:["H"]},
			'0127':{ u:'0127', i:230, name:'LATIN SMALL LETTER H WITH STROKE', cat:c.Ll,  relatives:['210f', '10795'],  canon:k._0, block:b[2], indexed:["H"]},
			'0128':{ u:'0128', i:231, name:'LATIN CAPITAL LETTER I WITH TILDE', cat:c.Lu,  relatives:['0049', '0303'], comp:['0049','0303'], canon:k._0, block:b[2], indexed:["I"]},
			'0129':{ u:'0129', i:232, name:'LATIN SMALL LETTER I WITH TILDE', cat:c.Ll,  relatives:['0069', '0303'], comp:['0069','0303'], canon:k._0, block:b[2], indexed:["I"]},
			'012a':{ u:'012a', i:233, name:'LATIN CAPITAL LETTER I WITH MACRON', cat:c.Lu,  relatives:['0049', '0304'], comp:['0049','0304'], canon:k._0, block:b[2], indexed:["I"]},
			'012b':{ u:'012b', i:234, name:'LATIN SMALL LETTER I WITH MACRON', cat:c.Ll,  relatives:['0069', '0304'], comp:['0069','0304'], canon:k._0, block:b[2], indexed:["I"]},
			'012c':{ u:'012c', i:235, name:'LATIN CAPITAL LETTER I WITH BREVE', cat:c.Lu,  relatives:['0049', '0306'], comp:['0049','0306'], canon:k._0, block:b[2], indexed:["I"]},
			'012d':{ u:'012d', i:236, name:'LATIN SMALL LETTER I WITH BREVE', cat:c.Ll,  relatives:['0069', '0306'], comp:['0069','0306'], canon:k._0, block:b[2], indexed:["I"]},
			'012e':{ u:'012e', i:237, name:'LATIN CAPITAL LETTER I WITH OGONEK', cat:c.Lu,  relatives:['0049', '0328'], comp:['0049','0328'], canon:k._0, block:b[2], indexed:["I"]},
			'012f':{ u:'012f', i:238, name:'LATIN SMALL LETTER I WITH OGONEK', cat:c.Ll,  relatives:['0069', '0328'], comp:['0069','0328'], canon:k._0, block:b[2], indexed:["I"]},
			'0130':{ u:'0130', i:239, name:'LATIN CAPITAL LETTER I WITH DOT ABOVE', cat:c.Lu,  relatives:['0049', '0307'], comp:['0049','0307'], canon:k._0, block:b[2], indexed:["I"]},
			'0131':{ u:'0131', i:240, name:'LATIN SMALL LETTER DOTLESS I', cat:c.Ll,  relatives:['1d6a4'],  canon:k._0, block:b[2], indexed:["I"]},
			'0132':{ u:'0132', i:241, name:'LATIN CAPITAL LIGATURE IJ', cat:c.Lu,  relatives:['0049', '004a'], comp:['0049','004a'], canon:k._0, block:b[2]},
			'0133':{ u:'0133', i:242, name:'LATIN SMALL LIGATURE IJ', cat:c.Ll,  relatives:['0069', '006a'], comp:['0069','006a'], canon:k._0, block:b[2]},
			'0134':{ u:'0134', i:243, name:'LATIN CAPITAL LETTER J WITH CIRCUMFLEX', cat:c.Lu,  relatives:['004a', '0302'], comp:['004a','0302'], canon:k._0, block:b[2], indexed:["J"]},
			'0135':{ u:'0135', i:244, name:'LATIN SMALL LETTER J WITH CIRCUMFLEX', cat:c.Ll,  relatives:['006a', '0302'], comp:['006a','0302'], canon:k._0, block:b[2], indexed:["J"]},
			'0136':{ u:'0136', i:245, name:'LATIN CAPITAL LETTER K WITH CEDILLA', cat:c.Lu,  relatives:['004b', '0327'], comp:['004b','0327'], canon:k._0, block:b[2], indexed:["K"]},
			'0137':{ u:'0137', i:246, name:'LATIN SMALL LETTER K WITH CEDILLA', cat:c.Ll,  relatives:['006b', '0327'], comp:['006b','0327'], canon:k._0, block:b[2], indexed:["K"]},
			'0138':{ u:'0138', i:247, name:'LATIN SMALL LETTER KRA', cat:c.Ll,   canon:k._0, block:b[2]},
			'0139':{ u:'0139', i:248, name:'LATIN CAPITAL LETTER L WITH ACUTE', cat:c.Lu,  relatives:['004c', '0301'], comp:['004c','0301'], canon:k._0, block:b[2], indexed:["L"]},
			'013a':{ u:'013a', i:249, name:'LATIN SMALL LETTER L WITH ACUTE', cat:c.Ll,  relatives:['006c', '0301'], comp:['006c','0301'], canon:k._0, block:b[2], indexed:["L"]},
			'013b':{ u:'013b', i:250, name:'LATIN CAPITAL LETTER L WITH CEDILLA', cat:c.Lu,  relatives:['004c', '0327'], comp:['004c','0327'], canon:k._0, block:b[2], indexed:["L"]},
			'013c':{ u:'013c', i:251, name:'LATIN SMALL LETTER L WITH CEDILLA', cat:c.Ll,  relatives:['006c', '0327'], comp:['006c','0327'], canon:k._0, block:b[2], indexed:["L"]},
			'013d':{ u:'013d', i:252, name:'LATIN CAPITAL LETTER L WITH CARON', cat:c.Lu,  relatives:['004c', '030c'], comp:['004c','030c'], canon:k._0, block:b[2], indexed:["L"]},
			'013e':{ u:'013e', i:253, name:'LATIN SMALL LETTER L WITH CARON', cat:c.Ll,  relatives:['006c', '030c'], comp:['006c','030c'], canon:k._0, block:b[2], indexed:["L"]},
			'013f':{ u:'013f', i:254, name:'LATIN CAPITAL LETTER L WITH MIDDLE DOT', cat:c.Lu,  relatives:['004c', '00b7'], comp:['004c','00b7'], canon:k._0, block:b[2], indexed:["L"]},
			'0140':{ u:'0140', i:255, name:'LATIN SMALL LETTER L WITH MIDDLE DOT', cat:c.Ll,  relatives:['006c', '00b7'], comp:['006c','00b7'], canon:k._0, block:b[2], indexed:["L"]},
			'0141':{ u:'0141', i:256, name:'LATIN CAPITAL LETTER L WITH STROKE', cat:c.Lu,   canon:k._0, block:b[2], indexed:["L"]},
			'0142':{ u:'0142', i:257, name:'LATIN SMALL LETTER L WITH STROKE', cat:c.Ll,   canon:k._0, block:b[2], indexed:["L"]},
			'0143':{ u:'0143', i:258, name:'LATIN CAPITAL LETTER N WITH ACUTE', cat:c.Lu,  relatives:['004e', '0301'], comp:['004e','0301'], canon:k._0, block:b[2], indexed:["N"]},
			'0144':{ u:'0144', i:259, name:'LATIN SMALL LETTER N WITH ACUTE', cat:c.Ll,  relatives:['006e', '0301'], comp:['006e','0301'], canon:k._0, block:b[2], indexed:["N"]},
			'0145':{ u:'0145', i:260, name:'LATIN CAPITAL LETTER N WITH CEDILLA', cat:c.Lu,  relatives:['004e', '0327'], comp:['004e','0327'], canon:k._0, block:b[2], indexed:["N"]},
			'0146':{ u:'0146', i:261, name:'LATIN SMALL LETTER N WITH CEDILLA', cat:c.Ll,  relatives:['006e', '0327'], comp:['006e','0327'], canon:k._0, block:b[2], indexed:["N"]},
			'0147':{ u:'0147', i:262, name:'LATIN CAPITAL LETTER N WITH CARON', cat:c.Lu,  relatives:['004e', '030c'], comp:['004e','030c'], canon:k._0, block:b[2], indexed:["N"]},
			'0148':{ u:'0148', i:263, name:'LATIN SMALL LETTER N WITH CARON', cat:c.Ll,  relatives:['006e', '030c'], comp:['006e','030c'], canon:k._0, block:b[2], indexed:["N"]},
			'0149':{ u:'0149', i:264, name:'LATIN SMALL LETTER N PRECEDED BY APOSTROPHE', cat:c.Ll,  relatives:['02bc', '006e'], comp:['02bc','006e'], canon:k._0, block:b[2], indexed:["N"]},
			'014a':{ u:'014a', i:265, name:'LATIN CAPITAL LETTER ENG', cat:c.Lu,   canon:k._0, block:b[2]},
			'014b':{ u:'014b', i:266, name:'LATIN SMALL LETTER ENG', cat:c.Ll,  relatives:['1d51'],  canon:k._0, block:b[2]},
			'014c':{ u:'014c', i:267, name:'LATIN CAPITAL LETTER O WITH MACRON', cat:c.Lu,  relatives:['004f', '0304', '1e50', '1e52'], comp:['004f','0304'], canon:k._0, block:b[2], indexed:["O"]},
			'014d':{ u:'014d', i:268, name:'LATIN SMALL LETTER O WITH MACRON', cat:c.Ll,  relatives:['006f', '0304', '1e51', '1e53'], comp:['006f','0304'], canon:k._0, block:b[2], indexed:["O"]},
			'014e':{ u:'014e', i:269, name:'LATIN CAPITAL LETTER O WITH BREVE', cat:c.Lu,  relatives:['004f', '0306'], comp:['004f','0306'], canon:k._0, block:b[2], indexed:["O"]},
			'014f':{ u:'014f', i:270, name:'LATIN SMALL LETTER O WITH BREVE', cat:c.Ll,  relatives:['006f', '0306'], comp:['006f','0306'], canon:k._0, block:b[2], indexed:["O"]},
			'0150':{ u:'0150', i:271, name:'LATIN CAPITAL LETTER O WITH DOUBLE ACUTE', cat:c.Lu,  relatives:['004f', '030b'], comp:['004f','030b'], canon:k._0, block:b[2], indexed:["O"]},
			'0151':{ u:'0151', i:272, name:'LATIN SMALL LETTER O WITH DOUBLE ACUTE', cat:c.Ll,  relatives:['006f', '030b'], comp:['006f','030b'], canon:k._0, block:b[2], indexed:["O"]},
			'0152':{ u:'0152', i:273, name:'LATIN CAPITAL LIGATURE OE', cat:c.Lu,   canon:k._0, block:b[2]},
			'0153':{ u:'0153', i:274, name:'LATIN SMALL LIGATURE OE', cat:c.Ll,  relatives:['a7f9'],  canon:k._0, block:b[2]},
			'0154':{ u:'0154', i:275, name:'LATIN CAPITAL LETTER R WITH ACUTE', cat:c.Lu,  relatives:['0052', '0301'], comp:['0052','0301'], canon:k._0, block:b[2], indexed:["R"]},
			'0155':{ u:'0155', i:276, name:'LATIN SMALL LETTER R WITH ACUTE', cat:c.Ll,  relatives:['0072', '0301'], comp:['0072','0301'], canon:k._0, block:b[2], indexed:["R"]},
			'0156':{ u:'0156', i:277, name:'LATIN CAPITAL LETTER R WITH CEDILLA', cat:c.Lu,  relatives:['0052', '0327'], comp:['0052','0327'], canon:k._0, block:b[2], indexed:["R"]},
			'0157':{ u:'0157', i:278, name:'LATIN SMALL LETTER R WITH CEDILLA', cat:c.Ll,  relatives:['0072', '0327'], comp:['0072','0327'], canon:k._0, block:b[2], indexed:["R"]},
			'0158':{ u:'0158', i:279, name:'LATIN CAPITAL LETTER R WITH CARON', cat:c.Lu,  relatives:['0052', '030c'], comp:['0052','030c'], canon:k._0, block:b[2], indexed:["R"]},
			'0159':{ u:'0159', i:280, name:'LATIN SMALL LETTER R WITH CARON', cat:c.Ll,  relatives:['0072', '030c'], comp:['0072','030c'], canon:k._0, block:b[2], indexed:["R"]},
			'015a':{ u:'015a', i:281, name:'LATIN CAPITAL LETTER S WITH ACUTE', cat:c.Lu,  relatives:['0053', '0301', '1e64'], comp:['0053','0301'], canon:k._0, block:b[2], indexed:["S"]},
			'015b':{ u:'015b', i:282, name:'LATIN SMALL LETTER S WITH ACUTE', cat:c.Ll,  relatives:['0073', '0301', '1e65'], comp:['0073','0301'], canon:k._0, block:b[2], indexed:["S"]},
			'015c':{ u:'015c', i:283, name:'LATIN CAPITAL LETTER S WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0053', '0302'], comp:['0053','0302'], canon:k._0, block:b[2], indexed:["S"]},
			'015d':{ u:'015d', i:284, name:'LATIN SMALL LETTER S WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0073', '0302'], comp:['0073','0302'], canon:k._0, block:b[2], indexed:["S"]},
			'015e':{ u:'015e', i:285, name:'LATIN CAPITAL LETTER S WITH CEDILLA', cat:c.Lu,  relatives:['0053', '0327'], comp:['0053','0327'], canon:k._0, block:b[2], indexed:["S"]},
			'015f':{ u:'015f', i:286, name:'LATIN SMALL LETTER S WITH CEDILLA', cat:c.Ll,  relatives:['0073', '0327'], comp:['0073','0327'], canon:k._0, block:b[2], indexed:["S"]},
			'0160':{ u:'0160', i:287, name:'LATIN CAPITAL LETTER S WITH CARON', cat:c.Lu,  relatives:['0053', '030c', '1e66'], comp:['0053','030c'], canon:k._0, block:b[2], indexed:["S"]},
			'0161':{ u:'0161', i:288, name:'LATIN SMALL LETTER S WITH CARON', cat:c.Ll,  relatives:['0073', '030c', '1e67'], comp:['0073','030c'], canon:k._0, block:b[2], indexed:["S"]},
			'0162':{ u:'0162', i:289, name:'LATIN CAPITAL LETTER T WITH CEDILLA', cat:c.Lu,  relatives:['0054', '0327'], comp:['0054','0327'], canon:k._0, block:b[2], indexed:["T"]},
			'0163':{ u:'0163', i:290, name:'LATIN SMALL LETTER T WITH CEDILLA', cat:c.Ll,  relatives:['0074', '0327'], comp:['0074','0327'], canon:k._0, block:b[2], indexed:["T"]},
			'0164':{ u:'0164', i:291, name:'LATIN CAPITAL LETTER T WITH CARON', cat:c.Lu,  relatives:['0054', '030c'], comp:['0054','030c'], canon:k._0, block:b[2], indexed:["T"]},
			'0165':{ u:'0165', i:292, name:'LATIN SMALL LETTER T WITH CARON', cat:c.Ll,  relatives:['0074', '030c'], comp:['0074','030c'], canon:k._0, block:b[2], indexed:["T"]},
			'0166':{ u:'0166', i:293, name:'LATIN CAPITAL LETTER T WITH STROKE', cat:c.Lu,   canon:k._0, block:b[2], indexed:["T"]},
			'0167':{ u:'0167', i:294, name:'LATIN SMALL LETTER T WITH STROKE', cat:c.Ll,   canon:k._0, block:b[2], indexed:["T"]},
			'0168':{ u:'0168', i:295, name:'LATIN CAPITAL LETTER U WITH TILDE', cat:c.Lu,  relatives:['0055', '0303', '1e78'], comp:['0055','0303'], canon:k._0, block:b[2], indexed:["U"]},
			'0169':{ u:'0169', i:296, name:'LATIN SMALL LETTER U WITH TILDE', cat:c.Ll,  relatives:['0075', '0303', '1e79'], comp:['0075','0303'], canon:k._0, block:b[2], indexed:["U"]},
			'016a':{ u:'016a', i:297, name:'LATIN CAPITAL LETTER U WITH MACRON', cat:c.Lu,  relatives:['0055', '0304', '1e7a'], comp:['0055','0304'], canon:k._0, block:b[2], indexed:["U"]},
			'016b':{ u:'016b', i:298, name:'LATIN SMALL LETTER U WITH MACRON', cat:c.Ll,  relatives:['0075', '0304', '1e7b'], comp:['0075','0304'], canon:k._0, block:b[2], indexed:["U"]},
			'016c':{ u:'016c', i:299, name:'LATIN CAPITAL LETTER U WITH BREVE', cat:c.Lu,  relatives:['0055', '0306'], comp:['0055','0306'], canon:k._0, block:b[2], indexed:["U"]},
			'016d':{ u:'016d', i:300, name:'LATIN SMALL LETTER U WITH BREVE', cat:c.Ll,  relatives:['0075', '0306'], comp:['0075','0306'], canon:k._0, block:b[2], indexed:["U"]},
			'016e':{ u:'016e', i:301, name:'LATIN CAPITAL LETTER U WITH RING ABOVE', cat:c.Lu,  relatives:['0055', '030a'], comp:['0055','030a'], canon:k._0, block:b[2], indexed:["U"]},
			'016f':{ u:'016f', i:302, name:'LATIN SMALL LETTER U WITH RING ABOVE', cat:c.Ll,  relatives:['0075', '030a'], comp:['0075','030a'], canon:k._0, block:b[2], indexed:["U"]},
			'0170':{ u:'0170', i:303, name:'LATIN CAPITAL LETTER U WITH DOUBLE ACUTE', cat:c.Lu,  relatives:['0055', '030b'], comp:['0055','030b'], canon:k._0, block:b[2], indexed:["U"]},
			'0171':{ u:'0171', i:304, name:'LATIN SMALL LETTER U WITH DOUBLE ACUTE', cat:c.Ll,  relatives:['0075', '030b'], comp:['0075','030b'], canon:k._0, block:b[2], indexed:["U"]},
			'0172':{ u:'0172', i:305, name:'LATIN CAPITAL LETTER U WITH OGONEK', cat:c.Lu,  relatives:['0055', '0328'], comp:['0055','0328'], canon:k._0, block:b[2], indexed:["U"]},
			'0173':{ u:'0173', i:306, name:'LATIN SMALL LETTER U WITH OGONEK', cat:c.Ll,  relatives:['0075', '0328'], comp:['0075','0328'], canon:k._0, block:b[2], indexed:["U"]},
			'0174':{ u:'0174', i:307, name:'LATIN CAPITAL LETTER W WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0057', '0302'], comp:['0057','0302'], canon:k._0, block:b[2], indexed:["W"]},
			'0175':{ u:'0175', i:308, name:'LATIN SMALL LETTER W WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0077', '0302'], comp:['0077','0302'], canon:k._0, block:b[2], indexed:["W"]},
			'0176':{ u:'0176', i:309, name:'LATIN CAPITAL LETTER Y WITH CIRCUMFLEX', cat:c.Lu,  relatives:['0059', '0302'], comp:['0059','0302'], canon:k._0, block:b[2], indexed:["Y"]},
			'0177':{ u:'0177', i:310, name:'LATIN SMALL LETTER Y WITH CIRCUMFLEX', cat:c.Ll,  relatives:['0079', '0302'], comp:['0079','0302'], canon:k._0, block:b[2], indexed:["Y"]},
			'0178':{ u:'0178', i:311, name:'LATIN CAPITAL LETTER Y WITH DIAERESIS', cat:c.Lu,  relatives:['0059', '0308'], comp:['0059','0308'], canon:k._0, block:b[2], indexed:["Y"]},
			'0179':{ u:'0179', i:312, name:'LATIN CAPITAL LETTER Z WITH ACUTE', cat:c.Lu,  relatives:['005a', '0301'], comp:['005a','0301'], canon:k._0, block:b[2], indexed:["Z"]},
			'017a':{ u:'017a', i:313, name:'LATIN SMALL LETTER Z WITH ACUTE', cat:c.Ll,  relatives:['007a', '0301'], comp:['007a','0301'], canon:k._0, block:b[2], indexed:["Z"]},
			'017b':{ u:'017b', i:314, name:'LATIN CAPITAL LETTER Z WITH DOT ABOVE', cat:c.Lu,  relatives:['005a', '0307'], comp:['005a','0307'], canon:k._0, block:b[2], indexed:["Z"]},
			'017c':{ u:'017c', i:315, name:'LATIN SMALL LETTER Z WITH DOT ABOVE', cat:c.Ll,  relatives:['007a', '0307'], comp:['007a','0307'], canon:k._0, block:b[2], indexed:["Z"]},
			'017d':{ u:'017d', i:316, name:'LATIN CAPITAL LETTER Z WITH CARON', cat:c.Lu,  relatives:['005a', '030c', '01c4'], comp:['005a','030c'], canon:k._0, block:b[2], indexed:["Z"]},
			'017e':{ u:'017e', i:317, name:'LATIN SMALL LETTER Z WITH CARON', cat:c.Ll,  relatives:['007a', '030c', '01c5', '01c6'], comp:['007a','030c'], canon:k._0, block:b[2], indexed:["Z"]},
			'017f':{ u:'017f', i:318, name:'LATIN SMALL LETTER LONG S', cat:c.Ll,  relatives:['0073', '1e9b', 'fb05'],  canon:k._0, block:b[2], indexed:["S"]},
			'0180':{ u:'0180', i:319, name:'LATIN SMALL LETTER B WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["B"]},
			'0181':{ u:'0181', i:320, name:'LATIN CAPITAL LETTER B WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["B"]},
			'0182':{ u:'0182', i:321, name:'LATIN CAPITAL LETTER B WITH TOPBAR', cat:c.Lu,   canon:k._0, block:b[3], indexed:["B"]},
			'0183':{ u:'0183', i:322, name:'LATIN SMALL LETTER B WITH TOPBAR', cat:c.Ll,   canon:k._0, block:b[3], indexed:["B"]},
			'0184':{ u:'0184', i:323, name:'LATIN CAPITAL LETTER TONE SIX', cat:c.Lu,   canon:k._0, block:b[3]},
			'0185':{ u:'0185', i:324, name:'LATIN SMALL LETTER TONE SIX', cat:c.Ll,   canon:k._0, block:b[3]},
			'0186':{ u:'0186', i:325, name:'LATIN CAPITAL LETTER OPEN O', cat:c.Lu,   canon:k._0, block:b[3], indexed:["O"]},
			'0187':{ u:'0187', i:326, name:'LATIN CAPITAL LETTER C WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["C"]},
			'0188':{ u:'0188', i:327, name:'LATIN SMALL LETTER C WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["C"]},
			'0189':{ u:'0189', i:328, name:'LATIN CAPITAL LETTER AFRICAN D', cat:c.Lu,   canon:k._0, block:b[3], indexed:["D"]},
			'018a':{ u:'018a', i:329, name:'LATIN CAPITAL LETTER D WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["D"]},
			'018b':{ u:'018b', i:330, name:'LATIN CAPITAL LETTER D WITH TOPBAR', cat:c.Lu,   canon:k._0, block:b[3], indexed:["D"]},
			'018c':{ u:'018c', i:331, name:'LATIN SMALL LETTER D WITH TOPBAR', cat:c.Ll,   canon:k._0, block:b[3], indexed:["D"]},
			'018d':{ u:'018d', i:332, name:'LATIN SMALL LETTER TURNED DELTA', cat:c.Ll,   canon:k._0, block:b[3]},
			'018e':{ u:'018e', i:333, name:'LATIN CAPITAL LETTER REVERSED E', cat:c.Lu,  relatives:['1d32'],  canon:k._0, block:b[3], indexed:["E"]},
			'018f':{ u:'018f', i:334, name:'LATIN CAPITAL LETTER SCHWA', cat:c.Lu,   canon:k._0, block:b[3]},
			'0190':{ u:'0190', i:335, name:'LATIN CAPITAL LETTER OPEN E', cat:c.Lu,  relatives:['2107'],  canon:k._0, block:b[3], indexed:["E"]},
			'0191':{ u:'0191', i:336, name:'LATIN CAPITAL LETTER F WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["F"]},
			'0192':{ u:'0192', i:337, name:'LATIN SMALL LETTER F WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["F"]},
			'0193':{ u:'0193', i:338, name:'LATIN CAPITAL LETTER G WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["G"]},
			'0194':{ u:'0194', i:339, name:'LATIN CAPITAL LETTER GAMMA', cat:c.Lu,   canon:k._0, block:b[3]},
			'0195':{ u:'0195', i:340, name:'LATIN SMALL LETTER HV', cat:c.Ll,   canon:k._0, block:b[3]},
			'0196':{ u:'0196', i:341, name:'LATIN CAPITAL LETTER IOTA', cat:c.Lu,   canon:k._0, block:b[3]},
			'0197':{ u:'0197', i:342, name:'LATIN CAPITAL LETTER I WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["I"]},
			'0198':{ u:'0198', i:343, name:'LATIN CAPITAL LETTER K WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["K"]},
			'0199':{ u:'0199', i:344, name:'LATIN SMALL LETTER K WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["K"]},
			'019a':{ u:'019a', i:345, name:'LATIN SMALL LETTER L WITH BAR', cat:c.Ll,   canon:k._0, block:b[3], indexed:["L"]},
			'019b':{ u:'019b', i:346, name:'LATIN SMALL LETTER LAMBDA WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3]},
			'019c':{ u:'019c', i:347, name:'LATIN CAPITAL LETTER TURNED M', cat:c.Lu,   canon:k._0, block:b[3], indexed:["M"]},
			'019d':{ u:'019d', i:348, name:'LATIN CAPITAL LETTER N WITH LEFT HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["N"]},
			'019e':{ u:'019e', i:349, name:'LATIN SMALL LETTER N WITH LONG RIGHT LEG', cat:c.Ll,   canon:k._0, block:b[3], indexed:["N"]},
			'019f':{ u:'019f', i:350, name:'LATIN CAPITAL LETTER O WITH MIDDLE TILDE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["O"]},
			'01a0':{ u:'01a0', i:351, name:'LATIN CAPITAL LETTER O WITH HORN', cat:c.Lu,  relatives:['004f', '031b', '1eda', '1edc', '1ede', '1ee0', '1ee2'], comp:['004f','031b'], canon:k._0, block:b[3], indexed:["O"]},
			'01a1':{ u:'01a1', i:352, name:'LATIN SMALL LETTER O WITH HORN', cat:c.Ll,  relatives:['006f', '031b', '1edb', '1edd', '1edf', '1ee1', '1ee3'], comp:['006f','031b'], canon:k._0, block:b[3], indexed:["O"]},
			'01a2':{ u:'01a2', i:353, name:'LATIN CAPITAL LETTER OI', cat:c.Lu,   canon:k._0, block:b[3]},
			'01a3':{ u:'01a3', i:354, name:'LATIN SMALL LETTER OI', cat:c.Ll,   canon:k._0, block:b[3]},
			'01a4':{ u:'01a4', i:355, name:'LATIN CAPITAL LETTER P WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["P"]},
			'01a5':{ u:'01a5', i:356, name:'LATIN SMALL LETTER P WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["P"]},
			'01a6':{ u:'01a6', i:357, name:'LATIN LETTER YR', cat:c.Lu,   canon:k._0, block:b[3]},
			'01a7':{ u:'01a7', i:358, name:'LATIN CAPITAL LETTER TONE TWO', cat:c.Lu,   canon:k._0, block:b[3]},
			'01a8':{ u:'01a8', i:359, name:'LATIN SMALL LETTER TONE TWO', cat:c.Ll,   canon:k._0, block:b[3]},
			'01a9':{ u:'01a9', i:360, name:'LATIN CAPITAL LETTER ESH', cat:c.Lu,   canon:k._0, block:b[3]},
			'01aa':{ u:'01aa', i:361, name:'LATIN LETTER REVERSED ESH LOOP', cat:c.Ll,   canon:k._0, block:b[3]},
			'01ab':{ u:'01ab', i:362, name:'LATIN SMALL LETTER T WITH PALATAL HOOK', cat:c.Ll,  relatives:['1db5'],  canon:k._0, block:b[3], indexed:["T"]},
			'01ac':{ u:'01ac', i:363, name:'LATIN CAPITAL LETTER T WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["T"]},
			'01ad':{ u:'01ad', i:364, name:'LATIN SMALL LETTER T WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["T"]},
			'01ae':{ u:'01ae', i:365, name:'LATIN CAPITAL LETTER T WITH RETROFLEX HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["T"]},
			'01af':{ u:'01af', i:366, name:'LATIN CAPITAL LETTER U WITH HORN', cat:c.Lu,  relatives:['0055', '031b', '1ee8', '1eea', '1eec', '1eee', '1ef0'], comp:['0055','031b'], canon:k._0, block:b[3], indexed:["U"]},
			'01b0':{ u:'01b0', i:367, name:'LATIN SMALL LETTER U WITH HORN', cat:c.Ll,  relatives:['0075', '031b', '1ee9', '1eeb', '1eed', '1eef', '1ef1'], comp:['0075','031b'], canon:k._0, block:b[3], indexed:["U"]},
			'01b1':{ u:'01b1', i:368, name:'LATIN CAPITAL LETTER UPSILON', cat:c.Lu,   canon:k._0, block:b[3]},
			'01b2':{ u:'01b2', i:369, name:'LATIN CAPITAL LETTER V WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["V"]},
			'01b3':{ u:'01b3', i:370, name:'LATIN CAPITAL LETTER Y WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["Y"]},
			'01b4':{ u:'01b4', i:371, name:'LATIN SMALL LETTER Y WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Y"]},
			'01b5':{ u:'01b5', i:372, name:'LATIN CAPITAL LETTER Z WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["Z"]},
			'01b6':{ u:'01b6', i:373, name:'LATIN SMALL LETTER Z WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Z"]},
			'01b7':{ u:'01b7', i:374, name:'LATIN CAPITAL LETTER EZH', cat:c.Lu,  relatives:['01ee'],  canon:k._0, block:b[3]},
			'01b8':{ u:'01b8', i:375, name:'LATIN CAPITAL LETTER EZH REVERSED', cat:c.Lu,   canon:k._0, block:b[3]},
			'01b9':{ u:'01b9', i:376, name:'LATIN SMALL LETTER EZH REVERSED', cat:c.Ll,   canon:k._0, block:b[3]},
			'01ba':{ u:'01ba', i:377, name:'LATIN SMALL LETTER EZH WITH TAIL', cat:c.Ll,   canon:k._0, block:b[3]},
			'01bb':{ u:'01bb', i:378, name:'LATIN LETTER TWO WITH STROKE', cat:c.Lo,   canon:k._0, block:b[3]},
			'01bc':{ u:'01bc', i:379, name:'LATIN CAPITAL LETTER TONE FIVE', cat:c.Lu,   canon:k._0, block:b[3]},
			'01bd':{ u:'01bd', i:380, name:'LATIN SMALL LETTER TONE FIVE', cat:c.Ll,   canon:k._0, block:b[3]},
			'01be':{ u:'01be', i:381, name:'LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3]},
			'01bf':{ u:'01bf', i:382, name:'LATIN LETTER WYNN', cat:c.Ll,   canon:k._0, block:b[3]},
			'01c0':{ u:'01c0', i:383, name:'LATIN LETTER DENTAL CLICK', cat:c.Lo,  relatives:['107b6'],  canon:k._0, block:b[3]},
			'01c1':{ u:'01c1', i:384, name:'LATIN LETTER LATERAL CLICK', cat:c.Lo,  relatives:['107b7'],  canon:k._0, block:b[3]},
			'01c2':{ u:'01c2', i:385, name:'LATIN LETTER ALVEOLAR CLICK', cat:c.Lo,  relatives:['107b8'],  canon:k._0, block:b[3]},
			'01c3':{ u:'01c3', i:386, name:'LATIN LETTER RETROFLEX CLICK', cat:c.Lo,   canon:k._0, block:b[3]},
			'01c4':{ u:'01c4', i:387, name:'LATIN CAPITAL LETTER DZ WITH CARON', cat:c.Lu,  relatives:['0044', '017d'], comp:['0044','017d'], canon:k._0, block:b[3]},
			'01c5':{ u:'01c5', i:388, name:'LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON', cat:c.Lt,  relatives:['0044', '017e'], comp:['0044','017e'], canon:k._0, block:b[3], indexed:["D","Z"]},
			'01c6':{ u:'01c6', i:389, name:'LATIN SMALL LETTER DZ WITH CARON', cat:c.Ll,  relatives:['0064', '017e'], comp:['0064','017e'], canon:k._0, block:b[3]},
			'01c7':{ u:'01c7', i:390, name:'LATIN CAPITAL LETTER LJ', cat:c.Lu,  relatives:['004c', '004a'], comp:['004c','004a'], canon:k._0, block:b[3]},
			'01c8':{ u:'01c8', i:391, name:'LATIN CAPITAL LETTER L WITH SMALL LETTER J', cat:c.Lt,  relatives:['004c', '006a'], comp:['004c','006a'], canon:k._0, block:b[3], indexed:["L","J"]},
			'01c9':{ u:'01c9', i:392, name:'LATIN SMALL LETTER LJ', cat:c.Ll,  relatives:['006c', '006a'], comp:['006c','006a'], canon:k._0, block:b[3]},
			'01ca':{ u:'01ca', i:393, name:'LATIN CAPITAL LETTER NJ', cat:c.Lu,  relatives:['004e', '004a'], comp:['004e','004a'], canon:k._0, block:b[3]},
			'01cb':{ u:'01cb', i:394, name:'LATIN CAPITAL LETTER N WITH SMALL LETTER J', cat:c.Lt,  relatives:['004e', '006a'], comp:['004e','006a'], canon:k._0, block:b[3], indexed:["N","J"]},
			'01cc':{ u:'01cc', i:395, name:'LATIN SMALL LETTER NJ', cat:c.Ll,  relatives:['006e', '006a'], comp:['006e','006a'], canon:k._0, block:b[3]},
			'01cd':{ u:'01cd', i:396, name:'LATIN CAPITAL LETTER A WITH CARON', cat:c.Lu,  relatives:['0041', '030c'], comp:['0041','030c'], canon:k._0, block:b[3], indexed:["A"]},
			'01ce':{ u:'01ce', i:397, name:'LATIN SMALL LETTER A WITH CARON', cat:c.Ll,  relatives:['0061', '030c'], comp:['0061','030c'], canon:k._0, block:b[3], indexed:["A"]},
			'01cf':{ u:'01cf', i:398, name:'LATIN CAPITAL LETTER I WITH CARON', cat:c.Lu,  relatives:['0049', '030c'], comp:['0049','030c'], canon:k._0, block:b[3], indexed:["I"]},
			'01d0':{ u:'01d0', i:399, name:'LATIN SMALL LETTER I WITH CARON', cat:c.Ll,  relatives:['0069', '030c'], comp:['0069','030c'], canon:k._0, block:b[3], indexed:["I"]},
			'01d1':{ u:'01d1', i:400, name:'LATIN CAPITAL LETTER O WITH CARON', cat:c.Lu,  relatives:['004f', '030c'], comp:['004f','030c'], canon:k._0, block:b[3], indexed:["O"]},
			'01d2':{ u:'01d2', i:401, name:'LATIN SMALL LETTER O WITH CARON', cat:c.Ll,  relatives:['006f', '030c'], comp:['006f','030c'], canon:k._0, block:b[3], indexed:["O"]},
			'01d3':{ u:'01d3', i:402, name:'LATIN CAPITAL LETTER U WITH CARON', cat:c.Lu,  relatives:['0055', '030c'], comp:['0055','030c'], canon:k._0, block:b[3], indexed:["U"]},
			'01d4':{ u:'01d4', i:403, name:'LATIN SMALL LETTER U WITH CARON', cat:c.Ll,  relatives:['0075', '030c'], comp:['0075','030c'], canon:k._0, block:b[3], indexed:["U"]},
			'01d5':{ u:'01d5', i:404, name:'LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON', cat:c.Lu,  relatives:['00dc', '0304'], comp:['00dc','0304'], canon:k._0, block:b[3], indexed:["U"]},
			'01d6':{ u:'01d6', i:405, name:'LATIN SMALL LETTER U WITH DIAERESIS AND MACRON', cat:c.Ll,  relatives:['00fc', '0304'], comp:['00fc','0304'], canon:k._0, block:b[3], indexed:["U"]},
			'01d7':{ u:'01d7', i:406, name:'LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE', cat:c.Lu,  relatives:['00dc', '0301'], comp:['00dc','0301'], canon:k._0, block:b[3], indexed:["U"]},
			'01d8':{ u:'01d8', i:407, name:'LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE', cat:c.Ll,  relatives:['00fc', '0301'], comp:['00fc','0301'], canon:k._0, block:b[3], indexed:["U"]},
			'01d9':{ u:'01d9', i:408, name:'LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON', cat:c.Lu,  relatives:['00dc', '030c'], comp:['00dc','030c'], canon:k._0, block:b[3], indexed:["U"]},
			'01da':{ u:'01da', i:409, name:'LATIN SMALL LETTER U WITH DIAERESIS AND CARON', cat:c.Ll,  relatives:['00fc', '030c'], comp:['00fc','030c'], canon:k._0, block:b[3], indexed:["U"]},
			'01db':{ u:'01db', i:410, name:'LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE', cat:c.Lu,  relatives:['00dc', '0300'], comp:['00dc','0300'], canon:k._0, block:b[3], indexed:["U"]},
			'01dc':{ u:'01dc', i:411, name:'LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE', cat:c.Ll,  relatives:['00fc', '0300'], comp:['00fc','0300'], canon:k._0, block:b[3], indexed:["U"]},
			'01dd':{ u:'01dd', i:412, name:'LATIN SMALL LETTER TURNED E', cat:c.Ll,   canon:k._0, block:b[3], indexed:["E"]},
			'01de':{ u:'01de', i:413, name:'LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON', cat:c.Lu,  relatives:['00c4', '0304'], comp:['00c4','0304'], canon:k._0, block:b[3], indexed:["A"]},
			'01df':{ u:'01df', i:414, name:'LATIN SMALL LETTER A WITH DIAERESIS AND MACRON', cat:c.Ll,  relatives:['00e4', '0304'], comp:['00e4','0304'], canon:k._0, block:b[3], indexed:["A"]},
			'01e0':{ u:'01e0', i:415, name:'LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON', cat:c.Lu,  relatives:['0226', '0304'], comp:['0226','0304'], canon:k._0, block:b[3], indexed:["A"]},
			'01e1':{ u:'01e1', i:416, name:'LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON', cat:c.Ll,  relatives:['0227', '0304'], comp:['0227','0304'], canon:k._0, block:b[3], indexed:["A"]},
			'01e2':{ u:'01e2', i:417, name:'LATIN CAPITAL LETTER AE WITH MACRON', cat:c.Lu,  relatives:['00c6', '0304'], comp:['00c6','0304'], canon:k._0, block:b[3]},
			'01e3':{ u:'01e3', i:418, name:'LATIN SMALL LETTER AE WITH MACRON', cat:c.Ll,  relatives:['00e6', '0304'], comp:['00e6','0304'], canon:k._0, block:b[3]},
			'01e4':{ u:'01e4', i:419, name:'LATIN CAPITAL LETTER G WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["G"]},
			'01e5':{ u:'01e5', i:420, name:'LATIN SMALL LETTER G WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["G"]},
			'01e6':{ u:'01e6', i:421, name:'LATIN CAPITAL LETTER G WITH CARON', cat:c.Lu,  relatives:['0047', '030c'], comp:['0047','030c'], canon:k._0, block:b[3], indexed:["G"]},
			'01e7':{ u:'01e7', i:422, name:'LATIN SMALL LETTER G WITH CARON', cat:c.Ll,  relatives:['0067', '030c'], comp:['0067','030c'], canon:k._0, block:b[3], indexed:["G"]},
			'01e8':{ u:'01e8', i:423, name:'LATIN CAPITAL LETTER K WITH CARON', cat:c.Lu,  relatives:['004b', '030c'], comp:['004b','030c'], canon:k._0, block:b[3], indexed:["K"]},
			'01e9':{ u:'01e9', i:424, name:'LATIN SMALL LETTER K WITH CARON', cat:c.Ll,  relatives:['006b', '030c'], comp:['006b','030c'], canon:k._0, block:b[3], indexed:["K"]},
			'01ea':{ u:'01ea', i:425, name:'LATIN CAPITAL LETTER O WITH OGONEK', cat:c.Lu,  relatives:['004f', '0328', '01ec'], comp:['004f','0328'], canon:k._0, block:b[3], indexed:["O"]},
			'01eb':{ u:'01eb', i:426, name:'LATIN SMALL LETTER O WITH OGONEK', cat:c.Ll,  relatives:['006f', '0328', '01ed'], comp:['006f','0328'], canon:k._0, block:b[3], indexed:["O"]},
			'01ec':{ u:'01ec', i:427, name:'LATIN CAPITAL LETTER O WITH OGONEK AND MACRON', cat:c.Lu,  relatives:['01ea', '0304'], comp:['01ea','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'01ed':{ u:'01ed', i:428, name:'LATIN SMALL LETTER O WITH OGONEK AND MACRON', cat:c.Ll,  relatives:['01eb', '0304'], comp:['01eb','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'01ee':{ u:'01ee', i:429, name:'LATIN CAPITAL LETTER EZH WITH CARON', cat:c.Lu,  relatives:['01b7', '030c'], comp:['01b7','030c'], canon:k._0, block:b[3]},
			'01ef':{ u:'01ef', i:430, name:'LATIN SMALL LETTER EZH WITH CARON', cat:c.Ll,  relatives:['0292', '030c'], comp:['0292','030c'], canon:k._0, block:b[3]},
			'01f0':{ u:'01f0', i:431, name:'LATIN SMALL LETTER J WITH CARON', cat:c.Ll,  relatives:['006a', '030c'], comp:['006a','030c'], canon:k._0, block:b[3], indexed:["J"]},
			'01f1':{ u:'01f1', i:432, name:'LATIN CAPITAL LETTER DZ', cat:c.Lu,  relatives:['0044', '005a'], comp:['0044','005a'], canon:k._0, block:b[3]},
			'01f2':{ u:'01f2', i:433, name:'LATIN CAPITAL LETTER D WITH SMALL LETTER Z', cat:c.Lt,  relatives:['0044', '007a'], comp:['0044','007a'], canon:k._0, block:b[3], indexed:["D","Z"]},
			'01f3':{ u:'01f3', i:434, name:'LATIN SMALL LETTER DZ', cat:c.Ll,  relatives:['0064', '007a'], comp:['0064','007a'], canon:k._0, block:b[3]},
			'01f4':{ u:'01f4', i:435, name:'LATIN CAPITAL LETTER G WITH ACUTE', cat:c.Lu,  relatives:['0047', '0301'], comp:['0047','0301'], canon:k._0, block:b[3], indexed:["G"]},
			'01f5':{ u:'01f5', i:436, name:'LATIN SMALL LETTER G WITH ACUTE', cat:c.Ll,  relatives:['0067', '0301'], comp:['0067','0301'], canon:k._0, block:b[3], indexed:["G"]},
			'01f6':{ u:'01f6', i:437, name:'LATIN CAPITAL LETTER HWAIR', cat:c.Lu,   canon:k._0, block:b[3]},
			'01f7':{ u:'01f7', i:438, name:'LATIN CAPITAL LETTER WYNN', cat:c.Lu,   canon:k._0, block:b[3]},
			'01f8':{ u:'01f8', i:439, name:'LATIN CAPITAL LETTER N WITH GRAVE', cat:c.Lu,  relatives:['004e', '0300'], comp:['004e','0300'], canon:k._0, block:b[3], indexed:["N"]},
			'01f9':{ u:'01f9', i:440, name:'LATIN SMALL LETTER N WITH GRAVE', cat:c.Ll,  relatives:['006e', '0300'], comp:['006e','0300'], canon:k._0, block:b[3], indexed:["N"]},
			'01fa':{ u:'01fa', i:441, name:'LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE', cat:c.Lu,  relatives:['00c5', '0301'], comp:['00c5','0301'], canon:k._0, block:b[3], indexed:["A"]},
			'01fb':{ u:'01fb', i:442, name:'LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE', cat:c.Ll,  relatives:['00e5', '0301'], comp:['00e5','0301'], canon:k._0, block:b[3], indexed:["A"]},
			'01fc':{ u:'01fc', i:443, name:'LATIN CAPITAL LETTER AE WITH ACUTE', cat:c.Lu,  relatives:['00c6', '0301'], comp:['00c6','0301'], canon:k._0, block:b[3]},
			'01fd':{ u:'01fd', i:444, name:'LATIN SMALL LETTER AE WITH ACUTE', cat:c.Ll,  relatives:['00e6', '0301'], comp:['00e6','0301'], canon:k._0, block:b[3]},
			'01fe':{ u:'01fe', i:445, name:'LATIN CAPITAL LETTER O WITH STROKE AND ACUTE', cat:c.Lu,  relatives:['00d8', '0301'], comp:['00d8','0301'], canon:k._0, block:b[3], indexed:["O"]},
			'01ff':{ u:'01ff', i:446, name:'LATIN SMALL LETTER O WITH STROKE AND ACUTE', cat:c.Ll,  relatives:['00f8', '0301'], comp:['00f8','0301'], canon:k._0, block:b[3], indexed:["O"]},
			'0200':{ u:'0200', i:447, name:'LATIN CAPITAL LETTER A WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['0041', '030f'], comp:['0041','030f'], canon:k._0, block:b[3], indexed:["A"]},
			'0201':{ u:'0201', i:448, name:'LATIN SMALL LETTER A WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['0061', '030f'], comp:['0061','030f'], canon:k._0, block:b[3], indexed:["A"]},
			'0202':{ u:'0202', i:449, name:'LATIN CAPITAL LETTER A WITH INVERTED BREVE', cat:c.Lu,  relatives:['0041', '0311'], comp:['0041','0311'], canon:k._0, block:b[3], indexed:["A"]},
			'0203':{ u:'0203', i:450, name:'LATIN SMALL LETTER A WITH INVERTED BREVE', cat:c.Ll,  relatives:['0061', '0311'], comp:['0061','0311'], canon:k._0, block:b[3], indexed:["A"]},
			'0204':{ u:'0204', i:451, name:'LATIN CAPITAL LETTER E WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['0045', '030f'], comp:['0045','030f'], canon:k._0, block:b[3], indexed:["E"]},
			'0205':{ u:'0205', i:452, name:'LATIN SMALL LETTER E WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['0065', '030f'], comp:['0065','030f'], canon:k._0, block:b[3], indexed:["E"]},
			'0206':{ u:'0206', i:453, name:'LATIN CAPITAL LETTER E WITH INVERTED BREVE', cat:c.Lu,  relatives:['0045', '0311'], comp:['0045','0311'], canon:k._0, block:b[3], indexed:["E"]},
			'0207':{ u:'0207', i:454, name:'LATIN SMALL LETTER E WITH INVERTED BREVE', cat:c.Ll,  relatives:['0065', '0311'], comp:['0065','0311'], canon:k._0, block:b[3], indexed:["E"]},
			'0208':{ u:'0208', i:455, name:'LATIN CAPITAL LETTER I WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['0049', '030f'], comp:['0049','030f'], canon:k._0, block:b[3], indexed:["I"]},
			'0209':{ u:'0209', i:456, name:'LATIN SMALL LETTER I WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['0069', '030f'], comp:['0069','030f'], canon:k._0, block:b[3], indexed:["I"]},
			'020a':{ u:'020a', i:457, name:'LATIN CAPITAL LETTER I WITH INVERTED BREVE', cat:c.Lu,  relatives:['0049', '0311'], comp:['0049','0311'], canon:k._0, block:b[3], indexed:["I"]},
			'020b':{ u:'020b', i:458, name:'LATIN SMALL LETTER I WITH INVERTED BREVE', cat:c.Ll,  relatives:['0069', '0311'], comp:['0069','0311'], canon:k._0, block:b[3], indexed:["I"]},
			'020c':{ u:'020c', i:459, name:'LATIN CAPITAL LETTER O WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['004f', '030f'], comp:['004f','030f'], canon:k._0, block:b[3], indexed:["O"]},
			'020d':{ u:'020d', i:460, name:'LATIN SMALL LETTER O WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['006f', '030f'], comp:['006f','030f'], canon:k._0, block:b[3], indexed:["O"]},
			'020e':{ u:'020e', i:461, name:'LATIN CAPITAL LETTER O WITH INVERTED BREVE', cat:c.Lu,  relatives:['004f', '0311'], comp:['004f','0311'], canon:k._0, block:b[3], indexed:["O"]},
			'020f':{ u:'020f', i:462, name:'LATIN SMALL LETTER O WITH INVERTED BREVE', cat:c.Ll,  relatives:['006f', '0311'], comp:['006f','0311'], canon:k._0, block:b[3], indexed:["O"]},
			'0210':{ u:'0210', i:463, name:'LATIN CAPITAL LETTER R WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['0052', '030f'], comp:['0052','030f'], canon:k._0, block:b[3], indexed:["R"]},
			'0211':{ u:'0211', i:464, name:'LATIN SMALL LETTER R WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['0072', '030f'], comp:['0072','030f'], canon:k._0, block:b[3], indexed:["R"]},
			'0212':{ u:'0212', i:465, name:'LATIN CAPITAL LETTER R WITH INVERTED BREVE', cat:c.Lu,  relatives:['0052', '0311'], comp:['0052','0311'], canon:k._0, block:b[3], indexed:["R"]},
			'0213':{ u:'0213', i:466, name:'LATIN SMALL LETTER R WITH INVERTED BREVE', cat:c.Ll,  relatives:['0072', '0311'], comp:['0072','0311'], canon:k._0, block:b[3], indexed:["R"]},
			'0214':{ u:'0214', i:467, name:'LATIN CAPITAL LETTER U WITH DOUBLE GRAVE', cat:c.Lu,  relatives:['0055', '030f'], comp:['0055','030f'], canon:k._0, block:b[3], indexed:["U"]},
			'0215':{ u:'0215', i:468, name:'LATIN SMALL LETTER U WITH DOUBLE GRAVE', cat:c.Ll,  relatives:['0075', '030f'], comp:['0075','030f'], canon:k._0, block:b[3], indexed:["U"]},
			'0216':{ u:'0216', i:469, name:'LATIN CAPITAL LETTER U WITH INVERTED BREVE', cat:c.Lu,  relatives:['0055', '0311'], comp:['0055','0311'], canon:k._0, block:b[3], indexed:["U"]},
			'0217':{ u:'0217', i:470, name:'LATIN SMALL LETTER U WITH INVERTED BREVE', cat:c.Ll,  relatives:['0075', '0311'], comp:['0075','0311'], canon:k._0, block:b[3], indexed:["U"]},
			'0218':{ u:'0218', i:471, name:'LATIN CAPITAL LETTER S WITH COMMA BELOW', cat:c.Lu,  relatives:['0053', '0326'], comp:['0053','0326'], canon:k._0, block:b[3], indexed:["S"]},
			'0219':{ u:'0219', i:472, name:'LATIN SMALL LETTER S WITH COMMA BELOW', cat:c.Ll,  relatives:['0073', '0326'], comp:['0073','0326'], canon:k._0, block:b[3], indexed:["S"]},
			'021a':{ u:'021a', i:473, name:'LATIN CAPITAL LETTER T WITH COMMA BELOW', cat:c.Lu,  relatives:['0054', '0326'], comp:['0054','0326'], canon:k._0, block:b[3], indexed:["T"]},
			'021b':{ u:'021b', i:474, name:'LATIN SMALL LETTER T WITH COMMA BELOW', cat:c.Ll,  relatives:['0074', '0326'], comp:['0074','0326'], canon:k._0, block:b[3], indexed:["T"]},
			'021c':{ u:'021c', i:475, name:'LATIN CAPITAL LETTER YOGH', cat:c.Lu,   canon:k._0, block:b[3]},
			'021d':{ u:'021d', i:476, name:'LATIN SMALL LETTER YOGH', cat:c.Ll,   canon:k._0, block:b[3]},
			'021e':{ u:'021e', i:477, name:'LATIN CAPITAL LETTER H WITH CARON', cat:c.Lu,  relatives:['0048', '030c'], comp:['0048','030c'], canon:k._0, block:b[3], indexed:["H"]},
			'021f':{ u:'021f', i:478, name:'LATIN SMALL LETTER H WITH CARON', cat:c.Ll,  relatives:['0068', '030c'], comp:['0068','030c'], canon:k._0, block:b[3], indexed:["H"]},
			'0220':{ u:'0220', i:479, name:'LATIN CAPITAL LETTER N WITH LONG RIGHT LEG', cat:c.Lu,   canon:k._0, block:b[3], indexed:["N"]},
			'0221':{ u:'0221', i:480, name:'LATIN SMALL LETTER D WITH CURL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["D"]},
			'0222':{ u:'0222', i:481, name:'LATIN CAPITAL LETTER OU', cat:c.Lu,  relatives:['1d3d'],  canon:k._0, block:b[3]},
			'0223':{ u:'0223', i:482, name:'LATIN SMALL LETTER OU', cat:c.Ll,   canon:k._0, block:b[3]},
			'0224':{ u:'0224', i:483, name:'LATIN CAPITAL LETTER Z WITH HOOK', cat:c.Lu,   canon:k._0, block:b[3], indexed:["Z"]},
			'0225':{ u:'0225', i:484, name:'LATIN SMALL LETTER Z WITH HOOK', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Z"]},
			'0226':{ u:'0226', i:485, name:'LATIN CAPITAL LETTER A WITH DOT ABOVE', cat:c.Lu,  relatives:['01e0', '0041', '0307'], comp:['0041','0307'], canon:k._0, block:b[3], indexed:["A"]},
			'0227':{ u:'0227', i:486, name:'LATIN SMALL LETTER A WITH DOT ABOVE', cat:c.Ll,  relatives:['01e1', '0061', '0307'], comp:['0061','0307'], canon:k._0, block:b[3], indexed:["A"]},
			'0228':{ u:'0228', i:487, name:'LATIN CAPITAL LETTER E WITH CEDILLA', cat:c.Lu,  relatives:['0045', '0327', '1e1c'], comp:['0045','0327'], canon:k._0, block:b[3], indexed:["E"]},
			'0229':{ u:'0229', i:488, name:'LATIN SMALL LETTER E WITH CEDILLA', cat:c.Ll,  relatives:['0065', '0327', '1e1d'], comp:['0065','0327'], canon:k._0, block:b[3], indexed:["E"]},
			'022a':{ u:'022a', i:489, name:'LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON', cat:c.Lu,  relatives:['00d6', '0304'], comp:['00d6','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'022b':{ u:'022b', i:490, name:'LATIN SMALL LETTER O WITH DIAERESIS AND MACRON', cat:c.Ll,  relatives:['00f6', '0304'], comp:['00f6','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'022c':{ u:'022c', i:491, name:'LATIN CAPITAL LETTER O WITH TILDE AND MACRON', cat:c.Lu,  relatives:['00d5', '0304'], comp:['00d5','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'022d':{ u:'022d', i:492, name:'LATIN SMALL LETTER O WITH TILDE AND MACRON', cat:c.Ll,  relatives:['00f5', '0304'], comp:['00f5','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'022e':{ u:'022e', i:493, name:'LATIN CAPITAL LETTER O WITH DOT ABOVE', cat:c.Lu,  relatives:['004f', '0307', '0230'], comp:['004f','0307'], canon:k._0, block:b[3], indexed:["O"]},
			'022f':{ u:'022f', i:494, name:'LATIN SMALL LETTER O WITH DOT ABOVE', cat:c.Ll,  relatives:['006f', '0307', '0231'], comp:['006f','0307'], canon:k._0, block:b[3], indexed:["O"]},
			'0230':{ u:'0230', i:495, name:'LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON', cat:c.Lu,  relatives:['022e', '0304'], comp:['022e','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'0231':{ u:'0231', i:496, name:'LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON', cat:c.Ll,  relatives:['022f', '0304'], comp:['022f','0304'], canon:k._0, block:b[3], indexed:["O"]},
			'0232':{ u:'0232', i:497, name:'LATIN CAPITAL LETTER Y WITH MACRON', cat:c.Lu,  relatives:['0059', '0304'], comp:['0059','0304'], canon:k._0, block:b[3], indexed:["Y"]},
			'0233':{ u:'0233', i:498, name:'LATIN SMALL LETTER Y WITH MACRON', cat:c.Ll,  relatives:['0079', '0304'], comp:['0079','0304'], canon:k._0, block:b[3], indexed:["Y"]},
			'0234':{ u:'0234', i:499, name:'LATIN SMALL LETTER L WITH CURL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["L"]},
			'0235':{ u:'0235', i:500, name:'LATIN SMALL LETTER N WITH CURL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["N"]},
			'0236':{ u:'0236', i:501, name:'LATIN SMALL LETTER T WITH CURL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["T"]},
			'0237':{ u:'0237', i:502, name:'LATIN SMALL LETTER DOTLESS J', cat:c.Ll,  relatives:['1d6a5'],  canon:k._0, block:b[3], indexed:["J"]},
			'0238':{ u:'0238', i:503, name:'LATIN SMALL LETTER DB DIGRAPH', cat:c.Ll,   canon:k._0, block:b[3]},
			'0239':{ u:'0239', i:504, name:'LATIN SMALL LETTER QP DIGRAPH', cat:c.Ll,   canon:k._0, block:b[3]},
			'023a':{ u:'023a', i:505, name:'LATIN CAPITAL LETTER A WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["A"]},
			'023b':{ u:'023b', i:506, name:'LATIN CAPITAL LETTER C WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["C"]},
			'023c':{ u:'023c', i:507, name:'LATIN SMALL LETTER C WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["C"]},
			'023d':{ u:'023d', i:508, name:'LATIN CAPITAL LETTER L WITH BAR', cat:c.Lu,   canon:k._0, block:b[3], indexed:["L"]},
			'023e':{ u:'023e', i:509, name:'LATIN CAPITAL LETTER T WITH DIAGONAL STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["T"]},
			'023f':{ u:'023f', i:510, name:'LATIN SMALL LETTER S WITH SWASH TAIL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["S"]},
			'0240':{ u:'0240', i:511, name:'LATIN SMALL LETTER Z WITH SWASH TAIL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Z"]},
			'0241':{ u:'0241', i:512, name:'LATIN CAPITAL LETTER GLOTTAL STOP', cat:c.Lu,   canon:k._0, block:b[3]},
			'0242':{ u:'0242', i:513, name:'LATIN SMALL LETTER GLOTTAL STOP', cat:c.Ll,   canon:k._0, block:b[3]},
			'0243':{ u:'0243', i:514, name:'LATIN CAPITAL LETTER B WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["B"]},
			'0244':{ u:'0244', i:515, name:'LATIN CAPITAL LETTER U BAR', cat:c.Lu,   canon:k._0, block:b[3], indexed:["U"]},
			'0245':{ u:'0245', i:516, name:'LATIN CAPITAL LETTER TURNED V', cat:c.Lu,   canon:k._0, block:b[3], indexed:["V"]},
			'0246':{ u:'0246', i:517, name:'LATIN CAPITAL LETTER E WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["E"]},
			'0247':{ u:'0247', i:518, name:'LATIN SMALL LETTER E WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["E"]},
			'0248':{ u:'0248', i:519, name:'LATIN CAPITAL LETTER J WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["J"]},
			'0249':{ u:'0249', i:520, name:'LATIN SMALL LETTER J WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["J"]},
			'024a':{ u:'024a', i:521, name:'LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL', cat:c.Lu,   canon:k._0, block:b[3], indexed:["Q"]},
			'024b':{ u:'024b', i:522, name:'LATIN SMALL LETTER Q WITH HOOK TAIL', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Q"]},
			'024c':{ u:'024c', i:523, name:'LATIN CAPITAL LETTER R WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["R"]},
			'024d':{ u:'024d', i:524, name:'LATIN SMALL LETTER R WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["R"]},
			'024e':{ u:'024e', i:525, name:'LATIN CAPITAL LETTER Y WITH STROKE', cat:c.Lu,   canon:k._0, block:b[3], indexed:["Y"]},
			'024f':{ u:'024f', i:526, name:'LATIN SMALL LETTER Y WITH STROKE', cat:c.Ll,   canon:k._0, block:b[3], indexed:["Y"]},
			'0250':{ u:'0250', i:527, name:'LATIN SMALL LETTER TURNED A', cat:c.Ll,  relatives:['1d44'],  canon:k._0, block:b[4], indexed:["A"]},
			'0251':{ u:'0251', i:528, name:'LATIN SMALL LETTER ALPHA', cat:c.Ll,  relatives:['1d45'],  canon:k._0, block:b[4]},
			'0252':{ u:'0252', i:529, name:'LATIN SMALL LETTER TURNED ALPHA', cat:c.Ll,  relatives:['1d9b'],  canon:k._0, block:b[4]},
			'0253':{ u:'0253', i:530, name:'LATIN SMALL LETTER B WITH HOOK', cat:c.Ll,  relatives:['10785'],  canon:k._0, block:b[4], indexed:["B"]},
			'0254':{ u:'0254', i:531, name:'LATIN SMALL LETTER OPEN O', cat:c.Ll,  relatives:['1d53'],  canon:k._0, block:b[4], indexed:["O"]},
			'0255':{ u:'0255', i:532, name:'LATIN SMALL LETTER C WITH CURL', cat:c.Ll,  relatives:['1d9d'],  canon:k._0, block:b[4], indexed:["C"]},
			'0256':{ u:'0256', i:533, name:'LATIN SMALL LETTER D WITH TAIL', cat:c.Ll,  relatives:['1078b'],  canon:k._0, block:b[4], indexed:["D"]},
			'0257':{ u:'0257', i:534, name:'LATIN SMALL LETTER D WITH HOOK', cat:c.Ll,  relatives:['1078c'],  canon:k._0, block:b[4], indexed:["D"]},
			'0258':{ u:'0258', i:535, name:'LATIN SMALL LETTER REVERSED E', cat:c.Ll,  relatives:['1078e'],  canon:k._0, block:b[4], indexed:["E"]},
			'0259':{ u:'0259', i:536, name:'LATIN SMALL LETTER SCHWA', cat:c.Ll,  relatives:['1d4a', '2094'],  canon:k._0, block:b[4]},
			'025a':{ u:'025a', i:537, name:'LATIN SMALL LETTER SCHWA WITH HOOK', cat:c.Ll,   canon:k._0, block:b[4]},
			'025b':{ u:'025b', i:538, name:'LATIN SMALL LETTER OPEN E', cat:c.Ll,  relatives:['1d4b'],  canon:k._0, block:b[4], indexed:["E"]},
			'025c':{ u:'025c', i:539, name:'LATIN SMALL LETTER REVERSED OPEN E', cat:c.Ll,  relatives:['1d4c', '1d9f'],  canon:k._0, block:b[4], indexed:["E"]},
			'025d':{ u:'025d', i:540, name:'LATIN SMALL LETTER REVERSED OPEN E WITH HOOK', cat:c.Ll,   canon:k._0, block:b[4], indexed:["E"]},
			'025e':{ u:'025e', i:541, name:'LATIN SMALL LETTER CLOSED REVERSED OPEN E', cat:c.Ll,  relatives:['1078f'],  canon:k._0, block:b[4], indexed:["E"]},
			'025f':{ u:'025f', i:542, name:'LATIN SMALL LETTER DOTLESS J WITH STROKE', cat:c.Ll,  relatives:['1da1'],  canon:k._0, block:b[4], indexed:["J"]},
			'0260':{ u:'0260', i:543, name:'LATIN SMALL LETTER G WITH HOOK', cat:c.Ll,  relatives:['10793'],  canon:k._0, block:b[4], indexed:["G"]},
			'0261':{ u:'0261', i:544, name:'LATIN SMALL LETTER SCRIPT G', cat:c.Ll,  relatives:['1da2'],  canon:k._0, block:b[4], indexed:["G"]},
			'0262':{ u:'0262', i:545, name:'LATIN LETTER SMALL CAPITAL G', cat:c.Ll,  relatives:['10792'],  canon:k._0, block:b[4], indexed:["G"]},
			'0263':{ u:'0263', i:546, name:'LATIN SMALL LETTER GAMMA', cat:c.Ll,  relatives:['02e0'],  canon:k._0, block:b[4]},
			'0264':{ u:'0264', i:547, name:'LATIN SMALL LETTER RAMS HORN', cat:c.Ll,  relatives:['10791'],  canon:k._0, block:b[4]},
			'0265':{ u:'0265', i:548, name:'LATIN SMALL LETTER TURNED H', cat:c.Ll,  relatives:['1da3'],  canon:k._0, block:b[4], indexed:["H"]},
			'0266':{ u:'0266', i:549, name:'LATIN SMALL LETTER H WITH HOOK', cat:c.Ll,  relatives:['02b1'],  canon:k._0, block:b[4], indexed:["H"]},
			'0267':{ u:'0267', i:550, name:'LATIN SMALL LETTER HENG WITH HOOK', cat:c.Ll,  relatives:['10797'],  canon:k._0, block:b[4]},
			'0268':{ u:'0268', i:551, name:'LATIN SMALL LETTER I WITH STROKE', cat:c.Ll,  relatives:['1da4'],  canon:k._0, block:b[4], indexed:["I"]},
			'0269':{ u:'0269', i:552, name:'LATIN SMALL LETTER IOTA', cat:c.Ll,  relatives:['1da5'],  canon:k._0, block:b[4]},
			'026a':{ u:'026a', i:553, name:'LATIN LETTER SMALL CAPITAL I', cat:c.Ll,  relatives:['1da6'],  canon:k._0, block:b[4], indexed:["I"]},
			'026b':{ u:'026b', i:554, name:'LATIN SMALL LETTER L WITH MIDDLE TILDE', cat:c.Ll,  relatives:['ab5e'],  canon:k._0, block:b[4], indexed:["L"]},
			'026c':{ u:'026c', i:555, name:'LATIN SMALL LETTER L WITH BELT', cat:c.Ll,  relatives:['1079b'],  canon:k._0, block:b[4], indexed:["L"]},
			'026d':{ u:'026d', i:556, name:'LATIN SMALL LETTER L WITH RETROFLEX HOOK', cat:c.Ll,  relatives:['1da9'],  canon:k._0, block:b[4], indexed:["L"]},
			'026e':{ u:'026e', i:557, name:'LATIN SMALL LETTER LEZH', cat:c.Ll,  relatives:['1079e'],  canon:k._0, block:b[4]},
			'026f':{ u:'026f', i:558, name:'LATIN SMALL LETTER TURNED M', cat:c.Ll,  relatives:['1d5a'],  canon:k._0, block:b[4], indexed:["M"]},
			'0270':{ u:'0270', i:559, name:'LATIN SMALL LETTER TURNED M WITH LONG LEG', cat:c.Ll,  relatives:['1dad'],  canon:k._0, block:b[4], indexed:["M"]},
			'0271':{ u:'0271', i:560, name:'LATIN SMALL LETTER M WITH HOOK', cat:c.Ll,  relatives:['1dac'],  canon:k._0, block:b[4], indexed:["M"]},
			'0272':{ u:'0272', i:561, name:'LATIN SMALL LETTER N WITH LEFT HOOK', cat:c.Ll,  relatives:['1dae'],  canon:k._0, block:b[4], indexed:["N"]},
			'0273':{ u:'0273', i:562, name:'LATIN SMALL LETTER N WITH RETROFLEX HOOK', cat:c.Ll,  relatives:['1daf'],  canon:k._0, block:b[4], indexed:["N"]},
			'0274':{ u:'0274', i:563, name:'LATIN LETTER SMALL CAPITAL N', cat:c.Ll,  relatives:['1db0'],  canon:k._0, block:b[4], indexed:["N"]},
			'0275':{ u:'0275', i:564, name:'LATIN SMALL LETTER BARRED O', cat:c.Ll,  relatives:['1db1'],  canon:k._0, block:b[4], indexed:["O"]},
			'0276':{ u:'0276', i:565, name:'LATIN LETTER SMALL CAPITAL OE', cat:c.Ll,  relatives:['107a3'],  canon:k._0, block:b[4]},
			'0277':{ u:'0277', i:566, name:'LATIN SMALL LETTER CLOSED OMEGA', cat:c.Ll,  relatives:['107a4'],  canon:k._0, block:b[4]},
			'0278':{ u:'0278', i:567, name:'LATIN SMALL LETTER PHI', cat:c.Ll,  relatives:['1db2'],  canon:k._0, block:b[4]},
			'0279':{ u:'0279', i:568, name:'LATIN SMALL LETTER TURNED R', cat:c.Ll,  relatives:['02b4'],  canon:k._0, block:b[4], indexed:["R"]},
			'027a':{ u:'027a', i:569, name:'LATIN SMALL LETTER TURNED R WITH LONG LEG', cat:c.Ll,  relatives:['107a6'],  canon:k._0, block:b[4], indexed:["R"]},
			'027b':{ u:'027b', i:570, name:'LATIN SMALL LETTER TURNED R WITH HOOK', cat:c.Ll,  relatives:['02b5'],  canon:k._0, block:b[4], indexed:["R"]},
			'027c':{ u:'027c', i:571, name:'LATIN SMALL LETTER R WITH LONG LEG', cat:c.Ll,   canon:k._0, block:b[4], indexed:["R"]},
			'027d':{ u:'027d', i:572, name:'LATIN SMALL LETTER R WITH TAIL', cat:c.Ll,  relatives:['107a8'],  canon:k._0, block:b[4], indexed:["R"]},
			'027e':{ u:'027e', i:573, name:'LATIN SMALL LETTER R WITH FISHHOOK', cat:c.Ll,  relatives:['107a9'],  canon:k._0, block:b[4], indexed:["R"]},
			'027f':{ u:'027f', i:574, name:'LATIN SMALL LETTER REVERSED R WITH FISHHOOK', cat:c.Ll,   canon:k._0, block:b[4], indexed:["R"]},
			'0280':{ u:'0280', i:575, name:'LATIN LETTER SMALL CAPITAL R', cat:c.Ll,  relatives:['107aa'],  canon:k._0, block:b[4], indexed:["R"]},
			'0281':{ u:'0281', i:576, name:'LATIN LETTER SMALL CAPITAL INVERTED R', cat:c.Ll,  relatives:['02b6'],  canon:k._0, block:b[4], indexed:["R"]},
			'0282':{ u:'0282', i:577, name:'LATIN SMALL LETTER S WITH HOOK', cat:c.Ll,  relatives:['1db3'],  canon:k._0, block:b[4], indexed:["S"]},
			'0283':{ u:'0283', i:578, name:'LATIN SMALL LETTER ESH', cat:c.Ll,  relatives:['1db4'],  canon:k._0, block:b[4]},
			'0284':{ u:'0284', i:579, name:'LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK', cat:c.Ll,  relatives:['10798'],  canon:k._0, block:b[4], indexed:["J"]},
			'0285':{ u:'0285', i:580, name:'LATIN SMALL LETTER SQUAT REVERSED ESH', cat:c.Ll,   canon:k._0, block:b[4]},
			'0286':{ u:'0286', i:581, name:'LATIN SMALL LETTER ESH WITH CURL', cat:c.Ll,   canon:k._0, block:b[4]},
			'0287':{ u:'0287', i:582, name:'LATIN SMALL LETTER TURNED T', cat:c.Ll,   canon:k._0, block:b[4], indexed:["T"]},
			'0288':{ u:'0288', i:583, name:'LATIN SMALL LETTER T WITH RETROFLEX HOOK', cat:c.Ll,  relatives:['107af'],  canon:k._0, block:b[4], indexed:["T"]},
			'0289':{ u:'0289', i:584, name:'LATIN SMALL LETTER U BAR', cat:c.Ll,  relatives:['1db6'],  canon:k._0, block:b[4], indexed:["U"]},
			'028a':{ u:'028a', i:585, name:'LATIN SMALL LETTER UPSILON', cat:c.Ll,  relatives:['1db7'],  canon:k._0, block:b[4]},
			'028b':{ u:'028b', i:586, name:'LATIN SMALL LETTER V WITH HOOK', cat:c.Ll,  relatives:['1db9'],  canon:k._0, block:b[4], indexed:["V"]},
			'028c':{ u:'028c', i:587, name:'LATIN SMALL LETTER TURNED V', cat:c.Ll,  relatives:['1dba'],  canon:k._0, block:b[4], indexed:["V"]},
			'028d':{ u:'028d', i:588, name:'LATIN SMALL LETTER TURNED W', cat:c.Ll,  relatives:['ab69'],  canon:k._0, block:b[4], indexed:["W"]},
			'028e':{ u:'028e', i:589, name:'LATIN SMALL LETTER TURNED Y', cat:c.Ll,  relatives:['107a0'],  canon:k._0, block:b[4], indexed:["Y"]},
			'028f':{ u:'028f', i:590, name:'LATIN LETTER SMALL CAPITAL Y', cat:c.Ll,  relatives:['107b2'],  canon:k._0, block:b[4], indexed:["Y"]},
			'0290':{ u:'0290', i:591, name:'LATIN SMALL LETTER Z WITH RETROFLEX HOOK', cat:c.Ll,  relatives:['1dbc'],  canon:k._0, block:b[4], indexed:["Z"]},
			'0291':{ u:'0291', i:592, name:'LATIN SMALL LETTER Z WITH CURL', cat:c.Ll,  relatives:['1dbd'],  canon:k._0, block:b[4], indexed:["Z"]},
			'0292':{ u:'0292', i:593, name:'LATIN SMALL LETTER EZH', cat:c.Ll,  relatives:['01ef', '1dbe'],  canon:k._0, block:b[4]},
			'0293':{ u:'0293', i:594, name:'LATIN SMALL LETTER EZH WITH CURL', cat:c.Ll,   canon:k._0, block:b[4]},
			'0294':{ u:'0294', i:595, name:'LATIN LETTER GLOTTAL STOP', cat:c.Lo,   canon:k._0, block:b[4]},
			'0295':{ u:'0295', i:596, name:'LATIN LETTER PHARYNGEAL VOICED FRICATIVE', cat:c.Ll,  relatives:['02e4'],  canon:k._0, block:b[4]},
			'0296':{ u:'0296', i:597, name:'LATIN LETTER INVERTED GLOTTAL STOP', cat:c.Ll,   canon:k._0, block:b[4]},
			'0297':{ u:'0297', i:598, name:'LATIN LETTER STRETCHED C', cat:c.Ll,   canon:k._0, block:b[4], indexed:["C"]},
			'0298':{ u:'0298', i:599, name:'LATIN LETTER BILABIAL CLICK', cat:c.Ll,  relatives:['107b5'],  canon:k._0, block:b[4]},
			'0299':{ u:'0299', i:600, name:'LATIN LETTER SMALL CAPITAL B', cat:c.Ll,  relatives:['10784'],  canon:k._0, block:b[4], indexed:["B"]},
			'029a':{ u:'029a', i:601, name:'LATIN SMALL LETTER CLOSED OPEN E', cat:c.Ll,   canon:k._0, block:b[4], indexed:["E"]},
			'029b':{ u:'029b', i:602, name:'LATIN LETTER SMALL CAPITAL G WITH HOOK', cat:c.Ll,  relatives:['10794'],  canon:k._0, block:b[4], indexed:["G"]},
			'029c':{ u:'029c', i:603, name:'LATIN LETTER SMALL CAPITAL H', cat:c.Ll,  relatives:['10796'],  canon:k._0, block:b[4], indexed:["H"]},
			'029d':{ u:'029d', i:604, name:'LATIN SMALL LETTER J WITH CROSSED-TAIL', cat:c.Ll,  relatives:['1da8'],  canon:k._0, block:b[4], indexed:["J"]},
			'029e':{ u:'029e', i:605, name:'LATIN SMALL LETTER TURNED K', cat:c.Ll,   canon:k._0, block:b[4], indexed:["K"]},
			'029f':{ u:'029f', i:606, name:'LATIN LETTER SMALL CAPITAL L', cat:c.Ll,  relatives:['1dab'],  canon:k._0, block:b[4], indexed:["L"]},
			'02a0':{ u:'02a0', i:607, name:'LATIN SMALL LETTER Q WITH HOOK', cat:c.Ll,   canon:k._0, block:b[4], indexed:["Q"]},
			'02a1':{ u:'02a1', i:608, name:'LATIN LETTER GLOTTAL STOP WITH STROKE', cat:c.Ll,  relatives:['107b3'],  canon:k._0, block:b[4]},
			'02a2':{ u:'02a2', i:609, name:'LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE', cat:c.Ll,  relatives:['107b4'],  canon:k._0, block:b[4]},
			'02a3':{ u:'02a3', i:610, name:'LATIN SMALL LETTER DZ DIGRAPH', cat:c.Ll,  relatives:['10787'],  canon:k._0, block:b[4]},
			'02a4':{ u:'02a4', i:611, name:'LATIN SMALL LETTER DEZH DIGRAPH', cat:c.Ll,  relatives:['1078a'],  canon:k._0, block:b[4]},
			'02a5':{ u:'02a5', i:612, name:'LATIN SMALL LETTER DZ DIGRAPH WITH CURL', cat:c.Ll,  relatives:['10789'],  canon:k._0, block:b[4]},
			'02a6':{ u:'02a6', i:613, name:'LATIN SMALL LETTER TS DIGRAPH', cat:c.Ll,  relatives:['107ac'],  canon:k._0, block:b[4]},
			'02a7':{ u:'02a7', i:614, name:'LATIN SMALL LETTER TESH DIGRAPH', cat:c.Ll,  relatives:['107ae'],  canon:k._0, block:b[4]},
			'02a8':{ u:'02a8', i:615, name:'LATIN SMALL LETTER TC DIGRAPH WITH CURL', cat:c.Ll,  relatives:['107ab'],  canon:k._0, block:b[4]},
			'02a9':{ u:'02a9', i:616, name:'LATIN SMALL LETTER FENG DIGRAPH', cat:c.Ll,  relatives:['10790'],  canon:k._0, block:b[4]},
			'02aa':{ u:'02aa', i:617, name:'LATIN SMALL LETTER LS DIGRAPH', cat:c.Ll,  relatives:['10799'],  canon:k._0, block:b[4]},
			'02ab':{ u:'02ab', i:618, name:'LATIN SMALL LETTER LZ DIGRAPH', cat:c.Ll,  relatives:['1079a'],  canon:k._0, block:b[4]},
			'02ac':{ u:'02ac', i:619, name:'LATIN LETTER BILABIAL PERCUSSIVE', cat:c.Ll,   canon:k._0, block:b[4]},
			'02ad':{ u:'02ad', i:620, name:'LATIN LETTER BIDENTAL PERCUSSIVE', cat:c.Ll,   canon:k._0, block:b[4]},
			'02ae':{ u:'02ae', i:621, name:'LATIN SMALL LETTER TURNED H WITH FISHHOOK', cat:c.Ll,   canon:k._0, block:b[4], indexed:["H"]},
			'02af':{ u:'02af', i:622, name:'LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL', cat:c.Ll,   canon:k._0, block:b[4], indexed:["H"]},
			'02b0':{ u:'02b0', i:623, name:'MODIFIER LETTER SMALL H', cat:c.Lm,  relatives:['0068'],  canon:k._0, block:b[5], indexed:["H"]},
			'02b1':{ u:'02b1', i:624, name:'MODIFIER LETTER SMALL H WITH HOOK', cat:c.Lm,  relatives:['0266'],  canon:k._0, block:b[5], indexed:["H"]},
			'02b2':{ u:'02b2', i:625, name:'MODIFIER LETTER SMALL J', cat:c.Lm,  relatives:['006a'],  canon:k._0, block:b[5], indexed:["J"]},
			'02b3':{ u:'02b3', i:626, name:'MODIFIER LETTER SMALL R', cat:c.Lm,  relatives:['0072'],  canon:k._0, block:b[5], indexed:["R"]},
			'02b4':{ u:'02b4', i:627, name:'MODIFIER LETTER SMALL TURNED R', cat:c.Lm,  relatives:['0279'],  canon:k._0, block:b[5], indexed:["R"]},
			'02b5':{ u:'02b5', i:628, name:'MODIFIER LETTER SMALL TURNED R WITH HOOK', cat:c.Lm,  relatives:['027b'],  canon:k._0, block:b[5], indexed:["R"]},
			'02b6':{ u:'02b6', i:629, name:'MODIFIER LETTER SMALL CAPITAL INVERTED R', cat:c.Lm,  relatives:['0281'],  canon:k._0, block:b[5], indexed:["R"]},
			'02b7':{ u:'02b7', i:630, name:'MODIFIER LETTER SMALL W', cat:c.Lm,  relatives:['0077'],  canon:k._0, block:b[5], indexed:["W"]},
			'02b8':{ u:'02b8', i:631, name:'MODIFIER LETTER SMALL Y', cat:c.Lm,  relatives:['0079'],  canon:k._0, block:b[5], indexed:["Y"]},
			'02b9':{ u:'02b9', i:632, name:'MODIFIER LETTER PRIME', cat:c.Lm,  relatives:['0374'],  canon:k._0, block:b[5]},
			'02ba':{ u:'02ba', i:633, name:'MODIFIER LETTER DOUBLE PRIME', cat:c.Lm,   canon:k._0, block:b[5]},
			'02bb':{ u:'02bb', i:634, name:'MODIFIER LETTER TURNED COMMA', cat:c.Lm,   canon:k._0, block:b[5]},
			'02bc':{ u:'02bc', i:635, name:'MODIFIER LETTER APOSTROPHE', cat:c.Lm,  relatives:['0149'],  canon:k._0, block:b[5]},
			'02bd':{ u:'02bd', i:636, name:'MODIFIER LETTER REVERSED COMMA', cat:c.Lm,   canon:k._0, block:b[5]},
			'02be':{ u:'02be', i:637, name:'MODIFIER LETTER RIGHT HALF RING', cat:c.Lm,  relatives:['1e9a'],  canon:k._0, block:b[5]},
			'02bf':{ u:'02bf', i:638, name:'MODIFIER LETTER LEFT HALF RING', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c0':{ u:'02c0', i:639, name:'MODIFIER LETTER GLOTTAL STOP', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c1':{ u:'02c1', i:640, name:'MODIFIER LETTER REVERSED GLOTTAL STOP', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c2':{ u:'02c2', i:641, name:'MODIFIER LETTER LEFT ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02c3':{ u:'02c3', i:642, name:'MODIFIER LETTER RIGHT ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02c4':{ u:'02c4', i:643, name:'MODIFIER LETTER UP ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02c5':{ u:'02c5', i:644, name:'MODIFIER LETTER DOWN ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02c6':{ u:'02c6', i:645, name:'MODIFIER LETTER CIRCUMFLEX ACCENT', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c7':{ u:'02c7', i:646, name:'CARON', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c8':{ u:'02c8', i:647, name:'MODIFIER LETTER VERTICAL LINE', cat:c.Lm,   canon:k._0, block:b[5]},
			'02c9':{ u:'02c9', i:648, name:'MODIFIER LETTER MACRON', cat:c.Lm,   canon:k._0, block:b[5]},
			'02ca':{ u:'02ca', i:649, name:'MODIFIER LETTER ACUTE ACCENT', cat:c.Lm,   canon:k._0, block:b[5]},
			'02cb':{ u:'02cb', i:650, name:'MODIFIER LETTER GRAVE ACCENT', cat:c.Lm,   canon:k._0, block:b[5]},
			'02cc':{ u:'02cc', i:651, name:'MODIFIER LETTER LOW VERTICAL LINE', cat:c.Lm,   canon:k._0, block:b[5]},
			'02cd':{ u:'02cd', i:652, name:'MODIFIER LETTER LOW MACRON', cat:c.Lm,   canon:k._0, block:b[5]},
			'02ce':{ u:'02ce', i:653, name:'MODIFIER LETTER LOW GRAVE ACCENT', cat:c.Lm,   canon:k._0, block:b[5]},
			'02cf':{ u:'02cf', i:654, name:'MODIFIER LETTER LOW ACUTE ACCENT', cat:c.Lm,   canon:k._0, block:b[5]},
			'02d0':{ u:'02d0', i:655, name:'MODIFIER LETTER TRIANGULAR COLON', cat:c.Lm,  relatives:['10781'],  canon:k._0, block:b[5]},
			'02d1':{ u:'02d1', i:656, name:'MODIFIER LETTER HALF TRIANGULAR COLON', cat:c.Lm,  relatives:['10782'],  canon:k._0, block:b[5]},
			'02d2':{ u:'02d2', i:657, name:'MODIFIER LETTER CENTRED RIGHT HALF RING', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d3':{ u:'02d3', i:658, name:'MODIFIER LETTER CENTRED LEFT HALF RING', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d4':{ u:'02d4', i:659, name:'MODIFIER LETTER UP TACK', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d5':{ u:'02d5', i:660, name:'MODIFIER LETTER DOWN TACK', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d6':{ u:'02d6', i:661, name:'MODIFIER LETTER PLUS SIGN', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d7':{ u:'02d7', i:662, name:'MODIFIER LETTER MINUS SIGN', cat:c.Sk,   canon:k._0, block:b[5]},
			'02d8':{ u:'02d8', i:663, name:'BREVE', cat:c.Sk,  relatives:['0020', '0306'], comp:['0020','0306'], canon:k._0, block:b[5]},
			'02d9':{ u:'02d9', i:664, name:'DOT ABOVE', cat:c.Sk,  relatives:['0020', '0307'], comp:['0020','0307'], canon:k._0, block:b[5]},
			'02da':{ u:'02da', i:665, name:'RING ABOVE', cat:c.Sk,  relatives:['0020', '030a'], comp:['0020','030a'], canon:k._0, block:b[5]},
			'02db':{ u:'02db', i:666, name:'OGONEK', cat:c.Sk,  relatives:['0020', '0328'], comp:['0020','0328'], canon:k._0, block:b[5]},
			'02dc':{ u:'02dc', i:667, name:'SMALL TILDE', cat:c.Sk,  relatives:['0020', '0303'], comp:['0020','0303'], canon:k._0, block:b[5]},
			'02dd':{ u:'02dd', i:668, name:'DOUBLE ACUTE ACCENT', cat:c.Sk,  relatives:['0020', '030b'], comp:['0020','030b'], canon:k._0, block:b[5]},
			'02de':{ u:'02de', i:669, name:'MODIFIER LETTER RHOTIC HOOK', cat:c.Sk,   canon:k._0, block:b[5]},
			'02df':{ u:'02df', i:670, name:'MODIFIER LETTER CROSS ACCENT', cat:c.Sk,   canon:k._0, block:b[5]},
			'02e0':{ u:'02e0', i:671, name:'MODIFIER LETTER SMALL GAMMA', cat:c.Lm,  relatives:['0263'],  canon:k._0, block:b[5]},
			'02e1':{ u:'02e1', i:672, name:'MODIFIER LETTER SMALL L', cat:c.Lm,  relatives:['006c'],  canon:k._0, block:b[5], indexed:["L"]},
			'02e2':{ u:'02e2', i:673, name:'MODIFIER LETTER SMALL S', cat:c.Lm,  relatives:['0073'],  canon:k._0, block:b[5], indexed:["S"]},
			'02e3':{ u:'02e3', i:674, name:'MODIFIER LETTER SMALL X', cat:c.Lm,  relatives:['0078'],  canon:k._0, block:b[5], indexed:["X"]},
			'02e4':{ u:'02e4', i:675, name:'MODIFIER LETTER SMALL REVERSED GLOTTAL STOP', cat:c.Lm,  relatives:['0295'],  canon:k._0, block:b[5]},
			'02e5':{ u:'02e5', i:676, name:'MODIFIER LETTER EXTRA-HIGH TONE BAR', cat:c.Sk,   canon:k._0, block:b[5]},
			'02e6':{ u:'02e6', i:677, name:'MODIFIER LETTER HIGH TONE BAR', cat:c.Sk,   canon:k._0, block:b[5]},
			'02e7':{ u:'02e7', i:678, name:'MODIFIER LETTER MID TONE BAR', cat:c.Sk,   canon:k._0, block:b[5]},
			'02e8':{ u:'02e8', i:679, name:'MODIFIER LETTER LOW TONE BAR', cat:c.Sk,   canon:k._0, block:b[5]},
			'02e9':{ u:'02e9', i:680, name:'MODIFIER LETTER EXTRA-LOW TONE BAR', cat:c.Sk,   canon:k._0, block:b[5]},
			'02ea':{ u:'02ea', i:681, name:'MODIFIER LETTER YIN DEPARTING TONE MARK', cat:c.Sk,   canon:k._0, block:b[5]},
			'02eb':{ u:'02eb', i:682, name:'MODIFIER LETTER YANG DEPARTING TONE MARK', cat:c.Sk,   canon:k._0, block:b[5]},
			'02ec':{ u:'02ec', i:683, name:'MODIFIER LETTER VOICING', cat:c.Lm,   canon:k._0, block:b[5]},
			'02ed':{ u:'02ed', i:684, name:'MODIFIER LETTER UNASPIRATED', cat:c.Sk,   canon:k._0, block:b[5]},
			'02ee':{ u:'02ee', i:685, name:'MODIFIER LETTER DOUBLE APOSTROPHE', cat:c.Lm,   canon:k._0, block:b[5]},
			'02ef':{ u:'02ef', i:686, name:'MODIFIER LETTER LOW DOWN ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f0':{ u:'02f0', i:687, name:'MODIFIER LETTER LOW UP ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f1':{ u:'02f1', i:688, name:'MODIFIER LETTER LOW LEFT ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f2':{ u:'02f2', i:689, name:'MODIFIER LETTER LOW RIGHT ARROWHEAD', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f3':{ u:'02f3', i:690, name:'MODIFIER LETTER LOW RING', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f4':{ u:'02f4', i:691, name:'MODIFIER LETTER MIDDLE GRAVE ACCENT', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f5':{ u:'02f5', i:692, name:'MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f6':{ u:'02f6', i:693, name:'MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f7':{ u:'02f7', i:694, name:'MODIFIER LETTER LOW TILDE', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f8':{ u:'02f8', i:695, name:'MODIFIER LETTER RAISED COLON', cat:c.Sk,   canon:k._0, block:b[5]},
			'02f9':{ u:'02f9', i:696, name:'MODIFIER LETTER BEGIN HIGH TONE', cat:c.Sk,   canon:k._0, block:b[5]},
			'02fa':{ u:'02fa', i:697, name:'MODIFIER LETTER END HIGH TONE', cat:c.Sk,   canon:k._0, block:b[5]},
			'02fb':{ u:'02fb', i:698, name:'MODIFIER LETTER BEGIN LOW TONE', cat:c.Sk,   canon:k._0, block:b[5]},
			'02fc':{ u:'02fc', i:699, name:'MODIFIER LETTER END LOW TONE', cat:c.Sk,   canon:k._0, block:b[5]},
			'02fd':{ u:'02fd', i:700, name:'MODIFIER LETTER SHELF', cat:c.Sk,   canon:k._0, block:b[5]},
			'02fe':{ u:'02fe', i:701, name:'MODIFIER LETTER OPEN SHELF', cat:c.Sk,   canon:k._0, block:b[5]},
			'02ff':{ u:'02ff', i:702, name:'MODIFIER LETTER LOW LEFT ARROW', cat:c.Sk,   canon:k._0, block:b[5]},
			'0300':{ u:'0300', i:703, name:'COMBINING GRAVE ACCENT', cat:c.Mn,  relatives:['00c0', '00c8', '00cc', '00d2', '00d9', '00e0', '00e8', '00ec', '00f2', '00f9', '01db', '01dc', '01f8', '01f9', '0340', '0400', '040d', '0450', '045d', '1e14', '1e15', '1e50', '1e51', '1e80', '1e81', '1ea6', '1ea7', '1eb0', '1eb1', '1ec0', '1ec1', '1ed2', '1ed3', '1edc', '1edd', '1eea', '1eeb', '1ef2', '1ef3', '1f02', '1f03', '1f0a', '1f0b', '1f12', '1f13', '1f1a', '1f1b', '1f22', '1f23', '1f2a', '1f2b', '1f32', '1f33', '1f3a', '1f3b', '1f42', '1f43', '1f4a', '1f4b', '1f52', '1f53', '1f5b', '1f62', '1f63', '1f6a', '1f6b', '1f70', '1f72', '1f74', '1f76', '1f78', '1f7a', '1f7c', '1fba', '1fc8', '1fca', '1fcd', '1fd2', '1fda', '1fdd', '1fe2', '1fea', '1fed', '1ff8', '1ffa'],  canon:k._230, block:b[6]},
			'0301':{ u:'0301', i:704, name:'COMBINING ACUTE ACCENT', cat:c.Mn,  relatives:['00b4', '00c1', '00c9', '00cd', '00d3', '00da', '00dd', '00e1', '00e9', '00ed', '00f3', '00fa', '00fd', '0106', '0107', '0139', '013a', '0143', '0144', '0154', '0155', '015a', '015b', '0179', '017a', '01d7', '01d8', '01f4', '01f5', '01fa', '01fb', '01fc', '01fd', '01fe', '01ff', '0341', '0344', '0384', '0385', '0386', '0388', '0389', '038a', '038c', '038e', '038f', '0390', '03ac', '03ad', '03ae', '03af', '03b0', '03cc', '03cd', '03ce', '03d3', '0403', '040c', '0453', '045c', '1e08', '1e09', '1e16', '1e17', '1e2e', '1e2f', '1e30', '1e31', '1e3e', '1e3f', '1e4c', '1e4d', '1e52', '1e53', '1e54', '1e55', '1e78', '1e79', '1e82', '1e83', '1ea4', '1ea5', '1eae', '1eaf', '1ebe', '1ebf', '1ed0', '1ed1', '1eda', '1edb', '1ee8', '1ee9', '1f04', '1f05', '1f0c', '1f0d', '1f14', '1f15', '1f1c', '1f1d', '1f24', '1f25', '1f2c', '1f2d', '1f34', '1f35', '1f3c', '1f3d', '1f44', '1f45', '1f4c', '1f4d', '1f54', '1f55', '1f5d', '1f64', '1f65', '1f6c', '1f6d', '1fce', '1fde'],  canon:k._230, block:b[6]},
			'0302':{ u:'0302', i:705, name:'COMBINING CIRCUMFLEX ACCENT', cat:c.Mn,  relatives:['00c2', '00ca', '00ce', '00d4', '00db', '00e2', '00ea', '00ee', '00f4', '00fb', '0108', '0109', '011c', '011d', '0124', '0125', '0134', '0135', '015c', '015d', '0174', '0175', '0176', '0177', '1e90', '1e91', '1eac', '1ead', '1ec6', '1ec7', '1ed8', '1ed9'],  canon:k._230, block:b[6]},
			'0303':{ u:'0303', i:706, name:'COMBINING TILDE', cat:c.Mn,  relatives:['00c3', '00d1', '00d5', '00e3', '00f1', '00f5', '0128', '0129', '0168', '0169', '02dc', '1e7c', '1e7d', '1eaa', '1eab', '1eb4', '1eb5', '1ebc', '1ebd', '1ec4', '1ec5', '1ed6', '1ed7', '1ee0', '1ee1', '1eee', '1eef', '1ef8', '1ef9'],  canon:k._230, block:b[6]},
			'0304':{ u:'0304', i:707, name:'COMBINING MACRON', cat:c.Mn,  relatives:['00af', '0100', '0101', '0112', '0113', '012a', '012b', '014c', '014d', '016a', '016b', '01d5', '01d6', '01de', '01df', '01e0', '01e1', '01e2', '01e3', '01ec', '01ed', '022a', '022b', '022c', '022d', '0230', '0231', '0232', '0233', '04e2', '04e3', '04ee', '04ef', '1e20', '1e21', '1e38', '1e39', '1e5c', '1e5d', '1fb1', '1fb9', '1fd1', '1fd9', '1fe1', '1fe9'],  canon:k._230, block:b[6]},
			'0305':{ u:'0305', i:708, name:'COMBINING OVERLINE', cat:c.Mn,  relatives:['203e'],  canon:k._230, block:b[6]},
			'0306':{ u:'0306', i:709, name:'COMBINING BREVE', cat:c.Mn,  relatives:['0102', '0103', '0114', '0115', '011e', '011f', '012c', '012d', '014e', '014f', '016c', '016d', '02d8', '040e', '0419', '0439', '045e', '04c1', '04c2', '04d0', '04d1', '04d6', '04d7', '1e1c', '1e1d', '1eb6', '1eb7', '1fb0', '1fb8', '1fd0', '1fd8', '1fe0', '1fe8'],  canon:k._230, block:b[6]},
			'0307':{ u:'0307', i:710, name:'COMBINING DOT ABOVE', cat:c.Mn,  relatives:['010a', '010b', '0116', '0117', '0120', '0121', '0130', '017b', '017c', '0226', '0227', '022e', '022f', '02d9', '1e02', '1e03', '1e0a', '1e0b', '1e1e', '1e1f', '1e22', '1e23', '1e40', '1e41', '1e44', '1e45', '1e56', '1e57', '1e58', '1e59', '1e60', '1e61', '1e64', '1e65', '1e66', '1e67', '1e68', '1e69', '1e6a', '1e6b', '1e86', '1e87', '1e8a', '1e8b', '1e8e', '1e8f', '1e9b'],  canon:k._230, block:b[6]},
			'0308':{ u:'0308', i:711, name:'COMBINING DIAERESIS', cat:c.Mn,  relatives:['00a8', '00c4', '00cb', '00cf', '00d6', '00dc', '00e4', '00eb', '00ef', '00f6', '00fc', '00ff', '0178', '0344', '03aa', '03ab', '03ca', '03cb', '03d4', '0401', '0407', '0451', '0457', '04d2', '04d3', '04da', '04db', '04dc', '04dd', '04de', '04df', '04e4', '04e5', '04e6', '04e7', '04ea', '04eb', '04ec', '04ed', '04f0', '04f1', '04f4', '04f5', '04f8', '04f9', '1e26', '1e27', '1e4e', '1e4f', '1e7a', '1e7b', '1e84', '1e85', '1e8c', '1e8d', '1e97'],  canon:k._230, block:b[6]},
			'0309':{ u:'0309', i:712, name:'COMBINING HOOK ABOVE', cat:c.Mn,  relatives:['1ea2', '1ea3', '1ea8', '1ea9', '1eb2', '1eb3', '1eba', '1ebb', '1ec2', '1ec3', '1ec8', '1ec9', '1ece', '1ecf', '1ed4', '1ed5', '1ede', '1edf', '1ee6', '1ee7', '1eec', '1eed', '1ef6', '1ef7'],  canon:k._230, block:b[6]},
			'030a':{ u:'030a', i:713, name:'COMBINING RING ABOVE', cat:c.Mn,  relatives:['00c5', '00e5', '016e', '016f', '02da', '1e98', '1e99'],  canon:k._230, block:b[6]},
			'030b':{ u:'030b', i:714, name:'COMBINING DOUBLE ACUTE ACCENT', cat:c.Mn,  relatives:['0150', '0151', '0170', '0171', '02dd', '04f2', '04f3'],  canon:k._230, block:b[6]},
			'030c':{ u:'030c', i:715, name:'COMBINING CARON', cat:c.Mn,  relatives:['010c', '010d', '010e', '010f', '011a', '011b', '013d', '013e', '0147', '0148', '0158', '0159', '0160', '0161', '0164', '0165', '017d', '017e', '01cd', '01ce', '01cf', '01d0', '01d1', '01d2', '01d3', '01d4', '01d9', '01da', '01e6', '01e7', '01e8', '01e9', '01ee', '01ef', '01f0', '021e', '021f'],  canon:k._230, block:b[6]},
			'030d':{ u:'030d', i:716, name:'COMBINING VERTICAL LINE ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'030e':{ u:'030e', i:717, name:'COMBINING DOUBLE VERTICAL LINE ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'030f':{ u:'030f', i:718, name:'COMBINING DOUBLE GRAVE ACCENT', cat:c.Mn,  relatives:['0200', '0201', '0204', '0205', '0208', '0209', '020c', '020d', '0210', '0211', '0214', '0215', '0476', '0477'],  canon:k._230, block:b[6]},
			'0310':{ u:'0310', i:719, name:'COMBINING CANDRABINDU', cat:c.Mn,   canon:k._230, block:b[6]},
			'0311':{ u:'0311', i:720, name:'COMBINING INVERTED BREVE', cat:c.Mn,  relatives:['0202', '0203', '0206', '0207', '020a', '020b', '020e', '020f', '0212', '0213', '0216', '0217'],  canon:k._230, block:b[6]},
			'0312':{ u:'0312', i:721, name:'COMBINING TURNED COMMA ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0313':{ u:'0313', i:722, name:'COMBINING COMMA ABOVE', cat:c.Mn,  relatives:['0343', '1f00', '1f08', '1f10', '1f18', '1f20', '1f28', '1f30', '1f38', '1f40', '1f48', '1f50', '1f60', '1f68', '1fbd', '1fbf', '1fe4'],  canon:k._230, block:b[6]},
			'0314':{ u:'0314', i:723, name:'COMBINING REVERSED COMMA ABOVE', cat:c.Mn,  relatives:['1f01', '1f09', '1f11', '1f19', '1f21', '1f29', '1f31', '1f39', '1f41', '1f49', '1f51', '1f59', '1f61', '1f69', '1fe5', '1fec', '1ffe'],  canon:k._230, block:b[6]},
			'0315':{ u:'0315', i:724, name:'COMBINING COMMA ABOVE RIGHT', cat:c.Mn,   canon:k._232, block:b[6]},
			'0316':{ u:'0316', i:725, name:'COMBINING GRAVE ACCENT BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0317':{ u:'0317', i:726, name:'COMBINING ACUTE ACCENT BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0318':{ u:'0318', i:727, name:'COMBINING LEFT TACK BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0319':{ u:'0319', i:728, name:'COMBINING RIGHT TACK BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'031a':{ u:'031a', i:729, name:'COMBINING LEFT ANGLE ABOVE', cat:c.Mn,   canon:k._232, block:b[6]},
			'031b':{ u:'031b', i:730, name:'COMBINING HORN', cat:c.Mn,  relatives:['01a0', '01a1', '01af', '01b0'],  canon:k._216, block:b[6]},
			'031c':{ u:'031c', i:731, name:'COMBINING LEFT HALF RING BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'031d':{ u:'031d', i:732, name:'COMBINING UP TACK BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'031e':{ u:'031e', i:733, name:'COMBINING DOWN TACK BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'031f':{ u:'031f', i:734, name:'COMBINING PLUS SIGN BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0320':{ u:'0320', i:735, name:'COMBINING MINUS SIGN BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0321':{ u:'0321', i:736, name:'COMBINING PALATALIZED HOOK BELOW', cat:c.Mn,   canon:k._202, block:b[6]},
			'0322':{ u:'0322', i:737, name:'COMBINING RETROFLEX HOOK BELOW', cat:c.Mn,   canon:k._202, block:b[6]},
			'0323':{ u:'0323', i:738, name:'COMBINING DOT BELOW', cat:c.Mn,  relatives:['1e04', '1e05', '1e0c', '1e0d', '1e24', '1e25', '1e32', '1e33', '1e36', '1e37', '1e42', '1e43', '1e46', '1e47', '1e5a', '1e5b', '1e62', '1e63', '1e6c', '1e6d', '1e7e', '1e7f', '1e88', '1e89', '1e92', '1e93', '1ea0', '1ea1', '1eb8', '1eb9', '1eca', '1ecb', '1ecc', '1ecd', '1ee2', '1ee3', '1ee4', '1ee5', '1ef0', '1ef1', '1ef4', '1ef5'],  canon:k._220, block:b[6]},
			'0324':{ u:'0324', i:739, name:'COMBINING DIAERESIS BELOW', cat:c.Mn,  relatives:['1e72', '1e73'],  canon:k._220, block:b[6]},
			'0325':{ u:'0325', i:740, name:'COMBINING RING BELOW', cat:c.Mn,  relatives:['1e00', '1e01'],  canon:k._220, block:b[6]},
			'0326':{ u:'0326', i:741, name:'COMBINING COMMA BELOW', cat:c.Mn,  relatives:['0218', '0219', '021a', '021b'],  canon:k._220, block:b[6]},
			'0327':{ u:'0327', i:742, name:'COMBINING CEDILLA', cat:c.Mn,  relatives:['00b8', '00c7', '00e7', '0122', '0123', '0136', '0137', '013b', '013c', '0145', '0146', '0156', '0157', '015e', '015f', '0162', '0163', '0228', '0229', '1e10', '1e11', '1e28', '1e29'],  canon:k._202, block:b[6]},
			'0328':{ u:'0328', i:743, name:'COMBINING OGONEK', cat:c.Mn,  relatives:['0104', '0105', '0118', '0119', '012e', '012f', '0172', '0173', '01ea', '01eb', '02db'],  canon:k._202, block:b[6]},
			'0329':{ u:'0329', i:744, name:'COMBINING VERTICAL LINE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'032a':{ u:'032a', i:745, name:'COMBINING BRIDGE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'032b':{ u:'032b', i:746, name:'COMBINING INVERTED DOUBLE ARCH BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'032c':{ u:'032c', i:747, name:'COMBINING CARON BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'032d':{ u:'032d', i:748, name:'COMBINING CIRCUMFLEX ACCENT BELOW', cat:c.Mn,  relatives:['1e12', '1e13', '1e18', '1e19', '1e3c', '1e3d', '1e4a', '1e4b', '1e70', '1e71', '1e76', '1e77'],  canon:k._220, block:b[6]},
			'032e':{ u:'032e', i:749, name:'COMBINING BREVE BELOW', cat:c.Mn,  relatives:['1e2a', '1e2b'],  canon:k._220, block:b[6]},
			'032f':{ u:'032f', i:750, name:'COMBINING INVERTED BREVE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0330':{ u:'0330', i:751, name:'COMBINING TILDE BELOW', cat:c.Mn,  relatives:['1e1a', '1e1b', '1e2c', '1e2d', '1e74', '1e75'],  canon:k._220, block:b[6]},
			'0331':{ u:'0331', i:752, name:'COMBINING MACRON BELOW', cat:c.Mn,  relatives:['1e06', '1e07', '1e0e', '1e0f', '1e34', '1e35', '1e3a', '1e3b', '1e48', '1e49', '1e5e', '1e5f', '1e6e', '1e6f', '1e94', '1e95', '1e96'],  canon:k._220, block:b[6]},
			'0332':{ u:'0332', i:753, name:'COMBINING LOW LINE', cat:c.Mn,   canon:k._220, block:b[6]},
			'0333':{ u:'0333', i:754, name:'COMBINING DOUBLE LOW LINE', cat:c.Mn,  relatives:['2017'],  canon:k._220, block:b[6]},
			'0334':{ u:'0334', i:755, name:'COMBINING TILDE OVERLAY', cat:c.Mn,   canon:k._1, block:b[6]},
			'0335':{ u:'0335', i:756, name:'COMBINING SHORT STROKE OVERLAY', cat:c.Mn,   canon:k._1, block:b[6]},
			'0336':{ u:'0336', i:757, name:'COMBINING LONG STROKE OVERLAY', cat:c.Mn,   canon:k._1, block:b[6]},
			'0337':{ u:'0337', i:758, name:'COMBINING SHORT SOLIDUS OVERLAY', cat:c.Mn,   canon:k._1, block:b[6]},
			'0338':{ u:'0338', i:759, name:'COMBINING LONG SOLIDUS OVERLAY', cat:c.Mn,  relatives:['219a', '219b', '21ae', '21cd', '21ce', '21cf', '2204', '2209', '220c', '2224', '2226', '2241', '2244', '2247', '2249', '2260', '2262', '226d', '226e', '226f', '2270', '2271', '2274', '2275', '2278', '2279', '2280', '2281', '2284', '2285', '2288', '2289', '22ac', '22ad', '22ae', '22af', '22e0', '22e1', '22e2', '22e3', '22ea', '22eb', '22ec', '22ed', '2adc'],  canon:k._1, block:b[6]},
			'0339':{ u:'0339', i:760, name:'COMBINING RIGHT HALF RING BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'033a':{ u:'033a', i:761, name:'COMBINING INVERTED BRIDGE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'033b':{ u:'033b', i:762, name:'COMBINING SQUARE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'033c':{ u:'033c', i:763, name:'COMBINING SEAGULL BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'033d':{ u:'033d', i:764, name:'COMBINING X ABOVE', cat:c.Mn,   canon:k._230, block:b[6], indexed:["X"]},
			'033e':{ u:'033e', i:765, name:'COMBINING VERTICAL TILDE', cat:c.Mn,   canon:k._230, block:b[6]},
			'033f':{ u:'033f', i:766, name:'COMBINING DOUBLE OVERLINE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0340':{ u:'0340', i:767, name:'COMBINING GRAVE TONE MARK', cat:c.Mn,  relatives:['0300'],  canon:k._230, block:b[6]},
			'0341':{ u:'0341', i:768, name:'COMBINING ACUTE TONE MARK', cat:c.Mn,  relatives:['0301'],  canon:k._230, block:b[6]},
			'0342':{ u:'0342', i:769, name:'COMBINING GREEK PERISPOMENI', cat:c.Mn,  relatives:['1f06', '1f07', '1f0e', '1f0f', '1f26', '1f27', '1f2e', '1f2f', '1f36', '1f37', '1f3e', '1f3f', '1f56', '1f57', '1f5f', '1f66', '1f67', '1f6e', '1f6f', '1fb6', '1fc0', '1fc1', '1fc6', '1fcf', '1fd6', '1fd7', '1fdf', '1fe6', '1fe7', '1ff6'],  canon:k._230, block:b[6]},
			'0343':{ u:'0343', i:770, name:'COMBINING GREEK KORONIS', cat:c.Mn,  relatives:['0313'],  canon:k._230, block:b[6]},
			'0344':{ u:'0344', i:771, name:'COMBINING GREEK DIALYTIKA TONOS', cat:c.Mn,  relatives:['0308', '0301'], comp:['0308','0301'], canon:k._230, block:b[6]},
			'0345':{ u:'0345', i:772, name:'COMBINING GREEK YPOGEGRAMMENI', cat:c.Mn,  relatives:['037a', '1f80', '1f81', '1f82', '1f83', '1f84', '1f85', '1f86', '1f87', '1f88', '1f89', '1f8a', '1f8b', '1f8c', '1f8d', '1f8e', '1f8f', '1f90', '1f91', '1f92', '1f93', '1f94', '1f95', '1f96', '1f97', '1f98', '1f99', '1f9a', '1f9b', '1f9c', '1f9d', '1f9e', '1f9f', '1fa0', '1fa1', '1fa2', '1fa3', '1fa4', '1fa5', '1fa6', '1fa7', '1fa8', '1fa9', '1faa', '1fab', '1fac', '1fad', '1fae', '1faf', '1fb2', '1fb3', '1fb4', '1fb7', '1fbc', '1fc2', '1fc3', '1fc4', '1fc7', '1fcc', '1ff2', '1ff3', '1ff4', '1ff7', '1ffc'],  canon:k._240, block:b[6]},
			'0346':{ u:'0346', i:773, name:'COMBINING BRIDGE ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0347':{ u:'0347', i:774, name:'COMBINING EQUALS SIGN BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0348':{ u:'0348', i:775, name:'COMBINING DOUBLE VERTICAL LINE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0349':{ u:'0349', i:776, name:'COMBINING LEFT ANGLE BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'034a':{ u:'034a', i:777, name:'COMBINING NOT TILDE ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'034b':{ u:'034b', i:778, name:'COMBINING HOMOTHETIC ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'034c':{ u:'034c', i:779, name:'COMBINING ALMOST EQUAL TO ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'034d':{ u:'034d', i:780, name:'COMBINING LEFT RIGHT ARROW BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'034e':{ u:'034e', i:781, name:'COMBINING UPWARDS ARROW BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'034f':{ u:'034f', i:782, name:'COMBINING GRAPHEME JOINER', cat:c.Mn,   canon:k._0, block:b[6]},
			'0350':{ u:'0350', i:783, name:'COMBINING RIGHT ARROWHEAD ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0351':{ u:'0351', i:784, name:'COMBINING LEFT HALF RING ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0352':{ u:'0352', i:785, name:'COMBINING FERMATA', cat:c.Mn,   canon:k._230, block:b[6]},
			'0353':{ u:'0353', i:786, name:'COMBINING X BELOW', cat:c.Mn,   canon:k._220, block:b[6], indexed:["X"]},
			'0354':{ u:'0354', i:787, name:'COMBINING LEFT ARROWHEAD BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0355':{ u:'0355', i:788, name:'COMBINING RIGHT ARROWHEAD BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0356':{ u:'0356', i:789, name:'COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'0357':{ u:'0357', i:790, name:'COMBINING RIGHT HALF RING ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'0358':{ u:'0358', i:791, name:'COMBINING DOT ABOVE RIGHT', cat:c.Mn,   canon:k._232, block:b[6]},
			'0359':{ u:'0359', i:792, name:'COMBINING ASTERISK BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'035a':{ u:'035a', i:793, name:'COMBINING DOUBLE RING BELOW', cat:c.Mn,   canon:k._220, block:b[6]},
			'035b':{ u:'035b', i:794, name:'COMBINING ZIGZAG ABOVE', cat:c.Mn,   canon:k._230, block:b[6]},
			'035c':{ u:'035c', i:795, name:'COMBINING DOUBLE BREVE BELOW', cat:c.Mn,   canon:k._233, block:b[6]},
			'035d':{ u:'035d', i:796, name:'COMBINING DOUBLE BREVE', cat:c.Mn,   canon:k._234, block:b[6]},
			'035e':{ u:'035e', i:797, name:'COMBINING DOUBLE MACRON', cat:c.Mn,   canon:k._234, block:b[6]},
			'035f':{ u:'035f', i:798, name:'COMBINING DOUBLE MACRON BELOW', cat:c.Mn,   canon:k._233, block:b[6]},
			'0360':{ u:'0360', i:799, name:'COMBINING DOUBLE TILDE', cat:c.Mn,   canon:k._234, block:b[6]},
			'0361':{ u:'0361', i:800, name:'COMBINING DOUBLE INVERTED BREVE', cat:c.Mn,   canon:k._234, block:b[6]},
			'0362':{ u:'0362', i:801, name:'COMBINING DOUBLE RIGHTWARDS ARROW BELOW', cat:c.Mn,   canon:k._233, block:b[6]},
			'0363':{ u:'0363', i:802, name:'COMBINING LATIN SMALL LETTER A', cat:c.Mn,   canon:k._230, block:b[6], indexed:["A"]},
			'0364':{ u:'0364', i:803, name:'COMBINING LATIN SMALL LETTER E', cat:c.Mn,   canon:k._230, block:b[6], indexed:["E"]},
			'0365':{ u:'0365', i:804, name:'COMBINING LATIN SMALL LETTER I', cat:c.Mn,   canon:k._230, block:b[6], indexed:["I"]},
			'0366':{ u:'0366', i:805, name:'COMBINING LATIN SMALL LETTER O', cat:c.Mn,   canon:k._230, block:b[6], indexed:["O"]},
			'0367':{ u:'0367', i:806, name:'COMBINING LATIN SMALL LETTER U', cat:c.Mn,   canon:k._230, block:b[6], indexed:["U"]},
			'0368':{ u:'0368', i:807, name:'COMBINING LATIN SMALL LETTER C', cat:c.Mn,   canon:k._230, block:b[6], indexed:["C"]},
			'0369':{ u:'0369', i:808, name:'COMBINING LATIN SMALL LETTER D', cat:c.Mn,   canon:k._230, block:b[6], indexed:["D"]},
			'036a':{ u:'036a', i:809, name:'COMBINING LATIN SMALL LETTER H', cat:c.Mn,   canon:k._230, block:b[6], indexed:["H"]},
			'036b':{ u:'036b', i:810, name:'COMBINING LATIN SMALL LETTER M', cat:c.Mn,   canon:k._230, block:b[6], indexed:["M"]},
			'036c':{ u:'036c', i:811, name:'COMBINING LATIN SMALL LETTER R', cat:c.Mn,   canon:k._230, block:b[6], indexed:["R"]},
			'036d':{ u:'036d', i:812, name:'COMBINING LATIN SMALL LETTER T', cat:c.Mn,   canon:k._230, block:b[6], indexed:["T"]},
			'036e':{ u:'036e', i:813, name:'COMBINING LATIN SMALL LETTER V', cat:c.Mn,   canon:k._230, block:b[6], indexed:["V"]},
			'036f':{ u:'036f', i:814, name:'COMBINING LATIN SMALL LETTER X', cat:c.Mn,   canon:k._230, block:b[6], indexed:["X"]},
			'0370':{ u:'0370', i:815, name:'GREEK CAPITAL LETTER HETA', cat:c.Lu,   canon:k._0, block:b[7]},
			'0371':{ u:'0371', i:816, name:'GREEK SMALL LETTER HETA', cat:c.Ll,   canon:k._0, block:b[7]},
			'0372':{ u:'0372', i:817, name:'GREEK CAPITAL LETTER ARCHAIC SAMPI', cat:c.Lu,   canon:k._0, block:b[7]},
			'0373':{ u:'0373', i:818, name:'GREEK SMALL LETTER ARCHAIC SAMPI', cat:c.Ll,   canon:k._0, block:b[7]},
			'0374':{ u:'0374', i:819, name:'GREEK NUMERAL SIGN', cat:c.Lm,  relatives:['02b9'],  canon:k._0, block:b[7]},
			'0375':{ u:'0375', i:820, name:'GREEK LOWER NUMERAL SIGN', cat:c.Sk,   canon:k._0, block:b[7]},
			'0376':{ u:'0376', i:821, name:'GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA', cat:c.Lu,   canon:k._0, block:b[7]},
			'0377':{ u:'0377', i:822, name:'GREEK SMALL LETTER PAMPHYLIAN DIGAMMA', cat:c.Ll,   canon:k._0, block:b[7]},
			'037a':{ u:'037a', i:823, name:'GREEK YPOGEGRAMMENI', cat:c.Lm,  relatives:['0020', '0345'], comp:['0020','0345'], canon:k._0, block:b[7]},
			'037b':{ u:'037b', i:824, name:'GREEK SMALL REVERSED LUNATE SIGMA SYMBOL', cat:c.Ll,   canon:k._0, block:b[7]},
			'037c':{ u:'037c', i:825, name:'GREEK SMALL DOTTED LUNATE SIGMA SYMBOL', cat:c.Ll,   canon:k._0, block:b[7]},
			'037d':{ u:'037d', i:826, name:'GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL', cat:c.Ll,   canon:k._0, block:b[7]},
			'037e':{ u:'037e', i:827, name:'GREEK QUESTION MARK', cat:c.Po,  relatives:['003b'],  canon:k._0, block:b[7]},
			'037f':{ u:'037f', i:828, name:'GREEK CAPITAL LETTER YOT', cat:c.Lu,   canon:k._0, block:b[7]},
			'0384':{ u:'0384', i:829, name:'GREEK TONOS', cat:c.Sk,  relatives:['0020', '0301'], comp:['0020','0301'], canon:k._0, block:b[7]},
			'0385':{ u:'0385', i:830, name:'GREEK DIALYTIKA TONOS', cat:c.Sk,  relatives:['00a8', '0301', '1fee'], comp:['00a8','0301'], canon:k._0, block:b[7]},
			'0386':{ u:'0386', i:831, name:'GREEK CAPITAL LETTER ALPHA WITH TONOS', cat:c.Lu,  relatives:['0391', '0301', '1fbb'], comp:['0391','0301'], canon:k._0, block:b[7]},
			'0387':{ u:'0387', i:832, name:'GREEK ANO TELEIA', cat:c.Po,  relatives:['00b7'],  canon:k._0, block:b[7]},
			'0388':{ u:'0388', i:833, name:'GREEK CAPITAL LETTER EPSILON WITH TONOS', cat:c.Lu,  relatives:['0395', '0301', '1fc9'], comp:['0395','0301'], canon:k._0, block:b[7]},
			'0389':{ u:'0389', i:834, name:'GREEK CAPITAL LETTER ETA WITH TONOS', cat:c.Lu,  relatives:['0397', '0301', '1fcb'], comp:['0397','0301'], canon:k._0, block:b[7]},
			'038a':{ u:'038a', i:835, name:'GREEK CAPITAL LETTER IOTA WITH TONOS', cat:c.Lu,  relatives:['0399', '0301', '1fdb'], comp:['0399','0301'], canon:k._0, block:b[7]},
			'038c':{ u:'038c', i:836, name:'GREEK CAPITAL LETTER OMICRON WITH TONOS', cat:c.Lu,  relatives:['039f', '0301', '1ff9'], comp:['039f','0301'], canon:k._0, block:b[7]},
			'038e':{ u:'038e', i:837, name:'GREEK CAPITAL LETTER UPSILON WITH TONOS', cat:c.Lu,  relatives:['03a5', '0301', '1feb'], comp:['03a5','0301'], canon:k._0, block:b[7]},
			'038f':{ u:'038f', i:838, name:'GREEK CAPITAL LETTER OMEGA WITH TONOS', cat:c.Lu,  relatives:['03a9', '0301', '1ffb'], comp:['03a9','0301'], canon:k._0, block:b[7]},
			'0390':{ u:'0390', i:839, name:'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS', cat:c.Ll,  relatives:['03ca', '0301', '1fd3'], comp:['03ca','0301'], canon:k._0, block:b[7]},
			'0391':{ u:'0391', i:840, name:'GREEK CAPITAL LETTER ALPHA', cat:c.Lu,  relatives:['0386', '1f08', '1f09', '1fb8', '1fb9', '1fba', '1fbc', '1d6a8', '1d6e2', '1d71c', '1d756', '1d790'],  canon:k._0, block:b[7]},
			'0392':{ u:'0392', i:841, name:'GREEK CAPITAL LETTER BETA', cat:c.Lu,  relatives:['1d6a9', '1d6e3', '1d71d', '1d757', '1d791'],  canon:k._0, block:b[7]},
			'0393':{ u:'0393', i:842, name:'GREEK CAPITAL LETTER GAMMA', cat:c.Lu,  relatives:['213e', '1d6aa', '1d6e4', '1d71e', '1d758', '1d792'],  canon:k._0, block:b[7]},
			'0394':{ u:'0394', i:843, name:'GREEK CAPITAL LETTER DELTA', cat:c.Lu,  relatives:['1d6ab', '1d6e5', '1d71f', '1d759', '1d793'],  canon:k._0, block:b[7]},
			'0395':{ u:'0395', i:844, name:'GREEK CAPITAL LETTER EPSILON', cat:c.Lu,  relatives:['0388', '1f18', '1f19', '1fc8', '1d6ac', '1d6e6', '1d720', '1d75a', '1d794'],  canon:k._0, block:b[7]},
			'0396':{ u:'0396', i:845, name:'GREEK CAPITAL LETTER ZETA', cat:c.Lu,  relatives:['1d6ad', '1d6e7', '1d721', '1d75b', '1d795'],  canon:k._0, block:b[7]},
			'0397':{ u:'0397', i:846, name:'GREEK CAPITAL LETTER ETA', cat:c.Lu,  relatives:['0389', '1f28', '1f29', '1fca', '1fcc', '1d6ae', '1d6e8', '1d722', '1d75c', '1d796'],  canon:k._0, block:b[7]},
			'0398':{ u:'0398', i:847, name:'GREEK CAPITAL LETTER THETA', cat:c.Lu,  relatives:['03f4', '1d6af', '1d6e9', '1d723', '1d75d', '1d797'],  canon:k._0, block:b[7]},
			'0399':{ u:'0399', i:848, name:'GREEK CAPITAL LETTER IOTA', cat:c.Lu,  relatives:['038a', '03aa', '1f38', '1f39', '1fd8', '1fd9', '1fda', '1d6b0', '1d6ea', '1d724', '1d75e', '1d798'],  canon:k._0, block:b[7]},
			'039a':{ u:'039a', i:849, name:'GREEK CAPITAL LETTER KAPPA', cat:c.Lu,  relatives:['1d6b1', '1d6eb', '1d725', '1d75f', '1d799'],  canon:k._0, block:b[7]},
			'039b':{ u:'039b', i:850, name:'GREEK CAPITAL LETTER LAMDA', cat:c.Lu,  relatives:['1d6b2', '1d6ec', '1d726', '1d760', '1d79a'],  canon:k._0, block:b[7]},
			'039c':{ u:'039c', i:851, name:'GREEK CAPITAL LETTER MU', cat:c.Lu,  relatives:['1d6b3', '1d6ed', '1d727', '1d761', '1d79b'],  canon:k._0, block:b[7]},
			'039d':{ u:'039d', i:852, name:'GREEK CAPITAL LETTER NU', cat:c.Lu,  relatives:['1d6b4', '1d6ee', '1d728', '1d762', '1d79c'],  canon:k._0, block:b[7]},
			'039e':{ u:'039e', i:853, name:'GREEK CAPITAL LETTER XI', cat:c.Lu,  relatives:['1d6b5', '1d6ef', '1d729', '1d763', '1d79d'],  canon:k._0, block:b[7]},
			'039f':{ u:'039f', i:854, name:'GREEK CAPITAL LETTER OMICRON', cat:c.Lu,  relatives:['038c', '1f48', '1f49', '1ff8', '1d6b6', '1d6f0', '1d72a', '1d764', '1d79e'],  canon:k._0, block:b[7]},
			'03a0':{ u:'03a0', i:855, name:'GREEK CAPITAL LETTER PI', cat:c.Lu,  relatives:['213f', '1d6b7', '1d6f1', '1d72b', '1d765', '1d79f'],  canon:k._0, block:b[7]},
			'03a1':{ u:'03a1', i:856, name:'GREEK CAPITAL LETTER RHO', cat:c.Lu,  relatives:['1fec', '1d6b8', '1d6f2', '1d72c', '1d766', '1d7a0'],  canon:k._0, block:b[7]},
			'03a3':{ u:'03a3', i:857, name:'GREEK CAPITAL LETTER SIGMA', cat:c.Lu,  relatives:['03f9', '1d6ba', '1d6f4', '1d72e', '1d768', '1d7a2'],  canon:k._0, block:b[7]},
			'03a4':{ u:'03a4', i:858, name:'GREEK CAPITAL LETTER TAU', cat:c.Lu,  relatives:['1d6bb', '1d6f5', '1d72f', '1d769', '1d7a3'],  canon:k._0, block:b[7]},
			'03a5':{ u:'03a5', i:859, name:'GREEK CAPITAL LETTER UPSILON', cat:c.Lu,  relatives:['038e', '03ab', '03d2', '1f59', '1fe8', '1fe9', '1fea', '1d6bc', '1d6f6', '1d730', '1d76a', '1d7a4'],  canon:k._0, block:b[7]},
			'03a6':{ u:'03a6', i:860, name:'GREEK CAPITAL LETTER PHI', cat:c.Lu,  relatives:['1d6bd', '1d6f7', '1d731', '1d76b', '1d7a5'],  canon:k._0, block:b[7]},
			'03a7':{ u:'03a7', i:861, name:'GREEK CAPITAL LETTER CHI', cat:c.Lu,  relatives:['1d6be', '1d6f8', '1d732', '1d76c', '1d7a6'],  canon:k._0, block:b[7]},
			'03a8':{ u:'03a8', i:862, name:'GREEK CAPITAL LETTER PSI', cat:c.Lu,  relatives:['1d6bf', '1d6f9', '1d733', '1d76d', '1d7a7'],  canon:k._0, block:b[7]},
			'03a9':{ u:'03a9', i:863, name:'GREEK CAPITAL LETTER OMEGA', cat:c.Lu,  relatives:['038f', '1f68', '1f69', '1ffa', '1ffc', '2126', '33c0', '33c1', '1d6c0', '1d6fa', '1d734', '1d76e', '1d7a8'],  canon:k._0, block:b[7]},
			'03aa':{ u:'03aa', i:864, name:'GREEK CAPITAL LETTER IOTA WITH DIALYTIKA', cat:c.Lu,  relatives:['0399', '0308'], comp:['0399','0308'], canon:k._0, block:b[7]},
			'03ab':{ u:'03ab', i:865, name:'GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA', cat:c.Lu,  relatives:['03a5', '0308'], comp:['03a5','0308'], canon:k._0, block:b[7]},
			'03ac':{ u:'03ac', i:866, name:'GREEK SMALL LETTER ALPHA WITH TONOS', cat:c.Ll,  relatives:['03b1', '0301', '1f71', '1fb4'], comp:['03b1','0301'], canon:k._0, block:b[7]},
			'03ad':{ u:'03ad', i:867, name:'GREEK SMALL LETTER EPSILON WITH TONOS', cat:c.Ll,  relatives:['03b5', '0301', '1f73'], comp:['03b5','0301'], canon:k._0, block:b[7]},
			'03ae':{ u:'03ae', i:868, name:'GREEK SMALL LETTER ETA WITH TONOS', cat:c.Ll,  relatives:['03b7', '0301', '1f75', '1fc4'], comp:['03b7','0301'], canon:k._0, block:b[7]},
			'03af':{ u:'03af', i:869, name:'GREEK SMALL LETTER IOTA WITH TONOS', cat:c.Ll,  relatives:['03b9', '0301', '1f77'], comp:['03b9','0301'], canon:k._0, block:b[7]},
			'03b0':{ u:'03b0', i:870, name:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS', cat:c.Ll,  relatives:['03cb', '0301', '1fe3'], comp:['03cb','0301'], canon:k._0, block:b[7]},
			'03b1':{ u:'03b1', i:871, name:'GREEK SMALL LETTER ALPHA', cat:c.Ll,  relatives:['03ac', '1f00', '1f01', '1f70', '1fb0', '1fb1', '1fb3', '1fb6', '1d6c2', '1d6fc', '1d736', '1d770', '1d7aa'],  canon:k._0, block:b[7]},
			'03b2':{ u:'03b2', i:872, name:'GREEK SMALL LETTER BETA', cat:c.Ll,  relatives:['03d0', '1d5d', '1d66', '1d6c3', '1d6fd', '1d737', '1d771', '1d7ab'],  canon:k._0, block:b[7]},
			'03b3':{ u:'03b3', i:873, name:'GREEK SMALL LETTER GAMMA', cat:c.Ll,  relatives:['1d5e', '1d67', '213d', '1d6c4', '1d6fe', '1d738', '1d772', '1d7ac'],  canon:k._0, block:b[7]},
			'03b4':{ u:'03b4', i:874, name:'GREEK SMALL LETTER DELTA', cat:c.Ll,  relatives:['1d5f', '1d6c5', '1d6ff', '1d739', '1d773', '1d7ad'],  canon:k._0, block:b[7]},
			'03b5':{ u:'03b5', i:875, name:'GREEK SMALL LETTER EPSILON', cat:c.Ll,  relatives:['03ad', '03f5', '1f10', '1f11', '1f72', '1d6c6', '1d700', '1d73a', '1d774', '1d7ae'],  canon:k._0, block:b[7]},
			'03b6':{ u:'03b6', i:876, name:'GREEK SMALL LETTER ZETA', cat:c.Ll,  relatives:['1d6c7', '1d701', '1d73b', '1d775', '1d7af'],  canon:k._0, block:b[7]},
			'03b7':{ u:'03b7', i:877, name:'GREEK SMALL LETTER ETA', cat:c.Ll,  relatives:['03ae', '1f20', '1f21', '1f74', '1fc3', '1fc6', '1d6c8', '1d702', '1d73c', '1d776', '1d7b0'],  canon:k._0, block:b[7]},
			'03b8':{ u:'03b8', i:878, name:'GREEK SMALL LETTER THETA', cat:c.Ll,  relatives:['03d1', '1dbf', '1d6c9', '1d703', '1d73d', '1d777', '1d7b1'],  canon:k._0, block:b[7]},
			'03b9':{ u:'03b9', i:879, name:'GREEK SMALL LETTER IOTA', cat:c.Ll,  relatives:['03af', '03ca', '1f30', '1f31', '1f76', '1fbe', '1fd0', '1fd1', '1fd6', '1d6ca', '1d704', '1d73e', '1d778', '1d7b2'],  canon:k._0, block:b[7]},
			'03ba':{ u:'03ba', i:880, name:'GREEK SMALL LETTER KAPPA', cat:c.Ll,  relatives:['03f0', '1d6cb', '1d705', '1d73f', '1d779', '1d7b3'],  canon:k._0, block:b[7]},
			'03bb':{ u:'03bb', i:881, name:'GREEK SMALL LETTER LAMDA', cat:c.Ll,  relatives:['1d6cc', '1d706', '1d740', '1d77a', '1d7b4'],  canon:k._0, block:b[7]},
			'03bc':{ u:'03bc', i:882, name:'GREEK SMALL LETTER MU', cat:c.Ll,  relatives:['00b5', '3382', '338c', '338d', '3395', '339b', '33b2', '33b6', '33bc', '1d6cd', '1d707', '1d741', '1d77b', '1d7b5'],  canon:k._0, block:b[7]},
			'03bd':{ u:'03bd', i:883, name:'GREEK SMALL LETTER NU', cat:c.Ll,  relatives:['1d6ce', '1d708', '1d742', '1d77c', '1d7b6'],  canon:k._0, block:b[7]},
			'03be':{ u:'03be', i:884, name:'GREEK SMALL LETTER XI', cat:c.Ll,  relatives:['1d6cf', '1d709', '1d743', '1d77d', '1d7b7'],  canon:k._0, block:b[7]},
			'03bf':{ u:'03bf', i:885, name:'GREEK SMALL LETTER OMICRON', cat:c.Ll,  relatives:['03cc', '1f40', '1f41', '1f78', '1d6d0', '1d70a', '1d744', '1d77e', '1d7b8'],  canon:k._0, block:b[7]},
			'03c0':{ u:'03c0', i:886, name:'GREEK SMALL LETTER PI', cat:c.Ll,  relatives:['03d6', '213c', '1d6d1', '1d70b', '1d745', '1d77f', '1d7b9'],  canon:k._0, block:b[7]},
			'03c1':{ u:'03c1', i:887, name:'GREEK SMALL LETTER RHO', cat:c.Ll,  relatives:['03f1', '1d68', '1fe4', '1fe5', '1d6d2', '1d70c', '1d746', '1d780', '1d7ba'],  canon:k._0, block:b[7]},
			'03c2':{ u:'03c2', i:888, name:'GREEK SMALL LETTER FINAL SIGMA', cat:c.Ll,  relatives:['03f2', '1d6d3', '1d70d', '1d747', '1d781', '1d7bb'],  canon:k._0, block:b[7]},
			'03c3':{ u:'03c3', i:889, name:'GREEK SMALL LETTER SIGMA', cat:c.Ll,  relatives:['1d6d4', '1d70e', '1d748', '1d782', '1d7bc'],  canon:k._0, block:b[7]},
			'03c4':{ u:'03c4', i:890, name:'GREEK SMALL LETTER TAU', cat:c.Ll,  relatives:['1d6d5', '1d70f', '1d749', '1d783', '1d7bd'],  canon:k._0, block:b[7]},
			'03c5':{ u:'03c5', i:891, name:'GREEK SMALL LETTER UPSILON', cat:c.Ll,  relatives:['03cb', '03cd', '1f50', '1f51', '1f7a', '1fe0', '1fe1', '1fe6', '1d6d6', '1d710', '1d74a', '1d784', '1d7be'],  canon:k._0, block:b[7]},
			'03c6':{ u:'03c6', i:892, name:'GREEK SMALL LETTER PHI', cat:c.Ll,  relatives:['03d5', '1d60', '1d69', '1d6d7', '1d711', '1d74b', '1d785', '1d7bf'],  canon:k._0, block:b[7]},
			'03c7':{ u:'03c7', i:893, name:'GREEK SMALL LETTER CHI', cat:c.Ll,  relatives:['1d61', '1d6a', '1d6d8', '1d712', '1d74c', '1d786', '1d7c0'],  canon:k._0, block:b[7]},
			'03c8':{ u:'03c8', i:894, name:'GREEK SMALL LETTER PSI', cat:c.Ll,  relatives:['1d6d9', '1d713', '1d74d', '1d787', '1d7c1'],  canon:k._0, block:b[7]},
			'03c9':{ u:'03c9', i:895, name:'GREEK SMALL LETTER OMEGA', cat:c.Ll,  relatives:['03ce', '1f60', '1f61', '1f7c', '1ff3', '1ff6', '1d6da', '1d714', '1d74e', '1d788', '1d7c2'],  canon:k._0, block:b[7]},
			'03ca':{ u:'03ca', i:896, name:'GREEK SMALL LETTER IOTA WITH DIALYTIKA', cat:c.Ll,  relatives:['0390', '03b9', '0308', '1fd2', '1fd7'], comp:['03b9','0308'], canon:k._0, block:b[7]},
			'03cb':{ u:'03cb', i:897, name:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA', cat:c.Ll,  relatives:['03b0', '03c5', '0308', '1fe2', '1fe7'], comp:['03c5','0308'], canon:k._0, block:b[7]},
			'03cc':{ u:'03cc', i:898, name:'GREEK SMALL LETTER OMICRON WITH TONOS', cat:c.Ll,  relatives:['03bf', '0301', '1f79'], comp:['03bf','0301'], canon:k._0, block:b[7]},
			'03cd':{ u:'03cd', i:899, name:'GREEK SMALL LETTER UPSILON WITH TONOS', cat:c.Ll,  relatives:['03c5', '0301', '1f7b'], comp:['03c5','0301'], canon:k._0, block:b[7]},
			'03ce':{ u:'03ce', i:900, name:'GREEK SMALL LETTER OMEGA WITH TONOS', cat:c.Ll,  relatives:['03c9', '0301', '1f7d', '1ff4'], comp:['03c9','0301'], canon:k._0, block:b[7]},
			'03cf':{ u:'03cf', i:901, name:'GREEK CAPITAL KAI SYMBOL', cat:c.Lu,   canon:k._0, block:b[7]},
			'03d0':{ u:'03d0', i:902, name:'GREEK BETA SYMBOL', cat:c.Ll,  relatives:['03b2'],  canon:k._0, block:b[7]},
			'03d1':{ u:'03d1', i:903, name:'GREEK THETA SYMBOL', cat:c.Ll,  relatives:['03b8', '1d6dd', '1d717', '1d751', '1d78b', '1d7c5'],  canon:k._0, block:b[7]},
			'03d2':{ u:'03d2', i:904, name:'GREEK UPSILON WITH HOOK SYMBOL', cat:c.Lu,  relatives:['03a5', '03d3', '03d4'],  canon:k._0, block:b[7]},
			'03d3':{ u:'03d3', i:905, name:'GREEK UPSILON WITH ACUTE AND HOOK SYMBOL', cat:c.Lu,  relatives:['03d2', '0301'], comp:['03d2','0301'], canon:k._0, block:b[7]},
			'03d4':{ u:'03d4', i:906, name:'GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL', cat:c.Lu,  relatives:['03d2', '0308'], comp:['03d2','0308'], canon:k._0, block:b[7]},
			'03d5':{ u:'03d5', i:907, name:'GREEK PHI SYMBOL', cat:c.Ll,  relatives:['03c6', '1d6df', '1d719', '1d753', '1d78d', '1d7c7'],  canon:k._0, block:b[7]},
			'03d6':{ u:'03d6', i:908, name:'GREEK PI SYMBOL', cat:c.Ll,  relatives:['03c0', '1d6e1', '1d71b', '1d755', '1d78f', '1d7c9'],  canon:k._0, block:b[7]},
			'03d7':{ u:'03d7', i:909, name:'GREEK KAI SYMBOL', cat:c.Ll,   canon:k._0, block:b[7]},
			'03d8':{ u:'03d8', i:910, name:'GREEK LETTER ARCHAIC KOPPA', cat:c.Lu,   canon:k._0, block:b[7]},
			'03d9':{ u:'03d9', i:911, name:'GREEK SMALL LETTER ARCHAIC KOPPA', cat:c.Ll,   canon:k._0, block:b[7]},
			'03da':{ u:'03da', i:912, name:'GREEK LETTER STIGMA', cat:c.Lu,   canon:k._0, block:b[7]},
			'03db':{ u:'03db', i:913, name:'GREEK SMALL LETTER STIGMA', cat:c.Ll,   canon:k._0, block:b[7]},
			'03dc':{ u:'03dc', i:914, name:'GREEK LETTER DIGAMMA', cat:c.Lu,  relatives:['1d7ca'],  canon:k._0, block:b[7]},
			'03dd':{ u:'03dd', i:915, name:'GREEK SMALL LETTER DIGAMMA', cat:c.Ll,  relatives:['1d7cb'],  canon:k._0, block:b[7]},
			'03de':{ u:'03de', i:916, name:'GREEK LETTER KOPPA', cat:c.Lu,   canon:k._0, block:b[7]},
			'03df':{ u:'03df', i:917, name:'GREEK SMALL LETTER KOPPA', cat:c.Ll,   canon:k._0, block:b[7]},
			'03e0':{ u:'03e0', i:918, name:'GREEK LETTER SAMPI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03e1':{ u:'03e1', i:919, name:'GREEK SMALL LETTER SAMPI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03e2':{ u:'03e2', i:920, name:'COPTIC CAPITAL LETTER SHEI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03e3':{ u:'03e3', i:921, name:'COPTIC SMALL LETTER SHEI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03e4':{ u:'03e4', i:922, name:'COPTIC CAPITAL LETTER FEI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03e5':{ u:'03e5', i:923, name:'COPTIC SMALL LETTER FEI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03e6':{ u:'03e6', i:924, name:'COPTIC CAPITAL LETTER KHEI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03e7':{ u:'03e7', i:925, name:'COPTIC SMALL LETTER KHEI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03e8':{ u:'03e8', i:926, name:'COPTIC CAPITAL LETTER HORI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03e9':{ u:'03e9', i:927, name:'COPTIC SMALL LETTER HORI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03ea':{ u:'03ea', i:928, name:'COPTIC CAPITAL LETTER GANGIA', cat:c.Lu,   canon:k._0, block:b[7]},
			'03eb':{ u:'03eb', i:929, name:'COPTIC SMALL LETTER GANGIA', cat:c.Ll,   canon:k._0, block:b[7]},
			'03ec':{ u:'03ec', i:930, name:'COPTIC CAPITAL LETTER SHIMA', cat:c.Lu,   canon:k._0, block:b[7]},
			'03ed':{ u:'03ed', i:931, name:'COPTIC SMALL LETTER SHIMA', cat:c.Ll,   canon:k._0, block:b[7]},
			'03ee':{ u:'03ee', i:932, name:'COPTIC CAPITAL LETTER DEI', cat:c.Lu,   canon:k._0, block:b[7]},
			'03ef':{ u:'03ef', i:933, name:'COPTIC SMALL LETTER DEI', cat:c.Ll,   canon:k._0, block:b[7]},
			'03f0':{ u:'03f0', i:934, name:'GREEK KAPPA SYMBOL', cat:c.Ll,  relatives:['03ba', '1d6de', '1d718', '1d752', '1d78c', '1d7c6'],  canon:k._0, block:b[7]},
			'03f1':{ u:'03f1', i:935, name:'GREEK RHO SYMBOL', cat:c.Ll,  relatives:['03c1', '1d6e0', '1d71a', '1d754', '1d78e', '1d7c8'],  canon:k._0, block:b[7]},
			'03f2':{ u:'03f2', i:936, name:'GREEK LUNATE SIGMA SYMBOL', cat:c.Ll,  relatives:['03c2'],  canon:k._0, block:b[7]},
			'03f3':{ u:'03f3', i:937, name:'GREEK LETTER YOT', cat:c.Ll,   canon:k._0, block:b[7]},
			'03f4':{ u:'03f4', i:938, name:'GREEK CAPITAL THETA SYMBOL', cat:c.Lu,  relatives:['0398', '1d6b9', '1d6f3', '1d72d', '1d767', '1d7a1'],  canon:k._0, block:b[7]},
			'03f5':{ u:'03f5', i:939, name:'GREEK LUNATE EPSILON SYMBOL', cat:c.Ll,  relatives:['03b5', '1d6dc', '1d716', '1d750', '1d78a', '1d7c4'],  canon:k._0, block:b[7]},
			'03f6':{ u:'03f6', i:940, name:'GREEK REVERSED LUNATE EPSILON SYMBOL', cat:c.Sm,   canon:k._0, block:b[7]},
			'03f7':{ u:'03f7', i:941, name:'GREEK CAPITAL LETTER SHO', cat:c.Lu,   canon:k._0, block:b[7]},
			'03f8':{ u:'03f8', i:942, name:'GREEK SMALL LETTER SHO', cat:c.Ll,   canon:k._0, block:b[7]},
			'03f9':{ u:'03f9', i:943, name:'GREEK CAPITAL LUNATE SIGMA SYMBOL', cat:c.Lu,  relatives:['03a3'],  canon:k._0, block:b[7]},
			'03fa':{ u:'03fa', i:944, name:'GREEK CAPITAL LETTER SAN', cat:c.Lu,   canon:k._0, block:b[7]},
			'03fb':{ u:'03fb', i:945, name:'GREEK SMALL LETTER SAN', cat:c.Ll,   canon:k._0, block:b[7]},
			'03fc':{ u:'03fc', i:946, name:'GREEK RHO WITH STROKE SYMBOL', cat:c.Ll,   canon:k._0, block:b[7]},
			'03fd':{ u:'03fd', i:947, name:'GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL', cat:c.Lu,   canon:k._0, block:b[7]},
			'03fe':{ u:'03fe', i:948, name:'GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL', cat:c.Lu,   canon:k._0, block:b[7]},
			'03ff':{ u:'03ff', i:949, name:'GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL', cat:c.Lu,   canon:k._0, block:b[7]},
			'0400':{ u:'0400', i:950, name:'CYRILLIC CAPITAL LETTER IE WITH GRAVE', cat:c.Lu,  relatives:['0415', '0300'], comp:['0415','0300'], canon:k._0, block:b[8]},
			'0401':{ u:'0401', i:951, name:'CYRILLIC CAPITAL LETTER IO', cat:c.Lu,  relatives:['0415', '0308'], comp:['0415','0308'], canon:k._0, block:b[8]},
			'0402':{ u:'0402', i:952, name:'CYRILLIC CAPITAL LETTER DJE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0403':{ u:'0403', i:953, name:'CYRILLIC CAPITAL LETTER GJE', cat:c.Lu,  relatives:['0413', '0301'], comp:['0413','0301'], canon:k._0, block:b[8]},
			'0404':{ u:'0404', i:954, name:'CYRILLIC CAPITAL LETTER UKRAINIAN IE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0405':{ u:'0405', i:955, name:'CYRILLIC CAPITAL LETTER DZE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0406':{ u:'0406', i:956, name:'CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I', cat:c.Lu,  relatives:['0407'],  canon:k._0, block:b[8], indexed:["I"]},
			'0407':{ u:'0407', i:957, name:'CYRILLIC CAPITAL LETTER YI', cat:c.Lu,  relatives:['0406', '0308'], comp:['0406','0308'], canon:k._0, block:b[8]},
			'0408':{ u:'0408', i:958, name:'CYRILLIC CAPITAL LETTER JE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0409':{ u:'0409', i:959, name:'CYRILLIC CAPITAL LETTER LJE', cat:c.Lu,   canon:k._0, block:b[8]},
			'040a':{ u:'040a', i:960, name:'CYRILLIC CAPITAL LETTER NJE', cat:c.Lu,   canon:k._0, block:b[8]},
			'040b':{ u:'040b', i:961, name:'CYRILLIC CAPITAL LETTER TSHE', cat:c.Lu,   canon:k._0, block:b[8]},
			'040c':{ u:'040c', i:962, name:'CYRILLIC CAPITAL LETTER KJE', cat:c.Lu,  relatives:['041a', '0301'], comp:['041a','0301'], canon:k._0, block:b[8]},
			'040d':{ u:'040d', i:963, name:'CYRILLIC CAPITAL LETTER I WITH GRAVE', cat:c.Lu,  relatives:['0418', '0300'], comp:['0418','0300'], canon:k._0, block:b[8], indexed:["I"]},
			'040e':{ u:'040e', i:964, name:'CYRILLIC CAPITAL LETTER SHORT U', cat:c.Lu,  relatives:['0423', '0306'], comp:['0423','0306'], canon:k._0, block:b[8], indexed:["U"]},
			'040f':{ u:'040f', i:965, name:'CYRILLIC CAPITAL LETTER DZHE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0410':{ u:'0410', i:966, name:'CYRILLIC CAPITAL LETTER A', cat:c.Lu,  relatives:['04d0', '04d2'],  canon:k._0, block:b[8], indexed:["A"]},
			'0411':{ u:'0411', i:967, name:'CYRILLIC CAPITAL LETTER BE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0412':{ u:'0412', i:968, name:'CYRILLIC CAPITAL LETTER VE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0413':{ u:'0413', i:969, name:'CYRILLIC CAPITAL LETTER GHE', cat:c.Lu,  relatives:['0403'],  canon:k._0, block:b[8]},
			'0414':{ u:'0414', i:970, name:'CYRILLIC CAPITAL LETTER DE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0415':{ u:'0415', i:971, name:'CYRILLIC CAPITAL LETTER IE', cat:c.Lu,  relatives:['0400', '0401', '04d6'],  canon:k._0, block:b[8]},
			'0416':{ u:'0416', i:972, name:'CYRILLIC CAPITAL LETTER ZHE', cat:c.Lu,  relatives:['04c1', '04dc'],  canon:k._0, block:b[8]},
			'0417':{ u:'0417', i:973, name:'CYRILLIC CAPITAL LETTER ZE', cat:c.Lu,  relatives:['04de'],  canon:k._0, block:b[8]},
			'0418':{ u:'0418', i:974, name:'CYRILLIC CAPITAL LETTER I', cat:c.Lu,  relatives:['040d', '0419', '04e2', '04e4'],  canon:k._0, block:b[8], indexed:["I"]},
			'0419':{ u:'0419', i:975, name:'CYRILLIC CAPITAL LETTER SHORT I', cat:c.Lu,  relatives:['0418', '0306'], comp:['0418','0306'], canon:k._0, block:b[8], indexed:["I"]},
			'041a':{ u:'041a', i:976, name:'CYRILLIC CAPITAL LETTER KA', cat:c.Lu,  relatives:['040c'],  canon:k._0, block:b[8]},
			'041b':{ u:'041b', i:977, name:'CYRILLIC CAPITAL LETTER EL', cat:c.Lu,   canon:k._0, block:b[8]},
			'041c':{ u:'041c', i:978, name:'CYRILLIC CAPITAL LETTER EM', cat:c.Lu,   canon:k._0, block:b[8]},
			'041d':{ u:'041d', i:979, name:'CYRILLIC CAPITAL LETTER EN', cat:c.Lu,   canon:k._0, block:b[8]},
			'041e':{ u:'041e', i:980, name:'CYRILLIC CAPITAL LETTER O', cat:c.Lu,  relatives:['04e6'],  canon:k._0, block:b[8], indexed:["O"]},
			'041f':{ u:'041f', i:981, name:'CYRILLIC CAPITAL LETTER PE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0420':{ u:'0420', i:982, name:'CYRILLIC CAPITAL LETTER ER', cat:c.Lu,   canon:k._0, block:b[8]},
			'0421':{ u:'0421', i:983, name:'CYRILLIC CAPITAL LETTER ES', cat:c.Lu,   canon:k._0, block:b[8]},
			'0422':{ u:'0422', i:984, name:'CYRILLIC CAPITAL LETTER TE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0423':{ u:'0423', i:985, name:'CYRILLIC CAPITAL LETTER U', cat:c.Lu,  relatives:['040e', '04ee', '04f0', '04f2'],  canon:k._0, block:b[8], indexed:["U"]},
			'0424':{ u:'0424', i:986, name:'CYRILLIC CAPITAL LETTER EF', cat:c.Lu,   canon:k._0, block:b[8]},
			'0425':{ u:'0425', i:987, name:'CYRILLIC CAPITAL LETTER HA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0426':{ u:'0426', i:988, name:'CYRILLIC CAPITAL LETTER TSE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0427':{ u:'0427', i:989, name:'CYRILLIC CAPITAL LETTER CHE', cat:c.Lu,  relatives:['04f4'],  canon:k._0, block:b[8]},
			'0428':{ u:'0428', i:990, name:'CYRILLIC CAPITAL LETTER SHA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0429':{ u:'0429', i:991, name:'CYRILLIC CAPITAL LETTER SHCHA', cat:c.Lu,   canon:k._0, block:b[8]},
			'042a':{ u:'042a', i:992, name:'CYRILLIC CAPITAL LETTER HARD SIGN', cat:c.Lu,   canon:k._0, block:b[8]},
			'042b':{ u:'042b', i:993, name:'CYRILLIC CAPITAL LETTER YERU', cat:c.Lu,  relatives:['04f8'],  canon:k._0, block:b[8]},
			'042c':{ u:'042c', i:994, name:'CYRILLIC CAPITAL LETTER SOFT SIGN', cat:c.Lu,   canon:k._0, block:b[8]},
			'042d':{ u:'042d', i:995, name:'CYRILLIC CAPITAL LETTER E', cat:c.Lu,  relatives:['04ec'],  canon:k._0, block:b[8], indexed:["E"]},
			'042e':{ u:'042e', i:996, name:'CYRILLIC CAPITAL LETTER YU', cat:c.Lu,   canon:k._0, block:b[8]},
			'042f':{ u:'042f', i:997, name:'CYRILLIC CAPITAL LETTER YA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0430':{ u:'0430', i:998, name:'CYRILLIC SMALL LETTER A', cat:c.Ll,  relatives:['04d1', '04d3'],  canon:k._0, block:b[8], indexed:["A"]},
			'0431':{ u:'0431', i:999, name:'CYRILLIC SMALL LETTER BE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0432':{ u:'0432', i:1000, name:'CYRILLIC SMALL LETTER VE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0433':{ u:'0433', i:1001, name:'CYRILLIC SMALL LETTER GHE', cat:c.Ll,  relatives:['0453'],  canon:k._0, block:b[8]},
			'0434':{ u:'0434', i:1002, name:'CYRILLIC SMALL LETTER DE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0435':{ u:'0435', i:1003, name:'CYRILLIC SMALL LETTER IE', cat:c.Ll,  relatives:['0450', '0451', '04d7'],  canon:k._0, block:b[8]},
			'0436':{ u:'0436', i:1004, name:'CYRILLIC SMALL LETTER ZHE', cat:c.Ll,  relatives:['04c2', '04dd'],  canon:k._0, block:b[8]},
			'0437':{ u:'0437', i:1005, name:'CYRILLIC SMALL LETTER ZE', cat:c.Ll,  relatives:['04df'],  canon:k._0, block:b[8]},
			'0438':{ u:'0438', i:1006, name:'CYRILLIC SMALL LETTER I', cat:c.Ll,  relatives:['0439', '045d', '04e3', '04e5'],  canon:k._0, block:b[8], indexed:["I"]},
			'0439':{ u:'0439', i:1007, name:'CYRILLIC SMALL LETTER SHORT I', cat:c.Ll,  relatives:['0438', '0306'], comp:['0438','0306'], canon:k._0, block:b[8], indexed:["I"]},
			'043a':{ u:'043a', i:1008, name:'CYRILLIC SMALL LETTER KA', cat:c.Ll,  relatives:['045c'],  canon:k._0, block:b[8]},
			'043b':{ u:'043b', i:1009, name:'CYRILLIC SMALL LETTER EL', cat:c.Ll,   canon:k._0, block:b[8]},
			'043c':{ u:'043c', i:1010, name:'CYRILLIC SMALL LETTER EM', cat:c.Ll,   canon:k._0, block:b[8]},
			'043d':{ u:'043d', i:1011, name:'CYRILLIC SMALL LETTER EN', cat:c.Ll,  relatives:['1d78'],  canon:k._0, block:b[8]},
			'043e':{ u:'043e', i:1012, name:'CYRILLIC SMALL LETTER O', cat:c.Ll,  relatives:['04e7'],  canon:k._0, block:b[8], indexed:["O"]},
			'043f':{ u:'043f', i:1013, name:'CYRILLIC SMALL LETTER PE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0440':{ u:'0440', i:1014, name:'CYRILLIC SMALL LETTER ER', cat:c.Ll,   canon:k._0, block:b[8]},
			'0441':{ u:'0441', i:1015, name:'CYRILLIC SMALL LETTER ES', cat:c.Ll,   canon:k._0, block:b[8]},
			'0442':{ u:'0442', i:1016, name:'CYRILLIC SMALL LETTER TE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0443':{ u:'0443', i:1017, name:'CYRILLIC SMALL LETTER U', cat:c.Ll,  relatives:['045e', '04ef', '04f1', '04f3'],  canon:k._0, block:b[8], indexed:["U"]},
			'0444':{ u:'0444', i:1018, name:'CYRILLIC SMALL LETTER EF', cat:c.Ll,   canon:k._0, block:b[8]},
			'0445':{ u:'0445', i:1019, name:'CYRILLIC SMALL LETTER HA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0446':{ u:'0446', i:1020, name:'CYRILLIC SMALL LETTER TSE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0447':{ u:'0447', i:1021, name:'CYRILLIC SMALL LETTER CHE', cat:c.Ll,  relatives:['04f5'],  canon:k._0, block:b[8]},
			'0448':{ u:'0448', i:1022, name:'CYRILLIC SMALL LETTER SHA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0449':{ u:'0449', i:1023, name:'CYRILLIC SMALL LETTER SHCHA', cat:c.Ll,   canon:k._0, block:b[8]},
			'044a':{ u:'044a', i:1024, name:'CYRILLIC SMALL LETTER HARD SIGN', cat:c.Ll,  relatives:['a69c'],  canon:k._0, block:b[8]},
			'044b':{ u:'044b', i:1025, name:'CYRILLIC SMALL LETTER YERU', cat:c.Ll,  relatives:['04f9'],  canon:k._0, block:b[8]},
			'044c':{ u:'044c', i:1026, name:'CYRILLIC SMALL LETTER SOFT SIGN', cat:c.Ll,  relatives:['a69d'],  canon:k._0, block:b[8]},
			'044d':{ u:'044d', i:1027, name:'CYRILLIC SMALL LETTER E', cat:c.Ll,  relatives:['04ed'],  canon:k._0, block:b[8], indexed:["E"]},
			'044e':{ u:'044e', i:1028, name:'CYRILLIC SMALL LETTER YU', cat:c.Ll,   canon:k._0, block:b[8]},
			'044f':{ u:'044f', i:1029, name:'CYRILLIC SMALL LETTER YA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0450':{ u:'0450', i:1030, name:'CYRILLIC SMALL LETTER IE WITH GRAVE', cat:c.Ll,  relatives:['0435', '0300'], comp:['0435','0300'], canon:k._0, block:b[8]},
			'0451':{ u:'0451', i:1031, name:'CYRILLIC SMALL LETTER IO', cat:c.Ll,  relatives:['0435', '0308'], comp:['0435','0308'], canon:k._0, block:b[8]},
			'0452':{ u:'0452', i:1032, name:'CYRILLIC SMALL LETTER DJE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0453':{ u:'0453', i:1033, name:'CYRILLIC SMALL LETTER GJE', cat:c.Ll,  relatives:['0433', '0301'], comp:['0433','0301'], canon:k._0, block:b[8]},
			'0454':{ u:'0454', i:1034, name:'CYRILLIC SMALL LETTER UKRAINIAN IE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0455':{ u:'0455', i:1035, name:'CYRILLIC SMALL LETTER DZE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0456':{ u:'0456', i:1036, name:'CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I', cat:c.Ll,  relatives:['0457'],  canon:k._0, block:b[8], indexed:["I"]},
			'0457':{ u:'0457', i:1037, name:'CYRILLIC SMALL LETTER YI', cat:c.Ll,  relatives:['0456', '0308'], comp:['0456','0308'], canon:k._0, block:b[8]},
			'0458':{ u:'0458', i:1038, name:'CYRILLIC SMALL LETTER JE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0459':{ u:'0459', i:1039, name:'CYRILLIC SMALL LETTER LJE', cat:c.Ll,   canon:k._0, block:b[8]},
			'045a':{ u:'045a', i:1040, name:'CYRILLIC SMALL LETTER NJE', cat:c.Ll,   canon:k._0, block:b[8]},
			'045b':{ u:'045b', i:1041, name:'CYRILLIC SMALL LETTER TSHE', cat:c.Ll,   canon:k._0, block:b[8]},
			'045c':{ u:'045c', i:1042, name:'CYRILLIC SMALL LETTER KJE', cat:c.Ll,  relatives:['043a', '0301'], comp:['043a','0301'], canon:k._0, block:b[8]},
			'045d':{ u:'045d', i:1043, name:'CYRILLIC SMALL LETTER I WITH GRAVE', cat:c.Ll,  relatives:['0438', '0300'], comp:['0438','0300'], canon:k._0, block:b[8], indexed:["I"]},
			'045e':{ u:'045e', i:1044, name:'CYRILLIC SMALL LETTER SHORT U', cat:c.Ll,  relatives:['0443', '0306'], comp:['0443','0306'], canon:k._0, block:b[8], indexed:["U"]},
			'045f':{ u:'045f', i:1045, name:'CYRILLIC SMALL LETTER DZHE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0460':{ u:'0460', i:1046, name:'CYRILLIC CAPITAL LETTER OMEGA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0461':{ u:'0461', i:1047, name:'CYRILLIC SMALL LETTER OMEGA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0462':{ u:'0462', i:1048, name:'CYRILLIC CAPITAL LETTER YAT', cat:c.Lu,   canon:k._0, block:b[8]},
			'0463':{ u:'0463', i:1049, name:'CYRILLIC SMALL LETTER YAT', cat:c.Ll,   canon:k._0, block:b[8]},
			'0464':{ u:'0464', i:1050, name:'CYRILLIC CAPITAL LETTER IOTIFIED E', cat:c.Lu,   canon:k._0, block:b[8], indexed:["E"]},
			'0465':{ u:'0465', i:1051, name:'CYRILLIC SMALL LETTER IOTIFIED E', cat:c.Ll,   canon:k._0, block:b[8], indexed:["E"]},
			'0466':{ u:'0466', i:1052, name:'CYRILLIC CAPITAL LETTER LITTLE YUS', cat:c.Lu,   canon:k._0, block:b[8]},
			'0467':{ u:'0467', i:1053, name:'CYRILLIC SMALL LETTER LITTLE YUS', cat:c.Ll,   canon:k._0, block:b[8]},
			'0468':{ u:'0468', i:1054, name:'CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS', cat:c.Lu,   canon:k._0, block:b[8]},
			'0469':{ u:'0469', i:1055, name:'CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS', cat:c.Ll,   canon:k._0, block:b[8]},
			'046a':{ u:'046a', i:1056, name:'CYRILLIC CAPITAL LETTER BIG YUS', cat:c.Lu,   canon:k._0, block:b[8]},
			'046b':{ u:'046b', i:1057, name:'CYRILLIC SMALL LETTER BIG YUS', cat:c.Ll,   canon:k._0, block:b[8]},
			'046c':{ u:'046c', i:1058, name:'CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS', cat:c.Lu,   canon:k._0, block:b[8]},
			'046d':{ u:'046d', i:1059, name:'CYRILLIC SMALL LETTER IOTIFIED BIG YUS', cat:c.Ll,   canon:k._0, block:b[8]},
			'046e':{ u:'046e', i:1060, name:'CYRILLIC CAPITAL LETTER KSI', cat:c.Lu,   canon:k._0, block:b[8]},
			'046f':{ u:'046f', i:1061, name:'CYRILLIC SMALL LETTER KSI', cat:c.Ll,   canon:k._0, block:b[8]},
			'0470':{ u:'0470', i:1062, name:'CYRILLIC CAPITAL LETTER PSI', cat:c.Lu,   canon:k._0, block:b[8]},
			'0471':{ u:'0471', i:1063, name:'CYRILLIC SMALL LETTER PSI', cat:c.Ll,   canon:k._0, block:b[8]},
			'0472':{ u:'0472', i:1064, name:'CYRILLIC CAPITAL LETTER FITA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0473':{ u:'0473', i:1065, name:'CYRILLIC SMALL LETTER FITA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0474':{ u:'0474', i:1066, name:'CYRILLIC CAPITAL LETTER IZHITSA', cat:c.Lu,  relatives:['0476'],  canon:k._0, block:b[8]},
			'0475':{ u:'0475', i:1067, name:'CYRILLIC SMALL LETTER IZHITSA', cat:c.Ll,  relatives:['0477'],  canon:k._0, block:b[8]},
			'0476':{ u:'0476', i:1068, name:'CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT', cat:c.Lu,  relatives:['0474', '030f'], comp:['0474','030f'], canon:k._0, block:b[8]},
			'0477':{ u:'0477', i:1069, name:'CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT', cat:c.Ll,  relatives:['0475', '030f'], comp:['0475','030f'], canon:k._0, block:b[8]},
			'0478':{ u:'0478', i:1070, name:'CYRILLIC CAPITAL LETTER UK', cat:c.Lu,   canon:k._0, block:b[8]},
			'0479':{ u:'0479', i:1071, name:'CYRILLIC SMALL LETTER UK', cat:c.Ll,   canon:k._0, block:b[8]},
			'047a':{ u:'047a', i:1072, name:'CYRILLIC CAPITAL LETTER ROUND OMEGA', cat:c.Lu,   canon:k._0, block:b[8]},
			'047b':{ u:'047b', i:1073, name:'CYRILLIC SMALL LETTER ROUND OMEGA', cat:c.Ll,   canon:k._0, block:b[8]},
			'047c':{ u:'047c', i:1074, name:'CYRILLIC CAPITAL LETTER OMEGA WITH TITLO', cat:c.Lu,   canon:k._0, block:b[8]},
			'047d':{ u:'047d', i:1075, name:'CYRILLIC SMALL LETTER OMEGA WITH TITLO', cat:c.Ll,   canon:k._0, block:b[8]},
			'047e':{ u:'047e', i:1076, name:'CYRILLIC CAPITAL LETTER OT', cat:c.Lu,   canon:k._0, block:b[8]},
			'047f':{ u:'047f', i:1077, name:'CYRILLIC SMALL LETTER OT', cat:c.Ll,   canon:k._0, block:b[8]},
			'0480':{ u:'0480', i:1078, name:'CYRILLIC CAPITAL LETTER KOPPA', cat:c.Lu,   canon:k._0, block:b[8]},
			'0481':{ u:'0481', i:1079, name:'CYRILLIC SMALL LETTER KOPPA', cat:c.Ll,   canon:k._0, block:b[8]},
			'0482':{ u:'0482', i:1080, name:'CYRILLIC THOUSANDS SIGN', cat:c.So,   canon:k._0, block:b[8]},
			'0483':{ u:'0483', i:1081, name:'COMBINING CYRILLIC TITLO', cat:c.Mn,   canon:k._230, block:b[8]},
			'0484':{ u:'0484', i:1082, name:'COMBINING CYRILLIC PALATALIZATION', cat:c.Mn,   canon:k._230, block:b[8]},
			'0485':{ u:'0485', i:1083, name:'COMBINING CYRILLIC DASIA PNEUMATA', cat:c.Mn,   canon:k._230, block:b[8]},
			'0486':{ u:'0486', i:1084, name:'COMBINING CYRILLIC PSILI PNEUMATA', cat:c.Mn,   canon:k._230, block:b[8]},
			'0487':{ u:'0487', i:1085, name:'COMBINING CYRILLIC POKRYTIE', cat:c.Mn,   canon:k._230, block:b[8]},
			'0488':{ u:'0488', i:1086, name:'COMBINING CYRILLIC HUNDRED THOUSANDS SIGN', cat:c.Me,   canon:k._0, block:b[8]},
			'0489':{ u:'0489', i:1087, name:'COMBINING CYRILLIC MILLIONS SIGN', cat:c.Me,   canon:k._0, block:b[8]},
			'048a':{ u:'048a', i:1088, name:'CYRILLIC CAPITAL LETTER SHORT I WITH TAIL', cat:c.Lu,   canon:k._0, block:b[8], indexed:["I"]},
			'048b':{ u:'048b', i:1089, name:'CYRILLIC SMALL LETTER SHORT I WITH TAIL', cat:c.Ll,   canon:k._0, block:b[8], indexed:["I"]},
			'048c':{ u:'048c', i:1090, name:'CYRILLIC CAPITAL LETTER SEMISOFT SIGN', cat:c.Lu,   canon:k._0, block:b[8]},
			'048d':{ u:'048d', i:1091, name:'CYRILLIC SMALL LETTER SEMISOFT SIGN', cat:c.Ll,   canon:k._0, block:b[8]},
			'048e':{ u:'048e', i:1092, name:'CYRILLIC CAPITAL LETTER ER WITH TICK', cat:c.Lu,   canon:k._0, block:b[8]},
			'048f':{ u:'048f', i:1093, name:'CYRILLIC SMALL LETTER ER WITH TICK', cat:c.Ll,   canon:k._0, block:b[8]},
			'0490':{ u:'0490', i:1094, name:'CYRILLIC CAPITAL LETTER GHE WITH UPTURN', cat:c.Lu,   canon:k._0, block:b[8]},
			'0491':{ u:'0491', i:1095, name:'CYRILLIC SMALL LETTER GHE WITH UPTURN', cat:c.Ll,   canon:k._0, block:b[8]},
			'0492':{ u:'0492', i:1096, name:'CYRILLIC CAPITAL LETTER GHE WITH STROKE', cat:c.Lu,   canon:k._0, block:b[8]},
			'0493':{ u:'0493', i:1097, name:'CYRILLIC SMALL LETTER GHE WITH STROKE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0494':{ u:'0494', i:1098, name:'CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'0495':{ u:'0495', i:1099, name:'CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'0496':{ u:'0496', i:1100, name:'CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'0497':{ u:'0497', i:1101, name:'CYRILLIC SMALL LETTER ZHE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'0498':{ u:'0498', i:1102, name:'CYRILLIC CAPITAL LETTER ZE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'0499':{ u:'0499', i:1103, name:'CYRILLIC SMALL LETTER ZE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'049a':{ u:'049a', i:1104, name:'CYRILLIC CAPITAL LETTER KA WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'049b':{ u:'049b', i:1105, name:'CYRILLIC SMALL LETTER KA WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'049c':{ u:'049c', i:1106, name:'CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE', cat:c.Lu,   canon:k._0, block:b[8]},
			'049d':{ u:'049d', i:1107, name:'CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE', cat:c.Ll,   canon:k._0, block:b[8]},
			'049e':{ u:'049e', i:1108, name:'CYRILLIC CAPITAL LETTER KA WITH STROKE', cat:c.Lu,   canon:k._0, block:b[8]},
			'049f':{ u:'049f', i:1109, name:'CYRILLIC SMALL LETTER KA WITH STROKE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04a0':{ u:'04a0', i:1110, name:'CYRILLIC CAPITAL LETTER BASHKIR KA', cat:c.Lu,   canon:k._0, block:b[8]},
			'04a1':{ u:'04a1', i:1111, name:'CYRILLIC SMALL LETTER BASHKIR KA', cat:c.Ll,   canon:k._0, block:b[8]},
			'04a2':{ u:'04a2', i:1112, name:'CYRILLIC CAPITAL LETTER EN WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04a3':{ u:'04a3', i:1113, name:'CYRILLIC SMALL LETTER EN WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04a4':{ u:'04a4', i:1114, name:'CYRILLIC CAPITAL LIGATURE EN GHE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04a5':{ u:'04a5', i:1115, name:'CYRILLIC SMALL LIGATURE EN GHE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04a6':{ u:'04a6', i:1116, name:'CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'04a7':{ u:'04a7', i:1117, name:'CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'04a8':{ u:'04a8', i:1118, name:'CYRILLIC CAPITAL LETTER ABKHASIAN HA', cat:c.Lu,   canon:k._0, block:b[8]},
			'04a9':{ u:'04a9', i:1119, name:'CYRILLIC SMALL LETTER ABKHASIAN HA', cat:c.Ll,   canon:k._0, block:b[8]},
			'04aa':{ u:'04aa', i:1120, name:'CYRILLIC CAPITAL LETTER ES WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04ab':{ u:'04ab', i:1121, name:'CYRILLIC SMALL LETTER ES WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04ac':{ u:'04ac', i:1122, name:'CYRILLIC CAPITAL LETTER TE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04ad':{ u:'04ad', i:1123, name:'CYRILLIC SMALL LETTER TE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04ae':{ u:'04ae', i:1124, name:'CYRILLIC CAPITAL LETTER STRAIGHT U', cat:c.Lu,   canon:k._0, block:b[8], indexed:["U"]},
			'04af':{ u:'04af', i:1125, name:'CYRILLIC SMALL LETTER STRAIGHT U', cat:c.Ll,   canon:k._0, block:b[8], indexed:["U"]},
			'04b0':{ u:'04b0', i:1126, name:'CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE', cat:c.Lu,   canon:k._0, block:b[8], indexed:["U"]},
			'04b1':{ u:'04b1', i:1127, name:'CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE', cat:c.Ll,   canon:k._0, block:b[8], indexed:["U"]},
			'04b2':{ u:'04b2', i:1128, name:'CYRILLIC CAPITAL LETTER HA WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04b3':{ u:'04b3', i:1129, name:'CYRILLIC SMALL LETTER HA WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04b4':{ u:'04b4', i:1130, name:'CYRILLIC CAPITAL LIGATURE TE TSE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04b5':{ u:'04b5', i:1131, name:'CYRILLIC SMALL LIGATURE TE TSE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04b6':{ u:'04b6', i:1132, name:'CYRILLIC CAPITAL LETTER CHE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04b7':{ u:'04b7', i:1133, name:'CYRILLIC SMALL LETTER CHE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04b8':{ u:'04b8', i:1134, name:'CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04b9':{ u:'04b9', i:1135, name:'CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04ba':{ u:'04ba', i:1136, name:'CYRILLIC CAPITAL LETTER SHHA', cat:c.Lu,   canon:k._0, block:b[8]},
			'04bb':{ u:'04bb', i:1137, name:'CYRILLIC SMALL LETTER SHHA', cat:c.Ll,   canon:k._0, block:b[8]},
			'04bc':{ u:'04bc', i:1138, name:'CYRILLIC CAPITAL LETTER ABKHASIAN CHE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04bd':{ u:'04bd', i:1139, name:'CYRILLIC SMALL LETTER ABKHASIAN CHE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04be':{ u:'04be', i:1140, name:'CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04bf':{ u:'04bf', i:1141, name:'CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04c0':{ u:'04c0', i:1142, name:'CYRILLIC LETTER PALOCHKA', cat:c.Lu,   canon:k._0, block:b[8]},
			'04c1':{ u:'04c1', i:1143, name:'CYRILLIC CAPITAL LETTER ZHE WITH BREVE', cat:c.Lu,  relatives:['0416', '0306'], comp:['0416','0306'], canon:k._0, block:b[8]},
			'04c2':{ u:'04c2', i:1144, name:'CYRILLIC SMALL LETTER ZHE WITH BREVE', cat:c.Ll,  relatives:['0436', '0306'], comp:['0436','0306'], canon:k._0, block:b[8]},
			'04c3':{ u:'04c3', i:1145, name:'CYRILLIC CAPITAL LETTER KA WITH HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'04c4':{ u:'04c4', i:1146, name:'CYRILLIC SMALL LETTER KA WITH HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'04c5':{ u:'04c5', i:1147, name:'CYRILLIC CAPITAL LETTER EL WITH TAIL', cat:c.Lu,   canon:k._0, block:b[8]},
			'04c6':{ u:'04c6', i:1148, name:'CYRILLIC SMALL LETTER EL WITH TAIL', cat:c.Ll,   canon:k._0, block:b[8]},
			'04c7':{ u:'04c7', i:1149, name:'CYRILLIC CAPITAL LETTER EN WITH HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'04c8':{ u:'04c8', i:1150, name:'CYRILLIC SMALL LETTER EN WITH HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'04c9':{ u:'04c9', i:1151, name:'CYRILLIC CAPITAL LETTER EN WITH TAIL', cat:c.Lu,   canon:k._0, block:b[8]},
			'04ca':{ u:'04ca', i:1152, name:'CYRILLIC SMALL LETTER EN WITH TAIL', cat:c.Ll,   canon:k._0, block:b[8]},
			'04cb':{ u:'04cb', i:1153, name:'CYRILLIC CAPITAL LETTER KHAKASSIAN CHE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04cc':{ u:'04cc', i:1154, name:'CYRILLIC SMALL LETTER KHAKASSIAN CHE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04cd':{ u:'04cd', i:1155, name:'CYRILLIC CAPITAL LETTER EM WITH TAIL', cat:c.Lu,   canon:k._0, block:b[8]},
			'04ce':{ u:'04ce', i:1156, name:'CYRILLIC SMALL LETTER EM WITH TAIL', cat:c.Ll,   canon:k._0, block:b[8]},
			'04cf':{ u:'04cf', i:1157, name:'CYRILLIC SMALL LETTER PALOCHKA', cat:c.Ll,   canon:k._0, block:b[8]},
			'04d0':{ u:'04d0', i:1158, name:'CYRILLIC CAPITAL LETTER A WITH BREVE', cat:c.Lu,  relatives:['0410', '0306'], comp:['0410','0306'], canon:k._0, block:b[8], indexed:["A"]},
			'04d1':{ u:'04d1', i:1159, name:'CYRILLIC SMALL LETTER A WITH BREVE', cat:c.Ll,  relatives:['0430', '0306'], comp:['0430','0306'], canon:k._0, block:b[8], indexed:["A"]},
			'04d2':{ u:'04d2', i:1160, name:'CYRILLIC CAPITAL LETTER A WITH DIAERESIS', cat:c.Lu,  relatives:['0410', '0308'], comp:['0410','0308'], canon:k._0, block:b[8], indexed:["A"]},
			'04d3':{ u:'04d3', i:1161, name:'CYRILLIC SMALL LETTER A WITH DIAERESIS', cat:c.Ll,  relatives:['0430', '0308'], comp:['0430','0308'], canon:k._0, block:b[8], indexed:["A"]},
			'04d4':{ u:'04d4', i:1162, name:'CYRILLIC CAPITAL LIGATURE A IE', cat:c.Lu,   canon:k._0, block:b[8], indexed:["A"]},
			'04d5':{ u:'04d5', i:1163, name:'CYRILLIC SMALL LIGATURE A IE', cat:c.Ll,   canon:k._0, block:b[8], indexed:["A"]},
			'04d6':{ u:'04d6', i:1164, name:'CYRILLIC CAPITAL LETTER IE WITH BREVE', cat:c.Lu,  relatives:['0415', '0306'], comp:['0415','0306'], canon:k._0, block:b[8]},
			'04d7':{ u:'04d7', i:1165, name:'CYRILLIC SMALL LETTER IE WITH BREVE', cat:c.Ll,  relatives:['0435', '0306'], comp:['0435','0306'], canon:k._0, block:b[8]},
			'04d8':{ u:'04d8', i:1166, name:'CYRILLIC CAPITAL LETTER SCHWA', cat:c.Lu,  relatives:['04da'],  canon:k._0, block:b[8]},
			'04d9':{ u:'04d9', i:1167, name:'CYRILLIC SMALL LETTER SCHWA', cat:c.Ll,  relatives:['04db'],  canon:k._0, block:b[8]},
			'04da':{ u:'04da', i:1168, name:'CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS', cat:c.Lu,  relatives:['04d8', '0308'], comp:['04d8','0308'], canon:k._0, block:b[8]},
			'04db':{ u:'04db', i:1169, name:'CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS', cat:c.Ll,  relatives:['04d9', '0308'], comp:['04d9','0308'], canon:k._0, block:b[8]},
			'04dc':{ u:'04dc', i:1170, name:'CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS', cat:c.Lu,  relatives:['0416', '0308'], comp:['0416','0308'], canon:k._0, block:b[8]},
			'04dd':{ u:'04dd', i:1171, name:'CYRILLIC SMALL LETTER ZHE WITH DIAERESIS', cat:c.Ll,  relatives:['0436', '0308'], comp:['0436','0308'], canon:k._0, block:b[8]},
			'04de':{ u:'04de', i:1172, name:'CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS', cat:c.Lu,  relatives:['0417', '0308'], comp:['0417','0308'], canon:k._0, block:b[8]},
			'04df':{ u:'04df', i:1173, name:'CYRILLIC SMALL LETTER ZE WITH DIAERESIS', cat:c.Ll,  relatives:['0437', '0308'], comp:['0437','0308'], canon:k._0, block:b[8]},
			'04e0':{ u:'04e0', i:1174, name:'CYRILLIC CAPITAL LETTER ABKHASIAN DZE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04e1':{ u:'04e1', i:1175, name:'CYRILLIC SMALL LETTER ABKHASIAN DZE', cat:c.Ll,   canon:k._0, block:b[8]},
			'04e2':{ u:'04e2', i:1176, name:'CYRILLIC CAPITAL LETTER I WITH MACRON', cat:c.Lu,  relatives:['0418', '0304'], comp:['0418','0304'], canon:k._0, block:b[8], indexed:["I"]},
			'04e3':{ u:'04e3', i:1177, name:'CYRILLIC SMALL LETTER I WITH MACRON', cat:c.Ll,  relatives:['0438', '0304'], comp:['0438','0304'], canon:k._0, block:b[8], indexed:["I"]},
			'04e4':{ u:'04e4', i:1178, name:'CYRILLIC CAPITAL LETTER I WITH DIAERESIS', cat:c.Lu,  relatives:['0418', '0308'], comp:['0418','0308'], canon:k._0, block:b[8], indexed:["I"]},
			'04e5':{ u:'04e5', i:1179, name:'CYRILLIC SMALL LETTER I WITH DIAERESIS', cat:c.Ll,  relatives:['0438', '0308'], comp:['0438','0308'], canon:k._0, block:b[8], indexed:["I"]},
			'04e6':{ u:'04e6', i:1180, name:'CYRILLIC CAPITAL LETTER O WITH DIAERESIS', cat:c.Lu,  relatives:['041e', '0308'], comp:['041e','0308'], canon:k._0, block:b[8], indexed:["O"]},
			'04e7':{ u:'04e7', i:1181, name:'CYRILLIC SMALL LETTER O WITH DIAERESIS', cat:c.Ll,  relatives:['043e', '0308'], comp:['043e','0308'], canon:k._0, block:b[8], indexed:["O"]},
			'04e8':{ u:'04e8', i:1182, name:'CYRILLIC CAPITAL LETTER BARRED O', cat:c.Lu,  relatives:['04ea'],  canon:k._0, block:b[8], indexed:["O"]},
			'04e9':{ u:'04e9', i:1183, name:'CYRILLIC SMALL LETTER BARRED O', cat:c.Ll,  relatives:['04eb'],  canon:k._0, block:b[8], indexed:["O"]},
			'04ea':{ u:'04ea', i:1184, name:'CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS', cat:c.Lu,  relatives:['04e8', '0308'], comp:['04e8','0308'], canon:k._0, block:b[8], indexed:["O"]},
			'04eb':{ u:'04eb', i:1185, name:'CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS', cat:c.Ll,  relatives:['04e9', '0308'], comp:['04e9','0308'], canon:k._0, block:b[8], indexed:["O"]},
			'04ec':{ u:'04ec', i:1186, name:'CYRILLIC CAPITAL LETTER E WITH DIAERESIS', cat:c.Lu,  relatives:['042d', '0308'], comp:['042d','0308'], canon:k._0, block:b[8], indexed:["E"]},
			'04ed':{ u:'04ed', i:1187, name:'CYRILLIC SMALL LETTER E WITH DIAERESIS', cat:c.Ll,  relatives:['044d', '0308'], comp:['044d','0308'], canon:k._0, block:b[8], indexed:["E"]},
			'04ee':{ u:'04ee', i:1188, name:'CYRILLIC CAPITAL LETTER U WITH MACRON', cat:c.Lu,  relatives:['0423', '0304'], comp:['0423','0304'], canon:k._0, block:b[8], indexed:["U"]},
			'04ef':{ u:'04ef', i:1189, name:'CYRILLIC SMALL LETTER U WITH MACRON', cat:c.Ll,  relatives:['0443', '0304'], comp:['0443','0304'], canon:k._0, block:b[8], indexed:["U"]},
			'04f0':{ u:'04f0', i:1190, name:'CYRILLIC CAPITAL LETTER U WITH DIAERESIS', cat:c.Lu,  relatives:['0423', '0308'], comp:['0423','0308'], canon:k._0, block:b[8], indexed:["U"]},
			'04f1':{ u:'04f1', i:1191, name:'CYRILLIC SMALL LETTER U WITH DIAERESIS', cat:c.Ll,  relatives:['0443', '0308'], comp:['0443','0308'], canon:k._0, block:b[8], indexed:["U"]},
			'04f2':{ u:'04f2', i:1192, name:'CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE', cat:c.Lu,  relatives:['0423', '030b'], comp:['0423','030b'], canon:k._0, block:b[8], indexed:["U"]},
			'04f3':{ u:'04f3', i:1193, name:'CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE', cat:c.Ll,  relatives:['0443', '030b'], comp:['0443','030b'], canon:k._0, block:b[8], indexed:["U"]},
			'04f4':{ u:'04f4', i:1194, name:'CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS', cat:c.Lu,  relatives:['0427', '0308'], comp:['0427','0308'], canon:k._0, block:b[8]},
			'04f5':{ u:'04f5', i:1195, name:'CYRILLIC SMALL LETTER CHE WITH DIAERESIS', cat:c.Ll,  relatives:['0447', '0308'], comp:['0447','0308'], canon:k._0, block:b[8]},
			'04f6':{ u:'04f6', i:1196, name:'CYRILLIC CAPITAL LETTER GHE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[8]},
			'04f7':{ u:'04f7', i:1197, name:'CYRILLIC SMALL LETTER GHE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[8]},
			'04f8':{ u:'04f8', i:1198, name:'CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS', cat:c.Lu,  relatives:['042b', '0308'], comp:['042b','0308'], canon:k._0, block:b[8]},
			'04f9':{ u:'04f9', i:1199, name:'CYRILLIC SMALL LETTER YERU WITH DIAERESIS', cat:c.Ll,  relatives:['044b', '0308'], comp:['044b','0308'], canon:k._0, block:b[8]},
			'04fa':{ u:'04fa', i:1200, name:'CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'04fb':{ u:'04fb', i:1201, name:'CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'04fc':{ u:'04fc', i:1202, name:'CYRILLIC CAPITAL LETTER HA WITH HOOK', cat:c.Lu,   canon:k._0, block:b[8]},
			'04fd':{ u:'04fd', i:1203, name:'CYRILLIC SMALL LETTER HA WITH HOOK', cat:c.Ll,   canon:k._0, block:b[8]},
			'04fe':{ u:'04fe', i:1204, name:'CYRILLIC CAPITAL LETTER HA WITH STROKE', cat:c.Lu,   canon:k._0, block:b[8]},
			'04ff':{ u:'04ff', i:1205, name:'CYRILLIC SMALL LETTER HA WITH STROKE', cat:c.Ll,   canon:k._0, block:b[8]},
			'0500':{ u:'0500', i:1206, name:'CYRILLIC CAPITAL LETTER KOMI DE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0501':{ u:'0501', i:1207, name:'CYRILLIC SMALL LETTER KOMI DE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0502':{ u:'0502', i:1208, name:'CYRILLIC CAPITAL LETTER KOMI DJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0503':{ u:'0503', i:1209, name:'CYRILLIC SMALL LETTER KOMI DJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0504':{ u:'0504', i:1210, name:'CYRILLIC CAPITAL LETTER KOMI ZJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0505':{ u:'0505', i:1211, name:'CYRILLIC SMALL LETTER KOMI ZJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0506':{ u:'0506', i:1212, name:'CYRILLIC CAPITAL LETTER KOMI DZJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0507':{ u:'0507', i:1213, name:'CYRILLIC SMALL LETTER KOMI DZJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0508':{ u:'0508', i:1214, name:'CYRILLIC CAPITAL LETTER KOMI LJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0509':{ u:'0509', i:1215, name:'CYRILLIC SMALL LETTER KOMI LJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'050a':{ u:'050a', i:1216, name:'CYRILLIC CAPITAL LETTER KOMI NJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'050b':{ u:'050b', i:1217, name:'CYRILLIC SMALL LETTER KOMI NJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'050c':{ u:'050c', i:1218, name:'CYRILLIC CAPITAL LETTER KOMI SJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'050d':{ u:'050d', i:1219, name:'CYRILLIC SMALL LETTER KOMI SJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'050e':{ u:'050e', i:1220, name:'CYRILLIC CAPITAL LETTER KOMI TJE', cat:c.Lu,   canon:k._0, block:b[9]},
			'050f':{ u:'050f', i:1221, name:'CYRILLIC SMALL LETTER KOMI TJE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0510':{ u:'0510', i:1222, name:'CYRILLIC CAPITAL LETTER REVERSED ZE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0511':{ u:'0511', i:1223, name:'CYRILLIC SMALL LETTER REVERSED ZE', cat:c.Ll,   canon:k._0, block:b[9]},
			'0512':{ u:'0512', i:1224, name:'CYRILLIC CAPITAL LETTER EL WITH HOOK', cat:c.Lu,   canon:k._0, block:b[9]},
			'0513':{ u:'0513', i:1225, name:'CYRILLIC SMALL LETTER EL WITH HOOK', cat:c.Ll,   canon:k._0, block:b[9]},
			'0514':{ u:'0514', i:1226, name:'CYRILLIC CAPITAL LETTER LHA', cat:c.Lu,   canon:k._0, block:b[9]},
			'0515':{ u:'0515', i:1227, name:'CYRILLIC SMALL LETTER LHA', cat:c.Ll,   canon:k._0, block:b[9]},
			'0516':{ u:'0516', i:1228, name:'CYRILLIC CAPITAL LETTER RHA', cat:c.Lu,   canon:k._0, block:b[9]},
			'0517':{ u:'0517', i:1229, name:'CYRILLIC SMALL LETTER RHA', cat:c.Ll,   canon:k._0, block:b[9]},
			'0518':{ u:'0518', i:1230, name:'CYRILLIC CAPITAL LETTER YAE', cat:c.Lu,   canon:k._0, block:b[9]},
			'0519':{ u:'0519', i:1231, name:'CYRILLIC SMALL LETTER YAE', cat:c.Ll,   canon:k._0, block:b[9]},
			'051a':{ u:'051a', i:1232, name:'CYRILLIC CAPITAL LETTER QA', cat:c.Lu,   canon:k._0, block:b[9]},
			'051b':{ u:'051b', i:1233, name:'CYRILLIC SMALL LETTER QA', cat:c.Ll,   canon:k._0, block:b[9]},
			'051c':{ u:'051c', i:1234, name:'CYRILLIC CAPITAL LETTER WE', cat:c.Lu,   canon:k._0, block:b[9]},
			'051d':{ u:'051d', i:1235, name:'CYRILLIC SMALL LETTER WE', cat:c.Ll,   canon:k._0, block:b[9]},
			'051e':{ u:'051e', i:1236, name:'CYRILLIC CAPITAL LETTER ALEUT KA', cat:c.Lu,   canon:k._0, block:b[9]},
			'051f':{ u:'051f', i:1237, name:'CYRILLIC SMALL LETTER ALEUT KA', cat:c.Ll,   canon:k._0, block:b[9]},
			'0520':{ u:'0520', i:1238, name:'CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK', cat:c.Lu,   canon:k._0, block:b[9]},
			'0521':{ u:'0521', i:1239, name:'CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK', cat:c.Ll,   canon:k._0, block:b[9]},
			'0522':{ u:'0522', i:1240, name:'CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK', cat:c.Lu,   canon:k._0, block:b[9]},
			'0523':{ u:'0523', i:1241, name:'CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK', cat:c.Ll,   canon:k._0, block:b[9]},
			'0524':{ u:'0524', i:1242, name:'CYRILLIC CAPITAL LETTER PE WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[9]},
			'0525':{ u:'0525', i:1243, name:'CYRILLIC SMALL LETTER PE WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[9]},
			'0526':{ u:'0526', i:1244, name:'CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[9]},
			'0527':{ u:'0527', i:1245, name:'CYRILLIC SMALL LETTER SHHA WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[9]},
			'0528':{ u:'0528', i:1246, name:'CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK', cat:c.Lu,   canon:k._0, block:b[9]},
			'0529':{ u:'0529', i:1247, name:'CYRILLIC SMALL LETTER EN WITH LEFT HOOK', cat:c.Ll,   canon:k._0, block:b[9]},
			'052a':{ u:'052a', i:1248, name:'CYRILLIC CAPITAL LETTER DZZHE', cat:c.Lu,   canon:k._0, block:b[9]},
			'052b':{ u:'052b', i:1249, name:'CYRILLIC SMALL LETTER DZZHE', cat:c.Ll,   canon:k._0, block:b[9]},
			'052c':{ u:'052c', i:1250, name:'CYRILLIC CAPITAL LETTER DCHE', cat:c.Lu,   canon:k._0, block:b[9]},
			'052d':{ u:'052d', i:1251, name:'CYRILLIC SMALL LETTER DCHE', cat:c.Ll,   canon:k._0, block:b[9]},
			'052e':{ u:'052e', i:1252, name:'CYRILLIC CAPITAL LETTER EL WITH DESCENDER', cat:c.Lu,   canon:k._0, block:b[9]},
			'052f':{ u:'052f', i:1253, name:'CYRILLIC SMALL LETTER EL WITH DESCENDER', cat:c.Ll,   canon:k._0, block:b[9]},
			'0531':{ u:'0531', i:1254, name:'ARMENIAN CAPITAL LETTER AYB', cat:c.Lu,   canon:k._0, block:b[10]},
			'0532':{ u:'0532', i:1255, name:'ARMENIAN CAPITAL LETTER BEN', cat:c.Lu,   canon:k._0, block:b[10]},
			'0533':{ u:'0533', i:1256, name:'ARMENIAN CAPITAL LETTER GIM', cat:c.Lu,   canon:k._0, block:b[10]},
			'0534':{ u:'0534', i:1257, name:'ARMENIAN CAPITAL LETTER DA', cat:c.Lu,   canon:k._0, block:b[10]},
			'0535':{ u:'0535', i:1258, name:'ARMENIAN CAPITAL LETTER ECH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0536':{ u:'0536', i:1259, name:'ARMENIAN CAPITAL LETTER ZA', cat:c.Lu,   canon:k._0, block:b[10]},
			'0537':{ u:'0537', i:1260, name:'ARMENIAN CAPITAL LETTER EH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0538':{ u:'0538', i:1261, name:'ARMENIAN CAPITAL LETTER ET', cat:c.Lu,   canon:k._0, block:b[10]},
			'0539':{ u:'0539', i:1262, name:'ARMENIAN CAPITAL LETTER TO', cat:c.Lu,   canon:k._0, block:b[10]},
			'053a':{ u:'053a', i:1263, name:'ARMENIAN CAPITAL LETTER ZHE', cat:c.Lu,   canon:k._0, block:b[10]},
			'053b':{ u:'053b', i:1264, name:'ARMENIAN CAPITAL LETTER INI', cat:c.Lu,   canon:k._0, block:b[10]},
			'053c':{ u:'053c', i:1265, name:'ARMENIAN CAPITAL LETTER LIWN', cat:c.Lu,   canon:k._0, block:b[10]},
			'053d':{ u:'053d', i:1266, name:'ARMENIAN CAPITAL LETTER XEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'053e':{ u:'053e', i:1267, name:'ARMENIAN CAPITAL LETTER CA', cat:c.Lu,   canon:k._0, block:b[10]},
			'053f':{ u:'053f', i:1268, name:'ARMENIAN CAPITAL LETTER KEN', cat:c.Lu,   canon:k._0, block:b[10]},
			'0540':{ u:'0540', i:1269, name:'ARMENIAN CAPITAL LETTER HO', cat:c.Lu,   canon:k._0, block:b[10]},
			'0541':{ u:'0541', i:1270, name:'ARMENIAN CAPITAL LETTER JA', cat:c.Lu,   canon:k._0, block:b[10]},
			'0542':{ u:'0542', i:1271, name:'ARMENIAN CAPITAL LETTER GHAD', cat:c.Lu,   canon:k._0, block:b[10]},
			'0543':{ u:'0543', i:1272, name:'ARMENIAN CAPITAL LETTER CHEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0544':{ u:'0544', i:1273, name:'ARMENIAN CAPITAL LETTER MEN', cat:c.Lu,   canon:k._0, block:b[10]},
			'0545':{ u:'0545', i:1274, name:'ARMENIAN CAPITAL LETTER YI', cat:c.Lu,   canon:k._0, block:b[10]},
			'0546':{ u:'0546', i:1275, name:'ARMENIAN CAPITAL LETTER NOW', cat:c.Lu,   canon:k._0, block:b[10]},
			'0547':{ u:'0547', i:1276, name:'ARMENIAN CAPITAL LETTER SHA', cat:c.Lu,   canon:k._0, block:b[10]},
			'0548':{ u:'0548', i:1277, name:'ARMENIAN CAPITAL LETTER VO', cat:c.Lu,   canon:k._0, block:b[10]},
			'0549':{ u:'0549', i:1278, name:'ARMENIAN CAPITAL LETTER CHA', cat:c.Lu,   canon:k._0, block:b[10]},
			'054a':{ u:'054a', i:1279, name:'ARMENIAN CAPITAL LETTER PEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'054b':{ u:'054b', i:1280, name:'ARMENIAN CAPITAL LETTER JHEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'054c':{ u:'054c', i:1281, name:'ARMENIAN CAPITAL LETTER RA', cat:c.Lu,   canon:k._0, block:b[10]},
			'054d':{ u:'054d', i:1282, name:'ARMENIAN CAPITAL LETTER SEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'054e':{ u:'054e', i:1283, name:'ARMENIAN CAPITAL LETTER VEW', cat:c.Lu,   canon:k._0, block:b[10]},
			'054f':{ u:'054f', i:1284, name:'ARMENIAN CAPITAL LETTER TIWN', cat:c.Lu,   canon:k._0, block:b[10]},
			'0550':{ u:'0550', i:1285, name:'ARMENIAN CAPITAL LETTER REH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0551':{ u:'0551', i:1286, name:'ARMENIAN CAPITAL LETTER CO', cat:c.Lu,   canon:k._0, block:b[10]},
			'0552':{ u:'0552', i:1287, name:'ARMENIAN CAPITAL LETTER YIWN', cat:c.Lu,   canon:k._0, block:b[10]},
			'0553':{ u:'0553', i:1288, name:'ARMENIAN CAPITAL LETTER PIWR', cat:c.Lu,   canon:k._0, block:b[10]},
			'0554':{ u:'0554', i:1289, name:'ARMENIAN CAPITAL LETTER KEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0555':{ u:'0555', i:1290, name:'ARMENIAN CAPITAL LETTER OH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0556':{ u:'0556', i:1291, name:'ARMENIAN CAPITAL LETTER FEH', cat:c.Lu,   canon:k._0, block:b[10]},
			'0559':{ u:'0559', i:1292, name:'ARMENIAN MODIFIER LETTER LEFT HALF RING', cat:c.Lm,   canon:k._0, block:b[10]},
			'055a':{ u:'055a', i:1293, name:'ARMENIAN APOSTROPHE', cat:c.Po,   canon:k._0, block:b[10]},
			'055b':{ u:'055b', i:1294, name:'ARMENIAN EMPHASIS MARK', cat:c.Po,   canon:k._0, block:b[10]},
			'055c':{ u:'055c', i:1295, name:'ARMENIAN EXCLAMATION MARK', cat:c.Po,   canon:k._0, block:b[10]},
			'055d':{ u:'055d', i:1296, name:'ARMENIAN COMMA', cat:c.Po,   canon:k._0, block:b[10]},
			'055e':{ u:'055e', i:1297, name:'ARMENIAN QUESTION MARK', cat:c.Po,   canon:k._0, block:b[10]},
			'055f':{ u:'055f', i:1298, name:'ARMENIAN ABBREVIATION MARK', cat:c.Po,   canon:k._0, block:b[10]},
			'0560':{ u:'0560', i:1299, name:'ARMENIAN SMALL LETTER TURNED AYB', cat:c.Ll,   canon:k._0, block:b[10]},
			'0561':{ u:'0561', i:1300, name:'ARMENIAN SMALL LETTER AYB', cat:c.Ll,   canon:k._0, block:b[10]},
			'0562':{ u:'0562', i:1301, name:'ARMENIAN SMALL LETTER BEN', cat:c.Ll,   canon:k._0, block:b[10]},
			'0563':{ u:'0563', i:1302, name:'ARMENIAN SMALL LETTER GIM', cat:c.Ll,   canon:k._0, block:b[10]},
			'0564':{ u:'0564', i:1303, name:'ARMENIAN SMALL LETTER DA', cat:c.Ll,   canon:k._0, block:b[10]},
			'0565':{ u:'0565', i:1304, name:'ARMENIAN SMALL LETTER ECH', cat:c.Ll,  relatives:['0587', 'fb14'],  canon:k._0, block:b[10]},
			'0566':{ u:'0566', i:1305, name:'ARMENIAN SMALL LETTER ZA', cat:c.Ll,   canon:k._0, block:b[10]},
			'0567':{ u:'0567', i:1306, name:'ARMENIAN SMALL LETTER EH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0568':{ u:'0568', i:1307, name:'ARMENIAN SMALL LETTER ET', cat:c.Ll,   canon:k._0, block:b[10]},
			'0569':{ u:'0569', i:1308, name:'ARMENIAN SMALL LETTER TO', cat:c.Ll,   canon:k._0, block:b[10]},
			'056a':{ u:'056a', i:1309, name:'ARMENIAN SMALL LETTER ZHE', cat:c.Ll,   canon:k._0, block:b[10]},
			'056b':{ u:'056b', i:1310, name:'ARMENIAN SMALL LETTER INI', cat:c.Ll,  relatives:['fb15'],  canon:k._0, block:b[10]},
			'056c':{ u:'056c', i:1311, name:'ARMENIAN SMALL LETTER LIWN', cat:c.Ll,   canon:k._0, block:b[10]},
			'056d':{ u:'056d', i:1312, name:'ARMENIAN SMALL LETTER XEH', cat:c.Ll,  relatives:['fb17'],  canon:k._0, block:b[10]},
			'056e':{ u:'056e', i:1313, name:'ARMENIAN SMALL LETTER CA', cat:c.Ll,   canon:k._0, block:b[10]},
			'056f':{ u:'056f', i:1314, name:'ARMENIAN SMALL LETTER KEN', cat:c.Ll,   canon:k._0, block:b[10]},
			'0570':{ u:'0570', i:1315, name:'ARMENIAN SMALL LETTER HO', cat:c.Ll,   canon:k._0, block:b[10]},
			'0571':{ u:'0571', i:1316, name:'ARMENIAN SMALL LETTER JA', cat:c.Ll,   canon:k._0, block:b[10]},
			'0572':{ u:'0572', i:1317, name:'ARMENIAN SMALL LETTER GHAD', cat:c.Ll,   canon:k._0, block:b[10]},
			'0573':{ u:'0573', i:1318, name:'ARMENIAN SMALL LETTER CHEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0574':{ u:'0574', i:1319, name:'ARMENIAN SMALL LETTER MEN', cat:c.Ll,  relatives:['fb13', 'fb14', 'fb15', 'fb17'],  canon:k._0, block:b[10]},
			'0575':{ u:'0575', i:1320, name:'ARMENIAN SMALL LETTER YI', cat:c.Ll,   canon:k._0, block:b[10]},
			'0576':{ u:'0576', i:1321, name:'ARMENIAN SMALL LETTER NOW', cat:c.Ll,  relatives:['fb13', 'fb16'],  canon:k._0, block:b[10]},
			'0577':{ u:'0577', i:1322, name:'ARMENIAN SMALL LETTER SHA', cat:c.Ll,   canon:k._0, block:b[10]},
			'0578':{ u:'0578', i:1323, name:'ARMENIAN SMALL LETTER VO', cat:c.Ll,   canon:k._0, block:b[10]},
			'0579':{ u:'0579', i:1324, name:'ARMENIAN SMALL LETTER CHA', cat:c.Ll,   canon:k._0, block:b[10]},
			'057a':{ u:'057a', i:1325, name:'ARMENIAN SMALL LETTER PEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'057b':{ u:'057b', i:1326, name:'ARMENIAN SMALL LETTER JHEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'057c':{ u:'057c', i:1327, name:'ARMENIAN SMALL LETTER RA', cat:c.Ll,   canon:k._0, block:b[10]},
			'057d':{ u:'057d', i:1328, name:'ARMENIAN SMALL LETTER SEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'057e':{ u:'057e', i:1329, name:'ARMENIAN SMALL LETTER VEW', cat:c.Ll,  relatives:['fb16'],  canon:k._0, block:b[10]},
			'057f':{ u:'057f', i:1330, name:'ARMENIAN SMALL LETTER TIWN', cat:c.Ll,   canon:k._0, block:b[10]},
			'0580':{ u:'0580', i:1331, name:'ARMENIAN SMALL LETTER REH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0581':{ u:'0581', i:1332, name:'ARMENIAN SMALL LETTER CO', cat:c.Ll,   canon:k._0, block:b[10]},
			'0582':{ u:'0582', i:1333, name:'ARMENIAN SMALL LETTER YIWN', cat:c.Ll,  relatives:['0587'],  canon:k._0, block:b[10]},
			'0583':{ u:'0583', i:1334, name:'ARMENIAN SMALL LETTER PIWR', cat:c.Ll,   canon:k._0, block:b[10]},
			'0584':{ u:'0584', i:1335, name:'ARMENIAN SMALL LETTER KEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0585':{ u:'0585', i:1336, name:'ARMENIAN SMALL LETTER OH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0586':{ u:'0586', i:1337, name:'ARMENIAN SMALL LETTER FEH', cat:c.Ll,   canon:k._0, block:b[10]},
			'0587':{ u:'0587', i:1338, name:'ARMENIAN SMALL LIGATURE ECH YIWN', cat:c.Ll,  relatives:['0565', '0582'], comp:['0565','0582'], canon:k._0, block:b[10]},
			'0588':{ u:'0588', i:1339, name:'ARMENIAN SMALL LETTER YI WITH STROKE', cat:c.Ll,   canon:k._0, block:b[10]},
			'0589':{ u:'0589', i:1340, name:'ARMENIAN FULL STOP', cat:c.Po,   canon:k._0, block:b[10]},
			'058a':{ u:'058a', i:1341, name:'ARMENIAN HYPHEN', cat:c.Pd,   canon:k._0, block:b[10]},
			'058d':{ u:'058d', i:1342, name:'RIGHT-FACING ARMENIAN ETERNITY SIGN', cat:c.So,   canon:k._0, block:b[10]},
			'058e':{ u:'058e', i:1343, name:'LEFT-FACING ARMENIAN ETERNITY SIGN', cat:c.So,   canon:k._0, block:b[10]},
			'058f':{ u:'058f', i:1344, name:'ARMENIAN DRAM SIGN', cat:c.Sc,   canon:k._0, block:b[10]},
			'0591':{ u:'0591', i:1345, name:'HEBREW ACCENT ETNAHTA', cat:c.Mn,   canon:k._220, block:b[11]},
			'0592':{ u:'0592', i:1346, name:'HEBREW ACCENT SEGOL', cat:c.Mn,   canon:k._230, block:b[11]},
			'0593':{ u:'0593', i:1347, name:'HEBREW ACCENT SHALSHELET', cat:c.Mn,   canon:k._230, block:b[11]},
			'0594':{ u:'0594', i:1348, name:'HEBREW ACCENT ZAQEF QATAN', cat:c.Mn,   canon:k._230, block:b[11]},
			'0595':{ u:'0595', i:1349, name:'HEBREW ACCENT ZAQEF GADOL', cat:c.Mn,   canon:k._230, block:b[11]},
			'0596':{ u:'0596', i:1350, name:'HEBREW ACCENT TIPEHA', cat:c.Mn,   canon:k._220, block:b[11]},
			'0597':{ u:'0597', i:1351, name:'HEBREW ACCENT REVIA', cat:c.Mn,   canon:k._230, block:b[11]},
			'0598':{ u:'0598', i:1352, name:'HEBREW ACCENT ZARQA', cat:c.Mn,   canon:k._230, block:b[11]},
			'0599':{ u:'0599', i:1353, name:'HEBREW ACCENT PASHTA', cat:c.Mn,   canon:k._230, block:b[11]},
			'059a':{ u:'059a', i:1354, name:'HEBREW ACCENT YETIV', cat:c.Mn,   canon:k._222, block:b[11]},
			'059b':{ u:'059b', i:1355, name:'HEBREW ACCENT TEVIR', cat:c.Mn,   canon:k._220, block:b[11]},
			'059c':{ u:'059c', i:1356, name:'HEBREW ACCENT GERESH', cat:c.Mn,   canon:k._230, block:b[11]},
			'059d':{ u:'059d', i:1357, name:'HEBREW ACCENT GERESH MUQDAM', cat:c.Mn,   canon:k._230, block:b[11]},
			'059e':{ u:'059e', i:1358, name:'HEBREW ACCENT GERSHAYIM', cat:c.Mn,   canon:k._230, block:b[11]},
			'059f':{ u:'059f', i:1359, name:'HEBREW ACCENT QARNEY PARA', cat:c.Mn,   canon:k._230, block:b[11]},
			'05a0':{ u:'05a0', i:1360, name:'HEBREW ACCENT TELISHA GEDOLA', cat:c.Mn,   canon:k._230, block:b[11]},
			'05a1':{ u:'05a1', i:1361, name:'HEBREW ACCENT PAZER', cat:c.Mn,   canon:k._230, block:b[11]},
			'05a2':{ u:'05a2', i:1362, name:'HEBREW ACCENT ATNAH HAFUKH', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a3':{ u:'05a3', i:1363, name:'HEBREW ACCENT MUNAH', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a4':{ u:'05a4', i:1364, name:'HEBREW ACCENT MAHAPAKH', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a5':{ u:'05a5', i:1365, name:'HEBREW ACCENT MERKHA', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a6':{ u:'05a6', i:1366, name:'HEBREW ACCENT MERKHA KEFULA', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a7':{ u:'05a7', i:1367, name:'HEBREW ACCENT DARGA', cat:c.Mn,   canon:k._220, block:b[11]},
			'05a8':{ u:'05a8', i:1368, name:'HEBREW ACCENT QADMA', cat:c.Mn,   canon:k._230, block:b[11]},
			'05a9':{ u:'05a9', i:1369, name:'HEBREW ACCENT TELISHA QETANA', cat:c.Mn,   canon:k._230, block:b[11]},
			'05aa':{ u:'05aa', i:1370, name:'HEBREW ACCENT YERAH BEN YOMO', cat:c.Mn,   canon:k._220, block:b[11]},
			'05ab':{ u:'05ab', i:1371, name:'HEBREW ACCENT OLE', cat:c.Mn,   canon:k._230, block:b[11]},
			'05ac':{ u:'05ac', i:1372, name:'HEBREW ACCENT ILUY', cat:c.Mn,   canon:k._230, block:b[11]},
			'05ad':{ u:'05ad', i:1373, name:'HEBREW ACCENT DEHI', cat:c.Mn,   canon:k._222, block:b[11]},
			'05ae':{ u:'05ae', i:1374, name:'HEBREW ACCENT ZINOR', cat:c.Mn,   canon:k._228, block:b[11]},
			'05af':{ u:'05af', i:1375, name:'HEBREW MARK MASORA CIRCLE', cat:c.Mn,   canon:k._230, block:b[11]},
			'05b0':{ u:'05b0', i:1376, name:'HEBREW POINT SHEVA', cat:c.Mn,   canon:k._10, block:b[11]},
			'05b1':{ u:'05b1', i:1377, name:'HEBREW POINT HATAF SEGOL', cat:c.Mn,   canon:k._11, block:b[11]},
			'05b2':{ u:'05b2', i:1378, name:'HEBREW POINT HATAF PATAH', cat:c.Mn,   canon:k._12, block:b[11]},
			'05b3':{ u:'05b3', i:1379, name:'HEBREW POINT HATAF QAMATS', cat:c.Mn,   canon:k._13, block:b[11]},
			'05b4':{ u:'05b4', i:1380, name:'HEBREW POINT HIRIQ', cat:c.Mn,  relatives:['fb1d'],  canon:k._14, block:b[11]},
			'05b5':{ u:'05b5', i:1381, name:'HEBREW POINT TSERE', cat:c.Mn,   canon:k._15, block:b[11]},
			'05b6':{ u:'05b6', i:1382, name:'HEBREW POINT SEGOL', cat:c.Mn,   canon:k._16, block:b[11]},
			'05b7':{ u:'05b7', i:1383, name:'HEBREW POINT PATAH', cat:c.Mn,  relatives:['fb1f', 'fb2e'],  canon:k._17, block:b[11]},
			'05b8':{ u:'05b8', i:1384, name:'HEBREW POINT QAMATS', cat:c.Mn,  relatives:['fb2f'],  canon:k._18, block:b[11]},
			'05b9':{ u:'05b9', i:1385, name:'HEBREW POINT HOLAM', cat:c.Mn,  relatives:['fb4b'],  canon:k._19, block:b[11]},
			'05ba':{ u:'05ba', i:1386, name:'HEBREW POINT HOLAM HASER FOR VAV', cat:c.Mn,   canon:k._19, block:b[11]},
			'05bb':{ u:'05bb', i:1387, name:'HEBREW POINT QUBUTS', cat:c.Mn,   canon:k._20, block:b[11]},
			'05bc':{ u:'05bc', i:1388, name:'HEBREW POINT DAGESH OR MAPIQ', cat:c.Mn,  relatives:['fb30', 'fb31', 'fb32', 'fb33', 'fb34', 'fb35', 'fb36', 'fb38', 'fb39', 'fb3a', 'fb3b', 'fb3c', 'fb3e', 'fb40', 'fb41', 'fb43', 'fb44', 'fb46', 'fb47', 'fb48', 'fb49', 'fb4a'],  canon:k._21, block:b[11]},
			'05bd':{ u:'05bd', i:1389, name:'HEBREW POINT METEG', cat:c.Mn,   canon:k._22, block:b[11]},
			'05be':{ u:'05be', i:1390, name:'HEBREW PUNCTUATION MAQAF', cat:c.Pd,   canon:k._0, block:b[11]},
			'05bf':{ u:'05bf', i:1391, name:'HEBREW POINT RAFE', cat:c.Mn,  relatives:['fb4c', 'fb4d', 'fb4e'],  canon:k._23, block:b[11]},
			'05c0':{ u:'05c0', i:1392, name:'HEBREW PUNCTUATION PASEQ', cat:c.Po,   canon:k._0, block:b[11]},
			'05c1':{ u:'05c1', i:1393, name:'HEBREW POINT SHIN DOT', cat:c.Mn,  relatives:['fb2a', 'fb2c'],  canon:k._24, block:b[11]},
			'05c2':{ u:'05c2', i:1394, name:'HEBREW POINT SIN DOT', cat:c.Mn,  relatives:['fb2b', 'fb2d'],  canon:k._25, block:b[11]},
			'05c3':{ u:'05c3', i:1395, name:'HEBREW PUNCTUATION SOF PASUQ', cat:c.Po,   canon:k._0, block:b[11]},
			'05c4':{ u:'05c4', i:1396, name:'HEBREW MARK UPPER DOT', cat:c.Mn,   canon:k._230, block:b[11]},
			'05c5':{ u:'05c5', i:1397, name:'HEBREW MARK LOWER DOT', cat:c.Mn,   canon:k._220, block:b[11]},
			'05c6':{ u:'05c6', i:1398, name:'HEBREW PUNCTUATION NUN HAFUKHA', cat:c.Po,   canon:k._0, block:b[11]},
			'05c7':{ u:'05c7', i:1399, name:'HEBREW POINT QAMATS QATAN', cat:c.Mn,   canon:k._18, block:b[11]},
			'05d0':{ u:'05d0', i:1400, name:'HEBREW LETTER ALEF', cat:c.Lo,  relatives:['2135', 'fb21', 'fb2e', 'fb2f', 'fb30', 'fb4f'],  canon:k._0, block:b[11]},
			'05d1':{ u:'05d1', i:1401, name:'HEBREW LETTER BET', cat:c.Lo,  relatives:['2136', 'fb31', 'fb4c'],  canon:k._0, block:b[11]},
			'05d2':{ u:'05d2', i:1402, name:'HEBREW LETTER GIMEL', cat:c.Lo,  relatives:['2137', 'fb32'],  canon:k._0, block:b[11]},
			'05d3':{ u:'05d3', i:1403, name:'HEBREW LETTER DALET', cat:c.Lo,  relatives:['2138', 'fb22', 'fb33'],  canon:k._0, block:b[11]},
			'05d4':{ u:'05d4', i:1404, name:'HEBREW LETTER HE', cat:c.Lo,  relatives:['fb23', 'fb34'],  canon:k._0, block:b[11]},
			'05d5':{ u:'05d5', i:1405, name:'HEBREW LETTER VAV', cat:c.Lo,  relatives:['fb35', 'fb4b'],  canon:k._0, block:b[11]},
			'05d6':{ u:'05d6', i:1406, name:'HEBREW LETTER ZAYIN', cat:c.Lo,  relatives:['fb36'],  canon:k._0, block:b[11]},
			'05d7':{ u:'05d7', i:1407, name:'HEBREW LETTER HET', cat:c.Lo,   canon:k._0, block:b[11]},
			'05d8':{ u:'05d8', i:1408, name:'HEBREW LETTER TET', cat:c.Lo,  relatives:['fb38'],  canon:k._0, block:b[11]},
			'05d9':{ u:'05d9', i:1409, name:'HEBREW LETTER YOD', cat:c.Lo,  relatives:['fb1d', 'fb39'],  canon:k._0, block:b[11]},
			'05da':{ u:'05da', i:1410, name:'HEBREW LETTER FINAL KAF', cat:c.Lo,  relatives:['fb3a'],  canon:k._0, block:b[11]},
			'05db':{ u:'05db', i:1411, name:'HEBREW LETTER KAF', cat:c.Lo,  relatives:['fb24', 'fb3b', 'fb4d'],  canon:k._0, block:b[11]},
			'05dc':{ u:'05dc', i:1412, name:'HEBREW LETTER LAMED', cat:c.Lo,  relatives:['fb25', 'fb3c', 'fb4f'],  canon:k._0, block:b[11]},
			'05dd':{ u:'05dd', i:1413, name:'HEBREW LETTER FINAL MEM', cat:c.Lo,  relatives:['fb26'],  canon:k._0, block:b[11]},
			'05de':{ u:'05de', i:1414, name:'HEBREW LETTER MEM', cat:c.Lo,  relatives:['fb3e'],  canon:k._0, block:b[11]},
			'05df':{ u:'05df', i:1415, name:'HEBREW LETTER FINAL NUN', cat:c.Lo,   canon:k._0, block:b[11]},
			'05e0':{ u:'05e0', i:1416, name:'HEBREW LETTER NUN', cat:c.Lo,  relatives:['fb40'],  canon:k._0, block:b[11]},
			'05e1':{ u:'05e1', i:1417, name:'HEBREW LETTER SAMEKH', cat:c.Lo,  relatives:['fb41'],  canon:k._0, block:b[11]},
			'05e2':{ u:'05e2', i:1418, name:'HEBREW LETTER AYIN', cat:c.Lo,  relatives:['fb20'],  canon:k._0, block:b[11]},
			'05e3':{ u:'05e3', i:1419, name:'HEBREW LETTER FINAL PE', cat:c.Lo,  relatives:['fb43'],  canon:k._0, block:b[11]},
			'05e4':{ u:'05e4', i:1420, name:'HEBREW LETTER PE', cat:c.Lo,  relatives:['fb44', 'fb4e'],  canon:k._0, block:b[11]},
			'05e5':{ u:'05e5', i:1421, name:'HEBREW LETTER FINAL TSADI', cat:c.Lo,   canon:k._0, block:b[11]},
			'05e6':{ u:'05e6', i:1422, name:'HEBREW LETTER TSADI', cat:c.Lo,  relatives:['fb46'],  canon:k._0, block:b[11]},
			'05e7':{ u:'05e7', i:1423, name:'HEBREW LETTER QOF', cat:c.Lo,  relatives:['fb47'],  canon:k._0, block:b[11]},
			'05e8':{ u:'05e8', i:1424, name:'HEBREW LETTER RESH', cat:c.Lo,  relatives:['fb27', 'fb48'],  canon:k._0, block:b[11]},
			'05e9':{ u:'05e9', i:1425, name:'HEBREW LETTER SHIN', cat:c.Lo,  relatives:['fb2a', 'fb2b', 'fb49'],  canon:k._0, block:b[11]},
			'05ea':{ u:'05ea', i:1426, name:'HEBREW LETTER TAV', cat:c.Lo,  relatives:['fb28', 'fb4a'],  canon:k._0, block:b[11]},
			'05ef':{ u:'05ef', i:1427, name:'HEBREW YOD TRIANGLE', cat:c.Lo,   canon:k._0, block:b[11]},
			'05f0':{ u:'05f0', i:1428, name:'HEBREW LIGATURE YIDDISH DOUBLE VAV', cat:c.Lo,   canon:k._0, block:b[11]},
			'05f1':{ u:'05f1', i:1429, name:'HEBREW LIGATURE YIDDISH VAV YOD', cat:c.Lo,   canon:k._0, block:b[11]},
			'05f2':{ u:'05f2', i:1430, name:'HEBREW LIGATURE YIDDISH DOUBLE YOD', cat:c.Lo,  relatives:['fb1f'],  canon:k._0, block:b[11]},
			'05f3':{ u:'05f3', i:1431, name:'HEBREW PUNCTUATION GERESH', cat:c.Po,   canon:k._0, block:b[11]},
			'05f4':{ u:'05f4', i:1432, name:'HEBREW PUNCTUATION GERSHAYIM', cat:c.Po,   canon:k._0, block:b[11]},
			'0600':{ u:'0600', i:1433, name:'ARABIC NUMBER SIGN', cat:c.Cf,   canon:k._0, block:b[12]},
			'0601':{ u:'0601', i:1434, name:'ARABIC SIGN SANAH', cat:c.Cf,   canon:k._0, block:b[12]},
			'0602':{ u:'0602', i:1435, name:'ARABIC FOOTNOTE MARKER', cat:c.Cf,   canon:k._0, block:b[12]},
			'0603':{ u:'0603', i:1436, name:'ARABIC SIGN SAFHA', cat:c.Cf,   canon:k._0, block:b[12]},
			'0604':{ u:'0604', i:1437, name:'ARABIC SIGN SAMVAT', cat:c.Cf,   canon:k._0, block:b[12]},
			'0605':{ u:'0605', i:1438, name:'ARABIC NUMBER MARK ABOVE', cat:c.Cf,   canon:k._0, block:b[12]},
			'0606':{ u:'0606', i:1439, name:'ARABIC-INDIC CUBE ROOT', cat:c.Sm,   canon:k._0, block:b[12]},
			'0607':{ u:'0607', i:1440, name:'ARABIC-INDIC FOURTH ROOT', cat:c.Sm,   canon:k._0, block:b[12]},
			'0608':{ u:'0608', i:1441, name:'ARABIC RAY', cat:c.Sm,   canon:k._0, block:b[12]},
			'0609':{ u:'0609', i:1442, name:'ARABIC-INDIC PER MILLE SIGN', cat:c.Po,   canon:k._0, block:b[12]},
			'060a':{ u:'060a', i:1443, name:'ARABIC-INDIC PER TEN THOUSAND SIGN', cat:c.Po,   canon:k._0, block:b[12]},
			'060b':{ u:'060b', i:1444, name:'AFGHANI SIGN', cat:c.Sc,   canon:k._0, block:b[12]},
			'060c':{ u:'060c', i:1445, name:'ARABIC COMMA', cat:c.Po,   canon:k._0, block:b[12]},
			'060d':{ u:'060d', i:1446, name:'ARABIC DATE SEPARATOR', cat:c.Po,   canon:k._0, block:b[12]},
			'060e':{ u:'060e', i:1447, name:'ARABIC POETIC VERSE SIGN', cat:c.So,   canon:k._0, block:b[12]},
			'060f':{ u:'060f', i:1448, name:'ARABIC SIGN MISRA', cat:c.So,   canon:k._0, block:b[12]},
			'0610':{ u:'0610', i:1449, name:'ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM', cat:c.Mn,   canon:k._230, block:b[12]},
			'0611':{ u:'0611', i:1450, name:'ARABIC SIGN ALAYHE ASSALLAM', cat:c.Mn,   canon:k._230, block:b[12]},
			'0612':{ u:'0612', i:1451, name:'ARABIC SIGN RAHMATULLAH ALAYHE', cat:c.Mn,   canon:k._230, block:b[12]},
			'0613':{ u:'0613', i:1452, name:'ARABIC SIGN RADI ALLAHOU ANHU', cat:c.Mn,   canon:k._230, block:b[12]},
			'0614':{ u:'0614', i:1453, name:'ARABIC SIGN TAKHALLUS', cat:c.Mn,   canon:k._230, block:b[12]},
			'0615':{ u:'0615', i:1454, name:'ARABIC SMALL HIGH TAH', cat:c.Mn,   canon:k._230, block:b[12]},
			'0616':{ u:'0616', i:1455, name:'ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH', cat:c.Mn,   canon:k._230, block:b[12]},
			'0617':{ u:'0617', i:1456, name:'ARABIC SMALL HIGH ZAIN', cat:c.Mn,   canon:k._230, block:b[12]},
			'0618':{ u:'0618', i:1457, name:'ARABIC SMALL FATHA', cat:c.Mn,   canon:k._30, block:b[12]},
			'0619':{ u:'0619', i:1458, name:'ARABIC SMALL DAMMA', cat:c.Mn,   canon:k._31, block:b[12]},
			'061a':{ u:'061a', i:1459, name:'ARABIC SMALL KASRA', cat:c.Mn,   canon:k._32, block:b[12]},
			'061b':{ u:'061b', i:1460, name:'ARABIC SEMICOLON', cat:c.Po,   canon:k._0, block:b[12]},
			'061c':{ u:'061c', i:1461, name:'ARABIC LETTER MARK', cat:c.Cf,   canon:k._0, block:b[12]},
			'061d':{ u:'061d', i:1462, name:'ARABIC END OF TEXT MARK', cat:c.Po,   canon:k._0, block:b[12]},
			'061e':{ u:'061e', i:1463, name:'ARABIC TRIPLE DOT PUNCTUATION MARK', cat:c.Po,   canon:k._0, block:b[12]},
			'061f':{ u:'061f', i:1464, name:'ARABIC QUESTION MARK', cat:c.Po,   canon:k._0, block:b[12]},
			'0620':{ u:'0620', i:1465, name:'ARABIC LETTER KASHMIRI YEH', cat:c.Lo,   canon:k._0, block:b[12]},
			'0621':{ u:'0621', i:1466, name:'ARABIC LETTER HAMZA', cat:c.Lo,  relatives:['fe80'],  canon:k._0, block:b[12]},
			'0622':{ u:'0622', i:1467, name:'ARABIC LETTER ALEF WITH MADDA ABOVE', cat:c.Lo,  relatives:['0627', '0653', 'fe81', 'fe82', 'fef5', 'fef6'], comp:['0627','0653'], canon:k._0, block:b[12]},
			'0623':{ u:'0623', i:1468, name:'ARABIC LETTER ALEF WITH HAMZA ABOVE', cat:c.Lo,  relatives:['0627', '0654', 'fe83', 'fe84', 'fef7', 'fef8'], comp:['0627','0654'], canon:k._0, block:b[12]},
			'0624':{ u:'0624', i:1469, name:'ARABIC LETTER WAW WITH HAMZA ABOVE', cat:c.Lo,  relatives:['0648', '0654', 'fe85', 'fe86'], comp:['0648','0654'], canon:k._0, block:b[12]},
			'0625':{ u:'0625', i:1470, name:'ARABIC LETTER ALEF WITH HAMZA BELOW', cat:c.Lo,  relatives:['0627', '0655', 'fe87', 'fe88', 'fef9', 'fefa'], comp:['0627','0655'], canon:k._0, block:b[12]},
			'0626':{ u:'0626', i:1471, name:'ARABIC LETTER YEH WITH HAMZA ABOVE', cat:c.Lo,  relatives:['064a', '0654', 'fbea', 'fbeb', 'fbec', 'fbed', 'fbee', 'fbef', 'fbf0', 'fbf1', 'fbf2', 'fbf3', 'fbf4', 'fbf5', 'fbf6', 'fbf7', 'fbf8', 'fbf9', 'fbfa', 'fbfb', 'fc00', 'fc01', 'fc02', 'fc03', 'fc04', 'fc64', 'fc65', 'fc66', 'fc67', 'fc68', 'fc69', 'fc97', 'fc98', 'fc99', 'fc9a', 'fc9b', 'fcdf', 'fce0', 'fe89', 'fe8a', 'fe8b', 'fe8c'], comp:['064a','0654'], canon:k._0, block:b[12]},
			'0627':{ u:'0627', i:1472, name:'ARABIC LETTER ALEF', cat:c.Lo,  relatives:['0622', '0623', '0625', '0675', 'fbea', 'fbeb', 'fc37', 'fc80', 'fc88', 'fd3c', 'fd3d', 'fdf2', 'fdf3', 'fdfa', 'fdfb', 'fdfc', 'fe8d', 'fe8e', 'fefb', 'fefc', '1ee00', '1ee80'],  canon:k._0, block:b[12]},
			'0628':{ u:'0628', i:1473, name:'ARABIC LETTER BEH', cat:c.Lo,  relatives:['fc05', 'fc06', 'fc07', 'fc08', 'fc09', 'fc0a', 'fc6a', 'fc6b', 'fc6c', 'fc6d', 'fc6e', 'fc6f', 'fc9c', 'fc9d', 'fc9e', 'fc9f', 'fca0', 'fce1', 'fce2', 'fd9e', 'fdc2', 'fdf3', 'fe8f', 'fe90', 'fe91', 'fe92', '1ee01', '1ee21', '1ee61', '1ee81', '1eea1'],  canon:k._0, block:b[12]},
			'0629':{ u:'0629', i:1474, name:'ARABIC LETTER TEH MARBUTA', cat:c.Lo,  relatives:['fe93', 'fe94'],  canon:k._0, block:b[12]},
			'062a':{ u:'062a', i:1475, name:'ARABIC LETTER TEH', cat:c.Lo,  relatives:['fc0b', 'fc0c', 'fc0d', 'fc0e', 'fc0f', 'fc10', 'fc70', 'fc71', 'fc72', 'fc73', 'fc74', 'fc75', 'fca1', 'fca2', 'fca3', 'fca4', 'fca5', 'fce3', 'fce4', 'fd50', 'fd51', 'fd52', 'fd53', 'fd54', 'fd55', 'fd56', 'fd57', 'fd9f', 'fda0', 'fda1', 'fda2', 'fda3', 'fda4', 'fe95', 'fe96', 'fe97', 'fe98', '1ee15', '1ee35', '1ee75', '1ee95', '1eeb5'],  canon:k._0, block:b[12]},
			'062b':{ u:'062b', i:1476, name:'ARABIC LETTER THEH', cat:c.Lo,  relatives:['fc11', 'fc12', 'fc13', 'fc14', 'fc76', 'fc77', 'fc78', 'fc79', 'fc7a', 'fc7b', 'fca6', 'fce5', 'fce6', 'fe99', 'fe9a', 'fe9b', 'fe9c', '1ee16', '1ee36', '1ee76', '1ee96', '1eeb6'],  canon:k._0, block:b[12]},
			'062c':{ u:'062c', i:1477, name:'ARABIC LETTER JEEM', cat:c.Lo,  relatives:['fc00', 'fc05', 'fc0b', 'fc11', 'fc15', 'fc16', 'fc17', 'fc19', 'fc1c', 'fc22', 'fc29', 'fc2b', 'fc2d', 'fc38', 'fc3f', 'fc45', 'fc4b', 'fc51', 'fc55', 'fc97', 'fc9c', 'fca1', 'fca7', 'fca8', 'fca9', 'fcab', 'fcad', 'fcb4', 'fcba', 'fcbc', 'fcbe', 'fcc4', 'fcc9', 'fcce', 'fcd2', 'fcd7', 'fcda', 'fd01', 'fd02', 'fd09', 'fd1d', 'fd1e', 'fd25', 'fd2d', 'fd34', 'fd37', 'fd50', 'fd51', 'fd52', 'fd55', 'fd58', 'fd59', 'fd5c', 'fd5d', 'fd5e', 'fd61', 'fd69', 'fd75', 'fd83', 'fd84', 'fd89', 'fd8c', 'fd8d', 'fd8e', 'fd92', 'fd93', 'fd97', 'fd98', 'fd99', 'fd9f', 'fda0', 'fda5', 'fda6', 'fda7', 'fdac', 'fdaf', 'fdb8', 'fdba', 'fdbc', 'fdbd', 'fdbe', 'fdbf', 'fdc0', 'fdc4', 'fdc7', 'fdfb', 'fe9d', 'fe9e', 'fe9f', 'fea0', '1ee02', '1ee22', '1ee42', '1ee62', '1ee82', '1eea2'],  canon:k._0, block:b[12]},
			'062d':{ u:'062d', i:1478, name:'ARABIC LETTER HAH', cat:c.Lo,  relatives:['fc01', 'fc06', 'fc0c', 'fc15', 'fc17', 'fc18', 'fc1a', 'fc1d', 'fc20', 'fc23', 'fc26', 'fc2e', 'fc33', 'fc39', 'fc40', 'fc46', 'fc4c', 'fc56', 'fc98', 'fc9d', 'fca2', 'fca7', 'fca9', 'fcaa', 'fcae', 'fcb1', 'fcb5', 'fcb8', 'fcbf', 'fcc2', 'fcc5', 'fcca', 'fccf', 'fcd3', 'fcdb', 'fcff', 'fd00', 'fd0a', 'fd1b', 'fd1c', 'fd26', 'fd2e', 'fd35', 'fd38', 'fd51', 'fd52', 'fd53', 'fd56', 'fd58', 'fd59', 'fd5a', 'fd5b', 'fd5c', 'fd5d', 'fd5f', 'fd60', 'fd64', 'fd65', 'fd67', 'fd68', 'fd6e', 'fd71', 'fd72', 'fd7e', 'fd80', 'fd81', 'fd82', 'fd87', 'fd88', 'fd89', 'fd8a', 'fd8b', 'fd8c', 'fd95', 'fd96', 'fda6', 'fda9', 'fdaa', 'fdab', 'fdae', 'fdb3', 'fdb4', 'fdb5', 'fdb8', 'fdbd', 'fdbe', 'fdbf', 'fdc2', 'fdf4', 'fea1', 'fea2', 'fea3', 'fea4', '1ee07', '1ee27', '1ee47', '1ee67', '1ee87', '1eea7'],  canon:k._0, block:b[12]},
			'062e':{ u:'062e', i:1479, name:'ARABIC LETTER KHAH', cat:c.Lo,  relatives:['fc07', 'fc0d', 'fc19', 'fc1a', 'fc1b', 'fc1e', 'fc24', 'fc2f', 'fc3a', 'fc41', 'fc47', 'fc4d', 'fc57', 'fc99', 'fc9e', 'fca3', 'fcab', 'fcac', 'fcaf', 'fcb2', 'fcb6', 'fcc0', 'fcc6', 'fccb', 'fcd0', 'fcd4', 'fcdc', 'fd03', 'fd04', 'fd0b', 'fd1f', 'fd20', 'fd27', 'fd2f', 'fd36', 'fd39', 'fd54', 'fd57', 'fd6a', 'fd6b', 'fd6f', 'fd70', 'fd7c', 'fd7d', 'fd85', 'fd86', 'fd8e', 'fd8f', 'fd92', 'fd9e', 'fda1', 'fda2', 'fda8', 'fdb9', 'fdc6', 'fea5', 'fea6', 'fea7', 'fea8', '1ee17', '1ee37', '1ee57', '1ee77', '1ee97', '1eeb7'],  canon:k._0, block:b[12]},
			'062f':{ u:'062f', i:1480, name:'ARABIC LETTER DAL', cat:c.Lo,  relatives:['fdf4', 'fea9', 'feaa', '1ee03', '1ee83', '1eea3'],  canon:k._0, block:b[12]},
			'0630':{ u:'0630', i:1481, name:'ARABIC LETTER THAL', cat:c.Lo,  relatives:['fc5b', 'feab', 'feac', '1ee18', '1ee98', '1eeb8'],  canon:k._0, block:b[12]},
			'0631':{ u:'0631', i:1482, name:'ARABIC LETTER REH', cat:c.Lo,  relatives:['fc5c', 'fc64', 'fc6a', 'fc70', 'fc76', 'fc8a', 'fc91', 'fd0d', 'fd0e', 'fd0f', 'fd10', 'fd29', 'fd2a', 'fd2b', 'fd2c', 'fdf3', 'fdf6', 'fdfc', 'fead', 'feae', '1ee13', '1ee93', '1eeb3'],  canon:k._0, block:b[12]},
			'0632':{ u:'0632', i:1483, name:'ARABIC LETTER ZAIN', cat:c.Lo,  relatives:['fc65', 'fc6b', 'fc71', 'fc77', 'fc8b', 'fc92', 'feaf', 'feb0', '1ee06', '1ee86', '1eea6'],  canon:k._0, block:b[12]},
			'0633':{ u:'0633', i:1484, name:'ARABIC LETTER SEEN', cat:c.Lo,  relatives:['fc1c', 'fc1d', 'fc1e', 'fc1f', 'fcad', 'fcae', 'fcaf', 'fcb0', 'fce7', 'fce8', 'fcfb', 'fcfc', 'fd0e', 'fd17', 'fd18', 'fd2a', 'fd31', 'fd34', 'fd35', 'fd36', 'fd5c', 'fd5d', 'fd5e', 'fd5f', 'fd60', 'fd61', 'fd62', 'fd63', 'fda8', 'fdc6', 'fdf6', 'fdf8', 'fdfa', 'feb1', 'feb2', 'feb3', 'feb4', '1ee0e', '1ee2e', '1ee4e', '1ee6e', '1ee8e', '1eeae'],  canon:k._0, block:b[12]},
			'0634':{ u:'0634', i:1485, name:'ARABIC LETTER SHEEN', cat:c.Lo,  relatives:['fce9', 'fcea', 'fcfd', 'fcfe', 'fd09', 'fd0a', 'fd0b', 'fd0c', 'fd0d', 'fd19', 'fd1a', 'fd25', 'fd26', 'fd27', 'fd28', 'fd29', 'fd2d', 'fd2e', 'fd2f', 'fd30', 'fd32', 'fd37', 'fd38', 'fd39', 'fd67', 'fd68', 'fd69', 'fd6a', 'fd6b', 'fd6c', 'fd6d', 'fdaa', 'feb5', 'feb6', 'feb7', 'feb8', '1ee14', '1ee34', '1ee54', '1ee74', '1ee94', '1eeb4'],  canon:k._0, block:b[12]},
			'0635':{ u:'0635', i:1486, name:'ARABIC LETTER SAD', cat:c.Lo,  relatives:['fc20', 'fc21', 'fcb1', 'fcb2', 'fcb3', 'fd05', 'fd06', 'fd0f', 'fd21', 'fd22', 'fd2b', 'fd64', 'fd65', 'fd66', 'fda9', 'fdc5', 'fdf0', 'fdf5', 'fdf9', 'fdfa', 'feb9', 'feba', 'febb', 'febc', '1ee11', '1ee31', '1ee51', '1ee71', '1ee91', '1eeb1'],  canon:k._0, block:b[12]},
			'0636':{ u:'0636', i:1487, name:'ARABIC LETTER DAD', cat:c.Lo,  relatives:['fc22', 'fc23', 'fc24', 'fc25', 'fcb4', 'fcb5', 'fcb6', 'fcb7', 'fd07', 'fd08', 'fd10', 'fd23', 'fd24', 'fd2c', 'fd6e', 'fd6f', 'fd70', 'fdab', 'febd', 'febe', 'febf', 'fec0', '1ee19', '1ee39', '1ee59', '1ee79', '1ee99', '1eeb9'],  canon:k._0, block:b[12]},
			'0637':{ u:'0637', i:1488, name:'ARABIC LETTER TAH', cat:c.Lo,  relatives:['fc26', 'fc27', 'fcb8', 'fcf5', 'fcf6', 'fd11', 'fd12', 'fd33', 'fd3a', 'fd71', 'fd72', 'fd73', 'fd74', 'fec1', 'fec2', 'fec3', 'fec4', '1ee08', '1ee68', '1ee88', '1eea8'],  canon:k._0, block:b[12]},
			'0638':{ u:'0638', i:1489, name:'ARABIC LETTER ZAH', cat:c.Lo,  relatives:['fc28', 'fcb9', 'fd3b', 'fec5', 'fec6', 'fec7', 'fec8', '1ee1a', '1ee7a', '1ee9a', '1eeba'],  canon:k._0, block:b[12]},
			'0639':{ u:'0639', i:1490, name:'ARABIC LETTER AIN', cat:c.Lo,  relatives:['fc29', 'fc2a', 'fcba', 'fcbb', 'fcf7', 'fcf8', 'fd13', 'fd14', 'fd75', 'fd76', 'fd77', 'fd78', 'fdb6', 'fdc4', 'fdf5', 'fdf7', 'fdfa', 'fec9', 'feca', 'fecb', 'fecc', '1ee0f', '1ee2f', '1ee4f', '1ee6f', '1ee8f', '1eeaf'],  canon:k._0, block:b[12]},
			'063a':{ u:'063a', i:1491, name:'ARABIC LETTER GHAIN', cat:c.Lo,  relatives:['fc2b', 'fc2c', 'fcbc', 'fcbd', 'fcf9', 'fcfa', 'fd15', 'fd16', 'fd79', 'fd7a', 'fd7b', 'fecd', 'fece', 'fecf', 'fed0', '1ee1b', '1ee3b', '1ee5b', '1ee7b', '1ee9b', '1eebb'],  canon:k._0, block:b[12]},
			'063b':{ u:'063b', i:1492, name:'ARABIC LETTER KEHEH WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'063c':{ u:'063c', i:1493, name:'ARABIC LETTER KEHEH WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'063d':{ u:'063d', i:1494, name:'ARABIC LETTER FARSI YEH WITH INVERTED V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'063e':{ u:'063e', i:1495, name:'ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'063f':{ u:'063f', i:1496, name:'ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0640':{ u:'0640', i:1497, name:'ARABIC TATWEEL', cat:c.Lm,  relatives:['fcf2', 'fcf3', 'fcf4', 'fe71', 'fe77', 'fe79', 'fe7b', 'fe7d', 'fe7f'],  canon:k._0, block:b[12]},
			'0641':{ u:'0641', i:1498, name:'ARABIC LETTER FEH', cat:c.Lo,  relatives:['fc2d', 'fc2e', 'fc2f', 'fc30', 'fc31', 'fc32', 'fc7c', 'fc7d', 'fcbe', 'fcbf', 'fcc0', 'fcc1', 'fd7c', 'fd7d', 'fdc1', 'fed1', 'fed2', 'fed3', 'fed4', '1ee10', '1ee30', '1ee70', '1ee90', '1eeb0'],  canon:k._0, block:b[12]},
			'0642':{ u:'0642', i:1499, name:'ARABIC LETTER QAF', cat:c.Lo,  relatives:['fc33', 'fc34', 'fc35', 'fc36', 'fc7e', 'fc7f', 'fcc2', 'fcc3', 'fd7e', 'fd7f', 'fdb2', 'fdb4', 'fdf1', 'fed5', 'fed6', 'fed7', 'fed8', '1ee12', '1ee32', '1ee52', '1ee72', '1ee92', '1eeb2'],  canon:k._0, block:b[12]},
			'0643':{ u:'0643', i:1500, name:'ARABIC LETTER KAF', cat:c.Lo,  relatives:['fc37', 'fc38', 'fc39', 'fc3a', 'fc3b', 'fc3c', 'fc3d', 'fc3e', 'fc80', 'fc81', 'fc82', 'fc83', 'fc84', 'fcc4', 'fcc5', 'fcc6', 'fcc7', 'fcc8', 'fceb', 'fcec', 'fdb7', 'fdbb', 'fdc3', 'fdf3', 'fed9', 'feda', 'fedb', 'fedc', '1ee0a', '1ee2a', '1ee6a'],  canon:k._0, block:b[12]},
			'0644':{ u:'0644', i:1501, name:'ARABIC LETTER LAM', cat:c.Lo,  relatives:['fc3b', 'fc3f', 'fc40', 'fc41', 'fc42', 'fc43', 'fc44', 'fc81', 'fc85', 'fc86', 'fc87', 'fcc7', 'fcc9', 'fcca', 'fccb', 'fccc', 'fccd', 'fceb', 'fced', 'fd80', 'fd81', 'fd82', 'fd83', 'fd84', 'fd85', 'fd86', 'fd87', 'fd88', 'fdac', 'fdad', 'fdb5', 'fdba', 'fdbc', 'fdf0', 'fdf1', 'fdf2', 'fdf5', 'fdf6', 'fdf7', 'fdf8', 'fdf9', 'fdfa', 'fdfb', 'fdfc', 'fedd', 'fede', 'fedf', 'fee0', 'fef5', 'fef6', 'fef7', 'fef8', 'fef9', 'fefa', 'fefb', 'fefc', '1ee0b', '1ee2b', '1ee4b', '1ee8b', '1eeab'],  canon:k._0, block:b[12]},
			'0645':{ u:'0645', i:1502, name:'ARABIC LETTER MEEM', cat:c.Lo,  relatives:['fc02', 'fc08', 'fc0e', 'fc12', 'fc16', 'fc18', 'fc1b', 'fc1f', 'fc21', 'fc25', 'fc27', 'fc28', 'fc2a', 'fc2c', 'fc30', 'fc34', 'fc3c', 'fc42', 'fc45', 'fc46', 'fc47', 'fc48', 'fc49', 'fc4a', 'fc4e', 'fc52', 'fc58', 'fc66', 'fc6c', 'fc72', 'fc78', 'fc82', 'fc85', 'fc88', 'fc89', 'fc8c', 'fc93', 'fc9a', 'fc9f', 'fca4', 'fca6', 'fca8', 'fcaa', 'fcac', 'fcb0', 'fcb3', 'fcb7', 'fcb9', 'fcbb', 'fcbd', 'fcc1', 'fcc3', 'fcc8', 'fccc', 'fcce', 'fccf', 'fcd0', 'fcd1', 'fcd5', 'fcd8', 'fcdd', 'fcdf', 'fce1', 'fce3', 'fce5', 'fce7', 'fce9', 'fcec', 'fced', 'fcee', 'fcf0', 'fd0c', 'fd28', 'fd30', 'fd33', 'fd3a', 'fd3b', 'fd50', 'fd53', 'fd54', 'fd55', 'fd56', 'fd57', 'fd58', 'fd59', 'fd5a', 'fd5b', 'fd5f', 'fd60', 'fd61', 'fd62', 'fd63', 'fd66', 'fd67', 'fd68', 'fd6a', 'fd6b', 'fd6c', 'fd6d', 'fd6f', 'fd70', 'fd71', 'fd72', 'fd73', 'fd74', 'fd75', 'fd76', 'fd77', 'fd78', 'fd79', 'fd7a', 'fd7b', 'fd7c', 'fd7d', 'fd7e', 'fd7f', 'fd80', 'fd85', 'fd86', 'fd87', 'fd88', 'fd89', 'fd8a', 'fd8b', 'fd8c', 'fd8d', 'fd8e', 'fd8f', 'fd92', 'fd93', 'fd94', 'fd95', 'fd97', 'fd98', 'fd9a', 'fd9b', 'fd9c', 'fd9d', 'fda3', 'fda4', 'fda5', 'fda7', 'fdad', 'fdb0', 'fdb1', 'fdb2', 'fdb4', 'fdb5', 'fdb6', 'fdb7', 'fdb9', 'fdba', 'fdbb', 'fdbc', 'fdc0', 'fdc1', 'fdc3', 'fdc4', 'fdc5', 'fdf4', 'fdf5', 'fdf8', 'fdfa', 'fee1', 'fee2', 'fee3', 'fee4', '1ee0c', '1ee2c', '1ee6c', '1ee8c', '1eeac'],  canon:k._0, block:b[12]},
			'0646':{ u:'0646', i:1503, name:'ARABIC LETTER NOON', cat:c.Lo,  relatives:['fc4b', 'fc4c', 'fc4d', 'fc4e', 'fc4f', 'fc50', 'fc67', 'fc6d', 'fc73', 'fc79', 'fc8a', 'fc8b', 'fc8c', 'fc8d', 'fc8e', 'fc8f', 'fc94', 'fcd2', 'fcd3', 'fcd4', 'fcd5', 'fcd6', 'fcee', 'fcef', 'fd95', 'fd96', 'fd97', 'fd98', 'fd99', 'fd9a', 'fd9b', 'fdb3', 'fdb8', 'fdbd', 'fdc7', 'fee5', 'fee6', 'fee7', 'fee8', '1ee0d', '1ee2d', '1ee4d', '1ee6d', '1ee8d', '1eead'],  canon:k._0, block:b[12]},
			'0647':{ u:'0647', i:1504, name:'ARABIC LETTER HEH', cat:c.Lo,  relatives:['fc51', 'fc52', 'fc53', 'fc54', 'fc9b', 'fca0', 'fca5', 'fccd', 'fcd6', 'fcd7', 'fcd8', 'fcd9', 'fcde', 'fce0', 'fce2', 'fce4', 'fce6', 'fce8', 'fcea', 'fcef', 'fcf1', 'fd31', 'fd32', 'fd93', 'fd94', 'fdf2', 'fdf7', 'fdfa', 'fdfb', 'fee9', 'feea', 'feeb', 'feec', '1ee24', '1ee64', '1ee84'],  canon:k._0, block:b[12]},
			'0648':{ u:'0648', i:1505, name:'ARABIC LETTER WAW', cat:c.Lo,  relatives:['0624', '0676', 'fbee', 'fbef', 'fdf6', 'fdf8', 'fdfa', 'feed', 'feee', '1ee05', '1ee85', '1eea5'],  canon:k._0, block:b[12]},
			'0649':{ u:'0649', i:1506, name:'ARABIC LETTER ALEF MAKSURA', cat:c.Lo,  relatives:['fbe8', 'fbe9', 'fbf9', 'fbfa', 'fbfb', 'fc03', 'fc09', 'fc0f', 'fc13', 'fc31', 'fc35', 'fc3d', 'fc43', 'fc49', 'fc4f', 'fc53', 'fc59', 'fc5d', 'fc68', 'fc6e', 'fc74', 'fc7a', 'fc7c', 'fc7e', 'fc83', 'fc86', 'fc8e', 'fc90', 'fc95', 'fcf5', 'fcf7', 'fcf9', 'fcfb', 'fcfd', 'fcff', 'fd01', 'fd03', 'fd05', 'fd07', 'fd11', 'fd13', 'fd15', 'fd17', 'fd19', 'fd1b', 'fd1d', 'fd1f', 'fd21', 'fd23', 'fd5b', 'fd5e', 'fd6e', 'fd78', 'fd7b', 'fd82', 'fd96', 'fd99', 'fd9b', 'fda0', 'fda2', 'fda4', 'fda6', 'fda7', 'fda8', 'fdf9', 'fdfa', 'feef', 'fef0'],  canon:k._0, block:b[12]},
			'064a':{ u:'064a', i:1507, name:'ARABIC LETTER YEH', cat:c.Lo,  relatives:['0626', '0678', 'fc04', 'fc0a', 'fc10', 'fc14', 'fc32', 'fc36', 'fc3e', 'fc44', 'fc4a', 'fc50', 'fc54', 'fc55', 'fc56', 'fc57', 'fc58', 'fc59', 'fc5a', 'fc69', 'fc6f', 'fc75', 'fc7b', 'fc7d', 'fc7f', 'fc84', 'fc87', 'fc8f', 'fc91', 'fc92', 'fc93', 'fc94', 'fc95', 'fc96', 'fcda', 'fcdb', 'fcdc', 'fcdd', 'fcde', 'fcf0', 'fcf1', 'fcf6', 'fcf8', 'fcfa', 'fcfc', 'fcfe', 'fd00', 'fd02', 'fd04', 'fd06', 'fd08', 'fd12', 'fd14', 'fd16', 'fd18', 'fd1a', 'fd1c', 'fd1e', 'fd20', 'fd22', 'fd24', 'fd5a', 'fd69', 'fd74', 'fd7a', 'fd81', 'fd8b', 'fd9a', 'fd9c', 'fd9d', 'fd9e', 'fd9f', 'fda1', 'fda3', 'fda5', 'fda9', 'fdaa', 'fdab', 'fdac', 'fdad', 'fdae', 'fdaf', 'fdb0', 'fdb1', 'fdb2', 'fdb3', 'fdb6', 'fdb7', 'fdb9', 'fdbe', 'fdbf', 'fdc0', 'fdc1', 'fdc2', 'fdc6', 'fdc7', 'fdf7', 'fdfa', 'fef1', 'fef2', 'fef3', 'fef4', '1ee09', '1ee29', '1ee49', '1ee69', '1ee89', '1eea9'],  canon:k._0, block:b[12]},
			'064b':{ u:'064b', i:1508, name:'ARABIC FATHATAN', cat:c.Mn,  relatives:['fd3c', 'fd3d', 'fe70', 'fe71'],  canon:k._27, block:b[12]},
			'064c':{ u:'064c', i:1509, name:'ARABIC DAMMATAN', cat:c.Mn,  relatives:['fc5e', 'fe72'],  canon:k._28, block:b[12]},
			'064d':{ u:'064d', i:1510, name:'ARABIC KASRATAN', cat:c.Mn,  relatives:['fc5f', 'fe74'],  canon:k._29, block:b[12]},
			'064e':{ u:'064e', i:1511, name:'ARABIC FATHA', cat:c.Mn,  relatives:['fc60', 'fcf2', 'fe76', 'fe77'],  canon:k._30, block:b[12]},
			'064f':{ u:'064f', i:1512, name:'ARABIC DAMMA', cat:c.Mn,  relatives:['fc61', 'fcf3', 'fe78', 'fe79'],  canon:k._31, block:b[12]},
			'0650':{ u:'0650', i:1513, name:'ARABIC KASRA', cat:c.Mn,  relatives:['fc62', 'fcf4', 'fe7a', 'fe7b'],  canon:k._32, block:b[12]},
			'0651':{ u:'0651', i:1514, name:'ARABIC SHADDA', cat:c.Mn,  relatives:['fc5e', 'fc5f', 'fc60', 'fc61', 'fc62', 'fc63', 'fcf2', 'fcf3', 'fcf4', 'fe7c', 'fe7d'],  canon:k._33, block:b[12]},
			'0652':{ u:'0652', i:1515, name:'ARABIC SUKUN', cat:c.Mn,  relatives:['fe7e', 'fe7f'],  canon:k._34, block:b[12]},
			'0653':{ u:'0653', i:1516, name:'ARABIC MADDAH ABOVE', cat:c.Mn,  relatives:['0622'],  canon:k._230, block:b[12]},
			'0654':{ u:'0654', i:1517, name:'ARABIC HAMZA ABOVE', cat:c.Mn,  relatives:['0623', '0624', '0626', '06c0', '06c2', '06d3'],  canon:k._230, block:b[12]},
			'0655':{ u:'0655', i:1518, name:'ARABIC HAMZA BELOW', cat:c.Mn,  relatives:['0625'],  canon:k._220, block:b[12]},
			'0656':{ u:'0656', i:1519, name:'ARABIC SUBSCRIPT ALEF', cat:c.Mn,   canon:k._220, block:b[12]},
			'0657':{ u:'0657', i:1520, name:'ARABIC INVERTED DAMMA', cat:c.Mn,   canon:k._230, block:b[12]},
			'0658':{ u:'0658', i:1521, name:'ARABIC MARK NOON GHUNNA', cat:c.Mn,   canon:k._230, block:b[12]},
			'0659':{ u:'0659', i:1522, name:'ARABIC ZWARAKAY', cat:c.Mn,   canon:k._230, block:b[12]},
			'065a':{ u:'065a', i:1523, name:'ARABIC VOWEL SIGN SMALL V ABOVE', cat:c.Mn,   canon:k._230, block:b[12], indexed:["V"]},
			'065b':{ u:'065b', i:1524, name:'ARABIC VOWEL SIGN INVERTED SMALL V ABOVE', cat:c.Mn,   canon:k._230, block:b[12], indexed:["V"]},
			'065c':{ u:'065c', i:1525, name:'ARABIC VOWEL SIGN DOT BELOW', cat:c.Mn,   canon:k._220, block:b[12]},
			'065d':{ u:'065d', i:1526, name:'ARABIC REVERSED DAMMA', cat:c.Mn,   canon:k._230, block:b[12]},
			'065e':{ u:'065e', i:1527, name:'ARABIC FATHA WITH TWO DOTS', cat:c.Mn,   canon:k._230, block:b[12]},
			'065f':{ u:'065f', i:1528, name:'ARABIC WAVY HAMZA BELOW', cat:c.Mn,   canon:k._220, block:b[12]},
			'0660':{ u:'0660', i:1529, name:'ARABIC-INDIC DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[12]},
			'0661':{ u:'0661', i:1530, name:'ARABIC-INDIC DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[12]},
			'0662':{ u:'0662', i:1531, name:'ARABIC-INDIC DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[12]},
			'0663':{ u:'0663', i:1532, name:'ARABIC-INDIC DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[12]},
			'0664':{ u:'0664', i:1533, name:'ARABIC-INDIC DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[12]},
			'0665':{ u:'0665', i:1534, name:'ARABIC-INDIC DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[12]},
			'0666':{ u:'0666', i:1535, name:'ARABIC-INDIC DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[12]},
			'0667':{ u:'0667', i:1536, name:'ARABIC-INDIC DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[12]},
			'0668':{ u:'0668', i:1537, name:'ARABIC-INDIC DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[12]},
			'0669':{ u:'0669', i:1538, name:'ARABIC-INDIC DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[12]},
			'066a':{ u:'066a', i:1539, name:'ARABIC PERCENT SIGN', cat:c.Po,   canon:k._0, block:b[12]},
			'066b':{ u:'066b', i:1540, name:'ARABIC DECIMAL SEPARATOR', cat:c.Po,   canon:k._0, block:b[12]},
			'066c':{ u:'066c', i:1541, name:'ARABIC THOUSANDS SEPARATOR', cat:c.Po,   canon:k._0, block:b[12]},
			'066d':{ u:'066d', i:1542, name:'ARABIC FIVE POINTED STAR', cat:c.Po,   canon:k._0, block:b[12]},
			'066e':{ u:'066e', i:1543, name:'ARABIC LETTER DOTLESS BEH', cat:c.Lo,  relatives:['1ee1c', '1ee7c'],  canon:k._0, block:b[12]},
			'066f':{ u:'066f', i:1544, name:'ARABIC LETTER DOTLESS QAF', cat:c.Lo,  relatives:['1ee1f', '1ee5f'],  canon:k._0, block:b[12]},
			'0670':{ u:'0670', i:1545, name:'ARABIC LETTER SUPERSCRIPT ALEF', cat:c.Mn,  relatives:['fc5b', 'fc5c', 'fc5d', 'fc63', 'fc90', 'fcd9'],  canon:k._35, block:b[12]},
			'0671':{ u:'0671', i:1546, name:'ARABIC LETTER ALEF WASLA', cat:c.Lo,  relatives:['fb50', 'fb51'],  canon:k._0, block:b[12]},
			'0672':{ u:'0672', i:1547, name:'ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0673':{ u:'0673', i:1548, name:'ARABIC LETTER ALEF WITH WAVY HAMZA BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'0674':{ u:'0674', i:1549, name:'ARABIC LETTER HIGH HAMZA', cat:c.Lo,  relatives:['0675', '0676', '0677', '0678'],  canon:k._0, block:b[12]},
			'0675':{ u:'0675', i:1550, name:'ARABIC LETTER HIGH HAMZA ALEF', cat:c.Lo,  relatives:['0627', '0674'], comp:['0627','0674'], canon:k._0, block:b[12]},
			'0676':{ u:'0676', i:1551, name:'ARABIC LETTER HIGH HAMZA WAW', cat:c.Lo,  relatives:['0648', '0674'], comp:['0648','0674'], canon:k._0, block:b[12]},
			'0677':{ u:'0677', i:1552, name:'ARABIC LETTER U WITH HAMZA ABOVE', cat:c.Lo,  relatives:['06c7', '0674', 'fbdd'], comp:['06c7','0674'], canon:k._0, block:b[12], indexed:["U"]},
			'0678':{ u:'0678', i:1553, name:'ARABIC LETTER HIGH HAMZA YEH', cat:c.Lo,  relatives:['064a', '0674'], comp:['064a','0674'], canon:k._0, block:b[12]},
			'0679':{ u:'0679', i:1554, name:'ARABIC LETTER TTEH', cat:c.Lo,  relatives:['fb66', 'fb67', 'fb68', 'fb69'],  canon:k._0, block:b[12]},
			'067a':{ u:'067a', i:1555, name:'ARABIC LETTER TTEHEH', cat:c.Lo,  relatives:['fb5e', 'fb5f', 'fb60', 'fb61'],  canon:k._0, block:b[12]},
			'067b':{ u:'067b', i:1556, name:'ARABIC LETTER BEEH', cat:c.Lo,  relatives:['fb52', 'fb53', 'fb54', 'fb55'],  canon:k._0, block:b[12]},
			'067c':{ u:'067c', i:1557, name:'ARABIC LETTER TEH WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'067d':{ u:'067d', i:1558, name:'ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS', cat:c.Lo,   canon:k._0, block:b[12]},
			'067e':{ u:'067e', i:1559, name:'ARABIC LETTER PEH', cat:c.Lo,  relatives:['fb56', 'fb57', 'fb58', 'fb59'],  canon:k._0, block:b[12]},
			'067f':{ u:'067f', i:1560, name:'ARABIC LETTER TEHEH', cat:c.Lo,  relatives:['fb62', 'fb63', 'fb64', 'fb65'],  canon:k._0, block:b[12]},
			'0680':{ u:'0680', i:1561, name:'ARABIC LETTER BEHEH', cat:c.Lo,  relatives:['fb5a', 'fb5b', 'fb5c', 'fb5d'],  canon:k._0, block:b[12]},
			'0681':{ u:'0681', i:1562, name:'ARABIC LETTER HAH WITH HAMZA ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0682':{ u:'0682', i:1563, name:'ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0683':{ u:'0683', i:1564, name:'ARABIC LETTER NYEH', cat:c.Lo,  relatives:['fb76', 'fb77', 'fb78', 'fb79'],  canon:k._0, block:b[12]},
			'0684':{ u:'0684', i:1565, name:'ARABIC LETTER DYEH', cat:c.Lo,  relatives:['fb72', 'fb73', 'fb74', 'fb75'],  canon:k._0, block:b[12]},
			'0685':{ u:'0685', i:1566, name:'ARABIC LETTER HAH WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0686':{ u:'0686', i:1567, name:'ARABIC LETTER TCHEH', cat:c.Lo,  relatives:['fb7a', 'fb7b', 'fb7c', 'fb7d'],  canon:k._0, block:b[12]},
			'0687':{ u:'0687', i:1568, name:'ARABIC LETTER TCHEHEH', cat:c.Lo,  relatives:['fb7e', 'fb7f', 'fb80', 'fb81'],  canon:k._0, block:b[12]},
			'0688':{ u:'0688', i:1569, name:'ARABIC LETTER DDAL', cat:c.Lo,  relatives:['fb88', 'fb89'],  canon:k._0, block:b[12]},
			'0689':{ u:'0689', i:1570, name:'ARABIC LETTER DAL WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'068a':{ u:'068a', i:1571, name:'ARABIC LETTER DAL WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'068b':{ u:'068b', i:1572, name:'ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH', cat:c.Lo,   canon:k._0, block:b[12]},
			'068c':{ u:'068c', i:1573, name:'ARABIC LETTER DAHAL', cat:c.Lo,  relatives:['fb84', 'fb85'],  canon:k._0, block:b[12]},
			'068d':{ u:'068d', i:1574, name:'ARABIC LETTER DDAHAL', cat:c.Lo,  relatives:['fb82', 'fb83'],  canon:k._0, block:b[12]},
			'068e':{ u:'068e', i:1575, name:'ARABIC LETTER DUL', cat:c.Lo,  relatives:['fb86', 'fb87'],  canon:k._0, block:b[12]},
			'068f':{ u:'068f', i:1576, name:'ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS', cat:c.Lo,   canon:k._0, block:b[12]},
			'0690':{ u:'0690', i:1577, name:'ARABIC LETTER DAL WITH FOUR DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0691':{ u:'0691', i:1578, name:'ARABIC LETTER RREH', cat:c.Lo,  relatives:['fb8c', 'fb8d'],  canon:k._0, block:b[12]},
			'0692':{ u:'0692', i:1579, name:'ARABIC LETTER REH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'0693':{ u:'0693', i:1580, name:'ARABIC LETTER REH WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'0694':{ u:'0694', i:1581, name:'ARABIC LETTER REH WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'0695':{ u:'0695', i:1582, name:'ARABIC LETTER REH WITH SMALL V BELOW', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'0696':{ u:'0696', i:1583, name:'ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0697':{ u:'0697', i:1584, name:'ARABIC LETTER REH WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'0698':{ u:'0698', i:1585, name:'ARABIC LETTER JEH', cat:c.Lo,  relatives:['fb8a', 'fb8b'],  canon:k._0, block:b[12]},
			'0699':{ u:'0699', i:1586, name:'ARABIC LETTER REH WITH FOUR DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'069a':{ u:'069a', i:1587, name:'ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'069b':{ u:'069b', i:1588, name:'ARABIC LETTER SEEN WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'069c':{ u:'069c', i:1589, name:'ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'069d':{ u:'069d', i:1590, name:'ARABIC LETTER SAD WITH TWO DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'069e':{ u:'069e', i:1591, name:'ARABIC LETTER SAD WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'069f':{ u:'069f', i:1592, name:'ARABIC LETTER TAH WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a0':{ u:'06a0', i:1593, name:'ARABIC LETTER AIN WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a1':{ u:'06a1', i:1594, name:'ARABIC LETTER DOTLESS FEH', cat:c.Lo,  relatives:['1ee1e', '1ee7e'],  canon:k._0, block:b[12]},
			'06a2':{ u:'06a2', i:1595, name:'ARABIC LETTER FEH WITH DOT MOVED BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a3':{ u:'06a3', i:1596, name:'ARABIC LETTER FEH WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a4':{ u:'06a4', i:1597, name:'ARABIC LETTER VEH', cat:c.Lo,  relatives:['fb6a', 'fb6b', 'fb6c', 'fb6d'],  canon:k._0, block:b[12]},
			'06a5':{ u:'06a5', i:1598, name:'ARABIC LETTER FEH WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a6':{ u:'06a6', i:1599, name:'ARABIC LETTER PEHEH', cat:c.Lo,  relatives:['fb6e', 'fb6f', 'fb70', 'fb71'],  canon:k._0, block:b[12]},
			'06a7':{ u:'06a7', i:1600, name:'ARABIC LETTER QAF WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a8':{ u:'06a8', i:1601, name:'ARABIC LETTER QAF WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06a9':{ u:'06a9', i:1602, name:'ARABIC LETTER KEHEH', cat:c.Lo,  relatives:['fb8e', 'fb8f', 'fb90', 'fb91'],  canon:k._0, block:b[12]},
			'06aa':{ u:'06aa', i:1603, name:'ARABIC LETTER SWASH KAF', cat:c.Lo,   canon:k._0, block:b[12]},
			'06ab':{ u:'06ab', i:1604, name:'ARABIC LETTER KAF WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'06ac':{ u:'06ac', i:1605, name:'ARABIC LETTER KAF WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06ad':{ u:'06ad', i:1606, name:'ARABIC LETTER NG', cat:c.Lo,  relatives:['fbd3', 'fbd4', 'fbd5', 'fbd6'],  canon:k._0, block:b[12]},
			'06ae':{ u:'06ae', i:1607, name:'ARABIC LETTER KAF WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06af':{ u:'06af', i:1608, name:'ARABIC LETTER GAF', cat:c.Lo,  relatives:['fb92', 'fb93', 'fb94', 'fb95'],  canon:k._0, block:b[12]},
			'06b0':{ u:'06b0', i:1609, name:'ARABIC LETTER GAF WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b1':{ u:'06b1', i:1610, name:'ARABIC LETTER NGOEH', cat:c.Lo,  relatives:['fb9a', 'fb9b', 'fb9c', 'fb9d'],  canon:k._0, block:b[12]},
			'06b2':{ u:'06b2', i:1611, name:'ARABIC LETTER GAF WITH TWO DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b3':{ u:'06b3', i:1612, name:'ARABIC LETTER GUEH', cat:c.Lo,  relatives:['fb96', 'fb97', 'fb98', 'fb99'],  canon:k._0, block:b[12]},
			'06b4':{ u:'06b4', i:1613, name:'ARABIC LETTER GAF WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b5':{ u:'06b5', i:1614, name:'ARABIC LETTER LAM WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'06b6':{ u:'06b6', i:1615, name:'ARABIC LETTER LAM WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b7':{ u:'06b7', i:1616, name:'ARABIC LETTER LAM WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b8':{ u:'06b8', i:1617, name:'ARABIC LETTER LAM WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06b9':{ u:'06b9', i:1618, name:'ARABIC LETTER NOON WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06ba':{ u:'06ba', i:1619, name:'ARABIC LETTER NOON GHUNNA', cat:c.Lo,  relatives:['fb9e', 'fb9f', '1ee1d', '1ee5d'],  canon:k._0, block:b[12]},
			'06bb':{ u:'06bb', i:1620, name:'ARABIC LETTER RNOON', cat:c.Lo,  relatives:['fba0', 'fba1', 'fba2', 'fba3'],  canon:k._0, block:b[12]},
			'06bc':{ u:'06bc', i:1621, name:'ARABIC LETTER NOON WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'06bd':{ u:'06bd', i:1622, name:'ARABIC LETTER NOON WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06be':{ u:'06be', i:1623, name:'ARABIC LETTER HEH DOACHASHMEE', cat:c.Lo,  relatives:['fbaa', 'fbab', 'fbac', 'fbad'],  canon:k._0, block:b[12]},
			'06bf':{ u:'06bf', i:1624, name:'ARABIC LETTER TCHEH WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06c0':{ u:'06c0', i:1625, name:'ARABIC LETTER HEH WITH YEH ABOVE', cat:c.Lo,  relatives:['06d5', '0654', 'fba4', 'fba5'], comp:['06d5','0654'], canon:k._0, block:b[12]},
			'06c1':{ u:'06c1', i:1626, name:'ARABIC LETTER HEH GOAL', cat:c.Lo,  relatives:['06c2', 'fba6', 'fba7', 'fba8', 'fba9'],  canon:k._0, block:b[12]},
			'06c2':{ u:'06c2', i:1627, name:'ARABIC LETTER HEH GOAL WITH HAMZA ABOVE', cat:c.Lo,  relatives:['06c1', '0654'], comp:['06c1','0654'], canon:k._0, block:b[12]},
			'06c3':{ u:'06c3', i:1628, name:'ARABIC LETTER TEH MARBUTA GOAL', cat:c.Lo,   canon:k._0, block:b[12]},
			'06c4':{ u:'06c4', i:1629, name:'ARABIC LETTER WAW WITH RING', cat:c.Lo,   canon:k._0, block:b[12]},
			'06c5':{ u:'06c5', i:1630, name:'ARABIC LETTER KIRGHIZ OE', cat:c.Lo,  relatives:['fbe0', 'fbe1'],  canon:k._0, block:b[12]},
			'06c6':{ u:'06c6', i:1631, name:'ARABIC LETTER OE', cat:c.Lo,  relatives:['fbd9', 'fbda', 'fbf2', 'fbf3'],  canon:k._0, block:b[12]},
			'06c7':{ u:'06c7', i:1632, name:'ARABIC LETTER U', cat:c.Lo,  relatives:['0677', 'fbd7', 'fbd8', 'fbf0', 'fbf1'],  canon:k._0, block:b[12], indexed:["U"]},
			'06c8':{ u:'06c8', i:1633, name:'ARABIC LETTER YU', cat:c.Lo,  relatives:['fbdb', 'fbdc', 'fbf4', 'fbf5'],  canon:k._0, block:b[12]},
			'06c9':{ u:'06c9', i:1634, name:'ARABIC LETTER KIRGHIZ YU', cat:c.Lo,  relatives:['fbe2', 'fbe3'],  canon:k._0, block:b[12]},
			'06ca':{ u:'06ca', i:1635, name:'ARABIC LETTER WAW WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06cb':{ u:'06cb', i:1636, name:'ARABIC LETTER VE', cat:c.Lo,  relatives:['fbde', 'fbdf'],  canon:k._0, block:b[12]},
			'06cc':{ u:'06cc', i:1637, name:'ARABIC LETTER FARSI YEH', cat:c.Lo,  relatives:['fbfc', 'fbfd', 'fbfe', 'fbff', 'fdfc'],  canon:k._0, block:b[12]},
			'06cd':{ u:'06cd', i:1638, name:'ARABIC LETTER YEH WITH TAIL', cat:c.Lo,   canon:k._0, block:b[12]},
			'06ce':{ u:'06ce', i:1639, name:'ARABIC LETTER YEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'06cf':{ u:'06cf', i:1640, name:'ARABIC LETTER WAW WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[12]},
			'06d0':{ u:'06d0', i:1641, name:'ARABIC LETTER E', cat:c.Lo,  relatives:['fbe4', 'fbe5', 'fbe6', 'fbe7', 'fbf6', 'fbf7', 'fbf8'],  canon:k._0, block:b[12], indexed:["E"]},
			'06d1':{ u:'06d1', i:1642, name:'ARABIC LETTER YEH WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06d2':{ u:'06d2', i:1643, name:'ARABIC LETTER YEH BARREE', cat:c.Lo,  relatives:['06d3', 'fbae', 'fbaf', 'fdf0', 'fdf1'],  canon:k._0, block:b[12]},
			'06d3':{ u:'06d3', i:1644, name:'ARABIC LETTER YEH BARREE WITH HAMZA ABOVE', cat:c.Lo,  relatives:['06d2', '0654', 'fbb0', 'fbb1'], comp:['06d2','0654'], canon:k._0, block:b[12]},
			'06d4':{ u:'06d4', i:1645, name:'ARABIC FULL STOP', cat:c.Po,   canon:k._0, block:b[12]},
			'06d5':{ u:'06d5', i:1646, name:'ARABIC LETTER AE', cat:c.Lo,  relatives:['06c0', 'fbec', 'fbed'],  canon:k._0, block:b[12]},
			'06d6':{ u:'06d6', i:1647, name:'ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA', cat:c.Mn,   canon:k._230, block:b[12]},
			'06d7':{ u:'06d7', i:1648, name:'ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA', cat:c.Mn,   canon:k._230, block:b[12]},
			'06d8':{ u:'06d8', i:1649, name:'ARABIC SMALL HIGH MEEM INITIAL FORM', cat:c.Mn,   canon:k._230, block:b[12]},
			'06d9':{ u:'06d9', i:1650, name:'ARABIC SMALL HIGH LAM ALEF', cat:c.Mn,   canon:k._230, block:b[12]},
			'06da':{ u:'06da', i:1651, name:'ARABIC SMALL HIGH JEEM', cat:c.Mn,   canon:k._230, block:b[12]},
			'06db':{ u:'06db', i:1652, name:'ARABIC SMALL HIGH THREE DOTS', cat:c.Mn,   canon:k._230, block:b[12]},
			'06dc':{ u:'06dc', i:1653, name:'ARABIC SMALL HIGH SEEN', cat:c.Mn,   canon:k._230, block:b[12]},
			'06dd':{ u:'06dd', i:1654, name:'ARABIC END OF AYAH', cat:c.Cf,   canon:k._0, block:b[12]},
			'06de':{ u:'06de', i:1655, name:'ARABIC START OF RUB EL HIZB', cat:c.So,   canon:k._0, block:b[12]},
			'06df':{ u:'06df', i:1656, name:'ARABIC SMALL HIGH ROUNDED ZERO', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e0':{ u:'06e0', i:1657, name:'ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e1':{ u:'06e1', i:1658, name:'ARABIC SMALL HIGH DOTLESS HEAD OF KHAH', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e2':{ u:'06e2', i:1659, name:'ARABIC SMALL HIGH MEEM ISOLATED FORM', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e3':{ u:'06e3', i:1660, name:'ARABIC SMALL LOW SEEN', cat:c.Mn,   canon:k._220, block:b[12]},
			'06e4':{ u:'06e4', i:1661, name:'ARABIC SMALL HIGH MADDA', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e5':{ u:'06e5', i:1662, name:'ARABIC SMALL WAW', cat:c.Lm,   canon:k._0, block:b[12]},
			'06e6':{ u:'06e6', i:1663, name:'ARABIC SMALL YEH', cat:c.Lm,   canon:k._0, block:b[12]},
			'06e7':{ u:'06e7', i:1664, name:'ARABIC SMALL HIGH YEH', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e8':{ u:'06e8', i:1665, name:'ARABIC SMALL HIGH NOON', cat:c.Mn,   canon:k._230, block:b[12]},
			'06e9':{ u:'06e9', i:1666, name:'ARABIC PLACE OF SAJDAH', cat:c.So,   canon:k._0, block:b[12]},
			'06ea':{ u:'06ea', i:1667, name:'ARABIC EMPTY CENTRE LOW STOP', cat:c.Mn,   canon:k._220, block:b[12]},
			'06eb':{ u:'06eb', i:1668, name:'ARABIC EMPTY CENTRE HIGH STOP', cat:c.Mn,   canon:k._230, block:b[12]},
			'06ec':{ u:'06ec', i:1669, name:'ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE', cat:c.Mn,   canon:k._230, block:b[12]},
			'06ed':{ u:'06ed', i:1670, name:'ARABIC SMALL LOW MEEM', cat:c.Mn,   canon:k._220, block:b[12]},
			'06ee':{ u:'06ee', i:1671, name:'ARABIC LETTER DAL WITH INVERTED V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'06ef':{ u:'06ef', i:1672, name:'ARABIC LETTER REH WITH INVERTED V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'06f0':{ u:'06f0', i:1673, name:'EXTENDED ARABIC-INDIC DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f1':{ u:'06f1', i:1674, name:'EXTENDED ARABIC-INDIC DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f2':{ u:'06f2', i:1675, name:'EXTENDED ARABIC-INDIC DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f3':{ u:'06f3', i:1676, name:'EXTENDED ARABIC-INDIC DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f4':{ u:'06f4', i:1677, name:'EXTENDED ARABIC-INDIC DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f5':{ u:'06f5', i:1678, name:'EXTENDED ARABIC-INDIC DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f6':{ u:'06f6', i:1679, name:'EXTENDED ARABIC-INDIC DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f7':{ u:'06f7', i:1680, name:'EXTENDED ARABIC-INDIC DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f8':{ u:'06f8', i:1681, name:'EXTENDED ARABIC-INDIC DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[12]},
			'06f9':{ u:'06f9', i:1682, name:'EXTENDED ARABIC-INDIC DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[12]},
			'06fa':{ u:'06fa', i:1683, name:'ARABIC LETTER SHEEN WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06fb':{ u:'06fb', i:1684, name:'ARABIC LETTER DAD WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06fc':{ u:'06fc', i:1685, name:'ARABIC LETTER GHAIN WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[12]},
			'06fd':{ u:'06fd', i:1686, name:'ARABIC SIGN SINDHI AMPERSAND', cat:c.So,   canon:k._0, block:b[12]},
			'06fe':{ u:'06fe', i:1687, name:'ARABIC SIGN SINDHI POSTPOSITION MEN', cat:c.So,   canon:k._0, block:b[12]},
			'06ff':{ u:'06ff', i:1688, name:'ARABIC LETTER HEH WITH INVERTED V', cat:c.Lo,   canon:k._0, block:b[12], indexed:["V"]},
			'0700':{ u:'0700', i:1689, name:'SYRIAC END OF PARAGRAPH', cat:c.Po,   canon:k._0, block:b[13]},
			'0701':{ u:'0701', i:1690, name:'SYRIAC SUPRALINEAR FULL STOP', cat:c.Po,   canon:k._0, block:b[13]},
			'0702':{ u:'0702', i:1691, name:'SYRIAC SUBLINEAR FULL STOP', cat:c.Po,   canon:k._0, block:b[13]},
			'0703':{ u:'0703', i:1692, name:'SYRIAC SUPRALINEAR COLON', cat:c.Po,   canon:k._0, block:b[13]},
			'0704':{ u:'0704', i:1693, name:'SYRIAC SUBLINEAR COLON', cat:c.Po,   canon:k._0, block:b[13]},
			'0705':{ u:'0705', i:1694, name:'SYRIAC HORIZONTAL COLON', cat:c.Po,   canon:k._0, block:b[13]},
			'0706':{ u:'0706', i:1695, name:'SYRIAC COLON SKEWED LEFT', cat:c.Po,   canon:k._0, block:b[13]},
			'0707':{ u:'0707', i:1696, name:'SYRIAC COLON SKEWED RIGHT', cat:c.Po,   canon:k._0, block:b[13]},
			'0708':{ u:'0708', i:1697, name:'SYRIAC SUPRALINEAR COLON SKEWED LEFT', cat:c.Po,   canon:k._0, block:b[13]},
			'0709':{ u:'0709', i:1698, name:'SYRIAC SUBLINEAR COLON SKEWED RIGHT', cat:c.Po,   canon:k._0, block:b[13]},
			'070a':{ u:'070a', i:1699, name:'SYRIAC CONTRACTION', cat:c.Po,   canon:k._0, block:b[13]},
			'070b':{ u:'070b', i:1700, name:'SYRIAC HARKLEAN OBELUS', cat:c.Po,   canon:k._0, block:b[13]},
			'070c':{ u:'070c', i:1701, name:'SYRIAC HARKLEAN METOBELUS', cat:c.Po,   canon:k._0, block:b[13]},
			'070d':{ u:'070d', i:1702, name:'SYRIAC HARKLEAN ASTERISCUS', cat:c.Po,   canon:k._0, block:b[13]},
			'070f':{ u:'070f', i:1703, name:'SYRIAC ABBREVIATION MARK', cat:c.Cf,   canon:k._0, block:b[13]},
			'0710':{ u:'0710', i:1704, name:'SYRIAC LETTER ALAPH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0711':{ u:'0711', i:1705, name:'SYRIAC LETTER SUPERSCRIPT ALAPH', cat:c.Mn,   canon:k._36, block:b[13]},
			'0712':{ u:'0712', i:1706, name:'SYRIAC LETTER BETH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0713':{ u:'0713', i:1707, name:'SYRIAC LETTER GAMAL', cat:c.Lo,   canon:k._0, block:b[13]},
			'0714':{ u:'0714', i:1708, name:'SYRIAC LETTER GAMAL GARSHUNI', cat:c.Lo,   canon:k._0, block:b[13]},
			'0715':{ u:'0715', i:1709, name:'SYRIAC LETTER DALATH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0716':{ u:'0716', i:1710, name:'SYRIAC LETTER DOTLESS DALATH RISH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0717':{ u:'0717', i:1711, name:'SYRIAC LETTER HE', cat:c.Lo,   canon:k._0, block:b[13]},
			'0718':{ u:'0718', i:1712, name:'SYRIAC LETTER WAW', cat:c.Lo,   canon:k._0, block:b[13]},
			'0719':{ u:'0719', i:1713, name:'SYRIAC LETTER ZAIN', cat:c.Lo,   canon:k._0, block:b[13]},
			'071a':{ u:'071a', i:1714, name:'SYRIAC LETTER HETH', cat:c.Lo,   canon:k._0, block:b[13]},
			'071b':{ u:'071b', i:1715, name:'SYRIAC LETTER TETH', cat:c.Lo,   canon:k._0, block:b[13]},
			'071c':{ u:'071c', i:1716, name:'SYRIAC LETTER TETH GARSHUNI', cat:c.Lo,   canon:k._0, block:b[13]},
			'071d':{ u:'071d', i:1717, name:'SYRIAC LETTER YUDH', cat:c.Lo,   canon:k._0, block:b[13]},
			'071e':{ u:'071e', i:1718, name:'SYRIAC LETTER YUDH HE', cat:c.Lo,   canon:k._0, block:b[13]},
			'071f':{ u:'071f', i:1719, name:'SYRIAC LETTER KAPH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0720':{ u:'0720', i:1720, name:'SYRIAC LETTER LAMADH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0721':{ u:'0721', i:1721, name:'SYRIAC LETTER MIM', cat:c.Lo,   canon:k._0, block:b[13]},
			'0722':{ u:'0722', i:1722, name:'SYRIAC LETTER NUN', cat:c.Lo,   canon:k._0, block:b[13]},
			'0723':{ u:'0723', i:1723, name:'SYRIAC LETTER SEMKATH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0724':{ u:'0724', i:1724, name:'SYRIAC LETTER FINAL SEMKATH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0725':{ u:'0725', i:1725, name:'SYRIAC LETTER E', cat:c.Lo,   canon:k._0, block:b[13], indexed:["E"]},
			'0726':{ u:'0726', i:1726, name:'SYRIAC LETTER PE', cat:c.Lo,   canon:k._0, block:b[13]},
			'0727':{ u:'0727', i:1727, name:'SYRIAC LETTER REVERSED PE', cat:c.Lo,   canon:k._0, block:b[13]},
			'0728':{ u:'0728', i:1728, name:'SYRIAC LETTER SADHE', cat:c.Lo,   canon:k._0, block:b[13]},
			'0729':{ u:'0729', i:1729, name:'SYRIAC LETTER QAPH', cat:c.Lo,   canon:k._0, block:b[13]},
			'072a':{ u:'072a', i:1730, name:'SYRIAC LETTER RISH', cat:c.Lo,   canon:k._0, block:b[13]},
			'072b':{ u:'072b', i:1731, name:'SYRIAC LETTER SHIN', cat:c.Lo,   canon:k._0, block:b[13]},
			'072c':{ u:'072c', i:1732, name:'SYRIAC LETTER TAW', cat:c.Lo,   canon:k._0, block:b[13]},
			'072d':{ u:'072d', i:1733, name:'SYRIAC LETTER PERSIAN BHETH', cat:c.Lo,   canon:k._0, block:b[13]},
			'072e':{ u:'072e', i:1734, name:'SYRIAC LETTER PERSIAN GHAMAL', cat:c.Lo,   canon:k._0, block:b[13]},
			'072f':{ u:'072f', i:1735, name:'SYRIAC LETTER PERSIAN DHALATH', cat:c.Lo,   canon:k._0, block:b[13]},
			'0730':{ u:'0730', i:1736, name:'SYRIAC PTHAHA ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0731':{ u:'0731', i:1737, name:'SYRIAC PTHAHA BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0732':{ u:'0732', i:1738, name:'SYRIAC PTHAHA DOTTED', cat:c.Mn,   canon:k._230, block:b[13]},
			'0733':{ u:'0733', i:1739, name:'SYRIAC ZQAPHA ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0734':{ u:'0734', i:1740, name:'SYRIAC ZQAPHA BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0735':{ u:'0735', i:1741, name:'SYRIAC ZQAPHA DOTTED', cat:c.Mn,   canon:k._230, block:b[13]},
			'0736':{ u:'0736', i:1742, name:'SYRIAC RBASA ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0737':{ u:'0737', i:1743, name:'SYRIAC RBASA BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0738':{ u:'0738', i:1744, name:'SYRIAC DOTTED ZLAMA HORIZONTAL', cat:c.Mn,   canon:k._220, block:b[13]},
			'0739':{ u:'0739', i:1745, name:'SYRIAC DOTTED ZLAMA ANGULAR', cat:c.Mn,   canon:k._220, block:b[13]},
			'073a':{ u:'073a', i:1746, name:'SYRIAC HBASA ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'073b':{ u:'073b', i:1747, name:'SYRIAC HBASA BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'073c':{ u:'073c', i:1748, name:'SYRIAC HBASA-ESASA DOTTED', cat:c.Mn,   canon:k._220, block:b[13]},
			'073d':{ u:'073d', i:1749, name:'SYRIAC ESASA ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'073e':{ u:'073e', i:1750, name:'SYRIAC ESASA BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'073f':{ u:'073f', i:1751, name:'SYRIAC RWAHA', cat:c.Mn,   canon:k._230, block:b[13]},
			'0740':{ u:'0740', i:1752, name:'SYRIAC FEMININE DOT', cat:c.Mn,   canon:k._230, block:b[13]},
			'0741':{ u:'0741', i:1753, name:'SYRIAC QUSHSHAYA', cat:c.Mn,   canon:k._230, block:b[13]},
			'0742':{ u:'0742', i:1754, name:'SYRIAC RUKKAKHA', cat:c.Mn,   canon:k._220, block:b[13]},
			'0743':{ u:'0743', i:1755, name:'SYRIAC TWO VERTICAL DOTS ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0744':{ u:'0744', i:1756, name:'SYRIAC TWO VERTICAL DOTS BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0745':{ u:'0745', i:1757, name:'SYRIAC THREE DOTS ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0746':{ u:'0746', i:1758, name:'SYRIAC THREE DOTS BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0747':{ u:'0747', i:1759, name:'SYRIAC OBLIQUE LINE ABOVE', cat:c.Mn,   canon:k._230, block:b[13]},
			'0748':{ u:'0748', i:1760, name:'SYRIAC OBLIQUE LINE BELOW', cat:c.Mn,   canon:k._220, block:b[13]},
			'0749':{ u:'0749', i:1761, name:'SYRIAC MUSIC', cat:c.Mn,   canon:k._230, block:b[13]},
			'074a':{ u:'074a', i:1762, name:'SYRIAC BARREKH', cat:c.Mn,   canon:k._230, block:b[13]},
			'074d':{ u:'074d', i:1763, name:'SYRIAC LETTER SOGDIAN ZHAIN', cat:c.Lo,   canon:k._0, block:b[13]},
			'074e':{ u:'074e', i:1764, name:'SYRIAC LETTER SOGDIAN KHAPH', cat:c.Lo,   canon:k._0, block:b[13]},
			'074f':{ u:'074f', i:1765, name:'SYRIAC LETTER SOGDIAN FE', cat:c.Lo,   canon:k._0, block:b[13]},
			'0750':{ u:'0750', i:1766, name:'ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0751':{ u:'0751', i:1767, name:'ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0752':{ u:'0752', i:1768, name:'ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0753':{ u:'0753', i:1769, name:'ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0754':{ u:'0754', i:1770, name:'ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0755':{ u:'0755', i:1771, name:'ARABIC LETTER BEH WITH INVERTED SMALL V BELOW', cat:c.Lo,   canon:k._0, block:b[14], indexed:["V"]},
			'0756':{ u:'0756', i:1772, name:'ARABIC LETTER BEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[14], indexed:["V"]},
			'0757':{ u:'0757', i:1773, name:'ARABIC LETTER HAH WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0758':{ u:'0758', i:1774, name:'ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0759':{ u:'0759', i:1775, name:'ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH', cat:c.Lo,   canon:k._0, block:b[14]},
			'075a':{ u:'075a', i:1776, name:'ARABIC LETTER DAL WITH INVERTED SMALL V BELOW', cat:c.Lo,   canon:k._0, block:b[14], indexed:["V"]},
			'075b':{ u:'075b', i:1777, name:'ARABIC LETTER REH WITH STROKE', cat:c.Lo,   canon:k._0, block:b[14]},
			'075c':{ u:'075c', i:1778, name:'ARABIC LETTER SEEN WITH FOUR DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'075d':{ u:'075d', i:1779, name:'ARABIC LETTER AIN WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'075e':{ u:'075e', i:1780, name:'ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'075f':{ u:'075f', i:1781, name:'ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0760':{ u:'0760', i:1782, name:'ARABIC LETTER FEH WITH TWO DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0761':{ u:'0761', i:1783, name:'ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0762':{ u:'0762', i:1784, name:'ARABIC LETTER KEHEH WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0763':{ u:'0763', i:1785, name:'ARABIC LETTER KEHEH WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0764':{ u:'0764', i:1786, name:'ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0765':{ u:'0765', i:1787, name:'ARABIC LETTER MEEM WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0766':{ u:'0766', i:1788, name:'ARABIC LETTER MEEM WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0767':{ u:'0767', i:1789, name:'ARABIC LETTER NOON WITH TWO DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0768':{ u:'0768', i:1790, name:'ARABIC LETTER NOON WITH SMALL TAH', cat:c.Lo,   canon:k._0, block:b[14]},
			'0769':{ u:'0769', i:1791, name:'ARABIC LETTER NOON WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[14], indexed:["V"]},
			'076a':{ u:'076a', i:1792, name:'ARABIC LETTER LAM WITH BAR', cat:c.Lo,   canon:k._0, block:b[14]},
			'076b':{ u:'076b', i:1793, name:'ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'076c':{ u:'076c', i:1794, name:'ARABIC LETTER REH WITH HAMZA ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'076d':{ u:'076d', i:1795, name:'ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'076e':{ u:'076e', i:1796, name:'ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'076f':{ u:'076f', i:1797, name:'ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS', cat:c.Lo,   canon:k._0, block:b[14]},
			'0770':{ u:'0770', i:1798, name:'ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS', cat:c.Lo,   canon:k._0, block:b[14]},
			'0771':{ u:'0771', i:1799, name:'ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS', cat:c.Lo,   canon:k._0, block:b[14]},
			'0772':{ u:'0772', i:1800, name:'ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0773':{ u:'0773', i:1801, name:'ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0774':{ u:'0774', i:1802, name:'ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0775':{ u:'0775', i:1803, name:'ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0776':{ u:'0776', i:1804, name:'ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0777':{ u:'0777', i:1805, name:'ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'0778':{ u:'0778', i:1806, name:'ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0779':{ u:'0779', i:1807, name:'ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'077a':{ u:'077a', i:1808, name:'ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'077b':{ u:'077b', i:1809, name:'ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'077c':{ u:'077c', i:1810, name:'ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW', cat:c.Lo,   canon:k._0, block:b[14]},
			'077d':{ u:'077d', i:1811, name:'ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'077e':{ u:'077e', i:1812, name:'ARABIC LETTER SEEN WITH INVERTED V', cat:c.Lo,   canon:k._0, block:b[14], indexed:["V"]},
			'077f':{ u:'077f', i:1813, name:'ARABIC LETTER KAF WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[14]},
			'0780':{ u:'0780', i:1814, name:'THAANA LETTER HAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'0781':{ u:'0781', i:1815, name:'THAANA LETTER SHAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0782':{ u:'0782', i:1816, name:'THAANA LETTER NOONU', cat:c.Lo,   canon:k._0, block:b[15]},
			'0783':{ u:'0783', i:1817, name:'THAANA LETTER RAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'0784':{ u:'0784', i:1818, name:'THAANA LETTER BAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'0785':{ u:'0785', i:1819, name:'THAANA LETTER LHAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0786':{ u:'0786', i:1820, name:'THAANA LETTER KAAFU', cat:c.Lo,   canon:k._0, block:b[15]},
			'0787':{ u:'0787', i:1821, name:'THAANA LETTER ALIFU', cat:c.Lo,   canon:k._0, block:b[15]},
			'0788':{ u:'0788', i:1822, name:'THAANA LETTER VAAVU', cat:c.Lo,   canon:k._0, block:b[15]},
			'0789':{ u:'0789', i:1823, name:'THAANA LETTER MEEMU', cat:c.Lo,   canon:k._0, block:b[15]},
			'078a':{ u:'078a', i:1824, name:'THAANA LETTER FAAFU', cat:c.Lo,   canon:k._0, block:b[15]},
			'078b':{ u:'078b', i:1825, name:'THAANA LETTER DHAALU', cat:c.Lo,   canon:k._0, block:b[15]},
			'078c':{ u:'078c', i:1826, name:'THAANA LETTER THAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'078d':{ u:'078d', i:1827, name:'THAANA LETTER LAAMU', cat:c.Lo,   canon:k._0, block:b[15]},
			'078e':{ u:'078e', i:1828, name:'THAANA LETTER GAAFU', cat:c.Lo,   canon:k._0, block:b[15]},
			'078f':{ u:'078f', i:1829, name:'THAANA LETTER GNAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0790':{ u:'0790', i:1830, name:'THAANA LETTER SEENU', cat:c.Lo,   canon:k._0, block:b[15]},
			'0791':{ u:'0791', i:1831, name:'THAANA LETTER DAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0792':{ u:'0792', i:1832, name:'THAANA LETTER ZAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0793':{ u:'0793', i:1833, name:'THAANA LETTER TAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0794':{ u:'0794', i:1834, name:'THAANA LETTER YAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'0795':{ u:'0795', i:1835, name:'THAANA LETTER PAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0796':{ u:'0796', i:1836, name:'THAANA LETTER JAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0797':{ u:'0797', i:1837, name:'THAANA LETTER CHAVIYANI', cat:c.Lo,   canon:k._0, block:b[15]},
			'0798':{ u:'0798', i:1838, name:'THAANA LETTER TTAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'0799':{ u:'0799', i:1839, name:'THAANA LETTER HHAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'079a':{ u:'079a', i:1840, name:'THAANA LETTER KHAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'079b':{ u:'079b', i:1841, name:'THAANA LETTER THAALU', cat:c.Lo,   canon:k._0, block:b[15]},
			'079c':{ u:'079c', i:1842, name:'THAANA LETTER ZAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'079d':{ u:'079d', i:1843, name:'THAANA LETTER SHEENU', cat:c.Lo,   canon:k._0, block:b[15]},
			'079e':{ u:'079e', i:1844, name:'THAANA LETTER SAADHU', cat:c.Lo,   canon:k._0, block:b[15]},
			'079f':{ u:'079f', i:1845, name:'THAANA LETTER DAADHU', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a0':{ u:'07a0', i:1846, name:'THAANA LETTER TO', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a1':{ u:'07a1', i:1847, name:'THAANA LETTER ZO', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a2':{ u:'07a2', i:1848, name:'THAANA LETTER AINU', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a3':{ u:'07a3', i:1849, name:'THAANA LETTER GHAINU', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a4':{ u:'07a4', i:1850, name:'THAANA LETTER QAAFU', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a5':{ u:'07a5', i:1851, name:'THAANA LETTER WAAVU', cat:c.Lo,   canon:k._0, block:b[15]},
			'07a6':{ u:'07a6', i:1852, name:'THAANA ABAFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07a7':{ u:'07a7', i:1853, name:'THAANA AABAAFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07a8':{ u:'07a8', i:1854, name:'THAANA IBIFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07a9':{ u:'07a9', i:1855, name:'THAANA EEBEEFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07aa':{ u:'07aa', i:1856, name:'THAANA UBUFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07ab':{ u:'07ab', i:1857, name:'THAANA OOBOOFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07ac':{ u:'07ac', i:1858, name:'THAANA EBEFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07ad':{ u:'07ad', i:1859, name:'THAANA EYBEYFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07ae':{ u:'07ae', i:1860, name:'THAANA OBOFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07af':{ u:'07af', i:1861, name:'THAANA OABOAFILI', cat:c.Mn,   canon:k._0, block:b[15]},
			'07b0':{ u:'07b0', i:1862, name:'THAANA SUKUN', cat:c.Mn,   canon:k._0, block:b[15]},
			'07b1':{ u:'07b1', i:1863, name:'THAANA LETTER NAA', cat:c.Lo,   canon:k._0, block:b[15]},
			'07c0':{ u:'07c0', i:1864, name:'NKO DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c1':{ u:'07c1', i:1865, name:'NKO DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c2':{ u:'07c2', i:1866, name:'NKO DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c3':{ u:'07c3', i:1867, name:'NKO DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c4':{ u:'07c4', i:1868, name:'NKO DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c5':{ u:'07c5', i:1869, name:'NKO DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c6':{ u:'07c6', i:1870, name:'NKO DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c7':{ u:'07c7', i:1871, name:'NKO DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c8':{ u:'07c8', i:1872, name:'NKO DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[16]},
			'07c9':{ u:'07c9', i:1873, name:'NKO DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[16]},
			'07ca':{ u:'07ca', i:1874, name:'NKO LETTER A', cat:c.Lo,   canon:k._0, block:b[16], indexed:["A"]},
			'07cb':{ u:'07cb', i:1875, name:'NKO LETTER EE', cat:c.Lo,   canon:k._0, block:b[16]},
			'07cc':{ u:'07cc', i:1876, name:'NKO LETTER I', cat:c.Lo,   canon:k._0, block:b[16], indexed:["I"]},
			'07cd':{ u:'07cd', i:1877, name:'NKO LETTER E', cat:c.Lo,   canon:k._0, block:b[16], indexed:["E"]},
			'07ce':{ u:'07ce', i:1878, name:'NKO LETTER U', cat:c.Lo,   canon:k._0, block:b[16], indexed:["U"]},
			'07cf':{ u:'07cf', i:1879, name:'NKO LETTER OO', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d0':{ u:'07d0', i:1880, name:'NKO LETTER O', cat:c.Lo,   canon:k._0, block:b[16], indexed:["O"]},
			'07d1':{ u:'07d1', i:1881, name:'NKO LETTER DAGBASINNA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d2':{ u:'07d2', i:1882, name:'NKO LETTER N', cat:c.Lo,   canon:k._0, block:b[16], indexed:["N"]},
			'07d3':{ u:'07d3', i:1883, name:'NKO LETTER BA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d4':{ u:'07d4', i:1884, name:'NKO LETTER PA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d5':{ u:'07d5', i:1885, name:'NKO LETTER TA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d6':{ u:'07d6', i:1886, name:'NKO LETTER JA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d7':{ u:'07d7', i:1887, name:'NKO LETTER CHA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d8':{ u:'07d8', i:1888, name:'NKO LETTER DA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07d9':{ u:'07d9', i:1889, name:'NKO LETTER RA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07da':{ u:'07da', i:1890, name:'NKO LETTER RRA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07db':{ u:'07db', i:1891, name:'NKO LETTER SA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07dc':{ u:'07dc', i:1892, name:'NKO LETTER GBA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07dd':{ u:'07dd', i:1893, name:'NKO LETTER FA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07de':{ u:'07de', i:1894, name:'NKO LETTER KA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07df':{ u:'07df', i:1895, name:'NKO LETTER LA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e0':{ u:'07e0', i:1896, name:'NKO LETTER NA WOLOSO', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e1':{ u:'07e1', i:1897, name:'NKO LETTER MA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e2':{ u:'07e2', i:1898, name:'NKO LETTER NYA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e3':{ u:'07e3', i:1899, name:'NKO LETTER NA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e4':{ u:'07e4', i:1900, name:'NKO LETTER HA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e5':{ u:'07e5', i:1901, name:'NKO LETTER WA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e6':{ u:'07e6', i:1902, name:'NKO LETTER YA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e7':{ u:'07e7', i:1903, name:'NKO LETTER NYA WOLOSO', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e8':{ u:'07e8', i:1904, name:'NKO LETTER JONA JA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07e9':{ u:'07e9', i:1905, name:'NKO LETTER JONA CHA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07ea':{ u:'07ea', i:1906, name:'NKO LETTER JONA RA', cat:c.Lo,   canon:k._0, block:b[16]},
			'07eb':{ u:'07eb', i:1907, name:'NKO COMBINING SHORT HIGH TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07ec':{ u:'07ec', i:1908, name:'NKO COMBINING SHORT LOW TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07ed':{ u:'07ed', i:1909, name:'NKO COMBINING SHORT RISING TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07ee':{ u:'07ee', i:1910, name:'NKO COMBINING LONG DESCENDING TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07ef':{ u:'07ef', i:1911, name:'NKO COMBINING LONG HIGH TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07f0':{ u:'07f0', i:1912, name:'NKO COMBINING LONG LOW TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07f1':{ u:'07f1', i:1913, name:'NKO COMBINING LONG RISING TONE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07f2':{ u:'07f2', i:1914, name:'NKO COMBINING NASALIZATION MARK', cat:c.Mn,   canon:k._220, block:b[16]},
			'07f3':{ u:'07f3', i:1915, name:'NKO COMBINING DOUBLE DOT ABOVE', cat:c.Mn,   canon:k._230, block:b[16]},
			'07f4':{ u:'07f4', i:1916, name:'NKO HIGH TONE APOSTROPHE', cat:c.Lm,   canon:k._0, block:b[16]},
			'07f5':{ u:'07f5', i:1917, name:'NKO LOW TONE APOSTROPHE', cat:c.Lm,   canon:k._0, block:b[16]},
			'07f6':{ u:'07f6', i:1918, name:'NKO SYMBOL OO DENNEN', cat:c.So,   canon:k._0, block:b[16]},
			'07f7':{ u:'07f7', i:1919, name:'NKO SYMBOL GBAKURUNEN', cat:c.Po,   canon:k._0, block:b[16]},
			'07f8':{ u:'07f8', i:1920, name:'NKO COMMA', cat:c.Po,   canon:k._0, block:b[16]},
			'07f9':{ u:'07f9', i:1921, name:'NKO EXCLAMATION MARK', cat:c.Po,   canon:k._0, block:b[16]},
			'07fa':{ u:'07fa', i:1922, name:'NKO LAJANYALAN', cat:c.Lm,   canon:k._0, block:b[16]},
			'07fd':{ u:'07fd', i:1923, name:'NKO DANTAYALAN', cat:c.Mn,   canon:k._220, block:b[16]},
			'07fe':{ u:'07fe', i:1924, name:'NKO DOROME SIGN', cat:c.Sc,   canon:k._0, block:b[16]},
			'07ff':{ u:'07ff', i:1925, name:'NKO TAMAN SIGN', cat:c.Sc,   canon:k._0, block:b[16]},
			'0800':{ u:'0800', i:1926, name:'SAMARITAN LETTER ALAF', cat:c.Lo,   canon:k._0, block:b[17]},
			'0801':{ u:'0801', i:1927, name:'SAMARITAN LETTER BIT', cat:c.Lo,   canon:k._0, block:b[17]},
			'0802':{ u:'0802', i:1928, name:'SAMARITAN LETTER GAMAN', cat:c.Lo,   canon:k._0, block:b[17]},
			'0803':{ u:'0803', i:1929, name:'SAMARITAN LETTER DALAT', cat:c.Lo,   canon:k._0, block:b[17]},
			'0804':{ u:'0804', i:1930, name:'SAMARITAN LETTER IY', cat:c.Lo,   canon:k._0, block:b[17]},
			'0805':{ u:'0805', i:1931, name:'SAMARITAN LETTER BAA', cat:c.Lo,   canon:k._0, block:b[17]},
			'0806':{ u:'0806', i:1932, name:'SAMARITAN LETTER ZEN', cat:c.Lo,   canon:k._0, block:b[17]},
			'0807':{ u:'0807', i:1933, name:'SAMARITAN LETTER IT', cat:c.Lo,   canon:k._0, block:b[17]},
			'0808':{ u:'0808', i:1934, name:'SAMARITAN LETTER TIT', cat:c.Lo,   canon:k._0, block:b[17]},
			'0809':{ u:'0809', i:1935, name:'SAMARITAN LETTER YUT', cat:c.Lo,   canon:k._0, block:b[17]},
			'080a':{ u:'080a', i:1936, name:'SAMARITAN LETTER KAAF', cat:c.Lo,   canon:k._0, block:b[17]},
			'080b':{ u:'080b', i:1937, name:'SAMARITAN LETTER LABAT', cat:c.Lo,   canon:k._0, block:b[17]},
			'080c':{ u:'080c', i:1938, name:'SAMARITAN LETTER MIM', cat:c.Lo,   canon:k._0, block:b[17]},
			'080d':{ u:'080d', i:1939, name:'SAMARITAN LETTER NUN', cat:c.Lo,   canon:k._0, block:b[17]},
			'080e':{ u:'080e', i:1940, name:'SAMARITAN LETTER SINGAAT', cat:c.Lo,   canon:k._0, block:b[17]},
			'080f':{ u:'080f', i:1941, name:'SAMARITAN LETTER IN', cat:c.Lo,   canon:k._0, block:b[17]},
			'0810':{ u:'0810', i:1942, name:'SAMARITAN LETTER FI', cat:c.Lo,   canon:k._0, block:b[17]},
			'0811':{ u:'0811', i:1943, name:'SAMARITAN LETTER TSAADIY', cat:c.Lo,   canon:k._0, block:b[17]},
			'0812':{ u:'0812', i:1944, name:'SAMARITAN LETTER QUF', cat:c.Lo,   canon:k._0, block:b[17]},
			'0813':{ u:'0813', i:1945, name:'SAMARITAN LETTER RISH', cat:c.Lo,   canon:k._0, block:b[17]},
			'0814':{ u:'0814', i:1946, name:'SAMARITAN LETTER SHAN', cat:c.Lo,   canon:k._0, block:b[17]},
			'0815':{ u:'0815', i:1947, name:'SAMARITAN LETTER TAAF', cat:c.Lo,   canon:k._0, block:b[17]},
			'0816':{ u:'0816', i:1948, name:'SAMARITAN MARK IN', cat:c.Mn,   canon:k._230, block:b[17]},
			'0817':{ u:'0817', i:1949, name:'SAMARITAN MARK IN-ALAF', cat:c.Mn,   canon:k._230, block:b[17]},
			'0818':{ u:'0818', i:1950, name:'SAMARITAN MARK OCCLUSION', cat:c.Mn,   canon:k._230, block:b[17]},
			'0819':{ u:'0819', i:1951, name:'SAMARITAN MARK DAGESH', cat:c.Mn,   canon:k._230, block:b[17]},
			'081a':{ u:'081a', i:1952, name:'SAMARITAN MODIFIER LETTER EPENTHETIC YUT', cat:c.Lm,   canon:k._0, block:b[17]},
			'081b':{ u:'081b', i:1953, name:'SAMARITAN MARK EPENTHETIC YUT', cat:c.Mn,   canon:k._230, block:b[17]},
			'081c':{ u:'081c', i:1954, name:'SAMARITAN VOWEL SIGN LONG E', cat:c.Mn,   canon:k._230, block:b[17], indexed:["E"]},
			'081d':{ u:'081d', i:1955, name:'SAMARITAN VOWEL SIGN E', cat:c.Mn,   canon:k._230, block:b[17], indexed:["E"]},
			'081e':{ u:'081e', i:1956, name:'SAMARITAN VOWEL SIGN OVERLONG AA', cat:c.Mn,   canon:k._230, block:b[17]},
			'081f':{ u:'081f', i:1957, name:'SAMARITAN VOWEL SIGN LONG AA', cat:c.Mn,   canon:k._230, block:b[17]},
			'0820':{ u:'0820', i:1958, name:'SAMARITAN VOWEL SIGN AA', cat:c.Mn,   canon:k._230, block:b[17]},
			'0821':{ u:'0821', i:1959, name:'SAMARITAN VOWEL SIGN OVERLONG A', cat:c.Mn,   canon:k._230, block:b[17], indexed:["A"]},
			'0822':{ u:'0822', i:1960, name:'SAMARITAN VOWEL SIGN LONG A', cat:c.Mn,   canon:k._230, block:b[17], indexed:["A"]},
			'0823':{ u:'0823', i:1961, name:'SAMARITAN VOWEL SIGN A', cat:c.Mn,   canon:k._230, block:b[17], indexed:["A"]},
			'0824':{ u:'0824', i:1962, name:'SAMARITAN MODIFIER LETTER SHORT A', cat:c.Lm,   canon:k._0, block:b[17], indexed:["A"]},
			'0825':{ u:'0825', i:1963, name:'SAMARITAN VOWEL SIGN SHORT A', cat:c.Mn,   canon:k._230, block:b[17], indexed:["A"]},
			'0826':{ u:'0826', i:1964, name:'SAMARITAN VOWEL SIGN LONG U', cat:c.Mn,   canon:k._230, block:b[17], indexed:["U"]},
			'0827':{ u:'0827', i:1965, name:'SAMARITAN VOWEL SIGN U', cat:c.Mn,   canon:k._230, block:b[17], indexed:["U"]},
			'0828':{ u:'0828', i:1966, name:'SAMARITAN MODIFIER LETTER I', cat:c.Lm,   canon:k._0, block:b[17], indexed:["I"]},
			'0829':{ u:'0829', i:1967, name:'SAMARITAN VOWEL SIGN LONG I', cat:c.Mn,   canon:k._230, block:b[17], indexed:["I"]},
			'082a':{ u:'082a', i:1968, name:'SAMARITAN VOWEL SIGN I', cat:c.Mn,   canon:k._230, block:b[17], indexed:["I"]},
			'082b':{ u:'082b', i:1969, name:'SAMARITAN VOWEL SIGN O', cat:c.Mn,   canon:k._230, block:b[17], indexed:["O"]},
			'082c':{ u:'082c', i:1970, name:'SAMARITAN VOWEL SIGN SUKUN', cat:c.Mn,   canon:k._230, block:b[17]},
			'082d':{ u:'082d', i:1971, name:'SAMARITAN MARK NEQUDAA', cat:c.Mn,   canon:k._230, block:b[17]},
			'0830':{ u:'0830', i:1972, name:'SAMARITAN PUNCTUATION NEQUDAA', cat:c.Po,   canon:k._0, block:b[17]},
			'0831':{ u:'0831', i:1973, name:'SAMARITAN PUNCTUATION AFSAAQ', cat:c.Po,   canon:k._0, block:b[17]},
			'0832':{ u:'0832', i:1974, name:'SAMARITAN PUNCTUATION ANGED', cat:c.Po,   canon:k._0, block:b[17]},
			'0833':{ u:'0833', i:1975, name:'SAMARITAN PUNCTUATION BAU', cat:c.Po,   canon:k._0, block:b[17]},
			'0834':{ u:'0834', i:1976, name:'SAMARITAN PUNCTUATION ATMAAU', cat:c.Po,   canon:k._0, block:b[17]},
			'0835':{ u:'0835', i:1977, name:'SAMARITAN PUNCTUATION SHIYYAALAA', cat:c.Po,   canon:k._0, block:b[17]},
			'0836':{ u:'0836', i:1978, name:'SAMARITAN ABBREVIATION MARK', cat:c.Po,   canon:k._0, block:b[17]},
			'0837':{ u:'0837', i:1979, name:'SAMARITAN PUNCTUATION MELODIC QITSA', cat:c.Po,   canon:k._0, block:b[17]},
			'0838':{ u:'0838', i:1980, name:'SAMARITAN PUNCTUATION ZIQAA', cat:c.Po,   canon:k._0, block:b[17]},
			'0839':{ u:'0839', i:1981, name:'SAMARITAN PUNCTUATION QITSA', cat:c.Po,   canon:k._0, block:b[17]},
			'083a':{ u:'083a', i:1982, name:'SAMARITAN PUNCTUATION ZAEF', cat:c.Po,   canon:k._0, block:b[17]},
			'083b':{ u:'083b', i:1983, name:'SAMARITAN PUNCTUATION TURU', cat:c.Po,   canon:k._0, block:b[17]},
			'083c':{ u:'083c', i:1984, name:'SAMARITAN PUNCTUATION ARKAANU', cat:c.Po,   canon:k._0, block:b[17]},
			'083d':{ u:'083d', i:1985, name:'SAMARITAN PUNCTUATION SOF MASHFAAT', cat:c.Po,   canon:k._0, block:b[17]},
			'083e':{ u:'083e', i:1986, name:'SAMARITAN PUNCTUATION ANNAAU', cat:c.Po,   canon:k._0, block:b[17]},
			'0840':{ u:'0840', i:1987, name:'MANDAIC LETTER HALQA', cat:c.Lo,   canon:k._0, block:b[18]},
			'0841':{ u:'0841', i:1988, name:'MANDAIC LETTER AB', cat:c.Lo,   canon:k._0, block:b[18]},
			'0842':{ u:'0842', i:1989, name:'MANDAIC LETTER AG', cat:c.Lo,   canon:k._0, block:b[18]},
			'0843':{ u:'0843', i:1990, name:'MANDAIC LETTER AD', cat:c.Lo,   canon:k._0, block:b[18]},
			'0844':{ u:'0844', i:1991, name:'MANDAIC LETTER AH', cat:c.Lo,   canon:k._0, block:b[18]},
			'0845':{ u:'0845', i:1992, name:'MANDAIC LETTER USHENNA', cat:c.Lo,   canon:k._0, block:b[18]},
			'0846':{ u:'0846', i:1993, name:'MANDAIC LETTER AZ', cat:c.Lo,   canon:k._0, block:b[18]},
			'0847':{ u:'0847', i:1994, name:'MANDAIC LETTER IT', cat:c.Lo,   canon:k._0, block:b[18]},
			'0848':{ u:'0848', i:1995, name:'MANDAIC LETTER ATT', cat:c.Lo,   canon:k._0, block:b[18]},
			'0849':{ u:'0849', i:1996, name:'MANDAIC LETTER AKSA', cat:c.Lo,   canon:k._0, block:b[18]},
			'084a':{ u:'084a', i:1997, name:'MANDAIC LETTER AK', cat:c.Lo,   canon:k._0, block:b[18]},
			'084b':{ u:'084b', i:1998, name:'MANDAIC LETTER AL', cat:c.Lo,   canon:k._0, block:b[18]},
			'084c':{ u:'084c', i:1999, name:'MANDAIC LETTER AM', cat:c.Lo,   canon:k._0, block:b[18]},
			'084d':{ u:'084d', i:2000, name:'MANDAIC LETTER AN', cat:c.Lo,   canon:k._0, block:b[18]},
			'084e':{ u:'084e', i:2001, name:'MANDAIC LETTER AS', cat:c.Lo,   canon:k._0, block:b[18]},
			'084f':{ u:'084f', i:2002, name:'MANDAIC LETTER IN', cat:c.Lo,   canon:k._0, block:b[18]},
			'0850':{ u:'0850', i:2003, name:'MANDAIC LETTER AP', cat:c.Lo,   canon:k._0, block:b[18]},
			'0851':{ u:'0851', i:2004, name:'MANDAIC LETTER ASZ', cat:c.Lo,   canon:k._0, block:b[18]},
			'0852':{ u:'0852', i:2005, name:'MANDAIC LETTER AQ', cat:c.Lo,   canon:k._0, block:b[18]},
			'0853':{ u:'0853', i:2006, name:'MANDAIC LETTER AR', cat:c.Lo,   canon:k._0, block:b[18]},
			'0854':{ u:'0854', i:2007, name:'MANDAIC LETTER ASH', cat:c.Lo,   canon:k._0, block:b[18]},
			'0855':{ u:'0855', i:2008, name:'MANDAIC LETTER AT', cat:c.Lo,   canon:k._0, block:b[18]},
			'0856':{ u:'0856', i:2009, name:'MANDAIC LETTER DUSHENNA', cat:c.Lo,   canon:k._0, block:b[18]},
			'0857':{ u:'0857', i:2010, name:'MANDAIC LETTER KAD', cat:c.Lo,   canon:k._0, block:b[18]},
			'0858':{ u:'0858', i:2011, name:'MANDAIC LETTER AIN', cat:c.Lo,   canon:k._0, block:b[18]},
			'0859':{ u:'0859', i:2012, name:'MANDAIC AFFRICATION MARK', cat:c.Mn,   canon:k._220, block:b[18]},
			'085a':{ u:'085a', i:2013, name:'MANDAIC VOCALIZATION MARK', cat:c.Mn,   canon:k._220, block:b[18]},
			'085b':{ u:'085b', i:2014, name:'MANDAIC GEMINATION MARK', cat:c.Mn,   canon:k._220, block:b[18]},
			'085e':{ u:'085e', i:2015, name:'MANDAIC PUNCTUATION', cat:c.Po,   canon:k._0, block:b[18]},
			'0860':{ u:'0860', i:2016, name:'SYRIAC LETTER MALAYALAM NGA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0861':{ u:'0861', i:2017, name:'SYRIAC LETTER MALAYALAM JA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0862':{ u:'0862', i:2018, name:'SYRIAC LETTER MALAYALAM NYA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0863':{ u:'0863', i:2019, name:'SYRIAC LETTER MALAYALAM TTA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0864':{ u:'0864', i:2020, name:'SYRIAC LETTER MALAYALAM NNA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0865':{ u:'0865', i:2021, name:'SYRIAC LETTER MALAYALAM NNNA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0866':{ u:'0866', i:2022, name:'SYRIAC LETTER MALAYALAM BHA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0867':{ u:'0867', i:2023, name:'SYRIAC LETTER MALAYALAM RA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0868':{ u:'0868', i:2024, name:'SYRIAC LETTER MALAYALAM LLA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0869':{ u:'0869', i:2025, name:'SYRIAC LETTER MALAYALAM LLLA', cat:c.Lo,   canon:k._0, block:b[19]},
			'086a':{ u:'086a', i:2026, name:'SYRIAC LETTER MALAYALAM SSA', cat:c.Lo,   canon:k._0, block:b[19]},
			'0870':{ u:'0870', i:2027, name:'ARABIC LETTER ALEF WITH ATTACHED FATHA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0871':{ u:'0871', i:2028, name:'ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0872':{ u:'0872', i:2029, name:'ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE', cat:c.Lo,   canon:k._0, block:b[20]},
			'0873':{ u:'0873', i:2030, name:'ARABIC LETTER ALEF WITH LEFT MIDDLE STROKE', cat:c.Lo,   canon:k._0, block:b[20]},
			'0874':{ u:'0874', i:2031, name:'ARABIC LETTER ALEF WITH ATTACHED KASRA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0875':{ u:'0875', i:2032, name:'ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0876':{ u:'0876', i:2033, name:'ARABIC LETTER ALEF WITH ATTACHED ROUND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[20]},
			'0877':{ u:'0877', i:2034, name:'ARABIC LETTER ALEF WITH ATTACHED RIGHT ROUND DOT', cat:c.Lo,   canon:k._0, block:b[20]},
			'0878':{ u:'0878', i:2035, name:'ARABIC LETTER ALEF WITH ATTACHED LEFT ROUND DOT', cat:c.Lo,   canon:k._0, block:b[20]},
			'0879':{ u:'0879', i:2036, name:'ARABIC LETTER ALEF WITH ATTACHED ROUND DOT BELOW', cat:c.Lo,   canon:k._0, block:b[20]},
			'087a':{ u:'087a', i:2037, name:'ARABIC LETTER ALEF WITH DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[20]},
			'087b':{ u:'087b', i:2038, name:'ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[20]},
			'087c':{ u:'087c', i:2039, name:'ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[20]},
			'087d':{ u:'087d', i:2040, name:'ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[20]},
			'087e':{ u:'087e', i:2041, name:'ARABIC LETTER ALEF WITH ATTACHED TOP RIGHT FATHA AND LEFT RING', cat:c.Lo,   canon:k._0, block:b[20]},
			'087f':{ u:'087f', i:2042, name:'ARABIC LETTER ALEF WITH RIGHT MIDDLE STROKE AND LEFT RING', cat:c.Lo,   canon:k._0, block:b[20]},
			'0880':{ u:'0880', i:2043, name:'ARABIC LETTER ALEF WITH ATTACHED BOTTOM RIGHT KASRA AND LEFT RING', cat:c.Lo,   canon:k._0, block:b[20]},
			'0881':{ u:'0881', i:2044, name:'ARABIC LETTER ALEF WITH ATTACHED RIGHT HAMZA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0882':{ u:'0882', i:2045, name:'ARABIC LETTER ALEF WITH ATTACHED LEFT HAMZA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0883':{ u:'0883', i:2046, name:'ARABIC TATWEEL WITH OVERSTRUCK HAMZA', cat:c.Lo,   canon:k._0, block:b[20]},
			'0884':{ u:'0884', i:2047, name:'ARABIC TATWEEL WITH OVERSTRUCK WAW', cat:c.Lo,   canon:k._0, block:b[20]},
			'0885':{ u:'0885', i:2048, name:'ARABIC TATWEEL WITH TWO DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[20]},
			'0886':{ u:'0886', i:2049, name:'ARABIC LETTER THIN YEH', cat:c.Lo,   canon:k._0, block:b[20]},
			'0887':{ u:'0887', i:2050, name:'ARABIC BASELINE ROUND DOT', cat:c.Lo,   canon:k._0, block:b[20]},
			'0888':{ u:'0888', i:2051, name:'ARABIC RAISED ROUND DOT', cat:c.Sk,   canon:k._0, block:b[20]},
			'0889':{ u:'0889', i:2052, name:'ARABIC LETTER NOON WITH INVERTED SMALL V', cat:c.Lo,   canon:k._0, block:b[20], indexed:["V"]},
			'088a':{ u:'088a', i:2053, name:'ARABIC LETTER HAH WITH INVERTED SMALL V BELOW', cat:c.Lo,   canon:k._0, block:b[20], indexed:["V"]},
			'088b':{ u:'088b', i:2054, name:'ARABIC LETTER TAH WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[20]},
			'088c':{ u:'088c', i:2055, name:'ARABIC LETTER TAH WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[20]},
			'088d':{ u:'088d', i:2056, name:'ARABIC LETTER KEHEH WITH TWO DOTS VERTICALLY BELOW', cat:c.Lo,   canon:k._0, block:b[20]},
			'088e':{ u:'088e', i:2057, name:'ARABIC VERTICAL TAIL', cat:c.Lo,   canon:k._0, block:b[20]},
			'0890':{ u:'0890', i:2058, name:'ARABIC POUND MARK ABOVE', cat:c.Cf,   canon:k._0, block:b[20]},
			'0891':{ u:'0891', i:2059, name:'ARABIC PIASTRE MARK ABOVE', cat:c.Cf,   canon:k._0, block:b[20]},
			'0898':{ u:'0898', i:2060, name:'ARABIC SMALL HIGH WORD AL-JUZ', cat:c.Mn,   canon:k._230, block:b[20]},
			'0899':{ u:'0899', i:2061, name:'ARABIC SMALL LOW WORD ISHMAAM', cat:c.Mn,   canon:k._220, block:b[20]},
			'089a':{ u:'089a', i:2062, name:'ARABIC SMALL LOW WORD IMAALA', cat:c.Mn,   canon:k._220, block:b[20]},
			'089b':{ u:'089b', i:2063, name:'ARABIC SMALL LOW WORD TASHEEL', cat:c.Mn,   canon:k._220, block:b[20]},
			'089c':{ u:'089c', i:2064, name:'ARABIC MADDA WAAJIB', cat:c.Mn,   canon:k._230, block:b[20]},
			'089d':{ u:'089d', i:2065, name:'ARABIC SUPERSCRIPT ALEF MOKHASSAS', cat:c.Mn,   canon:k._230, block:b[20]},
			'089e':{ u:'089e', i:2066, name:'ARABIC DOUBLED MADDA', cat:c.Mn,   canon:k._230, block:b[20]},
			'089f':{ u:'089f', i:2067, name:'ARABIC HALF MADDA OVER MADDA', cat:c.Mn,   canon:k._230, block:b[20]},
			'08a0':{ u:'08a0', i:2068, name:'ARABIC LETTER BEH WITH SMALL V BELOW', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08a1':{ u:'08a1', i:2069, name:'ARABIC LETTER BEH WITH HAMZA ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a2':{ u:'08a2', i:2070, name:'ARABIC LETTER JEEM WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a3':{ u:'08a3', i:2071, name:'ARABIC LETTER TAH WITH TWO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a4':{ u:'08a4', i:2072, name:'ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a5':{ u:'08a5', i:2073, name:'ARABIC LETTER QAF WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a6':{ u:'08a6', i:2074, name:'ARABIC LETTER LAM WITH DOUBLE BAR', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a7':{ u:'08a7', i:2075, name:'ARABIC LETTER MEEM WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a8':{ u:'08a8', i:2076, name:'ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08a9':{ u:'08a9', i:2077, name:'ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08aa':{ u:'08aa', i:2078, name:'ARABIC LETTER REH WITH LOOP', cat:c.Lo,   canon:k._0, block:b[21]},
			'08ab':{ u:'08ab', i:2079, name:'ARABIC LETTER WAW WITH DOT WITHIN', cat:c.Lo,   canon:k._0, block:b[21]},
			'08ac':{ u:'08ac', i:2080, name:'ARABIC LETTER ROHINGYA YEH', cat:c.Lo,   canon:k._0, block:b[21]},
			'08ad':{ u:'08ad', i:2081, name:'ARABIC LETTER LOW ALEF', cat:c.Lo,   canon:k._0, block:b[21]},
			'08ae':{ u:'08ae', i:2082, name:'ARABIC LETTER DAL WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08af':{ u:'08af', i:2083, name:'ARABIC LETTER SAD WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b0':{ u:'08b0', i:2084, name:'ARABIC LETTER GAF WITH INVERTED STROKE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b1':{ u:'08b1', i:2085, name:'ARABIC LETTER STRAIGHT WAW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b2':{ u:'08b2', i:2086, name:'ARABIC LETTER ZAIN WITH INVERTED V ABOVE', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08b3':{ u:'08b3', i:2087, name:'ARABIC LETTER AIN WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b4':{ u:'08b4', i:2088, name:'ARABIC LETTER KAF WITH DOT BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b5':{ u:'08b5', i:2089, name:'ARABIC LETTER QAF WITH DOT BELOW AND NO DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b6':{ u:'08b6', i:2090, name:'ARABIC LETTER BEH WITH SMALL MEEM ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b7':{ u:'08b7', i:2091, name:'ARABIC LETTER PEH WITH SMALL MEEM ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b8':{ u:'08b8', i:2092, name:'ARABIC LETTER TEH WITH SMALL TEH ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08b9':{ u:'08b9', i:2093, name:'ARABIC LETTER REH WITH SMALL NOON ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08ba':{ u:'08ba', i:2094, name:'ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08bb':{ u:'08bb', i:2095, name:'ARABIC LETTER AFRICAN FEH', cat:c.Lo,   canon:k._0, block:b[21]},
			'08bc':{ u:'08bc', i:2096, name:'ARABIC LETTER AFRICAN QAF', cat:c.Lo,   canon:k._0, block:b[21]},
			'08bd':{ u:'08bd', i:2097, name:'ARABIC LETTER AFRICAN NOON', cat:c.Lo,   canon:k._0, block:b[21]},
			'08be':{ u:'08be', i:2098, name:'ARABIC LETTER PEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08bf':{ u:'08bf', i:2099, name:'ARABIC LETTER TEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08c0':{ u:'08c0', i:2100, name:'ARABIC LETTER TTEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08c1':{ u:'08c1', i:2101, name:'ARABIC LETTER TCHEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08c2':{ u:'08c2', i:2102, name:'ARABIC LETTER KEHEH WITH SMALL V', cat:c.Lo,   canon:k._0, block:b[21], indexed:["V"]},
			'08c3':{ u:'08c3', i:2103, name:'ARABIC LETTER GHAIN WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c4':{ u:'08c4', i:2104, name:'ARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c5':{ u:'08c5', i:2105, name:'ARABIC LETTER JEEM WITH THREE DOTS ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c6':{ u:'08c6', i:2106, name:'ARABIC LETTER JEEM WITH THREE DOTS BELOW', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c7':{ u:'08c7', i:2107, name:'ARABIC LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVE', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c8':{ u:'08c8', i:2108, name:'ARABIC LETTER GRAF', cat:c.Lo,   canon:k._0, block:b[21]},
			'08c9':{ u:'08c9', i:2109, name:'ARABIC SMALL FARSI YEH', cat:c.Lm,   canon:k._0, block:b[21]},
			'08ca':{ u:'08ca', i:2110, name:'ARABIC SMALL HIGH FARSI YEH', cat:c.Mn,   canon:k._230, block:b[21]},
			'08cb':{ u:'08cb', i:2111, name:'ARABIC SMALL HIGH YEH BARREE WITH TWO DOTS BELOW', cat:c.Mn,   canon:k._230, block:b[21]},
			'08cc':{ u:'08cc', i:2112, name:'ARABIC SMALL HIGH WORD SAH', cat:c.Mn,   canon:k._230, block:b[21]},
			'08cd':{ u:'08cd', i:2113, name:'ARABIC SMALL HIGH ZAH', cat:c.Mn,   canon:k._230, block:b[21]},
			'08ce':{ u:'08ce', i:2114, name:'ARABIC LARGE ROUND DOT ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08cf':{ u:'08cf', i:2115, name:'ARABIC LARGE ROUND DOT BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08d0':{ u:'08d0', i:2116, name:'ARABIC SUKUN BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08d1':{ u:'08d1', i:2117, name:'ARABIC LARGE CIRCLE BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08d2':{ u:'08d2', i:2118, name:'ARABIC LARGE ROUND DOT INSIDE CIRCLE BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08d3':{ u:'08d3', i:2119, name:'ARABIC SMALL LOW WAW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08d4':{ u:'08d4', i:2120, name:'ARABIC SMALL HIGH WORD AR-RUB', cat:c.Mn,   canon:k._230, block:b[21]},
			'08d5':{ u:'08d5', i:2121, name:'ARABIC SMALL HIGH SAD', cat:c.Mn,   canon:k._230, block:b[21]},
			'08d6':{ u:'08d6', i:2122, name:'ARABIC SMALL HIGH AIN', cat:c.Mn,   canon:k._230, block:b[21]},
			'08d7':{ u:'08d7', i:2123, name:'ARABIC SMALL HIGH QAF', cat:c.Mn,   canon:k._230, block:b[21]},
			'08d8':{ u:'08d8', i:2124, name:'ARABIC SMALL HIGH NOON WITH KASRA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08d9':{ u:'08d9', i:2125, name:'ARABIC SMALL LOW NOON WITH KASRA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08da':{ u:'08da', i:2126, name:'ARABIC SMALL HIGH WORD ATH-THALATHA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08db':{ u:'08db', i:2127, name:'ARABIC SMALL HIGH WORD AS-SAJDA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08dc':{ u:'08dc', i:2128, name:'ARABIC SMALL HIGH WORD AN-NISF', cat:c.Mn,   canon:k._230, block:b[21]},
			'08dd':{ u:'08dd', i:2129, name:'ARABIC SMALL HIGH WORD SAKTA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08de':{ u:'08de', i:2130, name:'ARABIC SMALL HIGH WORD QIF', cat:c.Mn,   canon:k._230, block:b[21]},
			'08df':{ u:'08df', i:2131, name:'ARABIC SMALL HIGH WORD WAQFA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e0':{ u:'08e0', i:2132, name:'ARABIC SMALL HIGH FOOTNOTE MARKER', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e1':{ u:'08e1', i:2133, name:'ARABIC SMALL HIGH SIGN SAFHA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e2':{ u:'08e2', i:2134, name:'ARABIC DISPUTED END OF AYAH', cat:c.Cf,   canon:k._0, block:b[21]},
			'08e3':{ u:'08e3', i:2135, name:'ARABIC TURNED DAMMA BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08e4':{ u:'08e4', i:2136, name:'ARABIC CURLY FATHA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e5':{ u:'08e5', i:2137, name:'ARABIC CURLY DAMMA', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e6':{ u:'08e6', i:2138, name:'ARABIC CURLY KASRA', cat:c.Mn,   canon:k._220, block:b[21]},
			'08e7':{ u:'08e7', i:2139, name:'ARABIC CURLY FATHATAN', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e8':{ u:'08e8', i:2140, name:'ARABIC CURLY DAMMATAN', cat:c.Mn,   canon:k._230, block:b[21]},
			'08e9':{ u:'08e9', i:2141, name:'ARABIC CURLY KASRATAN', cat:c.Mn,   canon:k._220, block:b[21]},
			'08ea':{ u:'08ea', i:2142, name:'ARABIC TONE ONE DOT ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08eb':{ u:'08eb', i:2143, name:'ARABIC TONE TWO DOTS ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08ec':{ u:'08ec', i:2144, name:'ARABIC TONE LOOP ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08ed':{ u:'08ed', i:2145, name:'ARABIC TONE ONE DOT BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08ee':{ u:'08ee', i:2146, name:'ARABIC TONE TWO DOTS BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08ef':{ u:'08ef', i:2147, name:'ARABIC TONE LOOP BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08f0':{ u:'08f0', i:2148, name:'ARABIC OPEN FATHATAN', cat:c.Mn,   canon:k._27, block:b[21]},
			'08f1':{ u:'08f1', i:2149, name:'ARABIC OPEN DAMMATAN', cat:c.Mn,   canon:k._28, block:b[21]},
			'08f2':{ u:'08f2', i:2150, name:'ARABIC OPEN KASRATAN', cat:c.Mn,   canon:k._29, block:b[21]},
			'08f3':{ u:'08f3', i:2151, name:'ARABIC SMALL HIGH WAW', cat:c.Mn,   canon:k._230, block:b[21]},
			'08f4':{ u:'08f4', i:2152, name:'ARABIC FATHA WITH RING', cat:c.Mn,   canon:k._230, block:b[21]},
			'08f5':{ u:'08f5', i:2153, name:'ARABIC FATHA WITH DOT ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08f6':{ u:'08f6', i:2154, name:'ARABIC KASRA WITH DOT BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08f7':{ u:'08f7', i:2155, name:'ARABIC LEFT ARROWHEAD ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08f8':{ u:'08f8', i:2156, name:'ARABIC RIGHT ARROWHEAD ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08f9':{ u:'08f9', i:2157, name:'ARABIC LEFT ARROWHEAD BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08fa':{ u:'08fa', i:2158, name:'ARABIC RIGHT ARROWHEAD BELOW', cat:c.Mn,   canon:k._220, block:b[21]},
			'08fb':{ u:'08fb', i:2159, name:'ARABIC DOUBLE RIGHT ARROWHEAD ABOVE', cat:c.Mn,   canon:k._230, block:b[21]},
			'08fc':{ u:'08fc', i:2160, name:'ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT', cat:c.Mn,   canon:k._230, block:b[21]},
			'08fd':{ u:'08fd', i:2161, name:'ARABIC RIGHT ARROWHEAD ABOVE WITH DOT', cat:c.Mn,   canon:k._230, block:b[21]},
			'08fe':{ u:'08fe', i:2162, name:'ARABIC DAMMA WITH DOT', cat:c.Mn,   canon:k._230, block:b[21]},
			'08ff':{ u:'08ff', i:2163, name:'ARABIC MARK SIDEWAYS NOON GHUNNA', cat:c.Mn,   canon:k._230, block:b[21]},
			'0900':{ u:'0900', i:2164, name:'DEVANAGARI SIGN INVERTED CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[22]},
			'0901':{ u:'0901', i:2165, name:'DEVANAGARI SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[22]},
			'0902':{ u:'0902', i:2166, name:'DEVANAGARI SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[22]},
			'0903':{ u:'0903', i:2167, name:'DEVANAGARI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[22]},
			'0904':{ u:'0904', i:2168, name:'DEVANAGARI LETTER SHORT A', cat:c.Lo,   canon:k._0, block:b[22], indexed:["A"]},
			'0905':{ u:'0905', i:2169, name:'DEVANAGARI LETTER A', cat:c.Lo,   canon:k._0, block:b[22], indexed:["A"]},
			'0906':{ u:'0906', i:2170, name:'DEVANAGARI LETTER AA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0907':{ u:'0907', i:2171, name:'DEVANAGARI LETTER I', cat:c.Lo,   canon:k._0, block:b[22], indexed:["I"]},
			'0908':{ u:'0908', i:2172, name:'DEVANAGARI LETTER II', cat:c.Lo,   canon:k._0, block:b[22]},
			'0909':{ u:'0909', i:2173, name:'DEVANAGARI LETTER U', cat:c.Lo,   canon:k._0, block:b[22], indexed:["U"]},
			'090a':{ u:'090a', i:2174, name:'DEVANAGARI LETTER UU', cat:c.Lo,   canon:k._0, block:b[22]},
			'090b':{ u:'090b', i:2175, name:'DEVANAGARI LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[22], indexed:["R"]},
			'090c':{ u:'090c', i:2176, name:'DEVANAGARI LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[22], indexed:["L"]},
			'090d':{ u:'090d', i:2177, name:'DEVANAGARI LETTER CANDRA E', cat:c.Lo,   canon:k._0, block:b[22], indexed:["E"]},
			'090e':{ u:'090e', i:2178, name:'DEVANAGARI LETTER SHORT E', cat:c.Lo,   canon:k._0, block:b[22], indexed:["E"]},
			'090f':{ u:'090f', i:2179, name:'DEVANAGARI LETTER E', cat:c.Lo,   canon:k._0, block:b[22], indexed:["E"]},
			'0910':{ u:'0910', i:2180, name:'DEVANAGARI LETTER AI', cat:c.Lo,   canon:k._0, block:b[22]},
			'0911':{ u:'0911', i:2181, name:'DEVANAGARI LETTER CANDRA O', cat:c.Lo,   canon:k._0, block:b[22], indexed:["O"]},
			'0912':{ u:'0912', i:2182, name:'DEVANAGARI LETTER SHORT O', cat:c.Lo,   canon:k._0, block:b[22], indexed:["O"]},
			'0913':{ u:'0913', i:2183, name:'DEVANAGARI LETTER O', cat:c.Lo,   canon:k._0, block:b[22], indexed:["O"]},
			'0914':{ u:'0914', i:2184, name:'DEVANAGARI LETTER AU', cat:c.Lo,   canon:k._0, block:b[22]},
			'0915':{ u:'0915', i:2185, name:'DEVANAGARI LETTER KA', cat:c.Lo,  relatives:['0958'],  canon:k._0, block:b[22]},
			'0916':{ u:'0916', i:2186, name:'DEVANAGARI LETTER KHA', cat:c.Lo,  relatives:['0959'],  canon:k._0, block:b[22]},
			'0917':{ u:'0917', i:2187, name:'DEVANAGARI LETTER GA', cat:c.Lo,  relatives:['095a'],  canon:k._0, block:b[22]},
			'0918':{ u:'0918', i:2188, name:'DEVANAGARI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0919':{ u:'0919', i:2189, name:'DEVANAGARI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[22]},
			'091a':{ u:'091a', i:2190, name:'DEVANAGARI LETTER CA', cat:c.Lo,   canon:k._0, block:b[22]},
			'091b':{ u:'091b', i:2191, name:'DEVANAGARI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'091c':{ u:'091c', i:2192, name:'DEVANAGARI LETTER JA', cat:c.Lo,  relatives:['095b'],  canon:k._0, block:b[22]},
			'091d':{ u:'091d', i:2193, name:'DEVANAGARI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'091e':{ u:'091e', i:2194, name:'DEVANAGARI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[22]},
			'091f':{ u:'091f', i:2195, name:'DEVANAGARI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0920':{ u:'0920', i:2196, name:'DEVANAGARI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0921':{ u:'0921', i:2197, name:'DEVANAGARI LETTER DDA', cat:c.Lo,  relatives:['095c'],  canon:k._0, block:b[22]},
			'0922':{ u:'0922', i:2198, name:'DEVANAGARI LETTER DDHA', cat:c.Lo,  relatives:['095d'],  canon:k._0, block:b[22]},
			'0923':{ u:'0923', i:2199, name:'DEVANAGARI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0924':{ u:'0924', i:2200, name:'DEVANAGARI LETTER TA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0925':{ u:'0925', i:2201, name:'DEVANAGARI LETTER THA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0926':{ u:'0926', i:2202, name:'DEVANAGARI LETTER DA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0927':{ u:'0927', i:2203, name:'DEVANAGARI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0928':{ u:'0928', i:2204, name:'DEVANAGARI LETTER NA', cat:c.Lo,  relatives:['0929'],  canon:k._0, block:b[22]},
			'0929':{ u:'0929', i:2205, name:'DEVANAGARI LETTER NNNA', cat:c.Lo,  relatives:['0928', '093c'], comp:['0928','093c'], canon:k._0, block:b[22]},
			'092a':{ u:'092a', i:2206, name:'DEVANAGARI LETTER PA', cat:c.Lo,   canon:k._0, block:b[22]},
			'092b':{ u:'092b', i:2207, name:'DEVANAGARI LETTER PHA', cat:c.Lo,  relatives:['095e'],  canon:k._0, block:b[22]},
			'092c':{ u:'092c', i:2208, name:'DEVANAGARI LETTER BA', cat:c.Lo,   canon:k._0, block:b[22]},
			'092d':{ u:'092d', i:2209, name:'DEVANAGARI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'092e':{ u:'092e', i:2210, name:'DEVANAGARI LETTER MA', cat:c.Lo,   canon:k._0, block:b[22]},
			'092f':{ u:'092f', i:2211, name:'DEVANAGARI LETTER YA', cat:c.Lo,  relatives:['095f'],  canon:k._0, block:b[22]},
			'0930':{ u:'0930', i:2212, name:'DEVANAGARI LETTER RA', cat:c.Lo,  relatives:['0931'],  canon:k._0, block:b[22]},
			'0931':{ u:'0931', i:2213, name:'DEVANAGARI LETTER RRA', cat:c.Lo,  relatives:['0930', '093c'], comp:['0930','093c'], canon:k._0, block:b[22]},
			'0932':{ u:'0932', i:2214, name:'DEVANAGARI LETTER LA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0933':{ u:'0933', i:2215, name:'DEVANAGARI LETTER LLA', cat:c.Lo,  relatives:['0934'],  canon:k._0, block:b[22]},
			'0934':{ u:'0934', i:2216, name:'DEVANAGARI LETTER LLLA', cat:c.Lo,  relatives:['0933', '093c'], comp:['0933','093c'], canon:k._0, block:b[22]},
			'0935':{ u:'0935', i:2217, name:'DEVANAGARI LETTER VA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0936':{ u:'0936', i:2218, name:'DEVANAGARI LETTER SHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0937':{ u:'0937', i:2219, name:'DEVANAGARI LETTER SSA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0938':{ u:'0938', i:2220, name:'DEVANAGARI LETTER SA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0939':{ u:'0939', i:2221, name:'DEVANAGARI LETTER HA', cat:c.Lo,   canon:k._0, block:b[22]},
			'093a':{ u:'093a', i:2222, name:'DEVANAGARI VOWEL SIGN OE', cat:c.Mn,   canon:k._0, block:b[22]},
			'093b':{ u:'093b', i:2223, name:'DEVANAGARI VOWEL SIGN OOE', cat:c.Mc,   canon:k._0, block:b[22]},
			'093c':{ u:'093c', i:2224, name:'DEVANAGARI SIGN NUKTA', cat:c.Mn,  relatives:['0929', '0931', '0934', '0958', '0959', '095a', '095b', '095c', '095d', '095e', '095f'],  canon:k._7, block:b[22]},
			'093d':{ u:'093d', i:2225, name:'DEVANAGARI SIGN AVAGRAHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'093e':{ u:'093e', i:2226, name:'DEVANAGARI VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[22]},
			'093f':{ u:'093f', i:2227, name:'DEVANAGARI VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[22], indexed:["I"]},
			'0940':{ u:'0940', i:2228, name:'DEVANAGARI VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[22]},
			'0941':{ u:'0941', i:2229, name:'DEVANAGARI VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[22], indexed:["U"]},
			'0942':{ u:'0942', i:2230, name:'DEVANAGARI VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[22]},
			'0943':{ u:'0943', i:2231, name:'DEVANAGARI VOWEL SIGN VOCALIC R', cat:c.Mn,   canon:k._0, block:b[22], indexed:["R"]},
			'0944':{ u:'0944', i:2232, name:'DEVANAGARI VOWEL SIGN VOCALIC RR', cat:c.Mn,   canon:k._0, block:b[22]},
			'0945':{ u:'0945', i:2233, name:'DEVANAGARI VOWEL SIGN CANDRA E', cat:c.Mn,   canon:k._0, block:b[22], indexed:["E"]},
			'0946':{ u:'0946', i:2234, name:'DEVANAGARI VOWEL SIGN SHORT E', cat:c.Mn,   canon:k._0, block:b[22], indexed:["E"]},
			'0947':{ u:'0947', i:2235, name:'DEVANAGARI VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[22], indexed:["E"]},
			'0948':{ u:'0948', i:2236, name:'DEVANAGARI VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[22]},
			'0949':{ u:'0949', i:2237, name:'DEVANAGARI VOWEL SIGN CANDRA O', cat:c.Mc,   canon:k._0, block:b[22], indexed:["O"]},
			'094a':{ u:'094a', i:2238, name:'DEVANAGARI VOWEL SIGN SHORT O', cat:c.Mc,   canon:k._0, block:b[22], indexed:["O"]},
			'094b':{ u:'094b', i:2239, name:'DEVANAGARI VOWEL SIGN O', cat:c.Mc,   canon:k._0, block:b[22], indexed:["O"]},
			'094c':{ u:'094c', i:2240, name:'DEVANAGARI VOWEL SIGN AU', cat:c.Mc,   canon:k._0, block:b[22]},
			'094d':{ u:'094d', i:2241, name:'DEVANAGARI SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[22]},
			'094e':{ u:'094e', i:2242, name:'DEVANAGARI VOWEL SIGN PRISHTHAMATRA E', cat:c.Mc,   canon:k._0, block:b[22], indexed:["E"]},
			'094f':{ u:'094f', i:2243, name:'DEVANAGARI VOWEL SIGN AW', cat:c.Mc,   canon:k._0, block:b[22]},
			'0950':{ u:'0950', i:2244, name:'DEVANAGARI OM', cat:c.Lo,   canon:k._0, block:b[22]},
			'0951':{ u:'0951', i:2245, name:'DEVANAGARI STRESS SIGN UDATTA', cat:c.Mn,   canon:k._230, block:b[22]},
			'0952':{ u:'0952', i:2246, name:'DEVANAGARI STRESS SIGN ANUDATTA', cat:c.Mn,   canon:k._220, block:b[22]},
			'0953':{ u:'0953', i:2247, name:'DEVANAGARI GRAVE ACCENT', cat:c.Mn,   canon:k._230, block:b[22]},
			'0954':{ u:'0954', i:2248, name:'DEVANAGARI ACUTE ACCENT', cat:c.Mn,   canon:k._230, block:b[22]},
			'0955':{ u:'0955', i:2249, name:'DEVANAGARI VOWEL SIGN CANDRA LONG E', cat:c.Mn,   canon:k._0, block:b[22], indexed:["E"]},
			'0956':{ u:'0956', i:2250, name:'DEVANAGARI VOWEL SIGN UE', cat:c.Mn,   canon:k._0, block:b[22]},
			'0957':{ u:'0957', i:2251, name:'DEVANAGARI VOWEL SIGN UUE', cat:c.Mn,   canon:k._0, block:b[22]},
			'0958':{ u:'0958', i:2252, name:'DEVANAGARI LETTER QA', cat:c.Lo,  relatives:['0915', '093c'], comp:['0915','093c'], canon:k._0, block:b[22]},
			'0959':{ u:'0959', i:2253, name:'DEVANAGARI LETTER KHHA', cat:c.Lo,  relatives:['0916', '093c'], comp:['0916','093c'], canon:k._0, block:b[22]},
			'095a':{ u:'095a', i:2254, name:'DEVANAGARI LETTER GHHA', cat:c.Lo,  relatives:['0917', '093c'], comp:['0917','093c'], canon:k._0, block:b[22]},
			'095b':{ u:'095b', i:2255, name:'DEVANAGARI LETTER ZA', cat:c.Lo,  relatives:['091c', '093c'], comp:['091c','093c'], canon:k._0, block:b[22]},
			'095c':{ u:'095c', i:2256, name:'DEVANAGARI LETTER DDDHA', cat:c.Lo,  relatives:['0921', '093c'], comp:['0921','093c'], canon:k._0, block:b[22]},
			'095d':{ u:'095d', i:2257, name:'DEVANAGARI LETTER RHA', cat:c.Lo,  relatives:['0922', '093c'], comp:['0922','093c'], canon:k._0, block:b[22]},
			'095e':{ u:'095e', i:2258, name:'DEVANAGARI LETTER FA', cat:c.Lo,  relatives:['092b', '093c'], comp:['092b','093c'], canon:k._0, block:b[22]},
			'095f':{ u:'095f', i:2259, name:'DEVANAGARI LETTER YYA', cat:c.Lo,  relatives:['092f', '093c'], comp:['092f','093c'], canon:k._0, block:b[22]},
			'0960':{ u:'0960', i:2260, name:'DEVANAGARI LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[22]},
			'0961':{ u:'0961', i:2261, name:'DEVANAGARI LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[22]},
			'0962':{ u:'0962', i:2262, name:'DEVANAGARI VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[22], indexed:["L"]},
			'0963':{ u:'0963', i:2263, name:'DEVANAGARI VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[22]},
			'0964':{ u:'0964', i:2264, name:'DEVANAGARI DANDA', cat:c.Po,   canon:k._0, block:b[22]},
			'0965':{ u:'0965', i:2265, name:'DEVANAGARI DOUBLE DANDA', cat:c.Po,   canon:k._0, block:b[22]},
			'0966':{ u:'0966', i:2266, name:'DEVANAGARI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[22]},
			'0967':{ u:'0967', i:2267, name:'DEVANAGARI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[22]},
			'0968':{ u:'0968', i:2268, name:'DEVANAGARI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[22]},
			'0969':{ u:'0969', i:2269, name:'DEVANAGARI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[22]},
			'096a':{ u:'096a', i:2270, name:'DEVANAGARI DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[22]},
			'096b':{ u:'096b', i:2271, name:'DEVANAGARI DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[22]},
			'096c':{ u:'096c', i:2272, name:'DEVANAGARI DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[22]},
			'096d':{ u:'096d', i:2273, name:'DEVANAGARI DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[22]},
			'096e':{ u:'096e', i:2274, name:'DEVANAGARI DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[22]},
			'096f':{ u:'096f', i:2275, name:'DEVANAGARI DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[22]},
			'0970':{ u:'0970', i:2276, name:'DEVANAGARI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[22]},
			'0971':{ u:'0971', i:2277, name:'DEVANAGARI SIGN HIGH SPACING DOT', cat:c.Lm,   canon:k._0, block:b[22]},
			'0972':{ u:'0972', i:2278, name:'DEVANAGARI LETTER CANDRA A', cat:c.Lo,   canon:k._0, block:b[22], indexed:["A"]},
			'0973':{ u:'0973', i:2279, name:'DEVANAGARI LETTER OE', cat:c.Lo,   canon:k._0, block:b[22]},
			'0974':{ u:'0974', i:2280, name:'DEVANAGARI LETTER OOE', cat:c.Lo,   canon:k._0, block:b[22]},
			'0975':{ u:'0975', i:2281, name:'DEVANAGARI LETTER AW', cat:c.Lo,   canon:k._0, block:b[22]},
			'0976':{ u:'0976', i:2282, name:'DEVANAGARI LETTER UE', cat:c.Lo,   canon:k._0, block:b[22]},
			'0977':{ u:'0977', i:2283, name:'DEVANAGARI LETTER UUE', cat:c.Lo,   canon:k._0, block:b[22]},
			'0978':{ u:'0978', i:2284, name:'DEVANAGARI LETTER MARWARI DDA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0979':{ u:'0979', i:2285, name:'DEVANAGARI LETTER ZHA', cat:c.Lo,   canon:k._0, block:b[22]},
			'097a':{ u:'097a', i:2286, name:'DEVANAGARI LETTER HEAVY YA', cat:c.Lo,   canon:k._0, block:b[22]},
			'097b':{ u:'097b', i:2287, name:'DEVANAGARI LETTER GGA', cat:c.Lo,   canon:k._0, block:b[22]},
			'097c':{ u:'097c', i:2288, name:'DEVANAGARI LETTER JJA', cat:c.Lo,   canon:k._0, block:b[22]},
			'097d':{ u:'097d', i:2289, name:'DEVANAGARI LETTER GLOTTAL STOP', cat:c.Lo,   canon:k._0, block:b[22]},
			'097e':{ u:'097e', i:2290, name:'DEVANAGARI LETTER DDDA', cat:c.Lo,   canon:k._0, block:b[22]},
			'097f':{ u:'097f', i:2291, name:'DEVANAGARI LETTER BBA', cat:c.Lo,   canon:k._0, block:b[22]},
			'0980':{ u:'0980', i:2292, name:'BENGALI ANJI', cat:c.Lo,   canon:k._0, block:b[23]},
			'0981':{ u:'0981', i:2293, name:'BENGALI SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[23]},
			'0982':{ u:'0982', i:2294, name:'BENGALI SIGN ANUSVARA', cat:c.Mc,   canon:k._0, block:b[23]},
			'0983':{ u:'0983', i:2295, name:'BENGALI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[23]},
			'0985':{ u:'0985', i:2296, name:'BENGALI LETTER A', cat:c.Lo,   canon:k._0, block:b[23], indexed:["A"]},
			'0986':{ u:'0986', i:2297, name:'BENGALI LETTER AA', cat:c.Lo,   canon:k._0, block:b[23]},
			'0987':{ u:'0987', i:2298, name:'BENGALI LETTER I', cat:c.Lo,   canon:k._0, block:b[23], indexed:["I"]},
			'0988':{ u:'0988', i:2299, name:'BENGALI LETTER II', cat:c.Lo,   canon:k._0, block:b[23]},
			'0989':{ u:'0989', i:2300, name:'BENGALI LETTER U', cat:c.Lo,   canon:k._0, block:b[23], indexed:["U"]},
			'098a':{ u:'098a', i:2301, name:'BENGALI LETTER UU', cat:c.Lo,   canon:k._0, block:b[23]},
			'098b':{ u:'098b', i:2302, name:'BENGALI LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[23], indexed:["R"]},
			'098c':{ u:'098c', i:2303, name:'BENGALI LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[23], indexed:["L"]},
			'098f':{ u:'098f', i:2304, name:'BENGALI LETTER E', cat:c.Lo,   canon:k._0, block:b[23], indexed:["E"]},
			'0990':{ u:'0990', i:2305, name:'BENGALI LETTER AI', cat:c.Lo,   canon:k._0, block:b[23]},
			'0993':{ u:'0993', i:2306, name:'BENGALI LETTER O', cat:c.Lo,   canon:k._0, block:b[23], indexed:["O"]},
			'0994':{ u:'0994', i:2307, name:'BENGALI LETTER AU', cat:c.Lo,   canon:k._0, block:b[23]},
			'0995':{ u:'0995', i:2308, name:'BENGALI LETTER KA', cat:c.Lo,   canon:k._0, block:b[23]},
			'0996':{ u:'0996', i:2309, name:'BENGALI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'0997':{ u:'0997', i:2310, name:'BENGALI LETTER GA', cat:c.Lo,   canon:k._0, block:b[23]},
			'0998':{ u:'0998', i:2311, name:'BENGALI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'0999':{ u:'0999', i:2312, name:'BENGALI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099a':{ u:'099a', i:2313, name:'BENGALI LETTER CA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099b':{ u:'099b', i:2314, name:'BENGALI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099c':{ u:'099c', i:2315, name:'BENGALI LETTER JA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099d':{ u:'099d', i:2316, name:'BENGALI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099e':{ u:'099e', i:2317, name:'BENGALI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[23]},
			'099f':{ u:'099f', i:2318, name:'BENGALI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a0':{ u:'09a0', i:2319, name:'BENGALI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a1':{ u:'09a1', i:2320, name:'BENGALI LETTER DDA', cat:c.Lo,  relatives:['09dc'],  canon:k._0, block:b[23]},
			'09a2':{ u:'09a2', i:2321, name:'BENGALI LETTER DDHA', cat:c.Lo,  relatives:['09dd'],  canon:k._0, block:b[23]},
			'09a3':{ u:'09a3', i:2322, name:'BENGALI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a4':{ u:'09a4', i:2323, name:'BENGALI LETTER TA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a5':{ u:'09a5', i:2324, name:'BENGALI LETTER THA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a6':{ u:'09a6', i:2325, name:'BENGALI LETTER DA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a7':{ u:'09a7', i:2326, name:'BENGALI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09a8':{ u:'09a8', i:2327, name:'BENGALI LETTER NA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09aa':{ u:'09aa', i:2328, name:'BENGALI LETTER PA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09ab':{ u:'09ab', i:2329, name:'BENGALI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09ac':{ u:'09ac', i:2330, name:'BENGALI LETTER BA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09ad':{ u:'09ad', i:2331, name:'BENGALI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09ae':{ u:'09ae', i:2332, name:'BENGALI LETTER MA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09af':{ u:'09af', i:2333, name:'BENGALI LETTER YA', cat:c.Lo,  relatives:['09df'],  canon:k._0, block:b[23]},
			'09b0':{ u:'09b0', i:2334, name:'BENGALI LETTER RA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09b2':{ u:'09b2', i:2335, name:'BENGALI LETTER LA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09b6':{ u:'09b6', i:2336, name:'BENGALI LETTER SHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09b7':{ u:'09b7', i:2337, name:'BENGALI LETTER SSA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09b8':{ u:'09b8', i:2338, name:'BENGALI LETTER SA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09b9':{ u:'09b9', i:2339, name:'BENGALI LETTER HA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09bc':{ u:'09bc', i:2340, name:'BENGALI SIGN NUKTA', cat:c.Mn,  relatives:['09dc', '09dd', '09df'],  canon:k._7, block:b[23]},
			'09bd':{ u:'09bd', i:2341, name:'BENGALI SIGN AVAGRAHA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09be':{ u:'09be', i:2342, name:'BENGALI VOWEL SIGN AA', cat:c.Mc,  relatives:['09cb'],  canon:k._0, block:b[23]},
			'09bf':{ u:'09bf', i:2343, name:'BENGALI VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[23], indexed:["I"]},
			'09c0':{ u:'09c0', i:2344, name:'BENGALI VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[23]},
			'09c1':{ u:'09c1', i:2345, name:'BENGALI VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[23], indexed:["U"]},
			'09c2':{ u:'09c2', i:2346, name:'BENGALI VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[23]},
			'09c3':{ u:'09c3', i:2347, name:'BENGALI VOWEL SIGN VOCALIC R', cat:c.Mn,   canon:k._0, block:b[23], indexed:["R"]},
			'09c4':{ u:'09c4', i:2348, name:'BENGALI VOWEL SIGN VOCALIC RR', cat:c.Mn,   canon:k._0, block:b[23]},
			'09c7':{ u:'09c7', i:2349, name:'BENGALI VOWEL SIGN E', cat:c.Mc,  relatives:['09cb', '09cc'],  canon:k._0, block:b[23], indexed:["E"]},
			'09c8':{ u:'09c8', i:2350, name:'BENGALI VOWEL SIGN AI', cat:c.Mc,   canon:k._0, block:b[23]},
			'09cb':{ u:'09cb', i:2351, name:'BENGALI VOWEL SIGN O', cat:c.Mc,  relatives:['09c7', '09be'], comp:['09c7','09be'], canon:k._0, block:b[23], indexed:["O"]},
			'09cc':{ u:'09cc', i:2352, name:'BENGALI VOWEL SIGN AU', cat:c.Mc,  relatives:['09c7', '09d7'], comp:['09c7','09d7'], canon:k._0, block:b[23]},
			'09cd':{ u:'09cd', i:2353, name:'BENGALI SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[23]},
			'09ce':{ u:'09ce', i:2354, name:'BENGALI LETTER KHANDA TA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09d7':{ u:'09d7', i:2355, name:'BENGALI AU LENGTH MARK', cat:c.Mc,  relatives:['09cc'],  canon:k._0, block:b[23]},
			'09dc':{ u:'09dc', i:2356, name:'BENGALI LETTER RRA', cat:c.Lo,  relatives:['09a1', '09bc'], comp:['09a1','09bc'], canon:k._0, block:b[23]},
			'09dd':{ u:'09dd', i:2357, name:'BENGALI LETTER RHA', cat:c.Lo,  relatives:['09a2', '09bc'], comp:['09a2','09bc'], canon:k._0, block:b[23]},
			'09df':{ u:'09df', i:2358, name:'BENGALI LETTER YYA', cat:c.Lo,  relatives:['09af', '09bc'], comp:['09af','09bc'], canon:k._0, block:b[23]},
			'09e0':{ u:'09e0', i:2359, name:'BENGALI LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[23]},
			'09e1':{ u:'09e1', i:2360, name:'BENGALI LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[23]},
			'09e2':{ u:'09e2', i:2361, name:'BENGALI VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[23], indexed:["L"]},
			'09e3':{ u:'09e3', i:2362, name:'BENGALI VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[23]},
			'09e6':{ u:'09e6', i:2363, name:'BENGALI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[23]},
			'09e7':{ u:'09e7', i:2364, name:'BENGALI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[23]},
			'09e8':{ u:'09e8', i:2365, name:'BENGALI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[23]},
			'09e9':{ u:'09e9', i:2366, name:'BENGALI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[23]},
			'09ea':{ u:'09ea', i:2367, name:'BENGALI DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[23]},
			'09eb':{ u:'09eb', i:2368, name:'BENGALI DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[23]},
			'09ec':{ u:'09ec', i:2369, name:'BENGALI DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[23]},
			'09ed':{ u:'09ed', i:2370, name:'BENGALI DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[23]},
			'09ee':{ u:'09ee', i:2371, name:'BENGALI DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[23]},
			'09ef':{ u:'09ef', i:2372, name:'BENGALI DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[23]},
			'09f0':{ u:'09f0', i:2373, name:'BENGALI LETTER RA WITH MIDDLE DIAGONAL', cat:c.Lo,   canon:k._0, block:b[23]},
			'09f1':{ u:'09f1', i:2374, name:'BENGALI LETTER RA WITH LOWER DIAGONAL', cat:c.Lo,   canon:k._0, block:b[23]},
			'09f2':{ u:'09f2', i:2375, name:'BENGALI RUPEE MARK', cat:c.Sc,   canon:k._0, block:b[23]},
			'09f3':{ u:'09f3', i:2376, name:'BENGALI RUPEE SIGN', cat:c.Sc,   canon:k._0, block:b[23]},
			'09f4':{ u:'09f4', i:2377, name:'BENGALI CURRENCY NUMERATOR ONE', cat:c.No,   canon:k._0, block:b[23]},
			'09f5':{ u:'09f5', i:2378, name:'BENGALI CURRENCY NUMERATOR TWO', cat:c.No,   canon:k._0, block:b[23]},
			'09f6':{ u:'09f6', i:2379, name:'BENGALI CURRENCY NUMERATOR THREE', cat:c.No,   canon:k._0, block:b[23]},
			'09f7':{ u:'09f7', i:2380, name:'BENGALI CURRENCY NUMERATOR FOUR', cat:c.No,   canon:k._0, block:b[23]},
			'09f8':{ u:'09f8', i:2381, name:'BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR', cat:c.No,   canon:k._0, block:b[23]},
			'09f9':{ u:'09f9', i:2382, name:'BENGALI CURRENCY DENOMINATOR SIXTEEN', cat:c.No,   canon:k._0, block:b[23]},
			'09fa':{ u:'09fa', i:2383, name:'BENGALI ISSHAR', cat:c.So,   canon:k._0, block:b[23]},
			'09fb':{ u:'09fb', i:2384, name:'BENGALI GANDA MARK', cat:c.Sc,   canon:k._0, block:b[23]},
			'09fc':{ u:'09fc', i:2385, name:'BENGALI LETTER VEDIC ANUSVARA', cat:c.Lo,   canon:k._0, block:b[23]},
			'09fd':{ u:'09fd', i:2386, name:'BENGALI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[23]},
			'09fe':{ u:'09fe', i:2387, name:'BENGALI SANDHI MARK', cat:c.Mn,   canon:k._230, block:b[23]},
			'0a01':{ u:'0a01', i:2388, name:'GURMUKHI SIGN ADAK BINDI', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a02':{ u:'0a02', i:2389, name:'GURMUKHI SIGN BINDI', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a03':{ u:'0a03', i:2390, name:'GURMUKHI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[24]},
			'0a05':{ u:'0a05', i:2391, name:'GURMUKHI LETTER A', cat:c.Lo,   canon:k._0, block:b[24], indexed:["A"]},
			'0a06':{ u:'0a06', i:2392, name:'GURMUKHI LETTER AA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a07':{ u:'0a07', i:2393, name:'GURMUKHI LETTER I', cat:c.Lo,   canon:k._0, block:b[24], indexed:["I"]},
			'0a08':{ u:'0a08', i:2394, name:'GURMUKHI LETTER II', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a09':{ u:'0a09', i:2395, name:'GURMUKHI LETTER U', cat:c.Lo,   canon:k._0, block:b[24], indexed:["U"]},
			'0a0a':{ u:'0a0a', i:2396, name:'GURMUKHI LETTER UU', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a0f':{ u:'0a0f', i:2397, name:'GURMUKHI LETTER EE', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a10':{ u:'0a10', i:2398, name:'GURMUKHI LETTER AI', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a13':{ u:'0a13', i:2399, name:'GURMUKHI LETTER OO', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a14':{ u:'0a14', i:2400, name:'GURMUKHI LETTER AU', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a15':{ u:'0a15', i:2401, name:'GURMUKHI LETTER KA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a16':{ u:'0a16', i:2402, name:'GURMUKHI LETTER KHA', cat:c.Lo,  relatives:['0a59'],  canon:k._0, block:b[24]},
			'0a17':{ u:'0a17', i:2403, name:'GURMUKHI LETTER GA', cat:c.Lo,  relatives:['0a5a'],  canon:k._0, block:b[24]},
			'0a18':{ u:'0a18', i:2404, name:'GURMUKHI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a19':{ u:'0a19', i:2405, name:'GURMUKHI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a1a':{ u:'0a1a', i:2406, name:'GURMUKHI LETTER CA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a1b':{ u:'0a1b', i:2407, name:'GURMUKHI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a1c':{ u:'0a1c', i:2408, name:'GURMUKHI LETTER JA', cat:c.Lo,  relatives:['0a5b'],  canon:k._0, block:b[24]},
			'0a1d':{ u:'0a1d', i:2409, name:'GURMUKHI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a1e':{ u:'0a1e', i:2410, name:'GURMUKHI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a1f':{ u:'0a1f', i:2411, name:'GURMUKHI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a20':{ u:'0a20', i:2412, name:'GURMUKHI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a21':{ u:'0a21', i:2413, name:'GURMUKHI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a22':{ u:'0a22', i:2414, name:'GURMUKHI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a23':{ u:'0a23', i:2415, name:'GURMUKHI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a24':{ u:'0a24', i:2416, name:'GURMUKHI LETTER TA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a25':{ u:'0a25', i:2417, name:'GURMUKHI LETTER THA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a26':{ u:'0a26', i:2418, name:'GURMUKHI LETTER DA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a27':{ u:'0a27', i:2419, name:'GURMUKHI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a28':{ u:'0a28', i:2420, name:'GURMUKHI LETTER NA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a2a':{ u:'0a2a', i:2421, name:'GURMUKHI LETTER PA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a2b':{ u:'0a2b', i:2422, name:'GURMUKHI LETTER PHA', cat:c.Lo,  relatives:['0a5e'],  canon:k._0, block:b[24]},
			'0a2c':{ u:'0a2c', i:2423, name:'GURMUKHI LETTER BA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a2d':{ u:'0a2d', i:2424, name:'GURMUKHI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a2e':{ u:'0a2e', i:2425, name:'GURMUKHI LETTER MA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a2f':{ u:'0a2f', i:2426, name:'GURMUKHI LETTER YA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a30':{ u:'0a30', i:2427, name:'GURMUKHI LETTER RA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a32':{ u:'0a32', i:2428, name:'GURMUKHI LETTER LA', cat:c.Lo,  relatives:['0a33'],  canon:k._0, block:b[24]},
			'0a33':{ u:'0a33', i:2429, name:'GURMUKHI LETTER LLA', cat:c.Lo,  relatives:['0a32', '0a3c'], comp:['0a32','0a3c'], canon:k._0, block:b[24]},
			'0a35':{ u:'0a35', i:2430, name:'GURMUKHI LETTER VA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a36':{ u:'0a36', i:2431, name:'GURMUKHI LETTER SHA', cat:c.Lo,  relatives:['0a38', '0a3c'], comp:['0a38','0a3c'], canon:k._0, block:b[24]},
			'0a38':{ u:'0a38', i:2432, name:'GURMUKHI LETTER SA', cat:c.Lo,  relatives:['0a36'],  canon:k._0, block:b[24]},
			'0a39':{ u:'0a39', i:2433, name:'GURMUKHI LETTER HA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a3c':{ u:'0a3c', i:2434, name:'GURMUKHI SIGN NUKTA', cat:c.Mn,  relatives:['0a33', '0a36', '0a59', '0a5a', '0a5b', '0a5e'],  canon:k._7, block:b[24]},
			'0a3e':{ u:'0a3e', i:2435, name:'GURMUKHI VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[24]},
			'0a3f':{ u:'0a3f', i:2436, name:'GURMUKHI VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[24], indexed:["I"]},
			'0a40':{ u:'0a40', i:2437, name:'GURMUKHI VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[24]},
			'0a41':{ u:'0a41', i:2438, name:'GURMUKHI VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[24], indexed:["U"]},
			'0a42':{ u:'0a42', i:2439, name:'GURMUKHI VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a47':{ u:'0a47', i:2440, name:'GURMUKHI VOWEL SIGN EE', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a48':{ u:'0a48', i:2441, name:'GURMUKHI VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a4b':{ u:'0a4b', i:2442, name:'GURMUKHI VOWEL SIGN OO', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a4c':{ u:'0a4c', i:2443, name:'GURMUKHI VOWEL SIGN AU', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a4d':{ u:'0a4d', i:2444, name:'GURMUKHI SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[24]},
			'0a51':{ u:'0a51', i:2445, name:'GURMUKHI SIGN UDAAT', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a59':{ u:'0a59', i:2446, name:'GURMUKHI LETTER KHHA', cat:c.Lo,  relatives:['0a16', '0a3c'], comp:['0a16','0a3c'], canon:k._0, block:b[24]},
			'0a5a':{ u:'0a5a', i:2447, name:'GURMUKHI LETTER GHHA', cat:c.Lo,  relatives:['0a17', '0a3c'], comp:['0a17','0a3c'], canon:k._0, block:b[24]},
			'0a5b':{ u:'0a5b', i:2448, name:'GURMUKHI LETTER ZA', cat:c.Lo,  relatives:['0a1c', '0a3c'], comp:['0a1c','0a3c'], canon:k._0, block:b[24]},
			'0a5c':{ u:'0a5c', i:2449, name:'GURMUKHI LETTER RRA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a5e':{ u:'0a5e', i:2450, name:'GURMUKHI LETTER FA', cat:c.Lo,  relatives:['0a2b', '0a3c'], comp:['0a2b','0a3c'], canon:k._0, block:b[24]},
			'0a66':{ u:'0a66', i:2451, name:'GURMUKHI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a67':{ u:'0a67', i:2452, name:'GURMUKHI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a68':{ u:'0a68', i:2453, name:'GURMUKHI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a69':{ u:'0a69', i:2454, name:'GURMUKHI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6a':{ u:'0a6a', i:2455, name:'GURMUKHI DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6b':{ u:'0a6b', i:2456, name:'GURMUKHI DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6c':{ u:'0a6c', i:2457, name:'GURMUKHI DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6d':{ u:'0a6d', i:2458, name:'GURMUKHI DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6e':{ u:'0a6e', i:2459, name:'GURMUKHI DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a6f':{ u:'0a6f', i:2460, name:'GURMUKHI DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[24]},
			'0a70':{ u:'0a70', i:2461, name:'GURMUKHI TIPPI', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a71':{ u:'0a71', i:2462, name:'GURMUKHI ADDAK', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a72':{ u:'0a72', i:2463, name:'GURMUKHI IRI', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a73':{ u:'0a73', i:2464, name:'GURMUKHI URA', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a74':{ u:'0a74', i:2465, name:'GURMUKHI EK ONKAR', cat:c.Lo,   canon:k._0, block:b[24]},
			'0a75':{ u:'0a75', i:2466, name:'GURMUKHI SIGN YAKASH', cat:c.Mn,   canon:k._0, block:b[24]},
			'0a76':{ u:'0a76', i:2467, name:'GURMUKHI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[24]},
			'0a81':{ u:'0a81', i:2468, name:'GUJARATI SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[25]},
			'0a82':{ u:'0a82', i:2469, name:'GUJARATI SIGN ANUSVARA', cat:c.Mn,   canon:k._0, block:b[25]},
			'0a83':{ u:'0a83', i:2470, name:'GUJARATI SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[25]},
			'0a85':{ u:'0a85', i:2471, name:'GUJARATI LETTER A', cat:c.Lo,   canon:k._0, block:b[25], indexed:["A"]},
			'0a86':{ u:'0a86', i:2472, name:'GUJARATI LETTER AA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a87':{ u:'0a87', i:2473, name:'GUJARATI LETTER I', cat:c.Lo,   canon:k._0, block:b[25], indexed:["I"]},
			'0a88':{ u:'0a88', i:2474, name:'GUJARATI LETTER II', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a89':{ u:'0a89', i:2475, name:'GUJARATI LETTER U', cat:c.Lo,   canon:k._0, block:b[25], indexed:["U"]},
			'0a8a':{ u:'0a8a', i:2476, name:'GUJARATI LETTER UU', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a8b':{ u:'0a8b', i:2477, name:'GUJARATI LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[25], indexed:["R"]},
			'0a8c':{ u:'0a8c', i:2478, name:'GUJARATI LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[25], indexed:["L"]},
			'0a8d':{ u:'0a8d', i:2479, name:'GUJARATI VOWEL CANDRA E', cat:c.Lo,   canon:k._0, block:b[25], indexed:["E"]},
			'0a8f':{ u:'0a8f', i:2480, name:'GUJARATI LETTER E', cat:c.Lo,   canon:k._0, block:b[25], indexed:["E"]},
			'0a90':{ u:'0a90', i:2481, name:'GUJARATI LETTER AI', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a91':{ u:'0a91', i:2482, name:'GUJARATI VOWEL CANDRA O', cat:c.Lo,   canon:k._0, block:b[25], indexed:["O"]},
			'0a93':{ u:'0a93', i:2483, name:'GUJARATI LETTER O', cat:c.Lo,   canon:k._0, block:b[25], indexed:["O"]},
			'0a94':{ u:'0a94', i:2484, name:'GUJARATI LETTER AU', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a95':{ u:'0a95', i:2485, name:'GUJARATI LETTER KA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a96':{ u:'0a96', i:2486, name:'GUJARATI LETTER KHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a97':{ u:'0a97', i:2487, name:'GUJARATI LETTER GA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a98':{ u:'0a98', i:2488, name:'GUJARATI LETTER GHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a99':{ u:'0a99', i:2489, name:'GUJARATI LETTER NGA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9a':{ u:'0a9a', i:2490, name:'GUJARATI LETTER CA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9b':{ u:'0a9b', i:2491, name:'GUJARATI LETTER CHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9c':{ u:'0a9c', i:2492, name:'GUJARATI LETTER JA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9d':{ u:'0a9d', i:2493, name:'GUJARATI LETTER JHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9e':{ u:'0a9e', i:2494, name:'GUJARATI LETTER NYA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0a9f':{ u:'0a9f', i:2495, name:'GUJARATI LETTER TTA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa0':{ u:'0aa0', i:2496, name:'GUJARATI LETTER TTHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa1':{ u:'0aa1', i:2497, name:'GUJARATI LETTER DDA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa2':{ u:'0aa2', i:2498, name:'GUJARATI LETTER DDHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa3':{ u:'0aa3', i:2499, name:'GUJARATI LETTER NNA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa4':{ u:'0aa4', i:2500, name:'GUJARATI LETTER TA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa5':{ u:'0aa5', i:2501, name:'GUJARATI LETTER THA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa6':{ u:'0aa6', i:2502, name:'GUJARATI LETTER DA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa7':{ u:'0aa7', i:2503, name:'GUJARATI LETTER DHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aa8':{ u:'0aa8', i:2504, name:'GUJARATI LETTER NA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aaa':{ u:'0aaa', i:2505, name:'GUJARATI LETTER PA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aab':{ u:'0aab', i:2506, name:'GUJARATI LETTER PHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aac':{ u:'0aac', i:2507, name:'GUJARATI LETTER BA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aad':{ u:'0aad', i:2508, name:'GUJARATI LETTER BHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aae':{ u:'0aae', i:2509, name:'GUJARATI LETTER MA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0aaf':{ u:'0aaf', i:2510, name:'GUJARATI LETTER YA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab0':{ u:'0ab0', i:2511, name:'GUJARATI LETTER RA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab2':{ u:'0ab2', i:2512, name:'GUJARATI LETTER LA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab3':{ u:'0ab3', i:2513, name:'GUJARATI LETTER LLA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab5':{ u:'0ab5', i:2514, name:'GUJARATI LETTER VA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab6':{ u:'0ab6', i:2515, name:'GUJARATI LETTER SHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab7':{ u:'0ab7', i:2516, name:'GUJARATI LETTER SSA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab8':{ u:'0ab8', i:2517, name:'GUJARATI LETTER SA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ab9':{ u:'0ab9', i:2518, name:'GUJARATI LETTER HA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0abc':{ u:'0abc', i:2519, name:'GUJARATI SIGN NUKTA', cat:c.Mn,   canon:k._7, block:b[25]},
			'0abd':{ u:'0abd', i:2520, name:'GUJARATI SIGN AVAGRAHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0abe':{ u:'0abe', i:2521, name:'GUJARATI VOWEL SIGN AA', cat:c.Mc,   canon:k._0, block:b[25]},
			'0abf':{ u:'0abf', i:2522, name:'GUJARATI VOWEL SIGN I', cat:c.Mc,   canon:k._0, block:b[25], indexed:["I"]},
			'0ac0':{ u:'0ac0', i:2523, name:'GUJARATI VOWEL SIGN II', cat:c.Mc,   canon:k._0, block:b[25]},
			'0ac1':{ u:'0ac1', i:2524, name:'GUJARATI VOWEL SIGN U', cat:c.Mn,   canon:k._0, block:b[25], indexed:["U"]},
			'0ac2':{ u:'0ac2', i:2525, name:'GUJARATI VOWEL SIGN UU', cat:c.Mn,   canon:k._0, block:b[25]},
			'0ac3':{ u:'0ac3', i:2526, name:'GUJARATI VOWEL SIGN VOCALIC R', cat:c.Mn,   canon:k._0, block:b[25], indexed:["R"]},
			'0ac4':{ u:'0ac4', i:2527, name:'GUJARATI VOWEL SIGN VOCALIC RR', cat:c.Mn,   canon:k._0, block:b[25]},
			'0ac5':{ u:'0ac5', i:2528, name:'GUJARATI VOWEL SIGN CANDRA E', cat:c.Mn,   canon:k._0, block:b[25], indexed:["E"]},
			'0ac7':{ u:'0ac7', i:2529, name:'GUJARATI VOWEL SIGN E', cat:c.Mn,   canon:k._0, block:b[25], indexed:["E"]},
			'0ac8':{ u:'0ac8', i:2530, name:'GUJARATI VOWEL SIGN AI', cat:c.Mn,   canon:k._0, block:b[25]},
			'0ac9':{ u:'0ac9', i:2531, name:'GUJARATI VOWEL SIGN CANDRA O', cat:c.Mc,   canon:k._0, block:b[25], indexed:["O"]},
			'0acb':{ u:'0acb', i:2532, name:'GUJARATI VOWEL SIGN O', cat:c.Mc,   canon:k._0, block:b[25], indexed:["O"]},
			'0acc':{ u:'0acc', i:2533, name:'GUJARATI VOWEL SIGN AU', cat:c.Mc,   canon:k._0, block:b[25]},
			'0acd':{ u:'0acd', i:2534, name:'GUJARATI SIGN VIRAMA', cat:c.Mn,   canon:k._9, block:b[25]},
			'0ad0':{ u:'0ad0', i:2535, name:'GUJARATI OM', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ae0':{ u:'0ae0', i:2536, name:'GUJARATI LETTER VOCALIC RR', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ae1':{ u:'0ae1', i:2537, name:'GUJARATI LETTER VOCALIC LL', cat:c.Lo,   canon:k._0, block:b[25]},
			'0ae2':{ u:'0ae2', i:2538, name:'GUJARATI VOWEL SIGN VOCALIC L', cat:c.Mn,   canon:k._0, block:b[25], indexed:["L"]},
			'0ae3':{ u:'0ae3', i:2539, name:'GUJARATI VOWEL SIGN VOCALIC LL', cat:c.Mn,   canon:k._0, block:b[25]},
			'0ae6':{ u:'0ae6', i:2540, name:'GUJARATI DIGIT ZERO', cat:c.Nd,   canon:k._0, block:b[25]},
			'0ae7':{ u:'0ae7', i:2541, name:'GUJARATI DIGIT ONE', cat:c.Nd,   canon:k._0, block:b[25]},
			'0ae8':{ u:'0ae8', i:2542, name:'GUJARATI DIGIT TWO', cat:c.Nd,   canon:k._0, block:b[25]},
			'0ae9':{ u:'0ae9', i:2543, name:'GUJARATI DIGIT THREE', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aea':{ u:'0aea', i:2544, name:'GUJARATI DIGIT FOUR', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aeb':{ u:'0aeb', i:2545, name:'GUJARATI DIGIT FIVE', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aec':{ u:'0aec', i:2546, name:'GUJARATI DIGIT SIX', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aed':{ u:'0aed', i:2547, name:'GUJARATI DIGIT SEVEN', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aee':{ u:'0aee', i:2548, name:'GUJARATI DIGIT EIGHT', cat:c.Nd,   canon:k._0, block:b[25]},
			'0aef':{ u:'0aef', i:2549, name:'GUJARATI DIGIT NINE', cat:c.Nd,   canon:k._0, block:b[25]},
			'0af0':{ u:'0af0', i:2550, name:'GUJARATI ABBREVIATION SIGN', cat:c.Po,   canon:k._0, block:b[25]},
			'0af1':{ u:'0af1', i:2551, name:'GUJARATI RUPEE SIGN', cat:c.Sc,   canon:k._0, block:b[25]},
			'0af9':{ u:'0af9', i:2552, name:'GUJARATI LETTER ZHA', cat:c.Lo,   canon:k._0, block:b[25]},
			'0afa':{ u:'0afa', i:2553, name:'GUJARATI SIGN SUKUN', cat:c.Mn,   canon:k._0, block:b[25]},
			'0afb':{ u:'0afb', i:2554, name:'GUJARATI SIGN SHADDA', cat:c.Mn,   canon:k._0, block:b[25]},
			'0afc':{ u:'0afc', i:2555, name:'GUJARATI SIGN MADDAH', cat:c.Mn,   canon:k._0, block:b[25]},
			'0afd':{ u:'0afd', i:2556, name:'GUJARATI SIGN THREE-DOT NUKTA ABOVE', cat:c.Mn,   canon:k._0, block:b[25]},
			'0afe':{ u:'0afe', i:2557, name:'GUJARATI SIGN CIRCLE NUKTA ABOVE', cat:c.Mn,   canon:k._0, block:b[25]},
			'0aff':{ u:'0aff', i:2558, name:'GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE', cat:c.Mn,   canon:k._0, block:b[25]},
			'0b01':{ u:'0b01', i:2559, name:'ORIYA SIGN CANDRABINDU', cat:c.Mn,   canon:k._0, block:b[26]},
			'0b02':{ u:'0b02', i:2560, name:'ORIYA SIGN ANUSVARA', cat:c.Mc,   canon:k._0, block:b[26]},
			'0b03':{ u:'0b03', i:2561, name:'ORIYA SIGN VISARGA', cat:c.Mc,   canon:k._0, block:b[26]},
			'0b05':{ u:'0b05', i:2562, name:'ORIYA LETTER A', cat:c.Lo,   canon:k._0, block:b[26], indexed:["A"]},
			'0b06':{ u:'0b06', i:2563, name:'ORIYA LETTER AA', cat:c.Lo,   canon:k._0, block:b[26]},
			'0b07':{ u:'0b07', i:2564, name:'ORIYA LETTER I', cat:c.Lo,   canon:k._0, block:b[26], indexed:["I"]},
			'0b08':{ u:'0b08', i:2565, name:'ORIYA LETTER II', cat:c.Lo,   canon:k._0, block:b[26]},
			'0b09':{ u:'0b09', i:2566, name:'ORIYA LETTER U', cat:c.Lo,   canon:k._0, block:b[26], indexed:["U"]},
			'0b0a':{ u:'0b0a', i:2567, name:'ORIYA LETTER UU', cat:c.Lo,   canon:k._0, block:b[26]},
			'0b0b':{ u:'0b0b', i:2568, name:'ORIYA LETTER VOCALIC R', cat:c.Lo,   canon:k._0, block:b[26], indexed:["R"]},
			'0b0c':{ u:'0b0c', i:2569, name:'ORIYA LETTER VOCALIC L', cat:c.Lo,   canon:k._0, block:b[26], indexed:["L"]},
			'0b0f':{ u:'0b0f', i:2570, name:'ORIYA LETTER E', cat:c.Lo,   canon:k._0, block:b[26], indexed:["E"]},
			'0b10':{ u:'0b10', i:2571, name:'ORIYA LETTER AI', cat:c.Lo,   canon:k._0, block:b[26]},
			'0b13':{ u:'0b13', i:2572, name:'ORIYA LETTER O', cat:c.Lo,   canon:k._0, block:b[26], indexed:["O"]},
			'0b14':{ u:'0b14', i:2573, name:'ORIYA LETTER AU', cat:c.Lo,   canon:k._