# Hacking Guide
## This is the guide for you to start adding modules/tools to the repo


### Modules
Modules can be generated by running ./Template.py Type Name

Current Types:

1.	SDK
2.	API
3.	ThirdPartyTools
4.	Utils

~~For now, it only divides modules into seperate folders to make the modules look tidy.In the future we'll group settings based on those types.~~   ***It's live now.***

**Please Make Sure The Types Are Correct**

Also.There is a init_XXX_hook function inside each module,which XXX in your module name.

The main tweak will call that to init your hook.Check below for details

#### Names
##### For Modules. 
All these must be the same.

1.	Module File Name
2.	init function name component (see Modules Part)

*Please make sure the names are short and descriptive. We generate settings button text base on module name*

#### For Third Party Components

**Read ThirdPartyTools/README.md for detailed info**


#### Prototype Codes
Some codes, you might not want to expose them directly. Either because they have bugs, or, they are incomplete.

Put These Codes Inside **#ifdef PROTOTYPE** and **#endif**

These codes will be enabled only when PROTOTYPE Flag for build.py is *Implicitly* turned on.(See Below)


#### Custom Preferences
Add Your Own Preferences in **Preferences/** With Filename **MODULENAME.plist**

They will be injected into the *items* of the final Preferences Loader PLIST file

#### Marcos
Two Groups Of Marcos Has Been Created For Logging Purposes.
Please Call Exactly In The Following Sequence
##### Common Logging
1.	WTInit(ClassName,methodName)  **(For C Functions. Change ClassName to Library Name. For Example dlopen corresponds to dlfcn because it's in dlfcn.h)**
2.	WTAdd(Argument,Name) **The First is the argument itself. The second is the argument name**
3.	WTReturn(Return) **Return is the return value to add**
4.	WTSave	**No Arguments. It saves the log to database.**
5.	WTRelease **Release The Memory Of The Logger**
6.	WTShouldLog **if(WTShouldLog){} to check if it's called by the app itself**

##### Hooking
Wrappers of MS API Are in Hooks/Misc/WTSubstrate.h

Currently 

1.	WTHookFunction
2.	WTFindSymbol

Are available with the exact same usage with their MS* Equivalent

Use them instead of MS** Ones as they take care of jailed situation


##### dyld CallBack
1.	WTCallBack(LibraryName,FunctionToCall) **Generate A Function That Call FunctionToCall() when an image which path containing LibraryName is loaded. You Can Init Hooks inside FunctionToCall**
2.	WTAddCallBack(Loader) **Register the callback with dyld and execute Loader().Please Note That Loader Should Be The Function That Actually Init The Hooks,Not The CallBack**

Please Note:

1.	WTAdd can be called for many times. That's for adding Arguments
2.	WTInit,WTSave,WTRelease Must Be Called Under any circumstances
3.	Add Semicolons Yourself
4.	Don't add semicolon to WTCallBack
5.	Only One Set Of **dyld CallBack** Marcos Can Be Called In A Module

#### Building
You Probably Need The Latest Substrate Header. Check [Issues#1](https://github.com/Naville/WTFJH/issues/1) In Case Something Went Wrong.

Usually. Simple run **./build.py** is enough
Other Arguments(Upper/Lower Case Doesn't Matter):

1.	DEBUG. Show Compiling Info Inside Terminal. When Not Set. Logs Are Saved In **STDERR.log** and **STDOUT.log**
2.	OBFUSCATION OBFUSCATION SYMBOLS (NOT ALL. NEED CONTRIBUTIONS)
3.	PROTOTYPE *Enable Codes Flagged As Prototype*
4.	DISABLE=ModuleName1,ModuleName2,.........   *DISABLE UNWANTED MODULES*
5.	JAILED *Will Attempt To Build For Non-Jailbroken Devices.MSHookFunction Will Switch To FishHook*



#### Misc
Some functions don't come with the binary and you'll have to wait the related library to be loaded 

**Example: libMobileGestalt**

I personally use a dyldCallBack for that.

You might want to dlopen() that library itself.However that will also cause performance issues

When built with *JAILED* on, ThirdPartyToolsLoader will attempt to dlopen():

```
 @"%@/TEMPLATENAME.dylib",[NSBundle mainBundle].bundlePath  

```

Make sure it's correctly signed

Everything in BuildConfig should be pretty self-explainary. Except *CreateExtraSegs* , which is a dict, used to inject file-on-disk into the tweak. Key is SegmentName and Value is path to the file


#### Limitations

	syscall and its variations are no longer hooked as it's unstable and they are only barely a wrapper for corresponding assembly instruction, which is impossible to hook

	Also, other APIs in */usr/lib/system/libsystem_kernel.dylib* are also not hooked as they are only a wrapper around direct syscalls
	(Might implement in the future)

	

