# Vue 实现的影视评分类网站

一个基于 `vue` 实现的移动端影视评分网站项目的管理后台，涉及 `70+` 个页面，`200+` 个接口，包含数据统计、影视管理、影人管理、相册管理、用户管理、角色菜单权限等多个功能。
本项目会长期更新。

## 演示
- 演示地址：[https://test-admin.ixook.com](https://test-admin.ixook.com)  
- 接口文档：[https://doc.ixook.com](https://doc.ixook.com/doc/movie-admin-test/api)
- 开发文档：[https://admin-doc.ixook.com](https://admin-doc.ixook.com)

## 技术栈
- `vue2.6`
- `vuex`
- `vue-router`
- `vue-cli`
- `sass`
- `axios.js` [基于 promise 的 HTTP 库](https://www.kancloud.cn/yunye/axios/234845) 
- `iconfont` [阿里字体图标库](https://www.iconfont.cn/)
- `element-ui` [饿了么UI组件库](https://element.eleme.cn) 
- `cropperjs` [图片裁剪插件](https://github.com/fengyuanchen/cropperjs)
- `echarts` [百度图表插件](https://echarts.apache.org/zh/index.html)
- `vue-lazyload` [图片懒加载插件](https://github.com/hilongjw/vue-lazyload)
- `vue-json-viewer` [json 数据预览组件](https://github.com/chenfengjw163/vue-json-viewer)
- `vuedraggable` [一款基于 Sortable.js 的 Vue 拖拽组件](https://github.com/SortableJS/Vue.Draggable)
- `wangeditor` [一款简洁的开源 Web 富文本编辑器](https://www.wangeditor.com)

## 安装
```
npm install
```

## 开发环境启动
```
npm run serve
```

## 打包编译
```
npm run build
```

## 主体功能脑图
![慕影网管理端.png](https://note-file.ixook.com/FvOUclSznH8_FrRFh7-SPvssXLBg)


## 联系作者
如有问题可以提 `issue` 或者加入qq群: `577133021` 进行反馈

作者主页地址：[https://ixook.com](https://ixook.com)


## License
GPL
