/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000214d0ULL, 0x0000000000021150ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x000000000001f020ULL, 0x0000000000000170ULL,
0x000b0022000004bdULL, 0x000000000001f190ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x000000000001f1d0ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x000000000001f210ULL,
0x0000000000000070ULL, 0x000b00220000053dULL, 0x000000000001f280ULL, 0x0000000000000100ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001f380ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001f02000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x007aa00400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x9508288080920828ULL, 0x2880809808288080ULL, 0x809b082880809a08ULL, 0x08288080a0082880ULL,
0x8080a608288080a4ULL, 0x8408288080a70828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x0028808084920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001f02000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9208288080840828ULL, 0x2880809508288080ULL, 0x809a082880809808ULL,
0x082880809b082880ULL, 0x8080a408288080a0ULL, 0x8c08288080a70828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x0001f19000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080840828ULL, 0x2880809508288080ULL,
0x809a082880809808ULL, 0x082880809b082880ULL, 0x8080a608288080a4ULL, 0xa008288080a70828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000001c000000000ULL, 0x0001f1d000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080840828ULL,
0x2880809508288080ULL, 0x809a082880809808ULL, 0x082880809b082880ULL, 0x8080a608288080a0ULL,
0xa408288080a70828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a4920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL, 0x0001f21000000000ULL,
0x0000007000000000ULL, 0x0000180400000000ULL, 0x80a0288080a40900ULL, 0x0000000000002880ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080840828ULL, 0x2880809508288080ULL,
0x809a082880809808ULL, 0x082880809b082880ULL, 0x8080a608288080a4ULL, 0xa008288080a70828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000032000000000ULL, 0x0001f28000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x00082304000000a1ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL,
0x0000001b00081104ULL, 0x0004370400000000ULL, 0x00080a040000007bULL, 0x0068016000000018ULL,
0x000c170400681903ULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000003000043104ULL, 0xffffffff01bc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001bc2804ULL, 0x0000048000000130ULL,
0x00003560000034d0ULL, 0x000037c000003660ULL, 0x00003a20000039f0ULL, 0x00003ac000003a70ULL,
0x00006210000061f0ULL, 0x000062b000006260ULL, 0x00008e7000008de0ULL, 0x000090b000008f60ULL,
0x000092f0000092d0ULL, 0x0000939000009340ULL, 0x0000b8e00000b8c0ULL, 0x0000b9800000b930ULL,
0x0000e4300000e3a0ULL, 0x0000e6700000e520ULL, 0x0000e8b00000e890ULL, 0x0000e9500000e900ULL,
0x00010ea000010e80ULL, 0x00010f4000010ef0ULL, 0x000139f000013960ULL, 0x00013c3000013ae0ULL,
0x00013e7000013e50ULL, 0x00013f1000013ec0ULL, 0x0001646000016440ULL, 0x00016500000164b0ULL,
0x000179f0000178b0ULL, 0x00017ff000017fd0ULL, 0x000194f000018440ULL, 0x00019f8000019f60ULL,
0x0001b0300001b010ULL, 0x0001d4800001d440ULL, 0x0001d4a00001d490ULL, 0x0001d5100001d4b0ULL,
0x0001d5500001d530ULL, 0x0001e1c00001e170ULL, 0x0001e2800001e220ULL, 0x0001e3400001e2e0ULL,
0x0001e4000001e3a0ULL, 0x0001e4a00001e450ULL, 0x0001e5500001e4f0ULL, 0x0001e6100001e5b0ULL,
0x0001e6d00001e670ULL, 0x0001e7700001e720ULL, 0x0001e8200001e7c0ULL, 0x0001e8e00001e880ULL,
0x0001e9a00001e940ULL, 0x0001ea400001e9f0ULL, 0x0001eaf00001ea90ULL, 0x0001ebb00001eb50ULL,
0x0001ec700001ec10ULL, 0x0001ed100001ecc0ULL, 0x0001edc00001ed60ULL, 0x0001ee800001ee20ULL,
0x0001ef400001eee0ULL, 0x0001f0000001efa0ULL, 0x0000023007e03904ULL, 0x00010ad0000000ffULL,
0x00000260003f0100ULL, 0x00010ad80000000bULL, 0x00000360003f0120ULL, 0x00010b580000000bULL,
0x00000390003f0120ULL, 0x00010b780000000bULL, 0x00000430003f0120ULL, 0x00010b88000000ffULL,
0x00000500003f0100ULL, 0x00010ad0000000ffULL, 0x000007f0003f0107ULL, 0x00010b5c000000ffULL,
0x0000085000050102ULL, 0x00010b58000000ffULL, 0x000009d000050101ULL, 0x00010b88000000ffULL,
0x00000a10003f0101ULL, 0x00010b8c000000ffULL, 0x00000bd0003f0105ULL, 0x00010b8c000000ffULL,
0x000015e0003f0105ULL, 0x00010b88000000ffULL, 0x00001610003f0101ULL, 0x00010b8c000000ffULL,
0x000017e0003f0105ULL, 0x00010b8c000000ffULL, 0x00001950003f0105ULL, 0x00010b78000000ffULL,
0x000019d0003f0107ULL, 0x00010b78000000ffULL, 0x00001a30003f0101ULL, 0x00010b88000000ffULL,
0x00001d10003f0101ULL, 0x00010b7c000000ffULL, 0x00001ed0003f0105ULL, 0x00010b7c000000ffULL,
0x00001f30003f0105ULL, 0x00010b8c000000ffULL, 0x00002100003f0105ULL, 0x00010b8c000000ffULL,
0x00002b60003f0105ULL, 0x00010b88000000ffULL, 0x00002b90003f0101ULL, 0x00010b8c000000ffULL,
0x00002d60003f0105ULL, 0x00010b8c000000ffULL, 0x000030c0003f0105ULL, 0x00010b80000000ffULL,
0x00003140003f0107ULL, 0x00010b80000000ffULL, 0x000031f0003f0101ULL, 0x00010ad8000000ffULL,
0x0000322000050101ULL, 0x00010adc000000ffULL, 0x000033f000050105ULL, 0x00010adc000000ffULL,
0x00004e4000050105ULL, 0x00010b88000000ffULL, 0x00004f10003f0101ULL, 0x00010b84000000ffULL,
0x000050d0003f0105ULL, 0x00010b84000000ffULL, 0x00005130003f0105ULL, 0x00010b8c000000ffULL,
0x00005300003f0105ULL, 0x00010b8c000000ffULL, 0x00005d30003f0105ULL, 0x00010b88000000ffULL,
0x00005d60003f0101ULL, 0x00010b8c000000ffULL, 0x00005f30003f0105ULL, 0x00010b8c000000ffULL,
0x00006100003f0105ULL, 0x00010b78000000ffULL, 0x00006180003f0107ULL, 0x00010b78000000ffULL,
0x000074e0003f0101ULL, 0x00010b88000000ffULL, 0x00007590003f0101ULL, 0x00010b58000000ffULL,
0x00007670003f0101ULL, 0x00010b7c000000ffULL, 0x00007830003f0105ULL, 0x00010b7c000000ffULL,
0x00007890003f0105ULL, 0x00010b8c000000ffULL, 0x00007a60003f0105ULL, 0x00010b8c000000ffULL,
0x000084b0003f0105ULL, 0x00010b88000000ffULL, 0x000084e0003f0101ULL, 0x00010b8c000000ffULL,
0x000086b0003f0105ULL, 0x00010b8c000000ffULL, 0x000089e0003f0105ULL, 0x00010b80000000ffULL,
0x00008a60003f0107ULL, 0x00010b80000000ffULL, 0x00008b00003f0101ULL, 0x00010af8000000ffULL,
0x00008b3000050101ULL, 0x00010afc000000ffULL, 0x00008d0000050105ULL, 0x00010afc000000ffULL,
0x0000a51000050105ULL, 0x00010b88000000ffULL, 0x0000a5f0003f0101ULL, 0x00010b84000000ffULL,
0x0000a7b0003f0105ULL, 0x00010b84000000ffULL, 0x0000a810003f0105ULL, 0x00010b8c000000ffULL,
0x0000a9e0003f0105ULL, 0x00010b8c000000ffULL, 0x0000b410003f0105ULL, 0x00010b88000000ffULL,
0x0000b440003f0101ULL, 0x00010b8c000000ffULL, 0x0000b610003f0105ULL, 0x00010b8c000000ffULL,
0x0000b7e0003f0105ULL, 0x00010b78000000ffULL, 0x0000b860003f0107ULL, 0x00010b78000000ffULL,
0x0000cac0003f0101ULL, 0x00010b88000000ffULL, 0x0000cb50003f0101ULL, 0x00010b60000000ffULL,
0x0000cc30003f0101ULL, 0x00010b7c000000ffULL, 0x0000cdf0003f0105ULL, 0x00010b7c000000ffULL,
0x0000ce50003f0105ULL, 0x00010b8c000000ffULL, 0x0000d020003f0105ULL, 0x00010b8c000000ffULL,
0x0000da70003f0105ULL, 0x00010b88000000ffULL, 0x0000daa0003f0101ULL, 0x00010b8c000000ffULL,
0x0000dc70003f0105ULL, 0x00010b8c000000ffULL, 0x0000dfa0003f0105ULL, 0x00010b80000000ffULL,
0x0000e020003f0107ULL, 0x00010b80000000ffULL, 0x0000e0c0003f0101ULL, 0x00010b18000000ffULL,
0x0000e0f000050101ULL, 0x00010b1c000000ffULL, 0x0000e2c000050105ULL, 0x00010b1c000000ffULL,
0x0000fad000050105ULL, 0x00010b88000000ffULL, 0x0000fbb0003f0101ULL, 0x00010b84000000ffULL,
0x0000fd70003f0105ULL, 0x00010b84000000ffULL, 0x0000fdd0003f0105ULL, 0x00010b8c000000ffULL,
0x0000ffa0003f0105ULL, 0x00010b8c000000ffULL, 0x000109d0003f0105ULL, 0x00010b88000000ffULL,
0x00010a00003f0101ULL, 0x00010b8c000000ffULL, 0x00010bd0003f0105ULL, 0x00010b8c000000ffULL,
0x00010da0003f0105ULL, 0x00010b78000000ffULL, 0x00010e20003f0107ULL, 0x00010b78000000ffULL,
0x00012080003f0101ULL, 0x00010b88000000ffULL, 0x00012110003f0101ULL, 0x00010b68000000ffULL,
0x000121f0003f0101ULL, 0x00010b7c000000ffULL, 0x000123b0003f0105ULL, 0x00010b7c000000ffULL,
0x00012410003f0105ULL, 0x00010b8c000000ffULL, 0x000125e0003f0105ULL, 0x00010b8c000000ffULL,
0x00013030003f0105ULL, 0x00010b88000000ffULL, 0x00013060003f0101ULL, 0x00010b8c000000ffULL,
0x00013230003f0105ULL, 0x00010b8c000000ffULL, 0x00013560003f0105ULL, 0x00010b80000000ffULL,
0x000135e0003f0107ULL, 0x00010b80000000ffULL, 0x00013680003f0101ULL, 0x00010b38000000ffULL,
0x000136b000050101ULL, 0x00010b3c000000ffULL, 0x0001388000050105ULL, 0x00010b3c000000ffULL,
0x0001509000050105ULL, 0x00010b88000000ffULL, 0x00015170003f0101ULL, 0x00010b84000000ffULL,
0x00015330003f0105ULL, 0x00010b84000000ffULL, 0x00015390003f0105ULL, 0x00010b8c000000ffULL,
0x00015560003f0105ULL, 0x00010b8c000000ffULL, 0x00015f90003f0105ULL, 0x00010b88000000ffULL,
0x00015fc0003f0101ULL, 0x00010b8c000000ffULL, 0x00016190003f0105ULL, 0x00010b8c000000ffULL,
0x00016360003f0105ULL, 0x00010b78000000ffULL, 0x000163e0003f0107ULL, 0x00010b78000000ffULL,
0x00017640003f0101ULL, 0x00010b88000000ffULL, 0x000176c0003f0101ULL, 0x00010b70000000ffULL,
0x00018220003f0101ULL, 0x00010ad0000000ffULL, 0x00019520003f0101ULL, 0x00010ad4000000ffULL,
0x000196f0003f0105ULL, 0x00010ad4000000ffULL, 0x00019a70003f0105ULL, 0x00010ad0000000ffULL,
0x00019ab0003f0101ULL, 0x00010ad4000000ffULL, 0x00019c70003f0105ULL, 0x00010ad4000000ffULL,
0x0001c740003f0105ULL, 0x0000000000000055ULL, 0x0001c970003f0101ULL, 0x0000000400000055ULL,
0x0001cb40003f0105ULL, 0x0000000400000055ULL, 0x0001dfd0003f0105ULL, 0x0000000000000052ULL,
0x0001e030003f0101ULL, 0x0000000800000052ULL, 0x0001e090003f0101ULL, 0x0000001000000052ULL,
0x0001e100003f0101ULL, 0x0000001800000052ULL, 0x00053803003f0101ULL, 0x0001812000101c04ULL,
0x00019db000019cd0ULL, 0x000004010001e140ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003b4ULL,
0x0000001b00000002ULL, 0x00000000000002fcULL, 0x0000001b00000002ULL, 0x0000000000000254ULL,
0x0000001b00000002ULL, 0x00000000000001acULL, 0x0000001b00000002ULL, 0x0000000000000104ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x000000000000038aULL,
0x0000001b00000002ULL, 0x00000000000002d2ULL, 0x0000001b00000002ULL, 0x000000000000022aULL,
0x0000001b00000002ULL, 0x0000000000000182ULL, 0x0000001b00000002ULL, 0x00000000000000daULL,
0x0000001b00000002ULL, 0x0000000000010c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000b79c3ULL, 0x000ea20000002700ULL, 0x0000000000147806ULL, 0x000fe200038e0000ULL,
0x00005800ff107624ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x0000001400077300ULL, 0x000fe200000e0000ULL,
0x00004600000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee20000002200ULL,
0x0000000400097882ULL, 0x000fc60000000000ULL, 0x00000000000f7919ULL, 0x000f240000000000ULL,
0x0000001400147309ULL, 0x000ee40000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fe2000001160bULL, 0x000000020b0a7899ULL, 0x004fca000800063fULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000ffff147224ULL, 0x008fe400078e0a14ULL,
0x000001000a027a24ULL, 0x000fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000ea400000e0000ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000080700720cULL, 0x010fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003f25270ULL, 0x0000000f0b00780cULL, 0x040fe40003f44070ULL,
0x000000030b00780cULL, 0x040fe40003f64070ULL, 0x000000010b00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0b00780cULL, 0x000fe20003f84070ULL, 0x00000000000873c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff029424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x0000000000007919ULL, 0x002e620000002600ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff00ff08d424ULL, 0x000fe200078e00ffULL, 0x010ad002ff009388ULL, 0x0007e20000000a00ULL,
0x7fffff00ff09d424ULL, 0x000fc400078e00ffULL, 0xff317217ff12c424ULL, 0x000fe200078e00ffULL,
0x010ad8040b00a388ULL, 0x0009e80000008a00ULL, 0x010400120b00c388ULL, 0x000fe20000004800ULL,
0x0000000410037824ULL, 0x008fe200078e00ffULL, 0x000000080a067c11ULL, 0x004fe2000f8e10ffULL,
0x000000100f047824ULL, 0x010fc800078e00ffULL, 0x00000002060c7824ULL, 0x000fe400078e00ffULL,
0x0000000b03037c24ULL, 0x002fe2000f8e0200ULL, 0x000001f004117812ULL, 0x000fe200078ec0ffULL,
0x000000010c0d7824ULL, 0x040fe200078e020fULL, 0x000000040c057817ULL, 0x040fe20007800000ULL,
0x000000200c0e7824ULL, 0x040fe200078e00ffULL, 0x000000010c107810ULL, 0x040fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL, 0x000058000c027a24ULL, 0x000fe200078e0203ULL,
0xffffffe00e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001050d7824ULL, 0x000fe200078e0a0cULL,
0x010b58060b00b388ULL, 0x0003e20000008a00ULL, 0x0000580010047a24ULL, 0x000fc400078e0203ULL,
0x00005c0002027625ULL, 0x080fe200078e0013ULL, 0x010b78080b00d388ULL, 0x0005e20000008a00ULL,
0x000000ff0d00720cULL, 0x040fe40003f43070ULL, 0x00005c0004047625ULL, 0x000fe200078e0013ULL,
0x000000010d00780cULL, 0x000fe40003f63070ULL, 0x0000001102027210ULL, 0x080fe40007f9e0ffULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x3fffff80ff069424ULL, 0x002fc400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fe400078e00ffULL, 0x0000000110087824ULL, 0x044fe400078e020fULL,
0x0000002010097824ULL, 0x000fe200078e00ffULL, 0x010b8806ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0xffffffe009087812ULL, 0x000fe200078ee208ULL, 0x000000100e097824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000d101c4cULL,
0x000000ffff087224ULL, 0x000fc600078e0014ULL, 0x00000000040b7faeULL, 0x0003e8000d901c4cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x010ad408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000620000047ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL,
0x00006a0000067ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL,
0x00000004ff047e24ULL, 0x002fe4000f8e00ffULL, 0x00000005ff057e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff067e24ULL, 0x000fe4000f8e00ffULL, 0x00000007ff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c045f7981ULL, 0x000ea8000c1e1900ULL, 0x0000000c06067981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x0000003f5f5d7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff5f0c7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff5e7819ULL, 0x008fe40000011606ULL, 0x00000006ff5d7819ULL, 0x000fe4000001165dULL,
0x00000008ff607819ULL, 0x000fc6000001160cULL, 0x00017a9000008947ULL, 0x000fea0003800000ULL,
0x00000008ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000000308057899ULL, 0x000fe2000800063fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x00000003ff087424ULL, 0x000fe400078e00ffULL,
0x0000002003067824ULL, 0x000fca00078e020fULL, 0x0000001f0600780cULL, 0x040fe40003f04070ULL,
0x000000030600780cULL, 0x000fd60003f24070ULL, 0x0000007000000947ULL, 0x000fea0003800000ULL,
0x0000000aff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000005f0600720cULL, 0x040fe20003f06070ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x00010a0006077811ULL, 0x000fe200078e10ffULL,
0x0000680005047a24ULL, 0x000fc800078e0206ULL, 0x0000660004047625ULL, 0x000fcc00078e0009ULL,
0x0000000004077faeULL, 0x0003e4000c12184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5c08ffff798cULL, 0x0005e20008000005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b5800ffff7f8cULL, 0x000fe2000c800405ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e620000002700ULL, 0x000000ff5d00720cULL, 0x000fe20003f05270ULL,
0x00000004ff097424ULL, 0x000fe200078e00ffULL, 0x00010ac006077811ULL, 0x000fe200078e10ffULL,
0x0000000405047824ULL, 0x002fe400078e0206ULL, 0x00006400ff057624ULL, 0x000fe400078e00ffULL,
0x0000000204047824ULL, 0x000fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0205ULL,
0x0000600004047625ULL, 0x000fca00078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000812184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff087224ULL, 0x004fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0c00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fd4000800063fULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0x000000055f047c17ULL, 0x000fe2000f800000ULL,
0x00000100ff157424ULL, 0x000fc600078e00ffULL, 0x8000000504087c10ULL, 0x000fe4000fffe0ffULL,
0x00000004ff097819ULL, 0x002fe20000011617ULL, 0x0000001017137824ULL, 0x000fc600078e00ffULL,
0x00000005090b7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f013137812ULL, 0x000fe400078ec0ffULL,
0x000000080900720cULL, 0x000fe20003f06070ULL, 0x010a00000b067984ULL, 0x000e620000004800ULL,
0x00000040000d7824ULL, 0x000fe400078e020bULL, 0x000000010b077824ULL, 0x040fe400078e0217ULL,
0x000000100b0a7824ULL, 0x000fe200078e00ffULL, 0x000000020d117810ULL, 0x000fe20007ffe0ffULL,
0x010ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406047c24ULL, 0x002fc8000f8e020dULL,
0x00005e0004047625ULL, 0x000fca00078e0015ULL, 0x0000001304067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000c000040f7811ULL, 0x000fe400078e20ffULL, 0x0000000209057810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060f7faeULL, 0x0003e2000c101c4cULL,
0x00000005050a7c10ULL, 0x040fe4000fffe0ffULL, 0x000000080500720cULL, 0x000fe20003f06070ULL,
0x010a08000b0c7984ULL, 0x000ea40000004800ULL, 0x000000010a0e7824ULL, 0x000fe400078e0217ULL,
0x010ac0000c0c7984ULL, 0x004ea40000004800ULL, 0x000000040c047c24ULL, 0x004fc4000f8e0211ULL,
0x000000100a117824ULL, 0x000fe400078e00ffULL, 0x00005e0004047625ULL, 0x000fc600078e0015ULL,
0xfffffff0110e7812ULL, 0x000fe400078ee20eULL, 0x0000001304067210ULL, 0x002fe40007f3e0ffULL,
0x0000c0000e0f7811ULL, 0x000fe400078e20ffULL, 0x000000040d117810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000409057810ULL, 0x000fe40007ffe0ffULL,
0x000000060d0d7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c4cULL, 0x00000005050a7c10ULL, 0x040fe4000fffe0ffULL,
0x000000080500720cULL, 0x000fe20003f06070ULL, 0x010a10000b0c7984ULL, 0x000ea20000004800ULL,
0x0000000609097810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0e7824ULL, 0x000fe400078e0217ULL,
0x010ac0000c0c7984ULL, 0x004ea40000004800ULL, 0x000000040c047c24ULL, 0x004fc4000f8e0211ULL,
0x000000100a117824ULL, 0x000fe200078e00ffULL, 0x00000005090a7c10ULL, 0x000fe2000fffe0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0015ULL, 0xfffffff0110e7812ULL, 0x000fe400078ee20eULL,
0x0000001304067210ULL, 0x002fe40007f3e0ffULL, 0x0000c0000e0f7811ULL, 0x000fc600078e20ffULL,
0x000000ffff077224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e2000c101c4cULL, 0x000000080900720cULL, 0x000fe20003f06070ULL,
0x000000010a087824ULL, 0x040fe400078e0217ULL, 0x010a18000b0b7984ULL, 0x000ea20000004800ULL,
0x000000100a097824ULL, 0x000fca00078e00ffULL, 0xfffffff009087812ULL, 0x000fc800078ee208ULL,
0x0000c00008077811ULL, 0x002fe200078e20ffULL, 0x010ac0000b047984ULL, 0x004e640000004800ULL,
0x0000000404047c24ULL, 0x002fc8000f8e020dULL, 0x00005e0004047625ULL, 0x000fca00078e0015ULL,
0x0000001304047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00000100ff0c7424ULL, 0x000fe200078e00ffULL, 0x00000005110b7c11ULL, 0x042fe2000f8fe0ffULL,
0x0000001011057824ULL, 0x000fc800078e00ffULL, 0x010a00000b087984ULL, 0x000e620000004800ULL,
0x00000040000d7824ULL, 0x000fe200078e020bULL, 0x000000f005137812ULL, 0x000fe200078ec0ffULL,
0x000000010b077824ULL, 0x040fe400078e0211ULL, 0x000000100b0a7824ULL, 0x040fe200078e00ffULL,
0x010ac00008087984ULL, 0x002e640000004800ULL, 0x0000000408047c24ULL, 0x002fe2000f8e020dULL,
0x000000020b087810ULL, 0x000fc60007ffe0ffULL, 0x00005e0004047625ULL, 0x000fc800078e000cULL,
0x0000000108097824ULL, 0x000fe200078e0211ULL, 0x0000001304067210ULL, 0x000fe20007f1e0ffULL,
0x00000010080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00a047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000c000040f7811ULL, 0x000fe400078e20ffULL,
0x000000020d057810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0003e8000b901c4cULL, 0x010a08000b0a7984ULL, 0x000ea20000004800ULL,
0x000000040b067810ULL, 0x002fca0007ffe0ffULL, 0x0000000106077824ULL, 0x000fe200078e0211ULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000cULL, 0x0000001304087210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e047812ULL, 0x000fe200078ee209ULL, 0x00000010060e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000c000040f7811ULL, 0x000fe400078e20ffULL,
0x000000040d057810ULL, 0x040fe40007ffe0ffULL, 0x000000060d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e8000b901c4cULL,
0x010a10000b0a7984ULL, 0x000ea20000004800ULL, 0x000000060b087810ULL, 0x002fc60007ffe0ffULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000cULL, 0x0000001304067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000c00004097811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c4cULL, 0x010a18000b0a7984ULL, 0x000ea80000004800ULL,
0x010ac0000a0a7984ULL, 0x004ea40000004800ULL, 0x000000040a047c24ULL, 0x004fc4000f8e020dULL,
0x00000010080d7824ULL, 0x000fe400078e00ffULL, 0x00005e0004047625ULL, 0x000fc800078e000cULL,
0x00000001080c7824ULL, 0x000fe200078e0211ULL, 0x0000001304047210ULL, 0x000fc80007f1e0ffULL,
0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff057224ULL, 0x000fc600000e0605ULL,
0x0000c0000c077811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c4cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff047f8cULL, 0x002e64000c80043fULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x010b8c00ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002003057824ULL, 0x002fca00078e0204ULL,
0x0000001f0500780cULL, 0x000fda0003f04070ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000000aff087e24ULL, 0x000fe2000f8e00ffULL, 0x0000002005067810ULL, 0x040fe20007ffe0ffULL,
0x00000004ff097424ULL, 0x000fe400078e00ffULL, 0x0000680008077a24ULL, 0x000fe200078e0205ULL,
0x0000005f0600720cULL, 0x000fe40003f06070ULL, 0x00010a0005057811ULL, 0x000fe400078e10ffULL,
0x0000002007067810ULL, 0x000fca0007ffe0ffULL, 0x0000660006067625ULL, 0x000fca00078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff067f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x000000ffff677224ULL, 0x002fe200078e0007ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5c7224ULL, 0x000fe200078e00ffULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000001fff107424ULL, 0x000fc400078e00ffULL,
0xffffffffff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x004fe400078e0009ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00015b6000008947ULL, 0x000fea0003800000ULL,
0x00005800ff157624ULL, 0x000fe200078e00ffULL, 0x00015b4000007945ULL, 0x000fe20003800000ULL,
0xff317217ff127424ULL, 0x000fe400078e00ffULL, 0x000000ffff5c7224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fc400078e00ffULL, 0x000000ffff147224ULL, 0x000fe400078e00ffULL,
0x0000004015157824ULL, 0x000fc400078e00ffULL, 0x0000010013167824ULL, 0x000fca00078e00ffULL,
0x0000005f1600720cULL, 0x000fda0003f06070ULL, 0x00015a7000000947ULL, 0x022fea0003800000ULL,
0x000000ffff667224ULL, 0x000fc600078e00ffULL, 0x000000135e00720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff177819ULL, 0x000fe20000011666ULL,
0x000000ffff227224ULL, 0x002fe200078e00ffULL, 0x0000000366167812ULL, 0x040fe400078ec0ffULL,
0x00000017661e7207ULL, 0x000fe40002800000ULL, 0x000000ff16167207ULL, 0x000fe40006800000ULL,
0x000000031e1c7812ULL, 0x000fc400078ec0ffULL, 0x000000131e177211ULL, 0x020fc400078ff0ffULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x00000024201e7210ULL, 0x000fca0007f1e1ffULL,
0x0000000125247824ULL, 0x000fe200000e0e21ULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011424ULL,
0x0000001e1d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff1e7224ULL, 0x000fca00000e0624ULL,
0x000000021d1d7819ULL, 0x000fc8000000121eULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x010b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024201e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125247824ULL, 0x000fe200000e0e21ULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011424ULL, 0x0000001e1d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e0624ULL, 0x000000021d1d7819ULL, 0x000fc8000000121eULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001171d7810ULL, 0x000fe20007ffe0ffULL,
0x000009a000017945ULL, 0x000fe60003800000ULL, 0x000000601d00720cULL, 0x000fda0003f06070ULL,
0x0000053000008947ULL, 0x000fea0003800000ULL, 0x00000004ff267819ULL, 0x000fe20000011604ULL,
0x00000004171e7824ULL, 0x000fe200078e021cULL, 0x0000002000247811ULL, 0x000fe200078e30ffULL,
0x0000001004217824ULL, 0x000fe200078e00ffULL, 0x0000000526277c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x000000201e1e7811ULL, 0x000fe400078e30ffULL,
0x000000f0212b7812ULL, 0x000fe200078ec0ffULL, 0x010a000027207984ULL, 0x000e620000004800ULL,
0x0000001e5f1d7217ULL, 0x000fe20007800000ULL, 0x0000000127237824ULL, 0x000fe200078e0204ULL,
0x0000000226287810ULL, 0x000fc60007ffe0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1eULL,
0x00000005282d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000001271e7824ULL, 0x000fc600078e0224ULL,
0x000000051d1d7c17ULL, 0x000fe2000f800000ULL, 0x000000012d2a7824ULL, 0x000fc600078e0204ULL,
0x800000051d1d7c10ULL, 0x000fc8000fffe0ffULL, 0x0000001d2600720cULL, 0x000fe20003f06070ULL,
0x010ac00020207984ULL, 0x002e640000004800ULL, 0x00000020151e7224ULL, 0x002fc800078e021eULL,
0x00005e001e207625ULL, 0x000fc800078e0029ULL, 0x00000010271e7824ULL, 0x000fe200078e00ffULL,
0x0000002b20227210ULL, 0x000fe20007f3e0ffULL, 0x000000012d207824ULL, 0x040fe400078e0224ULL,
0x000000102d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff01e257812ULL, 0x000fe200078ee223ULL,
0x000000ffff237224ULL, 0x000fc600008e0621ULL, 0x0000e00025257811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e2000c101c4cULL,
0x0000001d2800720cULL, 0x000fe40003f06070ULL, 0x0000000426287810ULL, 0x040fe20007ffe0ffULL,
0x010a0800271e7984ULL, 0x000ea20000004800ULL, 0x0000000626267810ULL, 0x000fe40007ffe0ffULL,
0xfffffff02d257812ULL, 0x002fe400078ee22aULL, 0x00000005282d7c10ULL, 0x000fe4000fffe0ffULL,
0x0000e00025257811ULL, 0x000fc600078e20ffULL, 0x000000012d2a7824ULL, 0x000fe200078e0204ULL,
0x010ac0001e1e7984ULL, 0x004e640000004800ULL, 0x0000001e15207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fca00078e0029ULL, 0x0000002b20227210ULL, 0x000fe20007f3e0ffULL,
0x000000012d207824ULL, 0x040fe400078e0224ULL, 0x000000102d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fca00008e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e2000c101c4cULL, 0x0000001d2800720cULL, 0x000fc60003f06070ULL,
0x010a1000271e7984ULL, 0x000ea20000004800ULL, 0xfffffff02d257812ULL, 0x002fe400078ee22aULL,
0x00000005262d7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e00025257811ULL, 0x000fc600078e20ffULL,
0x000000012d247824ULL, 0x000fe200078e0224ULL, 0x010ac0001e1e7984ULL, 0x004e640000004800ULL,
0x0000001e15207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff237224ULL, 0x000fca00008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e2000c101c4cULL,
0x0000001d2600720cULL, 0x000fe20003f06070ULL, 0x000000102d1d7824ULL, 0x000fe400078e00ffULL,
0x010a1800271e7984ULL, 0x000ea80000004800ULL, 0x010ac0001e1e7984ULL, 0x004ea40000004800ULL,
0x0000001e15207224ULL, 0x004fc400078e0224ULL, 0x000000012d247824ULL, 0x000fe400078e0204ULL,
0x00005e0020207625ULL, 0x000fc600078e0029ULL, 0xfffffff01d1d7812ULL, 0x000fe400078ee224ULL,
0x0000002b20207210ULL, 0x000fe40007f3e0ffULL, 0x0000e0001d1d7811ULL, 0x000fc600078e20ffULL,
0x000000ffff217224ULL, 0x000fca00008e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000201d7faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x0000000504277c11ULL, 0x040fe2000f8fe0ffULL, 0x0000001004217824ULL, 0x000fe200078e00ffULL,
0x0000002000267811ULL, 0x000fe200078e30ffULL, 0x00000100ff297424ULL, 0x000fe200078e00ffULL,
0x0000000227257810ULL, 0x000fe20007ffe0ffULL, 0x010a0000271d7984ULL, 0x000e620000004800ULL,
0x000000f0212b7812ULL, 0x000fe200078ec0ffULL, 0x0000000127207824ULL, 0x040fe400078e0226ULL,
0x0000001027237824ULL, 0x000fc400078e00ffULL, 0x0000000125287824ULL, 0x000fe200078e0204ULL,
0x010ac0001d1e7984ULL, 0x002e640000004800ULL, 0x0000001e15207224ULL, 0x002fe400078e0220ULL,
0x00000001271e7824ULL, 0x000fe400078e0204ULL, 0x00005e0020207625ULL, 0x000fc600078e0029ULL,
0xfffffff0231d7812ULL, 0x000fe400078ee21eULL, 0x0000002b20227210ULL, 0x000fe20007f1e0ffULL,
0x0000000125207824ULL, 0x000fe200078e0226ULL, 0x0000e0001d1d7811ULL, 0x000fe200078e20ffULL,
0x0000001025257824ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fc600000e0621ULL,
0xfffffff025287812ULL, 0x000fe400078ee228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221d7faeULL, 0x0003e8000b901c4cULL, 0x010a0800271e7984ULL, 0x000ea20000004800ULL,
0x0000e000281d7811ULL, 0x002fe400078e20ffULL, 0x0000000427237810ULL, 0x000fca0007ffe0ffULL,
0x0000000123287824ULL, 0x000fe200078e0204ULL, 0x010ac0001e1e7984ULL, 0x004e640000004800ULL,
0x0000001e15207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20247210ULL, 0x000fe20007f1e0ffULL, 0x0000000123207824ULL, 0x040fe400078e0226ULL,
0x0000001023237824ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fc600000e0621ULL,
0xfffffff023287812ULL, 0x000fe400078ee228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000241d7faeULL, 0x0003e8000b901c4cULL, 0x010a1000271e7984ULL, 0x000ea20000004800ULL,
0x0000e000281d7811ULL, 0x002fe400078e20ffULL, 0x0000000627257810ULL, 0x000fca0007ffe0ffULL,
0x0000000125247824ULL, 0x000fe200078e0204ULL, 0x010ac0001e1e7984ULL, 0x004e640000004800ULL,
0x0000001e15207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fe20007f1e0ffULL, 0x0000000125207824ULL, 0x040fe400078e0226ULL,
0x0000001025257824ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fc600000e0621ULL,
0xfffffff025247812ULL, 0x000fe400078ee224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221d7faeULL, 0x0003e8000b901c4cULL, 0x010a1800271e7984ULL, 0x000ea20000004800ULL,
0x0000e000241d7811ULL, 0x002fc600078e20ffULL, 0x010ac0001e1e7984ULL, 0x004e640000004800ULL,
0x0000001e15207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000201d7faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff247224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x00000022201e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000123227824ULL, 0x000fe200000e0e21ULL,
0x003d09001e00780cULL, 0x000fc80003f06070ULL, 0x000000ff2200720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401e00780cULL, 0x000fc80003f06070ULL,
0x000000ff2200720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011422ULL, 0x0000001e1d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff1e7224ULL, 0x000fca00000e0622ULL, 0x000000021d1d7819ULL, 0x000fc8000000121eULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000175e00720cULL, 0x000fe20003f04070ULL,
0x0000020000017945ULL, 0x000fe20003800000ULL, 0x00000001161d7810ULL, 0x040fe40007ffe0ffULL,
0x000000031600780cULL, 0x000fe20003f45270ULL, 0x0000002003167824ULL, 0x000fe200078e0204ULL,
0x000000031d1e7812ULL, 0x000fc400078ec0ffULL, 0x000000175e00720cULL, 0x000fe40003f24070ULL,
0x0000001f1600780cULL, 0x000fe40003f84070ULL, 0x000000ff1e1e7207ULL, 0x000fe40004000000ULL,
0x00000002ff1d8819ULL, 0x000fca000001161dULL, 0x000000011c1c7824ULL, 0x000fc800078e021dULL,
0x000000401c1d7824ULL, 0x040fe200078e00ffULL, 0x000000171c177211ULL, 0x000fc800078ff0ffULL,
0x000000c01d1c7812ULL, 0x000fca00078ec0ffULL, 0x0000010017207824ULL, 0x000fe200078e021cULL,
0x0000011000009947ULL, 0x000fea0001000000ULL, 0x00000020031c7824ULL, 0x000fe200078e0204ULL,
0x0000000114147810ULL, 0x000fc80007ffe0ffULL, 0x000000031c00780cULL, 0x000fda0003f04070ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000001d7919ULL, 0x000e620000002700ULL,
0x0000640014177a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff247424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe40003f06070ULL, 0x00010ac01c217811ULL, 0x000fe200078e10ffULL,
0x000000041d1d7824ULL, 0x002fc800078e021cULL, 0x000000021d227824ULL, 0x000fc800078e00ffULL,
0x0000640022177a24ULL, 0x000fc800078e0217ULL, 0x00006000171c7625ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000e000017945ULL, 0x000fe20003800000ULL,
0x000000c000004947ULL, 0x000fea0003800000ULL, 0x0000000a1e177c10ULL, 0x000fe2000fffe0ffULL,
0x00000001161c7824ULL, 0x042fe200078e0220ULL, 0x00010a0016217811ULL, 0x000fc600078e10ffULL,
0x0000680017177a24ULL, 0x000fe200078e0220ULL, 0x0000005f1c00720cULL, 0x000fe20003f06070ULL,
0x00000004ff1c7424ULL, 0x000fe400078e00ffULL, 0x0000000116177824ULL, 0x000fc800078e0217ULL,
0x00006600171c7625ULL, 0x000fcc00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff1c7f8cULL, 0x002e62000c80043fULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000081000017945ULL, 0x000fe20003800000ULL, 0xffffffffff177424ULL, 0x000fe400078e00ffULL,
0x000000ffff677224ULL, 0x002fd200078e001dULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad800ff1c7f8cULL, 0x000e64000c800405ULL,
0x000000ffff257224ULL, 0x002fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x010adc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011421ULL,
0x0000002318187211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000218187819ULL, 0x000fc80000001221ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010adc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001004187824ULL, 0x000fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fc80000011604ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001181d7824ULL, 0x000fca00078e021dULL, 0x010000001d237984ULL, 0x000e680000000800ULL,
0x010200001d1c7984ULL, 0x0004e20000000800ULL, 0x000000122300720bULL, 0x002fe20003f1d000ULL,
0x0001ac827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff18297812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fd200078e0012ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05270ULL,
0x000000122300720bULL, 0x000fe20003f34000ULL, 0x0001ac427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000227806ULL, 0x000fc400008e0100ULL, 0x00000023121e7209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x0000991022207816ULL, 0x000fc600000000ffULL,
0x0104001e1d008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000001e12127221ULL, 0x002fe20000010000ULL,
0x000000ff22ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x00000012001d7308ULL, 0x000e640000000800ULL,
0x0000001d0f0f7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x000fe20000011604ULL, 0x0001ab927f007947ULL, 0x000fea000b800000ULL,
0x00001f121d127589ULL, 0x0002a400000e0000ULL, 0x000000120d0d7220ULL, 0x084fe20000410000ULL,
0x000000120e0e7220ULL, 0x080fe20000410000ULL, 0x0000001209097220ULL, 0x080fe20000410000ULL,
0x000000120a0a7220ULL, 0x080fe20000410000ULL, 0x0000001205057220ULL, 0x080fe20000410000ULL,
0x0000001206067220ULL, 0x080fe20000410000ULL, 0x0000001249497220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124d4d7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x0000001251517220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001255557220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001259597220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804127811ULL, 0x000fe200078ff0ffULL, 0x0001aa927f007947ULL, 0x000fea000b800000ULL,
0x00001f121d127589ULL, 0x00046400000e0000ULL, 0x000000120b0b7220ULL, 0x082fe20000410000ULL,
0x000000120c0c7220ULL, 0x080fe20000410000ULL, 0x0000001207077220ULL, 0x080fe20000410000ULL,
0x0000001208087220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x0000001248487220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x000000124c4c7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x0000001250507220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x0000001254547220ULL, 0x080fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x0000001258587220ULL, 0x080fe20000410000ULL, 0x000000125b5b7220ULL, 0x080fe20000410000ULL,
0x000000125c5c7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fda0007806022ULL, 0x8000001e23230221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x0000002300190308ULL, 0x000e640000000800ULL, 0x000000191c1c0220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000f1c0f7221ULL, 0x008fe20000010000ULL,
0x000000ffff127224ULL, 0x000fc400078e001eULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000782c0ffULL, 0x0000014000017945ULL, 0x000fd80003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fe400000000ffULL,
0x00000002ff1c7819ULL, 0x000fe40000011604ULL, 0x000054101a1d7816ULL, 0x004fe2000000001aULL,
0x0001a8c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1c1d1b7589ULL, 0x0002a400000e0000ULL,
0x000000081c1a7810ULL, 0x000fe20007ffe0ffULL, 0x0001a8f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a1d1a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x00003a8000207802ULL, 0x000fc40000000f00ULL, 0x0001b75000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x004fe200078e001dULL, 0x00003ad000207802ULL, 0x000fc40000000f00ULL,
0x0001b70000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000008041d7812ULL, 0x04efe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1c7819ULL, 0x100fe20000011604ULL, 0x0000000208047891ULL, 0x000fe2000f8e103fULL,
0x000000071d6c7812ULL, 0x000fe200078ef804ULL, 0x0000118000017945ULL, 0x000fe20003800000ULL,
0x0000000704717812ULL, 0x000fe200078ec0ffULL, 0x00000004036b7824ULL, 0x100fe200078e021cULL,
0x000000106c2d7812ULL, 0x040fe200078efcffULL, 0x000000106c1e7824ULL, 0x000fe200078e00ffULL,
0x000000041c6d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000016c1d7824ULL, 0x000fe200078e026bULL,
0x000000042d697c10ULL, 0x000fe2000fffe01cULL, 0x000000016b6a7824ULL, 0x000fe200078e022dULL,
0x0000000871717812ULL, 0x000fe200078ef804ULL, 0x000000102d257824ULL, 0x040fe200078e00ffULL,
0xfffffff01e1d7812ULL, 0x000fe200078ee21dULL, 0x000000102d2e7824ULL, 0x000fe200078e00ffULL,
0x000000135e00720cULL, 0x000fe20003fc3070ULL, 0x000000011c6e7824ULL, 0x000fe200078e0271ULL,
0x0000c0001d1d7811ULL, 0x000fe200078e20ffULL, 0x0000000871637824ULL, 0x000fe200078e00ffULL,
0xfffffff0256a7812ULL, 0x000fc400078ee26aULL, 0xfffffff02e697812ULL, 0x000fe200078ee269ULL,
0x000000001d20783bULL, 0x000e620000004200ULL, 0x0000c0006a1e7811ULL, 0x000fe400078e20ffULL,
0x0000c00069617811ULL, 0x000fe400078e20ffULL, 0xfffffff863637812ULL, 0x000fe200078ee26eULL,
0x000000001e24783bULL, 0x000fe20000004200ULL, 0x000000026e647810ULL, 0x000fe40007ffe0ffULL,
0x0000a00063447811ULL, 0x000fe200078e20ffULL, 0x000000006134783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc80003f03070ULL, 0x000000004444783bULL, 0x000ea20000000200ULL,
0x00000018ff2b7819ULL, 0x002fe20000011420ULL, 0x0000010020297824ULL, 0x040fe200078e00ffULL,
0x0000888020287816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe20000011421ULL, 0x00000100212c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011429ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000888021297816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x00000020007c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff317819ULL, 0x000fe20000011423ULL, 0x0000001b44449232ULL, 0x084fe20000000000ULL,
0x00008880232e7816ULL, 0x000fe200000000ffULL, 0x0000001b46469232ULL, 0x000fe20000000000ULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0000001a45459232ULL, 0x080fe20000000000ULL,
0x00008880222d7816ULL, 0x040fe200000000ffULL, 0x0000002c00427306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011424ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888024867816ULL, 0x000fe200000000ffULL,
0x0000001a47479232ULL, 0x000fe20000000000ULL, 0x00000018ff827819ULL, 0x000fc40000011425ULL,
0x0000002100437306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x004fe20000011420ULL,
0x000000016c207824ULL, 0x040fe200078e026dULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000888025887816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe20000011426ULL,
0x0000002200337306ULL, 0x000fe20000200c00ULL, 0x000000106c217824ULL, 0x002fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc40000011427ULL, 0x00008880267f7816ULL, 0x000fe400000000ffULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000010023217824ULL, 0x040fe200078e00ffULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000c00020627811ULL, 0x000fe200078e20ffULL, 0x0000010024207824ULL, 0x040fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x000000006238783bULL, 0x000e620000004200ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x00000021002f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00008880277e7816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe40000011434ULL, 0x0000888034767816ULL, 0x000fe200000000ffULL,
0x0000002000877306ULL, 0x0007e20000200c00ULL, 0x0000010025217824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011435ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000888035747816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x0000002300327306ULL, 0x0005e20000200c00ULL, 0x0000010026207824ULL, 0x048fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888036657816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100897306ULL, 0x0007e20000200c00ULL, 0x0000000871237824ULL, 0x004fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff707819ULL, 0x000fe40000011436ULL,
0xfffffff823647812ULL, 0x000fe400078ee264ULL, 0x0000002000807306ULL, 0x0005e20000200c00ULL,
0x0000010027217824ULL, 0x048fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011437ULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000010034207824ULL, 0x044fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x002fe40000011438ULL, 0x00000018ff797819ULL, 0x000fe40000011420ULL,
0x0000a00064207811ULL, 0x000fe200078e20ffULL, 0x0000002100817306ULL, 0x0003e20000200c00ULL,
0x0000888038417816ULL, 0x000fc400000000ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff3d7819ULL, 0x000fe40000011439ULL, 0x00000018ff7a7819ULL, 0x000fe2000001143aULL,
0x0000002900297306ULL, 0x000ea20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x00000018ff787819ULL, 0x000fcc000001143bULL, 0x0000002400847306ULL, 0x0007f00000200c00ULL,
0x0000002500857306ULL, 0x0005e20000200c00ULL, 0x0000010035247824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000026007d7306ULL, 0x000fe20000200c00ULL, 0x0000541029257816ULL, 0x004fe20000000042ULL,
0x0001000038297824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000888039427816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002400777306ULL, 0x0005f00000200c00ULL, 0x00000027007b7306ULL, 0x0007e20000200c00ULL,
0x0000541028247816ULL, 0x004fe2000000003fULL, 0x0000010038287824ULL, 0x000fe200078e00ffULL,
0x0000001b20209232ULL, 0x002fc40000000000ULL, 0x0000001b22229232ULL, 0x000fe40000000000ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x000000244424723cULL, 0x008f6200000018ffULL, 0x0000001a21219232ULL, 0x080fe40000000000ULL,
0x0000001a23239232ULL, 0x000fc80000000000ULL, 0x0000008800887306ULL, 0x000ff00000200c00ULL,
0x0000002a002a7306ULL, 0x000ff00000200c00ULL, 0x0000002d002d7306ULL, 0x000ff00000200c00ULL,
0x0000002c002c7306ULL, 0x000eb00000200c00ULL, 0x0000002800387306ULL, 0x0003f00000200c00ULL,
0x00000029003f7306ULL, 0x0007e20000200c00ULL, 0x0000541086287816ULL, 0x002fc40000000087ULL,
0x000054102d2c7816ULL, 0x004fca000000002cULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x0000541088297816ULL, 0x008fce0000000089ULL, 0x000000282024723cULL, 0x020be20000001824ULL,
0x0000003400757306ULL, 0x0005ec0000200c00ULL, 0x000054107c287816ULL, 0x020fe4000000002bULL,
0x0000541043297816ULL, 0x000fe2000000002aULL, 0x0000010039347824ULL, 0x004fe200078e00ffULL,
0x0000003000307306ULL, 0x000ea20000200c00ULL, 0x000054102e2d7816ULL, 0x002fc4000000002fULL,
0x000088803a437816ULL, 0x000fe400000000ffULL, 0x000000284428723cULL, 0x040f6200000018ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003100317306ULL, 0x000e6a0000200c00ULL,
0x0000002c442c723cULL, 0x000f6600000018ffULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x0000541032317816ULL, 0x002fce0000000031ULL, 0x0000003500737306ULL, 0x0003e20000200c00ULL,
0x000000304430723cULL, 0x000f6e00000018ffULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x0001000039357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400397306ULL, 0x0003f00000200c00ULL, 0x0000007e007e7306ULL, 0x000f220000200c00ULL,
0x000001003a347824ULL, 0x002fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000035007c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x0000003400867306ULL, 0x0003e20000200c00ULL,
0x0000541085357816ULL, 0x004fe40000000082ULL, 0x000088803b827816ULL, 0x000fca00000000ffULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x0000541084347816ULL, 0x002fce0000000083ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000342028723cULL, 0x020bee0000001828ULL,
0x000054107f347816ULL, 0x028fe20000000080ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000054107e357816ULL, 0x010fe20000000081ULL, 0x000001003b7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x00000034202c723cULL, 0x000be2000000182cULL,
0x0000004200427306ULL, 0x000eec0000200c00ULL, 0x000000ffff357224ULL, 0x020fe200078e0082ULL,
0x000054107d347816ULL, 0x004fe20000000040ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000541041387816ULL, 0x002fe20000000038ULL, 0x0000010036407824ULL, 0x040fe200078e00ffULL,
0x00008880377d7816ULL, 0x000fe200000000ffULL, 0x0001000036367824ULL, 0x000fc800078e00ffULL,
0x00000035007f7306ULL, 0x0003e20000200c00ULL, 0x0000541042397816ULL, 0x008fe40000000039ULL,
0x00000018ff367819ULL, 0x000fca0000011436ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x000054107b357816ULL, 0x002fe4000000003eULL, 0x000054103f3c7816ULL, 0x004fe4000000003cULL,
0x00000018ff7b7819ULL, 0x000fc60000011440ULL, 0x000000342030723cULL, 0x000be20000001830ULL,
0x0000004300437306ULL, 0x000e6c0000200c00ULL, 0x000100003b347824ULL, 0x020fe200078e00ffULL,
0x000054107c3d7816ULL, 0x008fe2000000003dULL, 0x0000007e007e7306ULL, 0x000ea60000200c00ULL,
0x00000018ff347819ULL, 0x000fc60000011434ULL, 0x0000003c443c723cULL, 0x000fe400000018ffULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541043407816ULL, 0x002fce0000000086ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x000054107f417816ULL, 0x004fe2000000007eULL,
0x00000100377e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000003a00837306ULL, 0x0002a20000200c00ULL, 0x000000404440723cULL, 0x040fee00000018ffULL,
0x0000003400357306ULL, 0x0004e20000200c00ULL, 0x000000384438723cULL, 0x002f6e00000018ffULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541083347816ULL, 0x004fce000000007aULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541035357816ULL, 0x008fce0000000078ULL,
0x0000007900797306ULL, 0x000ea20000200c00ULL, 0x000000344444723cULL, 0x000b6e00000018ffULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000541074357816ULL, 0x022fe20000000077ULL,
0x0001000037747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000541076347816ULL, 0x004fce0000000079ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000342038723cULL, 0x000b6e0000001838ULL,
0x0000007b007c7306ULL, 0x000ea20000200c00ULL, 0x0000541075347816ULL, 0x028fe40000000072ULL,
0x0000541073357816ULL, 0x002fc40000000068ULL, 0x00000002ff687819ULL, 0x000fc60000011604ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000000666800720cULL, 0x040fe20003f46070ULL,
0x00000034203c723cULL, 0x000b6c000000183cULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x0000541065347816ULL, 0x024fe4000000007cULL, 0x0000000868657810ULL, 0x000fc80007ffe0ffULL,
0x000000666500720cULL, 0x000fe20003f66070ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000054107d357816ULL, 0x002fce000000007eULL,
0x0000003600377306ULL, 0x0002a20000200c00ULL, 0x000000342040723cULL, 0x000b6e0000001840ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000000166367810ULL, 0x002fc80007ffe0ffULL,
0x000000366800720cULL, 0x080fe40005746470ULL, 0x000000366500720cULL, 0x000fe40005f66470ULL,
0x0000541037347816ULL, 0x024fe40000000070ULL, 0x0000541074357816ULL, 0x008fce000000006fULL,
0x000000342044723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240d0d7221ULL, 0x000fe20000010000ULL,
0x000000250e0e7221ULL, 0x000fe20000010000ULL, 0x0000002809097221ULL, 0x000fe20000010000ULL,
0x000000290a0a7221ULL, 0x000fe20000010000ULL, 0x0000002c05057221ULL, 0x000fe20000010000ULL,
0x0000002d06067221ULL, 0x000fe20000010000ULL, 0x0000003049497221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000384d4d7221ULL, 0x000fe20000010000ULL,
0x000000394e4e7221ULL, 0x000fe20000010000ULL, 0x0000003c51517221ULL, 0x000fe20000010000ULL,
0x0000003d52527221ULL, 0x000fe20000010000ULL, 0x0000004055557221ULL, 0x000fe20000010000ULL,
0x0000004156567221ULL, 0x000fe20000010000ULL, 0x0000004459597221ULL, 0x020fe20000010000ULL,
0x000000455a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x000000260b0b7221ULL, 0x000fe20000010000ULL, 0x000000270c0c7221ULL, 0x000fe20000010000ULL,
0x0000002a07077221ULL, 0x000fe20000010000ULL, 0x0000002b08087221ULL, 0x000fe20000010000ULL,
0x0000002e1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x000000324b4b7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x0000003a4f4f7221ULL, 0x000fe20000010000ULL, 0x0000003b50507221ULL, 0x000fe20000010000ULL,
0x0000003e53537221ULL, 0x000fe20000010000ULL, 0x0000003f54547221ULL, 0x000fe20000010000ULL,
0x0000004257577221ULL, 0x000fe20000010000ULL, 0x0000004358587221ULL, 0x000fe20000010000ULL,
0x000000465b5b7221ULL, 0x020fe20000010000ULL, 0x000000475c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011636ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000000135e00720cULL, 0x000fc40003f03070ULL,
0x000000135e00720cULL, 0x000fe40003fc3070ULL, 0x00000001ff2b7803ULL, 0x000fe40000000000ULL,
0x0000000336207812ULL, 0x042fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0021ULL,
0x0000002336367207ULL, 0x000fe40002800000ULL, 0x000000ff20207207ULL, 0x000fe40006800000ULL,
0x0000000336227812ULL, 0x000fc400078ec0ffULL, 0x0000001336217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe20007804867ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe20007804828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121237810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000602300720cULL, 0x000fda0003f06070ULL,
0x0000051000008947ULL, 0x000fea0003800000ULL, 0x000000051c297c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x010a000029237984ULL, 0x000e620000004800ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000421267824ULL, 0x000fe200078e0222ULL,
0x000000052c337c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002a7824ULL, 0x000fe400078e0229ULL,
0x0000004026267824ULL, 0x000fc400078e00ffULL, 0x0000001029277824ULL, 0x000fe400078e00ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332e7812ULL, 0x000fe200078ee22eULL, 0x010ac00023247984ULL, 0x0022a40000004800ULL,
0x000000265f237217ULL, 0x002fca0007800000ULL, 0x0000000123237824ULL, 0x000fe400078e0a26ULL,
0x0000000129267824ULL, 0x000fc600078e0204ULL, 0x0000000523237c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000523237c10ULL, 0x000fe4000fffe0ffULL,
0x0000c00026317811ULL, 0x000fe400078e20ffULL, 0x000000022a267810ULL, 0x000fe20007ffe0ffULL,
0x0000002415247224ULL, 0x004fc800078e022aULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000231c00720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e8000c101c4cULL, 0x010a080029287984ULL, 0x000ea20000004800ULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000042a247810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000232c00720cULL, 0x000fe40003f06070ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c337c10ULL, 0x000fca000fffe0ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e2000c101c4cULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a100029287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000062a267810ULL, 0x000fe40007ffe0ffULL,
0x000000061c2a7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000232c00720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e8000c101c4cULL, 0x010a180029287984ULL, 0x000ea80000004800ULL,
0x010ac00028287984ULL, 0x004ea40000004800ULL, 0x0000002815267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fe200078e002dULL, 0x000000052a2d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007f1e0ffULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000232a00720cULL, 0x000fe40003f06070ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c257811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000c101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051c2d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe400078e00ffULL, 0x010a00002d237984ULL, 0x000e620000004800ULL,
0x00000040002c7824ULL, 0x000fe400078e022dULL, 0x000000f026317812ULL, 0x000fe200078ec0ffULL,
0x010ac00023247984ULL, 0x0022a40000004800ULL, 0x000000022d237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123297824ULL, 0x040fe400078e0204ULL, 0x00000010232a7824ULL, 0x000fe200078e00ffULL,
0x000000042d237810ULL, 0x000fc80007ffe0ffULL, 0xfffffff02a297812ULL, 0x000fe200078ee229ULL,
0x00000001232a7824ULL, 0x040fe400078e0204ULL, 0x0000001023237824ULL, 0x000fe200078e00ffULL,
0x0000c00029297811ULL, 0x000fc800078e20ffULL, 0xfffffff0232a7812ULL, 0x000fc800078ee22aULL,
0x0000c0002a237811ULL, 0x000fe200078e20ffULL, 0x0000002415247224ULL, 0x004fc800078e022cULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124267210ULL, 0x000fe20007f1e0ffULL,
0x000000012d247824ULL, 0x000fc800078e0204ULL, 0x000000ffff277224ULL, 0x000fe400000e0625ULL,
0x000000102d257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0000c00024337811ULL, 0x000fe400078e20ffULL, 0x000000022c247810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026337faeULL, 0x0003e8000b901c4cULL,
0x010a08002d287984ULL, 0x000ea20000004800ULL, 0x000000042c267810ULL, 0x002fc60007ffe0ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000b901c4cULL, 0x010a10002d287984ULL, 0x000ea20000004800ULL,
0x000000062c247810ULL, 0x002fe40007ffe0ffULL, 0x000000062d297810ULL, 0x000fca0007ffe0ffULL,
0x00000001292a7824ULL, 0x040fe400078e0204ULL, 0x0000001029297824ULL, 0x000fca00078e00ffULL,
0xfffffff0292a7812ULL, 0x000fe200078ee22aULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002fULL,
0x0000003126267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e8000b901c4cULL,
0x010a18002d287984ULL, 0x000ea20000004800ULL, 0x0000c0002a237811ULL, 0x002fc600078e20ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000023ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fc80003f04070ULL, 0x000000ff20237207ULL, 0x040fe40000000000ULL,
0x000000ff20247207ULL, 0x000fc60004000000ULL, 0x0000000122227824ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fc600078e10ffULL, 0x0000004022207824ULL, 0x040fe200078e00ffULL,
0x0000002122217211ULL, 0x000fc800078ff0ffULL, 0x000000c020207812ULL, 0x000fca00078ec0ffULL,
0x0000010021207824ULL, 0x000fe200078e0220ULL, 0x0000000a24217c10ULL, 0x000fe2000fffe0ffULL,
0x00000004ff247424ULL, 0x000fc600078e00ffULL, 0x0000002020207810ULL, 0x000fca0007ffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0220ULL, 0x0000680021217a24ULL, 0x000fc600078e0220ULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x002fe200078e0021ULL, 0x0000010000001947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000181827f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002a400000e0000ULL,
0x000181c27f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000627000207802ULL, 0x000fc40000000f00ULL,
0x00018f6000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x000062c000207802ULL, 0x000fc40000000f00ULL, 0x00018f1000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000e0006a6a7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff2b00720cULL, 0x000fe20003f05270ULL,
0x000000016c6b7824ULL, 0x040fe200078e026bULL, 0x0000e00069697811ULL, 0x000fe200078e20ffULL,
0x000000006a28783bULL, 0x000f220000004200ULL, 0x000000106c267824ULL, 0x044fe200078e00ffULL,
0x00000ff000017945ULL, 0x000fe20003800000ULL, 0x000000016c6d7824ULL, 0x040fe200078e026dULL,
0x000000006920783bULL, 0x00afe20000004200ULL, 0x000000106c6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff0266b7812ULL, 0x000fe200078ee26bULL, 0x0000000871327824ULL, 0x000fc400078e00ffULL,
0x0000000871717824ULL, 0x000fe200078e00ffULL, 0x0000e0006b6b7811ULL, 0x000fe400078e20ffULL,
0xfffffff06c6c7812ULL, 0x000fe400078ee26dULL, 0x000000046e6d7810ULL, 0x000fe40007ffe0ffULL,
0x0000e0006c6c7811ULL, 0x000fe400078e20ffULL, 0xfffffff8326d7812ULL, 0x000fe400078ee26dULL,
0x000000066e6e7810ULL, 0x000fe20007ffe0ffULL, 0x000000006c34783bULL, 0x000e620000004200ULL,
0x0000a0006d407811ULL, 0x000fc400078e20ffULL, 0xfffffff8716e7812ULL, 0x000fc800078ee26eULL,
0x000000004040783bULL, 0x000ea20000000200ULL, 0x0000010028247824ULL, 0x050fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011428ULL, 0x0000010029257824ULL, 0x000fe200078e00ffULL,
0x0000888028877816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00000018ff767819ULL, 0x000fc4000001142aULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x000088802a7e7816ULL, 0x040fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe2000001142bULL, 0x0000002400867306ULL, 0x0007e20000200c00ULL,
0x000088802b7c7816ULL, 0x000fe400000000ffULL, 0x00000018ff807819ULL, 0x000fe40000011429ULL,
0x0000888029847816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x002fe20000011434ULL, 0x0000002500857306ULL, 0x0003e20000200c00ULL,
0x000001002a247824ULL, 0x008fe200078e00ffULL, 0x00008880343e7816ULL, 0x000fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x00000100343a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x000001002b247824ULL, 0x040fe200078e00ffULL, 0x0000002800827306ULL, 0x0007e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011424ULL, 0x0000001b40409232ULL, 0x084fe20000000000ULL,
0x000000006b24783bULL, 0x002e620000004200ULL, 0x0000002a007b7306ULL, 0x0005e20000200c00ULL,
0x0000010020287824ULL, 0x048fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000001b42429232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011420ULL,
0x0000001a41419232ULL, 0x080fe20000000000ULL, 0x00000018ff797819ULL, 0x000fe20000011428ULL,
0x0000001a43439232ULL, 0x000fe20000000000ULL, 0x0000002b007a7306ULL, 0x000fe20000200c00ULL,
0x0000888020787816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc40000011435ULL, 0x00008880358a7816ULL, 0x000fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000002900837306ULL, 0x0007e20000200c00ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff887819ULL, 0x000fe40000011437ULL,
0x0000888037717816ULL, 0x000fe400000000ffULL, 0x00008880363c7816ULL, 0x000fe200000000ffULL,
0x0000003a003f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fc40000011421ULL,
0x0000888021777816ULL, 0x000fe400000000ffULL, 0x00000018ff707819ULL, 0x000fe40000011422ULL,
0x00000018ff6f7819ULL, 0x000fe20000011423ULL, 0x00000034003b7306ULL, 0x0009e20000200c00ULL,
0x00000018ff287819ULL, 0x002fe20000011424ULL, 0x00000100242a7824ULL, 0x044fe200078e00ffULL,
0x0000888024447816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x008fe20000011425ULL, 0x00000100262d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142aULL, 0x00000100252a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x040fe200078e00ffULL,
0x0000888025457816ULL, 0x000fe200000000ffULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x00000100272f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000010037347824ULL, 0x050fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00008880262c7816ULL, 0x040fe200000000ffULL, 0x0000002e00257306ULL, 0x0002a20000200c00ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x00008880272e7816ULL, 0x042fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff8b7819ULL, 0x000fe40000011434ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400247306ULL, 0x000e620000200c00ULL, 0x0000541025287816ULL, 0x004fc40000000028ULL,
0x0000a0006e257811ULL, 0x000fe400078e20ffULL, 0x00000018ff8d7819ULL, 0x000fc60000011437ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000002b002b7306ULL, 0x000ea20000200c00ULL,
0x0000541024297816ULL, 0x002fce0000000029ULL, 0x0000002600337306ULL, 0x0003f00000200c00ULL,
0x0000002700327306ULL, 0x0007e20000200c00ULL, 0x0000010035267824ULL, 0x002fe200078e00ffULL,
0x0000541044447816ULL, 0x004fe2000000002bULL, 0x00000100362b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0001000035277824ULL, 0x008fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc8000001142bULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002600357306ULL, 0x000ff00000200c00ULL,
0x00000027003a7306ULL, 0x0003f00000200c00ULL, 0x0000002a002a7306ULL, 0x000ea20000200c00ULL,
0x000000002524783bULL, 0x002e6e0000000200ULL, 0x0000003e003e7306ULL, 0x000ef00000200c00ULL,
0x0000002000747306ULL, 0x0009e20000200c00ULL, 0x0000541045457816ULL, 0x004fc4000000002aULL,
0x000000284028723cULL, 0x040fea00000018ffULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x010fe20000011436ULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x008fe2000000003fULL, 0x00000100213e7824ULL, 0x040fe200078e00ffULL,
0x000000444044723cULL, 0x000f6200000018ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003d003d7306ULL, 0x000ea60000200c00ULL,
0x00000018ff217819ULL, 0x000fca0000011421ULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x0000001b24249232ULL, 0x082fe40000000000ULL, 0x0000001b26269232ULL, 0x000fe40000000000ULL,
0x0000001a25259232ULL, 0x080fe40000000000ULL, 0x0000001a27279232ULL, 0x000fe20000000000ULL,
0x0000002d002d7306ULL, 0x000e620000200c00ULL, 0x000054103c3c7816ULL, 0x004fce000000003dULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000008b008c7306ULL, 0x0004e20000200c00ULL,
0x000054102c2c7816ULL, 0x002fce000000002dULL, 0x0000003000307306ULL, 0x000e620000200c00ULL,
0x00008880228b7816ULL, 0x004fce00000000ffULL, 0x0000003100317306ULL, 0x000ea20000200c00ULL,
0x00005410713d7816ULL, 0x008fce000000008cULL, 0x0000003800387306ULL, 0x000ee20000200c00ULL,
0x0000541033307816ULL, 0x002fce0000000030ULL, 0x0000003900397306ULL, 0x000e620000200c00ULL,
0x0000541032317816ULL, 0x004fce0000000031ULL, 0x0000002e002e7306ULL, 0x000fe20000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x000000304030723cULL, 0x000fec00000018ffULL,
0x0000002f002f7306ULL, 0x000ea20000200c00ULL, 0x000054103a397816ULL, 0x002fce0000000039ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000054102e2d7816ULL, 0x004fce000000002fULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000054108a357816ULL, 0x002fe20000000035ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff8a7819ULL, 0x000fca000001143eULL,
0x0000003600897306ULL, 0x0002a40000200c00ULL, 0x0000003c403c723cULL, 0x040fec00000018ffULL,
0x0000008d008d7306ULL, 0x000ee40000200c00ULL, 0x000000344034723cULL, 0x002f6c00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x0000541089207816ULL, 0x004fe20000000020ULL,
0x0000010022897824ULL, 0x000fc400078e00ffULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011489ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x00000018ff227819ULL, 0x000fce0000011422ULL, 0x0000002100717306ULL, 0x0007f00000200c00ULL,
0x0000008000807306ULL, 0x000f220000200c00ULL, 0x000054108d217816ULL, 0x008fce0000000088ULL,
0x000000204040723cULL, 0x000b6200000018ffULL, 0x0000007e007e7306ULL, 0x000fec0000200c00ULL,
0x0000541087207816ULL, 0x022fe40000000086ULL, 0x0000541084217816ULL, 0x004fe20000000085ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000888023847816ULL, 0x000fca00000000ffULL,
0x000000202444723cULL, 0x000b640000001844ULL, 0x0000007c007c7306ULL, 0x000fea0000200c00ULL,
0x0000541082207816ULL, 0x020fe40000000081ULL, 0x0000541083217816ULL, 0x010fe20000000080ULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x0000010023807824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x00000018ff237819ULL, 0x000fc80000011423ULL, 0x000000ffff207224ULL, 0x020fc600078e0084ULL,
0x0000007500757306ULL, 0x000ee20000200c00ULL, 0x000054107c217816ULL, 0x002fce000000007fULL,
0x0000002000817306ULL, 0x0003f00000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000054107e207816ULL, 0x002fce000000007dULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000054107b207816ULL, 0x024fe40000000076ULL, 0x000054107a217816ULL, 0x008fca0000000075ULL,
0x0000008a008a7306ULL, 0x000ea40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x0000541078207816ULL, 0x022fce0000000079ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541077217816ULL, 0x004fce000000008aULL,
0x0000008b00887306ULL, 0x000fe20000200c00ULL, 0x000000202434723cULL, 0x000b6e0000001834ULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x0000541074207816ULL, 0x028fe40000000073ULL,
0x0000541071217816ULL, 0x002fca0000000072ULL, 0x0000008000807306ULL, 0x000e640000200c00ULL,
0x000000202438723cULL, 0x000b6c0000001838ULL, 0x0000002200857306ULL, 0x000fe20000200c00ULL,
0x0000541088207816ULL, 0x024fce0000000089ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000541081217816ULL, 0x002fce0000000080ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000020243c723cULL, 0x000b6e000000183cULL, 0x0000002300227306ULL, 0x000e620000200c00ULL,
0x0000541085207816ULL, 0x024fe40000000070ULL, 0x0000541022217816ULL, 0x002fce000000006fULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0000000000ULL, 0x000000440d0d7221ULL, 0x000fe20000010000ULL,
0x000000450e0e7221ULL, 0x000fe20000010000ULL, 0x0000002809097221ULL, 0x000fe20000010000ULL,
0x000000290a0a7221ULL, 0x000fe20000010000ULL, 0x0000002c05057221ULL, 0x000fe20000010000ULL,
0x0000002d06067221ULL, 0x000fe20000010000ULL, 0x0000003049497221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000344d4d7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003851517221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c55557221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x0000004059597221ULL, 0x020fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003000000ULL,
0x000000460b0b7221ULL, 0x000fe20000010000ULL, 0x000000470c0c7221ULL, 0x000fe20000010000ULL,
0x0000002a07077221ULL, 0x000fe20000010000ULL, 0x0000002b08087221ULL, 0x000fe20000010000ULL,
0x0000002e1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x000000324b4b7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x000000364f4f7221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a53537221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e57577221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425b5b7221ULL, 0x020fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000166667810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000004ff6f7424ULL, 0x000fe200078e00ffULL,
0x010b8800ff227f8cULL, 0x000e68000c80043fULL, 0x000000016f6f7807ULL, 0x000fc80006800000ULL,
0x0000006f6600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffa74000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004013207811ULL, 0x020fe200078e40ffULL, 0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0001011000000947ULL, 0x000fea0003800000ULL,
0x000000ffff707224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x020fe20000011670ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000370227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002170217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000121247810ULL, 0x000fc80007ffe0ffULL,
0x0000000324207812ULL, 0x040fe400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121237810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000602300720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000051c297c10ULL, 0x000fe2000fffe0ffULL,
0x0000000421247824ULL, 0x000fe200078e0220ULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x0000001004277824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x0000002024247811ULL, 0x000fe200078e30ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000f0272d7812ULL, 0x000fe200078ec0ffULL,
0x0000000129277824ULL, 0x000fe200078e0204ULL, 0x000000245f237217ULL, 0x000fe20007800000ULL,
0x0000001029287824ULL, 0x000fe200078e00ffULL, 0x000000052c317c10ULL, 0x000fc6000fffe0ffULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fe400078e022aULL,
0x00000001312e7824ULL, 0x000fe200078e0204ULL, 0x0000000523237c17ULL, 0x000fc8000f800000ULL,
0x8000000523237c10ULL, 0x000fc8000fffe0ffULL, 0x000000231c00720cULL, 0x000fe20003f06070ULL,
0x010ac00025267984ULL, 0x002e640000004800ULL, 0x0000002615247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe40007f3e0ffULL,
0xfffffff028247812ULL, 0x000fc600078ee227ULL, 0x000000ffff277224ULL, 0x000fe200008e0625ULL,
0x0000e000242f7811ULL, 0x000fe200078e20ffULL, 0x0000000131247824ULL, 0x040fe400078e022aULL,
0x0000001031317824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000232c00720cULL, 0x000fe40003f06070ULL,
0xfffffff0312e7812ULL, 0x000fe200078ee22eULL, 0x010a080029287984ULL, 0x000ea20000004800ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x00000001312e7824ULL, 0x000fe200078e0204ULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x0000000131247824ULL, 0x040fe400078e022aULL, 0x0000001031317824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600008e0625ULL, 0xfffffff0312e7812ULL, 0x000fe400078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x000000061c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a100029287984ULL, 0x000ea60000004800ULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x0000000131267824ULL, 0x040fe400078e022aULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe200078ee22aULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x0000e0002a237811ULL, 0x000fe200078e20ffULL,
0x010a180029287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000051c2d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000022d297810ULL, 0x040fe20007ffe0ffULL,
0x010a00002d237984ULL, 0x000e620000004800ULL, 0x000000f026317812ULL, 0x000fe200078ec0ffULL,
0x000000012d257824ULL, 0x040fe400078e022aULL, 0x000000012d277824ULL, 0x000fc400078e0204ULL,
0x000000102d287824ULL, 0x000fe400078e00ffULL, 0x00000001292c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x0022a40000004800ULL, 0xfffffff028237812ULL, 0x002fc800078ee227ULL,
0x0000e000232b7811ULL, 0x000fe200078e20ffULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0229ULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c4cULL, 0x010a08002d237984ULL, 0x000ea20000004800ULL,
0xfffffff0292c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c2b7811ULL, 0x002fe400078e20ffULL,
0x000000042d277810ULL, 0x000fca0007ffe0ffULL, 0x00000001272c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124287210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e8000b901c4cULL, 0x010a10002d237984ULL, 0x000ea20000004800ULL,
0xfffffff0272c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c297811ULL, 0x002fe400078e20ffULL,
0x000000062d2b7810ULL, 0x000fca0007ffe0ffULL, 0x000000012b287824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e022bULL,
0x000000102b2b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c4cULL, 0x010a18002d237984ULL, 0x000ea20000004800ULL,
0xfffffff02b287812ULL, 0x000fc800078ee228ULL, 0x0000e00028277811ULL, 0x002fe200078e20ffULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010af800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010afc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010afc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011604ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0100800027237984ULL, 0x000e680000000800ULL, 0x0102800027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x000156527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000010300780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x000156127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0104802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x00000012002a7308ULL, 0x000e640000000800ULL, 0x0000002a0f0f7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000155627f007947ULL, 0x000fea000b800000ULL,
0x00001f682a127589ULL, 0x0002a400000e0000ULL, 0x000000120d0d7220ULL, 0x084fe20000410000ULL,
0x000000120e0e7220ULL, 0x080fe20000410000ULL, 0x0000001209097220ULL, 0x080fe20000410000ULL,
0x000000120a0a7220ULL, 0x080fe20000410000ULL, 0x0000001205057220ULL, 0x080fe20000410000ULL,
0x0000001206067220ULL, 0x080fe20000410000ULL, 0x0000001249497220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124d4d7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x0000001251517220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001255557220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001259597220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000154727f007947ULL, 0x000fea000b800000ULL, 0x00001f652a127589ULL, 0x00046400000e0000ULL,
0x000000120b0b7220ULL, 0x082fe20000410000ULL, 0x000000120c0c7220ULL, 0x080fe20000410000ULL,
0x0000001207077220ULL, 0x080fe20000410000ULL, 0x0000001208087220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x000000124b4b7220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124f4f7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001253537220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001257577220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x000000125b5b7220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000f220f7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000152b27f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x000152f27f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000935000207802ULL, 0x000fc40000000f00ULL,
0x00015e8000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x000093a000207802ULL, 0x000fc40000000f00ULL, 0x00015e3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001d20783bULL, 0x002e620000004200ULL, 0x0000a80063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000a80064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200d0d7221ULL, 0x000fe20000010000ULL, 0x000000210e0e7221ULL, 0x000fe20000010000ULL,
0x0000004409097221ULL, 0x000fe20000010000ULL, 0x000000450a0a7221ULL, 0x000fe20000010000ULL,
0x0000002c05057221ULL, 0x000fe20000010000ULL, 0x0000002d06067221ULL, 0x000fe20000010000ULL,
0x0000003049497221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344d4d7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003851517221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c55557221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004059597221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220b0b7221ULL, 0x000fe20000010000ULL,
0x000000230c0c7221ULL, 0x000fe20000010000ULL, 0x0000004607077221ULL, 0x000fe20000010000ULL,
0x0000004708087221ULL, 0x000fe20000010000ULL, 0x0000002e1f1f7221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x000000324b4b7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364f4f7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a53537221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e57577221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425b5b7221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366247812ULL, 0x020fe400078ec0ffULL, 0x000000135e00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff24247207ULL, 0x000fe40006800000ULL,
0x0000000123207810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fc600078e0021ULL,
0x0000000320227812ULL, 0x040fe400078ec0ffULL, 0x0000001320237211ULL, 0x000fc400078ff0ffULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000123217810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000602100720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000423267824ULL, 0x000fe200078e0222ULL,
0x000000052c337c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002a7824ULL, 0x000fe400078e022bULL,
0x0000004026267824ULL, 0x000fc400078e00ffULL, 0x000000102b277824ULL, 0x000fe400078e00ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332e7812ULL, 0x000fe200078ee22eULL, 0x010ac00025207984ULL, 0x0022a40000004800ULL,
0x000000265f257217ULL, 0x002fca0007800000ULL, 0x0000000125257824ULL, 0x000fe400078e0a26ULL,
0x000000012b267824ULL, 0x000fc600078e0204ULL, 0x0000000525257c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000525257c10ULL, 0x000fe4000fffe0ffULL,
0x0000c00026317811ULL, 0x000fe400078e20ffULL, 0x000000022a267810ULL, 0x000fe20007ffe0ffULL,
0x0000002015207224ULL, 0x004fc800078e022aULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000251c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a08002b287984ULL, 0x000ea20000004800ULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000042a207810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252c00720cULL, 0x000fe40003fc6070ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c337c10ULL, 0x000fca000fffe0ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e2000f101c4cULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002b287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000062a267810ULL, 0x000fe40007ffe0ffULL,
0x000000061c2a7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000252c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a18002b287984ULL, 0x000ea80000004800ULL,
0x010ac00028287984ULL, 0x004ea40000004800ULL, 0x0000002815267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fe200078e002dULL, 0x000000052a2d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007fde0ffULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000252a00720cULL, 0x000fe40003fc6070ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c217811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000022b337810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b257984ULL, 0x000e620000004800ULL, 0x0000004000287824ULL, 0x000fe400078e022bULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x00000001332a7824ULL, 0x000fc400078e0204ULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe400078ee22aULL,
0x000000042b337810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025207984ULL, 0x002e640000004800ULL,
0x0000002015207224ULL, 0x002fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20267210ULL, 0x000fe20007fde0ffULL, 0x000000012b207824ULL, 0x000fc800078e0204ULL,
0x000000ffff277224ULL, 0x000fe400030e0621ULL, 0x000000102b217824ULL, 0x000fca00078e00ffULL,
0xfffffff021207812ULL, 0x000fe400078ee220ULL, 0x0000000228217810ULL, 0x000fe40007ffe0ffULL,
0x0000c00020317811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe200078e20ffULL, 0x00000001332a7824ULL, 0x040fe200078e0204ULL,
0x0000000428277810ULL, 0x040fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e00ffULL,
0x0000000628287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0332a7812ULL, 0x000fe200078ee22aULL,
0x010ac00025207984ULL, 0x004e640000004800ULL, 0x0000002015207224ULL, 0x002fc800078e0221ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fc600078e20ffULL, 0x010ac00025267984ULL, 0x004e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a18002b257984ULL, 0x000ea80000004800ULL, 0x010ac00025207984ULL, 0x004ea40000004800ULL,
0x0000002015207224ULL, 0x004fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fe200078e002dULL,
0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL, 0x0000002f20207210ULL, 0x000fe20007fde0ffULL,
0x000000012d287824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc600030e0621ULL, 0xfffffff02d287812ULL, 0x000fc800078ee228ULL,
0x0000c00028277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000235e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff24217207ULL, 0x040fe40003000000ULL,
0x000000ff24247207ULL, 0x000fc60007000000ULL, 0x0000000122227824ULL, 0x000fc800078e0221ULL,
0x0000004022207824ULL, 0x040fe200078e00ffULL, 0x0000002322227211ULL, 0x000fc800078ff0ffULL,
0x000000c020217812ULL, 0x000fe400078ec0ffULL, 0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL,
0x0000010022217824ULL, 0x000fca00078e0221ULL, 0x0000002021237810ULL, 0x000fca0007ffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003fc6070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x00012d827f007947ULL, 0x000fea000b800000ULL,
0x00001f68221b7589ULL, 0x0004e400000e0000ULL, 0x00012dc27f007947ULL, 0x000fea000b800000ULL,
0x00001f65221a7589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001068277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000b94000207802ULL, 0x000fc40000000f00ULL, 0x0001389000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001868277810ULL, 0x002fe40007ffe0ffULL, 0x0000b99000207802ULL, 0x000fc40000000f00ULL,
0x0001384000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006b24783bULL, 0x006e620000004200ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0000a8006d407811ULL, 0x000fe200078e20ffULL, 0x000000006a28783bULL, 0x000ea80000004200ULL,
0x000000006920783bULL, 0x000fe80000004200ULL, 0x000000006c34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe20000011424ULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000001002a337824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011428ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x00008880288b7816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc40000011429ULL, 0x0000888029867816ULL, 0x040fe400000000ffULL,
0x00000018ff847819ULL, 0x000fe20000011428ULL, 0x0000002e003d7306ULL, 0x0003e20000200c00ULL,
0x0000010026287824ULL, 0x000fe200078e00ffULL, 0x0000888024447816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011433ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011420ULL,
0x00000100292e7824ULL, 0x042fe200078e00ffULL, 0x0000888020787816ULL, 0x000fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011425ULL,
0x0000003200887306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe20000011429ULL,
0x0000010027297824ULL, 0x000fe200078e00ffULL, 0x0000888025457816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002e00897306ULL, 0x0005e20000200c00ULL, 0x0000888027327816ULL, 0x042fe200000000ffULL,
0x0000001a4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x00008880262e7816ULL, 0x044fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00008880343e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff877819ULL, 0x000fe20000011436ULL,
0x0000002600337306ULL, 0x0002a20000200c00ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff827819ULL, 0x000fe40000011437ULL, 0x00008880378d7816ULL, 0x000fc400000000ffULL,
0x00000018ff397819ULL, 0x000fe20000011435ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x042fe200078e00ffULL, 0x00008880358c7816ULL, 0x000fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011421ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff747819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x00000029003f7306ULL, 0x000fe20000200c00ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888021777816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe4000001142aULL,
0x00000018ff757819ULL, 0x000fe4000001142bULL, 0x000088802a7f7816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000088802b7c7816ULL, 0x000fe200000000ffULL,
0x0000002f00467306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff717819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011423ULL, 0x00000028002f7306ULL, 0x0005e20000200c00ULL,
0x0000541044447816ULL, 0x002fce000000003dULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x000001002b287824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x00000018ff2b7819ULL, 0x000fce000001142bULL, 0x0000003100317306ULL, 0x000ff00000200c00ULL,
0x00000027008a7306ULL, 0x0004e20000200c00ULL, 0x0000541025297816ULL, 0x002fce000000002cULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0001000035277824ULL, 0x004fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002000837306ULL, 0x0002a20000200c00ULL,
0x000054108a317816ULL, 0x008fce0000000031ULL, 0x0000002600797306ULL, 0x0007e20000200c00ULL,
0x0000010036207824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011420ULL, 0x00000028007d7306ULL, 0x0003e20000200c00ULL,
0x0000010035267824ULL, 0x008fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc80000011436ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027003a7306ULL, 0x000fe20000200c00ULL,
0x0000541024287816ULL, 0x002fe4000000002dULL, 0x0000a8006e247811ULL, 0x000fe400078e20ffULL,
0x00005410322d7816ULL, 0x000fe2000000003fULL, 0x0000010037327824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000002600357306ULL, 0x0003e40000200c00ULL,
0x00000018ff8a7819ULL, 0x000fc40000011432ULL, 0x000000304030723cULL, 0x000fe800000018ffULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000000200ULL,
0x00000034003b7306ULL, 0x0005f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103e347816ULL, 0x004fe20000000083ULL, 0x00000100213e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011437ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000541045457816ULL, 0x008fc60000000046ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff217819ULL, 0x000fc60000011421ULL, 0x000000444044723cULL, 0x000f6800000018ffULL,
0x0000003800387306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x000054103c3c7816ULL, 0x004fe2000000003dULL, 0x0000001b2424b232ULL, 0x002fc40000000000ULL,
0x0000001b2626b232ULL, 0x000fe40000000000ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x0000001a2727b232ULL, 0x000fcc0000000000ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x000054103a397816ULL, 0x010fce0000000039ULL, 0x0000008d003f7306ULL, 0x000fe20000200c00ULL,
0x000054102e2c7816ULL, 0x002fe2000000002fULL, 0x000000384038723cULL, 0x040fec00000018ffULL,
0x0000008a008e7306ULL, 0x000e620000200c00ULL, 0x000054108c357816ULL, 0x004fe20000000035ULL,
0x0000002c402c723cULL, 0x000fe200000018ffULL, 0x00000018ff8c7819ULL, 0x000fca000001143eULL,
0x0000008700877306ULL, 0x000fe40000200c00ULL, 0x000000344034723cULL, 0x000fec00000018ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000054103f3d7816ULL, 0x002fe4000000008eULL,
0x00008880228e7816ULL, 0x000fca00000000ffULL, 0x0000002000207306ULL, 0x000e620000200c00ULL,
0x0000003c403c723cULL, 0x000fee00000018ffULL, 0x00000083008d7306ULL, 0x000eb00000200c00ULL,
0x0000002100837306ULL, 0x0005e20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000087ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000054108d217816ULL, 0x004fe20000000082ULL,
0x000000ffff827224ULL, 0x000fcc00078e008eULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002a007b7306ULL, 0x000ff00000200c00ULL, 0x0000002b007a7306ULL, 0x0005f00000200c00ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000000284028723cULL, 0x044f6e00000018ffULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000000204040723cULL, 0x000b6e00000018ffULL,
0x0000010022207824ULL, 0x020fe200078e00ffULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x0000541086217816ULL, 0x002fe20000000089ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888023867816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000002000877306ULL, 0x0007f00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108b207816ULL, 0x008fce0000000088ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000007c007c7306ULL, 0x000f220000200c00ULL,
0x0000541084207816ULL, 0x024fe40000000081ULL, 0x0000541085217816ULL, 0x002fe20000000080ULL,
0x0000010023807824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe400078e00ffULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x000000ffff217224ULL, 0x020fe200078e0086ULL,
0x000054107f207816ULL, 0x008fcc000000007eULL, 0x0000002100817306ULL, 0x0009f00000200c00ULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0x000054107c217816ULL, 0x010fce000000007dULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008c008a7306ULL, 0x000f220000200c00ULL, 0x000054107b207816ULL, 0x022fe40000000076ULL,
0x000054107a217816ULL, 0x004fca0000000075ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541078207816ULL, 0x028fe40000000079ULL, 0x0000541077217816ULL, 0x010fca000000008aULL,
0x0000007400747306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x0000541083217816ULL, 0x022fce0000000072ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x0000541074207816ULL, 0x004fce0000000073ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541082207816ULL, 0x028fe40000000087ULL,
0x0000541081217816ULL, 0x002fca0000000080ULL, 0x0000002200227306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541022207816ULL, 0x022fe40000000071ULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000440d0d7221ULL, 0x000fe20000010000ULL,
0x000000450e0e7221ULL, 0x000fe20000010000ULL, 0x0000002809097221ULL, 0x000fe20000010000ULL,
0x000000290a0a7221ULL, 0x000fe20000010000ULL, 0x0000002c05057221ULL, 0x000fe20000010000ULL,
0x0000002d06067221ULL, 0x000fe20000010000ULL, 0x0000003049497221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000344d4d7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003851517221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c55557221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x0000004059597221ULL, 0x020fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460b0b7221ULL, 0x000fe20000010000ULL, 0x000000470c0c7221ULL, 0x000fe20000010000ULL,
0x0000002a07077221ULL, 0x000fe20000010000ULL, 0x0000002b08087221ULL, 0x000fe20000010000ULL,
0x0000002e1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x000000324b4b7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x000000364f4f7221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a53537221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e57577221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425b5b7221ULL, 0x020fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006f7000720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaae000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008013207811ULL, 0x020fe200078e40ffULL, 0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0000ab5000000947ULL, 0x000fea0003800000ULL,
0x000000ffff707224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x020fe20000011670ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000370227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002170217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221247810ULL, 0x000fc80007ffe0ffULL,
0x0000000324207812ULL, 0x040fe400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121237810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000602300720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000051c297c10ULL, 0x000fe2000fffe0ffULL,
0x0000000421247824ULL, 0x000fe200078e0220ULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x0000001004277824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x0000002024247811ULL, 0x000fe200078e30ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000f0272d7812ULL, 0x000fe200078ec0ffULL,
0x0000000129277824ULL, 0x000fe200078e0204ULL, 0x000000245f237217ULL, 0x000fe20007800000ULL,
0x0000001029287824ULL, 0x000fe200078e00ffULL, 0x000000052c317c10ULL, 0x000fc6000fffe0ffULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fe400078e022aULL,
0x00000001312e7824ULL, 0x000fe200078e0204ULL, 0x0000000523237c17ULL, 0x000fc8000f800000ULL,
0x8000000523237c10ULL, 0x000fc8000fffe0ffULL, 0x000000231c00720cULL, 0x000fe20003f06070ULL,
0x010ac00025267984ULL, 0x002e640000004800ULL, 0x0000002615247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe40007f3e0ffULL,
0xfffffff028247812ULL, 0x000fc600078ee227ULL, 0x000000ffff277224ULL, 0x000fe200008e0625ULL,
0x0000e000242f7811ULL, 0x000fe200078e20ffULL, 0x0000000131247824ULL, 0x040fe400078e022aULL,
0x0000001031317824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000232c00720cULL, 0x000fe40003f06070ULL,
0xfffffff0312e7812ULL, 0x000fe200078ee22eULL, 0x010a080029287984ULL, 0x000ea20000004800ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x00000001312e7824ULL, 0x000fe200078e0204ULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x0000000131247824ULL, 0x040fe400078e022aULL, 0x0000001031317824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600008e0625ULL, 0xfffffff0312e7812ULL, 0x000fe400078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x000000061c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a100029287984ULL, 0x000ea60000004800ULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x0000000131267824ULL, 0x040fe400078e022aULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe200078ee22aULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x0000e0002a237811ULL, 0x000fe200078e20ffULL,
0x010a180029287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000022b297810ULL, 0x040fe20007ffe0ffULL,
0x010a00002b237984ULL, 0x000e620000004800ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b257824ULL, 0x040fe400078e022aULL, 0x000000012b277824ULL, 0x000fc400078e0204ULL,
0x000000102b287824ULL, 0x000fe400078e00ffULL, 0x00000001292c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x0022a40000004800ULL, 0xfffffff028237812ULL, 0x002fc800078ee227ULL,
0x0000e00023317811ULL, 0x000fe200078e20ffULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0229ULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b237984ULL, 0x000ea20000004800ULL,
0xfffffff0292c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c317811ULL, 0x002fe400078e20ffULL,
0x000000042b277810ULL, 0x000fca0007ffe0ffULL, 0x00000001272c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b237984ULL, 0x000ea20000004800ULL,
0xfffffff0272c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c297811ULL, 0x002fe400078e20ffULL,
0x000000062b317810ULL, 0x000fca0007ffe0ffULL, 0x000000012a2a7824ULL, 0x000fe400078e0231ULL,
0x0000000131287824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031287812ULL, 0x000fe200078ee228ULL, 0x010ac00023247984ULL, 0x004e640000004800ULL,
0x0000002415247224ULL, 0x002fc800078e0225ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x010a18002b237984ULL, 0x000ea20000004800ULL, 0x0000e00028277811ULL, 0x002fc600078e20ffULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e022aULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b1800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b1c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b1c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011604ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0101000027237984ULL, 0x000e680000000800ULL, 0x0103000027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x000103627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000020300780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x000103227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105002427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x00000012002a7308ULL, 0x000e640000000800ULL, 0x0000002a0f0f7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000102727f007947ULL, 0x000fea000b800000ULL,
0x00001f682a127589ULL, 0x0002a400000e0000ULL, 0x000000120d0d7220ULL, 0x084fe20000410000ULL,
0x000000120e0e7220ULL, 0x080fe20000410000ULL, 0x0000001209097220ULL, 0x080fe20000410000ULL,
0x000000120a0a7220ULL, 0x080fe20000410000ULL, 0x0000001205057220ULL, 0x080fe20000410000ULL,
0x0000001206067220ULL, 0x080fe20000410000ULL, 0x0000001249497220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124d4d7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x0000001251517220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001255557220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001259597220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000101827f007947ULL, 0x000fea000b800000ULL, 0x00001f652a127589ULL, 0x00046400000e0000ULL,
0x000000120b0b7220ULL, 0x082fe20000410000ULL, 0x000000120c0c7220ULL, 0x080fe20000410000ULL,
0x0000001207077220ULL, 0x080fe20000410000ULL, 0x0000001208087220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x000000124b4b7220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124f4f7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001253537220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001257577220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x000000125b5b7220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000f220f7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000ffc27f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x000100027f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000e91000207802ULL, 0x000fc40000000f00ULL,
0x000108c000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0000e96000207802ULL, 0x000fc40000000f00ULL, 0x0001087000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001d20783bULL, 0x002e620000004200ULL, 0x0000b00063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000b00064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200d0d7221ULL, 0x000fe20000010000ULL, 0x000000210e0e7221ULL, 0x000fe20000010000ULL,
0x0000004409097221ULL, 0x000fe20000010000ULL, 0x000000450a0a7221ULL, 0x000fe20000010000ULL,
0x0000002c05057221ULL, 0x000fe20000010000ULL, 0x0000002d06067221ULL, 0x000fe20000010000ULL,
0x0000003049497221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344d4d7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003851517221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c55557221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004059597221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220b0b7221ULL, 0x000fe20000010000ULL,
0x000000230c0c7221ULL, 0x000fe20000010000ULL, 0x0000004607077221ULL, 0x000fe20000010000ULL,
0x0000004708087221ULL, 0x000fe20000010000ULL, 0x0000002e1f1f7221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x000000324b4b7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364f4f7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a53537221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e57577221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425b5b7221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366247812ULL, 0x020fe400078ec0ffULL, 0x000000135e00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff24247207ULL, 0x000fe40006800000ULL,
0x0000000223207810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fc600078e0021ULL,
0x0000000320227812ULL, 0x040fe400078ec0ffULL, 0x0000001320237211ULL, 0x000fc400078ff0ffULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000123217810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000602100720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000423267824ULL, 0x000fe200078e0222ULL,
0x000000052c337c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002a7824ULL, 0x000fe400078e022bULL,
0x0000004026267824ULL, 0x000fc400078e00ffULL, 0x000000102b277824ULL, 0x000fe400078e00ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332e7812ULL, 0x000fe200078ee22eULL, 0x010ac00025207984ULL, 0x0022a40000004800ULL,
0x000000265f257217ULL, 0x002fca0007800000ULL, 0x0000000125257824ULL, 0x000fe400078e0a26ULL,
0x000000012b267824ULL, 0x000fc600078e0204ULL, 0x0000000525257c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000525257c10ULL, 0x000fe4000fffe0ffULL,
0x0000c00026317811ULL, 0x000fe400078e20ffULL, 0x000000022a267810ULL, 0x000fe20007ffe0ffULL,
0x0000002015207224ULL, 0x004fc800078e022aULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000251c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a08002b287984ULL, 0x000ea20000004800ULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000042a207810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252c00720cULL, 0x000fe40003fc6070ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c337c10ULL, 0x000fca000fffe0ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e2000f101c4cULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002b287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000062a267810ULL, 0x000fe40007ffe0ffULL,
0x000000061c2a7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000252c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a18002b287984ULL, 0x000ea80000004800ULL,
0x010ac00028287984ULL, 0x004ea40000004800ULL, 0x0000002815267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fe200078e002dULL, 0x000000052a2d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007fde0ffULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000252a00720cULL, 0x000fe40003fc6070ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c217811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000022b337810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b257984ULL, 0x000e620000004800ULL, 0x0000004000287824ULL, 0x000fe400078e022bULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x00000001332a7824ULL, 0x000fc400078e0204ULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe400078ee22aULL,
0x000000042b337810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025207984ULL, 0x002e640000004800ULL,
0x0000002015207224ULL, 0x002fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20267210ULL, 0x000fe20007fde0ffULL, 0x000000012b207824ULL, 0x000fc800078e0204ULL,
0x000000ffff277224ULL, 0x000fe400030e0621ULL, 0x000000102b217824ULL, 0x000fca00078e00ffULL,
0xfffffff021207812ULL, 0x000fe400078ee220ULL, 0x0000000228217810ULL, 0x000fe40007ffe0ffULL,
0x0000c00020317811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe200078e20ffULL, 0x00000001332a7824ULL, 0x040fe200078e0204ULL,
0x0000000428277810ULL, 0x040fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e00ffULL,
0x0000000628287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0332a7812ULL, 0x000fe200078ee22aULL,
0x010ac00025207984ULL, 0x004e640000004800ULL, 0x0000002015207224ULL, 0x002fc800078e0221ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fc600078e20ffULL, 0x010ac00025267984ULL, 0x004e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a18002b257984ULL, 0x000ea80000004800ULL, 0x010ac00025207984ULL, 0x004ea40000004800ULL,
0x0000002015207224ULL, 0x004fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fe200078e002dULL,
0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL, 0x0000002f20207210ULL, 0x000fe20007fde0ffULL,
0x000000012d287824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc600030e0621ULL, 0xfffffff02d287812ULL, 0x000fc800078ee228ULL,
0x0000c00028277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000235e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff24217207ULL, 0x040fe40003000000ULL,
0x000000ff24247207ULL, 0x000fc60007000000ULL, 0x0000000122227824ULL, 0x000fc800078e0221ULL,
0x0000004022207824ULL, 0x040fe200078e00ffULL, 0x0000002322227211ULL, 0x000fc800078ff0ffULL,
0x000000c020217812ULL, 0x000fe400078ec0ffULL, 0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL,
0x0000010022217824ULL, 0x000fca00078e0221ULL, 0x0000002021237810ULL, 0x000fca0007ffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003fc6070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x0000da927f007947ULL, 0x000fea000b800000ULL,
0x00001f68221b7589ULL, 0x0004e400000e0000ULL, 0x0000dad27f007947ULL, 0x000fea000b800000ULL,
0x00001f65221a7589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001068277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00010f0000207802ULL, 0x000fc40000000f00ULL, 0x0000e2d000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001868277810ULL, 0x002fe40007ffe0ffULL, 0x00010f5000207802ULL, 0x000fc40000000f00ULL,
0x0000e28000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006b24783bULL, 0x006e620000004200ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0000b0006d407811ULL, 0x000fe200078e20ffULL, 0x000000006a28783bULL, 0x000ea80000004200ULL,
0x000000006920783bULL, 0x000fe80000004200ULL, 0x000000006c34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe20000011424ULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000001002a337824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011428ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x00008880288b7816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc40000011429ULL, 0x0000888029867816ULL, 0x040fe400000000ffULL,
0x00000018ff847819ULL, 0x000fe20000011428ULL, 0x0000002e003d7306ULL, 0x0003e20000200c00ULL,
0x0000010026287824ULL, 0x000fe200078e00ffULL, 0x0000888024447816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011433ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011420ULL,
0x00000100292e7824ULL, 0x042fe200078e00ffULL, 0x0000888020787816ULL, 0x000fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011425ULL,
0x0000003200887306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe20000011429ULL,
0x0000010027297824ULL, 0x000fe200078e00ffULL, 0x0000888025457816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002e00897306ULL, 0x0005e20000200c00ULL, 0x0000888027327816ULL, 0x042fe200000000ffULL,
0x0000001a4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x00008880262e7816ULL, 0x044fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00008880343e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff877819ULL, 0x000fe20000011436ULL,
0x0000002600337306ULL, 0x0002a20000200c00ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff827819ULL, 0x000fe40000011437ULL, 0x00008880378d7816ULL, 0x000fc400000000ffULL,
0x00000018ff397819ULL, 0x000fe20000011435ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x042fe200078e00ffULL, 0x00008880358c7816ULL, 0x000fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011421ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff747819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x00000029003f7306ULL, 0x000fe20000200c00ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888021777816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe4000001142aULL,
0x00000018ff757819ULL, 0x000fe4000001142bULL, 0x000088802a7f7816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000088802b7c7816ULL, 0x000fe200000000ffULL,
0x0000002f00467306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff717819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011423ULL, 0x00000028002f7306ULL, 0x0005e20000200c00ULL,
0x0000541044447816ULL, 0x002fce000000003dULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x000001002b287824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x00000018ff2b7819ULL, 0x000fce000001142bULL, 0x0000003100317306ULL, 0x000ff00000200c00ULL,
0x00000027008a7306ULL, 0x0004e20000200c00ULL, 0x0000541025297816ULL, 0x002fce000000002cULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0001000035277824ULL, 0x004fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002000837306ULL, 0x0002a20000200c00ULL,
0x000054108a317816ULL, 0x008fce0000000031ULL, 0x0000002600797306ULL, 0x0007e20000200c00ULL,
0x0000010036207824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011420ULL, 0x00000028007d7306ULL, 0x0003e20000200c00ULL,
0x0000010035267824ULL, 0x008fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc80000011436ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027003a7306ULL, 0x000fe20000200c00ULL,
0x0000541024287816ULL, 0x002fe4000000002dULL, 0x0000b0006e247811ULL, 0x000fe400078e20ffULL,
0x00005410322d7816ULL, 0x000fe2000000003fULL, 0x0000010037327824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000002600357306ULL, 0x0003e40000200c00ULL,
0x00000018ff8a7819ULL, 0x000fc40000011432ULL, 0x000000304030723cULL, 0x000fe800000018ffULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000000200ULL,
0x00000034003b7306ULL, 0x0005f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103e347816ULL, 0x004fe20000000083ULL, 0x00000100213e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011437ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000541045457816ULL, 0x008fc60000000046ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff217819ULL, 0x000fc60000011421ULL, 0x000000444044723cULL, 0x000f6800000018ffULL,
0x0000003800387306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x000054103c3c7816ULL, 0x004fe2000000003dULL, 0x0000001b2424b232ULL, 0x002fc40000000000ULL,
0x0000001b2626b232ULL, 0x000fe40000000000ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x0000001a2727b232ULL, 0x000fcc0000000000ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x000054103a397816ULL, 0x010fce0000000039ULL, 0x0000008d003f7306ULL, 0x000fe20000200c00ULL,
0x000054102e2c7816ULL, 0x002fe2000000002fULL, 0x000000384038723cULL, 0x040fec00000018ffULL,
0x0000008a008e7306ULL, 0x000e620000200c00ULL, 0x000054108c357816ULL, 0x004fe20000000035ULL,
0x0000002c402c723cULL, 0x000fe200000018ffULL, 0x00000018ff8c7819ULL, 0x000fca000001143eULL,
0x0000008700877306ULL, 0x000fe40000200c00ULL, 0x000000344034723cULL, 0x000fec00000018ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000054103f3d7816ULL, 0x002fe4000000008eULL,
0x00008880228e7816ULL, 0x000fca00000000ffULL, 0x0000002000207306ULL, 0x000e620000200c00ULL,
0x0000003c403c723cULL, 0x000fee00000018ffULL, 0x00000083008d7306ULL, 0x000eb00000200c00ULL,
0x0000002100837306ULL, 0x0005e20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000087ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000054108d217816ULL, 0x004fe20000000082ULL,
0x000000ffff827224ULL, 0x000fcc00078e008eULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002a007b7306ULL, 0x000ff00000200c00ULL, 0x0000002b007a7306ULL, 0x0005f00000200c00ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000000284028723cULL, 0x044f6e00000018ffULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000000204040723cULL, 0x000b6e00000018ffULL,
0x0000010022207824ULL, 0x020fe200078e00ffULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x0000541086217816ULL, 0x002fe20000000089ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888023867816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000002000877306ULL, 0x0007f00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108b207816ULL, 0x008fce0000000088ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000007c007c7306ULL, 0x000f220000200c00ULL,
0x0000541084207816ULL, 0x024fe40000000081ULL, 0x0000541085217816ULL, 0x002fe20000000080ULL,
0x0000010023807824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe400078e00ffULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x000000ffff217224ULL, 0x020fe200078e0086ULL,
0x000054107f207816ULL, 0x008fcc000000007eULL, 0x0000002100817306ULL, 0x0009f00000200c00ULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0x000054107c217816ULL, 0x010fce000000007dULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008c008a7306ULL, 0x000f220000200c00ULL, 0x000054107b207816ULL, 0x022fe40000000076ULL,
0x000054107a217816ULL, 0x004fca0000000075ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541078207816ULL, 0x028fe40000000079ULL, 0x0000541077217816ULL, 0x010fca000000008aULL,
0x0000007400747306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x0000541083217816ULL, 0x022fce0000000072ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x0000541074207816ULL, 0x004fce0000000073ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541082207816ULL, 0x028fe40000000087ULL,
0x0000541081217816ULL, 0x002fca0000000080ULL, 0x0000002200227306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541022207816ULL, 0x022fe40000000071ULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000440d0d7221ULL, 0x000fe20000010000ULL,
0x000000450e0e7221ULL, 0x000fe20000010000ULL, 0x0000002809097221ULL, 0x000fe20000010000ULL,
0x000000290a0a7221ULL, 0x000fe20000010000ULL, 0x0000002c05057221ULL, 0x000fe20000010000ULL,
0x0000002d06067221ULL, 0x000fe20000010000ULL, 0x0000003049497221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000344d4d7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003851517221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c55557221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x0000004059597221ULL, 0x020fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460b0b7221ULL, 0x000fe20000010000ULL, 0x000000470c0c7221ULL, 0x000fe20000010000ULL,
0x0000002a07077221ULL, 0x000fe20000010000ULL, 0x0000002b08087221ULL, 0x000fe20000010000ULL,
0x0000002e1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x000000324b4b7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x000000364f4f7221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a53537221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e57577221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425b5b7221ULL, 0x020fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006f7000720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaae000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c013207811ULL, 0x020fe200078e40ffULL, 0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005f2000720cULL, 0x000fda0003f06070ULL, 0x0000559000000947ULL, 0x000fea0003800000ULL,
0x000000ffff707224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x020fe20000011670ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000370227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000002170217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000321247810ULL, 0x000fc80007ffe0ffULL,
0x0000000324207812ULL, 0x040fe400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121237810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x000000602300720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000051c297c10ULL, 0x000fe2000fffe0ffULL,
0x0000000421247824ULL, 0x000fe200078e0220ULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x0000001004277824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a000029257984ULL, 0x000e620000004800ULL, 0x0000002024247811ULL, 0x000fe200078e30ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000f0272d7812ULL, 0x000fe200078ec0ffULL,
0x0000000129277824ULL, 0x000fe200078e0204ULL, 0x000000245f237217ULL, 0x000fe20007800000ULL,
0x0000001029287824ULL, 0x000fe200078e00ffULL, 0x000000052c317c10ULL, 0x000fc6000fffe0ffULL,
0x0000000123237824ULL, 0x000fe400078e0a24ULL, 0x0000000129247824ULL, 0x000fe400078e022aULL,
0x00000001312e7824ULL, 0x000fe200078e0204ULL, 0x0000000523237c17ULL, 0x000fc8000f800000ULL,
0x8000000523237c10ULL, 0x000fc8000fffe0ffULL, 0x000000231c00720cULL, 0x000fe20003f06070ULL,
0x010ac00025267984ULL, 0x002e640000004800ULL, 0x0000002615247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe40007f3e0ffULL,
0xfffffff028247812ULL, 0x000fc600078ee227ULL, 0x000000ffff277224ULL, 0x000fe200008e0625ULL,
0x0000e000242f7811ULL, 0x000fe200078e20ffULL, 0x0000000131247824ULL, 0x040fe400078e022aULL,
0x0000001031317824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000232c00720cULL, 0x000fe40003f06070ULL,
0xfffffff0312e7812ULL, 0x000fe200078ee22eULL, 0x010a080029287984ULL, 0x000ea20000004800ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x00000001312e7824ULL, 0x000fe200078e0204ULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x0000000131247824ULL, 0x040fe400078e022aULL, 0x0000001031317824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc600008e0625ULL, 0xfffffff0312e7812ULL, 0x000fe400078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x000000061c2c7810ULL, 0x000fe20007ffe0ffULL,
0x010a100029287984ULL, 0x000ea60000004800ULL, 0x000000052c317c10ULL, 0x000fe4000fffe0ffULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x0000000131267824ULL, 0x040fe400078e022aULL,
0x00000001312a7824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe200078ee22aULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e2000c101c4cULL,
0x000000232c00720cULL, 0x000fe40003f06070ULL, 0x0000e0002a237811ULL, 0x000fe200078e20ffULL,
0x010a180029287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26247210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x00000020002a7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000022b297810ULL, 0x040fe20007ffe0ffULL,
0x010a00002b237984ULL, 0x000e620000004800ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b257824ULL, 0x040fe400078e022aULL, 0x000000012b277824ULL, 0x000fc400078e0204ULL,
0x000000102b287824ULL, 0x000fe400078e00ffULL, 0x00000001292c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x0022a40000004800ULL, 0xfffffff028237812ULL, 0x002fc800078ee227ULL,
0x0000e00023317811ULL, 0x000fe200078e20ffULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0229ULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b237984ULL, 0x000ea20000004800ULL,
0xfffffff0292c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c317811ULL, 0x002fe400078e20ffULL,
0x000000042b277810ULL, 0x000fca0007ffe0ffULL, 0x00000001272c7824ULL, 0x000fe200078e0204ULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe400000e0625ULL, 0x000000012a257824ULL, 0x000fe400078e0227ULL,
0x0000001027277824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b237984ULL, 0x000ea20000004800ULL,
0xfffffff0272c7812ULL, 0x000fc800078ee22cULL, 0x0000e0002c297811ULL, 0x002fe400078e20ffULL,
0x000000062b317810ULL, 0x000fca0007ffe0ffULL, 0x000000012a2a7824ULL, 0x000fe400078e0231ULL,
0x0000000131287824ULL, 0x040fe400078e0204ULL, 0x0000001031317824ULL, 0x000fca00078e00ffULL,
0xfffffff031287812ULL, 0x000fe200078ee228ULL, 0x010ac00023247984ULL, 0x004e640000004800ULL,
0x0000002415247224ULL, 0x002fc800078e0225ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x010a18002b237984ULL, 0x000ea20000004800ULL, 0x0000e00028277811ULL, 0x002fc600078e20ffULL,
0x010ac00023247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e022aULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b3800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b3c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b3c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001004187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011604ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0101800027237984ULL, 0x000e680000000800ULL, 0x0103800027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x0000b0727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000030300780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x0000b0327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x00000012002a7308ULL, 0x000e640000000800ULL, 0x0000002a0f0f7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000af827f007947ULL, 0x000fea000b800000ULL,
0x00001f682a127589ULL, 0x0002a400000e0000ULL, 0x000000120d0d7220ULL, 0x084fe20000410000ULL,
0x000000120e0e7220ULL, 0x080fe20000410000ULL, 0x0000001209097220ULL, 0x080fe20000410000ULL,
0x000000120a0a7220ULL, 0x080fe20000410000ULL, 0x0000001205057220ULL, 0x080fe20000410000ULL,
0x0000001206067220ULL, 0x080fe20000410000ULL, 0x0000001249497220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124d4d7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x0000001251517220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001255557220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001259597220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000ae927f007947ULL, 0x000fea000b800000ULL, 0x00001f652a127589ULL, 0x00046400000e0000ULL,
0x000000120b0b7220ULL, 0x082fe20000410000ULL, 0x000000120c0c7220ULL, 0x080fe20000410000ULL,
0x0000001207077220ULL, 0x080fe20000410000ULL, 0x0000001208087220ULL, 0x080fe20000410000ULL,
0x000000121f1f7220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x000000124b4b7220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124f4f7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001253537220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001257577220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x000000125b5b7220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000f220f7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000acd27f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x0000ad127f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00013ed000207802ULL, 0x000fc40000000f00ULL,
0x0000b30000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x00013f2000207802ULL, 0x000fc40000000f00ULL, 0x0000b2b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001d20783bULL, 0x002e620000004200ULL, 0x0000b80063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000b80064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200d0d7221ULL, 0x000fe20000010000ULL, 0x000000210e0e7221ULL, 0x000fe20000010000ULL,
0x0000004409097221ULL, 0x000fe20000010000ULL, 0x000000450a0a7221ULL, 0x000fe20000010000ULL,
0x0000002c05057221ULL, 0x000fe20000010000ULL, 0x0000002d06067221ULL, 0x000fe20000010000ULL,
0x0000003049497221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344d4d7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003851517221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c55557221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004059597221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220b0b7221ULL, 0x000fe20000010000ULL,
0x000000230c0c7221ULL, 0x000fe20000010000ULL, 0x0000004607077221ULL, 0x000fe20000010000ULL,
0x0000004708087221ULL, 0x000fe20000010000ULL, 0x0000002e1f1f7221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x000000324b4b7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364f4f7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a53537221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e57577221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425b5b7221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366247812ULL, 0x020fe400078ec0ffULL, 0x000000135e00720cULL, 0x000fe40003f03070ULL,
0x00000040ff297803ULL, 0x000fe40000000000ULL, 0x000000ff24247207ULL, 0x000fe40006800000ULL,
0x0000000323207810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fc600078e0021ULL,
0x0000000320227812ULL, 0x040fe400078ec0ffULL, 0x0000001320237211ULL, 0x000fc400078ff0ffULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x010b8c00ff257984ULL, 0x000e620000000800ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000025ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e21ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011427ULL, 0x0000002625257211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000225257819ULL, 0x000fc80000001226ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000123217810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x000000602100720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000021c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x0000000423267824ULL, 0x000fe200078e0222ULL,
0x000000052c337c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002a7824ULL, 0x000fe400078e022bULL,
0x0000004026267824ULL, 0x000fc400078e00ffULL, 0x000000102b277824ULL, 0x000fe400078e00ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x0000001033337824ULL, 0x000fca00078e00ffULL,
0xfffffff0332e7812ULL, 0x000fe200078ee22eULL, 0x010ac00025207984ULL, 0x0022a40000004800ULL,
0x000000265f257217ULL, 0x002fca0007800000ULL, 0x0000000125257824ULL, 0x000fe400078e0a26ULL,
0x000000012b267824ULL, 0x000fc600078e0204ULL, 0x0000000525257c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000525257c10ULL, 0x000fe4000fffe0ffULL,
0x0000c00026317811ULL, 0x000fe400078e20ffULL, 0x000000022a267810ULL, 0x000fe20007ffe0ffULL,
0x0000002015207224ULL, 0x004fc800078e022aULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000251c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a08002b287984ULL, 0x000ea20000004800ULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000042a207810ULL, 0x000fe20007ffe0ffULL,
0x010ac00028287984ULL, 0x004e640000004800ULL, 0x0000002815267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000252c00720cULL, 0x000fe40003fc6070ULL,
0x000000041c2c7810ULL, 0x000fc80007ffe0ffULL, 0x000000052c337c10ULL, 0x000fca000fffe0ffULL,
0x00000001332e7824ULL, 0x040fe400078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e2000f101c4cULL, 0x0000001033337824ULL, 0x000fc600078e00ffULL,
0x010a10002b287984ULL, 0x000ea40000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x0000c0002e317811ULL, 0x002fe400078e20ffULL, 0x000000062a267810ULL, 0x000fe40007ffe0ffULL,
0x000000061c2a7810ULL, 0x000fe20007ffe0ffULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20207210ULL, 0x000fca0007fde0ffULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x000000252c00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000f101c4cULL, 0x010a18002b287984ULL, 0x000ea80000004800ULL,
0x010ac00028287984ULL, 0x004ea40000004800ULL, 0x0000002815267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fe200078e002dULL, 0x000000052a2d7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f26267210ULL, 0x000fe20007fde0ffULL, 0x000000012d2c7824ULL, 0x040fe400078e0204ULL,
0x000000102d2d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000252a00720cULL, 0x000fe40003fc6070ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x0000c0002c217811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026217faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051c2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001004267824ULL, 0x000fe200078e00ffULL, 0x000000022b337810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b257984ULL, 0x000e620000004800ULL, 0x0000004000287824ULL, 0x000fe400078e022bULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x00000001332a7824ULL, 0x000fc400078e0204ULL,
0x0000001033337824ULL, 0x000fca00078e00ffULL, 0xfffffff0332a7812ULL, 0x000fe400078ee22aULL,
0x000000042b337810ULL, 0x000fe20007ffe0ffULL, 0x010ac00025207984ULL, 0x002e640000004800ULL,
0x0000002015207224ULL, 0x002fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fca00078e002dULL,
0x0000002f20267210ULL, 0x000fe20007fde0ffULL, 0x000000012b207824ULL, 0x000fc800078e0204ULL,
0x000000ffff277224ULL, 0x000fe400030e0621ULL, 0x000000102b217824ULL, 0x000fca00078e00ffULL,
0xfffffff021207812ULL, 0x000fe400078ee220ULL, 0x0000000228217810ULL, 0x000fe40007ffe0ffULL,
0x0000c00020317811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x010a08002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fe200078e20ffULL, 0x00000001332a7824ULL, 0x040fe200078e0204ULL,
0x0000000428277810ULL, 0x040fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e00ffULL,
0x0000000628287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0332a7812ULL, 0x000fe200078ee22aULL,
0x010ac00025207984ULL, 0x004e640000004800ULL, 0x0000002015207224ULL, 0x002fc800078e0221ULL,
0x00005e0020207625ULL, 0x000fca00078e002dULL, 0x0000002f20207210ULL, 0x000fca0007fde0ffULL,
0x000000ffff217224ULL, 0x000fca00030e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020317faeULL, 0x0003e8000b901c4cULL, 0x010a10002b257984ULL, 0x000ea20000004800ULL,
0x0000c0002a317811ULL, 0x002fc600078e20ffULL, 0x010ac00025267984ULL, 0x004e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x010a18002b257984ULL, 0x000ea80000004800ULL, 0x010ac00025207984ULL, 0x004ea40000004800ULL,
0x0000002015207224ULL, 0x004fc800078e0228ULL, 0x00005e0020207625ULL, 0x000fe200078e002dULL,
0x000000062b2d7810ULL, 0x000fc80007ffe0ffULL, 0x0000002f20207210ULL, 0x000fe20007fde0ffULL,
0x000000012d287824ULL, 0x040fe400078e0204ULL, 0x000000102d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff217224ULL, 0x000fc600030e0621ULL, 0xfffffff02d287812ULL, 0x000fc800078ee228ULL,
0x0000c00028277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b8c00ff257984ULL, 0x000e620000000800ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000025ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002620267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e21ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011427ULL,
0x0000002625257211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000225257819ULL, 0x000fc80000001226ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000235e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff24217207ULL, 0x040fe40003000000ULL,
0x000000ff24247207ULL, 0x000fc60007000000ULL, 0x0000000122227824ULL, 0x000fc800078e0221ULL,
0x0000004022207824ULL, 0x040fe200078e00ffULL, 0x0000002322227211ULL, 0x000fc800078ff0ffULL,
0x000000c020217812ULL, 0x000fe400078ec0ffULL, 0x0000000a24207c10ULL, 0x000fc6000fffe0ffULL,
0x0000010022217824ULL, 0x000fca00078e0221ULL, 0x0000002021237810ULL, 0x000fca0007ffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003fc6070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000087a27f007947ULL, 0x000fea000b800000ULL,
0x00001f68221b7589ULL, 0x0004e400000e0000ULL, 0x000087e27f007947ULL, 0x000fea000b800000ULL,
0x00001f65221a7589ULL, 0x0004e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001068277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000164c000207802ULL, 0x000fc40000000f00ULL, 0x00008d1000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001868277810ULL, 0x002fe40007ffe0ffULL, 0x0001651000207802ULL, 0x000fc40000000f00ULL,
0x00008cc000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006b24783bULL, 0x006e620000004200ULL,
0x000000ff2900720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0000b8006d407811ULL, 0x000fe200078e20ffULL, 0x000000006a28783bULL, 0x000ea80000004200ULL,
0x000000006920783bULL, 0x000fe80000004200ULL, 0x000000006c34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe20000011424ULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000001002a337824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011428ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x00008880288b7816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc40000011429ULL, 0x0000888029867816ULL, 0x040fe400000000ffULL,
0x00000018ff847819ULL, 0x000fe20000011428ULL, 0x0000002e003d7306ULL, 0x0003e20000200c00ULL,
0x0000010026287824ULL, 0x000fe200078e00ffULL, 0x0000888024447816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011433ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011420ULL,
0x00000100292e7824ULL, 0x042fe200078e00ffULL, 0x0000888020787816ULL, 0x000fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011425ULL,
0x0000003200887306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe20000011429ULL,
0x0000010027297824ULL, 0x000fe200078e00ffULL, 0x0000888025457816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002e00897306ULL, 0x0005e20000200c00ULL, 0x0000888027327816ULL, 0x042fe200000000ffULL,
0x0000001a4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x00008880262e7816ULL, 0x044fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00008880343e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff877819ULL, 0x000fe20000011436ULL,
0x0000002600337306ULL, 0x0002a20000200c00ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff827819ULL, 0x000fe40000011437ULL, 0x00008880378d7816ULL, 0x000fc400000000ffULL,
0x00000018ff397819ULL, 0x000fe20000011435ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x042fe200078e00ffULL, 0x00008880358c7816ULL, 0x000fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011421ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff747819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x00000029003f7306ULL, 0x000fe20000200c00ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888021777816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe4000001142aULL,
0x00000018ff757819ULL, 0x000fe4000001142bULL, 0x000088802a7f7816ULL, 0x040fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000088802b7c7816ULL, 0x000fe200000000ffULL,
0x0000002f00467306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x004fc40000000030ULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff717819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011423ULL, 0x00000028002f7306ULL, 0x0005e20000200c00ULL,
0x0000541044447816ULL, 0x002fce000000003dULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x000001002b287824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x00000018ff2b7819ULL, 0x000fce000001142bULL, 0x0000003100317306ULL, 0x000ff00000200c00ULL,
0x00000027008a7306ULL, 0x0004e20000200c00ULL, 0x0000541025297816ULL, 0x002fce000000002cULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0001000035277824ULL, 0x004fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002000837306ULL, 0x0002a20000200c00ULL,
0x000054108a317816ULL, 0x008fce0000000031ULL, 0x0000002600797306ULL, 0x0007e20000200c00ULL,
0x0000010036207824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011420ULL, 0x00000028007d7306ULL, 0x0003e20000200c00ULL,
0x0000010035267824ULL, 0x008fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc80000011436ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000027003a7306ULL, 0x000fe20000200c00ULL,
0x0000541024287816ULL, 0x002fe4000000002dULL, 0x0000b8006e247811ULL, 0x000fe400078e20ffULL,
0x00005410322d7816ULL, 0x000fe2000000003fULL, 0x0000010037327824ULL, 0x040fe400078e00ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000002600357306ULL, 0x0003e40000200c00ULL,
0x00000018ff8a7819ULL, 0x000fc40000011432ULL, 0x000000304030723cULL, 0x000fe800000018ffULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000000200ULL,
0x00000034003b7306ULL, 0x0005f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103e347816ULL, 0x004fe20000000083ULL, 0x00000100213e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011437ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000541045457816ULL, 0x008fc60000000046ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff217819ULL, 0x000fc60000011421ULL, 0x000000444044723cULL, 0x000f6800000018ffULL,
0x0000003800387306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x000054103c3c7816ULL, 0x004fe2000000003dULL, 0x0000001b2424b232ULL, 0x002fc40000000000ULL,
0x0000001b2626b232ULL, 0x000fe40000000000ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x0000001a2727b232ULL, 0x000fcc0000000000ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x000054103a397816ULL, 0x010fce0000000039ULL, 0x0000008d003f7306ULL, 0x000fe20000200c00ULL,
0x000054102e2c7816ULL, 0x002fe2000000002fULL, 0x000000384038723cULL, 0x040fec00000018ffULL,
0x0000008a008e7306ULL, 0x000e620000200c00ULL, 0x000054108c357816ULL, 0x004fe20000000035ULL,
0x0000002c402c723cULL, 0x000fe200000018ffULL, 0x00000018ff8c7819ULL, 0x000fca000001143eULL,
0x0000008700877306ULL, 0x000fe40000200c00ULL, 0x000000344034723cULL, 0x000fec00000018ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x000054103f3d7816ULL, 0x002fe4000000008eULL,
0x00008880228e7816ULL, 0x000fca00000000ffULL, 0x0000002000207306ULL, 0x000e620000200c00ULL,
0x0000003c403c723cULL, 0x000fee00000018ffULL, 0x00000083008d7306ULL, 0x000eb00000200c00ULL,
0x0000002100837306ULL, 0x0005e20000200c00ULL, 0x0000541020207816ULL, 0x002fce0000000087ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000054108d217816ULL, 0x004fe20000000082ULL,
0x000000ffff827224ULL, 0x000fcc00078e008eULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002a007b7306ULL, 0x000ff00000200c00ULL, 0x0000002b007a7306ULL, 0x0005f00000200c00ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000000284028723cULL, 0x044f6e00000018ffULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000000204040723cULL, 0x000b6e00000018ffULL,
0x0000010022207824ULL, 0x020fe200078e00ffULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x0000541086217816ULL, 0x002fe20000000089ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000888023867816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000002000877306ULL, 0x0007f00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108b207816ULL, 0x008fce0000000088ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000007c007c7306ULL, 0x000f220000200c00ULL,
0x0000541084207816ULL, 0x024fe40000000081ULL, 0x0000541085217816ULL, 0x002fe20000000080ULL,
0x0000010023807824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe400078e00ffULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x000000ffff217224ULL, 0x020fe200078e0086ULL,
0x000054107f207816ULL, 0x008fcc000000007eULL, 0x0000002100817306ULL, 0x0009f00000200c00ULL,
0x0000007800787306ULL, 0x000ee20000200c00ULL, 0x000054107c217816ULL, 0x010fce000000007dULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008c008a7306ULL, 0x000f220000200c00ULL, 0x000054107b207816ULL, 0x022fe40000000076ULL,
0x000054107a217816ULL, 0x004fca0000000075ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541078207816ULL, 0x028fe40000000079ULL, 0x0000541077217816ULL, 0x010fca000000008aULL,
0x0000007400747306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x0000541083217816ULL, 0x022fce0000000072ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x0000541074207816ULL, 0x004fce0000000073ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541082207816ULL, 0x028fe40000000087ULL,
0x0000541081217816ULL, 0x002fca0000000080ULL, 0x0000002200227306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541022207816ULL, 0x022fe40000000071ULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000440d0d7221ULL, 0x000fe20000010000ULL,
0x000000450e0e7221ULL, 0x000fe20000010000ULL, 0x0000002809097221ULL, 0x000fe20000010000ULL,
0x000000290a0a7221ULL, 0x000fe20000010000ULL, 0x0000002c05057221ULL, 0x000fe20000010000ULL,
0x0000002d06067221ULL, 0x000fe20000010000ULL, 0x0000003049497221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000344d4d7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003851517221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c55557221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x0000004059597221ULL, 0x020fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460b0b7221ULL, 0x000fe20000010000ULL, 0x000000470c0c7221ULL, 0x000fe20000010000ULL,
0x0000002a07077221ULL, 0x000fe20000010000ULL, 0x0000002b08087221ULL, 0x000fe20000010000ULL,
0x0000002e1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x000000324b4b7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x000000364f4f7221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a53537221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e57577221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425b5b7221ULL, 0x020fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000170707810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006f7000720cULL, 0x000fe20003f06070ULL,
0x010b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaae000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000113137810ULL, 0x000fc80007ffe0ffULL,
0x000000601300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffea52000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6000720cULL, 0x000fe20003f05270ULL, 0x000000ffff157224ULL, 0x000fe400078e0005ULL,
0x000000ffff127224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fd000078e0007ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x018000000f007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000177e000047802ULL, 0x000fc40000000f00ULL, 0x0000784000007944ULL, 0x022fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000f00007308ULL, 0x000ea40000001000ULL,
0xbf80000000037423ULL, 0x004fc8000000000fULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff057624ULL, 0x000fe400078e00ffULL, 0x00006e00ff047624ULL, 0x000fca00078e00ffULL,
0x0000000c04057981ULL, 0x000f28000c1e9900ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x00000002ff277819ULL, 0x028fe20000011603ULL, 0x0000000005037220ULL, 0x014fe20000410000ULL,
0x000073f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2703007589ULL, 0x0004e400000e0000ULL,
0x0000000000047919ULL, 0x000f220000000000ULL, 0x0000000d000d7220ULL, 0x048fe20000410000ULL,
0x0000000e000e7220ULL, 0x040fe20000410000ULL, 0x0000000900097220ULL, 0x040fe20000410000ULL,
0x0000000a000a7220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x040fe20000410000ULL,
0x0000000600067220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x040fe20000410000ULL,
0x0000004a004a7220ULL, 0x040fe20000410000ULL, 0x0000004d004d7220ULL, 0x040fe20000410000ULL,
0x0000004e004e7220ULL, 0x040fe20000410000ULL, 0x0000005100517220ULL, 0x040fe20000410000ULL,
0x0000005200527220ULL, 0x040fe20000410000ULL, 0x0000005500557220ULL, 0x040fe20000410000ULL,
0x0000005600567220ULL, 0x040fe20000410000ULL, 0x0000005900597220ULL, 0x040fe20000410000ULL,
0x0000005a005a7220ULL, 0x000fe20000410000ULL, 0x0000000804277811ULL, 0x016fe200078ff0ffULL,
0x000073027f007947ULL, 0x000fea000b800000ULL, 0x00001f2703007589ULL, 0x0002a400000e0000ULL,
0x0000000b000b7220ULL, 0x044fe20000410000ULL, 0x0000000c000c7220ULL, 0x040fe20000410000ULL,
0x0000001300137220ULL, 0x040fe20000410000ULL, 0x0000001200127220ULL, 0x040fe20000410000ULL,
0x0000001f001f7220ULL, 0x040fe20000410000ULL, 0x0000004800487220ULL, 0x040fe20000410000ULL,
0x0000004b004b7220ULL, 0x040fe20000410000ULL, 0x0000004c004c7220ULL, 0x040fe20000410000ULL,
0x0000004f004f7220ULL, 0x040fe20000410000ULL, 0x0000005000507220ULL, 0x040fe20000410000ULL,
0x0000005300537220ULL, 0x040fe20000410000ULL, 0x0000005400547220ULL, 0x040fe20000410000ULL,
0x0000005700577220ULL, 0x040fe20000410000ULL, 0x0000005800587220ULL, 0x040fe20000410000ULL,
0x0000005b005b7220ULL, 0x040fe20000410000ULL, 0x0000005c005c7220ULL, 0x000fc20000410000ULL,
0x00000000001d7919ULL, 0x000ea20000002600ULL, 0x000000090a03723eULL, 0x002fe200000000ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000d0e00723eULL, 0x000fc400000000ffULL,
0x000000150604723eULL, 0x000fe400000000ffULL, 0x0000000b0c0a723eULL, 0x000fe400000000ffULL,
0x000000494a05723eULL, 0x000fe400000000ffULL, 0x0000004d4e06723eULL, 0x000fe400000000ffULL,
0x000000515207723eULL, 0x000fe400000000ffULL, 0x000000555608723eULL, 0x000fc400000000ffULL,
0x000000595a09723eULL, 0x000fe400000000ffULL, 0x00000013120b723eULL, 0x000fe400000000ffULL,
0x0000001f480c723eULL, 0x000fe400000000ffULL, 0x0000004b4c0d723eULL, 0x000fe400000000ffULL,
0x0000004f500e723eULL, 0x000fe400000000ffULL, 0x00000053540f723eULL, 0x000fc400000000ffULL,
0x000000575810723eULL, 0x000fe400000000ffULL, 0x0000005b5c11723eULL, 0x000fc400000000ffULL,
0x0000000000157919ULL, 0x004e620000000000ULL, 0x0000a00008087891ULL, 0x000fe2000f8e583fULL,
0x00005410001a7816ULL, 0x000fe40000000003ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000815137811ULL, 0x002fc400078ff0ffULL, 0x0000000215127812ULL, 0x000fc600078ec0ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001312147211ULL, 0x040fe200078ff8ffULL,
0x0000000815137824ULL, 0x000fe200078e00ffULL, 0x00000002ff157819ULL, 0x000fe40000011615ULL,
0xfffffff817177812ULL, 0x000fe400078ee214ULL, 0x0000000813147812ULL, 0x000fe200078ec0ffULL,
0x0000000815137824ULL, 0x040fe200078e00ffULL, 0x0000001512127211ULL, 0x000fe200078ff8ffULL,
0x0000000815187824ULL, 0x000fc400078e00ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee212ULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000000212157810ULL, 0x040fe40007ffe0ffULL, 0x0000000412167810ULL, 0x040fe40007ffe0ffULL,
0x0000000612127810ULL, 0x000fe40007ffe0ffULL, 0x0000000813137c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff818157812ULL, 0x000fc400078ee215ULL, 0xfffffff819167812ULL, 0x000fe200078ee216ULL,
0x0000000113137824ULL, 0x000fe200078e0214ULL, 0xfffffff81b127812ULL, 0x000fe400078ee212ULL,
0x00007632001b7816ULL, 0x000fe40000000003ULL, 0x0000000815157c11ULL, 0x000fe4000f8e20ffULL,
0x0000000816037c11ULL, 0x000fe2000f8e20ffULL, 0x0000001a13007388ULL, 0x0003e20000000a00ULL,
0x0000000817197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114157824ULL, 0x000fe200078e0215ULL,
0x0000000812177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114037824ULL, 0x000fe200078e0203ULL,
0x0000541004127816ULL, 0x000fe20000000005ULL, 0x0000000114197824ULL, 0x000fc400078e0219ULL,
0x0000000114177824ULL, 0x000fe200078e0217ULL, 0x0000763204137816ULL, 0x002fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000001215007388ULL, 0x000fe20000000a00ULL, 0x000054100a067816ULL, 0x140fe4000000000bULL,
0x000076320a077816ULL, 0x000fe2000000000bULL, 0x0000000403007388ULL, 0x0003e40000000a00ULL,
0x0000541008047816ULL, 0x002fc40000000009ULL, 0x0000763208057816ULL, 0x000fca0000000009ULL,
0x0000000417007388ULL, 0x0003e80000000a00ULL, 0x0000000619007388ULL, 0x0005e20000000a00ULL,
0x000054100c047816ULL, 0x142fe4000000000dULL, 0x000076320c057816ULL, 0x000fe4000000000dULL,
0x000054100e067816ULL, 0x144fe4000000000fULL, 0x000076320e077816ULL, 0x000fe2000000000fULL,
0x0004000415007388ULL, 0x0003e80000000a00ULL, 0x0004000603007388ULL, 0x0005e20000000a00ULL,
0x0000541010047816ULL, 0x002fc40000000011ULL, 0x0000763210057816ULL, 0x000fca0000000011ULL,
0x0004000417007388ULL, 0x0005e20000000a00ULL, 0x0000002000007947ULL, 0x000fea0003800000ULL,
0x00017fe000207802ULL, 0x020fc40000000f00ULL, 0x000072a000007944ULL, 0x004fea0003c00000ULL,
0x0000000000097919ULL, 0x000e620000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL,
0x000000040b0472a4ULL, 0x000fcc000f8e023fULL, 0x00000004ff037e24ULL, 0x004fe2000f8e00ffULL,
0x00000003ff007819ULL, 0x002fca0000011609ULL, 0x0000000100027824ULL, 0x040fe400078e0209ULL,
0x0000580000007a24ULL, 0x000fc600078e021dULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000003007211ULL, 0x000fe400078010ffULL, 0x0ffffff802047812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe400078048ffULL, 0x0000000804047984ULL, 0x000e62000800cc00ULL,
0x1ffffff809097812ULL, 0x000fc400078ef808ULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d0cULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000608057899ULL, 0x000fe2000800063fULL,
0x000000200f037810ULL, 0x000fca0007ffe0ffULL, 0x000000050f047c10ULL, 0x000fe2000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000680000047ab9ULL, 0x000fe20000000800ULL,
0x0000000503067c10ULL, 0x000fe2000fffe0ffULL, 0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL,
0x0000005f0400720cULL, 0x080fe20003f06070ULL, 0x0000000808067899ULL, 0x000fe2000800063fULL,
0x0000005f0600720cULL, 0x000fe20003f26070ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x010ad000ff0a7f8cULL, 0x000e62000c80043fULL, 0x000000040f047c10ULL, 0x000fe2000fffe0ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000403067c10ULL, 0x000fe2000fffe0ffULL,
0x00006e00ff087624ULL, 0x000fe200078e00ffULL, 0x000000060f037c11ULL, 0x040fe2000f8e10ffULL,
0x0000660004047625ULL, 0x000fe200078e000dULL, 0x000000030f00780cULL, 0x000fc60003f44070ULL,
0x0000660006067625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1060000004037faeULL, 0x0005e6000c12184cULL, 0x00006f00ff097624ULL, 0x000fe200078e00ffULL,
0x1068000006037faeULL, 0x0005ea000c92184cULL, 0x000000a000002947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004ea20000002700ULL, 0x000000085d007c0cULL, 0x000fe2000bf03070ULL,
0x0000000404037824ULL, 0x004fc400078e020fULL, 0x00000008ff047e24ULL, 0x000fe4000f8e00ffULL,
0x0000000203037824ULL, 0x000fe400078e00ffULL, 0x0000000404077824ULL, 0x000fe400078e020fULL,
0x0000640003037a24ULL, 0x000fc600078e0204ULL, 0x00010a8007077811ULL, 0x000fe200078e10ffULL,
0x0000600003047625ULL, 0x000fca00078e000dULL, 0x0000000004077faeULL, 0x0005e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0c00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000c08037981ULL, 0x004528000c1e9900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000ffff057224ULL, 0x002fe200078e000bULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000008a000000947ULL, 0x000fea0003800000ULL,
0x00000000000b7919ULL, 0x004e620000000000ULL, 0x00010a8008077891ULL, 0x000fe2000f8e203fULL,
0x000000055f047c17ULL, 0x000fe2000f800000ULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe4000f8e683fULL, 0x8000000504047c10ULL, 0x000fe4000fffe0ffULL,
0x00000002ff137819ULL, 0x002fe2000001160bULL, 0x000000100b117824ULL, 0x040fe200078e00ffULL,
0x0000000b0b087211ULL, 0x000fc400078fe8ffULL, 0x000000041300720cULL, 0x000fe20003f06070ULL,
0x0106000613097984ULL, 0x000e620008004800ULL, 0x00000040000e7824ULL, 0x000fe200078e0213ULL,
0x0000003011117812ULL, 0x000fe400078ec0ffULL, 0x00000003080c7812ULL, 0x000fe200078ec0ffULL,
0x0000000709097984ULL, 0x002e640008004800ULL, 0x0000000409067c24ULL, 0x002fc8000f8e020eULL,
0x00005e0006067625ULL, 0x000fca00078e0015ULL, 0x0000001106087210ULL, 0x000fe40007f3e0ffULL,
0x0ffffffc0c067812ULL, 0x000fe400078ef80bULL, 0x00000008130b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000080e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x01062006130f7984ULL, 0x000ea20008004800ULL,
0x0000001013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000100e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x01064006130f7984ULL, 0x000ea20008004800ULL,
0x00000018130b7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000180e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x01066006130f7984ULL, 0x000ea20008004800ULL,
0x0000002013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000200e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x01068006130f7984ULL, 0x000ea20008004800ULL,
0x00000028130b7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000280e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c4cULL, 0x000000040b00720cULL, 0x040fe20003f06070ULL,
0x000000040b0b7824ULL, 0x000fe400078e00ffULL, 0x0106a006130f7984ULL, 0x000ea20008004800ULL,
0x0000003013097810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x00000011060a7210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc0b067812ULL, 0x000fc600078ee20cULL,
0x000000ffff0b7224ULL, 0x000fe200008e0607ULL, 0x00000009060d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000300e067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c4cULL, 0x000000040900720cULL, 0x040fe20003f06070ULL,
0x0000000409097824ULL, 0x000fe400078e00ffULL, 0x0106c006130f7984ULL, 0x000ea20008004800ULL,
0x00000038130d7810ULL, 0x002fc60007ffe0ffULL, 0x000000070f0f7984ULL, 0x004e640008004800ULL,
0x000000040f067c24ULL, 0x002fc8000f8e0206ULL, 0x00005e0006067625ULL, 0x000fca00078e0015ULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x00000009060b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000380e077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c4cULL, 0x000000040d00720cULL, 0x040fe20003f06070ULL,
0x000000040d0d7824ULL, 0x000fe400078e00ffULL, 0x0106e006130a7984ULL, 0x000ea60008004800ULL,
0xfffffffc0d0c7812ULL, 0x000fc800078ee20cULL, 0x000000090c097c11ULL, 0x002fe2000f8e20ffULL,
0x000000070a0a7984ULL, 0x004e640008004800ULL, 0x000000040a077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0015ULL, 0x0000001106067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c4cULL, 0x000007f000007947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x004e620000000000ULL, 0x00010a8008077891ULL, 0x000fe2000f8e203fULL,
0x00000100ff117424ULL, 0x000fe200078e00ffULL, 0x0000200008097891ULL, 0x000fe2000f8e683fULL,
0x00000002ff0d7819ULL, 0x002fe20000011609ULL, 0x00000010090a7824ULL, 0x040fe200078e00ffULL,
0x0000000909087211ULL, 0x000fc600078fe8ffULL, 0x010600060d047984ULL, 0x000e620008004800ULL,
0x00000040000f7824ULL, 0x000fe200078e020dULL, 0x000000300a137812ULL, 0x000fe400078ec0ffULL,
0x00000003080c7812ULL, 0x000fe400078ec0ffULL, 0x000000080d0a7810ULL, 0x000fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x002e640008004800ULL,
0x0000000404067c24ULL, 0x002fe2000f8e020fULL, 0x0ffffffc0c047812ULL, 0x000fc600078ef809ULL,
0x00005e0006067625ULL, 0x000fe200078e0011ULL, 0x0000000904157c11ULL, 0x000fc8000f8e20ffULL,
0x0000001306087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x000000080f077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x010620060d047984ULL, 0x000ea20008004800ULL,
0x000000100d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000100f077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e8000b901c4cULL,
0x010640060d047984ULL, 0x000ea20008004800ULL, 0x000000180d0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000906157c11ULL, 0x000fe4000f8e20ffULL,
0x000000180f077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x010660060d047984ULL, 0x000ea20008004800ULL,
0x000000200d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000200f077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e8000b901c4cULL,
0x010680060d047984ULL, 0x000ea20008004800ULL, 0x000000280d0a7810ULL, 0x002fca0007ffe0ffULL,
0x000000040a0b7824ULL, 0x000fe200078e00ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0000000906157c11ULL, 0x000fe4000f8e20ffULL,
0x000000280f077810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008157faeULL, 0x0003e8000b901c4cULL, 0x0106a0060d047984ULL, 0x000ea20008004800ULL,
0x000000300d087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000704047984ULL, 0x004e640008004800ULL, 0x0000000404067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc0b067812ULL, 0x000fc600078ee20cULL, 0x000000ffff0b7224ULL, 0x000fe200000e0607ULL,
0x0000000906157c11ULL, 0x000fe4000f8e20ffULL, 0x000000300f077810ULL, 0x040fe40007ffe0ffULL,
0x000000380f0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e8000b901c4cULL, 0x0106c0060d047984ULL, 0x000ea20008004800ULL,
0x000000380d0a7810ULL, 0x002fc60007ffe0ffULL, 0x0000000704047984ULL, 0x004e640008004800ULL,
0x0000000404067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09067812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x00000009060b7c11ULL, 0x000fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c4cULL,
0x0106e0060d047984ULL, 0x000ea80008004800ULL, 0x0000000704047984ULL, 0x004ea40008004800ULL,
0x0000000404067c24ULL, 0x004fc4000f8e020fULL, 0x000000040a0f7824ULL, 0x000fe400078e00ffULL,
0x00005e0006067625ULL, 0x000fc600078e0011ULL, 0xfffffffc0f0c7812ULL, 0x000fe400078ee20cULL,
0x0000001306067210ULL, 0x000fe40007f1e0ffULL, 0x000000090c097c11ULL, 0x002fc6000f8e20ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e6000b901c4cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x010ad400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00000008ff057e24ULL, 0x000fc8000f8e00ffULL,
0x0000002005047824ULL, 0x002fca00078e0204ULL, 0x00000003ff067819ULL, 0x000fe40000011604ULL,
0x0000000f04047812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000000104067810ULL, 0x040fe20007ffe0ffULL, 0x00000020040a7824ULL, 0x040fe400078e00ffULL,
0x0000000104087824ULL, 0x040fe400078e0207ULL, 0x0000000107097824ULL, 0x040fe200078e0206ULL,
0x0000001007077810ULL, 0x000fe20007ffe0ffULL, 0x00000020040b7824ULL, 0x000fe200078e00ffULL,
0x0000001f08087812ULL, 0x000fc400078ec0ffULL, 0x0000001f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000001e00b087812ULL, 0x040fe400078ee208ULL,
0x000001e00a097812ULL, 0x000fe200078ee209ULL, 0x00000001040a7824ULL, 0x000fe200078e0207ULL,
0x0000001f06067812ULL, 0x000fe200078ec0ffULL, 0x0000000008107984ULL, 0x000e62000000cc00ULL,
0x0000002004077824ULL, 0x000fe400078e00ffULL, 0x0000001f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000ea2000000cc00ULL, 0x000001e00b067812ULL, 0x000fc400078ee206ULL,
0x000001e0070a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001408007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001809007388ULL, 0x000fe8000000cc00ULL, 0x00000000060c7984ULL, 0x000e68000000cc00ULL,
0x000000000a107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0a007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff067f8cULL, 0x002e62000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0d7224ULL, 0x002fc400078e0007ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011409ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000204047819ULL, 0x000fc80000001209ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6000720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x3d80000003037820ULL, 0x010fe20000410000ULL, 0x00010b5805557811ULL, 0x040fe200078e18ffULL,
0x000000ffff537224ULL, 0x000fe200078e00ffULL, 0xffffffff60547810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x00010ad805527811ULL, 0x000fe200078e28ffULL,
0x00000008ff087e24ULL, 0x000fe4000f8e00ffULL, 0x0000004007077824ULL, 0x000fc400078e00ffULL,
0x00000005535a7c11ULL, 0x000fe2000f8e40ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x0000005a5f00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff5c7424ULL, 0x000fe200078e00ffULL, 0x000000535e00720cULL, 0x000fe20003f44070ULL,
0x000000ffff597224ULL, 0x000fc600078e00ffULL, 0x000000015c5c7807ULL, 0x000fc40005000000ULL,
0x000000ffff187224ULL, 0x000fe200078e0006ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0059ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff617224ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fc4000001ff00ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000237f007947ULL, 0x000fea000b800000ULL, 0x00019f7000207802ULL, 0x000fc40000000f00ULL,
0x0000531000007944ULL, 0x002fea0003c00000ULL, 0x0000000161647810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000005964067211ULL, 0x040fe200078ff0ffULL,
0x0000104000007945ULL, 0x000fe20003800000ULL, 0x0000000364657812ULL, 0x000fe400078ec0ffULL,
0x00000003061a7812ULL, 0x000fe400078ec0ffULL, 0x00000002ff06a819ULL, 0x000fe40000011606ULL,
0x000000ff1a1a7207ULL, 0x000fc60005000000ULL, 0x0000000106197824ULL, 0x000fe200078e0253ULL,
0x0000000118067812ULL, 0x000fc800078e0cffULL, 0x00000001191b7810ULL, 0x000fc80007ffe0ffULL,
0x000000601b00720cULL, 0x000fda0003f06070ULL, 0x0000083000008947ULL, 0x000fea0003800000ULL,
0x00000002ff257819ULL, 0x002fe20000011604ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000519247c11ULL, 0x000fe2000f8e40ffULL, 0x0000000465217824ULL, 0x000fe200078e00ffULL,
0x0000000404277211ULL, 0x000fe200078fe8ffULL, 0x0106000625207984ULL, 0x000e620008004800ULL,
0x000000245f1b7217ULL, 0x000fe20007800000ULL, 0x0000004000667824ULL, 0x000fe200078e0225ULL,
0x0000000327277812ULL, 0x000fe200078ec0ffULL, 0x0000000205627824ULL, 0x000fe200078e0206ULL,
0x0000000825697810ULL, 0x000fe20007ffe0ffULL, 0x000000011b247824ULL, 0x000fe200078e0a24ULL,
0xfffffffc211b7812ULL, 0x000fe200078ee204ULL, 0x00000100ff267424ULL, 0x000fe200078e00ffULL,
0x0000200062627811ULL, 0x000fe200078e60ffULL, 0x0000000469687824ULL, 0x000fe200078e00ffULL,
0x000000242500720cULL, 0x000fc40003f06070ULL, 0x0ffffffc27637812ULL, 0x000fe400078ef804ULL,
0x0000000866237810ULL, 0x000fc60007ffe0ffULL, 0x0000001063637824ULL, 0x000fe200078e0262ULL,
0x0000000420207984ULL, 0x002e640008004800ULL, 0x0000002007217224ULL, 0x002fc800078e0266ULL,
0x00005e0021207625ULL, 0x000fcc00078e0026ULL, 0x000000101b207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020637faeULL, 0x0003e2000c101c4cULL,
0x000000246900720cULL, 0x000fe40003f06070ULL, 0xfffffffc68697812ULL, 0x000fe200078ee227ULL,
0x0106200625677984ULL, 0x000ea80008004800ULL, 0x0000001069697824ULL, 0x000fe200078e0262ULL,
0x0000001066217810ULL, 0x002fe20007ffe0ffULL, 0x0000000467227984ULL, 0x0042a40008004800ULL,
0x0000001025677810ULL, 0x002fca0007ffe0ffULL, 0x0000000467687824ULL, 0x000fe400078e00ffULL,
0x0000002207237224ULL, 0x004fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e0026ULL,
0x000000101b227825ULL, 0x000fca00078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022697faeULL, 0x0003e2000c101c4cULL, 0x000000246700720cULL, 0x000fe40003f06070ULL,
0xfffffffc68677812ULL, 0x000fe200078ee227ULL, 0x0106400625637984ULL, 0x000ea80008004800ULL,
0x0000001067677824ULL, 0x000fe200078e0262ULL, 0x0000001866237810ULL, 0x002fe40007ffe0ffULL,
0x0000001825697810ULL, 0x000fca0007ffe0ffULL, 0x0000000469687824ULL, 0x000fe200078e00ffULL,
0x0000000463207984ULL, 0x004e640008004800ULL, 0x0000002007217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0026ULL, 0x000000101b207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x0003e2000c101c4cULL,
0x000000246900720cULL, 0x000fe40003f06070ULL, 0xfffffffc68697812ULL, 0x000fe200078ee227ULL,
0x0106600625637984ULL, 0x000ea80008004800ULL, 0x0000001069697824ULL, 0x000fe200078e0262ULL,
0x0000002066217810ULL, 0x002fe40007ffe0ffULL, 0x0000002025677810ULL, 0x000fca0007ffe0ffULL,
0x0000000467687824ULL, 0x000fe200078e00ffULL, 0x0000000463227984ULL, 0x004e640008004800ULL,
0x0000002207237224ULL, 0x002fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e0026ULL,
0x000000101b227825ULL, 0x000fca00078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022697faeULL, 0x0003e2000c101c4cULL, 0x000000246700720cULL, 0x000fe40003f06070ULL,
0xfffffffc68677812ULL, 0x000fe200078ee227ULL, 0x0106800625637984ULL, 0x000ea80008004800ULL,
0x0000001067677824ULL, 0x000fe200078e0262ULL, 0x0000002866237810ULL, 0x002fe40007ffe0ffULL,
0x0000002825697810ULL, 0x000fca0007ffe0ffULL, 0x0000000469687824ULL, 0x000fe200078e00ffULL,
0x0000000463207984ULL, 0x004e640008004800ULL, 0x0000002007217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0026ULL, 0x000000101b207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x0003e2000c101c4cULL,
0x000000246900720cULL, 0x000fe40003f06070ULL, 0xfffffffc68697812ULL, 0x000fe200078ee227ULL,
0x0106a00625637984ULL, 0x000ea80008004800ULL, 0x0000001069697824ULL, 0x000fe200078e0262ULL,
0x0000003066217810ULL, 0x002fe40007ffe0ffULL, 0x0000003025677810ULL, 0x000fca0007ffe0ffULL,
0x0000000467687824ULL, 0x000fe200078e00ffULL, 0x0000000463227984ULL, 0x004e640008004800ULL,
0x0000002207237224ULL, 0x002fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e0026ULL,
0x000000101b227825ULL, 0x000fca00078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022697faeULL, 0x0003e2000c101c4cULL, 0x000000246700720cULL, 0x000fe40003f06070ULL,
0xfffffffc68677812ULL, 0x000fe200078ee227ULL, 0x0106c00625637984ULL, 0x000ea80008004800ULL,
0x0000001067677824ULL, 0x000fe200078e0262ULL, 0x0000003866237810ULL, 0x002fe40007ffe0ffULL,
0x0000003825697810ULL, 0x000fca0007ffe0ffULL, 0x0000000469667824ULL, 0x000fca00078e00ffULL,
0xfffffffc66277812ULL, 0x000fca00078ee227ULL, 0x0000001027277824ULL, 0x000fe200078e0262ULL,
0x0000000463207984ULL, 0x004e640008004800ULL, 0x0000002007217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0026ULL, 0x000000101b207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x0003e2000c101c4cULL,
0x000000246900720cULL, 0x000fc60003f06070ULL, 0x0106e00625637984ULL, 0x000ea80008004800ULL,
0x0000000463227984ULL, 0x004ea40008004800ULL, 0x0000002207237224ULL, 0x004fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0026ULL, 0x000000101b227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022277faeULL, 0x0003e2000c101c4cULL,
0x0000077000007947ULL, 0x000fea0003800000ULL, 0x00000002ff257819ULL, 0x002fe20000011604ULL,
0x00010a8008047891ULL, 0x000fe2000f8e203fULL, 0x00000004041b7211ULL, 0x000fe200078fe8ffULL,
0x0000000465237824ULL, 0x000fe200078e00ffULL, 0x0000000825667810ULL, 0x000fe20007ffe0ffULL,
0x0106000625277984ULL, 0x000e620008004800ULL, 0x0000004000267824ULL, 0x000fe200078e0225ULL,
0x000000031b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000205247824ULL, 0x000fe200078e0206ULL,
0xfffffffc23237812ULL, 0x000fe200078ee204ULL, 0x00000100ff227424ULL, 0x000fc400078e00ffULL,
0x0000000466667824ULL, 0x000fe200078e00ffULL, 0x0000200024247811ULL, 0x000fc800078e60ffULL,
0xfffffffc66677812ULL, 0x000fca00078ee21bULL, 0x00000010676b7824ULL, 0x000fe200078e0224ULL,
0x0000000427277984ULL, 0x002e640008004800ULL, 0x0000002707217224ULL, 0x002fe200078e0226ULL,
0x0ffffffc1b277812ULL, 0x000fc600078ef804ULL, 0x00005e0021207625ULL, 0x000fc800078e0022ULL,
0x0000001027697824ULL, 0x000fe400078e0224ULL, 0x0000001023627825ULL, 0x000fe200078e0020ULL,
0x0000000826217810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e8000b901c4cULL, 0x0106200625277984ULL, 0x000ea80008004800ULL,
0x0000000427207984ULL, 0x004ea40008004800ULL, 0x0000002007217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023667825ULL, 0x000fe200078e0020ULL,
0x0000001026217810ULL, 0x000fe40007ffe0ffULL, 0x0000001025207810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000666b7faeULL, 0x0005e6000b901c4cULL,
0x0000000420627824ULL, 0x002fe200078e00ffULL, 0x0106400625687984ULL, 0x000e680008004800ULL,
0xfffffffc62277812ULL, 0x000fc400078ee21bULL, 0x0000001825667810ULL, 0x004fc60007ffe0ffULL,
0x0000001027697824ULL, 0x000fe400078e0224ULL, 0x0000000466667824ULL, 0x000fca00078e00ffULL,
0xfffffffc66677812ULL, 0x000fca00078ee21bULL, 0x00000010676b7824ULL, 0x000fe200078e0224ULL,
0x0000000468687984ULL, 0x002e640008004800ULL, 0x0000006807217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023627825ULL, 0x000fe200078e0020ULL,
0x0000001826217810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e8000b901c4cULL, 0x0106600625277984ULL, 0x000ea80008004800ULL,
0x0000000427207984ULL, 0x004ea40008004800ULL, 0x0000002007217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023667825ULL, 0x000fe200078e0020ULL,
0x0000002026217810ULL, 0x000fe40007ffe0ffULL, 0x0000002025207810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000666b7faeULL, 0x0005e6000b901c4cULL,
0x0000000420627824ULL, 0x002fe200078e00ffULL, 0x0106800625687984ULL, 0x000e680008004800ULL,
0xfffffffc62277812ULL, 0x000fc400078ee21bULL, 0x0000002825667810ULL, 0x004fc60007ffe0ffULL,
0x0000001027697824ULL, 0x000fe400078e0224ULL, 0x0000000466667824ULL, 0x000fca00078e00ffULL,
0xfffffffc66677812ULL, 0x000fca00078ee21bULL, 0x00000010676b7824ULL, 0x000fe200078e0224ULL,
0x0000000468687984ULL, 0x002e640008004800ULL, 0x0000006807217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023627825ULL, 0x000fe200078e0020ULL,
0x0000002826217810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e8000b901c4cULL, 0x0106a00625277984ULL, 0x000ea80008004800ULL,
0x0000000427207984ULL, 0x004ea40008004800ULL, 0x0000002007217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023667825ULL, 0x000fe200078e0020ULL,
0x0000003026217810ULL, 0x000fe40007ffe0ffULL, 0x0000003025207810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000666b7faeULL, 0x0005e6000b901c4cULL,
0x0000000420687824ULL, 0x000fe200078e00ffULL, 0x0106c00625627984ULL, 0x002e680008004800ULL,
0xfffffffc68277812ULL, 0x000fca00078ee21bULL, 0x0000001027697824ULL, 0x000fe200078e0224ULL,
0x0000003826277810ULL, 0x000fe40007ffe0ffULL, 0x0000003825267810ULL, 0x000fe20007ffe0ffULL,
0x0000000462627984ULL, 0x002e640008004800ULL, 0x0000006207217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0022ULL, 0x0000001023207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020697faeULL, 0x0005e8000b901c4cULL,
0x0106e00625637984ULL, 0x000e680008004800ULL, 0x0000000463627984ULL, 0x002e640008004800ULL,
0x0000006207277224ULL, 0x002fc400078e0227ULL, 0x0000000426627824ULL, 0x000fe400078e00ffULL,
0x00005e0027267625ULL, 0x000fc600078e0022ULL, 0xfffffffc621b7812ULL, 0x000fc600078ee21bULL,
0x0000001023267825ULL, 0x000fc800078e0026ULL, 0x000000101b1b7824ULL, 0x000fca00078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000261b7faeULL, 0x0005e4000b901c4cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001b02000207802ULL, 0x006fc40000000f00ULL, 0x0000426000007944ULL, 0x000fea0003c00000ULL,
0x000000036500780cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000031000007945ULL, 0x000fec0003800000ULL, 0x000002f000000947ULL, 0x000fea0003800000ULL,
0x000000011a1b7810ULL, 0x004fe20007ffe0ffULL, 0x00000004ff237424ULL, 0x002fe200078e00ffULL,
0x000000195e00720cULL, 0x000fe20003f04070ULL, 0x0000026000017945ULL, 0x000fe20003800000ULL,
0x00000002ff207819ULL, 0x000fc4000001161bULL, 0x000000031b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000120207807ULL, 0x000fe40004000000ULL, 0x000000ff1b1b7207ULL, 0x000fe40004000000ULL,
0x0000002004267810ULL, 0x000fe20007ffe0ffULL, 0x0000000119207824ULL, 0x000fe200078e0220ULL,
0x000000195e00720cULL, 0x000fe40003f04070ULL, 0x000000031a00780cULL, 0x000fc40003f85270ULL,
0x0000000520217c11ULL, 0x000fe4000f8e40ffULL, 0x0000000a1b207c10ULL, 0x000fe4000fffe0ffULL,
0x0000000604257c11ULL, 0x000fe2000f8e10ffULL, 0x0000000121227824ULL, 0x000fe400078e0204ULL,
0x0000000126247824ULL, 0x100fe400078e0221ULL, 0x0000680020217a24ULL, 0x000fe200078e0221ULL,
0x0000005f2200720cULL, 0x000fc40003f26070ULL, 0x0000005f2400720cULL, 0x000fe20003f66070ULL,
0x00000001211a7824ULL, 0x000fe400078e0204ULL, 0x0000000126227824ULL, 0x000fe400078e0221ULL,
0x000066001a1a7625ULL, 0x000fc800078e0023ULL, 0x0000660022227625ULL, 0x000fe200078e0023ULL,
0x0000010000008947ULL, 0x000fea0002000000ULL, 0x000000030400780cULL, 0x000fe40003f04070ULL,
0x0000000408087810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000e620000002700ULL, 0x0000005d0800720cULL, 0x000fe20003f06070ULL,
0x0000000405247824ULL, 0x100fe400078e0204ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000419197824ULL, 0x002fc800078e0204ULL, 0x0000000219197824ULL, 0x000fc800078e00ffULL,
0x0000640019207a24ULL, 0x000fe200078e0208ULL, 0x00010a8024197811ULL, 0x000fc600078e10ffULL,
0x0000600020207625ULL, 0x000fca00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020197faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x106000001a257faeULL, 0x0005e8000c92184cULL,
0x1068000022257faeULL, 0x0005e4000d92184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002004657810ULL, 0x040fe20007ffe0ffULL,
0x0000000205667824ULL, 0x004fe200078e0218ULL, 0xfffffff804637812ULL, 0x040fe200078ec0ffULL,
0x000000ffff627224ULL, 0x000fe200078e00ffULL, 0xfffffff865657812ULL, 0x000fe400078ec0ffULL,
0x0000000704677812ULL, 0x002fc400078ec0ffULL, 0x0000000763637812ULL, 0x100fe400078ef804ULL,
0x0000000765657812ULL, 0x100fe400078ef804ULL, 0x0000200066667811ULL, 0x000fe400078e60ffULL,
0x0000000867677812ULL, 0x000fe400078ef804ULL, 0x00000001ff6b7819ULL, 0x000fe40000011663ULL,
0x00000001ff6d7819ULL, 0x000fc60000011665ULL, 0x000000016b187824ULL, 0x020fe200078e0262ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000463197824ULL, 0x000fc400078e00ffULL,
0x00000004619d7824ULL, 0x000fe400078e0262ULL, 0x00000004656f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc19197812ULL, 0x000fe200078ee218ULL, 0x000000016d187824ULL, 0x000fe400078e0262ULL,
0x000000029d9d7824ULL, 0x000fe400078e00ffULL, 0x0000001019207824ULL, 0x000fe400078e0266ULL,
0x0000000465197824ULL, 0x000fc800078e00ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0xfffffffc19197812ULL, 0x000fca00078ee218ULL, 0x0000001019197824ULL, 0x000fcc00078e0266ULL,
0x000000001918783bULL, 0x000ea20000000200ULL, 0x00000018ff737819ULL, 0x002fe20000011420ULL,
0x0001000020247824ULL, 0x040fe200078e00ffULL, 0x00008880209a7816ULL, 0x040fe200000000ffULL,
0x0000010020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011421ULL,
0x0001000021257824ULL, 0x040fe200078e00ffULL, 0x0000888021987816ULL, 0x040fe200000000ffULL,
0x0000010021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff947819ULL, 0x000fc40000011422ULL,
0x0000888022967816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff847819ULL, 0x000fe20000011423ULL, 0x00000020009c7306ULL, 0x0002e20000200c00ULL,
0x0000888023827816ULL, 0x000fe400000000ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff697819ULL, 0x004fe20000011418ULL,
0x0000002100817306ULL, 0x0005e20000200c00ULL, 0x0001000022207824ULL, 0x002fe200078e00ffULL,
0x0000888018687816ULL, 0x000fe200000000ffULL, 0x0000010022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe40000011419ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0001000023217824ULL, 0x044fe200078e00ffULL,
0x00000024009b7306ULL, 0x0003e20000200c00ULL, 0x0000010023237824ULL, 0x000fe200078e00ffULL,
0x00008880198d7816ULL, 0x000fc400000000ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000002200957306ULL, 0x0005e20000200c00ULL,
0x0000000463247824ULL, 0x002fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe4000001141aULL,
0x00000018ff757819ULL, 0x000fe4000001141bULL, 0x000088801a8b7816ULL, 0x000fc400000000ffULL,
0x0000002100937306ULL, 0x0003e20000200c00ULL, 0x0000000162227810ULL, 0x044fe40007ffe0ffULL,
0x000088801b877816ULL, 0x000fe400000000ffULL, 0x0000000262627810ULL, 0x000fc60007ffe0ffULL,
0x0000002300917306ULL, 0x0005e20000200c00ULL, 0x000000016b217824ULL, 0x102fe200078e0222ULL,
0x000000046200780cULL, 0x000fe20003f05270ULL, 0x000000016d227824ULL, 0x000fca00078e0222ULL,
0x0000002500997306ULL, 0x0003e20000200c00ULL, 0xfffffffc24237812ULL, 0x004fe200078ee221ULL,
0x0001000019217824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f6f7812ULL, 0x000fe200078ee222ULL,
0x0000010019197824ULL, 0x000fe400078e00ffULL, 0x0000001023237824ULL, 0x000fe200078e0266ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000002000977306ULL, 0x0005e20000200c00ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x000000002324783bULL, 0x002e6a0000000200ULL,
0x00000019008e7306ULL, 0x0009e20000200c00ULL, 0x0001000018207824ULL, 0x004fc400078e00ffULL,
0x0000010018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000100001b197824ULL, 0x050fe200078e00ffULL,
0x00000020008f7306ULL, 0x0005e20000200c00ULL, 0x000001001b1b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000001800927306ULL, 0x0009e20000200c00ULL, 0x000000106f207824ULL, 0x004fce00078e0266ULL,
0x0000001900887306ULL, 0x0005e20000200c00ULL, 0x000100001a187824ULL, 0x050fe400078e00ffULL,
0x000001001a1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0000002067197824ULL, 0x004fe200078e00ffULL,
0x00000018008c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff7d7819ULL, 0x002fe40000011424ULL,
0x0000888024807816ULL, 0x040fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe40000011425ULL,
0x00008880257c7816ULL, 0x000fe200000000ffULL, 0x0000001a008a7306ULL, 0x000fe20000200c00ULL,
0x0001000024187824ULL, 0x044fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011426ULL,
0x0000010024247824ULL, 0x000fe200078e00ffULL, 0x0000888026797816ULL, 0x000fc400000000ffULL,
0x00000018ff837819ULL, 0x000fe40000011418ULL, 0x0000009d04187211ULL, 0x000fe200078fe0ffULL,
0x0000001b00867306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff707819ULL, 0x000fe20000011427ULL, 0x0000000167187824ULL, 0x000fe200078e0218ULL,
0x0000888027727816ULL, 0x000fe400000000ffULL, 0x000000029d9d7810ULL, 0x000fe20007ffe0ffULL,
0x0000002100907306ULL, 0x0003e20000200c00ULL, 0xffffffe019187812ULL, 0x000fe200078ee218ULL,
0x0001000025197824ULL, 0x000fc400078e00ffULL, 0x0000010025257824ULL, 0x000fe400078e00ffULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011419ULL,
0x0000009a009a7306ULL, 0x000ea20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x00000018ff257819ULL, 0x000fc60000011425ULL, 0x000000001818783bULL, 0x000f260000000200ULL,
0x00000024007e7306ULL, 0x0005f00000200c00ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0001000026247824ULL, 0x004fc400078e00ffULL, 0x0000010026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000009800987306ULL, 0x000ea20000200c00ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x00000025007b7306ULL, 0x0003f00000200c00ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x0001000027257824ULL, 0x042fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011420ULL, 0x0000010027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fc40000011421ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000009600967306ULL, 0x000e620000200c00ULL, 0x00000018ff9e7819ULL, 0x000fe40000011427ULL,
0x000054109c277816ULL, 0x008fe40000000073ULL, 0x00000018ff6c7819ULL, 0x000fe40000011422ULL,
0x00000018ff6a7819ULL, 0x000fe20000011423ULL, 0x0000002600787306ULL, 0x0007f00000200c00ULL,
0x00000024007a7306ULL, 0x0005e20000200c00ULL, 0x000054109a267816ULL, 0x008fc4000000009bULL,
0x00008880209a7816ULL, 0x000fca00000000ffULL, 0x0000002500777306ULL, 0x0007e20000200c00ULL,
0x0000541098247816ULL, 0x004fe20000000099ULL, 0x000000261840723cULL, 0x010b620000001840ULL,
0x0000002067997824ULL, 0x000fca00078e00ffULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000541081257816ULL, 0x008fe20000000076ULL, 0x000000ffff277224ULL, 0x020fe200078e009aULL,
0x0000009d04267211ULL, 0x000fe200078fe0ffULL, 0x0001000020817824ULL, 0x040fe400078e00ffULL,
0x0000010020207824ULL, 0x000fe400078e00ffULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x00000024183c723cULL, 0x000b62000000183cULL, 0x0000000167267824ULL, 0x000fe200078e0226ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0xffffffe099267812ULL, 0x000fe200078ee226ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x0000541096247816ULL, 0x022fe40000000097ULL, 0x0000541095257816ULL, 0x000fe20000000094ULL,
0x0000001026267824ULL, 0x000fc800078e00ffULL, 0x0000006800687306ULL, 0x000e640000200c00ULL,
0x000000241838723cULL, 0x000b6c0000001838ULL, 0x0000008900897306ULL, 0x000f220000200c00ULL,
0x0000541082247816ULL, 0x024fe40000000093ULL, 0x0000541091257816ULL, 0x000fe20000000084ULL,
0x0001000021917824ULL, 0x000fe200078e00ffULL, 0x0000541092697816ULL, 0x008fc40000000069ULL,
0x0000888021937816ULL, 0x000fe200000000ffULL, 0x0000008d008d7306ULL, 0x000ea20000200c00ULL,
0x0000541068687816ULL, 0x002fe2000000008fULL, 0x000000241834723cULL, 0x000b640000001834ULL,
0x000000ffff847224ULL, 0x000fc800078e0093ULL, 0x0000002700767306ULL, 0x0003e40000200c00ULL,
0x000000681830723cULL, 0x000b6c0000001830ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000000002624783bULL, 0x022e620000000200ULL, 0x0000010021687824ULL, 0x000fe200078e00ffULL,
0x000054108e217816ULL, 0x010fc40000000089ULL, 0x00000018ff697819ULL, 0x000fe40000011491ULL,
0x00000018ff897819ULL, 0x000fe20000011468ULL, 0x0000008b008b7306ULL, 0x000ee20000200c00ULL,
0x0000888022687816ULL, 0x000fce00000000ffULL, 0x0000002000827306ULL, 0x0005f00000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054108d207816ULL, 0x004fce0000000090ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x00000020182c723cULL, 0x000b6e000000182cULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054108b207816ULL, 0x028fe4000000008cULL,
0x000054108a217816ULL, 0x000fe20000000085ULL, 0x0001000022857824ULL, 0x000fc400078e00ffULL,
0x0000010022227824ULL, 0x000fe400078e00ffULL, 0x0000008000807306ULL, 0x000fe40000200c00ULL,
0x000000201828723cULL, 0x000b620000001828ULL, 0x00000018ff227819ULL, 0x000fca0000011422ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x0000541087207816ULL, 0x024fe40000000088ULL,
0x0000541086217816ULL, 0x000fca0000000075ULL, 0x0000007400747306ULL, 0x000ea40000200c00ULL,
0x00000020181c723cULL, 0x000b6c000000181cULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541080187816ULL, 0x028fe40000000083ULL, 0x000054107e197816ULL, 0x000fc4000000007dULL,
0x00008880231a7816ULL, 0x000fe400000000ffULL, 0x00000018ff1b7819ULL, 0x000fe20000011485ULL,
0x0000007f007f7306ULL, 0x000ee40000200c00ULL, 0x000000182440723cULL, 0x002b6c0000001840ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000054107b197816ULL, 0x024fce0000000074ULL,
0x0000007900797306ULL, 0x000ea20000200c00ULL, 0x000054107c187816ULL, 0x008fce000000007fULL,
0x00000018243c723cULL, 0x000b62000000183cULL, 0x0000007000707306ULL, 0x000fec0000200c00ULL,
0x000000ffff187224ULL, 0x020fe200078e001aULL, 0x0000541078197816ULL, 0x002fe20000000071ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x00010000231a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000009e00737306ULL, 0x000ef00000200c00ULL,
0x0000001800207306ULL, 0x0005f00000200c00ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541079187816ULL, 0x004fce000000007aULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000000182438723cULL, 0x000b6e0000001838ULL, 0x0000010023197824ULL, 0x020fe200078e00ffULL,
0x0000002200217306ULL, 0x0009e20000200c00ULL, 0x0000541072187816ULL, 0x002fce0000000077ULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x00000018ff227819ULL, 0x010fe40000011419ULL,
0x0000541073197816ULL, 0x008fca0000000070ULL, 0x0000006900697306ULL, 0x000e640000200c00ULL,
0x000000182434723cULL, 0x000b6c0000001834ULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x0000541076187816ULL, 0x024fe40000000081ULL, 0x0000541082197816ULL, 0x000fca000000006fULL,
0x0000006e006e7306ULL, 0x000fe40000200c00ULL, 0x000000182430723cULL, 0x000b6c0000001830ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541084187816ULL, 0x022fe40000000069ULL,
0x0000541021697816ULL, 0x008fca000000006cULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000006800687306ULL, 0x000ff00000200c00ULL, 0x0000001b001b7306ULL, 0x000ea20000200c00ULL,
0x0000541089197816ULL, 0x002fce000000006eULL, 0x0000001a00237306ULL, 0x000e620000200c00ULL,
0x00000018242c723cULL, 0x000b6e000000182cULL, 0x0000002200717306ULL, 0x000ee20000200c00ULL,
0x0000541068687816ULL, 0x004fe4000000001bULL, 0x0000541020207816ULL, 0x002fca0000000023ULL,
0x000000682428723cULL, 0x000b620000001828ULL, 0x0000541071217816ULL, 0x008fce000000006aULL,
0x00000020241c723cULL, 0x000b62000000181cULL, 0xfffff05000000947ULL, 0x000fce000383ffffULL,
0x000000046400780cULL, 0x000fe20003f06070ULL, 0x000000ffff617224ULL, 0x000fe400078e0064ULL,
0x000000ffff187224ULL, 0x020fd400078e0006ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdb0000007947ULL, 0x000fea000383ffffULL, 0x00000002ff647819ULL, 0x000fc80000011604ULL,
0x000000596400720cULL, 0x040fe40003f06070ULL, 0x0000000159597810ULL, 0x000fe40007ffe0ffULL,
0x0000000864627810ULL, 0x040fe40007ffe0ffULL, 0x000000596400720cULL, 0x000fe40004706470ULL,
0x0000005b6200720cULL, 0x000fe40003f26070ULL, 0x000000535e00720cULL, 0x000fc40000703070ULL,
0x000000596200720cULL, 0x000fc80000f21070ULL, 0x000000535e00720cULL, 0x000fc80000f24470ULL,
0x000000581f587208ULL, 0x000fe40000800000ULL, 0x000000171e177208ULL, 0x000fe20000800000ULL,
0x000000ffff578224ULL, 0x000fe200078e001dULL, 0x000000442b447208ULL, 0x000fe20000800000ULL,
0x000000ffff568224ULL, 0x000fe200078e001cULL, 0x000000452a457208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0029ULL, 0x000000462f467208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e0028ULL, 0x000000472e477208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e002dULL, 0x0000004833487208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e002cULL, 0x0000004932497208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e0031ULL, 0x0000004a374a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e0030ULL, 0x0000004b364b7208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0035ULL, 0x0000004c3b4c7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0034ULL, 0x0000004d3a4d7208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0039ULL, 0x0000004e3f4e7208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0038ULL, 0x0000004f3e4f7208ULL, 0x000fe20000800000ULL,
0x000000ffff148224ULL, 0x000fe200078e003dULL, 0x0000005043507208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e003cULL, 0x0000005142517208ULL, 0x000fe20000800000ULL,
0x000000ffff168224ULL, 0x000fc400078e0041ULL, 0x000000ffff158224ULL, 0x000fe200078e0040ULL,
0x0000005c5900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd71000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000055187f8cULL, 0x000e62000c80043fULL, 0x0000000315157220ULL, 0x080fe20000410000ULL,
0x0000000316167220ULL, 0x080fe20000410000ULL, 0x0000000313137220ULL, 0x080fe20000410000ULL,
0x0000000314147220ULL, 0x080fe20000410000ULL, 0x0000000311117220ULL, 0x080fe20000410000ULL,
0x0000000312127220ULL, 0x080fe20000410000ULL, 0x000000030f227220ULL, 0x080fe20000410000ULL,
0x0000000310107220ULL, 0x080fe20000410000ULL, 0x000000030d217220ULL, 0x080fe20000410000ULL,
0x000000030e207220ULL, 0x080fe20000410000ULL, 0x000000030b0b7220ULL, 0x080fe20000410000ULL,
0x000000030c1f7220ULL, 0x080fe20000410000ULL, 0x0000000309097220ULL, 0x080fe20000410000ULL,
0x000000030a0a7220ULL, 0x080fe20000410000ULL, 0x00000003561e7220ULL, 0x080fe20000410000ULL,
0x00000003571d7220ULL, 0x080fe20000410000ULL, 0x0000000351327220ULL, 0x080fe20000410000ULL,
0x00000003502f7220ULL, 0x080fe20000410000ULL, 0x000000034f2e7220ULL, 0x080fe20000410000ULL,
0x000000034e2d7220ULL, 0x080fe20000410000ULL, 0x000000034d2c7220ULL, 0x080fe20000410000ULL,
0x000000034c2b7220ULL, 0x080fe20000410000ULL, 0x000000034b2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff1b7224ULL, 0x002fe200078e0019ULL, 0x000000034a297220ULL, 0x080fe20000410000ULL,
0x0000000349287220ULL, 0x080fe20000410000ULL, 0x0000000348277220ULL, 0x080fe20000410000ULL,
0x0000000347267220ULL, 0x080fe20000410000ULL, 0x0000000346257220ULL, 0x080fe20000410000ULL,
0x0000000345247220ULL, 0x080fe20000410000ULL, 0x0000000344237220ULL, 0x080fe20000410000ULL,
0x0000000317177220ULL, 0x080fe20000410000ULL, 0x00000003581c7220ULL, 0x000fc20000410000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x00000400550e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000780481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c197210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000190e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400550e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004041b7824ULL, 0x000fe200078e00ffULL,
0x000000545300720cULL, 0x000fc80003f05270ULL, 0xfffffff01b307812ULL, 0x000fca00078ec0ffULL,
0x0000008005307824ULL, 0x000fca00078e0230ULL, 0x01040000300c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000204187824ULL, 0x000fe400078e00ffULL,
0x000000015f5a7824ULL, 0x000fc600078e0a5aULL, 0x0000000618197812ULL, 0x000fc800078ec0ffULL,
0x0000000119317812ULL, 0x040fe400078efcffULL, 0x0000000819337812ULL, 0x000fe400078efcffULL,
0x0000005a3100720cULL, 0x080fe40003f26070ULL, 0x0000001019317812ULL, 0x000fe400078efcffULL,
0x0000005a3300720cULL, 0x080fe40003f06070ULL, 0x0000005a3100720cULL, 0x000fc40003fc6070ULL,
0x0000001119337812ULL, 0x040fe400078efcffULL, 0x0000001819317812ULL, 0x040fe400078efcffULL,
0x0000005a1900720cULL, 0x080fe40003f46070ULL, 0x0000005a3300720cULL, 0x080fe40003fa6070ULL,
0x0000005a3100720cULL, 0x000fe40003f66070ULL, 0x0000000919357812ULL, 0x000fc400078efcffULL,
0x0000001919337812ULL, 0x040fe400078efcffULL, 0x0000002019317812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fc40004800000ULL,
0x0000005a3500720cULL, 0x080fe40003f86070ULL, 0x0000005a3300720cULL, 0x080fe40003f46070ULL,
0x0000005a3100720cULL, 0x000fe40003f26070ULL, 0x0000002119337812ULL, 0x040fe400078efcffULL,
0x0000002819317812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fc40004000000ULL,
0xff80000013137808ULL, 0x000fe40004000000ULL, 0xff8000002d2d7808ULL, 0x000fe40006000000ULL,
0xff80000014147808ULL, 0x000fe40006000000ULL, 0x0000005a3300720cULL, 0x080fe40003f06070ULL,
0x0000005a3100720cULL, 0x000fe40003f86070ULL, 0x0000002919337812ULL, 0x000fc400078efcffULL,
0x0000003019317812ULL, 0x000fe400078efcffULL, 0xff8000002c2c7808ULL, 0x000fe40007000000ULL,
0xff80000011117808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006800000ULL,
0xff80000012127808ULL, 0x000fe40006800000ULL, 0x0000005a3300720cULL, 0x000fc40003fc6070ULL,
0x0000005a3100720cULL, 0x000fe40003fa6070ULL, 0x0000003119337812ULL, 0x040fe400078efcffULL,
0x0000003819317812ULL, 0x040fe400078efcffULL, 0x0000003919197812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005800000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff80000010107808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0x0000005a3300720cULL, 0x080fe40003f66070ULL, 0x0000005a3100720cULL, 0x000fc40003f46070ULL,
0x0000005a1900720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff80000020207808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000000b0b7808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fc40007000000ULL,
0xff8000001f1f7808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff80000009097808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff8000000a0a7808ULL, 0x000fe40005800000ULL, 0xff80000017177808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fc40004800000ULL, 0x000000150c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x000000320d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0000000c15197208ULL, 0x000fe40004000000ULL,
0x0000000d320c7208ULL, 0x000fc40004800000ULL, 0x000000161900720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001916187208ULL, 0x000fe40004000000ULL,
0x0000000c2f0d7208ULL, 0x000fe40004800000ULL, 0x000000131800720bULL, 0x000fe40003f1e000ULL,
0x0000002e0d00720bULL, 0x000fc40003f3e000ULL, 0x0000001813197208ULL, 0x000fe40004000000ULL,
0x0000000d2e0c7208ULL, 0x000fe40004800000ULL, 0x000000141900720bULL, 0x000fe40003f1e000ULL,
0x0000002d0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001914187208ULL, 0x000fe40004000000ULL,
0x0000000c2d0d7208ULL, 0x000fc40004800000ULL, 0x000000111800720bULL, 0x000fe40003f1e000ULL,
0x0000002c0d00720bULL, 0x000fe40003f3e000ULL, 0x0000001811197208ULL, 0x000fe40004000000ULL,
0x0000000d2c0c7208ULL, 0x000fe40004800000ULL, 0x000000121900720bULL, 0x000fe40003f1e000ULL,
0x0000002b0c00720bULL, 0x000fc40003f3e000ULL, 0x0000001912197208ULL, 0x000fe40004000000ULL,
0x0000000c2b0d7208ULL, 0x000fe40004800000ULL, 0x000000221900720bULL, 0x000fe40003f1e000ULL,
0x0000002a0d00720bULL, 0x000fe40003f3e000ULL, 0x0000001922197208ULL, 0x000fe40004000000ULL,
0x0000000d2a0c7208ULL, 0x000fc40004800000ULL, 0x000000101900720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000001910187208ULL, 0x000fe40004000000ULL,
0x0000000c290d7208ULL, 0x000fe40004800000ULL, 0x000000211800720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x0000001821197208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x000000201900720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x0000001920187208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fc40004800000ULL, 0x0000000b1800720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x000000180b187208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fe40004800000ULL, 0x0000001f1800720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x000000181f187208ULL, 0x000fe40004000000ULL,
0x0000000c250d7208ULL, 0x000fe40004800000ULL, 0x000000091800720bULL, 0x000fe40003f1e000ULL,
0x000000240d00720bULL, 0x000fe40003f3e000ULL, 0x0000001809197208ULL, 0x000fe40004000000ULL,
0x0000000d240c7208ULL, 0x000fc40004800000ULL, 0x0000000a1900720bULL, 0x000fe40003f1e000ULL,
0x000000230c00720bULL, 0x000fe40003f3e000ULL, 0x000000190a197208ULL, 0x000fe40004000000ULL,
0x0000000c230c7208ULL, 0x000fe40004800000ULL, 0x0000001e1900720bULL, 0x000fe40003f1e000ULL,
0x000000170c00720bULL, 0x000fc40003f3e000ULL, 0x000000191e187208ULL, 0x000fe40004000000ULL,
0x0000000c170d7208ULL, 0x000fe40004800000ULL, 0x0000001d1800720bULL, 0x000fe40003f1e000ULL,
0x0000001c0d00720bULL, 0x000fe40003f3e000ULL, 0x000000181d337208ULL, 0x000fe40004000000ULL,
0x0000000d1c317208ULL, 0x000fe20004800000ULL, 0x000019027f007947ULL, 0x000fec000b800000ULL,
0x0c401f00330c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3300720bULL, 0x008fc80003f1e000ULL,
0x000000330c357208ULL, 0x000fe20004000000ULL, 0x000019127f007947ULL, 0x000fea000b800000ULL,
0x0c401f00310c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f187f89ULL, 0x000e6800000e0000ULL, 0x0c201f0035197f89ULL, 0x000ea200000e0000ULL,
0x0000000c3100720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x000000310c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000180f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c337f89ULL, 0x004e6600000e0000ULL,
0x0000000f18317208ULL, 0x000fe20004000000ULL, 0x0c201f000d1a7f89ULL, 0x000ea200000e0000ULL,
0x000000193500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0031347f89ULL, 0x0006e200000e0000ULL,
0x0000003519187208ULL, 0x000fe40004000000ULL, 0x000000330c00720bULL, 0x002fe40003f3e000ULL,
0x0000001a0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c33197208ULL, 0x000fe40004800000ULL,
0x0000000d1a1a7208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b19357820ULL, 0x008fe20000410000ULL,
0x3c003c00ff337424ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000864367824ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b23447823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b18237820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2e2e7823ULL, 0x000fe20000010835ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b14147823ULL, 0x000fe20000010823ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010835ULL, 0x0000003200517308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2c2c7823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010823ULL, 0x0000002f00507308ULL, 0x000fe20000000800ULL,
0x3c003c00ff327424ULL, 0x002fe200078e00ffULL, 0x3fb8aa3b220f7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b10107823ULL, 0x000fe20000010823ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010835ULL, 0x0000002e004f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b210d7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b200e7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b1f0c7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010823ULL, 0x0000002d004e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe20000010823ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe20000010835ULL, 0x00000001641f7810ULL, 0x040fe20007ffe0ffULL,
0x00000008643a7824ULL, 0x040fe200078e00ffULL, 0x0000000464357810ULL, 0x040fe20007ffe0ffULL,
0x0000000864377824ULL, 0x000fe200078e00ffULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0xfffffff836367812ULL, 0x000fe200078ee21fULL, 0x0000000864387824ULL, 0x040fe200078e00ffULL,
0x00000003641f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008643c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a397812ULL, 0x000fe200078ee235ULL, 0x0000000864357824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee21fULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x0000a00008047891ULL, 0x000fe2000f8e583fULL, 0x00000008643e7824ULL, 0x040fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee264ULL, 0x00000008643d7824ULL, 0x040fe200078e00ffULL,
0x00000006643b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008623f7824ULL, 0x000fe200078e00ffULL,
0x0000000435357c11ULL, 0x000fe2000f8e20ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0xfffffff83e3b7812ULL, 0x000fc400078ee23bULL, 0xfffffff83f627812ULL, 0x000fe400078ee262ULL,
0x0000000439397c11ULL, 0x000fe4000f8e20ffULL, 0x000000043b3b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001400147308ULL, 0x000ee20000000800ULL, 0x00000004623f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000304ff7812ULL, 0x000fe4000780c0ffULL, 0x000000343100720bULL, 0x004fc60003f3e000ULL,
0x0000002b004c7308ULL, 0x0003f00000000800ULL, 0x0000002a004b7308ULL, 0x0007e20000000800ULL,
0x0000004f4e2b723eULL, 0x002fce00000000ffULL, 0x00000029004a7308ULL, 0x0002a20000000800ULL,
0x00000013142a723eULL, 0x008fce00000000ffULL, 0x0000002800497308ULL, 0x0007e20000000800ULL,
0x000000515029723eULL, 0x002fce00000000ffULL, 0x0000002c004d7308ULL, 0x0003e20000000800ULL,
0x000000151628723eULL, 0x008fce00000000ffULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x00000032282c723cULL, 0x002f6e00000018ffULL, 0x0000001200127308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000ff00000000800ULL, 0x0000001000107308ULL, 0x000e700000000800ULL,
0x0000002700487308ULL, 0x0004f00000000800ULL, 0x0000002600477308ULL, 0x0003e20000000800ULL,
0x0000004b4a27723eULL, 0x004fce00000000ffULL, 0x0000002500467308ULL, 0x0005220000000800ULL,
0x0000000f1026723eULL, 0x002fe400000000ffULL, 0x000000494821723eULL, 0x008fca00000000ffULL,
0x0000002400457308ULL, 0x0003e20000000800ULL, 0x0000004d4c25723eULL, 0x004fce00000000ffULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x000000111224723eULL, 0x002fe400000000ffULL,
0x000000474623723eULL, 0x010fca00000000ffULL, 0x00000032242c723cULL, 0x020f62000000182cULL,
0x0000000e000e7308ULL, 0x000e700000000800ULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000000c000c7308ULL, 0x000ea20000000800ULL, 0x0000000d0e20723eULL, 0x002fce00000000ffULL,
0x0000004400447308ULL, 0x000e620000000800ULL, 0x0000000b0c22723eULL, 0x004fce00000000ffULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x00000032202c723cULL, 0x020f6e000000182cULL,
0x0000000900097308ULL, 0x000ff00000000800ULL, 0x0000000a000a7308ULL, 0x000eb00000000800ULL,
0x0000001e00567308ULL, 0x0007f00000000800ULL, 0x0000001d00577308ULL, 0x0008a20000000800ULL,
0x00000002641e7810ULL, 0x008fc80007ffe0ffULL, 0xfffffff837377812ULL, 0x000fc600078ee21eULL,
0x0000001c00587308ULL, 0x0004e20000000800ULL, 0x00000005641d7810ULL, 0x010fe40007ffe0ffULL,
0x0000000437377c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff83c3a7812ULL, 0x000fe400078ee21dULL,
0x00000045441d723eULL, 0x002fe400000000ffULL, 0x000000090a1c723eULL, 0x004fe400000000ffULL,
0x00000056571e723eULL, 0x000fc400000000ffULL, 0xffffffff643c7810ULL, 0x000fe40007ffe0ffULL,
0x00000017581f723eULL, 0x008fe400000000ffULL, 0xfffffff83d3c7812ULL, 0x000fc800078ee23cULL,
0x000000043c3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000321c2c723cULL, 0x020b6e000000182cULL,
0x0000000c1b327812ULL, 0x020fe400078ec0ffULL, 0x00000004361b7c11ULL, 0x000fc4000f8e20ffULL,
0x000000043a337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000135357824ULL, 0x000fe400078e0232ULL,
0x0000000132377824ULL, 0x040fe400078e0237ULL, 0x0000000132397824ULL, 0x040fe200078e0239ULL,
0x0000002835007388ULL, 0x0003e20000000800ULL, 0x0000000132337824ULL, 0x000fe400078e0233ULL,
0x00000004382f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001322d7824ULL, 0x000fe200078e021bULL,
0x00000031341b7208ULL, 0x000fe20004800000ULL, 0x00000001323b7824ULL, 0x000fc400078e023bULL,
0x00000001322f7824ULL, 0x040fe200078e022fULL, 0x0000002a2d007388ULL, 0x0005e20000000800ULL,
0x00000001323d7824ULL, 0x040fe400078e023dULL, 0x0000000132327824ULL, 0x000fe200078e023fULL,
0x0000002437007388ULL, 0x0005e20000000800ULL, 0x000000ffff347224ULL, 0x000fe400078e002cULL,
0x000000ffff357224ULL, 0x002fe200078e002eULL, 0x000000262f007388ULL, 0x0005e80000000800ULL,
0x0000002039007388ULL, 0x0005e80000000800ULL, 0x0000002233007388ULL, 0x0005e80000000800ULL,
0x0000001c3b007388ULL, 0x0005e80000000800ULL, 0x0000001e3d007388ULL, 0x0005e80000000800ULL,
0x0000002932007388ULL, 0x0005e80000000800ULL, 0x0004002b2d007388ULL, 0x0005e80000000800ULL,
0x0004002537007388ULL, 0x0005e80000000800ULL, 0x000400272f007388ULL, 0x0005e80000000800ULL,
0x0004002139007388ULL, 0x0005e80000000800ULL, 0x0004002333007388ULL, 0x0005e80000000800ULL,
0x0004001d3b007388ULL, 0x0005e80000000800ULL, 0x0004001f3d007388ULL, 0x0005e80000000800ULL,
0x0100001830008388ULL, 0x0005e80000000c00ULL, 0x0102003430008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000052ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080052ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100052ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000153537810ULL, 0x000fe20007ffe0ffULL,
0x0000180052ff7f8cULL, 0x0003e6000c80043fULL, 0x000000605300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbc4000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001e18000247802ULL, 0x000fc40000000f00ULL, 0x0000109000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffe534000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001e1d000247802ULL, 0x000fc40000000f00ULL,
0x0000104000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0025ULL,
0xfffe538000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0012ULL,
0x0001e23000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001dULL,
0x00000fa000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffe542000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x0001e29000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0012ULL,
0x00000f4000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffe552000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x0001e2f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e001cULL,
0x00000ee000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe56f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e001aULL,
0x0001e35000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001dULL,
0x00000e8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe56c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e3b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x00000e2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe7e3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e41000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x00000dc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe7df000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001e46000247802ULL, 0x000fc40000000f00ULL, 0x00000db000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffea97000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001e4b000247802ULL, 0x000fc40000000f00ULL,
0x00000d6000007944ULL, 0x008fea0003c00000ULL, 0xfffea9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e002aULL, 0x0001e50000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xfffeaa5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e002aULL, 0x0001e56000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000c7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xfffeab4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e5c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000c1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffead0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e62000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000bb000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffeacc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e68000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000b5000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffed23000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e6e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000af000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffed1f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x004fe40004000000ULL, 0x0001e73000247802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xfffefc6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe40004800000ULL,
0x0001e78000247802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x008fea0003c00000ULL,
0xfffefcb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e002aULL,
0x0001e7d000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x00000a0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffefd4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e002aULL,
0x0001e83000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x000009a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffefe3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e89000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x0000094000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffefff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e8f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x000008e000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffeffb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e95000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x0000088000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xffff252000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e9b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x0000082000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff24e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001ea0000247802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xffff4f5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001ea5000247802ULL, 0x000fc40000000f00ULL,
0x000007c000007944ULL, 0x008fea0003c00000ULL, 0xffff4fa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e002aULL, 0x0001eaa000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x0000073000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xffff503000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e002aULL, 0x0001eb0000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x000006d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xffff512000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001eb6000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x0000067000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff52e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ebc000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x0000061000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff52a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ec2000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x000005b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff781000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ec8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x0000055000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff77d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0003ULL, 0x0001ecd000207802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0026ULL,
0xffff8bd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001ed2000207802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0026ULL, 0xffff8cc000007947ULL, 0x000fea000383ffffULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0001ed70000c7802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0034ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x006fe200078e0031ULL,
0x0001edd0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x000000343100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e000eULL, 0x0001ee30000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0000003134197208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000340e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e000fULL, 0x0001ee90000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0000000e34377208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000340f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0035ULL, 0x0001eef0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000000f34317208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000343500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0019ULL, 0x0001ef50000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000003534187208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000341900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0037ULL, 0x0001efb0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000001934197208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000343700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0031ULL, 0x0001f010000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x00000037341a7208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffe59000007947ULL, 0x000fea000383ffffULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000f00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0fff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000f037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000f00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe0e7004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00003633347389ULL, 0x0002a200000e0038ULL,
0xfffe0e300c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000001100007348ULL, 0x000fe80003800000ULL, 0x0000002726267389ULL, 0x0002a200000e0010ULL,
0xfffe0df020007950ULL, 0x000fea0003c3ffffULL, 0x000000012000780cULL, 0x000fe20003f25070ULL,
0x0000001700007348ULL, 0x000fe80003800000ULL, 0x00000000ff217424ULL, 0x000fd000078e00ffULL,
0x0000000000207806ULL, 0x000fc800048e0100ULL, 0x0000001720257212ULL, 0x000fe200078ec0ffULL,
0x000000ffff207224ULL, 0x000fc800078e0024ULL, 0xfffe0d8020007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000000200007348ULL, 0x000fe80003800000ULL,
0xfffe0d5020007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x00000000000003c8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eacULL, 0x0000000000000c3cULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001ae8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001af8ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001ba8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bacULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001d80ULL, 0x000000000001f380ULL, 0xa100001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021100ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021150ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000214d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001ba8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001f558ULL, 0x000000000001f558ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000214d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_89_cubin_len = 136624;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
