/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000023d50ULL, 0x00000000000239d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000021820ULL, 0x0000000000000180ULL,
0x000b0022000004bdULL, 0x00000000000219a0ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x00000000000219e0ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000021a20ULL,
0x0000000000000070ULL, 0x000b00220000053dULL, 0x0000000000021a90ULL, 0x00000000000000f0ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000021b80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0002182000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x0084a00400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8a08288080820828ULL, 0x2880809308288080ULL, 0x809a082880809408ULL, 0x082880809b082880ULL,
0x8080a408288080a0ULL, 0xa708288080a60828ULL, 0x288080d608288080ULL, 0x8280162880808608ULL,
0x0000000003102880ULL, 0x8080869200000000ULL, 0x0000000000220028ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0002182000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808086ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808a08288080ULL, 0x8094082880809308ULL,
0x082880809a082880ULL, 0x8080a0082880809bULL, 0xa708288080a40828ULL, 0x288080d608288080ULL,
0x8280162880808c08ULL, 0x0000000003102880ULL, 0x80808c9200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000013800000000ULL, 0x000219a000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL,
0x2880808a08288080ULL, 0x8094082880809308ULL, 0x082880809a082880ULL, 0x8080a4082880809bULL,
0xa708288080a60828ULL, 0x288080d608288080ULL, 0x828016288080a008ULL, 0x0000000003102880ULL,
0x8080a09200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000001e800000000ULL,
0x000219e000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808a08288080ULL, 0x8094082880809308ULL,
0x082880809a082880ULL, 0x8080a0082880809bULL, 0xa708288080a60828ULL, 0x288080d608288080ULL,
0x828016288080a408ULL, 0x0000000003102880ULL, 0x8080a49200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000029800000000ULL, 0x00021a2000000000ULL, 0x0000007000000000ULL,
0x0000180400000000ULL, 0x80a0288080a40900ULL, 0x0000000000002880ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8608288080820828ULL, 0x2880808a08288080ULL, 0x8094082880809308ULL,
0x0828808099082880ULL, 0x80809b082880809aULL, 0xa408288080a00828ULL, 0x288080a608288080ULL,
0x80d608288080a708ULL, 0x162880809c082880ULL, 0x0000031028808280ULL, 0x9c92000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000035800000000ULL, 0x00021a9000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x000823040000009eULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL,
0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL,
0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL,
0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001b00082304ULL, 0x0008120400000000ULL,
0x000000000000001bULL, 0x0000001b00081104ULL, 0x0004370400000000ULL, 0x000035010000007bULL,
0x0000001800080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f00000600007ULL,
0x00000000000c1704ULL, 0x0021f00000580006ULL, 0x00000000000c1704ULL, 0x0011f00000500005ULL,
0x00000000000c1704ULL, 0x0061f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x01bc290400000030ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01bc2804ffffffffULL,
0x0000013000000100ULL, 0x0000348000000480ULL, 0x0000361000003510ULL, 0x000039a000003770ULL,
0x00003a40000039d0ULL, 0x000061f000003ab0ULL, 0x0000628000006210ULL, 0x00008e30000062f0ULL,
0x00008fb000008ec0ULL, 0x0000932000009100ULL, 0x000093b000009340ULL, 0x0000b94000009420ULL,
0x0000b9d00000b960ULL, 0x0000e4600000ba40ULL, 0x0000e5e00000e4f0ULL, 0x0000e9500000e730ULL,
0x0000e9e00000e970ULL, 0x00010f700000ea50ULL, 0x0001100000010f90ULL, 0x00013a9000011070ULL,
0x00013c1000013b20ULL, 0x00013f8000013d60ULL, 0x0001401000013fa0ULL, 0x000165a000014080ULL,
0x00016630000165c0ULL, 0x00017a40000166a0ULL, 0x0001817000017b80ULL, 0x000185e000018190ULL,
0x0001b2700001a7f0ULL, 0x0001d3900001b290ULL, 0x0001f7800001d3b0ULL, 0x0001f7d00001f7c0ULL,
0x0001f7f00001f7e0ULL, 0x0001f8700001f850ULL, 0x000204c00001f890ULL, 0x000205a000020520ULL,
0x000206a000020620ULL, 0x000207a000020720ULL, 0x0002088000020820ULL, 0x00020950000208e0ULL,
0x00020a50000209d0ULL, 0x00020b5000020ad0ULL, 0x00020c3000020bd0ULL, 0x00020d0000020c90ULL,
0x00020e0000020d80ULL, 0x00020f0000020e80ULL, 0x00020fe000020f80ULL, 0x000210b000021040ULL,
0x000211b000021130ULL, 0x000212b000021230ULL, 0x000213a000021330ULL, 0x0002148000021410ULL,
0x0002158000021500ULL, 0x0002168000021600ULL, 0x0002178000021700ULL, 0x07e0390400021800ULL,
0x000000ff00000230ULL, 0x003f010000018ad0ULL, 0x0000000b00000260ULL, 0x003f012000018ad8ULL,
0x0000000b00000360ULL, 0x003f012000018b58ULL, 0x0000000b00000390ULL, 0x003f012000018b78ULL,
0x000000ff00000430ULL, 0x003f010000018b88ULL, 0x000000ff00000500ULL, 0x003f010700018ad0ULL,
0x000000ff000007e0ULL, 0x0005010200018b5cULL, 0x000000ff00000840ULL, 0x0005010100018b58ULL,
0x000000ff000009c0ULL, 0x003f010100018b88ULL, 0x000000ff00000a00ULL, 0x003f010500018b8cULL,
0x000000ff00000bc0ULL, 0x003f010500018b8cULL, 0x000000ff000015d0ULL, 0x003f010100018b88ULL,
0x000000ff00001600ULL, 0x003f010500018b8cULL, 0x000000ff000017d0ULL, 0x003f010500018b8cULL,
0x000000ff00001940ULL, 0x003f010700018b78ULL, 0x000000ff000019c0ULL, 0x003f010100018b78ULL,
0x000000ff00001a20ULL, 0x003f010100018b88ULL, 0x000000ff00001cd0ULL, 0x003f010500018b7cULL,
0x000000ff00001e90ULL, 0x003f010500018b7cULL, 0x000000ff00001ef0ULL, 0x003f010500018b8cULL,
0x000000ff000020c0ULL, 0x003f010500018b8cULL, 0x000000ff00002b20ULL, 0x003f010100018b88ULL,
0x000000ff00002b50ULL, 0x003f010500018b8cULL, 0x000000ff00002d20ULL, 0x003f010500018b8cULL,
0x000000ff00003080ULL, 0x003f010700018b80ULL, 0x000000ff00003100ULL, 0x003f010100018b80ULL,
0x000000ff000031a0ULL, 0x0005010100018ad8ULL, 0x000000ff000031d0ULL, 0x0005010500018adcULL,
0x000000ff000033a0ULL, 0x0005010500018adcULL, 0x000000ff00004e40ULL, 0x003f010100018b88ULL,
0x000000ff00004f10ULL, 0x003f010500018b84ULL, 0x000000ff000050d0ULL, 0x003f010500018b84ULL,
0x000000ff00005130ULL, 0x003f010500018b8cULL, 0x000000ff00005300ULL, 0x003f010500018b8cULL,
0x000000ff00005d30ULL, 0x003f010100018b88ULL, 0x000000ff00005d60ULL, 0x003f010500018b8cULL,
0x000000ff00005f30ULL, 0x003f010500018b8cULL, 0x000000ff00006100ULL, 0x003f010700018b78ULL,
0x000000ff00006180ULL, 0x003f010100018b78ULL, 0x000000ff00007530ULL, 0x003f010100018b88ULL,
0x000000ff000075e0ULL, 0x003f010100018b58ULL, 0x000000ff000076c0ULL, 0x003f010500018b7cULL,
0x000000ff00007880ULL, 0x003f010500018b7cULL, 0x000000ff000078e0ULL, 0x003f010500018b8cULL,
0x000000ff00007ab0ULL, 0x003f010500018b8cULL, 0x000000ff00008500ULL, 0x003f010100018b88ULL,
0x000000ff00008530ULL, 0x003f010500018b8cULL, 0x000000ff00008700ULL, 0x003f010500018b8cULL,
0x000000ff00008a30ULL, 0x003f010700018b80ULL, 0x000000ff00008ab0ULL, 0x003f010100018b80ULL,
0x000000ff00008b50ULL, 0x0005010100018af8ULL, 0x000000ff00008b80ULL, 0x0005010500018afcULL,
0x000000ff00008d50ULL, 0x0005010500018afcULL, 0x000000ff0000a590ULL, 0x003f010100018b88ULL,
0x000000ff0000a670ULL, 0x003f010500018b84ULL, 0x000000ff0000a830ULL, 0x003f010500018b84ULL,
0x000000ff0000a890ULL, 0x003f010500018b8cULL, 0x000000ff0000aa60ULL, 0x003f010500018b8cULL,
0x000000ff0000b490ULL, 0x003f010100018b88ULL, 0x000000ff0000b4c0ULL, 0x003f010500018b8cULL,
0x000000ff0000b690ULL, 0x003f010500018b8cULL, 0x000000ff0000b860ULL, 0x003f010700018b78ULL,
0x000000ff0000b8e0ULL, 0x003f010100018b78ULL, 0x000000ff0000cb80ULL, 0x003f010100018b88ULL,
0x000000ff0000cc10ULL, 0x003f010100018b60ULL, 0x000000ff0000ccf0ULL, 0x003f010500018b7cULL,
0x000000ff0000ceb0ULL, 0x003f010500018b7cULL, 0x000000ff0000cf10ULL, 0x003f010500018b8cULL,
0x000000ff0000d0e0ULL, 0x003f010500018b8cULL, 0x000000ff0000db30ULL, 0x003f010100018b88ULL,
0x000000ff0000db60ULL, 0x003f010500018b8cULL, 0x000000ff0000dd30ULL, 0x003f010500018b8cULL,
0x000000ff0000e060ULL, 0x003f010700018b80ULL, 0x000000ff0000e0e0ULL, 0x003f010100018b80ULL,
0x000000ff0000e180ULL, 0x0005010100018b18ULL, 0x000000ff0000e1b0ULL, 0x0005010500018b1cULL,
0x000000ff0000e380ULL, 0x0005010500018b1cULL, 0x000000ff0000fbc0ULL, 0x003f010100018b88ULL,
0x000000ff0000fca0ULL, 0x003f010500018b84ULL, 0x000000ff0000fe60ULL, 0x003f010500018b84ULL,
0x000000ff0000fec0ULL, 0x003f010500018b8cULL, 0x000000ff00010090ULL, 0x003f010500018b8cULL,
0x000000ff00010ac0ULL, 0x003f010100018b88ULL, 0x000000ff00010af0ULL, 0x003f010500018b8cULL,
0x000000ff00010cc0ULL, 0x003f010500018b8cULL, 0x000000ff00010e90ULL, 0x003f010700018b78ULL,
0x000000ff00010f10ULL, 0x003f010100018b78ULL, 0x000000ff000121b0ULL, 0x003f010100018b88ULL,
0x000000ff00012240ULL, 0x003f010100018b68ULL, 0x000000ff00012320ULL, 0x003f010500018b7cULL,
0x000000ff000124e0ULL, 0x003f010500018b7cULL, 0x000000ff00012540ULL, 0x003f010500018b8cULL,
0x000000ff00012710ULL, 0x003f010500018b8cULL, 0x000000ff00013160ULL, 0x003f010100018b88ULL,
0x000000ff00013190ULL, 0x003f010500018b8cULL, 0x000000ff00013360ULL, 0x003f010500018b8cULL,
0x000000ff00013690ULL, 0x003f010700018b80ULL, 0x000000ff00013710ULL, 0x003f010100018b80ULL,
0x000000ff000137b0ULL, 0x0005010100018b38ULL, 0x000000ff000137e0ULL, 0x0005010500018b3cULL,
0x000000ff000139b0ULL, 0x0005010500018b3cULL, 0x000000ff000151f0ULL, 0x003f010100018b88ULL,
0x000000ff000152d0ULL, 0x003f010500018b84ULL, 0x000000ff00015490ULL, 0x003f010500018b84ULL,
0x000000ff000154f0ULL, 0x003f010500018b8cULL, 0x000000ff000156c0ULL, 0x003f010500018b8cULL,
0x000000ff000160f0ULL, 0x003f010100018b88ULL, 0x000000ff00016120ULL, 0x003f010500018b8cULL,
0x000000ff000162f0ULL, 0x003f010500018b8cULL, 0x000000ff000164c0ULL, 0x003f010700018b78ULL,
0x000000ff00016540ULL, 0x003f010100018b78ULL, 0x000000ff000177e0ULL, 0x003f010100018b88ULL,
0x000000ff00017860ULL, 0x003f010100018b70ULL, 0x000000ff000183c0ULL, 0x003f010100018ad0ULL,
0x000000ff0001a820ULL, 0x003f010500018ad4ULL, 0x000000ff0001a9f0ULL, 0x003f010500018ad4ULL,
0x000000ff0001ad70ULL, 0x003f010100018ad0ULL, 0x000000ff0001adb0ULL, 0x003f010500018ad4ULL,
0x000000ff0001af70ULL, 0x003f010500018ad4ULL, 0x000000540001eaa0ULL, 0x003f010100000000ULL,
0x000000540001ecd0ULL, 0x003f010500000004ULL, 0x000000540001eea0ULL, 0x003f010500000004ULL,
0x0000005200020310ULL, 0x003f010100000000ULL, 0x0000005200020370ULL, 0x003f010100000008ULL,
0x00000052000203d0ULL, 0x003f010100000010ULL, 0x0000005200020440ULL, 0x003f010100000018ULL,
0x00101c0400053803ULL, 0x0001afd0000182c0ULL, 0x000204800001b0b0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000003fcULL, 0x0000001b00000002ULL, 0x0000000000000334ULL,
0x0000001b00000002ULL, 0x0000000000000284ULL, 0x0000001b00000002ULL, 0x00000000000001d4ULL,
0x0000001b00000002ULL, 0x000000000000010cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x00000000000003d6ULL, 0x0000001b00000002ULL, 0x000000000000030cULL,
0x0000001b00000002ULL, 0x000000000000025cULL, 0x0000001b00000002ULL, 0x00000000000001acULL,
0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL, 0x0000000000018c00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000b79c3ULL, 0x000ea20000002700ULL, 0x0000000000147806ULL, 0x000fe200038e0000ULL,
0x00005800ff107624ULL, 0x000fe200078e00ffULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x0000001400077300ULL, 0x000fe200000e0000ULL,
0x00004600000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ee20000002200ULL,
0x0000000400097882ULL, 0x000fc60000000000ULL, 0x00000000000f7919ULL, 0x000f240000000000ULL,
0x0000001400147309ULL, 0x000ee40000000000ULL, 0x0000000000087919ULL, 0x000f220000000000ULL,
0x00000005ff007819ULL, 0x002fe2000001160bULL, 0x000000020b0a7899ULL, 0x004fca000800063fULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x000000ffff147224ULL, 0x008fe400078e0a14ULL,
0x000001000a027a24ULL, 0x000fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000ea400000e0000ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000080700720cULL, 0x010fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003f25270ULL, 0x0000000f0b00780cULL, 0x040fe40003f44070ULL,
0x000000030b00780cULL, 0x040fe40003f64070ULL, 0x000000010b00780cULL, 0x040fe40003fa4070ULL,
0x0000007f0b00780cULL, 0x000fe20003f84070ULL, 0x00000000000873c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff029424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL,
0x0000000000007919ULL, 0x002e620000002600ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff00ff08d424ULL, 0x000fe200078e00ffULL, 0x018ad002ff009388ULL, 0x0007e20000000a00ULL,
0x7fffff00ff09d424ULL, 0x000fc400078e00ffULL, 0xff317217ff12c424ULL, 0x000fe200078e00ffULL,
0x018ad8040b00a388ULL, 0x0009e80000008a00ULL, 0x018400120b00c388ULL, 0x000fe20000004800ULL,
0x0000000410037824ULL, 0x008fe200078e00ffULL, 0x000000080a067c11ULL, 0x004fe2000f8e10ffULL,
0x000000100f047824ULL, 0x010fc800078e00ffULL, 0x00000002060c7824ULL, 0x000fe400078e00ffULL,
0x0000000b03037c24ULL, 0x002fe2000f8e0200ULL, 0x000001f004117812ULL, 0x000fe200078ec0ffULL,
0x000000010c0d7824ULL, 0x040fe200078e020fULL, 0x000000040c057817ULL, 0x040fe20007800000ULL,
0x000000200c0e7824ULL, 0x040fe200078e00ffULL, 0x000000010c107810ULL, 0x040fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL, 0x000058000c027a24ULL, 0x000fe200078e0203ULL,
0xffffffe00e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001050d7824ULL, 0x000fe200078e0a0cULL,
0x018b58060b00b388ULL, 0x0003e20000008a00ULL, 0x0000580010047a24ULL, 0x000fc400078e0203ULL,
0x00005c0002027625ULL, 0x080fe200078e0013ULL, 0x018b78080b00d388ULL, 0x0005e20000008a00ULL,
0x000000ff0d00720cULL, 0x040fe40003f43070ULL, 0x00005c0004047625ULL, 0x000fe200078e0013ULL,
0x000000010d00780cULL, 0x000fe40003f63070ULL, 0x0000001102027210ULL, 0x080fe40007f9e0ffULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x3fffff80ff069424ULL, 0x002fc400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fe400078e00ffULL, 0x0000000110087824ULL, 0x044fe400078e020fULL,
0x0000002010097824ULL, 0x000fe200078e00ffULL, 0x018b8806ff009388ULL, 0x000fe20000000a00ULL,
0x000000ffff037224ULL, 0x000fe400020e0603ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0xffffffe009087812ULL, 0x000fe200078ee208ULL, 0x000000100e097824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000010080b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e2000d101c4cULL,
0x000000ffff087224ULL, 0x000fc600078e0014ULL, 0x00000000040b7faeULL, 0x0003e8000d901c4cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x018ad408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018ad000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000620000047ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL,
0x00006a0000067ab9ULL, 0x000fe40000000a00ULL, 0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL,
0x00000004ff5c7e24ULL, 0x000fe4000f8e00ffULL, 0x00000005ff5d7e24ULL, 0x000fe4000f8e00ffULL,
0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL, 0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000000c5c5c7981ULL, 0x000ea8000c1e1900ULL, 0x0000000c02027981ULL, 0x000ee2000c1e1900ULL,
0x000000ff0a00720cULL, 0x000fc40003f05270ULL, 0x0000003f5c5a7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff5c0a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff597819ULL, 0x008fe40000011602ULL,
0x00000006ff5a7819ULL, 0x000fe4000001165aULL, 0x00000008ff5b7819ULL, 0x000fc6000001160aULL,
0x00017c4000008947ULL, 0x000fea0003800000ULL, 0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL,
0x0000000308057899ULL, 0x000fe2000800063fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000003ff067424ULL, 0x000fe400078e00ffULL, 0x0000002002037824ULL, 0x000fca00078e020fULL,
0x0000001f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL,
0x0000005c0300720cULL, 0x040fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0x00018a0003077811ULL, 0x000fe200078e10ffULL, 0x0000680004047a24ULL, 0x000fc800078e0203ULL,
0x0000660004047625ULL, 0x000fcc00078e0005ULL, 0x0000000004077faeULL, 0x0003e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b5c06ffff798cULL, 0x0005e20008000005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b5800ffff7f8cULL, 0x000fe2000c800405ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000002700ULL,
0x00006400ff057624ULL, 0x000fe200078e00ffULL, 0x000000ff5a00720cULL, 0x000fe20003f05270ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x002fe200078e0203ULL,
0x00018ac003037811ULL, 0x000fc600078e10ffULL, 0x0000000204047824ULL, 0x000fc800078e00ffULL,
0x0000640004047624ULL, 0x000fc800078e0205ULL, 0x0000600004047625ULL, 0x000fca00078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e4000812184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff047f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x018b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x004fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fd4000800063fULL,
0x000004f000000947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x000000055c037c17ULL, 0x000fe2000f800000ULL, 0x00000100ff107424ULL, 0x000fc600078e00ffULL,
0x8000000503037c10ULL, 0x000fe4000fffe0ffULL, 0x00000004ff087819ULL, 0x002fe20000011611ULL,
0x00000010110f7824ULL, 0x000fc600078e00ffULL, 0x0000000508097c10ULL, 0x040fe4000fffe0ffULL,
0x000000f00f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000030800720cULL, 0x000fe20003f06070ULL,
0x018a000009067984ULL, 0x004e620000004800ULL, 0x00000040000b7824ULL, 0x000fe400078e0209ULL,
0x0000000109077824ULL, 0x040fe400078e0211ULL, 0x00000010090a7824ULL, 0x000fe200078e00ffULL,
0x018ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406047c24ULL, 0x002fc8000f8e020bULL,
0x00005e0004047625ULL, 0x000fca00078e0010ULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x00014000040d7811ULL, 0x000fe400078e20ffULL, 0x000000020b057810ULL, 0x000fe40007ffe0ffULL,
0x0000000208047810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e6000c101c4cULL, 0x00000005040a7c10ULL, 0x040fe2000fffe0ffULL,
0x018a0800090c7984ULL, 0x000ea20000004800ULL, 0x000000030400720cULL, 0x000fc60003f06070ULL,
0x000000010a0e7824ULL, 0x040fe400078e0211ULL, 0x000000100a137824ULL, 0x000fca00078e00ffULL,
0xfffffff0130e7812ULL, 0x000fc800078ee20eULL, 0x000140000e0d7811ULL, 0x002fe200078e20ffULL,
0x018ac0000c0c7984ULL, 0x004e640000004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0x0000000408047810ULL, 0x040fe40007ffe0ffULL, 0x0000000608087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x000000040b057810ULL, 0x000fe40007ffe0ffULL,
0x00000005040a7c10ULL, 0x040fe4000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c4cULL, 0x000000030400720cULL, 0x000fc40003f06070ULL,
0x000000010a0e7824ULL, 0x040fe200078e0211ULL, 0x018a1000090c7984ULL, 0x000ea20000004800ULL,
0x000000100a137824ULL, 0x000fe200078e00ffULL, 0x000000060b0b7810ULL, 0x000fe40007ffe0ffULL,
0x00000005080a7c10ULL, 0x000fe4000fffe0ffULL, 0xfffffff0130e7812ULL, 0x000fc800078ee20eULL,
0x000140000e0d7811ULL, 0x002fe200078e20ffULL, 0x018ac0000c0c7984ULL, 0x004e640000004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000f04067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c4cULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x000000010a037824ULL, 0x040fe400078e0211ULL,
0x018a180009097984ULL, 0x000ea20000004800ULL, 0x000000100a0a7824ULL, 0x000fca00078e00ffULL,
0xfffffff00a037812ULL, 0x000fc800078ee203ULL, 0x0001400003037811ULL, 0x000fe200078e20ffULL,
0x018ac00009047984ULL, 0x004ea40000004800ULL, 0x0000000404047c24ULL, 0x004fc8000f8e020bULL,
0x00005e0004047625ULL, 0x000fca00078e0010ULL, 0x0000000f04047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x000e620000000000ULL, 0x00000100ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000050f037c11ULL, 0x042fe2000f8fe0ffULL, 0x000000100f057824ULL, 0x000fc800078e00ffULL,
0x018a000003087984ULL, 0x000e620000004800ULL, 0x00000040000b7824ULL, 0x000fe200078e0203ULL,
0x000000f005117812ULL, 0x000fe200078ec0ffULL, 0x0000000103077824ULL, 0x040fe400078e020fULL,
0x00000010030a7824ULL, 0x040fe200078e00ffULL, 0x018ac00008087984ULL, 0x002e640000004800ULL,
0x0000000408047c24ULL, 0x002fe2000f8e020bULL, 0x0000000203087810ULL, 0x000fc60007ffe0ffULL,
0x00005e0004047625ULL, 0x000fc800078e000cULL, 0x0000000108097824ULL, 0x000fe200078e020fULL,
0x0000001104067210ULL, 0x004fe20007f1e0ffULL, 0x00000010080e7824ULL, 0x000fe200078e00ffULL,
0xfffffff00a047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x00014000040d7811ULL, 0x000fe400078e20ffULL, 0x000000020b057810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e8000b901c4cULL,
0x018a0800030a7984ULL, 0x000ea20000004800ULL, 0x0000000403067810ULL, 0x002fca0007ffe0ffULL,
0x0000000106077824ULL, 0x000fe200078e020fULL, 0x018ac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000cULL,
0x0000001104087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e047812ULL, 0x000fe200078ee209ULL,
0x00000010060e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x00014000040d7811ULL, 0x000fe400078e20ffULL, 0x000000040b057810ULL, 0x040fe40007ffe0ffULL,
0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e8000b901c4cULL, 0x018a1000030a7984ULL, 0x000ea20000004800ULL,
0x0000000603087810ULL, 0x002fc60007ffe0ffULL, 0x018ac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000cULL,
0x0000001104067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0001400004097811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c4cULL,
0x018a1800030a7984ULL, 0x000ea80000004800ULL, 0x018ac0000a0a7984ULL, 0x004ea40000004800ULL,
0x000000040a047c24ULL, 0x004fc4000f8e020bULL, 0x00000001080b7824ULL, 0x000fe400078e020fULL,
0x00005e0004047625ULL, 0x000fc800078e000cULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000001104047210ULL, 0x000fc80007f1e0ffULL, 0xfffffff0080b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff057224ULL, 0x000fc600000e0605ULL, 0x000140000b0b7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e4000b901c4cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff047f8cULL, 0x002e64000c80043fULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x018b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018b8c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002002067824ULL, 0x002fca00078e0203ULL, 0x0000001f0600780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000aff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000002006057810ULL, 0x000fc60007ffe0ffULL, 0x0000680007047a24ULL, 0x000fe200078e0206ULL,
0x0000005c0500720cULL, 0x000fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0x00018a0006077811ULL, 0x000fe400078e10ffULL, 0x0000002004047810ULL, 0x000fca0007ffe0ffULL,
0x0000660004047625ULL, 0x000fca00078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000c12184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000ff5b00720cULL, 0x000fe20003f05270ULL,
0x000000ffff677224ULL, 0x002fe200078e0005ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff587224ULL, 0x000fe200078e00ffULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000ffff127224ULL, 0x000fc400078e00ffULL,
0x000000ffff237224ULL, 0x004fe400078e0007ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00015d3000008947ULL, 0x000fea0003800000ULL, 0x00005800ff167624ULL, 0x000fe200078e00ffULL,
0x00015d1000007945ULL, 0x000fe20003800000ULL, 0xff317217ff137424ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x0000004016167824ULL, 0x000fc600078e00ffULL, 0x0000010014177824ULL, 0x000fca00078e00ffULL,
0x0000005c1700720cULL, 0x000fda0003f06070ULL, 0x00015c5000000947ULL, 0x022fea0003800000ULL,
0x000000ffff667224ULL, 0x000fc600078e00ffULL, 0x000000145900720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff177819ULL, 0x000fe20000011666ULL,
0x000000ffff227224ULL, 0x002fe200078e00ffULL, 0x00000003661c7812ULL, 0x040fe400078ec0ffULL,
0x0000001766217207ULL, 0x020fe40002800000ULL, 0x000000ff1c177207ULL, 0x000fe40006800000ULL,
0x00000003211d7812ULL, 0x000fc400078ec0ffULL, 0x00000014211c7211ULL, 0x000fc400078ff0ffULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x018b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000002420277210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e21ULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc80000011425ULL,
0x000000271e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x000000021e1e7819ULL, 0x000fc80000001225ULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x018b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000002420277210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc80000011425ULL, 0x000000271e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x000000021e1e7819ULL, 0x000fc80000001225ULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000011c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000009a000017945ULL, 0x000fe60003800000ULL, 0x0000005b1e00720cULL, 0x000fda0003f06070ULL,
0x0000053000008947ULL, 0x000fea0003800000ULL, 0x00000004ff277819ULL, 0x000fe20000011603ULL,
0x000000041c217824ULL, 0x000fe200078e021dULL, 0x0000002000247811ULL, 0x000fe200078e30ffULL,
0x0000001003227824ULL, 0x000fe200078e00ffULL, 0x0000000527287c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x0000002021217811ULL, 0x000fe400078e30ffULL,
0x000000f0222b7812ULL, 0x000fe200078ec0ffULL, 0x018a000028207984ULL, 0x000e620000004800ULL,
0x000000215c1e7217ULL, 0x000fe20007800000ULL, 0x0000001028267824ULL, 0x000fe200078e00ffULL,
0x00000002272d7810ULL, 0x000fc60007ffe0ffULL, 0x000000011e1e7824ULL, 0x000fe200078e0a21ULL,
0x000000052d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000128217824ULL, 0x000fc600078e0224ULL,
0x000000051e1e7c17ULL, 0x000fe2000f800000ULL, 0x000000012a2c7824ULL, 0x000fc600078e0203ULL,
0x800000051e1e7c10ULL, 0x000fc8000fffe0ffULL, 0x0000001e2700720cULL, 0x000fe20003f06070ULL,
0x018ac00020237984ULL, 0x002e640000004800ULL, 0x0000002316217224ULL, 0x002fe400078e0221ULL,
0x0000000128237824ULL, 0x000fe400078e0203ULL, 0x00005e0021207625ULL, 0x000fc600078e0029ULL,
0xfffffff026257812ULL, 0x000fe400078ee223ULL, 0x0000002b20227210ULL, 0x000fe20007f3e0ffULL,
0x000000012a207824ULL, 0x000fe200078e0224ULL, 0x0001600025257811ULL, 0x000fc600078e20ffULL,
0x000000ffff237224ULL, 0x000fca00008e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e2000c101c4cULL, 0x0000001e2d00720cULL, 0x000fe20003f06070ULL,
0x000000102a2d7824ULL, 0x000fe400078e00ffULL, 0x018a080028267984ULL, 0x000ea60000004800ULL,
0xfffffff02d257812ULL, 0x002fe400078ee22cULL, 0x00000004272d7810ULL, 0x000fe40007ffe0ffULL,
0x0001600025257811ULL, 0x000fc400078e20ffULL, 0x000000052d2a7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000627277810ULL, 0x000fc60007ffe0ffULL, 0x000000012a2c7824ULL, 0x000fe200078e0203ULL,
0x018ac00026217984ULL, 0x004e640000004800ULL, 0x0000002116207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fca00078e0029ULL, 0x0000002b20227210ULL, 0x000fe20007f3e0ffULL,
0x000000012a207824ULL, 0x000fc800078e0224ULL, 0x000000ffff237224ULL, 0x000fca00008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e2000c101c4cULL,
0x0000001e2d00720cULL, 0x000fe20003f06070ULL, 0x000000102a2d7824ULL, 0x000fe200078e00ffULL,
0x00000005272a7c10ULL, 0x000fe2000fffe0ffULL, 0x018a100028267984ULL, 0x000ea80000004800ULL,
0x000000012a247824ULL, 0x000fe200078e0224ULL, 0xfffffff02d257812ULL, 0x002fc800078ee22cULL,
0x0001600025257811ULL, 0x000fe200078e20ffULL, 0x018ac00026217984ULL, 0x004e640000004800ULL,
0x0000002116207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff237224ULL, 0x000fca00008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e2000c101c4cULL,
0x0000001e2700720cULL, 0x000fe20003f06070ULL, 0x000000102a277824ULL, 0x000fe400078e00ffULL,
0x018a180028267984ULL, 0x000ea80000004800ULL, 0x018ac00026217984ULL, 0x004ea40000004800ULL,
0x0000002116217224ULL, 0x004fc400078e0224ULL, 0x000000012a247824ULL, 0x000fe400078e0203ULL,
0x00005e0021207625ULL, 0x000fc600078e0029ULL, 0xfffffff027237812ULL, 0x002fe400078ee224ULL,
0x0000002b20207210ULL, 0x000fe40007f3e0ffULL, 0x0001600023237811ULL, 0x000fc600078e20ffULL,
0x000000ffff217224ULL, 0x000fca00008e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x0000000503267c11ULL, 0x040fe2000f8fe0ffULL, 0x0000001003227824ULL, 0x000fe200078e00ffULL,
0x0000002000297811ULL, 0x000fe200078e30ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x018a0000261e7984ULL, 0x000e620000004800ULL, 0x000000f0222d7812ULL, 0x000fe200078ec0ffULL,
0x0000000126207824ULL, 0x040fe400078e0229ULL, 0x0000000126237824ULL, 0x000fc400078e0203ULL,
0x0000001026247824ULL, 0x000fca00078e00ffULL, 0xfffffff024277812ULL, 0x000fe400078ee223ULL,
0x0000000226247810ULL, 0x000fe40007ffe0ffULL, 0x0001600027277811ULL, 0x000fc600078e20ffULL,
0x0000000124257824ULL, 0x040fe400078e0203ULL, 0x0000001024287824ULL, 0x000fe200078e00ffULL,
0x018ac0001e217984ULL, 0x002e640000004800ULL, 0x0000002116207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fca00078e002bULL, 0x0000002d20227210ULL, 0x000fe20007f1e0ffULL,
0x0000000124207824ULL, 0x000fc800078e0229ULL, 0x000000ffff237224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022277faeULL, 0x0003e8000b901c4cULL,
0x018a0800261e7984ULL, 0x000ea20000004800ULL, 0x0000000426227810ULL, 0x002fca0007ffe0ffULL,
0x0000000122237824ULL, 0x000fe200078e0203ULL, 0x018ac0001e217984ULL, 0x004e640000004800ULL,
0x0000002116207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002bULL,
0x0000002d20247210ULL, 0x000fe40007f1e0ffULL, 0xfffffff028207812ULL, 0x000fe200078ee225ULL,
0x0000001022287824ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200000e0621ULL,
0x0001600020277811ULL, 0x000fe200078e20ffULL, 0x0000000122207824ULL, 0x000fc800078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e8000b901c4cULL,
0x018a1000261e7984ULL, 0x000ea20000004800ULL, 0x0000000626247810ULL, 0x002fca0007ffe0ffULL,
0x0000000124277824ULL, 0x000fe200078e0203ULL, 0x018ac0001e217984ULL, 0x004e640000004800ULL,
0x0000002116207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002bULL,
0x0000002d20227210ULL, 0x000fe40007f1e0ffULL, 0xfffffff028207812ULL, 0x000fc600078ee223ULL,
0x000000ffff237224ULL, 0x000fe200000e0621ULL, 0x0001600020257811ULL, 0x000fe200078e20ffULL,
0x0000000124207824ULL, 0x040fe400078e0229ULL, 0x0000001024247824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e6000b901c4cULL,
0xfffffff024277812ULL, 0x000fe200078ee227ULL, 0x018a1800261e7984ULL, 0x000ea60000004800ULL,
0x0001600027237811ULL, 0x002fe200078e20ffULL, 0x018ac0001e217984ULL, 0x004e640000004800ULL,
0x0000002116207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e002bULL,
0x0000002d20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x018b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc80000011423ULL, 0x000000251e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x000000021e1e7819ULL, 0x000fc80000001223ULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000001c5900720cULL, 0x000fe20003f04070ULL,
0x0000020000017945ULL, 0x000fe20003800000ULL, 0x00000001171e7810ULL, 0x040fe40007ffe0ffULL,
0x000000031700780cULL, 0x000fe20003f45270ULL, 0x0000002002177824ULL, 0x000fe200078e0203ULL,
0x000000031e207812ULL, 0x000fc400078ec0ffULL, 0x0000001c5900720cULL, 0x000fe40003f24070ULL,
0x0000001f1700780cULL, 0x000fe40003f84070ULL, 0x000000ff20207207ULL, 0x000fe40004000000ULL,
0x00000002ff1e8819ULL, 0x000fca000001161eULL, 0x000000011d1d7824ULL, 0x000fc800078e021eULL,
0x000000401d1e7824ULL, 0x040fe200078e00ffULL, 0x0000001c1d1c7211ULL, 0x000fc800078ff0ffULL,
0x000000c01e1d7812ULL, 0x000fca00078ec0ffULL, 0x000001001c1e7824ULL, 0x000fe200078e021dULL,
0x0000011000009947ULL, 0x000fea0001000000ULL, 0x00000020021d7824ULL, 0x000fe200078e0203ULL,
0x0000000115157810ULL, 0x000fc80007ffe0ffULL, 0x000000031d00780cULL, 0x000fda0003f04070ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000e620000002700ULL,
0x0000005a1500720cULL, 0x040fe20003f06070ULL, 0x00000004ff237424ULL, 0x000fe400078e00ffULL,
0x000000041c217824ULL, 0x002fe200078e021dULL, 0x00006400151c7a10ULL, 0x000fc60007ffe0ffULL,
0x0000000221217824ULL, 0x000fc800078e00ffULL, 0x00006400211c7a24ULL, 0x000fe200078e021cULL,
0x00018ac01d217811ULL, 0x000fc600078e10ffULL, 0x000060001c1c7625ULL, 0x000fca00078e0023ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000e000017945ULL, 0x000fe20003800000ULL,
0x000000c000004947ULL, 0x000fea0003800000ULL, 0x0000000a201c7c10ULL, 0x002fe2000fffe0ffULL,
0x00000001171d7824ULL, 0x040fe200078e021eULL, 0x00018a0017217811ULL, 0x000fc600078e10ffULL,
0x000068001c1c7a24ULL, 0x000fe200078e021eULL, 0x0000005c1d00720cULL, 0x000fe20003f06070ULL,
0x00000004ff1d7424ULL, 0x000fe400078e00ffULL, 0x00000001171c7824ULL, 0x000fc800078e021cULL,
0x000066001c1c7625ULL, 0x000fcc00078e001dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff1c7f8cULL, 0x000e62000c80043fULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000080000017945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x002fd600078e001dULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018ad800ff1c7f8cULL, 0x000e64000c800405ULL, 0x000000ffff257224ULL, 0x002fc400078e001dULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x018adc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201c237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011421ULL, 0x0000002318187211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000218187819ULL, 0x000fc80000001221ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018adc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff1c7819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c1d7812ULL, 0x000fca00078ec0ffULL, 0x00000001181d7824ULL, 0x000fca00078e021dULL,
0x018000001d1c7984ULL, 0x000e680000000800ULL, 0x018200001d1e7984ULL, 0x0004e20000000800ULL,
0x000000131c00720bULL, 0x002fe20003f1d000ULL, 0x0001d0127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0013ULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05270ULL, 0x000000131c00720bULL, 0x000fe20003f34000ULL,
0x0001cfe27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000237806ULL, 0x000fc400008e0100ULL,
0x0000001c13227209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x0000991023207816ULL, 0x000fc600000000ffULL, 0x018400221d008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002213137221ULL, 0x002fe20000010000ULL, 0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300247308ULL, 0x000e640000000800ULL, 0x0000002412127220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe20000011603ULL,
0x0001cf427f007947ULL, 0x000fea000b800000ULL, 0x00001f1324137589ULL, 0x0002a400000e0000ULL,
0x0000001311117220ULL, 0x084fe40000410000ULL, 0x0000001310107220ULL, 0x080fe40000410000ULL,
0x000000130d0d7220ULL, 0x080fe40000410000ULL, 0x000000130c0c7220ULL, 0x080fe40000410000ULL,
0x0000001309097220ULL, 0x080fe40000410000ULL, 0x0000001308087220ULL, 0x000fc40000410000ULL,
0x0000001305057220ULL, 0x080fe40000410000ULL, 0x0000001304047220ULL, 0x080fe40000410000ULL,
0x0000001349497220ULL, 0x080fe40000410000ULL, 0x000000134a4a7220ULL, 0x080fe40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x000000134e4e7220ULL, 0x000fc40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001352527220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0023ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803137811ULL, 0x000fe200078ff0ffULL,
0x0001ce627f007947ULL, 0x000fea000b800000ULL, 0x00001f1324137589ULL, 0x00046400000e0000ULL,
0x000000130f0f7220ULL, 0x082fe40000410000ULL, 0x000000130e0e7220ULL, 0x080fe40000410000ULL,
0x000000130b0b7220ULL, 0x080fe40000410000ULL, 0x000000130a0a7220ULL, 0x080fe40000410000ULL,
0x0000001307077220ULL, 0x080fe40000410000ULL, 0x0000001306067220ULL, 0x000fc40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x0000001348487220ULL, 0x080fe40000410000ULL,
0x000000134b4b7220ULL, 0x080fe40000410000ULL, 0x000000134c4c7220ULL, 0x080fe40000410000ULL,
0x000000134f4f7220ULL, 0x080fe40000410000ULL, 0x0000001350507220ULL, 0x000fc40000410000ULL,
0x0000001353537220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001357577220ULL, 0x080fe40000410000ULL, 0x0000001358587220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2aff7812ULL, 0x000fda0007806023ULL,
0x800000221c1c0221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c00190308ULL, 0x000e640000000800ULL,
0x000000191e1e0220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x000000121e127221ULL, 0x008fe40000010000ULL, 0x000000ffff137224ULL, 0x000fc400078e0022ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000017945ULL, 0x000fd80003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fe400000000ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011603ULL,
0x000054101a1c7816ULL, 0x000fe2000000001aULL, 0x0001ccb27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d1c1a7589ULL, 0x0002e400000e0000ULL, 0x000000081d1b7810ULL, 0x000fe20007ffe0ffULL,
0x0001cd027f007947ULL, 0x000fea000b800000ULL, 0x00001f1b1c1b7589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000101d277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e001cULL, 0x00003a5000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0001df9000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000181d277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x004fe200078e001cULL,
0x00003ac000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0001df2000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000803687812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff1d7819ULL, 0x102fe20000011603ULL,
0x0000000208047891ULL, 0x000fe2000f8e103fULL, 0x0000000768687812ULL, 0x000fe200078ef803ULL,
0x0000119000017945ULL, 0x000fe20003800000ULL, 0x00000007036e7812ULL, 0x000fe200078ec0ffULL,
0x0000000402657824ULL, 0x000fe200078e021dULL, 0x00000010682e7812ULL, 0x040fe200078efcffULL,
0x0000001068217824ULL, 0x040fe200078e00ffULL, 0x000000041d697c10ULL, 0x000fe2000fffe0ffULL,
0x00000001681c7824ULL, 0x000fe200078e0265ULL, 0x000000042e637c10ULL, 0x000fe2000fffe01dULL,
0x0000000165647824ULL, 0x000fe200078e022eULL, 0x000000086e6e7812ULL, 0x000fe200078ef803ULL,
0x000000102e257824ULL, 0x040fe200078e00ffULL, 0xfffffff0211c7812ULL, 0x000fe200078ee21cULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x000000145900720cULL, 0x000fe20003fc3070ULL,
0x000000011d6a7824ULL, 0x000fe200078e026eULL, 0x000140001c1c7811ULL, 0x000fe200078e20ffULL,
0x000000086e5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff025647812ULL, 0x000fc400078ee264ULL,
0xfffffff02e637812ULL, 0x000fe200078ee263ULL, 0x000000001c20783bULL, 0x000e620000004200ULL,
0x00014000641e7811ULL, 0x000fe400078e20ffULL, 0x00014000635d7811ULL, 0x000fe400078e20ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee26aULL, 0x000000001e24783bULL, 0x004fe20000004200ULL,
0x000000026a607810ULL, 0x000fe40007ffe0ffULL, 0x000120005f447811ULL, 0x000fe200078e20ffULL,
0x000000005d34783bULL, 0x000fe20000004200ULL, 0x000000145900720cULL, 0x000fc80003f03070ULL,
0x000000004444783bULL, 0x000ea20000000200ULL, 0x00000018ff2b7819ULL, 0x002fe20000011420ULL,
0x0000010020297824ULL, 0x040fe200078e00ffULL, 0x0000888020287816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe20000011421ULL,
0x00000100212c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011429ULL,
0x0000002b002b7306ULL, 0x000fe20000200c00ULL, 0x0000888021297816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fc40000011420ULL,
0x00000018ff317819ULL, 0x000fe40000011423ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000002000807306ULL, 0x0003e20000200c00ULL, 0x00008880232e7816ULL, 0x000fe200000000ffULL,
0x0000001a44449232ULL, 0x08cfe20000000000ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000001a46469232ULL, 0x000fe20000000000ULL, 0x00000018ff307819ULL, 0x000fe20000011422ULL,
0x0000001b45459232ULL, 0x080fe20000000000ULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x00000021002f7306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x0000888024827816ULL, 0x000fe200000000ffULL, 0x0000001b47479232ULL, 0x000fe20000000000ULL,
0x00000018ff7c7819ULL, 0x000fc40000011425ULL, 0x00000018ff2d7819ULL, 0x000fe20000011420ULL,
0x0000000168207824ULL, 0x040fe200078e0269ULL, 0x0000002c00427306ULL, 0x0003e20000200c00ULL,
0x0000001068217824ULL, 0x004fe200078e00ffULL, 0x0000888025847816ULL, 0x000fe400000000ffULL,
0x00000018ff407819ULL, 0x000fe40000011426ULL, 0xfffffff021207812ULL, 0x000fe200078ee220ULL,
0x0000010023217824ULL, 0x040fe200078e00ffULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00014000205e7811ULL, 0x000fe200078e20ffULL,
0x0000010024207824ULL, 0x040fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x000000005e38783bULL, 0x000ea20000004200ULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000002100817306ULL, 0x0007e20000200c00ULL, 0x00008880222c7816ULL, 0x042fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff3e7819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000002000837306ULL, 0x0003e20000200c00ULL, 0x0000010025217824ULL, 0x048fe200078e00ffULL,
0x0000888026797816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000888027787816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002300327306ULL, 0x0007e20000200c00ULL, 0x0000010026207824ULL, 0x042fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc40000011434ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100857306ULL, 0x0003e20000200c00ULL, 0x000000086e237824ULL, 0x008fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000888034717816ULL, 0x000fe400000000ffULL,
0xfffffff823607812ULL, 0x000fe400078ee260ULL, 0x00000020007a7306ULL, 0x0007e20000200c00ULL,
0x0000010027217824ULL, 0x042fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011435ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000888035727816ULL, 0x000fc400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002200337306ULL, 0x000fe20000200c00ULL,
0x0000010034207824ULL, 0x048fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x004fe40000011438ULL,
0x00000018ff747819ULL, 0x000fe40000011420ULL, 0x0001200060207811ULL, 0x000fe200078e20ffULL,
0x00000021007b7306ULL, 0x0003e20000200c00ULL, 0x0000888038417816ULL, 0x000fc400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff3d7819ULL, 0x000fe40000011439ULL,
0x00000018ff767819ULL, 0x000fe2000001143aULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x000000002020783bULL, 0x002e620000000200ULL, 0x00000018ff737819ULL, 0x000fe4000001143bULL,
0x0000888036617816ULL, 0x000fe400000000ffULL, 0x00000018ff6c7819ULL, 0x000fc40000011436ULL,
0x0000002900297306ULL, 0x000ea20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fce0000011437ULL,
0x00000024007e7306ULL, 0x0007f00000200c00ULL, 0x00000025007f7306ULL, 0x0005e20000200c00ULL,
0x0000010035247824ULL, 0x048fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000002600777306ULL, 0x000fe20000200c00ULL,
0x0000541029257816ULL, 0x004fe20000000042ULL, 0x0001000038297824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000888039427816ULL, 0x000fe400000000ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000002400757306ULL, 0x0005e20000200c00ULL,
0x0000001a20209232ULL, 0x002fc40000000000ULL, 0x0000001a22229232ULL, 0x000fe40000000000ULL,
0x0000001b21219232ULL, 0x080fe40000000000ULL, 0x0000001b23239232ULL, 0x000fe20000000000ULL,
0x0000002700437306ULL, 0x0003e20000200c00ULL, 0x0000541028247816ULL, 0x004fe2000000003fULL,
0x0000010038287824ULL, 0x000fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x000000244424723cULL, 0x002f6e00000018ffULL,
0x0000008400847306ULL, 0x000ff00000200c00ULL, 0x0000002a002a7306ULL, 0x000ff00000200c00ULL,
0x0000002c002c7306ULL, 0x000ff00000200c00ULL, 0x0000002d002d7306ULL, 0x000e700000200c00ULL,
0x0000002800387306ULL, 0x0005f00000200c00ULL, 0x00000029003f7306ULL, 0x0007e20000200c00ULL,
0x0000541082287816ULL, 0x004fc40000000083ULL, 0x000054102c2c7816ULL, 0x002fe4000000002dULL,
0x000088803a827816ULL, 0x000fc600000000ffULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x0000541084297816ULL, 0x008fce0000000085ULL, 0x000000282024723cULL, 0x020be20000001824ULL,
0x0000003400707306ULL, 0x0005ec0000200c00ULL, 0x0000541080287816ULL, 0x020fe4000000002bULL,
0x000054102f297816ULL, 0x000fe2000000002aULL, 0x0000010039347824ULL, 0x004fe200078e00ffULL,
0x0000003000307306ULL, 0x000ea20000200c00ULL, 0x000054102e2d7816ULL, 0x002fe20000000081ULL,
0x000000ffff817224ULL, 0x000fc400078e0082ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x000000284428723cULL, 0x040f6600000018ffULL, 0x0000003100317306ULL, 0x000e6a0000200c00ULL,
0x0000002c442c723cULL, 0x000f6600000018ffULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x0000541032317816ULL, 0x002fce0000000031ULL, 0x00000035006f7306ULL, 0x0003e20000200c00ULL,
0x000000304430723cULL, 0x000f6e00000018ffULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0001000039357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400397306ULL, 0x0003f00000200c00ULL, 0x0000007800787306ULL, 0x000f220000200c00ULL,
0x000001003a347824ULL, 0x002fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003500807306ULL, 0x0005e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x0000003400827306ULL, 0x0003e20000200c00ULL,
0x000054107f357816ULL, 0x004fe4000000007cULL, 0x000088803b7c7816ULL, 0x000fca00000000ffULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x000054107e347816ULL, 0x002fce000000007dULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000342028723cULL, 0x020bee0000001828ULL,
0x0000541079347816ULL, 0x028fe2000000007aULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000541078357816ULL, 0x010fe2000000007bULL, 0x000001003b787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x00000034202c723cULL, 0x000be2000000182cULL,
0x0000004200427306ULL, 0x000eec0000200c00ULL, 0x000000ffff357224ULL, 0x020fe200078e007cULL,
0x0000541077347816ULL, 0x004fe20000000040ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000541041387816ULL, 0x002fc40000000038ULL, 0x0000888037777816ULL, 0x000fca00000000ffULL,
0x0000003500797306ULL, 0x0003e20000200c00ULL, 0x0000541042397816ULL, 0x008fce0000000039ULL,
0x0000003d003d7306ULL, 0x000ee20000200c00ULL, 0x0000541043357816ULL, 0x002fe4000000003eULL,
0x000054103f3c7816ULL, 0x004fca000000003cULL, 0x000000342030723cULL, 0x000be20000001830ULL,
0x0000007800787306ULL, 0x000e6c0000200c00ULL, 0x000100003b347824ULL, 0x020fe200078e00ffULL,
0x00005410803d7816ULL, 0x008fe2000000003dULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x0000010036357824ULL, 0x000fc400078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000036367824ULL, 0x000fe400078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003c443c723cULL, 0x000fe200000018ffULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541079417816ULL, 0x002fe20000000078ULL, 0x0000010037787824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fc80000011436ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541081407816ULL, 0x004fce0000000082ULL,
0x0000003a007d7306ULL, 0x0002a20000200c00ULL, 0x000000404440723cULL, 0x040fee00000018ffULL,
0x00000034007a7306ULL, 0x0004e20000200c00ULL, 0x000000384438723cULL, 0x002f6e00000018ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054107d347816ULL, 0x004fce0000000076ULL,
0x0000007400747306ULL, 0x000e700000200c00ULL, 0x0000007200727306ULL, 0x000eb00000200c00ULL,
0x00000035007c7306ULL, 0x0007f00000200c00ULL, 0x0000006d006d7306ULL, 0x000f220000200c00ULL,
0x000054107a357816ULL, 0x008fce0000000073ULL, 0x0000006200627306ULL, 0x000ee20000200c00ULL,
0x000000344444723cULL, 0x000b6e00000018ffULL, 0x0000541071347816ULL, 0x022fe20000000074ULL,
0x0001000037717824ULL, 0x000fe200078e00ffULL, 0x0000541072357816ULL, 0x004fe20000000075ULL,
0x0000006100617306ULL, 0x000e660000200c00ULL, 0x00000018ff717819ULL, 0x000fc60000011471ULL,
0x000000342038723cULL, 0x000b640000001838ULL, 0x0000007700777306ULL, 0x000fea0000200c00ULL,
0x0000541070347816ULL, 0x030fe4000000006dULL, 0x000054106f357816ULL, 0x008fe20000000062ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x00000002ff627819ULL, 0x000fc80000011603ULL,
0x000000666200720cULL, 0x040fe20003f46070ULL, 0x00000034203c723cULL, 0x000b64000000183cULL,
0x0000006c006c7306ULL, 0x000fea0000200c00ULL, 0x0000541061347816ULL, 0x022fe4000000007cULL,
0x0000000862617810ULL, 0x000fe20007ffe0ffULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541077357816ULL, 0x004fc40000000078ULL, 0x000000666100720cULL, 0x000fca0003f66070ULL,
0x0000003600377306ULL, 0x0002a20000200c00ULL, 0x000000342040723cULL, 0x000b6e0000001840ULL,
0x0000007100707306ULL, 0x000ee20000200c00ULL, 0x0000000166367810ULL, 0x002fc80007ffe0ffULL,
0x000000366200720cULL, 0x080fe40005746470ULL, 0x000000366100720cULL, 0x000fe40005f66470ULL,
0x0000541037347816ULL, 0x024fe4000000006cULL, 0x0000541070357816ULL, 0x008fce000000006bULL,
0x000000342044723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000002411117221ULL, 0x000fe40000010000ULL,
0x0000002510107221ULL, 0x000fe40000010000ULL, 0x000000280d0d7221ULL, 0x000fe40000010000ULL,
0x000000290c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x0000003849497221ULL, 0x000fe40000010000ULL,
0x000000394a4a7221ULL, 0x000fe40000010000ULL, 0x0000003c4d4d7221ULL, 0x000fe40000010000ULL,
0x0000003d4e4e7221ULL, 0x000fc40000010000ULL, 0x0000004051517221ULL, 0x000fe40000010000ULL,
0x0000004152527221ULL, 0x000fe40000010000ULL, 0x0000004455557221ULL, 0x020fe40000010000ULL,
0x0000004556567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x000000260f0f7221ULL, 0x000fe40000010000ULL, 0x000000270e0e7221ULL, 0x000fe40000010000ULL,
0x0000002a0b0b7221ULL, 0x000fc40000010000ULL, 0x0000002b0a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x000000321f1f7221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x0000003a4b4b7221ULL, 0x000fc40000010000ULL, 0x0000003b4c4c7221ULL, 0x000fe40000010000ULL,
0x0000003e4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003f50507221ULL, 0x000fe40000010000ULL,
0x0000004253537221ULL, 0x000fe40000010000ULL, 0x0000004354547221ULL, 0x000fe40000010000ULL,
0x0000004657577221ULL, 0x020fc40000010000ULL, 0x0000004758587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011636ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000145900720cULL, 0x0c0fe40003f03070ULL,
0x0000002336257207ULL, 0x000fe40002800000ULL, 0x000000145900720cULL, 0x000fe40003fc3070ULL,
0x00000001ff2c7803ULL, 0x000fe40000000000ULL, 0x0000000325237812ULL, 0x000fc400078ec0ffULL,
0x0000000336207812ULL, 0x002fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fc600078e0021ULL,
0x000000ff20217207ULL, 0x000fe40006800000ULL, 0x0000001425207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8400ff227984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe20007804867ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000022ff7812ULL, 0x002fe2000780482bULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120227810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x0000005b2200720cULL, 0x000fda0003f06070ULL,
0x0000051000008947ULL, 0x000fea0003800000ULL, 0x000000051d2b7c10ULL, 0x040fe2000fffe0ffULL,
0x0000000420277824ULL, 0x000fe200078e0223ULL, 0x000000021d317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2e7424ULL, 0x000fe400078e00ffULL, 0x018a00002b227984ULL, 0x000e620000004800ULL,
0x0000004027277824ULL, 0x000fe200078e00ffULL, 0x00000005312a7c10ULL, 0x000fe2000fffe0ffULL,
0x00000040002d7824ULL, 0x000fe400078e022bULL, 0x0000001003267824ULL, 0x000fc400078e00ffULL,
0x000000012a307824ULL, 0x000fc600078e0203ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b267824ULL, 0x000fe200078e0203ULL, 0x018ac00022257984ULL, 0x0022a40000004800ULL,
0x000000275c227217ULL, 0x002fca0007800000ULL, 0x0000000122227824ULL, 0x000fe400078e0a27ULL,
0x000000102b277824ULL, 0x000fc600078e00ffULL, 0x0000000522227c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000522227c10ULL, 0x000fe4000fffe0ffULL,
0x0001400026297811ULL, 0x000fe400078e20ffULL, 0x000000022d267810ULL, 0x000fe20007ffe0ffULL,
0x0000002516257224ULL, 0x004fc800078e022dULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000221d00720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000c101c4cULL, 0x018a08002b287984ULL, 0x000ea20000004800ULL,
0x000000102a257824ULL, 0x002fe200078e00ffULL, 0x000000042d247810ULL, 0x040fe40007ffe0ffULL,
0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff025307812ULL, 0x000fc800078ee230ULL,
0x0001400030337811ULL, 0x000fe200078e20ffULL, 0x018ac00028277984ULL, 0x004e640000004800ULL,
0x0000002716277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002eULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000223100720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026337faeULL, 0x0003e8000c101c4cULL, 0x018a10002b2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002f24287210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0625ULL, 0x000000041d257810ULL, 0x000fc80007ffe0ffULL,
0x0000000525247c10ULL, 0x040fe4000fffe0ffULL, 0x000000222500720cULL, 0x000fc60003f06070ULL,
0x0000000124307824ULL, 0x040fe400078e0203ULL, 0x0000001024277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0001400030277811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000c101c4cULL,
0x018a18002b267984ULL, 0x000ea80000004800ULL, 0x018ac00026257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fe200078e022dULL, 0x000000061d2d7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0025247625ULL, 0x000fe200078e002eULL, 0x000000052d2a7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f24247210ULL, 0x000fe20007f1e0ffULL, 0x000000012a2e7824ULL, 0x040fe400078e0203ULL,
0x000000102a277824ULL, 0x002fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000222d00720cULL, 0x000fe40003f06070ULL, 0xfffffff0272e7812ULL, 0x000fc800078ee22eULL,
0x000140002e277811ULL, 0x000fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2d7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff307424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe400078e00ffULL, 0x018a00002d227984ULL, 0x000e620000004800ULL,
0x00000040002e7824ULL, 0x000fe400078e022dULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x018ac00022257984ULL, 0x0022a40000004800ULL, 0x000000022e227810ULL, 0x002fe20007ffe0ffULL,
0x0000002516257224ULL, 0x004fc800078e022eULL, 0x00005e0025247625ULL, 0x000fca00078e0030ULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012d247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000102d257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x00014000242b7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e8000b901c4cULL,
0x018a08002d2a7984ULL, 0x000ea80000004800ULL, 0x018ac0002a257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fe200078e0222ULL, 0x000000022d227810ULL, 0x000fc60007ffe0ffULL,
0x00005e0025247625ULL, 0x000fca00078e0030ULL, 0x0000002f24287210ULL, 0x000fe20007f1e0ffULL,
0x0000000122247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe400000e0625ULL,
0x0000001022257824ULL, 0x000fe200078e00ffULL, 0x000000042e227810ULL, 0x040fe40007ffe0ffULL,
0x000000062e2e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x00014000242b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282b7faeULL, 0x0003e8000b901c4cULL, 0x018a10002d2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fe200078e0222ULL,
0x000000042d227810ULL, 0x000fc60007ffe0ffULL, 0x00005e0025247625ULL, 0x000fca00078e0030ULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x0000000122247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x0000001022257824ULL, 0x000fe200078e00ffULL,
0x000000062d227810ULL, 0x000fc80007ffe0ffULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x00000001222a7824ULL, 0x040fe400078e0203ULL, 0x00000010222b7824ULL, 0x002fe200078e00ffULL,
0x0001400024297811ULL, 0x000fc800078e20ffULL, 0xfffffff02b2a7812ULL, 0x000fe200078ee22aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x018a18002d287984ULL, 0x000ea20000004800ULL, 0x000140002a277811ULL, 0x002fc600078e20ffULL,
0x018ac00028257984ULL, 0x004e640000004800ULL, 0x0000002516257224ULL, 0x002fc800078e022eULL,
0x00005e0025247625ULL, 0x000fca00078e0030ULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe2000780482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003f04070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40000000000ULL, 0x000000ff21247207ULL, 0x000fc60004000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003f06070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x002fe200078e0021ULL, 0x0000014000001947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0001a5627f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0002a400000e0000ULL,
0x0001a5c27f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000629000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0001b75000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x0000630000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0001b6e000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001600064647811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000168657824ULL, 0x040fe200078e0265ULL,
0x0001600063637811ULL, 0x000fe200078e20ffULL, 0x0000001068267824ULL, 0x044fe200078e00ffULL,
0x000000006428783bULL, 0x002e620000004200ULL, 0x0000000168697824ULL, 0x000fe200078e0269ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x0000001068687824ULL, 0x000fe200078e00ffULL,
0xfffffff026657812ULL, 0x000fe200078ee265ULL, 0x000000006320783bULL, 0x008fe20000004200ULL,
0x000000086e327824ULL, 0x000fe200078e00ffULL, 0x00000fb000017945ULL, 0x000fe20003800000ULL,
0x0001600065657811ULL, 0x000fc400078e20ffULL, 0xfffffff068687812ULL, 0x000fe400078ee269ULL,
0x000000046a697810ULL, 0x000fe40007ffe0ffULL, 0x0001600068687811ULL, 0x000fe400078e20ffULL,
0xfffffff832697812ULL, 0x000fe400078ee269ULL, 0x000000066a6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000006834783bULL, 0x000ea20000004200ULL, 0x0001200069407811ULL, 0x000fcc00078e20ffULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x0000010028247824ULL, 0x002fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000010029257824ULL, 0x000fe200078e00ffULL,
0x000088802a7a7816ULL, 0x000fe400000000ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fc40000011428ULL, 0x0000888028837816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe4000001142bULL,
0x000088802b787816ULL, 0x000fe200000000ffULL, 0x0000002400827306ULL, 0x0003e20000200c00ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff7c7819ULL, 0x000fe20000011429ULL,
0x00000100343b7824ULL, 0x004fe200078e00ffULL, 0x0000888029807816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011434ULL,
0x0000002500817306ULL, 0x0005e20000200c00ULL, 0x000001002a247824ULL, 0x002fe200078e00ffULL,
0x00008880343a7816ULL, 0x000fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011424ULL, 0x000001002b247824ULL, 0x040fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000028007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe20000011420ULL,
0x0000001a40409232ULL, 0x088fe20000000000ULL, 0x00000018ff7b7819ULL, 0x000fe20000011424ULL,
0x0000001a42429232ULL, 0x000fe20000000000ULL, 0x000000006524783bULL, 0x004ea20000004200ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000001b41419232ULL, 0x080fe20000000000ULL,
0x0000002a00777306ULL, 0x0005e20000200c00ULL, 0x0000010020287824ULL, 0x042fe200078e00ffULL,
0x0000888020747816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143bULL, 0x0000001b43439232ULL, 0x000fe20000000000ULL,
0x00000018ff757819ULL, 0x000fc40000011428ULL, 0x0000002b00767306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00008880353f7816ULL, 0x000fe200000000ffULL,
0x00000029007f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe40000011437ULL,
0x00008880363c7816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011421ULL,
0x0000888021737816ULL, 0x000fe200000000ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe40000011422ULL, 0x00000018ff6b7819ULL, 0x000fca0000011423ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000100242a7824ULL, 0x044fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x00000100262d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x002fe2000001142aULL, 0x00000100252a7824ULL, 0x000fe200078e00ffULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00000018ff297819ULL, 0x008fe20000011425ULL,
0x00000100272f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x040fe200078e00ffULL, 0x0000888025457816ULL, 0x000fc400000000ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x0000002b002b7306ULL, 0x000e620000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00008880262c7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011427ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2f7819ULL, 0x000fc6000001142fULL, 0x0000002e00257306ULL, 0x0004e20000200c00ULL,
0x0000541044447816ULL, 0x002fe2000000002bULL, 0x000000086e2b7824ULL, 0x000fe200078e00ffULL,
0x00008880376e7816ULL, 0x000fc800000000ffULL, 0xfffffff82b6a7812ULL, 0x000fe200078ee26aULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x00008880272e7816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400247306ULL, 0x000e620000200c00ULL, 0x0000541025287816ULL, 0x008fe40000000028ULL,
0x000120006a257811ULL, 0x000fca00078e20ffULL, 0x0000002600337306ULL, 0x0005f00000200c00ULL,
0x0000002700327306ULL, 0x0007e20000200c00ULL, 0x0000010035267824ULL, 0x044fe200078e00ffULL,
0x0000541024297816ULL, 0x002fe20000000029ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000010036277824ULL, 0x008fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff857819ULL, 0x000fe40000011427ULL, 0x0000002600867306ULL, 0x0003f00000200c00ULL,
0x0000002a002a7306ULL, 0x000ea20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000034003b7306ULL, 0x0007f00000200c00ULL, 0x0000002000707306ULL, 0x0009e20000200c00ULL,
0x0000010037347824ULL, 0x008fe200078e00ffULL, 0x0000541045457816ULL, 0x004fe2000000002aULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x000000284028723cULL, 0x000fe400000018ffULL,
0x00000018ff887819ULL, 0x000fc40000011434ULL, 0x00000018ff8a7819ULL, 0x000fe20000011437ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x010fe20000011436ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000054103a347816ULL, 0x000fe2000000003dULL,
0x00000100213a7824ULL, 0x040fe200078e00ffULL, 0x000000444044723cULL, 0x000f6200000018ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000002d002d7306ULL, 0x000ea60000200c00ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000001a24249232ULL, 0x082fe40000000000ULL,
0x0000001a26269232ULL, 0x000fe40000000000ULL, 0x0000001b25259232ULL, 0x080fe40000000000ULL,
0x0000001b27279232ULL, 0x000fe20000000000ULL, 0x0000008800897306ULL, 0x0002e20000200c00ULL,
0x000054102c2c7816ULL, 0x004fce000000002dULL, 0x0000003000307306ULL, 0x000ea20000200c00ULL,
0x0000888022887816ULL, 0x002fce00000000ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x000054106e3d7816ULL, 0x008fce0000000089ULL, 0x0000003800387306ULL, 0x000ee20000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541032317816ULL, 0x002fce0000000031ULL, 0x0000002e002e7306ULL, 0x000fe20000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x000000304030723cULL, 0x000fec00000018ffULL,
0x0000002f002f7306ULL, 0x000e700000200c00ULL, 0x0000003f003f7306ULL, 0x000eb00000200c00ULL,
0x00000035003e7306ULL, 0x0004e20000200c00ULL, 0x000054102e2d7816ULL, 0x002fce000000002fULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103f357816ULL, 0x004fe20000000086ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff867819ULL, 0x000fca000001143aULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000054103e397816ULL, 0x008fce0000000039ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x002fe20000000085ULL,
0x0000010022857824ULL, 0x000fc400078e00ffULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000003600877306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x000fe200000018ffULL, 0x00000018ff227819ULL, 0x000fcc0000011422ULL,
0x0000008a008b7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541087207816ULL, 0x004fe20000000020ULL,
0x000000ffff877224ULL, 0x000fcc00078e0088ULL, 0x0000008000807306ULL, 0x000eb00000200c00ULL,
0x00000021006e7306ULL, 0x0007f00000200c00ULL, 0x0000007d007d7306ULL, 0x000f220000200c00ULL,
0x000054108b217816ULL, 0x008fce0000000084ULL, 0x0000007c007c7306ULL, 0x000ee20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000541083207816ULL, 0x022fe20000000082ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541080217816ULL, 0x004fc40000000081ULL,
0x0000888023807816ULL, 0x000fca00000000ffULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000054107e207816ULL, 0x030fe4000000007dULL, 0x000054107f217816ULL, 0x008fe2000000007cULL,
0x00000100237c7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe400078e00ffULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000000ffff207224ULL, 0x020fce00078e0080ULL,
0x00000020007d7306ULL, 0x0007e20000200c00ULL, 0x0000541078217816ULL, 0x002fce000000007bULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000054107a207816ULL, 0x008fce0000000079ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541077207816ULL, 0x020fe40000000072ULL,
0x0000541076217816ULL, 0x004fca0000000071ULL, 0x0000008600867306ULL, 0x000ea40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000541074207816ULL, 0x022fce0000000075ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000541073217816ULL, 0x004fce0000000086ULL, 0x0000008700847306ULL, 0x000fe20000200c00ULL,
0x000000202434723cULL, 0x000b6e0000001834ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000541070207816ULL, 0x028fe4000000006fULL, 0x000054106e217816ULL, 0x002fca000000006dULL,
0x0000007c007c7306ULL, 0x000e640000200c00ULL, 0x000000202438723cULL, 0x000b6c0000001838ULL,
0x0000002200817306ULL, 0x000fe20000200c00ULL, 0x0000541084207816ULL, 0x024fce0000000085ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000054107d217816ULL, 0x002fce000000007cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000020243c723cULL, 0x000b6e000000183cULL,
0x0000002300227306ULL, 0x000e620000200c00ULL, 0x0000541081207816ULL, 0x024fe4000000006cULL,
0x0000541022217816ULL, 0x002fce000000006bULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x0000004411117221ULL, 0x000fe40000010000ULL, 0x0000004510107221ULL, 0x000fe40000010000ULL,
0x000000280d0d7221ULL, 0x000fe40000010000ULL, 0x000000290c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x0000003449497221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384d4d7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c51517221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004055557221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x000000460f0f7221ULL, 0x000fe40000010000ULL,
0x000000470e0e7221ULL, 0x000fe40000010000ULL, 0x0000002a0b0b7221ULL, 0x000fc40000010000ULL,
0x0000002b0a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x000000321f1f7221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x000000364b4b7221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e53537221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004257577221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000166667810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff6b7424ULL, 0x000fe200078e00ffULL, 0x018b8800ff227f8cULL, 0x000e68000c80043fULL,
0x000000016b6b7807ULL, 0x000fc80006800000ULL, 0x0000006b6600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffa6b000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004014217811ULL, 0x020fe200078e40ffULL,
0x018b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005c2100720cULL, 0x000fda0003f06070ULL,
0x0001026000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe2000001166cULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036c227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000000216c217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000121257810ULL, 0x000fc80007ffe0ffULL, 0x0000000325217812ULL, 0x040fe400078ec0ffULL,
0x0000001425207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x000fe20007ffe0ffULL, 0x0000099000017945ULL, 0x000fe60003800000ULL,
0x0000005b2400720cULL, 0x000fda0003f06070ULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000420237824ULL, 0x000fe200078e0221ULL,
0x0000002000297811ULL, 0x000fe200078e30ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x018a00002a257984ULL, 0x000e620000004800ULL,
0x0000002023237811ULL, 0x000fe200078e30ffULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a277824ULL, 0x000fe200078e0203ULL,
0x000000235c247217ULL, 0x000fe20007800000ULL, 0x000000102a2c7824ULL, 0x000fc800078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e0a23ULL, 0x000000012a237824ULL, 0x000fc600078e0229ULL,
0x0000000524247c17ULL, 0x000fc8000f800000ULL, 0x8000000524287c10ULL, 0x000fc8000fffe0ffULL,
0x000000281d00720cULL, 0x000fe20003f06070ULL, 0x018ac00025257984ULL, 0x002e640000004800ULL,
0x0000002516237224ULL, 0x002fc800078e0223ULL, 0x00005e0023247625ULL, 0x000fe200078e002bULL,
0xfffffff02c237812ULL, 0x000fe400078ee227ULL, 0x00000005312c7c10ULL, 0x000fe4000fffe0ffULL,
0x0000002d24267210ULL, 0x000fe40007f3e0ffULL, 0x00016000232f7811ULL, 0x000fe200078e20ffULL,
0x000000012c247824ULL, 0x000fe400078e0229ULL, 0x000000ffff277224ULL, 0x000fc400008e0625ULL,
0x000000012c2e7824ULL, 0x000fc600078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000283100720cULL, 0x000fe20003f06070ULL,
0x000000102c317824ULL, 0x000fe400078e00ffULL, 0x018a08002a237984ULL, 0x000ea60000004800ULL,
0xfffffff0312e7812ULL, 0x000fe400078ee22eULL, 0x000000041d317810ULL, 0x000fe40007ffe0ffULL,
0x000160002e2f7811ULL, 0x002fc400078e20ffULL, 0x00000005312c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24267210ULL, 0x000fe20007f3e0ffULL, 0x000000012c247824ULL, 0x000fc800078e0229ULL,
0x000000ffff277224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000283100720cULL, 0x000fe20003f06070ULL,
0x000000102c317824ULL, 0x000fe400078e00ffULL, 0x018a10002a237984ULL, 0x000ea60000004800ULL,
0xfffffff0312e7812ULL, 0x000fe400078ee22eULL, 0x000000061d317810ULL, 0x000fe40007ffe0ffULL,
0x000160002e2f7811ULL, 0x002fc400078e20ffULL, 0x00000005312c7c10ULL, 0x000fe2000fffe0ffULL,
0x018ac00023237984ULL, 0x004e640000004800ULL, 0x0000002316247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x000000012c247824ULL, 0x040fe400078e0229ULL, 0x000000012c297824ULL, 0x040fe400078e0203ULL,
0x000000ffff277224ULL, 0x000fe400008e0625ULL, 0x000000102c2c7824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0xfffffff02c297812ULL, 0x000fe200078ee229ULL,
0x018a18002a237984ULL, 0x000ea60000004800ULL, 0x0001600029297811ULL, 0x000fe200078e20ffULL,
0x018ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002316247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff257224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003257824ULL, 0x000fe200078e00ffULL,
0x00000020002d7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2f7424ULL, 0x000fe400078e00ffULL,
0x018a00002a237984ULL, 0x000e620000004800ULL, 0x000000f025317812ULL, 0x000fe200078ec0ffULL,
0x000000012a247824ULL, 0x040fe400078e022dULL, 0x000000012a277824ULL, 0x000fc400078e0203ULL,
0x000000102a287824ULL, 0x000fe200078e00ffULL, 0x018ac00023237984ULL, 0x002e640000004800ULL,
0x0000002316247224ULL, 0x002fe400078e0224ULL, 0xfffffff028237812ULL, 0x000fe400078ee227ULL,
0x000000022a287810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e002fULL,
0x00016000232b7811ULL, 0x000fc600078e20ffULL, 0x0000000128297824ULL, 0x000fe200078e0203ULL,
0x0000003124267210ULL, 0x000fe20007f1e0ffULL, 0x000000012d247824ULL, 0x000fe400078e0228ULL,
0x00000010282c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e8000b901c4cULL,
0x018a08002a237984ULL, 0x000ea20000004800ULL, 0x000000042a267810ULL, 0x002fca0007ffe0ffULL,
0x0000000126277824ULL, 0x000fe200078e0203ULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124287210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02c247812ULL, 0x000fe200078ee229ULL,
0x00000010262c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff297224ULL, 0x000fe200000e0625ULL,
0x00016000242b7811ULL, 0x000fe200078e20ffULL, 0x000000012d247824ULL, 0x000fc800078e0226ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e8000b901c4cULL,
0x018a10002a237984ULL, 0x000ea20000004800ULL, 0x000000062a287810ULL, 0x002fca0007ffe0ffULL,
0x00000001282b7824ULL, 0x000fe200078e0203ULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124267210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02c247812ULL, 0x000fc600078ee227ULL,
0x000000ffff277224ULL, 0x000fe200000e0625ULL, 0x0001600024297811ULL, 0x000fe200078e20ffULL,
0x000000012d247824ULL, 0x000fe400078e0228ULL, 0x0000001028287824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e6000b901c4cULL,
0xfffffff0282b7812ULL, 0x000fe200078ee22bULL, 0x018a18002a237984ULL, 0x000ea60000004800ULL,
0x000160002b277811ULL, 0x002fe200078e20ffULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe20003f04070ULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000032200780cULL, 0x000fda0003f25270ULL,
0x0000010000008947ULL, 0x000fea0000800000ULL, 0x000000031700780cULL, 0x000fe40003f04070ULL,
0x0000000115157810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x0000005a1500720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0217ULL,
0x0000640015247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00018ac017237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00018a0017237811ULL, 0x040fe200078e10ffULL,
0x0000000117217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x0000005c2100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000117207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff6c00720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6d7224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018af800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff277224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x018afc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220257210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011423ULL,
0x0000002518187211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000218187819ULL, 0x000fc80000001223ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x018afc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011603ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c20217812ULL, 0x000fca00078ec0ffULL,
0x0000000118277824ULL, 0x000fca00078e0221ULL, 0x0180800027227984ULL, 0x000e680000000800ULL,
0x0182800027237984ULL, 0x0004e20000000800ULL, 0x000000132200720bULL, 0x002fe20003f1d000ULL,
0x00017a227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0013ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f05270ULL,
0x000000132200720bULL, 0x000fe20003f34000ULL, 0x000179f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002213247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0184802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002413137221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300297308ULL, 0x000e640000000800ULL,
0x0000002912127220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000179527f007947ULL, 0x000fea000b800000ULL, 0x00001f6229137589ULL, 0x0002a400000e0000ULL,
0x0000001311117220ULL, 0x084fe40000410000ULL, 0x0000001310107220ULL, 0x080fe40000410000ULL,
0x000000130d0d7220ULL, 0x080fe40000410000ULL, 0x000000130c0c7220ULL, 0x080fe40000410000ULL,
0x0000001309097220ULL, 0x080fe40000410000ULL, 0x0000001308087220ULL, 0x000fc40000410000ULL,
0x0000001305057220ULL, 0x080fe40000410000ULL, 0x0000001304047220ULL, 0x080fe40000410000ULL,
0x0000001349497220ULL, 0x080fe40000410000ULL, 0x000000134a4a7220ULL, 0x080fe40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x000000134e4e7220ULL, 0x000fc40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001352527220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000178827f007947ULL, 0x000fea000b800000ULL,
0x00001f6129137589ULL, 0x00046400000e0000ULL, 0x000000130f0f7220ULL, 0x082fe40000410000ULL,
0x000000130e0e7220ULL, 0x080fe40000410000ULL, 0x000000130b0b7220ULL, 0x080fe40000410000ULL,
0x000000130a0a7220ULL, 0x080fe40000410000ULL, 0x0000001307077220ULL, 0x080fe40000410000ULL,
0x0000001306067220ULL, 0x000fc40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x0000001348487220ULL, 0x080fe40000410000ULL, 0x000000134b4b7220ULL, 0x080fe40000410000ULL,
0x000000134c4c7220ULL, 0x080fe40000410000ULL, 0x000000134f4f7220ULL, 0x080fe40000410000ULL,
0x0000001350507220ULL, 0x000fc40000410000ULL, 0x0000001353537220ULL, 0x080fe40000410000ULL,
0x0000001354547220ULL, 0x080fe40000410000ULL, 0x0000001357577220ULL, 0x080fe40000410000ULL,
0x0000001358587220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200190308ULL, 0x000e640000000800ULL, 0x0000001923230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001223127221ULL, 0x008fe40000010000ULL,
0x000000ffff137224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL, 0x0000016000017945ULL, 0x000fd80003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000176e27f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0002e400000e0000ULL, 0x000177427f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000093c000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0001862000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0000943000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000185b000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000128005f407811ULL, 0x000fe200078e20ffULL, 0x00000f9000017945ULL, 0x000fe20003800000ULL,
0x0000006c6200720cULL, 0x000fe20003f46070ULL, 0x000000001e24783bULL, 0x004ea20000004200ULL,
0x000000145900720cULL, 0x000fc40003fc3070ULL, 0x0000006c6100720cULL, 0x000fe20003f26070ULL,
0x000000005d28783bULL, 0x000fe20000004200ULL, 0x000000145900720cULL, 0x000fc60003f03070ULL,
0x000000005e34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000018ff447819ULL, 0x002fe20000011420ULL, 0x00000100202c7824ULL, 0x040fe200078e00ffULL,
0x0000888020327816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011421ULL, 0x00000100212d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000100242e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011425ULL,
0x0000888025817816ULL, 0x000fe200000000ffULL, 0x00000020003d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7d7819ULL, 0x000fe20000011424ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x0000888024827816ULL, 0x000fe200000000ffULL, 0x0000002d00477306ULL, 0x000fe20000200c00ULL,
0x0000010022207824ULL, 0x002fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011423ULL,
0x0000001b4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fc40000011426ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002c003f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff727819ULL, 0x000fe40000011427ULL, 0x0000888026797816ULL, 0x000fe400000000ffULL,
0x0000888027787816ULL, 0x000fe400000000ffULL, 0x00008880343a7816ULL, 0x000fe200000000ffULL,
0x00000020002d7306ULL, 0x0005e20000200c00ULL, 0x00000100252c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc40000011434ULL, 0x00000018ff847819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000010027207824ULL, 0x044fe200078e00ffULL, 0x0000002e00837306ULL, 0x0003e20000200c00ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe4000001142cULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00008880222c7816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000020007b7306ULL, 0x0005e20000200c00ULL,
0x00008880232e7816ULL, 0x002fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011436ULL,
0x0000002100247306ULL, 0x0003e20000200c00ULL, 0x0000010028207824ULL, 0x004fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x0000888035867816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fc40000011421ULL, 0x00000025007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00000018ff717819ULL, 0x000fe20000011428ULL,
0x0000004400447306ULL, 0x000ee20000200c00ULL, 0x0000010026257824ULL, 0x002fe200078e00ffULL,
0x0000541024457816ULL, 0x004fe20000000045ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888028747816ULL, 0x000fc400000000ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff707819ULL, 0x000fe40000011429ULL, 0x0000888029887816ULL, 0x000fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001142aULL, 0x00000023003e7306ULL, 0x0002a20000200c00ULL,
0x000054103d447816ULL, 0x008fc40000000044ULL, 0x00008880373d7816ULL, 0x000fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fc6000001142bULL, 0x00000025007a7306ULL, 0x0007e20000200c00ULL,
0x0000010036237824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0001280060257811ULL, 0x008fe400078e20ffULL,
0x000054103e317816ULL, 0x004fe40000000031ULL, 0x00000018ff367819ULL, 0x000fc60000011436ULL,
0x0000002000857306ULL, 0x0002b00000200c00ULL, 0x0000002600767306ULL, 0x000fe20000200c00ULL,
0x0000541032207816ULL, 0x002fe2000000003fULL, 0x0000010037327824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011423ULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011432ULL, 0x0000002700777306ULL, 0x0003f00000200c00ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0009f00000200c00ULL, 0x0000002200337306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x010fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000034003b7306ULL, 0x0009e20000200c00ULL, 0x0001000035227824ULL, 0x004fca00078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000054103a347816ULL, 0x010fe20000000085ULL, 0x00010000283a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fca0000011437ULL, 0x0000002100357306ULL, 0x0006a20000200c00ULL,
0x0000001a2424b232ULL, 0x082fe40000000000ULL, 0x0000001a2626b232ULL, 0x000fe40000000000ULL,
0x0000001b2525b232ULL, 0x080fe40000000000ULL, 0x0000001b2727b232ULL, 0x000fe20000000000ULL,
0x0000002c002c7306ULL, 0x000e620000200c00ULL, 0x0000541046217816ULL, 0x008fe40000000047ULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x0000541086357816ULL, 0x004fe20000000035ULL, 0x0000010029867824ULL, 0x000fc400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x000054102c2c7816ULL, 0x002fe4000000002dULL,
0x00000018ff297819ULL, 0x000fca0000011429ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x008fce0000000030ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x004fe20000000038ULL, 0x000000304030723cULL, 0x040fec00000018ffULL,
0x00000022007e7306ULL, 0x0004f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000000204020723cULL, 0x004f6200000018ffULL, 0x000054102e2d7816ULL, 0x002fcc000000002fULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054107e397816ULL, 0x008fe20000000039ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff7e7819ULL, 0x000fca000001143aULL,
0x0000003d003d7306ULL, 0x000fe40000200c00ULL, 0x000000384038723cULL, 0x000fec00000018ffULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054103d3d7816ULL, 0x004fce000000003eULL, 0x0000003600877306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x0000008500287306ULL, 0x000ee20000200c00ULL,
0x000000344034723cULL, 0x002f6e00000018ffULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x0000541087667816ULL, 0x004fce0000000066ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541028677816ULL, 0x008fce0000000067ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6200000018ffULL, 0x0000541082287816ULL, 0x002fcc0000000083ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000088802a667816ULL, 0x020fce00000000ffULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000008000807306ULL, 0x000e700000200c00ULL,
0x0000002900677306ULL, 0x0005f00000200c00ULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0000541081297816ULL, 0x004fe20000000084ULL, 0x000001002a817824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b620000001820ULL,
0x00000018ff2a7819ULL, 0x000fcc000001142aULL, 0x0000541080287816ULL, 0x022fe2000000007dULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054107f297816ULL, 0x000fe4000000007cULL,
0x000088802b7c7816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000000282444723cULL, 0x000b6e0000001844ULL, 0x0000541079287816ULL, 0x028fe2000000007aULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541078297816ULL, 0x004fe2000000007bULL,
0x000001002b787824ULL, 0x000fc400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x00000028242c723cULL, 0x000b62000000182cULL, 0x00000018ff2b7819ULL, 0x000fcc000001142bULL,
0x0000008800857306ULL, 0x000fe20000200c00ULL, 0x000000ffff287224ULL, 0x020fe200078e007cULL,
0x0000541077297816ULL, 0x002fcc0000000072ULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002800797306ULL, 0x0007f00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541076287816ULL, 0x008fce0000000073ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000000282430723cULL, 0x000b6e0000001830ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x0000541074287816ULL, 0x024fe40000000075ULL, 0x0000541085297816ULL, 0x002fca0000000086ULL,
0x0000006600667306ULL, 0x000fe40000200c00ULL, 0x000000282434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000054107e287816ULL, 0x028fe40000000071ULL,
0x0000541067297816ULL, 0x000fca0000000070ULL, 0x0000007800787306ULL, 0x000ea40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541066287816ULL, 0x022fe40000000081ULL, 0x000000016c667810ULL, 0x000fc80007ffe0ffULL,
0x000000666200720cULL, 0x080fe20005746470ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541079297816ULL, 0x004fe40000000078ULL, 0x000000666100720cULL, 0x000fca0004f26470ULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x00000028243c723cULL, 0x000b6e000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe4000000006fULL,
0x000054102b297816ULL, 0x004fce000000006eULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000002011117221ULL, 0x000fe40000010000ULL, 0x0000002110107221ULL, 0x000fe40000010000ULL,
0x000000440d0d7221ULL, 0x000fe40000010000ULL, 0x000000450c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x0000003449497221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384d4d7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c51517221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004055557221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220f0f7221ULL, 0x000fe40000010000ULL,
0x000000230e0e7221ULL, 0x000fe40000010000ULL, 0x000000460b0b7221ULL, 0x000fc40000010000ULL,
0x000000470a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x000000321f1f7221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x000000364b4b7221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e53537221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004257577221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff287224ULL, 0x020fe200078e00ffULL,
0x000000145900720cULL, 0x080fe40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366667812ULL, 0x000fe400078ec0ffULL, 0x0000000123257810ULL, 0x000fe40007ffe0ffULL,
0x000000145900720cULL, 0x000fc40003f03070ULL, 0x00000040ff2b7803ULL, 0x000fe40000000000ULL,
0x0000000325237812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2d7224ULL, 0x002fe200078e0021ULL,
0x000000ff66217207ULL, 0x000fe40006800000ULL, 0x0000001425207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8400ff227984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c486dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120227810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x0000005b2200720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x040fe2000fffe0ffULL,
0x0000000420277824ULL, 0x000fe200078e0223ULL, 0x000000021d317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2e7424ULL, 0x000fe400078e00ffULL, 0x018a00002c227984ULL, 0x000e620000004800ULL,
0x0000004027277824ULL, 0x000fe200078e00ffULL, 0x00000005312a7c10ULL, 0x000fe2000fffe0ffULL,
0x00000040002d7824ULL, 0x000fe400078e022cULL, 0x0000001003267824ULL, 0x000fc400078e00ffULL,
0x000000012a307824ULL, 0x000fc600078e0203ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x000000012c267824ULL, 0x000fe200078e0203ULL, 0x018ac00022257984ULL, 0x0022a40000004800ULL,
0x000000275c227217ULL, 0x002fca0007800000ULL, 0x0000000122227824ULL, 0x000fe400078e0a27ULL,
0x000000102c277824ULL, 0x000fc600078e00ffULL, 0x0000000522227c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000522227c10ULL, 0x000fe4000fffe0ffULL,
0x0001400026297811ULL, 0x000fe400078e20ffULL, 0x000000022d267810ULL, 0x000fe20007ffe0ffULL,
0x0000002516257224ULL, 0x004fc800078e022dULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000221d00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000f101c4cULL, 0x018a08002c287984ULL, 0x000ea20000004800ULL,
0x000000102a257824ULL, 0x002fe200078e00ffULL, 0x000000042d247810ULL, 0x040fe40007ffe0ffULL,
0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff025307812ULL, 0x000fc800078ee230ULL,
0x0001400030337811ULL, 0x000fe200078e20ffULL, 0x018ac00028277984ULL, 0x004e640000004800ULL,
0x0000002716277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002eULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000223100720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026337faeULL, 0x0003e8000f101c4cULL, 0x018a10002c2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002f24287210ULL, 0x000fca0007fde0ffULL,
0x000000ffff297224ULL, 0x000fe200030e0625ULL, 0x000000041d257810ULL, 0x000fc80007ffe0ffULL,
0x0000000525247c10ULL, 0x040fe4000fffe0ffULL, 0x000000222500720cULL, 0x000fc60003fc6070ULL,
0x0000000124307824ULL, 0x040fe400078e0203ULL, 0x0000001024277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0001400030277811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000f101c4cULL,
0x018a18002c267984ULL, 0x000ea80000004800ULL, 0x018ac00026257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fe200078e022dULL, 0x000000061d2d7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0025247625ULL, 0x000fe200078e002eULL, 0x000000052d2a7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f24247210ULL, 0x000fe20007fde0ffULL, 0x000000012a2e7824ULL, 0x040fe400078e0203ULL,
0x000000102a277824ULL, 0x002fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000222d00720cULL, 0x000fe40003fc6070ULL, 0xfffffff0272e7812ULL, 0x000fc800078ee22eULL,
0x000140002e277811ULL, 0x000fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe400078e00ffULL, 0x018a00002a227984ULL, 0x000e620000004800ULL,
0x00000040002c7824ULL, 0x000fe400078e022aULL, 0x000000f0262d7812ULL, 0x000fe200078ec0ffULL,
0x018ac00022257984ULL, 0x002e640000004800ULL, 0x0000002516257224ULL, 0x002fc800078e022cULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002d24267210ULL, 0x000fe20007fde0ffULL,
0x000000012a247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102a257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x00014000242f7811ULL, 0x000fe400078e20ffULL, 0x000000022c247810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e8000b901c4cULL,
0x018a08002a227984ULL, 0x000ea80000004800ULL, 0x018ac00022257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24287210ULL, 0x000fe40007fde0ffULL, 0x000000022a247810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe400030e0625ULL, 0x0000000124257824ULL, 0x040fe400078e0203ULL,
0x0000001024247824ULL, 0x000fca00078e00ffULL, 0xfffffff024257812ULL, 0x000fe400078ee225ULL,
0x000000042c247810ULL, 0x040fe40007ffe0ffULL, 0x00014000252f7811ULL, 0x002fe400078e20ffULL,
0x000000062c2c7810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e8000b901c4cULL, 0x018a10002a227984ULL, 0x000ea20000004800ULL,
0x000000062a287810ULL, 0x002fc60007ffe0ffULL, 0x018ac00022257984ULL, 0x004e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24267210ULL, 0x000fe40007fde0ffULL, 0x000000042a247810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x0000000124257824ULL, 0x040fe400078e0203ULL,
0x0000001024247824ULL, 0x000fca00078e00ffULL, 0xfffffff024257812ULL, 0x000fc800078ee225ULL,
0x0001400025297811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c4cULL, 0x018a18002a227984ULL, 0x000ea80000004800ULL,
0x018ac00022257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc400078e022cULL,
0x00000001282c7824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24247210ULL, 0x000fe20007fde0ffULL, 0x00000010282d7824ULL, 0x000fc800078e00ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x000140002c277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2d7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003fc4070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40003000000ULL, 0x000000ff21247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003fc6070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000151c27f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0004e400000e0000ULL, 0x000152227f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000b9e000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0001600000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0000ba5000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00015f9000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006524783bULL, 0x006e620000004200ULL,
0x000000ff2b00720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0001280069407811ULL, 0x000fe200078e20ffULL, 0x000000006428783bULL, 0x000ea80000004200ULL,
0x000000006320783bULL, 0x000fe80000004200ULL, 0x000000006834783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011424ULL, 0x0000010027337824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011428ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x0000002e003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fc40000011429ULL,
0x0000888028847816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888029827816ULL, 0x040fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011428ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000888026287816ULL, 0x040fe200000000ffULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe2000001142eULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7e7819ULL, 0x000fe20000011429ULL, 0x0000010026297824ULL, 0x040fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff2d7819ULL, 0x000fe20000011425ULL, 0x0000003200837306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff6f7819ULL, 0x000fe40000011420ULL,
0x0000888020737816ULL, 0x000fe400000000ffULL, 0x0000888025457816ULL, 0x000fe200000000ffULL,
0x00000033003d7306ULL, 0x000fe20000200c00ULL, 0x0000888027327816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002600337306ULL, 0x0005e20000200c00ULL, 0x0000888035877816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff867819ULL, 0x000fe20000011436ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x044fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011437ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00008880363c7816ULL, 0x000fc400000000ffULL,
0x00000018ff767819ULL, 0x000fe20000011426ULL, 0x0000010034267824ULL, 0x040fe200078e00ffULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011420ULL,
0x0000888034207816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000541044447816ULL, 0x002fe2000000003fULL,
0x0000002e00257306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff6e7819ULL, 0x000fe40000011421ULL, 0x0000888021747816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001142bULL, 0x000088802a797816ULL, 0x000fe400000000ffULL,
0x000088802b777816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011422ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00000018ff667819ULL, 0x000fce0000011423ULL,
0x0000002f003e7306ULL, 0x000e700000200c00ULL, 0x00000027003a7306ULL, 0x0005f00000200c00ULL,
0x00000029002f7306ULL, 0x0007e20000200c00ULL, 0x0000010035277824ULL, 0x004fe200078e00ffULL,
0x0000541045457816ULL, 0x002fe2000000003eULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00008880373e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000028002e7306ULL, 0x0002a20000200c00ULL, 0x000001002b297824ULL, 0x048fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x000000444044723cULL, 0x000f6400000018ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000026007f7306ULL, 0x0002e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000010036267824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011426ULL, 0x00000027008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011436ULL, 0x00000029007c7306ULL, 0x0003f00000200c00ULL,
0x00000028007a7306ULL, 0x0009e20000200c00ULL, 0x0000541024297816ULL, 0x002fe4000000002dULL,
0x00005410322d7816ULL, 0x000fe2000000003dULL, 0x0000010037327824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x0000541025287816ULL, 0x010fe4000000002cULL, 0x000128006a257811ULL, 0x000fe400078e20ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011432ULL, 0x000054102e2c7816ULL, 0x004fe2000000002fULL,
0x00000034003b7306ULL, 0x0007e20000200c00ULL, 0x000000002524783bULL, 0x000eaa0000000200ULL,
0x0000002c402c723cULL, 0x000fe400000018ffULL, 0x0000003500887306ULL, 0x0009e20000200c00ULL,
0x0000541020347816ULL, 0x008fc4000000007fULL, 0x00000018ff207819ULL, 0x000fe40000011437ULL,
0x000054103a317816ULL, 0x002fe20000000031ULL, 0x00000100213a7824ULL, 0x000fe400078e00ffULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000541087357816ULL, 0x010fe2000000008aULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc8000001143aULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x0000541033307816ULL, 0x002fce0000000030ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x000000304030723cULL, 0x000fe200000018ffULL, 0x0000001a2424b232ULL, 0x084fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe20000000000ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000541088397816ULL, 0x010fe20000000039ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000888022887816ULL, 0x000fca00000000ffULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054103e3d7816ULL, 0x004fce000000003dULL, 0x0000003600897306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x00000020008a7306ULL, 0x0004e20000200c00ULL,
0x000000344034723cULL, 0x002fee00000018ffULL, 0x00000021007f7306ULL, 0x0007e20000200c00ULL,
0x0000541089207816ULL, 0x004fe20000000086ULL, 0x0001000022867824ULL, 0x000fcc00078e00ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054108a217816ULL, 0x008fe20000000081ULL,
0x000000ffff817224ULL, 0x000fcc00078e0088ULL, 0x0000008200827306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002a00757306ULL, 0x000ff00000200c00ULL,
0x0000002b00787306ULL, 0x0005f00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0000541082217816ULL, 0x002fc40000000085ULL,
0x00000018ff827819ULL, 0x000fe40000011486ULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000002000227306ULL, 0x0007f00000200c00ULL,
0x0000007900797306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x008fc40000000083ULL,
0x0000888023837816ULL, 0x000fca00000000ffULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000541080207816ULL, 0x024fe2000000007dULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107e217816ULL, 0x002fe2000000007bULL,
0x00000100237b7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fcc0000011423ULL,
0x000000ffff217224ULL, 0x020fe200078e0083ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541079207816ULL, 0x010fce000000007aULL, 0x00000021007d7306ULL, 0x0007f00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541077217816ULL, 0x008fce000000007cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x0000541075207816ULL, 0x024fe40000000072ULL,
0x0000541078217816ULL, 0x002fca0000000071ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541073207816ULL, 0x030fe40000000076ULL, 0x0000541074217816ULL, 0x008fca0000000087ULL,
0x0000007000707306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054107f217816ULL, 0x022fce000000006eULL,
0x0000007b007a7306ULL, 0x000e620000200c00ULL, 0x0000541070207816ULL, 0x004fce000000006fULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541081207816ULL, 0x028fe40000000022ULL,
0x000054107d217816ULL, 0x002fca000000007aULL, 0x0000008200827306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541082207816ULL, 0x022fe4000000006dULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004411117221ULL, 0x000fe40000010000ULL,
0x0000004510107221ULL, 0x000fe40000010000ULL, 0x000000280d0d7221ULL, 0x000fe40000010000ULL,
0x000000290c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x0000003449497221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384d4d7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c51517221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004055557221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460f0f7221ULL, 0x000fe40000010000ULL, 0x000000470e0e7221ULL, 0x000fe40000010000ULL,
0x0000002a0b0b7221ULL, 0x000fc40000010000ULL, 0x0000002b0a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x000000321f1f7221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x000000364b4b7221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e53537221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004257577221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006b6c00720cULL, 0x000fe20003f06070ULL,
0x018b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaa7000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008014217811ULL, 0x020fe200078e40ffULL, 0x018b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005c2100720cULL, 0x000fda0003f06070ULL, 0x0000ac3000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6c7224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x020fe2000001166cULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000036c227812ULL, 0x042fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000000216c217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221257810ULL, 0x000fc80007ffe0ffULL,
0x0000000325217812ULL, 0x040fe400078ec0ffULL, 0x0000001425207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x000fe20007ffe0ffULL,
0x0000099000017945ULL, 0x000fe60003800000ULL, 0x0000005b2400720cULL, 0x000fda0003f06070ULL,
0x0000052000008947ULL, 0x000fea0003800000ULL, 0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000420237824ULL, 0x000fe200078e0221ULL, 0x0000002000297811ULL, 0x000fe200078e30ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000021d317810ULL, 0x000fe20007ffe0ffULL,
0x018a00002a257984ULL, 0x000e620000004800ULL, 0x0000002023237811ULL, 0x000fe200078e30ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000f0262d7812ULL, 0x000fe200078ec0ffULL,
0x000000012a277824ULL, 0x000fe200078e0203ULL, 0x000000235c247217ULL, 0x000fe20007800000ULL,
0x000000102a2c7824ULL, 0x000fc800078e00ffULL, 0x0000000124247824ULL, 0x000fe400078e0a23ULL,
0x000000012a237824ULL, 0x000fc600078e0229ULL, 0x0000000524247c17ULL, 0x000fc8000f800000ULL,
0x8000000524287c10ULL, 0x000fc8000fffe0ffULL, 0x000000281d00720cULL, 0x000fe20003f06070ULL,
0x018ac00025257984ULL, 0x002e640000004800ULL, 0x0000002516237224ULL, 0x002fc800078e0223ULL,
0x00005e0023247625ULL, 0x000fe200078e002bULL, 0xfffffff02c237812ULL, 0x000fe400078ee227ULL,
0x00000005312c7c10ULL, 0x000fe4000fffe0ffULL, 0x0000002d24267210ULL, 0x000fe40007f3e0ffULL,
0x00016000232f7811ULL, 0x000fe200078e20ffULL, 0x000000012c247824ULL, 0x000fe400078e0229ULL,
0x000000ffff277224ULL, 0x000fc400008e0625ULL, 0x000000012c2e7824ULL, 0x000fc600078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000283100720cULL, 0x000fe20003f06070ULL, 0x000000102c317824ULL, 0x000fe400078e00ffULL,
0x018a08002a237984ULL, 0x000ea60000004800ULL, 0xfffffff0312e7812ULL, 0x000fe400078ee22eULL,
0x000000041d317810ULL, 0x000fe40007ffe0ffULL, 0x000160002e2f7811ULL, 0x002fc400078e20ffULL,
0x00000005312c7c10ULL, 0x000fca000fffe0ffULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x018ac00023237984ULL, 0x004e640000004800ULL, 0x0000002316247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x000000012c247824ULL, 0x000fc800078e0229ULL, 0x000000ffff277224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000283100720cULL, 0x000fe20003f06070ULL, 0x000000102c317824ULL, 0x000fe400078e00ffULL,
0x018a10002a237984ULL, 0x000ea60000004800ULL, 0xfffffff0312e7812ULL, 0x000fe400078ee22eULL,
0x000000061d317810ULL, 0x000fe40007ffe0ffULL, 0x000160002e2f7811ULL, 0x002fc400078e20ffULL,
0x00000005312c7c10ULL, 0x000fe2000fffe0ffULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24267210ULL, 0x000fe20007f3e0ffULL, 0x000000012c247824ULL, 0x040fe400078e0229ULL,
0x000000012c297824ULL, 0x040fe400078e0203ULL, 0x000000ffff277224ULL, 0x000fe400008e0625ULL,
0x000000102c2c7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0xfffffff02c297812ULL, 0x000fe200078ee229ULL, 0x018a18002a237984ULL, 0x000ea60000004800ULL,
0x0001600029297811ULL, 0x000fe200078e20ffULL, 0x018ac00023237984ULL, 0x004ea40000004800ULL,
0x0000002316247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e2000c101c4cULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003257824ULL, 0x000fe200078e00ffULL, 0x00000020002b7811ULL, 0x000fe200078e30ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x018a00002a237984ULL, 0x000e620000004800ULL,
0x000000f0252f7812ULL, 0x000fe200078ec0ffULL, 0x000000012a247824ULL, 0x040fe400078e022bULL,
0x000000012a277824ULL, 0x000fc400078e0203ULL, 0x000000102a287824ULL, 0x000fe200078e00ffULL,
0x018ac00023237984ULL, 0x002e640000004800ULL, 0x0000002316247224ULL, 0x002fe400078e0224ULL,
0xfffffff028237812ULL, 0x000fe400078ee227ULL, 0x000000022a287810ULL, 0x000fe20007ffe0ffULL,
0x00005e0024247625ULL, 0x000fe200078e002dULL, 0x0001600023317811ULL, 0x000fc600078e20ffULL,
0x0000000128297824ULL, 0x000fe200078e0203ULL, 0x0000002f24267210ULL, 0x000fe20007f1e0ffULL,
0x000000012b247824ULL, 0x000fe400078e0228ULL, 0x00000010282c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c4cULL, 0x018a08002a237984ULL, 0x000ea20000004800ULL,
0x000000042a267810ULL, 0x002fca0007ffe0ffULL, 0x0000000126277824ULL, 0x000fe200078e0203ULL,
0x018ac00023237984ULL, 0x004e640000004800ULL, 0x0000002316247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02c247812ULL, 0x000fe200078ee229ULL, 0x00000010262c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x000fe200000e0625ULL, 0x0001600024317811ULL, 0x000fe200078e20ffULL,
0x000000012b247824ULL, 0x000fc800078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c4cULL, 0x018a10002a237984ULL, 0x000ea20000004800ULL,
0x000000062a287810ULL, 0x002fc60007ffe0ffULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02c247812ULL, 0x000fc600078ee227ULL,
0x000000ffff277224ULL, 0x000fe200000e0625ULL, 0x0001600024297811ULL, 0x000fe200078e20ffULL,
0x000000012b247824ULL, 0x000fe400078e0228ULL, 0x00000001282b7824ULL, 0x040fe400078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e2000b901c4cULL,
0x0000001028287824ULL, 0x000fc600078e00ffULL, 0x018a18002a237984ULL, 0x000ea40000004800ULL,
0xfffffff0282b7812ULL, 0x000fc800078ee22bULL, 0x000160002b2b7811ULL, 0x000fe200078e20ffULL,
0x018ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002316247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242b7faeULL, 0x0003e6000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe20003f04070ULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000032200780cULL, 0x000fda0003f25270ULL, 0x0000010000008947ULL, 0x000fea0000800000ULL,
0x000000031700780cULL, 0x000fe40003f04070ULL, 0x0000000115157810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x0000005a1500720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0217ULL, 0x0000640015247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00018ac017237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00018a0017237811ULL, 0x040fe200078e10ffULL, 0x0000000117217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x0000005c2100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff6c00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6d7224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b1800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x018b1c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b1c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0181000027227984ULL, 0x000e680000000800ULL, 0x0183000027237984ULL, 0x0004e20000000800ULL,
0x000000132200720bULL, 0x002fe20003f1d000ULL, 0x000127a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0013ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x000000132200720bULL, 0x000fe20003f34000ULL,
0x000127727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002213247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0185002427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002413137221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300297308ULL, 0x000e640000000800ULL, 0x0000002912127220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000126d27f007947ULL, 0x000fea000b800000ULL,
0x00001f6229137589ULL, 0x0002a400000e0000ULL, 0x0000001311117220ULL, 0x084fe40000410000ULL,
0x0000001310107220ULL, 0x080fe40000410000ULL, 0x000000130d0d7220ULL, 0x080fe40000410000ULL,
0x000000130c0c7220ULL, 0x080fe40000410000ULL, 0x0000001309097220ULL, 0x080fe40000410000ULL,
0x0000001308087220ULL, 0x000fc40000410000ULL, 0x0000001305057220ULL, 0x080fe40000410000ULL,
0x0000001304047220ULL, 0x080fe40000410000ULL, 0x0000001349497220ULL, 0x080fe40000410000ULL,
0x000000134a4a7220ULL, 0x080fe40000410000ULL, 0x000000134d4d7220ULL, 0x080fe40000410000ULL,
0x000000134e4e7220ULL, 0x000fc40000410000ULL, 0x0000001351517220ULL, 0x080fe40000410000ULL,
0x0000001352527220ULL, 0x080fe40000410000ULL, 0x0000001355557220ULL, 0x080fe40000410000ULL,
0x0000001356567220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000126027f007947ULL, 0x000fea000b800000ULL, 0x00001f6129137589ULL, 0x00046400000e0000ULL,
0x000000130f0f7220ULL, 0x082fe40000410000ULL, 0x000000130e0e7220ULL, 0x080fe40000410000ULL,
0x000000130b0b7220ULL, 0x080fe40000410000ULL, 0x000000130a0a7220ULL, 0x080fe40000410000ULL,
0x0000001307077220ULL, 0x080fe40000410000ULL, 0x0000001306067220ULL, 0x000fc40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x0000001348487220ULL, 0x080fe40000410000ULL,
0x000000134b4b7220ULL, 0x080fe40000410000ULL, 0x000000134c4c7220ULL, 0x080fe40000410000ULL,
0x000000134f4f7220ULL, 0x080fe40000410000ULL, 0x0000001350507220ULL, 0x000fc40000410000ULL,
0x0000001353537220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001357577220ULL, 0x080fe40000410000ULL, 0x0000001358587220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2aff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200190308ULL, 0x000e640000000800ULL,
0x0000001923230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001223127221ULL, 0x008fe40000010000ULL, 0x000000ffff137224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000124627f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0002e400000e0000ULL,
0x000124c27f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000e9f000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00012ff000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x0000ea6000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00012f8000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x000130005f407811ULL, 0x000fe200078e20ffULL,
0x00000f9000017945ULL, 0x000fe20003800000ULL, 0x0000006c6200720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000145900720cULL, 0x000fc40003fc3070ULL,
0x0000006c6100720cULL, 0x000fe20003f26070ULL, 0x000000005d28783bULL, 0x000fe20000004200ULL,
0x000000145900720cULL, 0x000fc60003f03070ULL, 0x000000005e34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x0000888020327816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000888021467816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011425ULL, 0x0000888025817816ULL, 0x000fe200000000ffULL,
0x00000020003d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001a4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x0000001b4141b232ULL, 0x080fe20000000000ULL, 0x0000888024827816ULL, 0x000fe200000000ffULL,
0x0000002d00477306ULL, 0x000fe20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011423ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fc40000011426ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002c003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011427ULL,
0x0000888026797816ULL, 0x000fe400000000ffULL, 0x0000888027787816ULL, 0x000fe400000000ffULL,
0x00008880343a7816ULL, 0x000fe200000000ffULL, 0x00000020002d7306ULL, 0x0005e20000200c00ULL,
0x00000100252c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011422ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011434ULL,
0x00000018ff847819ULL, 0x000fe2000001142cULL, 0x00010000242c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000010027207824ULL, 0x044fe200078e00ffULL,
0x0000002e00837306ULL, 0x0003e20000200c00ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe4000001142cULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00008880222c7816ULL, 0x040fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000020007b7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x002fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011436ULL, 0x0000002100247306ULL, 0x0003e20000200c00ULL,
0x0000010028207824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011437ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000010023217824ULL, 0x002fe200078e00ffULL, 0x0000888035867816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x00000025007f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff717819ULL, 0x000fe20000011428ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000010026257824ULL, 0x002fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888028747816ULL, 0x000fc400000000ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff707819ULL, 0x000fe40000011429ULL,
0x0000888029887816ULL, 0x000fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001142aULL,
0x00000023003e7306ULL, 0x0002a20000200c00ULL, 0x000054103d447816ULL, 0x008fc40000000044ULL,
0x00008880373d7816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fc6000001142bULL,
0x00000025007a7306ULL, 0x0007e20000200c00ULL, 0x0000010036237824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0001300060257811ULL, 0x008fe400078e20ffULL, 0x000054103e317816ULL, 0x004fe40000000031ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x0000002000857306ULL, 0x0002b00000200c00ULL,
0x0000002600767306ULL, 0x000fe20000200c00ULL, 0x0000541032207816ULL, 0x002fe2000000003fULL,
0x0000010037327824ULL, 0x040fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011423ULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe20000011432ULL,
0x0000002700777306ULL, 0x0003f00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000000002524783bULL, 0x002e6e0000000200ULL, 0x00000021002f7306ULL, 0x0009f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x0000010035217824ULL, 0x010fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000034003b7306ULL, 0x0009e20000200c00ULL,
0x0001000035227824ULL, 0x004fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000054103a347816ULL, 0x010fe20000000085ULL,
0x00010000283a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fca0000011437ULL,
0x0000002100357306ULL, 0x0006a20000200c00ULL, 0x0000001a2424b232ULL, 0x082fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe40000000000ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000002c002c7306ULL, 0x000e620000200c00ULL,
0x0000541046217816ULL, 0x008fe40000000047ULL, 0x000000444044723cULL, 0x000fea00000018ffULL,
0x0000003000307306ULL, 0x000ee20000200c00ULL, 0x0000541086357816ULL, 0x004fe20000000035ULL,
0x0000010029867824ULL, 0x000fc400078e00ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x000054102c2c7816ULL, 0x002fe4000000002dULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x008fce0000000030ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x004fe20000000038ULL,
0x000000304030723cULL, 0x040fec00000018ffULL, 0x00000022007e7306ULL, 0x0004f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000000204020723cULL, 0x004f6200000018ffULL,
0x000054102e2d7816ULL, 0x002fcc000000002fULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000054107e397816ULL, 0x008fe20000000039ULL, 0x0000002c402c723cULL, 0x000f6200000018ffULL,
0x00000018ff7e7819ULL, 0x000fca000001143aULL, 0x0000003d003d7306ULL, 0x000fe40000200c00ULL,
0x000000384038723cULL, 0x000fec00000018ffULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003fULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000003eULL,
0x0000003600877306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008500287306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541087667816ULL, 0x004fce0000000066ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541028677816ULL, 0x008fce0000000067ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000000664040723cULL, 0x000b6200000018ffULL,
0x0000541082287816ULL, 0x002fcc0000000083ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000088802a667816ULL, 0x020fce00000000ffULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000002900677306ULL, 0x0005f00000200c00ULL,
0x0000007900797306ULL, 0x000ee20000200c00ULL, 0x0000541081297816ULL, 0x004fe20000000084ULL,
0x000001002a817824ULL, 0x000fc400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x000000282420723cULL, 0x000b620000001820ULL, 0x00000018ff2a7819ULL, 0x000fcc000001142aULL,
0x0000541080287816ULL, 0x022fe2000000007dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000054107f297816ULL, 0x000fe4000000007cULL, 0x000088802b7c7816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x0000541079287816ULL, 0x028fe2000000007aULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078297816ULL, 0x004fe2000000007bULL, 0x000001002b787824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008800857306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e007cULL, 0x0000541077297816ULL, 0x002fcc0000000072ULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002800797306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541076287816ULL, 0x008fce0000000073ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x0000541074287816ULL, 0x024fe40000000075ULL,
0x0000541085297816ULL, 0x002fca0000000086ULL, 0x0000006600667306ULL, 0x000fe40000200c00ULL,
0x000000282434723cULL, 0x000b6c0000001834ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x000054107e287816ULL, 0x028fe40000000071ULL, 0x0000541067297816ULL, 0x000fca0000000070ULL,
0x0000007800787306ULL, 0x000ea40000200c00ULL, 0x000000282438723cULL, 0x000b6c0000001838ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541066287816ULL, 0x022fe40000000081ULL,
0x000000016c667810ULL, 0x000fc80007ffe0ffULL, 0x000000666200720cULL, 0x080fe20005746470ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541079297816ULL, 0x004fe40000000078ULL,
0x000000666100720cULL, 0x000fca0004f26470ULL, 0x0000002a002a7306ULL, 0x000e620000200c00ULL,
0x00000028243c723cULL, 0x000b6e000000183cULL, 0x0000002b002b7306ULL, 0x000ea20000200c00ULL,
0x000054102a287816ULL, 0x022fe4000000006fULL, 0x000054102b297816ULL, 0x004fce000000006eULL,
0x000000282440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000002011117221ULL, 0x000fe40000010000ULL,
0x0000002110107221ULL, 0x000fe40000010000ULL, 0x000000440d0d7221ULL, 0x000fe40000010000ULL,
0x000000450c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x0000003449497221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384d4d7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c51517221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004055557221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220f0f7221ULL, 0x000fe40000010000ULL, 0x000000230e0e7221ULL, 0x000fe40000010000ULL,
0x000000460b0b7221ULL, 0x000fc40000010000ULL, 0x000000470a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x000000321f1f7221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x000000364b4b7221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e53537221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004257577221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011666ULL,
0x000000ffff287224ULL, 0x020fe200078e00ffULL, 0x000000145900720cULL, 0x080fe40003fc3070ULL,
0x0000002366237207ULL, 0x040fe40002800000ULL, 0x0000000366667812ULL, 0x000fe400078ec0ffULL,
0x0000000223257810ULL, 0x000fe40007ffe0ffULL, 0x000000145900720cULL, 0x000fc40003f03070ULL,
0x00000040ff2b7803ULL, 0x000fe40000000000ULL, 0x0000000325237812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2d7224ULL, 0x002fe200078e0021ULL, 0x000000ff66217207ULL, 0x000fe40006800000ULL,
0x0000001425207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8400ff227984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c486dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120227810ULL, 0x000fe20007ffe0ffULL, 0x0000097000017945ULL, 0x000fe60003800000ULL,
0x0000005b2200720cULL, 0x000fda0003fc6070ULL, 0x000005100000e947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x040fe2000fffe0ffULL, 0x0000000420277824ULL, 0x000fe200078e0223ULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2e7424ULL, 0x000fe400078e00ffULL,
0x018a00002c227984ULL, 0x000e620000004800ULL, 0x0000004027277824ULL, 0x000fe200078e00ffULL,
0x00000005312a7c10ULL, 0x000fe2000fffe0ffULL, 0x00000040002d7824ULL, 0x000fe400078e022cULL,
0x0000001003267824ULL, 0x000fc400078e00ffULL, 0x000000012a307824ULL, 0x000fc600078e0203ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x000000012c267824ULL, 0x000fe200078e0203ULL,
0x018ac00022257984ULL, 0x0022a40000004800ULL, 0x000000275c227217ULL, 0x002fca0007800000ULL,
0x0000000122227824ULL, 0x000fe400078e0a27ULL, 0x000000102c277824ULL, 0x000fc600078e00ffULL,
0x0000000522227c17ULL, 0x000fe4000f800000ULL, 0xfffffff027267812ULL, 0x000fe400078ee226ULL,
0x8000000522227c10ULL, 0x000fe4000fffe0ffULL, 0x0001400026297811ULL, 0x000fe400078e20ffULL,
0x000000022d267810ULL, 0x000fe20007ffe0ffULL, 0x0000002516257224ULL, 0x004fc800078e022dULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002f24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000221d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000f101c4cULL,
0x018a08002c287984ULL, 0x000ea20000004800ULL, 0x000000102a257824ULL, 0x002fe200078e00ffULL,
0x000000042d247810ULL, 0x040fe40007ffe0ffULL, 0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0001400030337811ULL, 0x000fe200078e20ffULL,
0x018ac00028277984ULL, 0x004e640000004800ULL, 0x0000002716277224ULL, 0x002fc800078e0226ULL,
0x00005e0027267625ULL, 0x000fca00078e002eULL, 0x0000002f26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000223100720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026337faeULL, 0x0003e8000f101c4cULL,
0x018a10002c2a7984ULL, 0x000ea80000004800ULL, 0x018ac0002a257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24287210ULL, 0x000fca0007fde0ffULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x000000041d257810ULL, 0x000fc80007ffe0ffULL, 0x0000000525247c10ULL, 0x040fe4000fffe0ffULL,
0x000000222500720cULL, 0x000fc60003fc6070ULL, 0x0000000124307824ULL, 0x040fe400078e0203ULL,
0x0000001024277824ULL, 0x002fca00078e00ffULL, 0xfffffff027307812ULL, 0x000fc800078ee230ULL,
0x0001400030277811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e8000f101c4cULL, 0x018a18002c267984ULL, 0x000ea80000004800ULL,
0x018ac00026257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fe200078e022dULL,
0x000000061d2d7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0025247625ULL, 0x000fe200078e002eULL,
0x000000052d2a7c10ULL, 0x000fc8000fffe0ffULL, 0x0000002f24247210ULL, 0x000fe20007fde0ffULL,
0x000000012a2e7824ULL, 0x040fe400078e0203ULL, 0x000000102a277824ULL, 0x002fe400078e00ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000222d00720cULL, 0x000fe40003fc6070ULL,
0xfffffff0272e7812ULL, 0x000fc800078ee22eULL, 0x000140002e277811ULL, 0x000fce00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000f101c4cULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2e7424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe400078e00ffULL,
0x018a00002a227984ULL, 0x000e620000004800ULL, 0x00000040002c7824ULL, 0x000fe400078e022aULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x018ac00022257984ULL, 0x002e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e022cULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24267210ULL, 0x000fe20007fde0ffULL, 0x000000012a247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102a257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x00014000242f7811ULL, 0x000fe400078e20ffULL,
0x000000022c247810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c4cULL, 0x018a08002a227984ULL, 0x000ea80000004800ULL,
0x018ac00022257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002d24287210ULL, 0x000fe40007fde0ffULL,
0x000000022a247810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff297224ULL, 0x000fe400030e0625ULL,
0x0000000124257824ULL, 0x040fe400078e0203ULL, 0x0000001024247824ULL, 0x000fca00078e00ffULL,
0xfffffff024257812ULL, 0x000fe400078ee225ULL, 0x000000042c247810ULL, 0x040fe40007ffe0ffULL,
0x00014000252f7811ULL, 0x002fe400078e20ffULL, 0x000000062c2c7810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e8000b901c4cULL,
0x018a10002a227984ULL, 0x000ea20000004800ULL, 0x000000062a287810ULL, 0x002fc60007ffe0ffULL,
0x018ac00022257984ULL, 0x004e640000004800ULL, 0x0000002516257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002d24267210ULL, 0x000fe40007fde0ffULL,
0x000000042a247810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x0000000124257824ULL, 0x040fe400078e0203ULL, 0x0000001024247824ULL, 0x000fca00078e00ffULL,
0xfffffff024257812ULL, 0x000fc800078ee225ULL, 0x0001400025297811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c4cULL,
0x018a18002a227984ULL, 0x000ea80000004800ULL, 0x018ac00022257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc400078e022cULL, 0x00000001282c7824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002d24247210ULL, 0x000fe20007fde0ffULL,
0x00000010282d7824ULL, 0x000fc800078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL, 0x000140002c277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e4000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff2d7224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe40003fc4070ULL,
0x00018a0017257811ULL, 0x000fe400078e10ffULL, 0x000000ff21227207ULL, 0x000fc40003000000ULL,
0x000000ff21247207ULL, 0x000fc60007000000ULL, 0x0000000123237824ULL, 0x000fc800078e0222ULL,
0x0000004023217824ULL, 0x040fe200078e00ffULL, 0x0000002023207211ULL, 0x000fc800078ff0ffULL,
0x000000c021217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL, 0x0000002020227810ULL, 0x000fca0007ffe0ffULL,
0x0000000117237824ULL, 0x100fe400078e0222ULL, 0x0000680021207a24ULL, 0x000fe400078e0222ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x0000005c2300720cULL, 0x000fe20003fc6070ULL,
0x0000000117207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff667f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000ff427f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0004e400000e0000ULL,
0x0000ffa27f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001101000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000109d000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x0001108000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0001096000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006524783bULL, 0x006e620000004200ULL, 0x000000ff2b00720cULL, 0x000fe20003fc5270ULL,
0x00000f4000017945ULL, 0x000fe20003800000ULL, 0x0001300069407811ULL, 0x000fe200078e20ffULL,
0x000000006428783bULL, 0x000ea80000004200ULL, 0x000000006320783bULL, 0x000fe80000004200ULL,
0x000000006834783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000100242e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011424ULL,
0x0000010027337824ULL, 0x000fe200078e00ffULL, 0x0000888024447816ULL, 0x000fe200000000ffULL,
0x0000010028327824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011428ULL,
0x00000100252f7824ULL, 0x000fe200078e00ffULL, 0x0000002e003f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fc40000011429ULL, 0x0000888028847816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x0000888029827816ULL, 0x040fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x00000100292e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011428ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000888026287816ULL, 0x040fe200000000ffULL,
0x0000001a4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe2000001142eULL,
0x0000001a4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff7e7819ULL, 0x000fe20000011429ULL,
0x0000010026297824ULL, 0x040fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000001b4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0000001b4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff2d7819ULL, 0x000fe20000011425ULL,
0x0000003200837306ULL, 0x0005e20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff6f7819ULL, 0x000fe40000011420ULL, 0x0000888020737816ULL, 0x000fe400000000ffULL,
0x0000888025457816ULL, 0x000fe200000000ffULL, 0x00000033003d7306ULL, 0x000fe20000200c00ULL,
0x0000888027327816ULL, 0x044fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000002600337306ULL, 0x0005e20000200c00ULL,
0x0000888035877816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00000018ff867819ULL, 0x000fe20000011436ULL,
0x0000002d002d7306ULL, 0x000fe20000200c00ULL, 0x0000010020267824ULL, 0x044fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011437ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00008880363c7816ULL, 0x000fc400000000ffULL, 0x00000018ff767819ULL, 0x000fe20000011426ULL,
0x0000010034267824ULL, 0x040fe200078e00ffULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00000018ff707819ULL, 0x000fe40000011420ULL, 0x0000888034207816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000541044447816ULL, 0x002fe2000000003fULL, 0x0000002e00257306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff6e7819ULL, 0x000fe40000011421ULL,
0x0000888021747816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x000fe2000001142aULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fe4000001142bULL,
0x000088802a797816ULL, 0x000fe400000000ffULL, 0x000088802b777816ULL, 0x000fc400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011422ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00000018ff667819ULL, 0x000fce0000011423ULL, 0x0000002f003e7306ULL, 0x000e700000200c00ULL,
0x00000027003a7306ULL, 0x0005f00000200c00ULL, 0x00000029002f7306ULL, 0x0007e20000200c00ULL,
0x0000010035277824ULL, 0x004fe200078e00ffULL, 0x0000541045457816ULL, 0x002fe2000000003eULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00008880373e7816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000028002e7306ULL, 0x0002a20000200c00ULL,
0x000001002b297824ULL, 0x048fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x000000444044723cULL, 0x000f6400000018ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000001002a287824ULL, 0x042fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000026007f7306ULL, 0x0002e20000200c00ULL, 0x00000018ff2a7819ULL, 0x000fce000001142aULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000010036267824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011426ULL,
0x00000027008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fce0000011436ULL,
0x00000029007c7306ULL, 0x0003f00000200c00ULL, 0x00000028007a7306ULL, 0x0009e20000200c00ULL,
0x0000541024297816ULL, 0x002fe4000000002dULL, 0x00005410322d7816ULL, 0x000fe2000000003dULL,
0x0000010037327824ULL, 0x000fc400078e00ffULL, 0x0001000037377824ULL, 0x000fe400078e00ffULL,
0x0000003100317306ULL, 0x000e620000200c00ULL, 0x0000541025287816ULL, 0x010fe4000000002cULL,
0x000130006a257811ULL, 0x000fe400078e20ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011432ULL,
0x000054102e2c7816ULL, 0x004fe2000000002fULL, 0x00000034003b7306ULL, 0x0007e20000200c00ULL,
0x000000002524783bULL, 0x000eaa0000000200ULL, 0x0000002c402c723cULL, 0x000fe400000018ffULL,
0x0000003500887306ULL, 0x0009e20000200c00ULL, 0x0000541020347816ULL, 0x008fc4000000007fULL,
0x00000018ff207819ULL, 0x000fe40000011437ULL, 0x000054103a317816ULL, 0x002fe20000000031ULL,
0x00000100213a7824ULL, 0x000fe400078e00ffULL, 0x0000003000307306ULL, 0x000e620000200c00ULL,
0x0000541087357816ULL, 0x010fe2000000008aULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc8000001143aULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000003800387306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x0000541033307816ULL, 0x002fce0000000030ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x000000304030723cULL, 0x000fe200000018ffULL,
0x0000001a2424b232ULL, 0x084fe40000000000ULL, 0x0000001a2626b232ULL, 0x000fe40000000000ULL,
0x0000001b2525b232ULL, 0x080fe20000000000ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000541088397816ULL, 0x010fe20000000039ULL, 0x0000001b2727b232ULL, 0x000fe20000000000ULL,
0x0000888022887816ULL, 0x000fca00000000ffULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000000384038723cULL, 0x000fee00000018ffULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003fULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000054103e3d7816ULL, 0x004fce000000003dULL,
0x0000003600897306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x00000020008a7306ULL, 0x0004e20000200c00ULL, 0x000000344034723cULL, 0x002fee00000018ffULL,
0x00000021007f7306ULL, 0x0007e20000200c00ULL, 0x0000541089207816ULL, 0x004fe20000000086ULL,
0x0001000022867824ULL, 0x000fcc00078e00ffULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000054108a217816ULL, 0x008fe20000000081ULL, 0x000000ffff817224ULL, 0x000fcc00078e0088ULL,
0x0000008200827306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000002a00757306ULL, 0x000ff00000200c00ULL, 0x0000002b00787306ULL, 0x0005f00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000000284028723cULL, 0x044f6e00000018ffULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000000204040723cULL, 0x000b6e00000018ffULL,
0x0000010022207824ULL, 0x020fe200078e00ffULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541082217816ULL, 0x002fc40000000085ULL, 0x00000018ff827819ULL, 0x000fe40000011486ULL,
0x00000018ff207819ULL, 0x000fc60000011420ULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000002000227306ULL, 0x0007f00000200c00ULL, 0x0000007900797306ULL, 0x000f220000200c00ULL,
0x0000541084207816ULL, 0x008fc40000000083ULL, 0x0000888023837816ULL, 0x000fca00000000ffULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x000000202444723cULL, 0x000b6e0000001844ULL,
0x0000541080207816ULL, 0x024fe2000000007dULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054107e217816ULL, 0x002fe2000000007bULL, 0x00000100237b7824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff237819ULL, 0x000fcc0000011423ULL, 0x000000ffff217224ULL, 0x020fe200078e0083ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541079207816ULL, 0x010fce000000007aULL,
0x00000021007d7306ULL, 0x0007f00000200c00ULL, 0x0000007600767306ULL, 0x000f220000200c00ULL,
0x0000541077217816ULL, 0x008fce000000007cULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000008700877306ULL, 0x000ee20000200c00ULL,
0x0000541075207816ULL, 0x024fe40000000072ULL, 0x0000541078217816ULL, 0x002fca0000000071ULL,
0x0000006f006f7306ULL, 0x000fe40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541073207816ULL, 0x030fe40000000076ULL,
0x0000541074217816ULL, 0x008fca0000000087ULL, 0x0000007000707306ULL, 0x000ea40000200c00ULL,
0x000000202434723cULL, 0x000b6c0000001834ULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x000054107f217816ULL, 0x022fce000000006eULL, 0x0000007b007a7306ULL, 0x000e620000200c00ULL,
0x0000541070207816ULL, 0x004fce000000006fULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000000202438723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541081207816ULL, 0x028fe40000000022ULL, 0x000054107d217816ULL, 0x002fca000000007aULL,
0x0000008200827306ULL, 0x000e640000200c00ULL, 0x00000020243c723cULL, 0x000b6c000000183cULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541082207816ULL, 0x022fe4000000006dULL,
0x0000541023217816ULL, 0x004fce0000000066ULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000004411117221ULL, 0x000fe40000010000ULL, 0x0000004510107221ULL, 0x000fe40000010000ULL,
0x000000280d0d7221ULL, 0x000fe40000010000ULL, 0x000000290c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x0000003449497221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384d4d7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c51517221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004055557221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000460f0f7221ULL, 0x000fe40000010000ULL,
0x000000470e0e7221ULL, 0x000fe40000010000ULL, 0x0000002a0b0b7221ULL, 0x000fc40000010000ULL,
0x0000002b0a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x000000321f1f7221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x000000364b4b7221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e53537221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004257577221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006b6c00720cULL, 0x000fe20003f06070ULL, 0x018b8800ff227f8cULL, 0x000e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaa7000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c014217811ULL, 0x020fe200078e40ffULL,
0x018b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005c2100720cULL, 0x000fda0003f06070ULL,
0x0000560000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe2000001166cULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036c227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000000216c217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000321257810ULL, 0x000fc80007ffe0ffULL, 0x0000000325217812ULL, 0x040fe400078ec0ffULL,
0x0000001425207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x000fe20007ffe0ffULL, 0x0000099000017945ULL, 0x000fe60003800000ULL,
0x0000005b2400720cULL, 0x000fda0003f06070ULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000420237824ULL, 0x000fe200078e0221ULL,
0x0000002000297811ULL, 0x000fe200078e30ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x018a00002a257984ULL, 0x000e620000004800ULL,
0x0000002023237811ULL, 0x000fe200078e30ffULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a277824ULL, 0x000fe200078e0203ULL,
0x000000235c247217ULL, 0x000fe20007800000ULL, 0x000000102a2c7824ULL, 0x000fc800078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e0a23ULL, 0x000000012a237824ULL, 0x000fc600078e0229ULL,
0x0000000524247c17ULL, 0x000fc8000f800000ULL, 0x8000000524287c10ULL, 0x000fc8000fffe0ffULL,
0x000000281d00720cULL, 0x000fe20003f06070ULL, 0x018ac00025257984ULL, 0x002e640000004800ULL,
0x0000002516237224ULL, 0x002fc800078e0223ULL, 0x00005e0023247625ULL, 0x000fe200078e002bULL,
0xfffffff02c237812ULL, 0x000fe400078ee227ULL, 0x00000005312c7c10ULL, 0x000fe4000fffe0ffULL,
0x0000002d24267210ULL, 0x000fe40007f3e0ffULL, 0x00016000232f7811ULL, 0x000fe200078e20ffULL,
0x000000012c247824ULL, 0x000fe400078e0229ULL, 0x000000ffff277224ULL, 0x000fc400008e0625ULL,
0x000000012c2e7824ULL, 0x000fc600078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000283100720cULL, 0x000fe20003f06070ULL,
0x000000102c317824ULL, 0x000fe400078e00ffULL, 0x018a08002a237984ULL, 0x000ea60000004800ULL,
0xfffffff0312e7812ULL, 0x000fe400078ee22eULL, 0x000000041d317810ULL, 0x000fe40007ffe0ffULL,
0x000160002e2f7811ULL, 0x002fc400078e20ffULL, 0x00000005312c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24267210ULL, 0x000fe20007f3e0ffULL, 0x000000012c247824ULL, 0x000fc800078e0229ULL,
0x000000ffff277224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c4cULL, 0x000000283100720cULL, 0x000fe20003f06070ULL,
0x000000102c317824ULL, 0x000fe400078e00ffULL, 0x018a10002a237984ULL, 0x000ea60000004800ULL,
0xfffffff0312e7812ULL, 0x000fe400078ee22eULL, 0x000000061d317810ULL, 0x000fe40007ffe0ffULL,
0x000160002e2f7811ULL, 0x002fc400078e20ffULL, 0x00000005312c7c10ULL, 0x000fe2000fffe0ffULL,
0x018ac00023237984ULL, 0x004e640000004800ULL, 0x0000002316247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24267210ULL, 0x000fe20007f3e0ffULL,
0x000000012c247824ULL, 0x040fe400078e0229ULL, 0x000000012c297824ULL, 0x040fe400078e0203ULL,
0x000000ffff277224ULL, 0x000fe400008e0625ULL, 0x000000102c2c7824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c4cULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0xfffffff02c297812ULL, 0x000fe200078ee229ULL,
0x018a18002a237984ULL, 0x000ea60000004800ULL, 0x0001600029297811ULL, 0x000fe200078e20ffULL,
0x018ac00023237984ULL, 0x004ea40000004800ULL, 0x0000002316247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff257224ULL, 0x000fca00008e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e2000c101c4cULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003257824ULL, 0x000fe200078e00ffULL,
0x00000020002b7811ULL, 0x000fe200078e30ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x018a00002a237984ULL, 0x000e620000004800ULL, 0x000000f0252f7812ULL, 0x000fe200078ec0ffULL,
0x000000012a247824ULL, 0x040fe400078e022bULL, 0x000000012a277824ULL, 0x000fc400078e0203ULL,
0x000000102a287824ULL, 0x000fe200078e00ffULL, 0x018ac00023237984ULL, 0x002e640000004800ULL,
0x0000002316247224ULL, 0x002fe400078e0224ULL, 0xfffffff028237812ULL, 0x000fe400078ee227ULL,
0x000000022a287810ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x000fe200078e002dULL,
0x0001600023317811ULL, 0x000fc600078e20ffULL, 0x0000000128297824ULL, 0x000fe200078e0203ULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012b247824ULL, 0x000fe400078e0228ULL,
0x00000010282c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c4cULL,
0x018a08002a237984ULL, 0x000ea20000004800ULL, 0x000000042a267810ULL, 0x002fca0007ffe0ffULL,
0x0000000126277824ULL, 0x000fe200078e0203ULL, 0x018ac00023237984ULL, 0x004e640000004800ULL,
0x0000002316247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24287210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02c247812ULL, 0x000fe200078ee229ULL,
0x00000010262c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff297224ULL, 0x000fe200000e0625ULL,
0x0001600024317811ULL, 0x000fe200078e20ffULL, 0x000000012b247824ULL, 0x000fc800078e0226ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e8000b901c4cULL,
0x018a10002a237984ULL, 0x000ea20000004800ULL, 0x000000062a287810ULL, 0x002fc60007ffe0ffULL,
0x018ac00023237984ULL, 0x004e640000004800ULL, 0x0000002316247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02c247812ULL, 0x000fc600078ee227ULL, 0x000000ffff277224ULL, 0x000fe200000e0625ULL,
0x0001600024297811ULL, 0x000fe200078e20ffULL, 0x000000012b247824ULL, 0x000fe400078e0228ULL,
0x00000001282b7824ULL, 0x040fe400078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e2000b901c4cULL, 0x0000001028287824ULL, 0x000fc600078e00ffULL,
0x018a18002a237984ULL, 0x000ea40000004800ULL, 0xfffffff0282b7812ULL, 0x000fc800078ee22bULL,
0x000160002b2b7811ULL, 0x000fe200078e20ffULL, 0x018ac00023237984ULL, 0x004ea40000004800ULL,
0x0000002316247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e6000b901c4cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe20003f04070ULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000032200780cULL, 0x000fda0003f25270ULL,
0x0000010000008947ULL, 0x000fea0000800000ULL, 0x000000031700780cULL, 0x000fe40003f04070ULL,
0x0000000115157810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x0000005a1500720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0217ULL,
0x0000640015247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00018ac017237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00018a0017237811ULL, 0x040fe200078e10ffULL,
0x0000000117217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x0000005c2100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000117207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c12184cULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff6c00720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6d7224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b3800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff277224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x018b3c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220257210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011423ULL,
0x0000002518187211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000218187819ULL, 0x000fc80000001223ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x018b3c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011603ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c20217812ULL, 0x000fca00078ec0ffULL,
0x0000000118277824ULL, 0x000fca00078e0221ULL, 0x0181800027227984ULL, 0x000e680000000800ULL,
0x0183800027237984ULL, 0x0004e20000000800ULL, 0x000000132200720bULL, 0x002fe20003f1d000ULL,
0x0000d5227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0013ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f05270ULL,
0x000000132200720bULL, 0x000fe20003f34000ULL, 0x0000d4f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002213247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0185802427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002413137221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300297308ULL, 0x000e640000000800ULL,
0x0000002912127220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000d4527f007947ULL, 0x000fea000b800000ULL, 0x00001f6229137589ULL, 0x0002a400000e0000ULL,
0x0000001311117220ULL, 0x084fe40000410000ULL, 0x0000001310107220ULL, 0x080fe40000410000ULL,
0x000000130d0d7220ULL, 0x080fe40000410000ULL, 0x000000130c0c7220ULL, 0x080fe40000410000ULL,
0x0000001309097220ULL, 0x080fe40000410000ULL, 0x0000001308087220ULL, 0x000fc40000410000ULL,
0x0000001305057220ULL, 0x080fe40000410000ULL, 0x0000001304047220ULL, 0x080fe40000410000ULL,
0x0000001349497220ULL, 0x080fe40000410000ULL, 0x000000134a4a7220ULL, 0x080fe40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x000000134e4e7220ULL, 0x000fc40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001352527220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000d3827f007947ULL, 0x000fea000b800000ULL,
0x00001f6129137589ULL, 0x00046400000e0000ULL, 0x000000130f0f7220ULL, 0x082fe40000410000ULL,
0x000000130e0e7220ULL, 0x080fe40000410000ULL, 0x000000130b0b7220ULL, 0x080fe40000410000ULL,
0x000000130a0a7220ULL, 0x080fe40000410000ULL, 0x0000001307077220ULL, 0x080fe40000410000ULL,
0x0000001306067220ULL, 0x000fc40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x0000001348487220ULL, 0x080fe40000410000ULL, 0x000000134b4b7220ULL, 0x080fe40000410000ULL,
0x000000134c4c7220ULL, 0x080fe40000410000ULL, 0x000000134f4f7220ULL, 0x080fe40000410000ULL,
0x0000001350507220ULL, 0x000fc40000410000ULL, 0x0000001353537220ULL, 0x080fe40000410000ULL,
0x0000001354547220ULL, 0x080fe40000410000ULL, 0x0000001357577220ULL, 0x080fe40000410000ULL,
0x0000001358587220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200190308ULL, 0x000e640000000800ULL, 0x0000001923230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001223127221ULL, 0x008fe40000010000ULL,
0x000000ffff137224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL, 0x0000016000017945ULL, 0x000fd80003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x0000d1e27f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0002e400000e0000ULL, 0x0000d2427f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001402000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000d9c000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0001409000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000d95000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000138005f407811ULL, 0x000fe200078e20ffULL, 0x00000f9000017945ULL, 0x000fe20003800000ULL,
0x0000006c6200720cULL, 0x000fe20003f46070ULL, 0x000000001e24783bULL, 0x004ea20000004200ULL,
0x000000145900720cULL, 0x000fc40003fc3070ULL, 0x0000006c6100720cULL, 0x000fe20003f26070ULL,
0x000000005d28783bULL, 0x000fe20000004200ULL, 0x000000145900720cULL, 0x000fc60003f03070ULL,
0x000000005e34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000018ff447819ULL, 0x002fe20000011420ULL, 0x00000100202c7824ULL, 0x040fe200078e00ffULL,
0x0000888020327816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011421ULL, 0x00000100212d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000100242e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011425ULL,
0x0000888025817816ULL, 0x000fe200000000ffULL, 0x00000020003d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7d7819ULL, 0x000fe20000011424ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x0000888024827816ULL, 0x000fe200000000ffULL, 0x0000002d00477306ULL, 0x000fe20000200c00ULL,
0x0000010022207824ULL, 0x002fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011423ULL,
0x0000001b4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fc40000011426ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002c003f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff727819ULL, 0x000fe40000011427ULL, 0x0000888026797816ULL, 0x000fe400000000ffULL,
0x0000888027787816ULL, 0x000fe400000000ffULL, 0x00008880343a7816ULL, 0x000fe200000000ffULL,
0x00000020002d7306ULL, 0x0005e20000200c00ULL, 0x00000100252c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc40000011434ULL, 0x00000018ff847819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000010027207824ULL, 0x044fe200078e00ffULL, 0x0000002e00837306ULL, 0x0003e20000200c00ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe4000001142cULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00008880222c7816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000020007b7306ULL, 0x0005e20000200c00ULL,
0x00008880232e7816ULL, 0x002fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011436ULL,
0x0000002100247306ULL, 0x0003e20000200c00ULL, 0x0000010028207824ULL, 0x004fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x0000888035867816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fc40000011421ULL, 0x00000025007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00000018ff717819ULL, 0x000fe20000011428ULL,
0x0000004400447306ULL, 0x000ee20000200c00ULL, 0x0000010026257824ULL, 0x002fe200078e00ffULL,
0x0000541024457816ULL, 0x004fe20000000045ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888028747816ULL, 0x000fc400000000ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff707819ULL, 0x000fe40000011429ULL, 0x0000888029887816ULL, 0x000fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001142aULL, 0x00000023003e7306ULL, 0x0002a20000200c00ULL,
0x000054103d447816ULL, 0x008fc40000000044ULL, 0x00008880373d7816ULL, 0x000fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fc6000001142bULL, 0x00000025007a7306ULL, 0x0007e20000200c00ULL,
0x0000010036237824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0001380060257811ULL, 0x008fe400078e20ffULL,
0x000054103e317816ULL, 0x004fe40000000031ULL, 0x00000018ff367819ULL, 0x000fc60000011436ULL,
0x0000002000857306ULL, 0x0002b00000200c00ULL, 0x0000002600767306ULL, 0x000fe20000200c00ULL,
0x0000541032207816ULL, 0x002fe2000000003fULL, 0x0000010037327824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011423ULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011432ULL, 0x0000002700777306ULL, 0x0003f00000200c00ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0009f00000200c00ULL, 0x0000002200337306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x010fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000034003b7306ULL, 0x0009e20000200c00ULL, 0x0001000035227824ULL, 0x004fca00078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000054103a347816ULL, 0x010fe20000000085ULL, 0x00010000283a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fca0000011437ULL, 0x0000002100357306ULL, 0x0006a20000200c00ULL,
0x0000001a2424b232ULL, 0x082fe40000000000ULL, 0x0000001a2626b232ULL, 0x000fe40000000000ULL,
0x0000001b2525b232ULL, 0x080fe40000000000ULL, 0x0000001b2727b232ULL, 0x000fe20000000000ULL,
0x0000002c002c7306ULL, 0x000e620000200c00ULL, 0x0000541046217816ULL, 0x008fe40000000047ULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x0000541086357816ULL, 0x004fe20000000035ULL, 0x0000010029867824ULL, 0x000fc400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x000054102c2c7816ULL, 0x002fe4000000002dULL,
0x00000018ff297819ULL, 0x000fca0000011429ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x008fce0000000030ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x004fe20000000038ULL, 0x000000304030723cULL, 0x040fec00000018ffULL,
0x00000022007e7306ULL, 0x0004f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000000204020723cULL, 0x004f6200000018ffULL, 0x000054102e2d7816ULL, 0x002fcc000000002fULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054107e397816ULL, 0x008fe20000000039ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff7e7819ULL, 0x000fca000001143aULL,
0x0000003d003d7306ULL, 0x000fe40000200c00ULL, 0x000000384038723cULL, 0x000fec00000018ffULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054103d3d7816ULL, 0x004fce000000003eULL, 0x0000003600877306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x0000008500287306ULL, 0x000ee20000200c00ULL,
0x000000344034723cULL, 0x002f6e00000018ffULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x0000541087667816ULL, 0x004fce0000000066ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541028677816ULL, 0x008fce0000000067ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6200000018ffULL, 0x0000541082287816ULL, 0x002fcc0000000083ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000088802a667816ULL, 0x020fce00000000ffULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000008000807306ULL, 0x000e700000200c00ULL,
0x0000002900677306ULL, 0x0005f00000200c00ULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0000541081297816ULL, 0x004fe20000000084ULL, 0x000001002a817824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b620000001820ULL,
0x00000018ff2a7819ULL, 0x000fcc000001142aULL, 0x0000541080287816ULL, 0x022fe2000000007dULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054107f297816ULL, 0x000fe4000000007cULL,
0x000088802b7c7816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000000282444723cULL, 0x000b6e0000001844ULL, 0x0000541079287816ULL, 0x028fe2000000007aULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541078297816ULL, 0x004fe2000000007bULL,
0x000001002b787824ULL, 0x000fc400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x00000028242c723cULL, 0x000b62000000182cULL, 0x00000018ff2b7819ULL, 0x000fcc000001142bULL,
0x0000008800857306ULL, 0x000fe20000200c00ULL, 0x000000ffff287224ULL, 0x020fe200078e007cULL,
0x0000541077297816ULL, 0x002fcc0000000072ULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002800797306ULL, 0x0007f00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541076287816ULL, 0x008fce0000000073ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000000282430723cULL, 0x000b6e0000001830ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x0000541074287816ULL, 0x024fe40000000075ULL, 0x0000541085297816ULL, 0x002fca0000000086ULL,
0x0000006600667306ULL, 0x000fe40000200c00ULL, 0x000000282434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000054107e287816ULL, 0x028fe40000000071ULL,
0x0000541067297816ULL, 0x000fca0000000070ULL, 0x0000007800787306ULL, 0x000ea40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541066287816ULL, 0x022fe40000000081ULL, 0x000000016c667810ULL, 0x000fc80007ffe0ffULL,
0x000000666200720cULL, 0x080fe20005746470ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541079297816ULL, 0x004fe40000000078ULL, 0x000000666100720cULL, 0x000fca0004f26470ULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x00000028243c723cULL, 0x000b6e000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe4000000006fULL,
0x000054102b297816ULL, 0x004fce000000006eULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000002011117221ULL, 0x000fe40000010000ULL, 0x0000002110107221ULL, 0x000fe40000010000ULL,
0x000000440d0d7221ULL, 0x000fe40000010000ULL, 0x000000450c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x0000003449497221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384d4d7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c51517221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004055557221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220f0f7221ULL, 0x000fe40000010000ULL,
0x000000230e0e7221ULL, 0x000fe40000010000ULL, 0x000000460b0b7221ULL, 0x000fc40000010000ULL,
0x000000470a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x000000321f1f7221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x000000364b4b7221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e53537221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004257577221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff287224ULL, 0x020fe200078e00ffULL,
0x000000145900720cULL, 0x080fe40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366667812ULL, 0x000fe400078ec0ffULL, 0x0000000323257810ULL, 0x000fe40007ffe0ffULL,
0x000000145900720cULL, 0x000fc40003f03070ULL, 0x00000040ff2b7803ULL, 0x000fe40000000000ULL,
0x0000000325237812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2d7224ULL, 0x002fe200078e0021ULL,
0x000000ff66217207ULL, 0x000fe40006800000ULL, 0x0000001425207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8400ff227984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c486dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c482dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120227810ULL, 0x000fe20007ffe0ffULL,
0x0000097000017945ULL, 0x000fe60003800000ULL, 0x0000005b2200720cULL, 0x000fda0003fc6070ULL,
0x000005100000e947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x040fe2000fffe0ffULL,
0x0000000420277824ULL, 0x000fe200078e0223ULL, 0x000000021d317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2e7424ULL, 0x000fe400078e00ffULL, 0x018a00002c227984ULL, 0x000e620000004800ULL,
0x0000004027277824ULL, 0x000fe200078e00ffULL, 0x00000005312a7c10ULL, 0x000fe2000fffe0ffULL,
0x00000040002d7824ULL, 0x000fe400078e022cULL, 0x0000001003267824ULL, 0x000fc400078e00ffULL,
0x000000012a307824ULL, 0x000fc600078e0203ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x000000012c267824ULL, 0x000fe200078e0203ULL, 0x018ac00022257984ULL, 0x0022a40000004800ULL,
0x000000275c227217ULL, 0x002fca0007800000ULL, 0x0000000122227824ULL, 0x000fe400078e0a27ULL,
0x000000102c277824ULL, 0x000fc600078e00ffULL, 0x0000000522227c17ULL, 0x000fe4000f800000ULL,
0xfffffff027267812ULL, 0x000fe400078ee226ULL, 0x8000000522227c10ULL, 0x000fe4000fffe0ffULL,
0x0001400026297811ULL, 0x000fe400078e20ffULL, 0x000000022d267810ULL, 0x000fe20007ffe0ffULL,
0x0000002516257224ULL, 0x004fc800078e022dULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002f24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000221d00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000f101c4cULL, 0x018a08002c287984ULL, 0x000ea20000004800ULL,
0x000000102a257824ULL, 0x002fe200078e00ffULL, 0x000000042d247810ULL, 0x040fe40007ffe0ffULL,
0x000000062d2d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff025307812ULL, 0x000fc800078ee230ULL,
0x0001400030337811ULL, 0x000fe200078e20ffULL, 0x018ac00028277984ULL, 0x004e640000004800ULL,
0x0000002716277224ULL, 0x002fc800078e0226ULL, 0x00005e0027267625ULL, 0x000fca00078e002eULL,
0x0000002f26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000223100720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026337faeULL, 0x0003e8000f101c4cULL, 0x018a10002c2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002f24287210ULL, 0x000fca0007fde0ffULL,
0x000000ffff297224ULL, 0x000fe200030e0625ULL, 0x000000041d257810ULL, 0x000fc80007ffe0ffULL,
0x0000000525247c10ULL, 0x040fe4000fffe0ffULL, 0x000000222500720cULL, 0x000fc60003fc6070ULL,
0x0000000124307824ULL, 0x040fe400078e0203ULL, 0x0000001024277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0001400030277811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000f101c4cULL,
0x018a18002c267984ULL, 0x000ea80000004800ULL, 0x018ac00026257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fe200078e022dULL, 0x000000061d2d7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0025247625ULL, 0x000fe200078e002eULL, 0x000000052d2a7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002f24247210ULL, 0x000fe20007fde0ffULL, 0x000000012a2e7824ULL, 0x040fe400078e0203ULL,
0x000000102a277824ULL, 0x002fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000222d00720cULL, 0x000fe40003fc6070ULL, 0xfffffff0272e7812ULL, 0x000fc800078ee22eULL,
0x000140002e277811ULL, 0x000fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000f101c4cULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe400078e00ffULL, 0x018a00002a227984ULL, 0x000e620000004800ULL,
0x00000040002c7824ULL, 0x000fe400078e022aULL, 0x000000f0262d7812ULL, 0x000fe200078ec0ffULL,
0x018ac00022257984ULL, 0x002e640000004800ULL, 0x0000002516257224ULL, 0x002fc800078e022cULL,
0x00005e0025247625ULL, 0x000fca00078e002eULL, 0x0000002d24267210ULL, 0x000fe20007fde0ffULL,
0x000000012a247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102a257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x00014000242f7811ULL, 0x000fe400078e20ffULL, 0x000000022c247810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e8000b901c4cULL,
0x018a08002a227984ULL, 0x000ea80000004800ULL, 0x018ac00022257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24287210ULL, 0x000fe40007fde0ffULL, 0x000000022a247810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe400030e0625ULL, 0x0000000124257824ULL, 0x040fe400078e0203ULL,
0x0000001024247824ULL, 0x000fca00078e00ffULL, 0xfffffff024257812ULL, 0x000fe400078ee225ULL,
0x000000042c247810ULL, 0x040fe40007ffe0ffULL, 0x00014000252f7811ULL, 0x002fe400078e20ffULL,
0x000000062c2c7810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282f7faeULL, 0x0003e8000b901c4cULL, 0x018a10002a227984ULL, 0x000ea20000004800ULL,
0x000000062a287810ULL, 0x002fc60007ffe0ffULL, 0x018ac00022257984ULL, 0x004e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24267210ULL, 0x000fe40007fde0ffULL, 0x000000042a247810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x0000000124257824ULL, 0x040fe400078e0203ULL,
0x0000001024247824ULL, 0x000fca00078e00ffULL, 0xfffffff024257812ULL, 0x000fc800078ee225ULL,
0x0001400025297811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c4cULL, 0x018a18002a227984ULL, 0x000ea80000004800ULL,
0x018ac00022257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc400078e022cULL,
0x00000001282c7824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fca00078e002eULL,
0x0000002d24247210ULL, 0x000fe20007fde0ffULL, 0x00000010282d7824ULL, 0x000fc800078e00ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0xfffffff02d2c7812ULL, 0x000fc800078ee22cULL,
0x000140002c277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e4000b901c4cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2d7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003fc4070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40003000000ULL, 0x000000ff21247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003fc6070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000f12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x0000acc27f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0004e400000e0000ULL, 0x0000ad227f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001664000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000b3a000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x000166b000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000b33000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006524783bULL, 0x006e620000004200ULL,
0x000000ff2b00720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0001380069407811ULL, 0x000fe200078e20ffULL, 0x000000006428783bULL, 0x000ea80000004200ULL,
0x000000006320783bULL, 0x000fe80000004200ULL, 0x000000006834783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011424ULL, 0x0000010027337824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011428ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x0000002e003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fc40000011429ULL,
0x0000888028847816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888029827816ULL, 0x040fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011428ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000888026287816ULL, 0x040fe200000000ffULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe2000001142eULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7e7819ULL, 0x000fe20000011429ULL, 0x0000010026297824ULL, 0x040fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff2d7819ULL, 0x000fe20000011425ULL, 0x0000003200837306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff6f7819ULL, 0x000fe40000011420ULL,
0x0000888020737816ULL, 0x000fe400000000ffULL, 0x0000888025457816ULL, 0x000fe200000000ffULL,
0x00000033003d7306ULL, 0x000fe20000200c00ULL, 0x0000888027327816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002600337306ULL, 0x0005e20000200c00ULL, 0x0000888035877816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff867819ULL, 0x000fe20000011436ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x044fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011437ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00008880363c7816ULL, 0x000fc400000000ffULL,
0x00000018ff767819ULL, 0x000fe20000011426ULL, 0x0000010034267824ULL, 0x040fe200078e00ffULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011420ULL,
0x0000888034207816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000541044447816ULL, 0x002fe2000000003fULL,
0x0000002e00257306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff6e7819ULL, 0x000fe40000011421ULL, 0x0000888021747816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001142bULL, 0x000088802a797816ULL, 0x000fe400000000ffULL,
0x000088802b777816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011422ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00000018ff667819ULL, 0x000fce0000011423ULL,
0x0000002f003e7306ULL, 0x000e700000200c00ULL, 0x00000027003a7306ULL, 0x0005f00000200c00ULL,
0x00000029002f7306ULL, 0x0007e20000200c00ULL, 0x0000010035277824ULL, 0x004fe200078e00ffULL,
0x0000541045457816ULL, 0x002fe2000000003eULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00008880373e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000028002e7306ULL, 0x0002a20000200c00ULL, 0x000001002b297824ULL, 0x048fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x000000444044723cULL, 0x000f6400000018ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000026007f7306ULL, 0x0002e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000010036267824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011426ULL, 0x00000027008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011436ULL, 0x00000029007c7306ULL, 0x0003f00000200c00ULL,
0x00000028007a7306ULL, 0x0009e20000200c00ULL, 0x0000541024297816ULL, 0x002fe4000000002dULL,
0x00005410322d7816ULL, 0x000fe2000000003dULL, 0x0000010037327824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x0000541025287816ULL, 0x010fe4000000002cULL, 0x000138006a257811ULL, 0x000fe400078e20ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011432ULL, 0x000054102e2c7816ULL, 0x004fe2000000002fULL,
0x00000034003b7306ULL, 0x0007e20000200c00ULL, 0x000000002524783bULL, 0x000eaa0000000200ULL,
0x0000002c402c723cULL, 0x000fe400000018ffULL, 0x0000003500887306ULL, 0x0009e20000200c00ULL,
0x0000541020347816ULL, 0x008fc4000000007fULL, 0x00000018ff207819ULL, 0x000fe40000011437ULL,
0x000054103a317816ULL, 0x002fe20000000031ULL, 0x00000100213a7824ULL, 0x000fe400078e00ffULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000541087357816ULL, 0x010fe2000000008aULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc8000001143aULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x0000541033307816ULL, 0x002fce0000000030ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x000000304030723cULL, 0x000fe200000018ffULL, 0x0000001a2424b232ULL, 0x084fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe20000000000ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000541088397816ULL, 0x010fe20000000039ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000888022887816ULL, 0x000fca00000000ffULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054103e3d7816ULL, 0x004fce000000003dULL, 0x0000003600897306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x00000020008a7306ULL, 0x0004e20000200c00ULL,
0x000000344034723cULL, 0x002fee00000018ffULL, 0x00000021007f7306ULL, 0x0007e20000200c00ULL,
0x0000541089207816ULL, 0x004fe20000000086ULL, 0x0001000022867824ULL, 0x000fcc00078e00ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054108a217816ULL, 0x008fe20000000081ULL,
0x000000ffff817224ULL, 0x000fcc00078e0088ULL, 0x0000008200827306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002a00757306ULL, 0x000ff00000200c00ULL,
0x0000002b00787306ULL, 0x0005f00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0000541082217816ULL, 0x002fc40000000085ULL,
0x00000018ff827819ULL, 0x000fe40000011486ULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000002000227306ULL, 0x0007f00000200c00ULL,
0x0000007900797306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x008fc40000000083ULL,
0x0000888023837816ULL, 0x000fca00000000ffULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000541080207816ULL, 0x024fe2000000007dULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107e217816ULL, 0x002fe2000000007bULL,
0x00000100237b7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fcc0000011423ULL,
0x000000ffff217224ULL, 0x020fe200078e0083ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541079207816ULL, 0x010fce000000007aULL, 0x00000021007d7306ULL, 0x0007f00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541077217816ULL, 0x008fce000000007cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x0000541075207816ULL, 0x024fe40000000072ULL,
0x0000541078217816ULL, 0x002fca0000000071ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541073207816ULL, 0x030fe40000000076ULL, 0x0000541074217816ULL, 0x008fca0000000087ULL,
0x0000007000707306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054107f217816ULL, 0x022fce000000006eULL,
0x0000007b007a7306ULL, 0x000e620000200c00ULL, 0x0000541070207816ULL, 0x004fce000000006fULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541081207816ULL, 0x028fe40000000022ULL,
0x000054107d217816ULL, 0x002fca000000007aULL, 0x0000008200827306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541082207816ULL, 0x022fe4000000006dULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004411117221ULL, 0x000fe40000010000ULL,
0x0000004510107221ULL, 0x000fe40000010000ULL, 0x000000280d0d7221ULL, 0x000fe40000010000ULL,
0x000000290c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x0000003449497221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384d4d7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c51517221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004055557221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460f0f7221ULL, 0x000fe40000010000ULL, 0x000000470e0e7221ULL, 0x000fe40000010000ULL,
0x0000002a0b0b7221ULL, 0x000fc40000010000ULL, 0x0000002b0a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x000000321f1f7221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x000000364b4b7221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e53537221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004257577221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006b6c00720cULL, 0x000fe20003f06070ULL,
0x018b8800ff227f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaa7000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000114147810ULL, 0x000fc80007ffe0ffULL,
0x0000005b1400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffea34000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff147224ULL, 0x000fe400078e0006ULL,
0x000000ffff137224ULL, 0x000fd400078e0007ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x0180000012007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0001797000067802ULL, 0x000fc40000000f00ULL,
0x00009eb000007944ULL, 0x022fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001200037308ULL, 0x000ea40000001000ULL, 0xbf80000003007423ULL, 0x004fc80000000012ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000c02037981ULL, 0x000f28000c1e9900ULL,
0x0000000000067919ULL, 0x000ee40000000000ULL, 0x00000002ff277819ULL, 0x028fe20000011606ULL,
0x0000000003067220ULL, 0x014fe20000410000ULL, 0x000099227f007947ULL, 0x000fea000b800000ULL,
0x00001f2706007589ULL, 0x0004e400000e0000ULL, 0x0000000000027919ULL, 0x000f220000000000ULL,
0x0000001100117220ULL, 0x048fe40000410000ULL, 0x0000001000107220ULL, 0x000fc40000410000ULL,
0x0000000d000d7220ULL, 0x040fe40000410000ULL, 0x0000000c000c7220ULL, 0x040fe40000410000ULL,
0x0000000900097220ULL, 0x040fe40000410000ULL, 0x0000000800087220ULL, 0x040fe40000410000ULL,
0x0000000500057220ULL, 0x040fe40000410000ULL, 0x0000000400047220ULL, 0x000fc40000410000ULL,
0x0000004900497220ULL, 0x040fe40000410000ULL, 0x0000004a004a7220ULL, 0x040fe40000410000ULL,
0x0000004d004d7220ULL, 0x040fe40000410000ULL, 0x0000004e004e7220ULL, 0x000fe20000410000ULL,
0x0000000802277811ULL, 0x016fe200078ff0ffULL, 0x0000005100517220ULL, 0x040fe40000410000ULL,
0x0000005200527220ULL, 0x000fc40000410000ULL, 0x0000005500557220ULL, 0x040fe40000410000ULL,
0x0000005600567220ULL, 0x000fe20000410000ULL, 0x000098527f007947ULL, 0x000fea000b800000ULL,
0x00001f2706007589ULL, 0x0002a400000e0000ULL, 0x0000000f000f7220ULL, 0x044fe40000410000ULL,
0x0000000e000e7220ULL, 0x040fe40000410000ULL, 0x0000000b000b7220ULL, 0x040fe40000410000ULL,
0x0000000a000a7220ULL, 0x040fe40000410000ULL, 0x0000001300137220ULL, 0x000fc40000410000ULL,
0x0000001400147220ULL, 0x040fe40000410000ULL, 0x0000001f001f7220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004b004b7220ULL, 0x040fe40000410000ULL,
0x0000004c004c7220ULL, 0x040fe40000410000ULL, 0x0000004f004f7220ULL, 0x000fc40000410000ULL,
0x0000005000507220ULL, 0x040fe40000410000ULL, 0x0000005300537220ULL, 0x040fe40000410000ULL,
0x0000005400547220ULL, 0x040fe40000410000ULL, 0x0000005700577220ULL, 0x040fe40000410000ULL,
0x0000005800587220ULL, 0x000fc40000410000ULL, 0x0000000000177919ULL, 0x000ea20000002600ULL,
0x000000090803723eULL, 0x000fe200000000ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000111000723eULL, 0x000fc400000000ffULL, 0x0000000d0c02723eULL, 0x000fe400000000ffULL,
0x000000050404723eULL, 0x000fe400000000ffULL, 0x0000000f0e09723eULL, 0x000fe400000000ffULL,
0x0000000b0a0a723eULL, 0x000fe400000000ffULL, 0x000000494a05723eULL, 0x000fe400000000ffULL,
0x0000004d4e06723eULL, 0x002fc400000000ffULL, 0x000000515207723eULL, 0x000fe400000000ffULL,
0x000000555608723eULL, 0x000fe400000000ffULL, 0x00000013140b723eULL, 0x000fe400000000ffULL,
0x0000001f480c723eULL, 0x000fe400000000ffULL, 0x0000004b4c0d723eULL, 0x000fe400000000ffULL,
0x0000004f500e723eULL, 0x000fc400000000ffULL, 0x00000053540f723eULL, 0x000fe400000000ffULL,
0x000000575810723eULL, 0x000fc400000000ffULL, 0x0000000000147919ULL, 0x004e620000000000ULL,
0x0001200008087891ULL, 0x000fc6000f8e583fULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000814127811ULL, 0x042fe400078ff0ffULL, 0x0000000214117812ULL, 0x000fc600078ec0ffULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0x0000001211137211ULL, 0x040fe200078ff8ffULL,
0x0000000814127824ULL, 0x000fe200078e00ffULL, 0x00000002ff147819ULL, 0x000fe40000011614ULL,
0xfffffff816167812ULL, 0x000fe400078ee213ULL, 0x0000000812137812ULL, 0x000fe200078ec0ffULL,
0x0000000814127824ULL, 0x040fe200078e00ffULL, 0x0000001411117211ULL, 0x000fe200078ff8ffULL,
0x0000000814197824ULL, 0x000fe200078e00ffULL, 0x0000000816167c11ULL, 0x000fe2000f8e20ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee211ULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0x0000000211147810ULL, 0x000fe20007ffe0ffULL,
0x0000000113167824ULL, 0x000fe200078e0216ULL, 0x0000000411157810ULL, 0x000fc40007ffe0ffULL,
0x0000000611117810ULL, 0x000fe40007ffe0ffULL, 0x0000000812127c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff819147812ULL, 0x000fe400078ee214ULL, 0xfffffff818157812ULL, 0x000fe200078ee215ULL,
0x0000000112127824ULL, 0x000fe200078e0213ULL, 0xfffffff81a117812ULL, 0x000fe400078ee211ULL,
0x0000541000187816ULL, 0x000fc40000000002ULL, 0x0000763200197816ULL, 0x000fe40000000002ULL,
0x0000000814147c11ULL, 0x000fe4000f8e20ffULL, 0x0000000815007c11ULL, 0x000fe2000f8e20ffULL,
0x0000001812007388ULL, 0x0003e20000000a00ULL, 0x0000000811027c11ULL, 0x000fe2000f8e20ffULL,
0x0000000113147824ULL, 0x040fe400078e0214ULL, 0x0000000113007824ULL, 0x040fe400078e0200ULL,
0x0000000113027824ULL, 0x000fe200078e0202ULL, 0x0000763203137816ULL, 0x000fc40000000004ULL,
0x0000541003127816ULL, 0x002fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001214007388ULL, 0x0003e20000000a00ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000400007388ULL, 0x0003e20000000a00ULL, 0x0000541009087816ULL, 0x000fc4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x0000000602007388ULL, 0x0003e20000000a00ULL,
0x000054100b0a7816ULL, 0x140fe4000000000cULL, 0x000076320b0b7816ULL, 0x000fe2000000000cULL,
0x0000000816007388ULL, 0x0003e20000000a00ULL, 0x000054100d0c7816ULL, 0x140fe4000000000eULL,
0x000076320d0d7816ULL, 0x000fe2000000000eULL, 0x0004000a14007388ULL, 0x0003e20000000a00ULL,
0x000054100f0e7816ULL, 0x000fc40000000010ULL, 0x000076320f0f7816ULL, 0x000fe20000000010ULL,
0x0004000c00007388ULL, 0x0003e80000000a00ULL, 0x0004000e02007388ULL, 0x0003e20000000a00ULL,
0x0000003000007947ULL, 0x000fea0003800000ULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x00018180001c7802ULL, 0x000fc40000000f00ULL, 0x0000991000007944ULL, 0x022fea0003c00000ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL,
0x000000040b0472a4ULL, 0x000fcc000f8e023fULL, 0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL,
0x00000003ff007819ULL, 0x002fca0000011609ULL, 0x0000000100027824ULL, 0x040fe400078e0209ULL,
0x0000580000007a24ULL, 0x000fc600078e0217ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000003007211ULL, 0x000fe400078010ffULL, 0x0ffffff802047812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe400078048ffULL, 0x0000000804047984ULL, 0x000e62000800cc00ULL,
0x1ffffff809097812ULL, 0x000fc400078ef808ULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d0cULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000608057899ULL, 0x000fe2000800063fULL,
0x000000200f047810ULL, 0x000fca0007ffe0ffULL, 0x000000050f037c10ULL, 0x000fe2000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000680000047ab9ULL, 0x000fe20000000800ULL,
0x0000000504057c10ULL, 0x040fe2000fffe0ffULL, 0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL,
0x0000005c0300720cULL, 0x080fe20003f06070ULL, 0x0000000808067899ULL, 0x000fe2000800063fULL,
0x0000005c0500720cULL, 0x000fe20003f26070ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x018ad000ff087f8cULL, 0x000e62000c80043fULL, 0x000000040f027c10ULL, 0x040fe2000fffe0ffULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x0000000404047c10ULL, 0x000fe2000fffe0ffULL,
0x00006e00ff067624ULL, 0x000fe200078e00ffULL, 0x000000060f0b7c11ULL, 0x040fe2000f8e10ffULL,
0x0000660002027625ULL, 0x000fe200078e000dULL, 0x000000030f00780cULL, 0x000fc60003f44070ULL,
0x0000660004047625ULL, 0x000fe200078e000dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x18600000020b7faeULL, 0x0005e6000c12184cULL, 0x00006f00ff077624ULL, 0x000fe200078e00ffULL,
0x18680000040b7faeULL, 0x0005ea000c92184cULL, 0x000000a000002947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x004ea20000002700ULL, 0x00000008ff037e24ULL, 0x000fe2000f8e00ffULL,
0x000000085a007c0cULL, 0x000fc6000bf03070ULL, 0x0000000403057824ULL, 0x000fca00078e020fULL,
0x00018a8005057811ULL, 0x000fe200078e10ffULL, 0x0000000402027824ULL, 0x004fc800078e020fULL,
0x0000000202027824ULL, 0x000fc800078e00ffULL, 0x0000640002027a24ULL, 0x000fc800078e0203ULL,
0x0000600002027625ULL, 0x000fca00078e000dULL, 0x0000000002057faeULL, 0x0005e4000c12184cULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000c06027981ULL, 0x004528000c1e9900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000ffff037224ULL, 0x002fe200078e0009ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000119000000947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004e620000000000ULL, 0x00018a8008077891ULL, 0x000fe2000f8e203fULL,
0x000000055c0a7c17ULL, 0x000fe2000f800000ULL, 0x00000100ff077424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe4000f8e703fULL, 0x800000050a0a7c10ULL, 0x000fe4000fffe0ffULL,
0x00000003ff057819ULL, 0x002fe20000011604ULL, 0x0000001004067824ULL, 0x000fc600078e00ffULL,
0x0000000a0500720cULL, 0x040fe20003f06070ULL, 0x0186000605097984ULL, 0x000e620008004800ULL,
0x0000004000087824ULL, 0x000fe200078e0205ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x00000001050b7824ULL, 0x000fca00078e0204ULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000709097984ULL, 0x002e640008004800ULL, 0x00000004090c7c24ULL, 0x002fe2000f8e0208ULL,
0x0ffffff80b097812ULL, 0x000fe400078ef804ULL, 0x00000004050b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0007ULL, 0x0000000909097c11ULL, 0x000fc6000f8e20ffULL,
0x000000010b117824ULL, 0x040fe200078e0204ULL, 0x0000000c060e7210ULL, 0x000fe20007f3e0ffULL,
0x000000080b147824ULL, 0x000fc800078e00ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x00000004080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000008050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186100605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000008080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186200605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x0000000c080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000010050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186300605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000010080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x00000014050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186400605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x00000014080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000018050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186500605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000018080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x0000001c050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186600605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x0000001c080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000020050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186700605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000020080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x00000024050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186800605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x00000024080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000028050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186900605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000028080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x0000002c050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186a00605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x0000002c080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000030050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186b00605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x040fe400078e0204ULL,
0x000000080b147824ULL, 0x000fe200078e00ffULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000712127984ULL, 0x004e640008004800ULL, 0x00000004120c7c24ULL, 0x002fc8000f8e020dULL,
0x00005e000c0c7625ULL, 0x000fca00078e0007ULL, 0x0000000c06107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000030080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x00000034050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186c00605127984ULL, 0x000ea20008004800ULL, 0xfffffff814097812ULL, 0x002fc600078ee20fULL,
0x000000010b117824ULL, 0x040fe400078e0204ULL, 0x000000080b147824ULL, 0x000fe200078e00ffULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060dULL,
0x00000034080d7810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000c101c4cULL, 0x0000000a0b00720cULL, 0x000fe40003f06070ULL,
0x00000038050b7810ULL, 0x000fe20007ffe0ffULL, 0x0186d00605127984ULL, 0x000ea20008004800ULL,
0xfffffff814097812ULL, 0x002fc600078ee211ULL, 0x000000010b0f7824ULL, 0x000fe200078e0204ULL,
0x0000000909097c11ULL, 0x000fe2000f8e20ffULL, 0x0000000712127984ULL, 0x004e640008004800ULL,
0x00000004120c7c24ULL, 0x002fe4000f8e020dULL, 0x000000080b127824ULL, 0x000fe400078e00ffULL,
0x00005e000c0c7625ULL, 0x000fc600078e0007ULL, 0xfffffff8120f7812ULL, 0x000fe400078ee20fULL,
0x0000000c06107210ULL, 0x000fe40007f3e0ffULL, 0x000000090f0f7c11ULL, 0x000fc6000f8e20ffULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000038080d7810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010097faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x000fe40003f06070ULL, 0x0000003c050b7810ULL, 0x000fe20007ffe0ffULL,
0x0186e006050e7984ULL, 0x000ea80008004800ULL, 0x000000010b047824ULL, 0x000fe200078e0204ULL,
0x0000003c08097810ULL, 0x002fe20007ffe0ffULL, 0x000000070e0e7984ULL, 0x004e640008004800ULL,
0x000000040e0c7c24ULL, 0x002fc8000f8e020dULL, 0x00005e000c0c7625ULL, 0x000fca00078e0007ULL,
0x0000000c060c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0f7faeULL, 0x0003e2000c101c4cULL,
0x0000000a0b00720cULL, 0x040fe20003f06070ULL, 0x000000080b0b7824ULL, 0x000fe400078e00ffULL,
0x0186f006050e7984ULL, 0x0004e60008004800ULL, 0xfffffff80b047812ULL, 0x000fc800078ee204ULL,
0x0000000904057c11ULL, 0x004fe2000f8e20ffULL, 0x000000070e0e7984ULL, 0x008ea40008004800ULL,
0x000000040e087c24ULL, 0x004fc8000f8e0209ULL, 0x00005e0008087625ULL, 0x000fca00078e0007ULL,
0x0000000806067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000c101c4cULL,
0x0000106000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x004e620000000000ULL,
0x00018a8008077891ULL, 0x000fe2000f8e203fULL, 0x00000100ff067424ULL, 0x000fe200078e00ffULL,
0x0000200008097891ULL, 0x000fe2000f8e703fULL, 0x00000003ff057819ULL, 0x002fe20000011604ULL,
0x0000001004077824ULL, 0x000fc600078e00ffULL, 0x00000004050f7810ULL, 0x000fe20007ffe0ffULL,
0x0186000605097984ULL, 0x000e620008004800ULL, 0x0000004000087824ULL, 0x000fe200078e0205ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00000001050c7824ULL, 0x100fe400078e0204ULL,
0x000000010f107824ULL, 0x040fe400078e0204ULL, 0x000000080f0f7824ULL, 0x000fe200078e00ffULL,
0x000000070c0d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x002e640008004800ULL, 0x00000004090b7c24ULL, 0x002fe2000f8e0208ULL,
0x0ffffff80d097812ULL, 0x000fc600078ef804ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000909117c11ULL, 0x000fc8000f8e20ffULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x00000004080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186100605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000008050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000008080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186200605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x0000000c050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x0000000c080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186300605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000010050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000010080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186400605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000014050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x00000014080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186500605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000018050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000018080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186600605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x0000001c050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x0000001c080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186700605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000020050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000020080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186800605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000024050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x00000024080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186900605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000028050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000028080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186a00605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x0000002c050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x0000002c080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186b00605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000030050d7810ULL, 0x000fca0007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000030080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e117faeULL, 0x0003e8000b901c4cULL,
0x0186c00605097984ULL, 0x000ea20008004800ULL, 0x0000000910117c11ULL, 0x002fe4000f8e20ffULL,
0x00000034050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f107824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee210ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0c7210ULL, 0x000fe40007f1e0ffULL,
0x00000034080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0003e8000b901c4cULL,
0x0186d00605097984ULL, 0x000ea20008004800ULL, 0x00000009100d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000003805117810ULL, 0x000fca0007ffe0ffULL, 0x00000001110c7824ULL, 0x040fe400078e0204ULL,
0x0000000811117824ULL, 0x000fca00078e00ffULL, 0xfffffff8110c7812ULL, 0x000fe200078ee20cULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fc8000f8e020aULL,
0x00005e000b0a7625ULL, 0x000fca00078e0006ULL, 0x000000070a0e7210ULL, 0x000fe40007f1e0ffULL,
0x00000038080a7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0d7faeULL, 0x0003e8000b901c4cULL,
0x0186e00605097984ULL, 0x000ea20008004800ULL, 0x000000090c0d7c11ULL, 0x002fe4000f8e20ffULL,
0x0000003c050f7810ULL, 0x000fca0007ffe0ffULL, 0x000000010f047824ULL, 0x040fe400078e0204ULL,
0x000000080f0f7824ULL, 0x000fca00078e00ffULL, 0xfffffff80f047812ULL, 0x000fe200078ee204ULL,
0x0000000709097984ULL, 0x004e640008004800ULL, 0x00000004090b7c24ULL, 0x002fe2000f8e020aULL,
0x0000003c08097810ULL, 0x000fc60007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fca00078e0006ULL,
0x000000070a0a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e8000b901c4cULL,
0x0186f006050c7984ULL, 0x0004e40008004800ULL, 0x0000000904057c11ULL, 0x004fe4000f8e20ffULL,
0x000000070c0c7984ULL, 0x008ea40008004800ULL, 0x000000040c097c24ULL, 0x004fc8000f8e0209ULL,
0x00005e0009087625ULL, 0x000fca00078e0006ULL, 0x0000000708067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fca00000e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e6000b901c4cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x018ad400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018ad400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000008ff047e24ULL, 0x000fc8000f8e00ffULL,
0x0000002004037824ULL, 0x002fca00078e0203ULL, 0x00000003ff057819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003097824ULL, 0x040fe400078e00ffULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000106087824ULL, 0x040fe200078e0205ULL,
0x0000001006067810ULL, 0x000fe20007ffe0ffULL, 0x00000020030a7824ULL, 0x000fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fc400078ec0ffULL, 0x0000001f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0206ULL, 0x000001e00a077812ULL, 0x040fe400078ee207ULL,
0x000001e009087812ULL, 0x000fe200078ee208ULL, 0x0000000103097824ULL, 0x000fe200078e0206ULL,
0x0000001f05057812ULL, 0x000fe200078ec0ffULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000002003067824ULL, 0x000fe400078e00ffULL, 0x0000001f09097812ULL, 0x000fe200078ec0ffULL,
0x00000000080c7984ULL, 0x000ea2000000cc00ULL, 0x000001e00a057812ULL, 0x000fc400078ee205ULL,
0x000001e006097812ULL, 0x000fe200078ee209ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001808007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000009107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c09007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018ad000ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff057224ULL, 0x002fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x004fc400078e0007ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x018ad400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018ad400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00005800ff087624ULL, 0x000fe200078e00ffULL,
0x00018b5804547811ULL, 0x000fe200078e18ffULL, 0x3d80000002027820ULL, 0x010fe20000410000ULL,
0xffffffff5b537810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00018ad804527811ULL, 0x000fe200078e28ffULL, 0x000000ffff057224ULL, 0x000fe400078e00ffULL,
0x00000008ff077e24ULL, 0x000fe4000f8e00ffULL, 0x0000004008087824ULL, 0x000fc400078e00ffULL,
0x0000000506577c11ULL, 0x000fe2000f8e40ffULL, 0x0000000000007946ULL, 0x000fe60003800000ULL,
0x000000575c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff5e7424ULL, 0x000fe200078e00ffULL, 0x000000065900720cULL, 0x000fe20003f44070ULL,
0x000000ffff5d7224ULL, 0x000fc600078e00ffULL, 0x000000015e5e7807ULL, 0x000fc40005000000ULL,
0x000000ffff157224ULL, 0x000fe200078e0005ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5f7224ULL, 0x000fe200078e005dULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x0001b280001c7802ULL, 0x000fc40000000f00ULL, 0x0000681000007944ULL, 0x002fea0003c00000ULL,
0x0000000160627810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000005d62057211ULL, 0x040fe200078ff8ffULL, 0x000020a000007945ULL, 0x000fe20003800000ULL,
0x0000000162617812ULL, 0x000fe400078ec0ffULL, 0x0000000305167812ULL, 0x000fe400078ec0ffULL,
0x00000002ff05a819ULL, 0x000fe40000011605ULL, 0x000000ff16167207ULL, 0x000fc60005000000ULL,
0x0000000105147824ULL, 0x000fe200078e0206ULL, 0x0000000115057812ULL, 0x000fc800078e0cffULL,
0x00000001141c7810ULL, 0x000fc80007ffe0ffULL, 0x0000005b1c00720cULL, 0x000fda0003f06070ULL,
0x000010a000008947ULL, 0x000fea0003800000ULL, 0x00000003ff177819ULL, 0x002fe20000011603ULL,
0x00018a8008047891ULL, 0x000fe2000f8e203fULL, 0x00000005141d7c11ULL, 0x000fe2000f8e40ffULL,
0x0000000861227824ULL, 0x000fe400078e00ffULL, 0x0186000617217984ULL, 0x000e620008004800ULL,
0x0000001d5c1e7217ULL, 0x000fe20007800000ULL, 0x00000040001f7824ULL, 0x000fe400078e0217ULL,
0x00000002041c7824ULL, 0x000fe400078e0205ULL, 0x000000011e1e7824ULL, 0x000fc400078e0a1dULL,
0x00000001171d7824ULL, 0x140fe200078e0203ULL, 0x000020001c1c7811ULL, 0x000fe200078e68ffULL,
0x00000100ff207424ULL, 0x000fe200078e00ffULL, 0x0000001e1700720cULL, 0x000fe40003f06070ULL,
0x000000071d647812ULL, 0x000fe400078ec0ffULL, 0xfffffff8221d7812ULL, 0x000fe200078ee203ULL,
0x0000000421217984ULL, 0x002e640008004800ULL, 0x0000002108237224ULL, 0x002fe200078e021fULL,
0x0ffffff864217812ULL, 0x000fc600078ef803ULL, 0x00005e0023227625ULL, 0x000fc800078e0020ULL,
0x0000001021217824ULL, 0x000fe400078e021cULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000000417227810ULL, 0x000fe40007ffe0ffULL, 0x000000041f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186100617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000000817227810ULL, 0x000fe40007ffe0ffULL, 0x000000081f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186200617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000000c17227810ULL, 0x000fe40007ffe0ffULL, 0x0000000c1f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186300617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000001017227810ULL, 0x000fe40007ffe0ffULL, 0x000000101f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186400617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000001417227810ULL, 0x000fe40007ffe0ffULL, 0x000000141f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186500617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000001817227810ULL, 0x000fe40007ffe0ffULL, 0x000000181f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186600617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000001c17227810ULL, 0x000fe40007ffe0ffULL, 0x0000001c1f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186700617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000002017227810ULL, 0x000fe40007ffe0ffULL, 0x000000201f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186800617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000002417227810ULL, 0x000fe40007ffe0ffULL, 0x000000241f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186900617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000002817227810ULL, 0x000fe40007ffe0ffULL, 0x000000281f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186a00617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000002c17227810ULL, 0x000fe40007ffe0ffULL, 0x0000002c1f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186b00617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000003017227810ULL, 0x000fe40007ffe0ffULL, 0x000000301f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186c00617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000003417227810ULL, 0x000fe40007ffe0ffULL, 0x000000341f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186d00617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fca00078ee266ULL, 0x0000001067217824ULL, 0x002fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d647825ULL, 0x000fe200078e0022ULL,
0x0000003817227810ULL, 0x000fe40007ffe0ffULL, 0x000000381f237810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c101c4cULL,
0x0000000122667824ULL, 0x040fe200078e0203ULL, 0x0000001e2200720cULL, 0x040fe20003f06070ULL,
0x0000000822677824ULL, 0x000fe200078e00ffULL, 0x0186e00617637984ULL, 0x000ea80008004800ULL,
0xfffffff867677812ULL, 0x000fc400078ee266ULL, 0x0000003c17647810ULL, 0x002fc60007ffe0ffULL,
0x0000001067657824ULL, 0x000fe200078e021cULL, 0x0000003c1f217810ULL, 0x000fe20007ffe0ffULL,
0x00000001641f7824ULL, 0x040fe400078e0203ULL, 0x0000000864667824ULL, 0x000fca00078e00ffULL,
0xfffffff8661f7812ULL, 0x000fca00078ee21fULL, 0x000000101f1f7824ULL, 0x000fe200078e021cULL,
0x0000000463637984ULL, 0x004e640008004800ULL, 0x0000006308237224ULL, 0x002fc800078e0223ULL,
0x00005e0023227625ULL, 0x000fcc00078e0020ULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000c101c4cULL,
0x0000001e6400720cULL, 0x000fc60003f06070ULL, 0x0186f00617637984ULL, 0x000ea80008004800ULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e0020ULL, 0x000000101d207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000201f7faeULL, 0x0003e2000c101c4cULL,
0x00000f6000007947ULL, 0x000fea0003800000ULL, 0x00000003ff177819ULL, 0x002fe20000011603ULL,
0x00018a8008047891ULL, 0x000fe2000f8e203fULL, 0x0000000861207824ULL, 0x000fe400078e00ffULL,
0x00000002041d7824ULL, 0x000fe200078e0205ULL, 0x0186000617227984ULL, 0x000e620008004800ULL,
0x00000040001f7824ULL, 0x000fe400078e0217ULL, 0x00000001171c7824ULL, 0x000fe200078e0203ULL,
0x000020001d1d7811ULL, 0x000fe200078e68ffULL, 0x00000100ff1e7424ULL, 0x000fc600078e00ffULL,
0x000000071c647812ULL, 0x000fe400078ec0ffULL, 0xfffffff8201c7812ULL, 0x100fe400078ee203ULL,
0x0ffffff864647812ULL, 0x000fca00078ef803ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000422227984ULL, 0x002e640008004800ULL, 0x0000002208217224ULL, 0x002fc800078e021fULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x000fe200078e0020ULL,
0x0000000417207810ULL, 0x000fe40007ffe0ffULL, 0x000000041f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186100617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000000817207810ULL, 0x000fe40007ffe0ffULL,
0x000000081f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186200617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000000c17207810ULL, 0x000fe40007ffe0ffULL, 0x0000000c1f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186300617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000001017207810ULL, 0x000fe40007ffe0ffULL,
0x000000101f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186400617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000001417207810ULL, 0x000fe40007ffe0ffULL, 0x000000141f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186500617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000001817207810ULL, 0x000fe40007ffe0ffULL,
0x000000181f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186600617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000001c17207810ULL, 0x000fe40007ffe0ffULL, 0x0000001c1f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186700617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000002017207810ULL, 0x000fe40007ffe0ffULL,
0x000000201f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186800617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000002417207810ULL, 0x000fe40007ffe0ffULL, 0x000000241f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186900617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000002817207810ULL, 0x000fe40007ffe0ffULL,
0x000000281f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186a00617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000002c17207810ULL, 0x000fe40007ffe0ffULL, 0x0000002c1f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186b00617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000003017207810ULL, 0x000fe40007ffe0ffULL,
0x000000301f217810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe400078e0203ULL,
0x0000000820657824ULL, 0x000fe200078e00ffULL, 0x0186c00617637984ULL, 0x000ea80008004800ULL,
0xfffffff865647812ULL, 0x000fca00078ee264ULL, 0x0000001064657824ULL, 0x000fe200078e021dULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fcc00078e001eULL, 0x000000101c227825ULL, 0x002fe200078e0020ULL,
0x0000003417207810ULL, 0x000fe40007ffe0ffULL, 0x000000341f217810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e2000b901c4cULL,
0x0000000120647824ULL, 0x040fe400078e0203ULL, 0x0000000820677824ULL, 0x000fe200078e00ffULL,
0x0186d00617637984ULL, 0x000ea80008004800ULL, 0xfffffff867647812ULL, 0x000fca00078ee264ULL,
0x0000001064677824ULL, 0x000fe200078e021dULL, 0x0000000463637984ULL, 0x004ea40008004800ULL,
0x0000006308217224ULL, 0x004fc800078e0221ULL, 0x00005e0021207625ULL, 0x000fcc00078e001eULL,
0x000000101c227825ULL, 0x002fe200078e0020ULL, 0x0000003817207810ULL, 0x000fe40007ffe0ffULL,
0x000000381f217810ULL, 0x040fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022677faeULL, 0x0003e2000b901c4cULL, 0x0000000120647824ULL, 0x040fe200078e0203ULL,
0x0000003c1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000820657824ULL, 0x000fe200078e00ffULL,
0x0186e00617637984ULL, 0x000ea80008004800ULL, 0xfffffff865647812ULL, 0x000fca00078ee264ULL,
0x0000001064657824ULL, 0x000fe200078e021dULL, 0x0000003c17647810ULL, 0x000fe20007ffe0ffULL,
0x0000000463637984ULL, 0x004ea40008004800ULL, 0x0000006308217224ULL, 0x004fe400078e0221ULL,
0x0000000164637824ULL, 0x000fe400078e0203ULL, 0x00005e0021207625ULL, 0x000fc800078e001eULL,
0x0000000864647824ULL, 0x000fe400078e00ffULL, 0x000000101c207825ULL, 0x000fc600078e0020ULL,
0xfffffff864647812ULL, 0x000fe400078ee263ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020657faeULL, 0x0005e6000b901c4cULL, 0x00000010641d7824ULL, 0x000fe200078e021dULL,
0x0186f00617227984ULL, 0x002e680008004800ULL, 0x0000000422237984ULL, 0x002e640008004800ULL,
0x00000023081f7224ULL, 0x002fc800078e021fULL, 0x00005e001f1e7625ULL, 0x000fcc00078e001eULL,
0x000000101c1e7825ULL, 0x000fca00078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e1d7faeULL, 0x0005e4000b901c4cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0xffffffffff1d7424ULL, 0x004fe200078e00ffULL,
0x0001d3a0001c7802ULL, 0x000fc40000000f00ULL, 0x000046f000007944ULL, 0x002fea0003c00000ULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000031000007945ULL, 0x000fec0003800000ULL, 0x000002f000008947ULL, 0x000fea0003800000ULL,
0x0000000116177810ULL, 0x000fe20007ffe0ffULL, 0x0000028000017945ULL, 0x000fe20003800000ULL,
0x000000145900720cULL, 0x000fe40003f04070ULL, 0x00000002ff1c7819ULL, 0x000fc40000011617ULL,
0x0000000317177812ULL, 0x000fe400078ec0ffULL, 0x000000011c1d7807ULL, 0x004fe40004000000ULL,
0x000000ff17177207ULL, 0x000fe40004000000ULL, 0x0000002003217810ULL, 0x002fe20007ffe0ffULL,
0x00000001141d7824ULL, 0x000fe200078e021dULL, 0x000000145900720cULL, 0x000fe40003f04070ULL,
0x000000031600780cULL, 0x000fc40003f85270ULL, 0x000000051d1c7c11ULL, 0x000fe4000f8e40ffULL,
0x0000000a17177c10ULL, 0x000fe4000fffe0ffULL, 0x0000000603237c11ULL, 0x000fe2000f8e10ffULL,
0x00000001211f7824ULL, 0x100fe400078e021cULL, 0x000000011c1d7824ULL, 0x100fe400078e0203ULL,
0x00006800171c7a24ULL, 0x000fe200078e021cULL, 0x0000005c1f00720cULL, 0x080fe20003f66070ULL,
0x00000004ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000005c1d00720cULL, 0x000fe20003f26070ULL,
0x000000011c167824ULL, 0x000fc400078e0203ULL, 0x00000001211e7824ULL, 0x000fe400078e021cULL,
0x0000660016167625ULL, 0x000fc800078e001fULL, 0x000066001e1e7625ULL, 0x000fe200078e001fULL,
0x0000010000008947ULL, 0x000fea0002000000ULL, 0x000000030300780cULL, 0x000fe40003f04070ULL,
0x0000000407077810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000147919ULL, 0x000e620000002700ULL, 0x0000005a0700720cULL, 0x000fe20003f06070ULL,
0x0000000404207824ULL, 0x000fe400078e0203ULL, 0x00000004ff1d7424ULL, 0x000fc600078e00ffULL,
0x00018a8020217811ULL, 0x000fe200078e10ffULL, 0x0000000414147824ULL, 0x002fc800078e0203ULL,
0x0000000214147824ULL, 0x000fc800078e00ffULL, 0x00006400141c7a24ULL, 0x000fc800078e0207ULL,
0x000060001c1c7625ULL, 0x000fca00078e001dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e4000c12184cULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1860000016237faeULL, 0x0005e8000c92184cULL,
0x186800001e237faeULL, 0x0005e4000d92184cULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002003687810ULL, 0x040fe20007ffe0ffULL,
0x0000000204637824ULL, 0x000fe200078e0215ULL, 0x0000000703647812ULL, 0x040fe200078ec0ffULL,
0x000000ffff617224ULL, 0x000fe200078e00ffULL, 0xfffffff803667812ULL, 0x000fe400078ec0ffULL,
0xfffffff868687812ULL, 0x000fc400078ec0ffULL, 0x0000200063637811ULL, 0x000fe400078e68ffULL,
0x0000000864647812ULL, 0x100fe400078ef803ULL, 0x0000000766667812ULL, 0x100fe400078ef803ULL,
0x0000000768687812ULL, 0x000fc600078ef803ULL, 0x0000000166147824ULL, 0x160fe200078e0261ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000866157824ULL, 0x000fe200078e00ffULL,
0x0000000161657810ULL, 0x006fe20007ffe0ffULL, 0x00000008609a7824ULL, 0x000fc600078e0261ULL,
0xfffffff815147812ULL, 0x000fe200078ee214ULL, 0x0000000868157824ULL, 0x000fe400078e00ffULL,
0x000000029a9a7824ULL, 0x000fe400078e00ffULL, 0x00000010141c7824ULL, 0x000fe400078e0263ULL,
0x0000000168147824ULL, 0x000fe200078e0261ULL, 0x0000000261617810ULL, 0x000fc60007ffe0ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0xfffffff815147812ULL, 0x000fe400078ee214ULL,
0x000000086100780cULL, 0x000fc60003f05270ULL, 0x0000001014147824ULL, 0x000fcc00078e0263ULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000018ff707819ULL, 0x002fe2000001141cULL,
0x000100001c207824ULL, 0x040fe200078e00ffULL, 0x000088801c977816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001141dULL,
0x000100001d217824ULL, 0x040fe200078e00ffULL, 0x000088801d957816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff917819ULL, 0x000fc4000001141eULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x000088801e927816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000001c00997306ULL, 0x0002e20000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff867819ULL, 0x004fe40000011415ULL,
0x00008880158b7816ULL, 0x000fc400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011414ULL,
0x0000001d007e7306ULL, 0x0005e20000200c00ULL, 0x000100001e1c7824ULL, 0x002fe200078e00ffULL,
0x00008880146a7816ULL, 0x000fe200000000ffULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011416ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000100001f1d7824ULL, 0x004fe200078e00ffULL,
0x0000002000987306ULL, 0x000fe20000200c00ULL, 0x0000888016877816ULL, 0x000fc400000000ffULL,
0x00000018ff727819ULL, 0x000fe40000011417ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000888017847816ULL, 0x000fe200000000ffULL, 0x0000001e00947306ULL, 0x0003e20000200c00ULL,
0x00000018ff817819ULL, 0x000fe4000001141fULL, 0x000088801f827816ULL, 0x040fe200000000ffULL,
0x000001001f1f7824ULL, 0x000fc800078e00ffULL, 0x0000001d008f7306ULL, 0x0005e20000200c00ULL,
0x00000008661e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fcc000001141fULL,
0x0000002100967306ULL, 0x0003e20000200c00ULL, 0x00000001661d7824ULL, 0x104fe400078e0265ULL,
0x0000000168657824ULL, 0x000fc600078e0265ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee21dULL,
0x00010000151d7824ULL, 0x040fe200078e00ffULL, 0x0000001c00937306ULL, 0x0005e20000200c00ULL,
0x0000010015157824ULL, 0x000fe400078e00ffULL, 0x000000101e1e7824ULL, 0x000fe200078e0263ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x000000001e20783bULL, 0x002e620000000200ULL, 0x00010000141c7824ULL, 0x044fe200078e00ffULL,
0x0000001500897306ULL, 0x0005e20000200c00ULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000001c008d7306ULL, 0x0009e20000200c00ULL, 0x0001000017157824ULL, 0x044fe400078e00ffULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000014008e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x00000008681c7824ULL, 0x010fca00078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee265ULL,
0x0000001500857306ULL, 0x0009e20000200c00ULL, 0x0001000016147824ULL, 0x044fe400078e00ffULL,
0x0000010016167824ULL, 0x000fe400078e00ffULL, 0x000000101c1c7824ULL, 0x000fe200078e0263ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001700837306ULL, 0x000fe20000200c00ULL, 0x0000009a03157211ULL, 0x010fc400078fe0ffULL,
0x000000029a9a7810ULL, 0x000fe40007ffe0ffULL, 0x00000018ff7a7819ULL, 0x002fe20000011420ULL,
0x0000000164157824ULL, 0x000fe200078e0215ULL, 0x00008880207d7816ULL, 0x000fe200000000ffULL,
0x0000001600887306ULL, 0x0003e20000200c00ULL, 0x00000018ff717819ULL, 0x000fe40000011421ULL,
0x0000888021797816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fc40000011422ULL,
0x0000888022767816ULL, 0x000fe200000000ffULL, 0x00000014008a7306ULL, 0x0005e20000200c00ULL,
0x0000002064167824ULL, 0x002fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011423ULL,
0x00008880236f7816ULL, 0x000fe400000000ffULL, 0xffffffe016157812ULL, 0x000fe200078ee215ULL,
0x0001000021167824ULL, 0x000fe200078e00ffULL, 0x0000001f00907306ULL, 0x000fe20000200c00ULL,
0x0001000020147824ULL, 0x004fc400078e00ffULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011416ULL, 0x0000010020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000010021217824ULL, 0x000fe200078e00ffULL,
0x0000001d008c7306ULL, 0x0003e40000200c00ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff217819ULL, 0x000fc80000011421ULL, 0x0000001400807306ULL, 0x0005e20000200c00ULL,
0x000000001c1c783bULL, 0x002e6e0000000200ULL, 0x0000009700977306ULL, 0x000f220000200c00ULL,
0x000000001514783bULL, 0x004eae0000000200ULL, 0x00000020007b7306ULL, 0x0007f00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0001000022207824ULL, 0x008fc400078e00ffULL,
0x0000010022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000009500957306ULL, 0x000ee20000200c00ULL, 0x00000018ff227819ULL, 0x000fce0000011422ULL,
0x0000002100787306ULL, 0x0005e20000200c00ULL, 0x00000018ff677819ULL, 0x002fe4000001141cULL,
0x00000018ff697819ULL, 0x000fe4000001141dULL, 0x00000018ff6c7819ULL, 0x000fe4000001141eULL,
0x00000018ff6d7819ULL, 0x000fe2000001141fULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x0001000023217824ULL, 0x044fe400078e00ffULL, 0x0000010023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x00000018ff9b7819ULL, 0x000fe40000011423ULL, 0x0000541099237816ULL, 0x000fca0000000070ULL,
0x0000002200757306ULL, 0x0009f00000200c00ULL, 0x0000002000777306ULL, 0x0007e20000200c00ULL,
0x0000541097227816ULL, 0x010fe40000000098ULL, 0x000088801c977816ULL, 0x000fca00000000ffULL,
0x0000002100747306ULL, 0x0005e20000200c00ULL, 0x0000541095207816ULL, 0x008fe20000000096ULL,
0x00000022143c723cULL, 0x000b62000000183cULL, 0x0000002064967824ULL, 0x000fca00078e00ffULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000054107e217816ULL, 0x004fe20000000073ULL,
0x000000ffff227224ULL, 0x020fe200078e0097ULL, 0x0000009a03237211ULL, 0x000fe200078fe0ffULL,
0x000100001c7e7824ULL, 0x040fe400078e00ffULL, 0x000001001c1c7824ULL, 0x000fe400078e00ffULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x000000201438723cULL, 0x000b620000001838ULL,
0x0000000164237824ULL, 0x000fe200078e0223ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0xffffffe096237812ULL, 0x000fe200078ee223ULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x0000541092207816ULL, 0x022fe40000000093ULL,
0x0000541094217816ULL, 0x000fe20000000091ULL, 0x0000001023237824ULL, 0x000fc800078e00ffULL,
0x0000006a006a7306ULL, 0x000e640000200c00ULL, 0x000000201434723cULL, 0x000b6c0000001834ULL,
0x0000008600867306ULL, 0x000f220000200c00ULL, 0x0000541082207816ULL, 0x024fe4000000008fULL,
0x0000541090217816ULL, 0x000fc40000000081ULL, 0x000054108e6b7816ULL, 0x008fe4000000006bULL,
0x000088801d8f7816ULL, 0x040fe200000000ffULL, 0x0000008b008b7306ULL, 0x000ea20000200c00ULL,
0x000054106a6a7816ULL, 0x002fe2000000008dULL, 0x000000201430723cULL, 0x040b640000001830ULL,
0x000000ffff817224ULL, 0x000fe400078e008fULL, 0x000100001d8f7824ULL, 0x040fe400078e00ffULL,
0x0000002200737306ULL, 0x0003e40000200c00ULL, 0x0000006a142c723cULL, 0x000b6c000000182cULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000000002320783bULL, 0x022e620000000200ULL,
0x000001001d6b7824ULL, 0x000fe200078e00ffULL, 0x00005410891d7816ULL, 0x010fc40000000086ULL,
0x00000018ff6a7819ULL, 0x000fe4000001148fULL, 0x00000018ff867819ULL, 0x000fe2000001146bULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000088801e6b7816ULL, 0x000fce00000000ffULL,
0x0000001c00827306ULL, 0x0005f00000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000054108b1c7816ULL, 0x004fce000000008cULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x0000001c1428723cULL, 0x000b6e0000001828ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410871c7816ULL, 0x028fe4000000008aULL, 0x00005410881d7816ULL, 0x000fe2000000007fULL,
0x000100001e7f7824ULL, 0x000fc400078e00ffULL, 0x000001001e1e7824ULL, 0x000fe400078e00ffULL,
0x0000007d007d7306ULL, 0x000ee40000200c00ULL, 0x0000001c1424723cULL, 0x000b620000001824ULL,
0x00000018ff1e7819ULL, 0x000fca000001141eULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00005410841c7816ULL, 0x024fe40000000085ULL, 0x00005410831d7816ULL, 0x000fca0000000072ULL,
0x0000007900797306ULL, 0x000fe40000200c00ULL, 0x0000001c1418723cULL, 0x000b6c0000001818ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000054107d147816ULL, 0x028fe40000000080ULL,
0x000054107b157816ULL, 0x000fc4000000007aULL, 0x000088801f1c7816ULL, 0x000fe400000000ffULL,
0x00000018ff167819ULL, 0x000fe2000001147fULL, 0x0000006e006e7306ULL, 0x000ee40000200c00ULL,
0x00000014203c723cULL, 0x002b6c000000183cULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541079147816ULL, 0x024fc4000000007cULL, 0x0000541078157816ULL, 0x000fca0000000071ULL,
0x0000006500657306ULL, 0x000fe40000200c00ULL, 0x000000142038723cULL, 0x000b6c0000001838ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x000000ffff147224ULL, 0x020fe200078e001cULL,
0x0000541075157816ULL, 0x008fe2000000006eULL, 0x000100001f1c7824ULL, 0x000fc400078e00ffULL,
0x000001001f1f7824ULL, 0x000fc600078e00ffULL, 0x0000009b00707306ULL, 0x000ee20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x0000001e00177306ULL, 0x000ff00000200c00ULL, 0x00000014001d7306ULL, 0x0003f00000200c00ULL,
0x0000001c001c7306ULL, 0x000f220000200c00ULL, 0x0000541076147816ULL, 0x002fce0000000077ULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x000000142034723cULL, 0x000b6e0000001834ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054106f147816ULL, 0x024fe40000000074ULL,
0x0000541070157816ULL, 0x008fc40000000065ULL, 0x000054101d1c7816ULL, 0x010fc6000000001cULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00005410827f7816ULL, 0x002fe20000000067ULL,
0x000000142030723cULL, 0x000b6c0000001830ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x0000541017177816ULL, 0x004fce000000006cULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x00005410737e7816ULL, 0x002fce000000007eULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x0000007e202c723cULL, 0x000b6e000000182cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541081147816ULL, 0x024fce000000006aULL, 0x0000001600167306ULL, 0x000ea20000200c00ULL,
0x0000541086157816ULL, 0x002fce0000000069ULL, 0x0000001f001e7306ULL, 0x000e620000200c00ULL,
0x000000142028723cULL, 0x000b620000001828ULL, 0x000054106b167816ULL, 0x004fce0000000016ULL,
0x000000162024723cULL, 0x000b620000001824ULL, 0x000054101e1d7816ULL, 0x002fce000000006dULL,
0x0000001c2018723cULL, 0x000b620000001818ULL, 0xfffff05000000947ULL, 0x000fce000383ffffULL,
0x000000026200780cULL, 0x000fe20003f06070ULL, 0x000000ffff607224ULL, 0x000fe400078e0062ULL,
0x000000ffff157224ULL, 0x020fd400078e0005ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffcaa000007947ULL, 0x000fea000383ffffULL, 0x00000002ff627819ULL, 0x000fc80000011603ULL,
0x0000005d6200720cULL, 0x040fe40003f06070ULL, 0x000000015d5d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000862607810ULL, 0x040fe40007ffe0ffULL, 0x0000005d6200720cULL, 0x000fe40004706470ULL,
0x0000005f6000720cULL, 0x000fe40003f26070ULL, 0x000000065900720cULL, 0x000fc40000703070ULL,
0x0000005d6000720cULL, 0x000fc80000f21070ULL, 0x000000065900720cULL, 0x000fc80000f24470ULL,
0x000000581b587208ULL, 0x000fe40000800000ULL, 0x000000431a437208ULL, 0x000fe20000800000ULL,
0x000000ffff568224ULL, 0x000fe200078e0019ULL, 0x0000004427447208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e0018ULL, 0x0000004526457208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e0025ULL, 0x000000462b467208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0024ULL, 0x000000472a477208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e0029ULL, 0x000000482f487208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e0028ULL, 0x000000492e497208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e002dULL, 0x0000004a334a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e002cULL, 0x0000004b324b7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0031ULL, 0x0000004c374c7208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0030ULL, 0x0000004d364d7208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0035ULL, 0x0000004e3b4e7208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0034ULL, 0x0000004f3a4f7208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e0039ULL, 0x000000503f507208ULL, 0x000fe20000800000ULL,
0x000000ffff408224ULL, 0x000fe200078e0038ULL, 0x000000513e517208ULL, 0x000fe20000800000ULL,
0x000000ffff418224ULL, 0x000fc400078e003dULL, 0x000000ffff428224ULL, 0x000fe200078e003cULL,
0x0000005e5d00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffc6b000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000054147f8cULL, 0x000e62000c80043fULL, 0x0000000242217220ULL, 0x080fe40000410000ULL,
0x0000000241207220ULL, 0x080fe40000410000ULL, 0x00000002401f7220ULL, 0x080fe40000410000ULL,
0x0000000213137220ULL, 0x080fe40000410000ULL, 0x0000000212127220ULL, 0x080fe40000410000ULL,
0x0000000211117220ULL, 0x000fc40000410000ULL, 0x0000000210107220ULL, 0x080fe40000410000ULL,
0x000000020f1e7220ULL, 0x080fe40000410000ULL, 0x000000020e1d7220ULL, 0x080fe40000410000ULL,
0x000000020d1c7220ULL, 0x080fe40000410000ULL, 0x000000020c1b7220ULL, 0x080fe40000410000ULL,
0x000000020b0b7220ULL, 0x000fc40000410000ULL, 0x000000ffff177224ULL, 0x002fe400078e0015ULL,
0x000000020a0a7220ULL, 0x080fe40000410000ULL, 0x0000000209097220ULL, 0x080fe40000410000ULL,
0x00000002551a7220ULL, 0x080fe40000410000ULL, 0x0000000256197220ULL, 0x080fe40000410000ULL,
0x0000000251327220ULL, 0x000fc40000410000ULL, 0x0000000250317220ULL, 0x080fe40000410000ULL,
0x000000024f337220ULL, 0x080fe40000410000ULL, 0x000000024e2f7220ULL, 0x080fe40000410000ULL,
0x000000024d2e7220ULL, 0x080fe40000410000ULL, 0x000000024c2b7220ULL, 0x080fe40000410000ULL,
0x000000024b2a7220ULL, 0x000fc40000410000ULL, 0x000000024a297220ULL, 0x080fe40000410000ULL,
0x0000000249287220ULL, 0x080fe40000410000ULL, 0x0000000248277220ULL, 0x080fe40000410000ULL,
0x0000000247267220ULL, 0x080fe40000410000ULL, 0x0000000246257220ULL, 0x080fe40000410000ULL,
0x0000000245247220ULL, 0x000fc40000410000ULL, 0x0000000244237220ULL, 0x080fe40000410000ULL,
0x0000000243227220ULL, 0x080fe40000410000ULL, 0x0000000258187220ULL, 0x000fc40000410000ULL,
0x00000000000c7805ULL, 0x000fca0000015200ULL, 0x00000400540e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400540e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403177824ULL, 0x000fe200078e00ffULL,
0x000000530600720cULL, 0x000fc80003f05270ULL, 0xfffffff0170d7812ULL, 0x000fca00078ec0ffULL,
0x00000080042c7824ULL, 0x000fca00078e020dULL, 0x018400002c0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203147824ULL, 0x000fe400078e00ffULL,
0x000000015c577824ULL, 0x000fc600078e0a57ULL, 0x0000000614147812ULL, 0x000fc800078ec0ffULL,
0x0000000114167812ULL, 0x040fe400078efcffULL, 0x0000000814307812ULL, 0x000fe400078efcffULL,
0x000000571600720cULL, 0x080fe40003f26070ULL, 0x0000001014167812ULL, 0x000fe400078efcffULL,
0x000000573000720cULL, 0x080fe40003f06070ULL, 0x000000571600720cULL, 0x000fc40003fc6070ULL,
0x0000001114307812ULL, 0x040fe400078efcffULL, 0x0000001814167812ULL, 0x040fe400078efcffULL,
0x000000571400720cULL, 0x080fe40003f46070ULL, 0x000000573000720cULL, 0x080fe40003fa6070ULL,
0x000000571600720cULL, 0x000fe40003f66070ULL, 0x0000000914347812ULL, 0x000fc400078efcffULL,
0x0000001914307812ULL, 0x040fe400078efcffULL, 0x0000002014167812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff80000031317808ULL, 0x000fe40004800000ULL, 0xff80000020207808ULL, 0x000fc40004800000ULL,
0x000000573400720cULL, 0x080fe40003f86070ULL, 0x000000573000720cULL, 0x080fe40003f46070ULL,
0x000000571600720cULL, 0x000fe40003f26070ULL, 0x0000002114307812ULL, 0x040fe400078efcffULL,
0x0000002814167812ULL, 0x000fe400078efcffULL, 0xff80000033337808ULL, 0x000fc40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40006000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0x000000573000720cULL, 0x080fe40003f06070ULL,
0x000000571600720cULL, 0x000fe40003f86070ULL, 0x0000002914307812ULL, 0x000fc400078efcffULL,
0x0000003014167812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006800000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0x000000573000720cULL, 0x000fc40003fc6070ULL,
0x000000571600720cULL, 0x000fe40003fa6070ULL, 0x0000003114307812ULL, 0x040fe400078efcffULL,
0x0000003814167812ULL, 0x040fe400078efcffULL, 0x0000003914147812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0x000000573000720cULL, 0x080fe40003f66070ULL, 0x000000571600720cULL, 0x000fc40003f46070ULL,
0x000000571400720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000001b1b7808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fc40007000000ULL,
0xff8000000b0b7808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff8000000a0a7808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff80000009097808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff80000018187808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fc40004800000ULL, 0x000000210c00720bULL, 0x004fe40003f1e000ULL,
0x000000320d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c21157208ULL, 0x000fe40004000000ULL,
0x0000000d320c7208ULL, 0x000fc40004800000ULL, 0x000000201500720bULL, 0x000fe40003f1e000ULL,
0x000000310c00720bULL, 0x000fe40003f3e000ULL, 0x0000001520147208ULL, 0x000fe40004000000ULL,
0x0000000c310c7208ULL, 0x000fe40004800000ULL, 0x0000001f1400720bULL, 0x000fe40003f1e000ULL,
0x000000330c00720bULL, 0x000fc40003f3e000ULL, 0x000000141f147208ULL, 0x000fe40004000000ULL,
0x0000000c330c7208ULL, 0x000fe40004800000ULL, 0x000000131400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x00000014130d7208ULL, 0x000fe40004000000ULL,
0x0000000c2f157208ULL, 0x000fc40004800000ULL, 0x000000120d00720bULL, 0x000fe40003f1e000ULL,
0x0000002e1500720bULL, 0x000fe40003f3e000ULL, 0x0000000d120c7208ULL, 0x000fe40004000000ULL,
0x000000152e147208ULL, 0x000fe40004800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x0000002b1400720bULL, 0x000fc40003f3e000ULL, 0x0000000c110d7208ULL, 0x000fe40004000000ULL,
0x000000142b157208ULL, 0x000fe40004800000ULL, 0x000000100d00720bULL, 0x000fe40003f1e000ULL,
0x0000002a1500720bULL, 0x000fe40003f3e000ULL, 0x0000000d100d7208ULL, 0x000fe40004000000ULL,
0x000000152a0c7208ULL, 0x000fc40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000000d1e147208ULL, 0x000fe40004000000ULL,
0x0000000c290d7208ULL, 0x000fe40004800000ULL, 0x0000001d1400720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x000000141d157208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x0000001c1500720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x000000151c147208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fc40004800000ULL, 0x0000001b1400720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x000000141b147208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fe40004800000ULL, 0x0000000b1400720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x000000140b0d7208ULL, 0x000fe40004000000ULL,
0x0000000c25157208ULL, 0x000fe40004800000ULL, 0x0000000a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000241500720bULL, 0x000fe40003f3e000ULL, 0x0000000d0a0c7208ULL, 0x000fe40004000000ULL,
0x0000001524147208ULL, 0x000fc40004800000ULL, 0x000000090c00720bULL, 0x000fe40003f1e000ULL,
0x000000231400720bULL, 0x000fe40003f3e000ULL, 0x0000000c090d7208ULL, 0x000fe40004000000ULL,
0x0000001423157208ULL, 0x000fe40004800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000221500720bULL, 0x000fc40003f3e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004000000ULL,
0x0000001522157208ULL, 0x000fe40004800000ULL, 0x000000190c00720bULL, 0x000fe40003f1e000ULL,
0x000000181500720bULL, 0x000fe40003f3e000ULL, 0x0000000c19347208ULL, 0x000fe40004000000ULL,
0x00000015182d7208ULL, 0x000fe20004800000ULL, 0x00001cc27f007947ULL, 0x000fec000b800000ULL,
0x0c401f00340c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3400720bULL, 0x008fc80003f1e000ULL,
0x000000340c367208ULL, 0x000fe20004000000ULL, 0x00001cf27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d0c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f147f89ULL, 0x000e6800000e0000ULL, 0x0c201f0036157f89ULL, 0x000ea200000e0000ULL,
0x0000000c2d00720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x0000002d0c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000140f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c357f89ULL, 0x000e6600000e0000ULL,
0x0000000f142d7208ULL, 0x000fe20004000000ULL, 0x0c201f000d167f89ULL, 0x000ee200000e0000ULL,
0x000000153600720bULL, 0x004fc60003f1e000ULL, 0x0c201f002d307f89ULL, 0x0004a200000e0000ULL,
0x0000003615147208ULL, 0x000fe40004000000ULL, 0x000000350c00720bULL, 0x002fe40003f3e000ULL,
0x000000160d00720bULL, 0x008fe40003f5e000ULL, 0x0000000c35157208ULL, 0x000fe40004800000ULL,
0x0000000d16167208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b15347820ULL, 0x006fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000862367824ULL, 0x000fe200078e00ffULL,
0x0001200008047891ULL, 0x000fe2000f8e583fULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL,
0x0000000662377810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010834ULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003200517308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL, 0x000000302d00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fc40000010834ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL, 0x0000003100507308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b14327820ULL, 0x002fe40000410000ULL, 0x3fb8aa3b26267823ULL, 0x000fe40000010834ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x00000033004f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL,
0x0000000462317810ULL, 0x004fe20007ffe0ffULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc40000010832ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL, 0xfffffff836357812ULL, 0x000fe200078ee231ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010834ULL, 0x0000002f004e7308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL, 0x0000000435357c11ULL, 0x000fe2000f8e20ffULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b29297823ULL, 0x100fe40000010834ULL,
0x3fb8aa3b28287823ULL, 0x000fe20000010834ULL, 0x0000002100427308ULL, 0x000fe20000000800ULL,
0x3c003c00ff2f7424ULL, 0x002fc400078e00ffULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b11117823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010832ULL,
0x0000002000417308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1e0f7823ULL, 0x000fe40000010832ULL,
0x3fb8aa3b23237823ULL, 0x100fe40000010834ULL, 0x3fb8aa3b22227823ULL, 0x000fc40000010834ULL,
0x3fb8aa3b1d0e7823ULL, 0x100fe20000010832ULL, 0x0000001f00407308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1c0d7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b1b0c7823ULL, 0x100fe20000010832ULL,
0x00000001621b7810ULL, 0x040fe20007ffe0ffULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe40000010832ULL,
0x00000008621c7824ULL, 0x000fe200078e00ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x3fb8aa3b0a0a7823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b09097823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b19197823ULL, 0x000fe20000010832ULL,
0x0000002e004d7308ULL, 0x0007e20000000800ULL, 0xfffffff81c327812ULL, 0x000fe200078ee21bULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010834ULL, 0x00000003621b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000862337824ULL, 0x040fe400078e00ffULL, 0x0000000862347824ULL, 0x000fc400078e00ffULL,
0x0000002700487308ULL, 0x0005e20000000800ULL, 0x3c003c00ff2e7424ULL, 0x008fe400078e00ffULL,
0x0000000862387824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee21bULL,
0x0000000862317824ULL, 0x040fe400078e00ffULL, 0x00000008623a7824ULL, 0x000fe200078e00ffULL,
0x0000002600477308ULL, 0x0003e20000000800ULL, 0x0000004f4e27723eULL, 0x004fe200000000ffULL,
0x0000000862397824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee262ULL,
0x00000008603b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a377812ULL, 0x000fc400078ee237ULL,
0x0000000431317c11ULL, 0x000fe2000f8e20ffULL, 0x0000002500467308ULL, 0x0004e20000000800ULL,
0x000000401326723eULL, 0x002fe400000000ffULL, 0xfffffff83b607812ULL, 0x000fe400078ee260ULL,
0x0000000437377c11ULL, 0x000fe4000f8e20ffULL, 0x00000004603b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002400457308ULL, 0x0003e20000000800ULL, 0x000000515025723eULL, 0x004fce00000000ffULL,
0x0000002b004c7308ULL, 0x000ea20000000800ULL, 0x000000424124723eULL, 0x002fe400000000ffULL,
0x00000047461f723eULL, 0x008fca00000000ffULL, 0x0000002a004b7308ULL, 0x000ff00000000800ULL,
0x00000029004a7308ULL, 0x000fe20000000800ULL, 0x0000004d4c21723eULL, 0x004fce00000000ffULL,
0x0000002800497308ULL, 0x0002b00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000002e2428723cULL, 0x002f6e00000018ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x00000049481d723eULL, 0x004fce00000000ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x000000121120723eULL, 0x002fce00000000ffULL,
0x0000002300447308ULL, 0x0003f00000000800ULL, 0x0000002200437308ULL, 0x0005e20000000800ULL,
0x0000004b4a23723eULL, 0x002fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000100f22723eULL, 0x004fce00000000ffULL, 0x0000002e2028723cULL, 0x020f620000001828ULL,
0x0000000d000d7308ULL, 0x000e700000000800ULL, 0x0000000c000c7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000000e0d1c723eULL, 0x002fce00000000ffULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x0000000c0b1e723eULL, 0x004fce00000000ffULL,
0x0000000900097308ULL, 0x000e620000000800ULL, 0x0000002e1c28723cULL, 0x020f6e0000001828ULL,
0x0000001a00557308ULL, 0x0005f00000000800ULL, 0x0000001900567308ULL, 0x0007220000000800ULL,
0x00000002621a7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff833337812ULL, 0x000fc600078ee21aULL,
0x0000001800587308ULL, 0x0002a20000000800ULL, 0x0000000562197810ULL, 0x008fe40007ffe0ffULL,
0x0000000433337c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff838367812ULL, 0x000fe400078ee219ULL,
0x000000454419723eULL, 0x000fe400000000ffULL, 0x0000000a0918723eULL, 0x002fe400000000ffULL,
0x00000055561a723eULL, 0x010fc400000000ffULL, 0xffffffff62387810ULL, 0x000fe40007ffe0ffULL,
0x00000043581b723eULL, 0x004fe400000000ffULL, 0xfffffff839387812ULL, 0x000fc800078ee238ULL,
0x0000000438397c11ULL, 0x000fe2000f8e20ffULL, 0x0000002e1828723cULL, 0x020b6e0000001828ULL,
0x0000000c172e7812ULL, 0x020fe400078ec0ffULL, 0x0000000432177c11ULL, 0x000fc4000f8e20ffULL,
0x00000004362f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000131317824ULL, 0x000fe400078e022eULL,
0x000000012e337824ULL, 0x040fe400078e0233ULL, 0x000000012e357824ULL, 0x040fe200078e0235ULL,
0x0000002431007388ULL, 0x0003e20000000800ULL, 0x000000012e2f7824ULL, 0x000fe400078e022fULL,
0x00000004342b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000012e297824ULL, 0x000fe200078e0217ULL,
0x0000002d30177208ULL, 0x000fe20004800000ULL, 0x000000012e377824ULL, 0x000fc400078e0237ULL,
0x000000012e2b7824ULL, 0x040fe200078e022bULL, 0x0000002629007388ULL, 0x0005e20000000800ULL,
0x000000012e397824ULL, 0x040fe400078e0239ULL, 0x000000012e2e7824ULL, 0x000fe200078e023bULL,
0x0000002033007388ULL, 0x0005e20000000800ULL, 0x000000ffff307224ULL, 0x000fe400078e0028ULL,
0x000000ffff317224ULL, 0x002fe200078e002aULL, 0x000000222b007388ULL, 0x0005e80000000800ULL,
0x0000001c35007388ULL, 0x0005e80000000800ULL, 0x0000001e2f007388ULL, 0x0005e80000000800ULL,
0x0000001837007388ULL, 0x0005e80000000800ULL, 0x0000001a39007388ULL, 0x0005e80000000800ULL,
0x000000252e007388ULL, 0x0005e80000000800ULL, 0x0004002729007388ULL, 0x0005e80000000800ULL,
0x0004002133007388ULL, 0x0005e80000000800ULL, 0x000400232b007388ULL, 0x0005e80000000800ULL,
0x0004001d35007388ULL, 0x0005e80000000800ULL, 0x0004001f2f007388ULL, 0x0005e80000000800ULL,
0x0004001937007388ULL, 0x0005e80000000800ULL, 0x0004001b39007388ULL, 0x0005e80000000800ULL,
0x018000142c008388ULL, 0x0005e80000000c00ULL, 0x018200302c008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000052ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080052ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100052ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000106067810ULL, 0x000fe20007ffe0ffULL,
0x0000180052ff7f8cULL, 0x0003e6000c80043fULL, 0x0000005b0600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffac0000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff207807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x000204d000247802ULL, 0x000fc40000000f00ULL,
0x0000155000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xfffe2fa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0002053000247802ULL, 0x000fc40000000f00ULL,
0x000014f000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff237224ULL, 0x000fe200078e0025ULL,
0xfffe2fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0013ULL,
0x000205b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e0024ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000143000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffe305000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0024ULL,
0x0002063000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0013ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000013b000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffe313000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001cULL,
0x000206b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e001dULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000133000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe32e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e001bULL,
0x0002073000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe400078e001cULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000012b000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe329000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000207b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000123000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe5a3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0002083000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000011b000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe59d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0002089000247802ULL, 0x000fc40000000f00ULL,
0x0000119000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xfffe859000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x000208f000247802ULL, 0x000fc40000000f00ULL,
0x0000113000007944ULL, 0x008fea0003c00000ULL, 0xfffe85d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0002096000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000108000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffe864000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x000209e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000100000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffe871000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00020a6000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00000f8000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffe88b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00020ae000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00000f0000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffe885000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00020b6000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00000e8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffeadd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00020be000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffead7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00020c4000247802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffed81000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00020ca000247802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x008fea0003c00000ULL,
0xfffed85000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x00020d1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000cd000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffed8c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x00020d9000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffed99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020e1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffedb3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020e9000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000b5000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffedad000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020f1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000ad000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff005000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020f9000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000a5000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffefff000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00020ff000247802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xffff2a9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0002105000247802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x008fea0003c00000ULL, 0xffff2ad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x000210c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000092000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff2b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0002114000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff2c1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000211c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000082000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff2db000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002124000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000007a000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff2d5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000212c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff52d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002134000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000006a000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff527000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0006ULL, 0x000213b000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0026ULL,
0xffff668000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0002142000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000005c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0026ULL, 0xffff675000007947ULL, 0x000fea000383ffffULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x00021490000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0030ULL,
0xffffe2e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x006fe200078e002dULL,
0x00021510000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fc400078e00ffULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x000000302d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000eULL, 0x00021590000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000002d30157208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x000000300e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x00021610000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000000e30377208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x000000300f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0036ULL, 0x00021690000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000f302d7208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000303600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0015ULL, 0x00021710000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000003630147208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x000000301500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0037ULL, 0x00021790000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000001530157208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000303700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e002dULL, 0x00021810000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000003730167208ULL, 0x000fe20004000000ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff397424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffe0d000007947ULL, 0x000fea000383ffffULL,
0x0180000012007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001200008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff12ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000012027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001200007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0006ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffde66002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0c00003534307389ULL, 0x0002a200000e0030ULL, 0xfffde6200c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000002d00007348ULL, 0x000fe80003800000ULL,
0x0000002726267389ULL, 0x0002a200000e0028ULL, 0xfffde5e020007950ULL, 0x000fea0003c3ffffULL,
0x000000012000780cULL, 0x000fe20003f25070ULL, 0x0000002500007348ULL, 0x000fe80003800000ULL,
0x00000000ff217424ULL, 0x000fd000078e00ffULL, 0x0000000000207806ULL, 0x000fc800048e0100ULL,
0x0000002520257212ULL, 0x000fe200078ec0ffULL, 0x000000ffff207224ULL, 0x000fc800078e0024ULL,
0xfffde57020007950ULL, 0x000fea0003c3ffffULL, 0x0000001d00007348ULL, 0x000fe80003800000ULL,
0x00000000ff1d7424ULL, 0x000fc800078e00ffULL, 0xfffde5401c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000410ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e10ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ef4ULL, 0x0000000000000c40ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b38ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b48ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bf8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001bfcULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e00ULL, 0x0000000000021b80ULL, 0x9e00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023980ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000239d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000023d50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001bf8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000021d88ULL, 0x0000000000021d88ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000023980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000023d50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_64_nqpkv_1_m_1_sm_80_cubin_len = 146992;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
