/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000216d0ULL, 0x0000000000021350ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x000000000001f180ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x000000000001f310ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x000000000001f350ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x000000000001f390ULL,
0x0000000000000070ULL, 0x000b00220000053dULL, 0x000000000001f400ULL, 0x0000000000000100ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001f500ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001f18000000000ULL, 0x0000040400000000ULL, 0x810c000001700400ULL,
0x007ae40400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9208288080850828ULL, 0x2880809508288080ULL, 0x809a082880809808ULL, 0x082880809b082880ULL,
0x8080a408288080a0ULL, 0xa708288080a60828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808086ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001f18000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL,
0x0900000004042880ULL, 0x2880808228808086ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880808608288080ULL, 0x8095082880809208ULL, 0x0828808098082880ULL,
0x80809b082880809aULL, 0xa408288080a00828ULL, 0x288080a708288080ULL, 0x8280162880808c08ULL,
0x0000000003102880ULL, 0x80808c9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x0001f31000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL,
0x8095082880809208ULL, 0x0828808098082880ULL, 0x80809b082880809aULL, 0xa608288080a40828ULL,
0x288080a708288080ULL, 0x828016288080a008ULL, 0x0000000003102880ULL, 0x8080a09200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000001e000000000ULL, 0x0001f35000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880808608288080ULL, 0x8095082880809208ULL, 0x0828808098082880ULL,
0x80809b082880809aULL, 0xa608288080a00828ULL, 0x288080a708288080ULL, 0x828016288080a408ULL,
0x0000000003102880ULL, 0x8080a49200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL,
0x0000029000000000ULL, 0x0001f39000000000ULL, 0x0000007000000000ULL, 0x0000180400000000ULL,
0x80a0288080a40900ULL, 0x0000000000002880ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880808608288080ULL, 0x8095082880809208ULL, 0x0828808098082880ULL,
0x80809b082880809aULL, 0xa608288080a40828ULL, 0x288080a708288080ULL, 0x828016288080a008ULL,
0x0000000003102880ULL, 0x8080a09200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000035000000000ULL, 0x0001f40000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x00082304000000a0ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL, 0x0000001b00081104ULL,
0x0004370400000000ULL, 0x00080a040000007bULL, 0x0068016000000018ULL, 0x000c170400681903ULL,
0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL, 0x000c17040021f000ULL,
0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL, 0x000c17040061f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000003000043104ULL, 0xffffffff01bc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010001bc2804ULL, 0x0000044000000120ULL, 0x000035e000003550ULL,
0x00003840000036e0ULL, 0x00003aa000003a70ULL, 0x00003b4000003af0ULL, 0x000062a000006280ULL,
0x00006340000062f0ULL, 0x00008f1000008e80ULL, 0x0000915000009000ULL, 0x0000939000009370ULL,
0x00009430000093e0ULL, 0x0000b9900000b970ULL, 0x0000ba300000b9e0ULL, 0x0000e4f00000e460ULL,
0x0000e7300000e5e0ULL, 0x0000e9700000e950ULL, 0x0000ea100000e9c0ULL, 0x00010f7000010f50ULL,
0x0001101000010fc0ULL, 0x00013ad000013a40ULL, 0x00013d1000013bc0ULL, 0x00013f5000013f30ULL,
0x00013ff000013fa0ULL, 0x0001655000016530ULL, 0x000165f0000165a0ULL, 0x00017af0000179b0ULL,
0x000180f0000180d0ULL, 0x0001963000018580ULL, 0x0001a0b00001a090ULL, 0x0001b1800001b160ULL,
0x0001d5e00001d5a0ULL, 0x0001d6000001d5f0ULL, 0x0001d6700001d610ULL, 0x0001d6b00001d690ULL,
0x0001e3200001e2d0ULL, 0x0001e3e00001e380ULL, 0x0001e4a00001e440ULL, 0x0001e5600001e500ULL,
0x0001e6000001e5b0ULL, 0x0001e6b00001e650ULL, 0x0001e7700001e710ULL, 0x0001e8300001e7d0ULL,
0x0001e8d00001e880ULL, 0x0001e9800001e920ULL, 0x0001ea400001e9e0ULL, 0x0001eb000001eaa0ULL,
0x0001eba00001eb50ULL, 0x0001ec500001ebf0ULL, 0x0001ed100001ecb0ULL, 0x0001edd00001ed70ULL,
0x0001ee700001ee20ULL, 0x0001ef200001eec0ULL, 0x0001efe00001ef80ULL, 0x0001f0a00001f040ULL,
0x0001f1600001f100ULL, 0x0000021007e03904ULL, 0x00010ad0000000ffULL, 0x00000240003f0100ULL,
0x00010ad80000000bULL, 0x00000270003f0120ULL, 0x00010b580000000bULL, 0x000002a0003f0120ULL,
0x00010b780000000bULL, 0x00000390003f0120ULL, 0x00010b88000000ffULL, 0x00000550003f0100ULL,
0x00010ad0000000ffULL, 0x00000840003f0107ULL, 0x00010b5c000000ffULL, 0x000008a000050102ULL,
0x00010b58000000ffULL, 0x00000a2000050101ULL, 0x00010b88000000ffULL, 0x00000a60003f0101ULL,
0x00010b8c000000ffULL, 0x00000c20003f0105ULL, 0x00010b8c000000ffULL, 0x00001650003f0105ULL,
0x00010b88000000ffULL, 0x00001680003f0101ULL, 0x00010b8c000000ffULL, 0x00001850003f0105ULL,
0x00010b8c000000ffULL, 0x000019c0003f0105ULL, 0x00010b78000000ffULL, 0x00001a40003f0107ULL,
0x00010b78000000ffULL, 0x00001aa0003f0101ULL, 0x00010b88000000ffULL, 0x00001d80003f0101ULL,
0x00010b7c000000ffULL, 0x00001f40003f0105ULL, 0x00010b7c000000ffULL, 0x00001fa0003f0105ULL,
0x00010b8c000000ffULL, 0x00002170003f0105ULL, 0x00010b8c000000ffULL, 0x00002bc0003f0105ULL,
0x00010b88000000ffULL, 0x00002bf0003f0101ULL, 0x00010b8c000000ffULL, 0x00002dc0003f0105ULL,
0x00010b8c000000ffULL, 0x00003140003f0105ULL, 0x00010b80000000ffULL, 0x000031c0003f0107ULL,
0x00010b80000000ffULL, 0x00003270003f0101ULL, 0x00010ad8000000ffULL, 0x000032a000050101ULL,
0x00010adc000000ffULL, 0x0000347000050105ULL, 0x00010adc000000ffULL, 0x00004ec000050105ULL,
0x00010b88000000ffULL, 0x00004f90003f0101ULL, 0x00010b84000000ffULL, 0x00005150003f0105ULL,
0x00010b84000000ffULL, 0x000051b0003f0105ULL, 0x00010b8c000000ffULL, 0x00005380003f0105ULL,
0x00010b8c000000ffULL, 0x00005dc0003f0105ULL, 0x00010b88000000ffULL, 0x00005df0003f0101ULL,
0x00010b8c000000ffULL, 0x00005fc0003f0105ULL, 0x00010b8c000000ffULL, 0x00006190003f0105ULL,
0x00010b78000000ffULL, 0x00006210003f0107ULL, 0x00010b78000000ffULL, 0x00007570003f0101ULL,
0x00010b88000000ffULL, 0x00007620003f0101ULL, 0x00010b58000000ffULL, 0x00007700003f0101ULL,
0x00010b7c000000ffULL, 0x000078c0003f0105ULL, 0x00010b7c000000ffULL, 0x00007920003f0105ULL,
0x00010b8c000000ffULL, 0x00007af0003f0105ULL, 0x00010b8c000000ffULL, 0x00008530003f0105ULL,
0x00010b88000000ffULL, 0x00008560003f0101ULL, 0x00010b8c000000ffULL, 0x00008730003f0105ULL,
0x00010b8c000000ffULL, 0x00008a80003f0105ULL, 0x00010b80000000ffULL, 0x00008b00003f0107ULL,
0x00010b80000000ffULL, 0x00008ba0003f0101ULL, 0x00010af8000000ffULL, 0x00008bd000050101ULL,
0x00010afc000000ffULL, 0x00008da000050105ULL, 0x00010afc000000ffULL, 0x0000a5b000050105ULL,
0x00010b88000000ffULL, 0x0000a690003f0101ULL, 0x00010b84000000ffULL, 0x0000a850003f0105ULL,
0x00010b84000000ffULL, 0x0000a8b0003f0105ULL, 0x00010b8c000000ffULL, 0x0000aa80003f0105ULL,
0x00010b8c000000ffULL, 0x0000b4c0003f0105ULL, 0x00010b88000000ffULL, 0x0000b4f0003f0101ULL,
0x00010b8c000000ffULL, 0x0000b6c0003f0105ULL, 0x00010b8c000000ffULL, 0x0000b890003f0105ULL,
0x00010b78000000ffULL, 0x0000b910003f0107ULL, 0x00010b78000000ffULL, 0x0000cb70003f0101ULL,
0x00010b88000000ffULL, 0x0000cc00003f0101ULL, 0x00010b60000000ffULL, 0x0000cce0003f0101ULL,
0x00010b7c000000ffULL, 0x0000cea0003f0105ULL, 0x00010b7c000000ffULL, 0x0000cf00003f0105ULL,
0x00010b8c000000ffULL, 0x0000d0d0003f0105ULL, 0x00010b8c000000ffULL, 0x0000db10003f0105ULL,
0x00010b88000000ffULL, 0x0000db40003f0101ULL, 0x00010b8c000000ffULL, 0x0000dd10003f0105ULL,
0x00010b8c000000ffULL, 0x0000e060003f0105ULL, 0x00010b80000000ffULL, 0x0000e0e0003f0107ULL,
0x00010b80000000ffULL, 0x0000e180003f0101ULL, 0x00010b18000000ffULL, 0x0000e1b000050101ULL,
0x00010b1c000000ffULL, 0x0000e38000050105ULL, 0x00010b1c000000ffULL, 0x0000fb9000050105ULL,
0x00010b88000000ffULL, 0x0000fc70003f0101ULL, 0x00010b84000000ffULL, 0x0000fe30003f0105ULL,
0x00010b84000000ffULL, 0x0000fe90003f0105ULL, 0x00010b8c000000ffULL, 0x00010060003f0105ULL,
0x00010b8c000000ffULL, 0x00010aa0003f0105ULL, 0x00010b88000000ffULL, 0x00010ad0003f0101ULL,
0x00010b8c000000ffULL, 0x00010ca0003f0105ULL, 0x00010b8c000000ffULL, 0x00010e70003f0105ULL,
0x00010b78000000ffULL, 0x00010ef0003f0107ULL, 0x00010b78000000ffULL, 0x00012150003f0101ULL,
0x00010b88000000ffULL, 0x000121e0003f0101ULL, 0x00010b68000000ffULL, 0x000122c0003f0101ULL,
0x00010b7c000000ffULL, 0x00012480003f0105ULL, 0x00010b7c000000ffULL, 0x000124e0003f0105ULL,
0x00010b8c000000ffULL, 0x000126b0003f0105ULL, 0x00010b8c000000ffULL, 0x000130f0003f0105ULL,
0x00010b88000000ffULL, 0x00013120003f0101ULL, 0x00010b8c000000ffULL, 0x000132f0003f0105ULL,
0x00010b8c000000ffULL, 0x00013640003f0105ULL, 0x00010b80000000ffULL, 0x000136c0003f0107ULL,
0x00010b80000000ffULL, 0x00013760003f0101ULL, 0x00010b38000000ffULL, 0x0001379000050101ULL,
0x00010b3c000000ffULL, 0x0001396000050105ULL, 0x00010b3c000000ffULL, 0x0001517000050105ULL,
0x00010b88000000ffULL, 0x00015250003f0101ULL, 0x00010b84000000ffULL, 0x00015410003f0105ULL,
0x00010b84000000ffULL, 0x00015470003f0105ULL, 0x00010b8c000000ffULL, 0x00015640003f0105ULL,
0x00010b8c000000ffULL, 0x00016080003f0105ULL, 0x00010b88000000ffULL, 0x000160b0003f0101ULL,
0x00010b8c000000ffULL, 0x00016280003f0105ULL, 0x00010b8c000000ffULL, 0x00016450003f0105ULL,
0x00010b78000000ffULL, 0x000164d0003f0107ULL, 0x00010b78000000ffULL, 0x00017730003f0101ULL,
0x00010b88000000ffULL, 0x000177b0003f0101ULL, 0x00010b70000000ffULL, 0x00018320003f0101ULL,
0x00010ad0000000ffULL, 0x00019660003f0101ULL, 0x00010ad4000000ffULL, 0x00019830003f0105ULL,
0x00010ad4000000ffULL, 0x00019bb0003f0105ULL, 0x00010ad0000000ffULL, 0x00019bf0003f0101ULL,
0x00010ad4000000ffULL, 0x00019db0003f0105ULL, 0x00010ad4000000ffULL, 0x0001c8a0003f0105ULL,
0x0000000000000052ULL, 0x0001cad0003f0101ULL, 0x0000000400000052ULL, 0x0001cca0003f0105ULL,
0x0000000400000052ULL, 0x0001e130003f0105ULL, 0x0000000000000005ULL, 0x0001e190003f0101ULL,
0x0000000800000005ULL, 0x0001e1f0003f0101ULL, 0x0000001000000005ULL, 0x0001e260003f0101ULL,
0x0000001800000005ULL, 0x00053803003f0101ULL, 0x0001822000101c04ULL, 0x00019ee000019e10ULL,
0x000004010001e2a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003ecULL, 0x0000001b00000002ULL,
0x000000000000032cULL, 0x0000001b00000002ULL, 0x000000000000027cULL, 0x0000001b00000002ULL,
0x00000000000001ccULL, 0x0000001b00000002ULL, 0x0000000000000104ULL, 0x0000001b00000002ULL,
0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000003c4ULL, 0x0000001b00000002ULL,
0x0000000000000304ULL, 0x0000001b00000002ULL, 0x0000000000000254ULL, 0x0000001b00000002ULL,
0x00000000000001a4ULL, 0x0000001b00000002ULL, 0x00000000000000dfULL, 0x0000001b00000002ULL,
0x0000000000010c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000001379c3ULL, 0x000ea20000002700ULL, 0x00000000000c7806ULL, 0x000fe200038e0000ULL,
0x00005800000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee20000002300ULL,
0x00000200000f7882ULL, 0x000fe20000000000ULL, 0x0000000c00067300ULL, 0x000fe200000e0000ULL,
0x00005c0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000f220000002200ULL,
0x00000000000d79c3ULL, 0x000ea20000002600ULL, 0x0000460000107ab9ULL, 0x000fc40000000a00ULL,
0x00000000000d7919ULL, 0x000ea40000000000ULL, 0x0000000c000c7309ULL, 0x000ee40000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000005ff007819ULL, 0x002fc6000001160bULL,
0x00001fff03047589ULL, 0x008e6200000e0000ULL, 0x000000ffff0c7224ULL, 0x000fc600078e0a0cULL,
0x00001fff00007589ULL, 0x000ee200000e0000ULL, 0x0000010003027a24ULL, 0x010fc800078e0202ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000070600720cULL, 0x004fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x040fe40003f44070ULL, 0x0000007f0b00780cULL, 0x040fe40003f64070ULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00000000041273c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000000000873c2ULL, 0x008ea200000e0000ULL,
0x3fffffc0ff049424ULL, 0x002fe200078e00ffULL, 0x010ad002ff00d388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07a424ULL, 0x000fe200078e00ffULL,
0x010ad8040b009388ULL, 0x0007e20000008a00ULL, 0xff317217ff0ab424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08c424ULL, 0x000fe200078e00ffULL, 0x010b58060b00a388ULL, 0x0009e20000008a00ULL,
0x7fffff00ff09c424ULL, 0x000fc600078e00ffULL, 0x0104000a0b00b388ULL, 0x000fe80000004800ULL,
0x010b78080b00c388ULL, 0x000fe20000008a00ULL, 0x0000000812047291ULL, 0x004fc8000f8e103fULL,
0x00000001040a7899ULL, 0x000fe4000800063fULL, 0x000000020e047899ULL, 0x000fe4000800063fULL,
0x000000010a0c7890ULL, 0x000fe4000fffe03fULL, 0x0000000aff027e24ULL, 0x002fe2000f8e00ffULL,
0x0000000a0d007c10ULL, 0x000fe2000fffe0ffULL, 0x00000013040972a4ULL, 0x000fe4000f8e020dULL,
0x0000002002057824ULL, 0x008fe200078e00ffULL, 0x000000040a00788cULL, 0x000fe2000bf01070ULL,
0x3fffff80ff02d424ULL, 0x000fe200078e00ffULL, 0x0000000e0a0472a4ULL, 0x000fc4000f8e0209ULL,
0xffffffe005047812ULL, 0x000fe200078ee200ULL, 0x0000000cff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000040a0b7887ULL, 0x000fe2000c000000ULL, 0x010b8802ff00d388ULL, 0x000fe20000000a00ULL,
0x0000000f040472a5ULL, 0x000fe2000f8e0006ULL, 0x0000002000067824ULL, 0x010fe200078e00ffULL,
0x0000000b0a0b7290ULL, 0x000fe2000fffe13fULL, 0x000000100d007824ULL, 0x040fe200078e00ffULL,
0x0000000e0c0972a4ULL, 0x000fe2000f8e0209ULL, 0x0000000c0d057c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b00788cULL, 0x000fe2000bf03070ULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x000001f000007812ULL, 0x000fe200078ec0ffULL, 0x0000000f090672a5ULL, 0x000fe2000f8e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400027c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000400097882ULL, 0x000fe20000000000ULL, 0x0000000bff007c0cULL, 0x000fe2000bf26070ULL,
0x00000002130a7899ULL, 0x000fe2000800063fULL, 0xffffffe006067812ULL, 0x000fe200078ee205ULL,
0x00000005ff037e24ULL, 0x000fe200090e06ffULL, 0x000000000000781cULL, 0x000fc40003f4f008ULL,
0x0000000600047c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e000cULL, 0x00000007ff057e24ULL, 0x000fe400098e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c50ULL,
0x0000000004097faeULL, 0x0003e8000d101c50ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x010ad400ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000620000047ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL, 0x00006a0000067ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL, 0x00000004ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fe4000f8e00ffULL, 0x00000006ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000007ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000010025f7981ULL, 0x000ea8000c1e1900ULL,
0x0000001004047981ULL, 0x000ee2000c1e1900ULL, 0x00000012ff007c0cULL, 0x000fe2000bf05270ULL,
0xffffffffff007424ULL, 0x000fe200078e00ffULL, 0x0000007f5f5d7810ULL, 0x004fc40007ffe0ffULL,
0x000000ff5f0a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff5e7819ULL, 0x008fe40000011604ULL,
0x00000007ff5d7819ULL, 0x000fe4000001165dULL, 0x00000008ff607819ULL, 0x000fc6000001160aULL,
0x00017b4000008947ULL, 0x000fea0003800000ULL, 0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL,
0x0000000308057899ULL, 0x000fe2000800063fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000003ff077424ULL, 0x000fe400078e00ffULL, 0x0000002002067824ULL, 0x000fca00078e020dULL,
0x0000001f0600780cULL, 0x040fe40003f04070ULL, 0x000000030600780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000aff037e24ULL, 0x000fe2000f8e00ffULL,
0x0000005f0600720cULL, 0x040fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fe400078e00ffULL,
0x0000680003047a24ULL, 0x000fe200078e0206ULL, 0x00010a0006037811ULL, 0x000fc600078e10ffULL,
0x0000660004047625ULL, 0x000fcc00078e0005ULL, 0x0000000004037faeULL, 0x0003e4000c121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b5c07ffff798cULL, 0x0005e20008000005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b5800ffff7f8cULL, 0x000fe2000c800405ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000002700ULL,
0x00006400ff047624ULL, 0x000fe200078e00ffULL, 0x000000ff5d00720cULL, 0x000fe20003f05270ULL,
0x00000004ff087424ULL, 0x000fe200078e00ffULL, 0x00010ac006077811ULL, 0x004fe200078e10ffULL,
0x0000000403037824ULL, 0x002fc800078e0206ULL, 0x0000000203037824ULL, 0x000fc800078e00ffULL,
0x0000640003037624ULL, 0x000fc800078e0204ULL, 0x0000600003047625ULL, 0x000fca00078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e40008121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff047f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x004fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000005b7919ULL, 0x000e620000002600ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000805b5b7824ULL, 0x002fd200078e00ffULL,
0x000004f000000947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x000000055f037c17ULL, 0x000fe2000f800000ULL, 0x00000100ff107424ULL, 0x000fc600078e00ffULL,
0x8000000503037c10ULL, 0x000fe4000fffe0ffULL, 0x00000004ff087819ULL, 0x002fe20000011611ULL,
0x00000010110f7824ULL, 0x000fc600078e00ffULL, 0x00000005080a7c10ULL, 0x040fe4000fffe0ffULL,
0x000000f00f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000030800720cULL, 0x000fe20003f06070ULL,
0x010a00000a067984ULL, 0x000e620000004800ULL, 0x000000015b057824ULL, 0x000fe400078e020aULL,
0x000000010a077824ULL, 0x044fe400078e0211ULL, 0x000000100a0c7824ULL, 0x000fe200078e00ffULL,
0x010ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00c047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000c00004097811ULL, 0x000fe400078e20ffULL, 0x0000000208047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c50ULL,
0x00000005040c7c10ULL, 0x040fe4000fffe0ffULL, 0x000000030400720cULL, 0x000fe20003f06070ULL,
0x010a08000a0b7984ULL, 0x000ea40000004800ULL, 0x000000015b0e7824ULL, 0x000fe400078e020cULL,
0x000000010c0d7824ULL, 0x040fe400078e0211ULL, 0x000000100c0c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c0d7812ULL, 0x000fc800078ee20dULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x010ac0000b0b7984ULL, 0x004ea40000004800ULL, 0x000000040b057c24ULL, 0x004fc8000f8e020eULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000f04067210ULL, 0x002fe40007f3e0ffULL,
0x0000000408047810ULL, 0x040fe40007ffe0ffULL, 0x0000000608087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x00000005040c7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c50ULL,
0x000000015b0e7824ULL, 0x000fe200078e020cULL, 0x000000030400720cULL, 0x000fe20003f06070ULL,
0x000000010c0b7824ULL, 0x040fe200078e0211ULL, 0x010a10000a097984ULL, 0x000ea20000004800ULL,
0x000000100c0c7824ULL, 0x000fca00078e00ffULL, 0xfffffff00c0b7812ULL, 0x000fe400078ee20bULL,
0x00000005080c7c10ULL, 0x000fe4000fffe0ffULL, 0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL,
0x010ac00009097984ULL, 0x004ea40000004800ULL, 0x0000000409057c24ULL, 0x004fc8000f8e020eULL,
0x00005e0005047625ULL, 0x000fca00078e0010ULL, 0x0000000f04067210ULL, 0x002fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0605ULL, 0x000000015b057824ULL, 0x000fc600078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c50ULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x000000010c037824ULL, 0x040fe400078e0211ULL,
0x010a18000a0a7984ULL, 0x000ea20000004800ULL, 0x000000100c0c7824ULL, 0x000fca00078e00ffULL,
0xfffffff00c037812ULL, 0x000fc800078ee203ULL, 0x0000c00003037811ULL, 0x000fe200078e20ffULL,
0x010ac0000a047984ULL, 0x004ea40000004800ULL, 0x0000000404047c24ULL, 0x004fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e0010ULL, 0x0000000f04047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000c101c50ULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0x00000100ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000050d0a7c11ULL, 0x042fe2000f8fe0ffULL, 0x000000100d057824ULL, 0x000fc800078e00ffULL,
0x010a00000a037984ULL, 0x000e620000004800ULL, 0x000000015b047824ULL, 0x000fe200078e020aULL,
0x000000f005117812ULL, 0x000fe200078ec0ffULL, 0x000000010a077824ULL, 0x044fe400078e020dULL,
0x000000100a087824ULL, 0x000fe200078e00ffULL, 0x010ac00003037984ULL, 0x002e640000004800ULL,
0x0000000403047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff008047812ULL, 0x000fe400078ee207ULL,
0x000000020a087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000c00004037811ULL, 0x000fc600078e20ffULL, 0x000000015b047824ULL, 0x000fe400078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e2000b901c50ULL,
0x0000000108097824ULL, 0x040fe400078e020dULL, 0x00000010080c7824ULL, 0x000fe200078e00ffULL,
0x010a08000a0b7984ULL, 0x000ea20000004800ULL, 0x000000040a067810ULL, 0x002fca0007ffe0ffULL,
0x0000000106077824ULL, 0x000fe200078e020dULL, 0x010ac0000b0b7984ULL, 0x004e640000004800ULL,
0x000000040b047c24ULL, 0x002fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104087210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c047812ULL, 0x000fe200078ee209ULL,
0x00000010060c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000c00004037811ULL, 0x000fe200078e20ffULL, 0x000000015b047824ULL, 0x000fc800078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008037faeULL, 0x0003e8000b901c50ULL,
0x010a10000a0b7984ULL, 0x000ea20000004800ULL, 0x000000060a087810ULL, 0x002fc60007ffe0ffULL,
0x010ac0000b0b7984ULL, 0x004e640000004800ULL, 0x000000040b047c24ULL, 0x002fe4000f8e0204ULL,
0x00000001080b7824ULL, 0x000fe400078e020dULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104067210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00c047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000c00004037811ULL, 0x000fe200078e20ffULL,
0x000000015b047824ULL, 0x000fe400078e0208ULL, 0x0000001008087824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006037faeULL, 0x0003e6000b901c50ULL,
0xfffffff0080b7812ULL, 0x000fe200078ee20bULL, 0x010a18000a097984ULL, 0x000ea60000004800ULL,
0x0000c0000b0b7811ULL, 0x000fe200078e20ffULL, 0x010ac00009097984ULL, 0x004ea40000004800ULL,
0x0000000409047c24ULL, 0x004fc8000f8e0204ULL, 0x00005e0004047625ULL, 0x000fca00078e000fULL,
0x0000001104047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e6000b901c50ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff047f8cULL, 0x002e64000c80043fULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002002057824ULL, 0x002fca00078e0203ULL, 0x0000001f0500780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000aff067e24ULL, 0x000fe2000f8e00ffULL,
0x0000002005047810ULL, 0x040fe20007ffe0ffULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0x00010a0005097811ULL, 0x000fe200078e10ffULL, 0x0000680006067a24ULL, 0x000fe200078e0205ULL,
0x0000005f0400720cULL, 0x000fc80003f06070ULL, 0x0000002006047810ULL, 0x000fca0007ffe0ffULL,
0x0000660004047625ULL, 0x000fca00078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000ff6000720cULL, 0x000fe20003f05270ULL,
0x000000ffff677224ULL, 0x002fe200078e0005ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5c7224ULL, 0x000fe200078e00ffULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff5a7224ULL, 0x000fe200078e00ffULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000001fff107424ULL, 0x000fc400078e00ffULL, 0xffffffffff117424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x004fe400078e0007ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00015be000008947ULL, 0x000fea0003800000ULL, 0x00005800ff157624ULL, 0x000fe200078e00ffULL,
0x00015bc000007945ULL, 0x000fe20003800000ULL, 0xff317217ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff5c7224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x0000008015157824ULL, 0x000fc400078e00ffULL,
0x0000010013167824ULL, 0x000fca00078e00ffULL, 0x0000005f1600720cULL, 0x000fda0003f06070ULL,
0x00015af000000947ULL, 0x022fea0003800000ULL, 0x000000ffff667224ULL, 0x000fc600078e00ffULL,
0x000000135e00720cULL, 0x000fe20003fa4070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000002ff177819ULL, 0x000fe20000011666ULL, 0x000000ffff267224ULL, 0x020fe200078e00ffULL,
0x0000000366167812ULL, 0x040fe400078ec0ffULL, 0x00000017661c7207ULL, 0x000fe40002800000ULL,
0x000000ff16167207ULL, 0x000fe40006800000ULL, 0x000000031c1e7812ULL, 0x000fc400078ec0ffULL,
0x000000131c177211ULL, 0x002fc400078ff0ffULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b7c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x0000002420227210ULL, 0x000fca0007f1e1ffULL, 0x0000000125247824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011424ULL, 0x000000221d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0624ULL, 0x000000021d1d7819ULL, 0x000fc80000001222ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x010b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000002420227210ULL, 0x000fca0007f1e1ffULL,
0x0000000125247824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1d7819ULL, 0x000fc80000011424ULL,
0x000000221d1d7211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0624ULL,
0x000000021d1d7819ULL, 0x000fc80000001222ULL, 0x0000001d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000126267810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001171d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000417207824ULL, 0x000fe200078e021eULL,
0x0000098000017945ULL, 0x000fe40003800000ULL, 0x000000601d00720cULL, 0x000fe40003f06070ULL,
0x0000002020227811ULL, 0x000fc800078e30ffULL, 0x000000605b277812ULL, 0x000fce00078ef822ULL,
0x0000050000008947ULL, 0x000fea0003800000ULL, 0x00000004ff267819ULL, 0x000fe20000011603ULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x000000225f1d7217ULL, 0x000fe40007800000ULL,
0x0000000526287c10ULL, 0x040fe4000fffe0ffULL, 0x00000002262a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe400078e0a22ULL, 0x010a000028207984ULL, 0x000e620000004800ULL,
0x0000000128217824ULL, 0x000fe200078e0227ULL, 0x000000052a2c7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003227824ULL, 0x000fe200078e00ffULL, 0x000000051d1d7c17ULL, 0x000fe2000f800000ULL,
0x0000000128237824ULL, 0x000fc400078e0203ULL, 0x0000001028247824ULL, 0x000fe200078e00ffULL,
0x800000051d1d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012c2d7824ULL, 0x000fe200078e0203ULL,
0x000000f0222b7812ULL, 0x000fe400078ec0ffULL, 0x0000001d2600720cULL, 0x000fe40003f06070ULL,
0xfffffff024257812ULL, 0x000fc800078ee223ULL, 0x0000e00025257811ULL, 0x000fe200078e20ffULL,
0x010ac00020207984ULL, 0x002e640000004800ULL, 0x0000002015217224ULL, 0x002fc800078e0221ULL,
0x00005e0021207625ULL, 0x000fca00078e0029ULL, 0x0000002b20227210ULL, 0x000fe20007f3e0ffULL,
0x000000012c207824ULL, 0x040fe400078e0227ULL, 0x000000102c2c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fca00008e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e2000c101c50ULL, 0x0000001d2a00720cULL, 0x000fe40003f06070ULL,
0x00000004262a7810ULL, 0x040fe20007ffe0ffULL, 0x010a080028247984ULL, 0x000ea20000004800ULL,
0x0000000626267810ULL, 0x000fe40007ffe0ffULL, 0xfffffff02c257812ULL, 0x002fe400078ee22dULL,
0x000000052a2c7c10ULL, 0x000fe4000fffe0ffULL, 0x0000e00025257811ULL, 0x000fc600078e20ffULL,
0x000000012c2d7824ULL, 0x000fe200078e0203ULL, 0x010ac00024247984ULL, 0x004e640000004800ULL,
0x0000002415207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fe20007f3e0ffULL, 0x000000012c207824ULL, 0x040fe400078e0227ULL,
0x000000102c2c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fca00008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e2000c101c50ULL,
0x0000001d2a00720cULL, 0x000fe40003f06070ULL, 0x00000005262a7c10ULL, 0x000fe2000fffe0ffULL,
0x010a100028247984ULL, 0x000ea20000004800ULL, 0xfffffff02c257812ULL, 0x002fc800078ee22dULL,
0x0000e00025257811ULL, 0x000fe200078e20ffULL, 0x010ac00024247984ULL, 0x004e640000004800ULL,
0x0000002415207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fe20007f3e0ffULL, 0x000000012a207824ULL, 0x040fe400078e0227ULL,
0x000000012a277824ULL, 0x040fe400078e0203ULL, 0x000000ffff237224ULL, 0x000fe400008e0621ULL,
0x000000102a2a7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e2000c101c50ULL, 0x0000001d2600720cULL, 0x000fe40003f06070ULL,
0xfffffff02a1d7812ULL, 0x000fe200078ee227ULL, 0x010a180028247984ULL, 0x000ea60000004800ULL,
0x0000e0001d1d7811ULL, 0x000fe200078e20ffULL, 0x010ac00024247984ULL, 0x004ea40000004800ULL,
0x0000002415207224ULL, 0x004fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20207210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff217224ULL, 0x000fca00008e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000201d7faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x0000000503287c11ULL, 0x040fe2000f8fe0ffULL,
0x0000001003227824ULL, 0x000fe400078e00ffULL, 0x00000100ff297424ULL, 0x000fe400078e00ffULL,
0x010a0000281d7984ULL, 0x000e620000004800ULL, 0x0000000128217824ULL, 0x000fe200078e0227ULL,
0x000000f0222b7812ULL, 0x000fe200078ec0ffULL, 0x0000000128237824ULL, 0x040fe400078e0203ULL,
0x0000001028247824ULL, 0x000fe200078e00ffULL, 0x010ac0001d207984ULL, 0x002e640000004800ULL,
0x0000002015207224ULL, 0x002fc800078e0221ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20227210ULL, 0x000fe40007f1e0ffULL, 0xfffffff024207812ULL, 0x000fe400078ee223ULL,
0x0000000228247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200000e0621ULL,
0x0000e000201d7811ULL, 0x000fc600078e20ffULL, 0x0000000124207824ULL, 0x040fe400078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221d7faeULL, 0x0003e2000b901c50ULL,
0x0000000124257824ULL, 0x040fe400078e0203ULL, 0x00000010242a7824ULL, 0x000fe200078e00ffULL,
0x010a080028267984ULL, 0x000ea20000004800ULL, 0x0000000428227810ULL, 0x002fca0007ffe0ffULL,
0x0000000122237824ULL, 0x000fe200078e0203ULL, 0x010ac00026267984ULL, 0x004e640000004800ULL,
0x0000002615207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20247210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02a207812ULL, 0x000fe200078ee225ULL,
0x00000010222a7824ULL, 0x000fe400078e00ffULL, 0x000000ffff257224ULL, 0x000fe200000e0621ULL,
0x0000e000201d7811ULL, 0x000fe200078e20ffULL, 0x0000000122207824ULL, 0x000fc800078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000241d7faeULL, 0x0003e8000b901c50ULL,
0x010a100028267984ULL, 0x000ea80000004800ULL, 0x010ac00026267984ULL, 0x004ea40000004800ULL,
0x0000002615207224ULL, 0x004fe200078e0220ULL, 0x0000000628267810ULL, 0x000fc60007ffe0ffULL,
0x00005e0020207625ULL, 0x000fc800078e0029ULL, 0x0000000126257824ULL, 0x002fe200078e0203ULL,
0x0000002b20227210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02a207812ULL, 0x000fc600078ee223ULL,
0x000000ffff237224ULL, 0x000fe200000e0621ULL, 0x0000e000201d7811ULL, 0x000fe200078e20ffULL,
0x0000000126207824ULL, 0x040fe400078e0227ULL, 0x0000001026267824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff026257812ULL, 0x000fe200078ee225ULL, 0x010a180028247984ULL, 0x000ea60000004800ULL,
0x0000e000251d7811ULL, 0x002fe200078e20ffULL, 0x010ac00024247984ULL, 0x004e640000004800ULL,
0x0000002415207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fca00078e0029ULL,
0x0000002b20207210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000201d7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x002e64000c80043fULL, 0x000000ffff247224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b8c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1d7819ULL, 0x000fc80000011423ULL, 0x000000221d1d7211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x000000021d1d7819ULL, 0x000fc80000001222ULL,
0x0000001d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000175e00720cULL, 0x080fe20003f24070ULL,
0x0000022000017945ULL, 0x000fe20003800000ULL, 0x00000001161d7810ULL, 0x000fe40007ffe0ffULL,
0x000000175e00720cULL, 0x000fe40003f04070ULL, 0x000000031d207812ULL, 0x000fc400078ec0ffULL,
0x000000011c1c7812ULL, 0x000fe400078ec0ffULL, 0x000000031600780cULL, 0x000fe20004705270ULL,
0x0000002002167824ULL, 0x000fe200078e0203ULL, 0x000000ff20207207ULL, 0x000fe40004800000ULL,
0x00000002ff1d9819ULL, 0x000fe4000001161dULL, 0x000000011c00780cULL, 0x000fe40000705470ULL,
0x0000001f1600780cULL, 0x000fe20003f84070ULL, 0x000000011e1e7824ULL, 0x000fc800078e021dULL,
0x000000401e1d7824ULL, 0x040fe200078e00ffULL, 0x000000171e177211ULL, 0x000fc800078ff0ffULL,
0x000000c01d1c7812ULL, 0x000fca00078ec0ffULL, 0x00000100171e7824ULL, 0x000fe200078e021cULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000020021c7824ULL, 0x000fe200078e0203ULL,
0x0000000114147810ULL, 0x000fc80007ffe0ffULL, 0x000000031c00780cULL, 0x000fda0003f04070ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000001d7919ULL, 0x000e620000002700ULL,
0x0000640014177a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff247424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe40003f06070ULL, 0x00010ac01c217811ULL, 0x000fe200078e10ffULL,
0x000000041d1d7824ULL, 0x002fc800078e021cULL, 0x000000021d227824ULL, 0x000fc800078e00ffULL,
0x0000640022177a24ULL, 0x000fc800078e0217ULL, 0x00006000171c7625ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000e000017945ULL, 0x000fe20003800000ULL,
0x000000c000004947ULL, 0x000fea0003800000ULL, 0x0000000a20177c10ULL, 0x000fe2000fffe0ffULL,
0x00000001161c7824ULL, 0x042fe200078e021eULL, 0x00010a0016217811ULL, 0x000fc600078e10ffULL,
0x0000680017177a24ULL, 0x000fe200078e021eULL, 0x0000005f1c00720cULL, 0x000fe20003f06070ULL,
0x00000004ff1c7424ULL, 0x000fe400078e00ffULL, 0x0000000116177824ULL, 0x000fc800078e0217ULL,
0x00006600171c7625ULL, 0x000fcc00078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff1c7f8cULL, 0x002e62000c80043fULL, 0x000000ff6600720cULL, 0x000fe20003f05270ULL,
0x0000081000017945ULL, 0x000fe20003800000ULL, 0xffffffffff177424ULL, 0x000fe400078e00ffULL,
0x000000ffff677224ULL, 0x002fd200078e001dULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad800ff1c7f8cULL, 0x000e64000c800405ULL,
0x000000ffff257224ULL, 0x002fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x010adc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011421ULL,
0x0000002318187211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000218187819ULL, 0x000fc80000001221ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010adc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fc80000011603ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001181d7824ULL, 0x000fca00078e021dULL, 0x010000001d237984ULL, 0x000e680000000800ULL,
0x010200001d1c7984ULL, 0x0004e20000000800ULL, 0x000000122300720bULL, 0x002fe20003f1d000ULL,
0x0001ad627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff18297812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x000fd200078e0012ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05270ULL,
0x000000122300720bULL, 0x000fe20003f34000ULL, 0x0001ad227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000227806ULL, 0x000fc400008e0100ULL, 0x00000023121e7209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x0000991022207816ULL, 0x000fc600000000ffULL,
0x0104001e1d008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000001e12127221ULL, 0x002fe20000010000ULL,
0x000000ff22ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x00000012001d7308ULL, 0x000e640000000800ULL,
0x0000001d0e0e7220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x000fe20000011603ULL, 0x0001ac727f007947ULL, 0x000fea000b800000ULL,
0x00001f121d127589ULL, 0x0002a400000e0000ULL, 0x000000120f0f7220ULL, 0x084fe20000410000ULL,
0x000000120c0c7220ULL, 0x080fe20000410000ULL, 0x000000120b0b7220ULL, 0x080fe20000410000ULL,
0x0000001208087220ULL, 0x080fe20000410000ULL, 0x0000001207077220ULL, 0x080fe20000410000ULL,
0x0000001204047220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803127811ULL, 0x000fe200078ff0ffULL, 0x0001ab727f007947ULL, 0x000fea000b800000ULL,
0x00001f121d127589ULL, 0x00046400000e0000ULL, 0x000000120d0d7220ULL, 0x082fe20000410000ULL,
0x000000120a0a7220ULL, 0x080fe20000410000ULL, 0x0000001209097220ULL, 0x080fe20000410000ULL,
0x0000001206067220ULL, 0x080fe20000410000ULL, 0x0000001205057220ULL, 0x080fe20000410000ULL,
0x0000001248487220ULL, 0x080fe20000410000ULL, 0x0000001249497220ULL, 0x080fe20000410000ULL,
0x000000124c4c7220ULL, 0x080fe20000410000ULL, 0x000000124d4d7220ULL, 0x080fe20000410000ULL,
0x0000001250507220ULL, 0x080fe20000410000ULL, 0x0000001251517220ULL, 0x080fe20000410000ULL,
0x0000001254547220ULL, 0x080fe20000410000ULL, 0x0000001255557220ULL, 0x080fe20000410000ULL,
0x0000001258587220ULL, 0x080fe20000410000ULL, 0x0000001259597220ULL, 0x080fe20000410000ULL,
0x000000125c5c7220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff29ff7812ULL, 0x000fda0007806022ULL, 0x8000001e23230221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x0000002300190308ULL, 0x000e640000000800ULL, 0x000000191c1c0220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000e1c0e7221ULL, 0x008fe20000010000ULL,
0x000000ffff127224ULL, 0x000fc400078e001eULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000782c0ffULL, 0x0000014000017945ULL, 0x000fd80003800000ULL,
0x0000012000001947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fe400000000ffULL,
0x00000002ff1c7819ULL, 0x000fe40000011603ULL, 0x000054101a1d7816ULL, 0x004fe2000000001aULL,
0x0001a9a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1c1d1b7589ULL, 0x0002a400000e0000ULL,
0x000000081c1a7810ULL, 0x000fe20007ffe0ffULL, 0x0001a9d27f007947ULL, 0x000fea000b800000ULL,
0x00001f1a1d1a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000101c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x00003b0000207802ULL, 0x000fc40000000f00ULL, 0x0001b85000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000181c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x004fe200078e001dULL, 0x00003b5000207802ULL, 0x000fc40000000f00ULL,
0x0001b80000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000008036c7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1d7819ULL, 0x10efe20000011603ULL, 0x0000000208047891ULL, 0x000fe2000f8e103fULL,
0x000000076c6c7812ULL, 0x000fe200078ef803ULL, 0x0000118000017945ULL, 0x000fe20003800000ULL,
0x0000000703727812ULL, 0x000fe200078ec0ffULL, 0x00000004026b7824ULL, 0x000fe200078e021dULL,
0x000000106c2e7812ULL, 0x040fe200078efcffULL, 0x000000106c217824ULL, 0x040fe200078e00ffULL,
0x000000041d6d7c10ULL, 0x000fe2000fffe0ffULL, 0x000000016c1c7824ULL, 0x000fe200078e026bULL,
0x000000042e697c10ULL, 0x000fe2000fffe01dULL, 0x000000016b6a7824ULL, 0x000fe200078e022eULL,
0x0000000872727812ULL, 0x000fe200078ef803ULL, 0x000000102e257824ULL, 0x040fe200078e00ffULL,
0xfffffff0211c7812ULL, 0x000fe200078ee21cULL, 0x000000102e2e7824ULL, 0x000fe200078e00ffULL,
0x000000135e00720cULL, 0x000fe20003fc3070ULL, 0x000000011d6e7824ULL, 0x000fe200078e0272ULL,
0x0000c0001c1c7811ULL, 0x000fe200078e20ffULL, 0x0000000872637824ULL, 0x000fe200078e00ffULL,
0xfffffff0256a7812ULL, 0x000fc400078ee26aULL, 0xfffffff02e697812ULL, 0x000fe200078ee269ULL,
0x000000001c20783bULL, 0x000e620000004200ULL, 0x0000c0006a1e7811ULL, 0x000fe400078e20ffULL,
0x0000c00069617811ULL, 0x000fe400078e20ffULL, 0xfffffff863637812ULL, 0x000fe200078ee26eULL,
0x000000001e24783bULL, 0x000fe20000004200ULL, 0x000000026e647810ULL, 0x000fe40007ffe0ffULL,
0x0000a00063447811ULL, 0x000fe200078e20ffULL, 0x000000006134783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc80003f03070ULL, 0x000000004444783bULL, 0x000ea20000000200ULL,
0x00000018ff2b7819ULL, 0x002fe20000011420ULL, 0x0000010020297824ULL, 0x040fe200078e00ffULL,
0x0000888020287816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe20000011421ULL, 0x00000100212c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011429ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000888021297816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x00000020007c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff317819ULL, 0x000fe20000011423ULL, 0x0000001b44449232ULL, 0x084fe20000000000ULL,
0x00008880232e7816ULL, 0x000fe200000000ffULL, 0x0000001b46469232ULL, 0x000fe20000000000ULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0000001a45459232ULL, 0x080fe20000000000ULL,
0x00008880222d7816ULL, 0x040fe200000000ffULL, 0x0000002c00427306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011424ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888024867816ULL, 0x000fe200000000ffULL,
0x0000001a47479232ULL, 0x000fe20000000000ULL, 0x00000018ff827819ULL, 0x000fc40000011425ULL,
0x0000002100437306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x004fe20000011420ULL,
0x000000016c207824ULL, 0x040fe200078e026dULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000888025887816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe20000011426ULL,
0x0000002200337306ULL, 0x000fe20000200c00ULL, 0x000000106c217824ULL, 0x002fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc40000011427ULL, 0x00008880267f7816ULL, 0x000fe400000000ffULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000010023217824ULL, 0x040fe200078e00ffULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000c00020627811ULL, 0x000fe200078e20ffULL, 0x0000010024207824ULL, 0x040fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x000000006238783bULL, 0x000e620000004200ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x00000021002f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00008880277e7816ULL, 0x000fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe40000011434ULL, 0x0000888034767816ULL, 0x000fe200000000ffULL,
0x0000002000877306ULL, 0x0007e20000200c00ULL, 0x0000010025217824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011435ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000888035757816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x0000002300327306ULL, 0x0005e20000200c00ULL, 0x0000010026207824ULL, 0x048fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888036657816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002100897306ULL, 0x0007e20000200c00ULL, 0x0000000872237824ULL, 0x004fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff707819ULL, 0x000fe40000011436ULL,
0xfffffff823647812ULL, 0x000fe400078ee264ULL, 0x0000002000807306ULL, 0x0005e20000200c00ULL,
0x0000010027217824ULL, 0x048fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011437ULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000010034207824ULL, 0x044fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x002fe40000011438ULL, 0x00000018ff777819ULL, 0x000fe40000011420ULL,
0x0000a00064207811ULL, 0x000fe200078e20ffULL, 0x0000002100817306ULL, 0x0003e20000200c00ULL,
0x0000888038417816ULL, 0x000fc400000000ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff3d7819ULL, 0x000fe40000011439ULL, 0x00000018ff7a7819ULL, 0x000fe2000001143aULL,
0x0000002900297306ULL, 0x000ea20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x00000018ff797819ULL, 0x000fcc000001143bULL, 0x0000002400847306ULL, 0x0007f00000200c00ULL,
0x0000002500857306ULL, 0x0005e20000200c00ULL, 0x0000010035247824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000026007d7306ULL, 0x000fe20000200c00ULL, 0x0000541029257816ULL, 0x004fe20000000042ULL,
0x0001000038297824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000888039427816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002400787306ULL, 0x0005f00000200c00ULL, 0x00000027007b7306ULL, 0x0007e20000200c00ULL,
0x0000541028247816ULL, 0x004fe2000000003fULL, 0x0000010038287824ULL, 0x000fe200078e00ffULL,
0x0000001b20209232ULL, 0x002fc40000000000ULL, 0x0000001b22229232ULL, 0x000fe40000000000ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x000000244424723cULL, 0x008f6200000018ffULL, 0x0000001a21219232ULL, 0x080fe40000000000ULL,
0x0000001a23239232ULL, 0x000fc80000000000ULL, 0x0000008800887306ULL, 0x000ff00000200c00ULL,
0x0000002a002a7306ULL, 0x000ff00000200c00ULL, 0x0000002d002d7306ULL, 0x000ff00000200c00ULL,
0x0000002c002c7306ULL, 0x000eb00000200c00ULL, 0x0000002800387306ULL, 0x0003f00000200c00ULL,
0x00000029003f7306ULL, 0x0007e20000200c00ULL, 0x0000541086287816ULL, 0x002fc40000000087ULL,
0x000054102d2c7816ULL, 0x004fca000000002cULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x0000541088297816ULL, 0x008fce0000000089ULL, 0x000000282024723cULL, 0x020be20000001824ULL,
0x0000003400747306ULL, 0x0005ec0000200c00ULL, 0x000054107c287816ULL, 0x020fe4000000002bULL,
0x0000541043297816ULL, 0x000fe2000000002aULL, 0x0000010039347824ULL, 0x004fe200078e00ffULL,
0x0000003000307306ULL, 0x000ea20000200c00ULL, 0x000054102e2d7816ULL, 0x002fc4000000002fULL,
0x000088803a437816ULL, 0x000fe400000000ffULL, 0x000000284428723cULL, 0x040f6200000018ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003100317306ULL, 0x000e6a0000200c00ULL,
0x0000002c442c723cULL, 0x000f6600000018ffULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x0000541032317816ULL, 0x002fce0000000031ULL, 0x0000003500737306ULL, 0x0003e20000200c00ULL,
0x000000304430723cULL, 0x000f6e00000018ffULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x0001000039357824ULL, 0x002fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003400397306ULL, 0x0003f00000200c00ULL, 0x0000007e007e7306ULL, 0x000f220000200c00ULL,
0x000001003a347824ULL, 0x002fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000035007c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fce000001143aULL, 0x0000003400867306ULL, 0x0003e20000200c00ULL,
0x0000541085357816ULL, 0x004fe40000000082ULL, 0x000088803b827816ULL, 0x000fca00000000ffULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x0000541084347816ULL, 0x002fce0000000083ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000342028723cULL, 0x020bee0000001828ULL,
0x000054107f347816ULL, 0x028fe20000000080ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000054107e357816ULL, 0x010fe20000000081ULL, 0x000001003b7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x00000034202c723cULL, 0x000be2000000182cULL,
0x0000004200427306ULL, 0x000eec0000200c00ULL, 0x000000ffff357224ULL, 0x020fe200078e0082ULL,
0x000054107d347816ULL, 0x004fe20000000040ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x0000541041387816ULL, 0x002fe20000000038ULL, 0x00000100377d7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x00000035007f7306ULL, 0x0003e20000200c00ULL,
0x0000541042397816ULL, 0x008fce0000000039ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x000054107b357816ULL, 0x002fe4000000003eULL, 0x000054103f3c7816ULL, 0x004fe4000000003cULL,
0x00008880377b7816ULL, 0x000fc600000000ffULL, 0x000000342030723cULL, 0x000be20000001830ULL,
0x0000004300437306ULL, 0x000e6c0000200c00ULL, 0x000100003b347824ULL, 0x020fe200078e00ffULL,
0x000054107c3d7816ULL, 0x008fe2000000003dULL, 0x0000007e007e7306ULL, 0x000ea20000200c00ULL,
0x0000010036357824ULL, 0x000fc400078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0001000036367824ULL, 0x000fe400078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003c443c723cULL, 0x000fe200000018ffULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x0000541043407816ULL, 0x002fe40000000086ULL, 0x00000018ff367819ULL, 0x000fca0000011436ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000054107f417816ULL, 0x004fce000000007eULL,
0x0000003a00837306ULL, 0x0002a20000200c00ULL, 0x000000404440723cULL, 0x040fee00000018ffULL,
0x0000003400807306ULL, 0x0004e20000200c00ULL, 0x000000384438723cULL, 0x002f6e00000018ffULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x0000541083347816ULL, 0x004fce000000007aULL,
0x0000007600767306ULL, 0x000ff00000200c00ULL, 0x0000007700777306ULL, 0x000eb00000200c00ULL,
0x00000035007c7306ULL, 0x0007f00000200c00ULL, 0x0000007100717306ULL, 0x000f220000200c00ULL,
0x0000541080357816ULL, 0x008fce0000000079ULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x000000344444723cULL, 0x000b6e00000018ffULL, 0x0000541075357816ULL, 0x022fe20000000078ULL,
0x0001000037757824ULL, 0x000fe200078e00ffULL, 0x0000541076347816ULL, 0x004fe20000000077ULL,
0x0000006500657306ULL, 0x000e660000200c00ULL, 0x00000018ff757819ULL, 0x000fc60000011475ULL,
0x000000342038723cULL, 0x000b640000001838ULL, 0x0000007b007b7306ULL, 0x000fea0000200c00ULL,
0x0000541074347816ULL, 0x030fe40000000071ULL, 0x0000541073357816ULL, 0x008fe20000000068ULL,
0x0000007d007a7306ULL, 0x000ea20000200c00ULL, 0x00000002ff687819ULL, 0x000fc80000011603ULL,
0x000000666800720cULL, 0x040fe20003f46070ULL, 0x00000034203c723cULL, 0x000b64000000183cULL,
0x0000007000707306ULL, 0x000fea0000200c00ULL, 0x0000541065347816ULL, 0x022fe4000000007cULL,
0x0000000868657810ULL, 0x000fe20007ffe0ffULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000054107b357816ULL, 0x004fc4000000007aULL, 0x000000666500720cULL, 0x000fca0003f66070ULL,
0x0000003600377306ULL, 0x0002a20000200c00ULL, 0x000000342040723cULL, 0x000b6e0000001840ULL,
0x0000007500747306ULL, 0x000ee20000200c00ULL, 0x0000000166367810ULL, 0x002fc80007ffe0ffULL,
0x000000366800720cULL, 0x080fe40005746470ULL, 0x000000366500720cULL, 0x000fe40005f66470ULL,
0x0000541037347816ULL, 0x024fe40000000070ULL, 0x0000541074357816ULL, 0x008fce000000006fULL,
0x000000342044723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240f0f7221ULL, 0x000fe20000010000ULL,
0x000000250c0c7221ULL, 0x000fe20000010000ULL, 0x000000280b0b7221ULL, 0x000fe20000010000ULL,
0x0000002908087221ULL, 0x000fe20000010000ULL, 0x0000002c07077221ULL, 0x000fe20000010000ULL,
0x0000002d04047221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000314a4a7221ULL, 0x000fe20000010000ULL, 0x000000384b4b7221ULL, 0x000fe20000010000ULL,
0x000000394e4e7221ULL, 0x000fe20000010000ULL, 0x0000003c4f4f7221ULL, 0x000fe20000010000ULL,
0x0000003d52527221ULL, 0x000fe20000010000ULL, 0x0000004053537221ULL, 0x000fe20000010000ULL,
0x0000004156567221ULL, 0x000fe20000010000ULL, 0x0000004457577221ULL, 0x020fe20000010000ULL,
0x000000455a5a7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x000000260d0d7221ULL, 0x000fe20000010000ULL, 0x000000270a0a7221ULL, 0x000fe20000010000ULL,
0x0000002a09097221ULL, 0x000fe20000010000ULL, 0x0000002b06067221ULL, 0x000fe20000010000ULL,
0x0000002e05057221ULL, 0x000fe20000010000ULL, 0x0000002f48487221ULL, 0x000fe20000010000ULL,
0x0000003249497221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x0000003a4d4d7221ULL, 0x000fe20000010000ULL, 0x0000003b50507221ULL, 0x000fe20000010000ULL,
0x0000003e51517221ULL, 0x000fe20000010000ULL, 0x0000003f54547221ULL, 0x000fe20000010000ULL,
0x0000004255557221ULL, 0x000fe20000010000ULL, 0x0000004358587221ULL, 0x000fe20000010000ULL,
0x0000004659597221ULL, 0x020fe20000010000ULL, 0x000000475c5c7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011636ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000000135e00720cULL, 0x000fc40003f03070ULL,
0x0000002336227207ULL, 0x000fe40002800000ULL, 0x000000135e00720cULL, 0x000fe40003fc3070ULL,
0x00000001ff2c7803ULL, 0x000fe40000000000ULL, 0x0000000336207812ULL, 0x002fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0000000322217812ULL, 0x000fe400078ec0ffULL,
0x000000ff20207207ULL, 0x000fc40006800000ULL, 0x0000001322227211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe20007804867ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe20007804828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000122257810ULL, 0x040fe20007ffe0ffULL,
0x0000000422237824ULL, 0x000fe200078e0221ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000602500720cULL, 0x000fe20003f06070ULL, 0x0000004023287824ULL, 0x000fca00078e00ffULL,
0x000000405b237812ULL, 0x000fce00078ef828ULL, 0x000004f000008947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002a277984ULL, 0x000e620000004800ULL, 0x000000012a257824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe400078ec0ffULL, 0x000000285f267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a28ULL,
0x000000102a287824ULL, 0x000fe400078e00ffULL, 0x000000012e307824ULL, 0x100fe200078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027247984ULL, 0x0022a40000004800ULL,
0x000000012a277824ULL, 0x002fca00078e0203ULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x8000000526287c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000012e277824ULL, 0x000fe400078e0223ULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x000000281d00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000c101c50ULL,
0x010a08002a297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0x000000041d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e257824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002a297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x000000283100720cULL, 0x000fe40003f06070ULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000c101c50ULL, 0x010a18002a297984ULL, 0x000ea80000004800ULL,
0x010ac00029267984ULL, 0x004ea40000004800ULL, 0x0000002615267224ULL, 0x004fc400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d26267210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x0000c00023237811ULL, 0x000fd600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2e7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe400078e00ffULL,
0x010a00002e287984ULL, 0x000e620000004800ULL, 0x000000012e247824ULL, 0x000fe400078e0223ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x010ac00028287984ULL, 0x002e640000004800ULL,
0x0000002815247224ULL, 0x002fe200078e0224ULL, 0x000000022e287810ULL, 0x000fc60007ffe0ffULL,
0x00005e0024247625ULL, 0x000fc800078e002dULL, 0x00000001282a7824ULL, 0x100fe200078e0203ULL,
0x0000002f24267210ULL, 0x000fe20007f1e0ffULL, 0x000000012e247824ULL, 0x000fe400078e0203ULL,
0x0000001028317824ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fe400000e0625ULL,
0x000000102e257824ULL, 0x000fe200078e00ffULL, 0xfffffff0312a7812ULL, 0x000fc800078ee22aULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x0000000123257824ULL, 0x000fe200078e0228ULL,
0x000000042e287810ULL, 0x000fe40007ffe0ffULL, 0x0000c000242b7811ULL, 0x000fc600078e20ffULL,
0x0000001028317824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c50ULL, 0x010a08002e297984ULL, 0x000ea20000004800ULL,
0x0000c0002a2b7811ULL, 0x002fe200078e20ffULL, 0x0000000123277824ULL, 0x000fe400078e0228ULL,
0x00000001282a7824ULL, 0x000fe200078e0203ULL, 0x000000062e287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff0312a7812ULL, 0x000fe200078ee22aULL, 0x0000000123237824ULL, 0x000fe200078e0228ULL,
0x010ac00029247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242b7faeULL, 0x0003e8000b901c50ULL, 0x010a10002e297984ULL, 0x000ea20000004800ULL,
0x0000c0002a2b7811ULL, 0x002fc600078e20ffULL, 0x010ac00029267984ULL, 0x004e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e8000b901c50ULL,
0x010a18002e297984ULL, 0x000ea80000004800ULL, 0x010ac00029247984ULL, 0x004ea40000004800ULL,
0x0000002415247224ULL, 0x004fc400078e0223ULL, 0x0000000128237824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc800078e002dULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007f1e0ffULL, 0xfffffff028237812ULL, 0x000fe200078ee223ULL,
0x000000ffff257224ULL, 0x000fc600000e0625ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe20007804828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000225e00720cULL, 0x000fc80003f04070ULL,
0x000000ff20247207ULL, 0x040fe40000000000ULL, 0x000000ff20237207ULL, 0x000fc60004000000ULL,
0x0000000121217824ULL, 0x000fe400078e0224ULL, 0x00000004ff247424ULL, 0x000fe400078e00ffULL,
0x0000004021207824ULL, 0x040fe200078e00ffULL, 0x0000002221217211ULL, 0x000fc800078ff0ffULL,
0x000000c020207812ULL, 0x000fca00078ec0ffULL, 0x0000010021207824ULL, 0x000fe200078e0220ULL,
0x0000000a23217c10ULL, 0x000fe4000fffe0ffULL, 0x00010a0016237811ULL, 0x000fe400078e10ffULL,
0x0000002020207810ULL, 0x000fca0007ffe0ffULL, 0x0000000116227824ULL, 0x100fe400078e0220ULL,
0x0000680021217a24ULL, 0x000fc600078e0220ULL, 0x0000005f2200720cULL, 0x000fe20003f06070ULL,
0x0000000116217824ULL, 0x000fc800078e0221ULL, 0x0000660021207625ULL, 0x000fd000078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x002fe200078e0021ULL,
0x0000010000001947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000182527f007947ULL, 0x000fea000b800000ULL,
0x00001f68221b7589ULL, 0x0002a400000e0000ULL, 0x000182927f007947ULL, 0x000fea000b800000ULL,
0x00001f65221a7589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001068277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000630000207802ULL, 0x000fc40000000f00ULL, 0x0001905000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001868277810ULL, 0x002fe40007ffe0ffULL, 0x0000635000207802ULL, 0x000fc40000000f00ULL,
0x0001900000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000e0006a6a7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000016c6b7824ULL, 0x040fe200078e026bULL, 0x0000e00069697811ULL, 0x000fe200078e20ffULL,
0x000000106c267824ULL, 0x044fe200078e00ffULL, 0x000000006a28783bULL, 0x000ea20000004200ULL,
0x000000016c6d7824ULL, 0x000fe200078e026dULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x000000106c6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff0266b7812ULL, 0x000fe200078ee26bULL,
0x000000006920783bULL, 0x00afe20000004200ULL, 0x0000000872327824ULL, 0x040fe200078e00ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x0000e0006b6b7811ULL, 0x000fe200078e20ffULL,
0x0000000872897824ULL, 0x000fe200078e00ffULL, 0xfffffff06c6c7812ULL, 0x000fc400078ee26dULL,
0x000000046e6d7810ULL, 0x000fe40007ffe0ffULL, 0x0000e0006c6c7811ULL, 0x000fe400078e20ffULL,
0xfffffff8326d7812ULL, 0x000fe400078ee26dULL, 0x000000066e6e7810ULL, 0x000fe20007ffe0ffULL,
0x000000006c34783bULL, 0x000e620000004200ULL, 0x0000a0006d407811ULL, 0x000fe400078e20ffULL,
0xfffffff8896e7812ULL, 0x000fc800078ee26eULL, 0x000000004040783bULL, 0x000ee20000000200ULL,
0x0000010028247824ULL, 0x044fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011428ULL,
0x0000010029257824ULL, 0x000fe200078e00ffULL, 0x0000888028877816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00000018ff767819ULL, 0x000fc4000001142aULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x000088802a7e7816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fe2000001142bULL,
0x0000002400867306ULL, 0x0005e20000200c00ULL, 0x000088802b7c7816ULL, 0x000fe400000000ffULL,
0x00000018ff807819ULL, 0x000fe20000011429ULL, 0x00000100343a7824ULL, 0x002fe200078e00ffULL,
0x0000888029847816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011434ULL, 0x0000002500857306ULL, 0x0003e20000200c00ULL,
0x000001002a247824ULL, 0x004fe200078e00ffULL, 0x00008880343e7816ULL, 0x000fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x000001002b247824ULL, 0x040fe200078e00ffULL, 0x0000002800827306ULL, 0x0005e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000001b40409232ULL, 0x088fe20000000000ULL,
0x00000018ff7f7819ULL, 0x000fe20000011424ULL, 0x0000001b42429232ULL, 0x000fe20000000000ULL,
0x000000006b24783bULL, 0x002e620000004200ULL, 0x0000002a007b7306ULL, 0x0007e20000200c00ULL,
0x0000010020287824ULL, 0x004fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000001a41419232ULL, 0x080fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011420ULL,
0x0000001a43439232ULL, 0x000fe20000000000ULL, 0x00000018ff797819ULL, 0x000fc40000011428ULL,
0x0000002b007a7306ULL, 0x000fe20000200c00ULL, 0x0000888020787816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00008880358a7816ULL, 0x000fe200000000ffULL,
0x0000002900837306ULL, 0x0005e20000200c00ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff887819ULL, 0x000fc40000011437ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x0000888037727816ULL, 0x000fe200000000ffULL, 0x0000003a003f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe40000011421ULL, 0x0000888021777816ULL, 0x000fe400000000ffULL,
0x00000018ff707819ULL, 0x000fe40000011422ULL, 0x00000018ff6f7819ULL, 0x000fe20000011423ULL,
0x00000034003b7306ULL, 0x0009e20000200c00ULL, 0x00000018ff287819ULL, 0x002fe20000011424ULL,
0x00000100242a7824ULL, 0x048fe200078e00ffULL, 0x0000888024447816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x004fe20000011425ULL,
0x00000100262d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142aULL,
0x00000100252a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x040fe200078e00ffULL, 0x0000888025457816ULL, 0x000fe200000000ffULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x00000100272f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000010037347824ULL, 0x050fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00008880262c7816ULL, 0x040fe200000000ffULL,
0x0000002e00257306ULL, 0x0002a20000200c00ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x00008880272e7816ULL, 0x042fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe40000011434ULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000002400247306ULL, 0x000e620000200c00ULL,
0x0000541025287816ULL, 0x004fc40000000028ULL, 0x0000a0006e257811ULL, 0x000fe400078e20ffULL,
0x00000018ff8c7819ULL, 0x000fc60000011437ULL, 0x0000004400447306ULL, 0x000ff00000200c00ULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x0000541024297816ULL, 0x002fce0000000029ULL,
0x0000002600337306ULL, 0x0003f00000200c00ULL, 0x0000002700327306ULL, 0x0007e20000200c00ULL,
0x0000010035267824ULL, 0x002fe200078e00ffULL, 0x0000541044447816ULL, 0x004fe2000000002bULL,
0x00000100362b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0001000035277824ULL, 0x008fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc8000001142bULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002600357306ULL, 0x000ff00000200c00ULL, 0x00000027003a7306ULL, 0x0003f00000200c00ULL,
0x0000002a002a7306ULL, 0x000ea20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x0000003e003e7306ULL, 0x000ef00000200c00ULL, 0x0000002000747306ULL, 0x0009e20000200c00ULL,
0x0000541045457816ULL, 0x004fc4000000002aULL, 0x000000284028723cULL, 0x040fea00000018ffULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x010fe20000011436ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000054103e347816ULL, 0x008fe2000000003fULL,
0x00000100213e7824ULL, 0x040fe200078e00ffULL, 0x000000444044723cULL, 0x000f6200000018ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003d003d7306ULL, 0x000ea60000200c00ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x0000001b24249232ULL, 0x082fe40000000000ULL,
0x0000001b26269232ULL, 0x000fe40000000000ULL, 0x0000001a25259232ULL, 0x080fe40000000000ULL,
0x0000001a27279232ULL, 0x000fe20000000000ULL, 0x0000002d002d7306ULL, 0x000e620000200c00ULL,
0x000054103c3c7816ULL, 0x004fce000000003dULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000008b008b7306ULL, 0x000ea20000200c00ULL, 0x000054102c2c7816ULL, 0x002fce000000002dULL,
0x0000003000307306ULL, 0x000e700000200c00ULL, 0x0000003100317306ULL, 0x000ee20000200c00ULL,
0x00005410723d7816ULL, 0x004fe4000000008bULL, 0x00008880228b7816ULL, 0x000fca00000000ffULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x0000541033307816ULL, 0x002fce0000000030ULL,
0x0000003900397306ULL, 0x000e620000200c00ULL, 0x0000541032317816ULL, 0x008fce0000000031ULL,
0x0000002e002e7306ULL, 0x000fe20000200c00ULL, 0x000054103b387816ULL, 0x004fe20000000038ULL,
0x000000304030723cULL, 0x000fec00000018ffULL, 0x0000002f002f7306ULL, 0x000ea20000200c00ULL,
0x000054103a397816ULL, 0x002fce0000000039ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000000384038723cULL, 0x000fee00000018ffULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000054102e2d7816ULL, 0x004fce000000002fULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x000054108a357816ULL, 0x002fe20000000035ULL, 0x0000002c402c723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fca000001143eULL, 0x0000003600897306ULL, 0x0002a40000200c00ULL,
0x0000003c403c723cULL, 0x040fec00000018ffULL, 0x0000008c008d7306ULL, 0x000ee40000200c00ULL,
0x000000344034723cULL, 0x002f6c00000018ffULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x0000541089207816ULL, 0x004fe20000000020ULL, 0x0000010022897824ULL, 0x000fc400078e00ffULL,
0x0001000022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff897819ULL, 0x000fe20000011489ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x00000018ff227819ULL, 0x000fce0000011422ULL,
0x0000002100727306ULL, 0x0007f00000200c00ULL, 0x0000008000807306ULL, 0x000f220000200c00ULL,
0x000054108d217816ULL, 0x008fce0000000088ULL, 0x000000204040723cULL, 0x000b6200000018ffULL,
0x0000007e007e7306ULL, 0x000fec0000200c00ULL, 0x0000541087207816ULL, 0x022fe40000000086ULL,
0x0000541084217816ULL, 0x004fe20000000085ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000888023847816ULL, 0x000fca00000000ffULL, 0x000000202444723cULL, 0x000b640000001844ULL,
0x0000007c007c7306ULL, 0x000fea0000200c00ULL, 0x0000541082207816ULL, 0x020fe40000000081ULL,
0x0000541083217816ULL, 0x010fe20000000080ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x0000010023807824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00000018ff237819ULL, 0x000fc80000011423ULL,
0x000000ffff207224ULL, 0x020fc600078e0084ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x000054107c217816ULL, 0x002fce000000007fULL, 0x0000002000817306ULL, 0x0003f00000200c00ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x000054107e207816ULL, 0x002fce000000007dULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x000054107b207816ULL, 0x024fe40000000076ULL,
0x000054107a217816ULL, 0x008fca0000000075ULL, 0x0000008a008a7306ULL, 0x000ea40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x0000541078207816ULL, 0x022fce0000000079ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x0000541077217816ULL, 0x004fce000000008aULL, 0x0000008b00887306ULL, 0x000fe20000200c00ULL,
0x000000202434723cULL, 0x000b6e0000001834ULL, 0x0000008900897306ULL, 0x000ea20000200c00ULL,
0x0000541074207816ULL, 0x028fe40000000073ULL, 0x0000541072217816ULL, 0x002fca0000000071ULL,
0x0000008000807306ULL, 0x000e640000200c00ULL, 0x000000202438723cULL, 0x000b6c0000001838ULL,
0x0000002200857306ULL, 0x000fe20000200c00ULL, 0x0000541088207816ULL, 0x024fce0000000089ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x0000541081217816ULL, 0x002fce0000000080ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000020243c723cULL, 0x000b6e000000183cULL,
0x0000002300227306ULL, 0x000e620000200c00ULL, 0x0000541085207816ULL, 0x024fe40000000070ULL,
0x0000541022217816ULL, 0x002fce000000006fULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x000000440f0f7221ULL, 0x000fe20000010000ULL, 0x000000450c0c7221ULL, 0x000fe20000010000ULL,
0x000000280b0b7221ULL, 0x000fe20000010000ULL, 0x0000002908087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x000000460d0d7221ULL, 0x000fe20000010000ULL,
0x000000470a0a7221ULL, 0x000fe20000010000ULL, 0x0000002a09097221ULL, 0x000fe20000010000ULL,
0x0000002b06067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000166667810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff6f7424ULL, 0x000fe200078e00ffULL, 0x010b8800ff227f8cULL, 0x000e68000c80043fULL,
0x000000016f6f7807ULL, 0x000fc80006800000ULL, 0x0000006f6600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffa72000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004013207811ULL, 0x020fe200078e40ffULL,
0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005f2000720cULL, 0x000fda0003f06070ULL,
0x0001017000000947ULL, 0x000fea0003800000ULL, 0x000000ffff707224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe20000011670ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000370227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000002170217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000121247810ULL, 0x000fc80007ffe0ffULL, 0x0000000324207812ULL, 0x040fe400078ec0ffULL,
0x0000001324217211ULL, 0x000fc400078ff0ffULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x010b8c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000121237810ULL, 0x040fe20007ffe0ffULL, 0x0000000421257824ULL, 0x000fe200078e0220ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000602300720cULL, 0x000fe40003f06070ULL,
0x0000002025287811ULL, 0x000fc800078e30ffULL, 0x000000605b237812ULL, 0x000fce00078ef828ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000285f257217ULL, 0x000fe40007800000ULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x010a00002c267984ULL, 0x000e620000004800ULL,
0x000000012c277824ULL, 0x000fe400078e0223ULL, 0x0000000125257824ULL, 0x000fe200078e0a28ULL,
0x00000005312e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fc600078e00ffULL,
0x0000000525257c17ULL, 0x000fe2000f800000ULL, 0x000000012e297824ULL, 0x000fe200078e0223ULL,
0x000000f0282d7812ULL, 0x000fe200078ec0ffULL, 0x000000102c287824ULL, 0x040fe200078e00ffULL,
0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012c257824ULL, 0x100fe400078e0203ULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x0000002a1d00720cULL, 0x000fe40003f06070ULL,
0xfffffff028257812ULL, 0x000fc800078ee225ULL, 0x0000e000252f7811ULL, 0x000fe200078e20ffULL,
0x010ac00026267984ULL, 0x002e640000004800ULL, 0x0000002615277224ULL, 0x002fc800078e0227ULL,
0x00005e0027267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff277224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a08002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000041d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe400008e0629ULL,
0x000000012e297824ULL, 0x000fc600078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a10002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000061d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c50ULL,
0x0000002a3100720cULL, 0x000fc60003f06070ULL, 0x010a18002c257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fe400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d28267210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fc600008e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026237faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fe400078e00ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000022a2c7810ULL, 0x040fe20007ffe0ffULL,
0x010a00002a257984ULL, 0x000e620000004800ULL, 0x000000012a277824ULL, 0x000fe200078e0223ULL,
0x000000f0282f7812ULL, 0x000fe200078ec0ffULL, 0x000000012a287824ULL, 0x040fe400078e0203ULL,
0x000000102a297824ULL, 0x000fc400078e00ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0203ULL,
0x000000102c317824ULL, 0x040fe200078e00ffULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x000000012c297824ULL, 0x000fe200078e0223ULL, 0x000000042a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000e000282b7811ULL, 0x000fe400078e20ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000102c317824ULL, 0x000fe200078e00ffULL, 0x010ac00025267984ULL, 0x002e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e8000b901c50ULL,
0x010a08002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2b7811ULL, 0x002fe200078e20ffULL,
0x000000012c277824ULL, 0x040fe400078e0223ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000012c237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002dULL,
0x0000002f28287210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e8000b901c50ULL,
0x010a10002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2b7811ULL, 0x002fc600078e20ffULL,
0x010ac00025267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c50ULL, 0x010a18002a257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fc400078e0223ULL,
0x000000012c237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002dULL,
0x000000102c2c7824ULL, 0x000fe200078e00ffULL, 0x0000002f28287210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02c237812ULL, 0x000fe200078ee223ULL, 0x000000ffff297224ULL, 0x000fc600000e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028237faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff267f8cULL, 0x002e64000c80043fULL,
0x000000ffff2a7224ULL, 0x002fc400078e0027ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011429ULL,
0x0000002823237211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000223237819ULL, 0x000fc80000001228ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000124247812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012400780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010af800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010afc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010afc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0100800027237984ULL, 0x000e680000000800ULL, 0x0102800027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x000157127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x000156d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0104802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200297308ULL, 0x000e640000000800ULL, 0x000000290e0e7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000156227f007947ULL, 0x000fea000b800000ULL,
0x00001f6829127589ULL, 0x0002a400000e0000ULL, 0x000000120f0f7220ULL, 0x084fe20000410000ULL,
0x000000120c0c7220ULL, 0x080fe20000410000ULL, 0x000000120b0b7220ULL, 0x080fe20000410000ULL,
0x0000001208087220ULL, 0x080fe20000410000ULL, 0x0000001207077220ULL, 0x080fe20000410000ULL,
0x0000001204047220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000155327f007947ULL, 0x000fea000b800000ULL, 0x00001f6529127589ULL, 0x00046400000e0000ULL,
0x000000120d0d7220ULL, 0x082fe20000410000ULL, 0x000000120a0a7220ULL, 0x080fe20000410000ULL,
0x0000001209097220ULL, 0x080fe20000410000ULL, 0x0000001206067220ULL, 0x080fe20000410000ULL,
0x0000001205057220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x0000001249497220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124d4d7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001251517220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001255557220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x0000001259597220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000e220e7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000153727f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x000153b27f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000093f000207802ULL, 0x000fc40000000f00ULL,
0x00015f6000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0000944000207802ULL, 0x000fc40000000f00ULL, 0x00015f1000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x0000a80063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000a80064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200f0f7221ULL, 0x000fe20000010000ULL, 0x000000210c0c7221ULL, 0x000fe20000010000ULL,
0x000000440b0b7221ULL, 0x000fe20000010000ULL, 0x0000004508087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220d0d7221ULL, 0x000fe20000010000ULL,
0x000000230a0a7221ULL, 0x000fe20000010000ULL, 0x0000004609097221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff297224ULL, 0x020fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366227812ULL, 0x000fe400078ec0ffULL, 0x0000000123247810ULL, 0x000fe40007ffe0ffULL,
0x000000135e00720cULL, 0x000fe40003f03070ULL, 0x00000040ff2a7803ULL, 0x000fe40000000000ULL,
0x000000ff22227207ULL, 0x000fe20006800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0021ULL,
0x0000000324207812ULL, 0x000fc400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121257810ULL, 0x040fe20007ffe0ffULL,
0x0000000421237824ULL, 0x000fe200078e0220ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000602500720cULL, 0x000fe20003fc6070ULL, 0x0000004023287824ULL, 0x000fca00078e00ffULL,
0x000000405b237812ULL, 0x000fce00078ef828ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002c277984ULL, 0x000e620000004800ULL, 0x000000012c257824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe400078ec0ffULL, 0x000000285f267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a28ULL,
0x000000102c287824ULL, 0x000fe400078e00ffULL, 0x000000012e307824ULL, 0x100fe200078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027247984ULL, 0x0022a40000004800ULL,
0x000000012c277824ULL, 0x002fca00078e0203ULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x8000000526287c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000012e277824ULL, 0x000fe400078e0223ULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000281d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a08002c297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000041d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e257824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002c297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a18002c297984ULL, 0x000ea80000004800ULL,
0x010ac00029267984ULL, 0x004ea40000004800ULL, 0x0000002615267224ULL, 0x004fc400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d26267210ULL, 0x000fc80007fde0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0x0000c00023237811ULL, 0x000fd600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL, 0x010a00002c287984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe400078e0223ULL, 0x000000f0262b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x010ac00028287984ULL, 0x002e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24267210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102c257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x000000102e2e7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL, 0x010a08002c287984ULL, 0x000ea20000004800ULL,
0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL,
0x000000012e267824ULL, 0x042fe400078e0223ULL, 0x000000012e2d7824ULL, 0x040fe400078e0203ULL,
0x000000102e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL,
0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fca00030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002c287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e0029ULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e8000b901c50ULL,
0x010a18002c287984ULL, 0x000ee80000004800ULL, 0x010ac00028287984ULL, 0x008ee40000004800ULL,
0x0000002815237224ULL, 0x008fc800078e0223ULL, 0x00005e0023247625ULL, 0x002fc800078e0029ULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000002b24247210ULL, 0x000fe20007fde0ffULL,
0x000000102e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0xfffffff02e237812ULL, 0x000fc800078ee223ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0005e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x006e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff22237207ULL, 0x040fe40003000000ULL, 0x000000ff22247207ULL, 0x000fc60007000000ULL,
0x0000000120207824ULL, 0x000fe200078e0223ULL, 0x00010a0016237811ULL, 0x000fc600078e10ffULL,
0x0000004020227824ULL, 0x040fe200078e00ffULL, 0x0000002120207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a24217c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff247424ULL, 0x000fc600078e00ffULL,
0x0000002020207810ULL, 0x000fca0007ffe0ffULL, 0x0000000116227824ULL, 0x100fe400078e0220ULL,
0x0000680021217a24ULL, 0x000fc600078e0220ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000116217824ULL, 0x000fc800078e0221ULL, 0x0000660021207625ULL, 0x000fd000078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff667f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x00012e327f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0004e400000e0000ULL,
0x00012e727f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000b9f000207802ULL, 0x000fc40000000f00ULL,
0x0001396000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0000ba4000207802ULL, 0x000fc40000000f00ULL, 0x0001391000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006b24783bULL, 0x006e620000004200ULL, 0x000000ff2a00720cULL, 0x000fe20003fc5270ULL,
0x00000f4000017945ULL, 0x000fe20003800000ULL, 0x0000a8006d407811ULL, 0x000fe200078e20ffULL,
0x000000006a28783bULL, 0x000ea80000004200ULL, 0x000000006920783bULL, 0x000fe80000004200ULL,
0x000000006c34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000100242e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x00000100252f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011424ULL,
0x0000010028327824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002a337824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011428ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x00008880288b7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011429ULL,
0x0000888029867816ULL, 0x040fe400000000ffULL, 0x00000018ff847819ULL, 0x000fe20000011428ULL,
0x0000002e003d7306ULL, 0x0003e20000200c00ULL, 0x0000010026287824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011433ULL, 0x0000001b4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000001b4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fe20000011420ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x0000888020787816ULL, 0x000fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011425ULL, 0x0000003200887306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe20000011429ULL, 0x0000010027297824ULL, 0x000fe200078e00ffULL,
0x0000888025457816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002e00897306ULL, 0x0005e20000200c00ULL,
0x0000888027327816ULL, 0x042fe200000000ffULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d002d7306ULL, 0x000fe20000200c00ULL, 0x00008880262e7816ULL, 0x044fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00008880343e7816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff877819ULL, 0x000fe20000011436ULL, 0x0000002600337306ULL, 0x0002a20000200c00ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff827819ULL, 0x000fe40000011437ULL,
0x00008880378d7816ULL, 0x000fc400000000ffULL, 0x00000018ff397819ULL, 0x000fe20000011435ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x0000010020267824ULL, 0x042fe200078e00ffULL,
0x00008880358c7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011421ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff747819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000029003f7306ULL, 0x000fe20000200c00ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888021777816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff767819ULL, 0x000fe4000001142aULL, 0x00000018ff757819ULL, 0x000fe4000001142bULL,
0x000088802a7f7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000088802b7c7816ULL, 0x000fe200000000ffULL, 0x0000002f00467306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff717819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011423ULL,
0x00000028002f7306ULL, 0x0005e20000200c00ULL, 0x0000541044447816ULL, 0x002fce000000003dULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x044fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x00000018ff2b7819ULL, 0x000fce000001142bULL,
0x0000003100317306ULL, 0x000ff00000200c00ULL, 0x00000027008a7306ULL, 0x0004e20000200c00ULL,
0x0000541025297816ULL, 0x002fce000000002cULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0001000035277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002000837306ULL, 0x0002a20000200c00ULL, 0x000054108a317816ULL, 0x008fce0000000031ULL,
0x0000002600797306ULL, 0x0007e20000200c00ULL, 0x0000010036207824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011420ULL,
0x00000028007d7306ULL, 0x0003e20000200c00ULL, 0x0000010035267824ULL, 0x008fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc80000011436ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000027003a7306ULL, 0x000fe20000200c00ULL, 0x0000541024287816ULL, 0x002fe4000000002dULL,
0x0000a8006e247811ULL, 0x000fe400078e20ffULL, 0x00005410322d7816ULL, 0x000fe2000000003fULL,
0x0000010037327824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000002600357306ULL, 0x0003e40000200c00ULL, 0x00000018ff8a7819ULL, 0x000fc40000011432ULL,
0x000000304030723cULL, 0x000fe800000018ffULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x00000034003b7306ULL, 0x0005f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103e347816ULL, 0x004fe20000000083ULL,
0x00000100213e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011437ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000541045457816ULL, 0x008fc60000000046ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff217819ULL, 0x000fc60000011421ULL,
0x000000444044723cULL, 0x000f6800000018ffULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x000054103c3c7816ULL, 0x004fe2000000003dULL,
0x0000001b2424b232ULL, 0x002fc40000000000ULL, 0x0000001b2626b232ULL, 0x000fe40000000000ULL,
0x0000001a2525b232ULL, 0x080fe40000000000ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x0000001a2727b232ULL, 0x000fcc0000000000ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000054103a397816ULL, 0x010fce0000000039ULL,
0x0000008d003f7306ULL, 0x000fe20000200c00ULL, 0x000054102e2c7816ULL, 0x002fe2000000002fULL,
0x000000384038723cULL, 0x040fec00000018ffULL, 0x0000008a008e7306ULL, 0x000e620000200c00ULL,
0x000054108c357816ULL, 0x004fe20000000035ULL, 0x0000002c402c723cULL, 0x000fe200000018ffULL,
0x00000018ff8c7819ULL, 0x000fca000001143eULL, 0x0000008700877306ULL, 0x000fe40000200c00ULL,
0x000000344034723cULL, 0x000fec00000018ffULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x000054103f3d7816ULL, 0x002fe4000000008eULL, 0x00008880228e7816ULL, 0x000fca00000000ffULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0000003c403c723cULL, 0x000fee00000018ffULL,
0x00000083008d7306ULL, 0x000eb00000200c00ULL, 0x0000002100837306ULL, 0x0005e20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000087ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000054108d217816ULL, 0x004fe20000000082ULL, 0x000000ffff827224ULL, 0x000fcc00078e008eULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002a007b7306ULL, 0x000ff00000200c00ULL,
0x0000002b007a7306ULL, 0x0005f00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x0000541086217816ULL, 0x002fe20000000089ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888023867816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002000877306ULL, 0x0007f00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108b207816ULL, 0x008fce0000000088ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x000000202444723cULL, 0x000b6e0000001844ULL,
0x0000007c007c7306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x024fe40000000081ULL,
0x0000541085217816ULL, 0x002fe20000000080ULL, 0x0000010023807824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fe400078e00ffULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff237819ULL, 0x000fca0000011423ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000000ffff217224ULL, 0x020fe200078e0086ULL, 0x000054107f207816ULL, 0x008fcc000000007eULL,
0x0000002100817306ULL, 0x0009f00000200c00ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x000054107c217816ULL, 0x010fce000000007dULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000008c008a7306ULL, 0x000f220000200c00ULL,
0x000054107b207816ULL, 0x022fe40000000076ULL, 0x000054107a217816ULL, 0x004fca0000000075ULL,
0x0000007300737306ULL, 0x000fe40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541078207816ULL, 0x028fe40000000079ULL,
0x0000541077217816ULL, 0x010fca000000008aULL, 0x0000007400747306ULL, 0x000ea40000200c00ULL,
0x000000202434723cULL, 0x000b6c0000001834ULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x0000541083217816ULL, 0x022fce0000000072ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541074207816ULL, 0x004fce0000000073ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000202438723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541082207816ULL, 0x028fe40000000087ULL, 0x0000541081217816ULL, 0x002fca0000000080ULL,
0x0000002200227306ULL, 0x000e640000200c00ULL, 0x00000020243c723cULL, 0x000b6c000000183cULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541022207816ULL, 0x022fe40000000071ULL,
0x0000541023217816ULL, 0x004fce0000000066ULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000440f0f7221ULL, 0x000fe20000010000ULL, 0x000000450c0c7221ULL, 0x000fe20000010000ULL,
0x000000280b0b7221ULL, 0x000fe20000010000ULL, 0x0000002908087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000460d0d7221ULL, 0x000fe20000010000ULL,
0x000000470a0a7221ULL, 0x000fe20000010000ULL, 0x0000002a09097221ULL, 0x000fe20000010000ULL,
0x0000002b06067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006f7000720cULL, 0x000fe20003f06070ULL, 0x010b8800ff227f8cULL, 0x000e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaac000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008013207811ULL, 0x020fe200078e40ffULL,
0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005f2000720cULL, 0x000fda0003f06070ULL,
0x0000ab9000000947ULL, 0x000fea0003800000ULL, 0x000000ffff707224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe20000011670ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000370227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000002170217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000221247810ULL, 0x000fc80007ffe0ffULL, 0x0000000324207812ULL, 0x040fe400078ec0ffULL,
0x0000001324217211ULL, 0x000fc400078ff0ffULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x010b8c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000121237810ULL, 0x040fe20007ffe0ffULL, 0x0000000421257824ULL, 0x000fe200078e0220ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000602300720cULL, 0x000fe40003f06070ULL,
0x0000002025287811ULL, 0x000fc800078e30ffULL, 0x000000605b237812ULL, 0x000fce00078ef828ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000285f257217ULL, 0x000fe40007800000ULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x010a00002c267984ULL, 0x000e620000004800ULL,
0x000000012c277824ULL, 0x000fe400078e0223ULL, 0x0000000125257824ULL, 0x000fe200078e0a28ULL,
0x00000005312e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fc600078e00ffULL,
0x0000000525257c17ULL, 0x000fe2000f800000ULL, 0x000000012e297824ULL, 0x000fe200078e0223ULL,
0x000000f0282d7812ULL, 0x000fe200078ec0ffULL, 0x000000102c287824ULL, 0x040fe200078e00ffULL,
0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012c257824ULL, 0x100fe400078e0203ULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x0000002a1d00720cULL, 0x000fe40003f06070ULL,
0xfffffff028257812ULL, 0x000fc800078ee225ULL, 0x0000e000252f7811ULL, 0x000fe200078e20ffULL,
0x010ac00026267984ULL, 0x002e640000004800ULL, 0x0000002615277224ULL, 0x002fc800078e0227ULL,
0x00005e0027267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff277224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a08002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000041d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe400008e0629ULL,
0x000000012e297824ULL, 0x000fc600078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a10002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000061d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c50ULL,
0x0000002a3100720cULL, 0x000fc60003f06070ULL, 0x010a18002c257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fe400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d28267210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fc600008e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026237faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fe400078e00ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000022a2c7810ULL, 0x040fe20007ffe0ffULL,
0x010a00002a257984ULL, 0x000e620000004800ULL, 0x000000012a277824ULL, 0x000fe200078e0223ULL,
0x000000f0282d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a287824ULL, 0x040fe400078e0203ULL,
0x000000102a297824ULL, 0x000fc400078e00ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0203ULL,
0x000000102c317824ULL, 0x040fe200078e00ffULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x000000012c297824ULL, 0x000fe200078e0223ULL, 0x000000042a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000e000282f7811ULL, 0x000fe400078e20ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000102c317824ULL, 0x000fe200078e00ffULL, 0x010ac00025267984ULL, 0x002e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e8000b901c50ULL,
0x010a08002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fe200078e20ffULL,
0x000000012c277824ULL, 0x040fe400078e0223ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000012c237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28287210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL,
0x010ac00025267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c50ULL, 0x010a18002a257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fc400078e0223ULL,
0x000000012c237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002bULL,
0x000000102c2c7824ULL, 0x000fe200078e00ffULL, 0x0000002d28287210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02c237812ULL, 0x000fe200078ee223ULL, 0x000000ffff297224ULL, 0x000fc600000e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028237faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff267f8cULL, 0x002e64000c80043fULL,
0x000000ffff2a7224ULL, 0x002fc400078e0027ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011429ULL,
0x0000002823237211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000223237819ULL, 0x000fc80000001228ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000124247812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012400780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b1800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b1c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b1c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0101000027237984ULL, 0x000e680000000800ULL, 0x0103000027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x000104027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x000103c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105002427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200297308ULL, 0x000e640000000800ULL, 0x000000290e0e7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000103127f007947ULL, 0x000fea000b800000ULL,
0x00001f6829127589ULL, 0x0002a400000e0000ULL, 0x000000120f0f7220ULL, 0x084fe20000410000ULL,
0x000000120c0c7220ULL, 0x080fe20000410000ULL, 0x000000120b0b7220ULL, 0x080fe20000410000ULL,
0x0000001208087220ULL, 0x080fe20000410000ULL, 0x0000001207077220ULL, 0x080fe20000410000ULL,
0x0000001204047220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000102227f007947ULL, 0x000fea000b800000ULL, 0x00001f6529127589ULL, 0x00046400000e0000ULL,
0x000000120d0d7220ULL, 0x082fe20000410000ULL, 0x000000120a0a7220ULL, 0x080fe20000410000ULL,
0x0000001209097220ULL, 0x080fe20000410000ULL, 0x0000001206067220ULL, 0x080fe20000410000ULL,
0x0000001205057220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x0000001249497220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124d4d7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001251517220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001255557220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x0000001259597220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000e220e7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000100627f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x000100a27f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000e9d000207802ULL, 0x000fc40000000f00ULL,
0x0001098000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0000ea2000207802ULL, 0x000fc40000000f00ULL, 0x0001093000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x0000b00063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000b00064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200f0f7221ULL, 0x000fe20000010000ULL, 0x000000210c0c7221ULL, 0x000fe20000010000ULL,
0x000000440b0b7221ULL, 0x000fe20000010000ULL, 0x0000004508087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220d0d7221ULL, 0x000fe20000010000ULL,
0x000000230a0a7221ULL, 0x000fe20000010000ULL, 0x0000004609097221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff297224ULL, 0x020fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366227812ULL, 0x000fe400078ec0ffULL, 0x0000000223247810ULL, 0x000fe40007ffe0ffULL,
0x000000135e00720cULL, 0x000fe40003f03070ULL, 0x00000040ff2a7803ULL, 0x000fe40000000000ULL,
0x000000ff22227207ULL, 0x000fe20006800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0021ULL,
0x0000000324207812ULL, 0x000fc400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121257810ULL, 0x040fe20007ffe0ffULL,
0x0000000421237824ULL, 0x000fe200078e0220ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000602500720cULL, 0x000fe20003fc6070ULL, 0x0000004023287824ULL, 0x000fca00078e00ffULL,
0x000000405b237812ULL, 0x000fce00078ef828ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002c277984ULL, 0x000e620000004800ULL, 0x000000012c257824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe400078ec0ffULL, 0x000000285f267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a28ULL,
0x000000102c287824ULL, 0x000fe400078e00ffULL, 0x000000012e307824ULL, 0x100fe200078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027247984ULL, 0x0022a40000004800ULL,
0x000000012c277824ULL, 0x002fca00078e0203ULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x8000000526287c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000012e277824ULL, 0x000fe400078e0223ULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000281d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a08002c297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000041d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e257824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002c297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a18002c297984ULL, 0x000ea80000004800ULL,
0x010ac00029267984ULL, 0x004ea40000004800ULL, 0x0000002615267224ULL, 0x004fc400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d26267210ULL, 0x000fc80007fde0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0x0000c00023237811ULL, 0x000fd600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL, 0x010a00002c287984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe400078e0223ULL, 0x000000f0262b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x010ac00028287984ULL, 0x002e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24267210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102c257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x000000102e2e7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL, 0x010a08002c287984ULL, 0x000ea20000004800ULL,
0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL,
0x000000012e267824ULL, 0x042fe400078e0223ULL, 0x000000012e2d7824ULL, 0x040fe400078e0203ULL,
0x000000102e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL,
0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fca00030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002c287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e0029ULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e8000b901c50ULL,
0x010a18002c287984ULL, 0x000ee80000004800ULL, 0x010ac00028287984ULL, 0x008ee40000004800ULL,
0x0000002815237224ULL, 0x008fc800078e0223ULL, 0x00005e0023247625ULL, 0x002fc800078e0029ULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000002b24247210ULL, 0x000fe20007fde0ffULL,
0x000000102e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0xfffffff02e237812ULL, 0x000fc800078ee223ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0005e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x006e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff22237207ULL, 0x040fe40003000000ULL, 0x000000ff22247207ULL, 0x000fc60007000000ULL,
0x0000000120207824ULL, 0x000fe200078e0223ULL, 0x00010a0016237811ULL, 0x000fc600078e10ffULL,
0x0000004020227824ULL, 0x040fe200078e00ffULL, 0x0000002120207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a24217c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff247424ULL, 0x000fc600078e00ffULL,
0x0000002020207810ULL, 0x000fca0007ffe0ffULL, 0x0000000116227824ULL, 0x100fe400078e0220ULL,
0x0000680021217a24ULL, 0x000fc600078e0220ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000116217824ULL, 0x000fc800078e0221ULL, 0x0000660021207625ULL, 0x000fd000078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff667f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000db227f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0004e400000e0000ULL,
0x0000db627f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00010fd000207802ULL, 0x000fc40000000f00ULL,
0x0000e38000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0001102000207802ULL, 0x000fc40000000f00ULL, 0x0000e33000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006b24783bULL, 0x006e620000004200ULL, 0x000000ff2a00720cULL, 0x000fe20003fc5270ULL,
0x00000f4000017945ULL, 0x000fe20003800000ULL, 0x0000b0006d407811ULL, 0x000fe200078e20ffULL,
0x000000006a28783bULL, 0x000ea80000004200ULL, 0x000000006920783bULL, 0x000fe80000004200ULL,
0x000000006c34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000100242e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x00000100252f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011424ULL,
0x0000010028327824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002a337824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011428ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x00008880288b7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011429ULL,
0x0000888029867816ULL, 0x040fe400000000ffULL, 0x00000018ff847819ULL, 0x000fe20000011428ULL,
0x0000002e003d7306ULL, 0x0003e20000200c00ULL, 0x0000010026287824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011433ULL, 0x0000001b4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000001b4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fe20000011420ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x0000888020787816ULL, 0x000fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011425ULL, 0x0000003200887306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe20000011429ULL, 0x0000010027297824ULL, 0x000fe200078e00ffULL,
0x0000888025457816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002e00897306ULL, 0x0005e20000200c00ULL,
0x0000888027327816ULL, 0x042fe200000000ffULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d002d7306ULL, 0x000fe20000200c00ULL, 0x00008880262e7816ULL, 0x044fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00008880343e7816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff877819ULL, 0x000fe20000011436ULL, 0x0000002600337306ULL, 0x0002a20000200c00ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff827819ULL, 0x000fe40000011437ULL,
0x00008880378d7816ULL, 0x000fc400000000ffULL, 0x00000018ff397819ULL, 0x000fe20000011435ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x0000010020267824ULL, 0x042fe200078e00ffULL,
0x00008880358c7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011421ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff747819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000029003f7306ULL, 0x000fe20000200c00ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888021777816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff767819ULL, 0x000fe4000001142aULL, 0x00000018ff757819ULL, 0x000fe4000001142bULL,
0x000088802a7f7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000088802b7c7816ULL, 0x000fe200000000ffULL, 0x0000002f00467306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff717819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011423ULL,
0x00000028002f7306ULL, 0x0005e20000200c00ULL, 0x0000541044447816ULL, 0x002fce000000003dULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x044fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x00000018ff2b7819ULL, 0x000fce000001142bULL,
0x0000003100317306ULL, 0x000ff00000200c00ULL, 0x00000027008a7306ULL, 0x0004e20000200c00ULL,
0x0000541025297816ULL, 0x002fce000000002cULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0001000035277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002000837306ULL, 0x0002a20000200c00ULL, 0x000054108a317816ULL, 0x008fce0000000031ULL,
0x0000002600797306ULL, 0x0007e20000200c00ULL, 0x0000010036207824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011420ULL,
0x00000028007d7306ULL, 0x0003e20000200c00ULL, 0x0000010035267824ULL, 0x008fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc80000011436ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000027003a7306ULL, 0x000fe20000200c00ULL, 0x0000541024287816ULL, 0x002fe4000000002dULL,
0x0000b0006e247811ULL, 0x000fe400078e20ffULL, 0x00005410322d7816ULL, 0x000fe2000000003fULL,
0x0000010037327824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000002600357306ULL, 0x0003e40000200c00ULL, 0x00000018ff8a7819ULL, 0x000fc40000011432ULL,
0x000000304030723cULL, 0x000fe800000018ffULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x00000034003b7306ULL, 0x0005f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103e347816ULL, 0x004fe20000000083ULL,
0x00000100213e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011437ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000541045457816ULL, 0x008fc60000000046ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff217819ULL, 0x000fc60000011421ULL,
0x000000444044723cULL, 0x000f6800000018ffULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x000054103c3c7816ULL, 0x004fe2000000003dULL,
0x0000001b2424b232ULL, 0x002fc40000000000ULL, 0x0000001b2626b232ULL, 0x000fe40000000000ULL,
0x0000001a2525b232ULL, 0x080fe40000000000ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x0000001a2727b232ULL, 0x000fcc0000000000ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000054103a397816ULL, 0x010fce0000000039ULL,
0x0000008d003f7306ULL, 0x000fe20000200c00ULL, 0x000054102e2c7816ULL, 0x002fe2000000002fULL,
0x000000384038723cULL, 0x040fec00000018ffULL, 0x0000008a008e7306ULL, 0x000e620000200c00ULL,
0x000054108c357816ULL, 0x004fe20000000035ULL, 0x0000002c402c723cULL, 0x000fe200000018ffULL,
0x00000018ff8c7819ULL, 0x000fca000001143eULL, 0x0000008700877306ULL, 0x000fe40000200c00ULL,
0x000000344034723cULL, 0x000fec00000018ffULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x000054103f3d7816ULL, 0x002fe4000000008eULL, 0x00008880228e7816ULL, 0x000fca00000000ffULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0000003c403c723cULL, 0x000fee00000018ffULL,
0x00000083008d7306ULL, 0x000eb00000200c00ULL, 0x0000002100837306ULL, 0x0005e20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000087ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000054108d217816ULL, 0x004fe20000000082ULL, 0x000000ffff827224ULL, 0x000fcc00078e008eULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002a007b7306ULL, 0x000ff00000200c00ULL,
0x0000002b007a7306ULL, 0x0005f00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x0000541086217816ULL, 0x002fe20000000089ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888023867816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002000877306ULL, 0x0007f00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108b207816ULL, 0x008fce0000000088ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x000000202444723cULL, 0x000b6e0000001844ULL,
0x0000007c007c7306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x024fe40000000081ULL,
0x0000541085217816ULL, 0x002fe20000000080ULL, 0x0000010023807824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fe400078e00ffULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff237819ULL, 0x000fca0000011423ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000000ffff217224ULL, 0x020fe200078e0086ULL, 0x000054107f207816ULL, 0x008fcc000000007eULL,
0x0000002100817306ULL, 0x0009f00000200c00ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x000054107c217816ULL, 0x010fce000000007dULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000008c008a7306ULL, 0x000f220000200c00ULL,
0x000054107b207816ULL, 0x022fe40000000076ULL, 0x000054107a217816ULL, 0x004fca0000000075ULL,
0x0000007300737306ULL, 0x000fe40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541078207816ULL, 0x028fe40000000079ULL,
0x0000541077217816ULL, 0x010fca000000008aULL, 0x0000007400747306ULL, 0x000ea40000200c00ULL,
0x000000202434723cULL, 0x000b6c0000001834ULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x0000541083217816ULL, 0x022fce0000000072ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541074207816ULL, 0x004fce0000000073ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000202438723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541082207816ULL, 0x028fe40000000087ULL, 0x0000541081217816ULL, 0x002fca0000000080ULL,
0x0000002200227306ULL, 0x000e640000200c00ULL, 0x00000020243c723cULL, 0x000b6c000000183cULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541022207816ULL, 0x022fe40000000071ULL,
0x0000541023217816ULL, 0x004fce0000000066ULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000440f0f7221ULL, 0x000fe20000010000ULL, 0x000000450c0c7221ULL, 0x000fe20000010000ULL,
0x000000280b0b7221ULL, 0x000fe20000010000ULL, 0x0000002908087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000460d0d7221ULL, 0x000fe20000010000ULL,
0x000000470a0a7221ULL, 0x000fe20000010000ULL, 0x0000002a09097221ULL, 0x000fe20000010000ULL,
0x0000002b06067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006f7000720cULL, 0x000fe20003f06070ULL, 0x010b8800ff227f8cULL, 0x000e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaac000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c013207811ULL, 0x020fe200078e40ffULL,
0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005f2000720cULL, 0x000fda0003f06070ULL,
0x000055b000000947ULL, 0x000fea0003800000ULL, 0x000000ffff707224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe20000011670ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000370227812ULL, 0x042fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000002170217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000321247810ULL, 0x000fc80007ffe0ffULL, 0x0000000324207812ULL, 0x040fe400078ec0ffULL,
0x0000001324217211ULL, 0x000fc400078ff0ffULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x010b8c00ff287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff257819ULL, 0x000fc80000011429ULL,
0x0000002825257211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000225257819ULL, 0x000fc80000001228ULL, 0x000000250000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff287984ULL, 0x000e640000000800ULL,
0x8000000028ff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000121237810ULL, 0x040fe20007ffe0ffULL, 0x0000000421257824ULL, 0x000fe200078e0220ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000602300720cULL, 0x000fe40003f06070ULL,
0x0000002025287811ULL, 0x000fc800078e30ffULL, 0x000000605b237812ULL, 0x000fce00078ef828ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000285f257217ULL, 0x000fe40007800000ULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x010a00002c267984ULL, 0x000e620000004800ULL,
0x000000012c277824ULL, 0x000fe400078e0223ULL, 0x0000000125257824ULL, 0x000fe200078e0a28ULL,
0x00000005312e7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fc600078e00ffULL,
0x0000000525257c17ULL, 0x000fe2000f800000ULL, 0x000000012e297824ULL, 0x000fe200078e0223ULL,
0x000000f0282d7812ULL, 0x000fe200078ec0ffULL, 0x000000102c287824ULL, 0x040fe200078e00ffULL,
0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012c257824ULL, 0x100fe400078e0203ULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x0000002a1d00720cULL, 0x000fe40003f06070ULL,
0xfffffff028257812ULL, 0x000fc800078ee225ULL, 0x0000e000252f7811ULL, 0x000fe200078e20ffULL,
0x010ac00026267984ULL, 0x002e640000004800ULL, 0x0000002615277224ULL, 0x002fc800078e0227ULL,
0x00005e0027267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff277224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a08002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000041d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e307824ULL, 0x000fe200078e0203ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fe400008e0629ULL,
0x000000012e297824ULL, 0x000fc600078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fe20003f06070ULL,
0x000000102e317824ULL, 0x000fe400078e00ffULL, 0x010a10002c257984ULL, 0x000ea60000004800ULL,
0xfffffff031307812ULL, 0x000fe400078ee230ULL, 0x000000061d317810ULL, 0x000fe40007ffe0ffULL,
0x0000e000302f7811ULL, 0x002fc400078e20ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c50ULL,
0x0000002a3100720cULL, 0x000fc60003f06070ULL, 0x010a18002c257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fe400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d28267210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fc600008e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026237faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003287824ULL, 0x000fe400078e00ffULL,
0x00000100ff2b7424ULL, 0x000fe200078e00ffULL, 0x000000022a2c7810ULL, 0x040fe20007ffe0ffULL,
0x010a00002a257984ULL, 0x000e620000004800ULL, 0x000000012a277824ULL, 0x000fe200078e0223ULL,
0x000000f0282d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a287824ULL, 0x040fe400078e0203ULL,
0x000000102a297824ULL, 0x000fc400078e00ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0203ULL,
0x000000102c317824ULL, 0x040fe200078e00ffULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x000000012c297824ULL, 0x000fe200078e0223ULL, 0x000000042a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000e000282f7811ULL, 0x000fe400078e20ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000102c317824ULL, 0x000fe200078e00ffULL, 0x010ac00025267984ULL, 0x002e640000004800ULL,
0x0000002615267224ULL, 0x002fc800078e0227ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e8000b901c50ULL,
0x010a08002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fe200078e20ffULL,
0x000000012c277824ULL, 0x040fe400078e0223ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000012c237824ULL, 0x000fe200078e0223ULL, 0x010ac00025287984ULL, 0x004e640000004800ULL,
0x0000002815287224ULL, 0x002fc800078e0229ULL, 0x00005e0028287625ULL, 0x000fca00078e002bULL,
0x0000002d28287210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002a257984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL,
0x010ac00025267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c50ULL, 0x010a18002a257984ULL, 0x000ea80000004800ULL,
0x010ac00025287984ULL, 0x004ea40000004800ULL, 0x0000002815287224ULL, 0x004fc400078e0223ULL,
0x000000012c237824ULL, 0x000fe400078e0203ULL, 0x00005e0028287625ULL, 0x000fc800078e002bULL,
0x000000102c2c7824ULL, 0x000fe200078e00ffULL, 0x0000002d28287210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02c237812ULL, 0x000fe200078ee223ULL, 0x000000ffff297224ULL, 0x000fc600000e0629ULL,
0x0000e00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028237faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff267f8cULL, 0x002e64000c80043fULL,
0x000000ffff2a7224ULL, 0x002fc400078e0027ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002826287210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011429ULL,
0x0000002823237211ULL, 0x000fca00078110ffULL, 0x000000ffff287224ULL, 0x000fca00000e0629ULL,
0x0000000223237819ULL, 0x000fc80000001228ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000215e00720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000124247812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012400780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031600780cULL, 0x000fe40003f04070ULL, 0x0000000114147810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000237919ULL, 0x000e620000002700ULL,
0x0000640014247a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff257424ULL, 0x000fe200078e00ffULL,
0x0000005d1400720cULL, 0x000fe20003f06070ULL, 0x0000000423237824ULL, 0x002fc800078e0216ULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac016237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fe40003f04070ULL,
0x0000000122237810ULL, 0x002fc80007ffe0ffULL, 0x0000000323227812ULL, 0x000fc800078ec0ffULL,
0x000000ff22227207ULL, 0x000fc60004000000ULL, 0x00000002ff238819ULL, 0x000fca0000011623ULL,
0x0000000120207824ULL, 0x000fc800078e0223ULL, 0x0000004020237824ULL, 0x040fe200078e00ffULL,
0x0000002120207211ULL, 0x000fc800078ff0ffULL, 0x000000c023237812ULL, 0x000fca00078ec0ffULL,
0x0000010020237824ULL, 0x000fe200078e0223ULL, 0x0000000a22207c10ULL, 0x000fc6000fffe0ffULL,
0x0000000116227824ULL, 0x100fe400078e0223ULL, 0x0000680020217a24ULL, 0x000fe200078e0223ULL,
0x00010a0016237811ULL, 0x000fe200078e10ffULL, 0x00000004ff207424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f06070ULL, 0x0000000116217824ULL, 0x000fc800078e0221ULL,
0x0000660021207625ULL, 0x000fd000078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b3800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b3c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b3c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0101800027237984ULL, 0x000e680000000800ULL, 0x0103800027227984ULL, 0x0004e20000000800ULL,
0x000000122300720bULL, 0x002fe20003f1d000ULL, 0x0000b0f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff18287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0012ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x000fe40003f05270ULL, 0x000000122300720bULL, 0x000fe20003f34000ULL,
0x0000b0b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002312247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002412127221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200297308ULL, 0x000e640000000800ULL, 0x000000290e0e7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000b0027f007947ULL, 0x000fea000b800000ULL,
0x00001f6829127589ULL, 0x0002a400000e0000ULL, 0x000000120f0f7220ULL, 0x084fe20000410000ULL,
0x000000120c0c7220ULL, 0x080fe20000410000ULL, 0x000000120b0b7220ULL, 0x080fe20000410000ULL,
0x0000001208087220ULL, 0x080fe20000410000ULL, 0x0000001207077220ULL, 0x080fe20000410000ULL,
0x0000001204047220ULL, 0x080fe20000410000ULL, 0x000000121f1f7220ULL, 0x080fe20000410000ULL,
0x000000124a4a7220ULL, 0x080fe20000410000ULL, 0x000000124b4b7220ULL, 0x080fe20000410000ULL,
0x000000124e4e7220ULL, 0x080fe20000410000ULL, 0x000000124f4f7220ULL, 0x080fe20000410000ULL,
0x0000001252527220ULL, 0x080fe20000410000ULL, 0x0000001253537220ULL, 0x080fe20000410000ULL,
0x0000001256567220ULL, 0x080fe20000410000ULL, 0x0000001257577220ULL, 0x080fe20000410000ULL,
0x000000125a5a7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000af127f007947ULL, 0x000fea000b800000ULL, 0x00001f6529127589ULL, 0x00046400000e0000ULL,
0x000000120d0d7220ULL, 0x082fe20000410000ULL, 0x000000120a0a7220ULL, 0x080fe20000410000ULL,
0x0000001209097220ULL, 0x080fe20000410000ULL, 0x0000001206067220ULL, 0x080fe20000410000ULL,
0x0000001205057220ULL, 0x080fe20000410000ULL, 0x0000001248487220ULL, 0x080fe20000410000ULL,
0x0000001249497220ULL, 0x080fe20000410000ULL, 0x000000124c4c7220ULL, 0x080fe20000410000ULL,
0x000000124d4d7220ULL, 0x080fe20000410000ULL, 0x0000001250507220ULL, 0x080fe20000410000ULL,
0x0000001251517220ULL, 0x080fe20000410000ULL, 0x0000001254547220ULL, 0x080fe20000410000ULL,
0x0000001255557220ULL, 0x080fe20000410000ULL, 0x0000001258587220ULL, 0x080fe20000410000ULL,
0x0000001259597220ULL, 0x080fe20000410000ULL, 0x000000125c5c7220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002423230221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300190308ULL, 0x000e640000000800ULL,
0x0000001922220220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000e220e7221ULL, 0x008fe20000010000ULL, 0x000000ffff127224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000ad527f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0002e400000e0000ULL,
0x0000ad927f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00013fb000207802ULL, 0x000fc40000000f00ULL,
0x0000b3a000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0001400000207802ULL, 0x000fc40000000f00ULL, 0x0000b35000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x0000b80063407811ULL, 0x000fe200078e20ffULL,
0x00000fa000017945ULL, 0x000fe20003800000ULL, 0x000000706800720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000135e00720cULL, 0x000fc40003fc3070ULL,
0x000000706500720cULL, 0x000fe20003f26070ULL, 0x000000006128783bULL, 0x000fe20000004200ULL,
0x000000135e00720cULL, 0x000fc60003f03070ULL, 0x000000006234783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00008880203d7816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff807819ULL, 0x000fe40000011425ULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888025857816ULL, 0x000fe200000000ffULL,
0x0000002000477306ULL, 0x0003e20000200c00ULL, 0x00000018ff817819ULL, 0x000fe20000011424ULL,
0x0000001b4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001b4242b232ULL, 0x000fe20000000000ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x0000001a4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff777819ULL, 0x000fe20000011426ULL,
0x0000002c00827306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011427ULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00008880267d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002d008b7306ULL, 0x000fe20000200c00ULL, 0x00000100252c7824ULL, 0x004fe200078e00ffULL,
0x00008880277c7816ULL, 0x000fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011422ULL, 0x00000018ff887819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000020002d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff847819ULL, 0x000fe4000001142cULL, 0x00008880222c7816ULL, 0x000fe200000000ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010027207824ULL, 0x042fe200078e00ffULL,
0x00008880343e7816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100247306ULL, 0x0002a20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880378c7816ULL, 0x000fe200000000ffULL,
0x0000002500837306ULL, 0x0007e20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fc40000011423ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020007f7306ULL, 0x0003e20000200c00ULL,
0x0000010026257824ULL, 0x008fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888035897816ULL, 0x000fe400000000ffULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000010028207824ULL, 0x002fe200078e00ffULL, 0x00000025007e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011428ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000b80064257811ULL, 0x002fe200078e20ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff747819ULL, 0x000fe40000011429ULL, 0x0000888028797816ULL, 0x040fe200000000ffULL,
0x00000026007a7306ULL, 0x000fe20000200c00ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe4000001142aULL, 0x00000018ff727819ULL, 0x000fe4000001142bULL,
0x00000018ff287819ULL, 0x000fc40000011428ULL, 0x00000027007b7306ULL, 0x0003f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0007e20000200c00ULL, 0x0000010036227824ULL, 0x004fc400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000034003b7306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x048fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002e00867306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fca00078e00ffULL,
0x00000020003f7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fc80000011437ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x000054103d207816ULL, 0x004fe20000000082ULL, 0x0000001b2424b232ULL, 0x082fe20000000000ULL,
0x00000018ff3d7819ULL, 0x000fe20000011422ULL, 0x0000001b2626b232ULL, 0x000fe20000000000ULL,
0x00000018ff827819ULL, 0x000fe20000011434ULL, 0x0000001a2525b232ULL, 0x080fe40000000000ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000001a2727b232ULL, 0x000fce0000000000ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x0000541047447816ULL, 0x008fce0000000044ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000541046217816ULL, 0x002fe4000000008bULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054102c2c7816ULL, 0x004fce000000002dULL,
0x0000003000307306ULL, 0x000eb00000200c00ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000ff00000200c00ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x000054103b387816ULL, 0x002fce0000000038ULL,
0x0000002300327306ULL, 0x0002f00000200c00ULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x000000204020723cULL, 0x002f6200000018ffULL, 0x000054102e2d7816ULL, 0x004fcc000000002fULL,
0x00000035003a7306ULL, 0x0002a20000200c00ULL, 0x0000541032317816ULL, 0x008fe20000000031ULL,
0x0000002c402c723cULL, 0x040f6c00000018ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x0000541089357816ULL, 0x002fe2000000008aULL, 0x00000100298a7824ULL, 0x040fe200078e00ffULL,
0x0000888029897816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x000054103e347816ULL, 0x010fe2000000003fULL, 0x000000304030723cULL, 0x000f6200000018ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x00000082008d7306ULL, 0x000e620000200c00ULL,
0x000054103a397816ULL, 0x004fc40000000039ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054108c3d7816ULL, 0x002fce000000008dULL,
0x00000036008b7306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008e008e7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000054108b667816ULL, 0x004fc40000000066ULL,
0x000088802a8b7816ULL, 0x000fca00000000ffULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x000054108e677816ULL, 0x008fce0000000067ULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6e00000018ffULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000ef00000200c00ULL,
0x0000002800827306ULL, 0x0003f00000200c00ULL, 0x0000002900677306ULL, 0x0205e20000200c00ULL,
0x0000541087287816ULL, 0x002fe20000000086ULL, 0x000001002a867824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x0000541085297816ULL, 0x004fe20000000088ULL,
0x000000ffff857224ULL, 0x000fe200078e008bULL, 0x00000018ff2a7819ULL, 0x000fca000001142aULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b6e0000001820ULL,
0x0000541084287816ULL, 0x028fe20000000081ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541083297816ULL, 0x000fc40000000080ULL, 0x000088802b807816ULL, 0x000fca00000000ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x000054107d287816ULL, 0x022fe2000000007eULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000054107c297816ULL, 0x004fe2000000007fULL, 0x000001002b7c7824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e0080ULL, 0x000054107b297816ULL, 0x008fcc0000000076ULL,
0x0000008a00667306ULL, 0x000eb00000200c00ULL, 0x00000028007d7306ULL, 0x0007f00000200c00ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000054107a287816ULL, 0x008fce0000000077ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541079287816ULL, 0x022fe40000000078ULL,
0x0000541089297816ULL, 0x004fc40000000066ULL, 0x0000000170667810ULL, 0x000fc60007ffe0ffULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000666800720cULL, 0x080fe20005746470ULL,
0x000000282434723cULL, 0x000b620000001834ULL, 0x000000666500720cULL, 0x000fca0004f26470ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541082287816ULL, 0x030fe40000000075ULL,
0x0000541067297816ULL, 0x008fca0000000074ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541085287816ULL, 0x022fe40000000086ULL, 0x000054107d297816ULL, 0x004fca000000007cULL,
0x0000002a002a7306ULL, 0x000e640000200c00ULL, 0x00000028243c723cULL, 0x000b6c000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe40000000073ULL,
0x000054102b297816ULL, 0x004fce0000000072ULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000200f0f7221ULL, 0x000fe20000010000ULL, 0x000000210c0c7221ULL, 0x000fe20000010000ULL,
0x000000440b0b7221ULL, 0x000fe20000010000ULL, 0x0000004508087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220d0d7221ULL, 0x000fe20000010000ULL,
0x000000230a0a7221ULL, 0x000fe20000010000ULL, 0x0000004609097221ULL, 0x000fe20000010000ULL,
0x0000004706067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff297224ULL, 0x020fe200078e00ffULL,
0x000000135e00720cULL, 0x000fc40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366227812ULL, 0x000fe400078ec0ffULL, 0x0000000323247810ULL, 0x000fe40007ffe0ffULL,
0x000000135e00720cULL, 0x000fe40003f03070ULL, 0x00000040ff2a7803ULL, 0x000fe40000000000ULL,
0x000000ff22227207ULL, 0x000fe20006800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0021ULL,
0x0000000324207812ULL, 0x000fc400078ec0ffULL, 0x0000001324217211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4871ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000121257810ULL, 0x040fe20007ffe0ffULL,
0x0000000421237824ULL, 0x000fe200078e0220ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000602500720cULL, 0x000fe20003fc6070ULL, 0x0000004023287824ULL, 0x000fca00078e00ffULL,
0x000000405b237812ULL, 0x000fce00078ef828ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002c277984ULL, 0x000e620000004800ULL, 0x000000012c257824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe400078ec0ffULL, 0x000000285f267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a28ULL,
0x000000102c287824ULL, 0x000fe400078e00ffULL, 0x000000012e307824ULL, 0x100fe200078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027247984ULL, 0x0022a40000004800ULL,
0x000000012c277824ULL, 0x002fca00078e0203ULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x8000000526287c10ULL, 0x000fe4000fffe0ffULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000012e277824ULL, 0x000fe400078e0223ULL, 0x0000002415247224ULL, 0x004fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000281d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a08002c297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029267984ULL, 0x004e640000004800ULL, 0x0000002615267224ULL, 0x002fc800078e0227ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000041d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e257824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002c297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029247984ULL, 0x004e640000004800ULL, 0x0000002415247224ULL, 0x002fc800078e0225ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a18002c297984ULL, 0x000ea80000004800ULL,
0x010ac00029267984ULL, 0x004ea40000004800ULL, 0x0000002615267224ULL, 0x004fc400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002d26267210ULL, 0x000fc80007fde0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0x0000c00023237811ULL, 0x000fd600078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL, 0x010a00002c287984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe400078e0223ULL, 0x000000f0262b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x010ac00028287984ULL, 0x002e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24267210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102c257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x000000102e2e7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL, 0x010a08002c287984ULL, 0x000ea20000004800ULL,
0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL,
0x000000012e267824ULL, 0x042fe400078e0223ULL, 0x000000012e2d7824ULL, 0x040fe400078e0203ULL,
0x000000102e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL,
0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00028287984ULL, 0x004e640000004800ULL,
0x0000002815247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fca00030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002c287984ULL, 0x000ea80000004800ULL, 0x010ac00028287984ULL, 0x004ea40000004800ULL,
0x0000002815267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e0029ULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e8000b901c50ULL,
0x010a18002c287984ULL, 0x000ee80000004800ULL, 0x010ac00028287984ULL, 0x008ee40000004800ULL,
0x0000002815237224ULL, 0x008fc800078e0223ULL, 0x00005e0023247625ULL, 0x002fc800078e0029ULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000002b24247210ULL, 0x000fe20007fde0ffULL,
0x000000102e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0xfffffff02e237812ULL, 0x000fc800078ee223ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0005e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x006e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000215e00720cULL, 0x000fc80003fc4070ULL,
0x000000ff22237207ULL, 0x040fe40003000000ULL, 0x000000ff22247207ULL, 0x000fc60007000000ULL,
0x0000000120207824ULL, 0x000fe200078e0223ULL, 0x00010a0016237811ULL, 0x000fc600078e10ffULL,
0x0000004020227824ULL, 0x040fe200078e00ffULL, 0x0000002120207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a24217c10ULL, 0x000fe2000fffe0ffULL, 0x00000004ff247424ULL, 0x000fc600078e00ffULL,
0x0000002020207810ULL, 0x000fca0007ffe0ffULL, 0x0000000116227824ULL, 0x100fe400078e0220ULL,
0x0000680021217a24ULL, 0x000fc600078e0220ULL, 0x0000005f2200720cULL, 0x000fe20003fc6070ULL,
0x0000000116217824ULL, 0x000fc800078e0221ULL, 0x0000660021207625ULL, 0x000fd000078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff667f8cULL, 0x000e62000c80043fULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000088127f007947ULL, 0x000fea000b800000ULL, 0x00001f68221b7589ULL, 0x0004e400000e0000ULL,
0x000088527f007947ULL, 0x000fea000b800000ULL, 0x00001f65221a7589ULL, 0x0004e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001068277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000165b000207802ULL, 0x000fc40000000f00ULL,
0x00008da000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001868277810ULL, 0x002fe40007ffe0ffULL,
0x0001660000207802ULL, 0x000fc40000000f00ULL, 0x00008d5000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006b24783bULL, 0x006e620000004200ULL, 0x000000ff2a00720cULL, 0x000fe20003fc5270ULL,
0x00000f4000017945ULL, 0x000fe20003800000ULL, 0x0000b8006d407811ULL, 0x000fe200078e20ffULL,
0x000000006a28783bULL, 0x000ea80000004200ULL, 0x000000006920783bULL, 0x000fe80000004200ULL,
0x000000006c34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000100242e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x00000100252f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe20000011424ULL,
0x0000010028327824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002a337824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011428ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x00008880288b7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011429ULL,
0x0000888029867816ULL, 0x040fe400000000ffULL, 0x00000018ff847819ULL, 0x000fe20000011428ULL,
0x0000002e003d7306ULL, 0x0003e20000200c00ULL, 0x0000010026287824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011433ULL, 0x0000001b4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000001b4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fe20000011420ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x0000888020787816ULL, 0x000fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011425ULL, 0x0000003200887306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe20000011429ULL, 0x0000010027297824ULL, 0x000fe200078e00ffULL,
0x0000888025457816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002e00897306ULL, 0x0005e20000200c00ULL,
0x0000888027327816ULL, 0x042fe200000000ffULL, 0x0000001a4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d002d7306ULL, 0x000fe20000200c00ULL, 0x00008880262e7816ULL, 0x044fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00008880343e7816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff877819ULL, 0x000fe20000011436ULL, 0x0000002600337306ULL, 0x0002a20000200c00ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff827819ULL, 0x000fe40000011437ULL,
0x00008880378d7816ULL, 0x000fc400000000ffULL, 0x00000018ff397819ULL, 0x000fe20000011435ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x0000010020267824ULL, 0x042fe200078e00ffULL,
0x00008880358c7816ULL, 0x000fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011421ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff747819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x00000029003f7306ULL, 0x000fe20000200c00ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888021777816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff767819ULL, 0x000fe4000001142aULL, 0x00000018ff757819ULL, 0x000fe4000001142bULL,
0x000088802a7f7816ULL, 0x040fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000088802b7c7816ULL, 0x000fe200000000ffULL, 0x0000002f00467306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x004fc40000000030ULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x00000018ff717819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011423ULL,
0x00000028002f7306ULL, 0x0005e20000200c00ULL, 0x0000541044447816ULL, 0x002fce000000003dULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x044fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x00000018ff2b7819ULL, 0x000fce000001142bULL,
0x0000003100317306ULL, 0x000ff00000200c00ULL, 0x00000027008a7306ULL, 0x0004e20000200c00ULL,
0x0000541025297816ULL, 0x002fce000000002cULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0001000035277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002000837306ULL, 0x0002a20000200c00ULL, 0x000054108a317816ULL, 0x008fce0000000031ULL,
0x0000002600797306ULL, 0x0007e20000200c00ULL, 0x0000010036207824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011420ULL,
0x00000028007d7306ULL, 0x0003e20000200c00ULL, 0x0000010035267824ULL, 0x008fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc80000011436ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000027003a7306ULL, 0x000fe20000200c00ULL, 0x0000541024287816ULL, 0x002fe4000000002dULL,
0x0000b8006e247811ULL, 0x000fe400078e20ffULL, 0x00005410322d7816ULL, 0x000fe2000000003fULL,
0x0000010037327824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000002600357306ULL, 0x0003e40000200c00ULL, 0x00000018ff8a7819ULL, 0x000fc40000011432ULL,
0x000000304030723cULL, 0x000fe800000018ffULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x00000034003b7306ULL, 0x0005f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103e347816ULL, 0x004fe20000000083ULL,
0x00000100213e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011437ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000541045457816ULL, 0x008fc60000000046ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff217819ULL, 0x000fc60000011421ULL,
0x000000444044723cULL, 0x000f6800000018ffULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x000054103c3c7816ULL, 0x004fe2000000003dULL,
0x0000001b2424b232ULL, 0x002fc40000000000ULL, 0x0000001b2626b232ULL, 0x000fe40000000000ULL,
0x0000001a2525b232ULL, 0x080fe40000000000ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x0000001a2727b232ULL, 0x000fcc0000000000ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000054103a397816ULL, 0x010fce0000000039ULL,
0x0000008d003f7306ULL, 0x000fe20000200c00ULL, 0x000054102e2c7816ULL, 0x002fe2000000002fULL,
0x000000384038723cULL, 0x040fec00000018ffULL, 0x0000008a008e7306ULL, 0x000e620000200c00ULL,
0x000054108c357816ULL, 0x004fe20000000035ULL, 0x0000002c402c723cULL, 0x000fe200000018ffULL,
0x00000018ff8c7819ULL, 0x000fca000001143eULL, 0x0000008700877306ULL, 0x000fe40000200c00ULL,
0x000000344034723cULL, 0x000fec00000018ffULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x000054103f3d7816ULL, 0x002fe4000000008eULL, 0x00008880228e7816ULL, 0x000fca00000000ffULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0000003c403c723cULL, 0x000fee00000018ffULL,
0x00000083008d7306ULL, 0x000eb00000200c00ULL, 0x0000002100837306ULL, 0x0005e20000200c00ULL,
0x0000541020207816ULL, 0x002fce0000000087ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000054108d217816ULL, 0x004fe20000000082ULL, 0x000000ffff827224ULL, 0x000fcc00078e008eULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002a007b7306ULL, 0x000ff00000200c00ULL,
0x0000002b007a7306ULL, 0x0005f00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x0000541086217816ULL, 0x002fe20000000089ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888023867816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002000877306ULL, 0x0007f00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108b207816ULL, 0x008fce0000000088ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x000000202444723cULL, 0x000b6e0000001844ULL,
0x0000007c007c7306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x024fe40000000081ULL,
0x0000541085217816ULL, 0x002fe20000000080ULL, 0x0000010023807824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fe400078e00ffULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff237819ULL, 0x000fca0000011423ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000000ffff217224ULL, 0x020fe200078e0086ULL, 0x000054107f207816ULL, 0x008fcc000000007eULL,
0x0000002100817306ULL, 0x0009f00000200c00ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x000054107c217816ULL, 0x010fce000000007dULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000008c008a7306ULL, 0x000f220000200c00ULL,
0x000054107b207816ULL, 0x022fe40000000076ULL, 0x000054107a217816ULL, 0x004fca0000000075ULL,
0x0000007300737306ULL, 0x000fe40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541078207816ULL, 0x028fe40000000079ULL,
0x0000541077217816ULL, 0x010fca000000008aULL, 0x0000007400747306ULL, 0x000ea40000200c00ULL,
0x000000202434723cULL, 0x000b6c0000001834ULL, 0x0000008200827306ULL, 0x000ee20000200c00ULL,
0x0000541083217816ULL, 0x022fce0000000072ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541074207816ULL, 0x004fce0000000073ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000202438723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541082207816ULL, 0x028fe40000000087ULL, 0x0000541081217816ULL, 0x002fca0000000080ULL,
0x0000002200227306ULL, 0x000e640000200c00ULL, 0x00000020243c723cULL, 0x000b6c000000183cULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541022207816ULL, 0x022fe40000000071ULL,
0x0000541023217816ULL, 0x004fce0000000066ULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000440f0f7221ULL, 0x000fe20000010000ULL, 0x000000450c0c7221ULL, 0x000fe20000010000ULL,
0x000000280b0b7221ULL, 0x000fe20000010000ULL, 0x0000002908087221ULL, 0x000fe20000010000ULL,
0x0000002c07077221ULL, 0x000fe20000010000ULL, 0x0000002d04047221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000314a4a7221ULL, 0x000fe20000010000ULL,
0x000000344b4b7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x000000384f4f7221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c53537221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x0000004057577221ULL, 0x020fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000460d0d7221ULL, 0x000fe20000010000ULL,
0x000000470a0a7221ULL, 0x000fe20000010000ULL, 0x0000002a09097221ULL, 0x000fe20000010000ULL,
0x0000002b06067221ULL, 0x000fe20000010000ULL, 0x0000002e05057221ULL, 0x000fe20000010000ULL,
0x0000002f48487221ULL, 0x000fe20000010000ULL, 0x0000003249497221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x000000364d4d7221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a51517221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e55557221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x0000004259597221ULL, 0x020fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006f7000720cULL, 0x000fe20003f06070ULL, 0x010b8800ff227f8cULL, 0x000e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaac000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL,
0x0000000113137810ULL, 0x000fc80007ffe0ffULL, 0x000000601300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xfffea4a000007947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6000720cULL, 0x000fe20003f05270ULL,
0x000000ffff157224ULL, 0x000fe400078e0005ULL, 0x000000ffff057224ULL, 0x000fe400078e0004ULL,
0x000000ffff127224ULL, 0x000fe400078e0006ULL, 0x000000ffff137224ULL, 0x000fcc00078e0009ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x018000000e027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000178e000067802ULL, 0x000fc40000000f00ULL, 0x000078a000007944ULL, 0x022fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000e00037308ULL, 0x000ea40000001000ULL,
0xbf80000003027423ULL, 0x004fc8000000000eULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203047223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000001002037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000067919ULL, 0x000ee40000000000ULL,
0x00000002ff277819ULL, 0x028fe20000011606ULL, 0x0000000403047220ULL, 0x004fe20000410000ULL,
0x000074527f007947ULL, 0x000fea000b800000ULL, 0x00001f2704027589ULL, 0x0004e400000e0000ULL,
0x0000000000037919ULL, 0x000f220000000000ULL, 0x0000000f020f7220ULL, 0x048fe20000410000ULL,
0x0000000c020c7220ULL, 0x040fe20000410000ULL, 0x0000000b020b7220ULL, 0x040fe20000410000ULL,
0x0000000802087220ULL, 0x040fe20000410000ULL, 0x0000000702077220ULL, 0x040fe20000410000ULL,
0x0000000502057220ULL, 0x040fe20000410000ULL, 0x0000001f021f7220ULL, 0x040fe20000410000ULL,
0x0000004a024a7220ULL, 0x040fe20000410000ULL, 0x0000004b024b7220ULL, 0x040fe20000410000ULL,
0x0000004e024e7220ULL, 0x040fe20000410000ULL, 0x0000004f024f7220ULL, 0x040fe20000410000ULL,
0x0000005202527220ULL, 0x040fe20000410000ULL, 0x0000005302537220ULL, 0x040fe20000410000ULL,
0x0000005602567220ULL, 0x040fe20000410000ULL, 0x0000005702577220ULL, 0x040fe20000410000ULL,
0x0000005a025a7220ULL, 0x000fe20000410000ULL, 0x0000000803277811ULL, 0x016fe200078ff0ffULL,
0x000073627f007947ULL, 0x000fea000b800000ULL, 0x00001f2704027589ULL, 0x0002a400000e0000ULL,
0x0000000d020d7220ULL, 0x044fe20000410000ULL, 0x0000000a020a7220ULL, 0x040fe20000410000ULL,
0x0000001302137220ULL, 0x040fe20000410000ULL, 0x0000001202127220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000004802487220ULL, 0x040fe20000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000004c024c7220ULL, 0x040fe20000410000ULL,
0x0000004d024d7220ULL, 0x040fe20000410000ULL, 0x0000005002507220ULL, 0x040fe20000410000ULL,
0x0000005102517220ULL, 0x040fe20000410000ULL, 0x0000005402547220ULL, 0x040fe20000410000ULL,
0x0000005502557220ULL, 0x040fe20000410000ULL, 0x0000005802587220ULL, 0x040fe20000410000ULL,
0x0000005902597220ULL, 0x040fe20000410000ULL, 0x0000005c025c7220ULL, 0x000fc20000410000ULL,
0x00000000001d7919ULL, 0x000ea20000002600ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000f0c02723eULL, 0x000fc400000000ffULL, 0x0000000b0803723eULL, 0x000fe400000000ffULL,
0x000000070504723eULL, 0x002fe400000000ffULL, 0x0000000d0a0a723eULL, 0x000fe400000000ffULL,
0x0000001f4a05723eULL, 0x000fe400000000ffULL, 0x0000004b4e06723eULL, 0x000fe400000000ffULL,
0x0000004f5207723eULL, 0x000fc400000000ffULL, 0x000000535608723eULL, 0x000fe400000000ffULL,
0x000000575a09723eULL, 0x000fe400000000ffULL, 0x00000013120b723eULL, 0x000fe400000000ffULL,
0x00000015480c723eULL, 0x000fe400000000ffULL, 0x000000494c0d723eULL, 0x000fe400000000ffULL,
0x0000004d500e723eULL, 0x000fc400000000ffULL, 0x00000051540f723eULL, 0x000fe400000000ffULL,
0x000000555810723eULL, 0x000fe400000000ffULL, 0x000000595c11723eULL, 0x000fc400000000ffULL,
0x0000000000157919ULL, 0x004e620000000000ULL, 0x0000a00008087891ULL, 0x000fe2000f8e583fULL,
0x00005410021a7816ULL, 0x000fe40000000003ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000815137811ULL, 0x002fc400078ff0ffULL, 0x0000000215127812ULL, 0x000fc600078ec0ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000001312147211ULL, 0x040fe200078ff8ffULL,
0x0000000815137824ULL, 0x000fe200078e00ffULL, 0x00000002ff157819ULL, 0x000fe40000011615ULL,
0xfffffff817177812ULL, 0x000fe400078ee214ULL, 0x0000000813147812ULL, 0x000fe200078ec0ffULL,
0x0000000815137824ULL, 0x040fe200078e00ffULL, 0x0000001512127211ULL, 0x000fe200078ff8ffULL,
0x0000000815187824ULL, 0x000fc400078e00ffULL, 0x0000000815197824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee212ULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000000212157810ULL, 0x040fe40007ffe0ffULL, 0x0000000412167810ULL, 0x040fe40007ffe0ffULL,
0x0000000612127810ULL, 0x000fe40007ffe0ffULL, 0x0000000813137c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff818157812ULL, 0x000fc400078ee215ULL, 0xfffffff819167812ULL, 0x000fe200078ee216ULL,
0x0000000113137824ULL, 0x000fe200078e0214ULL, 0xfffffff81b127812ULL, 0x000fe400078ee212ULL,
0x00007632021b7816ULL, 0x000fe40000000003ULL, 0x0000000815157c11ULL, 0x000fe4000f8e20ffULL,
0x0000000816037c11ULL, 0x000fe2000f8e20ffULL, 0x0000001a13007388ULL, 0x0003e20000000a00ULL,
0x0000000817197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114157824ULL, 0x000fe200078e0215ULL,
0x0000000812177c11ULL, 0x000fe2000f8e20ffULL, 0x0000000114037824ULL, 0x000fe200078e0203ULL,
0x0000541004127816ULL, 0x000fe20000000005ULL, 0x0000000114197824ULL, 0x000fc400078e0219ULL,
0x0000000114177824ULL, 0x000fe200078e0217ULL, 0x0000763204137816ULL, 0x002fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x0000001215007388ULL, 0x000fe20000000a00ULL, 0x000054100a067816ULL, 0x140fe4000000000bULL,
0x000076320a077816ULL, 0x000fe2000000000bULL, 0x0000000403007388ULL, 0x0003e40000000a00ULL,
0x0000541008047816ULL, 0x002fc40000000009ULL, 0x0000763208057816ULL, 0x000fca0000000009ULL,
0x0000000417007388ULL, 0x0003e80000000a00ULL, 0x0000000619007388ULL, 0x0005e20000000a00ULL,
0x000054100c047816ULL, 0x142fe4000000000dULL, 0x000076320c057816ULL, 0x000fe4000000000dULL,
0x000054100e067816ULL, 0x144fe4000000000fULL, 0x000076320e077816ULL, 0x000fe2000000000fULL,
0x0004000415007388ULL, 0x0003e80000000a00ULL, 0x0004000603007388ULL, 0x0005e20000000a00ULL,
0x0000541010047816ULL, 0x002fc40000000011ULL, 0x0000763210057816ULL, 0x000fca0000000011ULL,
0x0004000417007388ULL, 0x0005e20000000a00ULL, 0x0000002000007947ULL, 0x000fea0003800000ULL,
0x000180e000207802ULL, 0x020fc40000000f00ULL, 0x0000732000007944ULL, 0x004fea0003c00000ULL,
0x0000000000097919ULL, 0x000e620000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL,
0x00000004130472a4ULL, 0x000fcc000f8e023fULL, 0x00000004ff037e24ULL, 0x004fe2000f8e00ffULL,
0x00000003ff007819ULL, 0x002fca0000011609ULL, 0x0000000100027824ULL, 0x040fe400078e0209ULL,
0x0000580000007a24ULL, 0x000fc600078e021dULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000003007211ULL, 0x000fe400078010ffULL, 0x0ffffff802047812ULL, 0x000fe400078ef809ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe400078048ffULL, 0x0000000804047984ULL, 0x000e62000800cc00ULL,
0x1ffffff809097812ULL, 0x000fc400078ef808ULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x0000001009027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d10ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000608057899ULL, 0x000fe2000800063fULL,
0x000000200d037810ULL, 0x000fca0007ffe0ffULL, 0x000000050d027c10ULL, 0x000fe2000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000680000047ab9ULL, 0x000fe20000000800ULL,
0x0000000503047c10ULL, 0x000fe2000fffe0ffULL, 0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL,
0x0000005f0200720cULL, 0x080fe20003f06070ULL, 0x0000000808067899ULL, 0x000fe2000800063fULL,
0x0000005f0400720cULL, 0x000fe20003f26070ULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x010ad000ff087f8cULL, 0x000e62000c80043fULL, 0x000000040d027c10ULL, 0x000fe2000fffe0ffULL,
0x000001a000007945ULL, 0x000fe20003800000ULL, 0x0000000403047c10ULL, 0x000fe2000fffe0ffULL,
0x000000013f047899ULL, 0x000fe20008011608ULL, 0x000000060d0b7c11ULL, 0x040fe2000f8e10ffULL,
0x0000660002027625ULL, 0x000fe200078e000fULL, 0x000000030d00780cULL, 0x000fc60003f44070ULL,
0x0000660004047625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x10600000020b7faeULL, 0x0005e6000c121850ULL, 0x00000004ff547e24ULL, 0x000fe2000f8e00ffULL,
0x10680000040b7faeULL, 0x0005e2000c921850ULL, 0x00006e00ff067624ULL, 0x000fe400078e00ffULL,
0x00006f00ff077624ULL, 0x000fe400078e00ffULL, 0x000000a000002947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x004ea20000002700ULL, 0x0000005d5400720cULL, 0x000fe20003f06070ULL,
0x0000000402037824ULL, 0x004fc400078e020dULL, 0x00000008ff027e24ULL, 0x000fe4000f8e00ffULL,
0x0000000203037824ULL, 0x000fe400078e00ffULL, 0x0000000402057824ULL, 0x000fe400078e020dULL,
0x0000640003037a24ULL, 0x000fc600078e0254ULL, 0x00010a8005057811ULL, 0x000fe200078e10ffULL,
0x0000600003027625ULL, 0x000fca00078e000fULL, 0x0000000002057faeULL, 0x0005e4000c121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x000000070d0d7899ULL, 0x000fe2000800063fULL, 0x0000001006027981ULL, 0x004528000c1e9900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x000000400d077892ULL, 0x000fe4000f8ef805ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x000000ffff037224ULL, 0x002fe200078e0009ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000008a000000947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x004e620000000000ULL, 0x00010a8008097891ULL, 0x000fe2000f8e203fULL,
0x000000055f047c17ULL, 0x000fe2000f800000ULL, 0x00000100ff0e7424ULL, 0x000fe200078e00ffULL,
0x00002000080b7891ULL, 0x000fe4000f8e683fULL, 0x80000005040a7c10ULL, 0x000fe4000fffe0ffULL,
0x00000002ff117819ULL, 0x002fe20000011608ULL, 0x00000010080f7824ULL, 0x000fc600078e00ffULL,
0x0000000711067c10ULL, 0x000fe2000fffe0ffULL, 0x0106000611077984ULL, 0x000e620008004800ULL,
0x000000300f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000a1100720cULL, 0x040fe40003f06070ULL,
0x0000000811097810ULL, 0x000fca0007ffe0ffULL, 0x0000000409107824ULL, 0x000fe200078e00ffULL,
0x0000000907077984ULL, 0x002e640008004800ULL, 0x0000000407057c24ULL, 0x002fe2000f8e0206ULL,
0x0000000808067211ULL, 0x000fc600078fe8ffULL, 0x00005e0005047625ULL, 0x000fe200078e000eULL,
0x00000003060b7812ULL, 0x000fc800078ec0ffULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0x0ffffffc0b047812ULL, 0x000fc600078ef808ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000709057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0900720cULL, 0x000fc60003f06070ULL, 0x01062006110c7984ULL, 0x000ea20008004800ULL,
0x0000001011077810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fe200078ee20bULL,
0x0000000407107824ULL, 0x040fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000707057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0700720cULL, 0x000fc60003f06070ULL, 0x01064006110c7984ULL, 0x000ea20008004800ULL,
0x0000001811097810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fe200078ee20bULL,
0x0000000409107824ULL, 0x040fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000709057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0900720cULL, 0x000fc60003f06070ULL, 0x01066006110c7984ULL, 0x000ea20008004800ULL,
0x0000002011077810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fe200078ee20bULL,
0x0000000407107824ULL, 0x040fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000707057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0700720cULL, 0x000fc60003f06070ULL, 0x01068006110c7984ULL, 0x000ea20008004800ULL,
0x0000002811097810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fe200078ee20bULL,
0x0000000409107824ULL, 0x040fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000709057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0900720cULL, 0x000fc60003f06070ULL, 0x0106a006110c7984ULL, 0x000ea20008004800ULL,
0x0000003011077810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04087210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fe200078ee20bULL,
0x0000000407107824ULL, 0x040fe400078e00ffULL, 0x000000ffff097224ULL, 0x000fe200008e0605ULL,
0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL, 0x0000000707057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e2000c101c50ULL,
0x0000000a0700720cULL, 0x000fc60003f06070ULL, 0x0106c006110c7984ULL, 0x000ea20008004800ULL,
0x00000038110d7810ULL, 0x002fc60007ffe0ffULL, 0x000000090c0c7984ULL, 0x004e640008004800ULL,
0x000000040c057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04067210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc10047812ULL, 0x000fc600078ee20bULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000b04097c11ULL, 0x000fe4000f8e20ffULL,
0x000000070d057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c50ULL, 0x0000000a0d00720cULL, 0x040fe20003f06070ULL,
0x000000040d0a7824ULL, 0x000fe400078e00ffULL, 0x0106e00611087984ULL, 0x000ea60008004800ULL,
0xfffffffc0a0b7812ULL, 0x000fc800078ee20bULL, 0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000908087984ULL, 0x004ea40008004800ULL, 0x0000000408057c24ULL, 0x004fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000c101c50ULL, 0x000007f000007947ULL, 0x000fea0003800000ULL,
0x0000000000077919ULL, 0x004e620000000000ULL, 0x00010a8008097891ULL, 0x000fe2000f8e203fULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe2000f8e683fULL,
0x00000002ff0b7819ULL, 0x002fe20000011607ULL, 0x0000001007097824ULL, 0x040fe200078e00ffULL,
0x0000000707067211ULL, 0x000fe400078fe8ffULL, 0x000000070b057c10ULL, 0x000fe2000fffe0ffULL,
0x010600060b087984ULL, 0x000e620008004800ULL, 0x00000030090f7812ULL, 0x000fc400078ec0ffULL,
0x00000003060c7812ULL, 0x000fe200078ec0ffULL, 0x0000000908087984ULL, 0x002e640008004800ULL,
0x0000000408047c24ULL, 0x002fe2000f8e0205ULL, 0x000000080b087810ULL, 0x000fc60007ffe0ffULL,
0x00005e0004047625ULL, 0x000fc800078e000dULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000f04067210ULL, 0x000fe40007f1e0ffULL, 0x0ffffffc0c047812ULL, 0x000fc600078ef807ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000708057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c50ULL, 0x010620060b0a7984ULL, 0x000ea20008004800ULL,
0x000000100b067810ULL, 0x002fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe200078e00ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000706057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x010640060b0a7984ULL, 0x000ea20008004800ULL, 0x000000180b087810ULL, 0x002fca0007ffe0ffULL,
0x0000000408097824ULL, 0x000fe200078e00ffULL, 0x000000090a0a7984ULL, 0x004e640008004800ULL,
0x000000040a047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04067210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc07047812ULL, 0x000fc600078ee20cULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000708057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c50ULL, 0x010660060b0a7984ULL, 0x000ea20008004800ULL,
0x000000200b067810ULL, 0x002fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe200078e00ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000706057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x010680060b0a7984ULL, 0x000ea20008004800ULL, 0x000000280b087810ULL, 0x002fca0007ffe0ffULL,
0x0000000408097824ULL, 0x000fe200078e00ffULL, 0x000000090a0a7984ULL, 0x004e640008004800ULL,
0x000000040a047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04067210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc07047812ULL, 0x000fc600078ee20cULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000708057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c50ULL, 0x0106a0060b0a7984ULL, 0x000ea20008004800ULL,
0x000000300b067810ULL, 0x002fca0007ffe0ffULL, 0x0000000406077824ULL, 0x000fe200078e00ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04087210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc09047812ULL, 0x000fc600078ee20cULL, 0x000000ffff097224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000706057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e8000b901c50ULL,
0x0106c0060b0a7984ULL, 0x000ea80008004800ULL, 0x000000090a0a7984ULL, 0x004ea40008004800ULL,
0x000000040a047c24ULL, 0x004fe2000f8e0205ULL, 0x000000380b0a7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc07047812ULL, 0x000fc600078ee20cULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000000b04097c11ULL, 0x002fe4000f8e20ffULL, 0x000000070a057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c50ULL,
0x0106e0060b087984ULL, 0x000ea80008004800ULL, 0x0000000908087984ULL, 0x004ea40008004800ULL,
0x0000000408047c24ULL, 0x004fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fc800078e000dULL,
0x000000040a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000f04047210ULL, 0x000fc80007f1e0ffULL,
0xfffffffc0d0c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff057224ULL, 0x000fc600000e0605ULL,
0x0000000b0c077c11ULL, 0x002fca000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c50ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x010ad400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000008ff047e24ULL, 0x000fc8000f8e00ffULL,
0x0000002004037824ULL, 0x002fca00078e0203ULL, 0x00000003ff057819ULL, 0x000fe40000011603ULL,
0x0000000f03037812ULL, 0x000fe400078ec0ffULL, 0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x0000002003097824ULL, 0x040fe400078e00ffULL,
0x0000000103077824ULL, 0x040fe400078e0206ULL, 0x0000000106087824ULL, 0x040fe200078e0205ULL,
0x0000001006067810ULL, 0x000fe20007ffe0ffULL, 0x00000020030a7824ULL, 0x000fe200078e00ffULL,
0x0000001f07077812ULL, 0x000fc400078ec0ffULL, 0x0000001f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x000fe200078e0206ULL, 0x000001e00a077812ULL, 0x040fe400078ee207ULL,
0x000001e009087812ULL, 0x000fe200078ee208ULL, 0x0000000103097824ULL, 0x000fe200078e0206ULL,
0x0000001f05057812ULL, 0x000fe200078ec0ffULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000002003067824ULL, 0x000fe400078e00ffULL, 0x0000001f09097812ULL, 0x000fe200078ec0ffULL,
0x00000000080c7984ULL, 0x000ea2000000cc00ULL, 0x000001e00a057812ULL, 0x000fc400078ee205ULL,
0x000001e006097812ULL, 0x000fe200078ee209ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fc400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x0000001808007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000009107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c09007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010ad000ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff057224ULL, 0x002fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x004fc400078e0007ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x010ad400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000105057810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010ad400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6000720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00005800ff067624ULL, 0x000fe200078e00ffULL,
0x3d80000002027820ULL, 0x010fe20000410000ULL, 0x00010b5804527811ULL, 0x000fe200078e18ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0xffffffff60507810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x00010ad804057811ULL, 0x000fe200078e28ffULL,
0x0000008006067824ULL, 0x000fc400078e00ffULL, 0x00000005075a7c11ULL, 0x000fe2000f8e40ffULL,
0x0000000000007946ULL, 0x000fe60003800000ULL, 0x0000005a5f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000004ff5c7424ULL, 0x000fe200078e00ffULL,
0x000000075e00720cULL, 0x000fe20003f44070ULL, 0x000000ffff577224ULL, 0x000fc600078e00ffULL,
0x000000015c5c7807ULL, 0x000fc40005000000ULL, 0x000000ffff197224ULL, 0x000fe200078e0009ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff597224ULL, 0x000fe200078e0057ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5b7224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x0001a0a000207802ULL, 0x000fc40000000f00ULL, 0x0000536000007944ULL, 0x002fea0003c00000ULL,
0x000000015b647810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000005764187211ULL, 0x040fe200078ff0ffULL, 0x0000106000007945ULL, 0x000fe20003800000ULL,
0x0000000364617812ULL, 0x000fe400078ec0ffULL, 0x00000003181a7812ULL, 0x000fe400078ec0ffULL,
0x00000002ff18a819ULL, 0x000fca0000011618ULL, 0x00000001181b7824ULL, 0x000fe200078e0207ULL,
0x000000ff1a187207ULL, 0x000fc80005000000ULL, 0x000000011b097810ULL, 0x040fe40007ffe0ffULL,
0x000000051b257c11ULL, 0x000fe4000f8e40ffULL, 0x000000600900720cULL, 0x000fe40003f06070ULL,
0x0000004025207812ULL, 0x000fe400078ec0ffULL, 0x0000000119097812ULL, 0x000fe400078e0cffULL,
0x0000000d201a7c10ULL, 0x000fce000fffe0ffULL, 0x0000082000008947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x002fe20000011603ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x000000255f247217ULL, 0x000fe20007800000ULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x0000000303267211ULL, 0x000fe200078fe8ffULL, 0x0106000621227984ULL, 0x000e620008004800ULL,
0x0000000121207824ULL, 0x040fe200078e021aULL, 0x0000000821677810ULL, 0x000fe20007ffe0ffULL,
0x0000000124247824ULL, 0x000fe200078e0a25ULL, 0x0000000326267812ULL, 0x000fe200078ec0ffULL,
0x0000000204257824ULL, 0x000fc400078e0209ULL, 0x0000000461667824ULL, 0x000fe200078e00ffULL,
0x000000242100720cULL, 0x000fe20003f06070ULL, 0x0000000467697824ULL, 0x000fe200078e00ffULL,
0x0000200025257811ULL, 0x000fc800078e60ffULL, 0xfffffffc69687812ULL, 0x000fe200078ee226ULL,
0x0000000422237984ULL, 0x002e640008004800ULL, 0x0000002306627224ULL, 0x002fe200078e0220ULL,
0xfffffffc66207812ULL, 0x000fc600078ee203ULL, 0x00005e0062227625ULL, 0x000fe200078e0027ULL,
0x0ffffffc26627812ULL, 0x000fca00078ef803ULL, 0x0000001062657824ULL, 0x000fe400078e0225ULL,
0x0000001020627825ULL, 0x000fc800078e0022ULL, 0x0000000167227824ULL, 0x040fe200078e021aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062657faeULL, 0x0003e2000c101c50ULL,
0x000000246700720cULL, 0x000fe20003f06070ULL, 0x0000001068677824ULL, 0x000fe400078e0225ULL,
0x0106200621667984ULL, 0x000ea80008004800ULL, 0x0000000466237984ULL, 0x004ea40008004800ULL,
0x0000002306227224ULL, 0x004fc800078e0222ULL, 0x00005e0022227625ULL, 0x000fcc00078e0027ULL,
0x0000001020627825ULL, 0x002fe200078e0022ULL, 0x0000001021237810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c50ULL,
0x0000000123227824ULL, 0x040fe200078e021aULL, 0x000000242300720cULL, 0x040fe20003f06070ULL,
0x0000000423697824ULL, 0x000fe200078e00ffULL, 0x0106400621657984ULL, 0x000ea80008004800ULL,
0xfffffffc69667812ULL, 0x000fca00078ee226ULL, 0x0000001066697824ULL, 0x000fe200078e0225ULL,
0x0000000465657984ULL, 0x004ea40008004800ULL, 0x0000006506227224ULL, 0x004fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e0027ULL, 0x0000001020627825ULL, 0x002fe200078e0022ULL,
0x0000001821237810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e2000c101c50ULL, 0x0000000123227824ULL, 0x040fe200078e021aULL,
0x000000242300720cULL, 0x040fe20003f06070ULL, 0x0000000423677824ULL, 0x000fe200078e00ffULL,
0x0106600621657984ULL, 0x000ea80008004800ULL, 0xfffffffc67667812ULL, 0x000fca00078ee226ULL,
0x0000001066677824ULL, 0x000fe200078e0225ULL, 0x0000000465657984ULL, 0x004ea40008004800ULL,
0x0000006506227224ULL, 0x004fc800078e0222ULL, 0x00005e0022227625ULL, 0x000fcc00078e0027ULL,
0x0000001020627825ULL, 0x002fe200078e0022ULL, 0x0000002021237810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c50ULL,
0x0000000123227824ULL, 0x040fe200078e021aULL, 0x000000242300720cULL, 0x040fe20003f06070ULL,
0x0000000423697824ULL, 0x000fe200078e00ffULL, 0x0106800621657984ULL, 0x000ea80008004800ULL,
0xfffffffc69667812ULL, 0x000fca00078ee226ULL, 0x0000001066697824ULL, 0x000fe200078e0225ULL,
0x0000000465657984ULL, 0x004ea40008004800ULL, 0x0000006506227224ULL, 0x004fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e0027ULL, 0x0000001020627825ULL, 0x002fe200078e0022ULL,
0x0000002821237810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062697faeULL, 0x0003e2000c101c50ULL, 0x0000000123227824ULL, 0x040fe200078e021aULL,
0x000000242300720cULL, 0x040fe20003f06070ULL, 0x0000000423677824ULL, 0x000fe200078e00ffULL,
0x0106a00621657984ULL, 0x000ea80008004800ULL, 0xfffffffc67667812ULL, 0x000fca00078ee226ULL,
0x0000001066677824ULL, 0x000fe200078e0225ULL, 0x0000000465657984ULL, 0x004ea40008004800ULL,
0x0000006506227224ULL, 0x004fc800078e0222ULL, 0x00005e0022227625ULL, 0x000fcc00078e0027ULL,
0x0000001020627825ULL, 0x002fe200078e0022ULL, 0x0000003021237810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062677faeULL, 0x0003e2000c101c50ULL,
0x0000000123227824ULL, 0x040fe200078e021aULL, 0x000000242300720cULL, 0x040fe20003f06070ULL,
0x0000000423697824ULL, 0x000fe200078e00ffULL, 0x0106c00621657984ULL, 0x000ea80008004800ULL,
0xfffffffc69667812ULL, 0x000fe400078ee226ULL, 0x0000003821637810ULL, 0x002fc60007ffe0ffULL,
0x0000001066697824ULL, 0x000fe400078e0225ULL, 0x00000001631a7824ULL, 0x040fe400078e021aULL,
0x0000000463677824ULL, 0x000fca00078e00ffULL, 0xfffffffc67267812ULL, 0x000fca00078ee226ULL,
0x0000001026257824ULL, 0x000fe200078e0225ULL, 0x0000000465657984ULL, 0x004e640008004800ULL,
0x0000006506227224ULL, 0x002fc800078e0222ULL, 0x00005e0022227625ULL, 0x000fcc00078e0027ULL,
0x0000001020227825ULL, 0x000fca00078e0022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022697faeULL, 0x0003e2000c101c50ULL, 0x000000246300720cULL, 0x000fc60003f06070ULL,
0x0106e00621657984ULL, 0x000ea80008004800ULL, 0x0000000465657984ULL, 0x004ea40008004800ULL,
0x00000065061a7224ULL, 0x004fc800078e021aULL, 0x00005e001a627625ULL, 0x000fcc00078e0027ULL,
0x0000001020627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062257faeULL, 0x0003e2000c101c50ULL, 0x0000077000007947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x002fe20000011603ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000303227211ULL, 0x000fe200078fe8ffULL, 0x0000000461267824ULL, 0x000fe200078e00ffULL,
0x0000000821677810ULL, 0x040fe20007ffe0ffULL, 0x0106000621257984ULL, 0x000e620008004800ULL,
0x0000000121277824ULL, 0x000fe200078e021aULL, 0x0000000322227812ULL, 0x000fe200078ec0ffULL,
0x0000000204247824ULL, 0x000fe200078e0209ULL, 0xfffffffc26237812ULL, 0x000fe200078ee203ULL,
0x00000100ff207424ULL, 0x000fc600078e00ffULL, 0x0000200024247811ULL, 0x000fe200078e60ffULL,
0x0000000425257984ULL, 0x002e640008004800ULL, 0x0000002506277224ULL, 0x002fe200078e0227ULL,
0x0ffffffc22257812ULL, 0x000fc600078ef803ULL, 0x00005e0027267625ULL, 0x000fc800078e0020ULL,
0x0000001025657824ULL, 0x000fe400078e0224ULL, 0x0000001023627825ULL, 0x000fc800078e0026ULL,
0x0000000167277824ULL, 0x040fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062657faeULL, 0x0003e2000b901c50ULL, 0x0000000467677824ULL, 0x000fc600078e00ffULL,
0x0106200621257984ULL, 0x000ea40008004800ULL, 0xfffffffc67677812ULL, 0x000fca00078ee222ULL,
0x0000001067697824ULL, 0x000fe200078e0224ULL, 0x0000000425257984ULL, 0x004ea40008004800ULL,
0x0000002506277224ULL, 0x004fe200078e0227ULL, 0x0000001021257810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fcc00078e0020ULL, 0x0000001023667825ULL, 0x000fc800078e0026ULL,
0x0000000125277824ULL, 0x040fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000066697faeULL, 0x0005e2000b901c50ULL, 0x0000000425257824ULL, 0x000fc600078e00ffULL,
0x0106400621657984ULL, 0x002e640008004800ULL, 0xfffffffc25257812ULL, 0x000fca00078ee222ULL,
0x00000010256b7824ULL, 0x000fe200078e0224ULL, 0x0000000465657984ULL, 0x002e640008004800ULL,
0x0000006506277224ULL, 0x002fe200078e0227ULL, 0x0000001821657810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fcc00078e0020ULL, 0x0000001023627825ULL, 0x000fc800078e0026ULL,
0x0000000165277824ULL, 0x040fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000626b7faeULL, 0x0003e2000b901c50ULL, 0x0000000465657824ULL, 0x000fc600078e00ffULL,
0x0106600621257984ULL, 0x000ee40008004800ULL, 0xfffffffc65657812ULL, 0x000fca00078ee222ULL,
0x0000001065697824ULL, 0x004fe200078e0224ULL, 0x0000000425257984ULL, 0x008ea40008004800ULL,
0x0000002506277224ULL, 0x004fe200078e0227ULL, 0x0000002021257810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fcc00078e0020ULL, 0x0000001023667825ULL, 0x000fc800078e0026ULL,
0x0000000125277824ULL, 0x040fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000066697faeULL, 0x0005e2000b901c50ULL, 0x0000000425257824ULL, 0x000fc600078e00ffULL,
0x0106800621657984ULL, 0x000ee40008004800ULL, 0xfffffffc25257812ULL, 0x000fca00078ee222ULL,
0x00000010256b7824ULL, 0x002fe200078e0224ULL, 0x0000000465657984ULL, 0x008e640008004800ULL,
0x0000006506277224ULL, 0x002fe200078e0227ULL, 0x0000002821657810ULL, 0x000fc60007ffe0ffULL,
0x00005e0027267625ULL, 0x000fcc00078e0020ULL, 0x0000001023627825ULL, 0x000fc800078e0026ULL,
0x0000000165277824ULL, 0x040fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000626b7faeULL, 0x0003e2000b901c50ULL, 0x0000000465657824ULL, 0x000fc600078e00ffULL,
0x0106a00621257984ULL, 0x000ee40008004800ULL, 0xfffffffc65657812ULL, 0x000fca00078ee222ULL,
0x0000001065657824ULL, 0x000fe200078e0224ULL, 0x0000000425257984ULL, 0x008ee40008004800ULL,
0x0000002506277224ULL, 0x008fc800078e0227ULL, 0x00005e0027267625ULL, 0x000fcc00078e0020ULL,
0x0000001023667825ULL, 0x004fe200078e0026ULL, 0x0000003021277810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000066657faeULL, 0x0005e2000b901c50ULL,
0x0000000127267824ULL, 0x040fe400078e021aULL, 0x0000000427637824ULL, 0x002fe200078e00ffULL,
0x0106c00621627984ULL, 0x000e620008004800ULL, 0x0000003821657810ULL, 0x004fc60007ffe0ffULL,
0x0000000462257984ULL, 0x002e640008004800ULL, 0x0000002506257224ULL, 0x002fc800078e0226ULL,
0x00005e0025267625ULL, 0x000fe200078e0020ULL, 0xfffffffc63257812ULL, 0x000fc600078ee222ULL,
0x0000000165637824ULL, 0x000fe400078e021aULL, 0x0000001025697824ULL, 0x000fe400078e0224ULL,
0x0000001023267825ULL, 0x000fc800078e0026ULL, 0x0000000465657824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026697faeULL, 0x0003e8000b901c50ULL,
0x0106e00621257984ULL, 0x000ea20008004800ULL, 0xfffffffc65657812ULL, 0x000fca00078ee222ULL,
0x0000001065657824ULL, 0x000fe200078e0224ULL, 0x0000000425257984ULL, 0x004ea40008004800ULL,
0x0000002506637224ULL, 0x004fc800078e0263ULL, 0x00005e0063627625ULL, 0x000fcc00078e0020ULL,
0x0000001023627825ULL, 0x000fca00078e0062ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000062657faeULL, 0x0003e4000b901c50ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000237f007947ULL, 0x000fea000b800000ULL, 0x0001b17000207802ULL, 0x000fc40000000f00ULL,
0x0000429000007944ULL, 0x002fea0003c00000ULL, 0x000000036100780cULL, 0x000fe20003f05270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000031000007945ULL, 0x000fec0003800000ULL,
0x000002f000000947ULL, 0x000fea0003800000ULL, 0x00000001181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000028000017945ULL, 0x000fe20003800000ULL, 0x0000001b5e00720cULL, 0x000fe40003f04070ULL,
0x00000002ff207819ULL, 0x000fc4000001161aULL, 0x000000031a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000000120207807ULL, 0x000fe40004000000ULL, 0x000000ff1a1a7207ULL, 0x000fe40004000000ULL,
0x0000002003237810ULL, 0x002fe20007ffe0ffULL, 0x000000011b207824ULL, 0x000fe200078e0220ULL,
0x0000001b5e00720cULL, 0x000fe40003f04070ULL, 0x000000031800780cULL, 0x000fc40003f85270ULL,
0x0000000520207c11ULL, 0x000fe4000f8e40ffULL, 0x0000000a1a217c10ULL, 0x000fe4000fffe0ffULL,
0x0000000603277c11ULL, 0x000fe2000f8e10ffULL, 0x00000001201a7824ULL, 0x100fe400078e0203ULL,
0x0000000123227824ULL, 0x100fe400078e0220ULL, 0x0000680021207a24ULL, 0x000fe200078e0220ULL,
0x0000005f1a00720cULL, 0x080fe20003f26070ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005f2200720cULL, 0x000fe20003f66070ULL, 0x00000001201a7824ULL, 0x000fc400078e0203ULL,
0x0000000123207824ULL, 0x000fe400078e0220ULL, 0x000066001a1a7625ULL, 0x000fc800078e0021ULL,
0x0000660020207625ULL, 0x000fe200078e0021ULL, 0x0000010000008947ULL, 0x000fea0002000000ULL,
0x000000030300780cULL, 0x000fe40003f04070ULL, 0x0000000254547810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000e620000002700ULL,
0x0000005d5400720cULL, 0x000fe20003f06070ULL, 0x00000004ff227424ULL, 0x000fe400078e00ffULL,
0x0000000418187824ULL, 0x002fc800078e0203ULL, 0x0000000218237824ULL, 0x000fe400078e00ffULL,
0x0000000404187824ULL, 0x000fe400078e0203ULL, 0x0000640023237a24ULL, 0x000fc600078e0254ULL,
0x00010a8018257811ULL, 0x000fe200078e10ffULL, 0x0000600023227625ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x106000001a277faeULL, 0x0005e8000c921850ULL, 0x1068000020277faeULL, 0x0005e4000d921850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020031a7810ULL, 0x044fe20007ffe0ffULL, 0x0000000204657824ULL, 0x002fe200078e0219ULL,
0xfffffff803187812ULL, 0x040fe200078ec0ffULL, 0x000000ffff627224ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000000703667812ULL, 0x000fc400078ec0ffULL,
0x0000000718617812ULL, 0x100fe400078ef803ULL, 0x000000071a637812ULL, 0x100fe400078ef803ULL,
0x0000200065657811ULL, 0x000fe400078e60ffULL, 0x0000000866667812ULL, 0x000fe400078ef803ULL,
0x00000001ff677819ULL, 0x000fe40000011661ULL, 0x00000001ff6b7819ULL, 0x000fc60000011663ULL,
0x0000000167187824ULL, 0x020fe200078e0262ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000461197824ULL, 0x000fc400078e00ffULL, 0x000000045b9c7824ULL, 0x000fc600078e0262ULL,
0xfffffffc19187812ULL, 0x000fe200078ee218ULL, 0x0000000463197824ULL, 0x000fe400078e00ffULL,
0x000000029c9c7824ULL, 0x000fe400078e00ffULL, 0x0000001018207824ULL, 0x000fe400078e0265ULL,
0x000000016b187824ULL, 0x000fc800078e0262ULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0xfffffffc19187812ULL, 0x000fca00078ee218ULL, 0x0000001018187824ULL, 0x000fcc00078e0265ULL,
0x000000001818783bULL, 0x000ea20000000200ULL, 0x00000018ff727819ULL, 0x002fe20000011420ULL,
0x0001000020247824ULL, 0x040fe200078e00ffULL, 0x0000888020997816ULL, 0x040fe200000000ffULL,
0x0000010020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011421ULL,
0x0001000021257824ULL, 0x040fe200078e00ffULL, 0x0000888021977816ULL, 0x040fe200000000ffULL,
0x0000010021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff937819ULL, 0x000fc40000011422ULL,
0x0000888022957816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x00000020009b7306ULL, 0x0002e20000200c00ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff887819ULL, 0x004fe40000011419ULL,
0x00008880198c7816ULL, 0x000fc400000000ffULL, 0x00000018ff697819ULL, 0x000fe20000011418ULL,
0x0000002100807306ULL, 0x0005e20000200c00ULL, 0x0001000022207824ULL, 0x002fe200078e00ffULL,
0x0000888018687816ULL, 0x000fe200000000ffULL, 0x0000010022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe4000001141aULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0001000023217824ULL, 0x004fe200078e00ffULL,
0x00000024009a7306ULL, 0x0003e20000200c00ULL, 0x000088801a8a7816ULL, 0x000fc400000000ffULL,
0x00000018ff837819ULL, 0x000fe40000011423ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000888023817816ULL, 0x000fe200000000ffULL, 0x0000002200947306ULL, 0x0005e20000200c00ULL,
0x0000000461247824ULL, 0x002fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe2000001141bULL,
0x0000010023237824ULL, 0x000fe200078e00ffULL, 0x000088801b867816ULL, 0x000fc800000000ffULL,
0x0000002100927306ULL, 0x0003e20000200c00ULL, 0x0000000162227810ULL, 0x044fe40007ffe0ffULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000000262627810ULL, 0x000fc60007ffe0ffULL,
0x0000002500987306ULL, 0x0005e20000200c00ULL, 0x0000000167217824ULL, 0x102fe200078e0222ULL,
0x000000046200780cULL, 0x000fe20003f05270ULL, 0x000000016b227824ULL, 0x000fc600078e0222ULL,
0xfffffffc24247812ULL, 0x000fe200078ee221ULL, 0x0001000019217824ULL, 0x040fe200078e00ffULL,
0x0000002000967306ULL, 0x0003e20000200c00ULL, 0x0000010019197824ULL, 0x000fe400078e00ffULL,
0x0000001024247824ULL, 0x000fe200078e0265ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000002300907306ULL, 0x0009e20000200c00ULL,
0x000000002424783bULL, 0x004ea20000000200ULL, 0x0001000018207824ULL, 0x002fc400078e00ffULL,
0x0000010018187824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x00000019008d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000000463237824ULL, 0x010fca00078e00ffULL, 0xfffffffc23227812ULL, 0x000fe200078ee222ULL,
0x00000018008e7306ULL, 0x0009e20000200c00ULL, 0x000100001b197824ULL, 0x042fe400078e00ffULL,
0x000001001b1b7824ULL, 0x000fe400078e00ffULL, 0x0000001022227824ULL, 0x000fe200078e0265ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x000100001a187824ULL, 0x050fe200078e00ffULL, 0x0000001900877306ULL, 0x0003e20000200c00ULL,
0x000001001a1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018008b7306ULL, 0x0009e20000200c00ULL,
0x0000009c03197211ULL, 0x002fe400078fe0ffULL, 0x000000029c9c7810ULL, 0x000fc60007ffe0ffULL,
0x0000000166197824ULL, 0x000fe200078e0219ULL, 0x00000018ff7c7819ULL, 0x004fe20000011424ULL,
0x0000001a00897306ULL, 0x0003e20000200c00ULL, 0x0001000024187824ULL, 0x050fe200078e00ffULL,
0x00008880247f7816ULL, 0x040fe200000000ffULL, 0x0000010024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011425ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001b00857306ULL, 0x000fe20000200c00ULL, 0x00000020661a7824ULL, 0x002fe200078e00ffULL,
0x00008880257b7816ULL, 0x000fc400000000ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0xffffffe01a197812ULL, 0x000fe200078ee219ULL, 0x00010000251a7824ULL, 0x040fe200078e00ffULL,
0x0000001800827306ULL, 0x0003e20000200c00ULL, 0x0000010025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011426ULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001141aULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x0000002000917306ULL, 0x000fe20000200c00ULL, 0x000000001918783bULL, 0x002fe20000000200ULL,
0x0000888026787816ULL, 0x040fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011427ULL,
0x0000888027717816ULL, 0x000fe400000000ffULL, 0x00000021008f7306ULL, 0x0003f00000200c00ULL,
0x0000009900997306ULL, 0x000ea20000200c00ULL, 0x000000002220783bULL, 0x002e6e0000000200ULL,
0x00000024007d7306ULL, 0x0009f00000200c00ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x0001000026247824ULL, 0x010fc400078e00ffULL, 0x0000010026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000009700977306ULL, 0x000f220000200c00ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x00000025007a7306ULL, 0x0003f00000200c00ULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x0001000027257824ULL, 0x042fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011420ULL, 0x0000010027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc40000011421ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000009500957306ULL, 0x000e620000200c00ULL, 0x00000018ff9d7819ULL, 0x000fe40000011427ULL,
0x000054109b277816ULL, 0x008fe40000000072ULL, 0x00000018ff6a7819ULL, 0x000fe40000011423ULL,
0x00000018ff6c7819ULL, 0x000fe20000011422ULL, 0x0000002600777306ULL, 0x0005f00000200c00ULL,
0x0000002400797306ULL, 0x0009e20000200c00ULL, 0x0000541099267816ULL, 0x004fc4000000009aULL,
0x0000888020997816ULL, 0x000fca00000000ffULL, 0x0000002500767306ULL, 0x0005e20000200c00ULL,
0x0000541097247816ULL, 0x010fe20000000098ULL, 0x000000261840723cULL, 0x000b620000001840ULL,
0x0000002066987824ULL, 0x000fca00078e00ffULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000541080257816ULL, 0x004fe20000000075ULL, 0x000000ffff267224ULL, 0x020fe200078e0099ULL,
0x0000009c03277211ULL, 0x000fe200078fe0ffULL, 0x0001000020807824ULL, 0x040fe400078e00ffULL,
0x0000010020207824ULL, 0x000fe400078e00ffULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00000024183c723cULL, 0x000b62000000183cULL, 0x0000000166277824ULL, 0x000fe200078e0227ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0xffffffe098277812ULL, 0x000fe200078ee227ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x0000541095247816ULL, 0x022fe40000000096ULL, 0x0000541094257816ULL, 0x000fe20000000093ULL,
0x0000001027277824ULL, 0x000fc800078e00ffULL, 0x0000006800687306ULL, 0x000e640000200c00ULL,
0x000000241838723cULL, 0x000b6c0000001838ULL, 0x0000008800887306ULL, 0x000f220000200c00ULL,
0x0000541081247816ULL, 0x024fe40000000092ULL, 0x0000541090257816ULL, 0x000fe20000000083ULL,
0x0001000021907824ULL, 0x000fe200078e00ffULL, 0x000054108e697816ULL, 0x008fc40000000069ULL,
0x0000888021927816ULL, 0x000fe200000000ffULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x0000541068687816ULL, 0x002fe20000000091ULL, 0x000000241834723cULL, 0x000b640000001834ULL,
0x000000ffff837224ULL, 0x000fc800078e0092ULL, 0x0000002600757306ULL, 0x0003e40000200c00ULL,
0x000000681830723cULL, 0x000b6c0000001830ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000000002724783bULL, 0x022e620000000200ULL, 0x0000010021697824ULL, 0x000fe200078e00ffULL,
0x000054108d217816ULL, 0x010fc40000000088ULL, 0x00000018ff687819ULL, 0x000fe40000011490ULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000008a008a7306ULL, 0x000ef00000200c00ULL,
0x0000002000817306ULL, 0x0005f00000200c00ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000054108c207816ULL, 0x004fc4000000008fULL, 0x00008880228c7816ULL, 0x000fca00000000ffULL,
0x0000008600867306ULL, 0x000ea20000200c00ULL, 0x00000020182c723cULL, 0x000b6e000000182cULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000054108a207816ULL, 0x028fe4000000008bULL,
0x0000541089217816ULL, 0x000fe20000000084ULL, 0x0001000022897824ULL, 0x000fc400078e00ffULL,
0x0000010022227824ULL, 0x000fe400078e00ffULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x000000ffff847224ULL, 0x000fe200078e008cULL, 0x000000201828723cULL, 0x000b620000001828ULL,
0x00000018ff227819ULL, 0x000fca0000011422ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541086207816ULL, 0x024fe40000000087ULL, 0x0000541085217816ULL, 0x000fca0000000074ULL,
0x0000007b007b7306ULL, 0x000fe40000200c00ULL, 0x00000020181c723cULL, 0x000b6c000000181cULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x000054107f187816ULL, 0x028fe40000000082ULL,
0x000054107d197816ULL, 0x000fc4000000007cULL, 0x00008880231a7816ULL, 0x000fe400000000ffULL,
0x00000018ff1b7819ULL, 0x000fe20000011489ULL, 0x0000007000707306ULL, 0x000ee40000200c00ULL,
0x000000182440723cULL, 0x002b6c0000001840ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000054107b187816ULL, 0x024fc4000000007eULL, 0x000054107a197816ULL, 0x000fca0000000073ULL,
0x0000006f006f7306ULL, 0x000fe40000200c00ULL, 0x00000018243c723cULL, 0x000b6c000000183cULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000000ffff187224ULL, 0x020fe200078e001aULL,
0x0000541077197816ULL, 0x008fe20000000070ULL, 0x00010000231a7824ULL, 0x000fc400078e00ffULL,
0x0000010023237824ULL, 0x000fc600078e00ffULL, 0x0000009d00727306ULL, 0x000ee20000200c00ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000001800207306ULL, 0x0003f00000200c00ULL, 0x0000001a00217306ULL, 0x000f220000200c00ULL,
0x0000541078187816ULL, 0x002fce0000000079ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000000182438723cULL, 0x000b6e0000001838ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541071187816ULL, 0x024fe40000000076ULL, 0x0000541072197816ULL, 0x008fc4000000006fULL,
0x0000541020207816ULL, 0x010fc60000000021ULL, 0x0000006c006c7306ULL, 0x000fe40000200c00ULL,
0x000000182434723cULL, 0x000b6c0000001834ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541081197816ULL, 0x022fce000000006eULL, 0x0000008000807306ULL, 0x000e700000200c00ULL,
0x0000008300837306ULL, 0x000ff00000200c00ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541075187816ULL, 0x002fce0000000080ULL, 0x0000006900887306ULL, 0x000e620000200c00ULL,
0x000000182430723cULL, 0x000b6e0000001830ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000541083687816ULL, 0x004fce0000000068ULL, 0x0000001b001b7306ULL, 0x000ea20000200c00ULL,
0x0000541088697816ULL, 0x002fce000000006dULL, 0x0000002200857306ULL, 0x000e620000200c00ULL,
0x00000068242c723cULL, 0x000b6e000000182cULL, 0x0000002300237306ULL, 0x000ee20000200c00ULL,
0x0000541084847816ULL, 0x004fe4000000001bULL, 0x0000541085857816ULL, 0x002fce000000006cULL,
0x000000842428723cULL, 0x000b620000001828ULL, 0x0000541023217816ULL, 0x008fce000000006aULL,
0x00000020241c723cULL, 0x000b62000000181cULL, 0xfffff04000000947ULL, 0x000fce000383ffffULL,
0x000000046400780cULL, 0x000fe20003f06070ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0064ULL,
0x000000ffff197224ULL, 0x020fd400078e0009ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdad000007947ULL, 0x000fea000383ffffULL, 0x00000002ff647819ULL, 0x000fc80000011603ULL,
0x000000576400720cULL, 0x040fe40003f06070ULL, 0x0000000157577810ULL, 0x000fe40007ffe0ffULL,
0x0000000864627810ULL, 0x040fe40007ffe0ffULL, 0x000000576400720cULL, 0x000fe40004706470ULL,
0x000000596200720cULL, 0x000fe40003f26070ULL, 0x000000075e00720cULL, 0x000fc40000703070ULL,
0x000000576200720cULL, 0x000fc80000f21070ULL, 0x000000075e00720cULL, 0x000fc80000f24470ULL,
0x000000581f587208ULL, 0x000fe40000800000ULL, 0x000000451e457208ULL, 0x000fe20000800000ULL,
0x000000ffff568224ULL, 0x000fe200078e001dULL, 0x000000162b167208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e001cULL, 0x000000472a477208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e0029ULL, 0x000000442f447208ULL, 0x000fe20000800000ULL,
0x000000ffff088224ULL, 0x000fe200078e0028ULL, 0x000000492e497208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e002dULL, 0x0000004633467208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e002cULL, 0x0000004b324b7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0031ULL, 0x0000004837487208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e0030ULL, 0x0000004d364d7208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0035ULL, 0x0000004a3b4a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e0034ULL, 0x0000004f3a4f7208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e0039ULL, 0x0000004c3f4c7208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0038ULL, 0x000000513e517208ULL, 0x000fe20000800000ULL,
0x000000ffff158224ULL, 0x000fe200078e003dULL, 0x0000004e434e7208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e003cULL, 0x0000005342537208ULL, 0x000fe20000800000ULL,
0x000000ffff178224ULL, 0x000fc400078e0041ULL, 0x000000ffff148224ULL, 0x000fe200078e0040ULL,
0x0000005c5700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd6e000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000052187f8cULL, 0x000e62000c80043fULL, 0x0000000214237220ULL, 0x080fe20000410000ULL,
0x0000000217177220ULL, 0x080fe20000410000ULL, 0x0000000212127220ULL, 0x080fe20000410000ULL,
0x0000000215157220ULL, 0x080fe20000410000ULL, 0x0000000210107220ULL, 0x080fe20000410000ULL,
0x0000000213137220ULL, 0x080fe20000410000ULL, 0x000000020e227220ULL, 0x080fe20000410000ULL,
0x0000000211117220ULL, 0x080fe20000410000ULL, 0x000000020c217220ULL, 0x080fe20000410000ULL,
0x000000020f207220ULL, 0x080fe20000410000ULL, 0x000000020a0a7220ULL, 0x080fe20000410000ULL,
0x000000020d1f7220ULL, 0x080fe20000410000ULL, 0x0000000208087220ULL, 0x080fe20000410000ULL,
0x000000020b0b7220ULL, 0x080fe20000410000ULL, 0x00000002551e7220ULL, 0x080fe20000410000ULL,
0x00000002561d7220ULL, 0x080fe20000410000ULL, 0x00000002532e7220ULL, 0x080fe20000410000ULL,
0x000000024e2f7220ULL, 0x080fe20000410000ULL, 0x0000000251327220ULL, 0x080fe20000410000ULL,
0x000000024c2d7220ULL, 0x080fe20000410000ULL, 0x000000024f2c7220ULL, 0x080fe20000410000ULL,
0x000000024a2b7220ULL, 0x080fe20000410000ULL, 0x000000024d2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff1b7224ULL, 0x002fe200078e0019ULL, 0x0000000248297220ULL, 0x080fe20000410000ULL,
0x000000024b287220ULL, 0x080fe20000410000ULL, 0x0000000246277220ULL, 0x080fe20000410000ULL,
0x0000000249267220ULL, 0x080fe20000410000ULL, 0x0000000244257220ULL, 0x080fe20000410000ULL,
0x0000000247247220ULL, 0x080fe20000410000ULL, 0x0000000216167220ULL, 0x080fe20000410000ULL,
0x0000000245147220ULL, 0x080fe20000410000ULL, 0x00000002581c7220ULL, 0x000fc20000410000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x00000400520e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc4000780481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c197210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000190e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400520e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004031b7824ULL, 0x000fe200078e00ffULL,
0x000000500700720cULL, 0x000fc80003f05270ULL, 0xfffffff01b0d7812ULL, 0x000fca00078ec0ffULL,
0x0000008004307824ULL, 0x000fca00078e020dULL, 0x01040000300c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203187824ULL, 0x000fe400078e00ffULL,
0x000000015f5a7824ULL, 0x000fc600078e0a5aULL, 0x0000000618197812ULL, 0x000fc800078ec0ffULL,
0x0000000119317812ULL, 0x040fe400078efcffULL, 0x0000000819337812ULL, 0x000fe400078efcffULL,
0x0000005a3100720cULL, 0x080fe40003f26070ULL, 0x0000001019317812ULL, 0x000fe400078efcffULL,
0x0000005a3300720cULL, 0x080fe40003f06070ULL, 0x0000005a3100720cULL, 0x000fc40003fc6070ULL,
0x0000001119337812ULL, 0x040fe400078efcffULL, 0x0000001819317812ULL, 0x040fe400078efcffULL,
0x0000005a1900720cULL, 0x080fe40003f46070ULL, 0x0000005a3300720cULL, 0x080fe40003fa6070ULL,
0x0000005a3100720cULL, 0x000fe40003f66070ULL, 0x0000000919357812ULL, 0x000fc400078efcffULL,
0x0000001919337812ULL, 0x040fe400078efcffULL, 0x0000002019317812ULL, 0x000fe400078efcffULL,
0xff8000002e2e7808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff80000017177808ULL, 0x000fc40004800000ULL,
0x0000005a3500720cULL, 0x080fe40003f86070ULL, 0x0000005a3300720cULL, 0x080fe40003f46070ULL,
0x0000005a3100720cULL, 0x000fe40003f26070ULL, 0x0000002119337812ULL, 0x040fe400078efcffULL,
0x0000002819317812ULL, 0x000fe400078efcffULL, 0xff80000032327808ULL, 0x000fc40004000000ULL,
0xff80000012127808ULL, 0x000fe40004000000ULL, 0xff8000002d2d7808ULL, 0x000fe40006000000ULL,
0xff80000015157808ULL, 0x000fe40006000000ULL, 0x0000005a3300720cULL, 0x080fe40003f06070ULL,
0x0000005a3100720cULL, 0x000fe40003f86070ULL, 0x0000002919337812ULL, 0x000fc400078efcffULL,
0x0000003019317812ULL, 0x000fe400078efcffULL, 0xff8000002c2c7808ULL, 0x000fe40007000000ULL,
0xff80000010107808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006800000ULL,
0xff80000013137808ULL, 0x000fe40006800000ULL, 0x0000005a3300720cULL, 0x000fc40003fc6070ULL,
0x0000005a3100720cULL, 0x000fe40003fa6070ULL, 0x0000003119337812ULL, 0x040fe400078efcffULL,
0x0000003819317812ULL, 0x040fe400078efcffULL, 0x0000003919197812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005800000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff80000011117808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0x0000005a3300720cULL, 0x080fe40003f66070ULL, 0x0000005a3100720cULL, 0x000fc40003f46070ULL,
0x0000005a1900720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff80000020207808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000000a0a7808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fc40007000000ULL,
0xff8000001f1f7808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff80000008087808ULL, 0x000fe40006800000ULL, 0xff80000016167808ULL, 0x000fe40005800000ULL,
0xff8000000b0b7808ULL, 0x000fe40005800000ULL, 0xff80000014147808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004800000ULL,
0xff8000001d1d7808ULL, 0x000fc40004800000ULL, 0x000000230c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x0000002e0d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0000000c230c7208ULL, 0x000fe40004000000ULL,
0x0000000d2e187208ULL, 0x000fc40004800000ULL, 0x000000170c00720bULL, 0x000fe40003f1e000ULL,
0x0000002f1800720bULL, 0x000fe40003f3e000ULL, 0x0000000c170d7208ULL, 0x000fe40004000000ULL,
0x000000182f197208ULL, 0x000fe40004800000ULL, 0x000000120d00720bULL, 0x000fe40003f1e000ULL,
0x000000321900720bULL, 0x000fc40003f3e000ULL, 0x0000000d120c7208ULL, 0x000fe40004000000ULL,
0x0000001932187208ULL, 0x000fe40004800000ULL, 0x000000150c00720bULL, 0x000fe40003f1e000ULL,
0x0000002d1800720bULL, 0x000fe40003f3e000ULL, 0x0000000c150d7208ULL, 0x000fe40004000000ULL,
0x000000182d197208ULL, 0x000fc40004800000ULL, 0x000000100d00720bULL, 0x000fe40003f1e000ULL,
0x0000002c1900720bULL, 0x000fe40003f3e000ULL, 0x0000000d100c7208ULL, 0x000fe40004000000ULL,
0x000000192c187208ULL, 0x000fe40004800000ULL, 0x000000130c00720bULL, 0x000fe40003f1e000ULL,
0x0000002b1800720bULL, 0x000fc40003f3e000ULL, 0x0000000c130d7208ULL, 0x000fe40004000000ULL,
0x000000182b197208ULL, 0x000fe40004800000ULL, 0x000000220d00720bULL, 0x000fe40003f1e000ULL,
0x0000002a1900720bULL, 0x000fe40003f3e000ULL, 0x0000000d220c7208ULL, 0x000fe40004000000ULL,
0x000000192a187208ULL, 0x000fc40004800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x000000291800720bULL, 0x000fe40003f3e000ULL, 0x0000000c110c7208ULL, 0x000fe40004000000ULL,
0x00000018290d7208ULL, 0x000fe40004800000ULL, 0x000000210c00720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x0000000c21197208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x000000201900720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x0000001920197208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fc40004800000ULL, 0x0000000a1900720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x000000190a0c7208ULL, 0x000fe40004000000ULL,
0x0000000d26187208ULL, 0x000fe40004800000ULL, 0x0000001f0c00720bULL, 0x000fe40003f1e000ULL,
0x000000251800720bULL, 0x000fc40003f3e000ULL, 0x0000000c1f0d7208ULL, 0x000fe40004000000ULL,
0x0000001825197208ULL, 0x000fe40004800000ULL, 0x000000080d00720bULL, 0x000fe40003f1e000ULL,
0x000000241900720bULL, 0x000fe40003f3e000ULL, 0x0000000d080c7208ULL, 0x000fe40004000000ULL,
0x0000001924197208ULL, 0x000fc40004800000ULL, 0x0000000b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000161900720bULL, 0x000fe40003f3e000ULL, 0x0000000c0b0d7208ULL, 0x000fe40004000000ULL,
0x0000001916197208ULL, 0x000fe40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000141900720bULL, 0x000fc40003f3e000ULL, 0x0000000d1e0c7208ULL, 0x000fe40004000000ULL,
0x0000001914197208ULL, 0x000fe40004800000ULL, 0x0000001d0c00720bULL, 0x000fe40003f1e000ULL,
0x0000001c1900720bULL, 0x000fe40003f3e000ULL, 0x0000000c1d337208ULL, 0x000fe40004000000ULL,
0x000000191c317208ULL, 0x000fe20004800000ULL, 0x000019027f007947ULL, 0x000fec000b800000ULL,
0x0c401f00330c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3300720bULL, 0x008fc80003f1e000ULL,
0x000000330c357208ULL, 0x000fe20004000000ULL, 0x000019127f007947ULL, 0x000fea000b800000ULL,
0x0c401f00310c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f187f89ULL, 0x000e6800000e0000ULL, 0x0c201f0035197f89ULL, 0x000ea200000e0000ULL,
0x0000000c3100720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x000000310c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000180f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c337f89ULL, 0x004e6600000e0000ULL,
0x0000000f18317208ULL, 0x000fe20004000000ULL, 0x0c201f000d1a7f89ULL, 0x000ea200000e0000ULL,
0x000000193500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0031347f89ULL, 0x0006e200000e0000ULL,
0x0000003519187208ULL, 0x000fe40004000000ULL, 0x000000330c00720bULL, 0x002fe40003f3e000ULL,
0x0000001a0d00720bULL, 0x004fe40003f5e000ULL, 0x0000000c33197208ULL, 0x000fe40004800000ULL,
0x0000000d1a1a7208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b19357820ULL, 0x008fe20000410000ULL,
0x3fb8aa3b18367820ULL, 0x002fe20000410000ULL, 0x3c003c00ff337424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b14457823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b23147823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010835ULL,
0x0000002e00537308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010836ULL,
0x0000002f004e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b220e7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b24247823ULL, 0x000fe20000010835ULL, 0x3fb8aa3b210c7823ULL, 0x100fe20000010836ULL,
0x0000003200517308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b200f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b1f0d7823ULL, 0x100fe20000010836ULL,
0x0000000864207824ULL, 0x040fe200078e00ffULL, 0x00000001641f7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b08087823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010836ULL,
0x0000002d004c7308ULL, 0x000ee20000000800ULL, 0x3c003c00ff327424ULL, 0x002fe200078e00ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fe20000010836ULL,
0xfffffff820367812ULL, 0x000fe200078ee21fULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b1c1c7823ULL, 0x000fe20000010835ULL, 0x00000008643a7824ULL, 0x040fe200078e00ffULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x0000000864377824ULL, 0x040fe200078e00ffULL,
0x0000000464357810ULL, 0x040fe20007ffe0ffULL, 0x0000000864387824ULL, 0x040fe200078e00ffULL,
0x00000003641f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008643c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a397812ULL, 0x000fe200078ee235ULL, 0x0000000864357824ULL, 0x000fe200078e00ffULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0xfffffff838387812ULL, 0x000fe200078ee21fULL,
0x0000a00008047891ULL, 0x000fe2000f8e583fULL, 0x00000008643e7824ULL, 0x040fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee264ULL, 0x00000008643d7824ULL, 0x040fe200078e00ffULL,
0x00000006643b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008623f7824ULL, 0x000fe200078e00ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000000435357c11ULL, 0x000fc4000f8e20ffULL,
0xfffffff83e3b7812ULL, 0x000fe400078ee23bULL, 0xfffffff83f627812ULL, 0x000fe400078ee262ULL,
0x0000000439397c11ULL, 0x000fe2000f8e20ffULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x000000043b3b7c11ULL, 0x000fe4000f8e20ffULL, 0x00000004623f7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000303ff7812ULL, 0x000fc4000780c0ffULL, 0x000000343100720bULL, 0x004fe20003f3e000ULL,
0x0000002b004a7308ULL, 0x0007f00000000800ULL, 0x0000002a004d7308ULL, 0x0003e20000000800ULL,
0x000000514c2b723eULL, 0x008fce00000000ffULL, 0x0000002900487308ULL, 0x0004e20000000800ULL,
0x00000012152a723eULL, 0x002fce00000000ffULL, 0x00000028004b7308ULL, 0x0003e20000000800ULL,
0x000000534e29723eULL, 0x004fce00000000ffULL, 0x0000002c004f7308ULL, 0x0005e20000000800ULL,
0x000000141728723eULL, 0x002fce00000000ffULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x00000032282c723cULL, 0x004f6e00000018ffULL, 0x0000001300137308ULL, 0x000ff00000000800ULL,
0x0000000e000e7308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000e700000000800ULL,
0x0000002700467308ULL, 0x0006b00000000800ULL, 0x0000002600497308ULL, 0x0003e20000000800ULL,
0x0000004d4827723eULL, 0x008fce00000000ffULL, 0x0000002500447308ULL, 0x0007220000000800ULL,
0x0000000e1126723eULL, 0x002fe400000000ffULL, 0x0000004b4621723eULL, 0x004fca00000000ffULL,
0x0000002400477308ULL, 0x0003e20000000800ULL, 0x0000004f4a25723eULL, 0x008fce00000000ffULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x000000101324723eULL, 0x002fe400000000ffULL,
0x000000494423723eULL, 0x010fca00000000ffULL, 0x00000032242c723cULL, 0x020f62000000182cULL,
0x0000000f000f7308ULL, 0x000e700000000800ULL, 0x0000000a000a7308ULL, 0x000ff00000000800ULL,
0x0000000d000d7308ULL, 0x000ea20000000800ULL, 0x0000000c0f20723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x0000000a0d22723eULL, 0x004fce00000000ffULL,
0x0000004500457308ULL, 0x000fe20000000800ULL, 0x00000032202c723cULL, 0x020f6e000000182cULL,
0x0000000800087308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000eb00000000800ULL,
0x0000001e00557308ULL, 0x0007f00000000800ULL, 0x0000001d00567308ULL, 0x0008a20000000800ULL,
0x00000002641e7810ULL, 0x008fc80007ffe0ffULL, 0xfffffff837377812ULL, 0x000fc600078ee21eULL,
0x0000001c00587308ULL, 0x0004e20000000800ULL, 0x00000005641d7810ULL, 0x010fe40007ffe0ffULL,
0x0000000437377c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff83c3a7812ULL, 0x000fe400078ee21dULL,
0x00000047161d723eULL, 0x002fe400000000ffULL, 0x000000080b1c723eULL, 0x004fe400000000ffULL,
0x00000055561e723eULL, 0x000fc400000000ffULL, 0xffffffff643c7810ULL, 0x000fe40007ffe0ffULL,
0x00000045581f723eULL, 0x008fe400000000ffULL, 0xfffffff83d3c7812ULL, 0x000fc800078ee23cULL,
0x000000043c3d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000321c2c723cULL, 0x020b6e000000182cULL,
0x0000000c1b327812ULL, 0x020fe400078ec0ffULL, 0x00000004361b7c11ULL, 0x000fc4000f8e20ffULL,
0x000000043a337c11ULL, 0x000fe2000f8e20ffULL, 0x0000000135357824ULL, 0x000fe400078e0232ULL,
0x0000000132377824ULL, 0x040fe400078e0237ULL, 0x0000000132397824ULL, 0x040fe200078e0239ULL,
0x0000002835007388ULL, 0x0003e20000000800ULL, 0x0000000132337824ULL, 0x000fe400078e0233ULL,
0x00000004382f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001322d7824ULL, 0x000fe200078e021bULL,
0x00000031341b7208ULL, 0x000fe20004800000ULL, 0x00000001323b7824ULL, 0x000fc400078e023bULL,
0x00000001322f7824ULL, 0x040fe200078e022fULL, 0x0000002a2d007388ULL, 0x0005e20000000800ULL,
0x00000001323d7824ULL, 0x040fe400078e023dULL, 0x0000000132327824ULL, 0x000fe200078e023fULL,
0x0000002437007388ULL, 0x0005e20000000800ULL, 0x000000ffff347224ULL, 0x000fe400078e002cULL,
0x000000ffff357224ULL, 0x002fe200078e002eULL, 0x000000262f007388ULL, 0x0005e80000000800ULL,
0x0000002039007388ULL, 0x0005e80000000800ULL, 0x0000002233007388ULL, 0x0005e80000000800ULL,
0x0000001c3b007388ULL, 0x0005e80000000800ULL, 0x0000001e3d007388ULL, 0x0005e80000000800ULL,
0x0000002932007388ULL, 0x0005e80000000800ULL, 0x0004002b2d007388ULL, 0x0005e80000000800ULL,
0x0004002537007388ULL, 0x0005e80000000800ULL, 0x000400272f007388ULL, 0x0005e80000000800ULL,
0x0004002139007388ULL, 0x0005e80000000800ULL, 0x0004002333007388ULL, 0x0005e80000000800ULL,
0x0004001d3b007388ULL, 0x0005e80000000800ULL, 0x0004001f3d007388ULL, 0x0005e80000000800ULL,
0x0100001830008388ULL, 0x0005e80000000c00ULL, 0x0102003430008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080005ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100005ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000107077810ULL, 0x000fe20007ffe0ffULL,
0x0000180005ff7f8cULL, 0x0003e6000c80043fULL, 0x000000600700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbc1000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001e2e000247802ULL, 0x000fc40000000f00ULL, 0x000010b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffe526000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001e33000247802ULL, 0x000fc40000000f00ULL,
0x0000106000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0025ULL,
0xfffe52a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e0012ULL,
0x0001e39000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001dULL,
0x00000fc000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffe534000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x0001e3f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0012ULL,
0x00000f6000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffe544000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001dULL,
0x0001e45000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e001cULL,
0x00000f0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe561000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e001aULL,
0x0001e4b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001dULL,
0x00000ea000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe55e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e51000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x00000e4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe7d6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e57000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x00000de000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe7d2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001e5c000247802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffea8b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001e61000247802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x008fea0003c00000ULL, 0xfffea90000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001e66000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000cf000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xfffea99000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001e6c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xfffeaa8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e72000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000c3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffeac4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e78000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000bd000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffeac0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e7e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x00000b7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffed18000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001e84000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x00000b1000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffed14000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x004fe40004000000ULL, 0x0001e89000247802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xfffefbc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe40004800000ULL,
0x0001e8e000247802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x008fea0003c00000ULL,
0xfffefc1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0001e93000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x00000a2000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffefca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0001e99000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0026ULL,
0xfffefd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001e9f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x0000096000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffeff5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001ea5000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x0000090000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffeff1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001eab000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0068ULL,
0x000008a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xffff249000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001eb1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e0065ULL,
0x0000084000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff245000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe40004000000ULL,
0x0001eb6000247802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xffff4ed000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe40004800000ULL, 0x0001ebb000247802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x008fea0003c00000ULL, 0xffff4f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001ec0000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x0000075000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xffff4fb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001ec6000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x000006f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0026ULL, 0xffff50a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ecc000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x0000069000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff526000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ed2000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x0000063000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff522000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ed8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0068ULL, 0x000005d000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xffff77a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001ede000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e0065ULL, 0x0000057000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xffff776000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0004ULL, 0x0001ee3000207802ULL, 0x000fc40000000f00ULL,
0x0000052000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0026ULL,
0xffff8b7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0004ULL,
0x0001ee8000207802ULL, 0x000fc40000000f00ULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0026ULL, 0xffff8c6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0001eed0000c7802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0034ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff337224ULL, 0x006fe200078e0031ULL,
0x0001ef30000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x000000343100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e000eULL, 0x0001ef90000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0000003134197208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000340e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e000fULL, 0x0001eff0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe200078e00ffULL, 0x0000000e34377208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000340f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0035ULL, 0x0001f050000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000000f34317208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000343500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0019ULL, 0x0001f0b0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000003534187208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000341900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0037ULL, 0x0001f110000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x0000001934197208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000343700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff337224ULL, 0x002fe200078e0031ULL, 0x0001f170000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x000fe200078e00ffULL, 0x00000037341a7208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe59000007947ULL, 0x000fea000383ffffULL,
0x018000000e027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000e00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0eff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000e037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000e00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe0cf002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00003633347389ULL, 0x0002a200000e0038ULL,
0xfffe0cb00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000001100007348ULL, 0x000fe80003800000ULL, 0x0000002726267389ULL, 0x0002a200000e0010ULL,
0xfffe0c7020007950ULL, 0x000fea0003c3ffffULL, 0x000000012000780cULL, 0x000fe20003f25070ULL,
0x0000001700007348ULL, 0x000fe80003800000ULL, 0x00000000ff217424ULL, 0x000fd000078e00ffULL,
0x0000000000207806ULL, 0x000fc800048e0100ULL, 0x0000001720257212ULL, 0x000fe200078ec0ffULL,
0x000000ffff207224ULL, 0x000fc800078e0024ULL, 0xfffe0c0020007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000000000007348ULL, 0x000fe80003800000ULL,
0xfffe0bd020007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000400ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ee4ULL, 0x0000000000000c3cULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b20ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b30ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001be0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001be4ULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e00ULL, 0x000000000001f500ULL, 0xa000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021300ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000021350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000216d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001be0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001f720ULL, 0x000000000001f720ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000021300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000216d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_89_cubin_len = 137136;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
