/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000023f50ULL, 0x0000000000023bd0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000021990ULL, 0x0000000000000180ULL,
0x000b0022000004bdULL, 0x0000000000021b10ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x0000000000021b50ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x0000000000021b90ULL,
0x0000000000000070ULL, 0x000b00220000053dULL, 0x0000000000021c00ULL, 0x0000000000000100ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000021d00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0002199000000000ULL, 0x0000040400000000ULL, 0x810c000001700400ULL,
0x0084e80400288080ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8c082880808a0828ULL, 0x2880808d08288080ULL, 0x8094082880809308ULL, 0x0828808095082880ULL,
0x80809a0828808097ULL, 0xa0082880809b0828ULL, 0x288080a408288080ULL, 0x80a708288080a608ULL,
0x08288080a8082880ULL, 0x8080d508288080adULL, 0x8016288080860828ULL, 0x0000000310288082ULL,
0x8086920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL,
0x0002199000000000ULL, 0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080860900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL,
0x2880808a08288080ULL, 0x8093082880808d08ULL, 0x0828808094082880ULL, 0x80809a0828808097ULL,
0xa0082880809b0828ULL, 0x288080a408288080ULL, 0x80a808288080a708ULL, 0x08288080ad082880ULL,
0x80808c08288080d5ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL,
0x0000001cffffffffULL, 0x0000014800000000ULL, 0x00021b1000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL,
0x2880808a08288080ULL, 0x808d082880808c08ULL, 0x0828808093082880ULL, 0x8080970828808094ULL,
0x9b082880809a0828ULL, 0x288080a408288080ULL, 0x80a708288080a608ULL, 0x08288080a8082880ULL,
0x8080d508288080adULL, 0x8016288080a00828ULL, 0x0000000310288082ULL, 0x80a0920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000020800000000ULL, 0x00021b5000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8608288080820828ULL, 0x2880808a08288080ULL, 0x808d082880808c08ULL, 0x0828808093082880ULL,
0x8080970828808094ULL, 0x9b082880809a0828ULL, 0x288080a008288080ULL, 0x80a708288080a608ULL,
0x08288080a8082880ULL, 0x8080d508288080adULL, 0x8016288080a40828ULL, 0x0000000310288082ULL,
0x80a4920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000002d000000000ULL,
0x00021b9000000000ULL, 0x0000007000000000ULL, 0x0000180400000000ULL, 0x80a0288080a40900ULL,
0x0000000000002880ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8608288080820828ULL,
0x2880808a08288080ULL, 0x808d082880808c08ULL, 0x0828808093082880ULL, 0x8080950828808094ULL,
0x9808288080970828ULL, 0x2880809a08288080ULL, 0x80a0082880809b08ULL, 0x08288080a4082880ULL,
0x8080a708288080a6ULL, 0xad08288080a80828ULL, 0x288080d508288080ULL, 0x8280162880809c08ULL,
0x0000000003102880ULL, 0x80809c9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x000003a800000000ULL, 0x00021c0000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x000823040000009dULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL, 0x0000001b00081104ULL,
0x0004370400000000ULL, 0x000035010000007bULL, 0x0000001800080a04ULL, 0x0068190300680160ULL,
0x00000000000c1704ULL, 0x0021f00000600007ULL, 0x00000000000c1704ULL, 0x0021f00000580006ULL,
0x00000000000c1704ULL, 0x0011f00000500005ULL, 0x00000000000c1704ULL, 0x0061f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x01bc290400000030ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01bc2804ffffffffULL, 0x0000012000000100ULL, 0x0000351000000440ULL,
0x000036a0000035a0ULL, 0x00003a3000003800ULL, 0x00003ad000003a60ULL, 0x0000629000003b40ULL,
0x00006320000062b0ULL, 0x00008ee000006390ULL, 0x0000906000008f70ULL, 0x000093d0000091b0ULL,
0x00009460000093f0ULL, 0x0000ba00000094d0ULL, 0x0000ba900000ba20ULL, 0x0000e5300000bb00ULL,
0x0000e6b00000e5c0ULL, 0x0000ea200000e800ULL, 0x0000eab00000ea40ULL, 0x000110500000eb20ULL,
0x000110e000011070ULL, 0x00013b8000011150ULL, 0x00013d0000013c10ULL, 0x0001407000013e50ULL,
0x0001410000014090ULL, 0x000166a000014170ULL, 0x00016730000166c0ULL, 0x00017b50000167a0ULL,
0x0001828000017c90ULL, 0x00018730000182a0ULL, 0x0001b3c00001a940ULL, 0x0001d5000001b3e0ULL,
0x0001f9000001d520ULL, 0x0001f9500001f940ULL, 0x0001f9700001f960ULL, 0x0001f9f00001f9d0ULL,
0x000206300001fa10ULL, 0x0002071000020690ULL, 0x0002081000020790ULL, 0x0002091000020890ULL,
0x000209f000020990ULL, 0x00020ac000020a50ULL, 0x00020bc000020b40ULL, 0x00020cc000020c40ULL,
0x00020da000020d40ULL, 0x00020e7000020e00ULL, 0x00020f7000020ef0ULL, 0x0002107000020ff0ULL,
0x00021150000210f0ULL, 0x00021220000211b0ULL, 0x00021320000212a0ULL, 0x00021420000213a0ULL,
0x00021510000214a0ULL, 0x000215f000021580ULL, 0x000216f000021670ULL, 0x000217f000021770ULL,
0x000218f000021870ULL, 0x07e0390400021970ULL, 0x000000ff00000210ULL, 0x003f010000018ad0ULL,
0x0000000b00000240ULL, 0x003f012000018ad8ULL, 0x0000000b00000270ULL, 0x003f012000018b58ULL,
0x0000000b000002a0ULL, 0x003f012000018b78ULL, 0x000000ff00000390ULL, 0x003f010000018b88ULL,
0x000000ff00000550ULL, 0x003f010700018ad0ULL, 0x000000ff00000830ULL, 0x0005010200018b5cULL,
0x000000ff00000890ULL, 0x0005010100018b58ULL, 0x000000ff00000a10ULL, 0x003f010100018b88ULL,
0x000000ff00000a50ULL, 0x003f010500018b8cULL, 0x000000ff00000c10ULL, 0x003f010500018b8cULL,
0x000000ff00001640ULL, 0x003f010100018b88ULL, 0x000000ff00001670ULL, 0x003f010500018b8cULL,
0x000000ff00001840ULL, 0x003f010500018b8cULL, 0x000000ff000019b0ULL, 0x003f010700018b78ULL,
0x000000ff00001a30ULL, 0x003f010100018b78ULL, 0x000000ff00001a90ULL, 0x003f010100018b88ULL,
0x000000ff00001d50ULL, 0x003f010500018b7cULL, 0x000000ff00001f10ULL, 0x003f010500018b7cULL,
0x000000ff00001f70ULL, 0x003f010500018b8cULL, 0x000000ff00002140ULL, 0x003f010500018b8cULL,
0x000000ff00002b90ULL, 0x003f010100018b88ULL, 0x000000ff00002bc0ULL, 0x003f010500018b8cULL,
0x000000ff00002d90ULL, 0x003f010500018b8cULL, 0x000000ff00003110ULL, 0x003f010700018b80ULL,
0x000000ff00003190ULL, 0x003f010100018b80ULL, 0x000000ff00003230ULL, 0x0005010100018ad8ULL,
0x000000ff00003260ULL, 0x0005010500018adcULL, 0x000000ff00003430ULL, 0x0005010500018adcULL,
0x000000ff00004ed0ULL, 0x003f010100018b88ULL, 0x000000ff00004fa0ULL, 0x003f010500018b84ULL,
0x000000ff00005160ULL, 0x003f010500018b84ULL, 0x000000ff000051c0ULL, 0x003f010500018b8cULL,
0x000000ff00005390ULL, 0x003f010500018b8cULL, 0x000000ff00005dd0ULL, 0x003f010100018b88ULL,
0x000000ff00005e00ULL, 0x003f010500018b8cULL, 0x000000ff00005fd0ULL, 0x003f010500018b8cULL,
0x000000ff000061a0ULL, 0x003f010700018b78ULL, 0x000000ff00006220ULL, 0x003f010100018b78ULL,
0x000000ff000075d0ULL, 0x003f010100018b88ULL, 0x000000ff00007680ULL, 0x003f010100018b58ULL,
0x000000ff00007760ULL, 0x003f010500018b7cULL, 0x000000ff00007920ULL, 0x003f010500018b7cULL,
0x000000ff00007980ULL, 0x003f010500018b8cULL, 0x000000ff00007b50ULL, 0x003f010500018b8cULL,
0x000000ff00008590ULL, 0x003f010100018b88ULL, 0x000000ff000085c0ULL, 0x003f010500018b8cULL,
0x000000ff00008790ULL, 0x003f010500018b8cULL, 0x000000ff00008ae0ULL, 0x003f010700018b80ULL,
0x000000ff00008b60ULL, 0x003f010100018b80ULL, 0x000000ff00008c00ULL, 0x0005010100018af8ULL,
0x000000ff00008c30ULL, 0x0005010500018afcULL, 0x000000ff00008e00ULL, 0x0005010500018afcULL,
0x000000ff0000a640ULL, 0x003f010100018b88ULL, 0x000000ff0000a720ULL, 0x003f010500018b84ULL,
0x000000ff0000a8e0ULL, 0x003f010500018b84ULL, 0x000000ff0000a940ULL, 0x003f010500018b8cULL,
0x000000ff0000ab10ULL, 0x003f010500018b8cULL, 0x000000ff0000b550ULL, 0x003f010100018b88ULL,
0x000000ff0000b580ULL, 0x003f010500018b8cULL, 0x000000ff0000b750ULL, 0x003f010500018b8cULL,
0x000000ff0000b920ULL, 0x003f010700018b78ULL, 0x000000ff0000b9a0ULL, 0x003f010100018b78ULL,
0x000000ff0000cc40ULL, 0x003f010100018b88ULL, 0x000000ff0000ccd0ULL, 0x003f010100018b60ULL,
0x000000ff0000cdb0ULL, 0x003f010500018b7cULL, 0x000000ff0000cf70ULL, 0x003f010500018b7cULL,
0x000000ff0000cfd0ULL, 0x003f010500018b8cULL, 0x000000ff0000d1a0ULL, 0x003f010500018b8cULL,
0x000000ff0000dbe0ULL, 0x003f010100018b88ULL, 0x000000ff0000dc10ULL, 0x003f010500018b8cULL,
0x000000ff0000dde0ULL, 0x003f010500018b8cULL, 0x000000ff0000e130ULL, 0x003f010700018b80ULL,
0x000000ff0000e1b0ULL, 0x003f010100018b80ULL, 0x000000ff0000e250ULL, 0x0005010100018b18ULL,
0x000000ff0000e280ULL, 0x0005010500018b1cULL, 0x000000ff0000e450ULL, 0x0005010500018b1cULL,
0x000000ff0000fc90ULL, 0x003f010100018b88ULL, 0x000000ff0000fd70ULL, 0x003f010500018b84ULL,
0x000000ff0000ff30ULL, 0x003f010500018b84ULL, 0x000000ff0000ff90ULL, 0x003f010500018b8cULL,
0x000000ff00010160ULL, 0x003f010500018b8cULL, 0x000000ff00010ba0ULL, 0x003f010100018b88ULL,
0x000000ff00010bd0ULL, 0x003f010500018b8cULL, 0x000000ff00010da0ULL, 0x003f010500018b8cULL,
0x000000ff00010f70ULL, 0x003f010700018b78ULL, 0x000000ff00010ff0ULL, 0x003f010100018b78ULL,
0x000000ff00012290ULL, 0x003f010100018b88ULL, 0x000000ff00012320ULL, 0x003f010100018b68ULL,
0x000000ff00012400ULL, 0x003f010500018b7cULL, 0x000000ff000125c0ULL, 0x003f010500018b7cULL,
0x000000ff00012620ULL, 0x003f010500018b8cULL, 0x000000ff000127f0ULL, 0x003f010500018b8cULL,
0x000000ff00013230ULL, 0x003f010100018b88ULL, 0x000000ff00013260ULL, 0x003f010500018b8cULL,
0x000000ff00013430ULL, 0x003f010500018b8cULL, 0x000000ff00013780ULL, 0x003f010700018b80ULL,
0x000000ff00013800ULL, 0x003f010100018b80ULL, 0x000000ff000138a0ULL, 0x0005010100018b38ULL,
0x000000ff000138d0ULL, 0x0005010500018b3cULL, 0x000000ff00013aa0ULL, 0x0005010500018b3cULL,
0x000000ff000152e0ULL, 0x003f010100018b88ULL, 0x000000ff000153c0ULL, 0x003f010500018b84ULL,
0x000000ff00015580ULL, 0x003f010500018b84ULL, 0x000000ff000155e0ULL, 0x003f010500018b8cULL,
0x000000ff000157b0ULL, 0x003f010500018b8cULL, 0x000000ff000161f0ULL, 0x003f010100018b88ULL,
0x000000ff00016220ULL, 0x003f010500018b8cULL, 0x000000ff000163f0ULL, 0x003f010500018b8cULL,
0x000000ff000165c0ULL, 0x003f010700018b78ULL, 0x000000ff00016640ULL, 0x003f010100018b78ULL,
0x000000ff000178e0ULL, 0x003f010100018b88ULL, 0x000000ff00017960ULL, 0x003f010100018b70ULL,
0x000000ff000184d0ULL, 0x003f010100018ad0ULL, 0x000000ff0001a970ULL, 0x003f010500018ad4ULL,
0x000000ff0001ab40ULL, 0x003f010500018ad4ULL, 0x000000ff0001aed0ULL, 0x003f010100018ad0ULL,
0x000000ff0001af10ULL, 0x003f010500018ad4ULL, 0x000000ff0001b0d0ULL, 0x003f010500018ad4ULL,
0x000000520001ec20ULL, 0x003f010100000000ULL, 0x000000520001ee50ULL, 0x003f010500000004ULL,
0x000000520001f020ULL, 0x003f010500000004ULL, 0x0000000500020480ULL, 0x003f010100000000ULL,
0x00000005000204e0ULL, 0x003f010100000008ULL, 0x0000000500020540ULL, 0x003f010100000010ULL,
0x00000005000205b0ULL, 0x003f010100000018ULL, 0x00101c0400053803ULL, 0x0001b130000183d0ULL,
0x000205f00001b200ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000046cULL,
0x0000001b00000002ULL, 0x0000000000000384ULL, 0x0000001b00000002ULL, 0x00000000000002bcULL,
0x0000001b00000002ULL, 0x00000000000001f4ULL, 0x0000001b00000002ULL, 0x0000000000000124ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x0000000000000444ULL,
0x0000001b00000002ULL, 0x000000000000035dULL, 0x0000001b00000002ULL, 0x0000000000000295ULL,
0x0000001b00000002ULL, 0x00000000000001d0ULL, 0x0000001b00000002ULL, 0x00000000000000fdULL,
0x0000001b00000002ULL, 0x0000000000018c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000001379c3ULL, 0x000ea20000002700ULL, 0x00000000000c7806ULL, 0x000fe200038e0000ULL,
0x00005800000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee20000002300ULL,
0x00000200000f7882ULL, 0x000fe20000000000ULL, 0x0000000c00067300ULL, 0x000fe200000e0000ULL,
0x00005c0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000f220000002200ULL,
0x00000000000d79c3ULL, 0x000ea20000002600ULL, 0x0000460000107ab9ULL, 0x000fc40000000a00ULL,
0x00000000000d7919ULL, 0x000ea40000000000ULL, 0x0000000c000c7309ULL, 0x000ee40000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000005ff007819ULL, 0x002fc6000001160bULL,
0x00001fff03047589ULL, 0x008e6200000e0000ULL, 0x000000ffff0c7224ULL, 0x000fc600078e0a0cULL,
0x00001fff00007589ULL, 0x000ee200000e0000ULL, 0x0000010003027a24ULL, 0x010fc800078e0202ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000070600720cULL, 0x004fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x040fe40003f44070ULL, 0x0000007f0b00780cULL, 0x040fe40003f64070ULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00000000041273c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000000000873c2ULL, 0x008ea200000e0000ULL,
0x3fffffc0ff049424ULL, 0x002fe200078e00ffULL, 0x018ad002ff00d388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07a424ULL, 0x000fe200078e00ffULL,
0x018ad8040b009388ULL, 0x0007e20000008a00ULL, 0xff317217ff0ab424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08c424ULL, 0x000fe200078e00ffULL, 0x018b58060b00a388ULL, 0x0009e20000008a00ULL,
0x7fffff00ff09c424ULL, 0x000fc600078e00ffULL, 0x0184000a0b00b388ULL, 0x000fe80000004800ULL,
0x018b78080b00c388ULL, 0x000fe20000008a00ULL, 0x0000000812047291ULL, 0x004fc8000f8e103fULL,
0x00000001040a7899ULL, 0x000fe4000800063fULL, 0x000000020e047899ULL, 0x000fe4000800063fULL,
0x000000010a0c7890ULL, 0x000fe4000fffe03fULL, 0x0000000aff027e24ULL, 0x002fe2000f8e00ffULL,
0x0000000a0d007c10ULL, 0x000fe2000fffe0ffULL, 0x00000013040972a4ULL, 0x000fe4000f8e020dULL,
0x0000002002057824ULL, 0x008fe200078e00ffULL, 0x000000040a00788cULL, 0x000fe2000bf01070ULL,
0x3fffff80ff02d424ULL, 0x000fe200078e00ffULL, 0x0000000e0a0472a4ULL, 0x000fc4000f8e0209ULL,
0xffffffe005047812ULL, 0x000fe200078ee200ULL, 0x0000000cff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000040a0b7887ULL, 0x000fe2000c000000ULL, 0x018b8802ff00d388ULL, 0x000fe20000000a00ULL,
0x0000000f040472a5ULL, 0x000fe2000f8e0006ULL, 0x0000002000067824ULL, 0x010fe200078e00ffULL,
0x0000000b0a0b7290ULL, 0x000fe2000fffe13fULL, 0x000000100d007824ULL, 0x040fe200078e00ffULL,
0x0000000e0c0972a4ULL, 0x000fe2000f8e0209ULL, 0x0000000c0d057c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b00788cULL, 0x000fe2000bf03070ULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x000001f000007812ULL, 0x000fe200078ec0ffULL, 0x0000000f090672a5ULL, 0x000fe2000f8e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400027c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000400097882ULL, 0x000fe20000000000ULL, 0x0000000bff007c0cULL, 0x000fe2000bf26070ULL,
0x00000002130a7899ULL, 0x000fe2000800063fULL, 0xffffffe006067812ULL, 0x000fe200078ee205ULL,
0x00000005ff037e24ULL, 0x000fe200090e06ffULL, 0x000000000000781cULL, 0x000fc40003f4f008ULL,
0x0000000600047c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e000cULL, 0x00000007ff057e24ULL, 0x000fe400098e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c50ULL,
0x0000000004097faeULL, 0x0003e8000d101c50ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x018ad400ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000620000047ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL, 0x00006a0000067ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL, 0x00000004ff5c7e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff5d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL, 0x000000105c5c7981ULL, 0x000ea8000c1e1900ULL,
0x0000001002027981ULL, 0x000ee2000c1e1900ULL, 0x00000012ff007c0cULL, 0x000fc4000bf05270ULL,
0x0000007f5c5a7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff5c0a7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff597819ULL, 0x008fe40000011602ULL, 0x00000007ff5a7819ULL, 0x000fe4000001165aULL,
0x00000008ff5b7819ULL, 0x000fc6000001160aULL, 0x00017d0000008947ULL, 0x000fea0003800000ULL,
0x00000008ff007e24ULL, 0x000fe2000f8e00ffULL, 0x0000000308057899ULL, 0x000fe2000800063fULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x00000003ff047424ULL, 0x000fe400078e00ffULL,
0x0000002000057824ULL, 0x000fca00078e020dULL, 0x0000001f0500780cULL, 0x040fe40003f04070ULL,
0x000000030500780cULL, 0x000fd60003f24070ULL, 0x0000007000000947ULL, 0x000fea0003800000ULL,
0x0000000aff027e24ULL, 0x000fe2000f8e00ffULL, 0x0000005c0500720cULL, 0x040fe20003f06070ULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00018a0005077811ULL, 0x000fe200078e10ffULL,
0x0000680002027a24ULL, 0x000fc800078e0205ULL, 0x0000660002027625ULL, 0x000fcc00078e0003ULL,
0x0000000002077faeULL, 0x0003e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b5c04ffff798cULL, 0x0005e20008000005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b5800ffff7f8cULL, 0x000fe2000c800405ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x002e620000002700ULL, 0x00006400ff037624ULL, 0x000fe200078e00ffULL,
0x000000ff5a00720cULL, 0x000fe20003f05270ULL, 0x00000004ff077424ULL, 0x000fe400078e00ffULL,
0x0000000402027824ULL, 0x002fe200078e0205ULL, 0x00018ac005057811ULL, 0x000fc600078e10ffULL,
0x0000000202027824ULL, 0x000fc800078e00ffULL, 0x0000640002027624ULL, 0x000fc800078e0203ULL,
0x0000600002027625ULL, 0x000fca00078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e40008121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff027f8cULL, 0x002e62000c80043fULL,
0x000000ffff067224ULL, 0x000fe400078e00ffULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018b8c00ff047984ULL, 0x004e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000106067810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018b8c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000577919ULL, 0x000e620000002600ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000008057577824ULL, 0x002fd200078e00ffULL, 0x000004f000000947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0x000000055c027c17ULL, 0x000fe2000f800000ULL,
0x00000100ff0f7424ULL, 0x000fc600078e00ffULL, 0x8000000502067c10ULL, 0x000fe4000fffe0ffULL,
0x00000004ff077819ULL, 0x002fe20000011611ULL, 0x00000010110d7824ULL, 0x000fc600078e00ffULL,
0x0000000507087c10ULL, 0x000fe4000fffe0ffULL, 0x000000f00d0d7812ULL, 0x000fe400078ec0ffULL,
0x000000060700720cULL, 0x000fe20003f06070ULL, 0x018a000008047984ULL, 0x000e620000004800ULL,
0x0000000157037824ULL, 0x000fe400078e0208ULL, 0x0000000108057824ULL, 0x040fe400078e0211ULL,
0x00000010080a7824ULL, 0x000fe200078e00ffULL, 0x018ac00004047984ULL, 0x002e640000004800ULL,
0x0000000404037c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0003027625ULL, 0x000fca00078e000fULL,
0x0000000d02047210ULL, 0x000fe40007f3e0ffULL, 0xfffffff00a027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200008e0603ULL, 0x0001400002097811ULL, 0x000fe400078e20ffULL,
0x0000000207037810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000c101c50ULL, 0x00000005030a7c10ULL, 0x040fe4000fffe0ffULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x018a0800080b7984ULL, 0x000ea40000004800ULL,
0x0000000157027824ULL, 0x000fe400078e020aULL, 0x000000010a0c7824ULL, 0x040fe400078e0211ULL,
0x000000100a137824ULL, 0x000fca00078e00ffULL, 0xfffffff0130c7812ULL, 0x000fc800078ee20cULL,
0x000140000c097811ULL, 0x002fe200078e20ffULL, 0x018ac0000b0b7984ULL, 0x004e640000004800ULL,
0x000000040b027c24ULL, 0x002fc8000f8e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000000d02047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200008e0603ULL,
0x0000000407037810ULL, 0x040fe40007ffe0ffULL, 0x0000000607077810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e2000c101c50ULL,
0x00000005030a7c10ULL, 0x040fe4000fffe0ffULL, 0x000000060300720cULL, 0x000fe20003f06070ULL,
0x018a1000080b7984ULL, 0x000ea40000004800ULL, 0x0000000157027824ULL, 0x000fc400078e020aULL,
0x000000010a0c7824ULL, 0x040fe400078e0211ULL, 0x000000100a137824ULL, 0x000fe200078e00ffULL,
0x00000005070a7c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff0130c7812ULL, 0x000fc800078ee20cULL,
0x000140000c097811ULL, 0x002fe200078e20ffULL, 0x018ac0000b0b7984ULL, 0x004e640000004800ULL,
0x000000040b027c24ULL, 0x002fc8000f8e0202ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000000d02047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe400008e0603ULL,
0x0000000157037824ULL, 0x000fc600078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e2000c101c50ULL, 0x000000060700720cULL, 0x000fe20003f06070ULL,
0x000000010a067824ULL, 0x040fe400078e0211ULL, 0x018a180008087984ULL, 0x000ea20000004800ULL,
0x000000100a077824ULL, 0x000fca00078e00ffULL, 0xfffffff007067812ULL, 0x000fc800078ee206ULL,
0x0001400006057811ULL, 0x002fe200078e20ffULL, 0x018ac00008027984ULL, 0x004e640000004800ULL,
0x0000000402027c24ULL, 0x002fc8000f8e0203ULL, 0x00005e0002027625ULL, 0x000fca00078e000fULL,
0x0000000d02027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e2000c101c50ULL,
0x0000044000007947ULL, 0x000fea0003800000ULL, 0x00000000000b7919ULL, 0x000e620000000000ULL,
0x00000100ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000050b087c11ULL, 0x042fe2000f8fe0ffULL,
0x000000100b027824ULL, 0x000fc800078e00ffULL, 0x018a000008067984ULL, 0x000e620000004800ULL,
0x0000000157037824ULL, 0x000fe200078e0208ULL, 0x000000f0020d7812ULL, 0x000fe200078ec0ffULL,
0x0000000108057824ULL, 0x040fe400078e020bULL, 0x00000010080a7824ULL, 0x000fe200078e00ffULL,
0x018ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406037c24ULL, 0x002fe2000f8e0203ULL,
0x0000000208067810ULL, 0x000fc60007ffe0ffULL, 0x00005e0003027625ULL, 0x000fc800078e000cULL,
0x0000000106077824ULL, 0x000fe200078e020bULL, 0x0000000d02047210ULL, 0x000fe20007f1e0ffULL,
0x00000010060e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00a027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe200000e0603ULL, 0x0001400002097811ULL, 0x000fe200078e20ffULL,
0x0000000157037824ULL, 0x000fc800078e0206ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004097faeULL, 0x0003e8000b901c50ULL, 0x018a0800080a7984ULL, 0x000ea20000004800ULL,
0x0000000408047810ULL, 0x002fca0007ffe0ffULL, 0x0000000104057824ULL, 0x000fe200078e020bULL,
0x018ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a037c24ULL, 0x002fc8000f8e0203ULL,
0x00005e0003027625ULL, 0x000fca00078e000cULL, 0x0000000d02067210ULL, 0x000fe40007f1e0ffULL,
0xfffffff00e027812ULL, 0x000fe200078ee207ULL, 0x00000010040e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200000e0603ULL, 0x0001400002097811ULL, 0x000fe200078e20ffULL,
0x0000000157037824ULL, 0x000fc800078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c50ULL, 0x018a1000080a7984ULL, 0x000ea20000004800ULL,
0x0000000608067810ULL, 0x002fc60007ffe0ffULL, 0x018ac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a037c24ULL, 0x002fe4000f8e0203ULL, 0x00000001060a7824ULL, 0x000fe400078e020bULL,
0x00005e0003027625ULL, 0x000fc800078e000cULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000d02047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff00e027812ULL, 0x000fe400078ee205ULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff057224ULL, 0x000fe200000e0603ULL,
0x0001400002077811ULL, 0x000fe200078e20ffULL, 0x0000000157027824ULL, 0x000fc800078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c50ULL,
0x018a180008097984ULL, 0x000ea20000004800ULL, 0x000140000a057811ULL, 0x002fc600078e20ffULL,
0x018ac00009097984ULL, 0x004e640000004800ULL, 0x0000000409027c24ULL, 0x002fc8000f8e0202ULL,
0x00005e0002027625ULL, 0x000fca00078e000cULL, 0x0000000d02027210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fca00000e0603ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e6000b901c50ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff027f8cULL, 0x002e64000c80043fULL, 0x000000ffff097224ULL, 0x002fc400078e0003ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x018b8c00ff047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000106067810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018b8c00ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002000027824ULL, 0x002fca00078e0203ULL,
0x0000001f0200780cULL, 0x000fda0003f04070ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000000aff077e24ULL, 0x000fe2000f8e00ffULL, 0x0000002002057810ULL, 0x000fc60007ffe0ffULL,
0x0000680007047a24ULL, 0x000fe200078e0202ULL, 0x0000005c0500720cULL, 0x000fe20003f06070ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x00018a0002077811ULL, 0x000fe400078e10ffULL,
0x0000002004047810ULL, 0x000fca0007ffe0ffULL, 0x0000660004047625ULL, 0x000fca00078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e4000c121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff047f8cULL, 0x002e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ff5b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff677224ULL, 0x002fe200078e0005ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000ffff587224ULL, 0x000fe200078e00ffULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x000000ffff567224ULL, 0x000fe200078e00ffULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff027224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x000000ffff127224ULL, 0x000fc400078e00ffULL,
0x000000ffff257224ULL, 0x004fe400078e0007ULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x00015db000008947ULL, 0x000fea0003800000ULL, 0x00005800ff167624ULL, 0x000fe200078e00ffULL,
0x00015d9000007945ULL, 0x000fe20003800000ULL, 0xff317217ff137424ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x0000008016167824ULL, 0x000fc600078e00ffULL, 0x0000010014177824ULL, 0x000fca00078e00ffULL,
0x0000005c1700720cULL, 0x000fda0003f06070ULL, 0x00015cd000000947ULL, 0x002fea0003800000ULL,
0x000000ffff667224ULL, 0x000fc600078e00ffULL, 0x000000145900720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff1d7819ULL, 0x000fe20000011666ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x0000000366177812ULL, 0x040fe400078ec0ffULL,
0x0000001d661d7207ULL, 0x000fe40002800000ULL, 0x000000ff17177207ULL, 0x000fe40006800000ULL,
0x000000031d217812ULL, 0x000fc400078ec0ffULL, 0x000000141d1c7211ULL, 0x002fc400078ff0ffULL,
0x0000000000227805ULL, 0x000fca0000015200ULL, 0x018b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002622297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e23ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc80000011427ULL,
0x000000291e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x000000021e1e7819ULL, 0x000fc80000001227ULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fc40000015200ULL, 0x018b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002622297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e23ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc80000011427ULL, 0x000000291e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x000000021e1e7819ULL, 0x000fc80000001227ULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000120207810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000011c1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000041c207824ULL, 0x000fe200078e0221ULL, 0x0000098000017945ULL, 0x000fe40003800000ULL,
0x0000005b1e00720cULL, 0x000fe40003f06070ULL, 0x0000002020257811ULL, 0x000fc800078e30ffULL,
0x0000006057287812ULL, 0x000fce00078ef825ULL, 0x0000050000008947ULL, 0x000fea0003800000ULL,
0x00000004ff297819ULL, 0x000fe20000011603ULL, 0x0000001003247824ULL, 0x000fe200078e00ffULL,
0x000000255c1e7217ULL, 0x000fe20007800000ULL, 0x00000100ff2b7424ULL, 0x000fe200078e00ffULL,
0x0000000529267c10ULL, 0x040fe4000fffe0ffULL, 0x000000f0242d7812ULL, 0x000fe200078ec0ffULL,
0x000000011e1e7824ULL, 0x000fe200078e0a25ULL, 0x00000002292f7810ULL, 0x000fe20007ffe0ffULL,
0x018a000026207984ULL, 0x000e620000004800ULL, 0x0000000126227824ULL, 0x000fc400078e0228ULL,
0x000000051e1e7c17ULL, 0x000fe2000f800000ULL, 0x0000000126257824ULL, 0x000fe200078e0203ULL,
0x000000052f2a7c10ULL, 0x000fe4000fffe0ffULL, 0x800000051e1e7c10ULL, 0x000fc6000fffe0ffULL,
0x000000012a2c7824ULL, 0x000fe200078e0203ULL, 0x0000001e2900720cULL, 0x000fe20003f06070ULL,
0x018ac00020237984ULL, 0x0022a40000004800ULL, 0x0000001026207824ULL, 0x002fca00078e00ffULL,
0xfffffff020277812ULL, 0x000fc800078ee225ULL, 0x0001600027277811ULL, 0x000fe200078e20ffULL,
0x0000002316227224ULL, 0x004fc800078e0222ULL, 0x00005e0022227625ULL, 0x000fca00078e002bULL,
0x0000002d22247210ULL, 0x000fe20007f3e0ffULL, 0x000000012a227824ULL, 0x000fc800078e0228ULL,
0x000000ffff257224ULL, 0x000fca00008e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000001e2f00720cULL, 0x000fe20003f06070ULL,
0x000000102a2f7824ULL, 0x000fe400078e00ffULL, 0x018a080026207984ULL, 0x000ea60000004800ULL,
0xfffffff02f277812ULL, 0x002fe400078ee22cULL, 0x00000004292f7810ULL, 0x000fe40007ffe0ffULL,
0x0001600027277811ULL, 0x000fc400078e20ffULL, 0x000000052f2a7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000629297810ULL, 0x000fc60007ffe0ffULL, 0x000000012a2c7824ULL, 0x000fe200078e0203ULL,
0x018ac00020237984ULL, 0x004e640000004800ULL, 0x0000002316227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fca00078e002bULL, 0x0000002d22247210ULL, 0x000fe20007f3e0ffULL,
0x000000012a227824ULL, 0x000fc800078e0228ULL, 0x000000ffff257224ULL, 0x000fca00008e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000c101c50ULL,
0x0000001e2f00720cULL, 0x000fe20003f06070ULL, 0x000000102a2f7824ULL, 0x000fe200078e00ffULL,
0x00000005292a7c10ULL, 0x000fe2000fffe0ffULL, 0x018a100026207984ULL, 0x000ea60000004800ULL,
0xfffffff02f277812ULL, 0x002fc800078ee22cULL, 0x0001600027277811ULL, 0x000fe200078e20ffULL,
0x018ac00020237984ULL, 0x004e640000004800ULL, 0x0000002316227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fca00078e002bULL, 0x0000002d22247210ULL, 0x000fe20007f3e0ffULL,
0x000000012a227824ULL, 0x040fe400078e0228ULL, 0x000000012a287824ULL, 0x000fe400078e0203ULL,
0x000000ffff257224ULL, 0x000fca00008e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000001e2900720cULL, 0x000fe20003f06070ULL,
0x000000102a297824ULL, 0x000fe400078e00ffULL, 0x018a180026207984ULL, 0x000ea60000004800ULL,
0xfffffff029257812ULL, 0x002fc800078ee228ULL, 0x0001600025257811ULL, 0x000fe200078e20ffULL,
0x018ac00020237984ULL, 0x004e640000004800ULL, 0x0000002316227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fca00078e002bULL, 0x0000002d22227210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff237224ULL, 0x000fca00008e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005032a7c11ULL, 0x040fe2000f8fe0ffULL, 0x0000001003227824ULL, 0x000fe400078e00ffULL,
0x00000100ff2c7424ULL, 0x000fe200078e00ffULL, 0x000000022a267810ULL, 0x040fe20007ffe0ffULL,
0x018a00002a1e7984ULL, 0x000e620000004800ULL, 0x000000012a207824ULL, 0x000fe200078e0228ULL,
0x000000f0222b7812ULL, 0x000fe200078ec0ffULL, 0x000000102a257824ULL, 0x000fe400078e00ffULL,
0x0000001026277824ULL, 0x000fe200078e00ffULL, 0x018ac0001e237984ULL, 0x002e640000004800ULL,
0x0000002316237224ULL, 0x002fc400078e0220ULL, 0x000000012a207824ULL, 0x000fe400078e0203ULL,
0x00005e0023227625ULL, 0x000fc600078e002cULL, 0xfffffff025207812ULL, 0x000fe400078ee220ULL,
0x0000002b22247210ULL, 0x000fe40007f1e0ffULL, 0x0001600020297811ULL, 0x000fe200078e20ffULL,
0x0000000126207824ULL, 0x000fe400078e0228ULL, 0x000000ffff257224ULL, 0x000fca00000e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000b901c50ULL,
0x018a08002a1e7984ULL, 0x000ea20000004800ULL, 0x000000042a247810ULL, 0x002fca0007ffe0ffULL,
0x0000001024257824ULL, 0x000fe200078e00ffULL, 0x018ac0001e237984ULL, 0x004e640000004800ULL,
0x0000002316237224ULL, 0x002fe400078e0220ULL, 0x0000000126207824ULL, 0x000fe400078e0203ULL,
0x00005e0023227625ULL, 0x000fc600078e002cULL, 0xfffffff027207812ULL, 0x000fe400078ee220ULL,
0x0000002b22267210ULL, 0x000fe40007f1e0ffULL, 0x0001600020297811ULL, 0x000fe200078e20ffULL,
0x0000000124207824ULL, 0x000fe400078e0228ULL, 0x000000ffff277224ULL, 0x000fca00000e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c50ULL,
0x018a10002a1e7984ULL, 0x000ea20000004800ULL, 0x000000062a267810ULL, 0x002fca0007ffe0ffULL,
0x0000001026297824ULL, 0x000fe200078e00ffULL, 0x018ac0001e237984ULL, 0x004e640000004800ULL,
0x0000002316237224ULL, 0x002fe400078e0220ULL, 0x0000000124207824ULL, 0x000fe400078e0203ULL,
0x00005e0023227625ULL, 0x000fc600078e002cULL, 0xfffffff025207812ULL, 0x000fe400078ee220ULL,
0x0000002b22247210ULL, 0x000fe40007f1e0ffULL, 0x0001600020277811ULL, 0x000fe200078e20ffULL,
0x0000000126207824ULL, 0x000fe400078e0228ULL, 0x000000ffff257224ULL, 0x000fca00000e0623ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e8000b901c50ULL,
0x018a18002a1e7984ULL, 0x000ea80000004800ULL, 0x018ac0001e237984ULL, 0x004ea40000004800ULL,
0x0000002316237224ULL, 0x004fc400078e0220ULL, 0x0000000126207824ULL, 0x000fe400078e0203ULL,
0x00005e0023227625ULL, 0x000fc600078e002cULL, 0xfffffff029207812ULL, 0x000fe400078ee220ULL,
0x0000002b22227210ULL, 0x000fe40007f1e0ffULL, 0x0001600020257811ULL, 0x002fc600078e20ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022257faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff227f8cULL, 0x002e64000c80043fULL,
0x000000ffff297224ULL, 0x002fc400078e0023ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0x018b8c00ff1e7984ULL, 0x000e640000000800ULL, 0x800000001eff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fcc0000015200ULL, 0x0000002422277210ULL, 0x000fca0007f1e1ffULL,
0x0000000125257824ULL, 0x000fe200000e0e23ULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc80000011425ULL,
0x000000271e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x000000021e1e7819ULL, 0x000fc80000001225ULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000120207810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff1e7984ULL, 0x000e640000000800ULL,
0x800000001eff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000001c5900720cULL, 0x080fe20003f24070ULL, 0x0000022000017945ULL, 0x000fe20003800000ULL,
0x00000001171e7810ULL, 0x000fe40007ffe0ffULL, 0x0000001c5900720cULL, 0x000fe40003f04070ULL,
0x000000031e207812ULL, 0x000fc400078ec0ffULL, 0x000000011d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000031700780cULL, 0x000fe20004705270ULL, 0x0000002000177824ULL, 0x000fe200078e0203ULL,
0x000000ff20207207ULL, 0x000fe40004800000ULL, 0x00000002ff1e9819ULL, 0x000fe4000001161eULL,
0x000000011d00780cULL, 0x000fe40000705470ULL, 0x0000001f1700780cULL, 0x000fe20003f84070ULL,
0x0000000121217824ULL, 0x000fc800078e021eULL, 0x00000040211e7824ULL, 0x040fe200078e00ffULL,
0x0000001c211c7211ULL, 0x000fc800078ff0ffULL, 0x000000c01e1d7812ULL, 0x000fca00078ec0ffULL,
0x000001001c1e7824ULL, 0x000fe200078e021dULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000020001d7824ULL, 0x000fe200078e0203ULL, 0x0000000115157810ULL, 0x000fc80007ffe0ffULL,
0x000000031d00780cULL, 0x000fda0003f04070ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000001c7919ULL, 0x000e620000002700ULL, 0x0000005a1500720cULL, 0x040fe20003f06070ULL,
0x00000004ff237424ULL, 0x000fe400078e00ffULL, 0x000000041c217824ULL, 0x002fe200078e021dULL,
0x00006400151c7a10ULL, 0x000fc60007ffe0ffULL, 0x0000000221217824ULL, 0x000fc800078e00ffULL,
0x00006400211c7a24ULL, 0x000fe200078e021cULL, 0x00018ac01d217811ULL, 0x000fc600078e10ffULL,
0x000060001c1c7625ULL, 0x000fca00078e0023ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000e000017945ULL, 0x000fe20003800000ULL, 0x000000c000004947ULL, 0x000fea0003800000ULL,
0x0000000a201c7c10ULL, 0x002fe2000fffe0ffULL, 0x00000001171d7824ULL, 0x040fe200078e021eULL,
0x00018a0017217811ULL, 0x000fc600078e10ffULL, 0x000068001c1c7a24ULL, 0x000fe200078e021eULL,
0x0000005c1d00720cULL, 0x000fe20003f06070ULL, 0x00000004ff1d7424ULL, 0x000fe400078e00ffULL,
0x00000001171c7824ULL, 0x000fc800078e021cULL, 0x000066001c1c7625ULL, 0x000fcc00078e001dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8000ff1c7f8cULL, 0x000e62000c80043fULL,
0x000000ff6600720cULL, 0x000fe20003f05270ULL, 0x0000080000017945ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x002fd600078e001dULL, 0x000007d000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018ad800ff1c7f8cULL, 0x000e64000c800405ULL,
0x000000ffff257224ULL, 0x002fc400078e001dULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x018adc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011421ULL,
0x0000002318187211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000218187819ULL, 0x000fc80000001221ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x018adc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fc80000011603ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1d7812ULL, 0x000fca00078ec0ffULL,
0x00000001181d7824ULL, 0x000fca00078e021dULL, 0x018000001d1c7984ULL, 0x000e680000000800ULL,
0x018200001d1e7984ULL, 0x0004e20000000800ULL, 0x000000131c00720bULL, 0x002fe20003f1d000ULL,
0x0001d0f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL, 0x0000045000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x000fd200078e0013ULL,
0x0000041000008947ULL, 0x000fea0003800000ULL, 0x00000008ff007c0cULL, 0x000fe4000bf05270ULL,
0x000000131c00720bULL, 0x000fe20003f34000ULL, 0x0001d0c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000237806ULL, 0x000fc400008e0100ULL, 0x0000001c13227209ULL, 0x000fe20007810000ULL,
0x0000035000037945ULL, 0x000fe20003800000ULL, 0x0000991023207816ULL, 0x000fc600000000ffULL,
0x018400221d008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000002213137221ULL, 0x002fe20000010000ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300247308ULL, 0x000e640000000800ULL,
0x0000002412127220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe20000011603ULL, 0x0001d0227f007947ULL, 0x000fea000b800000ULL,
0x00001f1324137589ULL, 0x0002a400000e0000ULL, 0x0000001311117220ULL, 0x084fe40000410000ULL,
0x0000001310107220ULL, 0x080fe40000410000ULL, 0x000000130d0d7220ULL, 0x080fe40000410000ULL,
0x000000130c0c7220ULL, 0x080fe40000410000ULL, 0x0000001309097220ULL, 0x080fe40000410000ULL,
0x0000001308087220ULL, 0x000fc40000410000ULL, 0x0000001305057220ULL, 0x080fe40000410000ULL,
0x0000001304047220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000134a4a7220ULL, 0x080fe40000410000ULL, 0x000000134b4b7220ULL, 0x080fe40000410000ULL,
0x000000134e4e7220ULL, 0x000fc40000410000ULL, 0x000000134f4f7220ULL, 0x080fe40000410000ULL,
0x0000001352527220ULL, 0x080fe40000410000ULL, 0x0000001353537220ULL, 0x080fe40000410000ULL,
0x0000001356567220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803137811ULL, 0x000fe200078ff0ffULL, 0x0001cf427f007947ULL, 0x000fea000b800000ULL,
0x00001f1324137589ULL, 0x00046400000e0000ULL, 0x000000130f0f7220ULL, 0x082fe40000410000ULL,
0x000000130e0e7220ULL, 0x080fe40000410000ULL, 0x000000130b0b7220ULL, 0x080fe40000410000ULL,
0x000000130a0a7220ULL, 0x080fe40000410000ULL, 0x0000001307077220ULL, 0x080fe40000410000ULL,
0x0000001306067220ULL, 0x000fc40000410000ULL, 0x0000001302027220ULL, 0x080fe40000410000ULL,
0x0000001348487220ULL, 0x080fe40000410000ULL, 0x0000001349497220ULL, 0x080fe40000410000ULL,
0x000000134c4c7220ULL, 0x080fe40000410000ULL, 0x000000134d4d7220ULL, 0x080fe40000410000ULL,
0x0000001350507220ULL, 0x000fc40000410000ULL, 0x0000001351517220ULL, 0x080fe40000410000ULL,
0x0000001354547220ULL, 0x080fe40000410000ULL, 0x0000001355557220ULL, 0x080fe40000410000ULL,
0x0000001358587220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fda0007806023ULL, 0x800000221c1c0221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c00190308ULL, 0x000e640000000800ULL, 0x000000191e1e0220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x000000121e127221ULL, 0x008fe40000010000ULL,
0x000000ffff137224ULL, 0x000fc400078e0022ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000017945ULL, 0x000fd80003800000ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fe400000000ffULL,
0x00000002ff1d7819ULL, 0x000fe40000011603ULL, 0x000054101a1c7816ULL, 0x000fe2000000001aULL,
0x0001cd927f007947ULL, 0x000fea000b800000ULL, 0x00001f1d1c1a7589ULL, 0x0002e400000e0000ULL,
0x000000081d1b7810ULL, 0x000fe20007ffe0ffULL, 0x0001cde27f007947ULL, 0x000fea000b800000ULL,
0x00001f1b1c1b7589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000101d277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e001cULL,
0x00003ae000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0001e07000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000181d277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x004fe200078e001cULL, 0x00003b5000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0001e00000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000803687812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff1d7819ULL, 0x102fe20000011603ULL, 0x0000000208047891ULL, 0x000fe2000f8e103fULL,
0x0000000768687812ULL, 0x000fe200078ef803ULL, 0x0000119000017945ULL, 0x000fe20003800000ULL,
0x00000007036e7812ULL, 0x000fe200078ec0ffULL, 0x0000000400657824ULL, 0x000fe200078e021dULL,
0x00000010682e7812ULL, 0x040fe200078efcffULL, 0x0000001068217824ULL, 0x040fe200078e00ffULL,
0x000000041d697c10ULL, 0x000fe2000fffe0ffULL, 0x00000001681c7824ULL, 0x000fe200078e0265ULL,
0x000000042e637c10ULL, 0x000fe2000fffe01dULL, 0x0000000165647824ULL, 0x000fe200078e022eULL,
0x000000086e6e7812ULL, 0x000fe200078ef803ULL, 0x000000102e257824ULL, 0x040fe200078e00ffULL,
0xfffffff0211c7812ULL, 0x000fe200078ee21cULL, 0x000000102e2e7824ULL, 0x000fe200078e00ffULL,
0x000000145900720cULL, 0x000fe20003fc3070ULL, 0x000000011d6a7824ULL, 0x000fe200078e026eULL,
0x000140001c1c7811ULL, 0x000fe200078e20ffULL, 0x000000086e5f7824ULL, 0x000fe200078e00ffULL,
0xfffffff025647812ULL, 0x000fc400078ee264ULL, 0xfffffff02e637812ULL, 0x000fe200078ee263ULL,
0x000000001c20783bULL, 0x000e620000004200ULL, 0x00014000641e7811ULL, 0x000fe400078e20ffULL,
0x00014000635d7811ULL, 0x000fe400078e20ffULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee26aULL,
0x000000001e24783bULL, 0x004fe20000004200ULL, 0x000000026a607810ULL, 0x000fe40007ffe0ffULL,
0x000120005f447811ULL, 0x000fe200078e20ffULL, 0x000000005d34783bULL, 0x000fe20000004200ULL,
0x000000145900720cULL, 0x000fc80003f03070ULL, 0x000000004444783bULL, 0x000ea20000000200ULL,
0x00000018ff2b7819ULL, 0x002fe20000011420ULL, 0x0000010020297824ULL, 0x040fe200078e00ffULL,
0x0000888020287816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe20000011421ULL, 0x00000100212c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011429ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000888021297816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff317819ULL, 0x000fe40000011423ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000002000807306ULL, 0x0003e20000200c00ULL,
0x00008880232e7816ULL, 0x000fe200000000ffULL, 0x0000001a44449232ULL, 0x08cfe20000000000ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000001a46469232ULL, 0x000fe20000000000ULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0000001b45459232ULL, 0x080fe20000000000ULL,
0x00000018ff7d7819ULL, 0x000fe20000011424ULL, 0x00000021002f7306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x002fe200078e00ffULL, 0x0000888024827816ULL, 0x000fe200000000ffULL,
0x0000001b47479232ULL, 0x000fe20000000000ULL, 0x00000018ff7c7819ULL, 0x000fc40000011425ULL,
0x00000018ff2d7819ULL, 0x000fe20000011420ULL, 0x0000000168207824ULL, 0x040fe200078e0269ULL,
0x0000002c00427306ULL, 0x0003e20000200c00ULL, 0x0000001068217824ULL, 0x004fe200078e00ffULL,
0x0000888025847816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011426ULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000010023217824ULL, 0x040fe200078e00ffULL,
0x0000002800287306ULL, 0x000fe20000200c00ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00014000205e7811ULL, 0x000fe200078e20ffULL, 0x0000010024207824ULL, 0x040fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x000000005e38783bULL, 0x000ea20000004200ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000002100817306ULL, 0x0007e20000200c00ULL,
0x00008880222c7816ULL, 0x042fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff3e7819ULL, 0x000fe40000011427ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000002000837306ULL, 0x0003e20000200c00ULL,
0x0000010025217824ULL, 0x048fe200078e00ffULL, 0x0000888026797816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x0000888027787816ULL, 0x000fe400000000ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002300327306ULL, 0x0007e20000200c00ULL,
0x0000010026207824ULL, 0x042fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc40000011434ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002100857306ULL, 0x0003e20000200c00ULL,
0x000000086e237824ULL, 0x008fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000888034717816ULL, 0x000fe400000000ffULL, 0xfffffff823607812ULL, 0x000fe400078ee260ULL,
0x00000020007a7306ULL, 0x0007e20000200c00ULL, 0x0000010027217824ULL, 0x042fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011435ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000888035727816ULL, 0x000fc400000000ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002200337306ULL, 0x000fe20000200c00ULL, 0x0000010034207824ULL, 0x048fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x004fe40000011438ULL, 0x00000018ff747819ULL, 0x000fe40000011420ULL,
0x0001200060207811ULL, 0x000fe200078e20ffULL, 0x00000021007b7306ULL, 0x0003e20000200c00ULL,
0x0000888038417816ULL, 0x000fc400000000ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff3d7819ULL, 0x000fe40000011439ULL, 0x00000018ff767819ULL, 0x000fe2000001143aULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x00000018ff737819ULL, 0x000fe4000001143bULL, 0x0000888036617816ULL, 0x000fe400000000ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011436ULL, 0x0000002900297306ULL, 0x000ea20000200c00ULL,
0x00000018ff6b7819ULL, 0x000fce0000011437ULL, 0x00000024007e7306ULL, 0x0007f00000200c00ULL,
0x00000025007f7306ULL, 0x0005e20000200c00ULL, 0x0000010035247824ULL, 0x048fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002600777306ULL, 0x000fe20000200c00ULL, 0x0000541029257816ULL, 0x004fe20000000042ULL,
0x0001000038297824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000888039427816ULL, 0x000fe400000000ffULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002400757306ULL, 0x0005e20000200c00ULL, 0x0000001a20209232ULL, 0x002fc40000000000ULL,
0x0000001a22229232ULL, 0x000fe40000000000ULL, 0x0000001b21219232ULL, 0x080fe40000000000ULL,
0x0000001b23239232ULL, 0x000fe20000000000ULL, 0x0000002700437306ULL, 0x0003e20000200c00ULL,
0x0000541028247816ULL, 0x004fe2000000003fULL, 0x0000010038287824ULL, 0x000fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x000000244424723cULL, 0x002f6e00000018ffULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000002a002a7306ULL, 0x000ff00000200c00ULL, 0x0000002c002c7306ULL, 0x000ff00000200c00ULL,
0x0000002d002d7306ULL, 0x000e700000200c00ULL, 0x0000002800387306ULL, 0x0005f00000200c00ULL,
0x00000029003f7306ULL, 0x0007e20000200c00ULL, 0x0000541082287816ULL, 0x004fc40000000083ULL,
0x000054102c2c7816ULL, 0x002fe4000000002dULL, 0x000088803a827816ULL, 0x000fc600000000ffULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x0000541084297816ULL, 0x008fce0000000085ULL,
0x000000282024723cULL, 0x020be20000001824ULL, 0x0000003400707306ULL, 0x0005ec0000200c00ULL,
0x0000541080287816ULL, 0x020fe4000000002bULL, 0x000054102f297816ULL, 0x000fe2000000002aULL,
0x0000010039347824ULL, 0x004fe200078e00ffULL, 0x0000003000307306ULL, 0x000ea20000200c00ULL,
0x000054102e2d7816ULL, 0x002fe20000000081ULL, 0x000000ffff817224ULL, 0x000fc400078e0082ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x000000284428723cULL, 0x040f6600000018ffULL,
0x0000003100317306ULL, 0x000e6a0000200c00ULL, 0x0000002c442c723cULL, 0x000f6600000018ffULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x004fce0000000030ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x0000541032317816ULL, 0x002fce0000000031ULL,
0x00000035006f7306ULL, 0x0003e20000200c00ULL, 0x000000304430723cULL, 0x000f6e00000018ffULL,
0x0000007900797306ULL, 0x000ee20000200c00ULL, 0x0001000039357824ULL, 0x002fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400397306ULL, 0x0003f00000200c00ULL,
0x0000007800787306ULL, 0x000f220000200c00ULL, 0x000001003a347824ULL, 0x002fc400078e00ffULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500807306ULL, 0x0005e20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fce000001143aULL,
0x0000003400827306ULL, 0x0003e20000200c00ULL, 0x000054107f357816ULL, 0x004fe4000000007cULL,
0x000088803b7c7816ULL, 0x000fca00000000ffULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x000054107e347816ULL, 0x002fce000000007dULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000000342028723cULL, 0x020bee0000001828ULL, 0x0000541079347816ULL, 0x028fe2000000007aULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x0000541078357816ULL, 0x010fe2000000007bULL,
0x000001003b787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00000034202c723cULL, 0x000be2000000182cULL, 0x0000004200427306ULL, 0x000eec0000200c00ULL,
0x000000ffff357224ULL, 0x020fe200078e007cULL, 0x0000541077347816ULL, 0x004fe20000000040ULL,
0x0000003c003c7306ULL, 0x000ea20000200c00ULL, 0x0000541041387816ULL, 0x002fc40000000038ULL,
0x0000888037777816ULL, 0x000fca00000000ffULL, 0x0000003500797306ULL, 0x0003e20000200c00ULL,
0x0000541042397816ULL, 0x008fce0000000039ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x0000541043357816ULL, 0x002fe4000000003eULL, 0x000054103f3c7816ULL, 0x004fca000000003cULL,
0x000000342030723cULL, 0x000be20000001830ULL, 0x0000007800787306ULL, 0x000e6c0000200c00ULL,
0x000100003b347824ULL, 0x020fe200078e00ffULL, 0x00005410803d7816ULL, 0x008fe2000000003dULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000010036357824ULL, 0x000fc400078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000036367824ULL, 0x000fe400078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003c443c723cULL, 0x000fe200000018ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541079417816ULL, 0x002fe20000000078ULL,
0x0000010037787824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc80000011436ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541081407816ULL, 0x004fce0000000082ULL, 0x0000003a007d7306ULL, 0x0002a20000200c00ULL,
0x000000404440723cULL, 0x040fee00000018ffULL, 0x00000034007a7306ULL, 0x0004e20000200c00ULL,
0x000000384438723cULL, 0x002f6e00000018ffULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000054107d347816ULL, 0x004fce0000000076ULL, 0x0000007400747306ULL, 0x000e700000200c00ULL,
0x0000007200727306ULL, 0x000eb00000200c00ULL, 0x00000035007c7306ULL, 0x0007f00000200c00ULL,
0x0000006d006d7306ULL, 0x000f220000200c00ULL, 0x000054107a357816ULL, 0x008fce0000000073ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000000344444723cULL, 0x000b6e00000018ffULL,
0x0000541071347816ULL, 0x022fe20000000074ULL, 0x0001000037717824ULL, 0x000fe200078e00ffULL,
0x0000541072357816ULL, 0x004fe20000000075ULL, 0x0000006100617306ULL, 0x000e660000200c00ULL,
0x00000018ff717819ULL, 0x000fc60000011471ULL, 0x000000342038723cULL, 0x000b640000001838ULL,
0x0000007700777306ULL, 0x000fea0000200c00ULL, 0x0000541070347816ULL, 0x030fe4000000006dULL,
0x000054106f357816ULL, 0x008fe20000000062ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x00000002ff627819ULL, 0x000fc80000011603ULL, 0x000000666200720cULL, 0x040fe20003f46070ULL,
0x00000034203c723cULL, 0x000b64000000183cULL, 0x0000006c006c7306ULL, 0x000fea0000200c00ULL,
0x0000541061347816ULL, 0x022fe4000000007cULL, 0x0000000862617810ULL, 0x000fe20007ffe0ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541077357816ULL, 0x004fc40000000078ULL,
0x000000666100720cULL, 0x000fca0003f66070ULL, 0x0000003600377306ULL, 0x0002a20000200c00ULL,
0x000000342040723cULL, 0x000b6e0000001840ULL, 0x0000007100707306ULL, 0x000ee20000200c00ULL,
0x0000000166367810ULL, 0x002fc80007ffe0ffULL, 0x000000366200720cULL, 0x080fe40005746470ULL,
0x000000366100720cULL, 0x000fe40005f66470ULL, 0x0000541037347816ULL, 0x024fe4000000006cULL,
0x0000541070357816ULL, 0x008fce000000006bULL, 0x000000342044723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000002411117221ULL, 0x000fe40000010000ULL, 0x0000002510107221ULL, 0x000fe40000010000ULL,
0x000000280d0d7221ULL, 0x000fe40000010000ULL, 0x000000290c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x000000381f1f7221ULL, 0x000fe40000010000ULL, 0x000000394a4a7221ULL, 0x000fe40000010000ULL,
0x0000003c4b4b7221ULL, 0x000fe40000010000ULL, 0x0000003d4e4e7221ULL, 0x000fc40000010000ULL,
0x000000404f4f7221ULL, 0x000fe40000010000ULL, 0x0000004152527221ULL, 0x000fe40000010000ULL,
0x0000004453537221ULL, 0x020fe40000010000ULL, 0x0000004556567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0000000000ULL, 0x000000260f0f7221ULL, 0x000fe40000010000ULL,
0x000000270e0e7221ULL, 0x000fe40000010000ULL, 0x0000002a0b0b7221ULL, 0x000fc40000010000ULL,
0x0000002b0a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x0000003202027221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x0000003a49497221ULL, 0x000fc40000010000ULL,
0x0000003b4c4c7221ULL, 0x000fe40000010000ULL, 0x0000003e4d4d7221ULL, 0x000fe40000010000ULL,
0x0000003f50507221ULL, 0x000fe40000010000ULL, 0x0000004251517221ULL, 0x000fe40000010000ULL,
0x0000004354547221ULL, 0x000fe40000010000ULL, 0x0000004655557221ULL, 0x020fc40000010000ULL,
0x0000004758587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff207f8cULL, 0x020e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011636ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000000145900720cULL, 0x0c0fe40003f03070ULL, 0x0000002336237207ULL, 0x000fe40002800000ULL,
0x000000145900720cULL, 0x080fe40003fc3070ULL, 0x00000001ff2c7803ULL, 0x000fe40000000000ULL,
0x0000001423227211ULL, 0x000fc400078ff0ffULL, 0x0000000336207812ULL, 0x002fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0000000323217812ULL, 0x000fe400078ec0ffULL,
0x000000ff20207207ULL, 0x000fc40006800000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe20007804867ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000023ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122247810ULL, 0x040fe20007ffe0ffULL, 0x0000000422237824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x0000005b2400720cULL, 0x000fe20003f06070ULL,
0x0000004023297824ULL, 0x000fca00078e00ffULL, 0x0000004057237812ULL, 0x000fce00078ef829ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2e7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000021d2b7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000041d337810ULL, 0x000fe20007ffe0ffULL,
0x018a00002e277984ULL, 0x000e620000004800ULL, 0x000000012e247824ULL, 0x000fe200078e0223ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x000000102e287824ULL, 0x000fe200078e00ffULL,
0x000000295c267217ULL, 0x000fe40007800000ULL, 0x000000052b307c10ULL, 0x000fc6000fffe0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a29ULL, 0x0000000130317824ULL, 0x000fc600078e0203ULL,
0x0000000526267c17ULL, 0x000fc8000f800000ULL, 0x80000005262a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000130267824ULL, 0x040fe400078e0223ULL, 0x0000001030307824ULL, 0x000fca00078e00ffULL,
0xfffffff030317812ULL, 0x000fe400078ee231ULL, 0x0000000533307c10ULL, 0x000fe4000fffe0ffULL,
0x0001400031317811ULL, 0x000fe200078e20ffULL, 0x018ac00027277984ULL, 0x002e640000004800ULL,
0x0000002716247224ULL, 0x002fe400078e0224ULL, 0x000000012e277824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc600078e002dULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x0000002f24247210ULL, 0x000fe40007f1e0ffULL, 0x0001400027297811ULL, 0x000fc600078e20ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000002a1d00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000c101c50ULL,
0x018a08002e287984ULL, 0x000ea20000004800ULL, 0x0000000130247824ULL, 0x002fc600078e0223ULL,
0x018ac00028277984ULL, 0x004e640000004800ULL, 0x0000002716267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000002a2b00720cULL, 0x000fda0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000c101c50ULL,
0x018a10002e2b7984ULL, 0x000ea80000004800ULL, 0x018ac0002b2b7984ULL, 0x004ea40000004800ULL,
0x0000002b16247224ULL, 0x004fe200078e0224ULL, 0x000000061d2b7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fe20007f1e0ffULL,
0x0000000130247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe200000e0625ULL,
0x0000002a3300720cULL, 0x000fe20003f06070ULL, 0x0000001030257824ULL, 0x000fe200078e00ffULL,
0x000000052b307c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x0000000130237824ULL, 0x000fc600078e0223ULL, 0x0001400024277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000c101c50ULL,
0x018a18002e267984ULL, 0x000ea80000004800ULL, 0x018ac00026257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc400078e0223ULL, 0x0000000130237824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fc800078e002dULL, 0x0000001030307824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007f1e0ffULL, 0xfffffff030237812ULL, 0x000fe200078ee223ULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0x0000002a2b00720cULL, 0x000fe40003f06070ULL,
0x0001400023237811ULL, 0x000fd600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2e7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000022e2a7810ULL, 0x040fe20007ffe0ffULL,
0x018a00002e287984ULL, 0x000e620000004800ULL, 0x000000012e247824ULL, 0x000fe400078e0223ULL,
0x000000f026317812ULL, 0x000fe200078ec0ffULL, 0x018ac00028257984ULL, 0x002e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002fULL,
0x0000003124267210ULL, 0x000fe20007f1e0ffULL, 0x000000012e247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400000e0625ULL, 0x000000102e257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x00014000242d7811ULL, 0x000fe200078e20ffULL,
0x0000000123247824ULL, 0x000fc800078e022aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0003e8000b901c50ULL, 0x018a08002e2b7984ULL, 0x000ea80000004800ULL,
0x018ac0002b2b7984ULL, 0x004ea40000004800ULL, 0x0000002b16247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124287210ULL, 0x000fe20007f1e0ffULL,
0x000000012a247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe400000e0625ULL,
0x000000102a257824ULL, 0x000fe200078e00ffULL, 0x000000042e2a7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x00014000242d7811ULL, 0x002fe200078e20ffULL,
0x0000000123247824ULL, 0x000fc800078e022aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e8000b901c50ULL, 0x018a10002e2b7984ULL, 0x000ea20000004800ULL,
0x000000062e287810ULL, 0x002fca0007ffe0ffULL, 0x0000000123237824ULL, 0x000fe200078e0228ULL,
0x018ac0002b2b7984ULL, 0x004e640000004800ULL, 0x0000002b16247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124267210ULL, 0x000fe20007f1e0ffULL,
0x000000012a247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400000e0625ULL,
0x000000102a257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0001400024297811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c50ULL, 0x018a18002e2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc400078e0223ULL,
0x0000000128237824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc800078e002fULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x0000003124247210ULL, 0x000fc80007f1e0ffULL,
0xfffffff028237812ULL, 0x000fe200078ee223ULL, 0x000000ffff257224ULL, 0x000fc600000e0625ULL,
0x0001400023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000023ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000225900720cULL, 0x000fe40003f04070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff20247207ULL, 0x000fc40000000000ULL, 0x000000ff20237207ULL, 0x000fc60004000000ULL,
0x0000000121217824ULL, 0x000fc800078e0224ULL, 0x0000004021207824ULL, 0x040fe200078e00ffULL,
0x0000002221217211ULL, 0x000fc800078ff0ffULL, 0x000000c020207812ULL, 0x000fca00078ec0ffULL,
0x0000010021207824ULL, 0x000fe200078e0220ULL, 0x0000000a23217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003f06070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000ffff677224ULL, 0x002fe200078e0021ULL, 0x0000014000001947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0001a6327f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0002a400000e0000ULL,
0x0001a6927f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000633000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0001b82000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x000063a000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0001b7b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001600064647811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000168657824ULL, 0x040fe200078e0265ULL,
0x0001600063637811ULL, 0x000fe200078e20ffULL, 0x0000001068267824ULL, 0x044fe200078e00ffULL,
0x000000006428783bULL, 0x002e620000004200ULL, 0x0000000168697824ULL, 0x000fe200078e0269ULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x0000001068687824ULL, 0x000fe200078e00ffULL,
0xfffffff026657812ULL, 0x000fe200078ee265ULL, 0x000000006320783bULL, 0x008fe20000004200ULL,
0x000000086e327824ULL, 0x000fe200078e00ffULL, 0x00000fb000017945ULL, 0x000fe20003800000ULL,
0x0001600065657811ULL, 0x000fc400078e20ffULL, 0xfffffff068687812ULL, 0x000fe400078ee269ULL,
0x000000046a697810ULL, 0x000fe40007ffe0ffULL, 0x0001600068687811ULL, 0x000fe400078e20ffULL,
0xfffffff832697812ULL, 0x000fe400078ee269ULL, 0x000000066a6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000006834783bULL, 0x000ea20000004200ULL, 0x0001200069407811ULL, 0x000fcc00078e20ffULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x0000010028247824ULL, 0x002fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000010029257824ULL, 0x000fe200078e00ffULL,
0x000088802a7a7816ULL, 0x000fe400000000ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fc40000011428ULL, 0x0000888028837816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe4000001142bULL,
0x000088802b787816ULL, 0x000fe200000000ffULL, 0x0000002400827306ULL, 0x0003e20000200c00ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff7c7819ULL, 0x000fe20000011429ULL,
0x00000100343b7824ULL, 0x004fe200078e00ffULL, 0x0000888029807816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011434ULL,
0x0000002500817306ULL, 0x0005e20000200c00ULL, 0x000001002a247824ULL, 0x002fe200078e00ffULL,
0x00008880343a7816ULL, 0x000fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011424ULL, 0x000001002b247824ULL, 0x040fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000028007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe20000011420ULL,
0x0000001a40409232ULL, 0x088fe20000000000ULL, 0x00000018ff7b7819ULL, 0x000fe20000011424ULL,
0x0000001a42429232ULL, 0x000fe20000000000ULL, 0x000000006524783bULL, 0x004ea20000004200ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000001b41419232ULL, 0x080fe20000000000ULL,
0x0000002a00777306ULL, 0x0005e20000200c00ULL, 0x0000010020287824ULL, 0x042fe200078e00ffULL,
0x0000888020747816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143bULL, 0x0000001b43439232ULL, 0x000fe20000000000ULL,
0x00000018ff757819ULL, 0x000fc40000011428ULL, 0x0000002b00767306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00008880353f7816ULL, 0x000fe200000000ffULL,
0x00000029007f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe40000011437ULL,
0x00008880363c7816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011421ULL,
0x0000888021737816ULL, 0x000fe200000000ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe40000011422ULL, 0x00000018ff6b7819ULL, 0x000fca0000011423ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000100242a7824ULL, 0x044fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x00000100262d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x002fe2000001142aULL, 0x00000100252a7824ULL, 0x000fe200078e00ffULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00000018ff297819ULL, 0x008fe20000011425ULL,
0x00000100272f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x040fe200078e00ffULL, 0x0000888025457816ULL, 0x000fc400000000ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x0000002b002b7306ULL, 0x000e620000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00008880262c7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011427ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2f7819ULL, 0x000fc6000001142fULL, 0x0000002e00257306ULL, 0x0004e20000200c00ULL,
0x0000541044447816ULL, 0x002fe2000000002bULL, 0x000000086e2b7824ULL, 0x000fe200078e00ffULL,
0x00008880376e7816ULL, 0x000fc800000000ffULL, 0xfffffff82b6a7812ULL, 0x000fe200078ee26aULL,
0x0000002900297306ULL, 0x000fe20000200c00ULL, 0x00008880272e7816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400247306ULL, 0x000e620000200c00ULL, 0x0000541025287816ULL, 0x008fe40000000028ULL,
0x000120006a257811ULL, 0x000fca00078e20ffULL, 0x0000002600337306ULL, 0x0005f00000200c00ULL,
0x0000002700327306ULL, 0x0007e20000200c00ULL, 0x0000010035267824ULL, 0x044fe200078e00ffULL,
0x0000541024297816ULL, 0x002fe20000000029ULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000010036277824ULL, 0x008fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff857819ULL, 0x000fe40000011427ULL, 0x0000002600867306ULL, 0x0003f00000200c00ULL,
0x0000002a002a7306ULL, 0x000ea20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000034003b7306ULL, 0x0007f00000200c00ULL, 0x0000002000707306ULL, 0x0009e20000200c00ULL,
0x0000010037347824ULL, 0x008fe200078e00ffULL, 0x0000541045457816ULL, 0x004fe2000000002aULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x000000284028723cULL, 0x000fe400000018ffULL,
0x00000018ff887819ULL, 0x000fc40000011434ULL, 0x00000018ff8a7819ULL, 0x000fe20000011437ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff207819ULL, 0x010fe20000011436ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000054103a347816ULL, 0x000fe2000000003dULL,
0x00000100213a7824ULL, 0x040fe200078e00ffULL, 0x000000444044723cULL, 0x000f6200000018ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000002d002d7306ULL, 0x000ea60000200c00ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000001a24249232ULL, 0x082fe40000000000ULL,
0x0000001a26269232ULL, 0x000fe40000000000ULL, 0x0000001b25259232ULL, 0x080fe40000000000ULL,
0x0000001b27279232ULL, 0x000fe20000000000ULL, 0x0000008800897306ULL, 0x0002e20000200c00ULL,
0x000054102c2c7816ULL, 0x004fce000000002dULL, 0x0000003000307306ULL, 0x000ea20000200c00ULL,
0x0000888022887816ULL, 0x002fce00000000ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x000054106e3d7816ULL, 0x008fce0000000089ULL, 0x0000003800387306ULL, 0x000ee20000200c00ULL,
0x0000541033307816ULL, 0x004fce0000000030ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541032317816ULL, 0x002fce0000000031ULL, 0x0000002e002e7306ULL, 0x000fe20000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x000000304030723cULL, 0x000fec00000018ffULL,
0x0000002f002f7306ULL, 0x000e700000200c00ULL, 0x0000003f003f7306ULL, 0x000eb00000200c00ULL,
0x00000035003e7306ULL, 0x0004e20000200c00ULL, 0x000054102e2d7816ULL, 0x002fce000000002fULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103f357816ULL, 0x004fe20000000086ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff867819ULL, 0x000fca000001143aULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000054103e397816ULL, 0x008fce0000000039ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x002fe20000000085ULL,
0x0000010022857824ULL, 0x000fc400078e00ffULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000003600877306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x000fe200000018ffULL, 0x00000018ff227819ULL, 0x000fcc0000011422ULL,
0x0000008a008b7306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541087207816ULL, 0x004fe20000000020ULL,
0x000000ffff877224ULL, 0x000fcc00078e0088ULL, 0x0000008000807306ULL, 0x000eb00000200c00ULL,
0x00000021006e7306ULL, 0x0007f00000200c00ULL, 0x0000007d007d7306ULL, 0x000f220000200c00ULL,
0x000054108b217816ULL, 0x008fce0000000084ULL, 0x0000007c007c7306ULL, 0x000ee20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000541083207816ULL, 0x022fe20000000082ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541080217816ULL, 0x004fc40000000081ULL,
0x0000888023807816ULL, 0x000fca00000000ffULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000054107e207816ULL, 0x030fe4000000007dULL, 0x000054107f217816ULL, 0x008fe2000000007cULL,
0x00000100237c7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fe400078e00ffULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000000ffff207224ULL, 0x020fce00078e0080ULL,
0x00000020007d7306ULL, 0x0007e20000200c00ULL, 0x0000541078217816ULL, 0x002fce000000007bULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000054107a207816ULL, 0x008fce0000000079ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541077207816ULL, 0x020fe40000000072ULL,
0x0000541076217816ULL, 0x004fca0000000071ULL, 0x0000008600867306ULL, 0x000ea40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000541074207816ULL, 0x022fce0000000075ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000541073217816ULL, 0x004fce0000000086ULL, 0x0000008700847306ULL, 0x000fe20000200c00ULL,
0x000000202434723cULL, 0x000b6e0000001834ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000541070207816ULL, 0x028fe4000000006fULL, 0x000054106e217816ULL, 0x002fca000000006dULL,
0x0000007c007c7306ULL, 0x000e640000200c00ULL, 0x000000202438723cULL, 0x000b6c0000001838ULL,
0x0000002200817306ULL, 0x000fe20000200c00ULL, 0x0000541084207816ULL, 0x024fce0000000085ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000054107d217816ULL, 0x002fce000000007cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000020243c723cULL, 0x000b6e000000183cULL,
0x0000002300227306ULL, 0x000e620000200c00ULL, 0x0000541081207816ULL, 0x024fe4000000006cULL,
0x0000541022217816ULL, 0x002fce000000006bULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x0000004411117221ULL, 0x000fe40000010000ULL, 0x0000004510107221ULL, 0x000fe40000010000ULL,
0x000000280d0d7221ULL, 0x000fe40000010000ULL, 0x000000290c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x000000341f1f7221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384b4b7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004053537221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x000000460f0f7221ULL, 0x000fe40000010000ULL,
0x000000470e0e7221ULL, 0x000fe40000010000ULL, 0x0000002a0b0b7221ULL, 0x000fc40000010000ULL,
0x0000002b0a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x0000003202027221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x0000003649497221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4d4d7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e51517221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004255557221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000166667810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff6b7424ULL, 0x000fe200078e00ffULL, 0x018b8800ff247f8cULL, 0x020e68000c80043fULL,
0x000000016b6b7807ULL, 0x000fc80006800000ULL, 0x0000006b6600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffa69000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004014217811ULL, 0x000fe200078e40ffULL,
0x018b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005c2100720cULL, 0x000fda0003f06070ULL,
0x000102c000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x000fe2000001166cULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036c227812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000216c217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000121237810ULL, 0x000fc80007ffe0ffULL, 0x0000000323217812ULL, 0x040fe400078ec0ffULL,
0x0000001423207211ULL, 0x002fc400078ff0ffULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x018b7c00ff247984ULL, 0x002e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011429ULL, 0x0000002b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000224247819ULL, 0x000fc80000001229ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x018b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420257824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x0000005b2400720cULL, 0x000fe40003f06070ULL,
0x0000002025287811ULL, 0x000fc800078e30ffULL, 0x0000006057247812ULL, 0x000fce00078ef828ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003297824ULL, 0x000fe200078e00ffULL, 0x000000285c257217ULL, 0x000fe20007800000ULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000021d337810ULL, 0x000fe20007ffe0ffULL,
0x018a00002b267984ULL, 0x000e620000004800ULL, 0x000000f0292f7812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x000fe400078e0a28ULL, 0x000000012b287824ULL, 0x040fe400078e0224ULL,
0x000000102b2c7824ULL, 0x000fe200078e00ffULL, 0x0000000525257c17ULL, 0x000fc8000f800000ULL,
0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012b257824ULL, 0x000fc600078e0203ULL,
0x0000002a1d00720cULL, 0x000fe40003f06070ULL, 0xfffffff02c257812ULL, 0x000fe400078ee225ULL,
0x00000005332c7c10ULL, 0x000fe4000fffe0ffULL, 0x0001600025317811ULL, 0x000fc600078e20ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00026277984ULL, 0x002e640000004800ULL,
0x0000002716277224ULL, 0x002fc800078e0228ULL, 0x00005e0027267625ULL, 0x000fca00078e002dULL,
0x0000002f26287210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0224ULL,
0x000000ffff297224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x018a08002b257984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x000000041d337810ULL, 0x000fe40007ffe0ffULL,
0x000160002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26287210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0224ULL,
0x000000ffff297224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x018a10002b257984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fc800078ee22eULL, 0x000160002e297811ULL, 0x002fe400078e20ffULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c247824ULL, 0x040fe400078e0224ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff277224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fc60003f06070ULL,
0x018a18002b287984ULL, 0x000ea80000004800ULL, 0x018ac00028257984ULL, 0x004ea40000004800ULL,
0x0000002516247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fc800078e002dULL,
0x000000102c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f24247210ULL, 0x000fc80007f3e0ffULL,
0xfffffff02d2e7812ULL, 0x000fe200078ee22eULL, 0x000000ffff257224ULL, 0x000fc600008e0625ULL,
0x000160002e277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fe400078e00ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x018a00002c257984ULL, 0x000e620000004800ULL,
0x000000012c267824ULL, 0x040fe200078e0224ULL, 0x000000f0272f7812ULL, 0x000fe200078ec0ffULL,
0x000000012c297824ULL, 0x040fe400078e0203ULL, 0x000000102c2a7824ULL, 0x000fe200078e00ffULL,
0x018ac00025257984ULL, 0x002e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26287210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02a267812ULL, 0x000fe400078ee229ULL, 0x000000022c2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0627ULL, 0x0001600026317811ULL, 0x000fc600078e20ffULL,
0x000000012a267824ULL, 0x040fe400078e0224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000b901c50ULL, 0x000000012a2b7824ULL, 0x040fe400078e0203ULL,
0x000000102a2e7824ULL, 0x000fe200078e00ffULL, 0x018a08002c257984ULL, 0x000ea20000004800ULL,
0x000000042c287810ULL, 0x002fca0007ffe0ffULL, 0x0000001028317824ULL, 0x000fe200078e00ffULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f262a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02e267812ULL, 0x000fe200078ee22bULL, 0x00000001282e7824ULL, 0x000fe400078e0203ULL,
0x000000ffff2b7224ULL, 0x000fe200000e0627ULL, 0x0001600026297811ULL, 0x000fe200078e20ffULL,
0x0000000128267824ULL, 0x000fe200078e0224ULL, 0xfffffff0312e7812ULL, 0x000fc600078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e8000b901c50ULL,
0x018a10002c257984ULL, 0x000ea20000004800ULL, 0x000160002e297811ULL, 0x002fe400078e20ffULL,
0x000000062c2a7810ULL, 0x000fca0007ffe0ffULL, 0x000000012a247824ULL, 0x040fe400078e0224ULL,
0x000000012a2b7824ULL, 0x040fe400078e0203ULL, 0x000000102a2a7824ULL, 0x000fca00078e00ffULL,
0xfffffff02a2b7812ULL, 0x000fe200078ee22bULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c50ULL,
0x018a18002c287984ULL, 0x000ea20000004800ULL, 0x000160002b277811ULL, 0x002fc600078e20ffULL,
0x018ac00028257984ULL, 0x004e640000004800ULL, 0x0000002516247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000123237812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012300780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031700780cULL, 0x000fe40003f04070ULL, 0x0000000115157810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x0000005a1500720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0217ULL, 0x0000640015247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00018ac017237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00018a0017237811ULL, 0x040fe200078e10ffULL, 0x0000000117217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x0000005c2100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff6c00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6d7224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018af800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x018afc05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018afc05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0180800027227984ULL, 0x000e680000000800ULL, 0x0182800027237984ULL, 0x0004e20000000800ULL,
0x000000132200720bULL, 0x002fe20003f1d000ULL, 0x00017ae27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0013ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f05270ULL, 0x000000132200720bULL, 0x000fe20003f34000ULL,
0x00017ab27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002213247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0184802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002413137221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300297308ULL, 0x000e640000000800ULL, 0x0000002912127220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00017a127f007947ULL, 0x000fea000b800000ULL,
0x00001f6229137589ULL, 0x0002a400000e0000ULL, 0x0000001311117220ULL, 0x084fe40000410000ULL,
0x0000001310107220ULL, 0x080fe40000410000ULL, 0x000000130d0d7220ULL, 0x080fe40000410000ULL,
0x000000130c0c7220ULL, 0x080fe40000410000ULL, 0x0000001309097220ULL, 0x080fe40000410000ULL,
0x0000001308087220ULL, 0x000fc40000410000ULL, 0x0000001305057220ULL, 0x080fe40000410000ULL,
0x0000001304047220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000134a4a7220ULL, 0x080fe40000410000ULL, 0x000000134b4b7220ULL, 0x080fe40000410000ULL,
0x000000134e4e7220ULL, 0x000fc40000410000ULL, 0x000000134f4f7220ULL, 0x080fe40000410000ULL,
0x0000001352527220ULL, 0x080fe40000410000ULL, 0x0000001353537220ULL, 0x080fe40000410000ULL,
0x0000001356567220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000179427f007947ULL, 0x000fea000b800000ULL, 0x00001f6129137589ULL, 0x00046400000e0000ULL,
0x000000130f0f7220ULL, 0x082fe40000410000ULL, 0x000000130e0e7220ULL, 0x080fe40000410000ULL,
0x000000130b0b7220ULL, 0x080fe40000410000ULL, 0x000000130a0a7220ULL, 0x080fe40000410000ULL,
0x0000001307077220ULL, 0x080fe40000410000ULL, 0x0000001306067220ULL, 0x000fc40000410000ULL,
0x0000001302027220ULL, 0x080fe40000410000ULL, 0x0000001348487220ULL, 0x080fe40000410000ULL,
0x0000001349497220ULL, 0x080fe40000410000ULL, 0x000000134c4c7220ULL, 0x080fe40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x0000001350507220ULL, 0x000fc40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001358587220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2aff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200190308ULL, 0x000e640000000800ULL,
0x0000001923230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001223127221ULL, 0x008fe40000010000ULL, 0x000000ffff137224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x000177a27f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0002e400000e0000ULL,
0x000178027f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000947000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000186e000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x000094e000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0001867000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x000128005f407811ULL, 0x000fe200078e20ffULL,
0x00000f9000017945ULL, 0x000fe20003800000ULL, 0x0000006c6200720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000145900720cULL, 0x000fc40003fc3070ULL,
0x0000006c6100720cULL, 0x000fe20003f26070ULL, 0x000000005d28783bULL, 0x000fe20000004200ULL,
0x000000145900720cULL, 0x000fc60003f03070ULL, 0x000000005e34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x0000888020327816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000888021467816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011425ULL, 0x0000888025817816ULL, 0x000fe200000000ffULL,
0x00000020003d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001a4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x0000001b4141b232ULL, 0x080fe20000000000ULL, 0x0000888024827816ULL, 0x000fe200000000ffULL,
0x0000002d00477306ULL, 0x000fe20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011423ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fc40000011426ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002c003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011427ULL,
0x0000888026797816ULL, 0x000fe400000000ffULL, 0x0000888027787816ULL, 0x000fe400000000ffULL,
0x00008880343a7816ULL, 0x000fe200000000ffULL, 0x00000020002d7306ULL, 0x0005e20000200c00ULL,
0x00000100252c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011422ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011434ULL,
0x00000018ff847819ULL, 0x000fe2000001142cULL, 0x00010000242c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000010027207824ULL, 0x044fe200078e00ffULL,
0x0000002e00837306ULL, 0x0003e20000200c00ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe4000001142cULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00008880222c7816ULL, 0x040fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000020007b7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x002fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011436ULL, 0x0000002100247306ULL, 0x0003e20000200c00ULL,
0x0000010028207824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011437ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000010023217824ULL, 0x002fe200078e00ffULL, 0x0000888035867816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x00000025007f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff717819ULL, 0x000fe20000011428ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000010026257824ULL, 0x002fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888028747816ULL, 0x000fc400000000ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff707819ULL, 0x000fe40000011429ULL,
0x0000888029887816ULL, 0x000fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001142aULL,
0x00000023003e7306ULL, 0x0002a20000200c00ULL, 0x000054103d447816ULL, 0x008fc40000000044ULL,
0x00008880373d7816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fc6000001142bULL,
0x00000025007a7306ULL, 0x0007e20000200c00ULL, 0x0000010036237824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0001280060257811ULL, 0x008fe400078e20ffULL, 0x000054103e317816ULL, 0x004fe40000000031ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x0000002000857306ULL, 0x0002b00000200c00ULL,
0x0000002600767306ULL, 0x000fe20000200c00ULL, 0x0000541032207816ULL, 0x002fe2000000003fULL,
0x0000010037327824ULL, 0x040fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011423ULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe20000011432ULL,
0x0000002700777306ULL, 0x0003f00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000000002524783bULL, 0x002e6e0000000200ULL, 0x00000021002f7306ULL, 0x0009f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x0000010035217824ULL, 0x010fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000034003b7306ULL, 0x0009e20000200c00ULL,
0x0001000035227824ULL, 0x004fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000054103a347816ULL, 0x010fe20000000085ULL,
0x00010000283a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fca0000011437ULL,
0x0000002100357306ULL, 0x0006a20000200c00ULL, 0x0000001a2424b232ULL, 0x082fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe40000000000ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000002c002c7306ULL, 0x000e620000200c00ULL,
0x0000541046217816ULL, 0x008fe40000000047ULL, 0x000000444044723cULL, 0x000fea00000018ffULL,
0x0000003000307306ULL, 0x000ee20000200c00ULL, 0x0000541086357816ULL, 0x004fe20000000035ULL,
0x0000010029867824ULL, 0x000fc400078e00ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x000054102c2c7816ULL, 0x002fe4000000002dULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x008fce0000000030ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x004fe20000000038ULL,
0x000000304030723cULL, 0x040fec00000018ffULL, 0x00000022007e7306ULL, 0x0004f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000000204020723cULL, 0x004f6200000018ffULL,
0x000054102e2d7816ULL, 0x002fcc000000002fULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000054107e397816ULL, 0x008fe20000000039ULL, 0x0000002c402c723cULL, 0x000f6200000018ffULL,
0x00000018ff7e7819ULL, 0x000fca000001143aULL, 0x0000003d003d7306ULL, 0x000fe40000200c00ULL,
0x000000384038723cULL, 0x000fec00000018ffULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003fULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000003eULL,
0x0000003600877306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008500287306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541087667816ULL, 0x004fce0000000066ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541028677816ULL, 0x008fce0000000067ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000000664040723cULL, 0x000b6200000018ffULL,
0x0000541082287816ULL, 0x002fcc0000000083ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000088802a667816ULL, 0x020fce00000000ffULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000002900677306ULL, 0x0005f00000200c00ULL,
0x0000007900797306ULL, 0x000ee20000200c00ULL, 0x0000541081297816ULL, 0x004fe20000000084ULL,
0x000001002a817824ULL, 0x000fc400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x000000282420723cULL, 0x000b620000001820ULL, 0x00000018ff2a7819ULL, 0x000fcc000001142aULL,
0x0000541080287816ULL, 0x022fe2000000007dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000054107f297816ULL, 0x000fe4000000007cULL, 0x000088802b7c7816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x0000541079287816ULL, 0x028fe2000000007aULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078297816ULL, 0x004fe2000000007bULL, 0x000001002b787824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008800857306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e007cULL, 0x0000541077297816ULL, 0x002fcc0000000072ULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002800797306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541076287816ULL, 0x008fce0000000073ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x0000541074287816ULL, 0x024fe40000000075ULL,
0x0000541085297816ULL, 0x002fca0000000086ULL, 0x0000006600667306ULL, 0x000fe40000200c00ULL,
0x000000282434723cULL, 0x000b6c0000001834ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x000054107e287816ULL, 0x028fe40000000071ULL, 0x0000541067297816ULL, 0x000fca0000000070ULL,
0x0000007800787306ULL, 0x000ea40000200c00ULL, 0x000000282438723cULL, 0x000b6c0000001838ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541066287816ULL, 0x022fe40000000081ULL,
0x000000016c667810ULL, 0x000fc80007ffe0ffULL, 0x000000666200720cULL, 0x080fe20005746470ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541079297816ULL, 0x004fe40000000078ULL,
0x000000666100720cULL, 0x000fca0004f26470ULL, 0x0000002a002a7306ULL, 0x000e620000200c00ULL,
0x00000028243c723cULL, 0x000b6e000000183cULL, 0x0000002b002b7306ULL, 0x000ea20000200c00ULL,
0x000054102a287816ULL, 0x022fe4000000006fULL, 0x000054102b297816ULL, 0x004fce000000006eULL,
0x000000282440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000002011117221ULL, 0x000fe40000010000ULL,
0x0000002110107221ULL, 0x000fe40000010000ULL, 0x000000440d0d7221ULL, 0x000fe40000010000ULL,
0x000000450c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x000000341f1f7221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384b4b7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004053537221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220f0f7221ULL, 0x000fe40000010000ULL, 0x000000230e0e7221ULL, 0x000fe40000010000ULL,
0x000000460b0b7221ULL, 0x000fc40000010000ULL, 0x000000470a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x0000003202027221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x0000003649497221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4d4d7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e51517221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004255557221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011666ULL,
0x000000ffff287224ULL, 0x020fe200078e00ffULL, 0x000000145900720cULL, 0x080fe40003fc3070ULL,
0x0000002366237207ULL, 0x040fe40002800000ULL, 0x0000000366667812ULL, 0x000fe400078ec0ffULL,
0x0000000123257810ULL, 0x000fe40007ffe0ffULL, 0x000000145900720cULL, 0x000fc40003f03070ULL,
0x00000040ff2c7803ULL, 0x000fe40000000000ULL, 0x0000000325237812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0021ULL, 0x000000ff66217207ULL, 0x000fe40006800000ULL,
0x0000001425207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8400ff227984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c486dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420227824ULL, 0x000fe200078e0223ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x0000005b2400720cULL, 0x000fe20003fc6070ULL,
0x0000004022297824ULL, 0x000fca00078e00ffULL, 0x0000004057227812ULL, 0x000fce00078ef829ULL,
0x000004f00000e947ULL, 0x000fea0003800000ULL, 0x000000051d2d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000021d2b7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000041d357810ULL, 0x000fe20007ffe0ffULL,
0x018a00002d277984ULL, 0x000e620000004800ULL, 0x000000012d247824ULL, 0x040fe200078e0222ULL,
0x000000f026317812ULL, 0x000fe200078ec0ffULL, 0x000000102d287824ULL, 0x000fe200078e00ffULL,
0x000000295c267217ULL, 0x000fe40007800000ULL, 0x000000052b2e7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a29ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x0000000526267c17ULL, 0x000fc8000f800000ULL, 0x80000005262a7c10ULL, 0x000fe2000fffe0ffULL,
0x000000012e267824ULL, 0x000fe200078e0222ULL, 0x018ac00027277984ULL, 0x002e640000004800ULL,
0x0000002716247224ULL, 0x002fe400078e0224ULL, 0x000000012d277824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x0000003124247210ULL, 0x000fe40007fde0ffULL, 0x0001400027297811ULL, 0x000fc600078e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000002a1d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000f101c50ULL,
0x018a08002d287984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fe200078e00ffULL,
0x00000005352e7c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff025307812ULL, 0x000fe200078ee230ULL,
0x000000012e247824ULL, 0x000fc600078e0222ULL, 0x0001400030337811ULL, 0x000fe200078e20ffULL,
0x018ac00028277984ULL, 0x004e640000004800ULL, 0x0000002716267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002fULL, 0x0000003126267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x0000002a2b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026337faeULL, 0x0003e8000f101c50ULL,
0x018a10002d2b7984ULL, 0x000ea80000004800ULL, 0x018ac0002b2b7984ULL, 0x004ea40000004800ULL,
0x0000002b16247224ULL, 0x004fe200078e0224ULL, 0x000000061d2b7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124287210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a3500720cULL, 0x000fe20003fc6070ULL, 0x000000102e257824ULL, 0x000fe200078e00ffULL,
0x000000052b2e7c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x000000012e227824ULL, 0x000fc600078e0222ULL, 0x0001400024277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000f101c50ULL,
0x018a18002d267984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fc600078e00ffULL,
0x018ac00026257984ULL, 0x004e640000004800ULL, 0x0000002516257224ULL, 0x002fe400078e0222ULL,
0x000000012e227824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc600078e002fULL,
0xfffffff027227812ULL, 0x000fe400078ee222ULL, 0x0000003124247210ULL, 0x000fe40007fde0ffULL,
0x0001400022277811ULL, 0x000fc600078e20ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x0000002a2b00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000f101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000022b2e7810ULL, 0x040fe20007ffe0ffULL,
0x018a00002b287984ULL, 0x000e620000004800ULL, 0x000000012b247824ULL, 0x000fe400078e0222ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x018ac00028257984ULL, 0x002e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fe20007fde0ffULL, 0x000000012b247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102b257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0001400024317811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x000fc800078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c50ULL, 0x018a08002b2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe400030e0625ULL,
0x000000102e257824ULL, 0x000fe200078e00ffULL, 0x000000042b2e7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0001400024317811ULL, 0x002fe200078e20ffULL,
0x000000012e247824ULL, 0x000fc800078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c50ULL, 0x018a10002b2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x0044e40000004800ULL, 0x000000062b2a7810ULL, 0x004fca0007ffe0ffULL,
0x000000012a227824ULL, 0x000fe400078e0222ULL, 0x0000002516247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102e257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0001400024297811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c50ULL, 0x018a18002b287984ULL, 0x000ea80000004800ULL,
0x018ac00028257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc400078e0222ULL,
0x000000012a227824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc800078e002dULL,
0x000000102a2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f24247210ULL, 0x000fc80007fde0ffULL,
0xfffffff02d227812ULL, 0x000fe200078ee222ULL, 0x000000ffff257224ULL, 0x000fc600030e0625ULL,
0x0001400022277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003fc4070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40003000000ULL, 0x000000ff21247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003fc6070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000f121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000152727f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0004e400000e0000ULL, 0x000152d27f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000baa000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000160b000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0000bb1000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0001604000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006524783bULL, 0x006e620000004200ULL,
0x000000ff2c00720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0001280069407811ULL, 0x000fe200078e20ffULL, 0x000000006428783bULL, 0x000ea80000004200ULL,
0x000000006320783bULL, 0x000fe80000004200ULL, 0x000000006834783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011424ULL, 0x0000010027337824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011428ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x0000002e003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fc40000011429ULL,
0x0000888028847816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888029827816ULL, 0x040fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011428ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000888026287816ULL, 0x040fe200000000ffULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe2000001142eULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7e7819ULL, 0x000fe20000011429ULL, 0x0000010026297824ULL, 0x040fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff2d7819ULL, 0x000fe20000011425ULL, 0x0000003200837306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff6f7819ULL, 0x000fe40000011420ULL,
0x0000888020737816ULL, 0x000fe400000000ffULL, 0x0000888025457816ULL, 0x000fe200000000ffULL,
0x00000033003d7306ULL, 0x000fe20000200c00ULL, 0x0000888027327816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002600337306ULL, 0x0005e20000200c00ULL, 0x0000888035877816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff867819ULL, 0x000fe20000011436ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x044fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011437ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00008880363c7816ULL, 0x000fc400000000ffULL,
0x00000018ff767819ULL, 0x000fe20000011426ULL, 0x0000010034267824ULL, 0x040fe200078e00ffULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011420ULL,
0x0000888034207816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000541044447816ULL, 0x002fe2000000003fULL,
0x0000002e00257306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff6e7819ULL, 0x000fe40000011421ULL, 0x0000888021747816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001142bULL, 0x000088802a797816ULL, 0x000fe400000000ffULL,
0x000088802b777816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011422ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00000018ff667819ULL, 0x000fce0000011423ULL,
0x0000002f003e7306ULL, 0x000e700000200c00ULL, 0x00000027003a7306ULL, 0x0005f00000200c00ULL,
0x00000029002f7306ULL, 0x0007e20000200c00ULL, 0x0000010035277824ULL, 0x004fe200078e00ffULL,
0x0000541045457816ULL, 0x002fe2000000003eULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00008880373e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000028002e7306ULL, 0x0002a20000200c00ULL, 0x000001002b297824ULL, 0x048fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x000000444044723cULL, 0x000f6400000018ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000026007f7306ULL, 0x0002e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000010036267824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011426ULL, 0x00000027008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011436ULL, 0x00000029007c7306ULL, 0x0003f00000200c00ULL,
0x00000028007a7306ULL, 0x0009e20000200c00ULL, 0x0000541024297816ULL, 0x002fe4000000002dULL,
0x00005410322d7816ULL, 0x000fe2000000003dULL, 0x0000010037327824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x0000541025287816ULL, 0x010fe4000000002cULL, 0x000128006a257811ULL, 0x000fe400078e20ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011432ULL, 0x000054102e2c7816ULL, 0x004fe2000000002fULL,
0x00000034003b7306ULL, 0x0007e20000200c00ULL, 0x000000002524783bULL, 0x000eaa0000000200ULL,
0x0000002c402c723cULL, 0x000fe400000018ffULL, 0x0000003500887306ULL, 0x0009e20000200c00ULL,
0x0000541020347816ULL, 0x008fc4000000007fULL, 0x00000018ff207819ULL, 0x000fe40000011437ULL,
0x000054103a317816ULL, 0x002fe20000000031ULL, 0x00000100213a7824ULL, 0x000fe400078e00ffULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000541087357816ULL, 0x010fe2000000008aULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc8000001143aULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x0000541033307816ULL, 0x002fce0000000030ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x000000304030723cULL, 0x000fe200000018ffULL, 0x0000001a2424b232ULL, 0x084fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe20000000000ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000541088397816ULL, 0x010fe20000000039ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000888022887816ULL, 0x000fca00000000ffULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054103e3d7816ULL, 0x004fce000000003dULL, 0x0000003600897306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x00000020008a7306ULL, 0x0004e20000200c00ULL,
0x000000344034723cULL, 0x002fee00000018ffULL, 0x00000021007f7306ULL, 0x0007e20000200c00ULL,
0x0000541089207816ULL, 0x004fe20000000086ULL, 0x0001000022867824ULL, 0x000fcc00078e00ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054108a217816ULL, 0x008fe20000000081ULL,
0x000000ffff817224ULL, 0x000fcc00078e0088ULL, 0x0000008200827306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002a00757306ULL, 0x000ff00000200c00ULL,
0x0000002b00787306ULL, 0x0005f00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0000541082217816ULL, 0x002fc40000000085ULL,
0x00000018ff827819ULL, 0x000fe40000011486ULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000002000227306ULL, 0x0007f00000200c00ULL,
0x0000007900797306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x008fc40000000083ULL,
0x0000888023837816ULL, 0x000fca00000000ffULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000541080207816ULL, 0x024fe2000000007dULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107e217816ULL, 0x002fe2000000007bULL,
0x00000100237b7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fcc0000011423ULL,
0x000000ffff217224ULL, 0x020fe200078e0083ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541079207816ULL, 0x010fce000000007aULL, 0x00000021007d7306ULL, 0x0007f00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541077217816ULL, 0x008fce000000007cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x0000541075207816ULL, 0x024fe40000000072ULL,
0x0000541078217816ULL, 0x002fca0000000071ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541073207816ULL, 0x030fe40000000076ULL, 0x0000541074217816ULL, 0x008fca0000000087ULL,
0x0000007000707306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054107f217816ULL, 0x022fce000000006eULL,
0x0000007b007a7306ULL, 0x000e620000200c00ULL, 0x0000541070207816ULL, 0x004fce000000006fULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541081207816ULL, 0x028fe40000000022ULL,
0x000054107d217816ULL, 0x002fca000000007aULL, 0x0000008200827306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541082207816ULL, 0x022fe4000000006dULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004411117221ULL, 0x000fe40000010000ULL,
0x0000004510107221ULL, 0x000fe40000010000ULL, 0x000000280d0d7221ULL, 0x000fe40000010000ULL,
0x000000290c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x000000341f1f7221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384b4b7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004053537221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460f0f7221ULL, 0x000fe40000010000ULL, 0x000000470e0e7221ULL, 0x000fe40000010000ULL,
0x0000002a0b0b7221ULL, 0x000fc40000010000ULL, 0x0000002b0a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x0000003202027221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x0000003649497221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4d4d7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e51517221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004255557221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006b6c00720cULL, 0x000fe20003f06070ULL,
0x018b8800ff247f8cULL, 0x020e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaa5000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008014217811ULL, 0x000fe200078e40ffULL, 0x018b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000005c2100720cULL, 0x000fda0003f06070ULL, 0x0000ac7000000947ULL, 0x000fea0003800000ULL,
0x000000ffff6c7224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x000fe2000001166cULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000036c227812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000000216c217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221237810ULL, 0x000fc80007ffe0ffULL,
0x0000000323217812ULL, 0x040fe400078ec0ffULL, 0x0000001423207211ULL, 0x002fc400078ff0ffULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x018b7c00ff247984ULL, 0x002e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b7c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x018b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011429ULL, 0x0000002b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000224247819ULL, 0x000fc80000001229ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x040fe20007ffe0ffULL,
0x0000000420257824ULL, 0x000fe200078e0221ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x0000005b2400720cULL, 0x000fe40003f06070ULL, 0x0000002025287811ULL, 0x000fc800078e30ffULL,
0x0000006057247812ULL, 0x000fce00078ef828ULL, 0x000004f000008947ULL, 0x000fea0003800000ULL,
0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003297824ULL, 0x000fe200078e00ffULL,
0x000000285c257217ULL, 0x000fe20007800000ULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x000000021d337810ULL, 0x000fe20007ffe0ffULL, 0x018a00002b267984ULL, 0x000e620000004800ULL,
0x000000f0292f7812ULL, 0x000fe200078ec0ffULL, 0x0000000125257824ULL, 0x000fe400078e0a28ULL,
0x000000012b287824ULL, 0x040fe400078e0224ULL, 0x000000102b2c7824ULL, 0x000fe200078e00ffULL,
0x0000000525257c17ULL, 0x000fc8000f800000ULL, 0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL,
0x000000012b257824ULL, 0x000fc600078e0203ULL, 0x0000002a1d00720cULL, 0x000fe40003f06070ULL,
0xfffffff02c257812ULL, 0x000fe400078ee225ULL, 0x00000005332c7c10ULL, 0x000fe4000fffe0ffULL,
0x0001600025317811ULL, 0x000fc600078e20ffULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x018ac00026277984ULL, 0x002e640000004800ULL, 0x0000002716277224ULL, 0x002fc800078e0228ULL,
0x00005e0027267625ULL, 0x000fca00078e002dULL, 0x0000002f26287210ULL, 0x000fe20007f3e0ffULL,
0x000000012c267824ULL, 0x000fc800078e0224ULL, 0x000000ffff297224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fe20003f06070ULL, 0x000000102c337824ULL, 0x000fe400078e00ffULL,
0x018a08002b257984ULL, 0x000ea60000004800ULL, 0xfffffff0332e7812ULL, 0x000fe400078ee22eULL,
0x000000041d337810ULL, 0x000fe40007ffe0ffULL, 0x000160002e317811ULL, 0x002fc400078e20ffULL,
0x00000005332c7c10ULL, 0x000fca000fffe0ffULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26287210ULL, 0x000fe20007f3e0ffULL,
0x000000012c267824ULL, 0x000fc800078e0224ULL, 0x000000ffff297224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fe20003f06070ULL, 0x000000102c337824ULL, 0x000fe400078e00ffULL,
0x018a10002b257984ULL, 0x000ea60000004800ULL, 0xfffffff0332e7812ULL, 0x000fc800078ee22eULL,
0x000160002e297811ULL, 0x002fe400078e20ffULL, 0x000000061d317810ULL, 0x000fc80007ffe0ffULL,
0x00000005312c7c10ULL, 0x000fca000fffe0ffULL, 0x000000012c247824ULL, 0x040fe400078e0224ULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e2000c101c50ULL,
0x0000002a3100720cULL, 0x000fc60003f06070ULL, 0x018a18002b287984ULL, 0x000ea80000004800ULL,
0x018ac00028257984ULL, 0x004ea40000004800ULL, 0x0000002516247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fc800078e002dULL, 0x000000102c2d7824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007f3e0ffULL, 0xfffffff02d2e7812ULL, 0x000fe200078ee22eULL,
0x000000ffff257224ULL, 0x000fc600008e0625ULL, 0x000160002e277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003277824ULL, 0x000fe400078e00ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x018a00002c257984ULL, 0x000e620000004800ULL, 0x000000012c267824ULL, 0x040fe200078e0224ULL,
0x000000f0272f7812ULL, 0x000fe200078ec0ffULL, 0x000000012c297824ULL, 0x040fe400078e0203ULL,
0x000000102c2a7824ULL, 0x000fe200078e00ffULL, 0x018ac00025257984ULL, 0x002e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26287210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02a267812ULL, 0x000fe400078ee229ULL,
0x000000022c2a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff297224ULL, 0x000fe200000e0627ULL,
0x0001600026317811ULL, 0x000fc600078e20ffULL, 0x000000012a267824ULL, 0x040fe400078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e2000b901c50ULL,
0x000000012a2b7824ULL, 0x040fe400078e0203ULL, 0x000000102a2e7824ULL, 0x000fe200078e00ffULL,
0x018a08002c257984ULL, 0x000ea20000004800ULL, 0x000000042c287810ULL, 0x002fca0007ffe0ffULL,
0x0000001028317824ULL, 0x000fe200078e00ffULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f262a7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff02e267812ULL, 0x000fe200078ee22bULL,
0x00000001282e7824ULL, 0x000fe400078e0203ULL, 0x000000ffff2b7224ULL, 0x000fe200000e0627ULL,
0x0001600026297811ULL, 0x000fe200078e20ffULL, 0x0000000128267824ULL, 0x000fe200078e0224ULL,
0xfffffff0312e7812ULL, 0x000fc600078ee22eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a297faeULL, 0x0003e8000b901c50ULL, 0x018a10002c257984ULL, 0x000ea20000004800ULL,
0x000160002e297811ULL, 0x002fe400078e20ffULL, 0x000000062c2a7810ULL, 0x000fca0007ffe0ffULL,
0x000000012a247824ULL, 0x040fe400078e0224ULL, 0x000000012a2b7824ULL, 0x040fe400078e0203ULL,
0x000000102a2a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2b7812ULL, 0x000fc800078ee22bULL,
0x000160002b2b7811ULL, 0x000fe200078e20ffULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c50ULL,
0x018a18002c287984ULL, 0x000ea80000004800ULL, 0x018ac00028257984ULL, 0x004ea40000004800ULL,
0x0000002516247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff2b7224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe20003f04070ULL,
0x0000015000017945ULL, 0x000fe20003800000ULL, 0x0000000123237812ULL, 0x000fe400078ec0ffULL,
0x000000032200780cULL, 0x000fc80004705270ULL, 0x000000012300780cULL, 0x000fda0000705470ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x000000031700780cULL, 0x000fe40003f04070ULL,
0x0000000115157810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x0000005a1500720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0217ULL,
0x0000640015247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00018ac017237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00018a0017237811ULL, 0x040fe200078e10ffULL,
0x0000000117217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x0000005c2100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000117207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff6c00720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff6d7224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b1800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff277224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x018b1c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220257210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011423ULL,
0x0000002518187211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000218187819ULL, 0x000fc80000001223ULL, 0x000000180000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x018b1c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003187824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011603ULL,
0x0000007018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c20217812ULL, 0x000fca00078ec0ffULL,
0x0000000118277824ULL, 0x000fca00078e0221ULL, 0x0181000027227984ULL, 0x000e680000000800ULL,
0x0183000027237984ULL, 0x0004e20000000800ULL, 0x000000132200720bULL, 0x002fe20003f1d000ULL,
0x000128427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000187806ULL, 0x004fc800000e0100ULL,
0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e0013ULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f05270ULL,
0x000000132200720bULL, 0x000fe20003f34000ULL, 0x000128127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x0000002213247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0185002427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x8000002413137221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL, 0x0000001300297308ULL, 0x000e640000000800ULL,
0x0000002912127220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000127727f007947ULL, 0x000fea000b800000ULL, 0x00001f6229137589ULL, 0x0002a400000e0000ULL,
0x0000001311117220ULL, 0x084fe40000410000ULL, 0x0000001310107220ULL, 0x080fe40000410000ULL,
0x000000130d0d7220ULL, 0x080fe40000410000ULL, 0x000000130c0c7220ULL, 0x080fe40000410000ULL,
0x0000001309097220ULL, 0x080fe40000410000ULL, 0x0000001308087220ULL, 0x000fc40000410000ULL,
0x0000001305057220ULL, 0x080fe40000410000ULL, 0x0000001304047220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x000000134a4a7220ULL, 0x080fe40000410000ULL,
0x000000134b4b7220ULL, 0x080fe40000410000ULL, 0x000000134e4e7220ULL, 0x000fc40000410000ULL,
0x000000134f4f7220ULL, 0x080fe40000410000ULL, 0x0000001352527220ULL, 0x080fe40000410000ULL,
0x0000001353537220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000126a27f007947ULL, 0x000fea000b800000ULL,
0x00001f6129137589ULL, 0x00046400000e0000ULL, 0x000000130f0f7220ULL, 0x082fe40000410000ULL,
0x000000130e0e7220ULL, 0x080fe40000410000ULL, 0x000000130b0b7220ULL, 0x080fe40000410000ULL,
0x000000130a0a7220ULL, 0x080fe40000410000ULL, 0x0000001307077220ULL, 0x080fe40000410000ULL,
0x0000001306067220ULL, 0x000fc40000410000ULL, 0x0000001302027220ULL, 0x080fe40000410000ULL,
0x0000001348487220ULL, 0x080fe40000410000ULL, 0x0000001349497220ULL, 0x080fe40000410000ULL,
0x000000134c4c7220ULL, 0x080fe40000410000ULL, 0x000000134d4d7220ULL, 0x080fe40000410000ULL,
0x0000001350507220ULL, 0x000fc40000410000ULL, 0x0000001351517220ULL, 0x080fe40000410000ULL,
0x0000001354547220ULL, 0x080fe40000410000ULL, 0x0000001355557220ULL, 0x080fe40000410000ULL,
0x0000001358587220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff2aff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200190308ULL, 0x000e640000000800ULL, 0x0000001923230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001223127221ULL, 0x008fe40000010000ULL,
0x000000ffff137224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL, 0x0000016000017945ULL, 0x000fd80003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x000125027f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0002e400000e0000ULL, 0x000125627f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000eac000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0001309000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x0000eb3000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0001302000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001c20783bULL, 0x002e620000004200ULL,
0x000130005f407811ULL, 0x000fe200078e20ffULL, 0x00000f9000017945ULL, 0x000fe20003800000ULL,
0x0000006c6200720cULL, 0x000fe20003f46070ULL, 0x000000001e24783bULL, 0x004ea20000004200ULL,
0x000000145900720cULL, 0x000fc40003fc3070ULL, 0x0000006c6100720cULL, 0x000fe20003f26070ULL,
0x000000005d28783bULL, 0x000fe20000004200ULL, 0x000000145900720cULL, 0x000fc60003f03070ULL,
0x000000005e34783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000018ff447819ULL, 0x002fe20000011420ULL, 0x00000100202c7824ULL, 0x040fe200078e00ffULL,
0x0000888020327816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011421ULL, 0x00000100212d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000100242e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x0000888021467816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011425ULL,
0x0000888025817816ULL, 0x000fe200000000ffULL, 0x00000020003d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7d7819ULL, 0x000fe20000011424ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x0000888024827816ULL, 0x000fe200000000ffULL, 0x0000002d00477306ULL, 0x000fe20000200c00ULL,
0x0000010022207824ULL, 0x002fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011423ULL,
0x0000001b4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fc40000011426ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002c003f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff727819ULL, 0x000fe40000011427ULL, 0x0000888026797816ULL, 0x000fe400000000ffULL,
0x0000888027787816ULL, 0x000fe400000000ffULL, 0x00008880343a7816ULL, 0x000fe200000000ffULL,
0x00000020002d7306ULL, 0x0005e20000200c00ULL, 0x00000100252c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011422ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc40000011434ULL, 0x00000018ff847819ULL, 0x000fe2000001142cULL,
0x00010000242c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000010027207824ULL, 0x044fe200078e00ffULL, 0x0000002e00837306ULL, 0x0003e20000200c00ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe4000001142cULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00008880222c7816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000020007b7306ULL, 0x0005e20000200c00ULL,
0x00008880232e7816ULL, 0x002fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x00000018ff667819ULL, 0x000fe20000011436ULL,
0x0000002100247306ULL, 0x0003e20000200c00ULL, 0x0000010028207824ULL, 0x004fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011437ULL, 0x00008880363c7816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011420ULL, 0x0000010034207824ULL, 0x040fe200078e00ffULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x0000010023217824ULL, 0x002fe200078e00ffULL,
0x0000888035867816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fc40000011421ULL, 0x00000025007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00000018ff717819ULL, 0x000fe20000011428ULL,
0x0000004400447306ULL, 0x000ee20000200c00ULL, 0x0000010026257824ULL, 0x002fe200078e00ffULL,
0x0000541024457816ULL, 0x004fe20000000045ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000888028747816ULL, 0x000fc400000000ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff707819ULL, 0x000fe40000011429ULL, 0x0000888029887816ULL, 0x000fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001142aULL, 0x00000023003e7306ULL, 0x0002a20000200c00ULL,
0x000054103d447816ULL, 0x008fc40000000044ULL, 0x00008880373d7816ULL, 0x000fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fc6000001142bULL, 0x00000025007a7306ULL, 0x0007e20000200c00ULL,
0x0000010036237824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x0001300060257811ULL, 0x008fe400078e20ffULL,
0x000054103e317816ULL, 0x004fe40000000031ULL, 0x00000018ff367819ULL, 0x000fc60000011436ULL,
0x0000002000857306ULL, 0x0002b00000200c00ULL, 0x0000002600767306ULL, 0x000fe20000200c00ULL,
0x0000541032207816ULL, 0x002fe2000000003fULL, 0x0000010037327824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011423ULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe20000011432ULL, 0x0000002700777306ULL, 0x0003f00000200c00ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000000002524783bULL, 0x002e6e0000000200ULL,
0x00000021002f7306ULL, 0x0009f00000200c00ULL, 0x0000002200337306ULL, 0x0005e20000200c00ULL,
0x0000010035217824ULL, 0x010fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000034003b7306ULL, 0x0009e20000200c00ULL, 0x0001000035227824ULL, 0x004fca00078e00ffULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000054103a347816ULL, 0x010fe20000000085ULL, 0x00010000283a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fca0000011437ULL, 0x0000002100357306ULL, 0x0006a20000200c00ULL,
0x0000001a2424b232ULL, 0x082fe40000000000ULL, 0x0000001a2626b232ULL, 0x000fe40000000000ULL,
0x0000001b2525b232ULL, 0x080fe40000000000ULL, 0x0000001b2727b232ULL, 0x000fe20000000000ULL,
0x0000002c002c7306ULL, 0x000e620000200c00ULL, 0x0000541046217816ULL, 0x008fe40000000047ULL,
0x000000444044723cULL, 0x000fea00000018ffULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x0000541086357816ULL, 0x004fe20000000035ULL, 0x0000010029867824ULL, 0x000fc400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x000054102c2c7816ULL, 0x002fe4000000002dULL,
0x00000018ff297819ULL, 0x000fca0000011429ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541033307816ULL, 0x008fce0000000030ULL, 0x0000002e002e7306ULL, 0x000e620000200c00ULL,
0x000054103b387816ULL, 0x004fe20000000038ULL, 0x000000304030723cULL, 0x040fec00000018ffULL,
0x00000022007e7306ULL, 0x0004f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000000204020723cULL, 0x004f6200000018ffULL, 0x000054102e2d7816ULL, 0x002fcc000000002fULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054107e397816ULL, 0x008fe20000000039ULL,
0x0000002c402c723cULL, 0x000f6200000018ffULL, 0x00000018ff7e7819ULL, 0x000fca000001143aULL,
0x0000003d003d7306ULL, 0x000fe40000200c00ULL, 0x000000384038723cULL, 0x000fec00000018ffULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054103d3d7816ULL, 0x004fce000000003eULL, 0x0000003600877306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x0000008500287306ULL, 0x000ee20000200c00ULL,
0x000000344034723cULL, 0x002f6e00000018ffULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x0000541087667816ULL, 0x004fce0000000066ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541028677816ULL, 0x008fce0000000067ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000000664040723cULL, 0x000b6200000018ffULL, 0x0000541082287816ULL, 0x002fcc0000000083ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000088802a667816ULL, 0x020fce00000000ffULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000008000807306ULL, 0x000e700000200c00ULL,
0x0000002900677306ULL, 0x0005f00000200c00ULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0000541081297816ULL, 0x004fe20000000084ULL, 0x000001002a817824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000000282420723cULL, 0x000b620000001820ULL,
0x00000018ff2a7819ULL, 0x000fcc000001142aULL, 0x0000541080287816ULL, 0x022fe2000000007dULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054107f297816ULL, 0x000fe4000000007cULL,
0x000088802b7c7816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000000282444723cULL, 0x000b6e0000001844ULL, 0x0000541079287816ULL, 0x028fe2000000007aULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541078297816ULL, 0x004fe2000000007bULL,
0x000001002b787824ULL, 0x000fc400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x00000028242c723cULL, 0x000b62000000182cULL, 0x00000018ff2b7819ULL, 0x000fcc000001142bULL,
0x0000008800857306ULL, 0x000fe20000200c00ULL, 0x000000ffff287224ULL, 0x020fe200078e007cULL,
0x0000541077297816ULL, 0x002fcc0000000072ULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000002800797306ULL, 0x0007f00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541076287816ULL, 0x008fce0000000073ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000000282430723cULL, 0x000b6e0000001830ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x0000541074287816ULL, 0x024fe40000000075ULL, 0x0000541085297816ULL, 0x002fca0000000086ULL,
0x0000006600667306ULL, 0x000fe40000200c00ULL, 0x000000282434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000054107e287816ULL, 0x028fe40000000071ULL,
0x0000541067297816ULL, 0x000fca0000000070ULL, 0x0000007800787306ULL, 0x000ea40000200c00ULL,
0x000000282438723cULL, 0x000b6c0000001838ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000541066287816ULL, 0x022fe40000000081ULL, 0x000000016c667810ULL, 0x000fc80007ffe0ffULL,
0x000000666200720cULL, 0x080fe20005746470ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541079297816ULL, 0x004fe40000000078ULL, 0x000000666100720cULL, 0x000fca0004f26470ULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x00000028243c723cULL, 0x000b6e000000183cULL,
0x0000002b002b7306ULL, 0x000ea20000200c00ULL, 0x000054102a287816ULL, 0x022fe4000000006fULL,
0x000054102b297816ULL, 0x004fce000000006eULL, 0x000000282440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000002011117221ULL, 0x000fe40000010000ULL, 0x0000002110107221ULL, 0x000fe40000010000ULL,
0x000000440d0d7221ULL, 0x000fe40000010000ULL, 0x000000450c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x000000341f1f7221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384b4b7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004053537221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000220f0f7221ULL, 0x000fe40000010000ULL,
0x000000230e0e7221ULL, 0x000fe40000010000ULL, 0x000000460b0b7221ULL, 0x000fc40000010000ULL,
0x000000470a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x0000003202027221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x0000003649497221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4d4d7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e51517221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004255557221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff207f8cULL, 0x000e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011666ULL, 0x000000ffff287224ULL, 0x020fe200078e00ffULL,
0x000000145900720cULL, 0x080fe40003fc3070ULL, 0x0000002366237207ULL, 0x040fe40002800000ULL,
0x0000000366667812ULL, 0x000fe400078ec0ffULL, 0x0000000223257810ULL, 0x000fe40007ffe0ffULL,
0x000000145900720cULL, 0x000fc40003f03070ULL, 0x00000040ff2c7803ULL, 0x000fe40000000000ULL,
0x0000000325237812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x002fe200078e0021ULL,
0x000000ff66217207ULL, 0x000fe40006800000ULL, 0x0000001425207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8400ff227984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c486dULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8400ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c482bULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x040fe20007ffe0ffULL,
0x0000000420227824ULL, 0x000fe200078e0223ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x0000005b2400720cULL, 0x000fe20003fc6070ULL, 0x0000004022297824ULL, 0x000fca00078e00ffULL,
0x0000004057227812ULL, 0x000fce00078ef829ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x000000051d2d7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000021d2b7810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff2f7424ULL, 0x000fe200078e00ffULL,
0x000000041d357810ULL, 0x000fe20007ffe0ffULL, 0x018a00002d277984ULL, 0x000e620000004800ULL,
0x000000012d247824ULL, 0x040fe200078e0222ULL, 0x000000f026317812ULL, 0x000fe200078ec0ffULL,
0x000000102d287824ULL, 0x000fe200078e00ffULL, 0x000000295c267217ULL, 0x000fe40007800000ULL,
0x000000052b2e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a29ULL,
0x000000012e307824ULL, 0x000fc600078e0203ULL, 0x0000000526267c17ULL, 0x000fc8000f800000ULL,
0x80000005262a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012e267824ULL, 0x000fe200078e0222ULL,
0x018ac00027277984ULL, 0x002e640000004800ULL, 0x0000002716247224ULL, 0x002fe400078e0224ULL,
0x000000012d277824ULL, 0x000fe400078e0203ULL, 0x00005e0024247625ULL, 0x000fc600078e002fULL,
0xfffffff028277812ULL, 0x000fe400078ee227ULL, 0x0000003124247210ULL, 0x000fe40007fde0ffULL,
0x0001400027297811ULL, 0x000fc600078e20ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x0000002a1d00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024297faeULL, 0x0003e8000f101c50ULL, 0x018a08002d287984ULL, 0x000ea20000004800ULL,
0x000000102e257824ULL, 0x002fe200078e00ffULL, 0x00000005352e7c10ULL, 0x000fc8000fffe0ffULL,
0xfffffff025307812ULL, 0x000fe200078ee230ULL, 0x000000012e247824ULL, 0x000fc600078e0222ULL,
0x0001400030337811ULL, 0x000fe200078e20ffULL, 0x018ac00028277984ULL, 0x004e640000004800ULL,
0x0000002716267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002fULL,
0x0000003126267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x0000002a2b00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026337faeULL, 0x0003e8000f101c50ULL, 0x018a10002d2b7984ULL, 0x000ea80000004800ULL,
0x018ac0002b2b7984ULL, 0x004ea40000004800ULL, 0x0000002b16247224ULL, 0x004fe200078e0224ULL,
0x000000061d2b7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0024247625ULL, 0x000fca00078e002fULL,
0x0000003124287210ULL, 0x000fe20007fde0ffULL, 0x000000012e247824ULL, 0x000fc800078e0203ULL,
0x000000ffff297224ULL, 0x000fe200030e0625ULL, 0x0000002a3500720cULL, 0x000fe20003fc6070ULL,
0x000000102e257824ULL, 0x000fe200078e00ffULL, 0x000000052b2e7c10ULL, 0x000fc8000fffe0ffULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x000000012e227824ULL, 0x000fc600078e0222ULL,
0x0001400024277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e8000f101c50ULL, 0x018a18002d267984ULL, 0x000ea20000004800ULL,
0x000000102e277824ULL, 0x002fc600078e00ffULL, 0x018ac00026257984ULL, 0x004e640000004800ULL,
0x0000002516257224ULL, 0x002fe400078e0222ULL, 0x000000012e227824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fc600078e002fULL, 0xfffffff027227812ULL, 0x000fe400078ee222ULL,
0x0000003124247210ULL, 0x000fe40007fde0ffULL, 0x0001400022277811ULL, 0x000fc600078e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000002a2b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022b2e7810ULL, 0x040fe20007ffe0ffULL, 0x018a00002b287984ULL, 0x000e620000004800ULL,
0x000000012b247824ULL, 0x000fe400078e0222ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x018ac00028257984ULL, 0x002e640000004800ULL, 0x0000002516257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe20007fde0ffULL,
0x000000012b247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102b257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0001400024317811ULL, 0x000fe200078e20ffULL, 0x000000012e247824ULL, 0x000fc800078e0222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026317faeULL, 0x0003e8000b901c50ULL,
0x018a08002b2a7984ULL, 0x000ea80000004800ULL, 0x018ac0002a257984ULL, 0x004ea40000004800ULL,
0x0000002516247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24287210ULL, 0x000fe20007fde0ffULL, 0x000000012e247824ULL, 0x000fc800078e0203ULL,
0x000000ffff297224ULL, 0x000fe400030e0625ULL, 0x000000102e257824ULL, 0x000fe200078e00ffULL,
0x000000042b2e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0001400024317811ULL, 0x002fe200078e20ffULL, 0x000000012e247824ULL, 0x000fc800078e0222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028317faeULL, 0x0003e8000b901c50ULL,
0x018a10002b2a7984ULL, 0x000ea80000004800ULL, 0x018ac0002a257984ULL, 0x0044e40000004800ULL,
0x000000062b2a7810ULL, 0x004fca0007ffe0ffULL, 0x000000012a227824ULL, 0x000fe400078e0222ULL,
0x0000002516247224ULL, 0x008fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fe20007fde0ffULL, 0x000000012e247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102e257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0001400024297811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026297faeULL, 0x0003e8000b901c50ULL,
0x018a18002b287984ULL, 0x000ea80000004800ULL, 0x018ac00028257984ULL, 0x004ea40000004800ULL,
0x0000002516257224ULL, 0x004fc400078e0222ULL, 0x000000012a227824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fc800078e002dULL, 0x000000102a2d7824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007fde0ffULL, 0xfffffff02d227812ULL, 0x000fe200078ee222ULL,
0x000000ffff257224ULL, 0x000fc600030e0625ULL, 0x0001400022277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff2b7224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x018b8c00ff227984ULL, 0x000e620000000800ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c482bULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8c00ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe40003fc4070ULL,
0x00018a0017257811ULL, 0x000fe400078e10ffULL, 0x000000ff21227207ULL, 0x000fc40003000000ULL,
0x000000ff21247207ULL, 0x000fc60007000000ULL, 0x0000000123237824ULL, 0x000fc800078e0222ULL,
0x0000004023217824ULL, 0x040fe200078e00ffULL, 0x0000002023207211ULL, 0x000fc800078ff0ffULL,
0x000000c021217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL, 0x0000002020227810ULL, 0x000fca0007ffe0ffULL,
0x0000000117237824ULL, 0x100fe400078e0222ULL, 0x0000680021207a24ULL, 0x000fe400078e0222ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x0000005c2300720cULL, 0x000fe20003fc6070ULL,
0x0000000117207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b7800ff667f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000ffd27f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0004e400000e0000ULL,
0x000100327f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000110f000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00010a6000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x0001116000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000109f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006524783bULL, 0x006e620000004200ULL, 0x000000ff2c00720cULL, 0x000fe20003fc5270ULL,
0x00000f4000017945ULL, 0x000fe20003800000ULL, 0x0001300069407811ULL, 0x000fe200078e20ffULL,
0x000000006428783bULL, 0x000ea80000004200ULL, 0x000000006320783bULL, 0x000fe80000004200ULL,
0x000000006834783bULL, 0x000fe80000004200ULL, 0x000000004040783bULL, 0x000f220000000200ULL,
0x00000100242e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe20000011424ULL,
0x0000010027337824ULL, 0x000fe200078e00ffULL, 0x0000888024447816ULL, 0x000fe200000000ffULL,
0x0000010028327824ULL, 0x004fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011428ULL,
0x00000100252f7824ULL, 0x000fe200078e00ffULL, 0x0000002e003f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fc40000011429ULL, 0x0000888028847816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x0000888029827816ULL, 0x040fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe20000011426ULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x00000100292e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011428ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000888026287816ULL, 0x040fe200000000ffULL,
0x0000001a4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff857819ULL, 0x000fe2000001142eULL,
0x0000001a4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff7e7819ULL, 0x000fe20000011429ULL,
0x0000010026297824ULL, 0x040fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe20000011424ULL,
0x0001000025247824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000001b4141b232ULL, 0x080fe20000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011427ULL,
0x0000001b4343b232ULL, 0x000fe20000000000ULL, 0x00000018ff2d7819ULL, 0x000fe20000011425ULL,
0x0000003200837306ULL, 0x0005e20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000018ff6f7819ULL, 0x000fe40000011420ULL, 0x0000888020737816ULL, 0x000fe400000000ffULL,
0x0000888025457816ULL, 0x000fe200000000ffULL, 0x00000033003d7306ULL, 0x000fe20000200c00ULL,
0x0000888027327816ULL, 0x044fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000002600337306ULL, 0x0005e20000200c00ULL,
0x0000888035877816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011435ULL, 0x00000018ff867819ULL, 0x000fe20000011436ULL,
0x0000002d002d7306ULL, 0x000fe20000200c00ULL, 0x0000010020267824ULL, 0x044fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011437ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00008880363c7816ULL, 0x000fc400000000ffULL, 0x00000018ff767819ULL, 0x000fe20000011426ULL,
0x0000010034267824ULL, 0x040fe200078e00ffULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00000018ff707819ULL, 0x000fe40000011420ULL, 0x0000888034207816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000541044447816ULL, 0x002fe2000000003fULL, 0x0000002e00257306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff6e7819ULL, 0x000fe40000011421ULL,
0x0000888021747816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x000fe2000001142aULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fe4000001142bULL,
0x000088802a797816ULL, 0x000fe400000000ffULL, 0x000088802b777816ULL, 0x000fc400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011422ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00000018ff667819ULL, 0x000fce0000011423ULL, 0x0000002f003e7306ULL, 0x000e700000200c00ULL,
0x00000027003a7306ULL, 0x0005f00000200c00ULL, 0x00000029002f7306ULL, 0x0007e20000200c00ULL,
0x0000010035277824ULL, 0x004fe200078e00ffULL, 0x0000541045457816ULL, 0x002fe2000000003eULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00008880373e7816ULL, 0x000fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000028002e7306ULL, 0x0002a20000200c00ULL,
0x000001002b297824ULL, 0x048fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x000000444044723cULL, 0x000f6400000018ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000001002a287824ULL, 0x042fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000026007f7306ULL, 0x0002e20000200c00ULL, 0x00000018ff2a7819ULL, 0x000fce000001142aULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000010036267824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011426ULL,
0x00000027008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fce0000011436ULL,
0x00000029007c7306ULL, 0x0003f00000200c00ULL, 0x00000028007a7306ULL, 0x0009e20000200c00ULL,
0x0000541024297816ULL, 0x002fe4000000002dULL, 0x00005410322d7816ULL, 0x000fe2000000003dULL,
0x0000010037327824ULL, 0x000fc400078e00ffULL, 0x0001000037377824ULL, 0x000fe400078e00ffULL,
0x0000003100317306ULL, 0x000e620000200c00ULL, 0x0000541025287816ULL, 0x010fe4000000002cULL,
0x000130006a257811ULL, 0x000fe400078e20ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011432ULL,
0x000054102e2c7816ULL, 0x004fe2000000002fULL, 0x00000034003b7306ULL, 0x0007e20000200c00ULL,
0x000000002524783bULL, 0x000eaa0000000200ULL, 0x0000002c402c723cULL, 0x000fe400000018ffULL,
0x0000003500887306ULL, 0x0009e20000200c00ULL, 0x0000541020347816ULL, 0x008fc4000000007fULL,
0x00000018ff207819ULL, 0x000fe40000011437ULL, 0x000054103a317816ULL, 0x002fe20000000031ULL,
0x00000100213a7824ULL, 0x000fe400078e00ffULL, 0x0000003000307306ULL, 0x000e620000200c00ULL,
0x0000541087357816ULL, 0x010fe2000000008aULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc8000001143aULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000003800387306ULL, 0x000ef00000200c00ULL, 0x0000003900397306ULL, 0x000f220000200c00ULL,
0x0000541033307816ULL, 0x002fce0000000030ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054103b387816ULL, 0x008fe20000000038ULL, 0x000000304030723cULL, 0x000fe200000018ffULL,
0x0000001a2424b232ULL, 0x084fe40000000000ULL, 0x0000001a2626b232ULL, 0x000fe40000000000ULL,
0x0000001b2525b232ULL, 0x080fe20000000000ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000541088397816ULL, 0x010fe20000000039ULL, 0x0000001b2727b232ULL, 0x000fe20000000000ULL,
0x0000888022887816ULL, 0x000fca00000000ffULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000000384038723cULL, 0x000fee00000018ffULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003fULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000054103e3d7816ULL, 0x004fce000000003dULL,
0x0000003600897306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x00000020008a7306ULL, 0x0004e20000200c00ULL, 0x000000344034723cULL, 0x002fee00000018ffULL,
0x00000021007f7306ULL, 0x0007e20000200c00ULL, 0x0000541089207816ULL, 0x004fe20000000086ULL,
0x0001000022867824ULL, 0x000fcc00078e00ffULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000054108a217816ULL, 0x008fe20000000081ULL, 0x000000ffff817224ULL, 0x000fcc00078e0088ULL,
0x0000008200827306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000002a00757306ULL, 0x000ff00000200c00ULL, 0x0000002b00787306ULL, 0x0005f00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000000284028723cULL, 0x044f6e00000018ffULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000000204040723cULL, 0x000b6e00000018ffULL,
0x0000010022207824ULL, 0x020fe200078e00ffULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541082217816ULL, 0x002fc40000000085ULL, 0x00000018ff827819ULL, 0x000fe40000011486ULL,
0x00000018ff207819ULL, 0x000fc60000011420ULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000002000227306ULL, 0x0007f00000200c00ULL, 0x0000007900797306ULL, 0x000f220000200c00ULL,
0x0000541084207816ULL, 0x008fc40000000083ULL, 0x0000888023837816ULL, 0x000fca00000000ffULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x000000202444723cULL, 0x000b6e0000001844ULL,
0x0000541080207816ULL, 0x024fe2000000007dULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054107e217816ULL, 0x002fe2000000007bULL, 0x00000100237b7824ULL, 0x000fc400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000202428723cULL, 0x000b620000001828ULL,
0x00000018ff237819ULL, 0x000fcc0000011423ULL, 0x000000ffff217224ULL, 0x020fe200078e0083ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541079207816ULL, 0x010fce000000007aULL,
0x00000021007d7306ULL, 0x0007f00000200c00ULL, 0x0000007600767306ULL, 0x000f220000200c00ULL,
0x0000541077217816ULL, 0x008fce000000007cULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000020242c723cULL, 0x000b6e000000182cULL, 0x0000008700877306ULL, 0x000ee20000200c00ULL,
0x0000541075207816ULL, 0x024fe40000000072ULL, 0x0000541078217816ULL, 0x002fca0000000071ULL,
0x0000006f006f7306ULL, 0x000fe40000200c00ULL, 0x000000202430723cULL, 0x000b6c0000001830ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541073207816ULL, 0x030fe40000000076ULL,
0x0000541074217816ULL, 0x008fca0000000087ULL, 0x0000007000707306ULL, 0x000ea40000200c00ULL,
0x000000202434723cULL, 0x000b6c0000001834ULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x000054107f217816ULL, 0x022fce000000006eULL, 0x0000007b007a7306ULL, 0x000e620000200c00ULL,
0x0000541070207816ULL, 0x004fce000000006fULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000000202438723cULL, 0x000b6e0000001838ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541081207816ULL, 0x028fe40000000022ULL, 0x000054107d217816ULL, 0x002fca000000007aULL,
0x0000008200827306ULL, 0x000e640000200c00ULL, 0x00000020243c723cULL, 0x000b6c000000183cULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000541082207816ULL, 0x022fe4000000006dULL,
0x0000541023217816ULL, 0x004fce0000000066ULL, 0x000000202440723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000004411117221ULL, 0x000fe40000010000ULL, 0x0000004510107221ULL, 0x000fe40000010000ULL,
0x000000280d0d7221ULL, 0x000fe40000010000ULL, 0x000000290c0c7221ULL, 0x000fe40000010000ULL,
0x0000002c09097221ULL, 0x000fe40000010000ULL, 0x0000002d08087221ULL, 0x000fc40000010000ULL,
0x0000003005057221ULL, 0x000fe40000010000ULL, 0x0000003104047221ULL, 0x000fe40000010000ULL,
0x000000341f1f7221ULL, 0x000fe40000010000ULL, 0x000000354a4a7221ULL, 0x000fe40000010000ULL,
0x000000384b4b7221ULL, 0x000fe40000010000ULL, 0x000000394e4e7221ULL, 0x000fc40000010000ULL,
0x0000003c4f4f7221ULL, 0x000fe40000010000ULL, 0x0000003d52527221ULL, 0x000fe40000010000ULL,
0x0000004053537221ULL, 0x020fe40000010000ULL, 0x0000004156567221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000460f0f7221ULL, 0x000fe40000010000ULL,
0x000000470e0e7221ULL, 0x000fe40000010000ULL, 0x0000002a0b0b7221ULL, 0x000fc40000010000ULL,
0x0000002b0a0a7221ULL, 0x000fe40000010000ULL, 0x0000002e07077221ULL, 0x000fe40000010000ULL,
0x0000002f06067221ULL, 0x000fe40000010000ULL, 0x0000003202027221ULL, 0x000fe40000010000ULL,
0x0000003348487221ULL, 0x000fe40000010000ULL, 0x0000003649497221ULL, 0x000fc40000010000ULL,
0x000000374c4c7221ULL, 0x000fe40000010000ULL, 0x0000003a4d4d7221ULL, 0x000fe40000010000ULL,
0x0000003b50507221ULL, 0x000fe40000010000ULL, 0x0000003e51517221ULL, 0x000fe40000010000ULL,
0x0000003f54547221ULL, 0x000fe40000010000ULL, 0x0000004255557221ULL, 0x020fc40000010000ULL,
0x0000004358587221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000006b6c00720cULL, 0x000fe20003f06070ULL, 0x018b8800ff247f8cULL, 0x020e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaa5000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c014217811ULL, 0x000fe200078e40ffULL,
0x018b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000005c2100720cULL, 0x000fda0003f06070ULL,
0x0000562000000947ULL, 0x000fea0003800000ULL, 0x000000ffff6c7224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x000fe2000001166cULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000036c227812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000000216c217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000321237810ULL, 0x000fc80007ffe0ffULL, 0x0000000323217812ULL, 0x040fe400078ec0ffULL,
0x0000001423207211ULL, 0x002fc400078ff0ffULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x018b7c00ff247984ULL, 0x002e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028262b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011429ULL, 0x0000002b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000224247819ULL, 0x000fc80000001229ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b7c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fc40000015200ULL,
0x018b8c00ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028262b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e27ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff247819ULL, 0x000fc80000011429ULL,
0x0000002b24247211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000224247819ULL, 0x000fc80000001229ULL, 0x000000240000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff247984ULL, 0x000e640000000800ULL,
0x8000000024ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420257824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x0000005b2400720cULL, 0x000fe40003f06070ULL,
0x0000002025287811ULL, 0x000fc800078e30ffULL, 0x0000006057247812ULL, 0x000fce00078ef828ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003297824ULL, 0x000fe200078e00ffULL, 0x000000285c257217ULL, 0x000fe20007800000ULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x000000021d337810ULL, 0x000fe20007ffe0ffULL,
0x018a00002b267984ULL, 0x000e620000004800ULL, 0x000000f0292f7812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x000fe400078e0a28ULL, 0x000000012b287824ULL, 0x040fe400078e0224ULL,
0x000000102b2c7824ULL, 0x000fe200078e00ffULL, 0x0000000525257c17ULL, 0x000fc8000f800000ULL,
0x80000005252a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000012b257824ULL, 0x000fc600078e0203ULL,
0x0000002a1d00720cULL, 0x000fe40003f06070ULL, 0xfffffff02c257812ULL, 0x000fe400078ee225ULL,
0x00000005332c7c10ULL, 0x000fe4000fffe0ffULL, 0x0001600025317811ULL, 0x000fc600078e20ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00026277984ULL, 0x002e640000004800ULL,
0x0000002716277224ULL, 0x002fc800078e0228ULL, 0x00005e0027267625ULL, 0x000fca00078e002dULL,
0x0000002f26287210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0224ULL,
0x000000ffff297224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x018a08002b257984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x000000041d337810ULL, 0x000fe40007ffe0ffULL,
0x000160002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x018ac00025257984ULL, 0x004e640000004800ULL,
0x0000002516267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26287210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0224ULL,
0x000000ffff297224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x018a10002b257984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fc800078ee22eULL, 0x000160002e297811ULL, 0x002fe400078e20ffULL,
0x000000061d317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c247824ULL, 0x040fe400078e0224ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff277224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e2000c101c50ULL, 0x0000002a3100720cULL, 0x000fc60003f06070ULL,
0x018a18002b287984ULL, 0x000ea80000004800ULL, 0x018ac00028257984ULL, 0x004ea40000004800ULL,
0x0000002516247224ULL, 0x004fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fc800078e002dULL,
0x000000102c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f24247210ULL, 0x000fc80007f3e0ffULL,
0xfffffff02d2e7812ULL, 0x000fe200078ee22eULL, 0x000000ffff257224ULL, 0x000fc600008e0625ULL,
0x000160002e277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fe400078e00ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x018a00002c257984ULL, 0x000e620000004800ULL,
0x000000012c267824ULL, 0x040fe200078e0224ULL, 0x000000f0272f7812ULL, 0x000fe200078ec0ffULL,
0x000000012c297824ULL, 0x040fe400078e0203ULL, 0x000000102c2a7824ULL, 0x000fe200078e00ffULL,
0x018ac00025257984ULL, 0x002e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26287210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02a267812ULL, 0x000fe400078ee229ULL, 0x000000022c2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200000e0627ULL, 0x0001600026317811ULL, 0x000fc600078e20ffULL,
0x000000012a267824ULL, 0x040fe400078e0224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e2000b901c50ULL, 0x000000012a2b7824ULL, 0x040fe400078e0203ULL,
0x000000102a2e7824ULL, 0x000fe200078e00ffULL, 0x018a08002c257984ULL, 0x000ea20000004800ULL,
0x000000042c287810ULL, 0x002fca0007ffe0ffULL, 0x0000001028317824ULL, 0x000fe200078e00ffULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f262a7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff02e267812ULL, 0x000fe200078ee22bULL, 0x00000001282e7824ULL, 0x000fe400078e0203ULL,
0x000000ffff2b7224ULL, 0x000fe200000e0627ULL, 0x0001600026297811ULL, 0x000fe200078e20ffULL,
0x0000000128267824ULL, 0x000fe200078e0224ULL, 0xfffffff0312e7812ULL, 0x000fc600078ee22eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a297faeULL, 0x0003e8000b901c50ULL,
0x018a10002c257984ULL, 0x000ea20000004800ULL, 0x000160002e297811ULL, 0x002fe400078e20ffULL,
0x000000062c2a7810ULL, 0x000fca0007ffe0ffULL, 0x000000012a247824ULL, 0x040fe400078e0224ULL,
0x000000012a2b7824ULL, 0x040fe400078e0203ULL, 0x000000102a2a7824ULL, 0x000fca00078e00ffULL,
0xfffffff02a2b7812ULL, 0x000fc800078ee22bULL, 0x000160002b2b7811ULL, 0x000fe200078e20ffULL,
0x018ac00025257984ULL, 0x004e640000004800ULL, 0x0000002516267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c50ULL, 0x018a18002c287984ULL, 0x000ea80000004800ULL,
0x018ac00028257984ULL, 0x004ea40000004800ULL, 0x0000002516247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242b7faeULL, 0x0003e6000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000123237812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012300780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031700780cULL, 0x000fe40003f04070ULL, 0x0000000115157810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x0000005a1500720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0217ULL, 0x0000640015247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00018ac017237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000205900720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00018a0017237811ULL, 0x040fe200078e10ffULL, 0x0000000117217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x0000005c2100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff6c00720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff6d7224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b3800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff277224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x018b3c05ff187984ULL, 0x000e640008000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220257210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff187819ULL, 0x000fc80000011423ULL, 0x0000002518187211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000218187819ULL, 0x000fc80000001223ULL,
0x000000180000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000124247810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x018b3c05ff187984ULL, 0x000e640008000800ULL, 0x8000000018ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003187824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007018187812ULL, 0x000fe400078ec0ffULL,
0x0000000c20217812ULL, 0x000fca00078ec0ffULL, 0x0000000118277824ULL, 0x000fca00078e0221ULL,
0x0181800027227984ULL, 0x000e680000000800ULL, 0x0183800027237984ULL, 0x0004e20000000800ULL,
0x000000132200720bULL, 0x002fe20003f1d000ULL, 0x0000d5a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800000e0100ULL, 0x0000ffff182a7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e0013ULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f05270ULL, 0x000000132200720bULL, 0x000fe20003f34000ULL,
0x0000d5727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x0000002213247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0185802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x8000002413137221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300297308ULL, 0x000e640000000800ULL, 0x0000002912127220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000d4d27f007947ULL, 0x000fea000b800000ULL,
0x00001f6229137589ULL, 0x0002a400000e0000ULL, 0x0000001311117220ULL, 0x084fe40000410000ULL,
0x0000001310107220ULL, 0x080fe40000410000ULL, 0x000000130d0d7220ULL, 0x080fe40000410000ULL,
0x000000130c0c7220ULL, 0x080fe40000410000ULL, 0x0000001309097220ULL, 0x080fe40000410000ULL,
0x0000001308087220ULL, 0x000fc40000410000ULL, 0x0000001305057220ULL, 0x080fe40000410000ULL,
0x0000001304047220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x080fe40000410000ULL,
0x000000134a4a7220ULL, 0x080fe40000410000ULL, 0x000000134b4b7220ULL, 0x080fe40000410000ULL,
0x000000134e4e7220ULL, 0x000fc40000410000ULL, 0x000000134f4f7220ULL, 0x080fe40000410000ULL,
0x0000001352527220ULL, 0x080fe40000410000ULL, 0x0000001353537220ULL, 0x080fe40000410000ULL,
0x0000001356567220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000d4027f007947ULL, 0x000fea000b800000ULL, 0x00001f6129137589ULL, 0x00046400000e0000ULL,
0x000000130f0f7220ULL, 0x082fe40000410000ULL, 0x000000130e0e7220ULL, 0x080fe40000410000ULL,
0x000000130b0b7220ULL, 0x080fe40000410000ULL, 0x000000130a0a7220ULL, 0x080fe40000410000ULL,
0x0000001307077220ULL, 0x080fe40000410000ULL, 0x0000001306067220ULL, 0x000fc40000410000ULL,
0x0000001302027220ULL, 0x080fe40000410000ULL, 0x0000001348487220ULL, 0x080fe40000410000ULL,
0x0000001349497220ULL, 0x080fe40000410000ULL, 0x000000134c4c7220ULL, 0x080fe40000410000ULL,
0x000000134d4d7220ULL, 0x080fe40000410000ULL, 0x0000001350507220ULL, 0x000fc40000410000ULL,
0x0000001351517220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x080fe40000410000ULL, 0x0000001358587220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff2aff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff180816ULL, 0x000fc60000000018ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200190308ULL, 0x000e640000000800ULL,
0x0000001923230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001223127221ULL, 0x008fe40000010000ULL, 0x000000ffff137224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff18ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000019ff1a723eULL, 0x000fc800000000ffULL, 0x000054101a227816ULL, 0x000fe2000000001aULL,
0x0000d2627f007947ULL, 0x000fea000b800000ULL, 0x00001f62221a7589ULL, 0x0002e400000e0000ULL,
0x0000d2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f61221b7589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001062277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001411000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000da4000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x0000001862277810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff287424ULL, 0x000fe200078e00ffULL, 0x0001418000207802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000d9d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001c20783bULL, 0x002e620000004200ULL, 0x000138005f407811ULL, 0x000fe200078e20ffULL,
0x00000f9000017945ULL, 0x000fe20003800000ULL, 0x0000006c6200720cULL, 0x000fe20003f46070ULL,
0x000000001e24783bULL, 0x004ea20000004200ULL, 0x000000145900720cULL, 0x000fc40003fc3070ULL,
0x0000006c6100720cULL, 0x000fe20003f26070ULL, 0x000000005d28783bULL, 0x000fe20000004200ULL,
0x000000145900720cULL, 0x000fc60003f03070ULL, 0x000000005e34783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000018ff447819ULL, 0x002fe20000011420ULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x0000888020327816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011421ULL,
0x00000100212d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000100242e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000888021467816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe40000011425ULL, 0x0000888025817816ULL, 0x000fe200000000ffULL,
0x00000020003d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000001a4040b232ULL, 0x098fe20000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000001a4242b232ULL, 0x000fe20000000000ULL, 0x00000018ff7d7819ULL, 0x000fe20000011424ULL,
0x0000001b4141b232ULL, 0x080fe20000000000ULL, 0x0000888024827816ULL, 0x000fe200000000ffULL,
0x0000002d00477306ULL, 0x000fe20000200c00ULL, 0x0000010022207824ULL, 0x002fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011423ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fc40000011426ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002c003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011427ULL,
0x0000888026797816ULL, 0x000fe400000000ffULL, 0x0000888027787816ULL, 0x000fe400000000ffULL,
0x00008880343a7816ULL, 0x000fe200000000ffULL, 0x00000020002d7306ULL, 0x0005e20000200c00ULL,
0x00000100252c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011422ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011434ULL,
0x00000018ff847819ULL, 0x000fe2000001142cULL, 0x00010000242c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000010027207824ULL, 0x044fe200078e00ffULL,
0x0000002e00837306ULL, 0x0003e20000200c00ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe4000001142cULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00008880222c7816ULL, 0x040fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000020007b7306ULL, 0x0005e20000200c00ULL, 0x00008880232e7816ULL, 0x002fc400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x00000018ff667819ULL, 0x000fe20000011436ULL, 0x0000002100247306ULL, 0x0003e20000200c00ULL,
0x0000010028207824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe40000011437ULL,
0x00008880363c7816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fe20000011420ULL,
0x0000010034207824ULL, 0x040fe200078e00ffULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000010023217824ULL, 0x002fe200078e00ffULL, 0x0000888035867816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x00000025007f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff717819ULL, 0x000fe20000011428ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000010026257824ULL, 0x002fe200078e00ffULL, 0x0000541024457816ULL, 0x004fe20000000045ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888028747816ULL, 0x000fc400000000ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff707819ULL, 0x000fe40000011429ULL,
0x0000888029887816ULL, 0x000fe400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001142aULL,
0x00000023003e7306ULL, 0x0002a20000200c00ULL, 0x000054103d447816ULL, 0x008fc40000000044ULL,
0x00008880373d7816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fc6000001142bULL,
0x00000025007a7306ULL, 0x0007e20000200c00ULL, 0x0000010036237824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0001380060257811ULL, 0x008fe400078e20ffULL, 0x000054103e317816ULL, 0x004fe40000000031ULL,
0x00000018ff367819ULL, 0x000fc60000011436ULL, 0x0000002000857306ULL, 0x0002b00000200c00ULL,
0x0000002600767306ULL, 0x000fe20000200c00ULL, 0x0000541032207816ULL, 0x002fe2000000003fULL,
0x0000010037327824ULL, 0x040fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe20000011423ULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe20000011432ULL,
0x0000002700777306ULL, 0x0003f00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000000002524783bULL, 0x002e6e0000000200ULL, 0x00000021002f7306ULL, 0x0009f00000200c00ULL,
0x0000002200337306ULL, 0x0005e20000200c00ULL, 0x0000010035217824ULL, 0x010fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000034003b7306ULL, 0x0009e20000200c00ULL,
0x0001000035227824ULL, 0x004fca00078e00ffULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000054103a347816ULL, 0x010fe20000000085ULL,
0x00010000283a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fca0000011437ULL,
0x0000002100357306ULL, 0x0006a20000200c00ULL, 0x0000001a2424b232ULL, 0x082fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe40000000000ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000002c002c7306ULL, 0x000e620000200c00ULL,
0x0000541046217816ULL, 0x008fe40000000047ULL, 0x000000444044723cULL, 0x000fea00000018ffULL,
0x0000003000307306ULL, 0x000ee20000200c00ULL, 0x0000541086357816ULL, 0x004fe20000000035ULL,
0x0000010029867824ULL, 0x000fc400078e00ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x000054102c2c7816ULL, 0x002fe4000000002dULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x0000541033307816ULL, 0x008fce0000000030ULL,
0x0000002e002e7306ULL, 0x000e620000200c00ULL, 0x000054103b387816ULL, 0x004fe20000000038ULL,
0x000000304030723cULL, 0x040fec00000018ffULL, 0x00000022007e7306ULL, 0x0004f00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000000204020723cULL, 0x004f6200000018ffULL,
0x000054102e2d7816ULL, 0x002fcc000000002fULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000054107e397816ULL, 0x008fe20000000039ULL, 0x0000002c402c723cULL, 0x000f6200000018ffULL,
0x00000018ff7e7819ULL, 0x000fca000001143aULL, 0x0000003d003d7306ULL, 0x000fe40000200c00ULL,
0x000000384038723cULL, 0x000fec00000018ffULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003fULL, 0x0000006600667306ULL, 0x000ff00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x004fce000000003eULL,
0x0000003600877306ULL, 0x0002a20000200c00ULL, 0x0000003c403c723cULL, 0x040fee00000018ffULL,
0x0000008500287306ULL, 0x000ee20000200c00ULL, 0x000000344034723cULL, 0x002f6e00000018ffULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541087667816ULL, 0x004fce0000000066ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541028677816ULL, 0x008fce0000000067ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000000664040723cULL, 0x000b6200000018ffULL,
0x0000541082287816ULL, 0x002fcc0000000083ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000088802a667816ULL, 0x020fce00000000ffULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000002900677306ULL, 0x0005f00000200c00ULL,
0x0000007900797306ULL, 0x000ee20000200c00ULL, 0x0000541081297816ULL, 0x004fe20000000084ULL,
0x000001002a817824ULL, 0x000fc400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x000000282420723cULL, 0x000b620000001820ULL, 0x00000018ff2a7819ULL, 0x000fcc000001142aULL,
0x0000541080287816ULL, 0x022fe2000000007dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000054107f297816ULL, 0x000fe4000000007cULL, 0x000088802b7c7816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000000282444723cULL, 0x000b6e0000001844ULL,
0x0000541079287816ULL, 0x028fe2000000007aULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541078297816ULL, 0x004fe2000000007bULL, 0x000001002b787824ULL, 0x000fc400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x00000028242c723cULL, 0x000b62000000182cULL,
0x00000018ff2b7819ULL, 0x000fcc000001142bULL, 0x0000008800857306ULL, 0x000fe20000200c00ULL,
0x000000ffff287224ULL, 0x020fe200078e007cULL, 0x0000541077297816ULL, 0x002fcc0000000072ULL,
0x0000008600867306ULL, 0x000e700000200c00ULL, 0x0000002800797306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541076287816ULL, 0x008fce0000000073ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000000282430723cULL, 0x000b6e0000001830ULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x0000541074287816ULL, 0x024fe40000000075ULL,
0x0000541085297816ULL, 0x002fca0000000086ULL, 0x0000006600667306ULL, 0x000fe40000200c00ULL,
0x000000282434723cULL, 0x000b6c0000001834ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x000054107e287816ULL, 0x028fe40000000071ULL, 0x0000541067297816ULL, 0x000fca0000000070ULL,
0x0000007800787306ULL, 0x000ea40000200c00ULL, 0x000000282438723cULL, 0x000b6c0000001838ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541066287816ULL, 0x022fe40000000081ULL,
0x000000016c667810ULL, 0x000fc80007ffe0ffULL, 0x000000666200720cULL, 0x080fe20005746470ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541079297816ULL, 0x004fe40000000078ULL,
0x000000666100720cULL, 0x000fca0004f26470ULL, 0x0000002a002a7306ULL, 0x000e620000200c00ULL,
0x00000028243c723cULL, 0x000b6e000000183cULL, 0x0000002b002b7306ULL, 0x000ea20000200c00ULL,
0x000054102a287816ULL, 0x022fe4000000006fULL, 0x000054102b297816ULL, 0x004fce000000006eULL,
0x000000282440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000002011117221ULL, 0x000fe40000010000ULL,
0x0000002110107221ULL, 0x000fe40000010000ULL, 0x000000440d0d7221ULL, 0x000fe40000010000ULL,
0x000000450c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x000000341f1f7221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384b4b7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004053537221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000220f0f7221ULL, 0x000fe40000010000ULL, 0x000000230e0e7221ULL, 0x000fe40000010000ULL,
0x000000460b0b7221ULL, 0x000fc40000010000ULL, 0x000000470a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x0000003202027221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x0000003649497221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4d4d7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e51517221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004255557221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b8800ff207f8cULL, 0x000e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe20000011666ULL,
0x000000ffff287224ULL, 0x020fe200078e00ffULL, 0x000000145900720cULL, 0x080fe40003fc3070ULL,
0x0000002366237207ULL, 0x040fe40002800000ULL, 0x0000000366667812ULL, 0x000fe400078ec0ffULL,
0x0000000323257810ULL, 0x000fe40007ffe0ffULL, 0x000000145900720cULL, 0x000fc40003f03070ULL,
0x00000040ff2c7803ULL, 0x000fe40000000000ULL, 0x0000000325237812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2b7224ULL, 0x002fe200078e0021ULL, 0x000000ff66217207ULL, 0x000fe40006800000ULL,
0x0000001425207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8400ff227984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000022ff7812ULL, 0x002fe200078c486dULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011427ULL, 0x0000002922227211ULL, 0x000fca00078d10ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x0000000222227819ULL, 0x000fc80000001227ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x018b8400ff227984ULL, 0x000e640000000800ULL, 0x8000000022ff7812ULL, 0x002fe400078c486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420227824ULL, 0x000fe200078e0223ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x0000005b2400720cULL, 0x000fe20003fc6070ULL,
0x0000004022297824ULL, 0x000fca00078e00ffULL, 0x0000004057227812ULL, 0x000fce00078ef829ULL,
0x000004f00000e947ULL, 0x000fea0003800000ULL, 0x000000051d2d7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000021d2b7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000041d357810ULL, 0x000fe20007ffe0ffULL,
0x018a00002d277984ULL, 0x000e620000004800ULL, 0x000000012d247824ULL, 0x040fe200078e0222ULL,
0x000000f026317812ULL, 0x000fe200078ec0ffULL, 0x000000102d287824ULL, 0x000fe200078e00ffULL,
0x000000295c267217ULL, 0x000fe40007800000ULL, 0x000000052b2e7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a29ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x0000000526267c17ULL, 0x000fc8000f800000ULL, 0x80000005262a7c10ULL, 0x000fe2000fffe0ffULL,
0x000000012e267824ULL, 0x000fe200078e0222ULL, 0x018ac00027277984ULL, 0x002e640000004800ULL,
0x0000002716247224ULL, 0x002fe400078e0224ULL, 0x000000012d277824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc600078e002fULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x0000003124247210ULL, 0x000fe40007fde0ffULL, 0x0001400027297811ULL, 0x000fc600078e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x0000002a1d00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024297faeULL, 0x0003e8000f101c50ULL,
0x018a08002d287984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fe200078e00ffULL,
0x00000005352e7c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff025307812ULL, 0x000fe200078ee230ULL,
0x000000012e247824ULL, 0x000fc600078e0222ULL, 0x0001400030337811ULL, 0x000fe200078e20ffULL,
0x018ac00028277984ULL, 0x004e640000004800ULL, 0x0000002716267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002fULL, 0x0000003126267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x0000002a2b00720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026337faeULL, 0x0003e8000f101c50ULL,
0x018a10002d2b7984ULL, 0x000ea80000004800ULL, 0x018ac0002b2b7984ULL, 0x004ea40000004800ULL,
0x0000002b16247224ULL, 0x004fe200078e0224ULL, 0x000000061d2b7810ULL, 0x000fc60007ffe0ffULL,
0x00005e0024247625ULL, 0x000fca00078e002fULL, 0x0000003124287210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe200030e0625ULL,
0x0000002a3500720cULL, 0x000fe20003fc6070ULL, 0x000000102e257824ULL, 0x000fe200078e00ffULL,
0x000000052b2e7c10ULL, 0x000fc8000fffe0ffULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x000000012e227824ULL, 0x000fc600078e0222ULL, 0x0001400024277811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e8000f101c50ULL,
0x018a18002d267984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fc600078e00ffULL,
0x018ac00026257984ULL, 0x004e640000004800ULL, 0x0000002516257224ULL, 0x002fe400078e0222ULL,
0x000000012e227824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc600078e002fULL,
0xfffffff027227812ULL, 0x000fe400078ee222ULL, 0x0000003124247210ULL, 0x000fe40007fde0ffULL,
0x0001400022277811ULL, 0x000fc600078e20ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x0000002a2b00720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000f101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x000000051d2b7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000022b2e7810ULL, 0x040fe20007ffe0ffULL,
0x018a00002b287984ULL, 0x000e620000004800ULL, 0x000000012b247824ULL, 0x000fe400078e0222ULL,
0x000000f0262f7812ULL, 0x000fe200078ec0ffULL, 0x018ac00028257984ULL, 0x002e640000004800ULL,
0x0000002516257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002dULL,
0x0000002f24267210ULL, 0x000fe20007fde0ffULL, 0x000000012b247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102b257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0001400024317811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x000fc800078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026317faeULL, 0x0003e8000b901c50ULL, 0x018a08002b2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x004ea40000004800ULL, 0x0000002516247224ULL, 0x004fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24287210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff297224ULL, 0x000fe400030e0625ULL,
0x000000102e257824ULL, 0x000fe200078e00ffULL, 0x000000042b2e7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0001400024317811ULL, 0x002fe200078e20ffULL,
0x000000012e247824ULL, 0x000fc800078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028317faeULL, 0x0003e8000b901c50ULL, 0x018a10002b2a7984ULL, 0x000ea80000004800ULL,
0x018ac0002a257984ULL, 0x0044e40000004800ULL, 0x000000062b2a7810ULL, 0x004fca0007ffe0ffULL,
0x000000012a227824ULL, 0x000fe400078e0222ULL, 0x0000002516247224ULL, 0x008fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe20007fde0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102e257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0001400024297811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026297faeULL, 0x0003e8000b901c50ULL, 0x018a18002b287984ULL, 0x000ea80000004800ULL,
0x018ac00028257984ULL, 0x004ea40000004800ULL, 0x0000002516257224ULL, 0x004fc400078e0222ULL,
0x000000012a227824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc800078e002dULL,
0x000000102a2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f24247210ULL, 0x000fc80007fde0ffULL,
0xfffffff02d227812ULL, 0x000fe200078ee222ULL, 0x000000ffff257224ULL, 0x000fc600030e0625ULL,
0x0001400022277811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x018b8c00ff227984ULL, 0x000e620000000800ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000022ff7812ULL, 0x002fe200078c482bULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002900780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011427ULL,
0x0000002922227211ULL, 0x000fca00078d10ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x0000000222227819ULL, 0x000fc80000001227ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x018b8c00ff227984ULL, 0x000e640000000800ULL,
0x8000000022ff7812ULL, 0x002fe400078c482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000205900720cULL, 0x000fe40003fc4070ULL, 0x00018a0017257811ULL, 0x000fe400078e10ffULL,
0x000000ff21227207ULL, 0x000fc40003000000ULL, 0x000000ff21247207ULL, 0x000fc60007000000ULL,
0x0000000123237824ULL, 0x000fc800078e0222ULL, 0x0000004023217824ULL, 0x040fe200078e00ffULL,
0x0000002023207211ULL, 0x000fc800078ff0ffULL, 0x000000c021217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a24217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000117237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x0000005c2300720cULL, 0x000fe20003fc6070ULL, 0x0000000117207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000f121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x018b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7800ff667f8cULL, 0x000e62000c80043fULL, 0x0000016000017945ULL, 0x000fe20003800000ULL,
0x0000014000003947ULL, 0x000fea0003800000ULL, 0x00000019ff1a723eULL, 0x000fc800000000ffULL,
0x000054101a227816ULL, 0x000fe2000000001aULL, 0x0000ad327f007947ULL, 0x000fea000b800000ULL,
0x00001f62221a7589ULL, 0x0004e400000e0000ULL, 0x0000ad927f007947ULL, 0x000fea000b800000ULL,
0x00001f61221b7589ULL, 0x0004e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001062277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001674000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000b41000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x0000001862277810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff287424ULL, 0x000fe200078e00ffULL,
0x000167b000207802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000b3a000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006524783bULL, 0x006e620000004200ULL,
0x000000ff2c00720cULL, 0x000fe20003fc5270ULL, 0x00000f4000017945ULL, 0x000fe20003800000ULL,
0x0001380069407811ULL, 0x000fe200078e20ffULL, 0x000000006428783bULL, 0x000ea80000004200ULL,
0x000000006320783bULL, 0x000fe80000004200ULL, 0x000000006834783bULL, 0x000fe80000004200ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x00000100242e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe20000011424ULL, 0x0000010027337824ULL, 0x000fe200078e00ffULL,
0x0000888024447816ULL, 0x000fe200000000ffULL, 0x0000010028327824ULL, 0x004fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe20000011428ULL, 0x00000100252f7824ULL, 0x000fe200078e00ffULL,
0x0000002e003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fc40000011429ULL,
0x0000888028847816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x0000888029827816ULL, 0x040fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe20000011426ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x00000100292e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011428ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000888026287816ULL, 0x040fe200000000ffULL, 0x0000001a4040b232ULL, 0x098fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe2000001142eULL, 0x0000001a4242b232ULL, 0x000fe20000000000ULL,
0x00000018ff7e7819ULL, 0x000fe20000011429ULL, 0x0000010026297824ULL, 0x040fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000018ff2e7819ULL, 0x000fe20000011424ULL, 0x0001000025247824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000001b4141b232ULL, 0x080fe20000000000ULL,
0x00000018ff317819ULL, 0x000fe20000011427ULL, 0x0000001b4343b232ULL, 0x000fe20000000000ULL,
0x00000018ff2d7819ULL, 0x000fe20000011425ULL, 0x0000003200837306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff6f7819ULL, 0x000fe40000011420ULL,
0x0000888020737816ULL, 0x000fe400000000ffULL, 0x0000888025457816ULL, 0x000fe200000000ffULL,
0x00000033003d7306ULL, 0x000fe20000200c00ULL, 0x0000888027327816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fe4000001142fULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002600337306ULL, 0x0005e20000200c00ULL, 0x0000888035877816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011435ULL,
0x00000018ff867819ULL, 0x000fe20000011436ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x0000010020267824ULL, 0x044fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe20000011437ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00008880363c7816ULL, 0x000fc400000000ffULL,
0x00000018ff767819ULL, 0x000fe20000011426ULL, 0x0000010034267824ULL, 0x040fe200078e00ffULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011420ULL,
0x0000888034207816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000541044447816ULL, 0x002fe2000000003fULL,
0x0000002e00257306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff6e7819ULL, 0x000fe40000011421ULL, 0x0000888021747816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe2000001142aULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe4000001142bULL, 0x000088802a797816ULL, 0x000fe400000000ffULL,
0x000088802b777816ULL, 0x000fc400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011422ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00000018ff667819ULL, 0x000fce0000011423ULL,
0x0000002f003e7306ULL, 0x000e700000200c00ULL, 0x00000027003a7306ULL, 0x0005f00000200c00ULL,
0x00000029002f7306ULL, 0x0007e20000200c00ULL, 0x0000010035277824ULL, 0x004fe200078e00ffULL,
0x0000541045457816ULL, 0x002fe2000000003eULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00008880373e7816ULL, 0x000fc400000000ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000028002e7306ULL, 0x0002a20000200c00ULL, 0x000001002b297824ULL, 0x048fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x000000444044723cULL, 0x000f6400000018ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x000001002a287824ULL, 0x042fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000026007f7306ULL, 0x0002e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fce000001142aULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x0000010036267824ULL, 0x042fe400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011426ULL, 0x00000027008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011436ULL, 0x00000029007c7306ULL, 0x0003f00000200c00ULL,
0x00000028007a7306ULL, 0x0009e20000200c00ULL, 0x0000541024297816ULL, 0x002fe4000000002dULL,
0x00005410322d7816ULL, 0x000fe2000000003dULL, 0x0000010037327824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x0000541025287816ULL, 0x010fe4000000002cULL, 0x000138006a257811ULL, 0x000fe400078e20ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011432ULL, 0x000054102e2c7816ULL, 0x004fe2000000002fULL,
0x00000034003b7306ULL, 0x0007e20000200c00ULL, 0x000000002524783bULL, 0x000eaa0000000200ULL,
0x0000002c402c723cULL, 0x000fe400000018ffULL, 0x0000003500887306ULL, 0x0009e20000200c00ULL,
0x0000541020347816ULL, 0x008fc4000000007fULL, 0x00000018ff207819ULL, 0x000fe40000011437ULL,
0x000054103a317816ULL, 0x002fe20000000031ULL, 0x00000100213a7824ULL, 0x000fe400078e00ffULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000541087357816ULL, 0x010fe2000000008aULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fc8000001143aULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000003800387306ULL, 0x000ef00000200c00ULL,
0x0000003900397306ULL, 0x000f220000200c00ULL, 0x0000541033307816ULL, 0x002fce0000000030ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054103b387816ULL, 0x008fe20000000038ULL,
0x000000304030723cULL, 0x000fe200000018ffULL, 0x0000001a2424b232ULL, 0x084fe40000000000ULL,
0x0000001a2626b232ULL, 0x000fe40000000000ULL, 0x0000001b2525b232ULL, 0x080fe20000000000ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x0000541088397816ULL, 0x010fe20000000039ULL,
0x0000001b2727b232ULL, 0x000fe20000000000ULL, 0x0000888022887816ULL, 0x000fca00000000ffULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000000384038723cULL, 0x000fee00000018ffULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003fULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054103e3d7816ULL, 0x004fce000000003dULL, 0x0000003600897306ULL, 0x0002a20000200c00ULL,
0x0000003c403c723cULL, 0x040fee00000018ffULL, 0x00000020008a7306ULL, 0x0004e20000200c00ULL,
0x000000344034723cULL, 0x002fee00000018ffULL, 0x00000021007f7306ULL, 0x0007e20000200c00ULL,
0x0000541089207816ULL, 0x004fe20000000086ULL, 0x0001000022867824ULL, 0x000fcc00078e00ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x000054108a217816ULL, 0x008fe20000000081ULL,
0x000000ffff817224ULL, 0x000fcc00078e0088ULL, 0x0000008200827306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000002a00757306ULL, 0x000ff00000200c00ULL,
0x0000002b00787306ULL, 0x0005f00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000000284028723cULL, 0x044f6e00000018ffULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000204040723cULL, 0x000b6e00000018ffULL, 0x0000010022207824ULL, 0x020fe200078e00ffULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x0000541082217816ULL, 0x002fc40000000085ULL,
0x00000018ff827819ULL, 0x000fe40000011486ULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000002000227306ULL, 0x0007f00000200c00ULL,
0x0000007900797306ULL, 0x000f220000200c00ULL, 0x0000541084207816ULL, 0x008fc40000000083ULL,
0x0000888023837816ULL, 0x000fca00000000ffULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000000202444723cULL, 0x000b6e0000001844ULL, 0x0000541080207816ULL, 0x024fe2000000007dULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107e217816ULL, 0x002fe2000000007bULL,
0x00000100237b7824ULL, 0x000fc400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000000202428723cULL, 0x000b620000001828ULL, 0x00000018ff237819ULL, 0x000fcc0000011423ULL,
0x000000ffff217224ULL, 0x020fe200078e0083ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541079207816ULL, 0x010fce000000007aULL, 0x00000021007d7306ULL, 0x0007f00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541077217816ULL, 0x008fce000000007cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000020242c723cULL, 0x000b6e000000182cULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x0000541075207816ULL, 0x024fe40000000072ULL,
0x0000541078217816ULL, 0x002fca0000000071ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x000000202430723cULL, 0x000b6c0000001830ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541073207816ULL, 0x030fe40000000076ULL, 0x0000541074217816ULL, 0x008fca0000000087ULL,
0x0000007000707306ULL, 0x000ea40000200c00ULL, 0x000000202434723cULL, 0x000b6c0000001834ULL,
0x0000008100817306ULL, 0x000ee20000200c00ULL, 0x000054107f217816ULL, 0x022fce000000006eULL,
0x0000007b007a7306ULL, 0x000e620000200c00ULL, 0x0000541070207816ULL, 0x004fce000000006fULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000202438723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541081207816ULL, 0x028fe40000000022ULL,
0x000054107d217816ULL, 0x002fca000000007aULL, 0x0000008200827306ULL, 0x000e640000200c00ULL,
0x00000020243c723cULL, 0x000b6c000000183cULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541082207816ULL, 0x022fe4000000006dULL, 0x0000541023217816ULL, 0x004fce0000000066ULL,
0x000000202440723cULL, 0x000b620000001840ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004411117221ULL, 0x000fe40000010000ULL,
0x0000004510107221ULL, 0x000fe40000010000ULL, 0x000000280d0d7221ULL, 0x000fe40000010000ULL,
0x000000290c0c7221ULL, 0x000fe40000010000ULL, 0x0000002c09097221ULL, 0x000fe40000010000ULL,
0x0000002d08087221ULL, 0x000fc40000010000ULL, 0x0000003005057221ULL, 0x000fe40000010000ULL,
0x0000003104047221ULL, 0x000fe40000010000ULL, 0x000000341f1f7221ULL, 0x000fe40000010000ULL,
0x000000354a4a7221ULL, 0x000fe40000010000ULL, 0x000000384b4b7221ULL, 0x000fe40000010000ULL,
0x000000394e4e7221ULL, 0x000fc40000010000ULL, 0x0000003c4f4f7221ULL, 0x000fe40000010000ULL,
0x0000003d52527221ULL, 0x000fe40000010000ULL, 0x0000004053537221ULL, 0x020fe40000010000ULL,
0x0000004156567221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x000000460f0f7221ULL, 0x000fe40000010000ULL, 0x000000470e0e7221ULL, 0x000fe40000010000ULL,
0x0000002a0b0b7221ULL, 0x000fc40000010000ULL, 0x0000002b0a0a7221ULL, 0x000fe40000010000ULL,
0x0000002e07077221ULL, 0x000fe40000010000ULL, 0x0000002f06067221ULL, 0x000fe40000010000ULL,
0x0000003202027221ULL, 0x000fe40000010000ULL, 0x0000003348487221ULL, 0x000fe40000010000ULL,
0x0000003649497221ULL, 0x000fc40000010000ULL, 0x000000374c4c7221ULL, 0x000fe40000010000ULL,
0x0000003a4d4d7221ULL, 0x000fe40000010000ULL, 0x0000003b50507221ULL, 0x000fe40000010000ULL,
0x0000003e51517221ULL, 0x000fe40000010000ULL, 0x0000003f54547221ULL, 0x000fe40000010000ULL,
0x0000004255557221ULL, 0x020fc40000010000ULL, 0x0000004358587221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006b6c00720cULL, 0x000fe20003f06070ULL,
0x018b8800ff247f8cULL, 0x020e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffaa5000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x018b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000114147810ULL, 0x000fc80007ffe0ffULL,
0x0000005b1400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffea2c000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5b00720cULL, 0x000fe20003f05270ULL, 0x000000ffff157224ULL, 0x000fe400078e0002ULL,
0x000000ffff147224ULL, 0x000fe400078e0006ULL, 0x000000ffff137224ULL, 0x000fd000078e0007ULL,
0x0000039000008947ULL, 0x000fea0003800000ULL, 0x0180000012007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00017a8000067802ULL, 0x000fc40000000f00ULL, 0x00009f1000007944ULL, 0x002fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001200037308ULL, 0x000ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc80000000012ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006f00ff037624ULL, 0x000fe400078e00ffULL, 0x00006e00ff027624ULL, 0x000fca00078e00ffULL,
0x0000001002037981ULL, 0x000f28000c1e9900ULL, 0x0000000000067919ULL, 0x000ee40000000000ULL,
0x00000002ff277819ULL, 0x008fe20000011606ULL, 0x0000000003067220ULL, 0x014fe20000410000ULL,
0x000099827f007947ULL, 0x000fea000b800000ULL, 0x00001f2706007589ULL, 0x0004e400000e0000ULL,
0x0000000000027919ULL, 0x000f220000000000ULL, 0x0000001100117220ULL, 0x048fe40000410000ULL,
0x0000001000107220ULL, 0x000fc40000410000ULL, 0x0000000d000d7220ULL, 0x040fe40000410000ULL,
0x0000000c000c7220ULL, 0x040fe40000410000ULL, 0x0000000900097220ULL, 0x040fe40000410000ULL,
0x0000000800087220ULL, 0x040fe40000410000ULL, 0x0000000500057220ULL, 0x040fe40000410000ULL,
0x0000000400047220ULL, 0x000fc40000410000ULL, 0x0000001f001f7220ULL, 0x040fe40000410000ULL,
0x0000004a004a7220ULL, 0x040fe40000410000ULL, 0x0000004b004b7220ULL, 0x040fe40000410000ULL,
0x0000004e004e7220ULL, 0x000fe20000410000ULL, 0x0000000802277811ULL, 0x016fe200078ff0ffULL,
0x0000004f004f7220ULL, 0x040fe40000410000ULL, 0x0000005200527220ULL, 0x000fc40000410000ULL,
0x0000005300537220ULL, 0x040fe40000410000ULL, 0x0000005600567220ULL, 0x000fe20000410000ULL,
0x000098b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2706007589ULL, 0x0002a400000e0000ULL,
0x0000000f000f7220ULL, 0x044fe40000410000ULL, 0x0000000e000e7220ULL, 0x040fe40000410000ULL,
0x0000000b000b7220ULL, 0x040fe40000410000ULL, 0x0000000a000a7220ULL, 0x040fe40000410000ULL,
0x0000001300137220ULL, 0x000fc40000410000ULL, 0x0000001400147220ULL, 0x040fe40000410000ULL,
0x0000001500157220ULL, 0x040fe40000410000ULL, 0x0000004800487220ULL, 0x040fe40000410000ULL,
0x0000004900497220ULL, 0x040fe40000410000ULL, 0x0000004c004c7220ULL, 0x040fe40000410000ULL,
0x0000004d004d7220ULL, 0x000fc40000410000ULL, 0x0000005000507220ULL, 0x040fe40000410000ULL,
0x0000005100517220ULL, 0x040fe40000410000ULL, 0x0000005400547220ULL, 0x040fe40000410000ULL,
0x0000005500557220ULL, 0x040fe40000410000ULL, 0x0000005800587220ULL, 0x000fc40000410000ULL,
0x0000000000177919ULL, 0x000ea20000002600ULL, 0x000000090803723eULL, 0x000fe200000000ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000111000723eULL, 0x000fc400000000ffULL,
0x0000000d0c02723eULL, 0x000fe400000000ffULL, 0x000000050404723eULL, 0x000fe400000000ffULL,
0x0000000f0e09723eULL, 0x000fe400000000ffULL, 0x0000000b0a0a723eULL, 0x000fe400000000ffULL,
0x0000001f4a05723eULL, 0x000fe400000000ffULL, 0x0000004b4e06723eULL, 0x002fc400000000ffULL,
0x0000004f5207723eULL, 0x000fe400000000ffULL, 0x000000535608723eULL, 0x000fe400000000ffULL,
0x00000013140b723eULL, 0x000fe400000000ffULL, 0x00000015480c723eULL, 0x000fe400000000ffULL,
0x000000494c0d723eULL, 0x000fe400000000ffULL, 0x0000004d500e723eULL, 0x000fc400000000ffULL,
0x00000051540f723eULL, 0x000fe400000000ffULL, 0x000000555810723eULL, 0x000fc400000000ffULL,
0x0000000000147919ULL, 0x004e620000000000ULL, 0x0001200008087891ULL, 0x000fc6000f8e583fULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000814127811ULL, 0x042fe400078ff0ffULL,
0x0000000214117812ULL, 0x000fc600078ec0ffULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0x0000001211137211ULL, 0x040fe200078ff8ffULL, 0x0000000814127824ULL, 0x000fe200078e00ffULL,
0x00000002ff147819ULL, 0x000fe40000011614ULL, 0xfffffff816167812ULL, 0x000fe400078ee213ULL,
0x0000000812137812ULL, 0x000fe200078ec0ffULL, 0x0000000814127824ULL, 0x040fe200078e00ffULL,
0x0000001411117211ULL, 0x000fe200078ff8ffULL, 0x0000000814197824ULL, 0x000fe200078e00ffULL,
0x0000000816167c11ULL, 0x000fe2000f8e20ffULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0x0000000211147810ULL, 0x000fe20007ffe0ffULL, 0x0000000113167824ULL, 0x000fe200078e0216ULL,
0x0000000411157810ULL, 0x000fc40007ffe0ffULL, 0x0000000611117810ULL, 0x000fe40007ffe0ffULL,
0x0000000812127c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff819147812ULL, 0x000fe400078ee214ULL,
0xfffffff818157812ULL, 0x000fe200078ee215ULL, 0x0000000112127824ULL, 0x000fe200078e0213ULL,
0xfffffff81a117812ULL, 0x000fe400078ee211ULL, 0x0000541000187816ULL, 0x000fc40000000002ULL,
0x0000763200197816ULL, 0x000fe40000000002ULL, 0x0000000814147c11ULL, 0x000fe4000f8e20ffULL,
0x0000000815007c11ULL, 0x000fe2000f8e20ffULL, 0x0000001812007388ULL, 0x0003e20000000a00ULL,
0x0000000811027c11ULL, 0x000fe2000f8e20ffULL, 0x0000000113147824ULL, 0x040fe400078e0214ULL,
0x0000000113007824ULL, 0x040fe400078e0200ULL, 0x0000000113027824ULL, 0x000fe200078e0202ULL,
0x0000763203137816ULL, 0x000fc40000000004ULL, 0x0000541003127816ULL, 0x002fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x0000001214007388ULL, 0x0003e20000000a00ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000400007388ULL, 0x0003e20000000a00ULL,
0x0000541009087816ULL, 0x000fc4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x0000000602007388ULL, 0x0003e20000000a00ULL, 0x000054100b0a7816ULL, 0x140fe4000000000cULL,
0x000076320b0b7816ULL, 0x000fe2000000000cULL, 0x0000000816007388ULL, 0x0003e20000000a00ULL,
0x000054100d0c7816ULL, 0x140fe4000000000eULL, 0x000076320d0d7816ULL, 0x000fe2000000000eULL,
0x0004000a14007388ULL, 0x0003e20000000a00ULL, 0x000054100f0e7816ULL, 0x000fc40000000010ULL,
0x000076320f0f7816ULL, 0x000fe20000000010ULL, 0x0004000c00007388ULL, 0x0003e80000000a00ULL,
0x0004000e02007388ULL, 0x0003e20000000a00ULL, 0x0000003000007947ULL, 0x000fea0003800000ULL,
0xffffffffff1d7424ULL, 0x000fe200078e00ffULL, 0x00018290001c7802ULL, 0x000fc40000000f00ULL,
0x0000997000007944ULL, 0x002fea0003c00000ULL, 0x0000000000097919ULL, 0x002e620000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000004130472a4ULL, 0x000fcc000f8e023fULL,
0x00000004ff037e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff007819ULL, 0x002fca0000011609ULL,
0x0000000100027824ULL, 0x040fe400078e0209ULL, 0x0000580000007a24ULL, 0x000fc600078e0217ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000003007211ULL, 0x000fe400078010ffULL,
0x0ffffff802047812ULL, 0x000fe400078ef809ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe400078048ffULL,
0x0000000804047984ULL, 0x000e62000800cc00ULL, 0x1ffffff809097812ULL, 0x000fc400078ef808ULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d10ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000608057899ULL, 0x000fe2000800063fULL, 0x000000200d007810ULL, 0x000fca0007ffe0ffULL,
0x000000050d037c10ULL, 0x000fe2000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000680000047ab9ULL, 0x000fe20000000800ULL, 0x0000000500057c10ULL, 0x040fe2000fffe0ffULL,
0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL, 0x0000005c0300720cULL, 0x080fe20003f06070ULL,
0x0000000808067899ULL, 0x000fe2000800063fULL, 0x0000005c0500720cULL, 0x000fe20003f26070ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x018ad000ff087f8cULL, 0x000e62000c80043fULL,
0x000000040d027c10ULL, 0x040fe2000fffe0ffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000000400047c10ULL, 0x000fe2000fffe0ffULL, 0x000000013f047899ULL, 0x000fe20008011608ULL,
0x000000060d0b7c11ULL, 0x040fe2000f8e10ffULL, 0x0000660002027625ULL, 0x000fe200078e000fULL,
0x000000030d00780cULL, 0x000fc60003f44070ULL, 0x0000660004047625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x18600000020b7faeULL, 0x0005e6000c121850ULL,
0x00000004ff537e24ULL, 0x000fe2000f8e00ffULL, 0x18680000040b7faeULL, 0x0005e2000c921850ULL,
0x00006e00ff067624ULL, 0x000fe400078e00ffULL, 0x00006f00ff077624ULL, 0x000fe400078e00ffULL,
0x000000a000002947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ee20000002700ULL,
0x00000008ff027e24ULL, 0x004fe2000f8e00ffULL, 0x0000005a5300720cULL, 0x000fc60003f06070ULL,
0x0000000402057824ULL, 0x000fca00078e020dULL, 0x00018a8005057811ULL, 0x000fe200078e10ffULL,
0x0000000400007824ULL, 0x008fc800078e020dULL, 0x0000000200007824ULL, 0x000fc800078e00ffULL,
0x0000640000007a24ULL, 0x000fc800078e0253ULL, 0x0000600000027625ULL, 0x000fca00078e000fULL,
0x0000000002057faeULL, 0x0005e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000070d0d7899ULL, 0x000fe2000800063fULL,
0x0000001006007981ULL, 0x000728000c1e9900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x000000400d077892ULL, 0x000fe4000f8ef805ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000ffff037224ULL, 0x006fe200078e0009ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000119000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x008e620000000000ULL,
0x00018a8008097891ULL, 0x000fe2000f8e203fULL, 0x000000055c087c17ULL, 0x000fe2000f800000ULL,
0x00000100ff047424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe4000f8e703fULL,
0x8000000508087c10ULL, 0x000fe4000fffe0ffULL, 0x00000003ff057819ULL, 0x002fe20000011602ULL,
0x0000001002097824ULL, 0x000fc600078e00ffULL, 0x0000000705067c10ULL, 0x040fe2000fffe0ffULL,
0x0186000605077984ULL, 0x000e620008004800ULL, 0x00000001050c7824ULL, 0x040fe200078e0202ULL,
0x000000080500720cULL, 0x000fe40003f06070ULL, 0x0000000907077984ULL, 0x002e640008004800ULL,
0x00000004070b7c24ULL, 0x002fe2000f8e0206ULL, 0x0000007009067812ULL, 0x000fe400078ec0ffULL,
0x000000070c077812ULL, 0x000fe200078ec0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0004ULL,
0x0000000405097810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff807077812ULL, 0x100fe400078ef802ULL,
0x0000000a060c7210ULL, 0x000fe20007f3e0ffULL, 0x00000001090f7824ULL, 0x000fe200078e0202ULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000809127824ULL, 0x040fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000000805097810ULL, 0x000fe20007ffe0ffULL,
0x0186100605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000000c05097810ULL, 0x000fe20007ffe0ffULL, 0x0186200605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000001005097810ULL, 0x000fe20007ffe0ffULL,
0x0186300605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000001405097810ULL, 0x000fe20007ffe0ffULL, 0x0186400605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000001805097810ULL, 0x000fe20007ffe0ffULL,
0x0186500605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000001c05097810ULL, 0x000fe20007ffe0ffULL, 0x0186600605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000002005097810ULL, 0x000fe20007ffe0ffULL,
0x0186700605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000002405097810ULL, 0x000fe20007ffe0ffULL, 0x0186800605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000002805097810ULL, 0x000fe20007ffe0ffULL,
0x0186900605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000002c05097810ULL, 0x000fe20007ffe0ffULL, 0x0186a00605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000003005097810ULL, 0x000fe20007ffe0ffULL,
0x0186b00605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x040fe400078e0202ULL, 0x0000000809127824ULL, 0x000fe200078e00ffULL,
0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL, 0x0000000910107984ULL, 0x004e640008004800ULL,
0x00000004100b7c24ULL, 0x002fc8000f8e020bULL, 0x00005e000b0a7625ULL, 0x000fca00078e0004ULL,
0x0000000a060e7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fe40003f06070ULL,
0x0000003405097810ULL, 0x000fe20007ffe0ffULL, 0x0186c00605107984ULL, 0x000ea20008004800ULL,
0xfffffff812077812ULL, 0x002fc600078ee20dULL, 0x00000001090f7824ULL, 0x040fe400078e0202ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060bULL, 0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000c101c50ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0x0000003805097810ULL, 0x000fe20007ffe0ffULL,
0x0186d00605107984ULL, 0x000ea20008004800ULL, 0xfffffff812077812ULL, 0x002fc600078ee20fULL,
0x00000001090d7824ULL, 0x000fe200078e0202ULL, 0x0000000b07077c11ULL, 0x000fe2000f8e20ffULL,
0x0000000910107984ULL, 0x004e640008004800ULL, 0x00000004100b7c24ULL, 0x002fe4000f8e020bULL,
0x0000000809107824ULL, 0x000fe400078e00ffULL, 0x00005e000b0a7625ULL, 0x000fc600078e0004ULL,
0xfffffff8100d7812ULL, 0x000fe400078ee20dULL, 0x0000000a060e7210ULL, 0x000fe40007f3e0ffULL,
0x0000000b0d0d7c11ULL, 0x000fc6000f8e20ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060bULL,
0x00000007090b7c10ULL, 0x000fc8000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e077faeULL, 0x0003e2000c101c50ULL, 0x000000080900720cULL, 0x000fc60003f06070ULL,
0x0186e006050c7984ULL, 0x000ea20008004800ULL, 0x0000003c05077810ULL, 0x002fc80007ffe0ffULL,
0x0000000707097c10ULL, 0x040fe2000fffe0ffULL, 0x0000000107027824ULL, 0x000fe200078e0202ULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c0b7c24ULL, 0x002fc8000f8e020bULL,
0x00005e000b0a7625ULL, 0x000fca00078e0004ULL, 0x0000000a060a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e060bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c101c50ULL, 0x000000080700720cULL, 0x040fe20003f06070ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0186f006050c7984ULL, 0x0004e60008004800ULL,
0xfffffff807027812ULL, 0x000fc800078ee202ULL, 0x0000000b02057c11ULL, 0x004fe2000f8e20ffULL,
0x000000090c0c7984ULL, 0x008ea40008004800ULL, 0x000000040c097c24ULL, 0x004fc8000f8e0209ULL,
0x00005e0009087625ULL, 0x000fca00078e0004ULL, 0x0000000806067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000c101c50ULL, 0x0000106000007947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x008e620000000000ULL, 0x00018a8008097891ULL, 0x000fe2000f8e203fULL,
0x00000100ff047424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe2000f8e703fULL,
0x00000003ff057819ULL, 0x002fc80000011602ULL, 0x0000000705067c10ULL, 0x040fe2000fffe0ffULL,
0x0186000605077984ULL, 0x000e620008004800ULL, 0x00000001050a7824ULL, 0x040fe200078e0202ULL,
0x00000004050d7810ULL, 0x000fc80007ffe0ffULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x002e640008004800ULL,
0x0000000407097c24ULL, 0x002fe2000f8e0206ULL, 0x0ffffff80b077812ULL, 0x000fe200078ef802ULL,
0x0000001002067824ULL, 0x000fe400078e00ffULL, 0x00005e0009087625ULL, 0x000fe200078e0004ULL,
0x0000000b070f7c11ULL, 0x000fe4000f8e20ffULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186100605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000008050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186200605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000000c050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186300605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000010050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186400605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000014050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186500605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000018050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186600605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000001c050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186700605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000020050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186800605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000024050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186900605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000028050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186a00605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x0000002c050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186b00605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000030050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186c00605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000034050d7810ULL, 0x000fca0007ffe0ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080a7210ULL, 0x000fe40007f1e0ffULL, 0x000000070d087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fc600000e0609ULL,
0xfffffff80d0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e8000b901c50ULL, 0x0186d00605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0f7c11ULL, 0x002fe4000f8e20ffULL, 0x00000038050b7810ULL, 0x000fca0007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0202ULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fc8000f8e0208ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x00000006080c7210ULL, 0x000fe40007f1e0ffULL, 0x000000070b087c10ULL, 0x040fe2000fffe0ffULL,
0x000000080b0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fc600000e0609ULL,
0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e8000b901c50ULL, 0x0186e00605077984ULL, 0x000ea20008004800ULL,
0x0000000b0e0d7c11ULL, 0x002fc6000f8e20ffULL, 0x0000000907077984ULL, 0x004e640008004800ULL,
0x0000000407097c24ULL, 0x002fe2000f8e0208ULL, 0x0000003c05077810ULL, 0x000fc60007ffe0ffULL,
0x00005e0009087625ULL, 0x000fc800078e0004ULL, 0x0000000107027824ULL, 0x000fe200078e0202ULL,
0x00000006080a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0609ULL,
0x0000000707097c10ULL, 0x040fe2000fffe0ffULL, 0x0000000807077824ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0d7faeULL, 0x0003e4000b901c50ULL,
0xfffffff807027812ULL, 0x000fe400078ee202ULL, 0x0186f006050c7984ULL, 0x0004e40008004800ULL,
0x0000000b02057c11ULL, 0x004fe4000f8e20ffULL, 0x000000090c0c7984ULL, 0x008ea40008004800ULL,
0x000000040c097c24ULL, 0x004fc8000f8e0209ULL, 0x00005e0009087625ULL, 0x000fca00078e0004ULL,
0x0000000608067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fca00000e0609ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e6000b901c50ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x018ad400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000902027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x018ad400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x00000008ff037e24ULL, 0x000fc8000f8e00ffULL, 0x0000002003027824ULL, 0x002fca00078e0202ULL,
0x00000003ff047819ULL, 0x000fe40000011602ULL, 0x0000000f02027812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000102047810ULL, 0x040fe20007ffe0ffULL,
0x0000002002087824ULL, 0x040fe400078e00ffULL, 0x0000000102067824ULL, 0x040fe400078e0205ULL,
0x0000000105077824ULL, 0x040fe200078e0204ULL, 0x0000001005057810ULL, 0x000fe20007ffe0ffULL,
0x0000002002097824ULL, 0x000fe200078e00ffULL, 0x0000001f06067812ULL, 0x000fe200078ec0ffULL,
0x0000002002117824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x100fe200078e0205ULL, 0x000001e009067812ULL, 0x000fe200078ee206ULL,
0x0000000102107824ULL, 0x000fe200078e0205ULL, 0x000001e008077812ULL, 0x000fe200078ee207ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x0000001f04047812ULL, 0x000fe200078ec0ffULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000001f10107812ULL, 0x000fc400078ec0ffULL,
0x000001e011047812ULL, 0x000fe200078ee204ULL, 0x0000000007087984ULL, 0x000ea2000000cc00ULL,
0x000001e005107812ULL, 0x000fe200078ee210ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fe400078e000eULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff1a7224ULL, 0x000fc400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fe200078e000bULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fca00078e000fULL,
0x0000001807007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000aULL,
0x000000ffff1e7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1c7224ULL, 0x004fe400078e000cULL, 0x000000ffff1d7224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000001c10007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x018ad000ff047f8cULL, 0x002e62000c80043fULL,
0x000000ffff087224ULL, 0x000fc400078e00ffULL, 0x000000ffff0b7224ULL, 0x002fc400078e0005ULL,
0x0000000000047805ULL, 0x000fca0000015200ULL, 0x018ad400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011407ULL,
0x0000000902027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x018ad400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff5b00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x00018b5803527811ULL, 0x000fe200078e18ffULL, 0x3d80000000007820ULL, 0x010fe20000410000ULL,
0xffffffff5b047810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00018ad803057811ULL, 0x000fe200078e28ffULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x0000008007077824ULL, 0x000fc400078e00ffULL, 0x0000000506577c11ULL, 0x000fe2000f8e40ffULL,
0x0000000000007946ULL, 0x000fe60003800000ULL, 0x000000575c00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000004ff5d7424ULL, 0x000fe200078e00ffULL,
0x000000065900720cULL, 0x000fe20003f44070ULL, 0x000000ffff587224ULL, 0x000fc600078e00ffULL,
0x000000015d5d7807ULL, 0x000fc40005000000ULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0058ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000ffff5f7224ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0xffffffffff1d7424ULL, 0x000fe200078e00ffULL, 0x0001b3d0001c7802ULL, 0x000fc40000000f00ULL,
0x0000683000007944ULL, 0x002fea0003c00000ULL, 0x000000015f617810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000005861157211ULL, 0x040fe200078ff8ffULL,
0x000020c000007945ULL, 0x000fe20003800000ULL, 0x0000000161607812ULL, 0x000fe400078ec0ffULL,
0x0000000315177812ULL, 0x000fe400078ec0ffULL, 0x00000002ff15a819ULL, 0x000fca0000011615ULL,
0x0000000115167824ULL, 0x000fe200078e0206ULL, 0x000000ff17157207ULL, 0x000fc80005000000ULL,
0x0000000116087810ULL, 0x040fe40007ffe0ffULL, 0x0000000516217c11ULL, 0x000fe4000f8e40ffULL,
0x0000005b0800720cULL, 0x000fe40003f06070ULL, 0x00000040211c7812ULL, 0x000fe400078ec0ffULL,
0x0000000114087812ULL, 0x000fe400078e0cffULL, 0x0000000d1c177c10ULL, 0x000fce000fffe0ffULL,
0x0000109000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x002fe20000011602ULL,
0x00018a8008047891ULL, 0x000fe2000f8e203fULL, 0x000000215c1f7217ULL, 0x000fe20007800000ULL,
0x0000000860637824ULL, 0x000fe200078e00ffULL, 0x000000041c667810ULL, 0x040fe20007ffe0ffULL,
0x018600061c1d7984ULL, 0x000e620008004800ULL, 0x000000011c207824ULL, 0x000fe400078e0217ULL,
0x000000011f1f7824ULL, 0x000fe400078e0a21ULL, 0x0000000203217824ULL, 0x000fc400078e0208ULL,
0x000000011c227824ULL, 0x140fe200078e0202ULL, 0x0000001f1c00720cULL, 0x000fe20003f06070ULL,
0x0000000166657824ULL, 0x040fe400078e0202ULL, 0x0000000866687824ULL, 0x000fca00078e00ffULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x000000041d1e7984ULL, 0x0022a40008004800ULL,
0xfffffff8631d7812ULL, 0x002fe200078ee202ULL, 0x0000001e07237224ULL, 0x004fe200078e0220ULL,
0x00002000211e7811ULL, 0x000fe200078e68ffULL, 0x00000100ff207424ULL, 0x000fe200078e00ffULL,
0x0000000722217812ULL, 0x000fc600078ec0ffULL, 0x00005e0023227625ULL, 0x000fe200078e0020ULL,
0x0ffffff821217812ULL, 0x000fca00078ef802ULL, 0x0000001021217824ULL, 0x000fe400078e021eULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000081c667810ULL, 0x000fe20007ffe0ffULL,
0x018610061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x0000000c1c667810ULL, 0x000fe20007ffe0ffULL,
0x018620061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000101c667810ULL, 0x000fe20007ffe0ffULL,
0x018630061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000141c667810ULL, 0x000fe20007ffe0ffULL,
0x018640061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000181c667810ULL, 0x000fe20007ffe0ffULL,
0x018650061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x0000001c1c667810ULL, 0x000fe20007ffe0ffULL,
0x018660061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000201c667810ULL, 0x000fe20007ffe0ffULL,
0x018670061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000241c667810ULL, 0x000fe20007ffe0ffULL,
0x018680061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000281c667810ULL, 0x000fe20007ffe0ffULL,
0x018690061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x0000002c1c667810ULL, 0x000fe20007ffe0ffULL,
0x0186a0061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000301c667810ULL, 0x000fe20007ffe0ffULL,
0x0186b0061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000341c667810ULL, 0x000fe20007ffe0ffULL,
0x0186c0061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fe40003f06070ULL, 0x000000381c667810ULL, 0x000fe20007ffe0ffULL,
0x0186d0061c647984ULL, 0x000ea80008004800ULL, 0x0000000866687824ULL, 0x000fe400078e00ffULL,
0x0000001065217824ULL, 0x002fc400078e021eULL, 0x0000000166657824ULL, 0x000fca00078e0202ULL,
0xfffffff868657812ULL, 0x000fe200078ee265ULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fc800078e0222ULL, 0x00005e0023227625ULL, 0x000fcc00078e0020ULL,
0x000000101d627825ULL, 0x000fc800078e0022ULL, 0x0000000166227824ULL, 0x040fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000062217faeULL, 0x0003e2000c101c50ULL,
0x0000001f6600720cULL, 0x000fc60003f06070ULL, 0x0186e0061c647984ULL, 0x000ea20008004800ULL,
0x0000001065637824ULL, 0x002fc600078e021eULL, 0x0000000464647984ULL, 0x004e640008004800ULL,
0x0000006407237224ULL, 0x002fe200078e0222ULL, 0x0000003c1c647810ULL, 0x000fc60007ffe0ffULL,
0x00005e0023227625ULL, 0x000fc800078e0020ULL, 0x0000000164177824ULL, 0x000fe400078e0217ULL,
0x000000101d227825ULL, 0x000fc800078e0022ULL, 0x0000000164657824ULL, 0x040fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022637faeULL, 0x0003e2000c101c50ULL,
0x0000000864667824ULL, 0x040fe200078e00ffULL, 0x0000001f6400720cULL, 0x000fe40003f06070ULL,
0x0186f0061c627984ULL, 0x000ea80008004800ULL, 0x0000000462627984ULL, 0x004ea40008004800ULL,
0x0000006207177224ULL, 0x004fc800078e0217ULL, 0x00005e0017207625ULL, 0x000fe200078e0020ULL,
0xfffffff866177812ULL, 0x000fca00078ee265ULL, 0x0000001017177824ULL, 0x000fe400078e021eULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020177faeULL, 0x0003e2000c101c50ULL, 0x00000f6000007947ULL, 0x000fea0003800000ULL,
0x00000003ff1c7819ULL, 0x002fe20000011602ULL, 0x00018a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000860217824ULL, 0x000fe400078e00ffULL, 0x00000002031e7824ULL, 0x000fe200078e0208ULL,
0x018600061c227984ULL, 0x000e620008004800ULL, 0x000000011c207824ULL, 0x040fe400078e0217ULL,
0x000000011c1d7824ULL, 0x000fe200078e0202ULL, 0x000020001e1e7811ULL, 0x000fe200078e68ffULL,
0x00000100ff1f7424ULL, 0x000fc600078e00ffULL, 0x000000071d237812ULL, 0x000fe400078ec0ffULL,
0xfffffff8211d7812ULL, 0x100fe400078ee202ULL, 0x0ffffff823237812ULL, 0x000fca00078ef802ULL,
0x0000001023637824ULL, 0x000fe200078e021eULL, 0x000000041c237810ULL, 0x000fca0007ffe0ffULL,
0x0000000123647824ULL, 0x040fe400078e0202ULL, 0x0000000823657824ULL, 0x000fca00078e00ffULL,
0xfffffff865657812ULL, 0x000fca00078ee264ULL, 0x0000001065657824ULL, 0x000fe200078e021eULL,
0x0000000422227984ULL, 0x002e640008004800ULL, 0x0000002207207224ULL, 0x002fe400078e0220ULL,
0x0000000123227824ULL, 0x000fe400078e0217ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x018610061c627984ULL, 0x000ea20008004800ULL,
0x000000081c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x018620061c627984ULL, 0x000ea20008004800ULL, 0x0000000c1c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x018630061c627984ULL, 0x000ea20008004800ULL,
0x000000101c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x018640061c627984ULL, 0x000ea20008004800ULL, 0x000000141c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x018650061c627984ULL, 0x000ea20008004800ULL,
0x000000181c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x018660061c627984ULL, 0x000ea20008004800ULL, 0x0000001c1c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x018670061c627984ULL, 0x000ea20008004800ULL,
0x000000201c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x018680061c627984ULL, 0x000ea20008004800ULL, 0x000000241c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x018690061c627984ULL, 0x000ea20008004800ULL,
0x000000281c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x0186a0061c627984ULL, 0x000ea20008004800ULL, 0x0000002c1c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x0186b0061c627984ULL, 0x000ea20008004800ULL,
0x000000301c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x0186c0061c627984ULL, 0x000ea20008004800ULL, 0x000000341c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123647824ULL, 0x040fe400078e0202ULL,
0x0000000823657824ULL, 0x000fca00078e00ffULL, 0xfffffff865657812ULL, 0x000fca00078ee264ULL,
0x0000001065657824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x0186d0061c627984ULL, 0x000ea20008004800ULL,
0x000000381c217810ULL, 0x002fca0007ffe0ffULL, 0x0000000121207824ULL, 0x040fe400078e0217ULL,
0x0000000121637824ULL, 0x040fe400078e0202ULL, 0x0000000821647824ULL, 0x000fca00078e00ffULL,
0xfffffff864637812ULL, 0x000fca00078ee263ULL, 0x0000001063637824ULL, 0x000fe200078e021eULL,
0x0000000462627984ULL, 0x004e640008004800ULL, 0x0000006207227224ULL, 0x002fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022657faeULL, 0x0003e8000b901c50ULL,
0x0186e0061c627984ULL, 0x000ea20008004800ULL, 0x0000003c1c237810ULL, 0x002fca0007ffe0ffULL,
0x0000000123227824ULL, 0x040fe400078e0217ULL, 0x0000000123177824ULL, 0x040fe400078e0202ULL,
0x0000000823647824ULL, 0x000fca00078e00ffULL, 0xfffffff864177812ULL, 0x000fca00078ee217ULL,
0x0000001017177824ULL, 0x000fe200078e021eULL, 0x0000000462627984ULL, 0x004e640008004800ULL,
0x0000006207207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e001fULL,
0x000000101d207825ULL, 0x000fca00078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020637faeULL, 0x0003e8000b901c50ULL, 0x0186f0061c627984ULL, 0x000ea80008004800ULL,
0x0000000462627984ULL, 0x004ea40008004800ULL, 0x0000006207227224ULL, 0x004fc800078e0222ULL,
0x00005e0022227625ULL, 0x000fcc00078e001fULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022177faeULL, 0x0003e4000b901c50ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0xffffffffff1d7424ULL, 0x000fe200078e00ffULL, 0x0001d510001c7802ULL, 0x000fc40000000f00ULL,
0x000046f000007944ULL, 0x002fea0003c00000ULL, 0x000000ff6000720cULL, 0x000fe20003f05270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000031000007945ULL, 0x000fec0003800000ULL,
0x000002f000008947ULL, 0x000fea0003800000ULL, 0x0000000115177810ULL, 0x002fe20007ffe0ffULL,
0x0000028000017945ULL, 0x000fe20003800000ULL, 0x000000165900720cULL, 0x000fe40003f04070ULL,
0x00000002ff1c7819ULL, 0x000fc40000011617ULL, 0x0000000317177812ULL, 0x000fe400078ec0ffULL,
0x000000011c1d7807ULL, 0x000fe40004000000ULL, 0x000000ff17177207ULL, 0x000fe40004000000ULL,
0x00000020021e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001161d7824ULL, 0x000fe200078e021dULL,
0x000000165900720cULL, 0x000fe40003f04070ULL, 0x000000031500780cULL, 0x000fc40003f85270ULL,
0x000000051d1d7c11ULL, 0x000fe4000f8e40ffULL, 0x0000000a171c7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000602217c11ULL, 0x000fe2000f8e10ffULL, 0x000000011d177824ULL, 0x100fe400078e0202ULL,
0x000000011e1f7824ULL, 0x100fe400078e021dULL, 0x000068001c1d7a24ULL, 0x000fe200078e021dULL,
0x0000005c1700720cULL, 0x080fe20003f26070ULL, 0x00000004ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005c1f00720cULL, 0x000fe20003f66070ULL, 0x000000011d167824ULL, 0x000fc400078e0202ULL,
0x000000011e1d7824ULL, 0x000fe400078e021dULL, 0x0000660016167625ULL, 0x000fc800078e001cULL,
0x000066001d1c7625ULL, 0x000fe200078e001cULL, 0x0000010000008947ULL, 0x000fea0002000000ULL,
0x000000030200780cULL, 0x000fe40003f04070ULL, 0x0000000253537810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x000e620000002700ULL,
0x0000005a5300720cULL, 0x000fe20003f06070ULL, 0x00000004ff1f7424ULL, 0x000fe400078e00ffULL,
0x0000000415157824ULL, 0x002fc800078e0202ULL, 0x00000002151e7824ULL, 0x000fe400078e00ffULL,
0x0000000403157824ULL, 0x000fe400078e0202ULL, 0x000064001e1e7a24ULL, 0x000fc600078e0253ULL,
0x00018a8015157811ULL, 0x000fe200078e10ffULL, 0x000060001e1e7625ULL, 0x000fca00078e001fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e157faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1860000016217faeULL, 0x0005e8000c921850ULL, 0x186800001c217faeULL, 0x0005e4000d921850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002677810ULL, 0x040fe20007ffe0ffULL, 0x0000000203627824ULL, 0x000fe200078e0214ULL,
0x0000000702637812ULL, 0x042fe200078ec0ffULL, 0x000000ffff607224ULL, 0x000fe200078e00ffULL,
0xfffffff802657812ULL, 0x000fe400078ec0ffULL, 0xfffffff867677812ULL, 0x000fc400078ec0ffULL,
0x0000200062627811ULL, 0x000fe400078e68ffULL, 0x0000000863637812ULL, 0x100fe400078ef802ULL,
0x0000000765657812ULL, 0x100fe400078ef802ULL, 0x0000000767677812ULL, 0x000fc600078ef802ULL,
0x0000000165147824ULL, 0x160fe200078e0260ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000865157824ULL, 0x000fe400078e00ffULL, 0x000000085f997824ULL, 0x000fc400078e0260ULL,
0x00000008676b7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee214ULL,
0x0000000167147824ULL, 0x000fe400078e0260ULL, 0x0000000299997824ULL, 0x000fe400078e00ffULL,
0x00000010151c7824ULL, 0x004fe400078e0262ULL, 0x0000000867157824ULL, 0x000fc800078e00ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0xfffffff815157812ULL, 0x000fca00078ee214ULL,
0x0000001015157824ULL, 0x000fcc00078e0262ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff717819ULL, 0x002fe2000001141cULL, 0x000100001c207824ULL, 0x040fe200078e00ffULL,
0x000088801c967816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001141dULL, 0x000100001d217824ULL, 0x040fe200078e00ffULL,
0x000088801d947816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff907819ULL, 0x000fc4000001141eULL, 0x000088801e917816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff817819ULL, 0x000fe2000001141fULL,
0x0000001c00987306ULL, 0x0002e20000200c00ULL, 0x000088801f807816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff217819ULL, 0x000fc40000011421ULL,
0x00000018ff697819ULL, 0x004fe20000011414ULL, 0x0000001d007d7306ULL, 0x0005e20000200c00ULL,
0x000100001e1c7824ULL, 0x002fe200078e00ffULL, 0x0000888014687816ULL, 0x000fe200000000ffULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011415ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x000100001f1d7824ULL, 0x044fe200078e00ffULL, 0x0000002000977306ULL, 0x0003e20000200c00ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00008880158a7816ULL, 0x000fc400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001e00937306ULL, 0x0005e20000200c00ULL, 0x0000000865207824ULL, 0x002fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011416ULL, 0x00000018ff707819ULL, 0x000fe40000011417ULL,
0x0000888016877816ULL, 0x000fc400000000ffULL, 0x0000001d008f7306ULL, 0x0003e20000200c00ULL,
0x00000001601e7810ULL, 0x044fe40007ffe0ffULL, 0x0000888017827816ULL, 0x000fe400000000ffULL,
0x0000000260607810ULL, 0x000fc60007ffe0ffULL, 0x0000001f008e7306ULL, 0x0005e20000200c00ULL,
0x00000001651d7824ULL, 0x102fe200078e021eULL, 0x000000086000780cULL, 0x000fe20003f05270ULL,
0x00000001671e7824ULL, 0x000fca00078e021eULL, 0x0000002100957306ULL, 0x0003e20000200c00ULL,
0xfffffff8201f7812ULL, 0x004fe200078ee21dULL, 0x00010000151d7824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee21eULL, 0x0000010015157824ULL, 0x000fe400078e00ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0262ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000001c00927306ULL, 0x0005e20000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x000000001f20783bULL, 0x002e6a0000000200ULL, 0x0000001500897306ULL, 0x0009e20000200c00ULL,
0x00010000141c7824ULL, 0x004fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000017157824ULL, 0x050fe200078e00ffULL, 0x0000001c008d7306ULL, 0x0005e20000200c00ULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000014008c7306ULL, 0x0009e20000200c00ULL,
0x000000106b1c7824ULL, 0x004fce00078e0262ULL, 0x0000001500857306ULL, 0x0005e20000200c00ULL,
0x0001000016147824ULL, 0x050fe400078e00ffULL, 0x0000010016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000002063157824ULL, 0x004fe200078e00ffULL, 0x0000001400887306ULL, 0x0005e20000200c00ULL,
0x00000018ff797819ULL, 0x002fe40000011420ULL, 0x00008880207b7816ULL, 0x040fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011421ULL, 0x0000888021777816ULL, 0x000fe200000000ffULL,
0x0000001600867306ULL, 0x000fe20000200c00ULL, 0x0001000020147824ULL, 0x044fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011422ULL, 0x0000010020207824ULL, 0x000fe200078e00ffULL,
0x0000888022757816ULL, 0x000fc400000000ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011414ULL,
0x0000009902147211ULL, 0x000fe200078fe0ffULL, 0x0000001700837306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff6c7819ULL, 0x000fe20000011423ULL,
0x0000000163147824ULL, 0x000fe200078e0214ULL, 0x00008880236e7816ULL, 0x000fe400000000ffULL,
0x0000000299997810ULL, 0x000fe20007ffe0ffULL, 0x0000001d008b7306ULL, 0x0003e20000200c00ULL,
0xffffffe015147812ULL, 0x000fe200078ee214ULL, 0x0001000021157824ULL, 0x000fc400078e00ffULL,
0x0000010021217824ULL, 0x000fe400078e00ffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011415ULL, 0x0000009600967306ULL, 0x000ea20000200c00ULL,
0x000000001c1c783bULL, 0x002e620000000200ULL, 0x00000018ff217819ULL, 0x000fc60000011421ULL,
0x000000001414783bULL, 0x000f260000000200ULL, 0x00000020007c7306ULL, 0x0005f00000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0001000022207824ULL, 0x004fc400078e00ffULL,
0x0000010022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000009400947306ULL, 0x000ea20000200c00ULL, 0x00000018ff227819ULL, 0x000fce0000011422ULL,
0x0000002100787306ULL, 0x0003f00000200c00ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x0001000023217824ULL, 0x042fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001141cULL,
0x0000010023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc4000001141dULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x00000018ff9a7819ULL, 0x000fe40000011423ULL, 0x0000541098237816ULL, 0x008fe40000000071ULL,
0x00000018ff647819ULL, 0x000fe4000001141fULL, 0x00000018ff667819ULL, 0x000fe2000001141eULL,
0x0000002200747306ULL, 0x0007f00000200c00ULL, 0x0000002000767306ULL, 0x0005e20000200c00ULL,
0x0000541096227816ULL, 0x008fc40000000097ULL, 0x000088801c967816ULL, 0x000fca00000000ffULL,
0x0000002100737306ULL, 0x0007e20000200c00ULL, 0x0000541094207816ULL, 0x004fe20000000095ULL,
0x00000022143c723cULL, 0x010b62000000183cULL, 0x0000002063957824ULL, 0x000fca00078e00ffULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x000054107d217816ULL, 0x008fe20000000072ULL,
0x000000ffff237224ULL, 0x020fe200078e0096ULL, 0x0000009902227211ULL, 0x000fe200078fe0ffULL,
0x000100001c7d7824ULL, 0x040fe400078e00ffULL, 0x000001001c1c7824ULL, 0x000fe400078e00ffULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x000000201438723cULL, 0x000b620000001838ULL,
0x0000000163227824ULL, 0x000fe200078e0222ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0xffffffe095227812ULL, 0x000fe200078ee222ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x0000541091207816ULL, 0x022fe40000000092ULL,
0x0000541093217816ULL, 0x000fe20000000090ULL, 0x0000001022227824ULL, 0x000fc800078e00ffULL,
0x0000006800687306ULL, 0x000e640000200c00ULL, 0x000000201434723cULL, 0x000b6c0000001834ULL,
0x0000008400847306ULL, 0x000f220000200c00ULL, 0x0000541080207816ULL, 0x024fe4000000008fULL,
0x000054108e217816ULL, 0x000fe20000000081ULL, 0x000100001d8e7824ULL, 0x000fe200078e00ffULL,
0x000054108c697816ULL, 0x008fc40000000069ULL, 0x000088801d8f7816ULL, 0x000fe200000000ffULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x0000541068687816ULL, 0x002fe2000000008dULL,
0x000000201430723cULL, 0x000b640000001830ULL, 0x000000ffff817224ULL, 0x000fc800078e008fULL,
0x0000002300727306ULL, 0x0003e40000200c00ULL, 0x00000068142c723cULL, 0x000b6c000000182cULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000000002220783bULL, 0x022e620000000200ULL,
0x000001001d697824ULL, 0x000fe200078e00ffULL, 0x00005410891d7816ULL, 0x010fc40000000084ULL,
0x000088801e847816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe2000001148eULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x00000018ff697819ULL, 0x000fce0000011469ULL,
0x0000001c00807306ULL, 0x0005f00000200c00ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000054108a1c7816ULL, 0x004fce000000008bULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x0000001c1428723cULL, 0x000b6e0000001828ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410871c7816ULL, 0x028fe40000000088ULL, 0x00005410861d7816ULL, 0x000fe2000000007fULL,
0x000000ffff7f7224ULL, 0x000fc400078e0084ULL, 0x000100001e847824ULL, 0x040fe400078e00ffULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000001c1424723cULL, 0x000b680000001824ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000007e007e7306ULL, 0x000ee20000200c00ULL, 0x00005410821c7816ULL, 0x024fc40000000085ULL,
0x00005410831d7816ULL, 0x000fca0000000070ULL, 0x0000006f006f7306ULL, 0x000ea40000200c00ULL,
0x0000001c1418723cULL, 0x000b6c0000001818ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000054107b147816ULL, 0x028fe4000000007eULL, 0x000054107c157816ULL, 0x000fc40000000079ULL,
0x000088801f1c7816ULL, 0x000fe400000000ffULL, 0x00000018ff167819ULL, 0x000fe20000011484ULL,
0x0000007a007a7306ULL, 0x000ee40000200c00ULL, 0x00000014203c723cULL, 0x002b6c000000183cULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541078157816ULL, 0x024fc4000000006fULL,
0x0000541077147816ULL, 0x008fca000000007aULL, 0x0000006d006d7306ULL, 0x000ea40000200c00ULL,
0x000000142038723cULL, 0x000b620000001838ULL, 0x000054106e6e7816ULL, 0x002fca0000000073ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000ffff147224ULL, 0x020fe400078e001cULL,
0x000100001f1c7824ULL, 0x000fca00078e00ffULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000541074157816ULL, 0x004fe4000000006dULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000014001d7306ULL, 0x000ff00000200c00ULL, 0x0000001c001c7306ULL, 0x000ea20000200c00ULL,
0x0000541080737816ULL, 0x002fce000000006bULL, 0x0000006a006a7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000054101d1c7816ULL, 0x004fce000000001cULL,
0x0000006400647306ULL, 0x000ff00000200c00ULL, 0x0000007500757306ULL, 0x000e700000200c00ULL,
0x0000009a00717306ULL, 0x000eb00000200c00ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541075147816ULL, 0x002fce0000000076ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00005410716f7816ULL, 0x004fe2000000006cULL, 0x000000142034723cULL, 0x040b6c0000001834ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000541072727816ULL, 0x008fe2000000007dULL,
0x0000006e2030723cULL, 0x040b6c0000001830ULL, 0x0000006900697306ULL, 0x000ea40000200c00ULL,
0x00000072202c723cULL, 0x000b6c000000182cULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541081687816ULL, 0x002fce0000000068ULL, 0x0000001600167306ULL, 0x000e620000200c00ULL,
0x0000541069697816ULL, 0x004fce000000006aULL, 0x0000001e00177306ULL, 0x000ea20000200c00ULL,
0x000000682028723cULL, 0x000b6e0000001828ULL, 0x0000001f001f7306ULL, 0x000ee20000200c00ULL,
0x000054107f167816ULL, 0x002fe40000000016ULL, 0x0000541017177816ULL, 0x004fce0000000066ULL,
0x000000162024723cULL, 0x000b620000001824ULL, 0x000054101f1d7816ULL, 0x008fce0000000064ULL,
0x0000001c2018723cULL, 0x000b620000001818ULL, 0xfffff04000000947ULL, 0x000fce000383ffffULL,
0x000000026100780cULL, 0x000fe20003f06070ULL, 0x000000ffff5f7224ULL, 0x000fe400078e0061ULL,
0x000000ffff147224ULL, 0x020fd400078e0008ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffca7000007947ULL, 0x000fea000383ffffULL, 0x00000002ff177819ULL, 0x000fc80000011602ULL,
0x000000581700720cULL, 0x040fe40003f06070ULL, 0x0000000158587810ULL, 0x000fe40007ffe0ffULL,
0x00000008175f7810ULL, 0x040fe40007ffe0ffULL, 0x000000581700720cULL, 0x000fe40004706470ULL,
0x0000005e5f00720cULL, 0x000fe40003f26070ULL, 0x000000065900720cULL, 0x000fc40000703070ULL,
0x000000585f00720cULL, 0x000fc80000f21070ULL, 0x000000065900720cULL, 0x000fc80000f24470ULL,
0x000000561b567208ULL, 0x000fe40000800000ULL, 0x000000431a437208ULL, 0x000fe20000800000ULL,
0x000000ffff548224ULL, 0x000fe200078e0019ULL, 0x0000004427447208ULL, 0x000fe20000800000ULL,
0x000000ffff558224ULL, 0x000fe200078e0018ULL, 0x0000004526457208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e0025ULL, 0x000000462b467208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0024ULL, 0x000000472a477208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e0029ULL, 0x000000482f487208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e0028ULL, 0x000000492e497208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e002dULL, 0x0000004a334a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e002cULL, 0x0000004b324b7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0031ULL, 0x0000004c374c7208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0030ULL, 0x0000004d364d7208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0035ULL, 0x0000004e3b4e7208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0034ULL, 0x0000004f3a4f7208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e0039ULL, 0x000000503f507208ULL, 0x000fe20000800000ULL,
0x000000ffff408224ULL, 0x000fe200078e0038ULL, 0x000000513e517208ULL, 0x000fe20000800000ULL,
0x000000ffff418224ULL, 0x000fc400078e003dULL, 0x000000ffff428224ULL, 0x000fe200078e003cULL,
0x0000005d5800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffc68000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000052147f8cULL, 0x000e62000c80043fULL, 0x0000000042217220ULL, 0x080fe40000410000ULL,
0x0000000041207220ULL, 0x080fe40000410000ULL, 0x00000000401f7220ULL, 0x080fe40000410000ULL,
0x0000000013137220ULL, 0x080fe40000410000ULL, 0x0000000012127220ULL, 0x080fe40000410000ULL,
0x0000000011117220ULL, 0x000fc40000410000ULL, 0x0000000010107220ULL, 0x080fe40000410000ULL,
0x000000000f1e7220ULL, 0x080fe40000410000ULL, 0x000000000e1d7220ULL, 0x080fe40000410000ULL,
0x000000000d1c7220ULL, 0x080fe40000410000ULL, 0x000000000c1b7220ULL, 0x080fe40000410000ULL,
0x000000000b0b7220ULL, 0x000fc40000410000ULL, 0x000000ffff2d7224ULL, 0x002fe400078e0015ULL,
0x000000000a0a7220ULL, 0x080fe40000410000ULL, 0x0000000009097220ULL, 0x080fe40000410000ULL,
0x00000000551a7220ULL, 0x080fe40000410000ULL, 0x0000000054197220ULL, 0x080fe40000410000ULL,
0x0000000051327220ULL, 0x000fc40000410000ULL, 0x00000000502f7220ULL, 0x080fe40000410000ULL,
0x000000004f337220ULL, 0x080fe40000410000ULL, 0x000000004e347220ULL, 0x080fe40000410000ULL,
0x000000004d2e7220ULL, 0x080fe40000410000ULL, 0x000000004c2b7220ULL, 0x080fe40000410000ULL,
0x000000004b2a7220ULL, 0x000fc40000410000ULL, 0x000000004a297220ULL, 0x080fe40000410000ULL,
0x0000000049287220ULL, 0x080fe40000410000ULL, 0x0000000048277220ULL, 0x080fe40000410000ULL,
0x0000000047267220ULL, 0x080fe40000410000ULL, 0x0000000046257220ULL, 0x080fe40000410000ULL,
0x0000000045247220ULL, 0x000fc40000410000ULL, 0x0000000044237220ULL, 0x080fe40000410000ULL,
0x0000000043227220ULL, 0x080fe40000410000ULL, 0x0000000056187220ULL, 0x000fc40000410000ULL,
0x00000000000c7805ULL, 0x000fca0000015200ULL, 0x00000400520e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fe4000780482dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400520e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe4000780482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004022c7824ULL, 0x000fe200078e00ffULL,
0x000000040600720cULL, 0x000fc80003f05270ULL, 0xfffffff02c0c7812ULL, 0x000fca00078ec0ffULL,
0x00000080032d7824ULL, 0x000fca00078e020cULL, 0x018400002d0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202147824ULL, 0x000fe400078e00ffULL,
0x000000015c577824ULL, 0x000fc600078e0a57ULL, 0x0000000614147812ULL, 0x000fc800078ec0ffULL,
0x0000000114167812ULL, 0x040fe400078efcffULL, 0x0000000814307812ULL, 0x000fe400078efcffULL,
0x000000571600720cULL, 0x080fe40003f26070ULL, 0x0000001014167812ULL, 0x000fe400078efcffULL,
0x000000573000720cULL, 0x080fe40003f06070ULL, 0x000000571600720cULL, 0x000fc40003fc6070ULL,
0x0000001114307812ULL, 0x040fe400078efcffULL, 0x0000001814167812ULL, 0x040fe400078efcffULL,
0x000000571400720cULL, 0x080fe40003f46070ULL, 0x000000573000720cULL, 0x080fe40003fa6070ULL,
0x000000571600720cULL, 0x000fe40003f66070ULL, 0x0000000914367812ULL, 0x000fc400078efcffULL,
0x0000001914307812ULL, 0x040fe400078efcffULL, 0x0000002014167812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff80000020207808ULL, 0x000fc40004800000ULL,
0x000000573600720cULL, 0x080fe40003f86070ULL, 0x000000573000720cULL, 0x080fe40003f46070ULL,
0x000000571600720cULL, 0x000fe40003f26070ULL, 0x0000002114307812ULL, 0x040fe400078efcffULL,
0x0000002814167812ULL, 0x000fe400078efcffULL, 0xff80000033337808ULL, 0x000fc40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004000000ULL, 0xff80000034347808ULL, 0x000fe40006000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0x000000573000720cULL, 0x080fe40003f06070ULL,
0x000000571600720cULL, 0x000fe40003f86070ULL, 0x0000002914307812ULL, 0x000fc400078efcffULL,
0x0000003014167812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006800000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0x000000573000720cULL, 0x000fc40003fc6070ULL,
0x000000571600720cULL, 0x000fe40003fa6070ULL, 0x0000003114307812ULL, 0x040fe400078efcffULL,
0x0000003814167812ULL, 0x040fe400078efcffULL, 0x0000003914147812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0x000000573000720cULL, 0x080fe40003f66070ULL, 0x000000571600720cULL, 0x000fc40003f46070ULL,
0x000000571400720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000001b1b7808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fc40007000000ULL,
0xff8000000b0b7808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff8000000a0a7808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff80000009097808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff80000018187808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fc40004800000ULL, 0x000000210c00720bULL, 0x004fe40003f1e000ULL,
0x000000320d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c21157208ULL, 0x000fe40004000000ULL,
0x0000000d320c7208ULL, 0x000fc40004800000ULL, 0x000000201500720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x0000001520147208ULL, 0x000fe40004000000ULL,
0x0000000c2f0c7208ULL, 0x000fe40004800000ULL, 0x0000001f1400720bULL, 0x000fe40003f1e000ULL,
0x000000330c00720bULL, 0x000fc40003f3e000ULL, 0x000000141f147208ULL, 0x000fe40004000000ULL,
0x0000000c330d7208ULL, 0x000fe40004800000ULL, 0x000000131400720bULL, 0x000fe40003f1e000ULL,
0x000000340d00720bULL, 0x000fe40003f3e000ULL, 0x0000001413157208ULL, 0x000fe40004000000ULL,
0x0000000d340d7208ULL, 0x000fc40004800000ULL, 0x000000121500720bULL, 0x000fe40003f1e000ULL,
0x0000002e0d00720bULL, 0x000fe40003f3e000ULL, 0x00000015120c7208ULL, 0x000fe40004000000ULL,
0x0000000d2e147208ULL, 0x000fe40004800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x0000002b1400720bULL, 0x000fc40003f3e000ULL, 0x0000000c110d7208ULL, 0x000fe40004000000ULL,
0x000000142b157208ULL, 0x000fe40004800000ULL, 0x000000100d00720bULL, 0x000fe40003f1e000ULL,
0x0000002a1500720bULL, 0x000fe40003f3e000ULL, 0x0000000d100d7208ULL, 0x000fe40004000000ULL,
0x000000152a0c7208ULL, 0x000fc40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000000d1e147208ULL, 0x000fe40004000000ULL,
0x0000000c290d7208ULL, 0x000fe40004800000ULL, 0x0000001d1400720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x000000141d157208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x0000001c1500720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x000000151c147208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fc40004800000ULL, 0x0000001b1400720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x000000141b147208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fe40004800000ULL, 0x0000000b1400720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x000000140b0d7208ULL, 0x000fe40004000000ULL,
0x0000000c25157208ULL, 0x000fe40004800000ULL, 0x0000000a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000241500720bULL, 0x000fe40003f3e000ULL, 0x0000000d0a0c7208ULL, 0x000fe40004000000ULL,
0x0000001524147208ULL, 0x000fc40004800000ULL, 0x000000090c00720bULL, 0x000fe40003f1e000ULL,
0x000000231400720bULL, 0x000fe40003f3e000ULL, 0x0000000c090d7208ULL, 0x000fe40004000000ULL,
0x0000001423157208ULL, 0x000fe40004800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000221500720bULL, 0x000fc40003f3e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004000000ULL,
0x0000001522157208ULL, 0x000fe40004800000ULL, 0x000000190c00720bULL, 0x000fe40003f1e000ULL,
0x000000181500720bULL, 0x000fe40003f3e000ULL, 0x0000000c19357208ULL, 0x000fe40004000000ULL,
0x0000001518377208ULL, 0x000fe20004800000ULL, 0x00001cb27f007947ULL, 0x000fec000b800000ULL,
0x0c401f00350c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3500720bULL, 0x008fc80003f1e000ULL,
0x000000350c387208ULL, 0x000fe20004000000ULL, 0x00001ce27f007947ULL, 0x000fea000b800000ULL,
0x0c401f00370c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f307f89ULL, 0x000e6800000e0000ULL, 0x0c201f0038147f89ULL, 0x000ea200000e0000ULL,
0x0000000c3700720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x000000370c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000300f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c157f89ULL, 0x000e6600000e0000ULL,
0x0000000f30307208ULL, 0x000fe20004000000ULL, 0x0c201f000d167f89ULL, 0x000ee200000e0000ULL,
0x000000143800720bULL, 0x004fc60003f1e000ULL, 0x0c201f0030317f89ULL, 0x0004a200000e0000ULL,
0x0000003814147208ULL, 0x000fe40004000000ULL, 0x000000150c00720bULL, 0x002fe40003f3e000ULL,
0x000000160d00720bULL, 0x008fe40003f5e000ULL, 0x0000000c15157208ULL, 0x000fe40004800000ULL,
0x0000000d16167208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b15357820ULL, 0x006fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000817367824ULL, 0x040fe200078e00ffULL,
0x0001200008047891ULL, 0x000fe2000f8e583fULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010835ULL,
0xffffffff173a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003200517308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010835ULL, 0x000000313000720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b34347823ULL, 0x000fc40000010835ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe40000010835ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010835ULL, 0x0000002f00507308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b14327820ULL, 0x002fe40000410000ULL, 0x3fb8aa3b26267823ULL, 0x000fe40000010835ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x00000033004f7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b20207823ULL, 0x000fc40000010832ULL,
0x3fb8aa3b1f1f7823ULL, 0x000fe40000010832ULL, 0x3fb8aa3b25257823ULL, 0x100fe40000010835ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010835ULL, 0x00000034004e7308ULL, 0x000ee20000000800ULL,
0x3c003c00ff2f7424ULL, 0x004fe400078e00ffULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe40000010835ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fc40000010835ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010835ULL,
0x0000002100427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b28287823ULL, 0x000fe40000010835ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b11117823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010832ULL, 0x0000002000417308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1e0f7823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b23237823ULL, 0x100fe40000010835ULL,
0x3fb8aa3b22227823ULL, 0x000fe40000010835ULL, 0x3fb8aa3b1d0e7823ULL, 0x100fe20000010832ULL,
0x0000001f00407308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c0d7823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b1b0c7823ULL, 0x100fe20000010832ULL, 0x00000001171b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010832ULL, 0x00000008171c7824ULL, 0x000fe200078e00ffULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010832ULL, 0xfffffff81c337812ULL, 0x002fe200078ee21bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010832ULL, 0x00000003171b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b19197823ULL, 0x000fe20000010832ULL, 0x0000002e004d7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010835ULL, 0x0000000417327810ULL, 0x040fe20007ffe0ffULL,
0x0000000817357824ULL, 0x000fc400078e00ffULL, 0x0000000817377824ULL, 0x040fe400078e00ffULL,
0x0000000817387824ULL, 0x040fe200078e00ffULL, 0x0000002700487308ULL, 0x0007e20000000800ULL,
0x3c003c00ff2e7424ULL, 0x002fe400078e00ffULL, 0x0000000817397824ULL, 0x040fe400078e00ffULL,
0x00000008173b7824ULL, 0x000fe400078e00ffULL, 0x000000085f3c7824ULL, 0x000fe200078e00ffULL,
0x0000002600477308ULL, 0x0005e20000000800ULL, 0x0000004f4e27723eULL, 0x008fc400000000ffULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee23aULL, 0xfffffff83c5f7812ULL, 0x000fe400078ee25fULL,
0x000000043b3c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002500467308ULL, 0x0002e20000000800ULL,
0x000000401326723eULL, 0x004fe400000000ffULL, 0x000000045f3e7c11ULL, 0x000fca000f8e20ffULL,
0x0000002400457308ULL, 0x0005e20000000800ULL, 0x000000515025723eULL, 0x002fce00000000ffULL,
0x0000002b004c7308ULL, 0x000e620000000800ULL, 0x000000424124723eULL, 0x004fe400000000ffULL,
0x00000047461f723eULL, 0x008fca00000000ffULL, 0x0000002a004b7308ULL, 0x000ff00000000800ULL,
0x00000029004a7308ULL, 0x000fe20000000800ULL, 0x0000004d4c21723eULL, 0x002fce00000000ffULL,
0x0000002800497308ULL, 0x0002b00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000002e2428723cULL, 0x002f6e00000018ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x00000049481d723eULL, 0x004fce00000000ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x000000121120723eULL, 0x002fce00000000ffULL,
0x0000002300447308ULL, 0x0003f00000000800ULL, 0x0000002200437308ULL, 0x0005e20000000800ULL,
0x0000004b4a23723eULL, 0x002fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000100f22723eULL, 0x004fce00000000ffULL, 0x0000002e2028723cULL, 0x020f620000001828ULL,
0x0000000d000d7308ULL, 0x000e700000000800ULL, 0x0000000c000c7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000000e0d1c723eULL, 0x002fce00000000ffULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x0000000c0b1e723eULL, 0x004fce00000000ffULL,
0x0000000900097308ULL, 0x000e620000000800ULL, 0x0000002e1c28723cULL, 0x020f6e0000001828ULL,
0x0000001a00557308ULL, 0x0005f00000000800ULL, 0x0000001900547308ULL, 0x0007220000000800ULL,
0x00000002171a7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff835347812ULL, 0x000fe400078ee21aULL,
0xfffffff836357812ULL, 0x000fe200078ee21bULL, 0x0000001800567308ULL, 0x0002a20000000800ULL,
0x0000000517197810ULL, 0x008fe40007ffe0ffULL, 0xfffffff837367812ULL, 0x000fe200078ee232ULL,
0x0000000817327824ULL, 0x000fe200078e00ffULL, 0xfffffff838377812ULL, 0x000fe400078ee219ULL,
0x000000454419723eULL, 0x000fc400000000ffULL, 0x0000000a0918723eULL, 0x002fe400000000ffULL,
0x00000055541a723eULL, 0x010fe400000000ffULL, 0xfffffff832327812ULL, 0x000fe400078ee217ULL,
0x0000000617387810ULL, 0x000fe40007ffe0ffULL, 0x00000043561b723eULL, 0x004fe400000000ffULL,
0x0000000c2c177812ULL, 0x000fc400078ec0ffULL, 0x0000000432327c11ULL, 0x000fe4000f8e20ffULL,
0x00000004332c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002e1828723cULL, 0x020b620000001828ULL,
0xfffffff839397812ULL, 0x000fe200078ee238ULL, 0x00000001173c7824ULL, 0x040fe200078e023cULL,
0x0000000434347c11ULL, 0x000fe2000f8e20ffULL, 0x00000001172c7824ULL, 0x040fe200078e022cULL,
0x0000000436367c11ULL, 0x000fe2000f8e20ffULL, 0x00000001173e7824ULL, 0x000fe200078e023eULL,
0x00000004352e7c11ULL, 0x020fe2000f8e20ffULL, 0x0000000117347824ULL, 0x000fe200078e0234ULL,
0x0000000437387c11ULL, 0x000fe2000f8e20ffULL, 0x0000000117367824ULL, 0x000fe200078e0236ULL,
0x00000004393a7c11ULL, 0x000fe2000f8e20ffULL, 0x00000001172e7824ULL, 0x000fc400078e022eULL,
0x0000000117387824ULL, 0x040fe400078e0238ULL, 0x00000001173a7824ULL, 0x000fc800078e023aULL,
0x0000000132297824ULL, 0x000fe200078e0217ULL, 0x0000003031177208ULL, 0x000fc80004800000ULL,
0x0000002429007388ULL, 0x0003e80000000800ULL, 0x000000262c007388ULL, 0x0005e80000000800ULL,
0x0000002034007388ULL, 0x0005e20000000800ULL, 0x000000ffff297224ULL, 0x002fc600078e002aULL,
0x000000222e007388ULL, 0x0005e80000000800ULL, 0x0000001c36007388ULL, 0x0005e80000000800ULL,
0x0000001e38007388ULL, 0x0005e80000000800ULL, 0x000000183a007388ULL, 0x0005e80000000800ULL,
0x0000001a3c007388ULL, 0x0005e80000000800ULL, 0x000000253e007388ULL, 0x0005e80000000800ULL,
0x000400272c007388ULL, 0x0005e80000000800ULL, 0x0004002134007388ULL, 0x0005e80000000800ULL,
0x000400232e007388ULL, 0x0005e80000000800ULL, 0x0004001d36007388ULL, 0x0005e80000000800ULL,
0x0004001f38007388ULL, 0x0005e80000000800ULL, 0x000400193a007388ULL, 0x0005e80000000800ULL,
0x0004001b3c007388ULL, 0x0005e80000000800ULL, 0x018000142d008388ULL, 0x0005e80000000c00ULL,
0x018200282d008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000005ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080005ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100005ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000106067810ULL, 0x000fe20007ffe0ffULL, 0x0000180005ff7f8cULL, 0x0003e6000c80043fULL,
0x0000005b0600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffabe000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff207807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0002064000247802ULL, 0x000fc40000000f00ULL, 0x0000155000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffe2ec000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x000206a000247802ULL, 0x000fc40000000f00ULL, 0x000014f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0025ULL, 0xfffe2ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x000fe200078e0013ULL, 0x0002072000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e0024ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000143000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffe2f7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0024ULL, 0x000207a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0013ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000013b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffe305000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001cULL, 0x0002082000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e001dULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000133000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffe320000007947ULL, 0x000fea000383ffffULL,
0x000000ffff277224ULL, 0x002fe200078e001bULL, 0x000208a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe400078e001cULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000012b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffe31b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002092000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000123000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffe596000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000209a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000011b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffe590000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00020a0000247802ULL, 0x000fc40000000f00ULL, 0x0000119000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xfffe84d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00020a6000247802ULL, 0x000fc40000000f00ULL, 0x0000113000007944ULL, 0x008fea0003c00000ULL,
0xfffe851000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x00020ad000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000108000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffe858000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x00020b5000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000100000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffe865000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020bd000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000f8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffe87f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020c5000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000f0000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffe879000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020cd000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000e8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xfffead2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00020d5000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000e0000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xfffeacc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00020db000247802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0025ULL,
0xfffed77000007947ULL, 0x000fea000383ffffULL, 0x00000001ff207807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00020e1000247802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x008fea0003c00000ULL, 0xfffed7b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x00020e8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000cd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffed82000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x00020f0000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000c5000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffed8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00020f8000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffeda9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002100000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffeda3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002108000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0062ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1a7224ULL, 0x004fe200078e0026ULL, 0xfffeffc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0002110000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fe400078e0061ULL, 0x0000001fff287424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0026ULL, 0xfffeff6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0002116000247802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e0025ULL, 0xffff2a1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff207807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x000211c000247802ULL, 0x000fc40000000f00ULL, 0x000009d000007944ULL, 0x008fea0003c00000ULL,
0xffff2a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0002123000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff2ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x000212b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff2b9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0002133000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000082000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff2d3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000213b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000007a000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xffff2cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0002143000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e0062ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x004fe200078e0026ULL,
0xffff526000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000214b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fe400078e0061ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff1b7224ULL, 0x004fe200078e0026ULL,
0xffff520000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0006ULL,
0x0002152000207802ULL, 0x000fe20000000f00ULL, 0x0000001fff287424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0026ULL, 0xffff662000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0006ULL, 0x0002159000207802ULL, 0x000fe20000000f00ULL,
0x0000001fff287424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0026ULL,
0xffff66f000007947ULL, 0x000fea000383ffffULL, 0x00000002ff367424ULL, 0x000fe200078e00ffULL,
0x00021600000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0031ULL, 0xffffe2f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff357224ULL, 0x006fe200078e0037ULL, 0x00021680000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fc400078e00ffULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000313700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e000eULL,
0x00021700000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x000fe200078e00ffULL,
0x0000003731167208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000310e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e000fULL,
0x00021780000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x000fe200078e00ffULL,
0x0000000e310e7208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000310f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e0038ULL,
0x00021800000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0x0000000f31307208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000313800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e0016ULL,
0x00021880000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0x0000003831147208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000311600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e000eULL,
0x00021900000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0x0000001631157208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000310e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff357224ULL, 0x002fe200078e0030ULL,
0x00021980000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0x0000000e31167208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe0e000007947ULL, 0x000fea000383ffffULL, 0x0180000012007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff12ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000012027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0006ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffde4f002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0c00003635317389ULL, 0x0002a200000e0031ULL,
0xfffde4b00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x0000002726267389ULL, 0x0002a200000e0028ULL,
0xfffde47020007950ULL, 0x000fea0003c3ffffULL, 0x000000012000780cULL, 0x000fe20003f25070ULL,
0x0000002500007348ULL, 0x000fe80003800000ULL, 0x00000000ff217424ULL, 0x000fd000078e00ffULL,
0x0000000000207806ULL, 0x000fc800048e0100ULL, 0x0000002520257212ULL, 0x000fe200078ec0ffULL,
0x000000ffff207224ULL, 0x000fc800078e0024ULL, 0xfffde40020007950ULL, 0x000fea0003c3ffffULL,
0x0000001d00007348ULL, 0x000fe80003800000ULL, 0x00000000ff1d7424ULL, 0x000fc800078e00ffULL,
0xfffde3d01c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000480ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f64ULL, 0x0000000000000c40ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001ba8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001bb8ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c68ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001c6cULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e80ULL, 0x0000000000021d00ULL, 0x9d00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023b80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000023bd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000023f50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001c68ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000021f18ULL, 0x0000000000021f18ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000023b80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000023f50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_int8_pagedKV_128_nqpkv_1_m_1_sm_80_cubin_len = 147504;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
