/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_64_nqpkv_1_m_1_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000002ac40ULL, 0x000000000002a8c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4974613245453233ULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x45386a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL,
0x324545386a4c4536ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x746e695f5f240067ULL, 0x5f305f6c616e7265ULL, 0x5f616475635f5f24ULL,
0x7063725f30326d73ULL, 0x5f7a74665f6e725fULL, 0x776f6c735f323366ULL, 0x5f5f240068746170ULL,
0x6c616e7265746e69ULL, 0x75635f5f245f315fULL, 0x5f30376d735f6164ULL, 0x636e79736c666873ULL,
0x00705f796c66625fULL, 0x7265746e695f5f24ULL, 0x5f245f325f6c616eULL, 0x6d735f616475635fULL,
0x736c6668735f3037ULL, 0x5f7864695f636e79ULL, 0x746e695f5f240070ULL, 0x5f335f6c616e7265ULL,
0x5f616475635f5f24ULL, 0x746f765f30376d73ULL, 0x61625f636e797365ULL, 0x5f5f2400746f6c6cULL,
0x6c616e7265746e69ULL, 0x75635f5f245f345fULL, 0x5f30376d735f6164ULL, 0x636e797370726177ULL,
0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL,
0x5f6c656e72656b2eULL, 0x72656b240061686dULL, 0x2461686d5f6c656eULL, 0x657479426d656d73ULL,
0x2e766e2e00667542ULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x61705f0061686d5fULL,
0x6265642e006d6172ULL, 0x656d6172665f6775ULL, 0x65642e6c65722e00ULL, 0x6d6172665f677562ULL,
0x2e616c65722e0065ULL, 0x72665f6775626564ULL, 0x2e766e2e00656d61ULL, 0x697463612e6c6572ULL,
0x0000000000006e6fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c0001000000adULL, 0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c0001000001adULL, 0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000002ceULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL,
0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000363ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c0001000003a8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b0022000003eeULL, 0x0000000000028720ULL, 0x0000000000000190ULL, 0x000b002200000421ULL,
0x00000000000288b0ULL, 0x0000000000000040ULL, 0x000b00220000044cULL, 0x00000000000288f0ULL,
0x0000000000000040ULL, 0x000b002200000476ULL, 0x0000000000028930ULL, 0x0000000000000070ULL,
0x000b0022000004a1ULL, 0x00000000000289a0ULL, 0x00000000000000e0ULL, 0x000a000300000508ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000528ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000558ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000028a80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0002872000000000ULL, 0x0000040400000000ULL, 0x810c000001680400ULL, 0x00a0540400288080ULL,
0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL,
0x2880808808288080ULL, 0x8091082880808c08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL,
0x9a08288080980828ULL, 0x288080a408288080ULL, 0x80a708288080a608ULL, 0x08288080b4082880ULL,
0x8080ba08288080b8ULL, 0xec08288080bb0828ULL, 0x2880808708288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808087ULL, 0x00000044ffffffffULL, 0x0000007000000000ULL,
0x0002872000000000ULL, 0x0000019000000000ULL, 0x0000480400000000ULL, 0x8082288080830900ULL,
0x0900000010042880ULL, 0x2880808628808082ULL, 0x8087090000000404ULL, 0x0000288080822880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808c08288080ULL,
0x8091082880808e08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL, 0x9a08288080980828ULL,
0x288080a408288080ULL, 0x80a708288080a608ULL, 0x08288080b4082880ULL, 0x8080bb08288080b8ULL,
0x8608288080ec0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808086920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000016800000000ULL, 0x000288b000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000009cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080830828ULL, 0x2880808c08288080ULL, 0x8091082880808e08ULL, 0x0828808092082880ULL,
0x8080940828808093ULL, 0x9a08288080980828ULL, 0x288080a408288080ULL, 0x80a708288080a608ULL,
0x08288080b8082880ULL, 0x8080bb08288080baULL, 0xb408288080ec0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b4920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000023800000000ULL, 0x000288f000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808c08288080ULL,
0x8091082880808e08ULL, 0x0828808092082880ULL, 0x8080940828808093ULL, 0x9a08288080980828ULL,
0x288080a408288080ULL, 0x80a708288080a608ULL, 0x08288080b4082880ULL, 0x8080bb08288080baULL,
0xb808288080ec0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080b8920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000030800000000ULL, 0x0002893000000000ULL,
0x0000007000000000ULL, 0x0000180400000000ULL, 0x80b4288080b80900ULL, 0x0000000000002880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080830828ULL, 0x2880808708288080ULL,
0x808c082880808808ULL, 0x0828808091082880ULL, 0x8080930828808092ULL, 0x9808288080940828ULL,
0x2880809a08288080ULL, 0x80a708288080a608ULL, 0x08288080b4082880ULL, 0x8080ba08288080b8ULL,
0xec08288080bb0828ULL, 0x288080a408288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x00002200288080a4ULL, 0x0000001cffffffffULL, 0x000003e800000000ULL, 0x000289a000000000ULL,
0x000000e000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000efULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL,
0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001900082304ULL, 0x0008120400000000ULL,
0x0000000000000019ULL, 0x0000001900081104ULL, 0x0004370400000000ULL, 0x000035010000007bULL,
0x0000001600080a04ULL, 0x0068190300680160ULL, 0x00000000000c1704ULL, 0x0021f00000600007ULL,
0x00000000000c1704ULL, 0x0021f00000580006ULL, 0x00000000000c1704ULL, 0x0011f00000500005ULL,
0x00000000000c1704ULL, 0x0061f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x01ec290400000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01ec2804ffffffffULL, 0x00000100000000f0ULL, 0x00004580000004a0ULL,
0x0000471000004610ULL, 0x00004aa000004870ULL, 0x00004b4000004ad0ULL, 0x000070d000004bb0ULL,
0x00007160000070f0ULL, 0x00009ac0000071d0ULL, 0x00009c4000009b50ULL, 0x00009fb000009d90ULL,
0x0000a04000009fd0ULL, 0x0000c2b00000a0b0ULL, 0x0000c3400000c2d0ULL, 0x0000eae00000c3b0ULL,
0x0000ec600000eb70ULL, 0x0000efd00000edb0ULL, 0x0000f0600000eff0ULL, 0x000112d00000f0d0ULL,
0x00011360000112f0ULL, 0x00013b00000113d0ULL, 0x00013c8000013b90ULL, 0x00013ff000013dd0ULL,
0x0001408000014010ULL, 0x000162f0000140f0ULL, 0x0001638000016310ULL, 0x00016c20000163f0ULL,
0x000173e000016d60ULL, 0x00018d1000017400ULL, 0x000193c000018e30ULL, 0x00019a90000193f0ULL,
0x0001c2d000019ea0ULL, 0x0001c6800001c660ULL, 0x0001e9500001e930ULL, 0x0001f2c00001f2b0ULL,
0x00021a40000214b0ULL, 0x0002399000023230ULL, 0x0002669000025160ULL, 0x000266e0000266d0ULL,
0x00026700000266f0ULL, 0x0002678000026760ULL, 0x000273c0000267a0ULL, 0x000274a000027420ULL,
0x000275a000027520ULL, 0x000276a000027620ULL, 0x0002778000027720ULL, 0x00027850000277e0ULL,
0x00027950000278d0ULL, 0x00027a50000279d0ULL, 0x00027b3000027ad0ULL, 0x00027c0000027b90ULL,
0x00027d0000027c80ULL, 0x00027e0000027d80ULL, 0x00027ee000027e80ULL, 0x00027fb000027f40ULL,
0x000280b000028030ULL, 0x000281b000028130ULL, 0x000282a000028230ULL, 0x0002838000028310ULL,
0x0002848000028400ULL, 0x0002858000028500ULL, 0x0002868000028600ULL, 0x07b0390400028700ULL,
0x000000ff00000220ULL, 0x003f01000001cad0ULL, 0x0000001100000280ULL, 0x003f01200001cad8ULL,
0x00000011000002e0ULL, 0x003f01200001cb58ULL, 0x0000001100000450ULL, 0x003f01200001cb78ULL,
0x000000ff00000480ULL, 0x003f01000001cb88ULL, 0x000000ff00000520ULL, 0x003f01070001cad0ULL,
0x0000006f000007a0ULL, 0x003f01020001cb5cULL, 0x0000006f00000800ULL, 0x003f01010001cb58ULL,
0x000000ff00000960ULL, 0x003f01010001cb88ULL, 0x000000ff000009a0ULL, 0x003f01050001cb8cULL,
0x000000ff00000b60ULL, 0x003f01050001cb8cULL, 0x000000ff00001e20ULL, 0x003f01010001cb88ULL,
0x000000ff00001e50ULL, 0x003f01050001cb8cULL, 0x000000ff00002020ULL, 0x003f01050001cb8cULL,
0x000000ff00002190ULL, 0x003f01070001cb78ULL, 0x000000ff00002210ULL, 0x003f01010001cb78ULL,
0x000000ff00002270ULL, 0x003f01010001cb88ULL, 0x000000ff00002520ULL, 0x003f01050001cb7cULL,
0x000000ff000026e0ULL, 0x003f01050001cb7cULL, 0x000000ff00002740ULL, 0x003f01050001cb8cULL,
0x000000ff00002910ULL, 0x003f01050001cb8cULL, 0x000000ff00003bf0ULL, 0x003f01010001cb88ULL,
0x000000ff00003c20ULL, 0x003f01050001cb8cULL, 0x000000ff00003df0ULL, 0x003f01050001cb8cULL,
0x000000ff00004190ULL, 0x003f01070001cb80ULL, 0x000000ff00004220ULL, 0x003f01010001cb80ULL,
0x0000006f000042a0ULL, 0x003f01010001cad8ULL, 0x0000006f000042d0ULL, 0x003f01050001cadcULL,
0x0000006f000044a0ULL, 0x003f01050001cadcULL, 0x000000ff00005480ULL, 0x003f01010001cb88ULL,
0x000000ff00005560ULL, 0x003f01050001cb84ULL, 0x000000ff00005720ULL, 0x003f01050001cb84ULL,
0x000000ff00005780ULL, 0x003f01050001cb8cULL, 0x000000ff00005950ULL, 0x003f01050001cb8cULL,
0x000000ff00006c10ULL, 0x003f01010001cb88ULL, 0x000000ff00006c40ULL, 0x003f01050001cb8cULL,
0x000000ff00006e10ULL, 0x003f01050001cb8cULL, 0x000000ff00006ff0ULL, 0x003f01070001cb78ULL,
0x000000ff00007070ULL, 0x003f01010001cb78ULL, 0x000000ff000078c0ULL, 0x003f01010001cb88ULL,
0x000000ff00007990ULL, 0x003f01010001cb58ULL, 0x000000ff00007a80ULL, 0x003f01050001cb7cULL,
0x000000ff00007c40ULL, 0x003f01050001cb7cULL, 0x000000ff00007ca0ULL, 0x003f01050001cb8cULL,
0x000000ff00007e70ULL, 0x003f01050001cb8cULL, 0x000000ff00009150ULL, 0x003f01010001cb88ULL,
0x000000ff00009180ULL, 0x003f01050001cb8cULL, 0x000000ff00009350ULL, 0x003f01050001cb8cULL,
0x000000ff000096d0ULL, 0x003f01070001cb80ULL, 0x000000ff00009760ULL, 0x003f01010001cb80ULL,
0x0000006f000097e0ULL, 0x003f01010001caf8ULL, 0x0000006f00009810ULL, 0x003f01050001cafcULL,
0x0000006f000099e0ULL, 0x003f01050001cafcULL, 0x000000ff0000a650ULL, 0x003f01010001cb88ULL,
0x000000ff0000a740ULL, 0x003f01050001cb84ULL, 0x000000ff0000a900ULL, 0x003f01050001cb84ULL,
0x000000ff0000a960ULL, 0x003f01050001cb8cULL, 0x000000ff0000ab30ULL, 0x003f01050001cb8cULL,
0x000000ff0000bdf0ULL, 0x003f01010001cb88ULL, 0x000000ff0000be20ULL, 0x003f01050001cb8cULL,
0x000000ff0000bff0ULL, 0x003f01050001cb8cULL, 0x000000ff0000c1d0ULL, 0x003f01070001cb78ULL,
0x000000ff0000c250ULL, 0x003f01010001cb78ULL, 0x000000ff0000c900ULL, 0x003f01010001cb88ULL,
0x000000ff0000c9b0ULL, 0x003f01010001cb60ULL, 0x000000ff0000caa0ULL, 0x003f01050001cb7cULL,
0x000000ff0000cc60ULL, 0x003f01050001cb7cULL, 0x000000ff0000ccc0ULL, 0x003f01050001cb8cULL,
0x000000ff0000ce90ULL, 0x003f01050001cb8cULL, 0x000000ff0000e170ULL, 0x003f01010001cb88ULL,
0x000000ff0000e1a0ULL, 0x003f01050001cb8cULL, 0x000000ff0000e370ULL, 0x003f01050001cb8cULL,
0x000000ff0000e6f0ULL, 0x003f01070001cb80ULL, 0x000000ff0000e780ULL, 0x003f01010001cb80ULL,
0x0000006f0000e800ULL, 0x003f01010001cb18ULL, 0x0000006f0000e830ULL, 0x003f01050001cb1cULL,
0x0000006f0000ea00ULL, 0x003f01050001cb1cULL, 0x000000ff0000f670ULL, 0x003f01010001cb88ULL,
0x000000ff0000f760ULL, 0x003f01050001cb84ULL, 0x000000ff0000f920ULL, 0x003f01050001cb84ULL,
0x000000ff0000f980ULL, 0x003f01050001cb8cULL, 0x000000ff0000fb50ULL, 0x003f01050001cb8cULL,
0x000000ff00010e10ULL, 0x003f01010001cb88ULL, 0x000000ff00010e40ULL, 0x003f01050001cb8cULL,
0x000000ff00011010ULL, 0x003f01050001cb8cULL, 0x000000ff000111f0ULL, 0x003f01070001cb78ULL,
0x000000ff00011270ULL, 0x003f01010001cb78ULL, 0x000000ff00011920ULL, 0x003f01010001cb88ULL,
0x000000ff000119d0ULL, 0x003f01010001cb68ULL, 0x000000ff00011ac0ULL, 0x003f01050001cb7cULL,
0x000000ff00011c80ULL, 0x003f01050001cb7cULL, 0x000000ff00011ce0ULL, 0x003f01050001cb8cULL,
0x000000ff00011eb0ULL, 0x003f01050001cb8cULL, 0x000000ff00013190ULL, 0x003f01010001cb88ULL,
0x000000ff000131c0ULL, 0x003f01050001cb8cULL, 0x000000ff00013390ULL, 0x003f01050001cb8cULL,
0x000000ff00013710ULL, 0x003f01070001cb80ULL, 0x000000ff000137a0ULL, 0x003f01010001cb80ULL,
0x0000006f00013820ULL, 0x003f01010001cb38ULL, 0x0000006f00013850ULL, 0x003f01050001cb3cULL,
0x0000006f00013a20ULL, 0x003f01050001cb3cULL, 0x000000ff00014690ULL, 0x003f01010001cb88ULL,
0x000000ff00014780ULL, 0x003f01050001cb84ULL, 0x000000ff00014940ULL, 0x003f01050001cb84ULL,
0x000000ff000149a0ULL, 0x003f01050001cb8cULL, 0x000000ff00014b70ULL, 0x003f01050001cb8cULL,
0x000000ff00015e30ULL, 0x003f01010001cb88ULL, 0x000000ff00015e60ULL, 0x003f01050001cb8cULL,
0x000000ff00016030ULL, 0x003f01050001cb8cULL, 0x000000ff00016210ULL, 0x003f01070001cb78ULL,
0x000000ff00016290ULL, 0x003f01010001cb78ULL, 0x000000ff00016940ULL, 0x003f01010001cb88ULL,
0x000000ff000169e0ULL, 0x003f01010001cb70ULL, 0x000000ff00019d10ULL, 0x003f01010001cad0ULL,
0x000000ff0001c300ULL, 0x003f01050001cad4ULL, 0x000000ff0001c4d0ULL, 0x003f01050001cad4ULL,
0x00000085000258a0ULL, 0x003f010100000000ULL, 0x0000008500025bf0ULL, 0x003f010500000004ULL,
0x0000008500025dc0ULL, 0x003f010500000004ULL, 0x0000007600027210ULL, 0x003f01010001cad8ULL,
0x0000007600027270ULL, 0x003f01010001cae0ULL, 0x00000076000272d0ULL, 0x003f01010001cae8ULL,
0x0000007600027340ULL, 0x003f01010001caf0ULL, 0x00101c0400053803ULL, 0x0001c53000019bc0ULL,
0x000273800001c5d0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000004a4ULL,
0x0000001900000002ULL, 0x00000000000003c4ULL, 0x0000001900000002ULL, 0x00000000000002f4ULL,
0x0000001900000002ULL, 0x0000000000000224ULL, 0x0000001900000002ULL, 0x000000000000012cULL,
0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL, 0x000000000000047fULL,
0x0000001900000002ULL, 0x000000000000039aULL, 0x0000001900000002ULL, 0x00000000000002caULL,
0x0000001900000002ULL, 0x00000000000001faULL, 0x0000001900000002ULL, 0x0000000000000107ULL,
0x0000001900000002ULL, 0x000000000001cc00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000200ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001300057300ULL, 0x000ee200000e0000ULL, 0x0000000204047899ULL, 0x000fe2000800063fULL,
0x00000004ff157424ULL, 0x000fe200078e00ffULL, 0x0000000000037919ULL, 0x000f220000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000147919ULL, 0x000ee20000000000ULL,
0x0000001300137309ULL, 0x000ee60000000000ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000005ff757819ULL, 0x002fc60000011611ULL, 0x00001fff04027589ULL, 0x004fe800000e0000ULL,
0x00001fff75757589ULL, 0x000e6200000e0000ULL, 0x0000010004007a24ULL, 0x010fc600078e0203ULL,
0x0000000000037919ULL, 0x000ea20000002600ULL, 0x0000000000117a24ULL, 0x000fc600078e0211ULL,
0x0000000000007919ULL, 0x000ea20000002700ULL, 0x000000060500720cULL, 0x008fe40003f02070ULL,
0x000000ff1100720cULL, 0x040fe40003f25270ULL, 0x0000000f1100780cULL, 0x040fe40003f44070ULL,
0x000000031100780cULL, 0x040fe40003f64070ULL, 0x0000007f1100780cULL, 0x000fe20003f84070ULL,
0x0000000402047824ULL, 0x002fcc00078e0275ULL, 0x7fffff8000059802ULL, 0x000fe40000000f00ULL,
0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL, 0x00000002040b7824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x000000010b0a7824ULL, 0x040fe200078e0214ULL,
0x000000050b0d7819ULL, 0x040fe200000006ffULL, 0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL,
0x01cad004ff009388ULL, 0x0003e20000000a00ULL, 0x000000040b0c7817ULL, 0x000fe20007800000ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0xffffffe00d107812ULL, 0x000fe200078ee20aULL,
0x00000004000a7c24ULL, 0x004fe2000f8e0203ULL, 0x000000010b0d7810ULL, 0x000fe20007ffe0ffULL,
0x01cad8061100a388ULL, 0x0005e20000008a00ULL, 0x000000011100780cULL, 0x000fe20003f44070ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000010d057824ULL, 0x002fc400078e0214ULL, 0x000000200d127824ULL, 0x000fe200078e00ffULL,
0x01cb58081100b388ULL, 0x0003e20000008a00ULL, 0x000058000b047a24ULL, 0x100fe400078e020aULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0xffffffe012127812ULL, 0x000fe200078ee205ULL,
0x0000001014067824ULL, 0x004fe400078e00ffULL, 0x000058000d077a24ULL, 0x000fe200078e020aULL,
0x01c4000e1100c388ULL, 0x0005e20000004800ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0bULL,
0x000001f0060b7812ULL, 0x000fe200078ec0ffULL, 0x00005c0007067625ULL, 0x000fc600078e000fULL,
0x000000ff0c00720cULL, 0x000fe20003f63070ULL, 0x00005c0004047625ULL, 0x000fe200078e000fULL,
0x000000010c00780cULL, 0x000fe40003f83070ULL, 0x0000000b060a7210ULL, 0x080fe20007fde0ffULL,
0x7fffff00ff0da424ULL, 0x000fe200078e00ffULL, 0x0000000b04087210ULL, 0x002fe20007fbe0ffULL,
0x3fffff80ff0e9424ULL, 0x004fe200078e00ffULL, 0x3fffff00000ca802ULL, 0x000fe20000000f00ULL,
0x7fffff80ff0f9424ULL, 0x000fe200078e00ffULL, 0x0000000400777c02ULL, 0x008fe20008000f00ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0607ULL, 0x0000000410077819ULL, 0x000fe200000006ffULL,
0x000000ffff047224ULL, 0x000fe200078e0a13ULL, 0x01cb780c1100a388ULL, 0x000fe20000008a00ULL,
0x000000ffff097224ULL, 0x000fc400028e0605ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x01cb880eff009388ULL, 0x000fe20000000a00ULL, 0x0000000400737824ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x0000620073047625ULL, 0x000fc600078e0015ULL, 0x000000000a137faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01cad40cffff038cULL, 0x0005e20000000200ULL,
0x00006a0073067625ULL, 0x002fc600078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01cad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000604717981ULL, 0x000ee8000c1e1900ULL,
0x0000000606067981ULL, 0x000f22000c1e1900ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x0000003f71727810ULL, 0x048fe40007ffe0ffULL, 0x000000ff71707810ULL, 0x000fc40007ffe0ffULL,
0x00000008ff6e7819ULL, 0x010fe40000011606ULL, 0x00000006ff727819ULL, 0x000fe40000011672ULL,
0x00000008ff707819ULL, 0x000fc60000011670ULL, 0x0001959000008947ULL, 0x000fea0003800000ULL,
0x0000002075057824ULL, 0x040fe200078e0214ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x00000008756f7824ULL, 0x000fe400078e00ffULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000001f0500780cULL, 0x000fe20003f04070ULL, 0x00000004776d7824ULL, 0x000fe200078e00ffULL,
0x000000030500780cULL, 0x000fe20003f24070ULL, 0x0000010077047824ULL, 0x000fd400078e00ffULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000504067210ULL, 0x000fe20007ffe0ffULL,
0x0000680073027a24ULL, 0x000fe200078e0204ULL, 0x0001ca0005097811ULL, 0x040fe400078e10ffULL,
0x000000710600720cULL, 0x000fe20003f06070ULL, 0x0000000105027824ULL, 0x000fc800078e0202ULL,
0x0000660002067625ULL, 0x000fd000078e0015ULL, 0x0000000006097faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb5c086fff738cULL, 0x0007e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb58006fff7f8cULL, 0x0003e2000c80043fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400027824ULL, 0x000fe200078e0205ULL,
0x000064006d077a10ULL, 0x042fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000202027824ULL, 0x000fe200078e00ffULL, 0x0001cac005057811ULL, 0x000fc600078e10ffULL,
0x0000640002077a24ULL, 0x000fc800078e0207ULL, 0x0000600007067625ULL, 0x000fca00078e0015ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff067f8cULL, 0x002e62000c80043fULL, 0x000000ffff0a7224ULL, 0x004fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x002fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x008fcc0000015200ULL,
0x0000000806057210ULL, 0x000fc80007f1e1ffULL, 0x0000000907087210ULL, 0x000fe400007fe5ffULL,
0x003d09000500780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011408ULL, 0x0000000502027211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0608ULL, 0x0000000202027819ULL, 0x000fc80000001205ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000177057810ULL, 0x000fe20007ffe0ffULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000700500720cULL, 0x000fda0003f06070ULL, 0x0000099000008947ULL, 0x000fea0003800000ULL,
0x000000046f0a7824ULL, 0x000fe200078e00ffULL, 0x0000000000107919ULL, 0x000e620000000000ULL,
0x0000000471057217ULL, 0x000fe20007800000ULL, 0x000000206f0c7824ULL, 0x040fe200078e00ffULL,
0x00000200000f7802ULL, 0x000fe20000000f00ULL, 0x01ca00000a027984ULL, 0x000ea20000000800ULL,
0x0000001010087824ULL, 0x00afe400078e00ffULL, 0x000000016f097824ULL, 0x000fc600078e0210ULL,
0x000001f008117812ULL, 0x000fe200078ec0ffULL, 0x0000000402077824ULL, 0x004fe400078e00ffULL,
0x0000000105027824ULL, 0x000fe400078e0a04ULL, 0x0000004003057824ULL, 0x000fe200078e026fULL,
0x01cac00007067984ULL, 0x000e640000000800ULL, 0x000000026f027217ULL, 0x000fca0007800000ULL,
0x0000000102027824ULL, 0x000fca00078e0a6fULL, 0x000000ff0200720cULL, 0x000fe20003f03070ULL,
0x0000000406067c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x0000001106087210ULL, 0x000fe40007f3e0ffULL, 0xffffffe00c067812ULL, 0x000fe400078ee209ULL,
0x000000016f0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x00014000060b7811ULL, 0x000fe400078e20ffULL, 0x0000000105077810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x040fe400078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c46ULL, 0x000000200c0c7824ULL, 0x000fe200078e00ffULL,
0x000000010200780cULL, 0x000fc40003f03070ULL, 0x01ca04000a067984ULL, 0x000ea40000000800ULL,
0xffffffe00c0d7812ULL, 0x000fc800078ee20dULL, 0x000140000d0d7811ULL, 0x000fe400078e20ffULL,
0x000000026f0b7810ULL, 0x002fca0007ffe0ffULL, 0x000000010b0c7824ULL, 0x040fe200078e0210ULL,
0x000000050b0b7819ULL, 0x000fc800000006ffULL, 0xffffffe00b0c7812ULL, 0x000fc800078ee20cULL,
0x000140000c0b7811ULL, 0x000fe400078e20ffULL, 0x000000036f0c7810ULL, 0x000fe40007ffe0ffULL,
0x00000002060e7819ULL, 0x004fca00000006ffULL, 0x01cac0000e067984ULL, 0x000e640000000800ULL,
0x0000000406067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x0000001106087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x0000000205077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000020200780cULL, 0x000fc60003f03070ULL,
0x01ca08000a067984ULL, 0x000ea20000000800ULL, 0x000000010c0d7824ULL, 0x042fe400078e0210ULL,
0x000000200c0c7824ULL, 0x000fca00078e00ffULL, 0xffffffe00c0d7812ULL, 0x000fc800078ee20dULL,
0x000140000d0d7811ULL, 0x000fe200078e20ffULL, 0x00000004060e7824ULL, 0x004fca00078e00ffULL,
0x01cac0000e067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000305077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000030200780cULL, 0x000fc60003f03070ULL, 0x01ca0c000a067984ULL, 0x000ea20000000800ULL,
0x000000046f0b7810ULL, 0x002fca0007ffe0ffULL, 0x000000010b0c7824ULL, 0x040fe400078e0210ULL,
0x000000200b0b7824ULL, 0x000fca00078e00ffULL, 0xffffffe00b0c7812ULL, 0x000fc800078ee20cULL,
0x000140000c0b7811ULL, 0x000fe400078e20ffULL, 0x000000056f0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000004060e7824ULL, 0x004fca00078e00ffULL, 0x01cac0000e067984ULL, 0x000e640000000800ULL,
0x0000000406067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x0000001106087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x0000000405077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c46ULL, 0x000000040200780cULL, 0x000fc60003f03070ULL,
0x01ca10000a067984ULL, 0x000ea20000000800ULL, 0x000000010c0d7824ULL, 0x042fe200078e0210ULL,
0x000000050c0c7819ULL, 0x000fc800000006ffULL, 0xffffffe00c0d7812ULL, 0x000fc800078ee20dULL,
0x000140000d0d7811ULL, 0x000fe400078e20ffULL, 0x00000002060e7819ULL, 0x004fca00000006ffULL,
0x01cac0000e067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000505077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000050200780cULL, 0x000fc60003f03070ULL, 0x01ca14000a067984ULL, 0x000ea20000000800ULL,
0x000000066f0b7810ULL, 0x002fca0007ffe0ffULL, 0x000000010b0c7824ULL, 0x040fe400078e0210ULL,
0x000000200b0b7824ULL, 0x000fca00078e00ffULL, 0xffffffe00b0c7812ULL, 0x000fc800078ee20cULL,
0x000140000c0b7811ULL, 0x000fe200078e20ffULL, 0x00000004060e7824ULL, 0x004fca00078e00ffULL,
0x01cac0000e067984ULL, 0x000e640000000800ULL, 0x0000000406067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e000fULL, 0x0000001106087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000605077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080d7faeULL, 0x0003e2000c101c46ULL,
0x000000060200780cULL, 0x000fc60003f03070ULL, 0x01ca18000a067984ULL, 0x000ea40000000800ULL,
0x00000004060e7824ULL, 0x004fca00078e00ffULL, 0x01cac0000e067984ULL, 0x000ea40000000800ULL,
0x0000000406067c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x0000001106087210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0607ULL,
0x0000000705077810ULL, 0x000fe40007ffe0ffULL, 0x000000076f057810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e2000c101c46ULL,
0x000000070200780cULL, 0x000fe40003f03070ULL, 0x00000001050c7824ULL, 0x040fe200078e0210ULL,
0x01ca1c000a0a7984ULL, 0x000ea20000000800ULL, 0x0000002005057824ULL, 0x000fca00078e00ffULL,
0xffffffe0050c7812ULL, 0x000fc800078ee20cULL, 0x000140000c057811ULL, 0x000fe400078e20ffULL,
0x000000020a0d7819ULL, 0x004fca00000006ffULL, 0x01cac0000d067984ULL, 0x000ea40000000800ULL,
0x0000000406067c24ULL, 0x004fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e000fULL,
0x0000001106067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x00000200ff117424ULL, 0x000fe200078e00ffULL, 0x0000006f0f027211ULL, 0x042fe400078fd8ffULL,
0x000000040f077819ULL, 0x000fc600000006ffULL, 0x01ca000002057984ULL, 0x000e620000004800ULL,
0x00000040030c7824ULL, 0x000fe200078e0202ULL, 0x000001f007137812ULL, 0x000fe200078ec0ffULL,
0x0000000102097824ULL, 0x040fe400078e020fULL, 0x00000020020a7824ULL, 0x000fe200078e00ffULL,
0x01cac00005057984ULL, 0x002e640000004800ULL, 0x0000000405067c24ULL, 0x002fc8000f8e020cULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x0000001306087210ULL, 0x008fe40007f1e0ffULL,
0xffffffe00a067812ULL, 0x000fe400078ee209ULL, 0x00000001020a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000010c067810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x040fe400078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x000000200a0e7824ULL, 0x000fc600078e00ffULL, 0x01ca0400020d7984ULL, 0x000ea20000004800ULL,
0x0000000202087810ULL, 0x002fca0007ffe0ffULL, 0x0000000108097824ULL, 0x000fe200078e020fULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e067812ULL, 0x000fe200078ee20bULL, 0x00000020080e7824ULL, 0x000fe200078e00ffULL,
0x00000007ff0b7210ULL, 0x000fe400007fe4ffULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000020c067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e8000b901c46ULL, 0x01ca0800020d7984ULL, 0x000ea20000004800ULL,
0x00000003020a7810ULL, 0x002fca0007ffe0ffULL, 0x000000010a0b7824ULL, 0x000fe200078e020fULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x0000001306087210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e067812ULL, 0x000fe200078ee209ULL, 0x000000200a0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000030c067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x01ca0c00020d7984ULL, 0x000ea20000004800ULL,
0x0000000402087810ULL, 0x002fca0007ffe0ffULL, 0x0000000108097824ULL, 0x000fe200078e020fULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e067812ULL, 0x000fe200078ee20bULL, 0x00000020080e7824ULL, 0x000fe200078e00ffULL,
0x00000007ff0b7210ULL, 0x000fe400007fe4ffULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000040c067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a057faeULL, 0x0003e8000b901c46ULL, 0x01ca1000020d7984ULL, 0x000ea20000004800ULL,
0x00000005020a7810ULL, 0x002fca0007ffe0ffULL, 0x000000010a0b7824ULL, 0x000fe200078e020fULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x0000001306087210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e067812ULL, 0x000fe200078ee209ULL, 0x000000200a0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000050c067810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x01ca1400020d7984ULL, 0x000ea20000004800ULL,
0x0000000602087810ULL, 0x002fca0007ffe0ffULL, 0x0000000108097824ULL, 0x000fe200078e020fULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fc8000f8e0206ULL,
0x00005e0006067625ULL, 0x000fca00078e0011ULL, 0x00000013060a7210ULL, 0x000fe40007f1e0ffULL,
0xffffffe00e067812ULL, 0x000fe200078ee20bULL, 0x00000020080e7824ULL, 0x000fe200078e00ffULL,
0x00000007ff0b7210ULL, 0x000fe400007fe4ffULL, 0x0001400006057811ULL, 0x000fe400078e20ffULL,
0x000000060c067810ULL, 0x040fe40007ffe0ffULL, 0x000000070c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a057faeULL, 0x0003e8000b901c46ULL,
0x01ca1800020d7984ULL, 0x000ea20000004800ULL, 0x00000007020a7810ULL, 0x002fc60007ffe0ffULL,
0x01cac0000d0d7984ULL, 0x004e640000004800ULL, 0x000000040d067c24ULL, 0x002fe4000f8e0206ULL,
0x000000200a0d7824ULL, 0x000fe400078e00ffULL, 0x00005e0006067625ULL, 0x000fca00078e0011ULL,
0x0000001306087210ULL, 0x000fe40007f1e0ffULL, 0xffffffe00e067812ULL, 0x000fc600078ee209ULL,
0x000000ffff097224ULL, 0x000fe200000e0607ULL, 0x0001400006057811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e8000b901c46ULL,
0x01ca1c00020b7984ULL, 0x000ea80000004800ULL, 0x01cac0000b0b7984ULL, 0x004ea40000004800ULL,
0x000000040b067c24ULL, 0x004fc4000f8e020cULL, 0x000000010a0c7824ULL, 0x000fe400078e020fULL,
0x00005e0006067625ULL, 0x000fc600078e0011ULL, 0xffffffe00d0c7812ULL, 0x000fe400078ee20cULL,
0x0000001306067210ULL, 0x000fe40007f1e0ffULL, 0x000140000c057811ULL, 0x002fe400078e20ffULL,
0x00000007ff077210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e8000b901c46ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff067f8cULL, 0x002e64000c80043fULL, 0x000000ffff0b7224ULL, 0x002fc400078e0007ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x01cb8c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806057210ULL, 0x000fca0007f1e1ffULL, 0x0000000109087824ULL, 0x000fe200000e0e07ULL,
0x003d09000500780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400500780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011408ULL, 0x0000000502027211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0608ULL, 0x0000000202027819ULL, 0x000fc80000001205ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01cb8c00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002075057824ULL, 0x002fca00078e0202ULL,
0x0000001f0500780cULL, 0x000fda0003f04070ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0000002004047810ULL, 0x000fe20007ffe0ffULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0x0001ca0005097811ULL, 0x040fe400078e10ffULL, 0x0000000405067210ULL, 0x000fe20007ffe0ffULL,
0x0000680073047a24ULL, 0x000fc600078e0204ULL, 0x000000710600720cULL, 0x000fe20003f06070ULL,
0x0000000105047824ULL, 0x000fc800078e0204ULL, 0x0000660004047625ULL, 0x000fd000078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004097faeULL, 0x0003e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7800ff047f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff067f8cULL, 0x000ea2000c80043fULL,
0x000000707700720cULL, 0x000fe20003f06070ULL, 0x000000ffff857224ULL, 0x002fe200078e0005ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0xff317217ff6c7424ULL, 0x000fe200078e00ffULL,
0x000000ff00317202ULL, 0x000fe20000000f00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x000000ffff377224ULL, 0x004fc400078e0007ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0001466000000947ULL, 0x000fea0003800000ULL,
0x00005800ff227624ULL, 0x000fe200078e00ffULL, 0x0001464000007945ULL, 0x000fe20003800000ULL,
0x000000ffff337224ULL, 0x000fe400078e00ffULL, 0xff317217ff6c7424ULL, 0x000fe400078e00ffULL,
0x0000004022227824ULL, 0x000fc400078e00ffULL, 0x0000010077287824ULL, 0x000fca00078e00ffULL,
0x000000712800720cULL, 0x000fda0003f06070ULL, 0x0001459000000947ULL, 0x000fea0003800000ULL,
0x000000ff00877202ULL, 0x000fc40000000f00ULL, 0x000000776e00720cULL, 0x000fe20003fa4070ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000002ff287819ULL, 0x000fe20000011687ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000387237812ULL, 0x040fe400078ec0ffULL,
0x0000002887287207ULL, 0x000fe40002800000ULL, 0x000000ff23237207ULL, 0x000fe40006800000ULL,
0x00000002ff2a7819ULL, 0x000fc40000011628ULL, 0x0000000328287812ULL, 0x000fc600078ec0ffULL,
0x000003002a297a24ULL, 0x000fc400078e0277ULL, 0x00000000002a7805ULL, 0x000fca0000015200ULL,
0x01cb7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002c7805ULL, 0x000fcc0000015200ULL,
0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012d2d7824ULL, 0x000fe200000e0e2bULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2c7819ULL, 0x000fc8000001142dULL, 0x0000002f2c2c7211ULL, 0x000fca00078110ffULL,
0x000000ffff2d7224ULL, 0x000fca00000e062dULL, 0x000000022c2c7819ULL, 0x000fc8000000122dULL,
0x0000002c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb7c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001142dULL,
0x0000002f2c2c7211ULL, 0x000fc800078110ffULL, 0x0000002dff2d7210ULL, 0x000fc800007fe4ffULL,
0x000000022c2c7819ULL, 0x000fc8000000122dULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001292b7810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000702b00720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x000000046f357824ULL, 0x000fe200078e00ffULL, 0x0000002003307811ULL, 0x000fe200078e30ffULL,
0x000000206f347824ULL, 0x040fe200078e00ffULL, 0x0000020000377802ULL, 0x000fe40000000f00ULL,
0x01ca0000352a7984ULL, 0x000e620000000800ULL, 0x000000016f2c7824ULL, 0x040fe200078e0230ULL,
0x000000016f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b367824ULL, 0x000fe400078e0202ULL,
0x000000042a2d7824ULL, 0x002fe400078e00ffULL, 0x00000004292a7824ULL, 0x000fc800078e0228ULL,
0x01cac0002d2d7984ULL, 0x000e620000000800ULL, 0x000000202a2a7811ULL, 0x000fc800078e30ffULL,
0x0000002a712b7217ULL, 0x000fca0007800000ULL, 0x000000012b2a7824ULL, 0x000fca00078e0a2aULL,
0x0000002a6f2a7217ULL, 0x000fca0007800000ULL, 0x000000012a2e7824ULL, 0x000fca00078e0a6fULL,
0x000000ff2e00720cULL, 0x000fe20003f03070ULL, 0x0000002d222b7224ULL, 0x002fe400078e022cULL,
0x00000010022c7824ULL, 0x000fe400078e00ffULL, 0x00005e002b2a7625ULL, 0x000fc600078e0037ULL,
0x000001f02c397812ULL, 0x000fe200078ec0ffULL, 0x000000016f2d7824ULL, 0x000fc600078e0202ULL,
0x000000392a2c7210ULL, 0x000fe40007f3e0ffULL, 0xffffffe0342f7812ULL, 0x000fc600078ee22dULL,
0x000000ffff2d7224ULL, 0x000fe200008e062bULL, 0x000180002f2f7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000012e00780cULL, 0x000fc60003f03070ULL, 0x01ca0400352a7984ULL, 0x000ea40000000800ULL,
0x000000022a347819ULL, 0x004fe200000006ffULL, 0x000000013b2a7824ULL, 0x040fe400078e0230ULL,
0x000000203b3b7824ULL, 0x000fe400078e00ffULL, 0x01cac000342b7984ULL, 0x000ea60000000800ULL,
0xffffffe03b2f7812ULL, 0x002fc400078ee236ULL, 0x000000026f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000013b367824ULL, 0x000fe400078e0202ULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000022e00780cULL, 0x000fc60003f03070ULL, 0x01ca0800352a7984ULL, 0x000ea40000000800ULL,
0x000000042a347824ULL, 0x004fe200078e00ffULL, 0x000000303b2a7210ULL, 0x040fe20007ffe0ffULL,
0x000000203b3b7824ULL, 0x000fc600078e00ffULL, 0x01cac000342b7984ULL, 0x000ea40000000800ULL,
0xffffffe03b2f7812ULL, 0x002fe400078ee236ULL, 0x000000036f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fe400078e20ffULL, 0x000000023b367210ULL, 0x000fe20007ffe0ffULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000032e00780cULL, 0x000fc60003f03070ULL, 0x01ca0c00352a7984ULL, 0x000ea40000000800ULL,
0x000000042a347824ULL, 0x004fe400078e00ffULL, 0x000000013b2a7824ULL, 0x040fe400078e0230ULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000342b7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2f7812ULL, 0x002fc400078ee236ULL, 0x000000046f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000013b367824ULL, 0x000fe400078e0202ULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000042e00780cULL, 0x000fc60003f03070ULL, 0x01ca1000352a7984ULL, 0x000ea40000000800ULL,
0x000000042a347824ULL, 0x004fe400078e00ffULL, 0x000000013b2a7824ULL, 0x040fe200078e0230ULL,
0x000000053b3b7819ULL, 0x000fe400000006ffULL, 0x01cac000342b7984ULL, 0x000ea40000000800ULL,
0xffffffe03b2f7812ULL, 0x002fe400078ee236ULL, 0x000000056f3b7810ULL, 0x000fc40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000013b367824ULL, 0x000fe400078e0202ULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000052e00780cULL, 0x000fc60003f03070ULL, 0x01ca1400352a7984ULL, 0x000ea40000000800ULL,
0x000000042a347824ULL, 0x004fe400078e00ffULL, 0x000000013b2a7824ULL, 0x040fe400078e0230ULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000342b7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2f7812ULL, 0x002fc400078ee236ULL, 0x000000066f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000013b367824ULL, 0x000fe400078e0202ULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fc80007f3e0ffULL, 0x0000002bff2d7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000062e00780cULL, 0x000fc60003f03070ULL, 0x01ca1800352a7984ULL, 0x000ea40000000800ULL,
0x000000042a347824ULL, 0x004fe400078e00ffULL, 0x000000013b2a7824ULL, 0x040fe400078e0230ULL,
0x000000203b3b7824ULL, 0x000fe200078e00ffULL, 0x01cac000342b7984ULL, 0x000ea80000000800ULL,
0xffffffe03b2f7812ULL, 0x002fc400078ee236ULL, 0x000000076f3b7810ULL, 0x000fe40007ffe0ffULL,
0x000180002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000013b307824ULL, 0x000fe400078e0230ULL,
0x0000002b222a7224ULL, 0x004fc800078e022aULL, 0x00005e002a2a7625ULL, 0x000fca00078e0037ULL,
0x000000392a2c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2d7224ULL, 0x000fca00008e062bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c101c46ULL,
0x000000072e00780cULL, 0x000fc60003f03070ULL, 0x01ca1c00352a7984ULL, 0x000ea40000000800ULL,
0x000000022a347819ULL, 0x004fca00000006ffULL, 0x01cac000342b7984ULL, 0x000ea40000000800ULL,
0x0000002b222b7224ULL, 0x004fe400078e0230ULL, 0x000000013b307824ULL, 0x000fe400078e0202ULL,
0x00005e002b2a7625ULL, 0x000fc800078e0037ULL, 0x000000203b3b7824ULL, 0x000fe200078e00ffULL,
0x000000392a2a7210ULL, 0x000fc80007f3e0ffULL, 0xffffffe03b2d7812ULL, 0x002fe200078ee230ULL,
0x000000ffff2b7224ULL, 0x000fc600008e062bULL, 0x000180002d2d7811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a2d7faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x0000006f02377211ULL, 0x040fe200078fd8ffULL,
0x00000200ff397424ULL, 0x000fe200078e00ffULL, 0x0000002003347811ULL, 0x000fe400078e30ffULL,
0x00000004022c7819ULL, 0x000fe200000006ffULL, 0x01ca0000372e7984ULL, 0x000e620000004800ULL,
0x00000001372d7824ULL, 0x040fe200078e0202ULL, 0x00000001372f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001372a7824ULL, 0x040fe200078e0234ULL, 0x000001f02c3b7812ULL, 0x000fe200078ec0ffULL,
0x0000002037307824ULL, 0x000fe200078e00ffULL, 0x000000022f367210ULL, 0x000fc80007ffe0ffULL,
0xffffffe030357812ULL, 0x000fc800078ee22dULL, 0x0001800035357811ULL, 0x000fe200078e20ffULL,
0x01cac0002e2b7984ULL, 0x002e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012f2a7824ULL, 0x040fe400078e0234ULL, 0x000000202f2f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fc600000e062bULL, 0xffffffe02f367812ULL, 0x000fe400078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c357faeULL, 0x0003e8000b901c46ULL,
0x01ca040037307984ULL, 0x000ea20000004800ULL, 0x0001800036357811ULL, 0x002fe400078e20ffULL,
0x00000002372d7810ULL, 0x000fca0007ffe0ffULL, 0x000000012d367824ULL, 0x000fe200078e0202ULL,
0x01cac000302b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d2a7824ULL, 0x040fe400078e0234ULL, 0x000000202d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fc600000e062bULL, 0xffffffe02d367812ULL, 0x000fe400078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e357faeULL, 0x0003e8000b901c46ULL,
0x01ca080037307984ULL, 0x000ea20000004800ULL, 0x0001800036357811ULL, 0x002fe400078e20ffULL,
0x00000003372f7810ULL, 0x000fca0007ffe0ffULL, 0x000000012f367824ULL, 0x000fe200078e0202ULL,
0x01cac000302b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012f2a7824ULL, 0x040fe400078e0234ULL, 0x000000202f2f7824ULL, 0x000fe200078e00ffULL,
0x0000002bff2d7210ULL, 0x000fc800007fe4ffULL, 0xffffffe02f367812ULL, 0x000fe200078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c357faeULL, 0x0003e8000b901c46ULL,
0x01ca0c0037307984ULL, 0x000ea20000004800ULL, 0x0001800036357811ULL, 0x002fe400078e20ffULL,
0x00000004372d7810ULL, 0x000fc80007ffe0ffULL, 0x000000022d367210ULL, 0x000fe20007ffe0ffULL,
0x01cac000302b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d2a7824ULL, 0x040fe400078e0234ULL, 0x000000202d2d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fc600000e062bULL, 0xffffffe02d367812ULL, 0x000fe400078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e357faeULL, 0x0003e8000b901c46ULL,
0x01ca100037307984ULL, 0x000ea20000004800ULL, 0x0001800036357811ULL, 0x002fe400078e20ffULL,
0x00000005372f7810ULL, 0x000fca0007ffe0ffULL, 0x000000012f367824ULL, 0x000fe200078e0202ULL,
0x01cac000302b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000012f2a7824ULL, 0x040fe400078e0234ULL, 0x000000202f2f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fc600000e062bULL, 0xffffffe02f367812ULL, 0x000fe400078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c357faeULL, 0x0003e8000b901c46ULL,
0x01ca140037307984ULL, 0x000ea20000004800ULL, 0x0001800036357811ULL, 0x002fe400078e20ffULL,
0x00000006372d7810ULL, 0x000fca0007ffe0ffULL, 0x000000012d367824ULL, 0x000fe200078e0202ULL,
0x01cac000302b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000012d2a7824ULL, 0x040fe400078e0234ULL, 0x000000202d2d7824ULL, 0x000fe200078e00ffULL,
0x0000002bff2f7210ULL, 0x000fc800007fe4ffULL, 0xffffffe02d367812ULL, 0x000fe200078ee236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e357faeULL, 0x0003e8000b901c46ULL,
0x01ca180037307984ULL, 0x000ea20000004800ULL, 0x00018000362f7811ULL, 0x002fe400078e20ffULL,
0x0000000737357810ULL, 0x000fe20007ffe0ffULL, 0x01cac000302b7984ULL, 0x0042a60000004800ULL,
0x0000000235307210ULL, 0x002fe20007ffe0ffULL, 0x0000002b222a7224ULL, 0x004fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001352a7824ULL, 0x040fe400078e0234ULL, 0x0000002035357824ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fc600000e062bULL, 0xffffffe035307812ULL, 0x000fe400078ee230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c00372e7984ULL, 0x000ea20000004800ULL, 0x00018000302d7811ULL, 0x002fc600078e20ffULL,
0x01cac0002e2b7984ULL, 0x004e640000004800ULL, 0x0000002b222a7224ULL, 0x002fc800078e022aULL,
0x00005e002a2a7625ULL, 0x000fca00078e0039ULL, 0x0000003b2a2a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a2d7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff2a7f8cULL, 0x002e64000c80043fULL,
0x000000ffff357224ULL, 0x002fc400078e002bULL, 0x00000000002a7805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff2c7984ULL, 0x000e640000000800ULL, 0x800000002cff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002c7805ULL, 0x000fcc0000015200ULL, 0x0000002c2a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012d2d7824ULL, 0x000fe200000e0e2bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2c7819ULL, 0x000fc8000001142dULL,
0x0000002f2c2c7211ULL, 0x000fc800078110ffULL, 0x0000002dff2d7210ULL, 0x000fc800007fe4ffULL,
0x000000022c2c7819ULL, 0x000fc8000000122dULL, 0x0000002c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff2c7984ULL, 0x000e640000000800ULL,
0x800000002cff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000296e00720cULL, 0x0c0fe20003f04070ULL, 0x00000004ff2e7424ULL, 0x000fe200078e00ffULL,
0x00000001232b7810ULL, 0x040fe20007ffe0ffULL, 0x00000300ff2d7624ULL, 0x000fe200078e00ffULL,
0x000000032300780cULL, 0x000fe20003f45270ULL, 0x0000002075237824ULL, 0x000fe200078e0202ULL,
0x000000032b2a7812ULL, 0x000fe200078ec0ffULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000000296e00720cULL, 0x000fc40003f24070ULL, 0x0000001f2300780cULL, 0x000fc60003f84070ULL,
0x00000002ff2b8819ULL, 0x000fca000001162bULL, 0x0000000128287824ULL, 0x000fca00078e022bULL,
0x00000002ff2c7819ULL, 0x000fe20000011628ULL, 0x0000004028287824ULL, 0x000fc800078e00ffULL,
0x000003002c2c7a24ULL, 0x000fe200078e0229ULL, 0x000000c0282b7812ULL, 0x000fe200078ec0ffULL,
0xfffffffd2e287424ULL, 0x000fe200078e022dULL, 0x0000012000009947ULL, 0x000fea0001000000ULL,
0x0000000275297211ULL, 0x000fe400078e28ffULL, 0x000000036d2d7812ULL, 0x000fe400078ec0ffULL,
0x000000032900780cULL, 0x000fe40003f44070ULL, 0x000000032d00780cULL, 0x000fc80003f25270ULL,
0x0000000128287807ULL, 0x000fca0004800000ULL, 0x000000016d6d7824ULL, 0x000fe400078e0228ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000400287824ULL, 0x000fe200078e0229ULL,
0x000064006d2d7a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f26070ULL,
0x0000000228287824ULL, 0x000fe200078e00ffULL, 0x0001cac0292f7811ULL, 0x000fc600078e10ffULL,
0x00006400282d7a24ULL, 0x000fc800078e022dULL, 0x000060002d287625ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282f7faeULL, 0x0003e4000c921846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000f000017945ULL, 0x000fe20003800000ULL,
0x000001002c2b7824ULL, 0x000fe200078e022bULL, 0x000000ff2a287207ULL, 0x002fe20004000000ULL,
0x000000b000004947ULL, 0x000fea0003800000ULL, 0x0000000173287824ULL, 0x000fe200078e0228ULL,
0x0000002b232a7210ULL, 0x000fc60007ffe0ffULL, 0x0000680028287a24ULL, 0x000fe200078e022bULL,
0x000000712a00720cULL, 0x000fe40003f06070ULL, 0x0001ca00232b7811ULL, 0x040fe200078e10ffULL,
0x0000000123287824ULL, 0x000fc800078e0228ULL, 0x0000660028287625ULL, 0x000fcc00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007f000017945ULL, 0x000ff60003800000ULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cad8006f287f8cULL, 0x000ea4000c80043fULL, 0x000000ffff2f7224ULL, 0x004fc400078e0029ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x01cadc006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780482fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282d7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc8000001142bULL, 0x0000002d24247211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x0000000224247819ULL, 0x000fc8000000122bULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012c2c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cadc006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000402247819ULL, 0x000fe400000006ffULL,
0x00000001ff287819ULL, 0x000fe40000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c28297812ULL, 0x000fca00078ec0ffULL, 0x0000000124297824ULL, 0x000fca00078e0229ULL,
0x01c00000292b7984ULL, 0x000ea80000000800ULL, 0x01c2000029287984ULL, 0x0006620000000800ULL,
0x0000006c2b00720bULL, 0x004fe20003f1d000ULL, 0x00022e127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff242f7812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff2a7224ULL, 0x000fd200078e006cULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x000000ff7500720cULL, 0x000fe40003f05270ULL, 0x0000006c2b00720bULL, 0x000fe20003f34000ULL,
0x00022de27f007947ULL, 0x000fd8000b800000ULL, 0x00000000002c7806ULL, 0x000fc400008e0100ULL,
0x0000002b6c2a7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099102c2d7816ULL, 0x000fc600000000ffULL, 0x01c4002a29008388ULL, 0x0005e20000000800ULL,
0x000000ff2d00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000002a6c297221ULL, 0x004fe20000010000ULL, 0x000000ff2cff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b29297820ULL, 0x000fc80000410000ULL,
0x00000029002e7308ULL, 0x000ea40000000800ULL, 0x0000002e21217220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011602ULL,
0x00022d427f007947ULL, 0x000fea000b800000ULL, 0x00001f292e297589ULL, 0x0004e400000e0000ULL,
0x0000002920207220ULL, 0x088fe40000410000ULL, 0x000000291f1f7220ULL, 0x080fe40000410000ULL,
0x000000291c1c7220ULL, 0x080fe40000410000ULL, 0x000000291b1b7220ULL, 0x080fe40000410000ULL,
0x0000002918187220ULL, 0x080fe40000410000ULL, 0x0000002917177220ULL, 0x000fc40000410000ULL,
0x0000002914147220ULL, 0x080fe40000410000ULL, 0x0000002913137220ULL, 0x080fe40000410000ULL,
0x0000002910107220ULL, 0x080fe40000410000ULL, 0x000000290f0f7220ULL, 0x080fe40000410000ULL,
0x000000290c0c7220ULL, 0x080fe40000410000ULL, 0x000000290b0b7220ULL, 0x000fc40000410000ULL,
0x0000002908087220ULL, 0x080fe40000410000ULL, 0x0000002907077220ULL, 0x080fe40000410000ULL,
0x0000002904047220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff002cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802297811ULL, 0x000fe200078ff0ffULL,
0x00022c627f007947ULL, 0x000fea000b800000ULL, 0x00001f292e297589ULL, 0x0006a400000e0000ULL,
0x000000291e1e7220ULL, 0x084fe40000410000ULL, 0x000000291d1d7220ULL, 0x080fe40000410000ULL,
0x000000291a1a7220ULL, 0x080fe40000410000ULL, 0x0000002919197220ULL, 0x080fe40000410000ULL,
0x0000002916167220ULL, 0x080fe40000410000ULL, 0x0000002915157220ULL, 0x000fc40000410000ULL,
0x0000002912127220ULL, 0x080fe40000410000ULL, 0x0000002911117220ULL, 0x080fe40000410000ULL,
0x000000290e0e7220ULL, 0x080fe40000410000ULL, 0x000000290d0d7220ULL, 0x080fe40000410000ULL,
0x000000290a0a7220ULL, 0x080fe40000410000ULL, 0x0000002909097220ULL, 0x000fc40000410000ULL,
0x0000002906067220ULL, 0x080fe40000410000ULL, 0x0000002905057220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff2fff7812ULL, 0x000fda000780602cULL,
0x8000002a2b2b0221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b2b2b0820ULL, 0x000fc80000410000ULL, 0x0000002b00250308ULL, 0x000ea40000000800ULL,
0x0000002528280220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002128217221ULL, 0x002fe20000010000ULL, 0x0000002a006c7202ULL, 0x000fc40000000f00ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000017945ULL, 0x000fd80003800000ULL, 0x0000016000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fe400000000ffULL, 0x00000002ff297819ULL, 0x000fe40000011602ULL,
0x0000541026287816ULL, 0x000fe20000000026ULL, 0x00022ab27f007947ULL, 0x000fea000b800000ULL,
0x00001f2928267589ULL, 0x0004e400000e0000ULL, 0x0000000829277810ULL, 0x000fe20007ffe0ffULL,
0x00022b027f007947ULL, 0x000fea000b800000ULL, 0x00001f2728277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010293b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0028ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x00004b5000347802ULL, 0x000fc40000000f00ULL,
0x00023da000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018293b7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff3a7224ULL, 0x004fe200078e0028ULL,
0x00004bc000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00023d3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000007027d7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000802297812ULL, 0x044fe200078ec0ffULL,
0x000006f000017945ULL, 0x000fe20003800000ULL, 0x000000087d7d7812ULL, 0x100fe400078ef802ULL,
0x000000046f837810ULL, 0x000fe40007ffe0ffULL, 0x0000000729807812ULL, 0x000fe200078ef802ULL,
0x000000087d2b7824ULL, 0x000fe200078e00ffULL, 0x0000007d027e7211ULL, 0x000fc400078fe0ffULL,
0x0000008302837211ULL, 0x000fe200078fe0ffULL, 0x00000020802a7824ULL, 0x000fe200078e00ffULL,
0x0000006f027f7211ULL, 0x000fe200078fe0ffULL, 0x00000020802c7824ULL, 0x040fe200078e00ffULL,
0x000000026f817810ULL, 0x040fe20007ffe0ffULL, 0x00000020802d7824ULL, 0x040fe200078e00ffULL,
0x000000066f897810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82b287812ULL, 0x000fe200078ee27eULL,
0x00000001802b7824ULL, 0x040fe200078e0283ULL, 0x0000007f80297210ULL, 0x000fc40007ffe0ffULL,
0x0000008102817211ULL, 0x040fe400078fe0ffULL, 0x0000008902897211ULL, 0x000fe400078fe0ffULL,
0xffffffe02a297812ULL, 0x000fe200078ee229ULL, 0x00000001802a7824ULL, 0x000fe200078e0281ULL,
0xffffffe02c2b7812ULL, 0x000fe200078ee22bULL, 0x00000001802c7824ULL, 0x000fe200078e0289ULL,
0x0001200028347811ULL, 0x000fe400078e20ffULL, 0xffffffe02d2a7812ULL, 0x000fc400078ee22aULL,
0xffffffe02d2d7812ULL, 0x000fe400078ee22cULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0001400029297811ULL, 0x000fe400078e20ffULL, 0x000140002a2a7811ULL, 0x000fe400078e20ffULL,
0x000140002b2b7811ULL, 0x000fe200078e20ffULL, 0x000000002950783bULL, 0x000f220000004200ULL,
0x000140002d2d7811ULL, 0x000fe400078e20ffULL, 0x000000037d2f7819ULL, 0x000fe200000006ffULL,
0x000000002a5c783bULL, 0x000ee40000004200ULL, 0x000000027e2e7810ULL, 0x008fc40007ffe0ffULL,
0x0000001080307812ULL, 0x000fe200078efcffULL, 0x000000002b64783bULL, 0x000fe20000004200ULL,
0xfffffff82f2c7812ULL, 0x000fe400078ee22eULL, 0x00000030837a7210ULL, 0x000fe20007ffe0ffULL,
0x000000002d3c783bULL, 0x002fe20000004200ULL, 0x000000017f7c7824ULL, 0x000fe200078e0230ULL,
0x000120002c387811ULL, 0x000fe200078e20ffULL, 0x0000002030397824ULL, 0x000fe200078e00ffULL,
0x00000002ff787819ULL, 0x000fe20000011602ULL, 0x00000001817b7824ULL, 0x000fe200078e0230ULL,
0x000000776e00720cULL, 0x000fe20003fc3070ULL, 0x00000020302e7824ULL, 0x040fe200078e00ffULL,
0xffffffe0397c7812ULL, 0x000fe200078ee27cULL, 0x00000020302f7824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000e620000000200ULL, 0x0000000189797824ULL, 0x000fe200078e0230ULL,
0xffffffe02e7b7812ULL, 0x000fe200078ee27bULL, 0x0000002030447824ULL, 0x000fe200078e00ffULL,
0xffffffe02f7a7812ULL, 0x000fc400078ee27aULL, 0x000140007c2e7811ULL, 0x000fe400078e20ffULL,
0xffffffe044797812ULL, 0x000fe400078ee279ULL, 0x000140007b2f7811ULL, 0x000fe200078e20ffULL,
0x000000002e40783bULL, 0x000ee20000004200ULL, 0x000140007a307811ULL, 0x000fe200078e20ffULL,
0x0000002634349232ULL, 0x084fe20000000000ULL, 0x0001400079747811ULL, 0x000fe200078e20ffULL,
0x000000002f44783bULL, 0x000ea20000004200ULL, 0x0000002636369232ULL, 0x000fe20000000000ULL,
0x000000877800720cULL, 0x040fe20003f46070ULL, 0x0000002735359232ULL, 0x080fe20000000000ULL,
0x00000000304c783bULL, 0x000ea20000004200ULL, 0x0000002737379232ULL, 0x000fe20000000000ULL,
0x0000000878767810ULL, 0x000fc40007ffe0ffULL, 0x000000007454783bULL, 0x000ea20000004200ULL,
0x000000776e00720cULL, 0x000fe40003f03070ULL, 0x000000877600720cULL, 0x000fe20003f66070ULL,
0x000000503448723cULL, 0x050f7000000018ffULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x0000002638389232ULL, 0x002fc40000000000ULL, 0x000000263a3a9232ULL, 0x000fca0000000000ULL,
0x000000643460723cULL, 0x000fe200000018ffULL, 0x0000002739399232ULL, 0x080fe40000000000ULL,
0x000000273b3b9232ULL, 0x000fca0000000000ULL, 0x000000523450723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040b6e00000018ffULL, 0x00000001873d7810ULL, 0x020fe20007ffe0ffULL,
0x0000003e3434723cULL, 0x000f6600000018ffULL, 0x0000003d7800720cULL, 0x000fc40005746470ULL,
0x0000003d7600720cULL, 0x000fc60005f66470ULL, 0x000000403848723cULL, 0x048b700000001848ULL,
0x000000423850723cULL, 0x040b700000001850ULL, 0x000000443858723cULL, 0x044b700000001858ULL,
0x00000046385c723cULL, 0x040b70000000185cULL, 0x0000004c3860723cULL, 0x040b700000001860ULL,
0x0000004e3864723cULL, 0x040b700000001864ULL, 0x000000543868723cULL, 0x040b700000001868ULL,
0x000000563834723cULL, 0x020b620000001834ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x0000004820207221ULL, 0x000fe40000010000ULL,
0x000000491f1f7221ULL, 0x000fc40000010000ULL, 0x000000501c1c7221ULL, 0x000fe40000010000ULL,
0x000000511b1b7221ULL, 0x000fe40000010000ULL, 0x0000005818187221ULL, 0x000fe40000010000ULL,
0x0000005917177221ULL, 0x000fe40000010000ULL, 0x0000005c14147221ULL, 0x000fe40000010000ULL,
0x0000005d13137221ULL, 0x000fc40000010000ULL, 0x0000006010107221ULL, 0x000fe40000010000ULL,
0x000000610f0f7221ULL, 0x000fe40000010000ULL, 0x000000640c0c7221ULL, 0x000fe40000010000ULL,
0x000000650b0b7221ULL, 0x000fe40000010000ULL, 0x0000006808087221ULL, 0x000fe40000010000ULL,
0x0000006907077221ULL, 0x000fc40000010000ULL, 0x0000003404047221ULL, 0x020fe40000010000ULL,
0x0000003531317221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000003947ULL, 0x000fea0000000000ULL,
0x0000004a1e1e7221ULL, 0x000fe40000010000ULL, 0x0000004b1d1d7221ULL, 0x000fe40000010000ULL,
0x000000521a1a7221ULL, 0x000fe40000010000ULL, 0x0000005319197221ULL, 0x000fe40000010000ULL,
0x0000005a16167221ULL, 0x000fc40000010000ULL, 0x0000005b15157221ULL, 0x000fe40000010000ULL,
0x0000005e12127221ULL, 0x000fe40000010000ULL, 0x0000005f11117221ULL, 0x000fe40000010000ULL,
0x000000620e0e7221ULL, 0x000fe40000010000ULL, 0x000000630d0d7221ULL, 0x000fe40000010000ULL,
0x000000660a0a7221ULL, 0x000fc40000010000ULL, 0x0000006709097221ULL, 0x000fe40000010000ULL,
0x0000006a06067221ULL, 0x000fe40000010000ULL, 0x0000006b05057221ULL, 0x000fe40000010000ULL,
0x0000003632327221ULL, 0x020fe40000010000ULL, 0x0000003733337221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000776e00720cULL, 0x0c0fe40003f03070ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x00000001ff3f7803ULL, 0x000fe40000000000ULL,
0x00000002ff347819ULL, 0x002fe2000001163dULL, 0x000000ffff3c7224ULL, 0x000fc600078e0035ULL,
0x000000343d367207ULL, 0x040fe40002800000ULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe20007804885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09003a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078110ffULL,
0x000000ffff3a7224ULL, 0x000fca00000e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe2000780483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003f06070ULL, 0x000009a000008947ULL, 0x000fea0003800000ULL,
0x000000046f407824ULL, 0x000fe400078e00ffULL, 0x0000004003417824ULL, 0x000fe400078e026fULL,
0x00000200ff427424ULL, 0x000fe200078e00ffULL, 0x01ca000040377984ULL, 0x000e620000000800ULL,
0x00000010023a7824ULL, 0x000fca00078e00ffULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x00000002373c7819ULL, 0x002fca00000006ffULL, 0x01cac0003c377984ULL, 0x0002a40000000800ULL,
0x000000206f3c7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fc800078e0241ULL,
0x00005e0037387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000435387824ULL, 0x000fc800078e0236ULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x0000000638387819ULL, 0x000fc800000006ffULL, 0x0000003871377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x000000016f377824ULL, 0x000fc600078e0202ULL,
0x000000386f387217ULL, 0x000fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fc600078ee237ULL,
0x0000000138377824ULL, 0x000fe200078e0a6fULL, 0x0001400039457811ULL, 0x000fc800078e20ffULL,
0x000000ff3700720cULL, 0x000fda0003f03070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000c101c46ULL, 0x01ca040040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000141387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3d7210ULL, 0x000fe400007fe4ffULL, 0x000000016f397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000c101c46ULL, 0x01ca080040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000241387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0x000000026f397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe200078e0202ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000c101c46ULL, 0x01ca0c0040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000341387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x000000036f397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000c101c46ULL, 0x01ca100040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000441387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fc80007f1e0ffULL,
0x00000039ff3b7210ULL, 0x000fe400007fe4ffULL, 0x000000046f397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000c101c46ULL, 0x01ca140040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000541387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0x000000056f397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x0000000139387824ULL, 0x040fe200078e0202ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000c101c46ULL, 0x01ca180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000641387810ULL, 0x040fe40007ffe0ffULL,
0x0000000741417810ULL, 0x000fe40007ffe0ffULL, 0x01cac0003e397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0042ULL,
0x00000043383a7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e0639ULL,
0x000000066f397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003f03070ULL,
0x0000000139387824ULL, 0x040fe400078e0202ULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000c101c46ULL,
0x01ca1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fe200078e0241ULL,
0x000000076f417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0039387625ULL, 0x000fc800078e0042ULL,
0x00000001413e7824ULL, 0x040fe200078e0202ULL, 0x0000004338387210ULL, 0x000fe20007f1e0ffULL,
0x0000002041417824ULL, 0x000fc600078e00ffULL, 0x00000039ff397210ULL, 0x000fe400007fe4ffULL,
0x000000073700780cULL, 0x000fe40003f03070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000c101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f023e7211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010023a7824ULL, 0x000fe400078e00ffULL, 0x01ca00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe400078e023eULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013e387824ULL, 0x000fc600078e0202ULL, 0x00000039ff3b7210ULL, 0x000fe200007fe4ffULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x000fe400078e20ffULL, 0x0000000140387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000013e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fc80007f1e0ffULL, 0x00000039ff3b7210ULL, 0x000fe400007fe4ffULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000340387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000033e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fc80007f1e0ffULL, 0x00000039ff3b7210ULL, 0x000fe400007fe4ffULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000540387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200000e0639ULL,
0x000000053e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fc80007f1e0ffULL, 0x00000039ff3b7210ULL, 0x000fe400007fe4ffULL,
0x000000063e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000740387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x0000004338387210ULL, 0x000fe20007f1e0ffULL,
0x00000001413c7824ULL, 0x040fe400078e0202ULL, 0x0000002041417824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600000e0639ULL, 0xffffffe0413c7812ULL, 0x000fc800078ee23cULL,
0x000140003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003c7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe2000780483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fc80003f04070ULL, 0x000000ff34377207ULL, 0x040fe40000000000ULL,
0x000000ff34387207ULL, 0x000fc60004000000ULL, 0x0000000136377824ULL, 0x000fca00078e0237ULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000173357824ULL, 0x000fc600078e0238ULL, 0x0000003734347211ULL, 0x000fe400078e40ffULL,
0x0001ca0023377811ULL, 0x000fe400078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x100fe400078e0236ULL, 0x0000000123367824ULL, 0x040fe400078e0236ULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000713600720cULL, 0x000fc60003f06070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7800ff847f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000001947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000205827f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x000205e27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000717000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0002178000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000037003a7202ULL, 0x004fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x002fe200078e00ffULL,
0x00000018783b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x000071e000347802ULL, 0x000fc40000000f00ULL, 0x0002171000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000087d357824ULL, 0x000fe200078e00ffULL,
0x000000047e827810ULL, 0x000fe20007ffe0ffULL, 0x0000000180897824ULL, 0x040fe200078e0289ULL,
0x0000008180817210ULL, 0x040fe20007ffe0ffULL, 0x0000000180837824ULL, 0x040fe200078e0283ULL,
0xfffffff835827812ULL, 0x000fe200078ee282ULL, 0x00000001807f7824ULL, 0x040fe200078e027fULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000020803a7824ULL, 0x004fe200078e00ffULL,
0x0001200082347811ULL, 0x000fe200078e20ffULL, 0x0000002080387824ULL, 0x040fe200078e00ffULL,
0x000000ff3f00720cULL, 0x000fe20003f05270ULL, 0x00000020803c7824ULL, 0x002fe200078e00ffULL,
0xffffffe03a897812ULL, 0x000fe200078ee289ULL, 0x0000002080807824ULL, 0x000fe200078e00ffULL,
0xffffffe038387812ULL, 0x000fe200078ee27fULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0xffffffe03c7f7812ULL, 0x000fe200078ee283ULL, 0x0000041000017945ULL, 0x000fe20003800000ULL,
0xffffffe080807812ULL, 0x000fc400078ee281ULL, 0x0001800038817811ULL, 0x000fe400078e20ffULL,
0x000000067e387810ULL, 0x000fe40007ffe0ffULL, 0x0001800080807811ULL, 0x000fe200078e20ffULL,
0x000000008154783bULL, 0x000ea20000004200ULL, 0x000180007f7f7811ULL, 0x000fe400078e20ffULL,
0x00018000897e7811ULL, 0x000fe200078e20ffULL, 0x00000000805c783bULL, 0x000f220000004200ULL,
0x000000037d7d7819ULL, 0x000fc400000006ffULL, 0x000180007c7c7811ULL, 0x000fe200078e20ffULL,
0x000000007f64783bULL, 0x000ee20000004200ULL, 0xfffffff87d7d7812ULL, 0x000fe400078ee238ULL,
0x000180007b7b7811ULL, 0x000fe200078e20ffULL, 0x000000007e3c783bULL, 0x000fe20000004200ULL,
0x000120007d387811ULL, 0x000fe400078e20ffULL, 0x000180007a7a7811ULL, 0x000fe200078e20ffULL,
0x000000007c40783bULL, 0x000fe20000004200ULL, 0x0001800079797811ULL, 0x000fc600078e20ffULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x000000007b44783bULL, 0x000ee80000004200ULL,
0x000000007a48783bULL, 0x000ee40000004200ULL, 0x0000002634349232ULL, 0x00afc40000000000ULL,
0x00000000794c783bULL, 0x000e620000004200ULL, 0x0000002636369232ULL, 0x000fe40000000000ULL,
0x0000002735359232ULL, 0x080fe40000000000ULL, 0x0000002737379232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x044f7000000018ffULL, 0x0000005c3458723cULL, 0x050ff000000018ffULL,
0x000000643460723cULL, 0x000fe200000018ffULL, 0x0000002638389232ULL, 0x000fc40000000000ULL,
0x000000263a3a9232ULL, 0x000fe40000000000ULL, 0x0000002739399232ULL, 0x080fe40000000000ULL,
0x000000273b3b9232ULL, 0x000fe20000000000ULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x060b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x042b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x0000005020207221ULL, 0x020fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x000fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x000000521e1e7221ULL, 0x020fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x000fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000187877810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x00000004ff837424ULL, 0x000fca00078e00ffULL,
0x0000000183837807ULL, 0x000fc80006800000ULL, 0x000000838700720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffab4000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004077347811ULL, 0x000fe200078e40ffULL, 0x01cb5800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000713400720cULL, 0x000fda0003f06070ULL, 0x0000f03000000947ULL, 0x000fea0003800000ULL,
0x000000ffff877224ULL, 0x000fca00078e00ffULL, 0x00000002ff347819ULL, 0x000fe20000011687ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000387367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000003487347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000134347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fc800078110ffULL,
0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x000000046f3d7824ULL, 0x000fe200078e00ffULL, 0x0000003435387211ULL, 0x000fe200078e10ffULL,
0x00000200ff407424ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x000000016f3c7824ULL, 0x040fe200078e0202ULL, 0x01ca00003d377984ULL, 0x000e620000000800ULL,
0x0000002038387811ULL, 0x000fe200078e30ffULL, 0x000000206f417824ULL, 0x040fe200078e00ffULL,
0x000000016f437810ULL, 0x040fe20007ffe0ffULL, 0x000000016f3b7824ULL, 0x000fc600078e023eULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x0000000143427824ULL, 0x000fc600078e0202ULL,
0x000180003c417811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003871377217ULL, 0x000fc80007800000ULL, 0x01cac0003a397984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x000000386f387217ULL, 0x000fc80007800000ULL,
0x000000386f377210ULL, 0x000fc80007ffe1ffULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003922397224ULL, 0x002fe400078e023bULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x00005e0039387625ULL, 0x000fc600078e0040ULL, 0x000001f03b3f7812ULL, 0x000fc800078ec0ffULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fc60003f03070ULL, 0x01ca04003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe200078e023eULL,
0x0000000543437819ULL, 0x000fe400000006ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000026f437810ULL, 0x000fc40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x01ca08003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000036f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x01ca0c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000046f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x01ca10003d387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fe200000006ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe400078e00ffULL, 0x01cac0003c397984ULL, 0x000ea60000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000056f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x01ca14003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe200078e00ffULL, 0x0000003e43387210ULL, 0x040fe20007ffe0ffULL,
0x0000002043437824ULL, 0x000fc600078e00ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000066f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fe400078e20ffULL, 0x0000000243427210ULL, 0x000fe20007ffe0ffULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fc60003f03070ULL, 0x01ca18003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000076f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x00000001433e7824ULL, 0x000fe400078e023eULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x01ca1c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fe400078e023eULL, 0x00000001433e7824ULL, 0x040fe200078e0202ULL,
0x0000000543437819ULL, 0x000fe200000006ffULL, 0x00005e0039387625ULL, 0x000fc600078e0040ULL,
0xffffffe0433e7812ULL, 0x000fe400078ee23eULL, 0x0000003f38387210ULL, 0x000fe40007f3e0ffULL,
0x000180003e377811ULL, 0x000fc600078e20ffULL, 0x000000ffff397224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x0000006f023f7211ULL, 0x040fe200078fd8ffULL,
0x0000001002397824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x000000053f3c7819ULL, 0x000fe200000006ffULL,
0x01ca00003f377984ULL, 0x000e620000004800ULL, 0x000001f039437812ULL, 0x000fe200078ec0ffULL,
0x000000013f387824ULL, 0x040fe200078e023eULL, 0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000013f3b7824ULL, 0x000fc800078e0202ULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fe200078e0238ULL,
0xffffffe03c377812ULL, 0x000fc600078ee23bULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x0001800037457811ULL, 0x000fc800078e20ffULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe400078e023eULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe40007f1e0ffULL,
0x0000003e3b387210ULL, 0x040fe20007ffe0ffULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe200078e023eULL, 0x000000053d3d7819ULL, 0x000fc600000006ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0xffffffe03d407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000043f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e023eULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000053f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe40007f1e0ffULL,
0x0000003e3d387210ULL, 0x040fe20007ffe0ffULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000063f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe200078e023eULL, 0x000000053b3b7819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0xffffffe03b407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003f377984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fca0007ffe0ffULL, 0x00000001453c7824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000145387824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe0453c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003f377984ULL, 0x000ea20000004800ULL, 0x000180003c3b7811ULL, 0x002fc600078e20ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003c7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000004ff387424ULL, 0x000fe200078e00ffULL,
0x000000036d397812ULL, 0x000fe200078ec0ffULL, 0x00000300ff377624ULL, 0x000fc600078e00ffULL,
0x000000033900780cULL, 0x000fe20003f05270ULL, 0xfffffffd38377424ULL, 0x000fca00078e0237ULL,
0x00000001373a7807ULL, 0x000fc80004000000ULL, 0x0000003a6d6d7210ULL, 0x000fe20007ffe0ffULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400377824ULL, 0x000fe200078e0223ULL,
0x000064006d3a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x0001cac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x002fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe200078e0235ULL, 0x0000003473347210ULL, 0x000fc60007ffe0ffULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01caf8006f347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cafc006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fc80007f1e1ffULL, 0x0000003735377210ULL, 0x000fe400007fe5ffULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cafc006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243b7824ULL, 0x000fca00078e0235ULL,
0x01c080003b377984ULL, 0x000ea80000000800ULL, 0x01c280003b367984ULL, 0x0006620000000800ULL,
0x0000006c3700720bULL, 0x004fe20003f1d000ULL, 0x0001dc927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x0000000100247802ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fd400078e006cULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000017500780cULL, 0x000fe40003f05270ULL, 0x0000006c3700720bULL, 0x000fe20003f34000ULL,
0x0001dc627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000376c387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c480383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386c347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0001dbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f783d347589ULL, 0x0004e400000e0000ULL, 0x0000003420207220ULL, 0x088fe40000410000ULL,
0x000000341f1f7220ULL, 0x080fe40000410000ULL, 0x000000341c1c7220ULL, 0x080fe40000410000ULL,
0x000000341b1b7220ULL, 0x080fe40000410000ULL, 0x0000003418187220ULL, 0x080fe40000410000ULL,
0x0000003417177220ULL, 0x000fc40000410000ULL, 0x0000003414147220ULL, 0x080fe40000410000ULL,
0x0000003413137220ULL, 0x080fe40000410000ULL, 0x0000003410107220ULL, 0x080fe40000410000ULL,
0x000000340f0f7220ULL, 0x080fe40000410000ULL, 0x000000340c0c7220ULL, 0x080fe40000410000ULL,
0x000000340b0b7220ULL, 0x000fc40000410000ULL, 0x0000003408087220ULL, 0x080fe40000410000ULL,
0x0000003407077220ULL, 0x080fe40000410000ULL, 0x0000003404047220ULL, 0x080fe40000410000ULL,
0x0000003431317220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0001daf27f007947ULL, 0x000fea000b800000ULL, 0x00001f763d347589ULL, 0x0006a400000e0000ULL,
0x000000341e1e7220ULL, 0x084fe40000410000ULL, 0x000000341d1d7220ULL, 0x080fe40000410000ULL,
0x000000341a1a7220ULL, 0x080fe40000410000ULL, 0x0000003419197220ULL, 0x080fe40000410000ULL,
0x0000003416167220ULL, 0x080fe40000410000ULL, 0x0000003415157220ULL, 0x000fc40000410000ULL,
0x0000003412127220ULL, 0x080fe40000410000ULL, 0x0000003411117220ULL, 0x080fe40000410000ULL,
0x000000340e0e7220ULL, 0x080fe40000410000ULL, 0x000000340d0d7220ULL, 0x080fe40000410000ULL,
0x000000340a0a7220ULL, 0x080fe40000410000ULL, 0x0000003409097220ULL, 0x000fc40000410000ULL,
0x0000003406067220ULL, 0x080fe40000410000ULL, 0x0000003405057220ULL, 0x080fe40000410000ULL,
0x0000003432327220ULL, 0x080fe40000410000ULL, 0x0000003433337220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003837370221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700250308ULL, 0x000ea40000000800ULL,
0x0000002536360220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002136217221ULL, 0x002fe40000010000ULL, 0x000000ffff6c7224ULL, 0x000fc400078e0038ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0001d9527f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x0001d9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0000a05000347802ULL, 0x000fc40000000f00ULL,
0x0001e8a000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0000a0c000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001e83000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001280028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000128002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b232ULL, 0x004fc40000000000ULL,
0x000000263636b232ULL, 0x000fe40000000000ULL, 0x000000273535b232ULL, 0x080fe40000000000ULL,
0x000000273737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000263838b232ULL, 0x082fe40000000000ULL, 0x000000263a3ab232ULL, 0x000fe40000000000ULL,
0x000000273939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000273b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x020fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe4000001163dULL,
0x00000035003c7202ULL, 0x000fe40000000f00ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000134367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078d10ffULL, 0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x000000046f407824ULL, 0x000fe400078e00ffULL, 0x0000004003417824ULL, 0x000fe400078e026fULL,
0x00000200ff427424ULL, 0x000fe200078e00ffULL, 0x01ca000040377984ULL, 0x000e620000000800ULL,
0x00000010023a7824ULL, 0x000fca00078e00ffULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x00000004373c7824ULL, 0x002fca00078e00ffULL, 0x01cac0003c377984ULL, 0x0002a40000000800ULL,
0x000000206f3c7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fc800078e0241ULL,
0x00005e0037387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000435387824ULL, 0x000fc600078e0236ULL, 0x00000039ff3b7210ULL, 0x000fe200037fe4ffULL,
0x0000004038387824ULL, 0x000fca00078e00ffULL, 0x0000003871377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x000000016f377824ULL, 0x000fc600078e0202ULL,
0x000000386f387217ULL, 0x040fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fe400078ee237ULL,
0x000000386f377210ULL, 0x000fe40007ffe1ffULL, 0x0001400039457811ULL, 0x000fe400078e20ffULL,
0x000000ff3700720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca040040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000141387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000016f397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca080040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000241387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3b7210ULL, 0x000fe400037fe4ffULL, 0x000000026f397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca0c0040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000341387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000036f397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe200078e0202ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca100040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000441387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000046f397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca140040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000541387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3d7210ULL, 0x000fe400037fe4ffULL, 0x000000056f397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000641387810ULL, 0x040fe40007ffe0ffULL,
0x0000000741417810ULL, 0x000fe40007ffe0ffULL, 0x01cac0003e397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0042ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000066f397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003fc3070ULL,
0x0000000139387824ULL, 0x040fe200078e0202ULL, 0x0000000539397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x01ca1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fe200078e0241ULL,
0x000000076f417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0039387625ULL, 0x000fc800078e0042ULL,
0x00000001413e7824ULL, 0x040fe200078e0202ULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x0000002041417824ULL, 0x000fc800078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073700780cULL, 0x000fe40003fc3070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f023e7211ULL, 0x040fe200078fd8ffULL, 0x00000010023a7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x01ca00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe200078e023eULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013e387824ULL, 0x000fc800078e0202ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x000fe400078e20ffULL, 0x0000000140387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000340387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000540387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000053e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000063e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000740387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x00000002413c7210ULL, 0x040fe20007ffe0ffULL,
0x0000002041417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007fde0ffULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x000000ffff397224ULL, 0x000fc600030e0639ULL,
0x000140003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fe40007000000ULL, 0x0000003736377210ULL, 0x000fc80007ffe0ffULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000173357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x000fe200078e0236ULL, 0x0000003623367210ULL, 0x040fe20007ffe0ffULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000713600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7800ff847f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x0001b7527f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x0001b7b27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0000c35000347802ULL, 0x000fc40000000f00ULL,
0x0001c5a000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0000c3c000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0001c53000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001280082347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000128007d387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000805c783bULL, 0x000fe80000004200ULL, 0x000000007f64783bULL, 0x000fe80000004200ULL,
0x000000007e3c783bULL, 0x002fe80000004200ULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000007c40783bULL, 0x000f280000004200ULL, 0x000000007b44783bULL, 0x000ee80000004200ULL,
0x000000007a48783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000263434b232ULL, 0x00cfc40000000000ULL, 0x000000263636b232ULL, 0x000fe40000000000ULL,
0x000000273535b232ULL, 0x080fe40000000000ULL, 0x000000273737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000263838b232ULL, 0x082fe40000000000ULL,
0x000000263a3ab232ULL, 0x000fe40000000000ULL, 0x000000273939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000273b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x020fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x000fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x020fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x000fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000187877810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000838700720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb08000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008077347811ULL, 0x000fe200078e40ffULL, 0x01cb6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000713400720cULL, 0x000fda0003f06070ULL, 0x0000a01000000947ULL, 0x000fea0003800000ULL,
0x000000ff00877202ULL, 0x000fc80000000f00ULL, 0x00000002ff347819ULL, 0x000fe20000011687ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000387367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000003487347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000234347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fc800078110ffULL, 0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x000000046f3d7824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x0000000435387824ULL, 0x000fe200078e0234ULL, 0x0000020000407802ULL, 0x000fe20000000f00ULL,
0x000000016f3c7824ULL, 0x040fe200078e0202ULL, 0x01ca00003d377984ULL, 0x000e620000000800ULL,
0x000000016f3b7824ULL, 0x040fe200078e023eULL, 0x0000002038387811ULL, 0x000fe200078e30ffULL,
0x000000206f417824ULL, 0x040fe200078e00ffULL, 0x000000016f437810ULL, 0x000fc80007ffe0ffULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x0000000143427824ULL, 0x000fc600078e0202ULL,
0x000180003c417811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003871377217ULL, 0x000fc80007800000ULL, 0x01cac0003a397984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x000000386f387217ULL, 0x000fca0007800000ULL,
0x0000000138377824ULL, 0x000fca00078e0a6fULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003922397224ULL, 0x002fe400078e023bULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x00005e0039387625ULL, 0x000fc600078e0040ULL, 0x000001f03b3f7812ULL, 0x000fc800078ec0ffULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fc60003f03070ULL, 0x01ca04003d387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fe200000006ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe400078e00ffULL, 0x01cac0003c397984ULL, 0x000ea60000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000026f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x01ca08003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe200078e00ffULL, 0x0000003e43387210ULL, 0x040fe20007ffe0ffULL,
0x0000002043437824ULL, 0x000fc600078e00ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000036f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fe400078e20ffULL, 0x0000000243427210ULL, 0x000fe20007ffe0ffULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x01ca0c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000046f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x01ca10003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe200078e023eULL,
0x0000000543437819ULL, 0x000fe400000006ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000056f437810ULL, 0x000fc40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x01ca14003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000066f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fc60003f03070ULL, 0x01ca18003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000076f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x00000001433e7824ULL, 0x000fe400078e023eULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x01ca1c003d387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fca00000006ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fe400078e023eULL, 0x00000001433e7824ULL, 0x000fe400078e0202ULL,
0x00005e0039387625ULL, 0x000fc800078e0040ULL, 0x0000002043437824ULL, 0x000fe200078e00ffULL,
0x0000003f38387210ULL, 0x000fc80007f3e0ffULL, 0xffffffe0433e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fc600008e0639ULL, 0x000180003e377811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x0000006f023f7211ULL, 0x040fe200078fd8ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe400078e30ffULL,
0x0000000402397819ULL, 0x000fe200000006ffULL, 0x01ca00003f377984ULL, 0x000e620000004800ULL,
0x000000013f3b7824ULL, 0x040fe200078e0202ULL, 0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000013f387824ULL, 0x000fe200078e023eULL, 0x000001f039437812ULL, 0x000fe200078ec0ffULL,
0x000000203f3c7824ULL, 0x000fe200078e00ffULL, 0x000000023d407210ULL, 0x000fe20007ffe0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fe200078e0238ULL,
0xffffffe03c377812ULL, 0x000fc600078ee23bULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x0001800037457811ULL, 0x000fc800078e20ffULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe400078e023eULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e023eULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe400078e023eULL, 0x000000203d3d7824ULL, 0x000fe200078e00ffULL,
0x00000039ff3b7210ULL, 0x000fc800007fe4ffULL, 0xffffffe03d407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000043f3b7810ULL, 0x000fc80007ffe0ffULL, 0x000000023b407210ULL, 0x000fe20007ffe0ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e023eULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000053f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe400078e023eULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000063f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e023eULL, 0x000000203b3b7824ULL, 0x000fe200078e00ffULL,
0x00000039ff3d7210ULL, 0x000fc800007fe4ffULL, 0xffffffe03b407812ULL, 0x000fe200078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003f377984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fc80007ffe0ffULL, 0x00000002453c7210ULL, 0x000fe20007ffe0ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000145387824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe0453c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003f377984ULL, 0x000ea20000004800ULL, 0x000180003c3b7811ULL, 0x002fc600078e20ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078110ffULL, 0x0000003bff3a7210ULL, 0x000fc800007fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000004ff387424ULL, 0x000fe200078e00ffULL,
0x000000036d397812ULL, 0x000fe200078ec0ffULL, 0x00000300ff377624ULL, 0x000fc600078e00ffULL,
0x000000033900780cULL, 0x000fe20003f05270ULL, 0xfffffffd38377424ULL, 0x000fca00078e0237ULL,
0x00000001373a7807ULL, 0x000fca0004000000ULL, 0x000000016d6d7824ULL, 0x000fe200078e023aULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400377824ULL, 0x000fe200078e0223ULL,
0x000064006d3a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x0001cac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fc80000011637ULL, 0x0000003734347210ULL, 0x000fe40007ffe0ffULL,
0x0001ca0023377811ULL, 0x000fe400078e10ffULL, 0x00000002ff387819ULL, 0x002fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe400078e0235ULL, 0x0000000173347824ULL, 0x000fe400078e0234ULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe40003f06070ULL,
0x0000003423347210ULL, 0x000fca0007ffe0ffULL, 0x0000660034347625ULL, 0x000fcc00078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb18006f347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cb1c006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cb1c006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fc800078ec0ffULL, 0x00000035243b7210ULL, 0x000fca0007ffe0ffULL,
0x01c100003b377984ULL, 0x000ea80000000800ULL, 0x01c300003b367984ULL, 0x0006620000000800ULL,
0x0000006c3700720bULL, 0x004fe20003f1d000ULL, 0x000190227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff387224ULL, 0x000fd200078e006cULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000027500780cULL, 0x000fe40003f05270ULL, 0x0000006c3700720bULL, 0x000fe20003f34000ULL,
0x00018ff27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000376c387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c500383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386c347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00018f527f007947ULL, 0x000fea000b800000ULL,
0x00001f783d347589ULL, 0x0004e400000e0000ULL, 0x0000003420207220ULL, 0x088fe40000410000ULL,
0x000000341f1f7220ULL, 0x080fe40000410000ULL, 0x000000341c1c7220ULL, 0x080fe40000410000ULL,
0x000000341b1b7220ULL, 0x080fe40000410000ULL, 0x0000003418187220ULL, 0x080fe40000410000ULL,
0x0000003417177220ULL, 0x000fc40000410000ULL, 0x0000003414147220ULL, 0x080fe40000410000ULL,
0x0000003413137220ULL, 0x080fe40000410000ULL, 0x0000003410107220ULL, 0x080fe40000410000ULL,
0x000000340f0f7220ULL, 0x080fe40000410000ULL, 0x000000340c0c7220ULL, 0x080fe40000410000ULL,
0x000000340b0b7220ULL, 0x000fc40000410000ULL, 0x0000003408087220ULL, 0x080fe40000410000ULL,
0x0000003407077220ULL, 0x080fe40000410000ULL, 0x0000003404047220ULL, 0x080fe40000410000ULL,
0x0000003431317220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00018e827f007947ULL, 0x000fea000b800000ULL, 0x00001f763d347589ULL, 0x0006a400000e0000ULL,
0x000000341e1e7220ULL, 0x084fe40000410000ULL, 0x000000341d1d7220ULL, 0x080fe40000410000ULL,
0x000000341a1a7220ULL, 0x080fe40000410000ULL, 0x0000003419197220ULL, 0x080fe40000410000ULL,
0x0000003416167220ULL, 0x080fe40000410000ULL, 0x0000003415157220ULL, 0x000fc40000410000ULL,
0x0000003412127220ULL, 0x080fe40000410000ULL, 0x0000003411117220ULL, 0x080fe40000410000ULL,
0x000000340e0e7220ULL, 0x080fe40000410000ULL, 0x000000340d0d7220ULL, 0x080fe40000410000ULL,
0x000000340a0a7220ULL, 0x080fe40000410000ULL, 0x0000003409097220ULL, 0x000fc40000410000ULL,
0x0000003406067220ULL, 0x080fe40000410000ULL, 0x0000003405057220ULL, 0x080fe40000410000ULL,
0x0000003432327220ULL, 0x080fe40000410000ULL, 0x0000003433337220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003837370221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700250308ULL, 0x000ea40000000800ULL,
0x0000002536360220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002136217221ULL, 0x002fe40000010000ULL, 0x000000ffff6c7224ULL, 0x000fc400078e0038ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x00018ce27f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x00018d427f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000f07000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001988000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000037003a7202ULL, 0x004fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x002fe200078e00ffULL,
0x00000018783b7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0000f0e000347802ULL, 0x000fc40000000f00ULL, 0x0001981000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001300028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000130002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b232ULL, 0x004fc40000000000ULL,
0x000000263636b232ULL, 0x000fe40000000000ULL, 0x000000273535b232ULL, 0x080fe40000000000ULL,
0x000000273737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000263838b232ULL, 0x082fe40000000000ULL, 0x000000263a3ab232ULL, 0x000fe40000000000ULL,
0x000000273939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000273b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x020fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe2000001163dULL,
0x000000ffff3c7224ULL, 0x000fc600078e0035ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000234367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fc800078d10ffULL,
0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x000000046f407824ULL, 0x000fe200078e00ffULL, 0x0000006f03417211ULL, 0x000fe200078e30ffULL,
0x00000200ff427424ULL, 0x000fe400078e00ffULL, 0x00000010023a7824ULL, 0x000fe200078e00ffULL,
0x01ca000040377984ULL, 0x000e680000000800ULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x00000004373c7824ULL, 0x002fca00078e00ffULL, 0x01cac0003c377984ULL, 0x0002a40000000800ULL,
0x000000206f3c7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fc800078e0241ULL,
0x00005e0037387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000435387824ULL, 0x000fc800078e0236ULL, 0x0000004038387824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600030e0639ULL, 0x0000003871377217ULL, 0x000fc80007800000ULL,
0x0000003738387210ULL, 0x000fe20007ffe1ffULL, 0x000000016f377824ULL, 0x000fc600078e0202ULL,
0x000000386f387217ULL, 0x000fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fc600078ee237ULL,
0x0000000138377824ULL, 0x000fe200078e0a6fULL, 0x0001400039457811ULL, 0x000fc800078e20ffULL,
0x000000ff3700720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca040040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000141387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000016f397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fe40003fc3070ULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca080040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000241387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000026f397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca0c0040387984ULL, 0x000ea40000000800ULL,
0x00000002383e7819ULL, 0x004fe400000006ffULL, 0x0000000341387810ULL, 0x000fc60007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000036f397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca100040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000441387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000046f397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fe40003fc3070ULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca140040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000541387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000056f397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca180040387984ULL, 0x000ea40000000800ULL,
0x00000002383e7819ULL, 0x004fe400000006ffULL, 0x0000000641387810ULL, 0x040fe40007ffe0ffULL,
0x0000000741417810ULL, 0x000fe20007ffe0ffULL, 0x01cac0003e397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0042ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000066f397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003fc3070ULL,
0x0000000139387824ULL, 0x040fe400078e0202ULL, 0x0000002039397824ULL, 0x000fca00078e00ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x01ca1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fe200078e0241ULL,
0x000000076f417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0039387625ULL, 0x000fe200078e0042ULL,
0x00000002413e7210ULL, 0x000fc60007ffe0ffULL, 0x0000002041417824ULL, 0x000fe200078e00ffULL,
0x0000004338387210ULL, 0x000fc80007fde0ffULL, 0xffffffe0413e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff397224ULL, 0x000fe200030e0639ULL, 0x000000073700780cULL, 0x000fe40003fc3070ULL,
0x000140003e3b7811ULL, 0x002fd600078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f023e7211ULL, 0x040fe200078fd8ffULL, 0x00000200ff417424ULL, 0x000fe400078e00ffULL,
0x00000010023a7824ULL, 0x000fe400078e00ffULL, 0x01ca00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe400078e023eULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe40007fde0ffULL,
0x000000023e387210ULL, 0x000fc60007ffe0ffULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x000fe400078e20ffULL, 0x0000000140387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000340387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000540387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000053e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000063e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000740387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x00000001413c7824ULL, 0x040fe400078e0202ULL, 0x0000002041417824ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fc600030e0639ULL, 0xffffffe0413c7812ULL, 0x000fc800078ee23cULL,
0x000140003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ff003d7202ULL, 0x000fe20000000f00ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fc60007000000ULL, 0x0000000136377824ULL, 0x000fca00078e0237ULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe400078ec0ffULL,
0x0000003873357210ULL, 0x000fc60007ffe0ffULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x100fe400078e0236ULL, 0x0000000123367824ULL, 0x040fe400078e0236ULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000713600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7800ff847f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x00016ae27f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x00016b427f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0001137000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0001758000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0000001f003c7802ULL, 0x000fe40000000f00ULL,
0x000113e000347802ULL, 0x000fc40000000f00ULL, 0x0001751000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001300082347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000130007d387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000805c783bULL, 0x000fe80000004200ULL, 0x000000007f64783bULL, 0x000fe80000004200ULL,
0x000000007e3c783bULL, 0x002fe80000004200ULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000007c40783bULL, 0x000f280000004200ULL, 0x000000007b44783bULL, 0x000ee80000004200ULL,
0x000000007a48783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000263434b232ULL, 0x00cfc40000000000ULL, 0x000000263636b232ULL, 0x000fe40000000000ULL,
0x000000273535b232ULL, 0x080fe40000000000ULL, 0x000000273737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000263838b232ULL, 0x082fe40000000000ULL,
0x000000263a3ab232ULL, 0x000fe40000000000ULL, 0x000000273939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000273b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x020fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x000fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x020fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x000fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000187877810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000838700720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb08000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c077347811ULL, 0x000fe200078e40ffULL, 0x01cb6800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000713400720cULL, 0x000fda0003f06070ULL, 0x00004ff000000947ULL, 0x000fea0003800000ULL,
0x000000ffff877224ULL, 0x000fca00078e00ffULL, 0x00000002ff347819ULL, 0x000fe20000011687ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000387367812ULL, 0x040fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x0000003487347207ULL, 0x000fe40002800000ULL,
0x000000ff36367207ULL, 0x000fe40006800000ULL, 0x0000000334347810ULL, 0x000fc80007ffe0ffULL,
0x00000002ff387819ULL, 0x000fe40000011634ULL, 0x0000000334347812ULL, 0x000fc600078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL, 0x000000013b3b7824ULL, 0x000fe200000e0e39ULL,
0x003d09003d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x0000003d3a3a7211ULL, 0x000fc800078110ffULL,
0x0000003bff3b7210ULL, 0x000fc800007fe4ffULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb7c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383d7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff3a7819ULL, 0x000fc8000001143bULL,
0x0000003d3a3a7211ULL, 0x000fca00078110ffULL, 0x000000ffff3b7224ULL, 0x000fca00000e063bULL,
0x000000023a3a7819ULL, 0x000fc8000000123bULL, 0x0000003a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff3a7984ULL, 0x000e640000000800ULL,
0x800000003aff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000122000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003f06070ULL, 0x000009b000008947ULL, 0x000fea0003800000ULL,
0x000000046f3d7824ULL, 0x000fe200078e00ffULL, 0x0000003435387211ULL, 0x000fe200078e10ffULL,
0x00000200ff407424ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x000000016f3c7824ULL, 0x040fe200078e0202ULL, 0x01ca00003d377984ULL, 0x000e620000000800ULL,
0x0000002038387811ULL, 0x000fe200078e30ffULL, 0x000000206f417824ULL, 0x040fe200078e00ffULL,
0x000000016f437810ULL, 0x040fe20007ffe0ffULL, 0x000000016f3b7824ULL, 0x000fc600078e023eULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x0000000143427824ULL, 0x000fc600078e0202ULL,
0x000180003c417811ULL, 0x000fe200078e20ffULL, 0x00000004373a7824ULL, 0x002fe200078e00ffULL,
0x0000003871377217ULL, 0x000fc80007800000ULL, 0x01cac0003a397984ULL, 0x000e620000000800ULL,
0x0000000137387824ULL, 0x000fca00078e0a38ULL, 0x000000386f387217ULL, 0x000fc80007800000ULL,
0x000000386f377210ULL, 0x000fc80007ffe1ffULL, 0x000000ff3700720cULL, 0x000fe20003f03070ULL,
0x0000003922397224ULL, 0x002fe400078e023bULL, 0x00000010023b7824ULL, 0x000fe400078e00ffULL,
0x00005e0039387625ULL, 0x000fc600078e0040ULL, 0x000001f03b3f7812ULL, 0x000fc800078ec0ffULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000013700780cULL, 0x000fc60003f03070ULL, 0x01ca04003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe200078e023eULL,
0x0000000543437819ULL, 0x000fe400000006ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000026f437810ULL, 0x000fc40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000023700780cULL, 0x000fc60003f03070ULL, 0x01ca08003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000036f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fc80007f3e0ffULL, 0x00000039ff3b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000033700780cULL, 0x000fc60003f03070ULL, 0x01ca0c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000046f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000043700780cULL, 0x000fc60003f03070ULL, 0x01ca10003d387984ULL, 0x000ea40000000800ULL,
0x00000002383c7819ULL, 0x004fe200000006ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe400078e00ffULL, 0x01cac0003c397984ULL, 0x000ea60000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000056f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x0000000143427824ULL, 0x000fe400078e0202ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000053700780cULL, 0x000fc60003f03070ULL, 0x01ca14003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe200078e00ffULL, 0x0000003e43387210ULL, 0x040fe20007ffe0ffULL,
0x0000002043437824ULL, 0x000fc600078e00ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0xffffffe043427812ULL, 0x000fe400078ee242ULL, 0x000000066f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fe400078e20ffULL, 0x0000000243427210ULL, 0x000fe20007ffe0ffULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000063700780cULL, 0x000fc60003f03070ULL, 0x01ca18003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fe400078e00ffULL, 0x0000000143387824ULL, 0x040fe400078e023eULL,
0x0000002043437824ULL, 0x000fe200078e00ffULL, 0x01cac0003c397984ULL, 0x000ea80000000800ULL,
0xffffffe043427812ULL, 0x000fc400078ee242ULL, 0x000000076f437810ULL, 0x000fe40007ffe0ffULL,
0x0001800042417811ULL, 0x002fc600078e20ffULL, 0x00000001433e7824ULL, 0x000fe400078e023eULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0040ULL,
0x0000003f383a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a417faeULL, 0x0003e2000c101c46ULL,
0x000000073700780cULL, 0x000fc60003f03070ULL, 0x01ca1c003d387984ULL, 0x000ea40000000800ULL,
0x00000004383c7824ULL, 0x004fca00078e00ffULL, 0x01cac0003c397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fe400078e023eULL, 0x00000001433e7824ULL, 0x040fe200078e0202ULL,
0x0000000543437819ULL, 0x000fe200000006ffULL, 0x00005e0039387625ULL, 0x000fc600078e0040ULL,
0xffffffe0433e7812ULL, 0x000fe400078ee23eULL, 0x0000003f38387210ULL, 0x000fe40007f3e0ffULL,
0x000180003e377811ULL, 0x000fc600078e20ffULL, 0x000000ffff397224ULL, 0x000fca00008e0639ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000c101c46ULL,
0x0000084000007947ULL, 0x000fea0003800000ULL, 0x0000006f023f7211ULL, 0x040fe200078fd8ffULL,
0x0000001002397824ULL, 0x000fe200078e00ffULL, 0x00000020033e7811ULL, 0x000fe200078e30ffULL,
0x00000200ff417424ULL, 0x000fe200078e00ffULL, 0x000000053f3c7819ULL, 0x000fe200000006ffULL,
0x01ca00003f377984ULL, 0x000e620000004800ULL, 0x000001f039437812ULL, 0x000fe200078ec0ffULL,
0x000000013f387824ULL, 0x040fe200078e023eULL, 0x000000013f3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000013f3b7824ULL, 0x000fc800078e0202ULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fe200078e0238ULL,
0xffffffe03c377812ULL, 0x000fc600078ee23bULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x0001800037457811ULL, 0x000fc800078e20ffULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe400078e023eULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000023f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe40007f1e0ffULL,
0x0000003e3b387210ULL, 0x040fe20007ffe0ffULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000033f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x000000013d387824ULL, 0x040fe200078e023eULL, 0x000000053d3d7819ULL, 0x000fc600000006ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e0639ULL, 0xffffffe03d407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000043f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe400078e023eULL, 0x000000203b3b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fc600000e0639ULL, 0xffffffe03b407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000053f3d7810ULL, 0x000fca0007ffe0ffULL, 0x000000013d407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe40007f1e0ffULL,
0x0000003e3d387210ULL, 0x040fe20007ffe0ffULL, 0x000000203d3d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe03d407812ULL, 0x000fe400078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003f377984ULL, 0x000ea20000004800ULL, 0x0001800040457811ULL, 0x002fe400078e20ffULL,
0x000000063f3b7810ULL, 0x000fca0007ffe0ffULL, 0x000000013b407824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383c7210ULL, 0x000fe20007f1e0ffULL,
0x000000013b387824ULL, 0x040fe200078e023eULL, 0x000000053b3b7819ULL, 0x000fc600000006ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e0639ULL, 0xffffffe03b407812ULL, 0x000fc800078ee240ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003f377984ULL, 0x000ea20000004800ULL, 0x00018000403d7811ULL, 0x002fe400078e20ffULL,
0x000000073f457810ULL, 0x000fca0007ffe0ffULL, 0x00000001453c7824ULL, 0x000fe200078e0202ULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000145387824ULL, 0x040fe400078e023eULL, 0x0000002045457824ULL, 0x000fe400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fc600000e0639ULL, 0xffffffe0453c7812ULL, 0x000fe400078ee23cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003f377984ULL, 0x000ea20000004800ULL, 0x000180003c3b7811ULL, 0x002fc600078e20ffULL,
0x01cac00037377984ULL, 0x004e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0238ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x0000004338387210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e6000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x00000039003c7202ULL, 0x002fc40000000f00ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe4000780483cULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe4000780483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fe20003f04070ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x000000033600780cULL, 0x000fda0003f25270ULL, 0x0000014000008947ULL, 0x000fea0000800000ULL,
0x000000032300780cULL, 0x000fe20003f24070ULL, 0x00000004ff387424ULL, 0x000fe200078e00ffULL,
0x000000036d397812ULL, 0x000fe200078ec0ffULL, 0x00000300ff377624ULL, 0x000fc600078e00ffULL,
0x000000033900780cULL, 0x000fe20003f05270ULL, 0xfffffffd38377424ULL, 0x000fca00078e0237ULL,
0x00000001373a7807ULL, 0x000fc80004000000ULL, 0x0000003a6d6d7210ULL, 0x000fe20007ffe0ffULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400377824ULL, 0x000fe200078e0223ULL,
0x000064006d3a7a10ULL, 0x040fe40007ffe0ffULL, 0x000000726d00720cULL, 0x000fe20003f06070ULL,
0x0000000237377824ULL, 0x000fe200078e00ffULL, 0x0001cac0233b7811ULL, 0x000fc600078e10ffULL,
0x0000640037377a24ULL, 0x000fc800078e023aULL, 0x0000600037387625ULL, 0x000fca00078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383b7faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000019000017945ULL, 0x000fe20003800000ULL,
0x0000017000004947ULL, 0x000fea0003800000ULL, 0x000000356e00720cULL, 0x000fe40003f04070ULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000000337367812ULL, 0x000fce00078ec0ffULL,
0x00000002ff378819ULL, 0x000fca0000011637ULL, 0x0000000134347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x00000002ff387819ULL, 0x002fe20000011634ULL,
0x0000004034347824ULL, 0x000fc800078e00ffULL, 0x0000030038387a24ULL, 0x000fe200078e0235ULL,
0x000000c034357812ULL, 0x000fe400078ec0ffULL, 0x000000ff36347207ULL, 0x000fc60004000000ULL,
0x0000010038357824ULL, 0x000fe200078e0235ULL, 0x0000003473347210ULL, 0x000fc60007ffe0ffULL,
0x0000000123367824ULL, 0x140fe400078e0235ULL, 0x0000680034347a24ULL, 0x000fe400078e0235ULL,
0x00000004ff357424ULL, 0x000fe200078e00ffULL, 0x000000713600720cULL, 0x000fe20003f06070ULL,
0x0000000123347824ULL, 0x000fc800078e0234ULL, 0x0000660034347625ULL, 0x000fd000078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000c121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff8700720cULL, 0x000fe20003f05270ULL,
0x01cb8000ff847f8cULL, 0x000e62000c80043fULL, 0x000007d000017945ULL, 0x000ff60003800000ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb38006f347f8cULL, 0x000ea4000c80043fULL, 0x000000ffff3b7224ULL, 0x004fc400078e0035ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x01cb3c006f247984ULL, 0x000ea40000000800ULL,
0x8000000024ff7812ULL, 0x004fc4000780483bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634397210ULL, 0x000fc80007f1e1ffULL, 0x0000003735377210ULL, 0x000fe400007fe5ffULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011437ULL, 0x0000003924247211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e0637ULL, 0x0000000224247819ULL, 0x000fc80000001237ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x01cb3c006f247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe4000780483bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001002247824ULL, 0x000fe200078e00ffULL,
0x00000001ff347819ULL, 0x000fc80000011602ULL, 0x0000007024247812ULL, 0x000fe400078ec0ffULL,
0x0000000c34357812ULL, 0x000fca00078ec0ffULL, 0x00000001243b7824ULL, 0x000fca00078e0235ULL,
0x01c180003b377984ULL, 0x000ea80000000800ULL, 0x01c380003b367984ULL, 0x0006620000000800ULL,
0x0000006c3700720bULL, 0x004fe20003f1d000ULL, 0x000143b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000247806ULL, 0x008fc800000e0100ULL, 0x0000ffff243e7812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x0000000100247802ULL, 0x000fe20000000f00ULL,
0x000000ffff387224ULL, 0x000fd400078e006cULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000037500780cULL, 0x000fe40003f05270ULL, 0x0000006c3700720bULL, 0x000fe20003f34000ULL,
0x000143827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000397806ULL, 0x000fc400008e0100ULL,
0x000000376c387209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991039347816ULL, 0x000fc600000000ffULL, 0x01c580383b008388ULL, 0x0005e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000386c347221ULL, 0x004fe20000010000ULL, 0x000000ff39ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL,
0x00000034003d7308ULL, 0x000ea40000000800ULL, 0x0000003d21217220ULL, 0x004fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000142e27f007947ULL, 0x000fea000b800000ULL,
0x00001f783d347589ULL, 0x0004e400000e0000ULL, 0x0000003420207220ULL, 0x088fe40000410000ULL,
0x000000341f1f7220ULL, 0x080fe40000410000ULL, 0x000000341c1c7220ULL, 0x080fe40000410000ULL,
0x000000341b1b7220ULL, 0x080fe40000410000ULL, 0x0000003418187220ULL, 0x080fe40000410000ULL,
0x0000003417177220ULL, 0x000fc40000410000ULL, 0x0000003414147220ULL, 0x080fe40000410000ULL,
0x0000003413137220ULL, 0x080fe40000410000ULL, 0x0000003410107220ULL, 0x080fe40000410000ULL,
0x000000340f0f7220ULL, 0x080fe40000410000ULL, 0x000000340c0c7220ULL, 0x080fe40000410000ULL,
0x000000340b0b7220ULL, 0x000fc40000410000ULL, 0x0000003408087220ULL, 0x080fe40000410000ULL,
0x0000003407077220ULL, 0x080fe40000410000ULL, 0x0000003404047220ULL, 0x080fe40000410000ULL,
0x0000003431317220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000142127f007947ULL, 0x000fea000b800000ULL, 0x00001f763d347589ULL, 0x0006a400000e0000ULL,
0x000000341e1e7220ULL, 0x084fe40000410000ULL, 0x000000341d1d7220ULL, 0x080fe40000410000ULL,
0x000000341a1a7220ULL, 0x080fe40000410000ULL, 0x0000003419197220ULL, 0x080fe40000410000ULL,
0x0000003416167220ULL, 0x080fe40000410000ULL, 0x0000003415157220ULL, 0x000fc40000410000ULL,
0x0000003412127220ULL, 0x080fe40000410000ULL, 0x0000003411117220ULL, 0x080fe40000410000ULL,
0x000000340e0e7220ULL, 0x080fe40000410000ULL, 0x000000340d0d7220ULL, 0x080fe40000410000ULL,
0x000000340a0a7220ULL, 0x080fe40000410000ULL, 0x0000003409097220ULL, 0x000fc40000410000ULL,
0x0000003406067220ULL, 0x080fe40000410000ULL, 0x0000003405057220ULL, 0x080fe40000410000ULL,
0x0000003432327220ULL, 0x080fe40000410000ULL, 0x0000003433337220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x004fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806039ULL,
0x8000003837370221ULL, 0x000fe20000010000ULL, 0x00007610ff240816ULL, 0x000fc60000000024ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700250308ULL, 0x000ea40000000800ULL,
0x0000002536360220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000002136217221ULL, 0x002fe40000010000ULL, 0x000000ffff6c7224ULL, 0x000fc400078e0038ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff24ff7812ULL, 0x000fe2000786c0ffULL,
0x0000016000017945ULL, 0x000fd80003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x000140727f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x000140d27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x00000037003a7202ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001409000347802ULL, 0x000fc40000000f00ULL,
0x0001486000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0001410000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000147f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001380028347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002954783bULL, 0x000fe20000004200ULL,
0x000138002c387811ULL, 0x000fe200078e20ffULL, 0x000003b000017945ULL, 0x000fe20003800000ULL,
0x000000877800720cULL, 0x000fe20003f46070ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x000000776e00720cULL, 0x000fc40003fc3070ULL, 0x000000877600720cULL, 0x000fe20003f26070ULL,
0x000000002a5c783bULL, 0x000fe20000004200ULL, 0x000000776e00720cULL, 0x000fc60003f03070ULL,
0x000000002b64783bULL, 0x000fe80000004200ULL, 0x000000002d3c783bULL, 0x00afe80000004200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000002e40783bULL, 0x000ee80000004200ULL,
0x000000002f44783bULL, 0x000f280000004200ULL, 0x000000003048783bULL, 0x000ee80000004200ULL,
0x00000000744c783bULL, 0x000ee20000004200ULL, 0x000000263434b232ULL, 0x004fc40000000000ULL,
0x000000263636b232ULL, 0x000fe40000000000ULL, 0x000000273535b232ULL, 0x080fe40000000000ULL,
0x000000273737b232ULL, 0x000fce0000000000ULL, 0x000000543450723cULL, 0x000f6200000018ffULL,
0x000000263838b232ULL, 0x082fe40000000000ULL, 0x000000263a3ab232ULL, 0x000fe40000000000ULL,
0x000000273939b232ULL, 0x000fc60000000000ULL, 0x0000005c3458723cULL, 0x000fe200000018ffULL,
0x000000273b3bb232ULL, 0x000fce0000000000ULL, 0x000000643460723cULL, 0x040ff000000018ffULL,
0x000000563454723cULL, 0x040f7000000018ffULL, 0x0000005e345c723cULL, 0x040f7000000018ffULL,
0x000000663464723cULL, 0x040f7000000018ffULL, 0x0000003c3468723cULL, 0x040b6e00000018ffULL,
0x00000001873d7810ULL, 0x020fe20007ffe0ffULL, 0x0000003e3434723cULL, 0x000f6600000018ffULL,
0x0000003d7800720cULL, 0x000fc40005746470ULL, 0x0000003d7600720cULL, 0x000fc60004f26470ULL,
0x000000403850723cULL, 0x048b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x050b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x020b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x000fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x020fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x000fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x020fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff347f8cULL, 0x020e62000c80043fULL,
0x000000776e00720cULL, 0x0c0fe40003fc3070ULL, 0x000000776e00720cULL, 0x000fc40003f03070ULL,
0x00000040ff3f7803ULL, 0x000fe40000000000ULL, 0x00000002ff347819ULL, 0x002fe4000001163dULL,
0x00000035003c7202ULL, 0x000fe40000000f00ULL, 0x000000343d347207ULL, 0x000fc80002800000ULL,
0x0000000334367810ULL, 0x000fe40007ffe0ffULL, 0x000000033d347812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e00ffULL, 0x00000002ff387819ULL, 0x000fe40000011636ULL,
0x000000ff34347207ULL, 0x000fe40006800000ULL, 0x0000000336367812ULL, 0x000fe200078ec0ffULL,
0x0000030038357a24ULL, 0x000fc400078e0277ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8400ff3a7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x800000003aff7812ULL, 0x002fe200078c4885ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000103d00780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fcc0000015200ULL,
0x0000003a383a7210ULL, 0x000fca0007fde1ffULL, 0x000000013b3b7824ULL, 0x000fe200030e0e39ULL,
0x003d09003a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff377819ULL, 0x000fc8000001143bULL, 0x0000003a37377211ULL, 0x000fca00078d10ffULL,
0x000000ffff3a7224ULL, 0x000fca00030e063bULL, 0x0000000237377819ULL, 0x000fc8000000123aULL,
0x000000370000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01cb8400ff3a7984ULL, 0x000e640000000800ULL, 0x800000003aff7812ULL, 0x002fe400078c4885ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fc40000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fc800078d10ffULL, 0x0000003bff3a7210ULL, 0x000fc800037fe4ffULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000135377810ULL, 0x000fe20007ffe0ffULL, 0x0000120000017945ULL, 0x000fe60003800000ULL,
0x000000703700720cULL, 0x000fda0003fc6070ULL, 0x000009a00000e947ULL, 0x000fea0003800000ULL,
0x000000046f407824ULL, 0x000fe400078e00ffULL, 0x0000004003417824ULL, 0x000fe400078e026fULL,
0x00000200ff427424ULL, 0x000fe200078e00ffULL, 0x01ca000040377984ULL, 0x000e620000000800ULL,
0x00000010023a7824ULL, 0x000fca00078e00ffULL, 0x000001f03a437812ULL, 0x000fe200078ec0ffULL,
0x00000004373c7824ULL, 0x002fca00078e00ffULL, 0x01cac0003c377984ULL, 0x0002a40000000800ULL,
0x000000206f3c7824ULL, 0x002fe400078e00ffULL, 0x0000003722377224ULL, 0x004fc800078e0241ULL,
0x00005e0037387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x0000000435387824ULL, 0x000fc600078e0236ULL, 0x00000039ff3b7210ULL, 0x000fe200037fe4ffULL,
0x0000004038387824ULL, 0x000fca00078e00ffULL, 0x0000003871377217ULL, 0x000fca0007800000ULL,
0x0000000137387824ULL, 0x000fe400078e0a38ULL, 0x000000016f377824ULL, 0x000fc600078e0202ULL,
0x000000386f387217ULL, 0x040fe40007800000ULL, 0xffffffe03c397812ULL, 0x000fe400078ee237ULL,
0x000000386f377210ULL, 0x000fe40007ffe1ffULL, 0x0001400039457811ULL, 0x000fe400078e20ffULL,
0x000000ff3700720cULL, 0x000fda0003fc3070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca040040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000141387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000016f397810ULL, 0x000fe40007ffe0ffULL,
0x000000013700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca080040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000241387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3b7210ULL, 0x000fe400037fe4ffULL, 0x000000026f397810ULL, 0x000fe40007ffe0ffULL,
0x000000023700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca0c0040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000341387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e0639ULL, 0x000000036f397810ULL, 0x000fe40007ffe0ffULL,
0x000000033700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe200078e0202ULL,
0x0000000539397819ULL, 0x000fc800000006ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca100040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000441387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383a7210ULL, 0x000fca0007fde0ffULL,
0x000000ffff3b7224ULL, 0x000fe200030e0639ULL, 0x000000046f397810ULL, 0x000fe40007ffe0ffULL,
0x000000043700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e8000f101c46ULL, 0x01ca140040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000541387810ULL, 0x000fc80007ffe0ffULL,
0x01cac0003e397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fc800078e0238ULL,
0x00005e0039387625ULL, 0x000fca00078e0042ULL, 0x00000043383c7210ULL, 0x000fc80007fde0ffULL,
0x00000039ff3d7210ULL, 0x000fe400037fe4ffULL, 0x000000056f397810ULL, 0x000fe40007ffe0ffULL,
0x000000053700780cULL, 0x000fc60003fc3070ULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003c457faeULL, 0x0003e8000f101c46ULL, 0x01ca180040387984ULL, 0x000ea40000000800ULL,
0x00000004383e7824ULL, 0x004fe200078e00ffULL, 0x0000000641387810ULL, 0x040fe40007ffe0ffULL,
0x0000000741417810ULL, 0x000fe40007ffe0ffULL, 0x01cac0003e397984ULL, 0x000ea40000000800ULL,
0x0000003922397224ULL, 0x004fc800078e0238ULL, 0x00005e0039387625ULL, 0x000fca00078e0042ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000066f397810ULL, 0x000fe40007ffe0ffULL, 0x000000063700780cULL, 0x000fc60003fc3070ULL,
0x0000000139387824ULL, 0x040fe200078e0202ULL, 0x0000000539397819ULL, 0x000fc800000006ffULL,
0xffffffe039387812ULL, 0x000fc800078ee238ULL, 0x00014000383d7811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000f101c46ULL,
0x01ca1c0040387984ULL, 0x000ea40000000800ULL, 0x00000004383c7824ULL, 0x004fca00078e00ffULL,
0x01cac0003c397984ULL, 0x000ea40000000800ULL, 0x0000003922397224ULL, 0x004fe200078e0241ULL,
0x000000076f417810ULL, 0x000fc60007ffe0ffULL, 0x00005e0039387625ULL, 0x000fc800078e0042ULL,
0x00000001413e7824ULL, 0x040fe200078e0202ULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x0000002041417824ULL, 0x000fc800078e00ffULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x000000073700780cULL, 0x000fe40003fc3070ULL, 0xffffffe0413e7812ULL, 0x000fc800078ee23eULL,
0x000140003e3b7811ULL, 0x002fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e2000f101c46ULL, 0x0000083000007947ULL, 0x000fea0003800000ULL,
0x0000006f023e7211ULL, 0x040fe200078fd8ffULL, 0x00000010023a7824ULL, 0x000fe200078e00ffULL,
0x0000020000417802ULL, 0x000fc60000000f00ULL, 0x01ca00003e377984ULL, 0x000e620000004800ULL,
0x0000004003407824ULL, 0x000fe200078e023eULL, 0x000001f03a437812ULL, 0x000fe400078ec0ffULL,
0x01cac00037377984ULL, 0x002e640000004800ULL, 0x0000003722387224ULL, 0x002fc800078e0240ULL,
0x00005e0038387625ULL, 0x000fca00078e0041ULL, 0x00000043383a7210ULL, 0x000fe20007fde0ffULL,
0x000000013e387824ULL, 0x000fc800078e0202ULL, 0x000000ffff3b7224ULL, 0x000fe400030e0639ULL,
0x000000203e397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x000fe400078e20ffULL, 0x0000000140387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca04003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000013e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000240387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca08003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000023e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000340387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca0c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000033e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000440387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca10003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000043e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000540387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x01ca14003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383c7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3d7224ULL, 0x000fe200030e0639ULL,
0x000000053e397810ULL, 0x000fc80007ffe0ffULL, 0x0000000239387210ULL, 0x040fe20007ffe0ffULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x0001400038457811ULL, 0x002fe400078e20ffULL, 0x0000000640387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x01ca18003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fca00078e0041ULL,
0x00000043383a7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff3b7224ULL, 0x000fe200030e0639ULL,
0x000000063e397810ULL, 0x000fca0007ffe0ffULL, 0x0000000139387824ULL, 0x040fe400078e0202ULL,
0x0000002039397824ULL, 0x000fca00078e00ffULL, 0xffffffe039387812ULL, 0x000fc800078ee238ULL,
0x00014000383d7811ULL, 0x002fe400078e20ffULL, 0x0000000740387810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x01ca1c003e377984ULL, 0x000ea80000004800ULL, 0x01cac00037377984ULL, 0x004ea40000004800ULL,
0x0000003722387224ULL, 0x004fc800078e0238ULL, 0x00005e0038387625ULL, 0x000fe200078e0041ULL,
0x000000073e417810ULL, 0x000fc80007ffe0ffULL, 0x00000002413c7210ULL, 0x040fe20007ffe0ffULL,
0x0000002041417824ULL, 0x000fe200078e00ffULL, 0x0000004338387210ULL, 0x000fc80007fde0ffULL,
0xffffffe0413c7812ULL, 0x000fe200078ee23cULL, 0x000000ffff397224ULL, 0x000fc600030e0639ULL,
0x000140003c3b7811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000383b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb8800ff387f8cULL, 0x002e64000c80043fULL,
0x000000ffff3c7224ULL, 0x002fc400078e0039ULL, 0x0000000000387805ULL, 0x000fca0000015200ULL,
0x01cb8c00ff377984ULL, 0x000e620000000800ULL, 0x000000ffff3d7224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000037ff7812ULL, 0x002fe200078c483cULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000103d00780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a383a7210ULL, 0x000fca0007fde1ffULL,
0x000000013b3b7824ULL, 0x000fe200030e0e39ULL, 0x003d09003a00780cULL, 0x000fc80003fc6070ULL,
0x000000ff3b00720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003fc6070ULL, 0x000000ff3b00720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff377819ULL, 0x000fc8000001143bULL,
0x0000003a37377211ULL, 0x000fca00078d10ffULL, 0x000000ffff3a7224ULL, 0x000fca00030e063bULL,
0x0000000237377819ULL, 0x000fc8000000123aULL, 0x000000370000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013d3d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01cb8c00ff377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x002fe400078c483cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000356e00720cULL, 0x000fc80003fc4070ULL, 0x000000ff34377207ULL, 0x040fe40003000000ULL,
0x000000ff34387207ULL, 0x000fe40007000000ULL, 0x0000003736377210ULL, 0x000fc80007ffe0ffULL,
0x00000002ff347819ULL, 0x000fe20000011637ULL, 0x0000004037377824ULL, 0x000fc800078e00ffULL,
0x0000030034347a24ULL, 0x000fe200078e0235ULL, 0x000000c037377812ULL, 0x000fe200078ec0ffULL,
0x0000000173357824ULL, 0x000fc800078e0238ULL, 0x0000010034347824ULL, 0x000fe200078e0237ULL,
0x0001ca0023377811ULL, 0x000fc800078e10ffULL, 0x0000002034367810ULL, 0x000fca0007ffe0ffULL,
0x0000680035347a24ULL, 0x000fe200078e0236ULL, 0x0000003623367210ULL, 0x040fe20007ffe0ffULL,
0x00000004ff357424ULL, 0x000fe400078e00ffULL, 0x0000000123347824ULL, 0x000fe200078e0234ULL,
0x000000713600720cULL, 0x000fc60003fc6070ULL, 0x0000660034347625ULL, 0x000fd400078e0035ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e4000f121846ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01cb7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cb7800ff847f8cULL, 0x000e62000c80043fULL,
0x0000016000017945ULL, 0x000fe20003800000ULL, 0x0000014000003947ULL, 0x000fea0003800000ULL,
0x00000025ff26723eULL, 0x000fc800000000ffULL, 0x0000541026377816ULL, 0x000fe20000000026ULL,
0x00011e727f007947ULL, 0x000fea000b800000ULL, 0x00001f7837267589ULL, 0x0004e400000e0000ULL,
0x00011ed27f007947ULL, 0x000fea000b800000ULL, 0x00001f7637277589ULL, 0x0004e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010783b7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001639000347802ULL, 0x000fc40000000f00ULL,
0x0001256000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0037ULL, 0x00000018783b7810ULL, 0x002fe20007ffe0ffULL,
0x0000001fff3c7424ULL, 0x000fe200078e00ffULL, 0x0001640000347802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000124f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0001380082347811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000ff3f00720cULL, 0x000fe20003fc5270ULL,
0x000000008154783bULL, 0x000fe20000004200ULL, 0x000138007d387811ULL, 0x000fe200078e20ffULL,
0x0000034000017945ULL, 0x000fe40003800000ULL, 0x000000003434783bULL, 0x004ea80000000200ULL,
0x00000000805c783bULL, 0x000fe80000004200ULL, 0x000000007f64783bULL, 0x000fe80000004200ULL,
0x000000007e3c783bULL, 0x002fe80000004200ULL, 0x000000003838783bULL, 0x000e680000000200ULL,
0x000000007c40783bULL, 0x000f280000004200ULL, 0x000000007b44783bULL, 0x000ee80000004200ULL,
0x000000007a48783bULL, 0x000ee80000004200ULL, 0x00000000794c783bULL, 0x000ee40000004200ULL,
0x000000263434b232ULL, 0x00cfc40000000000ULL, 0x000000263636b232ULL, 0x000fe40000000000ULL,
0x000000273535b232ULL, 0x080fe40000000000ULL, 0x000000273737b232ULL, 0x000fce0000000000ULL,
0x000000543450723cULL, 0x000f6200000018ffULL, 0x000000263838b232ULL, 0x082fe40000000000ULL,
0x000000263a3ab232ULL, 0x000fe40000000000ULL, 0x000000273939b232ULL, 0x000fc60000000000ULL,
0x0000005c3458723cULL, 0x000fe200000018ffULL, 0x000000273b3bb232ULL, 0x000fce0000000000ULL,
0x000000643460723cULL, 0x040ff000000018ffULL, 0x000000563454723cULL, 0x040f7000000018ffULL,
0x0000005e345c723cULL, 0x040f7000000018ffULL, 0x000000663464723cULL, 0x040f7000000018ffULL,
0x0000003c3468723cULL, 0x040f7000000018ffULL, 0x0000003e3434723cULL, 0x000f7000000018ffULL,
0x000000403850723cULL, 0x070b700000001850ULL, 0x000000423854723cULL, 0x040b700000001854ULL,
0x000000443858723cULL, 0x040b700000001858ULL, 0x00000046385c723cULL, 0x040b70000000185cULL,
0x000000483860723cULL, 0x040b700000001860ULL, 0x0000004a3864723cULL, 0x040b700000001864ULL,
0x0000004c3868723cULL, 0x040b700000001868ULL, 0x0000004e3834723cULL, 0x000b620000001834ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x0000005020207221ULL, 0x020fe40000010000ULL, 0x000000511f1f7221ULL, 0x000fc40000010000ULL,
0x000000541c1c7221ULL, 0x000fe40000010000ULL, 0x000000551b1b7221ULL, 0x000fe40000010000ULL,
0x0000005818187221ULL, 0x000fe40000010000ULL, 0x0000005917177221ULL, 0x000fe40000010000ULL,
0x0000005c14147221ULL, 0x000fe40000010000ULL, 0x0000005d13137221ULL, 0x000fc40000010000ULL,
0x0000006010107221ULL, 0x000fe40000010000ULL, 0x000000610f0f7221ULL, 0x000fe40000010000ULL,
0x000000640c0c7221ULL, 0x000fe40000010000ULL, 0x000000650b0b7221ULL, 0x000fe40000010000ULL,
0x0000006808087221ULL, 0x000fe40000010000ULL, 0x0000006907077221ULL, 0x000fc40000010000ULL,
0x0000003404047221ULL, 0x000fe40000010000ULL, 0x0000003531317221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x000000521e1e7221ULL, 0x020fe40000010000ULL,
0x000000531d1d7221ULL, 0x000fe40000010000ULL, 0x000000561a1a7221ULL, 0x000fe40000010000ULL,
0x0000005719197221ULL, 0x000fe40000010000ULL, 0x0000005a16167221ULL, 0x000fc40000010000ULL,
0x0000005b15157221ULL, 0x000fe40000010000ULL, 0x0000005e12127221ULL, 0x000fe40000010000ULL,
0x0000005f11117221ULL, 0x000fe40000010000ULL, 0x000000620e0e7221ULL, 0x000fe40000010000ULL,
0x000000630d0d7221ULL, 0x000fe40000010000ULL, 0x000000660a0a7221ULL, 0x000fc40000010000ULL,
0x0000006709097221ULL, 0x000fe40000010000ULL, 0x0000006a06067221ULL, 0x000fe40000010000ULL,
0x0000006b05057221ULL, 0x000fe40000010000ULL, 0x0000003632327221ULL, 0x000fe40000010000ULL,
0x0000003733337221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000187877810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb8800ff347f8cULL, 0x020e62000c80043fULL, 0x000000838700720cULL, 0x000fe20003f06070ULL,
0x000000ffff377224ULL, 0x002fd800078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb08000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01cb7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030077777a10ULL, 0x000fc80007ffe0ffULL,
0x000000707700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffeba0000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000297919ULL, 0x000e620000002500ULL, 0x0000000400287202ULL, 0x000fe20000000f00ULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x0000000a00237202ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0006ULL, 0x000000ffff257224ULL, 0x000fe400078e0007ULL,
0x000000ffff247224ULL, 0x000fe400078e0008ULL, 0x000000ffff227224ULL, 0x000fc400078e0009ULL,
0x000000ffff047224ULL, 0x000fe400078e000dULL, 0x000000ffff057224ULL, 0x000fe200078e000eULL,
0x000000702900720cULL, 0x002fda0003f06070ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000021027810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e0021ULL,
0x00016b8000077802ULL, 0x000fc40000000f00ULL, 0x00011ba000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0006ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002100027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc80000000021ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fc40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x00000002ff3b7819ULL, 0x004fe20000011603ULL, 0x000116427f007947ULL, 0x000fea000b800000ULL,
0x00001f3b02037589ULL, 0x0004e400000e0000ULL, 0x0000000000067919ULL, 0x000f220000000000ULL,
0x0000002003207220ULL, 0x048fe40000410000ULL, 0x0000001f031f7220ULL, 0x040fe40000410000ULL,
0x0000001c031c7220ULL, 0x040fe40000410000ULL, 0x0000001b031b7220ULL, 0x000fc40000410000ULL,
0x0000001803187220ULL, 0x040fe40000410000ULL, 0x0000001703177220ULL, 0x040fe40000410000ULL,
0x0000001403147220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000001003107220ULL, 0x040fe40000410000ULL, 0x0000000f030f7220ULL, 0x000fc40000410000ULL,
0x0000000c030c7220ULL, 0x040fe40000410000ULL, 0x0000000b030b7220ULL, 0x040fe20000410000ULL,
0x00000008063b7811ULL, 0x016fe200078ff0ffULL, 0x0000002403247220ULL, 0x040fe40000410000ULL,
0x0000002503257220ULL, 0x040fe40000410000ULL, 0x0000002803287220ULL, 0x040fe40000410000ULL,
0x0000003103317220ULL, 0x000fe20000410000ULL, 0x000115727f007947ULL, 0x000fea000b800000ULL,
0x00001f3b02027589ULL, 0x0002a400000e0000ULL, 0x0000001e021e7220ULL, 0x044fe40000410000ULL,
0x0000001d021d7220ULL, 0x000fc40000410000ULL, 0x0000001a021a7220ULL, 0x040fe40000410000ULL,
0x0000001902197220ULL, 0x040fe40000410000ULL, 0x0000001602167220ULL, 0x040fe40000410000ULL,
0x0000001502157220ULL, 0x040fe40000410000ULL, 0x0000001202127220ULL, 0x040fe40000410000ULL,
0x0000001102117220ULL, 0x000fc40000410000ULL, 0x0000000502057220ULL, 0x040fe40000410000ULL,
0x0000000402047220ULL, 0x040fe40000410000ULL, 0x0000002302237220ULL, 0x040fe40000410000ULL,
0x0000002202227220ULL, 0x040fe40000410000ULL, 0x0000002702277220ULL, 0x040fe40000410000ULL,
0x0000002602267220ULL, 0x000fc40000410000ULL, 0x0000003202327220ULL, 0x040fe40000410000ULL,
0x0000003302337220ULL, 0x000fc40000410000ULL, 0x000000100f08723eULL, 0x000fe200000000ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000141307723eULL, 0x000fe400000000ffULL,
0x0000000c0b09723eULL, 0x000fe400000000ffULL, 0x00000012110f723eULL, 0x000fe400000000ffULL,
0x000000201f02723eULL, 0x000fc400000000ffULL, 0x0000001c1b03723eULL, 0x000fe400000000ffULL,
0x000000181706723eULL, 0x000fe400000000ffULL, 0x00000024250a723eULL, 0x000fe400000000ffULL,
0x00000028310b723eULL, 0x000fe400000000ffULL, 0x0000001e1d0c723eULL, 0x000fe400000000ffULL,
0x0000001a190d723eULL, 0x000fc400000000ffULL, 0x00000016150e723eULL, 0x000fe400000000ffULL,
0x000000050410723eULL, 0x000fe400000000ffULL, 0x000000232211723eULL, 0x000fe400000000ffULL,
0x000000272612723eULL, 0x000fe400000000ffULL, 0x000000323313723eULL, 0x000fc400000000ffULL,
0x0000000000197919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff1b7819ULL, 0x004fc40000011619ULL, 0x0000000819247811ULL, 0x000fe400078ff0ffULL,
0x000000011b047810ULL, 0x040fe20007ffe0ffULL, 0x000000081b157824ULL, 0x040fe200078e00ffULL,
0x000000021b057810ULL, 0x040fe20007ffe0ffULL, 0x000000081b187824ULL, 0x040fe200078e00ffULL,
0x000000051b147810ULL, 0x040fe20007ffe0ffULL, 0x000000081b177824ULL, 0x000fe200078e00ffULL,
0xfffffff815167812ULL, 0x000fe200078ee204ULL, 0x000000081b1d7824ULL, 0x040fe200078e00ffULL,
0x000000031b047810ULL, 0x040fe20007ffe0ffULL, 0x000000081b1c7824ULL, 0x040fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x000000081b227824ULL, 0x040fe200078e00ffULL,
0x000000061b157810ULL, 0x000fc40007ffe0ffULL, 0x000000031b207819ULL, 0x000fe400000006ffULL,
0xfffffff8171a7812ULL, 0x000fe200078ee204ULL, 0x0000080075047824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1e7812ULL, 0x000fe200078ee214ULL, 0x000000081b147824ULL, 0x040fe200078e00ffULL,
0x000000041b057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee215ULL,
0x0000000419157824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fc400078ee205ULL,
0xfffffff814147812ULL, 0x000fe400078ee21bULL, 0x0001200004057810ULL, 0x000fe40007ffe0ffULL,
0xffffffff1b177810ULL, 0x000fe20007ffe0ffULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x0000001016167824ULL, 0x100fe200078e0205ULL,
0x0000000514147211ULL, 0x080fe200078e20ffULL, 0x0000001018187824ULL, 0x000fe200078e0205ULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000101a1a7824ULL, 0x100fe200078e0205ULL,
0xfffffff81b247812ULL, 0x000fe200078ee224ULL, 0x000000101c1c7824ULL, 0x000fe200078e0205ULL,
0x0000000520207211ULL, 0x000fe200078e20ffULL, 0x0000000114177824ULL, 0x000fe200078e0215ULL,
0x0000001a151a7210ULL, 0x000fe20007ffe0ffULL, 0x000000101e1e7824ULL, 0x000fc400078e0205ULL,
0x0000000115167824ULL, 0x040fe200078e0216ULL, 0x0000000217007388ULL, 0x0005e20000000800ULL,
0x0000000115197824ULL, 0x040fe400078e0218ULL, 0x0000001022227824ULL, 0x100fe200078e0205ULL,
0x0000000316007388ULL, 0x0005e20000000800ULL, 0x0000001024247824ULL, 0x000fe400078e0205ULL,
0x00000001151b7824ULL, 0x040fe200078e021cULL, 0x0000000619007388ULL, 0x0005e20000000800ULL,
0x00000001151e7824ULL, 0x000fc400078e021eULL, 0x00000001151d7824ULL, 0x040fe200078e0220ULL,
0x000000071a007388ULL, 0x0005e20000000800ULL, 0x0000000115227824ULL, 0x040fe400078e0222ULL,
0x0000000115157824ULL, 0x000fe200078e0224ULL, 0x000000081b007388ULL, 0x0005e80000000800ULL,
0x000000091e007388ULL, 0x0005e80000000800ULL, 0x0000000a1d007388ULL, 0x0005e80000000800ULL,
0x0000000b22007388ULL, 0x0005e80000000800ULL, 0x0000000c15007388ULL, 0x0005e80000000800ULL,
0x0004000d16007388ULL, 0x0005e80000000800ULL, 0x0004000e19007388ULL, 0x0005e80000000800ULL,
0x0004000f1a007388ULL, 0x0005e80000000800ULL, 0x000400101b007388ULL, 0x0005e80000000800ULL,
0x000400111e007388ULL, 0x0005e80000000800ULL, 0x000400121d007388ULL, 0x0005e80000000800ULL,
0x0004001322007388ULL, 0x0005e20000000800ULL, 0x0000003000007947ULL, 0x000fea0003800000ULL,
0xffffffff00257802ULL, 0x000fe40000000f00ULL, 0x000173f000247802ULL, 0x000fc40000000f00ULL,
0x000115b000007944ULL, 0x006fea0003c00000ULL, 0x00000300ff157624ULL, 0x004fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000011500780cULL, 0x000fda0003f05270ULL,
0x0000267000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x00005800ff027624ULL, 0x000fc600078e00ffULL, 0x00000000000b7919ULL, 0x000ee20000002600ULL,
0x00006c0002027a24ULL, 0x000fc800078e02ffULL, 0x0000030002077a24ULL, 0x040fe200078e02ffULL,
0x0000000f02037811ULL, 0x000fc800078e10ffULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080070e7824ULL, 0x000fc800078e020cULL, 0x0000008007027824ULL, 0x000fe400078e020eULL,
0x0000001006097824ULL, 0x004fe400078e0204ULL, 0x0000580000077a24ULL, 0x008fe200078e020bULL,
0x0000007f02027810ULL, 0x000fe40007ffe0ffULL, 0x0120000009107984ULL, 0x0004e20000000c00ULL,
0x00000300070f7a24ULL, 0x000fe200078e02ffULL, 0xffffff80020d7812ULL, 0x000fc800078ec0ffULL,
0x000000290f087210ULL, 0x000fe40007ffe0ffULL, 0x000070000d037a10ULL, 0x000fc80007f1e0ffULL,
0x0000000308027211ULL, 0x000fe200078258ffULL, 0x00007100ff037624ULL, 0x000fe200000e06ffULL,
0x000070000c147a10ULL, 0x000fc80007f1e0ffULL, 0x0000000308037211ULL, 0x000fe200008f5cffULL,
0x00007100ff167624ULL, 0x000fe200000e06ffULL, 0x000000ff7500720cULL, 0x000fc60003f25270ULL,
0x0000020075027825ULL, 0x000fcc00078e0002ULL, 0x0000001006027825ULL, 0x000fc800078e0002ULL,
0x0000011000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x004ea20000000000ULL,
0x0000008008097824ULL, 0x000fe400078e00ffULL, 0x000000100a0b7824ULL, 0x004fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe4000001160aULL, 0x00007000090a7a10ULL, 0x000fe40007b5e00eULL,
0x000000700b177812ULL, 0x000fe400078ec0ffULL, 0x00000019ff0b7819ULL, 0x000fc40000011608ULL,
0x0000000c18187812ULL, 0x000fe400078ec0ffULL, 0x0000001417097210ULL, 0x000fe4000791e009ULL,
0x000071000b197a10ULL, 0x000fe400017e64ffULL, 0x0000000918087210ULL, 0x040fe40007f5e0ffULL,
0x00000016ff097210ULL, 0x000fe400007e240bULL, 0x0000000a180a7210ULL, 0x000fc60007c7e017ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x00000019ff0b7210ULL, 0x000fc80001fe84ffULL,
0x0000006c08007986ULL, 0x0005e8000c101906ULL, 0x000000210a007986ULL, 0x0005e4000c101906ULL,
0x000000ff0600720cULL, 0x004fe20003f05270ULL, 0x0000001002007986ULL, 0x008fe2000c101d06ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff7500720cULL, 0x000fda0000705670ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x0000000400027802ULL, 0x000fe40000000f00ULL, 0xffffffff15097810ULL, 0x000fc60007ffe0ffULL,
0x0000700007027625ULL, 0x000fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fc80003f05270ULL,
0x00000001ff077807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x000ee40000000000ULL,
0x000000ff0200720cULL, 0x008fda0003f05270ULL, 0x0000220000008947ULL, 0x000fea0003800000ULL,
0x000000ff7500720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001006037824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe40000011606ULL,
0x000000140f027211ULL, 0x000fe400078038ffULL, 0x0000007003077812ULL, 0x004fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x000000160f037211ULL, 0x000fe400000f3cffULL,
0x0000000208027210ULL, 0x000fc8000791e007ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602077981ULL, 0x000528000c1e1900ULL, 0x0000800602087981ULL, 0x000522000c1e1900ULL,
0x000000021500780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010006020a7981ULL, 0x004522000c1e1900ULL, 0x000000041500780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800602107981ULL, 0x004522000c1e1900ULL,
0x000000041500780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000602127981ULL, 0x004522000c1e1900ULL, 0x000000061500780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800602147981ULL, 0x004522000c1e1900ULL,
0x000000061500780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081500780cULL, 0x004fe20003f06070ULL, 0x0003000602167981ULL, 0x000518000c1e1900ULL,
0x0003800602180981ULL, 0x000524000c1e1900ULL, 0x0000000715027810ULL, 0x004fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011602ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000c0f0b7211ULL, 0x000fe200078038ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1a7224ULL, 0x010fe200078e0007ULL, 0x000070000b0b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0f117211ULL, 0x000fe400000f3cffULL, 0x000007800b0b7810ULL, 0x000fc80007f5e0ffULL,
0x00007100ff117a10ULL, 0x000fc400017e2411ULL, 0x0000030013007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000409007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x014fea0003800000ULL, 0x0000000813027810ULL, 0x040fe40007ffe0ffULL,
0x0000000113037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001a07077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffc8006021a7981ULL, 0x000526000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000913027810ULL, 0x044fe40007ffe0ffULL,
0x0000000213037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000807077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffd000602087981ULL, 0x000526000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a13027810ULL, 0x044fe40007ffe0ffULL,
0x0000000313037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000a07077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffd8006020a7981ULL, 0x000526000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b13027810ULL, 0x044fe40007ffe0ffULL,
0x0000000413037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001007077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffe000602107981ULL, 0x000526000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c13027810ULL, 0x044fe40007ffe0ffULL,
0x0000000513037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xfffe800602127981ULL, 0x000526000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d13027810ULL, 0x044fe40007ffe0ffULL,
0x0000000613037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001407077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xffff000602147981ULL, 0x000526000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e13027810ULL, 0x044fe40007ffe0ffULL,
0x0000000713037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0xffff800602167981ULL, 0x000526000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f13027810ULL, 0x004fe40007ffe0ffULL,
0x0000001807077209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000406027819ULL, 0x000fe400000006ffULL,
0x00000001ff037819ULL, 0x000fe40000011606ULL, 0x0000007002027812ULL, 0x000fc800078ec0ffULL,
0x0000000c02027812ULL, 0x000fc800078ef803ULL, 0x000000020b027210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff037224ULL, 0x000fca00008e0611ULL, 0x0000000602187981ULL, 0x000526000c1e1900ULL,
0x000004000b0b7810ULL, 0x000fe40007f3e0ffULL, 0x0000000813137810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ee40000000000ULL, 0x0000001006027824ULL, 0x00cfe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102027824ULL, 0x000fca00078e0203ULL,
0x0000000702007388ULL, 0x0105e40000000800ULL, 0x000070000d027a10ULL, 0x004fe20007f1e0ffULL,
0x0000020075417824ULL, 0x042fe200078e00ffULL, 0x00000017ff437819ULL, 0x000fe20000011675ULL,
0x0000100075117824ULL, 0x000fe200078e00ffULL, 0x0000000406077819ULL, 0x040fe200000006ffULL,
0x00007100ff037624ULL, 0x000fe200000e06ffULL, 0x000000070600780cULL, 0x040fe20003f04070ULL,
0x0000001006137824ULL, 0x000fe200078e0211ULL, 0x00000001ff0a7819ULL, 0x000fe20000011606ULL,
0x000008000f087825ULL, 0x000fe200078e0002ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000004108087210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001075178824ULL, 0x000fe200078e0206ULL, 0x000070000c447a10ULL, 0x000fe20007f5e0ffULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x000070000e407a10ULL, 0x000fe20007f3e0ffULL,
0x0000000107077824ULL, 0x000fe200078e020aULL, 0x0000000675158211ULL, 0x000fe200078e20ffULL,
0x00007100ff467624ULL, 0x000fe200010e06ffULL, 0x000000440f0c8211ULL, 0x040fe200078438ffULL,
0x00007100ff427624ULL, 0x000fe200008e06ffULL, 0x000000400f0a8211ULL, 0x040fe200078238ffULL,
0x0000001006087825ULL, 0x040fe200078e0008ULL, 0x000000460f0d8211ULL, 0x040fe200010f3cffULL,
0x0000000007077984ULL, 0x000e620000000800ULL, 0x000000420f0b8211ULL, 0x000fe200008f3cffULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000010060c8825ULL, 0x040fe200078e000cULL, 0x0000458015158811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008137faeULL, 0x0005e2000b901c46ULL,
0x0000418017178811ULL, 0x000fe200078e20ffULL, 0x00000010060a8825ULL, 0x000fe200078e000aULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000000a158faeULL, 0x0007e2000b901c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000000c178faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x008fe2000001ff00ULL, 0x000000ff00307202ULL, 0x000fe20000000f00ULL,
0x0000000000167805ULL, 0x010fe2000001ff00ULL, 0x00000bb000009947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fc400078e00ffULL,
0x00000001ff477424ULL, 0x000fca00078e00ffULL, 0x0000030047007a0cULL, 0x000fda0003f06070ULL,
0x000001c000000947ULL, 0x000fea0003800000ULL, 0x000000070600780cULL, 0x000fe20003f44070ULL,
0x000008000f087825ULL, 0x000fe200078e0002ULL, 0x00000001470c7812ULL, 0x000fc600078ec0ffULL,
0x00000800470a7824ULL, 0x000fe200078e00ffULL, 0x0000004108087210ULL, 0x000fc80007f1e0ffULL,
0x000008000a327812ULL, 0x000fe200078ec0ffULL, 0x0000000109097824ULL, 0x000fe400000e0643ULL,
0x00000002750ba824ULL, 0x040fe200078e020cULL, 0x0000000c750da211ULL, 0x000fe200078e08ffULL,
0x0000000111317824ULL, 0x000fe200078e0232ULL, 0x000000400f0aa211ULL, 0x000fe200078038ffULL,
0x000000080b33a824ULL, 0x100fe200078e0206ULL, 0x000000440f0ca211ULL, 0x000fe200078238ffULL,
0x000000080d35a824ULL, 0x000fe200078e0206ULL, 0x000000420f0ba211ULL, 0x040fe200000f3cffULL,
0x0000001006317824ULL, 0x040fe200078e0231ULL, 0x000000460f0da211ULL, 0x000fe200008f3cffULL,
0x0000001006087825ULL, 0x000fe200078e0008ULL, 0x000045803333a811ULL, 0x000fc400078e20ffULL,
0x000041803535a811ULL, 0x000fe200078e20ffULL, 0x00000010060aa825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008317faeULL, 0x0005e6000b901c46ULL,
0x00000010060ca825ULL, 0x000fe200078e000cULL, 0x000000000a33afaeULL, 0x0005e8000b901c46ULL,
0x000000000c35afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff47087810ULL, 0x004fc40007ffe0ffULL, 0x00000004060b7819ULL, 0x000fe400000006ffULL,
0x00000001ff0c7819ULL, 0x100fe20000011606ULL, 0x0000008008097824ULL, 0x040fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000080008087824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x00000080090a7812ULL, 0x000fe200078ec0ffULL,
0x0000000406097824ULL, 0x000fe200078e00ffULL, 0x00000002ff3a7819ULL, 0x000fc40000011606ULL,
0x0000080008087812ULL, 0x000fe200078ec0ffULL, 0x00000100750a7824ULL, 0x000fe200078e020aULL,
0x0000000c093c7812ULL, 0x000fe200078ec0ffULL, 0x000000083a327824ULL, 0x040fe200078e00ffULL,
0x000000083a3e7810ULL, 0x040fe20007ffe0ffULL, 0x000000083a097824ULL, 0x000fe200078e00ffULL,
0x0000000a0c0a7210ULL, 0x000fe20007ffe00bULL, 0x000000083a387824ULL, 0x040fe200078e00ffULL,
0x000000013a0b7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000a0c7984ULL, 0x000ea20000000800ULL, 0xfffffff832337812ULL, 0x000fe200078ee20bULL,
0x000000083a377824ULL, 0x040fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee23aULL,
0x004580000a317984ULL, 0x0007220000000800ULL, 0x0000018011087810ULL, 0x000fe20007ffe008ULL,
0x000000083a457824ULL, 0x000fe200078e00ffULL, 0x000000033e0b7819ULL, 0x000fe200000006ffULL,
0x000000083a487824ULL, 0x040fe200078e00ffULL, 0x000000023a0d7810ULL, 0x040fe20007ffe0ffULL,
0x0000001009097824ULL, 0x000fe200078e0208ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee23eULL,
0x000000083a0a7824ULL, 0x048fe200078e00ffULL, 0x000000033a327810ULL, 0x000fe20007ffe0ffULL,
0x000000013c097824ULL, 0x000fe200078e0209ULL, 0x000000053a347810ULL, 0x000fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x100fe200078e0208ULL, 0xfffffff80a357812ULL, 0x000fe200078ee20dULL,
0x00000010330a7824ULL, 0x000fe200078e0208ULL, 0xfffffff837337812ULL, 0x000fe200078ee232ULL,
0x0000000009097984ULL, 0x000ee20000000800ULL, 0x0000000b3c0d7210ULL, 0x040fe20007ffe0ffULL,
0x000000013c0a7824ULL, 0x000fe200078e020aULL, 0x000000043a0b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff845457812ULL, 0x000fe200078ee234ULL, 0x000000000d367984ULL, 0x0003e20000000800ULL,
0xfffffff838397812ULL, 0x000fe400078ee20bULL, 0x000000063a347810ULL, 0x040fe20007ffe0ffULL,
0x000000000a0b7984ULL, 0x000fe20000000800ULL, 0x0000030047007a0cULL, 0x000fe20003f06070ULL,
0x0000001039327824ULL, 0x100fe200078e0208ULL, 0x000000010f0f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010330d7824ULL, 0x002fe200078e0208ULL, 0xffffffff3a337810ULL, 0x000fe20007ffe0ffULL,
0x000000013c327824ULL, 0x000fe200078e0232ULL, 0x000400000a377984ULL, 0x000fe20000000800ULL,
0x0000000147477810ULL, 0x000fe20007ffe0ffULL, 0x0000000c070c7221ULL, 0x004fe20000010100ULL,
0xfffffff848397812ULL, 0x000fc400078ee233ULL, 0x0000000845337211ULL, 0x000fe200078e20ffULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x000000013c337824ULL, 0x000fe400078e0233ULL,
0x0000000c000c7308ULL, 0x000f240000000800ULL, 0x000000310c3b7220ULL, 0x010fe40000410000ULL,
0x00000010350c7824ULL, 0x000fe200078e0208ULL, 0x000000033a357819ULL, 0x000fe200000006ffULL,
0x000000013c317824ULL, 0x040fe200078e020dULL, 0x00001f3a3b3d7589ULL, 0x000e6200000e0000ULL,
0x000000013c0c7824ULL, 0x000fe200078e020cULL, 0xfffffff835357812ULL, 0x000fe200078ee234ULL,
0x000000303b307221ULL, 0x000fe20000010000ULL, 0x00000000310a7984ULL, 0x000ea60000000800ULL,
0x0000001035347824ULL, 0x100fe200078e0208ULL, 0x000000000c0d7984ULL, 0x000f220000000800ULL,
0x0000001039357824ULL, 0x000fc400078e0208ULL, 0x000000013c347824ULL, 0x040fe200078e0234ULL,
0x0000000032087984ULL, 0x000fe40000000800ULL, 0x000000353c357210ULL, 0x000fe20007ffe0ffULL,
0x20000009ff3c7230ULL, 0x108fe20000004100ULL, 0x000400000c387984ULL, 0x000fe20000000800ULL,
0x30000009ff097230ULL, 0x000fc60000004100ULL, 0x00040000323a7984ULL, 0x000fe80000000800ULL,
0x00000000330c7984ULL, 0x000fe20000000800ULL, 0x0000003d092e7223ULL, 0x082fe4000001002eULL,
0x0000003d3c2f7223ULL, 0x000fe2000001002fULL, 0x00001f3e3b3f7589ULL, 0x0002e200000e0000ULL,
0x20000037ff3c7230ULL, 0x100fe40000004100ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x0000000034097984ULL, 0x000ee80000000800ULL, 0x0004000034327984ULL, 0x0004e20000000800ULL,
0x20000036ff3e7230ULL, 0x002fc40000004100ULL, 0x30000036ff3b7230ULL, 0x000fe20000004100ULL,
0x0004000031397984ULL, 0x000e620000000800ULL, 0x2000000bff367230ULL, 0x100fe40000004100ULL,
0x3000000bff0b7230ULL, 0x000fe20000004100ULL, 0x0004000033317984ULL, 0x000e620000000800ULL,
0x2000000aff347230ULL, 0x004fe20000004100ULL, 0x0000003d362b7223ULL, 0x080fe2000001002bULL,
0x2000000dff367230ULL, 0x110fe20000004100ULL, 0x0000003d0b2a7223ULL, 0x080fe2000001002aULL,
0x0004000035337984ULL, 0x000ea20000000800ULL, 0x3000000dff0d7230ULL, 0x000fe20000004100ULL,
0x0000003d34237223ULL, 0x000fc40000010023ULL, 0x00000000350b7984ULL, 0x0008a20000000800ULL,
0x0000003f3c297223ULL, 0x008fe20000010029ULL, 0x20000038ff3c7230ULL, 0x000fe20000004100ULL,
0x0000003d0d267223ULL, 0x000fe20000010026ULL, 0x3000000aff0d7230ULL, 0x000fe20000004100ULL,
0x0000003f37287223ULL, 0x080fe20000010028ULL, 0x20000008ff0a7230ULL, 0x100fe20000004100ULL,
0x0000003f3e2d7223ULL, 0x000fe2000001002dULL, 0x30000008ff357230ULL, 0x010fe20000004100ULL,
0x0000003d0d227223ULL, 0x080fe20000010022ULL, 0x2000000cff087230ULL, 0x000fe20000004100ULL,
0x0000003d0a1f7223ULL, 0x080fe2000001001fULL, 0x2000003aff0a7230ULL, 0x100fe20000004100ULL,
0x0000003d351e7223ULL, 0x080fe2000001001eULL, 0x3000003aff0d7230ULL, 0x000fe20000004100ULL,
0x0000003d08177223ULL, 0x000fe20000010017ULL, 0x3000000cff0c7230ULL, 0x000fe20000004100ULL,
0x0000003f0a1d7223ULL, 0x080fe2000001001dULL, 0x20000009ff087230ULL, 0x100fe20000004100ULL,
0x0000003f0d1c7223ULL, 0x000fe2000001001cULL, 0x30000009ff0a7230ULL, 0x000fe20000004100ULL,
0x0000003d0c1b7223ULL, 0x000fe2000001001bULL, 0x20000032ff097230ULL, 0x100fe20000004100ULL,
0x0000003f3b2c7223ULL, 0x000fe2000001002cULL, 0x30000032ff0d7230ULL, 0x000fe20000004100ULL,
0x0000003d36277223ULL, 0x000fe20000010027ULL, 0x30000038ff377230ULL, 0x000fe20000004100ULL,
0x0000003f09187223ULL, 0x080fe20000010018ULL, 0x20000039ff347230ULL, 0x102fe20000004100ULL,
0x0000003f0d167223ULL, 0x080fe20000010016ULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003f3c257223ULL, 0x080fe20000010025ULL, 0x20000031ff357230ULL, 0x100fe20000004100ULL,
0x0000003f37247223ULL, 0x080fe20000010024ULL, 0x30000031ff0c7230ULL, 0x000fe20000004100ULL,
0x0000003f34217223ULL, 0x080fe20000010021ULL, 0x20000033ff0d7230ULL, 0x104fe20000004100ULL,
0x0000003f39207223ULL, 0x080fe20000010020ULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000003f351a7223ULL, 0x080fe2000001001aULL, 0x2000000bff097230ULL, 0x100fe20000004100ULL,
0x0000003f0c157223ULL, 0x000fe20000010015ULL, 0x3000000bff0b7230ULL, 0x000fe20000004100ULL,
0x0000003d08137223ULL, 0x000fc40000010013ULL, 0x0000003d0a197223ULL, 0x080fe40000010019ULL,
0x0000003d09147223ULL, 0x080fe40000010014ULL, 0x0000003d0b127223ULL, 0x000fe40000010012ULL,
0x0000003f0d107223ULL, 0x080fe40000010010ULL, 0x0000003f330e7223ULL, 0x000fe2000001000eULL,
0xfffff48000008947ULL, 0x000fea000383ffffULL, 0x0180000030027810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x7f80000002027812ULL, 0x000fe200078ec0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000192f000077802ULL, 0x002fc40000000f00ULL,
0x0000f43000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0006ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003000037308ULL, 0x000ea40000001000ULL,
0xbf80000003027423ULL, 0x004fc80000000030ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0b7819ULL, 0x004fc4000001160aULL, 0x000000080a0d7811ULL, 0x040fe200078ff0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x000000030b0f7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0b02067589ULL, 0x000ea200000e0000ULL, 0x000000040b117810ULL, 0x040fe20007ffe0ffULL,
0x000000080b307824ULL, 0x042fe400078e00ffULL, 0x00001f0d02077589ULL, 0x0002e200000e0000ULL,
0x000000080b347824ULL, 0x000fe400078e00ffULL, 0x000000080d367824ULL, 0x000fc400078e00ffULL,
0x000000080b327824ULL, 0x000fc600078e00ffULL, 0xfffffff836367812ULL, 0x000fca00078ee20dULL,
0x0000001036367824ULL, 0x000fe400078e0205ULL, 0x0000001906087220ULL, 0x044fe40000410000ULL,
0x0000002f062f7220ULL, 0x040fe40000410000ULL, 0x0000002e062e7220ULL, 0x040fe40000410000ULL,
0x0000002b062b7220ULL, 0x040fe40000410000ULL, 0x0000002a062a7220ULL, 0x000fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x0000002706277220ULL, 0x000fc40000410000ULL,
0x0000002606267220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000002306237220ULL, 0x040fe40000410000ULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000001f061f7220ULL, 0x040fe40000410000ULL,
0x0000001e061e7220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001706177220ULL, 0x000fc40000410000ULL, 0x0000001b06027220ULL, 0x002fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001306137220ULL, 0x040fe40000410000ULL,
0x0000001406147220ULL, 0x000fe20000410000ULL, 0x000000170202723eULL, 0x000fe200000000ffULL,
0x0000001206037220ULL, 0x000fe20000410000ULL, 0x000000010b067810ULL, 0x040fe20007ffe0ffULL,
0x000000080b197824ULL, 0x000fe200078e00ffULL, 0x000000130808723eULL, 0x000fe200000000ffULL,
0x0000001607097220ULL, 0x008fe20000410000ULL, 0x000000140303723eULL, 0x000fe200000000ffULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0xfffffff8190c7812ULL, 0x000fe200078ee206ULL,
0x000000080b167824ULL, 0x040fe200078e00ffULL, 0x000000030b067819ULL, 0x000fe200000006ffULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0xfffffff812127812ULL, 0x000fe200078ee20fULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0xfffffff816167812ULL, 0x000fe200078ee211ULL,
0x0000002907297220ULL, 0x000fe20000410000ULL, 0x000000050b0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000002807287220ULL, 0x000fe20000410000ULL, 0xffffffff0b197810ULL, 0x000fe20007ffe0ffULL,
0x0000002507257220ULL, 0x000fe20000410000ULL, 0x000000060b117810ULL, 0x000fe20007ffe0ffULL,
0x0000002407247220ULL, 0x040fe20000410000ULL, 0xfffffff806067812ULL, 0x000fe200078ee20bULL,
0x0000002107217220ULL, 0x040fe20000410000ULL, 0xfffffff830307812ULL, 0x000fe200078ee20fULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0xfffffff834347812ULL, 0x000fe200078ee219ULL,
0x0000001d071d7220ULL, 0x040fe20000410000ULL, 0xfffffff832327812ULL, 0x000fe200078ee211ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000000506067211ULL, 0x080fe200078e20ffULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000000532327211ULL, 0x000fe200078e20ffULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000001807187220ULL, 0x040fe20000410000ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x0000001007107220ULL, 0x040fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000000e07077220ULL, 0x000fe20000410000ULL, 0x000000020b0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b1b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x000000212020723eULL, 0x000fe200000000ffULL,
0x0000001012127824ULL, 0x100fe200078e0205ULL, 0xfffffff81b0e7812ULL, 0x000fe200078ee20eULL,
0x0000001016167824ULL, 0x100fe200078e0205ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000001030307824ULL, 0x100fe200078e0205ULL, 0x000000120b117210ULL, 0x000fe20007ffe0ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x0000001a1515723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x000fe200078e0205ULL, 0x000000180909723eULL, 0x000fe200000000ffULL,
0x0000000106057824ULL, 0x000fe200078e020bULL, 0x000000100707723eULL, 0x000fe200000000ffULL,
0x000000010b0d7824ULL, 0x000fc400078e020cULL, 0x000000010b0f7824ULL, 0x040fe200078e020eULL,
0x0000002e05007388ULL, 0x0003e20000000800ULL, 0x000000010b137824ULL, 0x040fe400078e0216ULL,
0x000000010b307824ULL, 0x040fe200078e0230ULL, 0x0000002a0d007388ULL, 0x0003e20000000800ULL,
0x000000010b327824ULL, 0x040fe400078e0232ULL, 0x000000010b347824ULL, 0x040fe200078e0234ULL,
0x000000260f007388ULL, 0x0003e20000000800ULL, 0x000000010b0b7824ULL, 0x000fc600078e0236ULL,
0x0000002211007388ULL, 0x0003e80000000800ULL, 0x0000001e13007388ULL, 0x0003e80000000800ULL,
0x0000000230007388ULL, 0x0003e80000000800ULL, 0x0000000832007388ULL, 0x0003e80000000800ULL,
0x0000000334007388ULL, 0x0003e80000000800ULL, 0x0000002c0b007388ULL, 0x0003e80000000800ULL,
0x000400280d007388ULL, 0x0003e80000000800ULL, 0x000400240f007388ULL, 0x0003e80000000800ULL,
0x0004002011007388ULL, 0x0003e80000000800ULL, 0x0004001c13007388ULL, 0x0003e80000000800ULL,
0x0004001530007388ULL, 0x0003e80000000800ULL, 0x0004000932007388ULL, 0x0003e80000000800ULL,
0x0004000734007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x0000580000007a24ULL, 0x000fc600078e02ffULL,
0x0000000000097919ULL, 0x000ee20000002600ULL, 0x00000003ff027819ULL, 0x002fc80000011608ULL,
0x0000000802037210ULL, 0x000fc80007ffe0ffULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef808ULL, 0x0000000708087812ULL, 0x000fc600078ec0ffULL,
0x0000001003047824ULL, 0x000fe200078e0204ULL, 0x1ffffff8086f7812ULL, 0x000fe200078ef86fULL,
0x0000580002037a24ULL, 0x008fc800078e0209ULL, 0x0120000004047984ULL, 0x004e620000000c00ULL,
0x0000000300007211ULL, 0x000fca00078010ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fc800078048ffULL, 0x00005b0000037a11ULL, 0x000fca00000f4c03ULL,
0x000000106f027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000004075887824ULL, 0x040fe200078e00ffULL,
0x0000002014057810ULL, 0x040fe20007ffe0ffULL, 0x0000010075867824ULL, 0x000fe200078e00ffULL,
0x000000031400780cULL, 0x040fe20003f44070ULL, 0x00000100770a7824ULL, 0x004fe400078e0288ULL,
0x00000004140b7824ULL, 0x000fe400078e0286ULL, 0x000000010a047824ULL, 0x040fe200078e0214ULL,
0x000000050a087210ULL, 0x000fe20007ffe0ffULL, 0x0000680073027a24ULL, 0x000fc600078e020aULL,
0x000000710400720cULL, 0x080fe20003f06070ULL, 0x0000000102047824ULL, 0x000fe200078e0214ULL,
0x000000710800720cULL, 0x000fe20003f26070ULL, 0x0000000102067824ULL, 0x000fe400078e0205ULL,
0x0000660004047625ULL, 0x000fc800078e0015ULL, 0x0000660006067625ULL, 0x000fe200078e0015ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cad000ff087f8cULL, 0x000e62000c80043fULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000000477877824ULL, 0x000fe400078e0275ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x1c600000040b7faeULL, 0x0005e8000c121846ULL,
0x1c680000060b7faeULL, 0x0005e2000c921846ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x0000001400027211ULL, 0x000fe200078e10ffULL, 0x0000000475077824ULL, 0x004fe200078e0214ULL,
0x000000728700720cULL, 0x000fc60003f06070ULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0001ca8007077811ULL, 0x000fc600078e10ffULL, 0x0000640002027a24ULL, 0x000fc800078e0287ULL,
0x0000600002047625ULL, 0x000fca00078e0015ULL, 0x0000000004077faeULL, 0x0005e4000c121846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000177057810ULL, 0x004fe20007ffe0ffULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000700500720cULL, 0x000fe20003f06070ULL,
0x000000ffff057224ULL, 0x002fe200078e0009ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000012a000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000e620000000000ULL, 0x0001ca80750b7811ULL, 0x000fe200078e20ffULL,
0x00000200ff127424ULL, 0x000fe200078e00ffULL, 0x00000003ff137819ULL, 0x002fe20000011610ULL,
0x0000001010077824ULL, 0x000fc600078e00ffULL, 0x00000013030d7211ULL, 0x000fe200078e30ffULL,
0x0000000413047824ULL, 0x000fe200078e0286ULL, 0x0000007007157812ULL, 0x000fe200078ec0ffULL,
0x0000000113097824ULL, 0x140fe200078e0210ULL, 0x0000000413117810ULL, 0x000fe40007ffe0ffULL,
0x01c6000004027984ULL, 0x000e640000000800ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x00000001110e7824ULL, 0x000fc600078e0210ULL, 0x0ffffff8090f7812ULL, 0x000fe200078ef810ULL,
0x0000000402087824ULL, 0x002fe200078e020bULL, 0x0000000a71027217ULL, 0x000fca0007800000ULL,
0x0000000008087984ULL, 0x000e620000000800ULL, 0x0000000102027824ULL, 0x000fe200078e0a0aULL,
0x00002000750a7811ULL, 0x000fc800078e70ffULL, 0x000000021300720cULL, 0x000fe40003f06070ULL,
0x0000000a0f0f7211ULL, 0x000fe200078e20ffULL, 0x0000000408067c24ULL, 0x002fc8000f8e020dULL,
0x00005e0006067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000040d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6100004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000000813117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000080d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6200004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000000c13117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e020aULL,
0x00000010110e7210ULL, 0x000fe40007ffe0ffULL, 0x0000000b060c7211ULL, 0x004fcc00078e10ffULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000000c0d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6300004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000001013117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000100d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe40003f06070ULL, 0x0000000311117819ULL, 0x000fe200000006ffULL,
0x01c6400004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000001413117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000140d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6500004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000001813117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fc80007f3e0ffULL,
0x00000007ff097210ULL, 0x000fe40000ffe4ffULL, 0x000000180d077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6600004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000001c13117810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0f0f7211ULL, 0x000fc600078e20ffULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000001c0d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6700004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000002013117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000200d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6800004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000002413117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e020aULL,
0x00000010110e7210ULL, 0x000fe40007ffe0ffULL, 0x0000000b060c7211ULL, 0x004fcc00078e10ffULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000240d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6900004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000002813117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000280d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe40003f06070ULL, 0x0000000311117819ULL, 0x000fe200000006ffULL,
0x01c6a00004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000002c13117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x0000002c0d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6b00004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000003013117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fc80007f3e0ffULL,
0x00000007ff097210ULL, 0x000fe40000ffe4ffULL, 0x000000300d077810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6c00004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000003413117810ULL, 0x000fe40007ffe0ffULL, 0x0000000a0f0f7211ULL, 0x000fc600078e20ffULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000340d077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e2000c101c46ULL,
0x000000021100720cULL, 0x040fe20003f06070ULL, 0x0000000811117824ULL, 0x000fe400078e00ffULL,
0x01c6d00004067984ULL, 0x000ea60000000800ULL, 0xfffffff8110f7812ULL, 0x002fe400078ee20eULL,
0x0000003813117810ULL, 0x000fc60007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe400078e020aULL,
0x00000001110e7824ULL, 0x000fe400078e0210ULL, 0x00000004060c7824ULL, 0x004fcc00078e020bULL,
0x000000000c0c7984ULL, 0x000e640000000800ULL, 0x000000040c077c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0007067625ULL, 0x000fca00078e0012ULL, 0x0000000615087210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0607ULL, 0x000000380d077810ULL, 0x040fe40007ffe0ffULL,
0x0000003c0d0d7810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080f7faeULL, 0x0003e2000c101c46ULL, 0x000000021100720cULL, 0x040fe20003f06070ULL,
0x0000000811117824ULL, 0x000fe400078e00ffULL, 0x01c6e00004067984ULL, 0x000ea60000000800ULL,
0xfffffff8110f7812ULL, 0x002fca00078ee20eULL, 0x000000100f0f7824ULL, 0x000fe200078e020aULL,
0x0000000b060c7211ULL, 0x004fcc00078e10ffULL, 0x000000000c0c7984ULL, 0x000e640000000800ULL,
0x000000040c077c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0007067625ULL, 0x000fca00078e0012ULL,
0x0000000615087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080f7faeULL, 0x0003e8000c101c46ULL,
0x01c6f00004047984ULL, 0x000ea40000000800ULL, 0x00000004040c7824ULL, 0x004fe200078e020bULL,
0x0000003c130b7810ULL, 0x000fc80007ffe0ffULL, 0x000000020b00720cULL, 0x040fe20003f06070ULL,
0x000000000c0c7984ULL, 0x000ea20000000800ULL, 0x000000100b027210ULL, 0x040fe20007ffe0ffULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b097812ULL, 0x002fca00078ee202ULL,
0x0000001009097824ULL, 0x000fe400078e020aULL, 0x000000040c067c24ULL, 0x004fc8000f8e020dULL,
0x00005e0006067625ULL, 0x000fca00078e0012ULL, 0x0000000615067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x0000117000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0001ca80750f7811ULL, 0x040fe200078e20ffULL,
0x00000200ff137424ULL, 0x000fe200078e00ffULL, 0x0000200075177811ULL, 0x000fe400078e70ffULL,
0x00000003ff0d7819ULL, 0x002fe20000011604ULL, 0x0000001004087824ULL, 0x000fc600078e00ffULL,
0x0000000d03117211ULL, 0x000fe200078e30ffULL, 0x000000040d0c7824ULL, 0x040fe200078e0286ULL,
0x0000007008157812ULL, 0x000fe200078ec0ffULL, 0x000000010d097824ULL, 0x140fe200078e0204ULL,
0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL, 0x01c600000c027984ULL, 0x000e640000000800ULL,
0x0000000709097812ULL, 0x000fe200078ec0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe200078ee20eULL,
0x0000000402027824ULL, 0x002fcc00078e020fULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fe2000f8e0211ULL, 0x0ffffff809027812ULL, 0x000fc600078ef804ULL,
0x00005e0006067625ULL, 0x000fc800078e0013ULL, 0x0000001002197824ULL, 0x000fe200078e0217ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000411077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c610000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000080d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000000811077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c620000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x0000000c0d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000000c11077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c630000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000100d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000001011077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c640000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x000000140d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000001411077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c650000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000180d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000001811077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c660000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x0000001c0d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000001c11077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c670000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000200d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000002011077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c680000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x000000240d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000002411077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c690000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000280d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000002811077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c6a0000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x0000002c0d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000002c11077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c6b0000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000300d097810ULL, 0x000fca0007ffe0ffULL,
0x00000001090e7824ULL, 0x040fe400078e0204ULL, 0x0000000809097824ULL, 0x000fca00078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe400078ee20eULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000003011077810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x01c6c0000c027984ULL, 0x000ea20000000800ULL, 0x000000100e197824ULL, 0x002fe200078e0217ULL,
0x000000340d0b7810ULL, 0x000fca0007ffe0ffULL, 0x000000010b0e7824ULL, 0x040fe400078e0204ULL,
0x000000080b0b7824ULL, 0x000fca00078e00ffULL, 0xfffffff80b0e7812ULL, 0x000fe400078ee20eULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0607ULL,
0x0000003411077810ULL, 0x000fc80007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008197faeULL, 0x0003e8000b901c46ULL, 0x01c6d0000c027984ULL, 0x000ea20000000800ULL,
0x000000100e197824ULL, 0x002fe200078e0217ULL, 0x000000380d097810ULL, 0x040fe40007ffe0ffULL,
0x0000003c0d0d7810ULL, 0x000fc60007ffe0ffULL, 0x00000001090e7824ULL, 0x140fe400078e0204ULL,
0x0000000809097824ULL, 0x000fe400078e00ffULL, 0x000000010d047824ULL, 0x040fe400078e0204ULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8090e7812ULL, 0x000fc800078ee20eULL,
0xfffffff80d047812ULL, 0x000fe400078ee204ULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000e640000000800ULL, 0x0000000402067c24ULL, 0x002fc8000f8e0207ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x00000015060a7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0607ULL, 0x0000003811077810ULL, 0x040fe40007ffe0ffULL,
0x0000003c11117810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e8000b901c46ULL, 0x01c6e0000c027984ULL, 0x000ea20000000800ULL,
0x000000100e0b7824ULL, 0x002fc400078e0217ULL, 0x0000001004177824ULL, 0x000fe200078e0217ULL,
0x0000000f02027211ULL, 0x004fcc00078e10ffULL, 0x0000000002027984ULL, 0x000e640000000800ULL,
0x0000000402067c24ULL, 0x002fc8000f8e0207ULL, 0x00005e0006067625ULL, 0x000fca00078e0013ULL,
0x0000001506087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fca00000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c46ULL,
0x01c6f0000c027984ULL, 0x000ea40000000800ULL, 0x0000000f02027211ULL, 0x004fcc00078e10ffULL,
0x0000000002027984ULL, 0x000ea40000000800ULL, 0x0000000402067c24ULL, 0x004fc8000f8e0211ULL,
0x00005e0006067625ULL, 0x000fca00078e0013ULL, 0x0000001506067210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006177faeULL, 0x0003e6000b901c46ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01cad400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff00047202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008060b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011409ULL,
0x0000000b02027211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000202027819ULL, 0x000fc80000001209ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000104047810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01cad400ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000707700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00005800ff047624ULL, 0x000fe200078e00ffULL,
0x0001cb5875857811ULL, 0x040fe200078e18ffULL, 0x0000002075767824ULL, 0x000fe200078e00ffULL,
0xffffffff70847810ULL, 0x000fe40007ffe0ffULL, 0x0000000604047819ULL, 0x000fc400000006ffULL,
0x0000010077067824ULL, 0x000fe200078e0288ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000067100720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x000000776e00720cULL, 0x000fe20003f44070ULL,
0x000000ffff6f7224ULL, 0x000fc600078e00ffULL, 0x0000000105057807ULL, 0x000fc40005000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000337f007947ULL, 0x000fea000b800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001c67000247802ULL, 0x000fc40000000f00ULL,
0x0000c33000007944ULL, 0x002fea0003c00000ULL, 0x00000002ff247819ULL, 0x000fe2000001166fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000246f247207ULL, 0x000fe20001000000ULL,
0x0000225000007945ULL, 0x000fe80003800000ULL, 0x0000030024d77a24ULL, 0x000fca00078e0277ULL,
0x00000001d7257810ULL, 0x040fe40007ffe0ffULL, 0x00000088d7d07211ULL, 0x000fe400078e40ffULL,
0x000000702500720cULL, 0x000fda0003f06070ULL, 0x0000119000008947ULL, 0x000fea0003800000ULL,
0x00000003ff257819ULL, 0x002fe20000011602ULL, 0x00000200ff267424ULL, 0x000fe200078e00ffULL,
0x0001ca80752a7811ULL, 0x000fe400078e20ffULL, 0x00000002252f7210ULL, 0x040fe20007ffe0ffULL,
0x00000004252b7824ULL, 0x000fe200078e0286ULL, 0x00000007022e7812ULL, 0x000fe200078ec0ffULL,
0x0000004003297824ULL, 0x000fe200078e0225ULL, 0x000000072f2f7812ULL, 0x000fe400078ec0ffULL,
0x01c600002b277984ULL, 0x000e620000000800ULL, 0x0000400075247811ULL, 0x000fc400078e70ffULL,
0x0ffffff82f2f7812ULL, 0x000fe400078ef802ULL, 0x0000000425337810ULL, 0x000fc60007ffe0ffULL,
0x000000102f317824ULL, 0x000fe200078e0224ULL, 0x0000000333357819ULL, 0x040fe200000006ffULL,
0x0000000133327824ULL, 0x000fe400078e0202ULL, 0x00000004272c7824ULL, 0x002fe200078e022aULL,
0x000000d071277217ULL, 0x000fca0007800000ULL, 0x000000002c2c7984ULL, 0x000e620000000800ULL,
0x0000000127287824ULL, 0x000fe200078e0ad0ULL, 0x000000082e277812ULL, 0x000fe400078efcffULL,
0x00000004292e7810ULL, 0x000fe40007ffe0ffULL, 0x000000282500720cULL, 0x000fe20003f26070ULL,
0x0000002c042d7224ULL, 0x002fc800078e0229ULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000000825337810ULL, 0x000fe20007ffe0ffULL, 0x01c610002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000133327824ULL, 0x000fe200078e0202ULL,
0x00000008292c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833357824ULL, 0x000fe400078e00ffULL,
0x0000001031317824ULL, 0x000fe400078e0224ULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000000c25337810ULL, 0x000fe20007ffe0ffULL,
0x01c620002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x0000000c292e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000002431317211ULL, 0x000fe200078e20ffULL,
0x000000042d307824ULL, 0x004fca00078e022aULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000001025337810ULL, 0x000fe20007ffe0ffULL, 0x01c630002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000133327824ULL, 0x000fe200078e0202ULL,
0x00000010292c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833357824ULL, 0x000fe400078e00ffULL,
0x0000001031317824ULL, 0x000fe400078e0224ULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000001425337810ULL, 0x000fe20007ffe0ffULL,
0x01c640002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x00000014292e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000233327210ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e0224ULL,
0x0000002a2d307211ULL, 0x004fca00078e10ffULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000001825337810ULL, 0x000fe20007ffe0ffULL, 0x01c650002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000133327824ULL, 0x000fe200078e0202ULL,
0x00000018292c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000333357819ULL, 0x000fe200000006ffULL,
0x0000001031317824ULL, 0x000fe400078e0224ULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000001c25337810ULL, 0x000fe20007ffe0ffULL,
0x01c660002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x0000001c292e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe400078e00ffULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042d307824ULL, 0x004fca00078e022aULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000002025337810ULL, 0x000fe20007ffe0ffULL, 0x01c670002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000133327824ULL, 0x000fe200078e0202ULL,
0x00000020292c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833357824ULL, 0x000fe200078e00ffULL,
0x0000002431317211ULL, 0x000fe200078e20ffULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000002425337810ULL, 0x000fe20007ffe0ffULL,
0x01c680002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x00000024292e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe400078e00ffULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042d307824ULL, 0x004fca00078e022aULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000002825337810ULL, 0x000fe20007ffe0ffULL, 0x01c690002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000833357824ULL, 0x000fe200078e00ffULL,
0x00000028292c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000233327210ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e0224ULL, 0x0000002a2f307211ULL, 0x004fca00078e10ffULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000002c25337810ULL, 0x000fe20007ffe0ffULL,
0x01c6a0002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x0000002c292e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000333357819ULL, 0x000fe200000006ffULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042d307824ULL, 0x004fca00078e022aULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000003025337810ULL, 0x000fe20007ffe0ffULL, 0x01c6b0002b2f7984ULL, 0x000ea20000000800ULL,
0xfffffff835317812ULL, 0x002fc600078ee232ULL, 0x0000000133327824ULL, 0x000fe200078e0202ULL,
0x00000030292c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833357824ULL, 0x000fe400078e00ffULL,
0x0000001031317824ULL, 0x000fe400078e0224ULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fe40003f26070ULL, 0x0000003425337810ULL, 0x000fe20007ffe0ffULL,
0x01c6c0002b2d7984ULL, 0x000ea20000000800ULL, 0xfffffff835317812ULL, 0x002fc600078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x00000034292e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000002431317211ULL, 0x000fe200078e20ffULL,
0x000000042d307824ULL, 0x004fca00078e022aULL, 0x00000000302d7984ULL, 0x000e640000000800ULL,
0x0000002d042d7224ULL, 0x002fc800078e022cULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e2000c901c46ULL, 0x000000283300720cULL, 0x000fe40003f26070ULL,
0x0000003825337810ULL, 0x040fe20007ffe0ffULL, 0x01c6d0002b2f7984ULL, 0x000ea20000000800ULL,
0x0000003c25257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff835317812ULL, 0x002fe200078ee232ULL,
0x0000000133327824ULL, 0x000fe200078e0202ULL, 0x00000038292c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000003c29297810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fc400078e0224ULL, 0x000000042f307824ULL, 0x004fca00078e022aULL,
0x00000000302f7984ULL, 0x000e640000000800ULL, 0x0000002f042f7224ULL, 0x002fc800078e022eULL,
0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL, 0x00000010272e7825ULL, 0x000fca00078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e317faeULL, 0x0003e2000c901c46ULL,
0x000000283300720cULL, 0x000fc60003f26070ULL, 0x01c6e0002b2d7984ULL, 0x000ea20000000800ULL,
0xfffffff8352f7812ULL, 0x002fe400078ee232ULL, 0x00000002252e7210ULL, 0x000fc60007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0224ULL, 0x0000002a2d307211ULL, 0x004fca00078e10ffULL,
0x00000000302d7984ULL, 0x000e640000000800ULL, 0x0000002d042d7224ULL, 0x002fc800078e022cULL,
0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL, 0x00000010272c7825ULL, 0x000fca00078e002cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c2f7faeULL, 0x0003e2000c901c46ULL,
0x000000282500720cULL, 0x000fc60003f26070ULL, 0x01c6f0002b2b7984ULL, 0x000ea40000000800ULL,
0x000000042b2a7824ULL, 0x004fca00078e022aULL, 0x000000002a317984ULL, 0x000ea40000000800ULL,
0x0000003104297224ULL, 0x004fe400078e0229ULL, 0x0000000825317824ULL, 0x000fe400078e00ffULL,
0x00005e0029287625ULL, 0x000fc600078e0026ULL, 0xfffffff831257812ULL, 0x000fc600078ee22eULL,
0x0000001027287825ULL, 0x000fc800078e0028ULL, 0x0000001025257824ULL, 0x000fca00078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028257faeULL, 0x0003e2000c901c46ULL,
0x0000106000007947ULL, 0x000fea0003800000ULL, 0x00000003ff257819ULL, 0x002fe20000011602ULL,
0x00000200ff267424ULL, 0x000fe200078e00ffULL, 0x0001ca8075287811ULL, 0x000fe400078e20ffULL,
0x0000002503297211ULL, 0x000fe200078e30ffULL, 0x00000004252a7824ULL, 0x040fe200078e0286ULL,
0x0000000425337810ULL, 0x040fe20007ffe0ffULL, 0x0000000125247824ULL, 0x000fc600078e0202ULL,
0x01c600002a277984ULL, 0x000e620000000800ULL, 0x0000000233307210ULL, 0x040fe20007ffe0ffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x00000007242f7812ULL, 0x000fe400078ec0ffULL,
0x0000400075247811ULL, 0x000fe400078e70ffULL, 0x0ffffff82f2f7812ULL, 0x000fe400078ef802ULL,
0xfffffff833337812ULL, 0x000fc600078ee230ULL, 0x000000102f317824ULL, 0x100fe200078e0224ULL,
0x00000004292f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x00000004272b7824ULL, 0x002fe200078e0228ULL, 0x0000000702277812ULL, 0x000fc800078ec0ffULL,
0x0000000827277812ULL, 0x000fe200078efcffULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e0229ULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c610002a2b7984ULL, 0x000ea20000000800ULL,
0x0000000825317810ULL, 0x002fe40007ffe0ffULL, 0x00000008292d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131307824ULL, 0x040fe200078e0202ULL, 0x0000000331317819ULL, 0x000fc800000006ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c620002a2b7984ULL, 0x000ea20000000800ULL,
0x0000000c25337810ULL, 0x002fe40007ffe0ffULL, 0x0000000c292f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133307824ULL, 0x040fe400078e0202ULL, 0x0000000833337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fc800078ee230ULL, 0x0000002433337211ULL, 0x000fe200078e20ffULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c630002a2b7984ULL, 0x000ea20000000800ULL,
0x0000001025317810ULL, 0x002fe40007ffe0ffULL, 0x00000010292d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131307824ULL, 0x040fe400078e0202ULL, 0x0000000831317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c640002a2b7984ULL, 0x000ea20000000800ULL,
0x0000001425337810ULL, 0x002fe40007ffe0ffULL, 0x00000014292f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133307824ULL, 0x040fe400078e0202ULL, 0x0000000833337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fca00078ee230ULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c650002a2b7984ULL, 0x000ea20000000800ULL,
0x0000001825317810ULL, 0x002fe40007ffe0ffULL, 0x00000018292d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000231307210ULL, 0x040fe20007ffe0ffULL, 0x0000000831317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe200078e0224ULL,
0x000000282b2b7211ULL, 0x004fcc00078e10ffULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c660002a2b7984ULL, 0x000ea20000000800ULL,
0x0000001c25337810ULL, 0x002fe40007ffe0ffULL, 0x0000001c292f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133307824ULL, 0x040fe200078e0202ULL, 0x0000000333337819ULL, 0x000fc800000006ffULL,
0xfffffff833337812ULL, 0x000fca00078ee230ULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c670002a2b7984ULL, 0x000ea20000000800ULL,
0x0000002025317810ULL, 0x002fe40007ffe0ffULL, 0x00000020292d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131307824ULL, 0x040fe400078e0202ULL, 0x0000000831317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fc800078ee230ULL, 0x0000002431317211ULL, 0x000fe200078e20ffULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c680002a2b7984ULL, 0x000ea20000000800ULL,
0x0000002425337810ULL, 0x002fe40007ffe0ffULL, 0x00000024292f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133307824ULL, 0x040fe400078e0202ULL, 0x0000000833337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fca00078ee230ULL, 0x0000001033337824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c690002a2b7984ULL, 0x000ea20000000800ULL,
0x0000002825317810ULL, 0x002fe40007ffe0ffULL, 0x00000028292d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131307824ULL, 0x040fe400078e0202ULL, 0x0000000831317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c6a0002a2b7984ULL, 0x000ea20000000800ULL,
0x0000002c25337810ULL, 0x002fe40007ffe0ffULL, 0x0000002c292f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000233307210ULL, 0x040fe20007ffe0ffULL, 0x0000000833337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fca00078ee230ULL, 0x0000001033337824ULL, 0x000fe200078e0224ULL,
0x000000282b2b7211ULL, 0x004fcc00078e10ffULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c6b0002a2b7984ULL, 0x000ea20000000800ULL,
0x0000003025317810ULL, 0x002fe40007ffe0ffULL, 0x00000030292d7810ULL, 0x000fc60007ffe0ffULL,
0x0000000131307824ULL, 0x040fe200078e0202ULL, 0x0000000331317819ULL, 0x000fc800000006ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c6c0002a2b7984ULL, 0x000ea20000000800ULL,
0x0000003425337810ULL, 0x002fe40007ffe0ffULL, 0x00000034292f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000133307824ULL, 0x040fe400078e0202ULL, 0x0000000833337824ULL, 0x000fca00078e00ffULL,
0xfffffff833337812ULL, 0x000fc800078ee230ULL, 0x0000002433337211ULL, 0x000fe200078e20ffULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c6d0002a2b7984ULL, 0x000ea20000000800ULL,
0x0000003825317810ULL, 0x002fe40007ffe0ffULL, 0x00000038292d7810ULL, 0x000fe40007ffe0ffULL,
0x0000003c25257810ULL, 0x000fe20007ffe0ffULL, 0x0000000131307824ULL, 0x000fe200078e0202ULL,
0x0000003c29297810ULL, 0x000fe20007ffe0ffULL, 0x0000000831317824ULL, 0x000fca00078e00ffULL,
0xfffffff831317812ULL, 0x000fca00078ee230ULL, 0x0000001031317824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042f7224ULL, 0x002fc800078e022fULL, 0x00005e002f2e7625ULL, 0x000fcc00078e0026ULL,
0x00000010272e7825ULL, 0x000fca00078e002eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e337faeULL, 0x0003e8000b901c46ULL, 0x01c6e0002a2b7984ULL, 0x000ea20000000800ULL,
0x00000001252e7824ULL, 0x042fe400078e0202ULL, 0x0000000825257824ULL, 0x000fca00078e00ffULL,
0xfffffff825257812ULL, 0x000fca00078ee22eULL, 0x0000001025257824ULL, 0x000fe400078e0224ULL,
0x000000042b2b7824ULL, 0x004fcc00078e0228ULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b042d7224ULL, 0x002fc800078e022dULL, 0x00005e002d2c7625ULL, 0x000fcc00078e0026ULL,
0x00000010272c7825ULL, 0x000fca00078e002cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c317faeULL, 0x0003e8000b901c46ULL, 0x01c6f0002a2b7984ULL, 0x000ea40000000800ULL,
0x000000282b2b7211ULL, 0x004fcc00078e10ffULL, 0x000000002b2b7984ULL, 0x000ea40000000800ULL,
0x0000002b04297224ULL, 0x004fc800078e0229ULL, 0x00005e0029287625ULL, 0x000fcc00078e0026ULL,
0x0000001027287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000337f007947ULL, 0x000fea000b800000ULL, 0xffffffffff257424ULL, 0x002fe200078e00ffULL,
0x0001e94000247802ULL, 0x000fc40000000f00ULL, 0x0000a06000007944ULL, 0x000fea0003c00000ULL,
0x0000000702d57812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000008d5787812ULL, 0x100fe200078ef802ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff257819ULL, 0x002fe20000011602ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000002078247824ULL, 0x040fe200078e00ffULL, 0x0000002578797210ULL, 0x000fc80007ffe0ffULL,
0xffffffe024247812ULL, 0x000fca00078ee279ULL, 0x0000001024247824ULL, 0x000fc400078e00ffULL,
0x0000000825267824ULL, 0x000fe200078e00ffULL, 0x00000003ff7b7819ULL, 0x000fe20000011602ULL,
0x0000400075e57824ULL, 0x000fe200078e00ffULL, 0x0000000279297810ULL, 0x000fe20007ffe0ffULL,
0x00000020782a7824ULL, 0x000fe200078e00ffULL, 0xfffffff826497812ULL, 0x000fe400078ee2d5ULL,
0x000000017b287812ULL, 0x000fe400078ec0ffULL, 0x00002000e5817810ULL, 0x000fe20007ffe0ffULL,
0x0000000849257824ULL, 0x040fe200078e00ffULL, 0x0000004928487210ULL, 0x000fe20007ffe0ffULL,
0x00000008492b7824ULL, 0x040fe200078e00ffULL, 0x00000010494b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8259e7812ULL, 0x000fe400078ee248ULL, 0x00000002488e7810ULL, 0x000fe20007ffe0ffULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0x00000030496b7810ULL, 0x000fe20007ffe0ffULL,
0x000000109ece7824ULL, 0x000fe200078e0281ULL, 0xfffffff82b8e7812ULL, 0x000fe200078ee28eULL,
0x000000084b2b7824ULL, 0x000fe200078e00ffULL, 0x0000004b28ec7210ULL, 0x040fe20007ffe0ffULL,
0x00000001288c7824ULL, 0x000fe200078e026bULL, 0x00000000ce40783bULL, 0x000e620000000200ULL,
0x000000086b2d7824ULL, 0x000fe200078e00ffULL, 0x0000002049697810ULL, 0x000fe20007ffe0ffULL,
0x000000108ec47824ULL, 0x000fe200078e0281ULL, 0xffffffe02a297812ULL, 0x000fe200078ee229ULL,
0x000000084b357824ULL, 0x000fe200078e00ffULL, 0xfffffff82bec7812ULL, 0x000fe200078ee2ecULL,
0x00000008692b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d8c7812ULL, 0x000fe200078ee28cULL,
0x0000001029297824ULL, 0x000fe200078e00ffULL, 0x0000006928927210ULL, 0x000fe20007ffe0ffULL,
0x00000010eccc7824ULL, 0x000fe200078e0281ULL, 0x000000818cc67211ULL, 0x000fe200078e20ffULL,
0x00000000c44c783bULL, 0x000fe20000000200ULL, 0xfffffff82b927812ULL, 0x000fc400078ee292ULL,
0x0000001248807810ULL, 0x040fe20007ffe0ffULL, 0x000000002954783bULL, 0x000fe20000000200ULL,
0x0000002248e67810ULL, 0x000fe20007ffe0ffULL, 0x0000001092ca7824ULL, 0x100fe200078e0281ULL,
0xfffffff835807812ULL, 0x000fe200078ee280ULL, 0x00000000cc38783bULL, 0x000ea20000000200ULL,
0x0000000869357824ULL, 0x000fe200078e00ffULL, 0x0000003248e87810ULL, 0x000fe40007ffe0ffULL,
0x00000000c628783bULL, 0x000ee20000000200ULL, 0x0000001080907824ULL, 0x000fe200078e0281ULL,
0xfffffff835e67812ULL, 0x000fc400078ee2e6ULL, 0x00000000ca30783bULL, 0x000f220000000200ULL,
0x0000000448ea7810ULL, 0x000fe40007ffe0ffULL, 0x00000010e68f7824ULL, 0x000fe200078e0281ULL,
0x000000009044783bULL, 0x000f220000000200ULL, 0x0000001448967810ULL, 0x040fe40007ffe0ffULL,
0x0000002448947810ULL, 0x040fe20007ffe0ffULL, 0x000000008f34783bULL, 0x000f220000000200ULL,
0x0000003448917810ULL, 0x040fe20007ffe0ffULL, 0x00000040242c723cULL, 0x002f6200000018ffULL,
0x00000006488a7810ULL, 0x000fc40007ffe0ffULL, 0x00000016488b7810ULL, 0x040fe40007ffe0ffULL,
0x0000002648897810ULL, 0x040fe40007ffe0ffULL, 0x0000003648827810ULL, 0x000fe20007ffe0ffULL,
0x000000422440723cULL, 0x040f7000000018ffULL, 0x00000038243c723cULL, 0x044f7000000018ffULL,
0x00000028245c723cULL, 0x048bee00000018ffULL, 0x000000036b297819ULL, 0x020fe200000006ffULL,
0x0000003a2438723cULL, 0x000f6600000018ffULL, 0xfffffff829e87812ULL, 0x000fca00078ee2e8ULL,
0x0000004c542c723cULL, 0x000fe2000000182cULL, 0x00000010e8c27824ULL, 0x000fce00078e0281ULL,
0x0000004e544c723cULL, 0x000ff00000001840ULL, 0x000000302440723cULL, 0x050f7000000018ffULL,
0x000000322430723cULL, 0x040f7000000018ffULL, 0x0000002a2424723cULL, 0x000b6400000018ffULL,
0x00000000c228783bULL, 0x020e6c0000000200ULL, 0x00000044543c723cULL, 0x040f70000000183cULL,
0x000000465444723cULL, 0x040bee0000001838ULL, 0x0000002078397824ULL, 0x020fe200078e00ffULL,
0x0000000479387810ULL, 0x000fe20007ffe0ffULL, 0x000000345440723cULL, 0x000b620000001840ULL,
0x00000003693b7819ULL, 0x000fc400000006ffULL, 0xffffffe039387812ULL, 0x000fe200078ee238ULL,
0x000000084b397824ULL, 0x000fe200078e00ffULL, 0xfffffff83b947812ULL, 0x000fe400078ee294ULL,
0x0000000849357824ULL, 0x060fe200078e00ffULL, 0x0000000349497819ULL, 0x000fe200000006ffULL,
0x000000086b347824ULL, 0x000fe200078e00ffULL, 0xfffffff839967812ULL, 0x000fe200078ee296ULL,
0x0000001094937824ULL, 0x000fe200078e0281ULL, 0xfffffff835ea7812ULL, 0x000fe200078ee2eaULL,
0x000000086b6b7824ULL, 0x000fe200078e00ffULL, 0xfffffff834917812ULL, 0x000fe200078ee291ULL,
0x0000001096c07824ULL, 0x100fe200078e0281ULL, 0x000000365434723cULL, 0x000b620000001830ULL,
0x00000010eac87824ULL, 0x100fe200078e0281ULL, 0x000000009358783bULL, 0x000fe20000000200ULL,
0x00000010917f7824ULL, 0x000fe200078e0281ULL, 0x0000000679397810ULL, 0x000fc40007ffe0ffULL,
0x00000000c864783bULL, 0x000fe20000000200ULL, 0x0000001038307824ULL, 0x020fe200078e00ffULL,
0x00000028545c723cULL, 0x042b62000000185cULL, 0x0000002078387824ULL, 0x000fe200078e00ffULL,
0x00000000c060783bULL, 0x000fe20000000200ULL, 0xfffffff8498a7812ULL, 0x000fe400078ee28aULL,
0xfffffff86b827812ULL, 0x000fe200078ee282ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x000000084b287824ULL, 0x020fe200078e00ffULL, 0xffffffe038397812ULL, 0x000fe200078ee239ULL,
0x0000002a5454723cULL, 0x000b620000001824ULL, 0x000000007f50783bULL, 0x000ea20000000200ULL,
0x0000000369387819ULL, 0x000fe200000006ffULL, 0x000000108a7d7824ULL, 0x000fe200078e0281ULL,
0xfffffff8288b7812ULL, 0x000fe200078ee28bULL, 0x0000001039287824ULL, 0x000fe200078e00ffULL,
0xfffffff838897812ULL, 0x000fe200078ee289ULL, 0x00000010827a7824ULL, 0x100fe200078e0281ULL,
0x000000007d68783bULL, 0x000fe20000000200ULL, 0x000000108b7e7824ULL, 0x000fe200078e0281ULL,
0x00000081897c7211ULL, 0x000fc400078e20ffULL, 0x000000002828783bULL, 0x020ee80000000200ULL,
0x000000007e38783bULL, 0x000f280000000200ULL, 0x000000007c48783bULL, 0x000ea80000000200ULL,
0x000000007a24783bULL, 0x000ea20000000200ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000064302c723cULL, 0x042f70000000182cULL, 0x00000060303c723cULL, 0x040f70000000183cULL,
0x000000583040723cULL, 0x040f700000001840ULL, 0x00000066304c723cULL, 0x040f70000000184cULL,
0x000000623044723cULL, 0x040f700000001844ULL, 0x0000005a3034723cULL, 0x040f700000001834ULL,
0x00000050305c723cULL, 0x044f70000000185cULL, 0x000000523030723cULL, 0x000f700000001854ULL,
0x00000068282c723cULL, 0x068b70000000182cULL, 0x00000038283c723cULL, 0x050b70000000183cULL,
0x000000482840723cULL, 0x040b700000001840ULL, 0x0000006a2868723cULL, 0x040b70000000184cULL,
0x0000003a2838723cULL, 0x040b700000001844ULL, 0x0000004a2848723cULL, 0x040b700000001834ULL,
0x00000024285c723cULL, 0x040b70000000185cULL, 0x000000262828723cULL, 0x000b620000001830ULL,
0x0000003000007947ULL, 0x000fde0003800000ULL, 0xffffffffff257424ULL, 0x020fe200078e00ffULL,
0x0001f2c000247802ULL, 0x000fce0000000f00ULL, 0x000096e000007944ULL, 0x000fea0003c00000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000021b000007945ULL, 0x000fe20003800000ULL,
0x0000116000008947ULL, 0x000fea0003800000ULL, 0x000000047b9c7824ULL, 0x000fe200078e0286ULL,
0x0001ca80759a7811ULL, 0x000fe200078e20ffULL, 0x000000017b247824ULL, 0x020fe200078e0202ULL,
0x0000007b03d37211ULL, 0x000fe200078e30ffULL, 0x00000200ff987424ULL, 0x000fe200078e00ffULL,
0x01c600009c257984ULL, 0x000e620000000800ULL, 0x00000010d5317812ULL, 0x000fe400078efcffULL,
0x0000000724277812ULL, 0x000fe400078ec0ffULL, 0x000000047bd17810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff827e47812ULL, 0x100fe400078ef802ULL, 0x00000004d3cf7810ULL, 0x000fe20007ffe0ffULL,
0x00000001d1e37824ULL, 0x000fe200078e0202ULL, 0x000000087bcd7810ULL, 0x000fe20007ffe0ffULL,
0x00000010e4be7824ULL, 0x000fe200078e0281ULL, 0x00000008d3cb7810ULL, 0x000fe20007ffe0ffULL,
0x00000008d1347824ULL, 0x000fe200078e00ffULL, 0x00000002cde27210ULL, 0x040fe20007ffe0ffULL,
0x00000008cd337824ULL, 0x000fe200078e00ffULL, 0x0000000c7bc97810ULL, 0x000fc40007ffe0ffULL,
0xfffffff834e37812ULL, 0x000fe400078ee2e3ULL, 0xfffffff833e27812ULL, 0x000fe200078ee2e2ULL,
0x00000001c9e17824ULL, 0x000fe200078e0202ULL, 0x0000000cd3c77810ULL, 0x000fe20007ffe0ffULL,
0x00000010e3bc7824ULL, 0x100fe200078e0281ULL, 0x00000003c9347819ULL, 0x000fe200000006ffULL,
0x00000010e2ba7824ULL, 0x000fe200078e0281ULL, 0x00000010d3c37810ULL, 0x000fe40007ffe0ffULL,
0xfffffff834e17812ULL, 0x000fc400078ee2e1ULL, 0x000000107bc57810ULL, 0x040fe40007ffe0ffULL,
0x000000147bc17810ULL, 0x000fe20007ffe0ffULL, 0x00000010e1b87824ULL, 0x000fe200078e0281ULL,
0x00000014d3bf7810ULL, 0x000fe20007ffe0ffULL, 0x00000001c5e07824ULL, 0x000fe200078e0202ULL,
0x000000187bbd7810ULL, 0x000fe20007ffe0ffULL, 0x00000008c5337824ULL, 0x000fe200078e00ffULL,
0x00000018d3bb7810ULL, 0x000fe20007ffe0ffULL, 0x0000000425267824ULL, 0x002fe200078e029aULL,
0x000000d071257217ULL, 0x000fe20007800000ULL, 0x00000001c1df7824ULL, 0x000fe200078e0202ULL,
0xfffffff833e07812ULL, 0x000fe200078ee2e0ULL, 0x00000008c1347824ULL, 0x000fe200078e00ffULL,
0x0000001c7bb97810ULL, 0x000fe20007ffe0ffULL, 0x0000000026267984ULL, 0x000e620000000800ULL,
0x0000000125307824ULL, 0x000fe200078e0ad0ULL, 0x00000081e0b67211ULL, 0x000fe200078e20ffULL,
0x00000001bdde7824ULL, 0x040fe200078e0202ULL, 0xfffffff834df7812ULL, 0x000fe200078ee2dfULL,
0x00000008bd337824ULL, 0x000fe200078e00ffULL, 0x000000307b00720cULL, 0x000fe20003f26070ULL,
0x00000008b9347824ULL, 0x000fe200078e00ffULL, 0x0000001cd3b77810ULL, 0x000fe20007ffe0ffULL,
0x00000010dfb47824ULL, 0x000fe200078e0281ULL, 0xfffffff833de7812ULL, 0x000fc400078ee2deULL,
0x00000002b9dd7210ULL, 0x000fe40007ffe0ffULL, 0x000000207bb57810ULL, 0x000fe20007ffe0ffULL,
0x00000010deb27824ULL, 0x000fe200078e0281ULL, 0xfffffff834dd7812ULL, 0x000fe400078ee2ddULL,
0x00000020d3b37810ULL, 0x000fe20007ffe0ffULL, 0x00000001b5dc7824ULL, 0x040fe200078e0202ULL,
0x00000003b5337819ULL, 0x000fe200000006ffULL, 0x00000010ddb07824ULL, 0x000fe200078e0281ULL,
0x00000024d3af7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff833dc7812ULL, 0x000fe400078ee2dcULL,
0x000000247bb17810ULL, 0x040fe40007ffe0ffULL, 0x000000287bad7810ULL, 0x000fe20007ffe0ffULL,
0x00000010dcae7824ULL, 0x000fe200078e0281ULL, 0x00000028d3ab7810ULL, 0x000fe20007ffe0ffULL,
0x00000001b1db7824ULL, 0x100fe200078e0202ULL, 0x0000002c7ba97810ULL, 0x000fe20007ffe0ffULL,
0x00000008b1347824ULL, 0x000fe200078e00ffULL, 0x0000002cd3a77810ULL, 0x000fe20007ffe0ffULL,
0x00000001adda7824ULL, 0x100fe200078e0202ULL, 0x000000307ba57810ULL, 0x000fe20007ffe0ffULL,
0x00000008ad337824ULL, 0x000fe200078e00ffULL, 0xfffffff834db7812ULL, 0x000fe200078ee2dbULL,
0x00000001a9d97824ULL, 0x000fe200078e0202ULL, 0x00000030d3a37810ULL, 0x000fe20007ffe0ffULL,
0x0000002604257224ULL, 0x002fe200078e02d3ULL, 0x00000081dbac7211ULL, 0x000fe200078e20ffULL,
0x00000008a9347824ULL, 0x000fe200078e00ffULL, 0xfffffff833da7812ULL, 0x000fe200078ee2daULL,
0x00005e0025247625ULL, 0x000fe200078e0098ULL, 0x00000002a5d87210ULL, 0x000fc40007ffe0ffULL,
0xfffffff834d97812ULL, 0x000fe200078ee2d9ULL, 0x00000010daaa7824ULL, 0x000fe200078e0281ULL,
0x000000347ba17810ULL, 0x000fe20007ffe0ffULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x00000034d39f7810ULL, 0x040fe40007ffe0ffULL, 0x00000038d39b7810ULL, 0x000fe20007ffe0ffULL,
0x00000010d9a87824ULL, 0x000fe200078e0281ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024be7faeULL, 0x0003e2000c901c46ULL, 0x00000030d100720cULL, 0x000fe20003f26070ULL,
0x00000008a5337824ULL, 0x000fe200078e00ffULL, 0x000000387b9d7810ULL, 0x000fe20007ffe0ffULL,
0x01c610009c277984ULL, 0x000ea20000000800ULL, 0x00000001a1d67824ULL, 0x000fe200078e0202ULL,
0x0000003c7b997810ULL, 0x000fc40007ffe0ffULL, 0xfffffff833d87812ULL, 0x000fe200078ee2d8ULL,
0x000000019dd47824ULL, 0x100fe200078e0202ULL, 0x00000003a1337819ULL, 0x000fe200000006ffULL,
0x0000000199d27824ULL, 0x000fe200078e0202ULL, 0x0000003cd3977810ULL, 0x000fe20007ffe0ffULL,
0x00000010d8a67824ULL, 0x000fe200078e0281ULL, 0xfffffff833d67812ULL, 0x000fe200078ee2d6ULL,
0x000000089d337824ULL, 0x000fc800078e00ffULL, 0x00000010d6a47824ULL, 0x000fe200078e0281ULL,
0xfffffff833d47812ULL, 0x000fe200078ee2d4ULL, 0x0000000899337824ULL, 0x000fc600078e00ffULL,
0x00000081d4a27211ULL, 0x000fe400078e20ffULL, 0xfffffff833d27812ULL, 0x000fca00078ee2d2ULL,
0x00000010d2a07824ULL, 0x000fe200078e0281ULL, 0x0000009a27327211ULL, 0x004fcc00078e10ffULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204277224ULL, 0x004fc800078e02cfULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026bc7faeULL, 0x0005e2000c901c46ULL,
0x00000030cd00720cULL, 0x000fc60003f26070ULL, 0x01c620009c257984ULL, 0x002e640000000800ULL,
0x0000000425327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204257224ULL, 0x002fc800078e02cbULL, 0x00005e0025247625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x004fca00078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026ba7faeULL, 0x0003e2000c901c46ULL, 0x00000030c900720cULL, 0x000fc60003f26070ULL,
0x01c630009c257984ULL, 0x000ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e02c7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b87faeULL, 0x0005e2000c901c46ULL,
0x00000030c500720cULL, 0x000fc60003f26070ULL, 0x01c640009c277984ULL, 0x002e640000000800ULL,
0x0000000427327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e02c3ULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b67faeULL, 0x0003e2000c901c46ULL, 0x00000030c100720cULL, 0x000fc60003f26070ULL,
0x01c650009c257984ULL, 0x004ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e02bfULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b47faeULL, 0x0005e2000c901c46ULL,
0x00000030bd00720cULL, 0x000fc60003f26070ULL, 0x01c660009c277984ULL, 0x002e640000000800ULL,
0x0000009a27327211ULL, 0x002fcc00078e10ffULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e02bbULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026b27faeULL, 0x0003e2000c901c46ULL, 0x00000030b900720cULL, 0x000fc60003f26070ULL,
0x01c670009c257984ULL, 0x004ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e02b7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b07faeULL, 0x0005e2000c901c46ULL,
0x00000030b500720cULL, 0x000fc60003f26070ULL, 0x01c680009c277984ULL, 0x002e640000000800ULL,
0x0000000427327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e02b3ULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026ae7faeULL, 0x0003e2000c901c46ULL, 0x00000030b100720cULL, 0x000fc60003f26070ULL,
0x01c690009c257984ULL, 0x004ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e02afULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ac7faeULL, 0x0005e2000c901c46ULL,
0x00000030ad00720cULL, 0x000fc60003f26070ULL, 0x01c6a0009c277984ULL, 0x002e640000000800ULL,
0x0000000427327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e02abULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026aa7faeULL, 0x0003e2000c901c46ULL, 0x00000030a900720cULL, 0x000fc60003f26070ULL,
0x01c6b0009c257984ULL, 0x004ea40000000800ULL, 0x0000009a25327211ULL, 0x004fcc00078e10ffULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e02a7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a87faeULL, 0x0005e2000c901c46ULL,
0x00000030a500720cULL, 0x000fc60003f26070ULL, 0x01c6c0009c277984ULL, 0x002e640000000800ULL,
0x0000000427327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e02a3ULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026a67faeULL, 0x0003e2000c901c46ULL, 0x00000030a100720cULL, 0x000fc60003f26070ULL,
0x01c6d0009c257984ULL, 0x004ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e029fULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a47faeULL, 0x0005e2000c901c46ULL,
0x000000309d00720cULL, 0x000fc60003f26070ULL, 0x01c6e0009c277984ULL, 0x002e640000000800ULL,
0x0000000427327824ULL, 0x002fcc00078e029aULL, 0x0000000032327984ULL, 0x000e640000000800ULL,
0x0000003204277224ULL, 0x002fc800078e029bULL, 0x00005e0027267625ULL, 0x000fcc00078e0098ULL,
0x0000001031267825ULL, 0x000fca00078e0026ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026a27faeULL, 0x0003e2000c901c46ULL, 0x000000309900720cULL, 0x000fc60003f26070ULL,
0x01c6f0009c257984ULL, 0x004ea40000000800ULL, 0x0000000425327824ULL, 0x004fcc00078e029aULL,
0x0000000032327984ULL, 0x000ea40000000800ULL, 0x0000003204257224ULL, 0x004fc800078e0297ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a07faeULL, 0x0003e2000c901c46ULL,
0x0000103000007947ULL, 0x000fea0003800000ULL, 0x000000867b9c7211ULL, 0x000fe200078e10ffULL,
0x0000004003d37824ULL, 0x000fe200078e027bULL, 0x0001ca80759a7811ULL, 0x000fe200078e20ffULL,
0x000000017b247824ULL, 0x020fe200078e0202ULL, 0x00000010d5317812ULL, 0x000fe200078efcffULL,
0x01c600009c257984ULL, 0x000e620000000800ULL, 0x00000200ff987424ULL, 0x000fe200078e00ffULL,
0x000000047bd17810ULL, 0x000fe40007ffe0ffULL, 0x0000000724277812ULL, 0x000fc400078ec0ffULL,
0x00000004d3cf7810ULL, 0x000fe20007ffe0ffULL, 0x00000001d1e37824ULL, 0x100fe200078e0202ULL,
0x0ffffff827e47812ULL, 0x100fe200078ef802ULL, 0x00000008d1327824ULL, 0x000fe200078e00ffULL,
0x000000087bcd7810ULL, 0x000fe40007ffe0ffULL, 0x00000081e4be7211ULL, 0x000fe400078e20ffULL,
0xfffffff832e37812ULL, 0x000fe200078ee2e3ULL, 0x00000001cde27824ULL, 0x000fe200078e0202ULL,
0x00000008d3cb7810ULL, 0x000fe20007ffe0ffULL, 0x00000008cd337824ULL, 0x000fe200078e00ffULL,
0x0000000c7bc97810ULL, 0x000fe20007ffe0ffULL, 0x00000010e3bc7824ULL, 0x000fe200078e0281ULL,
0x0000000cd3c77810ULL, 0x000fc40007ffe0ffULL, 0xfffffff833e27812ULL, 0x000fe200078ee2e2ULL,
0x00000008c9327824ULL, 0x040fe200078e00ffULL, 0x00000002c9e17210ULL, 0x000fe40007ffe0ffULL,
0x000000107bc57810ULL, 0x000fe20007ffe0ffULL, 0x00000010e2ba7824ULL, 0x000fe200078e0281ULL,
0xfffffff832e17812ULL, 0x000fe400078ee2e1ULL, 0x00000010d3c37810ULL, 0x000fe20007ffe0ffULL,
0x00000001c5e07824ULL, 0x040fe200078e0202ULL, 0x00000003c5337819ULL, 0x000fe200000006ffULL,
0x00000010e1b87824ULL, 0x000fe200078e0281ULL, 0x00000014d3bf7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff833e07812ULL, 0x000fe400078ee2e0ULL, 0x000000147bc17810ULL, 0x000fe20007ffe0ffULL,
0x0000000425267824ULL, 0x002fe200078e029aULL, 0x000000187bbd7810ULL, 0x000fe20007ffe0ffULL,
0x00000010e0b67824ULL, 0x000fe200078e0281ULL, 0x00000018d3bb7810ULL, 0x000fe20007ffe0ffULL,
0x00000001c1df7824ULL, 0x100fe200078e0202ULL, 0x0000001c7bb97810ULL, 0x000fe20007ffe0ffULL,
0x0000000026267984ULL, 0x000e620000000800ULL, 0x00000008c1327824ULL, 0x000fe200078e00ffULL,
0x0000001cd3b77810ULL, 0x000fe20007ffe0ffULL, 0x00000001bdde7824ULL, 0x100fe200078e0202ULL,
0x000000207bb57810ULL, 0x000fe20007ffe0ffULL, 0x00000008bd337824ULL, 0x000fe200078e00ffULL,
0xfffffff832df7812ULL, 0x000fe200078ee2dfULL, 0x00000001b9dd7824ULL, 0x000fe200078e0202ULL,
0x00000020d3b37810ULL, 0x000fe20007ffe0ffULL, 0x00000008b9327824ULL, 0x000fe200078e00ffULL,
0x00000081dfb47211ULL, 0x000fc400078e20ffULL, 0xfffffff833de7812ULL, 0x000fe200078ee2deULL,
0x00000008b5337824ULL, 0x040fe200078e00ffULL, 0xfffffff832dd7812ULL, 0x000fe400078ee2ddULL,
0x00000002b5dc7210ULL, 0x000fe20007ffe0ffULL, 0x00000010deb27824ULL, 0x100fe200078e0281ULL,
0x000000247bb17810ULL, 0x000fe20007ffe0ffULL, 0x00000010ddb07824ULL, 0x100fe200078e0281ULL,
0xfffffff833dc7812ULL, 0x000fe400078ee2dcULL, 0x00000024d3af7810ULL, 0x000fe20007ffe0ffULL,
0x00000001b1db7824ULL, 0x040fe200078e0202ULL, 0x00000003b1327819ULL, 0x000fe200000006ffULL,
0x00000010dcae7824ULL, 0x000fe200078e0281ULL, 0x00000028d3ab7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff832db7812ULL, 0x000fe400078ee2dbULL, 0x000000287bad7810ULL, 0x040fe40007ffe0ffULL,
0x0000002c7ba97810ULL, 0x000fe20007ffe0ffULL, 0x00000010dbac7824ULL, 0x000fe200078e0281ULL,
0x0000002cd3a77810ULL, 0x000fe20007ffe0ffULL, 0x00000001adda7824ULL, 0x100fe200078e0202ULL,
0x000000307ba57810ULL, 0x000fe20007ffe0ffULL, 0x00000008ad337824ULL, 0x000fe200078e00ffULL,
0x00000030d3a37810ULL, 0x000fe20007ffe0ffULL, 0x00000001a9d97824ULL, 0x000fe200078e0202ULL,
0x000000347ba17810ULL, 0x000fe20007ffe0ffULL, 0x0000002604257224ULL, 0x002fe200078e02d3ULL,
0xfffffff833da7812ULL, 0x000fe200078ee2daULL, 0x00000008a9327824ULL, 0x000fe200078e00ffULL,
0x00000034d39f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0025247625ULL, 0x000fe200078e0098ULL,
0x00000081daaa7211ULL, 0x000fc400078e20ffULL, 0xfffffff832d97812ULL, 0x000fe200078ee2d9ULL,
0x00000001a5d87824ULL, 0x000fe200078e0202ULL, 0x00000002a1d67210ULL, 0x000fe20007ffe0ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000387b9d7810ULL, 0x000fe40007ffe0ffULL,
0x00000038d39b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010d9a87824ULL, 0x000fe200078e0281ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024be7faeULL, 0x0003e2000b901c46ULL,
0x00000008a5337824ULL, 0x000fe200078e00ffULL, 0x0000003cd3977810ULL, 0x000fe20007ffe0ffULL,
0x000000019dd47824ULL, 0x000fe200078e0202ULL, 0x01c610009c277984ULL, 0x000ea20000000800ULL,
0x0000003c7b997810ULL, 0x000fc40007ffe0ffULL, 0xfffffff833d87812ULL, 0x000fe200078ee2d8ULL,
0x00000008a1337824ULL, 0x000fe400078e00ffULL, 0x0000000199d27824ULL, 0x000fe400078e0202ULL,
0x00000010d8a67824ULL, 0x000fe200078e0281ULL, 0xfffffff833d67812ULL, 0x000fe400078ee2d6ULL,
0x000000039d337819ULL, 0x000fc600000006ffULL, 0x00000010d6a47824ULL, 0x000fe200078e0281ULL,
0xfffffff833d47812ULL, 0x000fe200078ee2d4ULL, 0x0000000899337824ULL, 0x000fc800078e00ffULL,
0x00000010d4a27824ULL, 0x000fe200078e0281ULL, 0xfffffff833d27812ULL, 0x000fc800078ee2d2ULL,
0x00000081d2a07211ULL, 0x000fe200078e20ffULL, 0x0000000427307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004277224ULL, 0x004fc800078e02cfULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026bc7faeULL, 0x0005e8000b901c46ULL,
0x01c620009c257984ULL, 0x002e640000000800ULL, 0x0000009a25307211ULL, 0x002fcc00078e10ffULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004257224ULL, 0x002fc800078e02cbULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x004fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026ba7faeULL, 0x0003e8000b901c46ULL,
0x01c630009c257984ULL, 0x000ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e02c7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b87faeULL, 0x0005e8000b901c46ULL,
0x01c640009c277984ULL, 0x002e640000000800ULL, 0x0000000427307824ULL, 0x002fcc00078e029aULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e02c3ULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b67faeULL, 0x0003e8000b901c46ULL,
0x01c650009c257984ULL, 0x004ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e02bfULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b47faeULL, 0x0005e8000b901c46ULL,
0x01c660009c277984ULL, 0x002e640000000800ULL, 0x0000000427307824ULL, 0x002fcc00078e029aULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e02bbULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b27faeULL, 0x0003e8000b901c46ULL,
0x01c670009c257984ULL, 0x004ea40000000800ULL, 0x0000009a25307211ULL, 0x004fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e02b7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b07faeULL, 0x0005e8000b901c46ULL,
0x01c680009c277984ULL, 0x002e640000000800ULL, 0x0000000427307824ULL, 0x002fcc00078e029aULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e02b3ULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026ae7faeULL, 0x0003e8000b901c46ULL,
0x01c690009c257984ULL, 0x004ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e02afULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ac7faeULL, 0x0005e8000b901c46ULL,
0x01c6a0009c277984ULL, 0x002e640000000800ULL, 0x0000000427307824ULL, 0x002fcc00078e029aULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e02abULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026aa7faeULL, 0x0003e8000b901c46ULL,
0x01c6b0009c257984ULL, 0x004ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e02a7ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a87faeULL, 0x0005e8000b901c46ULL,
0x01c6c0009c277984ULL, 0x002e640000000800ULL, 0x0000009a27307211ULL, 0x002fcc00078e10ffULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e02a3ULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a67faeULL, 0x0003e8000b901c46ULL,
0x01c6d0009c257984ULL, 0x004ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e029fULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a47faeULL, 0x0005e8000b901c46ULL,
0x01c6e0009c277984ULL, 0x002e640000000800ULL, 0x0000000427307824ULL, 0x002fcc00078e029aULL,
0x0000000030307984ULL, 0x000e640000000800ULL, 0x0000003004277224ULL, 0x002fc800078e029bULL,
0x00005e0027267625ULL, 0x000fcc00078e0098ULL, 0x0000001031267825ULL, 0x000fca00078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a27faeULL, 0x0003e8000b901c46ULL,
0x01c6f0009c257984ULL, 0x004ea40000000800ULL, 0x0000000425307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004257224ULL, 0x004fc800078e0297ULL,
0x00005e0025247625ULL, 0x000fcc00078e0098ULL, 0x0000001031247825ULL, 0x000fca00078e0024ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a07faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002078257824ULL, 0x002fe200078e00ffULL,
0x0000000879247810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe025247812ULL, 0x000fe200078ee224ULL, 0x0000002078517824ULL, 0x000fe200078e00ffULL,
0x00004000e5e57810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000a79507810ULL, 0x000fe20007ffe0ffULL, 0x0000001024307824ULL, 0x000fe200078e00ffULL,
0x000000e592927211ULL, 0x080fe200078e20ffULL, 0x000000109e9e7824ULL, 0x100fe200078e02e5ULL,
0xffffffe051507812ULL, 0x000fe200078ee250ULL, 0x00000010ec957824ULL, 0x100fe200078e02e5ULL,
0x000000e5808d7211ULL, 0x080fe200078e20ffULL, 0x000000003030783bULL, 0x000fe20000000200ULL,
0x000000108c8c7824ULL, 0x100fe200078e02e5ULL, 0x000000e58a8a7211ULL, 0x000fe200078e20ffULL,
0x00000010e6837824ULL, 0x100fe200078e02e5ULL, 0x000000009e4c783bULL, 0x000e620000000200ULL,
0x000000108e8e7824ULL, 0x100fe200078e02e5ULL, 0x00001be000007945ULL, 0x000fe20003800000ULL,
0x00000010e8817824ULL, 0x100fe200078e02e5ULL, 0x000000009534783bULL, 0x000ea20000000200ULL,
0x00000010ea807824ULL, 0x000fc400078e02e5ULL, 0x0000001096967824ULL, 0x100fe200078e02e5ULL,
0x000000009224783bULL, 0x000ee20000000200ULL, 0x0000001094947824ULL, 0x100fe400078e02e5ULL,
0x0000001091917824ULL, 0x100fe200078e02e5ULL, 0x000000008c44783bULL, 0x000f220000000200ULL,
0x000000108b8b7824ULL, 0x100fe400078e02e5ULL, 0x0000001089897824ULL, 0x100fe200078e02e5ULL,
0x000000008e54783bULL, 0x000fe20000000200ULL, 0x0000001082827824ULL, 0x000fc600078e02e5ULL,
0x000000009664783bULL, 0x000fe80000000200ULL, 0x000000009458783bULL, 0x000fe80000000200ULL,
0x000000008a60783bULL, 0x000fe20000000200ULL, 0x0000004c302c723cULL, 0x042bee000000182cULL,
0x00000010504c7824ULL, 0x020fe200078e00ffULL, 0x0000004e3068723cULL, 0x040be20000001868ULL,
0x000000008d50783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x020e660000000200ULL,
0x00000034303c723cULL, 0x044f70000000183cULL, 0x000000363038723cULL, 0x040be40000001838ULL,
0x000000008334783bULL, 0x020eac0000000200ULL, 0x000000243040723cULL, 0x048f700000001840ULL,
0x000000263048723cULL, 0x040b640000001848ULL, 0x000000008124783bULL, 0x020eec0000000200ULL,
0x00000044305c723cULL, 0x050b6e000000185cULL, 0x0000002078457824ULL, 0x020fe200078e00ffULL,
0x0000000c79447810ULL, 0x000fe20007ffe0ffULL, 0x000000463028723cULL, 0x000b660000001828ULL,
0xffffffe045447812ULL, 0x000fc800078ee244ULL, 0x0000000444307819ULL, 0x020fe200000006ffULL,
0x000000504c3c723cULL, 0x042be2000000183cULL, 0x000000008044783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000e640000000200ULL, 0x0000002078517824ULL, 0x020fe200078e00ffULL,
0x000000344c40723cULL, 0x004fe20000001840ULL, 0x0000000e79507810ULL, 0x000fc80007ffe0ffULL,
0xffffffe051507812ULL, 0x000fc600078ee250ULL, 0x000000364c34723cULL, 0x000be40000001848ULL,
0x000000009148783bULL, 0x020ea20000000200ULL, 0x0000001050507824ULL, 0x000fca00078e00ffULL,
0x000000544c2c723cULL, 0x040f70000000182cULL, 0x000000564c68723cULL, 0x040b640000001868ULL,
0x000000008954783bULL, 0x020fec0000000200ULL, 0x000000524c38723cULL, 0x040b640000001838ULL,
0x000000005050783bULL, 0x020f2c0000000200ULL, 0x000000244c5c723cULL, 0x048f70000000185cULL,
0x000000264c4c723cULL, 0x000b640000001828ULL, 0x000000008b24783bULL, 0x020ee80000000200ULL,
0x000000008228783bULL, 0x000ea20000000200ULL, 0x000080000000791aULL, 0x000fc80000000000ULL,
0x00000044302c723cULL, 0x042f70000000182cULL, 0x00000064303c723cULL, 0x040f70000000183cULL,
0x000000583040723cULL, 0x040f700000001840ULL, 0x000000463044723cULL, 0x040f700000001868ULL,
0x000000663038723cULL, 0x040f700000001838ULL, 0x0000005a3034723cULL, 0x040f700000001834ULL,
0x00000048305c723cULL, 0x044f70000000185cULL, 0x0000004a3030723cULL, 0x000f70000000184cULL,
0x00000060502c723cULL, 0x070f70000000182cULL, 0x00000024503c723cULL, 0x048f70000000183cULL,
0x000000545040723cULL, 0x040f700000001840ULL, 0x000000625060723cULL, 0x040f700000001844ULL,
0x000000265024723cULL, 0x040f700000001838ULL, 0x000000565054723cULL, 0x040f700000001834ULL,
0x00000028505c723cULL, 0x040f70000000185cULL, 0x0000002a5050723cULL, 0x000b6e0000001830ULL,
0x000000036f327812ULL, 0x020fc800078ec0ffULL, 0x000000ff32327207ULL, 0x000fe20005000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000c4000008947ULL, 0x000fea0003800000ULL,
0x01c600009c297984ULL, 0x000e620000000800ULL, 0x00000018d5d57812ULL, 0x000fe200078efcffULL,
0x00000010e4337824ULL, 0x100fe200078e02e5ULL, 0x000000e5dbdb7211ULL, 0x080fe200078e20ffULL,
0x00000010e3e37824ULL, 0x100fe200078e02e5ULL, 0x000000e5d4377211ULL, 0x000fe200078e20ffULL,
0x00000010e2357824ULL, 0x100fe400078e02e5ULL, 0x00000010e1e17824ULL, 0x100fe400078e02e5ULL,
0x00000010dfdf7824ULL, 0x000fc400078e02e5ULL, 0x00000010dddd7824ULL, 0x100fe400078e02e5ULL,
0x00000010d9d97824ULL, 0x000fe200078e02e5ULL, 0x0000009a29307211ULL, 0x002fe400078e10ffULL,
0x000000d071297217ULL, 0x000fc80007800000ULL, 0x0000000030307984ULL, 0x000e620000000800ULL,
0x0000000129d07824ULL, 0x000fca00078e0ad0ULL, 0x000000d07b00720cULL, 0x000fe20003f06070ULL,
0x0000003004297224ULL, 0x002fc800078e02d3ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a337faeULL, 0x0003e2000c101c46ULL, 0x000000d0d100720cULL, 0x000fc60003f06070ULL,
0x01c610009c297984ULL, 0x000ea40000000800ULL, 0x0000000429347824ULL, 0x004fcc00078e029aULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02cfULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030e37faeULL, 0x0005e2000c101c46ULL,
0x000000d0cd00720cULL, 0x000fc60003f06070ULL, 0x01c620009c297984ULL, 0x000e640000000800ULL,
0x0000009a29337211ULL, 0x002fcc00078e10ffULL, 0x0000000033337984ULL, 0x000e640000000800ULL,
0x0000003304297224ULL, 0x002fc800078e02cbULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0003e2000c101c46ULL, 0x000000d0c900720cULL, 0x000fc60003f06070ULL,
0x01c630009c297984ULL, 0x000ee20000000800ULL, 0x000000e5e0357211ULL, 0x002fe200078e20ffULL,
0x0000000429347824ULL, 0x008fcc00078e029aULL, 0x0000000034347984ULL, 0x000e640000000800ULL,
0x0000003404297224ULL, 0x002fc800078e02c7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x004fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030e17faeULL, 0x0003e2000c101c46ULL, 0x000000d0c500720cULL, 0x000fc60003f06070ULL,
0x01c640009c297984ULL, 0x000ea40000000800ULL, 0x0000000429337824ULL, 0x004fcc00078e029aULL,
0x0000000033337984ULL, 0x000ea40000000800ULL, 0x0000003304297224ULL, 0x004fc800078e02c3ULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e2000c101c46ULL,
0x000000d0c100720cULL, 0x000fc60003f06070ULL, 0x01c650009c297984ULL, 0x000ee20000000800ULL,
0x00000010de357824ULL, 0x004fe400078e02e5ULL, 0x0000000429347824ULL, 0x008fcc00078e029aULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02bfULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030df7faeULL, 0x0003e2000c101c46ULL,
0x000000d0bd00720cULL, 0x000fc60003f06070ULL, 0x01c660009c297984ULL, 0x000ea40000000800ULL,
0x0000000429337824ULL, 0x004fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e02bbULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0005e2000c101c46ULL, 0x000000d0b900720cULL, 0x000fc60003f06070ULL,
0x01c670009c297984ULL, 0x000ee20000000800ULL, 0x00000010dc357824ULL, 0x004fe200078e02e5ULL,
0x0000009a29347211ULL, 0x008fcc00078e10ffULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e02b7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030dd7faeULL, 0x0003e2000c101c46ULL, 0x000000d0b500720cULL, 0x000fc60003f06070ULL,
0x01c680009c297984ULL, 0x000ea40000000800ULL, 0x0000000429337824ULL, 0x004fcc00078e029aULL,
0x0000000033337984ULL, 0x000ea40000000800ULL, 0x0000003304297224ULL, 0x004fc800078e02b3ULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e2000c101c46ULL,
0x000000d0b100720cULL, 0x000fc60003f06070ULL, 0x01c690009c297984ULL, 0x000ee20000000800ULL,
0x00000010da357824ULL, 0x004fe400078e02e5ULL, 0x0000000429347824ULL, 0x008fcc00078e029aULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02afULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030db7faeULL, 0x0003e2000c101c46ULL,
0x000000d0ad00720cULL, 0x000fc60003f06070ULL, 0x01c6a0009c297984ULL, 0x000ea40000000800ULL,
0x0000000429337824ULL, 0x004fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e02abULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0005e2000c101c46ULL, 0x000000d0a900720cULL, 0x000fc60003f06070ULL,
0x01c6b0009c297984ULL, 0x000ee20000000800ULL, 0x00000010d8357824ULL, 0x004fe400078e02e5ULL,
0x0000000429347824ULL, 0x008fcc00078e029aULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e02a7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030d97faeULL, 0x0003e2000c101c46ULL, 0x000000d0a500720cULL, 0x000fc60003f06070ULL,
0x01c6c0009c297984ULL, 0x000ea40000000800ULL, 0x0000009a29337211ULL, 0x004fcc00078e10ffULL,
0x0000000033337984ULL, 0x000ea40000000800ULL, 0x0000003304297224ULL, 0x004fe400078e02a3ULL,
0x00000010d6337824ULL, 0x000fe400078e02e5ULL, 0x00005e0029287625ULL, 0x000fc800078e0098ULL,
0x00000010d2e57824ULL, 0x000fe400078e02e5ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e2000c101c46ULL,
0x000000d0a100720cULL, 0x000fc60003f06070ULL, 0x01c6d0009c297984ULL, 0x000ee40000000800ULL,
0x0000000429347824ULL, 0x008fcc00078e029aULL, 0x0000000034347984ULL, 0x000ee40000000800ULL,
0x0000003404297224ULL, 0x008fc800078e029fULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000c101c46ULL, 0x000000d09d00720cULL, 0x000fc60003f06070ULL,
0x01c6e0009c297984ULL, 0x000ea40000000800ULL, 0x0000000429357824ULL, 0x004fcc00078e029aULL,
0x0000000035357984ULL, 0x000ea40000000800ULL, 0x0000003504297224ULL, 0x004fc800078e029bULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0005e2000c101c46ULL,
0x000000d09900720cULL, 0x000fc60003f06070ULL, 0x01c6f0009c297984ULL, 0x000e640000000800ULL,
0x0000000429307824ULL, 0x002fcc00078e029aULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003004297224ULL, 0x002fc800078e0297ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028e57faeULL, 0x0005e2000c101c46ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x01c600009c297984ULL, 0x000e620000000800ULL, 0x00000018d5d57812ULL, 0x000fe200078efcffULL,
0x00000010e4357824ULL, 0x100fe200078e02e5ULL, 0x000000e5e1e17211ULL, 0x080fe200078e20ffULL,
0x00000010e3e37824ULL, 0x100fe200078e02e5ULL, 0x000000e5d6377211ULL, 0x000fe200078e20ffULL,
0x00000010dfdf7824ULL, 0x100fe400078e02e5ULL, 0x00000010dddd7824ULL, 0x100fe400078e02e5ULL,
0x00000010dbdb7824ULL, 0x000fc400078e02e5ULL, 0x00000010d9d97824ULL, 0x000fe400078e02e5ULL,
0x0000000429307824ULL, 0x002fcc00078e029aULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003004297224ULL, 0x002fc800078e02d3ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0003e8000b901c46ULL, 0x01c610009c297984ULL, 0x000ea20000000800ULL,
0x00000010e2357824ULL, 0x002fe200078e02e5ULL, 0x0000009a29337211ULL, 0x004fcc00078e10ffULL,
0x0000000033337984ULL, 0x000e640000000800ULL, 0x0000003304297224ULL, 0x002fc800078e02cfULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030e37faeULL, 0x0003e8000b901c46ULL,
0x01c620009c297984ULL, 0x000ea40000000800ULL, 0x0000000429347824ULL, 0x004fcc00078e029aULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02cbULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e8000b901c46ULL,
0x01c630009c297984ULL, 0x000ee20000000800ULL, 0x00000010e0357824ULL, 0x004fe400078e02e5ULL,
0x0000000429337824ULL, 0x008fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e02c7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030e17faeULL, 0x0003e8000b901c46ULL, 0x01c640009c297984ULL, 0x000ea40000000800ULL,
0x0000000429347824ULL, 0x004fcc00078e029aULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e02c3ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0005e8000b901c46ULL, 0x01c650009c297984ULL, 0x000ee20000000800ULL,
0x00000010de357824ULL, 0x004fe400078e02e5ULL, 0x0000000429337824ULL, 0x008fcc00078e029aULL,
0x0000000033337984ULL, 0x000ea40000000800ULL, 0x0000003304297224ULL, 0x004fc800078e02bfULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030df7faeULL, 0x0003e8000b901c46ULL,
0x01c660009c297984ULL, 0x000ea40000000800ULL, 0x0000009a29347211ULL, 0x004fcc00078e10ffULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02bbULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e8000b901c46ULL,
0x01c670009c297984ULL, 0x000ee20000000800ULL, 0x000000e5dc357211ULL, 0x004fe200078e20ffULL,
0x0000000429337824ULL, 0x008fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e02b7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030dd7faeULL, 0x0003e8000b901c46ULL, 0x01c680009c297984ULL, 0x000ea40000000800ULL,
0x0000000429347824ULL, 0x004fcc00078e029aULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e02b3ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0005e8000b901c46ULL, 0x01c690009c297984ULL, 0x000ee20000000800ULL,
0x00000010da357824ULL, 0x004fe400078e02e5ULL, 0x0000000429337824ULL, 0x008fcc00078e029aULL,
0x0000000033337984ULL, 0x000ea40000000800ULL, 0x0000003304297224ULL, 0x004fc800078e02afULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d5307825ULL, 0x002fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030db7faeULL, 0x0003e8000b901c46ULL,
0x01c6a0009c297984ULL, 0x000ea40000000800ULL, 0x0000000429347824ULL, 0x004fcc00078e029aULL,
0x0000000034347984ULL, 0x000ea40000000800ULL, 0x0000003404297224ULL, 0x004fc800078e02abULL,
0x00005e0029287625ULL, 0x000fcc00078e0098ULL, 0x00000010d52a7825ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a357faeULL, 0x0005e8000b901c46ULL,
0x01c6b0009c297984ULL, 0x000ee20000000800ULL, 0x00000010d8357824ULL, 0x004fe200078e02e5ULL,
0x0000009a29337211ULL, 0x008fcc00078e10ffULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e02a7ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030d97faeULL, 0x0003e8000b901c46ULL, 0x01c6c0009c297984ULL, 0x000ea40000000800ULL,
0x0000000429347824ULL, 0x004fcc00078e029aULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e02a3ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0005e8000b901c46ULL, 0x01c6d0009c297984ULL, 0x000ee20000000800ULL,
0x00000010d4357824ULL, 0x104fe400078e02e5ULL, 0x00000010d2e57824ULL, 0x000fe400078e02e5ULL,
0x0000000429337824ULL, 0x008fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e029fULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5307825ULL, 0x002fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030377faeULL, 0x0003e8000b901c46ULL, 0x01c6e0009c297984ULL, 0x000ea40000000800ULL,
0x0000000429347824ULL, 0x004fcc00078e029aULL, 0x0000000034347984ULL, 0x000ea40000000800ULL,
0x0000003404297224ULL, 0x004fc800078e029bULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d52a7825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a357faeULL, 0x0003e8000b901c46ULL, 0x01c6f0009c297984ULL, 0x000ea40000000800ULL,
0x0000000429337824ULL, 0x004fcc00078e029aULL, 0x0000000033337984ULL, 0x000ea40000000800ULL,
0x0000003304297224ULL, 0x004fc800078e0297ULL, 0x00005e0029287625ULL, 0x000fcc00078e0098ULL,
0x00000010d5287825ULL, 0x000fca00078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028e57faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000132287810ULL, 0x006fe20007ffe0ffULL, 0x0000002078307824ULL, 0x000fe200078e00ffULL,
0x000000d76e00720cULL, 0x000fe20003f04070ULL, 0x00000004ff497424ULL, 0x000fe200078e00ffULL,
0x00000002ff297819ULL, 0x000fe20000011628ULL, 0x0000000402d57824ULL, 0x000fe200078e00ffULL,
0x0000000328287812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000001292a7807ULL, 0x000fe20004000000ULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000ff28287207ULL, 0x000fe20004000000ULL, 0x00000001864b7824ULL, 0x000fe200078e02d5ULL,
0x000000d76e00720cULL, 0x000fe20003f24070ULL, 0x000003002a297a24ULL, 0x000fe200078e02d7ULL,
0x000000033200780cULL, 0x000fe20003f85270ULL, 0x0000000173287824ULL, 0x000fe200078e0228ULL,
0x00000010792b7810ULL, 0x000fe40007ffe0ffULL, 0x0000008829297211ULL, 0x000fc400078e40ffULL,
0xffffffe030307812ULL, 0x000fe400078ee22bULL, 0x0000002002487810ULL, 0x000fe20007ffe0ffULL,
0x00006800282b7a24ULL, 0x000fe200078e0229ULL, 0x0000000430447819ULL, 0x000fe200000006ffULL,
0x00000001292a7824ULL, 0x100fe200078e0202ULL, 0x0000002948287210ULL, 0x040fe20007ffe0ffULL,
0x000000012b347824ULL, 0x000fe400078e0202ULL, 0x0000000148487824ULL, 0x000fe200078e022bULL,
0x000000712a00720cULL, 0x000fe20003f06070ULL, 0x0000660034347625ULL, 0x000fe200078e0049ULL,
0x000000712800720cULL, 0x000fc60003f66070ULL, 0x0000660048487625ULL, 0x000fe200078e0049ULL,
0x000000f000009947ULL, 0x000fea0002000000ULL, 0x000000030200780cULL, 0x000fe20003f24070ULL,
0x00000004ff287424ULL, 0x000fc800078e00ffULL, 0x0000030028877a24ULL, 0x000fd000078e0287ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000400297824ULL, 0x100fe200078e0202ULL,
0x000000728700720cULL, 0x000fe20003f26070ULL, 0x00000004752b7824ULL, 0x000fe400078e0202ULL,
0x00000002292a7824ULL, 0x000fc600078e00ffULL, 0x0001ca802b2b7811ULL, 0x000fe200078e10ffULL,
0x000064002a297a24ULL, 0x000fc800078e0287ULL, 0x0000600029287625ULL, 0x000fca00078e0028ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282b7faeULL, 0x0003e4000c921846ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x1c600000344b7faeULL, 0x0005e2000c121846ULL, 0x0000001279367810ULL, 0x000fe20007ffe0ffULL,
0x00001c3000007945ULL, 0x000fe20003800000ULL, 0x0000000578377819ULL, 0x000fe200000006ffULL,
0x1c680000484b7faeULL, 0x0007e6000d921846ULL, 0xffffffe037367812ULL, 0x000fe200078ee236ULL,
0x000000004444783bULL, 0x000fe80000000200ULL, 0x00000000ca28783bULL, 0x002e620000000200ULL,
0x00000010364c7824ULL, 0x000fc600078e00ffULL, 0x00000000cc30783bULL, 0x000f280000000200ULL,
0x00000000ce38783bULL, 0x000f280000000200ULL, 0x00000000c664783bULL, 0x000f280000000200ULL,
0x00000000c434783bULL, 0x004fe80000000200ULL, 0x000000004c4c783bULL, 0x000ea80000000200ULL,
0x000000008f58783bULL, 0x000fe80000000200ULL, 0x00000000c248783bULL, 0x008fe80000000200ULL,
0x000000007c68783bULL, 0x000fe80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000284440723cULL, 0x042bee0000001840ULL, 0x0000002078297824ULL, 0x020fe200078e00ffULL,
0x0000001479287810ULL, 0x000fe20007ffe0ffULL, 0x00000030443c723cULL, 0x010fe6000000183cULL,
0xffffffe029287812ULL, 0x000fca00078ee228ULL, 0x000000324424723cULL, 0x040be20000001824ULL,
0x0000001028287824ULL, 0x000fe200078e00ffULL, 0x000000009030783bULL, 0x0202ec0000000200ULL,
0x00000038442c723cULL, 0x000f62000000182cULL, 0x000000016f907810ULL, 0x002fce0007ffe0ffULL,
0x0000003a4460723cULL, 0x040b640000001860ULL, 0x00000000c838783bULL, 0x020fec0000000200ULL,
0x0000002a4454723cULL, 0x040b640000001854ULL, 0x000000002828783bULL, 0x020e6c0000000200ULL,
0x00000064445c723cULL, 0x040f70000000185cULL, 0x000000664450723cULL, 0x000b640000001850ULL,
0x00000000c044783bULL, 0x020f2c0000000200ULL, 0x000000344c2c723cULL, 0x044f70000000182cULL,
0x000000364c34723cULL, 0x040f700000001860ULL, 0x000000304c3c723cULL, 0x048f70000000183cULL,
0x000000324c24723cULL, 0x040b640000001824ULL, 0x000000009330783bULL, 0x020eac0000000200ULL,
0x000000584c40723cULL, 0x040f700000001840ULL, 0x0000005a4c54723cULL, 0x040f700000001854ULL,
0x000000484c5c723cULL, 0x040f70000000185cULL, 0x0000004a4c4c723cULL, 0x000b640000001850ULL,
0x000000007f50783bULL, 0x020ee80000000200ULL, 0x000000007d48783bULL, 0x000fe40000000200ULL,
0x00000038282c723cULL, 0x042ff0000000182cULL, 0x0000003a2838723cULL, 0x040bee0000001834ULL,
0x0000002078357824ULL, 0x020fe200078e00ffULL, 0x0000001679347810ULL, 0x000fe20007ffe0ffULL,
0x00000044283c723cULL, 0x010fe6000000183cULL, 0xffffffe035347812ULL, 0x000fc800078ee234ULL,
0x0000000434647819ULL, 0x000fe200000006ffULL, 0x000000462844723cULL, 0x040be20000001824ULL,
0x000000007e34783bULL, 0x000fe80000000200ULL, 0x000000006464783bULL, 0x000e660000000200ULL,
0x000000302840723cULL, 0x004f640000001840ULL, 0x000000007a24783bULL, 0x020ea20000000200ULL,
0x000080000000791aULL, 0x000fca0000000000ULL, 0x000000322830723cULL, 0x040f700000001854ULL,
0x00000050285c723cULL, 0x048f70000000185cULL, 0x000000522828723cULL, 0x000f70000000184cULL,
0x000000686440723cULL, 0x042f700000001840ULL, 0x0000006a6468723cULL, 0x060b6e0000001830ULL,
0x00000002ff317819ULL, 0x020fe20000011690ULL, 0x00000024645c723cULL, 0x044b6e000000185cULL,
0x0000003190247207ULL, 0x020fe20001000000ULL, 0x00000034643c723cULL, 0x000b68000000183cULL,
0x0000030024317a24ULL, 0x000fc800078e0277ULL, 0x00000048642c723cULL, 0x000b62000000182cULL,
0x0000000131257810ULL, 0x000fc80007ffe0ffULL, 0x000000702500720cULL, 0x000fc60003f06070ULL,
0x0000004a6438723cULL, 0x040b700000001838ULL, 0x000000366434723cULL, 0x040b700000001844ULL,
0x000000266464723cULL, 0x000b620000001828ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000c6000008947ULL, 0x000fca0003800000ULL, 0x01c600009c257984ULL, 0x020e620000000800ULL,
0x0000010031287824ULL, 0x000fe400078e0288ULL, 0x0000001002297824ULL, 0x000fca00078e00ffULL,
0x0000007029297812ULL, 0x000fe200078ec0ffULL, 0x0000000425267824ULL, 0x002fe200078e029aULL,
0x0000002871257217ULL, 0x000fca0007800000ULL, 0x0000000026267984ULL, 0x000e620000000800ULL,
0x0000000125287824ULL, 0x000fca00078e0a28ULL, 0x000000287b00720cULL, 0x000fe20003f06070ULL,
0x0000002604d37224ULL, 0x002fc800078e02d3ULL, 0x00005e00d3247625ULL, 0x000fca00078e0098ULL,
0x0000002429247210ULL, 0x000fc80007f3e0ffULL, 0x00000025ff257210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024be7faeULL, 0x0003e2000c101c46ULL,
0x00000028d100720cULL, 0x000fc60003f06070ULL, 0x01c610009c277984ULL, 0x000ea40000000800ULL,
0x00000004272a7824ULL, 0x004fcc00078e029aULL, 0x000000002a2a7984ULL, 0x000ea40000000800ULL,
0x0000002a04277224ULL, 0x004fc800078e02cfULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002629267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026bc7faeULL, 0x0005e2000c101c46ULL,
0x00000028cd00720cULL, 0x000fc60003f06070ULL, 0x01c620009c2b7984ULL, 0x000ee40000000800ULL,
0x000000042b2b7824ULL, 0x008fcc00078e029aULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b04257224ULL, 0x002fc800078e02cbULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024ba7faeULL, 0x0003e2000c101c46ULL,
0x00000028c900720cULL, 0x000fc60003f06070ULL, 0x01c630009c317984ULL, 0x000ee40000000800ULL,
0x0000009a31317211ULL, 0x008fcc00078e10ffULL, 0x0000000031317984ULL, 0x000ea40000000800ULL,
0x0000003104277224ULL, 0x004fc800078e02c7ULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002629267210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b87faeULL, 0x0005e2000c101c46ULL,
0x00000028c500720cULL, 0x000fc60003f06070ULL, 0x01c640009c2b7984ULL, 0x000ee40000000800ULL,
0x000000042b2b7824ULL, 0x008fcc00078e029aULL, 0x000000002b2b7984ULL, 0x000e640000000800ULL,
0x0000002b04257224ULL, 0x002fc800078e02c3ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024b67faeULL, 0x0003e2000c101c46ULL,
0x00000028c100720cULL, 0x000fc60003f06070ULL, 0x01c650009c317984ULL, 0x000ee40000000800ULL,
0x0000000431317824ULL, 0x008fcc00078e029aULL, 0x0000000031317984ULL, 0x000ea40000000800ULL,
0x0000003104277224ULL, 0x004fc800078e02bfULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002629267210ULL, 0x000fc80007f3e0ffULL, 0x00000027ff277210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b47faeULL, 0x0005e2000c101c46ULL,
0x00000028bd00720cULL, 0x000fc60003f06070ULL, 0x01c660009c2b7984ULL, 0x000ee40000000800ULL,
0x000000042b307824ULL, 0x008fcc00078e029aULL, 0x0000000030307984ULL, 0x000e640000000800ULL,
0x0000003004257224ULL, 0x002fc800078e02bbULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x00000024292a7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002ab27faeULL, 0x0003e2000c101c46ULL,
0x00000028b900720cULL, 0x000fc60003f06070ULL, 0x01c670009c257984ULL, 0x000ee40000000800ULL,
0x0000000425317824ULL, 0x008fcc00078e029aULL, 0x0000000031317984ULL, 0x000ee40000000800ULL,
0x0000003104257224ULL, 0x008fc800078e02b7ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429267210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026b07faeULL, 0x0005e2000c101c46ULL,
0x00000028b500720cULL, 0x000fc60003f06070ULL, 0x01c680009c257984ULL, 0x000ee40000000800ULL,
0x0000009a25307211ULL, 0x008fcc00078e10ffULL, 0x0000000030307984ULL, 0x000ee40000000800ULL,
0x0000003004257224ULL, 0x008fc800078e02b3ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x00000024292a7210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aae7faeULL, 0x0003e2000c101c46ULL,
0x00000028b100720cULL, 0x000fc60003f06070ULL, 0x01c690009c257984ULL, 0x000ee40000000800ULL,
0x0000000425317824ULL, 0x008fcc00078e029aULL, 0x0000000031317984ULL, 0x000ee40000000800ULL,
0x0000003104257224ULL, 0x008fc800078e02afULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429267210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026ac7faeULL, 0x0005e2000c101c46ULL,
0x00000028ad00720cULL, 0x000fc60003f06070ULL, 0x01c6a0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425307824ULL, 0x008fcc00078e029aULL, 0x0000000030307984ULL, 0x000ee40000000800ULL,
0x0000003004257224ULL, 0x008fc800078e02abULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x00000024292a7210ULL, 0x002fc80007f3e0ffULL, 0x00000025ff2b7210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aaa7faeULL, 0x0003e2000c101c46ULL,
0x00000028a900720cULL, 0x000fc60003f06070ULL, 0x01c6b0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425317824ULL, 0x008fcc00078e029aULL, 0x0000000031317984ULL, 0x000ee40000000800ULL,
0x0000003104257224ULL, 0x008fc800078e02a7ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429267210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a87faeULL, 0x0005e2000c101c46ULL,
0x00000028a500720cULL, 0x000fc60003f06070ULL, 0x01c6c0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425307824ULL, 0x008fcc00078e029aULL, 0x0000000030307984ULL, 0x000ee40000000800ULL,
0x0000003004257224ULL, 0x008fc800078e02a3ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x00000024292a7210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa67faeULL, 0x0003e2000c101c46ULL,
0x00000028a100720cULL, 0x000fc60003f06070ULL, 0x01c6d0009c257984ULL, 0x000ee40000000800ULL,
0x0000009a25317211ULL, 0x008fcc00078e10ffULL, 0x0000000031317984ULL, 0x000ee40000000800ULL,
0x0000003104257224ULL, 0x008fc800078e029fULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429267210ULL, 0x004fca0007f3e0ffULL, 0x000000ffff277224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a47faeULL, 0x0005e2000c101c46ULL,
0x000000289d00720cULL, 0x000fc60003f06070ULL, 0x01c6e0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425307824ULL, 0x008fcc00078e029aULL, 0x0000000030307984ULL, 0x000ee40000000800ULL,
0x0000003004257224ULL, 0x008fc800078e029bULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x00000024292a7210ULL, 0x002fca0007f3e0ffULL, 0x000000ffff2b7224ULL, 0x000fca00008e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002aa27faeULL, 0x0005e2000c101c46ULL,
0x000000289900720cULL, 0x000fc60003f06070ULL, 0x01c6f0009c257984ULL, 0x000e640000000800ULL,
0x00000004259a7824ULL, 0x002fcc00078e029aULL, 0x000000009a9a7984ULL, 0x000e640000000800ULL,
0x0000009a04257224ULL, 0x002fc800078e0297ULL, 0x00005e0025247625ULL, 0x000fca00078e0098ULL,
0x0000002429247210ULL, 0x000fc80007f3e0ffULL, 0x00000025ff257210ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024a07faeULL, 0x0005e2000c101c46ULL,
0x00000b2000007947ULL, 0x000fea0003800000ULL, 0x01c600009c257984ULL, 0x020e620000000800ULL,
0x0000001002247824ULL, 0x000fca00078e00ffULL, 0x0000007024247812ULL, 0x000fe200078ec0ffULL,
0x0000000425257824ULL, 0x002fcc00078e029aULL, 0x0000000025257984ULL, 0x000e640000000800ULL,
0x0000002504277224ULL, 0x002fc800078e02d3ULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028be7faeULL, 0x0003e8000b901c46ULL,
0x01c610009c277984ULL, 0x000ea40000000800ULL, 0x0000000427307824ULL, 0x004fcc00078e029aULL,
0x0000000030307984ULL, 0x000ea40000000800ULL, 0x0000003004277224ULL, 0x004fc800078e02cfULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x000fc80007f1e0ffULL,
0x00000027ff2b7210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002abc7faeULL, 0x0005e8000b901c46ULL, 0x01c620009c257984ULL, 0x000ee40000000800ULL,
0x0000000425257824ULL, 0x008fcc00078e029aULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02cbULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ba7faeULL, 0x0003e8000b901c46ULL,
0x01c630009c277984ULL, 0x000ee40000000800ULL, 0x0000000427307824ULL, 0x008fcc00078e029aULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e02c7ULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab87faeULL, 0x0005e8000b901c46ULL, 0x01c640009c257984ULL, 0x000ee40000000800ULL,
0x0000009a25257211ULL, 0x008fcc00078e10ffULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02c3ULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b67faeULL, 0x0003e8000b901c46ULL,
0x01c650009c277984ULL, 0x000ee40000000800ULL, 0x0000000427307824ULL, 0x008fcc00078e029aULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e02bfULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab47faeULL, 0x0005e8000b901c46ULL, 0x01c660009c257984ULL, 0x000ee40000000800ULL,
0x0000000425257824ULL, 0x008fcc00078e029aULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02bbULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fc80007f1e0ffULL, 0x00000027ff297210ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028b27faeULL, 0x0003e8000b901c46ULL,
0x01c670009c277984ULL, 0x000ee40000000800ULL, 0x0000000427307824ULL, 0x008fcc00078e029aULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e02b7ULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002ab07faeULL, 0x0005e8000b901c46ULL, 0x01c680009c257984ULL, 0x000ee40000000800ULL,
0x0000000425257824ULL, 0x008fcc00078e029aULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02b3ULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028ae7faeULL, 0x0003e8000b901c46ULL,
0x01c690009c277984ULL, 0x000ee40000000800ULL, 0x0000009a27307211ULL, 0x008fcc00078e10ffULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e02afULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aac7faeULL, 0x0005e8000b901c46ULL, 0x01c6a0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425257824ULL, 0x008fcc00078e029aULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02abULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028aa7faeULL, 0x0003e8000b901c46ULL,
0x01c6b0009c277984ULL, 0x000ee40000000800ULL, 0x0000000427307824ULL, 0x008fcc00078e029aULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e02a7ULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fc80007f1e0ffULL,
0x00000027ff2b7210ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa87faeULL, 0x0005e8000b901c46ULL, 0x01c6c0009c257984ULL, 0x000ee40000000800ULL,
0x0000000425257824ULL, 0x008fcc00078e029aULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e02a3ULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624287210ULL, 0x002fca0007f1e0ffULL, 0x000000ffff297224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028a67faeULL, 0x0003e8000b901c46ULL,
0x01c6d0009c277984ULL, 0x000ee40000000800ULL, 0x0000000427307824ULL, 0x008fcc00078e029aULL,
0x0000000030307984ULL, 0x000ee40000000800ULL, 0x0000003004277224ULL, 0x008fc800078e029fULL,
0x00005e0027267625ULL, 0x000fca00078e0098ULL, 0x00000026242a7210ULL, 0x004fca0007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002aa47faeULL, 0x0005e8000b901c46ULL, 0x01c6e0009c257984ULL, 0x000ee40000000800ULL,
0x0000009a25257211ULL, 0x008fcc00078e10ffULL, 0x0000000025257984ULL, 0x000ee40000000800ULL,
0x0000002504277224ULL, 0x008fc800078e029bULL, 0x00005e0027267625ULL, 0x000fca00078e0098ULL,
0x0000002624267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026a27faeULL, 0x0005e8000b901c46ULL,
0x01c6f0009c297984ULL, 0x002e640000000800ULL, 0x0000000429297824ULL, 0x002fcc00078e029aULL,
0x0000000029297984ULL, 0x000e640000000800ULL, 0x0000002904997224ULL, 0x002fc800078e0297ULL,
0x00005e0099987625ULL, 0x000fca00078e0098ULL, 0x0000009824247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0699ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024a07faeULL, 0x0005e6000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002078257824ULL, 0x004fe200078e00ffULL, 0x0000001879247810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe025247812ULL, 0x000fe200078ee224ULL,
0x000000009e54783bULL, 0x000fe60000000200ULL, 0x0000000424447819ULL, 0x000fe200000006ffULL,
0x00000000924c783bULL, 0x000fe20000000200ULL, 0x0000001a79247810ULL, 0x000fc60007ffe0ffULL,
0x000000008c48783bULL, 0x000fe20000000200ULL, 0xffffffe025247812ULL, 0x000fc600078ee224ULL,
0x000000004444783bULL, 0x000e640000000200ULL, 0x0000001024287824ULL, 0x000fe400078e00ffULL,
0x000000008e24783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000ea80000000200ULL,
0x000000009550783bULL, 0x000ee80000000200ULL, 0x000000008358783bULL, 0x000f280000000200ULL,
0x000000008160783bULL, 0x000ea80000000200ULL, 0x000000008d30783bULL, 0x000ea80000000200ULL,
0x00000000897c783bULL, 0x000fe80000000200ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000564438723cULL, 0x042f700000001838ULL, 0x0000004c4440723cULL, 0x040f700000001840ULL,
0x00000048445c723cULL, 0x000f70000000185cULL, 0x000000262838723cULL, 0x024bee0000001838ULL,
0x0000002078277824ULL, 0x060fe200078e00ffULL, 0x0000001c79267810ULL, 0x000fe20007ffe0ffULL,
0x00000054442c723cULL, 0x000be2000000182cULL, 0x0000002078787824ULL, 0x000fe200078e00ffULL,
0x000000009154783bULL, 0x020fe20000000200ULL, 0xffffffe027267812ULL, 0x000fc400078ee226ULL,
0x0000001e79797810ULL, 0x000fe40007ffe0ffULL, 0x00000002ff277819ULL, 0x000fe20000011602ULL,
0x00000050443c723cULL, 0x008f62000000183cULL, 0x0000001026267824ULL, 0x000fe200078e00ffULL,
0xffffffe078797812ULL, 0x000fe400078ee279ULL, 0x0000006f2700720cULL, 0x000fc80003f06070ULL,
0x000000524434723cULL, 0x000be20000001834ULL, 0x000000902700720cULL, 0x000fe20004706470ULL,
0x000000009450783bULL, 0x020fe60000000200ULL, 0x000000776e00720cULL, 0x000fc60000703070ULL,
0x0000004e4468723cULL, 0x040b640000001868ULL, 0x00000000964c783bULL, 0x020fec0000000200ULL,
0x0000004a4464723cULL, 0x000b640000001864ULL, 0x000000008044783bULL, 0x020fe80000000200ULL,
0x000000002648783bULL, 0x000e640000000200ULL, 0x000000582840723cULL, 0x050fe40000001840ULL,
0x000000008280783bULL, 0x000fec0000000200ULL, 0x00000060285c723cULL, 0x040ff0000000185cULL,
0x00000030283c723cULL, 0x040f70000000183cULL, 0x0000005a2858723cULL, 0x040b6e0000001868ULL,
0x0000000479687819ULL, 0x020fe200000006ffULL, 0x000000622860723cULL, 0x040b620000001864ULL,
0x000000008b78783bULL, 0x000fe80000000200ULL, 0x000000008a64783bULL, 0x020fe60000000200ULL,
0x000000322834723cULL, 0x040f620000001834ULL, 0x000000006868783bULL, 0x000eae0000000200ULL,
0x00000024282c723cULL, 0x000f70000000182cULL, 0x000000464838723cULL, 0x042f700000001838ULL,
0x0000004c483c723cULL, 0x040f70000000183cULL, 0x000000504840723cULL, 0x040f700000001840ULL,
0x000000524858723cULL, 0x040f700000001858ULL, 0x00000054485c723cULL, 0x040ff0000000185cULL,
0x000000564860723cULL, 0x040ff00000001860ULL, 0x0000004e4834723cULL, 0x060ff00000001834ULL,
0x00000044482c723cULL, 0x000bee000000182cULL, 0x0000000827447810ULL, 0x020fe20007ffe0ffULL,
0x000000666838723cULL, 0x004f660000001838ULL, 0x0000006f4400720cULL, 0x000fe20003f26070ULL,
0x000000ffff6f7224ULL, 0x000fc600078e0090ULL, 0x000000904400720cULL, 0x000fe20000f21070ULL,
0x00000078683c723cULL, 0x000f66000000183cULL, 0x000000776e00720cULL, 0x000fca0000f24470ULL,
0x0000007c6840723cULL, 0x040f700000001840ULL, 0x0000007e6858723cULL, 0x000f640000001858ULL,
0x000000ffff168224ULL, 0x020fe200078e0039ULL, 0x0000000a3b0a7208ULL, 0x000fe20000800000ULL,
0x000000ffff178224ULL, 0x000fe200078e0038ULL, 0x000000093a097208ULL, 0x000fc60000800000ULL,
0x00000080685c723cULL, 0x000f62000000185cULL, 0x000000ffff148224ULL, 0x000fe200078e003dULL,
0x0000006c3f6c7208ULL, 0x000fe20000800000ULL, 0x000000ffff158224ULL, 0x000fe200078e003cULL,
0x0000006d3e6d7208ULL, 0x000fc80000800000ULL, 0x000000826860723cULL, 0x000f620000001860ULL,
0x000000ffff108224ULL, 0x000fe200078e0041ULL, 0x0000002043207208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0040ULL, 0x0000002142217208ULL, 0x000fc80000800000ULL,
0x0000007a6834723cULL, 0x000f620000001834ULL, 0x00000059000e8202ULL, 0x000fe20000000f00ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0058ULL, 0x0000001e5b1e7208ULL, 0x000fe40000800000ULL,
0x0000001f5a1f7208ULL, 0x000fc60000800000ULL, 0x00000064682c723cULL, 0x000f64000000182cULL,
0x000000ffff0c8224ULL, 0x020fe200078e005dULL, 0x0000001c5f1c7208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e005cULL, 0x0000001d5e1d7208ULL, 0x000fc60000800000ULL,
0x000000ffff748224ULL, 0x000fe200078e0061ULL, 0x0000001a631a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e0060ULL, 0x0000001b621b7208ULL, 0x000fca0000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0035ULL, 0x0000003400138202ULL, 0x000fe40000000f00ULL,
0x0000002237227208ULL, 0x000fe40000800000ULL, 0x0000002336237208ULL, 0x000fc60000800000ULL,
0x0000002d00188202ULL, 0x000fe20000000f00ULL, 0x000000ffff198224ULL, 0x000fe200078e002cULL,
0x000000059000720cULL, 0x000fe40003f06070ULL, 0x000000082f087208ULL, 0x000fe40000800000ULL,
0x000000072e077208ULL, 0x000fd20000800000ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff6dd000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000085247f8cULL, 0x0002a2000c80043fULL, 0x3d80000017177820ULL, 0x000fe40000410000ULL,
0x3d80000019197820ULL, 0x000fe40000410000ULL, 0x3d80000018187820ULL, 0x000fe40000410000ULL,
0x3d80000016167820ULL, 0x000fe40000410000ULL, 0x3d80000015157820ULL, 0x000fe40000410000ULL,
0x3d80000014147820ULL, 0x000fc40000410000ULL, 0x3d80000013137820ULL, 0x000fe40000410000ULL,
0x3d80000074747820ULL, 0x000fe40000410000ULL, 0x3d8000006d6d7820ULL, 0x000fe40000410000ULL,
0x3d80000020207820ULL, 0x000fe40000410000ULL, 0x3d80000007077820ULL, 0x000fe40000410000ULL,
0x3d80000008087820ULL, 0x000fc40000410000ULL, 0x3d80000009097820ULL, 0x000fe40000410000ULL,
0x3d8000000a0a7820ULL, 0x000fe40000410000ULL, 0x3d8000006c6c7820ULL, 0x000fe40000410000ULL,
0x3d80000023237820ULL, 0x000fe40000410000ULL, 0x3d80000022227820ULL, 0x000fe40000410000ULL,
0x3d80000021217820ULL, 0x000fc40000410000ULL, 0x3d8000001f1f7820ULL, 0x000fe40000410000ULL,
0x3d80000012287820ULL, 0x000fe40000410000ULL, 0x3d80000011297820ULL, 0x000fe40000410000ULL,
0x3d800000102a7820ULL, 0x000fe40000410000ULL, 0x3d8000000f2c7820ULL, 0x000fe40000410000ULL,
0x3d8000000e2d7820ULL, 0x000fe20000410000ULL, 0x00000017000e7202ULL, 0x000fe20000000f00ULL,
0x3d8000000d2e7820ULL, 0x000fe20000410000ULL, 0x0000006d00177202ULL, 0x000fe20000000f00ULL,
0x3d8000000c2f7820ULL, 0x000fc40000410000ULL, 0x3d8000001e2b7820ULL, 0x000fe40000410000ULL,
0x3d8000001d307820ULL, 0x000fe20000410000ULL, 0x00000020001d7202ULL, 0x000fe20000000f00ULL,
0x3d8000001c317820ULL, 0x000fe40000410000ULL, 0x3d8000001b327820ULL, 0x000fe40000410000ULL,
0x3d8000001a397820ULL, 0x000fe20000410000ULL, 0x00000074001a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0019ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0018ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe400078e0014ULL, 0x000000ffff127224ULL, 0x000fe400078e0013ULL,
0x3d8000000b387820ULL, 0x000fc40000410000ULL, 0x000000ffff147224ULL, 0x000fe400078e0007ULL,
0x000000ffff137224ULL, 0x000fe400078e0008ULL, 0x000000ffff157224ULL, 0x000fe400078e0009ULL,
0x000000ffff167224ULL, 0x000fe400078e000aULL, 0x000000ffff187224ULL, 0x000fe400078e006cULL,
0x000000ffff197224ULL, 0x000fc400078e0023ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0022ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1e7224ULL, 0x000fc400078e001fULL,
0x0000000000087805ULL, 0x006fca0000015200ULL, 0x0000040085057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000107077810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040085057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff0d5087812ULL, 0x000fe400078ec0ffULL,
0x000000847700720cULL, 0x000fe40003f05270ULL, 0x0000000875057211ULL, 0x000fca00078e38ffULL,
0x01c4000005087984ULL, 0x0002ac0000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202077824ULL, 0x000fe400078e00ffULL, 0x0000000171067824ULL, 0x000fc600078e0a06ULL,
0x0000000607077812ULL, 0x000fc800078ec0ffULL, 0x00000001071f7812ULL, 0x040fe400078efcffULL,
0x0000000807217812ULL, 0x000fe400078efcffULL, 0x000000061f00720cULL, 0x080fe40003f26070ULL,
0x00000010071f7812ULL, 0x000fe400078efcffULL, 0x000000062100720cULL, 0x080fe40003f06070ULL,
0x000000061f00720cULL, 0x000fc40003fc6070ULL, 0x0000001107217812ULL, 0x040fe400078efcffULL,
0x00000018071f7812ULL, 0x040fe400078efcffULL, 0x000000060700720cULL, 0x080fe40003f46070ULL,
0x000000062100720cULL, 0x080fe40003fa6070ULL, 0x000000061f00720cULL, 0x000fe40003f66070ULL,
0x0000000907237812ULL, 0x000fc400078efcffULL, 0x0000001907217812ULL, 0x040fe400078efcffULL,
0x00000020071f7812ULL, 0x000fe400078efcffULL, 0xff80000014147808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000013137808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000062300720cULL, 0x080fe40003f86070ULL,
0x000000062100720cULL, 0x080fe40003f46070ULL, 0x000000061f00720cULL, 0x000fe40003f26070ULL,
0x0000002107217812ULL, 0x040fe400078efcffULL, 0x00000028071f7812ULL, 0x000fe400078efcffULL,
0xff80000015157808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff80000016167808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000062100720cULL, 0x080fe40003f06070ULL, 0x000000061f00720cULL, 0x000fe40003f86070ULL,
0x0000002907217812ULL, 0x000fc400078efcffULL, 0x00000030071f7812ULL, 0x000fe400078efcffULL,
0xff80000017177808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff80000011117808ULL, 0x000fe40006800000ULL,
0x000000062100720cULL, 0x000fc40003fc6070ULL, 0x000000061f00720cULL, 0x000fe40003fa6070ULL,
0x0000003107217812ULL, 0x040fe400078efcffULL, 0x00000038071f7812ULL, 0x040fe400078efcffULL,
0x0000003907077812ULL, 0x000fe400078efcffULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff80000012127808ULL, 0x000fc40005800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40005000000ULL, 0xff8000001c1c7808ULL, 0x000fe40004800000ULL,
0xff80000029297808ULL, 0x000fe40004800000ULL, 0x000000062100720cULL, 0x080fe40003f66070ULL,
0x000000061f00720cULL, 0x000fc40003f46070ULL, 0x000000060700720cULL, 0x000fe40003f26070ULL,
0xff8000001d1d7808ULL, 0x000fe40004000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004000000ULL,
0xff8000001e1e7808ULL, 0x000fe40006000000ULL, 0xff8000002c2c7808ULL, 0x000fe40006000000ULL,
0xff8000002b2b7808ULL, 0x000fc40007000000ULL, 0xff8000002d2d7808ULL, 0x000fe40007000000ULL,
0xff80000030307808ULL, 0x000fe40006800000ULL, 0xff8000002e2e7808ULL, 0x000fe40006800000ULL,
0xff80000031317808ULL, 0x000fe40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005800000ULL,
0xff80000032327808ULL, 0x000fc40005000000ULL, 0xff80000038387808ULL, 0x000fe40005000000ULL,
0xff80000039397808ULL, 0x000fe40004800000ULL, 0xff8000001a1a7808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe40003f1e000ULL, 0x000000140900720bULL, 0x000fe40003f3e000ULL,
0x000000080d077208ULL, 0x000fe40004000000ULL, 0x0000000914067208ULL, 0x000fc40004800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000130600720bULL, 0x000fe40003f3e000ULL,
0x000000070c077208ULL, 0x000fe40004000000ULL, 0x0000000613067208ULL, 0x000fe40004800000ULL,
0x0000000e0700720bULL, 0x000fe40003f1e000ULL, 0x000000150600720bULL, 0x000fc40003f3e000ULL,
0x000000070e087208ULL, 0x000fe40004000000ULL, 0x0000000615077208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000160700720bULL, 0x000fe40003f3e000ULL,
0x000000080f097208ULL, 0x000fe40004000000ULL, 0x0000000716067208ULL, 0x000fc40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fe40003f3e000ULL,
0x0000000910087208ULL, 0x000fe40004000000ULL, 0x0000000617077208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fc40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x0000000718067208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x0000000912097208ULL, 0x000fe40004000000ULL, 0x0000000619067208ULL, 0x000fc40004800000ULL,
0x000000280900720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000928087208ULL, 0x000fe40004000000ULL, 0x000000061b077208ULL, 0x000fe40004800000ULL,
0x000000290800720bULL, 0x000fe40003f1e000ULL, 0x0000001c0700720bULL, 0x000fc40003f3e000ULL,
0x0000000829097208ULL, 0x000fe40004000000ULL, 0x000000071c067208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0600720bULL, 0x000fe40003f3e000ULL,
0x000000092a097208ULL, 0x000fe40004000000ULL, 0x000000061d077208ULL, 0x000fc40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x0000001e0700720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x000000071e087208ULL, 0x000fe40004800000ULL,
0x0000002d0600720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fc40003f3e000ULL,
0x000000062d077208ULL, 0x000fe40004000000ULL, 0x000000082b097208ULL, 0x000fe40004800000ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x000000300900720bULL, 0x000fe40003f3e000ULL,
0x000000072e067208ULL, 0x000fe40004000000ULL, 0x0000000930087208ULL, 0x000fc40004800000ULL,
0x0000002f0600720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x000000062f077208ULL, 0x000fe40004000000ULL, 0x0000000831097208ULL, 0x000fe40004800000ULL,
0x000000380700720bULL, 0x000fe40003f1e000ULL, 0x000000320900720bULL, 0x000fc40003f3e000ULL,
0x0000000738077208ULL, 0x000fe40004000000ULL, 0x0000000932067208ULL, 0x000fe40004800000ULL,
0x0000001a0700720bULL, 0x000fe40003f1e000ULL, 0x000000390600720bULL, 0x000fe40003f3e000ULL,
0x000000071a087208ULL, 0x000fe40004000000ULL, 0x00000006391f7208ULL, 0x000fe20004800000ULL,
0x00001cb27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0008067f89ULL, 0x0004e400000e0000ULL,
0x000000060800720bULL, 0x008fc80003f1e000ULL, 0x0000000806207208ULL, 0x000fe20004000000ULL,
0x00001ce27f007947ULL, 0x000fea000b800000ULL, 0x0c401f001f067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x006e6800000e0000ULL,
0x0c201f0020247f89ULL, 0x000ea200000e0000ULL, 0x000000061f00720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x010fe40003f3e000ULL, 0x0000001f06067208ULL, 0x000fe40004000000ULL,
0x0000000a07077208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f0006257f89ULL, 0x000e6600000e0000ULL, 0x0000000b083c7208ULL, 0x000fe20004000000ULL,
0x0c201f0007267f89ULL, 0x000ee200000e0000ULL, 0x000000242000720bULL, 0x004fc60003f1e000ULL,
0x0c201f003c3d7f89ULL, 0x0004a200000e0000ULL, 0x0000002024247208ULL, 0x000fe40004000000ULL,
0x000000250600720bULL, 0x002fe40003f3e000ULL, 0x000000260700720bULL, 0x008fe40003f5e000ULL,
0x0000000625257208ULL, 0x000fe40004800000ULL, 0x0000000726267208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b253a7820ULL, 0x004fe20000410000ULL, 0x3c003c0000467802ULL, 0x000fe20000000f00ULL,
0x3fb8aa3b243b7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b14077823ULL, 0x100fe2000001083aULL, 0x00000002273e7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b13087823ULL, 0x102fe2000001083aULL, 0x0000000327457819ULL, 0x000fe200000006ffULL,
0x3fb8aa3b15097823ULL, 0x100fe2000001083aULL, 0x00000003444f7819ULL, 0x000fe200000006ffULL,
0x3fb8aa3b160a7823ULL, 0x100fe2000001083aULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001083aULL, 0x0000000cd5d57812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b18187823ULL, 0x000fe2000001083aULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee244ULL,
0x3fb8aa3b19197823ULL, 0x000fe2000001083aULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe2000001083bULL, 0x00000017006d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe2000001083bULL, 0x0000003d3c00720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc4000001083bULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe4000001083bULL,
0x3fb8aa3b1e1f7823ULL, 0x100fe2000001083aULL, 0x00000018006c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b11147823ULL, 0x100fe4000001083bULL, 0x3fb8aa3b12137823ULL, 0x100fe4000001083bULL,
0x3fb8aa3b2b1e7823ULL, 0x000fe4000001083aULL, 0x3fb8aa3b28127823ULL, 0x100fe2000001083bULL,
0x0000001900237308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29117823ULL, 0x000fc4000001083bULL,
0x3fb8aa3b2a067823ULL, 0x100fe4000001083bULL, 0x3c003c00ff477424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001083aULL, 0x0000000800087308ULL, 0x000e620000000800ULL,
0x3fb8aa3b10107823ULL, 0x000fe4000001083bULL, 0x3fb8aa3b1c217823ULL, 0x100fe4000001083aULL,
0x3fb8aa3b1d207823ULL, 0x000fc4000001083aULL, 0x3fb8aa3b301d7823ULL, 0x100fe2000001083aULL,
0x0000000900097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b311c7823ULL, 0x100fe4000001083aULL,
0x0000000827437824ULL, 0x040fe400078e00ffULL, 0x3fb8aa3b380b7823ULL, 0x100fe2000001083bULL,
0x0000000527387810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe2000001083bULL,
0x0000000a000a7308ULL, 0x000ea20000000800ULL, 0x000000070829723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b39397823ULL, 0x000fc4000001083aULL, 0x00000008273f7824ULL, 0x040fe400078e00ffULL,
0x0000000827417824ULL, 0x040fe400078e00ffULL, 0x0000000d00197308ULL, 0x0003e20000000800ULL,
0x0000000827497824ULL, 0x000fe400078e00ffULL, 0xfffffff841417812ULL, 0x000fe200078ee23eULL,
0x00000008273e7824ULL, 0x000fe400078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee238ULL,
0x00000008274d7824ULL, 0x040fe200078e00ffULL, 0x0000000c00187308ULL, 0x0007220000000800ULL,
0x000000090a2b723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b2e0d7823ULL, 0x002fe2000001083bULL,
0xffffffff27387810ULL, 0x000fc80007ffe0ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee238ULL,
0x0000000e00177308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2f0c7823ULL, 0x008fce000001083bULL,
0x0000000f00167308ULL, 0x0004e20000000800ULL, 0x000000191828723eULL, 0x010fe200000000ffULL,
0x3fb8aa3b2d0e7823ULL, 0x002fe2000001083bULL, 0x0000006d6c2d723eULL, 0x000fca00000000ffULL,
0x0000001b00227308ULL, 0x0003220000000800ULL, 0x3fb8aa3b2c0f7823ULL, 0x004fe2000001083bULL,
0x00000006273b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83e4b7812ULL, 0x000fe400078ee23bULL,
0x00000017162a723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b321b7823ULL, 0x002fe2000001083aULL,
0x0000001000157308ULL, 0x000fea0000000800ULL, 0x000000462830723cULL, 0x000f6200000018ffULL,
0x00000023222f723eULL, 0x010fc400000000ffULL, 0x0000001400147308ULL, 0x000e700000000800ULL,
0x0000001300137308ULL, 0x000ff00000000800ULL, 0x0000001200127308ULL, 0x000ea20000000800ULL,
0x00000015142c723eULL, 0x002fce00000000ffULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x00000013122e723eULL, 0x004fce00000000ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x000000462c34723cULL, 0x020b6e0000001830ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x0000000327307810ULL, 0x020fce0007ffe0ffULL, 0x0000001e001e7308ULL, 0x000ea20000000800ULL,
0xfffffff843437812ULL, 0x000fe400078ee230ULL, 0x000000212031723eULL, 0x002fca00000000ffULL,
0x0000001100117308ULL, 0x000ff00000000800ULL, 0x0000000600107308ULL, 0x0002e20000000800ULL,
0x0000001f1e33723eULL, 0x004fce00000000ffULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000127067810ULL, 0x002fc80007ffe0ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee206ULL,
0x0000000427067810ULL, 0x000fe20007ffe0ffULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x000000111030723eULL, 0x008fe400000000ffULL, 0xfffffff845457812ULL, 0x000fe200078ee206ULL,
0x0000000827067824ULL, 0x000fc800078e00ffULL, 0x0000001a00747308ULL, 0x000fe20000000800ULL,
0xfffffff806277812ULL, 0x000fe400078ee227ULL, 0x0001200075067811ULL, 0x000fe400078e58ffULL,
0x0000000f0e32723eULL, 0x002fc600000000ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x0000001027277824ULL, 0x100fe400078e0206ULL, 0x000000103f3e7824ULL, 0x100fe400078e0206ULL,
0x00000010413f7824ULL, 0x100fe200078e0206ULL, 0x000000463034723cULL, 0x000f620000001834ULL,
0x0000001043407824ULL, 0x100fe200078e0206ULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x0000000645417211ULL, 0x000fe200078e20ffULL, 0x0000001049427824ULL, 0x000fe200078e0206ULL,
0x00000027d5277210ULL, 0x040fe20007ffe0ffULL, 0x00000001d53e7824ULL, 0x000fc400078e023eULL,
0x000000104b437824ULL, 0x100fe200078e0206ULL, 0x00000042d5427210ULL, 0x040fe20007ffe0ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x00000001d53f7824ULL, 0x000fe200078e023fULL,
0x0000002827007388ULL, 0x0003e20000000800ULL, 0x000000104d447824ULL, 0x000fe400078e0206ULL,
0x00000001d5407824ULL, 0x000fe200078e0240ULL, 0x0000002a3e007388ULL, 0x0005e20000000800ULL,
0x000000104f067824ULL, 0x000fe200078e0206ULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x00000001d5417824ULL, 0x040fe200078e0241ULL, 0x0000002c3f007388ULL, 0x0005e20000000800ULL,
0x00000001d5437824ULL, 0x000fe200078e0243ULL, 0x0000003c3d277208ULL, 0x002fe20004800000ULL,
0x00000001d5447824ULL, 0x040fe200078e0244ULL, 0x0000002e40007388ULL, 0x0005e20000000800ULL,
0x00000001d5067824ULL, 0x000fe200078e0206ULL, 0x0000000c000c7308ULL, 0x000e640000000800ULL,
0x0000003041007388ULL, 0x0005e80000000800ULL, 0x0000003242007388ULL, 0x0005e40000000800ULL,
0x0000000b000b7308ULL, 0x000ef00000000800ULL, 0x00000039001a7308ULL, 0x0008a20000000800ULL,
0x0000000d0c38723eULL, 0x002fca00000000ffULL, 0x0000003843007388ULL, 0x0003e20000000800ULL,
0x0000000b743a723eULL, 0x008fe400000000ffULL, 0x0000001d1c39723eULL, 0x010fc600000000ffULL,
0x0000003a44007388ULL, 0x0003e20000000800ULL, 0x0000001b1a3b723eULL, 0x004fc600000000ffULL,
0x0000002906007388ULL, 0x0003e80000000800ULL, 0x0004002b3e007388ULL, 0x0003e20000000800ULL,
0x000000463834723cULL, 0x020f660000001834ULL, 0x0004002d3f007388ULL, 0x0003e80000000800ULL,
0x0004002f40007388ULL, 0x0003e80000000800ULL, 0x0004003141007388ULL, 0x0003e80000000800ULL,
0x0004003342007388ULL, 0x0003e80000000800ULL, 0x0004003943007388ULL, 0x0003e80000000800ULL,
0x0004003b44007388ULL, 0x0003e20000000800ULL, 0x000000ffff357224ULL, 0x020fc600078e0036ULL,
0x01c0002405008388ULL, 0x0003e80000000c00ULL, 0x01c2003405008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cad80076ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cae00076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01cae80076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030077777a10ULL, 0x000fe20007ffe0ffULL,
0x01caf00076ff7f8cULL, 0x0003e6000c80043fULL, 0x000000707700720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff522000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000273d000387802ULL, 0x000fc40000000f00ULL,
0x0000156000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffdd1a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe40004800000ULL,
0xffffffff00397802ULL, 0x000fe40000000f00ULL, 0x0002743000387802ULL, 0x000fc40000000f00ULL,
0x0000150000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0039ULL,
0xfffdd1d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x000fe200078e0029ULL,
0x000274b000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3a7224ULL, 0x000fc400078e002eULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000144000007944ULL, 0x002fea0003c00000ULL, 0x0000003a00297202ULL, 0x004fe20000000f00ULL,
0xfffdd25000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e002eULL,
0x0002753000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fe400078e0029ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000013c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff297224ULL, 0x004fe200078e003aULL,
0xfffdd33000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0028ULL,
0x000275b000347802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0029ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000134000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdd4e000007947ULL, 0x000fea000383ffffULL, 0x00000027003b7202ULL, 0x002fe20000000f00ULL,
0x000000ffff3a7224ULL, 0x000fe200078e0028ULL, 0x0002763000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000012c000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdd49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x00000078003b7202ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x000276b000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x0000124000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffdfa1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0000001f003c7802ULL, 0x002fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0076ULL,
0x0002773000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x000011c000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffdf9b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0002779000387802ULL, 0x000fc40000000f00ULL,
0x000011a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffe232000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x000277f000387802ULL, 0x000fc40000000f00ULL,
0x0000114000007944ULL, 0x002fea0003c00000ULL, 0xfffe236000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0xffffffff00417802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x0002786000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0x0000109000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffe23d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x000278e000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e0076ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000101000007944ULL, 0x004fea0003c00000ULL,
0x0000003a00347202ULL, 0x004fe20000000f00ULL, 0xfffe24a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0002796000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0078ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000f9000007944ULL, 0x00afea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffe264000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x000279e000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e0076ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000f1000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe25e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x00027a6000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0078ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000e9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffe484000007947ULL, 0x000fea000383ffffULL,
0x00000037003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e0076ULL,
0x00027ae000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x00000e1000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffe47e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x008fe20004000000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00027b4000387802ULL, 0x000fc40000000f00ULL, 0x00000df000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0039ULL, 0xfffe6f9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe20004800000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x00027ba000387802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x002fea0003c00000ULL,
0xfffe6fd000007947ULL, 0x000fea000383ffffULL, 0x0000003d003a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027c1000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe704000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e003dULL,
0x00000076003b7202ULL, 0x002fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x00027c9000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000c6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff347224ULL, 0x004fe200078e003aULL,
0xfffe711000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x00000078003b7202ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe200078e00ffULL,
0x00027d1000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe72b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0000001f003c7802ULL, 0x002fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0076ULL,
0x00027d9000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000b6000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe725000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0x0000001f003c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0078ULL,
0x00027e1000347802ULL, 0x000fe20000000f00ULL, 0xffffffffff417424ULL, 0x000fc400078e00ffULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff267224ULL, 0x004fe200078e003aULL,
0xfffe94b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0037ULL,
0xffffffff00417802ULL, 0x002fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0076ULL,
0x00027e9000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0x00000a6000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e003aULL,
0xfffe945000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004000000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00027ef000387802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff247224ULL, 0x000fe200078e0039ULL,
0xfffebc0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x00027f5000387802ULL, 0x000fc40000000f00ULL,
0x000009e000007944ULL, 0x002fea0003c00000ULL, 0xfffebc4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0xffffffff00417802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe200078e0078ULL, 0x00027fc000347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3c7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff347224ULL, 0x004fe200078e003aULL, 0xfffebcb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e003dULL, 0x0002804000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e0076ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000008b000007944ULL, 0x004fea0003c00000ULL,
0x0000003a00347202ULL, 0x004fe20000000f00ULL, 0xfffebd8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x000280c000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0078ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x00afea0003c00000ULL,
0x0000003a00267202ULL, 0x004fe20000000f00ULL, 0xfffebf2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x0002814000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x002fc400078e0076ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000007b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffebec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0037ULL, 0x000281c000347802ULL, 0x000fe20000000f00ULL,
0x000000ffff3b7224ULL, 0x000fe400078e0078ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000073000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff267224ULL, 0x004fe200078e003aULL, 0xfffee12000007947ULL, 0x000fea000383ffffULL,
0x00000037003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x002fe200078e0076ULL,
0x0002824000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e003aULL, 0xfffee0c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0002ULL, 0x0000001f003c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x000282b000347802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e003aULL,
0xfffee96000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3a7224ULL, 0x000fe200078e0002ULL,
0x0002832000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff3c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x000fea0003c00000ULL,
0x0000003a00027202ULL, 0x004fe20000000f00ULL, 0xfffeea3000007947ULL, 0x000fea000383ffffULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002839000067802ULL, 0x000fc40000000f00ULL,
0x0000052000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003dULL,
0xffffe2f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x006fe200078e001fULL,
0xffffffff00347802ULL, 0x000fe20000000f00ULL, 0x00000002ff097424ULL, 0x000fe200078e00ffULL,
0x0002841000067802ULL, 0x000fe20000000f00ULL, 0x0000001fff3d7424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d1f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x002fe200078e000aULL, 0x0002849000067802ULL, 0x000fe20000000f00ULL,
0x00000002ff097424ULL, 0x000fe200078e00ffULL, 0x0000001f3d227208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0a00720bULL, 0x004fe20003f1e000ULL,
0x00000002ff097424ULL, 0x002fe200078e00ffULL, 0x0000000b00087202ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x0000000a3d0a7208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002851000067802ULL, 0x000fc40000000f00ULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x002fe200078e0020ULL, 0x0000000100097802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x0000000b3d3c7208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002859000067802ULL, 0x000fc40000000f00ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000003d2000720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x002fe200078e0022ULL, 0x0002861000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000203d247208ULL, 0x000fe20004000000ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x0000001f003d7802ULL, 0x000fc40000000f00ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000003d2200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x002fe200078e000aULL, 0xffffffff00347802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x000000223d257208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fe200078e00ffULL, 0x0002869000067802ULL, 0x000fc40000000f00ULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x0000003d0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff087224ULL, 0x002fe200078e003cULL, 0x0002871000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000a3d267208ULL, 0x000fe20004000000ULL,
0x0000001fff3d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe0e000007947ULL, 0x000fea000383ffffULL,
0x0180000030027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003000028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff30ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000030037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe400078efcffULL, 0x0000000300028202ULL, 0x000fe20000000f00ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003000027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0007ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffd775002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff077424ULL, 0x000fe200078e00ffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0c000009083d7389ULL, 0x0002a200000e003dULL,
0xfffd771006007950ULL, 0x000fea0003c3ffffULL, 0x0000000000357802ULL, 0x000fe20000000f00ULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x0000003b3a3a7389ULL, 0x0002a200000e003cULL,
0xfffd76d034007950ULL, 0x000fea0003c3ffffULL, 0x000000013400780cULL, 0x000fe20003f25070ULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x00000000ff357424ULL, 0x000fd000078e00ffULL,
0x0000000000347806ULL, 0x000fc800048e0100ULL, 0x0000003934397212ULL, 0x000fe200078ec0ffULL,
0x000000ffff347224ULL, 0x000fc800078e0038ULL, 0xfffd766034007950ULL, 0x000fea0003c3ffffULL,
0x0000002500007348ULL, 0x000fe80003800000ULL, 0x00000000ff257424ULL, 0x000fc800078e00ffULL,
0xfffd763024007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000567ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c8ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000938ULL,
0x00000000000004b8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000df0ULL,
0x00000000000000e4ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ed4ULL,
0x0000000000000c70ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001b48ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001b58ULL,
0x00000000000000b0ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001c08ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001c0cULL,
0x00000000000001c8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001e00ULL,
0x0000000000028a80ULL, 0xef00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000002a880ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000002a8c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000002ac40ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001c08ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000028c78ULL,
0x0000000000028c78ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000002a880ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000002ac40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_fp16_pagedKV_64_nqpkv_1_m_1_sm_80_cubin_len = 175392;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
