/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c350ULL, 0x000000000001bfd0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x336a4c4536316a4cULL, 0x4c49746132454532ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x36316a4c4532336aULL, 0x624c497461324545ULL, 0x31534b5245454531ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x45346a4c4545346aULL, 0x7461324545386a4cULL,
0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4536316a4c45ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5f2400676e696469ULL, 0x616e7265746e695fULL, 0x635f5f245f305f6cULL, 0x30326d735f616475ULL,
0x5f6e725f7063725fULL, 0x5f3233665f7a7466ULL, 0x68746170776f6c73ULL, 0x65746e695f5f2400ULL,
0x245f315f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x6c66625f636e7973ULL,
0x695f5f2400705f79ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f32ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x5f2400705f786469ULL, 0x616e7265746e695fULL, 0x635f5f245f335f6cULL,
0x30376d735f616475ULL, 0x6e797365746f765fULL, 0x746f6c6c61625f63ULL, 0x65746e695f5f2400ULL,
0x245f345f6c616e72ULL, 0x735f616475635f5fULL, 0x707261775f30376dULL, 0x65722e00636e7973ULL,
0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x2e6c65722e006168ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x5f6c656e72656b24ULL, 0x6d656d732461686dULL, 0x0066754265747942ULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x006d617261705f00ULL,
0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x2e6c65722e766e2eULL, 0x00006e6f69746361ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b1ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003ffULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000444ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b00220000048aULL, 0x0000000000019e40ULL, 0x0000000000000190ULL,
0x000b0022000004bdULL, 0x0000000000019fd0ULL, 0x0000000000000040ULL, 0x000b0022000004e8ULL,
0x000000000001a010ULL, 0x0000000000000040ULL, 0x000b002200000512ULL, 0x000000000001a050ULL,
0x0000000000000060ULL, 0x000b00220000053dULL, 0x000000000001a0b0ULL, 0x00000000000000d0ULL,
0x000a0003000005a4ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000005c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005f4ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001a180ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00019e4000000000ULL, 0x0000040400000000ULL, 0x810c000001700400ULL,
0x0066140400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8f08288080860828ULL, 0x2880809108288080ULL, 0x8097082880809208ULL, 0x0828808098082880ULL,
0x80809c082880809bULL, 0xa608288080a00828ULL, 0x288080a708288080ULL, 0x8280162880808508ULL,
0x0000000003102880ULL, 0x8080859200000000ULL, 0x0000000000220028ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00019e4000000000ULL, 0x0000019000000000ULL, 0x0000580400000000ULL,
0x8084288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL, 0x00000084ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL, 0x8091082880808f08ULL,
0x0828808092082880ULL, 0x8080980828808097ULL, 0x9c082880809b0828ULL, 0x288080a008288080ULL,
0x80b408288080a708ULL, 0x162880808c082880ULL, 0x0000031028808280ULL, 0x8c92000000000000ULL,
0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL, 0x00019fd000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880808608288080ULL, 0x8091082880808f08ULL, 0x0828808092082880ULL,
0x8080980828808097ULL, 0x9c082880809b0828ULL, 0x288080a608288080ULL, 0x80a008288080a708ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080a09200ULL, 0x0000001cffffffffULL,
0x000001f000000000ULL, 0x0001a01000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8508288080840828ULL, 0x2880808608288080ULL,
0x8091082880808f08ULL, 0x0828808092082880ULL, 0x8080980828808097ULL, 0x9c082880809b0828ULL,
0x288080a608288080ULL, 0x80a008288080a708ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080a09200ULL, 0x0000001cffffffffULL, 0x000002a000000000ULL, 0x0001a05000000000ULL,
0x0000006000000000ULL, 0x0000000000000000ULL, 0x00000084ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8508288080840828ULL, 0x2880808608288080ULL, 0x8091082880808f08ULL, 0x0828808092082880ULL,
0x8080970828808095ULL, 0x9b08288080980828ULL, 0x288080a008288080ULL, 0x80a708288080a608ULL,
0x162880809c082880ULL, 0x0000031028808280ULL, 0x9c92000000000000ULL, 0x0000002200288080ULL,
0x0000001cffffffffULL, 0x0000035000000000ULL, 0x0001a0b000000000ULL, 0x000000d000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000079ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001b00082304ULL, 0x0008120400000000ULL, 0x000000000000001bULL,
0x0000001b00081104ULL, 0x0004370400000000ULL, 0x00080a040000007bULL, 0x0068016000000018ULL,
0x000c170400681903ULL, 0x0060000700000000ULL, 0x000c17040021f000ULL, 0x0058000600000000ULL,
0x000c17040021f000ULL, 0x0050000500000000ULL, 0x000c17040011f000ULL, 0x0038000400000000ULL,
0x000c17040061f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0000003000043104ULL, 0xffffffff01bc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000010001bc2804ULL, 0x0000044000000120ULL,
0x000035b000003520ULL, 0x00003810000036b0ULL, 0x00003a7000003a40ULL, 0x00003b1000003ac0ULL,
0x0000595000005930ULL, 0x000059f0000059a0ULL, 0x00007cb000007c20ULL, 0x00007ef000007da0ULL,
0x0000813000008110ULL, 0x000081d000008180ULL, 0x00009e2000009e00ULL, 0x00009ec000009e70ULL,
0x0000c0600000bfd0ULL, 0x0000c2a00000c150ULL, 0x0000c4e00000c4c0ULL, 0x0000c5800000c530ULL,
0x0000e1d00000e1b0ULL, 0x0000e2700000e220ULL, 0x0001041000010380ULL, 0x0001065000010500ULL,
0x0001089000010870ULL, 0x00010930000108e0ULL, 0x0001258000012560ULL, 0x00012620000125d0ULL,
0x00013200000130c0ULL, 0x00013800000137e0ULL, 0x00014d4000013c90ULL, 0x000157b000015790ULL,
0x0001688000016860ULL, 0x000182a000018260ULL, 0x000182c0000182b0ULL, 0x00018330000182d0ULL,
0x0001837000018350ULL, 0x00018fe000018f90ULL, 0x000190a000019040ULL, 0x0001916000019100ULL,
0x00019220000191c0ULL, 0x000192c000019270ULL, 0x0001937000019310ULL, 0x00019430000193d0ULL,
0x000194f000019490ULL, 0x0001959000019540ULL, 0x00019640000195e0ULL, 0x00019700000196a0ULL,
0x000197c000019760ULL, 0x0001986000019810ULL, 0x00019910000198b0ULL, 0x000199d000019970ULL,
0x00019a9000019a30ULL, 0x00019b3000019ae0ULL, 0x00019be000019b80ULL, 0x00019ca000019c40ULL,
0x00019d6000019d00ULL, 0x00019e2000019dc0ULL, 0x0000021007e03904ULL, 0x00010ad0000000ffULL,
0x00000240003f0100ULL, 0x00010ad80000000bULL, 0x00000270003f0120ULL, 0x00010b580000000bULL,
0x000002a0003f0120ULL, 0x00010b780000000bULL, 0x00000390003f0120ULL, 0x00010b88000000ffULL,
0x00000550003f0100ULL, 0x00010ad0000000ffULL, 0x00000840003f0107ULL, 0x00010b5c000000ffULL,
0x000008a000050102ULL, 0x00010b58000000ffULL, 0x00000a2000050101ULL, 0x00010b88000000ffULL,
0x00000a60003f0101ULL, 0x00010b8c000000ffULL, 0x00000c20003f0105ULL, 0x00010b8c000000ffULL,
0x00001650003f0105ULL, 0x00010b88000000ffULL, 0x00001680003f0101ULL, 0x00010b8c000000ffULL,
0x00001850003f0105ULL, 0x00010b8c000000ffULL, 0x000019c0003f0105ULL, 0x00010b78000000ffULL,
0x00001a40003f0107ULL, 0x00010b78000000ffULL, 0x00001aa0003f0101ULL, 0x00010b88000000ffULL,
0x00001d60003f0101ULL, 0x00010b7c000000ffULL, 0x00001f20003f0105ULL, 0x00010b7c000000ffULL,
0x00001f80003f0105ULL, 0x00010b8c000000ffULL, 0x00002150003f0105ULL, 0x00010b8c000000ffULL,
0x00002ba0003f0105ULL, 0x00010b88000000ffULL, 0x00002bd0003f0101ULL, 0x00010b8c000000ffULL,
0x00002da0003f0105ULL, 0x00010b8c000000ffULL, 0x00003120003f0105ULL, 0x00010b80000000ffULL,
0x000031b0003f0107ULL, 0x00010b80000000ffULL, 0x00003240003f0101ULL, 0x00010ad8000000ffULL,
0x0000327000050101ULL, 0x00010adc000000ffULL, 0x0000344000050105ULL, 0x00010adc000000ffULL,
0x0000457000050105ULL, 0x00010b88000000ffULL, 0x00004640003f0101ULL, 0x00010b84000000ffULL,
0x00004800003f0105ULL, 0x00010b84000000ffULL, 0x00004860003f0105ULL, 0x00010b8c000000ffULL,
0x00004a30003f0105ULL, 0x00010b8c000000ffULL, 0x00005470003f0105ULL, 0x00010b88000000ffULL,
0x000054a0003f0101ULL, 0x00010b8c000000ffULL, 0x00005670003f0105ULL, 0x00010b8c000000ffULL,
0x00005840003f0105ULL, 0x00010b78000000ffULL, 0x000058c0003f0107ULL, 0x00010b78000000ffULL,
0x00006310003f0101ULL, 0x00010b88000000ffULL, 0x000063c0003f0101ULL, 0x00010b58000000ffULL,
0x000064a0003f0101ULL, 0x00010b7c000000ffULL, 0x00006660003f0105ULL, 0x00010b7c000000ffULL,
0x000066c0003f0105ULL, 0x00010b8c000000ffULL, 0x00006890003f0105ULL, 0x00010b8c000000ffULL,
0x000072d0003f0105ULL, 0x00010b88000000ffULL, 0x00007300003f0101ULL, 0x00010b8c000000ffULL,
0x000074d0003f0105ULL, 0x00010b8c000000ffULL, 0x00007820003f0105ULL, 0x00010b80000000ffULL,
0x000078a0003f0107ULL, 0x00010b80000000ffULL, 0x00007940003f0101ULL, 0x00010af8000000ffULL,
0x0000797000050101ULL, 0x00010afc000000ffULL, 0x00007b4000050105ULL, 0x00010afc000000ffULL,
0x00008a3000050105ULL, 0x00010b88000000ffULL, 0x00008b10003f0101ULL, 0x00010b84000000ffULL,
0x00008cd0003f0105ULL, 0x00010b84000000ffULL, 0x00008d30003f0105ULL, 0x00010b8c000000ffULL,
0x00008f00003f0105ULL, 0x00010b8c000000ffULL, 0x00009940003f0105ULL, 0x00010b88000000ffULL,
0x00009970003f0101ULL, 0x00010b8c000000ffULL, 0x00009b40003f0105ULL, 0x00010b8c000000ffULL,
0x00009d10003f0105ULL, 0x00010b78000000ffULL, 0x00009d90003f0107ULL, 0x00010b78000000ffULL,
0x0000a6e0003f0101ULL, 0x00010b88000000ffULL, 0x0000a770003f0101ULL, 0x00010b60000000ffULL,
0x0000a850003f0101ULL, 0x00010b7c000000ffULL, 0x0000aa10003f0105ULL, 0x00010b7c000000ffULL,
0x0000aa70003f0105ULL, 0x00010b8c000000ffULL, 0x0000ac40003f0105ULL, 0x00010b8c000000ffULL,
0x0000b680003f0105ULL, 0x00010b88000000ffULL, 0x0000b6b0003f0101ULL, 0x00010b8c000000ffULL,
0x0000b880003f0105ULL, 0x00010b8c000000ffULL, 0x0000bbd0003f0105ULL, 0x00010b80000000ffULL,
0x0000bc50003f0107ULL, 0x00010b80000000ffULL, 0x0000bcf0003f0101ULL, 0x00010b18000000ffULL,
0x0000bd2000050101ULL, 0x00010b1c000000ffULL, 0x0000bef000050105ULL, 0x00010b1c000000ffULL,
0x0000cde000050105ULL, 0x00010b88000000ffULL, 0x0000cec0003f0101ULL, 0x00010b84000000ffULL,
0x0000d080003f0105ULL, 0x00010b84000000ffULL, 0x0000d0e0003f0105ULL, 0x00010b8c000000ffULL,
0x0000d2b0003f0105ULL, 0x00010b8c000000ffULL, 0x0000dcf0003f0105ULL, 0x00010b88000000ffULL,
0x0000dd20003f0101ULL, 0x00010b8c000000ffULL, 0x0000def0003f0105ULL, 0x00010b8c000000ffULL,
0x0000e0c0003f0105ULL, 0x00010b78000000ffULL, 0x0000e140003f0107ULL, 0x00010b78000000ffULL,
0x0000ea90003f0101ULL, 0x00010b88000000ffULL, 0x0000eb20003f0101ULL, 0x00010b68000000ffULL,
0x0000ec00003f0101ULL, 0x00010b7c000000ffULL, 0x0000edc0003f0105ULL, 0x00010b7c000000ffULL,
0x0000ee20003f0105ULL, 0x00010b8c000000ffULL, 0x0000eff0003f0105ULL, 0x00010b8c000000ffULL,
0x0000fa30003f0105ULL, 0x00010b88000000ffULL, 0x0000fa60003f0101ULL, 0x00010b8c000000ffULL,
0x0000fc30003f0105ULL, 0x00010b8c000000ffULL, 0x0000ff80003f0105ULL, 0x00010b80000000ffULL,
0x00010000003f0107ULL, 0x00010b80000000ffULL, 0x000100a0003f0101ULL, 0x00010b38000000ffULL,
0x000100d000050101ULL, 0x00010b3c000000ffULL, 0x000102a000050105ULL, 0x00010b3c000000ffULL,
0x0001119000050105ULL, 0x00010b88000000ffULL, 0x00011270003f0101ULL, 0x00010b84000000ffULL,
0x00011430003f0105ULL, 0x00010b84000000ffULL, 0x00011490003f0105ULL, 0x00010b8c000000ffULL,
0x00011660003f0105ULL, 0x00010b8c000000ffULL, 0x000120a0003f0105ULL, 0x00010b88000000ffULL,
0x000120d0003f0101ULL, 0x00010b8c000000ffULL, 0x000122a0003f0105ULL, 0x00010b8c000000ffULL,
0x00012470003f0105ULL, 0x00010b78000000ffULL, 0x000124f0003f0107ULL, 0x00010b78000000ffULL,
0x00012e40003f0101ULL, 0x00010b88000000ffULL, 0x00012ec0003f0101ULL, 0x00010b70000000ffULL,
0x00013a30003f0101ULL, 0x00010ad0000000ffULL, 0x00014d70003f0101ULL, 0x00010ad4000000ffULL,
0x00014f40003f0105ULL, 0x00010ad4000000ffULL, 0x000152c0003f0105ULL, 0x00010ad0000000ffULL,
0x00015300003f0101ULL, 0x00010ad4000000ffULL, 0x000154c0003f0105ULL, 0x00010ad4000000ffULL,
0x00017560003f0105ULL, 0x0000000000000056ULL, 0x00017790003f0101ULL, 0x0000000400000056ULL,
0x00017960003f0105ULL, 0x0000000400000056ULL, 0x00018df0003f0105ULL, 0x0000000000000005ULL,
0x00018e50003f0101ULL, 0x0000000800000005ULL, 0x00018eb0003f0101ULL, 0x0000001000000005ULL,
0x00018f20003f0101ULL, 0x0000001800000005ULL, 0x00053803003f0101ULL, 0x0001393000101c04ULL,
0x000155e000015520ULL, 0x0000040100018f60ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003f4ULL,
0x0000001b00000002ULL, 0x000000000000033cULL, 0x0000001b00000002ULL, 0x000000000000028cULL,
0x0000001b00000002ULL, 0x00000000000001dcULL, 0x0000001b00000002ULL, 0x000000000000010cULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000003ceULL,
0x0000001b00000002ULL, 0x0000000000000319ULL, 0x0000001b00000002ULL, 0x0000000000000269ULL,
0x0000001b00000002ULL, 0x00000000000001b6ULL, 0x0000001b00000002ULL, 0x00000000000000e4ULL,
0x0000001b00000002ULL, 0x0000000000010c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000001379c3ULL, 0x000ea20000002700ULL, 0x00000000000c7806ULL, 0x000fe200038e0000ULL,
0x00005800000e7ab9ULL, 0x000fe20000000800ULL, 0x0000000000037919ULL, 0x000ee20000002300ULL,
0x00000200000f7882ULL, 0x000fe20000000000ULL, 0x0000000c00067300ULL, 0x000fe200000e0000ULL,
0x00005c0000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000f220000002200ULL,
0x00000000000d79c3ULL, 0x000ea20000002600ULL, 0x0000460000107ab9ULL, 0x000fc40000000a00ULL,
0x00000000000d7919ULL, 0x000ea40000000000ULL, 0x0000000c000c7309ULL, 0x000ee40000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000005ff007819ULL, 0x002fc6000001160bULL,
0x00001fff03047589ULL, 0x008e6200000e0000ULL, 0x000000ffff0c7224ULL, 0x000fc600078e0a0cULL,
0x00001fff00007589ULL, 0x000ee200000e0000ULL, 0x0000010003027a24ULL, 0x010fc800078e0202ULL,
0x00000000020b7a24ULL, 0x000fe200078e020bULL, 0x000000070600720cULL, 0x004fc80003f02070ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x040fe40003f44070ULL, 0x0000007f0b00780cULL, 0x040fe40003f64070ULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00000000041273c2ULL, 0x0022a800000e0000ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000000000873c2ULL, 0x008ea200000e0000ULL,
0x3fffffc0ff049424ULL, 0x002fe200078e00ffULL, 0x010ad002ff00d388ULL, 0x0003e20000000a00ULL,
0x3fffff60ff06a424ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07a424ULL, 0x000fe200078e00ffULL,
0x010ad8040b009388ULL, 0x0007e20000008a00ULL, 0xff317217ff0ab424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08c424ULL, 0x000fe200078e00ffULL, 0x010b58060b00a388ULL, 0x0009e20000008a00ULL,
0x7fffff00ff09c424ULL, 0x000fc600078e00ffULL, 0x0104000a0b00b388ULL, 0x000fe80000004800ULL,
0x010b78080b00c388ULL, 0x000fe20000008a00ULL, 0x0000000812047291ULL, 0x004fc8000f8e103fULL,
0x00000001040a7899ULL, 0x000fe4000800063fULL, 0x000000020e047899ULL, 0x000fe4000800063fULL,
0x000000010a0c7890ULL, 0x000fe4000fffe03fULL, 0x0000000aff027e24ULL, 0x002fe2000f8e00ffULL,
0x0000000a0d007c10ULL, 0x000fe2000fffe0ffULL, 0x00000013040972a4ULL, 0x000fe4000f8e020dULL,
0x0000002002057824ULL, 0x008fe200078e00ffULL, 0x000000040a00788cULL, 0x000fe2000bf01070ULL,
0x3fffff80ff02d424ULL, 0x000fe200078e00ffULL, 0x0000000e0a0472a4ULL, 0x000fc4000f8e0209ULL,
0xffffffe005047812ULL, 0x000fe200078ee200ULL, 0x0000000cff007e24ULL, 0x000fe2000f8e00ffULL,
0x000000040a0b7887ULL, 0x000fe2000c000000ULL, 0x010b8802ff00d388ULL, 0x000fe20000000a00ULL,
0x0000000f040472a5ULL, 0x000fe2000f8e0006ULL, 0x0000002000067824ULL, 0x010fe200078e00ffULL,
0x0000000b0a0b7290ULL, 0x000fe2000fffe13fULL, 0x000000100d007824ULL, 0x040fe200078e00ffULL,
0x0000000e0c0972a4ULL, 0x000fe2000f8e0209ULL, 0x0000000c0d057c10ULL, 0x000fe2000fffe0ffULL,
0x000000010b00788cULL, 0x000fe2000bf03070ULL, 0x0000001004077824ULL, 0x000fe200078e00ffULL,
0x000001f000007812ULL, 0x000fe200078ec0ffULL, 0x0000000f090672a5ULL, 0x000fe2000f8e0006ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400027c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000400097882ULL, 0x000fe20000000000ULL, 0x0000000bff007c0cULL, 0x000fe2000bf26070ULL,
0x00000002130a7899ULL, 0x000fe2000800063fULL, 0xffffffe006067812ULL, 0x000fe200078ee205ULL,
0x00000005ff037e24ULL, 0x000fe200090e06ffULL, 0x000000000000781cULL, 0x000fc40003f4f008ULL,
0x0000000600047c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e000cULL, 0x00000007ff057e24ULL, 0x000fe400098e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e8000c901c50ULL,
0x0000000004097faeULL, 0x0003e8000d101c50ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x010ad400ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010ad000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000620000047ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0472a5ULL, 0x000fc4000f8e0004ULL, 0x00006a0000067ab9ULL, 0x000fe40000000a00ULL,
0x000000090a0672a5ULL, 0x000fe4000f8e0006ULL, 0x00000004ff667e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff677e24ULL, 0x000fe4000f8e00ffULL, 0x00000006ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000007ff037e24ULL, 0x000fe2000f8e00ffULL, 0x0000001066667981ULL, 0x000ea8000c1e1900ULL,
0x0000001002027981ULL, 0x000ee2000c1e1900ULL, 0x00000012ff007c0cULL, 0x000fe2000bf05270ULL,
0xffffffffff007424ULL, 0x000fe200078e00ffULL, 0x0000007f66647810ULL, 0x004fc40007ffe0ffULL,
0x000000ff660a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff637819ULL, 0x008fe40000011602ULL,
0x00000007ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff657819ULL, 0x000fc6000001160aULL,
0x0001325000008947ULL, 0x000fea0003800000ULL, 0x00000008ff027e24ULL, 0x000fe2000f8e00ffULL,
0x0000000308057899ULL, 0x000fe2000800063fULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x00000003ff067424ULL, 0x000fe400078e00ffULL, 0x0000002002037824ULL, 0x000fca00078e020dULL,
0x0000001f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x000fd60003f24070ULL,
0x0000007000000947ULL, 0x000fea0003800000ULL, 0x0000000aff047e24ULL, 0x000fe2000f8e00ffULL,
0x000000660300720cULL, 0x040fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0x00010a0003077811ULL, 0x000fe200078e10ffULL, 0x0000680004047a24ULL, 0x000fc800078e0203ULL,
0x0000660004047625ULL, 0x000fcc00078e0005ULL, 0x0000000004077faeULL, 0x0003e4000c121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b5c06ffff798cULL, 0x0005e20008000005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b5800ffff7f8cULL, 0x000fe2000c800405ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000002700ULL,
0x00006400ff057624ULL, 0x000fe200078e00ffULL, 0x000000ff6400720cULL, 0x000fe20003f05270ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000404047824ULL, 0x002fe200078e0203ULL,
0x00010ac003037811ULL, 0x000fc600078e10ffULL, 0x0000000204047824ULL, 0x000fc800078e00ffULL,
0x0000640004047624ULL, 0x000fc800078e0205ULL, 0x0000600004047625ULL, 0x000fca00078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e40008121850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff047f8cULL, 0x002e62000c80043fULL, 0x000000ffff097224ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x004fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000109097810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000627919ULL, 0x000e620000002600ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x0000008062627824ULL, 0x002fd200078e00ffULL,
0x000004f000000947ULL, 0x000fea0003800000ULL, 0x0000000000107919ULL, 0x000e620000000000ULL,
0x0000000566037c17ULL, 0x000fe2000f800000ULL, 0x00000100ff0e7424ULL, 0x000fc600078e00ffULL,
0x8000000503037c10ULL, 0x000fe4000fffe0ffULL, 0x00000004ff087819ULL, 0x002fe20000011610ULL,
0x00000010100f7824ULL, 0x000fc600078e00ffULL, 0x0000000508097c10ULL, 0x040fe4000fffe0ffULL,
0x000000f00f0f7812ULL, 0x000fe400078ec0ffULL, 0x000000030800720cULL, 0x000fe20003f06070ULL,
0x010a000009067984ULL, 0x004e620000004800ULL, 0x0000000162057824ULL, 0x000fe400078e0209ULL,
0x0000000109077824ULL, 0x040fe400078e0210ULL, 0x00000010090a7824ULL, 0x000fe200078e00ffULL,
0x010ac00006067984ULL, 0x002e640000004800ULL, 0x0000000406057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a047812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000c000040b7811ULL, 0x000fe400078e20ffULL, 0x0000000208047810ULL, 0x000fc60007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c50ULL,
0x00000005040d7c10ULL, 0x040fe4000fffe0ffULL, 0x000000030400720cULL, 0x000fe20003f06070ULL,
0x010a0800090a7984ULL, 0x000ea40000004800ULL, 0x0000000162057824ULL, 0x000fe400078e020dULL,
0x000000010d0c7824ULL, 0x040fe400078e0210ULL, 0x000000100d0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff00d0c7812ULL, 0x000fc800078ee20cULL, 0x0000c0000c0b7811ULL, 0x002fe200078e20ffULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0x0000000408047810ULL, 0x040fe40007ffe0ffULL, 0x0000000608087810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x00000005040d7c10ULL, 0x000fc8000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c50ULL,
0x0000000162057824ULL, 0x000fe200078e020dULL, 0x000000030400720cULL, 0x000fe20003f06070ULL,
0x000000010d0c7824ULL, 0x040fe200078e0210ULL, 0x010a1000090a7984ULL, 0x000ea20000004800ULL,
0x000000100d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL,
0x00000005080d7c10ULL, 0x000fe4000fffe0ffULL, 0x0000c0000c0b7811ULL, 0x002fe200078e20ffULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fe400008e0605ULL, 0x0000000162057824ULL, 0x000fc600078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e2000c101c50ULL,
0x000000030800720cULL, 0x000fe20003f06070ULL, 0x000000010d037824ULL, 0x040fe400078e0210ULL,
0x010a180009097984ULL, 0x000ea20000004800ULL, 0x000000100d087824ULL, 0x000fca00078e00ffULL,
0xfffffff008037812ULL, 0x000fc800078ee203ULL, 0x0000c00003037811ULL, 0x000fe200078e20ffULL,
0x010ac00009047984ULL, 0x004ea40000004800ULL, 0x0000000404047c24ULL, 0x004fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000eULL, 0x0000000f04047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0605ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000c101c50ULL, 0x0000044000007947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x000e620000000000ULL, 0x00000100ff107424ULL, 0x000fe200078e00ffULL,
0x000000050e037c11ULL, 0x042fe2000f8fe0ffULL, 0x000000100e047824ULL, 0x000fc600078e00ffULL,
0x0000000203097810ULL, 0x040fe20007ffe0ffULL, 0x010a000003087984ULL, 0x000e620000004800ULL,
0x0000000162057824ULL, 0x000fe200078e0203ULL, 0x000000f0040d7812ULL, 0x000fe200078ec0ffULL,
0x0000000103077824ULL, 0x140fe400078e020eULL, 0x00000010030a7824ULL, 0x000fe400078e00ffULL,
0x00000001090c7824ULL, 0x000fe200078e020eULL, 0x010ac00008087984ULL, 0x002e640000004800ULL,
0x0000000408057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000d04067210ULL, 0x004fe40007f1e0ffULL, 0xfffffff00a047812ULL, 0x000fc600078ee207ULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000c000040b7811ULL, 0x000fe200078e20ffULL,
0x0000000162057824ULL, 0x000fe400078e0209ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060b7faeULL, 0x0003e6000b901c50ULL,
0xfffffff0090c7812ULL, 0x000fe200078ee20cULL, 0x010a0800030a7984ULL, 0x000ea60000004800ULL,
0x0000c0000c0b7811ULL, 0x002fc400078e20ffULL, 0x0000000403077810ULL, 0x000fca0007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e020eULL, 0x010ac0000a0a7984ULL, 0x004e640000004800ULL,
0x000000040a057c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000d04087210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe400000e0605ULL,
0x0000000162057824ULL, 0x000fe400078e0207ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e8000b901c50ULL,
0x010a1000030a7984ULL, 0x000ea20000004800ULL, 0xfffffff0070c7812ULL, 0x000fc800078ee20cULL,
0x0000c0000c097811ULL, 0x002fe400078e20ffULL, 0x00000006030b7810ULL, 0x000fe20007ffe0ffULL,
0x010ac0000a0a7984ULL, 0x004e640000004800ULL, 0x000000040a057c24ULL, 0x002fe4000f8e0205ULL,
0x000000010b0a7824ULL, 0x000fe400078e020eULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000d04067210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe400000e0605ULL,
0x0000000162057824ULL, 0x000fe400078e020bULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000b901c50ULL,
0x010a180003087984ULL, 0x0004e20000004800ULL, 0xfffffff00b0a7812ULL, 0x000fc800078ee20aULL,
0x0000c0000a037811ULL, 0x004fe200078e20ffULL, 0x010ac00008087984ULL, 0x008ea40000004800ULL,
0x0000000408057c24ULL, 0x004fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e0010ULL,
0x0000000d04047210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e6000b901c50ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff047f8cULL, 0x002e64000c80043fULL,
0x000000ffff087224ULL, 0x002fc400078e0005ULL, 0x0000000000047805ULL, 0x000fca0000015200ULL,
0x010b8c00ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804808ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000109097810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x010b8c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002002067824ULL, 0x002fca00078e0203ULL, 0x0000001f0600780cULL, 0x000fda0003f04070ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0000000aff077e24ULL, 0x000fe2000f8e00ffULL,
0x0000002006057810ULL, 0x000fc60007ffe0ffULL, 0x0000680007047a24ULL, 0x000fe200078e0206ULL,
0x000000660500720cULL, 0x000fe20003f06070ULL, 0x00000004ff057424ULL, 0x000fe200078e00ffULL,
0x00010a0006077811ULL, 0x000fe400078e10ffULL, 0x0000002004047810ULL, 0x000fca0007ffe0ffULL,
0x0000660004047625ULL, 0x000fca00078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff047f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff067f8cULL, 0x000ea2000c80043fULL, 0x000000ff6500720cULL, 0x000fe20003f05270ULL,
0x000000ffff757224ULL, 0x002fe200078e0005ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e00ffULL, 0x0000001fff0d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff0e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x004fe400078e0007ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0001130000008947ULL, 0x000fea0003800000ULL,
0x00005800ff127624ULL, 0x000fe200078e00ffULL, 0x000112e000007945ULL, 0x000fe20003800000ULL,
0xff317217ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000ffff607224ULL, 0x000fc400078e00ffULL, 0x0000008012127824ULL, 0x000fc600078e00ffULL,
0x0000010010137824ULL, 0x000fca00078e00ffULL, 0x000000661300720cULL, 0x000fda0003f06070ULL,
0x0001122000000947ULL, 0x022fea0003800000ULL, 0x000000ffff747224ULL, 0x000fc600078e00ffULL,
0x000000106300720cULL, 0x000fe20003fa4070ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000002ff197819ULL, 0x000fe20000011674ULL, 0x000000ffff227224ULL, 0x020fe200078e00ffULL,
0x0000000374137812ULL, 0x040fe400078ec0ffULL, 0x0000001974197207ULL, 0x000fe40002800000ULL,
0x000000ff13137207ULL, 0x000fe40006800000ULL, 0x00000003191b7812ULL, 0x000fc400078ec0ffULL,
0x0000001019147211ULL, 0x002fc400078ff0ffULL, 0x00000000001c7805ULL, 0x000fca0000015200ULL,
0x010b7c00ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201c237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc80000011421ULL, 0x000000231a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x000000021a1a7819ULL, 0x000fc80000001221ULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x010b8c00ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e1dULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc80000011421ULL,
0x000000231a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x000000021a1a7819ULL, 0x000fc80000001221ULL, 0x0000001a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000001141a7810ULL, 0x040fe20007ffe0ffULL, 0x00000004141c7824ULL, 0x000fe200078e021bULL,
0x0000098000017945ULL, 0x000fe40003800000ULL, 0x000000651a00720cULL, 0x000fe40003f06070ULL,
0x000000201c217811ULL, 0x000fc800078e30ffULL, 0x0000006062247812ULL, 0x000fce00078ef821ULL,
0x0000050000008947ULL, 0x000fea0003800000ULL, 0x00000004ff257819ULL, 0x000fe20000011603ULL,
0x00000100ff277424ULL, 0x000fe200078e00ffULL, 0x00000021661a7217ULL, 0x000fe40007800000ULL,
0x0000000525267c10ULL, 0x040fe4000fffe0ffULL, 0x00000002252b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1a7824ULL, 0x000fe400078e0a21ULL, 0x010a0000261c7984ULL, 0x000e620000004800ULL,
0x0000000126207824ULL, 0x000fe200078e0224ULL, 0x000000052b287c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003217824ULL, 0x000fe200078e00ffULL, 0x000000051a1a7c17ULL, 0x000fe2000f800000ULL,
0x0000001026227824ULL, 0x000fc400078e00ffULL, 0x00000001282a7824ULL, 0x100fe200078e0203ULL,
0x800000051a1a7c10ULL, 0x000fe4000fffe0ffULL, 0x000000f021297812ULL, 0x000fe200078ec0ffULL,
0x0000000126217824ULL, 0x000fe200078e0203ULL, 0x0000001a2500720cULL, 0x000fc80003f06070ULL,
0xfffffff022237812ULL, 0x000fc800078ee221ULL, 0x0000e00023237811ULL, 0x000fe200078e20ffULL,
0x010ac0001c1d7984ULL, 0x002e640000004800ULL, 0x0000001d121d7224ULL, 0x002fc800078e0220ULL,
0x00005e001d1c7625ULL, 0x000fca00078e0027ULL, 0x000000291c207210ULL, 0x000fe20007f3e0ffULL,
0x00000001281c7824ULL, 0x000fc800078e0224ULL, 0x000000ffff217224ULL, 0x000fca00008e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000c101c50ULL,
0x0000001a2b00720cULL, 0x000fe20003f06070ULL, 0x00000010282b7824ULL, 0x000fe400078e00ffULL,
0x010a080026227984ULL, 0x000ea60000004800ULL, 0xfffffff02b237812ULL, 0x002fe400078ee22aULL,
0x00000004252b7810ULL, 0x000fe40007ffe0ffULL, 0x0000e00023237811ULL, 0x000fc400078e20ffULL,
0x000000052b287c10ULL, 0x000fe4000fffe0ffULL, 0x0000000625257810ULL, 0x000fc60007ffe0ffULL,
0x00000001282a7824ULL, 0x000fe200078e0203ULL, 0x010ac000221d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c207210ULL, 0x000fe20007f3e0ffULL, 0x00000001281c7824ULL, 0x000fc800078e0224ULL,
0x000000ffff217224ULL, 0x000fca00008e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e2000c101c50ULL, 0x0000001a2b00720cULL, 0x000fe20003f06070ULL,
0x00000010282b7824ULL, 0x000fe200078e00ffULL, 0x0000000525287c10ULL, 0x000fe2000fffe0ffULL,
0x010a100026227984ULL, 0x000ea60000004800ULL, 0xfffffff02b237812ULL, 0x002fc800078ee22aULL,
0x0000e00023237811ULL, 0x000fe200078e20ffULL, 0x010ac000221d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c207210ULL, 0x000fe20007f3e0ffULL, 0x00000001281c7824ULL, 0x040fe400078e0224ULL,
0x0000000128247824ULL, 0x000fe400078e0203ULL, 0x000000ffff217224ULL, 0x000fca00008e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e2000c101c50ULL,
0x0000001a2500720cULL, 0x000fe20003f06070ULL, 0x0000001028257824ULL, 0x000fe400078e00ffULL,
0x010a180026227984ULL, 0x000ea60000004800ULL, 0xfffffff025217812ULL, 0x002fc800078ee224ULL,
0x0000e00021217811ULL, 0x000fe200078e20ffULL, 0x010ac000221d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff1d7224ULL, 0x000fca00008e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x0000000503267c11ULL, 0x040fe2000f8fe0ffULL,
0x0000001003207824ULL, 0x000fe400078e00ffULL, 0x00000100ff277424ULL, 0x000fe400078e00ffULL,
0x010a0000261a7984ULL, 0x000e620000004800ULL, 0x00000001261c7824ULL, 0x000fe200078e0224ULL,
0x000000f020297812ULL, 0x000fe200078ec0ffULL, 0x0000000126217824ULL, 0x040fe400078e0203ULL,
0x0000001026227824ULL, 0x000fca00078e00ffULL, 0xfffffff022257812ULL, 0x000fe400078ee221ULL,
0x0000000226227810ULL, 0x000fe40007ffe0ffULL, 0x0000e00025257811ULL, 0x000fc600078e20ffULL,
0x0000000122237824ULL, 0x040fe400078e0203ULL, 0x0000001022287824ULL, 0x000fe200078e00ffULL,
0x010ac0001a1d7984ULL, 0x002e640000004800ULL, 0x0000001d121c7224ULL, 0x002fc800078e021cULL,
0x00005e001c1c7625ULL, 0x000fca00078e0027ULL, 0x000000291c207210ULL, 0x000fe20007f1e0ffULL,
0x00000001221c7824ULL, 0x000fc800078e0224ULL, 0x000000ffff217224ULL, 0x000fca00000e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e8000b901c50ULL,
0x010a0800261a7984ULL, 0x000ea20000004800ULL, 0x0000000426207810ULL, 0x002fca0007ffe0ffULL,
0x0000000120217824ULL, 0x000fe200078e0203ULL, 0x010ac0001a1d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c227210ULL, 0x000fe40007f1e0ffULL, 0xfffffff0281c7812ULL, 0x000fe200078ee223ULL,
0x0000001020287824ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fe200000e061dULL,
0x0000e0001c257811ULL, 0x000fe200078e20ffULL, 0x00000001201c7824ULL, 0x000fc800078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022257faeULL, 0x0003e8000b901c50ULL,
0x010a1000261a7984ULL, 0x000ea20000004800ULL, 0x0000000626227810ULL, 0x002fca0007ffe0ffULL,
0x0000001022257824ULL, 0x000fe200078e00ffULL, 0x010ac0001a1d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c207210ULL, 0x000fe40007f1e0ffULL, 0xfffffff0281c7812ULL, 0x000fc600078ee221ULL,
0x000000ffff217224ULL, 0x000fe200000e061dULL, 0x0000e0001c237811ULL, 0x000fe200078e20ffULL,
0x00000001221c7824ULL, 0x040fe400078e0224ULL, 0x0000000122247824ULL, 0x000fe400078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e6000b901c50ULL,
0xfffffff025247812ULL, 0x000fe200078ee224ULL, 0x010a1800261a7984ULL, 0x000ea60000004800ULL,
0x0000e00024217811ULL, 0x002fe200078e20ffULL, 0x010ac0001a1d7984ULL, 0x004e640000004800ULL,
0x0000001d121c7224ULL, 0x002fc800078e021cULL, 0x00005e001c1c7625ULL, 0x000fca00078e0027ULL,
0x000000291c1c7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e6000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff1c7f8cULL, 0x002e64000c80043fULL, 0x000000ffff257224ULL, 0x002fc400078e001dULL,
0x00000000001c7805ULL, 0x000fca0000015200ULL, 0x010b8c00ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff227224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201c237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc80000011421ULL, 0x000000231a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x000000021a1a7819ULL, 0x000fc80000001221ULL,
0x0000001a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000122227810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff1a7984ULL, 0x000e640000000800ULL, 0x800000001aff7812ULL, 0x002fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000146300720cULL, 0x080fe20003f24070ULL,
0x0000022000017945ULL, 0x000fe20003800000ULL, 0x00000001131a7810ULL, 0x000fe40007ffe0ffULL,
0x000000146300720cULL, 0x000fe40003f04070ULL, 0x000000031a1c7812ULL, 0x000fc400078ec0ffULL,
0x0000000119197812ULL, 0x000fe400078ec0ffULL, 0x000000031300780cULL, 0x000fe20004705270ULL,
0x0000002002137824ULL, 0x000fe200078e0203ULL, 0x000000ff1c1c7207ULL, 0x000fe40004800000ULL,
0x00000002ff1a9819ULL, 0x000fe4000001161aULL, 0x000000011900780cULL, 0x000fe40000705470ULL,
0x0000001f1300780cULL, 0x000fe20003f84070ULL, 0x000000011b1b7824ULL, 0x000fc800078e021aULL,
0x000000401b1a7824ULL, 0x040fe200078e00ffULL, 0x000000141b147211ULL, 0x000fc800078ff0ffULL,
0x000000c01a197812ULL, 0x000fca00078ec0ffULL, 0x00000100141d7824ULL, 0x000fe200078e0219ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x0000002002197824ULL, 0x000fe200078e0203ULL,
0x0000000111117810ULL, 0x000fc80007ffe0ffULL, 0x000000031900780cULL, 0x000fda0003f04070ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000001a7919ULL, 0x000e620000002700ULL,
0x0000640011147a10ULL, 0x040fe20007ffe0ffULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x000000641100720cULL, 0x000fe20003f06070ULL, 0x000000041a1a7824ULL, 0x002fe200078e0219ULL,
0x00010ac019197811ULL, 0x000fc600078e10ffULL, 0x000000021a1b7824ULL, 0x000fc800078e00ffULL,
0x000064001b147a24ULL, 0x000fc800078e0214ULL, 0x00006000141a7625ULL, 0x000fca00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a197faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000e000017945ULL, 0x000fe20003800000ULL,
0x000000c000004947ULL, 0x000fea0003800000ULL, 0x0000000a1c147c10ULL, 0x000fe2000fffe0ffULL,
0x0000000113197824ULL, 0x102fe400078e021dULL, 0x00000004ff1b7424ULL, 0x000fe400078e00ffULL,
0x0000680014147a24ULL, 0x000fe200078e021dULL, 0x000000661900720cULL, 0x000fe40003f06070ULL,
0x00010a0013197811ULL, 0x040fe200078e10ffULL, 0x0000000113147824ULL, 0x000fc800078e0214ULL,
0x00006600141a7625ULL, 0x000fcc00078e001bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a197faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff7400720cULL, 0x000fe20003f05270ULL, 0x010b8000ff4a7f8cULL, 0x000ea2000c80043fULL,
0x0000080000017945ULL, 0x000fe20003800000ULL, 0xffffffffff147424ULL, 0x000fd400078e00ffULL,
0x000007d000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010ad800ff1a7f8cULL, 0x002e64000c800405ULL, 0x000000ffff207224ULL, 0x002fc400078e001bULL,
0x00000000001a7805ULL, 0x000fca0000015200ULL, 0x010adc05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804820ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e1bULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff157819ULL, 0x000fc8000001141dULL, 0x0000001c15157211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000215157819ULL, 0x000fc8000000121cULL,
0x000000150000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000119197810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010adc05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804820ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x00000001ff197819ULL, 0x000fc80000011603ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c191a7812ULL, 0x000fca00078ec0ffULL, 0x00000001151a7824ULL, 0x000fca00078e021aULL,
0x010000001a1c7984ULL, 0x000e680000000800ULL, 0x010200001a197984ULL, 0x0006a20000000800ULL,
0x0000000f1c00720bULL, 0x002fe20003f1d000ULL, 0x00015a527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x008fc800000e0100ULL, 0x0000ffff15227812ULL, 0x000fe2000780c0ffULL,
0x0000045000027945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fd200078e000fULL, 0x0000041000008947ULL, 0x000fea0003800000ULL,
0x00000008ff007c0cULL, 0x000fe4000bf05270ULL, 0x0000000f1c00720bULL, 0x000fe20003f34000ULL,
0x00015a127f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400008e0100ULL,
0x0000001c0f1b7209ULL, 0x000fe20007810000ULL, 0x0000035000037945ULL, 0x000fe20003800000ULL,
0x000099101d207816ULL, 0x000fc600000000ffULL, 0x0104001b1a008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000001b0f0f7221ULL, 0x002fe20000010000ULL, 0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f001a7308ULL, 0x000e640000000800ULL, 0x0000001a0c0c7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0f7819ULL, 0x000fe20000011603ULL,
0x000159627f007947ULL, 0x000fea000b800000ULL, 0x00001f0f1a0f7589ULL, 0x0002e400000e0000ULL,
0x0000000f0b0b7220ULL, 0x088fe20000410000ULL, 0x0000000f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000000f07077220ULL, 0x080fe20000410000ULL, 0x0000000f06067220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000f53537220ULL, 0x080fe20000410000ULL, 0x0000000f52527220ULL, 0x080fe20000410000ULL,
0x0000000f57577220ULL, 0x080fe20000410000ULL, 0x0000000f56567220ULL, 0x080fe20000410000ULL,
0x0000000f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000000f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000000f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000000f5e5e7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff001dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008030f7811ULL, 0x000fe200078ff0ffULL,
0x000158627f007947ULL, 0x000fea000b800000ULL, 0x00001f0f1a0f7589ULL, 0x00066400000e0000ULL,
0x0000000f09097220ULL, 0x082fe20000410000ULL, 0x0000000f08087220ULL, 0x080fe20000410000ULL,
0x0000000f05057220ULL, 0x080fe20000410000ULL, 0x0000000f04047220ULL, 0x080fe20000410000ULL,
0x0000000f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000f51517220ULL, 0x080fe20000410000ULL, 0x0000000f50507220ULL, 0x080fe20000410000ULL,
0x0000000f55557220ULL, 0x080fe20000410000ULL, 0x0000000f54547220ULL, 0x080fe20000410000ULL,
0x0000000f59597220ULL, 0x080fe20000410000ULL, 0x0000000f58587220ULL, 0x080fe20000410000ULL,
0x0000000f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000000f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000000f61617220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff22ff7812ULL, 0x000fda000780601dULL,
0x8000001b1c1c0221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c00160308ULL, 0x000e640000000800ULL,
0x0000001619190220ULL, 0x006fcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000c190c7221ULL, 0x004fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e001bULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff15ff7812ULL, 0x000fe2000782c0ffULL,
0x0000014000017945ULL, 0x000fd80003800000ULL, 0x0000012000001947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fe400000000ffULL, 0x00000002ff1a7819ULL, 0x00afe40000011603ULL,
0x0000541017197816ULL, 0x000fe20000000017ULL, 0x000156927f007947ULL, 0x000fea000b800000ULL,
0x00001f1a19177589ULL, 0x0002e400000e0000ULL, 0x000000081a187810ULL, 0x000fe20007ffe0ffULL,
0x000156c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1819187589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000101a277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0019ULL, 0x00003ad000207802ULL, 0x000fc40000000f00ULL,
0x0001654000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000181a277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x004fe200078e0019ULL,
0x00003b2000207802ULL, 0x000fc40000000f00ULL, 0x000164f000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000008031a7812ULL, 0x04afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff197819ULL, 0x100fe20000011603ULL,
0x0000000208047891ULL, 0x000fe2000f8e103fULL, 0x0000000703707812ULL, 0x000fe200078ec0ffULL,
0x0000086000017945ULL, 0x000fe20003800000ULL, 0x000000071a697812ULL, 0x000fe200078ef803ULL,
0x00000004024a7824ULL, 0x004fe200078e0219ULL, 0x0000000870707812ULL, 0x000fc400078ef803ULL,
0x0000001069387812ULL, 0x040fe200078efcffULL, 0x00000001691a7824ULL, 0x000fe200078e024aULL,
0x0000000419767c10ULL, 0x000fe2000fffe0ffULL, 0x00000010691b7824ULL, 0x000fe200078e00ffULL,
0x0000000438727c10ULL, 0x000fe2000fffe019ULL, 0x0000000119687824ULL, 0x000fe200078e0270ULL,
0x000000106300720cULL, 0x000fe20003fc3070ULL, 0x00000008701d7824ULL, 0x000fe200078e00ffULL,
0xfffffff01b1b7812ULL, 0x000fe200078ee21aULL, 0x000000014a717824ULL, 0x000fe200078e0238ULL,
0x00000002681c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001038207824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee268ULL, 0x0000001069317824ULL, 0x000fe200078e00ffULL,
0x0000c0001b1b7811ULL, 0x000fc400078e20ffULL, 0x0000a0001a447811ULL, 0x000fe400078e20ffULL,
0xfffffff020717812ULL, 0x000fe200078ee271ULL, 0x000000001b2c783bULL, 0x000e620000004200ULL,
0xfffffff81d1c7812ULL, 0x000fe400078ee21cULL, 0x0000c000711d7811ULL, 0x000fe200078e20ffULL,
0x000000004444783bULL, 0x000ea20000000200ULL, 0x0000a0001c207811ULL, 0x000fe400078e20ffULL,
0x000000106300720cULL, 0x000fe20003f03070ULL, 0x000000001d28783bULL, 0x000fe80000004200ULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0x000031202c347816ULL, 0x002fe200000000ffULL,
0x00000001692c7824ULL, 0x000fe200078e0276ULL, 0x000031202d2d7816ULL, 0x000fe200000000ffULL,
0x0000001744449232ULL, 0x084fe20000000000ULL, 0x00000034ff24723eULL, 0x080fe200020006ffULL,
0x0000001746469232ULL, 0x080fe20000000000ULL, 0x0000002dff25723eULL, 0x080fe200020006ffULL,
0x0000001845459232ULL, 0x080fe20000000000ULL, 0xfffffff0312c7812ULL, 0x000fe200078ee22cULL,
0x0000001847479232ULL, 0x080fe20000000000ULL, 0x00000034ff34723eULL, 0x000fe200030006ffULL,
0x0000001720209232ULL, 0x088fe20000000000ULL, 0x0000002dff35723eULL, 0x000fe200030006ffULL,
0x0000001722229232ULL, 0x000fe20000000000ULL, 0x0000c0002c677811ULL, 0x000fe200078e20ffULL,
0x0000001821219232ULL, 0x080fe20000000000ULL, 0x000000244424723cULL, 0x000f6200000018ffULL,
0x0000312028327816ULL, 0x000fe200000000ffULL, 0x0000001823239232ULL, 0x000fe20000000000ULL,
0x0000312029397816ULL, 0x000fe200000000ffULL, 0x00000000673c783bULL, 0x000e620000004200ULL,
0x000031202e2e7816ULL, 0x000fc400000000ffULL, 0x000031202f317816ULL, 0x000fe200000000ffULL,
0x000000344434723cULL, 0x000f6200000018ffULL, 0x00000032ff28723eULL, 0x000fe400020006ffULL,
0x00000039ff29723eULL, 0x000fe400020006ffULL, 0x0000002eff2c723eULL, 0x080fe400020006ffULL,
0x00000031ff2d723eULL, 0x000fe400020006ffULL, 0x0000002eff30723eULL, 0x000fc400030006ffULL,
0x00000031ff31723eULL, 0x000fe400030006ffULL, 0x000031202a3a7816ULL, 0x000fe200000000ffULL,
0x0000002c442c723cULL, 0x000f6200000018ffULL, 0x000031202b3b7816ULL, 0x000fce00000000ffULL,
0x000000282024723cULL, 0x020bee0000001824ULL, 0x00000039ff29723eULL, 0x020fe200030006ffULL,
0x0000001038397824ULL, 0x000fe200078e00ffULL, 0x00000032ff28723eULL, 0x000fe400030006ffULL,
0x000000304430723cULL, 0x000f6200000018ffULL, 0x0000003aff38723eULL, 0x000fc400020006ffULL,
0xfffffff039727812ULL, 0x000fe400078ee272ULL, 0x0000003bff39723eULL, 0x000fe400020006ffULL,
0x0000c000726a7811ULL, 0x000fe200078e20ffULL, 0x000000282028723cULL, 0x000be20000001834ULL,
0x000031203c3c7816ULL, 0x002fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe200000000ffULL,
0x000000006a34783bULL, 0x020e620000004200ULL, 0x000031203e487816ULL, 0x000fc400000000ffULL,
0x000031203f497816ULL, 0x000fe200000000ffULL, 0x00000038202c723cULL, 0x000be2000000182cULL,
0x00000048ff40723eULL, 0x080fe400020006ffULL, 0x00000049ff41723eULL, 0x000fe400020006ffULL,
0x00000048ff48723eULL, 0x000fe400030006ffULL, 0x0000003aff38723eULL, 0x020fe400030006ffULL,
0x0000003bff39723eULL, 0x000fe200030006ffULL, 0x000000404440723cULL, 0x000fe200000018ffULL,
0x00000049ff49723eULL, 0x000fce00030006ffULL, 0x000000382030723cULL, 0x000bee0000001830ULL,
0x0000003cff38723eULL, 0x0a0fe400020006ffULL, 0x0000003dff39723eULL, 0x000fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fc400030006ffULL, 0x0000003dff3d723eULL, 0x000fc600030006ffULL,
0x000000384438723cULL, 0x000f6200000018ffULL, 0x00003120346b7816ULL, 0x002fe400000000ffULL,
0x00003120356c7816ULL, 0x000fe400000000ffULL, 0x0000006bff34723eULL, 0x000fc600020006ffULL,
0x0000003c443c723cULL, 0x000f6200000018ffULL, 0x0000006cff35723eULL, 0x000fe400020006ffULL,
0x0000312036367816ULL, 0x000fe400000000ffULL, 0x0000312037377816ULL, 0x000fc600000000ffULL,
0x000000484444723cULL, 0x000b6e00000018ffULL, 0x0000000174487810ULL, 0x020fe20007ffe0ffULL,
0x000000342038723cULL, 0x000b6e0000001838ULL, 0x0000006bff34723eULL, 0x020fc400030006ffULL,
0x0000006cff35723eULL, 0x000fe400030006ffULL, 0x00000002ff6c7819ULL, 0x000fc80000011603ULL,
0x000000746c00720cULL, 0x040fe20003f46070ULL, 0x00000034203c723cULL, 0x000b62000000183cULL,
0x000000086c6b7810ULL, 0x040fe40007ffe0ffULL, 0x000000486c00720cULL, 0x000fe40005746470ULL,
0x000000746b00720cULL, 0x000fe40003f66070ULL, 0x00000036ff34723eULL, 0x020fe400020006ffULL,
0x00000037ff35723eULL, 0x000fc400020006ffULL, 0x000000486b00720cULL, 0x000fca0005f66470ULL,
0x000000342040723cULL, 0x000b6e0000001840ULL, 0x00000036ff34723eULL, 0x020fe400030006ffULL,
0x00000037ff35723eULL, 0x000fce00030006ffULL, 0x000000342044723cULL, 0x000b620000001844ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x0000002c1f1f7221ULL, 0x000fe20000010000ULL, 0x0000002d1e1e7221ULL, 0x000fe20000010000ULL,
0x000000304f4f7221ULL, 0x000fe20000010000ULL, 0x000000314e4e7221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fe20000010000ULL,
0x000000445f5f7221ULL, 0x020fe20000010000ULL, 0x000000455e5e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b04047221ULL, 0x000fe20000010000ULL, 0x0000002e4d4d7221ULL, 0x000fe20000010000ULL,
0x0000002f4c4c7221ULL, 0x000fe20000010000ULL, 0x0000003251517221ULL, 0x000fe20000010000ULL,
0x0000003350507221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fe20000010000ULL, 0x0000004661617221ULL, 0x020fe20000010000ULL,
0x0000004760607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x020e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe20000011648ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000000106300720cULL, 0x000fc40003f03070ULL, 0x0000002348237207ULL, 0x040fe40002800000ULL,
0x000000106300720cULL, 0x080fe40003fc3070ULL, 0x00000001ff2c7803ULL, 0x000fe40000000000ULL,
0x0000001023227211ULL, 0x040fe400078ff0ffULL, 0x0000000348207812ULL, 0x002fe200078ec0ffULL,
0x000000ffff287224ULL, 0x000fe200078e0021ULL, 0x0000000323217812ULL, 0x000fc400078ec0ffULL,
0x000000ff20207207ULL, 0x000fc40006800000ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe2000780484bULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078110ffULL,
0x000000ffff267224ULL, 0x000fca00000e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780484bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000023ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000122247810ULL, 0x040fe20007ffe0ffULL, 0x0000000422237824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000652400720cULL, 0x000fe20003f06070ULL,
0x0000004023297824ULL, 0x000fca00078e00ffULL, 0x0000004062237812ULL, 0x000fce00078ef829ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x00000005192a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x0000000219317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2b7424ULL, 0x000fe400078e00ffULL, 0x010a00002a277984ULL, 0x000e620000004800ULL,
0x000000012a247824ULL, 0x000fe200078e0223ULL, 0x000000f0262d7812ULL, 0x000fe200078ec0ffULL,
0x000000102a287824ULL, 0x000fe200078e00ffULL, 0x0000002966267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a29ULL,
0x000000012e307824ULL, 0x000fc600078e0203ULL, 0x0000000526267c17ULL, 0x000fe2000f800000ULL,
0x010ac00027277984ULL, 0x002e640000004800ULL, 0x0000002712247224ULL, 0x002fe400078e0224ULL,
0x000000012a277824ULL, 0x000fe400078e0203ULL, 0x00005e0024247625ULL, 0x000fc600078e002bULL,
0xfffffff028277812ULL, 0x000fe400078ee227ULL, 0x0000002d24247210ULL, 0x000fe40007f1e0ffULL,
0x8000000526287c10ULL, 0x000fe2000fffe0ffULL, 0x000000012e267824ULL, 0x000fe200078e0223ULL,
0x0000c000272f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000281900720cULL, 0x000fda0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000c101c50ULL, 0x010a08002a297984ULL, 0x000ea20000004800ULL,
0x000000102e257824ULL, 0x002fca00078e00ffULL, 0xfffffff025307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x000fe200078e20ffULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x0000000419317810ULL, 0x000fc80007ffe0ffULL,
0x00000005312e7c10ULL, 0x000fca000fffe0ffULL, 0x000000012e247824ULL, 0x040fe400078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000c101c50ULL,
0x000000012e307824ULL, 0x000fc600078e0203ULL, 0x010a10002a297984ULL, 0x000ea20000004800ULL,
0x000000102e277824ULL, 0x002fca00078e00ffULL, 0xfffffff027307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x000fe200078e20ffULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0x0000000619317810ULL, 0x000fc80007ffe0ffULL,
0x00000005312e7c10ULL, 0x000fca000fffe0ffULL, 0x000000012e237824ULL, 0x000fe400078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000c101c50ULL,
0x010a18002a297984ULL, 0x000ea80000004800ULL, 0x010ac00029297984ULL, 0x004ea40000004800ULL,
0x0000002912237224ULL, 0x004fc800078e0223ULL, 0x00005e0023267625ULL, 0x000fc800078e002bULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000002d26267210ULL, 0x000fe20007f1e0ffULL,
0x000000102e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x000000283100720cULL, 0x000fe40003f06070ULL, 0xfffffff02e237812ULL, 0x000fc800078ee223ULL,
0x0000c00023237811ULL, 0x000fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026237faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005192e7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe400078e00ffULL, 0x010a00002e287984ULL, 0x000e620000004800ULL,
0x000000012e247824ULL, 0x000fe400078e0223ULL, 0x000000f0262f7812ULL, 0x000fe200078ec0ffULL,
0x010ac00028257984ULL, 0x0022a40000004800ULL, 0x000000022e287810ULL, 0x002fca0007ffe0ffULL,
0x00000001282a7824ULL, 0x040fe400078e0203ULL, 0x0000001028317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312a7812ULL, 0x000fe200078ee22aULL, 0x0000002512257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002dULL, 0x0000002f24267210ULL, 0x000fe20007f1e0ffULL,
0x000000012e247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400000e0625ULL,
0x000000102e257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0000c000242b7811ULL, 0x000fe200078e20ffULL, 0x0000000123247824ULL, 0x000fe200078e0228ULL,
0x000000042e287810ULL, 0x000fc60007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e4000b901c50ULL, 0x0000001028317824ULL, 0x000fe400078e00ffULL,
0x010a08002e297984ULL, 0x000ea20000004800ULL, 0x0000c0002a2b7811ULL, 0x002fe200078e20ffULL,
0x0000000123267824ULL, 0x000fe400078e0228ULL, 0x00000001282a7824ULL, 0x000fe200078e0203ULL,
0x000000062e287810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312a7812ULL, 0x000fe200078ee22aULL,
0x0000000123237824ULL, 0x000fe200078e0228ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e8000b901c50ULL,
0x010a10002e297984ULL, 0x000ea20000004800ULL, 0x0000c0002a2b7811ULL, 0x002fc600078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262b7faeULL, 0x0003e8000b901c50ULL, 0x010a18002e297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912237224ULL, 0x004fc800078e0223ULL,
0x00005e0023247625ULL, 0x000fc800078e002dULL, 0x0000000128237824ULL, 0x000fe200078e0203ULL,
0x0000002f24247210ULL, 0x000fe20007f1e0ffULL, 0x0000001028287824ULL, 0x000fc800078e00ffULL,
0x000000ffff257224ULL, 0x000fe200000e0625ULL, 0xfffffff028237812ULL, 0x000fc800078ee223ULL,
0x0000c00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000023ff7812ULL, 0x002fe20007804828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000226300720cULL, 0x000fe40003f04070ULL, 0x00010a0013257811ULL, 0x000fe400078e10ffULL,
0x000000ff20247207ULL, 0x000fc40000000000ULL, 0x000000ff20237207ULL, 0x000fc60004000000ULL,
0x0000000121217824ULL, 0x000fc800078e0224ULL, 0x0000004021207824ULL, 0x040fe200078e00ffULL,
0x0000002221217211ULL, 0x000fc800078ff0ffULL, 0x000000c020207812ULL, 0x000fca00078ec0ffULL,
0x0000010021207824ULL, 0x000fe200078e0220ULL, 0x0000000a23217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000113237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x000000662300720cULL, 0x000fe20003f06070ULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fe200078e0021ULL, 0x0000010000001947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x000138627f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002a400000e0000ULL,
0x000138a27f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000059b000207802ULL, 0x000fc40000000f00ULL,
0x0001466000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x00005a0000207802ULL, 0x000fc40000000f00ULL, 0x0001461000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000001694a7824ULL, 0x040fe200078e024aULL,
0x00000004686f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001069217824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000870207824ULL, 0x000fe200078e00ffULL,
0x0000000668687810ULL, 0x000fe20007ffe0ffULL, 0x00000008702b7824ULL, 0x000fe200078e00ffULL,
0xfffffff0214a7812ULL, 0x000fe200078ee24aULL, 0x0000000169767824ULL, 0x040fe200078e0276ULL,
0xfffffff8206f7812ULL, 0x000fe200078ee26fULL, 0x00000010696d7824ULL, 0x000fe200078e00ffULL,
0x0000e0004a6e7811ULL, 0x000fe200078e20ffULL, 0x0000069000017945ULL, 0x000fe20003800000ULL,
0x0000a0006f4b7811ULL, 0x000fc400078e20ffULL, 0xfffffff82b707812ULL, 0x000fe200078ee268ULL,
0x000000006e20783bULL, 0x00ae620000004200ULL, 0x0000e00071717811ULL, 0x000fe400078e20ffULL,
0x000000ff2c00720cULL, 0x000fe20003f05270ULL, 0x000000004b48783bULL, 0x000ee20000000200ULL,
0xfffffff06d6d7812ULL, 0x000fe400078ee276ULL, 0x0000e00072727811ULL, 0x000fe200078e20ffULL,
0x00000000712c783bULL, 0x000f220000004200ULL, 0x0000e0006d6d7811ULL, 0x000fc600078e20ffULL,
0x000000007244783bULL, 0x000fe80000004200ULL, 0x000000006d3c783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff24723eULL, 0x080fe200020006ffULL, 0x0000001748489232ULL, 0x08cfe20000000000ULL,
0x00000020ff28723eULL, 0x000fe200030006ffULL, 0x000000174a4a9232ULL, 0x000fe20000000000ULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x0000001849499232ULL, 0x080fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000184b4b9232ULL, 0x000fe20000000000ULL,
0x0000a00070207811ULL, 0x000fc400078e20ffULL, 0x00000021ff25723eULL, 0x080fe400020006ffULL,
0x00000021ff29723eULL, 0x000fe400030006ffULL, 0x00000022ff30723eULL, 0x080fe400020006ffULL,
0x00000023ff31723eULL, 0x080fe200020006ffULL, 0x000000244824723cULL, 0x000f6200000018ffULL,
0x00000022ff34723eULL, 0x000fe400030006ffULL, 0x00000023ff35723eULL, 0x000fc400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031202c737816ULL, 0x010fe400000000ffULL,
0x000000284828723cULL, 0x040f6200000018ffULL, 0x000031202d767816ULL, 0x000fe400000000ffULL,
0x00000073ff2c723eULL, 0x000fe400020006ffULL, 0x00000076ff2d723eULL, 0x000fe400020006ffULL,
0x000031203c3c7816ULL, 0x000fe200000000ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x000031203d3d7816ULL, 0x000fc400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x000031202e2e7816ULL, 0x000fe200000000ffULL,
0x000000344834723cULL, 0x000f6200000018ffULL, 0x000031202f2f7816ULL, 0x000fe400000000ffULL,
0x0000003cff3c723eULL, 0x000fe400030006ffULL, 0x0000003dff3d723eULL, 0x000fc400030006ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x040f6200000018ffULL,
0x000031203f697816ULL, 0x000fe400000000ffULL, 0x00000068ff40723eULL, 0x000fe400020006ffULL,
0x00000069ff41723eULL, 0x000fe400020006ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fc400000000ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x0000001720209232ULL, 0x082fe20000000000ULL,
0x00000069ff69723eULL, 0x000fe200030006ffULL, 0x0000001722229232ULL, 0x000fe40000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x0000001821219232ULL, 0x080fe20000000000ULL,
0x0000312046467816ULL, 0x000fe200000000ffULL, 0x0000001823239232ULL, 0x000fe20000000000ULL,
0x0000312047477816ULL, 0x000fc800000000ffULL, 0x000000684848723cULL, 0x000f7000000018ffULL,
0x0000002c2024723cULL, 0x020b6e0000001824ULL, 0x00000073ff2c723eULL, 0x020fc400030006ffULL,
0x00000076ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2034723cULL, 0x000b6e0000001834ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0000000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000311e1e7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x000000495e5e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000003947ULL, 0x000fea0003000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b04047221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000174747810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff737424ULL, 0x000fe200078e00ffULL, 0x010b8800ff267f8cULL, 0x000e68000c80043fULL,
0x0000000173737807ULL, 0x000fc80006800000ULL, 0x000000737400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffb96000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004010217811ULL, 0x020fe200078e40ffULL,
0x010b5800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000662100720cULL, 0x000fda0003f06070ULL,
0x0000cae000000947ULL, 0x000fea0003800000ULL, 0x000000ffff747224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe20000011674ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000374227812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000002174217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000121237810ULL, 0x000fc80007ffe0ffULL, 0x0000000323217812ULL, 0x040fe400078ec0ffULL,
0x0000001023207211ULL, 0x002fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b7c00ff267984ULL, 0x002e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011429ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000226267819ULL, 0x000fc80000001229ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011429ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000226267819ULL, 0x000fc80000001229ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420257824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000652400720cULL, 0x000fe40003f06070ULL,
0x0000002025277811ULL, 0x000fc800078e30ffULL, 0x0000006062287812ULL, 0x000fce00078ef827ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x00000005192b7c10ULL, 0x040fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000002766247217ULL, 0x000fe40007800000ULL,
0x0000000219337810ULL, 0x000fe20007ffe0ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x000000012b267824ULL, 0x000fe400078e0228ULL, 0x0000000124247824ULL, 0x000fe200078e0a27ULL,
0x00000005332c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fc600078e00ffULL,
0x0000000524247c17ULL, 0x000fe2000f800000ULL, 0x000000012c2e7824ULL, 0x100fe200078e0203ULL,
0x000000f0272f7812ULL, 0x000fe200078ec0ffULL, 0x000000012b277824ULL, 0x000fe200078e0203ULL,
0x80000005242a7c10ULL, 0x000fc8000fffe0ffULL, 0x0000002a1900720cULL, 0x000fe20003f06070ULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002512267224ULL, 0x002fc800078e0226ULL,
0x00005e0026247625ULL, 0x000fc800078e002dULL, 0x000000102b267824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007f3e0ffULL, 0xfffffff026277812ULL, 0x000fe200078ee227ULL,
0x000000ffff257224ULL, 0x000fe400008e0625ULL, 0x000000012c267824ULL, 0x000fe200078e0228ULL,
0x0000e00027317811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x010a08002b297984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x0000000419337810ULL, 0x000fe40007ffe0ffULL,
0x0000e0002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26247210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0228ULL,
0x000000ffff257224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x010a10002b297984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x0000000619337810ULL, 0x000fe40007ffe0ffULL,
0x0000e0002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c287824ULL, 0x000fe200078e0228ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fc60003f06070ULL, 0x010a18002b297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912267224ULL, 0x004fe400078e0228ULL,
0x000000012c287824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002dULL,
0x000000102c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f26247210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02d287812ULL, 0x000fe200078ee228ULL, 0x000000ffff257224ULL, 0x000fc600008e0627ULL,
0x0000e00028277811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005192a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fe400078e00ffULL,
0x00000100ff2d7424ULL, 0x000fe400078e00ffULL, 0x010a00002a267984ULL, 0x000e620000004800ULL,
0x000000012a247824ULL, 0x040fe200078e0228ULL, 0x000000f0272f7812ULL, 0x000fe200078ec0ffULL,
0x000000012a277824ULL, 0x040fe400078e0203ULL, 0x000000102a2c7824ULL, 0x000fca00078e00ffULL,
0xfffffff02c277812ULL, 0x000fe400078ee227ULL, 0x000000022a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000e000272b7811ULL, 0x000fc600078e20ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0203ULL,
0x000000102c317824ULL, 0x000fca00078e00ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x010ac00026257984ULL, 0x0022a40000004800ULL, 0x000000012c267824ULL, 0x002fe200078e0228ULL,
0x000000042a2c7810ULL, 0x000fca0007ffe0ffULL, 0x000000102c317824ULL, 0x000fe400078e00ffULL,
0x0000002512257224ULL, 0x004fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002dULL,
0x0000002f24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242b7faeULL, 0x0003e8000b901c50ULL,
0x010a08002a297984ULL, 0x000ea20000004800ULL, 0x0000e0002e2b7811ULL, 0x002fe200078e20ffULL,
0x000000012c247824ULL, 0x040fe400078e0228ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000012c287824ULL, 0x000fe200078e0228ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e8000b901c50ULL,
0x010a10002a297984ULL, 0x000ea20000004800ULL, 0x0000e0002e2b7811ULL, 0x002fc600078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002dULL, 0x0000002f24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242b7faeULL, 0x0003e8000b901c50ULL, 0x010a18002a297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912267224ULL, 0x004fc400078e0228ULL,
0x000000012c287824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002dULL,
0x000000102c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f26267210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02d287812ULL, 0x000fe200078ee228ULL, 0x000000ffff277224ULL, 0x000fc600000e0627ULL,
0x0000e00028257811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000123237812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012300780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031300780cULL, 0x000fe40003f04070ULL, 0x0000000111117810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x000000641100720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0213ULL, 0x0000640011247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac013237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00010a0013237811ULL, 0x040fe200078e10ffULL, 0x0000000113217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x000000662100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7400720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010af800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff247224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010afc05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff157819ULL, 0x000fc80000011423ULL, 0x0000002215157211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x0000000215157819ULL, 0x000fc80000001222ULL,
0x000000150000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010afc05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c20207812ULL, 0x000fca00078ec0ffULL, 0x0000000115277824ULL, 0x000fca00078e0220ULL,
0x0100800027227984ULL, 0x000e680000000800ULL, 0x0102800027237984ULL, 0x0004e20000000800ULL,
0x0000000f2200720bULL, 0x002fe20003f1d000ULL, 0x000116327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x0000000f2200720bULL, 0x000fe20003f34000ULL,
0x000115f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x000000220f247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0104802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000240f0f7221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00297308ULL, 0x000e640000000800ULL, 0x000000290c0c7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000115427f007947ULL, 0x000fea000b800000ULL,
0x00001f6c290f7589ULL, 0x0002a400000e0000ULL, 0x0000000f0b0b7220ULL, 0x084fe20000410000ULL,
0x0000000f0a0a7220ULL, 0x080fe20000410000ULL, 0x0000000f07077220ULL, 0x080fe20000410000ULL,
0x0000000f06067220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000000f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000000f53537220ULL, 0x080fe20000410000ULL,
0x0000000f52527220ULL, 0x080fe20000410000ULL, 0x0000000f57577220ULL, 0x080fe20000410000ULL,
0x0000000f56567220ULL, 0x080fe20000410000ULL, 0x0000000f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000000f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000000f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000000f5e5e7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000114527f007947ULL, 0x000fea000b800000ULL, 0x00001f6b290f7589ULL, 0x00046400000e0000ULL,
0x0000000f09097220ULL, 0x082fe20000410000ULL, 0x0000000f08087220ULL, 0x080fe20000410000ULL,
0x0000000f05057220ULL, 0x080fe20000410000ULL, 0x0000000f04047220ULL, 0x080fe20000410000ULL,
0x0000000f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000f51517220ULL, 0x080fe20000410000ULL, 0x0000000f50507220ULL, 0x080fe20000410000ULL,
0x0000000f55557220ULL, 0x080fe20000410000ULL, 0x0000000f54547220ULL, 0x080fe20000410000ULL,
0x0000000f59597220ULL, 0x080fe20000410000ULL, 0x0000000f58587220ULL, 0x080fe20000410000ULL,
0x0000000f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000000f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000000f61617220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200160308ULL, 0x000e640000000800ULL,
0x0000001623230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000c230c7221ULL, 0x008fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x000112927f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002e400000e0000ULL,
0x000112d27f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000819000207802ULL, 0x000fc40000000f00ULL,
0x00011e8000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x000081e000207802ULL, 0x000fc40000000f00ULL, 0x00011e3000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001b20783bULL, 0x002e620000004200ULL, 0x0000a8001a247811ULL, 0x000fe200078e20ffULL,
0x0000068000017945ULL, 0x000fe20003800000ULL, 0x000000746c00720cULL, 0x000fe20003f46070ULL,
0x00000000673c783bULL, 0x000fe20000004200ULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000746b00720cULL, 0x000fe20003f26070ULL, 0x000000002448783bULL, 0x000f220000000200ULL,
0x000000106300720cULL, 0x000fc60003f03070ULL, 0x000000001d2c783bULL, 0x000ee80000004200ULL,
0x000000006a44783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fe400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fc400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x098fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000a8001c207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fe400030006ffULL,
0x00000022ff30723eULL, 0x000fc400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x040f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x000f6200000018ffULL,
0x000031203f697816ULL, 0x000fc400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fe400030006ffULL,
0x00000068ff40723eULL, 0x000fe400020006ffULL, 0x00000069ff41723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x040f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fc400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fe400030006ffULL,
0x00000001742e7810ULL, 0x000fc80007ffe0ffULL, 0x0000002e6c00720cULL, 0x080fe20005746470ULL,
0x0000002c2034723cULL, 0x000b620000001834ULL, 0x0000002e6b00720cULL, 0x000fcc0004f26470ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000311e1e7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x000000495e5e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b04047221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x020e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe2000001162eULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000232e237207ULL, 0x040fe40002800000ULL,
0x000000032e227812ULL, 0x000fe400078ec0ffULL, 0x0000000123237810ULL, 0x000fe40007ffe0ffULL,
0x000000106300720cULL, 0x000fe40003f03070ULL, 0x00000040ff2a7803ULL, 0x000fe40000000000ULL,
0x000000ff22227207ULL, 0x000fe20006800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0021ULL,
0x0000000323217812ULL, 0x000fc400078ec0ffULL, 0x0000001023207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4875ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x040fe20007ffe0ffULL,
0x0000000420237824ULL, 0x000fe200078e0221ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000652400720cULL, 0x000fe20003fc6070ULL, 0x0000004023297824ULL, 0x000fca00078e00ffULL,
0x0000004062237812ULL, 0x000fce00078ef829ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x0000000219317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002c277984ULL, 0x000e620000004800ULL, 0x000000012c247824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x000000102c287824ULL, 0x000fe200078e00ffULL,
0x0000002966267217ULL, 0x000fe40007800000ULL, 0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a29ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027277984ULL, 0x002e640000004800ULL,
0x0000002712247224ULL, 0x002fe400078e0224ULL, 0x000000012c277824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc600078e002bULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x0000002d24247210ULL, 0x000fe40007fde0ffULL, 0x8000000526287c10ULL, 0x000fe2000fffe0ffULL,
0x000000012e267824ULL, 0x000fe200078e0223ULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000281900720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a08002c297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x0000000419317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002c297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x0000000619317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a18002c297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912237224ULL, 0x004fc800078e0223ULL,
0x00005e0023267625ULL, 0x000fc800078e002bULL, 0x000000012e237824ULL, 0x000fe200078e0203ULL,
0x0000002d26267210ULL, 0x000fe20007fde0ffULL, 0x000000102e2e7824ULL, 0x000fc800078e00ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0xfffffff02e237812ULL, 0x000fc800078ee223ULL, 0x0000c00023237811ULL, 0x000fce00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL, 0x010a00002c287984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe400078e0223ULL, 0x000000f0262b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x010ac00028257984ULL, 0x002e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e0029ULL,
0x0000002b24267210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102c257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x000000102e2e7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL, 0x010a08002c287984ULL, 0x000ea20000004800ULL,
0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL,
0x000000012e267824ULL, 0x042fe400078e0223ULL, 0x000000012e2d7824ULL, 0x040fe400078e0203ULL,
0x000000102e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL,
0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fca00030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002c287984ULL, 0x000ea80000004800ULL, 0x010ac00028277984ULL, 0x004ea40000004800ULL,
0x0000002712267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e0029ULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e8000b901c50ULL,
0x010a18002c287984ULL, 0x000e680000004800ULL, 0x010ac00028257984ULL, 0x002e640000004800ULL,
0x0000002512257224ULL, 0x002fc400078e0223ULL, 0x000000012e237824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fc800078e0029ULL, 0x000000102e2e7824ULL, 0x000fe200078e00ffULL,
0x0000002b24247210ULL, 0x000fc80007fde0ffULL, 0xfffffff02e237812ULL, 0x000fe200078ee223ULL,
0x000000ffff257224ULL, 0x000fc600030e0625ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0005e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x006e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe40003fc4070ULL,
0x00010a0013257811ULL, 0x000fe400078e10ffULL, 0x000000ff22247207ULL, 0x000fc40003000000ULL,
0x000000ff22237207ULL, 0x000fc60007000000ULL, 0x0000000121217824ULL, 0x000fc800078e0224ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a23217c10ULL, 0x000fc8000fffe0ffULL, 0x0000002020227810ULL, 0x000fca0007ffe0ffULL,
0x0000000113237824ULL, 0x100fe400078e0222ULL, 0x0000680021207a24ULL, 0x000fe400078e0222ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x000000662300720cULL, 0x000fe20003fc6070ULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x0000f6627f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002a400000e0000ULL, 0x0000f6a27f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x00009e8000207802ULL, 0x000fc40000000f00ULL, 0x0001019000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x00009ed000207802ULL, 0x000fc40000000f00ULL,
0x0001014000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006e20783bULL, 0x00ae620000004200ULL,
0x0000a8006f247811ULL, 0x000fe200078e20ffULL, 0x0000062000017945ULL, 0x000fe20003800000ULL,
0x000000ff2a00720cULL, 0x000fe20003fc5270ULL, 0x000000006d3c783bULL, 0x000fe80000004200ULL,
0x000000002448783bULL, 0x000ee80000000200ULL, 0x00000000712c783bULL, 0x000f280000004200ULL,
0x000000007244783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fc400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fe400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x088fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000a80070207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fc400030006ffULL,
0x00000022ff30723eULL, 0x080fe400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x000f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fc400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x040f6200000018ffULL,
0x000031203f697816ULL, 0x000fe400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fc400030006ffULL,
0x00000068ff40723eULL, 0x080fe400020006ffULL, 0x00000069ff41723eULL, 0x080fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x000f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x010fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fc400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2034723cULL, 0x000b6e0000001834ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000311e1e7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x000000495e5e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b04047221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b60607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000174747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000737400720cULL, 0x000fe20003f06070ULL,
0x010b8800ff267f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffbcf000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008010217811ULL, 0x020fe200078e40ffULL, 0x010b6000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000662100720cULL, 0x000fda0003f06070ULL, 0x0000873000000947ULL, 0x000fea0003800000ULL,
0x000000ffff747224ULL, 0x000fca00078e00ffULL, 0x00000002ff217819ULL, 0x020fe20000011674ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000374227812ULL, 0x040fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000002174217207ULL, 0x000fe40002800000ULL,
0x000000ff22227207ULL, 0x000fe40006800000ULL, 0x0000000221237810ULL, 0x000fc80007ffe0ffULL,
0x0000000323217812ULL, 0x040fe400078ec0ffULL, 0x0000001023207211ULL, 0x002fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b7c00ff267984ULL, 0x002e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804875ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011429ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000226267819ULL, 0x000fc80000001229ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b7c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011429ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000226267819ULL, 0x000fc80000001229ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x040fe20007ffe0ffULL,
0x0000000420257824ULL, 0x000fe200078e0221ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000652400720cULL, 0x000fe40003f06070ULL, 0x0000002025277811ULL, 0x000fc800078e30ffULL,
0x0000006062287812ULL, 0x000fce00078ef827ULL, 0x000004f000008947ULL, 0x000fea0003800000ULL,
0x00000005192b7c10ULL, 0x040fe2000fffe0ffULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x0000002766247217ULL, 0x000fe40007800000ULL, 0x0000000219337810ULL, 0x000fe20007ffe0ffULL,
0x010a00002b257984ULL, 0x000e620000004800ULL, 0x000000012b267824ULL, 0x000fe400078e0228ULL,
0x0000000124247824ULL, 0x000fe200078e0a27ULL, 0x00000005332c7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003277824ULL, 0x000fc600078e00ffULL, 0x0000000524247c17ULL, 0x000fe2000f800000ULL,
0x000000012c2e7824ULL, 0x100fe200078e0203ULL, 0x000000f0272f7812ULL, 0x000fe200078ec0ffULL,
0x000000012b277824ULL, 0x000fe200078e0203ULL, 0x80000005242a7c10ULL, 0x000fc8000fffe0ffULL,
0x0000002a1900720cULL, 0x000fe20003f06070ULL, 0x010ac00025257984ULL, 0x002e640000004800ULL,
0x0000002512267224ULL, 0x002fc800078e0226ULL, 0x00005e0026247625ULL, 0x000fc800078e002dULL,
0x000000102b267824ULL, 0x000fe200078e00ffULL, 0x0000002f24247210ULL, 0x000fc80007f3e0ffULL,
0xfffffff026277812ULL, 0x000fe200078ee227ULL, 0x000000ffff257224ULL, 0x000fe400008e0625ULL,
0x000000012c267824ULL, 0x000fe200078e0228ULL, 0x0000e00027317811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fe20003f06070ULL, 0x000000102c337824ULL, 0x000fe400078e00ffULL,
0x010a08002b297984ULL, 0x000ea60000004800ULL, 0xfffffff0332e7812ULL, 0x000fe400078ee22eULL,
0x0000000419337810ULL, 0x000fe40007ffe0ffULL, 0x0000e0002e317811ULL, 0x002fc400078e20ffULL,
0x00000005332c7c10ULL, 0x000fca000fffe0ffULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26247210ULL, 0x000fe20007f3e0ffULL,
0x000000012c267824ULL, 0x000fc800078e0228ULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fe20003f06070ULL, 0x000000102c337824ULL, 0x000fe400078e00ffULL,
0x010a10002b297984ULL, 0x000ea60000004800ULL, 0xfffffff0332e7812ULL, 0x000fe400078ee22eULL,
0x0000000619337810ULL, 0x000fe40007ffe0ffULL, 0x0000e0002e317811ULL, 0x002fc400078e20ffULL,
0x00000005332c7c10ULL, 0x000fca000fffe0ffULL, 0x000000012c287824ULL, 0x000fe200078e0228ULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002dULL, 0x0000002f26247210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff257224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fc60003f06070ULL,
0x010a18002b297984ULL, 0x000ea80000004800ULL, 0x010ac00029297984ULL, 0x004ea40000004800ULL,
0x0000002912267224ULL, 0x004fe400078e0228ULL, 0x000000012c287824ULL, 0x000fe400078e0203ULL,
0x00005e0026267625ULL, 0x000fc800078e002dULL, 0x000000102c2d7824ULL, 0x000fe200078e00ffULL,
0x0000002f26247210ULL, 0x002fc80007f3e0ffULL, 0xfffffff02d287812ULL, 0x000fe200078ee228ULL,
0x000000ffff257224ULL, 0x000fc600008e0627ULL, 0x0000e00028277811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000c101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005192a7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003277824ULL, 0x000fe400078e00ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002a267984ULL, 0x000e620000004800ULL, 0x000000012a247824ULL, 0x040fe200078e0228ULL,
0x000000f0272d7812ULL, 0x000fe200078ec0ffULL, 0x000000012a277824ULL, 0x040fe400078e0203ULL,
0x000000102a2c7824ULL, 0x000fca00078e00ffULL, 0xfffffff02c277812ULL, 0x000fe400078ee227ULL,
0x000000022a2c7810ULL, 0x000fe40007ffe0ffULL, 0x0000e000272f7811ULL, 0x000fc600078e20ffULL,
0x000000012c2e7824ULL, 0x040fe400078e0203ULL, 0x000000102c317824ULL, 0x000fca00078e00ffULL,
0xfffffff0312e7812ULL, 0x000fe200078ee22eULL, 0x010ac00026257984ULL, 0x0022a40000004800ULL,
0x000000012c267824ULL, 0x002fe200078e0228ULL, 0x000000042a2c7810ULL, 0x000fca0007ffe0ffULL,
0x000000102c317824ULL, 0x000fe400078e00ffULL, 0x0000002512257224ULL, 0x004fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000b901c50ULL, 0x010a08002a297984ULL, 0x000ea20000004800ULL,
0x0000e0002e2f7811ULL, 0x002fe200078e20ffULL, 0x000000012c247824ULL, 0x040fe400078e0228ULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff0312e7812ULL, 0x000fe200078ee22eULL, 0x000000012c287824ULL, 0x000fe200078e0228ULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e8000b901c50ULL, 0x010a10002a297984ULL, 0x000ea20000004800ULL,
0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a18002a297984ULL, 0x000ea80000004800ULL, 0x010ac00029297984ULL, 0x004ea40000004800ULL,
0x0000002912267224ULL, 0x004fc400078e0228ULL, 0x000000012c287824ULL, 0x000fe400078e0203ULL,
0x00005e0026267625ULL, 0x000fc800078e002bULL, 0x000000102c2b7824ULL, 0x000fe200078e00ffULL,
0x0000002d26267210ULL, 0x000fc80007f1e0ffULL, 0xfffffff02b287812ULL, 0x000fe200078ee228ULL,
0x000000ffff277224ULL, 0x000fc600000e0627ULL, 0x0000e00028257811ULL, 0x002fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x002e64000c80043fULL, 0x000000ffff2b7224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624297210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09002900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000002926267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe20003f04070ULL,
0x0000015000017945ULL, 0x000fe20003800000ULL, 0x0000000123237812ULL, 0x000fe400078ec0ffULL,
0x000000032200780cULL, 0x000fc80004705270ULL, 0x000000012300780cULL, 0x000fda0000705470ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x000000031300780cULL, 0x000fe40003f04070ULL,
0x0000000111117810ULL, 0x000fd60007ffe0ffULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x0000000000247919ULL, 0x000e620000002700ULL, 0x000000641100720cULL, 0x040fe20003f06070ULL,
0x00000004ff257424ULL, 0x000fe400078e00ffULL, 0x0000000424237824ULL, 0x002fe200078e0213ULL,
0x0000640011247a10ULL, 0x000fc60007ffe0ffULL, 0x0000000223237824ULL, 0x000fc800078e00ffULL,
0x0000640023247a24ULL, 0x000fe200078e0224ULL, 0x00010ac013237811ULL, 0x000fc600078e10ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000018000017945ULL, 0x000fe20003800000ULL, 0x0000016000004947ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe40003f04070ULL, 0x0000000122227810ULL, 0x000fc80007ffe0ffULL,
0x0000000322237812ULL, 0x002fc800078ec0ffULL, 0x000000ff23237207ULL, 0x000fc60004000000ULL,
0x00000002ff228819ULL, 0x000fca0000011622ULL, 0x0000000121217824ULL, 0x000fc800078e0222ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020227824ULL, 0x000fe200078e0221ULL,
0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL, 0x00010a0013237811ULL, 0x040fe200078e10ffULL,
0x0000000113217824ULL, 0x100fe400078e0222ULL, 0x0000680020207a24ULL, 0x000fc600078e0222ULL,
0x000000662100720cULL, 0x000fe20003f06070ULL, 0x00000004ff217424ULL, 0x000fe400078e00ffULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fcc00078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8000ff207f8cULL, 0x000e62000c80043fULL,
0x000000ff7400720cULL, 0x000fe20003f05270ULL, 0x000007e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fd600078e0021ULL, 0x000007b000000947ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b1800ff207f8cULL, 0x000e64000c800405ULL,
0x000000ffff247224ULL, 0x002fc400078e0021ULL, 0x0000000000207805ULL, 0x000fca0000015200ULL,
0x010b1c05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000027945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000037945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff157819ULL, 0x000fc80000011423ULL,
0x0000002215157211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x0000000215157819ULL, 0x000fc80000001222ULL, 0x000000150000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000037941ULL, 0x000fea0003800000ULL, 0x010b1c05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000001003157824ULL, 0x000fe200078e00ffULL, 0x00000001ff207819ULL, 0x000fc80000011603ULL,
0x0000007015157812ULL, 0x000fe400078ec0ffULL, 0x0000000c20207812ULL, 0x000fca00078ec0ffULL,
0x0000000115277824ULL, 0x000fca00078e0220ULL, 0x0101000027227984ULL, 0x000e680000000800ULL,
0x0103000027237984ULL, 0x0004e20000000800ULL, 0x0000000f2200720bULL, 0x002fe20003f1d000ULL,
0x0000d5527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15287812ULL, 0x000fe2000780c0ffULL, 0x0000043000027945ULL, 0x000fe20003800000ULL,
0x00000001ff157424ULL, 0x000fe400078e00ffULL, 0x000000ffff247224ULL, 0x000fd200078e000fULL,
0x000003f000008947ULL, 0x000fea0003800000ULL, 0x000000020200780cULL, 0x000fe40003f05270ULL,
0x0000000f2200720bULL, 0x000fe20003f34000ULL, 0x0000d5127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000257806ULL, 0x000fc400008e0100ULL, 0x000000220f247209ULL, 0x000fe20007810000ULL,
0x0000033000037945ULL, 0x000fe20003800000ULL, 0x0000991025207816ULL, 0x000fc600000000ffULL,
0x0105002427008388ULL, 0x0003e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x800000240f0f7221ULL, 0x002fe20000010000ULL,
0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000047945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL, 0x0000000f00297308ULL, 0x000e640000000800ULL,
0x000000290c0c7220ULL, 0x002fc80000410000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000d4627f007947ULL, 0x000fea000b800000ULL, 0x00001f6c290f7589ULL, 0x0002a400000e0000ULL,
0x0000000f0b0b7220ULL, 0x084fe20000410000ULL, 0x0000000f0a0a7220ULL, 0x080fe20000410000ULL,
0x0000000f07077220ULL, 0x080fe20000410000ULL, 0x0000000f06067220ULL, 0x080fe20000410000ULL,
0x0000000f1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000f1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000f53537220ULL, 0x080fe20000410000ULL, 0x0000000f52527220ULL, 0x080fe20000410000ULL,
0x0000000f57577220ULL, 0x080fe20000410000ULL, 0x0000000f56567220ULL, 0x080fe20000410000ULL,
0x0000000f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000000f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000000f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000000f5e5e7220ULL, 0x000fc40000410000ULL,
0x0000000000047941ULL, 0x000fea0003800000ULL, 0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000d3727f007947ULL, 0x000fea000b800000ULL,
0x00001f6b290f7589ULL, 0x00046400000e0000ULL, 0x0000000f09097220ULL, 0x082fe20000410000ULL,
0x0000000f08087220ULL, 0x080fe20000410000ULL, 0x0000000f05057220ULL, 0x080fe20000410000ULL,
0x0000000f04047220ULL, 0x080fe20000410000ULL, 0x0000000f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000000f51517220ULL, 0x080fe20000410000ULL,
0x0000000f50507220ULL, 0x080fe20000410000ULL, 0x0000000f55557220ULL, 0x080fe20000410000ULL,
0x0000000f54547220ULL, 0x080fe20000410000ULL, 0x0000000f59597220ULL, 0x080fe20000410000ULL,
0x0000000f58587220ULL, 0x080fe20000410000ULL, 0x0000000f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000000f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000000f61617220ULL, 0x080fe20000410000ULL,
0x0000000f60607220ULL, 0x000fc40000410000ULL, 0x0000000000037941ULL, 0x002fea0003800000ULL,
0x0000ffff28ff7812ULL, 0x000fda0007806025ULL, 0x8000002422220221ULL, 0x000fe20000010000ULL,
0x00007610ff150816ULL, 0x000fc60000000015ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200160308ULL, 0x000e640000000800ULL, 0x0000001623230220ULL, 0x00afcc0000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000000c230c7221ULL, 0x008fe20000010000ULL,
0x000000ffff0f7224ULL, 0x000fc400078e0024ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL, 0x0000012000017945ULL, 0x000fd80003800000ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x0000d1b27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002e400000e0000ULL, 0x0000d1f27f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0000c54000207802ULL, 0x000fc40000000f00ULL, 0x0000dad000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x0000c59000207802ULL, 0x000fc40000000f00ULL,
0x0000da8000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001b20783bULL, 0x002e620000004200ULL,
0x0000b0001a247811ULL, 0x000fe200078e20ffULL, 0x0000068000017945ULL, 0x000fe20003800000ULL,
0x000000746c00720cULL, 0x000fe20003f46070ULL, 0x00000000673c783bULL, 0x000fe20000004200ULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000746b00720cULL, 0x000fe20003f26070ULL,
0x000000002448783bULL, 0x000f220000000200ULL, 0x000000106300720cULL, 0x000fc60003f03070ULL,
0x000000001d2c783bULL, 0x000ee80000004200ULL, 0x000000006a44783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fe400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff26723eULL, 0x084fe400020006ffULL, 0x00000020ff28723eULL, 0x000fc400030006ffULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x000000174848b232ULL, 0x098fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000174a4ab232ULL, 0x000fe20000000000ULL,
0x0000b0001c207811ULL, 0x000fe200078e20ffULL, 0x000000184949b232ULL, 0x080fe20000000000ULL,
0x00000021ff27723eULL, 0x080fe200020006ffULL, 0x000000184b4bb232ULL, 0x000fe20000000000ULL,
0x00000021ff29723eULL, 0x000fe400030006ffULL, 0x00000022ff30723eULL, 0x000fc400020006ffULL,
0x00000023ff31723eULL, 0x080fe400020006ffULL, 0x00000022ff34723eULL, 0x000fe200030006ffULL,
0x000000264824723cULL, 0x040f6200000018ffULL, 0x00000023ff35723eULL, 0x000fe400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031203c3c7816ULL, 0x000fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e687816ULL, 0x000fe200000000ffULL,
0x000000284828723cULL, 0x000f6200000018ffULL, 0x000031203f697816ULL, 0x000fc400000000ffULL,
0x0000003cff38723eULL, 0x080fe400020006ffULL, 0x0000003dff39723eULL, 0x080fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff3d723eULL, 0x000fe400030006ffULL, 0x00000068ff40723eULL, 0x000fe400020006ffULL,
0x00000069ff41723eULL, 0x000fc400020006ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x040f6200000018ffULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x000031202e2e7816ULL, 0x000fe400000000ffULL, 0x000031202f2f7816ULL, 0x000fe400000000ffULL,
0x0000312044447816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x000f6200000018ffULL,
0x0000312045457816ULL, 0x000fc400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x0000312047477816ULL, 0x000fc600000000ffULL, 0x0000003c483c723cULL, 0x000f6200000018ffULL,
0x000000172020b232ULL, 0x082fe40000000000ULL, 0x000000172222b232ULL, 0x000fe40000000000ULL,
0x000000182121b232ULL, 0x000fc60000000000ULL, 0x000000404840723cULL, 0x000f6200000018ffULL,
0x000000182323b232ULL, 0x000fce0000000000ULL, 0x000000684848723cULL, 0x000b6e00000018ffULL,
0x000031202c687816ULL, 0x020fe400000000ffULL, 0x000031202d697816ULL, 0x000fe400000000ffULL,
0x00000068ff2c723eULL, 0x000fc400020006ffULL, 0x00000069ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2024723cULL, 0x000b6e0000001824ULL, 0x00000068ff2c723eULL, 0x020fe400030006ffULL,
0x00000069ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fe400030006ffULL, 0x00000001742e7810ULL, 0x000fc80007ffe0ffULL,
0x0000002e6c00720cULL, 0x080fe20005746470ULL, 0x0000002c2034723cULL, 0x000b620000001834ULL,
0x0000002e6b00720cULL, 0x000fcc0004f26470ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000311e1e7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x000000495e5e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b04047221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b60607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff207f8cULL, 0x020e62000c80043fULL, 0x00000002ff237819ULL, 0x000fe2000001162eULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000232e237207ULL, 0x040fe40002800000ULL, 0x000000032e227812ULL, 0x000fe400078ec0ffULL,
0x0000000223237810ULL, 0x000fe40007ffe0ffULL, 0x000000106300720cULL, 0x000fe40003f03070ULL,
0x00000040ff2a7803ULL, 0x000fe40000000000ULL, 0x000000ff22227207ULL, 0x000fe20006800000ULL,
0x000000ffff287224ULL, 0x002fe200078e0021ULL, 0x0000000323217812ULL, 0x000fc400078ec0ffULL,
0x0000001023207211ULL, 0x000fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8400ff267984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000026ff7812ULL, 0x002fe200078c4875ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe400078c4875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x8000000023ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420237824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000652400720cULL, 0x000fe20003fc6070ULL,
0x0000004023297824ULL, 0x000fca00078e00ffULL, 0x0000004062237812ULL, 0x000fce00078ef829ULL,
0x000004f00000e947ULL, 0x000fea0003800000ULL, 0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x0000000219317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff2b7424ULL, 0x000fe400078e00ffULL, 0x010a00002c277984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe200078e0223ULL, 0x000000f0262d7812ULL, 0x000fe200078ec0ffULL,
0x000000102c287824ULL, 0x000fe200078e00ffULL, 0x0000002966267217ULL, 0x000fe40007800000ULL,
0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000126267824ULL, 0x000fe400078e0a29ULL,
0x000000012e307824ULL, 0x000fc600078e0203ULL, 0x0000000526267c17ULL, 0x000fe2000f800000ULL,
0x010ac00027277984ULL, 0x002e640000004800ULL, 0x0000002712247224ULL, 0x002fe400078e0224ULL,
0x000000012c277824ULL, 0x000fe400078e0203ULL, 0x00005e0024247625ULL, 0x000fc600078e002bULL,
0xfffffff028277812ULL, 0x000fe400078ee227ULL, 0x0000002d24247210ULL, 0x000fe40007fde0ffULL,
0x8000000526287c10ULL, 0x000fe2000fffe0ffULL, 0x000000012e267824ULL, 0x000fe200078e0223ULL,
0x0000c000272f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000281900720cULL, 0x000fda0003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a08002c297984ULL, 0x000ea20000004800ULL,
0x000000102e257824ULL, 0x002fca00078e00ffULL, 0xfffffff025307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x000fe200078e20ffULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0x0000000419317810ULL, 0x000fc80007ffe0ffULL,
0x00000005312e7c10ULL, 0x000fca000fffe0ffULL, 0x000000012e247824ULL, 0x040fe400078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e2000f101c50ULL,
0x000000012e307824ULL, 0x000fc600078e0203ULL, 0x010a10002c297984ULL, 0x000ea20000004800ULL,
0x000000102e277824ULL, 0x002fca00078e00ffULL, 0xfffffff027307812ULL, 0x000fc800078ee230ULL,
0x0000c000302f7811ULL, 0x000fe200078e20ffULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fe200030e0625ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0x0000000619317810ULL, 0x000fc80007ffe0ffULL,
0x00000005312e7c10ULL, 0x000fca000fffe0ffULL, 0x000000012e237824ULL, 0x000fe400078e0223ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a18002c297984ULL, 0x000ea80000004800ULL, 0x010ac00029297984ULL, 0x004ea40000004800ULL,
0x0000002912237224ULL, 0x004fc800078e0223ULL, 0x00005e0023267625ULL, 0x000fc800078e002bULL,
0x000000012e237824ULL, 0x000fe200078e0203ULL, 0x0000002d26267210ULL, 0x000fe20007fde0ffULL,
0x000000102e2e7824ULL, 0x000fc800078e00ffULL, 0x000000ffff277224ULL, 0x000fe200030e0627ULL,
0x000000283100720cULL, 0x000fe40003fc6070ULL, 0xfffffff02e237812ULL, 0x000fc800078ee223ULL,
0x0000c00023237811ULL, 0x000fce00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026237faeULL, 0x0003e2000f101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL, 0x00000100ff297424ULL, 0x000fe400078e00ffULL,
0x0000001003267824ULL, 0x000fe200078e00ffULL, 0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL,
0x010a00002c287984ULL, 0x000e620000004800ULL, 0x000000012c247824ULL, 0x000fe400078e0223ULL,
0x000000f0262b7812ULL, 0x000fe200078ec0ffULL, 0x000000012e2f7824ULL, 0x000fe200078e0203ULL,
0x010ac00028257984ULL, 0x002e640000004800ULL, 0x0000002512257224ULL, 0x002fc800078e0224ULL,
0x00005e0025247625ULL, 0x000fca00078e0029ULL, 0x0000002b24267210ULL, 0x000fe20007fde0ffULL,
0x000000012c247824ULL, 0x000fc800078e0203ULL, 0x000000ffff277224ULL, 0x000fe400030e0625ULL,
0x000000102c257824ULL, 0x000fca00078e00ffULL, 0xfffffff025247812ULL, 0x000fc800078ee224ULL,
0x0000c000242d7811ULL, 0x000fe200078e20ffULL, 0x000000012e247824ULL, 0x040fe400078e0223ULL,
0x000000102e2e7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0003e6000b901c50ULL, 0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL,
0x010a08002c287984ULL, 0x000ea20000004800ULL, 0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL, 0x000000012e267824ULL, 0x042fe400078e0223ULL,
0x000000012e2d7824ULL, 0x040fe400078e0203ULL, 0x000000102e2e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL, 0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL,
0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL, 0x000000012e237824ULL, 0x000fe200078e0223ULL,
0x010ac00028257984ULL, 0x004e640000004800ULL, 0x0000002512247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e0029ULL, 0x0000002b24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fca00030e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000b901c50ULL, 0x010a10002c287984ULL, 0x000ea80000004800ULL,
0x010ac00028277984ULL, 0x004ea40000004800ULL, 0x0000002712267224ULL, 0x004fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e0029ULL, 0x0000002b26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fca00030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262d7faeULL, 0x0005e8000b901c50ULL, 0x010a18002c287984ULL, 0x000e680000004800ULL,
0x010ac00028257984ULL, 0x002e640000004800ULL, 0x0000002512257224ULL, 0x002fc400078e0223ULL,
0x000000012e237824ULL, 0x000fe400078e0203ULL, 0x00005e0025247625ULL, 0x000fc800078e0029ULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0x0000002b24247210ULL, 0x000fc80007fde0ffULL,
0xfffffff02e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff257224ULL, 0x000fc600030e0625ULL,
0x0000c00023237811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024237faeULL, 0x0005e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x006e64000c80043fULL,
0x000000ffff287224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff237984ULL, 0x000e620000000800ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000023ff7812ULL, 0x002fe200078c4828ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe400078c4828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000017000017945ULL, 0x000fe20003800000ULL, 0x0000015000004947ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe40003fc4070ULL, 0x00010a0013257811ULL, 0x000fe400078e10ffULL,
0x000000ff22247207ULL, 0x000fc40003000000ULL, 0x000000ff22237207ULL, 0x000fc60007000000ULL,
0x0000000121217824ULL, 0x000fc800078e0224ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020207824ULL, 0x000fe200078e0221ULL, 0x0000000a23217c10ULL, 0x000fc8000fffe0ffULL,
0x0000002020227810ULL, 0x000fca0007ffe0ffULL, 0x0000000113237824ULL, 0x100fe400078e0222ULL,
0x0000680021207a24ULL, 0x000fe400078e0222ULL, 0x00000004ff217424ULL, 0x000fe200078e00ffULL,
0x000000662300720cULL, 0x000fe20003fc6070ULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fd000078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e4000f121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7800ff207f8cULL, 0x000e62000c80043fULL, 0x0000013000017945ULL, 0x000fe20003800000ULL,
0x000000ffff757224ULL, 0x002fe200078e0021ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x0000b5827f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002a400000e0000ULL,
0x0000b5c27f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0000e23000207802ULL, 0x000fc40000000f00ULL,
0x0000bde000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x0000e28000207802ULL, 0x000fc40000000f00ULL, 0x0000bd9000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000006e20783bULL, 0x00ae620000004200ULL, 0x0000b0006f247811ULL, 0x000fe200078e20ffULL,
0x0000062000017945ULL, 0x000fe20003800000ULL, 0x000000ff2a00720cULL, 0x000fe20003fc5270ULL,
0x000000006d3c783bULL, 0x000fe80000004200ULL, 0x000000002448783bULL, 0x000ee80000000200ULL,
0x00000000712c783bULL, 0x000f280000004200ULL, 0x000000007244783bULL, 0x000ea20000004200ULL,
0x0000312020207816ULL, 0x002fc400000000ffULL, 0x0000312021217816ULL, 0x000fe400000000ffULL,
0x00000020ff26723eULL, 0x084fe400020006ffULL, 0x00000020ff28723eULL, 0x000fe400030006ffULL,
0x0000312022227816ULL, 0x000fe200000000ffULL, 0x000000174848b232ULL, 0x088fe20000000000ULL,
0x0000312023237816ULL, 0x000fe200000000ffULL, 0x000000174a4ab232ULL, 0x000fe20000000000ULL,
0x0000b00070207811ULL, 0x000fe200078e20ffULL, 0x000000184949b232ULL, 0x080fe20000000000ULL,
0x00000021ff27723eULL, 0x080fe200020006ffULL, 0x000000184b4bb232ULL, 0x000fe20000000000ULL,
0x00000021ff29723eULL, 0x000fc400030006ffULL, 0x00000022ff30723eULL, 0x080fe400020006ffULL,
0x00000023ff31723eULL, 0x080fe400020006ffULL, 0x00000022ff34723eULL, 0x000fe200030006ffULL,
0x000000264824723cULL, 0x000f6200000018ffULL, 0x00000023ff35723eULL, 0x000fe400030006ffULL,
0x000000002020783bULL, 0x000e620000000200ULL, 0x000031203c3c7816ULL, 0x000fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc400000000ffULL, 0x000031203e687816ULL, 0x000fe200000000ffULL,
0x000000284828723cULL, 0x040f6200000018ffULL, 0x000031203f697816ULL, 0x000fe400000000ffULL,
0x0000003cff38723eULL, 0x080fe400020006ffULL, 0x0000003dff39723eULL, 0x080fe400020006ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x000000304830723cULL, 0x000f6200000018ffULL,
0x0000003dff3d723eULL, 0x000fc400030006ffULL, 0x00000068ff40723eULL, 0x080fe400020006ffULL,
0x00000069ff41723eULL, 0x080fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe200030006ffULL,
0x000000344834723cULL, 0x000f6200000018ffULL, 0x00000069ff69723eULL, 0x000fe400030006ffULL,
0x000031202e2e7816ULL, 0x010fe400000000ffULL, 0x000031202f2f7816ULL, 0x000fc400000000ffULL,
0x0000312044447816ULL, 0x000fe200000000ffULL, 0x000000384838723cULL, 0x000f6200000018ffULL,
0x0000312045457816ULL, 0x000fe400000000ffULL, 0x0000312046467816ULL, 0x000fe400000000ffULL,
0x0000312047477816ULL, 0x000fc600000000ffULL, 0x0000003c483c723cULL, 0x000f6200000018ffULL,
0x000000172020b232ULL, 0x082fe40000000000ULL, 0x000000172222b232ULL, 0x000fe40000000000ULL,
0x000000182121b232ULL, 0x000fc60000000000ULL, 0x000000404840723cULL, 0x000f6200000018ffULL,
0x000000182323b232ULL, 0x000fce0000000000ULL, 0x000000684848723cULL, 0x000b6e00000018ffULL,
0x000031202c687816ULL, 0x020fe400000000ffULL, 0x000031202d697816ULL, 0x000fe400000000ffULL,
0x00000068ff2c723eULL, 0x000fc400020006ffULL, 0x00000069ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2024723cULL, 0x000b6e0000001824ULL, 0x00000068ff2c723eULL, 0x020fe400030006ffULL,
0x00000069ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2028723cULL, 0x000b6e0000001828ULL,
0x0000002eff2c723eULL, 0x020fe400020006ffULL, 0x0000002fff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2030723cULL, 0x000b6e0000001830ULL, 0x0000002eff2c723eULL, 0x020fe400030006ffULL,
0x0000002fff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2034723cULL, 0x000b6e0000001834ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000311e1e7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x000000495e5e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b04047221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000174747810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000737400720cULL, 0x000fe20003f06070ULL, 0x010b8800ff267f8cULL, 0x000e58000c80043fULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffbcf000007947ULL, 0x000fea000383ffffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c010217811ULL, 0x020fe200078e40ffULL,
0x010b6800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000662100720cULL, 0x000fda0003f06070ULL,
0x0000438000000947ULL, 0x000fea0003800000ULL, 0x000000ffff747224ULL, 0x000fca00078e00ffULL,
0x00000002ff217819ULL, 0x020fe20000011674ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000374227812ULL, 0x040fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x0000002174217207ULL, 0x000fe40002800000ULL, 0x000000ff22227207ULL, 0x000fe40006800000ULL,
0x0000000321237810ULL, 0x000fc80007ffe0ffULL, 0x0000000323217812ULL, 0x040fe400078ec0ffULL,
0x0000001023207211ULL, 0x002fc400078ff0ffULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b7c00ff267984ULL, 0x002e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000017945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028242b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e25ULL,
0x003d09002b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011429ULL, 0x0000002b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000226267819ULL, 0x000fc80000001229ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b7c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804875ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x00000028242b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e25ULL, 0x003d09002b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011429ULL,
0x0000002b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000226267819ULL, 0x000fc80000001229ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000120247810ULL, 0x040fe20007ffe0ffULL, 0x0000000420257824ULL, 0x000fe200078e0221ULL,
0x0000097000017945ULL, 0x000fe40003800000ULL, 0x000000652400720cULL, 0x000fe40003f06070ULL,
0x0000002025277811ULL, 0x000fc800078e30ffULL, 0x0000006062287812ULL, 0x000fce00078ef827ULL,
0x000004f000008947ULL, 0x000fea0003800000ULL, 0x00000005192b7c10ULL, 0x040fe2000fffe0ffULL,
0x00000100ff2d7424ULL, 0x000fe200078e00ffULL, 0x0000002766247217ULL, 0x000fe40007800000ULL,
0x0000000219337810ULL, 0x000fe20007ffe0ffULL, 0x010a00002b257984ULL, 0x000e620000004800ULL,
0x000000012b267824ULL, 0x000fe400078e0228ULL, 0x0000000124247824ULL, 0x000fe200078e0a27ULL,
0x00000005332c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fc600078e00ffULL,
0x0000000524247c17ULL, 0x000fe2000f800000ULL, 0x000000012c2e7824ULL, 0x100fe200078e0203ULL,
0x000000f0272f7812ULL, 0x000fe200078ec0ffULL, 0x000000012b277824ULL, 0x000fe200078e0203ULL,
0x80000005242a7c10ULL, 0x000fc8000fffe0ffULL, 0x0000002a1900720cULL, 0x000fe20003f06070ULL,
0x010ac00025257984ULL, 0x002e640000004800ULL, 0x0000002512267224ULL, 0x002fc800078e0226ULL,
0x00005e0026247625ULL, 0x000fc800078e002dULL, 0x000000102b267824ULL, 0x000fe200078e00ffULL,
0x0000002f24247210ULL, 0x000fc80007f3e0ffULL, 0xfffffff026277812ULL, 0x000fe200078ee227ULL,
0x000000ffff257224ULL, 0x000fe400008e0625ULL, 0x000000012c267824ULL, 0x000fe200078e0228ULL,
0x0000e00027317811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x010a08002b297984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x0000000419337810ULL, 0x000fe40007ffe0ffULL,
0x0000e0002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c2e7824ULL, 0x000fe200078e0203ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26247210ULL, 0x000fe20007f3e0ffULL, 0x000000012c267824ULL, 0x000fc800078e0228ULL,
0x000000ffff257224ULL, 0x000fca00008e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024317faeULL, 0x0003e2000c101c50ULL, 0x0000002a3300720cULL, 0x000fe20003f06070ULL,
0x000000102c337824ULL, 0x000fe400078e00ffULL, 0x010a10002b297984ULL, 0x000ea60000004800ULL,
0xfffffff0332e7812ULL, 0x000fe400078ee22eULL, 0x0000000619337810ULL, 0x000fe40007ffe0ffULL,
0x0000e0002e317811ULL, 0x002fc400078e20ffULL, 0x00000005332c7c10ULL, 0x000fca000fffe0ffULL,
0x000000012c287824ULL, 0x000fe200078e0228ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002dULL,
0x0000002f26247210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff257224ULL, 0x000fca00008e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000c101c50ULL,
0x0000002a3300720cULL, 0x000fc60003f06070ULL, 0x010a18002b297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912267224ULL, 0x004fe400078e0228ULL,
0x000000012c287824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002dULL,
0x000000102c2d7824ULL, 0x000fe200078e00ffULL, 0x0000002f26247210ULL, 0x002fc80007f3e0ffULL,
0xfffffff02d287812ULL, 0x000fe200078ee228ULL, 0x000000ffff257224ULL, 0x000fc600008e0627ULL,
0x0000e00028277811ULL, 0x000fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024277faeULL, 0x0003e2000c101c50ULL, 0x0000043000007947ULL, 0x000fea0003800000ULL,
0x00000005192a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003277824ULL, 0x000fe400078e00ffULL,
0x00000100ff2b7424ULL, 0x000fe400078e00ffULL, 0x010a00002a267984ULL, 0x000e620000004800ULL,
0x000000012a247824ULL, 0x040fe200078e0228ULL, 0x000000f0272d7812ULL, 0x000fe200078ec0ffULL,
0x000000012a277824ULL, 0x040fe400078e0203ULL, 0x000000102a2c7824ULL, 0x000fca00078e00ffULL,
0xfffffff02c277812ULL, 0x000fe400078ee227ULL, 0x000000022a2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000e000272f7811ULL, 0x000fc600078e20ffULL, 0x000000012c2e7824ULL, 0x040fe400078e0203ULL,
0x000000102c317824ULL, 0x000fca00078e00ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x010ac00026257984ULL, 0x0022a40000004800ULL, 0x000000012c267824ULL, 0x002fe200078e0228ULL,
0x000000042a2c7810ULL, 0x000fca0007ffe0ffULL, 0x000000102c317824ULL, 0x000fe400078e00ffULL,
0x0000002512257224ULL, 0x004fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e002bULL,
0x0000002d24247210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff257224ULL, 0x000fca00000e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a08002a297984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fe200078e20ffULL,
0x000000012c247824ULL, 0x040fe400078e0228ULL, 0x000000012c2e7824ULL, 0x000fe200078e0203ULL,
0x000000062a2c7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff0312e7812ULL, 0x000fe200078ee22eULL,
0x000000012c287824ULL, 0x000fe200078e0228ULL, 0x010ac00029297984ULL, 0x004e640000004800ULL,
0x0000002912267224ULL, 0x002fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e002bULL,
0x0000002d26267210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002a297984ULL, 0x000ea20000004800ULL, 0x0000e0002e2f7811ULL, 0x002fc600078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000b901c50ULL, 0x010a18002a297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912267224ULL, 0x004fc400078e0228ULL,
0x000000012c287824ULL, 0x000fe400078e0203ULL, 0x00005e0026267625ULL, 0x000fc800078e002bULL,
0x000000102c2b7824ULL, 0x000fe200078e00ffULL, 0x0000002d26267210ULL, 0x000fc80007f1e0ffULL,
0xfffffff02b287812ULL, 0x000fe200078ee228ULL, 0x000000ffff277224ULL, 0x000fc600000e0627ULL,
0x0000e00028257811ULL, 0x002fca00078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e4000b901c50ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff247f8cULL, 0x002e64000c80043fULL,
0x000000ffff2b7224ULL, 0x002fc400078e0025ULL, 0x0000000000247805ULL, 0x000fca0000015200ULL,
0x010b8c00ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000017945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624297210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000002926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8c00ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000206300720cULL, 0x000fe20003f04070ULL, 0x0000015000017945ULL, 0x000fe20003800000ULL,
0x0000000123237812ULL, 0x000fe400078ec0ffULL, 0x000000032200780cULL, 0x000fc80004705270ULL,
0x000000012300780cULL, 0x000fda0000705470ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000031300780cULL, 0x000fe40003f04070ULL, 0x0000000111117810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000e620000002700ULL,
0x000000641100720cULL, 0x040fe20003f06070ULL, 0x00000004ff257424ULL, 0x000fe400078e00ffULL,
0x0000000424237824ULL, 0x002fe200078e0213ULL, 0x0000640011247a10ULL, 0x000fc60007ffe0ffULL,
0x0000000223237824ULL, 0x000fc800078e00ffULL, 0x0000640023247a24ULL, 0x000fe200078e0224ULL,
0x00010ac013237811ULL, 0x000fc600078e10ffULL, 0x0000600024247625ULL, 0x000fca00078e0025ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000018000017945ULL, 0x000fe20003800000ULL,
0x0000016000004947ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe40003f04070ULL,
0x0000000122227810ULL, 0x000fc80007ffe0ffULL, 0x0000000322237812ULL, 0x002fc800078ec0ffULL,
0x000000ff23237207ULL, 0x000fc60004000000ULL, 0x00000002ff228819ULL, 0x000fca0000011622ULL,
0x0000000121217824ULL, 0x000fc800078e0222ULL, 0x0000004021227824ULL, 0x040fe200078e00ffULL,
0x0000002021207211ULL, 0x000fc800078ff0ffULL, 0x000000c022217812ULL, 0x000fca00078ec0ffULL,
0x0000010020227824ULL, 0x000fe200078e0221ULL, 0x0000000a23207c10ULL, 0x000fe4000fffe0ffULL,
0x00010a0013237811ULL, 0x040fe200078e10ffULL, 0x0000000113217824ULL, 0x100fe400078e0222ULL,
0x0000680020207a24ULL, 0x000fc600078e0222ULL, 0x000000662100720cULL, 0x000fe20003f06070ULL,
0x00000004ff217424ULL, 0x000fe400078e00ffULL, 0x0000000113207824ULL, 0x000fc800078e0220ULL,
0x0000660020207625ULL, 0x000fcc00078e0021ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020237faeULL, 0x0003e4000c121850ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x010b8000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8000ff207f8cULL, 0x000e62000c80043fULL, 0x000000ff7400720cULL, 0x000fe20003f05270ULL,
0x000007e000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fd600078e0021ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b3800ff207f8cULL, 0x000e64000c800405ULL, 0x000000ffff247224ULL, 0x002fc400078e0021ULL,
0x0000000000207805ULL, 0x000fca0000015200ULL, 0x010b3c05ff157984ULL, 0x000e640008000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000027945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000037945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220227210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff157819ULL, 0x000fc80000011423ULL, 0x0000002215157211ULL, 0x000fca00078110ffULL,
0x000000ffff227224ULL, 0x000fca00000e0623ULL, 0x0000000215157819ULL, 0x000fc80000001222ULL,
0x000000150000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000037941ULL, 0x000fea0003800000ULL,
0x010b3c05ff157984ULL, 0x000e640008000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000001003157824ULL, 0x000fe200078e00ffULL,
0x00000001ff207819ULL, 0x000fc80000011603ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c20207812ULL, 0x000fca00078ec0ffULL, 0x0000000115277824ULL, 0x000fca00078e0220ULL,
0x0101800027227984ULL, 0x000e680000000800ULL, 0x0103800027237984ULL, 0x0004e20000000800ULL,
0x0000000f2200720bULL, 0x002fe20003f1d000ULL, 0x000094727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15287812ULL, 0x000fe2000780c0ffULL,
0x0000043000027945ULL, 0x000fe20003800000ULL, 0x00000001ff157424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e000fULL, 0x000003f000008947ULL, 0x000fea0003800000ULL,
0x000000030200780cULL, 0x000fe40003f05270ULL, 0x0000000f2200720bULL, 0x000fe20003f34000ULL,
0x000094327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x000fc400008e0100ULL,
0x000000220f247209ULL, 0x000fe20007810000ULL, 0x0000033000037945ULL, 0x000fe20003800000ULL,
0x0000991025207816ULL, 0x000fc600000000ffULL, 0x0105802427008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x800000240f0f7221ULL, 0x002fe20000010000ULL, 0x000000ff25ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000047945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0f0f7820ULL, 0x000fc80000410000ULL,
0x0000000f00297308ULL, 0x000e640000000800ULL, 0x000000290c0c7220ULL, 0x002fc80000410000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x000093827f007947ULL, 0x000fea000b800000ULL,
0x00001f6c290f7589ULL, 0x0002a400000e0000ULL, 0x0000000f0b0b7220ULL, 0x084fe20000410000ULL,
0x0000000f0a0a7220ULL, 0x080fe20000410000ULL, 0x0000000f07077220ULL, 0x080fe20000410000ULL,
0x0000000f06067220ULL, 0x080fe20000410000ULL, 0x0000000f1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000f1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000f4f4f7220ULL, 0x080fe20000410000ULL,
0x0000000f4e4e7220ULL, 0x080fe20000410000ULL, 0x0000000f53537220ULL, 0x080fe20000410000ULL,
0x0000000f52527220ULL, 0x080fe20000410000ULL, 0x0000000f57577220ULL, 0x080fe20000410000ULL,
0x0000000f56567220ULL, 0x080fe20000410000ULL, 0x0000000f5b5b7220ULL, 0x080fe20000410000ULL,
0x0000000f5a5a7220ULL, 0x080fe20000410000ULL, 0x0000000f5f5f7220ULL, 0x080fe20000410000ULL,
0x0000000f5e5e7220ULL, 0x000fc40000410000ULL, 0x0000000000047941ULL, 0x000fea0003800000ULL,
0x0000ff0025ff7812ULL, 0x000fda000780c0ffULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x000092927f007947ULL, 0x000fea000b800000ULL, 0x00001f6b290f7589ULL, 0x00046400000e0000ULL,
0x0000000f09097220ULL, 0x082fe20000410000ULL, 0x0000000f08087220ULL, 0x080fe20000410000ULL,
0x0000000f05057220ULL, 0x080fe20000410000ULL, 0x0000000f04047220ULL, 0x080fe20000410000ULL,
0x0000000f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000f51517220ULL, 0x080fe20000410000ULL, 0x0000000f50507220ULL, 0x080fe20000410000ULL,
0x0000000f55557220ULL, 0x080fe20000410000ULL, 0x0000000f54547220ULL, 0x080fe20000410000ULL,
0x0000000f59597220ULL, 0x080fe20000410000ULL, 0x0000000f58587220ULL, 0x080fe20000410000ULL,
0x0000000f5d5d7220ULL, 0x080fe20000410000ULL, 0x0000000f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000000f61617220ULL, 0x080fe20000410000ULL, 0x0000000f60607220ULL, 0x000fc40000410000ULL,
0x0000000000037941ULL, 0x002fea0003800000ULL, 0x0000ffff28ff7812ULL, 0x000fda0007806025ULL,
0x8000002422220221ULL, 0x000fe20000010000ULL, 0x00007610ff150816ULL, 0x000fc60000000015ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200160308ULL, 0x000e640000000800ULL,
0x0000001623230220ULL, 0x00afcc0000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000000c230c7221ULL, 0x008fe20000010000ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0024ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ff15ff7812ULL, 0x000fe2000786c0ffULL,
0x0000012000017945ULL, 0x000fd80003800000ULL, 0x0000010000003947ULL, 0x000fea0003800000ULL,
0x00000016ff17723eULL, 0x000fc800000000ffULL, 0x0000541017227816ULL, 0x000fe20000000017ULL,
0x000090d27f007947ULL, 0x000fea000b800000ULL, 0x00001f6c22177589ULL, 0x0002e400000e0000ULL,
0x000091127f007947ULL, 0x000fea000b800000ULL, 0x00001f6b22187589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000106c277810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000108f000207802ULL, 0x000fc40000000f00ULL,
0x0000972000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000ffff267224ULL, 0x004fe200078e0022ULL, 0x000000186c277810ULL, 0x002fe40007ffe0ffULL,
0x0001094000207802ULL, 0x000fc40000000f00ULL, 0x000096d000007944ULL, 0x008fea0003c00000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001b20783bULL, 0x002e620000004200ULL, 0x0000b8001a247811ULL, 0x000fe200078e20ffULL,
0x0000068000017945ULL, 0x000fe20003800000ULL, 0x000000746c00720cULL, 0x000fe20003f46070ULL,
0x00000000673c783bULL, 0x000fe20000004200ULL, 0x000000106300720cULL, 0x000fc40003fc3070ULL,
0x000000746b00720cULL, 0x000fe20003f26070ULL, 0x000000002448783bULL, 0x000f220000000200ULL,
0x000000106300720cULL, 0x000fc60003f03070ULL, 0x000000001d2c783bULL, 0x000ee80000004200ULL,
0x000000006a44783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fe400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fc400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x098fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000b8001c207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fe400030006ffULL,
0x00000022ff30723eULL, 0x000fc400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x040f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fe400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x000f6200000018ffULL,
0x000031203f697816ULL, 0x000fc400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fe400030006ffULL,
0x00000068ff40723eULL, 0x000fe400020006ffULL, 0x00000069ff41723eULL, 0x000fc400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x040f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x000fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fe400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fc400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fe400030006ffULL,
0x00000001742e7810ULL, 0x000fc80007ffe0ffULL, 0x0000002e6c00720cULL, 0x080fe20005746470ULL,
0x0000002c2034723cULL, 0x000b620000001834ULL, 0x0000002e6b00720cULL, 0x000fcc0004f26470ULL,
0x00000044ff2c723eULL, 0x020fe400020006ffULL, 0x00000045ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2038723cULL, 0x000b6e0000001838ULL, 0x00000044ff2c723eULL, 0x020fe400030006ffULL,
0x00000045ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c203c723cULL, 0x000b6e000000183cULL,
0x00000046ff2c723eULL, 0x020fe400020006ffULL, 0x00000047ff2d723eULL, 0x000fce00020006ffULL,
0x0000002c2040723cULL, 0x000b6e0000001840ULL, 0x00000046ff2c723eULL, 0x020fe400030006ffULL,
0x00000047ff2d723eULL, 0x000fce00030006ffULL, 0x0000002c2048723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000010000002947ULL, 0x000fde0003000000ULL,
0x000000240b0b7221ULL, 0x000fe20000010000ULL, 0x000000250a0a7221ULL, 0x000fe20000010000ULL,
0x0000002807077221ULL, 0x000fe20000010000ULL, 0x0000002906067221ULL, 0x000fe20000010000ULL,
0x000000301f1f7221ULL, 0x000fe20000010000ULL, 0x000000311e1e7221ULL, 0x000fe20000010000ULL,
0x000000344f4f7221ULL, 0x000fe20000010000ULL, 0x000000354e4e7221ULL, 0x000fe20000010000ULL,
0x0000003853537221ULL, 0x000fe20000010000ULL, 0x0000003952527221ULL, 0x000fe20000010000ULL,
0x0000003c57577221ULL, 0x000fe20000010000ULL, 0x0000003d56567221ULL, 0x000fe20000010000ULL,
0x000000405b5b7221ULL, 0x000fe20000010000ULL, 0x000000415a5a7221ULL, 0x000fe20000010000ULL,
0x000000485f5f7221ULL, 0x020fe20000010000ULL, 0x000000495e5e7221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000012000017945ULL, 0x000fe20003800000ULL,
0x0000010000001947ULL, 0x000fea0000000000ULL, 0x0000002609097221ULL, 0x000fe20000010000ULL,
0x0000002708087221ULL, 0x000fe20000010000ULL, 0x0000002a05057221ULL, 0x000fe20000010000ULL,
0x0000002b04047221ULL, 0x000fe20000010000ULL, 0x000000324d4d7221ULL, 0x000fe20000010000ULL,
0x000000334c4c7221ULL, 0x000fe20000010000ULL, 0x0000003651517221ULL, 0x000fe20000010000ULL,
0x0000003750507221ULL, 0x000fe20000010000ULL, 0x0000003a55557221ULL, 0x000fe20000010000ULL,
0x0000003b54547221ULL, 0x000fe20000010000ULL, 0x0000003e59597221ULL, 0x000fe20000010000ULL,
0x0000003f58587221ULL, 0x000fe20000010000ULL, 0x000000425d5d7221ULL, 0x000fe20000010000ULL,
0x000000435c5c7221ULL, 0x000fe20000010000ULL, 0x0000004a61617221ULL, 0x020fe20000010000ULL,
0x0000004b60607221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b8800ff207f8cULL, 0x020e62000c80043fULL,
0x00000002ff237819ULL, 0x000fe2000001162eULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x000000106300720cULL, 0x000fc40003fc3070ULL, 0x000000232e237207ULL, 0x040fe40002800000ULL,
0x000000032e227812ULL, 0x000fe400078ec0ffULL, 0x0000000323237810ULL, 0x000fe40007ffe0ffULL,
0x000000106300720cULL, 0x000fe40003f03070ULL, 0x00000040ff2a7803ULL, 0x000fe40000000000ULL,
0x000000ff22227207ULL, 0x000fe20006800000ULL, 0x000000ffff287224ULL, 0x002fe200078e0021ULL,
0x0000000323217812ULL, 0x000fc400078ec0ffULL, 0x0000001023207211ULL, 0x000fc400078ff0ffULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8400ff267984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x8000000026ff7812ULL, 0x002fe200078c4875ULL,
0x000001d000017945ULL, 0x000fd80003800000ULL, 0x000001b000006947ULL, 0x000fea0003800000ULL,
0x000000102900780cULL, 0x000fe20003fc6270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x000001100000e947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007fde1ffULL,
0x0000000127277824ULL, 0x000fe200030e0e25ULL, 0x003d09002600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000200000e947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000700000e947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc80000011427ULL,
0x0000002623237211ULL, 0x000fca00078d10ffULL, 0x000000ffff267224ULL, 0x000fca00030e0627ULL,
0x0000000223237819ULL, 0x000fc80000001226ULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x010b8400ff267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe400078c4875ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe500000e947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000120247810ULL, 0x040fe20007ffe0ffULL,
0x0000000420237824ULL, 0x000fe200078e0221ULL, 0x0000097000017945ULL, 0x000fe40003800000ULL,
0x000000652400720cULL, 0x000fe20003fc6070ULL, 0x0000004023297824ULL, 0x000fca00078e00ffULL,
0x0000004062237812ULL, 0x000fce00078ef829ULL, 0x000004f00000e947ULL, 0x000fea0003800000ULL,
0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x0000000219317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff2b7424ULL, 0x000fe400078e00ffULL,
0x010a00002c277984ULL, 0x000e620000004800ULL, 0x000000012c247824ULL, 0x000fe200078e0223ULL,
0x000000f0262d7812ULL, 0x000fe200078ec0ffULL, 0x000000102c287824ULL, 0x000fe200078e00ffULL,
0x0000002966267217ULL, 0x000fe40007800000ULL, 0x00000005312e7c10ULL, 0x000fc6000fffe0ffULL,
0x0000000126267824ULL, 0x000fe400078e0a29ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x0000000526267c17ULL, 0x000fe2000f800000ULL, 0x010ac00027277984ULL, 0x002e640000004800ULL,
0x0000002712247224ULL, 0x002fe400078e0224ULL, 0x000000012c277824ULL, 0x000fe400078e0203ULL,
0x00005e0024247625ULL, 0x000fc600078e002bULL, 0xfffffff028277812ULL, 0x000fe400078ee227ULL,
0x0000002d24247210ULL, 0x000fe40007fde0ffULL, 0x8000000526287c10ULL, 0x000fe2000fffe0ffULL,
0x000000012e267824ULL, 0x000fe200078e0223ULL, 0x0000c000272f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000281900720cULL, 0x000fda0003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000f101c50ULL,
0x010a08002c297984ULL, 0x000ea20000004800ULL, 0x000000102e257824ULL, 0x002fca00078e00ffULL,
0xfffffff025307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912267224ULL, 0x002fc800078e0226ULL,
0x00005e0026267625ULL, 0x000fca00078e002bULL, 0x0000002d26267210ULL, 0x000fca0007fde0ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x0000000419317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000262f7faeULL, 0x0003e2000f101c50ULL, 0x000000012e307824ULL, 0x000fc600078e0203ULL,
0x010a10002c297984ULL, 0x000ea20000004800ULL, 0x000000102e277824ULL, 0x002fca00078e00ffULL,
0xfffffff027307812ULL, 0x000fc800078ee230ULL, 0x0000c000302f7811ULL, 0x000fe200078e20ffULL,
0x010ac00029297984ULL, 0x004e640000004800ULL, 0x0000002912247224ULL, 0x002fc800078e0224ULL,
0x00005e0024247625ULL, 0x000fca00078e002bULL, 0x0000002d24247210ULL, 0x000fca0007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200030e0625ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0x0000000619317810ULL, 0x000fc80007ffe0ffULL, 0x00000005312e7c10ULL, 0x000fca000fffe0ffULL,
0x000000012e237824ULL, 0x000fe400078e0223ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000242f7faeULL, 0x0003e8000f101c50ULL, 0x010a18002c297984ULL, 0x000ea80000004800ULL,
0x010ac00029297984ULL, 0x004ea40000004800ULL, 0x0000002912237224ULL, 0x004fc800078e0223ULL,
0x00005e0023267625ULL, 0x000fc800078e002bULL, 0x000000012e237824ULL, 0x000fe200078e0203ULL,
0x0000002d26267210ULL, 0x000fe20007fde0ffULL, 0x000000102e2e7824ULL, 0x000fc800078e00ffULL,
0x000000ffff277224ULL, 0x000fe200030e0627ULL, 0x000000283100720cULL, 0x000fe40003fc6070ULL,
0xfffffff02e237812ULL, 0x000fc800078ee223ULL, 0x0000c00023237811ULL, 0x000fce00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000f101c50ULL,
0x0000043000007947ULL, 0x000fea0003800000ULL, 0x00000005192c7c10ULL, 0x000fe2000fffe0ffULL,
0x00000100ff297424ULL, 0x000fe400078e00ffULL, 0x0000001003267824ULL, 0x000fe200078e00ffULL,
0x000000022c2e7810ULL, 0x040fe20007ffe0ffULL, 0x010a00002c287984ULL, 0x000e620000004800ULL,
0x000000012c247824ULL, 0x000fe400078e0223ULL, 0x000000f0262b7812ULL, 0x000fe200078ec0ffULL,
0x000000012e2f7824ULL, 0x000fe200078e0203ULL, 0x010ac00028257984ULL, 0x002e640000004800ULL,
0x0000002512257224ULL, 0x002fc800078e0224ULL, 0x00005e0025247625ULL, 0x000fca00078e0029ULL,
0x0000002b24267210ULL, 0x000fe20007fde0ffULL, 0x000000012c247824ULL, 0x000fc800078e0203ULL,
0x000000ffff277224ULL, 0x000fe400030e0625ULL, 0x000000102c257824ULL, 0x000fca00078e00ffULL,
0xfffffff025247812ULL, 0x000fc800078ee224ULL, 0x0000c000242d7811ULL, 0x000fe200078e20ffULL,
0x000000012e247824ULL, 0x040fe400078e0223ULL, 0x000000102e2e7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0003e6000b901c50ULL,
0xfffffff02e2f7812ULL, 0x000fe200078ee22fULL, 0x010a08002c287984ULL, 0x000ea20000004800ULL,
0x000000042c2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000c0002f2f7811ULL, 0x000fc600078e20ffULL,
0x000000012e267824ULL, 0x042fe400078e0223ULL, 0x000000012e2d7824ULL, 0x040fe400078e0203ULL,
0x000000102e2e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2d7812ULL, 0x000fe400078ee22dULL,
0x000000062c2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000c0002d2d7811ULL, 0x000fc600078e20ffULL,
0x000000012e237824ULL, 0x000fe200078e0223ULL, 0x010ac00028257984ULL, 0x004e640000004800ULL,
0x0000002512247224ULL, 0x002fc800078e0224ULL, 0x00005e0024247625ULL, 0x000fca00078e0029ULL,
0x0000002b24247210ULL, 0x000fca0007fde0ffULL, 0x000000ffff257224ULL, 0x000fca00030e0625ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242f7faeULL, 0x0003e8000b901c50ULL,
0x010a10002c287984ULL, 0x000ea80000004800ULL, 0x010ac00028277984ULL, 0x004ea40000004800ULL,
0x0000002712267224ULL, 0x004fc800078e0226ULL, 0x00005e0026267625ULL, 0x000fca00078e0029ULL,
0x0000002b26267210ULL, 0x000fca0007fde0ffULL, 0x000000ffff277224ULL, 0x000fca00030e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262d7faeULL, 0x0005e8000b901c50ULL,
0x010a18002c287984ULL, 0x000e680000004800ULL, 0x010ac00028257984ULL, 0x002e640000004800ULL,
0x0000002512257224ULL, 0x002fc400078e0223ULL, 0x000000012e237824ULL, 0x000fe400078e0203ULL,
0x00005e0025247625ULL, 0x000fc800078e0029ULL, 0x000000102e2e7824ULL, 0x000fe200078e00ffULL,
0x0000002b24247210ULL, 0x000fc80007fde0ffULL, 0xfffffff02e237812ULL, 0x000fe200078ee223ULL,
0x000000ffff257224ULL, 0x000fc600030e0625ULL, 0x0000c00023237811ULL, 0x000fca00078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024237faeULL, 0x0005e4000b901c50ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b8800ff247f8cULL, 0x006e64000c80043fULL, 0x000000ffff287224ULL, 0x002fc400078e0025ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x010b8c00ff237984ULL, 0x000e620000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x8000000023ff7812ULL, 0x002fe200078c4828ULL, 0x000001d000017945ULL, 0x000fd80003800000ULL,
0x000001b000006947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003fc6270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x000001100000e947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624267210ULL, 0x000fca0007fde1ffULL, 0x0000000127277824ULL, 0x000fe200030e0e25ULL,
0x003d09002600780cULL, 0x000fc80003fc6070ULL, 0x000000ff2700720cULL, 0x000fda0003fc6360ULL,
0x000000200000e947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402600780cULL, 0x000fc80003fc6070ULL,
0x000000ff2700720cULL, 0x000fda0003fc6360ULL, 0x000000700000e947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc80000011427ULL, 0x0000002623237211ULL, 0x000fca00078d10ffULL,
0x000000ffff267224ULL, 0x000fca00030e0627ULL, 0x0000000223237819ULL, 0x000fc80000001226ULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x010b8c00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe400078c4828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe500000e947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000017000017945ULL, 0x000fe20003800000ULL,
0x0000015000004947ULL, 0x000fea0003800000ULL, 0x000000206300720cULL, 0x000fe40003fc4070ULL,
0x00010a0013257811ULL, 0x000fe400078e10ffULL, 0x000000ff22247207ULL, 0x000fc40003000000ULL,
0x000000ff22237207ULL, 0x000fc60007000000ULL, 0x0000000121217824ULL, 0x000fc800078e0224ULL,
0x0000004021227824ULL, 0x040fe200078e00ffULL, 0x0000002021207211ULL, 0x000fc800078ff0ffULL,
0x000000c022217812ULL, 0x000fca00078ec0ffULL, 0x0000010020207824ULL, 0x000fe200078e0221ULL,
0x0000000a23217c10ULL, 0x000fc8000fffe0ffULL, 0x0000002020227810ULL, 0x000fca0007ffe0ffULL,
0x0000000113237824ULL, 0x100fe400078e0222ULL, 0x0000680021207a24ULL, 0x000fe400078e0222ULL,
0x00000004ff217424ULL, 0x000fe200078e00ffULL, 0x000000662300720cULL, 0x000fe20003fc6070ULL,
0x0000000113207824ULL, 0x000fc800078e0220ULL, 0x0000660020207625ULL, 0x000fd000078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e4000f121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x010b7800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010b7800ff207f8cULL, 0x000e62000c80043fULL,
0x0000013000017945ULL, 0x000fe20003800000ULL, 0x000000ffff757224ULL, 0x002fe200078e0021ULL,
0x0000010000003947ULL, 0x000fea0003800000ULL, 0x00000016ff17723eULL, 0x000fc800000000ffULL,
0x0000541017227816ULL, 0x000fe20000000017ULL, 0x000074a27f007947ULL, 0x000fea000b800000ULL,
0x00001f6c22177589ULL, 0x0002a400000e0000ULL, 0x000074e27f007947ULL, 0x000fea000b800000ULL,
0x00001f6b22187589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000106c277810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000125e000207802ULL, 0x000fc40000000f00ULL, 0x00007a3000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000ffff267224ULL, 0x004fe200078e0022ULL,
0x000000186c277810ULL, 0x002fe40007ffe0ffULL, 0x0001263000207802ULL, 0x000fc40000000f00ULL,
0x000079e000007944ULL, 0x008fea0003c00000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000006e20783bULL, 0x00ae620000004200ULL,
0x0000b8006f247811ULL, 0x000fe200078e20ffULL, 0x0000062000017945ULL, 0x000fe20003800000ULL,
0x000000ff2a00720cULL, 0x000fe20003fc5270ULL, 0x000000006d3c783bULL, 0x000fe80000004200ULL,
0x000000002448783bULL, 0x000ee80000000200ULL, 0x00000000712c783bULL, 0x000f280000004200ULL,
0x000000007244783bULL, 0x000ea20000004200ULL, 0x0000312020207816ULL, 0x002fc400000000ffULL,
0x0000312021217816ULL, 0x000fe400000000ffULL, 0x00000020ff26723eULL, 0x084fe400020006ffULL,
0x00000020ff28723eULL, 0x000fe400030006ffULL, 0x0000312022227816ULL, 0x000fe200000000ffULL,
0x000000174848b232ULL, 0x088fe20000000000ULL, 0x0000312023237816ULL, 0x000fe200000000ffULL,
0x000000174a4ab232ULL, 0x000fe20000000000ULL, 0x0000b80070207811ULL, 0x000fe200078e20ffULL,
0x000000184949b232ULL, 0x080fe20000000000ULL, 0x00000021ff27723eULL, 0x080fe200020006ffULL,
0x000000184b4bb232ULL, 0x000fe20000000000ULL, 0x00000021ff29723eULL, 0x000fc400030006ffULL,
0x00000022ff30723eULL, 0x080fe400020006ffULL, 0x00000023ff31723eULL, 0x080fe400020006ffULL,
0x00000022ff34723eULL, 0x000fe200030006ffULL, 0x000000264824723cULL, 0x000f6200000018ffULL,
0x00000023ff35723eULL, 0x000fe400030006ffULL, 0x000000002020783bULL, 0x000e620000000200ULL,
0x000031203c3c7816ULL, 0x000fe400000000ffULL, 0x000031203d3d7816ULL, 0x000fc400000000ffULL,
0x000031203e687816ULL, 0x000fe200000000ffULL, 0x000000284828723cULL, 0x040f6200000018ffULL,
0x000031203f697816ULL, 0x000fe400000000ffULL, 0x0000003cff38723eULL, 0x080fe400020006ffULL,
0x0000003dff39723eULL, 0x080fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fe200030006ffULL,
0x000000304830723cULL, 0x000f6200000018ffULL, 0x0000003dff3d723eULL, 0x000fc400030006ffULL,
0x00000068ff40723eULL, 0x080fe400020006ffULL, 0x00000069ff41723eULL, 0x080fe400020006ffULL,
0x00000068ff68723eULL, 0x000fe200030006ffULL, 0x000000344834723cULL, 0x000f6200000018ffULL,
0x00000069ff69723eULL, 0x000fe400030006ffULL, 0x000031202e2e7816ULL, 0x010fe400000000ffULL,
0x000031202f2f7816ULL, 0x000fc400000000ffULL, 0x0000312044447816ULL, 0x000fe200000000ffULL,
0x000000384838723cULL, 0x000f6200000018ffULL, 0x0000312045457816ULL, 0x000fe400000000ffULL,
0x0000312046467816ULL, 0x000fe400000000ffULL, 0x0000312047477816ULL, 0x000fc600000000ffULL,
0x0000003c483c723cULL, 0x000f6200000018ffULL, 0x000000172020b232ULL, 0x082fe40000000000ULL,
0x000000172222b232ULL, 0x000fe40000000000ULL, 0x000000182121b232ULL, 0x000fc60000000000ULL,
0x000000404840723cULL, 0x000f6200000018ffULL, 0x000000182323b232ULL, 0x000fce0000000000ULL,
0x000000684848723cULL, 0x000b6e00000018ffULL, 0x000031202c687816ULL, 0x020fe400000000ffULL,
0x000031202d697816ULL, 0x000fe400000000ffULL, 0x00000068ff2c723eULL, 0x000fc400020006ffULL,
0x00000069ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2024723cULL, 0x000b6e0000001824ULL,
0x00000068ff2c723eULL, 0x020fe400030006ffULL, 0x00000069ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2028723cULL, 0x000b6e0000001828ULL, 0x0000002eff2c723eULL, 0x020fe400020006ffULL,
0x0000002fff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2030723cULL, 0x000b6e0000001830ULL,
0x0000002eff2c723eULL, 0x020fe400030006ffULL, 0x0000002fff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2034723cULL, 0x000b6e0000001834ULL, 0x00000044ff2c723eULL, 0x020fe400020006ffULL,
0x00000045ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2038723cULL, 0x000b6e0000001838ULL,
0x00000044ff2c723eULL, 0x020fe400030006ffULL, 0x00000045ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c203c723cULL, 0x000b6e000000183cULL, 0x00000046ff2c723eULL, 0x020fe400020006ffULL,
0x00000047ff2d723eULL, 0x000fce00020006ffULL, 0x0000002c2040723cULL, 0x000b6e0000001840ULL,
0x00000046ff2c723eULL, 0x020fe400030006ffULL, 0x00000047ff2d723eULL, 0x000fce00030006ffULL,
0x0000002c2048723cULL, 0x000b620000001848ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000010000002947ULL, 0x000fde0003000000ULL, 0x000000240b0b7221ULL, 0x000fe20000010000ULL,
0x000000250a0a7221ULL, 0x000fe20000010000ULL, 0x0000002807077221ULL, 0x000fe20000010000ULL,
0x0000002906067221ULL, 0x000fe20000010000ULL, 0x000000301f1f7221ULL, 0x000fe20000010000ULL,
0x000000311e1e7221ULL, 0x000fe20000010000ULL, 0x000000344f4f7221ULL, 0x000fe20000010000ULL,
0x000000354e4e7221ULL, 0x000fe20000010000ULL, 0x0000003853537221ULL, 0x000fe20000010000ULL,
0x0000003952527221ULL, 0x000fe20000010000ULL, 0x0000003c57577221ULL, 0x000fe20000010000ULL,
0x0000003d56567221ULL, 0x000fe20000010000ULL, 0x000000405b5b7221ULL, 0x000fe20000010000ULL,
0x000000415a5a7221ULL, 0x000fe20000010000ULL, 0x000000485f5f7221ULL, 0x020fe20000010000ULL,
0x000000495e5e7221ULL, 0x000fc40000010000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000012000017945ULL, 0x000fe20003800000ULL, 0x0000010000001947ULL, 0x000fea0000000000ULL,
0x0000002609097221ULL, 0x000fe20000010000ULL, 0x0000002708087221ULL, 0x000fe20000010000ULL,
0x0000002a05057221ULL, 0x000fe20000010000ULL, 0x0000002b04047221ULL, 0x000fe20000010000ULL,
0x000000324d4d7221ULL, 0x000fe20000010000ULL, 0x000000334c4c7221ULL, 0x000fe20000010000ULL,
0x0000003651517221ULL, 0x000fe20000010000ULL, 0x0000003750507221ULL, 0x000fe20000010000ULL,
0x0000003a55557221ULL, 0x000fe20000010000ULL, 0x0000003b54547221ULL, 0x000fe20000010000ULL,
0x0000003e59597221ULL, 0x000fe20000010000ULL, 0x0000003f58587221ULL, 0x000fe20000010000ULL,
0x000000425d5d7221ULL, 0x000fe20000010000ULL, 0x000000435c5c7221ULL, 0x000fe20000010000ULL,
0x0000004a61617221ULL, 0x020fe20000010000ULL, 0x0000004b60607221ULL, 0x000fc40000010000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000174747810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000737400720cULL, 0x000fe20003f06070ULL,
0x010b8800ff267f8cULL, 0x000e58000c80043fULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffbcf000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010b7000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000000110107810ULL, 0x000fc80007ffe0ffULL,
0x000000651000720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xfffeed7000007947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6500720cULL, 0x000fe20003f05270ULL, 0x000000ffff127224ULL, 0x000fe400078e0004ULL,
0x000000ffff117224ULL, 0x000fe400078e0005ULL, 0x000000ffff107224ULL, 0x000fe400078e0008ULL,
0x000000ffff0f7224ULL, 0x000fcc00078e0009ULL, 0x0000039000008947ULL, 0x000fea0003800000ULL,
0x018000000c027810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x00012ff000057802ULL, 0x000fc40000000f00ULL,
0x00006e5000007944ULL, 0x022fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000c00037308ULL, 0x000ea40000001000ULL, 0xbf80000003027423ULL, 0x004fc8000000000cULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203047223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006f00ff037624ULL, 0x000fe400078e00ffULL,
0x00006e00ff027624ULL, 0x000fca00078e00ffULL, 0x0000001002037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff277819ULL, 0x00afe20000011605ULL,
0x0000000403047220ULL, 0x004fe20000410000ULL, 0x00006a027f007947ULL, 0x000fea000b800000ULL,
0x00001f2704027589ULL, 0x0002a400000e0000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x0000000b020b7220ULL, 0x044fe20000410000ULL, 0x0000000a020a7220ULL, 0x040fe20000410000ULL,
0x0000000702077220ULL, 0x040fe20000410000ULL, 0x0000000602067220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000004f024f7220ULL, 0x040fe20000410000ULL, 0x0000004e024e7220ULL, 0x040fe20000410000ULL,
0x0000005302537220ULL, 0x040fe20000410000ULL, 0x0000005202527220ULL, 0x040fe20000410000ULL,
0x0000005702577220ULL, 0x040fe20000410000ULL, 0x0000005602567220ULL, 0x040fe20000410000ULL,
0x0000005b025b7220ULL, 0x040fe20000410000ULL, 0x0000005a025a7220ULL, 0x040fe20000410000ULL,
0x0000005f025f7220ULL, 0x040fe20000410000ULL, 0x0000005e025e7220ULL, 0x000fe20000410000ULL,
0x0000000803277811ULL, 0x00afe200078ff0ffULL, 0x000069127f007947ULL, 0x000fea000b800000ULL,
0x00001f2704027589ULL, 0x0002a400000e0000ULL, 0x0000000f020f7220ULL, 0x044fe20000410000ULL,
0x0000001002107220ULL, 0x040fe20000410000ULL, 0x0000001102117220ULL, 0x040fe20000410000ULL,
0x0000001202127220ULL, 0x040fe20000410000ULL, 0x0000004d024d7220ULL, 0x040fe20000410000ULL,
0x0000004c024c7220ULL, 0x040fe20000410000ULL, 0x0000005102517220ULL, 0x040fe20000410000ULL,
0x0000005002507220ULL, 0x040fe20000410000ULL, 0x0000005502557220ULL, 0x040fe20000410000ULL,
0x0000005402547220ULL, 0x040fe20000410000ULL, 0x0000005902597220ULL, 0x040fe20000410000ULL,
0x0000005802587220ULL, 0x040fe20000410000ULL, 0x0000005d025d7220ULL, 0x040fe20000410000ULL,
0x0000005c025c7220ULL, 0x040fe20000410000ULL, 0x0000006102617220ULL, 0x040fe20000410000ULL,
0x0000006002607220ULL, 0x000fc20000410000ULL, 0x0000000000217919ULL, 0x020ea20000002600ULL,
0x0000000b0a02723eULL, 0x000fe200000000ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000070603723eULL, 0x000fc400000000ffULL, 0x0000000f100a723eULL, 0x000fe400000000ffULL,
0x00000011120b723eULL, 0x000fe400000000ffULL, 0x0000001f1e04723eULL, 0x002fe400000000ffULL,
0x0000004f4e05723eULL, 0x000fe400000000ffULL, 0x000000535206723eULL, 0x000fe400000000ffULL,
0x000000575607723eULL, 0x000fc400000000ffULL, 0x0000005b5a08723eULL, 0x000fe400000000ffULL,
0x0000005f5e09723eULL, 0x000fe400000000ffULL, 0x0000004d4c0c723eULL, 0x000fe400000000ffULL,
0x00000051500d723eULL, 0x000fe400000000ffULL, 0x00000055540e723eULL, 0x000fe400000000ffULL,
0x00000059580f723eULL, 0x000fc400000000ffULL, 0x0000005d5c10723eULL, 0x000fe400000000ffULL,
0x000000616011723eULL, 0x000fc400000000ffULL, 0x0000000000157919ULL, 0x004e620000000000ULL,
0x0000a00008087891ULL, 0x000fe2000f8e583fULL, 0x00005410021a7816ULL, 0x000fe40000000003ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000815137811ULL, 0x002fc400078ff0ffULL,
0x0000000215127812ULL, 0x000fc600078ec0ffULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x0000001312147211ULL, 0x040fe200078ff8ffULL, 0x0000000815137824ULL, 0x000fe200078e00ffULL,
0x00000002ff157819ULL, 0x000fe40000011615ULL, 0xfffffff817177812ULL, 0x000fe400078ee214ULL,
0x0000000813147812ULL, 0x000fe200078ec0ffULL, 0x0000000815137824ULL, 0x040fe200078e00ffULL,
0x0000001512127211ULL, 0x000fe200078ff8ffULL, 0x0000000815187824ULL, 0x000fc400078e00ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000000212157810ULL, 0x040fe40007ffe0ffULL,
0x0000000412167810ULL, 0x040fe40007ffe0ffULL, 0x0000000612127810ULL, 0x000fe40007ffe0ffULL,
0x0000000813137c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff818157812ULL, 0x000fc400078ee215ULL,
0xfffffff819167812ULL, 0x000fe200078ee216ULL, 0x0000000113137824ULL, 0x000fe200078e0214ULL,
0xfffffff81b127812ULL, 0x000fe400078ee212ULL, 0x00007632021b7816ULL, 0x000fe40000000003ULL,
0x0000000815157c11ULL, 0x000fe4000f8e20ffULL, 0x0000000816037c11ULL, 0x000fe2000f8e20ffULL,
0x0000001a13007388ULL, 0x0003e20000000a00ULL, 0x0000000817197c11ULL, 0x000fe2000f8e20ffULL,
0x0000000114157824ULL, 0x000fe200078e0215ULL, 0x0000000812177c11ULL, 0x000fe2000f8e20ffULL,
0x0000000114037824ULL, 0x000fe200078e0203ULL, 0x0000541004127816ULL, 0x000fe20000000005ULL,
0x0000000114197824ULL, 0x000fc400078e0219ULL, 0x0000000114177824ULL, 0x000fe200078e0217ULL,
0x0000763204137816ULL, 0x002fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000001215007388ULL, 0x000fe20000000a00ULL,
0x000054100a067816ULL, 0x140fe4000000000bULL, 0x000076320a077816ULL, 0x000fe2000000000bULL,
0x0000000403007388ULL, 0x0003e40000000a00ULL, 0x0000541008047816ULL, 0x002fc40000000009ULL,
0x0000763208057816ULL, 0x000fca0000000009ULL, 0x0000000417007388ULL, 0x0003e80000000a00ULL,
0x0000000619007388ULL, 0x0005e20000000a00ULL, 0x000054100c047816ULL, 0x142fe4000000000dULL,
0x000076320c057816ULL, 0x000fe4000000000dULL, 0x000054100e067816ULL, 0x144fe4000000000fULL,
0x000076320e077816ULL, 0x000fe2000000000fULL, 0x0004000415007388ULL, 0x0003e80000000a00ULL,
0x0004000603007388ULL, 0x0005e20000000a00ULL, 0x0000541010047816ULL, 0x002fc40000000011ULL,
0x0000763210057816ULL, 0x000fca0000000011ULL, 0x0004000417007388ULL, 0x0005e20000000a00ULL,
0x0000002000007947ULL, 0x000fea0003800000ULL, 0x000137f0001c7802ULL, 0x000fc40000000f00ULL,
0x000068c000007944ULL, 0x004fea0003c00000ULL, 0x0000000000097919ULL, 0x000e620000000000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x00000005ff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000004130472a4ULL, 0x000fcc000f8e023fULL,
0x00000004ff037e24ULL, 0x004fe2000f8e00ffULL, 0x00000003ff007819ULL, 0x002fca0000011609ULL,
0x0000000100027824ULL, 0x040fe400078e0209ULL, 0x0000580000007a24ULL, 0x000fc600078e0221ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000003007211ULL, 0x000fe400078010ffULL,
0x0ffffff802047812ULL, 0x000fe400078ef809ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe400078048ffULL,
0x0000000804047984ULL, 0x000e62000800cc00ULL, 0x1ffffff809097812ULL, 0x000fc400078ef808ULL,
0x00005b0000037a11ULL, 0x000fca00000f4c03ULL, 0x0000001009027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d10ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000608057899ULL, 0x000fe2000800063fULL, 0x000000200d047810ULL, 0x000fca0007ffe0ffULL,
0x000000050d037c10ULL, 0x000fe2000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000680000047ab9ULL, 0x000fe20000000800ULL, 0x0000000504057c10ULL, 0x040fe2000fffe0ffULL,
0x000000040a0472a4ULL, 0x000fe2000f8e0205ULL, 0x000000660300720cULL, 0x080fe20003f06070ULL,
0x0000000808067899ULL, 0x000fe2000800063fULL, 0x000000660500720cULL, 0x000fe20003f26070ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x010ad000ff087f8cULL, 0x000e62000c80043fULL,
0x000000040d027c10ULL, 0x040fe2000fffe0ffULL, 0x000001a000007945ULL, 0x000fe20003800000ULL,
0x0000000404047c10ULL, 0x000fe2000fffe0ffULL, 0x000000013f047899ULL, 0x000fe20008011608ULL,
0x000000060d0b7c11ULL, 0x040fe2000f8e10ffULL, 0x0000660002027625ULL, 0x000fe200078e000fULL,
0x000000030d00780cULL, 0x000fc60003f44070ULL, 0x0000660004047625ULL, 0x000fe200078e000fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x10600000020b7faeULL, 0x0005e6000c121850ULL,
0x00000004ff597e24ULL, 0x000fe2000f8e00ffULL, 0x10680000040b7faeULL, 0x0005e2000c921850ULL,
0x00006e00ff067624ULL, 0x000fe400078e00ffULL, 0x00006f00ff077624ULL, 0x000fe400078e00ffULL,
0x000000a000002947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x004ea20000002700ULL,
0x00000008ff047e24ULL, 0x000fe2000f8e00ffULL, 0x000000645900720cULL, 0x000fc60003f06070ULL,
0x0000000404057824ULL, 0x000fca00078e020dULL, 0x00010a8005057811ULL, 0x000fe200078e10ffULL,
0x0000000402027824ULL, 0x004fc800078e020dULL, 0x0000000202027824ULL, 0x000fc800078e00ffULL,
0x0000640002027a24ULL, 0x000fc800078e0259ULL, 0x0000600002027625ULL, 0x000fca00078e000fULL,
0x0000000002057faeULL, 0x0005e4000c121850ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x000000070d0d7899ULL, 0x000fe2000800063fULL,
0x0000001006027981ULL, 0x004528000c1e9900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x000000400d077892ULL, 0x000fe4000f8ef805ULL,
0x0000000704047899ULL, 0x000fe2000800063fULL, 0x000000ffff037224ULL, 0x002fe200078e0009ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000008a000000947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x004e620000000000ULL,
0x00010a8008097891ULL, 0x000fe2000f8e203fULL, 0x0000000566047c17ULL, 0x000fe2000f800000ULL,
0x00000100ff0e7424ULL, 0x000fe200078e00ffULL, 0x00002000080b7891ULL, 0x000fe4000f8e683fULL,
0x80000005040a7c10ULL, 0x000fe4000fffe0ffULL, 0x00000002ff117819ULL, 0x002fe20000011608ULL,
0x00000010080f7824ULL, 0x000fc600078e00ffULL, 0x0000000711067c10ULL, 0x000fe2000fffe0ffULL,
0x0106000611077984ULL, 0x000e620008004800ULL, 0x000000300f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000a1100720cULL, 0x040fe40003f06070ULL, 0x0000000811097810ULL, 0x000fca0007ffe0ffULL,
0x0000000409107824ULL, 0x000fe200078e00ffULL, 0x0000000907077984ULL, 0x002e640008004800ULL,
0x0000000407057c24ULL, 0x002fe2000f8e0206ULL, 0x0000000808067211ULL, 0x000fc600078fe8ffULL,
0x00005e0005047625ULL, 0x000fe200078e000eULL, 0x00000003060b7812ULL, 0x000fc800078ec0ffULL,
0x0000000f04067210ULL, 0x000fe40007f3e0ffULL, 0x0ffffffc0b047812ULL, 0x000fc600078ef808ULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000709057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0900720cULL, 0x000fc60003f06070ULL,
0x01062006110c7984ULL, 0x000ea20008004800ULL, 0x0000001011077810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee20bULL, 0x0000000407107824ULL, 0x040fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000707057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0700720cULL, 0x000fc60003f06070ULL,
0x01064006110c7984ULL, 0x000ea20008004800ULL, 0x0000001811097810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee20bULL, 0x0000000409107824ULL, 0x040fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000709057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0900720cULL, 0x000fc60003f06070ULL,
0x01066006110c7984ULL, 0x000ea20008004800ULL, 0x0000002011077810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee20bULL, 0x0000000407107824ULL, 0x040fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000707057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0700720cULL, 0x000fc60003f06070ULL,
0x01068006110c7984ULL, 0x000ea20008004800ULL, 0x0000002811097810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee20bULL, 0x0000000409107824ULL, 0x040fe400078e00ffULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000709057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0900720cULL, 0x000fc60003f06070ULL,
0x0106a006110c7984ULL, 0x000ea20008004800ULL, 0x0000003011077810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04087210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee20bULL, 0x0000000407107824ULL, 0x040fe400078e00ffULL,
0x000000ffff097224ULL, 0x000fe200008e0605ULL, 0x0000000b040d7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000707057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c101c50ULL, 0x0000000a0700720cULL, 0x000fc60003f06070ULL,
0x0106c006110c7984ULL, 0x000ea20008004800ULL, 0x00000038110d7810ULL, 0x002fc60007ffe0ffULL,
0x000000090c0c7984ULL, 0x004e640008004800ULL, 0x000000040c057c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0005047625ULL, 0x000fca00078e000eULL, 0x0000000f04067210ULL, 0x000fe40007f3e0ffULL,
0xfffffffc10047812ULL, 0x000fc600078ee20bULL, 0x000000ffff077224ULL, 0x000fe200008e0605ULL,
0x0000000b04097c11ULL, 0x000fe4000f8e20ffULL, 0x000000070d057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c50ULL,
0x0000000a0d00720cULL, 0x040fe20003f06070ULL, 0x000000040d0a7824ULL, 0x000fe400078e00ffULL,
0x0106e00611087984ULL, 0x000ea60008004800ULL, 0xfffffffc0a0b7812ULL, 0x000fc800078ee20bULL,
0x0000000b0b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000908087984ULL, 0x004ea40008004800ULL,
0x0000000408057c24ULL, 0x004fc8000f8e0205ULL, 0x00005e0005047625ULL, 0x000fca00078e000eULL,
0x0000000f04047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000c101c50ULL,
0x000007f000007947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x004e620000000000ULL,
0x00010a8008097891ULL, 0x000fe2000f8e203fULL, 0x00000100ff0d7424ULL, 0x000fe200078e00ffULL,
0x00002000080b7891ULL, 0x000fe2000f8e683fULL, 0x00000002ff0b7819ULL, 0x002fe20000011607ULL,
0x0000001007097824ULL, 0x040fe200078e00ffULL, 0x0000000707067211ULL, 0x000fe400078fe8ffULL,
0x000000070b057c10ULL, 0x000fe2000fffe0ffULL, 0x010600060b087984ULL, 0x000e620008004800ULL,
0x00000030090f7812ULL, 0x000fc400078ec0ffULL, 0x00000003060c7812ULL, 0x000fe200078ec0ffULL,
0x0000000908087984ULL, 0x002e640008004800ULL, 0x0000000408047c24ULL, 0x002fe2000f8e0205ULL,
0x000000080b087810ULL, 0x000fc60007ffe0ffULL, 0x00005e0004047625ULL, 0x000fc800078e000dULL,
0x0000000408097824ULL, 0x000fe200078e00ffULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0x0ffffffc0c047812ULL, 0x000fc600078ef807ULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000b901c50ULL,
0x010620060b0a7984ULL, 0x000ea20008004800ULL, 0x000000100b067810ULL, 0x002fca0007ffe0ffULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x000000090a0a7984ULL, 0x004e640008004800ULL,
0x000000040a047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000706057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e8000b901c50ULL, 0x010640060b0a7984ULL, 0x000ea20008004800ULL,
0x000000180b087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc07047812ULL, 0x000fc600078ee20cULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000b901c50ULL,
0x010660060b0a7984ULL, 0x000ea20008004800ULL, 0x000000200b067810ULL, 0x002fca0007ffe0ffULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x000000090a0a7984ULL, 0x004e640008004800ULL,
0x000000040a047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000706057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e8000b901c50ULL, 0x010680060b0a7984ULL, 0x000ea20008004800ULL,
0x000000280b087810ULL, 0x002fca0007ffe0ffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x000000090a0a7984ULL, 0x004e640008004800ULL, 0x000000040a047c24ULL, 0x002fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fca00078e000dULL, 0x0000000f04067210ULL, 0x000fe40007f1e0ffULL,
0xfffffffc07047812ULL, 0x000fc600078ee20cULL, 0x000000ffff077224ULL, 0x000fe200000e0605ULL,
0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL, 0x0000000708057c10ULL, 0x000fc6000fffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000b901c50ULL,
0x0106a0060b0a7984ULL, 0x000ea20008004800ULL, 0x000000300b067810ULL, 0x002fca0007ffe0ffULL,
0x0000000406077824ULL, 0x000fe200078e00ffULL, 0x000000090a0a7984ULL, 0x004e640008004800ULL,
0x000000040a047c24ULL, 0x002fc8000f8e0205ULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc09047812ULL, 0x000fc600078ee20cULL,
0x000000ffff097224ULL, 0x000fe200000e0605ULL, 0x0000000b04117c11ULL, 0x000fe4000f8e20ffULL,
0x0000000706057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e8000b901c50ULL, 0x0106c0060b0a7984ULL, 0x000ea80008004800ULL,
0x000000090a0a7984ULL, 0x004ea40008004800ULL, 0x000000040a047c24ULL, 0x004fe2000f8e0205ULL,
0x000000380b0a7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0004047625ULL, 0x000fca00078e000dULL,
0x0000000f04067210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc07047812ULL, 0x000fc600078ee20cULL,
0x000000ffff077224ULL, 0x000fe200000e0605ULL, 0x0000000b04097c11ULL, 0x002fe4000f8e20ffULL,
0x000000070a057c10ULL, 0x000fc6000fffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e8000b901c50ULL, 0x0106e0060b087984ULL, 0x000ea80008004800ULL,
0x0000000908087984ULL, 0x004ea40008004800ULL, 0x0000000408047c24ULL, 0x004fc8000f8e0205ULL,
0x00005e0004047625ULL, 0x000fc800078e000dULL, 0x000000040a0d7824ULL, 0x000fe200078e00ffULL,
0x0000000f04047210ULL, 0x000fc80007f1e0ffULL, 0xfffffffc0d0c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff057224ULL, 0x000fc600000e0605ULL, 0x0000000b0c077c11ULL, 0x002fca000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e4000b901c50ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x010ad400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010ad400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00000008ff047e24ULL, 0x000fc8000f8e00ffULL, 0x0000002004037824ULL, 0x002fca00078e0203ULL,
0x00000003ff057819ULL, 0x000fe40000011603ULL, 0x0000000f03037812ULL, 0x000fe400078ec0ffULL,
0x1ffffffe05067812ULL, 0x000fe400078ec0ffULL, 0x0000000103057810ULL, 0x040fe20007ffe0ffULL,
0x0000002003097824ULL, 0x040fe400078e00ffULL, 0x0000000103077824ULL, 0x040fe400078e0206ULL,
0x0000000106087824ULL, 0x040fe200078e0205ULL, 0x0000001006067810ULL, 0x000fe20007ffe0ffULL,
0x00000020030a7824ULL, 0x000fe200078e00ffULL, 0x0000001f07077812ULL, 0x000fc400078ec0ffULL,
0x0000001f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0206ULL,
0x000001e00a077812ULL, 0x040fe400078ee207ULL, 0x000001e009087812ULL, 0x000fe200078ee208ULL,
0x0000000103097824ULL, 0x000fe200078e0206ULL, 0x0000001f05057812ULL, 0x000fe200078ec0ffULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000002003067824ULL, 0x000fe400078e00ffULL,
0x0000001f09097812ULL, 0x000fe200078ec0ffULL, 0x00000000080c7984ULL, 0x000ea2000000cc00ULL,
0x000001e00a057812ULL, 0x000fc400078ee205ULL, 0x000001e006097812ULL, 0x000fe200078ee209ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff187224ULL, 0x000fc400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x0000001808007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000009107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c09007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010ad000ff067f8cULL, 0x000ea2000c80043fULL, 0x000000ffff057224ULL, 0x002fc400078e00ffULL,
0x000000ffff0a7224ULL, 0x004fc400078e0007ULL, 0x0000000000067805ULL, 0x000fca0000015200ULL,
0x010ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x010ad400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00005800ff087624ULL, 0x000fe200078e00ffULL, 0x3d80000002027820ULL, 0x010fe20000410000ULL,
0x00010b5804567811ULL, 0x000fe200078e18ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0xffffffff65577810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087824ULL, 0x000fe200078e00ffULL,
0x00010ad804057811ULL, 0x000fc600078e28ffULL, 0x00000005065f7c11ULL, 0x000fe2000f8e40ffULL,
0x0000000000007946ULL, 0x000fe60003800000ULL, 0x0000005f6600720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000004ff627424ULL, 0x000fe200078e00ffULL,
0x000000066300720cULL, 0x000fe20003f44070ULL, 0x000000ffff677224ULL, 0x000fc600078e00ffULL,
0x0000000162627807ULL, 0x000fc40005000000ULL, 0x000000ffff197224ULL, 0x000fe200078e0007ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff617224ULL, 0x000fe200078e0067ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000ffff607224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x000080000000791aULL, 0x000fc80000000000ULL, 0x000000237f007947ULL, 0x000fea000b800000ULL,
0x000157a0001c7802ULL, 0x000fc40000000f00ULL, 0x0000491000007944ULL, 0x002fea0003c00000ULL,
0x00000001605e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000675e077211ULL, 0x040fe200078ff0ffULL, 0x0000106000007945ULL, 0x000fe20003800000ULL,
0x000000035e5c7812ULL, 0x000fe400078ec0ffULL, 0x00000003071a7812ULL, 0x000fe400078ec0ffULL,
0x00000002ff07a819ULL, 0x000fe40000011607ULL, 0x000000ff1a1a7207ULL, 0x000fc60005000000ULL,
0x0000000107187824ULL, 0x000fe200078e0206ULL, 0x0000000119077812ULL, 0x000fc800078e0cffULL,
0x00000001181c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000518207c11ULL, 0x000fe4000f8e40ffULL,
0x000000651c00720cULL, 0x000fe40003f06070ULL, 0x00000040201b7812ULL, 0x000fc800078ec0ffULL,
0x0000000d1b1b7c10ULL, 0x000fce000fffe0ffULL, 0x0000082000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x002fe20000011603ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x00000020661d7217ULL, 0x000fe20007800000ULL, 0x000000045c407824ULL, 0x000fe200078e00ffULL,
0x0000000303227211ULL, 0x000fe200078fe8ffULL, 0x010600061e1f7984ULL, 0x000e620008004800ULL,
0x000000011e1c7824ULL, 0x040fe200078e021bULL, 0x000000081e687810ULL, 0x000fe20007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0a20ULL, 0x0000000322227812ULL, 0x000fe200078ec0ffULL,
0x0000000204217824ULL, 0x000fc400078e0207ULL, 0x00000100ff237424ULL, 0x000fe200078e00ffULL,
0x0000001d1e00720cULL, 0x000fe20003f06070ULL, 0x00000004685d7824ULL, 0x000fe200078e00ffULL,
0x000000041f1f7984ULL, 0x002e640008004800ULL, 0x0000001f08207224ULL, 0x002fe200078e021cULL,
0xfffffffc401c7812ULL, 0x100fe400078ee203ULL, 0x00002000211f7811ULL, 0x000fe200078e60ffULL,
0x00005e0020207625ULL, 0x000fe200078e0023ULL, 0x0ffffffc22407812ULL, 0x000fca00078ef803ULL,
0x0000001040437824ULL, 0x000fe400078e021fULL, 0x000000101c407825ULL, 0x000fc800078e0020ULL,
0x0000000168207824ULL, 0x040fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e2000c101c50ULL, 0x0000001d6800720cULL, 0x000fe40003f06070ULL,
0xfffffffc5d687812ULL, 0x000fe200078ee222ULL, 0x010620061e427984ULL, 0x000ea80008004800ULL,
0x00000010685d7824ULL, 0x000fe200078e021fULL, 0x000000101e687810ULL, 0x000fca0007ffe0ffULL,
0x0000000468437824ULL, 0x002fe200078e00ffULL, 0x0000000442217984ULL, 0x004e640008004800ULL,
0x0000002108207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e0023ULL,
0x000000101c407825ULL, 0x000fc800078e0020ULL, 0x0000000168207824ULL, 0x040fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000405d7faeULL, 0x0003e2000c101c50ULL,
0x0000001d6800720cULL, 0x000fe40003f06070ULL, 0xfffffffc43687812ULL, 0x000fe200078ee222ULL,
0x010640061e427984ULL, 0x000ea80008004800ULL, 0x0000001068437824ULL, 0x000fe200078e021fULL,
0x000000181e687810ULL, 0x000fca0007ffe0ffULL, 0x00000004685d7824ULL, 0x002fe200078e00ffULL,
0x0000000442217984ULL, 0x004e640008004800ULL, 0x0000002108207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fcc00078e0023ULL, 0x000000101c407825ULL, 0x000fc800078e0020ULL,
0x0000000168207824ULL, 0x040fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e2000c101c50ULL, 0x0000001d6800720cULL, 0x000fe40003f06070ULL,
0xfffffffc5d687812ULL, 0x000fe200078ee222ULL, 0x010660061e427984ULL, 0x000ea80008004800ULL,
0x00000010685d7824ULL, 0x000fe200078e021fULL, 0x000000201e687810ULL, 0x000fca0007ffe0ffULL,
0x0000000468437824ULL, 0x002fe200078e00ffULL, 0x0000000442217984ULL, 0x004e640008004800ULL,
0x0000002108207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e0023ULL,
0x000000101c407825ULL, 0x000fc800078e0020ULL, 0x0000000168207824ULL, 0x040fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000405d7faeULL, 0x0003e2000c101c50ULL,
0x0000001d6800720cULL, 0x000fe40003f06070ULL, 0xfffffffc43687812ULL, 0x000fe200078ee222ULL,
0x010680061e427984ULL, 0x000ea80008004800ULL, 0x0000001068437824ULL, 0x000fe200078e021fULL,
0x000000281e687810ULL, 0x000fca0007ffe0ffULL, 0x00000004685d7824ULL, 0x002fe200078e00ffULL,
0x0000000442217984ULL, 0x004e640008004800ULL, 0x0000002108207224ULL, 0x002fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fcc00078e0023ULL, 0x000000101c407825ULL, 0x000fc800078e0020ULL,
0x0000000168207824ULL, 0x040fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000040437faeULL, 0x0003e2000c101c50ULL, 0x0000001d6800720cULL, 0x000fe40003f06070ULL,
0xfffffffc5d687812ULL, 0x000fe200078ee222ULL, 0x0106a0061e427984ULL, 0x000ea80008004800ULL,
0x00000010685d7824ULL, 0x000fe200078e021fULL, 0x000000301e687810ULL, 0x000fca0007ffe0ffULL,
0x0000000468437824ULL, 0x002fe200078e00ffULL, 0x0000000442217984ULL, 0x004e640008004800ULL,
0x0000002108207224ULL, 0x002fc800078e0220ULL, 0x00005e0020207625ULL, 0x000fcc00078e0023ULL,
0x000000101c407825ULL, 0x000fc800078e0020ULL, 0x0000000168207824ULL, 0x040fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000405d7faeULL, 0x0003e2000c101c50ULL,
0x0000001d6800720cULL, 0x000fe40003f06070ULL, 0xfffffffc43687812ULL, 0x000fe200078ee222ULL,
0x0106c0061e427984ULL, 0x000ea80008004800ULL, 0x0000001068437824ULL, 0x000fe200078e021fULL,
0x000000381e687810ULL, 0x000fca0007ffe0ffULL, 0x00000001681b7824ULL, 0x000fe200078e021bULL,
0x0000000442217984ULL, 0x004ea40008004800ULL, 0x0000002108207224ULL, 0x004fc800078e0220ULL,
0x00005e0020207625ULL, 0x000fcc00078e0023ULL, 0x000000101c207825ULL, 0x000fca00078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020437faeULL, 0x0005e2000c101c50ULL,
0x0000001d6800720cULL, 0x000fc60003f06070ULL, 0x0106e0061e427984ULL, 0x000e680008004800ULL,
0x0000000442417984ULL, 0x002e640008004800ULL, 0x0000004108407224ULL, 0x002fe400078e021bULL,
0x00000004681b7824ULL, 0x000fe400078e00ffULL, 0x00005e0040407625ULL, 0x000fc600078e0023ULL,
0xfffffffc1b227812ULL, 0x000fc600078ee222ULL, 0x000000101c407825ULL, 0x000fc800078e0040ULL,
0x00000010221f7824ULL, 0x000fca00078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000401f7faeULL, 0x0005e2000c101c50ULL, 0x0000077000007947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x002fe20000011603ULL, 0x00010a8008047891ULL, 0x000fe2000f8e203fULL,
0x0000000303207211ULL, 0x000fe200078fe8ffULL, 0x000000045c227824ULL, 0x000fe400078e00ffULL,
0x010600061e217984ULL, 0x000e620008004800ULL, 0x000000011e237824ULL, 0x000fe200078e021bULL,
0x0000000320207812ULL, 0x000fe200078ec0ffULL, 0x00000002041f7824ULL, 0x000fe200078e0207ULL,
0xfffffffc221d7812ULL, 0x100fe200078ee203ULL, 0x00000100ff1c7424ULL, 0x000fe200078e00ffULL,
0x0ffffffc20407812ULL, 0x000fc400078ef803ULL, 0x000020001f1f7811ULL, 0x000fca00078e60ffULL,
0x00000010405d7824ULL, 0x000fe200078e021fULL, 0x0000000421217984ULL, 0x002e640008004800ULL,
0x0000002108237224ULL, 0x002fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d407825ULL, 0x000fe200078e0022ULL, 0x000000081e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000405d7faeULL, 0x0003e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422437824ULL, 0x000fe200078e00ffULL,
0x010620061e217984ULL, 0x000ea80008004800ULL, 0xfffffffc43427812ULL, 0x000fca00078ee220ULL,
0x0000001042697824ULL, 0x000fe200078e021fULL, 0x0000000421217984ULL, 0x004ea40008004800ULL,
0x0000002108237224ULL, 0x004fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d427825ULL, 0x000fe200078e0022ULL, 0x000000101e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042697faeULL, 0x0005e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422217824ULL, 0x000fe200078e00ffULL,
0x010640061e5d7984ULL, 0x002e680008004800ULL, 0xfffffffc21407812ULL, 0x000fca00078ee220ULL,
0x00000010406b7824ULL, 0x000fe200078e021fULL, 0x000000045d5d7984ULL, 0x002e640008004800ULL,
0x0000005d08237224ULL, 0x002fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d407825ULL, 0x000fe200078e0022ULL, 0x000000181e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000406b7faeULL, 0x0003e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422437824ULL, 0x004fe200078e00ffULL,
0x010660061e217984ULL, 0x000ea80008004800ULL, 0xfffffffc43427812ULL, 0x000fca00078ee220ULL,
0x0000001042697824ULL, 0x000fe200078e021fULL, 0x0000000421217984ULL, 0x004ea40008004800ULL,
0x0000002108237224ULL, 0x004fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d427825ULL, 0x000fe200078e0022ULL, 0x000000201e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042697faeULL, 0x0005e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422217824ULL, 0x000fe200078e00ffULL,
0x010680061e5d7984ULL, 0x000ee80008004800ULL, 0xfffffffc21407812ULL, 0x002fca00078ee220ULL,
0x00000010406b7824ULL, 0x000fe200078e021fULL, 0x000000045d5d7984ULL, 0x008e640008004800ULL,
0x0000005d08237224ULL, 0x002fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d407825ULL, 0x000fe200078e0022ULL, 0x000000281e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000406b7faeULL, 0x0003e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422437824ULL, 0x004fe200078e00ffULL,
0x0106a0061e217984ULL, 0x000ea80008004800ULL, 0xfffffffc43427812ULL, 0x000fca00078ee220ULL,
0x00000010425d7824ULL, 0x000fe200078e021fULL, 0x0000000421217984ULL, 0x004ea40008004800ULL,
0x0000002108237224ULL, 0x004fc800078e0223ULL, 0x00005e0023227625ULL, 0x000fcc00078e001cULL,
0x000000101d427825ULL, 0x000fe200078e0022ULL, 0x000000301e227810ULL, 0x000fc80007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000425d7faeULL, 0x0005e2000b901c50ULL,
0x0000000122237824ULL, 0x040fe400078e021bULL, 0x0000000422417824ULL, 0x002fe200078e00ffULL,
0x0106c0061e407984ULL, 0x000e680008004800ULL, 0xfffffffc41687812ULL, 0x000fca00078ee220ULL,
0x0000001068697824ULL, 0x000fe200078e021fULL, 0x0000000440217984ULL, 0x0022e40008004800ULL,
0x000000381e407810ULL, 0x002fca0007ffe0ffULL, 0x0000000140417824ULL, 0x040fe400078e021bULL,
0x00000004401b7824ULL, 0x000fca00078e00ffULL, 0xfffffffc1b207812ULL, 0x000fca00078ee220ULL,
0x00000010201f7824ULL, 0x000fe400078e021fULL, 0x0000002108217224ULL, 0x008fc800078e0223ULL,
0x00005e0021227625ULL, 0x000fcc00078e001cULL, 0x000000101d227825ULL, 0x000fca00078e0022ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022697faeULL, 0x0005e8000b901c50ULL,
0x0106e0061e217984ULL, 0x000e680008004800ULL, 0x0000000421217984ULL, 0x002e640008004800ULL,
0x0000002108417224ULL, 0x002fc800078e0241ULL, 0x00005e0041407625ULL, 0x000fcc00078e001cULL,
0x000000101d407825ULL, 0x000fca00078e0040ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000401f7faeULL, 0x0005e4000b901c50ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000237f007947ULL, 0x000fea000b800000ULL, 0x00016870001c7802ULL, 0x000fc40000000f00ULL,
0x0000384000007944ULL, 0x004fea0003c00000ULL, 0x000000035c00780cULL, 0x000fe20003f05270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000031000007945ULL, 0x000fec0003800000ULL,
0x000002f000000947ULL, 0x000fea0003800000ULL, 0x000000011a1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000028000017945ULL, 0x000fe20003800000ULL, 0x000000186300720cULL, 0x000fe40003f04070ULL,
0x00000002ff1c7819ULL, 0x000fc4000001161bULL, 0x000000031b1b7812ULL, 0x000fe400078ec0ffULL,
0x000000011c1d7807ULL, 0x000fe40004000000ULL, 0x000000ff1b1b7207ULL, 0x000fe40004000000ULL,
0x0000002003217810ULL, 0x004fe20007ffe0ffULL, 0x00000001181d7824ULL, 0x000fe200078e021dULL,
0x000000186300720cULL, 0x000fe40003f04070ULL, 0x000000031a00780cULL, 0x000fc40003f85270ULL,
0x000000051d1c7c11ULL, 0x000fe4000f8e40ffULL, 0x0000000a1b1b7c10ULL, 0x000fe4000fffe0ffULL,
0x0000000603237c11ULL, 0x000fe2000f8e10ffULL, 0x000000011c1d7824ULL, 0x100fe400078e0203ULL,
0x00000001211f7824ULL, 0x100fe400078e021cULL, 0x000068001b1c7a24ULL, 0x000fe200078e021cULL,
0x000000661d00720cULL, 0x080fe20003f26070ULL, 0x00000004ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000661f00720cULL, 0x000fe20003f66070ULL, 0x000000011c1a7824ULL, 0x000fc400078e0203ULL,
0x00000001211c7824ULL, 0x000fe400078e021cULL, 0x000066001a1a7625ULL, 0x000fc800078e001dULL,
0x000066001c1c7625ULL, 0x000fe200078e001dULL, 0x0000010000008947ULL, 0x000fea0002000000ULL,
0x000000030300780cULL, 0x000fe40003f04070ULL, 0x0000000259597810ULL, 0x000fd60007ffe0ffULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x0000000000187919ULL, 0x000e620000002700ULL,
0x000000645900720cULL, 0x000fe20003f06070ULL, 0x00000004041e7824ULL, 0x000fe400078e0203ULL,
0x00000004ff1f7424ULL, 0x000fc600078e00ffULL, 0x00010a801e217811ULL, 0x000fe200078e10ffULL,
0x0000000418187824ULL, 0x002fc800078e0203ULL, 0x0000000218187824ULL, 0x000fc800078e00ffULL,
0x0000640018187a24ULL, 0x000fc800078e0259ULL, 0x00006000181e7625ULL, 0x000fca00078e001fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e217faeULL, 0x0003e4000c121850ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x106000001a237faeULL, 0x0005e8000c921850ULL, 0x106800001c237faeULL, 0x0005e4000d921850ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020036a7810ULL, 0x040fe20007ffe0ffULL, 0x00000002046b7824ULL, 0x000fe200078e0219ULL,
0xfffffff803687812ULL, 0x040fe200078ec0ffULL, 0x000000ffff697224ULL, 0x004fe200078e00ffULL,
0xfffffff86a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000007036c7812ULL, 0x000fc400078ec0ffULL,
0x0000000768687812ULL, 0x100fe400078ef803ULL, 0x000000076a6a7812ULL, 0x100fe400078ef803ULL,
0x000020006b6b7811ULL, 0x000fe400078e60ffULL, 0x000000086c6c7812ULL, 0x000fe400078ef803ULL,
0x00000001ff6e7819ULL, 0x000fe40000011668ULL, 0x00000001ff707819ULL, 0x000fc4000001166aULL,
0x00000004601e7824ULL, 0x102fe200078e0269ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000016e187824ULL, 0x020fe200078e0269ULL, 0x00000001696d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000468197824ULL, 0x000fc400078e00ffULL, 0x000000021e1e7824ULL, 0x000fe400078e00ffULL,
0x000000206c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19187812ULL, 0x000fe200078ee218ULL,
0x000000046a1d7824ULL, 0x000fe200078e00ffULL, 0x0000001e03197211ULL, 0x000fe400078fe0ffULL,
0x000000021e1e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010181a7824ULL, 0x000fe400078e026bULL,
0x000000016c197824ULL, 0x000fca00078e0219ULL, 0xffffffe01c1c7812ULL, 0x000fe400078ee219ULL,
0x000000001a18783bULL, 0x000e660000000200ULL, 0x000000101c207824ULL, 0x000fe400078e00ffULL,
0x00000001701c7824ULL, 0x000fe200078e0269ULL, 0x0000000269697810ULL, 0x000fc60007ffe0ffULL,
0x000000002020783bULL, 0x000ea20000000200ULL, 0xfffffffc1d1c7812ULL, 0x000fe400078ee21cULL,
0x000000046900780cULL, 0x000fc60003f05270ULL, 0x000000101c407824ULL, 0x000fcc00078e026bULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x00000018ff1c723eULL, 0x082fe400020006ffULL,
0x00000018ff1d723eULL, 0x000fe400030006ffULL, 0x00000019ff18723eULL, 0x080fe400020006ffULL,
0x00000019ff19723eULL, 0x000fc600030006ffULL, 0x0000001c203c723cULL, 0x044bee000000183cULL,
0x00000004681d7824ULL, 0x020fe200078e00ffULL, 0x000000182038723cULL, 0x000b620000001838ULL,
0x00000040ff5c723eULL, 0x088fe400020006ffULL, 0x00000040ff5d723eULL, 0x000fc800030006ffULL,
0x0000001aff18723eULL, 0x0a0fe400020006ffULL, 0x0000001aff19723eULL, 0x000fe200030006ffULL,
0x000000016e1a7824ULL, 0x100fe200078e026dULL, 0x00000041ff40723eULL, 0x080fe200020006ffULL,
0x0000005c2028723cULL, 0x000be20000001828ULL, 0x00000041ff41723eULL, 0x000fe200030006ffULL,
0x00000001706d7824ULL, 0x000fe200078e026dULL, 0xfffffffc1d1c7812ULL, 0x000fe400078ee21aULL,
0x0000001bff1a723eULL, 0x000fc400020006ffULL, 0x0000001bff1b723eULL, 0x000fe200030006ffULL,
0x000000182034723cULL, 0x000b620000001834ULL, 0x000000101c1c7824ULL, 0x000fe200078e026bULL,
0x00000043ff5d723eULL, 0x020fe200030006ffULL, 0x000000046a5c7824ULL, 0x000fc800078e00ffULL,
0x0000001e03197211ULL, 0x000fe200078fe0ffULL, 0x000000206c187824ULL, 0x040fe200078e00ffULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x00000040202c723cULL, 0x000be4000000182cULL,
0x000000016c197824ULL, 0x000fca00078e0219ULL, 0xffffffe018197812ULL, 0x000fe200078ee219ULL,
0x0000001a2014723cULL, 0x000b640000001814ULL, 0x00000042ff40723eULL, 0x0a0fe400020006ffULL,
0x00000042ff41723eULL, 0x000fe200030006ffULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffffc5c427812ULL, 0x000fe400078ee26dULL, 0x00000043ff5c723eULL, 0x000fc600020006ffULL,
0x000000001918783bULL, 0x000ea20000000200ULL, 0x0000001042427824ULL, 0x000fe200078e026bULL,
0x000000402030723cULL, 0x040b6a0000001830ULL, 0x000000004240783bULL, 0x020ee60000000200ULL,
0x0000005c2024723cULL, 0x000b6e0000001824ULL, 0x0000001cff20723eULL, 0x022fc400020006ffULL,
0x0000001cff21723eULL, 0x000fe400030006ffULL, 0x0000001dff1c723eULL, 0x080fe400020006ffULL,
0x0000001dff1d723eULL, 0x000fce00030006ffULL, 0x0000001c1838723cULL, 0x044b6e0000001838ULL,
0x0000001eff1c723eULL, 0x0a0fe200020006ffULL, 0x00000020183c723cULL, 0x000f62000000183cULL,
0x0000001eff1d723eULL, 0x000fe400030006ffULL, 0x0000001fff1e723eULL, 0x000fc400020006ffULL,
0x0000001fff1f723eULL, 0x000fc600030006ffULL, 0x0000001c1834723cULL, 0x040b6e0000001834ULL,
0x00000040ff1c723eULL, 0x0a8fe200020006ffULL, 0x0000001e1814723cULL, 0x000f620000001814ULL,
0x00000040ff1d723eULL, 0x000fe400030006ffULL, 0x00000041ff40723eULL, 0x000fc400020006ffULL,
0x00000041ff41723eULL, 0x000fc600030006ffULL, 0x0000001c1828723cULL, 0x040b6e0000001828ULL,
0x00000042ff1c723eULL, 0x0a0fe200020006ffULL, 0x00000040182c723cULL, 0x000b62000000182cULL,
0x00000042ff1d723eULL, 0x000fe400030006ffULL, 0x00000043ff42723eULL, 0x000fc400020006ffULL,
0x00000043ff43723eULL, 0x000fc600030006ffULL, 0x0000001c1830723cULL, 0x040b700000001830ULL,
0x000000421824723cULL, 0x000b620000001824ULL, 0xfffffa8000000947ULL, 0x000fce000383ffffULL,
0x000000045e00780cULL, 0x000fe20003f06070ULL, 0x000000ffff607224ULL, 0x000fc400078e005eULL,
0x000000ffff197224ULL, 0x020fd400078e0007ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe51000007947ULL, 0x000fea000383ffffULL, 0x00000002ff427819ULL, 0x000fc80000011603ULL,
0x000000674200720cULL, 0x040fe40003f06070ULL, 0x0000000167677810ULL, 0x000fe40007ffe0ffULL,
0x0000000842407810ULL, 0x040fe40007ffe0ffULL, 0x000000674200720cULL, 0x000fe40004706470ULL,
0x000000614000720cULL, 0x000fe40003f26070ULL, 0x000000066300720cULL, 0x000fc40000703070ULL,
0x000000674000720cULL, 0x000fc80000f21070ULL, 0x000000066300720cULL, 0x000fc80000f24470ULL,
0x0000005a275a7208ULL, 0x000fe40000800000ULL, 0x0000004726477208ULL, 0x000fe20000800000ULL,
0x000000ffff588224ULL, 0x000fe200078e0025ULL, 0x0000004833487208ULL, 0x000fe20000800000ULL,
0x000000ffff5b8224ULL, 0x000fe200078e0024ULL, 0x0000004932497208ULL, 0x000fe20000800000ULL,
0x000000ffff098224ULL, 0x000fe200078e0031ULL, 0x0000004a2f4a7208ULL, 0x000fe20000800000ULL,
0x000000ffff0a8224ULL, 0x000fe200078e0030ULL, 0x0000004b2e4b7208ULL, 0x000fe20000800000ULL,
0x000000ffff0b8224ULL, 0x000fe200078e002dULL, 0x0000004c2b4c7208ULL, 0x000fe20000800000ULL,
0x000000ffff0c8224ULL, 0x000fe200078e002cULL, 0x0000004d2a4d7208ULL, 0x000fe20000800000ULL,
0x000000ffff0d8224ULL, 0x000fe200078e0029ULL, 0x0000004e174e7208ULL, 0x000fe20000800000ULL,
0x000000ffff0e8224ULL, 0x000fe200078e0028ULL, 0x0000004f164f7208ULL, 0x000fe20000800000ULL,
0x000000ffff0f8224ULL, 0x000fe200078e0015ULL, 0x0000005037507208ULL, 0x000fe20000800000ULL,
0x000000ffff108224ULL, 0x000fe200078e0014ULL, 0x0000005136517208ULL, 0x000fe20000800000ULL,
0x000000ffff118224ULL, 0x000fe200078e0035ULL, 0x000000523b527208ULL, 0x000fe20000800000ULL,
0x000000ffff128224ULL, 0x000fe200078e0034ULL, 0x000000533a537208ULL, 0x000fe20000800000ULL,
0x000000ffff138224ULL, 0x000fe200078e0039ULL, 0x000000543f547208ULL, 0x000fe20000800000ULL,
0x000000ffff448224ULL, 0x000fe200078e0038ULL, 0x000000553e557208ULL, 0x000fe20000800000ULL,
0x000000ffff458224ULL, 0x000fc400078e003dULL, 0x000000ffff468224ULL, 0x000fe200078e003cULL,
0x000000626700720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fea000383ffffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000056147f8cULL, 0x000e62000c80043fULL, 0x0000000246217220ULL, 0x080fe20000410000ULL,
0x0000000245207220ULL, 0x080fe20000410000ULL, 0x00000002441f7220ULL, 0x080fe20000410000ULL,
0x0000000213137220ULL, 0x080fe20000410000ULL, 0x0000000212127220ULL, 0x080fe20000410000ULL,
0x0000000211117220ULL, 0x080fe20000410000ULL, 0x0000000210107220ULL, 0x080fe20000410000ULL,
0x000000020f1e7220ULL, 0x080fe20000410000ULL, 0x000000020e1d7220ULL, 0x080fe20000410000ULL,
0x000000020d1c7220ULL, 0x080fe20000410000ULL, 0x000000020c1b7220ULL, 0x080fe20000410000ULL,
0x000000020b0b7220ULL, 0x080fe20000410000ULL, 0x000000020a0a7220ULL, 0x080fe20000410000ULL,
0x0000000209097220ULL, 0x080fe20000410000ULL, 0x000000025b1a7220ULL, 0x080fe20000410000ULL,
0x0000000258197220ULL, 0x080fe20000410000ULL, 0x0000000255327220ULL, 0x080fe20000410000ULL,
0x0000000254317220ULL, 0x080fe20000410000ULL, 0x0000000253337220ULL, 0x080fe20000410000ULL,
0x00000002522f7220ULL, 0x080fe20000410000ULL, 0x00000002512e7220ULL, 0x080fe20000410000ULL,
0x00000002502b7220ULL, 0x080fe20000410000ULL, 0x000000024f2a7220ULL, 0x080fe20000410000ULL,
0x000000ffff177224ULL, 0x002fe200078e0015ULL, 0x000000024e297220ULL, 0x080fe20000410000ULL,
0x000000024d287220ULL, 0x080fe20000410000ULL, 0x000000024c277220ULL, 0x080fe20000410000ULL,
0x000000024b267220ULL, 0x080fe20000410000ULL, 0x000000024a257220ULL, 0x080fe20000410000ULL,
0x0000000249247220ULL, 0x080fe20000410000ULL, 0x0000000248237220ULL, 0x080fe20000410000ULL,
0x0000000247227220ULL, 0x080fe20000410000ULL, 0x000000025a187220ULL, 0x000fc20000410000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x00000400560e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c157210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000150e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400560e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000403177824ULL, 0x000fe200078e00ffULL,
0x000000570600720cULL, 0x000fc80003f05270ULL, 0xfffffff0170d7812ULL, 0x000fca00078ec0ffULL,
0x00000080042c7824ULL, 0x000fca00078e020dULL, 0x010400002c0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000203147824ULL, 0x000fe400078e00ffULL,
0x00000001665f7824ULL, 0x000fc600078e0a5fULL, 0x0000000614147812ULL, 0x000fc800078ec0ffULL,
0x0000000114167812ULL, 0x040fe400078efcffULL, 0x0000000814307812ULL, 0x000fe400078efcffULL,
0x0000005f1600720cULL, 0x080fe40003f26070ULL, 0x0000001014167812ULL, 0x000fe400078efcffULL,
0x0000005f3000720cULL, 0x080fe40003f06070ULL, 0x0000005f1600720cULL, 0x000fc40003fc6070ULL,
0x0000001114307812ULL, 0x040fe400078efcffULL, 0x0000001814167812ULL, 0x040fe400078efcffULL,
0x0000005f1400720cULL, 0x080fe40003f46070ULL, 0x0000005f3000720cULL, 0x080fe40003fa6070ULL,
0x0000005f1600720cULL, 0x000fe40003f66070ULL, 0x0000000914347812ULL, 0x000fc400078efcffULL,
0x0000001914307812ULL, 0x040fe400078efcffULL, 0x0000002014167812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40005000000ULL,
0xff80000031317808ULL, 0x000fe40004800000ULL, 0xff80000020207808ULL, 0x000fc40004800000ULL,
0x0000005f3400720cULL, 0x080fe40003f86070ULL, 0x0000005f3000720cULL, 0x080fe40003f46070ULL,
0x0000005f1600720cULL, 0x000fe40003f26070ULL, 0x0000002114307812ULL, 0x040fe400078efcffULL,
0x0000002814167812ULL, 0x000fe400078efcffULL, 0xff80000033337808ULL, 0x000fc40004000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40006000000ULL,
0xff80000013137808ULL, 0x000fe40006000000ULL, 0x0000005f3000720cULL, 0x080fe40003f06070ULL,
0x0000005f1600720cULL, 0x000fe40003f86070ULL, 0x0000002914307812ULL, 0x000fc400078efcffULL,
0x0000003014167812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006800000ULL,
0xff80000011117808ULL, 0x000fe40006800000ULL, 0x0000005f3000720cULL, 0x000fc40003fc6070ULL,
0x0000005f1600720cULL, 0x000fe40003fa6070ULL, 0x0000003114307812ULL, 0x040fe400078efcffULL,
0x0000003814167812ULL, 0x040fe400078efcffULL, 0x0000003914147812ULL, 0x000fe400078efcffULL,
0xff8000002a2a7808ULL, 0x000fe40005800000ULL, 0xff80000010107808ULL, 0x000fc40005800000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0xff8000001d1d7808ULL, 0x000fe40004800000ULL,
0x0000005f3000720cULL, 0x080fe40003f66070ULL, 0x0000005f1600720cULL, 0x000fc40003f46070ULL,
0x0000005f1400720cULL, 0x000fe40003f26070ULL, 0xff80000027277808ULL, 0x000fe40004000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004000000ULL, 0xff80000026267808ULL, 0x000fe40006000000ULL,
0xff8000001b1b7808ULL, 0x000fe40006000000ULL, 0xff80000025257808ULL, 0x000fc40007000000ULL,
0xff8000000b0b7808ULL, 0x000fe40007000000ULL, 0xff80000024247808ULL, 0x000fe40006800000ULL,
0xff8000000a0a7808ULL, 0x000fe40006800000ULL, 0xff80000023237808ULL, 0x000fe40005800000ULL,
0xff80000009097808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005000000ULL,
0xff8000001a1a7808ULL, 0x000fe40005000000ULL, 0xff80000018187808ULL, 0x000fe40004800000ULL,
0xff80000019197808ULL, 0x000fc40004800000ULL, 0x000000210c00720bULL, 0x004fe20003f1e000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x000000320d00720bULL, 0x000fe20003f3e000ULL,
0xffffffffff397424ULL, 0x000fe200078e00ffULL, 0x0000000c21157208ULL, 0x000fe40004000000ULL,
0x0000000d320c7208ULL, 0x000fc40004800000ULL, 0x000000201500720bULL, 0x000fe40003f1e000ULL,
0x000000310c00720bULL, 0x000fe40003f3e000ULL, 0x0000001520147208ULL, 0x000fe40004000000ULL,
0x0000000c310c7208ULL, 0x000fe40004800000ULL, 0x0000001f1400720bULL, 0x000fe40003f1e000ULL,
0x000000330c00720bULL, 0x000fc40003f3e000ULL, 0x000000141f147208ULL, 0x000fe40004000000ULL,
0x0000000c330c7208ULL, 0x000fe40004800000ULL, 0x000000131400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0c00720bULL, 0x000fe40003f3e000ULL, 0x00000014130d7208ULL, 0x000fe40004000000ULL,
0x0000000c2f157208ULL, 0x000fc40004800000ULL, 0x000000120d00720bULL, 0x000fe40003f1e000ULL,
0x0000002e1500720bULL, 0x000fe40003f3e000ULL, 0x0000000d120c7208ULL, 0x000fe40004000000ULL,
0x000000152e147208ULL, 0x000fe40004800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x0000002b1400720bULL, 0x000fc40003f3e000ULL, 0x0000000c110d7208ULL, 0x000fe40004000000ULL,
0x000000142b157208ULL, 0x000fe40004800000ULL, 0x000000100d00720bULL, 0x000fe40003f1e000ULL,
0x0000002a1500720bULL, 0x000fe40003f3e000ULL, 0x0000000d100d7208ULL, 0x000fe40004000000ULL,
0x000000152a0c7208ULL, 0x000fc40004800000ULL, 0x0000001e0d00720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000000d1e147208ULL, 0x000fe40004000000ULL,
0x0000000c290d7208ULL, 0x000fe40004800000ULL, 0x0000001d1400720bULL, 0x000fe40003f1e000ULL,
0x000000280d00720bULL, 0x000fc40003f3e000ULL, 0x000000141d157208ULL, 0x000fe40004000000ULL,
0x0000000d280c7208ULL, 0x000fe40004800000ULL, 0x0000001c1500720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x000000151c147208ULL, 0x000fe40004000000ULL,
0x0000000c270d7208ULL, 0x000fc40004800000ULL, 0x0000001b1400720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fe40003f3e000ULL, 0x000000141b147208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fe40004800000ULL, 0x0000000b1400720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x000000140b0d7208ULL, 0x000fe40004000000ULL,
0x0000000c25157208ULL, 0x000fe40004800000ULL, 0x0000000a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000241500720bULL, 0x000fe40003f3e000ULL, 0x0000000d0a0c7208ULL, 0x000fe40004000000ULL,
0x0000001524147208ULL, 0x000fc40004800000ULL, 0x000000090c00720bULL, 0x000fe40003f1e000ULL,
0x000000231400720bULL, 0x000fe40003f3e000ULL, 0x0000000c090d7208ULL, 0x000fe40004000000ULL,
0x0000001423157208ULL, 0x000fe40004800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000221500720bULL, 0x000fc40003f3e000ULL, 0x0000000d1a0c7208ULL, 0x000fe40004000000ULL,
0x0000001522157208ULL, 0x000fe40004800000ULL, 0x000000190c00720bULL, 0x000fe40003f1e000ULL,
0x000000181500720bULL, 0x000fe40003f3e000ULL, 0x0000000c19347208ULL, 0x000fe40004000000ULL,
0x00000015182d7208ULL, 0x000fe20004800000ULL, 0x000019027f007947ULL, 0x000fec000b800000ULL,
0x0c401f00340c7f89ULL, 0x0004e400000e0000ULL, 0x0000000c3400720bULL, 0x008fc80003f1e000ULL,
0x000000340c367208ULL, 0x000fe20004000000ULL, 0x000019127f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d0c7f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f147f89ULL, 0x000e6800000e0000ULL, 0x0c201f0036157f89ULL, 0x000ea200000e0000ULL,
0x0000000c2d00720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x0000002d0c0c7208ULL, 0x000fe40004000000ULL, 0x0000000e0d0d7208ULL, 0x000fe40004800000ULL,
0x000000140f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f000c357f89ULL, 0x000e6600000e0000ULL,
0x0000000f142d7208ULL, 0x000fe20004000000ULL, 0x0c201f000d167f89ULL, 0x000ee200000e0000ULL,
0x000000153600720bULL, 0x004fc60003f1e000ULL, 0x0c201f002d307f89ULL, 0x0004a200000e0000ULL,
0x0000003615147208ULL, 0x000fe40004000000ULL, 0x000000350c00720bULL, 0x002fe40003f3e000ULL,
0x000000160d00720bULL, 0x008fe40003f5e000ULL, 0x0000000c35157208ULL, 0x000fe40004800000ULL,
0x0000000d16167208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b15347820ULL, 0x006fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000842367824ULL, 0x000fe200078e00ffULL,
0x0000a00008047891ULL, 0x000fe2000f8e583fULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL, 0x0000003200557308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL, 0x0000003100547308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b14327820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b23237823ULL, 0x000fe20000010834ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010832ULL,
0x0000003300537308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1e0f7823ULL, 0x000fe20000010832ULL, 0x3fb8aa3b22227823ULL, 0x000fe20000010834ULL,
0x3fb8aa3b1d0e7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1c0d7823ULL, 0x100fe20000010832ULL,
0x0000002f00527308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b1b0c7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010832ULL, 0x00000008421c7824ULL, 0x040fe200078e00ffULL,
0x00000001421b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010832ULL,
0x0000002100467308ULL, 0x000fe20000000800ULL, 0x3c003c00ff2f7424ULL, 0x002fe200078e00ffULL,
0x3fb8aa3b19197823ULL, 0x000fe20000010832ULL, 0xfffffff81c327812ULL, 0x000fe200078ee21bULL,
0x3fb8aa3b18187823ULL, 0x000fe20000010834ULL, 0x0000000842337824ULL, 0x040fe200078e00ffULL,
0x0000000442317810ULL, 0x040fe20007ffe0ffULL, 0x0000000842347824ULL, 0x040fe200078e00ffULL,
0x0000002000457308ULL, 0x000fe20000000800ULL, 0x0000000842387824ULL, 0x040fe200078e00ffULL,
0x00000003421b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008423a7824ULL, 0x000fe200078e00ffULL,
0xfffffff836357812ULL, 0x000fe200078ee231ULL, 0x0000000842317824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee21bULL, 0x0000000842397824ULL, 0x040fe200078e00ffULL,
0x0000001f00447308ULL, 0x000fe20000000800ULL, 0x0000000642377810ULL, 0x000fe20007ffe0ffULL,
0x00000008403b7824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fc400078ee242ULL,
0xfffffff83a377812ULL, 0x000fe400078ee237ULL, 0x0000000431317c11ULL, 0x000fe2000f8e20ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0xfffffff83b407812ULL, 0x000fe400078ee240ULL,
0x0000000435357c11ULL, 0x000fe4000f8e20ffULL, 0x0000000437377c11ULL, 0x000fe4000f8e20ffULL,
0x00000004403b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000002e00517308ULL, 0x0007e20000000800ULL,
0x0000000303ff7812ULL, 0x000fc4000780c0ffULL, 0x000000302d00720bULL, 0x000fca0003f3e000ULL,
0x00000027004c7308ULL, 0x0005e20000000800ULL, 0x3c003c00ff2e7424ULL, 0x008fce00078e00ffULL,
0x00000026004b7308ULL, 0x0003e20000000800ULL, 0x000000535227723eULL, 0x004fce00000000ffULL,
0x00000025004a7308ULL, 0x0004e20000000800ULL, 0x000000441326723eULL, 0x002fce00000000ffULL,
0x0000002400497308ULL, 0x0003e20000000800ULL, 0x000000555425723eULL, 0x004fce00000000ffULL,
0x0000002b00507308ULL, 0x000ea20000000800ULL, 0x000000464524723eULL, 0x002fe400000000ffULL,
0x0000004b4a1f723eULL, 0x008fca00000000ffULL, 0x0000002a004f7308ULL, 0x000ff00000000800ULL,
0x00000029004e7308ULL, 0x000fe20000000800ULL, 0x000000515021723eULL, 0x004fce00000000ffULL,
0x00000028004d7308ULL, 0x0002b00000000800ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000002e2428723cULL, 0x002f6e00000018ffULL, 0x0000001100117308ULL, 0x000e620000000800ULL,
0x0000004d4c1d723eULL, 0x004fce00000000ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x000000121120723eULL, 0x002fce00000000ffULL,
0x0000002300487308ULL, 0x0003f00000000800ULL, 0x0000002200477308ULL, 0x0005e20000000800ULL,
0x0000004f4e23723eULL, 0x002fce00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x000000100f22723eULL, 0x004fce00000000ffULL, 0x0000002e2028723cULL, 0x020f620000001828ULL,
0x0000000d000d7308ULL, 0x000e700000000800ULL, 0x0000000c000c7308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x0000000e0d1c723eULL, 0x002fce00000000ffULL,
0x0000000a000a7308ULL, 0x000fe20000000800ULL, 0x0000000c0b1e723eULL, 0x004fce00000000ffULL,
0x0000000900097308ULL, 0x000e620000000800ULL, 0x0000002e1c28723cULL, 0x020f6e0000001828ULL,
0x0000001a005b7308ULL, 0x0005f00000000800ULL, 0x0000001900587308ULL, 0x0007220000000800ULL,
0x00000002421a7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff833337812ULL, 0x000fc600078ee21aULL,
0x00000018005a7308ULL, 0x0002a20000000800ULL, 0x0000000542197810ULL, 0x008fe40007ffe0ffULL,
0x0000000433337c11ULL, 0x000fe4000f8e20ffULL, 0xfffffff838367812ULL, 0x000fe400078ee219ULL,
0x000000494819723eULL, 0x000fe400000000ffULL, 0x0000000a0918723eULL, 0x002fe400000000ffULL,
0x0000005b581a723eULL, 0x010fc400000000ffULL, 0xffffffff42387810ULL, 0x000fe40007ffe0ffULL,
0x000000475a1b723eULL, 0x004fe400000000ffULL, 0xfffffff839387812ULL, 0x000fc800078ee238ULL,
0x0000000438397c11ULL, 0x000fe2000f8e20ffULL, 0x0000002e1828723cULL, 0x020b6e0000001828ULL,
0x0000000c172e7812ULL, 0x020fe400078ec0ffULL, 0x0000000432177c11ULL, 0x000fc4000f8e20ffULL,
0x00000004362f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000131317824ULL, 0x000fe400078e022eULL,
0x000000012e337824ULL, 0x040fe400078e0233ULL, 0x000000012e357824ULL, 0x040fe200078e0235ULL,
0x0000002431007388ULL, 0x0003e20000000800ULL, 0x000000012e2f7824ULL, 0x000fe400078e022fULL,
0x00000004342b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000012e297824ULL, 0x000fe200078e0217ULL,
0x0000002d30177208ULL, 0x000fe20004800000ULL, 0x000000012e377824ULL, 0x000fc400078e0237ULL,
0x000000012e2b7824ULL, 0x040fe200078e022bULL, 0x0000002629007388ULL, 0x0005e20000000800ULL,
0x000000012e397824ULL, 0x040fe400078e0239ULL, 0x000000012e2e7824ULL, 0x000fe200078e023bULL,
0x0000002033007388ULL, 0x0005e20000000800ULL, 0x000000ffff307224ULL, 0x000fe400078e0028ULL,
0x000000ffff317224ULL, 0x002fe200078e002aULL, 0x000000222b007388ULL, 0x0005e80000000800ULL,
0x0000001c35007388ULL, 0x0005e80000000800ULL, 0x0000001e2f007388ULL, 0x0005e80000000800ULL,
0x0000001837007388ULL, 0x0005e80000000800ULL, 0x0000001a39007388ULL, 0x0005e80000000800ULL,
0x000000252e007388ULL, 0x0005e80000000800ULL, 0x0004002729007388ULL, 0x0005e80000000800ULL,
0x0004002133007388ULL, 0x0005e80000000800ULL, 0x000400232b007388ULL, 0x0005e80000000800ULL,
0x0004001d35007388ULL, 0x0005e80000000800ULL, 0x0004001f2f007388ULL, 0x0005e80000000800ULL,
0x0004001937007388ULL, 0x0005e80000000800ULL, 0x0004001b39007388ULL, 0x0005e80000000800ULL,
0x010000142c008388ULL, 0x0005e80000000c00ULL, 0x010200302c008388ULL, 0x0005e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080005ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100005ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000106067810ULL, 0x000fe20007ffe0ffULL,
0x0000180005ff7f8cULL, 0x0003e6000c80043fULL, 0x000000650600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc65000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff217807ULL, 0x008fe40004000000ULL,
0x00018fa000207802ULL, 0x000fc40000000f00ULL, 0x000010b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0025ULL, 0xfffea57000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x00018ff000207802ULL, 0x000fc40000000f00ULL,
0x0000106000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0025ULL,
0xfffea5b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x000fe200078e000fULL,
0x0001905000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e001aULL,
0x00000fc000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xfffea65000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001aULL,
0x000190b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e000fULL,
0x00000f6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xfffea75000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0019ULL,
0x0001911000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e001aULL,
0x00000f0000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xfffea92000007947ULL, 0x000fea000383ffffULL, 0x000000ffff277224ULL, 0x002fe200078e0018ULL,
0x0001917000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fc400078e0019ULL,
0x00000ea000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xfffea8f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000191d000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x00000e4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xfffec75000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001923000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x00000de000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xfffec71000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x004fe40004000000ULL,
0x0001928000207802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0025ULL, 0xfffee99000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x000192d000207802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x008fea0003c00000ULL, 0xfffee9e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001932000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x00000cf000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xfffeea7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001938000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xfffeeb6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000193e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x00000c3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xfffeed2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001944000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x00000bd000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xfffeece000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000194a000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x00000b7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xffff095000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001950000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x00000b1000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xffff091000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x004fe40004000000ULL, 0x0001955000207802ULL, 0x000fc40000000f00ULL,
0x00000b0000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0025ULL,
0xffff2a7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x000fe40004800000ULL,
0x000195a000207802ULL, 0x000fc40000000f00ULL, 0x00000ab000007944ULL, 0x008fea0003c00000ULL,
0xffff2ac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x000195f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x00000a2000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xffff2b5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0029ULL,
0x0001965000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0026ULL,
0xffff2c4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000196b000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x0000096000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xffff2e0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001971000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x0000090000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xffff2dc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x0001977000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fc400078e006cULL,
0x000008a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff177224ULL, 0x004fe200078e0026ULL,
0xffff4a3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0022ULL,
0x000197d000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x002fc400078e006bULL,
0x0000084000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0026ULL,
0xffff49f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff217807ULL, 0x004fe40004000000ULL,
0x0001982000207802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0025ULL, 0xffff6b5000007947ULL, 0x000fea000383ffffULL,
0x00000001ff217807ULL, 0x000fe40004800000ULL, 0x0001987000207802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x008fea0003c00000ULL, 0xffff6ba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x000198c000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x0000075000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xffff6c3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0029ULL, 0x0001992000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x000006f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0026ULL, 0xffff6d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x0001998000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x0000069000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xffff6ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x000199e000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x0000063000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xffff6ea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00019a4000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e006cULL, 0x000005d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff177224ULL, 0x004fe200078e0026ULL, 0xffff8b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0022ULL, 0x00019aa000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x002fc400078e006bULL, 0x0000057000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff187224ULL, 0x004fe200078e0026ULL, 0xffff8ad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0004ULL, 0x00019af000207802ULL, 0x020fc40000000f00ULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0026ULL,
0xffff95c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0004ULL,
0x00019b4000207802ULL, 0x020fc40000000f00ULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0026ULL, 0xffff96b000007947ULL, 0x000fea000383ffffULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x00019b90000c7802ULL, 0x000fc40000000f00ULL,
0x0000044000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0030ULL,
0xffffe6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff347224ULL, 0x006fe200078e002dULL,
0x00019bf0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x000000302d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000eULL, 0x00019c50000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000002d30157208ULL, 0x000fc80004000000ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000300e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x00019cb0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe200078e00ffULL, 0x0000000e30377208ULL, 0x000fc80004000000ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000300f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0036ULL, 0x00019d10000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000000f302d7208ULL, 0x000fc80004000000ULL,
0x000002c000007944ULL, 0x000fea0003c00000ULL, 0x000000303600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0015ULL, 0x00019d70000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000003630147208ULL, 0x000fc80004000000ULL,
0x0000026000007944ULL, 0x000fea0003c00000ULL, 0x000000301500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e0037ULL, 0x00019dd0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000001530157208ULL, 0x000fc80004000000ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000303700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff347224ULL, 0x002fe200078e002dULL, 0x00019e30000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe200078e00ffULL, 0x0000003730167208ULL, 0x000fc80004000000ULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0xffffe59000007947ULL, 0x000fea000383ffffULL,
0x018000000c027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000c00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0cff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000c037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000c00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe603002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00003534307389ULL, 0x0002a200000e0038ULL,
0xfffe5ff00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000000e00007348ULL, 0x000fe80003800000ULL, 0x0000002726267389ULL, 0x0002a200000e000dULL,
0xfffe5fb020007950ULL, 0x000fea0003c3ffffULL, 0x000000012100780cULL, 0x000fe20003f25070ULL,
0x0000001400007348ULL, 0x000fd80003800000ULL, 0x0000000000217806ULL, 0x000fc800048e0100ULL,
0x0000001421257212ULL, 0x000fe200078ec0ffULL, 0x00000000ff217424ULL, 0x000fc800078e00ffULL,
0xfffe5f5020007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1d7424ULL, 0x000fe200078e00ffULL,
0x0000000000007348ULL, 0x000fe80003800000ULL, 0xfffe5f201c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x0000000000000603ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000760ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000408ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x00000000000000e4ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eecULL, 0x0000000000000c3cULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b28ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001b38ULL, 0x00000000000000b0ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001be8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001becULL, 0x00000000000001c8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001e00ULL, 0x000000000001a180ULL, 0x7900001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001bf80ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001bfd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001c350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001be8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001a398ULL, 0x000000000001a398ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001bf80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001c350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_4_kvt_e4m3_pagedKV_128_nqpkv_1_m_1_sm_89_cubin_len = 115760;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
