/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019190ULL, 0x0000000000018d10ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000017120ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000017290ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x00000000000172d0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000017310ULL,
0x0000000000000170ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017480ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001712000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x005adc0400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8e082880808c0828ULL, 0x2880809008288080ULL, 0x8098082880809208ULL, 0x082880809b082880ULL,
0x8080a0082880809dULL, 0xa408288080a30828ULL, 0x288080b208288080ULL, 0x80b808288080b408ULL,
0x08288080b9082880ULL, 0x80809a08288080ccULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809a92ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001712000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x90082880808e0828ULL, 0x2880809208288080ULL, 0x809a082880809808ULL, 0x082880809b082880ULL,
0x8080a308288080a0ULL, 0xb208288080a40828ULL, 0x288080b408288080ULL, 0x80b908288080b808ULL,
0x08288080cc082880ULL, 0x808280162880808cULL, 0x0000000000031028ULL, 0x2880808c92000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x0001729000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8e082880808c0828ULL, 0x2880809008288080ULL, 0x8098082880809208ULL, 0x082880809a082880ULL,
0x8080a0082880809bULL, 0xa408288080a30828ULL, 0x288080b208288080ULL, 0x80b908288080b408ULL,
0x08288080cc082880ULL, 0x80828016288080b8ULL, 0x0000000000031028ULL, 0x288080b892000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x000172d000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8e082880808c0828ULL, 0x2880809008288080ULL, 0x8098082880809208ULL, 0x082880809a082880ULL,
0x8080a0082880809bULL, 0xa408288080a30828ULL, 0x288080b208288080ULL, 0x80b808288080b408ULL,
0x08288080cc082880ULL, 0x80828016288080b9ULL, 0x0000000000031028ULL, 0x288080b992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000002b000000000ULL, 0x0001731000000000ULL,
0x0000017000000000ULL, 0x0000140400000000ULL, 0x80b4288080b90900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x000812040000009cULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000156f000015260ULL,
0x0001587000015700ULL, 0x0001589000015880ULL, 0xffffffff01c82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000060ffffffffULL,
0x0500006005000060ULL, 0xffffffff05000060ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01c82804ffffffffULL,
0x000000f0000000e0ULL, 0x00001870000017f0ULL, 0x0000194000001910ULL, 0x00001d5000001d20ULL,
0x00001e3000001dc0ULL, 0x0000353000003510ULL, 0x000035f000003590ULL, 0x00004d1000004c90ULL,
0x00004ee000004dc0ULL, 0x000051c0000051a0ULL, 0x0000528000005220ULL, 0x0000676000006740ULL,
0x00006820000067c0ULL, 0x00007eb000007e30ULL, 0x0000808000007f60ULL, 0x0000836000008340ULL,
0x00008420000083c0ULL, 0x000098f0000098d0ULL, 0x000099b000009950ULL, 0x0000b0400000afc0ULL,
0x0000b2100000b0f0ULL, 0x0000b4f00000b4d0ULL, 0x0000b5b00000b550ULL, 0x0000caa00000ca80ULL,
0x0000cb600000cb00ULL, 0x0000dc400000dc30ULL, 0x0000ff500000e3c0ULL, 0x000106d000010210ULL,
0x00010f4000010700ULL, 0x0001516000015130ULL, 0x0001518000015170ULL, 0x000151c0000151a0ULL,
0x000151f0000151e0ULL, 0x000158c000015860ULL, 0x000158e0000158d0ULL, 0x0001606000016000ULL,
0x00016120000160c0ULL, 0x000161f000016180ULL, 0x000162c000016250ULL, 0x0001638000016320ULL,
0x00016440000163e0ULL, 0x0001650000016490ULL, 0x000165d000016560ULL, 0x0001669000016630ULL,
0x00016750000166f0ULL, 0x00016810000167a0ULL, 0x000168e000016870ULL, 0x000169a000016940ULL,
0x00016a6000016a00ULL, 0x00016b2000016ab0ULL, 0x00016bf000016b80ULL, 0x00016ce000016c60ULL,
0x00016dc000016d50ULL, 0x00016ea000016e30ULL, 0x00016f8000016f10ULL, 0x0001705000016fe0ULL,
0x000170f0000170a0ULL, 0x000001d007003904ULL, 0x00010600000000ffULL, 0x00000200003f0100ULL,
0x0001060800000003ULL, 0x000002c0003f0120ULL, 0x0001068800000003ULL, 0x00000390003f0120ULL,
0x000106a800000003ULL, 0x000003c0003f0120ULL, 0x000106b8000000ffULL, 0x00000500003f0100ULL,
0x00010600000000ffULL, 0x000006a0003f0107ULL, 0x0001068c00000008ULL, 0x00000750003f0102ULL,
0x0001068800000008ULL, 0x00000c80003f0101ULL, 0x000106a8000000ffULL, 0x00000d00003f0107ULL,
0x000106a8000000ffULL, 0x00000d60003f0101ULL, 0x000106b8000000ffULL, 0x00000ed0003f0101ULL,
0x000106bc000000ffULL, 0x00000f20003f0105ULL, 0x000106bc000000ffULL, 0x00000fa0003f0105ULL,
0x000106bc000000ffULL, 0x00001570003f0105ULL, 0x000106b0000000ffULL, 0x000015f0003f0107ULL,
0x000106b0000000ffULL, 0x00001600003f0101ULL, 0x000106ac000000ffULL, 0x00001670003f0105ULL,
0x0001060800000008ULL, 0x00001690003f0101ULL, 0x0001060c00000008ULL, 0x00001720003f0105ULL,
0x0001060c00000008ULL, 0x00001c00003f0105ULL, 0x000106ac000000ffULL, 0x00001c80003f0105ULL,
0x000106ac000000ffULL, 0x00002e30003f0105ULL, 0x000106b8000000ffULL, 0x00002e40003f0101ULL,
0x000106bc000000ffULL, 0x00002e90003f0105ULL, 0x000106bc000000ffULL, 0x00002f10003f0105ULL,
0x000106bc000000ffULL, 0x00003310003f0105ULL, 0x000106a8000000ffULL, 0x00003390003f0107ULL,
0x000106a8000000ffULL, 0x000033a0003f0101ULL, 0x000106b4000000ffULL, 0x00003400003f0105ULL,
0x000106b4000000ffULL, 0x00003480003f0105ULL, 0x000106b4000000ffULL, 0x00004510003f0105ULL,
0x000106b8000000ffULL, 0x00004580003f0101ULL, 0x00010688000000ffULL, 0x000045b0003f0101ULL,
0x000106bc000000ffULL, 0x00004600003f0105ULL, 0x000106bc000000ffULL, 0x00004680003f0105ULL,
0x000106bc000000ffULL, 0x00004a50003f0105ULL, 0x000106b0000000ffULL, 0x00004ad0003f0107ULL,
0x000106b0000000ffULL, 0x00004ae0003f0101ULL, 0x000106ac000000ffULL, 0x00004b50003f0105ULL,
0x0001062800000008ULL, 0x00004b70003f0101ULL, 0x0001062c00000008ULL, 0x00004c00003f0105ULL,
0x0001062c00000008ULL, 0x00005090003f0105ULL, 0x000106ac000000ffULL, 0x00005110003f0105ULL,
0x000106ac000000ffULL, 0x00006150003f0105ULL, 0x000106b8000000ffULL, 0x00006160003f0101ULL,
0x000106bc000000ffULL, 0x000061b0003f0105ULL, 0x000106bc000000ffULL, 0x00006230003f0105ULL,
0x000106bc000000ffULL, 0x00006540003f0105ULL, 0x000106a8000000ffULL, 0x000065c0003f0107ULL,
0x000106a8000000ffULL, 0x000065d0003f0101ULL, 0x000106b4000000ffULL, 0x00006630003f0105ULL,
0x000106b4000000ffULL, 0x000066b0003f0105ULL, 0x000106b4000000ffULL, 0x000076b0003f0105ULL,
0x000106b8000000ffULL, 0x00007720003f0101ULL, 0x00010690000000ffULL, 0x00007750003f0101ULL,
0x000106bc000000ffULL, 0x000077a0003f0105ULL, 0x000106bc000000ffULL, 0x00007820003f0105ULL,
0x000106bc000000ffULL, 0x00007bf0003f0105ULL, 0x000106b0000000ffULL, 0x00007c70003f0107ULL,
0x000106b0000000ffULL, 0x00007c80003f0101ULL, 0x000106ac000000ffULL, 0x00007cf0003f0105ULL,
0x0001064800000008ULL, 0x00007d10003f0101ULL, 0x0001064c00000008ULL, 0x00007da0003f0105ULL,
0x0001064c00000008ULL, 0x00008230003f0105ULL, 0x000106ac000000ffULL, 0x000082b0003f0105ULL,
0x000106ac000000ffULL, 0x000092e0003f0105ULL, 0x000106b8000000ffULL, 0x000092f0003f0101ULL,
0x000106bc000000ffULL, 0x00009340003f0105ULL, 0x000106bc000000ffULL, 0x000093c0003f0105ULL,
0x000106bc000000ffULL, 0x000096d0003f0105ULL, 0x000106a8000000ffULL, 0x00009750003f0107ULL,
0x000106a8000000ffULL, 0x00009760003f0101ULL, 0x000106b4000000ffULL, 0x000097c0003f0105ULL,
0x000106b4000000ffULL, 0x00009840003f0105ULL, 0x000106b4000000ffULL, 0x0000a840003f0105ULL,
0x000106b8000000ffULL, 0x0000a8b0003f0101ULL, 0x00010698000000ffULL, 0x0000a8e0003f0101ULL,
0x000106bc000000ffULL, 0x0000a930003f0105ULL, 0x000106bc000000ffULL, 0x0000a9b0003f0105ULL,
0x000106bc000000ffULL, 0x0000ad80003f0105ULL, 0x000106b0000000ffULL, 0x0000ae00003f0107ULL,
0x000106b0000000ffULL, 0x0000ae10003f0101ULL, 0x000106ac000000ffULL, 0x0000ae80003f0105ULL,
0x0001066800000008ULL, 0x0000aea0003f0101ULL, 0x0001066c00000008ULL, 0x0000af30003f0105ULL,
0x0001066c00000008ULL, 0x0000b3c0003f0105ULL, 0x000106ac000000ffULL, 0x0000b440003f0105ULL,
0x000106ac000000ffULL, 0x0000c460003f0105ULL, 0x000106b8000000ffULL, 0x0000c470003f0101ULL,
0x000106bc000000ffULL, 0x0000c4c0003f0105ULL, 0x000106bc000000ffULL, 0x0000c540003f0105ULL,
0x000106bc000000ffULL, 0x0000c880003f0105ULL, 0x000106a8000000ffULL, 0x0000c900003f0107ULL,
0x000106a8000000ffULL, 0x0000c910003f0101ULL, 0x000106b4000000ffULL, 0x0000c970003f0105ULL,
0x000106b4000000ffULL, 0x0000c9f0003f0105ULL, 0x000106b4000000ffULL, 0x0000d9e0003f0105ULL,
0x000106b8000000ffULL, 0x0000da40003f0101ULL, 0x000106a0000000ffULL, 0x00011280003f0101ULL,
0x00010600000000ffULL, 0x00012080003f0101ULL, 0x00010604000000ffULL, 0x00012120003f0105ULL,
0x00010604000000ffULL, 0x00012440003f0105ULL, 0x00010600000000ffULL, 0x00012450003f0101ULL,
0x00010604000000ffULL, 0x000124e0003f0105ULL, 0x00010604000000ffULL, 0x00014650003f0105ULL,
0x000000000000002cULL, 0x00014680003f0101ULL, 0x000000040000002cULL, 0x00014a50003f0105ULL,
0x000000040000002cULL, 0x00015e50003f0105ULL, 0x000000000000002eULL, 0x00015eb0003f0101ULL,
0x000000080000002eULL, 0x00015f10003f0101ULL, 0x000000100000002eULL, 0x00015f80003f0101ULL,
0x000000180000002eULL, 0x00053803003f0101ULL, 0x0001119000101c04ULL, 0x000125f000012540ULL,
0x0000040100015fc0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000035cULL, 0x0000001200000002ULL,
0x000000000000029cULL, 0x0000001200000002ULL, 0x00000000000001dcULL, 0x0000001200000002ULL,
0x000000000000011cULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000333ULL, 0x0000001200000002ULL, 0x0000000000000273ULL, 0x0000001200000002ULL,
0x00000000000001b3ULL, 0x0000001200000002ULL, 0x00000000000000f8ULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000137806ULL, 0x000fe200038e0000ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x0000000000047919ULL, 0x000ea20000002300ULL, 0x0000001300067300ULL, 0x000ee200000e0000ULL,
0x0000000304057899ULL, 0x000fe4000800063fULL, 0x0000000000037919ULL, 0x000f220000002200ULL,
0x0000460000067ab9ULL, 0x000fc60000000a00ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x0000001300137309ULL, 0x000f660000000000ULL, 0x00000000005f7919ULL, 0x000f680000002600ULL,
0x00000000000c7919ULL, 0x000f620000002700ULL, 0x00000005ff007819ULL, 0x002fc60000011605ULL,
0x00001fff040d7589ULL, 0x0043e800000e0000ULL, 0x00001fff00007589ULL, 0x000ea200000e0000ULL,
0x0000000104027824ULL, 0x010fe200078e0203ULL, 0x000000070600720cULL, 0x008fc60003f02070ULL,
0x0000008002037824ULL, 0x000fe400078e0205ULL, 0x0000000000027919ULL, 0x000ee60000000000ULL,
0x000000ff0300720cULL, 0x040fe40003f25270ULL, 0x0000000f0300780cULL, 0x040fe40003f44070ULL,
0x0000007f0300780cULL, 0x040fe40003f84070ULL, 0x000000030300780cULL, 0x000fce0003f64070ULL,
0x3fffff80ff049424ULL, 0x002fe400078e00ffULL, 0x000000040d087824ULL, 0x004fe400078e0200ULL,
0x7fffff80ff059424ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06a424ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0x00000002080a7824ULL, 0x000fc400078e00ffULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x010608060300a388ULL, 0x0005e20000008a00ULL, 0x000000010300780cULL, 0x000fe20003f44070ULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x000000080a0b7817ULL, 0x040fe20007800000ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000010a127810ULL, 0x040fe20007ffe0ffULL,
0x010400100300c388ULL, 0x000fe20000004800ULL, 0x000000070a057812ULL, 0x002fe200078ec0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e0a0aULL, 0x00000007120f7812ULL, 0x000fe200078ec0ffULL,
0x000000085f0b7824ULL, 0x020fe200078e00ffULL, 0x0000001f05057812ULL, 0x108fe200078e7802ULL,
0x010688080300b388ULL, 0x0003e20000008a00ULL, 0x000000ff0e00720cULL, 0x000fe20003f63070ULL,
0x000000050c0b7c24ULL, 0x000fe2000f8e020bULL, 0x000000010e00780cULL, 0x000fe20003f83070ULL,
0x000000200a0e7824ULL, 0x000fe200078e0205ULL, 0x0000001f0f0f7812ULL, 0x000fe200078e7802ULL,
0x000000010b047824ULL, 0x000fc400078e020aULL, 0x000000010b067824ULL, 0x004fe400078e0212ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x3fffff00ff08a424ULL, 0x002fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a8080300a388ULL, 0x0003e20000008a00ULL,
0x0000001002107824ULL, 0x000fc400078e00ffULL, 0x00005c0004047625ULL, 0x080fe200078e0007ULL,
0x0106b80aff009388ULL, 0x0005e40000000a00ULL, 0x000001f010117812ULL, 0x000fe200078ec0ffULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000001104047210ULL, 0x080fe20007fbe0ffULL, 0x0000002012127824ULL, 0x000fe200078e020fULL,
0x0000001106067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0f7824ULL, 0x000fc400078e00ffULL,
0x000000ffff0e7224ULL, 0x000fe400078e0a13ULL, 0x000000ffff057224ULL, 0x000fe400028e0605ULL,
0x000000ffff077224ULL, 0x000fe400010e0607ULL, 0x0000001012117824ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x002fe400078e000eULL, 0x00000004ff137424ULL, 0x000fc800078e00ffULL,
0x000062000c087625ULL, 0x000fe200078e0013ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0005e8000d901c46ULL, 0x0000000006117faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060403ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000608037981ULL, 0x004ea2000c1e1900ULL, 0x00000000000579c3ULL, 0x000e620000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000005ff047e24ULL, 0x002fe2000f8e00ffULL,
0x0000003f03057810ULL, 0x004fc40007ffe0ffULL, 0x000000ff03067810ULL, 0x000fe40007ffe0ffULL,
0x00000006ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff067819ULL, 0x000fca0000011606ULL,
0x00010b9000008947ULL, 0x000fea0003800000ULL, 0x0000000404077824ULL, 0x000fe400078e00ffULL,
0x0000000800087824ULL, 0x000fe400078e00ffULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000050700720cULL, 0x000fda0003f06070ULL, 0x00006400070a8a10ULL, 0x000fe20007ffe0ffULL,
0x000000020c098824ULL, 0x000fc800078e00ffULL, 0x00006400090a8a24ULL, 0x000fe400078e020aULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0d08ff738cULL, 0x0003e20000000000ULL, 0x000060000a0a8625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000060a098981ULL, 0x0004e2000c1e1900ULL,
0x00000004ff0f7819ULL, 0x000fe20000011602ULL, 0x00000100040e7824ULL, 0x040fe200078e00ffULL,
0x00000001040d7810ULL, 0x002fe20007ffe0ffULL, 0x0106880008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000020f127810ULL, 0x040fe20007ffe0ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000040f147810ULL, 0x000fe20007ffe0ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x0000000108117824ULL, 0x040fe200078e0212ULL,
0x0000000e030d7217ULL, 0x000fe20007800000ULL, 0x0000000108157824ULL, 0x040fe200078e0214ULL,
0x000000060f177810ULL, 0x000fe20007ffe0ffULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000711137812ULL, 0x000fe200078ec0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x00000007150b7812ULL, 0x004fe200078ec0ffULL, 0x0000000108187824ULL, 0x040fe200078e0217ULL,
0x0000000f130a7812ULL, 0x000fe200078e7802ULL, 0x00000001080e7824ULL, 0x000fe200078e020fULL,
0x000000200d0d7807ULL, 0x000fe20000000000ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000001011137824ULL, 0x000fe200078e020aULL,
0x0000000f0b0a7812ULL, 0x000fe200078e7802ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000718117812ULL, 0x000fe200078ec0ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x000000070e0b7812ULL, 0x000fe200078ec0ffULL, 0x0000001015167824ULL, 0x000fe200078e020aULL,
0x0000000f11117812ULL, 0x100fe200078e7802ULL, 0x000000ffff497224ULL, 0x000fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fc400078e7802ULL, 0x0000000d080d7217ULL, 0x000fe20007800000ULL,
0x0000001018187824ULL, 0x000fe400078e0211ULL, 0x000000100e117824ULL, 0x000fe400078e020bULL,
0x000000010d0d7824ULL, 0x000fe400078e0a08ULL, 0x000000405f0b7824ULL, 0x000fc600078e020eULL,
0x0000000d0f00720cULL, 0x080fe40003f26070ULL, 0x000000020b0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000040b157810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1200720cULL, 0x080fe40003f46070ULL,
0x0000000d1400720cULL, 0x000fe20003f06070ULL, 0x00005800090a7a24ULL, 0x008fc800078e02ffULL,
0x000000400a0a7824ULL, 0x000fca00078e00ffULL, 0x0000000b0a1c7210ULL, 0x040fe40007f7e0ffULL,
0x0000000f0a197210ULL, 0x000fe40007f9e0ffULL, 0x000000060b0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x00005e001c1a7a11ULL, 0x040fe200078640ffULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e00190f7a11ULL, 0x000fe400078840ffULL,
0x00005f001c1c7a11ULL, 0x000fc400018f441bULL, 0x000000150a157210ULL, 0x040fe40007f7e0ffULL,
0x0000000b0a0a7210ULL, 0x000fe40007fbe0ffULL, 0x00005f0019197a11ULL, 0x000fe200020f440eULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x00005e0015127a11ULL, 0x000fe200078840ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x000000f0101b7812ULL, 0x000fe400078ec0ffULL,
0x00005e000a147a11ULL, 0x000fc400078a40ffULL, 0x00005f0015157a11ULL, 0x000fe400020f440eULL,
0x0000001a1b0e7210ULL, 0x000fe40007f9e0ffULL, 0x00005f000a0a7a11ULL, 0x000fe400028f440bULL,
0x0000001b0f107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200020e061cULL,
0x0000000d1700720cULL, 0x000fe40003f66070ULL, 0x0000c000110b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200028e0619ULL, 0x0000001b12127210ULL, 0x000fc40007f9e0ffULL,
0x0000001b14147210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0005e2000c901c46ULL, 0x0000c000130d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff137224ULL, 0x000fe200020e0615ULL, 0x0000c00016177811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200028e060aULL, 0x0000c00018197811ULL, 0x000fe200078e20ffULL,
0x00000000100d7faeULL, 0x0003e2000d101c46ULL, 0xff317217ff0a7424ULL, 0x000fc600078e00ffULL,
0x0000000012177faeULL, 0x0003e2000c101c46ULL, 0x000000060400720cULL, 0x000fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x004fe400078e00ffULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff0e7f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff107f8cULL, 0x002e62000c80043fULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000cc9000000947ULL, 0x000fea0003800000ULL, 0x00000004005c7824ULL, 0x000fe400078e00ffULL,
0x000000020c0d7824ULL, 0x000fc400078e00ffULL, 0x00006400ff107624ULL, 0x002fe200078e00ffULL,
0x000000025c5d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5e7224ULL, 0x004fe400078e000fULL,
0x000000ffff357224ULL, 0x000fe400078e0011ULL, 0x000064000d107624ULL, 0x000fe400078e0210ULL,
0xff317217ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x00000100040c7824ULL, 0x000fca00078e00ffULL, 0x000000030c00720cULL, 0x000fda0003f06070ULL,
0x0000cb9000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe40007804835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0x00000003070e7812ULL, 0x000fe200078ec0ffULL, 0x00000300ff0c7624ULL, 0x000fe400078e00ffULL,
0x0000580009117a24ULL, 0x000fe200078e02ffULL, 0x000000030e00780cULL, 0x000fe20003f05270ULL,
0xfffffffd0d0c7424ULL, 0x000fe200078e020cULL, 0x00000004ff177819ULL, 0x000fe20000011602ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000010c0c7807ULL, 0x000fca0004000000ULL,
0x0000000107077824ULL, 0x000fca00078e020cULL, 0x000000050700720cULL, 0x000fe20003f06070ULL,
0x00000001083f7824ULL, 0x000fe200078e0217ULL, 0x00000002172e7810ULL, 0x000fe40007ffe0ffULL,
0x00000001040f7810ULL, 0x000fe40007ffe0ffULL, 0x000000073f137812ULL, 0x000fce00078ec0ffULL,
0x00000001070c8824ULL, 0x000fc800078e0210ULL, 0x000060000c0c8625ULL, 0x000fe200078e000dULL,
0x00000020040e7811ULL, 0x000fe400078e40ffULL, 0x000000205f167811ULL, 0x000fe400078e30ffULL,
0x000000060c098981ULL, 0x000362000c1e1900ULL, 0x000000060f00720cULL, 0x000fe20003f06070ULL,
0x00000040111c7824ULL, 0x000fe200078e00ffULL, 0x0000000e030f7217ULL, 0x000fe20007800000ULL,
0x000000013f117824ULL, 0x000fe200078e0216ULL, 0x0000000417127810ULL, 0x000fe20007ffe0ffULL,
0x0000001002227824ULL, 0x000fc400078e00ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0a0eULL,
0x000000111c1f7210ULL, 0x000fe20007f3e0ffULL, 0x00000001080d7824ULL, 0x042fe200078e022eULL,
0x0000000f130c7812ULL, 0x000fe200078e7802ULL, 0x0000000108197824ULL, 0x040fe200078e0212ULL,
0x0000000617137810ULL, 0x000fe20007ffe0ffULL, 0x000000010d147824ULL, 0x040fe200078e0216ULL,
0x000000070d157812ULL, 0x000fe200078ec0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0x000000200f0f7807ULL, 0x000fe20000000000ULL, 0x0000000108217824ULL, 0x000fe200078e0213ULL,
0x0000000f153c7812ULL, 0x000fe200078e7802ULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0x00005e001f187a11ULL, 0x000fc400078240ffULL, 0x0000000721157812ULL, 0x000fe200078ec0ffULL,
0x000000100d3c7824ULL, 0x000fe200078e023cULL, 0x00000007191b7812ULL, 0x000fe400078ec0ffULL,
0x0000000f153e7812ULL, 0x000fe200078e7802ULL, 0x0000000119157824ULL, 0x100fe200078e0216ULL,
0x0000000f080f7217ULL, 0x000fe20007800000ULL, 0x0000000121167824ULL, 0x000fe200078e0216ULL,
0x00005f001f1f7a11ULL, 0x000fe200008f440cULL, 0x00000010213e7824ULL, 0x000fe200078e023eULL,
0x0000000f1b0c7812ULL, 0x000fe200078e7802ULL, 0x000000010f0f7824ULL, 0x000fe200078e0a08ULL,
0x000000141c1a7210ULL, 0x000fc40007f5e0ffULL, 0x000000151c1b7210ULL, 0x000fe20007f7e0ffULL,
0x00000010193d7824ULL, 0x000fe200078e020cULL, 0x0000000f1700720cULL, 0x000fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x00005e001a0e7a11ULL, 0x000fe200078440ffULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005e001b1e7a11ULL, 0x000fe400078640ffULL,
0x000000161c1c7210ULL, 0x000fe40007f9e0ffULL, 0x000000f022177812ULL, 0x000fc400078ec0ffULL,
0x00005f001a1a7a11ULL, 0x000fe200010f440dULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005f001b1b7a11ULL, 0x000fe400018f440cULL, 0x00000017180c7210ULL, 0x000fe40007f5e0ffULL,
0x00005e001c207a11ULL, 0x040fe400078a40ffULL, 0x0000e0003f187811ULL, 0x000fe200078e20ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e061fULL, 0x00005f001c1c7a11ULL, 0x000fc400028f4419ULL,
0x000000170e0e7210ULL, 0x000fe40007fbe0ffULL, 0x0000000f2e00720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c187faeULL, 0x0003e2000c901c46ULL,
0x0000000f1200720cULL, 0x080fe40003f66070ULL, 0x0000000f1300720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200028e061aULL, 0x000000171e1e7210ULL, 0x080fe40007f3e0ffULL,
0x0000001720207210ULL, 0x000fc40007fbe0ffULL, 0x0000e0003c197811ULL, 0x000fe200078e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e061bULL, 0x0000e0003d1a7811ULL, 0x000fe200078e20ffULL,
0x000000ffff217224ULL, 0x000fe200028e061cULL, 0x0000e0003e1b7811ULL, 0x000fe200078e20ffULL,
0x000000000e197faeULL, 0x0005e8000d101c46ULL, 0x000000001e1a7faeULL, 0x0005e8000d901c46ULL,
0x00000000201b7faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff2c7f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff0f7984ULL, 0x004ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060800080c7f8cULL, 0x000fe2000c80043fULL,
0x800000000fff7812ULL, 0x004fc6000784485eULL, 0x01060c00081f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe4000782480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL, 0x0000000e000f7305ULL, 0x0004e4000021f000ULL,
0x3fa000000e0e7823ULL, 0x004fe200000100ffULL, 0x0000000f0000735dULL, 0x008fe40003800000ULL,
0x01060c00080f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fc4000782480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff0c7819ULL, 0x000fe40000011602ULL,
0x00000070221c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL,
0x000000011c1c7824ULL, 0x000fca00078e020dULL, 0x010000001c0d7984ULL, 0x000ea80000000800ULL,
0x010200001c0c7984ULL, 0x0007220000000800ULL, 0x0000000a0d00720bULL, 0x004fe20003f3d000ULL,
0x000147e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x008fc800008e0100ULL,
0x0000ffff0e0f7812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff237424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f65270ULL, 0x0000000a0d00720bULL, 0x000fe20003f34000ULL,
0x000147c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x000fe400008e0100ULL,
0x0000000d0a1f7209ULL, 0x000fe40007810000ULL, 0x0000ffff0e0e7812ULL, 0x000fe400078e3cffULL,
0x00000002ff627819ULL, 0x000fe20000011602ULL, 0x0104001f1c00b388ULL, 0x0005e20000000800ULL,
0x8000001f0a0a7221ULL, 0x000fe20000010000ULL, 0x0000000e0fff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a003b7308ULL, 0x0004e20000000800ULL,
0x000147827f007947ULL, 0x000fea000b800000ULL, 0x00001f623b0a7589ULL, 0x00c4e400000e0000ULL,
0x0000000862627810ULL, 0x006fe20007ffe0ffULL, 0x000147b27f007947ULL, 0x000fea000b800000ULL,
0x00001f623b3a7589ULL, 0x0002a400000e0000ULL, 0x8000001f0d0d1221ULL, 0x000fe20000010000ULL,
0x00000001ff237807ULL, 0x000fe20000800000ULL, 0x0000000a31317220ULL, 0x088fe40000410000ULL,
0x3fb8aa3b0d0d1820ULL, 0x000fe40000410000ULL, 0x0000000a30307220ULL, 0x080fe40000410000ULL,
0x0000000d001d1308ULL, 0x000ee20000000800ULL, 0x0000000a41417220ULL, 0x000fc40000410000ULL,
0x0000000a40407220ULL, 0x080fe40000410000ULL, 0x0000000a45457220ULL, 0x080fe40000410000ULL,
0x0000000a44447220ULL, 0x080fe40000410000ULL, 0x0000000a49497220ULL, 0x080fe40000410000ULL,
0x0000000a48487220ULL, 0x080fe40000410000ULL, 0x0000000a4d4d7220ULL, 0x000fc40000410000ULL,
0x0000000a4c4c7220ULL, 0x080fe40000410000ULL, 0x0000000a51517220ULL, 0x080fe40000410000ULL,
0x0000000a50507220ULL, 0x080fe40000410000ULL, 0x0000000a55557220ULL, 0x080fe40000410000ULL,
0x0000000a54547220ULL, 0x080fe40000410000ULL, 0x0000000a59597220ULL, 0x000fc40000410000ULL,
0x0000000a58587220ULL, 0x000fe40000410000ULL, 0x0000003b0b0b7220ULL, 0x000fe40000410000ULL,
0x0000003a33337220ULL, 0x084fe40000410000ULL, 0x0000003a32327220ULL, 0x080fe40000410000ULL,
0x0000003a43437220ULL, 0x080fe40000410000ULL, 0x0000003a42427220ULL, 0x000fc40000410000ULL,
0x0000003a47477220ULL, 0x080fe40000410000ULL, 0x0000003a46467220ULL, 0x080fe40000410000ULL,
0x0000003a4b4b7220ULL, 0x080fe40000410000ULL, 0x0000003a4a4a7220ULL, 0x080fe40000410000ULL,
0x0000003a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000003a4e4e7220ULL, 0x000fc40000410000ULL,
0x0000003a53537220ULL, 0x080fe40000410000ULL, 0x0000003a52527220ULL, 0x080fe40000410000ULL,
0x0000003a57577220ULL, 0x080fe40000410000ULL, 0x0000003a56567220ULL, 0x080fe40000410000ULL,
0x0000003a5b5b7220ULL, 0x080fe40000410000ULL, 0x0000003a5a5a7220ULL, 0x000fc40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e001fULL, 0x0000001d0c0c1220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b0c0b7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe4000782485eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0004e4000021f000ULL,
0x3fa000000c0c7823ULL, 0x004fe200000100ffULL, 0x0000000d0000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fc4000782485eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001dff0c723eULL, 0x000fe400000000ffULL,
0x00000004ff8e7819ULL, 0x100fe40000011602ULL, 0x00000002ff647819ULL, 0x000fe40000011602ULL,
0x000054100c3b7816ULL, 0x002fe2000000000cULL, 0x000144227f007947ULL, 0x000fea000b800000ULL,
0x00001f643b6b7589ULL, 0x0002a400000e0000ULL, 0x00000008642f7810ULL, 0x000fe20007ffe0ffULL,
0x000144627f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3b5e7589ULL, 0x00072400000e0000ULL,
0x0000001064657810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0065ULL, 0x00001dd000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0001550000007944ULL, 0x03cfea0003c00000ULL, 0x0000001864647810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x000fe200078e0064ULL,
0x00001e4000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0001549000007944ULL, 0x03cfea0003c00000ULL,
0x00000008020d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000005c020c7211ULL, 0x000fe400078fe0ffULL, 0x000000070d0f7812ULL, 0x140fe400078ec802ULL,
0x000000070d0d7812ULL, 0x000fc400078ef802ULL, 0x0000000c0f0c7212ULL, 0x000fe400078e3cffULL,
0x0000005d020e7211ULL, 0x000fe400078fe0ffULL, 0x0000991023237816ULL, 0x000fe200000000ffULL,
0x000000100d697824ULL, 0x000fe200078e020cULL, 0x0000000e0f0e7212ULL, 0x000fe400078e3cffULL,
0x000000ff2300720cULL, 0x000fe40003f25270ULL, 0x0000c000691e7811ULL, 0x000fe200078e20ffULL,
0x000000100d637824ULL, 0x040fe200078e020eULL, 0x000001000d0d7811ULL, 0x000fc600078e20ffULL,
0x000000001e28783bULL, 0x000e620000004200ULL, 0x0000c000631f7811ULL, 0x000fe200078e20ffULL,
0x000000010c687824ULL, 0x100fe400078e020dULL, 0x000000010e667824ULL, 0x000fe400078e020dULL,
0x000000001f34783bULL, 0x000ee20000004200ULL, 0x0000c00068207811ULL, 0x000fe400078e20ffULL,
0x0000c00066217811ULL, 0x000fc600078e20ffULL, 0x000000002024783bULL, 0x000f280000004200ULL,
0x00000000210c783bULL, 0x000ea20000004200ULL, 0x00000018ff727819ULL, 0x002fe20000011428ULL,
0x0000010028677824ULL, 0x040fe200078e00ffULL, 0x0000888028227816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001142aULL,
0x0000010029777824ULL, 0x000fe200078e00ffULL, 0x0000002200757306ULL, 0x0003e20000200c00ULL,
0x00000018ff677819ULL, 0x000fc40000011467ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff6e7819ULL, 0x008fe40000011434ULL, 0x00000018ff737819ULL, 0x000fe20000011429ULL,
0x0000002800797306ULL, 0x0007e20000200c00ULL, 0x000088802a227816ULL, 0x002fe400000000ffULL,
0x0000888029747816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc4000001142bULL, 0x00000018ff6c7819ULL, 0x000fe20000011436ULL,
0x00000022007b7306ULL, 0x0003e20000200c00ULL, 0x000001002a287824ULL, 0x048fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011435ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000006700767306ULL, 0x0006a20000200c00ULL, 0x0000888034227816ULL, 0x002fc400000000ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000018ff627819ULL, 0x010fe40000011424ULL,
0x00000018ff6a7819ULL, 0x000fe20000011425ULL, 0x00000028007c7306ULL, 0x0003220000200c00ULL,
0x000088802b677816ULL, 0x008fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe40000011437ULL,
0x00000018ff607819ULL, 0x004fc4000001140cULL, 0x00000018ff617819ULL, 0x000fe2000001140dULL,
0x0000002200817306ULL, 0x0005e20000200c00ULL, 0x0000010034287824ULL, 0x042fe200078e00ffULL,
0x0000541075767816ULL, 0x000fe20000000076ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x000088800d757816ULL, 0x000fe400000000ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000067007d7306ULL, 0x0003e20000200c00ULL, 0x0000888036227816ULL, 0x004fc400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x000054107b7c7816ULL, 0x010fe4000000007cULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0000002200877306ULL, 0x0005e20000200c00ULL,
0x0000000702677812ULL, 0x002fe400078ec0ffULL, 0x00000018ff387819ULL, 0x000fe4000001140eULL,
0x0000000867677812ULL, 0x000fc400078ef802ULL, 0x00000018ff3a7819ULL, 0x000fe20000011426ULL,
0x0000002a007f7306ULL, 0x0003e20000200c00ULL, 0x0000010024227824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011427ULL, 0x00000018ff397819ULL, 0x000fc8000001140fULL,
0x0000003400857306ULL, 0x0005e20000200c00ULL, 0x00000100352a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x00000029007a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x004fe40000011422ULL, 0x000000078e227812ULL, 0x000fca00078e7867ULL,
0x0000002800827306ULL, 0x0004e20000200c00ULL, 0x0000888035297816ULL, 0x002fe200000000ffULL,
0x0000000867227824ULL, 0x000fe400078e0222ULL, 0x0001000035357824ULL, 0x000fc800078e00ffULL,
0x0000007400787306ULL, 0x0003e20000200c00ULL, 0x0000010036287824ULL, 0x044fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000002900837306ULL, 0x0005e20000200c00ULL,
0x000001002b747824ULL, 0x042fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x0000541081827816ULL, 0x008fe40000000082ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000002a00847306ULL, 0x0002e20000200c00ULL,
0x0000888037297816ULL, 0x004fc400000000ffULL, 0x00000018ff2b7819ULL, 0x000fca000001142bULL,
0x0000002800887306ULL, 0x0005220000200c00ULL, 0x00000100372a7824ULL, 0x042fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001142aULL,
0x0000002900897306ULL, 0x0003e20000200c00ULL, 0x0000a00022287811ULL, 0x004fe400078e20ffULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000541083837816ULL, 0x008fc60000000084ULL,
0x00000036008b7306ULL, 0x0005e20000200c00ULL, 0x0000010025297824ULL, 0x002fe200078e00ffULL,
0x0000541087887816ULL, 0x010fcc0000000088ULL, 0x0000002b00807306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x004fce0000011429ULL, 0x0000002a008a7306ULL, 0x0002b00000200c00ULL,
0x00000074007e7306ULL, 0x0007220000200c00ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000003500867306ULL, 0x0009e20000200c00ULL, 0x0000888024747816ULL, 0x048fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000541089897816ULL, 0x004fca000000008aULL,
0x00000034008d7306ULL, 0x0005e20000200c00ULL, 0x0000888025357816ULL, 0x050fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x000054107d7d7816ULL, 0x000fc8000000007eULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x00000035008e7306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x004fe40000011424ULL, 0x0000888026247816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0000010026357824ULL, 0x048fe400078e00ffULL,
0x0001000026267824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x0000006b28289232ULL, 0x082fe20000000000ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000006b2a2a9232ULL, 0x000fe40000000000ULL,
0x0000005e29299232ULL, 0x080fe40000000000ULL, 0x0000005e2b2b9232ULL, 0x000fe20000000000ULL,
0x00000034008f7306ULL, 0x0003e20000200c00ULL, 0x0000541079727816ULL, 0x004fca0000000072ULL,
0x0000007c2850723cULL, 0x000fe40000001850ULL, 0x0000003600917306ULL, 0x0005e20000200c00ULL,
0x000001000c347824ULL, 0x002fe200078e00ffULL, 0x000054107a737816ULL, 0x008fc80000000073ULL,
0x000000822848723cULL, 0x000fe40000001848ULL, 0x0000003500957306ULL, 0x0003e20000200c00ULL,
0x0000888027367816ULL, 0x004fca00000000ffULL, 0x000000ffff237224ULL, 0x000fe200078e0036ULL,
0x000000722854723cULL, 0x000fe20000001854ULL, 0x0000002500937306ULL, 0x0005e20000200c00ULL,
0x00000018ff357819ULL, 0x002fe40000011434ULL, 0x000000072e347812ULL, 0x000fc800078e7867ULL,
0x000000882840723cULL, 0x000fe20000001840ULL, 0x0000002300907306ULL, 0x0003e20000200c00ULL,
0x0000010027257824ULL, 0x044fe400078e00ffULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011425ULL, 0x00000037008c7306ULL, 0x000fe20000200c00ULL,
0x0000000867237824ULL, 0x002fe200078e0234ULL, 0x000088800c257816ULL, 0x040fe200000000ffULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000a00023347811ULL, 0x000fe400078e20ffULL, 0x0000003600977306ULL, 0x0003e20000200c00ULL,
0x00000018ff0c7819ULL, 0x000fce000001140cULL, 0x0000003500927306ULL, 0x0005e20000200c00ULL,
0x000001000d367824ULL, 0x042fe400078e00ffULL, 0x000100000d0d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011436ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x000000003434783bULL, 0x004ea20000000200ULL, 0x00000018ff0d7819ULL, 0x000fcc000001140dULL,
0x0000007100717306ULL, 0x000ef00000200c00ULL, 0x0000006e006e7306ULL, 0x000f220000200c00ULL,
0x000054107f707816ULL, 0x002fce0000000070ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541080717816ULL, 0x008fce0000000071ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00005410856e7816ULL, 0x010fe2000000006eULL, 0x00000070284c723cULL, 0x000fec000000184cULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00005410866f7816ULL, 0x002fe2000000006fULL,
0x0000006b34349232ULL, 0x084fe20000000000ULL, 0x000088800e717816ULL, 0x000fe200000000ffULL,
0x0000006b36369232ULL, 0x000fe20000000000ULL, 0x000001000f6b7824ULL, 0x000fe200078e00ffULL,
0x0000005e35359232ULL, 0x000fc40000000000ULL, 0x0000000c00737306ULL, 0x0003e20000200c00ULL,
0x0000006e2844723cULL, 0x000fe20000001844ULL, 0x0000005e37379232ULL, 0x000fe20000000000ULL,
0x00000018ff6b7819ULL, 0x000fca000001146bULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000001000e0c7824ULL, 0x042fe400078e00ffULL, 0x000100000e0e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x00000018ff0e7819ULL, 0x000fce000001140eULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x0000541078777816ULL, 0x004fce0000000077ULL, 0x0000002400247306ULL, 0x000ea20000200c00ULL,
0x000054108b6c7816ULL, 0x002fe2000000006cULL, 0x000000762858723cULL, 0x000fec0000001858ULL,
0x0000000d00707306ULL, 0x0003e20000200c00ULL, 0x000054108c6d7816ULL, 0x008fce000000006dULL,
0x0000000c006e7306ULL, 0x0007e20000200c00ULL, 0x000088800f0d7816ULL, 0x042fe200000000ffULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x0000006c2828723cULL, 0x000fe80000001830ULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0000000d006f7306ULL, 0x0003e20000200c00ULL,
0x000054108f0c7816ULL, 0x008fce0000000062ULL, 0x0000006000607306ULL, 0x000ee20000200c00ULL,
0x00005410930d7816ULL, 0x002fce000000006aULL, 0x0000000c3454723cULL, 0x000fe20000001854ULL,
0x0000006100617306ULL, 0x000e6c0000200c00ULL, 0x00005410240c7816ULL, 0x004fe40000000095ULL,
0x00005410900d7816ULL, 0x000fe20000000097ULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0000541073607816ULL, 0x008fca0000000060ULL, 0x0000000c3450723cULL, 0x040fe20000001850ULL,
0x0000541070617816ULL, 0x002fe20000000061ULL, 0x0000003b003b7306ULL, 0x000fec0000200c00ULL,
0x000000603444723cULL, 0x000fe40000001844ULL, 0x0000007400747306ULL, 0x000e700000200c00ULL,
0x0000002500257306ULL, 0x000eb00000200c00ULL, 0x0000007500767306ULL, 0x0007e20000200c00ULL,
0x0000541074747816ULL, 0x002fce000000008dULL, 0x0000007200777306ULL, 0x000e620000200c00ULL,
0x000054108e757816ULL, 0x008fe40000000091ULL, 0x0000541025927816ULL, 0x004fca0000000092ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000000743458723cULL, 0x000fee0000001858ULL,
0x0000006b00307306ULL, 0x000ee20000200c00ULL, 0x0000541076937816ULL, 0x002fce0000000077ULL,
0x0000002600317306ULL, 0x000e620000200c00ULL, 0x00005410716e7816ULL, 0x004fe2000000006eULL,
0x000000923448723cULL, 0x000fec0000001848ULL, 0x0000000e00337306ULL, 0x000fe20000200c00ULL,
0x000054106f6f7816ULL, 0x008fce0000000030ULL, 0x00000027000c7306ULL, 0x000ea20000200c00ULL,
0x00005410313a7816ULL, 0x002fe2000000003aULL, 0x0000006e3440723cULL, 0x000fec0000001840ULL,
0x0000003800387306ULL, 0x000e700000200c00ULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x000054100c3b7816ULL, 0x004fce000000003bULL, 0x0000000f000e7306ULL, 0x000ea20000200c00ULL,
0x0000541033387816ULL, 0x002fe20000000038ULL, 0x0000003a344c723cULL, 0x000fe2000000184cULL,
0x000054100e397816ULL, 0x004fce0000000039ULL, 0x000000383434723cULL, 0x000fe20000001828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff0c7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000784480dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fc4000784480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0e7424ULL, 0x000fc800078e00ffULL,
0x0000000e000f7305ULL, 0x0002a4000021f000ULL, 0x3fa000000e0e7823ULL, 0x002fe200000100ffULL,
0x0000000f0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000784480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000802247211ULL, 0x000fe200078fe0ffULL, 0x00005800090c7a24ULL, 0x020fe200078e02ffULL,
0x00000040040e7811ULL, 0x000fc400078e40ffULL, 0x00000002022b7811ULL, 0x000fe200078fe0ffULL,
0x000000400c3a7824ULL, 0x000fe200078e00ffULL, 0x0000000e030d7217ULL, 0x000fe20007800000ULL,
0x000000405f247824ULL, 0x000fe200078e0224ULL, 0x00000004020f7811ULL, 0x000fe200078fe0ffULL,
0x00000001080c7824ULL, 0x000fe200078e022bULL, 0x0000000602297811ULL, 0x000fe200078fe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0eULL, 0x000000243a337210ULL, 0x000fe20007f5e0ffULL,
0x000000405f257824ULL, 0x000fe200078e020cULL, 0x00000004ff277819ULL, 0x000fe20000011602ULL,
0x0000000108267824ULL, 0x040fe200078e020fULL, 0x000000200d0d7807ULL, 0x000fe20000000000ULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x00005e0033287a11ULL, 0x000fe200078440ffULL,
0x000000405f267824ULL, 0x000fe200078e0226ULL, 0x0000000d080d7217ULL, 0x000fc40007800000ULL,
0x00005f0033337a11ULL, 0x000fe200010f440eULL, 0x00000001080e7824ULL, 0x000fe200078e0229ULL,
0x000000253a397210ULL, 0x040fe20007f5e0ffULL, 0x000000010d2a7824ULL, 0x000fe200078e0a08ULL,
0x000000263a317210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x00005e0039387a11ULL, 0x000fe200078440ffULL, 0x000000ffff327224ULL, 0x000fe200020e06ffULL,
0x0000002a2700720cULL, 0x000fe20003f66070ULL, 0x000000405f277824ULL, 0x000fe200078e020eULL,
0x00005f0039397a11ULL, 0x000fe400010f440cULL, 0x00000017280c7210ULL, 0x000fe40007f5e0ffULL,
0x0000c0003f287811ULL, 0x000fe400078e20ffULL, 0x00005e0031307a11ULL, 0x000fe200078840ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e0633ULL, 0x000000273a337210ULL, 0x000fc40007fde0ffULL,
0x00000017380e7210ULL, 0x000fe40007fbe0ffULL, 0x00005f0031317a11ULL, 0x000fe200020f4432ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c287faeULL, 0x0003e2000d901c46ULL,
0x000000ffff387224ULL, 0x000fe200030e06ffULL, 0x0000002a2b00720cULL, 0x080fe40003f46070ULL,
0x0000002a0f00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0639ULL,
0x00005e0033327a11ULL, 0x000fe400078640ffULL, 0x0000002a2900720cULL, 0x000fc40003fa6070ULL,
0x0000001730307210ULL, 0x080fe40007fde0ffULL, 0x00005f0033337a11ULL, 0x000fe400018f4438ULL,
0x0000001732327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff317224ULL, 0x000fe200030e0631ULL,
0x0000c0003c297811ULL, 0x000fe400078e20ffULL, 0x0000c0003d2a7811ULL, 0x000fe200078e20ffULL,
0x000000ffff337224ULL, 0x000fe200018e0633ULL, 0x0000c0003e2b7811ULL, 0x000fe200078e20ffULL,
0x000000000e297faeULL, 0x0005e8000d101c46ULL, 0x00000000302a7faeULL, 0x0005e8000e101c46ULL,
0x00000000322b7faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff0c7f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff0f7984ULL, 0x004e640000000800ULL, 0x800000000fff7812ULL, 0x002fc4000784482dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5e7224ULL, 0x000fe200078e000dULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x0106b400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000784482dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001dff0c723eULL, 0x000fe400000000ffULL,
0x00000002ff627819ULL, 0x000fe40000011602ULL, 0x000054100c3b7816ULL, 0x000fe2000000000cULL,
0x00012d127f007947ULL, 0x000fea000b800000ULL, 0x00001f623b6b7589ULL, 0x0002a400000e0000ULL,
0x00012d527f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3b6c7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0065ULL,
0x000035a000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00013d3000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0064ULL,
0x0000360000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00013cd000007944ULL, 0x01cfea0003c00000ULL,
0x0000e000692c7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e000632d7811ULL, 0x000fe400078e20ffULL, 0x0000e000680c7811ULL, 0x000fe200078e20ffULL,
0x000000002c3c783bULL, 0x000f620000004200ULL, 0x0000e000660d7811ULL, 0x000fc600078e20ffULL,
0x000000002d60783bULL, 0x002e680000004200ULL, 0x000000000c30783bULL, 0x000ee80000004200ULL,
0x000000000d38783bULL, 0x00cea20000004200ULL, 0x000088803c0e7816ULL, 0x060fe200000000ffULL,
0x000001003c0f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe2000001143dULL,
0x000001003d7a7824ULL, 0x040fe200078e00ffULL, 0x0000000e007b7306ULL, 0x0007e20000200c00ULL,
0x000088803d797816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fc4000001140fULL, 0x00000018ff777819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000000f007c7306ULL, 0x000be20000200c00ULL, 0x000088803e0e7816ULL, 0x048fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff757819ULL, 0x000fe2000001143eULL, 0x0000000e00817306ULL, 0x0007e20000200c00ULL,
0x000001003e0f7824ULL, 0x060fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x002fc40000011462ULL,
0x00000018ff0f7819ULL, 0x000fe4000001140fULL, 0x0000003d007f7306ULL, 0x0003e20000200c00ULL,
0x00008880600e7816ULL, 0x008fe400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff747819ULL, 0x000fe40000011461ULL, 0x00000018ff6f7819ULL, 0x000fe20000011430ULL,
0x0000000e00877306ULL, 0x0007e20000200c00ULL, 0x00000100613d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc40000011463ULL, 0x00000018ff707819ULL, 0x000fe40000011431ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000000f00827306ULL, 0x0003620000200c00ULL,
0x00008880620e7816ULL, 0x008fe400000000ffULL, 0x00000018ff737819ULL, 0x000fe40000011460ULL,
0x00000018ff6d7819ULL, 0x000fe40000011432ULL, 0x00000018ff6e7819ULL, 0x000fe20000011433ULL,
0x0000000e008d7306ULL, 0x0007e20000200c00ULL, 0x00000100600f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x004fe20000011438ULL, 0x0001000060607824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc40000011439ULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000003c007e7306ULL, 0x0003e20000200c00ULL, 0x00000100300e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000541081827816ULL, 0x020fe40000000082ULL,
0x00000018ff667819ULL, 0x000fe4000001143aULL, 0x0000007a00807306ULL, 0x0005e20000200c00ULL,
0x000088803f3c7816ULL, 0x002fc400000000ffULL, 0x00000018ff687819ULL, 0x000fca000001143bULL,
0x0000003c00837306ULL, 0x0003e20000200c00ULL, 0x00000018ff7a7819ULL, 0x004fe4000001140eULL,
0x00000007120e7812ULL, 0x000fca00078e7867ULL, 0x0000003d008c7306ULL, 0x0005e20000200c00ULL,
0x00008880613c7816ULL, 0x002fe200000000ffULL, 0x00000008670e7824ULL, 0x000fe400078e020eULL,
0x0001000061617824ULL, 0x000fc800078e00ffULL, 0x00000079007d7306ULL, 0x0003e20000200c00ULL,
0x00000100633d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc80000011461ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000000f00887306ULL, 0x0004e20000200c00ULL,
0x000001003f797824ULL, 0x042fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x0000003c00897306ULL, 0x0003620000200c00ULL,
0x00000100620f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000062627824ULL, 0x000fc600078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe4000001140fULL,
0x0000003d00927306ULL, 0x0005e20000200c00ULL, 0x00008880633c7816ULL, 0x042fe200000000ffULL,
0x0001000063637824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000541087887816ULL, 0x008fe40000000088ULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000003c008f7306ULL, 0x0002e20000200c00ULL, 0x00000100313d7824ULL, 0x004fe200078e00ffULL,
0x0000541089897816ULL, 0x020fcc000000008cULL, 0x0000006200907306ULL, 0x0005e20000200c00ULL,
0x0000a0000e3c7811ULL, 0x002fce00078e20ffULL, 0x0000003e00847306ULL, 0x000fe20000200c00ULL,
0x00000018ff627819ULL, 0x004fe4000001143dULL, 0x000054108f8f7816ULL, 0x008fca0000000092ULL,
0x0000003f00857306ULL, 0x0003f00000200c00ULL, 0x00000061008b7306ULL, 0x0005e20000200c00ULL,
0x000000003c3c783bULL, 0x002e6e0000000200ULL, 0x0000000f008e7306ULL, 0x0007620000200c00ULL,
0x0000888030617816ULL, 0x044fe200000000ffULL, 0x0001000030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x00008880310f7816ULL, 0x048fe200000000ffULL, 0x0001000031317824ULL, 0x000fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000003000947306ULL, 0x0007e20000200c00ULL,
0x000054108d8e7816ULL, 0x020fce000000008eULL, 0x0000000f00937306ULL, 0x000be20000200c00ULL,
0x0000010033307824ULL, 0x008fe200078e00ffULL, 0x000054107e7e7816ULL, 0x004fc80000000077ULL,
0x00000018ff977819ULL, 0x000fe40000011430ULL, 0x0000000713307812ULL, 0x000fe200078e7867ULL,
0x00000100320f7824ULL, 0x020fe200078e00ffULL, 0x0000006300917306ULL, 0x000fe20000200c00ULL,
0x0000006b3c3c9232ULL, 0x082fe40000000000ULL, 0x0000006b3e3e9232ULL, 0x000fe20000000000ULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x0000006c3d3d9232ULL, 0x090fe40000000000ULL,
0x0000006c3f3f9232ULL, 0x000fe20000000000ULL, 0x0000000f00637306ULL, 0x0003ec0000200c00ULL,
0x000000883c48723cULL, 0x000fe40000001848ULL, 0x0000003100957306ULL, 0x0005e20000200c00ULL,
0x00000008670f7824ULL, 0x002fe200078e0230ULL, 0x000054107b307816ULL, 0x000fc8000000007cULL,
0x0000008e3c40723cULL, 0x000fe40000001840ULL, 0x0000007900867306ULL, 0x0002e20000200c00ULL,
0x000054107d317816ULL, 0x004fce0000000080ULL, 0x00000060008a7306ULL, 0x0005e20000200c00ULL,
0x0000888033797816ULL, 0x042fe200000000ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x000000303c58723cULL, 0x000fe80000001858ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000006200967306ULL, 0x000fe20000200c00ULL, 0x0000888032607816ULL, 0x044fe200000000ffULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x0000a0000f307811ULL, 0x000fe200078e20ffULL,
0x0000010038317824ULL, 0x000fe200078e00ffULL, 0x0000541083837816ULL, 0x008fc40000000086ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003300677306ULL, 0x000fe20000200c00ULL,
0x00000018ff777819ULL, 0x000fc60000011431ULL, 0x000000823c50723cULL, 0x000fe80000001850ULL,
0x0000003200627306ULL, 0x0003f00000200c00ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x000000003030783bULL, 0x002e6e0000000200ULL, 0x0000007500757306ULL, 0x000ef00000200c00ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x000054107f7f7816ULL, 0x004fc40000000078ULL,
0x0000888039787816ULL, 0x000fca00000000ffULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x0000541084847816ULL, 0x008fe20000000075ULL, 0x0000007e3c54723cULL, 0x000fec0000001854ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000541085857816ULL, 0x010fce0000000076ULL,
0x0000007100717306ULL, 0x000f220000200c00ULL, 0x000054108a8a7816ULL, 0x004fe20000000073ULL,
0x000000843c4c723cULL, 0x000fe2000000184cULL, 0x000088803a737816ULL, 0x040fe200000000ffULL,
0x0000006b30309232ULL, 0x082fe40000000000ULL, 0x0000006b32329232ULL, 0x000fe20000000000ULL,
0x000001003a6b7824ULL, 0x040fe200078e00ffULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000054108b8b7816ULL, 0x008fe20000000074ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000006c31319232ULL, 0x080fe20000000000ULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000006c33339232ULL, 0x000fc40000000000ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000009700987306ULL, 0x0005e20000200c00ULL, 0x0000541090907816ULL, 0x010fe20000000071ULL,
0x0000008a3c44723cULL, 0x000fe20000001844ULL, 0x000000ffff717224ULL, 0x000fe200078e0073ULL,
0x0000541091917816ULL, 0x002fc80000000072ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000888038977816ULL, 0x044fe200000000ffULL, 0x0001000038387824ULL, 0x000fc800078e00ffULL,
0x000000ffff7b7224ULL, 0x000fe200078e0097ULL, 0x000000903c34723cULL, 0x000fe20000001834ULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000007a007a7306ULL, 0x000e6a0000200c00ULL,
0x000001003b3e7824ULL, 0x040fe200078e00ffULL, 0x000088803b3d7816ULL, 0x040fe200000000ffULL,
0x000100003b3f7824ULL, 0x000fe200078e00ffULL, 0x0000007b007c7306ULL, 0x0005e40000200c00ULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x00000018ff3f7819ULL, 0x000fc8000001143fULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x00000100397b7824ULL, 0x004fe200078e00ffULL,
0x00005410617a7816ULL, 0x002fe2000000007aULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000541060607816ULL, 0x008fce0000000063ULL,
0x0000007000707306ULL, 0x000eb00000200c00ULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x0000541094947816ULL, 0x002fce000000006fULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541095957816ULL, 0x004fce0000000070ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541062627816ULL, 0x008fe2000000006dULL, 0x000000943054723cULL, 0x000fec0000001854ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541067637816ULL, 0x002fce000000006eULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x00000062304c723cULL, 0x000fee000000184cULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541079617816ULL, 0x002fce0000000098ULL, 0x0000007b007d7306ULL, 0x0002e20000200c00ULL,
0x000054107c7c7816ULL, 0x004fe20000000077ULL, 0x000000603050723cULL, 0x000fec0000001850ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x00005410937b7816ULL, 0x002fce0000000096ULL,
0x0000003900397306ULL, 0x000e620000200c00ULL, 0x00005410787d7816ULL, 0x008fe2000000007dULL,
0x0000007a3058723cULL, 0x040fec0000001858ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541038387816ULL, 0x004fe20000000069ULL, 0x0000007c3048723cULL, 0x000fec0000001848ULL,
0x0000006b003c7306ULL, 0x000ea20000200c00ULL, 0x0000541039397816ULL, 0x002fce000000006aULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000000383044723cULL, 0x000fee0000001844ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x00005410713c7816ULL, 0x004fce000000003cULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000054103d3d7816ULL, 0x002fce000000003eULL, 0x0000003a003b7306ULL, 0x000e620000200c00ULL,
0x0000003c3040723cULL, 0x000fee0000001840ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x000054103b667816ULL, 0x002fe40000000066ULL, 0x000054103f677816ULL, 0x004fce0000000068ULL,
0x000000663030723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff347f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004004347811ULL, 0x002fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000340300720cULL, 0x000fda0003f24070ULL,
0x000094b000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff347984ULL, 0x000e640000000800ULL,
0x8000000034ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff347984ULL, 0x000e640000000800ULL, 0x8000000034ff7812ULL, 0x002fe40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff347424ULL, 0x000fc800078e00ffULL, 0x0000003400367305ULL, 0x0002a4000021f000ULL,
0x3fa0000034347823ULL, 0x002fe200000100ffULL, 0x000000360000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fc40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff347424ULL, 0x000fe200078e00ffULL,
0x0000000307367812ULL, 0x000fe200078ec0ffULL, 0x00000300ff357624ULL, 0x000fc600078e00ffULL,
0x000000033600780cULL, 0x000fe20003f25270ULL, 0xfffffffd34357424ULL, 0x000fca00078e0235ULL,
0x0000000135367807ULL, 0x000fca0004800000ULL, 0x0000000107077824ULL, 0x000fe400078e0236ULL,
0x0000580009367a24ULL, 0x000fe400078e02ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000050700720cULL, 0x000fe20003f26070ULL, 0x0000004036387824ULL, 0x000fe200078e00ffULL,
0x0000006004367811ULL, 0x000fd600078e40ffULL, 0x0000000107359824ULL, 0x000fc800078e0210ULL,
0x0000600035349625ULL, 0x000fe200078e0034ULL, 0x0000003603377217ULL, 0x000fc80007800000ULL,
0x0000000634099981ULL, 0x000362000c1e1900ULL, 0x0000001138397210ULL, 0x040fe20007f3e0ffULL,
0x0000000137377824ULL, 0x000fe200078e0a36ULL, 0x00000015383b7210ULL, 0x040fe40007f5e0ffULL,
0x00000016383d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005e00393c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff607224ULL, 0x000fe200010e06ffULL,
0x0000002037377807ULL, 0x000fe20000000000ULL, 0x000000ffff667224ULL, 0x000fe200018e06ffULL,
0x00005f00393a7a11ULL, 0x000fc400008f443aULL, 0x0000001438367210ULL, 0x000fe40007f3e0ffULL,
0x0000003708377217ULL, 0x000fe40007800000ULL, 0x00000004ff347819ULL, 0x002fe20000011602ULL,
0x000000ffff357224ULL, 0x000fe200008e06ffULL, 0x00005e00363e7a11ULL, 0x040fe200078240ffULL,
0x0000000137397824ULL, 0x000fe200078e0a08ULL, 0x00005e003b627a11ULL, 0x000fe400078440ffULL,
0x00005f0036377a11ULL, 0x000fc400008f4435ULL, 0x000000393400720cULL, 0x000fe40003f26070ULL,
0x000000173c347210ULL, 0x080fe40007f9e0ffULL, 0x000000173e367210ULL, 0x000fe40007fbe0ffULL,
0x00005f003b607a11ULL, 0x000fe200010f4460ULL, 0x000000ffff357224ULL, 0x000fe200020e063aULL,
0x00005e003d3c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x000000392e00720cULL, 0x000fc40003f86070ULL, 0x000000391200720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034187faeULL, 0x0003e2000c901c46ULL,
0x000000391300720cULL, 0x000fe40003fa6070ULL, 0x0000001762387210ULL, 0x080fe40007f7e0ffULL,
0x00005f003d667a11ULL, 0x000fe400010f4466ULL, 0x000000173c3a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe400018e0660ULL, 0x0000000036197faeULL, 0x0003e4000e101c46ULL,
0x000000ffff3b7224ULL, 0x000fc400010e0666ULL, 0x00000000381a7faeULL, 0x0003e8000f101c46ULL,
0x000000003a1b7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff667f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff377984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106280008347f8cULL, 0x000fe2000c80043fULL,
0x8000000037ff7812ULL, 0x002fc6000784485eULL, 0x01062c0008397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff367424ULL, 0x000fc800078e00ffULL, 0x0000003600377305ULL, 0x0002e4000021f000ULL,
0x3fa0000036367823ULL, 0x002fe200000100ffULL, 0x000000370000735dULL, 0x008fe40003800000ULL,
0x01062c0008377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fc40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010080001c377984ULL, 0x000e680000000800ULL,
0x010280001c367984ULL, 0x0007220000000800ULL, 0x0000000a3700720bULL, 0x002fe20003f3d000ULL,
0x000116627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x008fc800008e0100ULL,
0x0000ffff343a7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff797424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f65270ULL, 0x0000000a3700720bULL, 0x000fe20003f34000ULL,
0x000116427f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x000fe400008e0100ULL,
0x000000370a357209ULL, 0x000fe40007810000ULL, 0x0000ffff34397812ULL, 0x000fe400078e3cffULL,
0x00000002ff627819ULL, 0x000fe20000011602ULL, 0x800000350a387221ULL, 0x000fe20000010000ULL,
0x010480351c00b388ULL, 0x0003e20000000800ULL, 0x000000393aff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b38387820ULL, 0x000fc80000410000ULL, 0x00000038003b7308ULL, 0x000ee40000000800ULL,
0x0000003b0b0b7220ULL, 0x008fe20000410000ULL, 0x000115f27f007947ULL, 0x000fea000b800000ULL,
0x00001f623b3a7589ULL, 0x0022e400000e0000ULL, 0x0000003a58587220ULL, 0x08cfe40000410000ULL,
0x0000003a59597220ULL, 0x080fe40000410000ULL, 0x0000003a54547220ULL, 0x080fe40000410000ULL,
0x0000003a55557220ULL, 0x080fe40000410000ULL, 0x0000003a50507220ULL, 0x000fc40000410000ULL,
0x0000003a51517220ULL, 0x080fe40000410000ULL, 0x0000003a4c4c7220ULL, 0x080fe40000410000ULL,
0x0000003a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000003a48487220ULL, 0x080fe40000410000ULL,
0x0000003a49497220ULL, 0x080fe40000410000ULL, 0x0000003a44447220ULL, 0x000fc40000410000ULL,
0x0000003a45457220ULL, 0x080fe40000410000ULL, 0x0000003a40407220ULL, 0x080fe40000410000ULL,
0x0000003a41417220ULL, 0x080fe40000410000ULL, 0x0000003a30307220ULL, 0x080fe40000410000ULL,
0x0000003a31317220ULL, 0x000fe20000410000ULL, 0x000115227f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b3a7589ULL, 0x0004e400000e0000ULL, 0x000000370a0a7209ULL, 0x000fe20007810000ULL,
0x0000003a5a5a7220ULL, 0x08cfe20000410000ULL, 0x00000001ff797807ULL, 0x000fe20000800000ULL,
0x0000003a5b5b7220ULL, 0x000fc40000410000ULL, 0x8000000a37371221ULL, 0x000fe40000010000ULL,
0x0000003a56567220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b37371820ULL, 0x000fe40000410000ULL,
0x0000003a57577220ULL, 0x080fe40000410000ULL, 0x00000037001d1308ULL, 0x000ea20000000800ULL,
0x0000003a52527220ULL, 0x080fe40000410000ULL, 0x0000003a53537220ULL, 0x000fc40000410000ULL,
0x0000003a4e4e7220ULL, 0x080fe40000410000ULL, 0x0000003a4f4f7220ULL, 0x080fe40000410000ULL,
0x0000003a4a4a7220ULL, 0x080fe40000410000ULL, 0x0000003a4b4b7220ULL, 0x080fe40000410000ULL,
0x0000003a46467220ULL, 0x080fe40000410000ULL, 0x0000003a47477220ULL, 0x000fc40000410000ULL,
0x0000003a42427220ULL, 0x080fe40000410000ULL, 0x0000003a43437220ULL, 0x080fe40000410000ULL,
0x0000003a32327220ULL, 0x080fe40000410000ULL, 0x0000003a33337220ULL, 0x000fe40000410000ULL,
0x000000361d361220ULL, 0x014fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000b360b7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fc4000782485eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff347424ULL, 0x000fc800078e00ffULL,
0x0000003400357305ULL, 0x000724000021f000ULL, 0x3fa0000034347823ULL, 0x008fe200000100ffULL,
0x000000350000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fe4000782485eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001dff34723eULL, 0x000fe400000000ffULL, 0x00000002ff627819ULL, 0x002fc40000011602ULL,
0x00005410343b7816ULL, 0x000fe20000000034ULL, 0x000112c27f007947ULL, 0x000fea000b800000ULL,
0x00001f623b6d7589ULL, 0x0002e400000e0000ULL, 0x000113027f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b6c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0065ULL, 0x0000523000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x000120a000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0064ULL, 0x0000529000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0001204000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001e34783bULL, 0x000f280000004200ULL, 0x000000001f60783bULL, 0x002e680000004200ULL,
0x00000000203c783bULL, 0x000ee80000004200ULL, 0x000000002138783bULL, 0x014ea20000004200ULL,
0x00000018ff777819ULL, 0x000fe20000011434ULL, 0x00000100347b7824ULL, 0x040fe200078e00ffULL,
0x00008880347a7816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011435ULL, 0x00000100357d7824ULL, 0x040fe200078e00ffULL,
0x00008880357c7816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007a007f7306ULL, 0x0009e20000200c00ULL,
0x00000018ff757819ULL, 0x000fc40000011436ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff737819ULL, 0x002fe20000011460ULL,
0x0000003400827306ULL, 0x0003e20000200c00ULL, 0x00008880367a7816ULL, 0x010fe400000000ffULL,
0x00000018ff767819ULL, 0x000fe40000011437ULL, 0x00000018ff747819ULL, 0x000fc40000011461ULL,
0x00000018ff717819ULL, 0x000fe20000011462ULL, 0x0000003500837306ULL, 0x0009e20000200c00ULL,
0x0000010036347824ULL, 0x042fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011463ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x008fe4000001143cULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000010060357824ULL, 0x010fe200078e00ffULL, 0x0000003400867306ULL, 0x0003e20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff707819ULL, 0x000fe4000001143dULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x000088803d7e7816ULL, 0x000fe200000000ffULL,
0x0000003600887306ULL, 0x0007e20000200c00ULL, 0x0000888060347816ULL, 0x042fe200000000ffULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001143eULL,
0x00000018ff6e7819ULL, 0x000fc4000001143fULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000007b00807306ULL, 0x0003e20000200c00ULL, 0x0000010061367824ULL, 0x008fe200078e00ffULL,
0x00000018ff697819ULL, 0x004fe40000011438ULL, 0x00000018ff6a7819ULL, 0x000fe40000011439ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000007c00817306ULL, 0x0005e20000200c00ULL,
0x00008880377b7816ULL, 0x002fc400000000ffULL, 0x0000888038997816ULL, 0x000fe400000000ffULL,
0x00000018ff687819ULL, 0x000fe4000001143bULL, 0x00000018ff5e7819ULL, 0x000fe2000001143aULL,
0x00000034008b7306ULL, 0x0003e20000200c00ULL, 0x00000100377c7824ULL, 0x044fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000035008c7306ULL, 0x0004e20000200c00ULL, 0x0000888062347816ULL, 0x002fe400000000ffULL,
0x00000018ff377819ULL, 0x000fca0000011437ULL, 0x0000007a00857306ULL, 0x0003220000200c00ULL,
0x0000010062357824ULL, 0x044fe400078e00ffULL, 0x0001000062627824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003600907306ULL, 0x0005e20000200c00ULL,
0x00008880617a7816ULL, 0x042fe200000000ffULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x000054108b8c7816ULL, 0x008fc8000000008cULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000003400917306ULL, 0x0003e20000200c00ULL, 0x0000010063367824ULL, 0x004fe200078e00ffULL,
0x0000541085867816ULL, 0x010fcc0000000086ULL, 0x0000007b00877306ULL, 0x0005e20000200c00ULL,
0x000001003c347824ULL, 0x002fce00078e00ffULL, 0x00000060008e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x004fe40000011434ULL, 0x0000a80022347811ULL, 0x000fca00078e20ffULL,
0x0000003700897306ULL, 0x0005e20000200c00ULL, 0x00000018ff607819ULL, 0x002fe40000011436ULL,
0x00000018ff367819ULL, 0x000fe40000011462ULL, 0x000088803c627816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe400078e00ffULL, 0x0000003500927306ULL, 0x0002e20000200c00ULL,
0x0000888063377816ULL, 0x044fe200000000ffULL, 0x0001000063637824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc8000001143cULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x00000061008f7306ULL, 0x0005e20000200c00ULL, 0x000001003d357824ULL, 0x042fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fca00078e00ffULL, 0x0000003700937306ULL, 0x000fe20000200c00ULL,
0x00000018ff617819ULL, 0x004fe40000011435ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000541091927816ULL, 0x008fc60000000092ULL, 0x0000003600947306ULL, 0x0003f00000200c00ULL,
0x0000006300957306ULL, 0x0005e20000200c00ULL, 0x000000003434783bULL, 0x002e6e0000000200ULL,
0x0000006100977306ULL, 0x0007e20000200c00ULL, 0x000001003e637824ULL, 0x004fce00078e00ffULL,
0x0000007d00847306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x008fe40000011463ULL,
0x0000991079637816ULL, 0x000fc800000000ffULL, 0x000000ff6300720cULL, 0x000fe20003f25270ULL,
0x0000007c008a7306ULL, 0x000eb00000200c00ULL, 0x0000003c007c7306ULL, 0x0007f00000200c00ULL,
0x0000007700777306ULL, 0x000f220000200c00ULL, 0x000001003f3c7824ULL, 0x008fe200078e00ffULL,
0x0000006d34349232ULL, 0x082fe20000000000ULL, 0x0000541087877816ULL, 0x004fe2000000008aULL,
0x0000006d36369232ULL, 0x000fc40000000000ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006c35359232ULL, 0x080fe20000000000ULL, 0x0000003d007d7306ULL, 0x0003e20000200c00ULL,
0x0000006c37379232ULL, 0x000fce0000000000ULL, 0x0000003c00987306ULL, 0x0005e20000200c00ULL,
0x00005410813d7816ULL, 0x002fe20000000084ULL, 0x000000863450723cULL, 0x000fe20000001850ULL,
0x0000541082827816ULL, 0x010fe20000000077ULL, 0x0000010039817824ULL, 0x000fc800078e00ffULL,
0x0000007a008d7306ULL, 0x0002e20000200c00ULL, 0x000054107f3c7816ULL, 0x004fe20000000080ULL,
0x000000ffff7f7224ULL, 0x000fe200078e0099ULL, 0x0000888039807816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc60000011481ULL,
0x0000006000967306ULL, 0x0005220000200c00ULL, 0x000088803f7a7816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000003c3458723cULL, 0x000fe20000001858ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000000ffff797224ULL, 0x000fe200078e007aULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000088803e607816ULL, 0x044fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000a800233c7811ULL, 0x000fe200078e20ffULL, 0x00000100383d7824ULL, 0x040fe200078e00ffULL,
0x000054108d8d7816ULL, 0x008fe20000000090ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003f00637306ULL, 0x000fe20000200c00ULL,
0x00000018ff777819ULL, 0x000fc4000001143dULL, 0x0000541093937816ULL, 0x010fe20000000096ULL,
0x0000008c3448723cULL, 0x000fe20000001848ULL, 0x00000018ff387819ULL, 0x000fc60000011438ULL,
0x0000003e007a7306ULL, 0x0005e20000200c00ULL, 0x0000541083837816ULL, 0x002fc60000000078ULL,
0x000000923440723cULL, 0x040fe80000001840ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000000003c3c783bULL, 0x004ea60000000200ULL, 0x000000823454723cULL, 0x000fe80000001854ULL,
0x0000007600767306ULL, 0x000ef00000200c00ULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x0000541088887816ULL, 0x002fce0000000075ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000541089897816ULL, 0x008fce0000000076ULL, 0x0000007100717306ULL, 0x000ee20000200c00ULL,
0x000054108e8e7816ULL, 0x010fe20000000073ULL, 0x00000088344c723cULL, 0x000fe2000000184cULL,
0x000088803a737816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000f220000200c00ULL,
0x000054108f8f7816ULL, 0x002fe20000000074ULL, 0x0000006d3c3c9232ULL, 0x084fe40000000000ULL,
0x0000006d3e3e9232ULL, 0x000fe20000000000ULL, 0x000001003a6d7824ULL, 0x040fe200078e00ffULL,
0x0000006c3d3d9232ULL, 0x080fe20000000000ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541094947816ULL, 0x008fe20000000071ULL,
0x0000008e3444723cULL, 0x000fe20000001844ULL, 0x0000006c3f3f9232ULL, 0x000fe20000000000ULL,
0x000000ffff717224ULL, 0x000fe200078e0073ULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x0000541095957816ULL, 0x010fce0000000072ULL, 0x0000007e007e7306ULL, 0x000ea20000200c00ULL,
0x000000943430723cULL, 0x000fee0000001830ULL, 0x0000541062347816ULL, 0x002fe2000000007bULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000088803b377816ULL, 0x000fc400000000ffULL,
0x000054107e357816ULL, 0x004fca0000000097ULL, 0x0000006100617306ULL, 0x000e640000200c00ULL,
0x000000343c58723cULL, 0x000fec0000001858ULL, 0x0000007900797306ULL, 0x000ea20000200c00ULL,
0x000001003b357824ULL, 0x040fe400078e00ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x0000006f006f7306ULL, 0x000ee20000200c00ULL, 0x000000ffff347224ULL, 0x000fe200078e0037ULL,
0x00000018ff377819ULL, 0x000fe40000011435ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000541060607816ULL, 0x002fe40000000061ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x0000541079617816ULL, 0x004fce0000000098ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x000054107c7c7816ULL, 0x008fe2000000006fULL, 0x000000603c50723cULL, 0x000fec0000001850ULL,
0x0000007000707306ULL, 0x000eb00000200c00ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x0000541034377816ULL, 0x002fce0000000037ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054107d7d7816ULL, 0x004fce0000000070ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000054107a627816ULL, 0x008fe2000000006bULL, 0x0000007c3c54723cULL, 0x000fec0000001854ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541063637816ULL, 0x002fce000000006eULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000623c4c723cULL, 0x000fee000000184cULL,
0x0000007f007f7306ULL, 0x000ff00000200c00ULL, 0x0000007700787306ULL, 0x000e700000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000054107f787816ULL, 0x002fce0000000078ULL, 0x0000003800387306ULL, 0x000e700000200c00ULL,
0x0000003900397306ULL, 0x000ee20000200c00ULL, 0x0000541080797816ULL, 0x004fce0000000081ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541038387816ULL, 0x002fe20000000069ULL,
0x000000783c48723cULL, 0x000fec0000001848ULL, 0x0000006d00367306ULL, 0x000e620000200c00ULL,
0x0000541039397816ULL, 0x008fce000000006aULL, 0x0000003a00357306ULL, 0x000ea20000200c00ULL,
0x000000383c44723cULL, 0x000fee0000001844ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541071367816ULL, 0x002fce0000000036ULL, 0x0000003b003b7306ULL, 0x000e620000200c00ULL,
0x0000541035347816ULL, 0x004fe2000000005eULL, 0x000000363c40723cULL, 0x000fe20000001840ULL,
0x000054103b357816ULL, 0x002fce0000000068ULL, 0x000000343c3c723cULL, 0x000fe20000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007844831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007844831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff327424ULL, 0x000fc800078e00ffULL,
0x0000003200337305ULL, 0x0002a4000021f000ULL, 0x3fa0000032327823ULL, 0x002fe200000100ffULL,
0x000000330000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe40007844831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000580009307a24ULL, 0x020fc800078e02ffULL, 0x0000004030327824ULL, 0x000fe200078e00ffULL,
0x0000008004307811ULL, 0x000fc800078e40ffULL, 0x0000003003317217ULL, 0x000fe40007800000ULL,
0x0000002432337210ULL, 0x040fe40007f5e0ffULL, 0x0000002532357210ULL, 0x000fe20007f7e0ffULL,
0x0000000131317824ULL, 0x000fe400078e0a30ULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0033367a11ULL, 0x000fe200078440ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x00005e00353a7a11ULL, 0x000fc400078640ffULL, 0x0000002031317807ULL, 0x000fe40000000000ULL,
0x00005f0033337a11ULL, 0x000fe400010f4434ULL, 0x00005f0035387a11ULL, 0x000fe400018f4438ULL,
0x0000002632307210ULL, 0x040fe40007f5e0ffULL, 0x0000002732397210ULL, 0x000fe40007f7e0ffULL,
0x0000003108317217ULL, 0x000fe20007800000ULL, 0x000000ffff357224ULL, 0x000fe200010e06ffULL,
0x00005e0030347a11ULL, 0x000fe200078440ffULL, 0x000000ffff5e7224ULL, 0x000fe200018e06ffULL,
0x00005e0039607a11ULL, 0x000fe200078640ffULL, 0x0000000131377824ULL, 0x000fe200078e0a08ULL,
0x00000004ff327819ULL, 0x000fc40000011602ULL, 0x00005f0030357a11ULL, 0x000fe400010f4435ULL,
0x00005f00395e7a11ULL, 0x000fe400018f445eULL, 0x0000001736307210ULL, 0x000fe40007f7e0ffULL,
0x000000373200720cULL, 0x000fe40003f46070ULL, 0x000000173a327210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200018e0633ULL, 0x0000001734347210ULL, 0x000fc40007fbe0ffULL,
0x000000372e00720cULL, 0x080fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200020e0638ULL,
0x000000371200720cULL, 0x080fe20003f86070ULL, 0x000000ffff357224ULL, 0x000fe200028e0635ULL,
0x000000371300720cULL, 0x000fe40003fa6070ULL, 0x0000001760367210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030287faeULL, 0x0003e8000d101c46ULL,
0x000000ffff377224ULL, 0x000fc400030e065eULL, 0x0000000032297faeULL, 0x0003e8000d901c46ULL,
0x00000000342a7faeULL, 0x0003e8000e101c46ULL, 0x00000000362b7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fc40007844867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0031ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007844867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fc800078e00ffULL,
0x0000003000317305ULL, 0x0002a4000021f000ULL, 0x3fa0000030307823ULL, 0x002fe200000100ffULL,
0x000000310000735dULL, 0x004fe40003800000ULL, 0x0106b400ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fc40007844867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001dff30723eULL, 0x000fe400000000ffULL, 0x00000002ff627819ULL, 0x000fe40000011602ULL,
0x00005410303b7816ULL, 0x000fe20000000030ULL, 0x0000fdf27f007947ULL, 0x000fea000b800000ULL,
0x00001f623b6b7589ULL, 0x0002a400000e0000ULL, 0x0000fe327f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b6a7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0065ULL, 0x000067d000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00010b0000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0064ULL, 0x0000683000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00010aa000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002c38783bULL, 0x00ee680000004200ULL, 0x000000002d60783bULL, 0x000fe80000004200ULL,
0x000000000c30783bULL, 0x000ea80000004200ULL, 0x000000000d34783bULL, 0x000ee20000004200ULL,
0x00000018ff767819ULL, 0x002fe20000011438ULL, 0x0000010038797824ULL, 0x040fe200078e00ffULL,
0x0000888038787816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011439ULL, 0x00000100397c7824ULL, 0x040fe200078e00ffULL,
0x00008880397a7816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x00000018ff747819ULL, 0x000fe2000001143aULL, 0x0000010031927824ULL, 0x004fe200078e00ffULL,
0x000088803a7f7816ULL, 0x000fc400000000ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x00000038007b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff757819ULL, 0x000fe4000001143bULL, 0x000088803b817816ULL, 0x000fe400000000ffULL,
0x00000018ff737819ULL, 0x000fe40000011461ULL, 0x0000888061867816ULL, 0x000fe200000000ffULL,
0x0000007c007d7306ULL, 0x0005e20000200c00ULL, 0x000001003a387824ULL, 0x042fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011460ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fc40000011462ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000039007e7306ULL, 0x0003e20000200c00ULL,
0x000001003b7c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011430ULL,
0x00000018ff6f7819ULL, 0x000fe40000011431ULL, 0x0000003800807306ULL, 0x0005e20000200c00ULL,
0x0000010060397824ULL, 0x002fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fc4000001143bULL,
0x00000018ff717819ULL, 0x000fe40000011463ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a00837306ULL, 0x0003e20000200c00ULL, 0x0000888060387816ULL, 0x044fe200000000ffULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011432ULL,
0x00000018ff6d7819ULL, 0x000fe40000011433ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000003800847306ULL, 0x0005e20000200c00ULL, 0x00000100613a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe20000011492ULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fc4000001147cULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b00827306ULL, 0x0003e20000200c00ULL, 0x0000888062387816ULL, 0x004fe400000000ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000018ff687819ULL, 0x008fe40000011434ULL,
0x0000888034987816ULL, 0x000fe200000000ffULL, 0x00000038008a7306ULL, 0x0005e20000200c00ULL,
0x00000100633b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc40000011435ULL,
0x00000018ff667819ULL, 0x000fe40000011436ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003900857306ULL, 0x0002e20000200c00ULL, 0x0000010030387824ULL, 0x004fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fcc0000011437ULL, 0x0000006100887306ULL, 0x0005e20000200c00ULL,
0x0000010062397824ULL, 0x042fe400078e00ffULL, 0x0001000062627824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00897306ULL, 0x0003e20000200c00ULL,
0x00000018ff617819ULL, 0x004fe40000011438ULL, 0x0000a8000e387811ULL, 0x000fe400078e20ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000541084847816ULL, 0x008fe20000000085ULL,
0x00000039008b7306ULL, 0x000ea20000200c00ULL, 0x00008880633a7816ULL, 0x042fe200000000ffULL,
0x0001000063637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000003a008c7306ULL, 0x000ff00000200c00ULL, 0x0000003b008f7306ULL, 0x0002e20000200c00ULL,
0x000054108a8a7816ULL, 0x004fce000000008bULL, 0x0000006000877306ULL, 0x0005e20000200c00ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x0000888030607816ULL, 0x044fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x000054108c8b7816ULL, 0x008fc8000000008fULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000007a007a7306ULL, 0x000ff00000200c00ULL, 0x00000062008d7306ULL, 0x0005f00000200c00ULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x0000888031627816ULL, 0x044fe200000000ffULL,
0x0001000031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x0000006b38389232ULL, 0x082fe40000000000ULL,
0x0000006b3a3a9232ULL, 0x000fe40000000000ULL, 0x0000006a39399232ULL, 0x090fe40000000000ULL,
0x0000006a3b3b9232ULL, 0x000fe20000000000ULL, 0x0000003000937306ULL, 0x0003e20000200c00ULL,
0x000054107b767816ULL, 0x008fca0000000076ULL, 0x0000008a3840723cULL, 0x000fe40000001840ULL,
0x0000003100967306ULL, 0x0007e20000200c00ULL, 0x0000010033307824ULL, 0x002fe200078e00ffULL,
0x000054107e777816ULL, 0x004fc80000000077ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000006000907306ULL, 0x0003e20000200c00ULL, 0x000054107a317816ULL, 0x008fe2000000007dULL,
0x000000763854723cULL, 0x000fe20000001854ULL, 0x00000100357a7824ULL, 0x000fca00078e00ffULL,
0x0000003000977306ULL, 0x0005e20000200c00ULL, 0x0000888032607816ULL, 0x002fe400000000ffULL,
0x00000018ff7a7819ULL, 0x000fca000001147aULL, 0x0000006100917306ULL, 0x0002e20000200c00ULL,
0x0000541078307816ULL, 0x004fe20000000079ULL, 0x000000ffff787224ULL, 0x000fe200078e0098ULL,
0x0000888035797816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fc800078e00ffULL,
0x0000006200947306ULL, 0x0005e20000200c00ULL, 0x0000010032617824ULL, 0x042fe200078e00ffULL,
0x000000303858723cULL, 0x000fe20000001858ULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc80000011435ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000010034317824ULL, 0x040fe200078e00ffULL, 0x0000888033627816ULL, 0x044fe200000000ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x0000a8000f307811ULL, 0x000fe200078e20ffULL,
0x00000063008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff767819ULL, 0x000fe20000011431ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000541090907816ULL, 0x008fc40000000091ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000009200957306ULL, 0x000ea20000200c00ULL, 0x00000018ff637819ULL, 0x002fce0000011461ULL,
0x0000006200927306ULL, 0x000ff00000200c00ULL, 0x0000003200617306ULL, 0x000fe20000200c00ULL,
0x0000541094917816ULL, 0x004fce0000000095ULL, 0x0000003300627306ULL, 0x0003f00000200c00ULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x000000003030783bULL, 0x002e6e0000000200ULL,
0x0000007500757306ULL, 0x000ef00000200c00ULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x0000541083747816ULL, 0x004fce0000000074ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x0000541082757816ULL, 0x008fce0000000075ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x000054107f807816ULL, 0x010fe20000000080ULL, 0x00000074384c723cULL, 0x000fec000000184cULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000006b30309232ULL, 0x082fe40000000000ULL,
0x0000006b32329232ULL, 0x000fe20000000000ULL, 0x00000100366b7824ULL, 0x000fe200078e00ffULL,
0x0000006a31319232ULL, 0x000fc40000000000ULL, 0x0000006a33339232ULL, 0x000fe20000000000ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541081817816ULL, 0x004fe4000000007cULL,
0x00000018ff6b7819ULL, 0x000fc6000001146bULL, 0x000000903058723cULL, 0x000fe40000001858ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x0000541087727816ULL, 0x008fca0000000072ULL,
0x000000803850723cULL, 0x000fe40000001850ULL, 0x0000007100717306ULL, 0x000ee20000200c00ULL,
0x0000541088737816ULL, 0x002fce0000000073ULL, 0x0000008600867306ULL, 0x000e620000200c00ULL,
0x000000723844723cULL, 0x000fe20000001844ULL, 0x000054108d707816ULL, 0x004fcc0000000070ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054108e717816ULL, 0x008fce0000000071ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x0000541086857816ULL, 0x002fe20000000089ULL,
0x00000070383c723cULL, 0x040fec000000183cULL, 0x0000003400757306ULL, 0x0003e40000200c00ULL,
0x000000843848723cULL, 0x000fec0000001848ULL, 0x0000003500727306ULL, 0x0007e20000200c00ULL,
0x0000888036347816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400737306ULL, 0x0003e20000200c00ULL,
0x0000888037357816ULL, 0x008fce00000000ffULL, 0x0000003500397306ULL, 0x0007e20000200c00ULL,
0x0000010037347824ULL, 0x042fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541092357816ULL, 0x008fce0000000097ULL,
0x00000034003a7306ULL, 0x0004f00000200c00ULL, 0x0000006f006f7306ULL, 0x000f220000200c00ULL,
0x0000541060347816ULL, 0x004fe40000000063ULL, 0x00005410936e7816ULL, 0x002fca000000006eULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000000343050723cULL, 0x000fe20000001850ULL,
0x0000541039397816ULL, 0x008fcc000000003aULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x00005410966f7816ULL, 0x010fce000000006fULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x00005410616c7816ULL, 0x002fe2000000006cULL, 0x0000006e3054723cULL, 0x000fec0000001854ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x00005410626d7816ULL, 0x004fce000000006dULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000541075687816ULL, 0x008fe20000000068ULL,
0x0000006c304c723cULL, 0x000fec000000184cULL, 0x0000007600777306ULL, 0x000ea20000200c00ULL,
0x0000541072697816ULL, 0x002fce0000000069ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000000683044723cULL, 0x000fee0000001844ULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541078787816ULL, 0x004fce0000000077ULL, 0x0000006b00387306ULL, 0x000eb00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000541079797816ULL, 0x002fce000000007aULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541073387816ULL, 0x004fe20000000038ULL,
0x000000783048723cULL, 0x040fec0000001848ULL, 0x0000003600357306ULL, 0x000e640000200c00ULL,
0x000000383040723cULL, 0x000fec0000001840ULL, 0x0000003700347306ULL, 0x000ea20000200c00ULL,
0x0000541035667816ULL, 0x002fc40000000066ULL, 0x0000541034677816ULL, 0x004fce0000000067ULL,
0x000000663030723cULL, 0x000fe2000000183cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff347f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008004347811ULL, 0x002fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000340300720cULL, 0x000fda0003f24070ULL,
0x0000631000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff347984ULL, 0x000e640000000800ULL,
0x8000000034ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff347984ULL, 0x000e640000000800ULL, 0x8000000034ff7812ULL, 0x002fe40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff347424ULL, 0x000fc800078e00ffULL, 0x0000003400367305ULL, 0x0002a4000021f000ULL,
0x3fa0000034347823ULL, 0x002fe200000100ffULL, 0x000000360000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff367984ULL, 0x000e640000000800ULL, 0x8000000036ff7812ULL, 0x002fc40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff347424ULL, 0x000fe200078e00ffULL,
0x0000000307367812ULL, 0x000fe200078ec0ffULL, 0x00000300ff357624ULL, 0x000fc600078e00ffULL,
0x000000033600780cULL, 0x000fe20003f25270ULL, 0xfffffffd34357424ULL, 0x000fca00078e0235ULL,
0x0000000135367807ULL, 0x000fca0004800000ULL, 0x0000000107077824ULL, 0x000fe400078e0236ULL,
0x0000580009367a24ULL, 0x000fe400078e02ffULL, 0xffffffffff097424ULL, 0x000fe200078e00ffULL,
0x000000050700720cULL, 0x000fe20003f26070ULL, 0x0000004036387824ULL, 0x000fe200078e00ffULL,
0x000000a004367811ULL, 0x000fd600078e40ffULL, 0x0000000107359824ULL, 0x000fc800078e0210ULL,
0x0000600035349625ULL, 0x000fe200078e0034ULL, 0x0000003603377217ULL, 0x000fc80007800000ULL,
0x0000000634099981ULL, 0x000362000c1e1900ULL, 0x0000001138397210ULL, 0x040fe20007f3e0ffULL,
0x0000000137377824ULL, 0x000fe200078e0a36ULL, 0x00000015383b7210ULL, 0x040fe40007f5e0ffULL,
0x00000016383d7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005e00393c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff607224ULL, 0x000fe200010e06ffULL,
0x0000002037377807ULL, 0x000fe20000000000ULL, 0x000000ffff667224ULL, 0x000fe200018e06ffULL,
0x00005f00393a7a11ULL, 0x000fc400008f443aULL, 0x0000001438367210ULL, 0x000fe40007f3e0ffULL,
0x0000003708377217ULL, 0x000fe40007800000ULL, 0x00000004ff347819ULL, 0x002fe20000011602ULL,
0x000000ffff357224ULL, 0x000fe200008e06ffULL, 0x00005e00363e7a11ULL, 0x040fe200078240ffULL,
0x0000000137397824ULL, 0x000fe200078e0a08ULL, 0x00005e003b627a11ULL, 0x000fe400078440ffULL,
0x00005f0036377a11ULL, 0x000fc400008f4435ULL, 0x000000393400720cULL, 0x000fe40003f26070ULL,
0x000000173c347210ULL, 0x080fe40007f9e0ffULL, 0x000000173e367210ULL, 0x000fe40007fbe0ffULL,
0x00005f003b607a11ULL, 0x000fe200010f4460ULL, 0x000000ffff357224ULL, 0x000fe200020e063aULL,
0x00005e003d3c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff377224ULL, 0x000fe200028e0637ULL,
0x000000392e00720cULL, 0x000fc40003f86070ULL, 0x000000391200720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034187faeULL, 0x0003e2000c901c46ULL,
0x000000391300720cULL, 0x000fe40003fa6070ULL, 0x0000001762387210ULL, 0x080fe40007f7e0ffULL,
0x00005f003d667a11ULL, 0x000fe400010f4466ULL, 0x000000173c3a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff397224ULL, 0x000fe400018e0660ULL, 0x0000000036197faeULL, 0x0003e4000e101c46ULL,
0x000000ffff3b7224ULL, 0x000fc400010e0666ULL, 0x00000000381a7faeULL, 0x0003e8000f101c46ULL,
0x000000003a1b7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff667f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff377984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480008347f8cULL, 0x000fe2000c80043fULL,
0x8000000037ff7812ULL, 0x002fc6000784485eULL, 0x01064c0008397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff367424ULL, 0x000fc800078e00ffULL, 0x0000003600377305ULL, 0x0002e4000021f000ULL,
0x3fa0000036367823ULL, 0x002fe200000100ffULL, 0x000000370000735dULL, 0x008fe40003800000ULL,
0x01064c0008377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fc40007824835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100001c377984ULL, 0x000e680000000800ULL,
0x010300001c367984ULL, 0x0007220000000800ULL, 0x0000000a3700720bULL, 0x002fe20003f3d000ULL,
0x0000e7d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x008fc800008e0100ULL,
0x0000ffff343a7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff797424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000020000780cULL, 0x000fe40003f65270ULL, 0x0000000a3700720bULL, 0x000fe20003f34000ULL,
0x0000e7b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000347806ULL, 0x000fe400008e0100ULL,
0x000000370a357209ULL, 0x000fe40007810000ULL, 0x0000ffff34397812ULL, 0x000fe400078e3cffULL,
0x00000002ff627819ULL, 0x000fe20000011602ULL, 0x800000350a387221ULL, 0x000fe20000010000ULL,
0x010500351c00b388ULL, 0x0003e20000000800ULL, 0x000000393aff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b38387820ULL, 0x000fc80000410000ULL, 0x00000038003b7308ULL, 0x000ee40000000800ULL,
0x0000003b0b0b7220ULL, 0x008fe20000410000ULL, 0x0000e7627f007947ULL, 0x000fea000b800000ULL,
0x00001f623b3a7589ULL, 0x0022e400000e0000ULL, 0x0000003a58587220ULL, 0x08cfe40000410000ULL,
0x0000003a59597220ULL, 0x080fe40000410000ULL, 0x0000003a54547220ULL, 0x080fe40000410000ULL,
0x0000003a55557220ULL, 0x080fe40000410000ULL, 0x0000003a50507220ULL, 0x000fc40000410000ULL,
0x0000003a51517220ULL, 0x080fe40000410000ULL, 0x0000003a4c4c7220ULL, 0x080fe40000410000ULL,
0x0000003a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000003a48487220ULL, 0x080fe40000410000ULL,
0x0000003a49497220ULL, 0x080fe40000410000ULL, 0x0000003a44447220ULL, 0x000fc40000410000ULL,
0x0000003a45457220ULL, 0x080fe40000410000ULL, 0x0000003a40407220ULL, 0x080fe40000410000ULL,
0x0000003a41417220ULL, 0x080fe40000410000ULL, 0x0000003a30307220ULL, 0x080fe40000410000ULL,
0x0000003a31317220ULL, 0x000fe20000410000ULL, 0x0000e6927f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b3a7589ULL, 0x0004e400000e0000ULL, 0x000000370a0a7209ULL, 0x000fe20007810000ULL,
0x0000003a5a5a7220ULL, 0x08cfe20000410000ULL, 0x00000001ff797807ULL, 0x000fe20000800000ULL,
0x0000003a5b5b7220ULL, 0x000fc40000410000ULL, 0x8000000a37371221ULL, 0x000fe40000010000ULL,
0x0000003a56567220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b37371820ULL, 0x000fe40000410000ULL,
0x0000003a57577220ULL, 0x080fe40000410000ULL, 0x00000037001d1308ULL, 0x000ea20000000800ULL,
0x0000003a52527220ULL, 0x080fe40000410000ULL, 0x0000003a53537220ULL, 0x000fc40000410000ULL,
0x0000003a4e4e7220ULL, 0x080fe40000410000ULL, 0x0000003a4f4f7220ULL, 0x080fe40000410000ULL,
0x0000003a4a4a7220ULL, 0x080fe40000410000ULL, 0x0000003a4b4b7220ULL, 0x080fe40000410000ULL,
0x0000003a46467220ULL, 0x080fe40000410000ULL, 0x0000003a47477220ULL, 0x000fc40000410000ULL,
0x0000003a42427220ULL, 0x080fe40000410000ULL, 0x0000003a43437220ULL, 0x080fe40000410000ULL,
0x0000003a32327220ULL, 0x080fe40000410000ULL, 0x0000003a33337220ULL, 0x000fe40000410000ULL,
0x000000361d361220ULL, 0x014fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000000b360b7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fc4000782485eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff347424ULL, 0x000fc800078e00ffULL,
0x0000003400357305ULL, 0x000724000021f000ULL, 0x3fa0000034347823ULL, 0x008fe200000100ffULL,
0x000000350000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fe4000782485eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001dff34723eULL, 0x000fe400000000ffULL, 0x00000002ff627819ULL, 0x002fc40000011602ULL,
0x00005410343b7816ULL, 0x000fe20000000034ULL, 0x0000e4327f007947ULL, 0x000fea000b800000ULL,
0x00001f623b6d7589ULL, 0x0002e400000e0000ULL, 0x0000e4727f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b6c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0065ULL, 0x000083d000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000ef0000007944ULL, 0x03cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0064ULL, 0x0000843000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000eea000007944ULL, 0x03cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000001e38783bULL, 0x016e680000004200ULL, 0x000000001f60783bULL, 0x000ea80000004200ULL,
0x00000000203c783bULL, 0x000f280000004200ULL, 0x000000002134783bULL, 0x000ee20000004200ULL,
0x00000018ff777819ULL, 0x002fe20000011438ULL, 0x00000100387b7824ULL, 0x040fe200078e00ffULL,
0x00008880387a7816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011439ULL, 0x00000100397d7824ULL, 0x040fe200078e00ffULL,
0x00008880397c7816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0000007a007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff757819ULL, 0x000fc4000001143aULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff737819ULL, 0x004fe20000011460ULL,
0x0000003800827306ULL, 0x0005e20000200c00ULL, 0x000088803a7a7816ULL, 0x002fe400000000ffULL,
0x00000018ff767819ULL, 0x000fe4000001143bULL, 0x00000018ff747819ULL, 0x000fc40000011461ULL,
0x00000018ff717819ULL, 0x000fe20000011462ULL, 0x0000003900837306ULL, 0x0003e20000200c00ULL,
0x000001003a387824ULL, 0x044fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011463ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x010fe4000001143cULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000010060397824ULL, 0x002fe200078e00ffULL, 0x0000003800867306ULL, 0x0003e20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff707819ULL, 0x000fe4000001143dULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803d7e7816ULL, 0x000fe200000000ffULL,
0x0000003a00887306ULL, 0x0005e20000200c00ULL, 0x0000888060387816ULL, 0x042fe200000000ffULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001143eULL,
0x00000018ff6e7819ULL, 0x000fc4000001143fULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000007b00807306ULL, 0x0003e20000200c00ULL, 0x00000100613a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff697819ULL, 0x008fe40000011434ULL, 0x0000888034997816ULL, 0x000fe400000000ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000007c00817306ULL, 0x0005e20000200c00ULL,
0x000088803b7b7816ULL, 0x002fc400000000ffULL, 0x00000018ff6a7819ULL, 0x000fe40000011435ULL,
0x00000018ff687819ULL, 0x000fe40000011437ULL, 0x00000018ff5e7819ULL, 0x000fe20000011436ULL,
0x00000038008b7306ULL, 0x0003e20000200c00ULL, 0x000001003b7c7824ULL, 0x044fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000039008c7306ULL, 0x0004e20000200c00ULL, 0x0000888062387816ULL, 0x002fe400000000ffULL,
0x00000018ff3b7819ULL, 0x000fca000001143bULL, 0x0000007a00857306ULL, 0x0003220000200c00ULL,
0x0000010062397824ULL, 0x044fe400078e00ffULL, 0x0001000062627824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00907306ULL, 0x0005e20000200c00ULL,
0x00008880617a7816ULL, 0x042fe200000000ffULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x000054108b8c7816ULL, 0x008fc8000000008cULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000003800917306ULL, 0x0003e20000200c00ULL, 0x00000100633a7824ULL, 0x004fe200078e00ffULL,
0x0000541085867816ULL, 0x010fcc0000000086ULL, 0x0000007b00877306ULL, 0x0005e20000200c00ULL,
0x000001003c387824ULL, 0x002fce00078e00ffULL, 0x00000060008e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x004fe40000011438ULL, 0x0000b00022387811ULL, 0x000fca00078e20ffULL,
0x0000003b00897306ULL, 0x0005e20000200c00ULL, 0x00000018ff607819ULL, 0x002fe4000001143aULL,
0x00000018ff3a7819ULL, 0x000fe40000011462ULL, 0x000088803c627816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe400078e00ffULL, 0x0000003900927306ULL, 0x0002e20000200c00ULL,
0x00008880633b7816ULL, 0x044fe200000000ffULL, 0x0001000063637824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc8000001143cULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x00000061008f7306ULL, 0x0005e20000200c00ULL, 0x000001003d397824ULL, 0x042fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fca00078e00ffULL, 0x0000003b00937306ULL, 0x000fe20000200c00ULL,
0x00000018ff617819ULL, 0x004fe40000011439ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000541091927816ULL, 0x008fc60000000092ULL, 0x0000003a00947306ULL, 0x0003f00000200c00ULL,
0x0000006300957306ULL, 0x0005e20000200c00ULL, 0x000000003838783bULL, 0x002e6e0000000200ULL,
0x0000006100977306ULL, 0x0007e20000200c00ULL, 0x000001003e637824ULL, 0x004fce00078e00ffULL,
0x0000007d00847306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x008fe40000011463ULL,
0x0000991079637816ULL, 0x000fc800000000ffULL, 0x000000ff6300720cULL, 0x000fe20003f25270ULL,
0x0000007c008a7306ULL, 0x000eb00000200c00ULL, 0x0000003c007c7306ULL, 0x0007f00000200c00ULL,
0x0000007700777306ULL, 0x000f220000200c00ULL, 0x000001003f3c7824ULL, 0x008fe200078e00ffULL,
0x0000006d38389232ULL, 0x082fe20000000000ULL, 0x0000541087877816ULL, 0x004fe2000000008aULL,
0x0000006d3a3a9232ULL, 0x000fc40000000000ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006c39399232ULL, 0x080fe20000000000ULL, 0x0000003d007d7306ULL, 0x0003e20000200c00ULL,
0x0000006c3b3b9232ULL, 0x000fce0000000000ULL, 0x0000003c00987306ULL, 0x0005e20000200c00ULL,
0x00005410813d7816ULL, 0x002fe20000000084ULL, 0x0000010035817824ULL, 0x000fe200078e00ffULL,
0x0000541082827816ULL, 0x010fe20000000077ULL, 0x000000863850723cULL, 0x000fe60000001850ULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000007a008d7306ULL, 0x0002e20000200c00ULL,
0x000054107f3c7816ULL, 0x004fe20000000080ULL, 0x000000ffff7f7224ULL, 0x000fe200078e0099ULL,
0x0000888035807816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fc800078e00ffULL,
0x0000006000967306ULL, 0x0005220000200c00ULL, 0x000088803f7a7816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000003c3858723cULL, 0x000fe20000001858ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x000000ffff797224ULL, 0x000fe200078e007aULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000088803e607816ULL, 0x044fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000b000233c7811ULL, 0x000fe200078e20ffULL, 0x00000100343d7824ULL, 0x040fe200078e00ffULL,
0x000054108d8d7816ULL, 0x008fe20000000090ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003f00637306ULL, 0x000fe20000200c00ULL,
0x00000018ff777819ULL, 0x000fc4000001143dULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000008c3848723cULL, 0x000fe20000001848ULL, 0x0000541093937816ULL, 0x010fc60000000096ULL,
0x0000003e007a7306ULL, 0x0005e20000200c00ULL, 0x0000541089897816ULL, 0x002fc60000000076ULL,
0x000000923840723cULL, 0x000fe80000001840ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000000003c3c783bULL, 0x004eae0000000200ULL, 0x0000007100717306ULL, 0x000ef00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541083837816ULL, 0x002fce0000000078ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541094947816ULL, 0x008fe20000000071ULL,
0x000000823854723cULL, 0x000fec0000001854ULL, 0x0000007e007e7306ULL, 0x000ff00000200c00ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x0000006d3c3c9232ULL, 0x004fc40000000000ULL,
0x0000006d3e3e9232ULL, 0x000fe20000000000ULL, 0x00000100366d7824ULL, 0x000fe200078e00ffULL,
0x0000006c3d3d9232ULL, 0x080fe40000000000ULL, 0x0000006c3f3f9232ULL, 0x000fe20000000000ULL,
0x0000007300737306ULL, 0x000ea20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fce000001146dULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000541088887816ULL, 0x002fce0000000075ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000054108e8e7816ULL, 0x004fe20000000073ULL,
0x00000088384c723cULL, 0x000fec000000184cULL, 0x0000003400767306ULL, 0x0005e20000200c00ULL,
0x000054108f8f7816ULL, 0x008fce0000000074ULL, 0x0000007700787306ULL, 0x000fe20000200c00ULL,
0x0000888036347816ULL, 0x044fe200000000ffULL, 0x0000008e3844723cULL, 0x000fe20000001844ULL,
0x0000541095957816ULL, 0x002fe20000000072ULL, 0x0001000036367824ULL, 0x000fc800078e00ffULL,
0x0000003500777306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x000000943830723cULL, 0x000fec0000001830ULL, 0x0000003400717306ULL, 0x0005e20000200c00ULL,
0x000054107e357816ULL, 0x002fe40000000097ULL, 0x0000888037397816ULL, 0x000fca00000000ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541062347816ULL, 0x004fce000000007bULL,
0x000000343c58723cULL, 0x000fe20000001858ULL, 0x0000006100617306ULL, 0x000e6c0000200c00ULL,
0x0000010037347824ULL, 0x040fe400078e00ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x0000007900797306ULL, 0x000ea20000200c00ULL, 0x000000ffff357224ULL, 0x000fe200078e0039ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000541060607816ULL, 0x002fe40000000061ULL, 0x0000003500397306ULL, 0x000ff00000200c00ULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x0000541079617816ULL, 0x004fce0000000098ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x000000603c50723cULL, 0x000fee0000001850ULL,
0x0000007000707306ULL, 0x000ee20000200c00ULL, 0x0000541039397816ULL, 0x002fce0000000034ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x000054107c7c7816ULL, 0x004fce000000006fULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000054107d7d7816ULL, 0x008fce0000000070ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x000054107a627816ULL, 0x002fe2000000006bULL,
0x0000007c3c54723cULL, 0x000fec0000001854ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541063637816ULL, 0x004fce000000006eULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541076767816ULL, 0x008fe20000000069ULL, 0x000000623c4c723cULL, 0x000fec000000184cULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0000541077777816ULL, 0x002fce000000006aULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000000763c44723cULL, 0x000fee0000001844ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000054107f787816ULL, 0x004fce0000000078ULL,
0x0000006d00387306ULL, 0x000eb00000200c00ULL, 0x0000003600357306ULL, 0x000ee20000200c00ULL,
0x0000541080797816ULL, 0x002fce0000000081ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541071387816ULL, 0x004fe20000000038ULL, 0x000000783c48723cULL, 0x040fec0000001848ULL,
0x0000003700377306ULL, 0x000e620000200c00ULL, 0x0000541035347816ULL, 0x008fe2000000005eULL,
0x000000383c40723cULL, 0x000fe20000001840ULL, 0x0000541037357816ULL, 0x002fce0000000068ULL,
0x000000343c3c723cULL, 0x000fe20000001830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff307f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff337984ULL, 0x000e640000000800ULL,
0x8000000033ff7812ULL, 0x002fe40007844831ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc40007844831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff327424ULL, 0x000fc800078e00ffULL, 0x0000003200337305ULL, 0x0002a4000021f000ULL,
0x3fa0000032327823ULL, 0x002fe200000100ffULL, 0x000000330000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fe40007844831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000580009307a24ULL, 0x020fc800078e02ffULL,
0x0000004030327824ULL, 0x000fe200078e00ffULL, 0x000000c004307811ULL, 0x000fc800078e40ffULL,
0x0000003003317217ULL, 0x000fe40007800000ULL, 0x0000002432337210ULL, 0x040fe40007f5e0ffULL,
0x0000002532357210ULL, 0x000fe20007f7e0ffULL, 0x0000000131317824ULL, 0x000fe400078e0a30ULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0033367a11ULL, 0x000fe200078440ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e00353a7a11ULL, 0x000fc400078640ffULL,
0x0000002031317807ULL, 0x000fe40000000000ULL, 0x00005f0033337a11ULL, 0x000fe400010f4434ULL,
0x00005f0035387a11ULL, 0x000fe400018f4438ULL, 0x0000002632307210ULL, 0x040fe40007f5e0ffULL,
0x0000002732397210ULL, 0x000fe40007f7e0ffULL, 0x0000003108317217ULL, 0x000fe20007800000ULL,
0x000000ffff357224ULL, 0x000fe200010e06ffULL, 0x00005e0030347a11ULL, 0x000fe200078440ffULL,
0x000000ffff5e7224ULL, 0x000fe200018e06ffULL, 0x00005e0039607a11ULL, 0x000fe200078640ffULL,
0x0000000131377824ULL, 0x000fe200078e0a08ULL, 0x00000004ff327819ULL, 0x000fc40000011602ULL,
0x00005f0030357a11ULL, 0x000fe400010f4435ULL, 0x00005f00395e7a11ULL, 0x000fe400018f445eULL,
0x0000001736307210ULL, 0x000fe40007f7e0ffULL, 0x000000373200720cULL, 0x000fe40003f46070ULL,
0x000000173a327210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff317224ULL, 0x000fe200018e0633ULL,
0x0000001734347210ULL, 0x000fc40007fbe0ffULL, 0x000000372e00720cULL, 0x080fe20003f66070ULL,
0x000000ffff337224ULL, 0x000fe200020e0638ULL, 0x000000371200720cULL, 0x080fe20003f86070ULL,
0x000000ffff357224ULL, 0x000fe200028e0635ULL, 0x000000371300720cULL, 0x000fe40003fa6070ULL,
0x0000001760367210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030287faeULL, 0x0003e8000d101c46ULL, 0x000000ffff377224ULL, 0x000fc400030e065eULL,
0x0000000032297faeULL, 0x0003e8000d901c46ULL, 0x00000000342a7faeULL, 0x0003e8000e101c46ULL,
0x00000000362b7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff337984ULL, 0x000e640000000800ULL, 0x8000000033ff7812ULL, 0x002fc40007844867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff5e7224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007844867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x0106b400ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001dff30723eULL, 0x000fe400000000ffULL,
0x00000002ff627819ULL, 0x000fe40000011602ULL, 0x00005410303b7816ULL, 0x000fe20000000030ULL,
0x0000cf727f007947ULL, 0x000fea000b800000ULL, 0x00001f623b6b7589ULL, 0x0002a400000e0000ULL,
0x0000cfb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3b6a7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0065ULL,
0x0000996000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000d97000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0064ULL,
0x000099c000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000d91000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002c38783bULL, 0x00ee680000004200ULL,
0x000000002d60783bULL, 0x000fe80000004200ULL, 0x000000000c30783bULL, 0x000ea80000004200ULL,
0x000000000d34783bULL, 0x000ee20000004200ULL, 0x00000018ff767819ULL, 0x002fe20000011438ULL,
0x0000010038797824ULL, 0x040fe200078e00ffULL, 0x0000888038787816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011439ULL,
0x00000100397c7824ULL, 0x040fe200078e00ffULL, 0x00008880397a7816ULL, 0x040fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe2000001143aULL,
0x0000010031927824ULL, 0x004fe200078e00ffULL, 0x000088803a7f7816ULL, 0x000fc400000000ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00000038007b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff757819ULL, 0x000fe4000001143bULL,
0x000088803b817816ULL, 0x000fe400000000ffULL, 0x00000018ff737819ULL, 0x000fe40000011461ULL,
0x0000888061867816ULL, 0x000fe200000000ffULL, 0x0000007c007d7306ULL, 0x0005e20000200c00ULL,
0x000001003a387824ULL, 0x042fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011460ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fc40000011462ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000039007e7306ULL, 0x0003e20000200c00ULL, 0x000001003b7c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe40000011430ULL, 0x00000018ff6f7819ULL, 0x000fe40000011431ULL,
0x0000003800807306ULL, 0x0005e20000200c00ULL, 0x0000010060397824ULL, 0x002fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff717819ULL, 0x000fe40000011463ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00837306ULL, 0x0003e20000200c00ULL,
0x0000888060387816ULL, 0x044fe200000000ffULL, 0x0001000060607824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011432ULL, 0x00000018ff6d7819ULL, 0x000fe40000011433ULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000003800847306ULL, 0x0005e20000200c00ULL,
0x00000100613a7824ULL, 0x042fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011492ULL,
0x0001000061617824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003b00827306ULL, 0x0003e20000200c00ULL,
0x0000888062387816ULL, 0x004fe400000000ffULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000018ff687819ULL, 0x008fe40000011434ULL, 0x0000888034987816ULL, 0x000fe200000000ffULL,
0x00000038008a7306ULL, 0x0005e20000200c00ULL, 0x00000100633b7824ULL, 0x002fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc40000011435ULL, 0x00000018ff667819ULL, 0x000fe40000011436ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x0000003900857306ULL, 0x0002e20000200c00ULL,
0x0000010030387824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fcc0000011437ULL,
0x0000006100887306ULL, 0x0005e20000200c00ULL, 0x0000010062397824ULL, 0x042fe400078e00ffULL,
0x0001000062627824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003a00897306ULL, 0x0003e20000200c00ULL, 0x00000018ff617819ULL, 0x004fe40000011438ULL,
0x0000b0000e387811ULL, 0x000fe400078e20ffULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000541084847816ULL, 0x008fe20000000085ULL, 0x00000039008b7306ULL, 0x000ea20000200c00ULL,
0x00008880633a7816ULL, 0x042fe200000000ffULL, 0x0001000063637824ULL, 0x000fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000003a008c7306ULL, 0x000ff00000200c00ULL,
0x0000003b008f7306ULL, 0x0002e20000200c00ULL, 0x000054108a8a7816ULL, 0x004fce000000008bULL,
0x0000006000877306ULL, 0x0005e20000200c00ULL, 0x000000003838783bULL, 0x002e6e0000000200ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000888030607816ULL, 0x044fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x000054108c8b7816ULL, 0x008fc8000000008fULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x00000062008d7306ULL, 0x0005f00000200c00ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x0000888031627816ULL, 0x044fe200000000ffULL, 0x0001000031317824ULL, 0x000fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x0000006b38389232ULL, 0x082fe40000000000ULL, 0x0000006b3a3a9232ULL, 0x000fe40000000000ULL,
0x0000006a39399232ULL, 0x090fe40000000000ULL, 0x0000006a3b3b9232ULL, 0x000fe20000000000ULL,
0x0000003000937306ULL, 0x0003e20000200c00ULL, 0x000054107b767816ULL, 0x008fca0000000076ULL,
0x0000008a3840723cULL, 0x000fe40000001840ULL, 0x0000003100967306ULL, 0x0007e20000200c00ULL,
0x0000010033307824ULL, 0x002fe200078e00ffULL, 0x000054107e777816ULL, 0x004fc80000000077ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000006000907306ULL, 0x0003e20000200c00ULL,
0x000054107a317816ULL, 0x008fe2000000007dULL, 0x000000763854723cULL, 0x000fe20000001854ULL,
0x00000100357a7824ULL, 0x000fca00078e00ffULL, 0x0000003000977306ULL, 0x0005e20000200c00ULL,
0x0000888032607816ULL, 0x002fe400000000ffULL, 0x00000018ff7a7819ULL, 0x000fca000001147aULL,
0x0000006100917306ULL, 0x0002e20000200c00ULL, 0x0000541078307816ULL, 0x004fe20000000079ULL,
0x000000ffff787224ULL, 0x000fe200078e0098ULL, 0x0000888035797816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fc800078e00ffULL, 0x0000006200947306ULL, 0x0005e20000200c00ULL,
0x0000010032617824ULL, 0x042fe200078e00ffULL, 0x000000303858723cULL, 0x000fe20000001858ULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000010034317824ULL, 0x040fe200078e00ffULL,
0x0000888033627816ULL, 0x044fe200000000ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x0000b0000f307811ULL, 0x000fe200078e20ffULL, 0x00000063008e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff767819ULL, 0x000fe20000011431ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000541090907816ULL, 0x008fc40000000091ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000009200957306ULL, 0x000ea20000200c00ULL,
0x00000018ff637819ULL, 0x002fce0000011461ULL, 0x0000006200927306ULL, 0x000ff00000200c00ULL,
0x0000003200617306ULL, 0x000fe20000200c00ULL, 0x0000541094917816ULL, 0x004fce0000000095ULL,
0x0000003300627306ULL, 0x0003f00000200c00ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000000003030783bULL, 0x002e6e0000000200ULL, 0x0000007500757306ULL, 0x000ef00000200c00ULL,
0x0000007f007f7306ULL, 0x000f220000200c00ULL, 0x0000541083747816ULL, 0x004fce0000000074ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541082757816ULL, 0x008fce0000000075ULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000054107f807816ULL, 0x010fe20000000080ULL,
0x00000074384c723cULL, 0x000fec000000184cULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x0000006b30309232ULL, 0x082fe40000000000ULL, 0x0000006b32329232ULL, 0x000fe20000000000ULL,
0x00000100366b7824ULL, 0x000fe200078e00ffULL, 0x0000006a31319232ULL, 0x000fc40000000000ULL,
0x0000006a33339232ULL, 0x000fe20000000000ULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x0000541081817816ULL, 0x004fe4000000007cULL, 0x00000018ff6b7819ULL, 0x000fc6000001146bULL,
0x000000903058723cULL, 0x000fe40000001858ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000541087727816ULL, 0x008fca0000000072ULL, 0x000000803850723cULL, 0x000fe40000001850ULL,
0x0000007100717306ULL, 0x000ee20000200c00ULL, 0x0000541088737816ULL, 0x002fce0000000073ULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x000000723844723cULL, 0x000fe20000001844ULL,
0x000054108d707816ULL, 0x004fcc0000000070ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054108e717816ULL, 0x008fce0000000071ULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x0000541086857816ULL, 0x002fe20000000089ULL, 0x00000070383c723cULL, 0x040fec000000183cULL,
0x0000003400757306ULL, 0x0003e40000200c00ULL, 0x000000843848723cULL, 0x000fec0000001848ULL,
0x0000003500727306ULL, 0x0007e20000200c00ULL, 0x0000888036347816ULL, 0x042fe200000000ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003400737306ULL, 0x0003e20000200c00ULL, 0x0000888037357816ULL, 0x008fce00000000ffULL,
0x0000003500397306ULL, 0x0007e20000200c00ULL, 0x0000010037347824ULL, 0x042fe400078e00ffULL,
0x0001000037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541092357816ULL, 0x008fce0000000097ULL, 0x00000034003a7306ULL, 0x0004f00000200c00ULL,
0x0000006f006f7306ULL, 0x000f220000200c00ULL, 0x0000541060347816ULL, 0x004fe40000000063ULL,
0x00005410936e7816ULL, 0x002fca000000006eULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x000000343050723cULL, 0x000fe20000001850ULL, 0x0000541039397816ULL, 0x008fcc000000003aULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00005410966f7816ULL, 0x010fce000000006fULL,
0x0000006800687306ULL, 0x000ee20000200c00ULL, 0x00005410616c7816ULL, 0x002fe2000000006cULL,
0x0000006e3054723cULL, 0x000fec0000001854ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x00005410626d7816ULL, 0x004fce000000006dULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541075687816ULL, 0x008fe20000000068ULL, 0x0000006c304c723cULL, 0x000fec000000184cULL,
0x0000007600777306ULL, 0x000ea20000200c00ULL, 0x0000541072697816ULL, 0x002fce0000000069ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000000683044723cULL, 0x000fee0000001844ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541078787816ULL, 0x004fce0000000077ULL,
0x0000006b00387306ULL, 0x000eb00000200c00ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541079797816ULL, 0x002fce000000007aULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0000541073387816ULL, 0x004fe20000000038ULL, 0x000000783048723cULL, 0x040fec0000001848ULL,
0x0000003600357306ULL, 0x000e640000200c00ULL, 0x000000383040723cULL, 0x000fec0000001840ULL,
0x0000003700347306ULL, 0x000ea20000200c00ULL, 0x0000541035667816ULL, 0x002fc40000000066ULL,
0x0000541034677816ULL, 0x004fce0000000067ULL, 0x000000663030723cULL, 0x000fe2000000183cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff347f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c004347811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000340300720cULL, 0x000fda0003f24070ULL, 0x0000318000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff347984ULL, 0x000e640000000800ULL, 0x8000000034ff7812ULL, 0x002fe40007824835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff347984ULL, 0x000e640000000800ULL,
0x8000000034ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff347424ULL, 0x000fc800078e00ffULL,
0x0000003400367305ULL, 0x0002a4000021f000ULL, 0x3fa0000034347823ULL, 0x002fe200000100ffULL,
0x000000360000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff367984ULL, 0x000e640000000800ULL,
0x8000000036ff7812ULL, 0x002fc40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff347424ULL, 0x000fe200078e00ffULL, 0x0000000307367812ULL, 0x000fe200078ec0ffULL,
0x00000300ff357624ULL, 0x000fe400078e00ffULL, 0x0000580009387a24ULL, 0x000fe200078e02ffULL,
0x000000033600780cULL, 0x000fe20003f25270ULL, 0xfffffffd34357424ULL, 0x000fe400078e0235ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x0000000135367807ULL, 0x000fca0004800000ULL,
0x0000000107077824ULL, 0x000fe200078e0236ULL, 0x000000e004367811ULL, 0x000fc800078e40ffULL,
0x000000050700720cULL, 0x000fe40003f26070ULL, 0x0000003603377217ULL, 0x000fe20007800000ULL,
0x0000004038387824ULL, 0x000fc800078e00ffULL, 0x0000000137377824ULL, 0x000fcc00078e0a36ULL,
0x0000000107359824ULL, 0x000fe200078e0210ULL, 0x0000002037377807ULL, 0x000fc60000000000ULL,
0x0000600035349625ULL, 0x000fe200078e0034ULL, 0x0000001138117210ULL, 0x000fe40007f5e0ffULL,
0x0000003708377217ULL, 0x000fe40007800000ULL, 0x0000000634099981ULL, 0x000362000c1e1900ULL,
0x00000016383b7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x0000001438367210ULL, 0x040fe20007f7e0ffULL, 0x0000000137377824ULL, 0x000fe200078e0a08ULL,
0x0000001538397210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x00000004ff147819ULL, 0x000fe20000011602ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005e00393c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005e0011347a11ULL, 0x002fc400078040ffULL, 0x00005e0036387a11ULL, 0x000fe400078440ffULL,
0x00005f0011167a11ULL, 0x000fe400000f4416ULL, 0x000000371400720cULL, 0x000fe40003f06070ULL,
0x0000001734147210ULL, 0x000fe40007f9e0ffULL, 0x00005f00393a7a11ULL, 0x000fe400018f443aULL,
0x00005f0036117a11ULL, 0x000fe200010f4415ULL, 0x000000ffff157224ULL, 0x000fe200020e0616ULL,
0x00005e003b607a11ULL, 0x000fc400078240ffULL, 0x000000372e00720cULL, 0x080fe40003f66070ULL,
0x000000371200720cULL, 0x080fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014187faeULL, 0x0003e2000c101c46ULL, 0x000000371300720cULL, 0x000fe40003f86070ULL,
0x0000001738347210ULL, 0x080fe40007f5e0ffULL, 0x000000173c367210ULL, 0x080fe40007fde0ffULL,
0x00005f003b3e7a11ULL, 0x000fe200008f443eULL, 0x000000ffff357224ULL, 0x000fe200010e0611ULL,
0x0000001760387210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff377224ULL, 0x000fc600030e063aULL,
0x0000000034197faeULL, 0x0003e2000d901c46ULL, 0x000000ffff397224ULL, 0x000fc600008e063eULL,
0x00000000361a7faeULL, 0x0003e8000e901c46ULL, 0x00000000381b7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff147f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff117984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680008187f8cULL, 0x000fe2000c80043fULL, 0x8000000011ff7812ULL, 0x004fc6000780485eULL,
0x01066c00081b7984ULL, 0x000ea40000000800ULL, 0x800000001bff7812ULL, 0x004fe40007824819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff117424ULL, 0x000fc800078e00ffULL,
0x0000001100167305ULL, 0x0004e4000021f000ULL, 0x3fa0000011117823ULL, 0x004fe200000100ffULL,
0x000000160000735dULL, 0x008fe20003800000ULL, 0x01066c00081b7984ULL, 0x000ea40000000800ULL,
0x800000001bff7812ULL, 0x004fc40007824819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180001c117984ULL, 0x000ea80000000800ULL, 0x010380001c167984ULL, 0x0007220000000800ULL,
0x0000000a1100720bULL, 0x004fe20003f3d000ULL, 0x0000b9527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x008fc800008e0100ULL, 0x0000ffff18197812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6b7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000030000780cULL, 0x000fe40003f45270ULL,
0x0000000a1100720bULL, 0x000fe20003f34000ULL, 0x0000b9327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x000fe400008e0100ULL, 0x000000110a1b7209ULL, 0x000fe40007810000ULL,
0x0000ffff18187812ULL, 0x000fe400078e3cffULL, 0x00000002ff627819ULL, 0x000fe20000011602ULL,
0x8000001b0a0a7221ULL, 0x000fe20000010000ULL, 0x0105801b1c00a388ULL, 0x0005e20000000800ULL,
0x0000001819ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL,
0x0000000a003b7308ULL, 0x000ee40000000800ULL, 0x0000003b0b0b7220ULL, 0x008fe20000410000ULL,
0x0000b8e27f007947ULL, 0x000fea000b800000ULL, 0x00001f623b3a7589ULL, 0x0044e400000e0000ULL,
0x0000003a58587220ULL, 0x08cfe40000410000ULL, 0x0000003a59597220ULL, 0x080fe40000410000ULL,
0x0000003a54547220ULL, 0x080fe40000410000ULL, 0x0000003a55557220ULL, 0x080fe40000410000ULL,
0x0000003a50507220ULL, 0x000fc40000410000ULL, 0x0000003a51517220ULL, 0x080fe40000410000ULL,
0x0000003a4c4c7220ULL, 0x080fe40000410000ULL, 0x0000003a4d4d7220ULL, 0x080fe40000410000ULL,
0x0000003a48487220ULL, 0x080fe40000410000ULL, 0x0000003a49497220ULL, 0x080fe40000410000ULL,
0x0000003a44447220ULL, 0x000fc40000410000ULL, 0x0000003a45457220ULL, 0x080fe40000410000ULL,
0x0000003a40407220ULL, 0x080fe40000410000ULL, 0x0000003a41417220ULL, 0x080fe40000410000ULL,
0x0000003a30307220ULL, 0x080fe40000410000ULL, 0x0000003a31317220ULL, 0x000fe20000410000ULL,
0x0000b8127f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3b3a7589ULL, 0x0004e400000e0000ULL,
0x8000001b11111221ULL, 0x000fe20000010000ULL, 0x00000001ff6b7807ULL, 0x000fe20000800000ULL,
0x0000003a5a5a7220ULL, 0x00cfc40000410000ULL, 0x3fb8aa3b11111820ULL, 0x000fe40000410000ULL,
0x0000003a5b5b7220ULL, 0x080fe40000410000ULL, 0x00000011001d1308ULL, 0x000ea20000000800ULL,
0x0000003a56567220ULL, 0x080fe40000410000ULL, 0x0000003a57577220ULL, 0x080fe40000410000ULL,
0x0000003a52527220ULL, 0x080fe40000410000ULL, 0x0000003a53537220ULL, 0x000fc40000410000ULL,
0x0000003a4e4e7220ULL, 0x080fe40000410000ULL, 0x0000003a4f4f7220ULL, 0x080fe40000410000ULL,
0x0000003a4a4a7220ULL, 0x080fe40000410000ULL, 0x0000003a4b4b7220ULL, 0x080fe40000410000ULL,
0x0000003a46467220ULL, 0x080fe40000410000ULL, 0x0000003a47477220ULL, 0x000fc40000410000ULL,
0x0000003a42427220ULL, 0x080fe40000410000ULL, 0x0000003a43437220ULL, 0x080fe40000410000ULL,
0x0000003a32327220ULL, 0x080fe40000410000ULL, 0x0000003a33337220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e001bULL, 0x000000161d161220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000000b160b7221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fc4000780485eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fc800078e00ffULL, 0x0000001100167305ULL, 0x0004e4000021f000ULL,
0x3fa0000011117823ULL, 0x004fe200000100ffULL, 0x000000160000735dULL, 0x008fe20003800000ULL,
0x0106ac00ff197984ULL, 0x000ea40000000800ULL, 0x8000000019ff7812ULL, 0x004fe4000780485eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001dff11723eULL, 0x000fe400000000ffULL,
0x00000002ff627819ULL, 0x002fc40000011602ULL, 0x00005410113b7816ULL, 0x000fe20000000011ULL,
0x0000b5b27f007947ULL, 0x000fea000b800000ULL, 0x00001f623b637589ULL, 0x0002a400000e0000ULL,
0x0000b5f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2f3b5e7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0065ULL,
0x0000b56000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000bd7000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff627224ULL, 0x002fe200078e0064ULL,
0x0000b5c000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000bd1000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000001e34783bULL, 0x000e620000004200ULL,
0x0000b80022227811ULL, 0x000fc400078e20ffULL, 0x0000b80023237811ULL, 0x000fe200078e20ffULL,
0x000000001f38783bULL, 0x00ee680000004200ULL, 0x00000000203c783bULL, 0x000ea80000004200ULL,
0x000000002118783bULL, 0x0007220000004200ULL, 0x00000018ff117819ULL, 0x000fe20000011434ULL,
0x00000100346c7824ULL, 0x040fe200078e00ffULL, 0x0000888034217816ULL, 0x048fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011435ULL,
0x00000100356f7824ULL, 0x040fe200078e00ffULL, 0x00008880356d7816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000010036747824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001146fULL,
0x0000010038797824ULL, 0x002fe200078e00ffULL, 0x00000034006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff697819ULL, 0x000fc40000011436ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000888036737816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe20000011437ULL, 0x0000003500727306ULL, 0x0007e20000200c00ULL,
0x0000010037347824ULL, 0x042fe200078e00ffULL, 0x0000888037757816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff677819ULL, 0x000fe20000011438ULL,
0x0000003600767306ULL, 0x0003e20000200c00ULL, 0x0000888038357816ULL, 0x048fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000018ff207819ULL, 0x000fe4000001143aULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003400787306ULL, 0x0007e20000200c00ULL, 0x0000010039367824ULL, 0x002fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011439ULL, 0x00000018ff667819ULL, 0x000fe4000001143bULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000035007a7306ULL, 0x0003e20000200c00ULL,
0x0000888039347816ULL, 0x048fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x00000034007b7306ULL, 0x0007e20000200c00ULL,
0x000088803a357816ULL, 0x002fc400000000ffULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000018ff617819ULL, 0x004fe4000001143cULL, 0x00000018ff627819ULL, 0x000fe2000001143dULL,
0x00000035007f7306ULL, 0x0003e20000200c00ULL, 0x000001003a347824ULL, 0x048fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001143eULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe4000001143fULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x0000003700777306ULL, 0x0005e20000200c00ULL, 0x000001003c357824ULL, 0x002fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff1e7819ULL, 0x010fe40000011419ULL,
0x00000018ff1c7819ULL, 0x000fe40000011418ULL, 0x00000038007c7306ULL, 0x0003e20000200c00ULL,
0x000001003b377824ULL, 0x004fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000036007e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff387819ULL, 0x002fe20000011435ULL,
0x000001003d357824ULL, 0x000fcc00078e00ffULL, 0x0000003400807306ULL, 0x0002e20000200c00ULL,
0x000088803b367816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000003a00837306ULL, 0x0005e20000200c00ULL,
0x000088803c347816ULL, 0x042fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000003600817306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x004fe40000011435ULL, 0x000054107f807816ULL, 0x008fca0000000080ULL,
0x0000003700827306ULL, 0x000e700000200c00ULL, 0x0000003400847306ULL, 0x0005f00000200c00ULL,
0x00000039007d7306ULL, 0x0007e20000200c00ULL, 0x000000002234783bULL, 0x0045220000000200ULL,
0x0000541081817816ULL, 0x002fcc0000000082ULL, 0x0000003a00897306ULL, 0x0003e20000200c00ULL,
0x000088803d397816ULL, 0x048fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000088803f227816ULL, 0x004fc800000000ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003900887306ULL, 0x0005e20000200c00ULL, 0x000001003f3a7824ULL, 0x042fe400078e00ffULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b00857306ULL, 0x0003e20000200c00ULL, 0x000001003e397824ULL, 0x004fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc8000001143fULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003800877306ULL, 0x0005e20000200c00ULL, 0x000099106b3b7816ULL, 0x002fc800000000ffULL,
0x000000ff3b00720cULL, 0x000fc60003f05270ULL, 0x00000039008d7306ULL, 0x000fe20000200c00ULL,
0x000088803e387816ULL, 0x044fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x00000038008a7306ULL, 0x000fe40000200c00ULL,
0x0000006334348232ULL, 0x090fe40000000000ULL, 0x0000006336368232ULL, 0x000fe40000000000ULL,
0x0000005e35358232ULL, 0x080fe40000000000ULL, 0x0000003a008e7306ULL, 0x0003e20000200c00ULL,
0x0000005e37378232ULL, 0x000fce0000000000ULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x000000002338783bULL, 0x002e620000000200ULL, 0x000000803440723cULL, 0x000fec0000001840ULL,
0x0000006c006c7306ULL, 0x000eb00000200c00ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000007000707306ULL, 0x000ee20000200c00ULL, 0x00005410216c7816ULL, 0x004fce000000006cULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000054106d6d7816ULL, 0x008fe20000000070ULL, 0x0000006338388232ULL, 0x002fc40000000000ULL,
0x000000633a3a8232ULL, 0x000fe40000000000ULL, 0x0000005e39398232ULL, 0x080fe40000000000ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x0000006c3458723cULL, 0x000fe20000001858ULL,
0x0000005e3b3b8232ULL, 0x000fcc0000000000ULL, 0x00000011006e7306ULL, 0x0007220000200c00ULL,
0x0000541073747816ULL, 0x004fce0000000074ULL, 0x0000001600717306ULL, 0x0004a20000200c00ULL,
0x0000541075757816ULL, 0x002fe40000000078ULL, 0x00000018ff117819ULL, 0x008fca000001141aULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x000054106f6e7816ULL, 0x010fe2000000006eULL,
0x000000743450723cULL, 0x000fe20000001850ULL, 0x00000018ff167819ULL, 0x004fca000001141bULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x00005410726f7816ULL, 0x000fce0000000071ULL,
0x00000022006b7306ULL, 0x0005e20000200c00ULL, 0x0000006e3454723cULL, 0x000fee0000001854ULL,
0x0000003c00867306ULL, 0x0007e20000200c00ULL, 0x0000888018227816ULL, 0x004fca00000000ffULL,
0x000000ffff217224ULL, 0x000fe400078e0022ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000100193c7824ULL, 0x008fe400078e00ffULL, 0x0000010018227824ULL, 0x040fe400078e00ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe4000001143cULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054107a3c7816ULL, 0x002fc40000000079ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff227819ULL, 0x000fc60000011422ULL,
0x0000006900697306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000ee20000200c00ULL,
0x000054107c7c7816ULL, 0x004fce0000000067ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000541076767816ULL, 0x002fce0000000069ULL, 0x0000003d008b7306ULL, 0x0003e20000200c00ULL,
0x0000541077777816ULL, 0x008fce000000006aULL, 0x00000021006c7306ULL, 0x0007e20000200c00ULL,
0x000054107b3d7816ULL, 0x002fe2000000007eULL, 0x00000076344c723cULL, 0x000fe2000000184cULL,
0x000054107d7d7816ULL, 0x004fca0000000068ULL, 0x0000003e008c7306ULL, 0x000fe20000200c00ULL,
0x0000888019217816ULL, 0x048fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x0000007c3444723cULL, 0x040fe80000001844ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000003f008f7306ULL, 0x0003f00000200c00ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000003c343c723cULL, 0x002fee0000001848ULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x0000541083487816ULL, 0x000fe20000000020ULL, 0x000001001a207824ULL, 0x000fe200078e00ffULL,
0x0000541085497816ULL, 0x000fca0000000066ULL, 0x0000001900677306ULL, 0x0005e40000200c00ULL,
0x000000483448723cULL, 0x000fec0000001830ULL, 0x00000021006e7306ULL, 0x0007e20000200c00ULL,
0x00000018ff197819ULL, 0x004fe40000011420ULL, 0x0000541084207816ULL, 0x000fc40000000087ULL,
0x000088801b307816ULL, 0x000fe400000000ffULL, 0x000054108a347816ULL, 0x000fe2000000008dULL,
0x0000001800697306ULL, 0x0005e20000200c00ULL, 0x0000541088217816ULL, 0x008fe40000000089ULL,
0x000054106b357816ULL, 0x000fe4000000008eULL, 0x000054108b317816ULL, 0x002fc60000000062ULL,
0x00000022006d7306ULL, 0x000e620000200c00ULL, 0x000088801a187816ULL, 0x044fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x000000343834723cULL, 0x000fea0000001850ULL,
0x00000023006f7306ULL, 0x0004e40000200c00ULL, 0x00000018ff507819ULL, 0x000fcc000001141aULL,
0x0000001800637306ULL, 0x0009e20000200c00ULL, 0x000000203820723cULL, 0x004fe20000001858ULL,
0x000054106c6c7816ULL, 0x002fcc000000006dULL, 0x000000ffff587224ULL, 0x000fe200078e0030ULL,
0x0000541086307816ULL, 0x000fe20000000061ULL, 0x000001001b187824ULL, 0x050fe200078e00ffULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000054106e6d7816ULL, 0x008fc6000000006fULL, 0x000000303830723cULL, 0x040fe20000001854ULL,
0x00000018ff517819ULL, 0x000fe4000001141bULL, 0x0000006000607306ULL, 0x000ea80000200c00ULL,
0x00000018ff547819ULL, 0x000fe20000011418ULL, 0x0000006c383c723cULL, 0x000fe6000000183cULL,
0x0000001e001e7306ULL, 0x000ee20000200c00ULL, 0x000054108c187816ULL, 0x002fce000000001fULL,
0x0000001c001c7306ULL, 0x000e700000200c00ULL, 0x0000001100117306ULL, 0x000ff00000200c00ULL,
0x0000001600167306ULL, 0x000ff00000200c00ULL, 0x00000019005e7306ULL, 0x0005300000200c00ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000054108f197816ULL, 0x004fce0000000060ULL,
0x0000005400557306ULL, 0x000ea20000200c00ULL, 0x000000183818723cULL, 0x000fee000000184cULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x00005410674d7816ULL, 0x008fe4000000001eULL,
0x00005410694c7816ULL, 0x002fc4000000001cULL, 0x00005410631e7816ULL, 0x010fc6000000005eULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00005410581f7816ULL, 0x004fe20000000055ULL,
0x0000004c3844723cULL, 0x000fe20000001844ULL, 0x0000541050507816ULL, 0x000fce0000000011ULL,
0x0000001e3840723cULL, 0x000fe20000001840ULL, 0x0000541051517816ULL, 0x002fce0000000016ULL,
0x000000503848723cULL, 0x000fe20000001848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff1e7f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000782481fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000782481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fc800078e00ffULL, 0x0000001100167305ULL, 0x0002a4000021f000ULL,
0x3fa0000011117823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe4000782481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030004117a10ULL, 0x000fe20007ffe0ffULL,
0x00005800091c7a24ULL, 0x020fc800078e02ffULL, 0x0000010011167824ULL, 0x040fe200078e00ffULL,
0x0000000111117810ULL, 0x000fe20007ffe0ffULL, 0x000000401c1c7824ULL, 0x000fc600078e00ffULL,
0x00000016031f7217ULL, 0x000fe40007800000ULL, 0x000000241c247210ULL, 0x000fe40007f3e0ffULL,
0x000000061100720cULL, 0x000fe20003f46070ULL, 0x000000011f1f7824ULL, 0x000fe200078e0a16ULL,
0x00005e00241e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x000000251c257210ULL, 0x000fe40007f9e0ffULL, 0x000000201f1f7807ULL, 0x000fc40001000000ULL,
0x000000261c387210ULL, 0x040fe40007fbe0ffULL, 0x000000271c397210ULL, 0x000fe40007f3e0ffULL,
0x00005f00241c7a11ULL, 0x000fe200018f4411ULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x0000001f081f7217ULL, 0x000fe20007800000ULL, 0x000000ffff277224ULL, 0x000fe200028e06ffULL,
0x00005e0025267a11ULL, 0x000fe200078440ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e00383a7a11ULL, 0x000fe200078640ffULL, 0x000000011f117824ULL, 0x000fe200078e0a08ULL,
0x00000004ff167819ULL, 0x000fc40000011602ULL, 0x00005e00394e7a11ULL, 0x000fe400078240ffULL,
0x00005f0025257a11ULL, 0x000fe400010f4424ULL, 0x000000171e1e7210ULL, 0x080fe40007f9e0ffULL,
0x0000001726247210ULL, 0x000fe40007fbe0ffULL, 0x00005f0038277a11ULL, 0x000fe200018f4427ULL,
0x000000ffff1f7224ULL, 0x000fe200020e061cULL, 0x00005f00394c7a11ULL, 0x000fe200008f444cULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000111600720cULL, 0x000fc40003f46070ULL,
0x000000173a267210ULL, 0x000fe40007f7e0ffULL, 0x000000112e00720cULL, 0x080fe40003f26070ULL,
0x000000111200720cULL, 0x080fe20003f86070ULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x000000111300720cULL, 0x000fe40003fa6070ULL, 0x000000174e127210ULL, 0x000fc60007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e287faeULL, 0x0003e4000d101c46ULL,
0x000000ffff137224ULL, 0x000fe400018e064cULL, 0x0000000024297faeULL, 0x0003e8000c901c46ULL,
0x00000000262a7faeULL, 0x0003e8000e101c46ULL, 0x00000000122b7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff127f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007824815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0013ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff117424ULL, 0x000fc800078e00ffULL,
0x0000001100127305ULL, 0x0002a4000021f000ULL, 0x3fa0000011117823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe20003800000ULL, 0x0106b400ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001dff11723eULL, 0x000fe400000000ffULL, 0x00000002ff627819ULL, 0x000fe40000011602ULL,
0x00005410113b7816ULL, 0x000fe20000000011ULL, 0x0000a0d27f007947ULL, 0x000fea000b800000ULL,
0x00001f623b137589ULL, 0x0002a400000e0000ULL, 0x0000a1127f007947ULL, 0x000fea000b800000ULL,
0x00001f2f3b1c7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0065ULL, 0x0000cb1000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000a7c000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff627224ULL, 0x002fe200078e0064ULL, 0x0000cb7000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000a76000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002c24783bULL, 0x000f620000004200ULL, 0x0000b8000e0e7811ULL, 0x000fe400078e20ffULL,
0x0000b8000f0f7811ULL, 0x000fe200078e20ffULL, 0x000000002d38783bULL, 0x00efe80000004200ULL,
0x000000000c28783bULL, 0x000e680000004200ULL, 0x000000000d14783bULL, 0x000ea20000004200ULL,
0x00000018ff117819ULL, 0x020fe20000011424ULL, 0x00000100244f7824ULL, 0x040fe200078e00ffULL,
0x00008880244e7816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011425ULL, 0x0000010025517824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe20000011426ULL, 0x0000010026577824ULL, 0x040fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000001100507306ULL, 0x000fe20000200c00ULL,
0x00000018ff537819ULL, 0x000fe20000011451ULL, 0x00000100296f7824ULL, 0x002fe200078e00ffULL,
0x0000888025527816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x0000888026547816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe20000011427ULL, 0x0000002400517306ULL, 0x0003e20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000888027607816ULL, 0x040fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000002500567306ULL, 0x0007e20000200c00ULL, 0x0000010027247824ULL, 0x042fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011438ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00000026005b7306ULL, 0x0003e20000200c00ULL, 0x0000888038257816ULL, 0x008fe400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff4d7819ULL, 0x000fe40000011439ULL,
0x00000018ff2e7819ULL, 0x000fe2000001143bULL, 0x0000002400617306ULL, 0x0007e20000200c00ULL,
0x0000010039267824ULL, 0x002fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fc40000011428ULL,
0x00008880296e7816ULL, 0x000fe400000000ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000002500647306ULL, 0x0003e20000200c00ULL, 0x0000888039247816ULL, 0x048fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff2f7819ULL, 0x000fe4000001143aULL,
0x00000018ff2d7819ULL, 0x000fe20000011429ULL, 0x0000002400667306ULL, 0x0007e20000200c00ULL,
0x0001000039257824ULL, 0x002fe200078e00ffULL, 0x000088802b727816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x004fe40000011414ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002700637306ULL, 0x0003e20000200c00ULL, 0x000001003a247824ULL, 0x008fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe40000011416ULL, 0x00000018ff0d7819ULL, 0x000fe40000011417ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000002600677306ULL, 0x0005e20000200c00ULL,
0x000088803a277816ULL, 0x042fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000024006a7306ULL, 0x0003e20000200c00ULL,
0x000088803b267816ULL, 0x004fce00000000ffULL, 0x0000005700597306ULL, 0x0005e20000200c00ULL,
0x0000010028247824ULL, 0x002fce00078e00ffULL, 0x0000002500687306ULL, 0x000fe20000200c00ULL,
0x00000018ff577819ULL, 0x004fce0000011424ULL, 0x0000002700697306ULL, 0x000e700000200c00ULL,
0x00000026006b7306ULL, 0x0005f00000200c00ULL, 0x0000005400587306ULL, 0x0007620000200c00ULL,
0x000000000e24783bULL, 0x0045220000000200ULL, 0x00005410696a7816ULL, 0x002fcc000000006aULL,
0x0000001200557306ULL, 0x0002620000200c00ULL, 0x0000010038547824ULL, 0x048fe400078e00ffULL,
0x0001000038387824ULL, 0x000fe400078e00ffULL, 0x000001002a0e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000057006d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000541058587816ULL, 0x020fc40000000059ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff127819ULL, 0x002fe20000011415ULL,
0x0000005400657306ULL, 0x0002e20000200c00ULL, 0x0000541056557816ULL, 0x000fe40000000055ULL,
0x000088802a577816ULL, 0x004fca00000000ffULL, 0x0000005700717306ULL, 0x000fe20000200c00ULL,
0x0000888028547816ULL, 0x042fe200000000ffULL, 0x0001000028287824ULL, 0x000fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x00000054006c7306ULL, 0x0003e20000200c00ULL,
0x0000001324248232ULL, 0x090fe20000000000ULL, 0x0000541064647816ULL, 0x008fe20000000065ULL,
0x0000001326268232ULL, 0x000fe20000000000ULL, 0x0000541066657816ULL, 0x000fe20000000067ULL,
0x0000001c25258232ULL, 0x080fe40000000000ULL, 0x0000001c27278232ULL, 0x000fe20000000000ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0001000029547824ULL, 0x002fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x00000064243c723cULL, 0x000fe2000000183cULL,
0x0000004f004f7306ULL, 0x000e700000200c00ULL, 0x0000005400707306ULL, 0x0005f00000200c00ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0000541051547816ULL, 0x004fe20000000050ULL,
0x0000010015507824ULL, 0x000fe200078e00ffULL, 0x000054104e4e7816ULL, 0x002fc8000000004fULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x000000542454723cULL, 0x000fe20000001830ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x000000000f30783bULL, 0x0004ee0000000200ULL,
0x0000006000607306ULL, 0x000f220000200c00ULL, 0x00008880160f7816ULL, 0x004fce00000000ffULL,
0x0000003800397306ULL, 0x0005e20000200c00ULL, 0x00005410524f7816ULL, 0x002fce0000000053ULL,
0x0000001e005a7306ULL, 0x0003620000200c00ULL, 0x000001003b387824ULL, 0x044fe200078e00ffULL,
0x0000004e2420723cULL, 0x040fe20000001820ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x0000541060597816ULL, 0x010fe40000000061ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000001f00627306ULL, 0x0005220000200c00ULL,
0x00000018ff1e7819ULL, 0x002fe2000001142bULL, 0x000000582434723cULL, 0x000fe20000001834ULL,
0x00000100144e7824ULL, 0x000fe200078e00ffULL, 0x00008880154f7816ULL, 0x040fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x000054105b5a7816ULL, 0x020fc4000000005aULL,
0x0000002800297306ULL, 0x0003e20000200c00ULL, 0x0000001330308232ULL, 0x088fe20000000000ULL,
0x000054106c587816ULL, 0x000fe2000000006dULL, 0x0000001332328232ULL, 0x000fe20000000000ULL,
0x00000018ff1f7819ULL, 0x004fe2000001142aULL, 0x0000001c31318232ULL, 0x080fe20000000000ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x0000001c33338232ULL, 0x000fe20000000000ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x002fe200078e00ffULL,
0x00005410635b7816ULL, 0x010fe20000000062ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00008880171c7816ULL, 0x000fe200000000ffULL, 0x0000010016137824ULL, 0x040fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000005a2418723cULL, 0x000fe20000001818ULL,
0x00000018ff2a7819ULL, 0x000fc4000001142aULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000002e002e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff167819ULL, 0x000fc60000011416ULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x000054106e597816ULL, 0x002fce000000006fULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000000583058723cULL, 0x000fee0000001820ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x000054103b3b7816ULL, 0x004fce000000002eULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x00005410394c7816ULL, 0x002fce000000004cULL, 0x0000002f002f7306ULL, 0x000fe20000200c00ULL,
0x00005410684d7816ULL, 0x008fce000000004dULL, 0x0000003a003a7306ULL, 0x000e620000200c00ULL,
0x000054106b6b7816ULL, 0x004fe20000000038ULL, 0x0000004c2444723cULL, 0x040fec0000001844ULL,
0x0000000e000e7306ULL, 0x000ea40000200c00ULL, 0x0000006a2440723cULL, 0x000fec0000001840ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000054103a3a7816ULL, 0x002fce000000002fULL,
0x0000002800737306ULL, 0x0002e20000200c00ULL, 0x00005410710e7816ULL, 0x004fe2000000000eULL,
0x0000003a2424723cULL, 0x000fec0000001848ULL, 0x0000000f002e7306ULL, 0x0005e20000200c00ULL,
0x0000888014287816ULL, 0x042fe200000000ffULL, 0x0001000014147824ULL, 0x000fca00078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000002c002c7306ULL, 0x000e620000200c00ULL,
0x00000100170f7824ULL, 0x044fe400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe4000001140fULL, 0x00005410720f7816ULL, 0x008fe20000000073ULL,
0x0000005000617306ULL, 0x0005e20000200c00ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00005410292c7816ULL, 0x002fca000000002cULL, 0x0000002d002d7306ULL, 0x000e620000200c00ULL,
0x0000000e3050723cULL, 0x004fee0000001834ULL, 0x0000001f001f7306ULL, 0x000ff00000200c00ULL,
0x0000001e001e7306ULL, 0x000fe20000200c00ULL, 0x00005410702d7816ULL, 0x002fce000000002dULL,
0x0000001100117306ULL, 0x000fe20000200c00ULL, 0x0000002c3054723cULL, 0x000fee0000001854ULL,
0x0000001200127306ULL, 0x000ff00000200c00ULL, 0x0000002a002a7306ULL, 0x000e700000200c00ULL,
0x0000002b002b7306ULL, 0x000eb00000200c00ULL, 0x0000002800287306ULL, 0x000fe20000200c00ULL,
0x000054102a2a7816ULL, 0x002fce000000001fULL, 0x0000004e00757306ULL, 0x000e620000200c00ULL,
0x000054102b2b7816ULL, 0x004fce000000001eULL, 0x0000004f00607306ULL, 0x0004f00000200c00ULL,
0x0000001400147306ULL, 0x000f220000200c00ULL, 0x0000541028287816ULL, 0x002fe20000000075ULL,
0x0000002a304c723cULL, 0x004fec0000001818ULL, 0x0000001500157306ULL, 0x000e620000200c00ULL,
0x0000541060297816ULL, 0x008fce0000000061ULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541014147816ULL, 0x010fe20000000011ULL, 0x000000283048723cULL, 0x000fec000000183cULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x0000541015157816ULL, 0x002fce0000000012ULL,
0x00000020002f7306ULL, 0x000e620000200c00ULL, 0x000054102e2e7816ULL, 0x004fe20000000013ULL,
0x000000143044723cULL, 0x000fec0000001844ULL, 0x0000000c000c7306ULL, 0x000ff00000200c00ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x000054101c2f7816ULL, 0x002fce000000002fULL,
0x00000016000f7306ULL, 0x000e620000200c00ULL, 0x0000002e3040723cULL, 0x000fee0000001840ULL,
0x00000017000e7306ULL, 0x000ea20000200c00ULL, 0x000054100f0c7816ULL, 0x002fe4000000000cULL,
0x000054100e0d7816ULL, 0x004fce000000000dULL, 0x0000000c3030723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff357224ULL, 0x002fc600078e000dULL,
0x0000030004047a10ULL, 0x000fc80007ffe0ffULL, 0x000000060400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff340000007947ULL, 0x000fea000383ffffULL,
0x0000000000127919ULL, 0x000ee40000002500ULL, 0x000000061200720cULL, 0x008fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000000b027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e000bULL, 0x0000db50001a7802ULL, 0x000fe40000000f00ULL,
0x000095d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x000ee40000001000ULL,
0xbf80000004027423ULL, 0x008fc8000000000bULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000077919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x012fe40000011607ULL, 0x0000000807077811ULL, 0x000fe200078ff0ffULL,
0x0000000403047220ULL, 0x008fca0000410000ULL, 0x00001f0504057589ULL, 0x000e6800000e0000ULL,
0x00001f0704077589ULL, 0x000ee200000e0000ULL, 0x0000005805587220ULL, 0x042fe40000410000ULL,
0x0000005905597220ULL, 0x040fe40000410000ULL, 0x0000005405547220ULL, 0x040fe40000410000ULL,
0x0000005505557220ULL, 0x000fc40000410000ULL, 0x0000005005507220ULL, 0x040fe40000410000ULL,
0x0000005105517220ULL, 0x040fe40000410000ULL, 0x0000004c054c7220ULL, 0x040fe40000410000ULL,
0x0000004d054d7220ULL, 0x040fe40000410000ULL, 0x0000004805487220ULL, 0x040fe40000410000ULL,
0x0000004905497220ULL, 0x000fc40000410000ULL, 0x0000004405447220ULL, 0x040fe40000410000ULL,
0x0000004505457220ULL, 0x040fe40000410000ULL, 0x0000004005407220ULL, 0x040fe40000410000ULL,
0x0000004105417220ULL, 0x040fe40000410000ULL, 0x0000003005307220ULL, 0x040fe40000410000ULL,
0x0000003105317220ULL, 0x000fc40000410000ULL, 0x0000005a075a7220ULL, 0x048fe40000410000ULL,
0x0000005b075b7220ULL, 0x040fe40000410000ULL, 0x0000005607567220ULL, 0x040fe40000410000ULL,
0x0000005707577220ULL, 0x040fe40000410000ULL, 0x0000005207527220ULL, 0x040fe40000410000ULL,
0x0000005307537220ULL, 0x000fc40000410000ULL, 0x0000004e074e7220ULL, 0x040fe40000410000ULL,
0x0000004f074f7220ULL, 0x040fe40000410000ULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000004b074b7220ULL, 0x040fe40000410000ULL, 0x0000004607467220ULL, 0x040fe40000410000ULL,
0x0000004707477220ULL, 0x000fc40000410000ULL, 0x0000004207427220ULL, 0x040fe40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003207327220ULL, 0x040fe40000410000ULL,
0x0000003307337220ULL, 0x000fe40000410000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x00000300ff207624ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x000000012000780cULL, 0x000fe40003f05270ULL, 0x0000000203027812ULL, 0x008fe400078ec0ffULL,
0x00000002ff117819ULL, 0x002fe40000011603ULL, 0x00000001ff047819ULL, 0x000fe40000011602ULL,
0x0000000202057811ULL, 0x000fc400078ff8ffULL, 0x0000000402097811ULL, 0x040fe400078ff8ffULL,
0x00000006020e7811ULL, 0x004fe400078ff8ffULL, 0x0000000803197811ULL, 0x000fe400078ff0ffULL,
0x0000000704027812ULL, 0x140fe400078e7811ULL, 0x00000007090c7812ULL, 0x040fe400078e7811ULL,
0x0000000709097812ULL, 0x100fe200078e7819ULL, 0x0000000811077824ULL, 0x000fe200078e0202ULL,
0x0000000704047812ULL, 0x000fe200078e7819ULL, 0x0000080000027824ULL, 0x000fe200078e00ffULL,
0x0000000705067812ULL, 0x000fe200078e7811ULL, 0x0000000819177824ULL, 0x000fe200078e0209ULL,
0x0000000705057812ULL, 0x000fe200078e7819ULL, 0x0000000819137824ULL, 0x000fe200078e0204ULL,
0x0000a00002047810ULL, 0x000fe20007ffe0ffULL, 0x0000000803097824ULL, 0x000fe200078e00ffULL,
0x000000070e107812ULL, 0x040fe200078e7811ULL, 0x00000008110f7824ULL, 0x040fe200078e020cULL,
0x000000070e0e7812ULL, 0x000fe200078e7819ULL, 0x00000008110d7824ULL, 0x000fe200078e0206ULL,
0x00000008090c7812ULL, 0x000fe200078ec0ffULL, 0x0000000819157824ULL, 0x000fe200078e0205ULL,
0x000000585905723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000545506723eULL, 0x000fe200000000ffULL, 0x000000100f097824ULL, 0x000fc400078e0204ULL,
0x0000000819197824ULL, 0x000fe200078e020eULL, 0x00005410051a7816ULL, 0x000fe20000000006ULL,
0x0000000811117824ULL, 0x000fe200078e0210ULL, 0x00007632051b7816ULL, 0x000fe20000000006ULL,
0x00000001070e7824ULL, 0x000fe200078e020cULL, 0x000000505107723eULL, 0x000fe200000000ffULL,
0x000000010c107824ULL, 0x040fe200078e0209ULL, 0x0000004c4d09723eULL, 0x000fe200000000ffULL,
0x000000100d0d7824ULL, 0x100fe200078e0204ULL, 0x0000001a0e007388ULL, 0x0003e20000000a00ULL,
0x000000484905723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0204ULL,
0x000000444506723eULL, 0x000fe200000000ffULL, 0x000000010c0f7824ULL, 0x000fe200078e020dULL,
0x00000056570d723eULL, 0x000fe200000000ffULL, 0x0000001013137824ULL, 0x000fc400078e0204ULL,
0x0000001015157824ULL, 0x100fe400078e0204ULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x00005410071a7816ULL, 0x102fe20000000009ULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x00007632071b7816ULL, 0x000fe20000000009ULL, 0x000000010c117824ULL, 0x040fe200078e0211ULL,
0x00005410050e7816ULL, 0x000fe20000000006ULL, 0x000000010c137824ULL, 0x040fe200078e0213ULL,
0x000000404107723eULL, 0x000fe200000000ffULL, 0x0000001a0f007388ULL, 0x0003e20000000a00ULL,
0x000000303109723eULL, 0x000fe200000000ffULL, 0x000000010c157824ULL, 0x000fc400078e0215ULL,
0x000000010c177824ULL, 0x040fe400078e0217ULL, 0x000000010c197824ULL, 0x000fe200078e0219ULL,
0x0000005a5b0c723eULL, 0x000fe400000000ffULL, 0x00007632050f7816ULL, 0x002fe40000000006ULL,
0x000000525305723eULL, 0x000fe400000000ffULL, 0x0000004e4f06723eULL, 0x000fe200000000ffULL,
0x0000000e10007388ULL, 0x0003e40000000a00ULL, 0x00005410070e7816ULL, 0x002fc40000000009ULL,
0x00007632070f7816ULL, 0x000fe40000000009ULL, 0x0000004a4b07723eULL, 0x000fe400000000ffULL,
0x000000464709723eULL, 0x000fe200000000ffULL, 0x0000000e11007388ULL, 0x0003e40000000a00ULL,
0x000054100c0e7816ULL, 0x142fe4000000000dULL, 0x000076320c0f7816ULL, 0x000fe4000000000dULL,
0x00000042430c723eULL, 0x000fc400000000ffULL, 0x00000032330d723eULL, 0x000fe200000000ffULL,
0x0000000e13007388ULL, 0x0003e40000000a00ULL, 0x00005410050e7816ULL, 0x142fe40000000006ULL,
0x00007632050f7816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000009ULL,
0x0000763207077816ULL, 0x000fe20000000009ULL, 0x0000000e15007388ULL, 0x0003e80000000a00ULL,
0x0000000617007388ULL, 0x0005e20000000a00ULL, 0x000054100c0e7816ULL, 0x002fc4000000000dULL,
0x000076320c0f7816ULL, 0x000fca000000000dULL, 0x0000000e19007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b7000008947ULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e620000002700ULL, 0x00000010030e7824ULL, 0x044fe200078e0202ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x0000580020057a24ULL, 0x000fe200078e02ffULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00001000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000002003157810ULL, 0x000fe20007ffe0ffULL, 0x0000660005077a24ULL, 0x000fe200078e02ffULL,
0x00a000000e187984ULL, 0x0004e20000000c00ULL, 0x000000ff0300720cULL, 0x000fc60000725670ULL,
0x00a200000e1c7984ULL, 0x0005220000000c00ULL, 0x0000580009097a24ULL, 0x002fe200078e0206ULL,
0x00000fff07067811ULL, 0x000fc600078e40ffULL, 0x0000030009057a24ULL, 0x000fc800078e02ffULL,
0x00000001050f7824ULL, 0x000fca00078e0212ULL, 0x0000000f060c7211ULL, 0x000fca00078fa0ffULL,
0x00006c000c0c7625ULL, 0x000fcc00078e000dULL, 0x00000400000c7825ULL, 0x000fcc00078e000cULL,
0x0000001015147825ULL, 0x000fc800078e000cULL, 0x0000001003127825ULL, 0x000fe200078e000cULL,
0x01ffffff070c7812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x01cfe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011603ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010f107824ULL, 0x000fe200078e020cULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00006c000f0e7625ULL, 0x000fe200078e0011ULL,
0x0000000c0d0d7812ULL, 0x000fc600078ec0ffULL, 0x00006c0010107625ULL, 0x000fe200078e0011ULL,
0x0000000e0d0e7210ULL, 0x000fc80007b5e007ULL, 0x000000100d107210ULL, 0x000fe40007d9e007ULL,
0x0000000fff0f7210ULL, 0x000fe400017e64ffULL, 0x00000011ff117210ULL, 0x000fc600027ea4ffULL,
0x0000000a0e007986ULL, 0x0003e8000c101906ULL, 0x0000000b10007986ULL, 0x0003e4000c101906ULL,
0x0000001812007986ULL, 0x01c5e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x0000001c14007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0a7424ULL, 0x002fe200078e00ffULL,
0xffffffff20077810ULL, 0x000fc60007ffe0ffULL, 0x00006a00090a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000070a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x000000070a00720cULL, 0x008fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000800000ULL,
0x00000009ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff077984ULL, 0x000ee40000000000ULL,
0x000000ff0700720cULL, 0x008fda0003f25270ULL, 0x000027b000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x002fe20000011603ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001050e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x0000000c0a117812ULL, 0x000fe400078ec0ffULL,
0x00000070070d7812ULL, 0x000fe200078ec0ffULL, 0x00006c00050a7625ULL, 0x000fc800078e0009ULL,
0x00006c000e0e7625ULL, 0x000fe200078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000e110e7210ULL, 0x000fe40007b5e00dULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x000000060a077981ULL, 0x000368000c1e1900ULL,
0x000000060e107981ULL, 0x000362000c1e1900ULL, 0x000000022000780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x004362000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004050a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0009ULL, 0x0000000a110a7210ULL, 0x000fc8000791e00dULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005050a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fc8000791e00dULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a187981ULL, 0x000362000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082000780cULL, 0x002fe40003f06070ULL,
0x00000006050a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0009ULL,
0x0000000a110a7210ULL, 0x000fe40007a3e00dULL, 0x00000007050e0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fe400078e0009ULL,
0x000000060a1c7981ULL, 0x000366000c1e1900ULL, 0x0000000e110e0210ULL, 0x000fc80007c7e00dULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000060e1e0981ULL, 0x000368000c1e1900ULL,
0x0000000720097810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff097819ULL, 0x000fc80000011609ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x024fe400078e0007ULL,
0x000000080e0d7824ULL, 0x040fe200078e00ffULL, 0x000000010e0e7810ULL, 0x000fc80007ffe0ffULL,
0x000003000d007a0cULL, 0x000fe40003f26070ULL, 0x000000090e00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080d0a7810ULL, 0x040fe40007ffe0ffULL,
0x000000010d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001a07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1a7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000020d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000030d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001207077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001407077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000050d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001607077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0d0a7810ULL, 0x042fe40007ffe0ffULL, 0x000000060d0b7810ULL, 0x000fe40007ffe0ffULL,
0x000003000a007a0cULL, 0x000fe40003f26070ULL, 0x000003000b007a0cULL, 0x000fe40003f46070ULL,
0x0000001807077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0d0a7810ULL, 0x042fe40007ffe0ffULL,
0x000000070d0b7810ULL, 0x000fe40007ffe0ffULL, 0x000003000a007a0cULL, 0x000fe40003f26070ULL,
0x000003000b007a0cULL, 0x000fe40003f46070ULL, 0x0000001c07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001050a7824ULL, 0x000fe200078e020aULL,
0x00000001ff117819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1c7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0d0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000001e07077209ULL, 0x000fe40007810000ULL,
0x000003000a007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001050a7824ULL, 0x000fe200078e020aULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0f0a7210ULL, 0x000fc80007a3e00dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a1e7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003097824ULL, 0x008fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x002fc80000011603ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fca00078ec0ffULL,
0x00000001090a7824ULL, 0x000fca00078e020aULL, 0x000000070a007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000005060a7211ULL, 0x002fe200078fa0ffULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011603ULL, 0x00000400003b7824ULL, 0x000fe200078e00ffULL,
0x00000016ff3d7819ULL, 0x000fe20000011600ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c090e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000020030f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x0000003b0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105108824ULL, 0x000fe200078e020cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x00000080ff128424ULL, 0x004fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000010b0b7824ULL, 0x000fe200008e063dULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000100000227824ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00006c0010108625ULL, 0x000fe200078e0011ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000001000158824ULL, 0x000fe200078e0203ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00006c0005128625ULL, 0x000fc600078e0012ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x0000000107197824ULL, 0x000fe400078e020eULL,
0x0000001000178824ULL, 0x000fe400078e0203ULL, 0x000000100f0e7825ULL, 0x000fe400078e000aULL,
0x0000000019197984ULL, 0x000e620000000800ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x00000010030d7824ULL, 0x040fe400078e0222ULL, 0x00000010030a7825ULL, 0x000fc800078e000aULL,
0x0000001003108825ULL, 0x040fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a0d7faeULL, 0x0005e6000b901c46ULL, 0x0000001003128825ULL, 0x000fe200078e0012ULL,
0x003800000e0d7faeULL, 0x0007e6000b901c46ULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000010158faeULL, 0x0009e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fc400078e00ffULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000000012178faeULL, 0x000be2000b901c46ULL,
0x00000000000a7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff187224ULL, 0x000fe400078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff0d7224ULL, 0x008fe200078e00ffULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x020fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000d0000009947ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134367810ULL, 0x000fc80007ffe0ffULL, 0x0000030036007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000105357824ULL, 0x000fe200078e0236ULL,
0x000000070300780cULL, 0x040fe20003f24070ULL, 0x00001000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000136217812ULL, 0x040fe200078ec0ffULL, 0x00000800361c7824ULL, 0x000fe200078e00ffULL,
0x00000035061a7211ULL, 0x000fe400078fa0ffULL, 0x0000002003397810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1f7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fc800078e001bULL,
0x000000010c1d9824ULL, 0x000fe200078e0235ULL, 0x0000003b1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x0000000200209824ULL, 0x000fe400078e0221ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00006c001d1c9625ULL, 0x000fc800078e001eULL,
0x00000001221e7824ULL, 0x000fe400078e021fULL, 0x00000002003a9824ULL, 0x000fe400078e0221ULL,
0x000000011b1b7824ULL, 0x000fe400000e063dULL, 0x0000000820379824ULL, 0x000fe400078e0203ULL,
0x00006c0035209625ULL, 0x000fc600078e0038ULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001003357824ULL, 0x040fe400078e021eULL, 0x000000083a3a9824ULL, 0x000fe400078e0203ULL,
0x00000010031e9825ULL, 0x000fc800078e001cULL, 0x00000010391c7825ULL, 0x000fe200078e001aULL,
0x000041803a399811ULL, 0x000fc600078e20ffULL, 0x00000010031a7825ULL, 0x000fc800078e001aULL,
0x0000001003209825ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001a357faeULL, 0x0005e8000b901c46ULL, 0x003800001c357faeULL, 0x0005e8000b901c46ULL,
0x000000001e379faeULL, 0x0005e8000b901c46ULL, 0x0000000020399faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e0034ULL,
0x00000001ff1e7819ULL, 0x100fe20000011603ULL, 0x00000010031c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff357819ULL, 0x000fe20000011603ULL, 0x000000801d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000835217824ULL, 0x040fe200078e00ffULL, 0x000000801a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008351f7824ULL, 0x040fe200078e00ffULL, 0x0000000735407812ULL, 0x000fe400078ec0ffULL,
0x00000035ff3e7212ULL, 0x000fe200078e33ffULL, 0x00000100001b7824ULL, 0x000fe200078e021bULL,
0xfffffff81f1a7812ULL, 0x000fe400078ee240ULL, 0xfffffff8213e7812ULL, 0x000fc400078ee23eULL,
0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL, 0x00000008351b7824ULL, 0x040fe200078e00ffULL,
0x0000000835377810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c3c7984ULL, 0x000ea20000000800ULL, 0x000000011b1e7812ULL, 0x100fe200078ef640ULL,
0x00000008371f7824ULL, 0x000fe200078e00ffULL, 0x000000021b207812ULL, 0x140fe200078ef640ULL,
0x004580001c4e7984ULL, 0x0004e20000000800ULL, 0x000000031b347812ULL, 0x100fe200078ef640ULL,
0x0000000837427824ULL, 0x000fe200078e00ffULL, 0x000000041b387812ULL, 0x140fe400078ef640ULL,
0x000000051b3a7812ULL, 0x000fe400078ef640ULL, 0x00000037ff4c7212ULL, 0x000fc800078e33ffULL,
0xfffffff81f4c7812ULL, 0x000fe400078ee24cULL, 0x00000007371f7812ULL, 0x000fe200078ec0ffULL,
0x0000003c191c7221ULL, 0x006fe20000010100ULL, 0x000000061b3c7812ULL, 0x000fe200078ef640ULL,
0x000008001d1b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000004031c7824ULL, 0x000fe200078e00ffULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000000837407824ULL, 0x000fc400078e00ffULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x00000180221b7810ULL, 0x000fe40007ffe01bULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8421c7812ULL, 0x000fe200078ee21fULL, 0x000000101a1a7824ULL, 0x000fe200078e021bULL,
0x0000000140427812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x0000000240447812ULL, 0x000fe200078ef61fULL, 0x000000011a1a7824ULL, 0x000fe200078e021dULL,
0x0000000340467812ULL, 0x140fe200078ef61fULL, 0x000000011d1e7824ULL, 0x040fe200078e021eULL,
0x0000000440487812ULL, 0x000fe200078ef61fULL, 0x0000001034347824ULL, 0x000fe200078e021bULL,
0x00000005404a7812ULL, 0x000fe200078ef61fULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x000000103e3e7824ULL, 0x000fe200078e021bULL, 0x0000000640407812ULL, 0x000fe200078ef61fULL,
0x000000011d347824ULL, 0x000fe200078e0234ULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000103a3a7824ULL, 0x000fc400078e021bULL, 0x000000011d3e7824ULL, 0x040fe400078e023eULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x000000011d3a7824ULL, 0x000fe400078e023aULL,
0x0000001020207824ULL, 0x100fe200078e021bULL, 0x000000003e3e7984ULL, 0x000ea20000000800ULL,
0x000000103c3c7824ULL, 0x000fe400078e021bULL, 0x0000004e214e7220ULL, 0x008fe20000410000ULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x000000011d207824ULL, 0x000fc400078e0220ULL,
0x000000011d3c7824ULL, 0x040fe200078e023cULL, 0x00001f354e1f7589ULL, 0x000ee200000e0000ULL,
0x0000001038387824ULL, 0x100fe400078e021bULL, 0x0000001042427824ULL, 0x100fe200078e021bULL,
0x0000000020207984ULL, 0x000f220000000800ULL, 0x000000011d387824ULL, 0x040fe400078e0238ULL,
0x000000011d427824ULL, 0x000fe200078e0242ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x000000101c1c7824ULL, 0x000fc400078e021bULL, 0x0000001046467824ULL, 0x100fe200078e021bULL,
0x0000000038387984ULL, 0x000f620000000800ULL, 0x000000011d1c7824ULL, 0x040fe400078e021cULL,
0x000000011d467824ULL, 0x040fe200078e0246ULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x0000001044447824ULL, 0x100fe400078e021bULL, 0x0000001048487824ULL, 0x000fe200078e021bULL,
0x000000001c1c7984ULL, 0x000f620000000800ULL, 0x000000011d447824ULL, 0x000fc400078e0244ULL,
0x000000011d487824ULL, 0x040fe200078e0248ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x000000104a4a7824ULL, 0x100fe400078e021bULL, 0x000000104c4c7824ULL, 0x100fe200078e021bULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x0000001040407824ULL, 0x000fe200078e021bULL,
0x2000001aff1b7230ULL, 0x102fe20000004100ULL, 0x000000011d4a7824ULL, 0x040fe200078e024aULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x000000011d4c7824ULL, 0x040fe200078e024cULL,
0x3000001aff1a7230ULL, 0x000fe20000004100ULL, 0x000000011d407824ULL, 0x000fe200078e0240ULL,
0x2000003eff1d7230ULL, 0x004fe20000004100ULL, 0x0000001f1b327223ULL, 0x088fe20000010032ULL,
0x2000001eff1b7230ULL, 0x000fe20000004100ULL, 0x000000004a4a7984ULL, 0x000fe20000000800ULL,
0x000000334e337221ULL, 0x000fe20000010000ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000001f1d247223ULL, 0x080fe20000010024ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x0000001f1b307223ULL, 0x080fe20000010030ULL, 0x20000034ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1a317223ULL, 0x080fe20000010031ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x20000020ff1d7230ULL, 0x010fe20000004100ULL, 0x0000001f3e237223ULL, 0x080fe20000010023ULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x00001f374e4e7589ULL, 0x000e6200000e0000ULL,
0x0000001f1b2c7223ULL, 0x080fe2000001002cULL, 0x2000003aff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1d2e7223ULL, 0x080fe2000001002eULL, 0x20000038ff1d7230ULL, 0x020fe20000004100ULL,
0x0000001f342b7223ULL, 0x080fe2000001002bULL, 0x3000001eff1e7230ULL, 0x000fe20000004100ULL,
0x0000001f1b287223ULL, 0x080fe20000010028ULL, 0x2000003cff1b7230ULL, 0x000fe20000004100ULL,
0x000000ffff347224ULL, 0x000fe200078e0036ULL, 0x30000020ff207230ULL, 0x000fe20000004100ULL,
0x0000001f1d2a7223ULL, 0x080fe2000001002aULL, 0x2000001cff1d7230ULL, 0x000fe20000004100ULL,
0x0000001f1b267223ULL, 0x080fe20000010026ULL, 0x20000042ff1b7230ULL, 0x000fe20000004100ULL,
0x0000030034007a0cULL, 0x000fe20003f06070ULL, 0x3000001cff1c7230ULL, 0x000fe20000004100ULL,
0x0000001f1e2f7223ULL, 0x080fe2000001002fULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000001f202d7223ULL, 0x000fe2000001002dULL, 0x3000003aff3a7230ULL, 0x000fc40000004100ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000001f38297223ULL, 0x080fe20000010029ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000004e1b167223ULL, 0x082fe20000010016ULL,
0x20000046ff1b7230ULL, 0x000fe20000004100ULL, 0x0000004e1d187223ULL, 0x080fe20000010018ULL,
0x20000044ff1d7230ULL, 0x100fe20000004100ULL, 0x0000004e1c177223ULL, 0x080fe20000010017ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000004e1b127223ULL, 0x080fe20000010012ULL,
0x20000048ff1b7230ULL, 0x000fe20000004100ULL, 0x0000004e1d147223ULL, 0x080fe20000010014ULL,
0x2000004aff1d7230ULL, 0x000fe20000004100ULL, 0x0000001f3a277223ULL, 0x080fe20000010027ULL,
0x2000004cff1c7230ULL, 0x000fe20000004100ULL, 0x0000004e1b107223ULL, 0x080fe20000010010ULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000001f3c257223ULL, 0x000fe20000010025ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000004e42157223ULL, 0x080fe20000010015ULL,
0x3000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000004e44137223ULL, 0x080fe20000010013ULL,
0x20000040ff1a7230ULL, 0x100fe20000004100ULL, 0x0000004e46117223ULL, 0x080fe20000010011ULL,
0x30000040ff1b7230ULL, 0x000fe20000004100ULL, 0x0000004e480f7223ULL, 0x080fe2000001000fULL,
0x3000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000004e1d0e7223ULL, 0x000fc4000001000eULL,
0x0000004e4a0d7223ULL, 0x080fe4000001000dULL, 0x0000004e1a0b7223ULL, 0x080fe4000001000bULL,
0x0000004e1b0a7223ULL, 0x080fe4000001000aULL, 0x0000004e1c097223ULL, 0x080fe40000010009ULL,
0x0000004e4c077223ULL, 0x000fe20000010007ULL, 0xfffff32000008947ULL, 0x000fea000383ffffULL,
0x0180000033007810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0033ULL, 0x00010610001a7802ULL, 0x000fe40000000f00ULL,
0x00006b1000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300007308ULL, 0x000ea40000001000ULL,
0xbf80000000037423ULL, 0x004fc80000000033ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000008033b7811ULL, 0x004fe400078ff0ffULL, 0x00000002ff1f7819ULL, 0x000fe40000011603ULL,
0x0000003bff3d7212ULL, 0x000fe200078e33ffULL, 0x00001f3b00067589ULL, 0x000ea200000e0000ULL,
0x000000083b0c7824ULL, 0x000fc400078e00ffULL, 0x000000081f3f7824ULL, 0x000fe200078e00ffULL,
0x00001f1f00057589ULL, 0x0022e200000e0000ULL, 0x000000083b1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c3d7812ULL, 0x000fe200078ee23dULL, 0x000000081f0c7824ULL, 0x000fc600078e00ffULL,
0xfffffff81a217812ULL, 0x000fe200078ee23bULL, 0x000000103d3d7824ULL, 0x000fe200078e0204ULL,
0x0000001fff007212ULL, 0x002fc600078e33ffULL, 0x0000001021217824ULL, 0x000fe200078e0204ULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee200ULL, 0x000000071f007812ULL, 0x000fe200078ec0ffULL,
0x0000001406147220ULL, 0x044fe40000410000ULL, 0x0000001306137220ULL, 0x040fe40000410000ULL,
0x0000001206127220ULL, 0x040fe40000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x0000001006107220ULL, 0x000fe20000410000ULL,
0x0000000500147812ULL, 0x000fe200078e3cffULL, 0x0000000f060f7220ULL, 0x040fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000000e060e7220ULL, 0x000fe20000410000ULL,
0x0000000400127812ULL, 0x000fe200078e3cffULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x0000001806187220ULL, 0x000fe20000410000ULL,
0x0000000300107812ULL, 0x000fe200078e3cffULL, 0x0000001706177220ULL, 0x040fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000001606167220ULL, 0x000fe20000410000ULL,
0x00000002000e7812ULL, 0x000fe200078e3cffULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000000ffULL, 0x0000000b060b7220ULL, 0x040fe20000410000ULL,
0x000000073b187812ULL, 0x000fe200078ec0ffULL, 0x0000000a060a7220ULL, 0x040fe20000410000ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x0000000906097220ULL, 0x000fc40000410000ULL,
0x0000000706067220ULL, 0x000fe20000410000ULL, 0xfffffff80c077812ULL, 0x000fe200078ee21fULL,
0x000000081f197824ULL, 0x040fe200078e0210ULL, 0x00000001000c7812ULL, 0x040fe200078e3cffULL,
0x000000081f1b7824ULL, 0x040fe200078e0212ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x000000081f1d7824ULL, 0x040fe200078e0214ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x000000081f0b7824ULL, 0x040fe200078e020eULL, 0x000000090606723eULL, 0x000fe200000000ffULL,
0x000000081f097824ULL, 0x040fe200078e020cULL, 0x00000002180c7812ULL, 0x040fe200078e3cffULL,
0x000000081f1f7824ULL, 0x000fe200078e0200ULL, 0x0000000118007812ULL, 0x040fe200078e3cffULL,
0x0000000403167824ULL, 0x000fe200078e00ffULL, 0x00000003180e7812ULL, 0x040fe200078e3cffULL,
0x0000003205327220ULL, 0x048fe20000410000ULL, 0x0000000418107812ULL, 0x040fe200078e3cffULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000000518127812ULL, 0x040fe200078e3cffULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000000618147812ULL, 0x000fe200078e3cffULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000000c16227812ULL, 0x000fe200078ec0ffULL,
0x0000002e052e7220ULL, 0x000fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x000000302f2f723eULL, 0x000fe200000000ffULL,
0x0000002c052c7220ULL, 0x000fc40000410000ULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000002805287220ULL, 0x040fe40000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000002605267220ULL, 0x000fc40000410000ULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x0000002405247220ULL, 0x040fe40000410000ULL, 0x0000002305057220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x000000083b237824ULL, 0x040fe400078e0200ULL,
0x000000083b337824ULL, 0x000fe200078e020cULL, 0x000000240505723eULL, 0x000fe200000000ffULL,
0x000000083b357824ULL, 0x000fc400078e020eULL, 0x000000083b377824ULL, 0x040fe400078e0210ULL,
0x000000083b397824ULL, 0x040fe400078e0212ULL, 0x000000083b3b7824ULL, 0x000fe400078e0214ULL,
0x0000001007077824ULL, 0x100fe400078e0204ULL, 0x000000103f0c7824ULL, 0x100fe400078e0204ULL,
0x0000001009097824ULL, 0x000fc400078e0204ULL, 0x000000100b0b7824ULL, 0x100fe400078e0204ULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x0000000122007824ULL, 0x000fe400078e0207ULL,
0x000000101b1b7824ULL, 0x100fe400078e0204ULL, 0x000000101d1d7824ULL, 0x100fe200078e0204ULL,
0x0000003100007388ULL, 0x0003e20000000800ULL, 0x000000101f1f7824ULL, 0x000fc400078e0204ULL,
0x0000001023237824ULL, 0x100fe400078e0204ULL, 0x0000001033337824ULL, 0x100fe400078e0204ULL,
0x0000001035357824ULL, 0x100fe400078e0204ULL, 0x0000001037377824ULL, 0x100fe400078e0204ULL,
0x0000001039397824ULL, 0x100fe400078e0204ULL, 0x000000103b3b7824ULL, 0x000fc400078e0204ULL,
0x0000000122167824ULL, 0x040fe400078e020cULL, 0x0000000122047824ULL, 0x040fe400078e0209ULL,
0x00000001220c7824ULL, 0x040fe400078e020bULL, 0x00000001220e7824ULL, 0x040fe200078e0219ULL,
0x0000002f04007388ULL, 0x0005e20000000800ULL, 0x0000000122107824ULL, 0x040fe400078e021bULL,
0x0000000122127824ULL, 0x040fe200078e021dULL, 0x0000002d0c007388ULL, 0x0005e20000000800ULL,
0x0000000122147824ULL, 0x000fc400078e021fULL, 0x0000000122187824ULL, 0x040fe200078e0221ULL,
0x0000002b0e007388ULL, 0x0005e20000000800ULL, 0x00000001221a7824ULL, 0x040fe400078e0223ULL,
0x0000000122007824ULL, 0x042fe200078e0233ULL, 0x0000002910007388ULL, 0x0005e20000000800ULL,
0x00000001221c7824ULL, 0x040fe400078e0235ULL, 0x00000001221e7824ULL, 0x040fe200078e0237ULL,
0x0000002712007388ULL, 0x0005e20000000800ULL, 0x0000000122207824ULL, 0x000fc400078e0239ULL,
0x00000001223b7824ULL, 0x040fe200078e023bULL, 0x0000002514007388ULL, 0x0005e20000000800ULL,
0x00000001223d7824ULL, 0x000fc600078e023dULL, 0x0000000516007388ULL, 0x0005e80000000800ULL,
0x0000001718007388ULL, 0x0005e80000000800ULL, 0x000000151a007388ULL, 0x0005e80000000800ULL,
0x0000001300007388ULL, 0x0005e80000000800ULL, 0x000000111c007388ULL, 0x0005e80000000800ULL,
0x0000000f1e007388ULL, 0x0005e80000000800ULL, 0x0000000d20007388ULL, 0x0005e80000000800ULL,
0x0000000a3b007388ULL, 0x0005e80000000800ULL, 0x000000063d007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000020030a7810ULL, 0x006fe20007ffe0ffULL,
0x0000000000097919ULL, 0x000e620000002600ULL, 0x00000003ff007819ULL, 0x100fe20000011603ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff067819ULL, 0x100fe2000001160aULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000700047812ULL, 0x000fe200078e4803ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000706077812ULL, 0x000fc400078e480aULL,
0x0ffffff804057812ULL, 0x000fe400078ef803ULL, 0x0ffffff807077812ULL, 0x000fc600078ef80aULL,
0x0000001005057824ULL, 0x100fe400078e0202ULL, 0x0000001007077824ULL, 0x000fc600078e0202ULL,
0x00a00000050c7984ULL, 0x0007280000000c00ULL, 0x00a0000007107984ULL, 0x000b220000000c00ULL,
0x00000008090b7824ULL, 0x042fe400078e00ffULL, 0x0000000809097824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0xfffffff80b007812ULL, 0x000fc400078ee200ULL,
0xfffffff809067812ULL, 0x000fe400078ee206ULL, 0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000406067c10ULL, 0x000fe4000ff3e0ffULL, 0x00000007030b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0000027a11ULL, 0x000fe200078048ffULL,
0x000000ffff057224ULL, 0x008fe200008e06ffULL, 0x00005a0006047a11ULL, 0x000fc400078248ffULL,
0x000000070a097812ULL, 0x000fe400078ec0ffULL, 0x00005b0000037a11ULL, 0x000fe400000f4c03ULL,
0x1ffffff80b077812ULL, 0x120fe400078ef808ULL, 0x00005b0006057a11ULL, 0x000fe400008f4c05ULL,
0x1ffffff809097812ULL, 0x000fe200078ef808ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001009047825ULL, 0x000fe200078e0004ULL, 0x0000000c02007986ULL, 0x010fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000404287824ULL, 0x000fca00078e0200ULL, 0x000000052800720cULL, 0x000fda0003f06070ULL,
0x000000020c078824ULL, 0x000fc800078e00ffULL, 0x00006400070a8a24ULL, 0x000fe400078e0228ULL,
0xffffffffff077424ULL, 0x000fe400078e00ffULL, 0x000060000a0a8625ULL, 0x000fe200078e0013ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0e7624ULL, 0x000fe200078e00ffULL,
0x000000060a078981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0f7624ULL, 0x000fc600078e00ffULL,
0x01060000ff087f8cULL, 0x000e68000c80043fULL, 0x000000060e2a7981ULL, 0x000762000c1e9900ULL,
0x00000001040d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004000297824ULL, 0x000fe400078e00ffULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x000000405f2b7824ULL, 0x000fc400078e00ffULL, 0x0000000407207c24ULL, 0x004fd4000f8e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x00000100040a7824ULL, 0x00afe200078e0229ULL,
0x00000002ff1e7819ULL, 0x100fe40000011602ULL, 0x00000003ff157819ULL, 0x000fe40000011602ULL,
0x0000000a030b7217ULL, 0x000fe20007800000ULL, 0x000000405f5f7824ULL, 0x000fe200078e021eULL,
0x0000000315157812ULL, 0x000fe400078e4802ULL, 0x00000030101f7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0d7824ULL, 0x000fe200078e0a0aULL, 0x000000085f0a7810ULL, 0x000fc40007ffe0ffULL,
0x000000105f0b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a200a7210ULL, 0x040fe40007f3e0ffULL,
0x0000005f20187210ULL, 0x040fe40007f1e0ffULL, 0x0000000b200b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005e000a167a11ULL, 0x000fe200078240ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e0018127a11ULL, 0x000fe200078040ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x00005f000a1b7a11ULL, 0x000fc400008f441bULL,
0x00005e000b137a11ULL, 0x000fe400078440ffULL, 0x000000185f0a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000d1e00720cULL, 0x000fe40003f66070ULL, 0x00005f0018187a11ULL, 0x000fe400000f440fULL,
0x00005f000b147a11ULL, 0x000fe400010f4414ULL, 0x0000000a20107210ULL, 0x000fc40007f3e0ffULL,
0x0000200000177811ULL, 0x000fe400078e68ffULL, 0x0ffffffc15027812ULL, 0x000fe200078ef802ULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x000000205f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000000121f0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001002197824ULL, 0x000fe200078e0217ULL,
0x0000000b201d7210ULL, 0x000fe40007f5e0ffULL, 0x000000285f0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0618ULL, 0x000000305f0f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000e201a7210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a197faeULL, 0x0003e2000d901c46ULL, 0x00005e0010127a11ULL, 0x000fe400078840ffULL,
0x0000001f160e7210ULL, 0x000fe40007f7e0ffULL, 0x000000385f5f7810ULL, 0x000fe40007ffe0ffULL,
0x000000081e1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000101e167810ULL, 0x000fc40007ffe0ffULL,
0x0000000f20187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e061bULL,
0x00005f0010027a11ULL, 0x000fe200020f4411ULL, 0x00000004160a7824ULL, 0x002fe200078e00ffULL,
0x0000005f205f7210ULL, 0x000fe40007f3e0ffULL, 0x0000001f13107210ULL, 0x000fe40007f9e0ffULL,
0x000000181e207810ULL, 0x000fe40007ffe0ffULL, 0x0000000d1c00720cULL, 0x040fe20003f66070ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0000001f12127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0614ULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee215ULL,
0x0000000420147824ULL, 0x000fe200078e00ffULL, 0x0000000d1600720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0602ULL, 0xfffffffc1c027812ULL, 0x000fe200078ee215ULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x0000000d2000720cULL, 0x000fe20003fa6070ULL,
0x000000100a197824ULL, 0x000fe200078e0217ULL, 0xfffffffc14147812ULL, 0x000fe200078ee215ULL,
0x00000010020b7824ULL, 0x000fe200078e0217ULL, 0x00005e001d1c7a11ULL, 0x000fc400078440ffULL,
0x000000281e0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010141b7824ULL, 0x000fe200078e0217ULL,
0x00005f001d1d7a11ULL, 0x000fe200010f4416ULL, 0x000000000e0b7faeULL, 0x0003e2000d901c46ULL,
0x000000201e027810ULL, 0x040fe40007ffe0ffULL, 0x000000301e147810ULL, 0x040fe20007ffe0ffULL,
0x0000000010197faeULL, 0x0005e2000e101c46ULL, 0x000000381e167810ULL, 0x000fe40007ffe0ffULL,
0x0000000d0a00720cULL, 0x0c0fe20003f66070ULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000d0200720cULL, 0x040fe20003f46070ULL, 0x0000000402027824ULL, 0x000fe200078e00ffULL,
0x00000000121b7faeULL, 0x0007e2000e901c46ULL, 0x00000004140e7824ULL, 0x002fe200078e00ffULL,
0xfffffffc0a0a7812ULL, 0x000fc400078ee215ULL, 0xfffffffc02027812ULL, 0x100fe200078ee215ULL,
0x0000000416107824ULL, 0x004fe200078e00ffULL, 0xfffffffc0e0e7812ULL, 0x100fe200078ee215ULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000000d1400720cULL, 0x080fe40003f86070ULL,
0xfffffffc10107812ULL, 0x000fe200078ee215ULL, 0x000000100a157824ULL, 0x100fe200078e0217ULL,
0x0000000d1600720cULL, 0x000fe20003fa6070ULL, 0x000000ffff137224ULL, 0x008fe200030e06ffULL,
0x00005e001a0f7a11ULL, 0x000fe200078c40ffULL, 0x00000010020d7824ULL, 0x000fc400078e0217ULL,
0x000000100e197824ULL, 0x000fe200078e0217ULL, 0x00005f001a137a11ULL, 0x000fe200030f4413ULL,
0x0000001010177824ULL, 0x000fe200078e0217ULL, 0x0000001f1c0a7210ULL, 0x080fe20007fde0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00005e0018107a11ULL, 0x040fe400078040ffULL,
0x0000001f0f0e7210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e061dULL,
0x00005e005f127a11ULL, 0x040fe400078c40ffULL, 0x00005f0018117a11ULL, 0x000fe200000f4411ULL,
0x000000ffff0f7224ULL, 0x000fe200008e0613ULL, 0x0000001f10107210ULL, 0x000fe20007f1e0ffULL,
0x000000000a0d7faeULL, 0x0003e2000d101c46ULL, 0x00005f005f027a11ULL, 0x000fc400030f4402ULL,
0x0000001f12127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x000000000e157faeULL, 0x0003e6000d901c46ULL, 0x000000ffff137224ULL, 0x000fe200008e0602ULL,
0x0000000010197faeULL, 0x0003e8000e101c46ULL, 0x0000000012177faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000002b020a7211ULL, 0x04afe400078ff0ffULL,
0x00000008022c7811ULL, 0x000fc400078ff0ffULL, 0x0000000a200a7210ULL, 0x000fe40007f1e0ffULL,
0x00000010020e7811ULL, 0x040fe400078ff0ffULL, 0x0000001802127811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x00005e000a247a11ULL, 0x000fe400078040ffULL,
0x0000002002147811ULL, 0x000fe200078ff0ffULL, 0x000000012b0d7824ULL, 0x040fe200078e0212ULL,
0x00005f000a267a11ULL, 0x000fe200000f440bULL, 0x000000012c0a7824ULL, 0x000fe200078e022bULL,
0x0000002802167811ULL, 0x040fe200078ff0ffULL, 0x000000012b0b7824ULL, 0x040fe200078e020eULL,
0x0000003002187811ULL, 0x040fe200078ff0ffULL, 0x000000012b0f7824ULL, 0x040fe200078e0214ULL,
0x00000038021a7811ULL, 0x000fe200078ff0ffULL, 0x000000012b117824ULL, 0x040fe200078e0216ULL,
0x00000003ff197819ULL, 0x000fe20000011602ULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000a20227210ULL, 0x040fe20007fde0ffULL, 0x000000012b137824ULL, 0x000fe200078e0218ULL,
0x0000000319197812ULL, 0x000fe200078e4802ULL, 0x000000012b157824ULL, 0x000fe200078e021aULL,
0x0000000b201e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x0000000d201c7210ULL, 0x000fe20007f1e0ffULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0x0000000f201b7210ULL, 0x000fe20007f3e0ffULL, 0x000000040e0a7824ULL, 0x000fe200078e00ffULL,
0x0000200000277811ULL, 0x000fe200078e68ffULL, 0x00000004140e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc120b7812ULL, 0x000fe200078ee219ULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000001120177210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200030e06ffULL,
0x0000001320137210ULL, 0x000fe20007f7e0ffULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0x0000001520157210ULL, 0x000fe20007f9e0ffULL, 0x000000100b1f7824ULL, 0x000fe200078e0227ULL,
0x0ffffffc19147812ULL, 0x000fe200078ef802ULL, 0x000000ffff0b7224ULL, 0x000fe200000e06ffULL,
0xfffffffc160f7812ULL, 0x000fc400078ee219ULL, 0xfffffffc2c027812ULL, 0x000fe200078ee219ULL,
0x00000010142f7824ULL, 0x100fe200078e0227ULL, 0x00005e0022207a11ULL, 0x000fe200078c40ffULL,
0x000000100f237824ULL, 0x000fe200078e0227ULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee219ULL,
0xfffffffc0e0e7812ULL, 0x100fe400078ee219ULL, 0xfffffffc18117812ULL, 0x000fe200078ee219ULL,
0x000000100a1d7824ULL, 0x000fe200078e0227ULL, 0x00005f0022227a11ULL, 0x000fe200030f440dULL,
0x00000010020d7824ULL, 0x100fe200078e0227ULL, 0x00005e001c0f7a11ULL, 0x000fe200078040ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x00000030102d7812ULL, 0x000fe200078ec0ffULL,
0x000000100e217824ULL, 0x100fe200078e0227ULL, 0x00005e001b147a11ULL, 0x000fe200078240ffULL,
0x0000001011257824ULL, 0x000fe200078e0227ULL, 0xfffffffc1a127812ULL, 0x000fe200078ee219ULL,
0x000000ffff197224ULL, 0x000fe200028e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200000f440bULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e001e117a11ULL, 0x000fe200078a40ffULL,
0x000000ffff0e7224ULL, 0x000fe200018e06ffULL, 0x000000242d0a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001012277824ULL, 0x000fe200078e0227ULL, 0x00005f001b1b7a11ULL, 0x000fe200008f4402ULL,
0x000000ffff027224ULL, 0x000fe200020e06ffULL, 0x00005e0013187a11ULL, 0x000fe200078440ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0626ULL, 0x00005e0017167a11ULL, 0x000fc400078240ffULL,
0x00005f001e1e7a11ULL, 0x000fe400028f4419ULL, 0x00005e00151a7a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2f7faeULL, 0x0003e2000b901c46ULL,
0x00005f0013197a11ULL, 0x000fe400010f440eULL, 0x00005f0017177a11ULL, 0x000fe400008f4410ULL,
0x000000202d0e7210ULL, 0x040fe40007f1e0ffULL, 0x000000112d107210ULL, 0x000fc40007f3e0ffULL,
0x00005f0015027a11ULL, 0x000fe400018f4402ULL, 0x0000000f2d127210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0622ULL, 0x000000142d147210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e061eULL, 0x000000162d167210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e061cULL, 0x000000182d187210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200018e061bULL, 0x0000001a2d1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e0617ULL, 0x000000000e0d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc400028e0619ULL, 0x000000ffff1b7224ULL, 0x000fe200000e0602ULL,
0x00000000101d7faeULL, 0x0003e8000b901c46ULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014217faeULL, 0x0003e8000b901c46ULL, 0x0000000016237faeULL, 0x0003e8000b901c46ULL,
0x0000000018257faeULL, 0x0003e8000b901c46ULL, 0x000000001a277faeULL, 0x0003e4000b901c46ULL,
0x01060400ff0b7984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x800000000bff7812ULL, 0x002fc60007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe20003800000ULL,
0x01060400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000097919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fc800078e0209ULL, 0x00000020020a7824ULL, 0x000fe200078e00ffULL,
0x00000003ff087819ULL, 0x000fc80000011602ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x000001e00a0a7812ULL, 0x000fe400078ec0ffULL, 0x00000001090d7812ULL, 0x040fe400078efcffULL,
0x00000007090b7812ULL, 0x100fe400078e7802ULL, 0x000000070d0d7812ULL, 0x100fe400078e7802ULL,
0x00000010090f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x040fe200078e020bULL,
0x0000001109097810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0d7824ULL, 0x000fe200078e020dULL,
0x000000070f0f7812ULL, 0x000fc400078e7802ULL, 0x000000000b147984ULL, 0x000e62000000cc00ULL,
0x0000000709097812ULL, 0x000fe400078e7802ULL, 0x000000010a0f7824ULL, 0x040fe200078e020fULL,
0x000000000d107984ULL, 0x000ea4000000cc00ULL, 0x000000010a097824ULL, 0x000fe400078e0209ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0017ULL,
0x000000180b007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fca00078e0013ULL, 0x0000001c0d007388ULL, 0x000fe8000000cc00ULL,
0x0000000009107984ULL, 0x000e68000000cc00ULL, 0x000000000f147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x000000200f007388ULL, 0x0003e8000000cc00ULL,
0x0000001009007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff087f8cULL, 0x002fe8000c80043fULL, 0x01060400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff027424ULL, 0x000fc800078e00ffULL, 0x00000002000a7305ULL, 0x0002a4000021f000ULL,
0x3fa0000002027823ULL, 0x002fe200000100ffULL, 0x0000000a0000735dULL, 0x004fe20003800000ULL,
0x01060400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000060400720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3d8000002a2a7820ULL, 0x020fe20000410000ULL, 0x00010688002c7811ULL, 0x000fe200078e18ffULL,
0x000064000c2d7a24ULL, 0x000fe200078e02ffULL, 0xffffffff062f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00010608002e7811ULL, 0x000fe400078e28ffULL,
0x0000010004307824ULL, 0x000fe200078e0229ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000300300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x03cfea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e0031ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000132337810ULL, 0x000fe20007ffe0ffULL, 0x00000d7000007945ULL, 0x000fe20003800000ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0032ULL, 0x00000002ff317819ULL, 0x100fe20000011633ULL,
0x0000000407457c24ULL, 0x020fe2000f8e02ffULL, 0x000000043300780cULL, 0x040fe20003f06070ULL,
0x000000ffff327224ULL, 0x000fe200078e0033ULL, 0x0000000333577812ULL, 0x000fe200078ec0ffULL,
0x0000030031347a24ULL, 0x000fca00078e0204ULL, 0x0000000134317810ULL, 0x000fc80007ffe0ffULL,
0x000000063100720cULL, 0x000fe40003f26070ULL, 0x0000000135317812ULL, 0x000fd600078e0cffULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x102fe20000011602ULL,
0x0000010034347824ULL, 0x000fe200078e0229ULL, 0x00000003ff477819ULL, 0x000fe20000011602ULL,
0x00000004574f7824ULL, 0x000fe200078e00ffULL, 0x00000010424e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000142337824ULL, 0x140fe200078e022bULL, 0x0000000842447810ULL, 0x040fe40007ffe0ffULL,
0x0000001842507810ULL, 0x000fe20007ffe0ffULL, 0x000000014e377824ULL, 0x100fe200078e022bULL,
0x00000033453d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000144367824ULL, 0x000fe200078e022bULL,
0x0000003403337217ULL, 0x000fc40007800000ULL, 0x00000037453b7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x0000003645397210ULL, 0x000fe20007f5e0ffULL,
0x0000000133337824ULL, 0x000fe200078e0a34ULL, 0x00005e003d367a11ULL, 0x000fe200078240ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x0000002842547810ULL, 0x000fe20007ffe0ffULL,
0x0000000150347824ULL, 0x000fe200078e022bULL, 0x00005e003b3a7a11ULL, 0x000fe200078640ffULL,
0x000000ffff3e7224ULL, 0x000fe200010e06ffULL, 0x0000002042527810ULL, 0x000fc40007ffe0ffULL,
0x00005f003d377a11ULL, 0x000fe200008f4440ULL, 0x000000012b3d7824ULL, 0x000fe200078e0254ULL,
0x00005e0039387a11ULL, 0x000fe400078440ffULL, 0x00005f003b3b7a11ULL, 0x000fe200018f443cULL,
0x000000012b3c7824ULL, 0x000fe200078e0252ULL, 0x0000003042567810ULL, 0x040fe40007ffe0ffULL,
0x0000003842587810ULL, 0x000fe40007ffe0ffULL, 0x0000003445407210ULL, 0x000fc40007f3e0ffULL,
0x00005f0039397a11ULL, 0x000fe200010f443eULL, 0x000000012b3e7824ULL, 0x000fe200078e0256ULL,
0x0000003d45417210ULL, 0x000fe20007fde0ffULL, 0x000000012b347824ULL, 0x000fe200078e0258ULL,
0x0000003c453f7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e06ffULL,
0x00005e00403c7a11ULL, 0x000fe200078240ffULL, 0x000000ffff4a7224ULL, 0x000fe200030e06ffULL,
0x0000003e45437210ULL, 0x040fe40007f9e0ffULL, 0x0000003445457210ULL, 0x000fe20007f7e0ffULL,
0x0000000200347824ULL, 0x000fe200078e0231ULL, 0x00005f00403d7a11ULL, 0x000fe200008f443dULL,
0x000000ffff407224ULL, 0x000fe200028e06ffULL, 0x000000334400720cULL, 0x0c0fe20003f26070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x00000003474d7812ULL, 0x000fe200078e4802ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x000000334200720cULL, 0x000fe20003f46070ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000200034347811ULL, 0x000fc400078e60ffULL,
0x0ffffffc4d497812ULL, 0x100fe400078ef802ULL, 0xfffffffc4f477812ULL, 0x000fe400078ee202ULL,
0xfffffffc444b7812ULL, 0x000fe200078ee24dULL, 0x0000001049497824ULL, 0x000fe200078e0234ULL,
0x00005e003f3e7a11ULL, 0x000fe200078a40ffULL, 0x0000001047367825ULL, 0x000fe200078e0036ULL,
0x00005e0043427a11ULL, 0x000fe400078840ffULL, 0x00005f003f3f7a11ULL, 0x000fe200028f4440ULL,
0x000000104b4b7824ULL, 0x000fe200078e0234ULL, 0x00005e0045447a11ULL, 0x000fe200078640ffULL,
0x0000001047387825ULL, 0x000fe200078e0038ULL, 0x00005e0041407a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036497faeULL, 0x0003e2000d101c46ULL,
0x00005f0043437a11ULL, 0x000fc400020f4448ULL, 0x000000335400720cULL, 0x080fe20003f86070ULL,
0x00000000384b7faeULL, 0x0005e2000c901c46ULL, 0x000000334e00720cULL, 0x080fe20003f26070ULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0x00005f0045457a11ULL, 0x000fe200018f4446ULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x000000335000720cULL, 0x0c0fe20003f46070ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x00005f0041417a11ULL, 0x000fe400028f444aULL,
0x000000335200720cULL, 0x0c0fe20003f66070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000335600720cULL, 0x0c0fe20003fa6070ULL, 0x0000000456567824ULL, 0x000fe200078e00ffULL,
0x000000335800720cULL, 0x040fe20003fc6070ULL, 0x0000000458587824ULL, 0x000fe200078e00ffULL,
0xfffffffc54377812ULL, 0x002fe200078ee24dULL, 0x0000001047387825ULL, 0x004fe200078e003cULL,
0xfffffffc4e337812ULL, 0x000fc400078ee24dULL, 0xfffffffc50497812ULL, 0x000fe200078ee24dULL,
0x00000010473c7825ULL, 0x000fe200078e0040ULL, 0xfffffffc524b7812ULL, 0x100fe400078ee24dULL,
0xfffffffc564f7812ULL, 0x100fe200078ee24dULL, 0x0000001033337824ULL, 0x100fe200078e0234ULL,
0xfffffffc58517812ULL, 0x000fe200078ee24dULL, 0x00000010374d7824ULL, 0x000fe400078e0234ULL,
0x0000001047367825ULL, 0x000fc800078e003aULL, 0x0000001049497824ULL, 0x100fe200078e0234ULL,
0x0000000036337faeULL, 0x0003e2000c901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0234ULL,
0x00000010473a7825ULL, 0x000fe200078e003eULL, 0x0000000038497faeULL, 0x0003e6000d101c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e0234ULL, 0x000000003a4b7faeULL, 0x0003e2000d901c46ULL,
0x00000010473e7825ULL, 0x000fc600078e0042ULL, 0x000000003c4d7faeULL, 0x0003e2000e101c46ULL,
0x0000001051517824ULL, 0x000fe400078e0234ULL, 0x0000001047407825ULL, 0x000fe200078e0044ULL,
0x000000003e4f7faeULL, 0x0003e8000e901c46ULL, 0x0000000040517faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x00000008023c7811ULL, 0x042fe200078ff0ffULL,
0x0000000457537824ULL, 0x000fe200078e00ffULL, 0x0000002b02347211ULL, 0x000fc400078ff0ffULL,
0x00000010023e7811ULL, 0x000fe200078ff0ffULL, 0x000000013c367824ULL, 0x000fe200078e022bULL,
0x0000004534377210ULL, 0x080fe20007f3e0ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x0000001802407811ULL, 0x000fe400078ff0ffULL, 0x0000004536337210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078240ffULL,
0x000000012b427824ULL, 0x000fe200078e0240ULL, 0x0000002802487811ULL, 0x000fe200078ff0ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0033387a11ULL, 0x000fc400078440ffULL,
0x00005f0037377a11ULL, 0x000fe200008f443aULL, 0x00000002003a7824ULL, 0x000fe200078e0231ULL,
0x0000002002447811ULL, 0x040fe200078ff0ffULL, 0x000000012b4a7824ULL, 0x000fe200078e0248ULL,
0x00005f0033397a11ULL, 0x000fe200010f4434ULL, 0x000000012b347824ULL, 0x040fe200078e023eULL,
0x00000003ff3b7819ULL, 0x000fe20000011602ULL, 0x000000012b467824ULL, 0x000fe200078e0244ULL,
0x00000030024e7811ULL, 0x000fe200078ff0ffULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x0000003802527811ULL, 0x000fc400078ff0ffULL, 0x000020003a517811ULL, 0x000fe200078e60ffULL,
0x00000004403a7824ULL, 0x000fe200078e00ffULL, 0x0000004534337210ULL, 0x080fe20007fde0ffULL,
0x000000012b507824ULL, 0x000fe200078e024eULL, 0x000000033b3b7812ULL, 0x000fe200078e4802ULL,
0x000000012b547824ULL, 0x000fe200078e0252ULL, 0x00000045423d7210ULL, 0x080fe20007fbe0ffULL,
0x000000043e427824ULL, 0x000fe200078e00ffULL, 0x000000454a417210ULL, 0x080fe20007f3e0ffULL,
0x000000044e4a7824ULL, 0x000fe200078e00ffULL, 0x00000045463f7210ULL, 0x000fe20007f9e0ffULL,
0x0000000444467824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c407812ULL, 0x100fe200078ee23bULL,
0x00000004524e7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc3b3e7812ULL, 0x000fe200078ef802ULL,
0x000000ffff3c7224ULL, 0x000fe200030e06ffULL, 0xfffffffc3a447812ULL, 0x000fc400078ee23bULL,
0x00005e00333a7a11ULL, 0x040fe200078c40ffULL, 0x000000103e557824ULL, 0x000fe200078e0251ULL,
0xfffffffc42427812ULL, 0x100fe200078ee23bULL, 0x000000ffff3e7224ULL, 0x000fe200028e06ffULL,
0xfffffffc46467812ULL, 0x000fe200078ee23bULL, 0x0000001044497824ULL, 0x000fe200078e0251ULL,
0xfffffffc48487812ULL, 0x000fe200078ee23bULL, 0x0000001042477824ULL, 0x000fe200078e0251ULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee23bULL, 0x00000010464b7824ULL, 0x000fe200078e0251ULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee23bULL, 0x00000010484d7824ULL, 0x100fe200078e0251ULL,
0x00005f00333b7a11ULL, 0x000fe200030f443cULL, 0x000000104a4f7824ULL, 0x100fe200078e0251ULL,
0x00005e003d3c7a11ULL, 0x040fe200078a40ffULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0x0000004550437210ULL, 0x080fe20007f5e0ffULL, 0x0000001040337824ULL, 0x100fe200078e0251ULL,
0x0000004554347210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x00005f003d3d7a11ULL, 0x000fe200028f443eULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0xfffffffc53537812ULL, 0x000fe200078ee202ULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078840ffULL, 0x000000104e517824ULL, 0x000fe200078e0251ULL,
0x00005e0041407a11ULL, 0x000fe200078240ffULL, 0x0000001053367825ULL, 0x000fe200078e0036ULL,
0x00005e0043427a11ULL, 0x000fc400078440ffULL, 0x00005e0034447a11ULL, 0x040fe200078640ffULL,
0x0000001053387825ULL, 0x000fe200078e0038ULL, 0x00005f003f3f7a11ULL, 0x000fe200020f444aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036557faeULL, 0x0003e2000b901c46ULL,
0x00005f0041417a11ULL, 0x000fe200008f4448ULL, 0x00000010533a7825ULL, 0x000fe200078e003aULL,
0x00005f0043437a11ULL, 0x000fe200010f4446ULL, 0x0000000038337faeULL, 0x0003e2000b901c46ULL,
0x00005f0034457a11ULL, 0x000fe200018f4445ULL, 0x00000010533c7825ULL, 0x040fe400078e003cULL,
0x000000003a477faeULL, 0x0003e4000b901c46ULL, 0x00000010533e7825ULL, 0x000fc400078e003eULL,
0x000000003c497faeULL, 0x0003e4000b901c46ULL, 0x0000001053407825ULL, 0x040fe400078e0040ULL,
0x000000003e4b7faeULL, 0x0003e4000b901c46ULL, 0x0000001053427825ULL, 0x040fe400078e0042ULL,
0x00000000404d7faeULL, 0x0003e4000b901c46ULL, 0x0000001053447825ULL, 0x000fc400078e0044ULL,
0x00000000424f7faeULL, 0x0003e8000b901c46ULL, 0x0000000044517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000035700780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x00000004ff377424ULL, 0x002fe400078e00ffULL, 0xffffffffff077424ULL, 0x000fe400078e00ffULL,
0x0000030037287a24ULL, 0x000fca00078e0228ULL, 0x000000052800720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x000000022d367824ULL, 0x000fc800078e0228ULL,
0x0000600036367625ULL, 0x000fca00078e0037ULL, 0x0000000636077981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002397810ULL, 0x002fe20007ffe0ffULL, 0x0000000200437824ULL, 0x000fe200078e0235ULL,
0xfffffff802377812ULL, 0x000fe200078ec0ffULL, 0x000000084c337824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ec0ffULL, 0x000000ffff417224ULL, 0x000fe200078e00ffULL,
0x0000000737407812ULL, 0x100fe400078ef802ULL, 0x0000000739447812ULL, 0x000fe400078ef802ULL,
0x0000000702357812ULL, 0x000fc400078ec0ffULL, 0x00000001ff467819ULL, 0x000fe40000011640ULL,
0x00000001ff487819ULL, 0x000fe40000011644ULL, 0x0000200043437811ULL, 0x000fe400078e60ffULL,
0x0000000835427812ULL, 0x000fe400078ef802ULL, 0x0000000346467812ULL, 0x000fe400078ec0ffULL,
0x0000000348487812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000004146357212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000004148397212ULL, 0x000fc400078e3cffULL, 0x00000001414d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000440347824ULL, 0x000fe200078e0235ULL, 0x0000003302517211ULL, 0x000fe200078fe0ffULL,
0x0000000444387824ULL, 0x000fe200078e0239ULL, 0x0000000241417810ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x100fe200078e0243ULL, 0x0000000433337810ULL, 0x000fe20007ffe0ffULL,
0x0000001038387824ULL, 0x000fe200078e0243ULL, 0x000000044100780cULL, 0x000fc60003f25270ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x00000018ff3e7819ULL, 0x002fe20000011436ULL, 0x00010000353f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011435ULL, 0x0000003e005a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fc40000011434ULL, 0x00000018ff4b7819ULL, 0x000fe40000011437ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff4a7819ULL, 0x004fe20000011438ULL,
0x0000003d00567306ULL, 0x0005e20000200c00ULL, 0x00008880353e7816ULL, 0x042fe200000000ffULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011439ULL,
0x00000018ff477819ULL, 0x000fc4000001143aULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000003c00527306ULL, 0x0003e20000200c00ULL, 0x00010000343d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc8000001143bULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003500597306ULL, 0x0005e20000200c00ULL, 0x00008880343c7816ULL, 0x042fe200000000ffULL,
0x0000010034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003d00537306ULL, 0x0003e20000200c00ULL, 0x0001000037357824ULL, 0x004fca00078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003c00507306ULL, 0x0005e20000200c00ULL,
0x00008880373d7816ULL, 0x042fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003400557306ULL, 0x0003e20000200c00ULL,
0x00008880363c7816ULL, 0x004fce00000000ffULL, 0x00000037005e7306ULL, 0x0005e20000200c00ULL,
0x0001000036347824ULL, 0x042fe400078e00ffULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000003c00587306ULL, 0x0003e20000200c00ULL,
0x0000004d46377212ULL, 0x084fe400078e3cffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000004d484d7212ULL, 0x000fc600078e3cffULL, 0x0000003e00547306ULL, 0x000fe20000200c00ULL,
0x00000004403c7824ULL, 0x002fc800078e0237ULL, 0x000000103c3c7824ULL, 0x000fc600078e0243ULL,
0x0000003f00577306ULL, 0x000e700000200c00ULL, 0x00000036005d7306ULL, 0x0005f00000200c00ULL,
0x0000003d005c7306ULL, 0x0007e20000200c00ULL, 0x0001000038367824ULL, 0x004fe200078e00ffULL,
0x0000541054547816ULL, 0x002fc80000000057ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000034005b7306ULL, 0x0002a20000200c00ULL, 0x000000003c3c783bULL, 0x008eee0000000200ULL,
0x00000035005f7306ULL, 0x0008a20000200c00ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000010038387824ULL, 0x000fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003400607306ULL, 0x0003e20000200c00ULL, 0x0000888039357816ULL, 0x010fe400000000ffULL,
0x0000541058587816ULL, 0x004fca000000005bULL, 0x0000003600617306ULL, 0x0005220000200c00ULL,
0x0001000039347824ULL, 0x042fe200078e00ffULL, 0x000054105c5c7816ULL, 0x000fe2000000005fULL,
0x0000010039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003500627306ULL, 0x0003e20000200c00ULL, 0x0000000444367824ULL, 0x004fe200078e024dULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x000100003b4d7824ULL, 0x000fe400078e00ffULL,
0x0000001036367824ULL, 0x000fc600078e0243ULL, 0x0000003400657306ULL, 0x0005220000200c00ULL,
0x000100003a357824ULL, 0x002fe200078e00ffULL, 0x000088803d6b7816ULL, 0x008fe200000000ffULL,
0x000100003e757824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff4c7819ULL, 0x000fe40000011435ULL, 0x0000003800637306ULL, 0x0003e20000200c00ULL,
0x000000003634783bULL, 0x004ea20000000200ULL, 0x0000541060607816ULL, 0x010fc40000000061ULL,
0x00000018ff757819ULL, 0x000fc80000011475ULL, 0x0000003900647306ULL, 0x0007e20000200c00ULL,
0x000088803a387816ULL, 0x042fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541062627816ULL, 0x000fc80000000065ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000003800667306ULL, 0x0003e20000200c00ULL, 0x000088803b397816ULL, 0x048fe200000000ffULL,
0x000001003b3b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000003900697306ULL, 0x0007e20000200c00ULL, 0x00000018ff387819ULL, 0x002fce000001143cULL,
0x0000003a00687306ULL, 0x0003e20000200c00ULL, 0x00000018ff397819ULL, 0x008fce000001143fULL,
0x00000039007b7306ULL, 0x0007e20000200c00ULL, 0x00000018ff3a7819ULL, 0x002fe4000001143dULL,
0x00008880347d7816ULL, 0x004fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe40000011434ULL,
0x00000018ff4e7819ULL, 0x000fe20000011435ULL, 0x0000003a00737306ULL, 0x0003e20000200c00ULL,
0x000100003c397824ULL, 0x008fce00078e00ffULL, 0x00000038006f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3a7819ULL, 0x002fe40000011439ULL, 0x0000000751397812ULL, 0x040fe400078e7842ULL,
0x0000000251517810ULL, 0x000fc60007ffe0ffULL, 0x0000002042397824ULL, 0x000fe200078e0239ULL,
0x000088803c387816ULL, 0x044fe200000000ffULL, 0x0000004c00677306ULL, 0x0002a20000200c00ULL,
0x000001003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000751517812ULL, 0x000fe200078e7842ULL,
0x0000001039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000002042517824ULL, 0x000fe200078e0251ULL, 0x0000003b006c7306ULL, 0x0007e20000200c00ULL,
0x00000018ff4c7819ULL, 0x002fce000001143eULL, 0x00000038006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3b7819ULL, 0x008fe40000011437ULL, 0x0000541066667816ULL, 0x004fca0000000067ULL,
0x0000004c00777306ULL, 0x000fe20000200c00ULL, 0x000100003d387824ULL, 0x042fe400078e00ffULL,
0x000001003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011438ULL,
0x0000003b004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000003a006e7306ULL, 0x0002b00000200c00ULL, 0x0000003d00747306ULL, 0x0007220000200c00ULL,
0x000000003938783bULL, 0x002e6e0000000200ULL, 0x0000003c00707306ULL, 0x0009220000200c00ULL,
0x000100003f3d7824ULL, 0x008fe200078e00ffULL, 0x000054106d6e7816ULL, 0x004fc8000000006eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000088803e3c7816ULL, 0x050fe200000000ffULL, 0x000001003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000541074737816ULL, 0x000fc80000000073ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003c00767306ULL, 0x0007e20000200c00ULL, 0x00005410706f7816ULL, 0x000fce000000006fULL,
0x0000003d007a7306ULL, 0x0009e20000200c00ULL, 0x00005410503c7816ULL, 0x008fe40000000053ULL,
0x0000541063617816ULL, 0x004fca000000004aULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x00005410553d7816ULL, 0x010fe20000000052ULL, 0x000000603818723cULL, 0x002fe20000001818ULL,
0x0000541059557816ULL, 0x000fe40000000056ULL, 0x000054105d597816ULL, 0x000fc6000000005aULL,
0x0000004900497306ULL, 0x000e640000200c00ULL, 0x0000003c3808723cULL, 0x040fec0000001808ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x000000ffff3c7224ULL, 0x000fe200078e007dULL,
0x000054105e5d7816ULL, 0x004fe2000000004bULL, 0x00000054380c723cULL, 0x000fea000000180cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541064637816ULL, 0x002fc40000000049ULL,
0x0000888036497816ULL, 0x000fe200000000ffULL, 0x000000583810723cULL, 0x040fe80000001810ULL,
0x0000004d006a7306ULL, 0x0002a20000200c00ULL, 0x0000541068677816ULL, 0x008fe20000000047ULL,
0x000000ffff477224ULL, 0x000fe400078e0049ULL, 0x0000005c3814723cULL, 0x000fe20000001814ULL,
0x0001000036497824ULL, 0x000fc600078e00ffULL, 0x0000006b00727306ULL, 0x0007e20000200c00ULL,
0x00000018ff4d7819ULL, 0x002fe40000011436ULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x00000062381c723cULL, 0x040fe8000000181cULL, 0x0000003e00787306ULL, 0x0003220000200c00ULL,
0x000088803f6b7816ULL, 0x048fe200000000ffULL, 0x000001003f3f7824ULL, 0x000fe200078e00ffULL,
0x00005410696a7816ULL, 0x004fe2000000006aULL, 0x000000663820723cULL, 0x000fe60000001820ULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0000003c00527306ULL, 0x0005e20000200c00ULL,
0x00010000343e7824ULL, 0x002fc400078e00ffULL, 0x0000010034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff507819ULL, 0x000fe4000001143eULL, 0x0000006b00797306ULL, 0x0002e20000200c00ULL,
0x00000010513c7824ULL, 0x004fe200078e00ffULL, 0x0000888035517816ULL, 0x000fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541078777816ULL, 0x010fe20000000077ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0051ULL, 0x0000003f007c7306ULL, 0x0005220000200c00ULL,
0x000054106c6b7816ULL, 0x002fce0000000045ULL, 0x0000005000537306ULL, 0x0003220000200c00ULL,
0x000000003c3c783bULL, 0x004ea20000000200ULL, 0x0000006a3824723cULL, 0x000fe20000001824ULL,
0x00005410797a7816ULL, 0x008fca000000007aULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0001000035507824ULL, 0x002fe200078e00ffULL, 0x0000888037397816ULL, 0x000fe200000000ffULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x000054107c7b7816ULL, 0x010fe2000000007bULL,
0x0000010036387824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x00010000373a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000010037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fc4000001143aULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x0000541052527816ULL, 0x000fc60000000053ULL,
0x0000004d004d7306ULL, 0x000ff00000200c00ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x0000006e3c08723cULL, 0x044fee0000001808ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000007a3c14723cULL, 0x000fee0000001814ULL, 0x0000003400347306ULL, 0x000ee20000200c00ULL,
0x0000541072727816ULL, 0x002fce0000000071ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000541076767816ULL, 0x004fe20000000075ULL, 0x000000723c0c723cULL, 0x040fec000000180cULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x0000541034537816ULL, 0x008fe2000000004fULL,
0x000000763c10723cULL, 0x040fec0000001810ULL, 0x0000003500357306ULL, 0x000ea40000200c00ULL,
0x000000523c18723cULL, 0x000fec0000001818ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054104b507816ULL, 0x002fce0000000050ULL, 0x0000004900367306ULL, 0x000e620000200c00ULL,
0x0000541035517816ULL, 0x004fce000000004eULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x000000503c1c723cULL, 0x000fee000000181cULL, 0x0000003900397306ULL, 0x000fe20000200c00ULL,
0x0000541047367816ULL, 0x002fce0000000036ULL, 0x0000003a003a7306ULL, 0x000e700000200c00ULL,
0x00000037003b7306ULL, 0x0004e20000200c00ULL, 0x00005410393a7816ULL, 0x002fe4000000003aULL,
0x0000541038377816ULL, 0x004fc4000000004dULL, 0x000054103b3b7816ULL, 0x008fca000000004cULL,
0x000000363c20723cULL, 0x040ff00000001820ULL, 0x0000003a3c24723cULL, 0x000fe20000001824ULL,
0xfffff0d000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff357224ULL, 0x000fe200078e0031ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe13000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002c327f8cULL, 0x000fe2000c80043fULL,
0x000000162a3b7220ULL, 0x000fc40000410000ULL, 0x000000172a3c7220ULL, 0x040fe20000410000ULL,
0x000004002c357984ULL, 0x000e620000000800ULL, 0x000000182a167220ULL, 0x040fe40000410000ULL,
0x000000192a177220ULL, 0x040fe40000410000ULL, 0x0000000a2a347220ULL, 0x040fe40000410000ULL,
0x0000000b2a367220ULL, 0x040fe40000410000ULL, 0x0000000e2a377220ULL, 0x000fc40000410000ULL,
0x0000000f2a387220ULL, 0x040fe40000410000ULL, 0x000000122a397220ULL, 0x040fe40000410000ULL,
0x0000001c2a187220ULL, 0x040fe40000410000ULL, 0x0000001d2a197220ULL, 0x040fe40000410000ULL,
0x000000082a087220ULL, 0x040fe40000410000ULL, 0x000000092a097220ULL, 0x000fc40000410000ULL,
0x0000000c2a0c7220ULL, 0x040fe40000410000ULL, 0x0000000d2a0d7220ULL, 0x040fe40000410000ULL,
0x000000102a0a7220ULL, 0x040fe40000410000ULL, 0x000000112a0b7220ULL, 0x040fe40000410000ULL,
0x000000132a3a7220ULL, 0x040fe40000410000ULL, 0x0000001a2a3d7220ULL, 0x000fc40000410000ULL,
0x0000001b2a3e7220ULL, 0x040fe40000410000ULL, 0x0000001e2a1c7220ULL, 0x040fe40000410000ULL,
0x0000001f2a1d7220ULL, 0x040fe20000410000ULL, 0x8000000035ff7812ULL, 0x002fe20007804833ULL,
0x000000222a3f7220ULL, 0x040fe40000410000ULL, 0x000000232a407220ULL, 0x040fe40000410000ULL,
0x000000202a1a7220ULL, 0x000fc40000410000ULL, 0x000000212a1b7220ULL, 0x040fe40000410000ULL,
0x000000242a1e7220ULL, 0x040fe40000410000ULL, 0x000000252a1f7220ULL, 0x040fe40000410000ULL,
0x000000262a417220ULL, 0x040fe40000410000ULL, 0x000000272a427220ULL, 0x000fe40000410000ULL,
0x000000ffff207224ULL, 0x000fc400078e0034ULL, 0x000000ffff217224ULL, 0x000fe400078e0036ULL,
0x000000ffff227224ULL, 0x000fe400078e0037ULL, 0x000000ffff237224ULL, 0x000fe400078e0038ULL,
0x000000ffff247224ULL, 0x000fe400078e0039ULL, 0x000000142a147220ULL, 0x040fe40000410000ULL,
0x000000152a157220ULL, 0x000fc40000410000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff107224ULL, 0x000fe400078e000cULL,
0x000000ffff117224ULL, 0x000fe400078e000dULL, 0x000000ffff127224ULL, 0x000fe400078e000aULL,
0x000000ffff137224ULL, 0x000fc400078e000bULL, 0x000000ffff257224ULL, 0x000fe400078e003aULL,
0x000000ffff267224ULL, 0x000fe400078e003bULL, 0x000000ffff277224ULL, 0x000fe400078e003cULL,
0x000000ffff347224ULL, 0x000fe400078e003dULL, 0x000000ffff357224ULL, 0x000fe400078e003eULL,
0x000000ffff367224ULL, 0x000fc400078e001cULL, 0x000000ffff377224ULL, 0x000fe400078e001dULL,
0x000000ffff387224ULL, 0x000fe400078e003fULL, 0x000000ffff397224ULL, 0x000fe200078e0040ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0041ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0042ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x000004002c097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004021d7824ULL, 0x000fe200078e00ffULL, 0x0000002f0400720cULL, 0x000fc80003f05270ULL,
0xfffffff01d097812ULL, 0x000fca00078ec0ffULL, 0x00000080001c7824ULL, 0x000fca00078e0209ULL,
0x010400001c087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002020c7824ULL, 0x000fe400078e00ffULL, 0x0000000103307824ULL, 0x000fc600078e0a30ULL,
0x000000060c0d7812ULL, 0x000fc800078ec0ffULL, 0x000000010d337812ULL, 0x040fe400078efcffULL,
0x000000080d3d7812ULL, 0x000fe400078efcffULL, 0x000000303300720cULL, 0x080fe40003f26070ULL,
0x000000100d337812ULL, 0x000fe400078efcffULL, 0x000000303d00720cULL, 0x080fe40003f06070ULL,
0x000000303300720cULL, 0x000fc40003fc6070ULL, 0x000000110d3d7812ULL, 0x040fe400078efcffULL,
0x000000180d337812ULL, 0x040fe400078efcffULL, 0x000000300d00720cULL, 0x080fe40003f46070ULL,
0x000000303d00720cULL, 0x080fe40003fa6070ULL, 0x000000303300720cULL, 0x000fe40003f66070ULL,
0x000000090d3f7812ULL, 0x000fc400078efcffULL, 0x000000190d3d7812ULL, 0x040fe400078efcffULL,
0x000000200d337812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40005000000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff0e0e7808ULL, 0x000fc40004800000ULL, 0x000000303f00720cULL, 0x080fe40003f86070ULL,
0x000000303d00720cULL, 0x080fe40003f46070ULL, 0x000000303300720cULL, 0x000fe40003f26070ULL,
0x000000210d3d7812ULL, 0x040fe400078efcffULL, 0x000000280d337812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fc40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff23237808ULL, 0x000fe40006000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0x000000303d00720cULL, 0x080fe40003f06070ULL, 0x000000303300720cULL, 0x000fe40003f86070ULL,
0x000000290d3d7812ULL, 0x000fc400078efcffULL, 0x000000300d337812ULL, 0x000fe400078efcffULL,
0xff7fffff24247808ULL, 0x000fe40007000000ULL, 0xff7fffff12127808ULL, 0x000fe40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40006800000ULL, 0xff7fffff13137808ULL, 0x000fe40006800000ULL,
0x000000303d00720cULL, 0x000fc40003fc6070ULL, 0x000000303300720cULL, 0x000fe40003fa6070ULL,
0x000000310d3d7812ULL, 0x040fe400078efcffULL, 0x000000380d337812ULL, 0x040fe400078efcffULL,
0x000000390d0d7812ULL, 0x000fe400078efcffULL, 0xff7fffff26267808ULL, 0x000fe40005800000ULL,
0xff7fffff14147808ULL, 0x000fc40005800000ULL, 0xff7fffff27277808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40005000000ULL, 0xff7fffff34347808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x000000303d00720cULL, 0x080fe40003f66070ULL,
0x000000303300720cULL, 0x000fc40003f46070ULL, 0x000000300d00720cULL, 0x000fe40003f26070ULL,
0xff7fffff35357808ULL, 0x000fe40004000000ULL, 0xff7fffff17177808ULL, 0x000fe40004000000ULL,
0xff7fffff36367808ULL, 0x000fe40006000000ULL, 0xff7fffff18187808ULL, 0x000fe40006000000ULL,
0xff7fffff37377808ULL, 0x000fc40007000000ULL, 0xff7fffff19197808ULL, 0x000fe40007000000ULL,
0xff7fffff38387808ULL, 0x000fe40006800000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40006800000ULL,
0xff7fffff39397808ULL, 0x000fe40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL,
0xff7fffff3a3a7808ULL, 0x000fc40005000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL,
0x0000000f080d7209ULL, 0x004fe40007810000ULL, 0x0000002009087209ULL, 0x000fe40007810000ULL,
0x0000000e0d0d7209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fc40007810000ULL,
0x000000100d087209ULL, 0x000fe40007810000ULL, 0x00000022090c7209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x000000240d0c7209ULL, 0x000fc40007810000ULL,
0x0000001308097209ULL, 0x000fe40007810000ULL, 0x000000250c0d7209ULL, 0x000fe40007810000ULL,
0x0000001409087209ULL, 0x000fe40007810000ULL, 0x000000260d0c7209ULL, 0x000fe40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x000000270c0d7209ULL, 0x000fc40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x000000340d0c7209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x000000350c0d7209ULL, 0x000fe40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x000000360d0c7209ULL, 0x000fc40007810000ULL,
0x0000001908097209ULL, 0x000fe40007810000ULL, 0x000000370c0d7209ULL, 0x000fe40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x000000380d0c7209ULL, 0x000fe40007810000ULL,
0x0000001b08097209ULL, 0x000fe40007810000ULL, 0x000000390c0d7209ULL, 0x000fc40007810000ULL,
0x0000001e09087209ULL, 0x000fe40007810000ULL, 0x0000003a0d0c7209ULL, 0x000fe40007810000ULL,
0x0000001f08327209ULL, 0x000fe40007810000ULL, 0x0000003b0c3c7209ULL, 0x000fe20007810000ULL,
0x00001af27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0032087f89ULL, 0x0004e400000e0000ULL,
0x00000008323d7209ULL, 0x008fe20007810000ULL, 0x00001b327f007947ULL, 0x000fea000b800000ULL,
0x0c401f003c087f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b307f89ULL, 0x000e6200000e0000ULL, 0x000000083c0c7209ULL, 0x008fc60007810000ULL,
0x0c201f003d087f89ULL, 0x000ee200000e0000ULL, 0x000000090a0d7209ULL, 0x010fc60007810000ULL,
0x0c201f000c097f89ULL, 0x000f2200000e0000ULL, 0x000000300b307209ULL, 0x002fc60007810000ULL,
0x0c201f000d327f89ULL, 0x004e6800000e0000ULL, 0x0c201f0030337f89ULL, 0x0004a200000e0000ULL,
0x000000083d087209ULL, 0x008fe40007810000ULL, 0x000000090c097209ULL, 0x010fe40007810000ULL,
0x000000320d0a7209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b080b7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff3c7424ULL, 0x000fe200078e00ffULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x0000000f000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b11117823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b12127823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x0000000e000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b15157823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b16167823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080bULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b19197823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1b1b7823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL, 0x0000001100117308ULL, 0x000f220000000800ULL,
0x3fb8aa3b1f0b7823ULL, 0x000fe2000001080bULL, 0x0000000c0d0c723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b091f7820ULL, 0x000fe40000410000ULL, 0x3c003c00ff3d7424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001081fULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001081fULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x00000010110e723eULL, 0x010fe200000000ffULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b27277823ULL, 0x000fc4000001081fULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b35357823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b36367823ULL, 0x100fe4000001081fULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081fULL,
0x00000022000f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b38387823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b39397823ULL, 0x000fc4000001081fULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe4000001081fULL,
0x3fb8aa3b3b1f7823ULL, 0x000fe2000001081fULL, 0x0000002300327308ULL, 0x002e620000000800ULL,
0x00000020210d723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000ee20000000800ULL,
0x0000000f320f723eULL, 0x002fce00000000ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x0000003c0c20723cULL, 0x000fe200000018ffULL, 0x000000121310723eULL, 0x008fcc00000000ffULL,
0x0000001500157308ULL, 0x000e700000000800ULL, 0x0000002400247308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ee20000000800ULL, 0x000000141512723eULL, 0x002fce00000000ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000242511723eULL, 0x008fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x000000262713723eULL, 0x002fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x0000003c1020723cULL, 0x000fee0000001820ULL, 0x0000001800187308ULL, 0x000ff00000000800ULL,
0x0000001900197308ULL, 0x000ee20000000800ULL, 0x000000161714723eULL, 0x002fce00000000ffULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x000000181916723eULL, 0x008fe200000000ffULL, 0x0000000fff197424ULL, 0x000fe200078e00ffULL,
0xfffffffc02187812ULL, 0x000fc800078ec0ffULL, 0x0000001819607219ULL, 0x000fe200000006ffULL,
0x0000003600367308ULL, 0x000fe60000000800ULL, 0x00000000602573a1ULL, 0x000ee200000e8000ULL,
0x00000000600573c4ULL, 0x000f280000004000ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x000000343515723eULL, 0x002fce00000000ffULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x000000363717723eULL, 0x004fce00000000ffULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000860ff7c12ULL, 0x008fe2000f804025ULL, 0x0000003c1420723cULL, 0x000fec0000001820ULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000000b000b7308ULL, 0x000ea20000000800ULL,
0x0000001a1b18723eULL, 0x002fce00000000ffULL, 0x0000003800387308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x0000001e0b1a723eULL, 0x004fe400000000ffULL,
0x00000030330b7209ULL, 0x000fca0007810000ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x000000383919723eULL, 0x002fe400000000ffULL,
0x0000003a1f1b723eULL, 0x004fce00000000ffULL, 0x0000003c183c723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000174205008947ULL, 0x010fde000b800000ULL,
0x001c1fff3c207589ULL, 0x0002a400000e0000ULL, 0x00000000601f73a1ULL, 0x000ee200000e8000ULL,
0x00000000600573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000860ff7c12ULL, 0x008fda000f80401fULL, 0x0000175205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3e217589ULL, 0x00072800000e0000ULL, 0x001c1fff01227589ULL, 0x00066800000e0000ULL,
0x001c1fff23237589ULL, 0x0006a400000e0000ULL, 0x00000002ff1e7819ULL, 0x000fe40000011602ULL,
0x0000000c1d417812ULL, 0x000fc400078ec0ffULL, 0x000000071e1f7812ULL, 0x040fe200078ec0ffULL,
0x000000081e307824ULL, 0x040fe200078e00ffULL, 0x0000001eff267212ULL, 0x000fe200078e33ffULL,
0x000000081e247824ULL, 0x000fe200078e00ffULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081e3d7824ULL, 0x040fe200078e00ffULL, 0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff830257812ULL, 0x100fe400078ee21fULL, 0x0000000124277812ULL, 0x100fe200078ef61fULL,
0x000000081e4f7824ULL, 0x000fe200078e00ffULL, 0x0000000224337812ULL, 0x100fe200078ef61fULL,
0x000000081e307824ULL, 0x000fe200078e00ffULL, 0x0000000324357812ULL, 0x000fc400078ef61fULL,
0x0000000424377812ULL, 0x140fe400078ef61fULL, 0x0000000524397812ULL, 0x140fe400078ef61fULL,
0x00000006243b7812ULL, 0x002fe200078ef61fULL, 0x000000081e247824ULL, 0x040fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe400078ee226ULL, 0x0000001eff267212ULL, 0x000fe400078e33ffULL,
0x000000071e1f7812ULL, 0x000fc400078ec0ffULL, 0x0000a000001e7811ULL, 0x000fe400078e58ffULL,
0xfffffff8303f7812ULL, 0x100fe400078ee21fULL, 0x0000000124437812ULL, 0x140fe200078ef61fULL,
0x00000010251d7824ULL, 0x100fe200078e021eULL, 0x0000000224457812ULL, 0x140fe200078ef61fULL,
0x0000001037307824ULL, 0x100fe200078e021eULL, 0x0000000324477812ULL, 0x040fe200078ef61fULL,
0x00000001411d7824ULL, 0x000fe200078e021dULL, 0x0000000424497812ULL, 0x140fe200078ef61fULL,
0x0000001039327824ULL, 0x100fe200078e021eULL, 0x00000005244b7812ULL, 0x140fe200078ef61fULL,
0x000000103b347824ULL, 0x100fe200078e021eULL, 0x00000006244d7812ULL, 0x000fe200078ef61fULL,
0x00000010271f7824ULL, 0x000fe200078e021eULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee226ULL,
0x0000001033247824ULL, 0x100fe200078e021eULL, 0x0000000c1d007388ULL, 0x0003e20000000800ULL,
0x0000001035267824ULL, 0x000fc400078e021eULL, 0x00000001411f7824ULL, 0x040fe400078e021fULL,
0x0000000141257824ULL, 0x000fe400078e0224ULL, 0x000000103d367824ULL, 0x000fe200078e021eULL,
0x0000000e1f007388ULL, 0x0007e20000000800ULL, 0x0000000141277824ULL, 0x000fe400078e0226ULL,
0x000000103f387824ULL, 0x000fe200078e021eULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x0000000141337824ULL, 0x000fc400078e0230ULL, 0x00000010433a7824ULL, 0x000fe200078e021eULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000141357824ULL, 0x000fe400078e0232ULL,
0x00000010453b7824ULL, 0x000fe200078e021eULL, 0x0000001433007388ULL, 0x0007e20000000800ULL,
0x0000000141377824ULL, 0x000fe400078e0234ULL, 0x00000010473c7824ULL, 0x000fe200078e021eULL,
0x0000001635007388ULL, 0x0007e20000000800ULL, 0x0000000141397824ULL, 0x000fc400078e0236ULL,
0x00000010493d7824ULL, 0x000fe200078e021eULL, 0x0000001837007388ULL, 0x0007e20000000800ULL,
0x0000000141387824ULL, 0x000fe400078e0238ULL, 0x000000104b3e7824ULL, 0x108fe200078e021eULL,
0x0000001a39007388ULL, 0x0007e20000000800ULL, 0x000000104d3f7824ULL, 0x100fe400078e021eULL,
0x000000104f407824ULL, 0x000fe200078e021eULL, 0x0000000d38007388ULL, 0x0007e20000000800ULL,
0x00000001413a7824ULL, 0x000fc400078e023aULL, 0x00000001411e7824ULL, 0x040fe400078e023bULL,
0x00000001413c7824ULL, 0x040fe200078e023cULL, 0x0000000f3a007388ULL, 0x0007e20000000800ULL,
0x00000001410c7824ULL, 0x042fe400078e023dULL, 0x00000001413e7824ULL, 0x040fe200078e023eULL,
0x000000111e007388ULL, 0x0007e20000000800ULL, 0x0000000141247824ULL, 0x040fe400078e023fULL,
0x0000000141407824ULL, 0x000fe200078e0240ULL, 0x000000133c007388ULL, 0x0007e80000000800ULL,
0x000000150c007388ULL, 0x0007e80000000800ULL, 0x000000173e007388ULL, 0x0007e80000000800ULL,
0x0000001924007388ULL, 0x0007e80000000800ULL, 0x0000001b40007388ULL, 0x0007e80000000800ULL,
0x010000081c008388ULL, 0x0007e80000000c00ULL, 0x010200201c008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002eff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002eff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030004047a10ULL, 0x000fe20007ffe0ffULL,
0x000018002eff7f8cULL, 0x0003e6000c80043fULL, 0x000000060400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc60000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff347807ULL, 0x008fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001601000397802ULL, 0x000fe40000000f00ULL,
0x0000130000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0038ULL,
0xfffeb7d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001607000397802ULL, 0x000fe40000000f00ULL,
0x000012a000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e0038ULL,
0xfffeb7f000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x000fe200078e00ffULL,
0x000160d000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000120000007944ULL, 0x03efea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e003aULL,
0xfffeb83000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x000fe200078e00ffULL,
0x0001613000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x038fea0003c00000ULL, 0xfffeb81000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x000fe200078e0064ULL, 0x0001619000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000114000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e003aULL,
0xfffebb8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff627224ULL, 0x002fe200078e002fULL,
0x0001620000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x000010d000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff5e7224ULL, 0x004fe200078e003aULL, 0xfffebb4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff617424ULL, 0x000fe200078e00ffULL, 0x0001626000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000107000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e003aULL, 0xfffed2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x000162d000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000100000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e003aULL,
0xfffed25000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001633000397802ULL, 0x000fe40000000f00ULL,
0x00000fe000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e0038ULL,
0xfffee95000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001639000397802ULL, 0x000fe40000000f00ULL,
0x00000f8000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff347224ULL, 0x000fe200078e0038ULL,
0xfffee97000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x002fe200078e00ffULL,
0x000163f000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00000ee000007944ULL, 0x034fea0003c00000ULL, 0xfffee9d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x0001645000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00000e8000007944ULL, 0x030fea0003c00000ULL, 0xfffeea9000007947ULL, 0x000fea000383ffffULL,
0x0000001fff617424ULL, 0x000fe200078e00ffULL, 0x000164a000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00000e3000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x004fe200078e003aULL, 0xfffeecf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x0001651000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00000dc000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e003aULL,
0xfffeeca000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x000fe200078e00ffULL,
0x0001657000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e003aULL,
0xffff01c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff627224ULL, 0x002fe200078e002fULL,
0x000165e000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00000cf000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff6a7224ULL, 0x004fe200078e003aULL, 0xffff017000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x008fe20004800000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0001664000397802ULL, 0x000fe40000000f00ULL, 0x00000cd000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0xffff17e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x000fe20004800000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x000166a000397802ULL, 0x000fe40000000f00ULL, 0x00000c7000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0xffff180000007947ULL, 0x000fea000383ffffULL,
0x0000001fff617424ULL, 0x002fe200078e00ffULL, 0x0001670000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00000bd000007944ULL, 0x034fea0003c00000ULL,
0xffff186000007947ULL, 0x000fea000383ffffULL, 0x000000ffff627224ULL, 0x002fe200078e002fULL,
0x0001676000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00000b7000007944ULL, 0x030fea0003c00000ULL,
0xffff192000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x000fe200078e00ffULL,
0x000167b000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x00000b2000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff6d7224ULL, 0x004fe200078e003aULL,
0xffff1b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff627224ULL, 0x002fe200078e002fULL,
0x0001682000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fe400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x00000ab000007944ULL, 0x02cfea0003c00000ULL,
0x000000ffff6c7224ULL, 0x004fe200078e003aULL, 0xffff1b3000007947ULL, 0x000fea000383ffffULL,
0x0000001fff617424ULL, 0x000fe200078e00ffULL, 0x0001688000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff607424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e003aULL, 0xffff304000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x000168f000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x000009e000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e003aULL,
0xffff2ff000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x008fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001695000397802ULL, 0x000fe40000000f00ULL,
0x000009c000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0038ULL,
0xffff466000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20004800000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x000169b000397802ULL, 0x000fe40000000f00ULL,
0x0000096000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e0038ULL,
0xffff468000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x004fe200078e00ffULL,
0x00016a1000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x000008c000007944ULL, 0x032fea0003c00000ULL, 0xffff46e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x00016a7000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x0000086000007944ULL, 0x030fea0003c00000ULL, 0xffff47a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff617424ULL, 0x000fe200078e00ffULL, 0x00016ac000387802ULL, 0x000fe20000000f00ULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x0000081000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e003aULL, 0xffff4a0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff627224ULL, 0x002fe200078e002fULL, 0x00016b3000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff617424ULL, 0x000fe400078e00ffULL, 0xffffffffff607424ULL, 0x000fe400078e00ffULL,
0x000007a000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff5e7224ULL, 0x004fe200078e003aULL,
0xffff49b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff617424ULL, 0x000fe200078e00ffULL,
0x00016b9000387802ULL, 0x000fe20000000f00ULL, 0xffffffffff607424ULL, 0x000fc400078e00ffULL,
0x0000074000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e003aULL,
0xffff5ee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff627224ULL, 0x002fe200078e002fULL,
0x00016c0000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff617424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fe400078e00ffULL, 0x000006d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e003aULL, 0xffff5e9000007947ULL, 0x000fea000383ffffULL,
0x00000002ff337424ULL, 0x000fe200078e00ffULL, 0x00016c70000c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0033ULL,
0xffffe4b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff327224ULL, 0x006fe200078e003cULL,
0x00016cf0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000005a000007944ULL, 0x020fea0003c00000ULL, 0x000000333c3c7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e000aULL, 0x00016d60000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000053000007944ULL, 0x000fea0003c00000ULL,
0x000000330a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e000bULL,
0x00016dd0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000004c000007944ULL, 0x000fea0003c00000ULL, 0x000000330b307209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e003dULL, 0x00016e40000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x000000333d087209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e003cULL,
0x00016eb0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x000000333c097209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e000aULL, 0x00016f20000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff337424ULL, 0x000fe400078e00ffULL, 0x0000001fff3e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3f7424ULL, 0x000fe400078e00ffULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000330a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0030ULL,
0x00016f90000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fc400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3f7424ULL, 0x000fe400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0xffffe29000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3b7224ULL, 0x000fe200078e003cULL, 0x00016ff000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff627224ULL, 0x000fe400078e00ffULL, 0x00001c1fff617424ULL, 0x000fe400078e00ffULL,
0x000002e000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e003aULL,
0xffffe86000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3b7224ULL, 0x002fe200078e003eULL,
0x0001706000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff627224ULL, 0x000fe400078e00ffULL,
0x00001c1fff617424ULL, 0x000fc400078e00ffULL, 0x0000027000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff627224ULL, 0x002fe200078e00ffULL, 0x000170b000387802ULL, 0x000fe20000000f00ULL,
0x00001c1fff617424ULL, 0x000fc400078e00ffULL, 0x000000ffff217224ULL, 0x004fe400078e003aULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff627224ULL, 0x002fe200078e00ffULL,
0x0001710000387802ULL, 0x000fe20000000f00ULL, 0x00001c1fff617424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x004fe400078e003aULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff237224ULL, 0x004fe200078e003aULL, 0xffffe7d000007947ULL, 0x000fea000383ffffULL,
0x0180000005037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003067812ULL, 0x000fc800078ec0ffULL, 0x018000000600780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0600720cULL, 0x040fe40003f25070ULL, 0x008000000600780cULL, 0x000fe40003f02070ULL,
0x00000001ff067807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000306ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff1b7424ULL, 0x000fc800078e00ffULL,
0xfffe8d701a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003f00007348ULL, 0x000fe80003800000ULL, 0x0c00003332337389ULL, 0x0002a200000e003eULL,
0xfffe8d300c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff397424ULL, 0x000fe200078e00ffULL,
0x0000006000007348ULL, 0x000fe80003800000ULL, 0x000000623b3a7389ULL, 0x0002a200000e0061ULL,
0xfffe8cf038007950ULL, 0x000fea0003c3ffffULL, 0x000000013400780cULL, 0x000fe20003f25070ULL,
0x0000003500007348ULL, 0x000fd80003800000ULL, 0x0000000000347806ULL, 0x000fc800048e0100ULL,
0x0000003534387212ULL, 0x000fe200078ec0ffULL, 0x000000ffff347224ULL, 0x000fe400078e0039ULL,
0x00000000ff357424ULL, 0x000fc800078e00ffULL, 0xfffe8c8034007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000380ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000960ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001580ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015b0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015d0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001668ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000017480ULL, 0x9c00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018d10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018d10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019190ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001660ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000176a0ULL, 0x00000000000176a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018d00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019190ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_8_m_8_sm_80_cubin_len = 103024;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
