/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016e90ULL, 0x0000000000016a10ULL, 0x0038004000590559ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000015390ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000015500ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000015540ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000015680ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001539000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0054400400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080b30828808081ULL, 0xac08288080ba0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080ac920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001539000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0xb308288080890828ULL,
0x288080aa08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080aaULL,
0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001550000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0xaa08288080890828ULL,
0x288080b308288080ULL, 0x8280162880808e08ULL, 0x0000000003102880ULL, 0x80808e9200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x0001554000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000a2ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x0000000d00080a04ULL, 0x0058190300580160ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0018310400ff1b03ULL, 0x000148c000014340ULL, 0x00014940000148d0ULL, 0x0001496000014950ULL,
0xffffffff01082904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000021ffffffffULL, 0x0500002105000021ULL, 0xffffffff05000021ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01082804ffffffffULL, 0x000000f0000000c0ULL, 0x000017d000001740ULL,
0x0000188000001850ULL, 0x0000236000002320ULL, 0x00003800000037c0ULL, 0x00004860000047e0ULL,
0x00004900000048d0ULL, 0x0000524000005210ULL, 0x0000666000006620ULL, 0x0000768000007600ULL,
0x00007720000076f0ULL, 0x0000803000008020ULL, 0x0000946000009420ULL, 0x0000a4600000a3e0ULL,
0x0000a5000000a4d0ULL, 0x0000ae300000ae00ULL, 0x0000c1b00000c170ULL, 0x0000cdd00000cdc0ULL,
0x0000f3b00000d550ULL, 0x0000f9a00000f4d0ULL, 0x000102100000f9e0ULL, 0x0001424000014210ULL,
0x0001426000014250ULL, 0x000142a000014280ULL, 0x000142d0000142c0ULL, 0x0001499000014930ULL,
0x000149b0000149a0ULL, 0x0001502000014fc0ULL, 0x000150c000015070ULL, 0x0001516000015110ULL,
0x00015200000151b0ULL, 0x000152d000015260ULL, 0x0001537000015320ULL, 0x0000017005e03904ULL,
0x00010600000000ffULL, 0x000001a0003f0100ULL, 0x000106080000000bULL, 0x000001d0003f0130ULL,
0x000106100000000bULL, 0x00000230003f0130ULL, 0x000106480000000bULL, 0x00000240003f0120ULL,
0x00010658000000ffULL, 0x000005a0003f0100ULL, 0x00010600000000ffULL, 0x00000770003f0107ULL,
0x000000040000000bULL, 0x00000880003f0102ULL, 0x000000000000000bULL, 0x00000ce0003f0101ULL,
0x00010648000000ffULL, 0x00000d60003f0107ULL, 0x00010658000000ffULL, 0x00000ed0003f0101ULL,
0x0001065c000000ffULL, 0x00000f30003f0106ULL, 0x0001065c000000ffULL, 0x00000fb0003f0106ULL,
0x0001065c000000ffULL, 0x000014f0003f0106ULL, 0x00010650000000ffULL, 0x00001560003f0107ULL,
0x0001064c000000ffULL, 0x00001580003f0106ULL, 0x0001060c000000ffULL, 0x00001680003f0106ULL,
0x0001060c000000ffULL, 0x00001ae0003f0106ULL, 0x0001064c000000ffULL, 0x00001b80003f0106ULL,
0x0001064c000000ffULL, 0x00002c20003f0106ULL, 0x00010658000000ffULL, 0x00002c30003f0101ULL,
0x0001065c000000ffULL, 0x00002c70003f0106ULL, 0x0001065c000000ffULL, 0x00002cf0003f0106ULL,
0x0001065c000000ffULL, 0x00002fb0003f0106ULL, 0x00010648000000ffULL, 0x00003020003f0107ULL,
0x00010654000000ffULL, 0x00003090003f0106ULL, 0x00010654000000ffULL, 0x00003130003f0106ULL,
0x00010654000000ffULL, 0x000040d0003f0106ULL, 0x00010658000000ffULL, 0x00004140003f0101ULL,
0x00010610000000ffULL, 0x00004190003f0101ULL, 0x0001065c000000ffULL, 0x000041d0003f0106ULL,
0x0001065c000000ffULL, 0x00004250003f0106ULL, 0x0001065c000000ffULL, 0x000045f0003f0106ULL,
0x00010650000000ffULL, 0x00004660003f0107ULL, 0x0001064c000000ffULL, 0x00004680003f0106ULL,
0x0001061c000000ffULL, 0x00004760003f0106ULL, 0x0001061c000000ffULL, 0x00004b70003f0106ULL,
0x0001064c000000ffULL, 0x00004c10003f0106ULL, 0x0001064c000000ffULL, 0x00005b60003f0106ULL,
0x00010658000000ffULL, 0x00005b70003f0101ULL, 0x0001065c000000ffULL, 0x00005bb0003f0106ULL,
0x0001065c000000ffULL, 0x00005c30003f0106ULL, 0x0001065c000000ffULL, 0x00005eb0003f0106ULL,
0x00010648000000ffULL, 0x00005f20003f0107ULL, 0x00010654000000ffULL, 0x00005f70003f0106ULL,
0x00010654000000ffULL, 0x00006000003f0106ULL, 0x00010654000000ffULL, 0x00006f30003f0106ULL,
0x00010658000000ffULL, 0x00006fa0003f0101ULL, 0x00010620000000ffULL, 0x00006ff0003f0101ULL,
0x0001065c000000ffULL, 0x00007030003f0106ULL, 0x0001065c000000ffULL, 0x000070b0003f0106ULL,
0x0001065c000000ffULL, 0x00007410003f0106ULL, 0x00010650000000ffULL, 0x00007480003f0107ULL,
0x0001064c000000ffULL, 0x000074a0003f0106ULL, 0x0001062c000000ffULL, 0x00007580003f0106ULL,
0x0001062c000000ffULL, 0x00007990003f0106ULL, 0x0001064c000000ffULL, 0x00007a30003f0106ULL,
0x0001064c000000ffULL, 0x00008960003f0106ULL, 0x00010658000000ffULL, 0x00008970003f0101ULL,
0x0001065c000000ffULL, 0x000089b0003f0106ULL, 0x0001065c000000ffULL, 0x00008a30003f0106ULL,
0x0001065c000000ffULL, 0x00008cb0003f0106ULL, 0x00010648000000ffULL, 0x00008d20003f0107ULL,
0x00010654000000ffULL, 0x00008d70003f0106ULL, 0x00010654000000ffULL, 0x00008e00003f0106ULL,
0x00010654000000ffULL, 0x00009d30003f0106ULL, 0x00010658000000ffULL, 0x00009da0003f0101ULL,
0x00010630000000ffULL, 0x00009df0003f0101ULL, 0x0001065c000000ffULL, 0x00009e30003f0106ULL,
0x0001065c000000ffULL, 0x00009eb0003f0106ULL, 0x0001065c000000ffULL, 0x0000a210003f0106ULL,
0x00010650000000ffULL, 0x0000a280003f0107ULL, 0x0001064c000000ffULL, 0x0000a2a0003f0106ULL,
0x0001063c000000ffULL, 0x0000a360003f0106ULL, 0x0001063c000000ffULL, 0x0000a770003f0106ULL,
0x0001064c000000ffULL, 0x0000a810003f0106ULL, 0x0001064c000000ffULL, 0x0000b730003f0106ULL,
0x00010658000000ffULL, 0x0000b740003f0101ULL, 0x0001065c000000ffULL, 0x0000b780003f0106ULL,
0x0001065c000000ffULL, 0x0000b800003f0106ULL, 0x0001065c000000ffULL, 0x0000bab0003f0106ULL,
0x00010648000000ffULL, 0x0000bb20003f0107ULL, 0x00010654000000ffULL, 0x0000bb70003f0106ULL,
0x00010654000000ffULL, 0x0000bc00003f0106ULL, 0x00010654000000ffULL, 0x0000caf0003f0106ULL,
0x00010658000000ffULL, 0x0000cb50003f0101ULL, 0x00010640000000ffULL, 0x00011390003f0101ULL,
0x00010604000000ffULL, 0x00011420003f0106ULL, 0x00010604000000ffULL, 0x00011750003f0106ULL,
0x00010600000000ffULL, 0x00011760003f0101ULL, 0x00010604000000ffULL, 0x000117e0003f0106ULL,
0x00010604000000ffULL, 0x00013730003f0106ULL, 0x0001061400000035ULL, 0x00013af0003f0106ULL,
0x0001061400000035ULL, 0x00014f30003f0106ULL, 0x0001060800000035ULL, 0x00053803003f0101ULL,
0x0001067000101c04ULL, 0x0001190000011830ULL, 0x0000040100014f90ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001e4ULL, 0x0000001100000002ULL, 0x000000000000015cULL, 0x0000001100000002ULL,
0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001bcULL, 0x0000001100000002ULL, 0x0000000000000137ULL, 0x0000001100000002ULL,
0x00000000000000b2ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff197424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff167624ULL, 0x000fc600078e00ffULL, 0x0000000000497919ULL, 0x000ee80000002100ULL,
0x00000000000a7919ULL, 0x000f220000002700ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000b7824ULL, 0x108fe200078e0249ULL, 0x00000005ff497819ULL, 0x000fe20000011649ULL,
0x00001fff08007589ULL, 0x00086600000e0000ULL, 0x000000ff0b00720cULL, 0x040fe40003f65270ULL,
0x000000030b00780cULL, 0x040fe20003f04070ULL, 0x00001fff49497589ULL, 0x000ee200000e0000ULL,
0x0000007f0b00780cULL, 0x040fe20003f24070ULL, 0x000062000a087625ULL, 0x010fe200078e0019ULL,
0x000000010b00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01060002ff00b388ULL, 0x0009e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x010608040b008388ULL, 0x0009e2000000ca00ULL, 0xff317217ff109424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0ca424ULL, 0x000fe200078e00ffULL, 0x010610060b008388ULL, 0x0009e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0da424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0eb424ULL, 0x000fe200078e00ffULL, 0x010400100b009388ULL, 0x0009e20000004800ULL,
0x7fffff80ff0fb424ULL, 0x000fc600078e00ffULL, 0x0106480c0b00a388ULL, 0x0009e80000008a00ULL,
0x0106580eff00b388ULL, 0x0009e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x004fea0003800000ULL, 0x0000000000137919ULL, 0x018e620000000000ULL,
0x0000000449027824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001016037824ULL, 0x000fc400078e00ffULL, 0x00000200ff177424ULL, 0x000fc600078e00ffULL,
0x0000000503047e24ULL, 0x000fe2000f8e020aULL, 0x0000000213057211ULL, 0x042fe200078fd8ffULL,
0x0000001013027824ULL, 0x000fc600078e00ffULL, 0x0000000705037812ULL, 0x040fe400078ec0ffULL,
0x000001f002157812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0205ULL,
0x00000002050f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x000fe200078e7813ULL,
0x00005c0002027625ULL, 0x000fe200078e0017ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe20007ffe0ffULL, 0x00000020050b7824ULL, 0x000fe200078e0206ULL,
0x000000070f0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0207ULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000104107824ULL, 0x000fe200078e020fULL,
0x00000007110d7812ULL, 0x000fe200078ec0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x0000001f0c127812ULL, 0x000fc400078e7813ULL, 0x00000015020c7210ULL, 0x000fe40007f1e0ffULL,
0x0000001f06067812ULL, 0x100fe200078e7813ULL, 0x000000200f127824ULL, 0x000fe200078e0212ULL,
0x0000001f0d147812ULL, 0x000fe200078e7813ULL, 0x0000000104137824ULL, 0x000fe400078e0211ULL,
0x000000ffff0d7224ULL, 0x000fe400000e0603ULL, 0x00005c0005027625ULL, 0x000fc600078e0017ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c46ULL,
0x00000020070e7824ULL, 0x000fe200078e0206ULL, 0x0000001502027210ULL, 0x000fe20007f1e0ffULL,
0x00005c0010047625ULL, 0x000fc800078e0017ULL, 0x00005c0013067625ULL, 0x000fe200078e0017ULL,
0x0000001504047210ULL, 0x000fc60007f3e0ffULL, 0x0000002011147824ULL, 0x000fe200078e0214ULL,
0x0000001506067210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001012117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001014137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608487981ULL, 0x018ea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff4b7e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f48007810ULL, 0x004fc40007ffe0ffULL,
0x000000ff48027810ULL, 0x002fe40007ffe0ffULL, 0x00000006ff007819ULL, 0x000fe40000011600ULL,
0x00000008ff027819ULL, 0x000fca0000011602ULL, 0x0000ffe000008947ULL, 0x000fea0003800000ULL,
0x000000044b037824ULL, 0x000fe200078e00ffULL, 0x00010610490b7811ULL, 0x000fe200078e20ffULL,
0x00000003ff067424ULL, 0x000fc600078e00ffULL, 0x000000000300720cULL, 0x000fda0003f06070ULL,
0x0000640003058a10ULL, 0x000fe20007ffe0ffULL, 0x000000020a048824ULL, 0x000fc800078e00ffULL,
0x0000640004058a24ULL, 0x000fe400078e0205ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000004060bff738cULL, 0x0003e20000000000ULL,
0x0000600005088625ULL, 0x000fe200078e0019ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000608048981ULL, 0x0004e2000c1e1900ULL, 0x000001004b0d7824ULL, 0x040fe200078e00ffULL,
0x000000014b077810ULL, 0x000fe20007ffe0ffULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000000000057919ULL, 0x000f220000000000ULL, 0x00000100ff1a7424ULL, 0x000fe200078e00ffULL,
0x0000000d48067217ULL, 0x002fe20007800000ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x0000004016077824ULL, 0x000fe200078e00ffULL,
0x000000000bff7f8cULL, 0x0003e2000c80043fULL, 0x00000001060d7824ULL, 0x000fe200078e0a0dULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000849067824ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000200d0d7807ULL, 0x000fe20000000000ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fc400078e00ffULL, 0x000000060d0d7217ULL, 0x000fca0007800000ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a06ULL, 0x00000004ff0c7819ULL, 0x010fe20000011605ULL,
0x0000001005157824ULL, 0x000fc600078e00ffULL, 0x000000020c0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x004fe200078e020cULL, 0x000000040c0f7810ULL, 0x040fe40007ffe0ffULL,
0x000000060c107810ULL, 0x040fe40007ffe0ffULL, 0x0000000d0c00720cULL, 0x080fe40003f66070ULL,
0x0000000d0e00720cULL, 0x080fe20003f46070ULL, 0x0000000106117824ULL, 0x040fe200078e0210ULL,
0x0000000d0f00720cULL, 0x080fe20003f26070ULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000000d1000720cULL, 0x000fe20003f06070ULL, 0x00000001060d7824ULL, 0x000fe200078e020eULL,
0x0000000709087812ULL, 0x000fc400078ec0ffULL, 0x000000070f107812ULL, 0x000fe400078ec0ffULL,
0x0000000f08087812ULL, 0x100fe400078e7805ULL, 0x000000070d0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000711127812ULL, 0x000fe200078ec0ffULL, 0x0000001009147824ULL, 0x000fe200078e0208ULL,
0x0000000f0e0e7812ULL, 0x100fe400078e7805ULL, 0x0000000f10107812ULL, 0x000fc400078e7805ULL,
0x0000000f12127812ULL, 0x000fe200078e7805ULL, 0x000000100d167824ULL, 0x000fe200078e020eULL,
0x000000f015157812ULL, 0x000fe200078ec0ffULL, 0x000000100f187824ULL, 0x000fe400078e0210ULL,
0x0000001011197824ULL, 0x000fe200078e0212ULL, 0x0000c00016177811ULL, 0x000fe400078e20ffULL,
0x0000c000180b7811ULL, 0x002fe400078e20ffULL, 0x0000c000191d7811ULL, 0x000fc400078e20ffULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000004040c7e24ULL, 0x008fca000f8e0207ULL,
0x0000003f0c097812ULL, 0x040fe400078ef809ULL, 0x0000003f0c0d7812ULL, 0x040fe400078ef80dULL,
0x0000003f0c0f7812ULL, 0x040fe200078ef80fULL, 0x00005e0009087625ULL, 0x000fe200078e001aULL,
0x0000003f0c107812ULL, 0x000fc600078ef811ULL, 0x00005e000d0c7625ULL, 0x000fe200078e001aULL,
0x0000001508127210ULL, 0x000fc60007fbe0ffULL, 0x00005e000f0e7625ULL, 0x000fe200078e001aULL,
0x000000150c0c7210ULL, 0x000fc60007f9e0ffULL, 0x00005e0010107625ULL, 0x000fe400078e001aULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x000000ffff137224ULL, 0x000fe200028e0609ULL,
0x000000150e0e7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e060dULL,
0x0000001510107210ULL, 0x000fe20007fde0ffULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x0000c00014157811ULL, 0x000fe200078e20ffULL, 0x000000ffff0f7224ULL, 0x000fc400028e060fULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc600078e00ffULL,
0x000000000c177faeULL, 0x0003e8000d101c46ULL, 0x000000000e0b7faeULL, 0x0003e2000c901c46ULL,
0x000000024b00720cULL, 0x000fc60003f26070ULL, 0x00000000101d7faeULL, 0x0003e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000bdd000001947ULL, 0x000fea0003800000ULL, 0x000000020a0b7824ULL, 0x002fe200078e00ffULL,
0x00007610ff697816ULL, 0x000fe20000000069ULL, 0x00006400ff0c7624ULL, 0x000fc400078e00ffULL,
0x00000004490a7824ULL, 0x000fe400078e00ffULL, 0x000064000b0c7624ULL, 0x000fe200078e020cULL,
0x00007610ff0b7816ULL, 0x000fe2000000000bULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x000000020a0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x000001004b0d7824ULL, 0x000fca00078e00ffULL, 0x000000480d00720cULL, 0x000fda0003f06070ULL,
0x0000bcb000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000ffff687224ULL, 0x000fe200078e0003ULL, 0x00007610690d7816ULL, 0x000fe2000000000dULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL,
0x0000000f00107305ULL, 0x0002a4000021f000ULL, 0x3fa000000f0f7823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000300ff0f7624ULL, 0x000fe200078e00ffULL,
0x0000000303107812ULL, 0x000fe200078ec0ffULL, 0x0000000404237e24ULL, 0x000fe4000f8e0207ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x000000031000780cULL, 0x000fe40003f05270ULL,
0xfffffffd0f0f7811ULL, 0x000fc800078e10ffULL, 0x000000010f107807ULL, 0x000fca0004000000ULL,
0x0000000103037824ULL, 0x000fca00078e0210ULL, 0x000000000300720cULL, 0x000fe40003f06070ULL,
0x000000204b0f7811ULL, 0x040fe400078e40ffULL, 0x000000014b137810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff277819ULL, 0x000fce0000011605ULL, 0x0000000103108824ULL, 0x000fe400078e020cULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000600010108625ULL, 0x000fe200078e0011ULL,
0x0000000f48127217ULL, 0x000fc80007800000ULL, 0x0000000610048981ULL, 0x000362000c1e1900ULL,
0x000000021300720cULL, 0x000fe20003f06070ULL, 0x00000001121c7824ULL, 0x000fe200078e0a0fULL,
0x0000000427137810ULL, 0x000fe20007ffe0ffULL, 0x00000001060f7824ULL, 0x040fe200078e0227ULL,
0x0000002023237810ULL, 0x000fe20007ffe0ffULL, 0x0000001005617824ULL, 0x000fe200078e00ffULL,
0x0000000627157810ULL, 0x000fe20007ffe0ffULL, 0x0000000106147824ULL, 0x040fe200078e0213ULL,
0x0000003f0f5e7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff457424ULL, 0x000fe200078e00ffULL,
0x0000000227117810ULL, 0x002fe20007ffe0ffULL, 0x0000000106167824ULL, 0x000fe200078e0215ULL,
0x0000003f145c7812ULL, 0x000fe200078ec0ffULL, 0x000000015e1d7824ULL, 0x000fe200078e0223ULL,
0x000000201c1f7807ULL, 0x000fe20000000000ULL, 0x0000000106127824ULL, 0x000fe200078e0211ULL,
0x000000f061107812ULL, 0x000fe200078ec0ffULL, 0x000000015c207824ULL, 0x000fe200078e0223ULL,
0x0000001f06257217ULL, 0x000fe20007800000ULL, 0x00005e001d1c7625ULL, 0x000fe200078e0045ULL,
0x0000003f125d7812ULL, 0x000fc400078ec0ffULL, 0x0000003f165b7812ULL, 0x000fe200078ec0ffULL,
0x00005e0020207625ULL, 0x080fe200078e0045ULL, 0x000000101c227210ULL, 0x080fe40007f3e0ffULL,
0x000000070f267812ULL, 0x000fe200078ec0ffULL, 0x000000015d1e7824ULL, 0x000fe200078e0223ULL,
0x0000001020207210ULL, 0x000fe20007f7e0ffULL, 0x0000000125247824ULL, 0x000fe200078e0a06ULL,
0x0000000714447812ULL, 0x000fe200078ec0ffULL, 0x00005e001e1e7625ULL, 0x000fe200078e0045ULL,
0x0000000716467812ULL, 0x000fc400078ec0ffULL, 0x000000241500720cULL, 0x000fe20003f86070ULL,
0x000000015b1c7824ULL, 0x000fe200078e0223ULL, 0x000000101e1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200008e061dULL, 0x000000242700720cULL, 0x080fe20003f26070ULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x000000241300720cULL, 0x080fe20003f66070ULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x000000241100720cULL, 0x000fe20003f46070ULL,
0x00005e001c1c7625ULL, 0x000fe200078e0045ULL, 0x0000000712247812ULL, 0x000fc400078ec0ffULL,
0x0000000f26267812ULL, 0x100fe400078e7805ULL, 0x0000000f24257812ULL, 0x100fe400078e7805ULL,
0x0000000f444d7812ULL, 0x100fe200078e7805ULL, 0x000000100f4f7824ULL, 0x000fe200078e0226ULL,
0x0000000f46277812ULL, 0x000fe200078e7805ULL, 0x00000010124e7824ULL, 0x000fe200078e0225ULL,
0x000000101c1c7210ULL, 0x000fe20007fbe0ffULL, 0x00000010144d7824ULL, 0x000fe200078e024dULL,
0x0000e0004f657811ULL, 0x000fe200078e20ffULL, 0x00000010164c7824ULL, 0x000fe200078e0227ULL,
0x0000e0004e647811ULL, 0x000fe200078e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e061dULL,
0x0000e0004d637811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022657faeULL, 0x0003e2000c901c46ULL, 0x0000e0004c627811ULL, 0x000fc600078e20ffULL,
0x000000001e647faeULL, 0x0003e8000d101c46ULL, 0x0000000020637faeULL, 0x0003e8000d901c46ULL,
0x000000001c627faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1f7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff1e7984ULL, 0x000ea20000000800ULL, 0x0000ffff691c7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff0b1d7812ULL, 0x000fe400078ec0ffULL, 0x000088801c217816ULL, 0x000fe400000000ffULL,
0x000088801d5f7816ULL, 0x000fc600000000ffULL, 0x80000000211c7824ULL, 0x000fe400078e00ffULL,
0x800000005f1d7824ULL, 0x000fc600078e00ffULL, 0x800000001fff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000005f1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01060c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff1c7819ULL, 0x000fe20000011605ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000007061617812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1c7812ULL, 0x000fca00078ec0ffULL,
0x0000000161617824ULL, 0x000fca00078e021cULL, 0x01000000611d7984ULL, 0x000e680000000800ULL,
0x01020000611c7984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e227812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f54000ULL,
0x0000001d08247209ULL, 0x000fe40007810000ULL, 0x00000002ff1f7819ULL, 0x000fc60000011605ULL,
0x80000024081e7221ULL, 0x000fe20000010000ULL, 0x000000081f207810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b1e1e7820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x000000ff4900720cULL, 0x000fe40003f45270ULL, 0x0000ffff08237812ULL, 0x000fe200078e3cffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x000000ffff087224ULL, 0x000fe400078e0024ULL,
0x0000002322ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff567807ULL, 0x000fc60001800000ULL,
0x010400246100a388ULL, 0x000fe80000000800ULL, 0x00001f201e207589ULL, 0x002e6400000e0000ULL,
0x800000241d1d3221ULL, 0x000fe20000010000ULL, 0x0000001e09097220ULL, 0x000fe20000410000ULL,
0x00001f1f1e1f7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b1d1d3820ULL, 0x000fc80000410000ULL,
0x0000001d00173308ULL, 0x000ee20000000800ULL, 0x000000201b1b7220ULL, 0x082fe20000410000ULL,
0x000000201a1a7220ULL, 0x080fe20000410000ULL, 0x000000202b2b7220ULL, 0x080fe20000410000ULL,
0x000000202a2a7220ULL, 0x080fe20000410000ULL, 0x000000202f2f7220ULL, 0x080fe20000410000ULL,
0x000000202e2e7220ULL, 0x080fe20000410000ULL, 0x0000002033337220ULL, 0x080fe20000410000ULL,
0x0000002032327220ULL, 0x080fe20000410000ULL, 0x0000002037377220ULL, 0x080fe20000410000ULL,
0x0000002036367220ULL, 0x080fe20000410000ULL, 0x000000203b3b7220ULL, 0x080fe20000410000ULL,
0x000000203a3a7220ULL, 0x080fe20000410000ULL, 0x000000203f3f7220ULL, 0x080fe20000410000ULL,
0x000000203e3e7220ULL, 0x080fe20000410000ULL, 0x0000002043437220ULL, 0x080fe20000410000ULL,
0x0000002042427220ULL, 0x000fe20000410000ULL, 0x0000001f19197220ULL, 0x084fe20000410000ULL,
0x0000001f18187220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f40407220ULL, 0x000fe20000410000ULL, 0x000000171c1c3220ULL, 0x008fc80000410000ULL,
0x000000091c097221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff1c7984ULL, 0x000e620000000800ULL, 0x80000000211d7824ULL, 0x000fca00078e00ffULL,
0x800000001cff7812ULL, 0x002fe2000782481dULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x80000000211e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01064c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000008051c7812ULL, 0x040fe400078ec0ffULL, 0x0000000a051d7211ULL, 0x040fe400078fe0ffULL,
0x000000071c1e7812ULL, 0x140fe400078ec805ULL, 0x000000071c1c7812ULL, 0x000fe400078ef805ULL,
0x0000001d1e1d7212ULL, 0x000fe400078e3cffULL, 0x0000000e051f7211ULL, 0x000fc400078fe0ffULL,
0x0000000705667812ULL, 0x000fe200078ec0ffULL, 0x000000101c537824ULL, 0x000fe200078e021dULL,
0x0000001f1e1f7212ULL, 0x000fe400078e3cffULL, 0x0000000866667812ULL, 0x000fe400078ef805ULL,
0x0000c00053607811ULL, 0x000fe200078e20ffULL, 0x000000101c527824ULL, 0x040fe200078e021fULL,
0x000001001c1c7811ULL, 0x000fc600078e20ffULL, 0x000000006024783bULL, 0x000e620000004200ULL,
0x0000c000525a7811ULL, 0x000fe200078e20ffULL, 0x000000011d517824ULL, 0x100fe400078e021cULL,
0x000000011f507824ULL, 0x000fe400078e021cULL, 0x000000005a44783bULL, 0x000ea20000004200ULL,
0x0000c00051597811ULL, 0x000fe400078e20ffULL, 0x0000c00050587811ULL, 0x000fc600078e20ffULL,
0x00000000591c783bULL, 0x000ee80000004200ULL, 0x000000005820783bULL, 0x000f220000004200ULL,
0x00000018ff977819ULL, 0x002fe20000011424ULL, 0x00000100244a7824ULL, 0x040fe200078e00ffULL,
0x00008880246e7816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011425ULL, 0x0000010025577824ULL, 0x040fe200078e00ffULL,
0x00008880259a7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff577819ULL, 0x000fc40000011457ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x00000018ff917819ULL, 0x000fe20000011426ULL,
0x0000002400987306ULL, 0x0003e20000200c00ULL, 0x00000018ff807819ULL, 0x000fe40000011427ULL,
0x0000888026967816ULL, 0x000fe400000000ffULL, 0x00008880277b7816ULL, 0x000fc400000000ffULL,
0x00000018ff8b7819ULL, 0x004fe20000011444ULL, 0x0000002500997306ULL, 0x0005e20000200c00ULL,
0x0000010026247824ULL, 0x002fe200078e00ffULL, 0x0000888044907816ULL, 0x000fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011445ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000057009b7306ULL, 0x0003e20000200c00ULL,
0x0000010045257824ULL, 0x004fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x00000018ff707819ULL, 0x008fe4000001141cULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002400957306ULL, 0x0005e20000200c00ULL, 0x00000004ff577819ULL, 0x002fe40000011605ULL,
0x0000888045817816ULL, 0x040fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000000757577812ULL, 0x000fe400078e7866ULL, 0x000088801c7d7816ULL, 0x000fe200000000ffULL,
0x00000025008e7306ULL, 0x0003e20000200c00ULL, 0x0000010044247824ULL, 0x004fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000000866577824ULL, 0x000fe200078e0257ULL,
0x00000018ff6d7819ULL, 0x000fe2000001141dULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000004a00737306ULL, 0x0005e20000200c00ULL,
0x0000010047257824ULL, 0x002fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x000088801d797816ULL, 0x000fe400000000ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000024008f7306ULL, 0x0003e20000200c00ULL, 0x00000100274a7824ULL, 0x044fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011446ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fc40000011447ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000002500877306ULL, 0x0005e20000200c00ULL, 0x0000010046247824ULL, 0x042fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00008880468a7816ULL, 0x040fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002600927306ULL, 0x000fe20000200c00ULL, 0x000001001d257824ULL, 0x004fe200078e00ffULL,
0x0000888047847816ULL, 0x000fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc40000011425ULL, 0x0000002400897306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000018ff6c7819ULL, 0x010fe40000011420ULL, 0x00008880206f7816ULL, 0x000fe200000000ffULL,
0x0000002700937306ULL, 0x0005e20000200c00ULL, 0x000001001c247824ULL, 0x042fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011421ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801e757816ULL, 0x000fc400000000ffULL, 0x00000018ff7c7819ULL, 0x000fe40000011424ULL,
0x0000a00057247811ULL, 0x000fe200078e20ffULL, 0x00000044008c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff777819ULL, 0x000fe4000001141cULL, 0x00000017ff1c723eULL, 0x000fe400000000ffULL,
0x000000002424783bULL, 0x004fe20000000200ULL, 0x000088801f727816ULL, 0x000fe400000000ffULL,
0x0000004a00947306ULL, 0x0005e20000200c00ULL, 0x00000002ff447819ULL, 0x002fc40000011605ULL,
0x00000018ff557819ULL, 0x000fe40000011422ULL, 0x00000018ff547819ULL, 0x000fe40000011423ULL,
0x00000018ff6a7819ULL, 0x000fe2000001141eULL, 0x00000045008d7306ULL, 0x0003e20000200c00ULL,
0x00000008444a7810ULL, 0x004fe40007ffe0ffULL, 0x00000018ff677819ULL, 0x000fca000001141fULL,
0x0000001d00767306ULL, 0x0005e20000200c00ULL, 0x000054101c457816ULL, 0x002fe2000000001cULL,
0x000001001e1c7824ULL, 0x040fe400078e00ffULL, 0x000100001e1e7824ULL, 0x000fe400078e00ffULL,
0x00001f4445837589ULL, 0x0002e200000e0000ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000009a009a7306ULL, 0x000fe20000200c00ULL, 0x00009910561d7816ULL, 0x004fe200000000ffULL,
0x00001f4a45827589ULL, 0x00052200000e0000ULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x000001001f1d7824ULL, 0x000fe400078e00ffULL,
0x0000009700977306ULL, 0x000f220000200c00ULL, 0x0000010020447824ULL, 0x042fe400078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000000711457812ULL, 0x004fe200078e7866ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe20000011444ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000000866567824ULL, 0x000fe200078e0245ULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000008324249232ULL, 0x008fc80000000000ULL,
0x0000001c00747306ULL, 0x0005e20000200c00ULL, 0x0000008326269232ULL, 0x000fe20000000000ULL,
0x0000541098447816ULL, 0x010fe20000000097ULL, 0x0000008225259232ULL, 0x080fe40000000000ULL,
0x0000008227279232ULL, 0x000fc60000000000ULL, 0x0000001d00717306ULL, 0x0007e20000200c00ULL,
0x000054106e1c7816ULL, 0x004fe40000000073ULL, 0x0000541099457816ULL, 0x002fe40000000078ULL,
0x0000888021737816ULL, 0x000fc600000000ffULL, 0x0000009600967306ULL, 0x000fe20000200c00ULL,
0x000054109a1d7816ULL, 0x008fce000000009bULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x0000001c2440723cULL, 0x000fee0000001840ULL, 0x00000100211d7824ULL, 0x040fe200078e00ffULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x0000a000561c7811ULL, 0x000fe200078e20ffULL,
0x0001000021217824ULL, 0x000fc400078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc6000001141dULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000008000807306ULL, 0x000ef00000200c00ULL,
0x0000004600887306ULL, 0x000ff00000200c00ULL, 0x0000004700857306ULL, 0x0009f00000200c00ULL,
0x0000001d00787306ULL, 0x0003e20000200c00ULL, 0x000000442444723cULL, 0x010fe2000000183cULL,
0x000000001c3c783bULL, 0x0008ec0000000200ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054107b1d7816ULL, 0x002fc40000000094ULL, 0x00005410961c7816ULL, 0x010fca0000000095ULL,
0x0000008100817306ULL, 0x000e640000200c00ULL, 0x0000001c2438723cULL, 0x000fec0000001838ULL,
0x0000008b008b7306ULL, 0x000f220000200c00ULL, 0x00005410921c7816ULL, 0x004fe40000000091ULL,
0x00005410931d7816ULL, 0x008fc40000000080ULL, 0x0000888022917816ULL, 0x000fc600000000ffULL,
0x0000008600867306ULL, 0x000ea40000200c00ULL, 0x0000001c2434723cULL, 0x000fec0000001834ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x00005410901c7816ULL, 0x000fe2000000008fULL,
0x000000833c3c9232ULL, 0x080fe20000000000ULL, 0x00005410811d7816ULL, 0x002fe2000000008eULL,
0x000000833e3e9232ULL, 0x000fe20000000000ULL, 0x000000ffff817224ULL, 0x000fe200078e0091ULL,
0x000000823d3d9232ULL, 0x000fc40000000000ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000000823f3f9232ULL, 0x000fe20000000000ULL, 0x0000001c2430723cULL, 0x000fec0000001830ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054108c1c7816ULL, 0x010fe4000000008bULL,
0x000054108d1d7816ULL, 0x004fc40000000086ULL, 0x0000888023867816ULL, 0x000fc600000000ffULL,
0x0000007e007e7306ULL, 0x000e640000200c00ULL, 0x0000001c242c723cULL, 0x000fec000000182cULL,
0x00000020007b7306ULL, 0x0005f00000200c00ULL, 0x0000002100807306ULL, 0x0007e20000200c00ULL,
0x0000010022207824ULL, 0x044fe200078e00ffULL, 0x00005410851d7816ULL, 0x002fe2000000007eULL,
0x0001000022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe40000011420ULL,
0x000054108a207816ULL, 0x000fe20000000089ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000541084217816ULL, 0x008fe40000000087ULL, 0x00000018ff227819ULL, 0x000fca0000011422ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000000202428723cULL, 0x000fee0000001828ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000010023217824ULL, 0x040fe400078e00ffULL,
0x0001000023237824ULL, 0x000fc400078e00ffULL, 0x000000ffff207224ULL, 0x000fc600078e0086ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x00000018ff237819ULL, 0x000fce0000011423ULL,
0x0000001c00847306ULL, 0x0005f00000200c00ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410881c7816ULL, 0x004fce000000007fULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000001c2418723cULL, 0x000fee0000001818ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe40000011421ULL, 0x00005410791d7816ULL, 0x002fca000000007aULL,
0x0000001c00857306ULL, 0x0003f00000200c00ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x000054107d1c7816ULL, 0x002fce000000007cULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000001c3c40723cULL, 0x000fee0000001840ULL, 0x00005410771c7816ULL, 0x004fe20000000070ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x00005410761d7816ULL, 0x000fce000000006dULL,
0x0000001c3c44723cULL, 0x000fe20000001844ULL, 0x0000006f006f7306ULL, 0x000fec0000200c00ULL,
0x00005410751c7816ULL, 0x008fe40000000074ULL, 0x00005410721d7816ULL, 0x002fe20000000071ULL,
0x0000009c006e7306ULL, 0x000e620000200c00ULL, 0x00005410806d7816ULL, 0x004fca000000006bULL,
0x0000001c3c38723cULL, 0x000fe40000001838ULL, 0x0000006c006c7306ULL, 0x000eb00000200c00ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054106f6e7816ULL, 0x002fce000000006eULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054107b6c7816ULL, 0x004fce000000006cULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000006c3c2c723cULL, 0x000fee000000182cULL,
0x0000008100817306ULL, 0x000eb00000200c00ULL, 0x0000002000207306ULL, 0x000ee20000200c00ULL,
0x00005410736f7816ULL, 0x002fce0000000078ULL, 0x0000001e00217306ULL, 0x000e620000200c00ULL,
0x0000541081847816ULL, 0x004fe20000000084ULL, 0x0000006e3c30723cULL, 0x000fec0000001830ULL,
0x0000001f001c7306ULL, 0x000ea20000200c00ULL, 0x0000541020857816ULL, 0x008fce0000000085ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00005410216a7816ULL, 0x002fe2000000006aULL,
0x000000843c28723cULL, 0x000fec0000001828ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x000054101c6b7816ULL, 0x004fce0000000067ULL, 0x0000002200227306ULL, 0x000e620000200c00ULL,
0x0000006a3c34723cULL, 0x000fee0000001834ULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x0000541022227816ULL, 0x002fe40000000055ULL, 0x0000541023237816ULL, 0x004fce0000000054ULL,
0x000000223c3c723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01065c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000404b197811ULL, 0x000fe200078e40ffULL,
0x0000000404237e24ULL, 0x020fe2000f8e0207ULL, 0x00000004ff217819ULL, 0x000fe20000011605ULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0x0000001948187217ULL, 0x000fc40007800000ULL,
0x0000003f231c7812ULL, 0x040fe400078ef812ULL, 0x0000003f231e7812ULL, 0x040fe200078ef814ULL,
0x0000000118187824ULL, 0x000fe200078e0a19ULL, 0x0000003f23207812ULL, 0x000fe200078ef816ULL,
0x00005e001c1c7625ULL, 0x080fe200078e0025ULL, 0x0000c0004f4f7811ULL, 0x000fe400078e20ffULL,
0x0000002018197807ULL, 0x000fe20000000000ULL, 0x00005e001e1e7625ULL, 0x000fe200078e0025ULL,
0x0000003f23187812ULL, 0x000fc400078ef80fULL, 0x00000019061b7217ULL, 0x000fe40007800000ULL,
0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL, 0x00005e0018187625ULL, 0x000fe200078e0025ULL,
0x0000c0004d4d7811ULL, 0x000fe400078e20ffULL, 0x0000c0004c4c7811ULL, 0x000fe200078e20ffULL,
0x000000011b227824ULL, 0x000fe200078e0a06ULL, 0x00000010181a7210ULL, 0x080fe40007f7e0ffULL,
0x000000101c187210ULL, 0x000fc40007f9e0ffULL, 0x000000101e1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e0619ULL, 0x000000222100720cULL, 0x080fe20003f46070ULL,
0x00005e0020207625ULL, 0x000fe200078e0025ULL, 0x000000221100720cULL, 0x000fc60003f66070ULL,
0x000000ffff197224ULL, 0x000fe200020e061dULL, 0x000000221300720cULL, 0x080fe20003f86070ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061fULL, 0x000000221500720cULL, 0x000fe40003fa6070ULL,
0x00000010201e7210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a4f7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff1f7224ULL, 0x000fe400030e0621ULL,
0x00000000184e7faeULL, 0x0003e8000d901c46ULL, 0x000000001c4d7faeULL, 0x0003e8000e101c46ULL,
0x000000001e4c7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff197984ULL, 0x002e620000000800ULL, 0x0000ffff69187812ULL, 0x000fc800078ec0ffULL,
0x00008880181a7816ULL, 0x000fca00000000ffULL, 0x800000001a187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x002fe20007844818ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x01065400ff197984ULL, 0x000e620000000800ULL,
0x800000001a187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x002fe20007844818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000001a197824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x00000018001a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x0000001a0000735dULL, 0x004fe40003800000ULL, 0x01065400ff1a7984ULL, 0x000e640000000800ULL,
0x800000001aff7812ULL, 0x002fc40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000e00053537811ULL, 0x000fe400078e20ffULL,
0x0000e00052527811ULL, 0x000fe400078e20ffULL, 0x0000e00051517811ULL, 0x000fe200078e20ffULL,
0x000000005320783bULL, 0x000e620000004200ULL, 0x0000e00050507811ULL, 0x000fe400078e20ffULL,
0x00000002ff817819ULL, 0x000fe20000011605ULL, 0x000000005224783bULL, 0x000ea80000004200ULL,
0x000000005118783bULL, 0x000ee80000004200ULL, 0x00000000501c783bULL, 0x000f220000004200ULL,
0x00000018ff967819ULL, 0x002fe20000011420ULL, 0x0000010020547824ULL, 0x040fe200078e00ffULL,
0x0000888020997816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011421ULL, 0x0000010021557824ULL, 0x040fe200078e00ffULL,
0x00008880219b7816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000009900997306ULL, 0x000fe20000200c00ULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff907819ULL, 0x000fe40000011422ULL, 0x00000018ff7f7819ULL, 0x000fe20000011423ULL,
0x0000002000977306ULL, 0x0003e20000200c00ULL, 0x0000888022957816ULL, 0x000fe400000000ffULL,
0x0000888023787816ULL, 0x000fe400000000ffULL, 0x00000018ff887819ULL, 0x004fc40000011424ULL,
0x00008880248f7816ULL, 0x000fe200000000ffULL, 0x0000002100987306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x008fe20000011419ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888019797816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000054009a7306ULL, 0x0003e20000200c00ULL,
0x0000010025217824ULL, 0x004fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc40000011422ULL,
0x00000018ff707819ULL, 0x000fe40000011418ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000947306ULL, 0x0005e20000200c00ULL, 0x0000010023547824ULL, 0x042fe200078e00ffULL,
0x00008880187c7816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000021008c7306ULL, 0x0003e20000200c00ULL, 0x0000010024207824ULL, 0x044fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe40000011427ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000005400937306ULL, 0x000fe20000200c00ULL, 0x0000010027217824ULL, 0x002fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x0000888027847816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000020008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff857819ULL, 0x000fe40000011425ULL,
0x00000018ff6e7819ULL, 0x000fe4000001141aULL, 0x0000888025837816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x000088801a747816ULL, 0x000fe200000000ffULL,
0x0000002100877306ULL, 0x0005e20000200c00ULL, 0x0000010026207824ULL, 0x002fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fc40000011426ULL, 0x00008880268b7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002200917306ULL, 0x000fe20000200c00ULL, 0x0000000713217812ULL, 0x004fe400078e7866ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff6d7819ULL, 0x000fe2000001141bULL,
0x0000000866547824ULL, 0x000fe200078e0221ULL, 0x000088801b717816ULL, 0x000fe200000000ffULL,
0x0000002000867306ULL, 0x0003e20000200c00ULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff6c7819ULL, 0x010fe4000001141cULL,
0x00000018ff6b7819ULL, 0x000fe2000001141dULL, 0x0000002300927306ULL, 0x000fe20000200c00ULL,
0x0000010018207824ULL, 0x042fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001141eULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe4000001141fULL,
0x00000018ff7b7819ULL, 0x000fe20000011420ULL, 0x0000010019207824ULL, 0x040fe200078e00ffULL,
0x00000024008d7306ULL, 0x0003e20000200c00ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff7a7819ULL, 0x000fe40000011420ULL,
0x0000a00054207811ULL, 0x000fe400078e20ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000009b009b7306ULL, 0x000fe20000200c00ULL, 0x00000017ff24723eULL, 0x002fe400000000ffULL,
0x000000002020783bULL, 0x000fea0000000200ULL, 0x0000001900767306ULL, 0x0003f00000200c00ULL,
0x00000055009c7306ULL, 0x0004e20000200c00ULL, 0x0000541024197816ULL, 0x002fe20000000024ULL,
0x000001001a247824ULL, 0x000fc400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe400078e00ffULL,
0x00001f8119817589ULL, 0x000e6200000e0000ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000001800777306ULL, 0x0009e20000200c00ULL, 0x0000000715557812ULL, 0x004fe200078e7866ULL,
0x00001f4a19807589ULL, 0x0006a200000e0000ULL, 0x00000018ff1a7819ULL, 0x000fc6000001141aULL,
0x0000000866557824ULL, 0x000fe200078e0255ULL, 0x000088801c667816ULL, 0x000fe200000000ffULL,
0x0000009600967306ULL, 0x000f620000200c00ULL, 0x000001001b187824ULL, 0x050fe400078e00ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000054109b197816ULL, 0x008fe4000000009cULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x0000008120209232ULL, 0x002fcc0000000000ULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x0000008122229232ULL, 0x000fe40000000000ULL,
0x0000008021219232ULL, 0x084fe40000000000ULL, 0x0000008023239232ULL, 0x000fc60000000000ULL,
0x0000007800787306ULL, 0x000e700000200c00ULL, 0x0000002400737306ULL, 0x0005f00000200c00ULL,
0x0000001800727306ULL, 0x0009e20000200c00ULL, 0x000001001c247824ULL, 0x004fc400078e00ffULL,
0x000100001c1c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x0000541099187816ULL, 0x010fe4000000009aULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x000000182040723cULL, 0x000fee0000001840ULL, 0x0000002700827306ULL, 0x000fe20000200c00ULL,
0x0000541097187816ULL, 0x020fe40000000096ULL, 0x0000541098197816ULL, 0x008fc40000000075ULL,
0x000088801d967816ULL, 0x000fc600000000ffULL, 0x00000025008a7306ULL, 0x0003e40000200c00ULL,
0x000000182044723cULL, 0x000fec0000001844ULL, 0x0000001a00277306ULL, 0x0007e20000200c00ULL,
0x0000541078257816ULL, 0x002fe20000000093ULL, 0x000001001d937824ULL, 0x000fc400078e00ffULL,
0x000000ffff787224ULL, 0x000fc800078e0096ULL, 0x0000002400757306ULL, 0x0003e20000200c00ULL,
0x0000a000551a7811ULL, 0x008fce00078e20ffULL, 0x0000008f008f7306ULL, 0x000ee20000200c00ULL,
0x0000541095247816ULL, 0x002fce0000000094ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x000000242038723cULL, 0x000fee0000001838ULL, 0x0000002600897306ULL, 0x000fe20000200c00ULL,
0x0000541091247816ULL, 0x004fe40000000090ULL, 0x0000541092257816ULL, 0x010fc4000000007fULL,
0x00000018ff7f7819ULL, 0x000fc60000011493ULL, 0x0000001b00267306ULL, 0x0005e40000200c00ULL,
0x000000242034723cULL, 0x000fec0000001834ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x000000001a18783bULL, 0x004ea20000000200ULL, 0x000054108f247816ULL, 0x008fc4000000008eULL,
0x0000541083257816ULL, 0x002fc8000000008cULL, 0x0000008500857306ULL, 0x000e660000200c00ULL,
0x000000242030723cULL, 0x000fea0000001830ULL, 0x0000008400847306ULL, 0x000ee40000200c00ULL,
0x000100001d247824ULL, 0x000fcc00078e00ffULL, 0x0000008b008b7306ULL, 0x000f220000200c00ULL,
0x000054108a1d7816ULL, 0x002fe40000000085ULL, 0x000088801e857816ULL, 0x000fca00000000ffULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x0000541084257816ULL, 0x008fce0000000087ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x0000008118189232ULL, 0x084fe40000000000ULL,
0x000000811a1a9232ULL, 0x000fe40000000000ULL, 0x0000008019199232ULL, 0x080fe40000000000ULL,
0x000000801b1b9232ULL, 0x000fe20000000000ULL, 0x0000001c00837306ULL, 0x0005f00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000054108d1c7816ULL, 0x004fce0000000088ULL,
0x0000007b007b7306ULL, 0x000ea20000200c00ULL, 0x0000001c202c723cULL, 0x000fee000000182cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe40000011424ULL,
0x000054108b247816ULL, 0x010fc40000000086ULL, 0x00005410891c7816ULL, 0x002fc6000000007eULL,
0x0000007a007a7306ULL, 0x000e640000200c00ULL, 0x000000242028723cULL, 0x000fec0000001828ULL,
0x0000001d00847306ULL, 0x0007e20000200c00ULL, 0x000001001e257824ULL, 0x040fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc400078e00ffULL, 0x000000ffff247224ULL, 0x000fe200078e0085ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410821d7816ULL, 0x008fe4000000007dULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x0000006f006f7306ULL, 0x000ee20000200c00ULL, 0x0000001c2020723cULL, 0x000fee000000183cULL,
0x000054107c1c7816ULL, 0x004fe2000000007bULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00005410791d7816ULL, 0x002fc4000000007aULL, 0x000088801f3c7816ULL, 0x000fe400000000ffULL,
0x00005410763d7816ULL, 0x008fc6000000006fULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x0000001c1840723cULL, 0x000fee0000001840ULL, 0x000000ffff1c7224ULL, 0x000fe200078e003cULL,
0x00005410773c7816ULL, 0x000fe20000000070ULL, 0x000001001f1d7824ULL, 0x040fe200078e00ffULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x000100001f1f7824ULL, 0x000fc800078e00ffULL,
0x0000003c183c723cULL, 0x000fe20000001844ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001c00797306ULL, 0x0007e80000200c00ULL, 0x00000018ff447819ULL, 0x000fe4000001141dULL,
0x00005410711d7816ULL, 0x002fe40000000072ULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x00005410741c7816ULL, 0x008fc40000000073ULL, 0x00005410266f7816ULL, 0x004fca000000006dULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x0000001c1838723cULL, 0x000fee0000001838ULL,
0x0000006e006e7306ULL, 0x000eb00000200c00ULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x0000541024247816ULL, 0x002fce0000000025ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x00005410276e7816ULL, 0x004fce000000006eULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x00005410836c7816ULL, 0x008fe2000000006cULL, 0x0000006e1834723cULL, 0x000fec0000001834ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x00005410846d7816ULL, 0x002fce000000006bULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x00005410667e7816ULL, 0x004fe20000000075ULL,
0x0000006c182c723cULL, 0x000fec000000182cULL, 0x0000004400447306ULL, 0x000eb00000200c00ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00005410787f7816ULL, 0x002fce000000007fULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541079257816ULL, 0x004fe20000000044ULL,
0x0000007e1830723cULL, 0x040fec0000001830ULL, 0x0000001e001d7306ULL, 0x000e640000200c00ULL,
0x000000241828723cULL, 0x000fec0000001828ULL, 0x0000001f001c7306ULL, 0x000ea20000200c00ULL,
0x000054101d667816ULL, 0x002fc4000000006aULL, 0x000054101c677816ULL, 0x004fce0000000067ULL,
0x000000661818723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000404b1d7811ULL, 0x000fe200078e40ffULL,
0x01061000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff69ff7812ULL, 0x000fe4000782c0ffULL,
0x0000001d4800720cULL, 0x000fe40003f44070ULL, 0x00000001ff697807ULL, 0x000fd60000800000ULL,
0x000089f00000a947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x00000003001c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000004ff1f7424ULL, 0x000fe200078e00ffULL,
0x00000003681d7812ULL, 0x000fe200078ec0ffULL, 0x00000300ff1c7624ULL, 0x000fe400078e00ffULL,
0x0000000404207e24ULL, 0x000fe2000f8e0207ULL, 0x000000031d00780cULL, 0x000fe20003f25270ULL,
0xfffffffd1f037424ULL, 0x000fe200078e021cULL, 0xfffffffd1c677811ULL, 0x000fe200078e10ffULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000103037807ULL, 0x000fca0004800000ULL,
0x0000000168687824ULL, 0x000fca00078e0203ULL, 0x0000000368037812ULL, 0x000fc800078ec0ffULL,
0x000000030300780cULL, 0x000fc80003f25270ULL, 0x0000000167677807ULL, 0x000fca0004800000ULL,
0x0000000168037824ULL, 0x000fe200078e0267ULL, 0x000000604b1d7811ULL, 0x000fc800078e40ffULL,
0x000000000300720cULL, 0x000fe40003f26070ULL, 0x0000001d481c7217ULL, 0x000fca0007800000ULL,
0x000000011c1c7824ULL, 0x000fe200078e0a1dULL, 0x0000002020207810ULL, 0x000fca0007ffe0ffULL,
0x000000670c1e9210ULL, 0x000fe40007ffe068ULL, 0x000000201c217807ULL, 0x000fe20000000000ULL,
0x00000100ff227424ULL, 0x000fe400078e00ffULL, 0x000060001e1e9625ULL, 0x000fe200078e001fULL,
0x0000002106217217ULL, 0x000fc60007800000ULL, 0x000000015e1d7824ULL, 0x100fe200078e0220ULL,
0x000000061e049981ULL, 0x000362000c1e1900ULL, 0x000000015d257824ULL, 0x100fe200078e0220ULL,
0x00000004ff237819ULL, 0x000fe20000011605ULL, 0x000000015c277824ULL, 0x000fe400078e0220ULL,
0x00005e001d1c7625ULL, 0x000fc800078e0022ULL, 0x0000000121247824ULL, 0x000fe200078e0a06ULL,
0x000000101c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e00251e7625ULL, 0x002fc600078e0022ULL,
0x000000242300720cULL, 0x000fe20003f46070ULL, 0x000000015b257824ULL, 0x000fe200078e0220ULL,
0x000000101e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00005e0027207625ULL, 0x000fc800078e0022ULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001020207210ULL, 0x000fe20007f9e0ffULL,
0x00005e0025227625ULL, 0x000fe200078e0022ULL, 0x000000241100720cULL, 0x000fc60003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000241300720cULL, 0x080fe20003f66070ULL,
0x000000ffff217224ULL, 0x000fe200020e0621ULL, 0x000000241500720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000d101c46ULL,
0x0000001022227210ULL, 0x000fca0007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x000000001e647faeULL, 0x0003e8000c901c46ULL, 0x0000000020637faeULL, 0x0003e8000d901c46ULL,
0x0000000022627faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01061c00ff1e7984ULL, 0x000ea20000000800ULL, 0x000000ff0dff7812ULL, 0x000fe2000782c0ffULL,
0x800000005f1f7824ULL, 0x000fc600078e00ffULL, 0x00000001ff667807ULL, 0x000fca0000800000ULL,
0x80000000661c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000005f1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01061c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01008000611d7984ULL, 0x000e620000000800ULL, 0x00000001ff727424ULL, 0x000fc600078e00ffULL,
0x01028000611c7984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e207812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f54000ULL,
0x0000001d081e7209ULL, 0x000fe40007810000ULL, 0x00000002ff227819ULL, 0x000fc60000011605ULL,
0x8000001e081f7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x000000014900780cULL, 0x000fe40003f45270ULL,
0x0000ffff08217812ULL, 0x000fe200078e3cffULL, 0x0000001f001f7308ULL, 0x000e660000000800ULL,
0x0000002120ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff727807ULL, 0x000fc60001800000ULL,
0x0104801e6100a388ULL, 0x000fe80000000800ULL, 0x00001f221f087589ULL, 0x002e6400000e0000ULL,
0x8000001e1d203221ULL, 0x000fe20000010000ULL, 0x0000001f09097220ULL, 0x000fe20000410000ULL,
0x00001f4a1f1d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b20203820ULL, 0x000fc80000410000ULL,
0x0000002000173308ULL, 0x000ee20000000800ULL, 0x0000000840407220ULL, 0x082fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x000fe20000410000ULL, 0x0000001d42427220ULL, 0x084fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000001d1b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e001eULL,
0x0000001c171c3220ULL, 0x008fc80000410000ULL, 0x000000091c097221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x80000000661d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000661e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000000601c783bULL, 0x000e620000004200ULL,
0x00000002ff817819ULL, 0x000fc60000011605ULL, 0x000000005a44783bULL, 0x000ea80000004200ULL,
0x000000005924783bULL, 0x000ee80000004200ULL, 0x000000005820783bULL, 0x000f220000004200ULL,
0x00000018ff977819ULL, 0x002fe2000001141cULL, 0x000001001c737824ULL, 0x040fe200078e00ffULL,
0x000088801c717816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001141dULL, 0x000001001d747824ULL, 0x040fe200078e00ffULL,
0x000088801d9b7816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011473ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff917819ULL, 0x000fe4000001141eULL, 0x00000018ff807819ULL, 0x000fe2000001141fULL,
0x0000001c00987306ULL, 0x0003e20000200c00ULL, 0x000088801e967816ULL, 0x000fe400000000ffULL,
0x000088801f797816ULL, 0x000fe400000000ffULL, 0x00000018ff867819ULL, 0x004fc40000011445ULL,
0x0000888045837816ULL, 0x040fe200000000ffULL, 0x0000001d00997306ULL, 0x0005e20000200c00ULL,
0x000001001e1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff707819ULL, 0x008fe20000011424ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00008880247d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000073009a7306ULL, 0x0003e20000200c00ULL,
0x00000100451d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fc40000011425ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00957306ULL, 0x0005e20000200c00ULL,
0x000001001f737824ULL, 0x042fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00008880257a7816ULL, 0x000fe400000000ffULL,
0x00000018ff8b7819ULL, 0x000fe40000011444ULL, 0x0000001d008e7306ULL, 0x0003e20000200c00ULL,
0x00000100441c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x0000888044907816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e00927306ULL, 0x000fe20000200c00ULL,
0x00000100471d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x0000001c008f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff7e7819ULL, 0x000fe40000011447ULL, 0x0000888047847816ULL, 0x040fe200000000ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011426ULL,
0x0000001f00937306ULL, 0x000fe20000200c00ULL, 0x00000100461c7824ULL, 0x002fe200078e00ffULL,
0x0000888026757816ULL, 0x000fc400000000ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011446ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d00877306ULL, 0x000fe20000200c00ULL,
0x00008880468a7816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000018ff6d7819ULL, 0x000fe40000011427ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000001c00897306ULL, 0x0003e20000200c00ULL,
0x00000018ff6c7819ULL, 0x010fc40000011420ULL, 0x00000018ff6b7819ULL, 0x000fe40000011421ULL,
0x00000018ff6a7819ULL, 0x000fe40000011422ULL, 0x00000018ff697819ULL, 0x000fe20000011423ULL,
0x00000045008d7306ULL, 0x0005e20000200c00ULL, 0x00000100241c7824ULL, 0x042fe400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001141cULL,
0x00000100251c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000017ff45723eULL, 0x004fe200000000ffULL,
0x00000044008c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe4000001141cULL,
0x0000a800571c7811ULL, 0x000fe400078e20ffULL, 0x0000541045457816ULL, 0x000fc40000000045ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002400777306ULL, 0x0005e20000200c00ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000010026447824ULL, 0x042fe400078e00ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00001f8145817589ULL, 0x000e6400000e0000ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000002500787306ULL, 0x0007e20000200c00ULL,
0x00001f4a45827589ULL, 0x000f2200000e0000ULL, 0x0000888027247816ULL, 0x004fc400000000ffULL,
0x00000018ff267819ULL, 0x000fc80000011426ULL, 0x0000009b009b7306ULL, 0x000fe20000200c00ULL,
0x0000991072257816ULL, 0x008fe200000000ffULL, 0x000000ffff727224ULL, 0x000fe400078e0024ULL,
0x0000010027247824ULL, 0x000fe200078e00ffULL, 0x000000ff2500720cULL, 0x000fe20003f25270ULL,
0x0001000027277824ULL, 0x000fe400078e00ffULL, 0x00000074009c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff277819ULL, 0x000fca0000011427ULL,
0x0000009700977306ULL, 0x000ff00000200c00ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x000000811c1c9232ULL, 0x082fe20000000000ULL, 0x000054109b257816ULL, 0x004fe2000000009cULL,
0x000000811e1e9232ULL, 0x000fc40000000000ULL, 0x000000821d1d9232ULL, 0x090fe40000000000ULL,
0x000000821f1f9232ULL, 0x000fe20000000000ULL, 0x0000004400747306ULL, 0x0003f00000200c00ULL,
0x0000009600967306ULL, 0x000fe20000200c00ULL, 0x0000888020447816ULL, 0x002fce00000000ffULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007300947306ULL, 0x000e700000200c00ULL,
0x0000002400737306ULL, 0x0005f00000200c00ULL, 0x0000009100917306ULL, 0x000ee20000200c00ULL,
0x0000541071247816ULL, 0x004fe2000000009aULL, 0x000000ffff717224ULL, 0x000fe200078e0044ULL,
0x0000541079457816ULL, 0x002fe20000000094ULL, 0x0000010020447824ULL, 0x000fc400078e00ffULL,
0x0001000020207824ULL, 0x000fe400078e00ffULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000241c40723cULL, 0x000fe20000001840ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000010021947824ULL, 0x000fc800078e00ffULL,
0x0000004700857306ULL, 0x000fe20000200c00ULL, 0x0000541098247816ULL, 0x000fe40000000097ULL,
0x0000541099257816ULL, 0x000fe40000000076ULL, 0x0000888021977816ULL, 0x000fc600000000ffULL,
0x0000002600477306ULL, 0x0005e40000200c00ULL, 0x000000241c3c723cULL, 0x000fe2000000183cULL,
0x000000ffff797224ULL, 0x000fca00078e0097ULL, 0x0000004400767306ULL, 0x0009e20000200c00ULL,
0x0000a80056267811ULL, 0x004fce00078e20ffULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x0000541096447816ULL, 0x010fce0000000095ULL, 0x0000008300837306ULL, 0x000f220000200c00ULL,
0x000000441c38723cULL, 0x000fee0000001838ULL, 0x0000004600887306ULL, 0x000fe20000200c00ULL,
0x0000541092447816ULL, 0x008fe40000000091ULL, 0x0000541093457816ULL, 0x002fc40000000080ULL,
0x00000018ff807819ULL, 0x000fc60000011494ULL, 0x0000002700467306ULL, 0x0003e40000200c00ULL,
0x000000441c34723cULL, 0x000fec0000001834ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000000002624783bULL, 0x002e620000000200ULL, 0x0000541090447816ULL, 0x004fc4000000008fULL,
0x0000541083457816ULL, 0x010fc8000000008eULL, 0x0000008600867306ULL, 0x000ea60000200c00ULL,
0x000000441c30723cULL, 0x000fea0000001830ULL, 0x0000008400847306ULL, 0x000ee40000200c00ULL,
0x0001000021447824ULL, 0x000fcc00078e00ffULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108d217816ULL, 0x004fe40000000086ULL, 0x0000888022867816ULL, 0x000fca00000000ffULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000541084457816ULL, 0x008fce0000000087ULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x0000008124249232ULL, 0x082fe40000000000ULL,
0x0000008126269232ULL, 0x000fe40000000000ULL, 0x0000008225259232ULL, 0x080fe40000000000ULL,
0x0000008227279232ULL, 0x000fe20000000000ULL, 0x0000002000837306ULL, 0x0003f00000200c00ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054108c207816ULL, 0x002fce000000008bULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x000000201c2c723cULL, 0x000fee000000182cULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff217819ULL, 0x000fe40000011444ULL,
0x000054108a447816ULL, 0x004fc40000000089ULL, 0x0000541088207816ULL, 0x000fc6000000007fULL,
0x0000007b007b7306ULL, 0x000ea40000200c00ULL, 0x000000441c28723cULL, 0x000fec0000001828ULL,
0x0000002100847306ULL, 0x0007e20000200c00ULL, 0x0000010022457824ULL, 0x040fe400078e00ffULL,
0x0001000022227824ULL, 0x000fc400078e00ffULL, 0x000000ffff447224ULL, 0x000fc600078e0086ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541085217816ULL, 0x008fe4000000007eULL,
0x00000018ff227819ULL, 0x000fca0000011422ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x000000201c18723cULL, 0x000fee0000001818ULL, 0x000054107d1c7816ULL, 0x002fe2000000007cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107a1d7816ULL, 0x004fc4000000007bULL,
0x00008880231e7816ULL, 0x000fe400000000ffULL, 0x00000018ff1f7819ULL, 0x000fc60000011445ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000001c2440723cULL, 0x000fee0000001840ULL,
0x000000ffff1c7224ULL, 0x000fe200078e001eULL, 0x00005410781d7816ULL, 0x008fe2000000006fULL,
0x00000100231e7824ULL, 0x040fe200078e00ffULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x0000001c00457306ULL, 0x0005f00000200c00ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x00005410771c7816ULL, 0x004fc40000000070ULL,
0x00005410466f7816ULL, 0x002fca000000006dULL, 0x0000001c243c723cULL, 0x000fe2000000183cULL,
0x0000006c006c7306ULL, 0x000e6c0000200c00ULL, 0x00005410751c7816ULL, 0x000fe40000000074ULL,
0x00005410721d7816ULL, 0x000fe20000000073ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x00005410476e7816ULL, 0x008fca000000006eULL, 0x0000001c2438723cULL, 0x040fe20000001838ULL,
0x00005410836c7816ULL, 0x002fe2000000006cULL, 0x0000007100717306ULL, 0x000e6c0000200c00ULL,
0x0000006e2434723cULL, 0x000fe40000001834ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410846d7816ULL, 0x004fce000000006bULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541071767816ULL, 0x002fe20000000076ULL, 0x0000006c242c723cULL, 0x000fec000000182cULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000001f001f7306ULL, 0x000e620000200c00ULL,
0x0000541079777816ULL, 0x004fce0000000080ULL, 0x0000001e001e7306ULL, 0x000ea20000200c00ULL,
0x000000762430723cULL, 0x000fee0000001830ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x002fce000000001fULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541045457816ULL, 0x004fce000000001eULL, 0x00000022001d7306ULL, 0x000e620000200c00ULL,
0x000000442428723cULL, 0x000fee0000001828ULL, 0x00000023001c7306ULL, 0x000ea20000200c00ULL,
0x000054101d6a7816ULL, 0x002fe4000000006aULL, 0x000054101c6b7816ULL, 0x004fce0000000069ULL,
0x0000006a2424723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01065c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000804b197811ULL, 0x000fe200078e40ffULL,
0x0000000404217e24ULL, 0x020fe2000f8e0207ULL, 0x00000004ff1f7819ULL, 0x000fe20000011605ULL,
0x00000100ff1e7424ULL, 0x000fe200078e00ffULL, 0x0000001948187217ULL, 0x000fc40007800000ULL,
0x0000003f21237812ULL, 0x040fe400078ef812ULL, 0x0000003f21457812ULL, 0x040fe200078ef814ULL,
0x0000000118187824ULL, 0x000fe200078e0a19ULL, 0x0000003f21197812ULL, 0x040fe400078ef80fULL,
0x0000003f21217812ULL, 0x000fe400078ef816ULL, 0x00000020181b7807ULL, 0x000fe20000000000ULL,
0x00005e0019187625ULL, 0x000fc600078e001eULL, 0x0000001b061d7217ULL, 0x000fe20007800000ULL,
0x00005e00231a7625ULL, 0x000fe200078e001eULL, 0x0000001018187210ULL, 0x000fc60007f5e0ffULL,
0x000000011d207824ULL, 0x000fe200078e0a06ULL, 0x000000101a1a7210ULL, 0x000fe20007f9e0ffULL,
0x00005e00451c7625ULL, 0x000fc600078e001eULL, 0x000000201100720cULL, 0x000fe20003f66070ULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x000000101c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061bULL, 0x000000201f00720cULL, 0x000fe20003f46070ULL,
0x00005e00211e7625ULL, 0x000fe200078e001eULL, 0x000000201300720cULL, 0x000fc60003f86070ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x000000201500720cULL, 0x000fe40003fa6070ULL,
0x000000101e1e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000184f7faeULL, 0x0003e8000d101c46ULL,
0x000000001a4e7faeULL, 0x0003e8000d901c46ULL, 0x000000001c4d7faeULL, 0x0003e8000e101c46ULL,
0x000000001e4c7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff187984ULL, 0x002e620000000800ULL, 0x8000000066197824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x002fe20007844819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000661a7824ULL, 0x000fe400078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01065400ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000784481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000005320783bULL, 0x000e620000004200ULL, 0x00000002ff817819ULL, 0x000fc60000011605ULL,
0x000000005244783bULL, 0x000ea80000004200ULL, 0x000000005118783bULL, 0x000ee80000004200ULL,
0x00000000501c783bULL, 0x000f220000004200ULL, 0x00000018ff977819ULL, 0x002fe20000011420ULL,
0x0000010020727824ULL, 0x040fe200078e00ffULL, 0x0000888020717816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011421ULL,
0x0000010021737824ULL, 0x040fe200078e00ffULL, 0x00008880219b7816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff917819ULL, 0x000fe40000011422ULL,
0x00000018ff807819ULL, 0x000fe20000011423ULL, 0x0000002000987306ULL, 0x0003e20000200c00ULL,
0x0000888022967816ULL, 0x000fe400000000ffULL, 0x0000888023797816ULL, 0x000fe400000000ffULL,
0x00000018ff8b7819ULL, 0x004fc40000011444ULL, 0x0000888044907816ULL, 0x000fe200000000ffULL,
0x0000002100997306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x042fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x008fe20000011419ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00008880197a7816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000072009a7306ULL, 0x0003e20000200c00ULL, 0x0000010045217824ULL, 0x004fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00000018ff707819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000957306ULL, 0x0005e20000200c00ULL,
0x0000010023727824ULL, 0x042fe200078e00ffULL, 0x00008880187d7816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff727819ULL, 0x000fc40000011472ULL, 0x00000021008e7306ULL, 0x0003e20000200c00ULL,
0x0000010044207824ULL, 0x044fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011447ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200927306ULL, 0x000fe20000200c00ULL,
0x0000010047217824ULL, 0x002fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fc40000011444ULL,
0x0000888047847816ULL, 0x040fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff867819ULL, 0x000fe40000011445ULL, 0x00000018ff6e7819ULL, 0x000fe4000001141aULL,
0x0000888045837816ULL, 0x040fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x000088801a757816ULL, 0x000fe200000000ffULL, 0x0000002300937306ULL, 0x000fe20000200c00ULL,
0x0000010046207824ULL, 0x002fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc40000011446ULL,
0x00008880468a7816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002100877306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000018ff6d7819ULL, 0x000fe4000001141bULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000002000897306ULL, 0x0003e20000200c00ULL, 0x00000018ff6c7819ULL, 0x010fc4000001141cULL,
0x00000018ff6b7819ULL, 0x000fe4000001141dULL, 0x00000018ff6a7819ULL, 0x000fe4000001141eULL,
0x00000018ff697819ULL, 0x000fe2000001141fULL, 0x00000044008c7306ULL, 0x0005e20000200c00ULL,
0x0000010018207824ULL, 0x042fe400078e00ffULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011420ULL, 0x0000010019207824ULL, 0x040fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000017ff44723eULL, 0x004fe200000000ffULL, 0x0000009b009b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011420ULL, 0x0000a80054207811ULL, 0x000fe400078e20ffULL,
0x00000018ff197819ULL, 0x000fc60000011419ULL, 0x00000073009c7306ULL, 0x000e620000200c00ULL,
0x000000002020783bULL, 0x000fee0000000200ULL, 0x0000001900787306ULL, 0x0005f00000200c00ULL,
0x0000001800777306ULL, 0x0007e20000200c00ULL, 0x0000541044197816ULL, 0x004fe20000000044ULL,
0x000001001a447824ULL, 0x000fc400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe400078e00ffULL,
0x00001f8119817589ULL, 0x000ea200000e0000ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000009700977306ULL, 0x000f220000200c00ULL, 0x000001001b187824ULL, 0x008fe200078e00ffULL,
0x00001f4a19827589ULL, 0x0002e200000e0000ULL, 0x00000018ff1a7819ULL, 0x000fc6000001141aULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000007600767306ULL, 0x000f620000200c00ULL,
0x000054109b197816ULL, 0x002fce000000009cULL, 0x0000004400747306ULL, 0x0003e20000200c00ULL,
0x0000008120209232ULL, 0x004fce0000000000ULL, 0x0000009600967306ULL, 0x000fe20000200c00ULL,
0x000088801c447816ULL, 0x002fe200000000ffULL, 0x0000008122229232ULL, 0x000fe40000000000ULL,
0x0000008221219232ULL, 0x088fe40000000000ULL, 0x0000008223239232ULL, 0x000fe40000000000ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007200947306ULL, 0x0002b00000200c00ULL,
0x0000001800737306ULL, 0x0007e20000200c00ULL, 0x000088801b727816ULL, 0x042fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x0000541071187816ULL, 0x008fe2000000009aULL,
0x000000ffff717224ULL, 0x000fe400078e0044ULL, 0x000001001c447824ULL, 0x040fe400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000182040723cULL, 0x000fe20000001840ULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000004700857306ULL, 0x000fe20000200c00ULL,
0x0000541098187816ULL, 0x010fe40000000097ULL, 0x0000541099197816ULL, 0x020fe40000000076ULL,
0x000088801d977816ULL, 0x000fc600000000ffULL, 0x00000045008d7306ULL, 0x0005e40000200c00ULL,
0x00000018203c723cULL, 0x000fec000000183cULL, 0x0000001a00477306ULL, 0x0009e20000200c00ULL,
0x0000541079457816ULL, 0x004fe20000000094ULL, 0x000001001d947824ULL, 0x000fc400078e00ffULL,
0x000000ffff797224ULL, 0x000fc800078e0097ULL, 0x0000004400767306ULL, 0x0005e20000200c00ULL,
0x0000a800551a7811ULL, 0x010fce00078e20ffULL, 0x0000009000907306ULL, 0x000f220000200c00ULL,
0x0000541096447816ULL, 0x004fce0000000095ULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x000000442038723cULL, 0x000fee0000001838ULL, 0x0000004600887306ULL, 0x000fe20000200c00ULL,
0x0000541092447816ULL, 0x002fe40000000091ULL, 0x0000541093457816ULL, 0x008fc40000000080ULL,
0x00000018ff807819ULL, 0x000fc60000011494ULL, 0x0000001b00467306ULL, 0x0003e40000200c00ULL,
0x000000442034723cULL, 0x000fec0000001834ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000000001a18783bULL, 0x002e620000000200ULL, 0x0000541090447816ULL, 0x010fc4000000008fULL,
0x0000541083457816ULL, 0x004fc8000000008eULL, 0x0000008600867306ULL, 0x000ea60000200c00ULL,
0x000000442030723cULL, 0x000fea0000001830ULL, 0x0000008400847306ULL, 0x000ee40000200c00ULL,
0x000100001d447824ULL, 0x000fcc00078e00ffULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x000054108d1d7816ULL, 0x004fe40000000086ULL, 0x000088801e867816ULL, 0x000fca00000000ffULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000541084457816ULL, 0x008fce0000000087ULL,
0x0000001c00837306ULL, 0x0005e20000200c00ULL, 0x0000008118189232ULL, 0x082fe40000000000ULL,
0x000000811a1a9232ULL, 0x000fe40000000000ULL, 0x0000008219199232ULL, 0x080fe40000000000ULL,
0x000000821b1b9232ULL, 0x000fe20000000000ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000054108c1c7816ULL, 0x004fce000000008bULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000001c202c723cULL, 0x000fee000000182cULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe40000011444ULL, 0x00005410881c7816ULL, 0x010fc4000000007fULL,
0x000054108a447816ULL, 0x002fc60000000089ULL, 0x0000007a007a7306ULL, 0x000fe80000200c00ULL,
0x000000442028723cULL, 0x000fe80000001828ULL, 0x0000007b007b7306ULL, 0x000e660000200c00ULL,
0x000001001e457824ULL, 0x000fc400078e00ffULL, 0x000100001e1e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200078e0086ULL, 0x0000001d00847306ULL, 0x0007e40000200c00ULL,
0x00000018ff1e7819ULL, 0x000fcc000001141eULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410851d7816ULL, 0x008fce000000007eULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000001c2024723cULL, 0x000fee0000001824ULL, 0x000054107d1c7816ULL, 0x004fe2000000007cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107a1d7816ULL, 0x002fc4000000007bULL,
0x000088801f207816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc60000011445ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000001c1840723cULL, 0x000fee0000001840ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410781d7816ULL, 0x008fe2000000006fULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c00457306ULL, 0x0005f00000200c00ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x00005410771c7816ULL, 0x004fc40000000070ULL,
0x00005410466f7816ULL, 0x002fca000000006dULL, 0x0000001c183c723cULL, 0x000fe2000000183cULL,
0x0000006c006c7306ULL, 0x000e6c0000200c00ULL, 0x00005410751c7816ULL, 0x000fe40000000074ULL,
0x00005410721d7816ULL, 0x000fe20000000073ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x00005410476e7816ULL, 0x008fca000000006eULL, 0x0000001c1838723cULL, 0x040fe20000001838ULL,
0x00005410836c7816ULL, 0x002fe2000000006cULL, 0x0000007100717306ULL, 0x000e6c0000200c00ULL,
0x0000006e1834723cULL, 0x000fe40000001834ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410846d7816ULL, 0x004fce000000006bULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541071767816ULL, 0x002fe20000000076ULL, 0x0000006c182c723cULL, 0x000fec000000182cULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x0000541079777816ULL, 0x004fce0000000080ULL, 0x0000002000207306ULL, 0x000ea20000200c00ULL,
0x000000761830723cULL, 0x000fee0000001830ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x002fce0000000021ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541045457816ULL, 0x004fce0000000020ULL, 0x0000001e001d7306ULL, 0x000e620000200c00ULL,
0x000000441828723cULL, 0x000fee0000001828ULL, 0x0000001f001c7306ULL, 0x000ea20000200c00ULL,
0x000054101d6a7816ULL, 0x002fe4000000006aULL, 0x000054101c6b7816ULL, 0x004fce0000000069ULL,
0x0000006a1818723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000804b1d7811ULL, 0x000fe200078e40ffULL,
0x01062000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0dff7812ULL, 0x000fe4000784c0ffULL,
0x0000001d4800720cULL, 0x000fe40003f24070ULL, 0x00000001ff697807ULL, 0x000fd60005000000ULL,
0x00005b9000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x00000003001c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000168677824ULL, 0x000fe400078e0267ULL,
0x00000004ff1e7424ULL, 0x000fe400078e00ffULL, 0x00000300ff037624ULL, 0x000fe200078e00ffULL,
0x00000003671c7812ULL, 0x000fe200078ec0ffULL, 0x0000000404207e24ULL, 0x000fe4000f8e0207ULL,
0xfffffffd1e037424ULL, 0x000fe200078e0203ULL, 0x000000031c00780cULL, 0x000fe20003f25270ULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000103687807ULL, 0x000fca0004800000ULL,
0x0000000167037824ULL, 0x000fe200078e0268ULL, 0x000000a04b1d7811ULL, 0x000fc800078e40ffULL,
0x000000000300720cULL, 0x000fe40003f26070ULL, 0x0000001d481c7217ULL, 0x000fca0007800000ULL,
0x000000011c1c7824ULL, 0x000fe200078e0a1dULL, 0x0000002020207810ULL, 0x000fca0007ffe0ffULL,
0x00000001031f9824ULL, 0x000fe200078e020cULL, 0x000000201c217807ULL, 0x000fe20000000000ULL,
0x00000100ff227424ULL, 0x000fe400078e00ffULL, 0x000060001f1e9625ULL, 0x000fe200078e001eULL,
0x0000002106217217ULL, 0x000fc60007800000ULL, 0x000000015e1d7824ULL, 0x100fe200078e0220ULL,
0x000000061e049981ULL, 0x000362000c1e1900ULL, 0x000000015d257824ULL, 0x100fe200078e0220ULL,
0x00000004ff237819ULL, 0x000fe20000011605ULL, 0x000000015c277824ULL, 0x000fe400078e0220ULL,
0x00005e001d1c7625ULL, 0x000fc800078e0022ULL, 0x0000000121247824ULL, 0x000fe200078e0a06ULL,
0x000000101c1c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e00251e7625ULL, 0x002fc600078e0022ULL,
0x000000242300720cULL, 0x000fe20003f46070ULL, 0x000000015b257824ULL, 0x000fe200078e0220ULL,
0x000000101e1e7210ULL, 0x000fe20007f7e0ffULL, 0x00005e0027207625ULL, 0x000fc800078e0022ULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000001020207210ULL, 0x000fe20007f9e0ffULL,
0x00005e0025227625ULL, 0x000fe200078e0022ULL, 0x000000241100720cULL, 0x000fc60003f26070ULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000241300720cULL, 0x080fe20003f66070ULL,
0x000000ffff217224ULL, 0x000fe200020e0621ULL, 0x000000241500720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c657faeULL, 0x0003e2000d101c46ULL,
0x0000001022227210ULL, 0x000fca0007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x000000001e647faeULL, 0x0003e8000c901c46ULL, 0x0000000020637faeULL, 0x0003e8000d901c46ULL,
0x0000000022627faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1d7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01062c00ff1e7984ULL, 0x000ea20000000800ULL, 0x000000ff0dff7812ULL, 0x000fe2000782c0ffULL,
0x800000005f1f7824ULL, 0x000fc600078e00ffULL, 0x00000001ff697807ULL, 0x000fca0004800000ULL,
0x80000000691c7824ULL, 0x000fca00078e00ffULL, 0x800000001dff7812ULL, 0x002fe4000782481cULL,
0x800000001eff7812ULL, 0x004fe2000784481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000005f1e7824ULL, 0x000fe400078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01062c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000784481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01010000611d7984ULL, 0x000e620000000800ULL, 0x00000001ff717424ULL, 0x000fc600078e00ffULL,
0x01030000611c7984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f5d000ULL,
0x00000000001e7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1e207812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f54000ULL,
0x0000001d081e7209ULL, 0x000fe40007810000ULL, 0x00000002ff227819ULL, 0x000fc60000011605ULL,
0x8000001e081f7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x000000024900780cULL, 0x000fe40003f45270ULL,
0x0000ffff08217812ULL, 0x000fe200078e3cffULL, 0x0000001f001f7308ULL, 0x000e660000000800ULL,
0x0000002120ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff717807ULL, 0x000fc60001800000ULL,
0x0105001e6100a388ULL, 0x000fe80000000800ULL, 0x00001f221f087589ULL, 0x002e6400000e0000ULL,
0x8000001e1d203221ULL, 0x000fe20000010000ULL, 0x0000001f09097220ULL, 0x000fe20000410000ULL,
0x00001f4a1f1d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b20203820ULL, 0x000fc80000410000ULL,
0x0000002000173308ULL, 0x000ee20000000800ULL, 0x0000000840407220ULL, 0x082fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x000fe20000410000ULL, 0x0000001d42427220ULL, 0x084fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000001d1b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e001eULL,
0x0000001c171c3220ULL, 0x008fc80000410000ULL, 0x000000091c097221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x80000000691d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000782481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000691e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000782481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000006020783bULL, 0x000e620000004200ULL,
0x00000002ff837819ULL, 0x000fc60000011605ULL, 0x000000005a44783bULL, 0x000ea80000004200ULL,
0x000000005924783bULL, 0x000ee80000004200ULL, 0x00000000581c783bULL, 0x000f220000004200ULL,
0x00000018ff987819ULL, 0x002fe20000011420ULL, 0x0000010020737824ULL, 0x040fe200078e00ffULL,
0x00008880209a7816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011421ULL, 0x0000010021747824ULL, 0x040fe200078e00ffULL,
0x00008880219c7816ULL, 0x040fe200000000ffULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000009a009a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011473ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff927819ULL, 0x000fe40000011422ULL, 0x00000018ff817819ULL, 0x000fe20000011423ULL,
0x0000002000997306ULL, 0x0003e20000200c00ULL, 0x0000888022977816ULL, 0x000fe400000000ffULL,
0x00008880237a7816ULL, 0x000fe400000000ffULL, 0x00000018ff877819ULL, 0x004fc40000011445ULL,
0x0000888045827816ULL, 0x000fe200000000ffULL, 0x00000021009b7306ULL, 0x0005e20000200c00ULL,
0x0000010022207824ULL, 0x042fe200078e00ffULL, 0x00000018ff707819ULL, 0x008fe20000011425ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00008880257b7816ULL, 0x000fe400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000073009d7306ULL, 0x0003e20000200c00ULL,
0x0000010045217824ULL, 0x044fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0001000045457824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fc40000011444ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000967306ULL, 0x0005e20000200c00ULL,
0x0000010023737824ULL, 0x042fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011445ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011424ULL,
0x0000888044917816ULL, 0x040fe400000000ffULL, 0x00000021008f7306ULL, 0x0003e20000200c00ULL,
0x0000010044207824ULL, 0x044fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00008880247e7816ULL, 0x000fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200937306ULL, 0x000fe20000200c00ULL,
0x0000010047217824ULL, 0x002fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000907306ULL, 0x0003e20000200c00ULL, 0x00000018ff737819ULL, 0x000fc40000011473ULL,
0x00000018ff807819ULL, 0x000fe40000011446ULL, 0x00008880468b7816ULL, 0x040fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011426ULL, 0x0000002300947306ULL, 0x000fe20000200c00ULL,
0x0000010046207824ULL, 0x002fe200078e00ffULL, 0x0000888026767816ULL, 0x000fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011447ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000002100887306ULL, 0x000fe20000200c00ULL,
0x0000888047857816ULL, 0x040fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff6e7819ULL, 0x000fe40000011427ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x00000020008a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff6d7819ULL, 0x010fe4000001141cULL, 0x00000018ff6c7819ULL, 0x000fc4000001141dULL,
0x00000018ff6b7819ULL, 0x000fe4000001141eULL, 0x00000018ff6a7819ULL, 0x000fe2000001141fULL,
0x00000045008e7306ULL, 0x0005e20000200c00ULL, 0x0000010024207824ULL, 0x042fe400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011420ULL,
0x0000010025207824ULL, 0x040fe200078e00ffULL, 0x0000009c009c7306ULL, 0x000fe20000200c00ULL,
0x00000017ff45723eULL, 0x004fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff7c7819ULL, 0x000fe40000011420ULL,
0x0000b00057207811ULL, 0x000fe200078e20ffULL, 0x00000074009f7306ULL, 0x000e620000200c00ULL,
0x0000541045457816ULL, 0x000fc40000000045ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x000000002020783bULL, 0x000fe60000000200ULL, 0x0000002500777306ULL, 0x0005e20000200c00ULL,
0x00001f8345837589ULL, 0x000ee800000e0000ULL, 0x00001f4a45847589ULL, 0x000f2600000e0000ULL,
0x00000044008d7306ULL, 0x0003e20000200c00ULL, 0x0000991071257816ULL, 0x004fc400000000ffULL,
0x000088801c717816ULL, 0x000fe400000000ffULL, 0x000000ff2500720cULL, 0x000fe40003f25270ULL,
0x000054109c257816ULL, 0x002fe2000000009fULL, 0x0000002400797306ULL, 0x0003e20000200c00ULL,
0x0000010026447824ULL, 0x040fe400078e00ffULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000009800987306ULL, 0x000fe20000200c00ULL,
0x0000010027247824ULL, 0x002fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc80000011426ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000008320209232ULL, 0x088fe40000000000ULL, 0x0000008322229232ULL, 0x000fca0000000000ULL,
0x0000009700977306ULL, 0x000fe20000200c00ULL, 0x0000008421219232ULL, 0x090fe40000000000ULL,
0x0000008423239232ULL, 0x000fca0000000000ULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x0000007300957306ULL, 0x0002b00000200c00ULL, 0x0000004400757306ULL, 0x0007e20000200c00ULL,
0x0000888027737816ULL, 0x042fe200000000ffULL, 0x0001000027277824ULL, 0x000fca00078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000002400747306ULL, 0x0003e20000200c00ULL,
0x000001001c447824ULL, 0x008fe200078e00ffULL, 0x000054107a457816ULL, 0x004fe20000000095ULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x000001001d957824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000009200927306ULL, 0x000ea20000200c00ULL,
0x000054109a247816ULL, 0x002fc4000000009dULL, 0x00000018ff1c7819ULL, 0x000fca000001141cULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000000242040723cULL, 0x000fee0000001840ULL,
0x0000004600897306ULL, 0x000fe20000200c00ULL, 0x0000541099247816ULL, 0x000fe40000000098ULL,
0x000054109b257816ULL, 0x000fc40000000078ULL, 0x000088801d987816ULL, 0x000fc600000000ffULL,
0x0000002600467306ULL, 0x0007e40000200c00ULL, 0x00000024203c723cULL, 0x000fe2000000183cULL,
0x000000ffff7a7224ULL, 0x000fca00078e0098ULL, 0x0000004400787306ULL, 0x0009e20000200c00ULL,
0x0000b00056267811ULL, 0x008fce00078e20ffULL, 0x0000009100917306ULL, 0x000ee20000200c00ULL,
0x0000541097447816ULL, 0x010fce0000000096ULL, 0x0000008200827306ULL, 0x000f220000200c00ULL,
0x000000442038723cULL, 0x000fee0000001838ULL, 0x0000004700867306ULL, 0x000fe20000200c00ULL,
0x0000541093447816ULL, 0x004fe40000000092ULL, 0x0000541094457816ULL, 0x002fc40000000081ULL,
0x00000018ff817819ULL, 0x000fc60000011495ULL, 0x0000002700477306ULL, 0x0003e40000200c00ULL,
0x000000442034723cULL, 0x000fec0000001834ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x000000002624783bULL, 0x002e620000000200ULL, 0x0000541091447816ULL, 0x008fc40000000090ULL,
0x0000541082457816ULL, 0x010fc8000000008fULL, 0x0000008700877306ULL, 0x000ea60000200c00ULL,
0x000000442030723cULL, 0x000fea0000001830ULL, 0x0000008500857306ULL, 0x000ee40000200c00ULL,
0x000100001d447824ULL, 0x000fcc00078e00ffULL, 0x0000008000807306ULL, 0x000f220000200c00ULL,
0x000054108e1d7816ULL, 0x004fe40000000087ULL, 0x000088801e877816ULL, 0x000fca00000000ffULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541085457816ULL, 0x008fce0000000088ULL,
0x0000001c00827306ULL, 0x0005e20000200c00ULL, 0x0000008324249232ULL, 0x082fe40000000000ULL,
0x0000008326269232ULL, 0x000fe40000000000ULL, 0x0000008425259232ULL, 0x080fe40000000000ULL,
0x0000008427279232ULL, 0x000fe20000000000ULL, 0x0000008b008b7306ULL, 0x000e620000200c00ULL,
0x000054108d1c7816ULL, 0x004fce000000008cULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x0000001c202c723cULL, 0x000fee000000182cULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe40000011444ULL, 0x00005410891c7816ULL, 0x010fc40000000080ULL,
0x000054108b447816ULL, 0x002fc6000000008aULL, 0x0000007b007b7306ULL, 0x000fe80000200c00ULL,
0x000000442028723cULL, 0x000fe80000001828ULL, 0x0000007c007c7306ULL, 0x000e660000200c00ULL,
0x000001001e457824ULL, 0x000fc400078e00ffULL, 0x000100001e1e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200078e0087ULL, 0x0000001d00857306ULL, 0x0007e40000200c00ULL,
0x00000018ff1e7819ULL, 0x000fcc000001141eULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00005410861d7816ULL, 0x008fce000000007fULL, 0x0000001c2018723cULL, 0x000fe20000001818ULL,
0x0000007000707306ULL, 0x000eec0000200c00ULL, 0x000054107e1c7816ULL, 0x004fe4000000007dULL,
0x000054107b1d7816ULL, 0x002fe2000000007cULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x000088801f207816ULL, 0x000fc400000000ffULL, 0x00000018ff217819ULL, 0x000fc60000011445ULL,
0x0000001c2440723cULL, 0x000fe40000001840ULL, 0x0000006e006e7306ULL, 0x000eaa0000200c00ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410771d7816ULL, 0x008fe20000000070ULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000541046467816ULL, 0x002fc4000000006fULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x0000541047477816ULL, 0x004fce000000006eULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541082827816ULL, 0x008fe2000000006dULL,
0x000000462434723cULL, 0x000fec0000001834ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541085837816ULL, 0x002fce000000006cULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x00000082242c723cULL, 0x000fee000000182cULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000541071787816ULL, 0x002fce0000000078ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000002100217306ULL, 0x000e700000200c00ULL,
0x0000001c00457306ULL, 0x0007f00000200c00ULL, 0x0000002000207306ULL, 0x000f220000200c00ULL,
0x00005410791c7816ULL, 0x008fc40000000072ULL, 0x000054107a797816ULL, 0x004fe40000000081ULL,
0x0000541044447816ULL, 0x002fc60000000021ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000001c243c723cULL, 0x040fee000000183cULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00005410761c7816ULL, 0x000fe20000000075ULL, 0x000000782430723cULL, 0x000fe20000001830ULL,
0x00005410731d7816ULL, 0x000fc40000000074ULL, 0x0000541045457816ULL, 0x010fc60000000020ULL,
0x0000001e001e7306ULL, 0x000e640000200c00ULL, 0x0000001c2438723cULL, 0x040fec0000001838ULL,
0x0000001f001f7306ULL, 0x000ea40000200c00ULL, 0x000000442428723cULL, 0x000fe20000001828ULL,
0x000054101e1e7816ULL, 0x002fc4000000006bULL, 0x000054101f1f7816ULL, 0x004fce000000006aULL,
0x0000001e2424723cULL, 0x000fe20000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01065c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000c04b197811ULL, 0x000fe200078e40ffULL,
0x0000000404217e24ULL, 0x020fe2000f8e0207ULL, 0x00000004ff1f7819ULL, 0x000fe20000011605ULL,
0x00000100ff1e7424ULL, 0x000fe200078e00ffULL, 0x0000001948187217ULL, 0x000fc40007800000ULL,
0x0000003f21237812ULL, 0x040fe400078ef812ULL, 0x0000003f21457812ULL, 0x040fe200078ef814ULL,
0x0000000118187824ULL, 0x000fe200078e0a19ULL, 0x0000003f21197812ULL, 0x040fe400078ef80fULL,
0x0000003f21217812ULL, 0x000fe400078ef816ULL, 0x00000020181b7807ULL, 0x000fe20000000000ULL,
0x00005e0019187625ULL, 0x000fc600078e001eULL, 0x0000001b061d7217ULL, 0x000fe20007800000ULL,
0x00005e00231a7625ULL, 0x000fe200078e001eULL, 0x0000001018187210ULL, 0x000fc60007f5e0ffULL,
0x000000011d207824ULL, 0x000fe200078e0a06ULL, 0x000000101a1a7210ULL, 0x000fe20007f9e0ffULL,
0x00005e00451c7625ULL, 0x000fc600078e001eULL, 0x000000201100720cULL, 0x000fe20003f66070ULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x000000101c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e061bULL, 0x000000201f00720cULL, 0x000fe20003f46070ULL,
0x00005e00211e7625ULL, 0x000fe200078e001eULL, 0x000000201300720cULL, 0x000fc60003f86070ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061dULL, 0x000000201500720cULL, 0x000fe40003fa6070ULL,
0x000000101e1e7210ULL, 0x000fca0007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e061fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000184f7faeULL, 0x0003e8000d101c46ULL,
0x000000001a4e7faeULL, 0x0003e8000d901c46ULL, 0x000000001c4d7faeULL, 0x0003e8000e101c46ULL,
0x000000001e4c7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff187984ULL, 0x002e620000000800ULL, 0x8000000069197824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x002fe20007844819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007844819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x80000000691a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01065400ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000784481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000005320783bULL, 0x000e620000004200ULL, 0x00000002ff817819ULL, 0x000fc60000011605ULL,
0x000000005244783bULL, 0x000ea80000004200ULL, 0x000000005118783bULL, 0x000ee80000004200ULL,
0x00000000501c783bULL, 0x000f220000004200ULL, 0x00000018ff977819ULL, 0x002fe20000011420ULL,
0x0000010020727824ULL, 0x040fe200078e00ffULL, 0x0000888020717816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011421ULL,
0x0000010021737824ULL, 0x040fe200078e00ffULL, 0x00008880219b7816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff917819ULL, 0x000fe40000011422ULL,
0x00000018ff807819ULL, 0x000fe20000011423ULL, 0x0000002000987306ULL, 0x0003e20000200c00ULL,
0x0000888022967816ULL, 0x000fe400000000ffULL, 0x0000888023797816ULL, 0x000fe400000000ffULL,
0x00000018ff8b7819ULL, 0x004fc40000011444ULL, 0x0000888044907816ULL, 0x000fe200000000ffULL,
0x0000002100997306ULL, 0x0005e20000200c00ULL, 0x0000010022207824ULL, 0x042fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x008fe20000011419ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00008880197a7816ULL, 0x000fe400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000072009a7306ULL, 0x0003e20000200c00ULL, 0x0000010045217824ULL, 0x004fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00000018ff707819ULL, 0x000fe40000011418ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000957306ULL, 0x0005e20000200c00ULL,
0x0000010023727824ULL, 0x042fe200078e00ffULL, 0x00008880187d7816ULL, 0x000fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff727819ULL, 0x000fc40000011472ULL, 0x00000021008e7306ULL, 0x0003e20000200c00ULL,
0x0000010044207824ULL, 0x044fe200078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe40000011447ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002200927306ULL, 0x000fe20000200c00ULL,
0x0000010047217824ULL, 0x002fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fc40000011444ULL,
0x0000888047847816ULL, 0x040fe200000000ffULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000020008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff867819ULL, 0x000fe40000011445ULL, 0x00000018ff6e7819ULL, 0x000fe4000001141aULL,
0x0000888045837816ULL, 0x040fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x000088801a757816ULL, 0x000fe200000000ffULL, 0x0000002300937306ULL, 0x000fe20000200c00ULL,
0x0000010046207824ULL, 0x002fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc40000011446ULL,
0x00008880468a7816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000002100877306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000018ff6d7819ULL, 0x000fe4000001141bULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000002000897306ULL, 0x0003e20000200c00ULL, 0x00000018ff6c7819ULL, 0x010fc4000001141cULL,
0x00000018ff6b7819ULL, 0x000fe4000001141dULL, 0x00000018ff6a7819ULL, 0x000fe4000001141eULL,
0x00000018ff697819ULL, 0x000fe2000001141fULL, 0x00000044008c7306ULL, 0x0005e20000200c00ULL,
0x0000010018207824ULL, 0x042fe400078e00ffULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe20000011420ULL, 0x0000010019207824ULL, 0x040fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000017ff44723eULL, 0x004fe200000000ffULL, 0x0000009b009b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011420ULL, 0x0000b00054207811ULL, 0x000fe400078e20ffULL,
0x00000018ff197819ULL, 0x000fc60000011419ULL, 0x00000073009c7306ULL, 0x000e620000200c00ULL,
0x000000002020783bULL, 0x000fee0000000200ULL, 0x0000001900787306ULL, 0x0005f00000200c00ULL,
0x0000001800777306ULL, 0x0007e20000200c00ULL, 0x0000541044197816ULL, 0x004fe20000000044ULL,
0x000001001a447824ULL, 0x000fc400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe400078e00ffULL,
0x00001f8119817589ULL, 0x000ea200000e0000ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0000009700977306ULL, 0x000f220000200c00ULL, 0x000001001b187824ULL, 0x008fe200078e00ffULL,
0x00001f4a19827589ULL, 0x0002e200000e0000ULL, 0x00000018ff1a7819ULL, 0x000fc6000001141aULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000007600767306ULL, 0x000f620000200c00ULL,
0x000054109b197816ULL, 0x002fce000000009cULL, 0x0000004400747306ULL, 0x0003e20000200c00ULL,
0x0000008120209232ULL, 0x004fce0000000000ULL, 0x0000009600967306ULL, 0x000fe20000200c00ULL,
0x000088801c447816ULL, 0x002fe200000000ffULL, 0x0000008122229232ULL, 0x000fe40000000000ULL,
0x0000008221219232ULL, 0x088fe40000000000ULL, 0x0000008223239232ULL, 0x000fe40000000000ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007200947306ULL, 0x0002b00000200c00ULL,
0x0000001800737306ULL, 0x0007e20000200c00ULL, 0x000088801b727816ULL, 0x042fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x0000541071187816ULL, 0x008fe2000000009aULL,
0x000000ffff717224ULL, 0x000fe400078e0044ULL, 0x000001001c447824ULL, 0x040fe400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x000000182040723cULL, 0x000fe20000001840ULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000004700857306ULL, 0x000fe20000200c00ULL,
0x0000541098187816ULL, 0x010fe40000000097ULL, 0x0000541099197816ULL, 0x020fe40000000076ULL,
0x000088801d977816ULL, 0x000fc600000000ffULL, 0x00000045008d7306ULL, 0x0005e40000200c00ULL,
0x00000018203c723cULL, 0x000fec000000183cULL, 0x0000001a00477306ULL, 0x0009e20000200c00ULL,
0x0000541079457816ULL, 0x004fe20000000094ULL, 0x000001001d947824ULL, 0x000fc400078e00ffULL,
0x000000ffff797224ULL, 0x000fc800078e0097ULL, 0x0000004400767306ULL, 0x0005e20000200c00ULL,
0x0000b000551a7811ULL, 0x010fce00078e20ffULL, 0x0000009000907306ULL, 0x000f220000200c00ULL,
0x0000541096447816ULL, 0x004fce0000000095ULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x000000442038723cULL, 0x000fee0000001838ULL, 0x0000004600887306ULL, 0x000fe20000200c00ULL,
0x0000541092447816ULL, 0x002fe40000000091ULL, 0x0000541093457816ULL, 0x008fc40000000080ULL,
0x00000018ff807819ULL, 0x000fc60000011494ULL, 0x0000001b00467306ULL, 0x0003e40000200c00ULL,
0x000000442034723cULL, 0x000fec0000001834ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000000001a18783bULL, 0x002e620000000200ULL, 0x0000541090447816ULL, 0x010fc4000000008fULL,
0x0000541083457816ULL, 0x004fc8000000008eULL, 0x0000008600867306ULL, 0x000ea60000200c00ULL,
0x000000442030723cULL, 0x000fea0000001830ULL, 0x0000008400847306ULL, 0x000ee40000200c00ULL,
0x000100001d447824ULL, 0x000fcc00078e00ffULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x000054108d1d7816ULL, 0x004fe40000000086ULL, 0x000088801e867816ULL, 0x000fca00000000ffULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000541084457816ULL, 0x008fce0000000087ULL,
0x0000001c00837306ULL, 0x0005e20000200c00ULL, 0x0000008118189232ULL, 0x082fe40000000000ULL,
0x000000811a1a9232ULL, 0x000fe40000000000ULL, 0x0000008219199232ULL, 0x080fe40000000000ULL,
0x000000821b1b9232ULL, 0x000fe20000000000ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000054108c1c7816ULL, 0x004fce000000008bULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000001c202c723cULL, 0x000fee000000182cULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe40000011444ULL, 0x00005410881c7816ULL, 0x010fc4000000007fULL,
0x000054108a447816ULL, 0x002fc60000000089ULL, 0x0000007a007a7306ULL, 0x000fe80000200c00ULL,
0x000000442028723cULL, 0x000fe80000001828ULL, 0x0000007b007b7306ULL, 0x000e660000200c00ULL,
0x000001001e457824ULL, 0x000fc400078e00ffULL, 0x000100001e1e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff447224ULL, 0x000fe200078e0086ULL, 0x0000001d00847306ULL, 0x0007e40000200c00ULL,
0x00000018ff1e7819ULL, 0x000fcc000001141eULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410851d7816ULL, 0x008fce000000007eULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000001c2024723cULL, 0x000fee0000001824ULL, 0x000054107d1c7816ULL, 0x004fe2000000007cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107a1d7816ULL, 0x002fc4000000007bULL,
0x000088801f207816ULL, 0x000fe400000000ffULL, 0x00000018ff217819ULL, 0x000fc60000011445ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000001c1840723cULL, 0x000fee0000001840ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0020ULL, 0x00005410781d7816ULL, 0x008fe2000000006fULL,
0x000001001f207824ULL, 0x040fe200078e00ffULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c00457306ULL, 0x0005f00000200c00ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x00005410771c7816ULL, 0x004fc40000000070ULL,
0x00005410466f7816ULL, 0x002fca000000006dULL, 0x0000001c183c723cULL, 0x000fe2000000183cULL,
0x0000006c006c7306ULL, 0x000e6c0000200c00ULL, 0x00005410751c7816ULL, 0x000fe40000000074ULL,
0x00005410721d7816ULL, 0x000fe20000000073ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x00005410476e7816ULL, 0x008fca000000006eULL, 0x0000001c1838723cULL, 0x040fe20000001838ULL,
0x00005410836c7816ULL, 0x002fe2000000006cULL, 0x0000007100717306ULL, 0x000e6c0000200c00ULL,
0x0000006e1834723cULL, 0x000fe40000001834ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00005410846d7816ULL, 0x004fce000000006bULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541071767816ULL, 0x002fe20000000076ULL, 0x0000006c182c723cULL, 0x000fec000000182cULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x0000541079777816ULL, 0x004fce0000000080ULL, 0x0000002000207306ULL, 0x000ea20000200c00ULL,
0x000000761830723cULL, 0x000fee0000001830ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x002fce0000000021ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541045457816ULL, 0x004fce0000000020ULL, 0x0000001e001d7306ULL, 0x000e620000200c00ULL,
0x000000441828723cULL, 0x000fee0000001828ULL, 0x0000001f001c7306ULL, 0x000ea20000200c00ULL,
0x000054101d6a7816ULL, 0x002fe4000000006aULL, 0x000054101c6b7816ULL, 0x004fce0000000069ULL,
0x0000006a1818723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c04b1d7811ULL, 0x000fe200078e40ffULL,
0x01063000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff0dff7812ULL, 0x000fe4000784c0ffULL,
0x0000001d4800720cULL, 0x000fe40003f24070ULL, 0x00000001ff697807ULL, 0x000fd60001000000ULL,
0x00002d9000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x00000003001c7305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x0000001c0000735dULL, 0x004fe40003800000ULL, 0x01065c00ff1c7984ULL, 0x000e640000000800ULL,
0x800000001cff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000167687824ULL, 0x000fe400078e0268ULL,
0x00000004ff1e7424ULL, 0x000fe400078e00ffULL, 0x00000300ff037624ULL, 0x000fe200078e00ffULL,
0x00000003681c7812ULL, 0x000fe200078ec0ffULL, 0x0000000404207e24ULL, 0x000fe4000f8e0207ULL,
0xfffffffd1e037424ULL, 0x000fe200078e0203ULL, 0x000000031c00780cULL, 0x000fe20003f25270ULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x0000000103037807ULL, 0x000fca0004800000ULL,
0x0000000168037824ULL, 0x000fe200078e0203ULL, 0x000000e04b1d7811ULL, 0x000fc800078e40ffULL,
0x000000000300720cULL, 0x000fe40003f26070ULL, 0x0000001d481c7217ULL, 0x000fe40007800000ULL,
0x0000002020207810ULL, 0x000fc60007ffe0ffULL, 0x000000011c1c7824ULL, 0x000fe400078e0a1dULL,
0x00000100ff227424ULL, 0x000fc800078e00ffULL, 0x00000001031f9824ULL, 0x000fe200078e020cULL,
0x000000201c217807ULL, 0x000fe20000000000ULL, 0x000000015e1d7824ULL, 0x000fe400078e0220ULL,
0x000060001f1e9625ULL, 0x000fe200078e001eULL, 0x0000002106217217ULL, 0x000fc60007800000ULL,
0x000000015d5d7824ULL, 0x000fe200078e0220ULL, 0x000000061e049981ULL, 0x000362000c1e1900ULL,
0x00005e001d1c7625ULL, 0x000fe200078e0022ULL, 0x00000004ff237819ULL, 0x000fc60000011605ULL,
0x0000000121247824ULL, 0x000fe200078e0a06ULL, 0x000000101c1c7210ULL, 0x000fe20007f1e0ffULL,
0x000000015c217824ULL, 0x100fe400078e0220ULL, 0x000000015b5b7824ULL, 0x000fe200078e0220ULL,
0x000000241100720cULL, 0x000fe20003f26070ULL, 0x00005e005d1e7625ULL, 0x002fe200078e0022ULL,
0x000000241500720cULL, 0x000fc60003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x000000101e1e7210ULL, 0x000fe20007f5e0ffULL, 0x00005e0021207625ULL, 0x000fe200078e0022ULL,
0x000000242300720cULL, 0x000fc60003f06070ULL, 0x00005e005b227625ULL, 0x000fe200078e0022ULL,
0x0000001020207210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000241300720cULL, 0x000fe20003f46070ULL, 0x000000ffff217224ULL, 0x000fe200020e0621ULL,
0x0000001022227210ULL, 0x000fc60007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c657faeULL, 0x0003e4000c101c46ULL, 0x000000ffff237224ULL, 0x000fe400028e0623ULL,
0x000000001e647faeULL, 0x0003e8000c901c46ULL, 0x0000000020637faeULL, 0x0003e8000d101c46ULL,
0x0000000022627faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff1c7984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01063c00ff1d7984ULL, 0x000ea20000000800ULL, 0x80000000661f7824ULL, 0x000fc400078e00ffULL,
0x800000005f1e7824ULL, 0x000fc600078e00ffULL, 0x800000001cff7812ULL, 0x002fe4000780481fULL,
0x800000001dff7812ULL, 0x004fe2000782481eULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000005f1e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01063c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fc4000782481eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01018000611d7984ULL, 0x000e620000000800ULL, 0x00000001ff637424ULL, 0x000fc600078e00ffULL,
0x01038000611c7984ULL, 0x0004e20000000800ULL, 0x000000081d00720bULL, 0x002fda0003f3d000ULL,
0x00000000001e7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1e1f7812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x000000081d00720bULL, 0x00cfe40003f34000ULL,
0x0000001d08227209ULL, 0x000fe40007810000ULL, 0x00000002ff217819ULL, 0x000fc60000011605ULL,
0x80000022081e7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400008e0100ULL, 0x000000034900780cULL, 0x000fe40003f25270ULL,
0x0000ffff08207812ULL, 0x000fe200078e3cffULL, 0x0000001e001e7308ULL, 0x000e660000000800ULL,
0x000000201fff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff637807ULL, 0x000fc60001000000ULL,
0x0105802261009388ULL, 0x000fe80000000800ULL, 0x00001f211e087589ULL, 0x002e6400000e0000ULL,
0x800000221d1f2221ULL, 0x000fe20000010000ULL, 0x0000001e09097220ULL, 0x000fe20000410000ULL,
0x00001f4a1e1d7589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b1f1f2820ULL, 0x000fc80000410000ULL,
0x0000001f00172308ULL, 0x000ee20000000800ULL, 0x0000000840407220ULL, 0x082fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000838387220ULL, 0x080fe20000410000ULL,
0x0000000839397220ULL, 0x080fe20000410000ULL, 0x0000000834347220ULL, 0x080fe20000410000ULL,
0x0000000835357220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x000000082c2c7220ULL, 0x080fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000828287220ULL, 0x080fe20000410000ULL,
0x0000000829297220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x000fe20000410000ULL, 0x0000001d42427220ULL, 0x084fe20000410000ULL,
0x0000001d43437220ULL, 0x080fe20000410000ULL, 0x0000001d3e3e7220ULL, 0x080fe20000410000ULL,
0x0000001d3f3f7220ULL, 0x080fe20000410000ULL, 0x0000001d3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001d3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001d36367220ULL, 0x080fe20000410000ULL,
0x0000001d37377220ULL, 0x080fe20000410000ULL, 0x0000001d32327220ULL, 0x080fe20000410000ULL,
0x0000001d33337220ULL, 0x080fe20000410000ULL, 0x0000001d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000001d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000001d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000001d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000001d1b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fe200078e0022ULL,
0x0000001c171c2220ULL, 0x008fc80000410000ULL, 0x000000091c097221ULL, 0x00cfe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x01064c00ff1c7984ULL, 0x000e620000000800ULL,
0x80000000661d7824ULL, 0x000fca00078e00ffULL, 0x800000001cff7812ULL, 0x002fe2000780481dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL, 0x80000000661e7824ULL, 0x000fe400078e00ffULL,
0x0000001c001d7305ULL, 0x0002a4000021f000ULL, 0x3fa000001c1c7823ULL, 0x002fe200000100ffULL,
0x0000001d0000735dULL, 0x004fe40003800000ULL, 0x01064c00ff1d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fc4000780481eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000000601c783bULL, 0x000e620000004200ULL,
0x00000002ff717819ULL, 0x000fc60000011605ULL, 0x000000005a20783bULL, 0x000ea80000004200ULL,
0x000000005924783bULL, 0x000ee80000004200ULL, 0x000000005844783bULL, 0x000f220000004200ULL,
0x00000018ff707819ULL, 0x002fe2000001141cULL, 0x000001001c607824ULL, 0x040fe200078e00ffULL,
0x000088801c877816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001141dULL, 0x000001001d617824ULL, 0x040fe200078e00ffULL,
0x000088801d897816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00000018ff607819ULL, 0x000fc40000011460ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff817819ULL, 0x000fe4000001141eULL, 0x00000018ff7f7819ULL, 0x000fe2000001141fULL,
0x0000001c008b7306ULL, 0x0003e20000200c00ULL, 0x000088801e837816ULL, 0x000fe400000000ffULL,
0x000088801f857816ULL, 0x000fe400000000ffULL, 0x00000018ff727819ULL, 0x004fc40000011421ULL,
0x00008880217b7816ULL, 0x000fe200000000ffULL, 0x0000001d008c7306ULL, 0x0005e20000200c00ULL,
0x000001001f1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011423ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888023737816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000060008a7306ULL, 0x0003e20000200c00ULL,
0x00000100201d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x00000018ff6d7819ULL, 0x000fe40000011422ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00887306ULL, 0x0005e20000200c00ULL, 0x000001001e607824ULL, 0x002fe200078e00ffULL,
0x0000888022767816ULL, 0x000fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x008fe40000011424ULL, 0x00000018ff607819ULL, 0x000fc40000011460ULL,
0x0000001d007e7306ULL, 0x0003e20000200c00ULL, 0x00000100211c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000888024677816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001e00847306ULL, 0x000fe20000200c00ULL, 0x00000100221d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc40000011425ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00807306ULL, 0x0003e20000200c00ULL, 0x00000018ff227819ULL, 0x000fe40000011422ULL,
0x0000888025697816ULL, 0x000fe400000000ffULL, 0x00008880207d7816ULL, 0x040fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011420ULL, 0x0000001d00777306ULL, 0x0005e20000200c00ULL,
0x00000100231c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011426ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000001f00827306ULL, 0x000fe20000200c00ULL, 0x00000100241d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff5d7819ULL, 0x000fc40000011427ULL, 0x00000018ff5a7819ULL, 0x010fe40000011444ULL,
0x00000018ff5b7819ULL, 0x000fe20000011445ULL, 0x0000001d006a7306ULL, 0x0005e20000200c00ULL,
0x00000100251c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011446ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011447ULL,
0x00000018ff6c7819ULL, 0x000fe4000001141cULL, 0x0000b800571c7811ULL, 0x000fe200078e20ffULL,
0x0000002100797306ULL, 0x0003e20000200c00ULL, 0x00000018ff257819ULL, 0x000fc80000011425ULL,
0x000000001c1c783bULL, 0x004fe60000000200ULL, 0x0000002300747306ULL, 0x0005e20000200c00ULL,
0x00000017ff21723eULL, 0x002fce00000000ffULL, 0x00000022007a7306ULL, 0x0003e20000200c00ULL,
0x0000541021237816ULL, 0x004fe40000000021ULL, 0x0000888027217816ULL, 0x000fc600000000ffULL,
0x00001f7123717589ULL, 0x000ea400000e0000ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000991063227816ULL, 0x002fe200000000ffULL, 0x00001f4a236e7589ULL, 0x0002e200000e0000ULL,
0x000000ffff637224ULL, 0x000fe400078e0021ULL, 0x000000ff2200720cULL, 0x000fe20003f05270ULL,
0x0000010027217824ULL, 0x040fe200078e00ffULL, 0x0000b80056227811ULL, 0x000fe200078e20ffULL,
0x0000006000867306ULL, 0x000fe20000200c00ULL, 0x0001000027277824ULL, 0x000fc400078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000010044237824ULL, 0x002fe400078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000008500857306ULL, 0x000e640000200c00ULL,
0x000000711c1c8232ULL, 0x004fcc0000000000ULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000000711e1e8232ULL, 0x000fe40000000000ULL, 0x0000006e1d1d8232ULL, 0x088fe40000000000ULL,
0x0000006e1f1f8232ULL, 0x000fc60000000000ULL, 0x0000007f007f7306ULL, 0x000ef00000200c00ULL,
0x0000002400657306ULL, 0x0009f00000200c00ULL, 0x0000002500687306ULL, 0x0003e20000200c00ULL,
0x0000888044247816ULL, 0x050fe200000000ffULL, 0x0001000044447824ULL, 0x000fcc00078e00ffULL,
0x0000002400567306ULL, 0x0009e20000200c00ULL, 0x0000541085257816ULL, 0x002fce0000000088ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541083247816ULL, 0x010fce0000000086ULL,
0x00000061008e7306ULL, 0x0003e20000200c00ULL, 0x000000241c38723cULL, 0x000fee0000001838ULL,
0x0000007d007d7306ULL, 0x000f220000200c00ULL, 0x0000541084247816ULL, 0x004fe40000000081ULL,
0x0000541082257816ULL, 0x008fc4000000007fULL, 0x0000888026617816ULL, 0x002fc600000000ffULL,
0x0000007b007b7306ULL, 0x000e640000200c00ULL, 0x000000241c34723cULL, 0x000fec0000001834ULL,
0x00000020007c7306ULL, 0x0005e20000200c00ULL, 0x000054107d247816ULL, 0x010fce000000007eULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000010026207824ULL, 0x044fe200078e00ffULL,
0x000054107b257816ULL, 0x002fe20000000080ULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x000000241c30723cULL, 0x000fec0000001830ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fce0000011444ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x0000002000627306ULL, 0x0005f00000200c00ULL,
0x0000002100647306ULL, 0x0007e20000200c00ULL, 0x0000541087207816ULL, 0x004fc4000000008aULL,
0x0000541079257816ULL, 0x002fe40000000072ULL, 0x0000888046727816ULL, 0x000fc600000000ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541089217816ULL, 0x008fce000000008eULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x000000201c40723cULL, 0x000fee0000001840ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000054108b207816ULL, 0x000fe40000000070ULL,
0x000054108c217816ULL, 0x000fc4000000006fULL, 0x0000888045707816ULL, 0x040fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe20000011423ULL, 0x0000006b006b7306ULL, 0x000fe40000200c00ULL,
0x000000201c3c723cULL, 0x000fe2000000183cULL, 0x000000002220783bULL, 0x000eaa0000000200ULL,
0x0000002600577306ULL, 0x0007f00000200c00ULL, 0x0000002700607306ULL, 0x0009e20000200c00ULL,
0x0000010045267824ULL, 0x008fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x0001000045277824ULL, 0x010fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011427ULL, 0x0000002400457306ULL, 0x0009e20000200c00ULL,
0x0000541073277816ULL, 0x002fce0000000078ULL, 0x00000026007f7306ULL, 0x0003e20000200c00ULL,
0x000054107c247816ULL, 0x010fe40000000075ULL, 0x00005410575c7816ULL, 0x008fe2000000005cULL,
0x0000007120208232ULL, 0x084fe40000000000ULL, 0x0000007122228232ULL, 0x000fe40000000000ULL,
0x000000241c2c723cULL, 0x000fe2000000182cULL, 0x0000541076267816ULL, 0x002fe20000000077ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x0000006e21218232ULL, 0x000fc40000000000ULL,
0x0000006e23238232ULL, 0x000fe40000000000ULL, 0x000054107a247816ULL, 0x000fe2000000006dULL,
0x000000261c28723cULL, 0x040fe20000001828ULL, 0x0000541074257816ULL, 0x000fe2000000006bULL,
0x0000005f005f7306ULL, 0x000eaa0000200c00ULL, 0x0000010046277824ULL, 0x040fe200078e00ffULL,
0x000000241c18723cULL, 0x000fe20000001818ULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x000000ffff267224ULL, 0x000fe200078e0072ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x00000100471d7824ULL, 0x040fe200078e00ffULL, 0x00008880471c7816ULL, 0x040fe200000000ffULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x00005410655e7816ULL, 0x002fe4000000005eULL, 0x00000018ff1e7819ULL, 0x000fe4000001141dULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00005410685f7816ULL, 0x004fe2000000005fULL,
0x0000002700277306ULL, 0x000e620000200c00ULL, 0x00005410605d7816ULL, 0x008fca000000005dULL,
0x0000005e203c723cULL, 0x040fe4000000183cULL, 0x0000001e001f7306ULL, 0x000fec0000200c00ULL,
0x0000005c2034723cULL, 0x000fe40000001834ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x0000541026267816ULL, 0x002fce0000000027ULL, 0x0000005b005b7306ULL, 0x000ff00000200c00ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00005410455a7816ULL, 0x004fce000000005aULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000006900697306ULL, 0x000ff00000200c00ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00005410676a7816ULL, 0x002fce000000006aULL, 0x0000006100617306ULL, 0x000e700000200c00ULL,
0x0000006300637306ULL, 0x000ee20000200c00ULL, 0x00005410696b7816ULL, 0x004fce000000006cULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541061627816ULL, 0x002fe20000000062ULL,
0x0000006a2040723cULL, 0x000fec0000001840ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541063637816ULL, 0x008fce0000000064ULL, 0x0000004400447306ULL, 0x000ee20000200c00ULL,
0x0000541056567816ULL, 0x004fe2000000006fULL, 0x000000622038723cULL, 0x000fec0000001838ULL,
0x0000001c001c7306ULL, 0x000ea20000200c00ULL, 0x0000541070577816ULL, 0x002fce000000007fULL,
0x00000046001d7306ULL, 0x000e620000200c00ULL, 0x00005410445b7816ULL, 0x008fe2000000005bULL,
0x000000562030723cULL, 0x040fec0000001830ULL, 0x00000047001e7306ULL, 0x000ee20000200c00ULL,
0x000054101c277816ULL, 0x004fe2000000001fULL, 0x0000005a202c723cULL, 0x000fe2000000182cULL,
0x000054101d587816ULL, 0x002fce0000000058ULL, 0x000000262028723cULL, 0x000fe20000001828ULL,
0x000054101e597816ULL, 0x008fce0000000059ULL, 0x000000582018723cULL, 0x000fe20000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff1c7984ULL, 0x000e640000000800ULL, 0x800000001cff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff1c7424ULL, 0x000fc800078e00ffULL, 0x0000001c001d7305ULL, 0x0002a4000021f000ULL,
0x3fa000001c1c7823ULL, 0x002fe200000100ffULL, 0x0000001d0000735dULL, 0x004fe40003800000ULL,
0x01065c00ff1d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000003004b1c7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000404237e24ULL, 0x020fe2000f8e0207ULL,
0x00000004ff217819ULL, 0x000fe20000011605ULL, 0x00000100ff227424ULL, 0x000fe200078e00ffULL,
0x000000011c1f7810ULL, 0x040fe20007ffe0ffULL, 0x000001001c1d7824ULL, 0x000fc600078e00ffULL,
0x000000021f00720cULL, 0x000fe40003f26070ULL, 0x0000001d481c7217ULL, 0x000fe40007800000ULL,
0x0000003f231f7812ULL, 0x000fc600078ef812ULL, 0x000000011c1c7824ULL, 0x000fe200078e0a1dULL,
0x0000003f231d7812ULL, 0x000fe200078ef80fULL, 0x00005e001f1e7625ULL, 0x000fc600078e0022ULL,
0x000000201c0f7807ULL, 0x000fe20000800000ULL, 0x00005e001d1c7625ULL, 0x000fe200078e0022ULL,
0x000000101e1e7210ULL, 0x080fe40007f7e0ffULL, 0x0000000f060f7217ULL, 0x000fe40007800000ULL,
0x000000101c1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1f7224ULL, 0x000fe400018e061fULL,
0x000000010f127824ULL, 0x000fe200078e0a06ULL, 0x0000003f230f7812ULL, 0x040fe200078ef814ULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000003f23237812ULL, 0x000fc400078ef816ULL,
0x000000122100720cULL, 0x000fe20003f46070ULL, 0x00005e000f207625ULL, 0x000fe200078e0022ULL,
0x000000121100720cULL, 0x080fe40003f26070ULL, 0x000000121300720cULL, 0x000fe20003f66070ULL,
0x00005e0023227625ULL, 0x000fe200078e0022ULL, 0x000000121500720cULL, 0x000fe40003f86070ULL,
0x0000001020127210ULL, 0x080fe40007fbe0ffULL, 0x0000001022107210ULL, 0x000fc60007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0621ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c4f7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff117224ULL, 0x000fc600030e0623ULL,
0x000000001e4e7faeULL, 0x0003e8000c901c46ULL, 0x00000000124d7faeULL, 0x0003e8000d901c46ULL,
0x00000000104c7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff0f7984ULL, 0x000ea20000000800ULL, 0x8000000066107824ULL, 0x002fca00078e00ffULL,
0x800000000fff7812ULL, 0x004fe20007824810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01065400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000066117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000000531c783bULL, 0x000e620000004200ULL, 0x00000002ff6b7819ULL, 0x000fc60000011605ULL,
0x000000005220783bULL, 0x000ea80000004200ULL, 0x000000005124783bULL, 0x000ee80000004200ULL,
0x000000005010783bULL, 0x000f220000004200ULL, 0x00000018ff627819ULL, 0x002fe2000001141cULL,
0x000001001c4c7824ULL, 0x040fe200078e00ffULL, 0x000088801c727816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001141dULL,
0x000001001d4d7824ULL, 0x040fe200078e00ffULL, 0x000088801d747816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff5a7819ULL, 0x004fc40000011420ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000888020647816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011421ULL, 0x0000001c00757306ULL, 0x0003e20000200c00ULL,
0x00000018ff537819ULL, 0x000fe40000011422ULL, 0x00000018ff587819ULL, 0x000fe40000011423ULL,
0x0000888021657816ULL, 0x000fc400000000ffULL, 0x0000888022607816ULL, 0x000fe200000000ffULL,
0x0000001d00767306ULL, 0x0005e20000200c00ULL, 0x000001001f1c7824ULL, 0x002fe200078e00ffULL,
0x00008880235e7816ULL, 0x000fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001141fULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801f6c7816ULL, 0x040fe200000000ffULL,
0x00000100201d7824ULL, 0x044fe200078e00ffULL, 0x0000001c00737306ULL, 0x0003e20000200c00ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000001d00677306ULL, 0x0005e20000200c00ULL,
0x00000100211c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000002000697306ULL, 0x0003e20000200c00ULL,
0x00000100221d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x000088801e667816ULL, 0x000fc400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00707306ULL, 0x0005e20000200c00ULL,
0x00000018ff227819ULL, 0x000fe40000011422ULL, 0x0000b80054207811ULL, 0x002fe400078e20ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001141eULL, 0x00000018ff467819ULL, 0x008fe20000011424ULL,
0x0000001d005f7306ULL, 0x0003e20000200c00ULL, 0x00000100231c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011425ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000888024577816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x00000100241d7824ULL, 0x042fe200078e00ffULL,
0x00000021006a7306ULL, 0x000fe20000200c00ULL, 0x0000888025567816ULL, 0x000fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011426ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff457819ULL, 0x000fe20000011427ULL,
0x0000002200687306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fc40000011424ULL,
0x00008880274e7816ULL, 0x000fe400000000ffULL, 0x00000018ff157819ULL, 0x010fe40000011410ULL,
0x00000018ff167819ULL, 0x000fe20000011411ULL, 0x00000023006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff0f7819ULL, 0x000fe40000011412ULL, 0x00000018ff147819ULL, 0x000fca0000011413ULL,
0x0000001d00527306ULL, 0x0005e20000200c00ULL, 0x000000002020783bULL, 0x002fee0000000200ULL,
0x0000001f00717306ULL, 0x0003e20000200c00ULL, 0x00000017ff1d723eULL, 0x004fce00000000ffULL,
0x0000001c00617306ULL, 0x0005e20000200c00ULL, 0x000054101d1f7816ULL, 0x002fe2000000001dULL,
0x00000100271d7824ULL, 0x000fc800078e00ffULL, 0x00001f6b1f6b7589ULL, 0x000e6200000e0000ULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000004c00777306ULL, 0x0007220000200c00ULL,
0x00000100251c7824ULL, 0x044fe200078e00ffULL, 0x00001f4a1f547589ULL, 0x00056200000e0000ULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000001001e4c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00008880104a7816ULL, 0x044fe200000000ffULL, 0x00000100101f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x0000004d00797306ULL, 0x000ea20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fc6000001141eULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006b20208232ULL, 0x002fc60000000000ULL,
0x0000001c00597306ULL, 0x0003e20000200c00ULL, 0x0000006b22228232ULL, 0x000fe40000000000ULL,
0x0000005421218232ULL, 0x0a0fe40000000000ULL, 0x0000005423238232ULL, 0x000fc60000000000ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x00000100261c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000006300637306ULL, 0x000e700000200c00ULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000004c006f7306ULL, 0x000bf00000200c00ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00008880264c7816ULL, 0x060fe200000000ffULL,
0x0001000026267824ULL, 0x000fcc00078e00ffULL, 0x0000001c004d7306ULL, 0x0009f00000200c00ULL,
0x0000001d004f7306ULL, 0x0005e20000200c00ULL, 0x00005410721c7816ULL, 0x010fce0000000077ULL,
0x0000005a005a7306ULL, 0x000f220000200c00ULL, 0x00005410741d7816ULL, 0x004fce0000000079ULL,
0x0000001e006e7306ULL, 0x0005e20000200c00ULL, 0x0000001c2040723cULL, 0x000fee0000001840ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00010000271e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fc40000011426ULL, 0x00005410751c7816ULL, 0x008fe40000000062ULL,
0x00005410761d7816ULL, 0x002fe20000000063ULL, 0x0000010011637824ULL, 0x000fe200078e00ffULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x000fe4000001141eULL,
0x0000b800551e7811ULL, 0x000fe400078e20ffULL, 0x0000001c203c723cULL, 0x000fe2000000183cULL,
0x00000018ff557819ULL, 0x000fc4000001141fULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x000000001e1c783bULL, 0x000ea20000000200ULL, 0x00005410695a7816ULL, 0x010fe4000000005aULL,
0x0000888011627816ULL, 0x040fe200000000ffULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x0000005300537306ULL, 0x000ee40000200c00ULL, 0x00000018ff117819ULL, 0x000fcc0000011411ULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x000054106a5b7816ULL, 0x002fce000000005bULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x0000541068687816ULL, 0x008fe20000000053ULL,
0x0000005a202c723cULL, 0x000fe2000000182cULL, 0x0000010012537824ULL, 0x000fca00078e00ffULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000054106d697816ULL, 0x010fe40000000058ULL,
0x00000018ff537819ULL, 0x000fca0000011453ULL, 0x0000006000607306ULL, 0x000f220000200c00ULL,
0x0000541064647816ULL, 0x002fe20000000067ULL, 0x000000682018723cULL, 0x000fe20000001818ULL,
0x0000006b1c1c8232ULL, 0x084fe40000000000ULL, 0x0000006b1e1e8232ULL, 0x000fe40000000000ULL,
0x000000541d1d8232ULL, 0x080fe20000000000ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x0000541065657816ULL, 0x008fe20000000070ULL, 0x000000541f1f8232ULL, 0x000fcc0000000000ULL,
0x0000002400517306ULL, 0x0005e20000200c00ULL, 0x0000541060607816ULL, 0x010fe2000000005fULL,
0x000000642030723cULL, 0x000fec0000001830ULL, 0x0000002500507306ULL, 0x0007e20000200c00ULL,
0x0000541066247816ULL, 0x004fe4000000006fULL, 0x000054105e617816ULL, 0x002fca0000000061ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000054106c257816ULL, 0x008fe20000000073ULL,
0x000000602028723cULL, 0x040fec0000001828ULL, 0x0000004c004c7306ULL, 0x000e640000200c00ULL,
0x000000242038723cULL, 0x000fec0000001838ULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x000054106e247816ULL, 0x000fc4000000005dULL, 0x0000541071257816ULL, 0x000fca000000005cULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x000054104c4c7816ULL, 0x002fe2000000004dULL,
0x000000242034723cULL, 0x000fec0000001834ULL, 0x0000005300217306ULL, 0x0003e20000200c00ULL,
0x0000888012247816ULL, 0x040fe200000000ffULL, 0x0000010013227824ULL, 0x040fe200078e00ffULL,
0x0000888013207816ULL, 0x040fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011463ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x000fc40000011412ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000541056537816ULL, 0x002fe40000000059ULL, 0x0000541051467816ULL, 0x004fe20000000046ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541050477816ULL, 0x008fce0000000047ULL,
0x0000001500157306ULL, 0x000fe20000200c00ULL, 0x000000461c3c723cULL, 0x000fee000000183cULL,
0x0000001600167306ULL, 0x000ff00000200c00ULL, 0x0000000f000f7306ULL, 0x000ff00000200c00ULL,
0x0000001400147306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000004e004e7306ULL, 0x000eb00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x0000541057527816ULL, 0x002fce0000000052ULL, 0x0000002600267306ULL, 0x000e620000200c00ULL,
0x000054104e4d7816ULL, 0x004fe2000000004fULL, 0x000000521c40723cULL, 0x040fec0000001840ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541027447816ULL, 0x008fe20000000044ULL,
0x0000004c1c38723cULL, 0x000fec0000001838ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000541026457816ULL, 0x002fce0000000045ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000441c34723cULL, 0x000fee0000001834ULL, 0x0000002500257306ULL, 0x000e700000200c00ULL,
0x0000001000107306ULL, 0x000eb00000200c00ULL, 0x0000001100117306ULL, 0x000ee20000200c00ULL,
0x0000541062257816ULL, 0x002fce0000000025ULL, 0x0000002400587306ULL, 0x0003220000200c00ULL,
0x0000541010107816ULL, 0x004fce0000000015ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x000054104a247816ULL, 0x002fe40000000055ULL, 0x0000541011117816ULL, 0x008fca0000000016ULL,
0x0000002200597306ULL, 0x000e620000200c00ULL, 0x0000541058587816ULL, 0x010fe20000000021ULL,
0x000000241c30723cULL, 0x040fec0000001830ULL, 0x0000001200127306ULL, 0x000ea40000200c00ULL,
0x000000101c2c723cULL, 0x000fec000000182cULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x0000541020597816ULL, 0x002fc40000000059ULL, 0x0000541012127816ULL, 0x004fca000000000fULL,
0x000000581c28723cULL, 0x000fe20000001828ULL, 0x0000541013137816ULL, 0x008fce0000000014ULL,
0x000000121c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01064000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff0dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff697807ULL, 0x000fe40004000000ULL,
0x000003004b4b7a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff0bff7812ULL, 0x000fe4000780c0ffULL,
0x000000024b00720cULL, 0x000fe40003f26070ULL, 0x00000001ff0b7807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff42c000007947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ea20000002500ULL, 0x000000ffff147224ULL, 0x000fe400078e001bULL,
0x000000ffff127224ULL, 0x002fe400078e001aULL, 0x000000ffff1f7224ULL, 0x000fe400078e0019ULL,
0x000000ffff107224ULL, 0x000fe400078e002dULL, 0x000000ffff1d7224ULL, 0x000fe200078e002cULL,
0x000000020500720cULL, 0x004fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000009007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0009ULL,
0x0000cce0002c7802ULL, 0x000fe40000000f00ULL, 0x000086b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x008fe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000900007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000009ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000077919ULL, 0x000e640000000000ULL, 0x00000002ff0b7819ULL, 0x002fe40000011607ULL,
0x0000000807077811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0b00047589ULL, 0x000e6800000e0000ULL, 0x00001f0700077589ULL, 0x000ea200000e0000ULL,
0x0000004004407220ULL, 0x042fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x000fe20000410000ULL,
0x0000004207427220ULL, 0x044fe20000410000ULL, 0x0000004307437220ULL, 0x040fe20000410000ULL,
0x0000003e073e7220ULL, 0x040fe20000410000ULL, 0x0000003f073f7220ULL, 0x040fe20000410000ULL,
0x0000003a073a7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x040fe20000410000ULL,
0x0000003607367220ULL, 0x040fe20000410000ULL, 0x0000003707377220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002b072b7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x000fe20000410000ULL,
0x0000000000137919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000213007812ULL, 0x002fc400078ec0ffULL, 0x00000002ff117819ULL, 0x000fe40000011613ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200037811ULL, 0x040fe400078ff8ffULL,
0x00000004000a7811ULL, 0x040fe400078ff8ffULL, 0x00000006000e7811ULL, 0x000fe400078ff8ffULL,
0x0000000813197811ULL, 0x000fc400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e7811ULL,
0x0000000703047812ULL, 0x100fe400078e7811ULL, 0x000000070a0c7812ULL, 0x100fe200078e7811ULL,
0x0000000811077824ULL, 0x000fe200078e0200ULL, 0x000000070e0f7812ULL, 0x000fe200078e7811ULL,
0x0000080049007824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x100fe200078e7819ULL,
0x00000008110b7824ULL, 0x040fe200078e0204ULL, 0x0000000702027812ULL, 0x100fe200078e7819ULL,
0x00000008110d7824ULL, 0x000fe200078e020cULL, 0x0000000703037812ULL, 0x000fe200078e7819ULL,
0x0000000811117824ULL, 0x000fe200078e020fULL, 0x000000070e0e7812ULL, 0x000fe200078e7819ULL,
0x0000000819177824ULL, 0x000fe200078e020aULL, 0x0000003c3d04723eULL, 0x000fe200000000ffULL,
0x00000008190f7824ULL, 0x000fe200078e0202ULL, 0x0000a00000027810ULL, 0x000fe20007ffe0ffULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0x0000003e3f0c723eULL, 0x000fe200000000ffULL,
0x0000000819157824ULL, 0x000fe200078e0203ULL, 0x000000404103723eULL, 0x000fe200000000ffULL,
0x0000000819197824ULL, 0x000fe200078e020eULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x00005410031a7816ULL, 0x000fe20000000004ULL,
0x000000100f137824ULL, 0x000fe200078e0202ULL, 0x00007632031b7816ULL, 0x000fe20000000004ULL,
0x000000100b0b7824ULL, 0x100fe200078e0202ULL, 0x000000303103723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000001d1004723eULL, 0x000fe200000000ffULL,
0x000000100d0f7824ULL, 0x000fc400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001019197824ULL, 0x000fe400078e0202ULL,
0x00000001070d7824ULL, 0x000fe200078e020aULL, 0x000000383907723eULL, 0x000fe200000000ffULL,
0x000000010a137824ULL, 0x040fe400078e0213ULL, 0x000000010a0e7824ULL, 0x040fe200078e020bULL,
0x0000001a0d007388ULL, 0x0003e20000000a00ULL, 0x000000010a157824ULL, 0x040fe200078e0215ULL,
0x00000042430b723eULL, 0x000fe200000000ffULL, 0x000000010a0f7824ULL, 0x000fc400078e020fULL,
0x000000010a117824ULL, 0x040fe400078e0211ULL, 0x000000010a177824ULL, 0x040fe400078e0217ULL,
0x000000010a197824ULL, 0x000fe200078e0219ULL, 0x00000034350a723eULL, 0x000fc800000000ffULL,
0x00005410071a7816ULL, 0x142fe4000000000aULL, 0x00007632071b7816ULL, 0x000fe4000000000aULL,
0x000000282907723eULL, 0x000fe400000000ffULL, 0x000000181f0a723eULL, 0x000fe200000000ffULL,
0x0000001a0e007388ULL, 0x0003e40000000a00ULL, 0x00005410031a7816ULL, 0x142fe40000000004ULL,
0x00007632031b7816ULL, 0x000fc40000000004ULL, 0x00005410070e7816ULL, 0x100fe4000000000aULL,
0x0000003a3b03723eULL, 0x000fe200000000ffULL, 0x0000001a0f007388ULL, 0x0003e20000000a00ULL,
0x000000363704723eULL, 0x000fe400000000ffULL, 0x00007632070f7816ULL, 0x002fe4000000000aULL,
0x000000323307723eULL, 0x000fe400000000ffULL, 0x0000002e2f0a723eULL, 0x000fe200000000ffULL,
0x0000000e11007388ULL, 0x0003e40000000a00ULL, 0x000054100b0e7816ULL, 0x002fc4000000000cULL,
0x000076320b0f7816ULL, 0x000fe4000000000cULL, 0x0000002a2b0b723eULL, 0x000fe200000000ffULL,
0x00000300ff2a7624ULL, 0x000fe200078e00ffULL, 0x00000012140c723eULL, 0x000fe200000000ffULL,
0x0000000e13007388ULL, 0x0003e60000000a00ULL, 0x000000012a00780cULL, 0x000fe40003f05270ULL,
0x00005410030e7816ULL, 0x002fc40000000004ULL, 0x00007632030f7816ULL, 0x000fca0000000004ULL,
0x0000000e15007388ULL, 0x0003e40000000a00ULL, 0x00005410070e7816ULL, 0x142fe4000000000aULL,
0x00007632070f7816ULL, 0x000fe4000000000aULL, 0x000054100b0a7816ULL, 0x140fe4000000000cULL,
0x000076320b0b7816ULL, 0x000fe2000000000cULL, 0x0000000e17007388ULL, 0x0003e80000000a00ULL,
0x0000000a19007388ULL, 0x0003e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cb000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000ea20000000000ULL,
0x000058002a037a24ULL, 0x000fe200078e02ffULL, 0x000000ff4900720cULL, 0x000fe20003f25270ULL,
0x00002000ff0d7424ULL, 0x000fe200078e00ffULL, 0x00000000000b7919ULL, 0x002e620000002700ULL,
0x0000660003077a24ULL, 0x000fc600078e02ffULL, 0x00000000000a7919ULL, 0x000e620000002600ULL,
0x00000010040e7824ULL, 0x044fe200078e0200ULL, 0x0000002004257810ULL, 0x040fe40007ffe0ffULL,
0x0000004004277810ULL, 0x040fe40007ffe0ffULL, 0x00a000000e107984ULL, 0x0004e20000000c00ULL,
0x0000006004297810ULL, 0x000fe20007ffe0ffULL, 0x000058000b0b7a24ULL, 0x002fe400078e020aULL,
0x00a200000e147984ULL, 0x0004620000000c00ULL, 0x00001fff070a7811ULL, 0x000fe200078e40ffULL,
0x000003000b037a24ULL, 0x000fc400078e02ffULL, 0x00a400000e187984ULL, 0x0005220000000c00ULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x0000000103057824ULL, 0x000fe400078e0205ULL,
0x00a600000e1c7984ULL, 0x0004620000000c00ULL, 0x000000ff4900720cULL, 0x000fe40000705670ULL,
0x000000050a0c7211ULL, 0x000fca00078f98ffULL, 0x00006c000c0c7625ULL, 0x000fcc00078e000dULL,
0x00000800490c7825ULL, 0x000fcc00078e000cULL, 0x0000001025247825ULL, 0x000fc800078e000cULL,
0x0000001027267825ULL, 0x000fc800078e000cULL, 0x0000001029287825ULL, 0x000fc800078e000cULL,
0x0000001004227825ULL, 0x000fe200078e000cULL, 0x01ffffff070c7812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000077919ULL, 0x00cea20000000000ULL,
0x00000080ff217424ULL, 0x000fe400078e00ffULL, 0x0000000105207824ULL, 0x040fe400078e020cULL,
0x00006c00050e7625ULL, 0x000fc800078e0021ULL, 0x00006c0020207625ULL, 0x000fc800078e0021ULL,
0x00000010070d7824ULL, 0x004fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011607ULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fc800078ec0ffULL,
0x0000000e070e7210ULL, 0x140fe40007b5e00dULL, 0x0000002007207210ULL, 0x000fe40007d9e00dULL,
0x0000000fff0f7210ULL, 0x000fe400017e64ffULL, 0x00000021ff217210ULL, 0x000fc600027ea4ffULL,
0x000000080e007986ULL, 0x0005e8000c101906ULL, 0x0000000920007986ULL, 0x0005e4000c101906ULL,
0x0000001022007986ULL, 0x00c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001424007986ULL, 0x0025e8000c101d06ULL, 0x0000001826007986ULL, 0x0105e8000c101d06ULL,
0x0000001c28007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff2a057810ULL, 0x000fc60007ffe0ffULL, 0x00006a000b087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000005080879a8ULL, 0x000ee400099ee1c6ULL, 0x000000050800720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000000000ULL,
0x00000007ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000284000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011604ULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x00000001030e7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x002fe200078e00ffULL, 0x0000000c080d7812ULL, 0x000fe400078ec0ffULL,
0x00000070050b7812ULL, 0x000fe200078ec0ffULL, 0x00006c0003087625ULL, 0x000fc800078e0007ULL,
0x00006c000e0e7625ULL, 0x000fe200078e0007ULL, 0x000000080d087210ULL, 0x000fc8000791e00bULL,
0x0000000e0d0e7210ULL, 0x000fe40007b5e00bULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000fff0f7210ULL, 0x000fc600017e64ffULL, 0x0000000608057981ULL, 0x000368000c1e1900ULL,
0x000000060e107981ULL, 0x004362000c1e1900ULL, 0x000000022a00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000203087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0007ULL, 0x000000080d087210ULL, 0x000fc8000791e00bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608127981ULL, 0x000362000c1e1900ULL,
0x000000042a00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000303087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0007ULL,
0x000000080d087210ULL, 0x000fc8000791e00bULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608147981ULL, 0x000362000c1e1900ULL, 0x000000042a00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000403087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0007ULL, 0x000000080d087210ULL, 0x000fc8000791e00bULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608167981ULL, 0x000362000c1e1900ULL,
0x000000062a00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000503087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0007ULL,
0x000000080d087210ULL, 0x000fc8000791e00bULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608187981ULL, 0x000362000c1e1900ULL, 0x000000062a00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082a00780cULL, 0x002fe40003f06070ULL,
0x0000000603087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0007ULL,
0x000000080d087210ULL, 0x000fe40007a3e00bULL, 0x00000007030e0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000e0e0625ULL, 0x000fe400078e0007ULL,
0x00000006081a7981ULL, 0x000366000c1e1900ULL, 0x0000000e0d0e0210ULL, 0x000fc80007c7e00bULL,
0x0000000fff0f0210ULL, 0x000fca0001fe84ffULL, 0x000000060e0e0981ULL, 0x000368000c1e1900ULL,
0x000000072a077810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff077819ULL, 0x000fc80000011607ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff1c7224ULL, 0x004fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x020fe400078e0005ULL,
0x000000081c0b7824ULL, 0x040fe200078e00ffULL, 0x000000011c1c7810ULL, 0x000fc80007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000000071c00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080b087810ULL, 0x040fe40007ffe0ffULL,
0x000000010b097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001e05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080f087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081e7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090b087810ULL, 0x042fe40007ffe0ffULL, 0x000000020b097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001005057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0f7819ULL, 0x000fe20000011604ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080f087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608107981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0b087810ULL, 0x042fe40007ffe0ffULL,
0x000000030b097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001205057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080f087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608127981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0b087810ULL, 0x042fe40007ffe0ffULL, 0x000000040b097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001405057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0f7819ULL, 0x000fe20000011604ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080f087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608147981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0b087810ULL, 0x042fe40007ffe0ffULL,
0x000000050b097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001605057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080f087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608167981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0b087810ULL, 0x042fe40007ffe0ffULL, 0x000000060b097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001805057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0f7819ULL, 0x000fe20000011604ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080f087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608187981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0b087810ULL, 0x042fe40007ffe0ffULL,
0x000000070b097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001a05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010040d7824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080f087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081a7981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0b087810ULL, 0x002fe40007ffe0ffULL, 0x0000000e05057209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010040b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0d0d7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080d087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x000ee40000000000ULL,
0x0000001004077824ULL, 0x008fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fc80000011604ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fca00078ec0ffULL,
0x0000000107087824ULL, 0x000fca00078e0208ULL, 0x0000000508007388ULL, 0x0203e40000000800ULL,
0x000000030a087211ULL, 0x002fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff097424ULL, 0x000fe200078e00ffULL, 0x000000070400780cULL, 0x000fe20003f04070ULL,
0x0000080049057824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x00000015ff077819ULL, 0x000fe20000011649ULL,
0x0000000000267805ULL, 0x004fe2000001ff00ULL, 0x0000000c0d107812ULL, 0x000fe200078ec0ffULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x00000005080e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000002004117810ULL, 0x040fe20007ffe0ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000103128824ULL, 0x000fe200078e020cULL, 0x0000004004157810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000006004197810ULL, 0x000fe20007ffe0ffULL,
0x00000001090f7824ULL, 0x000fe200008e0607ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff1c8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000100049097824ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000010b087824ULL, 0x000fe200078e0210ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00006c0012128625ULL, 0x000fc800078e0013ULL, 0x0000001011107825ULL, 0x100fe200078e000eULL,
0x0000000008087984ULL, 0x000e660000000800ULL, 0x0000001015147825ULL, 0x000fc800078e000eULL,
0x0000001019187825ULL, 0x000fc800078e000eULL, 0x00000010491f8824ULL, 0x000fe400078e0204ULL,
0x00006c00031c8625ULL, 0x000fc600078e001cULL, 0x000045801f1f8811ULL, 0x000fe200078e20ffULL,
0x0000001004177824ULL, 0x040fe400078e0209ULL, 0x00000010040e7825ULL, 0x000fc800078e000eULL,
0x0000001049218824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e177faeULL, 0x0005e2000b901c46ULL, 0x00000010041a8825ULL, 0x040fe400078e0012ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000418021218811ULL, 0x000fe200078e20ffULL,
0x00000010041c8825ULL, 0x000fe200078e001cULL, 0x0038000010177faeULL, 0x0007e6000b901c46ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0058000014177faeULL, 0x0009e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x00000000000e7805ULL, 0x004fc4000001ff00ULL,
0x0078000018177faeULL, 0x0005e8000b901c46ULL, 0x000000001a1f8faeULL, 0x000be2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x000000001c218faeULL, 0x0007e2000b901c46ULL,
0x0000000000147805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000167805ULL, 0x004fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x020fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000d6000009947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x002fe400078e00ffULL,
0x000000ffff3a7224ULL, 0x000fca00078e00ffULL, 0x000000013a2c7810ULL, 0x000fc80007ffe0ffULL,
0x000003002c007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x00000001033f7824ULL, 0x000fe200078e022cULL, 0x000000070400780cULL, 0x000fe20003f24070ULL,
0x00002000ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000012c327812ULL, 0x040fe200078ec0ffULL,
0x000008002c307824ULL, 0x000fe200078e00ffULL, 0x0000003f0a2e7211ULL, 0x000fe400078f98ffULL,
0x0000002004337810ULL, 0x000fe40007ffe0ffULL, 0x0000080030307812ULL, 0x000fe200078ec0ffULL,
0x00006c002e2e7625ULL, 0x000fe200078e002fULL, 0x0000004004357810ULL, 0x000fc40007ffe0ffULL,
0x00000060043d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109317824ULL, 0x000fe200078e0230ULL,
0x000000052e2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010c369824ULL, 0x000fe400078e023fULL,
0x00000080ff379424ULL, 0x000fe400078e00ffULL, 0x000000012f2f7824ULL, 0x000fe400000e0607ULL,
0x0000000249399824ULL, 0x140fe400078e0232ULL, 0x0000000249419824ULL, 0x000fc400078e0232ULL,
0x00000080ff389424ULL, 0x000fe400078e00ffULL, 0x00000010043b7824ULL, 0x000fe400078e0231ULL,
0x0000001033327825ULL, 0x000fc800078e002eULL, 0x0000001035347825ULL, 0x000fc800078e002eULL,
0x0000001004307825ULL, 0x000fc800078e002eULL, 0x000000103d2e7825ULL, 0x000fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000303b7faeULL, 0x0003e6000b901c46ULL,
0x00006c0036369625ULL, 0x000fe200078e0037ULL, 0x00380000323b7faeULL, 0x0003e6000b901c46ULL,
0x00000008393d9824ULL, 0x000fe200078e0204ULL, 0x00580000343b7faeULL, 0x0003e2000b901c46ULL,
0x00006c003f389625ULL, 0x000fc600078e0038ULL, 0x000045803d3d9811ULL, 0x000fe200078e20ffULL,
0x00000008413f9824ULL, 0x000fe200078e0204ULL, 0x007800002e3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001004369825ULL, 0x000fc600078e0036ULL, 0x000041803f3f9811ULL, 0x000fe200078e20ffULL,
0x0000001004389825ULL, 0x000fe200078e0038ULL, 0x00000000363d9faeULL, 0x0003e8000b901c46ULL,
0x00000000383f9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff337224ULL, 0x002fe200078e003aULL, 0x00000001ff307819ULL, 0x100fe20000011604ULL,
0x00000010042f7824ULL, 0x000fe200078e00ffULL, 0x00000002ff377819ULL, 0x000fe20000011604ULL,
0x00000080332e7824ULL, 0x000fe200078e00ffULL, 0x0000000c30307812ULL, 0x000fc400078ec0ffULL,
0x000000702f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000837357824ULL, 0x040fe200078e00ffULL,
0x000000802e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000837397824ULL, 0x040fe200078e00ffULL,
0x00000007373c7812ULL, 0x000fe400078ec0ffULL, 0x00000037ff3e7212ULL, 0x000fe200078e33ffULL,
0x00000100492e7824ULL, 0x000fc600078e022eULL, 0xfffffff8393e7812ULL, 0x000fe400078ee23eULL,
0x0000002e30307210ULL, 0x000fe20007ffe02fULL, 0x00000008372f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8352e7812ULL, 0x000fe200078ee23cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800030317984ULL, 0x000e620000000800ULL, 0x000000012f327812ULL, 0x140fe400078ef63cULL,
0x000000022f347812ULL, 0x140fe200078ef63cULL, 0x00458000304e7984ULL, 0x0004e20000000800ULL,
0x000000032f367812ULL, 0x140fe400078ef63cULL, 0x000000042f387812ULL, 0x140fe400078ef63cULL,
0x000000052f3a7812ULL, 0x140fe400078ef63cULL, 0x000000062f3c7812ULL, 0x000fe200078ef63cULL,
0x00000800332f7824ULL, 0x000fe200078e00ffULL, 0x0000000837397810ULL, 0x000fc80007ffe0ffULL,
0x000008002f307812ULL, 0x004fe200078ec0ffULL, 0x0000000839427824ULL, 0x040fe200078e00ffULL,
0x0000000739337812ULL, 0x040fe200078ec0ffULL, 0x0000000839407824ULL, 0x000fe200078e00ffULL,
0x00000180092f7810ULL, 0x000fe20007ffe030ULL, 0x00000008393b7824ULL, 0x000fe200078e00ffULL,
0xfffffff842307812ULL, 0x100fe400078ee233ULL, 0x0000000140427812ULL, 0x000fe200078ef633ULL,
0x000000102e2e7824ULL, 0x000fe200078e022fULL, 0x0000000240447812ULL, 0x000fe200078ef633ULL,
0x000000103e3e7824ULL, 0x000fe200078e022fULL, 0x0000000340467812ULL, 0x000fe200078ef633ULL,
0x0000001032327824ULL, 0x000fe200078e022fULL, 0x0000000440487812ULL, 0x000fe200078ef633ULL,
0x0000001034347824ULL, 0x100fe200078e022fULL, 0x00000039ff4c7212ULL, 0x000fe200078e33ffULL,
0x0000001036367824ULL, 0x000fe200078e022fULL, 0x00000005404a7812ULL, 0x000fe200078ef633ULL,
0x0000001038387824ULL, 0x100fe200078e022fULL, 0xfffffff83b4c7812ULL, 0x000fe200078ee24cULL,
0x000000103a3a7824ULL, 0x000fe200078e022fULL, 0x0000000640407812ULL, 0x000fe200078ef633ULL,
0x0000003108317221ULL, 0x002fe20000010100ULL, 0x000000103c3c7824ULL, 0x000fc400078e022fULL,
0x0000001030307824ULL, 0x100fe200078e022fULL, 0x3fb8aa3b31357820ULL, 0x000fe20000410000ULL,
0x0000000404317824ULL, 0x000fe400078e00ffULL, 0x0000001042427824ULL, 0x100fe400078e022fULL,
0x0000001044447824ULL, 0x100fe200078e022fULL, 0x0000000c31317812ULL, 0x000fe200078ec0ffULL,
0x0000003500357308ULL, 0x000ee20000000800ULL, 0x0000001046467824ULL, 0x100fe400078e022fULL,
0x0000001048487824ULL, 0x000fc400078e022fULL, 0x000000012e2e7824ULL, 0x000fe400078e0231ULL,
0x00000001313e7824ULL, 0x040fe400078e023eULL, 0x0000000131327824ULL, 0x040fe400078e0232ULL,
0x000000002e2e7984ULL, 0x000e620000000800ULL, 0x0000000131347824ULL, 0x040fe400078e0234ULL,
0x0000000131367824ULL, 0x040fe200078e0236ULL, 0x000000003e3e7984ULL, 0x000ea20000000800ULL,
0x0000000131387824ULL, 0x000fe200078e0238ULL, 0x0000004e354e7220ULL, 0x008fe20000410000ULL,
0x00000001313a7824ULL, 0x040fe200078e023aULL, 0x0000000032327984ULL, 0x000fe20000000800ULL,
0x00000001313c7824ULL, 0x040fe200078e023cULL, 0x0000002d4e2d7221ULL, 0x000fe20000010000ULL,
0x0000000131307824ULL, 0x040fe200078e0230ULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x0000000131427824ULL, 0x000fc400078e0242ULL, 0x0000000131447824ULL, 0x040fe200078e0244ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x0000000131467824ULL, 0x040fe400078e0246ULL,
0x0000000131487824ULL, 0x000fe200078e0248ULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x000000104a4a7824ULL, 0x100fe400078e022fULL, 0x000000104c4c7824ULL, 0x100fe200078e022fULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x0000001040407824ULL, 0x000fc400078e022fULL,
0x00000001314a7824ULL, 0x040fe200078e024aULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x00000001314c7824ULL, 0x040fe400078e024cULL, 0x0000000131407824ULL, 0x000fe200078e0240ULL,
0x0000000030307984ULL, 0x000fe80000000800ULL, 0x00001f374e337589ULL, 0x000ee800000e0000ULL,
0x0000000042427984ULL, 0x000f220000000800ULL, 0x2000002eff2f7230ULL, 0x002fc40000004100ULL,
0x3000002eff2e7230ULL, 0x000fe20000004100ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x2000003eff317230ULL, 0x104fe40000004100ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000000046467984ULL, 0x000fe80000000800ULL, 0x0000000048487984ULL, 0x000fe80000000800ULL,
0x000000004a4a7984ULL, 0x000fe80000000800ULL, 0x000000004c4c7984ULL, 0x000fe20000000800ULL,
0x000000332f267223ULL, 0x088fe20000010026ULL, 0x0000003331127223ULL, 0x080fe20000010012ULL,
0x20000032ff2f7230ULL, 0x000fe20000004100ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x20000034ff317230ULL, 0x000fe20000004100ULL, 0x000000332e257223ULL, 0x080fe20000010025ULL,
0x20000036ff2e7230ULL, 0x100fe20000004100ULL, 0x00001f394e4e7589ULL, 0x000e6200000e0000ULL,
0x000000332f247223ULL, 0x080fe20000010024ULL, 0x0000003331207223ULL, 0x080fe20000010020ULL,
0x30000036ff2f7230ULL, 0x000fe20000004100ULL, 0x000000332e1d7223ULL, 0x080fe2000001001dULL,
0x30000038ff317230ULL, 0x000fe20000004100ULL, 0x000000333e117223ULL, 0x080fe20000010011ULL,
0x2000003aff2e7230ULL, 0x100fe20000004100ULL, 0x000000332f1c7223ULL, 0x080fe2000001001cULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x00000033311a7223ULL, 0x080fe2000001001aULL,
0x2000003cff2f7230ULL, 0x000fe20000004100ULL, 0x000000332e177223ULL, 0x080fe20000010017ULL,
0x30000030ff317230ULL, 0x000fe20000004100ULL, 0x000000333a0f7223ULL, 0x080fe2000001000fULL,
0x000000ffff3a7224ULL, 0x000fe200078e002cULL, 0x000000332f0e7223ULL, 0x000fe2000001000eULL,
0x30000032ff327230ULL, 0x000fc40000004100ULL, 0x20000030ff2e7230ULL, 0x000fe20000004100ULL,
0x000003003a007a0cULL, 0x000fe20003f06070ULL, 0x30000042ff2f7230ULL, 0x010fe20000004100ULL,
0x0000003332237223ULL, 0x080fe20000010023ULL, 0x30000034ff347230ULL, 0x000fe20000004100ULL,
0x0000004e31227223ULL, 0x082fe20000010022ULL, 0x30000044ff317230ULL, 0x000fe20000004100ULL,
0x0000004e2e157223ULL, 0x080fe20000010015ULL, 0x20000038ff327230ULL, 0x000fe20000004100ULL,
0x0000004e2f2a7223ULL, 0x080fe2000001002aULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000004e311e7223ULL, 0x080fe2000001001eULL, 0x20000042ff2e7230ULL, 0x000fe20000004100ULL,
0x00000033341f7223ULL, 0x080fe2000001001fULL, 0x30000046ff2f7230ULL, 0x000fe20000004100ULL,
0x00000033321b7223ULL, 0x080fe2000001001bULL, 0x20000048ff317230ULL, 0x000fe20000004100ULL,
0x000000333c0d7223ULL, 0x000fe2000001000dULL, 0x0000004e2e2b7223ULL, 0x080fe2000001002bULL,
0x2000004aff337230ULL, 0x000fe20000004100ULL, 0x0000004e2f287223ULL, 0x080fe20000010028ULL,
0x0000004e31107223ULL, 0x000fe20000010010ULL, 0x2000004cff2c7230ULL, 0x000fc40000004100ULL,
0x20000044ff307230ULL, 0x000fe20000004100ULL, 0x0000004e33187223ULL, 0x080fe20000010018ULL,
0x20000046ff2e7230ULL, 0x000fe20000004100ULL, 0x0000004e2c137223ULL, 0x080fe20000010013ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000004e30217223ULL, 0x080fe20000010021ULL,
0x3000004aff4a7230ULL, 0x000fe20000004100ULL, 0x0000004e2e297223ULL, 0x080fe20000010029ULL,
0x20000040ff2f7230ULL, 0x100fe20000004100ULL, 0x0000004e48197223ULL, 0x080fe20000010019ULL,
0x30000040ff317230ULL, 0x000fe20000004100ULL, 0x0000004e4a277223ULL, 0x080fe20000010027ULL,
0x3000004cff4c7230ULL, 0x000fe20000004100ULL, 0x0000004e2f167223ULL, 0x000fc40000010016ULL,
0x0000004e31147223ULL, 0x080fe40000010014ULL, 0x0000004e4c0b7223ULL, 0x000fe2000001000bULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x018000002d037810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000f8f0002c7802ULL, 0x000fe40000000f00ULL,
0x00005aa000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc8000000002dULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff0c7819ULL, 0x002fe4000001160aULL,
0x000000080a2f7811ULL, 0x000fe400078ff0ffULL, 0x0000000cff077212ULL, 0x000fe200078e33ffULL,
0x00001f0c03047589ULL, 0x008e6200000e0000ULL, 0x000000080c2c7824ULL, 0x000fe200078e00ffULL,
0x0000002fff2d7212ULL, 0x000fe200078e33ffULL, 0x000000082f2e7824ULL, 0x000fe200078e00ffULL,
0x00001f2f03057589ULL, 0x000ea400000e0000ULL, 0xfffffff82c317812ULL, 0x000fc400078ee207ULL,
0x000000070c077812ULL, 0x000fe400078ec0ffULL, 0xfffffff82e2d7812ULL, 0x000fe400078ee22dULL,
0x0000000107097812ULL, 0x000fc600078e3cffULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x0000002604267220ULL, 0x042fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000000f04087220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x000fe20000410000ULL,
0x0000001305137220ULL, 0x044fe20000410000ULL, 0x0000000b05047220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x000fe20000410000ULL,
0x00000002070b7812ULL, 0x000fe200078e3cffULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001405037220ULL, 0x040fe20000410000ULL, 0x000000130404723eULL, 0x000fe200000000ffULL,
0x0000001505157220ULL, 0x000fe20000410000ULL, 0x00000003070f7812ULL, 0x000fe200078e3cffULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x000000170808723eULL, 0x000fe200000000ffULL,
0x0000002b052b7220ULL, 0x000fe20000410000ULL, 0x000000101910723eULL, 0x000fe200000000ffULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x0000000407137812ULL, 0x000fe200078e3cffULL,
0x0000002105217220ULL, 0x000fe20000410000ULL, 0x0000000507177812ULL, 0x000fe200078e3cffULL,
0x0000001e051e7220ULL, 0x000fe20000410000ULL, 0x0000000607197812ULL, 0x000fe200078e3cffULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x000000080c077824ULL, 0x040fe200078e0209ULL,
0x000000160303723eULL, 0x000fe200000000ffULL, 0x000000080c057824ULL, 0x040fe200078e00ffULL,
0x000000072f167812ULL, 0x040fe200078ec0ffULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x000000080c097824ULL, 0x040fe200078e020bULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x000000080c0b7824ULL, 0x040fe200078e020fULL,
0xfffffff805057812ULL, 0x000fe200078ee20cULL, 0x000000080c0f7824ULL, 0x000fe200078e0213ULL,
0x0000000416127812ULL, 0x000fe200078e3cffULL, 0x000000080c137824ULL, 0x000fe200078e0217ULL,
0x0000000516147812ULL, 0x000fe200078e3cffULL, 0x000000080c177824ULL, 0x000fe200078e0219ULL,
0xfffffff80e197812ULL, 0x000fe200078ee22fULL, 0x000000040a207824ULL, 0x000fe200078e00ffULL,
0x00000001160a7812ULL, 0x040fe200078e3cffULL, 0x0000001005057824ULL, 0x100fe200078e0202ULL,
0x00000002160c7812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x00000003160e7812ULL, 0x040fe200078e3cffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x0000000616167812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x000000082f1d7824ULL, 0x040fe200078e020cULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x000000082f1b7824ULL, 0x040fe200078e020aULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x000000082f2b7824ULL, 0x040fe200078e0216ULL,
0x000000211e1e723eULL, 0x000fe200000000ffULL, 0x000000082f217824ULL, 0x040fe200078e020eULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x000000082f297824ULL, 0x000fe200078e0214ULL,
0x000000182718723eULL, 0x000fe200000000ffULL, 0x000000082f277824ULL, 0x000fe200078e0212ULL,
0x0000000c20207812ULL, 0x000fe200078ec0ffULL, 0x00000010310c7824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x00000001200a7824ULL, 0x000fe200078e0205ULL,
0x000000152215723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x000fc400078e0202ULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x000000250a007388ULL, 0x0003e20000000800ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x000000101b1b7824ULL, 0x100fe400078e0202ULL,
0x000000101d1d7824ULL, 0x100fe400078e0202ULL, 0x0000001021217824ULL, 0x100fe400078e0202ULL,
0x0000001027277824ULL, 0x000fc400078e0202ULL, 0x0000001029297824ULL, 0x100fe400078e0202ULL,
0x000000102b2b7824ULL, 0x000fe400078e0202ULL, 0x0000000120127824ULL, 0x040fe400078e020cULL,
0x0000000120027824ULL, 0x040fe400078e0207ULL, 0x00000001200c7824ULL, 0x040fe400078e0209ULL,
0x00000001200b7824ULL, 0x040fe200078e020bULL, 0x0000002302007388ULL, 0x0005e20000000800ULL,
0x00000001200f7824ULL, 0x000fc400078e020fULL, 0x0000000120137824ULL, 0x040fe200078e0213ULL,
0x0000001f0c007388ULL, 0x0005e20000000800ULL, 0x00000001200e7824ULL, 0x040fe400078e0217ULL,
0x0000000120147824ULL, 0x040fe200078e0219ULL, 0x0000001c0b007388ULL, 0x0005e20000000800ULL,
0x00000001201b7824ULL, 0x040fe400078e021bULL, 0x00000001201d7824ULL, 0x040fe200078e021dULL,
0x0000001a0f007388ULL, 0x0005e20000000800ULL, 0x0000000120217824ULL, 0x000fc400078e0221ULL,
0x0000000120277824ULL, 0x040fe200078e0227ULL, 0x0000000813007388ULL, 0x0005e20000000800ULL,
0x0000000120297824ULL, 0x040fe400078e0229ULL, 0x00000001200a7824ULL, 0x042fe200078e022bULL,
0x0000000d0e007388ULL, 0x0005e20000000800ULL, 0x00000001202d7824ULL, 0x000fc600078e022dULL,
0x0000001112007388ULL, 0x0005e80000000800ULL, 0x0000001514007388ULL, 0x0005e80000000800ULL,
0x0000002a1b007388ULL, 0x0005e80000000800ULL, 0x0000001e1d007388ULL, 0x0005e80000000800ULL,
0x0000002821007388ULL, 0x0005e80000000800ULL, 0x0000001027007388ULL, 0x0005e80000000800ULL,
0x0000001829007388ULL, 0x0005e80000000800ULL, 0x000000030a007388ULL, 0x0005e80000000800ULL,
0x000000042d007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000001a7919ULL, 0x004ea20000002600ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000580000057ab9ULL, 0x000fc40000000800ULL, 0x00000000001b7919ULL, 0x000f220000000000ULL,
0x0000000405057899ULL, 0x000fe2000800063fULL, 0x000000101a037824ULL, 0x004fc600078e00ffULL,
0x00000004050472a4ULL, 0x008fe2000f8e023fULL, 0x000000101a187824ULL, 0x000fe200078e00ffULL,
0x00000003ff027819ULL, 0x010fe4000001161bULL, 0x000000201b1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000401b1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000601b1e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff003047812ULL, 0x000fc400078ee202ULL, 0x00000003ff037819ULL, 0x000fe4000001161cULL,
0x00000003ff077819ULL, 0x002fe4000001161dULL, 0x00000003ff197819ULL, 0x000fe4000001161eULL,
0x0000000702027812ULL, 0x000fe400078e481bULL, 0x0000000703057812ULL, 0x000fe400078e481cULL,
0x0000000707087812ULL, 0x000fc400078e481dULL, 0xfffffff018187812ULL, 0x000fe400078ee203ULL,
0x00000007190a7812ULL, 0x000fe400078e481eULL, 0x0ffffff802037812ULL, 0x000fe400078ef81bULL,
0x0ffffff805057812ULL, 0x000fe400078ef81cULL, 0x0ffffff808097812ULL, 0x000fe200078ef81dULL,
0x0000001003087824ULL, 0x000fe200078e0200ULL, 0x0ffffff80a0b7812ULL, 0x000fe200078ef81eULL,
0x0000001005057824ULL, 0x100fe200078e0200ULL, 0x0000000404037c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001009107824ULL, 0x000fc400078e0200ULL, 0x000000100b147824ULL, 0x000fe200078e0200ULL,
0x00a00000050c7984ULL, 0x0003e20000000c00ULL, 0x000000101a047824ULL, 0x040fe400078e00ffULL,
0x000000101a007824ULL, 0x000fe200078e00ffULL, 0x00a0000008087984ULL, 0x000ea20000000c00ULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe400078048ffULL,
0x00a0000010107984ULL, 0x000ee20000000c00ULL, 0xfffffff004047812ULL, 0x000fc400078ee219ULL,
0x000000071c057812ULL, 0x002fe200078ec0ffULL, 0x00a0000014147984ULL, 0x000e620000000c00ULL,
0x000000071d197812ULL, 0x000fe400078ec0ffULL, 0xfffffff000007812ULL, 0x000fe400078ee207ULL,
0x00005b0003037a11ULL, 0x000fe400000f4c1aULL, 0x1ffffff8051d7812ULL, 0x000fe400078ef806ULL,
0x0000000418057c10ULL, 0x000fc4000ff1e0ffULL, 0x1ffffff8191f7812ULL, 0x000fe400078ef806ULL,
0x0000000400197c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000404007c10ULL, 0x000fe4000ff5e0ffULL,
0x000000071b077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x000000071e1b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005a0019187a11ULL, 0x000fc400078248ffULL, 0x00005a00001a7a11ULL, 0x040fe400078448ffULL,
0x1ffffff807077812ULL, 0x000fe400078ef806ULL, 0x00005b0005057a11ULL, 0x000fe400000f4c1eULL,
0x1ffffff81b217812ULL, 0x000fe200078ef806ULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x00005b0019197a11ULL, 0x000fe400008f4c1cULL, 0x00005b00001b7a11ULL, 0x000fe200010f4c23ULL,
0x000000101d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x004fe6000c101d06ULL,
0x000000101f067825ULL, 0x000fe200078e0018ULL, 0x0000000c04007986ULL, 0x000fe6000c101d06ULL,
0x0000001021187825ULL, 0x000fe200078e001aULL, 0x0000001006007986ULL, 0x008fe8000c101d06ULL,
0x0000001418007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006800ff347624ULL, 0x000fe200078e00ffULL, 0x03ffffff49047812ULL, 0x000fe200078ec0ffULL,
0x00006900ff357624ULL, 0x000fc400078e00ffULL, 0xffffffffff317424ULL, 0x000fe400078e00ffULL,
0x000000044b337824ULL, 0x000fe200078e0204ULL, 0x0000000634347981ULL, 0x000368000c1e9900ULL,
0x000000003300720cULL, 0x000fe40003f06070ULL, 0x000000014b037810ULL, 0x000fd60007ffe0ffULL,
0x000000020a048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0233ULL,
0x0000600004048625ULL, 0x000fca00078e0019ULL, 0x0000000604318981ULL, 0x000362000c1e1900ULL,
0x000000020300720cULL, 0x000fe20003f06070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x0000004016167824ULL, 0x000fe400078e00ffULL, 0x0000004049307824ULL, 0x000fd200078e00ffULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x002e620000000000ULL,
0x00000004160b7e24ULL, 0x020fe2000f8e0231ULL, 0x0000200049157811ULL, 0x000fe200078e68ffULL,
0x00000100ff1b7424ULL, 0x000fe400078e00ffULL, 0x000001004b037824ULL, 0x000fca00078e0230ULL,
0x0000000348087217ULL, 0x000fca0007800000ULL, 0x0000000108037824ULL, 0x000fe200078e0a03ULL,
0x00000002ff1c7819ULL, 0x102fe20000011611ULL, 0x0000001011197824ULL, 0x000fe200078e00ffULL,
0x00000003ff147819ULL, 0x000fe40000011611ULL, 0x0000003f1c047812ULL, 0x040fe400078ec0ffULL,
0x000000081c127810ULL, 0x040fe40007ffe0ffULL, 0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b047824ULL, 0x000fe200078e0204ULL, 0x0000003f12067812ULL, 0x040fe200078ec0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x0000003f1e0c7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001bULL, 0x0000003019197812ULL, 0x000fc400078ec0ffULL,
0x000000181c207810ULL, 0x040fe20007ffe0ffULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x000000201c167810ULL, 0x000fe20007ffe0ffULL, 0x000000010b097824ULL, 0x040fe200078e020cULL,
0x00000019040c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0006067625ULL, 0x000fe200078e001bULL,
0x0000003f20047812ULL, 0x000fe400078ec0ffULL, 0x0000000314147812ULL, 0x000fe200078e4811ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0605ULL, 0x00000019060e7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b047824ULL, 0x000fe200078e0204ULL, 0x0000003f16067812ULL, 0x000fe200078ec0ffULL,
0x00005e0009087625ULL, 0x000fe200078e001bULL, 0x000000281c187810ULL, 0x000fc40007ffe0ffULL,
0x000000031e00720cULL, 0x000fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e001bULL,
0x0000001908087210ULL, 0x000fe40007f3e0ffULL, 0x000000032000720cULL, 0x000fe20003f86070ULL,
0x000000010b067824ULL, 0x000fe200078e0206ULL, 0x0000001904107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0ffffffc14047812ULL, 0x000fe200078ef811ULL,
0x00005e0006067625ULL, 0x000fe200078e001bULL, 0x000000031c00720cULL, 0x000fc60003f06070ULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000031200720cULL, 0x000fe20003f26070ULL,
0x0000001004177824ULL, 0x000fe200078e0215ULL, 0x0000001906127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0605ULL, 0x0000003f18047812ULL, 0x000fe400078ec0ffULL,
0xfffffffc13067812ULL, 0x000fe200078ee214ULL, 0x000000ffff137224ULL, 0x000fe200018e0607ULL,
0x000000031600720cULL, 0x000fe20003f66070ULL, 0x000000010b047824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c177faeULL, 0x0003e2000c101c46ULL,
0x0000001006077824ULL, 0x000fe200078e0215ULL, 0x000000301c067810ULL, 0x000fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001bULL, 0x000000381c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000003f061a7812ULL, 0x000fe200078ec0ffULL, 0x000000000e077faeULL, 0x0005e2000c901c46ULL,
0x000000031800720cULL, 0x080fe20003f46070ULL, 0x00000004061d7824ULL, 0x040fe200078e00ffULL,
0x000000030600720cULL, 0x000fe20003f26070ULL, 0x000000041c1f7824ULL, 0x000fe200078e00ffULL,
0x00000019040c7210ULL, 0x002fe20007fde0ffULL, 0x000000010b047824ULL, 0x000fe200078e021aULL,
0x000000031c00720cULL, 0x000fe20003f06070ULL, 0x000000041e037824ULL, 0x000fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000003f1c0e7812ULL, 0x004fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001bULL, 0xfffffffc1d1c7812ULL, 0x000fc600078ee214ULL,
0x000000010b077824ULL, 0x000fe200078e020eULL, 0x0000001904047210ULL, 0x000fe20007fde0ffULL,
0x00000004200b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc030e7812ULL, 0x100fe200078ee214ULL,
0x00000004160f7824ULL, 0x000fe400078e00ffULL, 0x0000000418177824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b167812ULL, 0x100fe200078ee214ULL, 0x00005e0007067625ULL, 0x000fe200078e001bULL,
0xfffffffc0f187812ULL, 0x100fe400078ee214ULL, 0xfffffffc171a7812ULL, 0x100fe200078ee214ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0xfffffffc1f147812ULL, 0x000fe200078ee214ULL,
0x000000100e037824ULL, 0x100fe200078e0215ULL, 0x0000001906067210ULL, 0x000fe20007fde0ffULL,
0x00000010160b7824ULL, 0x000fc400078e0215ULL, 0x00000010180f7824ULL, 0x100fe200078e0215ULL,
0x0000000008037faeULL, 0x0003e2000e901c46ULL, 0x000000101a177824ULL, 0x100fe400078e0215ULL,
0x000000101c197824ULL, 0x100fe200078e0215ULL, 0x00000000100b7faeULL, 0x0003e2000e101c46ULL,
0x0000001014157824ULL, 0x000fe400078e0215ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x00000000120f7faeULL, 0x0003e8000d901c46ULL, 0x000000000c177faeULL, 0x0003e8000d101c46ULL,
0x0000000004197faeULL, 0x0003e8000c901c46ULL, 0x0000000006157faeULL, 0x0003e2000c101c46ULL,
0x000005a000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000416167e24ULL, 0x020fe2000f8e0231ULL, 0x00002000490c7811ULL, 0x000fe200078e68ffULL,
0x00000100ff147424ULL, 0x000fe200078e00ffULL, 0x00000002ff047819ULL, 0x002fc40000011603ULL,
0x00000003ff067819ULL, 0x000fe40000011603ULL, 0x00000010040b7810ULL, 0x040fe40007ffe0ffULL,
0x00000018040e7810ULL, 0x040fe40007ffe0ffULL, 0x0000002004107810ULL, 0x040fe40007ffe0ffULL,
0x0000000804087810ULL, 0x000fe40007ffe0ffULL, 0x0000003f0b0d7812ULL, 0x000fe200078ec0ffULL,
0x00000004101f7824ULL, 0x000fe200078e00ffULL, 0x0000003f0e117812ULL, 0x000fc400078ec0ffULL,
0x0000003f10157812ULL, 0x000fe200078ec0ffULL, 0x00000001160f7824ULL, 0x000fe200078e020dULL,
0x0000002804127810ULL, 0x000fe20007ffe0ffULL, 0x0000000116137824ULL, 0x000fe200078e0211ULL,
0x0000003004187810ULL, 0x000fe20007ffe0ffULL, 0x00000001161d7824ULL, 0x000fe200078e0215ULL,
0x00000038041a7810ULL, 0x000fe20007ffe0ffULL, 0x00000004080d7824ULL, 0x000fe200078e00ffULL,
0x0000003f04057812ULL, 0x000fe200078ec0ffULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x0000003f08077812ULL, 0x000fe200078ec0ffULL, 0x000000040b117824ULL, 0x000fe200078e00ffULL,
0x0000000306067812ULL, 0x000fe200078e4803ULL, 0x000000040e157824ULL, 0x000fe200078e00ffULL,
0x0000003f12177812ULL, 0x040fe200078ec0ffULL, 0x0000000412237824ULL, 0x000fe200078e00ffULL,
0x0000003f18197812ULL, 0x040fe200078ec0ffULL, 0x0000000418277824ULL, 0x000fe200078e00ffULL,
0x0000003f1a1b7812ULL, 0x040fe200078ec0ffULL, 0x000000041a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee206ULL, 0x0000000116057824ULL, 0x040fe200078e0205ULL,
0xfffffffc11117812ULL, 0x100fe200078ee206ULL, 0x0000000116097824ULL, 0x000fe200078e0207ULL,
0x0ffffffc06077812ULL, 0x000fe200078ef803ULL, 0x0000000116217824ULL, 0x000fe200078e0217ULL,
0x0000003004037812ULL, 0x000fe200078ec0ffULL, 0x00005e0005047625ULL, 0x000fe200078e0014ULL,
0xfffffffc15157812ULL, 0x000fc400078ee206ULL, 0xfffffffc1f1f7812ULL, 0x100fe200078ee206ULL,
0x0000000116257824ULL, 0x040fe200078e0219ULL, 0xfffffffc23237812ULL, 0x100fe200078ee206ULL,
0x0000000116297824ULL, 0x000fe200078e021bULL, 0xfffffffc27277812ULL, 0x000fe200078ee206ULL,
0x00000010070b7824ULL, 0x000fe200078e020cULL, 0xfffffffc2b2b7812ULL, 0x000fe200078ee206ULL,
0x000000100d177824ULL, 0x100fe200078e020cULL, 0x0000000304047210ULL, 0x000fe20007f1e0ffULL,
0x0000001011197824ULL, 0x100fe400078e020cULL, 0x00000010151b7824ULL, 0x000fc400078e020cULL,
0x000000101f1f7824ULL, 0x100fe400078e020cULL, 0x0000001023237824ULL, 0x100fe400078e020cULL,
0x0000001027277824ULL, 0x100fe400078e020cULL, 0x000000102b2b7824ULL, 0x000fe400078e020cULL,
0x00005e00130c7625ULL, 0x000fc800078e0014ULL, 0x00005e0009067625ULL, 0x000fc800078e0014ULL,
0x00005e000f087625ULL, 0x000fe200078e0014ULL, 0x0000000306067210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x000000030c0c7210ULL, 0x080fe20007f1e0ffULL,
0x00005e001d0e7625ULL, 0x080fe200078e0014ULL, 0x0000000308087210ULL, 0x000fe40007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0021107625ULL, 0x000fc800078e0014ULL, 0x00005e0025127625ULL, 0x000fc800078e0014ULL,
0x00005e0029147625ULL, 0x000fc800078e0014ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000030e0e7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000310107210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000312127210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x0000000314147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000006177faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400010e0613ULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000000008197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010237faeULL, 0x0003e8000b901c46ULL, 0x0000000012277faeULL, 0x0003e8000b901c46ULL,
0x00000000142b7faeULL, 0x0003e4000b901c46ULL, 0x01060400ff037984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034900780cULL, 0x000fda0003f04070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002049037824ULL, 0x002fc800078e0204ULL,
0x0000002003057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104087812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x100fe400078e7803ULL,
0x0000000708087812ULL, 0x100fe400078e7803ULL, 0x0000001004147810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x0000000714147812ULL, 0x000fc400078e7803ULL,
0x0000000006107984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7803ULL,
0x0000000105147824ULL, 0x040fe200078e0214ULL, 0x00000000080c7984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0013ULL, 0x0000001806007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fca00078e000fULL,
0x0000001c08007388ULL, 0x000fe8000000cc00ULL, 0x00000000040c7984ULL, 0x000e68000000cc00ULL,
0x0000000014107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002014007388ULL, 0x0003e8000000cc00ULL, 0x0000000c04007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01060400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300047305ULL, 0x0022a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe40003800000ULL,
0x01060400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000024b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000327919ULL, 0x000ea20000000000ULL, 0x00005800ff3c7624ULL, 0x000fe200078e00ffULL,
0x3d80000034347820ULL, 0x000fe20000410000ULL, 0x000064000a367a24ULL, 0x000fe200078e02ffULL,
0xffffffff02387810ULL, 0x000fe20007ffe0ffULL, 0x0000001049357824ULL, 0x000fe200078e00ffULL,
0x00007610ff377816ULL, 0x000fe20000000037ULL, 0x000000ffff3a7224ULL, 0x000fe400078e00ffULL,
0x000000403c3c7824ULL, 0x000fe400078e00ffULL, 0x000001004b397824ULL, 0x000fe200078e0230ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000394800720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x028fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e003aULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000ffff037224ULL, 0x000fe200078e00ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x002fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000001030a7810ULL, 0x000fe20007ffe0ffULL,
0x00000bb000007945ULL, 0x000fe20003800000ULL, 0x00000001083a7812ULL, 0x000fc400078e0cffULL,
0x00000002ff247819ULL, 0x000fe4000001160aULL, 0x000000040a00780cULL, 0x040fe40003f06070ULL,
0x000000030a4a7812ULL, 0x000fe200078ec0ffULL, 0x00000300240b7a24ULL, 0x000fca00078e024bULL,
0x000000010b097810ULL, 0x000fc80007ffe0ffULL, 0x000000020900720cULL, 0x000fe20003f26070ULL,
0x000000ffff097224ULL, 0x000fe400078e0003ULL, 0x000000ffff037224ULL, 0x000fd400078e000aULL,
0x000005e000009947ULL, 0x020fea0003800000ULL, 0x000001000b0b7824ULL, 0x000fe200078e0230ULL,
0x00000002ff3d7819ULL, 0x004fe20000011632ULL, 0x000000043c2c7e24ULL, 0x000fe4000f8e0231ULL,
0x000000044a3b7824ULL, 0x000fe200078e00ffULL, 0x0000000b480a7217ULL, 0x000fe20007800000ULL,
0x0000000249277824ULL, 0x000fe200078e023aULL, 0x000000083d2d7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000003f3d257812ULL, 0x000fe200078ec0ffULL,
0x000000010a267824ULL, 0x000fe200078e0a0bULL, 0x00000003ff0b7819ULL, 0x100fe20000011632ULL,
0x000000042d3e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3b3b7812ULL, 0x100fe200078ee232ULL,
0x000000012c0a7824ULL, 0x000fe200078e0225ULL, 0x000000030b417812ULL, 0x000fc400078e4832ULL,
0x0000003f2d0b7812ULL, 0x000fe400078ec0ffULL, 0x000000263d00720cULL, 0x080fe40003f26070ULL,
0x000000262d00720cULL, 0x000fe20003f46070ULL, 0x000000012c247824ULL, 0x000fe200078e020bULL,
0x0000200027277811ULL, 0x000fe200078e60ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e003fULL,
0x0ffffffc412e7812ULL, 0x000fe400078ef832ULL, 0xfffffffc3e3e7812ULL, 0x000fe200078ee241ULL,
0x00005e0024247625ULL, 0x000fe200078e003fULL, 0x000000103d437810ULL, 0x000fc40007ffe0ffULL,
0x000000183d457810ULL, 0x040fe20007ffe0ffULL, 0x000000102e2d7824ULL, 0x000fe200078e0227ULL,
0x000000203d477810ULL, 0x000fe20007ffe0ffULL, 0x000000103b0a7825ULL, 0x000fe200078e000aULL,
0x000000283d4d7810ULL, 0x040fe40007ffe0ffULL, 0x000000303d4f7810ULL, 0x040fe20007ffe0ffULL,
0x000000103e2f7824ULL, 0x000fe200078e0227ULL, 0x000000383d517810ULL, 0x000fe20007ffe0ffULL,
0x000000103b247825ULL, 0x000fe200078e0024ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a2d7faeULL, 0x0003e2000c901c46ULL, 0x0000003f4f3d7812ULL, 0x000fc400078ec0ffULL,
0x0000003f51537812ULL, 0x000fe200078ec0ffULL, 0x00000000242f7faeULL, 0x0005e2000d101c46ULL,
0x000000264300720cULL, 0x080fe20003f26070ULL, 0x000000012c447824ULL, 0x040fe200078e023dULL,
0x000000264500720cULL, 0x080fe20003f46070ULL, 0x000000012c4c7824ULL, 0x040fe200078e0253ULL,
0x000000264700720cULL, 0x0c0fe20003f66070ULL, 0x00000004473e7824ULL, 0x000fe200078e00ffULL,
0x000000264d00720cULL, 0x0c0fe20003f86070ULL, 0x000000044d427824ULL, 0x000fe200078e00ffULL,
0x0000003f430b7812ULL, 0x002fe200078ec0ffULL, 0x000000044f467824ULL, 0x000fe200078e00ffULL,
0x0000003f472d7812ULL, 0x000fe200078ec0ffULL, 0x0000000443247824ULL, 0x004fe200078e00ffULL,
0x0000003f45257812ULL, 0x000fe200078ec0ffULL, 0x000000012c0a7824ULL, 0x040fe200078e020bULL,
0x0000003f4d2f7812ULL, 0x000fe200078ec0ffULL, 0x000000012c2e7824ULL, 0x040fe200078e022dULL,
0x000000264f00720cULL, 0x080fe20003fa6070ULL, 0x00000004514e7824ULL, 0x040fe200078e00ffULL,
0x000000265100720cULL, 0x000fe20003fc6070ULL, 0x000000012c267824ULL, 0x000fe200078e0225ULL,
0xfffffffc24247812ULL, 0x000fe200078ee241ULL, 0x000000012c407824ULL, 0x000fe200078e022fULL,
0xfffffffc3e3e7812ULL, 0x100fe200078ee241ULL, 0x00000004452c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc42427812ULL, 0x000fe200078ee241ULL, 0x00000010243d7824ULL, 0x000fe200078e0227ULL,
0xfffffffc46467812ULL, 0x100fe200078ee241ULL, 0x00005e000a0a7625ULL, 0x000fe200078e003fULL,
0xfffffffc2c2c7812ULL, 0x000fc400078ee241ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee241ULL,
0x000000103e437824ULL, 0x100fe400078e0227ULL, 0x000000102c417824ULL, 0x100fe400078e0227ULL,
0x0000001042457824ULL, 0x100fe400078e0227ULL, 0x0000001046477824ULL, 0x100fe400078e0227ULL,
0x000000104e4d7824ULL, 0x000fe400078e0227ULL, 0x00005e0026247625ULL, 0x000fc800078e003fULL,
0x00005e002e267625ULL, 0x000fc800078e003fULL, 0x00005e00402c7625ULL, 0x000fc800078e003fULL,
0x00005e00442e7625ULL, 0x000fc800078e003fULL, 0x00005e004c3e7625ULL, 0x000fc800078e003fULL,
0x000000103b0a7825ULL, 0x000fc800078e000aULL, 0x000000103b247825ULL, 0x040fe200078e0024ULL,
0x000000000a3d7faeULL, 0x0003e6000c901c46ULL, 0x000000103b267825ULL, 0x040fe200078e0026ULL,
0x0000000024417faeULL, 0x0003e6000d101c46ULL, 0x000000103b2c7825ULL, 0x040fe200078e002cULL,
0x0000000026437faeULL, 0x0003e6000d901c46ULL, 0x000000103b2e7825ULL, 0x040fe200078e002eULL,
0x000000002c457faeULL, 0x0003e6000e101c46ULL, 0x000000103b3e7825ULL, 0x000fe200078e003eULL,
0x000000002e477faeULL, 0x0003e8000e901c46ULL, 0x000000003e4d7faeULL, 0x0003e2000f101c46ULL,
0x0000052000007947ULL, 0x000fea0003800000ULL, 0x00000002ff0a7819ULL, 0x004fe20000011632ULL,
0x000000043c0b7e24ULL, 0x000fc4000f8e0231ULL, 0x000000044a3b7824ULL, 0x000fe200078e00ffULL,
0x0000003f0a247812ULL, 0x040fe200078ec0ffULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x000000080a267810ULL, 0x040fe40007ffe0ffULL, 0x000000100a2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000180a2f7810ULL, 0x040fe40007ffe0ffULL, 0x000000200a3d7810ULL, 0x040fe40007ffe0ffULL,
0x000000280a3f7810ULL, 0x000fc40007ffe0ffULL, 0x000000300a417810ULL, 0x040fe40007ffe0ffULL,
0x000000380a457810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e0224ULL,
0x0000003f26247812ULL, 0x040fe200078ec0ffULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x0000003f2d2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000445567824ULL, 0x000fe200078e00ffULL,
0x0000003f2f3e7812ULL, 0x000fe200078ec0ffULL, 0x000000010b2c7824ULL, 0x000fe200078e0224ULL,
0x0000003f3d427812ULL, 0x000fe200078ec0ffULL, 0x000000010b2e7824ULL, 0x000fe200078e022eULL,
0x0000003f3f467812ULL, 0x000fe200078ec0ffULL, 0x000000010b407824ULL, 0x000fe200078e023eULL,
0x0000003f414e7812ULL, 0x000fe200078ec0ffULL, 0x000000010b447824ULL, 0x000fe200078e0242ULL,
0x0000003f45527812ULL, 0x000fe200078ec0ffULL, 0x000000010b4c7824ULL, 0x000fe200078e0246ULL,
0xfffffffc3b3b7812ULL, 0x000fe200078ee232ULL, 0x000000010b507824ULL, 0x000fc400078e024eULL,
0x000000010b547824ULL, 0x000fe200078e0252ULL, 0x00000003ff0b7819ULL, 0x000fe20000011632ULL,
0x0000000249247824ULL, 0x000fe400078e023aULL, 0x000000042d3e7824ULL, 0x000fe200078e00ffULL,
0x000000030b257812ULL, 0x100fe200078e4832ULL, 0x000000042f427824ULL, 0x000fe200078e00ffULL,
0x0000200024277811ULL, 0x000fe200078e60ffULL, 0x000000043d467824ULL, 0x000fe200078e00ffULL,
0x0ffffffc25247812ULL, 0x000fe200078ef832ULL, 0x000000043f4e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc26267812ULL, 0x100fe200078ee225ULL, 0x0000000441527824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e3e7812ULL, 0x100fe200078ee225ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0043ULL,
0xfffffffc42427812ULL, 0x000fc400078ee225ULL, 0xfffffffc46467812ULL, 0x000fe200078ee225ULL,
0x00000010243d7824ULL, 0x000fe200078e0227ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee225ULL,
0x0000001026457824ULL, 0x000fe200078e0227ULL, 0xfffffffc52527812ULL, 0x000fe200078ee225ULL,
0x000000103e477824ULL, 0x000fe200078e0227ULL, 0xfffffffc56567812ULL, 0x000fe200078ee225ULL,
0x00000010424d7824ULL, 0x100fe400078e0227ULL, 0x00000010464f7824ULL, 0x100fe400078e0227ULL,
0x000000104e517824ULL, 0x000fc400078e0227ULL, 0x0000001052537824ULL, 0x100fe400078e0227ULL,
0x0000001056557824ULL, 0x000fe400078e0227ULL, 0x00005e002c247625ULL, 0x000fc800078e0043ULL,
0x00005e002e267625ULL, 0x000fc800078e0043ULL, 0x00005e00402c7625ULL, 0x000fc800078e0043ULL,
0x00005e00442e7625ULL, 0x000fc800078e0043ULL, 0x00005e004c3e7625ULL, 0x000fc800078e0043ULL,
0x000000103b0a7825ULL, 0x000fc800078e000aULL, 0x00005e0050407625ULL, 0x080fe200078e0043ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a3d7faeULL, 0x0003e6000b901c46ULL,
0x00005e0054427625ULL, 0x000fc800078e0043ULL, 0x000000103b247825ULL, 0x000fc800078e0024ULL,
0x000000103b267825ULL, 0x040fe200078e0026ULL, 0x0000000024457faeULL, 0x0003e6000b901c46ULL,
0x000000103b2c7825ULL, 0x040fe200078e002cULL, 0x0000000026477faeULL, 0x0003e6000b901c46ULL,
0x000000103b2e7825ULL, 0x040fe200078e002eULL, 0x000000002c4d7faeULL, 0x0003e6000b901c46ULL,
0x000000103b3e7825ULL, 0x040fe200078e003eULL, 0x000000002e4f7faeULL, 0x0003e6000b901c46ULL,
0x000000103b407825ULL, 0x040fe200078e0040ULL, 0x000000003e517faeULL, 0x0003e6000b901c46ULL,
0x000000103b427825ULL, 0x000fe200078e0042ULL, 0x0000000040537faeULL, 0x0003e8000b901c46ULL,
0x0000000042557faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000034a00780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x002fe400078e00ffULL,
0xffffffffff317424ULL, 0x000fe400078e00ffULL, 0x000003000b337a24ULL, 0x000fca00078e0233ULL,
0x000000003300720cULL, 0x000fda0003f26070ULL, 0x0000003000001947ULL, 0x000fea0003800000ULL,
0x00000002360a7824ULL, 0x000fc800078e0233ULL, 0x000060000a0a7625ULL, 0x000fca00078e000bULL,
0x000000060a317981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020320b7810ULL, 0x042fe20007ffe0ffULL,
0x00000002493f7824ULL, 0x000fe200078e0208ULL, 0xfffffff832417812ULL, 0x040fe200078ec0ffULL,
0x0000000809437824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x0000000741417812ULL, 0x100fe400078ef832ULL,
0x000000070b427812ULL, 0x000fe400078ef832ULL, 0x00000007323d7812ULL, 0x000fc400078ec0ffULL,
0x00000001ff3e7819ULL, 0x000fe40000011641ULL, 0x00000001ff407819ULL, 0x000fe40000011642ULL,
0x000020003f3f7811ULL, 0x000fe400078e60ffULL, 0x000000083d3d7812ULL, 0x000fe400078ef832ULL,
0x000000033e3e7812ULL, 0x000fe400078ec0ffULL, 0x0000000340407812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003b3e087212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003b40257212ULL, 0x000fc400078e3cffULL,
0x000000013b4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000441087824ULL, 0x000fe200078e0208ULL,
0x00000043327a7211ULL, 0x000fe200078fe0ffULL, 0x0000000442247824ULL, 0x000fe200078e0225ULL,
0x000000023b3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001008087824ULL, 0x100fe200078e023fULL,
0x0000000443437810ULL, 0x000fe20007ffe0ffULL, 0x0000001024247824ULL, 0x000fe200078e023fULL,
0x000000043b00780cULL, 0x000fc60003f25270ULL, 0x000000000808783bULL, 0x000e680000000200ULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x00000018ff6c7819ULL, 0x002fe20000011408ULL,
0x00010000082c7824ULL, 0x040fe200078e00ffULL, 0x0000888008717816ULL, 0x040fe200000000ffULL,
0x0000010008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe2000001140aULL,
0x00010000092d7824ULL, 0x000fe200078e00ffULL, 0x000088800a6f7816ULL, 0x000fe200000000ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff087819ULL, 0x000fc40000011408ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff6a7819ULL, 0x000fe20000011409ULL, 0x0000000800797306ULL, 0x0003e20000200c00ULL,
0x0000888009727816ULL, 0x040fe200000000ffULL, 0x0000010009097824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x004fe40000011424ULL, 0x00008880246b7816ULL, 0x000fc400000000ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000002c00787306ULL, 0x000fe20000200c00ULL,
0x000100000a087824ULL, 0x042fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe2000001140bULL,
0x000001000a0a7824ULL, 0x000fe200078e00ffULL, 0x000088800b6d7816ULL, 0x000fe400000000ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000002d00777306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fc40000011425ULL,
0x0000888025667816ULL, 0x000fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe40000011426ULL,
0x00000018ff467819ULL, 0x000fe20000011427ULL, 0x0000000a00757306ULL, 0x0003e20000200c00ULL,
0x0000888026627816ULL, 0x000fe400000000ffULL, 0x00008880275a7816ULL, 0x000fca00000000ffULL,
0x0000000800767306ULL, 0x0005e20000200c00ULL, 0x0000004d3e0a7212ULL, 0x082fe400078e3cffULL,
0x0000004d404d7212ULL, 0x000fc600078e3cffULL, 0x00000004410a7824ULL, 0x000fe400078e020aULL,
0x00000009007b7306ULL, 0x0003e20000200c00ULL, 0x0001000024087824ULL, 0x004fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe400078e023fULL, 0x0000010024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x000000000a2c783bULL, 0x000ea20000000200ULL,
0x000100000b097824ULL, 0x042fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x000001000b0b7824ULL, 0x000fe200078e00ffULL, 0x00000008006e7306ULL, 0x0003e40000200c00ULL,
0x00000018ff097819ULL, 0x000fc40000011409ULL, 0x00000018ff0b7819ULL, 0x000fc8000001140bULL,
0x0000002400707306ULL, 0x0007e20000200c00ULL, 0x0001000026087824ULL, 0x042fe400078e00ffULL,
0x0000010026267824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011408ULL,
0x0000000b00737306ULL, 0x0003e20000200c00ULL, 0x0000000442247824ULL, 0x008fe200078e024dULL,
0x00000018ff267819ULL, 0x000fcc0000011426ULL, 0x0000000900747306ULL, 0x0007e20000200c00ULL,
0x00000010240b7824ULL, 0x002fe400078e023fULL, 0x0001000027247824ULL, 0x040fe400078e00ffULL,
0x0000010027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0001000025097824ULL, 0x048fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000010025257824ULL, 0x000fe200078e00ffULL, 0x00000024005f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4a7819ULL, 0x004fe4000001142cULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x00000018ff4c7819ULL, 0x000fe2000001142dULL,
0x0000002600647306ULL, 0x000fe20000200c00ULL, 0x000100002c247824ULL, 0x042fe200078e00ffULL,
0x000088802c537816ULL, 0x040fe200000000ffULL, 0x000001002c2c7824ULL, 0x000fe200078e00ffULL,
0x000088802d567816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011424ULL,
0x000000077a247812ULL, 0x100fe200078e783dULL, 0x0000002500677306ULL, 0x0003e20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff4d7819ULL, 0x000fe2000001142eULL,
0x000000203d247824ULL, 0x000fe200078e0224ULL, 0x000088802e587816ULL, 0x000fe400000000ffULL,
0x000000027a7a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x0000002700617306ULL, 0x0005e20000200c00ULL, 0x000100002d257824ULL, 0x042fe200078e00ffULL,
0x000000077a7a7812ULL, 0x000fe200078e783dULL, 0x000001002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001142fULL, 0x00000018ff577819ULL, 0x000fe20000011425ULL,
0x000000203d7a7824ULL, 0x000fe200078e027aULL, 0x0000000900697306ULL, 0x0003e20000200c00ULL,
0x000000002424783bULL, 0x004fe20000000200ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000088802f5d7816ULL, 0x000fc800000000ffULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x000000000b08783bULL, 0x002e6e0000000200ULL, 0x0000002c00557306ULL, 0x0007f00000200c00ULL,
0x0000002d00597306ULL, 0x0009e20000200c00ULL, 0x000100002e2c7824ULL, 0x008fc400078e00ffULL,
0x000001002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000100002f2d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x000001002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fce000001142fULL, 0x0000002c005b7306ULL, 0x0005e20000200c00ULL,
0x00000018ff4f7819ULL, 0x002fe40000011408ULL, 0x00000018ff507819ULL, 0x000fe40000011409ULL,
0x00000018ff517819ULL, 0x000fe4000001140aULL, 0x00000018ff527819ULL, 0x000fe2000001140bULL,
0x0000002d005e7306ULL, 0x0003e20000200c00ULL, 0x00005410712c7816ULL, 0x004fce0000000078ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00005410792d7816ULL, 0x002fe2000000006cULL,
0x00010000086c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000002c2428723cULL, 0x000fee0000001828ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00005410722c7816ULL, 0x008fc40000000077ULL,
0x000054107b2d7816ULL, 0x000fca000000006aULL, 0x0000004500457306ULL, 0x000ea40000200c00ULL,
0x0000002c2420723cULL, 0x000fec0000001820ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x000054106f2c7816ULL, 0x002fe40000000076ULL, 0x00005410752d7816ULL, 0x000fca0000000068ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x0000541070457816ULL, 0x004fe20000000045ULL,
0x0000002c241c723cULL, 0x000fec000000181cULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x00005410732d7816ULL, 0x000fe40000000044ULL, 0x000054106b447816ULL, 0x008fca000000006eULL,
0x0000006600667306ULL, 0x000ee20000200c00ULL, 0x000054106d2c7816ULL, 0x002fe20000000074ULL,
0x000000442404723cULL, 0x000fe20000001804ULL, 0x00010000096d7824ULL, 0x000fca00078e00ffULL,
0x0000002e005c7306ULL, 0x0003e20000200c00ULL, 0x0000010009447824ULL, 0x000fe200078e00ffULL,
0x0000002c2418723cULL, 0x000fe20000001818ULL, 0x00000018ff457819ULL, 0x000fc6000001146dULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00008880082e7816ULL, 0x042fe200000000ffULL, 0x0000010008087824ULL, 0x000fca00078e00ffULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000006200627306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000e700000200c00ULL, 0x0000006c006f7306ULL, 0x0009f00000200c00ULL,
0x0000000800687306ULL, 0x0007e20000200c00ULL, 0x00008880096c7816ULL, 0x010fc400000000ffULL,
0x0000541067097816ULL, 0x004fe40000000060ULL, 0x000088800a607816ULL, 0x000fc600000000ffULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x0000541066087816ULL, 0x008fce0000000069ULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x000000082414723cULL, 0x000fee0000001814ULL,
0x0000541062087816ULL, 0x002fe20000000065ULL, 0x0000002e006a7306ULL, 0x0003e20000200c00ULL,
0x0000541064097816ULL, 0x000fc40000000047ULL, 0x0000541061617816ULL, 0x004fca0000000046ULL,
0x000000082410723cULL, 0x000fe20000001810ULL, 0x000000107a2e7824ULL, 0x002fe200078e00ffULL,
0x0000002f00637306ULL, 0x0003ea0000200c00ULL, 0x000000ffff087224ULL, 0x000fe200078e0060ULL,
0x000054105a607816ULL, 0x008fe2000000005fULL, 0x000100000a097824ULL, 0x040fe200078e00ffULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000002e2c783bULL, 0x002e620000000200ULL,
0x000001000a0a7824ULL, 0x000fc400078e00ffULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x00000060240c723cULL, 0x000fe4000000180cULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000005700577306ULL, 0x000ea80000200c00ULL, 0x000088800b247816ULL, 0x040fe200000000ffULL,
0x000100000b257824ULL, 0x040fe400078e00ffULL, 0x000001000b0b7824ULL, 0x000fe200078e00ffULL,
0x0000004c004c7306ULL, 0x000ee40000200c00ULL, 0x00000018ff257819ULL, 0x000fc40000011425ULL,
0x00000018ff0b7819ULL, 0x000fc8000001140bULL, 0x0000004e004e7306ULL, 0x000f220000200c00ULL,
0x0000541056567816ULL, 0x004fce0000000057ULL, 0x0000000800087306ULL, 0x000fe20000200c00ULL,
0x0000541059577816ULL, 0x008fce000000004cULL, 0x0000000900097306ULL, 0x000ea20000200c00ULL,
0x00005410635f7816ULL, 0x010fe2000000004eULL, 0x000000562c20723cULL, 0x002fe20000001820ULL,
0x000054106a4e7816ULL, 0x000fca000000006fULL, 0x0000002400247306ULL, 0x000ff00000200c00ULL,
0x0000002500257306ULL, 0x000e620000200c00ULL, 0x0000541008087816ULL, 0x004fce0000000009ULL,
0x0000004a004a7306ULL, 0x000eb00000200c00ULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x0000541024247816ULL, 0x002fce0000000025ULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x0000541055557816ULL, 0x004fce000000004aULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000054105c4d7816ULL, 0x008fce000000004dULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00005410684f7816ULL, 0x002fce000000004fULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x0000004e2c04723cULL, 0x000fee0000001804ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000eb00000200c00ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x0000541053547816ULL, 0x002fce0000000054ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410584c7816ULL, 0x004fe2000000005bULL,
0x000000542c28723cULL, 0x040fec0000001828ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000054105d5e7816ULL, 0x008fe2000000005eULL, 0x0000004c2c1c723cULL, 0x040fec000000181cULL,
0x00000044006d7306ULL, 0x000ea40000200c00ULL, 0x0000005e2c18723cULL, 0x000fec0000001818ULL,
0x0000000a000a7306ULL, 0x000ee20000200c00ULL, 0x000054106c6c7816ULL, 0x002fce0000000045ULL,
0x0000000b000b7306ULL, 0x000e620000200c00ULL, 0x000054106d6d7816ULL, 0x004fe40000000050ULL,
0x000054100a097816ULL, 0x008fca0000000051ULL, 0x0000006c2c14723cULL, 0x000fe20000001814ULL,
0x000054100b257816ULL, 0x002fce0000000052ULL, 0x000000082c10723cULL, 0x040ff00000001810ULL,
0x000000242c0c723cULL, 0x000fe2000000180cULL, 0xfffff0f000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff087224ULL, 0x000fe200078e003aULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe31000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0106140035087984ULL, 0x000e620000000800ULL,
0x0000ffff37037812ULL, 0x000fe200078ec0ffULL, 0x0000002134257220ULL, 0x040fe20000410000ULL,
0x00000022340a7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x00008880032f7816ULL, 0x000fe200000000ffULL, 0x0000002034277220ULL, 0x040fe20000410000ULL,
0x0000001f342c7220ULL, 0x040fe20000410000ULL, 0x0000001834227220ULL, 0x040fe20000410000ULL,
0x0000001934217220ULL, 0x040fe20000410000ULL, 0x800000002f037824ULL, 0x000fe200078e00ffULL,
0x0000002934097220ULL, 0x040fe20000410000ULL, 0x0000001a34187220ULL, 0x040fe20000410000ULL,
0x0000001b34197220ULL, 0x040fe20000410000ULL, 0x0000000434207220ULL, 0x040fe20000410000ULL,
0x00000005341f7220ULL, 0x040fe20000410000ULL, 0x0000002a342a7220ULL, 0x040fe20000410000ULL,
0x0000002b342b7220ULL, 0x040fe20000410000ULL, 0x0000001e34267220ULL, 0x040fe20000410000ULL,
0x0000000634067220ULL, 0x040fe20000410000ULL, 0x0000000734077220ULL, 0x040fe20000410000ULL,
0x0000001634047220ULL, 0x040fe20000410000ULL, 0x0000001734057220ULL, 0x040fe20000410000ULL,
0x00000012342d7220ULL, 0x040fe20000410000ULL, 0x00000013342e7220ULL, 0x040fe20000410000ULL,
0x00000023340b7220ULL, 0x040fe20000410000ULL, 0x0000001c34247220ULL, 0x040fe20000410000ULL,
0x0000001d34237220ULL, 0x040fe20000410000ULL, 0x00000014341e7220ULL, 0x040fe20000410000ULL,
0x0000000d34177220ULL, 0x040fe20000410000ULL, 0x000000ffff297224ULL, 0x000fe200078e0028ULL,
0x00000015341d7220ULL, 0x040fe20000410000ULL, 0x00000010341c7220ULL, 0x040fe20000410000ULL,
0x00000011341b7220ULL, 0x040fe20000410000ULL, 0x0000000f340d7220ULL, 0x040fe20000410000ULL,
0x000000ffff287224ULL, 0x000fe200078e0009ULL, 0x0000000c341a7220ULL, 0x040fe20000410000ULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0000000e340e7220ULL, 0x000fe20000410000ULL,
0x000000ffff137224ULL, 0x000fe200078e0019ULL, 0x8000000008ff7812ULL, 0x002fe20007804803ULL,
0x000000ffff087224ULL, 0x000fc400078e0018ULL, 0x000000ffff167224ULL, 0x000fe400078e002aULL,
0x000000ffff157224ULL, 0x000fe400078e002bULL, 0x000000ffff0a7224ULL, 0x000fe400078e0026ULL,
0x000000ffff097224ULL, 0x000fe400078e002cULL, 0x000000ffff127224ULL, 0x000fe400078e0006ULL,
0x000000ffff117224ULL, 0x000fc400078e0007ULL, 0x000000ffff107224ULL, 0x000fe400078e0004ULL,
0x000000ffff197224ULL, 0x000fe400078e0005ULL, 0x000000ffff187224ULL, 0x000fe400078e002dULL,
0x000000ffff0f7224ULL, 0x000fe200078e002eULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000002f2f7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff037424ULL, 0x000fc800078e00ffULL,
0x0000000300047305ULL, 0x0002a4000021f000ULL, 0x3fa0000003037823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0106140035047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fc4000780482fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000432037824ULL, 0x000fe200078e00ffULL, 0x000000384b00720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff0030c7812ULL, 0x000fca00078ec0ffULL,
0x00000080490c7824ULL, 0x000fca00078e020cULL, 0x010400000c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000232267824ULL, 0x000fe400078e00ffULL,
0x0000000148397824ULL, 0x000fc600078e0a39ULL, 0x0000000626267812ULL, 0x000fc800078ec0ffULL,
0x00000001262a7812ULL, 0x040fe400078efcffULL, 0x00000008262c7812ULL, 0x000fe400078efcffULL,
0x000000392a00720cULL, 0x080fe40003f26070ULL, 0x00000010262a7812ULL, 0x000fe400078efcffULL,
0x000000392c00720cULL, 0x080fe40003f06070ULL, 0x000000392a00720cULL, 0x000fc40003fc6070ULL,
0x00000011262c7812ULL, 0x040fe400078efcffULL, 0x00000018262a7812ULL, 0x040fe400078efcffULL,
0x000000392600720cULL, 0x080fe40003f46070ULL, 0x000000392c00720cULL, 0x080fe40003fa6070ULL,
0x000000392a00720cULL, 0x000fe40003f66070ULL, 0x00000009262e7812ULL, 0x000fc400078efcffULL,
0x00000019262c7812ULL, 0x040fe400078efcffULL, 0x00000020262a7812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff29297808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fc40004800000ULL,
0x000000392e00720cULL, 0x080fe40003f86070ULL, 0x000000392c00720cULL, 0x080fe40003f46070ULL,
0x000000392a00720cULL, 0x000fe40003f26070ULL, 0x00000021262c7812ULL, 0x040fe400078efcffULL,
0x00000028262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff14147808ULL, 0x000fc40004000000ULL,
0xff7fffff27277808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff25257808ULL, 0x000fe40006000000ULL, 0x000000392c00720cULL, 0x080fe40003f06070ULL,
0x000000392a00720cULL, 0x000fe40003f86070ULL, 0x00000029262c7812ULL, 0x000fc400078efcffULL,
0x00000030262a7812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff24247808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff23237808ULL, 0x000fe40006800000ULL, 0x000000392c00720cULL, 0x000fc40003fc6070ULL,
0x000000392a00720cULL, 0x000fe40003fa6070ULL, 0x00000031262c7812ULL, 0x040fe400078efcffULL,
0x00000038262a7812ULL, 0x040fe400078efcffULL, 0x0000003926267812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff22227808ULL, 0x000fc40005800000ULL,
0xff7fffff13137808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40005000000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0xff7fffff20207808ULL, 0x000fe40004800000ULL,
0x000000392c00720cULL, 0x080fe40003f66070ULL, 0x000000392a00720cULL, 0x000fc40003f46070ULL,
0x000000392600720cULL, 0x000fe40003f26070ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40006000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff19197808ULL, 0x000fc40007000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40007000000ULL, 0xff7fffff18187808ULL, 0x000fe40006800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005800000ULL, 0xff7fffff0e0e7808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL,
0xff7fffff17177808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000029042b7209ULL, 0x004fe20007810000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x0000001605267209ULL, 0x000fe20007810000ULL, 0xffffffffff3e7424ULL, 0x000fe200078e00ffULL,
0x000000282b047209ULL, 0x000fe40007810000ULL, 0x0000001526057209ULL, 0x000fc40007810000ULL,
0x0000002704047209ULL, 0x000fe40007810000ULL, 0x0000001405267209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x0000000b262b7209ULL, 0x000fe40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000000a2b267209ULL, 0x000fc40007810000ULL,
0x0000002304057209ULL, 0x000fe40007810000ULL, 0x00000009262b7209ULL, 0x000fe40007810000ULL,
0x0000002205047209ULL, 0x000fe40007810000ULL, 0x000000082b267209ULL, 0x000fe40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x00000013262b7209ULL, 0x000fc40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x000000122b267209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x00000011262b7209ULL, 0x000fe40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x000000102b267209ULL, 0x000fc40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x00000019262b7209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x000000182b267209ULL, 0x000fe40007810000ULL,
0x0000001b04057209ULL, 0x000fe40007810000ULL, 0x0000000f262b7209ULL, 0x000fc40007810000ULL,
0x0000001a05047209ULL, 0x000fe40007810000ULL, 0x0000000e2b267209ULL, 0x000fe40007810000ULL,
0x00000017042c7209ULL, 0x000fe40007810000ULL, 0x0000000d262e7209ULL, 0x000fe20007810000ULL,
0x00000d927f007947ULL, 0x000fea000b800000ULL, 0x0c401f002c047f89ULL, 0x0004e400000e0000ULL,
0x000000042c2f7209ULL, 0x008fe20007810000ULL, 0x00000db27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002e047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007267f89ULL, 0x000e6200000e0000ULL, 0x000000042e2a7209ULL, 0x008fc60007810000ULL,
0x0c201f002f047f89ULL, 0x000ee200000e0000ULL, 0x00000005062b7209ULL, 0x010fc60007810000ULL,
0x0c201f002a057f89ULL, 0x000f2200000e0000ULL, 0x0000002607267209ULL, 0x002fc60007810000ULL,
0x0c201f002b2c7f89ULL, 0x004e6800000e0000ULL, 0x0c201f00262d7f89ULL, 0x0004a200000e0000ULL,
0x000000042f047209ULL, 0x008fe40007810000ULL, 0x000000052a057209ULL, 0x010fe40007810000ULL,
0x0000002c2b067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b042a7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b052f7820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001082fULL,
0x0000001b002e7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b23237823ULL, 0x100fe2000001082aULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0b1b7823ULL, 0x108fe2000001082fULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001082aULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001082aULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe2000001082aULL, 0x3fb8aa3b083b7823ULL, 0x100fe2000001082fULL,
0x0000002800287308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe2000001082fULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe2000001082fULL,
0x3fb8aa3b0f0f7823ULL, 0x000fc8000001082fULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x00000025002c7308ULL, 0x002e620000000800ULL, 0x000000292808723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b10297823ULL, 0x000fcc000001082fULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ff00000000800ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001b000b7308ULL, 0x0007300000000800ULL, 0x0000001a002b7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b121b7823ULL, 0x008fce000001082fULL, 0x00000017002a7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b0a1a7823ULL, 0x104fe2000001082fULL, 0x000000272c0a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b11277823ULL, 0x000fe2000001082fULL, 0x000000140b0b723eULL, 0x010fc800000000ffULL,
0x0000001d00077308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b09177823ULL, 0x008fe2000001082fULL,
0x000000161509723eULL, 0x000fcc00000000ffULL, 0x0000001c00257308ULL, 0x0005e20000000800ULL,
0x3c003c00ff1d7424ULL, 0x002fce00078e00ffULL, 0x0000001700397308ULL, 0x0003e20000000800ULL,
0x3c003c00ff1c7424ULL, 0x004fce00078e00ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x0000001c0814723cULL, 0x002fee00000018ffULL, 0x0000002300237308ULL, 0x000e700000000800ULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x000000242310723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b18237823ULL, 0x000fcc000001082fULL,
0x0000001a001a7308ULL, 0x000e700000000800ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x000000222112723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b19217823ULL, 0x000fcc000001082fULL,
0x0000001300287308ULL, 0x000ea20000000800ULL, 0x0000001a3911723eULL, 0x002fce00000000ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x0000003b2813723eULL, 0x004fce00000000ffULL,
0x00000027002c7308ULL, 0x000e620000000800ULL, 0x0000001c1014723cULL, 0x000fee0000001814ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000001f001f7308ULL, 0x000ea20000000800ULL,
0x0000001b2c19723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000e700000000800ULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x000000201f18723eULL, 0x004fce00000000ffULL,
0x0000002100227308ULL, 0x000ea20000000800ULL, 0x0000001e071a723eULL, 0x002fe400000000ffULL,
0xfffffffc32077812ULL, 0x000fca00078ec0ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x00000029221b723eULL, 0x004fce00000000ffULL, 0x0000000f00247308ULL, 0x000e620000000800ULL,
0x0000001c1840723cULL, 0x000fee0000001814ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000fff147424ULL, 0x000fe200078e00ffULL, 0x0000002b2a16723eULL, 0x000fcc00000000ffULL,
0x0000000d000d7308ULL, 0x000ea20000000800ULL, 0x000000232415723eULL, 0x002fe400000000ffULL,
0x0000000714217219ULL, 0x000fe400000006ffULL, 0x000000252e14723eULL, 0x000fe400000000ffULL,
0x00000000211e73a1ULL, 0x000e6200000e8000ULL, 0x00000000210573c4ULL, 0x000ee20000004000ULL,
0x000000262d077209ULL, 0x000fe40007810000ULL, 0x0000000e0d17723eULL, 0x004fce00000000ffULL,
0x0000001c1440723cULL, 0x000fe20000001840ULL, 0x0000000821ff7c12ULL, 0x002fda000f80401eULL,
0x000008f205008947ULL, 0x008ff4000b800000ULL, 0x001c1fff401c7589ULL, 0x0002a400000e0000ULL,
0x00000000210e73a1ULL, 0x000ee200000e8000ULL, 0x00000000210573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x0000000821ff7c12ULL, 0x008fda000f80400eULL,
0x0000090205008947ULL, 0x010fea000b800000ULL, 0x001c1fff421d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff001f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff0d7819ULL, 0x002fe40000011632ULL, 0x0000000c033d7812ULL, 0x000fc400078ec0ffULL,
0x000000070d0e7812ULL, 0x040fe200078ec0ffULL, 0x000000080d237824ULL, 0x040fe200078e00ffULL,
0x0000000dff217212ULL, 0x008fe200078e33ffULL, 0x000000080d0f7824ULL, 0x040fe200078e00ffULL,
0x0000000332ff7812ULL, 0x000fe2000780c0ffULL, 0x000000080d2e7824ULL, 0x040fe200078e00ffULL,
0x000000080d0d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff823207812ULL, 0x100fe400078ee20eULL,
0x000000010f227812ULL, 0x100fe200078ef60eULL, 0x000000080d4e7824ULL, 0x000fe200078e00ffULL,
0x000000020f247812ULL, 0x100fe200078ef60eULL, 0x000000080d237824ULL, 0x000fe200078e00ffULL,
0x000000030f267812ULL, 0x000fc400078ef60eULL, 0x000000040f287812ULL, 0x140fe400078ef60eULL,
0x000000050f2a7812ULL, 0x140fe400078ef60eULL, 0x000000060f2c7812ULL, 0x000fe200078ef60eULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee221ULL,
0x0000000dff217212ULL, 0x000fe400078e33ffULL, 0x000000070d0e7812ULL, 0x000fc400078ec0ffULL,
0x0000a000490d7811ULL, 0x000fe400078e58ffULL, 0xfffffff84e4e7812ULL, 0x000fe400078ee221ULL,
0xfffffff8233e7812ULL, 0x100fe200078ee20eULL, 0x0000001020037824ULL, 0x100fe200078e020dULL,
0x000000010f407812ULL, 0x140fe200078ef60eULL, 0x0000001026207824ULL, 0x100fe200078e020dULL,
0x000000020f427812ULL, 0x140fe200078ef60eULL, 0x000000102c267824ULL, 0x000fe200078e020dULL,
0x000000030f447812ULL, 0x100fe200078ef60eULL, 0x000000013d037824ULL, 0x000fe200078e0203ULL,
0x000000040f467812ULL, 0x140fe200078ef60eULL, 0x00000010402b7824ULL, 0x100fe200078e020dULL,
0x000000050f4a7812ULL, 0x140fe200078ef60eULL, 0x00000010422c7824ULL, 0x100fe200078e020dULL,
0x000000060f4c7812ULL, 0x000fe200078ef60eULL, 0x00000010220e7824ULL, 0x100fe200078e020dULL,
0x0000000803007388ULL, 0x0003e20000000800ULL, 0x00000010240f7824ULL, 0x000fc400078e020dULL,
0x0000001028227824ULL, 0x100fe400078e020dULL, 0x000000102a247824ULL, 0x100fe400078e020dULL,
0x000000102e287824ULL, 0x100fe400078e020dULL, 0x000000103e2a7824ULL, 0x100fe400078e020dULL,
0x00000010442d7824ULL, 0x100fe400078e020dULL, 0x00000010462e7824ULL, 0x000fc400078e020dULL,
0x000000104a2f7824ULL, 0x100fe400078e020dULL, 0x000000104c397824ULL, 0x100fe400078e020dULL,
0x000000104e3b7824ULL, 0x000fe400078e020dULL, 0x000000013d0d7824ULL, 0x040fe400078e020eULL,
0x000000013d0f7824ULL, 0x040fe400078e020fULL, 0x000000013d217824ULL, 0x040fe200078e0220ULL,
0x0000000a0d007388ULL, 0x0007e20000000800ULL, 0x000000013d237824ULL, 0x000fc400078e0222ULL,
0x000000013d257824ULL, 0x040fe200078e0224ULL, 0x000000100f007388ULL, 0x0007e20000000800ULL,
0x000000013d277824ULL, 0x040fe400078e0226ULL, 0x000000013d297824ULL, 0x040fe200078e0228ULL,
0x0000001221007388ULL, 0x0007e20000000800ULL, 0x000000013d2a7824ULL, 0x040fe400078e022aULL,
0x000000013d0e7824ULL, 0x040fe200078e022bULL, 0x0000001823007388ULL, 0x0007e20000000800ULL,
0x000000013d2c7824ULL, 0x000fc400078e022cULL, 0x000000013d087824ULL, 0x042fe200078e022dULL,
0x0000001a25007388ULL, 0x0007e20000000800ULL, 0x000000013d2e7824ULL, 0x040fe400078e022eULL,
0x000000013d207824ULL, 0x040fe200078e022fULL, 0x0000001427007388ULL, 0x0007e20000000800ULL,
0x000000013d227824ULL, 0x040fe400078e0239ULL, 0x000000013d247824ULL, 0x000fe200078e023bULL,
0x0000001629007388ULL, 0x0007e80000000800ULL, 0x000000092a007388ULL, 0x0007e80000000800ULL,
0x0000000b0e007388ULL, 0x0007e80000000800ULL, 0x000000112c007388ULL, 0x0007e80000000800ULL,
0x0000001308007388ULL, 0x0007e80000000800ULL, 0x000000192e007388ULL, 0x0007e80000000800ULL,
0x0000001b20007388ULL, 0x0007e80000000800ULL, 0x0000001522007388ULL, 0x0007e80000000800ULL,
0x0000001724007388ULL, 0x0007e80000000800ULL, 0x010000040c008388ULL, 0x0007e80000000c00ULL,
0x0102001c0c008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003004b4b7a10ULL, 0x000fe20007ffe0ffULL, 0x0106080035ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff37ff7812ULL, 0x000fc4000780c0ffULL, 0x000000024b00720cULL, 0x000fe40003f26070ULL,
0x00000001ff377807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffc94000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000002ff2d7424ULL, 0x000fe200078e00ffULL, 0x00014fd0002a7802ULL, 0x000fe40000000f00ULL,
0x0000053000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002dULL,
0xfffff23000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2c7224ULL, 0x006fe200078e002eULL,
0x00015030002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2d7424ULL, 0x000fe400078e00ffULL,
0x000004d000007944ULL, 0x020fea0003c00000ULL, 0x0000002d2e2e7209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0006ULL, 0x00015080002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0007ULL,
0x000150d0002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x0000002d07267209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e002fULL, 0x00015120002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x000fea0003c00000ULL,
0x0000002d2f047209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e002eULL,
0x00015170002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000002d2e057209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e0006ULL, 0x000151c0002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2d7424ULL, 0x000fc400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0x0000002d06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0026ULL,
0x00015210002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2d7424ULL, 0x000fc400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xfffff0f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0d7224ULL, 0x000fe200078e0040ULL, 0x00015270000e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff207224ULL, 0x000fc400078e00ffULL, 0x00001c1fff227424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e001fULL,
0xfffff6b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0d7224ULL, 0x002fe200078e0042ULL,
0x000152e0000e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff207224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x0000026000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff207224ULL, 0x002fe200078e00ffULL, 0x00015330000e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x002fe200078e00ffULL,
0x00015380000e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff227424ULL, 0x000fc400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff63000007947ULL, 0x000fea000383ffffULL, 0x018000002d037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000002d00038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000304ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff2dff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000304ff7212ULL, 0x000fe4000780c0ffULL,
0x800000002d047812ULL, 0x000fd600078ec0ffULL, 0x0080000004030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002d00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff2d7424ULL, 0x006fc800078e00ffULL, 0xfffeab002c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003e00007348ULL, 0x000fe80003800000ULL,
0x0c00002d2c2d7389ULL, 0x0002a200000e0039ULL, 0xfffeaac02a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000002100007348ULL, 0x000fe80003800000ULL,
0x000000200d1f7389ULL, 0x0002a200000e0022ULL, 0xfffeaa800e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000790ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000808ULL, 0x00000000000008e8ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001110ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001120ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001140ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011b0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011b8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011c8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001380ULL, 0x0000000000015680ULL, 0xa200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016a00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016a10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016a10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016e90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000011b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015850ULL, 0x0000000000015850ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016e90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_89_cubin_len = 94064;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
