/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018210ULL, 0x0000000000017d90ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x00000000000168f0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x0000000000016a80ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000016ac0ULL, 0x0000000000000140ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016c00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000168f000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x0059980400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8908288080840828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808089920000ULL, 0x0000000000000022ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x000168f000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8087288080840900ULL, 0x0900000004042880ULL, 0x2880808428808089ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8c08288080840828ULL, 0x2880808808288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808088ULL, 0x0000001cffffffffULL,
0x0000010800000000ULL, 0x00016a8000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8808288080840828ULL, 0x2880808c08288080ULL,
0x8280162880809a08ULL, 0x0000000003102880ULL, 0x80809a9200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000018800000000ULL, 0x00016ac000000000ULL, 0x0000014000000000ULL,
0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000e0ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL, 0x0000000000000011ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0001578000183104ULL, 0x00015c4000015c10ULL, 0x00015da000015d90ULL, 0x00e8290400015db0ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002005000020ULL, 0x0500002005000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000c000e82804ULL, 0x00001e40000000f0ULL, 0x00001f5000001ee0ULL,
0x00002fd000001f80ULL, 0x00004d2000003000ULL, 0x00004e3000004db0ULL, 0x00005d1000004e60ULL,
0x0000794000005d50ULL, 0x00007a30000079c0ULL, 0x0000896000007a60ULL, 0x0000a600000089a0ULL,
0x0000a7100000a690ULL, 0x0000b5300000a740ULL, 0x0000ca500000b570ULL, 0x0000d1e00000ca60ULL,
0x0000f1800000ef20ULL, 0x0000f6900000f650ULL, 0x000156500000fec0ULL, 0x0001569000015680ULL,
0x000156c0000156a0ULL, 0x00015700000156e0ULL, 0x00015d8000015710ULL, 0x00015df000015de0ULL,
0x0001644000015e00ULL, 0x00016530000164c0ULL, 0x00016610000165a0ULL, 0x000166f000016680ULL,
0x000167c000016760ULL, 0x0001688000016830ULL, 0x03e03904000168d0ULL, 0x000000ff00000170ULL,
0x003f01000001c600ULL, 0x0000000f000001a0ULL, 0x003f01300001c608ULL, 0x0000000f000001d0ULL,
0x003f01300001c610ULL, 0x0000000f00000230ULL, 0x003f01200001c648ULL, 0x000000ff00000240ULL,
0x003f01000001c658ULL, 0x000000ff000005a0ULL, 0x003f01070001c600ULL, 0x0000007100000770ULL,
0x003f01020001c614ULL, 0x0000007100000850ULL, 0x003f01010001c610ULL, 0x000000ff00001050ULL,
0x003f01070001c648ULL, 0x000000ff000010d0ULL, 0x003f01010001c658ULL, 0x000000ff00001250ULL,
0x003f01060001c65cULL, 0x000000ff00001300ULL, 0x003f01060001c65cULL, 0x000000ff00001390ULL,
0x003f01060001c65cULL, 0x000000ff00001bf0ULL, 0x0005010700000000ULL, 0x0000002a00001c60ULL,
0x003f010600000004ULL, 0x000000ff00001c80ULL, 0x003f01060001c60cULL, 0x000000ff00001d80ULL,
0x003f01060001c60cULL, 0x0000002a000021e0ULL, 0x003f010600000004ULL, 0x0000002a00002280ULL,
0x003f010600000004ULL, 0x000000ff00004280ULL, 0x003f01010001c658ULL, 0x000000ff000042f0ULL,
0x003f01010001c610ULL, 0x000000ff000043a0ULL, 0x003f01060001c65cULL, 0x000000ff000043f0ULL,
0x003f01060001c65cULL, 0x000000ff00004480ULL, 0x003f01060001c65cULL, 0x0000003a00004b20ULL,
0x003f01070001c648ULL, 0x0000002800004b90ULL, 0x003f010600000004ULL, 0x000000ff00004bb0ULL,
0x003f01060001c61cULL, 0x000000ff00004ca0ULL, 0x003f01060001c61cULL, 0x00000028000050d0ULL,
0x003f010600000004ULL, 0x0000002800005160ULL, 0x003f010600000004ULL, 0x000000ff00006f50ULL,
0x003f01010001c658ULL, 0x000000ff00006fc0ULL, 0x003f01010001c620ULL, 0x000000ff00007050ULL,
0x003f01060001c65cULL, 0x000000ff000070b0ULL, 0x003f01060001c65cULL, 0x000000ff00007140ULL,
0x003f01060001c65cULL, 0x000000ff00007750ULL, 0x0005010700000000ULL, 0x00000030000077c0ULL,
0x003f01060001c64cULL, 0x000000ff000077e0ULL, 0x003f01060001c62cULL, 0x000000ff000078c0ULL,
0x003f01060001c62cULL, 0x0000003100007cf0ULL, 0x003f01060001c64cULL, 0x0000003200007de0ULL,
0x003f010600000004ULL, 0x000000ff00009bd0ULL, 0x003f01010001c658ULL, 0x000000ff00009c40ULL,
0x003f01010001c630ULL, 0x000000ff00009cf0ULL, 0x003f01060001c65cULL, 0x000000ff00009d40ULL,
0x003f01060001c65cULL, 0x000000ff00009dd0ULL, 0x003f01060001c65cULL, 0x000000360000a420ULL,
0x003f01070001c648ULL, 0x000000080000a490ULL, 0x003f010600000004ULL, 0x000000ff0000a4b0ULL,
0x003f01060001c63cULL, 0x000000ff0000a580ULL, 0x003f01060001c63cULL, 0x000000140000a9b0ULL,
0x003f010600000004ULL, 0x000000140000aa40ULL, 0x003f010600000004ULL, 0x000000ff0000c790ULL,
0x003f01010001c658ULL, 0x000000ff0000c7f0ULL, 0x003f01010001c640ULL, 0x000000ff00011c60ULL,
0x003f01060001c604ULL, 0x000000ff00011cf0ULL, 0x003f01060001c604ULL, 0x000000ff00012020ULL,
0x003f01010001c600ULL, 0x000000ff00012030ULL, 0x003f01060001c604ULL, 0x000000ff000120b0ULL,
0x003f01060001c604ULL, 0x0000002600014b20ULL, 0x003f01060001c614ULL, 0x0000002600014f50ULL,
0x003f01060001c614ULL, 0x0000002600016380ULL, 0x003f01010001c608ULL, 0x00101c0400053803ULL,
0x0001210000010300ULL, 0x000163e0000121d0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL, 0x00000000fffffffeULL,
0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x00000000000001fcULL, 0x0000001100000002ULL, 0x0000000000000174ULL, 0x0000001100000002ULL,
0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL, 0x0000001100000002ULL,
0x00000000000001d4ULL, 0x0000001100000002ULL, 0x000000000000014fULL, 0x0000001100000002ULL,
0x00000000000000b2ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff157424ULL, 0x000fe200078e00ffULL, 0x00000000000479c3ULL, 0x000ea20000002600ULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00005800ff2f7624ULL, 0x000fc600078e00ffULL, 0x0000000000097919ULL, 0x000ee80000002100ULL,
0x0000000000277919ULL, 0x000f220000002700ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x108fe200078e0209ULL, 0x00000005ff767819ULL, 0x000fe20000011609ULL,
0x00001fff08007589ULL, 0x00086600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff76767589ULL, 0x000ee200000e0000ULL,
0x0000007f0f00780cULL, 0x000fe20003f24070ULL, 0x0000620027087625ULL, 0x010fe200078e0015ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01c60002ff00b388ULL, 0x0009e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x01c608040f008388ULL, 0x0009e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0aa424ULL, 0x000fe200078e00ffULL, 0x01c610060f008388ULL, 0x0009e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x01c4000e0f009388ULL, 0x0009e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x01c6480a0f00a388ULL, 0x0009e80000008a00ULL,
0x01c6580cff00b388ULL, 0x0009e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x004fea0003800000ULL, 0x0000000000127919ULL, 0x018e620000000000ULL,
0x0000000476037824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x000000102f027824ULL, 0x000fc400078e00ffULL, 0x00000200ff147424ULL, 0x000fc600078e00ffULL,
0x0000000502047e24ULL, 0x000fe2000f8e0227ULL, 0x0000000312037211ULL, 0x042fe200078fd8ffULL,
0x0000001012027824ULL, 0x000fc600078e00ffULL, 0x0000000703057812ULL, 0x000fe400078ec0ffULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0x0000001f05067812ULL, 0x000fe400078e7812ULL, 0x00000002030d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000103057810ULL, 0x040fe20007ffe0ffULL, 0x00000020030c7824ULL, 0x040fe200078e0206ULL,
0x00000003030f7810ULL, 0x000fe20007ffe0ffULL, 0x00005c0002027625ULL, 0x000fe200078e0014ULL,
0x000000070d0a7812ULL, 0x000fc400078ec0ffULL, 0x0000000705077812ULL, 0x000fe200078ec0ffULL,
0x0000000104067824ULL, 0x000fe200078e0205ULL, 0x0000001f0a107812ULL, 0x000fe200078e7812ULL,
0x0000000104117824ULL, 0x000fe200078e020fULL, 0x000000070f0b7812ULL, 0x000fe400078ec0ffULL,
0x00000013020a7210ULL, 0x000fe20007f1e0ffULL, 0x000000200d107824ULL, 0x000fe200078e0210ULL,
0x0000001f070e7812ULL, 0x100fe200078e7812ULL, 0x0000000104077824ULL, 0x000fe200078e020dULL,
0x0000001f0b127812ULL, 0x000fe200078e7812ULL, 0x000000ffff0b7224ULL, 0x000fc400000e0603ULL,
0x00005c0006027625ULL, 0x000fc800078e0014ULL, 0x00000020050e7824ULL, 0x000fe200078e020eULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x00005c0007047625ULL, 0x000fc800078e0014ULL,
0x00005c0011067625ULL, 0x000fe200078e0014ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x000000200f127824ULL, 0x000fe200078e0212ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608747981ULL, 0x018ea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff787e24ULL, 0x008fe2000f8e00ffULL, 0x0000003f74757810ULL, 0x004fc40007ffe0ffULL,
0x000000ff74737810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff757819ULL, 0x000fe40000011675ULL,
0x00000008ff737819ULL, 0x000fca0000011673ULL, 0x0000fc7000008947ULL, 0x000fea0003800000ULL,
0x0000000478707824ULL, 0x000fe400078e00ffULL, 0x0000001076717824ULL, 0x000fe400078e00ffULL,
0x00000003ff047424ULL, 0x002fe200078e00ffULL, 0x000000757000720cULL, 0x000fe20003f06070ULL,
0xffffffffff067424ULL, 0x000fd800078e00ffULL, 0x0000640070038a10ULL, 0x000fe20007ffe0ffULL,
0x0000000227008824ULL, 0x000fc800078e00ffULL, 0x0000640000038a24ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6140471ff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0015ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000602068981ULL, 0x0004e2000c1e1900ULL, 0x0000000170707810ULL, 0x000fe20007ffe0ffULL,
0x0000010078077824ULL, 0x000fe400078e00ffULL, 0xffffffffff727424ULL, 0x000fe200078e00ffULL,
0x000000757000720cULL, 0x040fe20003f06070ULL, 0x0000000604047899ULL, 0x000fe2000800063fULL,
0x000000402f2f7824ULL, 0x000fe200078e00ffULL, 0x01c6100071ff7f8cULL, 0x0009f4000c80043fULL,
0x0000640070008a10ULL, 0x000fe20007ffe0ffULL, 0x0000000227058824ULL, 0x000fc800078e00ffULL,
0x0000640005008a24ULL, 0x000fc800078e0200ULL, 0x0000600000048625ULL, 0x002fe400078e0015ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000000774087217ULL, 0x000fe40007800000ULL,
0x0000000178027810ULL, 0x004fe20007ffe0ffULL, 0x0000000604728981ULL, 0x000562000c1e1900ULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000108087824ULL, 0x000fe200078e0a07ULL, 0x000000730200720cULL, 0x000fe20003f06070ULL,
0xff317217ff2e7424ULL, 0x000fe200078e00ffULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000004008087807ULL, 0x000fe20000000000ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000871087217ULL, 0x000fe20007800000ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff4d7224ULL, 0x000fc600078e00ffULL,
0x0000000108117824ULL, 0x000fe200078e0a71ULL, 0x00000004ff107819ULL, 0x002fe20000011600ULL,
0x00000010001d7824ULL, 0x000fc600078e00ffULL, 0x0000000210047810ULL, 0x044fe20007ffe0ffULL,
0x0000000171037824ULL, 0x000fe200078e0210ULL, 0x0000000610087810ULL, 0x000fe40007ffe0ffULL,
0x000000f01d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000000703057812ULL, 0x000fe200078ec0ffULL,
0x00000001710d7824ULL, 0x000fe200078e0208ULL, 0x000000110800720cULL, 0x080fe40003f46070ULL,
0x0000000f05027812ULL, 0x000fe200078e7800ULL, 0x0000000171057824ULL, 0x000fe200078e0204ULL,
0x000000110400720cULL, 0x000fc40003f86070ULL, 0x00000008100a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003137824ULL, 0x000fe200078e0202ULL, 0x0000000705077812ULL, 0x000fe400078ec0ffULL,
0x000000110a00720cULL, 0x080fe20003f26070ULL, 0x00000001710f7824ULL, 0x000fe200078e020aULL,
0x0000000f07047812ULL, 0x000fe400078e7800ULL, 0x000000111000720cULL, 0x040fe40003fa6070ULL,
0x0001400013137811ULL, 0x000fe200078e20ffULL, 0x0000001005147824ULL, 0x000fe200078e0204ULL,
0x0000000e101a7810ULL, 0x000fca0007ffe0ffULL, 0x00000001711b7824ULL, 0x000fe400078e021aULL,
0x000000042f127e24ULL, 0x008fe2000f8e0206ULL, 0x0000000410067810ULL, 0x000fc80007ffe0ffULL,
0x0000003f12037812ULL, 0x000fe200078ef803ULL, 0x00000001710b7824ULL, 0x000fe200078e0206ULL,
0x000000110600720cULL, 0x000fc60003f66070ULL, 0x00005e0003027625ULL, 0x000fe200078e001fULL,
0x000000070b077812ULL, 0x000fc800078ec0ffULL, 0x0000001d02087210ULL, 0x000fe40007f1e0ffULL,
0x0000003f12027812ULL, 0x000fe400078ef805ULL, 0x0000000f07047812ULL, 0x100fe200078e7800ULL,
0x000000ffff097224ULL, 0x000fe200000e0603ULL, 0x000000070d057812ULL, 0x000fe200078ec0ffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x000000070f077812ULL, 0x000fe400078ec0ffULL,
0x0000000f05067812ULL, 0x000fe200078e7800ULL, 0x000000100b157824ULL, 0x000fe200078e0204ULL,
0x0000001d020a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000e901c46ULL, 0x0000003f12027812ULL, 0x040fe200078ef80bULL,
0x000000100d167824ULL, 0x000fe200078e0206ULL, 0x0000003f12047812ULL, 0x040fe200078ef80dULL,
0x000000ffff0b7224ULL, 0x000fe200000e0603ULL, 0x0000003f12067812ULL, 0x000fe200078ef80fULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000000f07187812ULL, 0x000fc400078e7800ULL,
0x0001400015157811ULL, 0x000fe200078e20ffULL, 0x00005e0004047625ULL, 0x000fe200078e001fULL,
0x0000001d020c7210ULL, 0x000fe40007f1e0ffULL, 0x0000000a10027810ULL, 0x000fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e001fULL, 0x0000001d040e7210ULL, 0x000fe40007fde0ffULL,
0x0000000c10047810ULL, 0x000fe20007ffe0ffULL, 0x0000000171177824ULL, 0x000fe400078e0202ULL,
0x000000ffff0d7224ULL, 0x000fe200000e0603ULL, 0x000000110200720cULL, 0x000fe20003f06070ULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x0000003f12027812ULL, 0x000fe200078ef817ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0605ULL, 0x0000001d06067210ULL, 0x000fe20007fde0ffULL,
0x0000000171197824ULL, 0x000fe200078e0204ULL, 0x0001400014057811ULL, 0x000fe200078e20ffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x000000110400720cULL, 0x000fc40003fa6070ULL,
0x0000000717097812ULL, 0x002fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001d02107210ULL, 0x000fe20007fde0ffULL, 0x000000000a057faeULL, 0x0003e2000e101c46ULL,
0x0000003f12027812ULL, 0x000fe400078ef819ULL, 0x000000111a00720cULL, 0x000fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200030e0603ULL, 0x0000003f12047812ULL, 0x000fe200078ef81bULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000000719137812ULL, 0x000fe200078ec0ffULL,
0x000000000c157faeULL, 0x0009e2000d901c46ULL, 0x0000000f09127812ULL, 0x000fc400078e7800ULL,
0x0000001d02087210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x002fe200078e001fULL,
0x000000071b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000f13027812ULL, 0x000fe200078e7800ULL,
0x0000001017127824ULL, 0x000fe200078e0212ULL, 0x0000000f0b0a7812ULL, 0x000fe200078e7800ULL,
0x000000ffff097224ULL, 0x000fe200030e0603ULL, 0x0000001d04047210ULL, 0x000fe20007fde0ffULL,
0x0000001019027824ULL, 0x000fe200078e0202ULL, 0x0001400016037811ULL, 0x000fe200078e20ffULL,
0x000000101b0a7824ULL, 0x000fe200078e020aULL, 0x00014000180b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0001400012137811ULL, 0x000fe200078e20ffULL,
0x000000000e037faeULL, 0x0009e2000d101c46ULL, 0x0001400002177811ULL, 0x000fe200078e20ffULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x000140000a197811ULL, 0x000fe200078e20ffULL,
0x00000000060b7faeULL, 0x0009e8000c901c46ULL, 0x0000000010137faeULL, 0x0009e2000c101c46ULL,
0x000000737800720cULL, 0x000fc60003f06070ULL, 0x0000000008177faeULL, 0x0009e8000e901c46ULL,
0x0000000004197faeULL, 0x0009e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000b74000000947ULL, 0x000fea0003800000ULL,
0x0000000227067824ULL, 0x010fe200078e00ffULL, 0x0000000276047811ULL, 0x000fe200078e10ffULL,
0x00006400ff057624ULL, 0x000fe200078e00ffULL, 0x00007610ff657816ULL, 0x000fe20000000065ULL,
0xff317217ff2e7424ULL, 0x000fe200078e00ffULL, 0x00007610ff667816ULL, 0x000fe20000000066ULL,
0x0000640006057624ULL, 0x000fe200078e0205ULL, 0x00007610ff067816ULL, 0x000fe20000000006ULL,
0x000000ffff647224ULL, 0x000fc400078e00ffULL, 0x000000ffff537224ULL, 0x000fe400078e00ffULL,
0x0000010078037824ULL, 0x000fca00078e00ffULL, 0x000000740300720cULL, 0x000fda0003f06070ULL,
0x0000b61000000947ULL, 0x000fea0003800000ULL, 0x01c65c00ff087984ULL, 0x000e620000000800ULL,
0x0000ffff65037812ULL, 0x000fe200078ec0ffULL, 0x000000ffff827224ULL, 0x000fe400078e0070ULL,
0x000000ffff077224ULL, 0x000fe200078e0064ULL, 0x00008880030b7816ULL, 0x000fca00000000ffULL,
0x800000000b097824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x002fe20007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000761066037816ULL, 0x000fe40000000003ULL,
0x0000761065087816ULL, 0x000fe20000000008ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000b0b7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff097424ULL, 0x000fc800078e00ffULL,
0x00000009000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000009097823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000300ff097624ULL, 0x000fe200078e00ffULL,
0x00000003700a7812ULL, 0x000fe200078ec0ffULL, 0x0000000472167e24ULL, 0x020fe2000f8e022fULL,
0x00000004ff177819ULL, 0x000fe20000011600ULL, 0xffffffffff727424ULL, 0x000fe200078e00ffULL,
0x000000030a00780cULL, 0x000fe40003f05270ULL, 0xfffffffd09097811ULL, 0x000fc800078e10ffULL,
0x0000000109097807ULL, 0x000fca0004000000ULL, 0x0000000170707824ULL, 0x000fca00078e0209ULL,
0x000000757000720cULL, 0x000fe20003f06070ULL, 0x0000000171097824ULL, 0x000fe200078e0217ULL,
0x00000040780f7811ULL, 0x000fe200078e40ffULL, 0x00000100ff257424ULL, 0x000fe200078e00ffULL,
0x0000000217137810ULL, 0x000fe20007ffe0ffULL, 0x00000010002d7824ULL, 0x000fe200078e00ffULL,
0x0000003f160c7812ULL, 0x000fce00078ef809ULL, 0x00000001700a8824ULL, 0x000fe400078e0205ULL,
0x00000004ff0b8424ULL, 0x000fe200078e00ffULL, 0x0000000f74107217ULL, 0x000fc60007800000ULL,
0x000060000a0a8625ULL, 0x000fe200078e000bULL, 0x00000001780e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000417147810ULL, 0x040fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0025ULL,
0x000000060a728981ULL, 0x000362000c1e1900ULL, 0x000000730e00720cULL, 0x000fe40003f06070ULL,
0x0000000110107824ULL, 0x000fe200078e0a0fULL, 0x0000000617217810ULL, 0x040fe20007ffe0ffULL,
0x00004000642c7824ULL, 0x000fe200078e00ffULL, 0x0000000817297810ULL, 0x000fc40007ffe0ffULL,
0x0000004010107807ULL, 0x000fe20000000000ULL, 0x00000001710b7824ULL, 0x002fe200078e0213ULL,
0x000000f02d0a7812ULL, 0x000fe400078ec0ffULL, 0x0000001071107217ULL, 0x040fe40007800000ULL,
0x0000000a0c187210ULL, 0x000fe20007f3e0ffULL, 0x00000001710c7824ULL, 0x000fe200078e0214ULL,
0x0000003f160e7812ULL, 0x000fe200078ef80bULL, 0x00000001101c7824ULL, 0x000fe200078e0a71ULL,
0x0000000a17307810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e060dULL,
0x0000003f16117812ULL, 0x000fe200078ef80cULL, 0x00005e000e0e7625ULL, 0x000fe200078e0025ULL,
0x0000001c1300720cULL, 0x000fc40003f86070ULL, 0x0000001c1400720cULL, 0x000fe20003f66070ULL,
0x00000001710d7824ULL, 0x000fe200078e0221ULL, 0x0000000a0e1a7210ULL, 0x080fe20007f1e0ffULL,
0x00005e0011107625ULL, 0x080fe200078e0025ULL, 0x0000000c17317810ULL, 0x000fe40007ffe0ffULL,
0x0000003f16127812ULL, 0x000fe200078ef80dULL, 0x00000001710e7824ULL, 0x000fe200078e0229ULL,
0x0000000e17327810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e060fULL,
0x0000000a101e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0025ULL,
0x0000003f16147812ULL, 0x000fc400078ef80eULL, 0x0000001c2100720cULL, 0x080fe20003f46070ULL,
0x00000001710f7824ULL, 0x000fe200078e0230ULL, 0x0000001c1700720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1f7224ULL, 0x000fe200000e0611ULL, 0x0000000a12207210ULL, 0x080fe20007f1e0ffULL,
0x00005e0014147625ULL, 0x080fe200078e0025ULL, 0x0000003f16127812ULL, 0x000fe400078ef80fULL,
0x0000000709177812ULL, 0x000fe200078ec0ffULL, 0x000000ffff217224ULL, 0x000fe200000e0613ULL,
0x0000000a14227210ULL, 0x000fe20007f1e0ffULL, 0x0000000171107824ULL, 0x040fe200078e0231ULL,
0x000040002c287812ULL, 0x000fe200078e0cffULL, 0x0000000171117824ULL, 0x000fe200078e0232ULL,
0x000000070f337812ULL, 0x000fe200078ec0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0025ULL,
0x0000003f16147812ULL, 0x000fc400078ef810ULL, 0x0000003f16167812ULL, 0x000fe200078ef811ULL,
0x000000ffff237224ULL, 0x000fe200000e0615ULL, 0x0000000a12247210ULL, 0x080fe20007f1e0ffULL,
0x00005e0014147625ULL, 0x080fe200078e0025ULL, 0x0000000f17127812ULL, 0x000fe400078e7800ULL,
0x00014000282a7810ULL, 0x000fe20007ffe0ffULL, 0x00005e0016167625ULL, 0x000fe200078e0025ULL,
0x0000000a14267210ULL, 0x080fe40007f3e0ffULL, 0x0000000711357812ULL, 0x000fe200078ec0ffULL,
0x000000ffff257224ULL, 0x000fe200000e0613ULL, 0x000000070b137812ULL, 0x000fe200078ec0ffULL,
0x0000001009127824ULL, 0x000fe200078e0212ULL, 0x0000000a16287210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff277224ULL, 0x000fe200008e0615ULL, 0x0000000f13147812ULL, 0x000fe200078e7800ULL,
0x00000010122b7824ULL, 0x000fe200078e022aULL, 0x000000070c157812ULL, 0x000fc400078ec0ffULL,
0x0000001c2900720cULL, 0x080fe20003f26070ULL, 0x000000100b137824ULL, 0x000fe200078e0214ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000182b7faeULL, 0x0003e2000e901c46ULL,
0x0000000164147812ULL, 0x000fe200078e0cffULL, 0x000000ffff297224ULL, 0x000fe200000e0617ULL,
0x0000001c3100720cULL, 0x080fe20003fa6070ULL, 0x0000001013177824ULL, 0x000fe200078e022aULL,
0x000000070d317812ULL, 0x000fe200078ec0ffULL, 0x00000000140573c2ULL, 0x000ea200000e0000ULL,
0x0000000f15157812ULL, 0x100fe400078e7800ULL, 0x0000000f31167812ULL, 0x100fe200078e7800ULL,
0x000000001a177faeULL, 0x0007e2000e101c46ULL, 0x000000070e317812ULL, 0x000fe200078ec0ffULL,
0x000000100c157824ULL, 0x000fe200078e0215ULL, 0x0000000f33187812ULL, 0x002fe200078e7800ULL,
0x000000100d167824ULL, 0x000fe200078e0216ULL, 0x0000000f31317812ULL, 0x000fe200078e7800ULL,
0x0000001015197824ULL, 0x100fe200078e022aULL, 0x0000001c3000720cULL, 0x080fe20003f06070ULL,
0x00000010162b7824ULL, 0x000fe200078e022aULL, 0x0000001c3200720cULL, 0x000fe20003f86070ULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x000000001e197faeULL, 0x0003e2000d901c46ULL,
0x000000100e177824ULL, 0x008fe200078e0231ULL, 0x0000000710317812ULL, 0x000fc400078ec0ffULL,
0x0000000f351a7812ULL, 0x000fe200078e7800ULL, 0x00000010171b7824ULL, 0x000fe200078e022aULL,
0x0000000f31317812ULL, 0x000fe200078e7800ULL, 0x00000000202b7faeULL, 0x0007e4000d101c46ULL,
0x00000010111a7824ULL, 0x000fe200078e021aULL, 0x0001c64805057891ULL, 0x004fe2000f8e183fULL,
0x00000000221b7faeULL, 0x0005e2000c901c46ULL, 0x0000001010197824ULL, 0x002fe400078e0231ULL,
0x00000010181f7824ULL, 0x000fc400078e022aULL, 0x0000001019217824ULL, 0x008fc600078e022aULL,
0x00000000241f7faeULL, 0x0003e2000c101c46ULL, 0x000000101a2b7824ULL, 0x000fe200078e022aULL,
0x0001c648642a7811ULL, 0x000fe400078e18ffULL, 0x0000000026217faeULL, 0x0003e8000e901c46ULL,
0x00000000282b7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004002a1f7984ULL, 0x0022a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c60c00ff217984ULL, 0x000ee20000000800ULL, 0x0000ffff661b7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff061c7812ULL, 0x000fe400078ec0ffULL, 0x000088801b247816ULL, 0x000fe400000000ffULL,
0x000088801c1b7816ULL, 0x000fc600000000ffULL, 0x80000000241c7824ULL, 0x000fe400078e00ffULL,
0x800000001b1e7824ULL, 0x000fc600078e00ffULL, 0x800000001fff7812ULL, 0x004fe4000780481cULL,
0x8000000021ff7812ULL, 0x008fe2000782481eULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff1c7424ULL, 0x000fe400078e00ffULL,
0x800000001b1f7824ULL, 0x000fe400078e00ffULL, 0x0000001c001e7305ULL, 0x0004e4000021f000ULL,
0x3fa000001c1c7823ULL, 0x004fe200000100ffULL, 0x0000001e0000735dULL, 0x008fe40003800000ULL,
0x01c60c00ff1e7984ULL, 0x000ea40000000800ULL, 0x800000001eff7812ULL, 0x004fc4000782481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff1e7819ULL, 0x000fe20000011600ULL, 0x00000001ffc57424ULL, 0x000fe200078e00ffULL,
0x000000702d1c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1e1f7812ULL, 0x000fca00078ec0ffULL,
0x000000011c1c7824ULL, 0x000fca00078e021fULL, 0x01c000001c1f7984ULL, 0x000ea80000000800ULL,
0x01c200001c1e7984ULL, 0x0007220000000800ULL, 0x0000002e1f00720bULL, 0x004fda0003f3d000ULL,
0x0000000000207806ULL, 0x000fc800008e0100ULL, 0x0000ffff20257812ULL, 0x000fda000782c0ffULL,
0x0000035000009947ULL, 0x000fea0003800000ULL, 0x0000002e1f00720bULL, 0x018fe40003f34000ULL,
0x0000001f2e277209ULL, 0x000fe40007810000ULL, 0x00000002ff227819ULL, 0x000fc60000011600ULL,
0x800000272e207221ULL, 0x100fe20000010000ULL, 0x0000000822237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2e7224ULL, 0x000fe400078e0027ULL, 0x3fb8aa3b20217820ULL, 0x000fe40000410000ULL,
0x0000000000207806ULL, 0x000fe400008e0100ULL, 0x000000ff7600720cULL, 0x000fe40003f25270ULL,
0x0000ffff20207812ULL, 0x000fe200078e3cffULL, 0x0000002100217308ULL, 0x000ea60000000800ULL,
0x0000002025ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ffc57807ULL, 0x000fc60001000000ULL,
0x01c400271c009388ULL, 0x000fe80000000800ULL, 0x00001f2321237589ULL, 0x004ea400000e0000ULL,
0x800000271f1f2221ULL, 0x000fe40000010000ULL, 0x0000002102027220ULL, 0x000fe20000410000ULL,
0x00001f2221227589ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b1f1f2820ULL, 0x000fc80000410000ULL,
0x0000001f001d2308ULL, 0x000f220000000800ULL, 0x0000002353537220ULL, 0x084fe40000410000ULL,
0x0000002352527220ULL, 0x080fe40000410000ULL, 0x000000235b5b7220ULL, 0x080fe40000410000ULL,
0x000000235a5a7220ULL, 0x080fe40000410000ULL, 0x000000235f5f7220ULL, 0x080fe40000410000ULL,
0x000000235e5e7220ULL, 0x000fc40000410000ULL, 0x000000234f4f7220ULL, 0x080fe40000410000ULL,
0x000000234e4e7220ULL, 0x080fe40000410000ULL, 0x000000234b4b7220ULL, 0x080fe40000410000ULL,
0x000000234a4a7220ULL, 0x080fe40000410000ULL, 0x000000233f3f7220ULL, 0x080fe40000410000ULL,
0x000000233e3e7220ULL, 0x000fc40000410000ULL, 0x0000002343437220ULL, 0x080fe40000410000ULL,
0x0000002342427220ULL, 0x080fe40000410000ULL, 0x0000002347477220ULL, 0x080fe40000410000ULL,
0x0000002346467220ULL, 0x000fe40000410000ULL, 0x0000002251517220ULL, 0x088fe40000410000ULL,
0x0000002250507220ULL, 0x000fc40000410000ULL, 0x0000002259597220ULL, 0x080fe40000410000ULL,
0x0000002258587220ULL, 0x080fe40000410000ULL, 0x000000225d5d7220ULL, 0x080fe40000410000ULL,
0x000000225c5c7220ULL, 0x080fe40000410000ULL, 0x000000224d4d7220ULL, 0x080fe40000410000ULL,
0x000000224c4c7220ULL, 0x000fc40000410000ULL, 0x0000002249497220ULL, 0x080fe40000410000ULL,
0x0000002248487220ULL, 0x080fe40000410000ULL, 0x000000223d3d7220ULL, 0x080fe40000410000ULL,
0x000000223c3c7220ULL, 0x080fe40000410000ULL, 0x0000002241417220ULL, 0x080fe40000410000ULL,
0x0000002240407220ULL, 0x000fc40000410000ULL, 0x0000002245457220ULL, 0x080fe40000410000ULL,
0x0000002244447220ULL, 0x000fe40000410000ULL, 0x0000001d1e1e2220ULL, 0x010fc80000410000ULL,
0x000000021e027221ULL, 0x018fe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x000004002a1e7984ULL, 0x000ea20000000800ULL, 0x80000000241f7824ULL, 0x000fca00078e00ffULL,
0x800000001eff7812ULL, 0x004fe2000780481fULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000024247824ULL, 0x000fe400078e00ffULL,
0x3e000000ff1e7424ULL, 0x000fc800078e00ffULL, 0x0000001e001f7305ULL, 0x0004e4000021f000ULL,
0x3fa000001e1e7823ULL, 0x004fe200000100ffULL, 0x0000001f0000735dULL, 0x008fe40003800000ULL,
0x000004002a1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fc40007804824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004ff237819ULL, 0x100fe40000011600ULL, 0x00000008001f7812ULL, 0x000fe400078ec0ffULL,
0x000140002c207810ULL, 0x000fe20007ffe0ffULL, 0x00000004761e7824ULL, 0x000fe200078e0223ULL,
0x000000071f217812ULL, 0x000fe200078ec800ULL, 0x0000000123227824ULL, 0x000fe200078e0204ULL,
0x000000071f1f7812ULL, 0x000fe400078ef800ULL, 0x0000001e211e7212ULL, 0x000fc400078e3cffULL,
0x0000002221247212ULL, 0x000fe400078e3cffULL, 0x000001001f217811ULL, 0x040fe200078e20ffULL,
0x000000101f7f7824ULL, 0x040fe200078e021eULL, 0x0001400064267811ULL, 0x000fe200078e70ffULL,
0x000000101f7e7824ULL, 0x000fe200078e0224ULL, 0x0000000700977812ULL, 0x000fe200078ec0ffULL,
0x000000107f307824ULL, 0x100fe400078e0220ULL, 0x000000107e387824ULL, 0x000fe200078e0220ULL,
0x0000000897977812ULL, 0x000fe200078ef800ULL, 0x000000011e7d7824ULL, 0x000fc400078e0221ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x00000001247c7824ULL, 0x000fe200078e0221ULL,
0x000002001f217811ULL, 0x000fe200078e20ffULL, 0x000000107d547824ULL, 0x100fe200078e0226ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000003001f1f7811ULL, 0x000fe200078e20ffULL,
0x000000107c607824ULL, 0x000fe400078e0226ULL, 0x000000011e7b7824ULL, 0x040fe200078e0221ULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x000000011e797824ULL, 0x000fc400078e021fULL,
0x0000000124777824ULL, 0x040fe200078e021fULL, 0x000000006060783bULL, 0x000ee20000004200ULL,
0x000000107b347824ULL, 0x100fe400078e0226ULL, 0x00000001247a7824ULL, 0x000fe400078e0221ULL,
0x0000001079287824ULL, 0x100fe400078e0226ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x000000107a207824ULL, 0x100fe400078e0226ULL, 0x0000001077267824ULL, 0x000fe200078e0226ULL,
0x000000002828783bULL, 0x002fe80000004200ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x000000002624783bULL, 0x000e620000004200ULL, 0x00000100301e7824ULL, 0x044fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011430ULL, 0x00000100311f7824ULL, 0x000fe200078e00ffULL,
0x0000888030cc7816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff897819ULL, 0x000fe40000011431ULL, 0x00000018ff877819ULL, 0x008fe40000011463ULL,
0x00008880639b7816ULL, 0x000fe200000000ffULL, 0x0000001e00cf7306ULL, 0x0005e20000200c00ULL,
0x00000018ff927819ULL, 0x000fc40000011432ULL, 0x00000018ff937819ULL, 0x000fe40000011433ULL,
0x0000888031d07816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x0000888032c87816ULL, 0x040fe200000000ffULL, 0x0000001f00d17306ULL, 0x0007e20000200c00ULL,
0x00000100321e7824ULL, 0x044fe200078e00ffULL, 0x0000888033ca7816ULL, 0x000fe200000000ffULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x0000003000c97306ULL, 0x0005e20000200c00ULL,
0x00000100331f7824ULL, 0x048fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ffa37819ULL, 0x000fe40000011439ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001e00cb7306ULL, 0x0007e20000200c00ULL,
0x00000004ff307819ULL, 0x004fe40000011600ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x0000888039c17816ULL, 0x040fe400000000ffULL, 0x00000018ff887819ULL, 0x000fe20000011462ULL,
0x0000001f00cd7306ULL, 0x0005e20000200c00ULL, 0x00000100381e7824ULL, 0x008fe200078e00ffULL,
0x00008880629d7816ULL, 0x000fe400000000ffULL, 0x00000018ff817819ULL, 0x010fe40000011436ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000003100ce7306ULL, 0x000fe20000200c00ULL,
0x00000100391f7824ULL, 0x044fe200078e00ffULL, 0x00008880368a7816ULL, 0x000fe200000000ffULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ffbe7819ULL, 0x000fc40000011438ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001e00c37306ULL, 0x0005e20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000888038c27816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe40000011435ULL,
0x0000888035957816ULL, 0x000fe200000000ffULL, 0x0000001f00c47306ULL, 0x0007e20000200c00ULL,
0x000001003a1e7824ULL, 0x004fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x00000018ffac7819ULL, 0x000fe40000011455ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000003200c77306ULL, 0x000fe20000200c00ULL, 0x000001003b1f7824ULL, 0x008fe200078e00ffULL,
0x00000018ff9f7819ULL, 0x000fe40000011457ULL, 0x00000018ff847819ULL, 0x000fe40000011434ULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x0000001e00bc7306ULL, 0x0005e20000200c00ULL,
0x0000888055b57816ULL, 0x000fe400000000ffULL, 0x0000888057ae7816ULL, 0x000fe400000000ffULL,
0x0000888034917816ULL, 0x000fe400000000ffULL, 0x00000018ffa97819ULL, 0x000fe2000001143aULL,
0x0000001f00bd7306ULL, 0x0007e20000200c00ULL, 0x00000100541e7824ULL, 0x004fe200078e00ffULL,
0x00000018ffa87819ULL, 0x000fc4000001143bULL, 0x000088803abb7816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000003300c67306ULL, 0x000fe20000200c00ULL, 0x00000100551f7824ULL, 0x008fe200078e00ffULL,
0x000088803bba7816ULL, 0x000fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x002fe20000011420ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fc4000001141fULL, 0x0000001e00b77306ULL, 0x0003e20000200c00ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff807819ULL, 0x000fe40000011421ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000001f00b67306ULL, 0x0005e20000200c00ULL, 0x00000100561e7824ULL, 0x002fe200078e00ffULL,
0x00000018ffa07819ULL, 0x000fc40000011456ULL, 0x0000888056af7816ULL, 0x040fe200000000ffULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000003900c07306ULL, 0x0003e20000200c00ULL, 0x00000100571f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011460ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff1f7819ULL, 0x000fc4000001141fULL,
0x0000001e00b07306ULL, 0x0005e20000200c00ULL, 0x00000002ff397819ULL, 0x002fe40000011600ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000888060a77816ULL, 0x040fe400000000ffULL,
0x00000018ff8f7819ULL, 0x000fe20000011461ULL, 0x0000001f00b17306ULL, 0x0003e20000200c00ULL,
0x00000100601e7824ULL, 0x044fe200078e00ffULL, 0x0000888061a57816ULL, 0x000fe200000000ffULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc40000011437ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000003800bf7306ULL, 0x000fe20000200c00ULL,
0x00000100611f7824ULL, 0x042fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0001000061617824ULL, 0x000fe200078e00ffULL, 0x00008880378b7816ULL, 0x000fe400000000ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001e00a47306ULL, 0x0003e20000200c00ULL,
0x00000018ff617819ULL, 0x000fc40000011461ULL, 0x00000018ffad7819ULL, 0x000fe40000011454ULL,
0x0000888054b47816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011422ULL, 0x0000001f00a67306ULL, 0x0005e20000200c00ULL,
0x00000100621e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011423ULL,
0x0001000062627824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x00000100631f7824ULL, 0x044fe200078e00ffULL, 0x0000001e009c7306ULL, 0x0003e20000200c00ULL,
0x0001000063637824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe40000011428ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff637819ULL, 0x000fe40000011463ULL,
0x0000001f009e7306ULL, 0x0005e20000200c00ULL, 0x00000100341e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001142bULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011429ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000063009a7306ULL, 0x000fe20000200c00ULL, 0x00000100351f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011424ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000001e00967306ULL, 0x0003e20000200c00ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x00000018ff687819ULL, 0x000fe4000001142aULL, 0x00000018ff6a7819ULL, 0x000fe40000011425ULL,
0x00000018ff2c7819ULL, 0x000fe20000011426ULL, 0x0000001f00987306ULL, 0x0005e20000200c00ULL,
0x00000100361e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011427ULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff637819ULL, 0x000fe4000001141eULL,
0x00000007301e7812ULL, 0x000fe200078e7897ULL, 0x00000100371f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000006200997306ULL, 0x000fe20000200c00ULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x00000008971e7824ULL, 0x000fe200078e021eULL,
0x00000018ff8c7819ULL, 0x000fe4000001141fULL, 0x0000001dff1f723eULL, 0x000fc400000000ffULL,
0x000120001e307811ULL, 0x000fe200078e20ffULL, 0x0000003600627306ULL, 0x0003e20000200c00ULL,
0x00000018ff377819ULL, 0x000fc80000011437ULL, 0x000000003030783bULL, 0x000fe60000000200ULL,
0x00000035008e7306ULL, 0x0005e20000200c00ULL, 0x000054101f367816ULL, 0x002fe4000000001fULL,
0x00000008391f7810ULL, 0x000fc60007ffe0ffULL, 0x00001f3936397589ULL, 0x000e6400000e0000ULL,
0x000000cc00cc7306ULL, 0x000ee20000200c00ULL, 0x00009910c5357816ULL, 0x004fe200000000ffULL,
0x00001f1f36387589ULL, 0x000ea600000e0000ULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x0000010021357824ULL, 0x000fe400078e00ffULL, 0x000000d000d07306ULL, 0x000f260000200c00ULL,
0x00000018ff357819ULL, 0x000fca0000011435ULL, 0x0000005500b37306ULL, 0x0003f00000200c00ULL,
0x0000005700aa7306ULL, 0x0005e20000200c00ULL, 0x0000888020557816ULL, 0x002fe200000000ffULL,
0x0000003930308232ULL, 0x000fc40000000000ULL, 0x0000003932328232ULL, 0x000fc80000000000ULL,
0x00000034008d7306ULL, 0x0003e20000200c00ULL, 0x0000888021577816ULL, 0x044fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000003831318232ULL, 0x080fe40000000000ULL,
0x0000003833338232ULL, 0x000fe40000000000ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x0000010020347824ULL, 0x042fe400078e00ffULL,
0x0001000020207824ULL, 0x000fc600078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000003a00b87306ULL, 0x000ff00000200c00ULL,
0x0000003b00b97306ULL, 0x000ff00000200c00ULL, 0x00000020003a7306ULL, 0x0007f00000200c00ULL,
0x00000021003b7306ULL, 0x0009e20000200c00ULL, 0x00005410cc207816ULL, 0x008fce00000000cfULL,
0x000000c800c87306ULL, 0x000e620000200c00ULL, 0x00005410d0217816ULL, 0x010fce00000000d1ULL,
0x000000ca00ca7306ULL, 0x000fe20000200c00ULL, 0x000000203044723cULL, 0x000fee0000001844ULL,
0x0000005600ab7306ULL, 0x000fe20000200c00ULL, 0x00005410c9207816ULL, 0x000fe40000000090ULL,
0x00005410ce217816ULL, 0x004fc40000000089ULL, 0x0000888023897816ULL, 0x000fc600000000ffULL,
0x0000003400567306ULL, 0x0005e40000200c00ULL, 0x000000203040723cULL, 0x000fec0000001840ULL,
0x0000009200927306ULL, 0x000ee20000200c00ULL, 0x0000000200347811ULL, 0x004fe200078fe0ffULL,
0x0000010023217824ULL, 0x000fc600078e00ffULL, 0x0000000734347812ULL, 0x000fe400078e7897ULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x0000009300937306ULL, 0x000ea40000200c00ULL,
0x0000000897207824ULL, 0x000fe200078e0234ULL, 0x00005410c8347816ULL, 0x002fc800000000cbULL,
0x0001200020367811ULL, 0x000fe200078e20ffULL, 0x0000006000a17306ULL, 0x000fe20000200c00ULL,
0x00005410c7927816ULL, 0x008fce0000000092ULL, 0x0000003500607306ULL, 0x0003e20000200c00ULL,
0x00005410c6937816ULL, 0x004fce0000000093ULL, 0x0000006100a27306ULL, 0x0005e20000200c00ULL,
0x0000010022357824ULL, 0x002fe200078e00ffULL, 0x000000923048723cULL, 0x000fec0000001848ULL,
0x000000c200c27306ULL, 0x000e620000200c00ULL, 0x00000018ff617819ULL, 0x004fe40000011435ULL,
0x00005410ca357816ULL, 0x000fca00000000cdULL, 0x000000c100c17306ULL, 0x000ea40000200c00ULL,
0x00000034303c723cULL, 0x000fec000000183cULL, 0x0000003700867306ULL, 0x0007e20000200c00ULL,
0x00005410c2927816ULL, 0x002fce00000000c3ULL, 0x000000be00be7306ULL, 0x000fe20000200c00ULL,
0x000000003634783bULL, 0x008e620000000200ULL, 0x00005410c1937816ULL, 0x004fcc00000000c4ULL,
0x000000a300a37306ULL, 0x000ea20000200c00ULL, 0x00000092304c723cULL, 0x000fee000000184cULL,
0x0000005400b27306ULL, 0x0007e20000200c00ULL, 0x0001000023937824ULL, 0x000fce00078e00ffULL,
0x000000bb00bb7306ULL, 0x000f220000200c00ULL, 0x0000888022547816ULL, 0x048fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00005410c0237816ULL, 0x004fe400000000a3ULL,
0x00000018ffa37819ULL, 0x000fe40000011493ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x000000ba00ba7306ULL, 0x000ea20000200c00ULL, 0x0000888028937816ULL, 0x000fce00000000ffULL,
0x0000002200927306ULL, 0x0007e20000200c00ULL, 0x0000003934348232ULL, 0x082fe40000000000ULL,
0x0000003936368232ULL, 0x000fe40000000000ULL, 0x0000003835358232ULL, 0x080fe40000000000ULL,
0x0000003837378232ULL, 0x000fe20000000000ULL, 0x000000a900a97306ULL, 0x000e620000200c00ULL,
0x00005410bf227816ULL, 0x008fce00000000beULL, 0x000000a800a87306ULL, 0x000ee20000200c00ULL,
0x00000022305c723cULL, 0x000fee000000185cULL, 0x000000b400b47306ULL, 0x000e620000200c00ULL,
0x00005410bb227816ULL, 0x010fe400000000bcULL, 0x00005410ba237816ULL, 0x004fca00000000bdULL,
0x000000b500b57306ULL, 0x000ea40000200c00ULL, 0x000000223058723cULL, 0x000fec0000001858ULL,
0x000000ad00ad7306ULL, 0x000f220000200c00ULL, 0x00005410b8227816ULL, 0x002fe400000000a9ULL,
0x00005410b9237816ULL, 0x008fc400000000a8ULL, 0x0000888029a97816ULL, 0x000fc600000000ffULL,
0x000000ac00ac7306ULL, 0x000e640000200c00ULL, 0x000000223050723cULL, 0x000fec0000001850ULL,
0x0000002100907306ULL, 0x0007e20000200c00ULL, 0x00005410b4227816ULL, 0x000fe200000000b7ULL,
0x0000010029307824ULL, 0x000fe200078e00ffULL, 0x00005410b5237816ULL, 0x004fe200000000b6ULL,
0x0001000029297824ULL, 0x000fc800078e00ffULL, 0x000000af00af7306ULL, 0x000ea20000200c00ULL,
0x0000010028217824ULL, 0x008fe200078e00ffULL, 0x000000223444723cULL, 0x000fe20000001844ULL,
0x00000018ff297819ULL, 0x000fc60000011429ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x000000ae00ae7306ULL, 0x000ee20000200c00ULL, 0x00000018ff237819ULL, 0x000fe40000011430ULL,
0x00005410b2227816ULL, 0x010fe400000000adULL, 0x0000000400307811ULL, 0x000fe400078fe0ffULL,
0x000088802aad7816ULL, 0x000fe200000000ffULL, 0x0000002100a87306ULL, 0x0009e20000200c00ULL,
0x0000000730307812ULL, 0x000fce00078e7897ULL, 0x000000a000a07306ULL, 0x000e620000200c00ULL,
0x0001000028217824ULL, 0x010fce00078e00ffULL, 0x0000002300287306ULL, 0x0003f00000200c00ULL,
0x0000009f009f7306ULL, 0x000f220000200c00ULL, 0x00005410b3237816ULL, 0x002fe400000000acULL,
0x00000018ffac7819ULL, 0x000fe20000011421ULL, 0x0000000897217824ULL, 0x000fc800078e0230ULL,
0x000000223440723cULL, 0x000fe20000001840ULL, 0x000000a700a77306ULL, 0x000e620000200c00ULL,
0x0001200021307811ULL, 0x000fca00078e20ffULL, 0x00005410af227816ULL, 0x004fe200000000b0ULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x000000a500a57306ULL, 0x000e620000200c00ULL,
0x00005410ae237816ULL, 0x008fce00000000b1ULL, 0x00000022343c723cULL, 0x000fe2000000183cULL,
0x0000009400947306ULL, 0x000eec0000200c00ULL, 0x00005410ab227816ULL, 0x000fe200000000a0ULL,
0x000001002aa07824ULL, 0x000fe200078e00ffULL, 0x0000008f008f7306ULL, 0x000ea20000200c00ULL,
0x00005410aa237816ULL, 0x010fe2000000009fULL, 0x000000ffff9f7224ULL, 0x000fc400078e00adULL,
0x00000018ffa07819ULL, 0x000fc800000114a0ULL, 0x000000223448723cULL, 0x000fe20000001848ULL,
0x0000009d009d7306ULL, 0x000f2c0000200c00ULL, 0x00005410a7227816ULL, 0x002fe400000000a4ULL,
0x0000009b009b7306ULL, 0x000e620000200c00ULL, 0x00005410a5237816ULL, 0x000fc400000000a6ULL,
0x000088802ba47816ULL, 0x000fe200000000ffULL, 0x0000003930308232ULL, 0x084fe40000000000ULL,
0x0000003932328232ULL, 0x000fe40000000000ULL, 0x00000022344c723cULL, 0x000fe2000000184cULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x0000003831318232ULL, 0x080fe40000000000ULL,
0x0000003833338232ULL, 0x000fc60000000000ULL, 0x00005410a1227816ULL, 0x008fe20000000094ULL,
0x000001002b947824ULL, 0x040fe200078e00ffULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00005410a2237816ULL, 0x000fe2000000008fULL, 0x000100002b2b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff8f7224ULL, 0x000fc600078e00a4ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x00000022345c723cULL, 0x000fe2000000185cULL, 0x0000008400847306ULL, 0x000eac0000200c00ULL,
0x000054109d227816ULL, 0x010fe4000000009cULL, 0x000054109b237816ULL, 0x002fe2000000009eULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x00000018ff9b7819ULL, 0x000fe20000011494ULL,
0x000100002a947824ULL, 0x000fc800078e00ffULL, 0x000000223458723cULL, 0x000fe20000001858ULL,
0x000054108d847816ULL, 0x004fe20000000084ULL, 0x0000008a008a7306ULL, 0x000fea0000200c00ULL,
0x0000541099227816ULL, 0x000fe40000000088ULL, 0x000054109a237816ULL, 0x000fe20000000087ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x0000000600887811ULL, 0x000fc400078fe0ffULL,
0x000054108e857816ULL, 0x002fe40000000085ULL, 0x0000888024877816ULL, 0x000fe200000000ffULL,
0x000000223434723cULL, 0x000fe40000001850ULL, 0x0000008b008b7306ULL, 0x000fea0000200c00ULL,
0x0000000788227812ULL, 0x000fe200078e7897ULL, 0x0000010024517824ULL, 0x000fe200078e00ffULL,
0x000000843040723cULL, 0x000fe20000001840ULL, 0x0000002b00887306ULL, 0x0003e20000200c00ULL,
0x000054108a8a7816ULL, 0x004fe20000000063ULL, 0x0000000897227824ULL, 0x000fe200078e0222ULL,
0x00000018ff237819ULL, 0x000fe20000011494ULL, 0x0001000024247824ULL, 0x000fc400078e00ffULL,
0x0000888025857816ULL, 0x040fe400000000ffULL, 0x0001200022507811ULL, 0x000fe200078e20ffULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff2b7819ULL, 0x002fe20000011451ULL,
0x000000ffff637224ULL, 0x000fe200078e0085ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000010025857824ULL, 0x040fe200078e00ffULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x00000018ff257819ULL, 0x000fca0000011425ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000054108b8b7816ULL, 0x004fce000000008cULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x0000008a303c723cULL, 0x000fe2000000183cULL,
0x0000541062627816ULL, 0x008fcc0000000081ULL, 0x0000005700577306ULL, 0x000ef00000200c00ULL,
0x0000006f006f7306ULL, 0x000f220000200c00ULL, 0x0000541055567816ULL, 0x004fe20000000056ULL,
0x0000003950508232ULL, 0x002fc40000000000ULL, 0x0000003952528232ULL, 0x000fc80000000000ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x0000541057577816ULL, 0x008fe20000000060ULL,
0x0000003851518232ULL, 0x080fe40000000000ULL, 0x0000003853538232ULL, 0x000fc80000000000ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00000056304c723cULL, 0x000fe2000000184cULL,
0x000054103a3a7816ULL, 0x010fcc000000006fULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000054103b3b7816ULL, 0x002fce0000000080ULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000541092a27816ULL, 0x004fe2000000006dULL, 0x0000003a305c723cULL, 0x000fec000000185cULL,
0x0000009500957306ULL, 0x000eb00000200c00ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541091947816ULL, 0x002fce0000000096ULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x0000541095957816ULL, 0x004fce0000000098ULL, 0x0000008900897306ULL, 0x000ea20000200c00ULL,
0x000000943044723cULL, 0x000fee0000001844ULL, 0x000000a300a37306ULL, 0x000ee20000200c00ULL,
0x0000541054547816ULL, 0x002fce0000000061ULL, 0x000000a900a97306ULL, 0x000e620000200c00ULL,
0x0000541089557816ULL, 0x004fce0000000090ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x00005410a3a37816ULL, 0x008fe2000000006eULL, 0x000000543058723cULL, 0x040fec0000001858ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410a9a97816ULL, 0x002fe20000000028ULL,
0x000000a23034723cULL, 0x000fec0000001834ULL, 0x000000ac00ac7306ULL, 0x000e700000200c00ULL,
0x0000002900297306ULL, 0x000eb00000200c00ULL, 0x00000063008a7306ULL, 0x0007e20000200c00ULL,
0x00005410ac287816ULL, 0x002fce000000002dULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541086637816ULL, 0x008fe40000000083ULL, 0x0000541029297816ULL, 0x004fca000000006cULL,
0x000000623048723cULL, 0x000fe20000001848ULL, 0x0000006b006b7306ULL, 0x000e6e0000200c00ULL,
0x000000285040723cULL, 0x000fe20000001840ULL, 0x0000002300237306ULL, 0x000eb00000200c00ULL,
0x0000002400567306ULL, 0x0007f00000200c00ULL, 0x0000002500577306ULL, 0x0009e20000200c00ULL,
0x0000888026247816ULL, 0x008fce00000000ffULL, 0x0000002400397306ULL, 0x0007e20000200c00ULL,
0x0000888027257816ULL, 0x010fce00000000ffULL, 0x0000002500317306ULL, 0x0009e20000200c00ULL,
0x0000010027247824ULL, 0x008fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000002b00847306ULL, 0x0007e20000200c00ULL, 0x0001000027257824ULL, 0x010fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011425ULL, 0x0000002400287306ULL, 0x0005220000200c00ULL,
0x00000100262b7824ULL, 0x008fe200078e00ffULL, 0x0000541088257816ULL, 0x002fe2000000006bULL,
0x0001000026267824ULL, 0x000fc600078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000541023247816ULL, 0x004fe40000000068ULL, 0x0000541031317816ULL, 0x010fca0000000028ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x000000245048723cULL, 0x000fee0000001848ULL,
0x0000009300937306ULL, 0x000ee20000200c00ULL, 0x0000541056567816ULL, 0x002fce0000000067ULL,
0x0000009f009f7306ULL, 0x000fe20000200c00ULL, 0x0000541057577816ULL, 0x004fce000000006aULL,
0x000000a000a07306ULL, 0x000e620000200c00ULL, 0x0000541093a87816ULL, 0x008fe200000000a8ULL,
0x00000056505c723cULL, 0x040fec000000185cULL, 0x0000008f008f7306ULL, 0x000fe40000200c00ULL,
0x000000a85044723cULL, 0x000fec0000001844ULL, 0x0000009b002a7306ULL, 0x000ea20000200c00ULL,
0x000054109f8e7816ULL, 0x002fce00000000a0ULL, 0x0000008700877306ULL, 0x000e700000200c00ULL,
0x0000008500857306ULL, 0x000ee20000200c00ULL, 0x000054108f8f7816ULL, 0x004fce000000002aULL,
0x0000002b00307306ULL, 0x000ea20000200c00ULL, 0x0000541087847816ULL, 0x002fe20000000084ULL,
0x0000008e503c723cULL, 0x000fec000000183cULL, 0x0000002c002c7306ULL, 0x000fe20000200c00ULL,
0x000054108a857816ULL, 0x008fce0000000085ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000541039307816ULL, 0x004fe20000000030ULL, 0x00000084504c723cULL, 0x040fec000000184cULL,
0x0000002600277306ULL, 0x000e640000200c00ULL, 0x000000305058723cULL, 0x000fec0000001858ULL,
0x0000002900247306ULL, 0x000ea20000200c00ULL, 0x00005410272c7816ULL, 0x002fc4000000002cULL,
0x00005410242d7816ULL, 0x004fce0000000069ULL, 0x0000002c5050723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff66ff7812ULL, 0x000fe2000782c0ffULL, 0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000004078237811ULL, 0x000fe400078e40ffULL, 0x00000001ff547807ULL, 0x000fe40000800000ULL,
0x000000237400720cULL, 0x000fe40003f24070ULL, 0x000000ff65ff7812ULL, 0x000fc4000784c0ffULL,
0x000000010700780cULL, 0x000fe40003f05270ULL, 0x00000001ff237807ULL, 0x000fe40001000000ULL,
0x0000006654667207ULL, 0x000fe40004000000ULL, 0x0000000164647812ULL, 0x000fe400078e0cffULL,
0x0000761023657816ULL, 0x000fe20000000065ULL, 0x000084c000009947ULL, 0x000fea0003800000ULL,
0x01c65c00ff257984ULL, 0x000e620000000800ULL, 0x8000000023247824ULL, 0x000fca00078e00ffULL,
0x8000000025ff7812ULL, 0x002fe20007824824ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff247424ULL, 0x000fe400078e00ffULL,
0x8000000023267824ULL, 0x000fe400078e00ffULL, 0x0000002400257305ULL, 0x0002a4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007824826ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000004ff277424ULL, 0x000fe200078e00ffULL, 0x0000000382257812ULL, 0x000fe200078ec0ffULL,
0x00000300ff267624ULL, 0x000fe400078e00ffULL, 0x0000000472327e24ULL, 0x020fe2000f8e022fULL,
0x000000032500780cULL, 0x000fe20003f25270ULL, 0xfffffffd27247424ULL, 0x000fe200078e0226ULL,
0xfffffffd26817811ULL, 0x000fe200078e10ffULL, 0xffffffffff727424ULL, 0x000fc600078e00ffULL,
0x0000000124257807ULL, 0x000fca0004800000ULL, 0x0000000182827824ULL, 0x000fca00078e0225ULL,
0x0000000382247812ULL, 0x000fc800078ec0ffULL, 0x000000032400780cULL, 0x000fc80003f25270ULL,
0x0000000181817807ULL, 0x000fca0004800000ULL, 0x0000000182707824ULL, 0x000fca00078e0281ULL,
0x000000757000720cULL, 0x000fe20003f26070ULL, 0x00000100ff377424ULL, 0x000fe200078e00ffULL,
0x0000008078297811ULL, 0x000fe400078e40ffULL, 0x0000003f32267812ULL, 0x000fe400078ef809ULL,
0x00000001782a7810ULL, 0x000fce0007ffe0ffULL, 0x0000008105249210ULL, 0x000fca0007ffe082ULL,
0x0000600024249625ULL, 0x000fe200078e0027ULL, 0x0000002974287217ULL, 0x000fc60007800000ULL,
0x00005e0026267625ULL, 0x000fe200078e0037ULL, 0x0000000624729981ULL, 0x000362000c1e1900ULL,
0x000000732a00720cULL, 0x000fe40003f26070ULL, 0x0000003f322a7812ULL, 0x000fe200078ef80bULL,
0x0000000128337824ULL, 0x000fe200078e0a29ULL, 0x0000003f322c7812ULL, 0x000fe400078ef80cULL,
0x0000000a26267210ULL, 0x000fe40007f5e0ffULL, 0x0000003f32287812ULL, 0x000fe200078ef80dULL,
0x00005e002a247625ULL, 0x002fe200078e0037ULL, 0x0000003f32307812ULL, 0x000fc400078ef80eULL,
0x0000003f32347812ULL, 0x000fe200078ef810ULL, 0x00005e002c2a7625ULL, 0x080fe200078e0037ULL,
0x0000003f32367812ULL, 0x000fe400078ef811ULL, 0x00000004ff577819ULL, 0x000fe20000011600ULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x0000000a2a2a7210ULL, 0x080fe20007f7e0ffULL,
0x00005e00282c7625ULL, 0x080fe200078e0037ULL, 0x0000000a24287210ULL, 0x000fe40007f5e0ffULL,
0x0000003f32247812ULL, 0x000fe200078ef80fULL, 0x00005e0030307625ULL, 0x000fe200078e0037ULL,
0x0000000457397810ULL, 0x000fc40007ffe0ffULL, 0x00000008573b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff297224ULL, 0x000fe200010e0625ULL, 0x0000000a2c2c7210ULL, 0x080fe20007f5e0ffULL,
0x00005e0024247625ULL, 0x080fe200078e0037ULL, 0x0000000a57557810ULL, 0x040fe40007ffe0ffULL,
0x0000000c57617810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200010e062dULL,
0x0000000a24327210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e062bULL,
0x0000004033247807ULL, 0x000fe20000800000ULL, 0x00005e0034347625ULL, 0x000fe200078e0037ULL,
0x0000000a30307210ULL, 0x000fc40007f7e0ffULL, 0x0000002471247217ULL, 0x000fe20007800000ULL,
0x000000ffff337224ULL, 0x000fe200010e0625ULL, 0x0000000257257810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff317224ULL, 0x000fe200018e0631ULL, 0x0000000a34347210ULL, 0x000fe20007f3e0ffULL,
0x0000000124387824ULL, 0x000fe200078e0a71ULL, 0x0000000e57637810ULL, 0x000fe20007ffe0ffULL,
0x0000400007247824ULL, 0x000fe400078e00ffULL, 0x00005e0036367625ULL, 0x000fe200078e0037ULL,
0x000000382500720cULL, 0x000fc40003fa6070ULL, 0x0000400024807812ULL, 0x000fe200078ec0ffULL,
0x0000000807257824ULL, 0x000fe200078e00ffULL, 0x000000385700720cULL, 0x080fe20003f86070ULL,
0x000000ffff357224ULL, 0x000fe200008e0635ULL, 0x000000383900720cULL, 0x000fe40003f66070ULL,
0x00000008253a7812ULL, 0x000fe400078ec0ffULL, 0x0000000657397810ULL, 0x000fe40007ffe0ffULL,
0x0001400080807810ULL, 0x000fe20007ffe0ffULL, 0x000000003a0573c2ULL, 0x000e6200000e0000ULL,
0x0000000a36367210ULL, 0x000fc40007f5e0ffULL, 0x000000383900720cULL, 0x080fe20003f26070ULL,
0x0000001012397824ULL, 0x100fe400078e0280ULL, 0x000000ffff377224ULL, 0x000fe200010e0637ULL,
0x000000383b00720cULL, 0x080fe20003f46070ULL, 0x00000010133b7824ULL, 0x100fe200078e0280ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026397faeULL, 0x0005e2000e101c46ULL,
0x000000385500720cULL, 0x080fe20003f86070ULL, 0x0000001015557824ULL, 0x100fe400078e0280ULL,
0x00000000283b7faeULL, 0x0007e2000e901c46ULL, 0x000000386100720cULL, 0x000fe20003fa6070ULL,
0x0000001016577824ULL, 0x000fc400078e0280ULL, 0x000000002a557faeULL, 0x0009e2000d901c46ULL,
0x000000386300720cULL, 0x000fe20003f66070ULL, 0x0000001017617824ULL, 0x100fe400078e0280ULL,
0x0000001018277824ULL, 0x104fe200078e0280ULL, 0x000000002c577faeULL, 0x0009e2000c901c46ULL,
0x000000101a397824ULL, 0x100fe200078e0280ULL, 0x0001c64805057890ULL, 0x002fe2000fffe03fULL,
0x0000001019297824ULL, 0x008fe200078e0280ULL, 0x0000000030617faeULL, 0x0009e2000d101c46ULL,
0x0001c64814287811ULL, 0x000fc600078e18ffULL, 0x0000000032277faeULL, 0x0009e8000e101c46ULL,
0x0000000034297faeULL, 0x0009e8000e901c46ULL, 0x0000000036397faeULL, 0x0009e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040028287984ULL, 0x000e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c61c00ff277984ULL, 0x010ea20000000800ULL,
0x0000000354267207ULL, 0x000fe20004000000ULL, 0x800000001b2a7824ULL, 0x000fc600078e00ffULL,
0x0000ffff26037812ULL, 0x000fc800078ec0ffULL, 0x00008880032b7816ULL, 0x000fca00000000ffULL,
0x800000002b037824ULL, 0x000fca00078e00ffULL, 0x8000000028ff7812ULL, 0x002fe40007804803ULL,
0x8000000027ff7812ULL, 0x004fe2000782482aULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff037424ULL, 0x000fe400078e00ffULL,
0x800000001b287824ULL, 0x000fe400078e00ffULL, 0x0000000300277305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x004fe40003800000ULL,
0x01c61c00ff277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007824828ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01c080001c037984ULL, 0x000e620000000800ULL, 0x00000001ffd47424ULL, 0x000fc600078e00ffULL,
0x01c280001c277984ULL, 0x0004e20000000800ULL, 0x0000002e0300720bULL, 0x002fda0003f3d000ULL,
0x0000000000287806ULL, 0x000fc800008e0100ULL, 0x0000ffff282a7812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x0000002e0300720bULL, 0x00cfe40003f34000ULL,
0x000000032e317209ULL, 0x000fe40007810000ULL, 0x00000002ff2c7819ULL, 0x000fc60000011600ULL,
0x800000312e287221ULL, 0x100fe40000010000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0031ULL,
0x3fb8aa3b28297820ULL, 0x000fe40000410000ULL, 0x0000000000287806ULL, 0x000fe400008e0100ULL,
0x000000017600780cULL, 0x000fe40003f25270ULL, 0x0000ffff282d7812ULL, 0x000fe200078e3cffULL,
0x0000002900297308ULL, 0x000e660000000800ULL, 0x0000002d2aff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ffd47807ULL, 0x000fc60001000000ULL, 0x01c480311c009388ULL, 0x000fec0000000800ULL,
0x80000031032a2221ULL, 0x000fe20000010000ULL, 0x00001f2c29287589ULL, 0x002e6200000e0000ULL,
0x0000002902027220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2a2a2820ULL, 0x000fe20000410000ULL,
0x00001f1f29037589ULL, 0x000ea600000e0000ULL, 0x0000002a001d2308ULL, 0x000ee40000000800ULL,
0x000000271d272220ULL, 0x008fc40000410000ULL, 0x0000002844447220ULL, 0x082fe40000410000ULL,
0x0000002845457220ULL, 0x080fe40000410000ULL, 0x0000002840407220ULL, 0x080fe40000410000ULL,
0x0000002841417220ULL, 0x080fe40000410000ULL, 0x000000283c3c7220ULL, 0x080fe40000410000ULL,
0x000000283d3d7220ULL, 0x000fc40000410000ULL, 0x0000002848487220ULL, 0x080fe40000410000ULL,
0x0000002849497220ULL, 0x080fe40000410000ULL, 0x000000284c4c7220ULL, 0x080fe40000410000ULL,
0x000000284d4d7220ULL, 0x080fe40000410000ULL, 0x000000285c5c7220ULL, 0x080fe40000410000ULL,
0x000000285d5d7220ULL, 0x000fc40000410000ULL, 0x0000002858587220ULL, 0x080fe40000410000ULL,
0x0000002859597220ULL, 0x080fe40000410000ULL, 0x0000002850507220ULL, 0x080fe40000410000ULL,
0x0000002851517220ULL, 0x000fe40000410000ULL, 0x0000000346467220ULL, 0x084fe40000410000ULL,
0x0000000347477220ULL, 0x000fc40000410000ULL, 0x0000000342427220ULL, 0x080fe40000410000ULL,
0x0000000343437220ULL, 0x080fe40000410000ULL, 0x000000033e3e7220ULL, 0x080fe40000410000ULL,
0x000000033f3f7220ULL, 0x080fe40000410000ULL, 0x000000034a4a7220ULL, 0x080fe40000410000ULL,
0x000000034b4b7220ULL, 0x000fc40000410000ULL, 0x000000034e4e7220ULL, 0x080fe40000410000ULL,
0x000000034f4f7220ULL, 0x080fe40000410000ULL, 0x000000035e5e7220ULL, 0x080fe40000410000ULL,
0x000000035f5f7220ULL, 0x080fe40000410000ULL, 0x000000035a5a7220ULL, 0x080fe40000410000ULL,
0x000000035b5b7220ULL, 0x000fc40000410000ULL, 0x0000000352527220ULL, 0x080fe40000410000ULL,
0x0000000353537220ULL, 0x000fe40000410000ULL, 0x0000000227027221ULL, 0x00cfe20000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x0001c64814287811ULL, 0x000fe200078e18ffULL,
0x800000002b2a7824ULL, 0x000fc800078e00ffULL, 0x0000040028037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780482aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002b2a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff037424ULL, 0x000fc800078e00ffULL, 0x0000000300277305ULL, 0x0002a4000021f000ULL,
0x3fa0000003037823ULL, 0x002fe200000100ffULL, 0x000000270000735dULL, 0x004fe40003800000ULL,
0x0000040028277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc4000780482aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000107847812ULL, 0x000fc800078e0cffULL, 0x0001400084847811ULL, 0x000fca00078e70ffULL,
0x000000107f277824ULL, 0x100fe400078e0284ULL, 0x000000107e287824ULL, 0x100fe400078e0284ULL,
0x000000107d297824ULL, 0x100fe200078e0284ULL, 0x000000002754783bULL, 0x000e620000004200ULL,
0x000000107c2a7824ULL, 0x100fe400078e0284ULL, 0x000000107b2b7824ULL, 0x100fe200078e0284ULL,
0x000000002864783bULL, 0x000fe20000004200ULL, 0x000000107a2c7824ULL, 0x000fc400078e0284ULL,
0x00000010792d7824ULL, 0x100fe200078e0284ULL, 0x000000002968783bULL, 0x000fe20000004200ULL,
0x0000001077037824ULL, 0x000fc600078e0284ULL, 0x000000002a6c783bULL, 0x000fe80000004200ULL,
0x000000002b30783bULL, 0x000ea80000004200ULL, 0x000000002c60783bULL, 0x000ee80000004200ULL,
0x000000002d38783bULL, 0x000f280000004200ULL, 0x000000000334783bULL, 0x000ee20000004200ULL,
0x00000018ffd27819ULL, 0x002fe20000011454ULL, 0x0000010054987824ULL, 0x040fe200078e00ffULL,
0x0000888054d67816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ffd07819ULL, 0x000fe20000011455ULL, 0x0000010055997824ULL, 0x040fe200078e00ffULL,
0x0000888055dc7816ULL, 0x040fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000d600d67306ULL, 0x000fe20000200c00ULL,
0x00000018ff987819ULL, 0x000fc40000011498ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff967819ULL, 0x000fe40000011456ULL, 0x00000018ff927819ULL, 0x004fe20000011430ULL,
0x0000005400d57306ULL, 0x0003e20000200c00ULL, 0x00008880309c7816ULL, 0x000fe400000000ffULL,
0x00000018ff977819ULL, 0x000fe40000011457ULL, 0x0000888056d37816ULL, 0x000fc400000000ffULL,
0x0000888057d77816ULL, 0x000fe200000000ffULL, 0x0000005500db7306ULL, 0x0005e20000200c00ULL,
0x0000010056547824ULL, 0x042fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fe2000001146eULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x000088806ea97816ULL, 0x000fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000009800d97306ULL, 0x0002e20000200c00ULL,
0x0000010065557824ULL, 0x004fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400d87306ULL, 0x0005e20000200c00ULL, 0x0000010057987824ULL, 0x042fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe2000001146dULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x000088806daf7816ULL, 0x000fe400000000ffULL, 0x00000018ffac7819ULL, 0x000fc40000011465ULL,
0x0000005500cf7306ULL, 0x0003e20000200c00ULL, 0x0000010064547824ULL, 0x004fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000888065cc7816ULL, 0x040fe200000000ffULL,
0x0001000065657824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000009900dd7306ULL, 0x0005e20000200c00ULL, 0x0000010067557824ULL, 0x002fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fc40000011432ULL, 0x00000018ffc97819ULL, 0x000fe40000011464ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005400ce7306ULL, 0x0003e20000200c00ULL,
0x0000888032997816ULL, 0x004fe400000000ffULL, 0x0000888064cd7816ULL, 0x040fe200000000ffULL,
0x0001000064647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff937819ULL, 0x000fe20000011431ULL, 0x0000005500c87306ULL, 0x0005e20000200c00ULL,
0x0000010066547824ULL, 0x002fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc40000011464ULL,
0x00008880319e7816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005600d17306ULL, 0x000fe20000200c00ULL, 0x0000010069557824ULL, 0x044fe200078e00ffULL,
0x00000018ffb67819ULL, 0x000fe40000011469ULL, 0x0000888069be7816ULL, 0x040fe200000000ffULL,
0x0001000069697824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x0000005400c77306ULL, 0x0003e20000200c00ULL, 0x00000018ffab7819ULL, 0x000fe4000001146aULL,
0x000088806abb7816ULL, 0x000fe400000000ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ffb37819ULL, 0x000fe20000011467ULL, 0x0000005500c17306ULL, 0x0005e20000200c00ULL,
0x0000010068547824ULL, 0x002fe200078e00ffULL, 0x00000018ffb77819ULL, 0x000fc40000011468ULL,
0x0000888067c57816ULL, 0x040fe200000000ffULL, 0x0001000067677824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005700a07306ULL, 0x000fe20000200c00ULL,
0x000001006b557824ULL, 0x004fe200078e00ffULL, 0x0000888068bf7816ULL, 0x040fe200000000ffULL,
0x0001000068687824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x008fe40000011460ULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x0000005400c27306ULL, 0x0003e20000200c00ULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ff987819ULL, 0x000fe40000011498ULL, 0x00000018ff8f7819ULL, 0x000fe20000011461ULL,
0x0000005500b97306ULL, 0x0005e20000200c00ULL, 0x000001006a547824ULL, 0x042fe200078e00ffULL,
0x00000018ffa37819ULL, 0x000fe2000001146cULL, 0x000100006a6a7824ULL, 0x000fe200078e00ffULL,
0x000088806cb27816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006500cb7306ULL, 0x0003e20000200c00ULL, 0x000001006d557824ULL, 0x044fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x000100006d6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe40000011433ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400ba7306ULL, 0x0005e20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fc4000001146dULL,
0x00000002ff657819ULL, 0x002fe40000011600ULL, 0x00000018ffaa7819ULL, 0x000fe4000001146bULL,
0x000088806bb87816ULL, 0x040fe200000000ffULL, 0x0000005500b07306ULL, 0x0003e20000200c00ULL,
0x000001006c547824ULL, 0x044fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fe20000011466ULL,
0x000100006c6c7824ULL, 0x000fe200078e00ffULL, 0x0000888066c67816ULL, 0x040fe200000000ffULL,
0x000100006b6b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0001000066667824ULL, 0x000fe200078e00ffULL, 0x0000006d00ad7306ULL, 0x000fe20000200c00ULL,
0x000001006f557824ULL, 0x002fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001146cULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400b17306ULL, 0x0003e20000200c00ULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff957819ULL, 0x000fe4000001146fULL, 0x000088806fa67816ULL, 0x040fe200000000ffULL,
0x000100006f6f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe20000011462ULL,
0x0000005500a77306ULL, 0x0005e20000200c00ULL, 0x000001006e547824ULL, 0x042fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011463ULL, 0x000100006e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001146fULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000010031557824ULL, 0x044fe200078e00ffULL,
0x0000005400a87306ULL, 0x0003e20000200c00ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x010fe40000011438ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x00000055009f7306ULL, 0x0005e20000200c00ULL,
0x0000010030547824ULL, 0x042fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011439ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe4000001143aULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000010033557824ULL, 0x004fe200078e00ffULL, 0x0000005400a17306ULL, 0x0003e20000200c00ULL,
0x00000018ff877819ULL, 0x000fc4000001143bULL, 0x00000018ff887819ULL, 0x000fe40000011434ULL,
0x00000018ff9b7819ULL, 0x000fe40000011455ULL, 0x00000018ff897819ULL, 0x000fe20000011435ULL,
0x00000030009d7306ULL, 0x0005e20000200c00ULL, 0x000128001e547811ULL, 0x002fe400078e20ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011436ULL, 0x00000018ff8b7819ULL, 0x000fc40000011437ULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0x0000006e00a57306ULL, 0x000fe20000200c00ULL,
0x0000010032307824ULL, 0x044fe400078e00ffULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006400ca7306ULL, 0x000ff00000200c00ULL, 0x00000030006e7306ULL, 0x0003f00000200c00ULL,
0x00000032006d7306ULL, 0x0005e20000200c00ULL, 0x0000001dff30723eULL, 0x002fce00000000ffULL,
0x00000031009a7306ULL, 0x0003e20000200c00ULL, 0x0000541030327816ULL, 0x004fe20000000030ULL,
0x0000010060307824ULL, 0x000fc800078e00ffULL, 0x00001f6532657589ULL, 0x000ea200000e0000ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000dc00dc7306ULL, 0x000ee20000200c00ULL,
0x00009910d4317816ULL, 0x002fe200000000ffULL, 0x00001f1f32647589ULL, 0x00032600000e0000ULL,
0x000000ff3100720cULL, 0x000fe20003f05270ULL, 0x0000010061317824ULL, 0x040fe400078e00ffULL,
0x0000006900bd7306ULL, 0x0007e20000200c00ULL, 0x0001000061327824ULL, 0x002fce00078e00ffULL,
0x000000d200d27306ULL, 0x000e620000200c00ULL, 0x0000888060697816ULL, 0x048fe200000000ffULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006554548232ULL, 0x004fc80000000000ULL, 0x000000d000d07306ULL, 0x000ea20000200c00ULL,
0x0000006556568232ULL, 0x000fe40000000000ULL, 0x0000006455558232ULL, 0x090fe40000000000ULL,
0x0000006457578232ULL, 0x000fc60000000000ULL, 0x0000006a00b47306ULL, 0x0007f00000200c00ULL,
0x0000006700c47306ULL, 0x0009e20000200c00ULL, 0x00000018ff6a7819ULL, 0x008fe40000011431ULL,
0x00000018ff317819ULL, 0x000fca0000011460ULL, 0x0000006800bc7306ULL, 0x000fe20000200c00ULL,
0x0000888061677816ULL, 0x010fce00000000ffULL, 0x0000003000687306ULL, 0x0007f00000200c00ULL,
0x0000003100617306ULL, 0x0009e20000200c00ULL, 0x00005410d6307816ULL, 0x008fce00000000d9ULL,
0x000000d300d37306ULL, 0x000ee20000200c00ULL, 0x00005410dc317816ULL, 0x010fce00000000ddULL,
0x000000d700d77306ULL, 0x000fe20000200c00ULL, 0x000000305444723cULL, 0x000fee0000001844ULL,
0x0000009800da7306ULL, 0x0008e20000200c00ULL, 0x00005410d5307816ULL, 0x002fe400000000d2ULL,
0x00005410db317816ULL, 0x004fe200000000d0ULL, 0x0000010063d07824ULL, 0x000fc800078e00ffULL,
0x0000009600967306ULL, 0x000e620000200c00ULL, 0x0000888033987816ULL, 0x050fe200000000ffULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x000000305440723cULL, 0x000fe80000001840ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000009700977306ULL, 0x000ea40000200c00ULL,
0x00005410d3307816ULL, 0x008fc400000000d8ULL, 0x00005410d7317816ULL, 0x000fc800000000daULL,
0x000000cd00cd7306ULL, 0x000ee20000200c00ULL, 0x00005410d1967816ULL, 0x002fe40000000096ULL,
0x00000030543c723cULL, 0x000fea000000183cULL, 0x000000cc00cc7306ULL, 0x000e620000200c00ULL,
0x00005410a0977816ULL, 0x004fe40000000097ULL, 0x00000018ffa07819ULL, 0x000fca00000114d0ULL,
0x0000006c00ae7306ULL, 0x000fe20000200c00ULL, 0x000000965448723cULL, 0x000fee0000001848ULL,
0x00000033006c7306ULL, 0x0005e20000200c00ULL, 0x00005410cd967816ULL, 0x008fe400000000ceULL,
0x00005410cc977816ULL, 0x002fca00000000cfULL, 0x0000003200607306ULL, 0x0003e20000200c00ULL,
0x0000010062337824ULL, 0x004fe200078e00ffULL, 0x00000096544c723cULL, 0x000fec000000184cULL,
0x0000006b00b57306ULL, 0x0005e20000200c00ULL, 0x0001280020327811ULL, 0x002fe200078e20ffULL,
0x0001000063967824ULL, 0x000fcc00078e00ffULL, 0x000000c900c97306ULL, 0x000fe20000200c00ULL,
0x00000018ff6b7819ULL, 0x004fe40000011433ULL, 0x000000003230783bULL, 0x000e6a0000000200ULL,
0x000000ac00ac7306ULL, 0x000eb00000200c00ULL, 0x0000006600c37306ULL, 0x0007f00000200c00ULL,
0x000000c600c67306ULL, 0x000f220000200c00ULL, 0x0000888062667816ULL, 0x048fe200000000ffULL,
0x0001000062627824ULL, 0x000fca00078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x000000c500c57306ULL, 0x000ef00000200c00ULL, 0x0000006f00a47306ULL, 0x0005e20000200c00ULL,
0x0000006530308232ULL, 0x002fc40000000000ULL, 0x0000006532328232ULL, 0x000fe40000000000ULL,
0x0000006431318232ULL, 0x000fc60000000000ULL, 0x0000006200977306ULL, 0x0003e20000200c00ULL,
0x00008880636f7816ULL, 0x004fe200000000ffULL, 0x0000006433338232ULL, 0x000fe20000000000ULL,
0x00005410cb637816ULL, 0x000fe400000000acULL, 0x00000018ffac7819ULL, 0x000fe40000011496ULL,
0x0000888038967816ULL, 0x000fe200000000ffULL, 0x000000c000c07306ULL, 0x000ea20000200c00ULL,
0x00005410ca627816ULL, 0x002fce00000000c9ULL, 0x000000b300b37306ULL, 0x000e620000200c00ULL,
0x00000062545c723cULL, 0x000fee000000185cULL, 0x000000bf00bf7306ULL, 0x000e620000200c00ULL,
0x00005410c6627816ULL, 0x010fe400000000c7ULL, 0x00005410c5637816ULL, 0x008fe200000000c8ULL,
0x0000010038c57824ULL, 0x000fc400078e00ffULL, 0x0001000038387824ULL, 0x000fe400078e00ffULL,
0x000000be00be7306ULL, 0x000ee20000200c00ULL, 0x00000018ffc57819ULL, 0x000fe200000114c5ULL,
0x000000625458723cULL, 0x000fec0000001858ULL, 0x000000b700b77306ULL, 0x000f220000200c00ULL,
0x00005410c3627816ULL, 0x004fc400000000c0ULL, 0x00005410c4637816ULL, 0x002fca00000000b3ULL,
0x000000b600b67306ULL, 0x000e640000200c00ULL, 0x000000625450723cULL, 0x000fec0000001850ULL,
0x000000bb00bb7306ULL, 0x000ea20000200c00ULL, 0x00005410bf547816ULL, 0x000fe200000000c2ULL,
0x0000010039567824ULL, 0x000fe200078e00ffULL, 0x00005410be557816ULL, 0x008fc400000000c1ULL,
0x0000888039627816ULL, 0x040fe200000000ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ffb37819ULL, 0x000fe20000011456ULL, 0x000000b800b87306ULL, 0x000ee40000200c00ULL,
0x000000543044723cULL, 0x000fe20000001844ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x000000ab00ab7306ULL, 0x000ea20000200c00ULL, 0x00005410bc547816ULL, 0x010fe400000000b7ULL,
0x00005410bd557816ULL, 0x002fe400000000b6ULL, 0x00000018ffb67819ULL, 0x000fe40000011438ULL,
0x0001280021387811ULL, 0x000fe200078e20ffULL, 0x000000aa00aa7306ULL, 0x000e620000200c00ULL,
0x000088803ab77816ULL, 0x000fe200000000ffULL, 0x000000543040723cULL, 0x000fec0000001840ULL,
0x000000b200b27306ULL, 0x000f220000200c00ULL, 0x00005410bb547816ULL, 0x004fc400000000baULL,
0x00005410b8557816ULL, 0x008fca00000000b9ULL, 0x000000af00af7306ULL, 0x000ea40000200c00ULL,
0x000000543054723cULL, 0x000fe2000000183cULL, 0x00000000383c783bULL, 0x0006aa0000000200ULL,
0x0000003900b87306ULL, 0x0003e20000200c00ULL, 0x00005410b4387816ULL, 0x008fe200000000abULL,
0x000001003aab7824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fc800078e00ffULL,
0x000000a300a37306ULL, 0x000ee20000200c00ULL, 0x00005410b5397816ULL, 0x002fe200000000aaULL,
0x000000ffffaa7224ULL, 0x000fe200078e00b7ULL, 0x00000018ffab7819ULL, 0x000fca00000114abULL,
0x000000a200a27306ULL, 0x000e620000200c00ULL, 0x000000383048723cULL, 0x000fee0000001848ULL,
0x000000a900a97306ULL, 0x000e620000200c00ULL, 0x00005410b2387816ULL, 0x010fe400000000b1ULL,
0x00005410af397816ULL, 0x004fc400000000b0ULL, 0x000088803baf7816ULL, 0x000fc600000000ffULL,
0x000000a600a67306ULL, 0x000ea40000200c00ULL, 0x00000038304c723cULL, 0x000fe2000000184cULL,
0x000000653c3c8232ULL, 0x080fe40000000000ULL, 0x000000653e3e8232ULL, 0x000fe40000000000ULL,
0x000000643d3d8232ULL, 0x080fe20000000000ULL, 0x0000009400947306ULL, 0x000f220000200c00ULL,
0x00005410ae387816ULL, 0x008fe200000000a3ULL, 0x000001003ba37824ULL, 0x000fe200078e00ffULL,
0x00005410ad397816ULL, 0x002fe200000000a2ULL, 0x000000643f3f8232ULL, 0x000fe20000000000ULL,
0x000000ffffa27224ULL, 0x000fc400078e00afULL, 0x00000018ffa37819ULL, 0x000fe200000114a3ULL,
0x0000009500957306ULL, 0x000e640000200c00ULL, 0x00000038305c723cULL, 0x000fec000000185cULL,
0x0000009c009c7306ULL, 0x000ee20000200c00ULL, 0x00005410a9387816ULL, 0x000fc400000000a8ULL,
0x00005410a6397816ULL, 0x004fe400000000a7ULL, 0x00005410a5947816ULL, 0x010fc60000000094ULL,
0x0000009e009e7306ULL, 0x000fe20000200c00ULL, 0x00005410a4957816ULL, 0x002fe20000000095ULL,
0x000000383058723cULL, 0x040fec0000001858ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000100003b397824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe2000001143aULL,
0x000000943030723cULL, 0x000fe60000001850ULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x00000038003b7306ULL, 0x0007e40000200c00ULL, 0x0001280022507811ULL, 0x000fe200078e20ffULL,
0x0000010034517824ULL, 0x040fe200078e00ffULL, 0x0000888034947816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000039003a7306ULL, 0x0005e20000200c00ULL,
0x000054109c387816ULL, 0x008fe400000000a1ULL, 0x0000541069687816ULL, 0x002fe40000000068ULL,
0x00000018ff347819ULL, 0x000fc60000011434ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054109e397816ULL, 0x004fce000000009fULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x000000383c44723cULL, 0x000fee0000001844ULL, 0x0000009300937306ULL, 0x000ea20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011451ULL, 0x000000005050783bULL, 0x000eea0000000200ULL,
0x0000009900997306ULL, 0x000f220000200c00ULL, 0x0000541067697816ULL, 0x002fe2000000006aULL,
0x0001000035677824ULL, 0x000fcc00078e00ffULL, 0x0000009800987306ULL, 0x000fe20000200c00ULL,
0x000054109a937816ULL, 0x004fe20000000093ULL, 0x000000683c4c723cULL, 0x000fec000000184cULL,
0x0000009b009b7306ULL, 0x000e620000200c00ULL, 0x00005410999a7816ULL, 0x010fce000000006eULL,
0x0000008f008f7306ULL, 0x000eb00000200c00ULL, 0x0000009200927306ULL, 0x000f220000200c00ULL,
0x00005410989b7816ULL, 0x002fe2000000009bULL, 0x0000006550508232ULL, 0x008fc40000000000ULL,
0x0000006552528232ULL, 0x000fe40000000000ULL, 0x0000006451518232ULL, 0x080fe40000000000ULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x00005410608f7816ULL, 0x004fe2000000008fULL,
0x0000009a3c54723cULL, 0x000fe20000001854ULL, 0x00000018ff607819ULL, 0x000fe20000011467ULL,
0x0000006453538232ULL, 0x000fc80000000000ULL, 0x0000009100917306ULL, 0x000ea20000200c00ULL,
0x000054109d927816ULL, 0x010fce0000000092ULL, 0x0000008e008e7306ULL, 0x000ee20000200c00ULL,
0x000054106d907816ULL, 0x002fe20000000090ULL, 0x000000923c40723cULL, 0x000fec0000001840ULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000054106c917816ULL, 0x004fe40000000091ULL,
0x0000888035927816ULL, 0x000fca00000000ffULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x00005410618e7816ULL, 0x008fe2000000008eULL, 0x000000903c48723cULL, 0x040fe20000001848ULL,
0x000000ffff6e7224ULL, 0x000fe400078e0092ULL, 0x0000010035927824ULL, 0x000fe400078e00ffULL,
0x0000010036617824ULL, 0x000fe200078e00ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410978c7816ULL, 0x002fe2000000008cULL, 0x0000008e3c5c723cULL, 0x000fe2000000185cULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ff617819ULL, 0x000fc60000011461ULL,
0x0000006b006b7306ULL, 0x000e700000200c00ULL, 0x0000006f006f7306ULL, 0x000ff00000200c00ULL,
0x000000a000a07306ULL, 0x000ea20000200c00ULL, 0x0000541066667816ULL, 0x002fce000000006bULL,
0x000000ac00ac7306ULL, 0x000e700000200c00ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000054106f677816ULL, 0x004fce00000000a0ULL, 0x000000b300b37306ULL, 0x000ea20000200c00ULL,
0x00005410ac8d7816ULL, 0x002fe2000000008dULL, 0x000000663c58723cULL, 0x040fec0000001858ULL,
0x0000009600967306ULL, 0x000fe40000200c00ULL, 0x0000008c3c30723cULL, 0x000fec0000001830ULL,
0x000000c500637306ULL, 0x000e620000200c00ULL, 0x00008880373c7816ULL, 0x000fc400000000ffULL,
0x0000541062977816ULL, 0x004fc600000000b3ULL, 0x000000ffff627224ULL, 0x000fe400078e003cULL,
0x000000aa00aa7306ULL, 0x000fe20000200c00ULL, 0x00000100373c7824ULL, 0x000fce00078e00ffULL,
0x000000ab00ab7306ULL, 0x000ea20000200c00ULL, 0x0000541096967816ULL, 0x002fe40000000063ULL,
0x00000018ff637819ULL, 0x000fca000001143cULL, 0x000000a200a27306ULL, 0x000fe20000200c00ULL,
0x000000965044723cULL, 0x000fee0000001844ULL, 0x000000a300a37306ULL, 0x000e620000200c00ULL,
0x00005410aa3c7816ULL, 0x004fce00000000abULL, 0x0000003400357306ULL, 0x0005e20000200c00ULL,
0x00005410a23d7816ULL, 0x002fce00000000a3ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x0000888036347816ULL, 0x044fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000003c503c723cULL, 0x000fe80000001854ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000009400387306ULL, 0x000fe40000200c00ULL, 0x0001000037547824ULL, 0x000fcc00078e00ffULL,
0x0000003900397306ULL, 0x000ea20000200c00ULL, 0x0000541035887816ULL, 0x002fe40000000088ULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000541038387816ULL, 0x004fce0000000039ULL,
0x0000008600867306ULL, 0x000eb00000200c00ULL, 0x0000008700877306ULL, 0x000ee20000200c00ULL,
0x00005410b8b77816ULL, 0x002fce0000000085ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000054103b867816ULL, 0x004fce0000000086ULL, 0x000000b600b67306ULL, 0x000e620000200c00ULL,
0x000054103a877816ULL, 0x008fce0000000087ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000000865048723cULL, 0x000fee0000001848ULL, 0x00000092006d7306ULL, 0x000ea20000200c00ULL,
0x00005410b6b67816ULL, 0x002fce0000000083ULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x000000b65040723cULL, 0x000fee0000001840ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000054106e397816ULL, 0x004fce000000006dULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x0000541060897816ULL, 0x002fe20000000089ULL, 0x00000038504c723cULL, 0x040fec000000184cULL,
0x0000006200627306ULL, 0x000fe40000200c00ULL, 0x00000088505c723cULL, 0x000fec000000185cULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000541034347816ULL, 0x004fce0000000061ULL,
0x0000008a008a7306ULL, 0x000ff00000200c00ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541062357816ULL, 0x002fce0000000063ULL, 0x0000003600377306ULL, 0x000e620000200c00ULL,
0x000000345058723cULL, 0x000fee0000001858ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x00005410378a7816ULL, 0x002fe4000000008aULL, 0x00005410548b7816ULL, 0x004fce000000008bULL,
0x0000008a5050723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff26ff7812ULL, 0x000fe2000784c0ffULL,
0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000008078317811ULL, 0x000fe400078e40ffULL,
0x00000001ff837807ULL, 0x000fe40001000000ULL, 0x000000317400720cULL, 0x000fe40003f44070ULL,
0x000000ff08ff7812ULL, 0x000fc4000780c0ffULL, 0x0000000107647812ULL, 0x000fe4000782c0ffULL,
0x00000001ff657807ULL, 0x000fe40004000000ULL, 0x0000002683667207ULL, 0x000fca0004800000ULL,
0x000058100000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff317984ULL, 0x000e620000000800ULL,
0x00000001ff327807ULL, 0x000fca0004000000ULL, 0x8000000032307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe20007824830ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000032327824ULL, 0x000fe400078e00ffULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000182817824ULL, 0x000fe400078e0281ULL, 0x00000300ff307624ULL, 0x000fe400078e00ffULL,
0x0000000472547e24ULL, 0x020fe2000f8e022fULL, 0x0000000381317812ULL, 0x000fe200078ec0ffULL,
0xffffffffff727424ULL, 0x000fe200078e00ffULL, 0xfffffffd30307811ULL, 0x000fe400078e10ffULL,
0x000000033100780cULL, 0x000fc80003f25270ULL, 0x0000000130827807ULL, 0x000fca0004800000ULL,
0x0000000181707824ULL, 0x000fca00078e0282ULL, 0x000000757000720cULL, 0x000fe40003f26070ULL,
0x000000c078377811ULL, 0x040fe400078e40ffULL, 0x0000000178307810ULL, 0x000fe40007ffe0ffULL,
0x0000003774367217ULL, 0x000fce0007800000ULL, 0x0000000170349824ULL, 0x000fe400078e0205ULL,
0x00000004ff359424ULL, 0x000fe200078e00ffULL, 0x0000003f54317812ULL, 0x000fc600078ef809ULL,
0x0000600034349625ULL, 0x000fc800078e0035ULL, 0x00000100ff627424ULL, 0x000fe200078e00ffULL,
0x0000000634729981ULL, 0x000362000c1e1900ULL, 0x0000000136567824ULL, 0x000fe200078e0a37ULL,
0x000000733000720cULL, 0x000fe20003f26070ULL, 0x00005e0031307625ULL, 0x080fe200078e0062ULL,
0x0000003f54337812ULL, 0x040fe200078ef80bULL, 0x00000000140573c2ULL, 0x000ea200000e0000ULL,
0x0000003f54397812ULL, 0x040fe400078ef80cULL, 0x0000003f543b7812ULL, 0x000fe200078ef80fULL,
0x00005e0033327625ULL, 0x000fe200078e0062ULL, 0x0000004056607807ULL, 0x000fc40000800000ULL,
0x0000000a30307210ULL, 0x000fe20007f5e0ffULL, 0x00005e0039347625ULL, 0x002fe200078e0062ULL,
0x0000006071607217ULL, 0x000fe40007800000ULL, 0x0000003f54377812ULL, 0x040fe200078ef80dULL,
0x00005e003b3a7625ULL, 0x000fe200078e0062ULL, 0x0000003f54397812ULL, 0x040fe400078ef80eULL,
0x0000003f54577812ULL, 0x000fe200078ef811ULL, 0x000000ffff317224ULL, 0x000fe200010e0631ULL,
0x0000000a32327210ULL, 0x080fe20007f7e0ffULL, 0x0000000160607824ULL, 0x000fe200078e0a71ULL,
0x0000000a34347210ULL, 0x000fe20007f5e0ffULL, 0x00005e0037367625ULL, 0x000fe200078e0062ULL,
0x0000000a3a3a7210ULL, 0x000fc40007f3e0ffULL, 0x00000004ff697819ULL, 0x000fe20000011600ULL,
0x00005e0039387625ULL, 0x000fe200078e0062ULL, 0x0000003f54557812ULL, 0x000fe200078ef810ULL,
0x0001c64805057891ULL, 0x004fe2000f8e183fULL, 0x000000606900720cULL, 0x000fe20003f86070ULL,
0x00005e0057567625ULL, 0x000fe200078e0062ULL, 0x0000000269657810ULL, 0x040fe40007ffe0ffULL,
0x0000000469637810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x0000000a36367210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200010e0635ULL,
0x0000000a38387210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e063bULL,
0x0000000a56567210ULL, 0x000fe20007f3e0ffULL, 0x00005e0055547625ULL, 0x000fe200078e0062ULL,
0x0000000669617810ULL, 0x000fc40007ffe0ffULL, 0x000000606500720cULL, 0x080fe20003fa6070ULL,
0x000000ffff377224ULL, 0x000fe200018e0637ULL, 0x000000606300720cULL, 0x000fe20003f66070ULL,
0x000000ffff397224ULL, 0x000fe200010e0639ULL, 0x0000000a54547210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff577224ULL, 0x000fe200008e0657ULL, 0x000000606100720cULL, 0x000fe20003f26070ULL,
0x0000001012617824ULL, 0x000fe200078e0284ULL, 0x0000000869637810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff557224ULL, 0x000fe200010e0655ULL, 0x0000000a69657810ULL, 0x000fc40007ffe0ffULL,
0x000000606300720cULL, 0x080fe20003f46070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030617faeULL, 0x0003e2000e101c46ULL, 0x0000001013637824ULL, 0x100fe200078e0284ULL,
0x000000606500720cULL, 0x080fe20003f86070ULL, 0x0000001015657824ULL, 0x100fe200078e0284ULL,
0x0000000c69677810ULL, 0x040fe40007ffe0ffULL, 0x0000000e696b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000032637faeULL, 0x0005e2000e901c46ULL, 0x000000606700720cULL, 0x000fe20003fa6070ULL,
0x0000001016677824ULL, 0x000fc400078e0284ULL, 0x0000000034657faeULL, 0x0007e2000d901c46ULL,
0x000000606b00720cULL, 0x000fe20003f66070ULL, 0x0000001017697824ULL, 0x100fe200078e0284ULL,
0x0000000825307812ULL, 0x002fe200078ec0ffULL, 0x0000001018317824ULL, 0x100fe200078e0284ULL,
0x0000000036677faeULL, 0x0007e2000c901c46ULL, 0x000000101a617824ULL, 0x100fe400078e0284ULL,
0x0000001019337824ULL, 0x004fe200078e0284ULL, 0x0000000038697faeULL, 0x0007e8000d101c46ULL,
0x000000003a317faeULL, 0x0007e8000e101c46ULL, 0x0000000054337faeULL, 0x0007e8000e901c46ULL,
0x0000000056617faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c0030317984ULL, 0x0082a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c62c00ff327984ULL, 0x000ee20000000800ULL, 0x0000ffff66667812ULL, 0x000fe200078ec0ffULL,
0x800000001b337824ULL, 0x000fc600078e00ffULL, 0x0000888066307816ULL, 0x002fca00000000ffULL,
0x8000000030307824ULL, 0x000fca00078e00ffULL, 0x8000000031ff7812ULL, 0x004fe40007824830ULL,
0x8000000032ff7812ULL, 0x008fe20007844833ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x800000001b327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01c62c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007844832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c100001c317984ULL, 0x000e620000000800ULL, 0x00000001ff8f7424ULL, 0x000fc600078e00ffULL,
0x01c300001c307984ULL, 0x0004e20000000800ULL, 0x0000002e3100720bULL, 0x002fda0003f5d000ULL,
0x0000000000327806ULL, 0x000fc800010e0100ULL, 0x0000ffff32347812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x0000002e3100720bULL, 0x00cfe40003f54000ULL,
0x000000312e337209ULL, 0x000fe40007810000ULL, 0x00000002ff377819ULL, 0x000fc60000011600ULL,
0x800000332e327221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b32327820ULL, 0x000fe40000410000ULL,
0x00000000002e7806ULL, 0x000fe400010e0100ULL, 0x000000027600780cULL, 0x000fe40003f45270ULL,
0x0000ffff2e357812ULL, 0x000fe200078e3cffULL, 0x0000003200327308ULL, 0x000e660000000800ULL,
0x0000003534ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff8f7807ULL, 0x000fc60001800000ULL,
0x01c500331c00a388ULL, 0x000fe80000000800ULL, 0x00001f37322e7589ULL, 0x002e6400000e0000ULL,
0x8000003331343221ULL, 0x000fe40000010000ULL, 0x0000003202027220ULL, 0x000fe20000410000ULL,
0x00001f1f32317589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b34343820ULL, 0x000fc80000410000ULL,
0x00000034001d3308ULL, 0x000ee20000000800ULL, 0x0000002e44447220ULL, 0x082fe40000410000ULL,
0x0000002e45457220ULL, 0x080fe40000410000ULL, 0x0000002e40407220ULL, 0x080fe40000410000ULL,
0x0000002e41417220ULL, 0x080fe40000410000ULL, 0x0000002e3c3c7220ULL, 0x080fe40000410000ULL,
0x0000002e3d3d7220ULL, 0x000fc40000410000ULL, 0x0000002e48487220ULL, 0x080fe40000410000ULL,
0x0000002e49497220ULL, 0x080fe40000410000ULL, 0x0000002e4c4c7220ULL, 0x080fe40000410000ULL,
0x0000002e4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002e5c5c7220ULL, 0x080fe40000410000ULL,
0x0000002e5d5d7220ULL, 0x000fc40000410000ULL, 0x0000002e58587220ULL, 0x080fe40000410000ULL,
0x0000002e59597220ULL, 0x080fe40000410000ULL, 0x0000002e50507220ULL, 0x080fe40000410000ULL,
0x0000002e51517220ULL, 0x000fe40000410000ULL, 0x0000003146467220ULL, 0x084fe40000410000ULL,
0x0000003147477220ULL, 0x000fc40000410000ULL, 0x0000003142427220ULL, 0x080fe40000410000ULL,
0x0000003143437220ULL, 0x080fe40000410000ULL, 0x000000313e3e7220ULL, 0x080fe40000410000ULL,
0x000000313f3f7220ULL, 0x080fe40000410000ULL, 0x000000314a4a7220ULL, 0x080fe40000410000ULL,
0x000000314b4b7220ULL, 0x000fc40000410000ULL, 0x000000314e4e7220ULL, 0x080fe40000410000ULL,
0x000000314f4f7220ULL, 0x080fe40000410000ULL, 0x000000315e5e7220ULL, 0x080fe40000410000ULL,
0x000000315f5f7220ULL, 0x080fe40000410000ULL, 0x000000315a5a7220ULL, 0x080fe40000410000ULL,
0x000000315b5b7220ULL, 0x000fc40000410000ULL, 0x0000003152527220ULL, 0x080fe40000410000ULL,
0x0000003153537220ULL, 0x000fe40000410000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0033ULL,
0x000000301d303220ULL, 0x008fc80000410000ULL, 0x0000000230027221ULL, 0x00cfe20000010000ULL,
0x0000015000001947ULL, 0x000fea0003800000ULL, 0x0000000825317812ULL, 0x000fe400078ec0ffULL,
0x0000000107ff7812ULL, 0x000fc8000782c0ffULL, 0x01c64c0031317984ULL, 0x000e620000000800ULL,
0x0000002683307207ULL, 0x000fc80004800000ULL, 0x0000ffff30307812ULL, 0x000fc800078ec0ffULL,
0x0000888030327816ULL, 0x000fca00000000ffULL, 0x8000000032307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe20007824830ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x0000000107307812ULL, 0x000fe200078ec0ffULL,
0x8000000032337824ULL, 0x000fe400078e00ffULL, 0x3e000000ff317424ULL, 0x000fe200078e00ffULL,
0x0001c64830327811ULL, 0x000fc600078e18ffULL, 0x0000003100307305ULL, 0x0002a4000021f000ULL,
0x3fa0000031317823ULL, 0x002fe200000100ffULL, 0x000000300000735dULL, 0x004fe40003800000ULL,
0x0000040032307984ULL, 0x000e640000000800ULL, 0x8000000030ff7812ULL, 0x002fc40007824833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000107f547824ULL, 0x100fe400078e0280ULL, 0x000000107e647824ULL, 0x100fe400078e0280ULL,
0x000000107d687824ULL, 0x100fe400078e0280ULL, 0x000000005454783bULL, 0x000e620000004200ULL,
0x000000107c6c7824ULL, 0x100fe400078e0280ULL, 0x000000107b607824ULL, 0x100fe200078e0280ULL,
0x000000006464783bULL, 0x000fe20000004200ULL, 0x000000107a307824ULL, 0x000fc400078e0280ULL,
0x0000001079387824ULL, 0x100fe200078e0280ULL, 0x000000006868783bULL, 0x000fe20000004200ULL,
0x0000001077347824ULL, 0x000fc600078e0280ULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000006060783bULL, 0x000ee80000004200ULL, 0x000000003030783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000ee80000004200ULL, 0x000000003434783bULL, 0x000ee20000004200ULL,
0x00000018ffc77819ULL, 0x002fe20000011454ULL, 0x00000100548d7824ULL, 0x040fe200078e00ffULL,
0x0000888054ce7816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ffc87819ULL, 0x000fe20000011455ULL, 0x00000100558e7824ULL, 0x040fe200078e00ffULL,
0x0000888055d37816ULL, 0x040fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000ce00ce7306ULL, 0x000fe20000200c00ULL,
0x00000018ff8d7819ULL, 0x000fc4000001148dULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff8c7819ULL, 0x004fe4000001146fULL, 0x000088806f9c7816ULL, 0x000fe200000000ffULL,
0x0000005400cc7306ULL, 0x0003e20000200c00ULL, 0x00000018ffa27819ULL, 0x000fe40000011456ULL,
0x00000018ff937819ULL, 0x000fe40000011457ULL, 0x0000888056cb7816ULL, 0x000fc400000000ffULL,
0x0000888057cd7816ULL, 0x000fe200000000ffULL, 0x0000005500d17306ULL, 0x0005e20000200c00ULL,
0x0000010056547824ULL, 0x042fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x008fe40000011460ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000008d00cf7306ULL, 0x0003e20000200c00ULL,
0x0000010065557824ULL, 0x004fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x0000888060967816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400d07306ULL, 0x0005e20000200c00ULL, 0x00000100578d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001146eULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x000088806ea17816ULL, 0x000fe400000000ffULL, 0x00000018ffa57819ULL, 0x000fc40000011465ULL,
0x0000005500c67306ULL, 0x0003e20000200c00ULL, 0x0000010064547824ULL, 0x004fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x0000888065c37816ULL, 0x040fe200000000ffULL,
0x0001000065657824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000008e00d47306ULL, 0x0005e20000200c00ULL, 0x0000010067557824ULL, 0x002fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc40000011462ULL, 0x00000018ffab7819ULL, 0x000fe40000011464ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005400c57306ULL, 0x0003e20000200c00ULL,
0x00008880628e7816ULL, 0x004fe400000000ffULL, 0x0000888064c47816ULL, 0x040fe200000000ffULL,
0x0001000064647824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff8a7819ULL, 0x000fe20000011461ULL, 0x0000005500c17306ULL, 0x0005e20000200c00ULL,
0x0000010066547824ULL, 0x002fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc40000011464ULL,
0x0000888061987816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005600c97306ULL, 0x000fe20000200c00ULL, 0x0000010069557824ULL, 0x004fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe40000011468ULL, 0x0000888068b77816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x0000005400bf7306ULL, 0x0003e20000200c00ULL,
0x00000018ffb67819ULL, 0x000fe40000011467ULL, 0x0000888067bc7816ULL, 0x040fe200000000ffULL,
0x0001000067677824ULL, 0x000fe200078e00ffULL, 0x00000018ffb47819ULL, 0x000fe40000011466ULL,
0x0000888066be7816ULL, 0x000fe200000000ffULL, 0x0000005500b97306ULL, 0x0005e20000200c00ULL,
0x0000010068547824ULL, 0x042fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe20000011469ULL,
0x0001000068687824ULL, 0x000fe200078e00ffULL, 0x0000888069b87816ULL, 0x040fe200000000ffULL,
0x0001000066667824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0001000069697824ULL, 0x000fe200078e00ffULL, 0x0000005700ca7306ULL, 0x000fe20000200c00ULL,
0x000001006b557824ULL, 0x004fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fc40000011468ULL,
0x00000018ff857819ULL, 0x010fe40000011430ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400ba7306ULL, 0x0003e20000200c00ULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff8d7819ULL, 0x000fe2000001148dULL, 0x0000005500b27306ULL, 0x0005e20000200c00ULL,
0x000001006a547824ULL, 0x002fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fc40000011431ULL,
0x00000018ffa07819ULL, 0x000fe4000001146aULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006500c07306ULL, 0x0003e20000200c00ULL, 0x000001006d557824ULL, 0x004fe200078e00ffULL,
0x000088806ab07816ULL, 0x040fe200000000ffULL, 0x000100006a6a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9d7819ULL, 0x000fe4000001146bULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x0000005400b17306ULL, 0x0005e20000200c00ULL, 0x00000002ff657819ULL, 0x002fe40000011600ULL,
0x000088806baf7816ULL, 0x040fe200000000ffULL, 0x000100006b6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff927819ULL, 0x000fe2000001146dULL,
0x0000005500a97306ULL, 0x0003e20000200c00ULL, 0x000001006c547824ULL, 0x004fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001146bULL, 0x000088806da67816ULL, 0x040fe200000000ffULL,
0x000100006d6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006400c27306ULL, 0x000fe20000200c00ULL, 0x000001006f557824ULL, 0x042fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe20000011463ULL, 0x000100006f6f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x0000005400a77306ULL, 0x0003e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff917819ULL, 0x000fe4000001146cULL, 0x000088806ca87816ULL, 0x040fe200000000ffULL,
0x000100006c6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe20000011432ULL,
0x00000055009f7306ULL, 0x0005e20000200c00ULL, 0x000001006e547824ULL, 0x042fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011438ULL, 0x000100006e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc4000001146cULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006f009b7306ULL, 0x000fe20000200c00ULL, 0x0000010061557824ULL, 0x044fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe40000011439ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000054009e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff617819ULL, 0x000fc40000011461ULL,
0x00000018ff847819ULL, 0x000fe40000011433ULL, 0x00000018ff7c7819ULL, 0x000fe4000001143aULL,
0x00000018ff777819ULL, 0x000fe20000011434ULL, 0x0000005500997306ULL, 0x0005e20000200c00ULL,
0x0000010060547824ULL, 0x042fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011435ULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001143bULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000010063557824ULL, 0x004fe200078e00ffULL, 0x0000005400977306ULL, 0x0003e20000200c00ULL,
0x00000018ff797819ULL, 0x000fe40000011436ULL, 0x00000018ff7b7819ULL, 0x000fe40000011437ULL,
0x00000018ff907819ULL, 0x000fc60000011455ULL, 0x0000006000947306ULL, 0x0005e20000200c00ULL,
0x0000010062547824ULL, 0x042fe400078e00ffULL, 0x0001000062627824ULL, 0x000fc600078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011454ULL, 0x000130001e547811ULL, 0x000fe200078e20ffULL,
0x0000006e009a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000001dff60723eULL, 0x004fe400000000ffULL, 0x000000005454783bULL, 0x000fe60000000200ULL,
0x00000062006e7306ULL, 0x0003f00000200c00ULL, 0x0000006100957306ULL, 0x0005e20000200c00ULL,
0x0000541060627816ULL, 0x002fe20000000060ULL, 0x0000010030607824ULL, 0x000fc800078e00ffULL,
0x00001f6562657589ULL, 0x000e6200000e0000ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x000000d300d37306ULL, 0x000ee20000200c00ULL, 0x000099108f617816ULL, 0x004fe200000000ffULL,
0x00001f1f62647589ULL, 0x000ea600000e0000ULL, 0x000000ff6100720cULL, 0x000fe20003f25270ULL,
0x0000010031617824ULL, 0x000fe400078e00ffULL, 0x0000006800b37306ULL, 0x0009e60000200c00ULL,
0x00000018ff617819ULL, 0x000fca0000011461ULL, 0x000000c700c77306ULL, 0x000ee20000200c00ULL,
0x0000888030687816ULL, 0x050fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x0000006554549232ULL, 0x002fc80000000000ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000c800c87306ULL, 0x000e620000200c00ULL, 0x0000006556569232ULL, 0x000fe40000000000ULL,
0x0000006455559232ULL, 0x084fe40000000000ULL, 0x0000006457579232ULL, 0x000fc60000000000ULL,
0x0000006700bb7306ULL, 0x000ff00000200c00ULL, 0x0000006600bd7306ULL, 0x000ff00000200c00ULL,
0x0000006900b57306ULL, 0x0005f00000200c00ULL, 0x0000006000677306ULL, 0x0009e20000200c00ULL,
0x0000888031697816ULL, 0x004fce00000000ffULL, 0x0000003000667306ULL, 0x0005e20000200c00ULL,
0x0001000031607824ULL, 0x010fe200078e00ffULL, 0x00005410d3317816ULL, 0x008fcc00000000d4ULL,
0x000000cb00cb7306ULL, 0x000ee20000200c00ULL, 0x00005410ce307816ULL, 0x004fce00000000cfULL,
0x000000cd00cd7306ULL, 0x000fe20000200c00ULL, 0x000000305444723cULL, 0x000fee0000001844ULL,
0x0000008d00d27306ULL, 0x0005220000200c00ULL, 0x00005410cc307816ULL, 0x000fe400000000c7ULL,
0x00005410d1317816ULL, 0x002fc400000000c8ULL, 0x0000888033c77816ULL, 0x000fc600000000ffULL,
0x000000a200a27306ULL, 0x000fe20000200c00ULL, 0x00008880638d7816ULL, 0x044fe200000000ffULL,
0x0001000063637824ULL, 0x000fe200078e00ffULL, 0x000000305440723cULL, 0x000fe80000001840ULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000009300937306ULL, 0x000e640000200c00ULL,
0x0000010032317824ULL, 0x000fe200078e00ffULL, 0x0001300020307811ULL, 0x000fc800078e20ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000006a00ad7306ULL, 0x000ff00000200c00ULL,
0x0000006b00aa7306ULL, 0x0005f00000200c00ULL, 0x00000061006a7306ULL, 0x0009e20000200c00ULL,
0x00000018ff6b7819ULL, 0x004fc40000011460ULL, 0x00005410cb607816ULL, 0x008fca00000000d0ULL,
0x000000c400c47306ULL, 0x000ea20000200c00ULL, 0x00005410cd617816ULL, 0x010fce00000000d2ULL,
0x000000c300c37306ULL, 0x000ef00000200c00ULL, 0x0000006d00a37306ULL, 0x000ff00000200c00ULL,
0x00000063006d7306ULL, 0x0009f00000200c00ULL, 0x00000031008f7306ULL, 0x0003e20000200c00ULL,
0x000000605460723cULL, 0x010fe2000000183cULL, 0x00000000303c783bULL, 0x0008ec0000000200ULL,
0x000000ab00ab7306ULL, 0x000ea20000200c00ULL, 0x00005410ca317816ULL, 0x002fe20000000093ULL,
0x000000ffff937224ULL, 0x000fe200078e00c7ULL, 0x00005410c9307816ULL, 0x010fe200000000a2ULL,
0x0000010033a27824ULL, 0x000fc400078e00ffULL, 0x0001000033337824ULL, 0x000fe400078e00ffULL,
0x000000a500a57306ULL, 0x000e620000200c00ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x000000305448723cULL, 0x000fe20000001848ULL, 0x00000018ff337819ULL, 0x000fca0000011433ULL,
0x000000be00be7306ULL, 0x000f220000200c00ULL, 0x00005410c4307816ULL, 0x004fe400000000c5ULL,
0x00005410c3317816ULL, 0x008fca00000000c6ULL, 0x000000bc00bc7306ULL, 0x000ea40000200c00ULL,
0x00000030544c723cULL, 0x000fec000000184cULL, 0x000000b400b47306ULL, 0x000ee20000200c00ULL,
0x00005410c2307816ULL, 0x000fe200000000abULL, 0x000000653c3c9232ULL, 0x080fe20000000000ULL,
0x00005410c0317816ULL, 0x002fe200000000a5ULL, 0x000000653e3e9232ULL, 0x000fc40000000000ULL,
0x000000643d3d9232ULL, 0x080fe40000000000ULL, 0x000000b600b67306ULL, 0x000e620000200c00ULL,
0x000000643f3f9232ULL, 0x000fe20000000000ULL, 0x00000030545c723cULL, 0x000fec000000185cULL,
0x000000b700b77306ULL, 0x000e620000200c00ULL, 0x00005410be307816ULL, 0x010fc400000000bfULL,
0x00005410bc317816ULL, 0x004fe200000000c1ULL, 0x0000010038bc7824ULL, 0x000fc800078e00ffULL,
0x000000b800b87306ULL, 0x000ea40000200c00ULL, 0x000000305458723cULL, 0x000fec0000001858ULL,
0x000000ae00ae7306ULL, 0x000f220000200c00ULL, 0x0000888038317816ULL, 0x040fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00005410bd307816ULL, 0x008fc600000000b4ULL,
0x000000ffffb47224ULL, 0x000fe200078e0031ULL, 0x00005410bb317816ULL, 0x002fe200000000b6ULL,
0x000000ac00ac7306ULL, 0x000e620000200c00ULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x000000305450723cULL, 0x000fe40000001850ULL, 0x000000af00af7306ULL, 0x000eea0000200c00ULL,
0x00005410b7307816ULL, 0x000fe400000000baULL, 0x00005410b8317816ULL, 0x004fe200000000b9ULL,
0x000000a000a07306ULL, 0x000fe20000200c00ULL, 0x0000888039567816ULL, 0x000fc400000000ffULL,
0x00000018ff557819ULL, 0x000fc600000114bcULL, 0x000000303c44723cULL, 0x000fe40000001844ULL,
0x0000009d009d7306ULL, 0x000fea0000200c00ULL, 0x00005410b3307816ULL, 0x010fe400000000aeULL,
0x00005410b5317816ULL, 0x002fe200000000acULL, 0x0000006c00a47306ULL, 0x0003e20000200c00ULL,
0x0001000039ac7824ULL, 0x000fca00078e00ffULL, 0x000000303c40723cULL, 0x000fe40000001840ULL,
0x000000b000b07306ULL, 0x000ea20000200c00ULL, 0x00008880326c7816ULL, 0x042fe200000000ffULL,
0x0001000032327824ULL, 0x000fc600078e00ffULL, 0x00005410af317816ULL, 0x008fe400000000b2ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x000000a800a87306ULL, 0x000e700000200c00ULL,
0x000000a600a67306ULL, 0x000ee20000200c00ULL, 0x00005410b0307816ULL, 0x004fce00000000b1ULL,
0x0000003200a57306ULL, 0x0005e20000200c00ULL, 0x000000303c60723cULL, 0x000fee0000001860ULL,
0x0000003800af7306ULL, 0x0009e20000200c00ULL, 0x0000010039327824ULL, 0x004fe200078e00ffULL,
0x00005410aa397816ULL, 0x000fc4000000009dULL, 0x000088803a9d7816ULL, 0x000fe400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011432ULL, 0x0000009100917306ULL, 0x000ea20000200c00ULL,
0x00005410ad387816ULL, 0x010fe400000000a0ULL, 0x0001300021327811ULL, 0x000fe400078e20ffULL,
0x00000018ffa07819ULL, 0x000fc600000114acULL, 0x0000009200927306ULL, 0x000f220000200c00ULL,
0x000000383c48723cULL, 0x000fee0000001848ULL, 0x000000a100a17306ULL, 0x000ea20000200c00ULL,
0x00005410a8387816ULL, 0x002fe400000000a7ULL, 0x00005410a6397816ULL, 0x008fe200000000a9ULL,
0x000001003aa67824ULL, 0x000fc400078e00ffULL, 0x000100003a3a7824ULL, 0x000fe400078e00ffULL,
0x0000009c009c7306ULL, 0x000e640000200c00ULL, 0x000000383c4c723cULL, 0x000fec000000184cULL,
0x0000008b008b7306ULL, 0x000ee20000200c00ULL, 0x00005410a4387816ULL, 0x004fc40000000091ULL,
0x00005410a3397816ULL, 0x010fe40000000092ULL, 0x000088803b917816ULL, 0x000fe400000000ffULL,
0x00000018ff927819ULL, 0x000fe200000114a6ULL, 0x0000008c008c7306ULL, 0x000ea40000200c00ULL,
0x000000383c5c723cULL, 0x000fec000000185cULL, 0x0000003300ab7306ULL, 0x0009e20000200c00ULL,
0x00005410a1387816ULL, 0x000fc4000000009eULL, 0x000054109c397816ULL, 0x002fe4000000009fULL,
0x000054109a9a7816ULL, 0x008fe4000000008bULL, 0x000054109b9b7816ULL, 0x004fe2000000008cULL,
0x000000003230783bULL, 0x010e640000000200ULL, 0x000000383c58723cULL, 0x040fe20000001858ULL,
0x0000009600967306ULL, 0x000eac0000200c00ULL, 0x000001003b397824ULL, 0x040fe200078e00ffULL,
0x0000009a3c3c723cULL, 0x000fe20000001850ULL, 0x0000009800987306ULL, 0x000ee20000200c00ULL,
0x000100003b3b7824ULL, 0x000fc400078e00ffULL, 0x00000018ff8b7819ULL, 0x000fe40000011439ULL,
0x00000018ff397819ULL, 0x000fe4000001143aULL, 0x0001300022507811ULL, 0x000fe200078e20ffULL,
0x0000008900897306ULL, 0x000f220000200c00ULL, 0x0000541096967816ULL, 0x004fe40000000097ULL,
0x00008880343a7816ULL, 0x000fe400000000ffULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x0000541098977816ULL, 0x008fce0000000099ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x0000541094947816ULL, 0x010fe20000000089ULL, 0x0000010034897824ULL, 0x040fe400078e00ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000006530309232ULL, 0x082fe40000000000ULL,
0x00000018ff897819ULL, 0x000fe20000011489ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000006532329232ULL, 0x000fe20000000000ULL, 0x0000541095957816ULL, 0x000fe2000000008aULL,
0x0000006431319232ULL, 0x080fe20000000000ULL, 0x00008880358a7816ULL, 0x000fe200000000ffULL,
0x0000006433339232ULL, 0x000fe20000000000ULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x0000008700877306ULL, 0x000ee80000200c00ULL, 0x000000963044723cULL, 0x000fe80000001844ULL,
0x0000008800887306ULL, 0x000f220000200c00ULL, 0x000054108e8c7816ULL, 0x002fc6000000006fULL,
0x000000943040723cULL, 0x000fe20000001840ULL, 0x0000006451519232ULL, 0x084fe40000000000ULL,
0x0000006453539232ULL, 0x000fe20000000000ULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x000054106e6e7816ULL, 0x008fe20000000087ULL, 0x0000006550509232ULL, 0x080fe40000000000ULL,
0x0000006552529232ULL, 0x000fc80000000000ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x000054106d6f7816ULL, 0x010fe20000000088ULL, 0x000000ffff6d7224ULL, 0x000fcc00078e008aULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x0000541068687816ULL, 0x002fe20000000067ULL,
0x0000006e3048723cULL, 0x000fec0000001848ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x0000541066667816ULL, 0x004fe20000000085ULL, 0x00000100356e7824ULL, 0x000fc400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x00000018ff357819ULL, 0x000fce0000011435ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054106b677816ULL, 0x002fce0000000086ULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x0000541069697816ULL, 0x004fe2000000006aULL,
0x00000066305c723cULL, 0x040fec000000185cULL, 0x0000006c006c7306ULL, 0x000ea40000200c00ULL,
0x00000068304c723cULL, 0x000fec000000184cULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000054108d8d7816ULL, 0x002fce0000000090ULL, 0x000000a200a27306ULL, 0x000fe20000200c00ULL,
0x000054106c6c7816ULL, 0x004fe2000000008fULL, 0x0000008c3060723cULL, 0x000fec0000001860ULL,
0x0000008000807306ULL, 0x000e700000200c00ULL, 0x0000008400847306ULL, 0x000eb00000200c00ULL,
0x000000b400547306ULL, 0x000fe20000200c00ULL, 0x00005410a5aa7816ULL, 0x002fce0000000080ULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x00005410abab7816ULL, 0x004fce0000000084ULL,
0x0000005600567306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x002fce0000000055ULL, 0x0000007a007a7306ULL, 0x000ff00000200c00ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541056557816ULL, 0x004fce0000000057ULL,
0x000000a000a07306ULL, 0x000e620000200c00ULL, 0x000000545044723cULL, 0x000fee0000001844ULL,
0x0000006d006f7306ULL, 0x0005f00000200c00ULL, 0x0000003400667306ULL, 0x0007e20000200c00ULL,
0x00005410936d7816ULL, 0x004fce00000000a2ULL, 0x0000003500687306ULL, 0x0003e20000200c00ULL,
0x0000888036347816ULL, 0x008fe200000000ffULL, 0x0000006c3058723cULL, 0x040fec0000001858ULL,
0x0000003400647306ULL, 0x0005e20000200c00ULL, 0x00005410a0357816ULL, 0x002fe2000000007fULL,
0x000000aa3030723cULL, 0x000fec000000183cULL, 0x0000009100387306ULL, 0x000fe20000200c00ULL,
0x00005410af347816ULL, 0x004fe2000000007aULL, 0x00000100363c7824ULL, 0x000fc400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff547819ULL, 0x000fe2000001143cULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000000345040723cULL, 0x000fe20000001840ULL,
0x00008880373c7816ULL, 0x000fe400000000ffULL, 0x00000018ff367819ULL, 0x000fc80000011436ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000010037347824ULL, 0x040fe400078e00ffULL,
0x000000ffff357224ULL, 0x000fe400078e003cULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x00005410383d7816ULL, 0x002fe4000000008bULL, 0x00000018ff377819ULL, 0x000fca0000011437ULL,
0x0000003900397306ULL, 0x000ff00000200c00ULL, 0x0000003b003b7306ULL, 0x000e700000200c00ULL,
0x0000003500657306ULL, 0x0003f00000200c00ULL, 0x0000003400387306ULL, 0x0004e20000200c00ULL,
0x000054103b357816ULL, 0x002fce000000007eULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000541039347816ULL, 0x004fce000000007cULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x000000345048723cULL, 0x000fe20000001848ULL, 0x0000541065657816ULL, 0x008fcc0000000038ULL,
0x0000009d009d7306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fe40000000077ULL,
0x0000000107357812ULL, 0x000fc800078ec0ffULL, 0x000000013500780cULL, 0x000fe20003f25070ULL,
0x0000009200927306ULL, 0x000e620000200c00ULL, 0x0000541068677816ULL, 0x004fce000000007dULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x00000066505c723cULL, 0x000fee000000185cULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x000054109d3c7816ULL, 0x002fce0000000092ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000003c503c723cULL, 0x000fee0000001860ULL,
0x0000005400557306ULL, 0x000ee20000200c00ULL, 0x000054103a3a7816ULL, 0x004fce0000000089ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000054106f3b7816ULL, 0x002fce000000006eULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x008fe20000000055ULL,
0x0000003a504c723cULL, 0x040fec000000184cULL, 0x0000003600367306ULL, 0x000e640000200c00ULL,
0x000000645058723cULL, 0x000fec0000001858ULL, 0x0000003700347306ULL, 0x000ea20000200c00ULL,
0x0000541036367816ULL, 0x002fc40000000079ULL, 0x0000541034377816ULL, 0x004fce000000007bULL,
0x000000365050723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008326307207ULL, 0x000fe20004800000ULL,
0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000c078317811ULL, 0x000fe400078e40ffULL,
0x000000ff30ff7812ULL, 0x000fe4000784c0ffULL, 0x000000ff08ff7812ULL, 0x000fe4000786c0ffULL,
0x00000001ff087807ULL, 0x000fc40001000000ULL, 0x000000317400720cULL, 0x000fe40003f44070ULL,
0x0000008308087207ULL, 0x000fe40004800000ULL, 0x00000001ff657807ULL, 0x000fe40001800000ULL,
0x0000000107647812ULL, 0x000fe400078e0cffULL, 0x0000761008667816ULL, 0x000fca0000000066ULL,
0x00002b700000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff087984ULL, 0x000e620000000800ULL,
0x8000000023317824ULL, 0x000fca00078e00ffULL, 0x8000000008ff7812ULL, 0x002fe20007824831ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000023307824ULL, 0x000fe400078e00ffULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800237305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000230000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fc40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000181817824ULL, 0x000fe400078e0282ULL,
0x00000300ff087624ULL, 0x000fe400078e00ffULL, 0x0000000472327e24ULL, 0x020fe2000f8e022fULL,
0x0000000381237812ULL, 0x000fe200078ec0ffULL, 0x00000100ff367424ULL, 0x000fe200078e00ffULL,
0xfffffffd08087811ULL, 0x000fe200078e10ffULL, 0xffffffffff727424ULL, 0x000fe200078e00ffULL,
0x000000032300780cULL, 0x000fc80003f25270ULL, 0x0000000108707807ULL, 0x000fca0004800000ULL,
0x0000000181707824ULL, 0x000fca00078e0270ULL, 0x000000757000720cULL, 0x000fe40003f26070ULL,
0x0000030078087a10ULL, 0x000fe40007ffe0ffULL, 0x0000003f32097812ULL, 0x040fe400078ef809ULL,
0x0000003f32237812ULL, 0x000fe200078ef80bULL, 0x00000100080b7824ULL, 0x000fe200078e00ffULL,
0x0000003f32337812ULL, 0x000fca00078ef80cULL, 0x0000000170309824ULL, 0x000fe400078e0205ULL,
0x00000004ff319424ULL, 0x000fe200078e00ffULL, 0x00000001080c7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fc800078e0036ULL, 0x0000600030309625ULL, 0x000fe200078e0031ULL,
0x0000003f32377812ULL, 0x040fe400078ef80eULL, 0x0000003f32357812ULL, 0x000fe400078ef80dULL,
0x0000000630729981ULL, 0x000362000c1e1900ULL, 0x0000000b740e7217ULL, 0x000fe40007800000ULL,
0x000000730c00720cULL, 0x000fe20003f26070ULL, 0x00005e00230c7625ULL, 0x000fe200078e0036ULL,
0x0000000a08087210ULL, 0x000fc40007f5e0ffULL, 0x0000003f32397812ULL, 0x000fe200078ef80fULL,
0x000000010e0b7824ULL, 0x000fe200078e0a0bULL, 0x0000003f323b7812ULL, 0x000fe200078ef810ULL,
0x000000ffff097224ULL, 0x000fe200010e0609ULL, 0x0000000a0c0c7210ULL, 0x000fe20007f5e0ffULL,
0x00005e00330e7625ULL, 0x080fe200078e0036ULL, 0x0000003f32557812ULL, 0x000fe400078ef811ULL,
0x000000400b387807ULL, 0x000fe20000800000ULL, 0x00005e0037307625ULL, 0x002fe200078e0036ULL,
0x0000000a0e0e7210ULL, 0x000fc40007f7e0ffULL, 0x0000003871387217ULL, 0x000fe20007800000ULL,
0x00005e0035107625ULL, 0x000fe200078e0036ULL, 0x0000400024247812ULL, 0x000fc600078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x0000000a30307210ULL, 0x000fe20007f5e0ffULL,
0x00005e0039327625ULL, 0x000fe200078e0036ULL, 0x0000000a10107210ULL, 0x000fe40007f9e0ffULL,
0x00000004ff397819ULL, 0x000fe20000011600ULL, 0x00005e003b347625ULL, 0x080fe200078e0036ULL,
0x0001400024247810ULL, 0x000fe40007ffe0ffULL, 0x0000000439237810ULL, 0x000fe20007ffe0ffULL,
0x00005e0055367625ULL, 0x000fe200078e0036ULL, 0x0000000a34347210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e060fULL, 0x0000000a32327210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200010e0631ULL, 0x0000000a360a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000138387824ULL, 0x000fe200078e0a71ULL, 0x0000000825367812ULL, 0x000fe200078ec0ffULL,
0x000000ffff117224ULL, 0x000fe400020e0611ULL, 0x000000ffff0b7224ULL, 0x000fe200010e0637ULL,
0x0000000239377810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff337224ULL, 0x000fe200018e0633ULL,
0x000000383900720cULL, 0x080fe20003f86070ULL, 0x00000000360573c2ULL, 0x000e6200000e0000ULL,
0x000000383700720cULL, 0x080fe20003fa6070ULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000000639377810ULL, 0x000fe20007ffe0ffULL, 0x0000001013257824ULL, 0x100fe200078e0224ULL,
0x000000382300720cULL, 0x080fe20003f66070ULL, 0x0000001017177824ULL, 0x100fe200078e0224ULL,
0x0000000839237810ULL, 0x000fe20007ffe0ffULL, 0x0000001019197824ULL, 0x100fe200078e0224ULL,
0x000000383700720cULL, 0x080fe20003f26070ULL, 0x0000001012377824ULL, 0x000fe200078e0224ULL,
0x000000382300720cULL, 0x000fc40003f46070ULL, 0x0000000a39237810ULL, 0x040fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008377faeULL, 0x0005e2000e101c46ULL,
0x0000000c39137810ULL, 0x000fe40007ffe0ffULL, 0x000000382300720cULL, 0x080fe20003f86070ULL,
0x0000001015237824ULL, 0x100fe200078e0224ULL, 0x0000000e39397810ULL, 0x000fe20007ffe0ffULL,
0x000000000c257faeULL, 0x0007e2000e901c46ULL, 0x000000381300720cULL, 0x080fe20003fa6070ULL,
0x0000001016157824ULL, 0x100fe200078e0224ULL, 0x0001c64805057890ULL, 0x002fe2000fffe03fULL,
0x000000000e237faeULL, 0x0007e2000d901c46ULL, 0x000000383900720cULL, 0x000fe20003f66070ULL,
0x0000001018097824ULL, 0x104fe200078e0224ULL, 0x0001c64814087811ULL, 0x000fe200078e18ffULL,
0x000000101a137824ULL, 0x000fe200078e0224ULL, 0x0000000010157faeULL, 0x0007e8000c901c46ULL,
0x0000000030177faeULL, 0x0007e8000d101c46ULL, 0x0000000032097faeULL, 0x0007e8000e101c46ULL,
0x0000000034197faeULL, 0x0007e8000e901c46ULL, 0x000000000a137faeULL, 0x0007e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000040008097984ULL, 0x0082a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c63c00ff0a7984ULL, 0x000ee20000000800ULL,
0x0000ffff660e7812ULL, 0x000fe200078ec0ffULL, 0x800000001b0b7824ULL, 0x000fc800078e00ffULL,
0x800000000e087824ULL, 0x002fca00078e00ffULL, 0x8000000009ff7812ULL, 0x004fe40007824808ULL,
0x800000000aff7812ULL, 0x008fe2000784480bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x800000001b0a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x01c63c00ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000784480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c180001c097984ULL, 0x000e620000000800ULL, 0x00000001ff957424ULL, 0x000fc600078e00ffULL,
0x01c380001c087984ULL, 0x0004e20000000800ULL, 0x0000002e0900720bULL, 0x002fda0003f5d000ULL,
0x00000000000a7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0a0c7812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x0000002e0900720bULL, 0x00cfe40003f54000ULL,
0x000000092e0f7209ULL, 0x000fe40007810000ULL, 0x00000002ff107819ULL, 0x000fc60000011600ULL,
0x8000000f2e0a7221ULL, 0x100fe40000010000ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000fULL,
0x3fb8aa3b0a0b7820ULL, 0x000fe40000410000ULL, 0x00000000000a7806ULL, 0x000fe400010e0100ULL,
0x000000037600780cULL, 0x000fe40003f45270ULL, 0x0000ffff0a0d7812ULL, 0x000fe200078e3cffULL,
0x0000000b000b7308ULL, 0x000e660000000800ULL, 0x0000000d0cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff957807ULL, 0x000fc60001800000ULL, 0x01c5800f1c00a388ULL, 0x000fec0000000800ULL,
0x8000000f090c3221ULL, 0x000fe20000010000ULL, 0x00001f100b0a7589ULL, 0x002e6200000e0000ULL,
0x0000000b02027220ULL, 0x000fe40000410000ULL, 0x3fb8aa3b0c0c3820ULL, 0x000fe20000410000ULL,
0x00001f1f0b097589ULL, 0x000ea600000e0000ULL, 0x0000000c001d3308ULL, 0x000ee40000000800ULL,
0x000000081d083220ULL, 0x008fc40000410000ULL, 0x0000000a44447220ULL, 0x082fe40000410000ULL,
0x0000000a45457220ULL, 0x080fe40000410000ULL, 0x0000000a40407220ULL, 0x080fe40000410000ULL,
0x0000000a41417220ULL, 0x080fe40000410000ULL, 0x0000000a3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000a3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000a48487220ULL, 0x080fe40000410000ULL,
0x0000000a49497220ULL, 0x080fe40000410000ULL, 0x0000000a4c4c7220ULL, 0x080fe40000410000ULL,
0x0000000a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000000a5c5c7220ULL, 0x080fe40000410000ULL,
0x0000000a5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000a58587220ULL, 0x080fe40000410000ULL,
0x0000000a59597220ULL, 0x080fe40000410000ULL, 0x0000000a50507220ULL, 0x080fe40000410000ULL,
0x0000000a51517220ULL, 0x000fe40000410000ULL, 0x0000000946467220ULL, 0x084fe40000410000ULL,
0x0000000947477220ULL, 0x000fc40000410000ULL, 0x0000000942427220ULL, 0x080fe40000410000ULL,
0x0000000943437220ULL, 0x080fe40000410000ULL, 0x000000093e3e7220ULL, 0x080fe40000410000ULL,
0x000000093f3f7220ULL, 0x080fe40000410000ULL, 0x000000094a4a7220ULL, 0x080fe40000410000ULL,
0x000000094b4b7220ULL, 0x000fc40000410000ULL, 0x000000094e4e7220ULL, 0x080fe40000410000ULL,
0x000000094f4f7220ULL, 0x080fe40000410000ULL, 0x000000095e5e7220ULL, 0x080fe40000410000ULL,
0x000000095f5f7220ULL, 0x080fe40000410000ULL, 0x000000095a5a7220ULL, 0x080fe40000410000ULL,
0x000000095b5b7220ULL, 0x000fc40000410000ULL, 0x0000000952527220ULL, 0x080fe40000410000ULL,
0x0000000953537220ULL, 0x000fe40000410000ULL, 0x0000000208027221ULL, 0x00cfe20000010000ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0001c64814147811ULL, 0x000fe200078e18ffULL,
0x800000000e097824ULL, 0x000fc800078e00ffULL, 0x0000040014087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000000e0e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x0000040014097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc4000782480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000002714783bULL, 0x000e620000004200ULL, 0x0001380022227811ULL, 0x000fc600078e20ffULL,
0x000000002818783bULL, 0x000ea80000004200ULL, 0x000000002930783bULL, 0x000fe80000004200ULL,
0x000000002a34783bULL, 0x000fe80000004200ULL, 0x000000002b38783bULL, 0x000ee80000004200ULL,
0x000000002c10783bULL, 0x000f280000004200ULL, 0x000000002d0c783bULL, 0x000ee80000004200ULL,
0x000000000308783bULL, 0x0002e40000004200ULL, 0x0000010015637824ULL, 0x042fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011415ULL, 0x0000010014627824ULL, 0x000fe200078e00ffULL,
0x0000888015ab7816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000010017657824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x00000018ff927819ULL, 0x000fc40000011417ULL, 0x00000018ffae7819ULL, 0x000fe40000011415ULL,
0x00000018ff917819ULL, 0x000fe40000011416ULL, 0x0000888016157816ULL, 0x000fe200000000ffULL,
0x0000006300b07306ULL, 0x0003e20000200c00ULL, 0x00000018ff907819ULL, 0x004fe40000011418ULL,
0x00008880189d7816ULL, 0x000fe400000000ffULL, 0x00000018ff8f7819ULL, 0x000fc40000011419ULL,
0x00000018ff8e7819ULL, 0x000fe2000001141aULL, 0x0000006200ad7306ULL, 0x0005e20000200c00ULL,
0x0000888017637816ULL, 0x042fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001141bULL, 0x0000888019a27816ULL, 0x000fe400000000ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x000000ab00ab7306ULL, 0x000fe20000200c00ULL,
0x0000010016627824ULL, 0x004fe200078e00ffULL, 0x000088801a9b7816ULL, 0x000fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x000088801b9e7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001700a97306ULL, 0x0003e20000200c00ULL, 0x00000018ff947819ULL, 0x000fe40000011414ULL,
0x0000888014aa7816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x008fe40000011438ULL, 0x00008880386a7816ULL, 0x000fe200000000ffULL,
0x0000001600a87306ULL, 0x0005e20000200c00ULL, 0x000001001a177824ULL, 0x042fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011431ULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fc40000011439ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000006200ac7306ULL, 0x0003e20000200c00ULL, 0x0000010019167824ULL, 0x044fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000017009c7306ULL, 0x0005e20000200c00ULL, 0x0000010018627824ULL, 0x042fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00008880319a7816ULL, 0x000fc400000000ffULL, 0x00008880396c7816ULL, 0x000fe400000000ffULL,
0x0000001600a77306ULL, 0x0003e20000200c00ULL, 0x0000010030177824ULL, 0x044fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff1c7819ULL, 0x000fe4000001143aULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000001800a37306ULL, 0x0005e20000200c00ULL,
0x000001001b167824ULL, 0x042fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011430ULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000888030987816ULL, 0x040fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000001700997306ULL, 0x0003e20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x000138001e187811ULL, 0x004fe400078e20ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011432ULL,
0x00000018ff647819ULL, 0x000fe20000011434ULL, 0x0000001600a57306ULL, 0x0005e20000200c00ULL,
0x0000010032177824ULL, 0x002fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fc40000011430ULL,
0x00008880328b7816ULL, 0x040fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000001900a67306ULL, 0x000fe20000200c00ULL,
0x0000010031167824ULL, 0x044fe200078e00ffULL, 0x00008880347f7816ULL, 0x000fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x00000017008a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000018ff247819ULL, 0x010fe40000011410ULL, 0x00000018ff257819ULL, 0x000fe20000011411ULL,
0x0000001600a17306ULL, 0x0005e20000200c00ULL, 0x0000010034177824ULL, 0x042fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011433ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888033897816ULL, 0x000fc400000000ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001a009f7306ULL, 0x000fe20000200c00ULL, 0x0000010033167824ULL, 0x044fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000001700827306ULL, 0x0003e20000200c00ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x00000018ff607819ULL, 0x000fe40000011437ULL, 0x00008880377b7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe20000011435ULL, 0x00000016008c7306ULL, 0x0005e20000200c00ULL,
0x0000010036177824ULL, 0x002fe200078e00ffULL, 0x0000888035817816ULL, 0x000fe400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011412ULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x0000001b00a07306ULL, 0x0003e20000200c00ULL, 0x0000010035167824ULL, 0x044fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011436ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00008880367c7816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001700797306ULL, 0x0005e20000200c00ULL,
0x000000001818783bULL, 0x002fe20000000200ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x00000018ff237819ULL, 0x000fe4000001143bULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000001600867306ULL, 0x0003e20000200c00ULL, 0x0000010038177824ULL, 0x044fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011413ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fe4000001140dULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x00000018ff697819ULL, 0x000fe20000011438ULL, 0x0000010037167824ULL, 0x042fe200078e00ffULL,
0x00000017006b7306ULL, 0x0003e20000200c00ULL, 0x000088803a387816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fe4000001140cULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000001400b17306ULL, 0x000fe20000200c00ULL, 0x000001003a177824ULL, 0x042fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001140eULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fc4000001140fULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000016007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fe40000011408ULL,
0x00000018ff2d7819ULL, 0x000fe40000011409ULL, 0x00000018ff547819ULL, 0x000fe4000001140aULL,
0x00000018ff557819ULL, 0x000fe2000001140bULL, 0x0000006300147306ULL, 0x000fe20000200c00ULL,
0x0000010039167824ULL, 0x002fc400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000001700637306ULL, 0x0003f00000200c00ULL, 0x0000003100967306ULL, 0x0005e20000200c00ULL,
0x0000001dff17723eULL, 0x002fce00000000ffULL, 0x0000003900687306ULL, 0x0003e20000200c00ULL,
0x00000002ff317819ULL, 0x004fce0000011600ULL, 0x00000016006f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff397819ULL, 0x002fe4000001143aULL, 0x00005410173a7816ULL, 0x000fe20000000017ULL,
0x0000010011177824ULL, 0x000fc800078e00ffULL, 0x00001f313a317589ULL, 0x000e6200000e0000ULL,
0x000001003b167824ULL, 0x004fe200078e00ffULL, 0x0000003000977306ULL, 0x0005e20000200c00ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x00001f1f3a1e7589ULL, 0x000ee400000e0000ULL,
0x00000018ff167819ULL, 0x000fc80000011416ULL, 0x000000aa00aa7306ULL, 0x000f220000200c00ULL,
0x0000991095307816ULL, 0x004fc800000000ffULL, 0x000000ff3000720cULL, 0x000fc60003f25270ULL,
0x0000006500af7306ULL, 0x000ff00000200c00ULL, 0x0000003200877306ULL, 0x0005e40000200c00ULL,
0x0000003118189232ULL, 0x002fc40000000000ULL, 0x000000311a1a9232ULL, 0x000fe40000000000ULL,
0x0000001e19199232ULL, 0x088fe40000000000ULL, 0x00000034007d7306ULL, 0x0003e20000200c00ULL,
0x0000888010327816ULL, 0x004fe200000000ffULL, 0x0000001e1b1b9232ULL, 0x000fcc0000000000ULL,
0x0000001600657306ULL, 0x0005e20000200c00ULL, 0x0000888011347816ULL, 0x042fe200000000ffULL,
0x0001000011117824ULL, 0x000fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000009400947306ULL, 0x000e620000200c00ULL, 0x0000010010167824ULL, 0x044fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x000000ae00ae7306ULL, 0x000ea20000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x00000010001f7306ULL, 0x0009f00000200c00ULL, 0x0000001100307306ULL, 0x0007e20000200c00ULL,
0x00005410aa107816ULL, 0x010fce00000000adULL, 0x0000001500157306ULL, 0x000f220000200c00ULL,
0x00005410ab117816ULL, 0x008fce00000000b0ULL, 0x000000101844723cULL, 0x000fe20000001844ULL,
0x0000009100917306ULL, 0x000eec0000200c00ULL, 0x00005410b1107816ULL, 0x002fe40000000094ULL,
0x0000009200927306ULL, 0x000e620000200c00ULL, 0x00005410ae117816ULL, 0x004fce0000000093ULL,
0x000000101840723cULL, 0x000fe20000001840ULL, 0x0000009d009d7306ULL, 0x000fec0000200c00ULL,
0x0000541015107816ULL, 0x010fe400000000acULL, 0x0000006200a47306ULL, 0x0005220000200c00ULL,
0x0000541014117816ULL, 0x000fc400000000afULL, 0x0001380020157811ULL, 0x000fca00078e20ffULL,
0x000000a200a27306ULL, 0x000f220000200c00ULL, 0x00000010183c723cULL, 0x000fe2000000183cULL,
0x000088803b627816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fca00078e00ffULL,
0x0000003300887306ULL, 0x000fe20000200c00ULL, 0x00005410a8107816ULL, 0x008fe40000000091ULL,
0x00005410a9117816ULL, 0x002fca0000000092ULL, 0x0000001600337306ULL, 0x0003e40000200c00ULL,
0x000000101848723cULL, 0x000fec0000001848ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x0000010012167824ULL, 0x002fe200078e00ffULL, 0x000054109d107816ULL, 0x010fc400000000a4ULL,
0x00005410a2117816ULL, 0x000fe400000000a7ULL, 0x00000018ff3a7819ULL, 0x000fe40000011416ULL,
0x0000008f008f7306ULL, 0x000e620000200c00ULL, 0x0000888013167816ULL, 0x000fe400000000ffULL,
0x00000010184c723cULL, 0x000fe6000000184cULL, 0x000000ffff207224ULL, 0x000fc400078e0016ULL,
0x0000003700777306ULL, 0x000fe40000200c00ULL, 0x00005410a3107816ULL, 0x004fe40000000090ULL,
0x000088800c907816ULL, 0x000fc800000000ffULL, 0x0000001700377306ULL, 0x0005e20000200c00ULL,
0x00005410a6117816ULL, 0x002fce000000008fULL, 0x0000009b009b7306ULL, 0x000e620000200c00ULL,
0x000000001514783bULL, 0x004ea20000000200ULL, 0x00000010185c723cULL, 0x000fec000000185cULL,
0x0000009e009e7306ULL, 0x000ef00000200c00ULL, 0x0000008e008e7306ULL, 0x000f220000200c00ULL,
0x000054109b107816ULL, 0x002fce000000009cULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x000054109e117816ULL, 0x008fce00000000a5ULL, 0x0000003500807306ULL, 0x0007e20000200c00ULL,
0x000000101858723cULL, 0x000fee0000001858ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000888012357816ULL, 0x048fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x000054109f107816ULL, 0x010fe2000000008eULL, 0x000001000c117824ULL, 0x040fe200078e00ffULL,
0x0000003114149232ULL, 0x084fe20000000000ULL, 0x000088800d8e7816ULL, 0x000fe200000000ffULL,
0x0000003116169232ULL, 0x000fe20000000000ULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000001e15159232ULL, 0x080fe20000000000ULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x0000001e17179232ULL, 0x000fc80000000000ULL,
0x0000001200927306ULL, 0x0007e20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000007f007f7306ULL, 0x000f220000200c00ULL, 0x00000018ff127819ULL, 0x008fe40000011411ULL,
0x00005410a0117816ULL, 0x002fca000000008dULL, 0x0000008100817306ULL, 0x000e640000200c00ULL,
0x000000101818723cULL, 0x000fec0000001850ULL, 0x00000036007a7306ULL, 0x0007e20000200c00ULL,
0x000001000d107824ULL, 0x000fe200078e00ffULL, 0x0000541087507816ULL, 0x000fe2000000006eULL,
0x000100000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000541088517816ULL, 0x004fc4000000006dULL,
0x00000018ff917819ULL, 0x000fe40000011410ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x00000018ff367819ULL, 0x008fe2000001143bULL, 0x00000100133b7824ULL, 0x000fe200078e00ffULL,
0x0001380021107811ULL, 0x000fe200078e20ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000000501448723cULL, 0x000fe20000001848ULL, 0x000088800f527816ULL, 0x000fe200000000ffULL,
0x000001000e217824ULL, 0x000fe200078e00ffULL, 0x0000006700677306ULL, 0x000ee20000200c00ULL,
0x00000018ff137819ULL, 0x000fc40000011413ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x000054107f507816ULL, 0x010fe40000000082ULL, 0x0000541081517816ULL, 0x002fe20000000086ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x00000050144c723cULL, 0x000fe4000000184cULL, 0x0000007b007b7306ULL, 0x000f2a0000200c00ULL,
0x000054107d507816ULL, 0x004fe40000000064ULL, 0x0000541080517816ULL, 0x008fe20000000067ULL,
0x00000013008f7306ULL, 0x000fe20000200c00ULL, 0x000054107c7c7816ULL, 0x002fca0000000079ULL,
0x00000050145c723cULL, 0x000fe4000000185cULL, 0x00000012008d7306ULL, 0x0003e20000200c00ULL,
0x000054107b7d7816ULL, 0x010fc8000000007eULL, 0x000001000f517824ULL, 0x040fe400078e00ffULL,
0x000000ffff507224ULL, 0x000fe200078e0052ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000000001010783bULL, 0x002e620000000200ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000007c1458723cULL, 0x000fe20000001858ULL, 0x000100000f0f7824ULL, 0x000fc800078e00ffULL,
0x0000008500857306ULL, 0x000ef00000200c00ULL, 0x0000009800987306ULL, 0x000f220000200c00ULL,
0x0000541097847816ULL, 0x004fce0000000084ULL, 0x0000008b008b7306ULL, 0x000ea20000200c00ULL,
0x0000541096857816ULL, 0x008fce0000000085ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x000000841440723cULL, 0x000fe20000001840ULL, 0x0000541098987816ULL, 0x010fcc0000000099ULL,
0x0000006000607306ULL, 0x000f220000200c00ULL, 0x000054108b8a7816ULL, 0x004fe2000000008aULL,
0x0000003110109232ULL, 0x082fe20000000000ULL, 0x00000018ff847819ULL, 0x000fe2000001140dULL,
0x0000003112129232ULL, 0x000fe20000000000ULL, 0x000088800e0d7816ULL, 0x040fe200000000ffULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001e11119232ULL, 0x080fe20000000000ULL,
0x0000009a009a7306ULL, 0x000e620000200c00ULL, 0x000054107a7a7816ULL, 0x008fe20000000061ULL,
0x0000001e13139232ULL, 0x000fe20000000000ULL, 0x00000018ff0e7819ULL, 0x000fca000001140eULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x00005410777b7816ULL, 0x010fce0000000060ULL,
0x0000005000677306ULL, 0x000fe20000200c00ULL, 0x000054109a997816ULL, 0x002fe200000000a1ULL,
0x0000007a1418723cULL, 0x040fec0000001818ULL, 0x00000051007c7306ULL, 0x0003e20000200c00ULL,
0x00005410898b7816ULL, 0x004fe2000000008cULL, 0x000000981444723cULL, 0x040fec0000001844ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000002250783bULL, 0x002e620000000200ULL,
0x0000008a143c723cULL, 0x000fec000000183cULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x00000018ff147819ULL, 0x000fe2000001140fULL, 0x0000010009177824ULL, 0x000fe200078e00ffULL,
0x0000888008157816ULL, 0x000fc400000000ffULL, 0x0000888009167816ULL, 0x040fe200000000ffULL,
0x0001000009097824ULL, 0x000fe400078e00ffULL, 0x0000006900697306ULL, 0x000ee60000200c00ULL,
0x00000018ff097819ULL, 0x000fca0000011409ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x0000541068577816ULL, 0x004fce0000000057ULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x0000541069567816ULL, 0x008fce0000000056ULL, 0x0000003900397306ULL, 0x000ee20000200c00ULL,
0x000000561040723cULL, 0x000fe20000001840ULL, 0x0000003150509232ULL, 0x082fe40000000000ULL,
0x0000003152529232ULL, 0x000fe40000000000ULL, 0x0000001e51519232ULL, 0x080fe40000000000ULL,
0x0000003200327306ULL, 0x000e620000200c00ULL, 0x000054106a6a7816ULL, 0x004fe2000000006bULL,
0x0000001e53539232ULL, 0x000fcc0000000000ULL, 0x0000002300237306ULL, 0x000fe20000200c00ULL,
0x0000541039227816ULL, 0x008fe4000000001cULL, 0x00000018ff1c7819ULL, 0x000fca0000011417ULL,
0x0000002400247306ULL, 0x000ea20000200c00ULL, 0x0000541032327816ULL, 0x002fce0000000033ULL,
0x0000002500257306ULL, 0x000e700000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x000054101f247816ULL, 0x004fe20000000024ULL, 0x000001000a1f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000002800287306ULL, 0x000ea20000200c00ULL,
0x0000541030257816ULL, 0x002fce0000000025ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000541092927816ULL, 0x008fe20000000027ULL, 0x00000024105c723cULL, 0x000fec000000185cULL,
0x0000003800387306ULL, 0x000ee20000200c00ULL, 0x000054108f937816ULL, 0x004fce0000000028ULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000054106c6b7816ULL, 0x002fe2000000006fULL,
0x000000921018723cULL, 0x000fe20000001818ULL, 0x00005410676f7816ULL, 0x000fca000000007cULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0x0000541038647816ULL, 0x008fe20000000063ULL,
0x0000006a1044723cULL, 0x000fec0000001844ULL, 0x0000003400347306ULL, 0x000ee20000200c00ULL,
0x0000541062657816ULL, 0x004fce0000000065ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x0000541036237816ULL, 0x002fe20000000023ULL, 0x00000064103c723cULL, 0x040fec000000183cULL,
0x0000003a003a7306ULL, 0x000e620000200c00ULL, 0x0000541034337816ULL, 0x008fe20000000037ULL,
0x000000221048723cULL, 0x000fe20000001848ULL, 0x0000000107647812ULL, 0x000fca000786c0ffULL,
0x0000002000207306ULL, 0x000fe40000200c00ULL, 0x00000032104c723cULL, 0x000fec000000184cULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x00005410353a7816ULL, 0x002fce000000003aULL,
0x0000000e000f7306ULL, 0x0003f00000200c00ULL, 0x0000002900297306ULL, 0x000fe20000200c00ULL,
0x00000100080e7824ULL, 0x002fe200078e00ffULL, 0x00005410203b7816ULL, 0x004fe2000000003bULL,
0x0001000008087824ULL, 0x000fc600078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000003a1058723cULL, 0x000fec0000001858ULL, 0x0000000c000c7306ULL, 0x000e620000200c00ULL,
0x000001000b107824ULL, 0x000fca00078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000008400847306ULL, 0x000eb00000200c00ULL, 0x00000021006e7306ULL, 0x000ff00000200c00ULL,
0x0000001c00217306ULL, 0x000ff00000200c00ULL, 0x0000000800177306ULL, 0x0007f00000200c00ULL,
0x00000009001c7306ULL, 0x0009e20000200c00ULL, 0x000088800a087816ULL, 0x048fe200000000ffULL,
0x000100000a0a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000000800207306ULL, 0x0003e20000200c00ULL, 0x000088800b097816ULL, 0x050fe200000000ffULL,
0x000100000b0b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000000900117306ULL, 0x0005e20000200c00ULL, 0x000054100c087816ULL, 0x002fce0000000029ULL,
0x0000002a002a7306ULL, 0x000e620000200c00ULL, 0x0000541084097816ULL, 0x004fce0000000003ULL,
0x0000001600167306ULL, 0x000ea20000200c00ULL, 0x000000085040723cULL, 0x000fee0000001840ULL,
0x0000002b002b7306ULL, 0x000fe20000200c00ULL, 0x000054100f2a7816ULL, 0x002fce000000002aULL,
0x0000002c002c7306ULL, 0x000e620000200c00ULL, 0x00005410160f7816ULL, 0x004fce0000000021ULL,
0x0000002d002d7306ULL, 0x000eb00000200c00ULL, 0x0000009000907306ULL, 0x000ee20000200c00ULL,
0x00005410172c7816ULL, 0x002fce000000002cULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x000054101c2d7816ULL, 0x004fce000000002dULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000541090907816ULL, 0x008fe2000000008dULL, 0x0000002c505c723cULL, 0x000fec000000185cULL,
0x0000000d000d7306ULL, 0x000eb00000200c00ULL, 0x0000001400147306ULL, 0x000ee20000200c00ULL,
0x000054108e917816ULL, 0x002fce0000000091ULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000054100d6e7816ULL, 0x004fe2000000006eULL, 0x000000905044723cULL, 0x040fec0000001844ULL,
0x0000000e000e7306ULL, 0x000e620000200c00ULL, 0x00005410142b7816ULL, 0x008fe2000000002bULL,
0x0000006e503c723cULL, 0x040fec000000183cULL, 0x0000001f001f7306ULL, 0x000ea40000200c00ULL,
0x0000002a5048723cULL, 0x000fec0000001848ULL, 0x0000001000107306ULL, 0x000ee20000200c00ULL,
0x00005410150e7816ULL, 0x002fce000000000eULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541020207816ULL, 0x004fe2000000001fULL, 0x0000000e504c723cULL, 0x000fec000000184cULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000541011217816ULL, 0x008fce0000000010ULL,
0x0000000a00037306ULL, 0x000e620000200c00ULL, 0x000000205058723cULL, 0x000fee0000001858ULL,
0x0000000b00087306ULL, 0x000ea20000200c00ULL, 0x0000541003547816ULL, 0x002fe40000000054ULL,
0x0000991066037816ULL, 0x000fc400000000ffULL, 0x0000541008557816ULL, 0x004fce0000000055ULL,
0x000000545050723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000002683267207ULL, 0x000fe40005800000ULL, 0x000000ff0300720cULL, 0x000fe40003f45270ULL,
0x000000ff26ff7812ULL, 0x000fe4000782c0ffULL, 0x00000001ff657807ULL, 0x000fe40004000000ULL,
0x00000001ff667807ULL, 0x000fc40000800000ULL, 0x00000001ff66b807ULL, 0x000fe40001000000ULL,
0x0000030078787a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff06ff7812ULL, 0x000fe4000780c0ffULL,
0x000000737800720cULL, 0x000fe40003f26070ULL, 0x00000001ff067807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff496000007947ULL, 0x000fea000383ffffULL,
0x00000000000d7919ULL, 0x010e640000002500ULL, 0x000000730d00720cULL, 0x002fda0003f06070ULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x0180000002007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e0002ULL, 0x0000c97000097802ULL, 0x000fe40000000f00ULL,
0x00009f8000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000002ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff057624ULL, 0x000fe400078e00ffULL, 0x00006800ff047624ULL, 0x000fca00078e00ffULL,
0x0000000604057981ULL, 0x000ea8000c1e9900ULL, 0x0000000000077919ULL, 0x000ee40000000000ULL,
0x00000002ff037819ULL, 0x008fe40000011607ULL, 0x0000000807077811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x004fca0000410000ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0700077589ULL, 0x000ee200000e0000ULL, 0x0000004403447220ULL, 0x044fe40000410000ULL,
0x0000004503457220ULL, 0x040fe40000410000ULL, 0x0000004003407220ULL, 0x040fe40000410000ULL,
0x0000004103417220ULL, 0x000fc40000410000ULL, 0x0000003c033c7220ULL, 0x040fe40000410000ULL,
0x0000003d033d7220ULL, 0x040fe40000410000ULL, 0x0000004803487220ULL, 0x040fe40000410000ULL,
0x0000004903497220ULL, 0x040fe40000410000ULL, 0x0000004c034c7220ULL, 0x040fe40000410000ULL,
0x0000004d034d7220ULL, 0x000fc40000410000ULL, 0x0000005c035c7220ULL, 0x040fe40000410000ULL,
0x0000005d035d7220ULL, 0x040fe40000410000ULL, 0x0000005803587220ULL, 0x040fe40000410000ULL,
0x0000005903597220ULL, 0x040fe40000410000ULL, 0x0000005003507220ULL, 0x040fe40000410000ULL,
0x0000005103517220ULL, 0x000fc40000410000ULL, 0x0000004607467220ULL, 0x048fe40000410000ULL,
0x0000004707477220ULL, 0x040fe40000410000ULL, 0x0000004207427220ULL, 0x040fe40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x000fc40000410000ULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000004b074b7220ULL, 0x040fe40000410000ULL, 0x0000004e074e7220ULL, 0x040fe40000410000ULL,
0x0000004f074f7220ULL, 0x040fe40000410000ULL, 0x0000005e075e7220ULL, 0x040fe40000410000ULL,
0x0000005f075f7220ULL, 0x000fc40000410000ULL, 0x0000005a075a7220ULL, 0x040fe40000410000ULL,
0x0000005b075b7220ULL, 0x040fe40000410000ULL, 0x0000005207527220ULL, 0x040fe40000410000ULL,
0x0000005307537220ULL, 0x000fe40000410000ULL, 0x00000000000f7919ULL, 0x000ea20000000000ULL,
0x00000300ff287624ULL, 0x000fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x000000012800780cULL, 0x000fe40003f05270ULL, 0x000000020f007812ULL, 0x004fe400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe4000001160fULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x0000000200047811ULL, 0x000fc400078ff8ffULL, 0x0000000400077811ULL, 0x040fe400078ff8ffULL,
0x00000006000b7811ULL, 0x000fe400078ff8ffULL, 0x000000080f167811ULL, 0x000fe400078ff0ffULL,
0x0000000703007812ULL, 0x100fe400078e780eULL, 0x0000000704057812ULL, 0x100fe400078e780eULL,
0x0000000707097812ULL, 0x000fe200078e780eULL, 0x000000080e067824ULL, 0x000fe200078e0200ULL,
0x000000070b0c7812ULL, 0x000fe200078e780eULL, 0x0000080076007824ULL, 0x000fe200078e00ffULL,
0x0000000707077812ULL, 0x100fe200078e7816ULL, 0x000000080e087824ULL, 0x040fe200078e0205ULL,
0x0000000703037812ULL, 0x100fe200078e7816ULL, 0x000000080e0a7824ULL, 0x000fe200078e0209ULL,
0x0000000704047812ULL, 0x000fe200078e7816ULL, 0x000000080e0e7824ULL, 0x000fe200078e020cULL,
0x000000070b0b7812ULL, 0x000fe200078e7816ULL, 0x0000000816147824ULL, 0x040fe200078e0207ULL,
0x000000404105723eULL, 0x000fe200000000ffULL, 0x00000008160c7824ULL, 0x000fe200078e0203ULL,
0x0001200000037810ULL, 0x000fe20007ffe0ffULL, 0x000000080f077824ULL, 0x000fe200078e00ffULL,
0x000000424309723eULL, 0x000fe200000000ffULL, 0x0000000816127824ULL, 0x040fe200078e0204ULL,
0x000000444504723eULL, 0x000fe200000000ffULL, 0x0000000816167824ULL, 0x000fe200078e020bULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x0000541004187816ULL, 0x000fe20000000005ULL, 0x000000100c107824ULL, 0x000fe200078e0203ULL,
0x0000763204197816ULL, 0x000fe20000000005ULL, 0x0000001008087824ULL, 0x100fe200078e0203ULL,
0x0000004c4d04723eULL, 0x000fe200000000ffULL, 0x0000001012127824ULL, 0x100fe200078e0203ULL,
0x0000005c5d05723eULL, 0x000fe200000000ffULL, 0x000000100a0c7824ULL, 0x000fc400078e0203ULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x0000001014147824ULL, 0x100fe400078e0203ULL,
0x0000001016167824ULL, 0x000fe400078e0203ULL, 0x00000001060a7824ULL, 0x000fe200078e0207ULL,
0x0000003c3d06723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x040fe400078e0210ULL,
0x00000001070b7824ULL, 0x040fe200078e0208ULL, 0x000000180a007388ULL, 0x0005e20000000a00ULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x000000464708723eULL, 0x000fe200000000ffULL,
0x00000001070c7824ULL, 0x000fc400078e020cULL, 0x00000001070e7824ULL, 0x040fe400078e020eULL,
0x0000000107147824ULL, 0x040fe400078e0214ULL, 0x0000000107167824ULL, 0x000fe200078e0216ULL,
0x000000484907723eULL, 0x000fe400000000ffULL, 0x00005410040a7816ULL, 0x004fe40000000005ULL,
0x0000541006187816ULL, 0x140fe40000000007ULL, 0x0000763206197816ULL, 0x000fc40000000007ULL,
0x000000585906723eULL, 0x000fe400000000ffULL, 0x000000505107723eULL, 0x000fe200000000ffULL,
0x000000180b007388ULL, 0x0005e40000000a00ULL, 0x00007632040b7816ULL, 0x004fe40000000005ULL,
0x0000003e3f04723eULL, 0x000fe400000000ffULL, 0x0000004a4b05723eULL, 0x000fe200000000ffULL,
0x0000000a0c007388ULL, 0x0005e40000000a00ULL, 0x00005410060a7816ULL, 0x004fc40000000007ULL,
0x00007632060b7816ULL, 0x000fe40000000007ULL, 0x0000004e4f06723eULL, 0x000fe400000000ffULL,
0x0000005e5f07723eULL, 0x000fe200000000ffULL, 0x0000000a0e007388ULL, 0x0005e40000000a00ULL,
0x00005410080a7816ULL, 0x144fe40000000009ULL, 0x00007632080b7816ULL, 0x000fe40000000009ULL,
0x0000005a5b08723eULL, 0x000fc400000000ffULL, 0x000000525309723eULL, 0x000fe200000000ffULL,
0x0000000a10007388ULL, 0x0005e40000000a00ULL, 0x00005410040a7816ULL, 0x144fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a12007388ULL, 0x0005e20000000a00ULL,
0x0000541008067816ULL, 0x000fc40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x0000000414007388ULL, 0x0005e80000000a00ULL, 0x0000000616007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002cd000008947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x004ea20000000000ULL, 0x0000580028047a24ULL, 0x000fe200078e02ffULL,
0x000000ff7600720cULL, 0x000fe20003f25270ULL, 0x00002000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000167919ULL, 0x000ee20000002700ULL, 0x0000660004067a24ULL, 0x000fc600078e02ffULL,
0x0000000000077919ULL, 0x000ee20000002600ULL, 0x00000010050b7824ULL, 0x044fe200078e0200ULL,
0x0000002005117810ULL, 0x040fe40007ffe0ffULL, 0x0000004005137810ULL, 0x040fe40007ffe0ffULL,
0x012000000b187984ULL, 0x0005220000000c00ULL, 0x0000006005157810ULL, 0x000fe20007ffe0ffULL,
0x0000580016167a24ULL, 0x008fe400078e0207ULL, 0x012200000b1c7984ULL, 0x0004e20000000c00ULL,
0x00001fff06077811ULL, 0x000fe200078e40ffULL, 0x0000030016047a24ULL, 0x000fc400078e02ffULL,
0x012400000b207984ULL, 0x0004620000000c00ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x00000001040a7824ULL, 0x000fe400078e020dULL, 0x012600000b247984ULL, 0x0004620000000c00ULL,
0x000000ff7600720cULL, 0x000fe40000705670ULL, 0x0000000a07087211ULL, 0x000fca00078f98ffULL,
0x00006c0008087625ULL, 0x000fcc00078e0009ULL, 0x0000080076087825ULL, 0x000fcc00078e0008ULL,
0x0000001011107825ULL, 0x000fc800078e0008ULL, 0x0000001013127825ULL, 0x000fc800078e0008ULL,
0x0000001015147825ULL, 0x000fc800078e0008ULL, 0x00000010050e7825ULL, 0x000fe200078e0008ULL,
0x01ffffff06097812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x01cea20000000000ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000010a0c7824ULL, 0x040fe400078e0209ULL, 0x00006c000a0a7625ULL, 0x000fc800078e000dULL,
0x00006c000c0c7625ULL, 0x000fc800078e000dULL, 0x0000001006087824ULL, 0x004fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fc80000011606ULL, 0x0000007008177812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ec0ffULL, 0x0000000a060a7210ULL, 0x140fe40007b5e017ULL,
0x0000000c060c7210ULL, 0x000fe40007d9e017ULL, 0x0000000bff0b7210ULL, 0x000fe400017e64ffULL,
0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL, 0x0000002e0a007986ULL, 0x0005e8000c101906ULL,
0x000000020c007986ULL, 0x0005e4000c101906ULL, 0x000000180e007986ULL, 0x01c5e2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000001c10007986ULL, 0x0005e8000c101d06ULL,
0x0000002012007986ULL, 0x0025e8000c101d06ULL, 0x0000002414007986ULL, 0x0005e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0b7424ULL, 0x000fe200078e00ffULL, 0xffffffff280d7810ULL, 0x000fc60007ffe0ffULL,
0x00006a00160a7625ULL, 0x000fe200078e000bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x0000000d0a0a79a8ULL, 0x000ee400099ee1c6ULL,
0x0000000d0a00720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff027807ULL, 0x000fca0000000000ULL, 0x00000002ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x0000286000008947ULL, 0x000fea0003800000ULL, 0x00000d1000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001040c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001005027824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe20000011605ULL, 0x00000080ff197424ULL, 0x004fc600078e00ffULL,
0x00000070021b7812ULL, 0x000fe200078ec0ffULL, 0x00006c00040a7625ULL, 0x000fe200078e0019ULL,
0x0000000c06067812ULL, 0x000fc600078ec0ffULL, 0x00006c000c0c7625ULL, 0x000fe200078e0019ULL,
0x0000000a060a7210ULL, 0x000fc8000791e01bULL, 0x0000000c060c7210ULL, 0x000fe40007b5e01bULL,
0x0000000bff0b7210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x000000060a027981ULL, 0x000368000c1e1900ULL, 0x000000060c0f7981ULL, 0x000362000c1e1900ULL,
0x000000022800780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a060a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000042800780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a060a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000042800780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0019ULL,
0x0000000a060a7210ULL, 0x000fc8000791e01bULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000062800780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a060a7210ULL, 0x000fc8000791e01bULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a177981ULL, 0x000362000c1e1900ULL,
0x000000062800780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000082800780cULL, 0x002fe40003f06070ULL, 0x00000006040a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0019ULL, 0x0000000a060a7210ULL, 0x000fe40007a3e01bULL,
0x00000007040c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0019ULL, 0x000000060a197981ULL, 0x000366000c1e1900ULL,
0x0000000c060c0210ULL, 0x000fc80007c7e01bULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c1b0981ULL, 0x000368000c1e1900ULL, 0x0000000728067810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff067819ULL, 0x000fc80000011606ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000ffff1d7224ULL, 0x024fe400078e0002ULL, 0x000000080d087824ULL, 0x040fe200078e00ffULL,
0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x000000060d00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x00000008080b7810ULL, 0x040fe40007ffe0ffULL, 0x00000001080a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001d02027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c1d7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e01dULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1d7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x00000009080b7810ULL, 0x042fe40007ffe0ffULL,
0x00000002080a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e00fULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0f7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a080b7810ULL, 0x042fe40007ffe0ffULL, 0x00000003080a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001102027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c117812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b080b7810ULL, 0x042fe40007ffe0ffULL,
0x00000004080a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c137812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c080b7810ULL, 0x042fe40007ffe0ffULL, 0x00000005080a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d080b7810ULL, 0x042fe40007ffe0ffULL,
0x00000006080a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001702027209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700c177812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e080b7810ULL, 0x042fe40007ffe0ffULL, 0x00000007080a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001902027209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c197812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007b3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f080b7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b02027209ULL, 0x000fe40007810000ULL, 0x000003000b007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0c7819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x00000070081b7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0c0a7210ULL, 0x000fc80007a3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x0000001005067824ULL, 0x008fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011605ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c080b7812ULL, 0x002fca00078ec0ffULL, 0x00000001060b7824ULL, 0x000fca00078e020bULL,
0x000000020b007388ULL, 0x0203e40000000800ULL, 0x00000004070a7211ULL, 0x000fe200078f98ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00002000ff0b7424ULL, 0x002fe200078e00ffULL,
0x000000070500780cULL, 0x040fe20003f04070ULL, 0x0000001005027824ULL, 0x040fe200078e00ffULL,
0x00000001ff067819ULL, 0x000fe20000011605ULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x00000015ff417819ULL, 0x000fe20000011676ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x00000800763f7824ULL, 0x000fe200078e00ffULL,
0x0000000c060d7812ULL, 0x000fe200078ec0ffULL, 0x0000100076267824ULL, 0x004fe200078e00ffULL,
0x00000040050f7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000003f0a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000102027824ULL, 0x000fe200078e020dULL,
0x00000020050d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104128824ULL, 0x000fe200078e0209ULL,
0x0000006005117810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff138424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000010b0b7824ULL, 0x000fe200008e0641ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff158424ULL, 0x000fe200078e00ffULL,
0x0000000002197984ULL, 0x0002a20000000800ULL, 0x00006c0012128625ULL, 0x000fe200078e0013ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000100d0c7825ULL, 0x100fe200078e000aULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000100f0e7825ULL, 0x000fc800078e000aULL,
0x0000001011107825ULL, 0x000fc800078e000aULL, 0x00000010761d8824ULL, 0x000fe400078e0205ULL,
0x00006c0004148625ULL, 0x000fc600078e0015ULL, 0x000045801d1d8811ULL, 0x000fe200078e20ffULL,
0x00000010051b7824ULL, 0x040fe400078e0226ULL, 0x00000010050a7825ULL, 0x000fc800078e000aULL,
0x00000010761f8824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a1b7faeULL, 0x0007e2000b901c46ULL, 0x0000001005128825ULL, 0x000fc600078e0012ULL,
0x000041801f1f8811ULL, 0x000fe200078e20ffULL, 0x0000001005148825ULL, 0x000fe200078e0014ULL,
0x003800000c1b7faeULL, 0x0009e6000b901c46ULL, 0x000000ffff027224ULL, 0x002fe200078e00ffULL,
0x005800000e1b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x008fe2000001ff00ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00780000101b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x00000000121d8faeULL, 0x0005e2000b901c46ULL, 0x00000000000c7805ULL, 0x010fc6000001ff00ULL,
0x00000000141f8faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x002fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000107805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x004fe2000001ff00ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x00000d6000009947ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e00ffULL,
0x000000ffff367224ULL, 0x000fca00078e00ffULL, 0x0000000136377810ULL, 0x000fc80007ffe0ffULL,
0x0000030037007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x0000000104387824ULL, 0x000fe200078e0237ULL, 0x000000070500780cULL, 0x000fe20003f24070ULL,
0x00002000ff1b7424ULL, 0x000fe200078e00ffULL, 0x00000001371f7812ULL, 0x040fe200078ec0ffULL,
0x00000800371c7824ULL, 0x000fe200078e00ffULL, 0x00000038071a7211ULL, 0x000fe400078f98ffULL,
0x0000002005217810ULL, 0x040fe40007ffe0ffULL, 0x000008001c1d7812ULL, 0x000fe200078ec0ffULL,
0x00006c001a1a7625ULL, 0x000fe200078e001bULL, 0x0000004005257810ULL, 0x000fc40007ffe0ffULL,
0x00000060053b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001261c7824ULL, 0x000fe200078e021dULL,
0x0000003f1a1a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109229824ULL, 0x000fe400078e0238ULL,
0x00000080ff239424ULL, 0x000fe400078e00ffULL, 0x000000011b1b7824ULL, 0x000fe400000e0641ULL,
0x0000000276249824ULL, 0x140fe400078e021fULL, 0x00000002763a9824ULL, 0x000fc400078e021fULL,
0x00000080ff3d9424ULL, 0x000fe400078e00ffULL, 0x0000001005397824ULL, 0x000fe400078e021cULL,
0x00000010211e7825ULL, 0x000fc800078e001aULL, 0x0000001025207825ULL, 0x000fc800078e001aULL,
0x00000010051c7825ULL, 0x000fc800078e001aULL, 0x000000103b1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800001c397faeULL, 0x0003e6000b901c46ULL,
0x00006c0022229625ULL, 0x000fe200078e0023ULL, 0x003800001e397faeULL, 0x0003e6000b901c46ULL,
0x00000008243b9824ULL, 0x000fe200078e0205ULL, 0x0058000020397faeULL, 0x0003e2000b901c46ULL,
0x00006c0038249625ULL, 0x000fc600078e003dULL, 0x000045803b3b9811ULL, 0x000fe200078e20ffULL,
0x000000083a3a9824ULL, 0x000fe200078e0205ULL, 0x007800001a397faeULL, 0x0003e2000b901c46ULL,
0x0000001005229825ULL, 0x000fc600078e0022ULL, 0x000041803a3d9811ULL, 0x000fe200078e20ffULL,
0x0000001005249825ULL, 0x000fe200078e0024ULL, 0x00000000223b9faeULL, 0x0003e8000b901c46ULL,
0x00000000243d9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff1d7224ULL, 0x002fe200078e0036ULL, 0x00000001ff1e7819ULL, 0x100fe20000011605ULL,
0x00000010051c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff237819ULL, 0x000fe20000011605ULL,
0x000000801d1a7824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL,
0x000000701c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000823217824ULL, 0x040fe200078e00ffULL,
0x000000801a1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008231f7824ULL, 0x040fe200078e00ffULL,
0x00000007233c7812ULL, 0x000fe400078ec0ffULL, 0x00000023ff3a7212ULL, 0x000fe200078e33ffULL,
0x00000100761b7824ULL, 0x000fe200078e021bULL, 0xfffffff81f1a7812ULL, 0x000fe400078ee23cULL,
0xfffffff8213a7812ULL, 0x000fc400078ee23aULL, 0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL,
0x00000008231b7824ULL, 0x040fe200078e00ffULL, 0x0000000823257810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180001c387984ULL, 0x000e620000000800ULL,
0x000000011b1e7812ULL, 0x100fe200078ef63cULL, 0x00000008251f7824ULL, 0x000fe200078e00ffULL,
0x000000021b207812ULL, 0x140fe200078ef63cULL, 0x004580001c4a7984ULL, 0x0002a20000000800ULL,
0x000000031b227812ULL, 0x100fe200078ef63cULL, 0x00000008253e7824ULL, 0x000fe200078e00ffULL,
0x000000041b247812ULL, 0x140fe400078ef63cULL, 0x000000051b367812ULL, 0x000fe400078ef63cULL,
0x00000025ff487212ULL, 0x000fc800078e33ffULL, 0xfffffff81f487812ULL, 0x000fe400078ee248ULL,
0x00000007251f7812ULL, 0x000fe200078ec0ffULL, 0x00000038191c7221ULL, 0x002fe20000010100ULL,
0x000000061b387812ULL, 0x000fe200078ef63cULL, 0x000008001d1b7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL, 0x00000004051c7824ULL, 0x000fe200078e00ffULL,
0x000008001b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008253c7824ULL, 0x000fc400078e00ffULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x00000180261b7810ULL, 0x000fe40007ffe01bULL,
0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL, 0xfffffff83e1c7812ULL, 0x000fe200078ee21fULL,
0x000000101a1a7824ULL, 0x000fe200078e021bULL, 0x000000013c3e7812ULL, 0x000fe200078ef61fULL,
0x000000101e1e7824ULL, 0x000fe200078e021bULL, 0x000000023c407812ULL, 0x000fe200078ef61fULL,
0x000000011a1a7824ULL, 0x000fe200078e021dULL, 0x000000033c427812ULL, 0x140fe200078ef61fULL,
0x000000011d1e7824ULL, 0x040fe200078e021eULL, 0x000000043c447812ULL, 0x000fe200078ef61fULL,
0x000000103a3a7824ULL, 0x000fe200078e021bULL, 0x000000053c467812ULL, 0x000fe200078ef61fULL,
0x000000001a1a7984ULL, 0x000e620000000800ULL, 0x0000001022227824ULL, 0x000fe200078e021bULL,
0x000000063c3c7812ULL, 0x000fe200078ef61fULL, 0x000000011d3a7824ULL, 0x040fe200078e023aULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x000000011d227824ULL, 0x000fc400078e0222ULL,
0x0000001020207824ULL, 0x100fe400078e021bULL, 0x0000001036367824ULL, 0x100fe200078e021bULL,
0x000000003a3a7984ULL, 0x000ee20000000800ULL, 0x000000011d207824ULL, 0x040fe400078e0220ULL,
0x000000011d367824ULL, 0x000fe200078e0236ULL, 0x0000000022227984ULL, 0x000fe20000000800ULL,
0x0000001024247824ULL, 0x100fe400078e021bULL, 0x0000001038387824ULL, 0x000fe200078e021bULL,
0x0000000020207984ULL, 0x000fe20000000800ULL, 0x0000004a214a7220ULL, 0x004fc40000410000ULL,
0x000000011d247824ULL, 0x040fe200078e0224ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x000000011d387824ULL, 0x040fe400078e0238ULL, 0x000000101c1c7824ULL, 0x100fe200078e021bULL,
0x00001f234a1f7589ULL, 0x000ea200000e0000ULL, 0x000000103e3e7824ULL, 0x000fe400078e021bULL,
0x000000011d1c7824ULL, 0x040fe200078e021cULL, 0x0000000024247984ULL, 0x000f220000000800ULL,
0x000000011d3e7824ULL, 0x000fc400078e023eULL, 0x0000001040407824ULL, 0x100fe200078e021bULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x0000001042427824ULL, 0x100fe400078e021bULL,
0x000000011d407824ULL, 0x040fe200078e0240ULL, 0x000000001c1c7984ULL, 0x000f220000000800ULL,
0x000000011d427824ULL, 0x000fe400078e0242ULL, 0x0000001044447824ULL, 0x100fe200078e021bULL,
0x000000003e3e7984ULL, 0x000f220000000800ULL, 0x0000001046467824ULL, 0x000fc400078e021bULL,
0x000000011d447824ULL, 0x040fe200078e0244ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x000000011d467824ULL, 0x040fe400078e0246ULL, 0x000000103c3c7824ULL, 0x100fe200078e021bULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000001048487824ULL, 0x000fe200078e021bULL,
0x2000001aff1b7230ULL, 0x002fe20000004100ULL, 0x000000011d3c7824ULL, 0x040fe200078e023cULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x000000011d487824ULL, 0x000fe200078e0248ULL,
0x2000003aff1d7230ULL, 0x008fe20000004100ULL, 0x0000001f1b347223ULL, 0x084fe20000010034ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x2000001eff1b7230ULL, 0x000fe20000004100ULL,
0x000000354a357221ULL, 0x000fe20000010000ULL, 0x3000001aff1a7230ULL, 0x000fe20000004100ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x0000001f1d187223ULL, 0x080fe20000010018ULL,
0x20000020ff1d7230ULL, 0x000fe20000004100ULL, 0x0000001f1b327223ULL, 0x080fe20000010032ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x20000022ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1a337223ULL, 0x080fe20000010033ULL, 0x3000003aff3a7230ULL, 0x000fe20000004100ULL,
0x00001f254a4a7589ULL, 0x000e6200000e0000ULL, 0x0000001f1d307223ULL, 0x080fe20000010030ULL,
0x20000024ff1d7230ULL, 0x010fe20000004100ULL, 0x0000001f1b2e7223ULL, 0x080fe2000001002eULL,
0x20000036ff1b7230ULL, 0x100fe20000004100ULL, 0x0000001f3a177223ULL, 0x080fe20000010017ULL,
0x30000036ff367230ULL, 0x000fe20000004100ULL, 0x0000001f1d2c7223ULL, 0x080fe2000001002cULL,
0x2000001cff1d7230ULL, 0x000fe20000004100ULL, 0x0000001f1b2a7223ULL, 0x080fe2000001002aULL,
0x20000038ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f36297223ULL, 0x080fe20000010029ULL,
0x3000001eff1e7230ULL, 0x000fe20000004100ULL, 0x000000ffff367224ULL, 0x000fe200078e0037ULL,
0x30000020ff207230ULL, 0x000fe20000004100ULL, 0x0000001f1b287223ULL, 0x080fe20000010028ULL,
0x2000003eff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f1e317223ULL, 0x080fe20000010031ULL,
0x0000030036007a0cULL, 0x000fe20003f06070ULL, 0x30000022ff227230ULL, 0x000fe20000004100ULL,
0x0000001f202f7223ULL, 0x000fe2000001002fULL, 0x30000024ff247230ULL, 0x000fc40000004100ULL,
0x30000038ff387230ULL, 0x000fe20000004100ULL, 0x0000004a1d167223ULL, 0x082fe20000010016ULL,
0x20000040ff1d7230ULL, 0x000fe20000004100ULL, 0x0000004a1b147223ULL, 0x080fe20000010014ULL,
0x20000042ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f222d7223ULL, 0x080fe2000001002dULL,
0x3000001cff1c7230ULL, 0x000fe20000004100ULL, 0x0000004a1d127223ULL, 0x080fe20000010012ULL,
0x20000046ff1d7230ULL, 0x000fe20000004100ULL, 0x0000004a1b107223ULL, 0x080fe20000010010ULL,
0x20000044ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f242b7223ULL, 0x080fe2000001002bULL,
0x3000003eff3e7230ULL, 0x000fe20000004100ULL, 0x0000001f38277223ULL, 0x000fe20000010027ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000004a1b0e7223ULL, 0x080fe2000001000eULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000004a1d0c7223ULL, 0x080fe2000001000cULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000004a1c157223ULL, 0x080fe20000010015ULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004a3e137223ULL, 0x080fe20000010013ULL,
0x2000003cff1b7230ULL, 0x100fe20000004100ULL, 0x0000004a40117223ULL, 0x080fe20000010011ULL,
0x3000003cff1d7230ULL, 0x000fe20000004100ULL, 0x0000004a420f7223ULL, 0x080fe2000001000fULL,
0x20000048ff1f7230ULL, 0x100fe20000004100ULL, 0x0000004a440d7223ULL, 0x080fe2000001000dULL,
0x30000048ff217230ULL, 0x000fe20000004100ULL, 0x0000004a460b7223ULL, 0x000fc4000001000bULL,
0x0000004a1b0a7223ULL, 0x080fe4000001000aULL, 0x0000004a1d087223ULL, 0x080fe40000010008ULL,
0x0000004a1f067223ULL, 0x080fe40000010006ULL, 0x0000004a21027223ULL, 0x000fe20000010002ULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x0180000035047810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000004047812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000f59000097802ULL, 0x000fe40000000f00ULL,
0x0000736000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e0007ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003500047308ULL, 0x000e640000001000ULL,
0xbf80000004057423ULL, 0x002fc80000000035ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000197919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff1b7819ULL, 0x004fe20000011619ULL, 0x00000004191f7824ULL, 0x040fe200078e00ffULL,
0x0000000819207811ULL, 0x000fc600078ff0ffULL, 0x00001f1b04057589ULL, 0x000ea200000e0000ULL,
0x00000020ff227212ULL, 0x000fe200078e33ffULL, 0x00000008201d7824ULL, 0x040fe200078e00ffULL,
0x0000000c1f1f7812ULL, 0x000fe200078ec0ffULL, 0x00001f2004077589ULL, 0x00072600000e0000ULL,
0xfffffff81d227812ULL, 0x000fe400078ee222ULL, 0x00000007201d7812ULL, 0x000fc600078ec0ffULL,
0x0000001022227824ULL, 0x000fe200078e0203ULL, 0x000000041d197812ULL, 0x000fe400078e3cffULL,
0x0000001bff047212ULL, 0x008fc600078e33ffULL, 0x00000008201c7824ULL, 0x000fc800078e0219ULL,
0x000000101c1c7824ULL, 0x000fe400078e0203ULL, 0x0000003405347220ULL, 0x044fe40000410000ULL,
0x0000003305337220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003105317220ULL, 0x000fe20000410000ULL, 0x000000343333723eULL, 0x000fe200000000ffULL,
0x0000003005307220ULL, 0x000fc40000410000ULL, 0x0000002f052f7220ULL, 0x000fe20000410000ULL,
0x000000323131723eULL, 0x000fe200000000ffULL, 0x0000002e052e7220ULL, 0x040fe40000410000ULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x000000302f2f723eULL, 0x000fe200000000ffULL,
0x0000002c052c7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x0000002a052a7220ULL, 0x000fc40000410000ULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000002805287220ULL, 0x040fe40000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000001805187220ULL, 0x040fe40000410000ULL,
0x0000001705057220ULL, 0x000fe20000410000ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x000000081b177824ULL, 0x000fc400078e00ffULL, 0x0000000a070a7220ULL, 0x010fe20000410000ULL,
0x000000180505723eULL, 0x000fe200000000ffULL, 0x0000000807097220ULL, 0x000fe20000410000ULL,
0xfffffff817247812ULL, 0x000fe200078ee204ULL, 0x0000000c070c7220ULL, 0x000fe20000410000ULL,
0x000000071b047812ULL, 0x000fe200078ec0ffULL, 0x0000000b070b7220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000000ffULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000104087812ULL, 0x040fe200078e3cffULL, 0x0000000d070d7220ULL, 0x000fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x00000002040a7812ULL, 0x040fe200078e3cffULL, 0x0000001107117220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x00000003040c7812ULL, 0x040fe200078e3cffULL, 0x0000000f070f7220ULL, 0x000fe20000410000ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000001607167220ULL, 0x040fe20000410000ULL,
0x00000004040e7812ULL, 0x040fe200078e3cffULL, 0x0000001507157220ULL, 0x000fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000000504107812ULL, 0x040fe200078e3cffULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000000604127812ULL, 0x000fe200078e3cffULL, 0x0000000607067220ULL, 0x000fe20000410000ULL,
0x000000031d177812ULL, 0x000fe200078e3cffULL, 0x0000000207077220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000000081b027824ULL, 0x000fe200078e00ffULL,
0x000000021d147812ULL, 0x000fe200078e3cffULL, 0x000000081b047824ULL, 0x000fe200078e0208ULL,
0x000000060706723eULL, 0x000fe200000000ffULL, 0x0000000820077824ULL, 0x000fe200078e00ffULL,
0xfffffff802027812ULL, 0x000fe200078ee21bULL, 0x000000081b087824ULL, 0x000fe200078e020aULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x000000081b0a7824ULL, 0x000fc400078e020cULL,
0x000000081b0c7824ULL, 0x040fe400078e020eULL, 0x000000081b0e7824ULL, 0x040fe400078e0210ULL,
0x000000081b107824ULL, 0x000fe200078e0212ULL, 0xfffffff807127812ULL, 0x000fe200078ee220ULL,
0x0000001002027824ULL, 0x100fe200078e0203ULL, 0x000000011d077812ULL, 0x040fe200078e3cffULL,
0x0000001004047824ULL, 0x100fe200078e0203ULL, 0x000000051d1b7812ULL, 0x040fe200078e3cffULL,
0x0000001008087824ULL, 0x100fe200078e0203ULL, 0x000000061d1d7812ULL, 0x000fe200078e3cffULL,
0x000000100a0a7824ULL, 0x000fc400078e0203ULL, 0x000000011f027824ULL, 0x040fe400078e0202ULL,
0x000000100c0c7824ULL, 0x000fe400078e0203ULL, 0x0000000820167824ULL, 0x000fe200078e0207ULL,
0x0000003302007388ULL, 0x0005e20000000800ULL, 0x000000100e0e7824ULL, 0x000fe400078e0203ULL,
0x000000011f047824ULL, 0x000fe400078e0204ULL, 0x0000000820187824ULL, 0x000fc400078e0214ULL,
0x0000001010107824ULL, 0x000fe200078e0203ULL, 0x0000003104007388ULL, 0x0005e20000000800ULL,
0x000000011f087824ULL, 0x040fe400078e0208ULL, 0x00000008201a7824ULL, 0x000fe400078e0217ULL,
0x0000001024077824ULL, 0x100fe200078e0203ULL, 0x0000002f08007388ULL, 0x0005e20000000800ULL,
0x000000011f0a7824ULL, 0x000fe400078e020aULL, 0x0000001012147824ULL, 0x000fc400078e0203ULL,
0x000000011f0c7824ULL, 0x040fe200078e020cULL, 0x0000002d0a007388ULL, 0x0005e20000000800ULL,
0x00000008201e7824ULL, 0x000fe400078e021bULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x0000002b0c007388ULL, 0x0005e20000000800ULL, 0x000000011f0e7824ULL, 0x040fe400078e020eULL,
0x0000000820207824ULL, 0x000fe400078e021dULL, 0x0000001018187824ULL, 0x000fe200078e0203ULL,
0x000000290e007388ULL, 0x0005e20000000800ULL, 0x000000011f107824ULL, 0x000fc400078e0210ULL,
0x000000101a1a7824ULL, 0x000fe400078e0203ULL, 0x000000011f127824ULL, 0x040fe200078e0207ULL,
0x0000002710007388ULL, 0x0005e20000000800ULL, 0x000000011f147824ULL, 0x040fe400078e0214ULL,
0x000000101e1e7824ULL, 0x100fe200078e0203ULL, 0x0000000512007388ULL, 0x0005e20000000800ULL,
0x000000011f167824ULL, 0x040fe400078e0216ULL, 0x0000001020207824ULL, 0x000fe200078e0203ULL,
0x0000001514007388ULL, 0x0005e20000000800ULL, 0x000000011f187824ULL, 0x000fc400078e0218ULL,
0x000000011f1a7824ULL, 0x040fe200078e021aULL, 0x0000001316007388ULL, 0x0005e20000000800ULL,
0x000000011f1c7824ULL, 0x040fe400078e021cULL, 0x000000011f1e7824ULL, 0x040fe200078e021eULL,
0x0000001118007388ULL, 0x0005e20000000800ULL, 0x000000011f207824ULL, 0x040fe400078e0220ULL,
0x000000011f037824ULL, 0x000fe200078e0222ULL, 0x0000000f1a007388ULL, 0x0005e80000000800ULL,
0x0000000d1c007388ULL, 0x0005e80000000800ULL, 0x0000000b1e007388ULL, 0x0005e80000000800ULL,
0x0000000920007388ULL, 0x0005e80000000800ULL, 0x0000000603007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000157919ULL, 0x004ea20000000000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000f220000002600ULL,
0x0000000405057899ULL, 0x000fc6000800063fULL, 0x1ffffff876767812ULL, 0x000fe400078ec0ffULL,
0x0000002015177810ULL, 0x044fe20007ffe0ffULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x00000003ff027819ULL, 0x000fe20000011615ULL, 0x0000001014037824ULL, 0x050fe200078e00ffULL,
0x0000004015217810ULL, 0x040fe20007ffe0ffULL, 0x0000001014257824ULL, 0x040fe200078e00ffULL,
0x0000006015237810ULL, 0x000fe20007ffe0ffULL, 0x0000001014277824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc40000011617ULL, 0xfffffff003047812ULL, 0x000fe400078ee202ULL,
0x00000003ff087819ULL, 0x000fe40000011621ULL, 0x00000003ff0a7819ULL, 0x000fe40000011623ULL,
0x0000000702027812ULL, 0x000fe400078e4815ULL, 0x0000000705067812ULL, 0x000fe400078e4817ULL,
0x0000000708097812ULL, 0x000fc400078e4821ULL, 0x000000070a0b7812ULL, 0x000fe400078e4823ULL,
0x0ffffff802037812ULL, 0x000fe400078ef815ULL, 0x0ffffff806077812ULL, 0x000fe400078ef817ULL,
0x0ffffff809097812ULL, 0x000fe200078ef821ULL, 0x00000010030c7824ULL, 0x100fe200078e0200ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef823ULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0xfffffff025087812ULL, 0x000fe200078ee208ULL, 0x000000100b0b7824ULL, 0x000fe200078e0200ULL,
0x012000000c0c7984ULL, 0x000ea20000000c00ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0xfffffff0270a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0120000007107984ULL, 0x0007220000000c00ULL, 0x00005a0004027a11ULL, 0x000fc400078048ffULL,
0xfffffff000057812ULL, 0x000fe200078ee205ULL, 0x0120000009187984ULL, 0x0003220000000c00ULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL,
0x012000000b1c7984ULL, 0x0003220000000c00ULL, 0x0000000408007c10ULL, 0x000fe4000ff3e0ffULL,
0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x008fe200008e06ffULL,
0x00005a0000067a11ULL, 0x000fe200078248ffULL, 0x000000ffff097224ULL, 0x002fe200010e06ffULL,
0x00005a000a087a11ULL, 0x000fc400078448ffULL, 0x00000007760b7812ULL, 0x040fe400078ef815ULL,
0x0000000776157812ULL, 0x040fe400078ef817ULL, 0x00005b0005057a11ULL, 0x000fe200000f4c14ULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x0000000776177812ULL, 0x000fe400078ef821ULL,
0x00005b0000077a11ULL, 0x000fe200008f4c07ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000776217812ULL, 0x000fc400078ef823ULL, 0x00005b000a097a11ULL, 0x000fe200010f4c09ULL,
0x0000001017067825ULL, 0x000fc800078e0006ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000000c02007986ULL, 0x004fe8000c101d06ULL, 0x0000001004007986ULL, 0x010fe8000c101d06ULL,
0x0000001806007986ULL, 0x000fe8000c101d06ULL, 0x0000001c08007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff067624ULL, 0x002fe200078e00ffULL,
0x03ffffff76037812ULL, 0x000fe200078ec0ffULL, 0x00006900ff077624ULL, 0x000fc400078e00ffULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0000000478007824ULL, 0x000fe200078e0203ULL,
0x0000000606257981ULL, 0x000368000c1e9900ULL, 0x000000750000720cULL, 0x000fe40003f06070ULL,
0x0000000178087810ULL, 0x000fd60007ffe0ffULL, 0x0000000227038824ULL, 0x000fc800078e00ffULL,
0x0000640003048a24ULL, 0x000fc800078e0200ULL, 0x0000600004048625ULL, 0x000fca00078e0015ULL,
0x0000000604028981ULL, 0x000362000c1e1900ULL, 0x000000730800720cULL, 0x000fe20003f06070ULL,
0x0000000604047899ULL, 0x000fe2000800063fULL, 0x000000402f197824ULL, 0x000fe400078e00ffULL,
0x0000004076037824ULL, 0x000fd200078e00ffULL, 0x00000cc000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7919ULL, 0x002e620000000000ULL, 0x0000010078057824ULL, 0x000fe200078e0203ULL,
0x00002000761a7811ULL, 0x000fe200078e70ffULL, 0x0000000419197e24ULL, 0x020fe4000f8e0202ULL,
0x00000100ff357424ULL, 0x000fe200078e00ffULL, 0x0000000574047217ULL, 0x000fca0007800000ULL,
0x0000000104187824ULL, 0x000fe200078e0a05ULL, 0x00000003ff337819ULL, 0x002fc8000001161cULL,
0x00000010330b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000833057810ULL, 0x040fe40007ffe0ffULL,
0x0000000433077810ULL, 0x000fe20007ffe0ffULL, 0x000000080b237824ULL, 0x040fe200078e00ffULL,
0x0000001c0b087212ULL, 0x080fe200078e3cffULL, 0x00000008051f7824ULL, 0x040fe200078e00ffULL,
0x0000001c05047212ULL, 0x000fe200078e3cffULL, 0x00000008071d7824ULL, 0x000fe200078e00ffULL,
0x0000000c33097810ULL, 0x000fc40007ffe0ffULL, 0x0000001c07067212ULL, 0x080fe400078e3cffULL,
0xfffffff823237812ULL, 0x000fe200078ee208ULL, 0x000000101c087824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x0000000809217824ULL, 0x000fe200078e00ffULL,
0x0000003f33047812ULL, 0x000fe200078ec0ffULL, 0x0000001023237824ULL, 0x000fe200078e021aULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x0000001433117810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000001c09067212ULL, 0x000fe200078e3cffULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x0000007008377812ULL, 0x000fe200078ec0ffULL, 0x0000000811297824ULL, 0x000fe200078e00ffULL,
0x0000003f05087812ULL, 0x000fc400078ec0ffULL, 0xfffffff821217812ULL, 0x000fe400078ee206ULL,
0x0000001c11067212ULL, 0x000fe200078e3cffULL, 0x0000000119087824ULL, 0x000fe200078e0208ULL,
0x000000180500720cULL, 0x000fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e0035ULL,
0x0000003f090a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff829297812ULL, 0x000fe200078ee206ULL,
0x0000001021217824ULL, 0x000fe200078e021aULL, 0x0000003f07067812ULL, 0x000fc400078ec0ffULL,
0x000000180900720cULL, 0x000fe20003f06070ULL, 0x00005e0008087625ULL, 0x080fe200078e0035ULL,
0x00000004370c7210ULL, 0x000fe40007f3e0ffULL, 0x0000003f0b0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000119047824ULL, 0x000fe200078e020aULL, 0x0000000837087210ULL, 0x000fe20007f7e0ffULL,
0x0000000119067824ULL, 0x000fe200078e0206ULL, 0x000000180700720cULL, 0x080fe20003f86070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e0605ULL, 0x000000180b00720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x000fe200078e0035ULL, 0x0000001833177810ULL, 0x000fc40007ffe0ffULL,
0x0000001c332d7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0035ULL,
0x0000000733137812ULL, 0x000fe400078e481cULL, 0x0000003f2d147812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0609ULL, 0x0000000437107210ULL, 0x000fe20007f7e0ffULL,
0x00000001190a7824ULL, 0x000fe200078e020eULL, 0x0000003f11047812ULL, 0x000fe200078ec0ffULL,
0x00000008172b7824ULL, 0x000fe200078e00ffULL, 0x00000006370e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0035ULL, 0x0000003f17067812ULL, 0x000fc400078ec0ffULL,
0x00000020332f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000000a370a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0607ULL,
0x000000181100720cULL, 0x080fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200018e0605ULL,
0x0ffffff8131b7812ULL, 0x000fe200078ef81cULL, 0x00005e0004047625ULL, 0x080fe200078e0035ULL,
0x0000003f2f167812ULL, 0x000fe400078ec0ffULL, 0x000000183300720cULL, 0x000fe20003f66070ULL,
0x0000000119067824ULL, 0x000fe200078e0206ULL, 0x0000002433317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000437127210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fc800078e0035ULL, 0x0000000119047824ULL, 0x000fe400078e0214ULL,
0x000000ffff137224ULL, 0x000fe200030e0605ULL, 0x0000000637147210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fc800078e0035ULL, 0x0000000119067824ULL, 0x000fe400078e0216ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x0000000437167210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000001c17047212ULL, 0x000fe200078e3cffULL,
0x00005e0006067625ULL, 0x000fc600078e0035ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000d901c46ULL,
0x0000003f31047812ULL, 0x000fe200078ec0ffULL, 0x000000082d1e7824ULL, 0x000fe200078e00ffULL,
0x000000181700720cULL, 0x080fe20003f66070ULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000082f207824ULL, 0x000fe200078e00ffULL, 0x000000182d00720cULL, 0x000fe20003f86070ULL,
0x0000000119047824ULL, 0x000fe200078e0204ULL, 0x00000000081f7faeULL, 0x0007e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200030e0605ULL, 0x0000000637067210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0035ULL, 0x0000001c2d0d7212ULL, 0x082fe200078e3cffULL,
0x0000000010217faeULL, 0x0003e2000c101c46ULL, 0x0000001c2f1b7212ULL, 0x040fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000182f00720cULL, 0x000fe20003fa6070ULL,
0x0000001029297824ULL, 0x100fe200078e021aULL, 0xfffffff81e0f7812ULL, 0x004fe200078ee20dULL,
0x000000102b2b7824ULL, 0x100fe200078e021aULL, 0xfffffff8201b7812ULL, 0x000fe200078ee21bULL,
0x000000000a237faeULL, 0x0005e2000d101c46ULL, 0x00000004370c7210ULL, 0x000fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e021aULL, 0x0000002833097810ULL, 0x008fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000000012297faeULL, 0x0007e2000c901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000002c331d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000831057824ULL, 0x040fe200078e00ffULL, 0x00000000142b7faeULL, 0x0009e2000d901c46ULL,
0x0000001c31047212ULL, 0x000fe200078e3cffULL, 0x0000000809117824ULL, 0x002fe200078e00ffULL,
0x000000183100720cULL, 0x000fe20003fc6070ULL, 0x00000000160f7faeULL, 0x0003e2000e101c46ULL,
0xfffffff805057812ULL, 0x000fc400078ee204ULL, 0x0000003f09047812ULL, 0x000fe200078ec0ffULL,
0x00000000061b7faeULL, 0x0003e2000e901c46ULL, 0x000000081d137824ULL, 0x008fe200078e00ffULL,
0x00000030331f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010050b7824ULL, 0x004fe200078e021aULL,
0x0000003433217810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000003f1f0a7812ULL, 0x040fe200078ec0ffULL, 0x000000081f087824ULL, 0x000fe200078e00ffULL,
0x000000180900720cULL, 0x000fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e0035ULL,
0x000000000c0b7faeULL, 0x0005e2000f101c46ULL, 0x0000003833237810ULL, 0x000fc40007ffe0ffULL,
0x0000001c09067212ULL, 0x082fe200078e3cffULL, 0x00000008210e7824ULL, 0x000fe200078e00ffULL,
0x0000001c1f077212ULL, 0x080fe400078e3cffULL, 0xfffffff811117812ULL, 0x000fe400078ee206ULL,
0x0000001c1d067212ULL, 0x000fe400078e3cffULL, 0xfffffff808157812ULL, 0x010fe200078ee207ULL,
0x0000001011117824ULL, 0x000fe200078e021aULL, 0xfffffff813137812ULL, 0x000fc400078ee206ULL,
0x0000003f1d067812ULL, 0x000fe200078ec0ffULL, 0x0000001015157824ULL, 0x100fe200078e021aULL,
0x0000001c21097212ULL, 0x000fe200078e3cffULL, 0x0000001013137824ULL, 0x000fe200078e021aULL,
0x0000000437087210ULL, 0x000fe20007fde0ffULL, 0x0000000119067824ULL, 0x040fe200078e0206ULL,
0xfffffff80e177812ULL, 0x000fe200078ee209ULL, 0x0000000119047824ULL, 0x000fe200078e020aULL,
0x0000003f210c7812ULL, 0x004fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0035ULL,
0x0000003f230e7812ULL, 0x000fc400078ec0ffULL, 0x0000003c33297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0605ULL, 0x00000006370a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x080fe200078e0035ULL, 0x0000003f29107812ULL, 0x000fe400078ec0ffULL,
0x000000181d00720cULL, 0x080fe20003f86070ULL, 0x0000000119067824ULL, 0x000fe200078e020cULL,
0x000000181f00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x00000004370c7210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0035ULL,
0x000000182100720cULL, 0x080fe20003f46070ULL, 0x0000000008117faeULL, 0x0003e2000e901c46ULL,
0x000000182300720cULL, 0x080fe20003f26070ULL, 0x0000000119047824ULL, 0x000fe200078e020eULL,
0x000000182900720cULL, 0x000fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0x00000006370e7210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0035ULL,
0x0000001c29067212ULL, 0x040fe200078e3cffULL, 0x000000000a137faeULL, 0x0003e4000e101c46ULL,
0x00000008291b7824ULL, 0x000fc400078e00ffULL, 0x0000000119127824ULL, 0x000fe200078e0210ULL,
0x0000001c23107212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x0000000437047210ULL, 0x000fe20007fde0ffULL, 0x0000000823197824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x00005e0012067625ULL, 0x000fe200078e0035ULL,
0x000000000c157faeULL, 0x0003e4000d901c46ULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000000637067210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fc400078e021aULL, 0x0000001019197824ULL, 0x100fe400078e021aULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x000000000e177faeULL, 0x0003e2000d101c46ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000000419197e24ULL, 0x020fe4000f8e0202ULL,
0x00000100ff227424ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x002fc80000011604ULL,
0x00000004050b7810ULL, 0x040fe40007ffe0ffULL, 0x00000008050f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001805217810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c05137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f087824ULL, 0x000fe200078e00ffULL,
0x000000040b067212ULL, 0x080fe200078e3cffULL, 0x00000008210c7824ULL, 0x000fe200078e00ffULL,
0x0000001005177810ULL, 0x000fe20007ffe0ffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x000000040f077212ULL, 0x000fc400078e3cffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x00000008170a7824ULL, 0x000fe200078e00ffULL, 0x0000000421097212ULL, 0x080fe400078e3cffULL,
0x0000001c05297810ULL, 0x040fe40007ffe0ffULL, 0x00000028052f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000413067212ULL, 0x000fe200078e3cffULL, 0x00000008293b7824ULL, 0x000fe200078e00ffULL,
0xfffffff808117812ULL, 0x000fc400078ee207ULL, 0x0000000417077212ULL, 0x080fe400078e3cffULL,
0xfffffff80c237812ULL, 0x000fe200078ee209ULL, 0x000000082f0c7824ULL, 0x000fe200078e00ffULL,
0x00000020052b7810ULL, 0x040fe40007ffe0ffULL, 0x00000014051d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000002c05317810ULL, 0x000fe20007ffe0ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000429067212ULL, 0x000fc400078e3cffULL,
0x000000042f097212ULL, 0x080fe200078e3cffULL, 0x00000008314b7824ULL, 0x000fe200078e00ffULL,
0x0000003805377810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee207ULL,
0x000000082b0a7824ULL, 0x000fe200078e00ffULL, 0x00000024052d7810ULL, 0x000fe40007ffe0ffULL,
0x000000042b077212ULL, 0x000fe400078e3cffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee206ULL,
0x000000082d437824ULL, 0x000fe200078e00ffULL, 0xfffffff80c477812ULL, 0x000fe200078ee209ULL,
0x00000008370c7824ULL, 0x000fe200078e00ffULL, 0x0000003005337810ULL, 0x000fc40007ffe0ffULL,
0x000000041d087212ULL, 0x080fe400078e3cffULL, 0x0000000431067212ULL, 0x080fe400078e3cffULL,
0x0000000437097212ULL, 0x000fe400078e3cffULL, 0xfffffff80a3f7812ULL, 0x000fe200078ee207ULL,
0x00000008330a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee208ULL,
0xfffffff84b4b7812ULL, 0x000fc400078ee206ULL, 0x000000042d087212ULL, 0x080fe400078e3cffULL,
0x0000000433077212ULL, 0x000fe400078e3cffULL, 0xfffffff80c577812ULL, 0x000fe400078ee209ULL,
0x0000003f05067812ULL, 0x040fe400078ec0ffULL, 0x0000003405357810ULL, 0x040fe40007ffe0ffULL,
0x0000000705097812ULL, 0x000fc400078e4804ULL, 0x0000003c05397810ULL, 0x000fe20007ffe0ffULL,
0x0000000119057824ULL, 0x000fe200078e0206ULL, 0xfffffff843437812ULL, 0x000fe200078ee208ULL,
0x0000000835537824ULL, 0x040fe200078e00ffULL, 0xfffffff80a4f7812ULL, 0x000fe200078ee207ULL,
0x0000001004077824ULL, 0x000fe200078e00ffULL, 0x0000000435087212ULL, 0x080fe400078e3cffULL,
0x0ffffff809097812ULL, 0x000fe400078ef804ULL, 0x0000000439267212ULL, 0x000fc400078e3cffULL,
0x0000003f0b067812ULL, 0x000fe400078ec0ffULL, 0x0000003f0f0a7812ULL, 0x000fe400078ec0ffULL,
0x0000003f130c7812ULL, 0x000fe200078ec0ffULL, 0x00000001190b7824ULL, 0x000fe200078e0206ULL,
0x0000003f170e7812ULL, 0x000fe200078ec0ffULL, 0x00000001190f7824ULL, 0x000fe200078e020aULL,
0x0000003f1d107812ULL, 0x000fe200078ec0ffULL, 0x0000000119137824ULL, 0x000fe200078e020cULL,
0x0000003f21127812ULL, 0x000fe200078ec0ffULL, 0x0000000119177824ULL, 0x000fe200078e020eULL,
0x0000003f29147812ULL, 0x000fe200078ec0ffULL, 0x0000000839297824ULL, 0x000fe200078e00ffULL,
0x0000003f2b167812ULL, 0x000fe200078ec0ffULL, 0x00000001191d7824ULL, 0x000fe200078e0210ULL,
0x0000003f2d187812ULL, 0x000fe200078ec0ffULL, 0x0000000119217824ULL, 0x000fe200078e0212ULL,
0x0000003f2f1a7812ULL, 0x000fe200078ec0ffULL, 0x00000001193d7824ULL, 0x000fe200078e0216ULL,
0x0000003f311c7812ULL, 0x000fe200078ec0ffULL, 0x0000000119417824ULL, 0x000fe200078e0218ULL,
0x0000003f331e7812ULL, 0x000fe200078ec0ffULL, 0x0000000119457824ULL, 0x000fe200078e021aULL,
0x0000003f35207812ULL, 0x000fe200078ec0ffULL, 0x0000000119497824ULL, 0x000fe200078e021cULL,
0x0000003f37247812ULL, 0x000fe200078ec0ffULL, 0x00000001194d7824ULL, 0x000fe200078e021eULL,
0x0000003f39047812ULL, 0x000fe200078ec0ffULL, 0x0000000119397824ULL, 0x000fe200078e0214ULL,
0xfffffff853537812ULL, 0x000fe200078ee208ULL, 0x0000000119517824ULL, 0x040fe200078e0220ULL,
0x0000200076087811ULL, 0x000fe200078e70ffULL, 0x0000000119557824ULL, 0x000fc400078e0224ULL,
0x0000000119597824ULL, 0x000fe200078e0204ULL, 0xfffffff829197812ULL, 0x000fe200078ee226ULL,
0x00005e0005047625ULL, 0x000fe200078e0022ULL, 0x0000007007297812ULL, 0x000fc600078ec0ffULL,
0x00005e000b067625ULL, 0x000fe200078e0022ULL, 0x0000000429047210ULL, 0x000fc60007f1e0ffULL,
0x000000100d2d7824ULL, 0x100fe400078e0208ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000629067210ULL, 0x000fe20007f1e0ffULL, 0x00000010092b7824ULL, 0x100fe400078e0208ULL,
0x00000010112f7824ULL, 0x100fe400078e0208ULL, 0x0000001015317824ULL, 0x100fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000042b7faeULL, 0x0003e2000b901c46ULL,
0x000000101b337824ULL, 0x000fc400078e0208ULL, 0x000000101f357824ULL, 0x100fe400078e0208ULL,
0x0000001023377824ULL, 0x100fe400078e0208ULL, 0x000000103b3b7824ULL, 0x100fe400078e0208ULL,
0x000000103f3f7824ULL, 0x100fe400078e0208ULL, 0x0000001043437824ULL, 0x100fe400078e0208ULL,
0x0000001047477824ULL, 0x000fc400078e0208ULL, 0x000000104b4b7824ULL, 0x100fe400078e0208ULL,
0x000000104f4f7824ULL, 0x100fe400078e0208ULL, 0x0000001053537824ULL, 0x100fe400078e0208ULL,
0x0000001057577824ULL, 0x100fe400078e0208ULL, 0x00000010195b7824ULL, 0x000fe400078e0208ULL,
0x00005e00170c7625ULL, 0x000fc800078e0022ULL, 0x00005e000f087625ULL, 0x000fc800078e0022ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000c290c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0021107625ULL, 0x000fe200078e0022ULL, 0x0000000829087210ULL, 0x000fe40007f3e0ffULL,
0x00000000062d7faeULL, 0x0003e2000b901c46ULL, 0x00005e001d0e7625ULL, 0x000fc800078e0022ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000001029107210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000000e290e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e00130a7625ULL, 0x000fc600078e0022ULL, 0x00000000082f7faeULL, 0x0003e2000b901c46ULL,
0x00005e003d147625ULL, 0x000fe200078e0022ULL, 0x0000000a290a7210ULL, 0x000fc60007f5e0ffULL,
0x00005e0039127625ULL, 0x000fc800078e0022ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001429147210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000001229127210ULL, 0x000fe20007f3e0ffULL, 0x00005e00491a7625ULL, 0x000fc800078e0022ULL,
0x00005e0041167625ULL, 0x000fc800078e0022ULL, 0x00005e0045187625ULL, 0x000fc800078e0022ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000001a291a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000001629167210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000001829187210ULL, 0x000fe20007f5e0ffULL,
0x00005e004d1c7625ULL, 0x000fc600078e0022ULL, 0x000000000a317faeULL, 0x0003e2000b901c46ULL,
0x00005e00511e7625ULL, 0x000fc600078e0022ULL, 0x000000000c337faeULL, 0x0003e2000b901c46ULL,
0x00005e0055207625ULL, 0x000fc600078e0022ULL, 0x000000000e357faeULL, 0x0003e2000b901c46ULL,
0x00005e0059227625ULL, 0x000fc600078e0022ULL, 0x0000000010377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000001c291c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x0000001e291e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000002029207210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000002229227210ULL, 0x000fe20007f7e0ffULL,
0x00000000123b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400008e061fULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x00000000143f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc600018e0623ULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000018477faeULL, 0x0003e8000b901c46ULL, 0x000000001a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c4f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e537faeULL, 0x0003e8000b901c46ULL,
0x0000000020577faeULL, 0x0003e8000b901c46ULL, 0x00000000225b7faeULL, 0x0003e4000b901c46ULL,
0x01c60400ff047984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000004ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000037600780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002076047824ULL, 0x002fc800078e0205ULL, 0x0000002004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7804ULL, 0x0000000709097812ULL, 0x100fe400078e7804ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7804ULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7804ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000000090c7984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe200078e0013ULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fca00078e000fULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01c60400ff047984ULL, 0x000ea40000000800ULL,
0x8000000004ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0022a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000737800720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000247919ULL, 0x000ea20000000000ULL,
0x00005800ff2d7624ULL, 0x000fe200078e00ffULL, 0xffffffff73297810ULL, 0x000fe20007ffe0ffULL,
0x3d80000025257820ULL, 0x000fe20000410000ULL, 0x00007610ff287816ULL, 0x000fe20000000028ULL,
0x0000640027277a24ULL, 0x000fe400078e02ffULL, 0x0000001076267824ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x000000402d2d7824ULL, 0x000fc400078e00ffULL,
0x00000100782f7824ULL, 0x008fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002f7400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x020fea0003800000ULL,
0x000000ffff317224ULL, 0x000fe200078e002bULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x000000012a2e7810ULL, 0x000fe20007ffe0ffULL, 0x000016f000007945ULL, 0x000fe60003800000ULL,
0x00000001ff2b7819ULL, 0x000fc4000001162eULL, 0x000000022e00780cULL, 0x040fe40003f06070ULL,
0x000000012e507812ULL, 0x000fe200078ec0ffULL, 0x000003002b307a24ULL, 0x000fe200078e0278ULL,
0x00000001312b7812ULL, 0x000fc800078e0cffULL, 0x00000001302c7810ULL, 0x000fc80007ffe0ffULL,
0x000000732c00720cULL, 0x000fe20003f26070ULL, 0x000000ffff2c7224ULL, 0x000fe400078e002aULL,
0x000000ffff2a7224ULL, 0x000fd400078e002eULL, 0x00000bc000009947ULL, 0x020fea0003800000ULL,
0x0000010030337824ULL, 0x000fe200078e0203ULL, 0x00000003ff497819ULL, 0x004fe20000011624ULL,
0x000000042d3c7e24ULL, 0x000fe4000f8e0202ULL, 0x00000008503f7824ULL, 0x000fe200078e00ffULL,
0x00000033742e7217ULL, 0x000fe20007800000ULL, 0x00000100ff3e7424ULL, 0x000fe200078e00ffULL,
0x0000001049457810ULL, 0x040fe40007ffe0ffULL, 0x0000000449377810ULL, 0x040fe20007ffe0ffULL,
0x000000012e2e7824ULL, 0x000fe200078e0a33ULL, 0x0000000849397810ULL, 0x000fe20007ffe0ffULL,
0x0000000845367824ULL, 0x040fe200078e00ffULL, 0x0000002445337212ULL, 0x080fe200078e3cffULL,
0x00000008373d7824ULL, 0x000fe200078e00ffULL, 0x0000002049577810ULL, 0x000fe20007ffe0ffULL,
0x0000000839417824ULL, 0x000fe200078e00ffULL, 0x0000002437307212ULL, 0x000fc400078e3cffULL,
0x0000000c493b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff836477812ULL, 0x000fe200078ee233ULL,
0x0000000857367824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee230ULL,
0x000000083b437824ULL, 0x000fe200078e00ffULL, 0x00000018494f7810ULL, 0x000fe40007ffe0ffULL,
0x0000002439307212ULL, 0x080fe400078e3cffULL, 0x0000002457337212ULL, 0x000fe200078e3cffULL,
0x000000084f517824ULL, 0x000fe200078e00ffULL, 0x0000001c49537810ULL, 0x000fc40007ffe0ffULL,
0x000000243b327212ULL, 0x080fe400078e3cffULL, 0xfffffff841417812ULL, 0x000fe200078ee230ULL,
0x0000000853557824ULL, 0x000fe200078e00ffULL, 0xfffffff836597812ULL, 0x000fe400078ee233ULL,
0x000000244f307212ULL, 0x000fe400078e3cffULL, 0x0000003f49337812ULL, 0x000fe400078ec0ffULL,
0xfffffff843437812ULL, 0x000fc400078ee232ULL, 0x0000002453327212ULL, 0x000fe200078e3cffULL,
0x000000013c337824ULL, 0x000fe200078e0233ULL, 0xfffffff851517812ULL, 0x000fe200078ee230ULL,
0x0000000276307824ULL, 0x000fe200078e022bULL, 0x0000000749357812ULL, 0x040fe400078e4824ULL,
0x0000002e4900720cULL, 0x000fe40003f26070ULL, 0xfffffff855557812ULL, 0x000fe200078ee232ULL,
0x00005e0033327625ULL, 0x000fe200078e003eULL, 0x0000200030307811ULL, 0x000fc400078e68ffULL,
0xfffffff83f3f7812ULL, 0x100fe400078ee224ULL, 0x0ffffff835357812ULL, 0x000fe200078ef824ULL,
0x000000103d3d7824ULL, 0x000fe200078e0230ULL, 0x00000014494b7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f327825ULL, 0x000fe200078e0032ULL, 0x00000024495b7810ULL, 0x000fe40007ffe0ffULL,
0x000000244b347212ULL, 0x000fe200078e3cffULL, 0x0000001035357824ULL, 0x000fe200078e0230ULL,
0x00000028495f7810ULL, 0x000fe20007ffe0ffULL, 0x000000084b4d7824ULL, 0x000fe200078e00ffULL,
0x0000002c49637810ULL, 0x000fe20007ffe0ffULL, 0x000000085b5d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032357faeULL, 0x0003e2000c901c46ULL,
0x0000002e3700720cULL, 0x000fe20003f26070ULL, 0x000000085f617824ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee234ULL, 0x0000000863657824ULL, 0x000fe200078e00ffULL,
0x000000245b347212ULL, 0x000fe200078e3cffULL, 0x0000001041417824ULL, 0x100fe200078e0230ULL,
0x0000003f37377812ULL, 0x000fe200078ec0ffULL, 0x0000001043437824ULL, 0x000fe200078e0230ULL,
0x0000002e3900720cULL, 0x000fc40003f46070ULL, 0x0000003049677810ULL, 0x000fe20007ffe0ffULL,
0x000000013c337824ULL, 0x042fe200078e0237ULL, 0x0000003f39397812ULL, 0x000fe400078ec0ffULL,
0x0000002e3b00720cULL, 0x080fe20003f66070ULL, 0x0000000867697824ULL, 0x000fe200078e00ffULL,
0x0000003f3b3b7812ULL, 0x000fe200078ec0ffULL, 0x000000013c357824ULL, 0x000fe200078e0239ULL,
0x0000002e4500720cULL, 0x000fe20003f86070ULL, 0x00005e0033327625ULL, 0x000fe200078e003eULL,
0x0000003f45457812ULL, 0x000fc400078ec0ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee234ULL,
0x000000013c377824ULL, 0x040fe200078e023bULL, 0x000000245f347212ULL, 0x080fe200078e3cffULL,
0x000000013c397824ULL, 0x000fe200078e0245ULL, 0x0000002463367212ULL, 0x080fe200078e3cffULL,
0x000000103f327825ULL, 0x000fe200078e0032ULL, 0x0000002467387212ULL, 0x000fe400078e3cffULL,
0xfffffff861617812ULL, 0x000fe200078ee234ULL, 0x00005e0035347625ULL, 0x080fe200078e003eULL,
0xfffffff865657812ULL, 0x000fe200078ee236ULL, 0x00000000323d7faeULL, 0x0003e2000c901c46ULL,
0xfffffff869697812ULL, 0x000fe200078ee238ULL, 0x00005e0037367625ULL, 0x000fe200078e003eULL,
0x00000034496b7810ULL, 0x000fc40007ffe0ffULL, 0x0000002e4b00720cULL, 0x000fe20003fa6070ULL,
0x00005e0039387625ULL, 0x000fe200078e003eULL, 0x0000003f4b4b7812ULL, 0x000fe400078ec0ffULL,
0x000000246b3a7212ULL, 0x000fe200078e3cffULL, 0x000000103f347825ULL, 0x000fe200078e0034ULL,
0x0000002e4f00720cULL, 0x0c0fe40003f26070ULL, 0x0000003f4f4f7812ULL, 0x000fe200078ec0ffULL,
0x000000103f367825ULL, 0x000fe200078e0036ULL, 0x0000000034417faeULL, 0x0005e2000d101c46ULL,
0x0000002e5300720cULL, 0x000fc40003f46070ULL, 0x0000001047457824ULL, 0x000fe200078e0230ULL,
0x0000000036437faeULL, 0x0007e2000d901c46ULL, 0x000000103f387825ULL, 0x000fe200078e0038ULL,
0x0000003f53537812ULL, 0x000fe400078ec0ffULL, 0x0000002e5700720cULL, 0x000fe20003f66070ULL,
0x000000086b6d7824ULL, 0x000fe200078e00ffULL, 0x0000000038457faeULL, 0x0009e2000e101c46ULL,
0x000000013c3b7824ULL, 0x040fe200078e024bULL, 0x0000003f57577812ULL, 0x000fe200078ec0ffULL,
0x000000013c337824ULL, 0x002fe200078e024fULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee23aULL,
0x00005e003b3a7625ULL, 0x000fe200078e003eULL, 0x0000002e5b00720cULL, 0x000fc40003f86070ULL,
0x0000003f5b5b7812ULL, 0x000fe200078ec0ffULL, 0x000000013c357824ULL, 0x044fe400078e0253ULL,
0x000000013c377824ULL, 0x048fe200078e0257ULL, 0x0000003849457810ULL, 0x010fe20007ffe0ffULL,
0x000000013c397824ULL, 0x000fe400078e025bULL, 0x000000104d477824ULL, 0x000fe400078e0230ULL,
0x000000103f3a7825ULL, 0x000fc800078e003aULL, 0x00005e0033327625ULL, 0x000fe200078e003eULL,
0x000000003a477faeULL, 0x0003e2000e901c46ULL, 0x0000002e4500720cULL, 0x000fe40003fa6070ULL,
0x00005e0035347625ULL, 0x000fc800078e003eULL, 0x00005e0037367625ULL, 0x000fc800078e003eULL,
0x00005e0039387625ULL, 0x000fe200078e003eULL, 0x0000003c49477810ULL, 0x002fe40007ffe0ffULL,
0x00000024453a7212ULL, 0x000fe200078e3cffULL, 0x00000010513b7824ULL, 0x000fe200078e0230ULL,
0x0000002e4700720cULL, 0x000fe20003fc6070ULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x00000010553d7824ULL, 0x000fe200078e0230ULL, 0x00000000323b7faeULL, 0x0003e2000c901c46ULL,
0x000000103f347825ULL, 0x000fe200078e0034ULL, 0x0000002e5f00720cULL, 0x0c0fe40003f26070ULL,
0x0000003f5f5f7812ULL, 0x000fe200078ec0ffULL, 0x0000001059417824ULL, 0x000fe200078e0230ULL,
0x00000000343d7faeULL, 0x0005e2000d101c46ULL, 0x000000103f367825ULL, 0x000fe200078e0036ULL,
0x0000002e6300720cULL, 0x0c0fe40003f46070ULL, 0x0000003f63637812ULL, 0x000fe200078ec0ffULL,
0x000000105d437824ULL, 0x000fe200078e0230ULL, 0x0000000036417faeULL, 0x0007e2000d901c46ULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0x0000002e6700720cULL, 0x000fc40003f66070ULL,
0x0000003f67677812ULL, 0x000fe200078ec0ffULL, 0x0000000845497824ULL, 0x000fe200078e00ffULL,
0x0000000038437faeULL, 0x0009e2000e101c46ULL, 0x0000002e6b00720cULL, 0x040fe20003f86070ULL,
0x000000013c337824ULL, 0x042fe200078e025fULL, 0x0000003f6b6b7812ULL, 0x000fe200078ec0ffULL,
0x000000013c357824ULL, 0x044fe200078e0263ULL, 0x0000003f45457812ULL, 0x000fe200078ec0ffULL,
0x000000013c377824ULL, 0x008fe200078e0267ULL, 0x0000003f473d7812ULL, 0x000fe200078ec0ffULL,
0x00005e0033327625ULL, 0x000fe200078e003eULL, 0x00000024472e7212ULL, 0x000fc400078e3cffULL,
0xfffffff849497812ULL, 0x000fe200078ee23aULL, 0x000000013c397824ULL, 0x050fe400078e026bULL,
0x000000013c3b7824ULL, 0x040fe400078e0245ULL, 0x00000008474b7824ULL, 0x000fe400078e00ffULL,
0x000000013c3d7824ULL, 0x000fe400078e023dULL, 0x00005e0035347625ULL, 0x000fe200078e003eULL,
0xfffffff84b4b7812ULL, 0x000fc600078ee22eULL, 0x00005e0037367625ULL, 0x000fc800078e003eULL,
0x00005e0039387625ULL, 0x000fc800078e003eULL, 0x00005e003b3a7625ULL, 0x000fc800078e003eULL,
0x00005e003d3c7625ULL, 0x000fc800078e003eULL, 0x0000001061417824ULL, 0x000fe400078e0230ULL,
0x000000103f327825ULL, 0x000fc800078e0032ULL, 0x0000001065437824ULL, 0x000fe200078e0230ULL,
0x0000000032417faeULL, 0x0003e2000c901c46ULL, 0x000000103f347825ULL, 0x000fc800078e0034ULL,
0x0000001069457824ULL, 0x000fe200078e0230ULL, 0x0000000034437faeULL, 0x0003e2000d101c46ULL,
0x000000103f367825ULL, 0x000fc800078e0036ULL, 0x000000106d477824ULL, 0x000fe200078e0230ULL,
0x0000000036457faeULL, 0x0003e2000d901c46ULL, 0x000000103f387825ULL, 0x000fc800078e0038ULL,
0x0000001049497824ULL, 0x000fe200078e0230ULL, 0x0000000038477faeULL, 0x0003e2000e101c46ULL,
0x000000103f3a7825ULL, 0x000fc800078e003aULL, 0x000000104b4b7824ULL, 0x000fe200078e0230ULL,
0x000000003a497faeULL, 0x0003e2000e901c46ULL, 0x000000103f3c7825ULL, 0x000fca00078e003cULL,
0x000000003c4b7faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff337819ULL, 0x004fe20000011624ULL, 0x0000000850517824ULL, 0x000fe400078e00ffULL,
0x00000100ff4f7424ULL, 0x000fe200078e00ffULL, 0x0000000433397810ULL, 0x040fe40007ffe0ffULL,
0x0000000c33417810ULL, 0x040fe40007ffe0ffULL, 0x00000008333d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008393b7824ULL, 0x040fe200078e00ffULL, 0x00000024392e7212ULL, 0x000fe200078e3cffULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x0000001433497810ULL, 0x000fe20007ffe0ffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fc400078ee22eULL,
0x0000001c33537810ULL, 0x000fe20007ffe0ffULL, 0x00000008494b7824ULL, 0x000fe200078e00ffULL,
0x0000001033457810ULL, 0x000fe40007ffe0ffULL, 0x00000024412e7212ULL, 0x080fe200078e3cffULL,
0x00000008535f7824ULL, 0x000fe200078e00ffULL, 0x000000243d307212ULL, 0x000fe200078e3cffULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0x00000018334d7810ULL, 0x040fe40007ffe0ffULL,
0x0000002433577810ULL, 0x000fc40007ffe0ffULL, 0x0000002449327212ULL, 0x080fe200078e3cffULL,
0x000000084d5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee22eULL,
0x0000000857637824ULL, 0x000fe200078e00ffULL, 0x0000002c335b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee230ULL, 0x0000002033557810ULL, 0x000fe20007ffe0ffULL,
0x000000085b677824ULL, 0x000fe200078e00ffULL, 0x00000024532e7212ULL, 0x000fc400078e3cffULL,
0x0000002445307212ULL, 0x080fe200078e3cffULL, 0x0000000855617824ULL, 0x000fe200078e00ffULL,
0x0000002833597810ULL, 0x000fe40007ffe0ffULL, 0x000000244d347212ULL, 0x080fe400078e3cffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee232ULL, 0x0000000859657824ULL, 0x000fe200078e00ffULL,
0x00000034336d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002457327212ULL, 0x000fc400078e3cffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee22eULL, 0x000000086d6f7824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe400078ee230ULL, 0x0000003033697810ULL, 0x000fe40007ffe0ffULL,
0x000000245b2e7212ULL, 0x080fe400078e3cffULL, 0x0000002455307212ULL, 0x000fe200078e3cffULL,
0x00000008696b7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fc400078ee234ULL,
0x0000002459347212ULL, 0x080fe400078e3cffULL, 0xfffffff863637812ULL, 0x000fe400078ee232ULL,
0x0000003833717810ULL, 0x000fe40007ffe0ffULL, 0x000000246d327212ULL, 0x000fe400078e3cffULL,
0xfffffff867677812ULL, 0x000fe200078ee22eULL, 0x000000042d2e7e24ULL, 0x000fe2000f8e0202ULL,
0x0000003f33357812ULL, 0x000fe200078ec0ffULL, 0x0000000871777824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fc400078ee230ULL, 0x0000000733377812ULL, 0x000fe400078e4824ULL,
0x0000002469307212ULL, 0x080fe400078e3cffULL, 0x0000003c33337810ULL, 0x000fe40007ffe0ffULL,
0xfffffff865657812ULL, 0x000fe400078ee234ULL, 0x0000002471347212ULL, 0x000fe200078e3cffULL,
0x0000000833797824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee232ULL,
0x000000012e327824ULL, 0x000fe200078e0235ULL, 0x0000003f39397812ULL, 0x000fc400078ec0ffULL,
0x0000003f3d3d7812ULL, 0x000fe400078ec0ffULL, 0x0000003f41417812ULL, 0x000fe400078ec0ffULL,
0x0000003f45457812ULL, 0x000fe200078ec0ffULL, 0x000000012e367824ULL, 0x040fe200078e023dULL,
0x0000003f49497812ULL, 0x000fe200078ec0ffULL, 0x000000012e387824ULL, 0x040fe200078e0241ULL,
0x0000003f4d4d7812ULL, 0x000fe200078ec0ffULL, 0x000000012e3a7824ULL, 0x040fe200078e0245ULL,
0x0000003f53537812ULL, 0x000fe200078ec0ffULL, 0x000000012e3c7824ULL, 0x040fe200078e0249ULL,
0x0000003f55557812ULL, 0x000fe200078ec0ffULL, 0x000000012e3e7824ULL, 0x040fe200078e024dULL,
0x0000003f57577812ULL, 0x000fe200078ec0ffULL, 0x000000012e407824ULL, 0x040fe200078e0253ULL,
0x0000003f59597812ULL, 0x000fe200078ec0ffULL, 0x000000012e427824ULL, 0x040fe200078e0255ULL,
0x0000003f5b5b7812ULL, 0x000fe200078ec0ffULL, 0x000000012e447824ULL, 0x040fe200078e0257ULL,
0x0000003f69697812ULL, 0x000fe200078ec0ffULL, 0x000000012e467824ULL, 0x040fe200078e0259ULL,
0x0000003f6d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000012e487824ULL, 0x040fe200078e025bULL,
0x0000003f71717812ULL, 0x000fe200078ec0ffULL, 0x000000012e4a7824ULL, 0x000fe200078e0269ULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee230ULL, 0x0000000276307824ULL, 0x000fe200078e022bULL,
0x0000003f33357812ULL, 0x040fe200078ec0ffULL, 0x000000012e4c7824ULL, 0x040fe200078e026dULL,
0x0000002433527212ULL, 0x000fe200078e3cffULL, 0x000000012e4e7824ULL, 0x040fe200078e0271ULL,
0xfffffff877777812ULL, 0x000fe200078ee234ULL, 0x000000012e347824ULL, 0x000fe200078e0239ULL,
0x0000200030307811ULL, 0x000fe200078e68ffULL, 0x000000012e2e7824ULL, 0x000fe200078e0235ULL,
0xfffffff879357812ULL, 0x000fe200078ee252ULL, 0x00005e0032327625ULL, 0x000fe200078e004fULL,
0x0ffffff837377812ULL, 0x000fc400078ef824ULL, 0xfffffff851517812ULL, 0x000fe200078ee224ULL,
0x0000001035697824ULL, 0x100fe400078e0230ULL, 0x0000001037497824ULL, 0x000fe400078e0230ULL,
0x00005e0034347625ULL, 0x000fc800078e004fULL, 0x00005e0036367625ULL, 0x000fc800078e004fULL,
0x000000103b537824ULL, 0x000fe400078e0230ULL, 0x00005e0038387625ULL, 0x000fc800078e004fULL,
0x00005e003a3a7625ULL, 0x000fc800078e004fULL, 0x0000001051327825ULL, 0x000fc800078e0032ULL,
0x000000103f557824ULL, 0x000fe200078e0230ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032497faeULL, 0x0003e2000b901c46ULL, 0x00005e003c3c7625ULL, 0x000fc800078e004fULL,
0x00005e003e3e7625ULL, 0x000fc800078e004fULL, 0x0000001043577824ULL, 0x000fe400078e0230ULL,
0x00005e0040407625ULL, 0x000fc800078e004fULL, 0x0000001051347825ULL, 0x000fc800078e0034ULL,
0x00005e0042427625ULL, 0x000fe200078e004fULL, 0x0000000034537faeULL, 0x0005e6000b901c46ULL,
0x0000001051367825ULL, 0x000fc800078e0036ULL, 0x0000001047597824ULL, 0x000fe200078e0230ULL,
0x0000000036557faeULL, 0x0005e2000b901c46ULL, 0x00005e0044447625ULL, 0x000fc800078e004fULL,
0x0000001051387825ULL, 0x000fc800078e0038ULL, 0x00005e0046467625ULL, 0x000fe200078e004fULL,
0x0000000038577faeULL, 0x0005e6000b901c46ULL, 0x00000010513a7825ULL, 0x000fc800078e003aULL,
0x000000104b5b7824ULL, 0x000fe200078e0230ULL, 0x000000003a597faeULL, 0x0005e2000b901c46ULL,
0x00005e0048327625ULL, 0x002fc800078e004fULL, 0x00000010513c7825ULL, 0x000fc800078e003cULL,
0x000000105d5d7824ULL, 0x000fe200078e0230ULL, 0x000000003c5b7faeULL, 0x0005e2000b901c46ULL,
0x00005e004a487625ULL, 0x000fc800078e004fULL, 0x00000010513e7825ULL, 0x000fc800078e003eULL,
0x000000105f5f7824ULL, 0x000fe200078e0230ULL, 0x000000003e5d7faeULL, 0x0005e2000b901c46ULL,
0x00005e004c4a7625ULL, 0x000fc800078e004fULL, 0x0000001051407825ULL, 0x000fc800078e0040ULL,
0x0000001061617824ULL, 0x000fe200078e0230ULL, 0x00000000405f7faeULL, 0x0005e2000b901c46ULL,
0x00005e004e4c7625ULL, 0x000fc800078e004fULL, 0x0000001051427825ULL, 0x000fc800078e0042ULL,
0x0000001063637824ULL, 0x000fe200078e0230ULL, 0x0000000042617faeULL, 0x0005e2000b901c46ULL,
0x00005e002e4e7625ULL, 0x000fc800078e004fULL, 0x0000001051447825ULL, 0x000fc800078e0044ULL,
0x0000001065657824ULL, 0x000fe200078e0230ULL, 0x0000000044637faeULL, 0x0005e2000b901c46ULL,
0x0000001051467825ULL, 0x000fc800078e0046ULL, 0x0000001067677824ULL, 0x000fe200078e0230ULL,
0x0000000046657faeULL, 0x0005e2000b901c46ULL, 0x0000001051327825ULL, 0x000fc800078e0032ULL,
0x000000106b6b7824ULL, 0x000fe200078e0230ULL, 0x0000000032677faeULL, 0x0005e2000b901c46ULL,
0x0000001051487825ULL, 0x000fc800078e0048ULL, 0x000000106f6f7824ULL, 0x000fe200078e0230ULL,
0x00000000486b7faeULL, 0x0005e2000b901c46ULL, 0x00000010514a7825ULL, 0x000fc800078e004aULL,
0x0000001077777824ULL, 0x000fe200078e0230ULL, 0x000000004a6f7faeULL, 0x0005e2000b901c46ULL,
0x00000010514c7825ULL, 0x000fc800078e004cULL, 0x00000010514e7825ULL, 0x000fe200078e004eULL,
0x000000004c777faeULL, 0x0005e8000b901c46ULL, 0x000000004e697faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff5000720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x00000004ff337424ULL, 0x006fe400078e00ffULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x0000030033007a24ULL, 0x000fca00078e0200ULL, 0x000000750000720cULL, 0x000fda0003f26070ULL,
0x0000003000001947ULL, 0x000fea0003800000ULL, 0x0000000227327824ULL, 0x000fc800078e0200ULL,
0x0000600032327625ULL, 0x000fca00078e0033ULL, 0x0000000632027981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002024417810ULL, 0x006fe20007ffe0ffULL, 0x00000002763c7824ULL, 0x000fe200078e0231ULL,
0x0000000724317812ULL, 0x000fe200078ec0ffULL, 0x000000102c3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8243f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe400078ec0ffULL, 0x000020003c3c7811ULL, 0x000fe400078e68ffULL,
0x00000008312e7812ULL, 0x000fc400078ef824ULL, 0x000000073f3f7812ULL, 0x100fe400078ef824ULL,
0x0000000741417812ULL, 0x000fe200078ef824ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000072c307812ULL, 0x040fe200078e783fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000072c347812ULL, 0x040fe400078e7841ULL, 0x000000012c467810ULL, 0x040fe20007ffe0ffULL,
0x000000083f317824ULL, 0x000fe200078e0230ULL, 0x000000022c2c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000841357824ULL, 0x000fc400078e0234ULL, 0x0000001031317824ULL, 0x100fe200078e023cULL,
0x000000082c00780cULL, 0x000fe20003f25270ULL, 0x0000001035357824ULL, 0x000fc800078e023cULL,
0x000000003130783bULL, 0x000e680000000200ULL, 0x000000003534783bULL, 0x000ea20000000200ULL,
0x00000018ff387819ULL, 0x002fe20000011430ULL, 0x00010000313b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011431ULL, 0x00000038004a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fc40000011432ULL, 0x00000018ff447819ULL, 0x000fe40000011433ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff437819ULL, 0x004fe20000011434ULL,
0x00000039004e7306ULL, 0x0005e20000200c00ULL, 0x0000888030387816ULL, 0x002fe400000000ffULL,
0x00000018ff427819ULL, 0x000fe40000011435ULL, 0x00000018ff407819ULL, 0x000fc40000011436ULL,
0x00000018ff3e7819ULL, 0x000fe20000011437ULL, 0x0000003a00527306ULL, 0x0003e20000200c00ULL,
0x0001000030397824ULL, 0x044fe400078e00ffULL, 0x0000010030307824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003800487306ULL, 0x0005e20000200c00ULL, 0x00008880313a7816ULL, 0x042fe200000000ffULL,
0x0000010031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000030004d7306ULL, 0x0003e20000200c00ULL, 0x0000888032387816ULL, 0x004fce00000000ffULL,
0x00000039004b7306ULL, 0x0005e20000200c00ULL, 0x0001000032307824ULL, 0x042fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000003100517306ULL, 0x0003e20000200c00ULL, 0x0000888033397816ULL, 0x004fe400000000ffULL,
0x00000018ff327819ULL, 0x000fca0000011432ULL, 0x0000003800507306ULL, 0x0005e20000200c00ULL,
0x0001000033317824ULL, 0x042fe400078e00ffULL, 0x0000010033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000537306ULL, 0x0002e20000200c00ULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000000746387812ULL, 0x044fe400078e783fULL,
0x0000000746467812ULL, 0x000fc600078e7841ULL, 0x0000003200557306ULL, 0x0005e20000200c00ULL,
0x0000888034307816ULL, 0x002fe200000000ffULL, 0x0000000841457824ULL, 0x000fe400078e0246ULL,
0x0001000037467824ULL, 0x000fc800078e00ffULL, 0x0000003100577306ULL, 0x0003e20000200c00ULL,
0x0001000034327824ULL, 0x044fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000010034347824ULL, 0x000fe200078e00ffULL, 0x0000541050507816ULL, 0x008fe40000000053ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000003300597306ULL, 0x0005e20000200c00ULL,
0x0000888035317816ULL, 0x002fe400000000ffULL, 0x00000018ff347819ULL, 0x000fca0000011434ULL,
0x0000003000567306ULL, 0x0003e20000200c00ULL, 0x000000083f337824ULL, 0x004fc800078e0238ULL,
0x0000001033337824ULL, 0x000fc600078e023cULL, 0x00000032005b7306ULL, 0x0004e20000200c00ULL,
0x0001000035307824ULL, 0x042fe400078e00ffULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031005a7306ULL, 0x0003e20000200c00ULL,
0x0000001045327824ULL, 0x004fe200078e023cULL, 0x00000018ff357819ULL, 0x000fcc0000011435ULL,
0x0000003a004c7306ULL, 0x000fe20000200c00ULL, 0x0001000036317824ULL, 0x002fe200078e00ffULL,
0x0000541056567816ULL, 0x008fc8000000005bULL, 0x00000018ff457819ULL, 0x000fe40000011431ULL,
0x0000003b004f7306ULL, 0x000e700000200c00ULL, 0x0000003900547306ULL, 0x0004f00000200c00ULL,
0x00000030005d7306ULL, 0x0008e20000200c00ULL, 0x000000003338783bULL, 0x004ea20000000200ULL,
0x000054104c4c7816ULL, 0x002fcc000000004fULL, 0x0000003400587306ULL, 0x0003e20000200c00ULL,
0x000000003230783bULL, 0x010f220000000200ULL, 0x0000541054547816ULL, 0x008fcc0000000057ULL,
0x00000035005f7306ULL, 0x0007e20000200c00ULL, 0x0000888036347816ULL, 0x042fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x000054105a5a7816ULL, 0x000fc8000000005dULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x00000034005c7306ULL, 0x000fe20000200c00ULL,
0x0000888037357816ULL, 0x048fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x00000035005e7306ULL, 0x0005f00000200c00ULL,
0x0000003600637306ULL, 0x0003e20000200c00ULL, 0x00000018ff357819ULL, 0x004fe2000001143bULL,
0x000100003a6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011438ULL,
0x0000888039647816ULL, 0x000fe400000000ffULL, 0x00000018ff6a7819ULL, 0x000fe2000001146aULL,
0x0000003500707306ULL, 0x0005e20000200c00ULL, 0x00000018ff497819ULL, 0x010fe40000011430ULL,
0x00000018ff367819ULL, 0x002fe40000011439ULL, 0x00000018ff477819ULL, 0x000fc60000011431ULL,
0x0000004900727306ULL, 0x0003e20000200c00ULL, 0x0001000038357824ULL, 0x004fce00078e00ffULL,
0x0000003600687306ULL, 0x0005e20000200c00ULL, 0x0000003d24497211ULL, 0x002fe400078fe0ffULL,
0x000000043d3d7810ULL, 0x000fca0007ffe0ffULL, 0x0000003400627306ULL, 0x0003e20000200c00ULL,
0x00000018ff367819ULL, 0x004fe40000011435ULL, 0x0000000749357812ULL, 0x040fe400078e782eULL,
0x0000000249497810ULL, 0x000fc60007ffe0ffULL, 0x000000202e357824ULL, 0x000fe200078e0235ULL,
0x0000888038347816ULL, 0x042fe200000000ffULL, 0x0000004500617306ULL, 0x0002a20000200c00ULL,
0x0000010038387824ULL, 0x000fe200078e00ffULL, 0x0000000749497812ULL, 0x000fe200078e782eULL,
0x0000001035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000000202e497824ULL, 0x000fe200078e0249ULL, 0x0000003700677306ULL, 0x0007e20000200c00ULL,
0x00000018ff457819ULL, 0x002fce000001143aULL, 0x0000003400607306ULL, 0x0003e20000200c00ULL,
0x00000018ff377819ULL, 0x008fe40000011433ULL, 0x000054105c5c7816ULL, 0x004fca0000000061ULL,
0x00000045006e7306ULL, 0x000fe20000200c00ULL, 0x0001000039347824ULL, 0x042fe400078e00ffULL,
0x0000010039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011434ULL,
0x0000003700457306ULL, 0x000fe20000200c00ULL, 0x00000018ff397819ULL, 0x000fce0000011439ULL,
0x0000003600697306ULL, 0x0002b00000200c00ULL, 0x00000039006f7306ULL, 0x0007e20000200c00ULL,
0x000000003534783bULL, 0x002e6e0000000200ULL, 0x00000038006b7306ULL, 0x0009220000200c00ULL,
0x000100003b397824ULL, 0x008fe200078e00ffULL, 0x0000541060607816ULL, 0x004fc80000000069ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x000088803a387816ULL, 0x050fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000038006c7306ULL, 0x0007e20000200c00ULL,
0x000054106b617816ULL, 0x000fce0000000062ULL, 0x0000003900797306ULL, 0x0009e20000200c00ULL,
0x0000541048387816ULL, 0x008fe4000000004bULL, 0x0000541058577816ULL, 0x004fe40000000043ULL,
0x0000888032437816ULL, 0x000fc600000000ffULL, 0x0000006a00717306ULL, 0x0004e20000200c00ULL,
0x000054104d397816ULL, 0x010fe2000000004aULL, 0x000000563414723cULL, 0x002fe20000001814ULL,
0x00005410514d7816ULL, 0x000fe4000000004eULL, 0x0000541055517816ULL, 0x000fc60000000052ULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x00008880306a7816ULL, 0x004fe200000000ffULL,
0x000000383404723cULL, 0x040fec0000001804ULL, 0x00000066006d7306ULL, 0x0005e20000200c00ULL,
0x000000ffff387224ULL, 0x000fe200078e006aULL, 0x0000004c3408723cULL, 0x000fe20000001808ULL,
0x000054106c6c7816ULL, 0x008fca0000000071ULL, 0x0000004200427306ULL, 0x000ee20000200c00ULL,
0x000088803b667816ULL, 0x044fe200000000ffULL, 0x000001003b3b7824ULL, 0x000fe200078e00ffULL,
0x00005410635d7816ULL, 0x002fe20000000040ULL, 0x000000ffff407224ULL, 0x000fe200078e0043ULL,
0x00008880314c7816ULL, 0x000fe200000000ffULL, 0x0001000032437824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x00000050340c723cULL, 0x000fe4000000180cULL, 0x00000018ff437819ULL, 0x000fca0000011443ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000054105f5b7816ULL, 0x008fe20000000042ULL,
0x0000005c341c723cULL, 0x040fec000000181cULL, 0x0000004600657306ULL, 0x0007220000200c00ULL,
0x0000541059557816ULL, 0x002fe20000000044ULL, 0x000000ffff447224ULL, 0x000fe200078e004cULL,
0x0000005a3418723cULL, 0x040fea0000001818ULL, 0x0000003a00777306ULL, 0x0003e20000200c00ULL,
0x00000018ff467819ULL, 0x008fe20000011432ULL, 0x0000010032327824ULL, 0x000fe200078e00ffULL,
0x00005410675f7816ULL, 0x004fe2000000003eULL, 0x000000543410723cULL, 0x000fe60000001810ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x00000038004a7306ULL, 0x0005e20000200c00ULL,
0x00010000303a7824ULL, 0x002fe200078e00ffULL, 0x000054105e5e7816ULL, 0x010fe20000000065ULL,
0x0000010030307824ULL, 0x000fe200078e00ffULL, 0x000054106f657816ULL, 0x000fc40000000068ULL,
0x00000018ff487819ULL, 0x000fe4000001143aULL, 0x0000003b007b7306ULL, 0x0002e20000200c00ULL,
0x0000001049387824ULL, 0x004fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000005e3420723cULL, 0x000fea0000001820ULL, 0x00000048004b7306ULL, 0x0005220000200c00ULL,
0x000000003838783bULL, 0x002e620000000200ULL, 0x0001000033347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000003000497306ULL, 0x0009220000200c00ULL,
0x0001000031487824ULL, 0x004fe200078e00ffULL, 0x000054107b677816ULL, 0x008fc80000000070ULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x0000003200357306ULL, 0x0005e20000200c00ULL,
0x0000010031307824ULL, 0x010fe200078e00ffULL, 0x000054104a4a7816ULL, 0x000fc8000000004bULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000010033327824ULL, 0x004fe200078e00ffULL, 0x00005410494b7816ULL, 0x000fc80000000072ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000004800317306ULL, 0x000ff00000200c00ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000000603804723cULL, 0x042fee0000001804ULL,
0x0000003000427306ULL, 0x0003e20000200c00ULL, 0x0000004a3814723cULL, 0x000fee0000001814ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000888033307816ULL, 0x002fce00000000ffULL,
0x0000004600467306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000541064647816ULL, 0x004fe4000000006dULL, 0x00005410776d7816ULL, 0x000fca000000006eULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000000643808723cULL, 0x040fee0000001808ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fe20000000079ULL,
0x0000006c380c723cULL, 0x040fec000000180cULL, 0x0000003000367306ULL, 0x0003e40000200c00ULL,
0x000000663810723cULL, 0x000fec0000001810ULL, 0x0000003400337306ULL, 0x000ea20000200c00ULL,
0x0000541044307816ULL, 0x002fc40000000031ULL, 0x0000541042317816ULL, 0x000fca0000000047ULL,
0x0000003200327306ULL, 0x000e640000200c00ULL, 0x000000303818723cULL, 0x000fe20000001818ULL,
0x0000541036367816ULL, 0x004fcc0000000033ULL, 0x0000541040307816ULL, 0x000fe40000000043ULL,
0x0000541035317816ULL, 0x000fe40000000046ULL, 0x0000541032377816ULL, 0x002fca0000000045ULL,
0x00000030381c723cULL, 0x040ff0000000181cULL, 0x000000363820723cULL, 0x000fe20000001820ULL,
0xfffff0d000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff317224ULL, 0x000fe200078e002bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffd7f000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x01c6140026317984ULL, 0x000e620000000800ULL, 0x00000004252a7220ULL, 0x040fe20000410000ULL,
0x0000ffff28047812ULL, 0x000fe200078ec0ffULL, 0x0000001225357220ULL, 0x000fc40000410000ULL,
0x0000001325367220ULL, 0x040fe20000410000ULL, 0x00008880043d7816ULL, 0x000fe200000000ffULL,
0x0000001425127220ULL, 0x040fe40000410000ULL, 0x0000001525137220ULL, 0x000fe40000410000ULL,
0x800000003d047824ULL, 0x000fe400078e00ffULL, 0x00000006252c7220ULL, 0x040fe40000410000ULL,
0x00000007252e7220ULL, 0x000fc40000410000ULL, 0x0000000a25307220ULL, 0x040fe40000410000ULL,
0x0000000b25327220ULL, 0x040fe40000410000ULL, 0x0000001825147220ULL, 0x040fe40000410000ULL,
0x0000001925157220ULL, 0x040fe40000410000ULL, 0x0000000525057220ULL, 0x040fe40000410000ULL,
0x0000000825087220ULL, 0x000fc40000410000ULL, 0x0000000925097220ULL, 0x040fe40000410000ULL,
0x0000000c25067220ULL, 0x040fe40000410000ULL, 0x0000000d25077220ULL, 0x040fe40000410000ULL,
0x0000000e25337220ULL, 0x040fe40000410000ULL, 0x0000000f25347220ULL, 0x040fe40000410000ULL,
0x0000001625377220ULL, 0x000fe20000410000ULL, 0x8000000031ff7812ULL, 0x002fe20007804804ULL,
0x0000001725387220ULL, 0x000fc40000410000ULL, 0x0000001a25187220ULL, 0x040fe40000410000ULL,
0x0000001b25197220ULL, 0x040fe40000410000ULL, 0x0000001e25397220ULL, 0x040fe40000410000ULL,
0x0000001f253a7220ULL, 0x040fe40000410000ULL, 0x0000001c25167220ULL, 0x040fe40000410000ULL,
0x0000001d25177220ULL, 0x000fc40000410000ULL, 0x00000020251a7220ULL, 0x040fe40000410000ULL,
0x00000021251b7220ULL, 0x040fe40000410000ULL, 0x00000022253b7220ULL, 0x040fe40000410000ULL,
0x00000023253c7220ULL, 0x000fe40000410000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e002aULL,
0x000000ffff1c7224ULL, 0x000fc400078e002cULL, 0x000000ffff1d7224ULL, 0x000fe400078e002eULL,
0x000000ffff1e7224ULL, 0x000fe400078e0030ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0032ULL,
0x0000001025107220ULL, 0x040fe40000410000ULL, 0x0000001125117220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0005ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0008ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0006ULL,
0x000000ffff0f7224ULL, 0x000fe400078e0007ULL, 0x000000ffff207224ULL, 0x000fe400078e0033ULL,
0x000000ffff217224ULL, 0x000fc400078e0034ULL, 0x000000ffff227224ULL, 0x000fe400078e0035ULL,
0x000000ffff237224ULL, 0x000fe400078e0036ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0037ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0038ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0018ULL,
0x000000ffff307224ULL, 0x000fc400078e0019ULL, 0x000000ffff317224ULL, 0x000fe400078e0039ULL,
0x000000ffff327224ULL, 0x000fe200078e003aULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000ffff337224ULL, 0x000fe400078e003bULL,
0x000000ffff347224ULL, 0x000fe200078e003cULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000003d067824ULL, 0x000fe400078e00ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c6140026057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804806ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000424197824ULL, 0x000fe200078e00ffULL, 0x000000297800720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x0000008076187824ULL, 0x000fca00078e0205ULL, 0x01c4000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000224087824ULL, 0x000fe400078e00ffULL,
0x00000001742f7824ULL, 0x000fc600078e0a2fULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108367812ULL, 0x040fe400078efcffULL, 0x0000000808387812ULL, 0x000fe400078efcffULL,
0x0000002f3600720cULL, 0x080fe40003f26070ULL, 0x0000001008367812ULL, 0x000fe400078efcffULL,
0x0000002f3800720cULL, 0x080fe40003f06070ULL, 0x0000002f3600720cULL, 0x000fc40003fc6070ULL,
0x0000001108387812ULL, 0x040fe400078efcffULL, 0x0000001808367812ULL, 0x040fe400078efcffULL,
0x0000002f0800720cULL, 0x080fe40003f46070ULL, 0x0000002f3800720cULL, 0x080fe40003fa6070ULL,
0x0000002f3600720cULL, 0x000fe40003f66070ULL, 0x00000009083a7812ULL, 0x000fc400078efcffULL,
0x0000001908387812ULL, 0x040fe400078efcffULL, 0x0000002008367812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL,
0x0000002f3a00720cULL, 0x080fe40003f86070ULL, 0x0000002f3800720cULL, 0x080fe40003f46070ULL,
0x0000002f3600720cULL, 0x000fe40003f26070ULL, 0x0000002108387812ULL, 0x040fe400078efcffULL,
0x0000002808367812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000002f3800720cULL, 0x080fe40003f06070ULL,
0x0000002f3600720cULL, 0x000fe40003f86070ULL, 0x0000002908387812ULL, 0x000fc400078efcffULL,
0x0000003008367812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000002f3800720cULL, 0x000fc40003fc6070ULL,
0x0000002f3600720cULL, 0x000fe40003fa6070ULL, 0x0000003108387812ULL, 0x040fe400078efcffULL,
0x0000003808367812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000002f3800720cULL, 0x080fe40003f66070ULL, 0x0000002f3600720cULL, 0x000fc40003f46070ULL,
0x0000002f0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff2c2c7808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff30307808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff31317808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff32327808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff33337808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff34347808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000b04097209ULL, 0x004fe40007810000ULL, 0x0000001c05047209ULL, 0x000fe40007810000ULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fc40007810000ULL,
0x0000000c09047209ULL, 0x000fe40007810000ULL, 0x0000001e05087209ULL, 0x000fe40007810000ULL,
0x0000000d04057209ULL, 0x000fe40007810000ULL, 0x0000001f08097209ULL, 0x000fe40007810000ULL,
0x0000000e05047209ULL, 0x000fe40007810000ULL, 0x0000002009087209ULL, 0x000fc40007810000ULL,
0x0000000f04057209ULL, 0x000fe40007810000ULL, 0x0000002108097209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x0000002209087209ULL, 0x000fe40007810000ULL,
0x0000001104057209ULL, 0x000fe40007810000ULL, 0x0000002308097209ULL, 0x000fc40007810000ULL,
0x0000001205047209ULL, 0x000fe40007810000ULL, 0x0000002a09097209ULL, 0x000fe40007810000ULL,
0x0000001304057209ULL, 0x000fe40007810000ULL, 0x0000002c09097209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x0000002e09097209ULL, 0x000fc40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x0000003009047209ULL, 0x000fe40007810000ULL,
0x0000001605087209ULL, 0x000fe40007810000ULL, 0x0000003104057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003205047209ULL, 0x000fc40007810000ULL,
0x0000001a09087209ULL, 0x000fe40007810000ULL, 0x0000003304057209ULL, 0x000fe40007810000ULL,
0x0000001b08357209ULL, 0x000fe40007810000ULL, 0x0000003405377209ULL, 0x000fe20007810000ULL,
0x00000da27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0035047f89ULL, 0x0004e400000e0000ULL,
0x0000000435357209ULL, 0x00cfe20007810000ULL, 0x00000df27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037047f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006057f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007367f89ULL, 0x000f2200000e0000ULL, 0x0000000437087209ULL, 0x004fc60007810000ULL,
0x0c201f0035047f89ULL, 0x000ea200000e0000ULL, 0x0000000506097209ULL, 0x008fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000ee200000e0000ULL, 0x0000003607367209ULL, 0x010fc60007810000ULL,
0x0c201f0009387f89ULL, 0x002e6800000e0000ULL, 0x0c201f00362f7f89ULL, 0x00092200000e0000ULL,
0x0000000435047209ULL, 0x004fe40007810000ULL, 0x0000000508057209ULL, 0x008fe40007810000ULL,
0x0000003809067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff3c7424ULL, 0x002fe200078e00ffULL,
0x0000000000087886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b0b0b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x0000000b00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b11117823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b16167823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b17177823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL, 0x000000080908723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b051b7820ULL, 0x000fe40000410000ULL, 0x3c003c00ff3d7424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081bULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc4000001081bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081bULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x0000000c0d0a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b23237823ULL, 0x000fc4000001081bULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081bULL,
0x0000001e000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b32327823ULL, 0x000fc4000001081bULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b341b7823ULL, 0x000fe2000001081bULL, 0x0000001f00387308ULL, 0x000ee20000000800ULL,
0x0000001c1d09723eULL, 0x002fce00000000ffULL, 0x0000000f000f7308ULL, 0x000e620000000800ULL,
0x0000000b380b723eULL, 0x008fce00000000ffULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x0000003c0838723cULL, 0x000fe200000018ffULL, 0x0000000e0f0c723eULL, 0x002fcc00000000ffULL,
0x0000001100117308ULL, 0x000e700000000800ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ee20000000800ULL, 0x00000010110e723eULL, 0x002fce00000000ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000020210d723eULL, 0x008fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x002fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003c0c38723cULL, 0x000fee0000001838ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002c001d7308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe200000000ffULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc24147812ULL, 0x000fc800078ec0ffULL, 0x0000001415207219ULL, 0x000fe200000006ffULL,
0x0000002e002e7308ULL, 0x000fe60000000800ULL, 0x00000000200573c4ULL, 0x000eea0000004000ULL,
0x00000030001f7308ULL, 0x000f220000000800ULL, 0x0000002a1d11723eULL, 0x002fc400000000ffULL,
0x00000000201d73a1ULL, 0x000e6a00000e8000ULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x0000002e1f13723eULL, 0x010fce00000000ffULL, 0x0000001700177308ULL, 0x000f220000000800ULL,
0x0000003c1038723cULL, 0x000fee0000001838ULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x0000000820ff7c12ULL, 0x002fce000f80401dULL, 0x0000000700077308ULL, 0x000e620000000800ULL,
0x000000161714723eULL, 0x010fce00000000ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000f220000000800ULL, 0x0000001a0716723eULL, 0x002fe400000000ffULL,
0x000000362f077209ULL, 0x004fca0007810000ULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x0000001b001c7308ULL, 0x000e620000000800ULL, 0x000000313215723eULL, 0x010fe400000000ffULL,
0x000000331c17723eULL, 0x002fce00000000ffULL, 0x0000003c1438723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0205008947ULL, 0x008fde000b800000ULL,
0x001c1fff381c7589ULL, 0x0002a400000e0000ULL, 0x00000000201b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200573c4ULL, 0x000f220000004000ULL, 0x0000000000087886ULL, 0x000fe400038e0100ULL,
0x0000000820ff7c12ULL, 0x008fda000f80401bULL, 0x00000a1205008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1a7819ULL, 0x000fe40000011624ULL,
0x0000000c193d7812ULL, 0x000fc400078ec0ffULL, 0x000000071a1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081a2a7824ULL, 0x040fe200078e00ffULL, 0x0000001aff227212ULL, 0x002fe200078e33ffULL,
0x000000081a207824ULL, 0x008fe200078e00ffULL, 0x0000000324ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081a397824ULL, 0x040fe200078e00ffULL, 0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82a217812ULL, 0x100fe400078ee21bULL, 0x0000000120237812ULL, 0x100fe200078ef61bULL,
0x000000081a4b7824ULL, 0x000fe200078e00ffULL, 0x00000002202f7812ULL, 0x100fe200078ef61bULL,
0x000000081a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000320317812ULL, 0x000fc400078ef61bULL,
0x0000000420337812ULL, 0x140fe400078ef61bULL, 0x0000000520357812ULL, 0x140fe400078ef61bULL,
0x0000000620377812ULL, 0x000fe200078ef61bULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe400078ee222ULL, 0x0000001aff227212ULL, 0x000fe400078e33ffULL,
0x000000071a1b7812ULL, 0x000fc400078ec0ffULL, 0x00012000761a7811ULL, 0x000fe400078e58ffULL,
0xfffffff82a3b7812ULL, 0x100fe400078ee21bULL, 0x00000001203f7812ULL, 0x140fe200078ef61bULL,
0x0000001021197824ULL, 0x100fe200078e021aULL, 0x0000000220417812ULL, 0x140fe200078ef61bULL,
0x00000010332a7824ULL, 0x100fe200078e021aULL, 0x0000000320437812ULL, 0x040fe200078ef61bULL,
0x000000013d197824ULL, 0x000fe200078e0219ULL, 0x0000000420457812ULL, 0x140fe200078ef61bULL,
0x00000010352c7824ULL, 0x100fe200078e021aULL, 0x0000000520477812ULL, 0x140fe200078ef61bULL,
0x00000010372e7824ULL, 0x100fe200078e021aULL, 0x0000000620497812ULL, 0x000fe200078ef61bULL,
0x00000010231b7824ULL, 0x000fe200078e021aULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee222ULL,
0x000000102f207824ULL, 0x100fe200078e021aULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x0000001031227824ULL, 0x000fc400078e021aULL, 0x000000013d1b7824ULL, 0x040fe400078e021bULL,
0x000000013d217824ULL, 0x000fe400078e0220ULL, 0x0000001039307824ULL, 0x000fe200078e021aULL,
0x0000000a1b007388ULL, 0x0007e20000000800ULL, 0x000000013d237824ULL, 0x000fe400078e0222ULL,
0x000000103b327824ULL, 0x000fe200078e021aULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x000000013d2f7824ULL, 0x000fc400078e022aULL, 0x000000103f347824ULL, 0x000fe200078e021aULL,
0x0000000e23007388ULL, 0x0007e20000000800ULL, 0x000000013d317824ULL, 0x000fe400078e022cULL,
0x0000001041367824ULL, 0x000fe200078e021aULL, 0x000000102f007388ULL, 0x0007e20000000800ULL,
0x000000013d337824ULL, 0x000fe400078e022eULL, 0x0000001043377824ULL, 0x000fe200078e021aULL,
0x0000001231007388ULL, 0x0007e20000000800ULL, 0x000000013d357824ULL, 0x000fc400078e0230ULL,
0x0000001045387824ULL, 0x000fe200078e021aULL, 0x0000001433007388ULL, 0x0007e20000000800ULL,
0x000000013d327824ULL, 0x000fe400078e0232ULL, 0x0000001047397824ULL, 0x000fe200078e021aULL,
0x0000001635007388ULL, 0x0007e20000000800ULL, 0x000000013d347824ULL, 0x000fe400078e0234ULL,
0x00000010493a7824ULL, 0x000fe200078e021aULL, 0x0000000932007388ULL, 0x0007e20000000800ULL,
0x000000013d367824ULL, 0x000fc400078e0236ULL, 0x000000104b3b7824ULL, 0x000fe200078e021aULL,
0x0000000b34007388ULL, 0x0007e20000000800ULL, 0x000000013d087824ULL, 0x042fe400078e0237ULL,
0x000000013d387824ULL, 0x040fe200078e0238ULL, 0x0000000d36007388ULL, 0x0007e20000000800ULL,
0x000000013d1a7824ULL, 0x040fe400078e0239ULL, 0x000000013d3a7824ULL, 0x040fe200078e023aULL,
0x0000000f08007388ULL, 0x0007e20000000800ULL, 0x000000013d207824ULL, 0x000fc600078e023bULL,
0x0000001138007388ULL, 0x0007e80000000800ULL, 0x000000131a007388ULL, 0x0007e80000000800ULL,
0x000000153a007388ULL, 0x0007e80000000800ULL, 0x0000001720007388ULL, 0x0007e80000000800ULL,
0x01c0000418008388ULL, 0x0007e80000000c00ULL, 0x01c2001c18008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030078787a10ULL, 0x000fe20007ffe0ffULL,
0x01c6080026ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff28ff7812ULL, 0x000fc4000780c0ffULL,
0x000000737800720cULL, 0x000fe40003f26070ULL, 0x00000001ff287807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffbdc000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0035ULL,
0x0001645000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x000fe400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000063000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002fULL,
0xfffff1f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0037ULL,
0x000164d000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fe400078e00ffULL,
0x0000001fff397424ULL, 0x000fc400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000005b000007944ULL, 0x020fea0003c00000ULL, 0x0000002f373a7209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0006ULL, 0x0001654000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff387424ULL, 0x002fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000054000007944ULL, 0x000fea0003c00000ULL,
0x0000002f06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0007ULL,
0x000165b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff387424ULL, 0x002fc400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000004d000007944ULL, 0x000fea0003c00000ULL, 0x0000002f07367209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0035ULL, 0x0001662000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000046000007944ULL, 0x000fea0003c00000ULL,
0x0000002f35047209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e003aULL,
0x0001669000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000003f000007944ULL, 0x000fea0003c00000ULL, 0x0000002f3a057209ULL, 0x004fe20007810000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0006ULL, 0x0001670000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff387424ULL, 0x002fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3c7424ULL, 0x000fe400078e00ffULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x0000002f06067209ULL, 0x004fe20007810000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0036ULL,
0x0001677000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff387424ULL, 0x002fc400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0xffffefd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0038ULL, 0x000167d0001a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff227224ULL, 0x000fe400078e00ffULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e001fULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x002fe200078e003aULL,
0x00016840001a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff227224ULL, 0x000fe400078e00ffULL,
0x00001c1fff237424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff227224ULL, 0x002fe200078e00ffULL, 0x00016890001a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff237424ULL, 0x000fc400078e00ffULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff227224ULL, 0x002fe200078e00ffULL,
0x000168e0001a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0xfffff52000007947ULL, 0x000fea000383ffffULL, 0x0180000035047810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000004057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003500048308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff047807ULL, 0x004fc80004000000ULL, 0x0000000405ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff35ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff047807ULL, 0x000fc80000000000ULL, 0x0000000405ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000035057812ULL, 0x000fd600078ec0ffULL, 0x0080000005040812ULL, 0x000fe200078efcffULL,
0x000000ffff048224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003500047308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff077224ULL, 0x00cfe400078e0004ULL, 0x000000ffff047224ULL, 0x000fe400078e0009ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe958004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003c00007348ULL, 0x000fe80003800000ULL,
0x0c0000382f2f7389ULL, 0x0002a200000e0039ULL, 0xfffe954008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff1b7424ULL, 0x000fe200078e00ffULL, 0x0000002000007348ULL, 0x000fe80003800000ULL,
0x00000022211f7389ULL, 0x0002a200000e0023ULL, 0xfffe95001a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000210ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007a8ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000820ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eccULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ef0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f00ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f20ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f90ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f98ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016c00ULL, 0xe000001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017d80ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017d90ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017d90ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018210ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f90ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016df0ULL, 0x0000000000016df0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017d80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018210ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_64_nqpkv_16_m_16_sm_80_cubin_len = 99056;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
