/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000015778ULL, 0x00000000000152f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000013d00ULL, 0x0000000000000200ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000013f00ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00013d0000000000ULL, 0x0000780400000000ULL, 0x0400288080810c00ULL, 0x0000000000004ebcULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808892ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x00013d0000000000ULL,
0x0000020000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x00012a2000103104ULL, 0x00012a4000012a30ULL, 0x010c290400012a50ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002805000029ULL, 0x0500002905000028ULL, 0x0500002905000029ULL,
0x0500003e0500003eULL, 0x0500003e0500003eULL, 0x0500003e0500003eULL, 0x0500003e0500003eULL,
0x0500003e0500003eULL, 0x010c28040500003eULL, 0x00000100000000b0ULL, 0x0000191000001880ULL,
0x000019c000001990ULL, 0x00001e4000001d10ULL, 0x0000308000003030ULL, 0x0000440000004390ULL,
0x000044a000004470ULL, 0x000047a000004790ULL, 0x000059b0000059a0ULL, 0x00006c0000006b90ULL,
0x00006ca000006c70ULL, 0x00006fa000006f90ULL, 0x0000812000008110ULL, 0x0000940000009390ULL,
0x000094a000009470ULL, 0x0000994000009900ULL, 0x0000a9d00000a9c0ULL, 0x0000b9b00000b9a0ULL,
0x0000dba00000c120ULL, 0x0000e0700000dbd0ULL, 0x0000e5000000e090ULL, 0x0001236000012350ULL,
0x0001238000012370ULL, 0x000123d0000123b0ULL, 0x00012400000123f0ULL, 0x00012a3000012a10ULL,
0x00012a8000012a40ULL, 0x00012aa000012a90ULL, 0x000138a000013810ULL, 0x0001396000013900ULL,
0x00013a30000139d0ULL, 0x00013af000013a90ULL, 0x00013c2000013b80ULL, 0x06f0390400013cc0ULL,
0x000000ff00000230ULL, 0x0004010000010600ULL, 0x0000000c00000310ULL, 0x003f010000010608ULL,
0x0000000c00000420ULL, 0x003f010000010688ULL, 0x0000000300000540ULL, 0x003f0100000106a8ULL,
0x000000ff00000630ULL, 0x00040100000106b8ULL, 0x000000ff000008f0ULL, 0x0007010700010600ULL,
0x0000000d00000aa0ULL, 0x0007010100010688ULL, 0x000000ff00001010ULL, 0x00070107000106a8ULL,
0x000000ff00001050ULL, 0x00070101000106a8ULL, 0x000000ff000010d0ULL, 0x00070101000106b8ULL,
0x000000ff000011c0ULL, 0x000c010500000000ULL, 0x000000ff000012a0ULL, 0x00070109000106b8ULL,
0x000000ff00001710ULL, 0x00070107000106b0ULL, 0x000000ff00001740ULL, 0x00070101000106b0ULL,
0x000000ff00001780ULL, 0x000b010500000000ULL, 0x0000000d000017a0ULL, 0x0007010100010608ULL,
0x0000000d000017b0ULL, 0x0007010900010608ULL, 0x000000ff00001c10ULL, 0x00070109000106a8ULL,
0x000000ff00002980ULL, 0x00070101000106b8ULL, 0x000000ff00002a80ULL, 0x000c010500000000ULL,
0x000000ff00002de0ULL, 0x00070109000106b8ULL, 0x000000ff00002f60ULL, 0x000b010700000000ULL,
0x000000ff00002f90ULL, 0x00070101000106a8ULL, 0x000000ff00002fb0ULL, 0x000e010500000000ULL,
0x000000ff00002fd0ULL, 0x00070109000106b0ULL, 0x000000ff00003ec0ULL, 0x00070101000106b8ULL,
0x000000ff00003ee0ULL, 0x0007010100010688ULL, 0x000000ff00003f10ULL, 0x000c010500000000ULL,
0x000000ff00004140ULL, 0x00070109000106b8ULL, 0x000000ff000042c0ULL, 0x000e010700000000ULL,
0x000000ff00004300ULL, 0x00070101000106b0ULL, 0x000000ff00004310ULL, 0x000b010500000000ULL,
0x0000000d00004320ULL, 0x0007010100010628ULL, 0x0000000d00004330ULL, 0x0007010900010628ULL,
0x000000ff00004700ULL, 0x00070109000106a8ULL, 0x000000ff000053a0ULL, 0x00070101000106b8ULL,
0x000000ff00005450ULL, 0x000c010500000000ULL, 0x000000ff00005820ULL, 0x00070109000106b8ULL,
0x000000ff000058d0ULL, 0x000b010700000000ULL, 0x000000ff00005900ULL, 0x00070101000106a8ULL,
0x000000ff00005910ULL, 0x000e010500000000ULL, 0x000000ff00005930ULL, 0x00070109000106b0ULL,
0x000000ff00006780ULL, 0x00070101000106b8ULL, 0x000000ff00006790ULL, 0x0007010100010690ULL,
0x000000ff000067c0ULL, 0x000c010500000000ULL, 0x000000ff00006a30ULL, 0x00070109000106b8ULL,
0x000000ff00006ad0ULL, 0x000e010700000000ULL, 0x000000ff00006b00ULL, 0x00070101000106b0ULL,
0x000000ff00006b10ULL, 0x000b010500000000ULL, 0x0000000d00006b20ULL, 0x0007010100010648ULL,
0x0000000d00006b30ULL, 0x0007010900010648ULL, 0x000000ff00006f00ULL, 0x00070109000106a8ULL,
0x000000ff00007b10ULL, 0x00070101000106b8ULL, 0x000000ff00007c20ULL, 0x000c010500000000ULL,
0x000000ff00007fb0ULL, 0x00070109000106b8ULL, 0x000000ff00008060ULL, 0x000b010700000000ULL,
0x000000ff00008090ULL, 0x00070101000106a8ULL, 0x000000ff000080a0ULL, 0x000e010500000000ULL,
0x000000ff000080c0ULL, 0x00070109000106b0ULL, 0x000000ff00008f20ULL, 0x00070101000106b8ULL,
0x000000ff00008f30ULL, 0x0007010100010698ULL, 0x000000ff00008f70ULL, 0x000c010500000000ULL,
0x000000ff00009160ULL, 0x00070109000106b8ULL, 0x000000ff000092c0ULL, 0x000e010700000000ULL,
0x000000ff00009300ULL, 0x00070101000106b0ULL, 0x000000ff00009310ULL, 0x000b010500000000ULL,
0x0000000d00009320ULL, 0x0007010100010668ULL, 0x0000000d00009330ULL, 0x0007010900010668ULL,
0x000000ff00009700ULL, 0x00070109000106a8ULL, 0x000000ff0000a3b0ULL, 0x00070101000106b8ULL,
0x000000ff0000a540ULL, 0x000c010500000000ULL, 0x000000ff0000a850ULL, 0x00070109000106b8ULL,
0x000000ff0000a8f0ULL, 0x000b010700000000ULL, 0x000000ff0000a920ULL, 0x00070101000106a8ULL,
0x000000ff0000a930ULL, 0x000e010500000000ULL, 0x000000ff0000a950ULL, 0x00070109000106b0ULL,
0x000000ff0000b600ULL, 0x00070101000106b8ULL, 0x000000ff0000b630ULL, 0x00070101000106a0ULL,
0x000000ff0000e7b0ULL, 0x0007010100010600ULL, 0x000000ff0000f690ULL, 0x0007010900010600ULL,
0x000000ff0000f970ULL, 0x0007010100010600ULL, 0x000000ff0000f980ULL, 0x0007010900010600ULL,
0x0000000800011aa0ULL, 0x003f010100010688ULL, 0x0000000800011c20ULL, 0x003f010900010688ULL,
0x0000000900012d90ULL, 0x003f010100010608ULL, 0x0000000900012da0ULL, 0x003f010100010610ULL,
0x0000000900012db0ULL, 0x003f010100010618ULL, 0x0000000900012dc0ULL, 0x003f010100010620ULL,
0x0000001b00012e00ULL, 0x003f0109000106b8ULL, 0x0000000700012e60ULL, 0x003f010900010608ULL,
0x0000001500012ed0ULL, 0x003f0109000106a8ULL, 0x0000001100012f40ULL, 0x003f0109000106b8ULL,
0x0000001100012fb0ULL, 0x003f0109000106b0ULL, 0x0000007300013020ULL, 0x003f0109000106b8ULL,
0x0000000700013080ULL, 0x003f010900010628ULL, 0x00000015000130f0ULL, 0x003f0109000106a8ULL,
0x0000001100013160ULL, 0x003f0109000106b8ULL, 0x00000011000131d0ULL, 0x003f0109000106b0ULL,
0x0000002700013240ULL, 0x003f0109000106b8ULL, 0x00000007000132a0ULL, 0x003f010900010648ULL,
0x0000001500013310ULL, 0x003f0109000106a8ULL, 0x0000001100013380ULL, 0x003f0109000106b8ULL,
0x00000011000133f0ULL, 0x003f0109000106b0ULL, 0x0000002700013460ULL, 0x003f0109000106b8ULL,
0x00000007000134c0ULL, 0x003f010900010668ULL, 0x0000001500013530ULL, 0x003f0109000106a8ULL,
0x00000011000135a0ULL, 0x003f0109000106b8ULL, 0x0000001100013610ULL, 0x003f0109000106b0ULL,
0x0000001500013680ULL, 0x003f010900010600ULL, 0x0000000d000136f0ULL, 0x003f010900010600ULL,
0x0000000800013750ULL, 0x003f010900010688ULL, 0x00101c0400053803ULL, 0x0000f9a00000e760ULL,
0x00012de00000fa40ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x00080a0400581903ULL, 0x005802100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x0000000000000000ULL, 0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x0000000000013d00ULL,
0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x00000000000a7919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000000000f7919ULL, 0x000f2a0000002100ULL,
0x00008800ff087b82ULL, 0x000f620000000a00ULL, 0x00000000000b7919ULL, 0x000f620000002700ULL,
0x0000000000027919ULL, 0x000f620000000000ULL, 0x00000004ff0e7e24ULL, 0x008fc4000f8e00ffULL,
0x000000010a007824ULL, 0x004fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000fe400000e0000ULL,
0x0000008000037824ULL, 0x110fe200078e020fULL, 0x00000005ff0f7819ULL, 0x000fe2000001160fULL,
0x0000000000007919ULL, 0x000ea60000002600ULL, 0x0000007f0300780cULL, 0x040fe40003f64070ULL,
0x00001fff0f0f7589ULL, 0x000ee200000e0000ULL, 0x000000ff0300720cULL, 0x000fc40003f45270ULL,
0x0000000f0300780cULL, 0x040fe40003f04070ULL, 0x000000030300780cULL, 0x040fe40003fa4070ULL,
0x000000010300780cULL, 0x000fc80003f84070ULL, 0x000000000006b919ULL, 0x000f220000008800ULL,
0x000004000005b802ULL, 0x000fe20000000f00ULL, 0x000000040a047824ULL, 0x008fc800078e020fULL,
0x0000000204077824ULL, 0x000fe200078e00ffULL, 0x00000654060cb816ULL, 0x010fe20000000005ULL,
0x0000000800067824ULL, 0x004fe400078e00ffULL, 0xff317217ff05b424ULL, 0x000fe400078e00ffULL,
0x000000040304b824ULL, 0x000fe200078e020cULL, 0x0000000000242947ULL, 0x022fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01060006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000380947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x00000004030c7c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000000000c0612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01060804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000385947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x00000004030c7c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x000000000c0612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01068804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010400050400b388ULL, 0x0007e20000000800ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ff8000000057882ULL, 0x000fc60000000000ULL,
0x0000000403037c11ULL, 0x000fe2000f8e18ffULL, 0x001ffe0000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x00cfca0000000000ULL, 0x00000000030612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x0106a804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x0000000000242947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x0106b806043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000840000067ab9ULL, 0x002fe20000000800ULL, 0x00000000000579c3ULL, 0x000f220000008800ULL,
0x0000000306047899ULL, 0x000fe2000800063fULL, 0x0000000807047848ULL, 0x048fe20007fe0000ULL,
0x00000001070d7836ULL, 0x040fe20000000000ULL, 0x0000000707037812ULL, 0x000fe200078ec0ffULL,
0x0000820000087ab9ULL, 0x000fe40000000a00ULL, 0x000000040b067c24ULL, 0x000fe2000f8e0206ULL,
0x00008e00ff107b82ULL, 0x000ee20000000a00ULL, 0x0000000104047824ULL, 0x100fe200078e0a07ULL,
0x0000001f03127812ULL, 0x000fe200078e7802ULL, 0x0000000106057824ULL, 0x040fe200078e0207ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000106137824ULL, 0x000fc600078e020dULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x000000ff0400720cULL, 0x000fe20003f03070ULL,
0x0000001002067824ULL, 0x000fe200078e00ffULL, 0x000000010400780cULL, 0x000fe20003f23070ULL,
0x0000020005047825ULL, 0x000fc600078e0008ULL, 0x000001f006157812ULL, 0x000fe200078ec0ffULL,
0x0000020013087825ULL, 0x000fe200078e0008ULL, 0x000000070d137812ULL, 0x000fe200078ec0ffULL,
0x0000065405077896ULL, 0x010fe20008000004ULL, 0x00000015040c7210ULL, 0x000fe20007f5e0ffULL,
0x0000002007127824ULL, 0x000fe200078e0212ULL, 0x0000001f13147812ULL, 0x000fe200078e7802ULL,
0x0001060007047890ULL, 0x000fe2000fffe03fULL, 0x0000001508087210ULL, 0x000fe40007f7e0ffULL,
0x0000000712037c11ULL, 0x000fe2000f8e20ffULL, 0x000000200d147824ULL, 0x000fc400078e0214ULL,
0x000000ffff0d7224ULL, 0x000fe400010e0605ULL, 0x000000ffff097224ULL, 0x000fe200018e0609ULL,
0x0000000714077c11ULL, 0x000fe2000f8e20ffULL, 0x000000040b047825ULL, 0x008fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c037faeULL, 0x0003e8000c101c48ULL,
0x0000000008077faeULL, 0x0003e2000c901c48ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000804047981ULL, 0x000ea2000c1e1900ULL,
0x00000300ff037b82ULL, 0x002e620000000800ULL, 0x000000ff0a00720cULL, 0x000fe40003f05270ULL,
0x00000000040a72caULL, 0x004fda00000e0000ULL, 0x0000007f0a047890ULL, 0x000fe4000fffe03fULL,
0x000000ff0a057890ULL, 0x000fe4000fffe03fULL, 0x000000073f047899ULL, 0x000fe40008011604ULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x000000dc006c8947ULL, 0x002ff60003800000ULL,
0x000000020e5d7824ULL, 0x040fe400078e00ffULL, 0x000000080f0d7824ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x000fe20000011602ULL, 0x000001000e077824ULL, 0x000fe200078e00ffULL,
0x000000045d007c0cULL, 0x000fe2000bf06070ULL, 0x00008a00000c7ab9ULL, 0x000fd80000000a00ULL,
0x00009000ff0a8b82ULL, 0x000e620000000800ULL, 0x000000020b048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff088b82ULL, 0x000ea20000000a00ULL, 0x000000015d058824ULL, 0x002fc800078e020aULL,
0x0000000a04058224ULL, 0x000fe400078e0205ULL, 0xffffffffff047424ULL, 0x000fe400078e00ffULL,
0x00000004ff0a7424ULL, 0x000fe400078e00ffULL, 0x0000000405088825ULL, 0x004fe400078e0008ULL,
0x0106880a0dff79a7ULL, 0x0003e60008500007ULL, 0x0000000808048981ULL, 0x000522000c1e1900ULL,
0x000000040c147836ULL, 0x000fe20000000000ULL, 0x000000f006197812ULL, 0x000fe200078ec0ffULL,
0x000000010e057836ULL, 0x000fe20000000000ULL, 0x000106a8070b7890ULL, 0x000fe2000fffe03fULL,
0x000000020c107836ULL, 0x000fe20000000000ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000a070a7c48ULL, 0x002fe2000ffe0000ULL, 0x000000060c157836ULL, 0x000fe20000000000ULL,
0x0000000505007c0cULL, 0x000fe2000bf06070ULL, 0x000000010d087824ULL, 0x044fe200078e0214ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000010d117824ULL, 0x040fe200078e0210ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000010a0a7824ULL, 0x000fe200078e0a07ULL,
0x0000000708057812ULL, 0x000fe200078ec0ffULL, 0x000000010d077824ULL, 0x000fe200078e020cULL,
0x0000000711137812ULL, 0x000fc400078ec0ffULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000f05097812ULL, 0x000fe400078e7802ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x000000200a0a7807ULL, 0x000fe40000000000ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000707057812ULL, 0x000fc400078ec0ffULL, 0x0000000f13127812ULL, 0x000fe200078e7802ULL,
0x0000001008137824ULL, 0x000fe200078e0209ULL, 0x0000000a0d0a7248ULL, 0x000fe40007fe0000ULL,
0x0000000f05087812ULL, 0x000fe200078e7802ULL, 0x0000001011127824ULL, 0x000fe400078e0212ULL,
0x000000010a0a7824ULL, 0x000fe400078e0a0dULL, 0x0000001007097824ULL, 0x000fe400078e0208ULL,
0x0000008000087824ULL, 0x000fe200078e0207ULL, 0x0000000a0c00720cULL, 0x080fe20003f26070ULL,
0x000000010d117824ULL, 0x000fe200078e0215ULL, 0x0000000a1400720cULL, 0x080fe20003f06070ULL,
0x00000002080c7836ULL, 0x000fe20000000000ULL, 0x0000000a1000720cULL, 0x000fe20003f46070ULL,
0x0000000408107836ULL, 0x000fe20000000000ULL, 0x0000000711177812ULL, 0x000fc800078ec0ffULL,
0x0000000f17167812ULL, 0x000fca00078e7802ULL, 0x0000001011177824ULL, 0x000fe400078e0216ULL,
0x0000000604057c24ULL, 0x010fe2000f8e02ffULL, 0x0000c00007067890ULL, 0x000fc6000fffe03fULL,
0x0000008005057824ULL, 0x000fca00078e00ffULL, 0x00000008051b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000608087836ULL, 0x000fe20000000000ULL, 0x0000000c050c7210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x0000000c1b1a7c11ULL, 0x040fe2000f8640ffULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x0000000c0c117c11ULL, 0x040fe4000f8840ffULL,
0x0000000d1b1b7c11ULL, 0x000fe400098f4414ULL, 0x0000001005107210ULL, 0x000fe40007f7e0ffULL,
0x0000000805087210ULL, 0x000fe40007fbe0ffULL, 0x0000000d0c187c11ULL, 0x000fe2000a0f4407ULL,
0x000000ffff077224ULL, 0x000fe200018e06ffULL, 0x0000000c10147c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x0000000c08167c11ULL, 0x000fc4000f8a40ffULL,
0x0000000a1500720cULL, 0x000fe40003f66070ULL, 0x0000000d100c7c11ULL, 0x000fe4000a0f4407ULL,
0x0000001a19067210ULL, 0x000fe40007f9e0ffULL, 0x0000000d080a7c11ULL, 0x000fe4000a8f4405ULL,
0x0000001911087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fe200020e061bULL,
0x0000000609057c11ULL, 0x000fc4000f8e20ffULL, 0x0000001914147210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0618ULL, 0x0000001916167210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000c901c48ULL,
0x0000000612117c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff157224ULL, 0x000fe200020e060cULL,
0x0000000613197c11ULL, 0x000fe4000f8e20ffULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x00000006171b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff177224ULL, 0x000fe200028e060aULL,
0x0000000008117faeULL, 0x0005e8000d101c48ULL, 0x0000000014197faeULL, 0x0007e2000c101c48ULL,
0x000000050e007c0cULL, 0x000fe2000bf06070ULL, 0x00000001ff077424ULL, 0x002fc400078e00ffULL,
0x00000000161b7faeULL, 0x0007e2000d901c48ULL, 0xff317217ff057424ULL, 0x000fe400078e00ffULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000107805ULL, 0x004fe2000001ff00ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4bULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a807ff6e79a7ULL, 0x000e620008500007ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0106b807ff1479a7ULL, 0x0084e20008500007ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x000000070d077c36ULL, 0x004fe20008000000ULL,
0x000000a400b80947ULL, 0x008fec0003800000ULL, 0x00009000ff057b82ULL, 0x000ea20000000800ULL,
0x000000020b087824ULL, 0x000fe200078e00ffULL, 0x000106b8070c7890ULL, 0x000fe2000fffe03fULL,
0x000000040f097824ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x00000002090b7836ULL, 0x000fe40000000000ULL, 0x0000000508087224ULL, 0x004fe400078e0205ULL,
0xff317217ff057424ULL, 0x000fce00078e00ffULL, 0x000001000e0a7824ULL, 0x000fca00078e00ffULL,
0x0000000a0a007c0cULL, 0x000fda000bf06070ULL, 0x000000a400800947ULL, 0x000fea0003800000ULL,
0x00000015ff0075a7ULL, 0x008ea2000802004cULL, 0x000000200e0a7811ULL, 0x040fe200078e40ffULL,
0x00008400000f7ab9ULL, 0x000fe20000000800ULL, 0x00000004ff507819ULL, 0x000fe20000011602ULL,
0x000000010e167836ULL, 0x000fe20000000000ULL, 0x0000000a0a177c48ULL, 0x000fe2000ffe0000ULL,
0x0000000f046c7c24ULL, 0x000fe2000f8e02ffULL, 0x00000020006a7811ULL, 0x000fe200078e38ffULL,
0x000000010d697824ULL, 0x000fe200078e0250ULL, 0x0000000516007c0cULL, 0x000fe2000bf06070ULL,
0x0000000117177824ULL, 0x000fc400078e0a0aULL, 0x000000806c6c7824ULL, 0x000fe400078e00ffULL,
0x0000000169197824ULL, 0x000fe200078e026aULL, 0x0000000000081947ULL, 0x004fee0003800000ULL,
0x0106b815ff0075a7ULL, 0x000ea40008020147ULL, 0x0000011800cc9947ULL, 0x004fea0003800000ULL,
0x000000196c197210ULL, 0x000fe20007f3e0ffULL, 0x00000002504e7836ULL, 0x040fe20000000000ULL,
0x00008a0000107ab9ULL, 0x000fe20000000a00ULL, 0x00000004504c7836ULL, 0x040fe20000000000ULL,
0x00000020170a7807ULL, 0x000fe20000000000ULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000001019277c11ULL, 0x000fe2000f8240ffULL, 0x000000010d677824ULL, 0x040fe200078e024eULL,
0x0000000a0d0a7248ULL, 0x040fe20007fe0000ULL, 0x000000010d5f7824ULL, 0x000fe200078e024cULL,
0x0000001119167c11ULL, 0x000fe200088f4416ULL, 0x0000000650487836ULL, 0x000fe20000000000ULL,
0x0000e000070d7890ULL, 0x000fe2000fffe03fULL, 0x0000000167157824ULL, 0x100fe200078e026aULL,
0x000106b0070e7890ULL, 0x000fe2000fffe03fULL, 0x000000015f197824ULL, 0x000fc400078e026aULL,
0x000000010d437824ULL, 0x000fe200078e0248ULL, 0x000000156c187210ULL, 0x000fe20007f3e0ffULL,
0x0000001002457824ULL, 0x000fe200078e00ffULL, 0x000000196c247210ULL, 0x000fe20007f5e0ffULL,
0x0000000143157824ULL, 0x000fe400078e026aULL, 0x000000ffff1b7224ULL, 0x000fe200008e06ffULL,
0x0000001018257c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000001024197c11ULL, 0x000fe4000f8440ffULL, 0x000000156c147210ULL, 0x000fe20007f7e0ffULL,
0x000000010a157824ULL, 0x000fe200078e0a0dULL, 0x0000001124247c11ULL, 0x000fc400090f4417ULL,
0x0000001118187c11ULL, 0x000fe200088f441bULL, 0x000000ffff177224ULL, 0x000fe200018e06ffULL,
0x00000010141b7c11ULL, 0x000fe4000f8a40ffULL, 0x000000155000720cULL, 0x080fe40003f66070ULL,
0x000000154e00720cULL, 0x080fe40003f86070ULL, 0x000000154c00720cULL, 0x080fe40003f46070ULL,
0x000000154800720cULL, 0x000fc40003f26070ULL, 0x00000011140a7c11ULL, 0x000fe4000a8f4417ULL,
0x0000000769157812ULL, 0x000fe400078ec0ffULL, 0x000000f045427812ULL, 0x000fe400078ec0ffULL,
0x0000000767177812ULL, 0x000fe400078ec0ffULL, 0x0000000f151a7812ULL, 0x000fe400078e7802ULL,
0x0000004227147210ULL, 0x000fc40007fbe0ffULL, 0x0000000f17527812ULL, 0x000fe200078e7802ULL,
0x0000001069497824ULL, 0x000fe200078e021aULL, 0x000000075f277812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200028e0616ULL, 0x0000004225167210ULL, 0x000fe20007fbe0ffULL,
0x0000001067527824ULL, 0x000fe200078e0252ULL, 0x0000000743257812ULL, 0x000fe400078ec0ffULL,
0x0000000d495c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff177224ULL, 0x000fe200028e0618ULL,
0x0000000d525b7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f271a7812ULL, 0x000fe200078e7802ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000145c7faeULL, 0x000fe2000d901c48ULL,
0x0000000f25267812ULL, 0x000fe400078e7802ULL, 0x0000004219187210ULL, 0x000fe20007f7e0ffULL,
0x00000000165b7faeULL, 0x0007e2000e101c48ULL, 0x000000105f517824ULL, 0x000fe200078e021aULL,
0x000000421b1a7210ULL, 0x000fe20007f9e0ffULL, 0x00000010434f7824ULL, 0x000fe400078e0226ULL,
0x000000ffff197224ULL, 0x000fe200018e0624ULL, 0x0000000d51477c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e060aULL, 0x0000000d4f467c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff0a7424ULL, 0x000fc400078e00ffULL, 0x0000000018477faeULL, 0x0007e8000d101c48ULL,
0x000000001a467faeULL, 0x0007e2000c901c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106b00aff7079a7ULL, 0x0004a20008500007ULL, 0x00000001ff167819ULL, 0x008fe40000011602ULL,
0x0000007045457812ULL, 0x000fe400078ec0ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x0000006fff0075a7ULL, 0x0024a6000802004bULL, 0x0000000716457c10ULL, 0x000fe2000fffe045ULL,
0x0106080a0d1479a7ULL, 0x000ee40008500007ULL, 0x010608150d0075a7ULL, 0x008ee40008040147ULL,
0x0000011400a4a947ULL, 0x00efea0003800000ULL, 0x0100000045147984ULL, 0x000e620000000800ULL,
0x0000000802177812ULL, 0x040fe200078ec0ffULL, 0x00000001ff587424ULL, 0x000fe200078e00ffULL,
0x0000000902167211ULL, 0x000fe200078fe0ffULL, 0x0102000045657984ULL, 0x0004a20000000800ULL,
0x00000007176b7812ULL, 0x000fe400078ec802ULL, 0x0000000717567812ULL, 0x000fe400078ef802ULL,
0x000000166b197212ULL, 0x000fca00078e3cffULL, 0x0000001056537824ULL, 0x000fca00078e0219ULL,
0x0000000653447c11ULL, 0x000fe4000f8e20ffULL, 0x000000051400720bULL, 0x002fda0003f5d000ULL,
0x0000000000157806ULL, 0x000fc800010e0100ULL, 0x0000ffff15187812ULL, 0x000fda000784c0ffULL,
0x0000000000d4a947ULL, 0x004fea0003800000ULL, 0x000000051400720bULL, 0x000fe40003f54000ULL,
0x00000014051a7209ULL, 0x000fe40007810000ULL, 0x00000002ff167819ULL, 0x000fc60000011602ULL,
0x8000001a05157221ULL, 0x100fe40000010000ULL, 0x0000000816177836ULL, 0x000fe40000000000ULL,
0x3fb8aa3b15157820ULL, 0x000fe40000410000ULL, 0x0000000000057806ULL, 0x000fe400010e0100ULL,
0x000000ff0f00720cULL, 0x000fe40003f45270ULL, 0x0000ffff05057812ULL, 0x000fe200078e3cffULL,
0x0000001500157308ULL, 0x000e660000000800ULL, 0x0000000518ff7212ULL, 0x000fe2000786c0ffULL,
0x000000ffff057224ULL, 0x000fc600078e001aULL, 0x00000001ff587807ULL, 0x000fc60001800000ULL,
0x0104001a4500a388ULL, 0x000fe80000000800ULL, 0x00001f1715177589ULL, 0x002e6400000e0000ULL,
0x8000001a14143221ULL, 0x000fe20000010000ULL, 0x0000001506067220ULL, 0x000fe20000410000ULL,
0x00001f1615167589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b14143820ULL, 0x000fc80000410000ULL,
0x00000014000c3308ULL, 0x000ee20000000800ULL, 0x0000001713137220ULL, 0x082fe20000410000ULL,
0x0000001712127220ULL, 0x080fe20000410000ULL, 0x000000173b3b7220ULL, 0x080fe20000410000ULL,
0x000000173a3a7220ULL, 0x080fe20000410000ULL, 0x0000001737377220ULL, 0x080fe20000410000ULL,
0x0000001736367220ULL, 0x080fe20000410000ULL, 0x0000001733337220ULL, 0x080fe20000410000ULL,
0x0000001732327220ULL, 0x080fe20000410000ULL, 0x000000172f2f7220ULL, 0x080fe20000410000ULL,
0x000000172e2e7220ULL, 0x080fe20000410000ULL, 0x000000172b2b7220ULL, 0x080fe20000410000ULL,
0x000000172a2a7220ULL, 0x080fe20000410000ULL, 0x0000001723237220ULL, 0x080fe20000410000ULL,
0x0000001722227220ULL, 0x080fe20000410000ULL, 0x000000171f1f7220ULL, 0x080fe20000410000ULL,
0x000000171e1e7220ULL, 0x000fe20000410000ULL, 0x0000001611117220ULL, 0x084fe20000410000ULL,
0x0000001610107220ULL, 0x080fe20000410000ULL, 0x0000001639397220ULL, 0x080fe20000410000ULL,
0x0000001638387220ULL, 0x080fe20000410000ULL, 0x0000001635357220ULL, 0x080fe20000410000ULL,
0x0000001634347220ULL, 0x080fe20000410000ULL, 0x0000001631317220ULL, 0x080fe20000410000ULL,
0x0000001630307220ULL, 0x080fe20000410000ULL, 0x000000162d2d7220ULL, 0x080fe20000410000ULL,
0x000000162c2c7220ULL, 0x080fe20000410000ULL, 0x0000001629297220ULL, 0x080fe20000410000ULL,
0x0000001628287220ULL, 0x080fe20000410000ULL, 0x0000001621217220ULL, 0x080fe20000410000ULL,
0x0000001620207220ULL, 0x080fe20000410000ULL, 0x000000161d1d7220ULL, 0x080fe20000410000ULL,
0x000000161c1c7220ULL, 0x000fe20000410000ULL, 0x0000000c65653220ULL, 0x008fce0000410000ULL,
0x0000000000081947ULL, 0x000fea0003800000ULL, 0x0106a86fff0075a7ULL, 0x000e640008020147ULL,
0x0000011000a49947ULL, 0x002fea0003800000ULL, 0x000000004424783bULL, 0x000e620000004200ULL,
0x0000000702557812ULL, 0x040fe400078ec0ffULL, 0x0000000b02147211ULL, 0x000fe400078fe0ffULL,
0x0000000855557812ULL, 0x000fe400078ef802ULL, 0x000000146b6b7212ULL, 0x000fe400078e3cffULL,
0x0000000750147812ULL, 0x000fe400078e7855ULL, 0x00000002ff417819ULL, 0x000fe20000011602ULL,
0x00000010564d7824ULL, 0x000fe200078e026bULL, 0x0000000cff66723eULL, 0x000fe200000000ffULL,
0x0000000855147824ULL, 0x000fe200078e0214ULL, 0x00009910586e7816ULL, 0x000fc400000000ffULL,
0x0000541066667816ULL, 0x000fe40000000066ULL, 0x0000000714577c11ULL, 0x000fe4000f8e20ffULL,
0x000000064d5a7c11ULL, 0x000fe2000f8e20ffULL, 0x00001f4166637589ULL, 0x000fe200000e0000ULL,
0x0000010056567811ULL, 0x000fe400078e20ffULL, 0x0000000649497c11ULL, 0x000fe2000f8e20ffULL,
0x00a000005714783bULL, 0x000ea40000000200ULL, 0x0000000119607824ULL, 0x000fc400078e0256ULL,
0x000000005a3c783bULL, 0x000fe20000004200ULL, 0x000000016b567824ULL, 0x000fe400078e0256ULL,
0x0000000660597c11ULL, 0x000fca000f8e20ffULL, 0x000000005918783bULL, 0x000fe20000004200ULL,
0x0000010024407824ULL, 0x042fe200078e00ffULL, 0x0000888024627816ULL, 0x040fe200000000ffULL,
0x0000010025617824ULL, 0x040fe200078e00ffULL, 0x0000888025747816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011440ULL, 0x0000000841407836ULL, 0x000fe20000000000ULL,
0x00000018ff767819ULL, 0x000fe20000011461ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000000ffff617224ULL, 0x000fe200078e006eULL, 0x00000018ff4b7819ULL, 0x000fe20000011425ULL,
0x00001f4066647589ULL, 0x000e6200000e0000ULL, 0x00010000246e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011424ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x000000ff6100720cULL, 0x000fe20003f25270ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x00000018ff6e7819ULL, 0x000fc4000001146eULL, 0x00000018ff687819ULL, 0x000fe40000011426ULL,
0x00000018ff5e7819ULL, 0x000fc60000011427ULL, 0x0000007400587306ULL, 0x0009e80000200c00ULL,
0x0000006314149232ULL, 0x084fe40000000000ULL, 0x0000006316169232ULL, 0x000fe20000000000ULL,
0x0000541062247816ULL, 0x008fe20000000075ULL, 0x0000007600777306ULL, 0x0004e20000200c00ULL,
0x00000018ff627819ULL, 0x000fe20000011425ULL, 0x0000006415159232ULL, 0x082fe20000000000ULL,
0x0000888026747816ULL, 0x010fe200000000ffULL, 0x0000006417179232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fc6000001143cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff727819ULL, 0x000fe4000001143dULL, 0x000088803d767816ULL, 0x004fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001143eULL, 0x0000541058257816ULL, 0x008fe20000000077ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff547819ULL, 0x000fe4000001143fULL,
0x00000018ff617819ULL, 0x000fc40000011419ULL, 0x00000018ff6d7819ULL, 0x000fe20000011418ULL,
0x00000024141c723cULL, 0x000fe4000000181cULL, 0x0000006e00757306ULL, 0x000e6a0000200c00ULL,
0x0000010026257824ULL, 0x040fe400078e00ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000006200587306ULL, 0x0004e20000200c00ULL, 0x000000ffff247224ULL, 0x000fe200078e0074ULL,
0x00000018ff777819ULL, 0x000fc40000011425ULL, 0x00000018ff6b7819ULL, 0x000fe40000011426ULL,
0x0000888027257816ULL, 0x000fe400000000ffULL, 0x00005410754a7816ULL, 0x002fe2000000004aULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000010027627824ULL, 0x044fe200078e00ffULL,
0x000088803c747816ULL, 0x000fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00005410584b7816ULL, 0x008fc8000000004bULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff6e7819ULL, 0x000fe40000011462ULL, 0x0000000656587c11ULL, 0x000fe2000f8e20ffULL,
0x0000004a1420723cULL, 0x000fe20000001820ULL, 0x00000018ff627819ULL, 0x000fc6000001141aULL,
0x0000002400247306ULL, 0x000fe60000200c00ULL, 0x000001003c4a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011427ULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000004a00757306ULL, 0x0005e20000200c00ULL,
0x0000541024247816ULL, 0x002fce0000000077ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000054106b4a7816ULL, 0x004fe20000000068ULL, 0x000001003d687824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011468ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054104b4b7816ULL, 0x002fce000000005eULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000004a142c723cULL, 0x000fee000000182cULL,
0x0000003c003c7306ULL, 0x000e700000200c00ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce0000000073ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x000054103d3d7816ULL, 0x004fce0000000072ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000003c1434723cULL, 0x000fe20000001834ULL, 0x00005410744a7816ULL, 0x002fcc0000000075ULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x000088803f757816ULL, 0x040fe200000000ffULL,
0x000001003e747824ULL, 0x000fe400078e00ffULL, 0x000001003f3c7824ULL, 0x040fe400078e00ffULL,
0x000000ffff3d7224ULL, 0x000fe200078e0075ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe2000001143cULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x00005410764b7816ULL, 0x002fce0000000077ULL,
0x0000007400727306ULL, 0x000fe20000200c00ULL, 0x0000004a1430723cULL, 0x000fee0000001830ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000088803e4b7816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fcc00078e00ffULL, 0x0000004b00737306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143eULL, 0x00000100183e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000007500767306ULL, 0x000ea20000200c00ULL,
0x00000018ff4b7819ULL, 0x002fe4000001143fULL, 0x00008880183f7816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fc800078e00ffULL, 0x0000003c00747306ULL, 0x0003e20000200c00ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x000054103d3d7816ULL, 0x004fca0000000076ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x00005410733c7816ULL, 0x002fe40000000072ULL,
0x0000888019727816ULL, 0x000fe400000000ffULL, 0x000088801a737816ULL, 0x000fc600000000ffULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000003c1438723cULL, 0x000fe20000001838ULL,
0x0000541025257816ULL, 0x004fcc000000006eULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x00000100193c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001141bULL,
0x0001000019197824ULL, 0x000fe400078e00ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e0072ULL,
0x00000018ff727819ULL, 0x000fe2000001143cULL, 0x000000241428723cULL, 0x000fe20000001828ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x000000005824783bULL, 0x000eec0000004200ULL, 0x00000019003c7306ULL, 0x0003f00000200c00ULL,
0x0000001800767306ULL, 0x0005e20000200c00ULL, 0x000054104b197816ULL, 0x002fe20000000054ULL,
0x000001001a4b7824ULL, 0x040fe200078e00ffULL, 0x000000074e547812ULL, 0x000fe200078e7855ULL,
0x000100001a1a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000000855547824ULL, 0x000fe200078e0254ULL, 0x0000541074187816ULL, 0x004fe2000000006fULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000000754547c11ULL, 0x000fe4000f8e20ffULL, 0x000088801b747816ULL, 0x040fe200000000ffULL,
0x000000181414723cULL, 0x000fe40000001810ULL, 0x00a000005410783bULL, 0x000e620000000200ULL,
0x0000003e003e7306ULL, 0x000ea80000200c00ULL, 0x000001001b187824ULL, 0x000fc400078e00ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000888024197816ULL, 0x008fe200000000ffULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x00000018ff6b7819ULL, 0x000fe40000011424ULL,
0x00000018ff687819ULL, 0x000fe20000011425ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fc40000011426ULL, 0x00000018ff4a7819ULL, 0x000fca0000011427ULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x0000006100617306ULL, 0x000f220000200c00ULL,
0x0000006310109232ULL, 0x002fce0000000000ULL, 0x0000001a00777306ULL, 0x0003e20000200c00ULL,
0x0000006312129232ULL, 0x000fe40000000000ULL, 0x0000006411119232ULL, 0x080fe40000000000ULL,
0x0000006413139232ULL, 0x000fe20000000000ULL, 0x000000400e647811ULL, 0x000fe400078e40ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000100251a7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000004b00787306ULL, 0x000e700000200c00ULL,
0x0000001800757306ULL, 0x0005f00000200c00ULL, 0x0000007400747306ULL, 0x000f620000200c00ULL,
0x000054103f187816ULL, 0x004fe2000000003eULL, 0x00000100243e7824ULL, 0x000fc400078e00ffULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x00000019003f7306ULL, 0x0007e20000200c00ULL, 0x00000018ff247819ULL, 0x000fce0000011424ULL,
0x0000001b006f7306ULL, 0x0009e20000200c00ULL, 0x000054103d197816ULL, 0x008fe40000000072ULL,
0x00008880253d7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fc800078e00ffULL,
0x0000001a00727306ULL, 0x0005e20000200c00ULL, 0x000054103c1b7816ULL, 0x010fe20000000061ULL,
0x00000018101c723cULL, 0x000fe2000000181cULL, 0x00000040003c7811ULL, 0x000fe400078e38ffULL,
0x00000018ff4b7819ULL, 0x000fe40000011425ULL, 0x0000888026257816ULL, 0x000fe200000000ffULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x00005410761a7816ULL, 0x004fe2000000006dULL,
0x0000000169617824ULL, 0x000fe200078e023cULL, 0x0000541073187816ULL, 0x002fc40000000078ULL,
0x0106b80aff7879a7ULL, 0x000e620008500007ULL, 0x0000541074197816ULL, 0x020fe40000000075ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000001a1020723cULL, 0x000fe20000001820ULL,
0x000000616c637210ULL, 0x000fca0007f5e0ffULL, 0x000000181028723cULL, 0x000fe20000001828ULL,
0x00000100261b7824ULL, 0x040fe200078e00ffULL, 0x0000003e003e7306ULL, 0x000f220000200c00ULL,
0x00005410771a7816ULL, 0x008fe20000000062ULL, 0x0001000026267824ULL, 0x000fe400078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00000010636d7c11ULL, 0x000fe2000f8440ffULL, 0x000000015f627824ULL, 0x000fe200078e023cULL,
0x0000003d003d7306ULL, 0x000ee20000200c00ULL, 0x0000888027197816ULL, 0x000fe200000000ffULL,
0x00000079ff0075a7ULL, 0x002e6c000808004cULL, 0x0000001b00747306ULL, 0x0005f00000200c00ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000054106f1b7816ULL, 0x004fc4000000006eULL,
0x00000018ff6f7819ULL, 0x000fe40000011426ULL, 0x000000626c267210ULL, 0x000fc60007f7e0ffULL,
0x0000001a102c723cULL, 0x000fe2000000182cULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000000ffff5f7224ULL, 0x000fca00018e06ffULL, 0x00000011631a7c11ULL, 0x000fe200090f4418ULL,
0x0000000167637824ULL, 0x000fe200078e023cULL, 0x000054103f187816ULL, 0x010fe2000000003eULL,
0x00000100273f7824ULL, 0x000fe200078e00ffULL, 0x00000019003e7306ULL, 0x0007e40000200c00ULL,
0x000000636c1b7210ULL, 0x000fe40007f5e0ffULL, 0x00000018ff3f7819ULL, 0x000fc6000001143fULL,
0x000000ffff6e7224ULL, 0x000fe200010e06ffULL, 0x0000002400247306ULL, 0x000fe20000200c00ULL,
0x000054103d197816ULL, 0x008fce0000000072ULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x000000181030723cULL, 0x000fee0000001830ULL, 0x0000000a64197c48ULL, 0x000fe2000ffe0000ULL,
0x0001000027187824ULL, 0x000fe200078e00ffULL, 0x0000002500257306ULL, 0x000ee20000200c00ULL,
0x000000101b277c11ULL, 0x000fc4000f8440ffULL, 0x0000000119197824ULL, 0x000fe200078e0a64ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x000000111b1b7c11ULL, 0x000fe400090f446eULL,
0x0000003f00737306ULL, 0x000f220000200c00ULL, 0x00000020196e7807ULL, 0x000fe40000000000ULL,
0x000054104b197816ULL, 0x004fe40000000068ULL, 0x00000010263d7c11ULL, 0x000fc4000f8440ffULL,
0x0000006e0d6e7248ULL, 0x000fe20007fe0000ULL, 0x00000018003f7306ULL, 0x0005e20000200c00ULL,
0x0000001126267c11ULL, 0x000fe200090f445fULL, 0x00000001435f7824ULL, 0x000fe400078e023cULL,
0x000000016e4b7824ULL, 0x000fc600078e0a0dULL, 0x0000005f6c3c7210ULL, 0x000fe20007f5e0ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541024187816ULL, 0x004fe4000000006bULL,
0x000000426d247210ULL, 0x000fe40007fbe0ffULL, 0x0000004b5000720cULL, 0x000fc60003f66070ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000000181034723cULL, 0x000fee0000001834ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541025187816ULL, 0x008fe20000000074ULL,
0x000000ffff257224ULL, 0x000fe200028e061aULL, 0x000054103e197816ULL, 0x010fce0000000073ULL,
0x000000181038723cULL, 0x000fee0000001838ULL, 0x000054106f187816ULL, 0x004fe4000000005eULL,
0x000054103f197816ULL, 0x000fce000000004aULL, 0x000000181014723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000084947ULL, 0x002fde0003800000ULL,
0x0106b879ff0075a7ULL, 0x000e640008080147ULL, 0x00000100004cc947ULL, 0x002fea0003800000ULL,
0x0000004227107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024497faeULL, 0x0003e2000d901c48ULL,
0x000000103c197c11ULL, 0x000fe4000f8440ffULL, 0x0000004b4e00720cULL, 0x080fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200028e061bULL, 0x0000004b4c00720cULL, 0x080fe40003f66070ULL,
0x0000004b4800720cULL, 0x000fe40003fa6070ULL, 0x000000423d127210ULL, 0x000fc40007fde0ffULL,
0x000000113c3c7c11ULL, 0x000fe400090f4413ULL, 0x0000004219187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200030e0626ULL, 0x0000000652527c11ULL, 0x000fe4000f8e20ffULL,
0x0000000651517c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff197224ULL, 0x000fe200010e063cULL,
0x000000064f4f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000010527faeULL, 0x0003e8000e101c48ULL,
0x0000000012517faeULL, 0x0003e8000d901c48ULL, 0x00000000184f7faeULL, 0x0003e2000e901c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4bULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a80aff6e79a7ULL, 0x0004a20008500007ULL,
0x0000000d53537c11ULL, 0x000fe2000f8e20ffULL, 0x00000071ff0075a7ULL, 0x000ee4000804004eULL,
0x0000000000082947ULL, 0x00cfea0003800000ULL, 0x0106b071ff0075a7ULL, 0x000ea40008040147ULL,
0x000000fc00eca947ULL, 0x004fea0003800000ULL, 0x00000000533c783bULL, 0x000ea20000004200ULL,
0x00000004025e7811ULL, 0x000fe200078fe0ffULL, 0x0000000665067221ULL, 0x000fe20000010000ULL,
0x0000000d4d4d7c11ULL, 0x000fe2000f8e20ffULL, 0x00001f41666b7589ULL, 0x000fe200000e0000ULL,
0x000000075e107812ULL, 0x002fe400078e7855ULL, 0x0000000d56567c11ULL, 0x000fe2000f8e20ffULL,
0x000000004d24783bULL, 0x000e640000004200ULL, 0x0000000855107824ULL, 0x000fc400078e0210ULL,
0x00001f4066687589ULL, 0x000fe600000e0000ULL, 0x00000007104a7c11ULL, 0x000fca000f8e20ffULL,
0x00a000004a18783bULL, 0x000ee20000000200ULL, 0x00000018ff117819ULL, 0x004fe2000001143cULL,
0x000001003c127824ULL, 0x040fe200078e00ffULL, 0x000088803c107816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001143dULL,
0x000001003d717824ULL, 0x040fe200078e00ffULL, 0x000088803d4b7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000001100117306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fc40000011471ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff767819ULL, 0x000fe4000001143eULL,
0x00000018ff707819ULL, 0x000fe2000001143fULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff727819ULL, 0x002fe20000011424ULL, 0x0000006b18189232ULL, 0x088fe20000000000ULL,
0x00000018ff757819ULL, 0x000fe20000011425ULL, 0x0000006b1a1a9232ULL, 0x000fe20000000000ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000006819199232ULL, 0x000fc40000000000ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x000000681b1b9232ULL, 0x000fce0000000000ULL,
0x0000003d00667306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce0000000011ULL,
0x0000004b00737306ULL, 0x0003e20000200c00ULL, 0x00005410663d7816ULL, 0x004fce000000006dULL,
0x0000007100747306ULL, 0x0004e20000200c00ULL, 0x000001003e667824ULL, 0x000fe200078e00ffULL,
0x0000000d604b7c11ULL, 0x002fe2000f8e20ffULL, 0x000001003f6d7824ULL, 0x000fe200078e00ffULL,
0x000088803e607816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c1820723cULL, 0x000fe20000001820ULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x004fe40000011426ULL,
0x00000018ff3e7819ULL, 0x000fc4000001143eULL, 0x000088803f3c7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000541073117816ULL, 0x008fe20000000074ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe40000011427ULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x0000007100737306ULL, 0x0003f00000200c00ULL,
0x00000066003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff717819ULL, 0x002fce000001146dULL,
0x0000003c00777306ULL, 0x0005f00000200c00ULL, 0x0000007100787306ULL, 0x000e620000200c00ULL,
0x00005410603c7816ULL, 0x004fe2000000003dULL, 0x0000010024607824ULL, 0x000fca00078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410773d7816ULL, 0x002fce0000000078ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000003c1828723cULL, 0x000fee0000001828ULL, 0x0000003e00777306ULL, 0x0002b00000200c00ULL,
0x0000003f003d7306ULL, 0x000ee20000200c00ULL, 0x00008880243e7816ULL, 0x042fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00005410773c7816ULL, 0x004fca0000000076ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x000054103d3d7816ULL, 0x008fca0000000070ULL, 0x00000060003f7306ULL, 0x0002a20000200c00ULL,
0x0000888025707816ULL, 0x040fe200000000ffULL, 0x0000003c182c723cULL, 0x000fec000000182cULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000888026607816ULL, 0x002fe200000000ffULL,
0x00000100253c7824ULL, 0x000fc400078e00ffULL, 0x0001000025257824ULL, 0x000fc800078e00ffULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000018ff767819ULL, 0x000fe4000001143cULL,
0x00000018ff257819ULL, 0x000fca0000011425ULL, 0x0000007600777306ULL, 0x000e700000200c00ULL,
0x00000024003d7306ULL, 0x0004f00000200c00ULL, 0x00000025003c7306ULL, 0x0003220000200c00ULL,
0x000054103e247816ULL, 0x004fce000000003fULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x0000541070257816ULL, 0x002fce0000000077ULL, 0x000000241830723cULL, 0x000fe20000001830ULL,
0x0000001200137306ULL, 0x000e6c0000200c00ULL, 0x000054103d247816ULL, 0x008fe20000000072ULL,
0x0000010026727824ULL, 0x000fe200078e00ffULL, 0x000054103c257816ULL, 0x010fe20000000075ULL,
0x0000010027757824ULL, 0x000fe200078e00ffULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000000563c783bULL, 0x000ea20000004200ULL, 0x00000018ff767819ULL, 0x000fe20000011475ULL,
0x000000241834723cULL, 0x000fe20000001834ULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000007200257306ULL, 0x000ee20000200c00ULL, 0x0000541010107816ULL, 0x002fc60000000013ULL,
0x0000888027247816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x0000002400777306ULL, 0x0007e20000200c00ULL, 0x00000010181c723cULL, 0x000fe2000000181cULL,
0x00000018ff757819ULL, 0x000fe20000011427ULL, 0x000000004b10783bULL, 0x000e6a0000004200ULL,
0x0000007600767306ULL, 0x000f220000200c00ULL, 0x0000541060247816ULL, 0x008fe40000000025ULL,
0x0000000602607811ULL, 0x000fca00078fe0ffULL, 0x0000002600267306ULL, 0x000ee20000200c00ULL,
0x0000541077257816ULL, 0x010fce0000000076ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00000018ff767819ULL, 0x004fe4000001143fULL, 0x00000018ff277819ULL, 0x000fe2000001143dULL,
0x000000241838723cULL, 0x000fe20000001838ULL, 0x00000018ff727819ULL, 0x000fc6000001143cULL,
0x0000007500757306ULL, 0x000ea60000200c00ULL, 0x0000541026247816ULL, 0x008fe40000000073ULL,
0x0000000760267812ULL, 0x000fc600078e7855ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff787819ULL, 0x002fe20000011413ULL, 0x0000000855557824ULL, 0x000fe200078e0226ULL,
0x0000888010737816ULL, 0x040fe400000000ffULL, 0x0000541075257816ULL, 0x004fe20000000074ULL,
0x0000010011757824ULL, 0x000fe200078e00ffULL, 0x0000000755557c11ULL, 0x000fe2000f8e20ffULL,
0x0000007800707306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fe40000011411ULL,
0x00000018ff777819ULL, 0x000fe20000011475ULL, 0x000000241818723cULL, 0x000fe20000001814ULL,
0x00a000005514783bULL, 0x000e620000000200ULL, 0x00000018ff6d7819ULL, 0x000fe20000011410ULL,
0x0001000010757824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff667819ULL, 0x000fc40000011412ULL, 0x0000010010257824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff267819ULL, 0x000fe4000001143eULL,
0x00000018ff747819ULL, 0x000fe20000011425ULL, 0x0000007700787306ULL, 0x000fe20000200c00ULL,
0x0000888011257816ULL, 0x040fe200000000ffULL, 0x0001000011117824ULL, 0x000fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000007400747306ULL, 0x000eb00000200c00ULL,
0x0000002500257306ULL, 0x000ee20000200c00ULL, 0x0000541073107816ULL, 0x004fce0000000074ULL,
0x0000007600247306ULL, 0x000fe20000200c00ULL, 0x0000888012737816ULL, 0x000fe200000000ffULL,
0x0000006815159232ULL, 0x082fe40000000000ULL, 0x0000006817179232ULL, 0x000fc80000000000ULL,
0x0000001100687306ULL, 0x0007e20000200c00ULL, 0x0000006b14149232ULL, 0x080fe40000000000ULL,
0x0000006b16169232ULL, 0x000fe40000000000ULL, 0x00000100126b7824ULL, 0x000fe200078e00ffULL,
0x0000000a64007c0cULL, 0x000fe4000bf21070ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541025117816ULL, 0x008fe40000000078ULL, 0x00000018ff747819ULL, 0x000fc4000001146bULL,
0x00008880136b7816ULL, 0x000fc600000000ffULL, 0x00000010141c723cULL, 0x000fe2000000181cULL,
0x0000007100717306ULL, 0x000e6c0000200c00ULL, 0x0000010013107824ULL, 0x040fe400078e00ffULL,
0x0000007500767306ULL, 0x000ea20000200c00ULL, 0x0001000013137824ULL, 0x000fc400078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011410ULL, 0x0001000012107824ULL, 0x000fe400078e00ffULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001100127306ULL, 0x0003e20000200c00ULL,
0x00000018ff107819ULL, 0x000fce0000011410ULL, 0x0000001000757306ULL, 0x0005e20000200c00ULL,
0x0000541068117816ULL, 0x002fe20000000071ULL, 0x000001003c717824ULL, 0x000fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011471ULL, 0x0000007300257306ULL, 0x000fe20000200c00ULL,
0x0000541076107816ULL, 0x004fe4000000006dULL, 0x000088803d717816ULL, 0x000fe400000000ffULL,
0x000088803c6d7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe400078e00ffULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000000101420723cULL, 0x000fe40000001820ULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000001003d107824ULL, 0x040fe400078e00ffULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x000054106b117816ULL, 0x002fca0000000012ULL,
0x0000001000767306ULL, 0x0003f00000200c00ULL, 0x0000001300737306ULL, 0x0004e20000200c00ULL,
0x0000541025107816ULL, 0x002fe20000000074ULL, 0x000001003e257824ULL, 0x000fca00078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011425ULL, 0x000000101428723cULL, 0x000fe20000001828ULL,
0x0000006d00687306ULL, 0x000fe20000200c00ULL, 0x000088803e137816ULL, 0x044fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fc800078e00ffULL, 0x000001003f107824ULL, 0x000fe200078e00ffULL,
0x0000541073117816ULL, 0x008fe20000000070ULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x00000018ff257819ULL, 0x000fe4000001143eULL, 0x00000018ff107819ULL, 0x000fca0000011410ULL,
0x0000007100717306ULL, 0x000eb00000200c00ULL, 0x0000003d00747306ULL, 0x000ff00000200c00ULL,
0x00000010003d7306ULL, 0x0007f00000200c00ULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000541075107816ULL, 0x008fce0000000066ULL, 0x0000003c006d7306ULL, 0x0007220000200c00ULL,
0x00000010142c723cULL, 0x000fee000000182cULL, 0x0000541068107816ULL, 0x002fe20000000077ULL,
0x0000001300127306ULL, 0x0003e20000200c00ULL, 0x000088803f3c7816ULL, 0x048fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x0000541071117816ULL, 0x004fca0000000076ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x00000018ff137819ULL, 0x002fe2000001143fULL,
0x000000101430723cULL, 0x000fec0000001830ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x000054106d107816ULL, 0x010fe40000000072ULL, 0x0000541074117816ULL, 0x000fca0000000027ULL,
0x0000002600267306ULL, 0x000fe40000200c00ULL, 0x000000101434723cULL, 0x000fec0000001834ULL,
0x0000002500257306ULL, 0x000ee20000200c00ULL, 0x0000541012107816ULL, 0x004fe4000000006bULL,
0x000054103c117816ULL, 0x002fca000000003dULL, 0x0000001300137306ULL, 0x000e640000200c00ULL,
0x000000101438723cULL, 0x000fee0000001838ULL, 0x0000541025107816ULL, 0x008fe40000000026ULL,
0x0000541013117816ULL, 0x002fce0000000024ULL, 0x000000101410723cULL, 0x000fe20000001818ULL,
0x0106b80aff1479a7ULL, 0x0002ac0008500007ULL, 0x000000ffff197224ULL, 0x000fe200078e005dULL,
0x0106880affff79a7ULL, 0x0003e20008500007ULL, 0x0000007800309947ULL, 0x000fde0003800000ULL,
0x000000015d047812ULL, 0x000fe200078ec0ffULL, 0x00000015ff0075a7ULL, 0x004ea2000808004cULL,
0xffffffff03647811ULL, 0x000fe400078e08ffULL, 0x000000010400780cULL, 0x000fe40003f25070ULL,
0x0000006000187811ULL, 0x000fe400078e38ffULL, 0x0000000164047807ULL, 0x000fe40004800000ULL,
0x000000600e167811ULL, 0x000fe200078e40ffULL, 0x0000000169687824ULL, 0x000fe200078e0218ULL,
0x0000005e18667210ULL, 0x000fe20007ffe00dULL, 0x000000015d5d7824ULL, 0x000fe200078e0204ULL,
0x0000000a16177c48ULL, 0x000fe2000ffe0000ULL, 0x0000000167677824ULL, 0x000fe200078e0218ULL,
0x000000686c3d7210ULL, 0x000fc40007f3e0ffULL, 0x000000045d007c0cULL, 0x000fe2000bf66070ULL,
0x0000000117177824ULL, 0x000fe200078e0a16ULL, 0x0000006018657210ULL, 0x000fe20007ffe00dULL,
0x000000ffff167224ULL, 0x000fe200008e06ffULL, 0x000000103d257c11ULL, 0x000fe4000f8240ffULL,
0x0000002017187807ULL, 0x000fe40000000000ULL, 0x000000113d3d7c11ULL, 0x000fe400088f4416ULL,
0x000000666c1a7210ULL, 0x000fc40007fde0ffULL, 0x000000180d187248ULL, 0x000fe20007fe0000ULL,
0x00008c00ff16bb82ULL, 0x000ee20000000a00ULL, 0x000000676c3c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff6b7224ULL, 0x000fe200030e06ffULL, 0x000000656c267210ULL, 0x000fe20007fbe0ffULL,
0x0000000118277824ULL, 0x000fe200078e0a0dULL, 0x0000004225247210ULL, 0x000fe20007fde0ffULL,
0x000000ffff717224ULL, 0x000fe200008e06ffULL, 0x000000103c6d7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e06ffULL, 0x000000101a3f7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff257224ULL, 0x000fe200030e063dULL, 0x00000010263d7c11ULL, 0x000fc4000f8a40ffULL,
0x000000275000720cULL, 0x000fe20003fc6070ULL, 0x0000000000084947ULL, 0x004fd80003800000ULL,
0x0106b815ff0075a7ULL, 0x000ea40008080147ULL, 0x000000ec00acc947ULL, 0x004fea0003800000ULL,
0x000000111a147c11ULL, 0x000fe200088f446bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000245c7faeULL, 0x0005e2000f101c48ULL, 0x000000113c3c7c11ULL, 0x000fe400090f4471ULL,
0x000000426d1a7210ULL, 0x000fe40007f9e0ffULL, 0x0000001126267c11ULL, 0x000fe4000a8f441bULL,
0x000000423f187210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e063cULL,
0x000000274e00720cULL, 0x000fc40003f46070ULL, 0x000000275e00720cULL, 0x080fe40003f26070ULL,
0x000000276000720cULL, 0x000fe40003f86070ULL, 0x000000040815b210ULL, 0x000fe20007ffe019ULL,
0x000000ffff197224ULL, 0x000fe200028e0614ULL, 0x000000423d147210ULL, 0x000fe20007fbe0ffULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x000000041516b825ULL, 0x008fe400078e0016ULL,
0x000000001a5b7faeULL, 0x0007e4000d101c48ULL, 0x000000ffff157224ULL, 0x000fc400028e0626ULL,
0x0000000018477faeULL, 0x0007e8000c901c48ULL, 0x0000000014467faeULL, 0x0007e2000e101c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x000000081604b981ULL, 0x000768000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4eULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0106b00aff7079a7ULL, 0x0004a20008500007ULL, 0x0000006fff0075a7ULL, 0x0004a2000802004bULL,
0x0106280a0d1479a7ULL, 0x008ee40008500007ULL, 0x010628150d0075a7ULL, 0x008ee40008040147ULL,
0x000000ec004ca947ULL, 0x00efea0003800000ULL, 0x0100800045147984ULL, 0x000e620000000800ULL,
0x00000001ff3d7424ULL, 0x000fc600078e00ffULL, 0x01028000456b7984ULL, 0x0004a20000000800ULL,
0x000000051400720bULL, 0x002fda0003f5d000ULL, 0x0000000000157806ULL, 0x000fc800010e0100ULL,
0x0000ffff15177812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000051400720bULL, 0x000fe40003f54000ULL, 0x0000001405167209ULL, 0x000fca0007810000ULL,
0x8000001605157221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b15157820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400010e0100ULL, 0x000000010f00780cULL, 0x000fe40003f45270ULL,
0x0000ffff05187812ULL, 0x000fe200078e3cffULL, 0x0000001500157308ULL, 0x000e660000000800ULL,
0x0000001817ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff3d7807ULL, 0x000fc60001800000ULL,
0x010480164500a388ULL, 0x000fe80000000800ULL, 0x00001f4115057589ULL, 0x002e6400000e0000ULL,
0x8000001614173221ULL, 0x000fe20000010000ULL, 0x0000001506067220ULL, 0x000fe20000410000ULL,
0x00001f4015147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b17173820ULL, 0x000fc80000410000ULL,
0x00000017000c3308ULL, 0x000ee20000000800ULL, 0x000000051c1c7220ULL, 0x082fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x000fe20000410000ULL, 0x000000141e1e7220ULL, 0x084fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x000000143a3a7220ULL, 0x080fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fe20000410000ULL, 0x000000ffff057224ULL, 0x000fc400078e0016ULL,
0x0000006b0c6b3220ULL, 0x008fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a86fff0075a7ULL, 0x000e640008020147ULL, 0x000000e800709947ULL, 0x002fea0003800000ULL,
0x000000004424783bULL, 0x000e620000004200ULL, 0x000099103d757816ULL, 0x000fe400000000ffULL,
0x0000000cff6d723eULL, 0x000fe200000000ffULL, 0x000000005a14783bULL, 0x000fe20000004200ULL,
0x000000ff7500720cULL, 0x000fe40003f65270ULL, 0x000054106d6d7816ULL, 0x000fe2000000006dULL,
0x00a800005718783bULL, 0x000fe80000000200ULL, 0x00001f416d6f7589ULL, 0x000ea800000e0000ULL,
0x00001f406d6c7589ULL, 0x000ee200000e0000ULL, 0x00000100243e7824ULL, 0x042fe200078e00ffULL,
0x00008880243c7816ULL, 0x000fe200000000ffULL, 0x0000010025757824ULL, 0x040fe200078e00ffULL,
0x0000888025747816ULL, 0x000fc400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000006f1818b232ULL, 0x084fe20000000000ULL, 0x00000018ff727819ULL, 0x000fe20000011425ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011424ULL,
0x0001000024247824ULL, 0x000fe400078e00ffULL, 0x0000006f1a1ab232ULL, 0x000fe20000000000ULL,
0x0000003e003d7306ULL, 0x000e620000200c00ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000006c1919b232ULL, 0x088fe20000000000ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000006c1b1bb232ULL, 0x000fe20000000000ULL, 0x00000018ff3f7819ULL, 0x000fc40000011427ULL,
0x00000018ff737819ULL, 0x000fe20000011426ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce000000003dULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x00000018ff3d7819ULL, 0x000fce0000011414ULL, 0x0000003d003e7306ULL, 0x0003f00000200c00ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00005410743d7816ULL, 0x002fe40000000075ULL,
0x00000018ff747819ULL, 0x000fca0000011416ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000003c181c723cULL, 0x000fee000000181cULL, 0x0000002400757306ULL, 0x000e620000200c00ULL,
0x00008880263d7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fca0000011415ULL,
0x0000002500257306ULL, 0x000ea20000200c00ULL, 0x0000541075247816ULL, 0x002fce000000006eULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541025257816ULL, 0x004fce0000000072ULL,
0x00000074006e7306ULL, 0x0003e20000200c00ULL, 0x0000010026727824ULL, 0x040fe400078e00ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x000000241820723cULL, 0x000fe40000001820ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x0000010027747824ULL, 0x002fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000888027257816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe40000011474ULL, 0x0000007200247306ULL, 0x0002a40000200c00ULL,
0x00000018ff747819ULL, 0x000fe40000011427ULL, 0x0000888014277816ULL, 0x000fc800000000ffULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x002fe40000011417ULL,
0x000054103d247816ULL, 0x004fca0000000024ULL, 0x0000007500767306ULL, 0x0002a20000200c00ULL,
0x00000100143d7824ULL, 0x040fe400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x0000888015757816ULL, 0x002fe400000000ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000541025257816ULL, 0x004fc60000000076ULL, 0x0000002700277306ULL, 0x000fe80000200c00ULL,
0x000000241828723cULL, 0x000fe80000001828ULL, 0x0000003d00767306ULL, 0x000fe60000200c00ULL,
0x0000010015247824ULL, 0x040fe200078e00ffULL, 0x0000541074257816ULL, 0x008fe2000000003fULL,
0x0001000015157824ULL, 0x000fc600078e00ffULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x0000888016747816ULL, 0x000fe400000000ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x00000018ff3f7819ULL, 0x000fc60000011415ULL, 0x0000002400787306ULL, 0x000e700000200c00ULL,
0x00000014003d7306ULL, 0x0005e20000200c00ULL, 0x0000541075157816ULL, 0x002fce0000000078ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541027147816ULL, 0x004fe40000000076ULL,
0x0000888017767816ULL, 0x000fca00000000ffULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000000141830723cULL, 0x000fee0000001830ULL, 0x0000010016147824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000010017157824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff777819ULL, 0x000fe40000011415ULL, 0x0000002600267306ULL, 0x000ea20000200c00ULL,
0x000054103f157816ULL, 0x002fce000000003cULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541026247816ULL, 0x004fce0000000073ULL, 0x0000001400757306ULL, 0x0003e20000200c00ULL,
0x00000024182c723cULL, 0x000fe2000000182cULL, 0x000000005924783bULL, 0x000eac0000004200ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x000054103d147816ULL, 0x002fe4000000003eULL,
0x00000000583c783bULL, 0x000e6a0000004200ULL, 0x000000141834723cULL, 0x000fe20000001834ULL,
0x0000007700157306ULL, 0x000eec0000200c00ULL, 0x00000018ff147819ULL, 0x000fe20000011416ULL,
0x0001000017167824ULL, 0x000fe200078e00ffULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541076157816ULL, 0x008fce0000000015ULL, 0x0000001400177306ULL, 0x0007240000200c00ULL,
0x0000541074147816ULL, 0x008fe40000000075ULL, 0x00000018ff757819ULL, 0x000fe40000011416ULL,
0x00000018ff737819ULL, 0x004fc60000011424ULL, 0x000000141838723cULL, 0x000fe20000001838ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x00000018ff747819ULL, 0x000fe40000011425ULL,
0x00000018ff167819ULL, 0x000fc60000011426ULL, 0x0000541017147816ULL, 0x010fe2000000006eULL,
0x00000100256e7824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff177819ULL, 0x000fc60000011427ULL, 0x00000018ff777819ULL, 0x000fe4000001146eULL,
0x00000018ff6e7819ULL, 0x002fe4000001143dULL, 0x0000541075157816ULL, 0x004fe20000000072ULL,
0x0000007700787306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fca000001143cULL,
0x000000141818723cULL, 0x000fe20000001810ULL, 0x00a800005410783bULL, 0x000e620000000200ULL,
0x0000007400747306ULL, 0x000fea0000200c00ULL, 0x0000010024157824ULL, 0x040fe200078e00ffULL,
0x0000888024147816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000001700177306ULL, 0x000fe40000200c00ULL, 0x00000018ff757819ULL, 0x000fc40000011415ULL,
0x0000888025157816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe40000011424ULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x0000888026247816ULL, 0x000fce00000000ffULL, 0x0000007500757306ULL, 0x000eb00000200c00ULL,
0x0000001500157306ULL, 0x000ee20000200c00ULL, 0x0000541014147816ULL, 0x004fe20000000075ULL,
0x0000006f1010b232ULL, 0x002fcc0000000000ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000006f1212b232ULL, 0x000fe20000000000ULL, 0x00000018ff6f7819ULL, 0x000fe20000011425ULL,
0x0000006c1111b232ULL, 0x080fe20000000000ULL, 0x0000888027257816ULL, 0x000fe200000000ffULL,
0x0000006c1313b232ULL, 0x000fe20000000000ULL, 0x0000541015157816ULL, 0x008fe40000000078ULL,
0x0000006f006f7306ULL, 0x000fea0000200c00ULL, 0x00000014101c723cULL, 0x000fe6000000181cULL,
0x0000002400247306ULL, 0x000fe80000200c00ULL, 0x0000010027157824ULL, 0x000fc400078e00ffULL,
0x0000010026147824ULL, 0x040fe400078e00ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011415ULL, 0x0001000026157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff157819ULL, 0x000fca0000011415ULL,
0x0000001400777306ULL, 0x0002b00000200c00ULL, 0x0000001500757306ULL, 0x0007e20000200c00ULL,
0x0000541076147816ULL, 0x002fe40000000073ULL, 0x0000541024247816ULL, 0x004fca0000000077ULL,
0x0000007800267306ULL, 0x000e620000200c00ULL, 0x000054106f157816ULL, 0x008fe40000000074ULL,
0x000088803c6f7816ULL, 0x000fca00000000ffULL, 0x00000027006c7306ULL, 0x0004e20000200c00ULL,
0x000000141020723cULL, 0x000fe20000001820ULL, 0x0000541025257816ULL, 0x002fcc0000000026ULL,
0x000000ffff147224ULL, 0x000fe200078e006fULL, 0x000088803d157816ULL, 0x040fe200000000ffULL,
0x000001003d277824ULL, 0x044fe200078e00ffULL, 0x0000001600167306ULL, 0x000e620000200c00ULL,
0x000001003c6f7824ULL, 0x000fe200078e00ffULL, 0x000088803e267816ULL, 0x000fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011427ULL,
0x000100003c277824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001146fULL,
0x000000241028723cULL, 0x000fe20000001828ULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000054106c177816ULL, 0x008fc40000000017ULL, 0x00000018ff6f7819ULL, 0x000fe40000011427ULL,
0x000088803f6c7816ULL, 0x000fe200000000ffULL, 0x0000008000257824ULL, 0x000fe200078e0269ULL,
0x00000018ff277819ULL, 0x000fe2000001143dULL, 0x00000074003c7306ULL, 0x0004e20000200c00ULL,
0x0000541075167816ULL, 0x002fe20000000016ULL, 0x000000ffff247224ULL, 0x000fe400078e006cULL,
0x0000000f046c7c24ULL, 0x020fe4000f8e02ffULL, 0x000001003e3d7824ULL, 0x000fc400078e00ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000000806c6c7824ULL, 0x000fe200078e00ffULL,
0x00000016102c723cULL, 0x000fe2000000182cULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0106b80aff7479a7ULL, 0x004e620008500007ULL, 0x0000541015157816ULL, 0x008fc6000000003cULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x000001003f3c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff697819ULL, 0x000fe4000001143cULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x0000006c253c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x000054106f167816ULL, 0x004fe20000000072ULL, 0x0000007300737306ULL, 0x000ea20000200c00ULL,
0x000000103c6f7c11ULL, 0x040fe2000f8240ffULL, 0x00000075ff0075a7ULL, 0x002e66000808004cULL,
0x000000113c3c7c11ULL, 0x000fc600088f4417ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541014147816ULL, 0x004fce0000000073ULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x0000000225737836ULL, 0x000fca0000000000ULL, 0x0000006c73727210ULL, 0x000fe20007f5e0ffULL,
0x000000141030723cULL, 0x000fe20000001830ULL, 0x0000002400247306ULL, 0x000fec0000200c00ULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0x0000541027177816ULL, 0x004fe2000000006eULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000001072737c11ULL, 0x000fc8000f8440ffULL,
0x0000001172727c11ULL, 0x000fe200090f4415ULL, 0x000000161034723cULL, 0x000fe40000001834ULL,
0x0000002600267306ULL, 0x000fea0000200c00ULL, 0x0000000425177836ULL, 0x040fe20000000000ULL,
0x0000541024157816ULL, 0x004fe40000000069ULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000000800e697811ULL, 0x000fe200078e40ffULL, 0x0000000625257836ULL, 0x000fe20000000000ULL,
0x0000006c17247210ULL, 0x000fc40007f3e0ffULL, 0x0000000a69167c48ULL, 0x000fc6000ffe0000ULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000001024177c11ULL, 0x000fe4000f8240ffULL,
0x0000541026147816ULL, 0x004fe4000000003dULL, 0x00000018ff3d7819ULL, 0x000fe2000001143eULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000004273267210ULL, 0x000fc60007fde0ffULL,
0x000000141038723cULL, 0x000fe20000001838ULL, 0x00000018ff6e7819ULL, 0x000fe2000001143eULL,
0x0000003d003d7306ULL, 0x000fea0000200c00ULL, 0x0000001124147c11ULL, 0x000fe200088f4427ULL,
0x0000000116247824ULL, 0x000fe200078e0a69ULL, 0x00000018ff157819ULL, 0x000fe2000001143fULL,
0x000100003f167824ULL, 0x000fe200078e00ffULL, 0x0000006c253e7210ULL, 0x000fe20007f3e0ffULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000002024247807ULL, 0x000fe20000000000ULL,
0x000000ffff277224ULL, 0x000fe200030e0672ULL, 0x00000018ff767819ULL, 0x000fe20000011416ULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x000000103e3f7c11ULL, 0x000fc4000f8240ffULL,
0x000000240d247248ULL, 0x000fe20007fe0000ULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x000000113e3e7c11ULL, 0x000fe400088f4425ULL, 0x000000426f167210ULL, 0x000fe20007f3e0ffULL,
0x00000001246f7824ULL, 0x000fe200078e0a0dULL, 0x0000004217247210ULL, 0x000fc60007fbe0ffULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x000000ffff177224ULL, 0x000fe200008e063cULL,
0x0000006f5000720cULL, 0x080fe20003f46070ULL, 0x000000ffff257224ULL, 0x000fe200028e0614ULL,
0x000054106e147816ULL, 0x004fe4000000003dULL, 0x0000006f4e00720cULL, 0x080fe40003f26070ULL,
0x0000006f4c00720cULL, 0x080fe40003fa6070ULL, 0x0000006f4800720cULL, 0x000fc40003fc6070ULL,
0x0000541076157816ULL, 0x008fce0000000015ULL, 0x000000141018723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000084947ULL, 0x002fde0003800000ULL,
0x0106b875ff0075a7ULL, 0x000e640008080147ULL, 0x000000d80044c947ULL, 0x002fea0003800000ULL,
0x000000423f107210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016497faeULL, 0x0003e8000d101c48ULL, 0x000000ffff117224ULL, 0x000fe200020e063eULL,
0x0000000026527faeULL, 0x0003e8000c901c48ULL, 0x0000000024517faeULL, 0x0003e8000e901c48ULL,
0x00000000104f7faeULL, 0x0003e2000f101c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4bULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a80aff6e79a7ULL, 0x0004a20008500007ULL, 0x00000071ff0075a7ULL, 0x000ee4000802004eULL,
0x0000000000081947ULL, 0x00cfea0003800000ULL, 0x0106b071ff0075a7ULL, 0x000ea40008020147ULL,
0x000000d8001c9947ULL, 0x004fea0003800000ULL, 0x000000005314783bULL, 0x002e620000004200ULL,
0x0000000a69007c0cULL, 0x000fe2000bf21070ULL, 0x000000066b067221ULL, 0x000fe40000010000ULL,
0x000000004d24783bULL, 0x000fe80000004200ULL, 0x00a800004a10783bULL, 0x000fe80000000200ULL,
0x00001f416d3f7589ULL, 0x000ea800000e0000ULL, 0x00001f406d3e7589ULL, 0x000ee200000e0000ULL,
0x00000100143d7824ULL, 0x042fe200078e00ffULL, 0x00008880143c7816ULL, 0x000fe200000000ffULL,
0x0000010015717824ULL, 0x040fe200078e00ffULL, 0x0000888015707816ULL, 0x000fc400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff757819ULL, 0x000fe20000011471ULL, 0x0000003f1010b232ULL, 0x084fe20000000000ULL,
0x00000018ff747819ULL, 0x000fe20000011414ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011415ULL, 0x0001000015157824ULL, 0x000fe400078e00ffULL,
0x0000003f1212b232ULL, 0x000fe20000000000ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000003e1111b232ULL, 0x088fe20000000000ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000003e1313b232ULL, 0x000fe20000000000ULL,
0x00000018ff727819ULL, 0x000fc40000011416ULL, 0x00000018ff717819ULL, 0x000fe20000011417ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce0000011424ULL,
0x0000003d006d7306ULL, 0x0003f00000200c00ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x00005410703d7816ULL, 0x002fe40000000075ULL, 0x00000018ff707819ULL, 0x000fca0000011425ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000003c101c723cULL, 0x000fee000000181cULL,
0x0000001400757306ULL, 0x000e620000200c00ULL, 0x00008880163d7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fca0000011426ULL, 0x0000001500767306ULL, 0x000ea20000200c00ULL,
0x0000541075147816ULL, 0x002fe20000000074ULL, 0x0000010016747824ULL, 0x040fe200078e00ffULL,
0x0000888017757816ULL, 0x000fe200000000ffULL, 0x0001000016167824ULL, 0x000fc800078e00ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000541076157816ULL, 0x004fca0000000073ULL, 0x0000003d00737306ULL, 0x0003e40000200c00ULL,
0x000000141020723cULL, 0x000fec0000001820ULL, 0x0000007400147306ULL, 0x0004e20000200c00ULL,
0x00000018ff3d7819ULL, 0x002fe20000011427ULL, 0x0000010017157824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011415ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe20000011416ULL, 0x0001000017167824ULL, 0x000fe200078e00ffULL,
0x0000888025747816ULL, 0x004fe400000000ffULL, 0x0000541073147816ULL, 0x008fc60000000014ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000888024737816ULL, 0x000fca00000000ffULL, 0x0000001500177306ULL, 0x0003f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541075157816ULL, 0x002fce0000000076ULL,
0x000000141028723cULL, 0x000fe20000001828ULL, 0x0000001600167306ULL, 0x000e6c0000200c00ULL,
0x0000010025157824ULL, 0x040fe400078e00ffULL, 0x0000010024147824ULL, 0x040fe200078e00ffULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000001500757306ULL, 0x0002a20000200c00ULL, 0x00000018ff257819ULL, 0x000fce0000011425ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541016157816ULL, 0x002fe20000000071ULL,
0x0000010026717824ULL, 0x000fcc00078e00ffULL, 0x0000001400767306ULL, 0x0002f00000200c00ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541017147816ULL, 0x002fe40000000072ULL,
0x0000888026727816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fc800078e00ffULL,
0x00000014102c723cULL, 0x000fe2000000182cULL, 0x0000002400247306ULL, 0x000e6c0000200c00ULL,
0x0000541074157816ULL, 0x004fe20000000075ULL, 0x0000010027747824ULL, 0x000fe200078e00ffULL,
0x0000541073147816ULL, 0x008fe20000000076ULL, 0x0000002500257306ULL, 0x000ea20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011471ULL, 0x0000888027717816ULL, 0x040fe400000000ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x000000141030723cULL, 0x000fe20000001830ULL,
0x00000018ff757819ULL, 0x000fe20000011426ULL, 0x0001000027267824ULL, 0x000fe200078e00ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000000004b14783bULL, 0x000ee20000004200ULL,
0x0000541024247816ULL, 0x002fe4000000006dULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000541025257816ULL, 0x004fe40000000070ULL, 0x0000007300737306ULL, 0x000e6a0000200c00ULL,
0x000000241034723cULL, 0x000fe60000001834ULL, 0x0000007100717306ULL, 0x000fe80000200c00ULL,
0x0000541072247816ULL, 0x002fc80000000073ULL, 0x0000007400747306ULL, 0x000e700000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000541071257816ULL, 0x002fce0000000074ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000100156d7824ULL, 0x048fe200078e00ffULL,
0x0000888015747816ULL, 0x000fe400000000ffULL, 0x00000018ff707819ULL, 0x000fe20000011414ULL,
0x000000241038723cULL, 0x000fe20000001838ULL, 0x00000018ff737819ULL, 0x000fe40000011415ULL,
0x0000007500277306ULL, 0x0002a20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011416ULL,
0x00000018ff717819ULL, 0x000fca0000011417ULL, 0x0000002600267306ULL, 0x000ee20000200c00ULL,
0x00000018ff757819ULL, 0x002fe4000001146dULL, 0x0000541027247816ULL, 0x004fca000000003cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00008880143c7816ULL, 0x000fe400000000ffULL,
0x0000541026257816ULL, 0x008fe2000000003dULL, 0x00000100143d7824ULL, 0x000fc800078e00ffULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000000241018723cULL, 0x000fe20000001818ULL,
0x00a800005510783bULL, 0x000e640000000200ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000000005624783bULL, 0x000eae0000004200ULL,
0x0000003d003d7306ULL, 0x000ef00000200c00ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x008fce000000003dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00005410743d7816ULL, 0x000fce0000000075ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000003f1010b232ULL, 0x082fe40000000000ULL, 0x0000003f1212b232ULL, 0x000fca0000000000ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000003e1111b232ULL, 0x080fe20000000000ULL,
0x00000018ff6d7819ULL, 0x004fe20000011424ULL, 0x0000003e1313b232ULL, 0x000fe20000000000ULL,
0x0000888024757816ULL, 0x000fe400000000ffULL, 0x00000018ff3f7819ULL, 0x000fe40000011425ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe20000011426ULL,
0x0000003c101c723cULL, 0x000fec000000181cULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x00010000153d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc80000011427ULL,
0x00000018ff747819ULL, 0x000fe4000001143dULL, 0x0000001400157306ULL, 0x000e620000200c00ULL,
0x00008880163d7816ULL, 0x000fce00000000ffULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x0000541015147816ULL, 0x002fe20000000070ULL, 0x0000010016157824ULL, 0x000fcc00078e00ffULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011415ULL, 0x0000541074157816ULL, 0x004fe40000000073ULL,
0x0000888017737816ULL, 0x040fe400000000ffULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x000000141020723cULL, 0x000fea0000001820ULL,
0x0000007000707306ULL, 0x000e640000200c00ULL, 0x0000010017147824ULL, 0x000fc400078e00ffULL,
0x000000ffff157224ULL, 0x000fe400078e0073ULL, 0x0001000017737824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000001600177306ULL, 0x0005e60000200c00ULL,
0x00000018ff737819ULL, 0x000fca0000011473ULL, 0x0000001500157306ULL, 0x000fe20000200c00ULL,
0x0000888026167816ULL, 0x004fce00000000ffULL, 0x0000001400747306ULL, 0x0002b00000200c00ULL,
0x0000007300787306ULL, 0x0007220000200c00ULL, 0x000054103d147816ULL, 0x002fe20000000070ULL,
0x00000100243d7824ULL, 0x000fc400078e00ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x0000541015157816ULL, 0x004fc60000000074ULL, 0x0000007500707306ULL, 0x000fe20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000888025737816ULL, 0x048fe400000000ffULL,
0x00000018ff747819ULL, 0x000fe20000011424ULL, 0x000000141028723cULL, 0x000fe40000001828ULL,
0x0000003d003d7306ULL, 0x000fea0000200c00ULL, 0x0000010025147824ULL, 0x000fc400078e00ffULL,
0x0000010026157824ULL, 0x000fe200078e00ffULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc80000011414ULL,
0x00000018ff247819ULL, 0x000fe20000011425ULL, 0x0001000027257824ULL, 0x000fe200078e00ffULL,
0x0000001400767306ULL, 0x0002a80000200c00ULL, 0x00000018ff257819ULL, 0x000fc80000011425ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000541017147816ULL, 0x002fe40000000072ULL,
0x00000018ff177819ULL, 0x000fe40000011415ULL, 0x0000541078157816ULL, 0x010fe40000000071ULL,
0x0000888027717816ULL, 0x040fe200000000ffULL, 0x0000002400247306ULL, 0x000e680000200c00ULL,
0x00000014102c723cULL, 0x000fe8000000182cULL, 0x0000001600167306ULL, 0x000fe60000200c00ULL,
0x0000010027147824ULL, 0x000fca00078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011414ULL,
0x0001000026147824ULL, 0x000fe200078e00ffULL, 0x0000001700177306ULL, 0x000f280000200c00ULL,
0x00000018ff147819ULL, 0x000fc80000011414ULL, 0x0000001500267306ULL, 0x0005f00000200c00ULL,
0x0000001400277306ULL, 0x000be20000200c00ULL, 0x0000541073157816ULL, 0x004fce0000000076ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x0000541070147816ULL, 0x020fce000000003dULL,
0x000000141030723cULL, 0x000fe20000001830ULL, 0x0000003c003c7306ULL, 0x000fec0000200c00ULL,
0x0000541074147816ULL, 0x008fe4000000006dULL, 0x0000541024157816ULL, 0x002fe2000000003fULL,
0x0000002500257306ULL, 0x000e6c0000200c00ULL, 0x000000141034723cULL, 0x000fee0000001834ULL,
0x0000541016147816ULL, 0x010fc40000000017ULL, 0x0000541071157816ULL, 0x004fce0000000026ULL,
0x000000141038723cULL, 0x000fee0000001838ULL, 0x0000541027147816ULL, 0x000fe4000000003eULL,
0x0000541025157816ULL, 0x002fce000000003cULL, 0x000000141010723cULL, 0x000fe20000001818ULL,
0x0106b80aff1479a7ULL, 0x0002a20008500007ULL, 0x0106900affff79a7ULL, 0x0003e20008500007ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000005000009947ULL, 0x000fde0003800000ULL,
0x00000015ff0075a7ULL, 0x004ea200080c004cULL, 0x000000a00e167811ULL, 0x000fe400078e40ffULL,
0x000000506a177210ULL, 0x100fe40007ffe00dULL, 0x0000000a16197c48ULL, 0x000fe4000ffe0000ULL,
0x000000176c3e7210ULL, 0x000fe40007f3e0ffULL, 0x0000004e6a1b7210ULL, 0x140fe20007ffe00dULL,
0x0000000119167824ULL, 0x000fe200078e0a16ULL, 0x0000004c6a197210ULL, 0x140fe20007ffe00dULL,
0x000000ffff257224ULL, 0x000fe200008e06ffULL, 0x000000486a177210ULL, 0x000fc40007ffe00dULL,
0x0000001b6c3d7210ULL, 0x000fe40007f5e0ffULL, 0x000000196c3c7210ULL, 0x000fe40007f7e0ffULL,
0x000000176c177210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x000000103e3f7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x0000002016167807ULL, 0x000fe20000000000ULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x000000113e3e7c11ULL, 0x000fc400088f4425ULL, 0x000000103d257c11ULL, 0x000fe4000f8240ffULL,
0x000000103c197c11ULL, 0x040fe4000f8440ffULL, 0x0000001017277c11ULL, 0x000fe4000f8640ffULL,
0x000000160d167248ULL, 0x000fe40007fe0000ULL, 0x000000113d3d7c11ULL, 0x000fe400088f4418ULL,
0x000000113c3c7c11ULL, 0x000fc400090f441bULL, 0x0000001117267c11ULL, 0x000fe200098f4426ULL,
0x0000000116177824ULL, 0x000fe200078e0a0dULL, 0x000000423f247210ULL, 0x000fe40007f3e0ffULL,
0x00000042251a7210ULL, 0x000fe40007f5e0ffULL, 0x0000004219187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e063eULL, 0x000000175000720cULL, 0x080fe20003f26070ULL,
0x000000ffff1b7224ULL, 0x000fe200010e063dULL, 0x000000174e00720cULL, 0x080fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fe200018e063cULL, 0x000000174c00720cULL, 0x000fc40003f66070ULL,
0x000000174800720cULL, 0x000fe40003f86070ULL, 0x0000004227167210ULL, 0x000fe20007fbe0ffULL,
0x0000000000086947ULL, 0x004fd80003800000ULL, 0x0106b815ff0075a7ULL, 0x000ea400080c0147ULL,
0x000000c400f8e947ULL, 0x004fea0003800000ULL, 0x000000ffff177224ULL, 0x000fe200028e0626ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000245c7faeULL, 0x0005e8000c901c48ULL,
0x000000001a5b7faeULL, 0x0005e8000d101c48ULL, 0x0000000018477faeULL, 0x0005e8000d901c48ULL,
0x0000000016467faeULL, 0x0005e2000e101c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106b00aff7079a7ULL, 0x0006e20008500007ULL, 0x0000006fff0075a7ULL, 0x0006e2000802004bULL,
0x0106480a0d1479a7ULL, 0x000f240008500007ULL, 0x010648150d0075a7ULL, 0x010f240008040147ULL,
0x000000c400d4a947ULL, 0x01afea0003800000ULL, 0x0101000045147984ULL, 0x000e620000000800ULL,
0x00000001ff3d7424ULL, 0x000fc600078e00ffULL, 0x0103000045697984ULL, 0x0006e20000000800ULL,
0x000000051400720bULL, 0x002fda0003f5d000ULL, 0x0000000000157806ULL, 0x000fc800010e0100ULL,
0x0000ffff15177812ULL, 0x004fda000784c0ffULL, 0x0000000000cca947ULL, 0x008fea0003800000ULL,
0x000000051400720bULL, 0x000fe40003f54000ULL, 0x0000001405167209ULL, 0x000fca0007810000ULL,
0x8000001605157221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b15157820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400010e0100ULL, 0x000000020f00780cULL, 0x000fe40003f45270ULL,
0x0000ffff05187812ULL, 0x000fe200078e3cffULL, 0x0000001500157308ULL, 0x000e660000000800ULL,
0x0000001817ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff3d7807ULL, 0x000fc60001800000ULL,
0x010500164500a388ULL, 0x000fe80000000800ULL, 0x00001f4115057589ULL, 0x002e6400000e0000ULL,
0x8000001614173221ULL, 0x000fe20000010000ULL, 0x0000001506067220ULL, 0x000fe20000410000ULL,
0x00001f4015147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b17173820ULL, 0x000fc80000410000ULL,
0x00000017000c3308ULL, 0x000ee20000000800ULL, 0x000000051c1c7220ULL, 0x082fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x000fe20000410000ULL, 0x000000141e1e7220ULL, 0x084fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x000000143a3a7220ULL, 0x080fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fe20000410000ULL, 0x000000ffff057224ULL, 0x000fc400078e0016ULL,
0x000000690c693220ULL, 0x008fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a86fff0075a7ULL, 0x000e640008020147ULL, 0x000000c000f89947ULL, 0x002fea0003800000ULL,
0x000000004424783bULL, 0x000e620000004200ULL, 0x0000000cff6a723eULL, 0x000fe400000000ffULL,
0x000099103d747816ULL, 0x000fe200000000ffULL, 0x000000005a18783bULL, 0x000fe20000004200ULL,
0x000054106a6a7816ULL, 0x000fe4000000006aULL, 0x000000ff7400720cULL, 0x000fe20003f25270ULL,
0x00b000005714783bULL, 0x000fe80000000200ULL, 0x00001f416a6b7589ULL, 0x000ea800000e0000ULL,
0x00001f406a6e7589ULL, 0x000ee200000e0000ULL, 0x00000100243e7824ULL, 0x042fe200078e00ffULL,
0x00008880243c7816ULL, 0x000fe200000000ffULL, 0x0000010025747824ULL, 0x040fe200078e00ffULL,
0x0000888025737816ULL, 0x000fc400000000ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000006b14149232ULL, 0x084fe20000000000ULL, 0x00000018ff6d7819ULL, 0x000fe20000011424ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe20000011425ULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x0000006b16169232ULL, 0x000fe20000000000ULL,
0x0000003e003d7306ULL, 0x000e620000200c00ULL, 0x0000006e15159232ULL, 0x088fe20000000000ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006e17179232ULL, 0x000fe20000000000ULL,
0x00000018ff257819ULL, 0x000fc40000011425ULL, 0x00000018ff757819ULL, 0x000fe4000001141aULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fe40000011426ULL,
0x00000018ff3f7819ULL, 0x000fe40000011427ULL, 0x000054103c3c7816ULL, 0x002fc6000000003dULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce0000011418ULL,
0x0000003d003e7306ULL, 0x0003f00000200c00ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00005410733d7816ULL, 0x002fe40000000074ULL, 0x00000018ff747819ULL, 0x000fc40000011419ULL,
0x0000888026737816ULL, 0x000fc600000000ffULL, 0x0000003c141c723cULL, 0x000fe2000000181cULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000002400247306ULL, 0x000e700000200c00ULL,
0x00000025003c7306ULL, 0x000ea20000200c00ULL, 0x0000541024247816ULL, 0x002fce000000006dULL,
0x00000074003d7306ULL, 0x000fe20000200c00ULL, 0x000054103c257816ULL, 0x004fe2000000006fULL,
0x00000100266f7824ULL, 0x000fcc00078e00ffULL, 0x00000075006d7306ULL, 0x0003e20000200c00ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x000000241420723cULL, 0x000fea0000001820ULL, 0x00000073003c7306ULL, 0x000fe40000200c00ULL,
0x0000010027247824ULL, 0x040fe200078e00ffULL, 0x0000888027257816ULL, 0x000fca00000000ffULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff757819ULL, 0x002fe40000011424ULL,
0x00000018ff247819ULL, 0x000fe20000011426ULL, 0x0001000027267824ULL, 0x000fc800078e00ffULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x00000018ff267819ULL, 0x000fce0000011426ULL,
0x0000007500747306ULL, 0x000e700000200c00ULL, 0x0000002400277306ULL, 0x0005e20000200c00ULL,
0x0000541025257816ULL, 0x002fce0000000074ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x000054103c247816ULL, 0x004fe2000000006fULL, 0x00000100183c7824ULL, 0x040fe200078e00ffULL,
0x00008880186f7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fc600078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001143cULL, 0x000000241428723cULL, 0x000fe20000001828ULL,
0x0000002600267306ULL, 0x000e620000200c00ULL, 0x00008880193c7816ULL, 0x000fe400000000ffULL,
0x00000018ff187819ULL, 0x000fc60000011418ULL, 0x0000010019247824ULL, 0x040fe400078e00ffULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0001000019197824ULL, 0x000fe400078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x0000541026257816ULL, 0x002fc6000000003fULL,
0x0000006f00747306ULL, 0x0003f00000200c00ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x002fce000001141bULL, 0x0000003c003c7306ULL, 0x000ff00000200c00ULL,
0x0000002400737306ULL, 0x0004700000200c00ULL, 0x00000018003f7306ULL, 0x0007220000200c00ULL,
0x0000541027247816ULL, 0x004fc40000000072ULL, 0x00000018ff727819ULL, 0x000fe40000011419ULL,
0x000054103c197816ULL, 0x002fc60000000073ULL, 0x00000024142c723cULL, 0x000fe2000000182cULL,
0x0000541074187816ULL, 0x008fe20000000075ULL, 0x000000005924783bULL, 0x000e620000004200ULL,
0x000088801b737816ULL, 0x000fe200000000ffULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000088801a747816ULL, 0x040fe400000000ffULL, 0x000054103f3c7816ULL, 0x010fe2000000003eULL,
0x000000181430723cULL, 0x000fe20000001830ULL, 0x000001001b3e7824ULL, 0x040fe400078e00ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000007400187306ULL, 0x0007e40000200c00ULL,
0x00000018ff757819ULL, 0x000fe2000001143eULL, 0x000001001a197824ULL, 0x040fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe2000001141bULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00005410723d7816ULL, 0x004fc4000000003dULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff747819ULL, 0x008fe4000001141aULL,
0x0000003c143c723cULL, 0x000fe20000001834ULL, 0x000000005834783bULL, 0x000ea40000004200ULL,
0x0000001900197306ULL, 0x000ef00000200c00ULL, 0x0000007500767306ULL, 0x000f220000200c00ULL,
0x00000018ff727819ULL, 0x002fc40000011424ULL, 0x0000541018187816ULL, 0x008fca0000000019ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1a7819ULL, 0x000fe40000011426ULL,
0x00000018ff1b7819ULL, 0x000fe40000011427ULL, 0x0000541073197816ULL, 0x010fc60000000076ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x00000018ff737819ULL, 0x000fc60000011425ULL,
0x000000181438723cULL, 0x000fe80000001838ULL, 0x0000007700767306ULL, 0x000ee60000200c00ULL,
0x0000541074187816ULL, 0x002fe2000000006dULL, 0x00000100256d7824ULL, 0x040fe200078e00ffULL,
0x0000888025747816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fc400078e00ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff757819ULL, 0x000fe4000001146dULL,
0x0000541076197816ULL, 0x008fe4000000006fULL, 0x00000018ff6d7819ULL, 0x004fc60000011435ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe20000011434ULL,
0x000000181414723cULL, 0x000fe20000001810ULL, 0x00b000005410783bULL, 0x000e6a0000000200ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000010024197824ULL, 0x040fe200078e00ffULL,
0x0000888024187816ULL, 0x040fe200000000ffULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000001800187306ULL, 0x000ff00000200c00ULL, 0x0000001900197306ULL, 0x000eb00000200c00ULL,
0x0000001b001b7306ULL, 0x000fe20000200c00ULL, 0x0000006b10109232ULL, 0x002fc40000000000ULL,
0x0000006b12129232ULL, 0x000fe20000000000ULL, 0x0000541018187816ULL, 0x004fe20000000019ULL,
0x0000006e11119232ULL, 0x080fe20000000000ULL, 0x0000541074197816ULL, 0x000fe20000000075ULL,
0x0000006e13139232ULL, 0x000fe20000000000ULL, 0x00000018ff757819ULL, 0x000fe20000011424ULL,
0x0000001a001a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff747819ULL, 0x000fe40000011425ULL,
0x0000888026257816ULL, 0x000fe400000000ffULL, 0x00000018101c723cULL, 0x000fe2000000181cULL,
0x00008880276e7816ULL, 0x000fc400000000ffULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x00000018ff6b7819ULL, 0x000fc60000011436ULL, 0x0000010026187824ULL, 0x040fe400078e00ffULL,
0x0000010027197824ULL, 0x040fe400078e00ffULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000026267824ULL, 0x000fe400078e00ffULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000001800247306ULL, 0x0003f00000200c00ULL, 0x0000002500257306ULL, 0x000ee20000200c00ULL,
0x0000541075187816ULL, 0x002fc40000000072ULL, 0x00000018ff757819ULL, 0x000fe40000011419ULL,
0x0000541074197816ULL, 0x004fe40000000073ULL, 0x0000888035727816ULL, 0x040fe200000000ffULL,
0x0000002600737306ULL, 0x0003e80000200c00ULL, 0x000000181020723cULL, 0x000fe80000001820ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000010035267824ULL, 0x002fc400078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011427ULL, 0x0000010034277824ULL, 0x040fe200078e00ffULL,
0x0000888034197816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0001000034347824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011434ULL, 0x0000001800187306ULL, 0x000e620000200c00ULL,
0x00000018ff347819ULL, 0x000fce0000011437ULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000002600777306ULL, 0x0006b00000200c00ULL, 0x0000001900197306ULL, 0x000fe20000200c00ULL,
0x0000541025267816ULL, 0x008fc40000000024ULL, 0x0000541018257816ULL, 0x002fe4000000001bULL,
0x0000541073247816ULL, 0x000fe4000000001aULL, 0x00005410721b7816ULL, 0x004fe20000000077ULL,
0x0000002700747306ULL, 0x0002a20000200c00ULL, 0x0106b80aff7279a7ULL, 0x000ee60008500007ULL,
0x00000024102c723cULL, 0x000fe8000000182cULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000054106e277816ULL, 0x002fc40000000075ULL, 0x00000018ff6e7819ULL, 0x000fe40000011435ULL,
0x0000006c61357210ULL, 0x000fe20007f5e0ffULL, 0x0000010036617824ULL, 0x040fe200078e00ffULL,
0x00005410191a7816ULL, 0x004fe20000000074ULL, 0x000000261028723cULL, 0x000fe20000001828ULL,
0x0000888036197816ULL, 0x040fe200000000ffULL, 0x000000ffff747224ULL, 0x000fe200010e06ffULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000001a1030723cULL, 0x000fe20000001830ULL,
0x000000ffff267224ULL, 0x000fe200078e0019ULL, 0x0000006c63197210ULL, 0x000fe20007f7e0ffULL,
0x00000073ff0075a7ULL, 0x008e6200080c004cULL, 0x0000001035277c11ULL, 0x040fe2000f8440ffULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00000018ff787819ULL, 0x000fe20000011436ULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x0000001135357c11ULL, 0x000fe200090f4474ULL,
0x00000100371a7824ULL, 0x000fe200078e00ffULL, 0x0000001019257c11ULL, 0x000fc4000f8440ffULL,
0x0000006c62747210ULL, 0x000fe20007f7e0ffULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x0000001119627c11ULL, 0x000fe400090f4424ULL, 0x00000010741b7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff197224ULL, 0x000fe200018e06ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000541076187816ULL, 0x004fe2000000006fULL, 0x0000006100637306ULL, 0x0005e20000200c00ULL,
0x0000001174747c11ULL, 0x000fc400090f4419ULL, 0x00008880376f7816ULL, 0x000fe400000000ffULL,
0x0000006c5f5f7210ULL, 0x000fe40007f5e0ffULL, 0x000054106e197816ULL, 0x008fe2000000006dULL,
0x0000002600267306ULL, 0x000fe20000200c00ULL, 0x000000c00e617811ULL, 0x004fe200078e40ffULL,
0x000000ffff367224ULL, 0x000fc600010e06ffULL, 0x0000000a61247c48ULL, 0x000fe2000ffe0000ULL,
0x00000018103c723cULL, 0x000fe4000000183cULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x0000000124247824ULL, 0x000fc600078e0a61ULL, 0x0001000037187824ULL, 0x000fe200078e00ffULL,
0x000000105f377c11ULL, 0x000fe4000f8440ffULL, 0x0000001a006e7306ULL, 0x0004e20000200c00ULL,
0x0000002024767807ULL, 0x000fe40000000000ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x000000760d7a7248ULL, 0x000fe40007fe0000ULL, 0x000000115f367c11ULL, 0x000fe200090f4436ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000004227247210ULL, 0x000fe20007f5e0ffULL,
0x000000017a197824ULL, 0x000fe200078e0a0dULL, 0x00000042251a7210ULL, 0x004fc40007f7e0ffULL,
0x000000421b767210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff257224ULL, 0x000fe200010e0635ULL,
0x000000195000720cULL, 0x080fe20003f46070ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000000ffff1b7224ULL, 0x000fe200018e0662ULL, 0x000000194e00720cULL, 0x080fe20003f66070ULL,
0x000000ffff777224ULL, 0x000fe200020e0674ULL, 0x000000194c00720cULL, 0x080fe40003f86070ULL,
0x000000194800720cULL, 0x000fe40003fa6070ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x000054106f197816ULL, 0x008fce000000006eULL, 0x0000001800277306ULL, 0x0007240000200c00ULL,
0x0000541026187816ULL, 0x008fce0000000063ULL, 0x000000181038723cULL, 0x000fee0000001838ULL,
0x0000541078187816ULL, 0x004fe4000000006bULL, 0x0000541027197816ULL, 0x010fce0000000034ULL,
0x000000181014723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000086947ULL, 0x002fde0003800000ULL, 0x0106b873ff0075a7ULL, 0x000e6400080c0147ULL,
0x000000b000e8e947ULL, 0x002fea0003800000ULL, 0x0000004237107210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024497faeULL, 0x0003e8000d101c48ULL,
0x000000ffff117224ULL, 0x000fe200030e0636ULL, 0x000000001a527faeULL, 0x0003e8000d901c48ULL,
0x0000000076517faeULL, 0x0003e8000e101c48ULL, 0x00000000104f7faeULL, 0x0003e2000e901c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a4bULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a80aff6e79a7ULL, 0x0004a20008500007ULL,
0x00000071ff0075a7ULL, 0x000ee4000804004eULL, 0x0000000000082947ULL, 0x00cfea0003800000ULL,
0x0106b071ff0075a7ULL, 0x000ea40008040147ULL, 0x000000b000c0a947ULL, 0x004fea0003800000ULL,
0x000000005334783bULL, 0x000ea20000004200ULL, 0x0000000669067221ULL, 0x000fc60000010000ULL,
0x00b000004a18783bULL, 0x002fe80000000200ULL, 0x00001f416a5f7589ULL, 0x000e6800000e0000ULL,
0x00001f406a627589ULL, 0x000ee800000e0000ULL, 0x000000004d24783bULL, 0x000f220000004200ULL,
0x00000018ff717819ULL, 0x004fe20000011434ULL, 0x0000010034117824ULL, 0x040fe200078e00ffULL,
0x0000888034107816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011435ULL, 0x0000010035137824ULL, 0x040fe200078e00ffULL,
0x0000888035127816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000005f18189232ULL, 0x082fe20000000000ULL, 0x0000888036747816ULL, 0x000fe200000000ffULL,
0x0000005f1a1a9232ULL, 0x000fe20000000000ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000006219199232ULL, 0x088fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011436ULL,
0x000000621b1b9232ULL, 0x000fe20000000000ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc40000011437ULL, 0x00000018ff6b7819ULL, 0x010fe40000011424ULL,
0x00000018ff707819ULL, 0x000fe40000011425ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x00000018ff757819ULL, 0x000fe40000011427ULL, 0x00000018ff727819ULL, 0x000fc60000011426ULL,
0x00000035006a7306ULL, 0x000ea20000200c00ULL, 0x0000541034347816ULL, 0x002fe20000000071ULL,
0x0000010036717824ULL, 0x000fcc00078e00ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x000054106a357816ULL, 0x004fe40000000063ULL, 0x00008880376a7816ULL, 0x040fe400000000ffULL,
0x0000007100637306ULL, 0x000e620000200c00ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000000341820723cULL, 0x000fea0000001820ULL, 0x0000007300737306ULL, 0x000fe40000200c00ULL,
0x0000010037357824ULL, 0x000fc400078e00ffULL, 0x000000ffff347224ULL, 0x000fe400078e006aULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x00000034006a7306ULL, 0x0003e60000200c00ULL, 0x00000018ff767819ULL, 0x000fca0000011437ULL,
0x0000003500357306ULL, 0x000ea20000200c00ULL, 0x0000541074347816ULL, 0x002fce0000000063ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000054106a357816ULL, 0x004fce0000000035ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x000000341828723cULL, 0x000fee0000001828ULL,
0x00000036006a7306ULL, 0x0002a20000200c00ULL, 0x0000888024347816ULL, 0x040fe200000000ffULL,
0x0000010024357824ULL, 0x000fc400078e00ffULL, 0x0001000024247824ULL, 0x000fc800078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000010025367824ULL, 0x042fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011435ULL, 0x0000888025357816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fce0000011436ULL,
0x0000002400747306ULL, 0x0004700000200c00ULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x000054106a247816ULL, 0x004fe40000000073ULL, 0x00000018ff737819ULL, 0x000fc40000011425ULL,
0x0000541076257816ULL, 0x000fc6000000006dULL, 0x0000001100117306ULL, 0x000ea80000200c00ULL,
0x00000024182c723cULL, 0x000fe8000000182cULL, 0x0000007300737306ULL, 0x000ee60000200c00ULL,
0x0000888026257816ULL, 0x000fc400000000ffULL, 0x0000541074247816ULL, 0x002fe4000000006bULL,
0x0000541010107816ULL, 0x004fe20000000011ULL, 0x0000001200127306ULL, 0x000fe20000200c00ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0025ULL, 0x0000541073257816ULL, 0x008fcc0000000070ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x0000010026707824ULL, 0x040fe400078e00ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000024183c723cULL, 0x000fe8000000183cULL,
0x0000007500717306ULL, 0x0005e20000200c00ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x00000018ff247819ULL, 0x000fe20000011470ULL, 0x0000010027707824ULL, 0x040fe200078e00ffULL,
0x0000888027257816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000541012117816ULL, 0x002fe20000000013ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff757819ULL, 0x004fc40000011470ULL, 0x00000018ff747819ULL, 0x000fc60000011427ULL,
0x00000010181c723cULL, 0x000fe2000000181cULL, 0x000000004b10783bULL, 0x000e620000004200ULL,
0x0000002400247306ULL, 0x000eb00000200c00ULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x000054106b247816ULL, 0x004fce0000000024ULL, 0x0000007500767306ULL, 0x000eb00000200c00ULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x0000541025257816ULL, 0x004fce0000000076ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x000000241838723cULL, 0x000fe20000001838ULL,
0x00000018ff637819ULL, 0x002fcc0000011410ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fe40000011411ULL, 0x00000018ff6a7819ULL, 0x000fe40000011412ULL,
0x00000018ff707819ULL, 0x000fe40000011413ULL, 0x0000541034347816ULL, 0x004fe20000000037ULL,
0x0000003600367306ULL, 0x000e700000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x002fce0000000036ULL, 0x0000002600737306ULL, 0x000e620000200c00ULL,
0x000000341830723cULL, 0x000fe20000001830ULL, 0x000000005634783bULL, 0x000eac0000004200ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x0000541073247816ULL, 0x002fe20000000072ULL,
0x0000010011737824ULL, 0x000fcc00078e00ffULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x0000541074257816ULL, 0x008fe40000000071ULL,
0x0000888010717816ULL, 0x000fc600000000ffULL, 0x0000007300787306ULL, 0x000fe20000200c00ULL,
0x0000888012747816ULL, 0x000fe200000000ffULL, 0x000000241818723cULL, 0x000fe20000001814ULL,
0x00b000005514783bULL, 0x000e6a0000000200ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000010010257824ULL, 0x040fe400078e00ffULL, 0x0001000010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011425ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000888011257816ULL, 0x040fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff757819ULL, 0x004fe40000011436ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x00000018ff277819ULL, 0x000fc40000011434ULL, 0x00000018ff247819ULL, 0x000fe40000011437ULL,
0x00000018ff6b7819ULL, 0x000fc60000011435ULL, 0x0000002500257306ULL, 0x000ef00000200c00ULL,
0x0000001000767306ULL, 0x0005e20000200c00ULL, 0x0000005f14149232ULL, 0x082fe40000000000ULL,
0x0000005f16169232ULL, 0x000fc40000000000ULL, 0x00000100125f7824ULL, 0x000fe400078e00ffULL,
0x0000006215159232ULL, 0x080fe20000000000ULL, 0x0000541071107816ULL, 0x004fe20000000072ULL,
0x0000006217179232ULL, 0x000fe20000000000ULL, 0x0000001100727306ULL, 0x0006620000200c00ULL,
0x00000018ff627819ULL, 0x000fe4000001145fULL, 0x00008880135f7816ULL, 0x000fe400000000ffULL,
0x0000000a61007c0cULL, 0x000fc6000bf21070ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541025117816ULL, 0x008fce0000000078ULL, 0x00000010141c723cULL, 0x000fe2000000181cULL,
0x0000006200257306ULL, 0x0004ec0000200c00ULL, 0x0000010013107824ULL, 0x040fe400078e00ffULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000888034627816ULL, 0x004fc400000000ffULL, 0x00000018ff117819ULL, 0x000fe20000011410ULL,
0x0001000012107824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001100127306ULL, 0x0002a40000200c00ULL, 0x00000018ff107819ULL, 0x000fcc0000011410ULL,
0x0000001000737306ULL, 0x0009e20000200c00ULL, 0x0000541072117816ULL, 0x002fe4000000006dULL,
0x00008880376d7816ULL, 0x000fca00000000ffULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541076107816ULL, 0x010fe20000000063ULL, 0x0000010034637824ULL, 0x040fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x000000101420723cULL, 0x000fe20000001820ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fca0000011434ULL, 0x0000010035107824ULL, 0x000fe400078e00ffULL,
0x0000010036117824ULL, 0x000fe200078e00ffULL, 0x0000001300717306ULL, 0x0003240000200c00ULL,
0x00000018ff107819ULL, 0x000fcc0000011410ULL, 0x0000001000767306ULL, 0x0007e20000200c00ULL,
0x0000888036137816ULL, 0x042fe200000000ffULL, 0x0001000036367824ULL, 0x000fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000007500267306ULL, 0x0003e20000200c00ULL,
0x0000541074107816ULL, 0x008fe40000000025ULL, 0x00000018ff257819ULL, 0x000fe40000011411ULL,
0x000054105f117816ULL, 0x004fc60000000012ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000888035757816ULL, 0x042fe200000000ffULL, 0x0001000035357824ULL, 0x000fe400078e00ffULL,
0x000000101428723cULL, 0x000fe60000001828ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000006300637306ULL, 0x000e660000200c00ULL, 0x0000010037107824ULL, 0x000fe200078e00ffULL,
0x0000541071117816ULL, 0x010fe20000000070ULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000001000747306ULL, 0x0007f00000200c00ULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541073107816ULL, 0x008fce000000006aULL, 0x0000002500127306ULL, 0x0007220000200c00ULL,
0x00000010142c723cULL, 0x000fee000000182cULL, 0x0000006d006d7306ULL, 0x000f620000200c00ULL,
0x00000018ff257819ULL, 0x008fe40000011437ULL, 0x0000541062107816ULL, 0x002fc40000000063ULL,
0x0000541075117816ULL, 0x004fc60000000076ULL, 0x0000002700277306ULL, 0x000fe80000200c00ULL,
0x000000101430723cULL, 0x000fe80000001830ULL, 0x0000006b006b7306ULL, 0x000fe60000200c00ULL,
0x0000541013107816ULL, 0x010fc40000000012ULL, 0x000054106d117816ULL, 0x020fc60000000074ULL,
0x0000002400247306ULL, 0x000fe80000200c00ULL, 0x000000101438723cULL, 0x000fe80000001838ULL,
0x0000003400347306ULL, 0x000e700000200c00ULL, 0x0000003500727306ULL, 0x000ea20000200c00ULL,
0x0000541034347816ULL, 0x002fce0000000027ULL, 0x00000036005f7306ULL, 0x0002e20000200c00ULL,
0x0000541072357816ULL, 0x004fce000000006bULL, 0x0000002500257306ULL, 0x000ea20000200c00ULL,
0x000000341434723cULL, 0x002fe2000000183cULL, 0x000054105f107816ULL, 0x008fe40000000026ULL,
0x0000541025117816ULL, 0x004fce0000000024ULL, 0x000000101410723cULL, 0x000fe20000001818ULL,
0x0106b80aff1479a7ULL, 0x0002a20008500007ULL, 0x0106980affff79a7ULL, 0x0003e20008500007ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000002800189947ULL, 0x000fde0003800000ULL,
0x000000015d047812ULL, 0x000fe200078ec0ffULL, 0x00000015ff0075a7ULL, 0x004ea2000804004cULL,
0x0000006c671a7210ULL, 0x000fe40007fbe0ffULL, 0x000000010400780cULL, 0x000fe40003f25070ULL,
0x000000e00e047811ULL, 0x000fe200078e40ffULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x0000000164647807ULL, 0x000fe40004800000ULL, 0x0000000a04177c48ULL, 0x000fc4000ffe0000ULL,
0x0000006c68247210ULL, 0x000fe20007f9e0ffULL, 0x000000015d5d7824ULL, 0x000fe200078e0264ULL,
0x0000006c66667210ULL, 0x000fe20007f7e0ffULL, 0x0000000117177824ULL, 0x000fe200078e0a04ULL,
0x0000006c65267210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200020e06ffULL,
0x000000045d007c0cULL, 0x000fe4000bf26070ULL, 0x0000002017047807ULL, 0x000fe20000000000ULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x000000101a3f7c11ULL, 0x000fc4000f8040ffULL,
0x0000001024257c11ULL, 0x000fe4000f8840ffULL, 0x000000040d047248ULL, 0x000fe40007fe0000ULL,
0x000000111a1a7c11ULL, 0x000fe200080f4419ULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x0000001124247c11ULL, 0x000fe2000a0f441bULL, 0x00008c00ff169b82ULL, 0x000ee20000000a00ULL,
0x0000004225187210ULL, 0x000fe20007f7e0ffULL, 0x00000001041b7824ULL, 0x000fe200078e0a0dULL,
0x00000010663d7c11ULL, 0x000fc4000f8840ffULL, 0x0000001026257c11ULL, 0x000fe4000f8a40ffULL,
0x0000001166047c11ULL, 0x000fe4000a0f4419ULL, 0x0000001126267c11ULL, 0x000fe4000a8f4427ULL,
0x0000001b5000720cULL, 0x000fe20003f06070ULL, 0x0000000000082947ULL, 0x004fd80003800000ULL,
0x0106b815ff0075a7ULL, 0x000ea40008040147ULL, 0x000000a000b4a947ULL, 0x004fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe200018e0624ULL, 0x000000423f147210ULL, 0x000fe40007fbe0ffULL,
0x0000001b4e00720cULL, 0x080fe40003f86070ULL, 0x0000001b5e00720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000185c7faeULL, 0x0005e2000c101c48ULL,
0x0000001b6000720cULL, 0x000fe20003f46070ULL, 0x000000ffff157224ULL, 0x000fe200028e061aULL,
0x000000423d247210ULL, 0x000fe20007f1e0ffULL, 0x000000015d1b9824ULL, 0x000fe200078e0208ULL,
0x00000042251a7210ULL, 0x000fc60007fbe0ffULL, 0x000000041b169825ULL, 0x008fe400078e0016ULL,
0x00000000145b7faeULL, 0x0007e4000e101c48ULL, 0x000000ffff257224ULL, 0x000fe400000e0604ULL,
0x000000ffff1b7224ULL, 0x000fe400028e0626ULL, 0xffffffffff047424ULL, 0x000fe200078e00ffULL,
0x0000000024477faeULL, 0x0007e8000d901c48ULL, 0x000000001a467faeULL, 0x0007e2000d101c48ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000816049981ULL, 0x000768000c1e1900ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4eULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0106b00aff7079a7ULL, 0x0004a20008500007ULL, 0x0000006fff0075a7ULL, 0x0004a2000800004bULL,
0x0106680a0d1479a7ULL, 0x008ee40008500007ULL, 0x010668150d0075a7ULL, 0x008ee40008020147ULL,
0x000000a0005c9947ULL, 0x00efea0003800000ULL, 0x0101800045147984ULL, 0x000e620000000800ULL,
0x00000001ff627424ULL, 0x000fc600078e00ffULL, 0x01038000455b7984ULL, 0x0004a20000000800ULL,
0x000000051400720bULL, 0x002fda0003f3d000ULL, 0x0000000000157806ULL, 0x000fc800008e0100ULL,
0x0000ffff15167812ULL, 0x000fda000782c0ffULL, 0x0000000000cc9947ULL, 0x004fea0003800000ULL,
0x000000051400720bULL, 0x000fe40003f34000ULL, 0x0000001405187209ULL, 0x000fca0007810000ULL,
0x8000001805157221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b15157820ULL, 0x000fe40000410000ULL,
0x0000000000057806ULL, 0x000fe400008e0100ULL, 0x000000030f00780cULL, 0x000fe40003f25270ULL,
0x0000ffff05177812ULL, 0x000fe200078e3cffULL, 0x0000001500157308ULL, 0x000e660000000800ULL,
0x0000001716ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff627807ULL, 0x000fc60001000000ULL,
0x0105801845009388ULL, 0x000fe80000000800ULL, 0x00001f4115057589ULL, 0x002e6400000e0000ULL,
0x8000001814162221ULL, 0x000fe20000010000ULL, 0x0000001506067220ULL, 0x000fe20000410000ULL,
0x00001f4015147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b16162820ULL, 0x000fc80000410000ULL,
0x00000016000c2308ULL, 0x000ee20000000800ULL, 0x000000051c1c7220ULL, 0x082fe20000410000ULL,
0x000000051d1d7220ULL, 0x080fe20000410000ULL, 0x0000000520207220ULL, 0x080fe20000410000ULL,
0x0000000521217220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000538387220ULL, 0x080fe20000410000ULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x0000000510107220ULL, 0x080fe20000410000ULL,
0x0000000511117220ULL, 0x000fe20000410000ULL, 0x000000141e1e7220ULL, 0x084fe20000410000ULL,
0x000000141f1f7220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x000000143a3a7220ULL, 0x080fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fe20000410000ULL, 0x000000ffff057224ULL, 0x000fc400078e0018ULL,
0x0000005b0c5b2220ULL, 0x008fce0000410000ULL, 0x0000000000080947ULL, 0x000fea0003800000ULL,
0x0106a86fff0075a7ULL, 0x000e640008000147ULL, 0x0000009c00808947ULL, 0x002fea0003800000ULL,
0x000000004444783bULL, 0x000e620000004200ULL, 0x0000991062637816ULL, 0x000fc600000000ffULL,
0x000000005a3c783bULL, 0x000ea20000004200ULL, 0x000000ff6300720cULL, 0x000fc60003f05270ULL,
0x000000005924783bULL, 0x000ee80000004200ULL, 0x000000005814783bULL, 0x000fe20000004200ULL,
0x0000010044187824ULL, 0x002fe200078e00ffULL, 0x00008880456b7816ULL, 0x040fe200000000ffULL,
0x0000010046627824ULL, 0x000fe200078e00ffULL, 0x00008880446a7816ULL, 0x000fe400000000ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011418ULL, 0x0000010045187824ULL, 0x040fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011462ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe20000011445ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fc40000011418ULL, 0x00b800005718783bULL, 0x0003e20000000200ULL,
0x00000018ff727819ULL, 0x000fe20000011444ULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00008880466e7816ULL, 0x000fe400000000ffULL, 0x0000000cff57723eULL, 0x002fe400000000ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x0000541057577816ULL, 0x000fc40000000057ULL, 0x00000018ff697819ULL, 0x000fe20000011446ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011447ULL,
0x00001f4157637589ULL, 0x000f2200000e0000ULL, 0x00000018ff677819ULL, 0x004fe2000001143cULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff667819ULL, 0x000fe2000001143dULL,
0x00001f4057627589ULL, 0x000ea200000e0000ULL, 0x000088803c7d7816ULL, 0x000fe400000000ffULL,
0x000088803d787816ULL, 0x000fc400000000ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000004500747306ULL, 0x0003e20000200c00ULL, 0x00000018ff647819ULL, 0x000fe4000001143fULL,
0x00000018ff617819ULL, 0x008fe40000011424ULL, 0x00000018ff657819ULL, 0x000fe4000001143eULL,
0x000088803e777816ULL, 0x000fe200000000ffULL, 0x0000004400737306ULL, 0x0005e20000200c00ULL,
0x000054106b457816ULL, 0x002fe2000000006cULL, 0x00000100476c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc40000011425ULL, 0x00000018ff5f7819ULL, 0x000fe20000011426ULL,
0x0000006318188232ULL, 0x090fe20000000000ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x000000631a1a8232ULL, 0x000fe20000000000ULL, 0x000054106a447816ULL, 0x004fe2000000006dULL,
0x0000006219198232ULL, 0x080fe20000000000ULL, 0x00008880476a7816ULL, 0x040fe200000000ffULL,
0x000000621b1b8232ULL, 0x000fe20000000000ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0001000047477824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc40000011427ULL,
0x00000018ff5c7819ULL, 0x000fe40000011414ULL, 0x00000044181c723cULL, 0x000fe2000000181cULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x00000075006d7306ULL, 0x000e620000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe40000011415ULL, 0x00000018ff597819ULL, 0x000fe40000011416ULL,
0x000001003c447824ULL, 0x040fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011417ULL,
0x000001003d457824ULL, 0x040fe200078e00ffULL, 0x0000006a006b7306ULL, 0x000fe20000200c00ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fc40000011445ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fce000001143dULL, 0x00000046006a7306ULL, 0x000ff00000200c00ULL,
0x0000006900697306ULL, 0x000ff00000200c00ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x0000004700477306ULL, 0x000ef00000200c00ULL, 0x0000003c00467306ULL, 0x0003f00000200c00ULL,
0x0000003d007b7306ULL, 0x0005e20000200c00ULL, 0x000054106e3c7816ULL, 0x002fce000000006dULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x000054106b3d7816ULL, 0x004fe4000000006cULL,
0x00008880246c7816ULL, 0x000fca00000000ffULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000003c1828723cULL, 0x000fee0000001828ULL, 0x00000100243c7824ULL, 0x040fe200078e00ffULL,
0x00005410473d7816ULL, 0x008fe20000000068ULL, 0x00000044007a7306ULL, 0x0003e20000200c00ULL,
0x0001000024247824ULL, 0x000fc400078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001143cULL,
0x000054106a3c7816ULL, 0x000fe40000000069ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000004500797306ULL, 0x0005e20000200c00ULL, 0x0000541073447816ULL, 0x002fe40000000072ULL,
0x00008880266a7816ULL, 0x000fe200000000ffULL, 0x0000003c182c723cULL, 0x000fe8000000182cULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000541074457816ULL, 0x004fc4000000006fULL,
0x00000001033c7824ULL, 0x000fe200078e020eULL, 0x000088803f6f7816ULL, 0x000fc600000000ffULL,
0x000000013c3d7836ULL, 0x040fe20000000000ULL, 0x000000441820723cULL, 0x000fe20000001820ULL,
0x000001003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000002400747306ULL, 0x0003e40000200c00ULL,
0x000000053d007c0cULL, 0x000fe4000bf26070ULL, 0x0000000a3c3d7c48ULL, 0x000fe2000ffe0000ULL,
0x000001003f457824ULL, 0x040fe400078e00ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000000013d3d7824ULL, 0x000fe200078e0a3cULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x000001003e447824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000000203d247807ULL, 0x002fe20000800000ULL, 0x00000100263c7824ULL, 0x040fe200078e00ffULL,
0x0000003f00737306ULL, 0x0003e20000200c00ULL, 0x00000018ff447819ULL, 0x000fe20000011444ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x000000240d247248ULL, 0x000fe40007fe0000ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000003e006e7306ULL, 0x0007e20000200c00ULL, 0x00000100253f7824ULL, 0x002fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc8000001143cULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x00008880253e7816ULL, 0x048fe200000000ffULL,
0x0001000025257824ULL, 0x000fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000003f00757306ULL, 0x0007f00000200c00ULL, 0x0000006600667306ULL, 0x000f220000200c00ULL,
0x00000001243f7824ULL, 0x008fc400078e0a0dULL, 0x0000010027247824ULL, 0x000fc600078e00ffULL,
0x0000003f5000720cULL, 0x080fe20003f26070ULL, 0x0000008000507824ULL, 0x000fe200078e0243ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x00000025006d7306ULL, 0x0005e20000200c00ULL,
0x0000003f4e00720cULL, 0x080fe20003f46070ULL, 0xfffffffa504e7836ULL, 0x000fe20000000000ULL,
0x0000003f4c00720cULL, 0x000fe40003f66070ULL, 0x00008880154c7816ULL, 0x000fc600000000ffULL,
0x0000002400477306ULL, 0x0007e20000200c00ULL, 0x0000541078257816ULL, 0x004fe20000000079ULL,
0x0000000f04797c24ULL, 0x020fc8000f8e02ffULL, 0x0000008079797824ULL, 0x000fe400078e00ffULL,
0x0000004400767306ULL, 0x0005e20000200c00ULL, 0x000054107d247816ULL, 0x008fce000000007aULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x0000888027447816ULL, 0x044fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x000000241830723cULL, 0x000fe80000001830ULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x0000541046247816ULL, 0x002fc40000000067ULL, 0x000054107b257816ULL, 0x010fe40000000066ULL,
0x0000004e79667210ULL, 0x000fe20007f9e0ffULL, 0x00000100154e7824ULL, 0x040fe200078e00ffULL,
0x0000004500727306ULL, 0x000e620000200c00ULL, 0x0001000015157824ULL, 0x000fe400078e00ffULL,
0x000000241834723cULL, 0x000fe20000001834ULL, 0x00000018ff677819ULL, 0x000fe2000001144eULL,
0xfffffffe504e7836ULL, 0x000fe20000000000ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x0000003e00687306ULL, 0x000fe40000200c00ULL, 0x0000004e794e7210ULL, 0x000fe40007fde0ffULL,
0x000054106f3d7816ULL, 0x002fc80000000072ULL, 0x00000026003e7306ULL, 0x0003f00000200c00ULL,
0x0000002700457306ULL, 0x0005e20000200c00ULL, 0x0000010014267824ULL, 0x002fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011426ULL, 0x0000003c00697306ULL, 0x0003e20000200c00ULL,
0x00b800005424783bULL, 0x0044ee0000000200ULL, 0x0000006500657306ULL, 0x000f220000200c00ULL,
0x00008880143c7816ULL, 0x042fe200000000ffULL, 0x0001000014147824ULL, 0x000fc400078e00ffULL,
0xfffffffc50547836ULL, 0x004fc60000000000ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000003c00467306ULL, 0x0003e20000200c00ULL, 0x0000005479547210ULL, 0x000fce0007fbe0ffULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x00005410773c7816ULL, 0x002fce0000000076ULL,
0x0000003c1838723cULL, 0x000fe20000001838ULL, 0x0000006000607306ULL, 0x000e6c0000200c00ULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x0000001066777c11ULL, 0x000fe2000f8840ffULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000006324248232ULL, 0x008fc40000000000ULL,
0x00000011663c7c11ULL, 0x000fe2000a0f443dULL, 0x0000006326268232ULL, 0x000fe20000000000ULL,
0x0000004277767210ULL, 0x000fe20007f9e0ffULL, 0x0000006225258232ULL, 0x080fe40000000000ULL,
0x00000014003d7306ULL, 0x0009e20000200c00ULL, 0x0000006227278232ULL, 0x000fe40000000000ULL,
0x000000ffff777224ULL, 0x000fe200020e063cULL, 0x00000050793c7210ULL, 0x000fe40007f9e0ffULL,
0x0000888016507816ULL, 0x000fc400000000ffULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x000054106e147816ULL, 0x010fe40000000065ULL, 0x0106b80aff6e79a7ULL, 0x000f2a0008500007ULL,
0x0000001500657306ULL, 0x0005f00000200c00ULL, 0x0000006100617306ULL, 0x000f620000200c00ULL,
0x0000541073157816ULL, 0x004fce0000000064ULL, 0x000000141810723cULL, 0x000fe20000001810ULL,
0x0000006a006a7306ULL, 0x000eac0000200c00ULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x0000001054737c11ULL, 0x000fe2000f8a40ffULL, 0x0000010016147824ULL, 0x000fe200078e00ffULL,
0x000054106d157816ULL, 0x002fe20000000060ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000001154547c11ULL, 0x000fe2000a8f4419ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0050ULL,
0x0000004273607210ULL, 0x000fe20007fbe0ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x000054106c187816ULL, 0x008fe2000000006bULL,
0x0000001a001a7306ULL, 0x000fe20000200c00ULL, 0x0000541068197816ULL, 0x000fe40000000075ULL,
0x0000888017507816ULL, 0x000fca00000000ffULL, 0x00000014001b7306ULL, 0x000a620000200c00ULL,
0x00000018241c723cULL, 0x000fee000000181cULL, 0x0000010017197824ULL, 0x040fe200078e00ffULL,
0x0000541074147816ULL, 0x020fe20000000061ULL, 0x000000ffff617224ULL, 0x000fe200028e0654ULL,
0x0000006fff0075a7ULL, 0x010ee200080a004cULL, 0x000054106a187816ULL, 0x004fe20000000069ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x000000ffff697224ULL, 0x000fe200030e06ffULL, 0x000000142420723cULL, 0x000fe20000001820ULL,
0x000000104e637c11ULL, 0x000fc4000f8c40ffULL, 0x000054101a1a7816ULL, 0x002fe4000000001bULL,
0x000000114e4e7c11ULL, 0x000fe2000b0f4469ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011419ULL, 0x0000541044197816ULL, 0x000fe40000000047ULL,
0x00000018ff147819ULL, 0x000fe40000011416ULL, 0x0000004263167210ULL, 0x000fe20007fde0ffULL,
0x0000005c005c7306ULL, 0x000f220000200c00ULL, 0x000054103e447816ULL, 0x004fe2000000005fULL,
0x000000182428723cULL, 0x000fe20000001828ULL, 0x0000541045457816ULL, 0x002fca000000005eULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x00000018ff187819ULL, 0x000fe20000011417ULL,
0x000000ffff177224ULL, 0x000fe200030e064eULL, 0x0000003f4800720cULL, 0x000fe20003fc6070ULL,
0x000000ffff3f7224ULL, 0x000fe200020e06ffULL, 0x00000044242c723cULL, 0x000fe2000000182cULL,
0x000054103d647816ULL, 0x010fe4000000005cULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000005aULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000000642434723cULL, 0x000fe20000001834ULL, 0x0000541046467816ULL, 0x004fcc0000000043ULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x000000103c437c11ULL, 0x000fc8000f8840ffULL,
0x000000113c3c7c11ULL, 0x000fe4000a0f443fULL, 0x0000004243427210ULL, 0x000fe20007f9e0ffULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000054104c477816ULL, 0x002fce0000000067ULL,
0x0000001500157306ULL, 0x000e620000200c00ULL, 0x000000462430723cULL, 0x000fee0000001830ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00005410501b7816ULL, 0x002fce0000000015ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000001a2438723cULL, 0x000fee0000001838ULL,
0x0000001400147306ULL, 0x000e700000200c00ULL, 0x0000001800197306ULL, 0x000ea20000200c00ULL,
0x0000541014147816ULL, 0x002fc40000000059ULL, 0x0000541019157816ULL, 0x004fce0000000058ULL,
0x000000142424723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000085947ULL, 0x008fde0003800000ULL, 0x0106b86fff0075a7ULL, 0x000e6400080a0147ULL,
0x0000008c0048d947ULL, 0x002fea0003800000ULL, 0x000000ffff437224ULL, 0x000fe200020e063cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000076497faeULL, 0x0003e8000c901c48ULL,
0x0000000060527faeULL, 0x0003e8000d101c48ULL, 0x0000000016517faeULL, 0x0003e8000d901c48ULL,
0x00000000424f7faeULL, 0x0003e2000f101c48ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a4bULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a80aff6e79a7ULL, 0x0004a20008500007ULL, 0x00000071ff0075a7ULL, 0x000ee4000802004eULL,
0x0000000000081947ULL, 0x00cfea0003800000ULL, 0x0106b071ff0075a7ULL, 0x000ea40008020147ULL,
0x0000008c00249947ULL, 0x004fea0003800000ULL, 0x000000005318783bULL, 0x000ea20000004200ULL,
0x000000065b067221ULL, 0x000fc60000010000ULL, 0x000000004d3c783bULL, 0x000fe80000004200ULL,
0x000000004b10783bULL, 0x0007e80000004200ULL, 0x000000005614783bULL, 0x002e680000004200ULL,
0x00001f41575f7589ULL, 0x000fe800000e0000ULL, 0x00001f40575c7589ULL, 0x0003e200000e0000ULL,
0x00000018ff527819ULL, 0x004fe20000011418ULL, 0x00000100184b7824ULL, 0x048fe200078e00ffULL,
0x00008880187d7816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011419ULL, 0x00000100194c7824ULL, 0x040fe200078e00ffULL,
0x0000888019747816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000010015577824ULL, 0x002fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001141aULL,
0x00000018ff647819ULL, 0x000fe2000001141bULL, 0x0000001800797306ULL, 0x0002a20000200c00ULL,
0x000088801a777816ULL, 0x000fe400000000ffULL, 0x000088801b6c7816ULL, 0x000fe400000000ffULL,
0x00000018ff627819ULL, 0x000fc4000001143cULL, 0x00000018ff5a7819ULL, 0x000fe2000001143dULL,
0x0000001900537306ULL, 0x0007e20000200c00ULL, 0x000001001b187824ULL, 0x042fe200078e00ffULL,
0x000088803c6d7816ULL, 0x040fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088803d667816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000004b00767306ULL, 0x0003e20000200c00ULL, 0x000001003c197824ULL, 0x048fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x0000541079527816ULL, 0x004fc40000000052ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001800757306ULL, 0x0005e20000200c00ULL, 0x000001001a4b7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe4000001143eULL, 0x00000018ff4b7819ULL, 0x000fe4000001144bULL,
0x0000001900687306ULL, 0x0003e20000200c00ULL, 0x000001003d187824ULL, 0x044fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000088803e657816ULL, 0x000fc400000000ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001a00737306ULL, 0x000fe20000200c00ULL, 0x000001003e197824ULL, 0x042fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011410ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018006b7306ULL, 0x0003e20000200c00ULL, 0x0000888010547816ULL, 0x000fc400000000ffULL,
0x00000018ff477819ULL, 0x000fe40000011412ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000001900607306ULL, 0x0005e20000200c00ULL,
0x000001003f187824ULL, 0x002fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe40000011411ULL,
0x0000888011507816ULL, 0x000fe400000000ffULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x0000001b00717306ULL, 0x000fe20000200c00ULL, 0x0000010010197824ULL, 0x044fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011414ULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001143fULL, 0x00000018ff4f7819ULL, 0x000fe40000011419ULL,
0x0000001800637306ULL, 0x0003e20000200c00ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x000088803f567816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fc40000011413ULL, 0x00000018ff447819ULL, 0x000fe20000011415ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x0000010011187824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000888015407816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fe40000011418ULL,
0x00b800004a18783bULL, 0x000e620000000200ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff437819ULL, 0x000fe40000011416ULL,
0x00000018ff427819ULL, 0x000fe40000011417ULL, 0x0000541053537816ULL, 0x004fe20000000072ULL,
0x0000004b00707306ULL, 0x0004e20000200c00ULL, 0x00000018ff577819ULL, 0x000fce0000011457ULL,
0x0000006c006c7306ULL, 0x000f220000200c00ULL, 0x00008880134b7816ULL, 0x004fce00000000ffULL,
0x0000006a006a7306ULL, 0x000eb00000200c00ULL, 0x0000006400647306ULL, 0x000f620000200c00ULL,
0x0000005f18188232ULL, 0x002fce0000000000ULL, 0x0000003c00697306ULL, 0x0003e20000200c00ULL,
0x0000005f1a1a8232ULL, 0x000fe40000000000ULL, 0x0000005c19198232ULL, 0x080fe40000000000ULL,
0x0000005c1b1b8232ULL, 0x000fc60000000000ULL, 0x0000003d00677306ULL, 0x0005e20000200c00ULL,
0x00000100123c7824ULL, 0x002fc600078e00ffULL, 0x000000521820723cULL, 0x000fe40000001820ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x00008880123d7816ULL, 0x044fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x0000541077527816ULL, 0x008fe40000000070ULL, 0x000054106c537816ULL, 0x010fe40000000075ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000007400747306ULL, 0x000fe80000200c00ULL,
0x000000521828723cULL, 0x000fe80000001828ULL, 0x0000004c007b7306ULL, 0x000fe60000200c00ULL,
0x0000541073527816ULL, 0x000fc4000000006aULL, 0x0000541071537816ULL, 0x020fc60000000064ULL,
0x0000006d006d7306ULL, 0x000fe80000200c00ULL, 0x00000052182c723cULL, 0x000fe8000000182cULL,
0x0000006600667306ULL, 0x000e660000200c00ULL, 0x0001000015527824ULL, 0x000fca00078e00ffULL,
0x0000003e005e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000541066157816ULL, 0x002fca000000006bULL, 0x00000010004c7306ULL, 0x0003f00000200c00ULL,
0x0000003c003e7306ULL, 0x0005e20000200c00ULL, 0x0000010013107824ULL, 0x042fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000012004a7306ULL, 0x0003e20000200c00ULL, 0x00008880143c7816ULL, 0x004fe400000000ffULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x0000010014127824ULL, 0x042fe400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011412ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000011004d7306ULL, 0x0003f00000200c00ULL, 0x00000010004e7306ULL, 0x0007e20000200c00ULL,
0x0000541074117816ULL, 0x002fce000000007bULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054107d107816ULL, 0x008fce0000000076ULL, 0x0000001400647306ULL, 0x0007e20000200c00ULL,
0x00000010181c723cULL, 0x000fee000000181cULL, 0x0000003f00617306ULL, 0x000fe20000200c00ULL,
0x000054106d147816ULL, 0x008fce0000000068ULL, 0x00000013003f7306ULL, 0x0007e20000200c00ULL,
0x000000141830723cULL, 0x000fee0000001830ULL, 0x0000888016157816ULL, 0x000fe200000000ffULL,
0x00b800005510783bULL, 0x0087220000000200ULL, 0x0000005600567306ULL, 0x000f620000200c00ULL,
0x0000541069147816ULL, 0x004fc40000000062ULL, 0x000000ffff627224ULL, 0x000fe200078e0015ULL,
0x0000541067157816ULL, 0x002fc8000000005aULL, 0x0000005900597306ULL, 0x000e660000200c00ULL,
0x000000141834723cULL, 0x000fe20000001834ULL, 0x0000541056537816ULL, 0x020fc80000000063ULL,
0x0000005800587306ULL, 0x000ea40000200c00ULL, 0x0000010016157824ULL, 0x040fe400078e00ffULL,
0x0001000016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011415ULL,
0x0000006500657306ULL, 0x000f620000200c00ULL, 0x000054105e147816ULL, 0x002fe40000000059ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000541061157816ULL, 0x004fc60000000058ULL,
0x0000005200557306ULL, 0x008be80000200c00ULL, 0x000000141824723cULL, 0x000fe20000001824ULL,
0x0000005f10108232ULL, 0x010fc60000000000ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x0000541065527816ULL, 0x020fe20000000060ULL, 0x0000005f12128232ULL, 0x000fe40000000000ULL,
0x0000005c11118232ULL, 0x080fe40000000000ULL, 0x0000005c13138232ULL, 0x000fe40000000000ULL,
0x0000004f004f7306ULL, 0x000e620000200c00ULL, 0x000000521838723cULL, 0x000fee0000001838ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000010017197824ULL, 0x040fe200078e00ffULL,
0x0000888017527816ULL, 0x040fe200000000ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000541054147816ULL, 0x002fca000000004fULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000541050157816ULL, 0x004fce0000000051ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x00000014101c723cULL, 0x000fee000000181cULL,
0x00000062005a7306ULL, 0x000fe20000200c00ULL, 0x000054103d147816ULL, 0x002fe4000000003eULL,
0x000054104b157816ULL, 0x004fca000000004eULL, 0x0000005600537306ULL, 0x000e640000200c00ULL,
0x000000141028723cULL, 0x000fec0000001828ULL, 0x0000005200187306ULL, 0x000fe20000200c00ULL,
0x000054105a147816ULL, 0x002fce0000000053ULL, 0x0000001900197306ULL, 0x000e700000200c00ULL,
0x0000004900497306ULL, 0x000ea20000200c00ULL, 0x0000541018157816ULL, 0x002fce0000000019ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000000141038723cULL, 0x000fe20000001838ULL,
0x000054104c4c7816ULL, 0x004fcc0000000049ULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0106b80aff1479a7ULL, 0x0006e20008500007ULL, 0x000054104d4d7816ULL, 0x002fcc0000000048ULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x0106a00affff79a7ULL, 0x0007e20008500007ULL,
0x0000004c1020723cULL, 0x000fe20000001820ULL, 0x000054104a3e7816ULL, 0x004fca0000000047ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x000054103f3f7816ULL, 0x002fce0000000046ULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x0000003e102c723cULL, 0x000fe2000000182cULL,
0x0000541064547816ULL, 0x004fcc0000000045ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541055557816ULL, 0x002fce0000000044ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000000541034723cULL, 0x000fee0000001834ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce0000000041ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00005410403d7816ULL, 0x002fce0000000057ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000003c1030723cULL, 0x000fee0000001830ULL,
0x0000001600167306ULL, 0x000e700000200c00ULL, 0x0000001700177306ULL, 0x000ea20000200c00ULL,
0x0000541016167816ULL, 0x002fc40000000043ULL, 0x0000541017177816ULL, 0x004fce0000000042ULL,
0x000000161010723cULL, 0x008fde0000001824ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000001030e7824ULL, 0x000fca00078e020eULL, 0x000000050e007c0cULL, 0x000fda000bf06070ULL,
0xffffff5800688947ULL, 0x00efea000383ffffULL, 0x0000000000077919ULL, 0x000ea20000002500ULL,
0x000000ffff3d7224ULL, 0x000fe400078e0029ULL, 0x000000ffff297224ULL, 0x000fe400078e0021ULL,
0x000000ffff157224ULL, 0x008fe200078e001dULL, 0x0000000507007c0cULL, 0x004fda000bf06070ULL,
0x0000000000dc0947ULL, 0x000fea0003800000ULL, 0x0180000006007836ULL, 0x000fe20000000000ULL,
0x000000d000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff3f7224ULL, 0x000fe200078e0006ULL, 0x0000b8d000087802ULL, 0x000fce0000000f00ULL,
0x00000084000c7944ULL, 0x002fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0004ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000600097308ULL, 0x000ea40000001000ULL,
0xbf80000009007423ULL, 0x004fc80000000006ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000009007223ULL, 0x000fce0000000009ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009400ff087b82ULL, 0x000ea40000000a00ULL, 0x0000000808097981ULL, 0x004ea2000c1e9900ULL,
0x00000000000b7919ULL, 0x000ee40000000000ULL, 0x00000002ff177819ULL, 0x008fe4000001160bULL,
0x000000080b0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000009007220ULL, 0x004fca0000410000ULL,
0x00001f1700027589ULL, 0x000ea800000e0000ULL, 0x00001f0b00047589ULL, 0x000ee200000e0000ULL,
0x0000001c021c7220ULL, 0x044fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002802287220ULL, 0x040fe20000410000ULL, 0x0000003d023d7220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x040fe20000410000ULL,
0x0000003002307220ULL, 0x040fe20000410000ULL, 0x0000003102317220ULL, 0x040fe20000410000ULL,
0x0000003402347220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000003802387220ULL, 0x040fe20000410000ULL, 0x0000003902397220ULL, 0x040fe20000410000ULL,
0x0000001002107220ULL, 0x040fe20000410000ULL, 0x0000001102117220ULL, 0x000fe20000410000ULL,
0x0000001e041e7220ULL, 0x048fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001204127220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x000fce0000410000ULL,
0x00000000001b7919ULL, 0x000ea20000000000ULL, 0x0000002c2d2c723eULL, 0x000fe400000000ffULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x000000343518723eULL, 0x000fe400000000ffULL, 0x000000383938723eULL, 0x000fe400000000ffULL,
0x0000001e1f1f723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fc400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x000000010300780cULL, 0x000fe40003f05270ULL, 0x0000003a3b3a723eULL, 0x000fe400000000ffULL,
0x000054101f1e7816ULL, 0x140fe40000000022ULL, 0x000076321f1f7816ULL, 0x000fc40000000022ULL,
0x000000021b007812ULL, 0x044fe400078ec0ffULL, 0x00000002ff197819ULL, 0x000fe4000001161bULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x00000004000a7811ULL, 0x040fe400078ff8ffULL,
0x000000081b277811ULL, 0x000fe400078ff0ffULL, 0x0000000200047811ULL, 0x000fc400078ff8ffULL,
0x00000006000e7811ULL, 0x000fe400078ff8ffULL, 0x0000000702007812ULL, 0x000fe400078e7819ULL,
0x000000070a0c7812ULL, 0x000fe400078e7819ULL, 0x000000070a0a7812ULL, 0x000fe200078e7827ULL,
0x0000000819097824ULL, 0x040fe200078e0200ULL, 0x0000000702027812ULL, 0x000fe200078e7827ULL,
0x0000000819177824ULL, 0x000fe200078e020cULL, 0x000000070f007c11ULL, 0x000fe2000f8e58ffULL,
0x0000000827257824ULL, 0x000fe200078e020aULL, 0x0000000704087812ULL, 0x000fe200078e7819ULL,
0x000000081b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7827ULL,
0x00000008271d7824ULL, 0x000fe200078e0202ULL, 0x000000070e147812ULL, 0x000fe200078e7819ULL,
0x0000a00000027836ULL, 0x000fe20000000000ULL, 0x000000080a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000008190b7824ULL, 0x000fe200078e0208ULL, 0x000000202908723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x000000070e0e7812ULL, 0x000fe200078e7827ULL,
0x0000000827217824ULL, 0x000fe200078e0204ULL, 0x0000001c1504723eULL, 0x000fe200000000ffULL,
0x000000100b157824ULL, 0x000fe200078e0202ULL, 0x00000010111c723eULL, 0x000fe200000000ffULL,
0x00000001090b7824ULL, 0x000fe200078e020aULL, 0x000000283d09723eULL, 0x000fe200000000ffULL,
0x000000010a157824ULL, 0x000fe200078e0215ULL, 0x0000541004287816ULL, 0x040fe20000000008ULL,
0x0000000819197824ULL, 0x000fe200078e0214ULL, 0x0000763204297816ULL, 0x000fe20000000008ULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x0000541009087816ULL, 0x000fe2000000002cULL,
0x0000001019197824ULL, 0x000fe200078e0202ULL, 0x0000763209097816ULL, 0x000fe2000000002cULL,
0x000000280b007388ULL, 0x000fe20000000a00ULL, 0x000000101d1d7824ULL, 0x000fc400078e0202ULL,
0x000000010a177824ULL, 0x040fe200078e0217ULL, 0x0000000815007388ULL, 0x0005e20000000a00ULL,
0x0000000827277824ULL, 0x000fe400078e020eULL, 0x000000010a0c7824ULL, 0x040fe200078e0219ULL,
0x000000363719723eULL, 0x000fe200000000ffULL, 0x0000001021217824ULL, 0x100fe400078e0202ULL,
0x000000010a0e7824ULL, 0x000fe200078e021dULL, 0x00000012131d723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x000fc400078e0202ULL, 0x0000001027277824ULL, 0x000fe200078e0202ULL,
0x0000541030087816ULL, 0x104fe20000000018ULL, 0x000000010a217824ULL, 0x000fe200078e0221ULL,
0x0000763230097816ULL, 0x000fe20000000018ULL, 0x000000010a257824ULL, 0x040fe200078e0225ULL,
0x0000002e2f15723eULL, 0x000fe200000000ffULL, 0x000000010a277824ULL, 0x000fe200078e0227ULL,
0x0000541032187816ULL, 0x000fe20000000019ULL, 0x0000000817007388ULL, 0x0005e20000000a00ULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fc40000000015ULL,
0x0000763232197816ULL, 0x000fe40000000019ULL, 0x0000541038087816ULL, 0x144fe4000000001cULL,
0x0000763238097816ULL, 0x000fe4000000001cULL, 0x000054103a1c7816ULL, 0x140fe4000000001dULL,
0x000076323a1d7816ULL, 0x000fe2000000001dULL, 0x000000080c007388ULL, 0x0005e80000000a00ULL,
0x0000001e0e007388ULL, 0x0005e80000000a00ULL, 0x0000001421007388ULL, 0x0005e80000000a00ULL,
0x0000001825007388ULL, 0x0005e80000000a00ULL, 0x0000001c27007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002000f48947ULL, 0x000fea0003800000ULL,
0x00000000001a7919ULL, 0x000ee20000002700ULL, 0x00008400ff0c7b82ULL, 0x004ee20000000800ULL,
0x000000101b197824ULL, 0x000fe200078e0200ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x00000000001d7919ULL, 0x000ee20000002600ULL, 0x000000201b217836ULL, 0x040fe40000000000ULL,
0x000000ff1b00720cULL, 0x000fe20000725670ULL, 0x00a0000019087984ULL, 0x0004a20000000c00ULL,
0x00009200ff157b82ULL, 0x000f260000000800ULL, 0x00a2000019107984ULL, 0x0004a20000000c00ULL,
0x00000000001f7919ULL, 0x000f680000008800ULL, 0x00009800ff167b82ULL, 0x000ea20000000a00ULL,
0x0000000c1a1a7224ULL, 0x008fc400078e021dULL, 0x0000000c030c7224ULL, 0x000fe400078e02ffULL,
0x000000031a047224ULL, 0x000fe400078e02ffULL, 0x000000150c0e7224ULL, 0x010fe200078e02ffULL,
0x00000400000c7802ULL, 0x000fe20000000f00ULL, 0x0000000104187824ULL, 0x000fc600078e0207ULL,
0x00000fff0e077811ULL, 0x000fe400078e40ffULL, 0x000006541f0c7816ULL, 0x020fe4000000000cULL,
0x0000001807157211ULL, 0x000fca00078fa0ffULL, 0x0000100015147825ULL, 0x006fc800078e0016ULL,
0x000004000f147825ULL, 0x000fc800078e0014ULL, 0x0000001021207825ULL, 0x000fc800078e0014ULL,
0x000000101b1e7825ULL, 0x000fe200078e0014ULL, 0x01ffffff0e157812ULL, 0x000fe200078ec0ffULL,
0x0000000000380947ULL, 0x000fec0003800000ULL, 0x00009800ff1c7b82ULL, 0x000e620000000a00ULL,
0x0000000118237824ULL, 0x000fe200078e0215ULL, 0x00000001ff147819ULL, 0x000fe2000001161bULL,
0x000000101b0e7824ULL, 0x000fc600078e00ffULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x0000008018187825ULL, 0x002fc800078e001cULL, 0x00000080231c7825ULL, 0x000fe200078e001cULL,
0x000000700e237812ULL, 0x000fc800078ec0ffULL, 0x0000001814187210ULL, 0x140fe40007b5e023ULL,
0x0000001c141c7210ULL, 0x000fe40007d9e023ULL, 0x00000019ff197210ULL, 0x000fe400017e64ffULL,
0x0000001dff1d7210ULL, 0x000fc600027ea4ffULL, 0x0000000518007986ULL, 0x0003e8000c101908ULL,
0x000000061c007986ULL, 0x0003e4000c101908ULL, 0x000000081e007986ULL, 0x0005e8000c101d08ULL,
0x0000001020007986ULL, 0x0005e2000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000004c1947ULL, 0x000fea0003800000ULL, 0x00009600ff087b82ULL, 0x004ea20000000a00ULL,
0xffffffff03057836ULL, 0x002fe40000000000ULL, 0x000000041a087825ULL, 0x004fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x0003ec0000008000ULL, 0x0000000000007992ULL, 0x002fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000005080879a8ULL, 0x000ea800099ee1c8ULL, 0x00000000ff00798fULL, 0x004fe20002000000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fc40000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x000000050800720cULL, 0x000fc80003f25270ULL,
0x00000001ff067807ULL, 0x000fca0000800000ULL, 0x00000006ff007988ULL, 0x0003e80008000004ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000000c057984ULL, 0x002e640000000000ULL, 0x000000ff0500720cULL, 0x002fda0003f25270ULL,
0x0000001c00e09947ULL, 0x000fea0003800000ULL, 0x0000000c00300947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000000000d88947ULL, 0x000fea0003800000ULL,
0x000000101b057824ULL, 0x000fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe2000001161bULL,
0x00000001040b7836ULL, 0x044fe40000000000ULL, 0x0000008004087825ULL, 0x100fe200078e0016ULL,
0x0000007005117812ULL, 0x000fe400078ec0ffULL, 0x0000000c06107812ULL, 0x000fe200078ec0ffULL,
0x000000800b0a7825ULL, 0x000fc600078e0016ULL, 0x0000000810087210ULL, 0x140fe4000791e011ULL,
0x0000000a100a7210ULL, 0x000fe40007b5e011ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000808057981ULL, 0x000368000c1e1900ULL,
0x000000080a067981ULL, 0x000362000c1e1900ULL, 0x000000020300780cULL, 0x000fda0003f05270ULL,
0x00000000009c8947ULL, 0x002fea0003800000ULL, 0x0000000204097836ULL, 0x000fc80000000000ULL,
0x0000008009087825ULL, 0x000fc600078e0016ULL, 0x00000008100a7210ULL, 0x000fc8000791e011ULL,
0x00000009ff0b7210ULL, 0x000fca00007e24ffULL, 0x000000080a0a7981ULL, 0x000362000c1e1900ULL,
0x000000040300780cULL, 0x000fda0003f06070ULL, 0x0000000000808947ULL, 0x002fea0003800000ULL,
0x0000000304097836ULL, 0x000fc80000000000ULL, 0x0000008009087825ULL, 0x000fc600078e0016ULL,
0x0000000810087210ULL, 0x000fc8000791e011ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000008080e7981ULL, 0x000362000c1e1900ULL, 0x000000040300780cULL, 0x000fda0003f05270ULL,
0x0000000000648947ULL, 0x002fea0003800000ULL, 0x0000000404097836ULL, 0x000fc80000000000ULL,
0x0000008009087825ULL, 0x000fc600078e0016ULL, 0x0000000810087210ULL, 0x000fc8000791e011ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000808127981ULL, 0x000362000c1e1900ULL,
0x000000060300780cULL, 0x000fda0003f06070ULL, 0x0000000000488947ULL, 0x002fea0003800000ULL,
0x0000000504097836ULL, 0x000fc80000000000ULL, 0x0000008009087825ULL, 0x000fc600078e0016ULL,
0x0000000810087210ULL, 0x000fc8000791e011ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000808147981ULL, 0x000362000c1e1900ULL, 0x000000060300780cULL, 0x000fda0003f05270ULL,
0x00000000002c8947ULL, 0x002fea0003800000ULL, 0x000000080300780cULL, 0x000fe20003f06070ULL,
0x0000000604097836ULL, 0x000fc80000000000ULL, 0x0000008009087825ULL, 0x000fc600078e0016ULL,
0x0000000810087210ULL, 0x000fca0007a3e011ULL, 0x00000007040b0836ULL, 0x000fe20000000000ULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x000000800b160825ULL, 0x000fc600078e0016ULL,
0x0000001610100210ULL, 0x000fc60007c7e011ULL, 0x0000000808167981ULL, 0x000362000c1e1900ULL,
0x00000017ff110210ULL, 0x000fca0001fe84ffULL, 0x0000000810180981ULL, 0x000368000c1e1900ULL,
0x0000000703087836ULL, 0x006fca0000000000ULL, 0x00000003ff137819ULL, 0x000fc80000011608ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000000800248947ULL, 0x000fea0003800000ULL,
0x00009800ff087b82ULL, 0x000e620000000a00ULL, 0x000000ffff177224ULL, 0x000fe200078e0004ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1a7224ULL, 0x020fe200078e0005ULL,
0x0000003f00057c82ULL, 0x000fcc0008000000ULL, 0x0000000403007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000513007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400f41947ULL, 0x022fee0003800000ULL, 0x0000000804067890ULL, 0x000fe2000fffe03fULL,
0x0000001a05057209ULL, 0x000fe20007810000ULL, 0x0000000104077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff197819ULL, 0x000fe2000001161bULL, 0x0000000817117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x002fe200078e0008ULL,
0x0000000c19197812ULL, 0x000fc800078ec0ffULL, 0x0000001019107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000008101a7981ULL, 0x000368000c1e1900ULL,
0x0000000400b42947ULL, 0x000fea0003800000ULL, 0x0000000904067890ULL, 0x000fe2000fffe03fULL,
0x0000000605057209ULL, 0x000fe20007810000ULL, 0x0000000204077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b067824ULL, 0x000fe200078e00ffULL,
0x00000001ff197819ULL, 0x000fe2000001161bULL, 0x0000000917117836ULL, 0x002fc60000000000ULL,
0x00000070060b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c19197812ULL, 0x000fc800078ec0ffULL, 0x0000001019107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810067981ULL, 0x000368000c1e1900ULL,
0x0000000400742947ULL, 0x000fea0003800000ULL, 0x0000000a04067890ULL, 0x000fe2000fffe03fULL,
0x0000000a05057209ULL, 0x000fe20007810000ULL, 0x0000000304077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff107819ULL, 0x002fe2000001161bULL, 0x0000000a170b7836ULL, 0x000fc60000000000ULL,
0x000000700a117812ULL, 0x000fe200078ec0ffULL, 0x000000800b0a7825ULL, 0x000fe200078e0008ULL,
0x0000000c10107812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000080a0a7981ULL, 0x000368000c1e1900ULL,
0x0000000400342947ULL, 0x000fea0003800000ULL, 0x0000000b04067890ULL, 0x000fe2000fffe03fULL,
0x0000000e05057209ULL, 0x000fe20007810000ULL, 0x0000000404077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe2000001161bULL, 0x0000000b17117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000100e107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x00000008100e7981ULL, 0x000368000c1e1900ULL,
0x0000000000f42947ULL, 0x000fea0003800000ULL, 0x0000000c04067890ULL, 0x000fe2000fffe03fULL,
0x0000001205057209ULL, 0x000fe20007810000ULL, 0x0000000504077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe2000001161bULL, 0x0000000c17117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000001012107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810127981ULL, 0x000368000c1e1900ULL,
0x0000000000b42947ULL, 0x000fea0003800000ULL, 0x0000000d04067890ULL, 0x000fe2000fffe03fULL,
0x0000001405057209ULL, 0x000fe20007810000ULL, 0x0000000604077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe2000001161bULL, 0x0000000d17117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c14147812ULL, 0x000fc800078ec0ffULL, 0x0000001014107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810147981ULL, 0x000368000c1e1900ULL,
0x0000000000742947ULL, 0x000fea0003800000ULL, 0x0000000e04067890ULL, 0x000fe2000fffe03fULL,
0x0000001605057209ULL, 0x000fe20007810000ULL, 0x0000000704077890ULL, 0x000fc8000fffe03fULL,
0x0000000603007c0cULL, 0x040fe4000bf23070ULL, 0x0000000703007c0cULL, 0x000fd6000bf43070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff167819ULL, 0x000fe2000001161bULL, 0x0000000e17117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c16167812ULL, 0x000fc800078ec0ffULL, 0x0000001016107210ULL, 0x000fc80007b3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe64ffULL, 0x0000000810167981ULL, 0x000368000c1e1900ULL,
0x0000000000342947ULL, 0x000fea0003800000ULL, 0x0000000f04067890ULL, 0x000fe2000fffe03fULL,
0x0000001805057209ULL, 0x000fca0007810000ULL, 0x0000000603007c0cULL, 0x000fda000bf23070ULL,
0x0000000000241947ULL, 0x000fea0003800000ULL, 0x000000101b0b7824ULL, 0x002fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe2000001161bULL, 0x0000000f17117836ULL, 0x000fc60000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x0000000c18187812ULL, 0x000fc800078ec0ffULL, 0x0000001018107210ULL, 0x000fc80007a3e00bULL,
0x00000011ff117210ULL, 0x000fca0000fe44ffULL, 0x0000000810187981ULL, 0x000368000c1e1900ULL,
0x0000000804047890ULL, 0x000fe2000fffe03fULL, 0x0000000817177836ULL, 0x000fe20000000000ULL,
0xfffffff400f08947ULL, 0x000ff4000383ffffULL, 0x00000000001b7919ULL, 0x000ea40000000000ULL,
0x000000101b067824ULL, 0x024fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fc8000001161bULL,
0x0000007006097812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ec0ffULL,
0x0000000c08087210ULL, 0x000fca0007ffe009ULL, 0x0000000508007388ULL, 0x0003e40000000800ULL,
0x00009800ff107b82ULL, 0x004ea20000000a00ULL, 0x0000000407477211ULL, 0x000fe200078fa0ffULL,
0x000004000f0e7824ULL, 0x000fe200078e00ffULL, 0x000000071b00780cULL, 0x040fe20003f04070ULL,
0x000000101b1d7824ULL, 0x040fe200078e00ffULL, 0x00000016ff1a7819ULL, 0x000fe2000001160fULL,
0x0000000104157824ULL, 0x000fe200078e0215ULL, 0x00000001ff1e7819ULL, 0x000fe2000001161bULL,
0x000000201b097836ULL, 0x000fe20000000000ULL, 0x000000701d1d7812ULL, 0x000fe200078ec0ffULL,
0x000010000f1c7824ULL, 0x000fe200078e020cULL, 0x0000000c1e1e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000101b057824ULL, 0x002fe200078e021cULL, 0x0000000c1e1f7210ULL, 0x000fe20007ffe01dULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000001000f128824ULL, 0x140fe200078e020cULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000001000f148824ULL, 0x000fe200078e020cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000101b138824ULL, 0x040fe200078e0212ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000101b178824ULL, 0x000fe200078e0214ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000100047067825ULL, 0x004fe200078e0010ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000080150a8825ULL, 0x100fe200078e0010ULL,
0x0000000e06067210ULL, 0x000fe40007f3e0ffULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000008004108825ULL, 0x000fe200078e0010ULL,
0x0000000000367805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000107077824ULL, 0x000fe200008e061aULL,
0x000000ff0300720cULL, 0x000fe20003f25270ULL, 0x000000101b0a8825ULL, 0x000fe200078e000aULL,
0x000000001f1f7984ULL, 0x000e620000000800ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000001009087825ULL, 0x000fe200078e0006ULL,
0x0000000000207805ULL, 0x000fc6000001ff00ULL, 0x000000101b067825ULL, 0x000fc800078e0006ULL,
0x000000101b108825ULL, 0x000fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006057faeULL, 0x0005e8000b901c48ULL, 0x0038000008057faeULL, 0x0005e8000b901c48ULL,
0x045800000a138faeULL, 0x0005e8000b901c48ULL, 0x0418000010178faeULL, 0x0005e8000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000008005c9947ULL, 0x000fea0003800000ULL,
0x00009800ff187b82ULL, 0x000ee20000000a00ULL, 0x00000003ff057819ULL, 0x104fe2000001161bULL,
0x0000000115457836ULL, 0x000fe20000000000ULL, 0xfffffff8ff067812ULL, 0x000fe200078ee21bULL,
0x0000000147477836ULL, 0x000fe20000000000ULL, 0x0000000305057812ULL, 0x000fe200078ec0ffULL,
0x0000000104497836ULL, 0x000fe20000000000ULL, 0x00000002ff487819ULL, 0x000fe2000001161bULL,
0x0000000806087836ULL, 0x040fe20000000000ULL, 0x0000000405077812ULL, 0x000fe200078efcffULL,
0x0000000806427824ULL, 0x000fe200078e00ffULL, 0x0000000705417812ULL, 0x000fe200078e7806ULL,
0x0000000808447824ULL, 0x000fe200078e00ffULL, 0x0000000705437812ULL, 0x000fe200078e7808ULL,
0x00000001ff467424ULL, 0x000fe200078e00ffULL, 0x0000000707057812ULL, 0x000fe200078e7806ULL,
0x000000ffff407224ULL, 0x000fe200078e00ffULL, 0x0000000707077812ULL, 0x000fe200078e7808ULL,
0x000001000f4c7824ULL, 0x000fe200078e020cULL, 0x0000004241417212ULL, 0x000fe200078efcffULL,
0x00000008484a7836ULL, 0x000fe20000000000ULL, 0x0000004443437212ULL, 0x000fc400078efcffULL,
0x0000004205427212ULL, 0x000fe400078efcffULL, 0x0000004407447212ULL, 0x008fce00078efcffULL,
0x000000034600720cULL, 0x000fda0003f06070ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x0000100047047825ULL, 0x000fe200078e0018ULL, 0x000000071b00780cULL, 0x040fe40003f24070ULL,
0x0000000146137812ULL, 0x040fe200078ec0ffULL, 0x000000201b157836ULL, 0x000fe20000000000ULL,
0x0000000e040a7210ULL, 0x000fe20007f1e0ffULL, 0x0000080046047824ULL, 0x000fc800078e00ffULL,
0x00000001050b7824ULL, 0x000fe200000e061aULL, 0x0000080004097812ULL, 0x000fc600078ec0ffULL,
0x000001000f4c9824ULL, 0x000fe400078e020cULL, 0x000000011c087824ULL, 0x000fe400078e0209ULL,
0x0000008045069825ULL, 0x000fc800078e0018ULL, 0x0000008049049825ULL, 0x000fc800078e0018ULL,
0x0000008013109824ULL, 0x000fe400078e024cULL, 0x000000101b117824ULL, 0x000fe400078e0208ULL,
0x0000008013129824ULL, 0x000fe400078e024cULL, 0x0000001015087825ULL, 0x000fc800078e000aULL,
0x000000101b0a7825ULL, 0x000fc800078e000aULL, 0x000000101b069825ULL, 0x040fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a117faeULL, 0x0005e6000b901c48ULL,
0x000000101b139824ULL, 0x040fe200078e0210ULL, 0x0038000008117faeULL, 0x0005e2000b901c48ULL,
0x000000101b049825ULL, 0x000fc600078e0004ULL, 0x0458000006139faeULL, 0x0005e2000b901c48ULL,
0x000000101b159824ULL, 0x000fca00078e0212ULL, 0x0418000004159faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff46047836ULL, 0x044fe20000000000ULL,
0x000000034600720cULL, 0x040fe20003f06070ULL, 0x0000000146467836ULL, 0x000fe40000000000ULL,
0x0000008004057824ULL, 0x040fe400078e00ffULL, 0x0000080004047824ULL, 0x000fe400078e00ffULL,
0x0000000145457836ULL, 0x000fe20000000000ULL, 0x0000008005057812ULL, 0x000fe200078ec0ffULL,
0x0000000147477836ULL, 0x000fc40000000000ULL, 0x0000000149497836ULL, 0x000fe20000000000ULL,
0x0000004c1d057210ULL, 0x000fca0007ffe005ULL, 0x000000011e4b7824ULL, 0x000fe200078e0205ULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180004b127984ULL, 0x000ea20000000800ULL, 0x000001801c147810ULL, 0x000fc60007ffe005ULL,
0x004580004b4e7984ULL, 0x000fe40000000800ULL, 0x0000001041047824ULL, 0x100fe400078e0214ULL,
0x0000001042087824ULL, 0x100fe400078e0214ULL, 0x0000001043107824ULL, 0x100fe400078e0214ULL,
0x0000001044147824ULL, 0x000fe200078e0214ULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x000000121f157221ULL, 0x006fc60000010100ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x3fb8aa3b15517820ULL, 0x000fc60000410000ULL,
0x000000001414783bULL, 0x000ea60000000200ULL, 0x0000005100517308ULL, 0x000f620000000800ULL,
0x30000004ff4b7230ULL, 0x008fe40000004100ULL, 0x20000005ff4d7230ULL, 0x000fe40000004100ULL,
0x20000007ff4f7230ULL, 0x000fe40000004100ULL, 0x30000007ff507230ULL, 0x000fc40000004100ULL,
0x30000009ff527230ULL, 0x010fe40000004100ULL, 0x2000000bff537230ULL, 0x000fe40000004100ULL,
0x0000004e515d7220ULL, 0x020fe20000410000ULL, 0x20000004ff4e7230ULL, 0x000fe40000004100ULL,
0x30000005ff047230ULL, 0x000fe40000004100ULL, 0x0000003f5d3f7221ULL, 0x000fe20000010000ULL,
0x00001f485d5c7589ULL, 0x000ee200000e0000ULL, 0x20000009ff517230ULL, 0x000fc40000004100ULL,
0x3000000bff547230ULL, 0x000fe20000004100ULL, 0x00001f4a5d5e7589ULL, 0x000f2200000e0000ULL,
0x20000006ff057230ULL, 0x000fe40000004100ULL, 0x20000008ff077230ULL, 0x000fe40000004100ULL,
0x2000000aff097230ULL, 0x000fe40000004100ULL, 0x30000006ff067230ULL, 0x000fe40000004100ULL,
0x20000011ff557230ULL, 0x002fc40000004100ULL, 0x30000011ff567230ULL, 0x000fe40000004100ULL,
0x20000013ff577230ULL, 0x000fe40000004100ULL, 0x30000013ff587230ULL, 0x000fe40000004100ULL,
0x20000015ff597230ULL, 0x004fe40000004100ULL, 0x30000015ff5a7230ULL, 0x000fe40000004100ULL,
0x0000005c4e217223ULL, 0x008fe20000010021ULL, 0x20000010ff0b7230ULL, 0x000fc40000004100ULL,
0x0000005c4b207223ULL, 0x080fe20000010020ULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x0000005c4d3e7223ULL, 0x080fe2000001003eULL, 0x20000014ff137230ULL, 0x000fe40000004100ULL,
0x0000005c043b7223ULL, 0x080fe2000001003bULL, 0x20000016ff157230ULL, 0x000fe40000004100ULL,
0x0000005c053a7223ULL, 0x000fe2000001003aULL, 0x20000017ff5b7230ULL, 0x000fc40000004100ULL,
0x0000005c06377223ULL, 0x080fe20000010037ULL, 0x30000008ff087230ULL, 0x000fe40000004100ULL,
0x0000005c4f367223ULL, 0x080fe20000010036ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x0000005c50337223ULL, 0x080fe20000010033ULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000005c07327223ULL, 0x000fe20000010032ULL, 0x30000012ff127230ULL, 0x000fc40000004100ULL,
0x0000005c082f7223ULL, 0x080fe2000001002fULL, 0x30000014ff147230ULL, 0x000fe40000004100ULL,
0x0000005c512e7223ULL, 0x080fe2000001002eULL, 0x30000016ff167230ULL, 0x000fe40000004100ULL,
0x0000005c522b7223ULL, 0x080fe2000001002bULL, 0x30000017ff177230ULL, 0x000fe40000004100ULL,
0x0000005c092a7223ULL, 0x080fe2000001002aULL, 0x0000005c0a277223ULL, 0x080fe20000010027ULL,
0x0000005c53267223ULL, 0x080fe20000010026ULL, 0x0000005c54237223ULL, 0x000fe20000010023ULL,
0x0000005e0b227223ULL, 0x090fe20000010022ULL, 0x0000005e103d7223ULL, 0x080fe2000001003dULL,
0x0000005e553c7223ULL, 0x080fe2000001003cULL, 0x0000005e56397223ULL, 0x080fe20000010039ULL,
0x0000005e11387223ULL, 0x080fe20000010038ULL, 0x0000005e12357223ULL, 0x080fe20000010035ULL,
0x0000005e57347223ULL, 0x080fe20000010034ULL, 0x0000005e58317223ULL, 0x080fe20000010031ULL,
0x0000005e13307223ULL, 0x080fe20000010030ULL, 0x0000005e142d7223ULL, 0x080fe2000001002dULL,
0x0000005e592c7223ULL, 0x080fe2000001002cULL, 0x0000005e5a297223ULL, 0x080fe20000010029ULL,
0x0000005e15287223ULL, 0x080fe20000010028ULL, 0x0000005e16257223ULL, 0x080fe20000010025ULL,
0x0000005e5b247223ULL, 0x080fe20000010024ULL, 0x0000005e17407223ULL, 0x000fe20000010040ULL,
0xfffffff800048947ULL, 0x000fec000383ffffULL, 0x018000003f037836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000dfc000087802ULL, 0x004fce0000000f00ULL, 0x0000005c00507944ULL, 0x002fea0003c00000ULL,
0x000000ffff037224ULL, 0x00cfe200078e0004ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003f00047308ULL, 0x000ee40000001000ULL, 0xbf80000004037423ULL, 0x008fc8000000003fULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fce0000000004ULL,
0x00000000001b7919ULL, 0x000ee40000000000ULL, 0x00000002ff047819ULL, 0x108fe4000001161bULL,
0x000000081b0a7811ULL, 0x004fe400078ff0ffULL, 0x00000003ff0e7819ULL, 0x000fe2000001161bULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0403047589ULL, 0x000ea200000e0000ULL,
0x000000030e0e7812ULL, 0x000fc600078ec0ffULL, 0x00001f0a030f7589ULL, 0x00072200000e0000ULL,
0x000000040e107812ULL, 0x000fe200078efcffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0xfffffff8ff037812ULL, 0x008fc800078ee21bULL, 0x000000070e117812ULL, 0x000fe200078e7803ULL,
0x0000000803157836ULL, 0x040fe20000000000ULL, 0x0000000710137812ULL, 0x000fe200078e7803ULL,
0x0000002104217220ULL, 0x044fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000003e04057220ULL, 0x040fe20000410000ULL, 0x0000003b04067220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003604077220ULL, 0x040fe20000410000ULL, 0x0000003304087220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002e04097220ULL, 0x040fe20000410000ULL, 0x0000002b040a7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x00000026040b7220ULL, 0x040fe20000410000ULL, 0x00000023040c7220ULL, 0x000fe20000410000ULL,
0x0000000803047824ULL, 0x000fe200078e00ffULL, 0x000000070e177812ULL, 0x000fe200078e7815ULL,
0x00000008150e7824ULL, 0x000fe200078e00ffULL, 0x0000000710157812ULL, 0x000fe200078e7815ULL,
0x000000220f227220ULL, 0x010fe20000410000ULL, 0x0000000411037212ULL, 0x080fe200078efcffULL,
0x0000003d0f3d7220ULL, 0x000fe20000410000ULL, 0x0000000413137212ULL, 0x000fe200078efcffULL,
0x0000003c0f3c7220ULL, 0x040fe20000410000ULL, 0x000000390f397220ULL, 0x040fe20000410000ULL,
0x000000380f387220ULL, 0x040fe20000410000ULL, 0x000000350f357220ULL, 0x040fe20000410000ULL,
0x000000340f347220ULL, 0x040fe20000410000ULL, 0x000000310f317220ULL, 0x040fe20000410000ULL,
0x000000300f307220ULL, 0x040fe20000410000ULL, 0x0000002d0f2d7220ULL, 0x040fe20000410000ULL,
0x0000002c0f2c7220ULL, 0x040fe20000410000ULL, 0x000000290f297220ULL, 0x040fe20000410000ULL,
0x000000280f287220ULL, 0x040fe20000410000ULL, 0x000000250f257220ULL, 0x040fe20000410000ULL,
0x000000240f247220ULL, 0x000fe20000410000ULL, 0x0000000e17177212ULL, 0x000fe200078efcffULL,
0x000000400f0f7220ULL, 0x000fe20000410000ULL, 0x0000000e15157212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0202ULL, 0x000000050605723eULL, 0x000fe200000000ffULL,
0x00000010130e7824ULL, 0x100fe200078e0202ULL, 0x000000212004723eULL, 0x000fe200000000ffULL,
0x0000001017147824ULL, 0x100fe200078e0202ULL, 0x0000003a3706723eULL, 0x000fe200000000ffULL,
0x0000001015027824ULL, 0x000fe200078e0202ULL, 0x000000070807723eULL, 0x000fc400000000ffULL,
0x000000090a09723eULL, 0x000fe400000000ffULL, 0x000000322f08723eULL, 0x000fe200000000ffULL,
0x0000000403007844ULL, 0x0005e20000000200ULL, 0x0000002a270a723eULL, 0x000fe400000000ffULL,
0x0000000b0c0b723eULL, 0x000fe400000000ffULL, 0x000000223d10723eULL, 0x000fe400000000ffULL,
0x0000003c3911723eULL, 0x000fe200000000ffULL, 0x000000080e007844ULL, 0x0005e20000000200ULL,
0x000000383512723eULL, 0x000fc400000000ffULL, 0x000000343113723eULL, 0x000fe400000000ffULL,
0x000000302d30723eULL, 0x000fe400000000ffULL, 0x0000002c2931723eULL, 0x000fe200000000ffULL,
0x0000001014007844ULL, 0x0005e20000000200ULL, 0x000000282532723eULL, 0x000fe400000000ffULL,
0x000000240f33723eULL, 0x000fca00000000ffULL, 0x0000003002007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000067919ULL, 0x004ea20000002600ULL,
0x000000201b0f7836ULL, 0x040fe20000000000ULL, 0x00000003ff0c7819ULL, 0x000fe2000001161bULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x000000071b0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x00000003ff047819ULL, 0x000fe4000001160fULL, 0x000000070c027812ULL, 0x000fe400078e481bULL,
0x0000000704057812ULL, 0x000fc400078e480fULL, 0x0ffffff802037812ULL, 0x000fe400078ef81bULL,
0x0ffffff805057812ULL, 0x000fc600078ef80fULL, 0x0000001003037824ULL, 0x100fe400078e0200ULL,
0x0000001005057824ULL, 0x000fc600078e0200ULL, 0x00a0000003087984ULL, 0x000f280000000c00ULL,
0x00a0000005107984ULL, 0x000b220000000c00ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000806077824ULL, 0x044fe400078e00ffULL, 0x0000000806157824ULL, 0x000fc600078e00ffULL,
0xfffffff807007812ULL, 0x000fe400078ee20cULL, 0xfffffff815047812ULL, 0x000fe400078ee204ULL,
0x0000000400077c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404067c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0x000000070f007812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000407027c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff057224ULL, 0x020fe200008e06ffULL, 0x0000000406047c11ULL, 0x000fc4000f8248ffULL,
0x0000000507037c11ULL, 0x000fe400080f4c0cULL, 0x1ffffff80e077812ULL, 0x000fe400078ef80dULL,
0x0000000506057c11ULL, 0x000fe400088f4c05ULL, 0x1ffffff8000d7812ULL, 0x000fe200078ef80dULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d08ULL, 0x0000001004007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff057819ULL, 0x000fe2000001160fULL,
0x00009400ff127b82ULL, 0x000e620000000a00ULL, 0x00000001ff0a7424ULL, 0x000fc600078e00ffULL,
0x000000020e047824ULL, 0x000fe200078e0205ULL, 0x0106000aff0879a7ULL, 0x0004a80008500007ULL,
0x0000000404007c0cULL, 0x000fda000bf06070ULL, 0x00009000ff078b82ULL, 0x000ee20000000800ULL,
0x000000020b058824ULL, 0x000fe200078e00ffULL, 0x00000008120c7981ULL, 0x00256c000c1e9900ULL,
0x00008c00ff108b82ULL, 0x000e620000000a00ULL, 0x0000000705058224ULL, 0x008fc800078e0204ULL,
0x0000000405108825ULL, 0x002fc800078e0010ULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000810058981ULL, 0x000ee2000c1e1900ULL, 0x000000010e0d7836ULL, 0x000fca0000000000ULL,
0x000000050d007c0cULL, 0x000fe2000bf06070ULL, 0x000000400f077824ULL, 0x000fe200078e00ffULL,
0x0000000706067899ULL, 0x000fe2000800063fULL, 0x0000008000007824ULL, 0x000fe400078e00ffULL,
0x000001000e157824ULL, 0x000fca00078e0207ULL, 0x0000004000227812ULL, 0x000fe200078ef815ULL,
0x00000006050d7c24ULL, 0x008fe4000f8e02ffULL, 0x0000000400cc8947ULL, 0x004fea0003800000ULL,
0x00000002ff297819ULL, 0x100fe20000011602ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000a15107c48ULL, 0x000fe4000ffe0000ULL, 0x00000003ff177819ULL, 0x000fe20000011602ULL,
0x0000000129127824ULL, 0x140fe200078e0222ULL, 0x00000030062b7812ULL, 0x000fe200078ec0ffULL,
0x00000008291b7836ULL, 0x040fe20000000000ULL, 0x0000000317177812ULL, 0x000fe200078e4802ULL,
0x0000000110167824ULL, 0x000fe200078e0a15ULL, 0x000000120d1d7210ULL, 0x000fe20007f1e0ffULL,
0x0000001029117836ULL, 0x000fe20000000000ULL, 0x0ffffffc17067812ULL, 0x000fe200078ef802ULL,
0x000000011b107824ULL, 0x000fc400078e0222ULL, 0x0000001829217836ULL, 0x000fe40000000000ULL,
0x0000000122127824ULL, 0x040fe200078e0211ULL, 0x000000100d1c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x0000000c1d207c11ULL, 0x040fe2000f8040ffULL,
0x0000000122107824ULL, 0x000fe200078e0221ULL, 0x000000120d127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e06ffULL, 0x0000000d1d1d7c11ULL, 0x000fe200080f4414ULL,
0x0000002029237836ULL, 0x040fe20000000000ULL, 0x0000000c1c187c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0x000000100d1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000002829257836ULL, 0x040fe20000000000ULL, 0x0000000c12147c11ULL, 0x000fe2000f8240ffULL,
0x0000003029277836ULL, 0x000fe20000000000ULL, 0x0000000d1c1c7c11ULL, 0x000fe200080f4413ULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x000000070f107c11ULL, 0x000fc4000f8e68ffULL,
0x0000000c1e1a7c11ULL, 0x000fe4000f8040ffULL, 0x0000000d12157c11ULL, 0x000fe200088f4415ULL,
0x0000200010197836ULL, 0x000fe20000000000ULL, 0x0000000d1e1e7c11ULL, 0x000fe200080f4413ULL,
0x000000041b127824ULL, 0x000fe200078e00ffULL, 0x000000162900720cULL, 0x0c0fe20003f06070ULL,
0x0000003829297836ULL, 0x000fe20000000000ULL, 0x000000161b00720cULL, 0x000fe20003f26070ULL,
0x00000010061b7824ULL, 0x000fe200078e0219ULL, 0x000000202b107210ULL, 0x000fe20007f7e0ffULL,
0x0000000411207824ULL, 0x000fe200078e00ffULL, 0xfffffffc12067812ULL, 0x000fc400078ee217ULL,
0x000000161100720cULL, 0x080fe20003f46070ULL, 0x000000ffff117224ULL, 0x000fe200018e061dULL,
0x0000002b18127210ULL, 0x000fe20007f7e0ffULL, 0x00000010061d7824ULL, 0x000fe200078e0219ULL,
0xfffffffc20187812ULL, 0x000fe200078ee217ULL, 0x0000000122067824ULL, 0x000fe200078e0223ULL,
0x0000002b14147210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e061cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101b7faeULL, 0x0003e2000c101c48ULL,
0x00000010181f7824ULL, 0x000fe200078e0219ULL, 0x000000162300720cULL, 0x080fe20003f66070ULL,
0x0000000421187824ULL, 0x040fe200078e00ffULL, 0x00000000121d7faeULL, 0x0005e2000c901c48ULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x000000162100720cULL, 0x000fc40003f86070ULL,
0x000000162700720cULL, 0x080fe40003f26070ULL, 0x00000000141f7faeULL, 0x0007e2000d101c48ULL,
0x000000162500720cULL, 0x000fe40003f46070ULL, 0x000000060d117210ULL, 0x002fe40007f1e0ffULL,
0x0000002b1a107210ULL, 0x000fe40007fbe0ffULL, 0x0000000c111c7c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff127224ULL, 0x004fe200000e06ffULL, 0xfffffffc18067812ULL, 0x000fc400078ee217ULL,
0x000000162900720cULL, 0x000fe20003f06070ULL, 0x0000000122147824ULL, 0x008fe200078e0229ULL,
0x0000000d11167c11ULL, 0x000fe2000b0f4412ULL, 0x000000ffff117224ULL, 0x000fe400028e061eULL,
0x0000001006137824ULL, 0x000fe200078e0219ULL, 0x000000140d157210ULL, 0x000fe20007fde0ffULL,
0x0000000122067824ULL, 0x040fe400078e0225ULL, 0x0000000122127824ULL, 0x000fe200078e0227ULL,
0x0000000010137faeULL, 0x0003e2000e101c48ULL, 0x0000000427147824ULL, 0x000fe200078e00ffULL,
0x000000060d1a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000423067824ULL, 0x000fe200078e00ffULL,
0x000000120d187210ULL, 0x000fe20007f9e0ffULL, 0x0000000425127824ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x000fe200078ee217ULL, 0x00000004291e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc06067812ULL, 0x000fc400078ee217ULL, 0xfffffffc12127812ULL, 0x000fe200078ee217ULL,
0x00000010141d7824ULL, 0x100fe200078e0219ULL, 0xfffffffc1e107812ULL, 0x002fe200078ee217ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x0000000c1a137c11ULL, 0x000fe2000f8a40ffULL,
0x00000010060d7824ULL, 0x100fe400078e0219ULL, 0x00000010121b7824ULL, 0x000fe200078e0219ULL,
0x0000000d1a1a7c11ULL, 0x000fe2000a8f4411ULL, 0x0000001010197824ULL, 0x000fe200078e0219ULL,
0x0000002b1c107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x0000000c18147c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff067224ULL, 0x000fc400030e06ffULL,
0x000000ffff117224ULL, 0x000fe200028e0616ULL, 0x0000002b13127210ULL, 0x000fe40007fbe0ffULL,
0x0000000c15167c11ULL, 0x040fe4000f8c40ffULL, 0x0000000d18177c11ULL, 0x000fe2000a0f4417ULL,
0x000000ffff137224ULL, 0x000fe200028e061aULL, 0x0000002b14147210ULL, 0x000fe20007f9e0ffULL,
0x00000000100d7faeULL, 0x0003e2000d901c48ULL, 0x0000000d15067c11ULL, 0x000fe4000b0f4406ULL,
0x0000002b16167210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200020e0617ULL,
0x00000000121b7faeULL, 0x0003e6000d101c48ULL, 0x000000ffff177224ULL, 0x000fe200028e0606ULL,
0x00000000141d7faeULL, 0x0003e8000c901c48ULL, 0x0000000016197faeULL, 0x0003e2000c101c48ULL,
0x00000004009c7947ULL, 0x000fea0003800000ULL, 0x0000002202107211ULL, 0x040fe200078ff0ffULL,
0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL, 0x0000000802217811ULL, 0x040fe400078ff0ffULL,
0x000000100d107210ULL, 0x000fe40007f1e0ffULL, 0x000000070f127c11ULL, 0x000fe2000f8e68ffULL,
0x00000004211e7824ULL, 0x040fe200078e00ffULL, 0x0000001802137811ULL, 0x000fe200078ff0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000000c10207c11ULL, 0x000fe2000f8040ffULL,
0x0000200012247836ULL, 0x000fe20000000000ULL, 0x0000002002157811ULL, 0x000fe200078ff0ffULL,
0x0000000122147824ULL, 0x000fe200078e0213ULL, 0x0000000d102c7c11ULL, 0x000fe200080f4411ULL,
0x0000000121107824ULL, 0x000fe200078e0222ULL, 0x0000001002117811ULL, 0x000fe200078ff0ffULL,
0x0000000122167824ULL, 0x000fe200078e0215ULL, 0x0000002802177811ULL, 0x040fe200078ff0ffULL,
0x00000004152a7824ULL, 0x000fe200078e00ffULL, 0x0000003002197811ULL, 0x040fe200078ff0ffULL,
0x0000000411267824ULL, 0x000fe200078e00ffULL, 0x00000038021b7811ULL, 0x000fe200078ff0ffULL,
0x0000000122127824ULL, 0x040fe200078e0211ULL, 0x00000003ff1d7819ULL, 0x000fe20000011602ULL,
0x0000000122187824ULL, 0x040fe200078e0217ULL, 0x000000100d107210ULL, 0x000fe20007f7e0ffULL,
0x00000004172e7824ULL, 0x000fe200078e00ffULL, 0x000000031d1f7812ULL, 0x000fe200078e4802ULL,
0x00000001221a7824ULL, 0x040fe200078e0219ULL, 0x000000140d147210ULL, 0x000fe20007f1e0ffULL,
0x00000001221c7824ULL, 0x000fe200078e021bULL, 0xfffffffc1e117812ULL, 0x000fe200078ee21fULL,
0x0000000413287824ULL, 0x000fe200078e00ffULL, 0xfffffffc26137812ULL, 0x000fe200078ee21fULL,
0x0000000419307824ULL, 0x000fe200078e00ffULL, 0xfffffffc2a177812ULL, 0x000fe200078ee21fULL,
0x000000041b227824ULL, 0x000fe200078e00ffULL, 0xfffffffc2e197812ULL, 0x000fe200078ee21fULL,
0x0000001013217824ULL, 0x100fe200078e0224ULL, 0x000000160d167210ULL, 0x000fe20007f3e0ffULL,
0x0000001017257824ULL, 0x100fe200078e0224ULL, 0xfffffffc28157812ULL, 0x000fe200078ee21fULL,
0x0000001019277824ULL, 0x100fe200078e0224ULL, 0xfffffffc301b7812ULL, 0x000fe200078ee21fULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0xfffffffc221d7812ULL, 0x000fe200078ee21fULL,
0x0000001015237824ULL, 0x100fe200078e0224ULL, 0x0ffffffc1f1e7812ULL, 0x000fe200078ef802ULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0x000000120d127210ULL, 0x000fe20007f5e0ffULL,
0x000000101b297824ULL, 0x100fe200078e0224ULL, 0x000000180d187210ULL, 0x000fe20007f7e0ffULL,
0x000000101e2d7824ULL, 0x100fe200078e0224ULL, 0x0000001a0d1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x0000001c0d1c7210ULL, 0x000fe20007fbe0ffULL,
0x00000010110d7824ULL, 0x100fe200078e0224ULL, 0x0000000c14177c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff117224ULL, 0x000fe200008e06ffULL, 0x0000000c16197c11ULL, 0x000fe2000f8240ffULL,
0x000000101d2b7824ULL, 0x000fe200078e0224ULL, 0x0000000c10287c11ULL, 0x000fc4000f8c40ffULL,
0x00000030062e7812ULL, 0x000fe400078ec0ffULL, 0x0000000c12157c11ULL, 0x000fe4000f8440ffULL,
0x0000000d14247c11ULL, 0x000fe200080f4413ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x0000000d16227c11ULL, 0x000fe200088f4411ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x0000000d102a7c11ULL, 0x000fe2000b0f441fULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x0000000c1c1e7c11ULL, 0x000fc4000f8640ffULL, 0x000000202e107210ULL, 0x000fe40007f1e0ffULL,
0x0000000d12267c11ULL, 0x000fe400090f441bULL, 0x0000000c181b7c11ULL, 0x000fe4000f8240ffULL,
0x0000000c1a1d7c11ULL, 0x000fe4000f8440ffULL, 0x0000000d1c067c11ULL, 0x000fe200098f4411ULL,
0x000000ffff117224ULL, 0x000fe200000e062cULL, 0x0000000d18207c11ULL, 0x000fc400088f4413ULL,
0x000000282e127210ULL, 0x000fe40007f1e0ffULL, 0x0000000d1a1f7c11ULL, 0x000fe200090f441fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102d7faeULL, 0x0003e2000b901c48ULL,
0x000000152e147210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200000e062aULL,
0x000000172e167210ULL, 0x000fe40007f5e0ffULL, 0x000000192e187210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0626ULL, 0x0000001b2e1a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0624ULL, 0x0000001d2e1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0622ULL, 0x0000001e2e1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200020e0620ULL, 0x00000000120d7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff1d7224ULL, 0x000fc400028e061fULL, 0x000000ffff1f7224ULL, 0x000fe200000e0606ULL,
0x0000000014217faeULL, 0x0003e8000b901c48ULL, 0x0000000016237faeULL, 0x0003e8000b901c48ULL,
0x0000000018257faeULL, 0x0003e8000b901c48ULL, 0x000000001a277faeULL, 0x0003e8000b901c48ULL,
0x000000001c297faeULL, 0x0003e8000b901c48ULL, 0x000000001e2b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01060009ff0075a7ULL, 0x000ea20008000147ULL,
0x000000200f067824ULL, 0x000fc800078e0202ULL, 0x0000002006107824ULL, 0x002fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fc80000011606ULL, 0x1ffffffe0d0d7812ULL, 0x000fe400078ec0ffULL,
0x000001e010107812ULL, 0x000fe400078ec0ffULL, 0x000000070d117812ULL, 0x000fe400078e7806ULL,
0x000000010d137812ULL, 0x000fc600078efcffULL, 0x0000000110117824ULL, 0x000fe200078e0211ULL,
0x0000000713137812ULL, 0x000fc800078e7806ULL, 0x0000000711117c11ULL, 0x000fe2000f8e20ffULL,
0x0000000110137824ULL, 0x000fe200078e0213ULL, 0x0000003c00c48947ULL, 0x004fec0003800000ULL,
0x0000000713137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000011187984ULL, 0x000e620000000c00ULL,
0x000000100d097836ULL, 0x040fe20000000000ULL, 0x000000050e007c0cULL, 0x000fe2000bf26070ULL,
0x000000110d0d7836ULL, 0x000fe20000000000ULL, 0x0000000013147984ULL, 0x000ea40000000c00ULL,
0x0000000709097812ULL, 0x000fe400078e7806ULL, 0x000000070d0d7812ULL, 0x000fc600078e7806ULL,
0x0000000110097824ULL, 0x040fe400078e0209ULL, 0x00000001100d7824ULL, 0x000fc600078e020dULL,
0x0000000709067c11ULL, 0x000fe4000f8e20ffULL, 0x000000070d0d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1c7224ULL, 0x002fe400078e0018ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff1e7224ULL, 0x004fe400078e0014ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0016ULL,
0x000000ffff207224ULL, 0x000fc400078e0019ULL, 0x000000ffff217224ULL, 0x000fe200078e001bULL,
0x0000001c11007388ULL, 0x000fe20000000c00ULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fca00078e0017ULL, 0x0000002013007388ULL, 0x000fe80000000c00ULL,
0x000000000d147984ULL, 0x000e680000000c00ULL, 0x0000000006187984ULL, 0x000ea20000000c00ULL,
0x000000ffff277224ULL, 0x002fe400078e0016ULL, 0x000000ffff267224ULL, 0x000fc400078e0014ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff247224ULL, 0x004fe400078e0018ULL,
0x000000ffff257224ULL, 0x000fe400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff157224ULL, 0x000fe200078e001bULL, 0x0000002406007388ULL, 0x0003e80000000c00ULL,
0x000000140d007388ULL, 0x0003e20000000c00ULL, 0x0106000aff0879a7ULL, 0x000ea40008500007ULL,
0x01060009ff0075a7ULL, 0x004ea40008000147ULL, 0x0000003c00508947ULL, 0x006fea0003800000ULL,
0x000000000000194dULL, 0x000fea0003800000ULL, 0x00009000000c7ab9ULL, 0x000fe20000000800ULL,
0x3d8000000c067820ULL, 0x020fe20000410000ULL, 0x000000070f087c11ULL, 0x040fe2000f8e18ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000000070f097c11ULL, 0x000fe2000f8e28ffULL,
0x0000000c0b0b7c24ULL, 0x000fe2000f8e02ffULL, 0xffffffff050b7890ULL, 0x000fd8000fffe03fULL,
0x000001000e0c7824ULL, 0x000fca00078e0207ULL, 0x0000000a0c007c0cULL, 0x000fda000bf01070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e000aULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fc4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fce000001ff00ULL, 0x000000010d127836ULL, 0x000fe40000000000ULL,
0x000000ffff417224ULL, 0x000fe400078e000dULL, 0x000000ffff0d7224ULL, 0x100fe200078e0012ULL,
0x00000002ff0a7819ULL, 0x000fe40000011612ULL, 0x000000041200780cULL, 0x040fe40003f06070ULL,
0x0000000312407812ULL, 0x000fe200078ec0ffULL, 0x000000030a0a7224ULL, 0x000fc800078e020eULL,
0x000000010a117836ULL, 0x040fe40000000000ULL, 0x000001000a427824ULL, 0x000fe200078e0207ULL,
0x00000001100a7812ULL, 0x000fe400078e0cffULL, 0x0000000511007c0cULL, 0x000fe2000bf26070ULL,
0x0000000605117c24ULL, 0x020fe2000f8e02ffULL, 0x0000004042137812ULL, 0x000fca00078ec0ffULL,
0x00000001001f7824ULL, 0x000fcc00078e0213ULL, 0x0000000400b89947ULL, 0x000fea0003800000ULL,
0x00000002ff1e7819ULL, 0x100fe20000011602ULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x0000000a42137c48ULL, 0x000fe2000ffe0000ULL, 0x0000000440477824ULL, 0x000fe200078e00ffULL,
0x00000003ff437819ULL, 0x000fe20000011602ULL, 0x000000081e467836ULL, 0x040fe40000000000ULL,
0x000000101e4e7836ULL, 0x000fe20000000000ULL, 0xfffffffc47477812ULL, 0x000fe200078ee202ULL,
0x0000000146147824ULL, 0x100fe400078e021fULL, 0x000000011e127824ULL, 0x000fc400078e021fULL,
0x000000014e167824ULL, 0x000fe200078e021fULL, 0x0000001411147210ULL, 0x000fe20007f5e0ffULL,
0x000000181e4f7836ULL, 0x000fe20000000000ULL, 0x00000012111c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000113427824ULL, 0x000fe200078e0a42ULL, 0x0000001611167210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e06ffULL, 0x0000000c143e7c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x0000000c1c447c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff157224ULL, 0x000fe200018e06ffULL, 0x0000000d143f7c11ULL, 0x000fe200090f4417ULL,
0x000000014f147824ULL, 0x000fe200078e021fULL, 0x0000000c16127c11ULL, 0x000fe2000f8640ffULL,
0x000000201e507836ULL, 0x000fe20000000000ULL, 0x0000000d1c457c11ULL, 0x000fe200088f441dULL,
0x000000281e517836ULL, 0x000fe20000000000ULL, 0x0000000d16137c11ULL, 0x000fe200098f4415ULL,
0x000000301e527836ULL, 0x040fe20000000000ULL, 0x000000421e00720cULL, 0x040fe20003f46070ULL,
0x000000381e537836ULL, 0x000fe20000000000ULL, 0x0000001411147210ULL, 0x000fe20007f3e0ffULL,
0x0000000150167824ULL, 0x000fc400078e021fULL, 0x00000001511c7824ULL, 0x100fe400078e021fULL,
0x00000001521e7824ULL, 0x100fe400078e021fULL, 0x00000001533c7824ULL, 0x000fe200078e021fULL,
0x00000016111f7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x0000001c113d7210ULL, 0x000fe20007fde0ffULL, 0x0000001047447825ULL, 0x040fe200078e0044ULL,
0x0000001e111d7210ULL, 0x000fe40007f9e0ffULL, 0x0000003c11157210ULL, 0x000fe20007f7e0ffULL,
0x00000004463c7824ULL, 0x000fe200078e00ffULL, 0x0000000c14167c11ULL, 0x000fe2000f8240ffULL,
0x00000010473e7825ULL, 0x000fe200078e003eULL, 0x000000070f117c11ULL, 0x000fc4000f8e68ffULL,
0x00000002431c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff4c7224ULL, 0x000fe200030e06ffULL,
0x0000000d14177c11ULL, 0x000fe200088f4417ULL, 0x000010000a147824ULL, 0x000fe200078e0211ULL,
0x000000031c4d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200028e06ffULL,
0x000000424600720cULL, 0x000fe20003f26070ULL, 0x0000200014467836ULL, 0x000fe20000000000ULL,
0x0ffffffc4d497812ULL, 0x000fe200078ef802ULL, 0x000000ffff4a7224ULL, 0x000fe200020e06ffULL,
0xfffffffc3c4b7812ULL, 0x000fe200078ee24dULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x0000000c1f1e7c11ULL, 0x000fe2000f8a40ffULL, 0x0000001049497824ULL, 0x100fe200078e0246ULL,
0x0000000c15147c11ULL, 0x000fe2000f8840ffULL, 0x000000104b4b7824ULL, 0x000fe200078e0246ULL,
0x0000000d1f1f7c11ULL, 0x000fe2000a8f441cULL, 0x0000001047127825ULL, 0x000fe200078e0012ULL,
0x0000000c3d3c7c11ULL, 0x000fe2000f8a40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000044497faeULL, 0x0003e2000d101c48ULL, 0x0000000c1d1c7c11ULL, 0x000fe2000f8640ffULL,
0x0000001047167825ULL, 0x000fe200078e0016ULL, 0x0000000d3d3d7c11ULL, 0x000fe2000a8f444cULL,
0x000000003e4b7faeULL, 0x0005e2000c901c48ULL, 0x0000000d1d1d7c11ULL, 0x000fe200098f444aULL,
0x00000010471e7825ULL, 0x000fe200078e001eULL, 0x0000000d15157c11ULL, 0x000fc4000a0f4448ULL,
0x000000424e00720cULL, 0x0c0fe20003f26070ULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x000000424f00720cULL, 0x080fe20003f46070ULL, 0x0000000451447824ULL, 0x042fe200078e00ffULL,
0x000000425000720cULL, 0x0c0fe20003f66070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x000000425100720cULL, 0x080fe20003f86070ULL, 0x00000004533e7824ULL, 0x044fe200078e00ffULL,
0x000000425200720cULL, 0x0c0fe20003fa6070ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x000000425300720cULL, 0x000fe20003fc6070ULL, 0x000000044f427824ULL, 0x000fe200078e00ffULL,
0xfffffffc4e3f7812ULL, 0x000fe200078ee24dULL, 0x00000010473c7825ULL, 0x000fe200078e003cULL,
0xfffffffc50497812ULL, 0x000fc400078ee24dULL, 0xfffffffc42457812ULL, 0x000fe200078ee24dULL,
0x000000103f3f7824ULL, 0x100fe200078e0246ULL, 0xfffffffc444b7812ULL, 0x000fe200078ee24dULL,
0x0000001049497824ULL, 0x100fe200078e0246ULL, 0xfffffffc524f7812ULL, 0x000fe200078ee24dULL,
0x0000001045457824ULL, 0x100fe200078e0246ULL, 0xfffffffc3e517812ULL, 0x000fe200078ee24dULL,
0x000000104b4b7824ULL, 0x100fe200078e0246ULL, 0x00000000123f7faeULL, 0x0003e2000c901c48ULL,
0x000000104f4d7824ULL, 0x000fe400078e0246ULL, 0x00000010471c7825ULL, 0x000fe200078e001cULL,
0x0000000016457faeULL, 0x0003e6000d101c48ULL, 0x00000010514f7824ULL, 0x000fe200078e0246ULL,
0x000000001e497faeULL, 0x0003e2000d901c48ULL, 0x0000001047147825ULL, 0x000fc600078e0014ULL,
0x000000003c4b7faeULL, 0x0003e8000e101c48ULL, 0x000000001c4d7faeULL, 0x0003e8000e901c48ULL,
0x00000000144f7faeULL, 0x0003e2000f101c48ULL, 0x0000000400887947ULL, 0x000fea0003800000ULL,
0x00000010024c7811ULL, 0x040fe200078ff0ffULL, 0x00008a00000c7ab9ULL, 0x000fe20000000a00ULL,
0x00000008024a7811ULL, 0x000fe200078ff0ffULL, 0x0000000440557824ULL, 0x000fe200078e00ffULL,
0x0000001f02127211ULL, 0x000fe200078ff0ffULL, 0x000000014c167824ULL, 0x100fe200078e021fULL,
0x00000018024e7811ULL, 0x000fe200078ff0ffULL, 0x000000014a147824ULL, 0x000fe200078e021fULL,
0x0000001211177210ULL, 0x000fe40007f3e0ffULL, 0x0000001611137210ULL, 0x000fc40007f7e0ffULL,
0x0000001411157210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000000c173e7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x0000000c13127c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x0000000c15167c11ULL, 0x000fe4000f8440ffULL, 0x0000000d13137c11ULL, 0x000fe200098f4414ULL,
0x000000014e147824ULL, 0x000fe200078e021fULL, 0x0000002002507811ULL, 0x000fc400078ff0ffULL,
0x0000000d173f7c11ULL, 0x000fe400088f441eULL, 0x0000003002547811ULL, 0x000fe400078ff0ffULL,
0x0000000d15177c11ULL, 0x000fe200090f441cULL, 0x00000001501c7824ULL, 0x100fe200078e021fULL,
0x0000002802527811ULL, 0x000fe200078ff0ffULL, 0x00000001543c7824ULL, 0x100fe200078e021fULL,
0x0000001411157210ULL, 0x000fe40007f3e0ffULL, 0x0000003802567811ULL, 0x000fe200078ff0ffULL,
0x00000001521e7824ULL, 0x100fe200078e021fULL, 0x0000001c113d7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x0000000c15147c11ULL, 0x000fe2000f8640ffULL,
0x0000000156427824ULL, 0x000fe200078e021fULL, 0x0000003c111d7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x0000001e111f7210ULL, 0x000fc40007fbe0ffULL,
0x0000000d15157c11ULL, 0x000fe200098f441cULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x0000000c3d3c7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff467224ULL, 0x000fe200028e06ffULL,
0x0000000c1d1c7c11ULL, 0x000fe4000f8440ffULL, 0x00000003ff437819ULL, 0x000fe40000011602ULL,
0x0000004211427210ULL, 0x000fe40007f3e0ffULL, 0x0000000d3d3d7c11ULL, 0x000fe200098f4448ULL,
0x000000044a487824ULL, 0x000fe200078e00ffULL, 0x0000000c1f1e7c11ULL, 0x000fe2000f8840ffULL,
0x000000044c4a7824ULL, 0x000fe200078e00ffULL, 0x000000070f117c11ULL, 0x000fe2000f8e68ffULL,
0x000000044e4c7824ULL, 0x000fe200078e00ffULL, 0x0000000d1d1d7c11ULL, 0x000fe200090f4444ULL,
0x00000004504e7824ULL, 0x000fe200078e00ffULL, 0x0000000243447212ULL, 0x000fe200078e3cffULL,
0x0000000452507824ULL, 0x000fe200078e00ffULL, 0x0000000d1f1f7c11ULL, 0x000fe2000a0f4446ULL,
0x000010000a467824ULL, 0x000fe200078e0211ULL, 0x0000000344457812ULL, 0x000fe200078ec0ffULL,
0x0000000454527824ULL, 0x000fe200078e00ffULL, 0xfffffffc55557812ULL, 0x000fe200078ee202ULL,
0x0000000456547824ULL, 0x000fe200078e00ffULL, 0xfffffffc48487812ULL, 0x000fe200078ee245ULL,
0x0000200046537836ULL, 0x000fe20000000000ULL, 0x0ffffffc45467812ULL, 0x000fe200078ef802ULL,
0x00000010553e7825ULL, 0x000fe200078e003eULL, 0xfffffffc4a4a7812ULL, 0x000fc400078ee245ULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee245ULL, 0x0000001046577824ULL, 0x100fe200078e0253ULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee245ULL, 0x0000001048477824ULL, 0x000fe200078e0253ULL,
0xfffffffc50507812ULL, 0x000fe200078ee245ULL, 0x0000001055167825ULL, 0x040fe200078e0016ULL,
0xfffffffc52527812ULL, 0x000fe200078ee245ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e577faeULL, 0x0003e2000b901c48ULL, 0xfffffffc54547812ULL, 0x000fe200078ee245ULL,
0x000000ffff457224ULL, 0x000fe200008e06ffULL, 0x0000000c42447c11ULL, 0x000fe2000f8240ffULL,
0x000000104a497824ULL, 0x000fe200078e0253ULL, 0x0000000016477faeULL, 0x0003e2000b901c48ULL,
0x0000001055127825ULL, 0x000fe200078e0012ULL, 0x0000000d42457c11ULL, 0x000fc600088f4445ULL,
0x000000104c4b7824ULL, 0x000fe200078e0253ULL, 0x0000000012497faeULL, 0x0003e2000b901c48ULL,
0x0000001055147825ULL, 0x000fc800078e0014ULL, 0x000000104e4d7824ULL, 0x000fe200078e0253ULL,
0x00000000144b7faeULL, 0x0003e2000b901c48ULL, 0x00000010553c7825ULL, 0x000fc800078e003cULL,
0x00000010504f7824ULL, 0x000fe200078e0253ULL, 0x000000003c4d7faeULL, 0x0003e2000b901c48ULL,
0x00000010551e7825ULL, 0x000fc800078e001eULL, 0x0000001052517824ULL, 0x000fe200078e0253ULL,
0x000000001e4f7faeULL, 0x0003e2000b901c48ULL, 0x00000010551c7825ULL, 0x000fc800078e001cULL,
0x0000001054537824ULL, 0x000fe200078e0253ULL, 0x000000001c517faeULL, 0x0003e2000b901c48ULL,
0x0000001055447825ULL, 0x000fca00078e0044ULL, 0x0000000044537faeULL, 0x0003e4000b901c48ULL,
0x000000034000780cULL, 0x000fda0003f25270ULL, 0x0000000000201947ULL, 0x000fea0003800000ULL,
0x0000000203047824ULL, 0x000fe400078e0204ULL, 0xffffffffff057424ULL, 0x000fc600078e00ffULL,
0x0000000404007c0cULL, 0x000fda000bf26070ULL, 0x0000000000101947ULL, 0x000fea0003800000ULL,
0x00008c00ff127b82ULL, 0x002e620000000a00ULL, 0x000000020b057824ULL, 0x000fc800078e0204ULL,
0x0000000405127825ULL, 0x002fca00078e0012ULL, 0x0000000812057981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002157836ULL, 0x042fe20000000000ULL,
0xfffffff802137812ULL, 0x000fe200078ec0ffULL, 0x00001000103f7824ULL, 0x000fe200078e0211ULL,
0x0000000702477812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ec0ffULL, 0x000020003f3f7836ULL, 0x000fe20000000000ULL,
0x0000000713407812ULL, 0x000fe400078ef802ULL, 0x0000000715427812ULL, 0x000fc400078ef802ULL,
0x00000001ff3d7819ULL, 0x000fe40000011640ULL, 0x00000001ff457819ULL, 0x000fe40000011642ULL,
0x00000008473e7812ULL, 0x000fe400078ef802ULL, 0x000000033d3d7812ULL, 0x000fe400078ec0ffULL,
0x0000000345457812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x0000003c3d117212ULL, 0x080fe200078e3cffULL, 0x0000000441797824ULL, 0x000fe200078e023cULL,
0x0000003c45157212ULL, 0x000fc600078e3cffULL, 0x0000000440107824ULL, 0x000fe400078e0211ULL,
0x0000000442147824ULL, 0x000fe400078e0215ULL, 0x0000001010107824ULL, 0x100fe400078e023fULL,
0x0000001014147824ULL, 0x000fe400078e023fULL, 0x0000000279797824ULL, 0x000fe400078e00ffULL,
0x000000001010783bULL, 0x000e680000000200ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00000018ff5c7819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010567816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115a7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff657819ULL, 0x000fc40000011412ULL, 0x0000888012747816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001000777306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff697819ULL, 0x004fe40000011414ULL, 0x00008880146e7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe20000011415ULL, 0x0000001100607306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x042fe200078e00ffULL, 0x00008880156a7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011413ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c005b7306ULL, 0x000e620000200c00ULL,
0x0000888013707816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011416ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000001200727306ULL, 0x0005e20000200c00ULL,
0x0000888016677816ULL, 0x000fe400000000ffULL, 0x00000018ff447819ULL, 0x000fe40000011417ULL,
0x00008880175e7816ULL, 0x000fc600000000ffULL, 0x0000001100737306ULL, 0x0007e20000200c00ULL,
0x000000013c127836ULL, 0x044fe40000000000ULL, 0x000000023c3c7836ULL, 0x000fca0000000000ULL,
0x0000001d005f7306ULL, 0x0005e20000200c00ULL, 0x000000123d117212ULL, 0x008fe400078e3cffULL,
0x000000043c00780cULL, 0x000fc60003f25270ULL, 0x00000004401c7824ULL, 0x000fe400078e0211ULL,
0x0000001000757306ULL, 0x0007e20000200c00ULL, 0x0001000015117824ULL, 0x040fe400078e00ffULL,
0x000000101c1c7824ULL, 0x000fe400078e023fULL, 0x0000010015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001300717306ULL, 0x0009e20000200c00ULL,
0x000000001c1c783bULL, 0x004ea20000000200ULL, 0x0001000014107824ULL, 0x048fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x00000015006b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001245137212ULL, 0x010fca00078e3cffULL,
0x00000014006c7306ULL, 0x0009e20000200c00ULL, 0x0000007902157211ULL, 0x008fe200078fe0ffULL,
0x0000000442127824ULL, 0x000fe400078e0213ULL, 0x0000000279797836ULL, 0x000fe20000000000ULL,
0x0000000715157812ULL, 0x000fe200078e783eULL, 0x0000001012127824ULL, 0x000fe400078e023fULL,
0x00000010006f7306ULL, 0x0007e20000200c00ULL, 0x0001000017147824ULL, 0x050fe200078e00ffULL,
0x0000007902797211ULL, 0x000fe200078fe0ffULL, 0x0000010017177824ULL, 0x000fc400078e00ffULL,
0x000000203e157824ULL, 0x000fe200078e0215ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0001000016107824ULL, 0x048fe200078e00ffULL,
0x0000001400637306ULL, 0x0005e20000200c00ULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x0000000715157c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff687819ULL, 0x000fe40000011410ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x0000001700617306ULL, 0x000fe20000200c00ULL,
0x000100001c147824ULL, 0x044fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe4000001141cULL,
0x000088801c497816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001600667306ULL, 0x0005e20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fe4000001141dULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x000088801d507816ULL, 0x040fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001141eULL,
0x0000001400527306ULL, 0x0007e20000200c00ULL, 0x000100001d167824ULL, 0x044fe200078e00ffULL,
0x000088801e537816ULL, 0x000fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001141fULL, 0x00000018ff557819ULL, 0x000fe40000011416ULL,
0x00000011006d7306ULL, 0x0005e20000200c00ULL, 0x000000001514783bULL, 0x008fe20000000200ULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x0000000779797812ULL, 0x000fc800078e783eULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x000000001210783bULL, 0x004ea20000000200ULL,
0x000000203e797824ULL, 0x000fcc00078e0279ULL, 0x0000001c00517306ULL, 0x0009f00000200c00ULL,
0x0000001d00547306ULL, 0x0003e20000200c00ULL, 0x000100001e1c7824ULL, 0x050fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005a005a7306ULL, 0x000f220000200c00ULL, 0x000088801f1d7816ULL, 0x002fe400000000ffULL,
0x00000018ff1e7819ULL, 0x000fca000001141eULL, 0x0000001c00587306ULL, 0x0003f00000200c00ULL,
0x0000005d005d7306ULL, 0x000ee20000200c00ULL, 0x00005410561c7816ULL, 0x002fe2000000005bULL,
0x000100001f5b7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x004fe20000011410ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fc40000011411ULL,
0x00000018ff487819ULL, 0x000fe20000011413ULL, 0x0000001d00567306ULL, 0x0007e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x00000018ff4a7819ULL, 0x000fc60000011412ULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x00005410771d7816ULL, 0x008fce000000005cULL, 0x0000001c1438723cULL, 0x000fe20000001838ULL,
0x0000006400647306ULL, 0x000eac0000200c00ULL, 0x00010000101d7824ULL, 0x000fe200078e00ffULL,
0x000054105a1c7816ULL, 0x010fe2000000005fULL, 0x0000007000707306ULL, 0x000ee60000200c00ULL,
0x00000018ff1d7819ULL, 0x000fca000001141dULL, 0x0000001e00577306ULL, 0x0009f00000200c00ULL,
0x0000001d005f7306ULL, 0x0003e20000200c00ULL, 0x00008880101e7816ULL, 0x050fe200000000ffULL,
0x0000010010107824ULL, 0x000fca00078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00005410601d7816ULL, 0x002fe4000000005dULL,
0x0000888011607816ULL, 0x000fca00000000ffULL, 0x0000001c1434723cULL, 0x000fe20000001834ULL,
0x0000001f005c7306ULL, 0x0003ec0000200c00ULL, 0x00005410721d7816ULL, 0x000fe20000000065ULL,
0x0000010011727824ULL, 0x040fe200078e00ffULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00010000111f7824ULL, 0x002fe200078e00ffULL, 0x0000541071117816ULL, 0x004fc40000000064ULL,
0x00000018ff647819ULL, 0x000fe40000011472ULL, 0x00000018ff657819ULL, 0x000fe4000001141fULL,
0x00000010005d7306ULL, 0x0007f00000200c00ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000541070107816ULL, 0x008fce0000000073ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000010142c723cULL, 0x000fe2000000182cULL, 0x00005410741c7816ULL, 0x002fcc0000000075ULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x0000888012117816ULL, 0x000fe400000000ffULL,
0x000054106e107816ULL, 0x000fc6000000006fULL, 0x000000ffff6e7224ULL, 0x000fe200078e0011ULL,
0x000054106c117816ULL, 0x000fe20000000069ULL, 0x0000001e005a7306ULL, 0x0004e20000200c00ULL,
0x0000001c1430723cULL, 0x000fe20000001830ULL, 0x00010000126c7824ULL, 0x000fca00078e00ffULL,
0x000000101428723cULL, 0x000fe20000001828ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000007791e7c11ULL, 0x004fe4000f8e20ffULL, 0x00000018ff6c7819ULL, 0x000fc6000001146cULL,
0x000054106a107816ULL, 0x002fe2000000006dULL, 0x000000001e1c783bULL, 0x000e620000000200ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000054106b117816ULL, 0x000fe40000000062ULL,
0x000054105a5a7816ULL, 0x008fca000000005fULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x000000101424723cULL, 0x000fee0000001824ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000010012117824ULL, 0x000fe200078e00ffULL, 0x0000541067107816ULL, 0x004fc80000000068ULL,
0x00000018ff677819ULL, 0x000fe40000011411ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x0000541066117816ULL, 0x008fe40000000059ULL, 0x0000888013597816ULL, 0x000fca00000000ffULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000101420723cULL, 0x000fee0000001820ULL,
0x0000004900497306ULL, 0x000ee20000200c00ULL, 0x000054105e107816ULL, 0x004fe40000000063ULL,
0x0000541061117816ULL, 0x000fe20000000044ULL, 0x000000ffff447224ULL, 0x000fc800078e0059ULL,
0x0000004e004e7306ULL, 0x000ea40000200c00ULL, 0x000000101418723cULL, 0x000fec0000001818ULL,
0x0000005b005b7306ULL, 0x000f220000200c00ULL, 0x0001000013117824ULL, 0x000fe200078e00ffULL,
0x0000541049107816ULL, 0x008fe20000000052ULL, 0x0000010013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011411ULL, 0x0000541051117816ULL, 0x000fe20000000046ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000541057597816ULL, 0x004fc6000000004eULL, 0x000000101c38723cULL, 0x002fe20000001838ULL,
0x0000541056567816ULL, 0x010fe2000000005bULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x0000541054517816ULL, 0x008fce000000004fULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x000054105c577816ULL, 0x002fce000000004dULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000000561c2c723cULL, 0x000fe2000000182cULL, 0x000054105d5b7816ULL, 0x004fcc000000004cULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000005a1c28723cULL, 0x000fee0000001828ULL,
0x0000004800487306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000ff00000200c00ULL,
0x0000005500557306ULL, 0x000e700000200c00ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x0000541050507816ULL, 0x002fce0000000055ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000501c34723cULL, 0x000fe20000001834ULL, 0x0000541053587816ULL, 0x004fcc0000000058ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000000581c30723cULL, 0x000fee0000001830ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541060607816ULL, 0x002fce0000000065ULL,
0x0000006e00697306ULL, 0x000fe20000200c00ULL, 0x0000541064617816ULL, 0x004fce000000004bULL,
0x0000006c00127306ULL, 0x000e620000200c00ULL, 0x000000601c24723cULL, 0x000fee0000001824ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541069127816ULL, 0x002fce0000000012ULL,
0x0000004400147306ULL, 0x000ff00000200c00ULL, 0x0000001500117306ULL, 0x000e700000200c00ULL,
0x0000001300177306ULL, 0x0004e20000200c00ULL, 0x0000541014147816ULL, 0x002fc40000000011ULL,
0x0000541067137816ULL, 0x004fe4000000004aULL, 0x0000541017157816ULL, 0x008fca0000000048ULL,
0x000000121c20723cULL, 0x000fec0000001820ULL, 0x000000141c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000301947ULL, 0x000fde000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000aULL, 0xffffffe000448947ULL, 0x000fec000383ffffULL,
0x00000001ff3c7424ULL, 0x000fe200078e00ffULL, 0x000000070f0d7c11ULL, 0x000fe2000f8e38ffULL,
0x0000000402127824ULL, 0x000fe400078e00ffULL, 0x0000000620147220ULL, 0x080fe20000410000ULL,
0x0106883c081079a7ULL, 0x000e62000850003fULL, 0x0000000621167220ULL, 0x080fe20000410000ULL,
0x0000000638157220ULL, 0x080fe20000410000ULL, 0xfffffff012127812ULL, 0x000fe200078ec0ffULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x000000063a3a7220ULL, 0x080fe20000410000ULL,
0x000000063b3b7220ULL, 0x080fe20000410000ULL, 0x0000000634347220ULL, 0x080fe20000410000ULL,
0x0000000635357220ULL, 0x080fe20000410000ULL, 0x0000000636367220ULL, 0x080fe20000410000ULL,
0x0000000637377220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x080fe20000410000ULL, 0x0000000632327220ULL, 0x080fe20000410000ULL,
0x0000000633337220ULL, 0x080fe20000410000ULL, 0x000000062c2c7220ULL, 0x080fe20000410000ULL,
0x000000062d2d7220ULL, 0x080fe20000410000ULL, 0x000000062e2e7220ULL, 0x080fe20000410000ULL,
0x000000062f2f7220ULL, 0x080fe20000410000ULL, 0x0000000628287220ULL, 0x080fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x000000062a2a7220ULL, 0x080fe20000410000ULL,
0x000000062b2b7220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x01068811080075a7ULL, 0x002e62000800017fULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000626267220ULL, 0x080fe20000410000ULL, 0x0000000627277220ULL, 0x080fe20000410000ULL,
0x0000000622227220ULL, 0x080fe20000410000ULL, 0x0000000623237220ULL, 0x000fe20000410000ULL,
0x000000010d0d7824ULL, 0x000fc400078e0212ULL, 0x0000000618187220ULL, 0x080fe20000410000ULL,
0x0000000619197220ULL, 0x080fe20000410000ULL, 0x000000061a207220ULL, 0x080fe20000410000ULL,
0x000000061b217220ULL, 0x000fe20000410000ULL, 0x00000018009c8947ULL, 0x002fec0003800000ULL,
0x010400000d107984ULL, 0x0002a20000000c00ULL, 0x0000000b0e007c0cULL, 0x000fda000bf05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x0000000202177824ULL, 0x000fe200078e00ffULL,
0x0000000a0c0c7c10ULL, 0x000fc8000fffe1ffULL, 0x0000000617177812ULL, 0x000fc800078ec0ffULL,
0x00000001171b7812ULL, 0x040fe400078efcffULL, 0x00000008171d7812ULL, 0x000fe400078efcffULL,
0x0000000c1b00720cULL, 0x080fe40003f26070ULL, 0x00000010171b7812ULL, 0x000fe400078efcffULL,
0x0000000c1d00720cULL, 0x080fe40003f06070ULL, 0x0000000c1b00720cULL, 0x000fc40003fc6070ULL,
0x00000011171d7812ULL, 0x040fe400078efcffULL, 0x00000018171b7812ULL, 0x040fe400078efcffULL,
0x0000000c1700720cULL, 0x080fe40003f46070ULL, 0x0000000c1d00720cULL, 0x080fe40003fa6070ULL,
0x0000000c1b00720cULL, 0x000fe40003f66070ULL, 0x00000009171f7812ULL, 0x000fc400078efcffULL,
0x00000019171d7812ULL, 0x040fe400078efcffULL, 0x00000020171b7812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x0000000c1f00720cULL, 0x080fe40003f86070ULL, 0x0000000c1d00720cULL, 0x080fe40003f46070ULL,
0x0000000c1b00720cULL, 0x000fe40003f26070ULL, 0x00000021171d7812ULL, 0x040fe400078efcffULL,
0x00000028171b7812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x0000000c1d00720cULL, 0x080fe40003f06070ULL,
0x0000000c1b00720cULL, 0x000fe40003f86070ULL, 0x00000029171d7812ULL, 0x000fc400078efcffULL,
0x00000030171b7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x0000000c1d00720cULL, 0x000fc40003fc6070ULL,
0x0000000c1b00720cULL, 0x000fe40003fa6070ULL, 0x00000031171d7812ULL, 0x040fe400078efcffULL,
0x00000038171b7812ULL, 0x040fe400078efcffULL, 0x0000003917177812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fe40004800000ULL,
0x0000000c1d00720cULL, 0x080fe40003f66070ULL, 0x0000000c1b00720cULL, 0x000fc40003f46070ULL,
0x0000000c1700720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff24247808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff14147808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x0000001510107209ULL, 0x004fe20007810000ULL,
0xffffffff000c7882ULL, 0x000fe20000000000ULL, 0x0000003a110c7209ULL, 0x000fe40007810000ULL,
0x0000003910117209ULL, 0x000fe40007810000ULL, 0x0000003b0c177209ULL, 0x000fe40007810000ULL,
0x00000034110c7209ULL, 0x000fe40007810000ULL, 0x0000003617107209ULL, 0x000fc40007810000ULL,
0x000000350c117209ULL, 0x000fe40007810000ULL, 0x0000003710177209ULL, 0x000fe40007810000ULL,
0x00000030110c7209ULL, 0x000fe40007810000ULL, 0x0000003217107209ULL, 0x000fe40007810000ULL,
0x000000310c117209ULL, 0x000fe40007810000ULL, 0x0000003310177209ULL, 0x000fc40007810000ULL,
0x0000002c110c7209ULL, 0x000fe40007810000ULL, 0x0000002e17107209ULL, 0x000fe40007810000ULL,
0x0000002d0c117209ULL, 0x000fe40007810000ULL, 0x0000002f10177209ULL, 0x000fe40007810000ULL,
0x00000028110c7209ULL, 0x000fe40007810000ULL, 0x0000002a17107209ULL, 0x000fc40007810000ULL,
0x000000290c117209ULL, 0x000fe40007810000ULL, 0x0000002b10177209ULL, 0x000fe40007810000ULL,
0x00000024110c7209ULL, 0x000fe40007810000ULL, 0x0000002617107209ULL, 0x000fe40007810000ULL,
0x000000250c117209ULL, 0x000fe40007810000ULL, 0x0000002710177209ULL, 0x000fc40007810000ULL,
0x0000001411117209ULL, 0x000fe40007810000ULL, 0x00000022170c7209ULL, 0x000fe40007810000ULL,
0x0000001611117209ULL, 0x000fe40007810000ULL, 0x000000230c177209ULL, 0x000fe40007810000ULL,
0x00000018110c7209ULL, 0x000fe40007810000ULL, 0x0000002017107209ULL, 0x000fc40007810000ULL,
0x000000190c117209ULL, 0x000fe40007810000ULL, 0x0000002110107209ULL, 0x000fe20007810000ULL,
0x000000160c187947ULL, 0x000fec000b800000ULL, 0x0c401f00110c7f89ULL, 0x000e6800000e0000ULL,
0x0c401f00101b7f89ULL, 0x000ea800000e0000ULL, 0x0c401f00121d7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00131a7f89ULL, 0x000f2200000e0000ULL, 0x0000000c11177209ULL, 0x002fc40007810000ULL,
0x0000001b101b7209ULL, 0x004fc60007810000ULL, 0x0c201f00171c7f89ULL, 0x000e6200000e0000ULL,
0x0000001d121d7209ULL, 0x008fc60007810000ULL, 0x0c201f001b1e7f89ULL, 0x000ea200000e0000ULL,
0x0000001a130c7209ULL, 0x010fc60007810000ULL, 0x0c201f001d387f89ULL, 0x000ee800000e0000ULL,
0x0c201f000c3d7f89ULL, 0x00092200000e0000ULL, 0x0000001c17107209ULL, 0x002fe40007810000ULL,
0x0000001e1b117209ULL, 0x004fe40007810000ULL, 0x000000381d127209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b10137820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b11407820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010840ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010840ULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010813ULL, 0x00000039001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010813ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010840ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010813ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010840ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010840ULL, 0x00000018003e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19137823ULL, 0x000fe20000010813ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010840ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010840ULL, 0x3fb8aa3b23237823ULL, 0x000fc40000010840ULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000003600177308ULL, 0x000ff00000000800ULL, 0x0000003700187308ULL, 0x000e700000000800ULL,
0x0000002c001e7308ULL, 0x000fe20000000800ULL, 0x000000171817723eULL, 0x002fce00000000ffULL,
0x00000014002c7308ULL, 0x0003f00000000800ULL, 0x0000002800387308ULL, 0x0005e20000000800ULL,
0x000000151a14723eULL, 0x002fe400000000ffULL, 0x0000003a3b15723eULL, 0x000fca00000000ffULL,
0x0000002900397308ULL, 0x0003e20000000800ULL, 0x3c003c00ff287424ULL, 0x004fce00078e00ffULL,
0x00000016003f7308ULL, 0x0005e20000000800ULL, 0x3c003c00ff297424ULL, 0x002fce00078e00ffULL,
0x00000030001c7308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x004fe200000000ffULL,
0x0000000000007948ULL, 0x000fec0003800000ULL, 0x000000281418723cULL, 0x000fe200000018ffULL,
0x0000002400307308ULL, 0x000ff00000000800ULL, 0x00000032001d7308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x0000001c311c723eULL, 0x002fce00000000ffULL, 0x0000003300247308ULL, 0x000e620000000800ULL,
0x0000001e2d1e723eULL, 0x004fce00000000ffULL, 0x0000002e001f7308ULL, 0x0005e20000000800ULL,
0x0000001d241d723eULL, 0x002fce00000000ffULL, 0x0000002f00327308ULL, 0x000e620000000800ULL,
0x3fb8aa3b272e7823ULL, 0x004fe20000010840ULL, 0x000000383924723eULL, 0x000fcc00000000ffULL,
0x0000002500257308ULL, 0x000ea20000000800ULL, 0x0000001f321f723eULL, 0x002fce00000000ffULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x000000281c18723cULL, 0x000fee0000001818ULL,
0x0000002b002b7308ULL, 0x000e700000000800ULL, 0x00000026002d7308ULL, 0x0005f00000000800ULL,
0x0000002e002e7308ULL, 0x000ee20000000800ULL, 0x000000302526723eULL, 0x004fc400000000ffULL,
0x0000002a2b25723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b202a7823ULL, 0x100fe20000010840ULL,
0x3fb8aa3b21407823ULL, 0x000fe20000010840ULL, 0x0000002c3f20723eULL, 0x000fe400000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x0000002d2e27723eULL, 0x008fce00000000ffULL,
0x00000022002f7308ULL, 0x0003e20000000800ULL, 0x000000282418723cULL, 0x000fee0000001818ULL,
0x0000002300327308ULL, 0x000ea20000000800ULL, 0x0000003e1322723eULL, 0x002fe400000000ffULL,
0xfffffffc02137812ULL, 0x000fca00078ec0ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x0000002f3221723eULL, 0x004fce00000000ffULL, 0x00000040002b7308ULL, 0x000e640000000800ULL,
0x0000002a2b23723eULL, 0x002fce00000000ffULL, 0x00000028202c723cULL, 0x000fee0000001818ULL,
0x0000000fff187424ULL, 0x000fca00078e00ffULL, 0x0000001318297219ULL, 0x000fe400000006ffULL,
0x0000003d0c137209ULL, 0x010fd20007810000ULL, 0x001c1fff2c187589ULL, 0x00026200000e0000ULL,
0x0000000000287806ULL, 0x000fe200038e0100ULL, 0x00000000291a73a1ULL, 0x000eb000000e8000ULL,
0x00000000290c73c4ULL, 0x000ee20000004000ULL, 0x00000000000d7886ULL, 0x000fc400038e0100ULL,
0x0000000d29ff7c12ULL, 0x004fda000f80401aULL, 0x000000120c2c8947ULL, 0x00afea000b800000ULL,
0x001c1fff2e197589ULL, 0x0002a800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x000ee800000e0000ULL,
0x001c1fff001b7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff477812ULL, 0x000fe200078ee247ULL,
0x000000ffff307224ULL, 0x000fe200078e0014ULL, 0x00000003432b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff317224ULL, 0x000fe200078e0016ULL, 0x000000070f2a7c11ULL, 0x000fe2000f8e58ffULL,
0x0000000847287836ULL, 0x000fe20000000000ULL, 0x000000042b2d7812ULL, 0x000fe200078efcffULL,
0x00000008470c7824ULL, 0x000fe200078e00ffULL, 0x000000072b297812ULL, 0x002fe200078e7847ULL,
0x0000a0002a2a7836ULL, 0x000fe20000000000ULL, 0x000000072d477812ULL, 0x000fe200078e7847ULL,
0x000000ffff327224ULL, 0x000fe200078e001cULL, 0x000000072b2b7812ULL, 0x000fe200078e7828ULL,
0x000000ffff337224ULL, 0x000fe200078e001eULL, 0x000000072d2d7812ULL, 0x000fe200078e7828ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x0000000c29297212ULL, 0x080fe200078efcffULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000000c47477212ULL, 0x000fe200078efcffULL,
0x000000ffff347224ULL, 0x000fe200078e0024ULL, 0x0000000302ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001029297824ULL, 0x100fe200078e022aULL, 0x000000282b2b7212ULL, 0x080fe200078efcffULL,
0x0000001047477824ULL, 0x000fe200078e022aULL, 0x000000282d2d7212ULL, 0x000fe200078efcffULL,
0x000000ffff357224ULL, 0x000fe200078e0026ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000003029007844ULL, 0x0003e20000000200ULL, 0x000000ffff367224ULL, 0x000fc400078e0020ULL,
0x000000ffff377224ULL, 0x000fe400078e0022ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000102b2b7824ULL, 0x100fe200078e022aULL, 0x0000003447007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe400078e001fULL,
0x000000102d2d7824ULL, 0x000fc400078e022aULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0x000000142b007844ULL, 0x0003e20000000200ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0027ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x00000001030e7824ULL, 0x000fc600078e020eULL, 0x0000001c2d007844ULL, 0x0003e80000000200ULL,
0x010000100d008388ULL, 0x0003e80000000c00ULL, 0x010200180d008388ULL, 0x01c3e20000000c00ULL,
0x000000050e007c0cULL, 0x000fe2000bf06070ULL, 0x0106083c09ff79a7ULL, 0x0003e2000850003fULL,
0x0106103c09ff79a7ULL, 0x0003e2000850003fULL, 0x0106183c09ff79a7ULL, 0x0003e2000850003fULL,
0x0106203c09ff79a7ULL, 0x0003f2000850003fULL, 0xffffffcc00108947ULL, 0x022fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000007ff1b7e24ULL, 0x000fc8000f8e00ffULL,
0x0106b8151b0075a7ULL, 0x0004a2000802017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x0106b8151b0095a7ULL, 0x000e64000802007fULL,
0xfffffffc00e89947ULL, 0x002fea000383ffffULL, 0xfffffee400187947ULL, 0x002fea000383ffffULL,
0x01060815070075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010608150700a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xfffffee800447947ULL, 0x000fea000383ffffULL,
0x00000007ff157e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86f150075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86f150095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xfffffeec00407947ULL, 0x000fea000383ffffULL, 0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b879110075a7ULL, 0x000262000808017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b8791100c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xfffffefc00987947ULL, 0x000fea000383ffffULL,
0x00000007ff117e24ULL, 0x002fc8000f8e00ffULL, 0x0106b071110075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0711100a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00e8a947ULL, 0x002fea000383ffffULL,
0xfffffefc00f87947ULL, 0x000fea000383ffffULL, 0x00000007ff737e24ULL, 0x000fc8000f8e00ffULL,
0x0106b815730075a7ULL, 0x0004a2000808017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b8157300c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xffffff1000387947ULL, 0x00afea000383ffffULL,
0x01062815070075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010628150700a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff10009c7947ULL, 0x020fea000383ffffULL,
0x00000007ff157e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86f150075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86f150095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff1400747947ULL, 0x020fea000383ffffULL, 0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b875110075a7ULL, 0x000262000808017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000c95dULL, 0x000fea0003900000ULL, 0x0106b8751100c5a7ULL, 0x000e64000808007fULL,
0xfffffffc00e8c947ULL, 0x002fea000383ffffULL, 0xffffff2400a07947ULL, 0x000fea000383ffffULL,
0x00000007ff117e24ULL, 0x002fc8000f8e00ffULL, 0x0106b071110075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b071110095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff2400c87947ULL, 0x000fea000383ffffULL, 0x00000007ff277e24ULL, 0x000fc8000f8e00ffULL,
0x0106b815270075a7ULL, 0x0004a200080c017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000e95dULL, 0x000fea0003900000ULL, 0x0106b8152700e5a7ULL, 0x000e6400080c007fULL,
0xfffffffc00e8e947ULL, 0x002fea000383ffffULL, 0xffffff3400ec7947ULL, 0x002fea000383ffffULL,
0x01064815070075a7ULL, 0x000262000804017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x010648150700a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00eca947ULL, 0x002fea000383ffffULL, 0xffffff3800147947ULL, 0x004fea000383ffffULL,
0x00000007ff157e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86f150075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a86f150095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff3800ec7947ULL, 0x000fea000383ffffULL, 0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b873110075a7ULL, 0x00026200080c017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000e95dULL, 0x000fea0003900000ULL, 0x0106b8731100e5a7ULL, 0x000e6400080c007fULL,
0xfffffffc00e8e947ULL, 0x002fea000383ffffULL, 0xffffff4800fc7947ULL, 0x000fea000383ffffULL,
0x00000007ff117e24ULL, 0x002fc8000f8e00ffULL, 0x0106b071110075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0711100a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00e8a947ULL, 0x002fea000383ffffULL,
0xffffff4c00247947ULL, 0x000fea000383ffffULL, 0x00000007ff277e24ULL, 0x000fc8000f8e00ffULL,
0x0106b815270075a7ULL, 0x0004a2000804017fULL, 0x0000a0000000791aULL, 0x000fc80000000000ULL,
0x009896800000a95dULL, 0x000fea0003900000ULL, 0x0106b8152700a5a7ULL, 0x000e64000804007fULL,
0xfffffffc00e8a947ULL, 0x002fea000383ffffULL, 0xffffff5c00307947ULL, 0x00afea000383ffffULL,
0x01066815070075a7ULL, 0x000262000802017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000995dULL, 0x000fea0003900000ULL, 0x01066815070095a7ULL, 0x000e64000802007fULL,
0xfffffffc00ec9947ULL, 0x002fea000383ffffULL, 0xffffff5c008c7947ULL, 0x020fea000383ffffULL,
0x00000007ff157e24ULL, 0x000fc8000f8e00ffULL, 0x0106a86f150075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106a86f150085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffff6000647947ULL, 0x020fea000383ffffULL, 0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL,
0x0106b86f110075a7ULL, 0x00026200080a017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000d95dULL, 0x000fea0003900000ULL, 0x0106b86f1100d5a7ULL, 0x000e6400080a007fULL,
0xfffffffc00e8d947ULL, 0x002fea000383ffffULL, 0xffffff70009c7947ULL, 0x000fea000383ffffULL,
0x00000007ff117e24ULL, 0x000fc8000f8e00ffULL, 0x0106b071110075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b071110095a7ULL, 0x000e64000802007fULL, 0xfffffffc00e89947ULL, 0x002fea000383ffffULL,
0xffffff7000c07947ULL, 0x002fea000383ffffULL, 0x00000007ff157e24ULL, 0x000fc8000f8e00ffULL,
0x01060009150075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01060009150085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffc000207947ULL, 0x020fea000383ffffULL,
0x00000007ff0d7e24ULL, 0x000fc8000f8e00ffULL, 0x010600090d0075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x010600090d0085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffc000947947ULL, 0x020fea000383ffffULL, 0x01068811080075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01068811080085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe4004c7947ULL, 0x020fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0011ULL, 0x00000002ff3f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fce00078e00ffULL,
0x000000003e087348ULL, 0x000fea0003c00000ULL, 0x0c00003f1f3d7389ULL, 0x0006e40000000040ULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff1f7224ULL, 0x002fe400078e0010ULL, 0x00000002ff3f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff407424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x004fce00078e003dULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0c00003f1f3d7389ULL, 0x0002640000000040ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000c11177209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1b7224ULL, 0x000fce00078e003dULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0c00003f1f3d7389ULL, 0x0002640000000040ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001b101b7209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1d7224ULL, 0x000fce00078e003dULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0c00003f1f3d7389ULL, 0x0002640000000040ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001d121d7209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0017ULL,
0x00000001ff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x000fce00078e003dULL,
0x000000003e087348ULL, 0x000fea0003c00000ULL, 0x0c00003f1f3d7389ULL, 0x0002640000000040ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001a130c7209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e001bULL, 0x000000ffff1c7224ULL, 0x000fce00078e003dULL,
0x000000003e087348ULL, 0x000fea0003c00000ULL, 0x0c00003f1f3d7389ULL, 0x0002640000000040ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001c17107209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e001dULL, 0x000000ffff1e7224ULL, 0x000fce00078e003dULL,
0x000000003e087348ULL, 0x000fea0003c00000ULL, 0x0c00003f1f3d7389ULL, 0x0002640000000040ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001e1b117209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000cULL, 0x000000ffff387224ULL, 0x000fce00078e003dULL,
0x000000003e087348ULL, 0x000fea0003c00000ULL, 0x0c00003f1f3d7389ULL, 0x0002640000000040ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000381d127209ULL, 0x000fe20007810000ULL,
0xffffffe800447947ULL, 0x020fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fce00078e0029ULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0000001b2e1b7389ULL, 0x0006e4000000002bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x004fe400078e001bULL, 0x000000ffff2e7224ULL, 0x002fe400078e001aULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fce00078e0029ULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0000001b2e1b7389ULL, 0x0006e4000000002bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x004fe400078e001bULL, 0x000000ffff2e7224ULL, 0x002fe400078e0000ULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff3e7224ULL, 0x000fce00078e0029ULL, 0x000000003e087348ULL, 0x000fea0003c00000ULL,
0x0000001b2e1b7389ULL, 0x0006e4000000002bULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffec006c7947ULL, 0x026fea000383ffffULL,
0x018000003f047836ULL, 0x000fe20000000000ULL, 0x0000013000017945ULL, 0x000fe80003800000ULL,
0x7f80000004097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000003f00048308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff097807ULL, 0x000fe40000800000ULL, 0x00000001ff047807ULL, 0x004fc80004000000ULL,
0x0000000409ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff3fff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff047807ULL, 0x000fc80000000000ULL,
0x0000000409ff7212ULL, 0x000fe4000780c0ffULL, 0x800000003f097812ULL, 0x000fd600078ec0ffULL,
0x0080000009040812ULL, 0x000fe200078efcffULL, 0x000000ffff048224ULL, 0x000fe200078e0009ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000003f00047308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffffec008647950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000a00ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001058ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000001078ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000001078ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x00000000000010a8ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000010f0ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000010f8ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000013f00ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015080ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000015090ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015090ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000015090ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000015778ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015778ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000010f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000013f00ULL, 0x0000000000013f00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000015080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015090ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 88264;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
