/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019510ULL, 0x0000000000019090ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000172a0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000017410ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000017450ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000017490ULL,
0x00000000000000f0ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000172a000000000ULL, 0x0000040400000000ULL, 0x810c0000015c0400ULL,
0x005b3c0400288080ULL, 0x0000000000000000ULL, 0x0000011cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x9208288080900828ULL, 0x2880809408288080ULL, 0x8099082880809608ULL, 0x082880809a082880ULL,
0x80809f082880809bULL, 0xa208288080a00828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL,
0x08288080a6082880ULL, 0x8080a808288080a7ULL, 0xab08288080a90828ULL, 0x288080ac08288080ULL,
0x80af08288080ad08ULL, 0x08288080b0082880ULL, 0x8080b208288080b1ULL, 0xb508288080b40828ULL,
0x288080b808288080ULL, 0x80ba08288080b908ULL, 0x08288080bb082880ULL, 0x8080bd08288080bcULL,
0xc108288080c00828ULL, 0x288080d008288080ULL, 0x80dd08288080d808ULL, 0x08288080de082880ULL,
0x8080eb08288080eaULL, 0xf408288080f00828ULL, 0x288080f508288080ULL, 0x8280162880808408ULL,
0x0000000003102880ULL, 0x8080849200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x000172a000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x00000134ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8a08288080840828ULL, 0x2880808b08288080ULL,
0x808e082880808c08ULL, 0x082880808f082880ULL, 0x8080920828808090ULL, 0x9808288080940828ULL,
0x2880809908288080ULL, 0x809b082880809a08ULL, 0x082880809d082880ULL, 0x8080a0082880809fULL,
0xa308288080a20828ULL, 0x288080a408288080ULL, 0x80a708288080a508ULL, 0x08288080a8082880ULL,
0x8080ab08288080a9ULL, 0xaf08288080ad0828ULL, 0x288080b008288080ULL, 0x80b208288080b108ULL,
0x08288080b4082880ULL, 0x8080b808288080b5ULL, 0xba08288080b90828ULL, 0x288080bb08288080ULL,
0x80bd08288080bc08ULL, 0x08288080c0082880ULL, 0x8080d008288080c1ULL, 0xdd08288080d80828ULL,
0x288080de08288080ULL, 0x80eb08288080ea08ULL, 0x08288080f0082880ULL, 0x8080f508288080f4ULL,
0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000001c000000000ULL, 0x0001741000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000134ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080840828ULL,
0x2880808a08288080ULL, 0x808c082880808b08ULL, 0x082880808e082880ULL, 0x808090082880808fULL,
0x9408288080920828ULL, 0x2880809808288080ULL, 0x809a082880809908ULL, 0x082880809b082880ULL,
0x80809f082880809dULL, 0xa208288080a00828ULL, 0x288080a308288080ULL, 0x80a508288080a408ULL,
0x08288080a7082880ULL, 0x8080a908288080a8ULL, 0xad08288080ab0828ULL, 0x288080af08288080ULL,
0x80b108288080b008ULL, 0x08288080b4082880ULL, 0x8080b808288080b5ULL, 0xba08288080b90828ULL,
0x288080bb08288080ULL, 0x80bd08288080bc08ULL, 0x08288080c0082880ULL, 0x8080d008288080c1ULL,
0xdd08288080d80828ULL, 0x288080de08288080ULL, 0x80eb08288080ea08ULL, 0x08288080f0082880ULL,
0x8080f508288080f4ULL, 0x8016288080b20828ULL, 0x0000000310288082ULL, 0x80b2920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000032800000000ULL, 0x0001745000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000134ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8808288080840828ULL, 0x2880808a08288080ULL, 0x808c082880808b08ULL, 0x082880808e082880ULL,
0x808090082880808fULL, 0x9808288080920828ULL, 0x2880809908288080ULL, 0x809b082880809a08ULL,
0x082880809d082880ULL, 0x8080a0082880809fULL, 0xa308288080a20828ULL, 0x288080a408288080ULL,
0x80a708288080a508ULL, 0x08288080a8082880ULL, 0x8080ab08288080a9ULL, 0xaf08288080ad0828ULL,
0x288080b008288080ULL, 0x80b208288080b108ULL, 0x08288080b4082880ULL, 0x8080b808288080b5ULL,
0xba08288080b90828ULL, 0x288080bb08288080ULL, 0x80bd08288080bc08ULL, 0x08288080c0082880ULL,
0x8080d008288080c1ULL, 0xdd08288080d80828ULL, 0x288080de08288080ULL, 0x80eb08288080ea08ULL,
0x08288080f0082880ULL, 0x8080f508288080f4ULL, 0x8016288080940828ULL, 0x0000000310288082ULL,
0x8094920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000049000000000ULL,
0x0001749000000000ULL, 0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL,
0x000812040000009cULL, 0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000159f0000157d0ULL, 0x00015b7000015a00ULL,
0x00015b9000015b80ULL, 0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500003effffffffULL, 0x0500003e0500003eULL,
0xffffffff0500003eULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x00000120000000f0ULL,
0x000017c000001740ULL, 0x0000189000001860ULL, 0x00001ca000001c70ULL, 0x00001d8000001d10ULL,
0x0000345000003430ULL, 0x00003510000034b0ULL, 0x00004ca000004c20ULL, 0x00004e7000004d50ULL,
0x0000515000005130ULL, 0x00005210000051b0ULL, 0x0000674000006720ULL, 0x00006800000067a0ULL,
0x00007e3000007db0ULL, 0x0000800000007ee0ULL, 0x000082e0000082c0ULL, 0x000083a000008340ULL,
0x000098a000009880ULL, 0x0000996000009900ULL, 0x0000b0800000b000ULL, 0x0000b2500000b130ULL,
0x0000b5300000b510ULL, 0x0000b5f00000b590ULL, 0x0000cb400000cb20ULL, 0x0000cc000000cba0ULL,
0x0000df000000def0ULL, 0x000101900000e680ULL, 0x0001098000010470ULL, 0x000111f0000109b0ULL,
0x0001546000015430ULL, 0x0001548000015470ULL, 0x000154c0000154a0ULL, 0x000154f0000154e0ULL,
0x00015bc000015b60ULL, 0x00015be000015bd0ULL, 0x00016340000162f0ULL, 0x00016400000163a0ULL,
0x000164d000016460ULL, 0x000165a000016530ULL, 0x00016640000165f0ULL, 0x00016700000166a0ULL,
0x000167c000016750ULL, 0x0001689000016820ULL, 0x00016930000168e0ULL, 0x000169f000016990ULL,
0x00016ab000016a40ULL, 0x00016b8000016b10ULL, 0x00016c2000016bd0ULL, 0x00016ce000016c80ULL,
0x00016da000016d30ULL, 0x00016e7000016e00ULL, 0x00016f2000016ec0ULL, 0x00016fc000016f70ULL,
0x0001706000017010ULL, 0x00017100000170b0ULL, 0x000171d000017160ULL, 0x0001727000017220ULL,
0x0000027007003904ULL, 0x00010600000000ffULL, 0x000002b0003f0100ULL, 0x000106080000000dULL,
0x00000310003f0120ULL, 0x000106880000000dULL, 0x000003d0003f0120ULL, 0x000106a80000000dULL,
0x00000400003f0120ULL, 0x000106b8000000ffULL, 0x00000500003f0100ULL, 0x00010600000000ffULL,
0x000006a0003f0107ULL, 0x0001068c00000060ULL, 0x00000750003f0102ULL, 0x0001068800000060ULL,
0x00000c80003f0101ULL, 0x000106a8000000ffULL, 0x00000d00003f0107ULL, 0x000106a8000000ffULL,
0x00000d60003f0101ULL, 0x000106b8000000ffULL, 0x00000ec0003f0101ULL, 0x000106bc000000ffULL,
0x00000f20003f0105ULL, 0x000106bc000000ffULL, 0x00000fa0003f0105ULL, 0x000106bc000000ffULL,
0x000014b0003f0105ULL, 0x000106b0000000ffULL, 0x00001530003f0107ULL, 0x000106b0000000ffULL,
0x00001540003f0101ULL, 0x000106ac000000ffULL, 0x000015b0003f0105ULL, 0x0001060800000060ULL,
0x000015d0003f0101ULL, 0x0001060c00000060ULL, 0x00001660003f0105ULL, 0x0001060c00000060ULL,
0x00001b50003f0105ULL, 0x000106ac000000ffULL, 0x00001bd0003f0105ULL, 0x000106ac000000ffULL,
0x00002d90003f0105ULL, 0x000106b8000000ffULL, 0x00002da0003f0101ULL, 0x000106bc000000ffULL,
0x00002df0003f0105ULL, 0x000106bc000000ffULL, 0x00002e70003f0105ULL, 0x000106bc000000ffULL,
0x00003230003f0105ULL, 0x000106a8000000ffULL, 0x000032b0003f0107ULL, 0x000106a8000000ffULL,
0x000032c0003f0101ULL, 0x000106b4000000ffULL, 0x00003310003f0105ULL, 0x000106b4000000ffULL,
0x00003390003f0105ULL, 0x000106b4000000ffULL, 0x00004430003f0105ULL, 0x000106b8000000ffULL,
0x000044a0003f0101ULL, 0x00010688000000ffULL, 0x000044d0003f0101ULL, 0x000106bc000000ffULL,
0x00004520003f0105ULL, 0x000106bc000000ffULL, 0x000045a0003f0105ULL, 0x000106bc000000ffULL,
0x000049e0003f0105ULL, 0x000106b0000000ffULL, 0x00004a60003f0107ULL, 0x000106b0000000ffULL,
0x00004a70003f0101ULL, 0x000106ac000000ffULL, 0x00004ae0003f0105ULL, 0x0001062800000060ULL,
0x00004b00003f0101ULL, 0x0001062c00000060ULL, 0x00004b90003f0105ULL, 0x0001062c00000060ULL,
0x00005020003f0105ULL, 0x000106ac000000ffULL, 0x000050a0003f0105ULL, 0x000106ac000000ffULL,
0x000060b0003f0105ULL, 0x000106b8000000ffULL, 0x000060c0003f0101ULL, 0x000106bc000000ffULL,
0x00006110003f0105ULL, 0x000106bc000000ffULL, 0x00006190003f0105ULL, 0x000106bc000000ffULL,
0x00006520003f0105ULL, 0x000106a8000000ffULL, 0x000065a0003f0107ULL, 0x000106a8000000ffULL,
0x000065b0003f0101ULL, 0x000106b4000000ffULL, 0x00006610003f0105ULL, 0x000106b4000000ffULL,
0x00006690003f0105ULL, 0x000106b4000000ffULL, 0x00007690003f0105ULL, 0x000106b8000000ffULL,
0x00007700003f0101ULL, 0x00010690000000ffULL, 0x00007730003f0101ULL, 0x000106bc000000ffULL,
0x00007780003f0105ULL, 0x000106bc000000ffULL, 0x00007800003f0105ULL, 0x000106bc000000ffULL,
0x00007b70003f0105ULL, 0x000106b0000000ffULL, 0x00007bf0003f0107ULL, 0x000106b0000000ffULL,
0x00007c00003f0101ULL, 0x000106ac000000ffULL, 0x00007c70003f0105ULL, 0x0001064800000060ULL,
0x00007c90003f0101ULL, 0x0001064c00000060ULL, 0x00007d20003f0105ULL, 0x0001064c00000060ULL,
0x000081b0003f0105ULL, 0x000106ac000000ffULL, 0x00008230003f0105ULL, 0x000106ac000000ffULL,
0x00009240003f0105ULL, 0x000106b8000000ffULL, 0x00009250003f0101ULL, 0x000106bc000000ffULL,
0x000092a0003f0105ULL, 0x000106bc000000ffULL, 0x00009320003f0105ULL, 0x000106bc000000ffULL,
0x00009690003f0105ULL, 0x000106a8000000ffULL, 0x00009710003f0107ULL, 0x000106a8000000ffULL,
0x00009720003f0101ULL, 0x000106b4000000ffULL, 0x00009770003f0105ULL, 0x000106b4000000ffULL,
0x000097f0003f0105ULL, 0x000106b4000000ffULL, 0x0000a800003f0105ULL, 0x000106b8000000ffULL,
0x0000a870003f0101ULL, 0x00010698000000ffULL, 0x0000a8a0003f0101ULL, 0x000106bc000000ffULL,
0x0000a8f0003f0105ULL, 0x000106bc000000ffULL, 0x0000a970003f0105ULL, 0x000106bc000000ffULL,
0x0000adc0003f0105ULL, 0x000106b0000000ffULL, 0x0000ae40003f0107ULL, 0x000106b0000000ffULL,
0x0000ae50003f0101ULL, 0x000106ac000000ffULL, 0x0000aec0003f0105ULL, 0x0001066800000060ULL,
0x0000aee0003f0101ULL, 0x0001066c00000060ULL, 0x0000af70003f0105ULL, 0x0001066c00000060ULL,
0x0000b400003f0105ULL, 0x000106ac000000ffULL, 0x0000b480003f0105ULL, 0x000106ac000000ffULL,
0x0000c4a0003f0105ULL, 0x000106b8000000ffULL, 0x0000c4b0003f0101ULL, 0x000106bc000000ffULL,
0x0000c500003f0105ULL, 0x000106bc000000ffULL, 0x0000c580003f0105ULL, 0x000106bc000000ffULL,
0x0000c930003f0105ULL, 0x000106a8000000ffULL, 0x0000c9b0003f0107ULL, 0x000106a8000000ffULL,
0x0000c9c0003f0101ULL, 0x000106b4000000ffULL, 0x0000ca10003f0105ULL, 0x000106b4000000ffULL,
0x0000ca90003f0105ULL, 0x000106b4000000ffULL, 0x0000dac0003f0105ULL, 0x000106b8000000ffULL,
0x0000db20003f0101ULL, 0x000106a0000000ffULL, 0x00011540003f0101ULL, 0x00010600000000ffULL,
0x00012350003f0101ULL, 0x00010604000000ffULL, 0x000123f0003f0105ULL, 0x00010604000000ffULL,
0x00012710003f0105ULL, 0x00010600000000ffULL, 0x00012720003f0101ULL, 0x00010604000000ffULL,
0x000127b0003f0105ULL, 0x00010604000000ffULL, 0x00014930003f0105ULL, 0x0000000000000028ULL,
0x00014970003f0101ULL, 0x0000000400000028ULL, 0x00014d30003f0105ULL, 0x0000000400000028ULL,
0x00016150003f0105ULL, 0x000000000000002aULL, 0x000161b0003f0101ULL, 0x000000080000002aULL,
0x00016210003f0101ULL, 0x000000100000002aULL, 0x00016280003f0101ULL, 0x000000180000002aULL,
0x00053803003f0101ULL, 0x0001144000101c04ULL, 0x000128c000012810ULL, 0x00000401000162c0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL,
0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000005e4ULL, 0x0000001200000002ULL, 0x000000000000047cULL,
0x0000001200000002ULL, 0x0000000000000314ULL, 0x0000001200000002ULL, 0x00000000000001acULL,
0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL, 0x00000000000005bdULL,
0x0000001200000002ULL, 0x0000000000000455ULL, 0x0000001200000002ULL, 0x00000000000002edULL,
0x0000001200000002ULL, 0x0000000000000184ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff247624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001000047300ULL, 0x000fe200000e0000ULL, 0x00000200ff157424ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee80000002200ULL, 0x0000000000687919ULL, 0x000f220000002600ULL,
0x0000001000107309ULL, 0x000f660000000000ULL, 0x0000000000147919ULL, 0x000f280000002700ULL,
0x0000000000057919ULL, 0x000f220000000000ULL, 0x00000005ff677819ULL, 0x002fc6000001160dULL,
0x0000000000667919ULL, 0x000e680000000000ULL, 0x00001fff020c7589ULL, 0x004fe200000e0000ULL,
0x000000ffff107224ULL, 0x020fe400078e0a10ULL, 0x0000000102007824ULL, 0x008fe200078e0203ULL,
0x00001fff67677589ULL, 0x000ea600000e0000ULL, 0x00000080000d7824ULL, 0x000fc400078e020dULL,
0x0000000868037824ULL, 0x010fe400078e00ffULL, 0x0000000824007824ULL, 0x000fe200078e00ffULL,
0x000000ff0d00720cULL, 0x040fe40003f25270ULL, 0x0000000f0d00780cULL, 0x040fe20003f44070ULL,
0x0000001400007224ULL, 0x000fe200078e0203ULL, 0x0000007f0d00780cULL, 0x040fe40003f84070ULL,
0x000000030d00780cULL, 0x000fe40003f64070ULL, 0x000000050400720cULL, 0x000fe20003f02070ULL,
0x00000010660e7824ULL, 0x002fc800078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe200078e00ffULL,
0x000001f00e137812ULL, 0x000fe200078ec0ffULL, 0x3fffffc0ff04a424ULL, 0x000fe400078e00ffULL,
0x000000040c027824ULL, 0x004fe400078e0267ULL, 0x7fffffc0ff05a424ULL, 0x000fe400078e00ffULL,
0x0000000202097824ULL, 0x000fe400078e00ffULL, 0x3fffff80ff029424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe200078e00ffULL, 0x0000000809087817ULL, 0x040fe20007800000ULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0003e20000000a00ULL,
0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL, 0x00000007090b7812ULL, 0x000fe200078ec0ffULL,
0x0000000108087824ULL, 0x100fe200078e0a09ULL, 0x010608040d00a388ULL, 0x000fe20000008a00ULL,
0x000000010d00780cULL, 0x000fe40003f44070ULL, 0x0000000109117810ULL, 0x000fe20007ffe0ffULL,
0x0104000a0d00c388ULL, 0x0005e20000004800ULL, 0x000000010800780cULL, 0x000fe20003f83070ULL,
0x0000000100027824ULL, 0x002fc400078e0209ULL, 0x010688060d00b388ULL, 0x0003e20000008a00ULL,
0x000000ff0800720cULL, 0x000fe20003f63070ULL, 0x00005c0002027625ULL, 0x000fe200078e0015ULL,
0x0000001f0b087812ULL, 0x000fc600078e7866ULL, 0x3fffff80ff0a9424ULL, 0x004fe400078e00ffULL,
0x00000020090f7824ULL, 0x000fe400078e0208ULL, 0x3fffff00ff08a424ULL, 0x000fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe200078e00ffULL, 0x0000000711077812ULL, 0x002fe200078ec0ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0000001302067210ULL, 0x000fe20007fbe0ffULL,
0x0000000100047824ULL, 0x000fe200078e0211ULL, 0x0106a8080d00a388ULL, 0x0003e20000008a00ULL,
0x0000001f07007812ULL, 0x000fe200078e7866ULL, 0x000000100f0f7824ULL, 0x000fc400078e00ffULL,
0x0106b80aff009388ULL, 0x0005e20000000a00ULL, 0x00005c0004047625ULL, 0x000fc800078e0015ULL,
0x0000002011007824ULL, 0x000fe200078e0200ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001304047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe400028e0603ULL,
0x0000001000117824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000ffff007224ULL, 0x000fe400078e0010ULL, 0x00000004ff097424ULL, 0x002fc800078e00ffULL,
0x0000620014027625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060f7faeULL, 0x0005e8000d901c46ULL, 0x0000000004117faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01060400ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602657981ULL, 0x000ee2000c1e1900ULL, 0x00000000000479c3ULL, 0x000e620000002500ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x00000004ff647e24ULL, 0x002fe2000f8e00ffULL,
0x0000007f65637810ULL, 0x008fc40007ffe0ffULL, 0x000000ff65627810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff627819ULL, 0x000fca0000011662ULL,
0x00010e4000008947ULL, 0x000fea0003800000ULL, 0x0000000264617824ULL, 0x000fe400078e00ffULL,
0x0000000867607824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x004fe200078e00ffULL,
0x000000636100720cULL, 0x000fe20003f06070ULL, 0xffffffffff5f7424ULL, 0x000fd800078e00ffULL,
0x0000640061038a10ULL, 0x000fe20007ffe0ffULL, 0x0000000214008824ULL, 0x000fc800078e00ffULL,
0x0000640000038a24ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01068c0560ff738cULL, 0x0003e20000000000ULL, 0x0000600003028625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006025f8981ULL, 0x0004e2000c1e1900ULL,
0x00000004ff047819ULL, 0x000fe20000011666ULL, 0x0000010064007824ULL, 0x040fe200078e00ffULL,
0x0000000164057810ULL, 0x002fe20007ffe0ffULL, 0x0106880060ff7f8cULL, 0x0003e2000c80043fULL,
0x0000000204087810ULL, 0x040fe20007ffe0ffULL, 0xff317217ff5e7424ULL, 0x000fe200078e00ffULL,
0x00000004040a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff5d7224ULL, 0x000fe200078e00ffULL,
0x000000620500720cULL, 0x000fe20003f06070ULL, 0x0000000160067824ULL, 0x040fe200078e0208ULL,
0x0000000065057217ULL, 0x000fe20007800000ULL, 0x00000001600b7824ULL, 0x000fe200078e020aULL,
0x00000006040f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000160037824ULL, 0x004fe200078e0204ULL,
0x0000000706077812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a00ULL,
0x000000070b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000160107824ULL, 0x000fe200078e020fULL,
0x0000000f07077812ULL, 0x100fe200078e7866ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000f0d007812ULL, 0x000fe200078e7866ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000002005057807ULL, 0x000fe20000000000ULL, 0x0000001006097824ULL, 0x000fe200078e0207ULL,
0x0000000703077812ULL, 0x000fe200078ec0ffULL, 0x000000100b0c7824ULL, 0x000fe200078e0200ULL,
0x0000000560057217ULL, 0x000fe20007800000ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000f07027812ULL, 0x000fe200078e7866ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000007100d7812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a60ULL,
0x000000f00e117812ULL, 0x000fe200078ec0ffULL, 0x0000001003067824ULL, 0x000fe200078e0202ULL,
0x0000000f0d0d7812ULL, 0x000fe200078e7866ULL, 0x0000008068037824ULL, 0x000fe200078e0203ULL,
0x000000050800720cULL, 0x080fe20003f46070ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000050400720cULL, 0x080fe20003f26070ULL, 0x0000001010107824ULL, 0x000fe200078e020dULL,
0x0000000203077810ULL, 0x040fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000004030b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000050a00720cULL, 0x000fe20003f06070ULL, 0x000000ffff197224ULL, 0x000fc400078e00ffULL,
0x000058005f007a24ULL, 0x008fc800078e02ffULL, 0x0000008000007824ULL, 0x000fca00078e00ffULL,
0x0000000300137210ULL, 0x040fe40007f7e0ffULL, 0x0000000700077210ULL, 0x000fe40007f9e0ffULL,
0x0000000603037810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078640ffULL, 0x000000ffff027224ULL, 0x000fe200020e06ffULL,
0x00005e0007047a11ULL, 0x000fe400078840ffULL, 0x00005f0013137a11ULL, 0x000fc400018f4408ULL,
0x0000000b000b7210ULL, 0x040fe40007f7e0ffULL, 0x0000000300007210ULL, 0x000fe40007fbe0ffULL,
0x00005f00070d7a11ULL, 0x000fe200020f4402ULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x00005e000b077a11ULL, 0x040fe200078840ffULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x00005e0000087a11ULL, 0x000fe400078a40ffULL, 0x00005f000b0a7a11ULL, 0x000fc400020f440aULL,
0x0000001211027210ULL, 0x000fe40007f9e0ffULL, 0x00005f0000007a11ULL, 0x000fe400028f4403ULL,
0x0000001104047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff037224ULL, 0x000fe200020e0613ULL,
0x000000050f00720cULL, 0x000fe40003f66070ULL, 0x0000c000060b7811ULL, 0x000fe200078e20ffULL,
0x000000ffff057224ULL, 0x000fe200028e060dULL, 0x0000001107067210ULL, 0x000fc40007f9e0ffULL,
0x0000001108087210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000c901c46ULL, 0x0000c000090d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200020e060aULL, 0x0000c0000c0f7811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200028e0600ULL, 0x0000c00010117811ULL, 0x000fe200078e20ffULL,
0x00000000040d7faeULL, 0x0003e8000d101c46ULL, 0x00000000060f7faeULL, 0x0003e2000c101c46ULL,
0x000000626400720cULL, 0x000fc60003f06070ULL, 0x0000000008117faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff027f8cULL, 0x002e62000c80043fULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000cd7000000947ULL, 0x000fea0003800000ULL, 0x00000004675c7824ULL, 0x000fe400078e00ffULL,
0x0000000214147824ULL, 0x000fc400078e00ffULL, 0x00006400ff5b7624ULL, 0x000fe200078e00ffULL,
0x000000025c5a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x002fe400078e0003ULL,
0x00006400145b7624ULL, 0x000fe400078e025bULL, 0xff317217ff5e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fe400078e00ffULL, 0x0000010064007824ULL, 0x000fca00078e00ffULL,
0x000000650000720cULL, 0x000fda0003f06070ULL, 0x0000cc8000000947ULL, 0x006fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0061ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff167819ULL, 0x000fe20000011666ULL,
0x000058005f3c7a24ULL, 0x000fe200078e02ffULL, 0x0000002068027811ULL, 0x000fe200078e38ffULL,
0x0000001066537824ULL, 0x000fe200078e00ffULL, 0x0000000164037810ULL, 0x000fe20007ffe0ffULL,
0x0000000160177824ULL, 0x000fe200078e0216ULL, 0x00000004162a7810ULL, 0x000fe20007ffe0ffULL,
0x000000803c3c7824ULL, 0x000fe200078e00ffULL, 0x0000002064007811ULL, 0x000fe200078e40ffULL,
0x0000000117157824ULL, 0x040fe200078e0202ULL, 0x0000000717297812ULL, 0x000fe200078ec0ffULL,
0x00000001602b7824ULL, 0x000fe200078e022aULL, 0x0000000216347810ULL, 0x000fc40007ffe0ffULL,
0x000000153c157210ULL, 0x000fe40007f3e0ffULL, 0x0000000f29487812ULL, 0x000fe400078e7866ULL,
0x000000620300720cULL, 0x000fe20003f06070ULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x0000000065037217ULL, 0x000fe20007800000ULL, 0x0000001017487824ULL, 0x000fe200078e0248ULL,
0x00005e00152f7a11ULL, 0x000fe200078240ffULL, 0x0000000160177824ULL, 0x000fe200078e0234ULL,
0x00000006162c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a00ULL,
0x00005f0015147a11ULL, 0x000fc400008f4414ULL, 0x000000072b157812ULL, 0x000fe200078ec0ffULL,
0x0000000160457824ULL, 0x040fe200078e022cULL, 0x0000000717297812ULL, 0x000fe400078ec0ffULL,
0x0000000f15467812ULL, 0x000fe200078e7866ULL, 0x0000000117157824ULL, 0x000fe200078e0202ULL,
0x0000002003037807ULL, 0x000fe40000000000ULL, 0x0000000f29007812ULL, 0x000fe200078e7866ULL,
0x000000102b467824ULL, 0x000fe200078e0246ULL, 0x0000000360037217ULL, 0x000fc40007800000ULL,
0x000000153c287210ULL, 0x000fe20007f3e0ffULL, 0x0000001017477824ULL, 0x000fe200078e0200ULL,
0x0000000745297812ULL, 0x000fe200078ec0ffULL, 0x000000012b177824ULL, 0x000fe200078e0202ULL,
0x00005e00282d7a11ULL, 0x000fe200078440ffULL, 0x0000000103157824ULL, 0x000fe200078e0a60ULL,
0x0000000f29007812ULL, 0x000fe200078e7866ULL, 0x000000ffff037224ULL, 0x000fe200008e06ffULL,
0x000000173c177210ULL, 0x000fe20007f7e0ffULL, 0x0000000145297824ULL, 0x000fe200078e0202ULL,
0x000000f053587812ULL, 0x000fe200078ec0ffULL, 0x0000001045457824ULL, 0x000fe200078e0200ULL,
0x00005f0028287a11ULL, 0x000fc400010f4403ULL, 0x000000152a00720cULL, 0x000fe20003f46070ULL,
0x000000ffff2a7224ULL, 0x000fe200018e06ffULL, 0x00005e00172b7a11ULL, 0x040fe400078a40ffULL,
0x000000293c007210ULL, 0x000fe40007fde0ffULL, 0x000000151600720cULL, 0x000fe40003f26070ULL,
0x00005f00172a7a11ULL, 0x000fe200028f442aULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000582f027210ULL, 0x000fc40007f9e0ffULL, 0x00005e0000297a11ULL, 0x000fe400078a40ffULL,
0x0000e00048577811ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200020e0614ULL,
0x00005f0000007a11ULL, 0x000fe400028f4417ULL, 0x000000582d147210ULL, 0x080fe40007fbe0ffULL,
0x000000153400720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002577faeULL, 0x0003e2000c901c46ULL, 0x000000152c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff157224ULL, 0x000fe200028e0628ULL, 0x000000582b167210ULL, 0x000fc40007f3e0ffULL,
0x0000005829287210ULL, 0x000fe40007fbe0ffULL, 0x0000e00047567811ULL, 0x000fe200078e20ffULL,
0x000000ffff177224ULL, 0x000fe200008e062aULL, 0x0000e00046557811ULL, 0x000fe200078e20ffULL,
0x000000ffff297224ULL, 0x000fe200028e0600ULL, 0x0000e00045547811ULL, 0x000fe200078e20ffULL,
0x0000000014567faeULL, 0x0003e8000e101c46ULL, 0x0000000016557faeULL, 0x0003e8000d101c46ULL,
0x0000000028547faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff027f8cULL, 0x002e68000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106080060147f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x00cfc60007844831ULL, 0x01060c0060177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fe40007824815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000167305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000160000735dULL, 0x008fe20003800000ULL,
0x01060c0060177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe20000011666ULL,
0xffffffffff527424ULL, 0x000fe200078e00ffULL, 0x0000007053537812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x0000000153537824ULL, 0x000fca00078e0200ULL,
0x0100000053177984ULL, 0x000ea80000000800ULL, 0x0102000053007984ULL, 0x0007220000000800ULL,
0x0000005e1700720bULL, 0x004fe20003f3d000ULL, 0x00014b927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800008e0100ULL, 0x0000ffff14167812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff357424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff6700720cULL, 0x000fe40003f65270ULL,
0x0000005e1700720bULL, 0x000fe20003f34000ULL, 0x00014b627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000175e287209ULL, 0x000fe40007810000ULL,
0x0000ffff14297812ULL, 0x000fe400078e3cffULL, 0x00000002ff707819ULL, 0x000fe20000011666ULL,
0x010400285300b388ULL, 0x0005e20000000800ULL, 0x800000285e157221ULL, 0x000fe20000010000ULL,
0x0000002916ff7212ULL, 0x000fc6000782c0ffULL, 0x3fb8aa3b15157820ULL, 0x000fc80000410000ULL,
0x00000015003d7308ULL, 0x0004e20000000800ULL, 0x00014b127f007947ULL, 0x000fea000b800000ULL,
0x00001f703d147589ULL, 0x0086a400000e0000ULL, 0x0000000870707810ULL, 0x00afe20007ffe0ffULL,
0x00014b427f007947ULL, 0x000fea000b800000ULL, 0x00001f703d307589ULL, 0x0002e400000e0000ULL,
0x8000002817171221ULL, 0x100fe20000010000ULL, 0x0000003d5d5d7220ULL, 0x000fe20000410000ULL,
0x0000003027277220ULL, 0x08cfe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b17171820ULL, 0x000fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000001700511308ULL, 0x000ea20000000800ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003012127220ULL, 0x080fe20000410000ULL,
0x0000003007077220ULL, 0x080fe20000410000ULL, 0x0000003006067220ULL, 0x080fe20000410000ULL,
0x000000300b0b7220ULL, 0x080fe20000410000ULL, 0x000000300a0a7220ULL, 0x080fe20000410000ULL,
0x000000300f0f7220ULL, 0x080fe20000410000ULL, 0x000000300e0e7220ULL, 0x000fe20000410000ULL,
0x00000001ff357807ULL, 0x000fe20000800000ULL, 0x0000001425257220ULL, 0x080fe20000410000ULL,
0x0000001424247220ULL, 0x080fe20000410000ULL, 0x0000001421217220ULL, 0x080fe20000410000ULL,
0x0000001420207220ULL, 0x080fe20000410000ULL, 0x000000141d1d7220ULL, 0x080fe20000410000ULL,
0x000000141c1c7220ULL, 0x080fe20000410000ULL, 0x0000001419197220ULL, 0x080fe20000410000ULL,
0x0000001418187220ULL, 0x080fe20000410000ULL, 0x0000001411117220ULL, 0x080fe20000410000ULL,
0x0000001410107220ULL, 0x080fe20000410000ULL, 0x0000001405057220ULL, 0x080fe20000410000ULL,
0x0000001404047220ULL, 0x080fe20000410000ULL, 0x0000001409097220ULL, 0x080fe20000410000ULL,
0x0000001408087220ULL, 0x080fe20000410000ULL, 0x000000140d0d7220ULL, 0x080fe20000410000ULL,
0x000000140c0c7220ULL, 0x000fe20000410000ULL, 0x000000ffff5e7224ULL, 0x000fe200078e0028ULL,
0x0000005100001220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000005d005d7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000147305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000140000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff00723eULL, 0x000fe400000000ffULL, 0x00000004ff8c7819ULL, 0x000fc40000011666ULL,
0x00000002ff147819ULL, 0x000fe40000011666ULL, 0x00005410003d7816ULL, 0x002fe20000000000ULL,
0x000147b27f007947ULL, 0x000fea000b800000ULL, 0x00001f143d6b7589ULL, 0x0002a400000e0000ULL,
0x0000000814507810ULL, 0x000fe20007ffe0ffULL, 0x000147f27f007947ULL, 0x000fea000b800000ULL,
0x00001f503d407589ULL, 0x00072400000e0000ULL, 0x00000010146d7810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e006dULL,
0x00001d2000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0001573000007944ULL, 0x01cfea0003c00000ULL,
0x00000018144f7810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e004fULL, 0x00001d9000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000156c000007944ULL, 0x01cfea0003c00000ULL, 0x0000000866157812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000005c66147211ULL, 0x042fe400078fe0ffULL,
0x0000000715177812ULL, 0x140fe400078ec866ULL, 0x0000000715007812ULL, 0x000fe400078ef866ULL,
0x0000001417297212ULL, 0x000fe400078e3cffULL, 0x0000005a66147211ULL, 0x000fc600078fe0ffULL,
0x0000001000447824ULL, 0x000fe200078e0229ULL, 0x0000001417417212ULL, 0x000fc800078e3cffULL,
0x0000c000444e7811ULL, 0x000fe200078e20ffULL, 0x0000001000437824ULL, 0x040fe200078e0241ULL,
0x0000010000007811ULL, 0x000fc600078e20ffULL, 0x000000004e30783bULL, 0x004e620000004200ULL,
0x0000c000434d7811ULL, 0x000fe200078e20ffULL, 0x0000000129427824ULL, 0x100fe400078e0200ULL,
0x0000000141417824ULL, 0x000fe400078e0200ULL, 0x000000004d14783bULL, 0x000ea20000004200ULL,
0x0000c000424c7811ULL, 0x000fe400078e20ffULL, 0x0000c000414b7811ULL, 0x000fc600078e20ffULL,
0x000000004c2c783bULL, 0x000f680000004200ULL, 0x000000004b28783bULL, 0x000ee20000004200ULL,
0x00000018ff367819ULL, 0x002fe20000011430ULL, 0x0000010030397824ULL, 0x040fe200078e00ffULL,
0x0000888030387816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011431ULL, 0x00000100313b7824ULL, 0x040fe200078e00ffULL,
0x00008880313a7816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000010033697824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x004fe20000011414ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff747819ULL, 0x000fe40000011432ULL, 0x0000888032497816ULL, 0x000fe200000000ffULL,
0x0000003000777306ULL, 0x0003e20000200c00ULL, 0x00008880334a7816ULL, 0x040fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011433ULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc40000011416ULL, 0x00000018ff707819ULL, 0x000fe20000011417ULL,
0x0000003100767306ULL, 0x0005e20000200c00ULL, 0x0000010032307824ULL, 0x042fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011415ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000069007d7306ULL, 0x0003e20000200c00ULL, 0x0000010014317824ULL, 0x004fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fc40000011432ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000797306ULL, 0x0005e20000200c00ULL,
0x0000000766697812ULL, 0x002fe400078ec0ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000000869697812ULL, 0x000fe400078ef866ULL, 0x00000018ff6f7819ULL, 0x020fe2000001142cULL,
0x0000004a007a7306ULL, 0x0003e20000200c00ULL, 0x0000888014307816ULL, 0x044fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000000734347812ULL, 0x000fc400078e7869ULL,
0x00000018ff6e7819ULL, 0x000fe4000001142dULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000030007e7306ULL, 0x0005e20000200c00ULL, 0x000000078c4a7812ULL, 0x002fe400078e7869ULL,
0x00000018ff6a7819ULL, 0x008fe40000011428ULL, 0x00000018ff6c7819ULL, 0x000fe20000011429ULL,
0x00000008694a7824ULL, 0x000fe200078e024aULL, 0x00000018ff3e7819ULL, 0x000fe2000001142eULL,
0x0000001400817306ULL, 0x0003e20000200c00ULL, 0x0000888016307816ULL, 0x004fc400000000ffULL,
0x00000018ff007819ULL, 0x000fe4000001142aULL, 0x00000018ff3d7819ULL, 0x000fe4000001142bULL,
0x00000018ff3f7819ULL, 0x000fe2000001142fULL, 0x00000032007b7306ULL, 0x0005e20000200c00ULL,
0x0000010017147824ULL, 0x002fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000003000847306ULL, 0x0003e20000200c00ULL, 0x0000010015327824ULL, 0x004fca00078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000031007f7306ULL, 0x0004e20000200c00ULL,
0x000001002c307824ULL, 0x002fce00078e00ffULL, 0x0000001400887306ULL, 0x0003e20000200c00ULL,
0x0000010016317824ULL, 0x044fe400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003200837306ULL, 0x0005e20000200c00ULL,
0x00000018ff147819ULL, 0x002fe40000011430ULL, 0x0000a0004a307811ULL, 0x000fe400078e20ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x000054107e7e7816ULL, 0x008fe2000000007fULL,
0x00000033007c7306ULL, 0x000fe20000200c00ULL, 0x0000888017327816ULL, 0x044fe200000000ffULL,
0x0001000017177824ULL, 0x000fca00078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000003100857306ULL, 0x000ff00000200c00ULL, 0x0000003200877306ULL, 0x0003f00000200c00ULL,
0x0000004900787306ULL, 0x0004e20000200c00ULL, 0x000000003030783bULL, 0x002e6e0000000200ULL,
0x0000001600867306ULL, 0x000be20000200c00ULL, 0x0000888015497816ULL, 0x044fe200000000ffULL,
0x0001000015157824ULL, 0x000fca00078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000001700897306ULL, 0x0005e20000200c00ULL, 0x000088802d167816ULL, 0x020fe400000000ffULL,
0x0000541078787816ULL, 0x008fe40000000079ULL, 0x000054107a797816ULL, 0x000fc6000000007dULL,
0x00000016008c7306ULL, 0x0007e20000200c00ULL, 0x000001002d177824ULL, 0x044fe400078e00ffULL,
0x000100002d2d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000003900397306ULL, 0x000ea20000200c00ULL, 0x0000991035167816ULL, 0x008fe200000000ffULL,
0x0000010028357824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000000ff1600720cULL, 0x000fc60003f25270ULL, 0x0000003a003a7306ULL, 0x000ff00000200c00ULL,
0x0000003b003b7306ULL, 0x000ee20000200c00ULL, 0x0000541038387816ULL, 0x004fe20000000039ULL,
0x0000006b30309232ULL, 0x002fc40000000000ULL, 0x0000006b32329232ULL, 0x000fe40000000000ULL,
0x0000004031319232ULL, 0x090fe40000000000ULL, 0x0000001500827306ULL, 0x0003e20000200c00ULL,
0x0000004033339232ULL, 0x000fce0000000000ULL, 0x00000017008d7306ULL, 0x0005e20000200c00ULL,
0x000088802c157816ULL, 0x042fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x000054103a397816ULL, 0x008fe2000000003bULL, 0x000000783004723cULL, 0x000fe60000001804ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000015008a7306ULL, 0x0003e20000200c00ULL,
0x000088802f177816ULL, 0x004fc600000000ffULL, 0x000000383038723cULL, 0x000fe4000000180cULL,
0x000000ffff167224ULL, 0x000fe400078e0017ULL, 0x00000014008b7306ULL, 0x0004e20000200c00ULL,
0x000001002e157824ULL, 0x002fe400078e00ffULL, 0x000001002f177824ULL, 0x000fe400078e00ffULL,
0x00000100290d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x0000004900807306ULL, 0x0003220000200c00ULL, 0x000088802e147816ULL, 0x044fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff0d7819ULL, 0x000fc6000001140dULL, 0x00000014008e7306ULL, 0x0005e20000200c00ULL,
0x0000000869497824ULL, 0x002fe200078e0234ULL, 0x000054108a8a7816ULL, 0x008fe4000000008bULL,
0x000054108c8b7816ULL, 0x000fc8000000008dULL, 0x00000015008f7306ULL, 0x0003e20000200c00ULL,
0x0000888028147816ULL, 0x044fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00005410807f7816ULL, 0x010fc80000000083ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000001600907306ULL, 0x0005e20000200c00ULL, 0x00000018ff157819ULL, 0x002fe20000011435ULL,
0x0000007e3018723cULL, 0x000fec0000001818ULL, 0x0000001400927306ULL, 0x0003e20000200c00ULL,
0x0000888029167816ULL, 0x004fca00000000ffULL, 0x000000ffff0c7224ULL, 0x000fe400078e0016ULL,
0x0000001700917306ULL, 0x000fe20000200c00ULL, 0x0000a00049147811ULL, 0x002fce00078e20ffULL,
0x0000001500937306ULL, 0x0002b00000200c00ULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000003700377306ULL, 0x000f220000200c00ULL,
0x0000541092927816ULL, 0x004fce0000000093ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x0000541077367816ULL, 0x008fce0000000036ULL, 0x0000007500757306ULL, 0x000ee20000200c00ULL,
0x0000541076377816ULL, 0x010fce0000000037ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000000363034723cULL, 0x000fe20000001808ULL, 0x000054107b747816ULL, 0x004fcc0000000074ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0001000029087824ULL, 0x000fe200078e00ffULL,
0x000054107c757816ULL, 0x008fe20000000075ULL, 0x0000006b14149232ULL, 0x082fe20000000000ULL,
0x000088802a097816ULL, 0x040fe200000000ffULL, 0x0000006b16169232ULL, 0x000fe20000000000ULL,
0x00000018ff087819ULL, 0x000fe20000011408ULL, 0x0000004015159232ULL, 0x080fe20000000000ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000743010723cULL, 0x000fe20000001810ULL,
0x0000004017179232ULL, 0x000fe20000000000ULL, 0x000001002a0a7824ULL, 0x000fc400078e00ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000008a1438723cULL, 0x000fe20000001838ULL, 0x00000018ff2a7819ULL, 0x000fcc000001142aULL,
0x0000002c002c7306ULL, 0x000e700000200c00ULL, 0x0000002d002d7306ULL, 0x000eb00000200c00ULL,
0x0000000c00947306ULL, 0x0007e20000200c00ULL, 0x000054102c2c7816ULL, 0x002fce000000006fULL,
0x0000000d00777306ULL, 0x0003220000200c00ULL, 0x00005410810c7816ULL, 0x008fe40000000072ULL,
0x000054102d2d7816ULL, 0x004fca000000006eULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x00005410820d7816ULL, 0x002fe20000000073ULL, 0x0000002c1434723cULL, 0x000fec0000001834ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x000054108e2c7816ULL, 0x000fe2000000008fULL,
0x0000000c300c723cULL, 0x000fe2000000181cULL, 0x00005410902d7816ULL, 0x000fc40000000091ULL,
0x0000541094937816ULL, 0x010fc60000000077ULL, 0x0000002800297306ULL, 0x000fe20000200c00ULL,
0x000001002b1e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001140aULL,
0x000088802b1d7816ULL, 0x040fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000000921418723cULL, 0x000fe20000001818ULL,
0x0000000800757306ULL, 0x0007e20000200c00ULL, 0x0000541086867816ULL, 0x004fce0000000071ULL,
0x0000000900287306ULL, 0x0005e20000200c00ULL, 0x0000541084087816ULL, 0x008fce0000000085ULL,
0x0000006a006a7306ULL, 0x000ee20000200c00ULL, 0x0000541087097816ULL, 0x004fe40000000088ULL,
0x0000541089877816ULL, 0x002fca0000000070ULL, 0x000000083008723cULL, 0x040fe20000001820ULL,
0x0000001e00237306ULL, 0x0003ee0000200c00ULL, 0x000000863024723cULL, 0x000fe20000001824ULL,
0x0000001c001f7306ULL, 0x0005220000200c00ULL, 0x000100002f1e7824ULL, 0x002fe200078e00ffULL,
0x00005410296a7816ULL, 0x008fc8000000006aULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000001d00207306ULL, 0x000e620000200c00ULL, 0x00000018ff1c7819ULL, 0x004fe4000001142eULL,
0x0000002c142c723cULL, 0x000fea0000001804ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541028287816ULL, 0x010fc4000000001fULL, 0x00000018ff047819ULL, 0x000fca000001142bULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541020297816ULL, 0x002fce0000000023ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x000000281408723cULL, 0x000fe20000001808ULL,
0x00005410756b7816ULL, 0x004fcc000000006cULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000006a140c723cULL, 0x000fee000000180cULL, 0x0000003f003f7306ULL, 0x000ff00000200c00ULL,
0x0000001c001d7306ULL, 0x000e700000200c00ULL, 0x0000002a00217306ULL, 0x000ff00000200c00ULL,
0x0000001e001e7306ULL, 0x000ea20000200c00ULL, 0x000054101d287816ULL, 0x002fce000000003eULL,
0x0000000400067306ULL, 0x0002e20000200c00ULL, 0x000054101e297816ULL, 0x004fe4000000003fULL,
0x0000541021047816ULL, 0x002fca0000000000ULL, 0x000000281428723cULL, 0x000fe20000001810ULL,
0x0000541006057816ULL, 0x008fce000000003dULL, 0x000000041404723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff107f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe20003800000ULL, 0x0106bc00ff137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004064007811ULL, 0x000fe400078e40ffULL, 0x00000004ff1d7819ULL, 0x000fc40000011666ULL,
0x0000000065117217ULL, 0x000fe40007800000ULL, 0x0000004068137811ULL, 0x000fe400078e38ffULL,
0x000000021d257810ULL, 0x000fe20007ffe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0a00ULL,
0x0000006013157210ULL, 0x0c0fe40007ffe01dULL, 0x0000006013177210ULL, 0x000fe40007ffe025ULL,
0x0000002011117807ULL, 0x000fc40000000000ULL, 0x000000153c157210ULL, 0x000fe40007f5e0ffULL,
0x0000001160117217ULL, 0x000fe40007800000ULL, 0x000000041d237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x000000173c177210ULL, 0x000fe20007f7e0ffULL,
0x0000000111007824ULL, 0x000fe200078e0a60ULL, 0x00005e0015117a11ULL, 0x000fe200078440ffULL,
0x00000001606c7824ULL, 0x000fe200078e0223ULL, 0x00005e00171f7a11ULL, 0x000fe200078840ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005f0015127a11ULL, 0x000fe200010f4412ULL,
0x000000016c157824ULL, 0x000fe200078e0213ULL, 0x000000061d217810ULL, 0x000fc40007ffe0ffULL,
0x000000001d00720cULL, 0x000fe40003f66070ULL, 0x00005f0017147a11ULL, 0x000fe400020f4414ULL,
0x000000153c1c7210ULL, 0x000fe40007f9e0ffULL, 0x0000005811107210ULL, 0x000fe40007f5e0ffULL,
0x0000006013137210ULL, 0x000fe20007ffe021ULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x0000c00048487811ULL, 0x000fe200078e20ffULL, 0x000000ffff117224ULL, 0x000fe200010e0612ULL,
0x000000133c157210ULL, 0x000fc40007fde0ffULL, 0x00005e001c1d7a11ULL, 0x040fe400078840ffULL,
0x000000581f127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe200020f4417ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010487faeULL, 0x0003e2000d901c46ULL, 0x000000002500720cULL, 0x080fe20003f46070ULL,
0x000000ffff137224ULL, 0x000fe200028e0614ULL, 0x00005e0015177a11ULL, 0x000fe400078840ffULL,
0x000000002300720cULL, 0x000fc40003f66070ULL, 0x000000002100720cULL, 0x000fe40003fa6070ULL,
0x000000581d147210ULL, 0x080fe40007fde0ffULL, 0x00005f0015007a11ULL, 0x000fe400020f4416ULL,
0x0000005817107210ULL, 0x002fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200030e061cULL,
0x0000c00047477811ULL, 0x000fe400078e20ffULL, 0x0000c00046467811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200020e0600ULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x0000000012477faeULL, 0x0003e8000d101c46ULL, 0x0000000014467faeULL, 0x0003e8000d901c46ULL,
0x0000000010457faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000107305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe20003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff707819ULL, 0x000fe40000011666ULL,
0x0000000466267811ULL, 0x000fe400078fe0ffULL, 0x00005410003d7816ULL, 0x000fe20000000000ULL,
0x000130d27f007947ULL, 0x000fea000b800000ULL, 0x00001f703d6b7589ULL, 0x0002a400000e0000ULL,
0x000131127f007947ULL, 0x000fea000b800000ULL, 0x00001f503d6a7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e006dULL,
0x000034c000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fc400078e00ffULL, 0x00013f9000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e004fULL,
0x0000352000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00013f3000007944ULL, 0x01cfea0003c00000ULL,
0x0000e00044447811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e00043437811ULL, 0x000fe400078e20ffULL, 0x0000e00042427811ULL, 0x000fe200078e20ffULL,
0x000000004414783bULL, 0x000f620000004200ULL, 0x0000000726267812ULL, 0x000fe400078e7869ULL,
0x0000e00041417811ULL, 0x000fe200078e20ffULL, 0x000000004320783bULL, 0x000e680000004200ULL,
0x00000000421c783bULL, 0x000ee80000004200ULL, 0x000000004110783bULL, 0x000f220000004200ULL,
0x00000018ff247819ULL, 0x020fe20000011414ULL, 0x0000010014277824ULL, 0x040fe200078e00ffULL,
0x0000888014037816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011415ULL, 0x0000010015757824ULL, 0x000fe200078e00ffULL,
0x0000000300747306ULL, 0x000be20000200c00ULL, 0x00000018ff727819ULL, 0x000fe20000011416ULL,
0x00000100177b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x0000888015407816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011417ULL, 0x0000001400777306ULL, 0x0005e20000200c00ULL,
0x0000888016037816ULL, 0x060fe400000000ffULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff707819ULL, 0x002fe40000011420ULL, 0x00000018ff717819ULL, 0x000fe20000011421ULL,
0x0000000300797306ULL, 0x0003e20000200c00ULL, 0x0000010016147824ULL, 0x044fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x008fe2000001141cULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000004000767306ULL, 0x0005e20000200c00ULL,
0x0000888020037816ULL, 0x002fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011422ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff6f7819ULL, 0x000fe20000011423ULL,
0x00000014007a7306ULL, 0x0002e20000200c00ULL, 0x0000888017407816ULL, 0x044fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc4000001147bULL,
0x00000018ff3f7819ULL, 0x000fe4000001141dULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001500787306ULL, 0x0005e20000200c00ULL, 0x0000010020147824ULL, 0x042fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe2000001141eULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001141fULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000016007d7306ULL, 0x0003e20000200c00ULL, 0x0000888021157816ULL, 0x004fc400000000ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00005410797a7816ULL, 0x008fe4000000007aULL,
0x00000018ff307819ULL, 0x010fe20000011410ULL, 0x00000003007f7306ULL, 0x0005e20000200c00ULL,
0x0000010021167824ULL, 0x002fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011411ULL,
0x00000018ff007819ULL, 0x000fe40000011412ULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000001400807306ULL, 0x0002e20000200c00ULL, 0x0001000021037824ULL, 0x004fe200078e00ffULL,
0x00000018ff027819ULL, 0x000fc80000011413ULL, 0x00000018ff037819ULL, 0x000fe40000011403ULL,
0x0000001500817306ULL, 0x0005e20000200c00ULL, 0x0000888022147816ULL, 0x002fce00000000ffULL,
0x0000001400837306ULL, 0x0003e20000200c00ULL, 0x0000010022157824ULL, 0x044fe200078e00ffULL,
0x000054107f807816ULL, 0x008fe20000000080ULL, 0x0001000022227824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000040007c7306ULL, 0x0005e20000200c00ULL,
0x000001001c147824ULL, 0x002fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fcc0000011422ULL,
0x00000017007e7306ULL, 0x0003e20000200c00ULL, 0x0000000869407824ULL, 0x004fce00078e0226ULL,
0x0000001600827306ULL, 0x0004e20000200c00ULL, 0x0000010023177824ULL, 0x002fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000000300847306ULL, 0x0003e20000200c00ULL,
0x0000888023167816ULL, 0x004fce00000000ffULL, 0x0000002000217306ULL, 0x0005e20000200c00ULL,
0x0001000023037824ULL, 0x002fe200078e00ffULL, 0x0000541081817816ULL, 0x008fc80000000082ULL,
0x00000018ff037819ULL, 0x000fe40000011403ULL, 0x0000001500867306ULL, 0x0003e20000200c00ULL,
0x00000018ff207819ULL, 0x004fe40000011414ULL, 0x0000a00040147811ULL, 0x000fca00078e20ffULL,
0x0000001600857306ULL, 0x0005e20000200c00ULL, 0x000088801c157816ULL, 0x042fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x00000003008a7306ULL, 0x0003e20000200c00ULL, 0x000001001d167824ULL, 0x004fce00078e00ffULL,
0x0000001700887306ULL, 0x000fe20000200c00ULL, 0x00000018ff037819ULL, 0x002fce0000011416ULL,
0x0000001500877306ULL, 0x0003f00000200c00ULL, 0x0000001c00897306ULL, 0x0005e20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000002400247306ULL, 0x000ee20000200c00ULL,
0x000001001f1c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe4000001141cULL,
0x0000002500257306ULL, 0x000ea20000200c00ULL, 0x00000006661c7811ULL, 0x000fc800078fe0ffULL,
0x000000071c1c7812ULL, 0x000fc600078e7869ULL, 0x0000002700277306ULL, 0x000f220000200c00ULL,
0x0000541077247816ULL, 0x008fce0000000024ULL, 0x00000003008e7306ULL, 0x0007e20000200c00ULL,
0x0000541078257816ULL, 0x004fce0000000025ULL, 0x0000002600967306ULL, 0x000fe20000200c00ULL,
0x000088801f037816ULL, 0x048fe200000000ffULL, 0x0000006b14149232ULL, 0x082fe20000000000ULL,
0x0000541074747816ULL, 0x010fe20000000027ULL, 0x0000006b16169232ULL, 0x000fe20000000000ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000006a15159232ULL, 0x080fe40000000000ULL,
0x00000003008f7306ULL, 0x0003e20000200c00ULL, 0x0000006a17179232ULL, 0x000fe20000000000ULL,
0x00000018ff1f7819ULL, 0x000fcc000001141fULL, 0x000000241434723cULL, 0x000fe20000001834ULL,
0x0000000869037824ULL, 0x002fe200078e021cULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x00008880101c7816ULL, 0x000fc600000000ffULL, 0x0000a00003267811ULL, 0x000fe400078e20ffULL,
0x000000801418723cULL, 0x000fe40000001818ULL, 0x0000002200237306ULL, 0x0005e40000200c00ULL,
0x000000002624783bULL, 0x000eec0000000200ULL, 0x0000007200727306ULL, 0x000f220000200c00ULL,
0x000088801d227816ULL, 0x044fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x0000541076757816ULL, 0x002fc80000000075ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000007300737306ULL, 0x000e640000200c00ULL, 0x000000741438723cULL, 0x000fec0000001838ULL,
0x0000007b007b7306ULL, 0x000ea20000200c00ULL, 0x000054107d727816ULL, 0x010fce0000000072ULL,
0x00000020008c7306ULL, 0x0009e20000200c00ULL, 0x000054107e737816ULL, 0x002fce0000000073ULL,
0x00000022008b7306ULL, 0x0003e20000200c00ULL, 0x000088801e207816ULL, 0x010fe200000000ffULL,
0x000000721428723cULL, 0x040fe20000001828ULL, 0x000054107c7b7816ULL, 0x004fe2000000007bULL,
0x0000006b24249232ULL, 0x088fe40000000000ULL, 0x0000006b26269232ULL, 0x000fe40000000000ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000001001e227824ULL, 0x042fe200078e00ffULL,
0x0000007a142c723cULL, 0x000fe2000000182cULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000006a25259232ULL, 0x000fc40000000000ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000006a27279232ULL, 0x000fe20000000000ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000001d00907306ULL, 0x0003f00000200c00ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x00000100101d7824ULL, 0x042fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000001e00947306ULL, 0x0007e20000200c00ULL, 0x00005410236e7816ULL, 0x004fce000000006eULL,
0x0000001c00697306ULL, 0x0005e20000200c00ULL, 0x00000100111e7824ULL, 0x008fe200078e00ffULL,
0x000054108a6f7816ULL, 0x002fcc000000006fULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x00008880111c7816ULL, 0x044fe200000000ffULL, 0x0001000011117824ULL, 0x000fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000003f003f7306ULL, 0x000eb00000200c00ULL,
0x00000020008d7306ULL, 0x0007e20000200c00ULL, 0x00005410893e7816ULL, 0x002fce000000003eULL,
0x0000001d00747306ULL, 0x0003220000200c00ULL, 0x00000018ff207819ULL, 0x008fe4000001141eULL,
0x00005410903f7816ULL, 0x004fca000000003fULL, 0x0000001c00757306ULL, 0x0005e20000200c00ULL,
0x00005410841d7816ULL, 0x002fce0000000071ULL, 0x0000002000727306ULL, 0x0002e20000200c00ULL,
0x00005410211c7816ULL, 0x004fe40000000070ULL, 0x0000541085217816ULL, 0x000fe40000000088ULL,
0x0000541069747816ULL, 0x010fc60000000074ULL, 0x0000002200927306ULL, 0x0005220000200c00ULL,
0x0000541083207816ULL, 0x002fce0000000086ULL, 0x0000001f00987306ULL, 0x0003e20000200c00ULL,
0x000000201420723cULL, 0x004fe20000001808ULL, 0x0000541075757816ULL, 0x008fcc0000000072ULL,
0x0000003300337306ULL, 0x000fe20000200c00ULL, 0x0000001c141c723cULL, 0x002fe2000000180cULL,
0x0000010012097824ULL, 0x000fcc00078e00ffULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x00008880120c7816ULL, 0x040fe200000000ffULL, 0x0000006e1414723cULL, 0x000fe20000001804ULL,
0x000054108b0d7816ULL, 0x000fe2000000008eULL, 0x0001000012127824ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fe200078e000cULL, 0x00005410870c7816ULL, 0x000fe2000000008cULL,
0x0000001000737306ULL, 0x0005e20000200c00ULL, 0x0000010013057824ULL, 0x040fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fe20000011409ULL, 0x000000742418723cULL, 0x040fea0000001818ULL,
0x00000008006b7306ULL, 0x0007e20000200c00ULL, 0x0000888013107816ULL, 0x044fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x0000000c240c723cULL, 0x040fea0000001838ULL,
0x00000004006a7306ULL, 0x0008a60000200c00ULL, 0x0000003e2408723cULL, 0x008fea0000001834ULL,
0x0000001100717306ULL, 0x0003e20000200c00ULL, 0x000054108d047816ULL, 0x010fc40000000092ULL,
0x00000018ff347819ULL, 0x000fe40000011405ULL, 0x000054108f057816ULL, 0x000fc60000000096ULL,
0x0000001000387306ULL, 0x0007e20000200c00ULL, 0x0000541098117816ULL, 0x002fe4000000003dULL,
0x000054106b6a7816ULL, 0x004fe2000000006aULL, 0x000000042404723cULL, 0x000fe8000000182cULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000541094107816ULL, 0x008fe40000000033ULL,
0x00000018ff2c7819ULL, 0x000fc40000011412ULL, 0x00000018ff2e7819ULL, 0x000fc60000011413ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x000000102410723cULL, 0x000fee0000001828ULL,
0x0000003400357306ULL, 0x000ee20000200c00ULL, 0x0000541073287816ULL, 0x002fce0000000030ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541071297816ULL, 0x004fce0000000032ULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x00000028241c723cULL, 0x000fe2000000181cULL,
0x00005410386b7816ULL, 0x008fcc0000000035ULL, 0x0000002c002d7306ULL, 0x000e620000200c00ULL,
0x0000006a2420723cULL, 0x000fee0000001820ULL, 0x0000002e002b7306ULL, 0x000ea20000200c00ULL,
0x000054102d287816ULL, 0x002fe40000000000ULL, 0x000054102b297816ULL, 0x004fce0000000002ULL,
0x000000282424723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004064007811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000006500720cULL, 0x000fda0003f24070ULL,
0x0000967000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x006fe40007824815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000300ff027624ULL, 0x000fe200078e00ffULL,
0x0000000161007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff5f7424ULL, 0x000fc600078e00ffULL,
0x000000010000780cULL, 0x000fe40003f25070ULL, 0xffffffff02027811ULL, 0x000fc800078e08ffULL,
0x0000000102027807ULL, 0x000fca0004800000ULL, 0x0000000161617824ULL, 0x000fca00078e0202ULL,
0x000000636100720cULL, 0x000fe40003f26070ULL, 0x00000004ff287819ULL, 0x000fe40000011666ULL,
0x0000006068297811ULL, 0x000fd200078e38ffULL, 0x000000025b149210ULL, 0x000fe20007ffe059ULL,
0x00000004ff159424ULL, 0x000fe200078e00ffULL, 0x00000060292b7210ULL, 0x000fc60007ffe028ULL,
0x0000600014149625ULL, 0x000fe200078e0015ULL, 0x0000006064007811ULL, 0x000fc800078e40ffULL,
0x00000006145f9981ULL, 0x000362000c1e1900ULL, 0x0000002b3c167210ULL, 0x000fe40007f3e0ffULL,
0x0000000065177217ULL, 0x000fe40007800000ULL, 0x0000000466307811ULL, 0x040fe200078fe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e06ffULL, 0x00000006662e7811ULL, 0x000fe200078fe0ffULL,
0x0000000117177824ULL, 0x000fe200078e0a00ULL, 0x0000000228327810ULL, 0x000fe40007ffe0ffULL,
0x00005e0016337a11ULL, 0x000fc400078240ffULL, 0x0000003029157210ULL, 0x042fe20007ffe060ULL,
0x0000000160007824ULL, 0x000fe200078e0232ULL, 0x0000002e292b7210ULL, 0x000fe40007ffe060ULL,
0x00005f0016167a11ULL, 0x000fe200008f442dULL, 0x0000000100297824ULL, 0x000fe200078e0229ULL,
0x000000153c147210ULL, 0x040fe40007f3e0ffULL, 0x0000002b3c2c7210ULL, 0x040fe40007f7e0ffULL,
0x0000002017177807ULL, 0x000fe20000000000ULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x000000293c2a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005e002c2b7a11ULL, 0x000fc400078640ffULL, 0x00005e00142d7a11ULL, 0x000fe400078440ffULL,
0x0000001760177217ULL, 0x000fe40007800000ULL, 0x00005f002c2c7a11ULL, 0x000fe200018f4415ULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x00005f0014297a11ULL, 0x000fe200010f442fULL,
0x0000000117177824ULL, 0x000fe200078e0a60ULL, 0x00005e002a2f7a11ULL, 0x000fe400078640ffULL,
0x0000005833147210ULL, 0x000fc40007f9e0ffULL, 0x00005f002a2a7a11ULL, 0x000fe400018f4415ULL,
0x000000172800720cULL, 0x080fe20003f46070ULL, 0x000000ffff157224ULL, 0x000fe200020e0616ULL,
0x000000582f167210ULL, 0x080fe40007fbe0ffULL, 0x000000173200720cULL, 0x080fe40003f26070ULL,
0x000000173000720cULL, 0x080fe40003f66070ULL, 0x000000172e00720cULL, 0x000fe20003f86070ULL,
0x000000ffff177224ULL, 0x000fe200028e062aULL, 0x000000582d287210ULL, 0x000fc40007fde0ffULL,
0x000000582b2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e4000d101c46ULL, 0x000000ffff297224ULL, 0x000fe400030e0629ULL,
0x000000ffff2b7224ULL, 0x000fe200028e062cULL, 0x0000000016567faeULL, 0x0003e8000c901c46ULL,
0x0000000028557faeULL, 0x0003e8000d901c46ULL, 0x000000002a547faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff347f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff147984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106280060167f8cULL, 0x000fe2000c80043fULL, 0x8000000014ff7812ULL, 0x002fc60007844831ULL,
0x01062c0060157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007824817ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002e4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x008fe40003800000ULL, 0x01062c0060157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007824817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0100800053177984ULL, 0x000e680000000800ULL, 0x0102800053167984ULL, 0x0007220000000800ULL,
0x0000005e1700720bULL, 0x002fe20003f3d000ULL, 0x000119b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800008e0100ULL, 0x0000ffff14297812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000016700780cULL, 0x000fe40003f65270ULL,
0x0000005e1700720bULL, 0x000fe20003f34000ULL, 0x000119827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000175e157209ULL, 0x000fe40007810000ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff707819ULL, 0x000fe20000011666ULL,
0x800000155e287221ULL, 0x000fe20000010000ULL, 0x010480155300b388ULL, 0x0003e20000000800ULL,
0x0000001429ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x00000028003d7308ULL, 0x000ee40000000800ULL, 0x0000003d5d5d7220ULL, 0x008fe20000410000ULL,
0x000119227f007947ULL, 0x000fea000b800000ULL, 0x00001f703d307589ULL, 0x0022e400000e0000ULL,
0x000000300c0c7220ULL, 0x08cfe20000410000ULL, 0x000000300d0d7220ULL, 0x080fe20000410000ULL,
0x0000003008087220ULL, 0x080fe20000410000ULL, 0x0000003009097220ULL, 0x080fe20000410000ULL,
0x0000003004047220ULL, 0x080fe20000410000ULL, 0x0000003005057220ULL, 0x080fe20000410000ULL,
0x0000003010107220ULL, 0x080fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x000fe20000410000ULL,
0x000118527f007947ULL, 0x000fea000b800000ULL, 0x00001f503d307589ULL, 0x0004e400000e0000ULL,
0x000000175e5e7209ULL, 0x000fe20007810000ULL, 0x000000300e0e7220ULL, 0x08cfe20000410000ULL,
0x00000001ff737807ULL, 0x000fe20000800000ULL, 0x000000300f0f7220ULL, 0x080fe20000410000ULL,
0x000000300a0a7220ULL, 0x080fe20000410000ULL, 0x8000005e17171221ULL, 0x000fe20000010000ULL,
0x000000300b0b7220ULL, 0x080fe20000410000ULL, 0x0000003006067220ULL, 0x080fe20000410000ULL,
0x0000003007077220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b17171820ULL, 0x000fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x0000001700511308ULL, 0x000ea20000000800ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x000fe20000410000ULL, 0x0000001651161220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000005d165d7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff147984ULL, 0x000ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fc40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x000724000021f000ULL,
0x3fa0000014147823ULL, 0x008fe200000100ffULL, 0x000000150000735dULL, 0x010fe20003800000ULL,
0x0106ac00ff167984ULL, 0x000ee40000000800ULL, 0x8000000016ff7812ULL, 0x008fe40007824831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000051ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff707819ULL, 0x002fc40000011666ULL, 0x00005410143d7816ULL, 0x000fe20000000014ULL,
0x000115f27f007947ULL, 0x000fea000b800000ULL, 0x00001f703d3b7589ULL, 0x0002e400000e0000ULL,
0x000116327f007947ULL, 0x000fea000b800000ULL, 0x00001f503d3a7589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e006dULL,
0x000051c000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0001229000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e004fULL,
0x0000522000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0001223000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004e2c783bULL, 0x000f280000004200ULL,
0x000000004d30783bULL, 0x004fe80000004200ULL, 0x000000004c14783bULL, 0x000ea80000004200ULL,
0x000000004b28783bULL, 0x000ee20000004200ULL, 0x00000018ff717819ULL, 0x010fe2000001142cULL,
0x000001002c757824ULL, 0x040fe200078e00ffULL, 0x000088802c747816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe2000001142dULL,
0x000001002d787824ULL, 0x040fe200078e00ffULL, 0x000088802d777816ULL, 0x040fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x000001002f7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001142eULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000088802e7a7816ULL, 0x000fe200000000ffULL,
0x0000010016907824ULL, 0x004fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x00000018ff7e7819ULL, 0x000fe4000001147cULL, 0x00000018ff707819ULL, 0x002fe2000001142fULL,
0x0000002c00767306ULL, 0x0003e20000200c00ULL, 0x000088802f7d7816ULL, 0x040fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe40000011430ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d00797306ULL, 0x0005e20000200c00ULL, 0x000001002e2c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011414ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x00000100302d7824ULL, 0x044fe200078e00ffULL,
0x0000002c007b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe40000011415ULL,
0x00008880158b7816ULL, 0x000fe400000000ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff3c7819ULL, 0x000fe20000011416ULL, 0x0000002e007c7306ULL, 0x0005e20000200c00ULL,
0x00008880302c7816ULL, 0x042fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fc40000011417ULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000002c00807306ULL, 0x0003e20000200c00ULL,
0x00000100312e7824ULL, 0x044fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe40000011431ULL,
0x0000888031837816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x0000002d00817306ULL, 0x0005220000200c00ULL,
0x00008880322c7816ULL, 0x002fc400000000ffULL, 0x00000018ff697819ULL, 0x000fe40000011432ULL,
0x00000018ff6a7819ULL, 0x000fe40000011433ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000002c00857306ULL, 0x0003e20000200c00ULL, 0x00000100322d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff387819ULL, 0x008fe20000011428ULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011429ULL, 0x00000018ff2d7819ULL, 0x000fc4000001142dULL,
0x0000002f007f7306ULL, 0x0005e20000200c00ULL, 0x00000100142c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000541080807816ULL, 0x010fe40000000081ULL,
0x00000018ff377819ULL, 0x000fe4000001142bULL, 0x0000002e00847306ULL, 0x0003e20000200c00ULL,
0x00000100332f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc8000001142aULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x0000003000827306ULL, 0x0005e20000200c00ULL,
0x00008880332e7816ULL, 0x042fe200000000ffULL, 0x0001000033337824ULL, 0x000fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000002d00867306ULL, 0x0002e20000200c00ULL,
0x00000018ff307819ULL, 0x004fe4000001142cULL, 0x0000a8004a2c7811ULL, 0x000fca00078e20ffULL,
0x0000002e00877306ULL, 0x0005e20000200c00ULL, 0x00008880142d7816ULL, 0x042fe200000000ffULL,
0x0001000014147824ULL, 0x000fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000002f00887306ULL, 0x000e620000200c00ULL, 0x00000100152e7824ULL, 0x004fe200078e00ffULL,
0x0000541085867816ULL, 0x008fe20000000086ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001142eULL, 0x0000002d00897306ULL, 0x0005e20000200c00ULL,
0x00000018ff157819ULL, 0x000fce0000011415ULL, 0x0000008d008e7306ULL, 0x0007e20000200c00ULL,
0x000000002c2c783bULL, 0x004ea20000000200ULL, 0x0000541087877816ULL, 0x002fcc0000000088ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x00009910738d7816ULL, 0x008fe200000000ffULL,
0x0000010017737824ULL, 0x000fc600078e00ffULL, 0x000000ff8d00720cULL, 0x000fc60003f25270ULL,
0x0000007700777306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000ee20000200c00ULL,
0x0000541074747816ULL, 0x002fce0000000075ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x00000014008c7306ULL, 0x0009e20000200c00ULL, 0x0000003b2c2c9232ULL, 0x084fe20000000000ULL,
0x0000541077757816ULL, 0x008fe20000000078ULL, 0x0000003b2e2e9232ULL, 0x000fc40000000000ULL,
0x0000003a2d2d9232ULL, 0x080fe40000000000ULL, 0x0000003a2f2f9232ULL, 0x000fe20000000000ULL,
0x00000030008a7306ULL, 0x0004e20000200c00ULL, 0x0000888017147816ULL, 0x050fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000541076767816ULL, 0x002fc60000000071ULL,
0x000000742c0c723cULL, 0x000fe2000000180cULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001400927306ULL, 0x0003e20000200c00ULL, 0x0000888016307816ULL, 0x044fe200000000ffULL,
0x0001000016167824ULL, 0x000fc600078e00ffULL, 0x0000010029757824ULL, 0x000fe200078e00ffULL,
0x000000862c20723cULL, 0x000fe20000001820ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x00000015008f7306ULL, 0x0005e20000200c00ULL, 0x0000888028147816ULL, 0x002fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00005410898a7816ULL, 0x008fe2000000008aULL,
0x000000ffff747224ULL, 0x000fe200078e0014ULL, 0x0000a80049147811ULL, 0x000fe200078e20ffULL,
0x0000009000917306ULL, 0x000fe20000200c00ULL, 0x00000018ff157819ULL, 0x004fce0000011473ULL,
0x0000001500937306ULL, 0x0003f00000200c00ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000010028157824ULL, 0x042fe400078e00ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff717819ULL, 0x000fe40000011415ULL, 0x0000001600737306ULL, 0x000fe20000200c00ULL,
0x00000018ff287819ULL, 0x000fce0000011428ULL, 0x0000001700907306ULL, 0x0003e20000200c00ULL,
0x000054107a7a7816ULL, 0x004fce000000007bULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000008300837306ULL, 0x000ef00000200c00ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000054107d7b7816ULL, 0x004fce000000007eULL, 0x0000003100317306ULL, 0x000ea20000200c00ULL,
0x0000007a2c04723cULL, 0x000fe20000001804ULL, 0x0000541083817816ULL, 0x008fcc0000000084ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x000000802c18723cULL, 0x000fe20000001818ULL,
0x0000003b14149232ULL, 0x082fe40000000000ULL, 0x0000003b16169232ULL, 0x000fe40000000000ULL,
0x0000003a15159232ULL, 0x080fe40000000000ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541031837816ULL, 0x004fe2000000006eULL, 0x000001002a317824ULL, 0x000fe200078e00ffULL,
0x0000003a17179232ULL, 0x000fc80000000000ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x0000541079777816ULL, 0x008fe40000000072ULL,
0x0000888029727816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fc800078e00ffULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x000054107c7c7816ULL, 0x002fe2000000006fULL,
0x000000762c08723cULL, 0x000fe20000001808ULL, 0x00000018ff297819ULL, 0x000fca0000011429ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054107f7d7816ULL, 0x004fce0000000070ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541082827816ULL, 0x008fe2000000006bULL,
0x0000007c2c10723cULL, 0x040fec0000001810ULL, 0x0000003200327306ULL, 0x000e640000200c00ULL,
0x000000822c1c723cULL, 0x000fec000000181cULL, 0x0000003300337306ULL, 0x000eb00000200c00ULL,
0x0000003000307306ULL, 0x000ee20000200c00ULL, 0x0000541032327816ULL, 0x002fc40000000069ULL,
0x0000541033337816ULL, 0x004fca000000006aULL, 0x00000028006f7306ULL, 0x0003e40000200c00ULL,
0x000000322c24723cULL, 0x000fe20000001824ULL, 0x0000541030307816ULL, 0x008fca0000000091ULL,
0x00000031002c7306ULL, 0x0005e20000200c00ULL, 0x000088802a287816ULL, 0x042fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142aULL,
0x00000029006e7306ULL, 0x0003e20000200c00ULL, 0x0000541092317816ULL, 0x004fce0000000093ULL,
0x00000028003b7306ULL, 0x0004e20000200c00ULL, 0x000088802b297816ULL, 0x042fe200000000ffULL,
0x000000301404723cULL, 0x000fec0000001804ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000001002b287824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe40000011428ULL, 0x00000018ff307819ULL, 0x000fe2000001142bULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000054103b2c7816ULL, 0x008fe4000000002cULL,
0x000054108c8c7816ULL, 0x002fca000000003fULL, 0x0000003c003c7306ULL, 0x000e700000200c00ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x000054108f8d7816ULL, 0x004fce000000003eULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x0000541073287816ULL, 0x002fe2000000003cULL,
0x0000008c1408723cULL, 0x000fec0000001808ULL, 0x0000003900397306ULL, 0x000e700000200c00ULL,
0x0000008b008b7306ULL, 0x000ee20000200c00ULL, 0x000054106f387816ULL, 0x004fce0000000038ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000054106e397816ULL, 0x002fce0000000039ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000054108b8b7816ULL, 0x008fe2000000008eULL,
0x00000038141c723cULL, 0x040fec000000181cULL, 0x0000007200727306ULL, 0x000fe40000200c00ULL,
0x0000008a140c723cULL, 0x000fec000000180cULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000541074747816ULL, 0x002fce0000000071ULL, 0x0000002900327306ULL, 0x0003f00000200c00ULL,
0x0000002e00337306ULL, 0x000ee20000200c00ULL, 0x0000541090297816ULL, 0x002fe4000000003dULL,
0x0000541072757816ULL, 0x004fca0000000075ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000000281428723cULL, 0x040fee0000001810ULL, 0x0000003700377306ULL, 0x000fe20000200c00ULL,
0x000000741418723cULL, 0x000fee0000001818ULL, 0x0000002d002f7306ULL, 0x0006700000200c00ULL,
0x0000003000307306ULL, 0x000ea20000200c00ULL, 0x00005410322d7816ULL, 0x008fc40000000033ULL,
0x000054102f367816ULL, 0x002fca0000000036ULL, 0x0000002c1420723cULL, 0x000fe20000001820ULL,
0x0000541030377816ULL, 0x004fce0000000037ULL, 0x000000361414723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff127f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007844813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007844813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff2f7819ULL, 0x000fe20000011666ULL, 0x000058005f6a7a24ULL, 0x020fe200078e02ffULL,
0x0000008064107811ULL, 0x000fc400078e40ffULL, 0x000000022f317810ULL, 0x000fe20007ffe0ffULL,
0x0000000160697824ULL, 0x000fe200078e022fULL, 0x0000001065117217ULL, 0x000fe20007800000ULL,
0x000000806a6a7824ULL, 0x000fe400078e00ffULL, 0x0000008068337824ULL, 0x000fe400078e0269ULL,
0x0000000111117824ULL, 0x000fc600078e0a10ULL, 0x0000006a33127210ULL, 0x040fe40007f5e0ffULL,
0x0000000233277810ULL, 0x000fe40007ffe0ffULL, 0x0000002011117807ULL, 0x000fe20000000000ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e00122d7a11ULL, 0x000fe400078440ffULL,
0x0000001160117217ULL, 0x000fe40007800000ULL, 0x00005f0012127a11ULL, 0x000fc400010f4413ULL,
0x0000006a27277210ULL, 0x080fe20007f5e0ffULL, 0x0000000111267824ULL, 0x000fe200078e0a60ULL,
0x0000000433137810ULL, 0x040fe40007ffe0ffULL, 0x0000000633337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x0000006a132e7210ULL, 0x000fe40007f9e0ffULL,
0x00005e0027137a11ULL, 0x000fe400078640ffULL, 0x000000263100720cULL, 0x000fe20003f46070ULL,
0x000000ffff117224ULL, 0x000fe200020e06ffULL, 0x00005f0027277a11ULL, 0x000fc400018f4410ULL,
0x00005e002e257a11ULL, 0x040fe400078840ffULL, 0x000000582d107210ULL, 0x000fe40007fbe0ffULL,
0x00005f002e2e7a11ULL, 0x000fe400020f4411ULL, 0x0000006a332c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0612ULL, 0x0000005813127210ULL, 0x080fe40007fde0ffULL,
0x0000005825247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e06ffULL,
0x000000042f317810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200030e0627ULL,
0x000000262f00720cULL, 0x040fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200028e062eULL,
0x000000062f2f7810ULL, 0x000fc40007ffe0ffULL, 0x00005e002c277a11ULL, 0x040fe400078840ffULL,
0x000000263100720cULL, 0x080fe40003fc6070ULL, 0x000000262f00720cULL, 0x000fe40003fa6070ULL,
0x00005f002c2c7a11ULL, 0x000fe400020f442dULL, 0x0000005827267210ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010487faeULL, 0x0003e8000d901c46ULL,
0x000000ffff277224ULL, 0x000fe200020e062cULL, 0x0000000012477faeULL, 0x0003e8000d101c46ULL,
0x0000000024467faeULL, 0x0003e8000f101c46ULL, 0x0000000026457faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff117984ULL, 0x002e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x00000001606b7824ULL, 0x000fe200078e022fULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff707819ULL, 0x000fe40000011666ULL,
0x00005410103d7816ULL, 0x000fe20000000010ULL, 0x000100d27f007947ULL, 0x000fea000b800000ULL,
0x00001f703d397589ULL, 0x0002a400000e0000ULL, 0x000101127f007947ULL, 0x000fea000b800000ULL,
0x00001f503d3a7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e006dULL, 0x000067b000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00010ca000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e004fULL, 0x0000681000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00010c4000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000432c783bULL, 0x000f680000004200ULL, 0x000000004224783bULL, 0x000fe80000004200ULL,
0x000000004434783bULL, 0x000e680000004200ULL, 0x000000004110783bULL, 0x000ee20000004200ULL,
0x00000018ff6f7819ULL, 0x020fe2000001142cULL, 0x000001002c7e7824ULL, 0x040fe200078e00ffULL,
0x000088802c7d7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x002fe2000001142dULL, 0x000001002d807824ULL, 0x040fe200078e00ffULL,
0x000088802d7f7816ULL, 0x040fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000001002e857824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011480ULL, 0x0000010034767824ULL, 0x000fe200078e00ffULL,
0x0000002c00807306ULL, 0x0003e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe2000001142eULL,
0x0000010035787824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001142fULL,
0x00000100258d7824ULL, 0x000fe200078e00ffULL, 0x000088802e847816ULL, 0x040fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000008100827306ULL, 0x000be20000200c00ULL, 0x000001002f2c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011434ULL, 0x0000010026917824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x00000100367a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000100377c7824ULL, 0x000fe200078e00ffULL,
0x0000002d00837306ULL, 0x0003e20000200c00ULL, 0x000088802f817816ULL, 0x060fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fc40000011435ULL,
0x0000888034757816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002c00887306ULL, 0x000be20000200c00ULL,
0x00000100242d7824ULL, 0x002fe200078e00ffULL, 0x0000888035777816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x0000008100877306ULL, 0x0003e20000200c00ULL,
0x0000a800402c7811ULL, 0x020fc400078e20ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff3e7819ULL, 0x000fe40000011424ULL, 0x00008880248a7816ULL, 0x040fe200000000ffULL,
0x0000002e00867306ULL, 0x000fe20000200c00ULL, 0x00000018ff817819ULL, 0x002fe2000001142dULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x008fe40000011425ULL,
0x00008880258c7816ULL, 0x040fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002f00897306ULL, 0x0003e20000200c00ULL,
0x00000018ff8e7819ULL, 0x000fc4000001148dULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff3b7819ULL, 0x000fe40000011426ULL, 0x00000018ff3c7819ULL, 0x000fe20000011427ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000000002c2c783bULL, 0x002e620000000200ULL,
0x0000888027937816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe40000011436ULL,
0x00000018ff727819ULL, 0x000fc40000011437ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000888036797816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00008880377b7816ULL, 0x040fe200000000ffULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe40000011485ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000003400347306ULL, 0x000ee20000200c00ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000018ff787819ULL, 0x000fc40000011478ULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000003500357306ULL, 0x000f620000200c00ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff337819ULL, 0x000fe40000011410ULL,
0x00000018ff387819ULL, 0x000fe40000011411ULL, 0x00000018ff307819ULL, 0x004fe20000011412ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541034347816ULL, 0x008fe20000000073ULL,
0x0000010011737824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011413ULL,
0x00000018ff917819ULL, 0x000fe40000011491ULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000000392c2c9232ULL, 0x082fe20000000000ULL,
0x0000541035357816ULL, 0x020fe20000000074ULL, 0x000000392e2e9232ULL, 0x000fe40000000000ULL,
0x0000003a2d2d9232ULL, 0x090fe40000000000ULL, 0x0000003a2f2f9232ULL, 0x000fe20000000000ULL,
0x00000024008d7306ULL, 0x0003ec0000200c00ULL, 0x000000342c08723cULL, 0x000fe40000001808ULL,
0x00000081008b7306ULL, 0x0007e20000200c00ULL, 0x0000010027247824ULL, 0x002fe200078e00ffULL,
0x0000541075767816ULL, 0x004fe20000000076ULL, 0x0001000027277824ULL, 0x000fc400078e00ffULL,
0x0000888011357816ULL, 0x040fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000002500907306ULL, 0x0003e20000200c00ULL,
0x0000888026817816ULL, 0x048fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000002400947306ULL, 0x0005e20000200c00ULL,
0x0000888010257816ULL, 0x002fca00000000ffULL, 0x000000ffff757224ULL, 0x000fe400078e0025ULL,
0x0000010010257824ULL, 0x040fe200078e00ffULL, 0x0000a80003247811ULL, 0x004fe200078e20ffULL,
0x0000008e008f7306ULL, 0x000fe20000200c00ULL, 0x0001000010107824ULL, 0x000fe400078e00ffULL,
0x00000018ff347819ULL, 0x000fc60000011425ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000026008e7306ULL, 0x000ff00000200c00ULL, 0x0000002700957306ULL, 0x0003f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000000200ULL,
0x0000007200727306ULL, 0x000ff00000200c00ULL, 0x0000003600367306ULL, 0x000eb00000200c00ULL,
0x0000003700377306ULL, 0x000ef00000200c00ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000541036367816ULL, 0x004fce0000000071ULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x0000541037377816ULL, 0x008fe20000000072ULL, 0x0000003924249232ULL, 0x082fe40000000000ULL,
0x0000003926269232ULL, 0x000fe20000000000ULL, 0x0000010012397824ULL, 0x000fe200078e00ffULL,
0x0000003a25259232ULL, 0x080fe40000000000ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x000000362c28723cULL, 0x000fe20000001828ULL, 0x0000003a27279232ULL, 0x000fe20000000000ULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000541084847816ULL, 0x004fe40000000085ULL, 0x0000541087857816ULL, 0x000fca0000000088ULL,
0x0000003f003f7306ULL, 0x000ea20000200c00ULL, 0x0000541080807816ULL, 0x002fe2000000006fULL,
0x000000842c20723cULL, 0x000fec0000001820ULL, 0x0000006e006e7306ULL, 0x000e700000200c00ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x0000541086867816ULL, 0x004fce000000003fULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541089877816ULL, 0x002fce000000006eULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000000862c14723cULL, 0x000fee0000001814ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541077777816ULL, 0x004fce0000000078ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000000762c0c723cULL, 0x000fee000000180cULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x00005410797a7816ULL, 0x002fce000000007aULL,
0x0000007d007d7306ULL, 0x000ff00000200c00ULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x000054107b7b7816ULL, 0x004fce000000007cULL, 0x0000007f007f7306ULL, 0x000ea20000200c00ULL,
0x0000007a2c04723cULL, 0x000fee0000001804ULL, 0x0000003b003b7306ULL, 0x000ee20000200c00ULL,
0x000054107d7e7816ULL, 0x002fce000000007eULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x000054107f7f7816ULL, 0x004fce0000000082ULL, 0x0000001000367306ULL, 0x0005e20000200c00ULL,
0x0000007e2c18723cULL, 0x000fee0000001818ULL, 0x0000008100927306ULL, 0x0009e20000200c00ULL,
0x0000888012107816ULL, 0x044fe200000000ffULL, 0x0001000012127824ULL, 0x000fcc00078e00ffULL,
0x00000010006e7306ULL, 0x0005e20000200c00ULL, 0x0000541083817816ULL, 0x010fce0000000070ULL,
0x0000001100377306ULL, 0x0009e20000200c00ULL, 0x0000010013107824ULL, 0x044fe200078e00ffULL,
0x000000802c1c723cULL, 0x000fec000000181cULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x0000888013117816ULL, 0x050fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fc40000011410ULL, 0x000054108e107816ULL, 0x008fe4000000003bULL,
0x00000018ff2c7819ULL, 0x000fe20000011412ULL, 0x00000011006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fce0000011413ULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x0000541095117816ULL, 0x002fe4000000003cULL, 0x000054108a8a7816ULL, 0x004fca000000008bULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000000102410723cULL, 0x000fee0000001828ULL,
0x0000003300337306ULL, 0x000ea20000200c00ULL, 0x000054108d3e7816ULL, 0x008fce000000003eULL,
0x0000003800387306ULL, 0x000ee20000200c00ULL, 0x00005410903f7816ULL, 0x002fce000000003dULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x0000541036367816ULL, 0x004fe20000000033ULL,
0x0000003e2408723cULL, 0x000fec0000001808ULL, 0x0000009100917306ULL, 0x000ea20000200c00ULL,
0x0000541037377816ULL, 0x008fce0000000038ULL, 0x0000009300937306ULL, 0x000ee20000200c00ULL,
0x000054108c8b7816ULL, 0x002fe2000000008fULL, 0x00000036241c723cULL, 0x040fec000000181cULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x0000541092927816ULL, 0x004fe20000000091ULL,
0x0000008a240c723cULL, 0x000fec000000180cULL, 0x0000003400347306ULL, 0x000e620000200c00ULL,
0x0000541093937816ULL, 0x008fce0000000094ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x000000922404723cULL, 0x000fee0000001804ULL, 0x0000007300727306ULL, 0x000ea20000200c00ULL,
0x0000541075347816ULL, 0x002fce0000000034ULL, 0x0000003900397306ULL, 0x000e700000200c00ULL,
0x0000002e002e7306ULL, 0x000ee20000200c00ULL, 0x0000541035357816ULL, 0x004fce0000000072ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x000054106e6e7816ULL, 0x002fe20000000039ULL,
0x000000342418723cULL, 0x000fec0000001818ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000054106f6f7816ULL, 0x008fce000000002eULL, 0x0000002c002d7306ULL, 0x000e620000200c00ULL,
0x0000006e2420723cULL, 0x000fee0000001820ULL, 0x0000002f00297306ULL, 0x000ea20000200c00ULL,
0x000054102d287816ULL, 0x002fe40000000030ULL, 0x0000541029297816ULL, 0x004fce0000000032ULL,
0x000000282424723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008064147811ULL, 0x002fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000146500720cULL, 0x000fda0003f24070ULL,
0x0000641000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007824815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400167305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000160000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff167984ULL, 0x000e640000000800ULL, 0x8000000016ff7812ULL, 0x002fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff167819ULL, 0x000fe40000011666ULL,
0x00000020682b7811ULL, 0x000fe400078e38ffULL, 0x000000a064147811ULL, 0x000fe400078e40ffULL,
0x000000162b157210ULL, 0x000fe40007ffe060ULL, 0x0000001465177217ULL, 0x000fe40007800000ULL,
0x000000156a157210ULL, 0x000fc40007f3e0ffULL, 0x0000000616307810ULL, 0x040fe20007ffe0ffULL,
0x0000000117147824ULL, 0x000fe200078e0a14ULL, 0x0000000216347810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x00005e0015357a11ULL, 0x040fe400078240ffULL,
0x0000000416327810ULL, 0x000fe40007ffe0ffULL, 0x00005f0015287a11ULL, 0x000fe400008f4428ULL,
0x000000302b157210ULL, 0x000fc40007ffe060ULL, 0x000000342b297210ULL, 0x140fe40007ffe060ULL,
0x000000322b177210ULL, 0x100fe40007ffe060ULL, 0x00000020142b7807ULL, 0x000fe40000000000ULL,
0x000000156a157210ULL, 0x040fe40007f7e0ffULL, 0x000000176a177210ULL, 0x000fe40007f5e0ffULL,
0x0000002b602b7217ULL, 0x000fe20007800000ULL, 0x000000ffff2c7224ULL, 0x000fe200018e06ffULL,
0x000000296a2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00005e00152d7a11ULL, 0x000fe200078640ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0a60ULL,
0x00005e0017297a11ULL, 0x000fe200078440ffULL, 0x000000ffff337224ULL, 0x000fe200008e06ffULL,
0x00005e002e2f7a11ULL, 0x000fc400078240ffULL, 0x00005f00152c7a11ULL, 0x000fe400018f442cULL,
0x0000005835147210ULL, 0x080fe40007f7e0ffULL, 0x00005f00172a7a11ULL, 0x000fe400010f442aULL,
0x0000002b1600720cULL, 0x000fe20003f46070ULL, 0x000000ffff157224ULL, 0x000fe200018e0628ULL,
0x00005f002e2e7a11ULL, 0x000fe400008f4433ULL, 0x000000582f167210ULL, 0x000fc40007f9e0ffULL,
0x0000005829287210ULL, 0x080fe40007fbe0ffULL, 0x0000002b3400720cULL, 0x080fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe200020e062eULL, 0x0000002b3200720cULL, 0x080fe20003f66070ULL,
0x000000ffff297224ULL, 0x000fe200028e062aULL, 0x0000002b3000720cULL, 0x000fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e2000d101c46ULL,
0x000000582d2a7210ULL, 0x000fca0007fbe0ffULL, 0x000000ffff2b7224ULL, 0x000fe400028e062cULL,
0x0000000016567faeULL, 0x0003e8000c901c46ULL, 0x0000000028557faeULL, 0x0003e8000d901c46ULL,
0x000000002a547faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff6e7f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff147984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106480060167f8cULL, 0x000fe2000c80043fULL,
0x8000000014ff7812ULL, 0x002fc60007844831ULL, 0x01064c0060157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007824817ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x0002e4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x008fe40003800000ULL,
0x01064c0060157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007824817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101000053177984ULL, 0x000e680000000800ULL,
0x0103000053167984ULL, 0x0007220000000800ULL, 0x0000005e1700720bULL, 0x002fe20003f3d000ULL,
0x0000eb127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800008e0100ULL,
0x0000ffff14297812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff797424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000026700780cULL, 0x000fe40003f65270ULL, 0x0000005e1700720bULL, 0x000fe20003f34000ULL,
0x0000eae27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000175e157209ULL, 0x000fe40007810000ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff707819ULL, 0x000fe20000011666ULL, 0x800000155e287221ULL, 0x000fe20000010000ULL,
0x010500155300b388ULL, 0x0003e20000000800ULL, 0x0000001429ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028003d7308ULL, 0x000ee40000000800ULL,
0x0000003d5d5d7220ULL, 0x008fe20000410000ULL, 0x0000ea827f007947ULL, 0x000fea000b800000ULL,
0x00001f703d307589ULL, 0x0022e400000e0000ULL, 0x000000300c0c7220ULL, 0x08cfe20000410000ULL,
0x000000300d0d7220ULL, 0x080fe20000410000ULL, 0x0000003008087220ULL, 0x080fe20000410000ULL,
0x0000003009097220ULL, 0x080fe20000410000ULL, 0x0000003004047220ULL, 0x080fe20000410000ULL,
0x0000003005057220ULL, 0x080fe20000410000ULL, 0x0000003010107220ULL, 0x080fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x000fe20000410000ULL, 0x0000e9b27f007947ULL, 0x000fea000b800000ULL,
0x00001f503d307589ULL, 0x0004e400000e0000ULL, 0x000000175e5e7209ULL, 0x000fe20007810000ULL,
0x000000300e0e7220ULL, 0x08cfe20000410000ULL, 0x00000001ff797807ULL, 0x000fe20000800000ULL,
0x000000300f0f7220ULL, 0x080fe20000410000ULL, 0x000000300a0a7220ULL, 0x080fe20000410000ULL,
0x8000005e17171221ULL, 0x000fe20000010000ULL, 0x000000300b0b7220ULL, 0x080fe20000410000ULL,
0x0000003006067220ULL, 0x080fe20000410000ULL, 0x0000003007077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b17171820ULL, 0x000fe20000410000ULL, 0x0000003012127220ULL, 0x080fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x0000001700511308ULL, 0x000ea20000000800ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x000fe20000410000ULL,
0x0000001651161220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000005d165d7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff147984ULL, 0x000ee40000000800ULL,
0x8000000014ff7812ULL, 0x008fc40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x000724000021f000ULL, 0x3fa0000014147823ULL, 0x008fe200000100ffULL,
0x000000150000735dULL, 0x010fe20003800000ULL, 0x0106ac00ff167984ULL, 0x000ee40000000800ULL,
0x8000000016ff7812ULL, 0x008fe40007824831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff707819ULL, 0x002fc40000011666ULL,
0x00005410143d7816ULL, 0x000fe20000000014ULL, 0x0000e7527f007947ULL, 0x000fea000b800000ULL,
0x00001f703d757589ULL, 0x0002e400000e0000ULL, 0x0000e7927f007947ULL, 0x000fea000b800000ULL,
0x00001f503d3c7589ULL, 0x00086400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e006dULL, 0x0000835000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000f10000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e004fULL, 0x000083b000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000f0a000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004e30783bULL, 0x004ea20000004200ULL, 0x0000991079957816ULL, 0x000fc600000000ffULL,
0x000000004d28783bULL, 0x000fe20000004200ULL, 0x000000ff9500720cULL, 0x000fc60003f25270ULL,
0x000000004c2c783bULL, 0x000f680000004200ULL, 0x000000004b14783bULL, 0x000f220000004200ULL,
0x00000018ff3a7819ULL, 0x004fe20000011430ULL, 0x00000100303e7824ULL, 0x042fe200078e00ffULL,
0x00008880303d7816ULL, 0x050fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe20000011431ULL, 0x00000100317a7824ULL, 0x040fe200078e00ffULL,
0x00008880313f7816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x000001002f797824ULL, 0x020fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fc40000011432ULL, 0x00008880327b7816ULL, 0x040fe400000000ffULL,
0x00008880337c7816ULL, 0x000fe200000000ffULL, 0x00000030007d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff347819ULL, 0x000fe40000011428ULL,
0x00000018ff377819ULL, 0x000fe40000011433ULL, 0x00000018ff357819ULL, 0x000fe20000011429ULL,
0x0000007a007e7306ULL, 0x0005e20000200c00ULL, 0x0000010032307824ULL, 0x042fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe2000001142aULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc4000001142bULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000007b007f7306ULL, 0x0003e20000200c00ULL, 0x00000100337a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff777819ULL, 0x000fe4000001142cULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000007c00817306ULL, 0x0005e20000200c00ULL,
0x00008880287b7816ULL, 0x002fc400000000ffULL, 0x00000018ff787819ULL, 0x000fe4000001142dULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff747819ULL, 0x000fe2000001142eULL,
0x0000003100807306ULL, 0x0003e20000200c00ULL, 0x00000100287c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001142fULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011414ULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x0000007a00827306ULL, 0x0005e20000200c00ULL, 0x0001000033317824ULL, 0x002fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x00000018ff737819ULL, 0x000fe40000011415ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003200337306ULL, 0x0003e20000200c00ULL,
0x00008880297a7816ULL, 0x004fe400000000ffULL, 0x00000018ff707819ULL, 0x000fc40000011416ULL,
0x00000018ff717819ULL, 0x000fc60000011417ULL, 0x0000002800857306ULL, 0x0005e20000200c00ULL,
0x0000010029327824ULL, 0x042fe400078e00ffULL, 0x0001000029297824ULL, 0x000fc600078e00ffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000001002b287824ULL, 0x004fe200078e00ffULL, 0x0000003100847306ULL, 0x0003e80000200c00ULL,
0x00000018ff287819ULL, 0x000fc80000011428ULL, 0x0000007b00837306ULL, 0x0005e20000200c00ULL,
0x000088802a317816ULL, 0x002fce00000000ffULL, 0x0000007a00877306ULL, 0x0003e20000200c00ULL,
0x000088802b7b7816ULL, 0x044fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002900887306ULL, 0x0005e20000200c00ULL,
0x000001002a7a7824ULL, 0x042fe400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000003100897306ULL, 0x0003e20000200c00ULL,
0x000001002c297824ULL, 0x004fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fcc000001142aULL,
0x00000028008d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff317819ULL, 0x002fe20000011429ULL,
0x000001002d297824ULL, 0x000fcc00078e00ffULL, 0x0000007b008c7306ULL, 0x0003e20000200c00ULL,
0x0000b0004a287811ULL, 0x004fce00078e20ffULL, 0x0000002a008b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff7b7819ULL, 0x002fce0000011429ULL, 0x0000002b008e7306ULL, 0x0003f00000200c00ULL,
0x0000007c00867306ULL, 0x0005e20000200c00ULL, 0x000000002828783bULL, 0x002e6e0000000200ULL,
0x0000003e003e7306ULL, 0x000f220000200c00ULL, 0x000088802c7c7816ULL, 0x044fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000007a008a7306ULL, 0x0005f00000200c00ULL, 0x0000003a003a7306ULL, 0x000f620000200c00ULL,
0x000088802d7a7816ULL, 0x044fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x000054103d3e7816ULL, 0x010fc8000000003eULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000003b003b7306ULL, 0x000eb00000200c00ULL, 0x0000002c00907306ULL, 0x0009e20000200c00ULL,
0x0000007528289232ULL, 0x00afc40000000000ULL, 0x000000752a2a9232ULL, 0x000fe40000000000ULL,
0x0000003c29299232ULL, 0x080fe40000000000ULL, 0x0000003c2b2b9232ULL, 0x000fe20000000000ULL,
0x00000031008f7306ULL, 0x0003e20000200c00ULL, 0x000088802f2c7816ULL, 0x050fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff967819ULL, 0x000fe2000001142fULL,
0x0000002c00947306ULL, 0x0007e20000200c00ULL, 0x000001002e317824ULL, 0x002fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000002d00937306ULL, 0x0003e20000200c00ULL,
0x00008880142c7816ULL, 0x008fca00000000ffULL, 0x000000ffff3d7224ULL, 0x000fe200078e002cULL,
0x000054107d2c7816ULL, 0x020fe2000000003aULL, 0x0000007a00917306ULL, 0x0007e20000200c00ULL,
0x00000018ff2d7819ULL, 0x002fe40000011479ULL, 0x00008880153a7816ULL, 0x000fca00000000ffULL,
0x0000002d00957306ULL, 0x0005e20000200c00ULL, 0x000088802e7a7816ULL, 0x048fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x00005410802d7816ULL, 0x004fce000000003bULL,
0x0000007b00927306ULL, 0x000eb00000200c00ULL, 0x00000031007b7306ULL, 0x0007e20000200c00ULL,
0x000054107f307816ULL, 0x002fce0000000030ULL, 0x0000002e00797306ULL, 0x0003e20000200c00ULL,
0x0000b00049317811ULL, 0x008fe400078e20ffULL, 0x00005410917d7816ULL, 0x004fca0000000092ULL,
0x0000003f003f7306ULL, 0x000ea20000200c00ULL, 0x0000002c282c723cULL, 0x002fe20000001808ULL,
0x000000003108783bULL, 0x0002ec0000000200ULL, 0x0000003200327306ULL, 0x000f220000200c00ULL,
0x0000541081317816ULL, 0x002fce0000000082ULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x000000302804723cULL, 0x000fe20000001804ULL, 0x000054103f3f7816ULL, 0x004fcc000000007eULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000010015307824ULL, 0x000fe200078e00ffULL,
0x0000541087317816ULL, 0x010fe20000000032ULL, 0x0000003e280c723cULL, 0x000fe6000000180cULL,
0x00000018ff3b7819ULL, 0x000fe40000011430ULL, 0x0000003400347306ULL, 0x000f220000200c00ULL,
0x0000541083307816ULL, 0x000fe20000000086ULL, 0x00000100143e7824ULL, 0x040fe200078e00ffULL,
0x0000541033367816ULL, 0x002fe20000000036ULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x0000541084377816ULL, 0x004fe20000000037ULL, 0x000000302830723cULL, 0x040fe20000001818ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000007508089232ULL, 0x088fe40000000000ULL,
0x000000750a0a9232ULL, 0x000fe40000000000ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x0001000015187824ULL, 0x000fe200078e00ffULL, 0x0000541085347816ULL, 0x010fe20000000034ULL,
0x0000010016197824ULL, 0x000fe200078e00ffULL, 0x000000362810723cULL, 0x000fe20000001810ULL,
0x0000003c09099232ULL, 0x080fe20000000000ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000003c0b0b9232ULL, 0x000fe20000000000ULL, 0x0000003900397306ULL, 0x000ea20000200c00ULL,
0x0000541088357816ULL, 0x002fce0000000035ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x000000342834723cULL, 0x000fee000000181cULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000054108e3f7816ULL, 0x004fe20000000039ULL, 0x00000100171e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc40000011419ULL, 0x00008880171d7816ULL, 0x000fc600000000ffULL,
0x0000003e00997306ULL, 0x0005f00000200c00ULL, 0x0000003a007f7306ULL, 0x0007e20000200c00ULL,
0x000054108b3e7816ULL, 0x004fe40000000038ULL, 0x0000541093197816ULL, 0x002fca0000000078ULL,
0x0000003b00807306ULL, 0x0002a20000200c00ULL, 0x00005410893a7816ULL, 0x008fce000000008aULL,
0x0000001800827306ULL, 0x0007e20000200c00ULL, 0x000054108c3b7816ULL, 0x002fce000000008dULL,
0x0000003d007e7306ULL, 0x0003e20000200c00ULL, 0x0000541090187816ULL, 0x008fe20000000077ULL,
0x0000003a2838723cULL, 0x040fec0000001820ULL, 0x0000001400157306ULL, 0x0007e20000200c00ULL,
0x00000018ff207819ULL, 0x000fe2000001141eULL, 0x0000003e283c723cULL, 0x002fe20000001824ULL,
0x000054107f217816ULL, 0x004fca0000000080ULL, 0x0000001c00297306ULL, 0x0003e20000200c00ULL,
0x0000888016147816ULL, 0x048fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x000000180818723cULL, 0x000fe8000000182cULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x00010000171c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001141cULL, 0x0000001400147306ULL, 0x000e700000200c00ULL,
0x0000007400747306ULL, 0x000ee20000200c00ULL, 0x000054107a7a7816ULL, 0x004fc4000000007bULL,
0x00005410947b7816ULL, 0x000fca0000000095ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541014287816ULL, 0x002fe20000000029ULL, 0x0000007a0804723cULL, 0x000fec0000001804ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x00005410791c7816ULL, 0x008fce0000000074ULL,
0x0000007300737306ULL, 0x000eb00000200c00ULL, 0x0000007c007c7306ULL, 0x000ee20000200c00ULL,
0x0000541015247816ULL, 0x002fce0000000072ULL, 0x0000009600977306ULL, 0x000e620000200c00ULL,
0x0000541082257816ULL, 0x004fce0000000073ULL, 0x0000001d002a7306ULL, 0x0003e20000200c00ULL,
0x000054107c7c7816ULL, 0x008fe2000000008fULL, 0x000000240824723cULL, 0x040fec0000001834ULL,
0x00000020002b7306ULL, 0x0004e20000200c00ULL, 0x00005410971d7816ULL, 0x002fe20000000076ULL,
0x0000007c080c723cULL, 0x040fec000000180cULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000054107e207816ULL, 0x004fe20000000099ULL, 0x0000001c081c723cULL, 0x040fec0000001810ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054102a297816ULL, 0x008fe2000000002bULL,
0x000000200820723cULL, 0x040fec0000001830ULL, 0x0000001600177306ULL, 0x000e640000200c00ULL,
0x000000280828723cULL, 0x000fec0000001838ULL, 0x0000002c002c7306ULL, 0x000ea20000200c00ULL,
0x0000541017707816ULL, 0x002fc40000000070ULL, 0x000054102c717816ULL, 0x004fce0000000071ULL,
0x000000700808723cULL, 0x000fe2000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff127f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007844813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007844813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004068127811ULL, 0x000fe400078e38ffULL,
0x000000c064107811ULL, 0x000fc400078e40ffULL, 0x00000004ff337819ULL, 0x000fe20000011666ULL,
0x0000000100117824ULL, 0x100fe400078e0212ULL, 0x0000000169137824ULL, 0x100fe200078e0212ULL,
0x0000000233357810ULL, 0x000fe20007ffe0ffULL, 0x000000016c2d7824ULL, 0x000fe200078e0212ULL,
0x0000006a112e7210ULL, 0x080fe40007f7e0ffULL, 0x0000006a13147210ULL, 0x000fe40007f5e0ffULL,
0x0000001065117217ULL, 0x000fe20007800000ULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005e002e2f7a11ULL, 0x000fe200078640ffULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00005e0014317a11ULL, 0x000fe200078440ffULL, 0x0000000111117824ULL, 0x000fe200078e0a10ULL,
0x00005f002e2e7a11ULL, 0x000fe200018f4413ULL, 0x000000016b137824ULL, 0x000fe200078e0212ULL,
0x00005f0014147a11ULL, 0x000fc400010f4415ULL, 0x0000006a2d2d7210ULL, 0x080fe40007f5e0ffULL,
0x0000006a132c7210ULL, 0x000fe40007f7e0ffULL, 0x0000002011117807ULL, 0x000fe20000000000ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e002d157a11ULL, 0x000fe200078440ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x00005e002c177a11ULL, 0x000fe400078640ffULL,
0x0000001160117217ULL, 0x000fc40007800000ULL, 0x00005f002d2d7a11ULL, 0x000fe400010f4410ULL,
0x00005f002c2c7a11ULL, 0x000fe200018f4413ULL, 0x0000000111167824ULL, 0x000fe200078e0a60ULL,
0x0000005831107210ULL, 0x080fe40007f7e0ffULL, 0x000000582f127210ULL, 0x080fe40007f9e0ffULL,
0x0000000433317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0614ULL,
0x0000005815147210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e062eULL,
0x000000163300720cULL, 0x000fc40003f66070ULL, 0x0000000633337810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200028e062dULL, 0x000000163500720cULL, 0x080fe40003f46070ULL,
0x000000163100720cULL, 0x080fe40003f86070ULL, 0x000000163300720cULL, 0x000fe40003fa6070ULL,
0x0000005817167210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010487faeULL, 0x0003e4000d901c46ULL, 0x000000ffff177224ULL, 0x000fe400030e062cULL,
0x0000000012477faeULL, 0x0003e8000d101c46ULL, 0x0000000014467faeULL, 0x0003e8000e101c46ULL,
0x0000000016457faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000784486fULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000784486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc4000784486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff707819ULL, 0x000fe40000011666ULL,
0x00005410103d7816ULL, 0x000fe20000000010ULL, 0x0000d2627f007947ULL, 0x000fea000b800000ULL,
0x00001f703d397589ULL, 0x0002a400000e0000ULL, 0x0000d2a27f007947ULL, 0x000fea000b800000ULL,
0x00001f503d3a7589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e006dULL, 0x0000991000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000db4000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e004fULL, 0x0000997000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000dae000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004434783bULL, 0x000f680000004200ULL, 0x00000000432c783bULL, 0x000e680000004200ULL,
0x000000004214783bULL, 0x000ee80000004200ULL, 0x000000004110783bULL, 0x000f220000004200ULL,
0x00000018ff727819ULL, 0x020fe20000011434ULL, 0x0000010034757824ULL, 0x040fe200078e00ffULL,
0x0000888034747816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011435ULL, 0x0000010035787824ULL, 0x040fe200078e00ffULL,
0x0000888035767816ULL, 0x040fe200000000ffULL, 0x0001000035797824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x00010000377d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x000001002c807824ULL, 0x002fe200078e00ffULL,
0x0000003400777306ULL, 0x0003e20000200c00ULL, 0x00000018ff707819ULL, 0x000fe20000011436ULL,
0x000001002e847824ULL, 0x000fe200078e00ffULL, 0x00008880367b7816ULL, 0x000fe200000000ffULL,
0x00000100158b7824ULL, 0x008fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001142cULL,
0x0000010016907824ULL, 0x000fe200078e00ffULL, 0x000088802c7f7816ULL, 0x000fe200000000ffULL,
0x0000007800357306ULL, 0x0007e20000200c00ULL, 0x0000010036347824ULL, 0x042fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc40000011437ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x0000010037787824ULL, 0x048fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00000079007a7306ULL, 0x000fe20000200c00ULL, 0x00008880377c7816ULL, 0x000fe400000000ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff6f7819ULL, 0x000fe4000001142dULL,
0x00000018ff3f7819ULL, 0x000fe2000001142eULL, 0x0000007800797306ULL, 0x0003e20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fc4000001142fULL, 0x000088802e837816ULL, 0x040fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x000088802f857816ULL, 0x000fe400000000ffULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0000003600377306ULL, 0x0007e20000200c00ULL,
0x000088802d787816ULL, 0x002fe400000000ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x00000018ff3e7819ULL, 0x000fc40000011414ULL, 0x0000888014887816ULL, 0x000fe200000000ffULL,
0x0000007d007e7306ULL, 0x000fe20000200c00ULL, 0x000001002d367824ULL, 0x048fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe20000011415ULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00008880158a7816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000002c007d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x00000018ff8c7819ULL, 0x000fe4000001148bULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff3b7819ULL, 0x000fe20000011416ULL,
0x0000002d00827306ULL, 0x0007e20000200c00ULL, 0x000001002f2c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe20000011417ULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x00008880168f7816ULL, 0x040fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fc4000001142cULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x00000100142d7824ULL, 0x048fe200078e00ffULL, 0x0000002c00867306ULL, 0x0003e20000200c00ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000888017917816ULL, 0x000fe400000000ffULL,
0x00000018ff897819ULL, 0x000fe4000001142dULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000003600817306ULL, 0x000fe20000200c00ULL, 0x0000b000402c7811ULL, 0x002fc400078e20ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000002e00367306ULL, 0x000fe20000200c00ULL,
0x00000018ff847819ULL, 0x000fe40000011484ULL, 0x00000018ff337819ULL, 0x010fe40000011410ULL,
0x00000018ff387819ULL, 0x000fc40000011411ULL, 0x00000018ff307819ULL, 0x004fe20000011412ULL,
0x0000002f00877306ULL, 0x0003e20000200c00ULL, 0x00000018ff327819ULL, 0x000fe40000011413ULL,
0x00000018ff907819ULL, 0x000fca0000011490ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000000002c2c783bULL, 0x002e6e0000000200ULL, 0x0000007300737306ULL, 0x000ef00000200c00ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541077727816ULL, 0x004fce0000000072ULL,
0x0000007500757306ULL, 0x000ea20000200c00ULL, 0x000054107a737816ULL, 0x008fce0000000073ULL,
0x0000007600767306ULL, 0x000ef00000200c00ULL, 0x00000014008b7306ULL, 0x0009e20000200c00ULL,
0x000000392c2c9232ULL, 0x082fe20000000000ULL, 0x0000541074747816ULL, 0x004fe20000000075ULL,
0x000000392e2e9232ULL, 0x000fc40000000000ULL, 0x0000003a2d2d9232ULL, 0x080fe40000000000ULL,
0x0000003a2f2f9232ULL, 0x000fe20000000000ULL, 0x00000015008e7306ULL, 0x0003e20000200c00ULL,
0x0000010017147824ULL, 0x050fe200078e00ffULL, 0x0000541076757816ULL, 0x008fe20000000035ULL,
0x0001000017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000000722c18723cULL, 0x000fe20000001818ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000008c008d7306ULL, 0x000fe20000200c00ULL, 0x0000888010157816ULL, 0x002fca00000000ffULL,
0x000000ffff357224ULL, 0x000fe200078e0015ULL, 0x000000742c0c723cULL, 0x000fe2000000180cULL,
0x0000001400927306ULL, 0x0003e20000200c00ULL, 0x0000010010157824ULL, 0x040fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011415ULL,
0x00000016008c7306ULL, 0x000fe20000200c00ULL, 0x0000b00003147811ULL, 0x002fe400078e20ffULL,
0x0000888011757816ULL, 0x000fe400000000ffULL, 0x00000018ff107819ULL, 0x000fc60000011410ULL,
0x0000001700937306ULL, 0x0003f00000200c00ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000003400347306ULL, 0x000eb00000200c00ULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x000054107b347816ULL, 0x004fce0000000034ULL, 0x0000007100717306ULL, 0x000eb00000200c00ULL,
0x0000006e006e7306ULL, 0x000f220000200c00ULL, 0x0000541037707816ULL, 0x008fe20000000070ULL,
0x0000003914149232ULL, 0x002fc40000000000ULL, 0x0000003916169232ULL, 0x000fe20000000000ULL,
0x0000010012397824ULL, 0x000fe200078e00ffULL, 0x0000003a15159232ULL, 0x080fe40000000000ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x000054107e717816ULL, 0x004fe20000000071ULL,
0x0000003a17179232ULL, 0x000fe20000000000ULL, 0x00000018ff397819ULL, 0x000fca0000011439ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054107d6e7816ULL, 0x010fe2000000006eULL,
0x000000702c1c723cULL, 0x000fec000000181cULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x00005410826f7816ULL, 0x002fce000000006fULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x0000006e2c24723cULL, 0x000fee0000001824ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000054107f807816ULL, 0x004fce0000000080ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x0000541078817816ULL, 0x002fce0000000081ULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x000000802c20723cULL, 0x000fee0000001820ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x0000541083847816ULL, 0x004fce0000000084ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541085857816ULL, 0x002fce0000000086ULL, 0x0000003500747306ULL, 0x0003e20000200c00ULL,
0x0000541036367816ULL, 0x008fe2000000003fULL, 0x000000842c28723cULL, 0x000fec0000001828ULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x000054107c357816ULL, 0x002fe40000000079ULL,
0x0000541087377816ULL, 0x004fca000000006cULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000342c04723cULL, 0x040fee0000001804ULL, 0x000000ffff347224ULL, 0x000fe200078e0075ULL,
0x0000003b003b7306ULL, 0x000fe20000200c00ULL, 0x0000010011357824ULL, 0x040fe200078e00ffULL,
0x000000362c2c723cULL, 0x000fe20000001808ULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003400757306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x000054108b087816ULL, 0x008fe4000000003eULL,
0x000054108e097816ULL, 0x002fc6000000003dULL, 0x0000001000347306ULL, 0x0003e80000200c00ULL,
0x000000081408723cULL, 0x000fe80000001818ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000888012107816ULL, 0x042fe200000000ffULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011412ULL, 0x0000003500707306ULL, 0x000e700000200c00ULL,
0x0000001100357306ULL, 0x0005f00000200c00ULL, 0x00000010003f7306ULL, 0x0007e20000200c00ULL,
0x0000888013117816ULL, 0x004fc400000000ffULL, 0x0000541075197816ULL, 0x002fca0000000070ULL,
0x0000003300337306ULL, 0x000fe20000200c00ULL, 0x0000010013107824ULL, 0x048fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011410ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe40000011413ULL,
0x000054108c107816ULL, 0x000fca000000003bULL, 0x0000007200737306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000003900367306ULL, 0x000ff00000200c00ULL, 0x00000011003a7306ULL, 0x0005e20000200c00ULL,
0x0000541088887816ULL, 0x002fce0000000089ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541093117816ULL, 0x004fce000000003cULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000000101410723cULL, 0x000fee000000181cULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x00005410341c7816ULL, 0x000fe40000000033ULL, 0x00005410351d7816ULL, 0x000fca0000000038ULL,
0x0000008f008f7306ULL, 0x000fe40000200c00ULL, 0x0000001c141c723cULL, 0x000fec0000001824ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x000054108a897816ULL, 0x002fce000000008dULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x00000088140c723cULL, 0x000fee000000180cULL,
0x0000001800397306ULL, 0x0007220000200c00ULL, 0x000054108f907816ULL, 0x004fce0000000090ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000541074187816ULL, 0x008fe40000000073ULL,
0x0000541091917816ULL, 0x002fca0000000092ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000181418723cULL, 0x040fee0000001820ULL, 0x000054103f207816ULL, 0x000fe20000000036ULL,
0x000000901404723cULL, 0x000fe20000001804ULL, 0x000054103a217816ULL, 0x010fc40000000039ULL,
0x0000541037247816ULL, 0x004fe40000000030ULL, 0x000054103d257816ULL, 0x002fc60000000032ULL,
0x000000201420723cULL, 0x040ff00000001828ULL, 0x000000241424723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c064147811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000146500720cULL, 0x000fda0003f24070ULL, 0x000032a000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007824815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400167305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000159597824ULL, 0x000fe400078e0202ULL, 0x00000002ff027424ULL, 0x000fe400078e00ffULL,
0x00000001ff157424ULL, 0x000fe200078e00ffULL, 0x0000000159147812ULL, 0x000fe200078ec0ffULL,
0xffffffffff5f7424ULL, 0x000fe400078e00ffULL, 0x0000030002027a24ULL, 0x000fe200078e0a15ULL,
0x000000011400780cULL, 0x000fc80003f25070ULL, 0x0000000102027807ULL, 0x000fca0004800000ULL,
0x0000000159617824ULL, 0x000fca00078e0202ULL, 0x000000636100720cULL, 0x000fe40003f26070ULL,
0x000000e064027811ULL, 0x000fe400078e40ffULL, 0x0000006068297811ULL, 0x000fe400078e38ffULL,
0x0000000265177217ULL, 0x000fc60007800000ULL, 0x00000001002f7824ULL, 0x000fc800078e0229ULL,
0x0000000161149824ULL, 0x000fe400078e025bULL, 0x00000004ff159424ULL, 0x000fe400078e00ffULL,
0x0000000169697824ULL, 0x000fe400078e0229ULL, 0x0000600014149625ULL, 0x000fe200078e0015ULL,
0x00000006662c7811ULL, 0x000fc600078fe0ffULL, 0x0000000117177824ULL, 0x000fe200078e0a02ULL,
0x00000006145f9981ULL, 0x000362000c1e1900ULL, 0x0000006a2f2a7210ULL, 0x080fe40007f5e0ffULL,
0x0000000466167811ULL, 0x000fe400078fe0ffULL, 0x0000006a69287210ULL, 0x000fe40007f3e0ffULL,
0x0000002c292b7210ULL, 0x100fe40007ffe060ULL, 0x0000002017177807ULL, 0x000fe20000000000ULL,
0x000000ffff157224ULL, 0x002fe200010e06ffULL, 0x00000016292d7210ULL, 0x000fe20007ffe060ULL,
0x000000ffff297224ULL, 0x000fe200008e06ffULL, 0x00005e002a2f7a11ULL, 0x000fc400078440ffULL,
0x0000006a2b007210ULL, 0x080fe40007f9e0ffULL, 0x0000001760177217ULL, 0x000fe40007800000ULL,
0x00005e0028337a11ULL, 0x000fe400078240ffULL, 0x0000006a2d027210ULL, 0x000fe20007f7e0ffULL,
0x0000000117177824ULL, 0x000fe200078e0a60ULL, 0x00005f002a2a7a11ULL, 0x000fe200010f4415ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005f0028287a11ULL, 0x000fe200008f4429ULL,
0x000000ffff2d7224ULL, 0x000fe200018e06ffULL, 0x00000004ff147819ULL, 0x000fc40000011666ULL,
0x00005e00002b7a11ULL, 0x000fe400078240ffULL, 0x00000002142e7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0002297a11ULL, 0x000fe400078040ffULL, 0x00005f0000007a11ULL, 0x000fe400008f4415ULL,
0x000000171400720cULL, 0x000fe40003f66070ULL, 0x0000005833147210ULL, 0x000fc40007f9e0ffULL,
0x000000171600720cULL, 0x080fe40003f26070ULL, 0x000000582f167210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff157224ULL, 0x000fe200020e0628ULL, 0x000000172e00720cULL, 0x080fe40003f46070ULL,
0x00005f0002027a11ULL, 0x000fe400000f442dULL, 0x000000172c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff177224ULL, 0x000fe200028e062aULL, 0x0000005829287210ULL, 0x080fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e2000d901c46ULL,
0x000000582b2a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe400020e0602ULL,
0x000000ffff2b7224ULL, 0x000fe200028e0600ULL, 0x0000000016567faeULL, 0x0003e8000d101c46ULL,
0x0000000028557faeULL, 0x0003e8000c901c46ULL, 0x000000002a547faeULL, 0x0003e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff347f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106680060147f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007804831ULL,
0x01066c0060177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007824815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x008fe20003800000ULL, 0x01066c0060177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101800053177984ULL, 0x000e680000000800ULL, 0x0103800053007984ULL, 0x0007220000000800ULL,
0x0000005e1700720bULL, 0x002fe20003f3d000ULL, 0x0000bbb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x008fc800008e0100ULL, 0x0000ffff02167812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff547424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000036700780cULL, 0x000fe40003f45270ULL,
0x0000005e1700720bULL, 0x000fe20003f34000ULL, 0x0000bb827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x000fe400008e0100ULL, 0x000000175e287209ULL, 0x000fe40007810000ULL,
0x0000ffff02157812ULL, 0x000fe400078e3cffULL, 0x00000002ff707819ULL, 0x000fe20000011666ULL,
0x800000285e147221ULL, 0x000fe20000010000ULL, 0x010580285300a388ULL, 0x0003e20000000800ULL,
0x0000001516ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL,
0x00000014003d7308ULL, 0x000ee40000000800ULL, 0x0000003d5d5d7220ULL, 0x008fe20000410000ULL,
0x0000bb227f007947ULL, 0x000fea000b800000ULL, 0x00001f703d307589ULL, 0x0022e400000e0000ULL,
0x000000300c0c7220ULL, 0x08cfe20000410000ULL, 0x000000300d0d7220ULL, 0x080fe20000410000ULL,
0x0000003008087220ULL, 0x080fe20000410000ULL, 0x0000003009097220ULL, 0x080fe20000410000ULL,
0x0000003004047220ULL, 0x080fe20000410000ULL, 0x0000003005057220ULL, 0x080fe20000410000ULL,
0x0000003010107220ULL, 0x080fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x000fe20000410000ULL,
0x0000ba527f007947ULL, 0x000fea000b800000ULL, 0x00001f503d307589ULL, 0x0004e400000e0000ULL,
0x8000002817171221ULL, 0x100fe20000010000ULL, 0x00000001ff547807ULL, 0x000fe20000800000ULL,
0x000000300e0e7220ULL, 0x08cfe20000410000ULL, 0x000000300f0f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b17171820ULL, 0x000fe20000410000ULL, 0x000000300a0a7220ULL, 0x080fe20000410000ULL,
0x000000300b0b7220ULL, 0x080fe20000410000ULL, 0x0000003006067220ULL, 0x080fe20000410000ULL,
0x0000001700511308ULL, 0x000ea20000000800ULL, 0x0000003007077220ULL, 0x080fe20000410000ULL,
0x0000003012127220ULL, 0x080fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x000fe20000410000ULL,
0x000000ffff5e7224ULL, 0x000fe200078e0028ULL, 0x0000000051001220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000005d005d7221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000020000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff027984ULL, 0x000ee40000000800ULL, 0x8000000002ff7812ULL, 0x008fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000051ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff707819ULL, 0x002fc40000011666ULL, 0x00005410003d7816ULL, 0x000fe20000000000ULL,
0x0000b7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f703d397589ULL, 0x0002e400000e0000ULL,
0x0000b8327f007947ULL, 0x000fea000b800000ULL, 0x00001f503d387589ULL, 0x00086400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e006dULL,
0x0000b5a000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000beb000007944ULL, 0x03cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff707224ULL, 0x002fe200078e004fULL,
0x0000b60000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000be5000007944ULL, 0x03cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004e28783bULL, 0x000f280000004200ULL,
0x000000004d2c783bULL, 0x000ee80000004200ULL, 0x000000004b14783bULL, 0x0005e80000004200ULL,
0x000000004c30783bULL, 0x0044620000004200ULL, 0x00000018ff007819ULL, 0x010fe20000011428ULL,
0x00000100284e7824ULL, 0x040fe200078e00ffULL, 0x00008880284b7816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe2000001142aULL,
0x0000010029567824ULL, 0x040fe200078e00ffULL, 0x000088802a6e7816ULL, 0x040fe200000000ffULL,
0x000001002a6f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011456ULL,
0x000001002c737824ULL, 0x008fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fe20000011429ULL,
0x0000002800567306ULL, 0x0007e20000200c00ULL, 0x0000888029577816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x00000018ff537819ULL, 0x000fe4000001142bULL, 0x000088802b707816ULL, 0x042fe200000000ffULL,
0x00000059006a7306ULL, 0x000fe20000200c00ULL, 0x000001002b287824ULL, 0x048fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001142cULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002a00597306ULL, 0x0003e20000200c00ULL, 0x00000018ff2b7819ULL, 0x000fc4000001142bULL,
0x00000018ff4c7819ULL, 0x004fe4000001142dULL, 0x00000018ff3e7819ULL, 0x000fe4000001142eULL,
0x00000018ff3f7819ULL, 0x000fe2000001142fULL, 0x00000029006c7306ULL, 0x0005e20000200c00ULL,
0x000001002d2a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe40000011430ULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff2a7819ULL, 0x000fc4000001142aULL,
0x0000002800717306ULL, 0x0003e20000200c00ULL, 0x000088802c297816ULL, 0x044fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff3d7819ULL, 0x000fe40000011431ULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000002b00727306ULL, 0x0005e20000200c00ULL, 0x000088802d287816ULL, 0x042fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fc40000011473ULL,
0x00000018ff3a7819ULL, 0x000fe40000011432ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002900747306ULL, 0x0003e20000200c00ULL, 0x000001002f2b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011433ULL, 0x00000018ff377819ULL, 0x000fe40000011415ULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x0000002800757306ULL, 0x0005e20000200c00ULL,
0x000088802e297816ULL, 0x002fc400000000ffULL, 0x00000018ff367819ULL, 0x000fca0000011414ULL,
0x0000002a00787306ULL, 0x0002e20000200c00ULL, 0x000001002e287824ULL, 0x044fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002c00767306ULL, 0x0005e20000200c00ULL, 0x000088802f2a7816ULL, 0x042fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fc8000001142eULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d00777306ULL, 0x000fe20000200c00ULL,
0x0000b8004a2c7811ULL, 0x004fe400078e20ffULL, 0x0000541075757816ULL, 0x008fca0000000078ULL,
0x0000002e007d7306ULL, 0x000ff00000200c00ULL, 0x0000002f007e7306ULL, 0x0003f00000200c00ULL,
0x0000002900797306ULL, 0x0005e20000200c00ULL, 0x000000002c2c783bULL, 0x002e6e0000000200ULL,
0x00000028007a7306ULL, 0x0007220000200c00ULL, 0x0000010030297824ULL, 0x004fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000888030287816ULL, 0x048fe200000000ffULL, 0x0001000030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x00005410797a7816ULL, 0x010fce000000007aULL, 0x0000003000817306ULL, 0x0007f00000200c00ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000991054307816ULL, 0x008fc800000000ffULL,
0x000000ff3000720cULL, 0x000fc60003f05270ULL, 0x0000002900807306ULL, 0x0007f00000200c00ULL,
0x0000002b007c7306ULL, 0x0009e20000200c00ULL, 0x0000010032297824ULL, 0x008fe200078e00ffULL,
0x000000392c2c8232ULL, 0x002fc40000000000ULL, 0x000000392e2e8232ULL, 0x000fe40000000000ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x000000382d2d8232ULL, 0x080fe20000000000ULL,
0x00000028007f7306ULL, 0x0003e20000200c00ULL, 0x00000100312b7824ULL, 0x010fe200078e00ffULL,
0x000000382f2f8232ULL, 0x000fc80000000000ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000002a007b7306ULL, 0x0007220000200c00ULL, 0x0000888032287816ULL, 0x042fe200000000ffULL,
0x0001000032327824ULL, 0x000fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002800847306ULL, 0x0005e20000200c00ULL, 0x00008880312a7816ULL, 0x048fe200000000ffULL,
0x0001000031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000002900857306ULL, 0x0003e20000200c00ULL, 0x000054104b287816ULL, 0x004fe4000000004eULL,
0x000054107b7b7816ULL, 0x010fca000000007cULL, 0x0000002a00827306ULL, 0x0005e20000200c00ULL,
0x0000541057297816ULL, 0x002fe2000000006aULL, 0x0000007a2c20723cULL, 0x040fec0000001820ULL,
0x0000002b00837306ULL, 0x0003e20000200c00ULL, 0x00008880332a7816ULL, 0x044fe200000000ffULL,
0x000000282c0c723cULL, 0x000fec000000180cULL, 0x0000002a00547306ULL, 0x0005e20000200c00ULL,
0x00000100332b7824ULL, 0x002fe200078e00ffULL, 0x0000b80049287811ULL, 0x000fe200078e20ffULL,
0x0000010014297824ULL, 0x000fc400078e00ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff497819ULL, 0x000fe20000011429ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00008880142a7816ULL, 0x044fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fc60000011433ULL,
0x000000ffff4b7224ULL, 0x000fe200078e002aULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000002b00897306ULL, 0x0003f00000200c00ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000000000557306ULL, 0x0007220000200c00ULL, 0x000054106e307816ULL, 0x004fce000000006fULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x00000018ff007819ULL, 0x008fce0000011416ULL,
0x0000005300537306ULL, 0x000ee20000200c00ULL, 0x0000541056567816ULL, 0x010fe40000000055ULL,
0x0000888015557816ULL, 0x000fca00000000ffULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x0000541059527816ULL, 0x004fe20000000052ULL, 0x0000003928288232ULL, 0x082fe40000000000ULL,
0x000000392a2a8232ULL, 0x000fe40000000000ULL, 0x0000003829298232ULL, 0x080fe40000000000ULL,
0x00000031004a7306ULL, 0x0003e20000200c00ULL, 0x0000541072537816ULL, 0x008fe20000000053ULL,
0x000000382b2b8232ULL, 0x000fcc0000000000ULL, 0x0000004c004c7306ULL, 0x000ea20000200c00ULL,
0x0000541070317816ULL, 0x002fe20000000071ULL, 0x000000522c10723cULL, 0x000fe20000001810ULL,
0x0000541074747816ULL, 0x010fca0000000073ULL, 0x0000004d004d7306ULL, 0x000e640000200c00ULL,
0x000000742c18723cULL, 0x000fec0000001818ULL, 0x0000003200877306ULL, 0x000fe20000200c00ULL,
0x0000541077777816ULL, 0x004fce000000004cULL, 0x0000003300867306ULL, 0x0005e20000200c00ULL,
0x0000541076767816ULL, 0x002fce000000004dULL, 0x0000000200697306ULL, 0x0002e20000200c00ULL,
0x000000302c30723cULL, 0x044fee0000001804ULL, 0x0000010015057824ULL, 0x040fe200078e00ffULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000000ffff047224ULL, 0x000fe200078e0055ULL,
0x000000762c1c723cULL, 0x000fe2000000181cULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fc40000011405ULL, 0x00000018ff027819ULL, 0x002fe40000011417ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x000054106c577816ULL, 0x008fca0000000069ULL, 0x0000000400557306ULL, 0x0007e20000200c00ULL,
0x000054107d3e7816ULL, 0x004fe2000000003eULL, 0x000000562c08723cULL, 0x000fec0000001808ULL,
0x00000015004c7306ULL, 0x0005e20000200c00ULL, 0x0000010016047824ULL, 0x008fe200078e00ffULL,
0x000054107e3f7816ULL, 0x002fcc000000003fULL, 0x0000000500527306ULL, 0x0002e20000200c00ULL,
0x00000018ff157819ULL, 0x004fe20000011404ULL, 0x0000003e2c24723cULL, 0x000fe20000001824ULL,
0x000054107f047816ULL, 0x000fca0000000080ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000541082057816ULL, 0x002fe40000000083ULL, 0x00008880172d7816ULL, 0x000fca00000000ffULL,
0x00000049004e7306ULL, 0x000e620000200c00ULL, 0x000000042804723cULL, 0x000fee000000180cULL,
0x0000001400497306ULL, 0x0005e20000200c00ULL, 0x00000100170c7824ULL, 0x040fe200078e00ffULL,
0x00005410540d7816ULL, 0x000fe20000000089ULL, 0x0001000017177824ULL, 0x000fca00078e00ffULL,
0x0000003600367306ULL, 0x000f220000200c00ULL, 0x0000888016147816ULL, 0x044fe200000000ffULL,
0x0001000016167824ULL, 0x000fca00078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000003700377306ULL, 0x000eb00000200c00ULL, 0x0000001400397306ULL, 0x0003f00000200c00ULL,
0x00000015002c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff147819ULL, 0x002fc4000001140cULL,
0x00005410840c7816ULL, 0x000fca0000000085ULL, 0x00000014002f7306ULL, 0x0003e20000200c00ULL,
0x0000541055157816ULL, 0x008fe20000000052ULL, 0x0000000c280c723cULL, 0x000fec0000001830ULL,
0x0000002d002e7306ULL, 0x000fe20000200c00ULL, 0x000054104b147816ULL, 0x002fe4000000004eULL,
0x00000018ff307819ULL, 0x000fca0000011417ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x000000142818723cULL, 0x000fee0000001818ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x0000541049147816ULL, 0x010fe40000000036ULL, 0x000054104c157816ULL, 0x004fca0000000037ULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x00005410813c7816ULL, 0x002fce000000003cULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x000054104a3d7816ULL, 0x008fce000000003dULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x00005410873a7816ULL, 0x004fe2000000003aULL,
0x0000003c2808723cULL, 0x000fec0000001808ULL, 0x0000000200027306ULL, 0x000fe20000200c00ULL,
0x00005410863b7816ULL, 0x002fce000000003bULL, 0x00000016002d7306ULL, 0x0002a20000200c00ULL,
0x0000003a2810723cULL, 0x040fee0000001810ULL, 0x0000003000317306ULL, 0x000ee20000200c00ULL,
0x000000142814723cULL, 0x002fee000000181cULL, 0x00005410391c7816ULL, 0x000fc4000000002cULL,
0x000054102e1d7816ULL, 0x000fce000000002fULL, 0x0000001c281c723cULL, 0x000fee0000001820ULL,
0x000054102d207816ULL, 0x004fe40000000000ULL, 0x0000541031217816ULL, 0x008fce0000000002ULL,
0x000000202828723cULL, 0x000fe20000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff207f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007824821ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fc40007824821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe20003800000ULL,
0x0106bc00ff237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007824821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000030064007a10ULL, 0x000fe20007ffe0ffULL,
0x000058005f207a24ULL, 0x020fe200078e02ffULL, 0x00000004ff337819ULL, 0x000fe20000011666ULL,
0x00000080686b7824ULL, 0x000fe200078e026bULL, 0x0000000100217810ULL, 0x040fe20007ffe0ffULL,
0x0000010000027824ULL, 0x000fe200078e00ffULL, 0x0000000233377810ULL, 0x000fe20007ffe0ffULL,
0x0000008020257824ULL, 0x000fe200078e00ffULL, 0xfffffffa6b007810ULL, 0x000fc40007ffe0ffULL,
0x0000000265237217ULL, 0x000fe40007800000ULL, 0x000000622100720cULL, 0x000fe40003f46070ULL,
0x00000000252c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000123237824ULL, 0x000fe200078e0a02ULL,
0xfffffffc6b027810ULL, 0x040fe40007ffe0ffULL, 0xfffffffe6b007810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x0000002023237807ULL, 0x000fc40001000000ULL,
0x0000000225207210ULL, 0x040fe40007f9e0ffULL, 0x0000000025267210ULL, 0x040fe40007fbe0ffULL,
0x00005e002c317a11ULL, 0x000fe200078640ffULL, 0x000000ffff2f7224ULL, 0x000fe200020e06ffULL,
0x0000002360237217ULL, 0x000fe20007800000ULL, 0x000000ffff277224ULL, 0x000fe200028e06ffULL,
0x0000006b25027210ULL, 0x000fe40007f3e0ffULL, 0x00005f002c2c7a11ULL, 0x000fe200018f4421ULL,
0x0000000123007824ULL, 0x000fe200078e0a60ULL, 0x00005e00202d7a11ULL, 0x000fe200078440ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005e0026257a11ULL, 0x000fc400078640ffULL,
0x00005f0020237a11ULL, 0x000fe400010f442fULL, 0x00005e0002597a11ULL, 0x000fe400078240ffULL,
0x00005f0026267a11ULL, 0x000fe400018f4427ULL, 0x0000005831207210ULL, 0x000fe40007f9e0ffULL,
0x0000000633277810ULL, 0x040fe40007ffe0ffULL, 0x000000003300720cULL, 0x000fc40003f46070ULL,
0x000000582d227210ULL, 0x080fe40007fbe0ffULL, 0x0000000433337810ULL, 0x000fe40007ffe0ffULL,
0x00005f0002027a11ULL, 0x000fe200008f4421ULL, 0x000000ffff217224ULL, 0x000fe200020e062cULL,
0x0000005825247210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x000000003700720cULL, 0x080fe40003f26070ULL, 0x000000003300720cULL, 0x080fe20003f86070ULL,
0x000000ffff257224ULL, 0x000fe200018e0626ULL, 0x000000002700720cULL, 0x000fe20003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020487faeULL, 0x0003e2000d101c46ULL,
0x0000005859587210ULL, 0x000fca0007f7e0ffULL, 0x000000ffff597224ULL, 0x000fe400018e0602ULL,
0x0000000022477faeULL, 0x0003e8000c901c46ULL, 0x0000000024467faeULL, 0x0003e8000e101c46ULL,
0x0000000058457faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff217984ULL, 0x002e640000000800ULL, 0x8000000021ff7812ULL, 0x002fc40007824835ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe20003800000ULL, 0x0106b400ff217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fc40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000051ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff707819ULL, 0x000fe40000011666ULL,
0x00005410003d7816ULL, 0x000fe20000000000ULL, 0x0000a2b27f007947ULL, 0x000fea000b800000ULL,
0x00001f703d397589ULL, 0x0002a400000e0000ULL, 0x0000a2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f503d507589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e006dULL, 0x0000cbb000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000a8a000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff707224ULL, 0x002fe200078e004fULL, 0x0000cc1000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000a84000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004444783bULL, 0x000f620000004200ULL, 0x0000b80003037811ULL, 0x000fc600078e20ffULL,
0x00000000432c783bULL, 0x000e680000004200ULL, 0x000000004224783bULL, 0x0007280000004200ULL,
0x000000004120783bULL, 0x0005e20000004200ULL, 0x0000010046497824ULL, 0x020fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe20000011444ULL, 0x0000010044357824ULL, 0x040fe200078e00ffULL,
0x0000888044347816ULL, 0x040fe200000000ffULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe20000011449ULL, 0x0000010045377824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x002fe2000001142cULL, 0x000001002c4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x00000049004a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff427819ULL, 0x008fe20000011437ULL, 0x000001002d537824ULL, 0x040fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001142dULL, 0x000001002e577824ULL, 0x000fe200078e00ffULL,
0x000088802d527816ULL, 0x040fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011453ULL, 0x0000004400377306ULL, 0x0007e20000200c00ULL,
0x000088802c497816ULL, 0x042fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe2000001144fULL, 0x00000100256d7824ULL, 0x010fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000010026707824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000005400557306ULL, 0x000fe20000200c00ULL,
0x0000010047447824ULL, 0x008fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001142eULL,
0x00000018ff3c7819ULL, 0x000fe4000001142fULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000002c00537306ULL, 0x0003e20000200c00ULL, 0x000088802f597816ULL, 0x040fe400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff3a7819ULL, 0x000fe40000011424ULL,
0x0000888024697816ULL, 0x000fe200000000ffULL, 0x00000044004d7306ULL, 0x000fe20000200c00ULL,
0x000001002f2c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x0000888045417816ULL, 0x004fc400000000ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000004f00447306ULL, 0x0003e20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00000018ff3b7819ULL, 0x000fe40000011425ULL,
0x00000018ff027819ULL, 0x000fe20000011445ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011426ULL, 0x0000002d00567306ULL, 0x0005e20000200c00ULL,
0x000088802e4f7816ULL, 0x042fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fc40000011427ULL, 0x00008880266f7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002c006a7306ULL, 0x0003e20000200c00ULL, 0x00000100242d7824ULL, 0x044fe200078e00ffULL,
0x0000888027727816ULL, 0x000fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff6b7819ULL, 0x000fe4000001142dULL,
0x00008880252d7816ULL, 0x040fe200000000ffULL, 0x0000005700547306ULL, 0x000fe20000200c00ULL,
0x0000b800402c7811ULL, 0x002fe200078e20ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000ffff407224ULL, 0x000fe200078e002dULL,
0x0000888046437816ULL, 0x000fc400000000ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000002e00587306ULL, 0x000fe20000200c00ULL, 0x00008880474c7816ULL, 0x040fe400000000ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000018ff307819ULL, 0x000fe20000011446ULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011447ULL,
0x0000002f00577306ULL, 0x0003e20000200c00ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc4000001146dULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x00000018ff707819ULL, 0x000fcc0000011470ULL,
0x0000003500357306ULL, 0x000eb00000200c00ULL, 0x0000004100417306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000ee20000200c00ULL, 0x0000541034347816ULL, 0x004fce0000000035ULL,
0x0000006b006c7306ULL, 0x000ff00000200c00ULL, 0x00000024006b7306ULL, 0x0005e20000200c00ULL,
0x0000541041357816ULL, 0x008fe20000000042ULL, 0x000000392c2c8232ULL, 0x002fc40000000000ULL,
0x000000392e2e8232ULL, 0x000fe40000000000ULL, 0x000000502d2d8232ULL, 0x080fe40000000000ULL,
0x00000025006e7306ULL, 0x0003e20000200c00ULL, 0x0000010027247824ULL, 0x044fe200078e00ffULL,
0x000000502f2f8232ULL, 0x000fe20000000000ULL, 0x0001000027277824ULL, 0x000fc600078e00ffULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000000000367306ULL, 0x0004e20000200c00ULL, 0x0000888020257816ULL, 0x002fe200000000ffULL,
0x000000342c04723cULL, 0x000fe80000001804ULL, 0x000000ffff417224ULL, 0x000fe400078e0025ULL,
0x0000002400737306ULL, 0x0003e20000200c00ULL, 0x00000018ff007819ULL, 0x004fce0000011422ULL,
0x0000000200487306ULL, 0x0005e20000200c00ULL, 0x0000010020247824ULL, 0x002fe200078e00ffULL,
0x0000541037367816ULL, 0x008fc80000000036ULL, 0x00000018ff427819ULL, 0x000fe40000011424ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x00000018ff027819ULL, 0x004fce0000011423ULL,
0x0000004300437306ULL, 0x000eb00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x0000541045377816ULL, 0x002fe40000000048ULL, 0x0000888021457816ULL, 0x000fca00000000ffULL,
0x0000002600717306ULL, 0x000fe20000200c00ULL, 0x0000541043347816ULL, 0x004fe2000000004aULL,
0x000000362c08723cULL, 0x000fec0000001808ULL, 0x0000002700747306ULL, 0x0003e20000200c00ULL,
0x000054104c357816ULL, 0x008fce000000004dULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000000000324783bULL, 0x002e620000000200ULL, 0x000000342c34723cULL, 0x000fec000000180cULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0045ULL,
0x00000100210d7824ULL, 0x000fca00078e00ffULL, 0x0000004f004f7306ULL, 0x000f220000200c00ULL,
0x00005410533e7816ULL, 0x004fe4000000003eULL, 0x00000018ff0d7819ULL, 0x000fca000001140dULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x00005410563f7816ULL, 0x008fce000000003fULL,
0x00000030004b7306ULL, 0x0007e20000200c00ULL, 0x0000003e2c14723cULL, 0x000fee0000001814ULL,
0x00000032004e7306ULL, 0x000be20000200c00ULL, 0x000054104f3e7816ULL, 0x010fe20000000054ULL,
0x0000003924248232ULL, 0x082fe20000000000ULL, 0x00005410593f7816ULL, 0x004fe2000000006aULL,
0x0000003926268232ULL, 0x000fe20000000000ULL, 0x00000018ff307819ULL, 0x008fe20000011420ULL,
0x0000005025258232ULL, 0x080fe20000000000ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x00000018ff327819ULL, 0x020fe20000011421ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000005027278232ULL, 0x000fe20000000000ULL,
0x00000018ff207819ULL, 0x000fc60000011420ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000003c003c7306ULL, 0x000eb00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x0000541058587816ULL, 0x002fce000000003dULL, 0x0000004700477306ULL, 0x000e620000200c00ULL,
0x0000541057597816ULL, 0x004fe4000000003cULL, 0x0000003e2c3c723cULL, 0x040fea000000181cULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000541046467816ULL, 0x008fe4000000004bULL,
0x00008880231e7816ULL, 0x000fe200000000ffULL, 0x000000582c28723cULL, 0x000fe80000001828ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000541047477816ULL, 0x002fce000000004eULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000462c10723cULL, 0x000fee0000001810ULL,
0x0000000c00437306ULL, 0x0003f00000200c00ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x00008880220c7816ULL, 0x002fca00000000ffULL, 0x000000ffff1c7224ULL, 0x000fe400078e000cULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x00000100220c7824ULL, 0x040fe400078e00ffULL,
0x0001000022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001140cULL,
0x0000003a003a7306ULL, 0x000f220000200c00ULL, 0x00005410690c7816ULL, 0x004fe4000000006cULL,
0x0000541049447816ULL, 0x008fe40000000044ULL, 0x00000018ff227819ULL, 0x000fc60000011422ULL,
0x0000003b003b7306ULL, 0x000ea20000200c00ULL, 0x0000541052457816ULL, 0x002fce0000000055ULL,
0x0000000d00467306ULL, 0x0002e20000200c00ULL, 0x000054106b3a7816ULL, 0x010fe2000000003aULL,
0x000000442c18723cULL, 0x000fec0000001818ULL, 0x0000003300337306ULL, 0x000f220000200c00ULL,
0x00005410400d7816ULL, 0x002fe4000000006dULL, 0x000054106e3b7816ULL, 0x004fca000000003bULL,
0x0000000c240c723cULL, 0x000fe20000001804ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x0000541043437816ULL, 0x008fca0000000046ULL, 0x0000010023047824ULL, 0x040fe200078e00ffULL,
0x0000003a2408723cULL, 0x000fe20000001808ULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x0000541074397816ULL, 0x010fc60000000033ULL,
0x00000018ff2e7819ULL, 0x000fc80000011423ULL, 0x0000002000037306ULL, 0x000ff00000200c00ULL,
0x0000002100217306ULL, 0x000ff00000200c00ULL, 0x0000001c00207306ULL, 0x0003f00000200c00ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x00000018ff1c7819ULL, 0x002fce0000011404ULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541071387816ULL, 0x004fce0000000038ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000000382410723cULL, 0x000fee0000001810ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054106f047816ULL, 0x002fce0000000070ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000541072057816ULL, 0x004fce0000000073ULL, 0x0000001d002d7306ULL, 0x0004e20000200c00ULL,
0x000000042404723cULL, 0x000fee0000001834ULL, 0x0000001e002c7306ULL, 0x000fe20000200c00ULL,
0x00005410211d7816ULL, 0x004fe40000000032ULL, 0x0000541041427816ULL, 0x002fca0000000042ULL,
0x0000001c003b7306ULL, 0x0002a20000200c00ULL, 0x0000541020207816ULL, 0x008fe2000000002dULL,
0x000000422418723cULL, 0x000fec0000001818ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x00005410031c7816ULL, 0x002fce0000000030ULL, 0x0000000200027306ULL, 0x000fe20000200c00ULL,
0x0000001c241c723cULL, 0x000fe20000001814ULL, 0x000054102c217816ULL, 0x004fcc000000003bULL,
0x00000022002f7306ULL, 0x0002b00000200c00ULL, 0x0000002e00337306ULL, 0x000ee20000200c00ULL,
0x000000202420723cULL, 0x002fe2000000183cULL, 0x000054102f147816ULL, 0x004fc40000000000ULL,
0x0000541033157816ULL, 0x008fce0000000002ULL, 0x000000142424723cULL, 0x000fe20000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff027f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff157224ULL, 0x002fc600078e0003ULL,
0x0000030064647a10ULL, 0x000fc80007ffe0ffULL, 0x000000626400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff331000007947ULL, 0x000fea000383ffffULL,
0x0000000000337919ULL, 0x000ee20000002500ULL, 0x000000ffff297224ULL, 0x000fe400078e001fULL,
0x000000ffff1f7224ULL, 0x000fe400078e0010ULL, 0x000000ffff317224ULL, 0x004fe400078e0027ULL,
0x000000ffff307224ULL, 0x000fe400078e0026ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0025ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0024ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0023ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0022ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0020ULL,
0x000000ffff107224ULL, 0x000fe400078e000eULL, 0x000000ffff2a7224ULL, 0x000fe400078e0021ULL,
0x000000ffff287224ULL, 0x000fe200078e001eULL, 0x000000623300720cULL, 0x008fe20003f06070ULL,
0x000000ffff267224ULL, 0x000fc400078e001dULL, 0x000000ffff277224ULL, 0x000fe400078e001cULL,
0x000000ffff257224ULL, 0x000fe400078e001bULL, 0x000000ffff247224ULL, 0x000fe400078e001aULL,
0x000000ffff227224ULL, 0x000fe400078e0019ULL, 0x000000ffff237224ULL, 0x000fe400078e0018ULL,
0x000000ffff207224ULL, 0x000fc400078e0012ULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff217224ULL, 0x000fe400078e0013ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0007ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0006ULL,
0x000000ffff187224ULL, 0x000fc400078e0005ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000bULL, 0x000000ffff167224ULL, 0x000fe400078e000aULL,
0x000000ffff147224ULL, 0x002fe400078e0009ULL, 0x000000ffff197224ULL, 0x000fe400078e0008ULL,
0x000000ffff127224ULL, 0x000fc400078e000fULL, 0x000000ffff0d7224ULL, 0x000fe200078e000cULL,
0x0000036000000947ULL, 0x000fea0003800000ULL, 0x018000005d007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000de2000047802ULL, 0x000fe40000000f00ULL, 0x0000948000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000005d00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc8000000005dULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006900ff037624ULL, 0x000fe400078e00ffULL, 0x00006800ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff077819ULL, 0x020fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x01cfca0000410000ULL, 0x00001f0700047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000000d040d7220ULL, 0x044fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x000fe20000410000ULL, 0x0000001005107220ULL, 0x048fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002805287220ULL, 0x040fe20000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x0000000202057811ULL, 0x040fe400078ff8ffULL,
0x0000000402067811ULL, 0x000fe400078ff8ffULL, 0x0000000800177811ULL, 0x000fe400078ff0ffULL,
0x0000000705037812ULL, 0x000fe400078e780fULL, 0x00000001ff047819ULL, 0x000fc40000011602ULL,
0x00000006020a7811ULL, 0x000fe200078ff8ffULL, 0x000000080f097824ULL, 0x000fe200078e0203ULL,
0x0000000706087812ULL, 0x040fe200078e780fULL, 0x0000080067037824ULL, 0x000fe200078e00ffULL,
0x0000000706067812ULL, 0x000fe400078e7817ULL, 0x0000000704027812ULL, 0x100fe200078e780fULL,
0x000000080f0b7824ULL, 0x000fe200078e0208ULL, 0x000000070a0c7812ULL, 0x000fe200078e780fULL,
0x0000000817157824ULL, 0x000fe200078e0206ULL, 0x0000000704047812ULL, 0x100fe200078e7817ULL,
0x000000080f077824ULL, 0x000fe200078e0202ULL, 0x0000000705057812ULL, 0x100fe200078e7817ULL,
0x0000000800067824ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x000fe200078e7817ULL,
0x0000000817117824ULL, 0x000fe200078e0204ULL, 0x0000a00003027810ULL, 0x000fe20007ffe0ffULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x0000000d0e04723eULL, 0x000fe200000000ffULL,
0x000000080f0f7824ULL, 0x000fe200078e020cULL, 0x0000000806067812ULL, 0x000fe200078ec0ffULL,
0x0000000817177824ULL, 0x000fe200078e020aULL, 0x000000191405723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x000000101208723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x0000763204197816ULL, 0x000fe20000000005ULL,
0x000000100b0d7824ULL, 0x000fc400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001013137824ULL, 0x100fe400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x000fe400078e0202ULL,
0x00000001070a7824ULL, 0x000fe200078e0206ULL, 0x0000001f1e07723eULL, 0x000fe200000000ffULL,
0x00000001060b7824ULL, 0x000fe200078e0209ULL, 0x000000161a09723eULL, 0x000fe200000000ffULL,
0x00000001060d7824ULL, 0x000fc400078e020dULL, 0x0000000106117824ULL, 0x040fe400078e0211ULL,
0x0000000106137824ULL, 0x040fe400078e0213ULL, 0x00000001060f7824ULL, 0x040fe400078e020fULL,
0x0000000106157824ULL, 0x040fe400078e0215ULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x0000001b1806723eULL, 0x000fe200000000ffULL, 0x00000300ff127624ULL, 0x000fe200078e00ffULL,
0x0000541004187816ULL, 0x000fc40000000005ULL, 0x000000232204723eULL, 0x000fe400000000ffULL,
0x000000272605723eULL, 0x000fe200000000ffULL, 0x000000180a007388ULL, 0x0005e20000000a00ULL,
0x000000011200780cULL, 0x000fe40003f05270ULL, 0x0000541006187816ULL, 0x144fe40000000007ULL,
0x0000763206197816ULL, 0x000fe40000000007ULL, 0x00005410040a7816ULL, 0x000fc40000000005ULL,
0x0000002b2a06723eULL, 0x000fe200000000ffULL, 0x000000180b007388ULL, 0x0005e20000000a00ULL,
0x0000002f2e07723eULL, 0x000fe400000000ffULL, 0x00007632040b7816ULL, 0x004fe40000000005ULL,
0x0000001c1d04723eULL, 0x000fe400000000ffULL, 0x000000202105723eULL, 0x000fe200000000ffULL,
0x0000000a0d007388ULL, 0x0005e40000000a00ULL, 0x00005410060a7816ULL, 0x004fc40000000007ULL,
0x00007632060b7816ULL, 0x000fe40000000007ULL, 0x000000242506723eULL, 0x000fe400000000ffULL,
0x000000282907723eULL, 0x000fe200000000ffULL, 0x0000000a0f007388ULL, 0x0005e40000000a00ULL,
0x00005410080a7816ULL, 0x144fe40000000009ULL, 0x00007632080b7816ULL, 0x000fe40000000009ULL,
0x0000002c2d08723eULL, 0x000fc400000000ffULL, 0x000000303109723eULL, 0x000fe200000000ffULL,
0x0000000a11007388ULL, 0x0005e40000000a00ULL, 0x00005410040a7816ULL, 0x144fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a13007388ULL, 0x0005e20000000a00ULL,
0x0000541008067816ULL, 0x000fc40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x0000000415007388ULL, 0x0005e80000000a00ULL, 0x0000000617007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b6000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ee20000002700ULL, 0x0000001000097824ULL, 0x000fe200078e0203ULL,
0x000000ff6700720cULL, 0x000fe20003f05270ULL, 0x0000580012047a24ULL, 0x004fe200078e02ffULL,
0x0000000000057919ULL, 0x000ee20000002600ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x00000020000f7810ULL, 0x000fe20007ffe0ffULL, 0x0000660004087a24ULL, 0x000fe200078e02ffULL,
0x00a0000009147984ULL, 0x0005220000000c00ULL, 0x000000ff0000720cULL, 0x000fc60000725670ULL,
0x00a2000009187984ULL, 0x0004620000000c00ULL, 0x0000580010107a24ULL, 0x008fe200078e0205ULL,
0x00000fff08057811ULL, 0x000fc600078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x00000001040a7824ULL, 0x000fca00078e0233ULL, 0x0000000a05067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x0000040067067825ULL, 0x000fcc00078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x00000010000c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08077812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x016fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff067424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008117812ULL, 0x000fe400078ec0ffULL, 0x0000000c09137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a087625ULL, 0x000fc800078e0006ULL, 0x00006c000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000813087210ULL, 0x000fc80007b5e011ULL, 0x0000000a130a7210ULL, 0x000fe40007d9e011ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000005e08007986ULL, 0x0003e8000c101906ULL, 0x0000005d0a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x0163e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff120b7810ULL, 0x000fc60007ffe0ffULL, 0x00006a0010087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000800000ULL,
0x00000006ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x004ea40000000000ULL,
0x000000ff0600720cULL, 0x004fda0003f25270ULL, 0x000027a000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff177424ULL, 0x002fe200078e00ffULL, 0x0000000c080c7812ULL, 0x000fe400078ec0ffULL,
0x0000007006197812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e0017ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x0000000a0c0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608067981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021200780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000041200780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000041200780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0017ULL, 0x000000080c087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608137981ULL, 0x000362000c1e1900ULL,
0x000000061200780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608157981ULL, 0x000362000c1e1900ULL, 0x000000061200780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081200780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0017ULL,
0x000000080c087210ULL, 0x000fe40007a3e019ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0017ULL,
0x0000000608177981ULL, 0x000366000c1e1900ULL, 0x0000000a0c0a0210ULL, 0x000fc80007c7e019ULL,
0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL, 0x000000060a0b0981ULL, 0x000366000c1e1900ULL,
0x0000000712087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x00000008190c7824ULL, 0x040fe200078e00ffULL, 0x0000000119197810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x0000000a1900720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c097810ULL, 0x040fe40007ffe0ffULL,
0x000000010c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e01bULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006081b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c097810ULL, 0x042fe40007ffe0ffULL, 0x000000020c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000000d06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0e7819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000030c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000000f06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000040c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000050c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c097810ULL, 0x042fe40007ffe0ffULL, 0x000000060c087810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x0000030008007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000810087210ULL, 0x000fc80007b3e015ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c097810ULL, 0x042fe40007ffe0ffULL,
0x000000070c087810ULL, 0x000fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x0000030008007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000810087210ULL, 0x000fc80007b3e017ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c097810ULL, 0x002fe40007ffe0ffULL, 0x0000000b06067209ULL, 0x000fe40007810000ULL,
0x0000030009007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x00000001ff0c7819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0c7812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000080c087210ULL, 0x000fc80007a3e00bULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080b7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000609007388ULL, 0x0203e40000000800ULL,
0x000000070000780cULL, 0x000fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000000405087211ULL, 0x000fe200078fa0ffULL, 0x00001000ff097424ULL, 0x002fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x100fe20000011600ULL, 0x00000400673b7824ULL, 0x000fe200078e00ffULL,
0x00000016ff3d7819ULL, 0x000fe20000011667ULL, 0x00006c0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0a0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000020000d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001000067824ULL, 0x000fe200078e00ffULL,
0x0000003b08087210ULL, 0x000fe20007f3e0ffULL, 0x00000001040e8824ULL, 0x000fe200078e0207ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fe200078ec0ffULL, 0x00000080ff118424ULL, 0x000fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000109097824ULL, 0x000fe200008e063dULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x0000100067217824ULL, 0x040fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00006c000e0e8625ULL, 0x000fe200078e000fULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000001067158824ULL, 0x000fe200078e0200ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00006c0004108625ULL, 0x000fc600078e0011ULL,
0x0000458015158811ULL, 0x000fe200078e20ffULL, 0x0000000106177824ULL, 0x000fe400078e020bULL,
0x0000001067198824ULL, 0x000fe400078e0200ULL, 0x0000001000137824ULL, 0x040fe400078e0221ULL,
0x00000010000a7825ULL, 0x100fe200078e0008ULL, 0x0000418019198811ULL, 0x000fe200078e20ffULL,
0x0000000017177984ULL, 0x000e640000000800ULL, 0x000000100d0c7825ULL, 0x000fc400078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000010000e8825ULL, 0x040fe400078e000eULL,
0x003800000c137faeULL, 0x0007e4000b901c46ULL, 0x0000001000108825ULL, 0x000fe400078e0010ULL,
0x000000000e158faeULL, 0x0009e4000b901c46ULL, 0x000000ffff067224ULL, 0x000fc400078e00ffULL,
0x0000000010198faeULL, 0x000be2000b901c46ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x00000000000a7805ULL, 0x004fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x008fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x020fe2000001ff00ULL,
0x00000d0000009947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e00ffULL, 0x0000000132337810ULL, 0x000fc80007ffe0ffULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x0000000104347824ULL, 0x000fe200078e0233ULL, 0x000000070000780cULL, 0x040fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001331e7812ULL, 0x040fe200078ec0ffULL,
0x00000800331a7824ULL, 0x000fe200078e00ffULL, 0x0000003405187211ULL, 0x000fe400078fa0ffULL,
0x0000002000397810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018187625ULL, 0x000fc800078e0019ULL, 0x00000001071b9824ULL, 0x000fe200078e0234ULL,
0x0000003b18187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff369424ULL, 0x000fe400078e00ffULL,
0x00000002671f9824ULL, 0x000fe400078e021eULL, 0x00000080ff359424ULL, 0x000fe400078e00ffULL,
0x00006c001b1a9625ULL, 0x000fc800078e0036ULL, 0x00000001211d7824ULL, 0x000fe400078e021cULL,
0x00000002673f9824ULL, 0x000fe400078e021eULL, 0x0000000119197824ULL, 0x000fe400000e063dULL,
0x000000081f379824ULL, 0x000fe400078e0200ULL, 0x00006c00341e9625ULL, 0x000fc600078e0035ULL,
0x0000458037379811ULL, 0x000fe200078e20ffULL, 0x0000001000357824ULL, 0x040fe400078e021dULL,
0x000000083f3f9824ULL, 0x000fe400078e0200ULL, 0x00000010001c9825ULL, 0x000fc800078e001aULL,
0x00000010391a7825ULL, 0x000fe200078e0018ULL, 0x000041803f399811ULL, 0x000fc600078e20ffULL,
0x0000001000187825ULL, 0x000fc800078e0018ULL, 0x00000010001e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018357faeULL, 0x0005e8000b901c46ULL,
0x003800001a357faeULL, 0x0005e8000b901c46ULL, 0x000000001c379faeULL, 0x0005e8000b901c46ULL,
0x000000001e399faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0032ULL, 0x00000001ff1a7819ULL, 0x100fe20000011600ULL,
0x0000001000197824ULL, 0x000fe200078e00ffULL, 0x00000002ff357819ULL, 0x000fe20000011600ULL,
0x000000801b187824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x00000008351f7824ULL, 0x040fe200078e00ffULL,
0x0000008018187812ULL, 0x000fe200078ec0ffULL, 0x00000008351d7824ULL, 0x040fe200078e00ffULL,
0x00000007353c7812ULL, 0x000fe400078ec0ffULL, 0x00000035ff3a7212ULL, 0x000fe200078e33ffULL,
0x0000010067187824ULL, 0x000fe200078e0218ULL, 0x0000000835377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81f3a7812ULL, 0x000fc400078ee23aULL, 0x000000181a1a7210ULL, 0x000fe20007ffe019ULL,
0x0000000835197824ULL, 0x000fe200078e00ffULL, 0xfffffff81d187812ULL, 0x000fe200078ee23cULL,
0x00000008371d7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001a387984ULL, 0x000ea20000000800ULL, 0x00000001191c7812ULL, 0x100fe200078ef63cULL,
0x00000008373e7824ULL, 0x000fe200078e00ffULL, 0x00000002191e7812ULL, 0x140fe200078ef63cULL,
0x004580001a4a7984ULL, 0x0004e20000000800ULL, 0x0000000319327812ULL, 0x140fe400078ef63cULL,
0x0000000419347812ULL, 0x140fe400078ef63cULL, 0x0000000519367812ULL, 0x000fe400078ef63cULL,
0x00000037ff487212ULL, 0x000fc800078e33ffULL, 0xfffffff81d487812ULL, 0x000fe400078ee248ULL,
0x00000007371d7812ULL, 0x000fe200078ec0ffULL, 0x00000038171a7221ULL, 0x006fe20000010100ULL,
0x0000000619387812ULL, 0x000fe200078ef63cULL, 0x000008001b197824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b1a1f7820ULL, 0x000fe20000410000ULL, 0x00000004001b7824ULL, 0x000fe400078e00ffULL,
0x00000800191a7812ULL, 0x000fe200078ec0ffULL, 0x00000008373c7824ULL, 0x000fc400078e00ffULL,
0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000001f001f7308ULL, 0x000ee20000000800ULL,
0x0000018021197810ULL, 0x000fe40007ffe01aULL, 0xfffffff83e1a7812ULL, 0x100fe400078ee21dULL,
0x000000013c3e7812ULL, 0x000fe200078ef61dULL, 0x0000001018187824ULL, 0x000fe200078e0219ULL,
0x000000033c427812ULL, 0x000fe200078ef61dULL, 0x000000101c1c7824ULL, 0x000fe200078e0219ULL,
0x000000023c407812ULL, 0x000fe200078ef61dULL, 0x0000000118187824ULL, 0x000fe200078e021bULL,
0x000000043c447812ULL, 0x140fe200078ef61dULL, 0x000000011b1c7824ULL, 0x000fe200078e021cULL,
0x000000053c467812ULL, 0x000fe200078ef61dULL, 0x0000001032327824ULL, 0x000fe200078e0219ULL,
0x000000063c3c7812ULL, 0x000fe200078ef61dULL, 0x0000000018187984ULL, 0x000e620000000800ULL,
0x000000103a3a7824ULL, 0x000fe200078e0219ULL, 0x0000004a1f4a7220ULL, 0x008fe20000410000ULL,
0x000000011b327824ULL, 0x040fe200078e0232ULL, 0x000000001c1c7984ULL, 0x000fe20000000800ULL,
0x000000011b3a7824ULL, 0x000fe200078e023aULL, 0x000000314a317221ULL, 0x000fe20000010000ULL,
0x0000001036367824ULL, 0x100fe200078e0219ULL, 0x00001f354a1f7589ULL, 0x000ea200000e0000ULL,
0x000000101e1e7824ULL, 0x000fc400078e0219ULL, 0x000000011b367824ULL, 0x040fe200078e0236ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000011b1e7824ULL, 0x040fe400078e021eULL,
0x0000001038387824ULL, 0x100fe200078e0219ULL, 0x000000003a3a7984ULL, 0x000ee20000000800ULL,
0x0000001034347824ULL, 0x000fe400078e0219ULL, 0x000000011b387824ULL, 0x040fe200078e0238ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x000000011b347824ULL, 0x000fc400078e0234ULL,
0x000000103e3e7824ULL, 0x100fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000f220000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0219ULL, 0x000000011b3e7824ULL, 0x040fe200078e023eULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x000000011b1a7824ULL, 0x000fe400078e021aULL,
0x0000001042427824ULL, 0x100fe200078e0219ULL, 0x0000000034347984ULL, 0x000f620000000800ULL,
0x0000001040407824ULL, 0x000fc400078e0219ULL, 0x000000011b427824ULL, 0x040fe200078e0242ULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x000000011b407824ULL, 0x040fe400078e0240ULL,
0x0000001044447824ULL, 0x100fe200078e0219ULL, 0x000000001a1a7984ULL, 0x000f620000000800ULL,
0x0000001046467824ULL, 0x000fe400078e0219ULL, 0x000000011b447824ULL, 0x040fe200078e0244ULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x000000011b467824ULL, 0x000fc400078e0246ULL,
0x000000103c3c7824ULL, 0x100fe200078e0219ULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x0000001048487824ULL, 0x000fe400078e0219ULL, 0x20000018ff197230ULL, 0x002fe20000004100ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x000000011b3c7824ULL, 0x040fe400078e023cULL,
0x000000011b487824ULL, 0x000fe200078e0248ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x0000001f19307223ULL, 0x004fe20000010030ULL, 0x2000001cff197230ULL, 0x000fc40000004100ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x2000003aff1b7230ULL, 0x008fe40000004100ULL,
0x0000001f192e7223ULL, 0x080fe2000001002eULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x20000032ff197230ULL, 0x000fe20000004100ULL, 0x0000001f1b227223ULL, 0x080fe20000010022ULL,
0x2000001eff1b7230ULL, 0x010fe20000004100ULL, 0x00001f374a4a7589ULL, 0x000e6200000e0000ULL,
0x30000032ff327230ULL, 0x000fe20000004100ULL, 0x0000001f192a7223ULL, 0x080fe2000001002aULL,
0x20000036ff197230ULL, 0x000fe20000004100ULL, 0x0000001f1b2c7223ULL, 0x080fe2000001002cULL,
0x20000034ff1b7230ULL, 0x020fe20000004100ULL, 0x0000001f32297223ULL, 0x080fe20000010029ULL,
0x000000ffff327224ULL, 0x000fe200078e0033ULL, 0x0000001f19267223ULL, 0x080fe20000010026ULL,
0x20000038ff197230ULL, 0x000fe20000004100ULL, 0x0000001f1b287223ULL, 0x080fe20000010028ULL,
0x3000003aff1d7230ULL, 0x000fe20000004100ULL, 0x0000030032007a0cULL, 0x000fe20003f06070ULL,
0x2000001aff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f19247223ULL, 0x080fe20000010024ULL,
0x2000003eff197230ULL, 0x000fe20000004100ULL, 0x0000001f1d207223ULL, 0x000fe20000010020ULL,
0x30000018ff187230ULL, 0x000fc40000004100ULL, 0x3000001cff1c7230ULL, 0x000fe40000004100ULL,
0x3000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000001f182f7223ULL, 0x080fe2000001002fULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x0000004a19147223ULL, 0x082fe20000010014ULL,
0x0000004a1b167223ULL, 0x080fe20000010016ULL, 0x20000042ff197230ULL, 0x000fe20000004100ULL,
0x0000001f1c2d7223ULL, 0x080fe2000001002dULL, 0x20000040ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1e2b7223ULL, 0x080fe2000001002bULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x0000004a19107223ULL, 0x080fe20000010010ULL, 0x20000044ff197230ULL, 0x000fe20000004100ULL,
0x0000004a1b127223ULL, 0x080fe20000010012ULL, 0x20000046ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f34277223ULL, 0x080fe20000010027ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000004a190e7223ULL, 0x080fe2000001000eULL, 0x2000003cff197230ULL, 0x000fe20000004100ULL,
0x0000004a1b0c7223ULL, 0x080fe2000001000cULL, 0x3000001aff1a7230ULL, 0x000fe20000004100ULL,
0x0000001f36257223ULL, 0x080fe20000010025ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000001f38237223ULL, 0x000fe20000010023ULL, 0x30000040ff407230ULL, 0x000fe20000004100ULL,
0x0000004a1a157223ULL, 0x080fe20000010015ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000004a3e137223ULL, 0x080fe20000010013ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000004a40117223ULL, 0x080fe20000010011ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000004a420f7223ULL, 0x080fe2000001000fULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000004a440d7223ULL, 0x080fe2000001000dULL, 0x20000048ff1b7230ULL, 0x100fe20000004100ULL,
0x0000004a460b7223ULL, 0x080fe2000001000bULL, 0x30000048ff1d7230ULL, 0x000fe20000004100ULL,
0x0000004a190a7223ULL, 0x080fe2000001000aULL, 0x0000004a3c097223ULL, 0x080fe20000010009ULL,
0x0000004a1b087223ULL, 0x000fc40000010008ULL, 0x0000004a1d067223ULL, 0x000fe20000010006ULL,
0xfffff32000008947ULL, 0x000fea000383ffffULL, 0x0180000031007810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000000007812ULL, 0x000fc600078ec0ffULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff5d7224ULL, 0x000fe200078e0031ULL,
0x000108c000047802ULL, 0x000fe40000000f00ULL, 0x000069e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003100047308ULL, 0x000ea40000001000ULL, 0xbf80000004007423ULL, 0x004fc80000000031ULL,
0x800000ff00057221ULL, 0x000fc80000010100ULL, 0x0000000504047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008003f7811ULL, 0x004fe400078ff0ffULL,
0x00000002ff317819ULL, 0x000fe40000011600ULL, 0x0000003fff417212ULL, 0x000fe200078e33ffULL,
0x00001f3f04077589ULL, 0x000ea200000e0000ULL, 0x000000083f187824ULL, 0x000fc400078e00ffULL,
0x0000000831437824ULL, 0x000fe200078e00ffULL, 0x00001f3104057589ULL, 0x00072400000e0000ULL,
0xfffffff818417812ULL, 0x000fca00078ee241ULL, 0x0000001041417824ULL, 0x000fe200078e0202ULL,
0x00000031ff047212ULL, 0x008fc800078e33ffULL, 0xfffffff843437812ULL, 0x000fe400078ee204ULL,
0x0000000731047812ULL, 0x000fe200078ec0ffULL, 0x0000001607167220ULL, 0x044fe20000410000ULL,
0x0000001507157220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x0000001107117220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f070f7220ULL, 0x040fe20000410000ULL, 0x0000000e070e7220ULL, 0x040fe20000410000ULL,
0x0000000d070d7220ULL, 0x040fe20000410000ULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x0000000b070b7220ULL, 0x040fe20000410000ULL, 0x0000000a070a7220ULL, 0x040fe20000410000ULL,
0x0000000907097220ULL, 0x040fe20000410000ULL, 0x0000000807087220ULL, 0x040fe20000410000ULL,
0x0000000607077220ULL, 0x000fe20000410000ULL, 0x0000000831067824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000003005307220ULL, 0x010fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000002f052f7220ULL, 0x000fe20000410000ULL,
0x0000000a0909723eULL, 0x000fe200000000ffULL, 0x0000002e052e7220ULL, 0x000fe20000410000ULL,
0x000000080707723eULL, 0x000fe200000000ffULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0xfffffff806177812ULL, 0x002fe200078ee231ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000000104067812ULL, 0x040fe200078e3cffULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x0000000204087812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x000fe200078e0202ULL,
0x00000003040a7812ULL, 0x040fe200078e3cffULL, 0x0000000831197824ULL, 0x040fe200078e0206ULL,
0x00000004040c7812ULL, 0x040fe200078e3cffULL, 0x00000008311b7824ULL, 0x040fe200078e0208ULL,
0x00000005040e7812ULL, 0x040fe200078e3cffULL, 0x00000008311d7824ULL, 0x040fe200078e020aULL,
0x0000000604047812ULL, 0x000fe200078e3cffULL, 0x00000008311f7824ULL, 0x000fe200078e020cULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000000831217824ULL, 0x000fe200078e020eULL,
0x000000073f127812ULL, 0x000fe200078ec0ffULL, 0x0000000831317824ULL, 0x000fe200078e0204ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000000083f147824ULL, 0x000fe200078e00ffULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x0000000400107824ULL, 0x000fe200078e00ffULL,
0x0000000112047812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0202ULL,
0x0000000212067812ULL, 0x040fe200078e3cffULL, 0x0000002a052a7220ULL, 0x000fe20000410000ULL,
0x0000000312087812ULL, 0x040fe200078e3cffULL, 0x000000083f357824ULL, 0x040fe200078e0204ULL,
0x00000004120a7812ULL, 0x040fe200078e3cffULL, 0x000000083f377824ULL, 0x040fe200078e0206ULL,
0x00000005120c7812ULL, 0x040fe200078e3cffULL, 0x000000083f397824ULL, 0x040fe200078e0208ULL,
0x00000006120e7812ULL, 0x000fe200078e3cffULL, 0x000000083f3b7824ULL, 0x040fe200078e020aULL,
0xfffffff814337812ULL, 0x000fe200078ee23fULL, 0x000000083f3d7824ULL, 0x040fe200078e020cULL,
0x0000000c101c7812ULL, 0x000fe200078ec0ffULL, 0x000000083f3f7824ULL, 0x000fe200078e020eULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000001043067824ULL, 0x100fe200078e0202ULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x000fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000001033337824ULL, 0x100fe200078e0202ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x000000011c047824ULL, 0x040fe200078e0217ULL,
0x0000002305237220ULL, 0x000fe20000410000ULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000002205227220ULL, 0x000fe20000410000ULL, 0x0000001021217824ULL, 0x100fe200078e0202ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x0000001031317824ULL, 0x100fe200078e0202ULL,
0x0000002005057220ULL, 0x000fe20000410000ULL, 0x0000001035357824ULL, 0x100fe200078e0202ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000001037377824ULL, 0x100fe200078e0202ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000001039397824ULL, 0x100fe200078e0202ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0202ULL,
0x0000002f04007388ULL, 0x0003e20000000800ULL, 0x000000103f3f7824ULL, 0x000fe200078e0202ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x000000011c107824ULL, 0x040fe200078e0206ULL,
0x000000220505723eULL, 0x000fe200000000ffULL, 0x000000011c027824ULL, 0x040fe200078e0219ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x000000011c067824ULL, 0x000fc400078e021bULL,
0x000000011c087824ULL, 0x040fe200078e021dULL, 0x0000002d02007388ULL, 0x0005e20000000800ULL,
0x000000011c0a7824ULL, 0x040fe400078e021fULL, 0x000000011c0c7824ULL, 0x040fe200078e0221ULL,
0x0000002b06007388ULL, 0x0005e20000000800ULL, 0x000000011c0e7824ULL, 0x040fe400078e0231ULL,
0x000000011c127824ULL, 0x040fe200078e0233ULL, 0x0000002908007388ULL, 0x0005e20000000800ULL,
0x000000011c147824ULL, 0x000fc400078e0235ULL, 0x000000011c047824ULL, 0x042fe200078e0237ULL,
0x000000270a007388ULL, 0x0005e20000000800ULL, 0x000000011c167824ULL, 0x040fe400078e0239ULL,
0x000000011c187824ULL, 0x040fe200078e023bULL, 0x000000250c007388ULL, 0x0005e20000000800ULL,
0x000000011c1e7824ULL, 0x040fe400078e0241ULL, 0x000000011c1a7824ULL, 0x040fe200078e023dULL,
0x000000230e007388ULL, 0x0005e20000000800ULL, 0x000000011c1c7824ULL, 0x000fc600078e023fULL,
0x0000000510007388ULL, 0x0005e80000000800ULL, 0x0000001512007388ULL, 0x0005e80000000800ULL,
0x0000001314007388ULL, 0x0005e80000000800ULL, 0x0000001104007388ULL, 0x0005e80000000800ULL,
0x0000000f16007388ULL, 0x0005e80000000800ULL, 0x0000000d18007388ULL, 0x0005e80000000800ULL,
0x0000000b1a007388ULL, 0x0005e80000000800ULL, 0x000000091c007388ULL, 0x0005e80000000800ULL,
0x000000071e007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000020000d7810ULL, 0x006fe20007ffe0ffULL, 0x00000000000c7919ULL, 0x000e620000002600ULL,
0x00000003ff057819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x100fe2000001160dULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000705077812ULL, 0x000fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000704067812ULL, 0x000fc400078e480dULL, 0x0ffffff807027812ULL, 0x000fe400078ef800ULL,
0x0ffffff806067812ULL, 0x000fe400078ef80dULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000001002027824ULL, 0x100fe200078e0203ULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x1ffffff807077812ULL, 0x100fe400078ef860ULL,
0x00a0000002087984ULL, 0x000ee20000000c00ULL, 0x1ffffff80d0d7812ULL, 0x000fc600078ef860ULL,
0x00a0000006107984ULL, 0x0009620000000c00ULL, 0x000000080c0e7824ULL, 0x042fe400078e00ffULL,
0x000000080c037824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0xfffffff80e057812ULL, 0x000fe400078ee205ULL, 0xfffffff803047812ULL, 0x000fe400078ee204ULL,
0x0000000405037c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000404057c10ULL, 0x000fc6000ff3e0ffULL,
0x000000ffff067224ULL, 0x010fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fe400078248ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4c06ULL, 0x00005b0005057a11ULL, 0x000fc600008f4c00ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x000fca0000011667ULL,
0x0000000264027824ULL, 0x000fca00078e0203ULL, 0x000000630200720cULL, 0x000fda0003f06070ULL,
0x0000000214038824ULL, 0x000fc800078e00ffULL, 0x0000640003068a24ULL, 0x004fe400078e0202ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000600006068625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff087624ULL, 0x000fe200078e00ffULL,
0x0000000606038981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff097624ULL, 0x000fc600078e00ffULL,
0x01060000ff047f8cULL, 0x000e68000c80043fULL, 0x0000000608277981ULL, 0x000762000c1e9900ULL,
0x00000001640b7810ULL, 0x000fe20007ffe0ffULL, 0x0000004067257824ULL, 0x000fe400078e00ffULL,
0x0000008068687824ULL, 0x000fe200078e00ffULL, 0x000000620b00720cULL, 0x000fe20003f06070ULL,
0x00000100640b7824ULL, 0x000fc400078e0225ULL, 0x0000008024247824ULL, 0x000fc600078e00ffULL,
0x0000004068187812ULL, 0x000fe200078ef80bULL, 0x0000002403217224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x00afe40000011666ULL,
0x0000000b65007217ULL, 0x000fe40007800000ULL, 0x000000081d117810ULL, 0x040fe20007ffe0ffULL,
0x000000011d067824ULL, 0x140fe200078e0218ULL, 0x000000181d237810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000101d177810ULL, 0x000fe40007ffe0ffULL,
0x0000000621137210ULL, 0x000fe20007f1e0ffULL, 0x0000000111067824ULL, 0x100fe200078e0218ULL,
0x000000300e1f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117077824ULL, 0x000fe200078e0218ULL,
0x00000003ff0d7819ULL, 0x000fe20000011666ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005e00130a7a11ULL, 0x000fe200078040ffULL, 0x00000004170e7824ULL, 0x000fe200078e00ffULL,
0x0000000721127210ULL, 0x000fc40007f3e0ffULL, 0x00005f0013137a11ULL, 0x000fe200000f4408ULL,
0x0000000123087824ULL, 0x000fe200078e0218ULL, 0x0000000621067210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x000000030d0d7812ULL, 0x000fe400078e4866ULL,
0x0000000821087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e00060c7a11ULL, 0x000fe400078040ffULL, 0x00005e00120b7a11ULL, 0x000fe200078240ffULL,
0x000000ffff077224ULL, 0x000fe200010e06ffULL, 0x00005e0008107a11ULL, 0x000fc400078440ffULL,
0x00005f0006157a11ULL, 0x000fe400000f4415ULL, 0x00005f0008167a11ULL, 0x000fe200010f4407ULL,
0x0000000411087824ULL, 0x000fe200078e00ffULL, 0x0000000a1f067210ULL, 0x000fe40007f7e0ffULL,
0x000000001d00720cULL, 0x000fe40003f06070ULL, 0xfffffffc080a7812ULL, 0x000fe200078ee20dULL,
0x000000ffff077224ULL, 0x000fe200018e0613ULL, 0x00002000670f7811ULL, 0x000fc400078e68ffULL,
0x0000001f0c087210ULL, 0x080fe40007f7e0ffULL, 0x0ffffffc0d667812ULL, 0x000fe200078ef866ULL,
0x000000100a137824ULL, 0x000fe200078e020fULL, 0x000000001700720cULL, 0x080fe40003f46070ULL,
0xfffffffc0e0c7812ULL, 0x000fe200078ee20dULL, 0x00000004230e7824ULL, 0x000fe200078e00ffULL,
0x000000201d177810ULL, 0x000fe40007ffe0ffULL, 0x00005f0012127a11ULL, 0x000fe200008f4409ULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0x000000001100720cULL, 0x080fe20003f26070ULL,
0x0000001066117824ULL, 0x100fe200078e020fULL, 0x0000001f0b0a7210ULL, 0x000fe20007f9e0ffULL,
0x000000100c157824ULL, 0x000fe200078e020fULL, 0x000000281d197810ULL, 0x000fe20007ffe0ffULL,
0x00000001180c7824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000c101c46ULL, 0x000000ffff0b7224ULL, 0x000fe200020e0612ULL,
0x000000002300720cULL, 0x000fc40003f86070ULL, 0x0000000c21127210ULL, 0x000fe40007f1e0ffULL,
0x000000301d1b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000008137faeULL, 0x0005e2000c901c46ULL,
0x00005e00120c7a11ULL, 0x000fe400078c40ffULL, 0x000000381d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a157faeULL, 0x0007e2000d101c46ULL, 0x000000ffff077224ULL, 0x002fe200000e06ffULL,
0x0000001f10067210ULL, 0x000fe40007fbe0ffULL, 0x000000001700720cULL, 0x000fc40003f66070ULL,
0x00005f0012127a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0616ULL,
0xfffffffc0e087812ULL, 0x004fe200078ee20dULL, 0x000000041d167824ULL, 0x000fe200078e00ffULL,
0x000000001900720cULL, 0x080fe40003f46070ULL, 0x000000001b00720cULL, 0x080fe20003f26070ULL,
0x0000001008097824ULL, 0x000fe200078e020fULL, 0x000000001d00720cULL, 0x000fe20003f06070ULL,
0x0000000118007824ULL, 0x040fe400078e0219ULL, 0x0000000118087824ULL, 0x040fe200078e021bULL,
0x0000000006097faeULL, 0x0003e2000e101c46ULL, 0x00000001180a7824ULL, 0x008fe200078e021dULL,
0x0000000021107210ULL, 0x000fe20007fbe0ffULL, 0x0000000417007824ULL, 0x000fe200078e00ffULL,
0x00000008210e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000419087824ULL, 0x000fe200078e00ffULL,
0x0000000a210b7210ULL, 0x000fe20007fde0ffULL, 0x000000041b0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fc400078ee20dULL, 0xfffffffc08087812ULL, 0x100fe400078ee20dULL,
0xfffffffc0a0a7812ULL, 0x100fe200078ee20dULL, 0x000000ffff077224ULL, 0x002fe200028e06ffULL,
0xfffffffc16067812ULL, 0x000fe200078ee20dULL, 0x0000001000117824ULL, 0x100fe200078e020fULL,
0x00005e0010097a11ULL, 0x000fe200078a40ffULL, 0x0000001008137824ULL, 0x100fe400078e020fULL,
0x000000100a157824ULL, 0x000fe200078e020fULL, 0x00005f0010107a11ULL, 0x000fe200028f4407ULL,
0x00000010060f7824ULL, 0x000fe200078e020fULL, 0x0000001f0c067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e06ffULL, 0x00005e000e0a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff007224ULL, 0x000fe200030e06ffULL, 0x00005e000b0c7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200028e0612ULL, 0x0000001f09087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000e0d7a11ULL, 0x000fe400020f440dULL, 0x0000001f0a0a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff097224ULL, 0x000fe200028e0610ULL, 0x00005f000b007a11ULL, 0x000fe200030f4400ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x0000001f0c0c7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe400020e060dULL, 0x0000000008137faeULL, 0x0003e4000d101c46ULL,
0x000000ffff0d7224ULL, 0x000fc400028e0600ULL, 0x000000000a157faeULL, 0x0003e8000c901c46ULL,
0x000000000c0f7faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001866007211ULL, 0x04afe400078ff0ffULL, 0x0000000866177811ULL, 0x040fe400078ff0ffULL,
0x0000000021007210ULL, 0x000fe40007f1e0ffULL, 0x0000001066067811ULL, 0x000fc400078ff0ffULL,
0x0000001866087811ULL, 0x000fe200078ff0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0000227a11ULL, 0x000fe400078040ffULL, 0x00000028660c7811ULL, 0x000fe200078ff0ffULL,
0x0000000118097824ULL, 0x000fe200078e0208ULL, 0x00005f0000267a11ULL, 0x000fe200000f4407ULL,
0x0000000117007824ULL, 0x000fe200078e0218ULL, 0x00000020660a7811ULL, 0x000fe200078ff0ffULL,
0x0000000118077824ULL, 0x040fe200078e0206ULL, 0x00000003ff157819ULL, 0x000fe20000011666ULL,
0x00000001180d7824ULL, 0x000fe200078e020cULL, 0x00000030660f7811ULL, 0x000fe200078ff0ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0000000021207210ULL, 0x000fe20007fde0ffULL,
0x00000001180b7824ULL, 0x000fe200078e020aULL, 0x0000000315157812ULL, 0x000fe200078e4866ULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000003866117811ULL, 0x000fe200078ff0ffULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0x0000000721137210ULL, 0x040fe20007fbe0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x00000009211c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000118107824ULL, 0x000fe200078e020fULL, 0x0000200067237811ULL, 0x000fe200078e68ffULL,
0x000000040f167824ULL, 0x000fe200078e00ffULL, 0xfffffffc08077812ULL, 0x000fe200078ee215ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0x0000000b211a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000118127824ULL, 0x000fe200078e0211ULL, 0xfffffffc0c097812ULL, 0x100fe200078ee215ULL,
0x0000000406067824ULL, 0x000fe200078e00ffULL, 0x00005e00201e7a11ULL, 0x000fe200078c40ffULL,
0x0000000411187824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x000fe200078ee215ULL,
0x00000010071b7824ULL, 0x000fe200078e0223ULL, 0xfffffffc0a087812ULL, 0x000fe200078ee215ULL,
0x00000010091f7824ULL, 0x000fe200078e0223ULL, 0xfffffffc160a7812ULL, 0x000fe200078ee215ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005f0020207a11ULL, 0x000fe200030f440fULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000001021107210ULL, 0x040fe20007f7e0ffULL,
0x00000010081d7824ULL, 0x000fe200078e0223ULL, 0x0000001221127210ULL, 0x000fc40007f9e0ffULL,
0xfffffffc06067812ULL, 0x000fe200078ee215ULL, 0x000000ffff177224ULL, 0x000fe200018e06ffULL,
0x00005e001a0f7a11ULL, 0x000fe400078240ffULL, 0x0ffffffc15667812ULL, 0x000fe200078ef866ULL,
0x0000001006197824ULL, 0x000fe200078e0223ULL, 0xfffffffc180b7812ULL, 0x000fe200078ee215ULL,
0x0000001000157824ULL, 0x100fe200078e0223ULL, 0x00005e001c0c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200028e06ffULL, 0x0000000d210d7210ULL, 0x000fe20007f5e0ffULL,
0x000000100a217824ULL, 0x100fe200078e0223ULL, 0x000000300e297812ULL, 0x000fe200078ec0ffULL,
0x00000010662b7824ULL, 0x100fe200078e0223ULL, 0x00005e00130a7a11ULL, 0x000fe200078a40ffULL,
0x000000100b237824ULL, 0x000fe200078e0223ULL, 0x00005f001a1a7a11ULL, 0x000fe200008f4407ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200000f4409ULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e0012167a11ULL, 0x000fc400078640ffULL,
0x0000002229067210ULL, 0x000fe40007f1e0ffULL, 0x00005f00130b7a11ULL, 0x000fe400028f4400ULL,
0x00005e000d117a11ULL, 0x040fe400078240ffULL, 0x00005e0010137a11ULL, 0x000fe400078440ffULL,
0x00005f0012007a11ULL, 0x000fe200018f4407ULL, 0x000000ffff077224ULL, 0x000fe200000e0626ULL,
0x00005f000d187a11ULL, 0x000fc400008f4418ULL, 0x0000001e29087210ULL, 0x040fe40007f1e0ffULL,
0x00005f0010177a11ULL, 0x000fe200010f4417ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000062b7faeULL, 0x0003e2000b901c46ULL, 0x0000000a290a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000000c290c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000f290e7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001129107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e061cULL,
0x0000001329127210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e061aULL,
0x0000001629167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200020e0618ULL,
0x0000000008157faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400028e0617ULL,
0x000000ffff177224ULL, 0x000fe200000e0600ULL, 0x000000000a197faeULL, 0x0003e8000b901c46ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e4000b901c46ULL, 0x01060400ff077984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000007ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002067007824ULL, 0x002fc800078e0200ULL,
0x0000002000067824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011600ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x000001e006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105097812ULL, 0x040fe400078efcffULL, 0x0000000705077812ULL, 0x100fe400078e7800ULL,
0x0000000709097812ULL, 0x100fe400078e7800ULL, 0x00000010050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001105057810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fc400078e7800ULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000000705057812ULL, 0x000fe400078e7800ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x00000000090c7984ULL, 0x000ea4000000cc00ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0013ULL, 0x0000001807007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fca00078e000fULL,
0x0000001c09007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x000000000b107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x000000200b007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff047f8cULL, 0x002fe8000c80043fULL,
0x01060400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000067305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe20003800000ULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000626400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000267919ULL, 0x000e620000000000ULL, 0x3d80000027277820ULL, 0x020fe20000410000ULL,
0x0000640014297a24ULL, 0x000fe200078e02ffULL, 0x0001068867287811ULL, 0x040fe200078e18ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e00ffULL, 0xffffffff622b7810ULL, 0x000fe40007ffe0ffULL,
0x00010608672a7811ULL, 0x000fe400078e28ffULL, 0x00000100642e7824ULL, 0x000fe200078e0225ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002e6500720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e002cULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x00000001002f7810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x0000002403407224ULL, 0x020fc400078e02ffULL,
0x00000002ff2d7819ULL, 0x000fe4000001162fULL, 0x000000042f00780cULL, 0x040fe40003f06070ULL,
0x000000032f517812ULL, 0x000fe200078ec0ffULL, 0x000003002d2c7a24ULL, 0x000fe400078e0264ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0000ULL, 0x000001002c3e7824ULL, 0x040fe200078e0225ULL,
0x000000012c317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff007224ULL, 0x000fe200078e002fULL,
0x00000001302c7812ULL, 0x000fc400078e0cffULL, 0x000000623100720cULL, 0x000fe40003f26070ULL,
0x000000403e317812ULL, 0x000fca00078ec0ffULL, 0x00000001683b7824ULL, 0x000fcc00078e0231ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff427819ULL, 0x002fe20000011626ULL,
0x0000000451497824ULL, 0x000fc600078e00ffULL, 0x0000000842447810ULL, 0x040fe20007ffe0ffULL,
0x00000001422f7824ULL, 0x140fe200078e023bULL, 0x00000010424a7810ULL, 0x040fe40007ffe0ffULL,
0x00000018424c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000144317824ULL, 0x100fe200078e023bULL,
0x0000002f40337210ULL, 0x000fe20007f3e0ffULL, 0x000000014a327824ULL, 0x100fe200078e023bULL,
0x0000002842507810ULL, 0x000fe40007ffe0ffULL, 0x0000003140357210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x0000003240317210ULL, 0x000fe20007f7e0ffULL,
0x0000000150397824ULL, 0x000fe200078e023bULL, 0x00005e0033327a11ULL, 0x000fe200078240ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00000020424e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e0031367a11ULL, 0x000fc400078640ffULL,
0x0000003842547810ULL, 0x000fe40007ffe0ffULL, 0x00005f0031377a11ULL, 0x000fe200018f4438ULL,
0x000000014c317824ULL, 0x100fe200078e023bULL, 0x00005e0035347a11ULL, 0x000fe200078440ffULL,
0x000000014e387824ULL, 0x000fe200078e023bULL, 0x00005f0033337a11ULL, 0x000fe400008f443cULL,
0x0000003042527810ULL, 0x000fe40007ffe0ffULL, 0x0000003e652f7217ULL, 0x000fc40007800000ULL,
0x00000031403c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000154317824ULL, 0x100fe200078e023bULL,
0x00005f0035357a11ULL, 0x000fe200010f443aULL, 0x00000001523a7824ULL, 0x000fe200078e023bULL,
0x00000039403d7210ULL, 0x040fe20007fde0ffULL, 0x000000012f2f7824ULL, 0x000fe200078e0a3eULL,
0x00000038403b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x00005e003c387a11ULL, 0x000fe200078240ffULL, 0x000000ffff487224ULL, 0x000fe200030e06ffULL,
0x0000003140417210ULL, 0x000fc40007f7e0ffULL, 0x00000003ff317819ULL, 0x000fe40000011626ULL,
0x0000002f4200720cULL, 0x080fe20003f46070ULL, 0x0000000267427824ULL, 0x000fe200078e022cULL,
0x00005f003c397a11ULL, 0x000fe200008f4439ULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x0000002f4400720cULL, 0x040fe20003f26070ULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x0000000331477812ULL, 0x000fe400078e4826ULL, 0x0000003a403f7210ULL, 0x000fc40007f9e0ffULL,
0x0000200042427811ULL, 0x000fe400078e60ffULL, 0x0ffffffc47437812ULL, 0x100fe200078ef826ULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0xfffffffc49317812ULL, 0x000fe400078ee226ULL,
0xfffffffc44457812ULL, 0x000fe200078ee247ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0x00005e003b3a7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff447224ULL, 0x000fe200018e06ffULL,
0x00005e0041407a11ULL, 0x000fe200078840ffULL, 0x0000001031327825ULL, 0x000fe200078e0032ULL,
0x00005f003b3b7a11ULL, 0x000fc400028f443cULL, 0x00005e003f3e7a11ULL, 0x000fe200078640ffULL,
0x0000001045457824ULL, 0x000fe200078e0242ULL, 0x00005e003d3c7a11ULL, 0x000fe200078a40ffULL,
0x0000001031347825ULL, 0x000fe200078e0034ULL, 0x00005f0041417a11ULL, 0x000fe200020f4444ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032437faeULL, 0x0003e2000d101c46ULL,
0x0000002f5000720cULL, 0x0c0fe20003f86070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x00005f003f3f7a11ULL, 0x000fe200018f4446ULL, 0x0000000034457faeULL, 0x0005e2000c901c46ULL,
0x0000002f4a00720cULL, 0x0c0fe20003f26070ULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x0000002f4c00720cULL, 0x040fe20003f46070ULL, 0x000000044c4c7824ULL, 0x000fe200078e00ffULL,
0x00005f003d3d7a11ULL, 0x000fc400028f4448ULL, 0x0000002f4e00720cULL, 0x0c0fe20003f66070ULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x0000002f5200720cULL, 0x0c0fe20003fa6070ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0x0000002f5400720cULL, 0x040fe20003fc6070ULL,
0x0000000454547824ULL, 0x000fe200078e00ffULL, 0xfffffffc50337812ULL, 0x002fe200078ee247ULL,
0x0000001031347825ULL, 0x044fe200078e0038ULL, 0xfffffffc4a2f7812ULL, 0x100fe400078ee247ULL,
0xfffffffc4c437812ULL, 0x000fe200078ee247ULL, 0x0000001031387825ULL, 0x000fe200078e003cULL,
0xfffffffc4e457812ULL, 0x000fc400078ee247ULL, 0xfffffffc52497812ULL, 0x100fe200078ee247ULL,
0x000000102f2f7824ULL, 0x100fe200078e0242ULL, 0xfffffffc544b7812ULL, 0x000fe200078ee247ULL,
0x0000001033477824ULL, 0x000fe400078e0242ULL, 0x0000001031327825ULL, 0x000fc800078e0036ULL,
0x0000001043437824ULL, 0x100fe200078e0242ULL, 0x00000000322f7faeULL, 0x0003e2000c901c46ULL,
0x0000001045457824ULL, 0x000fe400078e0242ULL, 0x0000001031367825ULL, 0x000fe200078e003aULL,
0x0000000034437faeULL, 0x0003e6000d101c46ULL, 0x0000001049497824ULL, 0x000fe200078e0242ULL,
0x0000000036457faeULL, 0x0003e2000d901c46ULL, 0x00000010313a7825ULL, 0x000fc600078e003eULL,
0x0000000038477faeULL, 0x0003e2000e101c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e0242ULL,
0x00000010313c7825ULL, 0x000fe200078e0040ULL, 0x000000003a497faeULL, 0x0003e8000e901c46ULL,
0x000000003c4b7faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x00000008263a7811ULL, 0x042fe200078ff0ffULL, 0x00000004514d7824ULL, 0x000fe200078e00ffULL,
0x0000003b262f7211ULL, 0x000fc400078ff0ffULL, 0x00000020263c7811ULL, 0x000fe200078ff0ffULL,
0x000000013a317824ULL, 0x000fe200078e023bULL, 0x0000002f402f7210ULL, 0x000fe20007f3e0ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000003026427811ULL, 0x000fe400078ff0ffULL,
0x0000003140317210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00005e002f327a11ULL, 0x000fe200078240ffULL, 0x00000004424c7824ULL, 0x000fe200078e00ffULL,
0x0000003826447811ULL, 0x000fe200078ff0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0031347a11ULL, 0x000fc400078440ffULL, 0x00005f002f337a11ULL, 0x000fe200008f4438ULL,
0x0000000144397824ULL, 0x140fe200078e023bULL, 0x00005f0031357a11ULL, 0x000fe200010f4436ULL,
0x0000000267317824ULL, 0x000fe200078e022cULL, 0x00000003ff2f7819ULL, 0x100fe20000011626ULL,
0x00000004444e7824ULL, 0x000fe200078e00ffULL, 0x0000001026367811ULL, 0x040fe400078ff0ffULL,
0x0000001826387811ULL, 0x000fe400078ff0ffULL, 0x000000032f3d7812ULL, 0x100fe200078e4826ULL,
0x00000001362f7824ULL, 0x100fe200078e023bULL, 0x00002000314b7811ULL, 0x000fe200078e60ffULL,
0x0000000138317824ULL, 0x100fe200078e023bULL, 0x00000028263e7811ULL, 0x000fe200078ff0ffULL,
0x0000000436467824ULL, 0x000fe200078e00ffULL, 0x0000002f402f7210ULL, 0x000fe20007f7e0ffULL,
0x0000000438487824ULL, 0x000fe200078e00ffULL, 0x0000003940417210ULL, 0x000fe20007fbe0ffULL,
0x000000013c367824ULL, 0x000fe200078e023bULL, 0xfffffffc46447812ULL, 0x000fe200078ee23dULL,
0x0000000142387824ULL, 0x000fe200078e023bULL, 0xfffffffc3a427812ULL, 0x100fe200078ee23dULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x00000031403a7210ULL, 0x000fe20007f5e0ffULL,
0x000000043e4a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc48467812ULL, 0x000fe200078ee23dULL,
0x000000013e377824ULL, 0x000fe200078e023bULL, 0xfffffffc3c487812ULL, 0x100fe200078ee23dULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0xfffffffc4a4a7812ULL, 0x100fe200078ee23dULL,
0x000000ffff397224ULL, 0x000fe200010e06ffULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee23dULL,
0x0000001048457824ULL, 0x000fe200078e024bULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee23dULL,
0x0000001046437824ULL, 0x100fe200078e024bULL, 0x0ffffffc3d3e7812ULL, 0x000fe200078ef826ULL,
0x0000001044317824ULL, 0x100fe200078e024bULL, 0x00000036403b7210ULL, 0x000fe20007f3e0ffULL,
0x000000104a477824ULL, 0x100fe200078e024bULL, 0x00000038403f7210ULL, 0x000fe20007f9e0ffULL,
0x000000103e4f7824ULL, 0x000fe200078e024bULL, 0x00000037403d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00005e003a387a11ULL, 0x040fe200078440ffULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005e002f367a11ULL, 0x040fe200078c40ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005f003a397a11ULL, 0x000fe200010f4439ULL,
0x000000104c497824ULL, 0x100fe200078e024bULL, 0x00005f002f377a11ULL, 0x000fe200030f443cULL,
0x00000010422f7824ULL, 0x100fe200078e024bULL, 0xfffffffc4d4d7812ULL, 0x000fe200078ee226ULL,
0x000000ffff427224ULL, 0x000fe200028e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078240ffULL,
0x000000104e4b7824ULL, 0x000fe200078e024bULL, 0x00005e003d3c7a11ULL, 0x000fe200078440ffULL,
0x000000104d327825ULL, 0x000fe200078e0032ULL, 0x00005e003f3e7a11ULL, 0x000fc400078640ffULL,
0x00005e0041407a11ULL, 0x000fe200078840ffULL, 0x000000104d347825ULL, 0x000fe200078e0034ULL,
0x00005f003b3b7a11ULL, 0x000fe200008f4448ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000324f7faeULL, 0x0003e2000b901c46ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4446ULL,
0x000000104d367825ULL, 0x000fe200078e0036ULL, 0x00005f003f3f7a11ULL, 0x000fe200018f4444ULL,
0x00000000342f7faeULL, 0x0003e2000b901c46ULL, 0x00005f0041417a11ULL, 0x000fe200020f4442ULL,
0x000000104d387825ULL, 0x040fe400078e0038ULL, 0x0000000036317faeULL, 0x0003e4000b901c46ULL,
0x000000104d3a7825ULL, 0x000fc400078e003aULL, 0x0000000038437faeULL, 0x0003e4000b901c46ULL,
0x000000104d3c7825ULL, 0x040fe400078e003cULL, 0x000000003a457faeULL, 0x0003e4000b901c46ULL,
0x000000104d3e7825ULL, 0x040fe400078e003eULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x000000104d407825ULL, 0x000fc400078e0040ULL, 0x000000003e497faeULL, 0x0003e8000b901c46ULL,
0x00000000404b7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000035100780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff037624ULL, 0x000fc800078e00ffULL,
0x0000000203027824ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x000000630200720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000229327824ULL, 0x002fe400078e0202ULL, 0x00000004ff337424ULL, 0x000fc800078e00ffULL,
0x0000600032327625ULL, 0x000fca00078e0033ULL, 0x0000000632037981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020263f7810ULL, 0x042fe20007ffe0ffULL, 0x00000002673e7824ULL, 0x000fe200078e0230ULL,
0xfffffff8262f7812ULL, 0x040fe200078ec0ffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000000072f2f7812ULL, 0x100fe400078ef826ULL, 0x000000073f3f7812ULL, 0x000fe400078ef826ULL,
0x00000007263d7812ULL, 0x000fc400078ec0ffULL, 0x00000001ff417819ULL, 0x000fe4000001162fULL,
0x00000001ff437819ULL, 0x000fe4000001163fULL, 0x000020003e3e7811ULL, 0x000fe400078e60ffULL,
0x000000083d3d7812ULL, 0x000fe400078ef826ULL, 0x0000000341417812ULL, 0x000fe400078ec0ffULL,
0x0000000343437812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003c41307212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003c43347212ULL, 0x000fc400078e3cffULL, 0x000000013c487810ULL, 0x040fe20007ffe0ffULL,
0x000000042f317824ULL, 0x000fe200078e0230ULL, 0x000000023c3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000043f357824ULL, 0x000fe400078e0234ULL, 0x0000001031317824ULL, 0x100fe200078e023eULL,
0x000000043c00780cULL, 0x000fe20003f25270ULL, 0x0000001035357824ULL, 0x000fc800078e023eULL,
0x000000003130783bULL, 0x000e680000000200ULL, 0x000000003534783bULL, 0x000ea20000000200ULL,
0x00000018ff3a7819ULL, 0x002fe20000011432ULL, 0x00010000313b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011431ULL, 0x0000003a00567306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fc40000011430ULL, 0x00000018ff467819ULL, 0x000fe40000011433ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff457819ULL, 0x004fe20000011434ULL,
0x0000003900527306ULL, 0x0005e20000200c00ULL, 0x00008880313a7816ULL, 0x042fe200000000ffULL,
0x0000010031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011435ULL,
0x00000018ff427819ULL, 0x000fc40000011436ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000038004e7306ULL, 0x0003e20000200c00ULL, 0x0001000030397824ULL, 0x004fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc80000011437ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003100537306ULL, 0x0005e20000200c00ULL, 0x0000888030387816ULL, 0x042fe200000000ffULL,
0x0000010030307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x00000039004d7306ULL, 0x0003e20000200c00ULL, 0x0001000033317824ULL, 0x004fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000038004c7306ULL, 0x0004e20000200c00ULL,
0x0000888033397816ULL, 0x042fe200000000ffULL, 0x0000010033337824ULL, 0x000fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x00000030004f7306ULL, 0x0003220000200c00ULL,
0x0000888032387816ULL, 0x004fce00000000ffULL, 0x0000003800547306ULL, 0x0005e20000200c00ULL,
0x0001000032307824ULL, 0x002fe200078e00ffULL, 0x000054104c4c7816ULL, 0x008fe2000000004dULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000033005b7306ULL, 0x0003e20000200c00ULL, 0x0000004841387212ULL, 0x084fe400078e3cffULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x0000004843487212ULL, 0x000fe400078e3cffULL,
0x000054104f4d7816ULL, 0x010fe2000000004eULL, 0x0000003a00507306ULL, 0x000fe20000200c00ULL,
0x000000042f337824ULL, 0x002fc400078e0238ULL, 0x000000043f477824ULL, 0x000fe400078e0248ULL,
0x0000001033337824ULL, 0x000fe400078e023eULL, 0x0001000037487824ULL, 0x000fe200078e00ffULL,
0x0000003b00517306ULL, 0x000e680000200c00ULL, 0x00000018ff487819ULL, 0x000fc80000011448ULL,
0x0000003900587306ULL, 0x0005f00000200c00ULL, 0x0000003000557306ULL, 0x0007220000200c00ULL,
0x000000003338783bULL, 0x004ea20000000200ULL, 0x0000541050507816ULL, 0x002fc40000000051ULL,
0x0000541053517816ULL, 0x000fc80000000052ULL, 0x0000003200577306ULL, 0x0003220000200c00ULL,
0x0000888034307816ULL, 0x008fce00000000ffULL, 0x0000003100597306ULL, 0x0006a20000200c00ULL,
0x0001000034327824ULL, 0x002fe200078e00ffULL, 0x0000541054547816ULL, 0x010fe20000000055ULL,
0x0000010034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000030005a7306ULL, 0x0003e20000200c00ULL, 0x0000888035317816ULL, 0x008fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541057557816ULL, 0x000fc60000000056ULL,
0x00000032005d7306ULL, 0x0007220000200c00ULL, 0x0001000035307824ULL, 0x042fe200078e00ffULL,
0x0000541058587816ULL, 0x004fe20000000059ULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031005e7306ULL, 0x0003e20000200c00ULL,
0x0000001047327824ULL, 0x008fe200078e023eULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000100003a767824ULL, 0x000fe200078e00ffULL, 0x0000888039707816ULL, 0x000fe400000000ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001143bULL, 0x00000030005f7306ULL, 0x0004e20000200c00ULL,
0x0001000036317824ULL, 0x002fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc40000011476ULL,
0x000054105a5a7816ULL, 0x010fe4000000005dULL, 0x00000018ff477819ULL, 0x000fe40000011431ULL,
0x00000034005c7306ULL, 0x0003e20000200c00ULL, 0x000000003230783bULL, 0x004eae0000000200ULL,
0x0000003500617306ULL, 0x0009e20000200c00ULL, 0x0000888036347816ULL, 0x042fe200000000ffULL,
0x0000010036367824ULL, 0x000fe200078e00ffULL, 0x000054105e5e7816ULL, 0x008fc8000000005fULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x0000003400607306ULL, 0x0003e20000200c00ULL,
0x0000888037357816ULL, 0x050fe200000000ffULL, 0x0000010037377824ULL, 0x000fca00078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000003500667306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011438ULL, 0x00000034006e7306ULL, 0x0003e20000200c00ULL,
0x0000888038357816ULL, 0x008fce00000000ffULL, 0x00000036006b7306ULL, 0x0007e20000200c00ULL,
0x0001000038347824ULL, 0x042fe200078e00ffULL, 0x00008880314e7816ULL, 0x004fe200000000ffULL,
0x0000010038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011430ULL,
0x00000018ff497819ULL, 0x000fe40000011431ULL, 0x00000018ff6c7819ULL, 0x000fe20000011438ULL,
0x0000004700697306ULL, 0x0002a20000200c00ULL, 0x00000018ff367819ULL, 0x008fc40000011439ULL,
0x0000002d26387211ULL, 0x000fe400078fe0ffULL, 0x000000042d2d7810ULL, 0x000fc60007ffe0ffULL,
0x0000003600747306ULL, 0x0007e20000200c00ULL, 0x00000018ff477819ULL, 0x002fce000001143aULL,
0x00000037006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x008fe40000011434ULL,
0x0000000738347812ULL, 0x040fe400078e783dULL, 0x0000000238387810ULL, 0x000fe40007ffe0ffULL,
0x0000541060607816ULL, 0x004fe20000000069ULL, 0x000000203d347824ULL, 0x000fe200078e0234ULL,
0x00000035006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff377819ULL, 0x002fc40000011433ULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0x0000000738387812ULL, 0x000fc800078e783dULL,
0x0000004700787306ULL, 0x000fe20000200c00ULL, 0x0001000039357824ULL, 0x044fe400078e00ffULL,
0x0000010039397824ULL, 0x000fe400078e00ffULL, 0x000000203d387824ULL, 0x000fe200078e0238ULL,
0x00000018ff727819ULL, 0x000fe40000011435ULL, 0x0000003700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000001038387824ULL, 0x000fcc00078e00ffULL,
0x0000003600717306ULL, 0x0002b00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x000000003434783bULL, 0x002e6e0000000200ULL, 0x0000006c00737306ULL, 0x0009e20000200c00ULL,
0x000054106a6a7816ULL, 0x004fce0000000071ULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x000088803a6c7816ULL, 0x050fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x000054105b597816ULL, 0x008fe20000000046ULL, 0x000000ffff467224ULL, 0x000fe400078e004eULL,
0x00010000314e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x0000010031317824ULL, 0x000fe400078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000004200427306ULL, 0x000f220000200c00ULL, 0x00005410615f7816ULL, 0x004fce0000000044ULL,
0x0000003a007b7306ULL, 0x0005e20000200c00ULL, 0x0000004c3404723cULL, 0x002fe20000001804ULL,
0x000054105c5b7816ULL, 0x008fcc0000000045ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x00008880303a7816ULL, 0x044fe200000000ffULL, 0x00010000304c7824ULL, 0x040fe200078e00ffULL,
0x000054106b617816ULL, 0x010fe20000000042ULL, 0x0000010030307824ULL, 0x000fe200078e00ffULL,
0x000000503408723cULL, 0x000fe20000001808ULL, 0x0001000032427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x00000048006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000054340c723cULL, 0x000fe2000000180cULL, 0x00005410736b7816ULL, 0x000fe4000000006eULL,
0x0000007200757306ULL, 0x0005e20000200c00ULL, 0x00000018ff487819ULL, 0x002fc80000011432ULL,
0x000000583410723cULL, 0x000fe60000001810ULL, 0x0000003900777306ULL, 0x0002e20000200c00ULL,
0x000088803b727816ULL, 0x004fc800000000ffULL, 0x0000005a3414723cULL, 0x040fe60000001814ULL,
0x00000030004f7306ULL, 0x0005e20000200c00ULL, 0x000100003b397824ULL, 0x042fe400078e00ffULL,
0x000001003b3b7824ULL, 0x000fe400078e00ffULL, 0x0000005e3418723cULL, 0x040fe20000001818ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000004e00457306ULL, 0x000fe20000200c00ULL, 0x0000888032307816ULL, 0x044fe200000000ffULL,
0x0000010032327824ULL, 0x000fe200078e00ffULL, 0x0000541077717816ULL, 0x008fe20000000074ULL,
0x00000060341c723cULL, 0x000fe6000000181cULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000003100447306ULL, 0x0003f00000200c00ULL, 0x00000030004e7306ULL, 0x0005e20000200c00ULL,
0x000054106f317816ULL, 0x002fce0000000040ULL, 0x0000007600797306ULL, 0x000fe20000200c00ULL,
0x0000541066307816ULL, 0x004fe4000000006dULL, 0x000054107b6d7816ULL, 0x000fca0000000078ULL,
0x00000039007d7306ULL, 0x000fe20000200c00ULL, 0x000000303420723cULL, 0x000fee0000001820ULL,
0x0000003b00767306ULL, 0x000fe20000200c00ULL, 0x0001000033317824ULL, 0x040fe200078e00ffULL,
0x0000888033307816ULL, 0x000fc800000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003a004d7306ULL, 0x0003f00000200c00ULL, 0x0000003200377306ULL, 0x0005e20000200c00ULL,
0x000000003838783bULL, 0x002e6e0000000200ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x0000010033327824ULL, 0x004fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000004a004a7306ULL, 0x000eb00000200c00ULL, 0x0000004200357306ULL, 0x000f220000200c00ULL,
0x000054104d4c7816ULL, 0x008fce000000004cULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x000054104f4d7816ULL, 0x004fce000000004aULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054104e4e7816ULL, 0x010fe20000000035ULL, 0x0000006a3804723cULL, 0x042fec0000001804ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000541076737816ULL, 0x008fe2000000004bULL,
0x0000004c3814723cULL, 0x000fec0000001814ULL, 0x0000007000707306ULL, 0x000eb00000200c00ULL,
0x0000006c006c7306ULL, 0x000ee20000200c00ULL, 0x00005410374f7816ULL, 0x002fce0000000048ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541070707816ULL, 0x004fe20000000075ULL,
0x0000004e381c723cULL, 0x040fec000000181cULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x000054106c6c7816ULL, 0x008fe20000000079ULL, 0x000000703808723cULL, 0x040fec0000001808ULL,
0x0000003000347306ULL, 0x0005e20000200c00ULL, 0x0000541072727816ULL, 0x002fe2000000007dULL,
0x0000006c380c723cULL, 0x040fec000000180cULL, 0x0000003100337306ULL, 0x0002e20000200c00ULL,
0x0000541046307816ULL, 0x004fe20000000045ULL, 0x000000723810723cULL, 0x000fec0000001810ULL,
0x0000003200327306ULL, 0x000ea20000200c00ULL, 0x0000541044317816ULL, 0x002fc40000000049ULL,
0x0000541034347816ULL, 0x008fca0000000033ULL, 0x000000303818723cULL, 0x000fe20000001818ULL,
0x0000541032357816ULL, 0x004fce0000000047ULL, 0x000000343820723cULL, 0x000fe20000001820ULL,
0xfffff0f000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff307224ULL, 0x000fe200078e002cULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe12000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000028307f8cULL, 0x000fe2000c80043fULL,
0x0000001627387220ULL, 0x040fe20000410000ULL, 0x00000006272f7220ULL, 0x040fe20000410000ULL,
0x0000000a27327220ULL, 0x040fe20000410000ULL, 0x00000400282d7984ULL, 0x000e620000000800ULL,
0x0000000b27337220ULL, 0x040fe20000410000ULL, 0x0000000e27347220ULL, 0x040fe20000410000ULL,
0x0000001c27167220ULL, 0x040fe20000410000ULL, 0x0000000427047220ULL, 0x040fe20000410000ULL,
0x0000000527057220ULL, 0x040fe20000410000ULL, 0x0000000727077220ULL, 0x040fe20000410000ULL,
0x0000000827087220ULL, 0x040fe20000410000ULL, 0x0000000927097220ULL, 0x040fe20000410000ULL,
0x0000000c27007220ULL, 0x040fe20000410000ULL, 0x0000000d27067220ULL, 0x040fe20000410000ULL,
0x0000000f27357220ULL, 0x040fe20000410000ULL, 0x0000001227367220ULL, 0x040fe20000410000ULL,
0x0000001327377220ULL, 0x040fe20000410000ULL, 0x0000001727397220ULL, 0x040fe20000410000ULL,
0x0000001a273a7220ULL, 0x040fe20000410000ULL, 0x0000001b273b7220ULL, 0x040fe20000410000ULL,
0x0000001e271c7220ULL, 0x040fe20000410000ULL, 0x0000001f273c7220ULL, 0x040fe20000410000ULL,
0x0000001427127220ULL, 0x040fe20000410000ULL, 0x0000001527137220ULL, 0x040fe20000410000ULL,
0x0000001827147220ULL, 0x040fe20000410000ULL, 0x0000001927157220ULL, 0x040fe20000410000ULL,
0x0000001d27177220ULL, 0x040fe20000410000ULL, 0x0000002027187220ULL, 0x040fe20000410000ULL,
0x0000002127197220ULL, 0x040fe20000410000ULL, 0x00000022273d7220ULL, 0x040fe20000410000ULL,
0x00000023273e7220ULL, 0x040fe20000410000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e002fULL,
0x0000001027107220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0032ULL,
0x0000001127117220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0033ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0004ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0005ULL, 0x800000002dff7812ULL, 0x002fe20007804831ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0007ULL, 0x000000ffff207224ULL, 0x000fe400078e0035ULL,
0x000000ffff217224ULL, 0x000fe400078e0036ULL, 0x000000ffff227224ULL, 0x000fe400078e0037ULL,
0x000000ffff237224ULL, 0x000fc400078e0038ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0039ULL,
0x000000ffff2f7224ULL, 0x000fe400078e003aULL, 0x000000ffff327224ULL, 0x000fe400078e003bULL,
0x000000ffff337224ULL, 0x000fe400078e001cULL, 0x000000ffff347224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fc400078e003dULL, 0x000000ffff367224ULL, 0x000fe200078e003eULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe20003800000ULL, 0x0000040028057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004261c7824ULL, 0x000fe200078e00ffULL, 0x0000002b6400720cULL, 0x000fc80003f05270ULL,
0xfffffff01c007812ULL, 0x000fca00078ec0ffULL, 0x0000008067007824ULL, 0x000fca00078e0200ULL,
0x0104000000047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000226087824ULL, 0x000fe400078e00ffULL, 0x00000001652e7824ULL, 0x000fc600078e0a2eULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109317812ULL, 0x040fe400078efcffULL,
0x0000000809377812ULL, 0x000fe400078efcffULL, 0x0000002e3100720cULL, 0x080fe40003f26070ULL,
0x0000001009317812ULL, 0x000fe400078efcffULL, 0x0000002e3700720cULL, 0x080fe40003f06070ULL,
0x0000002e3100720cULL, 0x000fc40003fc6070ULL, 0x0000001109377812ULL, 0x040fe400078efcffULL,
0x0000001809317812ULL, 0x040fe400078efcffULL, 0x0000002e0900720cULL, 0x080fe40003f46070ULL,
0x0000002e3700720cULL, 0x080fe40003fa6070ULL, 0x0000002e3100720cULL, 0x000fe40003f66070ULL,
0x0000000909397812ULL, 0x000fc400078efcffULL, 0x0000001909377812ULL, 0x040fe400078efcffULL,
0x0000002009317812ULL, 0x000fe400078efcffULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000002e3900720cULL, 0x080fe40003f86070ULL,
0x0000002e3700720cULL, 0x080fe40003f46070ULL, 0x0000002e3100720cULL, 0x000fe40003f26070ULL,
0x0000002109377812ULL, 0x040fe400078efcffULL, 0x0000002809317812ULL, 0x000fe400078efcffULL,
0xff7fffff1d1d7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002e3700720cULL, 0x080fe40003f06070ULL, 0x0000002e3100720cULL, 0x000fe40003f86070ULL,
0x0000002909377812ULL, 0x000fc400078efcffULL, 0x0000003009317812ULL, 0x000fe400078efcffULL,
0xff7fffff1f1f7808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff20207808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002e3700720cULL, 0x000fc40003fc6070ULL, 0x0000002e3100720cULL, 0x000fe40003fa6070ULL,
0x0000003109377812ULL, 0x040fe400078efcffULL, 0x0000003809317812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002e3700720cULL, 0x080fe40003f66070ULL,
0x0000002e3100720cULL, 0x000fc40003f46070ULL, 0x0000002e0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff2d2d7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff32327808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff33337808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff34347808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff35357808ULL, 0x000fc40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40005000000ULL,
0xff7fffff36367808ULL, 0x000fe40004800000ULL, 0xff7fffff19197808ULL, 0x000fe40004800000ULL,
0x0000000b04097209ULL, 0x004fe20007810000ULL, 0x0000001fff397424ULL, 0x000fe200078e00ffULL,
0x0000001a05047209ULL, 0x000fe20007810000ULL, 0xffffffffff3c7424ULL, 0x000fe200078e00ffULL,
0x0000000a09097209ULL, 0x000fe40007810000ULL, 0x0000001b04047209ULL, 0x000fc40007810000ULL,
0x0000000c09087209ULL, 0x000fe40007810000ULL, 0x0000001d04057209ULL, 0x000fe40007810000ULL,
0x0000000d08097209ULL, 0x000fe40007810000ULL, 0x0000001e05047209ULL, 0x000fe40007810000ULL,
0x0000000e09087209ULL, 0x000fe40007810000ULL, 0x0000001f04057209ULL, 0x000fc40007810000ULL,
0x0000000f08097209ULL, 0x000fe40007810000ULL, 0x0000002005047209ULL, 0x000fe40007810000ULL,
0x0000001009087209ULL, 0x000fe40007810000ULL, 0x0000002104057209ULL, 0x000fe40007810000ULL,
0x0000001108097209ULL, 0x000fe40007810000ULL, 0x0000002205047209ULL, 0x000fc40007810000ULL,
0x0000001209087209ULL, 0x000fe40007810000ULL, 0x0000002304047209ULL, 0x000fe40007810000ULL,
0x0000001308057209ULL, 0x000fe40007810000ULL, 0x0000002d04047209ULL, 0x000fe40007810000ULL,
0x0000001405087209ULL, 0x000fe40007810000ULL, 0x0000002f04057209ULL, 0x000fc40007810000ULL,
0x0000001508097209ULL, 0x000fe40007810000ULL, 0x0000003205047209ULL, 0x000fe40007810000ULL,
0x0000001609087209ULL, 0x000fe40007810000ULL, 0x0000003304057209ULL, 0x000fe40007810000ULL,
0x0000001708097209ULL, 0x000fe40007810000ULL, 0x0000003405047209ULL, 0x000fc40007810000ULL,
0x0000001809087209ULL, 0x000fe40007810000ULL, 0x0000003504057209ULL, 0x000fe40007810000ULL,
0x0000001908307209ULL, 0x000fe40007810000ULL, 0x0000003605377209ULL, 0x000fe20007810000ULL,
0x00001a727f007947ULL, 0x000fea000b800000ULL, 0x0c401f0030047f89ULL, 0x0004e400000e0000ULL,
0x0000000430387209ULL, 0x008fe20007810000ULL, 0x00001a927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072e7f89ULL, 0x000e6200000e0000ULL, 0x0000000437087209ULL, 0x008fc60007810000ULL,
0x0c201f0038047f89ULL, 0x000ee200000e0000ULL, 0x0000000506097209ULL, 0x010fc60007810000ULL,
0x0c201f0008057f89ULL, 0x000f2200000e0000ULL, 0x0000002e072e7209ULL, 0x002fc60007810000ULL,
0x0c201f0009307f89ULL, 0x004e6800000e0000ULL, 0x0c201f002e317f89ULL, 0x0004a200000e0000ULL,
0x0000000438047209ULL, 0x008fe40007810000ULL, 0x0000000508057209ULL, 0x010fe40007810000ULL,
0x0000003009067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b05307820ULL, 0x002fe20000410000ULL, 0x3c003c00ff3c7424ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3c003c00ff3d7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010830ULL, 0x0000000a00097308ULL, 0x000e620000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010830ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010830ULL, 0x0000000d000d7308ULL, 0x000ee20000000800ULL,
0x000000080908723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b19077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b36307823ULL, 0x000fe20000010830ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000001b001b7308ULL, 0x000e620000000800ULL,
0x0000000c0d0a723eULL, 0x008fce00000000ffULL, 0x0000001d000b7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ee20000000800ULL, 0x0000001a1b09723eULL, 0x002fce00000000ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x0000000b1e0b723eULL, 0x008fce00000000ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000003c0838723cULL, 0x000fee00000018ffULL,
0x0000001000107308ULL, 0x000ff00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x0000000e0f0c723eULL, 0x002fce00000000ffULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x00000010110e723eULL, 0x008fce00000000ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002200227308ULL, 0x000ee20000000800ULL,
0x0000001f200d723eULL, 0x002fce00000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000021220f723eULL, 0x008fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000003c0c38723cULL, 0x000fee0000001838ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ee20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000ff00000000800ULL, 0x0000002d001a7308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x008fe200000000ffULL, 0x0000000fff157424ULL, 0x000fe200078e00ffULL,
0xfffffffc26147812ULL, 0x000fc800078ec0ffULL, 0x00000014153e7219ULL, 0x000fe200000006ffULL,
0x0000002f002f7308ULL, 0x000fe60000000800ULL, 0x000000003e1973a1ULL, 0x000ee200000e8000ULL,
0x000000003e0473c4ULL, 0x000f280000004000ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x000000231a11723eULL, 0x002fce00000000ffULL, 0x0000001600167308ULL, 0x000fe20000000800ULL,
0x0000002f3213723eULL, 0x004fce00000000ffULL, 0x0000001700177308ULL, 0x000e620000000800ULL,
0x000000053eff7c12ULL, 0x008fe2000f804019ULL, 0x0000003c1038723cULL, 0x000fec0000001838ULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x002fce00000000ffULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x000000180716723eULL, 0x004fe400000000ffULL,
0x0000002e31077209ULL, 0x000fca0007810000ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x000000333415723eULL, 0x002fe400000000ffULL,
0x000000353017723eULL, 0x004fce00000000ffULL, 0x0000003c1438723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x000015c204008947ULL, 0x010fde000b800000ULL,
0x001c1fff38187589ULL, 0x0002a400000e0000ULL, 0x000000003e1973a1ULL, 0x000ee200000e8000ULL,
0x000000003e0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000053eff7c12ULL, 0x008fda000f804019ULL, 0x000015d204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a197589ULL, 0x00072800000e0000ULL, 0x001c1fff011a7589ULL, 0x00066800000e0000ULL,
0x001c1fff1b1b7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1d7819ULL, 0x000fe40000011626ULL,
0x0000000c1c3b7812ULL, 0x000fc400078ec0ffULL, 0x000000071d1e7812ULL, 0x040fe200078ec0ffULL,
0x000000081d237824ULL, 0x040fe200078e00ffULL, 0x0000001dff217212ULL, 0x000fe200078e33ffULL,
0x000000081d1f7824ULL, 0x040fe200078e00ffULL, 0x0000000326ff7812ULL, 0x000fe2000780c0ffULL,
0x000000081d387824ULL, 0x042fe200078e00ffULL, 0x000000081d1d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff823207812ULL, 0x100fe400078ee21eULL, 0x000000011f227812ULL, 0x100fe200078ef61eULL,
0x000000081d487824ULL, 0x000fe200078e00ffULL, 0x000000021f2e7812ULL, 0x100fe200078ef61eULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0x000000031f307812ULL, 0x000fc400078ef61eULL,
0x000000041f327812ULL, 0x140fe400078ef61eULL, 0x000000051f347812ULL, 0x140fe400078ef61eULL,
0x000000061f367812ULL, 0x000fe200078ef61eULL, 0x000000081d1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe400078ee221ULL, 0x0000001dff217212ULL, 0x000fe400078e33ffULL,
0x000000071d1e7812ULL, 0x000fc400078ec0ffULL, 0x0000a000671d7811ULL, 0x000fe400078e58ffULL,
0xfffffff8233a7812ULL, 0x108fe400078ee21eULL, 0xfffffff848487812ULL, 0x000fe200078ee221ULL,
0x00000010201c7824ULL, 0x100fe200078e021dULL, 0x000000011f3c7812ULL, 0x140fe200078ef61eULL,
0x000000102e207824ULL, 0x100fe200078e021dULL, 0x000000021f3e7812ULL, 0x140fe200078ef61eULL,
0x00000010322d7824ULL, 0x100fe200078e021dULL, 0x000000031f407812ULL, 0x140fe200078ef61eULL,
0x00000010342e7824ULL, 0x100fe200078e021dULL, 0x000000041f427812ULL, 0x140fe200078ef61eULL,
0x0000001038327824ULL, 0x100fe200078e021dULL, 0x000000051f447812ULL, 0x140fe200078ef61eULL,
0x000000103c347824ULL, 0x100fe200078e021dULL, 0x000000061f467812ULL, 0x000fe200078ef61eULL,
0x00000010221e7824ULL, 0x000fc400078e021dULL, 0x0000001030227824ULL, 0x100fe400078e021dULL,
0x000000013b1f7824ULL, 0x000fe400078e021cULL, 0x0000001036307824ULL, 0x100fe400078e021dULL,
0x000000103a1c7824ULL, 0x100fe200078e021dULL, 0x000000081f007388ULL, 0x0003e20000000800ULL,
0x000000103e357824ULL, 0x100fe400078e021dULL, 0x0000001040367824ULL, 0x000fc400078e021dULL,
0x0000001042377824ULL, 0x100fe400078e021dULL, 0x0000001044387824ULL, 0x100fe400078e021dULL,
0x0000001046397824ULL, 0x100fe400078e021dULL, 0x00000010483a7824ULL, 0x000fe400078e021dULL,
0x000000013b1d7824ULL, 0x040fe400078e021eULL, 0x000000013b217824ULL, 0x000fc400078e0220ULL,
0x000000013b237824ULL, 0x040fe200078e0222ULL, 0x0000000a1d007388ULL, 0x0007e20000000800ULL,
0x000000013b2d7824ULL, 0x040fe400078e022dULL, 0x000000013b2f7824ULL, 0x040fe200078e022eULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000013b317824ULL, 0x040fe400078e0230ULL,
0x000000013b337824ULL, 0x040fe200078e0232ULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x000000013b1c7824ULL, 0x000fc400078e021cULL, 0x000000013b347824ULL, 0x040fe200078e0234ULL,
0x000000102d007388ULL, 0x0007e20000000800ULL, 0x000000013b1e7824ULL, 0x040fe400078e0235ULL,
0x000000013b367824ULL, 0x040fe200078e0236ULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x000000013b087824ULL, 0x042fe400078e0237ULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x0000001431007388ULL, 0x0007e20000000800ULL, 0x000000013b207824ULL, 0x000fc400078e0239ULL,
0x000000013b3a7824ULL, 0x000fe200078e023aULL, 0x0000001633007388ULL, 0x0007e80000000800ULL,
0x000000091c007388ULL, 0x0007e80000000800ULL, 0x0000000b34007388ULL, 0x0007e80000000800ULL,
0x0000000d1e007388ULL, 0x0007e80000000800ULL, 0x0000000f36007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001338007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x000000173a007388ULL, 0x0007e80000000800ULL,
0x0100000400008388ULL, 0x0007e80000000c00ULL, 0x0102001800008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002aff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002aff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000030064647a10ULL, 0x000fe20007ffe0ffULL,
0x000018002aff7f8cULL, 0x0003e6000c80043fULL, 0x000000626400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc5d000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff157807ULL, 0x008fe40004800000ULL,
0x0001630000147802ULL, 0x000fe40000000f00ULL, 0x0000119000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xfffeb43000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x0001635000147802ULL, 0x000fe40000000f00ULL,
0x0000114000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xfffeb46000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x000163b000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000010a000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0030ULL,
0xfffeb4a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0001641000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000104000007944ULL, 0x014fea0003c00000ULL, 0xfffeb48000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x000fe200078e0014ULL, 0x0001647000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000fe000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x004fe200078e0030ULL,
0xfffeb7f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff707224ULL, 0x002fe200078e0050ULL,
0x000164e000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000f7000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff407224ULL, 0x004fe200078e0030ULL, 0xfffeb7b000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x0001654000327802ULL, 0x000fe20000000f00ULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000f1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6b7224ULL, 0x004fe200078e0030ULL, 0xfffecee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x000165b000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000ea000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6a7224ULL, 0x004fe200078e0030ULL,
0xfffece9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x008fe40004800000ULL,
0x0001660000147802ULL, 0x000fe40000000f00ULL, 0x00000e9000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xfffee61000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x0001665000147802ULL, 0x000fe40000000f00ULL,
0x00000e4000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xfffee64000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x002fe200078e00ffULL,
0x000166b000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000da000007944ULL, 0x034fea0003c00000ULL, 0xfffee6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x0001671000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000d4000007944ULL, 0x030fea0003c00000ULL, 0xfffee76000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x0001676000327802ULL, 0x000fe20000000f00ULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000cf000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0030ULL, 0xfffee9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x000167d000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000c8000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0030ULL,
0xfffee97000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x0001683000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x00000c2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0030ULL,
0xfffefee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff707224ULL, 0x002fe200078e0050ULL,
0x000168a000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000bb000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0030ULL, 0xfffefe9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x008fe40004800000ULL, 0x000168f000147802ULL, 0x000fe40000000f00ULL,
0x00000ba000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xffff14b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x000fe40004800000ULL,
0x0001694000147802ULL, 0x000fe40000000f00ULL, 0x00000b5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xffff14e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x002fe200078e00ffULL, 0x000169a000327802ULL, 0x000fe20000000f00ULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000ab000007944ULL, 0x014fea0003c00000ULL,
0xffff154000007947ULL, 0x000fea000383ffffULL, 0x000000ffff707224ULL, 0x002fe200078e0050ULL,
0x00016a0000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0xffff160000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x00016a5000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x00000a0000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff757224ULL, 0x004fe200078e0030ULL,
0xffff186000007947ULL, 0x000fea000383ffffULL, 0x000000ffff707224ULL, 0x002fe200078e0050ULL,
0x00016ac000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000099000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0030ULL, 0xffff181000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x00016b2000327802ULL, 0x000fe20000000f00ULL,
0xffffffffff3e7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff397224ULL, 0x004fe200078e0030ULL, 0xffff2d5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x00016b9000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000008c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0030ULL,
0xffff2d0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff157807ULL, 0x008fe40004800000ULL,
0x00016be000147802ULL, 0x000fe40000000f00ULL, 0x000008b000007944ULL, 0x034fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0028ULL, 0xffff441000007947ULL, 0x000fea000383ffffULL,
0x00000001ff157807ULL, 0x000fe40004800000ULL, 0x00016c3000147802ULL, 0x000fe40000000f00ULL,
0x0000086000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e0028ULL,
0xffff444000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x002fe200078e00ffULL,
0x00016c9000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000007c000007944ULL, 0x034fea0003c00000ULL, 0xffff44a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x00016cf000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x0000076000007944ULL, 0x030fea0003c00000ULL, 0xffff456000007947ULL, 0x000fea000383ffffULL,
0x0000001fff3f7424ULL, 0x000fe200078e00ffULL, 0x00016d4000327802ULL, 0x000fe20000000f00ULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff397224ULL, 0x004fe200078e0030ULL, 0xffff47c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff707224ULL, 0x002fe200078e0050ULL, 0x00016db000327802ULL, 0x000fe20000000f00ULL,
0x0000001fff3f7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3e7424ULL, 0x000fe400078e00ffULL,
0x000006a000007944ULL, 0x02cfea0003c00000ULL, 0x000000ffff387224ULL, 0x004fe200078e0030ULL,
0xffff477000007947ULL, 0x000fea000383ffffULL, 0x0000001fff3f7424ULL, 0x000fe200078e00ffULL,
0x00016e1000327802ULL, 0x000fe20000000f00ULL, 0xffffffffff3e7424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0030ULL,
0xffff5d0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff707224ULL, 0x002fe200078e0050ULL,
0x00016e8000327802ULL, 0x000fe20000000f00ULL, 0x0000001fff3f7424ULL, 0x000fc400078e00ffULL,
0xffffffffff3e7424ULL, 0x000fe400078e00ffULL, 0x000005d000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff507224ULL, 0x004fe200078e0030ULL, 0xffff5cb000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x00016ed000087802ULL, 0x000fe40000000f00ULL,
0x0000054000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0031ULL,
0xffffe55000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0037ULL,
0x00016f3000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe400078e00ffULL,
0x000004e000007944ULL, 0x020fea0003c00000ULL, 0x00000031373a7209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x00016f8000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e0007ULL,
0x00016fd000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x00000031072e7209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0038ULL, 0x0001702000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x0000003138047209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e003aULL,
0x0001707000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x000000313a057209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x002fe200078e0006ULL, 0x000170c000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fc400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x0000003106067209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x002fe200078e002eULL,
0x0001711000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff317424ULL, 0x000fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0xffffe41000007947ULL, 0x000fea000383ffffULL,
0x000000ffff3d7224ULL, 0x000fe200078e0038ULL, 0x0001717000327802ULL, 0x000fe20000000f00ULL,
0x000000ffff707224ULL, 0x000fc400078e00ffULL, 0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL,
0x000002e000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e0030ULL,
0xffffe9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff3d7224ULL, 0x002fe200078e003aULL,
0x000171e000327802ULL, 0x000fe20000000f00ULL, 0x000000ffff707224ULL, 0x000fe400078e00ffULL,
0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL, 0x0000027000007944ULL, 0x024fea0003c00000ULL,
0x000000ffff707224ULL, 0x002fe200078e00ffULL, 0x0001723000327802ULL, 0x000fe20000000f00ULL,
0x00001c1fff3f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff197224ULL, 0x004fe400078e0030ULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff707224ULL, 0x002fe200078e00ffULL,
0x0001728000327802ULL, 0x000fe20000000f00ULL, 0x00001c1fff3f7424ULL, 0x000fc400078e00ffULL,
0x000000ffff1a7224ULL, 0x004fe400078e0030ULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1b7224ULL, 0x004fe200078e0030ULL, 0xffffe95000007947ULL, 0x000fea000383ffffULL,
0x018000005d007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000005d00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff5dff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x800000005d057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000005d00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe8bf004007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003c00007348ULL, 0x000fe80003800000ULL, 0x0c00003130317389ULL, 0x0002a200000e0039ULL,
0xfffe8bb008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff337424ULL, 0x000fe200078e00ffULL,
0x0000003e00007348ULL, 0x000fe80003800000ULL, 0x000000703d307389ULL, 0x0002a200000e003fULL,
0xfffe8b7032007950ULL, 0x000fea0003c3ffffULL, 0x000000011500780cULL, 0x000fe20003f25070ULL,
0x0000005200007348ULL, 0x000fd80003800000ULL, 0x0000000000157806ULL, 0x000fc800048e0100ULL,
0x0000005215287212ULL, 0x000fe200078ec0ffULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffe8b1014007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000005f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000bd8ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c68ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017f8ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001818ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001828ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001848ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018d8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000018e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000018f0ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001b00ULL, 0x0000000000017580ULL, 0x9c00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000019090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000018d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000177a8ULL, 0x00000000000177a8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 103920;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
