/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000019a10ULL, 0x0000000000019590ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000177e0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000017950ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x00000000000179a0ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x00000000000179f0ULL,
0x0000000000000110ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000017b00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000177e000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x005c900400288080ULL, 0x0000000000000000ULL, 0x000000f4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9408288080920828ULL, 0x2880809508288080ULL, 0x8098082880809608ULL, 0x082880809c082880ULL,
0x8080a508288080a4ULL, 0xa708288080a60828ULL, 0x288080a808288080ULL, 0x80aa08288080a908ULL,
0x08288080ab082880ULL, 0x8080ad08288080acULL, 0xaf08288080ae0828ULL, 0x288080b008288080ULL,
0x80b208288080b108ULL, 0x08288080b3082880ULL, 0x8080b508288080b4ULL, 0xb708288080b60828ULL,
0x288080b808288080ULL, 0x80ba08288080b908ULL, 0x08288080bb082880ULL, 0x8080bd08288080bcULL,
0xed08288080d10828ULL, 0x288080ee08288080ULL, 0x8280162880808408ULL, 0x0000000003102880ULL,
0x8080849200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000177e000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000114ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8a08288080880828ULL, 0x2880808c08288080ULL, 0x8090082880808e08ULL,
0x0828808094082880ULL, 0x8080960828808095ULL, 0x9d082880809c0828ULL, 0x2880809e08288080ULL,
0x80a0082880809f08ULL, 0x08288080a1082880ULL, 0x8080a308288080a2ULL, 0xa508288080a40828ULL,
0x288080a608288080ULL, 0x80a808288080a708ULL, 0x08288080a9082880ULL, 0x8080ad08288080aaULL,
0xaf08288080ae0828ULL, 0x288080b008288080ULL, 0x80b308288080b208ULL, 0x08288080b4082880ULL,
0x8080b608288080b5ULL, 0xb808288080b70828ULL, 0x288080b908288080ULL, 0x80bb08288080ba08ULL,
0x08288080bc082880ULL, 0x8080d108288080bdULL, 0xee08288080ed0828ULL, 0x2880808908288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808089ULL, 0x0000002cffffffffULL,
0x0000019800000000ULL, 0x0001795000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8088288080890900ULL, 0x0000000000002880ULL, 0x0000011cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8908288080880828ULL, 0x2880808a08288080ULL, 0x808e082880808c08ULL, 0x0828808090082880ULL,
0x8080950828808094ULL, 0x9c08288080960828ULL, 0x2880809d08288080ULL, 0x809f082880809e08ULL,
0x08288080a0082880ULL, 0x8080a208288080a1ULL, 0xa408288080a30828ULL, 0x288080a508288080ULL,
0x80a708288080a608ULL, 0x08288080a8082880ULL, 0x8080aa08288080a9ULL, 0xad08288080ac0828ULL,
0x288080ae08288080ULL, 0x80b008288080af08ULL, 0x08288080b1082880ULL, 0x8080b308288080b2ULL,
0xb508288080b40828ULL, 0x288080b608288080ULL, 0x80b908288080b708ULL, 0x08288080ba082880ULL,
0x8080bc08288080bbULL, 0xd108288080bd0828ULL, 0x288080ed08288080ULL, 0x80b808288080ee08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b89200ULL, 0x0000002cffffffffULL,
0x000002f000000000ULL, 0x000179a000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80b2288080b80900ULL, 0x0000000000002880ULL, 0x0000011cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8908288080880828ULL, 0x2880808a08288080ULL, 0x808e082880808c08ULL, 0x0828808090082880ULL,
0x8080960828808094ULL, 0x9d082880809c0828ULL, 0x2880809e08288080ULL, 0x80a0082880809f08ULL,
0x08288080a1082880ULL, 0x8080a308288080a2ULL, 0xa508288080a40828ULL, 0x288080a608288080ULL,
0x80a808288080a708ULL, 0x08288080a9082880ULL, 0x8080ac08288080aaULL, 0xae08288080ad0828ULL,
0x288080af08288080ULL, 0x80b108288080b008ULL, 0x08288080b2082880ULL, 0x8080b408288080b3ULL,
0xb608288080b50828ULL, 0x288080b708288080ULL, 0x80b908288080b808ULL, 0x08288080ba082880ULL,
0x8080bc08288080bbULL, 0xd108288080bd0828ULL, 0x288080ed08288080ULL, 0x809508288080ee08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080959200ULL, 0x0000002cffffffffULL,
0x0000045000000000ULL, 0x000179f000000000ULL, 0x0000011000000000ULL, 0x0000140400000000ULL,
0x8094288080950900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL, 0x0008120400000098ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x00015ba0000156f0ULL, 0x00015d0000015bb0ULL, 0x00015d2000015d10ULL,
0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000020ffffffffULL, 0x0500002005000020ULL, 0xffffffff05000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x000000f0000000e0ULL, 0x000017b000001730ULL,
0x0000188000001850ULL, 0x00001c9000001c60ULL, 0x00001d9000001d10ULL, 0x0000348000003460ULL,
0x00003560000034f0ULL, 0x00004d1000004c90ULL, 0x00004ee000004dc0ULL, 0x000051c0000051a0ULL,
0x000052a000005230ULL, 0x000067e0000067c0ULL, 0x000068c000006850ULL, 0x00007f0000007e80ULL,
0x000080d000007fb0ULL, 0x000083b000008390ULL, 0x0000849000008420ULL, 0x000099b000009990ULL,
0x00009a9000009a20ULL, 0x0000b1c00000b140ULL, 0x0000b3900000b270ULL, 0x0000b6700000b650ULL,
0x0000b7500000b6e0ULL, 0x0000ccc00000cca0ULL, 0x0000cda00000cd30ULL, 0x0000e0a00000e090ULL,
0x000103c00000e820ULL, 0x00010b1000010660ULL, 0x0001137000010b50ULL, 0x000155f0000155c0ULL,
0x0001561000015600ULL, 0x0001565000015630ULL, 0x0001568000015670ULL, 0x00015d5000015cf0ULL,
0x00015d7000015d60ULL, 0x000164f000016490ULL, 0x000165f000016570ULL, 0x000166f000016670ULL,
0x000167e000016760ULL, 0x000168a000016840ULL, 0x0001699000016920ULL, 0x00016a70000169f0ULL,
0x00016b6000016ae0ULL, 0x00016c2000016bc0ULL, 0x00016d1000016ca0ULL, 0x00016df000016d70ULL,
0x00016ee000016e60ULL, 0x00016fa000016f40ULL, 0x0001709000017020ULL, 0x00017170000170f0ULL,
0x00017260000171e0ULL, 0x00017360000172e0ULL, 0x00017440000173d0ULL, 0x00017520000174b0ULL,
0x0001760000017590ULL, 0x000176f000017670ULL, 0x000177b000017750ULL, 0x0000021007003904ULL,
0x00010600000000ffULL, 0x00000250003f0100ULL, 0x0001060800000000ULL, 0x000002c0003f0120ULL,
0x0001068800000000ULL, 0x00000390003f0120ULL, 0x000106a800000000ULL, 0x000003c0003f0120ULL,
0x000106b8000000ffULL, 0x000004e0003f0100ULL, 0x00010600000000ffULL, 0x00000690003f0107ULL,
0x0001068c0000005fULL, 0x00000740003f0102ULL, 0x000106880000005fULL, 0x00000c70003f0101ULL,
0x000106a8000000ffULL, 0x00000cf0003f0107ULL, 0x000106a8000000ffULL, 0x00000d50003f0101ULL,
0x000106b8000000ffULL, 0x00000ec0003f0101ULL, 0x000106bc000000ffULL, 0x00000f20003f0105ULL,
0x000106bc000000ffULL, 0x00000fa0003f0105ULL, 0x000106bc000000ffULL, 0x000014b0003f0105ULL,
0x000106b0000000ffULL, 0x00001530003f0107ULL, 0x000106b0000000ffULL, 0x00001540003f0101ULL,
0x000106ac000000ffULL, 0x000015b0003f0105ULL, 0x000106080000005fULL, 0x000015d0003f0101ULL,
0x0001060c0000005fULL, 0x00001660003f0105ULL, 0x0001060c0000005fULL, 0x00001b40003f0105ULL,
0x000106ac000000ffULL, 0x00001bc0003f0105ULL, 0x000106ac000000ffULL, 0x00002db0003f0105ULL,
0x000106b8000000ffULL, 0x00002dc0003f0101ULL, 0x000106bc000000ffULL, 0x00002e10003f0105ULL,
0x000106bc000000ffULL, 0x00002e90003f0105ULL, 0x000106bc000000ffULL, 0x00003250003f0105ULL,
0x000106a8000000ffULL, 0x000032d0003f0107ULL, 0x000106a8000000ffULL, 0x000032e0003f0101ULL,
0x000106b4000000ffULL, 0x00003340003f0105ULL, 0x000106b4000000ffULL, 0x000033c0003f0105ULL,
0x000106b4000000ffULL, 0x00004490003f0105ULL, 0x000106b8000000ffULL, 0x00004500003f0101ULL,
0x00010688000000ffULL, 0x00004540003f0101ULL, 0x000106bc000000ffULL, 0x00004590003f0105ULL,
0x000106bc000000ffULL, 0x00004610003f0105ULL, 0x000106bc000000ffULL, 0x00004a50003f0105ULL,
0x000106b0000000ffULL, 0x00004ad0003f0107ULL, 0x000106b0000000ffULL, 0x00004ae0003f0101ULL,
0x000106ac000000ffULL, 0x00004b50003f0105ULL, 0x000106280000005fULL, 0x00004b70003f0101ULL,
0x0001062c0000005fULL, 0x00004c00003f0105ULL, 0x0001062c0000005fULL, 0x00005090003f0105ULL,
0x000106ac000000ffULL, 0x00005110003f0105ULL, 0x000106ac000000ffULL, 0x00006140003f0105ULL,
0x000106b8000000ffULL, 0x00006150003f0101ULL, 0x000106bc000000ffULL, 0x000061a0003f0105ULL,
0x000106bc000000ffULL, 0x00006220003f0105ULL, 0x000106bc000000ffULL, 0x000065b0003f0105ULL,
0x000106a8000000ffULL, 0x00006630003f0107ULL, 0x000106a8000000ffULL, 0x00006640003f0101ULL,
0x000106b4000000ffULL, 0x000066b0003f0105ULL, 0x000106b4000000ffULL, 0x00006730003f0105ULL,
0x000106b4000000ffULL, 0x00007750003f0105ULL, 0x000106b8000000ffULL, 0x000077c0003f0101ULL,
0x00010690000000ffULL, 0x00007800003f0101ULL, 0x000106bc000000ffULL, 0x00007850003f0105ULL,
0x000106bc000000ffULL, 0x000078d0003f0105ULL, 0x000106bc000000ffULL, 0x00007c40003f0105ULL,
0x000106b0000000ffULL, 0x00007cc0003f0107ULL, 0x000106b0000000ffULL, 0x00007cd0003f0101ULL,
0x000106ac000000ffULL, 0x00007d40003f0105ULL, 0x000106480000005fULL, 0x00007d60003f0101ULL,
0x0001064c0000005fULL, 0x00007df0003f0105ULL, 0x0001064c0000005fULL, 0x00008280003f0105ULL,
0x000106ac000000ffULL, 0x00008300003f0105ULL, 0x000106ac000000ffULL, 0x00009340003f0105ULL,
0x000106b8000000ffULL, 0x00009350003f0101ULL, 0x000106bc000000ffULL, 0x000093a0003f0105ULL,
0x000106bc000000ffULL, 0x00009420003f0105ULL, 0x000106bc000000ffULL, 0x00009790003f0105ULL,
0x000106a8000000ffULL, 0x00009810003f0107ULL, 0x000106a8000000ffULL, 0x00009820003f0101ULL,
0x000106b4000000ffULL, 0x00009880003f0105ULL, 0x000106b4000000ffULL, 0x00009900003f0105ULL,
0x000106b4000000ffULL, 0x0000a930003f0105ULL, 0x000106b8000000ffULL, 0x0000a9a0003f0101ULL,
0x00010698000000ffULL, 0x0000a9e0003f0101ULL, 0x000106bc000000ffULL, 0x0000aa30003f0105ULL,
0x000106bc000000ffULL, 0x0000aab0003f0105ULL, 0x000106bc000000ffULL, 0x0000af00003f0105ULL,
0x000106b0000000ffULL, 0x0000af80003f0107ULL, 0x000106b0000000ffULL, 0x0000af90003f0101ULL,
0x000106ac000000ffULL, 0x0000b000003f0105ULL, 0x000106680000005fULL, 0x0000b020003f0101ULL,
0x0001066c0000005fULL, 0x0000b0b0003f0105ULL, 0x0001066c0000005fULL, 0x0000b540003f0105ULL,
0x000106ac000000ffULL, 0x0000b5c0003f0105ULL, 0x000106ac000000ffULL, 0x0000c610003f0105ULL,
0x000106b8000000ffULL, 0x0000c620003f0101ULL, 0x000106bc000000ffULL, 0x0000c670003f0105ULL,
0x000106bc000000ffULL, 0x0000c6f0003f0105ULL, 0x000106bc000000ffULL, 0x0000caa0003f0105ULL,
0x000106a8000000ffULL, 0x0000cb20003f0107ULL, 0x000106a8000000ffULL, 0x0000cb30003f0101ULL,
0x000106b4000000ffULL, 0x0000cb90003f0105ULL, 0x000106b4000000ffULL, 0x0000cc10003f0105ULL,
0x000106b4000000ffULL, 0x0000dc50003f0105ULL, 0x000106b8000000ffULL, 0x0000dcb0003f0101ULL,
0x000106a0000000ffULL, 0x00011720003f0101ULL, 0x00010600000000ffULL, 0x000124d0003f0101ULL,
0x00010604000000ffULL, 0x00012570003f0105ULL, 0x00010604000000ffULL, 0x00012890003f0105ULL,
0x00010600000000ffULL, 0x000128a0003f0101ULL, 0x00010604000000ffULL, 0x00012930003f0105ULL,
0x00010604000000ffULL, 0x00014ae0003f0105ULL, 0x0000000000000028ULL, 0x00014b10003f0101ULL,
0x0000000400000028ULL, 0x00014ee0003f0105ULL, 0x0000000400000028ULL, 0x000162e0003f0105ULL,
0x000000000000002aULL, 0x00016340003f0101ULL, 0x000000080000002aULL, 0x000163a0003f0101ULL,
0x000000100000002aULL, 0x00016410003f0101ULL, 0x000000180000002aULL, 0x00053803003f0101ULL,
0x000115c000101c04ULL, 0x00012a4000012990ULL, 0x0000040100016450ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000058cULL, 0x0000001200000002ULL, 0x000000000000042cULL, 0x0000001200000002ULL,
0x00000000000002ccULL, 0x0000001200000002ULL, 0x0000000000000184ULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000569ULL, 0x0000001200000002ULL,
0x0000000000000409ULL, 0x0000001200000002ULL, 0x00000000000002a7ULL, 0x0000001200000002ULL,
0x000000000000015cULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x00000000000e7806ULL, 0x000fe200038e0000ULL, 0x00005800ff247624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000007919ULL, 0x000ea20000002300ULL,
0x0000000e00057300ULL, 0x000ee600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000677919ULL, 0x000f620000002600ULL, 0x0000000e00107309ULL, 0x0002a60000000000ULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x0000000000067919ULL, 0x000ee20000000000ULL,
0x00000005ff667819ULL, 0x002fc60000011603ULL, 0x0000000000657919ULL, 0x000e680000000000ULL,
0x00001fff000a7589ULL, 0x0049e800000e0000ULL, 0x00001fff66667589ULL, 0x000ea200000e0000ULL,
0x0000000100007824ULL, 0x010fe400078e0202ULL, 0x0000000867027824ULL, 0x020fc400078e00ffULL,
0x0000008000007824ULL, 0x000fe400078e0203ULL, 0x0000000824037824ULL, 0x000fe200078e00ffULL,
0x000000060500720cULL, 0x008fe40003f02070ULL, 0x000000ff0000720cULL, 0x040fe20003f25270ULL,
0x0000001403087224ULL, 0x000fe200078e0202ULL, 0x0000000f0000780cULL, 0x040fe40003f44070ULL,
0x0000007f0000780cULL, 0x040fe40003f84070ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040a047824ULL, 0x004fcc00078e0266ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x0000000204097824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff039424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff04a424ULL, 0x000fe200078e00ffULL, 0x00000008090b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff05a424ULL, 0x000fe200078e00ffULL, 0x01060002ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0cc424ULL, 0x000fe200078e00ffULL, 0x00000001090d7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL, 0x010608040000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x0104000c0000c388ULL, 0x0009e20000004800ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a09ULL, 0x0000000709027812ULL, 0x004fc400078ec0ffULL,
0x010688060000b388ULL, 0x0005e20000008a00ULL, 0x0000001f0e0e7812ULL, 0x102fe400078e7865ULL,
0x0000001f02037812ULL, 0x000fe200078e7865ULL, 0x0000000108027824ULL, 0x040fe200078e0209ULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x0000000108047824ULL, 0x008fe200078e020dULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x00000020090c7824ULL, 0x010fe400078e0203ULL,
0x3fffff80ff089424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff06a424ULL, 0x004fe400078e00ffULL,
0x7fffff00ff07a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x0106a8060000a388ULL, 0x0003e20000008a00ULL,
0x00000010650b7824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x080fe200078e0005ULL,
0x0106b808ff009388ULL, 0x0005e40000000a00ULL, 0x000001f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x000fe200078e0005ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000000f02027210ULL, 0x080fe20007fbe0ffULL, 0x000000200d0e7824ULL, 0x000fe200078e020eULL,
0x0000000f04047210ULL, 0x000fe20007f5e0ffULL, 0x000000100c0c7824ULL, 0x000fc400078e00ffULL,
0x000000ffff037224ULL, 0x000fe400028e0603ULL, 0x000000ffff057224ULL, 0x000fe400010e0605ULL,
0x000000100e0e7824ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x002fe400078e0a10ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020c7faeULL, 0x0003e8000d901c46ULL, 0x00000000040e7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x01060400ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000620014027625ULL, 0x000fc600078e0006ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000602647981ULL, 0x004ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x00000004ff637e24ULL, 0x002fe2000f8e00ffULL, 0x0000007f64627810ULL, 0x044fe40007ffe0ffULL,
0x000000ff64617810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff627819ULL, 0x000fe40000011662ULL,
0x00000008ff617819ULL, 0x000fca0000011661ULL, 0x00010fd000008947ULL, 0x000fea0003800000ULL,
0x0000000263607824ULL, 0x000fe400078e00ffULL, 0x00000008665f7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x000000626000720cULL, 0x000fe20003f06070ULL,
0xffffffffff6b7424ULL, 0x000fd800078e00ffULL, 0x0000640060028a10ULL, 0x000fe20007ffe0ffULL,
0x0000000214008824ULL, 0x000fc800078e00ffULL, 0x0000640000028a24ULL, 0x000fe200078e0202ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01068c035fff738cULL, 0x0003e40000000000ULL,
0x0000600002028625ULL, 0x002fe400078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006026b8981ULL, 0x0002a2000c1e1900ULL, 0x0000000163007810ULL, 0x000fe20007ffe0ffULL,
0xff317217ff5e7424ULL, 0x000fe200078e00ffULL, 0x000000f00b0f7812ULL, 0x000fe200078ec0ffULL,
0x010688005fff7f8cULL, 0x0007e2000c80043fULL, 0x000000610000720cULL, 0x000fe20003f06070ULL,
0x000000ffff5d7224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000004ff037819ULL, 0x002fe20000011665ULL, 0x0000010063027824ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000203067810ULL, 0x040fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000403087810ULL, 0x000fe20007ffe0ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000264007217ULL, 0x000fe20007800000ULL, 0x000000015f047824ULL, 0x000fe200078e0206ULL,
0x00000006030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000015f097824ULL, 0x000fc400078e0208ULL,
0x0000000100007824ULL, 0x000fe200078e0a02ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000000015f0d7824ULL, 0x000fe200078e020cULL, 0x0000000709027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x100fe400078e7865ULL,
0x0000000f02027812ULL, 0x000fe400078e7865ULL, 0x0000002000007807ULL, 0x000fe20000000000ULL,
0x0000001004077824ULL, 0x000fe200078e0205ULL, 0x000000070d0e7812ULL, 0x000fe200078ec0ffULL,
0x000000015f047824ULL, 0x000fc400078e0203ULL, 0x00000010090a7824ULL, 0x000fe200078e0202ULL,
0x000000005f027217ULL, 0x000fe40007800000ULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x0000000f0e0e7812ULL, 0x000fe200078e7865ULL, 0x0000000102027824ULL, 0x000fe200078e0a5fULL,
0x0000000f05057812ULL, 0x000fe400078e7865ULL, 0x0000c0000a0a7811ULL, 0x000fe200078e20ffULL,
0x000000100d0e7824ULL, 0x000fe200078e020eULL, 0x000000020300720cULL, 0x080fe20003f26070ULL,
0x0000001004057824ULL, 0x000fe200078e0205ULL, 0x000000020600720cULL, 0x080fe20003f46070ULL,
0x0000008067047824ULL, 0x000fe200078e0204ULL, 0x000000020800720cULL, 0x000fc40003f06070ULL,
0x0000c0000e0e7811ULL, 0x000fe400078e20ffULL, 0x0000000204037810ULL, 0x040fe40007ffe0ffULL,
0x0000000404067810ULL, 0x000fe20007ffe0ffULL, 0x000058006b007a24ULL, 0x004fc800078e02ffULL,
0x0000008000007824ULL, 0x000fca00078e00ffULL, 0x0000000400117210ULL, 0x040fe40007f7e0ffULL,
0x00000003000d7210ULL, 0x000fe40007f9e0ffULL, 0x0000000604047810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff037224ULL, 0x000fe200018e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078640ffULL,
0x000000ffff087224ULL, 0x000fe200020e06ffULL, 0x00005e000d097a11ULL, 0x000fe400078840ffULL,
0x00005f0011117a11ULL, 0x000fc400018f4403ULL, 0x0000000600037210ULL, 0x040fe40007f7e0ffULL,
0x0000000400047210ULL, 0x000fe40007fbe0ffULL, 0x00005f000d0d7a11ULL, 0x000fe200020f4408ULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0x00005e0003067a11ULL, 0x000fe200078840ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x00005e0004087a11ULL, 0x000fe400078a40ffULL,
0x000000020c00720cULL, 0x000fc40003f66070ULL, 0x00005f00030c7a11ULL, 0x000fe400020f4400ULL,
0x000000100f027210ULL, 0x000fe40007f9e0ffULL, 0x00005f00040b7a11ULL, 0x000fe400028f440bULL,
0x0000000f09047210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff037224ULL, 0x000fe200020e0611ULL,
0x0000c00005007811ULL, 0x000fe400078e20ffULL, 0x0000000f06067210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200028e060dULL, 0x0000c00007097811ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002007faeULL, 0x0003e2000c901c46ULL,
0x0000000f08087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff077224ULL, 0x000fc400020e060cULL,
0x0000000004097faeULL, 0x0005e8000d101c46ULL, 0x00000000060a7faeULL, 0x0007e2000c101c46ULL,
0x000000616300720cULL, 0x000fe20003f06070ULL, 0x000000ffff097224ULL, 0x004fca00028e060bULL,
0x00000000080e7faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b800ff027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x008fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000cf1000000947ULL, 0x000fea0003800000ULL,
0x00000004665c7824ULL, 0x000fe400078e00ffULL, 0x0000000214007824ULL, 0x000fc400078e00ffULL,
0x00006400ff5b7624ULL, 0x000fe200078e00ffULL, 0x000000025c5a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x002fe400078e0031ULL, 0x000000ffff147224ULL, 0x004fe400078e0003ULL,
0x00006400005b7624ULL, 0x000fe400078e025bULL, 0xff317217ff5e7424ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fc400078e00ffULL, 0x0000010063007824ULL, 0x000fca00078e00ffULL,
0x000000640000720cULL, 0x000fda0003f06070ULL, 0x0000ce1000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804814ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0060ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000020000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804814ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff157819ULL, 0x000fe20000011665ULL,
0x000058006b687a24ULL, 0x000fe200078e02ffULL, 0x0000002067037811ULL, 0x000fe200078e38ffULL,
0x0000001065537824ULL, 0x000fe200078e00ffULL, 0x0000000163007810ULL, 0x000fe20007ffe0ffULL,
0x000000015f487824ULL, 0x000fe200078e0215ULL, 0x0000002063027811ULL, 0x000fe200078e40ffULL,
0x0000008068687824ULL, 0x000fe200078e00ffULL, 0x000000610000720cULL, 0x000fe20003f06070ULL,
0x0000000148147824ULL, 0x040fe200078e0203ULL, 0x0000000748167812ULL, 0x000fc400078ec0ffULL,
0x0000000264007217ULL, 0x000fe40007800000ULL, 0x0000000215347810ULL, 0x000fe40007ffe0ffULL,
0x0000000f16167812ULL, 0x000fe200078e7865ULL, 0x0000000100007824ULL, 0x000fe200078e0a02ULL,
0x0000001468147210ULL, 0x000fe20007f3e0ffULL, 0x000000015f027824ULL, 0x000fe200078e0234ULL,
0x00000004152c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001048487824ULL, 0x000fe200078e0216ULL,
0x00000006152d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e06ffULL,
0x00005e0014167a11ULL, 0x000fe200078240ffULL, 0x000000015f287824ULL, 0x040fe200078e022cULL,
0x0000000702177812ULL, 0x000fe200078ec0ffULL, 0x000000015f457824ULL, 0x000fe200078e022dULL,
0x00005f00142b7a11ULL, 0x000fc400008f442bULL, 0x0000000728147812ULL, 0x000fe400078ec0ffULL,
0x0000000f17177812ULL, 0x100fe400078e7865ULL, 0x0000000f14147812ULL, 0x000fe400078e7865ULL,
0x0000002000007807ULL, 0x000fe20000000000ULL, 0x0000001002477824ULL, 0x040fe200078e0217ULL,
0x0000000745177812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0203ULL,
0x000000005f007217ULL, 0x000fe20007800000ULL, 0x0000001028467824ULL, 0x040fe200078e0214ULL,
0x0000000f17177812ULL, 0x000fe200078e7865ULL, 0x0000000128147824ULL, 0x000fe200078e0203ULL,
0x0000000268027210ULL, 0x000fe20007f3e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a5fULL,
0x000000f053587812ULL, 0x000fe200078ec0ffULL, 0x0000000145037824ULL, 0x040fe200078e0203ULL,
0x0000001468287210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0002297a11ULL, 0x000fe200078440ffULL, 0x0000001045457824ULL, 0x000fe200078e0217ULL,
0x000000001500720cULL, 0x000fe20003f26070ULL, 0x000000ffff157224ULL, 0x000fe200018e06ffULL,
0x00005e0028177a11ULL, 0x000fc400078a40ffULL, 0x0000000368147210ULL, 0x000fe40007fde0ffULL,
0x00005f00022a7a11ULL, 0x000fe400010f442aULL, 0x0000005816027210ULL, 0x000fe40007f9e0ffULL,
0x00005f0028287a11ULL, 0x000fe200028f4415ULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x00005e0014167a11ULL, 0x000fe200078a40ffULL, 0x000000ffff037224ULL, 0x000fe200020e062bULL,
0x000000002c00720cULL, 0x000fc40003f46070ULL, 0x000000002d00720cULL, 0x080fe40003f66070ULL,
0x000000003400720cULL, 0x000fe40003f86070ULL, 0x0000e00048577811ULL, 0x000fe400078e20ffULL,
0x00005f0014007a11ULL, 0x000fe400028f4415ULL, 0x0000005829147210ULL, 0x000fe20007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002577faeULL, 0x0003e2000c901c46ULL,
0x0000e00047567811ULL, 0x000fc400078e20ffULL, 0x0000e00046557811ULL, 0x000fe200078e20ffULL,
0x000000ffff157224ULL, 0x000fe200028e062aULL, 0x0000005816167210ULL, 0x080fe40007fbe0ffULL,
0x0000e00045547811ULL, 0x000fe400078e20ffULL, 0x0000000014567faeULL, 0x0005e2000e101c46ULL,
0x0000005817027210ULL, 0x002fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fc800028e0600ULL,
0x000000ffff037224ULL, 0x000fca00008e0628ULL, 0x0000000002557faeULL, 0x0005e8000d101c46ULL,
0x0000000016547faeULL, 0x0005e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff027f8cULL, 0x004e68000c80043fULL,
0x0106ac00ff007984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010608005f147f8cULL, 0x000fe2000c80043fULL,
0x8000000000ff7812ULL, 0x004fc60007844830ULL, 0x01060c005f167984ULL, 0x000ea40000000800ULL,
0x8000000016ff7812ULL, 0x004fe40007824815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000167305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000160000735dULL, 0x008fe40003800000ULL,
0x01060c005f167984ULL, 0x000ea40000000800ULL, 0x8000000016ff7812ULL, 0x004fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe40000011665ULL,
0x0000007053537812ULL, 0x000fe400078ec0ffULL, 0x0000000c00007812ULL, 0x000fca00078ec0ffULL,
0x0000000153537824ULL, 0x000fca00078e0200ULL, 0x0100000053007984ULL, 0x000ea80000000800ULL,
0x0102000053167984ULL, 0x0007220000000800ULL, 0x0000005e0000720bULL, 0x004fe20003f3d000ULL,
0x00014d327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800008e0100ULL,
0x0000ffff14177812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff6600720cULL, 0x000fe40003f65270ULL, 0x0000005e0000720bULL, 0x000fe20003f34000ULL,
0x00014d127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000005e287209ULL, 0x000fe40007810000ULL, 0x0000ffff14147812ULL, 0x000fc600078e3cffULL,
0x010400285300b388ULL, 0x0005e20000000800ULL, 0x800000285e157221ULL, 0x000fe20000010000ULL,
0x0000001417ff7212ULL, 0x000fe4000782c0ffULL, 0x00000002ff147819ULL, 0x000fe20000011665ULL,
0x3fb8aa3b15157820ULL, 0x000fc80000410000ULL, 0x0000001500297308ULL, 0x0004e20000000800ULL,
0x00014cd27f007947ULL, 0x000fea000b800000ULL, 0x00001f1429157589ULL, 0x00c4e400000e0000ULL,
0x0000000814147810ULL, 0x004fe20007ffe0ffULL, 0x00014d227f007947ULL, 0x000fea000b800000ULL,
0x00001f1429147589ULL, 0x00052400000e0000ULL, 0x8000002800001221ULL, 0x000fe20000010000ULL,
0x00000001ff3a7807ULL, 0x000fe20000800000ULL, 0x000000295d5d7220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b00001820ULL, 0x000fe40000410000ULL, 0x0000001427277220ULL, 0x090fe40000410000ULL,
0x0000000000521308ULL, 0x000f220000000800ULL, 0x0000001426267220ULL, 0x000fc40000410000ULL,
0x0000001423237220ULL, 0x080fe40000410000ULL, 0x0000001422227220ULL, 0x080fe40000410000ULL,
0x000000141f1f7220ULL, 0x080fe40000410000ULL, 0x000000141e1e7220ULL, 0x080fe40000410000ULL,
0x000000141b1b7220ULL, 0x080fe40000410000ULL, 0x000000141a1a7220ULL, 0x000fc40000410000ULL,
0x0000001413137220ULL, 0x080fe40000410000ULL, 0x0000001412127220ULL, 0x080fe40000410000ULL,
0x0000001407077220ULL, 0x080fe40000410000ULL, 0x0000001406067220ULL, 0x080fe40000410000ULL,
0x000000140b0b7220ULL, 0x080fe40000410000ULL, 0x000000140a0a7220ULL, 0x000fc40000410000ULL,
0x000000140f0f7220ULL, 0x080fe40000410000ULL, 0x000000140e0e7220ULL, 0x000fe40000410000ULL,
0x0000001525257220ULL, 0x088fe40000410000ULL, 0x0000001524247220ULL, 0x080fe40000410000ULL,
0x0000001521217220ULL, 0x080fe40000410000ULL, 0x0000001520207220ULL, 0x000fc40000410000ULL,
0x000000151d1d7220ULL, 0x080fe40000410000ULL, 0x000000151c1c7220ULL, 0x080fe40000410000ULL,
0x0000001519197220ULL, 0x080fe40000410000ULL, 0x0000001518187220ULL, 0x080fe40000410000ULL,
0x0000001511117220ULL, 0x080fe40000410000ULL, 0x0000001510107220ULL, 0x000fc40000410000ULL,
0x0000001505057220ULL, 0x080fe40000410000ULL, 0x0000001504047220ULL, 0x080fe40000410000ULL,
0x0000001509097220ULL, 0x080fe40000410000ULL, 0x0000001508087220ULL, 0x080fe40000410000ULL,
0x000000150d0d7220ULL, 0x080fe40000410000ULL, 0x000000150c0c7220ULL, 0x000fc40000410000ULL,
0x000000ffff5e7224ULL, 0x000fe400078e0028ULL, 0x0000005216161220ULL, 0x010fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000005d165d7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fe40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000147305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000140000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff147984ULL, 0x000ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fc40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff00723eULL, 0x000fe400000000ffULL,
0x00000004ff4a7819ULL, 0x100fe40000011665ULL, 0x00000002ff4f7819ULL, 0x000fe40000011665ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000149c27f007947ULL, 0x000fea000b800000ULL,
0x00001f4f006e7589ULL, 0x00072400000e0000ULL, 0x000000084f517810ULL, 0x000fe20007ffe0ffULL,
0x00014a127f007947ULL, 0x000fea000b800000ULL, 0x00001f51006d7589ULL, 0x0004e400000e0000ULL,
0x000000104f507810ULL, 0x000fe20007ffe0ffULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x00001d2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e0050ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00015c8000007944ULL, 0x01efea0003c00000ULL,
0x000000184f4f7810ULL, 0x008fe20007ffe0ffULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x00001da000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e004fULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00015c0000007944ULL, 0x016fea0003c00000ULL,
0x0000000865007812ULL, 0x044fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000005c65147211ULL, 0x000fc400078fe0ffULL, 0x0000000700157812ULL, 0x140fe400078ec865ULL,
0x0000000700007812ULL, 0x000fe400078ef865ULL, 0x0000001415147212ULL, 0x000fe400078e3cffULL,
0x0000005a65167211ULL, 0x000fc600078fe0ffULL, 0x0000001000447824ULL, 0x000fe200078e0214ULL,
0x0000001615167212ULL, 0x000fc800078e3cffULL, 0x0000c000444e7811ULL, 0x000fe200078e20ffULL,
0x0000001000437824ULL, 0x040fe200078e0216ULL, 0x0000010000007811ULL, 0x000fc600078e20ffULL,
0x000000004e30783bULL, 0x000ea20000004200ULL, 0x0000c000434d7811ULL, 0x000fe200078e20ffULL,
0x0000000114427824ULL, 0x100fe400078e0200ULL, 0x0000000116417824ULL, 0x000fe400078e0200ULL,
0x000000004d28783bULL, 0x000ee20000004200ULL, 0x0000c000424c7811ULL, 0x000fe400078e20ffULL,
0x0000c000414b7811ULL, 0x000fc600078e20ffULL, 0x000000004c2c783bULL, 0x000fe80000004200ULL,
0x000000004b14783bULL, 0x000f620000004200ULL, 0x00000018ff377819ULL, 0x004fe20000011430ULL,
0x00000100303e7824ULL, 0x040fe200078e00ffULL, 0x0000888030007816ULL, 0x040fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe40000011431ULL,
0x00000000003f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff387819ULL, 0x008fc40000011428ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff397819ULL, 0x000fe40000011429ULL,
0x00000018ff3c7819ULL, 0x000fe2000001142aULL, 0x0000003000737306ULL, 0x0007e20000200c00ULL,
0x0000888031007816ULL, 0x004fe400000000ffULL, 0x00000018ff357819ULL, 0x000fe40000011432ULL,
0x00000018ff367819ULL, 0x000fc40000011433ULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000000000497306ULL, 0x0005e20000200c00ULL, 0x0000010031307824ULL, 0x048fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001142bULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x020fe40000011415ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x0000888032007816ULL, 0x004fc400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe40000011414ULL,
0x00000018ff727819ULL, 0x000fe4000001142cULL, 0x00000018ff717819ULL, 0x000fe2000001142dULL,
0x0000003000747306ULL, 0x0005620000200c00ULL, 0x00000018ff6a7819ULL, 0x000fe4000001142eULL,
0x00000018ff6c7819ULL, 0x000fe4000001142fULL, 0x00000018ff407819ULL, 0x000fc40000011416ULL,
0x00000018ff697819ULL, 0x000fe20000011417ULL, 0x0000000000767306ULL, 0x0009e20000200c00ULL,
0x0000010032307824ULL, 0x044fe200078e00ffULL, 0x000054103f3e7816ULL, 0x008fe2000000003eULL,
0x0001000032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003100757306ULL, 0x000fe20000200c00ULL,
0x0000888033007816ULL, 0x010fe400000000ffULL, 0x00005410493f7816ULL, 0x020fca0000000074ULL,
0x0000003000777306ULL, 0x0004f00000200c00ULL, 0x0000000000797306ULL, 0x0009e20000200c00ULL,
0x0000010033307824ULL, 0x044fe400078e00ffULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000003200787306ULL, 0x000fe20000200c00ULL, 0x0000888028007816ULL, 0x010fe400000000ffULL,
0x0000541076767816ULL, 0x008fca0000000077ULL, 0x00000030007a7306ULL, 0x0004f00000200c00ULL,
0x00000000007c7306ULL, 0x0009e20000200c00ULL, 0x0000010028307824ULL, 0x044fe400078e00ffULL,
0x0001000028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x00000033007b7306ULL, 0x000fe20000200c00ULL,
0x0000888029007816ULL, 0x010fe400000000ffULL, 0x0000541079777816ULL, 0x008fca000000007aULL,
0x00000028007e7306ULL, 0x0005f00000200c00ULL, 0x00000030007d7306ULL, 0x0007e20000200c00ULL,
0x000001002a287824ULL, 0x004fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000000007f7306ULL, 0x0005e20000200c00ULL, 0x0000010029307824ULL, 0x048fe400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000002800837306ULL, 0x0007e20000200c00ULL, 0x000088802a007816ULL, 0x044fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000000000827306ULL, 0x0005e20000200c00ULL,
0x000001002b287824ULL, 0x008fca00078e00ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x0000002900817306ULL, 0x0007e20000200c00ULL, 0x000088802b007816ULL, 0x044fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800867306ULL, 0x0005e20000200c00ULL, 0x000088802d297816ULL, 0x008fce00000000ffULL,
0x0000000000857306ULL, 0x0007e20000200c00ULL, 0x000001002c287824ULL, 0x004fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000003000807306ULL, 0x000fe20000200c00ULL,
0x000088802c007816ULL, 0x048fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000000000887306ULL, 0x0005f00000200c00ULL,
0x0000002800897306ULL, 0x0007e20000200c00ULL, 0x0000000765007812ULL, 0x004fc800078ec0ffULL,
0x0000000800007812ULL, 0x000fc600078ef865ULL, 0x0000002a00847306ULL, 0x0005e20000200c00ULL,
0x000000ffff287224ULL, 0x008fe200078e0029ULL, 0x000000074a4a7812ULL, 0x100fe200078e7800ULL,
0x000001002d297824ULL, 0x040fe200078e00ffULL, 0x0000000734347812ULL, 0x000fe200078e7800ULL,
0x000100002d2d7824ULL, 0x000fe400078e00ffULL, 0x00000008004a7824ULL, 0x040fe200078e024aULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x00000028008a7306ULL, 0x0007e20000200c00ULL,
0x000088802f2a7816ULL, 0x004fe200000000ffULL, 0x0000000800497824ULL, 0x000fe200078e0234ULL,
0x0000a0004a307811ULL, 0x000fc400078e20ffULL, 0x00000018ff2d7819ULL, 0x000fc6000001142dULL,
0x00000029008b7306ULL, 0x0005e20000200c00ULL, 0x000088802e287816ULL, 0x048fe200000000ffULL,
0x000000003030783bULL, 0x000eec0000000200ULL, 0x00000028008c7306ULL, 0x0009e20000200c00ULL,
0x000001002e297824ULL, 0x044fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b00877306ULL, 0x000fe20000200c00ULL,
0x000099103a287816ULL, 0x010fe400000000ffULL, 0x00000018ff2e7819ULL, 0x000fe4000001142eULL,
0x000000ff2800720cULL, 0x000fe20003f25270ULL, 0x000000ffff287224ULL, 0x000fe400078e002aULL,
0x00000029008d7306ULL, 0x0005e20000200c00ULL, 0x00000100152a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe4000001142aULL, 0x00000028008e7306ULL, 0x0009e20000200c00ULL,
0x000001002f297824ULL, 0x044fe400078e00ffULL, 0x000100002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000003b003b7306ULL, 0x000ea20000200c00ULL,
0x0000888014287816ULL, 0x010fe200000000ffULL, 0x0000006e30309232ULL, 0x088fe20000000000ULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000006e32329232ULL, 0x000fe40000000000ULL,
0x0000006d31319232ULL, 0x080fe40000000000ULL, 0x00000029008f7306ULL, 0x0007e20000200c00ULL,
0x0000006d33339232ULL, 0x000fce0000000000ULL, 0x0000002800907306ULL, 0x0009e20000200c00ULL,
0x0000010014297824ULL, 0x048fe200078e00ffULL, 0x000000763004723cULL, 0x040fe20000001804ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00005410753b7816ULL, 0x004fe4000000003bULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000003500357306ULL, 0x000ea20000200c00ULL,
0x0000888015287816ULL, 0x050fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000003e300c723cULL, 0x000fe6000000180cULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000002900917306ULL, 0x0007e60000200c00ULL,
0x00005410853f7816ULL, 0x000fc40000000086ULL, 0x00005410823e7816ULL, 0x000fc60000000083ULL,
0x0000003600367306ULL, 0x000f220000200c00ULL, 0x000000ffff297224ULL, 0x008fe200078e0028ULL,
0x0000a00049287811ULL, 0x000fe400078e20ffULL, 0x0000541078787816ULL, 0x004fe40000000035ULL,
0x000054107f357816ULL, 0x000fe40000000080ULL, 0x0000002900747306ULL, 0x0005f00000200c00ULL,
0x0000003700377306ULL, 0x000ee20000200c00ULL, 0x000000002828783bULL, 0x004ea20000000200ULL,
0x000054107b797816ULL, 0x010fcc0000000036ULL, 0x0000003800387306ULL, 0x000f220000200c00ULL,
0x000000783010723cULL, 0x000fee0000001810ULL, 0x0000003900397306ULL, 0x000f620000200c00ULL,
0x00005410733a7816ULL, 0x008fce0000000037ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000003a3008723cULL, 0x000fe20000001808ULL, 0x000054107e387816ULL, 0x010fcc0000000038ULL,
0x0000003d003d7306ULL, 0x000f220000200c00ULL, 0x0000541081397816ULL, 0x020fce0000000039ULL,
0x0000003400757306ULL, 0x000be20000200c00ULL, 0x0000006e28289232ULL, 0x084fe20000000000ULL,
0x0000541084847816ULL, 0x008fe2000000003cULL, 0x0000006e2a2a9232ULL, 0x000fe20000000000ULL,
0x000000383038723cULL, 0x000fe2000000181cULL, 0x0000006d29299232ULL, 0x080fe40000000000ULL,
0x0000006d2b2b9232ULL, 0x000fe20000000000ULL, 0x0000001500767306ULL, 0x0005e20000200c00ULL,
0x000054107c347816ULL, 0x020fe4000000007dULL, 0x0000541087857816ULL, 0x010fc4000000003dULL,
0x0000003e303c723cULL, 0x000fe60000001820ULL, 0x0000001400737306ULL, 0x0007e20000200c00ULL,
0x0000010016157824ULL, 0x004fc600078e00ffULL, 0x0000541088207816ULL, 0x000fe20000000089ULL,
0x000000343034723cULL, 0x040fe20000001818ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000888016147816ULL, 0x048fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x000054108a217816ULL, 0x000fe4000000008bULL,
0x000054108c187816ULL, 0x000fe2000000008dULL, 0x000000843024723cULL, 0x000fe20000001824ULL,
0x000054108e197816ULL, 0x000fe2000000008fULL, 0x0000001400777306ULL, 0x0005e20000200c00ULL,
0x00000018ff167819ULL, 0x000fca0000011416ULL, 0x000000182818723cULL, 0x000fe40000001804ULL,
0x0000001500787306ULL, 0x0007e20000200c00ULL, 0x0000888017147816ULL, 0x004fca00000000ffULL,
0x000000202820723cULL, 0x000fe4000000180cULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000010017157824ULL, 0x048fe400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000002c002c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff047819ULL, 0x000fce0000011417ULL, 0x0000002d002d7306ULL, 0x000ef00000200c00ULL,
0x0000006f006f7306ULL, 0x000f220000200c00ULL, 0x000054102c1c7816ULL, 0x004fce0000000072ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000054102d1d7816ULL, 0x008fce0000000071ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000001c281c723cULL, 0x000fe20000001808ULL,
0x00005410730c7816ULL, 0x010fcc000000006fULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x00005410760d7816ULL, 0x004fe40000000070ULL, 0x0000541077087816ULL, 0x000fca0000000078ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000000c280c723cULL, 0x000fee0000001838ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x00000014006e7306ULL, 0x0005f00000200c00ULL,
0x0000001500317306ULL, 0x0007220000200c00ULL, 0x0000541090147816ULL, 0x004fce0000000091ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x0000541074157816ULL, 0x008fce0000000075ULL,
0x0000001600307306ULL, 0x0007e20000200c00ULL, 0x000054106e097816ULL, 0x010fce0000000031ULL,
0x0000002f002f7306ULL, 0x000f220000200c00ULL, 0x000054102e2e7816ULL, 0x004fe2000000006aULL,
0x000000142814723cULL, 0x048fec0000001834ULL, 0x0000000400057306ULL, 0x0004e40000200c00ULL,
0x000000082808723cULL, 0x000fe2000000183cULL, 0x000054102f2f7816ULL, 0x010fc4000000006cULL,
0x0000541030047816ULL, 0x004fca0000000040ULL, 0x0000002e282c723cULL, 0x000fe20000001810ULL,
0x0000541005057816ULL, 0x008fce0000000069ULL, 0x000000042804723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff107f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007844811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x0000001200137305ULL, 0x0004e4000021f000ULL, 0x3fa0000012127823ULL, 0x004fe200000100ffULL,
0x000000130000735dULL, 0x008fe40003800000ULL, 0x0106bc00ff137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000004063107811ULL, 0x000fe400078e40ffULL, 0x00000004ff277819ULL, 0x000fc40000011665ULL,
0x0000001064117217ULL, 0x000fe40007800000ULL, 0x0000004067127811ULL, 0x000fe400078e38ffULL,
0x0000000227287810ULL, 0x000fe20007ffe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0a10ULL,
0x0000005f12107210ULL, 0x0c0fe40007ffe027ULL, 0x0000005f12137210ULL, 0x000fe40007ffe028ULL,
0x0000002011117807ULL, 0x000fc40000000000ULL, 0x0000001068257210ULL, 0x040fe40007f5e0ffULL,
0x000000115f117217ULL, 0x000fe40007800000ULL, 0x00000004272b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x0000001368297210ULL, 0x000fe20007f7e0ffULL,
0x0000000111137824ULL, 0x000fe200078e0a5fULL, 0x00005e0025107a11ULL, 0x000fe200078440ffULL,
0x000000015f6c7824ULL, 0x000fe200078e022bULL, 0x00005e0029267a11ULL, 0x000fe200078840ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x000000132700720cULL, 0x000fc40003f66070ULL,
0x00005f0025257a11ULL, 0x000fe200010f4424ULL, 0x000000016c247824ULL, 0x000fe200078e0212ULL,
0x0000005810107210ULL, 0x000fe40007f5e0ffULL, 0x00000006272a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0029297a11ULL, 0x000fe200020f4411ULL, 0x000000ffff117224ULL, 0x000fe200010e0625ULL,
0x0000002468247210ULL, 0x000fe40007f9e0ffULL, 0x0000c00048487811ULL, 0x000fc400078e20ffULL,
0x0000005f12127210ULL, 0x000fe40007ffe02aULL, 0x000000132800720cULL, 0x080fe20003f46070ULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x0000001268257210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010487faeULL, 0x0005e2000d901c46ULL,
0x00005e0024277a11ULL, 0x040fe400078840ffULL, 0x000000132b00720cULL, 0x000fe40003f66070ULL,
0x00005f0024287a11ULL, 0x000fc400020f4428ULL, 0x00005e0025247a11ULL, 0x000fe400078840ffULL,
0x0000c00047477811ULL, 0x000fe400078e20ffULL, 0x0000c00046467811ULL, 0x000fe400078e20ffULL,
0x0000005826107210ULL, 0x084fe20007fbe0ffULL, 0x000000ffff267224ULL, 0x000fe200030e06ffULL,
0x0000005827127210ULL, 0x000fe40007fde0ffULL, 0x0000c00045457811ULL, 0x000fe200078e20ffULL,
0x000000ffff117224ULL, 0x000fe200028e0629ULL, 0x000000132a00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff137224ULL, 0x000fe200030e0628ULL, 0x00005f0025257a11ULL, 0x000fc400020f4426ULL,
0x0000005824247210ULL, 0x000fe20007f9e0ffULL, 0x0000000010477faeULL, 0x0005e8000d101c46ULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x0000000012467faeULL, 0x0007e8000d901c46ULL,
0x0000000024457faeULL, 0x0007e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x006fc40007844803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007844803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x0106b400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff377819ULL, 0x000fe40000011665ULL, 0x0000000465037811ULL, 0x000fe400078fe0ffULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x000132c27f007947ULL, 0x000fea000b800000ULL,
0x00001f37023d7589ULL, 0x0002a400000e0000ULL, 0x000133127f007947ULL, 0x000fea000b800000ULL,
0x00001f51023c7589ULL, 0x00086400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0002ULL, 0x0000350000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x002fe400078e0050ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x000144a000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0002ULL,
0x0000357000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fe400078e004fULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0001443000007944ULL, 0x01cfea0003c00000ULL, 0x0000e00044447811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e00043437811ULL, 0x000fe400078e20ffULL,
0x0000e00042427811ULL, 0x000fe200078e20ffULL, 0x000000004424783bULL, 0x008ee20000004200ULL,
0x0000000703037812ULL, 0x000fc400078e7800ULL, 0x0000e00041417811ULL, 0x000fe200078e20ffULL,
0x000000004328783bULL, 0x000f680000004200ULL, 0x000000004234783bULL, 0x002e680000004200ULL,
0x000000004110783bULL, 0x000f220000004200ULL, 0x0000888026407816ULL, 0x048fe200000000ffULL,
0x0000010027777824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011427ULL,
0x0000010026757824ULL, 0x040fe200078e00ffULL, 0x0000004000767306ULL, 0x0007e20000200c00ULL,
0x00000018ff717819ULL, 0x000fe20000011426ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x020fe20000011428ULL, 0x0000010024397824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011429ULL, 0x00000100253b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000888027407816ULL, 0x048fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc4000001142aULL, 0x00000018ff6e7819ULL, 0x000fe4000001142bULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000002600787306ULL, 0x0007e20000200c00ULL,
0x0000888024387816ULL, 0x000fe400000000ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00008880253a7816ULL, 0x000fe400000000ffULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x00000027007a7306ULL, 0x000be20000200c00ULL, 0x0000888028267816ULL, 0x008fc400000000ffULL,
0x00000018ff737819ULL, 0x000fe20000011424ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011425ULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x002fe20000011434ULL, 0x00000026007b7306ULL, 0x0003e20000200c00ULL,
0x0000010028277824ULL, 0x060fe200078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x0000004000797306ULL, 0x0007e20000200c00ULL,
0x0000888029267816ULL, 0x002fe400000000ffULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff697819ULL, 0x000fe40000011435ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x00000027007c7306ULL, 0x0003620000200c00ULL, 0x0000000800407824ULL, 0x008fe200078e0203ULL,
0x00000018ff3e7819ULL, 0x000fe20000011436ULL, 0x0000010035037824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011437ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000026007d7306ULL, 0x0007e20000200c00ULL, 0x0000010029277824ULL, 0x042fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fe20000011403ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff327819ULL, 0x010fe40000011410ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000028007e7306ULL, 0x0003e20000200c00ULL, 0x000088802a267816ULL, 0x008fc400000000ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x000054107b7c7816ULL, 0x020fe4000000007cULL,
0x00000018ff337819ULL, 0x000fe20000011411ULL, 0x00000027007f7306ULL, 0x0007220000200c00ULL,
0x0000a00040287811ULL, 0x002fe400078e20ffULL, 0x00000018ff027819ULL, 0x000fe40000011412ULL,
0x00000018ff317819ULL, 0x004fc60000011413ULL, 0x0000002600817306ULL, 0x0003e20000200c00ULL,
0x000001002a277824ULL, 0x048fe400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002900807306ULL, 0x000fe20000200c00ULL, 0x000088802b267816ULL, 0x002fe400000000ffULL,
0x000054107d7d7816ULL, 0x010fca000000007fULL, 0x0000002700827306ULL, 0x0003f00000200c00ULL,
0x0000002a00837306ULL, 0x000fe20000200c00ULL, 0x000001002b277824ULL, 0x042fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002600847306ULL, 0x0003f00000200c00ULL,
0x0000002b00867306ULL, 0x0005e20000200c00ULL, 0x0000888034267816ULL, 0x002fce00000000ffULL,
0x0000002600877306ULL, 0x0003e20000200c00ULL, 0x000000002828783bULL, 0x004eae0000000200ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x0000888035267816ULL, 0x042fe200000000ffULL,
0x0001000035357824ULL, 0x000fca00078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x00000026008a7306ULL, 0x0003f00000200c00ULL, 0x0000003900397306ULL, 0x000ee20000200c00ULL,
0x0000010036267824ULL, 0x002fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000003a003a7306ULL, 0x000ff00000200c00ULL, 0x0000003b003b7306ULL, 0x000e620000200c00ULL,
0x0000541038387816ULL, 0x008fe20000000039ULL, 0x0000003d28289232ULL, 0x004fc40000000000ULL,
0x0000003d2a2a9232ULL, 0x000fe40000000000ULL, 0x0000003c29299232ULL, 0x080fe40000000000ULL,
0x00000003008b7306ULL, 0x0005e20000200c00ULL, 0x0000003c2b2b9232ULL, 0x000fce0000000000ULL,
0x00000026008e7306ULL, 0x0007e20000200c00ULL, 0x0000888036037816ULL, 0x044fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x000054103a397816ULL, 0x002fe2000000003bULL,
0x0000007c2814723cULL, 0x000fe60000001814ULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x00000003008d7306ULL, 0x0003e20000200c00ULL, 0x0000010037267824ULL, 0x008fc600078e00ffULL,
0x000000382838723cULL, 0x000fe40000001820ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000888037037816ULL, 0x042fe200000000ffULL,
0x0001000037377824ULL, 0x000fe400078e00ffULL, 0x0000010010217824ULL, 0x000fc600078e00ffULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000000300907306ULL, 0x0003e20000200c00ULL,
0x00000018ff217819ULL, 0x000fce0000011421ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000000665037811ULL, 0x002fc800078fe0ffULL, 0x0000000703037812ULL, 0x000fc600078e7800ULL,
0x0000002400247306ULL, 0x000fe40000200c00ULL, 0x0000000800037824ULL, 0x000fcc00078e0203ULL,
0x0000002500257306ULL, 0x000e700000200c00ULL, 0x0000002700857306ULL, 0x0005f00000200c00ULL,
0x0000002600917306ULL, 0x0007e20000200c00ULL, 0x0000010034277824ULL, 0x004fc400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x00000035008c7306ULL, 0x0003e20000200c00ULL,
0x0000888010267816ULL, 0x048fe200000000ffULL, 0x0001000010107824ULL, 0x000fc800078e00ffULL,
0x000000ffff207224ULL, 0x000fe200078e0026ULL, 0x0000a00003267811ULL, 0x000fe200078e20ffULL,
0x0000003400897306ULL, 0x0005e20000200c00ULL, 0x0000541025357816ULL, 0x002fe40000000074ULL,
0x00000018ff107819ULL, 0x000fca0000011410ULL, 0x0000002700887306ULL, 0x0003e20000200c00ULL,
0x0000541024347816ULL, 0x004fce0000000073ULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000000002624783bULL, 0x002e6e0000000200ULL, 0x0000006f006f7306ULL, 0x000ff00000200c00ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541079777816ULL, 0x004fc40000000077ULL,
0x000054107a797816ULL, 0x000fca0000000072ULL, 0x0000007500757306ULL, 0x000eb00000200c00ULL,
0x00000036008f7306ULL, 0x000ff00000200c00ULL, 0x0000003700007306ULL, 0x0007e20000200c00ULL,
0x0000541076767816ULL, 0x004fe20000000075ULL, 0x0000003d24249232ULL, 0x002fc40000000000ULL,
0x0000003d26269232ULL, 0x000fe40000000000ULL, 0x0000003c25259232ULL, 0x080fe40000000000ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000342834723cULL, 0x008fe2000000181cULL,
0x0000003c27279232ULL, 0x000fcc0000000000ULL, 0x00000100111d7824ULL, 0x040fe200078e00ffULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00008880111c7816ULL, 0x040fe200000000ffULL,
0x000000762818723cULL, 0x000fe20000001818ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000541078787816ULL, 0x002fe40000000071ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x00000018ff117819ULL, 0x000fc80000011411ULL,
0x00000078282c723cULL, 0x000fe6000000182cULL, 0x0000002000927306ULL, 0x0007f00000200c00ULL,
0x0000002100737306ULL, 0x0009e20000200c00ULL, 0x0000541081207816ULL, 0x008fce0000000082ULL,
0x0000001c00747306ULL, 0x0007e20000200c00ULL, 0x0000541084217816ULL, 0x010fce0000000085ULL,
0x0000001d00727306ULL, 0x0009e20000200c00ULL, 0x000054107e1c7816ULL, 0x008fe2000000006fULL,
0x000000202820723cULL, 0x000fec0000001808ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00005410801d7816ULL, 0x010fe20000000070ULL, 0x0000010012097824ULL, 0x000fca00078e00ffULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x0000001c281c723cULL, 0x000fee000000180cULL, 0x00008880120e7816ULL, 0x040fe200000000ffULL,
0x00000009003c7306ULL, 0x0007e20000200c00ULL, 0x00005410830c7816ULL, 0x004fe2000000006dULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00005410860d7816ULL, 0x002fe2000000006eULL,
0x000000ffff087224ULL, 0x000fc600078e000eULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000008003d7306ULL, 0x0002a20000200c00ULL, 0x000054108c097816ULL, 0x008fe20000000069ULL,
0x0000000c2828723cULL, 0x000fec0000001804ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x0000010013057824ULL, 0x000fe200078e00ffULL, 0x00005410870c7816ULL, 0x000fc40000000088ULL,
0x000054108a0d7816ULL, 0x000fe4000000008bULL, 0x0000541089087816ULL, 0x002fe4000000006aULL,
0x0000888013047816ULL, 0x040fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000000c240c723cULL, 0x000fe20000001838ULL,
0x0000000400387306ULL, 0x0003e20000200c00ULL, 0x000054103d3c7816ULL, 0x004fe4000000003cULL,
0x00005410003f7816ULL, 0x008fc8000000003fULL, 0x000000082408723cULL, 0x000fe20000001834ULL,
0x0000000500357306ULL, 0x0004e20000200c00ULL, 0x000054108d047816ULL, 0x002fce000000008eULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x0000541090057816ULL, 0x004fce0000000091ULL,
0x000000042404723cULL, 0x000fe20000001818ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x00005410383d7816ULL, 0x008fca0000000035ULL, 0x00000018ff187819ULL, 0x000fe40000011413ULL,
0x0000003300337306ULL, 0x000fe20000200c00ULL, 0x000054108f3e7816ULL, 0x002fe2000000003eULL,
0x0000003c2420723cULL, 0x000fe20000001820ULL, 0x0000541074197816ULL, 0x000fca0000000072ULL,
0x0000001000717306ULL, 0x000e700000200c00ULL, 0x00000011006f7306ULL, 0x000eb00000200c00ULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x0000541071327816ULL, 0x002fce0000000032ULL,
0x0000003100317306ULL, 0x000fe20000200c00ULL, 0x000054106f337816ULL, 0x004fce0000000033ULL,
0x0000001200347306ULL, 0x0002a20000200c00ULL, 0x00000032241c723cULL, 0x040fee000000181cULL,
0x0000001800007306ULL, 0x0007220000200c00ULL, 0x0000003e2410723cULL, 0x002fe2000000182cULL,
0x0000541034347816ULL, 0x004fc40000000002ULL, 0x0000541092187816ULL, 0x008fe40000000073ULL,
0x0000541000357816ULL, 0x010fca0000000031ULL, 0x000000182418723cULL, 0x040ff00000001814ULL,
0x000000342424723cULL, 0x000fe20000001828ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004063007811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff147224ULL, 0x002fc400078e0015ULL,
0x000000006400720cULL, 0x000fda0003f24070ULL, 0x0000979000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824814ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300ff027624ULL, 0x000fe200078e00ffULL, 0x0000000160007812ULL, 0x000fe200078ec0ffULL,
0xffffffffff6b7424ULL, 0x000fc600078e00ffULL, 0x000000010000780cULL, 0x000fe40003f25070ULL,
0xffffffff02027811ULL, 0x000fc800078e08ffULL, 0x0000000102027807ULL, 0x000fca0004800000ULL,
0x0000000160607824ULL, 0x000fca00078e0202ULL, 0x000000626000720cULL, 0x000fe40003f26070ULL,
0x00000004ff327819ULL, 0x000fd60000011665ULL, 0x000000025b149210ULL, 0x000fe20007ffe059ULL,
0x00000004ff159424ULL, 0x000fc800078e00ffULL, 0x0000600014149625ULL, 0x000fe200078e0015ULL,
0x0000006063007811ULL, 0x000fc800078e40ffULL, 0x00000006146b9981ULL, 0x000362000c1e1900ULL,
0x0000000465317811ULL, 0x040fe400078fe0ffULL, 0x0000000232337810ULL, 0x000fe40007ffe0ffULL,
0x00000006652f7811ULL, 0x000fe400078fe0ffULL, 0x0000006067157811ULL, 0x002fe400078e38ffULL,
0x0000000064147217ULL, 0x000fe40007800000ULL, 0x0000005f15167210ULL, 0x000fc40007ffe032ULL,
0x0000002f15177210ULL, 0x140fe20007ffe05fULL, 0x0000000114147824ULL, 0x000fe200078e0a00ULL,
0x00000016682e7210ULL, 0x040fe40007f3e0ffULL, 0x0000003115167210ULL, 0x000fe40007ffe05fULL,
0x00000017682b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005e002e2d7a11ULL, 0x000fe400078240ffULL, 0x0000002014147807ULL, 0x000fc40000000000ULL,
0x00005f002e2e7a11ULL, 0x000fe200008f4400ULL, 0x000000015f007824ULL, 0x040fe200078e0233ULL,
0x0000001668297210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x000000145f147217ULL, 0x000fe20007800000ULL, 0x0000000100157824ULL, 0x000fe200078e0215ULL,
0x00005e0029287a11ULL, 0x000fe200078440ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078640ffULL, 0x0000001568157210ULL, 0x000fc40007f3e0ffULL,
0x00005f0029297a11ULL, 0x000fe200010f4417ULL, 0x0000000114177824ULL, 0x000fe200078e0a5fULL,
0x00005f002b2b7a11ULL, 0x000fe200018f4416ULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x00005e0015167a11ULL, 0x000fe400078640ffULL, 0x000000582d147210ULL, 0x080fe40007f9e0ffULL,
0x000000173200720cULL, 0x000fe40003f46070ULL, 0x00005f00152c7a11ULL, 0x000fe200018f442cULL,
0x000000ffff157224ULL, 0x000fe200020e062eULL, 0x0000005816167210ULL, 0x000fc40007fbe0ffULL,
0x000000173300720cULL, 0x080fe40003f26070ULL, 0x000000173100720cULL, 0x080fe40003f66070ULL,
0x000000172f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff177224ULL, 0x000fe200028e062cULL,
0x0000005828287210ULL, 0x080fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e2000d101c46ULL, 0x000000582a2a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff297224ULL, 0x000fe400030e0629ULL, 0x000000ffff2b7224ULL, 0x000fe200028e062bULL,
0x0000000016567faeULL, 0x0005e8000c901c46ULL, 0x0000000028557faeULL, 0x0005e8000d901c46ULL,
0x000000002a547faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff347f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff167984ULL, 0x004ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010628005f147f8cULL, 0x000fe2000c80043fULL,
0x8000000016ff7812ULL, 0x004fc60007844830ULL, 0x01062c005f177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fe40007824815ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff167424ULL, 0x000fc800078e00ffULL, 0x0000001600177305ULL, 0x0004e4000021f000ULL,
0x3fa0000016167823ULL, 0x004fe200000100ffULL, 0x000000170000735dULL, 0x008fe40003800000ULL,
0x01062c005f177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fc40007824815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800053167984ULL, 0x000ea80000000800ULL,
0x0102800053177984ULL, 0x0007220000000800ULL, 0x0000005e1600720bULL, 0x004fe20003f3d000ULL,
0x00011b827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800008e0100ULL,
0x0000ffff14297812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff727424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000016600780cULL, 0x000fe40003f65270ULL, 0x0000005e1600720bULL, 0x000fe20003f34000ULL,
0x00011b627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fe400008e0100ULL,
0x000000165e157209ULL, 0x000fe40007810000ULL, 0x0000ffff14147812ULL, 0x000fe400078e3cffULL,
0x00000002ff317819ULL, 0x000fe20000011665ULL, 0x800000155e287221ULL, 0x000fe20000010000ULL,
0x010480155300b388ULL, 0x0005e20000000800ULL, 0x0000001429ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b28287820ULL, 0x000fcc0000410000ULL, 0x0000002800287308ULL, 0x000ee40000000800ULL,
0x000000285d5d7220ULL, 0x008fe20000410000ULL, 0x00011b127f007947ULL, 0x000fea000b800000ULL,
0x00001f3128317589ULL, 0x0044e400000e0000ULL, 0x000000310c0c7220ULL, 0x08cfe40000410000ULL,
0x000000310d0d7220ULL, 0x080fe40000410000ULL, 0x0000003108087220ULL, 0x080fe40000410000ULL,
0x0000003109097220ULL, 0x080fe40000410000ULL, 0x0000003104047220ULL, 0x000fc40000410000ULL,
0x0000003105057220ULL, 0x080fe40000410000ULL, 0x0000003110107220ULL, 0x080fe40000410000ULL,
0x0000003111117220ULL, 0x080fe40000410000ULL, 0x0000003118187220ULL, 0x080fe40000410000ULL,
0x0000003119197220ULL, 0x080fe40000410000ULL, 0x000000311c1c7220ULL, 0x000fc40000410000ULL,
0x000000311d1d7220ULL, 0x080fe40000410000ULL, 0x0000003120207220ULL, 0x080fe40000410000ULL,
0x0000003121217220ULL, 0x080fe40000410000ULL, 0x0000003124247220ULL, 0x080fe40000410000ULL,
0x0000003125257220ULL, 0x000fe20000410000ULL, 0x00011a627f007947ULL, 0x000fea000b800000ULL,
0x00001f5128317589ULL, 0x0004e400000e0000ULL, 0x000000165e5e7209ULL, 0x000fe20007810000ULL,
0x000000310e0e7220ULL, 0x08cfe20000410000ULL, 0x00000001ff727807ULL, 0x000fe20000800000ULL,
0x000000310f0f7220ULL, 0x000fc40000410000ULL, 0x8000005e16161221ULL, 0x000fe40000010000ULL,
0x000000310a0a7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b16161820ULL, 0x000fe40000410000ULL,
0x000000310b0b7220ULL, 0x080fe40000410000ULL, 0x0000001600521308ULL, 0x000ea20000000800ULL,
0x0000003106067220ULL, 0x080fe40000410000ULL, 0x0000003107077220ULL, 0x000fc40000410000ULL,
0x0000003112127220ULL, 0x080fe40000410000ULL, 0x0000003113137220ULL, 0x080fe40000410000ULL,
0x000000311a1a7220ULL, 0x080fe40000410000ULL, 0x000000311b1b7220ULL, 0x080fe40000410000ULL,
0x000000311e1e7220ULL, 0x080fe40000410000ULL, 0x000000311f1f7220ULL, 0x000fc40000410000ULL,
0x0000003122227220ULL, 0x080fe40000410000ULL, 0x0000003123237220ULL, 0x080fe40000410000ULL,
0x0000003126267220ULL, 0x080fe40000410000ULL, 0x0000003127277220ULL, 0x000fe40000410000ULL,
0x0000001752171220ULL, 0x014fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000005d175d7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fc40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0004e4000021f000ULL, 0x3fa0000014147823ULL, 0x004fe200000100ffULL,
0x000000150000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff14723eULL, 0x000fe400000000ffULL, 0x00000002ff377819ULL, 0x000fc40000011665ULL,
0x0000541014147816ULL, 0x000fe20000000014ULL, 0x000118127f007947ULL, 0x000fea000b800000ULL,
0x00001f37143b7589ULL, 0x0004e400000e0000ULL, 0x000118627f007947ULL, 0x000fea000b800000ULL,
0x00001f51143a7589ULL, 0x0008a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0014ULL, 0x0000524000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x004fe400078e0050ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0001276000007944ULL, 0x03afea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0014ULL,
0x000052b000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x004fe400078e004fULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000126f000007944ULL, 0x03afea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004e2c783bULL, 0x000f220000004200ULL, 0x0000991072727816ULL, 0x000fc600000000ffULL,
0x000000004d30783bULL, 0x004fe20000004200ULL, 0x000000ff7200720cULL, 0x000fc60003f25270ULL,
0x000000004c14783bULL, 0x010ea80000004200ULL, 0x000000004b28783bULL, 0x000f220000004200ULL,
0x00000018ff707819ULL, 0x000fe2000001142cULL, 0x000001002c747824ULL, 0x040fe200078e00ffULL,
0x000088802c737816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x000088802d757816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe2000001142dULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fc4000001142cULL,
0x00000018ff6e7819ULL, 0x000fe4000001142eULL, 0x00000018ff6f7819ULL, 0x000fe4000001142fULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000002c00767306ULL, 0x0006620000200c00ULL,
0x00000018ff3e7819ULL, 0x004fe40000011415ULL, 0x00000018ff6a7819ULL, 0x000fe40000011430ULL,
0x00000018ff6d7819ULL, 0x000fc40000011431ULL, 0x00000018ff3f7819ULL, 0x000fe20000011414ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000ffff2c7224ULL, 0x008fe200078e0075ULL,
0x00000018ff687819ULL, 0x000fe20000011432ULL, 0x000001002d757824ULL, 0x040fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011433ULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011416ULL, 0x0000002c00777306ULL, 0x0005e20000200c00ULL,
0x00000018ff757819ULL, 0x000fc40000011475ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000541076707816ULL, 0x002fe40000000070ULL, 0x00000018ff3d7819ULL, 0x000fe20000011417ULL,
0x0000002d00787306ULL, 0x0002e20000200c00ULL, 0x000088802e2c7816ULL, 0x004fe400000000ffULL,
0x00000018ff397819ULL, 0x010fe40000011429ULL, 0x00000018ff387819ULL, 0x000fc40000011428ULL,
0x00000018ff377819ULL, 0x000fe2000001142bULL, 0x0000002c00797306ULL, 0x0005e20000200c00ULL,
0x000001002e2d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe2000001142aULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000088802f2c7816ULL, 0x004fe400000000ffULL, 0x0000541078717816ULL, 0x008fca0000000071ULL,
0x0000002d007a7306ULL, 0x0002b00000200c00ULL, 0x0000002c007b7306ULL, 0x0007e20000200c00ULL,
0x000001002f2d7824ULL, 0x042fe400078e00ffULL, 0x000100002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002e007c7306ULL, 0x000fe20000200c00ULL, 0x00008880302c7816ULL, 0x008fe400000000ffULL,
0x00005410797a7816ULL, 0x004fca000000007aULL, 0x0000002d007d7306ULL, 0x0002b00000200c00ULL,
0x0000002c007f7306ULL, 0x0007e20000200c00ULL, 0x00000100302d7824ULL, 0x042fe400078e00ffULL,
0x0001000030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002f007e7306ULL, 0x000fe20000200c00ULL, 0x00008880312c7816ULL, 0x008fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x000054107b7b7816ULL, 0x004fc6000000007dULL,
0x0000002d00807306ULL, 0x0002b00000200c00ULL, 0x0000002c00817306ULL, 0x0007e20000200c00ULL,
0x00000100312d7824ULL, 0x042fe400078e00ffULL, 0x0001000031317824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x00008880322c7816ULL, 0x008fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x000054107f807816ULL, 0x004fc60000000080ULL, 0x0000002d00827306ULL, 0x0004f00000200c00ULL,
0x0000002c00837306ULL, 0x0009e20000200c00ULL, 0x00000100322d7824ULL, 0x044fe200078e00ffULL,
0x0000541073747816ULL, 0x002fe20000000074ULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x00008880332c7816ULL, 0x010fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x0000541081817816ULL, 0x008fc60000000082ULL, 0x0000002d00847306ULL, 0x0004f00000200c00ULL,
0x0000002c00857306ULL, 0x0009e20000200c00ULL, 0x00000100332d7824ULL, 0x004fe200078e00ffULL,
0x0000541077757816ULL, 0x002fe20000000075ULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00008880142c7816ULL, 0x010fe400000000ffULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000541083847816ULL, 0x008fc60000000084ULL, 0x0000002d00867306ULL, 0x0002b00000200c00ULL,
0x0000002c00877306ULL, 0x0007e20000200c00ULL, 0x00000100142d7824ULL, 0x042fe400078e00ffULL,
0x0001000014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00008880152c7816ULL, 0x008fe400000000ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000541085857816ULL, 0x004fc60000000086ULL,
0x0000002d00887306ULL, 0x0002b00000200c00ULL, 0x0000002c00897306ULL, 0x0007e20000200c00ULL,
0x00000100152d7824ULL, 0x042fe400078e00ffULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000003000307306ULL, 0x000e620000200c00ULL, 0x0000a8004a2c7811ULL, 0x008fe400078e20ffULL,
0x0000541087887816ULL, 0x004fca0000000088ULL, 0x0000002d008b7306ULL, 0x0004f00000200c00ULL,
0x00000015008c7306ULL, 0x0009e20000200c00ULL, 0x000000002c2c783bULL, 0x004ea20000000200ULL,
0x0000541030307816ULL, 0x002fcc000000006aULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x0000010016157824ULL, 0x010fe200078e00ffULL, 0x0000541089897816ULL, 0x008fc8000000008bULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000014008a7306ULL, 0x0007f00000200c00ULL,
0x0000006e006e7306ULL, 0x000f220000200c00ULL, 0x0000888016147816ULL, 0x048fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000541031317816ULL, 0x002fc8000000006dULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000006f006f7306ULL, 0x000e700000200c00ULL,
0x00000015008e7306ULL, 0x0007e20000200c00ULL, 0x0000003b2c2c9232ULL, 0x084fe20000000000ULL,
0x000054107c6e7816ULL, 0x010fe2000000006eULL, 0x0000003b2e2e9232ULL, 0x000fc40000000000ULL,
0x0000003a2d2d9232ULL, 0x080fe40000000000ULL, 0x0000003a2f2f9232ULL, 0x000fe20000000000ULL,
0x00000014008d7306ULL, 0x0005220000200c00ULL, 0x0000010017157824ULL, 0x008fe200078e00ffULL,
0x000054107e6f7816ULL, 0x002fc8000000006fULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000000742c0c723cULL, 0x000fe2000000180cULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000888017147816ULL, 0x044fe200000000ffULL, 0x0001000017177824ULL, 0x000fc800078e00ffULL,
0x0000010029747824ULL, 0x000fe200078e00ffULL, 0x000000702c08723cULL, 0x040fe20000001808ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x000054108d8e7816ULL, 0x010fe4000000008eULL,
0x0000888029717816ULL, 0x040fe200000000ffULL, 0x0000003200327306ULL, 0x000e620000200c00ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x000000302c1c723cULL, 0x000fe8000000181cULL,
0x00000018ff297819ULL, 0x000fc40000011429ULL, 0x0000003300337306ULL, 0x000ea40000200c00ULL,
0x0000006e2c10723cULL, 0x040fec0000001810ULL, 0x00000014008f7306ULL, 0x0007e20000200c00ULL,
0x0000541032687816ULL, 0x002fe20000000068ULL, 0x0000007a2c04723cULL, 0x040fec0000001804ULL,
0x0000001500907306ULL, 0x0003220000200c00ULL, 0x0000a80049147811ULL, 0x008fe200078e20ffULL,
0x000000802c18723cULL, 0x000fe20000001818ULL, 0x0000541033697816ULL, 0x004fca0000000069ULL,
0x0000001600727306ULL, 0x0005e20000200c00ULL, 0x0000888028157816ULL, 0x042fe200000000ffULL,
0x000000842c20723cULL, 0x040fec0000001820ULL, 0x0000001700917306ULL, 0x000fe20000200c00ULL,
0x0000010028167824ULL, 0x044fe200078e00ffULL, 0x000000682c24723cULL, 0x000fe20000001824ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x000054108f8f7816ULL, 0x010fc40000000090ULL,
0x00000018ff707819ULL, 0x000fe40000011416ULL, 0x0000001500737306ULL, 0x0003e20000200c00ULL,
0x00000018ff287819ULL, 0x000fce0000011428ULL, 0x0000002900307306ULL, 0x0005e20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x00000028006e7306ULL, 0x0007e20000200c00ULL,
0x000001002a297824ULL, 0x004fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000003f003f7306ULL, 0x000ea20000200c00ULL, 0x000088802a287816ULL, 0x048fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002800317306ULL, 0x0007f00000200c00ULL, 0x00000029002c7306ULL, 0x0008620000200c00ULL,
0x000088802b287816ULL, 0x008fc400000000ffULL, 0x000054108a8a7816ULL, 0x004fca000000003fULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x000001002b297824ULL, 0x050fe200078e00ffULL,
0x0000003b14149232ULL, 0x082fe20000000000ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000003b16169232ULL, 0x000fe40000000000ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000003a15159232ULL, 0x080fe20000000000ULL, 0x00000018ff327819ULL, 0x000fe2000001142bULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000003a17179232ULL, 0x000fe20000000000ULL,
0x00005410312c7816ULL, 0x000fc4000000002cULL, 0x000054108c8b7816ULL, 0x004fc8000000003eULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000088140c723cULL, 0x040fee000000180cULL,
0x0000003800387306ULL, 0x000e620000200c00ULL, 0x0000008a1408723cULL, 0x040fee0000001808ULL,
0x0000003900397306ULL, 0x000ea20000200c00ULL, 0x0000008e1404723cULL, 0x000fee0000001804ULL,
0x0000007000707306ULL, 0x000ee20000200c00ULL, 0x000054106e387816ULL, 0x002fce0000000038ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541030397816ULL, 0x004fce0000000039ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541073707816ULL, 0x008fe20000000070ULL,
0x00000038141c723cULL, 0x000fec000000181cULL, 0x00000028002d7306ULL, 0x0005f00000200c00ULL,
0x00000029002f7306ULL, 0x0007220000200c00ULL, 0x0000541072287816ULL, 0x004fc4000000003cULL,
0x0000541071717816ULL, 0x002fca0000000074ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000541091297816ULL, 0x008fe2000000003dULL, 0x000000701418723cULL, 0x000fec0000001818ULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x000054102d2d7816ULL, 0x010fce000000002fULL,
0x0000002a002e7306ULL, 0x0002a20000200c00ULL, 0x0000002c1420723cULL, 0x040fee0000001820ULL,
0x0000003200327306ULL, 0x000ee20000200c00ULL, 0x000000281428723cULL, 0x002fe20000001810ULL,
0x000054102e367816ULL, 0x004fc40000000036ULL, 0x0000541032377816ULL, 0x008fce0000000037ULL,
0x000000361414723cULL, 0x000fe20000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff107f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff2e7819ULL, 0x000fe20000011665ULL,
0x000058006b697a24ULL, 0x020fe200078e02ffULL, 0x0000008063107811ULL, 0x000fc400078e40ffULL,
0x000000022e2c7810ULL, 0x000fe20007ffe0ffULL, 0x000000015f687824ULL, 0x000fe200078e022eULL,
0x0000001064117217ULL, 0x000fe20007800000ULL, 0x0000008069697824ULL, 0x000fe400078e00ffULL,
0x00000080672f7824ULL, 0x000fe400078e0268ULL, 0x0000000111117824ULL, 0x000fc600078e0a10ULL,
0x000000692f2d7210ULL, 0x000fe40007f5e0ffULL, 0x0000002011117807ULL, 0x000fe40000000000ULL,
0x000000042f257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00005e002d277a11ULL, 0x000fe400078440ffULL, 0x000000022f137810ULL, 0x000fe40007ffe0ffULL,
0x000000115f117217ULL, 0x000fc40007800000ULL, 0x0000006925257210ULL, 0x080fe40007f9e0ffULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4410ULL, 0x0000000111267824ULL, 0x000fe200078e0a5fULL,
0x0000006913137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e0025247a11ULL, 0x000fe400078840ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000262c00720cULL, 0x000fc40003f46070ULL,
0x00005f0025257a11ULL, 0x000fe400020f4410ULL, 0x000000062f2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000005827107210ULL, 0x080fe40007fbe0ffULL, 0x00005f0013137a11ULL, 0x000fe400018f4411ULL,
0x000000692c2c7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e062dULL,
0x0000005812127210ULL, 0x000fc40007fde0ffULL, 0x0000005824247210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200020e06ffULL, 0x000000042e2f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000262e00720cULL, 0x0c0fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x000000062e2e7810ULL, 0x000fe40007ffe0ffULL,
0x00005e002c277a11ULL, 0x000fe400078840ffULL, 0x000000262f00720cULL, 0x000fc40003fc6070ULL,
0x000000262e00720cULL, 0x000fe40003fa6070ULL, 0x00005f002c2c7a11ULL, 0x000fe400020f442dULL,
0x0000005827267210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010487faeULL, 0x0003e8000d901c46ULL, 0x000000ffff277224ULL, 0x000fe200020e062cULL,
0x0000000012477faeULL, 0x0005e8000d101c46ULL, 0x0000000024467faeULL, 0x0005e8000f101c46ULL,
0x0000000026457faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007844835ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe400078e0031ULL, 0x000000015f6a7824ULL, 0x000fe200078e022eULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002e4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x008fe40003800000ULL, 0x0106b400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff377819ULL, 0x000fe40000011665ULL,
0x0000541010107816ULL, 0x000fe20000000010ULL, 0x000102e27f007947ULL, 0x000fea000b800000ULL,
0x00001f37103a7589ULL, 0x0002e400000e0000ULL, 0x000103327f007947ULL, 0x000fea000b800000ULL,
0x00001f5110397589ULL, 0x00086400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0010ULL, 0x0000686000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x002fe400078e0050ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fc400078e00ffULL, 0x0001114000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x000068d000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fc400078e004fULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000110d000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000432c783bULL, 0x000f680000004200ULL, 0x000000004224783bULL, 0x004fe80000004200ULL,
0x000000004434783bULL, 0x002e680000004200ULL, 0x000000004110783bULL, 0x010ea20000004200ULL,
0x00000018ff6f7819ULL, 0x020fe2000001142dULL, 0x000001002d7f7824ULL, 0x040fe200078e00ffULL,
0x000088802d7e7816ULL, 0x040fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001142cULL, 0x000001002c7d7824ULL, 0x040fe200078e00ffULL,
0x000088802c7c7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000007e00807306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe2000001142eULL, 0x0000010034757824ULL, 0x042fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x00000100258a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001142fULL, 0x0000010035777824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe20000011425ULL, 0x0000002d00817306ULL, 0x0003e20000200c00ULL,
0x0000888034747816ULL, 0x000fe200000000ffULL, 0x00000100377b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0000010036797824ULL, 0x000fe200078e00ffULL,
0x0000888035767816ULL, 0x000fc400000000ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000002c007e7306ULL, 0x0009e20000200c00ULL, 0x000001002e2d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011434ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe40000011424ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000088802e2c7816ULL, 0x050fe200000000ffULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002d00837306ULL, 0x0003e20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe40000011426ULL,
0x00000018ff737819ULL, 0x000fe20000011435ULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011427ULL, 0x00000018ff717819ULL, 0x000fe20000011437ULL,
0x0000002c00827306ULL, 0x0009620000200c00ULL, 0x000001002f2d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fc40000011435ULL, 0x00008880377a7816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002e00847306ULL, 0x0003e20000200c00ULL, 0x000088802f2c7816ULL, 0x050fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011436ULL,
0x0000888036787816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002d00867306ULL, 0x0009e20000200c00ULL,
0x00008880252e7816ULL, 0x042fe200000000ffULL, 0x0001000025257824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fc40000011437ULL, 0x00000018ff797819ULL, 0x000fe40000011479ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002c00857306ULL, 0x0002e20000200c00ULL,
0x00000100242d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002f00877306ULL, 0x000fe20000200c00ULL, 0x00008880242c7816ULL, 0x042fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002c00887306ULL, 0x0003e20000200c00ULL, 0x00000018ff387819ULL, 0x004fe40000011411ULL,
0x00000018ff337819ULL, 0x000fe40000011410ULL, 0x0000541082827816ULL, 0x020fe40000000083ULL,
0x0000541085837816ULL, 0x008fe20000000086ULL, 0x0000002d00897306ULL, 0x0004e20000200c00ULL,
0x0000a800402c7811ULL, 0x002fc400078e20ffULL, 0x00000018ff327819ULL, 0x000fe40000011413ULL,
0x00000018ff317819ULL, 0x000fc60000011412ULL, 0x00000025008d7306ULL, 0x0003e20000200c00ULL,
0x000000ffff2d7224ULL, 0x004fce00078e002eULL, 0x0000002d008b7306ULL, 0x0005e20000200c00ULL,
0x0000010026257824ULL, 0x002fe200078e00ffULL, 0x0000541088887816ULL, 0x008fc80000000089ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000000002c2c783bULL, 0x004eae0000000200ULL, 0x0000007600767306ULL, 0x000ff00000200c00ULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x0000541074747816ULL, 0x002fce0000000075ULL,
0x0000008a008c7306ULL, 0x000e700000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541076757816ULL, 0x008fce0000000077ULL, 0x0000003400347306ULL, 0x000ee20000200c00ULL,
0x0000003a2c2c9232ULL, 0x084fe20000000000ULL, 0x000054108b897816ULL, 0x002fe2000000008cULL,
0x0000003a2e2e9232ULL, 0x000fe40000000000ULL, 0x000000392d2d9232ULL, 0x080fe40000000000ULL,
0x000000392f2f9232ULL, 0x000fe20000000000ULL, 0x00000024008a7306ULL, 0x0003ec0000200c00ULL,
0x000000742c0c723cULL, 0x000fe4000000180cULL, 0x00000025008f7306ULL, 0x0005e20000200c00ULL,
0x0000888026247816ULL, 0x042fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x0000541034727816ULL, 0x008fc60000000072ULL, 0x000000822c20723cULL, 0x000fe20000001820ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x00000024008e7306ULL, 0x0002e20000200c00ULL,
0x0000010027257824ULL, 0x004fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002600907306ULL, 0x0005e20000200c00ULL, 0x0000888027247816ULL, 0x042fe200000000ffULL,
0x0001000027277824ULL, 0x000fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000002400917306ULL, 0x0003e20000200c00ULL, 0x0000010010267824ULL, 0x004fe200078e00ffULL,
0x000054108e8e7816ULL, 0x008fc8000000008fULL, 0x00000018ff347819ULL, 0x000fe40000011426ULL,
0x0000002500927306ULL, 0x0004e20000200c00ULL, 0x0000a80003247811ULL, 0x002fce00078e20ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000888010257816ULL, 0x044fe200000000ffULL,
0x0001000010107824ULL, 0x000fca00078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000003500357306ULL, 0x000e620000200c00ULL, 0x00005410918f7816ULL, 0x008fce0000000092ULL,
0x0000002700937306ULL, 0x000ff00000200c00ULL, 0x0000002500747306ULL, 0x0005e20000200c00ULL,
0x0000541035737816ULL, 0x002fe40000000073ULL, 0x0000888011357816ULL, 0x000fca00000000ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000002424783bULL, 0x004e620000000200ULL,
0x000000722c08723cULL, 0x000fec0000001808ULL, 0x0000003700377306ULL, 0x000ea20000200c00ULL,
0x0000010011727824ULL, 0x040fe400078e00ffULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fce0000011411ULL, 0x0000007900797306ULL, 0x000ee20000200c00ULL,
0x0000541037717816ULL, 0x004fce0000000071ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x0000541078787816ULL, 0x008fe20000000079ULL,
0x0000003a24249232ULL, 0x002fc40000000000ULL, 0x0000003a26269232ULL, 0x000fe40000000000ULL,
0x0000003925259232ULL, 0x080fe40000000000ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000003927279232ULL, 0x000fce0000000000ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x000054107c7c7816ULL, 0x004fe2000000007dULL, 0x00000088240c723cULL, 0x000fec000000180cULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054107e6e7816ULL, 0x002fce000000006eULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00005410816f7816ULL, 0x004fce000000006fULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x0000541084847816ULL, 0x008fe2000000003fULL, 0x0000006e2c1c723cULL, 0x000fec000000181cULL,
0x0000007b007b7306ULL, 0x000ea20000200c00ULL, 0x0000541087857816ULL, 0x002fce000000006dULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0x000000842c14723cULL, 0x000fee0000001814ULL,
0x0000007f007f7306ULL, 0x000ee20000200c00ULL, 0x000054107a797816ULL, 0x004fce000000007bULL,
0x0000001100377306ULL, 0x0005e20000200c00ULL, 0x0000541036707816ULL, 0x002fe20000000070ULL,
0x000000782c04723cULL, 0x000fe20000001804ULL, 0x00005410807d7816ULL, 0x008fe2000000007fULL,
0x0000010012117824ULL, 0x004fc800078e00ffULL, 0x0000001000367306ULL, 0x0003e40000200c00ULL,
0x000000702c28723cULL, 0x000fe20000001828ULL, 0x00000018ff117819ULL, 0x000fca0000011411ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000888012107816ULL, 0x042fe200000000ffULL,
0x0000007c2c18723cULL, 0x000fe20000001818ULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x00000010003a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000008e2404723cULL, 0x000fec0000001804ULL, 0x00000011002c7306ULL, 0x0007220000200c00ULL,
0x0000888013107816ULL, 0x002fe400000000ffULL, 0x000054108a3e7816ULL, 0x004fca000000003eULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000010013117824ULL, 0x048fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff397819ULL, 0x000fe20000011413ULL, 0x0000003b003b7306ULL, 0x000fe20000200c00ULL,
0x000054103a2c7816ULL, 0x010fe4000000002cULL, 0x000054108d3f7816ULL, 0x002fca000000003dULL,
0x0000003c003c7306ULL, 0x000fe40000200c00ULL, 0x0000003e2408723cULL, 0x000fec0000001808ULL,
0x0000003300337306ULL, 0x000e700000200c00ULL, 0x0000003800387306ULL, 0x000eb00000200c00ULL,
0x0000003400347306ULL, 0x000ee20000200c00ULL, 0x0000541036367816ULL, 0x002fce0000000033ULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0000541037377816ULL, 0x004fce0000000038ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541074347816ULL, 0x008fe20000000034ULL,
0x00000036241c723cULL, 0x000fec000000181cULL, 0x00000010002d7306ULL, 0x0005f00000200c00ULL,
0x00000011002f7306ULL, 0x0007220000200c00ULL, 0x0000541090107816ULL, 0x004fc4000000003bULL,
0x0000541035357816ULL, 0x002fca0000000072ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x0000541093117816ULL, 0x008fe2000000003cULL, 0x000000342418723cULL, 0x000fec0000001818ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x000054102d2d7816ULL, 0x010fce000000002fULL,
0x00000012002e7306ULL, 0x0002a20000200c00ULL, 0x0000002c2420723cULL, 0x040fee0000001820ULL,
0x0000003900397306ULL, 0x000ee20000200c00ULL, 0x000000102410723cULL, 0x002fe20000001828ULL,
0x000054102e2e7816ULL, 0x004fc40000000031ULL, 0x00005410392f7816ULL, 0x008fce0000000032ULL,
0x0000002e2424723cULL, 0x000fe20000001814ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008063147811ULL, 0x002fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000146400720cULL, 0x000fe20003f24070ULL,
0x000000ffff147224ULL, 0x000fd800078e0015ULL, 0x000064d000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007824814ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff157424ULL, 0x000fc800078e00ffULL,
0x0000001500167305ULL, 0x0002a4000021f000ULL, 0x3fa0000015157823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff317819ULL, 0x000fe40000011665ULL, 0x0000002067287811ULL, 0x000fe400078e38ffULL,
0x000000a063157811ULL, 0x000fe400078e40ffULL, 0x0000003128147210ULL, 0x000fe40007ffe05fULL,
0x0000001564167217ULL, 0x000fe40007800000ULL, 0x0000001469147210ULL, 0x000fc40007f3e0ffULL,
0x0000000231347810ULL, 0x040fe20007ffe0ffULL, 0x0000000116177824ULL, 0x000fe200078e0a15ULL,
0x0000000631327810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e06ffULL,
0x00005e00142e7a11ULL, 0x000fe400078240ffULL, 0x0000003428167210ULL, 0x000fe40007ffe05fULL,
0x00005f00142f7a11ULL, 0x000fe400008f442fULL, 0x0000000431337810ULL, 0x000fc40007ffe0ffULL,
0x0000003228147210ULL, 0x140fe40007ffe05fULL, 0x00000016692d7210ULL, 0x040fe40007f3e0ffULL,
0x0000003328157210ULL, 0x000fe40007ffe05fULL, 0x0000001469147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200008e06ffULL, 0x0000002017177807ULL, 0x000fe40000000000ULL,
0x0000001569157210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x000000175f177217ULL, 0x000fc40007800000ULL, 0x00005e002d167a11ULL, 0x040fe200078240ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e00142a7a11ULL, 0x040fe400078640ffULL,
0x00005f002d2d7a11ULL, 0x000fe200008f4429ULL, 0x0000000117297824ULL, 0x000fe200078e0a5fULL,
0x00005e0015287a11ULL, 0x000fe400078440ffULL, 0x00005f00142b7a11ULL, 0x000fe400018f442bULL,
0x000000582e147210ULL, 0x000fc40007f7e0ffULL, 0x0000005816167210ULL, 0x080fe40007f9e0ffULL,
0x00005f00152c7a11ULL, 0x000fe200010f442cULL, 0x000000ffff157224ULL, 0x000fe200018e062fULL,
0x000000293100720cULL, 0x080fe20003f46070ULL, 0x000000ffff177224ULL, 0x000fe200020e062dULL,
0x0000005828287210ULL, 0x000fe40007fbe0ffULL, 0x000000293400720cULL, 0x080fe40003f26070ULL,
0x000000293300720cULL, 0x000fc40003f66070ULL, 0x000000293200720cULL, 0x000fe20003f86070ULL,
0x000000ffff297224ULL, 0x000fe200028e062cULL, 0x000000582a2a7210ULL, 0x000fc60007fbe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e4000d101c46ULL,
0x000000ffff2b7224ULL, 0x000fe400028e062bULL, 0x0000000016567faeULL, 0x0005e8000c901c46ULL,
0x0000000028557faeULL, 0x0005e8000d901c46ULL, 0x000000002a547faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff6e7f8cULL, 0x000e68000c80043fULL, 0x0106ac00ff167984ULL, 0x004ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648005f147f8cULL, 0x000fe2000c80043fULL, 0x8000000016ff7812ULL, 0x004fc60007844830ULL,
0x01064c005f177984ULL, 0x000ea40000000800ULL, 0x8000000017ff7812ULL, 0x004fe40007824815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff167424ULL, 0x000fc800078e00ffULL,
0x0000001600177305ULL, 0x0004e4000021f000ULL, 0x3fa0000016167823ULL, 0x004fe200000100ffULL,
0x000000170000735dULL, 0x008fe40003800000ULL, 0x01064c005f177984ULL, 0x000ea40000000800ULL,
0x8000000017ff7812ULL, 0x004fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000053167984ULL, 0x000ea80000000800ULL, 0x0103000053177984ULL, 0x0007220000000800ULL,
0x0000005e1600720bULL, 0x004fe20003f3d000ULL, 0x0000ed127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800008e0100ULL, 0x0000ffff14297812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3e7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000026600780cULL, 0x000fe40003f65270ULL,
0x0000005e1600720bULL, 0x000fe20003f34000ULL, 0x0000ecf27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000165e157209ULL, 0x000fe40007810000ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff317819ULL, 0x000fe20000011665ULL,
0x800000155e287221ULL, 0x000fe20000010000ULL, 0x010500155300b388ULL, 0x0005e20000000800ULL,
0x0000001429ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b28287820ULL, 0x000fcc0000410000ULL,
0x0000002800287308ULL, 0x000ee40000000800ULL, 0x000000285d5d7220ULL, 0x008fe20000410000ULL,
0x0000eca27f007947ULL, 0x000fea000b800000ULL, 0x00001f3128317589ULL, 0x0044e400000e0000ULL,
0x000000310c0c7220ULL, 0x08cfe40000410000ULL, 0x000000310d0d7220ULL, 0x080fe40000410000ULL,
0x0000003108087220ULL, 0x080fe40000410000ULL, 0x0000003109097220ULL, 0x080fe40000410000ULL,
0x0000003104047220ULL, 0x000fc40000410000ULL, 0x0000003105057220ULL, 0x080fe40000410000ULL,
0x0000003110107220ULL, 0x080fe40000410000ULL, 0x0000003111117220ULL, 0x080fe40000410000ULL,
0x0000003118187220ULL, 0x080fe40000410000ULL, 0x0000003119197220ULL, 0x080fe40000410000ULL,
0x000000311c1c7220ULL, 0x000fc40000410000ULL, 0x000000311d1d7220ULL, 0x080fe40000410000ULL,
0x0000003120207220ULL, 0x080fe40000410000ULL, 0x0000003121217220ULL, 0x080fe40000410000ULL,
0x0000003124247220ULL, 0x080fe40000410000ULL, 0x0000003125257220ULL, 0x000fe20000410000ULL,
0x0000ebf27f007947ULL, 0x000fea000b800000ULL, 0x00001f5128317589ULL, 0x0004e400000e0000ULL,
0x000000165e5e7209ULL, 0x000fe20007810000ULL, 0x000000310e0e7220ULL, 0x08cfe20000410000ULL,
0x00000001ff3e7807ULL, 0x000fe20000800000ULL, 0x000000310f0f7220ULL, 0x000fc40000410000ULL,
0x8000005e16161221ULL, 0x000fe40000010000ULL, 0x000000310a0a7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b16161820ULL, 0x000fe40000410000ULL, 0x000000310b0b7220ULL, 0x080fe40000410000ULL,
0x0000001600521308ULL, 0x000ea20000000800ULL, 0x0000003106067220ULL, 0x080fe40000410000ULL,
0x0000003107077220ULL, 0x000fc40000410000ULL, 0x0000003112127220ULL, 0x080fe40000410000ULL,
0x0000003113137220ULL, 0x080fe40000410000ULL, 0x000000311a1a7220ULL, 0x080fe40000410000ULL,
0x000000311b1b7220ULL, 0x080fe40000410000ULL, 0x000000311e1e7220ULL, 0x080fe40000410000ULL,
0x000000311f1f7220ULL, 0x000fc40000410000ULL, 0x0000003122227220ULL, 0x080fe40000410000ULL,
0x0000003123237220ULL, 0x080fe40000410000ULL, 0x0000003126267220ULL, 0x080fe40000410000ULL,
0x0000003127277220ULL, 0x000fe40000410000ULL, 0x0000001752171220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000005d175d7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fc40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x0004e4000021f000ULL,
0x3fa0000014147823ULL, 0x004fe200000100ffULL, 0x000000150000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007824830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff14723eULL, 0x000fe400000000ffULL,
0x00000002ff377819ULL, 0x000fc40000011665ULL, 0x0000541014147816ULL, 0x000fe20000000014ULL,
0x0000e9a27f007947ULL, 0x000fea000b800000ULL, 0x00001f37143d7589ULL, 0x0004e400000e0000ULL,
0x0000e9f27f007947ULL, 0x000fea000b800000ULL, 0x00001f51143c7589ULL, 0x0008a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0014ULL,
0x0000843000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x004fe400078e0050ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000f57000007944ULL, 0x01afea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0014ULL, 0x000084a000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x004fe400078e004fULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000f50000007944ULL, 0x01afea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004e30783bULL, 0x004ea20000004200ULL,
0x000099103e3e7816ULL, 0x000fc600000000ffULL, 0x000000004d28783bULL, 0x000f620000004200ULL,
0x000000ff3e00720cULL, 0x000fc60003f25270ULL, 0x000000004c2c783bULL, 0x000f280000004200ULL,
0x000000004b14783bULL, 0x010f220000004200ULL, 0x0000010030777824ULL, 0x044fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe20000011430ULL, 0x0001000030787824ULL, 0x040fe200078e00ffULL,
0x00008880303f7816ULL, 0x000fe400000000ffULL, 0x00000018ff777819ULL, 0x000fc40000011477ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fe40000011431ULL, 0x00000018ff357819ULL, 0x020fe40000011429ULL,
0x00000018ff347819ULL, 0x000fe40000011428ULL, 0x00000018ff387819ULL, 0x000fe2000001142aULL,
0x0000007700307306ULL, 0x0005e20000200c00ULL, 0x00000018ff397819ULL, 0x000fc4000001142bULL,
0x00000018ff757819ULL, 0x000fe4000001142cULL, 0x00000018ff767819ULL, 0x000fe4000001142dULL,
0x00000018ff737819ULL, 0x000fe2000001142eULL, 0x0000007800797306ULL, 0x000be20000200c00ULL,
0x0000888031777816ULL, 0x004fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe4000001142fULL,
0x00000018ff367819ULL, 0x000fc40000011432ULL, 0x00000018ff377819ULL, 0x000fe20000011433ULL,
0x00000077007a7306ULL, 0x0005e20000200c00ULL, 0x0000010031787824ULL, 0x060fe200078e00ffULL,
0x00000018ff717819ULL, 0x010fe40000011414ULL, 0x00000018ff727819ULL, 0x000fe40000011415ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000003f003f7306ULL, 0x000f220000200c00ULL,
0x0001000031777824ULL, 0x004fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc40000011416ULL,
0x00000018ff707819ULL, 0x000fe40000011417ULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000007800317306ULL, 0x0005700000200c00ULL, 0x00000077007b7306ULL, 0x0007e20000200c00ULL,
0x0000888032787816ULL, 0x004fc400000000ffULL, 0x000054103f307816ULL, 0x010fca0000000030ULL,
0x0000003b003b7306ULL, 0x000fe20000200c00ULL, 0x000000ffff777224ULL, 0x008fe200078e0078ULL,
0x000054107a317816ULL, 0x020fe20000000031ULL, 0x0000010032787824ULL, 0x040fe400078e00ffULL,
0x0001000032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00000077007c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff327819ULL, 0x000fce0000011432ULL,
0x00000078007d7306ULL, 0x0007220000200c00ULL, 0x0000888033777816ULL, 0x004fce00000000ffULL,
0x00000077007e7306ULL, 0x0005e20000200c00ULL, 0x0000010033787824ULL, 0x048fe400078e00ffULL,
0x0001000033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0000888028777816ULL, 0x004fe400000000ffULL, 0x000054107c7c7816ULL, 0x010fca000000007dULL,
0x00000078007f7306ULL, 0x0004f00000200c00ULL, 0x0000007700807306ULL, 0x0009e20000200c00ULL,
0x0000010028787824ULL, 0x044fe400078e00ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x0000888029777816ULL, 0x010fe400000000ffULL,
0x000054107e7d7816ULL, 0x008fca000000007fULL, 0x0000007800817306ULL, 0x0005f00000200c00ULL,
0x0000002800827306ULL, 0x0007e20000200c00ULL, 0x0000010029787824ULL, 0x044fe400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000007700837306ULL, 0x0005e20000200c00ULL,
0x000088802a287816ULL, 0x008fce00000000ffULL, 0x0000002900857306ULL, 0x0007e20000200c00ULL,
0x000088802e777816ULL, 0x004fce00000000ffULL, 0x0000002800867306ULL, 0x0005e20000200c00ULL,
0x000001002a297824ULL, 0x048fe400078e00ffULL, 0x000100002a2a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000007800847306ULL, 0x000fe20000200c00ULL, 0x000088802b287816ULL, 0x004fce00000000ffULL,
0x0000002900877306ULL, 0x0005f00000200c00ULL, 0x0000002800897306ULL, 0x0007e20000200c00ULL,
0x000001002b297824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002a00887306ULL, 0x000fe20000200c00ULL, 0x000088802c287816ULL, 0x008fce00000000ffULL,
0x00000029008a7306ULL, 0x0005f00000200c00ULL, 0x00000028008c7306ULL, 0x0007e20000200c00ULL,
0x000001002c297824ULL, 0x044fe400078e00ffULL, 0x000100002c2c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b008b7306ULL, 0x000fe20000200c00ULL,
0x000088802d287816ULL, 0x008fe400000000ffULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x00000029008d7306ULL, 0x0004f00000200c00ULL, 0x00000028008f7306ULL, 0x0009e20000200c00ULL,
0x000001002d297824ULL, 0x044fe400078e00ffULL, 0x000100002d2d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002c008e7306ULL, 0x0005e20000200c00ULL,
0x0000b0004a287811ULL, 0x010fe400078e20ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x000054108c8c7816ULL, 0x008fc6000000008dULL, 0x0000002900907306ULL, 0x0007220000200c00ULL,
0x000001002e2c7824ULL, 0x044fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000002d00917306ULL, 0x0005e20000200c00ULL,
0x000000002828783bULL, 0x008ee20000000200ULL, 0x00000018ff2e7819ULL, 0x000fcc000001142eULL,
0x0000002c00787306ULL, 0x000be20000200c00ULL, 0x000088802f2d7816ULL, 0x004fe400000000ffULL,
0x000054108f8d7816ULL, 0x010fca0000000090ULL, 0x0000002e00927306ULL, 0x000fe20000200c00ULL,
0x000000ffff2c7224ULL, 0x020fe400078e002dULL, 0x000001002f2d7824ULL, 0x040fe400078e00ffULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x0000002c00937306ULL, 0x0005e20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff2f7819ULL, 0x000fca000001142fULL,
0x0000002d00947306ULL, 0x0009620000200c00ULL, 0x00008880142c7816ULL, 0x004fce00000000ffULL,
0x0000002c007a7306ULL, 0x0005e20000200c00ULL, 0x0000003d28289232ULL, 0x088fe20000000000ULL,
0x000054107b2d7816ULL, 0x010fe2000000003bULL, 0x0000003d2a2a9232ULL, 0x000fe20000000000ULL,
0x00005410893b7816ULL, 0x000fe2000000008aULL, 0x0000003c29299232ULL, 0x080fe40000000000ULL,
0x0000003c2b2b9232ULL, 0x000fe20000000000ULL, 0x0000002f00957306ULL, 0x0007e20000200c00ULL,
0x00005410792c7816ULL, 0x004fe4000000003aULL, 0x00005410863a7816ULL, 0x000fc40000000087ULL,
0x0000541093797816ULL, 0x020fe20000000094ULL, 0x00000030280c723cULL, 0x040fe4000000180cULL,
0x0000003200327306ULL, 0x000eaa0000200c00ULL, 0x0000b00049307811ULL, 0x000fe200078e20ffULL,
0x0000010014317824ULL, 0x040fe200078e00ffULL, 0x0000002c282c723cULL, 0x008fe20000001808ULL,
0x0000003300337306ULL, 0x000ee20000200c00ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x000000003008783bULL, 0x0009620000000200ULL, 0x00000018ff317819ULL, 0x000fc60000011431ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000007c2804723cULL, 0x000fe20000001804ULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x0000541032367816ULL, 0x004fe40000000036ULL,
0x0000888015307816ULL, 0x010fca00000000ffULL, 0x0000003500357306ULL, 0x000ea20000200c00ULL,
0x0000541033377816ULL, 0x008fce0000000037ULL, 0x00000031007b7306ULL, 0x0007e20000200c00ULL,
0x0000541082347816ULL, 0x002fe20000000034ULL, 0x000000362810723cULL, 0x000fec0000001810ULL,
0x00000030007c7306ULL, 0x0003e20000200c00ULL, 0x0000010015317824ULL, 0x008fe200078e00ffULL,
0x0000541085357816ULL, 0x004fe20000000035ULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x0000541080307816ULL, 0x002fe20000000081ULL, 0x000000342834723cULL, 0x000fe2000000181cULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000003d08089232ULL, 0x0a0fe40000000000ULL,
0x0000003d0a0a9232ULL, 0x000fe40000000000ULL, 0x00000031007d7306ULL, 0x0003e20000200c00ULL,
0x00000100171c7824ULL, 0x000fe200078e00ffULL, 0x0000003c09099232ULL, 0x000fc40000000000ULL,
0x0000003c0b0b9232ULL, 0x000fe40000000000ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000003900397306ULL, 0x000ee20000200c00ULL, 0x0000541083317816ULL, 0x002fe40000000084ULL,
0x00005410883e7816ULL, 0x004fe20000000038ULL, 0x0000008c080c723cULL, 0x000fe8000000180cULL,
0x0000007500757306ULL, 0x000fe80000200c00ULL, 0x000000302830723cULL, 0x000fe20000001818ULL,
0x000054108b3f7816ULL, 0x008fc60000000039ULL, 0x0000007600767306ULL, 0x000fe60000200c00ULL,
0x0000888016187816ULL, 0x040fe200000000ffULL, 0x0000010016197824ULL, 0x040fe200078e00ffULL,
0x0000003a2838723cULL, 0x000fe20000001820ULL, 0x0001000016167824ULL, 0x000fe400078e00ffULL,
0x00000018007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x0000003e283c723cULL, 0x000fe20000001824ULL,
0x000054107a207816ULL, 0x000fe4000000007bULL, 0x000054107c217816ULL, 0x000fe2000000007dULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000888017187816ULL, 0x042fe200000000ffULL,
0x0001000017177824ULL, 0x000fc800078e00ffULL, 0x000000200820723cULL, 0x000fe20000001830ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000007400747306ULL, 0x000e700000200c00ULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00005410951d7816ULL, 0x002fce0000000074ULL, 0x0000007700777306ULL, 0x000e700000200c00ULL,
0x0000001400147306ULL, 0x000eb00000200c00ULL, 0x0000001500157306ULL, 0x000ee20000200c00ULL,
0x0000541077787816ULL, 0x002fce0000000078ULL, 0x0000001900287306ULL, 0x0003220000200c00ULL,
0x0000541014247816ULL, 0x004fe20000000071ULL, 0x000000780804723cULL, 0x000fec0000001804ULL,
0x0000001800297306ULL, 0x0005e20000200c00ULL, 0x0000541091197816ULL, 0x002fe40000000076ULL,
0x0000541015257816ULL, 0x008fca0000000072ULL, 0x0000001c002a7306ULL, 0x0002e20000200c00ULL,
0x000054108e187816ULL, 0x004fe20000000075ULL, 0x000000240824723cULL, 0x000fe20000001834ULL,
0x000054107e287816ULL, 0x010fca0000000028ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00005410921c7816ULL, 0x002fe20000000073ULL, 0x000000180818723cULL, 0x040fec000000182cULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541029297816ULL, 0x008fe2000000002aULL,
0x0000001c081c723cULL, 0x040fec0000001810ULL, 0x0000001600167306ULL, 0x000e640000200c00ULL,
0x000000280828723cULL, 0x000fec0000001838ULL, 0x0000001700177306ULL, 0x000ea20000200c00ULL,
0x0000541016167816ULL, 0x002fc4000000006dULL, 0x0000541017177816ULL, 0x004fce0000000070ULL,
0x000000160808723cULL, 0x000fe2000000183cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff107f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0002a4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004067157811ULL, 0x000fe400078e38ffULL,
0x000000c063107811ULL, 0x000fc400078e40ffULL, 0x00000004ff307819ULL, 0x000fe20000011665ULL,
0x00000001002d7824ULL, 0x100fe200078e0215ULL, 0x0000001064117217ULL, 0x000fe20007800000ULL,
0x00000001682f7824ULL, 0x100fe200078e0215ULL, 0x0000000230317810ULL, 0x000fe20007ffe0ffULL,
0x000000016a2c7824ULL, 0x100fe200078e0215ULL, 0x000000692d2d7210ULL, 0x080fe20007f7e0ffULL,
0x0000000111117824ULL, 0x000fe200078e0a10ULL, 0x000000692f2f7210ULL, 0x000fe20007f5e0ffULL,
0x000000016c6c7824ULL, 0x000fe400078e0215ULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e002d137a11ULL, 0x000fe200078640ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x00005e002f2e7a11ULL, 0x000fc400078440ffULL, 0x00005f002d2d7a11ULL, 0x000fe400018f4412ULL,
0x000000692c2c7210ULL, 0x080fe40007f7e0ffULL, 0x00005f002f2f7a11ULL, 0x000fe400010f4414ULL,
0x0000002011117807ULL, 0x000fe20000000000ULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x000000696c157210ULL, 0x000fe40007f5e0ffULL, 0x00005e002c177a11ULL, 0x000fc400078640ffULL,
0x000000115f117217ULL, 0x000fe20007800000ULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0015147a11ULL, 0x000fe400078440ffULL, 0x00005f002c2c7a11ULL, 0x000fe200018f4410ULL,
0x0000000111167824ULL, 0x000fe200078e0a5fULL, 0x000000582e107210ULL, 0x080fe40007f7e0ffULL,
0x00005f0015157a11ULL, 0x000fe400010f4412ULL, 0x0000005813127210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e062fULL, 0x0000005814147210ULL, 0x000fc40007fbe0ffULL,
0x00000004302e7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e062dULL,
0x000000163000720cULL, 0x0c0fe20003f66070ULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x0000000630307810ULL, 0x000fe40007ffe0ffULL, 0x000000163100720cULL, 0x080fe40003f46070ULL,
0x000000162e00720cULL, 0x080fe40003f86070ULL, 0x000000163000720cULL, 0x000fc40003fa6070ULL,
0x0000005817167210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010487faeULL, 0x0003e4000d901c46ULL, 0x000000ffff177224ULL, 0x000fe400030e062cULL,
0x0000000012477faeULL, 0x0005e8000d101c46ULL, 0x0000000014467faeULL, 0x0005e8000e101c46ULL,
0x0000000016457faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff307f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc4000784486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0031ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe4000784486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002e4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x008fe40003800000ULL,
0x0106b400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc4000784486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff10723eULL, 0x000fe400000000ffULL,
0x00000002ff377819ULL, 0x000fe40000011665ULL, 0x0000541010107816ULL, 0x000fe20000000010ULL,
0x0000d4927f007947ULL, 0x000fea000b800000ULL, 0x00001f37103a7589ULL, 0x0002e400000e0000ULL,
0x0000d4e27f007947ULL, 0x000fea000b800000ULL, 0x00001f5110397589ULL, 0x00086400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00009a3000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fe400078e0050ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fc400078e00ffULL,
0x0000df7000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0010ULL, 0x00009aa000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x002fc400078e004fULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000df0000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000000442c783bULL, 0x000f680000004200ULL,
0x000000004334783bULL, 0x002fe80000004200ULL, 0x000000004214783bULL, 0x004e680000004200ULL,
0x000000004110783bULL, 0x010ea20000004200ULL, 0x00000018ff717819ULL, 0x020fe2000001142cULL,
0x000001002c747824ULL, 0x040fe200078e00ffULL, 0x000088802c737816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802d757816ULL, 0x000fc400000000ffULL,
0x00000018ff727819ULL, 0x000fe2000001142dULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000010015897824ULL, 0x002fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001142eULL, 0x00000018ff3d7819ULL, 0x000fe40000011415ULL,
0x00000018ff707819ULL, 0x000fe2000001142fULL, 0x0000002c00767306ULL, 0x0003220000200c00ULL,
0x00000018ff3e7819ULL, 0x000fc40000011414ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff3b7819ULL, 0x000fe40000011416ULL, 0x00000018ff3c7819ULL, 0x000fe20000011417ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000000ffff2c7224ULL, 0x002fe200078e0075ULL,
0x00000018ff6d7819ULL, 0x000fe20000011434ULL, 0x000001002d757824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011435ULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fc40000011436ULL, 0x0000002c00777306ULL, 0x0003e20000200c00ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000541076767816ULL, 0x010fe40000000071ULL, 0x00000018ff6c7819ULL, 0x000fe20000011437ULL,
0x0000002d00787306ULL, 0x0009e20000200c00ULL, 0x000088802e2c7816ULL, 0x002fe400000000ffULL,
0x00000018ff337819ULL, 0x004fc40000011410ULL, 0x00000018ff387819ULL, 0x000fe40000011411ULL,
0x00000018ff317819ULL, 0x000fe20000011412ULL, 0x0000002c00797306ULL, 0x0003e20000200c00ULL,
0x000001002e2d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011413ULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x000088802f2c7816ULL, 0x002fce00000000ffULL,
0x0000002d007a7306ULL, 0x0003300000200c00ULL, 0x0000002c007b7306ULL, 0x000be20000200c00ULL,
0x000001002f2d7824ULL, 0x002fe200078e00ffULL, 0x0000541073747816ULL, 0x004fe20000000074ULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002e007c7306ULL, 0x0003e20000200c00ULL, 0x00008880342c7816ULL, 0x020fe400000000ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00005410797a7816ULL, 0x010fc6000000007aULL,
0x0000002d007d7306ULL, 0x0005220000200c00ULL, 0x00008880152e7816ULL, 0x042fe200000000ffULL,
0x0001000015157824ULL, 0x000fca00078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000002c007f7306ULL, 0x0003e20000200c00ULL, 0x00000100342d7824ULL, 0x044fe400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000015008c7306ULL, 0x0005e20000200c00ULL, 0x00008880352c7816ULL, 0x002fe400000000ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x000054107b7b7816ULL, 0x010fc6000000007dULL,
0x0000002d00807306ULL, 0x0003220000200c00ULL, 0x0000010016157824ULL, 0x004fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000002c00817306ULL, 0x0005e20000200c00ULL,
0x00000100352d7824ULL, 0x042fe400078e00ffULL, 0x0001000035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002f007e7306ULL, 0x000fe20000200c00ULL,
0x00008880362c7816ULL, 0x004fe400000000ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x000054107f807816ULL, 0x010fc60000000080ULL, 0x0000002d00827306ULL, 0x0002b00000200c00ULL,
0x0000002c00837306ULL, 0x0009e20000200c00ULL, 0x00000100362d7824ULL, 0x042fe400078e00ffULL,
0x0001000036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000015008e7306ULL, 0x0003e20000200c00ULL, 0x00008880372c7816ULL, 0x010fe400000000ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000541081817816ULL, 0x004fc60000000082ULL,
0x0000002d00847306ULL, 0x0005220000200c00ULL, 0x0000010017157824ULL, 0x002fca00078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000002c00857306ULL, 0x0003e20000200c00ULL,
0x00000100372d7824ULL, 0x044fe400078e00ffULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000001500917306ULL, 0x0005e20000200c00ULL,
0x00008880142c7816ULL, 0x002fe400000000ffULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000541083847816ULL, 0x010fc60000000084ULL, 0x0000002d00867306ULL, 0x0003220000200c00ULL,
0x0000888010157816ULL, 0x004fce00000000ffULL, 0x0000002c00877306ULL, 0x0005e20000200c00ULL,
0x00000100142d7824ULL, 0x042fe400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000001500737306ULL, 0x000fe20000200c00ULL, 0x0000b000402c7811ULL, 0x004fe400078e20ffULL,
0x0000541085857816ULL, 0x010fca0000000086ULL, 0x0000002d00887306ULL, 0x0002b00000200c00ULL,
0x00000014008a7306ULL, 0x0009e20000200c00ULL, 0x000000ffff2d7224ULL, 0x002fce00078e002eULL,
0x0000002d008b7306ULL, 0x0003e20000200c00ULL, 0x0000888016147816ULL, 0x050fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000541087887816ULL, 0x004fc80000000088ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x00000014008d7306ULL, 0x0005220000200c00ULL,
0x000000002c2c783bULL, 0x002e6e0000000200ULL, 0x0000001600907306ULL, 0x000be20000200c00ULL,
0x0000888017147816ULL, 0x044fe200000000ffULL, 0x0001000017177824ULL, 0x000fca00078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x00000014008f7306ULL, 0x0004e20000200c00ULL,
0x0000010010167824ULL, 0x060fe200078e00ffULL, 0x000054108d8e7816ULL, 0x010fe2000000008eULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff717819ULL, 0x000fe40000011416ULL,
0x0000001700927306ULL, 0x0009e20000200c00ULL, 0x0000b00003147811ULL, 0x004fe400078e20ffULL,
0x00000018ff107819ULL, 0x000fca0000011410ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x000000001414783bULL, 0x010f220000000200ULL, 0x000054108f8f7816ULL, 0x008fcc0000000091ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000003a2c2c9232ULL, 0x082fe40000000000ULL,
0x0000003a2e2e9232ULL, 0x000fe40000000000ULL, 0x000000392d2d9232ULL, 0x080fe40000000000ULL,
0x000000392f2f9232ULL, 0x000fe20000000000ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541077757816ULL, 0x004fca0000000075ULL, 0x0000007a2c04723cULL, 0x000fe40000001804ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x0000541078777816ULL, 0x008fe40000000072ULL,
0x0000888011727816ULL, 0x000fc600000000ffULL, 0x000000742c0c723cULL, 0x000fe4000000180cULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000054107c7c7816ULL, 0x002fc8000000006fULL,
0x0000010011747824ULL, 0x040fe200078e00ffULL, 0x000000762c18723cULL, 0x040fe20000001818ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000054107e7d7816ULL, 0x004fe20000000070ULL, 0x0000003915159232ULL, 0x090fe20000000000ULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000003917179232ULL, 0x000fe20000000000ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x000000802c20723cULL, 0x000fe20000001820ULL,
0x0000003a14149232ULL, 0x080fe20000000000ULL, 0x0000003400347306ULL, 0x000e620000200c00ULL,
0x0000003a16169232ULL, 0x000fca0000000000ULL, 0x0000007c2c1c723cULL, 0x040fe4000000181cULL,
0x0000003500357306ULL, 0x000eac0000200c00ULL, 0x000000842c28723cULL, 0x000fe40000001828ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000541034347816ULL, 0x002fca000000006dULL,
0x0000008e1404723cULL, 0x000fe40000001804ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x004fce000000006eULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x000000342c24723cULL, 0x000fee0000001824ULL, 0x0000003700377306ULL, 0x000eb00000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541036367816ULL, 0x002fce000000003fULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000541037377816ULL, 0x004fce000000006cULL,
0x000000362c2c723cULL, 0x000fe20000001808ULL, 0x0000003b003b7306ULL, 0x000eac0000200c00ULL,
0x0000888013087816ULL, 0x000fe400000000ffULL, 0x00000010006f7306ULL, 0x0007e20000200c00ULL,
0x000054108c097816ULL, 0x002fce000000003dULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000888012107816ULL, 0x008fce00000000ffULL, 0x0000000800397306ULL, 0x0003f00000200c00ULL,
0x0000001000357306ULL, 0x0007e20000200c00ULL, 0x000054108a087816ULL, 0x002fce000000003eULL,
0x0000001100347306ULL, 0x0003e20000200c00ULL, 0x0000010013107824ULL, 0x048fe200078e00ffULL,
0x000000081408723cULL, 0x000fe20000001818ULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000003300337306ULL, 0x000fe20000200c00ULL,
0x0000010012117824ULL, 0x042fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011413ULL,
0x0001000012127824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x00000018ff127819ULL, 0x000fce0000011412ULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000007400747306ULL, 0x000e700000200c00ULL, 0x00000010003a7306ULL, 0x0005f00000200c00ULL,
0x0000001100367306ULL, 0x0007e20000200c00ULL, 0x0000541090107816ULL, 0x004fc4000000003bULL,
0x0000541072197816ULL, 0x002fca0000000074ULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x0000541092117816ULL, 0x008fce000000003cULL, 0x0000003200327306ULL, 0x000ff00000200c00ULL,
0x0000008900897306ULL, 0x000e700000200c00ULL, 0x0000001200377306ULL, 0x0004f00000200c00ULL,
0x00000018003b7306ULL, 0x0009620000200c00ULL, 0x000000101410723cULL, 0x004fe2000000181cULL,
0x000054108b897816ULL, 0x002fcc0000000089ULL, 0x000054106f1c7816ULL, 0x000fe20000000033ULL,
0x00000088140c723cULL, 0x000fe2000000180cULL, 0x0000541073187816ULL, 0x010fe40000000071ULL,
0x00005410341d7816ULL, 0x000fca0000000038ULL, 0x000000181418723cULL, 0x040fee0000001820ULL,
0x0000541035207816ULL, 0x000fe20000000036ULL, 0x0000001c141c723cULL, 0x000fe20000001824ULL,
0x0000541039217816ULL, 0x000fcc000000003aULL, 0x0000541037247816ULL, 0x008fe20000000031ULL,
0x000000201420723cULL, 0x000fe20000001828ULL, 0x000054103b257816ULL, 0x020fce0000000032ULL,
0x000000241424723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c063147811ULL, 0x002fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000146400720cULL, 0x000fe20003f24070ULL,
0x000000ffff147224ULL, 0x000fd800078e0015ULL, 0x000032f000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007824814ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff157424ULL, 0x000fc800078e00ffULL,
0x0000001500167305ULL, 0x0002a4000021f000ULL, 0x3fa0000015157823ULL, 0x002fe200000100ffULL,
0x000000160000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff167984ULL, 0x000e640000000800ULL,
0x8000000016ff7812ULL, 0x002fc40007824814ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000159597824ULL, 0x000fe400078e0202ULL, 0x00000002ff027424ULL, 0x000fe400078e00ffULL,
0x00000001ff147424ULL, 0x000fe200078e00ffULL, 0x0000000159157812ULL, 0x000fe200078ec0ffULL,
0xffffffffff6b7424ULL, 0x000fe400078e00ffULL, 0x0000030002027a24ULL, 0x000fe200078e0a14ULL,
0x000000011500780cULL, 0x000fc80003f25070ULL, 0x0000000102027807ULL, 0x000fca0004800000ULL,
0x0000000159607824ULL, 0x000fca00078e0202ULL, 0x000000626000720cULL, 0x000fe40003f26070ULL,
0x000000e063027811ULL, 0x000fd600078e40ffULL, 0x0000000160149824ULL, 0x000fe400078e025bULL,
0x00000004ff159424ULL, 0x000fc800078e00ffULL, 0x0000600014149625ULL, 0x000fca00078e0015ULL,
0x00000006146b9981ULL, 0x000362000c1e1900ULL, 0x00000004652e7811ULL, 0x040fe400078fe0ffULL,
0x00000006652f7811ULL, 0x000fe400078fe0ffULL, 0x00000004ff317819ULL, 0x000fe40000011665ULL,
0x0000006067157811ULL, 0x002fe400078e38ffULL, 0x0000000264147217ULL, 0x000fe40007800000ULL,
0x0000002e15297210ULL, 0x000fe20007ffe05fULL, 0x00000001002b7824ULL, 0x000fc400078e0215ULL,
0x0000000114147824ULL, 0x000fe200078e0a02ULL, 0x0000002f15027210ULL, 0x000fe20007ffe05fULL,
0x00000001682d7824ULL, 0x000fe200078e0215ULL, 0x000000692b2b7210ULL, 0x080fe40007f5e0ffULL,
0x0000002014147807ULL, 0x000fe40000000000ULL, 0x000000692d2d7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x00005e002b177a11ULL, 0x000fe400078440ffULL,
0x000000145f147217ULL, 0x000fe20007800000ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x0000006929297210ULL, 0x000fc40007f7e0ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078240ffULL,
0x0000006902027210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005f002b2b7a11ULL, 0x000fe200010f4400ULL, 0x0000000114007824ULL, 0x000fe200078e0a5fULL,
0x0000000231147810ULL, 0x000fe40007ffe0ffULL, 0x00005f002d2d7a11ULL, 0x000fe200008f4415ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005e0029287a11ULL, 0x000fc400078040ffULL,
0x00005e00022a7a11ULL, 0x000fe400078240ffULL, 0x000000001400720cULL, 0x000fe40003f46070ULL,
0x00005f0029297a11ULL, 0x000fe400000f4416ULL, 0x000000582c147210ULL, 0x000fe40007f9e0ffULL,
0x000000003100720cULL, 0x000fe40003f66070ULL, 0x0000005817167210ULL, 0x000fc40007fbe0ffULL,
0x00005f0002027a11ULL, 0x000fe200008f4415ULL, 0x000000ffff157224ULL, 0x000fe200020e062dULL,
0x000000002e00720cULL, 0x080fe20003f26070ULL, 0x000000ffff177224ULL, 0x000fe200028e062bULL,
0x000000002f00720cULL, 0x000fe40003f06070ULL, 0x0000005828287210ULL, 0x080fe40007f9e0ffULL,
0x000000582a2a7210ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014577faeULL, 0x0003e4000d901c46ULL, 0x000000ffff297224ULL, 0x000fc400020e0629ULL,
0x000000ffff2b7224ULL, 0x000fe200028e0602ULL, 0x0000000016567faeULL, 0x0003e8000d101c46ULL,
0x0000000028557faeULL, 0x0003e8000c901c46ULL, 0x000000002a547faeULL, 0x0003e8000c101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff347f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010668005f147f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007804830ULL,
0x01066c005f027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe40007824815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x01066c005f027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fc40007824815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101800053007984ULL, 0x000e680000000800ULL, 0x0103800053027984ULL, 0x0007220000000800ULL,
0x0000005e0000720bULL, 0x002fe20003f3d000ULL, 0x0000bdd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800008e0100ULL, 0x0000ffff14167812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff547424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000036600780cULL, 0x000fe40003f45270ULL,
0x0000005e0000720bULL, 0x000fe20003f34000ULL, 0x0000bdb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x000fe400008e0100ULL, 0x000000005e177209ULL, 0x000fe40007810000ULL,
0x0000ffff14147812ULL, 0x000fe400078e3cffULL, 0x00000002ff317819ULL, 0x000fe20000011665ULL,
0x800000175e157221ULL, 0x000fe20000010000ULL, 0x010580175300a388ULL, 0x0003e20000000800ULL,
0x0000001416ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b15157820ULL, 0x000fcc0000410000ULL,
0x0000001500157308ULL, 0x000ee40000000800ULL, 0x000000155d5d7220ULL, 0x008fe20000410000ULL,
0x0000bd627f007947ULL, 0x000fea000b800000ULL, 0x00001f3115317589ULL, 0x0022e400000e0000ULL,
0x000000310c0c7220ULL, 0x08cfe40000410000ULL, 0x000000310d0d7220ULL, 0x080fe40000410000ULL,
0x0000003108087220ULL, 0x080fe40000410000ULL, 0x0000003109097220ULL, 0x080fe40000410000ULL,
0x0000003104047220ULL, 0x000fc40000410000ULL, 0x0000003105057220ULL, 0x080fe40000410000ULL,
0x0000003110107220ULL, 0x080fe40000410000ULL, 0x0000003111117220ULL, 0x080fe40000410000ULL,
0x0000003118187220ULL, 0x080fe40000410000ULL, 0x0000003119197220ULL, 0x080fe40000410000ULL,
0x000000311c1c7220ULL, 0x000fc40000410000ULL, 0x000000311d1d7220ULL, 0x080fe40000410000ULL,
0x0000003120207220ULL, 0x080fe40000410000ULL, 0x0000003121217220ULL, 0x080fe40000410000ULL,
0x0000003124247220ULL, 0x080fe40000410000ULL, 0x0000003125257220ULL, 0x000fe20000410000ULL,
0x0000bcb27f007947ULL, 0x000fea000b800000ULL, 0x00001f5115317589ULL, 0x0004e400000e0000ULL,
0x8000001700001221ULL, 0x000fe20000010000ULL, 0x00000001ff547807ULL, 0x000fe20000800000ULL,
0x000000310e0e7220ULL, 0x00cfc40000410000ULL, 0x3fb8aa3b00001820ULL, 0x000fe40000410000ULL,
0x000000310f0f7220ULL, 0x080fe40000410000ULL, 0x0000000000521308ULL, 0x000ea20000000800ULL,
0x000000310a0a7220ULL, 0x080fe40000410000ULL, 0x000000310b0b7220ULL, 0x080fe40000410000ULL,
0x0000003106067220ULL, 0x080fe40000410000ULL, 0x0000003107077220ULL, 0x000fc40000410000ULL,
0x0000003112127220ULL, 0x080fe40000410000ULL, 0x0000003113137220ULL, 0x080fe40000410000ULL,
0x000000311a1a7220ULL, 0x080fe40000410000ULL, 0x000000311b1b7220ULL, 0x080fe40000410000ULL,
0x000000311e1e7220ULL, 0x080fe40000410000ULL, 0x000000311f1f7220ULL, 0x000fc40000410000ULL,
0x0000003122227220ULL, 0x080fe40000410000ULL, 0x0000003123237220ULL, 0x080fe40000410000ULL,
0x0000003126267220ULL, 0x080fe40000410000ULL, 0x0000003127277220ULL, 0x000fe40000410000ULL,
0x000000ffff5e7224ULL, 0x000fe400078e0017ULL, 0x0000000252021220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000005d025d7221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007804830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000027305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000020000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff027984ULL, 0x000ee40000000800ULL, 0x8000000002ff7812ULL, 0x008fe40007804830ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000052ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff377819ULL, 0x000fc40000011665ULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x0000ba627f007947ULL, 0x000fea000b800000ULL, 0x00001f37003d7589ULL, 0x00072400000e0000ULL,
0x0000bab27f007947ULL, 0x000fea000b800000ULL, 0x00001f51003c7589ULL, 0x0002e400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x0000b6f000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x008fe400078e0050ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000c2b000007944ULL, 0x036fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x0000b76000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x008fe400078e004fULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000c24000007944ULL, 0x036fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004e28783bULL, 0x000e620000004200ULL,
0x0000b80049497811ULL, 0x000fc600078e20ffULL, 0x000000004d2c783bULL, 0x000f280000004200ULL,
0x000000004c30783bULL, 0x004ea80000004200ULL, 0x000000004b14783bULL, 0x0024620000004200ULL,
0x00000018ff007819ULL, 0x008fe20000011428ULL, 0x0000010029597824ULL, 0x040fe200078e00ffULL,
0x0000888029577816ULL, 0x000fe200000000ffULL, 0x0000010028557824ULL, 0x040fe200078e00ffULL,
0x0000000000567306ULL, 0x0007e20000200c00ULL, 0x0000888028537816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001142aULL,
0x00000018ff3b7819ULL, 0x000fe4000001142bULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000005700687306ULL, 0x000fe20000200c00ULL, 0x00000018ff007819ULL, 0x008fe20000011429ULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x010fe4000001142dULL,
0x00000018ff4d7819ULL, 0x000fe4000001142eULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000002800577306ULL, 0x0007e20000200c00ULL, 0x00000018ff557819ULL, 0x000fc40000011455ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff387819ULL, 0x000fe4000001142cULL,
0x00000018ff4e7819ULL, 0x000fe2000001142fULL, 0x00000029006c7306ULL, 0x0009e20000200c00ULL,
0x000088802a287816ULL, 0x008fe400000000ffULL, 0x00000018ff4b7819ULL, 0x004fe40000011430ULL,
0x00000018ff4c7819ULL, 0x000fc40000011431ULL, 0x00000018ff3e7819ULL, 0x000fe20000011432ULL,
0x00000028006d7306ULL, 0x0005e20000200c00ULL, 0x000001002a297824ULL, 0x050fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe20000011433ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x002fe40000011414ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000088802b287816ULL, 0x004fc400000000ffULL, 0x00000018ff377819ULL, 0x000fe40000011415ULL,
0x00000018ff027819ULL, 0x000fc60000011417ULL, 0x00000029006e7306ULL, 0x0003f00000200c00ULL,
0x0000002800707306ULL, 0x0005e20000200c00ULL, 0x000001002b297824ULL, 0x042fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x0000002a006f7306ULL, 0x000fe20000200c00ULL,
0x000088802c287816ULL, 0x004fce00000000ffULL, 0x0000002900717306ULL, 0x0003f00000200c00ULL,
0x0000002800737306ULL, 0x0005e20000200c00ULL, 0x000001002c297824ULL, 0x042fe400078e00ffULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002b00727306ULL, 0x000fe20000200c00ULL, 0x000088802d287816ULL, 0x004fe400000000ffULL,
0x00000018ff2c7819ULL, 0x000fca000001142cULL, 0x0000002900747306ULL, 0x0002b00000200c00ULL,
0x0000002800757306ULL, 0x0007e20000200c00ULL, 0x000001002d297824ULL, 0x042fe400078e00ffULL,
0x000100002d2d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x000088802e287816ULL, 0x008fe400000000ffULL, 0x0000541073747816ULL, 0x004fca0000000074ULL,
0x0000002900777306ULL, 0x0002b00000200c00ULL, 0x0000002800797306ULL, 0x0007e20000200c00ULL,
0x000001002e297824ULL, 0x042fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000002d00787306ULL, 0x0003e20000200c00ULL, 0x000088802f287816ULL, 0x008fe400000000ffULL,
0x0000541075757816ULL, 0x004fca0000000077ULL, 0x00000029007a7306ULL, 0x0004e20000200c00ULL,
0x00000100322d7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000028007b7306ULL, 0x0003e20000200c00ULL, 0x000001002f297824ULL, 0x044fe400078e00ffULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002e007c7306ULL, 0x0005e20000200c00ULL, 0x0000888030287816ULL, 0x002fe400000000ffULL,
0x00000018ff2f7819ULL, 0x000fe4000001142fULL, 0x00005410797a7816ULL, 0x008fc6000000007aULL,
0x00000029007d7306ULL, 0x0002e20000200c00ULL, 0x00009910542e7816ULL, 0x004fc800000000ffULL,
0x000000ff2e00720cULL, 0x000fe40003f05270ULL, 0x00008880142e7816ULL, 0x000fe200000000ffULL,
0x00000028007f7306ULL, 0x0005e20000200c00ULL, 0x0000010030297824ULL, 0x042fe400078e00ffULL,
0x0001000030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x0000888031287816ULL, 0x004fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x000054107b7b7816ULL, 0x008fc6000000007dULL,
0x0000002900807306ULL, 0x0005f00000200c00ULL, 0x0000002800817306ULL, 0x0007e20000200c00ULL,
0x0000010031297824ULL, 0x044fe400078e00ffULL, 0x0001000031317824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002c00767306ULL, 0x0005e20000200c00ULL,
0x0000b8004a287811ULL, 0x008fe400078e20ffULL, 0x00000018ff317819ULL, 0x000fca0000011431ULL,
0x0000002900827306ULL, 0x0007e20000200c00ULL, 0x00008880322c7816ULL, 0x044fe200000000ffULL,
0x0001000032327824ULL, 0x000fca00078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002d00857306ULL, 0x0005e20000200c00ULL, 0x000000002828783bULL, 0x008eee0000000200ULL,
0x0000002c00847306ULL, 0x0009e20000200c00ULL, 0x00000100332d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000000000697306ULL, 0x0004620000200c00ULL,
0x00008880332c7816ULL, 0x050fe200000000ffULL, 0x0001000033337824ULL, 0x000fca00078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000002c00867306ULL, 0x0009e20000200c00ULL,
0x00000018ff007819ULL, 0x004fce0000011416ULL, 0x0000002d00877306ULL, 0x0003e20000200c00ULL,
0x00005410532c7816ULL, 0x010fe40000000055ULL, 0x0000888015557816ULL, 0x000fca00000000ffULL,
0x0000002f007e7306ULL, 0x000fe20000200c00ULL, 0x0000003d28288232ULL, 0x088fe20000000000ULL,
0x00005410682d7816ULL, 0x002fe20000000059ULL, 0x0000003d2a2a8232ULL, 0x000fe40000000000ULL,
0x0000003c29298232ULL, 0x080fe40000000000ULL, 0x0000003c2b2b8232ULL, 0x000fe20000000000ULL,
0x00000030004a7306ULL, 0x0003ec0000200c00ULL, 0x0000002c280c723cULL, 0x000fe4000000180cULL,
0x0000003100837306ULL, 0x0005e20000200c00ULL, 0x0000010014307824ULL, 0x002fc400078e00ffULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e002eULL,
0x000054106c2d7816ULL, 0x000fe20000000069ULL, 0x000000742818723cULL, 0x000fe20000001818ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000002c00537306ULL, 0x0003e20000200c00ULL,
0x0000541070317816ULL, 0x004fe40000000071ULL, 0x00000018ff147819ULL, 0x000fc60000011414ULL,
0x0000007a2820723cULL, 0x000fe40000001820ULL, 0x0000003a003a7306ULL, 0x000ea20000200c00ULL,
0x00005410572c7816ULL, 0x002fce0000000056ULL, 0x0000002c282c723cULL, 0x000fe20000001808ULL,
0x000000004908783bULL, 0x0002e20000000200ULL, 0x0000003b003b7306ULL, 0x000f220000200c00ULL,
0x000054106f3a7816ULL, 0x004fce000000003aULL, 0x0000003000497306ULL, 0x0023f00000200c00ULL,
0x0000003800387306ULL, 0x000ea20000200c00ULL, 0x000054106d307816ULL, 0x002fe4000000006eULL,
0x00005410723b7816ULL, 0x010fca000000003bULL, 0x0000003900397306ULL, 0x000e640000200c00ULL,
0x0000003a2810723cULL, 0x000fec0000001810ULL, 0x0000004d004d7306ULL, 0x000f220000200c00ULL,
0x0000541076387816ULL, 0x004fe20000000038ULL, 0x0000003d08088232ULL, 0x008fcc0000000000ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541078397816ULL, 0x002fe20000000039ULL,
0x0000003d0a0a8232ULL, 0x000fe40000000000ULL, 0x0000003c09098232ULL, 0x080fe40000000000ULL,
0x0000003c0b0b8232ULL, 0x000fe40000000000ULL, 0x0000003200547306ULL, 0x000fe20000200c00ULL,
0x000054107c7c7816ULL, 0x010fe2000000004dULL, 0x000000382838723cULL, 0x000fec000000181cULL,
0x0000003300887306ULL, 0x0003e20000200c00ULL, 0x000054107e7d7816ULL, 0x004fc4000000004eULL,
0x00005410841c7816ULL, 0x000fe40000000085ULL, 0x00005410861d7816ULL, 0x000fc60000000087ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000000302830723cULL, 0x042fee0000001804ULL,
0x0000010015057824ULL, 0x040fe200078e00ffULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000000ffff047224ULL, 0x000fe200078e0055ULL, 0x0000007c2824723cULL, 0x000fe20000001824ULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fc80000011405ULL,
0x0000000500577306ULL, 0x0003e20000200c00ULL, 0x00000018ff157819ULL, 0x000fce0000011415ULL,
0x0000000400567306ULL, 0x0005e20000200c00ULL, 0x0000010016057824ULL, 0x042fe200078e00ffULL,
0x0000001c081c723cULL, 0x000fe80000001830ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000001400557306ULL, 0x0003e20000200c00ULL, 0x0000888016047816ULL, 0x044fe200000000ffULL,
0x0001000016167824ULL, 0x000fca00078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x00000004003d7306ULL, 0x0005e20000200c00ULL, 0x0000888017147816ULL, 0x002fce00000000ffULL,
0x0000000500287306ULL, 0x0002e20000200c00ULL, 0x000054107f047816ULL, 0x004fce0000000080ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541081057816ULL, 0x002fce0000000082ULL,
0x000000040804723cULL, 0x000fe2000000180cULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000054103d287816ULL, 0x008fca0000000028ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0014ULL,
0x00005410830d7816ULL, 0x000fe2000000004cULL, 0x0000010017147824ULL, 0x040fe200078e00ffULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00005410543e7816ULL, 0x004fe4000000003eULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x0000000c00297306ULL, 0x0005e20000200c00ULL,
0x00005410883f7816ULL, 0x002fce000000003fULL, 0x0000003700377306ULL, 0x000fe20000200c00ULL,
0x000054104a0c7816ULL, 0x004fe2000000004bULL, 0x0000003e0810723cULL, 0x040fec0000001810ULL,
0x0000001500597306ULL, 0x0003e40000200c00ULL, 0x0000000c080c723cULL, 0x000fec000000182cULL,
0x00000014002b7306ULL, 0x0004e20000200c00ULL, 0x0000541056157816ULL, 0x002fce0000000057ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541053147816ULL, 0x004fce0000000049ULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x000000140818723cULL, 0x000fe20000001818ULL,
0x0000541029297816ULL, 0x008fcc000000002bULL, 0x00000016002a7306ULL, 0x000e620000200c00ULL,
0x0000541055147816ULL, 0x000fe20000000036ULL, 0x000000280820723cULL, 0x000fe20000001820ULL,
0x0000541059157816ULL, 0x000fca0000000037ULL, 0x00000017002c7306ULL, 0x0004e20000200c00ULL,
0x000054102a2a7816ULL, 0x002fe20000000000ULL, 0x000000140814723cULL, 0x004fe20000001838ULL,
0x000054102c2b7816ULL, 0x008fce0000000002ULL, 0x0000002a0808723cULL, 0x000fe20000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff247f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000030063007a10ULL, 0x000fe20007ffe0ffULL, 0x000058006b257a24ULL, 0x020fe200078e02ffULL,
0x00000004ff2e7819ULL, 0x000fe20000011665ULL, 0x00000080676a7824ULL, 0x000fe200078e026aULL,
0x0000000100247810ULL, 0x040fe20007ffe0ffULL, 0x0000010000027824ULL, 0x000fe200078e00ffULL,
0x000000022e2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008025267824ULL, 0x000fe200078e00ffULL,
0xfffffffa6a007810ULL, 0x000fc40007ffe0ffULL, 0x0000000264257217ULL, 0x000fe40007800000ULL,
0x000000612400720cULL, 0x000fe40003f46070ULL, 0x00000000262d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a02ULL, 0xfffffffc6a027810ULL, 0x040fe40007ffe0ffULL,
0xfffffffe6a007810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x0000002025257807ULL, 0x000fc40001000000ULL, 0x00000002262a7210ULL, 0x040fe40007f9e0ffULL,
0x00005e002d2c7a11ULL, 0x000fe400078640ffULL, 0x0000006a26027210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e06ffULL, 0x0000000026297210ULL, 0x000fe40007fbe0ffULL,
0x000000255f257217ULL, 0x000fe40007800000ULL, 0x00005f002d2d7a11ULL, 0x000fe200018f4424ULL,
0x000000ffff247224ULL, 0x000fe200008e06ffULL, 0x00005e0002597a11ULL, 0x000fe200078240ffULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005e002a277a11ULL, 0x000fe200078440ffULL,
0x0000000125007824ULL, 0x000fe200078e0a5fULL, 0x00005e0029287a11ULL, 0x000fc400078640ffULL,
0x00005f0002027a11ULL, 0x000fe400008f4424ULL, 0x00005f002a2a7a11ULL, 0x000fe400010f442bULL,
0x00005f0029297a11ULL, 0x000fe400018f4426ULL, 0x000000582c247210ULL, 0x000fe40007f9e0ffULL,
0x000000062e2b7810ULL, 0x040fe40007ffe0ffULL, 0x000000002e00720cULL, 0x000fe20003f46070ULL,
0x000000ffff257224ULL, 0x000fe200020e062dULL, 0x0000005827267210ULL, 0x000fc40007fbe0ffULL,
0x000000042e2e7810ULL, 0x000fe40007ffe0ffULL, 0x0000005828287210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200028e062aULL, 0x000000002f00720cULL, 0x080fe40003f26070ULL,
0x000000002e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x000000002b00720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024487faeULL, 0x0003e2000d101c46ULL, 0x0000005859587210ULL, 0x000fca0007f7e0ffULL,
0x000000ffff597224ULL, 0x000fe400018e0602ULL, 0x0000000026477faeULL, 0x0003e8000c901c46ULL,
0x0000000028467faeULL, 0x0003e8000e101c46ULL, 0x0000000058457faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff307f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007824835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff307224ULL, 0x000fe200078e0031ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fe40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000027305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000020000735dULL, 0x008fe40003800000ULL, 0x0106b400ff027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007824835ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000052ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff377819ULL, 0x000fe40000011665ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000a5027f007947ULL, 0x000fea000b800000ULL,
0x00001f3700397589ULL, 0x0004e400000e0000ULL, 0x0000a5527f007947ULL, 0x000fea000b800000ULL,
0x00001f5100517589ULL, 0x00086400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff377224ULL, 0x004fe200078e0050ULL, 0x0000cd4000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff367224ULL, 0x000fe400078e0000ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fc400078e00ffULL, 0x0000ac6000007944ULL, 0x01afea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x0000cdb000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x004fc400078e004fULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000abf000007944ULL, 0x01afea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000432c783bULL, 0x000f620000004200ULL, 0x0000b80003037811ULL, 0x000fc600078e20ffULL,
0x000000004228783bULL, 0x002fe80000004200ULL, 0x000000004444783bULL, 0x000e680000004200ULL,
0x000000004124783bULL, 0x0008e20000004200ULL, 0x00000018ff3f7819ULL, 0x020fe2000001142dULL,
0x000001002d507824ULL, 0x040fe200078e00ffULL, 0x000088802d4f7816ULL, 0x040fe200000000ffULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001142cULL,
0x000001002c4e7824ULL, 0x040fe200078e00ffULL, 0x000088802c4d7816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000010044357824ULL, 0x002fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000010045417824ULL, 0x010fe200078e00ffULL, 0x0000002d00547306ULL, 0x0003e20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000010046487824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001142eULL, 0x00000100474b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001142fULL, 0x00000018ff007819ULL, 0x004fe20000011444ULL,
0x0000005000537306ULL, 0x000fe20000200c00ULL, 0x000001002e2d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe40000011429ULL, 0x0000888044347816ULL, 0x040fe200000000ffULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00507306ULL, 0x0003e20000200c00ULL, 0x0000888045377816ULL, 0x000fc400000000ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0000002d00567306ULL, 0x0005e20000200c00ULL,
0x000088802e2c7816ULL, 0x042fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe40000011428ULL, 0x00000018ff387819ULL, 0x000fc4000001142aULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000002c00557306ULL, 0x0003220000200c00ULL,
0x000001002f2d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe4000001142bULL,
0x0000888046437816ULL, 0x000fe400000000ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002e00587306ULL, 0x0005e20000200c00ULL, 0x000088802f2c7816ULL, 0x042fe200000000ffULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fc40000011448ULL,
0x0000888047497816ULL, 0x000fe400000000ffULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000002d00597306ULL, 0x0003e20000200c00ULL, 0x00008880292e7816ULL, 0x004fe400000000ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x0000541055567816ULL, 0x010fe20000000056ULL, 0x0000002c00577306ULL, 0x0005220000200c00ULL,
0x00000100282d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff317819ULL, 0x008fc40000011424ULL,
0x00000018ff327819ULL, 0x000fe40000011425ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002f00687306ULL, 0x000fe20000200c00ULL, 0x00008880282c7816ULL, 0x044fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fc80000011427ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000002c00697306ULL, 0x0003e20000200c00ULL,
0x0000541057577816ULL, 0x010fce0000000059ULL, 0x0000002d006a7306ULL, 0x0005e20000200c00ULL,
0x0000b800402c7811ULL, 0x002fe200078e20ffULL, 0x0000010029407824ULL, 0x040fe400078e00ffULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000000000367306ULL, 0x0003e20000200c00ULL, 0x000000ffff2d7224ULL, 0x004fe200078e002eULL,
0x00000018ff297819ULL, 0x000fcc0000011429ULL, 0x0000002d006c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff007819ULL, 0x002fe20000011445ULL, 0x0001000045457824ULL, 0x000fca00078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011445ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000000002c2c783bULL, 0x004e6e0000000200ULL, 0x0000003500357306ULL, 0x000eb00000200c00ULL,
0x00000029006e7306ULL, 0x0007f00000200c00ULL, 0x0000003700377306ULL, 0x000fe20000200c00ULL,
0x000001002a297824ULL, 0x008fe200078e00ffULL, 0x0000541034347816ULL, 0x004fc80000000035ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000004100417306ULL, 0x000eb00000200c00ULL,
0x0000000000427306ULL, 0x0007e20000200c00ULL, 0x000000392c2c8232ULL, 0x002fc40000000000ULL,
0x000000392e2e8232ULL, 0x000fe40000000000ULL, 0x000000512d2d8232ULL, 0x080fe40000000000ULL,
0x000000512f2f8232ULL, 0x000fe20000000000ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000541037357816ULL, 0x004fe40000000041ULL, 0x00000018ff007819ULL, 0x008fe20000011446ULL,
0x0001000046467824ULL, 0x000fe400078e00ffULL, 0x000000562c20723cULL, 0x000fe40000001820ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x00000018ff467819ULL, 0x000fca0000011446ULL,
0x000000342c04723cULL, 0x000fe40000001804ULL, 0x00000040006d7306ULL, 0x000fe20000200c00ULL,
0x0000541044367816ULL, 0x002fce0000000036ULL, 0x0000002800407306ULL, 0x0003e20000200c00ULL,
0x0000541045377816ULL, 0x004fce0000000042ULL, 0x0000002900707306ULL, 0x0005e20000200c00ULL,
0x000088802a287816ULL, 0x042fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000000362c34723cULL, 0x000fe8000000180cULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x00000028006f7306ULL, 0x0003e20000200c00ULL, 0x000001002b297824ULL, 0x004fe200078e00ffULL,
0x00008880250d7816ULL, 0x000fc800000000ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00717306ULL, 0x000fe20000200c00ULL, 0x000088802b287816ULL, 0x042fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800727306ULL, 0x0003f00000200c00ULL, 0x0000002900737306ULL, 0x0005e20000200c00ULL,
0x0000888024287816ULL, 0x002fce00000000ffULL, 0x0000002b00747306ULL, 0x000fe20000200c00ULL,
0x0000010024297824ULL, 0x044fe400078e00ffULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe40000011429ULL, 0x0000002800417306ULL, 0x0003e20000200c00ULL,
0x00000018ff247819ULL, 0x000fce0000011424ULL, 0x00000000004a7306ULL, 0x0005e20000200c00ULL,
0x000000000328783bULL, 0x0022ee0000000200ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00000018ff007819ULL, 0x004fe20000011447ULL, 0x0001000047477824ULL, 0x000fca00078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004800487306ULL, 0x000eb00000200c00ULL,
0x0000000c00037306ULL, 0x0023f00000200c00ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000dULL, 0x0000541043487816ULL, 0x004fe20000000048ULL,
0x00000100250d7824ULL, 0x000fc400078e00ffULL, 0x0001000025257824ULL, 0x000fc600078e00ffULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000003928288232ULL, 0x088fe20000000000ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x000000392a2a8232ULL, 0x000fe40000000000ULL, 0x0000005129298232ULL, 0x080fe40000000000ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x000000512b2b8232ULL, 0x000fce0000000000ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x0000541049497816ULL, 0x002fce000000004bULL,
0x00000000004c7306ULL, 0x0003e20000200c00ULL, 0x0000541058587816ULL, 0x004fe2000000003dULL,
0x000000482c1c723cULL, 0x000fec000000181cULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541068597816ULL, 0x008fe4000000003cULL, 0x00000018ff007819ULL, 0x002fca0000011426ULL,
0x0000003f003f7306ULL, 0x000e700000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x00005410503e7816ULL, 0x004fce000000003eULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x00005410543f7816ULL, 0x002fce000000003fULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000541046467816ULL, 0x008fe2000000004aULL, 0x0000003e2c14723cULL, 0x000fec0000001814ULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x0000541047477816ULL, 0x004fce000000004cULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000000462c10723cULL, 0x000fee0000001810ULL,
0x0000000d00437306ULL, 0x0007e20000200c00ULL, 0x000054104d4e7816ULL, 0x002fce000000004eULL,
0x0000000c00427306ULL, 0x0003e20000200c00ULL, 0x00000100260d7824ULL, 0x008fe200078e00ffULL,
0x000054104f4f7816ULL, 0x004fc80000000053ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000003a003a7306ULL, 0x000ea20000200c00ULL, 0x00008880260c7816ULL, 0x042fe200000000ffULL,
0x0000004e2c18723cULL, 0x000fe20000001818ULL, 0x0001000026267824ULL, 0x000fca00078e00ffULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x000000582c2c723cULL, 0x000fec0000001808ULL, 0x0000000c003c7306ULL, 0x0007e20000200c00ULL,
0x0000888027087816ULL, 0x000fe400000000ffULL, 0x00005410403a7816ULL, 0x004fca000000003aULL,
0x0000000d003d7306ULL, 0x0005220000200c00ULL, 0x00005410690c7816ULL, 0x008fe4000000006aULL,
0x000054106e3b7816ULL, 0x002fca000000003bULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x000054106c0d7816ULL, 0x004fce000000006dULL, 0x0000000c280c723cULL, 0x000fe20000001804ULL,
0x0000003300337306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x010fca000000003dULL,
0x0000010027057824ULL, 0x000fe200078e00ffULL, 0x0000541071387816ULL, 0x002fe20000000038ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000000ffff047224ULL, 0x000fe200078e0008ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000003a2808723cULL, 0x040fe20000001834ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000541074397816ULL, 0x004fe40000000033ULL, 0x00000004003e7306ULL, 0x0003ea0000200c00ULL,
0x000000382810723cULL, 0x000fe60000001810ULL, 0x0000000500347306ULL, 0x0004e20000200c00ULL,
0x000054106f047816ULL, 0x002fce0000000070ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x0000541072057816ULL, 0x004fce0000000073ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000000042804723cULL, 0x000fe2000000181cULL, 0x000054103e3d7816ULL, 0x008fcc0000000034ULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x00005410411c7816ULL, 0x000fe20000000003ULL,
0x0000003c2820723cULL, 0x000fe20000001820ULL, 0x00005410421d7816ULL, 0x000fca0000000043ULL,
0x0000002400247306ULL, 0x000e640000200c00ULL, 0x0000001c2818723cULL, 0x000fec0000001818ULL,
0x0000002500257306ULL, 0x000eb00000200c00ULL, 0x0000002600267306ULL, 0x000ee20000200c00ULL,
0x00005410241c7816ULL, 0x002fce0000000031ULL, 0x0000002700277306ULL, 0x000e620000200c00ULL,
0x00005410251d7816ULL, 0x004fe40000000032ULL, 0x0000541026267816ULL, 0x008fca0000000000ULL,
0x0000001c281c723cULL, 0x000fe20000001814ULL, 0x0000541027277816ULL, 0x002fce0000000002ULL,
0x000000262824723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff027f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff147224ULL, 0x002fc600078e0003ULL, 0x0000030063637a10ULL, 0x000fc80007ffe0ffULL,
0x000000616300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff318000007947ULL, 0x000fea000383ffffULL, 0x0000000000307919ULL, 0x002e620000002500ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0027ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0026ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0025ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0023ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0022ULL,
0x000000ffff297224ULL, 0x000fe400078e0021ULL, 0x000000ffff287224ULL, 0x000fe400078e0020ULL,
0x000000ffff277224ULL, 0x000fe400078e001fULL, 0x000000ffff267224ULL, 0x000fe400078e001eULL,
0x000000ffff257224ULL, 0x000fe400078e001dULL, 0x000000ffff247224ULL, 0x000fe200078e001cULL,
0x000000613000720cULL, 0x002fe20003f06070ULL, 0x000000ffff237224ULL, 0x000fc400078e001bULL,
0x000000ffff227224ULL, 0x000fe400078e001aULL, 0x000000ffff217224ULL, 0x000fe400078e0019ULL,
0x000000ffff207224ULL, 0x000fe400078e0018ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0011ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0007ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0006ULL, 0x000000ffff197224ULL, 0x000fe400078e0005ULL,
0x000000ffff187224ULL, 0x000fe400078e0004ULL, 0x000000ffff177224ULL, 0x000fc400078e000bULL,
0x000000ffff167224ULL, 0x000fe400078e000aULL, 0x000000ffff157224ULL, 0x000fe400078e0009ULL,
0x000000ffff147224ULL, 0x000fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x000fe400078e000eULL, 0x000000ffff117224ULL, 0x000fc400078e000dULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x018000005d007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff317224ULL, 0x000fe200078e005dULL,
0x0000dfc000047802ULL, 0x000fe40000000f00ULL, 0x0000982000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000005d00007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x006fc8000000005dULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000200007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006800ff027624ULL, 0x000fe400078e00ffULL, 0x00006900ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x000968000c1e9900ULL, 0x0000000000037919ULL, 0x010f240000000000ULL,
0x00000002ff047819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000002007220ULL, 0x02cfca0000410000ULL, 0x00001f0400027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000001002107220ULL, 0x044fe40000410000ULL,
0x0000001102117220ULL, 0x040fe40000410000ULL, 0x0000001402147220ULL, 0x040fe40000410000ULL,
0x0000001502157220ULL, 0x000fc40000410000ULL, 0x0000001802187220ULL, 0x040fe40000410000ULL,
0x0000001902197220ULL, 0x040fe40000410000ULL, 0x0000001c021c7220ULL, 0x040fe40000410000ULL,
0x0000001d021d7220ULL, 0x040fe40000410000ULL, 0x0000002002207220ULL, 0x040fe40000410000ULL,
0x0000002102217220ULL, 0x000fc40000410000ULL, 0x0000002402247220ULL, 0x040fe40000410000ULL,
0x0000002502257220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002c022c7220ULL, 0x040fe40000410000ULL,
0x0000002d022d7220ULL, 0x000fc40000410000ULL, 0x0000001203127220ULL, 0x048fe40000410000ULL,
0x0000001303137220ULL, 0x040fe40000410000ULL, 0x0000001603167220ULL, 0x040fe40000410000ULL,
0x0000001703177220ULL, 0x040fe40000410000ULL, 0x0000001a031a7220ULL, 0x040fe40000410000ULL,
0x0000001b031b7220ULL, 0x000fc40000410000ULL, 0x0000001e031e7220ULL, 0x040fe40000410000ULL,
0x0000001f031f7220ULL, 0x040fe40000410000ULL, 0x0000002203227220ULL, 0x040fe40000410000ULL,
0x0000002303237220ULL, 0x040fe40000410000ULL, 0x0000002603267220ULL, 0x040fe40000410000ULL,
0x0000002703277220ULL, 0x000fc40000410000ULL, 0x0000002a032a7220ULL, 0x040fe40000410000ULL,
0x0000002b032b7220ULL, 0x040fe40000410000ULL, 0x0000002e032e7220ULL, 0x040fe40000410000ULL,
0x0000002f032f7220ULL, 0x000fe40000410000ULL, 0x0000000000007919ULL, 0x000ee80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200027812ULL, 0x00cfc400078ec0ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x00000001ff037819ULL, 0x000fe40000011602ULL,
0x0000000202047811ULL, 0x040fe400078ff8ffULL, 0x0000000402077811ULL, 0x040fe400078ff8ffULL,
0x00000006020b7811ULL, 0x000fe400078ff8ffULL, 0x00000008000f7811ULL, 0x000fc400078ff0ffULL,
0x0000000703027812ULL, 0x100fe400078e780dULL, 0x0000000704057812ULL, 0x100fe400078e780dULL,
0x0000000707097812ULL, 0x000fe200078e780dULL, 0x000000080d067824ULL, 0x000fe200078e0202ULL,
0x0000000707077812ULL, 0x000fe200078e780fULL, 0x000000080d087824ULL, 0x000fe200078e0205ULL,
0x000000070b0c7812ULL, 0x000fe200078e780dULL, 0x0000080066027824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe200078e780fULL, 0x000000080f0e7824ULL, 0x000fe200078e0207ULL,
0x0000000704047812ULL, 0x000fe200078e780fULL, 0x000000080d0a7824ULL, 0x000fe200078e0209ULL,
0x000000070b057812ULL, 0x000fe200078e780fULL, 0x000000080d0c7824ULL, 0x000fc400078e020cULL,
0x000000080f0b7824ULL, 0x040fe200078e0203ULL, 0x0000a00002037810ULL, 0x000fe20007ffe0ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x000000080f0d7824ULL, 0x000fe200078e0204ULL,
0x000000101104723eULL, 0x000fe200000000ffULL, 0x000000080f0f7824ULL, 0x000fe200078e0205ULL,
0x0000000807077812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x000000141505723eULL, 0x000fe200000000ffULL, 0x0000001008097824ULL, 0x000fc400078e0203ULL,
0x000000100a0a7824ULL, 0x000fe200078e0203ULL, 0x0000541004107816ULL, 0x040fe20000000005ULL,
0x000000100b0b7824ULL, 0x000fe200078e0203ULL, 0x0000763204117816ULL, 0x000fe20000000005ULL,
0x000000100d0d7824ULL, 0x100fe400078e0203ULL, 0x000000100c0c7824ULL, 0x100fe400078e0203ULL,
0x000000100e0e7824ULL, 0x100fe400078e0203ULL, 0x000000100f0f7824ULL, 0x000fc400078e0203ULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000181906723eULL, 0x000fe200000000ffULL,
0x0000000107097824ULL, 0x040fe400078e0209ULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x0000001008007388ULL, 0x0005e20000000a00ULL, 0x00000001070b7824ULL, 0x040fe400078e020bULL,
0x00000001070d7824ULL, 0x040fe400078e020dULL, 0x00000001070c7824ULL, 0x000fc400078e020cULL,
0x00000001070e7824ULL, 0x040fe400078e020eULL, 0x00000001070f7824ULL, 0x000fe200078e020fULL,
0x0000001c1d07723eULL, 0x000fe400000000ffULL, 0x000000121308723eULL, 0x004fe200000000ffULL,
0x00000300ff137624ULL, 0x000fe200078e00ffULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe40000000007ULL, 0x000000282906723eULL, 0x000fc400000000ffULL,
0x0000002c2d07723eULL, 0x000fe200000000ffULL, 0x0000000409007388ULL, 0x0005e20000000a00ULL,
0x000000011300780cULL, 0x000fe40003f05270ULL, 0x000000202104723eULL, 0x004fe400000000ffULL,
0x000000242505723eULL, 0x000fe400000000ffULL, 0x000000161709723eULL, 0x000fe400000000ffULL,
0x0000541004107816ULL, 0x000fc40000000005ULL, 0x0000763204117816ULL, 0x000fe40000000005ULL,
0x0000541006047816ULL, 0x140fe40000000007ULL, 0x0000763206057816ULL, 0x000fe20000000007ULL,
0x000000100a007388ULL, 0x000fe20000000a00ULL, 0x000000222306723eULL, 0x000fe400000000ffULL,
0x000000262707723eULL, 0x000fe200000000ffULL, 0x000000040c007388ULL, 0x0005e40000000a00ULL,
0x0000541008047816ULL, 0x004fc40000000009ULL, 0x0000763208057816ULL, 0x000fe40000000009ULL,
0x0000002a2b08723eULL, 0x000fe400000000ffULL, 0x0000002e2f09723eULL, 0x000fe200000000ffULL,
0x000000040b007388ULL, 0x0005e40000000a00ULL, 0x0000001a1b04723eULL, 0x004fe400000000ffULL,
0x0000001e1f05723eULL, 0x000fc800000000ffULL, 0x00005410040a7816ULL, 0x140fe40000000005ULL,
0x00007632040b7816ULL, 0x000fe40000000005ULL, 0x0000541006047816ULL, 0x140fe40000000007ULL,
0x0000763206057816ULL, 0x000fe20000000007ULL, 0x0000000a0d007388ULL, 0x0005e20000000a00ULL,
0x0000541008067816ULL, 0x140fe40000000009ULL, 0x0000763208077816ULL, 0x000fe20000000009ULL,
0x000000040e007388ULL, 0x0005e80000000a00ULL, 0x000000060f007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x000ee20000002700ULL, 0x0000001000047824ULL, 0x004fe200078e0202ULL,
0x000000ff6600720cULL, 0x000fe20003f05270ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000ee20000002600ULL, 0x00000020000e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x00a0000004147984ULL, 0x000ea80000000c00ULL,
0x00a2000004187984ULL, 0x0008640000000c00ULL, 0x0000580013047a24ULL, 0x010fc800078e02ffULL,
0x0000660004087a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x008fc600078e0205ULL,
0x00000fff08057811ULL, 0x000fe200078e40ffULL, 0x0000030010047a24ULL, 0x000fc800078e02ffULL,
0x0000000104097824ULL, 0x000fca00078e0230ULL, 0x0000000905067211ULL, 0x000fca00078fa0ffULL,
0x00006c0006067625ULL, 0x000fcc00078e0007ULL, 0x0000040066067825ULL, 0x000fcc00078e0006ULL,
0x000000100e0e7825ULL, 0x000fc800078e0006ULL, 0x00000010000c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08067812ULL, 0x000fe200078ec0ffULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000001ff087819ULL, 0x006fe20000011600ULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c08117812ULL, 0x000fe200078ec0ffULL,
0x00000001090a7824ULL, 0x000fe200078e0206ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x00006c0009087625ULL, 0x000fc800078e000bULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000811087210ULL, 0x000fc80007b5e007ULL, 0x0000000a110a7210ULL, 0x000fe40007d9e007ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000005e08007986ULL, 0x0003e8000c101906ULL, 0x0000005d0a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x0063e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff13077810ULL, 0x000fc60007ffe0ffULL, 0x00006a0010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000007080879a8ULL, 0x000ea400099ee1c6ULL, 0x000000070800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000800000ULL,
0x00000007ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff077984ULL, 0x004ea40000000000ULL,
0x000000ff0700720cULL, 0x004fda0003f25270ULL, 0x0000278000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001040a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff117424ULL, 0x000fe200078e00ffULL, 0x0000000c08147812ULL, 0x002fe400078ec0ffULL,
0x0000007007127812ULL, 0x000fe200078ec0ffULL, 0x00006c0004087625ULL, 0x000fc800078e0011ULL,
0x00006c000a0a7625ULL, 0x000fe200078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e012ULL,
0x0000000a140a7210ULL, 0x000fe40007b5e012ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608077981ULL, 0x000368000c1e1900ULL,
0x000000060a0c7981ULL, 0x000362000c1e1900ULL, 0x000000021300780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e012ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080d7981ULL, 0x000362000c1e1900ULL,
0x000000041300780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e012ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080e7981ULL, 0x000362000c1e1900ULL, 0x000000041300780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404087810ULL, 0x002fca0007ffe0ffULL,
0x00006c0008087625ULL, 0x000fca00078e0011ULL, 0x0000000814087210ULL, 0x000fc8000791e012ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080f7981ULL, 0x000362000c1e1900ULL,
0x000000061300780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504087810ULL, 0x002fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fc8000791e012ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608107981ULL, 0x000362000c1e1900ULL, 0x000000061300780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081300780cULL, 0x002fe40003f06070ULL,
0x0000000604087810ULL, 0x000fca0007ffe0ffULL, 0x00006c0008087625ULL, 0x000fca00078e0011ULL,
0x0000000814087210ULL, 0x000fe40007a3e012ULL, 0x00000007040a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006c000a0a0625ULL, 0x000fe400078e0011ULL,
0x0000000608117981ULL, 0x000366000c1e1900ULL, 0x0000000a140a0210ULL, 0x000fc80007c7e012ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a120981ULL, 0x000368000c1e1900ULL,
0x0000000713087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x020fe400078e0007ULL,
0x000000080b147824ULL, 0x040fe200078e00ffULL, 0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL,
0x0000030014007a0cULL, 0x000fe40003f26070ULL, 0x0000000a0b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000814087810ULL, 0x040fe40007ffe0ffULL,
0x0000000114097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001307077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000137824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007013137812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e013ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608137981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000914087810ULL, 0x042fe40007ffe0ffULL, 0x0000000214097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000c07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00cULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080c7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000314097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000414097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000e07077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000e7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x000000700e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e00eULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080e7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000514097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000f07077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000f7824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e00fULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080f7981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d14087810ULL, 0x042fe40007ffe0ffULL, 0x0000000614097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001007077209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007010107812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007b3e010ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608107981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e14087810ULL, 0x042fe40007ffe0ffULL,
0x0000000714097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001107077209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000104087824ULL, 0x000fe200078e0208ULL,
0x00000001ff157819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x0000000c15157812ULL, 0x000fe200078ec0ffULL,
0x00006c0008087625ULL, 0x000fc600078e0009ULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000815087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f14087810ULL, 0x002fe40007ffe0ffULL, 0x0000001207077209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x00000001ff147819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x00006c0008087625ULL, 0x000fc600078e0009ULL,
0x0000007012127812ULL, 0x000fc800078ec0ffULL, 0x0000000814087210ULL, 0x000fc80007a3e012ULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x0000000608127981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000708007388ULL, 0x0203e40000000800ULL,
0x0000000405087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x00006c0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff417819ULL, 0x000fe20000011666ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000040066407824ULL, 0x000fe200078e00ffULL, 0x0000000c0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000100066207824ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0000004008087210ULL, 0x000fe20007f3e0ffULL,
0x0000000107177824ULL, 0x000fe200078e020aULL, 0x00000020000a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001040c8824ULL, 0x000fe200078e0206ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0641ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000017177984ULL, 0x000e620000000800ULL,
0x00006c000c0c8625ULL, 0x000fe200078e000dULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000001000077824ULL, 0x000fc400078e0220ULL, 0x0000001066108824ULL, 0x000fe400078e0200ULL,
0x0000001000087825ULL, 0x000fc600078e0008ULL, 0x0000458010108811ULL, 0x000fe200078e20ffULL,
0x00006c00040e8625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008077faeULL, 0x0005e6000b901c46ULL, 0x0000001066118824ULL, 0x000fe200078e0200ULL,
0x003800000a077faeULL, 0x0007e2000b901c46ULL, 0x00000010000c8825ULL, 0x000fc600078e000cULL,
0x0000418011118811ULL, 0x000fe200078e20ffULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000000000c108faeULL, 0x0009e2000b901c46ULL, 0x0000001000088825ULL, 0x004fe400078e000eULL,
0x00000000000e7805ULL, 0x000fe4000001ff00ULL, 0x000000ffff077224ULL, 0x008fe200078e00ffULL,
0x0000000008118faeULL, 0x0005e2000b901c46ULL, 0x00000000000a7805ULL, 0x000fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000087805ULL, 0x004fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000cf000009947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x002fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fca00078e00ffULL, 0x0000000132337810ULL, 0x000fc80007ffe0ffULL,
0x0000030033007a0cULL, 0x000fda0003f06070ULL, 0x0000023000000947ULL, 0x000fea0003800000ULL,
0x00000001041f7824ULL, 0x000fe200078e0233ULL, 0x000000070000780cULL, 0x040fe20003f24070ULL,
0x00001000ff197424ULL, 0x000fe200078e00ffULL, 0x00000001331e7812ULL, 0x040fe200078ec0ffULL,
0x00000800331a7824ULL, 0x000fe200078e00ffULL, 0x0000001f05187211ULL, 0x000fe400078fa0ffULL,
0x0000002000367810ULL, 0x000fe40007ffe0ffULL, 0x000008001a1c7812ULL, 0x000fe200078ec0ffULL,
0x00006c0018187625ULL, 0x000fc800078e0019ULL, 0x00000001061b9824ULL, 0x000fe200078e021fULL,
0x0000004018187210ULL, 0x000fe20007f1e0ffULL, 0x00000080ff349424ULL, 0x000fe400078e00ffULL,
0x00000002661d9824ULL, 0x140fe400078e021eULL, 0x0000000266379824ULL, 0x000fe400078e021eULL,
0x00006c001b1a9625ULL, 0x000fc800078e0034ULL, 0x00000080ff1e9424ULL, 0x000fe400078e00ffULL,
0x00000001201c7824ULL, 0x000fe400078e021cULL, 0x0000000119197824ULL, 0x000fe400000e0641ULL,
0x000000081d359824ULL, 0x000fe400078e0200ULL, 0x00006c001f1e9625ULL, 0x000fc600078e001eULL,
0x0000458035359811ULL, 0x000fe200078e20ffULL, 0x0000001000347824ULL, 0x040fe400078e021cULL,
0x0000000837379824ULL, 0x000fe400078e0200ULL, 0x00000010001c9825ULL, 0x000fc800078e001aULL,
0x00000010361a7825ULL, 0x000fe200078e0018ULL, 0x0000418037369811ULL, 0x000fc600078e20ffULL,
0x0000001000187825ULL, 0x000fc800078e0018ULL, 0x00000010001e9825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000018347faeULL, 0x0003e8000b901c46ULL,
0x003800001a347faeULL, 0x0003e8000b901c46ULL, 0x000000001c359faeULL, 0x0003e8000b901c46ULL,
0x000000001e369faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff357224ULL, 0x002fe200078e0032ULL, 0x00000001ff1a7819ULL, 0x100fe20000011600ULL,
0x0000001000197824ULL, 0x000fe200078e00ffULL, 0x00000002ff427819ULL, 0x000fe20000011600ULL,
0x0000008035187824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x00000008421b7824ULL, 0x000fe200078e00ffULL,
0x0000008018187812ULL, 0x000fe400078ec0ffULL, 0x00000042ff347212ULL, 0x000fe400078e33ffULL,
0x0000000742327812ULL, 0x000fe200078ec0ffULL, 0x0000010066187824ULL, 0x000fe200078e0218ULL,
0xfffffff81b347812ULL, 0x000fe400078ee234ULL, 0x0000000842437810ULL, 0x000fc40007ffe0ffULL,
0x000000181a187210ULL, 0x000fe20007ffe019ULL, 0x0000000842197824ULL, 0x000fe200078e00ffULL,
0x00000043ff3d7212ULL, 0x000fe200078e33ffULL, 0x0000000843367824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000181a7984ULL, 0x000e620000000800ULL,
0x00000001191b7812ULL, 0x100fe200078ef632ULL, 0x0000000843377824ULL, 0x000fe200078e00ffULL,
0x00000002191c7812ULL, 0x140fe200078ef632ULL, 0x00458000183f7984ULL, 0x0004e20000000800ULL,
0x00000003191d7812ULL, 0x140fe400078ef632ULL, 0x00000004191e7812ULL, 0x140fe400078ef632ULL,
0x00000005191f7812ULL, 0x000fe400078ef632ULL, 0xfffffff8363d7812ULL, 0x000fe200078ee23dULL,
0x0000000842187824ULL, 0x004fca00078e00ffULL, 0xfffffff818187812ULL, 0x100fe400078ee232ULL,
0x0000000619327812ULL, 0x000fe200078ef632ULL, 0x0000080035197824ULL, 0x000fca00078e00ffULL,
0x0000080019197812ULL, 0x000fc800078ec0ffULL, 0x0000018020197810ULL, 0x000fca0007ffe019ULL,
0x0000001018187824ULL, 0x100fe400078e0219ULL, 0x000000101b1b7824ULL, 0x100fe400078e0219ULL,
0x000000101d1d7824ULL, 0x100fe400078e0219ULL, 0x0000001a171a7221ULL, 0x002fe40000010100ULL,
0x000000101c1c7824ULL, 0x000fe400078e0219ULL, 0x3fb8aa3b1a357820ULL, 0x000fc40000410000ULL,
0x00000004001a7824ULL, 0x000fe400078e00ffULL, 0x00000035003e7308ULL, 0x0002e20000000800ULL,
0x000000101f1f7824ULL, 0x100fe400078e0219ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000101e1e7824ULL, 0x100fe400078e0219ULL, 0x0000001032327824ULL, 0x000fe400078e0219ULL,
0x0000000118187824ULL, 0x000fe200078e021aULL, 0x0000000743357812ULL, 0x002fe200078ec0ffULL,
0x000000011a1b7824ULL, 0x000fc400078e021bULL, 0x000000011a1d7824ULL, 0x000fe200078e021dULL,
0xfffffff836367812ULL, 0x100fe200078ee235ULL, 0x0000000018187984ULL, 0x000e620000000800ULL,
0x000000011a1c7824ULL, 0x040fe200078e021cULL, 0x0000000137387812ULL, 0x040fe200078ef635ULL,
0x000000011a1f7824ULL, 0x000fe200078e021fULL, 0x000000001b1b7984ULL, 0x000fe20000000800ULL,
0x0000003f3e3e7220ULL, 0x008fe20000410000ULL, 0x0000000237397812ULL, 0x140fe200078ef635ULL,
0x000000011a1e7824ULL, 0x040fe200078e021eULL, 0x000000001d1d7984ULL, 0x000fe20000000800ULL,
0x000000011a327824ULL, 0x000fe200078e0232ULL, 0x00000003373a7812ULL, 0x040fe200078ef635ULL,
0x0000001036367824ULL, 0x000fe200078e0219ULL, 0x000000001c1c7984ULL, 0x000fe20000000800ULL,
0x00000004373b7812ULL, 0x040fe200078ef635ULL, 0x0000001038387824ULL, 0x000fe200078e0219ULL,
0x00000005373c7812ULL, 0x140fe200078ef635ULL, 0x000000001f1f7984ULL, 0x000fe20000000800ULL,
0x0000000637357812ULL, 0x000fe200078ef635ULL, 0x000000011a367824ULL, 0x000fc400078e0236ULL,
0x00001f423e377589ULL, 0x000ea200000e0000ULL, 0x000000011a387824ULL, 0x000fe400078e0238ULL,
0x0000001039397824ULL, 0x100fe200078e0219ULL, 0x000000001e1e7984ULL, 0x000ee20000000800ULL,
0x000000103a3a7824ULL, 0x000fe400078e0219ULL, 0x000000011a397824ULL, 0x040fe200078e0239ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000011a3a7824ULL, 0x000fe400078e023aULL,
0x000000103b3b7824ULL, 0x100fe200078e0219ULL, 0x0000000036367984ULL, 0x000f220000000800ULL,
0x000000103c3c7824ULL, 0x000fc400078e0219ULL, 0x000000011a3b7824ULL, 0x040fe200078e023bULL,
0x0000000038387984ULL, 0x000f620000000800ULL, 0x000000011a3c7824ULL, 0x000fe400078e023cULL,
0x0000001034347824ULL, 0x100fe200078e0219ULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000001035357824ULL, 0x100fe400078e0219ULL, 0x000000103d3d7824ULL, 0x000fe200078e0219ULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x20000018ff197230ULL, 0x102fe20000004100ULL,
0x000000011a347824ULL, 0x040fe200078e0234ULL, 0x30000018ff187230ULL, 0x000fe20000004100ULL,
0x000000011a357824ULL, 0x040fe200078e0235ULL, 0x000000003b3b7984ULL, 0x000fe20000000800ULL,
0x000000011a3d7824ULL, 0x000fc400078e023dULL, 0x00000037182f7223ULL, 0x084fe2000001002fULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x2000001bff187230ULL, 0x100fe20000004100ULL,
0x000000313e317221ULL, 0x000fe20000010000ULL, 0x3000001bff1b7230ULL, 0x000fe20000004100ULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x0000003719307223ULL, 0x080fe20000010030ULL,
0x2000001cff197230ULL, 0x100fe20000004100ULL, 0x00000037182e7223ULL, 0x080fe2000001002eULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x2000001dff187230ULL, 0x000fe20000004100ULL,
0x000000371b2d7223ULL, 0x080fe2000001002dULL, 0x3000001cff1c7230ULL, 0x000fe20000004100ULL,
0x000000003d3d7984ULL, 0x000fe20000000800ULL, 0x00000037192c7223ULL, 0x080fe2000001002cULL,
0x2000001eff197230ULL, 0x008fe20000004100ULL, 0x00000037182a7223ULL, 0x080fe2000001002aULL,
0x00001f433e3e7589ULL, 0x000e6200000e0000ULL, 0x2000001fff187230ULL, 0x000fe20000004100ULL,
0x000000371c2b7223ULL, 0x080fe2000001002bULL, 0x3000001dff1d7230ULL, 0x000fe20000004100ULL,
0x0000003719287223ULL, 0x080fe20000010028ULL, 0x20000036ff197230ULL, 0x010fe20000004100ULL,
0x0000003718267223ULL, 0x080fe20000010026ULL, 0x20000032ff187230ULL, 0x100fe20000004100ULL,
0x000000371d297223ULL, 0x000fe20000010029ULL, 0x30000032ff327230ULL, 0x000fc40000004100ULL,
0x3000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000003718247223ULL, 0x080fe20000010024ULL,
0x20000038ff187230ULL, 0x020fe20000004100ULL, 0x0000003732237223ULL, 0x080fe20000010023ULL,
0x3000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000000ffff327224ULL, 0x000fe200078e0033ULL,
0x30000036ff367230ULL, 0x000fe20000004100ULL, 0x000000371e277223ULL, 0x080fe20000010027ULL,
0x30000038ff387230ULL, 0x000fe20000004100ULL, 0x000000371f257223ULL, 0x080fe20000010025ULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x0000003e19167223ULL, 0x082fe20000010016ULL,
0x20000039ff197230ULL, 0x000fe20000004100ULL, 0x0000003e18147223ULL, 0x080fe20000010014ULL,
0x2000003aff187230ULL, 0x000fe20000004100ULL, 0x0000003e36157223ULL, 0x080fe20000010015ULL,
0x20000034ff1a7230ULL, 0x000fe20000004100ULL, 0x0000003e19127223ULL, 0x080fe20000010012ULL,
0x2000003cff197230ULL, 0x000fe20000004100ULL, 0x0000003e18107223ULL, 0x080fe20000010010ULL,
0x2000003bff187230ULL, 0x000fe20000004100ULL, 0x000000371a227223ULL, 0x080fe20000010022ULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x0000003e190c7223ULL, 0x080fe2000001000cULL,
0x2000003dff197230ULL, 0x000fe20000004100ULL, 0x0000003e180e7223ULL, 0x080fe2000001000eULL,
0x20000035ff187230ULL, 0x000fe20000004100ULL, 0x0000003734217223ULL, 0x000fe20000010021ULL,
0x30000039ff397230ULL, 0x000fe20000004100ULL, 0x0000003e38137223ULL, 0x080fe20000010013ULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x0000003e180a7223ULL, 0x080fe2000001000aULL,
0x3000003bff3b7230ULL, 0x000fe20000004100ULL, 0x0000003e39117223ULL, 0x080fe20000010011ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000003e3a0f7223ULL, 0x080fe2000001000fULL,
0x30000035ff357230ULL, 0x000fe20000004100ULL, 0x0000003e3b0d7223ULL, 0x080fe2000001000dULL,
0x3000003dff3d7230ULL, 0x000fe20000004100ULL, 0x0000003e3c0b7223ULL, 0x000fc4000001000bULL,
0x0000003e35097223ULL, 0x080fe40000010009ULL, 0x0000003e19087223ULL, 0x080fe40000010008ULL,
0x0000003e3d077223ULL, 0x000fe20000010007ULL, 0xfffff33000008947ULL, 0x000fea000383ffffULL,
0x0180000031007810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000000007812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00010a4000047802ULL, 0x000fe40000000f00ULL, 0x00006da000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003100047308ULL, 0x000e640000001000ULL, 0xbf80000004317423ULL, 0x002fc80000000031ULL,
0x800000ff31317221ULL, 0x000fc80000010100ULL, 0x0000003104047223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff177819ULL, 0x004fe20000011600ULL,
0x00000004001e7824ULL, 0x040fe200078e00ffULL, 0x00000008001d7811ULL, 0x000fe400078ff0ffULL,
0x00000017ff067212ULL, 0x000fe200078e33ffULL, 0x00001f1704057589ULL, 0x000ea200000e0000ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x000000071d1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081d187824ULL, 0x000fe200078e00ffULL, 0x00001f1d04047589ULL, 0x000ee200000e0000ULL,
0x0000001dff1c7212ULL, 0x000fc400078e33ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL,
0x0000000817067824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff8181c7812ULL, 0x000fe400078ee21cULL, 0xfffffff806067812ULL, 0x000fe400078ee217ULL,
0x000000031b187812ULL, 0x040fe200078e3cffULL, 0x000000101c1c7824ULL, 0x100fe200078e0203ULL,
0x000000041b197812ULL, 0x040fe200078e3cffULL, 0x0000001006067824ULL, 0x000fe200078e0203ULL,
0x000000051b1a7812ULL, 0x000fe200078e3cffULL, 0x000000081d187824ULL, 0x000fc400078e0218ULL,
0x000000011e067824ULL, 0x000fe400078e0206ULL, 0x0000003005307220ULL, 0x044fe40000410000ULL,
0x0000002f052f7220ULL, 0x000fe40000410000ULL, 0x0000001604167220ULL, 0x048fe40000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x000000302f2f723eULL, 0x000fe200000000ffULL,
0x0000001404147220ULL, 0x000fc40000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000002f06007388ULL, 0x0005e20000000800ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x0000001004107220ULL, 0x040fe40000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x0000000e040e7220ULL, 0x000fc40000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x0000000c040c7220ULL, 0x040fe40000410000ULL,
0x0000000b040b7220ULL, 0x040fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x0000000a040a7220ULL, 0x040fe40000410000ULL, 0x0000000904097220ULL, 0x040fe20000410000ULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000000804087220ULL, 0x000fc40000410000ULL,
0x0000000704047220ULL, 0x000fe20000410000ULL, 0x0000000717077812ULL, 0x000fe200078ec0ffULL,
0x000000081d147824ULL, 0x000fe200078e00ffULL, 0x0000000a0909723eULL, 0x000fe200000000ffULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x000000080404723eULL, 0x000fe200000000ffULL,
0x0000002d052d7220ULL, 0x000fe20000410000ULL, 0x0000000107087812ULL, 0x000fe200078e3cffULL,
0x0000002c052c7220ULL, 0x000fe20000410000ULL, 0x00000002070a7812ULL, 0x000fe200078e3cffULL,
0x0000002b052b7220ULL, 0x000fe20000410000ULL, 0x00000003070c7812ULL, 0x000fe200078e3cffULL,
0x0000002a052a7220ULL, 0x000fe20000410000ULL, 0x00000004070e7812ULL, 0x000fe200078e3cffULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x0000000507107812ULL, 0x000fe200078e3cffULL,
0x0000002805287220ULL, 0x000fe20000410000ULL, 0x0000000607127812ULL, 0x000fe200078e3cffULL,
0x0000000817077824ULL, 0x040fe200078e0208ULL, 0xfffffff814147812ULL, 0x000fe200078ee21dULL,
0x0000000817087824ULL, 0x000fe200078e020aULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x00000008170a7824ULL, 0x000fe200078e020cULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x00000008170c7824ULL, 0x000fe200078e020eULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x00000008170e7824ULL, 0x000fc400078e0210ULL, 0x0000000817107824ULL, 0x000fe200078e0212ULL,
0x000000011b127812ULL, 0x000fe200078e3cffULL, 0x0000001007077824ULL, 0x100fe200078e0203ULL,
0x000000021b177812ULL, 0x040fe200078e3cffULL, 0x0000001008087824ULL, 0x100fe200078e0203ULL,
0x000000061b1b7812ULL, 0x000fe200078e3cffULL, 0x0000002705277220ULL, 0x040fe40000410000ULL,
0x000000100a0a7824ULL, 0x000fe400078e0203ULL, 0x0000002605267220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002505257220ULL, 0x000fc40000410000ULL,
0x000000100c0c7824ULL, 0x100fe400078e0203ULL, 0x0000002405247220ULL, 0x000fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000002305237220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x000fe40000410000ULL, 0x000000081d167824ULL, 0x000fe200078e0212ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x000000100e0e7824ULL, 0x000fc400078e0203ULL,
0x000000011e077824ULL, 0x000fe400078e0207ULL, 0x0000002105057220ULL, 0x000fe40000410000ULL,
0x000000081d177824ULL, 0x000fe200078e0217ULL, 0x0000002d07007388ULL, 0x0005e20000000800ULL,
0x0000001010107824ULL, 0x100fe200078e0203ULL, 0x000000220505723eULL, 0x000fe200000000ffULL,
0x000000011e087824ULL, 0x000fe400078e0208ULL, 0x000000101f127824ULL, 0x000fc400078e0203ULL,
0x000000011e0a7824ULL, 0x000fe200078e020aULL, 0x0000002b08007388ULL, 0x0005e20000000800ULL,
0x000000081d197824ULL, 0x040fe400078e0219ULL, 0x0000001014147824ULL, 0x100fe200078e0203ULL,
0x000000290a007388ULL, 0x0005e20000000800ULL, 0x000000011e0c7824ULL, 0x000fe400078e020cULL,
0x000000081d1a7824ULL, 0x000fe400078e021aULL, 0x0000001016167824ULL, 0x000fe200078e0203ULL,
0x000000270c007388ULL, 0x0005e20000000800ULL, 0x000000011e0e7824ULL, 0x000fc400078e020eULL,
0x000000081d1b7824ULL, 0x000fe400078e021bULL, 0x0000001017177824ULL, 0x100fe200078e0203ULL,
0x000000250e007388ULL, 0x0005e20000000800ULL, 0x000000011e107824ULL, 0x000fe400078e0210ULL,
0x0000001018187824ULL, 0x100fe400078e0203ULL, 0x000000011e127824ULL, 0x000fe200078e0212ULL,
0x0000002310007388ULL, 0x0005e20000000800ULL, 0x0000001019197824ULL, 0x000fc400078e0203ULL,
0x000000011e147824ULL, 0x000fe200078e0214ULL, 0x0000000512007388ULL, 0x0005e20000000800ULL,
0x000000101a1a7824ULL, 0x100fe400078e0203ULL, 0x000000011e167824ULL, 0x040fe200078e0216ULL,
0x0000001514007388ULL, 0x0005e20000000800ULL, 0x000000101b1b7824ULL, 0x000fe400078e0203ULL,
0x000000011e177824ULL, 0x040fe200078e0217ULL, 0x0000001316007388ULL, 0x0005e20000000800ULL,
0x000000011e187824ULL, 0x000fc400078e0218ULL, 0x000000011e197824ULL, 0x040fe200078e0219ULL,
0x0000001117007388ULL, 0x0005e20000000800ULL, 0x000000011e1a7824ULL, 0x040fe400078e021aULL,
0x000000011e1b7824ULL, 0x040fe200078e021bULL, 0x0000000f18007388ULL, 0x0005e20000000800ULL,
0x000000011e1c7824ULL, 0x000fc600078e021cULL, 0x0000000d19007388ULL, 0x0005e80000000800ULL,
0x0000000b1a007388ULL, 0x0005e80000000800ULL, 0x000000091b007388ULL, 0x0005e80000000800ULL,
0x000000041c007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002000117810ULL, 0x004fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00000003ff037819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff057819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000703047812ULL, 0x000fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fc400078e4811ULL, 0x0ffffff804047812ULL, 0x000fe400078ef800ULL,
0x0ffffff806067812ULL, 0x000fe400078ef811ULL, 0x0000000700107812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x100fe400078e0202ULL, 0x0000001006067824ULL, 0x000fc600078e0202ULL,
0x00a0000004087984ULL, 0x000f280000000c00ULL, 0x00a00000060c7984ULL, 0x0023620000000c00ULL,
0x0000000807027824ULL, 0x044fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff802037812ULL, 0x000fc400078ee203ULL,
0xfffffff807057812ULL, 0x000fe400078ee205ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000711067812ULL, 0x002fe200078ec0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078248ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff810007812ULL, 0x000fe400078ef85fULL,
0x00005b0005057a11ULL, 0x000fe400008f4c07ULL, 0x1ffffff806067812ULL, 0x000fe200078ef85fULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001006047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe20000011666ULL,
0xffffffffff027424ULL, 0x000fc800078e00ffULL, 0x0000000263007824ULL, 0x000fca00078e0200ULL,
0x000000620000720cULL, 0x000fda0003f06070ULL, 0x0000000214048824ULL, 0x000fc800078e00ffULL,
0x0000640004048a24ULL, 0x000fc800078e0200ULL, 0x0000600004048625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff267624ULL, 0x000fe200078e00ffULL,
0x0000000604028981ULL, 0x0002a2000c1e1900ULL, 0x00006900ff277624ULL, 0x000fca00078e00ffULL,
0x0000000626267981ULL, 0x000762000c1e9900ULL, 0x0000000163067810ULL, 0x000fe20007ffe0ffULL,
0x0000004066037824ULL, 0x000fe400078e00ffULL, 0x0000008067677824ULL, 0x000fe200078e00ffULL,
0x000000610600720cULL, 0x000fe20003f06070ULL, 0x00000100630c7824ULL, 0x000fe200078e0203ULL,
0x01060000ff047f8cULL, 0x002e62000c80043fULL, 0x0000008024247824ULL, 0x000fc600078e00ffULL,
0x0000004067187812ULL, 0x000fe200078ef80cULL, 0x0000002402197224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff167819ULL, 0x10afe40000011665ULL,
0x0000000c64067217ULL, 0x000fe40007800000ULL, 0x00000010161b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116077824ULL, 0x040fe200078e0218ULL, 0x00000008161a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001060c7824ULL, 0x000fe200078e0a0cULL, 0x00000018161c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000719077210ULL, 0x000fe20007f1e0ffULL, 0x000000011a067824ULL, 0x100fe200078e0218ULL,
0x000000300b177812ULL, 0x000fe200078ec0ffULL, 0x000000011c087824ULL, 0x000fe200078e0218ULL,
0x00000003ff0d7819ULL, 0x000fe20000011665ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005e0007097a11ULL, 0x000fc400078040ffULL, 0x0000000819087210ULL, 0x000fe40007f5e0ffULL,
0x00005f0007107a11ULL, 0x000fe200000f4410ULL, 0x000000011b077824ULL, 0x000fe200078e0218ULL,
0x0000000619067210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e0008117a11ULL, 0x000fe400078440ffULL, 0x0000000719077210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00060f7a11ULL, 0x000fc400078040ffULL,
0x000000030d0d7812ULL, 0x000fe200078e4865ULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e00070a7a11ULL, 0x040fe400078240ffULL, 0x00005f0006157a11ULL, 0x000fe400000f4415ULL,
0x00005f0007127a11ULL, 0x000fe400008f4412ULL, 0x0000000c1a00720cULL, 0x040fe20003f26070ULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000000917067210ULL, 0x000fc40007f7e0ffULL,
0x0000000c1600720cULL, 0x080fe40003f06070ULL, 0x00005f0008137a11ULL, 0x000fe200010f4413ULL,
0x000000ffff077224ULL, 0x000fe200018e0610ULL, 0x00002000660e7811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0d657812ULL, 0x000fe400078ef865ULL, 0xfffffffc1a097812ULL, 0x000fe400078ee20dULL,
0x000000170f087210ULL, 0x080fe20007f7e0ffULL, 0x0000001065657824ULL, 0x100fe200078e020eULL,
0x0000000c1b00720cULL, 0x0c0fe20003f46070ULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0x000000170a0a7210ULL, 0x000fe20007f9e0ffULL, 0x00000010090f7824ULL, 0x000fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006657faeULL, 0x0003e2000c101c46ULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0xfffffffc1b107812ULL, 0x000fe200078ee20dULL,
0x000000ffff0b7224ULL, 0x000fe200020e0612ULL, 0x0000000c1c00720cULL, 0x000fc40003f86070ULL,
0x00000000080f7faeULL, 0x0005e2000c901c46ULL, 0x0000001010107824ULL, 0x000fca00078e020eULL,
0x000000000a107faeULL, 0x0007e2000d101c46ULL, 0x0000002016097810ULL, 0x004fe20007ffe0ffULL,
0x000000041c087824ULL, 0x000fe200078e00ffULL, 0x00000030160f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c0900720cULL, 0x000fe20003f66070ULL, 0x0000000118067824ULL, 0x002fe200078e0209ULL,
0x00000028160a7810ULL, 0x048fe40007ffe0ffULL, 0x0000003816107810ULL, 0x000fe40007ffe0ffULL,
0x0000000619167210ULL, 0x000fe20007f1e0ffULL, 0x00000001180b7824ULL, 0x040fe200078e020aULL,
0x0000001711067210ULL, 0x000fe20007fbe0ffULL, 0x0000000118117824ULL, 0x000fe200078e0210ULL,
0x00005e0016127a11ULL, 0x000fe200078c40ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0xfffffffc08087812ULL, 0x000fc400078ee20dULL, 0x0000000c0a00720cULL, 0x080fe40003f46070ULL,
0x00005f0016167a11ULL, 0x000fe200030f4407ULL, 0x000000ffff077224ULL, 0x000fe200028e0613ULL,
0x0000000b19157210ULL, 0x000fe20007fbe0ffULL, 0x0000001008087824ULL, 0x000fe200078e020eULL,
0x0000000c0f00720cULL, 0x080fe40003f26070ULL, 0x0000000c1000720cULL, 0x000fe20003f06070ULL,
0x00000001180c7824ULL, 0x000fe200078e020fULL, 0x0000000006087faeULL, 0x0003e2000e101c46ULL,
0x0000001119117210ULL, 0x000fc60007fde0ffULL, 0x0000000c190b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000409067824ULL, 0x002fe400078e00ffULL, 0x000000040a077824ULL, 0x000fe400078e00ffULL,
0x000000040f087824ULL, 0x000fe200078e00ffULL, 0xfffffffc06067812ULL, 0x100fe200078ee20dULL,
0x0000000410097824ULL, 0x000fe200078e00ffULL, 0xfffffffc07077812ULL, 0x100fe400078ee20dULL,
0xfffffffc08087812ULL, 0x000fc400078ee20dULL, 0xfffffffc09097812ULL, 0x000fe200078ee20dULL,
0x00000010060d7824ULL, 0x100fe400078e020eULL, 0x000000ffff067224ULL, 0x000fe200028e06ffULL,
0x00005e0015137a11ULL, 0x000fe200078a40ffULL, 0x00000010070f7824ULL, 0x100fe400078e020eULL,
0x0000001008107824ULL, 0x000fe200078e020eULL, 0x00005f0015157a11ULL, 0x000fe200028f4406ULL,
0x00000010090e7824ULL, 0x000fe200078e020eULL, 0x0000001712067210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078840ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e00110c7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff077224ULL, 0x000fe200028e0616ULL, 0x0000001713087210ULL, 0x000fc40007fbe0ffULL,
0x00005f000b0b7a11ULL, 0x000fe400020f4412ULL, 0x00005f0011117a11ULL, 0x000fe200030f4409ULL,
0x000000ffff097224ULL, 0x000fe200028e0615ULL, 0x000000170a0a7210ULL, 0x080fe20007f9e0ffULL,
0x00000000060d7faeULL, 0x0003e2000d901c46ULL, 0x000000170c0c7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x00000000080f7faeULL, 0x0005e8000d101c46ULL,
0x000000000a107faeULL, 0x0005e2000c901c46ULL, 0x000000ffff0d7224ULL, 0x002fca00028e0611ULL,
0x000000000c0e7faeULL, 0x0005e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001865067211ULL, 0x04afe400078ff0ffULL, 0x0000001065077811ULL, 0x000fe400078ff0ffULL,
0x0000000619067210ULL, 0x000fe40007f1e0ffULL, 0x00000008651f7811ULL, 0x040fe200078ff0ffULL,
0x0000000118087824ULL, 0x000fe200078e0207ULL, 0x0000001865097811ULL, 0x000fe200078ff0ffULL,
0x000000ffff227224ULL, 0x000fe200000e06ffULL, 0x00005e0006217a11ULL, 0x000fe200078040ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x00000020650c7811ULL, 0x000fe200078ff0ffULL,
0x00000001180a7824ULL, 0x000fe200078e0209ULL, 0x00005f0006227a11ULL, 0x000fe200000f4422ULL,
0x000000011f067824ULL, 0x000fe200078e0218ULL, 0x00000028650e7811ULL, 0x040fe200078ff0ffULL,
0x00000001180d7824ULL, 0x000fe200078e020cULL, 0x0000003065107811ULL, 0x000fc400078ff0ffULL,
0x00000003ff157819ULL, 0x100fe20000011665ULL, 0x00000001180f7824ULL, 0x000fe200078e020eULL,
0x00000008191e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000409087824ULL, 0x000fe200078e00ffULL,
0x0000003865127811ULL, 0x000fe200078ff0ffULL, 0x000000040c097824ULL, 0x000fe200078e00ffULL,
0x0000000619207210ULL, 0x000fe20007fde0ffULL, 0x000000041f067824ULL, 0x000fe200078e00ffULL,
0x0000000a19167210ULL, 0x000fe20007f1e0ffULL, 0x000000040e0a7824ULL, 0x000fe200078e00ffULL,
0x0000000315157812ULL, 0x000fe200078e4865ULL, 0x00000004100c7824ULL, 0x000fe200078e00ffULL,
0x0000000d191d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000118117824ULL, 0x000fe200078e0210ULL,
0x00002000661a7811ULL, 0x000fe200078e68ffULL, 0x0000000118137824ULL, 0x000fe200078e0212ULL,
0xfffffffc07077812ULL, 0x100fe200078ee215ULL, 0x00000004120d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc08087812ULL, 0x100fe200078ee215ULL, 0x000000ffff0e7224ULL, 0x000fe200030e06ffULL,
0xfffffffc06067812ULL, 0x000fc400078ee215ULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee215ULL,
0xfffffffc0c0c7812ULL, 0x000fe400078ee215ULL, 0x00005e00201f7a11ULL, 0x000fe200078c40ffULL,
0x000000100a187824ULL, 0x100fe200078e021aULL, 0x00000011191b7210ULL, 0x000fe20007f7e0ffULL,
0x0000001007117824ULL, 0x100fe200078e021aULL, 0x0000001319177210ULL, 0x000fe20007f9e0ffULL,
0x0000001008137824ULL, 0x100fe200078e021aULL, 0x0ffffffc15657812ULL, 0x000fe200078ef865ULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0xfffffffc09097812ULL, 0x100fe200078ee215ULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x0000000f191c7210ULL, 0x000fe20007f5e0ffULL,
0x00000010060f7824ULL, 0x100fe200078e021aULL, 0xfffffffc0d0d7812ULL, 0x000fe200078ee215ULL,
0x000000100c197824ULL, 0x000fe200078e021aULL, 0x00005f0020207a11ULL, 0x000fe200030f440eULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e001e0a7a11ULL, 0x000fe200078a40ffULL,
0x0000001065657824ULL, 0x100fe200078e021aULL, 0x00005e00160c7a11ULL, 0x000fe200078040ffULL,
0x0000001009157824ULL, 0x100fe200078e021aULL, 0x00005e001d0e7a11ULL, 0x000fe200078240ffULL,
0x000000100d1a7824ULL, 0x000fe200078e021aULL, 0x000000300b0b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005f001e1e7a11ULL, 0x000fe200028f4408ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005f00160d7a11ULL, 0x000fe200000f4407ULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005f001d1d7a11ULL, 0x000fc400008f4406ULL,
0x00005e0017167a11ULL, 0x000fe400078640ffULL, 0x000000210b067210ULL, 0x000fe40007f1e0ffULL,
0x00005e001b127a11ULL, 0x000fe400078440ffULL, 0x00005e001c107a11ULL, 0x000fe400078240ffULL,
0x00005f0017177a11ULL, 0x000fe200018f4407ULL, 0x000000ffff077224ULL, 0x000fe200000e0622ULL,
0x00005f001b1b7a11ULL, 0x000fc400010f4408ULL, 0x0000001f0b087210ULL, 0x040fe40007f1e0ffULL,
0x00005f001c1c7a11ULL, 0x000fe200008f4409ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006657faeULL, 0x0003e2000b901c46ULL, 0x0000000a0b0a7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0620ULL, 0x0000000c0b0c7210ULL, 0x040fe40007f5e0ffULL,
0x0000000e0b0e7210ULL, 0x040fe40007f7e0ffULL, 0x000000100b107210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x000000120b127210ULL, 0x040fe20007fbe0ffULL,
0x00000000080f7faeULL, 0x0005e2000b901c46ULL, 0x000000160b167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0b7224ULL, 0x000fc800008e061eULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000000a117faeULL, 0x0007e8000b901c46ULL, 0x000000000c137faeULL, 0x0009e2000b901c46ULL,
0x000000ffff0f7224ULL, 0x004fca00018e061dULL, 0x000000000e157faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x008fe400020e061cULL, 0x000000ffff137224ULL, 0x010fc600028e061bULL,
0x0000000010187faeULL, 0x0003e8000b901c46ULL, 0x0000000012197faeULL, 0x0003e8000b901c46ULL,
0x00000000161a7faeULL, 0x0003e4000b901c46ULL, 0x01060400ff067984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000006ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002e4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x008fe40003800000ULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002066047824ULL, 0x002fc800078e0204ULL,
0x0000002004067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000001e006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105087812ULL, 0x044fe400078efcffULL, 0x0000000705077812ULL, 0x140fe400078e7804ULL,
0x0000000708087812ULL, 0x000fe400078e7804ULL, 0x0000001005097810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001105057810ULL, 0x000fe20007ffe0ffULL,
0x0000000106087824ULL, 0x000fe200078e0208ULL, 0x0000000709097812ULL, 0x000fc400078e7804ULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000000705057812ULL, 0x000fe400078e7804ULL,
0x0000000106097824ULL, 0x040fe200078e0209ULL, 0x00000000080c7984ULL, 0x000ea4000000cc00ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x000000ffff187224ULL, 0x002fe400078e0010ULL,
0x000000ffff197224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x004fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0013ULL, 0x0000001807007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1f7224ULL, 0x000fca00078e000fULL,
0x0000001c08007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x0000000009107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000eULL,
0x000000ffff227224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff207224ULL, 0x004fe400078e0010ULL, 0x000000ffff217224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002009007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff047f8cULL, 0x002fe8000c80043fULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x0000000600077305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x000000070000735dULL, 0x004fe40003800000ULL, 0x01060400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000616300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000257919ULL, 0x000e620000000000ULL, 0x3d80000026267820ULL, 0x020fe20000410000ULL,
0x0001068866287811ULL, 0x000fe200078e18ffULL, 0x0000640014277a24ULL, 0x000fe200078e02ffULL,
0xffffffff61297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x00010608662a7811ULL, 0x000fe400078e28ffULL, 0x00000100632c7824ULL, 0x000fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002c6400720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x03cfea0003800000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002bULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff2d7224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x000000012d307810ULL, 0x000fe20007ffe0ffULL,
0x00000d9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fc400078e002dULL,
0x00000002ff2b7819ULL, 0x100fe20000011630ULL, 0x00000024023f7224ULL, 0x020fe200078e02ffULL,
0x000000043000780cULL, 0x040fe20003f06070ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0030ULL,
0x00000003304f7812ULL, 0x000fe200078ec0ffULL, 0x000003002b2b7a24ULL, 0x000fc800078e0263ULL,
0x000001002b407824ULL, 0x040fe200078e0203ULL, 0x000000012b317810ULL, 0x000fe40007ffe0ffULL,
0x000000012f2b7812ULL, 0x000fe400078e0cffULL, 0x000000613100720cULL, 0x000fe40003f26070ULL,
0x0000004040317812ULL, 0x000fca00078ec0ffULL, 0x00000001673a7824ULL, 0x000fcc00078e0231ULL,
0x000006b000009947ULL, 0x000fea0003800000ULL, 0x00000002ff3b7819ULL, 0x002fe20000011625ULL,
0x0000000266427824ULL, 0x000fe200078e022bULL, 0x0000004064317217ULL, 0x000fe40007800000ULL,
0x000000103b497810ULL, 0x040fe20007ffe0ffULL, 0x000000013b307824ULL, 0x040fe200078e023aULL,
0x000000083b417810ULL, 0x000fe20007ffe0ffULL, 0x0000000131407824ULL, 0x000fe200078e0a40ULL,
0x000000183b4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000149337824ULL, 0x100fe200078e023aULL,
0x000000303f387210ULL, 0x000fe20007f3e0ffULL, 0x0000000141327824ULL, 0x000fe200078e023aULL,
0x000000203b4b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000441447824ULL, 0x000fe200078e00ffULL,
0x000000333f357210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x000000323f377210ULL, 0x000fc40007f5e0ffULL, 0x00005e0038307a11ULL, 0x000fe200078240ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078640ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x00005e0037327a11ULL, 0x000fe400078440ffULL,
0x00005f0035357a11ULL, 0x000fe200018f4436ULL, 0x000000014a367824ULL, 0x000fe200078e023aULL,
0x000000283b4c7810ULL, 0x040fe40007ffe0ffULL, 0x000000303b4d7810ULL, 0x000fc40007ffe0ffULL,
0x000000383b4e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0038317a11ULL, 0x000fe200008f4439ULL,
0x000000014c387824ULL, 0x100fe200078e023aULL, 0x00005f0037337a11ULL, 0x000fe200010f4433ULL,
0x000000014b377824ULL, 0x100fe200078e023aULL, 0x000000363f3e7210ULL, 0x000fe20007f3e0ffULL,
0x000000014d397824ULL, 0x100fe200078e023aULL, 0x000000403b00720cULL, 0x000fe20003f46070ULL,
0x000000014e3a7824ULL, 0x000fe200078e023aULL, 0x000000373f3c7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x000000383f3b7210ULL, 0x000fc40007fde0ffULL,
0x00000003ff387819ULL, 0x100fe40000011625ULL, 0x00005e003e367a11ULL, 0x000fe200078240ffULL,
0x000000ffff477224ULL, 0x000fe200030e06ffULL, 0x000000393f3d7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200028e06ffULL, 0x0000003a3f3f7210ULL, 0x000fe20007f7e0ffULL,
0x000000044f3a7824ULL, 0x000fe200078e00ffULL, 0x0000000338487812ULL, 0x000fe200078e4825ULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005f003e377a11ULL, 0x000fe200008f4437ULL,
0x000000ffff457224ULL, 0x000fe200018e06ffULL, 0x000000404100720cULL, 0x000fc40003f26070ULL,
0x0000200042427811ULL, 0x000fe400078e60ffULL, 0x0ffffffc48437812ULL, 0x100fe400078ef825ULL,
0xfffffffc3a417812ULL, 0x000fe400078ee225ULL, 0xfffffffc44447812ULL, 0x000fe200078ee248ULL,
0x0000001043437824ULL, 0x000fe200078e0242ULL, 0x00005e003c387a11ULL, 0x000fe200078a40ffULL,
0x0000001041307825ULL, 0x000fe200078e0030ULL, 0x00005e003f3e7a11ULL, 0x000fc400078840ffULL,
0x00005f003c397a11ULL, 0x000fe200028f4439ULL, 0x0000001044447824ULL, 0x000fe200078e0242ULL,
0x00005e003b3a7a11ULL, 0x000fe200078a40ffULL, 0x0000001041327825ULL, 0x000fe200078e0032ULL,
0x00005e003d3c7a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030437faeULL, 0x0003e2000d101c46ULL, 0x00005f003b3b7a11ULL, 0x000fe400028f4447ULL,
0x00005f003d3d7a11ULL, 0x000fe200018f4446ULL, 0x0000000032447faeULL, 0x0005e2000c901c46ULL,
0x00005f003f3f7a11ULL, 0x000fe200020f4445ULL, 0x000000044c457824ULL, 0x000fe200078e00ffULL,
0x000000404900720cULL, 0x080fe20003f26070ULL, 0x000000044d467824ULL, 0x000fe200078e00ffULL,
0x000000404a00720cULL, 0x000fc40003f46070ULL, 0x000000404b00720cULL, 0x080fe20003f66070ULL,
0x000000044a437824ULL, 0x002fe200078e00ffULL, 0x000000404c00720cULL, 0x080fe20003f86070ULL,
0x0000001041307825ULL, 0x000fe200078e0034ULL, 0x000000404d00720cULL, 0x080fe40003fa6070ULL,
0x000000404e00720cULL, 0x040fe20003fc6070ULL, 0x0000000449407824ULL, 0x000fe200078e00ffULL,
0xfffffffc43437812ULL, 0x100fe200078ee248ULL, 0x000000044b447824ULL, 0x004fe200078e00ffULL,
0xfffffffc45457812ULL, 0x100fe200078ee248ULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc40407812ULL, 0x000fe200078ee248ULL, 0x0000001043437824ULL, 0x000fe200078e0242ULL,
0xfffffffc44447812ULL, 0x000fe200078ee248ULL, 0x0000001041327825ULL, 0x000fe200078e0036ULL,
0xfffffffc46467812ULL, 0x000fc400078ee248ULL, 0xfffffffc4e487812ULL, 0x000fe200078ee248ULL,
0x0000001040407824ULL, 0x100fe400078e0242ULL, 0x0000001044447824ULL, 0x000fe400078e0242ULL,
0x0000001041347825ULL, 0x000fe200078e0038ULL, 0x0000000030407faeULL, 0x0003e6000c901c46ULL,
0x0000001045457824ULL, 0x000fe200078e0242ULL, 0x0000000032437faeULL, 0x0003e2000d101c46ULL,
0x0000001041367825ULL, 0x000fc600078e003aULL, 0x0000000034447faeULL, 0x0003e2000d901c46ULL,
0x0000001046467824ULL, 0x000fe400078e0242ULL, 0x0000001041387825ULL, 0x040fe200078e003cULL,
0x0000000036457faeULL, 0x0003e6000e101c46ULL, 0x0000001048427824ULL, 0x000fe200078e0242ULL,
0x0000000038467faeULL, 0x0003e2000e901c46ULL, 0x00000010413a7825ULL, 0x000fca00078e003eULL,
0x000000003a427faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000000825367811ULL, 0x002fe200078ff0ffULL, 0x000000044f4b7824ULL, 0x000fe200078e00ffULL,
0x0000003a25307211ULL, 0x040fe400078ff0ffULL, 0x0000001025377811ULL, 0x000fe200078ff0ffULL,
0x0000000136317824ULL, 0x040fe200078e023aULL, 0x000000303f357210ULL, 0x000fe20007f3e0ffULL,
0x0000000436407824ULL, 0x000fe200078e00ffULL, 0x0000001825387811ULL, 0x000fe200078ff0ffULL,
0x0000000437417824ULL, 0x000fe200078e00ffULL, 0x000000313f337210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00005e0035307a11ULL, 0x000fe200078240ffULL,
0x0000000438427824ULL, 0x000fe200078e00ffULL, 0x00000028253c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff347224ULL, 0x000fe200010e06ffULL, 0x00005e0033327a11ULL, 0x000fc400078440ffULL,
0x00005f0035317a11ULL, 0x000fe200008f4431ULL, 0x000000043c447824ULL, 0x000fe200078e00ffULL,
0x00005f0033337a11ULL, 0x000fe200010f4434ULL, 0x0000000266347824ULL, 0x000fe200078e022bULL,
0x00000003ff357819ULL, 0x100fe40000011625ULL, 0x0000002025397811ULL, 0x000fe400078ff0ffULL,
0x0000200034467811ULL, 0x000fe200078e60ffULL, 0x0000000137347824ULL, 0x100fe200078e023aULL,
0x00000030253d7811ULL, 0x040fe200078ff0ffULL, 0x000000013c377824ULL, 0x100fe200078e023aULL,
0x00000038253e7811ULL, 0x000fe200078ff0ffULL, 0x0000000139367824ULL, 0x100fe200078e023aULL,
0x00000003353b7812ULL, 0x000fe200078e4825ULL, 0x0000000138357824ULL, 0x100fe200078e023aULL,
0x000000343f3c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000439437824ULL, 0x000fe200078e00ffULL,
0xfffffffc40407812ULL, 0x100fe200078ee23bULL, 0x000000043d457824ULL, 0x000fe200078e00ffULL,
0xfffffffc41417812ULL, 0x100fe200078ee23bULL, 0x000000043e477824ULL, 0x000fe200078e00ffULL,
0xfffffffc42427812ULL, 0x100fe200078ee23bULL, 0x000000013d387824ULL, 0x100fe200078e023aULL,
0xfffffffc43437812ULL, 0x100fe200078ee23bULL, 0x000000013e397824ULL, 0x000fe200078e023aULL,
0x000000353f3a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff357224ULL, 0x000fe200018e06ffULL,
0xfffffffc44447812ULL, 0x100fe200078ee23bULL, 0x0000001040407824ULL, 0x100fe200078e0246ULL,
0xfffffffc45457812ULL, 0x100fe200078ee23bULL, 0x0000001041417824ULL, 0x100fe200078e0246ULL,
0xfffffffc47477812ULL, 0x000fe200078ee23bULL, 0x0000001042427824ULL, 0x100fe200078e0246ULL,
0x0ffffffc3b3e7812ULL, 0x100fe200078ef825ULL, 0x0000001043437824ULL, 0x100fe200078e0246ULL,
0x000000363f4a7210ULL, 0x040fe20007f3e0ffULL, 0x0000001044447824ULL, 0x100fe200078e0246ULL,
0x000000373f3b7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff377224ULL, 0x000fe200010e06ffULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee225ULL, 0x000000103e4c7824ULL, 0x100fe200078e0246ULL,
0x000000383f3d7210ULL, 0x000fe20007f9e0ffULL, 0x0000001045457824ULL, 0x000fe200078e0246ULL,
0x00005e003a367a11ULL, 0x000fe200078440ffULL, 0x000000ffff497224ULL, 0x000fe200018e06ffULL,
0x00005e003c347a11ULL, 0x000fe200078c40ffULL, 0x000000104b307825ULL, 0x000fe200078e0030ULL,
0x000000393f3f7210ULL, 0x000fc40007fbe0ffULL, 0x00005f003a377a11ULL, 0x000fe200010f4437ULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x00005e004a387a11ULL, 0x000fe200078240ffULL,
0x0000001047467824ULL, 0x000fe200078e0246ULL, 0x00005f003c357a11ULL, 0x000fe200030f4435ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe200078440ffULL,
0x000000ffff477224ULL, 0x000fe200028e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000304c7faeULL, 0x0003e2000b901c46ULL,
0x00005e003f3e7a11ULL, 0x000fc400078840ffULL, 0x00005f004a397a11ULL, 0x000fe400008f4439ULL,
0x00005f003b3b7a11ULL, 0x000fe400010f4449ULL, 0x00005f003d3d7a11ULL, 0x000fe400018f4448ULL,
0x00005f003f3f7a11ULL, 0x000fe200020f4447ULL, 0x000000104b307825ULL, 0x002fc800078e0032ULL,
0x000000104b327825ULL, 0x040fe200078e0034ULL, 0x0000000030407faeULL, 0x0003e6000b901c46ULL,
0x000000104b347825ULL, 0x040fe200078e0036ULL, 0x0000000032417faeULL, 0x0003e6000b901c46ULL,
0x000000104b367825ULL, 0x040fe200078e0038ULL, 0x0000000034427faeULL, 0x0003e6000b901c46ULL,
0x000000104b387825ULL, 0x040fe200078e003aULL, 0x0000000036437faeULL, 0x0003e6000b901c46ULL,
0x000000104b3a7825ULL, 0x040fe200078e003cULL, 0x0000000038447faeULL, 0x0003e6000b901c46ULL,
0x000000104b3c7825ULL, 0x000fe200078e003eULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x000000003c467faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000034f00780cULL, 0x000fe20003f25270ULL, 0x000000b000007945ULL, 0x000fd80003800000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x00000300ff027624ULL, 0x000fc800078e00ffULL,
0x0000000202007824ULL, 0x000fe400078e0200ULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000620000720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000227307824ULL, 0x002fe400078e0200ULL, 0x00000004ff317424ULL, 0x000fc800078e00ffULL,
0x0000600030307625ULL, 0x000fca00078e0031ULL, 0x0000000630027981ULL, 0x000364000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020253f7810ULL, 0x040fe20007ffe0ffULL, 0x00000002663e7824ULL, 0x000fe200078e022fULL,
0xfffffff825307812ULL, 0x002fe200078ec0ffULL, 0x000000082e2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x00000007302f7812ULL, 0x100fe400078ef825ULL, 0x000000073f3f7812ULL, 0x000fe400078ef825ULL,
0x00000007253d7812ULL, 0x000fc400078ec0ffULL, 0x00000001ff407819ULL, 0x000fe4000001162fULL,
0x00000001ff417819ULL, 0x000fe4000001163fULL, 0x000020003e3e7811ULL, 0x000fe400078e60ffULL,
0x000000083d3d7812ULL, 0x000fe400078ef825ULL, 0x0000000340407812ULL, 0x000fe400078ec0ffULL,
0x0000000341417812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003c40307212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003c41347212ULL, 0x000fc600078e3cffULL, 0x000000042f307824ULL, 0x000fe400078e0230ULL,
0x000000043f347824ULL, 0x000fe400078e0234ULL, 0x0000001030307824ULL, 0x100fe400078e023eULL,
0x0000001034347824ULL, 0x000fc800078e023eULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000018ff387819ULL, 0x002fe20000011430ULL,
0x0001000030397824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe40000011433ULL,
0x00000038004e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff457819ULL, 0x004fc40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff447819ULL, 0x000fe40000011435ULL,
0x00000018ff437819ULL, 0x000fe20000011436ULL, 0x00000039004d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x002fe40000011431ULL, 0x00000018ff427819ULL, 0x000fca0000011437ULL,
0x0000003800527306ULL, 0x0003f00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x002fce0000011432ULL, 0x0000003800567306ULL, 0x0003f00000200c00ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000888030387816ULL, 0x042fe200000000ffULL,
0x0000010030307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x00000038004c7306ULL, 0x0002b00000200c00ULL, 0x00000030004f7306ULL, 0x0007220000200c00ULL,
0x0000888031387816ULL, 0x002fc400000000ffULL, 0x000054104c4c7816ULL, 0x004fc6000000004dULL,
0x000000ffff307224ULL, 0x008fe400078e0038ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0001000031387824ULL, 0x040fe400078e00ffULL, 0x0000010031317824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000003000507306ULL, 0x0003e20000200c00ULL, 0x000054104f4d7816ULL, 0x010fce000000004eULL,
0x0000003100537306ULL, 0x0005e20000200c00ULL, 0x0000888032307816ULL, 0x002fce00000000ffULL,
0x0000003000547306ULL, 0x0003e20000200c00ULL, 0x0001000032317824ULL, 0x044fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x0000003800517306ULL, 0x000ea20000200c00ULL,
0x0000888033307816ULL, 0x002fce00000000ffULL, 0x0000003100557306ULL, 0x0002f00000200c00ULL,
0x0000003200577306ULL, 0x0008e20000200c00ULL, 0x0001000033317824ULL, 0x042fe200078e00ffULL,
0x0000541050507816ULL, 0x004fe20000000051ULL, 0x0000010033337824ULL, 0x000fe200078e00ffULL,
0x0000541053517816ULL, 0x000fc40000000052ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000003000587306ULL, 0x0003e20000200c00ULL,
0x000000013c327810ULL, 0x010fe40007ffe0ffULL, 0x0000541054547816ULL, 0x008fe40000000055ULL,
0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL, 0x0000541057557816ULL, 0x000fe20000000056ULL,
0x0000003100597306ULL, 0x0004e20000200c00ULL, 0x0000888034307816ULL, 0x002fc400000000ffULL,
0x000000043c00780cULL, 0x000fca0003f25270ULL, 0x00000033005a7306ULL, 0x000e620000200c00ULL,
0x0001000034317824ULL, 0x044fe400078e00ffULL, 0x0000010034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x00000030005b7306ULL, 0x0005e20000200c00ULL, 0x0000541058587816ULL, 0x008fe40000000059ULL,
0x000054105a597816ULL, 0x002fca0000000046ULL, 0x00000031005c7306ULL, 0x0002e20000200c00ULL,
0x0000888035307816ULL, 0x004fce00000000ffULL, 0x00000034005d7306ULL, 0x0005220000200c00ULL,
0x0000003240317212ULL, 0x082fe400078e3cffULL, 0x0000003241327212ULL, 0x000fc600078e3cffULL,
0x000000042f337824ULL, 0x000fe400078e0231ULL, 0x0001000035317824ULL, 0x000fe200078e00ffULL,
0x0000888037347816ULL, 0x004fe200000000ffULL, 0x0000001033337824ULL, 0x000fe200078e023eULL,
0x00000030005e7306ULL, 0x0003e20000200c00ULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x000000043f327824ULL, 0x000fe200078e0232ULL,
0x000000003338783bULL, 0x000ea20000000200ULL, 0x000054105b5c7816ULL, 0x008fc4000000005cULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x00000034006a7306ULL, 0x000fe20000200c00ULL,
0x0000888036307816ULL, 0x002fe200000000ffULL, 0x0000001032327824ULL, 0x000fe200078e023eULL,
0x000054105d5d7816ULL, 0x010fca0000000045ULL, 0x0000003500607306ULL, 0x0003f00000200c00ULL,
0x00000031005f7306ULL, 0x0007220000200c00ULL, 0x0001000037357824ULL, 0x042fe400078e00ffULL,
0x0000010037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0001000036317824ULL, 0x048fe200078e00ffULL,
0x00000035006b7306ULL, 0x0004620000200c00ULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003000657306ULL, 0x000fe20000200c00ULL, 0x000054105e5e7816ULL, 0x010fe2000000005fULL,
0x0001000038357824ULL, 0x004fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011438ULL,
0x000088803a757816ULL, 0x000fe400000000ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x00000034006f7306ULL, 0x0005e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc4000001143bULL,
0x00005410605f7816ULL, 0x000fe40000000044ULL, 0x000054106a6a7816ULL, 0x002fc6000000006bULL,
0x0000003600697306ULL, 0x0003e20000200c00ULL, 0x00000018ff347819ULL, 0x004fce0000011439ULL,
0x0000003400737306ULL, 0x0005e20000200c00ULL, 0x0001000039367824ULL, 0x002fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x00000035006e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x004fce000001143aULL, 0x0000003400777306ULL, 0x0005e20000200c00ULL,
0x0000888039357816ULL, 0x042fe200000000ffULL, 0x0000010039397824ULL, 0x000fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003100687306ULL, 0x0002e20000200c00ULL,
0x0000888038347816ULL, 0x044fe200000000ffULL, 0x0000010038387824ULL, 0x000fcc00078e00ffULL,
0x00000034006d7306ULL, 0x0005220000200c00ULL, 0x000000003230783bULL, 0x002e6e0000000200ULL,
0x00000037006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x004fe40000011438ULL,
0x0000002e25387211ULL, 0x000fc400078fe0ffULL, 0x0000541065687816ULL, 0x008fe40000000068ULL,
0x000000042e2e7810ULL, 0x000fe20007ffe0ffULL, 0x0000003400707306ULL, 0x0004e20000200c00ULL,
0x000054106d6e7816ULL, 0x010fce000000006eULL, 0x0000003500717306ULL, 0x000fe20000200c00ULL,
0x0000000738347812ULL, 0x044fe400078e783dULL, 0x0000000238387810ULL, 0x000fc60007ffe0ffULL,
0x000000203d347824ULL, 0x040fe200078e0234ULL, 0x0000000738387812ULL, 0x000fe200078e783dULL,
0x0000003600727306ULL, 0x0005e20000200c00ULL, 0x00005410706f7816ULL, 0x008fe2000000006fULL,
0x0000001034347824ULL, 0x000fe400078e00ffULL, 0x000000203d387824ULL, 0x000fc800078e0238ULL,
0x0000003900747306ULL, 0x0007e20000200c00ULL, 0x000000003434783bULL, 0x004ea20000000200ULL,
0x00008880314e7816ULL, 0x042fe200000000ffULL, 0x0000001038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011431ULL, 0x0000888032447816ULL, 0x000fe200000000ffULL,
0x000000ffff467224ULL, 0x000fe200078e004eULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000000ffff397224ULL, 0x008fe200078e0075ULL, 0x00000018ff4a7819ULL, 0x000fe20000011430ULL,
0x000100003a757824ULL, 0x040fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011432ULL,
0x000001003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011433ULL,
0x00010000314e7824ULL, 0x040fe200078e00ffULL, 0x0000003900767306ULL, 0x0007e20000200c00ULL,
0x0000010031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fc4000001143aULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003a00787306ULL, 0x0008a20000200c00ULL, 0x000088803b397816ULL, 0x008fe400000000ffULL,
0x0000541069697816ULL, 0x002fe20000000043ULL, 0x0001000032437824ULL, 0x040fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000010032327824ULL, 0x000fe200078e00ffULL,
0x0000541071727816ULL, 0x000fe20000000072ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x000100003b3a7824ULL, 0x050fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011432ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000003900797306ULL, 0x0007e20000200c00ULL,
0x0000004c3404723cULL, 0x044fe20000001804ULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000541074737816ULL, 0x000fe40000000073ULL, 0x0000541078777816ULL, 0x000fe40000000077ULL,
0x0000003a007a7306ULL, 0x0005220000200c00ULL, 0x0000888030397816ULL, 0x008fe200000000ffULL,
0x000000503408723cULL, 0x000fe20000001808ULL, 0x000054106c6b7816ULL, 0x002fca0000000042ULL,
0x00000039004c7306ULL, 0x0003e20000200c00ULL, 0x00010000303a7824ULL, 0x044fe200078e00ffULL,
0x00000054340c723cULL, 0x040fe8000000180cULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000003b007b7306ULL, 0x000fe20000200c00ULL, 0x0000010030397824ULL, 0x002fe200078e00ffULL,
0x000000583410723cULL, 0x000fe20000001810ULL, 0x00005410797a7816ULL, 0x010fc6000000007aULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003a00307306ULL, 0x000e640000200c00ULL,
0x0000005c3414723cULL, 0x040fec0000001814ULL, 0x00000039004d7306ULL, 0x0005e40000200c00ULL,
0x0000005e3418723cULL, 0x040fec0000001818ULL, 0x00000031004f7306ULL, 0x0007e20000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x00000068341c723cULL, 0x000fe2000000181cULL,
0x000054104c307816ULL, 0x002fca0000000030ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000ffff317224ULL, 0x008fe200078e0044ULL, 0x0000006a3420723cULL, 0x000fec0000001820ULL,
0x0000003100447306ULL, 0x0007e20000200c00ULL, 0x0001000033347824ULL, 0x000fca00078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000004a004a7306ULL, 0x000f220000200c00ULL,
0x0000888033317816ULL, 0x048fe200000000ffULL, 0x0000010033337824ULL, 0x000fe200078e00ffULL,
0x000054107b7b7816ULL, 0x002fc8000000004bULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000003100357306ULL, 0x0009f00000200c00ULL, 0x0000003400347306ULL, 0x000e620000200c00ULL,
0x000054104d317816ULL, 0x010fe2000000004aULL, 0x0000006e3804723cULL, 0x044fec0000001804ULL,
0x0000004900497306ULL, 0x000ea40000200c00ULL, 0x000000723808723cULL, 0x040fec0000001808ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000541035347816ULL, 0x002fe20000000034ULL,
0x0000007a3810723cULL, 0x040fec0000001810ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x000054104f4f7816ULL, 0x004fe20000000049ULL, 0x000000303814723cULL, 0x000fec0000001814ULL,
0x0000007500757306ULL, 0x000e700000200c00ULL, 0x0000004600467306ULL, 0x000ff00000200c00ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541076767816ULL, 0x002fce0000000075ULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x00000076380c723cULL, 0x000fee000000180cULL,
0x0000003200327306ULL, 0x000ee20000200c00ULL, 0x00005410464e7816ULL, 0x004fce000000004eULL,
0x0000003300337306ULL, 0x000ea20000200c00ULL, 0x0000541044447816ULL, 0x002fe20000000043ULL,
0x0000004e3818723cULL, 0x000fe20000001818ULL, 0x0000541032457816ULL, 0x008fce0000000048ULL,
0x00000044381c723cULL, 0x000fe2000000181cULL, 0x0000541033357816ULL, 0x004fce0000000047ULL,
0x000000343820723cULL, 0x000fe20000001820ULL, 0xfffff0c000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e002bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe0f000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000282e7f8cULL, 0x000fe2000c80043fULL, 0x0000001226367220ULL, 0x040fe40000410000ULL,
0x0000001326377220ULL, 0x040fe20000410000ULL, 0x00000400282d7984ULL, 0x000e620000000800ULL,
0x0000001426127220ULL, 0x040fe40000410000ULL, 0x0000001526137220ULL, 0x040fe40000410000ULL,
0x0000000626307220ULL, 0x000fc40000410000ULL, 0x0000000726317220ULL, 0x040fe40000410000ULL,
0x0000000a26327220ULL, 0x040fe40000410000ULL, 0x0000000b26337220ULL, 0x040fe40000410000ULL,
0x0000000e26347220ULL, 0x040fe40000410000ULL, 0x0000001826147220ULL, 0x040fe40000410000ULL,
0x0000001926157220ULL, 0x000fc40000410000ULL, 0x0000000426047220ULL, 0x040fe40000410000ULL,
0x0000000526057220ULL, 0x040fe40000410000ULL, 0x0000000826087220ULL, 0x040fe40000410000ULL,
0x0000000926097220ULL, 0x040fe40000410000ULL, 0x0000000c26067220ULL, 0x040fe40000410000ULL,
0x0000000d26077220ULL, 0x000fc40000410000ULL, 0x0000000f26357220ULL, 0x040fe40000410000ULL,
0x0000001626387220ULL, 0x040fe40000410000ULL, 0x0000001726397220ULL, 0x040fe40000410000ULL,
0x0000001a26187220ULL, 0x040fe40000410000ULL, 0x0000001b26197220ULL, 0x040fe20000410000ULL,
0x800000002dff7812ULL, 0x002fe2000780482fULL, 0x0000001e263a7220ULL, 0x000fc40000410000ULL,
0x0000001f263b7220ULL, 0x040fe40000410000ULL, 0x0000001c26167220ULL, 0x040fe40000410000ULL,
0x0000001d26177220ULL, 0x040fe40000410000ULL, 0x00000020261a7220ULL, 0x040fe40000410000ULL,
0x00000021261b7220ULL, 0x040fe40000410000ULL, 0x00000022263c7220ULL, 0x000fc40000410000ULL,
0x00000023263d7220ULL, 0x000fe40000410000ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0030ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0031ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0032ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0033ULL, 0x000000ffff207224ULL, 0x000fc400078e0034ULL,
0x0000001026107220ULL, 0x040fe40000410000ULL, 0x0000001126117220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff217224ULL, 0x000fe400078e0035ULL, 0x000000ffff227224ULL, 0x000fe400078e0036ULL,
0x000000ffff237224ULL, 0x000fe400078e0037ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0038ULL,
0x000000ffff307224ULL, 0x000fe400078e0039ULL, 0x000000ffff317224ULL, 0x000fe400078e0018ULL,
0x000000ffff327224ULL, 0x000fe400078e0019ULL, 0x000000ffff337224ULL, 0x000fe400078e003aULL,
0x000000ffff347224ULL, 0x000fe200078e003bULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fc400078e003cULL,
0x000000ffff367224ULL, 0x000fe200078e003dULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0000040028057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000425197824ULL, 0x000fe200078e00ffULL,
0x000000296300720cULL, 0x000fc80003f05270ULL, 0xfffffff019187812ULL, 0x000fca00078ec0ffULL,
0x0000008066187824ULL, 0x000fca00078e0218ULL, 0x0104000018047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000225087824ULL, 0x000fe400078e00ffULL,
0x00000001642c7824ULL, 0x000fc600078e0a2cULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x00000008082e7812ULL, 0x040fe400078efcffULL,
0x0000002c0900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x0000002c2e00720cULL, 0x080fe40003f06070ULL, 0x0000002c0900720cULL, 0x000fc40003fc6070ULL,
0x00000011082e7812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x0000002c0800720cULL, 0x080fe40003f46070ULL, 0x0000002c2e00720cULL, 0x080fe40003fa6070ULL,
0x0000002c0900720cULL, 0x000fe40003f66070ULL, 0x00000009082f7812ULL, 0x000fc400078efcffULL,
0x00000019082e7812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL,
0x0000002c2f00720cULL, 0x080fe40003f86070ULL, 0x0000002c2e00720cULL, 0x080fe40003f46070ULL,
0x0000002c0900720cULL, 0x000fe40003f26070ULL, 0x00000021082e7812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000002c2e00720cULL, 0x080fe40003f06070ULL,
0x0000002c0900720cULL, 0x000fe40003f86070ULL, 0x00000029082e7812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000002c2e00720cULL, 0x000fc40003fc6070ULL,
0x0000002c0900720cULL, 0x000fe40003fa6070ULL, 0x00000031082e7812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff23237808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000002c2e00720cULL, 0x080fe40003f66070ULL, 0x0000002c0900720cULL, 0x000fc40003f46070ULL,
0x0000002c0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff30307808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff31317808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff32327808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff34347808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff35357808ULL, 0x000fc40005000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff36367808ULL, 0x000fe40004800000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0x0000000a04047209ULL, 0x004fe40007810000ULL,
0x0000001c05057209ULL, 0x000fe40007810000ULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x0000001d05057209ULL, 0x000fc40007810000ULL, 0x0000000c04047209ULL, 0x000fe40007810000ULL,
0x0000001e05057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000001f05057209ULL, 0x000fe40007810000ULL, 0x0000000e04047209ULL, 0x000fe40007810000ULL,
0x0000002005057209ULL, 0x000fc40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000002105057209ULL, 0x000fe40007810000ULL, 0x0000001004047209ULL, 0x000fe40007810000ULL,
0x0000002205057209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fe40007810000ULL,
0x0000002305057209ULL, 0x000fc40007810000ULL, 0x0000001204047209ULL, 0x000fe40007810000ULL,
0x0000002d05057209ULL, 0x000fe40007810000ULL, 0x0000001304047209ULL, 0x000fe40007810000ULL,
0x0000003005057209ULL, 0x000fe40007810000ULL, 0x0000001404047209ULL, 0x000fe40007810000ULL,
0x0000003105057209ULL, 0x000fc40007810000ULL, 0x0000001504047209ULL, 0x000fe40007810000ULL,
0x0000003205057209ULL, 0x000fe40007810000ULL, 0x0000001604047209ULL, 0x000fe40007810000ULL,
0x0000003305057209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000003405057209ULL, 0x000fc40007810000ULL, 0x0000001a04047209ULL, 0x000fe40007810000ULL,
0x0000003505057209ULL, 0x000fe40007810000ULL, 0x0000001b042c7209ULL, 0x000fe40007810000ULL,
0x0000003605057209ULL, 0x000fe20007810000ULL, 0x00001cd27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002c047f89ULL, 0x0004e400000e0000ULL, 0x000000042c2f7209ULL, 0x008fe20007810000ULL,
0x00001d227f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006087f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007097f89ULL, 0x000e6200000e0000ULL,
0x0000000405057209ULL, 0x008fc60007810000ULL, 0x0c201f002f047f89ULL, 0x000ee200000e0000ULL,
0x0000000806067209ULL, 0x010fc60007810000ULL, 0x0c201f0005087f89ULL, 0x000f2200000e0000ULL,
0x0000000907077209ULL, 0x002fc60007810000ULL, 0x0c201f00062c7f89ULL, 0x004e6800000e0000ULL,
0x0c201f00072e7f89ULL, 0x0004a200000e0000ULL, 0x000000042f047209ULL, 0x008fe40007810000ULL,
0x0000000805057209ULL, 0x010fe40007810000ULL, 0x0000002c06067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b052c7820ULL, 0x000fe20000410000ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010808ULL, 0x000000072e077209ULL, 0x004fe20007810000ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b0d0d7823ULL, 0x000fe20000010808ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001082cULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe2000001082cULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b10107823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b14147823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b1b087823ULL, 0x000fe20000010808ULL, 0x0000001c00097308ULL, 0x000fe20000000800ULL,
0x3c003c00ff387424ULL, 0x000fc400078e00ffULL, 0x3c003c00ff397424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b20207823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082cULL,
0x0000001d001d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001082cULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc4000001082cULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001082cULL, 0x0000001e001e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b32327823ULL, 0x100fe4000001082cULL,
0x3fb8aa3b33337823ULL, 0x100fe4000001082cULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001082cULL,
0x0000001f001f7308ULL, 0x000ea20000000800ULL, 0x000000091d09723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b35357823ULL, 0x000fc4000001082cULL, 0x3fb8aa3b362c7823ULL, 0x000fc8000001082cULL,
0x00000008001b7308ULL, 0x0003f00000000800ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000a0b08723eULL, 0x002fe400000000ffULL, 0x0000000c0d0a723eULL, 0x000fc400000000ffULL,
0x0000001e1f0b723eULL, 0x004fc600000000ffULL, 0x0000000f000f7308ULL, 0x000e680000000800ULL,
0x00000038081c723cULL, 0x000fe800000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x004fce00000000ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x00000020210d723eULL, 0x002fe200000000ffULL,
0x0000000fff207424ULL, 0x000fcc00078e00ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000022230f723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000380c1c723cULL, 0x000fee000000181cULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x004fe400000000ffULL, 0xfffffffc25147812ULL, 0x000fc800078ec0ffULL,
0x0000001420207219ULL, 0x000fe200000006ffULL, 0x0000003100317308ULL, 0x000fe60000000800ULL,
0x00000000202173a1ULL, 0x000ea200000e8000ULL, 0x00000000200473c4ULL, 0x000ee80000004000ULL,
0x0000003200327308ULL, 0x000f220000000800ULL, 0x0000002d3011723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000313213723eULL, 0x010fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000000520ff7c12ULL, 0x004fe2000f804021ULL,
0x00000038101c723cULL, 0x000fec000000181cULL, 0x0000001a001a7308ULL, 0x000eb00000000800ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x000000161714723eULL, 0x002fce00000000ffULL,
0x0000003400347308ULL, 0x000e620000000800ULL, 0x0000001a1b16723eULL, 0x004fce00000000ffULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x000000333415723eULL, 0x002fe400000000ffULL, 0x000000352c17723eULL, 0x004fce00000000ffULL,
0x00000038141c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000193204008947ULL, 0x008fde000b800000ULL, 0x001c1fff1c1c7589ULL, 0x0002a400000e0000ULL,
0x00000000201a73a1ULL, 0x000ee200000e8000ULL, 0x00000000200473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000520ff7c12ULL, 0x008fda000f80401aULL,
0x0000195204008947ULL, 0x010fea000b800000ULL, 0x001c1fff1e1d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011625ULL, 0x0000000c19357812ULL, 0x000fc400078ec0ffULL,
0x000000071a1b7812ULL, 0x040fe200078ec0ffULL, 0x000000081a207824ULL, 0x04afe200078e00ffULL,
0x0000001aff307212ULL, 0x000fe200078e33ffULL, 0x000000081a217824ULL, 0x040fe200078e00ffULL,
0x0000000325ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081a317824ULL, 0x040fe200078e00ffULL,
0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff820207812ULL, 0x100fe400078ee21bULL,
0x0000000121227812ULL, 0x140fe200078ef61bULL, 0x000000081a397824ULL, 0x040fe200078e00ffULL,
0x0000000221237812ULL, 0x140fe200078ef61bULL, 0x000000081a327824ULL, 0x000fe200078e00ffULL,
0x00000003212c7812ULL, 0x000fc400078ef61bULL, 0x00000004212d7812ULL, 0x140fe400078ef61bULL,
0x00000005212e7812ULL, 0x140fe400078ef61bULL, 0x00000006212f7812ULL, 0x000fe200078ef61bULL,
0x000000081a217824ULL, 0x040fe200078e00ffULL, 0xfffffff831307812ULL, 0x000fe400078ee230ULL,
0x0000001aff317212ULL, 0x000fe400078e33ffULL, 0x000000071a1b7812ULL, 0x000fc400078ec0ffULL,
0x0000a000661a7811ULL, 0x000fe400078e58ffULL, 0xfffffff839397812ULL, 0x000fe400078ee231ULL,
0xfffffff832317812ULL, 0x100fe200078ee21bULL, 0x0000001020197824ULL, 0x100fe200078e021aULL,
0x0000000121327812ULL, 0x100fe200078ef61bULL, 0x0000001023207824ULL, 0x100fe200078e021aULL,
0x0000000221337812ULL, 0x000fe200078ef61bULL, 0x0000000135197824ULL, 0x000fe200078e0219ULL,
0x0000000321347812ULL, 0x140fe200078ef61bULL, 0x000000102e237824ULL, 0x000fe200078e021aULL,
0x0000000421367812ULL, 0x100fe200078ef61bULL, 0x0000000135207824ULL, 0x000fe200078e0220ULL,
0x0000000521377812ULL, 0x100fe200078ef61bULL, 0x00000010312e7824ULL, 0x100fe200078e021aULL,
0x0000000621387812ULL, 0x000fe200078ef61bULL, 0x00000010221b7824ULL, 0x100fe200078e021aULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x000000102c217824ULL, 0x000fc400078e021aULL,
0x000000102d227824ULL, 0x100fe400078e021aULL, 0x00000001351b7824ULL, 0x000fe400078e021bULL,
0x000000102f2c7824ULL, 0x100fe400078e021aULL, 0x00000010302d7824ULL, 0x000fe200078e021aULL,
0x0000000a1b007388ULL, 0x0003e20000000800ULL, 0x0000000135217824ULL, 0x040fe400078e0221ULL,
0x0000000135227824ULL, 0x000fe200078e0222ULL, 0x0000000c20007388ULL, 0x0003e20000000800ULL,
0x00000010322f7824ULL, 0x000fc400078e021aULL, 0x0000000135237824ULL, 0x000fe200078e0223ULL,
0x0000000e21007388ULL, 0x0003e20000000800ULL, 0x0000001033307824ULL, 0x000fe400078e021aULL,
0x00000001352c7824ULL, 0x040fe200078e022cULL, 0x0000001022007388ULL, 0x0003e20000000800ULL,
0x0000001034317824ULL, 0x100fe400078e021aULL, 0x00000001352d7824ULL, 0x000fe200078e022dULL,
0x0000001223007388ULL, 0x0003e20000000800ULL, 0x0000001036327824ULL, 0x000fc400078e021aULL,
0x00000001352e7824ULL, 0x000fe200078e022eULL, 0x000000142c007388ULL, 0x0003e20000000800ULL,
0x0000001037337824ULL, 0x100fe400078e021aULL, 0x00000001352f7824ULL, 0x040fe200078e022fULL,
0x000000162d007388ULL, 0x0003e20000000800ULL, 0x0000001038347824ULL, 0x000fe400078e021aULL,
0x0000000135307824ULL, 0x000fe200078e0230ULL, 0x000000092e007388ULL, 0x0003e20000000800ULL,
0x00000010391a7824ULL, 0x000fc400078e021aULL, 0x0000000135317824ULL, 0x040fe200078e0231ULL,
0x0000000b2f007388ULL, 0x0003e20000000800ULL, 0x0000000135327824ULL, 0x040fe400078e0232ULL,
0x0000000135337824ULL, 0x040fe200078e0233ULL, 0x0000000d30007388ULL, 0x0003e20000000800ULL,
0x0000000135347824ULL, 0x040fe400078e0234ULL, 0x00000001351a7824ULL, 0x000fe200078e021aULL,
0x0000000f31007388ULL, 0x0003e80000000800ULL, 0x0000001132007388ULL, 0x0003e80000000800ULL,
0x0000001333007388ULL, 0x0003e80000000800ULL, 0x0000001534007388ULL, 0x0003e80000000800ULL,
0x000000171a007388ULL, 0x0003e80000000800ULL, 0x0100000418008388ULL, 0x0003e80000000c00ULL,
0x0102001c18008388ULL, 0x0143e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002aff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002aff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030063637a10ULL, 0x000fe20007ffe0ffULL, 0x000018002aff7f8cULL, 0x0003e6000c80043fULL,
0x000000616300720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc5c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff147807ULL, 0x008fe20004800000ULL, 0xffffffffff287424ULL, 0x000fe200078e00ffULL,
0x000164a000157802ULL, 0x000fe40000000f00ULL, 0x0000155000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xfffeb28000007947ULL, 0x000fea000383ffffULL,
0x00000001ff147807ULL, 0x000fe20004800000ULL, 0xffffffffff287424ULL, 0x000fe200078e00ffULL,
0x0001650000157802ULL, 0x000fe40000000f00ULL, 0x000014f000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0028ULL, 0xfffeb2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x008fe200078e0029ULL, 0x0001658000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e0014ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000142000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0031ULL, 0xfffeb2c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff377224ULL, 0x000fe200078e0014ULL, 0x0001660000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff367224ULL, 0x000fe400078e0029ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x000013a000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0031ULL, 0xfffeb27000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x0001668000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e004fULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000132000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x004fe200078e0031ULL, 0xfffeb5d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x0001670000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x000012a000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff6d7224ULL, 0x004fe200078e0031ULL, 0xfffeb58000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0002ULL, 0x0001677000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000123000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff3d7224ULL, 0x004fe200078e0031ULL,
0xfffecce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0002ULL,
0x000167f000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fe400078e0051ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000011b000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff3c7224ULL, 0x004fe200078e0031ULL,
0xfffecc8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x008fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x0001685000157802ULL, 0x000fc40000000f00ULL,
0x000011a000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xfffee43000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x000168b000157802ULL, 0x000fc40000000f00ULL,
0x0000114000007944ULL, 0x032fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xfffee45000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x004fe200078e0031ULL,
0x0001693000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fc400078e0028ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000107000007944ULL, 0x032fea0003c00000ULL, 0xfffee49000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0028ULL, 0x000169a000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000100000007944ULL, 0x032fea0003c00000ULL,
0xfffee54000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0014ULL,
0x00016a0000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00000fa000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff3b7224ULL, 0x004fe200078e0031ULL, 0xfffee79000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0014ULL, 0x00016a8000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x004fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00000f2000007944ULL, 0x02afea0003c00000ULL,
0x000000ffff3a7224ULL, 0x004fe200078e0031ULL, 0xfffee73000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0010ULL, 0x00016af000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x00000eb000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0031ULL,
0xfffefcc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00016b7000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fe400078e0051ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x00000e3000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0031ULL,
0xfffefc6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x008fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x00016bd000157802ULL, 0x000fc40000000f00ULL,
0x00000e2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xffff12a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x00016c3000157802ULL, 0x000fc40000000f00ULL,
0x00000dc000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xffff12c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x004fe200078e0031ULL,
0x00016cb000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fc400078e0028ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x00000cf000007944ULL, 0x012fea0003c00000ULL, 0xffff130000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0028ULL, 0x00016d2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00000c8000007944ULL, 0x012fea0003c00000ULL,
0xffff13b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0014ULL,
0x00016d8000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00000c2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e0031ULL, 0xffff160000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0014ULL, 0x00016e0000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x004fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x00000ba000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0031ULL, 0xffff15a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0010ULL, 0x00016e7000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x00000b3000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff3a7224ULL, 0x004fe200078e0031ULL,
0xffff2b1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0010ULL,
0x00016ef000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff377224ULL, 0x002fe400078e0051ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x00000ab000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0031ULL,
0xffff2ab000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x008fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x00016f5000157802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xffff41e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff147807ULL, 0x000fe20004800000ULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x00016fb000157802ULL, 0x000fc40000000f00ULL,
0x00000a4000007944ULL, 0x034fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0028ULL,
0xffff420000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x002fe200078e0031ULL,
0x0001703000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fc400078e0015ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000097000007944ULL, 0x034fea0003c00000ULL, 0xffff424000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0015ULL, 0x000170a000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000090000007944ULL, 0x032fea0003c00000ULL,
0xffff42f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e0000ULL,
0x0001710000387802ULL, 0x000fe20000000f00ULL, 0x0000001fff337424ULL, 0x000fc400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x000008a000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff3d7224ULL, 0x004fe200078e0031ULL, 0xffff454000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x0001718000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x008fe400078e0051ULL, 0x0000001fff337424ULL, 0x000fe400078e00ffULL,
0xffffffffff327424ULL, 0x000fe400078e00ffULL, 0x0000082000007944ULL, 0x036fea0003c00000ULL,
0x000000ffff3c7224ULL, 0x004fe200078e0031ULL, 0xffff44e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e0000ULL, 0x000171f000387802ULL, 0x000fe20000000f00ULL,
0x0000001fff337424ULL, 0x000fc400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x000007b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff397224ULL, 0x004fe200078e0031ULL,
0xffff5aa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff377224ULL, 0x004fe200078e0051ULL,
0x0001727000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fe400078e0000ULL,
0x0000001fff337424ULL, 0x000fe400078e00ffULL, 0xffffffffff327424ULL, 0x000fe400078e00ffULL,
0x0000073000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff517224ULL, 0x004fe200078e0031ULL,
0xffff5a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e002cULL,
0x000172f000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000066000007944ULL, 0x022fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002eULL,
0xffffe2c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0001737000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x000005e000007944ULL, 0x026fea0003c00000ULL, 0x0000002e05057209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x000173e000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x0000002e06067209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001745000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000002e07077209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e002fULL, 0x000174c000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000002e2f047209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0005ULL,
0x0001753000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000002e05057209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0006ULL, 0x000175a000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000002e06067209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0007ULL,
0x0001761000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe0a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e001cULL, 0x0001768000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fc400078e00ffULL, 0x00001c1fff337424ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e0020ULL, 0x0000032000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0031ULL, 0xffffe66000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e001eULL, 0x0001770000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff337424ULL, 0x000fe400078e00ffULL,
0x000000ffff327224ULL, 0x000fe400078e0020ULL, 0x000002a000007944ULL, 0x026fea0003c00000ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0001776000387802ULL, 0x000fe20000000f00ULL,
0x00001c1fff337424ULL, 0x000fc400078e00ffULL, 0x000000ffff327224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x004fe400078e0031ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e0020ULL, 0x000177c000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff377224ULL, 0x000fe400078e00ffULL, 0x00001c1fff337424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e0031ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e0031ULL, 0xffffe5a000007947ULL, 0x000fea000383ffffULL,
0x0180000031007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000003100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000005ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff31ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000031057812ULL, 0x000fd600078ec0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffe86b004007950ULL, 0x000fea0003c3ffffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0c00002e082e7389ULL, 0x0002a400000e0037ULL, 0x000000ffff087224ULL, 0x002fe400078e0009ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe866008007950ULL, 0x000fea0003c3ffffULL,
0x0000003200007348ULL, 0x000fe80003800000ULL, 0x0000003736317389ULL, 0x0002a400000e0033ULL,
0x000000ffff327224ULL, 0x002fe400078e0038ULL, 0x00000000ff337424ULL, 0x000fc800078e00ffULL,
0xfffe861032007950ULL, 0x000fea0003c3ffffULL, 0x000000011400780cULL, 0x000fe20003f25070ULL,
0x0000002800007348ULL, 0x000fd80003800000ULL, 0x0000000000147806ULL, 0x000fc800048e0100ULL,
0x0000002814287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff147224ULL, 0x000fe400078e0015ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe85a014007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000005b0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000b90ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000c20ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017b0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000017d0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000017e0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001890ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001898ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000018a8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001a80ULL, 0x0000000000017b00ULL, 0x9800001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019580ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000019590ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019590ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000019a10ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001890ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000017cf0ULL, 0x0000000000017cf0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000019580ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000019a10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 105200;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
