/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018090ULL, 0x0000000000017c10ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000016800ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x0000000000016970ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x00000000000169b0ULL, 0x00000000000000d0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016a80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001680000000000ULL, 0x0000040400000000ULL, 0x810c000000980400ULL, 0x00595c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001680000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0x8016288080880828ULL, 0x0000000310288082ULL, 0x8088920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x0001697000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x9a082880808e0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809a920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x000169b000000000ULL,
0x000000d000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000e9ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000dULL,
0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL,
0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x0001569000183104ULL, 0x00015b9000015b50ULL, 0x00015cb000015ca0ULL,
0x00e8290400015cc0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002d0500002dULL, 0x0500002d0500002dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000c000e82804ULL, 0x00001e50000000f0ULL,
0x00001f6000001ee0ULL, 0x0000302000001f90ULL, 0x00004c6000003060ULL, 0x00004d5000004ce0ULL,
0x00005c8000004d80ULL, 0x000078c000005cb0ULL, 0x000079b000007940ULL, 0x00008750000079e0ULL,
0x0000a4d000008830ULL, 0x0000a5c00000a550ULL, 0x0000b4000000a5f0ULL, 0x0000c9200000b430ULL,
0x0000d0b00000c930ULL, 0x0000f0500000edf0ULL, 0x0000f5500000f510ULL, 0x000155600000fd80ULL,
0x000155a000015590ULL, 0x000155d0000155b0ULL, 0x00015610000155f0ULL, 0x00015c9000015620ULL,
0x00015d0000015cf0ULL, 0x0001635000015d10ULL, 0x00016440000163d0ULL, 0x00016520000164b0ULL,
0x0001660000016590ULL, 0x000166d000016670ULL, 0x0001679000016740ULL, 0x03e03904000167e0ULL,
0x000000ff00000170ULL, 0x003f01000001c600ULL, 0x0000000f000001a0ULL, 0x003f01300001c608ULL,
0x0000000f000001d0ULL, 0x003f01300001c610ULL, 0x0000000f00000230ULL, 0x003f01200001c648ULL,
0x000000ff00000240ULL, 0x003f01000001c658ULL, 0x000000ff000005a0ULL, 0x003f01070001c600ULL,
0x0000002e00000770ULL, 0x003f01020001c614ULL, 0x0000002e00000870ULL, 0x003f01010001c610ULL,
0x000000ff00000fd0ULL, 0x003f01070001c648ULL, 0x000000ff00001050ULL, 0x003f01010001c658ULL,
0x000000ff000011d0ULL, 0x003f01060001c65cULL, 0x000000ff00001280ULL, 0x003f01060001c65cULL,
0x000000ff00001310ULL, 0x003f01060001c65cULL, 0x000000ff00001c00ULL, 0x0005010700000000ULL,
0x0000002400001c70ULL, 0x003f01060001c64cULL, 0x000000ff00001c90ULL, 0x003f01060001c60cULL,
0x000000ff00001d90ULL, 0x003f01060001c60cULL, 0x0000002900002210ULL, 0x003f010600000004ULL,
0x00000029000022a0ULL, 0x003f010600000004ULL, 0x000000ff000042c0ULL, 0x003f01010001c658ULL,
0x000000ff00004330ULL, 0x003f01010001c610ULL, 0x000000ff000043e0ULL, 0x003f01060001c65cULL,
0x000000ff00004430ULL, 0x003f01060001c65cULL, 0x000000ff000044c0ULL, 0x003f01060001c65cULL,
0x0000006000004a60ULL, 0x003f01070001c648ULL, 0x0000003c00004ad0ULL, 0x003f010600000004ULL,
0x000000ff00004af0ULL, 0x003f01060001c61cULL, 0x000000ff00004be0ULL, 0x003f01060001c61cULL,
0x0000003200005010ULL, 0x003f010600000004ULL, 0x00000032000050a0ULL, 0x003f010600000004ULL,
0x000000ff00006eb0ULL, 0x003f01010001c658ULL, 0x000000ff00006f20ULL, 0x003f01010001c620ULL,
0x000000ff00006fb0ULL, 0x003f01060001c65cULL, 0x000000ff00007010ULL, 0x003f01060001c65cULL,
0x000000ff000070a0ULL, 0x003f01060001c65cULL, 0x000000ff000076d0ULL, 0x0005010700000000ULL,
0x0000000e00007740ULL, 0x003f01060001c64cULL, 0x000000ff00007760ULL, 0x003f01060001c62cULL,
0x000000ff00007840ULL, 0x003f01060001c62cULL, 0x0000000e00007c70ULL, 0x003f01060001c64cULL,
0x0000001100007d60ULL, 0x003f010600000004ULL, 0x000000ff00009b50ULL, 0x003f01010001c658ULL,
0x000000ff00009bc0ULL, 0x003f01010001c630ULL, 0x000000ff00009c90ULL, 0x003f01060001c65cULL,
0x000000ff00009ce0ULL, 0x003f01060001c65cULL, 0x000000ff00009d70ULL, 0x003f01060001c65cULL,
0x000000850000a2f0ULL, 0x003f01070001c648ULL, 0x0000000e0000a360ULL, 0x003f010600000004ULL,
0x000000ff0000a380ULL, 0x003f01060001c63cULL, 0x000000ff0000a450ULL, 0x003f01060001c63cULL,
0x0000001d0000a880ULL, 0x003f010600000004ULL, 0x0000001d0000a910ULL, 0x003f010600000004ULL,
0x000000ff0000c670ULL, 0x003f01010001c658ULL, 0x000000ff0000c6d0ULL, 0x003f01010001c640ULL,
0x000000ff00011b40ULL, 0x003f01060001c604ULL, 0x000000ff00011bd0ULL, 0x003f01060001c604ULL,
0x000000ff00011f00ULL, 0x003f01010001c600ULL, 0x000000ff00011f10ULL, 0x003f01060001c604ULL,
0x000000ff00011f90ULL, 0x003f01060001c604ULL, 0x0000002700014a30ULL, 0x003f01060001c614ULL,
0x0000002700014e60ULL, 0x003f01060001c614ULL, 0x0000002700016290ULL, 0x003f01010001c608ULL,
0x00101c0400053803ULL, 0x00011fe0000101c0ULL, 0x000162f0000120b0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL,
0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL,
0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000087919ULL, 0x000e620000002300ULL,
0x00000004ff177424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e620000002200ULL, 0x0000580000047ab9ULL, 0x000fc60000000800ULL,
0x0000000000097919ULL, 0x000ea80000002100ULL, 0x0000000000287919ULL, 0x000ee80000002700ULL,
0x0000000000247919ULL, 0x000f220000002600ULL, 0x0000000108007824ULL, 0x002fc800078e0203ULL,
0x00000080000f7824ULL, 0x104fe200078e0209ULL, 0x00000005ff747819ULL, 0x000fe20000011609ULL,
0x00001fff08007589ULL, 0x00066600000e0000ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff74747589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe20003f24070ULL, 0x0000620028087625ULL, 0x008fe200078e0017ULL,
0x000000010f00780cULL, 0x000fce0003f44070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL,
0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL, 0x01c60002ff00b388ULL, 0x0007e20000000a00ULL,
0x3fffff80ff068424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff078424ULL, 0x000fe200078e00ffULL,
0x01c608040f008388ULL, 0x0007e2000000ca00ULL, 0xff317217ff0e9424ULL, 0x000fc400078e00ffULL,
0x3fffff80ff0aa424ULL, 0x000fe200078e00ffULL, 0x01c610060f008388ULL, 0x0007e2000000ca00ULL,
0x000000ff0000720cULL, 0x002fe20003f05270ULL, 0x7fffff80ff0ba424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL, 0x01c4000e0f009388ULL, 0x0007e20000004800ULL,
0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL, 0x01c6480a0f00a388ULL, 0x0007e80000008a00ULL,
0x01c6580cff00b388ULL, 0x0007e80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000003a000000947ULL, 0x000fea0003800000ULL, 0x00000000000f7919ULL, 0x01ce620000000000ULL,
0x0000000474027824ULL, 0x000fe200078e00ffULL, 0x0000000404057899ULL, 0x000fe2000800063fULL,
0x0000001024037824ULL, 0x000fc400078e00ffULL, 0x00000200ff157424ULL, 0x000fc600078e00ffULL,
0x0000000528047c24ULL, 0x000fe2000f8e0203ULL, 0x000000020f057211ULL, 0x042fe200078fd8ffULL,
0x000000100f027824ULL, 0x000fc600078e00ffULL, 0x0000000705037812ULL, 0x040fe400078ec0ffULL,
0x000001f002137812ULL, 0x000fe200078ec0ffULL, 0x0000000104027824ULL, 0x000fe200078e0205ULL,
0x00000002050d7810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fe200078e0015ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0000000305117810ULL, 0x040fe20007ffe0ffULL, 0x00000020050c7824ULL, 0x000fe200078e0206ULL,
0x000000070d0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x040fe200078e0207ULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000104127824ULL, 0x000fe200078e0211ULL,
0x00000007110b7812ULL, 0x000fc400078ec0ffULL, 0x0000001f0a107812ULL, 0x100fe400078e780fULL,
0x00000013020a7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f06067812ULL, 0x100fe200078e780fULL,
0x000000200d107824ULL, 0x000fe200078e0210ULL, 0x0000001f0b147812ULL, 0x000fe200078e780fULL,
0x00000001040f7824ULL, 0x000fe400078e020dULL, 0x000000ffff0b7224ULL, 0x000fe400000e0603ULL,
0x00005c0005027625ULL, 0x000fc800078e0015ULL, 0x00000020070e7824ULL, 0x000fe200078e0206ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x00005c000f047625ULL, 0x000fc800078e0015ULL,
0x00005c0012067625ULL, 0x000fe200078e0015ULL, 0x0000001304047210ULL, 0x000fc60007f3e0ffULL,
0x0000002011147824ULL, 0x000fe200078e0214ULL, 0x0000001306067210ULL, 0x000fe20007f5e0ffULL,
0x000000100c0d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x000000100e0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001010117824ULL, 0x000fe200078e00ffULL, 0x00000000020f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc400010e0607ULL, 0x0000001014137824ULL, 0x000fe200078e00ffULL,
0x0000000004117faeULL, 0x0003e8000b901c46ULL, 0x0000000006137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000608737981ULL, 0x01cea2000c1e1900ULL,
0x00000000000579c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000005ff757e24ULL, 0x008fe2000f8e00ffULL, 0x0000007f73727810ULL, 0x004fc40007ffe0ffULL,
0x000000ff73707810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff727819ULL, 0x000fe40000011672ULL,
0x00000008ff707819ULL, 0x000fca0000011670ULL, 0x0000fb3000008947ULL, 0x000fea0003800000ULL,
0x0000000275717824ULL, 0x000fe400078e00ffULL, 0x00000010742e7824ULL, 0x000fe400078e00ffULL,
0x00000003ff057424ULL, 0x002fe200078e00ffULL, 0x000000727100720cULL, 0x000fe20003f06070ULL,
0xffffffffff2f7424ULL, 0x000fd800078e00ffULL, 0x0000640071038a10ULL, 0x000fe20007ffe0ffULL,
0x0000000228008824ULL, 0x000fc800078e00ffULL, 0x0000640000038a24ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c614052eff738cULL, 0x0003e20000000000ULL,
0x0000600003028625ULL, 0x000fe200078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006022f8981ULL, 0x0004e2000c1e1900ULL, 0x0000010075047824ULL, 0x040fe200078e00ffULL,
0x0000000175057810ULL, 0x002fe20007ffe0ffULL, 0x0000000704047899ULL, 0x000fe2000800063fULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x00000100ff217424ULL, 0x000fe200078e00ffULL,
0x000000700500720cULL, 0x000fe20003f06070ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000473077217ULL, 0x000fe20007800000ULL, 0x01c610002eff7f8cULL, 0x0009e2000c80043fULL,
0x0000008024027824ULL, 0x004fe200078e00ffULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000107077824ULL, 0x000fe200078e0a04ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x0000004007077807ULL, 0x000fe20000000000ULL, 0x000000ffff4d7224ULL, 0x000fc600078e00ffULL,
0x000000072e077217ULL, 0x000fca0007800000ULL, 0x0000000107037824ULL, 0x000fe200078e0a2eULL,
0x00000004ff127819ULL, 0x002fe20000011600ULL, 0x00000010001f7824ULL, 0x000fc600078e00ffULL,
0x0000000212067810ULL, 0x000fe20007ffe0ffULL, 0x000000012e057824ULL, 0x000fe200078e0212ULL,
0x00000006120a7810ULL, 0x040fe40007ffe0ffULL, 0x0000000412087810ULL, 0x000fe20007ffe0ffULL,
0x000000012e077824ULL, 0x040fe200078e0206ULL, 0x0000000705097812ULL, 0x000fe200078ec0ffULL,
0x000000012e0f7824ULL, 0x040fe200078e020aULL, 0x000000f01f1f7812ULL, 0x000fe200078ec0ffULL,
0x000000012e0d7824ULL, 0x000fe200078e0208ULL, 0x0000000f09047812ULL, 0x000fc400078e7800ULL,
0x000000030a00720cULL, 0x080fe40003f46070ULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x0000001005137824ULL, 0x000fe200078e0204ULL, 0x000000030600720cULL, 0x080fe40003f86070ULL,
0x0000000f09067812ULL, 0x000fe400078e7800ULL, 0x00000008120c7810ULL, 0x000fe40007ffe0ffULL,
0x000000070d097812ULL, 0x000fe200078ec0ffULL, 0x0000001007157824ULL, 0x000fe200078e0206ULL,
0x000000030c00720cULL, 0x000fe20003f26070ULL, 0x000000012e117824ULL, 0x000fe200078e020cULL,
0x0000000f09067812ULL, 0x000fc400078e7800ULL, 0x000000030800720cULL, 0x080fe40003f66070ULL,
0x0000000711097812ULL, 0x000fe200078ec0ffULL, 0x000000100d167824ULL, 0x000fe200078e0206ULL,
0x000000031200720cULL, 0x000fe40003fa6070ULL, 0x0000000f09187812ULL, 0x000fe400078e7800ULL,
0x0001400015157811ULL, 0x000fc600078e20ffULL, 0x0000001011187824ULL, 0x000fe400078e0218ULL,
0x000000042f147c24ULL, 0x008fca000f8e0202ULL, 0x0000007f14057812ULL, 0x040fe400078ef805ULL,
0x0000007f14067812ULL, 0x000fc600078ef80fULL, 0x00005e0005047625ULL, 0x000fca00078e0021ULL,
0x0000001f040a7210ULL, 0x000fe40007f1e0ffULL, 0x0000007f14047812ULL, 0x000fe400078ef807ULL,
0x000000070f077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe400000e0605ULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x0000000f07087812ULL, 0x000fc600078e7800ULL,
0x00005e0006067625ULL, 0x000fe200078e0021ULL, 0x0000001f040c7210ULL, 0x080fe40007f1e0ffULL,
0x0000007f14047812ULL, 0x040fe200078ef80dULL, 0x000000100f177824ULL, 0x000fe200078e0208ULL,
0x0000007f14087812ULL, 0x000fe200078ef811ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0605ULL,
0x0000001f06107210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x080fe200078e0021ULL,
0x0000000c12067810ULL, 0x000fe40007ffe0ffULL, 0x0001400017177811ULL, 0x000fe200078e20ffULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0x0000001f040e7210ULL, 0x000fc40007f1e0ffULL,
0x0000000a12047810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0607ULL,
0x0000001f08087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e0605ULL,
0x000000030400720cULL, 0x080fe20003f06070ULL, 0x000000012e197824ULL, 0x040fe200078e0204ULL,
0x0001400013077811ULL, 0x000fe200078e20ffULL, 0x000000012e1b7824ULL, 0x000fe200078e0206ULL,
0x0000000e12137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0x0000007f14047812ULL, 0x000fe200078ef819ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000e901c46ULL, 0x000000030600720cULL, 0x000fe20003fa6070ULL,
0x000000012e1d7824ULL, 0x000fc400078e0213ULL, 0x00005e0004047625ULL, 0x000fe200078e0021ULL,
0x000000000c157faeULL, 0x0005e2000e101c46ULL, 0x000000031300720cULL, 0x000fe40003f86070ULL,
0x0000000719037812ULL, 0x000fe400078ec0ffULL, 0x0000001f04127210ULL, 0x000fe40007fde0ffULL,
0x0000007f14047812ULL, 0x040fe400078ef81bULL, 0x0000007f14067812ULL, 0x000fe200078ef81dULL,
0x000000ffff137224ULL, 0x000fe200030e0605ULL, 0x000000071b0b7812ULL, 0x002fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0021ULL, 0x0000000f03147812ULL, 0x000fc400078e7800ULL,
0x000000071d037812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0021ULL,
0x0000001f040a7210ULL, 0x080fe40007fde0ffULL, 0x0000000f0b047812ULL, 0x000fe200078e7800ULL,
0x0000001019147824ULL, 0x000fe200078e0214ULL, 0x0000000f030c7812ULL, 0x004fe200078e7800ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0605ULL, 0x0000001f06067210ULL, 0x000fe20007fde0ffULL,
0x000000101b047824ULL, 0x000fe200078e0204ULL, 0x0001400016057811ULL, 0x000fe200078e20ffULL,
0x000000101d0c7824ULL, 0x000fe200078e020cULL, 0x00014000180d7811ULL, 0x000fe200078e20ffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0001400014157811ULL, 0x000fe200078e20ffULL,
0x000000000e057faeULL, 0x0003e2000d901c46ULL, 0x0001400004197811ULL, 0x000fe200078e20ffULL,
0xff317217ff037424ULL, 0x000fe200078e00ffULL, 0x000140000c1b7811ULL, 0x000fe200078e20ffULL,
0x0000000010177faeULL, 0x0009e2000d101c46ULL, 0x000000ffff047224ULL, 0x000fc600078e00ffULL,
0x00000000080d7faeULL, 0x0009e8000c901c46ULL, 0x0000000012157faeULL, 0x0009e2000c101c46ULL,
0x000000707500720cULL, 0x000fc60003f06070ULL, 0x000000000a197faeULL, 0x0009e8000e901c46ULL,
0x00000000061b7faeULL, 0x0009e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000b69000000947ULL, 0x000fea0003800000ULL,
0x0000000228077824ULL, 0x010fe200078e00ffULL, 0x0000000274057811ULL, 0x000fe200078e10ffULL,
0x00006400ff067624ULL, 0x000fe200078e00ffULL, 0x00007610ff8d7816ULL, 0x000fe2000000008dULL,
0xff317217ff037424ULL, 0x000fe200078e00ffULL, 0x00007610ff8c7816ULL, 0x000fe2000000008cULL,
0x0000640007067624ULL, 0x000fe200078e0206ULL, 0x00007610ff077816ULL, 0x000fe20000000007ULL,
0x000000ffff8e7224ULL, 0x000fc400078e00ffULL, 0x000000ffff537224ULL, 0x000fe400078e00ffULL,
0x0000010075087824ULL, 0x000fca00078e00ffULL, 0x000000730800720cULL, 0x000fda0003f06070ULL,
0x0000b56000000947ULL, 0x020fea0003800000ULL, 0x01c65c00ff097984ULL, 0x000e620000000800ULL,
0x0000ffff8d087812ULL, 0x000fe200078ec0ffULL, 0x000000ffff897224ULL, 0x000fc600078e0071ULL,
0x00008880080c7816ULL, 0x000fe200000000ffULL, 0x000000ffff087224ULL, 0x000fc800078e008eULL,
0x800000000c0a7824ULL, 0x000fca00078e00ffULL, 0x8000000009ff7812ULL, 0x002fe2000780480aULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000076108c837816ULL, 0x000fe40000000083ULL,
0x000076108d097816ULL, 0x000fe20000000009ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780480aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000c0c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x3fa000000a0a7823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x00000300ff867624ULL, 0x000fe200078e00ffULL,
0x00000001710a7812ULL, 0x000fe200078ec0ffULL, 0x000000042f217c24ULL, 0x000fe2000f8e0202ULL,
0x00000004ff1c7819ULL, 0x000fe20000011600ULL, 0xffffffffff2f7424ULL, 0x000fe200078e00ffULL,
0x000000010a00780cULL, 0x000fe40003f05070ULL, 0xffffffff86867811ULL, 0x000fc800078e08ffULL,
0x0000000186867807ULL, 0x000fca0004000000ULL, 0x0000000171717824ULL, 0x000fca00078e0286ULL,
0x000000727100720cULL, 0x000fe20003f06070ULL, 0x000000012e0a7824ULL, 0x000fe200078e021cULL,
0x0000004075107811ULL, 0x000fe400078e40ffULL, 0x0000004021217810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0a0b7812ULL, 0x000fe400078ec0ffULL, 0x0000001073137217ULL, 0x000fca0007800000ULL,
0x00000086060c8210ULL, 0x000fe20007ffe089ULL, 0x00000004ff0d8424ULL, 0x000fe200078e00ffULL,
0x0000000175117810ULL, 0x000fc60007ffe0ffULL, 0x000060000c0c8625ULL, 0x000fc800078e000dULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x000000060c2f8981ULL, 0x000362000c1e1900ULL,
0x000000010b0e7824ULL, 0x000fe200078e0221ULL, 0x000000701100720cULL, 0x000fe20003f06070ULL,
0x00000010003c7824ULL, 0x000fe200078e00ffULL, 0x000000021c117810ULL, 0x040fe20007ffe0ffULL,
0x0000000113137824ULL, 0x000fe200078e0a10ULL, 0x000000041c127810ULL, 0x000fe20007ffe0ffULL,
0x00005e000e0e7625ULL, 0x000fe200078e0031ULL, 0x000000061c177810ULL, 0x000fe40007ffe0ffULL,
0x000000f03c0c7812ULL, 0x002fe200078ec0ffULL, 0x000000012e0d7824ULL, 0x040fe200078e0211ULL,
0x0000004013137807ULL, 0x000fe20000000000ULL, 0x000000012e107824ULL, 0x000fe200078e0217ULL,
0x0000000c0e227210ULL, 0x000fe20007f3e0ffULL, 0x000040008e377824ULL, 0x000fe200078e00ffULL,
0x000000132e137217ULL, 0x000fc40007800000ULL, 0x0000007f0d0e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff237224ULL, 0x000fe200008e060fULL, 0x000000081c3d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113277824ULL, 0x000fe200078e0a2eULL, 0x0000000a1c3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000012e0f7824ULL, 0x000fe200078e0212ULL, 0x0000000c1c3f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e147824ULL, 0x000fe200078e0221ULL, 0x000000271100720cULL, 0x000fe20003f86070ULL,
0x000000012e137824ULL, 0x000fe200078e023dULL, 0x0000007f0f117812ULL, 0x000fe200078ec0ffULL,
0x00005e0014147625ULL, 0x000fe200078e0031ULL, 0x000000271200720cULL, 0x000fc40003f66070ULL,
0x0000007f10127812ULL, 0x000fe200078ec0ffULL, 0x0000000111167824ULL, 0x100fe200078e0221ULL,
0x000000271700720cULL, 0x000fe40003f46070ULL, 0x0000000c14247210ULL, 0x000fe20007f1e0ffULL,
0x0000000112187824ULL, 0x000fe200078e0221ULL, 0x0000007f13147812ULL, 0x000fe200078ec0ffULL,
0x00005e0016167625ULL, 0x000fe200078e0031ULL, 0x0000000e1c547810ULL, 0x040fe40007ffe0ffULL,
0x000000271c00720cULL, 0x000fe20003fa6070ULL, 0x00005e0018187625ULL, 0x000fe200078e0031ULL,
0x000000070a337812ULL, 0x000fc600078ec0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0615ULL,
0x0000000c16287210ULL, 0x080fe20007f1e0ffULL, 0x000000012e157824ULL, 0x000fe200078e023eULL,
0x0000000c182a7210ULL, 0x000fe20007f3e0ffULL, 0x00000001141a7824ULL, 0x000fe200078e0221ULL,
0x0000000f33357812ULL, 0x000fe200078e7800ULL, 0x000000ffff297224ULL, 0x000fe200000e0617ULL,
0x0000007f15177812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fe400008e0619ULL,
0x000000012e167824ULL, 0x000fc400078e023fULL, 0x00005e001a1a7625ULL, 0x000fc600078e0031ULL,
0x0000007f16187812ULL, 0x000fe200078ec0ffULL, 0x000000012e197824ULL, 0x000fe200078e0254ULL,
0x0000000c1a2c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001171c7824ULL, 0x100fe400078e0221ULL,
0x00000001181e7824ULL, 0x000fe200078e0221ULL, 0x0000007f191a7812ULL, 0x000fe200078ec0ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e0031ULL, 0x000000ffff2d7224ULL, 0x000fe200000e061bULL,
0x0000000c1c307210ULL, 0x000fe20007f1e0ffULL, 0x000000011a217824ULL, 0x000fe200078e0221ULL,
0x00004000371b7812ULL, 0x000fe200078e0cffULL, 0x00005e001e1e7625ULL, 0x000fc600078e0031ULL,
0x000140001b367810ULL, 0x000fe20007ffe0ffULL, 0x00005e0021207625ULL, 0x000fe200078e0031ULL,
0x0000000c1e327210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e061dULL,
0x000000070d1d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff337224ULL, 0x000fe200008e061fULL,
0x000000273d00720cULL, 0x000fe20003f26070ULL, 0x000000100a1b7824ULL, 0x000fe200078e0235ULL,
0x0000000f1d1c7812ULL, 0x000fe400078e7800ULL, 0x000000070f1d7812ULL, 0x000fe200078ec0ffULL,
0x000000101b1f7824ULL, 0x000fe200078e0236ULL, 0x00000007103d7812ULL, 0x000fe200078ec0ffULL,
0x000000100d1c7824ULL, 0x000fe200078e021cULL, 0x0000000f1d1e7812ULL, 0x000fc400078e7800ULL,
0x000000018e1d7812ULL, 0x000fe200078e0cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000221f7faeULL, 0x0003e2000e901c46ULL, 0x0000000c20347210ULL, 0x000fe20007f1e0ffULL,
0x000000100f1e7824ULL, 0x000fe200078e021eULL, 0x000000001d0573c2ULL, 0x000ea200000e0000ULL,
0x0000000f3d3d7812ULL, 0x000fe400078e7800ULL, 0x000000ffff357224ULL, 0x000fe200000e0621ULL,
0x000000273f00720cULL, 0x000fe20003fa6070ULL, 0x000000101c217824ULL, 0x000fe200078e0236ULL,
0x00000007193f7812ULL, 0x000fc400078ec0ffULL, 0x000000273e00720cULL, 0x080fe20003f06070ULL,
0x00000010101f7824ULL, 0x002fe200078e023dULL, 0x00000007133d7812ULL, 0x000fe200078ec0ffULL,
0x0000000024217faeULL, 0x0003e2000e101c46ULL, 0x000000101e237824ULL, 0x100fe200078e0236ULL,
0x000000275400720cULL, 0x000fe20003f86070ULL, 0x000000101f277824ULL, 0x000fe200078e0236ULL,
0x0000000f3d207812ULL, 0x000fe400078e7800ULL, 0x00000007153d7812ULL, 0x000fe200078ec0ffULL,
0x0000000028237faeULL, 0x0007e4000d901c46ULL, 0x0000001013207824ULL, 0x000fe200078e0220ULL,
0x0000000f3d227812ULL, 0x000fe200078e7800ULL, 0x000000002a277faeULL, 0x0009e2000d101c46ULL,
0x0000000716217812ULL, 0x002fe200078ec0ffULL, 0x0000001020257824ULL, 0x000fe200078e0236ULL,
0x0000000f3f247812ULL, 0x100fe200078e7800ULL, 0x0001c64805057891ULL, 0x004fe2000f8e183fULL,
0x0000000f213d7812ULL, 0x000fe200078e7800ULL, 0x0000001015217824ULL, 0x000fe200078e0222ULL,
0x000000002c257faeULL, 0x0003e2000c901c46ULL, 0x0000001019237824ULL, 0x008fc400078e0224ULL,
0x0000001016227824ULL, 0x000fe400078e023dULL, 0x0000001021277824ULL, 0x110fe400078e0236ULL,
0x0000001022297824ULL, 0x100fe400078e0236ULL, 0x00000010232b7824ULL, 0x000fe200078e0236ULL,
0x0000000030277faeULL, 0x0005e2000c101c46ULL, 0x000000088e247824ULL, 0x000fc600078e00ffULL,
0x0000000032297faeULL, 0x0005e8000e901c46ULL, 0x00000000342b7faeULL, 0x0005e8000e101c46ULL,
0x0000000000007918ULL, 0x002fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c64c0024287984ULL, 0x0002e20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c60c00ff2a7984ULL, 0x000f220000000800ULL,
0x0000ffff8c247812ULL, 0x002fc400078ec0ffULL, 0x0000ffff07257812ULL, 0x000fe400078ec0ffULL,
0x00008880242c7816ULL, 0x000fe400000000ffULL, 0x0000888025247816ULL, 0x000fc600000000ffULL,
0x800000002c257824ULL, 0x000fe400078e00ffULL, 0x8000000024277824ULL, 0x004fc600078e00ffULL,
0x8000000028ff7812ULL, 0x008fe40007804825ULL, 0x800000002aff7812ULL, 0x010fe20007824827ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff257424ULL, 0x000fe400078e00ffULL, 0x8000000024287824ULL, 0x000fe400078e00ffULL,
0x0000002500277305ULL, 0x0002a4000021f000ULL, 0x3fa0000025257823ULL, 0x002fe200000100ffULL,
0x000000270000735dULL, 0x004fe40003800000ULL, 0x01c60c00ff277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007824828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000001ff277819ULL, 0x000fe20000011600ULL,
0x00000001ffcf7424ULL, 0x000fe200078e00ffULL, 0x000000703c257812ULL, 0x000fe400078ec0ffULL,
0x0000000c27287812ULL, 0x000fca00078ec0ffULL, 0x0000000125257824ULL, 0x000fca00078e0228ULL,
0x01c0000025287984ULL, 0x000e680000000800ULL, 0x01c2000025277984ULL, 0x0004e20000000800ULL,
0x000000032800720bULL, 0x002fda0003f3d000ULL, 0x0000000000297806ULL, 0x000fc800008e0100ULL,
0x0000ffff292d7812ULL, 0x000fda000782c0ffULL, 0x0000035000009947ULL, 0x000fea0003800000ULL,
0x000000032800720bULL, 0x00cfe40003f34000ULL, 0x0000002803327209ULL, 0x000fe40007810000ULL,
0x00000002ff2a7819ULL, 0x000fc60000011600ULL, 0x8000003203297221ULL, 0x000fe20000010000ULL,
0x000000082a2b7810ULL, 0x000fc60007ffe0ffULL, 0x3fb8aa3b29297820ULL, 0x000fe40000410000ULL,
0x0000000000037806ULL, 0x000fe400008e0100ULL, 0x000000ff7400720cULL, 0x000fe40003f25270ULL,
0x0000ffff03307812ULL, 0x000fe200078e3cffULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000ffff037224ULL, 0x000fe400078e0032ULL, 0x000000302dff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ffcf7807ULL, 0x000fc60001000000ULL, 0x01c4003225009388ULL, 0x000fe80000000800ULL,
0x00001f2b292b7589ULL, 0x002e6400000e0000ULL, 0x8000003228282221ULL, 0x000fe40000010000ULL,
0x0000002904047220ULL, 0x000fe20000410000ULL, 0x00001f2a292a7589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b28282820ULL, 0x000fc80000410000ULL, 0x0000002800262308ULL, 0x000ee20000000800ULL,
0x0000002b53537220ULL, 0x082fe40000410000ULL, 0x0000002b52527220ULL, 0x080fe40000410000ULL,
0x0000002b5b5b7220ULL, 0x080fe40000410000ULL, 0x0000002b5a5a7220ULL, 0x080fe40000410000ULL,
0x0000002b5f5f7220ULL, 0x080fe40000410000ULL, 0x0000002b5e5e7220ULL, 0x000fc40000410000ULL,
0x0000002b4f4f7220ULL, 0x080fe40000410000ULL, 0x0000002b4e4e7220ULL, 0x080fe40000410000ULL,
0x0000002b4b4b7220ULL, 0x080fe40000410000ULL, 0x0000002b4a4a7220ULL, 0x080fe40000410000ULL,
0x0000002b3b3b7220ULL, 0x080fe40000410000ULL, 0x0000002b3a3a7220ULL, 0x000fc40000410000ULL,
0x0000002b43437220ULL, 0x080fe40000410000ULL, 0x0000002b42427220ULL, 0x080fe40000410000ULL,
0x0000002b47477220ULL, 0x080fe40000410000ULL, 0x0000002b46467220ULL, 0x000fe40000410000ULL,
0x0000002a51517220ULL, 0x084fe40000410000ULL, 0x0000002a50507220ULL, 0x000fc40000410000ULL,
0x0000002a59597220ULL, 0x080fe40000410000ULL, 0x0000002a58587220ULL, 0x080fe40000410000ULL,
0x0000002a5d5d7220ULL, 0x080fe40000410000ULL, 0x0000002a5c5c7220ULL, 0x080fe40000410000ULL,
0x0000002a4d4d7220ULL, 0x080fe40000410000ULL, 0x0000002a4c4c7220ULL, 0x000fc40000410000ULL,
0x0000002a49497220ULL, 0x080fe40000410000ULL, 0x0000002a48487220ULL, 0x080fe40000410000ULL,
0x0000002a39397220ULL, 0x080fe40000410000ULL, 0x0000002a38387220ULL, 0x080fe40000410000ULL,
0x0000002a41417220ULL, 0x080fe40000410000ULL, 0x0000002a40407220ULL, 0x000fc40000410000ULL,
0x0000002a45457220ULL, 0x080fe40000410000ULL, 0x0000002a44447220ULL, 0x000fe40000410000ULL,
0x0000002627272220ULL, 0x008fc80000410000ULL, 0x0000000427047221ULL, 0x00cfe20000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x0001c6488e297811ULL, 0x000fe200078e18ffULL,
0x800000002c287824ULL, 0x000fc800078e00ffULL, 0x0000040029277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804828ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000002c2b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff277424ULL, 0x000fc800078e00ffULL, 0x0000002700287305ULL, 0x0002a4000021f000ULL,
0x3fa0000027277823ULL, 0x002fe200000100ffULL, 0x000000280000735dULL, 0x004fe40003800000ULL,
0x0000040029287984ULL, 0x000e640000000800ULL, 0x8000000028ff7812ULL, 0x002fc4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004ff2a7819ULL, 0x000fe40000011600ULL, 0x0000000800277812ULL, 0x000fe400078ec0ffULL,
0x000140008e347811ULL, 0x000fe200078e70ffULL, 0x0000000474287824ULL, 0x000fe200078e022aULL,
0x0000000727297812ULL, 0x140fe200078ec800ULL, 0x000000012a2a7824ULL, 0x000fe200078e0205ULL,
0x00000007272c7812ULL, 0x000fe400078ef800ULL, 0x00000028292d7212ULL, 0x000fc400078e3cffULL,
0x0001400037287810ULL, 0x000fe40007ffe0ffULL, 0x0000002a29357212ULL, 0x000fe200078e3cffULL,
0x000000102c887824ULL, 0x040fe200078e022dULL, 0x000001002c2a7811ULL, 0x040fe400078e20ffULL,
0x000002002c367811ULL, 0x000fe200078e20ffULL, 0x0000001088547824ULL, 0x000fe400078e0228ULL,
0x000000102c277824ULL, 0x000fe400078e0235ULL, 0x0000000135297824ULL, 0x000fc400078e022aULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x0000001027647824ULL, 0x000fe400078e0228ULL,
0x000000012d287824ULL, 0x000fe400078e022aULL, 0x00000010296c7824ULL, 0x100fe400078e0234ULL,
0x000000006464783bULL, 0x000fe20000004200ULL, 0x0000001028687824ULL, 0x000fe400078e0234ULL,
0x000000012d2a7824ULL, 0x100fe200078e0236ULL, 0x000000006c6c783bULL, 0x000fe20000004200ULL,
0x00000001352b7824ULL, 0x000fe200078e0236ULL, 0x000003002c367811ULL, 0x000fe200078e20ffULL,
0x000000102a307824ULL, 0x100fe200078e0234ULL, 0x000000006868783bULL, 0x000fe20000004200ULL,
0x000000102b607824ULL, 0x000fc400078e0234ULL, 0x000000012d2c7824ULL, 0x100fe400078e0236ULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x00000001352d7824ULL, 0x000fe400078e0236ULL,
0x000000102c3c7824ULL, 0x100fe200078e0234ULL, 0x000000006060783bULL, 0x000fe20000004200ULL,
0x000000102d347824ULL, 0x000fc800078e0234ULL, 0x000000003c3c783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x00000018ff787819ULL, 0x002fe20000011455ULL,
0x0000010055777824ULL, 0x040fe200078e00ffULL, 0x0000888055d87816ULL, 0x040fe200000000ffULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ffcd7819ULL, 0x000fe20000011454ULL,
0x0000010054767824ULL, 0x040fe200078e00ffULL, 0x0000888054d37816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x000000d800d87306ULL, 0x000fe20000200c00ULL, 0x00000018ff767819ULL, 0x000fc40000011476ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff997819ULL, 0x000fe40000011457ULL,
0x0000888057d07816ULL, 0x000fe200000000ffULL, 0x0000005500d77306ULL, 0x0003e20000200c00ULL,
0x00000018ff987819ULL, 0x000fe40000011456ULL, 0x00000018ff917819ULL, 0x004fe40000011431ULL,
0x00008880319b7816ULL, 0x000fc400000000ffULL, 0x00000018ff907819ULL, 0x000fe20000011430ULL,
0x0000005400d27306ULL, 0x0005e20000200c00ULL, 0x0000010065557824ULL, 0x002fe200078e00ffULL,
0x0000888030977816ULL, 0x000fe400000000ffULL, 0x0000888056d17816ULL, 0x040fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000007600d67306ULL, 0x0003e20000200c00ULL,
0x0000010056547824ULL, 0x044fe200078e00ffULL, 0x00000018ff9d7819ULL, 0x000fe2000001146dULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x000088806dab7816ULL, 0x000fc400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000005500cc7306ULL, 0x0005e20000200c00ULL,
0x0000010057767824ULL, 0x042fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x00000018ffa87819ULL, 0x000fe40000011465ULL,
0x00000018ff767819ULL, 0x000fe40000011476ULL, 0x0000005400d47306ULL, 0x0003e20000200c00ULL,
0x0000010067557824ULL, 0x004fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fc40000011457ULL,
0x0000888065c77816ULL, 0x040fe200000000ffULL, 0x0001000065657824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005700ce7306ULL, 0x0005e20000200c00ULL,
0x0000010064547824ULL, 0x002fe200078e00ffULL, 0x00000018ff9f7819ULL, 0x000fe4000001146cULL,
0x000088806cb27816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000005500c17306ULL, 0x0003e20000200c00ULL, 0x00000004ff577819ULL, 0x004fe40000011600ULL,
0x00000018ff8b7819ULL, 0x000fe40000011432ULL, 0x0000888032947816ULL, 0x000fe400000000ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000005400ca7306ULL, 0x0005e20000200c00ULL,
0x0000010069557824ULL, 0x002fe200078e00ffULL, 0x00000018ffc37819ULL, 0x000fc40000011464ULL,
0x0000888064c97816ULL, 0x040fe200000000ffULL, 0x0001000064647824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000007600d57306ULL, 0x000fe20000200c00ULL,
0x0000010066547824ULL, 0x004fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000005500be7306ULL, 0x0003e20000200c00ULL, 0x00000018ffaf7819ULL, 0x000fe40000011468ULL,
0x00000018ffaa7819ULL, 0x000fe4000001146aULL, 0x0000888068b97816ULL, 0x000fe400000000ffULL,
0x000088806ab67816ULL, 0x000fe200000000ffULL, 0x0000005400c67306ULL, 0x0005e20000200c00ULL,
0x000001006b557824ULL, 0x002fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fc4000001146eULL,
0x000088806ea77816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005600cb7306ULL, 0x000fe20000200c00ULL, 0x0000010068547824ULL, 0x044fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe20000011433ULL, 0x0001000068687824ULL, 0x000fe200078e00ffULL,
0x0000888033937816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000005500b87306ULL, 0x0003e20000200c00ULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ffa97819ULL, 0x000fe4000001146bULL, 0x000088806bb37816ULL, 0x040fe200000000ffULL,
0x000100006b6b7824ULL, 0x000fe200078e00ffULL, 0x0000888066bf7816ULL, 0x000fe200000000ffULL,
0x0000005400c07306ULL, 0x0005e20000200c00ULL, 0x000001006d557824ULL, 0x002fe200078e00ffULL,
0x0000888067a67816ULL, 0x000fe200000000ffULL, 0x000100006d6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001146bULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x000001006a547824ULL, 0x044fe200078e00ffULL,
0x0000005500b07306ULL, 0x0003e20000200c00ULL, 0x000100006a6a7824ULL, 0x000fe200078e00ffULL,
0x00000018ffbd7819ULL, 0x000fe20000011466ULL, 0x0001000066667824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff6a7819ULL, 0x000fc4000001146aULL,
0x0000005400b57306ULL, 0x0005e20000200c00ULL, 0x000001006f557824ULL, 0x002fe200078e00ffULL,
0x00000018ffb77819ULL, 0x000fe20000011467ULL, 0x0001000067677824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000006d00ac7306ULL, 0x000fe20000200c00ULL, 0x000001006c547824ULL, 0x044fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x000100006c6c7824ULL, 0x000fe200078e00ffULL,
0x0000888069bb7816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005500a57306ULL, 0x0003e20000200c00ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000018ff797819ULL, 0x000fe20000011469ULL, 0x0001000069697824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x008fe4000001143cULL, 0x00000018ff7c7819ULL, 0x000fe2000001143dULL,
0x0000005400ad7306ULL, 0x0005e20000200c00ULL, 0x0000010031557824ULL, 0x042fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x000088806fa27816ULL, 0x000fc400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff9a7819ULL, 0x000fe20000011431ULL, 0x000001006e547824ULL, 0x004fe200078e00ffULL,
0x0000000700317812ULL, 0x000fe200078ec0ffULL, 0x00000055009e7306ULL, 0x000fe20000200c00ULL,
0x000100006e6e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001146fULL,
0x000100006f6f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000000831a07812ULL, 0x000fc400078ef800ULL, 0x0000005400a47306ULL, 0x0003e20000200c00ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000000757317812ULL, 0x000fe400078e78a0ULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff877819ULL, 0x000fe20000011460ULL,
0x00000008a0767824ULL, 0x000fe200078e0231ULL, 0x0000006500c57306ULL, 0x0005e20000200c00ULL,
0x0000010030547824ULL, 0x042fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe20000011461ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001143eULL,
0x0000010033317824ULL, 0x040fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000006c00ae7306ULL, 0x000fe20000200c00ULL, 0x00000002ff657819ULL, 0x004fc40000011600ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x00000018ff847819ULL, 0x000fe20000011462ULL, 0x00000054009c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff857819ULL, 0x000fe40000011463ULL, 0x00000018ff7e7819ULL, 0x000fe4000001143fULL,
0x00000018ff7f7819ULL, 0x010fc40000011434ULL, 0x00000018ff807819ULL, 0x000fe20000011435ULL,
0x0000003000957306ULL, 0x0005e20000200c00ULL, 0x0001200076547811ULL, 0x002fe400078e20ffULL,
0x00000018ff817819ULL, 0x000fe40000011436ULL, 0x00000018ff827819ULL, 0x000fe40000011437ULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0x0000007700d97306ULL, 0x0003e20000200c00ULL,
0x0000010032307824ULL, 0x004fc400078e00ffULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006400c87306ULL, 0x000fe20000200c00ULL, 0x0000000865777810ULL, 0x002fce0007ffe0ffULL,
0x00000030006d7306ULL, 0x0003f00000200c00ULL, 0x00000032006c7306ULL, 0x0005e20000200c00ULL,
0x00000026ff30723eULL, 0x002fce00000000ffULL, 0x0000003100967306ULL, 0x0003e20000200c00ULL,
0x0000541030327816ULL, 0x004fe20000000030ULL, 0x0000010060307824ULL, 0x000fc800078e00ffULL,
0x00001f6532657589ULL, 0x000ea200000e0000ULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x000000d300d37306ULL, 0x000ee20000200c00ULL, 0x00009910cf317816ULL, 0x002fe200000000ffULL,
0x00001f7732647589ULL, 0x00032600000e0000ULL, 0x000000ff3100720cULL, 0x000fe20003f05270ULL,
0x0000010061317824ULL, 0x000fe400078e00ffULL, 0x000000cd00cd7306ULL, 0x000ee60000200c00ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000010062327824ULL, 0x002fc800078e00ffULL,
0x0000007800787306ULL, 0x000e640000200c00ULL, 0x0000006554548232ULL, 0x004fcc0000000000ULL,
0x0000006800bc7306ULL, 0x000fe20000200c00ULL, 0x0000006556568232ULL, 0x000fe40000000000ULL,
0x0000006455558232ULL, 0x090fe40000000000ULL, 0x0000006457578232ULL, 0x000fc60000000000ULL,
0x0000006a00b17306ULL, 0x000ff00000200c00ULL, 0x0000003000687306ULL, 0x0007f00000200c00ULL,
0x00000031006a7306ULL, 0x0005e20000200c00ULL, 0x00005410d3307816ULL, 0x008fce00000000d6ULL,
0x000000d100d17306ULL, 0x000ee20000200c00ULL, 0x00005410d8317816ULL, 0x004fce00000000d9ULL,
0x000000d000d07306ULL, 0x000ea20000200c00ULL, 0x000000305444723cULL, 0x000fee0000001844ULL,
0x0000000200317811ULL, 0x000fe200078fe0ffULL, 0x0000006e00a37306ULL, 0x000fe20000200c00ULL,
0x00005410d2307816ULL, 0x000fe200000000cdULL, 0x0000010063cd7824ULL, 0x000fca00078e00ffULL,
0x00000018ffcd7819ULL, 0x000fe200000114cdULL, 0x00000033006e7306ULL, 0x0009f00000200c00ULL,
0x0000009800987306ULL, 0x000ea20000200c00ULL, 0x0000000731337812ULL, 0x010fc400078e78a0ULL,
0x00005410d7317816ULL, 0x002fc60000000078ULL, 0x00000008a0787824ULL, 0x000fe400078e0233ULL,
0x0000009900997306ULL, 0x000e640000200c00ULL, 0x000000305440723cULL, 0x000fec0000001840ULL,
0x000000c900c97306ULL, 0x000f220000200c00ULL, 0x00005410d1307816ULL, 0x008fc400000000d4ULL,
0x00005410d0317816ULL, 0x004fe400000000d5ULL, 0x00005410cb987816ULL, 0x000fe20000000098ULL,
0x0001000062cb7824ULL, 0x000fe400078e00ffULL, 0x000000c700c77306ULL, 0x000ea20000200c00ULL,
0x00005410ce997816ULL, 0x002fe20000000099ULL, 0x000000305438723cULL, 0x000fe20000001838ULL,
0x00000018ffcb7819ULL, 0x000fca00000114cbULL, 0x0000006b00b47306ULL, 0x0003e40000200c00ULL,
0x000000985448723cULL, 0x000fec0000001848ULL, 0x000000c300c37306ULL, 0x000ee20000200c00ULL,
0x00000018ff6b7819ULL, 0x002fe40000011432ULL, 0x0001200078327811ULL, 0x000fc400078e20ffULL,
0x00005410c9987816ULL, 0x010fe400000000caULL, 0x00005410c7997816ULL, 0x004fe200000000ccULL,
0x000000a800a87306ULL, 0x000e620000200c00ULL, 0x000000003230783bULL, 0x000ea20000000200ULL,
0x0001000063c77824ULL, 0x000fc800078e00ffULL, 0x00000098544c723cULL, 0x000fe4000000184cULL,
0x000000bf00bf7306ULL, 0x000f2a0000200c00ULL, 0x00005410c8987816ULL, 0x008fe400000000c3ULL,
0x000088803cc37816ULL, 0x000fe200000000ffULL, 0x000000a600a67306ULL, 0x000ee20000200c00ULL,
0x00005410c5997816ULL, 0x002fc400000000a8ULL, 0x00000018ffa87819ULL, 0x000fca00000114c7ULL,
0x000000bd00bd7306ULL, 0x000fe20000200c00ULL, 0x00000098545c723cULL, 0x000fee000000185cULL,
0x000000b700b77306ULL, 0x000fe20000200c00ULL, 0x00005410bf987816ULL, 0x010fe200000000c6ULL,
0x000001003cbf7824ULL, 0x000fe200078e00ffULL, 0x00005410a6997816ULL, 0x008fe200000000c1ULL,
0x000100003c3c7824ULL, 0x000fc400078e00ffULL, 0x000000ffffa67224ULL, 0x000fe200078e00c3ULL,
0x00000018ffbf7819ULL, 0x000fe200000114bfULL, 0x0000006600c47306ULL, 0x000e620000200c00ULL,
0x0000006530308232ULL, 0x084fe20000000000ULL, 0x000000985458723cULL, 0x000fe20000001858ULL,
0x0000006532328232ULL, 0x000fe40000000000ULL, 0x0000006431318232ULL, 0x080fe40000000000ULL,
0x0000006433338232ULL, 0x000fe20000000000ULL, 0x0000006700c27306ULL, 0x0004f00000200c00ULL,
0x000000b900b97306ULL, 0x000f220000200c00ULL, 0x00005410c4987816ULL, 0x002fc400000000bdULL,
0x0000888061677816ULL, 0x044fe200000000ffULL, 0x0001000061617824ULL, 0x000fc800078e00ffULL,
0x000000bb00bb7306ULL, 0x000e620000200c00ULL, 0x00005410c2997816ULL, 0x008fe400000000b7ULL,
0x00000018ffb77819ULL, 0x000fe4000001143cULL, 0x00000018ff617819ULL, 0x000fc60000011461ULL,
0x000000af00af7306ULL, 0x000ea20000200c00ULL, 0x000000985450723cULL, 0x000fee0000001850ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x00005410b9547816ULL, 0x010fe200000000c0ULL,
0x000001003d567824ULL, 0x000fe200078e00ffULL, 0x00005410bb557816ULL, 0x002fc400000000beULL,
0x000088803d987816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000006900ba7306ULL, 0x0002e40000200c00ULL,
0x000000543044723cULL, 0x000fe20000001844ULL, 0x00000018ff3d7819ULL, 0x000fca000001143dULL,
0x000000b600b67306ULL, 0x000f220000200c00ULL, 0x0000000400557811ULL, 0x000fe400078fe0ffULL,
0x00005410bc547816ULL, 0x004fe400000000afULL, 0x0000000755577812ULL, 0x000fe400078e78a0ULL,
0x0000888060697816ULL, 0x002fe200000000ffULL, 0x000000b300b37306ULL, 0x000e620000200c00ULL,
0x00005410ba557816ULL, 0x008fe20000000079ULL, 0x00000008a0797824ULL, 0x000fc400078e0257ULL,
0x0001000060607824ULL, 0x000fc600078e00ffULL, 0x00012000793c7811ULL, 0x000fe200078e20ffULL,
0x000000aa00aa7306ULL, 0x000fe20000200c00ULL, 0x000000543040723cULL, 0x000fe20000001840ULL,
0x00000018ff607819ULL, 0x000fcc0000011460ULL, 0x000000a900a97306ULL, 0x000ea20000200c00ULL,
0x00005410b6547816ULL, 0x010fe400000000b5ULL, 0x00005410b3557816ULL, 0x002fe400000000b8ULL,
0x000088803eb57816ULL, 0x000fc600000000ffULL, 0x000000b200b27306ULL, 0x000e700000200c00ULL,
0x000000ab00ab7306ULL, 0x000ef00000200c00ULL, 0x0000005600af7306ULL, 0x0009f00000200c00ULL,
0x0000003d00b37306ULL, 0x0005e20000200c00ULL, 0x000000543054723cULL, 0x010fe20000001838ULL,
0x000000003c38783bULL, 0x0008ec0000000200ULL, 0x0000009f009f7306ULL, 0x000e620000200c00ULL,
0x00005410b43d7816ULL, 0x004fe200000000a9ULL, 0x000000ffffa97224ULL, 0x000fe200078e00b5ULL,
0x00005410b13c7816ULL, 0x010fe200000000aaULL, 0x000001003eaa7824ULL, 0x000fc800078e00ffULL,
0x0000009d009d7306ULL, 0x000ea20000200c00ULL, 0x00000018ffaa7819ULL, 0x000fe200000114aaULL,
0x0000003c3048723cULL, 0x000fec0000001848ULL, 0x000000a700a77306ULL, 0x000f220000200c00ULL,
0x00005410b23c7816ULL, 0x002fe400000000adULL, 0x00005410ab3d7816ULL, 0x008fc400000000b0ULL,
0x000088803fab7816ULL, 0x000fc600000000ffULL, 0x000000a200a27306ULL, 0x000e640000200c00ULL,
0x0000003c304c723cULL, 0x040fec000000184cULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x00005410ae3c7816ULL, 0x000fe2000000009fULL, 0x0000006538388232ULL, 0x080fe20000000000ULL,
0x00005410ac3d7816ULL, 0x004fe2000000009dULL, 0x000001003f9d7824ULL, 0x040fe200078e00ffULL,
0x000000653a3a8232ULL, 0x000fe20000000000ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000006439398232ULL, 0x080fe20000000000ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x000000643b3b8232ULL, 0x000fe20000000000ULL, 0x0000003c305c723cULL, 0x000fe2000000185cULL,
0x000000ffff9f7224ULL, 0x000fca00078e00abULL, 0x0000006f00a17306ULL, 0x0005e20000200c00ULL,
0x00005410a73c7816ULL, 0x010fe400000000a4ULL, 0x00005410a23d7816ULL, 0x002fca00000000a5ULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x00008880626f7816ULL, 0x004fe200000000ffULL,
0x0000003c3058723cULL, 0x000fec0000001858ULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe4000001149dULL, 0x00005410a33c7816ULL, 0x008fe20000000092ULL,
0x000100003e927824ULL, 0x000fe200078e00ffULL, 0x00000006009d7811ULL, 0x000fc600078fe0ffULL,
0x0000009a009a7306ULL, 0x000ea20000200c00ULL, 0x000000079d9d7812ULL, 0x000fe400078e78a0ULL,
0x0000541095907816ULL, 0x002fca0000000090ULL, 0x0000009400947306ULL, 0x000ff00000200c00ULL,
0x0000009300937306ULL, 0x000e620000200c00ULL, 0x000054109a917816ULL, 0x004fce0000000091ULL,
0x0000006000667306ULL, 0x000fe20000200c00ULL, 0x000000903840723cULL, 0x000fee0000001840ULL,
0x0000003d003e7306ULL, 0x0005e20000200c00ULL, 0x0000888035917816ULL, 0x000fe400000000ffULL,
0x0000541093937816ULL, 0x002fca0000000096ULL, 0x0000006f00607306ULL, 0x0003e20000200c00ULL,
0x00005410a13d7816ULL, 0x004fe2000000007aULL, 0x00000008a07a7824ULL, 0x000fcc00078e029dULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x00008880636f7816ULL, 0x002fe200000000ffULL,
0x0000003c3030723cULL, 0x000fec0000001850ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000120007a507811ULL, 0x000fe200078e20ffULL, 0x0000010034517824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc40000011492ULL, 0x0000541094927816ULL, 0x000fe2000000006dULL,
0x000000ffff6d7224ULL, 0x000fe200078e0091ULL, 0x00000018ff907819ULL, 0x000fe20000011451ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x000000005050783bULL, 0x000ee20000000200ULL,
0x0000541069687816ULL, 0x004fe20000000068ULL, 0x0000010035917824ULL, 0x040fe200078e00ffULL,
0x000000923854723cULL, 0x000fe20000001854ULL, 0x00000018ff3d7819ULL, 0x000fe2000001143fULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00008880343f7816ULL, 0x040fe200000000ffULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x0000541067697816ULL, 0x002fe2000000006aULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fc40000011491ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x00000068384c723cULL, 0x000fee000000184cULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541061677816ULL, 0x004fce000000008aULL,
0x000000cd00627306ULL, 0x000ea20000200c00ULL, 0x0000541060607816ULL, 0x002fce000000006bULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x0000006550508232ULL, 0x088fe40000000000ULL,
0x0000006552528232ULL, 0x000fe40000000000ULL, 0x0000006451518232ULL, 0x080fe40000000000ULL,
0x0000006453538232ULL, 0x000fe20000000000ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x000054106f617816ULL, 0x004fe40000000062ULL, 0x0000888036627816ULL, 0x000fca00000000ffULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x000054106c6c7816ULL, 0x002fe2000000008bULL,
0x000000603858723cULL, 0x000fec0000001858ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000000ffff607224ULL, 0x000fe200078e0062ULL, 0x0000888037627816ULL, 0x000fe200000000ffULL,
0x0000010036617824ULL, 0x000fc400078e00ffULL, 0x0001000036367824ULL, 0x000fc600078e00ffULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x004fe40000000087ULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x00000018ff367819ULL, 0x000fc60000011436ULL,
0x0000009700977306ULL, 0x000e620000200c00ULL, 0x00000066385c723cULL, 0x000fee000000185cULL,
0x0000009b009b7306ULL, 0x000eb00000200c00ULL, 0x000000cb00637306ULL, 0x000ee20000200c00ULL,
0x00005410979c7816ULL, 0x002fce000000009cULL, 0x000000a800a87306ULL, 0x000e620000200c00ULL,
0x000054109b9d7816ULL, 0x004fce000000009eULL, 0x0000006d00927306ULL, 0x0005e20000200c00ULL,
0x0000541063847816ULL, 0x008fe20000000084ULL, 0x0000009c3844723cULL, 0x000fe20000001844ULL,
0x00005410a8857816ULL, 0x002fca0000000085ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054106e6d7816ULL, 0x004fe2000000008fULL, 0x000000843830723cULL, 0x040fec0000001830ULL,
0x0000006100617306ULL, 0x000e640000200c00ULL, 0x0000006c3848723cULL, 0x000fec0000001848ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000010037387824ULL, 0x000fc400078e00ffULL,
0x0001000037377824ULL, 0x000fca00078e00ffULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x0000541060607816ULL, 0x002fe40000000061ULL, 0x00000018ff637819ULL, 0x000fe40000011438ULL,
0x00000018ff377819ULL, 0x000fc60000011437ULL, 0x0000007d007d7306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x00005410b3b37816ULL, 0x004fce000000007cULL,
0x0000007f007f7306ULL, 0x000ff00000200c00ULL, 0x0000008000807306ULL, 0x000ff00000200c00ULL,
0x000000a600a67306ULL, 0x000ff00000200c00ULL, 0x000000bf00997306ULL, 0x000e700000200c00ULL,
0x0000009800987306ULL, 0x000eb00000200c00ULL, 0x000000b700b67306ULL, 0x000ee20000200c00ULL,
0x00005410a6a67816ULL, 0x002fce0000000099ULL, 0x000000a900a97306ULL, 0x000fe20000200c00ULL,
0x0000541098a77816ULL, 0x004fce00000000afULL, 0x000000aa00aa7306ULL, 0x000e620000200c00ULL,
0x00005410b6b27816ULL, 0x008fe2000000007bULL, 0x000000a65044723cULL, 0x040fec0000001844ULL,
0x0000009f009f7306ULL, 0x000ea40000200c00ULL, 0x000000b25040723cULL, 0x000fec0000001840ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x00005410a9387816ULL, 0x002fce00000000aaULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x000054109f397816ULL, 0x004fce000000003eULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x008fe2000000007dULL,
0x000000385038723cULL, 0x000fec0000001854ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054103d3d7816ULL, 0x002fce000000007eULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x0000003c5048723cULL, 0x000fee0000001848ULL, 0x0000003400347306ULL, 0x000ee20000200c00ULL,
0x000054103f907816ULL, 0x004fce0000000090ULL, 0x0000003500357306ULL, 0x000ea20000200c00ULL,
0x0000541092917816ULL, 0x002fce0000000091ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541034347816ULL, 0x008fe2000000007fULL, 0x00000090504c723cULL, 0x000fec000000184cULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000541035357816ULL, 0x004fce0000000080ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00000034505c723cULL, 0x000fee000000185cULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x0000541062617816ULL, 0x002fce0000000063ULL,
0x0000003600367306ULL, 0x000e620000200c00ULL, 0x000000605058723cULL, 0x000fee0000001858ULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000541036367816ULL, 0x002fe40000000081ULL,
0x0000541037377816ULL, 0x004fce0000000082ULL, 0x000000365050723cULL, 0x000fe20000001830ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff8cff7812ULL, 0x000fe2000782c0ffULL, 0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL,
0x0000004075307811ULL, 0x000fe400078e40ffULL, 0x00000001ff647807ULL, 0x000fe40000800000ULL,
0x000000307300720cULL, 0x000fe40003f24070ULL, 0x000000ff8dff7812ULL, 0x000fc4000784c0ffULL,
0x000000010800780cULL, 0x000fe40003f05270ULL, 0x00000001ff877807ULL, 0x000fe40001000000ULL,
0x0000008c648c7207ULL, 0x000fe40004000000ULL, 0x000000018e8e7812ULL, 0x000fe400078e0cffULL,
0x00007610878d7816ULL, 0x000fe2000000008dULL, 0x0000835000009947ULL, 0x000fea0003800000ULL,
0x01c65c00ff317984ULL, 0x000e620000000800ULL, 0x8000000087307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe20007824830ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x8000000087327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000058002f317a24ULL, 0x020fe200078e02ffULL, 0x0000000175337810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff637424ULL, 0x000fe200078e00ffULL, 0x0000008075327811ULL, 0x000fe200078e40ffULL,
0x0000008031627824ULL, 0x000fe200078e0202ULL, 0x000000703300720cULL, 0x000fe20003f26070ULL,
0x0000000808857824ULL, 0x040fe200078e00ffULL, 0x0000003273337217ULL, 0x000fe20007800000ULL,
0x0000400008847824ULL, 0x000fe200078e00ffULL, 0x0000007f62307812ULL, 0x040fe400078ef80aULL,
0x0000007f62347812ULL, 0x040fe200078ef80dULL, 0x0000000133607824ULL, 0x000fe200078e0a32ULL,
0x0000007f62357812ULL, 0x000fe200078ef80fULL, 0x00005e0030307625ULL, 0x000fe200078e0063ULL,
0x0000007f62367812ULL, 0x000fc400078ef810ULL, 0x0000004060617807ULL, 0x000fe20000800000ULL,
0x00005e0034327625ULL, 0x000fe200078e0063ULL, 0x0000000c303c7210ULL, 0x080fe40007f5e0ffULL,
0x0000007f62377812ULL, 0x000fe400078ef813ULL, 0x000000612e617217ULL, 0x000fe20007800000ULL,
0x000000ffff3d7224ULL, 0x000fe200010e0631ULL, 0x0000000c323e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0035307625ULL, 0x000fe200078e0063ULL, 0x0000007f62327812ULL, 0x000fc400078ef815ULL,
0x00004000848a7812ULL, 0x000fe200078ec0ffULL, 0x00005e0036347625ULL, 0x080fe200078e0063ULL,
0x0000000c30547210ULL, 0x080fe40007f7e0ffULL, 0x000140008a8a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200010e0633ULL, 0x0000000c34567210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff557224ULL, 0x000fe200018e0631ULL, 0x0000007f62347812ULL, 0x000fe200078ef819ULL,
0x00005e0032307625ULL, 0x000fe200078e0063ULL, 0x0000007f62327812ULL, 0x000fc400078ef816ULL,
0x00000004ff627819ULL, 0x000fe20000011600ULL, 0x00005e0037367625ULL, 0x000fc600078e0063ULL,
0x0000000262607810ULL, 0x000fe20007ffe0ffULL, 0x0000000161617824ULL, 0x000fe200078e0a2eULL,
0x0000000c36367210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff577224ULL, 0x000fe200010e0635ULL,
0x0000000c30307210ULL, 0x000fe20007f5e0ffULL, 0x00005e0034347625ULL, 0x000fe200078e0063ULL,
0x000000616000720cULL, 0x080fe40003fa6070ULL, 0x0000000462607810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff377224ULL, 0x000fe200018e0637ULL, 0x000000616200720cULL, 0x080fe20003f86070ULL,
0x000000ffff317224ULL, 0x000fe200010e0631ULL, 0x000000616000720cULL, 0x000fe20003f66070ULL,
0x00005e0032327625ULL, 0x000fe200078e0063ULL, 0x0000000885607812ULL, 0x000fc400078ec0ffULL,
0x0000000c34347210ULL, 0x080fe20007f5e0ffULL, 0x000000101b637824ULL, 0x100fe200078e028aULL,
0x00000000600573c2ULL, 0x000e6200000e0000ULL, 0x0000000862667810ULL, 0x000fe20007ffe0ffULL,
0x000000101c657824ULL, 0x100fe200078e028aULL, 0x0000000c32327210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff357224ULL, 0x000fe200010e0635ULL, 0x000000616600720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c637faeULL, 0x0005e2000e101c46ULL,
0x0000000a62667810ULL, 0x000fe20007ffe0ffULL, 0x000000101e677824ULL, 0x100fe200078e028aULL,
0x0000000662687810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff337224ULL, 0x000fe200008e0633ULL,
0x000000616600720cULL, 0x080fe20003f86070ULL, 0x000000003e657faeULL, 0x0007e2000e901c46ULL,
0x0000000c62667810ULL, 0x000fe20007ffe0ffULL, 0x000000101f697824ULL, 0x100fe200078e028aULL,
0x000000616800720cULL, 0x080fe20003f26070ULL, 0x0000000054677faeULL, 0x0009e2000d901c46ULL,
0x0000000e62627810ULL, 0x000fe20007ffe0ffULL, 0x00000010213d7824ULL, 0x104fe200078e028aULL,
0x000000616600720cULL, 0x080fe20003fa6070ULL, 0x0000001023637824ULL, 0x100fe200078e028aULL,
0x000000616200720cULL, 0x000fe20003f66070ULL, 0x0000001020617824ULL, 0x100fe200078e028aULL,
0x0001c6481d3c7811ULL, 0x000fe200078e18ffULL, 0x0001c64805057890ULL, 0x002fe2000fffe03fULL,
0x00000010223f7824ULL, 0x008fc600078e028aULL, 0x0000000056697faeULL, 0x0009e8000c901c46ULL,
0x0000000036617faeULL, 0x0009e8000d101c46ULL, 0x00000000303d7faeULL, 0x0009e8000e101c46ULL,
0x00000000323f7faeULL, 0x0009e8000e901c46ULL, 0x0000000034637faeULL, 0x0009e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000004003c317984ULL, 0x0102a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c61c00ff327984ULL, 0x000ee20000000800ULL,
0x0000008364837207ULL, 0x000fe20004000000ULL, 0x8000000024337824ULL, 0x000fc600078e00ffULL,
0x0000ffff83307812ULL, 0x000fc800078ec0ffULL, 0x0000888030347816ULL, 0x000fca00000000ffULL,
0x8000000034307824ULL, 0x000fca00078e00ffULL, 0x8000000031ff7812ULL, 0x004fe40007804830ULL,
0x8000000032ff7812ULL, 0x008fe20007824833ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff307424ULL, 0x000fe400078e00ffULL,
0x8000000024327824ULL, 0x000fe400078e00ffULL, 0x0000003000317305ULL, 0x0004e4000021f000ULL,
0x3fa0000030307823ULL, 0x004fe200000100ffULL, 0x000000310000735dULL, 0x008fe40003800000ULL,
0x01c61c00ff317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x01c0800025307984ULL, 0x000ea20000000800ULL, 0x00000001ffe27424ULL, 0x000fc600078e00ffULL,
0x01c2800025317984ULL, 0x0007220000000800ULL, 0x000000033000720bULL, 0x004fda0003f3d000ULL,
0x0000000000327806ULL, 0x000fc800008e0100ULL, 0x0000ffff32337812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x000000033000720bULL, 0x018fe40003f34000ULL,
0x00000030033c7209ULL, 0x002fe40007810000ULL, 0x00000002ff357819ULL, 0x000fc60000011600ULL,
0x8000003c03327221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b32327820ULL, 0x000fe40000410000ULL,
0x0000000000037806ULL, 0x000fe400008e0100ULL, 0x000000017400780cULL, 0x000fe40003f25270ULL,
0x0000ffff03367812ULL, 0x000fe200078e3cffULL, 0x0000003200327308ULL, 0x000e660000000800ULL,
0x0000003633ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ffe27807ULL, 0x000fc60001000000ULL,
0x01c4803c25009388ULL, 0x000fe80000000800ULL, 0x00001f3532037589ULL, 0x002e6400000e0000ULL,
0x8000003c30332221ULL, 0x000fe40000010000ULL, 0x0000003204047220ULL, 0x000fe20000410000ULL,
0x00001f7732307589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b33332820ULL, 0x000fc80000410000ULL,
0x0000003300262308ULL, 0x000ee20000000800ULL, 0x0000000344447220ULL, 0x082fe40000410000ULL,
0x0000000345457220ULL, 0x080fe40000410000ULL, 0x0000000340407220ULL, 0x080fe40000410000ULL,
0x0000000341417220ULL, 0x080fe40000410000ULL, 0x0000000338387220ULL, 0x080fe40000410000ULL,
0x0000000339397220ULL, 0x000fc40000410000ULL, 0x0000000348487220ULL, 0x080fe40000410000ULL,
0x0000000349497220ULL, 0x080fe40000410000ULL, 0x000000034c4c7220ULL, 0x080fe40000410000ULL,
0x000000034d4d7220ULL, 0x080fe40000410000ULL, 0x000000035c5c7220ULL, 0x080fe40000410000ULL,
0x000000035d5d7220ULL, 0x000fc40000410000ULL, 0x0000000358587220ULL, 0x080fe40000410000ULL,
0x0000000359597220ULL, 0x080fe40000410000ULL, 0x0000000350507220ULL, 0x080fe40000410000ULL,
0x0000000351517220ULL, 0x000fe40000410000ULL, 0x0000003046467220ULL, 0x084fe40000410000ULL,
0x0000003047477220ULL, 0x000fc40000410000ULL, 0x0000003042427220ULL, 0x080fe40000410000ULL,
0x0000003043437220ULL, 0x080fe40000410000ULL, 0x000000303a3a7220ULL, 0x080fe40000410000ULL,
0x000000303b3b7220ULL, 0x080fe40000410000ULL, 0x000000304a4a7220ULL, 0x080fe40000410000ULL,
0x000000304b4b7220ULL, 0x000fc40000410000ULL, 0x000000304e4e7220ULL, 0x080fe40000410000ULL,
0x000000304f4f7220ULL, 0x080fe40000410000ULL, 0x000000305e5e7220ULL, 0x080fe40000410000ULL,
0x000000305f5f7220ULL, 0x080fe40000410000ULL, 0x000000305a5a7220ULL, 0x080fe40000410000ULL,
0x000000305b5b7220ULL, 0x000fc40000410000ULL, 0x0000003052527220ULL, 0x080fe40000410000ULL,
0x0000003053537220ULL, 0x000fe40000410000ULL, 0x000000ffff037224ULL, 0x000fe400078e003cULL,
0x0000003126312220ULL, 0x008fc80000410000ULL, 0x0000000431047221ULL, 0x018fe20000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x0001c6481d327811ULL, 0x000fe200078e18ffULL,
0x8000000034317824ULL, 0x000fc800078e00ffULL, 0x0000040032307984ULL, 0x000ea40000000800ULL,
0x8000000030ff7812ULL, 0x004fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000034347824ULL, 0x000fe400078e00ffULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0004e4000021f000ULL,
0x3fa0000030307823ULL, 0x004fe200000100ffULL, 0x000000310000735dULL, 0x008fe40003800000ULL,
0x0000040032317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fc40007804834ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000001088b7812ULL, 0x000fc800078e0cffULL, 0x000140008b8b7811ULL, 0x000fca00078e70ffULL,
0x0000001088827824ULL, 0x100fe400078e028bULL, 0x0000001027817824ULL, 0x100fe400078e028bULL,
0x0000001028807824ULL, 0x100fe200078e028bULL, 0x000000008254783bULL, 0x000ea20000004200ULL,
0x00000010297f7824ULL, 0x100fe400078e028bULL, 0x000000102a7e7824ULL, 0x100fe200078e028bULL,
0x000000008164783bULL, 0x000fe20000004200ULL, 0x000000102b7d7824ULL, 0x000fc400078e028bULL,
0x000000102c7b7824ULL, 0x100fe200078e028bULL, 0x000000008068783bULL, 0x000fe20000004200ULL,
0x000000102d7c7824ULL, 0x000fc600078e028bULL, 0x000000007f6c783bULL, 0x000fe80000004200ULL,
0x000000007e60783bULL, 0x000ee80000004200ULL, 0x000000007d30783bULL, 0x000f280000004200ULL,
0x000000007b3c783bULL, 0x002e680000004200ULL, 0x000000007c34783bULL, 0x000f620000004200ULL,
0x00000018ffdf7819ULL, 0x004fe20000011454ULL, 0x00000100549c7824ULL, 0x040fe200078e00ffULL,
0x0000888054e17816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x00000018ffde7819ULL, 0x000fe20000011455ULL, 0x00000100559d7824ULL, 0x040fe200078e00ffULL,
0x0000888055e57816ULL, 0x040fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x000000e100e17306ULL, 0x000fe20000200c00ULL,
0x00000018ff9c7819ULL, 0x000fc4000001149cULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ffd87819ULL, 0x000fe40000011456ULL, 0x00000018ffa67819ULL, 0x000fe20000011457ULL,
0x0000005400e07306ULL, 0x0005e20000200c00ULL, 0x0000888056da7816ULL, 0x000fe400000000ffULL,
0x0000888057a17816ULL, 0x000fe400000000ffULL, 0x00000018ff9d7819ULL, 0x000fc4000001149dULL,
0x00000018ff9a7819ULL, 0x008fe20000011460ULL, 0x0000005500e37306ULL, 0x0007e20000200c00ULL,
0x0000010056547824ULL, 0x004fe200078e00ffULL, 0x0000888060a77816ULL, 0x000fe200000000ffULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ffa07819ULL, 0x000fe4000001146fULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000009c00e47306ULL, 0x0004620000200c00ULL,
0x0000010065557824ULL, 0x008fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x000088806fb07816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400dd7306ULL, 0x0007e20000200c00ULL, 0x00000100579c7824ULL, 0x044fe200078e00ffULL,
0x00000018ffb17819ULL, 0x000fe20000011465ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x0000888065ac7816ULL, 0x040fe200000000ffULL, 0x0001000065657824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fc40000011462ULL, 0x0000005500d57306ULL, 0x0005e20000200c00ULL,
0x0000010064547824ULL, 0x008fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00008880629f7816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000009d00e67306ULL, 0x000fe20000200c00ULL, 0x0000010067557824ULL, 0x004fe200078e00ffULL,
0x00000018ffd27819ULL, 0x000fc40000011464ULL, 0x0000888064d77816ULL, 0x040fe200000000ffULL,
0x0001000064647824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400d67306ULL, 0x0005e20000200c00ULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff9b7819ULL, 0x000fe40000011461ULL,
0x0000888061a57816ULL, 0x000fe200000000ffULL, 0x0000005500cf7306ULL, 0x0007e20000200c00ULL,
0x0000010066547824ULL, 0x004fe200078e00ffULL, 0x00000018ffc07819ULL, 0x000fc40000011468ULL,
0x00000018ffb47819ULL, 0x000fe4000001146bULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005600db7306ULL, 0x000fe20000200c00ULL, 0x0000010069557824ULL, 0x008fe200078e00ffULL,
0x0000888068c97816ULL, 0x000fe400000000ffULL, 0x000088806bc17816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x000fc40000011455ULL, 0x0000005400d07306ULL, 0x0005e20000200c00ULL,
0x00000018ffca7819ULL, 0x000fe40000011466ULL, 0x00000018ffbf7819ULL, 0x000fe40000011469ULL,
0x0000888066d17816ULL, 0x040fe200000000ffULL, 0x0001000066667824ULL, 0x000fe200078e00ffULL,
0x0000888069c87816ULL, 0x040fe200000000ffULL, 0x0000005500cb7306ULL, 0x0007e20000200c00ULL,
0x0000010068547824ULL, 0x044fe200078e00ffULL, 0x00000018ff967819ULL, 0x010fe20000011430ULL,
0x0001000068687824ULL, 0x000fe200078e00ffULL, 0x00000018ff977819ULL, 0x000fe20000011431ULL,
0x0001000069697824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000005700d97306ULL, 0x000fe20000200c00ULL, 0x000001006b557824ULL, 0x048fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x000100006b6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff9c7819ULL, 0x000fe4000001149cULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400cc7306ULL, 0x0005e20000200c00ULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x00000018ff667819ULL, 0x000fc40000011466ULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ffb67819ULL, 0x000fe2000001146aULL, 0x0000005500c27306ULL, 0x0007e20000200c00ULL,
0x000001006a547824ULL, 0x044fe200078e00ffULL, 0x000088806ac47816ULL, 0x040fe200000000ffULL,
0x000100006a6a7824ULL, 0x000fe200078e00ffULL, 0x00000018ffa97819ULL, 0x000fe4000001146dULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000006500d47306ULL, 0x0005e20000200c00ULL,
0x000001006d557824ULL, 0x008fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fc4000001146aULL,
0x000088806db77816ULL, 0x040fe200000000ffULL, 0x000100006d6d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005400c37306ULL, 0x0007e20000200c00ULL,
0x00000002ff657819ULL, 0x004fe40000011600ULL, 0x00000018ffab7819ULL, 0x000fe4000001146cULL,
0x000088806cbe7816ULL, 0x040fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000005500bc7306ULL, 0x0005e20000200c00ULL, 0x000001006c547824ULL, 0x048fe200078e00ffULL,
0x00000018ffa27819ULL, 0x000fe2000001146eULL, 0x000100006c6c7824ULL, 0x000fe200078e00ffULL,
0x000088806eb57816ULL, 0x000fc400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000006400d37306ULL, 0x000fe20000200c00ULL, 0x000001006f557824ULL, 0x044fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x000100006f6f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff997819ULL, 0x000fe40000011463ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400b97306ULL, 0x0005e20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fc4000001146fULL,
0x0000888067ae7816ULL, 0x040fe400000000ffULL, 0x00000018ffc77819ULL, 0x000fe20000011467ULL,
0x0001000067677824ULL, 0x000fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fe20000011432ULL,
0x0000005500b37306ULL, 0x0007e20000200c00ULL, 0x000001006e547824ULL, 0x044fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011433ULL, 0x000100006e6e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x0000006f00ad7306ULL, 0x000fe20000200c00ULL, 0x0000010061557824ULL, 0x048fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x00000018ff937819ULL, 0x002fe4000001143cULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005400b27306ULL, 0x0003e20000200c00ULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x00000018ff927819ULL, 0x000fc4000001143dULL, 0x00000018ff917819ULL, 0x000fe4000001143eULL,
0x00000018ff907819ULL, 0x000fe2000001143fULL, 0x0000005500a87306ULL, 0x0005e20000200c00ULL,
0x0000010060547824ULL, 0x042fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x020fe20000011434ULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe40000011435ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000010063557824ULL, 0x004fe200078e00ffULL, 0x0000005400aa7306ULL, 0x0003e20000200c00ULL,
0x00000018ff8d7819ULL, 0x000fc40000011436ULL, 0x00000018ff8c7819ULL, 0x000fe40000011437ULL,
0x00000018ff9d7819ULL, 0x000fc60000011455ULL, 0x0000006000a37306ULL, 0x0005e20000200c00ULL,
0x0000010062547824ULL, 0x042fe400078e00ffULL, 0x0001000062627824ULL, 0x000fc600078e00ffULL,
0x00000018ff9e7819ULL, 0x000fe40000011454ULL, 0x0001280076547811ULL, 0x000fe200078e20ffULL,
0x0000006100a47306ULL, 0x0003e20000200c00ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000026ff60723eULL, 0x004fe400000000ffULL, 0x000000005454783bULL, 0x000fe60000000200ULL,
0x00000062006f7306ULL, 0x0005e20000200c00ULL, 0x00009910e2617816ULL, 0x002fc800000000ffULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x0000010031617824ULL, 0x000fe400078e00ffULL,
0x000000e500e57306ULL, 0x000e620000200c00ULL, 0x0000541060627816ULL, 0x004fe20000000060ULL,
0x0000010030607824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc60000011461ULL,
0x00001f6562657589ULL, 0x000ea200000e0000ULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000006800c57306ULL, 0x0007e40000200c00ULL, 0x00001f7762647589ULL, 0x000f2c00000e0000ULL,
0x0000006b00bb7306ULL, 0x000be20000200c00ULL, 0x0000888031687816ULL, 0x048fe200000000ffULL,
0x0001000031317824ULL, 0x000fca00078e00ffULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x000000df00df7306ULL, 0x000ee20000200c00ULL, 0x00008880306b7816ULL, 0x060fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x0000006554548232ULL, 0x004fc80000000000ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000de00de7306ULL, 0x000ea20000200c00ULL,
0x0000006556568232ULL, 0x000fe40000000000ULL, 0x0000006455558232ULL, 0x090fe40000000000ULL,
0x0000006457578232ULL, 0x000fc60000000000ULL, 0x000000da00da7306ULL, 0x000f300000200c00ULL,
0x000000a100a17306ULL, 0x000ff00000200c00ULL, 0x0000009c00dc7306ULL, 0x000a700000200c00ULL,
0x0000006600cd7306ULL, 0x000fe20000200c00ULL, 0x00008880639c7816ULL, 0x060fe200000000ffULL,
0x0001000063637824ULL, 0x000fca00078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011463ULL,
0x0000006900c67306ULL, 0x000ff00000200c00ULL, 0x0000003000697306ULL, 0x000bf00000200c00ULL,
0x0000003100667306ULL, 0x0003e20000200c00ULL, 0x00005410e1307816ULL, 0x020fce00000000e4ULL,
0x0000006a00bd7306ULL, 0x000fe20000200c00ULL, 0x00005410e5317816ULL, 0x002fce00000000e6ULL,
0x000000d800d87306ULL, 0x000fe20000200c00ULL, 0x000000305444723cULL, 0x000fee0000001844ULL,
0x000000a600a67306ULL, 0x000e620000200c00ULL, 0x00005410e0307816ULL, 0x008fe400000000dfULL,
0x00005410e3317816ULL, 0x004fca00000000deULL, 0x00000060006a7306ULL, 0x0005e40000200c00ULL,
0x000000305440723cULL, 0x000fec0000001840ULL, 0x0000006c00ba7306ULL, 0x0007e20000200c00ULL,
0x0000010032607824ULL, 0x004fe200078e00ffULL, 0x0001280078307811ULL, 0x000fc400078e20ffULL,
0x0000888033317816ULL, 0x000fc800000000ffULL, 0x0000006d00b87306ULL, 0x000fe20000200c00ULL,
0x00000018ff6c7819ULL, 0x008fe40000011460ULL, 0x00005410da607816ULL, 0x010fe200000000ddULL,
0x0000010033da7824ULL, 0x040fe400078e00ffULL, 0x0001000033337824ULL, 0x000fe400078e00ffULL,
0x00000061006d7306ULL, 0x0005e60000200c00ULL, 0x00000018ff337819ULL, 0x000fca0000011433ULL,
0x000000d700d77306ULL, 0x000ee20000200c00ULL, 0x00005410a1617816ULL, 0x004fe200000000dcULL,
0x000000ffffa17224ULL, 0x000fe200078e0031ULL, 0x00005410d9317816ULL, 0x002fe400000000a6ULL,
0x00000018ffa67819ULL, 0x000fc600000114daULL, 0x000000ac00ac7306ULL, 0x000e700000200c00ULL,
0x0000006e00af7306ULL, 0x000ff00000200c00ULL, 0x00000063006e7306ULL, 0x0005f00000200c00ULL,
0x000000d200d27306ULL, 0x000f220000200c00ULL, 0x000000605460723cULL, 0x004fe20000001838ULL,
0x000000003038783bULL, 0x00056c0000000200ULL, 0x000000b100b17306ULL, 0x000e620000200c00ULL,
0x00005410db307816ULL, 0x004fce00000000d8ULL, 0x000000d100d17306ULL, 0x000ea20000200c00ULL,
0x000000305448723cULL, 0x000fee0000001848ULL, 0x000000ae00ae7306ULL, 0x000ea20000200c00ULL,
0x00005410d7307816ULL, 0x008fe400000000d6ULL, 0x00005410ac317816ULL, 0x002fca00000000d5ULL,
0x000000ca00ca7306ULL, 0x000e640000200c00ULL, 0x00000030544c723cULL, 0x000fec000000184cULL,
0x000000c700c77306ULL, 0x000fe20000200c00ULL, 0x00005410d3307816ULL, 0x010fe200000000d2ULL,
0x0000006538388232ULL, 0x0a0fe20000000000ULL, 0x00005410d4317816ULL, 0x000fe200000000b1ULL,
0x000000653a3a8232ULL, 0x000fe20000000000ULL, 0x000088803cd27816ULL, 0x000fe200000000ffULL,
0x0000006439398232ULL, 0x000fc40000000000ULL, 0x0000006700ce7306ULL, 0x0007220000200c00ULL,
0x000000643b3b8232ULL, 0x000fe20000000000ULL, 0x00000030545c723cULL, 0x000fec000000185cULL,
0x000000c900c97306ULL, 0x000f620000200c00ULL, 0x00005410d1307816ULL, 0x004fe400000000d0ULL,
0x00005410ae317816ULL, 0x000fe200000000cfULL, 0x000000ffffae7224ULL, 0x000fe200078e00d2ULL,
0x0000888032677816ULL, 0x048fe200000000ffULL, 0x0001000032327824ULL, 0x000fc400078e00ffULL,
0x000000c800c87306ULL, 0x000ea40000200c00ULL, 0x000000305458723cULL, 0x000fe20000001858ULL,
0x00000018ff327819ULL, 0x000fca0000011432ULL, 0x000000bf00bf7306ULL, 0x000ee20000200c00ULL,
0x00005410cd307816ULL, 0x002fe400000000caULL, 0x00005410ce317816ULL, 0x010fca00000000c7ULL,
0x000000b600b67306ULL, 0x000fe40000200c00ULL, 0x000000305450723cULL, 0x000fec0000001850ULL,
0x000000b400b47306ULL, 0x000fe20000200c00ULL, 0x000088803d547816ULL, 0x000fe400000000ffULL,
0x00005410c9307816ULL, 0x020fc400000000ccULL, 0x00005410c8317816ULL, 0x004fc600000000cbULL,
0x000000c000c07306ULL, 0x000e680000200c00ULL, 0x000000303844723cULL, 0x000fe80000001844ULL,
0x0000003200ac7306ULL, 0x0005e60000200c00ULL, 0x00005410c6317816ULL, 0x008fca00000000bfULL,
0x0000003300b17306ULL, 0x0007e20000200c00ULL, 0x000001003c327824ULL, 0x044fe200078e00ffULL,
0x00005410c5307816ULL, 0x002fe200000000c0ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803ec07816ULL, 0x000fe400000000ffULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x000000be00be7306ULL, 0x000fe20000200c00ULL, 0x000001003d337824ULL, 0x048fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000000303840723cULL, 0x000fe40000001840ULL, 0x00000018ff337819ULL, 0x000fc40000011433ULL,
0x000000b700b77306ULL, 0x000fe20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x000000c400c47306ULL, 0x000e700000200c00ULL, 0x000000c100c17306ULL, 0x000eb00000200c00ULL,
0x0000003c00567306ULL, 0x0007e20000200c00ULL, 0x00005410c4307816ULL, 0x002fce00000000c3ULL,
0x0000003d00bf7306ULL, 0x0003e20000200c00ULL, 0x00005410bd3c7816ULL, 0x008fe200000000b6ULL,
0x000001003eb67824ULL, 0x000fe200078e00ffULL, 0x00005410c1317816ULL, 0x004fc800000000c2ULL,
0x00000018ffb67819ULL, 0x000fe200000114b6ULL, 0x000000ab00ab7306ULL, 0x000ea20000200c00ULL,
0x00005410bb3d7816ULL, 0x002fe200000000b4ULL, 0x000000303860723cULL, 0x000fe20000001860ULL,
0x000000ffffb47224ULL, 0x000fca00078e00c0ULL, 0x000000a900a97306ULL, 0x000e640000200c00ULL,
0x0000003c3848723cULL, 0x000fec0000001848ULL, 0x000000b500b57306ULL, 0x000ee20000200c00ULL,
0x00005410be3c7816ULL, 0x000fe400000000b9ULL, 0x00005410b73d7816ULL, 0x000fc400000000bcULL,
0x000088803fb97816ULL, 0x000fc600000000ffULL, 0x000000b000b07306ULL, 0x000f240000200c00ULL,
0x0000003c384c723cULL, 0x000fec000000184cULL, 0x0000003200557306ULL, 0x000be20000200c00ULL,
0x00005410ba3c7816ULL, 0x004fe200000000abULL, 0x000001003fab7824ULL, 0x040fe200078e00ffULL,
0x00005410b83d7816ULL, 0x002fe200000000a9ULL, 0x000100003f3f7824ULL, 0x000fc400078e00ffULL,
0x000000ffffa97224ULL, 0x000fe400078e00b9ULL, 0x0000003300577306ULL, 0x0003e20000200c00ULL,
0x0001280079327811ULL, 0x020fe200078e20ffULL, 0x0000003c385c723cULL, 0x000fe2000000185cULL,
0x00000018ff3f7819ULL, 0x000fca000001143fULL, 0x000000a200a27306ULL, 0x000fe20000200c00ULL,
0x000000003230783bULL, 0x002e620000000200ULL, 0x00005410b53c7816ULL, 0x008fe400000000b2ULL,
0x00005410b03d7816ULL, 0x010fc800000000b3ULL, 0x000000a000a07306ULL, 0x000ea60000200c00ULL,
0x0000003c3858723cULL, 0x000fea0000001858ULL, 0x000000a700a77306ULL, 0x000ee40000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe200000114abULL, 0x000100003eab7824ULL, 0x000fca00078e00ffULL,
0x0000003c003e7306ULL, 0x0009e20000200c00ULL, 0x00005410ad3d7816ULL, 0x004fe400000000a0ULL,
0x00000018ffa07819ULL, 0x000fca00000114abULL, 0x000000a500a57306ULL, 0x000ea20000200c00ULL,
0x00005410af3c7816ULL, 0x010fe400000000a2ULL, 0x0000888034a27816ULL, 0x000fca00000000ffULL,
0x0000003c3838723cULL, 0x000fe20000001850ULL, 0x0000009a009a7306ULL, 0x000f220000200c00ULL,
0x0000006530308232ULL, 0x082fe40000000000ULL, 0x0000006532328232ULL, 0x000fe40000000000ULL,
0x0000006431318232ULL, 0x080fe20000000000ULL, 0x000128007a507811ULL, 0x000fe200078e20ffULL,
0x0000006433338232ULL, 0x000fe20000000000ULL, 0x0000009b009b7306ULL, 0x000e620000200c00ULL,
0x00005410a73c7816ULL, 0x008fc400000000aaULL, 0x00005410a53d7816ULL, 0x004fe200000000a8ULL,
0x000000005050783bULL, 0x000ea80000000200ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x00005410a39a7816ULL, 0x010fe2000000009aULL, 0x0000003c3044723cULL, 0x000fec0000001844ULL,
0x0000006800687306ULL, 0x000f220000200c00ULL, 0x00000100343c7824ULL, 0x000fe200078e00ffULL,
0x00005410a49b7816ULL, 0x002fe2000000009bULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000009800987306ULL, 0x000e620000200c00ULL,
0x0000009a3040723cULL, 0x000fe20000001840ULL, 0x000054106b6a7816ULL, 0x008fe4000000006aULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x0000009900997306ULL, 0x000ee20000200c00ULL,
0x00005410686b7816ULL, 0x010fe4000000006dULL, 0x00008880359a7816ULL, 0x000fca00000000ffULL,
0x0000009600967306ULL, 0x000f220000200c00ULL, 0x000054106f987816ULL, 0x002fe20000000098ULL,
0x0000006a304c723cULL, 0x000fe2000000184cULL, 0x0000006550508232ULL, 0x084fe40000000000ULL,
0x0000006552528232ULL, 0x000fe20000000000ULL, 0x0000010036657824ULL, 0x000fe400078e00ffULL,
0x0000009700977306ULL, 0x000e620000200c00ULL, 0x000054106e997816ULL, 0x008fe20000000099ULL,
0x0000006451518232ULL, 0x080fe20000000000ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000006453538232ULL, 0x000fc80000000000ULL, 0x0000009f009f7306ULL, 0x000fe20000200c00ULL,
0x0000541069967816ULL, 0x010fe20000000096ULL, 0x000000983048723cULL, 0x000fec0000001848ULL,
0x0000009e009e7306ULL, 0x000fe20000200c00ULL, 0x0000541066977816ULL, 0x002fce0000000097ULL,
0x0000009c009c7306ULL, 0x000fe20000200c00ULL, 0x00000096305c723cULL, 0x000fee000000185cULL,
0x0000009d009d7306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000054109c3d7816ULL, 0x002fce000000009dULL,
0x000000a100a17306ULL, 0x000ff00000200c00ULL, 0x000000a600a67306ULL, 0x000e620000200c00ULL,
0x00005410676c7816ULL, 0x004fce000000006cULL, 0x0000009500957306ULL, 0x000eb00000200c00ULL,
0x0000009400947306ULL, 0x000ee20000200c00ULL, 0x00005410a16d7816ULL, 0x002fce00000000a6ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00005410acac7816ULL, 0x004fe20000000095ULL,
0x0000006c3058723cULL, 0x000fec0000001858ULL, 0x0000003c009b7306ULL, 0x0005e20000200c00ULL,
0x00005410b1ad7816ULL, 0x008fce0000000094ULL, 0x000000ae00ae7306ULL, 0x000ee20000200c00ULL,
0x000054109f3c7816ULL, 0x004fe4000000009eULL, 0x0000541054af7816ULL, 0x002fca0000000057ULL,
0x0000003c3060723cULL, 0x040fe20000001860ULL, 0x000000a900a97306ULL, 0x000e6c0000200c00ULL,
0x000000ffff3d7224ULL, 0x000fe200078e009aULL, 0x000000ac3030723cULL, 0x000fe20000001838ULL,
0x00000100359a7824ULL, 0x040fe200078e00ffULL, 0x00008880363c7816ULL, 0x000fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00005410aeae7816ULL, 0x008fe20000000055ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000888037387816ULL, 0x000fc400000000ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x000000ae5044723cULL, 0x000fe20000001844ULL,
0x00000018ff367819ULL, 0x000fe20000011436ULL, 0x000000ffff547224ULL, 0x000fe200078e0038ULL,
0x00005410a9397816ULL, 0x002fe2000000003eULL, 0x0000010037387824ULL, 0x040fe200078e00ffULL,
0x0000009a009a7306ULL, 0x000e620000200c00ULL, 0x0001000037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011438ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000009300937306ULL, 0x000eb00000200c00ULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x000054103da37816ULL, 0x002fce000000009aULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x004fce0000000093ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00005410bf577816ULL, 0x008fce0000000092ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x000000565040723cULL, 0x000fee0000001840ULL, 0x0000008e008e7306ULL, 0x000ff00000200c00ULL,
0x000000b400b47306ULL, 0x000ff00000200c00ULL, 0x000000b600b77306ULL, 0x000e700000200c00ULL,
0x000000a000a07306ULL, 0x000eb00000200c00ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x00005410b4387816ULL, 0x002fce00000000b7ULL, 0x000000a200a27306ULL, 0x000e620000200c00ULL,
0x00005410a03e7816ULL, 0x004fe20000000091ULL, 0x000000385038723cULL, 0x000fec0000001860ULL,
0x0000003400347306ULL, 0x000ea20000200c00ULL, 0x000054103f3f7816ULL, 0x008fce0000000090ULL,
0x0000003500357306ULL, 0x000ee20000200c00ULL, 0x00005410a2a27816ULL, 0x002fe2000000009bULL,
0x0000003e5048723cULL, 0x040fec0000001848ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541034347816ULL, 0x004fe2000000008fULL, 0x000000a2504c723cULL, 0x000fec000000184cULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0000541035357816ULL, 0x008fce000000008eULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x00000034505c723cULL, 0x000fee000000185cULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce0000000065ULL,
0x0000008d008d7306ULL, 0x000ff00000200c00ULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x00005410543d7816ULL, 0x004fce0000000055ULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x0000003c5058723cULL, 0x000fee0000001858ULL, 0x0000003700377306ULL, 0x000ea20000200c00ULL,
0x0000541036367816ULL, 0x002fe4000000008dULL, 0x0000541037377816ULL, 0x004fce000000008cULL,
0x000000365050723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ff83ff7812ULL, 0x000fe2000784c0ffULL,
0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL, 0x0000008075307811ULL, 0x000fe400078e40ffULL,
0x00000001ff6c7807ULL, 0x000fe40001000000ULL, 0x000000307300720cULL, 0x000fe40003f44070ULL,
0x000000ff09ff7812ULL, 0x000fc4000780c0ffULL, 0x00000001088e7812ULL, 0x000fe4000782c0ffULL,
0x00000001ff8d7807ULL, 0x000fe40004000000ULL, 0x000000836c8c7207ULL, 0x000fca0004800000ULL,
0x000057800000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff317984ULL, 0x000e620000000800ULL,
0x00000001ff327807ULL, 0x000fca0004000000ULL, 0x8000000032307824ULL, 0x000fca00078e00ffULL,
0x8000000031ff7812ULL, 0x002fe20007824830ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007824830ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000032327824ULL, 0x000fe400078e00ffULL,
0x3e000000ff307424ULL, 0x000fc800078e00ffULL, 0x0000003000317305ULL, 0x0002a4000021f000ULL,
0x3fa0000030307823ULL, 0x002fe200000100ffULL, 0x000000310000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fc40007824832ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000189717824ULL, 0x000fe400078e0286ULL, 0x00000300ff307624ULL, 0x000fe400078e00ffULL,
0x000058002f337a24ULL, 0x000fe200078e02ffULL, 0x0000000171317812ULL, 0x000fe200078ec0ffULL,
0xffffffffff2f7424ULL, 0x000fe200078e00ffULL, 0xffffffff30307811ULL, 0x000fe400078e08ffULL,
0x000000013100780cULL, 0x000fc80003f25070ULL, 0x0000000130307807ULL, 0x000fca0004800000ULL,
0x0000000171717824ULL, 0x000fca00078e0230ULL, 0x000000727100720cULL, 0x000fe20003f26070ULL,
0x0000008033357824ULL, 0x000fe200078e0202ULL, 0x000000c075327811ULL, 0x000fc800078e40ffULL,
0x0000004035357810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff617424ULL, 0x000fcc00078e00ffULL,
0x0000000171309824ULL, 0x000fe400078e0206ULL, 0x00000004ff319424ULL, 0x000fe200078e00ffULL,
0x0000003273337217ULL, 0x000fe20007800000ULL, 0x000000010b0b7824ULL, 0x000fe400078e0235ULL,
0x0000600030309625ULL, 0x000fe200078e0031ULL, 0x0000000175377810ULL, 0x000fc80007ffe0ffULL,
0x00000006302f9981ULL, 0x000362000c1e1900ULL, 0x0000000133347824ULL, 0x000fe200078e0a32ULL,
0x000000703700720cULL, 0x000fe20003f66070ULL, 0x000000010e327824ULL, 0x100fe200078e0235ULL,
0x00000004ff0e7819ULL, 0x000fe20000011600ULL, 0x0000000111117824ULL, 0x000fe200078e0235ULL,
0x000000001d0573c2ULL, 0x000ea200000e0000ULL, 0x00005e0032327625ULL, 0x080fe200078e0061ULL,
0x000000020e567810ULL, 0x040fe40007ffe0ffULL, 0x000000040e547810ULL, 0x000fe20007ffe0ffULL,
0x00005e000b307625ULL, 0x002fe200078e0061ULL, 0x00000040340b7807ULL, 0x000fc40001800000ULL,
0x0000000c323c7210ULL, 0x080fe20007f5e0ffULL, 0x0000000112127824ULL, 0x100fe200078e0235ULL,
0x0000000c30367210ULL, 0x000fe20007f3e0ffULL, 0x0000000114147824ULL, 0x100fe200078e0235ULL,
0x0000000b2e0b7217ULL, 0x000fe20007800000ULL, 0x0000000117177824ULL, 0x000fe400078e0235ULL,
0x000000ffff377224ULL, 0x000fe400008e0631ULL, 0x00005e0011307625ULL, 0x000fc800078e0061ULL,
0x0000000118187824ULL, 0x100fe200078e0235ULL, 0x0000000c303e7210ULL, 0x000fe20007f3e0ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0235ULL, 0x0001c64805057891ULL, 0x004fe2000f8e183fULL,
0x000000ffff3d7224ULL, 0x000fe400010e0633ULL, 0x000000010b0b7824ULL, 0x000fe400078e0a2eULL,
0x00005e0012327625ULL, 0x000fe200078e0061ULL, 0x000000060e127810ULL, 0x000fe40007ffe0ffULL,
0x0000000b5600720cULL, 0x000fe20003fa6070ULL, 0x00005e0014347625ULL, 0x000fe200078e0061ULL,
0x0000000b5400720cULL, 0x000fc40003f66070ULL, 0x0000000c32547210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e0631ULL, 0x0000000c34567210ULL, 0x000fe20007f3e0ffULL,
0x00005e0017307625ULL, 0x000fe200078e0061ULL, 0x0000000b0e00720cULL, 0x000fc60003f86070ULL,
0x000000ffff557224ULL, 0x000fe400010e0633ULL, 0x000000ffff577224ULL, 0x000fe200008e0635ULL,
0x0000000c30307210ULL, 0x000fe20007f3e0ffULL, 0x00005e0018327625ULL, 0x000fc800078e0061ULL,
0x000000ffff317224ULL, 0x000fe200008e0631ULL, 0x0000000c32327210ULL, 0x080fe20007f5e0ffULL,
0x000000101b117824ULL, 0x000fe200078e028bULL, 0x0000000b1200720cULL, 0x000fe20003f26070ULL,
0x00005e001a347625ULL, 0x000fe200078e0061ULL, 0x000000080e127810ULL, 0x000fe40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036117faeULL, 0x0003e2000e101c46ULL,
0x000000ffff337224ULL, 0x000fe200010e0633ULL, 0x0000000b1200720cULL, 0x080fe20003f46070ULL,
0x000000101c177824ULL, 0x100fe200078e028bULL, 0x0000000a0e127810ULL, 0x000fe20007ffe0ffULL,
0x000000101e617824ULL, 0x100fe200078e028bULL, 0x0000000c34347210ULL, 0x000fe20007fde0ffULL,
0x000000101f637824ULL, 0x100fe200078e028bULL, 0x0000000b1200720cULL, 0x080fe20003f86070ULL,
0x000000003c177faeULL, 0x0005e2000e901c46ULL, 0x0000000c0e127810ULL, 0x000fe20007ffe0ffULL,
0x0000001020657824ULL, 0x100fe200078e028bULL, 0x0000000e0e0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000003e617faeULL, 0x0005e2000d901c46ULL, 0x0000000b1200720cULL, 0x080fe20003fa6070ULL,
0x0000001022117824ULL, 0x102fe200078e028bULL, 0x0000000b0e00720cULL, 0x000fe20003f66070ULL,
0x00000010210b7824ULL, 0x000fe200078e028bULL, 0x0000000054637faeULL, 0x0005e2000c901c46ULL,
0x000000ffff357224ULL, 0x000fe200030e0635ULL, 0x00000008850e7812ULL, 0x000fe200078ec0ffULL,
0x00000010238b7824ULL, 0x000fe200078e028bULL, 0x0000000056657faeULL, 0x0005e8000d101c46ULL,
0x00000000300b7faeULL, 0x0005e8000e101c46ULL, 0x0000000032117faeULL, 0x0005e8000e901c46ULL,
0x00000000348b7faeULL, 0x0005e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c000e0e7984ULL, 0x000e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c62c00ff117984ULL, 0x004ea20000000800ULL, 0x0000ffff8c8c7812ULL, 0x000fe200078ec0ffULL,
0x8000000024127824ULL, 0x000fc600078e00ffULL, 0x000088808c0b7816ULL, 0x000fca00000000ffULL,
0x800000000b0b7824ULL, 0x000fca00078e00ffULL, 0x800000000eff7812ULL, 0x002fe4000782480bULL,
0x8000000011ff7812ULL, 0x004fe20007844812ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0b7424ULL, 0x000fe400078e00ffULL,
0x8000000024117824ULL, 0x000fe400078e00ffULL, 0x0000000b000e7305ULL, 0x0002a4000021f000ULL,
0x3fa000000b0b7823ULL, 0x002fe200000100ffULL, 0x0000000e0000735dULL, 0x004fe40003800000ULL,
0x01c62c00ff0e7984ULL, 0x000e640000000800ULL, 0x800000000eff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c10000250e7984ULL, 0x000e620000000800ULL, 0x00000001ff8e7424ULL, 0x000fc600078e00ffULL,
0x01c30000250b7984ULL, 0x0004e20000000800ULL, 0x000000030e00720bULL, 0x002fda0003f5d000ULL,
0x0000000000117806ULL, 0x000fc800010e0100ULL, 0x0000ffff11147812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000030e00720bULL, 0x00cfe40003f54000ULL,
0x0000000e03127209ULL, 0x000fe40007810000ULL, 0x00000002ff187819ULL, 0x000fc60000011600ULL,
0x8000001203117221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b11117820ULL, 0x000fe40000410000ULL,
0x0000000000037806ULL, 0x000fe400010e0100ULL, 0x000000027400780cULL, 0x000fe40003f45270ULL,
0x0000ffff03177812ULL, 0x000fe200078e3cffULL, 0x0000001100117308ULL, 0x000e660000000800ULL,
0x0000001714ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff8e7807ULL, 0x000fc60001800000ULL,
0x01c500122500a388ULL, 0x000fe80000000800ULL, 0x00001f1811037589ULL, 0x002e6400000e0000ULL,
0x800000120e143221ULL, 0x000fe40000010000ULL, 0x0000001104047220ULL, 0x000fe20000410000ULL,
0x00001f77110e7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b14143820ULL, 0x000fc80000410000ULL,
0x0000001400263308ULL, 0x000ee20000000800ULL, 0x0000000344447220ULL, 0x082fe40000410000ULL,
0x0000000345457220ULL, 0x080fe40000410000ULL, 0x0000000340407220ULL, 0x080fe40000410000ULL,
0x0000000341417220ULL, 0x080fe40000410000ULL, 0x0000000338387220ULL, 0x080fe40000410000ULL,
0x0000000339397220ULL, 0x000fc40000410000ULL, 0x0000000348487220ULL, 0x080fe40000410000ULL,
0x0000000349497220ULL, 0x080fe40000410000ULL, 0x000000034c4c7220ULL, 0x080fe40000410000ULL,
0x000000034d4d7220ULL, 0x080fe40000410000ULL, 0x000000035c5c7220ULL, 0x080fe40000410000ULL,
0x000000035d5d7220ULL, 0x000fc40000410000ULL, 0x0000000358587220ULL, 0x080fe40000410000ULL,
0x0000000359597220ULL, 0x080fe40000410000ULL, 0x0000000350507220ULL, 0x080fe40000410000ULL,
0x0000000351517220ULL, 0x000fe40000410000ULL, 0x0000000e46467220ULL, 0x084fe40000410000ULL,
0x0000000e47477220ULL, 0x000fc40000410000ULL, 0x0000000e42427220ULL, 0x080fe40000410000ULL,
0x0000000e43437220ULL, 0x080fe40000410000ULL, 0x0000000e3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000e4a4a7220ULL, 0x080fe40000410000ULL,
0x0000000e4b4b7220ULL, 0x000fc40000410000ULL, 0x0000000e4e4e7220ULL, 0x080fe40000410000ULL,
0x0000000e4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000e5e5e7220ULL, 0x080fe40000410000ULL,
0x0000000e5f5f7220ULL, 0x080fe40000410000ULL, 0x0000000e5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000e5b5b7220ULL, 0x000fc40000410000ULL, 0x0000000e52527220ULL, 0x080fe40000410000ULL,
0x0000000e53537220ULL, 0x000fe40000410000ULL, 0x000000ffff037224ULL, 0x000fe400078e0012ULL,
0x0000000b260b3220ULL, 0x008fc80000410000ULL, 0x000000040b047221ULL, 0x00cfe20000010000ULL,
0x0000015000001947ULL, 0x000fea0003800000ULL, 0x00000008850e7812ULL, 0x000fe400078ec0ffULL,
0x0000000108ff7812ULL, 0x000fc8000782c0ffULL, 0x01c64c000e0e7984ULL, 0x000e620000000800ULL,
0x000000836c0b7207ULL, 0x000fc80004800000ULL, 0x0000ffff0b0b7812ULL, 0x000fc800078ec0ffULL,
0x000088800b117816ULL, 0x000fca00000000ffULL, 0x80000000110b7824ULL, 0x000fca00078e00ffULL,
0x800000000eff7812ULL, 0x002fe2000782480bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000b000001947ULL, 0x000fea0003800000ULL, 0x00000001080b7812ULL, 0x000fe200078ec0ffULL,
0x8000000011127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0e7424ULL, 0x000fe200078e00ffULL,
0x0001c6480b117811ULL, 0x000fc600078e18ffULL, 0x0000000e000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000e0e7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x00000400110b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007824812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000001088307824ULL, 0x100fe400078e028aULL, 0x0000001027347824ULL, 0x100fe400078e028aULL,
0x00000010283c7824ULL, 0x100fe400078e028aULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x0000001029547824ULL, 0x100fe400078e028aULL, 0x000000102a607824ULL, 0x100fe200078e028aULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x000000102b2b7824ULL, 0x000fc400078e028aULL,
0x000000102c647824ULL, 0x100fe200078e028aULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000102d687824ULL, 0x000fc600078e028aULL, 0x000000005454783bULL, 0x000f280000004200ULL,
0x000000006060783bULL, 0x000fe80000004200ULL, 0x000000002b28783bULL, 0x000ea80000004200ULL,
0x000000006464783bULL, 0x000ee80000004200ULL, 0x000000006868783bULL, 0x000f220000004200ULL,
0x00000018ffc67819ULL, 0x002fe20000011430ULL, 0x00000100308a7824ULL, 0x040fe200078e00ffULL,
0x0000888030cd7816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe20000011431ULL, 0x00000100318c7824ULL, 0x040fe200078e00ffULL,
0x0000888031d27816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000cd00cd7306ULL, 0x000fe20000200c00ULL,
0x00000018ff8a7819ULL, 0x000fc4000001148aULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ffc17819ULL, 0x000fe40000011432ULL, 0x00000018ffa27819ULL, 0x000fe20000011433ULL,
0x0000003000cb7306ULL, 0x0003e20000200c00ULL, 0x0000888032ca7816ULL, 0x000fe400000000ffULL,
0x0000888033cc7816ULL, 0x000fe400000000ffULL, 0x00000018ffa67819ULL, 0x004fc40000011434ULL,
0x0000888034c47816ULL, 0x000fe200000000ffULL, 0x0000003100d07306ULL, 0x0005e20000200c00ULL,
0x0000010032307824ULL, 0x042fe200078e00ffULL, 0x00000018ffa97819ULL, 0x008fe2000001143dULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x000088803db67816ULL, 0x000fe400000000ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000008a00ce7306ULL, 0x0003e20000200c00ULL,
0x0000010035317824ULL, 0x004fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fc40000011432ULL,
0x00000018ffa77819ULL, 0x000fe40000011436ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000cf7306ULL, 0x0005e20000200c00ULL, 0x00000100338a7824ULL, 0x042fe200078e00ffULL,
0x0000888036bc7816ULL, 0x000fe200000000ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0x00000018ffae7819ULL, 0x000fe4000001143cULL, 0x00000018ff8a7819ULL, 0x000fc4000001148aULL,
0x0000003100c57306ULL, 0x0003e20000200c00ULL, 0x0000010034307824ULL, 0x044fe200078e00ffULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x000088803caf7816ULL, 0x000fe400000000ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000008a00d17306ULL, 0x000fe20000200c00ULL, 0x0000010037317824ULL, 0x002fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ffa57819ULL, 0x000fe40000011435ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000c37306ULL, 0x0003e20000200c00ULL,
0x0000888035c27816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x010fe40000011454ULL, 0x0000888054a87816ULL, 0x000fe400000000ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003100be7306ULL, 0x0005e20000200c00ULL,
0x0000010036307824ULL, 0x042fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001148cULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff9a7819ULL, 0x000fc4000001143fULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003200c87306ULL, 0x000fe20000200c00ULL,
0x000001003d317824ULL, 0x044fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x000088803fb07816ULL, 0x000fe400000000ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000bd7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x00000018ff9c7819ULL, 0x000fe4000001143eULL,
0x000088803eb17816ULL, 0x000fe400000000ffULL, 0x00000018ff917819ULL, 0x000fe20000011455ULL,
0x0000003100b77306ULL, 0x0005e20000200c00ULL, 0x000001003c307824ULL, 0x042fe200078e00ffULL,
0x0000888055a17816ULL, 0x000fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe40000011428ULL, 0x00000018ff307819ULL, 0x000fc40000011430ULL,
0x0000003300c97306ULL, 0x000fe20000200c00ULL, 0x000001003f317824ULL, 0x044fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe40000011429ULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000b87306ULL, 0x0003e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff897819ULL, 0x000fc40000011456ULL, 0x00008880569e7816ULL, 0x000fe400000000ffULL,
0x00000018ff867819ULL, 0x000fe20000011460ULL, 0x0000003100b37306ULL, 0x0005e20000200c00ULL,
0x000001003e307824ULL, 0x002fe200078e00ffULL, 0x0000888060927816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ffac7819ULL, 0x000fe40000011437ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003400bf7306ULL, 0x0003e20000200c00ULL,
0x0000010055317824ULL, 0x044fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x0000888037bb7816ULL, 0x040fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x0000003000b27306ULL, 0x0005e20000200c00ULL, 0x00000026ff34723eULL, 0x002fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x00000018ff8b7819ULL, 0x000fe20000011457ULL, 0x0000003100aa7306ULL, 0x0003e20000200c00ULL,
0x0000010054307824ULL, 0x044fe200078e00ffULL, 0x00008880579d7816ULL, 0x000fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fc4000001142aULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003d00b47306ULL, 0x0005e20000200c00ULL,
0x0000010057317824ULL, 0x042fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0001000057577824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe40000011461ULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000a37306ULL, 0x0003e20000200c00ULL,
0x00000002ff3d7819ULL, 0x004fc40000011600ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000888061947816ULL, 0x000fe400000000ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011462ULL,
0x0000003100a07306ULL, 0x0005e20000200c00ULL, 0x0000010056307824ULL, 0x002fe200078e00ffULL,
0x00008880628d7816ULL, 0x000fe200000000ffULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe40000011463ULL, 0x00000018ff307819ULL, 0x000fc40000011430ULL,
0x0000003600ba7306ULL, 0x0003e20000200c00ULL, 0x0000010061317824ULL, 0x044fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0001000061617824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142bULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000030009b7306ULL, 0x0005e20000200c00ULL, 0x0000541034367816ULL, 0x002fe20000000034ULL,
0x0000010028347824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc40000011461ULL,
0x00000018ff117819ULL, 0x000fe20000011464ULL, 0x00001f3d363d7589ULL, 0x000fe200000e0000ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000003100997306ULL, 0x0003e20000200c00ULL,
0x0000010060307824ULL, 0x044fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe20000011465ULL,
0x0001000060607824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011466ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003c00b57306ULL, 0x0005e20000200c00ULL,
0x0000010063317824ULL, 0x002fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fc40000011460ULL,
0x00000018ff187819ULL, 0x000fe40000011467ULL, 0x00000018ff8f7819ULL, 0x000fe40000011431ULL,
0x0000003000977306ULL, 0x0003e20000200c00ULL, 0x00001f77363c7589ULL, 0x004fe200000e0000ULL,
0x00000018ff0b7819ULL, 0x000fe40000011468ULL, 0x00000018ff177819ULL, 0x000fe40000011469ULL,
0x00000018ff0e7819ULL, 0x000fc4000001146aULL, 0x0000003500c07306ULL, 0x0005e20000200c00ULL,
0x0000010062307824ULL, 0x042fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe2000001146bULL,
0x0001000062627824ULL, 0x000fc600078e00ffULL, 0x00000018ff8a7819ULL, 0x000fe40000011430ULL,
0x0001300076307811ULL, 0x000fe200078e20ffULL, 0x000000d200d27306ULL, 0x000fe20000200c00ULL,
0x000099108e357816ULL, 0x004fc800000000ffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x000000ff3500720cULL, 0x000fe20003f25270ULL, 0x0000010029357824ULL, 0x000fe200078e00ffULL,
0x0000008c00d37306ULL, 0x0004e80000200c00ULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000054009f7306ULL, 0x0009e20000200c00ULL, 0x00008880638c7816ULL, 0x044fe200000000ffULL,
0x0001000063637824ULL, 0x000fcc00078e00ffULL, 0x000000c600c67306ULL, 0x000ea20000200c00ULL,
0x0000888028547816ULL, 0x050fe200000000ffULL, 0x0001000028287824ULL, 0x000fca00078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x000000c700c77306ULL, 0x000f300000200c00ULL,
0x0000003f00ab7306ULL, 0x000fe20000200c00ULL, 0x0000003d30309232ULL, 0x002fc40000000000ULL,
0x0000003d32329232ULL, 0x000fca0000000000ULL, 0x0000003e00ad7306ULL, 0x000fe20000200c00ULL,
0x0000003c31319232ULL, 0x080fe40000000000ULL, 0x0000003c33339232ULL, 0x000fca0000000000ULL,
0x0000005500a47306ULL, 0x0003f00000200c00ULL, 0x00000034003f7306ULL, 0x0005e20000200c00ULL,
0x0000888029557816ULL, 0x002fce00000000ffULL, 0x00000028003e7306ULL, 0x0003e20000200c00ULL,
0x0001000029347824ULL, 0x004fe200078e00ffULL, 0x00005410d2297816ULL, 0x008fcc00000000d3ULL,
0x000000ca00ca7306ULL, 0x000ea20000200c00ULL, 0x00005410cd287816ULL, 0x002fce00000000ceULL,
0x000000cc00cc7306ULL, 0x000e620000200c00ULL, 0x000000283044723cULL, 0x000fee0000001844ULL,
0x000000c100c17306ULL, 0x000ee20000200c00ULL, 0x00005410cb287816ULL, 0x000fe400000000c6ULL,
0x00005410d0297816ULL, 0x010fca00000000c7ULL, 0x000000a200a27306ULL, 0x000f240000200c00ULL,
0x000000283040723cULL, 0x000fec0000001840ULL, 0x000000c400c47306ULL, 0x000ee20000200c00ULL,
0x00005410ca287816ULL, 0x004fe400000000cfULL, 0x00005410cc297816ULL, 0x002fca00000000d1ULL,
0x000000c200c27306ULL, 0x000e640000200c00ULL, 0x000000283038723cULL, 0x000fec0000001838ULL,
0x000000a600a67306ULL, 0x000ea20000200c00ULL, 0x00005410c8287816ULL, 0x008fe400000000c1ULL,
0x00005410c9297816ULL, 0x010fe200000000a2ULL, 0x000001002ba27824ULL, 0x000fc800078e00ffULL,
0x000000a500a57306ULL, 0x000ee20000200c00ULL, 0x00000018ffa27819ULL, 0x000fe200000114a2ULL,
0x000000283048723cULL, 0x000fec0000001848ULL, 0x0000005600967306ULL, 0x000fe20000200c00ULL,
0x00005410c4287816ULL, 0x000fe400000000c3ULL, 0x00005410c2297816ULL, 0x002fca00000000c5ULL,
0x0000006000937306ULL, 0x0003e40000200c00ULL, 0x00000028304c723cULL, 0x000fec000000184cULL,
0x0000003500567306ULL, 0x0009e20000200c00ULL, 0x00000018ff607819ULL, 0x002fe40000011434ULL,
0x0001300078347811ULL, 0x000fc400078e20ffULL, 0x00005410bf287816ULL, 0x004fe400000000a6ULL,
0x00005410c0297816ULL, 0x008fe200000000a5ULL, 0x000000bc00bc7306ULL, 0x000e620000200c00ULL,
0x000001002a357824ULL, 0x010fca00078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe20000011435ULL,
0x00000028305c723cULL, 0x000fe2000000185cULL, 0x000000bb00bb7306ULL, 0x000eb00000200c00ULL,
0x0000003700b97306ULL, 0x0007e20000200c00ULL, 0x00005410bc287816ULL, 0x002fce00000000bdULL,
0x000000a700a77306ULL, 0x000e620000200c00ULL, 0x000000003434783bULL, 0x008ee20000000200ULL,
0x00005410bb297816ULL, 0x004fcc00000000beULL, 0x000000ac00ac7306ULL, 0x000ea20000200c00ULL,
0x000000283058723cULL, 0x000fee0000001858ULL, 0x000000af00af7306ULL, 0x000f220000200c00ULL,
0x0000888064297816ULL, 0x000fe400000000ffULL, 0x00005410ba287816ULL, 0x002fe200000000a7ULL,
0x0000010064ba7824ULL, 0x000fc400078e00ffULL, 0x000000ffffa77224ULL, 0x000fe400078e0029ULL,
0x0000005700987306ULL, 0x0003e20000200c00ULL, 0x00005410b9297816ULL, 0x004fe400000000acULL,
0x00000018ffac7819ULL, 0x000fca00000114baULL, 0x000000b600b67306ULL, 0x000ea20000200c00ULL,
0x000088802a577816ULL, 0x042fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x000000283030723cULL, 0x000fe80000001850ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x000000ae00ae7306ULL, 0x000e620000200c00ULL, 0x0000003d34349232ULL, 0x088fe20000000000ULL,
0x00005410af287816ULL, 0x010fe200000000b8ULL, 0x0000003d36369232ULL, 0x000fc40000000000ULL,
0x0000003c35359232ULL, 0x080fe40000000000ULL, 0x0000003c37379232ULL, 0x000fe20000000000ULL,
0x0000002a00a67306ULL, 0x0007e20000200c00ULL, 0x00005410b6297816ULL, 0x004fce00000000b7ULL,
0x000000a900a97306ULL, 0x000ea20000200c00ULL, 0x00008880652a7816ULL, 0x048fe200000000ffULL,
0x000000283444723cULL, 0x000fe80000001844ULL, 0x000000ffffaf7224ULL, 0x000fe400078e002aULL,
0x0000009c009c7306ULL, 0x000fe20000200c00ULL, 0x00000100652a7824ULL, 0x000fe200078e00ffULL,
0x00005410b5287816ULL, 0x002fe200000000aeULL, 0x0001000065657824ULL, 0x000fc600078e00ffULL,
0x00000018ff507819ULL, 0x000fe4000001142aULL, 0x0000009a009a7306ULL, 0x000e620000200c00ULL,
0x00005410b4297816ULL, 0x004fe400000000a9ULL, 0x00013000792a7811ULL, 0x000fe400078e20ffULL,
0x00000018ff657819ULL, 0x000fc60000011465ULL, 0x0000006100957306ULL, 0x0005e20000200c00ULL,
0x000000283440723cULL, 0x000fee0000001840ULL, 0x000000b100b17306ULL, 0x000ee20000200c00ULL,
0x00000018ff617819ULL, 0x004fe40000011462ULL, 0x00000018ff627819ULL, 0x000fc40000011463ULL,
0x000088802b637816ULL, 0x040fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00005410ab517816ULL, 0x002fe2000000009aULL, 0x000000b000b07306ULL, 0x000e620000200c00ULL,
0x00008880669a7816ULL, 0x000fe400000000ffULL, 0x00000018ff2b7819ULL, 0x000fca000001142bULL,
0x000000a800a87306ULL, 0x000fe20000200c00ULL, 0x00005410b1287816ULL, 0x008fce00000000b2ULL,
0x000000a100a17306ULL, 0x000fe20000200c00ULL, 0x00005410b0297816ULL, 0x002fce00000000b3ULL,
0x0000002b00a57306ULL, 0x0003e20000200c00ULL, 0x000000283438723cULL, 0x000fee0000001838ULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x00010000642b7824ULL, 0x002fca00078e00ffULL,
0x00000018ffae7819ULL, 0x000fe4000001142bULL, 0x0000005000647306ULL, 0x0003e20000200c00ULL,
0x000000002a28783bULL, 0x000eee0000000200ULL, 0x0000009100917306ULL, 0x000f220000200c00ULL,
0x00005410ad507816ULL, 0x002fc4000000009cULL, 0x000054109f907816ULL, 0x004fca0000000090ULL,
0x000000503448723cULL, 0x000fe20000001848ULL, 0x0000008900897306ULL, 0x000fec0000200c00ULL,
0x00005410a8507816ULL, 0x000fe400000000a3ULL, 0x00005410a1517816ULL, 0x000fe200000000aaULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x00005410a4917816ULL, 0x010fca0000000091ULL,
0x00000050344c723cULL, 0x040fe4000000184cULL, 0x0000009e009e7306ULL, 0x000eaa0000200c00ULL,
0x0000010066507824ULL, 0x040fe200078e00ffULL, 0x00000090345c723cULL, 0x000fe2000000185cULL,
0x0000010067517824ULL, 0x040fe200078e00ffULL, 0x0000009d009d7306ULL, 0x000f220000200c00ULL,
0x0001000066667824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0000003d28289232ULL, 0x088fe20000000000ULL, 0x00000018ff527819ULL, 0x000fe20000011451ULL,
0x0000003d2a2a9232ULL, 0x000fe20000000000ULL, 0x0000541098517816ULL, 0x002fe2000000008bULL,
0x0000003c29299232ULL, 0x080fe20000000000ULL, 0x0000005000917306ULL, 0x0003e20000200c00ULL,
0x000054109e9c7816ULL, 0x004fe2000000009bULL, 0x0000003c2b2b9232ULL, 0x000fe20000000000ULL,
0x0000888067907816ULL, 0x040fe200000000ffULL, 0x0001000067677824ULL, 0x000fc800078e00ffULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x0000541096507816ULL, 0x002fe40000000089ULL,
0x000054109d9d7816ULL, 0x010fe400000000a0ULL, 0x00000018ff677819ULL, 0x000fc60000011467ULL,
0x000000503430723cULL, 0x040fe20000001830ULL, 0x0000006200627306ULL, 0x000e6c0000200c00ULL,
0x000130007a507811ULL, 0x000fe200078e20ffULL, 0x0000009c3458723cULL, 0x000fe20000001858ULL,
0x00000052009b7306ULL, 0x0005ec0000200c00ULL, 0x0000010068367824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011466ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000000005050783bULL, 0x004ea20000000200ULL, 0x00005410626f7816ULL, 0x002fe2000000006fULL,
0x0000010069627824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc40000011436ULL,
0x0000888068347816ULL, 0x040fe200000000ffULL, 0x0001000068687824ULL, 0x000fe200078e00ffULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x0000888069667816ULL, 0x040fe200000000ffULL, 0x0001000069697824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc60000011468ULL, 0x0000009400947306ULL, 0x000ee20000200c00ULL,
0x00000018ff697819ULL, 0x000fce0000011469ULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x00005410616e7816ULL, 0x002fe2000000006eULL, 0x000000ffff617224ULL, 0x000fcc00078e0066ULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x0000541094997816ULL, 0x008fe20000000099ULL,
0x0000006e2848723cULL, 0x000fec0000001848ULL, 0x0000008800887306ULL, 0x000ee20000200c00ULL,
0x0000541054547816ULL, 0x010fe2000000003fULL, 0x0000003d50509232ULL, 0x004fc40000000000ULL,
0x0000003d52529232ULL, 0x000fe40000000000ULL, 0x0000003c51519232ULL, 0x080fe40000000000ULL,
0x0000002d002d7306ULL, 0x000ea20000200c00ULL, 0x0000541093947816ULL, 0x002fe20000000086ULL,
0x0000003c53539232ULL, 0x000fcc0000000000ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541095957816ULL, 0x008fce0000000088ULL, 0x0000002700277306ULL, 0x000e620000200c00ULL,
0x000054103e3e7816ULL, 0x004fe2000000002dULL, 0x000000942840723cULL, 0x000fec0000001840ULL,
0x0000002c002c7306ULL, 0x000eb00000200c00ULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x00005410a6a47816ULL, 0x002fc40000000027ULL, 0x000088806a277816ULL, 0x000fca00000000ffULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x00005410a5a57816ULL, 0x004fce000000002cULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x0000541092987816ULL, 0x008fe20000000097ULL,
0x000000a42830723cULL, 0x040fec0000001830ULL, 0x0000008c008c7306ULL, 0x000fe40000200c00ULL,
0x000000982844723cULL, 0x000fec0000001844ULL, 0x0000008f008f7306ULL, 0x000ea20000200c00ULL,
0x000054108d8a7816ULL, 0x002fce000000008aULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x000054108c8b7816ULL, 0x004fce000000008fULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541055557816ULL, 0x002fe20000000056ULL,
0x0000008a2838723cULL, 0x040fec0000001838ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x00005410603f7816ULL, 0x008fe2000000006dULL, 0x00000054284c723cULL, 0x040fec000000184cULL,
0x0000006300637306ULL, 0x000fe40000200c00ULL, 0x0000003e285c723cULL, 0x000fec000000185cULL,
0x000000a200a27306ULL, 0x000e700000200c00ULL, 0x0000001a001a7306ULL, 0x000ff00000200c00ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x0000541063637816ULL, 0x002fce00000000a2ULL,
0x0000003600377306ULL, 0x000ff00000200c00ULL, 0x000000af00af7306ULL, 0x000e620000200c00ULL,
0x0000541065657816ULL, 0x004fe2000000001aULL, 0x000001006b1a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0000006200367306ULL, 0x0005f00000200c00ULL,
0x0000001100117306ULL, 0x000fe20000200c00ULL, 0x0000541057627816ULL, 0x004fc4000000008eULL,
0x00005410afad7816ULL, 0x002fca0000000064ULL, 0x000000ae00ae7306ULL, 0x000e620000200c00ULL,
0x000000622858723cULL, 0x000fee0000001858ULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x000001006a287824ULL, 0x040fe200078e00ffULL, 0x000088806b297816ULL, 0x000fe200000000ffULL,
0x000100006a6a7824ULL, 0x000fc400078e00ffULL, 0x000100006b6b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x00005410ae647816ULL, 0x002fe20000000011ULL, 0x000000ffff117224ULL, 0x000fe200078e0029ULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff6b7819ULL, 0x000fc6000001146bULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x000000645040723cULL, 0x000fee0000001840ULL,
0x0000006700677306ULL, 0x000e700000200c00ULL, 0x00000028002a7306ULL, 0x0005e20000200c00ULL,
0x0000541067297816ULL, 0x002fce0000000018ULL, 0x0000000b000b7306ULL, 0x000fe20000200c00ULL,
0x0000541035287816ULL, 0x004fce0000000014ULL, 0x0000001700177306ULL, 0x000fe20000200c00ULL,
0x000000285048723cULL, 0x000fee0000001848ULL, 0x000000a700a77306ULL, 0x000ff00000200c00ULL,
0x000000ac00ac7306ULL, 0x000e700000200c00ULL, 0x0000009a009a7306ULL, 0x000eb00000200c00ULL,
0x0000009000907306ULL, 0x000ee20000200c00ULL, 0x00005410a7ac7816ULL, 0x002fce00000000acULL,
0x0000003400347306ULL, 0x000e620000200c00ULL, 0x000054109a9a7816ULL, 0x004fe20000000091ULL,
0x000000ac5044723cULL, 0x000fec0000001844ULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x00005410909b7816ULL, 0x008fce000000009bULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x0000541034347816ULL, 0x002fe20000000037ULL, 0x0000009a5038723cULL, 0x000fec0000001838ULL,
0x00000069002c7306ULL, 0x000e620000200c00ULL, 0x0000541061357816ULL, 0x004fce0000000036ULL,
0x0000002700277306ULL, 0x000ea20000200c00ULL, 0x0000541068687816ULL, 0x008fe2000000000bULL,
0x00000034504c723cULL, 0x000fe2000000184cULL, 0x00000001080b7812ULL, 0x000fc800078ec0ffULL,
0x000000010b00780cULL, 0x000fe20003f25070ULL, 0x00000011002b7306ULL, 0x000fe20000200c00ULL,
0x000054102c697816ULL, 0x002fce0000000017ULL, 0x0000001a001a7306ULL, 0x000e620000200c00ULL,
0x00005410272a7816ULL, 0x004fe2000000002aULL, 0x00000068505c723cULL, 0x000fec000000185cULL,
0x0000000e000e7306ULL, 0x000ff00000200c00ULL, 0x0000001200127306ULL, 0x000fe20000200c00ULL,
0x000054102b2b7816ULL, 0x002fce000000001aULL, 0x0000006a00117306ULL, 0x000e620000200c00ULL,
0x0000002a5058723cULL, 0x000fee0000001858ULL, 0x0000006b00297306ULL, 0x000ea20000200c00ULL,
0x0000541011287816ULL, 0x002fe4000000000eULL, 0x0000541029297816ULL, 0x004fce0000000012ULL,
0x000000285050723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000006c83837207ULL, 0x000fe20004800000ULL,
0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000c0750e7811ULL, 0x000fe400078e40ffULL,
0x000000ff83ff7812ULL, 0x000fe4000782c0ffULL, 0x000000ff09ff7812ULL, 0x000fe4000786c0ffULL,
0x00000001ff097807ULL, 0x000fc40000800000ULL, 0x0000000e7300720cULL, 0x000fe40003f24070ULL,
0x00000001080b7812ULL, 0x040fe400078ec0ffULL, 0x00000001ff8d7807ULL, 0x000fe40001800000ULL,
0x000000010b00780cULL, 0x000fe40003f45070ULL, 0x00000001088e7812ULL, 0x000fe400078e0cffULL,
0x0000006c096c7207ULL, 0x000fc80005000000ULL, 0x000076106c8c7816ULL, 0x000fe2000000008cULL,
0x00002aa000009947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e620000000800ULL,
0x80000000870e7824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x002fe2000782480eULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000782480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000087877824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b000e7305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x0000000e0000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff0e7984ULL, 0x000e640000000800ULL,
0x800000000eff7812ULL, 0x002fc40007824887ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000300750b7a10ULL, 0x000fe20007ffe0ffULL,
0x000000042f0e7c24ULL, 0x020fe2000f8e0202ULL, 0x0000400084847812ULL, 0x000fe200078ec0ffULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x0000000885857812ULL, 0x000fe200078ec0ffULL,
0x000001000b127824ULL, 0x040fe200078e00ffULL, 0x0000007f0e147812ULL, 0x040fe400078ef80dULL,
0x0000007f0e287812ULL, 0x000fe200078ef813ULL, 0x00000000850573c2ULL, 0x000e6200000e0000ULL,
0x000000010b0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000001273137217ULL, 0x000fe40007800000ULL,
0x000000700d00720cULL, 0x000fe40003f26070ULL, 0x0000007f0e0a7812ULL, 0x040fe200078ef80aULL,
0x00000001130d7824ULL, 0x000fe200078e0a12ULL, 0x0000007f0e187812ULL, 0x040fe400078ef80fULL,
0x0000007f0e1a7812ULL, 0x000fe200078ef810ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0031ULL,
0x000000400d0d7807ULL, 0x000fc40000800000ULL, 0x0000007f0e2a7812ULL, 0x000fe200078ef815ULL,
0x00005e0018107625ULL, 0x000fe200078e0031ULL, 0x0000000d2e0d7217ULL, 0x000fe40007800000ULL,
0x0000000c0a0a7210ULL, 0x080fe20007f5e0ffULL, 0x00005e001a127625ULL, 0x080fe200078e0031ULL,
0x0000007f0e2c7812ULL, 0x040fe400078ef816ULL, 0x0000007f0e307812ULL, 0x000fe200078ef819ULL,
0x00005e00140e7625ULL, 0x080fe200078e0031ULL, 0x00000004ff197819ULL, 0x000fe20000011600ULL,
0x0001c64805057890ULL, 0x002fe2000fffe03fULL, 0x0001400084847810ULL, 0x000fe20007ffe0ffULL,
0x00005e0028147625ULL, 0x000fe200078e0031ULL, 0x0000000c0e0e7210ULL, 0x000fc40007f7e0ffULL,
0x0000000619277810ULL, 0x000fe20007ffe0ffULL, 0x000000010d287824ULL, 0x000fe200078e0a2eULL,
0x00000002190d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000c10107210ULL, 0x000fe20007f5e0ffULL, 0x00005e002a167625ULL, 0x080fe200078e0031ULL,
0x000000281900720cULL, 0x000fe40003f86070ULL, 0x0000000c14147210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000000c16167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e060fULL, 0x000000280d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000000c12127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x00000008190d7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0284ULL, 0x0000000419297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000282700720cULL, 0x080fe20003f26070ULL,
0x000000101e2b7824ULL, 0x100fe200078e0284ULL, 0x000000280d00720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a1b7faeULL, 0x0003e2000e101c46ULL,
0x0000000a190d7810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0284ULL,
0x0000000c19277810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0284ULL,
0x0000000e192d7810ULL, 0x000fe20007ffe0ffULL, 0x00005e002c187625ULL, 0x000fe200078e0031ULL,
0x000000282900720cULL, 0x000fc40003f66070ULL, 0x000000280d00720cULL, 0x000fe20003f86070ULL,
0x000000101c0d7824ULL, 0x000fe200078e0284ULL, 0x0000000c180a7210ULL, 0x002fe20007fde0ffULL,
0x00005e00301a7625ULL, 0x000fc600078e0031ULL, 0x000000000e0d7faeULL, 0x0003e2000e901c46ULL,
0x000000282700720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0619ULL,
0x000000282d00720cULL, 0x000fe20003fc6070ULL, 0x0000001020297824ULL, 0x100fe200078e0284ULL,
0x00000000102b7faeULL, 0x0005e2000d901c46ULL, 0x0000000c1a0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001022277824ULL, 0x100fe400078e0284ULL, 0x0000001023237824ULL, 0x000fe200078e0284ULL,
0x00000000121f7faeULL, 0x0005e2000c901c46ULL, 0x000000ffff0d7224ULL, 0x002fe200018e061bULL,
0x0001c6481d0e7811ULL, 0x000fc400078e18ffULL, 0x0000000014297faeULL, 0x0005e8000d101c46ULL,
0x0000000016217faeULL, 0x0005e8000e101c46ULL, 0x000000000a277faeULL, 0x0005e8000e901c46ULL,
0x000000000c237faeULL, 0x0005e8000f101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000004000e0b7984ULL, 0x0042a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c63c00ff0c7984ULL, 0x000ee20000000800ULL, 0x0000ffff8c0f7812ULL, 0x000fe200078ec0ffULL,
0x80000000240d7824ULL, 0x000fc800078e00ffULL, 0x800000000f0a7824ULL, 0x000fca00078e00ffULL,
0x800000000bff7812ULL, 0x004fe4000782480aULL, 0x800000000cff7812ULL, 0x008fe2000784480dULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x8000000024247824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0004e4000021f000ULL, 0x3fa000000a0a7823ULL, 0x004fe200000100ffULL,
0x0000000b0000735dULL, 0x008fe40003800000ULL, 0x01c63c00ff0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fc40007844824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x01c18000250a7984ULL, 0x000ea20000000800ULL,
0x00000001ff947424ULL, 0x000fc600078e00ffULL, 0x01c38000250b7984ULL, 0x0007220000000800ULL,
0x000000030a00720bULL, 0x004fda0003f5d000ULL, 0x00000000000c7806ULL, 0x000fc800010e0100ULL,
0x0000ffff0c0d7812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000030a00720bULL, 0x018fe40003f54000ULL, 0x0000000a03107209ULL, 0x000fe40007810000ULL,
0x00000002ff117819ULL, 0x000fc60000011600ULL, 0x80000010030c7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fe40000410000ULL, 0x0000000000037806ULL, 0x000fe400010e0100ULL,
0x000000037400780cULL, 0x000fe40003f45270ULL, 0x0000ffff030e7812ULL, 0x002fe200078e3cffULL,
0x0000000c000c7308ULL, 0x000e660000000800ULL, 0x0000000e0dff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff947807ULL, 0x000fc60001800000ULL, 0x01c580102500a388ULL, 0x000fe80000000800ULL,
0x00001f110c037589ULL, 0x002e6400000e0000ULL, 0x800000100a0d3221ULL, 0x000fe40000010000ULL,
0x0000000c04047220ULL, 0x000fe20000410000ULL, 0x00001f770c0a7589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b0d0d3820ULL, 0x000fc80000410000ULL, 0x0000000d00263308ULL, 0x000ee20000000800ULL,
0x0000000344447220ULL, 0x082fe40000410000ULL, 0x0000000345457220ULL, 0x080fe40000410000ULL,
0x0000000340407220ULL, 0x080fe40000410000ULL, 0x0000000341417220ULL, 0x080fe40000410000ULL,
0x0000000338387220ULL, 0x080fe40000410000ULL, 0x0000000339397220ULL, 0x000fc40000410000ULL,
0x0000000348487220ULL, 0x080fe40000410000ULL, 0x0000000349497220ULL, 0x080fe40000410000ULL,
0x000000034c4c7220ULL, 0x080fe40000410000ULL, 0x000000034d4d7220ULL, 0x080fe40000410000ULL,
0x000000035c5c7220ULL, 0x080fe40000410000ULL, 0x000000035d5d7220ULL, 0x000fc40000410000ULL,
0x0000000358587220ULL, 0x080fe40000410000ULL, 0x0000000359597220ULL, 0x080fe40000410000ULL,
0x0000000350507220ULL, 0x080fe40000410000ULL, 0x0000000351517220ULL, 0x000fe40000410000ULL,
0x0000000a46467220ULL, 0x084fe40000410000ULL, 0x0000000a47477220ULL, 0x000fc40000410000ULL,
0x0000000a42427220ULL, 0x080fe40000410000ULL, 0x0000000a43437220ULL, 0x080fe40000410000ULL,
0x0000000a3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000a3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000a4a4a7220ULL, 0x080fe40000410000ULL, 0x0000000a4b4b7220ULL, 0x000fc40000410000ULL,
0x0000000a4e4e7220ULL, 0x080fe40000410000ULL, 0x0000000a4f4f7220ULL, 0x080fe40000410000ULL,
0x0000000a5e5e7220ULL, 0x080fe40000410000ULL, 0x0000000a5f5f7220ULL, 0x080fe40000410000ULL,
0x0000000a5a5a7220ULL, 0x080fe40000410000ULL, 0x0000000a5b5b7220ULL, 0x000fc40000410000ULL,
0x0000000a52527220ULL, 0x080fe40000410000ULL, 0x0000000a53537220ULL, 0x000fe40000410000ULL,
0x000000ffff037224ULL, 0x000fe400078e0010ULL, 0x0000000b260b3220ULL, 0x008fc80000410000ULL,
0x000000040b047221ULL, 0x018fe20000010000ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0001c6481d1d7811ULL, 0x000fe200078e18ffULL, 0x800000000f0b7824ULL, 0x000fc800078e00ffULL,
0x000004001d0a7984ULL, 0x000ea40000000800ULL, 0x800000000aff7812ULL, 0x004fe4000782480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000000f0c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0004e4000021f000ULL, 0x3fa000000a0a7823ULL, 0x004fe200000100ffULL,
0x0000000b0000735dULL, 0x008fe40003800000ULL, 0x000004001d0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fc4000782480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000008214783bULL, 0x000ea80000004200ULL,
0x000000008118783bULL, 0x000ee80000004200ULL, 0x00000000801c783bULL, 0x000fe80000004200ULL,
0x000000007f28783bULL, 0x000f280000004200ULL, 0x000000007e20783bULL, 0x000f680000004200ULL,
0x000000007d10783bULL, 0x000e680000004200ULL, 0x000000007b0c783bULL, 0x002e680000004200ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x0000010015547824ULL, 0x004fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011417ULL, 0x0000010017557824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011415ULL, 0x00000100143f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fc40000011454ULL, 0x0000888015a97816ULL, 0x040fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x0000005400b27306ULL, 0x0005e20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff927819ULL, 0x000fe40000011416ULL,
0x00000018ffb07819ULL, 0x000fe40000011415ULL, 0x0000888016157816ULL, 0x000fe200000000ffULL,
0x0000003f00ae7306ULL, 0x0009e20000200c00ULL, 0x0000888017547816ULL, 0x044fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x008fc40000011418ULL,
0x00008880189c7816ULL, 0x000fe400000000ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x000000a900a97306ULL, 0x000fe20000200c00ULL, 0x00000100163f7824ULL, 0x050fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe20000011419ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001141aULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x0000001700aa7306ULL, 0x0005e20000200c00ULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x00000018ff8d7819ULL, 0x000fe4000001141bULL, 0x00008880199f7816ULL, 0x000fe400000000ffULL,
0x000088801a9a7816ULL, 0x040fe200000000ffULL, 0x0000001600a57306ULL, 0x0007e20000200c00ULL,
0x000001001a177824ULL, 0x044fe200078e00ffULL, 0x000088801b9d7816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe4000001142aULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x0000003f00ac7306ULL, 0x0005e20000200c00ULL,
0x0000010019167824ULL, 0x048fe200078e00ffULL, 0x000088802a6c7816ULL, 0x000fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000017009b7306ULL, 0x0007e20000200c00ULL,
0x00000100183f7824ULL, 0x044fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001142bULL,
0x000088802b6e7816ULL, 0x000fe400000000ffULL, 0x0000001600a87306ULL, 0x0005e20000200c00ULL,
0x000001001c177824ULL, 0x008fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff857819ULL, 0x000fe4000001141dULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001800a47306ULL, 0x0007e20000200c00ULL, 0x000001001b167824ULL, 0x004fe200078e00ffULL,
0x000088801d997816ULL, 0x000fe200000000ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0a7819ULL, 0x020fc40000011422ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000001700987306ULL, 0x0005e20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0001380076187811ULL, 0x008fe200078e20ffULL, 0x0000010013767824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x00000018ff847819ULL, 0x000fe2000001141cULL,
0x0000001600a67306ULL, 0x0007e20000200c00ULL, 0x000001001e177824ULL, 0x004fe200078e00ffULL,
0x000088801c977816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fc4000001141fULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001900a37306ULL, 0x000fe20000200c00ULL, 0x000001001d167824ULL, 0x048fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801f897816ULL, 0x000fe400000000ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000017008a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff677819ULL, 0x000fe4000001141eULL, 0x00000018ff377819ULL, 0x000fe40000011420ULL,
0x0000888014a77816ULL, 0x000fe200000000ffULL, 0x0000001600a07306ULL, 0x0007e20000200c00ULL,
0x0000010028177824ULL, 0x004fe200078e00ffULL, 0x000088801e8b7816ULL, 0x040fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000888020627816ULL, 0x000fe400000000ffULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x0000001a009e7306ULL, 0x000fe20000200c00ULL,
0x000001001f167824ULL, 0x048fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011414ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe20000011455ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000001700827306ULL, 0x0005e20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x00000018ff3c7819ULL, 0x000fe40000011421ULL,
0x0000888021647816ULL, 0x000fe200000000ffULL, 0x00000016008e7306ULL, 0x0007e20000200c00ULL,
0x000001002a177824ULL, 0x044fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe40000011410ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000010029167824ULL, 0x008fe200078e00ffULL, 0x00000017006d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff367819ULL, 0x000fc40000011411ULL, 0x00000018ff567819ULL, 0x000fe40000011428ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000888028817816ULL, 0x000fe200000000ffULL,
0x0000001b00a27306ULL, 0x0007e20000200c00ULL, 0x0000010020177824ULL, 0x044fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe20000011423ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011429ULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x0000001600867306ULL, 0x0005e20000200c00ULL,
0x000000001818783bULL, 0x008fe20000000200ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000888029837816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000001700657306ULL, 0x0007e20000200c00ULL,
0x000001002b167824ULL, 0x044fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011412ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff297819ULL, 0x000fc40000011429ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000002a006b7306ULL, 0x0005e20000200c00ULL,
0x0000010022177824ULL, 0x048fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff357819ULL, 0x000fe40000011413ULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000003f00a17306ULL, 0x000fe20000200c00ULL, 0x00008880222a7816ULL, 0x044fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x002fc4000001140cULL,
0x00000018ff307819ULL, 0x000fe4000001140eULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x00000017003f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff337819ULL, 0x000fe4000001140fULL,
0x00000018ff347819ULL, 0x000fe4000001140dULL, 0x00000018ff2d7819ULL, 0x000fe4000001147cULL,
0x00000018ff327819ULL, 0x000fe2000001147dULL, 0x00000016006f7306ULL, 0x0005e20000200c00ULL,
0x00000026ff17723eULL, 0x002fc400000000ffULL, 0x00000018ff247819ULL, 0x000fe4000001147eULL,
0x00000018ff317819ULL, 0x000fc6000001147fULL, 0x0000001d00967306ULL, 0x0003e20000200c00ULL,
0x0000010021167824ULL, 0x044fe400078e00ffULL, 0x0001000021217824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000002b006a7306ULL, 0x000fe20000200c00ULL,
0x00000002ff1d7819ULL, 0x002fe40000011600ULL, 0x00000018ff217819ULL, 0x000fca0000011421ULL,
0x00000022002b7306ULL, 0x0003f00000200c00ULL, 0x0000001c00957306ULL, 0x0005e20000200c00ULL,
0x0000541017227816ULL, 0x002fe20000000017ULL, 0x0000010011177824ULL, 0x000fc800078e00ffULL,
0x00001f1d221d7589ULL, 0x000e6200000e0000ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000001600697306ULL, 0x0007e40000200c00ULL, 0x00001f77221c7589ULL, 0x00452c00000e0000ULL,
0x0000001f00877306ULL, 0x000be20000200c00ULL, 0x0000010023167824ULL, 0x008fe200078e00ffULL,
0x0000888012227816ULL, 0x004fc800000000ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x000000a700a77306ULL, 0x000ea20000200c00ULL, 0x00009910941f7816ULL, 0x020fe400000000ffULL,
0x00000018ff777819ULL, 0x000fe40000011476ULL, 0x000000ff1f00720cULL, 0x000fc60003f25270ULL,
0x0000005500ab7306ULL, 0x000ff00000200c00ULL, 0x0000001e00887306ULL, 0x0007e40000200c00ULL,
0x0000001d18189232ULL, 0x002fc40000000000ULL, 0x0000001d1a1a9232ULL, 0x000fe40000000000ULL,
0x0000001c19199232ULL, 0x090fe40000000000ULL, 0x0000002000607306ULL, 0x0003e20000200c00ULL,
0x00008880101e7816ULL, 0x008fe200000000ffULL, 0x0000001c1b1b9232ULL, 0x000fcc0000000000ULL,
0x0000001600557306ULL, 0x0007e20000200c00ULL, 0x0000888011207816ULL, 0x042fe200000000ffULL,
0x0001000011117824ULL, 0x000fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000010010167824ULL, 0x048fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000001400ad7306ULL, 0x000e700000200c00ULL, 0x000000b000b07306ULL, 0x000ef00000200c00ULL,
0x0000002100637306ULL, 0x000ff00000200c00ULL, 0x00000010001f7306ULL, 0x0005f00000200c00ULL,
0x0000001100217306ULL, 0x0009e20000200c00ULL, 0x00005410a7107816ULL, 0x004fce00000000aeULL,
0x0000001500157306ULL, 0x000ea20000200c00ULL, 0x00005410a9117816ULL, 0x010fce00000000b2ULL,
0x0000005400147306ULL, 0x0009620000200c00ULL, 0x000000101844723cULL, 0x000fee0000001844ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x0000888023547816ULL, 0x050fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00005410ad107816ULL, 0x002fc40000000068ULL,
0x00005410b0117816ULL, 0x008fe40000000061ULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x0000009300937306ULL, 0x000e620000200c00ULL, 0x0000888013687816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe400078e00ffULL, 0x000000101840723cULL, 0x000fe60000001840ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x00000028007b7306ULL, 0x000fe60000200c00ULL,
0x0000541015107816ULL, 0x004fc400000000acULL, 0x0000541014117816ULL, 0x020fe400000000abULL,
0x0001380078157811ULL, 0x000fe200078e20ffULL, 0x0000002300287306ULL, 0x000fe80000200c00ULL,
0x000000101838723cULL, 0x000fe80000001838ULL, 0x0000009c009c7306ULL, 0x000ea60000200c00ULL,
0x00005410a5107816ULL, 0x000fc40000000092ULL, 0x00005410aa117816ULL, 0x002fc60000000093ULL,
0x0000009f009f7306ULL, 0x000e680000200c00ULL, 0x000000101848723cULL, 0x000fe80000001848ULL,
0x0000001600237306ULL, 0x0007e60000200c00ULL, 0x000054109c107816ULL, 0x004fca00000000a1ULL,
0x0000002900807306ULL, 0x000fe20000200c00ULL, 0x0000010012167824ULL, 0x048fe200078e00ffULL,
0x000054109f117816ULL, 0x002fe200000000a8ULL, 0x0001000012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011416ULL, 0x0000001700297306ULL, 0x0003e20000200c00ULL,
0x00000010184c723cULL, 0x000fe2000000184cULL, 0x00000018ff127819ULL, 0x000fcc0000011412ULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x000000001514783bULL, 0x002e6e0000000200ULL,
0x0000009000907306ULL, 0x000ef00000200c00ULL, 0x0000009a009a7306ULL, 0x000f220000200c00ULL,
0x00005410a4107816ULL, 0x004fce0000000091ULL, 0x0000009d009d7306ULL, 0x000ea20000200c00ULL,
0x00005410a3117816ULL, 0x008fe40000000090ULL, 0x000088800c907816ULL, 0x000fca00000000ffULL,
0x0000008f008f7306ULL, 0x000ee20000200c00ULL, 0x00000010185c723cULL, 0x000fee000000185cULL,
0x0000008d008d7306ULL, 0x000f620000200c00ULL, 0x000054109a107816ULL, 0x010fe2000000009bULL,
0x0000001d14149232ULL, 0x082fe20000000000ULL, 0x000054109d117816ULL, 0x004fe200000000a6ULL,
0x0000001d16169232ULL, 0x000fc40000000000ULL, 0x0000001c15159232ULL, 0x080fe40000000000ULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x000054109e9e7816ULL, 0x008fe2000000008fULL,
0x000000101858723cULL, 0x000fe20000001858ULL, 0x0000001c17179232ULL, 0x000fe20000000000ULL,
0x000088800d8f7816ULL, 0x000fc800000000ffULL, 0x0000008500857306ULL, 0x000ea20000200c00ULL,
0x000001000c107824ULL, 0x000fe200078e00ffULL, 0x00005410a29f7816ULL, 0x020fe2000000008dULL,
0x000001000d117824ULL, 0x040fe400078e00ffULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000008b008b7306ULL, 0x000ee20000200c00ULL,
0x0000541095847816ULL, 0x002fe20000000084ULL, 0x0000009e1818723cULL, 0x000fe20000001850ULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000018ff0d7819ULL, 0x000fc6000001140dULL,
0x0000008900897306ULL, 0x000e620000200c00ULL, 0x0000541096857816ULL, 0x004fe20000000085ULL,
0x000001000f527824ULL, 0x040fe200078e00ffULL, 0x000088800e507816ULL, 0x000fe200000000ffULL,
0x000100000f537824ULL, 0x040fe200078e00ffULL, 0x000088800f517816ULL, 0x000fe400000000ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000000841440723cULL, 0x000fe20000001840ULL, 0x000054108b8a7816ULL, 0x008fc4000000008aULL,
0x00000018ff537819ULL, 0x000fc80000011453ULL, 0x00000010008d7306ULL, 0x0007e20000200c00ULL,
0x00005410898b7816ULL, 0x002fce000000008eULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000100000c107824ULL, 0x008fe200078e00ffULL, 0x0000541087897816ULL, 0x004fe20000000066ULL,
0x000000ffff667224ULL, 0x000fe200078e0050ULL, 0x0000008a1438723cULL, 0x000fe20000001838ULL,
0x000001000e507824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011410ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0001380079107811ULL, 0x000fe400078e20ffULL,
0x00000018ff507819ULL, 0x000fca0000011450ULL, 0x0000005600567306ULL, 0x000ee20000200c00ULL,
0x0000541088887816ULL, 0x002fce0000000067ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000054106c6c7816ULL, 0x004fe2000000006dULL, 0x000000881448723cULL, 0x000fec0000001848ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000054107b567816ULL, 0x008fce0000000056ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x0000541080577816ULL, 0x002fce0000000057ULL,
0x0000009700977306ULL, 0x000e620000200c00ULL, 0x00000056145c723cULL, 0x000fee000000185cULL,
0x0000009900997306ULL, 0x000ee20000200c00ULL, 0x000054106a0f7816ULL, 0x004fce000000003dULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000541097987816ULL, 0x002fce0000000098ULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000541099997816ULL, 0x008fce00000000a0ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x0000541081827816ULL, 0x004fe20000000082ULL,
0x000000981444723cULL, 0x000fec0000001844ULL, 0x0000001200767306ULL, 0x000fe20000200c00ULL,
0x0000541083837816ULL, 0x002fce0000000086ULL, 0x0000001300787306ULL, 0x000fe20000200c00ULL,
0x000054106e6d7816ULL, 0x008fe2000000006fULL, 0x00000082144c723cULL, 0x040fec000000184cULL,
0x00000011000c7306ULL, 0x0003e40000200c00ULL, 0x0000006c1458723cULL, 0x000fec0000001858ULL,
0x0000005000677306ULL, 0x0005e20000200c00ULL, 0x000000001010783bULL, 0x002e6e0000000200ULL,
0x0000005100567306ULL, 0x000fe20000200c00ULL, 0x000100000e507824ULL, 0x004fe200078e00ffULL,
0x000054106b0e7816ULL, 0x000fc8000000003eULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x0000005200577306ULL, 0x000fe20000200c00ULL, 0x0000000e1418723cULL, 0x000fee0000001818ULL,
0x0000005000157306ULL, 0x0005e20000200c00ULL, 0x000088807c167816ULL, 0x000fce00000000ffULL,
0x0000005300147306ULL, 0x0007e20000200c00ULL, 0x000138007a507811ULL, 0x004fce00078e20ffULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000000005050783bULL, 0x008ee20000000200ULL,
0x0000001d10109232ULL, 0x082fe40000000000ULL, 0x0000001d12129232ULL, 0x000fe40000000000ULL,
0x0000001c11119232ULL, 0x080fe40000000000ULL, 0x0000006400647306ULL, 0x000e620000200c00ULL,
0x0000001c13139232ULL, 0x000fce0000000000ULL, 0x0000003700377306ULL, 0x000f220000200c00ULL,
0x00005410620e7816ULL, 0x004fce0000000065ULL, 0x0000003c003c7306ULL, 0x000ea20000200c00ULL,
0x00005410640f7816ULL, 0x002fce0000000069ULL, 0x0000000a000a7306ULL, 0x000e620000200c00ULL,
0x0000000e1044723cULL, 0x000fe20000001844ULL, 0x0000541060627816ULL, 0x010fe40000000037ULL,
0x000088807d377816ULL, 0x000fc800000000ffULL, 0x0000000b000b7306ULL, 0x000f220000200c00ULL,
0x000001007c0f7824ULL, 0x040fe200078e00ffULL, 0x0000541063637816ULL, 0x004fe2000000003cULL,
0x000000ffff0e7224ULL, 0x000fe200078e0016ULL, 0x0000001d50509232ULL, 0x088fe20000000000ULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000001d52529232ULL, 0x000fe20000000000ULL, 0x0000001e001e7306ULL, 0x000ea20000200c00ULL,
0x000054102b0a7816ULL, 0x002fe2000000000aULL, 0x000000621040723cULL, 0x000fe20000001840ULL,
0x0000001c51519232ULL, 0x080fe20000000000ULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000001c53539232ULL, 0x000fc60000000000ULL, 0x0000002000207306ULL, 0x000e620000200c00ULL,
0x00005410280b7816ULL, 0x010fce000000000bULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000054101e287816ULL, 0x004fe20000000023ULL, 0x0000000a1048723cULL, 0x000fec0000001848ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x0000541020297816ULL, 0x002fe20000000029ULL,
0x000001007e0b7824ULL, 0x040fe200078e00ffULL, 0x000088807e0a7816ULL, 0x040fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x0000002c002c7306ULL, 0x000e620000200c00ULL, 0x00000028104c723cULL, 0x000fe2000000184cULL,
0x00000018ff7e7819ULL, 0x000fcc000001147eULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x0000541068237816ULL, 0x004fce0000000077ULL, 0x0000002700277306ULL, 0x000ea20000200c00ULL,
0x000054101f207816ULL, 0x002fce000000002cULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x0000541021217816ULL, 0x008fce0000000036ULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x0000541076767816ULL, 0x004fe20000000027ULL, 0x00000020105c723cULL, 0x000fec000000185cULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541078777816ULL, 0x002fce0000000035ULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x000000761018723cULL, 0x000fee0000001818ULL,
0x0000006100617306ULL, 0x000e700000200c00ULL, 0x0000008f008f7306ULL, 0x000eb00000200c00ULL,
0x0000000e00167306ULL, 0x0007e20000200c00ULL, 0x0000541022227816ULL, 0x002fce0000000061ULL,
0x0000000f00177306ULL, 0x0003220000200c00ULL, 0x000054102a0e7816ULL, 0x008fe2000000003fULL,
0x000000221058723cULL, 0x000fe20000001858ULL, 0x000054108f8f7816ULL, 0x004fe2000000000cULL,
0x000001007d2a7824ULL, 0x040fe400078e00ffULL, 0x000100007d7d7824ULL, 0x000fe400078e00ffULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x00005410540f7816ULL, 0x002fe40000000055ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff2a7819ULL, 0x000fc6000001142aULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x0000000e1038723cULL, 0x000fe20000001838ULL,
0x0000541016167816ULL, 0x010fcc0000000017ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x000088807f117816ULL, 0x000fe200000000ffULL, 0x000000ffff0e7224ULL, 0x000fc800078e0037ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x0000003300337306ULL, 0x000ff00000200c00ULL,
0x0000008400847306ULL, 0x000ff00000200c00ULL, 0x0000000d000d7306ULL, 0x000e700000200c00ULL,
0x0000000a001d7306ULL, 0x0005f00000200c00ULL, 0x0000000b00107306ULL, 0x0007220000200c00ULL,
0x000001007f0a7824ULL, 0x004fe200078e00ffULL, 0x000054100d0d7816ULL, 0x002fe20000000034ULL,
0x000100007f7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000000c00117306ULL, 0x0003e20000200c00ULL, 0x00005410140b7816ULL, 0x008fe40000000033ULL,
0x00000018ff7f7819ULL, 0x000fca000001147fULL, 0x0000000a00127306ULL, 0x0004e20000200c00ULL,
0x00005410840c7816ULL, 0x002fe40000000025ULL, 0x000054101d107816ULL, 0x010fca0000000010ULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x00005410150a7816ULL, 0x004fe20000000030ULL,
0x0000000c5040723cULL, 0x040fec0000001840ULL, 0x0000002d002d7306ULL, 0x000fe20000200c00ULL,
0x0000541011117816ULL, 0x008fe20000000012ULL, 0x0000000a5048723cULL, 0x040fec0000001848ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fe20000000067ULL,
0x000000105058723cULL, 0x000fe20000001858ULL, 0x0000541056677816ULL, 0x000fca0000000057ULL,
0x0000009000907306ULL, 0x000e640000200c00ULL, 0x000000665038723cULL, 0x000fec0000001838ULL,
0x0000000e000e7306ULL, 0x000ff00000200c00ULL, 0x0000002a000f7306ULL, 0x000ea20000200c00ULL,
0x00005410908e7816ULL, 0x002fce000000008dULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x0000008e5044723cULL, 0x000fee0000001844ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x000054100e177816ULL, 0x004fe4000000000fULL, 0x00000001088e7812ULL, 0x000fca000784c0ffULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x000054107c7c7816ULL, 0x002fe2000000002dULL,
0x00000016504c723cULL, 0x000fec000000184cULL, 0x0000003100317306ULL, 0x000fe20000200c00ULL,
0x000054107d7d7816ULL, 0x008fce0000000032ULL, 0x0000007e000d7306ULL, 0x000e620000200c00ULL,
0x0000007c505c723cULL, 0x000fee000000185cULL, 0x0000007f000a7306ULL, 0x000ea20000200c00ULL,
0x000054100d247816ULL, 0x002fe40000000024ULL, 0x000054100a257816ULL, 0x004fce0000000031ULL,
0x000000245050723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000099108c087816ULL, 0x000fe400000000ffULL, 0x00000001ff8d7807ULL, 0x000fe40004000000ULL,
0x000000ff0800720cULL, 0x000fc80003f25270ULL, 0x00000001ff09a807ULL, 0x000fc80000800000ULL,
0x00007610098c7816ULL, 0x000fe4000000008cULL, 0x0000030075757a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff07ff7812ULL, 0x000fe4000780c0ffULL, 0x000000707500720cULL, 0x000fe40003f26070ULL,
0x00000001ff077807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff4a1000007947ULL, 0x000fea000383ffffULL, 0x0000000000297919ULL, 0x000e640000002500ULL,
0x000000702900720cULL, 0x002fda0003f06070ULL, 0x0000038000000947ULL, 0x000fea0003800000ULL,
0x0180000004007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0004ULL,
0x0000c84000067802ULL, 0x010fe40000000f00ULL, 0x00009fc000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000400057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc80000000004ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff077624ULL, 0x010fe400078e00ffULL,
0x00006800ff067624ULL, 0x000fca00078e00ffULL, 0x0000000606077981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff097819ULL, 0x008fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000007007220ULL, 0x004fca0000410000ULL,
0x00001f0900027589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000004402447220ULL, 0x044fe40000410000ULL, 0x0000004502457220ULL, 0x040fe40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x000fc40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000004802487220ULL, 0x040fe40000410000ULL, 0x0000004902497220ULL, 0x040fe40000410000ULL,
0x0000004c024c7220ULL, 0x040fe40000410000ULL, 0x0000004d024d7220ULL, 0x000fc40000410000ULL,
0x0000005c025c7220ULL, 0x040fe40000410000ULL, 0x0000005d025d7220ULL, 0x040fe40000410000ULL,
0x0000005802587220ULL, 0x040fe40000410000ULL, 0x0000005902597220ULL, 0x040fe40000410000ULL,
0x0000005002507220ULL, 0x040fe40000410000ULL, 0x0000005102517220ULL, 0x000fc40000410000ULL,
0x0000004605467220ULL, 0x048fe40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x040fe40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x000fc40000410000ULL,
0x0000004a054a7220ULL, 0x040fe40000410000ULL, 0x0000004b054b7220ULL, 0x040fe40000410000ULL,
0x0000004e054e7220ULL, 0x040fe40000410000ULL, 0x0000004f054f7220ULL, 0x040fe40000410000ULL,
0x0000005e055e7220ULL, 0x040fe40000410000ULL, 0x0000005f055f7220ULL, 0x000fc40000410000ULL,
0x0000005a055a7220ULL, 0x040fe40000410000ULL, 0x0000005b055b7220ULL, 0x040fe40000410000ULL,
0x0000005205527220ULL, 0x040fe40000410000ULL, 0x0000005305537220ULL, 0x000fe40000410000ULL,
0x00000000000e7919ULL, 0x000ea20000000000ULL, 0x00000300ff287624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000012800780cULL, 0x000fe40003f05270ULL,
0x000000020e007812ULL, 0x004fe400078ec0ffULL, 0x00000002ff0f7819ULL, 0x000fe4000001160eULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200057811ULL, 0x000fc400078ff8ffULL,
0x0000000400087811ULL, 0x050fe400078ff8ffULL, 0x00000006000c7811ULL, 0x000fe400078ff8ffULL,
0x000000080e177811ULL, 0x000fe400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e780fULL,
0x0000000705067812ULL, 0x100fe400078e780fULL, 0x00000007080a7812ULL, 0x100fe200078e780fULL,
0x000000080f077824ULL, 0x040fe200078e0200ULL, 0x000000070c0d7812ULL, 0x000fe200078e780fULL,
0x0000080074007824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x100fe200078e7817ULL,
0x000000080f097824ULL, 0x040fe200078e0206ULL, 0x0000000702027812ULL, 0x100fe200078e7817ULL,
0x000000080f0b7824ULL, 0x000fe200078e020aULL, 0x0000000705057812ULL, 0x000fe200078e7817ULL,
0x000000080f0f7824ULL, 0x000fe200078e020dULL, 0x000000070c0c7812ULL, 0x000fe200078e7817ULL,
0x0000000817157824ULL, 0x000fe200078e0208ULL, 0x000000404106723eULL, 0x000fe200000000ffULL,
0x00000008170d7824ULL, 0x000fe200078e0202ULL, 0x0001200000027810ULL, 0x000fe20007ffe0ffULL,
0x000000080e087824ULL, 0x000fe200078e00ffULL, 0x00000042430a723eULL, 0x000fe200000000ffULL,
0x0000000817137824ULL, 0x000fe200078e0205ULL, 0x000000444505723eULL, 0x000fe200000000ffULL,
0x0000000817177824ULL, 0x000fe200078e020cULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x0000541005187816ULL, 0x000fe20000000006ULL,
0x000000100d117824ULL, 0x000fe200078e0202ULL, 0x0000763205197816ULL, 0x000fe20000000006ULL,
0x0000001009097824ULL, 0x100fe200078e0202ULL, 0x0000004c4d05723eULL, 0x000fe200000000ffULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000005c5d06723eULL, 0x000fe200000000ffULL,
0x000000100b0d7824ULL, 0x000fc400078e0202ULL, 0x000000100f0f7824ULL, 0x100fe400078e0202ULL,
0x0000001015157824ULL, 0x100fe400078e0202ULL, 0x0000001017177824ULL, 0x000fe400078e0202ULL,
0x00000001070b7824ULL, 0x000fe200078e0208ULL, 0x000000383907723eULL, 0x000fe200000000ffULL,
0x0000000108117824ULL, 0x040fe400078e0211ULL, 0x00000001080c7824ULL, 0x040fe200078e0209ULL,
0x000000180b007388ULL, 0x0005e20000000a00ULL, 0x0000000108137824ULL, 0x040fe200078e0213ULL,
0x000000464709723eULL, 0x000fe200000000ffULL, 0x00000001080d7824ULL, 0x000fc400078e020dULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x000fe200078e0217ULL, 0x000000484908723eULL, 0x000fc800000000ffULL,
0x0000541007187816ULL, 0x144fe40000000008ULL, 0x0000763207197816ULL, 0x000fe40000000008ULL,
0x000000585907723eULL, 0x000fe400000000ffULL, 0x000000505108723eULL, 0x000fe200000000ffULL,
0x000000180c007388ULL, 0x0005e40000000a00ULL, 0x0000541005187816ULL, 0x144fe40000000006ULL,
0x0000763205197816ULL, 0x000fc40000000006ULL, 0x00005410070c7816ULL, 0x100fe40000000008ULL,
0x0000003a3b05723eULL, 0x000fe200000000ffULL, 0x000000180d007388ULL, 0x0005e20000000a00ULL,
0x0000004a4b06723eULL, 0x000fe400000000ffULL, 0x00007632070d7816ULL, 0x004fe40000000008ULL,
0x0000004e4f07723eULL, 0x000fe400000000ffULL, 0x0000005e5f08723eULL, 0x000fe200000000ffULL,
0x0000000c0f007388ULL, 0x0005e40000000a00ULL, 0x00005410090c7816ULL, 0x004fc4000000000aULL,
0x00007632090d7816ULL, 0x000fe4000000000aULL, 0x0000005a5b09723eULL, 0x000fe400000000ffULL,
0x00000052530a723eULL, 0x000fe200000000ffULL, 0x0000000c11007388ULL, 0x0005e40000000a00ULL,
0x00005410050c7816ULL, 0x144fe40000000006ULL, 0x00007632050d7816ULL, 0x000fe40000000006ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000000c13007388ULL, 0x0005e20000000a00ULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x0000000615007388ULL, 0x0005e80000000a00ULL,
0x0000000817007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cc000008947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x0000580028067a24ULL, 0x004fe200078e02ffULL, 0x000000ff7400720cULL, 0x000fe20003f25270ULL,
0x00002000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000167919ULL, 0x000ea20000002700ULL,
0x00006600060a7a24ULL, 0x000fc600078e02ffULL, 0x0000000000077919ULL, 0x000ea20000002600ULL,
0x00000010050b7824ULL, 0x048fe200078e0200ULL, 0x0000002005117810ULL, 0x040fe40007ffe0ffULL,
0x0000004005137810ULL, 0x040fe40007ffe0ffULL, 0x012000000b187984ULL, 0x0007220000000c00ULL,
0x0000006005157810ULL, 0x000fe20007ffe0ffULL, 0x0000580016167a24ULL, 0x004fe400078e0207ULL,
0x012200000b1c7984ULL, 0x0006a20000000c00ULL, 0x00001fff0a077811ULL, 0x000fe200078e40ffULL,
0x0000030016067a24ULL, 0x000fc400078e02ffULL, 0x012400000b207984ULL, 0x0006620000000c00ULL,
0x000000ff0500720cULL, 0x000fe20003f05270ULL, 0x00000001060c7824ULL, 0x000fe400078e0229ULL,
0x012600000b247984ULL, 0x0006620000000c00ULL, 0x000000ff7400720cULL, 0x000fe40000705670ULL,
0x0000000c07087211ULL, 0x000fca00078f98ffULL, 0x00006c0008087625ULL, 0x000fcc00078e0009ULL,
0x0000080074087825ULL, 0x000fcc00078e0008ULL, 0x0000001011107825ULL, 0x000fc800078e0008ULL,
0x0000001013127825ULL, 0x000fc800078e0008ULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x00000010050e7825ULL, 0x000fe200078e0008ULL, 0x01ffffff0a097812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x01cea20000000000ULL,
0x00000080ff087424ULL, 0x000fe400078e00ffULL, 0x000000010c0d7824ULL, 0x000fe400078e0209ULL,
0x000000100a177824ULL, 0x004fe200078e00ffULL, 0x00000001ff297819ULL, 0x000fe2000001160aULL,
0x00006c000c0a7625ULL, 0x000fc600078e0008ULL, 0x0000007017177812ULL, 0x000fe200078ec0ffULL,
0x00006c000d0c7625ULL, 0x000fe200078e0008ULL, 0x0000000c29297812ULL, 0x000fc800078ec0ffULL,
0x0000000a290a7210ULL, 0x140fe40007b5e017ULL, 0x0000000c290c7210ULL, 0x000fe40007d9e017ULL,
0x0000000bff0b7210ULL, 0x000fe400017e64ffULL, 0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL,
0x000000030a007986ULL, 0x0005e8000c101906ULL, 0x000000040c007986ULL, 0x0005e4000c101906ULL,
0x000000180e007986ULL, 0x01c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001c10007986ULL, 0x0005e8000c101d06ULL, 0x0000002012007986ULL, 0x0025e8000c101d06ULL,
0x0000002414007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0b7424ULL, 0x000fe200078e00ffULL,
0xffffffff28037810ULL, 0x000fc60007ffe0ffULL, 0x00006a00160a7625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000030a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x000000030a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff047807ULL, 0x000fca0000000000ULL,
0x00000004ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff037984ULL, 0x000ee40000000000ULL,
0x000000ff0300720cULL, 0x008fda0003f05270ULL, 0x0000285000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x00000001060c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001005037824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x002fe20000011605ULL,
0x00000080ff0f7424ULL, 0x004fc600078e00ffULL, 0x0000007003117812ULL, 0x000fe200078ec0ffULL,
0x00006c00060a7625ULL, 0x000fe200078e000fULL, 0x0000000c04137812ULL, 0x000fc600078ec0ffULL,
0x00006c000c0c7625ULL, 0x000fe200078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000c130c7210ULL, 0x000fe40007b5e011ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a037981ULL, 0x000368000c1e1900ULL,
0x000000060c047981ULL, 0x000362000c1e1900ULL, 0x000000022800780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a087981ULL, 0x000362000c1e1900ULL,
0x000000042800780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a0e7981ULL, 0x000362000c1e1900ULL, 0x000000042800780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004060a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e000fULL, 0x0000000a130a7210ULL, 0x000fc8000791e011ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a107981ULL, 0x000362000c1e1900ULL,
0x000000062800780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005060a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fc8000791e011ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a127981ULL, 0x000362000c1e1900ULL, 0x000000062800780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082800780cULL, 0x002fe40003f06070ULL,
0x00000006060a7810ULL, 0x000fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e000fULL,
0x0000000a130a7210ULL, 0x000fe40007a3e011ULL, 0x00000007060c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006c000c0c0625ULL, 0x000fe400078e000fULL,
0x000000060a147981ULL, 0x000366000c1e1900ULL, 0x0000000c130c0210ULL, 0x000fc80007c7e011ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c160981ULL, 0x000368000c1e1900ULL,
0x00000007280a7810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0c7819ULL, 0x000fc8000001160aULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000ffff187224ULL, 0x024fe400078e0003ULL,
0x000000080d0f7824ULL, 0x040fe200078e00ffULL, 0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000c0d00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080f0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001803037209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a187981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000403037209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001005047824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007004117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a047981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000803037209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007008117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a087981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000e03037209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff137819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13137812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a130a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0e7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001003037209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005107824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007010117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a107981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060f0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001203037209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x0000001005117824ULL, 0x000fe200078e00ffULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000a120a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a127981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0f0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070f0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001403037209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001060a7824ULL, 0x000fe200078e020bULL,
0x00000001ff137819ULL, 0x000fe20000011605ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001005117824ULL, 0x000fe200078e00ffULL, 0x0000000c13137812ULL, 0x000fe200078ec0ffULL,
0x00006c000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007011117812ULL, 0x000fc800078ec0ffULL,
0x0000000a130a7210ULL, 0x000fc80007b3e011ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a147981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001603037209ULL, 0x000fe40007810000ULL,
0x000003000f007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001060a7824ULL, 0x002fe200078e020fULL, 0x00000001ff117819ULL, 0x000fe20000011605ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010050f7824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006c000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a110a7210ULL, 0x000fc80007a3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a167981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x0000001005047824ULL, 0x028fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011605ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c080b7812ULL, 0x002fca00078ec0ffULL,
0x0000000104047824ULL, 0x000fca00078e020bULL, 0x0000000304007388ULL, 0x0003e40000000800ULL,
0x00000006070a7211ULL, 0x000fe200078f98ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000070500780cULL, 0x040fe20003f04070ULL,
0x00000800743f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x002fe20000011605ULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff417819ULL, 0x000fe20000011674ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000c04047812ULL, 0x000fe200078ec0ffULL,
0x0000001005037824ULL, 0x040fe200078e00ffULL, 0x0000003f0a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000100074267824ULL, 0x004fe200078e00ffULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x0000007003037812ULL, 0x000fe200078ec0ffULL,
0x0000000106128824ULL, 0x000fe200078e0209ULL, 0x00000040050f7810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff138424ULL, 0x000fe200078e00ffULL, 0x0000006005117810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200008e0641ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00006c0012128625ULL, 0x000fe200078e0013ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x020fe2000001ff00ULL,
0x0000000103037824ULL, 0x000fe200078e0204ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000100d0c7825ULL, 0x100fe200078e000aULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000003197984ULL, 0x0002a20000000800ULL,
0x000000100f0e7825ULL, 0x000fc800078e000aULL, 0x0000001011107825ULL, 0x000fc800078e000aULL,
0x00000010741d8824ULL, 0x000fe400078e0205ULL, 0x00006c0006148625ULL, 0x000fc600078e0015ULL,
0x000045801d1d8811ULL, 0x000fe200078e20ffULL, 0x00000010051b7824ULL, 0x040fe400078e0226ULL,
0x00000010050a7825ULL, 0x000fc800078e000aULL, 0x00000010741f8824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000a1b7faeULL, 0x0007e2000b901c46ULL,
0x0000001005128825ULL, 0x000fc600078e0012ULL, 0x000041801f1f8811ULL, 0x000fe200078e20ffULL,
0x0000001005148825ULL, 0x000fe200078e0014ULL, 0x003800000c1b7faeULL, 0x0009e6000b901c46ULL,
0x000000ffff037224ULL, 0x002fe200078e00ffULL, 0x005800000e1b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000000000a7805ULL, 0x008fe2000001ff00ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x00780000101b7faeULL, 0x0007e2000b901c46ULL,
0x000000ffff277224ULL, 0x000fc600078e00ffULL, 0x00000000121d8faeULL, 0x0005e2000b901c46ULL,
0x00000000000c7805ULL, 0x010fc6000001ff00ULL, 0x00000000141f8faeULL, 0x0009e2000b901c46ULL,
0x00000000000e7805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000107805ULL, 0x008fe2000001ff00ULL, 0x0000000000127805ULL, 0x004fe2000001ff00ULL,
0x0000000000147805ULL, 0x010fe2000001ff00ULL, 0x00000d6000009947ULL, 0x000fea0003800000ULL,
0x000000ffff037224ULL, 0x000fe400078e00ffULL, 0x000000ffff367224ULL, 0x000fca00078e00ffULL,
0x0000000136377810ULL, 0x000fc80007ffe0ffULL, 0x0000030037007a0cULL, 0x000fda0003f06070ULL,
0x0000029000000947ULL, 0x000fea0003800000ULL, 0x0000000106387824ULL, 0x000fe200078e0237ULL,
0x000000070500780cULL, 0x000fe20003f24070ULL, 0x00002000ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000001371f7812ULL, 0x040fe200078ec0ffULL, 0x00000800371c7824ULL, 0x000fe200078e00ffULL,
0x00000038071a7211ULL, 0x000fe400078f98ffULL, 0x0000002005217810ULL, 0x040fe40007ffe0ffULL,
0x000008001c1d7812ULL, 0x000fe200078ec0ffULL, 0x00006c001a1a7625ULL, 0x000fe200078e001bULL,
0x0000004005257810ULL, 0x000fc40007ffe0ffULL, 0x00000060053b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001261c7824ULL, 0x000fe200078e021dULL, 0x0000003f1a1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000109229824ULL, 0x000fe400078e0238ULL, 0x00000080ff239424ULL, 0x000fe400078e00ffULL,
0x000000011b1b7824ULL, 0x000fe400000e0641ULL, 0x0000000274249824ULL, 0x140fe400078e021fULL,
0x00000002743a9824ULL, 0x000fc400078e021fULL, 0x00000080ff3d9424ULL, 0x000fe400078e00ffULL,
0x0000001005397824ULL, 0x000fe400078e021cULL, 0x00000010211e7825ULL, 0x000fc800078e001aULL,
0x0000001025207825ULL, 0x000fc800078e001aULL, 0x00000010051c7825ULL, 0x000fc800078e001aULL,
0x000000103b1a7825ULL, 0x000fe200078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800001c397faeULL, 0x0003e6000b901c46ULL, 0x00006c0022229625ULL, 0x000fe200078e0023ULL,
0x003800001e397faeULL, 0x0003e6000b901c46ULL, 0x00000008243b9824ULL, 0x000fe200078e0205ULL,
0x0058000020397faeULL, 0x0003e2000b901c46ULL, 0x00006c0038249625ULL, 0x000fc600078e003dULL,
0x000045803b3b9811ULL, 0x000fe200078e20ffULL, 0x000000083a3a9824ULL, 0x000fe200078e0205ULL,
0x007800001a397faeULL, 0x0003e2000b901c46ULL, 0x0000001005229825ULL, 0x000fc600078e0022ULL,
0x000041803a3d9811ULL, 0x000fe200078e20ffULL, 0x0000001005249825ULL, 0x000fe200078e0024ULL,
0x00000000223b9faeULL, 0x0003e8000b901c46ULL, 0x00000000243d9faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff1d7224ULL, 0x002fe200078e0036ULL,
0x00000001ff1e7819ULL, 0x100fe20000011605ULL, 0x00000010051c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff237819ULL, 0x000fe20000011605ULL, 0x000000801d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000823217824ULL, 0x040fe200078e00ffULL, 0x000000801a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008231f7824ULL, 0x040fe200078e00ffULL, 0x00000007233c7812ULL, 0x000fe400078ec0ffULL,
0x00000023ff3a7212ULL, 0x000fe200078e33ffULL, 0x00000100741b7824ULL, 0x000fe200078e021bULL,
0xfffffff81f1a7812ULL, 0x000fe400078ee23cULL, 0xfffffff8213a7812ULL, 0x000fc400078ee23aULL,
0x0000001b1e1c7210ULL, 0x000fe20007ffe01cULL, 0x00000008231b7824ULL, 0x040fe200078e00ffULL,
0x0000000823257810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180001c387984ULL, 0x000e620000000800ULL, 0x000000011b1e7812ULL, 0x100fe200078ef63cULL,
0x00000008251f7824ULL, 0x000fe200078e00ffULL, 0x000000021b207812ULL, 0x140fe200078ef63cULL,
0x004580001c4a7984ULL, 0x0002a20000000800ULL, 0x000000031b227812ULL, 0x100fe200078ef63cULL,
0x00000008253e7824ULL, 0x000fe200078e00ffULL, 0x000000041b247812ULL, 0x140fe400078ef63cULL,
0x000000051b367812ULL, 0x000fe400078ef63cULL, 0x00000025ff487212ULL, 0x000fc800078e33ffULL,
0xfffffff81f487812ULL, 0x000fe400078ee248ULL, 0x00000007251f7812ULL, 0x000fe200078ec0ffULL,
0x00000038191c7221ULL, 0x002fe20000010100ULL, 0x000000061b387812ULL, 0x000fe200078ef63cULL,
0x000008001d1b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c217820ULL, 0x000fe40000410000ULL,
0x00000004051c7824ULL, 0x000fe200078e00ffULL, 0x000008001b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008253c7824ULL, 0x000fc400078e00ffULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x00000180261b7810ULL, 0x000fe40007ffe01bULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff83e1c7812ULL, 0x000fe200078ee21fULL, 0x000000101a1a7824ULL, 0x000fe200078e021bULL,
0x000000013c3e7812ULL, 0x000fe200078ef61fULL, 0x000000101e1e7824ULL, 0x000fe200078e021bULL,
0x000000023c407812ULL, 0x000fe200078ef61fULL, 0x000000011a1a7824ULL, 0x000fe200078e021dULL,
0x000000033c427812ULL, 0x140fe200078ef61fULL, 0x000000011d1e7824ULL, 0x040fe200078e021eULL,
0x000000043c447812ULL, 0x000fe200078ef61fULL, 0x000000103a3a7824ULL, 0x000fe200078e021bULL,
0x000000053c467812ULL, 0x000fe200078ef61fULL, 0x000000001a1a7984ULL, 0x000e620000000800ULL,
0x0000001022227824ULL, 0x000fe200078e021bULL, 0x000000063c3c7812ULL, 0x000fe200078ef61fULL,
0x000000011d3a7824ULL, 0x040fe200078e023aULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000011d227824ULL, 0x000fc400078e0222ULL, 0x0000001020207824ULL, 0x100fe400078e021bULL,
0x0000001036367824ULL, 0x100fe200078e021bULL, 0x000000003a3a7984ULL, 0x000ee20000000800ULL,
0x000000011d207824ULL, 0x040fe400078e0220ULL, 0x000000011d367824ULL, 0x000fe200078e0236ULL,
0x0000000022227984ULL, 0x000fe20000000800ULL, 0x0000001024247824ULL, 0x100fe400078e021bULL,
0x0000001038387824ULL, 0x000fe200078e021bULL, 0x0000000020207984ULL, 0x000fe20000000800ULL,
0x0000004a214a7220ULL, 0x004fc40000410000ULL, 0x000000011d247824ULL, 0x040fe200078e0224ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x000000011d387824ULL, 0x040fe400078e0238ULL,
0x000000101c1c7824ULL, 0x100fe200078e021bULL, 0x00001f234a1f7589ULL, 0x000ea200000e0000ULL,
0x000000103e3e7824ULL, 0x000fe400078e021bULL, 0x000000011d1c7824ULL, 0x040fe200078e021cULL,
0x0000000024247984ULL, 0x000f220000000800ULL, 0x000000011d3e7824ULL, 0x000fc400078e023eULL,
0x0000001040407824ULL, 0x100fe200078e021bULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x0000001042427824ULL, 0x100fe400078e021bULL, 0x000000011d407824ULL, 0x040fe200078e0240ULL,
0x000000001c1c7984ULL, 0x000f620000000800ULL, 0x000000011d427824ULL, 0x000fe400078e0242ULL,
0x0000001044447824ULL, 0x100fe200078e021bULL, 0x000000003e3e7984ULL, 0x000f620000000800ULL,
0x0000001046467824ULL, 0x000fc400078e021bULL, 0x000000011d447824ULL, 0x040fe200078e0244ULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000011d467824ULL, 0x040fe400078e0246ULL,
0x0000001048487824ULL, 0x100fe200078e021bULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x000000103c3c7824ULL, 0x000fe200078e021bULL, 0x2000001aff1b7230ULL, 0x002fe20000004100ULL,
0x000000011d487824ULL, 0x040fe200078e0248ULL, 0x0000000044447984ULL, 0x000fe20000000800ULL,
0x000000011d3c7824ULL, 0x000fe200078e023cULL, 0x2000003aff1d7230ULL, 0x008fe20000004100ULL,
0x0000001f1b347223ULL, 0x084fe20000010034ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x2000001eff1b7230ULL, 0x000fe20000004100ULL, 0x000000354a357221ULL, 0x000fe20000010000ULL,
0x3000001aff1a7230ULL, 0x000fe20000004100ULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x0000001f1d187223ULL, 0x080fe20000010018ULL, 0x20000020ff1d7230ULL, 0x000fe20000004100ULL,
0x0000001f1b327223ULL, 0x080fe20000010032ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x20000022ff1b7230ULL, 0x000fe20000004100ULL, 0x0000001f1a337223ULL, 0x080fe20000010033ULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x00001f254a4a7589ULL, 0x000e6200000e0000ULL,
0x0000001f1d307223ULL, 0x080fe20000010030ULL, 0x20000024ff1d7230ULL, 0x010fe20000004100ULL,
0x0000001f1b2e7223ULL, 0x080fe2000001002eULL, 0x20000036ff1b7230ULL, 0x100fe20000004100ULL,
0x0000001f3a177223ULL, 0x080fe20000010017ULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x0000001f1d2c7223ULL, 0x080fe2000001002cULL, 0x2000001cff1d7230ULL, 0x020fe20000004100ULL,
0x0000001f1b2a7223ULL, 0x080fe2000001002aULL, 0x20000038ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f36297223ULL, 0x080fe20000010029ULL, 0x3000001eff1e7230ULL, 0x000fe20000004100ULL,
0x000000ffff367224ULL, 0x000fe200078e0037ULL, 0x30000020ff207230ULL, 0x000fe20000004100ULL,
0x0000001f1b287223ULL, 0x080fe20000010028ULL, 0x2000003eff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f1e317223ULL, 0x080fe20000010031ULL, 0x0000030036007a0cULL, 0x000fe20003f06070ULL,
0x30000022ff227230ULL, 0x000fe20000004100ULL, 0x0000001f202f7223ULL, 0x000fe2000001002fULL,
0x30000024ff247230ULL, 0x000fc40000004100ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000004a1d167223ULL, 0x082fe20000010016ULL, 0x20000040ff1d7230ULL, 0x000fe20000004100ULL,
0x0000004a1b147223ULL, 0x080fe20000010014ULL, 0x20000042ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f222d7223ULL, 0x080fe2000001002dULL, 0x3000001cff1c7230ULL, 0x000fe20000004100ULL,
0x0000004a1d127223ULL, 0x080fe20000010012ULL, 0x20000046ff1d7230ULL, 0x000fe20000004100ULL,
0x0000004a1b107223ULL, 0x080fe20000010010ULL, 0x20000044ff1b7230ULL, 0x000fe20000004100ULL,
0x0000001f242b7223ULL, 0x080fe2000001002bULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x0000001f38277223ULL, 0x000fe20000010027ULL, 0x20000048ff1f7230ULL, 0x000fe20000004100ULL,
0x0000004a1b0e7223ULL, 0x080fe2000001000eULL, 0x30000040ff407230ULL, 0x000fe20000004100ULL,
0x0000004a1d0c7223ULL, 0x080fe2000001000cULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000004a1c157223ULL, 0x080fe20000010015ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000004a3e137223ULL, 0x080fe20000010013ULL, 0x30000046ff467230ULL, 0x000fe20000004100ULL,
0x0000004a40117223ULL, 0x080fe20000010011ULL, 0x2000003cff1b7230ULL, 0x100fe20000004100ULL,
0x0000004a420f7223ULL, 0x080fe2000001000fULL, 0x3000003cff1d7230ULL, 0x000fe20000004100ULL,
0x0000004a440d7223ULL, 0x080fe2000001000dULL, 0x30000048ff487230ULL, 0x000fe20000004100ULL,
0x0000004a460b7223ULL, 0x000fc4000001000bULL, 0x0000004a1b0a7223ULL, 0x080fe4000001000aULL,
0x0000004a1d087223ULL, 0x080fe40000010008ULL, 0x0000004a1f047223ULL, 0x080fe40000010004ULL,
0x0000004a48037223ULL, 0x000fe20000010003ULL, 0xfffff2c000008947ULL, 0x000fea000383ffffULL,
0x0180000035057810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000005057812ULL, 0x000fc600078ec0ffULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000f46000067802ULL, 0x000fe40000000f00ULL, 0x000073a000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003500067308ULL, 0x000e640000001000ULL,
0xbf80000006057423ULL, 0x002fc80000000035ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000506057223ULL, 0x000fe40000000006ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000001a7919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff1c7819ULL, 0x010fe4000001161aULL, 0x000000081a3d7811ULL, 0x040fe200078ff0ffULL,
0x000000041a1a7824ULL, 0x000fe400078e00ffULL, 0x00001f1c05067589ULL, 0x00cea200000e0000ULL,
0x000000081c417824ULL, 0x000fe200078e00ffULL, 0x0000003dff3f7212ULL, 0x000fe200078e33ffULL,
0x000000083d1e7824ULL, 0x000fe200078e00ffULL, 0x00001f3d05077589ULL, 0x000ee800000e0000ULL,
0xfffffff81e3f7812ULL, 0x000fca00078ee23fULL, 0x000000103f3f7824ULL, 0x000fe400078e0202ULL,
0x0000003406347220ULL, 0x044fe40000410000ULL, 0x0000003306337220ULL, 0x040fe40000410000ULL,
0x0000003206327220ULL, 0x040fe40000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x000000343333723eULL, 0x000fe200000000ffULL, 0x0000003006307220ULL, 0x000fc40000410000ULL,
0x0000002f062f7220ULL, 0x040fe20000410000ULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x0000002e062e7220ULL, 0x040fe40000410000ULL, 0x0000002d062d7220ULL, 0x040fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000002c062c7220ULL, 0x040fe40000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000002a062a7220ULL, 0x000fc40000410000ULL, 0x0000002906297220ULL, 0x040fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000002806287220ULL, 0x040fe40000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000001806187220ULL, 0x040fe40000410000ULL, 0x0000001706177220ULL, 0x000fe20000410000ULL,
0x0000001cff067212ULL, 0x000fe200078e33ffULL, 0x0000000407047220ULL, 0x008fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000000307037220ULL, 0x000fe20000410000ULL,
0xfffffff841417812ULL, 0x000fe200078ee206ULL, 0x0000000e070e7220ULL, 0x000fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000000ffULL, 0x0000000d070d7220ULL, 0x000fe20000410000ULL,
0x000000040303723eULL, 0x000fe200000000ffULL, 0x0000000c070c7220ULL, 0x040fe20000410000ULL,
0x000000071c047812ULL, 0x000fe200078ec0ffULL, 0x0000000b070b7220ULL, 0x000fe20000410000ULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000000a070a7220ULL, 0x000fe20000410000ULL,
0x000000073d0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000807057220ULL, 0x000fe20000410000ULL,
0x0000000104097812ULL, 0x040fe200078e3cffULL, 0x000000083d067824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000001607167220ULL, 0x000fe20000410000ULL,
0x0000000a0505723eULL, 0x000fe200000000ffULL, 0x0000001507157220ULL, 0x040fe20000410000ULL,
0x0000000204197812ULL, 0x040fe200078e3cffULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x00000003041b7812ULL, 0x040fe200078e3cffULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x00000004041d7812ULL, 0x040fe200078e3cffULL, 0x0000001207127220ULL, 0x040fe20000410000ULL,
0x00000005041f7812ULL, 0x040fe200078e3cffULL, 0x0000001107117220ULL, 0x040fe20000410000ULL,
0x0000000604217812ULL, 0x000fe200078e3cffULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0xfffffff806237812ULL, 0x000fe200078ee23dULL, 0x0000000f070f7220ULL, 0x000fe20000410000ULL,
0x000000010e047812ULL, 0x000fe200078e3cffULL, 0x000000081c077824ULL, 0x000fe200078e00ffULL,
0x000000020e067812ULL, 0x000fe200078e3cffULL, 0x000000081c097824ULL, 0x000fe200078e0209ULL,
0x000000030e087812ULL, 0x000fe200078e3cffULL, 0x000000081c197824ULL, 0x000fe200078e0219ULL,
0x000000040e0a7812ULL, 0x000fe200078e3cffULL, 0x000000081c1b7824ULL, 0x000fe200078e021bULL,
0x000000050e0c7812ULL, 0x000fe200078e3cffULL, 0x000000081c1d7824ULL, 0x040fe200078e021dULL,
0xfffffff807077812ULL, 0x000fe200078ee21cULL, 0x000000081c1f7824ULL, 0x000fe200078e021fULL,
0x000000060e0e7812ULL, 0x000fe200078e3cffULL, 0x000000081c217824ULL, 0x000fe200078e0221ULL,
0x0000000c1a1c7812ULL, 0x000fe200078ec0ffULL, 0x000000083d257824ULL, 0x000fe200078e0204ULL,
0x000000100f0f723eULL, 0x000fe200000000ffULL, 0x000000083d357824ULL, 0x002fe200078e0206ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x000000083d377824ULL, 0x000fe200078e0208ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x000000083d397824ULL, 0x000fe200078e020aULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000000083d3b7824ULL, 0x000fc400078e020cULL,
0x000000083d3d7824ULL, 0x000fe400078e020eULL, 0x0000001007077824ULL, 0x100fe400078e0202ULL,
0x0000001041067824ULL, 0x100fe400078e0202ULL, 0x0000001009097824ULL, 0x100fe400078e0202ULL,
0x0000001019197824ULL, 0x100fe400078e0202ULL, 0x000000101b1b7824ULL, 0x000fc400078e0202ULL,
0x0000001023237824ULL, 0x100fe400078e0202ULL, 0x000000011c047824ULL, 0x000fe400078e0207ULL,
0x000000101d1d7824ULL, 0x100fe400078e0202ULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000003304007388ULL, 0x0003e20000000800ULL, 0x0000001021217824ULL, 0x100fe400078e0202ULL,
0x0000001025257824ULL, 0x000fc400078e0202ULL, 0x0000001035357824ULL, 0x100fe400078e0202ULL,
0x0000001037377824ULL, 0x100fe400078e0202ULL, 0x0000001039397824ULL, 0x100fe400078e0202ULL,
0x000000103b3b7824ULL, 0x100fe400078e0202ULL, 0x000000103d3d7824ULL, 0x000fe400078e0202ULL,
0x000000011c107824ULL, 0x000fc400078e0206ULL, 0x000000011c027824ULL, 0x040fe400078e0209ULL,
0x000000011c067824ULL, 0x040fe400078e0219ULL, 0x000000011c087824ULL, 0x040fe200078e021bULL,
0x0000003102007388ULL, 0x0005e20000000800ULL, 0x000000011c0a7824ULL, 0x040fe400078e021dULL,
0x000000011c0c7824ULL, 0x040fe200078e021fULL, 0x0000002f06007388ULL, 0x0005e20000000800ULL,
0x000000011c0e7824ULL, 0x000fc400078e0221ULL, 0x000000011c127824ULL, 0x040fe200078e0223ULL,
0x0000002d08007388ULL, 0x0005e20000000800ULL, 0x000000011c147824ULL, 0x040fe400078e0225ULL,
0x000000011c047824ULL, 0x042fe200078e0235ULL, 0x0000002b0a007388ULL, 0x0005e20000000800ULL,
0x000000011c167824ULL, 0x040fe400078e0237ULL, 0x000000011c187824ULL, 0x040fe200078e0239ULL,
0x000000290c007388ULL, 0x0005e20000000800ULL, 0x000000011c1e7824ULL, 0x000fc400078e023fULL,
0x000000011c1a7824ULL, 0x040fe200078e023bULL, 0x000000270e007388ULL, 0x0005e20000000800ULL,
0x000000011c1c7824ULL, 0x000fc600078e023dULL, 0x0000001710007388ULL, 0x0005e80000000800ULL,
0x0000001512007388ULL, 0x0005e80000000800ULL, 0x0000001314007388ULL, 0x0005e80000000800ULL,
0x0000001104007388ULL, 0x0005e80000000800ULL, 0x0000000f16007388ULL, 0x0005e80000000800ULL,
0x0000000d18007388ULL, 0x0005e80000000800ULL, 0x0000000b1a007388ULL, 0x0005e80000000800ULL,
0x000000051c007388ULL, 0x0005e80000000800ULL, 0x000000031e007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000157919ULL, 0x004ea20000000000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x0000000000147919ULL, 0x000f220000002600ULL,
0x0000000405057899ULL, 0x000fc6000800063fULL, 0x1ffffff874747812ULL, 0x000fe400078ec0ffULL,
0x0000002015177810ULL, 0x044fe20007ffe0ffULL, 0x00000004050472a4ULL, 0x008fe2000f8e023fULL,
0x00000003ff027819ULL, 0x000fe20000011615ULL, 0x0000001014037824ULL, 0x050fe200078e00ffULL,
0x0000004015217810ULL, 0x040fe20007ffe0ffULL, 0x0000001014257824ULL, 0x040fe200078e00ffULL,
0x0000006015237810ULL, 0x000fe20007ffe0ffULL, 0x0000001014277824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc40000011617ULL, 0xfffffff003047812ULL, 0x002fe400078ee202ULL,
0x00000003ff087819ULL, 0x000fe40000011621ULL, 0x00000003ff0a7819ULL, 0x000fe40000011623ULL,
0x0000000702027812ULL, 0x000fe400078e4815ULL, 0x0000000705067812ULL, 0x000fe400078e4817ULL,
0x0000000708097812ULL, 0x000fc400078e4821ULL, 0x000000070a0b7812ULL, 0x000fe400078e4823ULL,
0x0ffffff802037812ULL, 0x000fe400078ef815ULL, 0x0ffffff806077812ULL, 0x000fe400078ef817ULL,
0x0ffffff809097812ULL, 0x000fe200078ef821ULL, 0x00000010030c7824ULL, 0x100fe200078e0200ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef823ULL, 0x0000001007077824ULL, 0x100fe200078e0200ULL,
0x0000000404047c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001009097824ULL, 0x000fe200078e0200ULL,
0xfffffff025087812ULL, 0x000fe200078ee208ULL, 0x000000100b0b7824ULL, 0x000fe200078e0200ULL,
0x012000000c0c7984ULL, 0x000e620000000c00ULL, 0x0000001014007824ULL, 0x000fe200078e00ffULL,
0xfffffff0270a7812ULL, 0x000fe200078ee20aULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x0120000007107984ULL, 0x0004e20000000c00ULL, 0x00005a0004027a11ULL, 0x000fc400078048ffULL,
0xfffffff000057812ULL, 0x000fe200078ee205ULL, 0x0120000009187984ULL, 0x0008e20000000c00ULL,
0x00005b0004037a11ULL, 0x000fe400000f4c03ULL, 0x0000000405057c10ULL, 0x000fe2000ff1e0ffULL,
0x012000000b1c7984ULL, 0x0008e20000000c00ULL, 0x0000000408007c10ULL, 0x000fe4000ff3e0ffULL,
0x000000040a0a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005a0005047a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x004fe200008e06ffULL,
0x00005a0000067a11ULL, 0x000fe200078248ffULL, 0x000000ffff097224ULL, 0x010fe200010e06ffULL,
0x00005a000a087a11ULL, 0x000fc400078448ffULL, 0x00000007740b7812ULL, 0x040fe400078ef815ULL,
0x0000000774157812ULL, 0x040fe400078ef817ULL, 0x00005b0005057a11ULL, 0x000fe200000f4c14ULL,
0x000000100b027825ULL, 0x000fe200078e0002ULL, 0x0000000774177812ULL, 0x000fe400078ef821ULL,
0x00005b0000077a11ULL, 0x000fe200008f4c07ULL, 0x0000001015047825ULL, 0x000fe200078e0004ULL,
0x0000000774217812ULL, 0x000fc400078ef823ULL, 0x00005b000a097a11ULL, 0x000fe200010f4c09ULL,
0x0000001017067825ULL, 0x000fc800078e0006ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000000c02007986ULL, 0x002fe8000c101d06ULL, 0x0000001004007986ULL, 0x008fe8000c101d06ULL,
0x0000001806007986ULL, 0x000fe8000c101d06ULL, 0x0000001c08007986ULL, 0x000fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006800ff267624ULL, 0x000fe200078e00ffULL,
0x00000001ff007819ULL, 0x000fe20000011674ULL, 0x00006900ff277624ULL, 0x000fc600078e00ffULL,
0x01ffffff00007812ULL, 0x000fe400078ec0ffULL, 0x0000000626267981ULL, 0x000566000c1e9900ULL,
0x0000000275037824ULL, 0x002fe400078e0200ULL, 0xffffffffff007424ULL, 0x000fc600078e00ffULL,
0x000000720300720cULL, 0x000fe40003f06070ULL, 0x0000000175077810ULL, 0x000fd60007ffe0ffULL,
0x0000000228048824ULL, 0x000fc800078e00ffULL, 0x0000640004048a24ULL, 0x000fc800078e0203ULL,
0x0000600004048625ULL, 0x000fca00078e0017ULL, 0x0000000604008981ULL, 0x000562000c1e1900ULL,
0x000000700700720cULL, 0x000fe20003f06070ULL, 0x0000004074027824ULL, 0x000fe400078e00ffULL,
0x0000008024247824ULL, 0x000fe400078e00ffULL, 0x0000010075077824ULL, 0x000fe200078e0202ULL,
0x0000000704047899ULL, 0x000fc8000800063fULL, 0x0000004024197812ULL, 0x000fc600078ef807ULL,
0x00000cb000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x004e620000000000ULL,
0x0000000773047217ULL, 0x000fe20007800000ULL, 0x0000000400197c24ULL, 0x020fe2000f8e0219ULL,
0x00002000741a7811ULL, 0x000fe200078e70ffULL, 0x00000100ff317424ULL, 0x000fe400078e00ffULL,
0x0000000104187824ULL, 0x000fe200078e0a07ULL, 0x00000003ff2f7819ULL, 0x002fc8000001161cULL,
0x000000042f057810ULL, 0x040fe40007ffe0ffULL, 0x000000102f0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000082f077810ULL, 0x000fe20007ffe0ffULL, 0x00000008051d7824ULL, 0x000fe200078e00ffULL,
0x0000000c2f097810ULL, 0x000fe20007ffe0ffULL, 0x000000080b237824ULL, 0x000fe200078e00ffULL,
0x0000001c05067212ULL, 0x080fe200078e3cffULL, 0x00000008071f7824ULL, 0x000fe200078e00ffULL,
0x0000001c0b087212ULL, 0x080fe200078e3cffULL, 0x0000000809217824ULL, 0x000fe200078e00ffULL,
0x0000001c07047212ULL, 0x000fc400078e3cffULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee206ULL,
0x000000142f117810ULL, 0x000fe40007ffe0ffULL, 0x0000001c09067212ULL, 0x080fe200078e3cffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0xfffffff823237812ULL, 0x000fe200078ee208ULL,
0x000000101c087824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0x0000007f2f047812ULL, 0x000fe200078ec0ffULL,
0x0000001023237824ULL, 0x000fe200078e021aULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x0000001c11067212ULL, 0x000fe200078e3cffULL,
0x0000000119047824ULL, 0x000fe200078e0204ULL, 0x0000007008337812ULL, 0x000fe200078ec0ffULL,
0x0000001021217824ULL, 0x000fe200078e021aULL, 0x0000007f07087812ULL, 0x000fc400078ec0ffULL,
0xfffffff825257812ULL, 0x000fe400078ee206ULL, 0x000000180500720cULL, 0x080fe20003f86070ULL,
0x0000000119087824ULL, 0x000fe200078e0208ULL, 0x0000007f05067812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x080fe200078e0031ULL, 0x0000007f090a7812ULL, 0x040fe400078ec0ffULL,
0x000000180900720cULL, 0x000fe20003f06070ULL, 0x00005e0008087625ULL, 0x000fe200078e0031ULL,
0x00000004330c7210ULL, 0x000fc40007f3e0ffULL, 0x0000007f0b0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000119047824ULL, 0x000fe200078e020aULL, 0x0000000833087210ULL, 0x000fe20007f7e0ffULL,
0x0000000119067824ULL, 0x000fe200078e0206ULL, 0x000000180700720cULL, 0x080fe20003fa6070ULL,
0x000000ffff0d7224ULL, 0x000fe200008e0605ULL, 0x000000180b00720cULL, 0x000fe20003f46070ULL,
0x00005e0004047625ULL, 0x080fe200078e0031ULL, 0x000000182f177810ULL, 0x040fe40007ffe0ffULL,
0x0000001c2f297810ULL, 0x040fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0031ULL,
0x000000072f137812ULL, 0x000fc400078e481cULL, 0x0000007f29147812ULL, 0x000fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200018e0609ULL, 0x0000000433107210ULL, 0x000fe20007f7e0ffULL,
0x00000001190a7824ULL, 0x000fe200078e020eULL, 0x0000007f11047812ULL, 0x000fe200078ec0ffULL,
0x0000000817277824ULL, 0x000fe200078e00ffULL, 0x00000006330e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e000a0a7625ULL, 0x080fe200078e0031ULL, 0x0000007f17067812ULL, 0x000fe400078ec0ffULL,
0x000000202f2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000000a330a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e0607ULL,
0x000000181100720cULL, 0x000fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200018e0605ULL,
0x0ffffff8131b7812ULL, 0x000fe200078ef81cULL, 0x00005e0004047625ULL, 0x000fe200078e0031ULL,
0x0000007f2b167812ULL, 0x000fc400078ec0ffULL, 0x000000182f00720cULL, 0x000fe20003f66070ULL,
0x0000000119067824ULL, 0x000fe200078e0206ULL, 0x000000242f2d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000433127210ULL, 0x000fe20007fde0ffULL,
0x00005e0006067625ULL, 0x000fc800078e0031ULL, 0x0000000119047824ULL, 0x000fe400078e0214ULL,
0x000000ffff137224ULL, 0x000fe200030e0605ULL, 0x0000000633147210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fc800078e0031ULL, 0x0000000119067824ULL, 0x000fe400078e0216ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x0000000433167210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000001c17047212ULL, 0x000fe200078e3cffULL,
0x00005e0006067625ULL, 0x000fc600078e0031ULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1b7faeULL, 0x0003e2000d901c46ULL,
0x0000007f2d047812ULL, 0x000fe200078ec0ffULL, 0x00000008291e7824ULL, 0x000fe200078e00ffULL,
0x000000181700720cULL, 0x080fe20003f66070ULL, 0x000000000e1d7faeULL, 0x0005e2000e101c46ULL,
0x000000082b207824ULL, 0x000fe200078e00ffULL, 0x000000182900720cULL, 0x000fe20003f86070ULL,
0x0000000119047824ULL, 0x000fe200078e0204ULL, 0x00000000081f7faeULL, 0x0007e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200030e0605ULL, 0x0000000633067210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x000fe200078e0031ULL, 0x0000001c290d7212ULL, 0x082fe200078e3cffULL,
0x0000000010217faeULL, 0x0003e2000c101c46ULL, 0x0000001c2b1b7212ULL, 0x040fe200078e3cffULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x000000182b00720cULL, 0x000fe20003fa6070ULL,
0x0000001025257824ULL, 0x100fe200078e021aULL, 0xfffffff81e0f7812ULL, 0x004fe200078ee20dULL,
0x0000001027277824ULL, 0x100fe200078e021aULL, 0xfffffff8201b7812ULL, 0x000fe200078ee21bULL,
0x000000000a237faeULL, 0x0005e2000d101c46ULL, 0x00000004330c7210ULL, 0x000fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x100fe200078e021aULL, 0x000000282f097810ULL, 0x008fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000000012257faeULL, 0x0007e2000c901c46ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0605ULL, 0x0000002c2f1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000082d057824ULL, 0x040fe200078e00ffULL, 0x0000000014277faeULL, 0x0009e2000d901c46ULL,
0x0000001c2d047212ULL, 0x000fe200078e3cffULL, 0x0000000809117824ULL, 0x002fe200078e00ffULL,
0x000000182d00720cULL, 0x000fe20003fc6070ULL, 0x00000000160f7faeULL, 0x0003e2000e101c46ULL,
0xfffffff805057812ULL, 0x000fc400078ee204ULL, 0x0000007f09047812ULL, 0x000fe200078ec0ffULL,
0x00000000061b7faeULL, 0x0003e2000e901c46ULL, 0x000000081d137824ULL, 0x008fe200078e00ffULL,
0x000000302f1f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010050b7824ULL, 0x004fe200078e021aULL,
0x000000342f217810ULL, 0x000fe20007ffe0ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000007f1f0a7812ULL, 0x040fe200078ec0ffULL, 0x000000081f087824ULL, 0x000fe200078e00ffULL,
0x000000180900720cULL, 0x000fe20003fa6070ULL, 0x00005e0004047625ULL, 0x000fe200078e0031ULL,
0x000000000c0b7faeULL, 0x0005e2000f101c46ULL, 0x000000382f237810ULL, 0x000fc40007ffe0ffULL,
0x0000001c09067212ULL, 0x082fe200078e3cffULL, 0x00000008210e7824ULL, 0x000fe200078e00ffULL,
0x0000001c1f077212ULL, 0x080fe400078e3cffULL, 0xfffffff811117812ULL, 0x000fe400078ee206ULL,
0x0000001c1d067212ULL, 0x000fe400078e3cffULL, 0xfffffff808157812ULL, 0x010fe200078ee207ULL,
0x0000001011117824ULL, 0x000fe200078e021aULL, 0xfffffff813137812ULL, 0x000fc400078ee206ULL,
0x0000007f1d067812ULL, 0x000fe200078ec0ffULL, 0x0000001015157824ULL, 0x100fe200078e021aULL,
0x0000001c21097212ULL, 0x000fe200078e3cffULL, 0x0000001013137824ULL, 0x000fe200078e021aULL,
0x0000000433087210ULL, 0x000fe20007fde0ffULL, 0x0000000119067824ULL, 0x040fe200078e0206ULL,
0xfffffff80e177812ULL, 0x000fe200078ee209ULL, 0x0000000119047824ULL, 0x000fe200078e020aULL,
0x0000007f210c7812ULL, 0x004fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0031ULL,
0x0000007f230e7812ULL, 0x000fc400078ec0ffULL, 0x0000003c2f257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0605ULL, 0x00000006330a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0004047625ULL, 0x080fe200078e0031ULL, 0x0000007f25107812ULL, 0x000fe400078ec0ffULL,
0x000000181d00720cULL, 0x080fe20003f86070ULL, 0x0000000119067824ULL, 0x000fe200078e020cULL,
0x000000181f00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e0607ULL,
0x00000004330c7210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x080fe200078e0031ULL,
0x000000182100720cULL, 0x080fe20003f46070ULL, 0x0000000008117faeULL, 0x0003e2000e901c46ULL,
0x000000182300720cULL, 0x080fe20003f26070ULL, 0x0000000119047824ULL, 0x000fe200078e020eULL,
0x000000182500720cULL, 0x000fe20003f06070ULL, 0x000000ffff0d7224ULL, 0x000fe200030e0605ULL,
0x00000006330e7210ULL, 0x000fe20007fde0ffULL, 0x00005e0004047625ULL, 0x000fe200078e0031ULL,
0x0000001c25067212ULL, 0x040fe200078e3cffULL, 0x000000000a137faeULL, 0x0003e4000e101c46ULL,
0x00000008251b7824ULL, 0x000fc400078e00ffULL, 0x0000000119127824ULL, 0x000fe200078e0210ULL,
0x0000001c23107212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x0000000433047210ULL, 0x000fe20007fde0ffULL, 0x0000000823197824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x00005e0012067625ULL, 0x000fe200078e0031ULL,
0x000000000c157faeULL, 0x0003e4000d901c46ULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x000000ffff057224ULL, 0x000fe200030e0605ULL, 0x0000000633067210ULL, 0x000fe20007fde0ffULL,
0x0000001017177824ULL, 0x000fc400078e021aULL, 0x0000001019197824ULL, 0x100fe400078e021aULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x000000000e177faeULL, 0x0003e2000d101c46ULL,
0x000000ffff077224ULL, 0x000fc600030e0607ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x004e620000000000ULL, 0x0000000400197c24ULL, 0x020fe4000f8e0219ULL,
0x00000100ff227424ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x002fc80000011604ULL,
0x00000004050b7810ULL, 0x040fe40007ffe0ffULL, 0x00000008050f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001805217810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c05137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f087824ULL, 0x000fe200078e00ffULL,
0x000000040b067212ULL, 0x080fe200078e3cffULL, 0x00000008210c7824ULL, 0x000fe200078e00ffULL,
0x0000001005177810ULL, 0x000fe20007ffe0ffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0x000000040f077212ULL, 0x000fc400078e3cffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee206ULL,
0x00000008170a7824ULL, 0x000fe200078e00ffULL, 0x0000000421097212ULL, 0x080fe400078e3cffULL,
0x0000001c05257810ULL, 0x040fe40007ffe0ffULL, 0x00000028052b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000413067212ULL, 0x000fe200078e3cffULL, 0x0000000825377824ULL, 0x000fe200078e00ffULL,
0xfffffff808117812ULL, 0x000fc400078ee207ULL, 0x0000000417077212ULL, 0x080fe400078e3cffULL,
0xfffffff80c237812ULL, 0x000fe200078ee209ULL, 0x000000082b0c7824ULL, 0x000fe200078e00ffULL,
0x0000002005277810ULL, 0x040fe40007ffe0ffULL, 0x00000014051d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000002c052d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d1f7824ULL, 0x000fe200078e00ffULL, 0x0000000425067212ULL, 0x000fc400078e3cffULL,
0x000000042b097212ULL, 0x080fe200078e3cffULL, 0x000000082d477824ULL, 0x000fe200078e00ffULL,
0x0000003805337810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee207ULL,
0x00000008270a7824ULL, 0x000fe200078e00ffULL, 0x0000002405297810ULL, 0x000fe40007ffe0ffULL,
0x0000000427077212ULL, 0x000fe400078e3cffULL, 0xfffffff837377812ULL, 0x000fe200078ee206ULL,
0x00000008293f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c437812ULL, 0x000fe200078ee209ULL,
0x00000008330c7824ULL, 0x000fe200078e00ffULL, 0x00000030052f7810ULL, 0x000fc40007ffe0ffULL,
0x000000041d087212ULL, 0x080fe400078e3cffULL, 0x000000042d067212ULL, 0x080fe400078e3cffULL,
0x0000000433097212ULL, 0x000fe400078e3cffULL, 0xfffffff80a3b7812ULL, 0x000fe200078ee207ULL,
0x000000082f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee208ULL,
0xfffffff847477812ULL, 0x000fc400078ee206ULL, 0x0000000429087212ULL, 0x080fe400078e3cffULL,
0x000000042f077212ULL, 0x000fe400078e3cffULL, 0xfffffff80c537812ULL, 0x000fe400078ee209ULL,
0x0000007f05067812ULL, 0x040fe400078ec0ffULL, 0x0000003405317810ULL, 0x040fe40007ffe0ffULL,
0x0000000705097812ULL, 0x000fc400078e4804ULL, 0x0000003c05357810ULL, 0x000fe20007ffe0ffULL,
0x0000000119057824ULL, 0x000fe200078e0206ULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee208ULL,
0x00000008314f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a4b7812ULL, 0x000fe200078ee207ULL,
0x0000001004077824ULL, 0x000fe200078e00ffULL, 0x0000007f25147812ULL, 0x000fe200078ec0ffULL,
0x00000008352c7824ULL, 0x000fe200078e00ffULL, 0x0000000431087212ULL, 0x000fe400078e3cffULL,
0x0ffffff809097812ULL, 0x000fc400078ef804ULL, 0x0000000435257212ULL, 0x000fe400078e3cffULL,
0x0000007f0b067812ULL, 0x000fe400078ec0ffULL, 0x0000007f0f0a7812ULL, 0x000fe400078ec0ffULL,
0x0000007f130c7812ULL, 0x000fe200078ec0ffULL, 0x00000001190b7824ULL, 0x000fe200078e0206ULL,
0x0000007f170e7812ULL, 0x000fe200078ec0ffULL, 0x00000001190f7824ULL, 0x000fe200078e020aULL,
0x0000007f1d107812ULL, 0x000fe200078ec0ffULL, 0x0000000119137824ULL, 0x000fe200078e020cULL,
0x0000007f21127812ULL, 0x000fe200078ec0ffULL, 0x0000000119177824ULL, 0x000fe200078e020eULL,
0x0000007f27167812ULL, 0x000fe200078ec0ffULL, 0x00000001191d7824ULL, 0x000fe200078e0210ULL,
0x0000007f29187812ULL, 0x000fe200078ec0ffULL, 0x0000000119217824ULL, 0x000fe200078e0212ULL,
0x0000007f2b1a7812ULL, 0x000fe200078ec0ffULL, 0x0000000119397824ULL, 0x000fe200078e0216ULL,
0x0000007f2d1c7812ULL, 0x000fe200078ec0ffULL, 0x00000001193d7824ULL, 0x000fe200078e0218ULL,
0x0000007f2f1e7812ULL, 0x000fe200078ec0ffULL, 0x0000000119417824ULL, 0x000fe200078e021aULL,
0x0000007f31207812ULL, 0x000fe200078ec0ffULL, 0x0000000119457824ULL, 0x000fe200078e021cULL,
0x0000007f332a7812ULL, 0x000fe200078ec0ffULL, 0x0000000119497824ULL, 0x000fe200078e021eULL,
0x0000007f35047812ULL, 0x000fe200078ec0ffULL, 0x0000000119357824ULL, 0x000fe200078e0214ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee208ULL, 0x00000001194d7824ULL, 0x040fe200078e0220ULL,
0x0000200074087811ULL, 0x000fe200078e70ffULL, 0x0000000119517824ULL, 0x000fc400078e022aULL,
0x0000000119557824ULL, 0x000fe200078e0204ULL, 0xfffffff82c197812ULL, 0x000fe200078ee225ULL,
0x00005e0005047625ULL, 0x000fe200078e0022ULL, 0x0000007007257812ULL, 0x000fc600078ec0ffULL,
0x00005e000b067625ULL, 0x000fe200078e0022ULL, 0x0000000425047210ULL, 0x000fc60007f1e0ffULL,
0x000000100d297824ULL, 0x100fe400078e0208ULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000625067210ULL, 0x000fe20007f1e0ffULL, 0x0000001009277824ULL, 0x100fe400078e0208ULL,
0x00000010112b7824ULL, 0x100fe400078e0208ULL, 0x00000010152d7824ULL, 0x100fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004277faeULL, 0x0003e2000b901c46ULL,
0x000000101b2f7824ULL, 0x000fc400078e0208ULL, 0x000000101f317824ULL, 0x100fe400078e0208ULL,
0x0000001023337824ULL, 0x100fe400078e0208ULL, 0x0000001037377824ULL, 0x100fe400078e0208ULL,
0x000000103b3b7824ULL, 0x100fe400078e0208ULL, 0x000000103f3f7824ULL, 0x100fe400078e0208ULL,
0x0000001043437824ULL, 0x000fc400078e0208ULL, 0x0000001047477824ULL, 0x100fe400078e0208ULL,
0x000000104b4b7824ULL, 0x100fe400078e0208ULL, 0x000000104f4f7824ULL, 0x100fe400078e0208ULL,
0x0000001053537824ULL, 0x100fe400078e0208ULL, 0x0000001019577824ULL, 0x000fe400078e0208ULL,
0x00005e00170c7625ULL, 0x000fc800078e0022ULL, 0x00005e000f087625ULL, 0x000fc800078e0022ULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000000c250c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0021107625ULL, 0x000fe200078e0022ULL, 0x0000000825087210ULL, 0x000fe40007f3e0ffULL,
0x0000000006297faeULL, 0x0003e2000b901c46ULL, 0x00005e001d0e7625ULL, 0x000fc800078e0022ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000001025107210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000000e250e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e00130a7625ULL, 0x000fc600078e0022ULL, 0x00000000082b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0039147625ULL, 0x000fe200078e0022ULL, 0x0000000a250a7210ULL, 0x000fc60007f5e0ffULL,
0x00005e0035127625ULL, 0x000fc800078e0022ULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001425147210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000001225127210ULL, 0x000fe20007f3e0ffULL, 0x00005e00451a7625ULL, 0x000fc800078e0022ULL,
0x00005e003d167625ULL, 0x000fc800078e0022ULL, 0x00005e0041187625ULL, 0x000fc800078e0022ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000001a251a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x0000001625167210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000001825187210ULL, 0x000fe20007f5e0ffULL,
0x00005e00491c7625ULL, 0x000fc600078e0022ULL, 0x000000000a2d7faeULL, 0x0003e2000b901c46ULL,
0x00005e004d1e7625ULL, 0x000fc600078e0022ULL, 0x000000000c2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0051207625ULL, 0x000fc600078e0022ULL, 0x000000000e317faeULL, 0x0003e2000b901c46ULL,
0x00005e0055227625ULL, 0x000fc600078e0022ULL, 0x0000000010337faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000001c251c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0617ULL, 0x0000001e251e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x0000002025207210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000002225227210ULL, 0x000fe20007f7e0ffULL,
0x0000000012377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fc400008e061fULL,
0x000000ffff217224ULL, 0x000fe200010e0621ULL, 0x00000000143b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc600018e0623ULL, 0x00000000163f7faeULL, 0x0003e8000b901c46ULL,
0x0000000018437faeULL, 0x0003e8000b901c46ULL, 0x000000001a477faeULL, 0x0003e8000b901c46ULL,
0x000000001c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e4f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020537faeULL, 0x0003e8000b901c46ULL, 0x0000000022577faeULL, 0x0003e4000b901c46ULL,
0x01c60400ff047984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000004ff7812ULL, 0x002fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000037400780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002074047824ULL, 0x002fc800078e0205ULL, 0x0000002004067824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7804ULL, 0x0000000709097812ULL, 0x100fe400078e7804ULL,
0x00000010050b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070b0b7812ULL, 0x000fc400078e7804ULL, 0x0000000007107984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7804ULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000000090c7984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff167224ULL, 0x004fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fe200078e0013ULL,
0x0000001407007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fca00078e000fULL, 0x0000001809007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x000000000b107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000eULL, 0x000000ffff1e7224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000001c0b007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01c60400ff047984ULL, 0x000ea40000000800ULL,
0x8000000004ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0022a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000707500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000257919ULL, 0x000ea20000000000ULL,
0x3d80000026267820ULL, 0x000fe20000410000ULL, 0xffffffff702a7810ULL, 0x000fe20007ffe0ffULL,
0x0000640028287a24ULL, 0x000fe200078e02ffULL, 0x00007610ff2b7816ULL, 0x000fe2000000002bULL,
0x0000001074277824ULL, 0x000fe200078e00ffULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000704047899ULL, 0x000fe4000800063fULL,
0x00000100752c7824ULL, 0x000fe200078e0202ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002c7300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0029ULL, 0x0000000000047805ULL, 0x002fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fc4000001ff00ULL,
0x000000012d307810ULL, 0x000fe20007ffe0ffULL, 0x0000171000007945ULL, 0x000fe60003800000ULL,
0x00000001ff2e7819ULL, 0x000fc40000011630ULL, 0x000000023000780cULL, 0x040fe40003f06070ULL,
0x00000001304e7812ULL, 0x000fe200078ec0ffULL, 0x000003002e297a24ULL, 0x000fe400078e0275ULL,
0x000000ffff2e7224ULL, 0x000fe400078e002dULL, 0x00000100293a7824ULL, 0x040fe200078e0202ULL,
0x0000000129317810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200078e0030ULL,
0x000000012f297812ULL, 0x000fc400078e0cffULL, 0x000000703100720cULL, 0x000fe40003f26070ULL,
0x000000403a317812ULL, 0x000fca00078ec0ffULL, 0x0000000124317824ULL, 0x000fcc00078e0231ULL,
0x00000bb000009947ULL, 0x020fea0003800000ULL, 0x00000003ff3e7819ULL, 0x004fe20000011625ULL,
0x00000004003b7c24ULL, 0x000fe2000f8e0231ULL, 0x0000003a73307217ULL, 0x000fe20007800000ULL,
0x00000100ff4b7424ULL, 0x000fe200078e00ffULL, 0x000000083e357810ULL, 0x040fe40007ffe0ffULL,
0x000000043e347810ULL, 0x000fe20007ffe0ffULL, 0x00000001303a7824ULL, 0x000fe200078e0a3aULL,
0x0000002535307212ULL, 0x040fe200078e3cffULL, 0x0000000835417824ULL, 0x000fe200078e00ffULL,
0x000000103e377810ULL, 0x000fe20007ffe0ffULL, 0x00000008343f7824ULL, 0x000fe200078e00ffULL,
0x0000000c3e367810ULL, 0x000fc40007ffe0ffULL, 0xfffffff841417812ULL, 0x000fe200078ee230ULL,
0x000000084e307824ULL, 0x000fe200078e00ffULL, 0x0000002534327212ULL, 0x080fe200078e3cffULL,
0x00000008373c7824ULL, 0x040fe200078e00ffULL, 0x0000002537337212ULL, 0x000fe200078e3cffULL,
0x0000000836437824ULL, 0x000fe200078e00ffULL, 0xfffffff8303d7812ULL, 0x000fe400078ee225ULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee232ULL, 0x0000007f3e307812ULL, 0x000fc400078ec0ffULL,
0x0000002536327212ULL, 0x000fe400078e3cffULL, 0xfffffff83c457812ULL, 0x000fe200078ee233ULL,
0x00000002743c7824ULL, 0x000fe200078e0229ULL, 0xfffffff843437812ULL, 0x000fe200078ee232ULL,
0x0000000130307824ULL, 0x000fe200078e023bULL, 0x000000073e327812ULL, 0x040fe400078e4825ULL,
0x0000003a3e00720cULL, 0x000fe20003f26070ULL, 0x00005e0030307625ULL, 0x000fe200078e004bULL,
0x000020003c3c7811ULL, 0x000fc400078e68ffULL, 0x0ffffff832337812ULL, 0x000fe400078ef825ULL,
0x000000183e427810ULL, 0x040fe20007ffe0ffULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x000000143e397810ULL, 0x000fe40007ffe0ffULL, 0x0000002542327212ULL, 0x080fe200078e3cffULL,
0x0000001033337824ULL, 0x000fe200078e023cULL, 0x0000001c3e447810ULL, 0x000fe20007ffe0ffULL,
0x0000000842497824ULL, 0x000fe200078e00ffULL, 0x0000002539387212ULL, 0x0c0fe200078e3cffULL,
0x0000000839477824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000c901c46ULL, 0x0000003a3400720cULL, 0x080fe20003f26070ULL,
0x00000008444d7824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee232ULL,
0x000000103f3f7824ULL, 0x100fe200078e023cULL, 0x0000007f34347812ULL, 0x000fe200078ec0ffULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000007f35327812ULL, 0x000fe200078ec0ffULL,
0x0000001043437824ULL, 0x000fe200078e023cULL, 0xfffffff847477812ULL, 0x000fe200078ee238ULL,
0x0000001045457824ULL, 0x000fe200078e023cULL, 0x0000002544387212ULL, 0x000fe200078e3cffULL,
0x0000000134307824ULL, 0x102fe200078e023bULL, 0x000000203e467810ULL, 0x000fe20007ffe0ffULL,
0x0000000132327824ULL, 0x000fe200078e023bULL, 0x0000003a3600720cULL, 0x000fe20003f66070ULL,
0x00005e0030307625ULL, 0x000fe200078e004bULL, 0x0000007f36367812ULL, 0x000fc400078ec0ffULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee238ULL, 0x00000008464f7824ULL, 0x000fe200078e00ffULL,
0x0000003a3500720cULL, 0x080fe20003f46070ULL, 0x00005e0032327625ULL, 0x000fe200078e004bULL,
0x0000007f37387812ULL, 0x040fe400078ec0ffULL, 0x0000002546407212ULL, 0x000fe200078e3cffULL,
0x0000000136347824ULL, 0x100fe200078e023bULL, 0x0000003a3700720cULL, 0x000fe20003f86070ULL,
0x0000000138367824ULL, 0x000fe200078e023bULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee240ULL,
0x00005e0034347625ULL, 0x000fe200078e004bULL, 0x0000007f39407812ULL, 0x000fc400078ec0ffULL,
0x0000003a3900720cULL, 0x000fe20003fa6070ULL, 0x000000103d307825ULL, 0x000fe200078e0030ULL,
0x000000243e487810ULL, 0x000fc60007ffe0ffULL, 0x000000103d327825ULL, 0x040fe200078e0032ULL,
0x00000000303f7faeULL, 0x0003e2000c901c46ULL, 0x0000003a4200720cULL, 0x080fe40003f26070ULL,
0x00005e0036367625ULL, 0x000fe200078e004bULL, 0x0000000032417faeULL, 0x0005e2000d101c46ULL,
0x0000007f42427812ULL, 0x000fe400078ec0ffULL, 0x0000000140387824ULL, 0x000fe200078e023bULL,
0x0000003a4400720cULL, 0x040fe20003f46070ULL, 0x000000103d347825ULL, 0x000fe200078e0034ULL,
0x0000007f44447812ULL, 0x000fc400078ec0ffULL, 0x00000025484a7212ULL, 0x000fe200078e3cffULL,
0x000000103d367825ULL, 0x000fe200078e0036ULL, 0x0000000034437faeULL, 0x0007e2000d901c46ULL,
0x0000003a4600720cULL, 0x080fe40003f66070ULL, 0x00005e0038387625ULL, 0x000fe200078e004bULL,
0x0000007f46467812ULL, 0x000fe200078ec0ffULL, 0x0000000036457faeULL, 0x0009e2000e101c46ULL,
0x0000003a4800720cULL, 0x000fe20003f86070ULL, 0x0000000142307824ULL, 0x102fe200078e023bULL,
0x0000002c3e407810ULL, 0x000fe20007ffe0ffULL, 0x0000000144327824ULL, 0x004fe200078e023bULL,
0x000000343e447810ULL, 0x000fe20007ffe0ffULL, 0x0000000848517824ULL, 0x040fe200078e00ffULL,
0x0000007f48487812ULL, 0x000fe200078ec0ffULL, 0x0000001047477824ULL, 0x000fe200078e023cULL,
0x000000303e427810ULL, 0x000fe20007ffe0ffULL, 0x000000103d387825ULL, 0x000fe200078e0038ULL,
0xfffffff851517812ULL, 0x000fc600078ee24aULL, 0x00005e0030307625ULL, 0x080fe200078e004bULL,
0x0000000038477faeULL, 0x0003e6000e901c46ULL, 0x00005e0032327625ULL, 0x000fc800078e004bULL,
0x0000000146347824ULL, 0x108fe200078e023bULL, 0x000000383e467810ULL, 0x000fe20007ffe0ffULL,
0x0000000148367824ULL, 0x010fe400078e023bULL, 0x00005e0034347625ULL, 0x000fe200078e004bULL,
0x000000283e387810ULL, 0x042fe40007ffe0ffULL, 0x0000003c3e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001049397824ULL, 0x000fe200078e023cULL, 0x0000003a4600720cULL, 0x080fe20003fa6070ULL,
0x000000103d307825ULL, 0x000fe200078e0030ULL, 0x0000003a3e00720cULL, 0x000fc60003fc6070ULL,
0x000000104d3f7824ULL, 0x000fe200078e023cULL, 0x0000000030397faeULL, 0x0003e2000c901c46ULL,
0x000000103d327825ULL, 0x000fe200078e0032ULL, 0x0000003a3800720cULL, 0x000fc60003f26070ULL,
0x00005e0036367625ULL, 0x000fe200078e004bULL, 0x00000000323f7faeULL, 0x0005e2000d101c46ULL,
0x0000003a4000720cULL, 0x000fe40003f46070ULL, 0x000000104f417824ULL, 0x000fe400078e023cULL,
0x000000103d347825ULL, 0x000fe200078e0034ULL, 0x0000002538307212ULL, 0x082fe400078e3cffULL,
0x0000002542317212ULL, 0x080fe200078e3cffULL, 0x0000001051437824ULL, 0x000fe200078e023cULL,
0x0000000034417faeULL, 0x0003e2000d901c46ULL, 0x000000103d367825ULL, 0x000fe200078e0036ULL,
0x0000002544327212ULL, 0x004fc400078e3cffULL, 0x0000003a4200720cULL, 0x080fe20003f66070ULL,
0x00000008383f7824ULL, 0x000fe200078e00ffULL, 0x0000000036437faeULL, 0x0005e2000e101c46ULL,
0x0000000844457824ULL, 0x040fe200078e00ffULL, 0x0000003a4400720cULL, 0x000fe40003f86070ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee230ULL, 0x0000000840417824ULL, 0x042fe200078e00ffULL,
0x0000002540307212ULL, 0x080fe200078e3cffULL, 0x0000000842347824ULL, 0x000fe200078e00ffULL,
0x0000002546337212ULL, 0x040fe200078e3cffULL, 0x000000103f3f7824ULL, 0x000fe200078e023cULL,
0xfffffff841417812ULL, 0x000fe200078ee230ULL, 0x0000000846367824ULL, 0x004fe200078e00ffULL,
0x0000007f3e3a7812ULL, 0x000fc400078ec0ffULL, 0x000000253e357212ULL, 0x040fe200078e3cffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee232ULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000007f38307812ULL, 0x000fe400078ec0ffULL,
0xfffffff834317812ULL, 0x000fe200078ee231ULL, 0x0000001045457824ULL, 0x100fe200078e023cULL,
0x0000007f40327812ULL, 0x000fe200078ec0ffULL, 0x0000000130307824ULL, 0x000fe200078e023bULL,
0xfffffff836337812ULL, 0x000fe200078ee233ULL, 0x0000001031437824ULL, 0x100fe200078e023cULL,
0x0000007f42347812ULL, 0x000fe200078ec0ffULL, 0x0000000132327824ULL, 0x100fe200078e023bULL,
0x0000007f44367812ULL, 0x000fe200078ec0ffULL, 0x0000001033477824ULL, 0x000fe200078e023cULL,
0x0000007f46387812ULL, 0x000fe200078ec0ffULL, 0x0000000134347824ULL, 0x000fe200078e023bULL,
0xfffffff83e357812ULL, 0x000fe200078ee235ULL, 0x0000000136367824ULL, 0x000fc400078e023bULL,
0x0000000138387824ULL, 0x000fe400078e023bULL, 0x00005e0030307625ULL, 0x000fc800078e004bULL,
0x000000013a3b7824ULL, 0x000fe400078e023bULL, 0x0000001035497824ULL, 0x000fe400078e023cULL,
0x00005e0032327625ULL, 0x000fc800078e004bULL, 0x00005e0034347625ULL, 0x000fc800078e004bULL,
0x00005e0036367625ULL, 0x000fc800078e004bULL, 0x00005e0038387625ULL, 0x000fc800078e004bULL,
0x00005e003b3a7625ULL, 0x000fc800078e004bULL, 0x000000103d307825ULL, 0x000fc800078e0030ULL,
0x000000103d327825ULL, 0x040fe200078e0032ULL, 0x00000000303f7faeULL, 0x0003e6000c901c46ULL,
0x000000103d347825ULL, 0x040fe200078e0034ULL, 0x0000000032417faeULL, 0x0003e6000d101c46ULL,
0x000000103d367825ULL, 0x040fe200078e0036ULL, 0x0000000034437faeULL, 0x0003e6000d901c46ULL,
0x000000103d387825ULL, 0x040fe200078e0038ULL, 0x0000000036457faeULL, 0x0003e6000e101c46ULL,
0x000000103d3a7825ULL, 0x000fe200078e003aULL, 0x0000000038477faeULL, 0x0003e8000e901c46ULL,
0x000000003a497faeULL, 0x0003e2000f101c46ULL, 0x00000a8000007947ULL, 0x000fea0003800000ULL,
0x00000003ff307819ULL, 0x004fe20000011625ULL, 0x000000084e787824ULL, 0x000fc400078e00ffULL,
0x00000100ff4c7424ULL, 0x000fe200078e00ffULL, 0x0000000430367810ULL, 0x040fe40007ffe0ffULL,
0x0000000c303e7810ULL, 0x000fe40007ffe0ffULL, 0x0000002536327212ULL, 0x0c0fe200078e3cffULL,
0x0000000836357824ULL, 0x000fe200078e00ffULL, 0x0000001430467810ULL, 0x000fe20007ffe0ffULL,
0x000000083e377824ULL, 0x000fe200078e00ffULL, 0x00000008303a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff835387812ULL, 0x000fe200078ee232ULL, 0x0000000846397824ULL, 0x000fe200078e00ffULL,
0x000000253e327212ULL, 0x000fe200078e3cffULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0x0000001c30527810ULL, 0x000fc40007ffe0ffULL, 0x0000002546347212ULL, 0x080fe400078e3cffULL,
0x00000024305a7810ULL, 0x040fe40007ffe0ffULL, 0x0000001030427810ULL, 0x040fe40007ffe0ffULL,
0x00000018304a7810ULL, 0x000fe40007ffe0ffULL, 0x000000253a337212ULL, 0x080fe200078e3cffULL,
0x0000000842447824ULL, 0x000fe200078e00ffULL, 0xfffffff837407812ULL, 0x000fe200078ee232ULL,
0x0000000852377824ULL, 0x000fe200078e00ffULL, 0xfffffff839487812ULL, 0x000fe200078ee234ULL,
0x000000085a397824ULL, 0x000fe200078e00ffULL, 0x0000002552327212ULL, 0x000fe200078e3cffULL,
0x000000084a507824ULL, 0x000fe200078e00ffULL, 0x0000002c30627810ULL, 0x000fc40007ffe0ffULL,
0x000000255a347212ULL, 0x080fe400078e3cffULL, 0x00000034306a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee233ULL, 0x0000002030567810ULL, 0x040fe40007ffe0ffULL,
0x00000028305e7810ULL, 0x000fe40007ffe0ffULL, 0x0000002542337212ULL, 0x080fe200078e3cffULL,
0x0000000856587824ULL, 0x000fe200078e00ffULL, 0x000000254a357212ULL, 0x080fe200078e3cffULL,
0x000000085e607824ULL, 0x000fe200078e00ffULL, 0xfffffff837547812ULL, 0x000fe200078ee232ULL,
0x0000000862377824ULL, 0x000fe200078e00ffULL, 0xfffffff8395c7812ULL, 0x000fe200078ee234ULL,
0x000000086a397824ULL, 0x000fe200078e00ffULL, 0x0000002562327212ULL, 0x000fc400078e3cffULL,
0xfffffff844447812ULL, 0x000fe400078ee233ULL, 0xfffffff850507812ULL, 0x000fe400078ee235ULL,
0x0000003030667810ULL, 0x040fe40007ffe0ffULL, 0x00000038306e7810ULL, 0x000fe40007ffe0ffULL,
0x000000256a347212ULL, 0x080fe200078e3cffULL, 0x0000000866687824ULL, 0x000fe200078e00ffULL,
0x0000002556337212ULL, 0x080fe200078e3cffULL, 0x000000086e767824ULL, 0x000fe200078e00ffULL,
0x000000255e357212ULL, 0x000fc400078e3cffULL, 0xfffffff837647812ULL, 0x000fe200078ee232ULL,
0x0000000400327c24ULL, 0x000fe2000f8e0231ULL, 0xfffffff8396c7812ULL, 0x000fe400078ee234ULL,
0xfffffff858587812ULL, 0x000fe400078ee233ULL, 0xfffffff860607812ULL, 0x000fe400078ee235ULL,
0x0000000730347812ULL, 0x040fe400078e4825ULL, 0x0000007f30317812ULL, 0x000fc400078ec0ffULL,
0x0000002566337212ULL, 0x080fe400078e3cffULL, 0x000000256e357212ULL, 0x000fe200078e3cffULL,
0x0000000131317824ULL, 0x000fe200078e0232ULL, 0x0000003c30307810ULL, 0x000fe40007ffe0ffULL,
0xfffffff868687812ULL, 0x000fe200078ee233ULL, 0x0000000274337824ULL, 0x000fe200078e0229ULL,
0xfffffff876767812ULL, 0x000fe200078ee235ULL, 0x0000000830577824ULL, 0x000fe200078e00ffULL,
0x0000007f36357812ULL, 0x000fc400078ec0ffULL, 0x0000002530367212ULL, 0x000fe400078e3cffULL,
0x0000007f3a377812ULL, 0x000fe200078ec0ffULL, 0x0000000135357824ULL, 0x100fe200078e0232ULL,
0x0000007f3e397812ULL, 0x000fe400078ec0ffULL, 0x0000007f5e477812ULL, 0x000fe200078ec0ffULL,
0x0000000137377824ULL, 0x100fe200078e0232ULL, 0x0000007f6a517812ULL, 0x000fe200078ec0ffULL,
0x0000000139397824ULL, 0x100fe200078e0232ULL, 0x0000007f6e537812ULL, 0x000fe200078ec0ffULL,
0x0000000147497824ULL, 0x000fe200078e0232ULL, 0x0000007f30557812ULL, 0x000fe200078ec0ffULL,
0x00005e0031307625ULL, 0x000fe200078e004cULL, 0x0000200033337811ULL, 0x000fc400078e68ffULL,
0x0ffffff834347812ULL, 0x100fe200078ef825ULL, 0x0000000151697824ULL, 0x100fe200078e0232ULL,
0x0000007f423b7812ULL, 0x000fe200078ec0ffULL, 0x00000001536d7824ULL, 0x100fe200078e0232ULL,
0x0000007f463d7812ULL, 0x000fe200078ec0ffULL, 0x0000000155717824ULL, 0x100fe200078e0232ULL,
0x0000007f4a3f7812ULL, 0x000fe200078ec0ffULL, 0x000000013b3b7824ULL, 0x100fe200078e0232ULL,
0x0000007f52417812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x100fe200078e0232ULL,
0x0000007f56437812ULL, 0x000fe200078ec0ffULL, 0x000000013f3f7824ULL, 0x100fe200078e0232ULL,
0x0000007f5a457812ULL, 0x000fe200078ec0ffULL, 0x0000000141417824ULL, 0x100fe200078e0232ULL,
0x0000007f624b7812ULL, 0x000fe200078ec0ffULL, 0x0000000143437824ULL, 0x100fe200078e0232ULL,
0x0000007f664d7812ULL, 0x000fe200078ec0ffULL, 0x0000000145457824ULL, 0x000fe200078e0232ULL,
0xfffffff857367812ULL, 0x000fe200078ee236ULL, 0x000000014b4b7824ULL, 0x100fe200078e0232ULL,
0xfffffff8784f7812ULL, 0x000fe200078ee225ULL, 0x000000014d4d7824ULL, 0x000fc400078e0232ULL,
0x0000001034477824ULL, 0x100fe400078e0233ULL, 0x0000001038517824ULL, 0x100fe400078e0233ULL,
0x000000103c537824ULL, 0x100fe400078e0233ULL, 0x0000001040557824ULL, 0x100fe400078e0233ULL,
0x0000001044577824ULL, 0x100fe400078e0233ULL, 0x0000001048597824ULL, 0x000fc400078e0233ULL,
0x00000010505b7824ULL, 0x100fe400078e0233ULL, 0x00000010545d7824ULL, 0x100fe400078e0233ULL,
0x00000010585f7824ULL, 0x100fe400078e0233ULL, 0x000000105c617824ULL, 0x100fe400078e0233ULL,
0x0000001060637824ULL, 0x100fe400078e0233ULL, 0x0000001064657824ULL, 0x000fc400078e0233ULL,
0x0000001068677824ULL, 0x100fe400078e0233ULL, 0x000000106c6b7824ULL, 0x100fe400078e0233ULL,
0x00000010766f7824ULL, 0x100fe400078e0233ULL, 0x0000001036777824ULL, 0x000fe400078e0233ULL,
0x00005e0035327625ULL, 0x000fc800078e004cULL, 0x00005e0037347625ULL, 0x000fc800078e004cULL,
0x00005e0039367625ULL, 0x000fc800078e004cULL, 0x00005e003b387625ULL, 0x000fc800078e004cULL,
0x000000104f307825ULL, 0x000fc800078e0030ULL, 0x00005e003d3a7625ULL, 0x080fe200078e004cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030477faeULL, 0x0003e6000b901c46ULL,
0x00005e003f3c7625ULL, 0x000fc800078e004cULL, 0x00005e00413e7625ULL, 0x000fc800078e004cULL,
0x000000104f327825ULL, 0x000fc800078e0032ULL, 0x00005e0043407625ULL, 0x000fe200078e004cULL,
0x0000000032517faeULL, 0x0005e6000b901c46ULL, 0x000000104f347825ULL, 0x000fc800078e0034ULL,
0x00005e0045427625ULL, 0x000fe200078e004cULL, 0x0000000034537faeULL, 0x0005e6000b901c46ULL,
0x000000104f367825ULL, 0x000fc800078e0036ULL, 0x00005e0049447625ULL, 0x000fe200078e004cULL,
0x0000000036557faeULL, 0x0005e6000b901c46ULL, 0x000000104f387825ULL, 0x000fc800078e0038ULL,
0x00005e004b307625ULL, 0x002fe200078e004cULL, 0x0000000038577faeULL, 0x0005e6000b901c46ULL,
0x000000104f3a7825ULL, 0x000fc800078e003aULL, 0x00005e004d467625ULL, 0x000fe200078e004cULL,
0x000000003a597faeULL, 0x0005e6000b901c46ULL, 0x000000104f3c7825ULL, 0x000fc800078e003cULL,
0x00005e0069487625ULL, 0x000fe200078e004cULL, 0x000000003c5b7faeULL, 0x0005e6000b901c46ULL,
0x000000104f3e7825ULL, 0x000fc800078e003eULL, 0x00005e006d4a7625ULL, 0x000fe200078e004cULL,
0x000000003e5d7faeULL, 0x0005e6000b901c46ULL, 0x000000104f407825ULL, 0x000fc800078e0040ULL,
0x00005e00714c7625ULL, 0x000fe200078e004cULL, 0x00000000405f7faeULL, 0x0005e6000b901c46ULL,
0x000000104f427825ULL, 0x000fc800078e0042ULL, 0x000000104f447825ULL, 0x040fe200078e0044ULL,
0x0000000042617faeULL, 0x0005e6000b901c46ULL, 0x000000104f307825ULL, 0x040fe200078e0030ULL,
0x0000000044637faeULL, 0x0005e6000b901c46ULL, 0x000000104f467825ULL, 0x040fe200078e0046ULL,
0x0000000030657faeULL, 0x0005e6000b901c46ULL, 0x000000104f487825ULL, 0x040fe200078e0048ULL,
0x0000000046677faeULL, 0x0005e6000b901c46ULL, 0x000000104f4a7825ULL, 0x040fe200078e004aULL,
0x00000000486b7faeULL, 0x0005e6000b901c46ULL, 0x000000104f4c7825ULL, 0x000fe200078e004cULL,
0x000000004a6f7faeULL, 0x0005e8000b901c46ULL, 0x000000004c777faeULL, 0x0005e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4e00720cULL, 0x000fe20003f25270ULL,
0x000000b000007945ULL, 0x000fd80003800000ULL, 0x0000009000009947ULL, 0x000fea0003800000ULL,
0x00000300ff007624ULL, 0x000fc800078e00ffULL, 0x0000000200037824ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fc600078e00ffULL, 0x000000720300720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000228307824ULL, 0x006fe400078e0203ULL,
0x00000004ff317424ULL, 0x000fc800078e00ffULL, 0x0000600030307625ULL, 0x000fca00078e0031ULL,
0x0000000630007981ULL, 0x000364000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002025407810ULL, 0x044fe20007ffe0ffULL,
0x00000002743d7824ULL, 0x000fe200078e022fULL, 0x00000007253c7812ULL, 0x040fe200078ec0ffULL,
0x000000102e2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8253e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe400078ec0ffULL,
0x000020003d3d7811ULL, 0x000fe400078e68ffULL, 0x000000083c3c7812ULL, 0x000fc400078ef825ULL,
0x000000073e3e7812ULL, 0x100fe400078ef825ULL, 0x0000000740407812ULL, 0x000fe200078ef825ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000072f317812ULL, 0x042fe200078e783eULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000072f357812ULL, 0x040fe400078e7840ULL,
0x000000012f457810ULL, 0x040fe20007ffe0ffULL, 0x000000083e307824ULL, 0x000fe200078e0231ULL,
0x000000022f2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000840347824ULL, 0x000fc400078e0235ULL,
0x0000001030307824ULL, 0x100fe200078e023dULL, 0x000000082f00780cULL, 0x000fe20003f25270ULL,
0x0000001034347824ULL, 0x000fc800078e023dULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000018ff387819ULL, 0x002fe20000011430ULL,
0x00010000313b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011431ULL,
0x00000018ff3a7819ULL, 0x000fe20000011432ULL, 0x00000038004a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff447819ULL, 0x000fe20000011433ULL, 0x0001000037467824ULL, 0x004fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc4000001143bULL, 0x00000018ff437819ULL, 0x000fe40000011434ULL,
0x00000018ff427819ULL, 0x000fe20000011435ULL, 0x00000039004e7306ULL, 0x0005e20000200c00ULL,
0x0000888030387816ULL, 0x042fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011436ULL,
0x00000018ff3f7819ULL, 0x000fe40000011437ULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000003a00527306ULL, 0x0003e20000200c00ULL, 0x0001000030397824ULL, 0x004fc400078e00ffULL,
0x0000010030307824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003800487306ULL, 0x0005e20000200c00ULL,
0x00008880313a7816ULL, 0x042fe200000000ffULL, 0x0000010031317824ULL, 0x000fca00078e00ffULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x00000030004d7306ULL, 0x0003e20000200c00ULL,
0x0000888032387816ULL, 0x004fce00000000ffULL, 0x00000039004b7306ULL, 0x0005e20000200c00ULL,
0x0001000032307824ULL, 0x042fe400078e00ffULL, 0x0000010032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100517306ULL, 0x0003e20000200c00ULL,
0x0000888033397816ULL, 0x004fe400000000ffULL, 0x00000018ff327819ULL, 0x000fca0000011432ULL,
0x0000003200557306ULL, 0x0005e20000200c00ULL, 0x0001000033317824ULL, 0x042fe400078e00ffULL,
0x0000010033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0001000034327824ULL, 0x004fe200078e00ffULL,
0x0000003000537306ULL, 0x0003e80000200c00ULL, 0x00000018ff327819ULL, 0x000fc80000011432ULL,
0x0000003300597306ULL, 0x0005e20000200c00ULL, 0x0000888034307816ULL, 0x042fe200000000ffULL,
0x0000010034347824ULL, 0x000fca00078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000003800507306ULL, 0x0002e20000200c00ULL, 0x0000000745337812ULL, 0x044fe400078e783eULL,
0x0000000745457812ULL, 0x000fca00078e7840ULL, 0x0000003100577306ULL, 0x0005e20000200c00ULL,
0x000000083e387824ULL, 0x002fc800078e0233ULL, 0x0000001038387824ULL, 0x000fc600078e023dULL,
0x0000003000567306ULL, 0x0003e20000200c00ULL, 0x0000888035317816ULL, 0x004fe400000000ffULL,
0x0000541050507816ULL, 0x008fca0000000053ULL, 0x00000032005b7306ULL, 0x0004e20000200c00ULL,
0x0001000035307824ULL, 0x042fe400078e00ffULL, 0x0000010035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000031005a7306ULL, 0x0003e20000200c00ULL,
0x0000000840327824ULL, 0x004fe200078e0245ULL, 0x00000018ff357819ULL, 0x000fc60000011435ULL,
0x0000001032327824ULL, 0x000fc600078e023dULL, 0x0000003a004c7306ULL, 0x000fe20000200c00ULL,
0x0001000036317824ULL, 0x002fe200078e00ffULL, 0x0000541056567816ULL, 0x008fc8000000005bULL,
0x00000018ff457819ULL, 0x000fe40000011431ULL, 0x0000003b004f7306ULL, 0x000e700000200c00ULL,
0x0000003900547306ULL, 0x0004f00000200c00ULL, 0x00000030005d7306ULL, 0x0008e20000200c00ULL,
0x000000003838783bULL, 0x004ea20000000200ULL, 0x000054104c4c7816ULL, 0x002fcc000000004fULL,
0x0000003400587306ULL, 0x0003e20000200c00ULL, 0x000000003230783bULL, 0x010f220000000200ULL,
0x0000541054547816ULL, 0x008fcc0000000057ULL, 0x00000035005f7306ULL, 0x0007e20000200c00ULL,
0x0000888036347816ULL, 0x042fe200000000ffULL, 0x0000010036367824ULL, 0x000fe200078e00ffULL,
0x000054105a5a7816ULL, 0x000fc8000000005dULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x00000034005c7306ULL, 0x000fe20000200c00ULL, 0x0000888037357816ULL, 0x048fe200000000ffULL,
0x0000010037377824ULL, 0x000fca00078e00ffULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000003500607306ULL, 0x0005f00000200c00ULL, 0x00000036005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff357819ULL, 0x004fe2000001143bULL, 0x000100003a6c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc40000011438ULL, 0x0000888039687816ULL, 0x000fe400000000ffULL,
0x000088803b717816ULL, 0x000fe200000000ffULL, 0x0000003500777306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x010fe40000011430ULL, 0x00000018ff367819ULL, 0x002fe40000011439ULL,
0x00008880307a7816ULL, 0x000fe400000000ffULL, 0x00000018ff477819ULL, 0x000fe20000011431ULL,
0x0000004900797306ULL, 0x0003e20000200c00ULL, 0x0001000038357824ULL, 0x004fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fcc000001146cULL, 0x00000036006a7306ULL, 0x0005e20000200c00ULL,
0x0000002e25497211ULL, 0x002fe400078fe0ffULL, 0x000000042e2e7810ULL, 0x000fca0007ffe0ffULL,
0x0000003400667306ULL, 0x0003e20000200c00ULL, 0x00000018ff367819ULL, 0x004fe40000011435ULL,
0x0000000749357812ULL, 0x040fe400078e783cULL, 0x0000000249497810ULL, 0x000fc60007ffe0ffULL,
0x000000203c357824ULL, 0x000fe200078e0235ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000004500617306ULL, 0x0002a20000200c00ULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000000749497812ULL, 0x000fe200078e783cULL, 0x0000001035357824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x000000203c497824ULL, 0x000fe200078e0249ULL,
0x0000003700627306ULL, 0x0007e20000200c00ULL, 0x00000018ff457819ULL, 0x002fce000001143aULL,
0x0000003400647306ULL, 0x0003e20000200c00ULL, 0x00000018ff377819ULL, 0x008fe40000011433ULL,
0x000054105c5c7816ULL, 0x004fca0000000061ULL, 0x00000045006e7306ULL, 0x000fe20000200c00ULL,
0x0001000039347824ULL, 0x042fe400078e00ffULL, 0x0000010039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff697819ULL, 0x000fe40000011434ULL, 0x0000003700457306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000003600657306ULL, 0x0002b00000200c00ULL,
0x00000039006b7306ULL, 0x0007e20000200c00ULL, 0x000000003534783bULL, 0x002e6e0000000200ULL,
0x0000003800677306ULL, 0x0009220000200c00ULL, 0x000100003b397824ULL, 0x048fe200078e00ffULL,
0x0000541064647816ULL, 0x004fe20000000065ULL, 0x000001003b3b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x000088803a387816ULL, 0x050fe200000000ffULL, 0x000001003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc8000001143bULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x00000038006d7306ULL, 0x0007e20000200c00ULL, 0x0000541067657816ULL, 0x000fce0000000066ULL,
0x0000003900767306ULL, 0x0009e20000200c00ULL, 0x0000541048387816ULL, 0x008fce000000004bULL,
0x0000004300437306ULL, 0x000ee20000200c00ULL, 0x000054104d397816ULL, 0x010fe4000000004aULL,
0x00005410514d7816ULL, 0x000fe4000000004eULL, 0x0000541055517816ULL, 0x000fe40000000052ULL,
0x0000541059557816ULL, 0x004fe20000000044ULL, 0x0000004200427306ULL, 0x000ea20000200c00ULL,
0x000000383404723cULL, 0x042fee0000001804ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000000ffff387224ULL, 0x000fe200078e007aULL, 0x0000541058577816ULL, 0x008fe20000000043ULL,
0x0000010031437824ULL, 0x000fe200078e00ffULL, 0x0000004c3408723cULL, 0x000fe80000001808ULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x000054105f5b7816ULL, 0x004fc40000000042ULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000050340c723cULL, 0x000fe8000000180cULL,
0x0000004600637306ULL, 0x0005220000200c00ULL, 0x000054105e5d7816ULL, 0x002fc60000000041ULL,
0x000000543410723cULL, 0x040fe80000001810ULL, 0x0000003a006f7306ULL, 0x0003e20000200c00ULL,
0x0000541062617816ULL, 0x008fe4000000003fULL, 0x00000018ff467819ULL, 0x004fe20000011432ULL,
0x000000563414723cULL, 0x040fe80000001814ULL, 0x00000038004a7306ULL, 0x0005e20000200c00ULL,
0x00010000303a7824ULL, 0x002fe200078e00ffULL, 0x0000541060607816ULL, 0x010fe20000000063ULL,
0x0000010030307824ULL, 0x000fe200078e00ffULL, 0x0000005a3418723cULL, 0x000fe40000001818ULL,
0x00000018ff487819ULL, 0x000fc4000001143aULL, 0x0000003b00787306ULL, 0x0002e20000200c00ULL,
0x0000001049387824ULL, 0x004fe200078e00ffULL, 0x0000888031497816ULL, 0x000fe400000000ffULL,
0x0000005c341c723cULL, 0x000fe2000000181cULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x000000ffff447224ULL, 0x000fe200078e0049ULL, 0x00000048004b7306ULL, 0x0005220000200c00ULL,
0x000000003838783bULL, 0x002e620000000200ULL, 0x0000888032497816ULL, 0x000fc400000000ffULL,
0x000000603420723cULL, 0x000fe60000001820ULL, 0x000000ffff417224ULL, 0x000fe200078e0049ULL,
0x0000003000307306ULL, 0x000f220000200c00ULL, 0x0001000031487824ULL, 0x004fe200078e00ffULL,
0x0000541078777816ULL, 0x008fe20000000077ULL, 0x0001000033357824ULL, 0x040fe200078e00ffULL,
0x0000888033347816ULL, 0x040fe200000000ffULL, 0x0000010033337824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc40000011448ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x000054104a4a7816ULL, 0x010fe4000000004bULL, 0x00005410304b7816ULL, 0x000fc60000000079ULL,
0x0000004800317306ULL, 0x0005f00000200c00ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x0001000032487824ULL, 0x044fe400078e00ffULL, 0x0000010032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011448ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000000643804723cULL, 0x002fe20000001804ULL,
0x0000541068687816ULL, 0x008fcc0000000069ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x000054106b697816ULL, 0x000fe2000000006aULL, 0x0000004a3814723cULL, 0x040fec0000001814ULL,
0x0000003200497306ULL, 0x000fe20000200c00ULL, 0x000054106d6c7816ULL, 0x004fe2000000006cULL,
0x000000683808723cULL, 0x000fe20000001808ULL, 0x000054106f6d7816ULL, 0x000fca000000006eULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x0000541044307816ULL, 0x002fe20000000031ULL,
0x0000006c380c723cULL, 0x000fec000000180cULL, 0x0000003500357306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000ff00000200c00ULL, 0x0000004600467306ULL, 0x000ea20000200c00ULL,
0x0000541034347816ULL, 0x002fce0000000035ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x0000004300427306ULL, 0x000ee20000200c00ULL, 0x0000541049497816ULL, 0x004fce0000000046ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541071767816ULL, 0x002fce0000000076ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000541042317816ULL, 0x008fe20000000047ULL,
0x000000763810723cULL, 0x040fec0000001810ULL, 0x0000003300327306ULL, 0x000ea40000200c00ULL,
0x000000303818723cULL, 0x000fe20000001818ULL, 0x0000541041487816ULL, 0x002fce0000000048ULL,
0x00000048381c723cULL, 0x000fe2000000181cULL, 0x0000541032357816ULL, 0x004fce0000000045ULL,
0x000000343820723cULL, 0x000fe20000001820ULL, 0xfffff0d000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff2f7224ULL, 0x000fe200078e0029ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffd7c000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x01c61400272d7984ULL, 0x000e620000000800ULL,
0x00000004262e7220ULL, 0x040fe20000410000ULL, 0x0000ffff2b047812ULL, 0x000fe200078ec0ffULL,
0x0000001226357220ULL, 0x040fe40000410000ULL, 0x0000001326367220ULL, 0x000fe20000410000ULL,
0x00008880043d7816ULL, 0x000fe200000000ffULL, 0x0000001426127220ULL, 0x040fe40000410000ULL,
0x0000001526137220ULL, 0x000fc40000410000ULL, 0x800000003d047824ULL, 0x000fe400078e00ffULL,
0x00000006262f7220ULL, 0x040fe40000410000ULL, 0x0000000726307220ULL, 0x040fe40000410000ULL,
0x0000000a26317220ULL, 0x040fe40000410000ULL, 0x0000000b26327220ULL, 0x040fe40000410000ULL,
0x0000001826147220ULL, 0x000fc40000410000ULL, 0x0000001926157220ULL, 0x040fe40000410000ULL,
0x0000000526057220ULL, 0x040fe40000410000ULL, 0x0000000826087220ULL, 0x040fe40000410000ULL,
0x0000000926097220ULL, 0x040fe40000410000ULL, 0x0000000c26067220ULL, 0x040fe40000410000ULL,
0x0000000d26077220ULL, 0x000fc40000410000ULL, 0x0000000e26337220ULL, 0x040fe40000410000ULL,
0x0000000f26347220ULL, 0x040fe40000410000ULL, 0x0000001626377220ULL, 0x040fe20000410000ULL,
0x800000002dff7812ULL, 0x002fe20007804804ULL, 0x0000001726387220ULL, 0x040fe40000410000ULL,
0x0000001a26187220ULL, 0x040fe40000410000ULL, 0x0000001b26197220ULL, 0x000fc40000410000ULL,
0x0000001e26397220ULL, 0x040fe40000410000ULL, 0x0000001f263a7220ULL, 0x040fe40000410000ULL,
0x0000001c26167220ULL, 0x040fe40000410000ULL, 0x0000001d26177220ULL, 0x040fe40000410000ULL,
0x00000020261a7220ULL, 0x040fe40000410000ULL, 0x00000021261b7220ULL, 0x000fc40000410000ULL,
0x00000022263b7220ULL, 0x040fe40000410000ULL, 0x00000023263c7220ULL, 0x000fe40000410000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e002eULL, 0x000000ffff1c7224ULL, 0x000fe400078e002fULL,
0x000000ffff1d7224ULL, 0x000fe400078e0030ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0031ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0032ULL, 0x0000001026107220ULL, 0x040fe40000410000ULL,
0x0000001126117220ULL, 0x000fe40000410000ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff207224ULL, 0x000fe400078e0033ULL, 0x000000ffff217224ULL, 0x000fe400078e0034ULL,
0x000000ffff227224ULL, 0x000fe400078e0035ULL, 0x000000ffff237224ULL, 0x000fc400078e0036ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0037ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0038ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0018ULL, 0x000000ffff307224ULL, 0x000fe400078e0019ULL,
0x000000ffff317224ULL, 0x000fe400078e0039ULL, 0x000000ffff327224ULL, 0x000fe200078e003aULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff337224ULL, 0x000fc400078e003bULL, 0x000000ffff347224ULL, 0x000fe200078e003cULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000003d067824ULL, 0x000fe400078e00ffULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01c6140027057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804806ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000425197824ULL, 0x000fe200078e00ffULL,
0x0000002a7500720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff019057812ULL, 0x000fca00078ec0ffULL, 0x0000008074187824ULL, 0x000fca00078e0205ULL,
0x01c4000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000225087824ULL, 0x000fe400078e00ffULL, 0x00000001732c7824ULL, 0x000fc600078e0a2cULL,
0x0000000608097812ULL, 0x000fc800078ec0ffULL, 0x0000000109357812ULL, 0x040fe400078efcffULL,
0x0000000809377812ULL, 0x000fe400078efcffULL, 0x0000002c3500720cULL, 0x080fe40003f26070ULL,
0x0000001009357812ULL, 0x000fe400078efcffULL, 0x0000002c3700720cULL, 0x080fe40003f06070ULL,
0x0000002c3500720cULL, 0x000fc40003fc6070ULL, 0x0000001109377812ULL, 0x040fe400078efcffULL,
0x0000001809357812ULL, 0x040fe400078efcffULL, 0x0000002c0900720cULL, 0x080fe40003f46070ULL,
0x0000002c3700720cULL, 0x080fe40003fa6070ULL, 0x0000002c3500720cULL, 0x000fe40003f66070ULL,
0x0000000909397812ULL, 0x000fc400078efcffULL, 0x0000001909377812ULL, 0x040fe400078efcffULL,
0x0000002009357812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0b0b7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff0a0a7808ULL, 0x000fc40004800000ULL, 0x0000002c3900720cULL, 0x080fe40003f86070ULL,
0x0000002c3700720cULL, 0x080fe40003f46070ULL, 0x0000002c3500720cULL, 0x000fe40003f26070ULL,
0x0000002109377812ULL, 0x040fe400078efcffULL, 0x0000002809357812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002c3700720cULL, 0x080fe40003f06070ULL, 0x0000002c3500720cULL, 0x000fe40003f86070ULL,
0x0000002909377812ULL, 0x000fc400078efcffULL, 0x0000003009357812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002c3700720cULL, 0x000fc40003fc6070ULL, 0x0000002c3500720cULL, 0x000fe40003fa6070ULL,
0x0000003109377812ULL, 0x040fe400078efcffULL, 0x0000003809357812ULL, 0x040fe400078efcffULL,
0x0000003909097812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002c3700720cULL, 0x080fe40003f66070ULL,
0x0000002c3500720cULL, 0x000fc40003f46070ULL, 0x0000002c0900720cULL, 0x000fe40003f26070ULL,
0xff7fffff2e2e7808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff30307808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff32327808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff33337808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff34347808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000b04097209ULL, 0x004fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000000a09097209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fc40007810000ULL, 0x0000000c09047209ULL, 0x000fe40007810000ULL,
0x0000001e05087209ULL, 0x000fe40007810000ULL, 0x0000000d04057209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x0000000e05047209ULL, 0x000fe40007810000ULL,
0x0000002009087209ULL, 0x000fc40007810000ULL, 0x0000000f04057209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fe40007810000ULL, 0x0000001005047209ULL, 0x000fe40007810000ULL,
0x0000002209087209ULL, 0x000fe40007810000ULL, 0x0000001104057209ULL, 0x000fe40007810000ULL,
0x0000002308087209ULL, 0x000fc40007810000ULL, 0x0000001205047209ULL, 0x000fe40007810000ULL,
0x0000002d08057209ULL, 0x000fe40007810000ULL, 0x0000001304097209ULL, 0x000fe40007810000ULL,
0x0000002e05047209ULL, 0x000fe40007810000ULL, 0x0000001409087209ULL, 0x000fe40007810000ULL,
0x0000002f04057209ULL, 0x000fc40007810000ULL, 0x0000001508097209ULL, 0x000fe40007810000ULL,
0x0000003005047209ULL, 0x000fe40007810000ULL, 0x0000001609087209ULL, 0x000fe40007810000ULL,
0x0000003104057209ULL, 0x000fe40007810000ULL, 0x0000001708097209ULL, 0x000fe40007810000ULL,
0x0000003205047209ULL, 0x000fc40007810000ULL, 0x0000001a09087209ULL, 0x000fe40007810000ULL,
0x0000003304057209ULL, 0x000fe40007810000ULL, 0x0000001b08377209ULL, 0x000fe40007810000ULL,
0x0000003405387209ULL, 0x000fe20007810000ULL, 0x00000da27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037047f89ULL, 0x0004e400000e0000ULL, 0x0000000437377209ULL, 0x00cfe20007810000ULL,
0x00000df27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038047f89ULL, 0x000ea800000e0000ULL,
0x0c401f0006057f89ULL, 0x000ee800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x0000000438087209ULL, 0x004fc60007810000ULL, 0x0c201f0037047f89ULL, 0x000ea200000e0000ULL,
0x0000000506097209ULL, 0x008fc60007810000ULL, 0x0c201f0008057f89ULL, 0x000ee200000e0000ULL,
0x0000002c072c7209ULL, 0x010fc60007810000ULL, 0x0c201f0009367f89ULL, 0x002e6800000e0000ULL,
0x0c201f002c357f89ULL, 0x00092200000e0000ULL, 0x0000000437047209ULL, 0x004fe40007810000ULL,
0x0000000508057209ULL, 0x008fe40007810000ULL, 0x0000003609067209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b04077820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff377424ULL, 0x000fe200078e00ffULL, 0x0000000000087886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x0000000b00087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x0000000a00097308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b11117823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b17177823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1b077823ULL, 0x000fe20000010807ULL,
0x000000080908723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b051b7820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081bULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081bULL,
0x0000001e000b7308ULL, 0x000fe20000000800ULL, 0x0000000c0d0a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b21217823ULL, 0x000fc4000001081bULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001081bULL, 0x0000001f00367308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081bULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x000fc4000001081bULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001081bULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001081bULL,
0x3fb8aa3b341b7823ULL, 0x000fe2000001081bULL, 0x0000001d001d7308ULL, 0x000ee20000000800ULL,
0x0000000b360b723eULL, 0x002fe200000000ffULL, 0x3c003c00ff367424ULL, 0x000fcc00078e00ffULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0x0000001c1d09723eULL, 0x008fce00000000ffULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x00000036081c723cULL, 0x000fe200000018ffULL,
0x0000000e0f0c723eULL, 0x002fcc00000000ffULL, 0x0000001100117308ULL, 0x000e700000000800ULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ee20000000800ULL,
0x00000010110e723eULL, 0x002fce00000000ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x00000020210d723eULL, 0x008fce00000000ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x00000022230f723eULL, 0x002fce00000000ffULL,
0x0000001300137308ULL, 0x000e620000000800ULL, 0x000000360c1c723cULL, 0x000fee000000181cULL,
0x0000001400147308ULL, 0x000ff00000000800ULL, 0x0000001500157308ULL, 0x000ee20000000800ULL,
0x000000121310723eULL, 0x002fce00000000ffULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x000000141512723eULL, 0x008fe400000000ffULL,
0xfffffffc25147812ULL, 0x000fca00078ec0ffULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ee20000000800ULL, 0x0000002d2e11723eULL, 0x002fe200000000ffULL,
0x0000000fff2d7424ULL, 0x000fca00078e00ffULL, 0x000000142d2d7219ULL, 0x000fe200000006ffULL,
0x0000001600167308ULL, 0x000fe60000000800ULL, 0x000000002d0573c4ULL, 0x000e620000004000ULL,
0x0000002f3013723eULL, 0x008fc800000000ffULL, 0x0000001700177308ULL, 0x000ee60000000800ULL,
0x000000361020723cULL, 0x000fe2000000181cULL, 0x000000002d1e73a1ULL, 0x000f2800000e8000ULL,
0x0000001a001a7308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ea20000000800ULL,
0x000000161714723eULL, 0x008fce00000000ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000082dff7c12ULL, 0x010fce000f80401eULL, 0x0000003200327308ULL, 0x000ee20000000800ULL,
0x0000001a0716723eULL, 0x004fe400000000ffULL, 0x0000002c35077209ULL, 0x000fca0007810000ULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000001b001c7308ULL, 0x000ea20000000800ULL,
0x000000313215723eULL, 0x008fe400000000ffULL, 0x000000331c17723eULL, 0x004fce00000000ffULL,
0x000000361430723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000a0205008947ULL, 0x002fde000b800000ULL, 0x001c1fff301c7589ULL, 0x0002a400000e0000ULL,
0x000000002d1a73a1ULL, 0x000ee200000e8000ULL, 0x000000002d0573c4ULL, 0x000f220000004000ULL,
0x0000000000087886ULL, 0x000fe400038e0100ULL, 0x000000082dff7c12ULL, 0x008fda000f80401aULL,
0x00000a1205008947ULL, 0x010fea000b800000ULL, 0x001c1fff321d7589ULL, 0x00072800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL, 0x001c1fff001f7589ULL, 0x0206a400000e0000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011625ULL, 0x0000000c193d7812ULL, 0x000fc400078ec0ffULL,
0x000000071a1b7812ULL, 0x040fe200078ec0ffULL, 0x000000081a2c7824ULL, 0x040fe200078e00ffULL,
0x0000001aff227212ULL, 0x002fe200078e33ffULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0x0000000325ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081a377824ULL, 0x040fe200078e00ffULL,
0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c217812ULL, 0x100fe400078ee21bULL,
0x0000000120237812ULL, 0x100fe200078ef61bULL, 0x000000081a497824ULL, 0x000fe200078e00ffULL,
0x00000002202d7812ULL, 0x108fe200078ef61bULL, 0x000000081a2c7824ULL, 0x000fe200078e00ffULL,
0x00000003202f7812ULL, 0x000fc400078ef61bULL, 0x0000000420317812ULL, 0x140fe400078ef61bULL,
0x0000000520337812ULL, 0x140fe400078ef61bULL, 0x0000000620357812ULL, 0x000fe200078ef61bULL,
0x000000081a207824ULL, 0x040fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe400078ee222ULL,
0x0000001aff227212ULL, 0x000fe400078e33ffULL, 0x000000071a1b7812ULL, 0x000fc400078ec0ffULL,
0x00012000741a7811ULL, 0x000fe400078e58ffULL, 0xfffffff82c397812ULL, 0x100fe400078ee21bULL,
0x00000001203b7812ULL, 0x140fe200078ef61bULL, 0x0000001021197824ULL, 0x100fe200078e021aULL,
0x00000002203f7812ULL, 0x140fe200078ef61bULL, 0x00000010312c7824ULL, 0x100fe200078e021aULL,
0x0000000320417812ULL, 0x040fe200078ef61bULL, 0x000000013d197824ULL, 0x000fe200078e0219ULL,
0x0000000420437812ULL, 0x140fe200078ef61bULL, 0x00000010332e7824ULL, 0x100fe200078e021aULL,
0x0000000520457812ULL, 0x140fe200078ef61bULL, 0x0000001035307824ULL, 0x100fe200078e021aULL,
0x0000000620477812ULL, 0x000fe200078ef61bULL, 0x00000010231b7824ULL, 0x000fe200078e021aULL,
0xfffffff849497812ULL, 0x000fe200078ee222ULL, 0x000000102d207824ULL, 0x100fe200078e021aULL,
0x0000000819007388ULL, 0x0003e20000000800ULL, 0x000000102f227824ULL, 0x000fc400078e021aULL,
0x000000013d1b7824ULL, 0x040fe400078e021bULL, 0x000000013d217824ULL, 0x000fe400078e0220ULL,
0x0000001037327824ULL, 0x000fe200078e021aULL, 0x0000000a1b007388ULL, 0x0007e20000000800ULL,
0x000000013d237824ULL, 0x000fe400078e0222ULL, 0x0000001039347824ULL, 0x000fe200078e021aULL,
0x0000000c21007388ULL, 0x0007e20000000800ULL, 0x000000013d2d7824ULL, 0x000fc400078e022cULL,
0x000000103b357824ULL, 0x000fe200078e021aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x000000013d2f7824ULL, 0x000fe400078e022eULL, 0x000000103f367824ULL, 0x000fe200078e021aULL,
0x000000102d007388ULL, 0x0007e20000000800ULL, 0x000000013d317824ULL, 0x000fe400078e0230ULL,
0x0000001041377824ULL, 0x000fe200078e021aULL, 0x000000122f007388ULL, 0x0007e20000000800ULL,
0x000000013d337824ULL, 0x000fc400078e0232ULL, 0x0000001043387824ULL, 0x100fe200078e021aULL,
0x0000001431007388ULL, 0x0007e20000000800ULL, 0x0000001045397824ULL, 0x100fe400078e021aULL,
0x00000010473a7824ULL, 0x100fe200078e021aULL, 0x0000001633007388ULL, 0x0007e20000000800ULL,
0x00000010493b7824ULL, 0x000fe400078e021aULL, 0x000000013d347824ULL, 0x040fe400078e0234ULL,
0x000000013d1a7824ULL, 0x000fc400078e0235ULL, 0x000000013d367824ULL, 0x040fe200078e0236ULL,
0x0000000934007388ULL, 0x0007e20000000800ULL, 0x000000013d087824ULL, 0x042fe400078e0237ULL,
0x000000013d387824ULL, 0x040fe200078e0238ULL, 0x0000000b1a007388ULL, 0x0007e20000000800ULL,
0x000000013d207824ULL, 0x040fe400078e0239ULL, 0x000000013d3a7824ULL, 0x040fe200078e023aULL,
0x0000000d36007388ULL, 0x0007e20000000800ULL, 0x000000013d227824ULL, 0x000fc600078e023bULL,
0x0000000f08007388ULL, 0x0007e80000000800ULL, 0x0000001138007388ULL, 0x0007e80000000800ULL,
0x0000001320007388ULL, 0x0007e80000000800ULL, 0x000000153a007388ULL, 0x0007e80000000800ULL,
0x0000001722007388ULL, 0x0007e80000000800ULL, 0x01c0000418008388ULL, 0x0007e80000000c00ULL,
0x01c2001c18008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030075757a10ULL, 0x000fe20007ffe0ffULL, 0x01c6080027ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff2bff7812ULL, 0x000fc4000780c0ffULL, 0x000000707500720cULL, 0x000fe40003f26070ULL,
0x00000001ff2b7807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffbd9000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e0037ULL, 0x0001636000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x000fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x0000061000007944ULL, 0x022fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0035ULL, 0xfffff1f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff357224ULL, 0x000fe200078e0038ULL, 0x000163e000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x002fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x0000059000007944ULL, 0x020fea0003c00000ULL,
0x0000003538387209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e0006ULL,
0x0001645000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff367424ULL, 0x002fe400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fe400078e00ffULL,
0x0000052000007944ULL, 0x000fea0003c00000ULL, 0x0000003506067209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e0007ULL, 0x000164c000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff367424ULL, 0x002fc400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x000004b000007944ULL, 0x000fea0003c00000ULL,
0x00000035072c7209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e0037ULL,
0x0001653000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fe400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fe400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000003537047209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e0038ULL, 0x000165a000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x0000003538057209ULL, 0x004fe20007810000ULL, 0x000000ffff357224ULL, 0x000fe200078e0006ULL,
0x0001661000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff367424ULL, 0x002fe400078e00ffULL,
0x0000001fff397424ULL, 0x000fe400078e00ffULL, 0xffffffffff3a7424ULL, 0x000fe400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x0000003506067209ULL, 0x004fe20007810000ULL,
0x000000ffff357224ULL, 0x000fe200078e002cULL, 0x0001668000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff367424ULL, 0x002fc400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fe400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xffffefd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff207224ULL, 0x000fe200078e0030ULL,
0x000166e0001a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fe400078e00ffULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000002d000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e001fULL, 0xfffff5a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff207224ULL, 0x002fe200078e0032ULL, 0x00016750001a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff217224ULL, 0x000fe400078e00ffULL, 0x00001c1fff227424ULL, 0x000fc400078e00ffULL,
0x0000026000007944ULL, 0x024fea0003c00000ULL, 0x000000ffff217224ULL, 0x002fe200078e00ffULL,
0x000167a0001a7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff227424ULL, 0x000fc400078e00ffULL,
0x000000ffff1d7224ULL, 0x004fe400078e001fULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff217224ULL, 0x002fe200078e00ffULL, 0x000167f0001a7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e001fULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xfffff52000007947ULL, 0x000fea000383ffffULL,
0x0180000035057810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000005077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000003500058308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff1a7807ULL, 0x000fe40000800000ULL, 0x00000001ff057807ULL, 0x004fc80004000000ULL,
0x000000051aff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff35ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000035077812ULL, 0x000fe400078ec0ffULL,
0x00000001ff057807ULL, 0x000fc80000000000ULL, 0x000000051aff7212ULL, 0x000fda000780c0ffULL,
0x0080000007050812ULL, 0x000fe200078efcffULL, 0x000000ffff058224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000003500057308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe969006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0c00003635357389ULL, 0x0002a200000e0039ULL,
0xfffe965008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff1b7424ULL, 0x000fe200078e00ffULL,
0x0000002d00007348ULL, 0x000fe80003800000ULL, 0x00000021201f7389ULL, 0x0002a200000e0022ULL,
0xfffe96101a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e94ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ec8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ee8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f70ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016a80ULL, 0xe900001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017c00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017c10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017c10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018090ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f58ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016ca8ULL, 0x0000000000016ca8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017c00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018090ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_pagedKV_128_nqpkv_16_m_16_sm_80_cubin_len = 98672;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
