/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x00000000000146f0ULL, 0x0000000000014270ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000012c50ULL, 0x0000000000000230ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000012e80ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00012c5000000000ULL, 0x00007c0400000000ULL, 0x0400288080810c00ULL, 0x0000000000004a8cULL,
0x00000044ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080920828808081ULL, 0x8016288080840828ULL, 0x0000000310288082ULL,
0x8084920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL,
0x00012c5000000000ULL, 0x0000023000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL,
0x0008120400000080ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000eULL, 0x0000000e00081104ULL, 0x0008120400000000ULL, 0x000000000000000eULL,
0x0000007c00043704ULL, 0x00000000000c1704ULL, 0x0021f00000480007ULL, 0x00000000000c1704ULL,
0x0021f00000400006ULL, 0x00000000000c1704ULL, 0x0021f00000380005ULL, 0x00000000000c1704ULL,
0x0011f00000300004ULL, 0x00000000000c1704ULL, 0x0061f00000180003ULL, 0x00000000000c1704ULL,
0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL,
0x0011f00000000000ULL, 0x00801b0380005003ULL, 0x00011a6000103104ULL, 0x00011a8000011a70ULL,
0x010c290400011a90ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002c0500000dULL, 0x0500000d0500002cULL,
0x0500000d0500000dULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x0500003c0500003cULL,
0x0500003c0500003cULL, 0x0500003c0500003cULL, 0x010c28040500003cULL, 0x00000130000000e0ULL,
0x000016c000001630ULL, 0x0000177000001740ULL, 0x00001c7000001bd0ULL, 0x00002d3000002d00ULL,
0x00003f5000003ee0ULL, 0x00003fe000003fc0ULL, 0x000042f0000042e0ULL, 0x0000543000005420ULL,
0x000065e000006570ULL, 0x0000667000006650ULL, 0x0000698000006970ULL, 0x00007ac000007ab0ULL,
0x00008c7000008c00ULL, 0x00008d1000008cf0ULL, 0x000090f0000090c0ULL, 0x0000a1700000a160ULL,
0x0000b1600000b150ULL, 0x0000d3700000b8d0ULL, 0x0000d8200000d3a0ULL, 0x0000dcb00000d840ULL,
0x000113a000011390ULL, 0x000113c0000113b0ULL, 0x00011410000113f0ULL, 0x0001144000011430ULL,
0x00011a7000011a50ULL, 0x00011ac000011a80ULL, 0x00011ae000011ad0ULL, 0x000127e000012750ULL,
0x000128a000012840ULL, 0x0001297000012910ULL, 0x00012a30000129d0ULL, 0x00012b7000012ad0ULL,
0x06f0390400012c10ULL, 0x000000ff00000240ULL, 0x0004010000010600ULL, 0x0000000700000320ULL,
0x003f010000010608ULL, 0x0000000700000430ULL, 0x003f010000010688ULL, 0x0000000200000550ULL,
0x003f0100000106a8ULL, 0x000000ff00000640ULL, 0x00040100000106b8ULL, 0x000000ff00000900ULL,
0x0009010700010600ULL, 0x0000000f00000af0ULL, 0x0009010100010688ULL, 0x000000ff00000ee0ULL,
0x00090107000106a8ULL, 0x000000ff00000f10ULL, 0x00090101000106a8ULL, 0x000000ff00000f90ULL,
0x00090101000106b8ULL, 0x0000000800001050ULL, 0x003f010500000000ULL, 0x000000ff00001110ULL,
0x00090109000106b8ULL, 0x000000ff000014c0ULL, 0x00090107000106b0ULL, 0x000000ff000014f0ULL,
0x00090101000106b0ULL, 0x000000ff00001530ULL, 0x0004010500000000ULL, 0x0000000f00001550ULL,
0x0009010100010608ULL, 0x0000000f00001560ULL, 0x0009010900010608ULL, 0x000000ff000019c0ULL,
0x00090109000106a8ULL, 0x000000ff000026f0ULL, 0x00090101000106b8ULL, 0x00000008000027f0ULL,
0x003f010500000000ULL, 0x000000ff00002b70ULL, 0x00090109000106b8ULL, 0x000000ff00002c30ULL,
0x0004010700000000ULL, 0x000000ff00002c60ULL, 0x00090101000106a8ULL, 0x000000ff00002c80ULL,
0x0005010500000000ULL, 0x000000ff00002ca0ULL, 0x00090109000106b0ULL, 0x000000ff00003b80ULL,
0x00090101000106b8ULL, 0x000000ff00003b90ULL, 0x0009010100010688ULL, 0x0000000800003bc0ULL,
0x003f010500000000ULL, 0x000000ff00003c60ULL, 0x00090109000106b8ULL, 0x000000ff00003e20ULL,
0x0005010700000000ULL, 0x000000ff00003e50ULL, 0x00090101000106b0ULL, 0x000000ff00003e60ULL,
0x0004010500000000ULL, 0x0000000f00003e70ULL, 0x0009010100010628ULL, 0x0000000f00003e80ULL,
0x0009010900010628ULL, 0x000000ff00004250ULL, 0x00090109000106a8ULL, 0x000000ff00004e90ULL,
0x00090101000106b8ULL, 0x0000000800004f00ULL, 0x003f010500000000ULL, 0x000000ff000052d0ULL,
0x00090109000106b8ULL, 0x000000ff00005360ULL, 0x0004010700000000ULL, 0x000000ff00005390ULL,
0x00090101000106a8ULL, 0x000000ff000053a0ULL, 0x0005010500000000ULL, 0x000000ff000053c0ULL,
0x00090109000106b0ULL, 0x000000ff00006210ULL, 0x00090101000106b8ULL, 0x000000ff00006220ULL,
0x0009010100010690ULL, 0x0000000800006250ULL, 0x003f010500000000ULL, 0x000000ff000062f0ULL,
0x00090109000106b8ULL, 0x000000ff000064b0ULL, 0x0005010700000000ULL, 0x000000ff000064e0ULL,
0x00090101000106b0ULL, 0x000000ff000064f0ULL, 0x0004010500000000ULL, 0x0000000f00006500ULL,
0x0009010100010648ULL, 0x0000000f00006510ULL, 0x0009010900010648ULL, 0x000000ff000068e0ULL,
0x00090109000106a8ULL, 0x000000ff00007520ULL, 0x00090101000106b8ULL, 0x0000000800007590ULL,
0x003f010500000000ULL, 0x000000ff00007960ULL, 0x00090109000106b8ULL, 0x000000ff000079f0ULL,
0x0004010700000000ULL, 0x000000ff00007a20ULL, 0x00090101000106a8ULL, 0x000000ff00007a30ULL,
0x0005010500000000ULL, 0x000000ff00007a50ULL, 0x00090109000106b0ULL, 0x000000ff000088a0ULL,
0x00090101000106b8ULL, 0x000000ff000088b0ULL, 0x0009010100010698ULL, 0x00000008000088e0ULL,
0x003f010500000000ULL, 0x000000ff00008970ULL, 0x00090109000106b8ULL, 0x000000ff00008b40ULL,
0x0005010700000000ULL, 0x000000ff00008b70ULL, 0x00090101000106b0ULL, 0x000000ff00008b80ULL,
0x0004010500000000ULL, 0x0000000f00008b90ULL, 0x0009010100010668ULL, 0x0000000f00008ba0ULL,
0x0009010900010668ULL, 0x000000ff00008f70ULL, 0x00090109000106a8ULL, 0x000000ff00009ad0ULL,
0x00090101000106b8ULL, 0x0000000800009bf0ULL, 0x003f010500000000ULL, 0x000000ff0000a000ULL,
0x00090109000106b8ULL, 0x000000ff0000a090ULL, 0x0004010700000000ULL, 0x000000ff0000a0c0ULL,
0x00090101000106a8ULL, 0x000000ff0000a0d0ULL, 0x0005010500000000ULL, 0x000000ff0000a0f0ULL,
0x00090109000106b0ULL, 0x000000ff0000aee0ULL, 0x00090101000106b8ULL, 0x000000ff0000af10ULL,
0x00090101000106a0ULL, 0x000000ff0000dfc0ULL, 0x0009010100010600ULL, 0x000000ff0000eaa0ULL,
0x0009010900010600ULL, 0x000000ff0000ed80ULL, 0x0009010100010600ULL, 0x000000ff0000ed90ULL,
0x0009010900010600ULL, 0x0000000600010ae0ULL, 0x003f010100010688ULL, 0x0000000600010c60ULL,
0x003f010900010688ULL, 0x0000000700011dd0ULL, 0x003f010100010608ULL, 0x0000000700011de0ULL,
0x003f010100010610ULL, 0x0000000700011df0ULL, 0x003f010100010618ULL, 0x0000000700011e00ULL,
0x003f010100010620ULL, 0x0000000400011e30ULL, 0x003f0109000106b8ULL, 0x0000000d00011e90ULL,
0x003f010900010608ULL, 0x0000000400011ef0ULL, 0x003f0109000106a8ULL, 0x0000000400011f50ULL,
0x003f0109000106b8ULL, 0x0000000400011fb0ULL, 0x003f0109000106b0ULL, 0x0000000400012010ULL,
0x003f0109000106b8ULL, 0x0000000d00012070ULL, 0x003f010900010628ULL, 0x00000004000120d0ULL,
0x003f0109000106a8ULL, 0x0000000400012130ULL, 0x003f0109000106b8ULL, 0x0000000400012190ULL,
0x003f0109000106b0ULL, 0x00000004000121f0ULL, 0x003f0109000106b8ULL, 0x0000000d00012250ULL,
0x003f010900010648ULL, 0x00000004000122b0ULL, 0x003f0109000106a8ULL, 0x0000000400012310ULL,
0x003f0109000106b8ULL, 0x0000000400012370ULL, 0x003f0109000106b0ULL, 0x00000004000123d0ULL,
0x003f0109000106b8ULL, 0x0000000d00012430ULL, 0x003f010900010668ULL, 0x0000000400012490ULL,
0x003f0109000106a8ULL, 0x00000004000124f0ULL, 0x003f0109000106b8ULL, 0x0000000400012550ULL,
0x003f0109000106b0ULL, 0x0000000d000125c0ULL, 0x003f010900010600ULL, 0x0000000700012630ULL,
0x003f010900010600ULL, 0x0000000600012690ULL, 0x003f010900010688ULL, 0x00101c0400053803ULL,
0x0000edb00000df10ULL, 0x00011e200000ee30ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x005002100000000fULL, 0x0000000800043604ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000000ULL, 0x00000000000000ccULL, 0x0000000e00000002ULL,
0x0000000000012c50ULL, 0x0000000000000044ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL,
0x00000000000000a5ULL, 0x0000000e00000002ULL, 0x0000000000000000ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000087919ULL, 0x000eae0000002300ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x0000040000097802ULL, 0x000fe20000000f00ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x0000000000477919ULL, 0x000f280000002100ULL, 0x00008400ff107b82ULL, 0x000f620000000800ULL,
0x0000000000137919ULL, 0x000f620000002700ULL, 0x00000000000c7919ULL, 0x000f6c0000008800ULL,
0x00008800ff047b82ULL, 0x000f700000000a00ULL, 0x00000000000879c3ULL, 0x000f620000002600ULL,
0x00000004ff457e24ULL, 0x008fc4000f8e00ffULL, 0x0000000108007824ULL, 0x004fe400078e0203ULL,
0x00001fff08087589ULL, 0x000fe400000e0000ULL, 0x0000008000027824ULL, 0x110fe200078e0247ULL,
0x00000005ff477819ULL, 0x000fe20000011647ULL, 0x0000000000007919ULL, 0x000f660000000000ULL,
0x0000007f0200780cULL, 0x040fe40003f64070ULL, 0x00001fff47477589ULL, 0x000ea200000e0000ULL,
0x000000ff0200720cULL, 0x000fc40003f45270ULL, 0x0000000f0200780cULL, 0x040fe40003f04070ULL,
0x000000030200780cULL, 0x040fe40003fa4070ULL, 0x000000010200780cULL, 0x000fc80003f84070ULL,
0x000000000006b919ULL, 0x000ee20000008800ULL, 0x000004000003b802ULL, 0x000fe20000000f00ULL,
0xff317217ff0ab424ULL, 0x000fc600078e00ffULL, 0x000006540603b816ULL, 0x008fe20000000003ULL,
0x0000000408067824ULL, 0x004fc800078e0247ULL, 0x000000040203b824ULL, 0x000fe200078e0203ULL,
0x0000000000242947ULL, 0x022fec0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01060006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000380947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402077c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01060804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000385947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402077c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000070612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01068804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0104000a0300b388ULL, 0x0007e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ff8000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffe0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x00cfca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x0106a804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x0000000000242947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x002e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x0106b806043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000308047899ULL, 0x002fe2000800063fULL,
0x0000000810027824ULL, 0x000fe200078e00ffULL, 0x000006540c097816ULL, 0x000fe20000000009ULL,
0x0000000206077824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x004fe40000010000ULL,
0x0000000402027e24ULL, 0x000fe2000f8e0213ULL, 0x00000000090972caULL, 0x000fe200000e0000ULL,
0x00000001070f7836ULL, 0x040fe20000000000ULL, 0x0000000807067848ULL, 0x000fe20007fe0000ULL,
0x0000000102037824ULL, 0x008fc400078e0207ULL, 0x00008c00ff0a7b82ULL, 0x000ea20000000a00ULL,
0x00000001020d7824ULL, 0x000fe200078e020fULL, 0x000000070f117812ULL, 0x000fe200078ec0ffULL,
0x0000020003027825ULL, 0x100fe200078e0004ULL, 0x0000820000067ab9ULL, 0x000fe40000000a00ULL,
0x0000001f110e7812ULL, 0x000fe200078e7800ULL, 0x000002000d047825ULL, 0x000fe200078e0004ULL,
0x00000007070d7812ULL, 0x000fe200078ec0ffULL, 0x0001060009047890ULL, 0x000fe4000fffe03fULL,
0x0000001000097824ULL, 0x000fe200078e00ffULL, 0x0000001f0d0c7812ULL, 0x000fe200078e7800ULL,
0x0000000106067824ULL, 0x000fc400078e0a07ULL, 0x000000200f0e7824ULL, 0x000fe200078e020eULL,
0x000001f009157812ULL, 0x000fe200078ec0ffULL, 0x00000020070c7824ULL, 0x000fe200078e020cULL,
0x000000ff0600720cULL, 0x040fe40003f03070ULL, 0x000000010600780cULL, 0x000fe40003f23070ULL,
0x0000001502027210ULL, 0x000fe40007f5e0ffULL, 0x0000001504067210ULL, 0x000fe40007f7e0ffULL,
0x000000090c0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff037224ULL, 0x000fe200010e0603ULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff077224ULL, 0x000fc400018e0605ULL,
0x0000000413047825ULL, 0x004fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e8000c101c46ULL, 0x00000000060f7faeULL, 0x0003e2000c901c46ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe40008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000604447981ULL, 0x000ea2000c1e1900ULL, 0x00000300ff027b82ULL, 0x002e620000000800ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x000000ff440e7836ULL, 0x004fca0000000000ULL,
0x00000008ff0e7819ULL, 0x000fce000001160eULL, 0x000000d400608947ULL, 0x002fea0003800000ULL,
0x0000000213037824ULL, 0x000fe200078e00ffULL, 0x00000004ff077819ULL, 0x000fe20000011600ULL,
0x0000000810047c36ULL, 0x000fe20008000000ULL, 0x00008a00ff0a7b82ULL, 0x000e620000000a00ULL,
0x00000008470f7824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000000145057836ULL, 0x000fe20000000000ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001003037224ULL, 0x000fe200078e0204ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000010045047824ULL, 0x000fe200078e00ffULL, 0x0000000e0500720cULL, 0x000fe20003f06070ULL,
0x000000010f0d7824ULL, 0x000fe200078e0207ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000207087836ULL, 0x000fe20000000000ULL, 0x0000000444057248ULL, 0x000fe20007fe0000ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0x000000070d117812ULL, 0x000fe200078ec0ffULL,
0x0000000407107836ULL, 0x000fe20000000000ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000010f137824ULL, 0x000fe200078e0208ULL, 0x010688060fff79a7ULL, 0x0007e20008500009ULL,
0x0000000607177836ULL, 0x000fe20000000000ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000010f157824ULL, 0x040fe200078e0210ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000010f197824ULL, 0x000fe200078e0217ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000403047c24ULL, 0x000fe2000f8e0204ULL, 0x0000000f11067812ULL, 0x008fe200078e7800ULL,
0x000106a809047890ULL, 0x000fe2000fffe03fULL, 0x0000000713117812ULL, 0x000fc600078ec0ffULL,
0x000000100d127824ULL, 0x000fe200078e0206ULL, 0x0000002005067807ULL, 0x000fe20000000000ULL,
0x00000001040d7824ULL, 0x040fe200078e020dULL, 0x0000000715057812ULL, 0x000fe400078ec0ffULL,
0x0000000f110c7812ULL, 0x000fe400078e7800ULL, 0x0000000719117812ULL, 0x000fe400078ec0ffULL,
0x0000000f05167812ULL, 0x000fe200078e7800ULL, 0x0000001013147824ULL, 0x000fe200078e020cULL,
0x000000060f067248ULL, 0x000fe20007fe0000ULL, 0x0000000104137824ULL, 0x000fe200078e0213ULL,
0x0000000f110c7812ULL, 0x000fe200078e7800ULL, 0x0000001015167824ULL, 0x000fc400078e0216ULL,
0x0000000104157824ULL, 0x040fe400078e0215ULL, 0x0000000104117824ULL, 0x000fe400078e0219ULL,
0x0000000106067824ULL, 0x000fe400078e0a0fULL, 0x0000001019187824ULL, 0x000fe200078e020cULL,
0x000000f009197812ULL, 0x000fe200078ec0ffULL, 0x000001000d047825ULL, 0x102fe200078e000aULL,
0x000000060700720cULL, 0x080fe40003f66070ULL, 0x000000060800720cULL, 0x080fe20003f46070ULL,
0x0000010015087825ULL, 0x000fe200078e000aULL, 0x000000061000720cULL, 0x000fc40003f26070ULL,
0x000000061700720cULL, 0x000fe20003f06070ULL, 0x0000010013067825ULL, 0x100fe200078e000aULL,
0x00000019040c7210ULL, 0x000fe40007f9e0ffULL, 0x0000001908087210ULL, 0x000fe20007fbe0ffULL,
0x00000009ff047e24ULL, 0x000fe4000f8e00ffULL, 0x00000100110a7825ULL, 0x000fc800078e000aULL,
0x000000ffff0d7224ULL, 0x000fe200020e0605ULL, 0x0000001906107210ULL, 0x000fe20007f9e0ffULL,
0x0000c00004057836ULL, 0x000fe20000000000ULL, 0x000000190a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff097224ULL, 0x000fe400028e0609ULL, 0x000000ffff117224ULL, 0x000fe400020e0607ULL,
0x0000001012077824ULL, 0x100fe400078e0205ULL, 0x0000001014137824ULL, 0x000fc400078e0205ULL,
0x0000001016157824ULL, 0x000fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c077faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0b7224ULL, 0x000fe400030e060bULL,
0x0000001018177824ULL, 0x000fe200078e0205ULL, 0x0000000010137faeULL, 0x000fe2000d101c46ULL,
0x00000001ff187424ULL, 0x000fe400078e00ffULL, 0xff317217ff067424ULL, 0x000fe200078e00ffULL,
0x0000000008157faeULL, 0x000fe2000c901c46ULL, 0x0000000e4500720cULL, 0x000fc60003f26070ULL,
0x000000000a177faeULL, 0x0005e2000c101c46ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a818ff6879a7ULL, 0x0008e20008500009ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x004fc4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0106b818ff1879a7ULL, 0x000e620008500009ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000000090f0d7c36ULL, 0x000fe20008000000ULL,
0x0000009c00ec1947ULL, 0x010fec0003800000ULL, 0x0000000447097824ULL, 0x000fe400078e00ffULL,
0x000106b804087836ULL, 0x000fe40000000000ULL, 0xff317217ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe400078e00ffULL, 0x00000002090b7836ULL, 0x000fce0000000000ULL,
0x00000100451b7824ULL, 0x000fca00078e00ffULL, 0x000000441b00720cULL, 0x000fda0003f06070ULL,
0x0000009c00c00947ULL, 0x000fea0003800000ULL, 0x00000019080075a7ULL, 0x002e62000802007fULL,
0x00000001451b7836ULL, 0x040fe20000000000ULL, 0x00000020450a7811ULL, 0x000fe200078e40ffULL,
0x00008e0000087ab9ULL, 0x000fe20000000800ULL, 0x00000004ff507819ULL, 0x000fe40000011600ULL,
0x0000000e1b00720cULL, 0x000fe40003f06070ULL, 0x0000000a441b7248ULL, 0x000fe20007fe0000ULL,
0x000000010f517824ULL, 0x000fc800078e0250ULL, 0x000000011b1b7824ULL, 0x100fe400078e0a0aULL,
0x00000008030a7c24ULL, 0x000fe2000f8e020aULL, 0x00008a00ff667b82ULL, 0x000ea40000000a00ULL,
0x0000000000081947ULL, 0x006fea0003800000ULL, 0x0106b819ff0075a7ULL, 0x000e640008020149ULL,
0x0000010c00409947ULL, 0x002fea0003800000ULL, 0x00000002504e7836ULL, 0x040fe20000000000ULL,
0x000000201b1a7807ULL, 0x000fe20000000000ULL, 0x00000004504c7836ULL, 0x040fe20000000000ULL,
0x0000000751377812ULL, 0x000fe200078ec0ffULL, 0x00000006504a7836ULL, 0x000fe20000000000ULL,
0x000106b009057890ULL, 0x000fe2000fffe03fULL, 0x000000010f4f7824ULL, 0x000fe200078e024eULL,
0x0000000f376e7812ULL, 0x000fe200078e7800ULL, 0x0000000151197824ULL, 0x000fe400078e020aULL,
0x0000001000437824ULL, 0x000fe200078e00ffULL, 0x000000074f377812ULL, 0x000fe200078ec0ffULL,
0x000000010f4d7824ULL, 0x000fc400078e024cULL, 0x000000010f4b7824ULL, 0x000fe200078e024aULL,
0x000000f043497812ULL, 0x000fe200078ec0ffULL, 0x000000014f1b7824ULL, 0x000fe200078e020aULL,
0x0000000f376c7812ULL, 0x000fe200078e7800ULL, 0x0000010019187825ULL, 0x000fe200078e0066ULL,
0x000000074b377812ULL, 0x000fc600078ec0ffULL, 0x000000014d2f7824ULL, 0x100fe200078e020aULL,
0x0000004918187210ULL, 0x000fe20007f3e0ffULL, 0x000000014b357824ULL, 0x000fe200078e020aULL,
0x0000001a0f0a7248ULL, 0x000fe20007fe0000ULL, 0x000001001b1a7825ULL, 0x000fe200078e0066ULL,
0x0000000f376a7812ULL, 0x000fc600078e7800ULL, 0x000000010a2d7824ULL, 0x000fe200078e0a0fULL,
0x000000491a2c7210ULL, 0x000fe20007fbe0ffULL, 0x000001002f2e7825ULL, 0x000fc600078e0066ULL,
0x0000002d5000720cULL, 0x080fe20003f86070ULL, 0x0000010035347825ULL, 0x000fe200078e0066ULL,
0x0000002d4e00720cULL, 0x080fe40003f66070ULL, 0x0000002d4c00720cULL, 0x080fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fe200008e0619ULL, 0x0000002d4a00720cULL, 0x000fe20003f26070ULL,
0x000000ffff2d7224ULL, 0x000fe200028e061bULL, 0x000000492e1a7210ULL, 0x000fe20007fde0ffULL,
0x0000e000045d7836ULL, 0x000fe20000000000ULL, 0x00000049342e7210ULL, 0x000fe20007fbe0ffULL,
0x00000010516e7824ULL, 0x000fc400078e026eULL, 0x000000ffff1b7224ULL, 0x000fe400030e062fULL,
0x000000ffff2f7224ULL, 0x000fe200028e0635ULL, 0x000000074d357812ULL, 0x000fe200078ec0ffULL,
0x000000104f6c7824ULL, 0x000fe400078e026cULL, 0x000000104b6a7824ULL, 0x000fe200078e026aULL,
0x0000000f355a7812ULL, 0x000fe200078e7800ULL, 0x000000106e637824ULL, 0x100fe400078e025dULL,
0x000000106c627824ULL, 0x000fc400078e025dULL, 0x000000104d5a7824ULL, 0x000fe200078e025aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018637faeULL, 0x000fe2000e101c46ULL,
0x000000106a607824ULL, 0x100fe400078e025dULL, 0x000000105a617824ULL, 0x000fe200078e025dULL,
0x000000002c627faeULL, 0x000fe2000d901c46ULL, 0x00000001ff0a7424ULL, 0x000fc600078e00ffULL,
0x000000001a617faeULL, 0x0005e8000d101c46ULL, 0x000000002e607faeULL, 0x0005e2000c901c46ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106b00aff7279a7ULL, 0x0002620008500009ULL,
0x00000001ff1a7819ULL, 0x004fe40000011600ULL, 0x0000007043437812ULL, 0x000fe400078ec0ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x00000069ff0075a7ULL, 0x0082660008020044ULL,
0x000000091a437c10ULL, 0x000fe2000fffe043ULL, 0x0106080a0f1879a7ULL, 0x000ea40008500009ULL,
0x010608190f0075a7ULL, 0x004ea40008040149ULL, 0x000001080044a947ULL, 0x00efea0003800000ULL,
0x0100000043197984ULL, 0x000e620000000800ULL, 0x0000000800557812ULL, 0x040fe200078ec0ffULL,
0x00000001ff537424ULL, 0x000fe200078e00ffULL, 0x0000000900547211ULL, 0x000fe200078fe0ffULL,
0x0102000043657984ULL, 0x0004a20000000800ULL, 0x00000007552d7812ULL, 0x000fe400078ec800ULL,
0x0000000755557812ULL, 0x000fe400078ef800ULL, 0x000000542d547212ULL, 0x000fca00078e3cffULL,
0x00000010555c7824ULL, 0x000fc800078e0254ULL, 0x000000105c427824ULL, 0x000fe200078e0205ULL,
0x000000061900720bULL, 0x002fda0003f5d000ULL, 0x0000000000187806ULL, 0x000fc800010e0100ULL,
0x0000ffff182c7812ULL, 0x000fda000784c0ffULL, 0x0000000000d4a947ULL, 0x004fea0003800000ULL,
0x000000061900720bULL, 0x000fe40003f54000ULL, 0x00000019062e7209ULL, 0x000fe40007810000ULL,
0x00000002ff1a7819ULL, 0x000fc60000011600ULL, 0x8000002e06187221ULL, 0x100fe40000010000ULL,
0x000000081a1b7836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b18187820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x000000ff4700720cULL, 0x000fe40003f45270ULL,
0x0000ffff062f7812ULL, 0x000fe200078e3cffULL, 0x0000001800187308ULL, 0x000e620000000800ULL,
0x000000ffff067224ULL, 0x000fc400078e002eULL, 0x0000002f2cff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff537807ULL, 0x000fc60001800000ULL, 0x0104002e4300a388ULL, 0x000fe80000000800ULL,
0x00001f1b181b7589ULL, 0x002e6400000e0000ULL, 0x8000002e19193221ULL, 0x000fe20000010000ULL,
0x0000001807077220ULL, 0x000fe20000410000ULL, 0x00001f1a181a7589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b19193820ULL, 0x000fc80000410000ULL, 0x00000019000c3308ULL, 0x000ee20000000800ULL,
0x0000001b33337220ULL, 0x082fe20000410000ULL, 0x0000001b32327220ULL, 0x080fe20000410000ULL,
0x0000001b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000001b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000001b27277220ULL, 0x080fe20000410000ULL, 0x0000001b26267220ULL, 0x080fe20000410000ULL,
0x0000001b23237220ULL, 0x080fe20000410000ULL, 0x0000001b22227220ULL, 0x080fe20000410000ULL,
0x0000001b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000001b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000001b17177220ULL, 0x080fe20000410000ULL, 0x0000001b16167220ULL, 0x080fe20000410000ULL,
0x0000001b13137220ULL, 0x080fe20000410000ULL, 0x0000001b12127220ULL, 0x080fe20000410000ULL,
0x0000001b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000001b2a2a7220ULL, 0x000fe20000410000ULL,
0x0000001a31317220ULL, 0x084fe20000410000ULL, 0x0000001a30307220ULL, 0x080fe20000410000ULL,
0x0000001a39397220ULL, 0x080fe20000410000ULL, 0x0000001a38387220ULL, 0x080fe20000410000ULL,
0x0000001a25257220ULL, 0x080fe20000410000ULL, 0x0000001a24247220ULL, 0x080fe20000410000ULL,
0x0000001a21217220ULL, 0x080fe20000410000ULL, 0x0000001a20207220ULL, 0x080fe20000410000ULL,
0x0000001a1d1d7220ULL, 0x080fe20000410000ULL, 0x0000001a1c1c7220ULL, 0x080fe20000410000ULL,
0x0000001a15157220ULL, 0x080fe20000410000ULL, 0x0000001a14147220ULL, 0x080fe20000410000ULL,
0x0000001a11117220ULL, 0x080fe20000410000ULL, 0x0000001a10107220ULL, 0x080fe20000410000ULL,
0x0000001a29297220ULL, 0x080fe20000410000ULL, 0x0000001a28287220ULL, 0x000fe20000410000ULL,
0x0000000c65653220ULL, 0x008fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a869ff0075a7ULL, 0x000e640008020149ULL, 0x0000010400449947ULL, 0x002fea0003800000ULL,
0x000000004218783bULL, 0x000e620000004200ULL, 0x00000007006b7812ULL, 0x040fe400078ec0ffULL,
0x0000000b00647211ULL, 0x000fe400078fe0ffULL, 0x000000086b6b7812ULL, 0x000fe400078ef800ULL,
0x000000642d647212ULL, 0x000fe400078e3cffULL, 0x0000000cff6d723eULL, 0x000fe400000000ffULL,
0x0000991053717816ULL, 0x000fe200000000ffULL, 0x0000001055527824ULL, 0x000fe200078e0264ULL,
0x000054106d6d7816ULL, 0x000fc4000000006dULL, 0x000000ff7100720cULL, 0x000fe20003f25270ULL,
0x00000010525f7824ULL, 0x000fe200078e0205ULL, 0x0000010055557811ULL, 0x000fc800078e20ffULL,
0x000000005f3c783bULL, 0x000ea20000004200ULL, 0x0000000154547824ULL, 0x100fe400078e0255ULL,
0x0000000164647824ULL, 0x000fe400078e0255ULL, 0x00000100182e7824ULL, 0x042fe200078e00ffULL,
0x0000888018577816ULL, 0x040fe200000000ffULL, 0x0001000018347824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe20000011418ULL, 0x0000010019487824ULL, 0x000fe200078e00ffULL,
0x00000018ff2f7819ULL, 0x000fe2000001142eULL, 0x000001001a6f7824ULL, 0x000fe200078e00ffULL,
0x00000007502e7812ULL, 0x000fe200078e786bULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000018ff467819ULL, 0x000fc40000011434ULL, 0x00000018ff5e7819ULL, 0x000fe20000011448ULL,
0x000000086b587824ULL, 0x000fe200078e022eULL, 0x00000002ff487819ULL, 0x000fe40000011600ULL,
0x0000888019597816ULL, 0x040fe200000000ffULL, 0x00000046002e7306ULL, 0x0003e20000200c00ULL,
0x0000000958587c11ULL, 0x000fe2000f8e20ffULL, 0x00001f486d537589ULL, 0x000fe200000e0000ULL,
0x00000018ff2c7819ULL, 0x000fe20000011419ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x000088801a707816ULL, 0x000fe200000000ffULL, 0x00a000005834783bULL, 0x000ee20000000200ULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000002f00187306ULL, 0x000f220000200c00ULL,
0x0000000848467836ULL, 0x002fe20000000000ULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff417819ULL, 0x000fe4000001141bULL, 0x00001f466d687589ULL, 0x000e6200000e0000ULL,
0x000088801b717816ULL, 0x000fe200000000ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe4000001141aULL, 0x00000018ff747819ULL, 0x004fe4000001143cULL,
0x00000018ff5b7819ULL, 0x000fe4000001143dULL, 0x0000541057187816ULL, 0x010fe20000000018ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000001001b577824ULL, 0x040fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe2000001143fULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc4000001143eULL, 0x00000018ff757819ULL, 0x000fe20000011457ULL,
0x000100001a577824ULL, 0x000fe200078e00ffULL, 0x0000002d002d7306ULL, 0x000f220000200c00ULL,
0x00000018ff1b7819ULL, 0x000fc6000001141bULL, 0x00000018ff577819ULL, 0x000fc80000011457ULL,
0x0000002c002c7306ULL, 0x000fe20000200c00ULL, 0x0000005334349232ULL, 0x008fce0000000000ULL,
0x00000019002f7306ULL, 0x0004e20000200c00ULL, 0x0000005336369232ULL, 0x000fe40000000000ULL,
0x0000006835359232ULL, 0x082fe40000000000ULL, 0x0000006837379232ULL, 0x000fc60000000000ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541059197816ULL, 0x004fe2000000005eULL,
0x00000010545e7824ULL, 0x000fcc00078e0205ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x000000183428723cULL, 0x000fee0000001828ULL, 0x000054102e187816ULL, 0x010fe2000000002dULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000054102f197816ULL, 0x008fc4000000002cULL,
0x000000005e2c783bULL, 0x000eaa0000004200ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000000183410723cULL, 0x000fee0000001810ULL, 0x0000005700577306ULL, 0x000ee20000200c00ULL,
0x0000541070187816ULL, 0x002fe2000000006fULL, 0x000001003d707824ULL, 0x040fe200078e00ffULL,
0x000088803d6f7816ULL, 0x000fc800000000ffULL, 0x00000018ff777819ULL, 0x000fe20000011470ULL,
0x0000001b00767306ULL, 0x000e620000200c00ULL, 0x0000541057407816ULL, 0x008fce0000000040ULL,
0x00000075001a7306ULL, 0x0007e20000200c00ULL, 0x0000541076417816ULL, 0x002fce0000000041ULL,
0x0000007100597306ULL, 0x0003220000200c00ULL, 0x000001003c757824ULL, 0x008fe200078e00ffULL,
0x00000018ff707819ULL, 0x004fe4000001142dULL, 0x000088802e7c7816ULL, 0x000fe200000000ffULL,
0x00000040341c723cULL, 0x000fe2000000181cULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x0000006f00577306ULL, 0x0005e20000200c00ULL, 0x000088803c717816ULL, 0x042fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000007100557306ULL, 0x0003e20000200c00ULL, 0x0000541059197816ULL, 0x010fe2000000001aULL,
0x0000001064597824ULL, 0x000fe200078e0205ULL, 0x00000018ff6f7819ULL, 0x004fca000001142eULL,
0x0000007500787306ULL, 0x000ea20000200c00ULL, 0x000000183414723cULL, 0x000fe20000001814ULL,
0x000000005918783bULL, 0x000ee20000004200ULL, 0x00000018ff717819ULL, 0x002fca000001142cULL,
0x0000007700767306ULL, 0x000e620000200c00ULL, 0x0000541055407816ULL, 0x004fce0000000078ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541057417816ULL, 0x002fce0000000076ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff577819ULL, 0x000fe2000001142fULL,
0x000000403420723cULL, 0x000fec0000001820ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000100003d407824ULL, 0x000fe200078e00ffULL, 0x000088803e417816ULL, 0x000fcc00000000ffULL,
0x0000003c003d7306ULL, 0x000e620000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff777819ULL, 0x008fe4000001141bULL, 0x00000018ff557819ULL, 0x000fc60000011418ULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x000054103d3c7816ULL, 0x002fe20000000074ULL,
0x000001003e3d7824ULL, 0x000fcc00078e00ffULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x00000018ff747819ULL, 0x000fe4000001143dULL, 0x00005410403d7816ULL, 0x004fe4000000005bULL,
0x000088803f5b7816ULL, 0x000fc600000000ffULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe2000001141aULL, 0x0000003c3424723cULL, 0x000fec0000001824ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000001003f3d7824ULL, 0x040fe400078e00ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e005bULL, 0x00000018ff5b7819ULL, 0x000fe20000011419ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000003c00757306ULL, 0x0003f00000200c00ULL, 0x0000003d00767306ULL, 0x000ea20000200c00ULL,
0x00005410413c7816ULL, 0x002fe20000000074ULL, 0x000100003e417824ULL, 0x000fca00078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00005410753d7816ULL, 0x004fce0000000076ULL, 0x0000004100747306ULL, 0x0002a20000200c00ULL,
0x000001002c757824ULL, 0x000fe200078e00ffULL, 0x0000003c3438723cULL, 0x000fe80000001838ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000088802d417816ULL, 0x002fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143fULL,
0x000088802c3f7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe400078e00ffULL,
0x0000003c003d7306ULL, 0x0004660000200c00ULL, 0x00000018ff2c7819ULL, 0x000fca000001142cULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x00005410743c7816ULL, 0x004fe20000000069ULL,
0x000001002e697824ULL, 0x040fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x000054103d3d7816ULL, 0x002fc60000000056ULL, 0x0000007500747306ULL, 0x0002a20000200c00ULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000003c3434723cULL, 0x000fe80000001830ULL, 0x00000041003d7306ULL, 0x000fe20000200c00ULL,
0x000088802f757816ULL, 0x002fe400000000ffULL, 0x000000074e307812ULL, 0x000fe200078e786bULL,
0x000001002d317824ULL, 0x000fc400078e00ffULL, 0x000100002d2d7824ULL, 0x000fe400078e00ffULL,
0x0000002c003c7306ULL, 0x0005e20000200c00ULL, 0x000000086b307824ULL, 0x000fe200078e0230ULL,
0x00000018ff7a7819ULL, 0x000fe40000011431ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000000930567c11ULL, 0x000fe4000f8e20ffULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x000054103f2c7816ULL, 0x004fc40000000074ULL, 0x00a000005630783bULL, 0x000eaa0000000200ULL,
0x0000002d00417306ULL, 0x0007300000200c00ULL, 0x00000075003f7306ULL, 0x000fe20000200c00ULL,
0x000001002f2d7824ULL, 0x008fc400078e00ffULL, 0x000100002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff2f7819ULL, 0x000fce000001142fULL, 0x0000002d00767306ULL, 0x0002f00000200c00ULL,
0x0000006900697306ULL, 0x000f620000200c00ULL, 0x000054103d2d7816ULL, 0x002fe2000000007aULL,
0x0000005330309232ULL, 0x084fe20000000000ULL, 0x00008880187a7816ULL, 0x000fe200000000ffULL,
0x0000005332329232ULL, 0x000fe20000000000ULL, 0x00008880193d7816ULL, 0x000fe200000000ffULL,
0x0000006831319232ULL, 0x000fc40000000000ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000006833339232ULL, 0x000fce0000000000ULL, 0x0000002c3028723cULL, 0x000fe20000001828ULL,
0x0000005700577306ULL, 0x000fec0000200c00ULL, 0x00000100192d7824ULL, 0x040fe400078e00ffULL,
0x00000100182c7824ULL, 0x040fe200078e00ffULL, 0x0000002e00787306ULL, 0x0003e20000200c00ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fc4000001142cULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000002f00687306ULL, 0x0009e20000200c00ULL,
0x000054103c2e7816ULL, 0x002fe40000000071ULL, 0x00000018ff197819ULL, 0x000fca0000011419ULL,
0x0000002d00747306ULL, 0x0007e20000200c00ULL, 0x00005410412f7816ULL, 0x010fe40000000070ULL,
0x0000004045417811ULL, 0x000fca00078e40ffULL, 0x00000077003e7306ULL, 0x0003e20000200c00ULL,
0x000054103f2d7816ULL, 0x008fe20000000076ULL, 0x0000002e3010723cULL, 0x000fec0000001810ULL,
0x0000002c00537306ULL, 0x000be20000200c00ULL, 0x0106b80aff7679a7ULL, 0x002e620008500009ULL,
0x00000008032e7c24ULL, 0x000fe2000f8e0241ULL, 0x000088801a2f7816ULL, 0x000fc600000000ffULL,
0x000000014f3f7824ULL, 0x100fe400078e022eULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x000054107c2c7816ULL, 0x020fe20000000069ULL, 0x0000000151697824ULL, 0x100fe200078e022eULL,
0x00000041447c7248ULL, 0x000fe20007fe0000ULL, 0x000000014b717824ULL, 0x000fc800078e022eULL,
0x0000003d003d7306ULL, 0x000ee20000200c00ULL, 0x0000002c3014723cULL, 0x000fe20000001814ULL,
0x000000017c7c7824ULL, 0x000fca00078e0a41ULL, 0x000000207c7c7807ULL, 0x000fe20000000000ULL,
0x00000018003c7306ULL, 0x0009e20000200c00ULL, 0x000001001a2d7824ULL, 0x000fe200078e00ffULL,
0x000054107a2c7816ULL, 0x004fe20000000053ULL, 0x00000077080075a7ULL, 0x002e6200080c007fULL,
0x000088801b537816ULL, 0x000fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000001900707306ULL, 0x0005e20000200c00ULL,
0x0000541078187816ULL, 0x010fc4000000006fULL, 0x0000007c0f7c7248ULL, 0x000fca0007fe0000ULL,
0x0000002d007a7306ULL, 0x0007e20000200c00ULL, 0x0000541068197816ULL, 0x004fe20000000057ULL,
0x0000010069687825ULL, 0x000fc600078e0066ULL, 0x0000004968787210ULL, 0x000fc60007f5e0ffULL,
0x00000018301c723cULL, 0x000fe2000000181cULL, 0x000054103d2d7816ULL, 0x008fe20000000074ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x000000ffff797224ULL, 0x000fc800010e0669ULL,
0x000001003f187825ULL, 0x000fe200078e0066ULL, 0x0000002c3020723cULL, 0x000fe40000001820ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0053ULL,
0x0000004918687210ULL, 0x000fe20007f5e0ffULL, 0x000001001b187824ULL, 0x040fe400078e00ffULL,
0x000100001b2c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff697224ULL, 0x000fe200010e0619ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000002f002f7306ULL, 0x000ee20000200c00ULL,
0x00000018ff537819ULL, 0x000fe2000001142cULL, 0x000000014d1b7824ULL, 0x000fe200078e022eULL,
0x0000541070197816ULL, 0x004fe2000000005bULL, 0x0000010071707825ULL, 0x000fc800078e0066ULL,
0x0000003f003d7306ULL, 0x0005f00000200c00ULL, 0x0000001800747306ULL, 0x0009620000200c00ULL,
0x00000018ff3f7819ULL, 0x004fe2000001141aULL, 0x000001001b1a7825ULL, 0x000fc600078e0066ULL,
0x000000491a2c7210ULL, 0x000fc60007f5e0ffULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054103c187816ULL, 0x010fe20000000055ULL, 0x000000017c557824ULL, 0x000fe400078e0a0fULL,
0x000000ffff2d7224ULL, 0x000fe200010e061bULL, 0x00000049701a7210ULL, 0x000fe40007f5e0ffULL,
0x000000554e00720cULL, 0x080fe20003f66070ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x000000183024723cULL, 0x000fe20000001824ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0671ULL,
0x000000555000720cULL, 0x000fc40003f46070ULL, 0x000000554c00720cULL, 0x080fe40003f86070ULL,
0x000000554a00720cULL, 0x000fe20003fa6070ULL, 0x0000005300537306ULL, 0x000f220000200c00ULL,
0x000054102f187816ULL, 0x008fe4000000007aULL, 0x000054103d197816ULL, 0x020fce0000000074ULL,
0x000000183038723cULL, 0x000fee0000001838ULL, 0x000054103f187816ULL, 0x004fe40000000040ULL,
0x0000541053197816ULL, 0x010fe2000000003eULL, 0x000000106e537824ULL, 0x000fcc00078e0205ULL,
0x000000183034723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000086947ULL, 0x002fde0003800000ULL, 0x0106b877ff0075a7ULL, 0x000e6400080c0149ULL,
0x000000f000f0e947ULL, 0x002fea0003800000ULL, 0x000000106c5b7824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000078537faeULL, 0x000fe2000d101c46ULL,
0x000000105a5a7824ULL, 0x100fe400078e0205ULL, 0x000000106a577824ULL, 0x000fe200078e0205ULL,
0x00000000685b7faeULL, 0x0003e8000d901c46ULL, 0x000000002c5a7faeULL, 0x0003e8000e101c46ULL,
0x000000001a577faeULL, 0x0003e2000e901c46ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a80aff6879a7ULL, 0x0022620008500009ULL, 0x000000105c5c7824ULL, 0x000fe200078e025dULL,
0x00000073ff0075a7ULL, 0x000ea40008040045ULL, 0x0000000000082947ULL, 0x006fea0003800000ULL,
0x0106b073ff0075a7ULL, 0x000e640008040149ULL, 0x000000f000bca947ULL, 0x002fea0003800000ULL,
0x000000005c3c783bULL, 0x000e620000004200ULL, 0x000000074c2c7812ULL, 0x000fe200078e786bULL,
0x0000001052557824ULL, 0x000fe400078e025dULL, 0x0000000765077221ULL, 0x000fe20000010000ULL,
0x00001f486d6f7589ULL, 0x000fe200000e0000ULL, 0x0000001054547824ULL, 0x100fe400078e025dULL,
0x000000086b2c7824ULL, 0x000fe200078e022cULL, 0x00001f466d407589ULL, 0x0005e200000e0000ULL,
0x00000010645d7824ULL, 0x000fc600078e025dULL, 0x000000092c527c11ULL, 0x000fe2000f8e20ffULL,
0x000000005518783bULL, 0x000fe80000004200ULL, 0x00a00000522c783bULL, 0x000ee20000000200ULL,
0x00000018ff737819ULL, 0x002fe2000001143cULL, 0x000001003c317824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe2000001143dULL, 0x000001003d337824ULL, 0x040fe200078e00ffULL,
0x000088803c307816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000088803d327816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000088803e6d7816ULL, 0x004fc400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff727819ULL, 0x000fe2000001143eULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000006f2c2c9232ULL, 0x088fe20000000000ULL, 0x00000018ff707819ULL, 0x000fe2000001143fULL,
0x0000006f2e2e9232ULL, 0x000fe20000000000ULL, 0x00000018ff6c7819ULL, 0x000fe20000011418ULL,
0x000000402d2d9232ULL, 0x080fe20000000000ULL, 0x00000018ff6a7819ULL, 0x000fe20000011419ULL,
0x000000402f2f9232ULL, 0x000fe20000000000ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x000088801a647816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe2000001141aULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff747819ULL, 0x000fe4000001141bULL,
0x000054103c3c7816ULL, 0x002fe20000000073ULL, 0x000001003e737824ULL, 0x000fc800078e00ffULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x000054103d3d7816ULL, 0x004fe4000000006eULL,
0x000088803f6e7816ULL, 0x040fe400000000ffULL, 0x0000007300767306ULL, 0x0002a60000200c00ULL,
0x0000003c2c10723cULL, 0x000fea0000001810ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff737819ULL, 0x002fe2000001143eULL, 0x000001003f3d7824ULL, 0x000fe200078e00ffULL,
0x00008880183e7816ULL, 0x000fe200000000ffULL, 0x000000ffff3c7224ULL, 0x000fc400078e006eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000003c00757306ULL, 0x0005f00000200c00ULL, 0x0000003d00787306ULL, 0x000e620000200c00ULL,
0x000054106d3c7816ULL, 0x004fc40000000076ULL, 0x0000888019767816ULL, 0x000fca00000000ffULL,
0x0000007300737306ULL, 0x000ea20000200c00ULL, 0x00005410753d7816ULL, 0x002fce0000000078ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000003c2c14723cULL, 0x000fee0000001814ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143fULL,
0x00000100183f7824ULL, 0x000fc400078e00ffULL, 0x0001000018187824ULL, 0x000fc800078e00ffULL,
0x0000003c003d7306ULL, 0x0005e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fe4000001143fULL,
0x00000018ff187819ULL, 0x000fca0000011418ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x00005410733c7816ULL, 0x004fe20000000072ULL, 0x0000010019737824ULL, 0x040fe400078e00ffULL,
0x0001000019197824ULL, 0x000fc600078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011473ULL,
0x0000007600727306ULL, 0x0003f00000200c00ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x00000018ff767819ULL, 0x002fce0000011419ULL, 0x0000001800737306ULL, 0x0003e20000200c00ULL,
0x0000541072197816ULL, 0x004fce0000000075ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x000054103e187816ULL, 0x002fe2000000003fULL, 0x000001001b727824ULL, 0x000fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011472ULL, 0x0000003100317306ULL, 0x000e620000200c00ULL,
0x000000182c20723cULL, 0x000fee0000001820ULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000001001a187824ULL, 0x040fe200078e00ffULL, 0x000088801b197816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fc400078e00ffULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000003300337306ULL, 0x000ea20000200c00ULL,
0x0000541030307816ULL, 0x002fe40000000031ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x00000018ff1b7819ULL, 0x000fc6000001141bULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541032317816ULL, 0x004fce0000000033ULL, 0x0000007600757306ULL, 0x000e620000200c00ULL,
0x000000302c28723cULL, 0x000fe20000001828ULL, 0x000000005430783bULL, 0x000eac0000004200ULL,
0x0000001800777306ULL, 0x0007f00000200c00ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x0000541073187816ULL, 0x008fce000000006cULL, 0x00000019006c7306ULL, 0x0003f00000200c00ULL,
0x0000007900797306ULL, 0x000ee20000200c00ULL, 0x0000541075197816ULL, 0x002fce000000006aULL,
0x000000182c24723cULL, 0x000fe20000001824ULL, 0x0000007100717306ULL, 0x000fec0000200c00ULL,
0x0000541064187816ULL, 0x010fe20000000077ULL, 0x0000010030767824ULL, 0x004fe200078e00ffULL,
0x000054106c197816ULL, 0x008fe20000000079ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000888030647816ULL, 0x000fc400000000ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff6e7819ULL, 0x000fe20000011430ULL, 0x000000182c38723cULL, 0x000fe20000001838ULL,
0x00000018ff6d7819ULL, 0x000fe20000011431ULL, 0x0000001a00187306ULL, 0x0002a20000200c00ULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00008880327a7816ULL, 0x000fe400000000ffULL,
0x0000888033777816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x000fc40000011433ULL,
0x0000001b00197306ULL, 0x000ee20000200c00ULL, 0x00008880311a7816ULL, 0x002fe400000000ffULL,
0x0000541018187816ULL, 0x004fca0000000071ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x0000541019197816ULL, 0x008fce0000000074ULL, 0x0000006400717306ULL, 0x0005e20000200c00ULL,
0x000000182c34723cULL, 0x000fe20000001834ULL, 0x000054103d3d7816ULL, 0x002fcc0000000070ULL,
0x0000007600747306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011432ULL,
0x000000074a187812ULL, 0x000fe200078e786bULL, 0x0000010031197824ULL, 0x000fe200078e00ffULL,
0x0000003c2c1c723cULL, 0x000fe6000000181cULL, 0x0000001a002d7306ULL, 0x0003e20000200c00ULL,
0x000000005d3c783bULL, 0x000ee20000004200ULL, 0x000000086b187824ULL, 0x000fc400078e0218ULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe20000011419ULL,
0x00000100322c7824ULL, 0x000fe200078e00ffULL, 0x0000000918647c11ULL, 0x004fe2000f8e20ffULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff2f7819ULL, 0x000fe20000011430ULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x00a000006418783bULL, 0x002e620000000200ULL, 0x00000018ff307819ULL, 0x000fe20000011431ULL,
0x0000010033317824ULL, 0x040fe200078e00ffULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x0001000033337824ULL, 0x000fc400078e00ffULL,
0x00000018ff317819ULL, 0x000fc60000011431ULL, 0x00000018ff337819ULL, 0x000fe40000011433ULL,
0x0000002c00797306ULL, 0x0009e20000200c00ULL, 0x000054102d2d7816ULL, 0x004fce000000002eULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00005410712c7816ULL, 0x010fce0000000074ULL,
0x0000002f002f7306ULL, 0x000ea20000200c00ULL, 0x000088803c767816ULL, 0x008fe400000000ffULL,
0x00000018ff737819ULL, 0x000fe4000001143cULL, 0x00000018ff727819ULL, 0x000fe4000001143dULL,
0x00000018ff6a7819ULL, 0x000fe2000001143eULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fe2000001143fULL, 0x0000006f18189232ULL, 0x002fc40000000000ULL,
0x0000006f1a1a9232ULL, 0x000fe40000000000ULL, 0x0000004019199232ULL, 0x080fe40000000000ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x000000401b1b9232ULL, 0x000fe20000000000ULL,
0x000088803d407816ULL, 0x000fe400000000ffULL, 0x000000414400720cULL, 0x000fc80003f24070ULL,
0x0000002c1828723cULL, 0x000fe20000001828ULL, 0x0000007700777306ULL, 0x000fec0000200c00ULL,
0x000001003c2c7824ULL, 0x040fe400078e00ffULL, 0x000001003d2d7824ULL, 0x040fe200078e00ffULL,
0x0000003100787306ULL, 0x0009620000200c00ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x00000018ff2e7819ULL, 0x000fe4000001143cULL,
0x0000002c00717306ULL, 0x0005e20000200c00ULL, 0x00000018ff317819ULL, 0x010fe4000001143dULL,
0x000088803e3d7816ULL, 0x000fca00000000ffULL, 0x0000002d006f7306ULL, 0x0007e20000200c00ULL,
0x000054102f2c7816ULL, 0x004fce000000006eULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00005410302d7816ULL, 0x008fe4000000006dULL, 0x000088803f307816ULL, 0x000fca00000000ffULL,
0x0000002c1810723cULL, 0x000fe20000001810ULL, 0x0000007500757306ULL, 0x000fec0000200c00ULL,
0x000001003e2c7824ULL, 0x040fe400078e00ffULL, 0x000001003f2d7824ULL, 0x040fe200078e00ffULL,
0x00000032006b7306ULL, 0x000ea20000200c00ULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fc4000001142dULL, 0x00000018ff2f7819ULL, 0x000fe4000001143eULL,
0x0000003300747306ULL, 0x000ee20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fce000001143fULL,
0x0000002c00327306ULL, 0x0003f00000200c00ULL, 0x0000002d00337306ULL, 0x000be20000200c00ULL,
0x000054107a2c7816ULL, 0x002fce0000000079ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x00005410772d7816ULL, 0x020fce0000000078ULL, 0x0000004000407306ULL, 0x000f220000200c00ULL,
0x0000002c1814723cULL, 0x000fee0000001814ULL, 0x000054106b2c7816ULL, 0x004fe20000000070ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00005410742d7816ULL, 0x008fce0000000075ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000002c181c723cULL, 0x000fee000000181cULL,
0x0000002e002e7306ULL, 0x000ea20000200c00ULL, 0x00005410762c7816ULL, 0x002fe40000000071ULL,
0x00005410402d7816ULL, 0x010fca000000006fULL, 0x0000003100317306ULL, 0x000e640000200c00ULL,
0x0000002c1820723cULL, 0x000fec0000001820ULL, 0x0000003000307306ULL, 0x000ee20000200c00ULL,
0x000054102e2c7816ULL, 0x004fe40000000073ULL, 0x00005410312d7816ULL, 0x002fca0000000072ULL,
0x0000006a006a7306ULL, 0x000fe40000200c00ULL, 0x0000002c1824723cULL, 0x000fec0000001824ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410302d7816ULL, 0x008fce0000000033ULL,
0x0000003d003d7306ULL, 0x000e700000200c00ULL, 0x0000002f002f7306ULL, 0x000ea20000200c00ULL,
0x000054103d2c7816ULL, 0x002fce0000000032ULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000002c1838723cULL, 0x000fe20000001838ULL, 0x000054102f307816ULL, 0x004fe4000000006aULL,
0x000054103f317816ULL, 0x002fce000000006cULL, 0x000000301830723cULL, 0x000fe20000001834ULL,
0x0106b80aff1879a7ULL, 0x0002a20008500009ULL, 0x0106880affff79a7ULL, 0x0003e20008500009ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000007000e49947ULL, 0x000fde0003800000ULL,
0x00000019080075a7ULL, 0x004ea2000802007fULL, 0x00000060451a7811ULL, 0x000fc800078e40ffULL,
0x0000001a441b7248ULL, 0x000fe20007fe0000ULL, 0x0000000803347c24ULL, 0x000fc8000f8e021aULL,
0x000000011b1b7824ULL, 0x000fe400078e0a1aULL, 0x00000001512d7824ULL, 0x100fe400078e0234ULL,
0x000000014f2f7824ULL, 0x000fe200078e0234ULL, 0x000000201b2c7807ULL, 0x000fe20000000000ULL,
0x000001002d1a7825ULL, 0x000fe200078e0066ULL, 0x0000000000081947ULL, 0x004fec0003800000ULL,
0x0106b819ff0075a7ULL, 0x000ea40008020149ULL, 0x000000e000e49947ULL, 0x004fea0003800000ULL,
0x0000002c0f187248ULL, 0x000fe20007fe0000ULL, 0x000001002f2c7825ULL, 0x000fe200078e0066ULL,
0x000000491a2e7210ULL, 0x000fc60007f3e0ffULL, 0x0000000118357824ULL, 0x000fe200078e0a0fULL,
0x000000492c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000014d197824ULL, 0x100fe400078e0234ULL,
0x000000014b377824ULL, 0x000fe200078e0234ULL, 0x000000355000720cULL, 0x080fe20003f46070ULL,
0x000000ffff2f7224ULL, 0x000fe200008e061bULL, 0x000000354e00720cULL, 0x080fe20003f26070ULL,
0x00000100191a7825ULL, 0x000fe200078e0066ULL, 0x000000354a00720cULL, 0x000fc60003f86070ULL,
0x0000010037187825ULL, 0x000fe200078e0066ULL, 0x000000491a1a7210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200018e062dULL, 0x000000354c00720cULL, 0x000fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200028e061bULL, 0x0000004918187210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e637faeULL, 0x000fe8000d101c46ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000002c627faeULL, 0x000fea000c901c46ULL,
0x000000001a617faeULL, 0x000fe8000d901c46ULL, 0x0000000018607faeULL, 0x0005e2000e101c46ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106b00aff7479a7ULL, 0x0006e20008500009ULL,
0x00000069ff0075a7ULL, 0x0006e20008020044ULL, 0x0106280a0f1879a7ULL, 0x004ea40008500009ULL,
0x010628190f0075a7ULL, 0x004ea40008040149ULL, 0x000000e00074a947ULL, 0x00efea0003800000ULL,
0x0100800043197984ULL, 0x000e620000000800ULL, 0x00000001ff2c7424ULL, 0x000fc600078e00ffULL,
0x0102800043657984ULL, 0x0004a20000000800ULL, 0x000000061900720bULL, 0x002fda0003f5d000ULL,
0x0000000000187806ULL, 0x000fc800010e0100ULL, 0x0000ffff182d7812ULL, 0x000fda000784c0ffULL,
0x0000000000cca947ULL, 0x004fea0003800000ULL, 0x000000061900720bULL, 0x000fe40003f54000ULL,
0x0000001906187209ULL, 0x000fca0007810000ULL, 0x80000018061a7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400010e0100ULL,
0x0000001a001b7308ULL, 0x000e620000000800ULL, 0x000000014700780cULL, 0x000fe40003f45270ULL,
0x0000ffff062c7812ULL, 0x000fc800078e3cffULL, 0x0000002c2dff7212ULL, 0x000fce000786c0ffULL,
0x010480184300a388ULL, 0x000fe20000000800ULL, 0x0000001b07077220ULL, 0x002fc60000410000ULL,
0x00001f481b067589ULL, 0x000e6400000e0000ULL, 0x80000018192c3221ULL, 0x000fe40000010000ULL,
0x00001f461b197589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL,
0x0000002c000c3308ULL, 0x0007240000000800ULL, 0x00000001ff2c7807ULL, 0x008fe20001800000ULL,
0x0000000628287220ULL, 0x082fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000610107220ULL, 0x080fe20000410000ULL, 0x0000000611117220ULL, 0x080fe20000410000ULL,
0x0000000614147220ULL, 0x080fe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x000fe20000410000ULL,
0x000000192a2a7220ULL, 0x084fe20000410000ULL, 0x000000192b2b7220ULL, 0x080fe20000410000ULL,
0x0000001912127220ULL, 0x080fe20000410000ULL, 0x0000001913137220ULL, 0x080fe20000410000ULL,
0x0000001916167220ULL, 0x080fe20000410000ULL, 0x0000001917177220ULL, 0x080fe20000410000ULL,
0x000000191e1e7220ULL, 0x080fe20000410000ULL, 0x000000191f1f7220ULL, 0x080fe20000410000ULL,
0x0000001922227220ULL, 0x080fe20000410000ULL, 0x0000001923237220ULL, 0x080fe20000410000ULL,
0x0000001926267220ULL, 0x080fe20000410000ULL, 0x0000001927277220ULL, 0x080fe20000410000ULL,
0x000000193a3a7220ULL, 0x080fe20000410000ULL, 0x000000193b3b7220ULL, 0x080fe20000410000ULL,
0x0000001932327220ULL, 0x080fe20000410000ULL, 0x0000001933337220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fc400078e0018ULL, 0x000000650c653220ULL, 0x010fce0000410000ULL,
0x0000000000081947ULL, 0x000fea0003800000ULL, 0x0106a869ff0075a7ULL, 0x000e640008020149ULL,
0x000000dc00989947ULL, 0x002fea0003800000ULL, 0x00000000423c783bULL, 0x000e620000004200ULL,
0x0000000cff6d723eULL, 0x000fe400000000ffULL, 0x000099102c2c7816ULL, 0x000fe200000000ffULL,
0x00a800005834783bULL, 0x000fe20000000200ULL, 0x000054106d6d7816ULL, 0x000fe4000000006dULL,
0x000000ff2c00720cULL, 0x000fe20003f25270ULL, 0x000000005f18783bULL, 0x000fe80000004200ULL,
0x00001f486d697589ULL, 0x000ea800000e0000ULL, 0x00001f466d687589ULL, 0x000ee200000e0000ULL,
0x000001003c2d7824ULL, 0x042fe200078e00ffULL, 0x000088803c407816ULL, 0x040fe200000000ffULL,
0x000001003d707824ULL, 0x040fe200078e00ffULL, 0x000088803d717816ULL, 0x040fe200000000ffULL,
0x0000006934349232ULL, 0x084fe20000000000ULL, 0x00000018ff417819ULL, 0x000fe2000001142dULL,
0x0000006936369232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011470ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x000fe2000001143cULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001143dULL,
0x000100003d3d7824ULL, 0x000fc400078e00ffULL, 0x0000006835359232ULL, 0x088fe20000000000ULL,
0x00000018ff6c7819ULL, 0x000fe2000001143eULL, 0x0000006837379232ULL, 0x000fe20000000000ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000005e2c783bULL, 0x000ea20000004200ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff6f7819ULL, 0x000fe4000001143fULL, 0x00000018ff6e7819ULL, 0x000fe20000011418ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff6a7819ULL, 0x000fc40000011419ULL,
0x00000018ff707819ULL, 0x000fe4000001141aULL, 0x0000541040407816ULL, 0x002fc60000000041ULL,
0x0000007300767306ULL, 0x000e700000200c00ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541071417816ULL, 0x002fce0000000076ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fe2000001141bULL, 0x000000403428723cULL, 0x000fec0000001828ULL,
0x0000003c00737306ULL, 0x000e620000200c00ULL, 0x000088802f797816ULL, 0x004fe400000000ffULL,
0x00000018ff417819ULL, 0x000fca000001142cULL, 0x0000003d00407306ULL, 0x000ea20000200c00ULL,
0x00005410733c7816ULL, 0x002fce0000000072ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000088803f737816ULL, 0x000fe400000000ffULL, 0x000088803e727816ULL, 0x000fe400000000ffULL,
0x00005410403d7816ULL, 0x004fe2000000006bULL, 0x000001003e6b7824ULL, 0x040fe400078e00ffULL,
0x0000007200407306ULL, 0x0003e20000200c00ULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x0000003c3410723cULL, 0x000fe80000001810ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff727819ULL, 0x002fe2000001143eULL, 0x000100003f3e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001146bULL, 0x000001003f6b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003c003d7306ULL, 0x000e620000200c00ULL,
0x00000018ff767819ULL, 0x000fe4000001146bULL, 0x00000018ff6b7819ULL, 0x000fca000001142dULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00005410403c7816ULL, 0x002fce000000003dULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x0000888018407816ULL, 0x000fe400000000ffULL,
0x00005410733d7816ULL, 0x004fca0000000076ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000088801b767816ULL, 0x000fe200000000ffULL, 0x0000003c3414723cULL, 0x000fec0000001814ULL,
0x00000072003f7306ULL, 0x0004e20000200c00ULL, 0x00000100193d7824ULL, 0x000fe400078e00ffULL,
0x00000100183c7824ULL, 0x000fca00078e00ffULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x0000888019727816ULL, 0x004fe400000000ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000003d00737306ULL, 0x0003e20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fce000001143cULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054103e3d7816ULL, 0x002fe2000000006fULL,
0x00010000193e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001143eULL,
0x0000001800197306ULL, 0x0003f00000200c00ULL, 0x0000003c00777306ULL, 0x0007e20000200c00ULL,
0x000001001a187824ULL, 0x002fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x000054103f3c7816ULL, 0x008fe4000000006cULL,
0x00000018ff6c7819ULL, 0x000fca000001142eULL, 0x0000003c341c723cULL, 0x000fe2000000181cULL,
0x0000006a006a7306ULL, 0x000fec0000200c00ULL, 0x00005410723d7816ULL, 0x004fe40000000073ULL,
0x0000001800737306ULL, 0x0005e20000200c00ULL, 0x00005410403c7816ULL, 0x002fc40000000077ULL,
0x000088801a407816ULL, 0x040fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc6000001142fULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000541019187816ULL, 0x004fe2000000006eULL, 0x000001001b197824ULL, 0x040fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000003c343c723cULL, 0x000fe20000001820ULL, 0x000000005920783bULL, 0x000ea20000004200ULL,
0x00000018ff777819ULL, 0x000fe20000011419ULL, 0x0000004000407306ULL, 0x000ee20000200c00ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x000054106f197816ULL, 0x002fca000000006aULL,
0x0000007600767306ULL, 0x000fe40000200c00ULL, 0x000000183424723cULL, 0x000fec0000001824ULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x0000541040187816ULL, 0x008fe40000000073ULL,
0x000088802c737816ULL, 0x000fca00000000ffULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000541076197816ULL, 0x002fce0000000077ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000183438723cULL, 0x000fe20000001838ULL, 0x00000018ff6e7819ULL, 0x004fcc0000011421ULL,
0x0000001a00197306ULL, 0x0002a20000200c00ULL, 0x00000018ff6f7819ULL, 0x000fe40000011420ULL,
0x00000018ff407819ULL, 0x000fe40000011422ULL, 0x00000018ff6a7819ULL, 0x000fc60000011423ULL,
0x0000001b00767306ULL, 0x000ee20000200c00ULL, 0x000088802d1a7816ULL, 0x002fe400000000ffULL,
0x0000541019187816ULL, 0x004fe20000000070ULL, 0x000001002c197824ULL, 0x000fc800078e00ffULL,
0x0000007300707306ULL, 0x000fe20000200c00ULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011419ULL, 0x0000541076197816ULL, 0x008fc80000000071ULL,
0x0000007700717306ULL, 0x0002a20000200c00ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x000000183430723cULL, 0x000fea0000001830ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000088802e777816ULL, 0x002fe200000000ffULL, 0x000001002d187824ULL, 0x000fc400078e00ffULL,
0x000000ffff357224ULL, 0x000fe400078e001aULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff367819ULL, 0x000fe20000011418ULL, 0x000001002e377824ULL, 0x040fe200078e00ffULL,
0x00a800005618783bULL, 0x000e620000000200ULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fc80000011437ULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000003600367306ULL, 0x000ef00000200c00ULL, 0x0000002d00347306ULL, 0x0009f00000200c00ULL,
0x0000006b006b7306ULL, 0x000f620000200c00ULL, 0x000001002f2d7824ULL, 0x010fc400078e00ffULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00787306ULL, 0x0005220000200c00ULL, 0x00000018ff2f7819ULL, 0x000fe2000001142fULL,
0x0000006918189232ULL, 0x002fcc0000000000ULL, 0x0000002d00737306ULL, 0x0007e20000200c00ULL,
0x00005410702c7816ULL, 0x004fe20000000071ULL, 0x000000691a1a9232ULL, 0x000fe20000000000ULL,
0x0000888020717816ULL, 0x000fe200000000ffULL, 0x0000006819199232ULL, 0x080fe40000000000ULL,
0x000000681b1b9232ULL, 0x000fe40000000000ULL, 0x0000003700767306ULL, 0x000fe20000200c00ULL,
0x00005410352d7816ULL, 0x008fe40000000036ULL, 0x0000888021357816ULL, 0x000fca00000000ffULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000002c1828723cULL, 0x000fee0000001828ULL,
0x0000007900707306ULL, 0x000e620000200c00ULL, 0x00000100212d7824ULL, 0x040fe400078e00ffULL,
0x0001000021217824ULL, 0x000fc400078e00ffULL, 0x00000100202c7824ULL, 0x040fe200078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x0000002f00377306ULL, 0x000aa20000200c00ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff207819ULL, 0x000fc60000011420ULL,
0x0000007700777306ULL, 0x000ee20000200c00ULL, 0x00005410342f7816ULL, 0x020fe4000000006bULL,
0x00000080456b7811ULL, 0x000fca00078e40ffULL, 0x0000002e00697306ULL, 0x0009f00000200c00ULL,
0x0000006c006c7306ULL, 0x000f620000200c00ULL, 0x00005410782e7816ULL, 0x010fe40000000041ULL,
0x0000888022417816ULL, 0x000fca00000000ffULL, 0x0000002e1810723cULL, 0x000fe20000001810ULL,
0x0000002d00367306ULL, 0x0003ec0000200c00ULL, 0x00000008032e7c24ULL, 0x000fe4000f8e026bULL,
0x00000021002f7306ULL, 0x0005e20000200c00ULL, 0x00005410702d7816ULL, 0x002fce0000000073ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541037217816ULL, 0x004fe20000000072ULL,
0x000000ffff377224ULL, 0x000fe200078e0041ULL, 0x0106b80aff7279a7ULL, 0x000e620008500009ULL,
0x000000014f417824ULL, 0x000fc800078e022eULL, 0x0000002c00687306ULL, 0x0006b00000200c00ULL,
0x0000003500357306ULL, 0x000f220000200c00ULL, 0x00005410772c7816ULL, 0x008fce0000000076ULL,
0x0000002000347306ULL, 0x000be20000200c00ULL, 0x0000002c1814723cULL, 0x000fe20000001814ULL,
0x00000073080075a7ULL, 0x002e6c00080c007fULL, 0x00000100222d7824ULL, 0x040fe200078e00ffULL,
0x0000541069207816ULL, 0x020fe2000000006cULL, 0x0000000151697824ULL, 0x000fe200078e022eULL,
0x00005410712c7816ULL, 0x004fe20000000068ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fe2000001142dULL, 0x0000010069687825ULL, 0x100fe200078e0066ULL,
0x0000888023717816ULL, 0x000fe200000000ffULL, 0x00000020181c723cULL, 0x000fe4000000181cULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000004968707210ULL, 0x000fe20007f5e0ffULL,
0x0000002d006c7306ULL, 0x0009e60000200c00ULL, 0x0000010041207825ULL, 0x000fc600078e0066ULL,
0x0000004920687210ULL, 0x000fe20007f7e0ffULL, 0x0000010023207824ULL, 0x000fe200078e00ffULL,
0x00005410352d7816ULL, 0x010fe20000000036ULL, 0x0000006e006e7306ULL, 0x000ee20000200c00ULL,
0x000000ffff357224ULL, 0x000fe400078e0071ULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x000000ffff717224ULL, 0x000fe400010e0669ULL, 0x0000002c183c723cULL, 0x000fe2000000183cULL,
0x000000ffff697224ULL, 0x000fe200018e0621ULL, 0x0000003700377306ULL, 0x000f220000200c00ULL,
0x000000014d217824ULL, 0x000fc800078e022eULL, 0x00010000232d7824ULL, 0x000fe200078e00ffULL,
0x0000006b442c7248ULL, 0x000fe40007fe0000ULL, 0x0000003500357306ULL, 0x000fe40000200c00ULL,
0x00000018ff417819ULL, 0x000fe2000001142dULL, 0x000000012c2c7824ULL, 0x000fca00078e0a6bULL,
0x0000002000367306ULL, 0x0005700000200c00ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541034207816ULL, 0x004fe2000000006fULL, 0x000000014b6f7824ULL, 0x000fe200078e022eULL,
0x00000018ff347819ULL, 0x000fe20000011422ULL, 0x0000010021227825ULL, 0x000fe200078e0066ULL,
0x000054102f217816ULL, 0x008fc4000000006eULL, 0x000000202c2e7807ULL, 0x000fe20000000000ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000049222c7210ULL, 0x000fe20007f5e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0066ULL, 0x0000002e0f2e7248ULL, 0x000fe20007fe0000ULL,
0x000000201824723cULL, 0x000fe40000001824ULL, 0x000000ffff2d7224ULL, 0x000fe200010e0623ULL,
0x000000496e227210ULL, 0x000fe20007f5e0ffULL, 0x00000034002f7306ULL, 0x000ea20000200c00ULL,
0x000000012e777824ULL, 0x000fc400078e0a0fULL, 0x0000541037207816ULL, 0x010fe2000000006cULL,
0x000000ffff237224ULL, 0x000fe200010e066fULL, 0x0000541035217816ULL, 0x020fe40000000036ULL,
0x000000775000720cULL, 0x080fe20003f46070ULL, 0x0000004100417306ULL, 0x000ee20000200c00ULL,
0x000000774e00720cULL, 0x080fe40003f66070ULL, 0x000000774c00720cULL, 0x080fe20003f86070ULL,
0x000000201838723cULL, 0x000fe20000001838ULL, 0x000000774a00720cULL, 0x000fcc0003fa6070ULL,
0x000054102f207816ULL, 0x004fe40000000040ULL, 0x0000541041217816ULL, 0x008fce000000006aULL,
0x000000201830723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000086947ULL, 0x002fde0003800000ULL, 0x0106b873ff0075a7ULL, 0x000e6400080c0149ULL,
0x000000cc0090e947ULL, 0x002fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000070537faeULL, 0x000fe8000d101c46ULL, 0x00000000685b7faeULL, 0x0003e8000d901c46ULL,
0x000000002c5a7faeULL, 0x0003e8000e101c46ULL, 0x0000000022577faeULL, 0x0003e2000e901c46ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106a80aff6879a7ULL, 0x0022620008500009ULL,
0x00000075ff0075a7ULL, 0x000ea40008040045ULL, 0x0000000000082947ULL, 0x006fea0003800000ULL,
0x0106b075ff0075a7ULL, 0x000e640008040149ULL, 0x000000cc006ca947ULL, 0x002fea0003800000ULL,
0x000000005c34783bULL, 0x000e620000004200ULL, 0x0000000765077221ULL, 0x000fc60000010000ULL,
0x000000005520783bULL, 0x000fe80000004200ULL, 0x00a80000522c783bULL, 0x000fe80000000200ULL,
0x00001f486d6f7589ULL, 0x000ea800000e0000ULL, 0x00001f466d6a7589ULL, 0x00072200000e0000ULL,
0x0000010034197824ULL, 0x002fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011434ULL,
0x0000010035707824ULL, 0x040fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe20000011435ULL,
0x00000100366d7824ULL, 0x008fe200078e00ffULL, 0x0000888034187816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x0000888035717816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011419ULL,
0x0000001800417306ULL, 0x0003e20000200c00ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000006f2c2c9232ULL, 0x084fe20000000000ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000006f2e2e9232ULL, 0x000fe20000000000ULL, 0x00000018ff737819ULL, 0x000fe20000011470ULL,
0x0000006a2d2d9232ULL, 0x090fe20000000000ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x0000006a2f2f9232ULL, 0x000fe20000000000ULL,
0x00000018ff6c7819ULL, 0x000fe20000011436ULL, 0x000000005418783bULL, 0x002e620000004200ULL,
0x00000018ff747819ULL, 0x000fc40000011437ULL, 0x00000018ff727819ULL, 0x000fe40000011420ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011421ULL,
0x0000541041407816ULL, 0x004fca0000000040ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x000fce0000011422ULL, 0x0000003400347306ULL, 0x000eb00000200c00ULL,
0x0000003500357306ULL, 0x000ee20000200c00ULL, 0x0000541034347816ULL, 0x004fce0000000075ULL,
0x0000007100767306ULL, 0x000fe20000200c00ULL, 0x000088801a797816ULL, 0x002fe400000000ffULL,
0x0000541035357816ULL, 0x008fca000000006eULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x00000018ff6e7819ULL, 0x000fe20000011419ULL, 0x000000342c10723cULL, 0x000fec0000001810ULL,
0x0000004100717306ULL, 0x0003e20000200c00ULL, 0x0000010037347824ULL, 0x040fe200078e00ffULL,
0x0000888037357816ULL, 0x000fcc00000000ffULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541076417816ULL, 0x002fe40000000073ULL, 0x00000018ff757819ULL, 0x000fe40000011434ULL,
0x00000018ff737819ULL, 0x000fc60000011423ULL, 0x000000402c28723cULL, 0x000fe20000001828ULL,
0x0000003500357306ULL, 0x000fec0000200c00ULL, 0x0000888036407816ULL, 0x040fe200000000ffULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000007500767306ULL, 0x000e620000200c00ULL,
0x00000018ff417819ULL, 0x000fc60000011418ULL, 0x00000018ff347819ULL, 0x000fe20000011436ULL,
0x0001000037367824ULL, 0x000fc600078e00ffULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x0000541035357816ULL, 0x002fce0000000076ULL, 0x0000003400377306ULL, 0x0005f00000200c00ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541040347816ULL, 0x004fe4000000006dULL,
0x00000018ff6d7819ULL, 0x000fc40000011436ULL, 0x0000888020367816ULL, 0x040fe400000000ffULL,
0x0000888021407816ULL, 0x000fe200000000ffULL, 0x000000342c14723cULL, 0x000fe20000001814ULL,
0x0000006d006d7306ULL, 0x000e6c0000200c00ULL, 0x0000010020357824ULL, 0x000fc400078e00ffULL,
0x0000010021347824ULL, 0x040fe200078e00ffULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000003500777306ULL, 0x0003f00000200c00ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000054106d357816ULL, 0x002fc40000000074ULL,
0x00000018ff747819ULL, 0x000fca0000011421ULL, 0x0000003400757306ULL, 0x000e700000200c00ULL,
0x00000020006d7306ULL, 0x0005e20000200c00ULL, 0x0000541040217816ULL, 0x002fce0000000075ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541036207816ULL, 0x004fe40000000077ULL,
0x0000888022407816ULL, 0x000fca00000000ffULL, 0x000000202c3c723cULL, 0x000fe2000000183cULL,
0x0000007000707306ULL, 0x000fec0000200c00ULL, 0x0000010022207824ULL, 0x040fe200078e00ffULL,
0x0000888023217816ULL, 0x000fe200000000ffULL, 0x0000007400757306ULL, 0x0004e20000200c00ULL,
0x0001000022227824ULL, 0x000fc400078e00ffULL, 0x00000018ff207819ULL, 0x000fca0000011420ULL,
0x0000002000777306ULL, 0x0003e20000200c00ULL, 0x00000018ff747819ULL, 0x004fce000001141bULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x000054106d207816ULL, 0x002fe20000000072ULL,
0x0000010023727824ULL, 0x040fe400078e00ffULL, 0x0001000023237824ULL, 0x000fc600078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011472ULL, 0x00000021006d7306ULL, 0x0007f00000200c00ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000541075217816ULL, 0x008fce0000000070ULL,
0x000000202c24723cULL, 0x000fe20000001824ULL, 0x0000006c006c7306ULL, 0x000eec0000200c00ULL,
0x0000541040207816ULL, 0x004fe40000000077ULL, 0x000054106d217816ULL, 0x002fe20000000076ULL,
0x0000007300737306ULL, 0x000fec0000200c00ULL, 0x000000202c38723cULL, 0x000fe20000001838ULL,
0x0000541037347816ULL, 0x008fe2000000006cULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x00000018ff6c7819ULL, 0x000fc8000001141aULL, 0x00000018ff207819ULL, 0x000fe20000011422ULL,
0x000000342c1c723cULL, 0x000fe2000000181cULL, 0x00000018ff217819ULL, 0x000fe20000011423ULL,
0x000000005d34783bULL, 0x000e620000004200ULL, 0x0000010018237824ULL, 0x040fe200078e00ffULL,
0x0000888018227816ULL, 0x040fe200000000ffULL, 0x0000002000207306ULL, 0x000ea20000200c00ULL,
0x0001000018187824ULL, 0x000fe400078e00ffULL, 0x00000018ff237819ULL, 0x000fc60000011423ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000002100767306ULL, 0x000ee20000200c00ULL,
0x0000541020207816ULL, 0x004fce0000000071ULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x0000888019717816ULL, 0x000fe400000000ffULL, 0x0000541076217816ULL, 0x008fca0000000073ULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x000001001a737824ULL, 0x040fe200078e00ffULL,
0x000088801b767816ULL, 0x000fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x000000202c2c723cULL, 0x000fe20000001830ULL, 0x00a800006430783bULL, 0x000ee60000000200ULL,
0x00000018007a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x0000010019217824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x002fe20000011434ULL, 0x000000ffff207224ULL, 0x000fc400078e0071ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000541022187816ULL, 0x004fe40000000023ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000002000207306ULL, 0x000fe20000200c00ULL,
0x0000888034757816ULL, 0x000fe400000000ffULL, 0x00000018ff707819ULL, 0x000fc40000011435ULL,
0x00000018ff407819ULL, 0x000fe40000011436ULL, 0x00000018ff6d7819ULL, 0x000fe20000011437ULL,
0x0000002100217306ULL, 0x000e700000200c00ULL, 0x0000001900717306ULL, 0x0005220000200c00ULL,
0x0000006f30309232ULL, 0x008fce0000000000ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000001001b197824ULL, 0x044fe400078e00ffULL, 0x0000006f32329232ULL, 0x000fe40000000000ULL,
0x000100001b1b7824ULL, 0x000fe400078e00ffULL, 0x0000006a31319232ULL, 0x080fe20000000000ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000006a33339232ULL, 0x000fe20000000000ULL,
0x0000007300787306ULL, 0x000ea20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fc4000001141bULL,
0x0000006b4400720cULL, 0x000fca0003f24070ULL, 0x0000001900777306ULL, 0x0003f00000200c00ULL,
0x0000007600767306ULL, 0x000ee20000200c00ULL, 0x0000541020197816ULL, 0x002fe40000000021ULL,
0x0000888035217816ULL, 0x000fca00000000ffULL, 0x000000183028723cULL, 0x000fe20000001828ULL,
0x0000001a00737306ULL, 0x0003ec0000200c00ULL, 0x0000010034187824ULL, 0x040fe400078e00ffULL,
0x0000010035197824ULL, 0x040fe200078e00ffULL, 0x0000006c006c7306ULL, 0x000f620000200c00ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x00010000351a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000001800207306ULL, 0x0003f00000200c00ULL,
0x0000001900227306ULL, 0x0009e20000200c00ULL, 0x000054107a187816ULL, 0x002fc40000000041ULL,
0x00000018ff417819ULL, 0x000fe4000001141aULL, 0x00008880371a7816ULL, 0x000fc600000000ffULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541071197816ULL, 0x010fe4000000006eULL,
0x0000888036717816ULL, 0x000fca00000000ffULL, 0x000000183010723cULL, 0x000fe20000001810ULL,
0x0000001b00237306ULL, 0x00032c0000200c00ULL, 0x0000010036187824ULL, 0x040fe400078e00ffULL,
0x0000010037197824ULL, 0x040fe200078e00ffULL, 0x0000003400357306ULL, 0x000fe20000200c00ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x00000018ff1b7819ULL, 0x002fe40000011436ULL, 0x0000001800347306ULL, 0x0005e20000200c00ULL,
0x00000018ff367819ULL, 0x000fce0000011437ULL, 0x00000019006f7306ULL, 0x0007e20000200c00ULL,
0x0000541079187816ULL, 0x004fce0000000078ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541076197816ULL, 0x008fce0000000077ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x000000183014723cULL, 0x000fee0000001814ULL, 0x0000004100417306ULL, 0x000ea20000200c00ULL,
0x0000541073187816ULL, 0x020fe4000000006cULL, 0x0000541023197816ULL, 0x010fca0000000074ULL,
0x0000007100717306ULL, 0x000ee40000200c00ULL, 0x00000018301c723cULL, 0x000fec000000181cULL,
0x0000001a001a7306ULL, 0x000f220000200c00ULL, 0x0000541035187816ULL, 0x002fe40000000072ULL,
0x0000541041197816ULL, 0x004fca0000000070ULL, 0x0000007500757306ULL, 0x000e640000200c00ULL,
0x000000183024723cULL, 0x000fec0000001824ULL, 0x0000002100217306ULL, 0x000ea20000200c00ULL,
0x0000541071187816ULL, 0x008fe40000000034ULL, 0x000054101a197816ULL, 0x010fc4000000006fULL,
0x0000541075207816ULL, 0x002fc60000000020ULL, 0x0000004000407306ULL, 0x000fe40000200c00ULL,
0x000000183038723cULL, 0x000fe20000001838ULL, 0x0000541021217816ULL, 0x004fca0000000022ULL,
0x0000006d006d7306ULL, 0x000fe40000200c00ULL, 0x000000203020723cULL, 0x000fec000000183cULL,
0x0000001b001b7306ULL, 0x000e700000200c00ULL, 0x0000003600367306ULL, 0x000ea20000200c00ULL,
0x000054101b187816ULL, 0x002fc40000000040ULL, 0x0000541036197816ULL, 0x004fce000000006dULL,
0x000000183030723cULL, 0x000fe2000000182cULL, 0x0106b80aff1879a7ULL, 0x0002a20008500009ULL,
0x0106900affff79a7ULL, 0x0003e20008500009ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000004c00409947ULL, 0x000fde0003800000ULL, 0x00000019080075a7ULL, 0x004ea2000802007fULL,
0x000000a0451a7811ULL, 0x000fc800078e40ffULL, 0x0000001a441b7248ULL, 0x000fe20007fe0000ULL,
0x0000000803347c24ULL, 0x000fc8000f8e021aULL, 0x000000011b1b7824ULL, 0x000fe400078e0a1aULL,
0x00000001512d7824ULL, 0x100fe400078e0234ULL, 0x000000014f2f7824ULL, 0x000fe200078e0234ULL,
0x000000201b2c7807ULL, 0x000fe20000000000ULL, 0x000001002d1a7825ULL, 0x000fe200078e0066ULL,
0x0000000000081947ULL, 0x004fec0003800000ULL, 0x0106b819ff0075a7ULL, 0x000ea40008020149ULL,
0x000000bc00b89947ULL, 0x004fea0003800000ULL, 0x0000002c0f187248ULL, 0x000fe20007fe0000ULL,
0x000001002f2c7825ULL, 0x000fe200078e0066ULL, 0x000000491a2e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000118357824ULL, 0x000fe200078e0a0fULL, 0x000000492c2c7210ULL, 0x000fe20007f7e0ffULL,
0x000000014d197824ULL, 0x100fe400078e0234ULL, 0x000000014b377824ULL, 0x000fe200078e0234ULL,
0x000000355000720cULL, 0x080fe20003f46070ULL, 0x000000ffff2f7224ULL, 0x000fe200008e061bULL,
0x000000354e00720cULL, 0x080fe20003f26070ULL, 0x00000100191a7825ULL, 0x000fe200078e0066ULL,
0x000000354a00720cULL, 0x000fc60003f86070ULL, 0x0000010037187825ULL, 0x000fe200078e0066ULL,
0x000000491a1a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200018e062dULL,
0x000000354c00720cULL, 0x000fe20003f66070ULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x0000004918187210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e637faeULL, 0x000fe8000d101c46ULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0x000000002c627faeULL, 0x000fea000c901c46ULL, 0x000000001a617faeULL, 0x000fe8000d901c46ULL,
0x0000000018607faeULL, 0x0005e2000e101c46ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106b00aff7479a7ULL, 0x0006e20008500009ULL, 0x00000069ff0075a7ULL, 0x0006e20008020044ULL,
0x0106480a0f1879a7ULL, 0x004ea40008500009ULL, 0x010648190f0075a7ULL, 0x004ea40008040149ULL,
0x000000bc0048a947ULL, 0x00efea0003800000ULL, 0x0101000043197984ULL, 0x000e620000000800ULL,
0x00000001ff2c7424ULL, 0x000fc600078e00ffULL, 0x0103000043657984ULL, 0x0004a20000000800ULL,
0x000000061900720bULL, 0x002fda0003f5d000ULL, 0x0000000000187806ULL, 0x000fc800010e0100ULL,
0x0000ffff182d7812ULL, 0x000fda000784c0ffULL, 0x0000000000cca947ULL, 0x004fea0003800000ULL,
0x000000061900720bULL, 0x000fe40003f54000ULL, 0x0000001906187209ULL, 0x000fca0007810000ULL,
0x80000018061a7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1a1a7820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x0000001a001b7308ULL, 0x000e620000000800ULL,
0x000000024700780cULL, 0x000fe40003f45270ULL, 0x0000ffff062c7812ULL, 0x000fc800078e3cffULL,
0x0000002c2dff7212ULL, 0x000fce000786c0ffULL, 0x010500184300a388ULL, 0x000fe20000000800ULL,
0x0000001b07077220ULL, 0x002fc60000410000ULL, 0x00001f481b067589ULL, 0x000e6400000e0000ULL,
0x80000018192c3221ULL, 0x000fe40000010000ULL, 0x00001f461b197589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b2c2c3820ULL, 0x000fc80000410000ULL, 0x0000002c000c3308ULL, 0x0007240000000800ULL,
0x00000001ff2c7807ULL, 0x008fe20001800000ULL, 0x0000000628287220ULL, 0x082fe20000410000ULL,
0x0000000629297220ULL, 0x080fe20000410000ULL, 0x0000000610107220ULL, 0x080fe20000410000ULL,
0x0000000611117220ULL, 0x080fe20000410000ULL, 0x0000000614147220ULL, 0x080fe20000410000ULL,
0x0000000615157220ULL, 0x080fe20000410000ULL, 0x000000061c1c7220ULL, 0x080fe20000410000ULL,
0x000000061d1d7220ULL, 0x080fe20000410000ULL, 0x0000000620207220ULL, 0x080fe20000410000ULL,
0x0000000621217220ULL, 0x080fe20000410000ULL, 0x0000000624247220ULL, 0x080fe20000410000ULL,
0x0000000625257220ULL, 0x080fe20000410000ULL, 0x0000000638387220ULL, 0x080fe20000410000ULL,
0x0000000639397220ULL, 0x080fe20000410000ULL, 0x0000000630307220ULL, 0x080fe20000410000ULL,
0x0000000631317220ULL, 0x000fe20000410000ULL, 0x000000192a2a7220ULL, 0x084fe20000410000ULL,
0x000000192b2b7220ULL, 0x080fe20000410000ULL, 0x0000001912127220ULL, 0x080fe20000410000ULL,
0x0000001913137220ULL, 0x080fe20000410000ULL, 0x0000001916167220ULL, 0x080fe20000410000ULL,
0x0000001917177220ULL, 0x080fe20000410000ULL, 0x000000191e1e7220ULL, 0x080fe20000410000ULL,
0x000000191f1f7220ULL, 0x080fe20000410000ULL, 0x0000001922227220ULL, 0x080fe20000410000ULL,
0x0000001923237220ULL, 0x080fe20000410000ULL, 0x0000001926267220ULL, 0x080fe20000410000ULL,
0x0000001927277220ULL, 0x080fe20000410000ULL, 0x000000193a3a7220ULL, 0x080fe20000410000ULL,
0x000000193b3b7220ULL, 0x080fe20000410000ULL, 0x0000001932327220ULL, 0x080fe20000410000ULL,
0x0000001933337220ULL, 0x000fe20000410000ULL, 0x000000ffff067224ULL, 0x000fc400078e0018ULL,
0x000000650c653220ULL, 0x010fce0000410000ULL, 0x0000000000081947ULL, 0x000fea0003800000ULL,
0x0106a869ff0075a7ULL, 0x000e640008020149ULL, 0x000000b8006c9947ULL, 0x002fea0003800000ULL,
0x00000000423c783bULL, 0x000e620000004200ULL, 0x0000000cff6d723eULL, 0x000fe400000000ffULL,
0x000099102c2c7816ULL, 0x000fe200000000ffULL, 0x00b000005834783bULL, 0x000fe20000000200ULL,
0x000054106d6d7816ULL, 0x000fe4000000006dULL, 0x000000ff2c00720cULL, 0x000fe20003f25270ULL,
0x000000005f18783bULL, 0x000fe80000004200ULL, 0x00001f486d697589ULL, 0x000ea800000e0000ULL,
0x00001f466d687589ULL, 0x000ee200000e0000ULL, 0x000001003c2d7824ULL, 0x042fe200078e00ffULL,
0x000088803c407816ULL, 0x040fe200000000ffULL, 0x000001003d707824ULL, 0x040fe200078e00ffULL,
0x000088803d717816ULL, 0x040fe200000000ffULL, 0x0000006934349232ULL, 0x084fe20000000000ULL,
0x00000018ff417819ULL, 0x000fe2000001142dULL, 0x0000006936369232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fe20000011470ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x00000018ff727819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fc400078e00ffULL,
0x0000006835359232ULL, 0x088fe20000000000ULL, 0x00000018ff6c7819ULL, 0x000fe2000001143eULL,
0x0000006837379232ULL, 0x000fe20000000000ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000000005e2c783bULL, 0x000ea20000004200ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff6f7819ULL, 0x000fe4000001143fULL,
0x00000018ff6e7819ULL, 0x000fe20000011418ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fc40000011419ULL, 0x00000018ff707819ULL, 0x000fe4000001141aULL,
0x0000541040407816ULL, 0x002fc60000000041ULL, 0x0000007300767306ULL, 0x000e700000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x0000541071417816ULL, 0x002fce0000000076ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff717819ULL, 0x000fe2000001141bULL,
0x000000403428723cULL, 0x000fec0000001828ULL, 0x0000003c00737306ULL, 0x000e620000200c00ULL,
0x000088802f797816ULL, 0x004fe400000000ffULL, 0x00000018ff417819ULL, 0x000fca000001142cULL,
0x0000003d00407306ULL, 0x000ea20000200c00ULL, 0x00005410733c7816ULL, 0x002fce0000000072ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000088803f737816ULL, 0x000fe400000000ffULL,
0x000088803e727816ULL, 0x000fe400000000ffULL, 0x00005410403d7816ULL, 0x004fe2000000006bULL,
0x000001003e6b7824ULL, 0x040fe400078e00ffULL, 0x0000007200407306ULL, 0x0003e20000200c00ULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x0000003c3410723cULL, 0x000fe80000001810ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x00000018ff727819ULL, 0x002fe2000001143eULL,
0x000100003f3e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001146bULL,
0x000001003f6b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000003c003d7306ULL, 0x000e620000200c00ULL, 0x00000018ff767819ULL, 0x000fe4000001146bULL,
0x00000018ff6b7819ULL, 0x000fca000001142dULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x00005410403c7816ULL, 0x002fce000000003dULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x0000888018407816ULL, 0x000fe400000000ffULL, 0x00005410733d7816ULL, 0x004fca0000000076ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000088801b767816ULL, 0x000fe200000000ffULL,
0x0000003c3414723cULL, 0x000fec0000001814ULL, 0x00000072003f7306ULL, 0x0004e20000200c00ULL,
0x00000100193d7824ULL, 0x000fe400078e00ffULL, 0x00000100183c7824ULL, 0x000fca00078e00ffULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x0000888019727816ULL, 0x004fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000003d00737306ULL, 0x0003e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fce000001143cULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fe2000000006fULL, 0x00010000193e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001143eULL, 0x0000001800197306ULL, 0x0003f00000200c00ULL,
0x0000003c00777306ULL, 0x0007e20000200c00ULL, 0x000001001a187824ULL, 0x002fca00078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x000054103f3c7816ULL, 0x008fe4000000006cULL, 0x00000018ff6c7819ULL, 0x000fca000001142eULL,
0x0000003c341c723cULL, 0x000fe2000000181cULL, 0x0000006a006a7306ULL, 0x000fec0000200c00ULL,
0x00005410723d7816ULL, 0x004fe40000000073ULL, 0x0000001800737306ULL, 0x0005e20000200c00ULL,
0x00005410403c7816ULL, 0x002fc40000000077ULL, 0x000088801a407816ULL, 0x040fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc6000001142fULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000541019187816ULL, 0x004fe2000000006eULL,
0x000001001b197824ULL, 0x040fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000003c343c723cULL, 0x000fe20000001820ULL,
0x000000005920783bULL, 0x000ea20000004200ULL, 0x00000018ff777819ULL, 0x000fe20000011419ULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x000054106f197816ULL, 0x002fca000000006aULL, 0x0000007600767306ULL, 0x000fe40000200c00ULL,
0x000000183424723cULL, 0x000fec0000001824ULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000541040187816ULL, 0x008fe40000000073ULL, 0x000088802c737816ULL, 0x000fca00000000ffULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541076197816ULL, 0x002fce0000000077ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000183438723cULL, 0x000fe20000001838ULL,
0x00000018ff6e7819ULL, 0x004fcc0000011421ULL, 0x0000001a00197306ULL, 0x0002a20000200c00ULL,
0x00000018ff6f7819ULL, 0x000fe40000011420ULL, 0x00000018ff407819ULL, 0x000fe40000011422ULL,
0x00000018ff6a7819ULL, 0x000fc60000011423ULL, 0x0000001b00767306ULL, 0x000ee20000200c00ULL,
0x000088802d1a7816ULL, 0x002fe400000000ffULL, 0x0000541019187816ULL, 0x004fe20000000070ULL,
0x000001002c197824ULL, 0x000fc800078e00ffULL, 0x0000007300707306ULL, 0x000fe20000200c00ULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe40000011419ULL,
0x0000541076197816ULL, 0x008fc80000000071ULL, 0x0000007700717306ULL, 0x0002a20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x000000183430723cULL, 0x000fea0000001830ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x000088802e777816ULL, 0x002fe200000000ffULL,
0x000001002d187824ULL, 0x000fc400078e00ffULL, 0x000000ffff357224ULL, 0x000fe400078e001aULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011418ULL,
0x000001002e377824ULL, 0x040fe200078e00ffULL, 0x00b000005618783bULL, 0x000e620000000200ULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x000100002e2e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc80000011437ULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x0000003600367306ULL, 0x000ef00000200c00ULL,
0x0000002d00347306ULL, 0x0009f00000200c00ULL, 0x0000006b006b7306ULL, 0x000f620000200c00ULL,
0x000001002f2d7824ULL, 0x010fc400078e00ffULL, 0x000100002f2f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002c00787306ULL, 0x0005220000200c00ULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000006918189232ULL, 0x002fcc0000000000ULL,
0x0000002d00737306ULL, 0x0007e20000200c00ULL, 0x00005410702c7816ULL, 0x004fe20000000071ULL,
0x000000691a1a9232ULL, 0x000fe20000000000ULL, 0x0000888020717816ULL, 0x000fe200000000ffULL,
0x0000006819199232ULL, 0x080fe40000000000ULL, 0x000000681b1b9232ULL, 0x000fe40000000000ULL,
0x0000003700767306ULL, 0x000fe20000200c00ULL, 0x00005410352d7816ULL, 0x008fe40000000036ULL,
0x0000888021357816ULL, 0x000fca00000000ffULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000002c1828723cULL, 0x000fee0000001828ULL, 0x0000007900707306ULL, 0x000e620000200c00ULL,
0x00000100212d7824ULL, 0x040fe400078e00ffULL, 0x0001000021217824ULL, 0x000fc400078e00ffULL,
0x00000100202c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x0000002f00377306ULL, 0x000aa20000200c00ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x00000018ff207819ULL, 0x000fc60000011420ULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x00005410342f7816ULL, 0x020fe4000000006bULL, 0x000000c0456b7811ULL, 0x000fca00078e40ffULL,
0x0000002e00697306ULL, 0x0009f00000200c00ULL, 0x0000006c006c7306ULL, 0x000f620000200c00ULL,
0x00005410782e7816ULL, 0x010fe40000000041ULL, 0x0000888022417816ULL, 0x000fca00000000ffULL,
0x0000002e1810723cULL, 0x000fe20000001810ULL, 0x0000002d00367306ULL, 0x0003ec0000200c00ULL,
0x00000008032e7c24ULL, 0x000fe4000f8e026bULL, 0x00000021002f7306ULL, 0x0005e20000200c00ULL,
0x00005410702d7816ULL, 0x002fce0000000073ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541037217816ULL, 0x004fe20000000072ULL, 0x000000ffff377224ULL, 0x000fe200078e0041ULL,
0x0106b80aff7279a7ULL, 0x000e620008500009ULL, 0x000000014f417824ULL, 0x000fc800078e022eULL,
0x0000002c00687306ULL, 0x0006b00000200c00ULL, 0x0000003500357306ULL, 0x000f220000200c00ULL,
0x00005410772c7816ULL, 0x008fce0000000076ULL, 0x0000002000347306ULL, 0x000be20000200c00ULL,
0x0000002c1814723cULL, 0x000fe20000001814ULL, 0x00000073080075a7ULL, 0x002e6c00080c007fULL,
0x00000100222d7824ULL, 0x040fe200078e00ffULL, 0x0000541069207816ULL, 0x020fe2000000006cULL,
0x0000000151697824ULL, 0x000fe200078e022eULL, 0x00005410712c7816ULL, 0x004fe20000000068ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000010069687825ULL, 0x100fe200078e0066ULL, 0x0000888023717816ULL, 0x000fe200000000ffULL,
0x00000020181c723cULL, 0x000fe4000000181cULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000004968707210ULL, 0x000fe20007f5e0ffULL, 0x0000002d006c7306ULL, 0x0009e60000200c00ULL,
0x0000010041207825ULL, 0x000fc600078e0066ULL, 0x0000004920687210ULL, 0x000fe20007f7e0ffULL,
0x0000010023207824ULL, 0x000fe200078e00ffULL, 0x00005410352d7816ULL, 0x010fe20000000036ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x000000ffff357224ULL, 0x000fe400078e0071ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x000000ffff717224ULL, 0x000fe400010e0669ULL,
0x0000002c183c723cULL, 0x000fe2000000183cULL, 0x000000ffff697224ULL, 0x000fe200018e0621ULL,
0x0000003700377306ULL, 0x000f220000200c00ULL, 0x000000014d217824ULL, 0x000fc800078e022eULL,
0x00010000232d7824ULL, 0x000fe200078e00ffULL, 0x0000006b442c7248ULL, 0x000fe40007fe0000ULL,
0x0000003500357306ULL, 0x000fe40000200c00ULL, 0x00000018ff417819ULL, 0x000fe2000001142dULL,
0x000000012c2c7824ULL, 0x000fca00078e0a6bULL, 0x0000002000367306ULL, 0x0005700000200c00ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000541034207816ULL, 0x004fe2000000006fULL,
0x000000014b6f7824ULL, 0x000fe200078e022eULL, 0x00000018ff347819ULL, 0x000fe20000011422ULL,
0x0000010021227825ULL, 0x000fe200078e0066ULL, 0x000054102f217816ULL, 0x008fc4000000006eULL,
0x000000202c2e7807ULL, 0x000fe20000000000ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000049222c7210ULL, 0x000fe20007f5e0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0066ULL,
0x0000002e0f2e7248ULL, 0x000fe20007fe0000ULL, 0x000000201824723cULL, 0x000fe40000001824ULL,
0x000000ffff2d7224ULL, 0x000fe200010e0623ULL, 0x000000496e227210ULL, 0x000fe20007f5e0ffULL,
0x00000034002f7306ULL, 0x000ea20000200c00ULL, 0x000000012e777824ULL, 0x000fc400078e0a0fULL,
0x0000541037207816ULL, 0x010fe2000000006cULL, 0x000000ffff237224ULL, 0x000fe200010e066fULL,
0x0000541035217816ULL, 0x020fe40000000036ULL, 0x000000775000720cULL, 0x080fe20003f46070ULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x000000774e00720cULL, 0x080fe40003f66070ULL,
0x000000774c00720cULL, 0x080fe20003f86070ULL, 0x000000201838723cULL, 0x000fe20000001838ULL,
0x000000774a00720cULL, 0x000fcc0003fa6070ULL, 0x000054102f207816ULL, 0x004fe40000000040ULL,
0x0000541041217816ULL, 0x008fce000000006aULL, 0x000000201830723cULL, 0x000fe20000001830ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000086947ULL, 0x002fde0003800000ULL,
0x0106b873ff0075a7ULL, 0x000e6400080c0149ULL, 0x000000a80064e947ULL, 0x002fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000070537faeULL, 0x000fe8000d101c46ULL,
0x00000000685b7faeULL, 0x0003e8000d901c46ULL, 0x000000002c5a7faeULL, 0x0003e8000e101c46ULL,
0x0000000022577faeULL, 0x0003e2000e901c46ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a80aff6879a7ULL, 0x0022620008500009ULL, 0x00000075ff0075a7ULL, 0x000ea40008040045ULL,
0x0000000000082947ULL, 0x006fea0003800000ULL, 0x0106b075ff0075a7ULL, 0x000e640008040149ULL,
0x000000a80040a947ULL, 0x002fea0003800000ULL, 0x000000005c34783bULL, 0x000e620000004200ULL,
0x0000000765077221ULL, 0x000fc60000010000ULL, 0x000000005520783bULL, 0x000fe80000004200ULL,
0x00b00000522c783bULL, 0x000fe80000000200ULL, 0x00001f486d6f7589ULL, 0x000ea800000e0000ULL,
0x00001f466d6a7589ULL, 0x00072200000e0000ULL, 0x0000010034197824ULL, 0x002fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011434ULL, 0x0000010035707824ULL, 0x040fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011435ULL, 0x00000100366d7824ULL, 0x008fe200078e00ffULL,
0x0000888034187816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x0000888035717816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011419ULL, 0x0000001800417306ULL, 0x0003e20000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000006f2c2c9232ULL, 0x084fe20000000000ULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000006f2e2e9232ULL, 0x000fe20000000000ULL,
0x00000018ff737819ULL, 0x000fe20000011470ULL, 0x0000006a2d2d9232ULL, 0x090fe20000000000ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x0000006a2f2f9232ULL, 0x000fe20000000000ULL, 0x00000018ff6c7819ULL, 0x000fe20000011436ULL,
0x000000005418783bULL, 0x002e620000004200ULL, 0x00000018ff747819ULL, 0x000fc40000011437ULL,
0x00000018ff727819ULL, 0x000fe40000011420ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00000018ff707819ULL, 0x000fe40000011421ULL, 0x0000541041407816ULL, 0x004fca0000000040ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff417819ULL, 0x000fce0000011422ULL,
0x0000003400347306ULL, 0x000eb00000200c00ULL, 0x0000003500357306ULL, 0x000ee20000200c00ULL,
0x0000541034347816ULL, 0x004fce0000000075ULL, 0x0000007100767306ULL, 0x000fe20000200c00ULL,
0x000088801a797816ULL, 0x002fe400000000ffULL, 0x0000541035357816ULL, 0x008fca000000006eULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe20000011419ULL,
0x000000342c10723cULL, 0x000fec0000001810ULL, 0x0000004100717306ULL, 0x0003e20000200c00ULL,
0x0000010037347824ULL, 0x040fe200078e00ffULL, 0x0000888037357816ULL, 0x000fcc00000000ffULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000541076417816ULL, 0x002fe40000000073ULL,
0x00000018ff757819ULL, 0x000fe40000011434ULL, 0x00000018ff737819ULL, 0x000fc60000011423ULL,
0x000000402c28723cULL, 0x000fe20000001828ULL, 0x0000003500357306ULL, 0x000fec0000200c00ULL,
0x0000888036407816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x0000007500767306ULL, 0x000e620000200c00ULL, 0x00000018ff417819ULL, 0x000fc60000011418ULL,
0x00000018ff347819ULL, 0x000fe20000011436ULL, 0x0001000037367824ULL, 0x000fc600078e00ffULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x0000541035357816ULL, 0x002fce0000000076ULL,
0x0000003400377306ULL, 0x0005f00000200c00ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541040347816ULL, 0x004fe4000000006dULL, 0x00000018ff6d7819ULL, 0x000fc40000011436ULL,
0x0000888020367816ULL, 0x040fe400000000ffULL, 0x0000888021407816ULL, 0x000fe200000000ffULL,
0x000000342c14723cULL, 0x000fe20000001814ULL, 0x0000006d006d7306ULL, 0x000e6c0000200c00ULL,
0x0000010020357824ULL, 0x000fc400078e00ffULL, 0x0000010021347824ULL, 0x040fe200078e00ffULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000003500777306ULL, 0x0003f00000200c00ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054106d357816ULL, 0x002fc40000000074ULL, 0x00000018ff747819ULL, 0x000fca0000011421ULL,
0x0000003400757306ULL, 0x000e700000200c00ULL, 0x00000020006d7306ULL, 0x0005e20000200c00ULL,
0x0000541040217816ULL, 0x002fce0000000075ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541036207816ULL, 0x004fe40000000077ULL, 0x0000888022407816ULL, 0x000fca00000000ffULL,
0x000000202c3c723cULL, 0x000fe2000000183cULL, 0x0000007000707306ULL, 0x000fec0000200c00ULL,
0x0000010022207824ULL, 0x040fe200078e00ffULL, 0x0000888023217816ULL, 0x000fe200000000ffULL,
0x0000007400757306ULL, 0x0004e20000200c00ULL, 0x0001000022227824ULL, 0x000fc400078e00ffULL,
0x00000018ff207819ULL, 0x000fca0000011420ULL, 0x0000002000777306ULL, 0x0003e20000200c00ULL,
0x00000018ff747819ULL, 0x004fce000001141bULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x000054106d207816ULL, 0x002fe20000000072ULL, 0x0000010023727824ULL, 0x040fe400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011472ULL,
0x00000021006d7306ULL, 0x0007f00000200c00ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x0000541075217816ULL, 0x008fce0000000070ULL, 0x000000202c24723cULL, 0x000fe20000001824ULL,
0x0000006c006c7306ULL, 0x000eec0000200c00ULL, 0x0000541040207816ULL, 0x004fe40000000077ULL,
0x000054106d217816ULL, 0x002fe20000000076ULL, 0x0000007300737306ULL, 0x000fec0000200c00ULL,
0x000000202c38723cULL, 0x000fe20000001838ULL, 0x0000541037347816ULL, 0x008fe2000000006cULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x00000018ff6c7819ULL, 0x000fc8000001141aULL,
0x00000018ff207819ULL, 0x000fe20000011422ULL, 0x000000342c1c723cULL, 0x000fe2000000181cULL,
0x00000018ff217819ULL, 0x000fe20000011423ULL, 0x000000005d34783bULL, 0x000e620000004200ULL,
0x0000010018237824ULL, 0x040fe200078e00ffULL, 0x0000888018227816ULL, 0x040fe200000000ffULL,
0x0000002000207306ULL, 0x000ea20000200c00ULL, 0x0001000018187824ULL, 0x000fe400078e00ffULL,
0x00000018ff237819ULL, 0x000fc60000011423ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000002100767306ULL, 0x000ee20000200c00ULL, 0x0000541020207816ULL, 0x004fce0000000071ULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x0000888019717816ULL, 0x000fe400000000ffULL,
0x0000541076217816ULL, 0x008fca0000000073ULL, 0x0000002300237306ULL, 0x000ea20000200c00ULL,
0x000001001a737824ULL, 0x040fe200078e00ffULL, 0x000088801b767816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x000000202c2c723cULL, 0x000fe20000001830ULL,
0x00b000006430783bULL, 0x000ee60000000200ULL, 0x00000018007a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0000010019217824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x002fe20000011434ULL,
0x000000ffff207224ULL, 0x000fc400078e0071ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000541022187816ULL, 0x004fe40000000023ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x0000888034757816ULL, 0x000fe400000000ffULL,
0x00000018ff707819ULL, 0x000fc40000011435ULL, 0x00000018ff407819ULL, 0x000fe40000011436ULL,
0x00000018ff6d7819ULL, 0x000fe20000011437ULL, 0x0000002100217306ULL, 0x000e700000200c00ULL,
0x0000001900717306ULL, 0x0005220000200c00ULL, 0x0000006f30309232ULL, 0x008fce0000000000ULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000001001b197824ULL, 0x044fe400078e00ffULL,
0x0000006f32329232ULL, 0x000fe40000000000ULL, 0x000100001b1b7824ULL, 0x000fe400078e00ffULL,
0x0000006a31319232ULL, 0x080fe20000000000ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000006a33339232ULL, 0x000fe20000000000ULL, 0x0000007300787306ULL, 0x000ea20000200c00ULL,
0x00000018ff1b7819ULL, 0x000fc4000001141bULL, 0x0000006b4400720cULL, 0x000fca0003f24070ULL,
0x0000001900777306ULL, 0x0003f00000200c00ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x0000541020197816ULL, 0x002fe40000000021ULL, 0x0000888035217816ULL, 0x000fca00000000ffULL,
0x000000183028723cULL, 0x000fe20000001828ULL, 0x0000001a00737306ULL, 0x0003ec0000200c00ULL,
0x0000010034187824ULL, 0x040fe400078e00ffULL, 0x0000010035197824ULL, 0x040fe200078e00ffULL,
0x0000006c006c7306ULL, 0x000f620000200c00ULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00010000351a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fc40000011419ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000001800207306ULL, 0x0003f00000200c00ULL, 0x0000001900227306ULL, 0x0009e20000200c00ULL,
0x000054107a187816ULL, 0x002fc40000000041ULL, 0x00000018ff417819ULL, 0x000fe4000001141aULL,
0x00008880371a7816ULL, 0x000fc600000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541071197816ULL, 0x010fe4000000006eULL, 0x0000888036717816ULL, 0x000fca00000000ffULL,
0x000000183010723cULL, 0x000fe20000001810ULL, 0x0000001b00237306ULL, 0x00032c0000200c00ULL,
0x0000010036187824ULL, 0x040fe400078e00ffULL, 0x0000010037197824ULL, 0x040fe200078e00ffULL,
0x0000003400357306ULL, 0x000fe20000200c00ULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fc40000011419ULL, 0x00000018ff1b7819ULL, 0x002fe40000011436ULL,
0x0000001800347306ULL, 0x0005e20000200c00ULL, 0x00000018ff367819ULL, 0x000fce0000011437ULL,
0x00000019006f7306ULL, 0x0007e20000200c00ULL, 0x0000541079187816ULL, 0x004fce0000000078ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541076197816ULL, 0x008fce0000000077ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x000000183014723cULL, 0x000fee0000001814ULL,
0x0000004100417306ULL, 0x000ea20000200c00ULL, 0x0000541073187816ULL, 0x020fe4000000006cULL,
0x0000541023197816ULL, 0x010fca0000000074ULL, 0x0000007100717306ULL, 0x000ee40000200c00ULL,
0x00000018301c723cULL, 0x000fec000000181cULL, 0x0000001a001a7306ULL, 0x000f220000200c00ULL,
0x0000541035187816ULL, 0x002fe40000000072ULL, 0x0000541041197816ULL, 0x004fca0000000070ULL,
0x0000007500757306ULL, 0x000e640000200c00ULL, 0x000000183024723cULL, 0x000fec0000001824ULL,
0x0000002100217306ULL, 0x000ea20000200c00ULL, 0x0000541071187816ULL, 0x008fe40000000034ULL,
0x000054101a197816ULL, 0x010fc4000000006fULL, 0x0000541075207816ULL, 0x002fc60000000020ULL,
0x0000004000407306ULL, 0x000fe40000200c00ULL, 0x000000183038723cULL, 0x000fe20000001838ULL,
0x0000541021217816ULL, 0x004fca0000000022ULL, 0x0000006d006d7306ULL, 0x000fe40000200c00ULL,
0x000000203020723cULL, 0x000fec000000183cULL, 0x0000001b001b7306ULL, 0x000e700000200c00ULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x000054101b187816ULL, 0x002fc40000000040ULL,
0x0000541036197816ULL, 0x004fce000000006dULL, 0x000000183030723cULL, 0x000fe2000000182cULL,
0x0106b80aff1879a7ULL, 0x0002a20008500009ULL, 0x0106980affff79a7ULL, 0x0003e20008500009ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000024009c9947ULL, 0x000fde0003800000ULL,
0x00000019080075a7ULL, 0x004ea2000802007fULL, 0x000000e0451a7811ULL, 0x000fc800078e40ffULL,
0x0000001a441b7248ULL, 0x000fe20007fe0000ULL, 0x00000008032c7c24ULL, 0x000fc8000f8e021aULL,
0x000000011b1b7824ULL, 0x000fe400078e0a1aULL, 0x00000001512d7824ULL, 0x000fc600078e022cULL,
0x000000201b2e7807ULL, 0x000fe20000000000ULL, 0x000001002d1a7825ULL, 0x000fe200078e0066ULL,
0x0000000000081947ULL, 0x004fec0003800000ULL, 0x0106b819ff0075a7ULL, 0x000ea40008000149ULL,
0x0000009800908947ULL, 0x004fea0003800000ULL, 0x0000002e0f187248ULL, 0x000fe20007fe0000ULL,
0x000000014f2d7824ULL, 0x100fe200078e022cULL, 0x000000491a2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014d197824ULL, 0x100fe400078e022cULL, 0x0000000118357824ULL, 0x000fe400078e0a0fULL,
0x000000014b377824ULL, 0x000fe400078e022cULL, 0x000000ffff2f7224ULL, 0x000fe200000e061bULL,
0x000000355000720cULL, 0x080fe20003f06070ULL, 0x000001002d2c7825ULL, 0x000fe200078e0066ULL,
0x000000354e00720cULL, 0x000fc40003f26070ULL, 0x000000354c00720cULL, 0x080fe20003f46070ULL,
0x00000100191a7825ULL, 0x100fe200078e0066ULL, 0x000000354a00720cULL, 0x000fe40003f66070ULL,
0x000000492c2c7210ULL, 0x000fe20007f9e0ffULL, 0x0000010037187825ULL, 0x000fe200078e0066ULL,
0x000000491a1a7210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff2d7224ULL, 0x000fe200020e062dULL,
0x0000004918187210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e637faeULL, 0x000fe6000c101c46ULL,
0x000000ffff197224ULL, 0x000fe200030e0619ULL, 0x000000002c627faeULL, 0x000fe8000c901c46ULL,
0x000000001a617faeULL, 0x000fe8000d101c46ULL, 0x0000000018607faeULL, 0x0005e2000d901c46ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0106b00aff6e79a7ULL, 0x0006e20008500009ULL,
0x00000069ff0075a7ULL, 0x0006e20008000044ULL, 0x0106680a0f1879a7ULL, 0x004ea40008500009ULL,
0x010668190f0075a7ULL, 0x004ea40008020149ULL, 0x00000098001c9947ULL, 0x00efea0003800000ULL,
0x0101800043197984ULL, 0x000e620000000800ULL, 0x00000001ff747424ULL, 0x000fc600078e00ffULL,
0x0103800043607984ULL, 0x0004a20000000800ULL, 0x000000061900720bULL, 0x002fda0003f3d000ULL,
0x0000000000187806ULL, 0x000fc800008e0100ULL, 0x0000ffff181a7812ULL, 0x000fda000782c0ffULL,
0x0000000000cc9947ULL, 0x004fea0003800000ULL, 0x000000061900720bULL, 0x000fe40003f34000ULL,
0x00000019062c7209ULL, 0x000fca0007810000ULL, 0x8000002c06187221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b18187820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x00000018001b7308ULL, 0x000e620000000800ULL, 0x000000034700780cULL, 0x000fe40003f25270ULL,
0x0000ffff062d7812ULL, 0x000fc800078e3cffULL, 0x0000002d1aff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ff747807ULL, 0x000fc60001000000ULL, 0x0105802c43009388ULL, 0x000fe20000000800ULL,
0x0000001b07077220ULL, 0x002fc60000410000ULL, 0x00001f481b067589ULL, 0x000e6400000e0000ULL,
0x8000002c191a2221ULL, 0x000fe40000010000ULL, 0x00001f461b197589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b1a1a2820ULL, 0x000fc80000410000ULL, 0x0000001a000c2308ULL, 0x000ee20000000800ULL,
0x0000000628287220ULL, 0x082fe20000410000ULL, 0x0000000629297220ULL, 0x080fe20000410000ULL,
0x0000000610107220ULL, 0x080fe20000410000ULL, 0x0000000611117220ULL, 0x080fe20000410000ULL,
0x0000000614147220ULL, 0x080fe20000410000ULL, 0x0000000615157220ULL, 0x080fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x000000061d1d7220ULL, 0x080fe20000410000ULL,
0x0000000620207220ULL, 0x080fe20000410000ULL, 0x0000000621217220ULL, 0x080fe20000410000ULL,
0x0000000624247220ULL, 0x080fe20000410000ULL, 0x0000000625257220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000630307220ULL, 0x080fe20000410000ULL, 0x0000000631317220ULL, 0x000fe20000410000ULL,
0x000000192a2a7220ULL, 0x084fe20000410000ULL, 0x000000192b2b7220ULL, 0x080fe20000410000ULL,
0x0000001912127220ULL, 0x080fe20000410000ULL, 0x0000001913137220ULL, 0x080fe20000410000ULL,
0x0000001916167220ULL, 0x080fe20000410000ULL, 0x0000001917177220ULL, 0x080fe20000410000ULL,
0x000000191e1e7220ULL, 0x080fe20000410000ULL, 0x000000191f1f7220ULL, 0x080fe20000410000ULL,
0x0000001922227220ULL, 0x080fe20000410000ULL, 0x0000001923237220ULL, 0x080fe20000410000ULL,
0x0000001926267220ULL, 0x080fe20000410000ULL, 0x0000001927277220ULL, 0x080fe20000410000ULL,
0x000000193a3a7220ULL, 0x080fe20000410000ULL, 0x000000193b3b7220ULL, 0x080fe20000410000ULL,
0x0000001932327220ULL, 0x080fe20000410000ULL, 0x0000001933337220ULL, 0x000fe20000410000ULL,
0x000000ffff067224ULL, 0x000fc400078e002cULL, 0x000000600c602220ULL, 0x008fce0000410000ULL,
0x0000000000080947ULL, 0x000fea0003800000ULL, 0x0106a869ff0075a7ULL, 0x000e640008000149ULL,
0x0000009400408947ULL, 0x002fea0003800000ULL, 0x000000004240783bULL, 0x000e620000004200ULL,
0x0000000cff68723eULL, 0x000fe400000000ffULL, 0x0000991074747816ULL, 0x000fe200000000ffULL,
0x00b80000582c783bULL, 0x000fe60000000200ULL, 0x000000ff7400720cULL, 0x000fe20003f05270ULL,
0x000000005f3c783bULL, 0x0002a80000004200ULL, 0x000000005918783bULL, 0x0007e80000004200ULL,
0x000000005e34783bULL, 0x0009620000004200ULL, 0x00000100405f7824ULL, 0x002fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011440ULL, 0x0000010041747824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc40000011441ULL, 0x00000018ff597819ULL, 0x008fe4000001145fULL,
0x00005410685f7816ULL, 0x000fe20000000068ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00008880405e7816ULL, 0x050fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x0000888041587816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00001f485f697589ULL, 0x000e6200000e0000ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x00001f465f687589ULL, 0x000ee200000e0000ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff707819ULL, 0x000fc40000011443ULL, 0x00000018ff717819ULL, 0x000fe40000011442ULL,
0x00000018ff6d7819ULL, 0x004fe4000001143cULL, 0x00000018ff6c7819ULL, 0x000fe2000001143dULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x00000018ff657819ULL, 0x020fe40000011434ULL,
0x00000018ff637819ULL, 0x000fe40000011435ULL, 0x000088803e7c7816ULL, 0x000fc400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001143eULL, 0x0000004100417306ULL, 0x000f220000200c00ULL,
0x00000018ff617819ULL, 0x000fe20000011436ULL, 0x000000692c2c8232ULL, 0x082fe20000000000ULL,
0x00000018ff6a7819ULL, 0x000fe2000001143fULL, 0x000000692e2e8232ULL, 0x000fe20000000000ULL,
0x00000018ff627819ULL, 0x000fe20000011437ULL, 0x000000682d2d8232ULL, 0x088fe20000000000ULL,
0x0000541040407816ULL, 0x004fe20000000073ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000682f2f8232ULL, 0x000fe20000000000ULL, 0x0000888042737816ULL, 0x000fc400000000ffULL,
0x0000541041417816ULL, 0x010fc80000000072ULL, 0x0000005900597306ULL, 0x000e660000200c00ULL,
0x000000402c10723cULL, 0x000fea0000001810ULL, 0x0000005800757306ULL, 0x0003e40000200c00ULL,
0x0000010043407824ULL, 0x000fcc00078e00ffULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000054105e587816ULL, 0x002fe40000000059ULL, 0x00000018ff777819ULL, 0x000fe20000011440ULL,
0x0001000042407824ULL, 0x000fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fc60000011418ULL,
0x0000007300727306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000541075597816ULL, 0x004fe20000000074ULL, 0x0000010042747824ULL, 0x000fe200078e00ffULL,
0x0000888043757816ULL, 0x000fc600000000ffULL, 0x0000007700787306ULL, 0x0003e20000200c00ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe4000001141bULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x000000582c28723cULL, 0x000fe20000001828ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000007400417306ULL, 0x0004e20000200c00ULL,
0x000088803f777816ULL, 0x002fc600000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011419ULL,
0x00000018ff587819ULL, 0x000fe4000001141aULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000088803c747816ULL, 0x004fce00000000ffULL, 0x0000004000767306ULL, 0x0007f00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541072407816ULL, 0x008fe40000000041ULL,
0x0000541075417816ULL, 0x002fca0000000078ULL, 0x0000007000707306ULL, 0x000fe40000200c00ULL,
0x000000402c14723cULL, 0x000fec0000001814ULL, 0x0000004300757306ULL, 0x0002a20000200c00ULL,
0x000001003c417824ULL, 0x040fe200078e00ffULL, 0x000088803d407816ULL, 0x000fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000001003d437824ULL, 0x042fe200078e00ffULL,
0x0000004100737306ULL, 0x0003e20000200c00ULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fc80000011443ULL, 0x0000003c00727306ULL, 0x0007e20000200c00ULL,
0x00000018ff417819ULL, 0x002fe4000001143dULL, 0x00005410753d7816ULL, 0x004fca0000000070ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00005410763c7816ULL, 0x008fe40000000071ULL,
0x0000888034767816ULL, 0x000fe400000000ffULL, 0x0000888035717816ULL, 0x000fc600000000ffULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000003c2c1c723cULL, 0x000fee000000181cULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x000001003e3d7824ULL, 0x000fe400078e00ffULL,
0x000001003f3c7824ULL, 0x000fc400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff3f7819ULL, 0x000fca000001143fULL,
0x0000003d00797306ULL, 0x0003f00000200c00ULL, 0x0000003c007a7306ULL, 0x0005e20000200c00ULL,
0x00005410403d7816ULL, 0x002fce0000000043ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x00005410743c7816ULL, 0x004fce0000000073ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000003c2c20723cULL, 0x000fee0000001820ULL, 0x00000100343c7824ULL, 0x040fe200078e00ffULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0001000034347824ULL, 0x000fc400078e00ffULL,
0x00000100353d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000003c00737306ULL, 0x0005e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fce000001143dULL,
0x0000003400407306ULL, 0x0007e20000200c00ULL, 0x00000018ff3c7819ULL, 0x004fe40000011435ULL,
0x0000541041357816ULL, 0x002fe4000000006cULL, 0x0000888037417816ULL, 0x000fc600000000ffULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x0000541072347816ULL, 0x008fe2000000006dULL,
0x00000100186d7824ULL, 0x000fe200078e00ffULL, 0x0000888036727816ULL, 0x000fca00000000ffULL,
0x000000342c24723cULL, 0x000fe20000001824ULL, 0x0000006b006b7306ULL, 0x000fec0000200c00ULL,
0x0000010036357824ULL, 0x040fe400078e00ffULL, 0x0000010037347824ULL, 0x040fe200078e00ffULL,
0x0000003e00787306ULL, 0x0004e20000200c00ULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc80000011434ULL, 0x0000003500437306ULL, 0x0003e20000200c00ULL,
0x00000018ff3e7819ULL, 0x004fe40000011436ULL, 0x0000888018367816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fc800078e00ffULL, 0x0000003400707306ULL, 0x0005e20000200c00ULL,
0x0000541077357816ULL, 0x002fe4000000007aULL, 0x00000018ff187819ULL, 0x000fca0000011418ULL,
0x0000003c006c7306ULL, 0x0007e20000200c00ULL, 0x000054107c347816ULL, 0x004fce0000000079ULL,
0x0000003f00757306ULL, 0x0003e20000200c00ULL, 0x00005410783c7816ULL, 0x008fe2000000006bULL,
0x000000ffff6b7224ULL, 0x000fe200078e0036ULL, 0x000000342c38723cULL, 0x000fea0000001838ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x00000018ff3f7819ULL, 0x002fe40000011437ULL,
0x00b800005634783bULL, 0x0002ea0000000200ULL, 0x0000003d00747306ULL, 0x0005f00000200c00ULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x00005410753d7816ULL, 0x004fce000000006aULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x0000003c2c2c723cULL, 0x000fee0000001830ULL,
0x0000010019317824ULL, 0x040fe200078e00ffULL, 0x0000006500657306ULL, 0x000f220000200c00ULL,
0x0000000102327824ULL, 0x000fe200078e0245ULL, 0x0000888019307816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff337819ULL, 0x000fe20000011431ULL,
0x0000000132317836ULL, 0x040fe20000000000ULL, 0x00000018ff3d7819ULL, 0x000fe2000001146dULL,
0x0000010032567824ULL, 0x002fe200078e00ffULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe20000011419ULL, 0x0000006934348232ULL, 0x088fe20000000000ULL,
0x0000000e3100720cULL, 0x000fe20003f26070ULL, 0x0000006936368232ULL, 0x000fe20000000000ULL,
0x0000541071197816ULL, 0x004fe20000000074ULL, 0x0000006835358232ULL, 0x000fc40000000000ULL,
0x0000000803327c24ULL, 0x000fe4000f8e0256ULL, 0x0000006837378232ULL, 0x000fe20000000000ULL,
0x0000001800317306ULL, 0x0005e20000200c00ULL, 0x0106b80aff6879a7ULL, 0x000ee20008500009ULL,
0x0000000151777824ULL, 0x100fe400078e0232ULL, 0x000000014f757824ULL, 0x100fe400078e0232ULL,
0x000000014d797824ULL, 0x100fe400078e0232ULL, 0x0000007200727306ULL, 0x000f620000200c00ULL,
0x0000541076187816ULL, 0x004fe20000000073ULL, 0x000000014b4b7824ULL, 0x000fe200078e0232ULL,
0x000088801a327816ULL, 0x040fe200000000ffULL, 0x000001001a4d7824ULL, 0x000fc400078e00ffULL,
0x000100001a1a7824ULL, 0x000fe400078e00ffULL, 0x0000004100417306ULL, 0x000ea20000200c00ULL,
0x000000183428723cULL, 0x000fe20000001828ULL, 0x0000010077767825ULL, 0x000fe200078e0066ULL,
0x00000018ff4d7819ULL, 0x000fc6000001144dULL, 0x0000010075747825ULL, 0x000fe200078e0066ULL,
0x0000004976767210ULL, 0x000fe20007f5e0ffULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000541040187816ULL, 0x010fe20000000065ULL, 0x00000069080075a7ULL, 0x008ee200080a007fULL,
0x000054106c197816ULL, 0x002fe20000000063ULL, 0x0000010079787825ULL, 0x000fe200078e0066ULL,
0x0000004974747210ULL, 0x000fc60007f7e0ffULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x000001001b4f7824ULL, 0x000fe200078e00ffULL, 0x000000183410723cULL, 0x000fe20000001810ULL,
0x000001004b667825ULL, 0x000fe200078e0066ULL, 0x000088801b4b7816ULL, 0x000fe400000000ffULL,
0x00000018ff407819ULL, 0x000fe2000001144fULL, 0x000000ffff777224ULL, 0x000fe200010e0677ULL,
0x0000006b006a7306ULL, 0x0009e20000200c00ULL, 0x0000541072187816ULL, 0x020fe20000000043ULL,
0x000000ffff757224ULL, 0x000fe200018e0675ULL, 0x0000541041197816ULL, 0x004fca0000000070ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000056446b7248ULL, 0x010fe20007fe0000ULL,
0x000000183414723cULL, 0x000fe80000001814ULL, 0x000000016b567824ULL, 0x000fe400078e0a56ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff187819ULL, 0x000fe2000001141aULL,
0x000100001b197824ULL, 0x000fe200078e00ffULL, 0x000054103f1b7816ULL, 0x002fc40000000062ULL,
0x0000002056567807ULL, 0x000fc60000800000ULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x000000560f567248ULL, 0x000fce0007fe0000ULL, 0x0000003000307306ULL, 0x000fe20000200c00ULL,
0x000054103e1a7816ULL, 0x002fce0000000061ULL, 0x0000003300337306ULL, 0x000e620000200c00ULL,
0x0000001a341c723cULL, 0x000fee000000181cULL, 0x00000018003f7306ULL, 0x0005e20000200c00ULL,
0x00000049781a7210ULL, 0x000fce0007f3e0ffULL, 0x0000005e005e7306ULL, 0x000f220000200c00ULL,
0x000054106a187816ULL, 0x004fe2000000003dULL, 0x000000ffff1b7224ULL, 0x000fe200008e0679ULL,
0x00000018ff3d7819ULL, 0x000fe40000011419ULL, 0x0000541030197816ULL, 0x002fe20000000033ULL,
0x0000000156337824ULL, 0x000fe400078e0a0fULL, 0x0000005900597306ULL, 0x000fe60000200c00ULL,
0x000000335000720cULL, 0x080fe20003f26070ULL, 0x000000183420723cULL, 0x000fe20000001820ULL,
0x000000334e00720cULL, 0x000fc40003f46070ULL, 0x000000334c00720cULL, 0x080fe20003f66070ULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x000000334a00720cULL, 0x000fe40003f86070ULL,
0x0000541031187816ULL, 0x010fca000000005eULL, 0x0000003200327306ULL, 0x000fe20000200c00ULL,
0x000054103c197816ULL, 0x002fce0000000059ULL, 0x0000004d004d7306ULL, 0x000e620000200c00ULL,
0x000000183424723cULL, 0x000fee0000001824ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000004966187210ULL, 0x000fe40007fde0ffULL, 0x0000541032327816ULL, 0x002fca000000004dULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x000000ffff197224ULL, 0x000fce00030e0667ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000054104b337816ULL, 0x002fce0000000040ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000323438723cULL, 0x000fe20000001838ULL,
0x000054103f587816ULL, 0x004fcc0000000058ULL, 0x0000003d003d7306ULL, 0x000e640000200c00ULL,
0x000054103d597816ULL, 0x002fce0000000042ULL, 0x000000583434723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000085947ULL, 0x008fde0003800000ULL,
0x0106b869ff0075a7ULL, 0x000e6400080a0149ULL, 0x000000840034d947ULL, 0x002fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000076537faeULL, 0x0003e8000c901c46ULL,
0x00000000745b7faeULL, 0x0003e8000d101c46ULL, 0x000000001a5a7faeULL, 0x0003e8000d901c46ULL,
0x0000000018577faeULL, 0x0003e2000e101c46ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0106a80aff6879a7ULL, 0x0004a20008500009ULL, 0x0000006fff0075a7ULL, 0x000ee40008020045ULL,
0x0000000000081947ULL, 0x00cfea0003800000ULL, 0x0106b06fff0075a7ULL, 0x000ea40008020149ULL,
0x0000008400109947ULL, 0x004fea0003800000ULL, 0x000000005c2c783bULL, 0x000ea20000004200ULL,
0x0000000760077221ULL, 0x000fc60000010000ULL, 0x00000000553c783bULL, 0x0007e80000004200ULL,
0x000000005430783bULL, 0x000f280000004200ULL, 0x000000005d18783bULL, 0x0023680000004200ULL,
0x00001f485f5b7589ULL, 0x0003e800000e0000ULL, 0x00001f465f627589ULL, 0x000fe200000e0000ULL,
0x00000018ff777819ULL, 0x004fe2000001142cULL, 0x000001002c4d7824ULL, 0x040fe200078e00ffULL,
0x000088802c7d7816ULL, 0x040fe200000000ffULL, 0x000100002c2c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe2000001142dULL, 0x000001002d4e7824ULL, 0x040fe200078e00ffULL,
0x000088802d797816ULL, 0x040fe200000000ffULL, 0x000100002d2d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff717819ULL, 0x000fe4000001142eULL, 0x00000018ff6f7819ULL, 0x000fe2000001142fULL,
0x0000002c007a7306ULL, 0x0005e20000200c00ULL, 0x000088802e737816ULL, 0x000fe400000000ffULL,
0x000088802f557816ULL, 0x008fe400000000ffULL, 0x00000018ff4c7819ULL, 0x010fc40000011430ULL,
0x0000888030577816ULL, 0x000fe200000000ffULL, 0x0000002d00787306ULL, 0x0007e20000200c00ULL,
0x000001002f2c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x000100002f2f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011431ULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000004d007b7306ULL, 0x0005e20000200c00ULL,
0x000001003c2d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff2f7819ULL, 0x000fc4000001142fULL,
0x0000888031537816ULL, 0x000fe400000000ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00767306ULL, 0x0007e20000200c00ULL, 0x000001002e4d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001143cULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001143dULL, 0x00000018ff4d7819ULL, 0x000fc4000001144dULL,
0x0000002d006d7306ULL, 0x0005e20000200c00ULL, 0x000001003d2c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff2e7819ULL, 0x000fe4000001142eULL, 0x000088803c707816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fe4000001142cULL,
0x0000002e00747306ULL, 0x000fe20000200c00ULL, 0x000001003e2d7824ULL, 0x004fe200078e00ffULL,
0x000088803d6b7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc4000001143fULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c006e7306ULL, 0x0005e20000200c00ULL, 0x000088803f5d7816ULL, 0x042fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5a7819ULL, 0x000fe2000001143eULL, 0x0000002d00637306ULL, 0x0003e20000200c00ULL,
0x000001003f2c7824ULL, 0x044fe200078e00ffULL, 0x000088803e6a7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011432ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2c7819ULL, 0x000fc4000001142cULL,
0x0000002f00727306ULL, 0x000fe20000200c00ULL, 0x00000100302d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011433ULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c00667306ULL, 0x0003e20000200c00ULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x00000018ff437819ULL, 0x020fc40000011418ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff427819ULL, 0x000fe20000011419ULL, 0x0000002d00567306ULL, 0x0005e20000200c00ULL,
0x00000100312c7824ULL, 0x002fe200078e00ffULL, 0x0000888019487816ULL, 0x000fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe4000001141aULL,
0x00000018ff587819ULL, 0x000fe4000001142cULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x00b80000522c783bULL, 0x0042a20000000200ULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x00000018ff407819ULL, 0x000fc8000001141bULL, 0x0000004e007c7306ULL, 0x0007e20000200c00ULL,
0x0000010019527824ULL, 0x002fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000030004f7306ULL, 0x0003e20000200c00ULL, 0x00008880334e7816ULL, 0x008fce00000000ffULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000010033307824ULL, 0x042fe400078e00ffULL,
0x0001000033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff307819ULL, 0x000fe40000011430ULL,
0x0000004d00547306ULL, 0x000e620000200c00ULL, 0x00000018ff337819ULL, 0x000fce0000011433ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000005b2c2c8232ULL, 0x084fe40000000000ULL,
0x0000005b2e2e8232ULL, 0x000fe40000000000ULL, 0x000000622d2d8232ULL, 0x080fe40000000000ULL,
0x000000622f2f8232ULL, 0x000fe20000000000ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541073547816ULL, 0x002fe40000000054ULL, 0x0000541055557816ULL, 0x008fca0000000076ULL,
0x0000007500757306ULL, 0x000fe40000200c00ULL, 0x000000542c14723cULL, 0x000fec0000001814ULL,
0x0000003100507306ULL, 0x0003f00000200c00ULL, 0x0000003000517306ULL, 0x0005e20000200c00ULL,
0x0000541079317816ULL, 0x002fce000000007cULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000054107d307816ULL, 0x004fce000000007bULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x000000302c28723cULL, 0x000fe20000001828ULL, 0x0000541074547816ULL, 0x002fcc0000000071ULL,
0x0000010018307824ULL, 0x000fe200078e00ffULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000541078317816ULL, 0x000fc60000000075ULL, 0x00000018ff467819ULL, 0x000fe40000011430ULL,
0x000054107a307816ULL, 0x000fe40000000077ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x0000541072557816ULL, 0x004fc8000000006fULL, 0x000000302c10723cULL, 0x000fe60000001810ULL,
0x0000003c006c7306ULL, 0x0005e60000200c00ULL, 0x000000542c1c723cULL, 0x000fea000000181cULL,
0x0000003d00677306ULL, 0x0007e20000200c00ULL, 0x00008880323c7816ULL, 0x004fe200000000ffULL,
0x0001000019547824ULL, 0x000fe200078e00ffULL, 0x000054106b197816ULL, 0x002fc8000000006eULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000003f005c7306ULL, 0x0003e20000200c00ULL,
0x00000100323d7824ULL, 0x048fe400078e00ffULL, 0x0001000032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x00008880183f7816ULL, 0x042fe200000000ffULL,
0x0001000018187824ULL, 0x000fca00078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000005e005e7306ULL, 0x000e700000200c00ULL, 0x0000003e00617306ULL, 0x000ff00000200c00ULL,
0x0000003d004d7306ULL, 0x000ff00000200c00ULL, 0x00000032003d7306ULL, 0x000ff00000200c00ULL,
0x00000033003e7306ULL, 0x0007f00000200c00ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00b800006430783bULL, 0x00872e0000000200ULL, 0x0000005900597306ULL, 0x000ff00000200c00ULL,
0x0000001800647306ULL, 0x0087f00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541070187816ULL, 0x008fce000000006dULL, 0x000000182c20723cULL, 0x000fe20000001820ULL,
0x0000005d005d7306ULL, 0x000eec0000200c00ULL, 0x000054106c187816ULL, 0x004fe40000000065ULL,
0x0000541067197816ULL, 0x002fe2000000005eULL, 0x00000052005f7306ULL, 0x0003e20000200c00ULL,
0x0000005b30308232ULL, 0x010fc40000000000ULL, 0x0000005b32328232ULL, 0x000fe40000000000ULL,
0x0000006231318232ULL, 0x080fe20000000000ULL, 0x000000182c24723cULL, 0x000fe20000001824ULL,
0x000054105d557816ULL, 0x008fe20000000066ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000088801a527816ULL, 0x002fe200000000ffULL, 0x0000006233338232ULL, 0x000fc60000000000ULL,
0x000001001a197824ULL, 0x040fe200078e00ffULL, 0x0000541061187816ULL, 0x000fe2000000005aULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000052005e7306ULL, 0x0003e40000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe40000011419ULL, 0x000054105c197816ULL, 0x000fe40000000059ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x000088801b527816ULL, 0x002fc400000000ffULL, 0x000000182c34723cULL, 0x000fea0000001834ULL,
0x00000054006b7306ULL, 0x0003e40000200c00ULL, 0x000001001b187824ULL, 0x040fe400078e00ffULL,
0x000100001b1b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054106a547816ULL, 0x002fe40000000063ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000541050197816ULL, 0x004fc6000000004bULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000542c38723cULL, 0x000fee0000001838ULL,
0x0000004800487306ULL, 0x000ff00000200c00ULL, 0x0000004a004a7306ULL, 0x000e700000200c00ULL,
0x0000004900497306ULL, 0x000ea20000200c00ULL, 0x000054103d4a7816ULL, 0x002fce000000004aULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x000054103e4b7816ULL, 0x004fce0000000049ULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000004a301c723cULL, 0x000fe2000000181cULL,
0x0000541064647816ULL, 0x002fcc0000000043ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x000054106b657816ULL, 0x004fce0000000042ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000000643024723cULL, 0x000fee0000001824ULL, 0x0000005800587306ULL, 0x000e700000200c00ULL,
0x0000003c003c7306ULL, 0x000ea20000200c00ULL, 0x0000541053537816ULL, 0x002fce0000000058ULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054103c507816ULL, 0x004fce000000004dULL,
0x0000005a00557306ULL, 0x000ea20000200c00ULL, 0x000054104e517816ULL, 0x002fce0000000051ULL,
0x00000052002c7306ULL, 0x0003e20000200c00ULL, 0x000000503014723cULL, 0x000fe20000001814ULL,
0x000054105e5e7816ULL, 0x004fcc0000000055ULL, 0x00000018002d7306ULL, 0x0004e20000200c00ULL,
0x0000541057527816ULL, 0x002fce0000000056ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054104f187816ULL, 0x004fe2000000004cULL, 0x000000523028723cULL, 0x000fec0000001828ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000000183010723cULL, 0x000fee0000001810ULL,
0x0000001a001a7306ULL, 0x000e620000200c00ULL, 0x000054103f187816ULL, 0x000fc40000000046ULL,
0x0000541048197816ULL, 0x000fe4000000005fULL, 0x000054102c5f7816ULL, 0x008fc6000000002dULL,
0x0000001b001b7306ULL, 0x000ea40000200c00ULL, 0x000000183020723cULL, 0x000fe20000001820ULL,
0x0106b80aff1879a7ULL, 0x0007220008500009ULL, 0x000054101a1a7816ULL, 0x002fc80000000041ULL,
0x0000005e3038723cULL, 0x000fe20000001838ULL, 0x0106a00affff79a7ULL, 0x0007e20008500009ULL,
0x000054101b1b7816ULL, 0x004fce0000000040ULL, 0x0000001a3030723cULL, 0x008fde0000001834ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000102457824ULL, 0x000fca00078e0245ULL,
0x0000000e4500720cULL, 0x000fda0003f06070ULL, 0xffffff6000288947ULL, 0x01efea000383ffffULL,
0x0000000000097919ULL, 0x000ea20000002500ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0014ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff187224ULL, 0x002fe400078e0010ULL, 0x000000ffff147224ULL, 0x000fe200078e0029ULL,
0x0000000e0900720cULL, 0x004fda0003f06070ULL, 0x0000000000dc0947ULL, 0x000fea0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x000000d000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e0007ULL,
0x0000b08000047802ULL, 0x000fce0000000f00ULL, 0x0000007800f47944ULL, 0x008fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000007ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009200ff047b82ULL, 0x000ea40000000a00ULL,
0x0000000604057981ULL, 0x004ea2000c1e9900ULL, 0x00000000000b7919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe4000001160bULL, 0x000000080b0b7811ULL, 0x000fe200078ff0ffULL,
0x0000000005007220ULL, 0x004fca0000410000ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0b00087589ULL, 0x000f2200000e0000ULL, 0x0000002803287220ULL, 0x044fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002e032e7220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000003803387220ULL, 0x040fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fe20000410000ULL, 0x0000002a082a7220ULL, 0x050fe20000410000ULL,
0x0000002b082b7220ULL, 0x040fe20000410000ULL, 0x0000001208127220ULL, 0x040fe20000410000ULL,
0x0000001308137220ULL, 0x040fe20000410000ULL, 0x0000001608167220ULL, 0x040fe20000410000ULL,
0x0000001708177220ULL, 0x040fe20000410000ULL, 0x0000001e081e7220ULL, 0x040fe20000410000ULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000002208227220ULL, 0x040fe20000410000ULL,
0x0000002308237220ULL, 0x040fe20000410000ULL, 0x0000002608267220ULL, 0x040fe20000410000ULL,
0x0000002708277220ULL, 0x040fe20000410000ULL, 0x0000003a083a7220ULL, 0x040fe20000410000ULL,
0x0000003b083b7220ULL, 0x040fe20000410000ULL, 0x0000003208327220ULL, 0x040fe20000410000ULL,
0x0000003308337220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000001c1d1c723eULL, 0x000fe400000000ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000383938723eULL, 0x000fe400000000ffULL,
0x0000002a2b2b723eULL, 0x000fe400000000ffULL, 0x000000121312723eULL, 0x000fe400000000ffULL,
0x000000161716723eULL, 0x000fc400000000ffULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x000000010200780cULL, 0x000fe40003f05270ULL, 0x0000003a3b3a723eULL, 0x000fe400000000ffULL,
0x00000032331d723eULL, 0x000fe400000000ffULL, 0x000054102b2a7816ULL, 0x140fe40000000012ULL,
0x000076322b2b7816ULL, 0x000fc40000000012ULL, 0x0000000203007812ULL, 0x004fe400078ec0ffULL,
0x00000002ff157819ULL, 0x000fe40000011603ULL, 0x00000001ff047819ULL, 0x000fe40000011600ULL,
0x0000000200057811ULL, 0x040fe400078ff8ffULL, 0x00000004000a7811ULL, 0x040fe400078ff8ffULL,
0x00000006000e7811ULL, 0x000fc400078ff8ffULL, 0x00000008032d7811ULL, 0x000fe400078ff0ffULL,
0x0000000704007812ULL, 0x000fe400078e7815ULL, 0x0000000705087812ULL, 0x000fe400078e7815ULL,
0x000000070a0c7812ULL, 0x000fe200078e7815ULL, 0x00000008150b7824ULL, 0x040fe200078e0200ULL,
0x000000070e107812ULL, 0x000fe200078e7815ULL, 0x00000008150d7824ULL, 0x000fe200078e0208ULL,
0x0000000704047812ULL, 0x000fe200078e782dULL, 0x0000000803087824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078e782dULL, 0x0000000815117824ULL, 0x000fe200078e020cULL,
0x000000070a0a7812ULL, 0x000fe200078e782dULL, 0x000000082d197824ULL, 0x040fe200078e0204ULL,
0x000000070e0e7812ULL, 0x000fe200078e782dULL, 0x000000082d1b7824ULL, 0x000fe200078e0205ULL,
0x0000000947007c11ULL, 0x000fe2000f8e58ffULL, 0x000000082d297824ULL, 0x040fe200078e020aULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x000000082d2d7824ULL, 0x000fe200078e020eULL,
0x000000281404723eULL, 0x000fe200000000ffULL, 0x0000000815157824ULL, 0x000fe200078e0210ULL,
0x000000181a05723eULL, 0x000fe200000000ffULL, 0x0000a000000e7836ULL, 0x000fe20000000000ULL,
0x000000242510723eULL, 0x000fc400000000ffULL, 0x00007632042f7816ULL, 0x000fe20000000005ULL,
0x000000100b0b7824ULL, 0x100fe400078e020eULL, 0x000000100d0d7824ULL, 0x100fe400078e020eULL,
0x0000001011117824ULL, 0x100fe400078e020eULL, 0x0000001019197824ULL, 0x100fe400078e020eULL,
0x000000101b1b7824ULL, 0x100fe400078e020eULL, 0x0000001015157824ULL, 0x000fc400078e020eULL,
0x0000001029297824ULL, 0x100fe400078e020eULL, 0x000000102d2d7824ULL, 0x000fe400078e020eULL,
0x000000010b0b7824ULL, 0x000fe400078e0208ULL, 0x00000001080d7824ULL, 0x040fe400078e020dULL,
0x00000001080a7824ULL, 0x040fe200078e0211ULL, 0x000000262711723eULL, 0x000fe200000000ffULL,
0x0000000108197824ULL, 0x000fc400078e0219ULL, 0x00000001081b7824ULL, 0x040fe400078e021bULL,
0x0000000108157824ULL, 0x040fe400078e0215ULL, 0x0000000108297824ULL, 0x040fe400078e0229ULL,
0x00000001082d7824ULL, 0x000fe200078e022dULL, 0x0000002c2e08723eULL, 0x000fe400000000ffULL,
0x00005410042e7816ULL, 0x000fe40000000005ULL, 0x0000541008047816ULL, 0x000fc4000000001cULL,
0x0000763208057816ULL, 0x000fe2000000001cULL, 0x0000002e0b007388ULL, 0x0005e20000000a00ULL,
0x00000030311c723eULL, 0x000fc600000000ffULL, 0x000000040d007388ULL, 0x0009e20000000a00ULL,
0x0000001e1f0b723eULL, 0x004fe400000000ffULL, 0x0000541020047816ULL, 0x150fe40000000010ULL,
0x0000763220057816ULL, 0x000fe40000000010ULL, 0x0000541022107816ULL, 0x140fe40000000011ULL,
0x0000763222117816ULL, 0x000fe20000000011ULL, 0x000000040a007388ULL, 0x0005e40000000a00ULL,
0x0000541038047816ULL, 0x004fc4000000001cULL, 0x0000763238057816ULL, 0x000fe4000000001cULL,
0x00005410160a7816ULL, 0x140fe4000000000bULL, 0x00007632160b7816ULL, 0x000fe2000000000bULL,
0x0000000415007388ULL, 0x0005e20000000a00ULL, 0x000054103a1c7816ULL, 0x140fe4000000001dULL,
0x000076323a1d7816ULL, 0x000fe2000000001dULL, 0x0000002a19007388ULL, 0x0005e80000000a00ULL,
0x0000000a1b007388ULL, 0x0005e80000000a00ULL, 0x0000001029007388ULL, 0x0005e80000000a00ULL,
0x0000001c2d007388ULL, 0x0005e20000000a00ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000002000f48947ULL, 0x000fea0003800000ULL, 0x0000000000197919ULL, 0x004ea20000002700ULL,
0x00008400ff057b82ULL, 0x000ea20000000800ULL, 0x00000010030d7824ULL, 0x000fe200078e0200ULL,
0x000000ff4700720cULL, 0x000fe20003f05270ULL, 0x0000000000047919ULL, 0x000ea20000002600ULL,
0x00000020031f7836ULL, 0x040fe20000000000ULL, 0x0000040000187802ULL, 0x000fe20000000f00ULL,
0x00a000000d107984ULL, 0x0009240000000c00ULL, 0x00009000ff0c7b82ULL, 0x000f620000000800ULL,
0x000000ff0300720cULL, 0x000fe20000725670ULL, 0x00a200000d147984ULL, 0x0009220000000c00ULL,
0x00000000001b7919ULL, 0x000eaa0000008800ULL, 0x00009600ff0a7b82ULL, 0x000f220000000a00ULL,
0x0000000519197224ULL, 0x004fc400078e0204ULL, 0x0000000502057224ULL, 0x000fe400078e02ffULL,
0x0000000219047224ULL, 0x000fe400078e02ffULL, 0x0000000c050c7224ULL, 0x020fe400078e02ffULL,
0x0000000104207824ULL, 0x000fc600078e0209ULL, 0x00000fff0c057811ULL, 0x000fe400078e40ffULL,
0x000006541b187816ULL, 0x002fe40000000018ULL, 0x0000002005097211ULL, 0x000fca00078fa0ffULL,
0x0000100009087825ULL, 0x010fc800078e000aULL, 0x0000040047087825ULL, 0x000fc800078e0008ULL,
0x000000101f1e7825ULL, 0x000fc800078e0008ULL, 0x00000010031c7825ULL, 0x000fe200078e0008ULL,
0x01ffffff0c097812ULL, 0x000fe200078ec0ffULL, 0x0000000000380947ULL, 0x008fec0003800000ULL,
0x00009600ff1a7b82ULL, 0x000e620000000a00ULL, 0x0000000120217824ULL, 0x000fe200078e0209ULL,
0x00000001ff227819ULL, 0x000fe20000011603ULL, 0x0000001003087824ULL, 0x000fc600078e00ffULL,
0x0000000c22227812ULL, 0x000fe200078ec0ffULL, 0x00000080200c7825ULL, 0x002fc800078e001aULL,
0x00000080211a7825ULL, 0x000fe200078e001aULL, 0x0000007008217812ULL, 0x000fc800078ec0ffULL,
0x0000000c220c7210ULL, 0x140fe40007b5e021ULL, 0x0000001a221a7210ULL, 0x000fe40007d9e021ULL,
0x0000000dff0d7210ULL, 0x000fe400017e64ffULL, 0x0000001bff1b7210ULL, 0x000fc600027ea4ffULL,
0x000000060c007986ULL, 0x0003e8000c101906ULL, 0x000000071a007986ULL, 0x0003e4000c101906ULL,
0x000000101c007986ULL, 0x0005e8000c101d06ULL, 0x000000141e007986ULL, 0x0005e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000004c1947ULL, 0x000fea0003800000ULL,
0x00009400ff067b82ULL, 0x002e620000000a00ULL, 0xffffffff020d7836ULL, 0x000fe40000000000ULL,
0x0000000419067825ULL, 0x002fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x0000000d060679a8ULL, 0x000ee800099ee1c6ULL,
0x00000000ff00798fULL, 0x008fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000d0600720cULL, 0x000fc80003f25270ULL, 0x00000001ff087807ULL, 0x000fca0000800000ULL,
0x00000008ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x0000000018067984ULL, 0x002e640000000000ULL,
0x000000ff0600720cULL, 0x002fda0003f25270ULL, 0x0000001c00e09947ULL, 0x000fea0003800000ULL,
0x0000000c00300947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x0000000000d88947ULL, 0x000fea0003800000ULL, 0x0000001003087824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000001040d7836ULL, 0x040fe40000000000ULL,
0x0000008004067825ULL, 0x100fe200078e000aULL, 0x00000070081b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0c087812ULL, 0x000fe200078ec0ffULL, 0x000000800d0c7825ULL, 0x000fc600078e000aULL,
0x0000000608107210ULL, 0x144fe4000791e01bULL, 0x0000000c080c7210ULL, 0x000fe40007b5e01bULL,
0x00000007ff117210ULL, 0x000fe400007e24ffULL, 0x0000000dff0d7210ULL, 0x000fc600017e64ffULL,
0x0000000610067981ULL, 0x000368000c1e1900ULL, 0x000000060c077981ULL, 0x000362000c1e1900ULL,
0x000000020200780cULL, 0x000fda0003f05270ULL, 0x00000000009c8947ULL, 0x002fea0003800000ULL,
0x00000002040d7836ULL, 0x000fc80000000000ULL, 0x000000800d0c7825ULL, 0x000fc600078e000aULL,
0x0000000c080c7210ULL, 0x000fc8000791e01bULL, 0x0000000dff0d7210ULL, 0x000fcc00007e24ffULL,
0x000000060c0d7981ULL, 0x000362000c1e1900ULL, 0x000000040200780cULL, 0x000fda0003f06070ULL,
0x0000000000808947ULL, 0x002fea0003800000ULL, 0x0000000304117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fc8000791e01bULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610137981ULL, 0x000362000c1e1900ULL,
0x000000040200780cULL, 0x000fda0003f05270ULL, 0x0000000000648947ULL, 0x002fea0003800000ULL,
0x0000000404117836ULL, 0x000fc80000000000ULL, 0x0000008011107825ULL, 0x000fc600078e000aULL,
0x0000001008107210ULL, 0x000fc8000791e01bULL, 0x00000011ff117210ULL, 0x000fca00007e24ffULL,
0x0000000610157981ULL, 0x000362000c1e1900ULL, 0x000000060200780cULL, 0x000fda0003f06070ULL,
0x0000000000488947ULL, 0x002fea0003800000ULL, 0x0000000504117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fc8000791e01bULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610177981ULL, 0x000362000c1e1900ULL,
0x000000060200780cULL, 0x000fda0003f05270ULL, 0x00000000002c8947ULL, 0x002fea0003800000ULL,
0x000000080200780cULL, 0x000fe20003f06070ULL, 0x0000000604117836ULL, 0x000fc80000000000ULL,
0x0000008011107825ULL, 0x000fc600078e000aULL, 0x0000001008107210ULL, 0x000fca0007a3e01bULL,
0x0000000704190836ULL, 0x000fe20000000000ULL, 0x00000011ff117210ULL, 0x000fc60000fe44ffULL,
0x00000080190a0825ULL, 0x000fe400078e000aULL, 0x0000000610197981ULL, 0x000362000c1e1900ULL,
0x0000000a080a0210ULL, 0x000fc80007c7e01bULL, 0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL,
0x000000060a1b0981ULL, 0x000368000c1e1900ULL, 0x0000000702087836ULL, 0x000fca0000000000ULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000000800248947ULL, 0x000fea0003800000ULL, 0x00009600ff0a7b82ULL, 0x002e620000000a00ULL,
0x000000ffff127224ULL, 0x004fe200078e0004ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x020fe200078e0006ULL, 0x0000003f00057c82ULL, 0x000fcc0008000000ULL,
0x0000000402007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000508007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400f41947ULL, 0x022fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000001d06067209ULL, 0x000fe20007810000ULL,
0x0000000104097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000812117836ULL, 0x000fc60000000000ULL, 0x000000700c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x002fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e01dULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x00000006101d7981ULL, 0x000368000c1e1900ULL, 0x0000000400b42947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x0000000204097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011603ULL,
0x0000000912117836ULL, 0x002fc60000000000ULL, 0x0000007007077812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100c107210ULL, 0x000fc80007b3e007ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610077981ULL, 0x000368000c1e1900ULL, 0x0000000400742947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x0000000304097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x002fe20000011603ULL,
0x0000000a120d7836ULL, 0x000fc60000000000ULL, 0x000000700c117812ULL, 0x000fe200078ec0ffULL,
0x000000800d0c7825ULL, 0x000fe200078e000aULL, 0x0000000c10107812ULL, 0x000fc800078ec0ffULL,
0x0000000c100c7210ULL, 0x000fc80007b3e011ULL, 0x0000000dff0d7210ULL, 0x000fcc0000fe64ffULL,
0x000000060c0d7981ULL, 0x000366000c1e1900ULL, 0x0000000400342947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fe20007810000ULL,
0x0000000404097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000b12117836ULL, 0x000fc60000000000ULL, 0x000000700c137812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e013ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610137981ULL, 0x000368000c1e1900ULL, 0x0000000000f42947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001506067209ULL, 0x000fe20007810000ULL,
0x0000000504097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000c12117836ULL, 0x000fc60000000000ULL, 0x000000700c157812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e015ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610157981ULL, 0x000368000c1e1900ULL, 0x0000000000b42947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001706067209ULL, 0x000fe20007810000ULL,
0x0000000604097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000d12117836ULL, 0x000fc60000000000ULL, 0x000000700c177812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e017ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610177981ULL, 0x000368000c1e1900ULL, 0x0000000000742947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001906067209ULL, 0x000fe20007810000ULL,
0x0000000704097890ULL, 0x000fc8000fffe03fULL, 0x0000000802007c0cULL, 0x040fe4000bf23070ULL,
0x0000000902007c0cULL, 0x000fd6000bf43070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000e12117836ULL, 0x000fc60000000000ULL, 0x000000700c197812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007b3e019ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610197981ULL, 0x000368000c1e1900ULL, 0x0000000000342947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b06067209ULL, 0x000fca0007810000ULL,
0x0000000802007c0cULL, 0x000fda000bf23070ULL, 0x0000000000241947ULL, 0x000fea0003800000ULL,
0x00000010030c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff147819ULL, 0x000fe20000011603ULL,
0x0000000f12117836ULL, 0x000fc60000000000ULL, 0x000000700c1b7812ULL, 0x000fe200078ec0ffULL,
0x0000008011107825ULL, 0x000fe200078e000aULL, 0x0000000c14147812ULL, 0x000fc800078ec0ffULL,
0x0000001014107210ULL, 0x000fc80007a3e01bULL, 0x00000011ff117210ULL, 0x000fca0000fe44ffULL,
0x00000006101b7981ULL, 0x000368000c1e1900ULL, 0x0000000804047890ULL, 0x000fe2000fffe03fULL,
0x0000000812127836ULL, 0x000fe20000000000ULL, 0xfffffff400f08947ULL, 0x000ff4000383ffffULL,
0x0000000000037919ULL, 0x000ee40000000000ULL, 0x0000001003077824ULL, 0x028fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011603ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fc800078ec0ffULL, 0x0000001808077210ULL, 0x000fca0007ffe007ULL,
0x0000000607007388ULL, 0x0007e40000000800ULL, 0x00009600ff0c7b82ULL, 0x002e620000000a00ULL,
0x0000000405057211ULL, 0x000fe200078fa0ffULL, 0x0000040047197824ULL, 0x000fe200078e00ffULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x00000010031b7824ULL, 0x040fe200078e00ffULL,
0x00000016ff1a7819ULL, 0x000fe20000011647ULL, 0x0000000104457824ULL, 0x000fe200078e0209ULL,
0x00000001ff1d7819ULL, 0x004fe20000011603ULL, 0x0000002003097836ULL, 0x000fe20000000000ULL,
0x000000701b1b7812ULL, 0x000fe200078ec0ffULL, 0x00001000471c7824ULL, 0x000fe200078e0218ULL,
0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000001003117824ULL, 0x000fe200078e021cULL,
0x000000181d1e7210ULL, 0x000fe20007ffe01bULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000010047108824ULL, 0x140fe200078e0218ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000010047128824ULL, 0x000fe200078e0218ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000001003138824ULL, 0x040fe200078e0210ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000001003158824ULL, 0x000fe200078e0212ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000100005067825ULL, 0x00afe200078e000cULL, 0x00000000002c7805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000080450a8825ULL, 0x100fe200078e000cULL, 0x0000001906067210ULL, 0x000fe40007f3e0ffULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000080040c8825ULL, 0x000fe200078e000cULL, 0x0000000000367805ULL, 0x000fc4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000107077824ULL, 0x000fe200008e061aULL, 0x000000ff0200720cULL, 0x000fe20003f25270ULL,
0x00000010030a8825ULL, 0x000fe200078e000aULL, 0x000000001e1e7984ULL, 0x000e620000000800ULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000001009087825ULL, 0x000fc800078e0006ULL, 0x0000001003067825ULL, 0x000fc800078e0006ULL,
0x00000010030c8825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000006117faeULL, 0x0005e6000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0038000008117faeULL, 0x0005e8000b901c46ULL, 0x045800000a138faeULL, 0x0005e8000b901c46ULL,
0x041800000c158faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008005c9947ULL, 0x000fea0003800000ULL, 0x00009600ff0c7b82ULL, 0x004ea20000000a00ULL,
0x00000003ff067819ULL, 0x100fe20000011603ULL, 0x0000000145457836ULL, 0x000fe20000000000ULL,
0xfffffff8ff077812ULL, 0x000fe200078ee203ULL, 0x0000000105497836ULL, 0x000fe20000000000ULL,
0x0000000306067812ULL, 0x000fe200078ec0ffULL, 0x00000001044d7836ULL, 0x000fe20000000000ULL,
0x00000002ff447819ULL, 0x000fe20000011603ULL, 0x0000000807097836ULL, 0x040fe20000000000ULL,
0x0000000406087812ULL, 0x000fe200078efcffULL, 0x0000000807417824ULL, 0x000fe200078e00ffULL,
0x0000000706407812ULL, 0x000fe200078e7807ULL, 0x0000000809437824ULL, 0x000fe200078e00ffULL,
0x0000000706427812ULL, 0x000fe200078e7809ULL, 0x00000001ff4b7424ULL, 0x000fe200078e00ffULL,
0x0000000708067812ULL, 0x000fe200078e7807ULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x0000000708087812ULL, 0x000fe200078e7809ULL, 0x0000010047487824ULL, 0x000fe200078e0218ULL,
0x0000004140407212ULL, 0x000fe200078efcffULL, 0x0000000844467836ULL, 0x000fe20000000000ULL,
0x0000004342427212ULL, 0x000fc400078efcffULL, 0x0000004106417212ULL, 0x000fe400078efcffULL,
0x0000004308437212ULL, 0x004fce00078efcffULL, 0x000000024b00720cULL, 0x000fda0003f06070ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x0000100049047825ULL, 0x000fe200078e000cULL,
0x000000070300780cULL, 0x000fe40003f24070ULL, 0x000000014b137812ULL, 0x000fe200078ec0ffULL,
0x0000002003157836ULL, 0x000fe20000000000ULL, 0x00000019040a7210ULL, 0x000fe20007f1e0ffULL,
0x000008004b047824ULL, 0x000fc800078e00ffULL, 0x00000001050b7824ULL, 0x000fe200000e061aULL,
0x0000080004097812ULL, 0x000fc600078ec0ffULL, 0x0000010047489824ULL, 0x000fe400078e0218ULL,
0x000000011c087824ULL, 0x000fe400078e0209ULL, 0x0000008045069825ULL, 0x000fc800078e000cULL,
0x000000804d049825ULL, 0x000fc800078e000cULL, 0x0000008013109824ULL, 0x000fe400078e0248ULL,
0x0000001003117824ULL, 0x000fe400078e0208ULL, 0x0000008013129824ULL, 0x000fe400078e0248ULL,
0x0000001015087825ULL, 0x000fc800078e000aULL, 0x00000010030a7825ULL, 0x000fc800078e000aULL,
0x0000001003069825ULL, 0x040fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a117faeULL, 0x0005e6000b901c46ULL, 0x0000001003139824ULL, 0x040fe200078e0210ULL,
0x0038000008117faeULL, 0x0005e2000b901c46ULL, 0x0000001003049825ULL, 0x000fc600078e0004ULL,
0x0458000006139faeULL, 0x0005e2000b901c46ULL, 0x0000001003159824ULL, 0x000fca00078e0212ULL,
0x0418000004159faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff4b047836ULL, 0x044fe20000000000ULL, 0x000000024b00720cULL, 0x040fe20003f06070ULL,
0x000000014b4b7836ULL, 0x000fe40000000000ULL, 0x0000008004057824ULL, 0x040fe400078e00ffULL,
0x0000080004047824ULL, 0x000fe400078e00ffULL, 0x0000000145457836ULL, 0x000fe20000000000ULL,
0x0000008005057812ULL, 0x000fe200078ec0ffULL, 0x0000000149497836ULL, 0x000fc40000000000ULL,
0x000000014d4d7836ULL, 0x000fe20000000000ULL, 0x000000481b067210ULL, 0x000fe40007ffe005ULL,
0x0000080004057812ULL, 0x000fc600078ec0ffULL, 0x000000011d4a7824ULL, 0x000fe200078e0206ULL,
0x000001801c147810ULL, 0x000fe20007ffe005ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180004a117984ULL, 0x000ea20000000800ULL, 0x0000001040047824ULL, 0x100fe400078e0214ULL,
0x0000001041087824ULL, 0x100fe200078e0214ULL, 0x004580004a4f7984ULL, 0x000fe20000000800ULL,
0x0000001042107824ULL, 0x100fe400078e0214ULL, 0x0000001043147824ULL, 0x000fe200078e0214ULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000000808783bULL, 0x000f220000000200ULL,
0x000000111e157221ULL, 0x006fc60000010100ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x3fb8aa3b154e7820ULL, 0x000fc60000410000ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x20000006ff4c7230ULL, 0x008fe40000004100ULL, 0x0000004e004e7308ULL, 0x000ee20000000800ULL,
0x30000006ff517230ULL, 0x000fe40000004100ULL, 0x30000008ff537230ULL, 0x010fe40000004100ULL,
0x2000000aff507230ULL, 0x000fe40000004100ULL, 0x3000000aff557230ULL, 0x000fc40000004100ULL,
0x20000005ff4a7230ULL, 0x000fe40000004100ULL, 0x20000007ff067230ULL, 0x000fe40000004100ULL,
0x2000000bff0a7230ULL, 0x000fe40000004100ULL, 0x0000004f4e5f7220ULL, 0x008fe20000410000ULL,
0x20000008ff4e7230ULL, 0x000fe40000004100ULL, 0x20000004ff4f7230ULL, 0x000fe40000004100ULL,
0x0000003e5f3e7221ULL, 0x000fe20000010000ULL, 0x00001f445f5c7589ULL, 0x000ee200000e0000ULL,
0x20000009ff087230ULL, 0x000fc40000004100ULL, 0x30000004ff047230ULL, 0x000fe20000004100ULL,
0x00001f465f5e7589ULL, 0x000f2200000e0000ULL, 0x30000005ff057230ULL, 0x000fe40000004100ULL,
0x30000007ff077230ULL, 0x000fe40000004100ULL, 0x30000009ff097230ULL, 0x000fe40000004100ULL,
0x3000000bff0b7230ULL, 0x000fe40000004100ULL, 0x20000010ff527230ULL, 0x002fc40000004100ULL,
0x30000010ff577230ULL, 0x000fe40000004100ULL, 0x20000012ff547230ULL, 0x000fe40000004100ULL,
0x30000012ff597230ULL, 0x000fe40000004100ULL, 0x20000014ff567230ULL, 0x004fe40000004100ULL,
0x30000014ff5b7230ULL, 0x000fe40000004100ULL, 0x0000005c4f207223ULL, 0x008fe20000010020ULL,
0x20000011ff107230ULL, 0x000fc40000004100ULL, 0x0000005c041f7223ULL, 0x080fe2000001001fULL,
0x20000013ff127230ULL, 0x000fe40000004100ULL, 0x0000005c4a3d7223ULL, 0x080fe2000001003dULL,
0x20000015ff147230ULL, 0x000fe40000004100ULL, 0x0000005c053a7223ULL, 0x080fe2000001003aULL,
0x20000016ff587230ULL, 0x000fe40000004100ULL, 0x0000005c4c397223ULL, 0x000fe20000010039ULL,
0x30000016ff5d7230ULL, 0x000fc40000004100ULL, 0x0000005c51367223ULL, 0x080fe20000010036ULL,
0x30000011ff117230ULL, 0x000fe40000004100ULL, 0x0000005c06357223ULL, 0x080fe20000010035ULL,
0x30000013ff137230ULL, 0x000fe40000004100ULL, 0x0000005c07327223ULL, 0x080fe20000010032ULL,
0x30000015ff157230ULL, 0x000fe40000004100ULL, 0x0000005c4e317223ULL, 0x000fe20000010031ULL,
0x20000017ff167230ULL, 0x000fc40000004100ULL, 0x0000005c532e7223ULL, 0x080fe2000001002eULL,
0x30000017ff5a7230ULL, 0x000fe40000004100ULL, 0x0000005c082d7223ULL, 0x080fe2000001002dULL,
0x0000005c092a7223ULL, 0x080fe2000001002aULL, 0x0000005c50297223ULL, 0x080fe20000010029ULL,
0x0000005c55267223ULL, 0x080fe20000010026ULL, 0x0000005c0a257223ULL, 0x080fe20000010025ULL,
0x0000005c0b227223ULL, 0x000fe20000010022ULL, 0x0000005e52217223ULL, 0x090fe20000010021ULL,
0x0000005e573c7223ULL, 0x080fe2000001003cULL, 0x0000005e103b7223ULL, 0x080fe2000001003bULL,
0x0000005e11387223ULL, 0x080fe20000010038ULL, 0x0000005e54377223ULL, 0x080fe20000010037ULL,
0x0000005e59347223ULL, 0x080fe20000010034ULL, 0x0000005e12337223ULL, 0x080fe20000010033ULL,
0x0000005e13307223ULL, 0x080fe20000010030ULL, 0x0000005e562f7223ULL, 0x080fe2000001002fULL,
0x0000005e5b2c7223ULL, 0x080fe2000001002cULL, 0x0000005e142b7223ULL, 0x080fe2000001002bULL,
0x0000005e15287223ULL, 0x080fe20000010028ULL, 0x0000005e58277223ULL, 0x080fe20000010027ULL,
0x0000005e5d247223ULL, 0x080fe20000010024ULL, 0x0000005e16237223ULL, 0x080fe20000010023ULL,
0x0000005e5a3f7223ULL, 0x000fe2000001003fULL, 0xfffffff800048947ULL, 0x000fec000383ffffULL,
0x018000003e027836ULL, 0x000fe20000000000ULL, 0x0000000000007b1dULL, 0x000fe80000010000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000d77000047802ULL, 0x000fce0000000f00ULL,
0x0000005400387944ULL, 0x006fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000003e00037308ULL, 0x000ee40000001000ULL,
0xbf80000003027423ULL, 0x008fc8000000003eULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fce0000000003ULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x00000002ff097819ULL, 0x10cfe40000011603ULL, 0x00000008030b7811ULL, 0x000fe400078ff0ffULL,
0x00000003ff0d7819ULL, 0x000fe20000011603ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0902047589ULL, 0x000ea200000e0000ULL, 0x000000030d0d7812ULL, 0x000fc600078ec0ffULL,
0x00001f0b020c7589ULL, 0x00072200000e0000ULL, 0x000000040d137812ULL, 0x000fe200078efcffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0xfffffff8ff027812ULL, 0x008fc800078ee203ULL,
0x000000070d117812ULL, 0x000fe200078e7802ULL, 0x0000000802107836ULL, 0x000fc80000000000ULL,
0x0000000810127824ULL, 0x000fe400078e00ffULL, 0x0000002004207220ULL, 0x044fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000003d04057220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003904067220ULL, 0x040fe20000410000ULL,
0x0000003604077220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003104087220ULL, 0x040fe20000410000ULL,
0x0000002e04097220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x00000029040a7220ULL, 0x040fe20000410000ULL,
0x00000026040b7220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x000fe20000410000ULL, 0x0000000802047824ULL, 0x000fe200078e00ffULL,
0x000000070d157812ULL, 0x000fe200078e7810ULL, 0x000000210c217220ULL, 0x050fe20000410000ULL,
0x00000007130d7812ULL, 0x000fe200078e7802ULL, 0x0000003c0c3c7220ULL, 0x040fe20000410000ULL,
0x0000000713137812ULL, 0x000fe200078e7810ULL, 0x0000003b0c3b7220ULL, 0x040fe20000410000ULL,
0x0000000411117212ULL, 0x000fe200078efcffULL, 0x000000380c387220ULL, 0x040fe20000410000ULL,
0x000000040d0d7212ULL, 0x000fe200078efcffULL, 0x000000370c377220ULL, 0x040fe20000410000ULL,
0x000000340c347220ULL, 0x040fe20000410000ULL, 0x000000330c337220ULL, 0x040fe20000410000ULL,
0x000000300c307220ULL, 0x040fe20000410000ULL, 0x0000002f0c2f7220ULL, 0x040fe20000410000ULL,
0x0000002c0c2c7220ULL, 0x040fe20000410000ULL, 0x0000002b0c2b7220ULL, 0x040fe20000410000ULL,
0x000000280c287220ULL, 0x040fe20000410000ULL, 0x000000270c277220ULL, 0x040fe20000410000ULL,
0x000000240c247220ULL, 0x040fe20000410000ULL, 0x000000230c237220ULL, 0x040fe20000410000ULL,
0x0000001215157212ULL, 0x080fe200078efcffULL, 0x0000003f0c0c7220ULL, 0x000fe20000410000ULL,
0x0000001213137212ULL, 0x000fe200078efcffULL, 0x0000001011027824ULL, 0x100fe200078e020eULL,
0x000000060706723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x100fe200078e020eULL,
0x000000201f04723eULL, 0x000fe200000000ffULL, 0x0000001015107824ULL, 0x100fe200078e020eULL,
0x000000053a05723eULL, 0x000fe200000000ffULL, 0x00000010130e7824ULL, 0x000fe200078e020eULL,
0x000000353207723eULL, 0x000fc400000000ffULL, 0x000000080908723eULL, 0x000fe400000000ffULL,
0x0000000a0b0a723eULL, 0x000fe200000000ffULL, 0x0000000402007844ULL, 0x0005e20000000200ULL,
0x0000002d2a09723eULL, 0x000fe400000000ffULL, 0x00000025220b723eULL, 0x000fe400000000ffULL,
0x000000213c3c723eULL, 0x000fe400000000ffULL, 0x0000003b383d723eULL, 0x000fe200000000ffULL,
0x000000080d007844ULL, 0x0005e20000000200ULL, 0x00000037343e723eULL, 0x002fc400000000ffULL,
0x00000033303f723eULL, 0x000fe400000000ffULL, 0x0000002f2c20723eULL, 0x000fe400000000ffULL,
0x0000002b2821723eULL, 0x000fe200000000ffULL, 0x0000003c10007844ULL, 0x0005e20000000200ULL,
0x000000272422723eULL, 0x000fe400000000ffULL, 0x000000230c23723eULL, 0x000fca00000000ffULL,
0x000000200e007844ULL, 0x0005e20000000200ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000020030d7836ULL, 0x004fe20000000000ULL, 0x00000000000c7919ULL, 0x000ea20000002600ULL,
0x00000003ff0e7819ULL, 0x000fe20000011603ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff047819ULL, 0x000fe2000001160dULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x000000070e027812ULL, 0x000fe400078e4803ULL,
0x0000000704067812ULL, 0x000fe400078e480dULL, 0x0ffffff802057812ULL, 0x000fc400078ef803ULL,
0x0ffffff806077812ULL, 0x000fc600078ef80dULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x000fc600078e0200ULL, 0x00a0000005087984ULL, 0x000b680000000c00ULL,
0x00a0000007107984ULL, 0x0005620000000c00ULL, 0x00000005040472a4ULL, 0x010fe2000f8e023fULL,
0x000000080c157824ULL, 0x044fe400078e00ffULL, 0x000000080c177824ULL, 0x000fc600078e00ffULL,
0xfffffff815007812ULL, 0x000fe400078ee20eULL, 0xfffffff817047812ULL, 0x000fe400078ee204ULL,
0x00000004000c7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000404057c10ULL, 0x020fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0x00000007030e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x000000040c027c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000000405047c11ULL, 0x000fc4000f8248ffULL,
0x000000070d007812ULL, 0x000fe400078ec0ffULL, 0x000000050c037c11ULL, 0x000fe400080f4c03ULL,
0x1ffffff80e077812ULL, 0x008fe400078ef80fULL, 0x0000000505057c11ULL, 0x000fe400088f4c06ULL,
0x1ffffff8000f7812ULL, 0x000fe200078ef80fULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100f047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x000fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009200ff0a7b82ULL, 0x000e620000000a00ULL, 0x00000001450d7836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000060a057981ULL, 0x002366000c1e9900ULL,
0x0000000e0d00720cULL, 0x000fe20003f06070ULL, 0x0000000213037824ULL, 0x000fe400078e00ffULL,
0x0000004047047824ULL, 0x000fe400078e00ffULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000010045147824ULL, 0x000fe400078e0204ULL, 0x0000000803037e24ULL, 0x000fe2000f8e0210ULL,
0x01060008ff0679a7ULL, 0x0002a60008500009ULL, 0x0000000403217c24ULL, 0x000fe2000f8e0214ULL,
0x00000004006c8947ULL, 0x000fec0003800000ULL, 0x00008a00ff0a7b82ULL, 0x002e620000000a00ULL,
0x00000002ff287819ULL, 0x100fe40000011600ULL, 0x0000003009237812ULL, 0x000fe400078ec0ffULL,
0x0000001444097248ULL, 0x000fe20007fe0000ULL, 0x00000001280d7824ULL, 0x040fe200078e0221ULL,
0x00000003ff0f7819ULL, 0x000fe20000011600ULL, 0x00000010281e7836ULL, 0x040fe40000000000ULL,
0x00000008281a7836ULL, 0x000fe20000000000ULL, 0x000000030f0f7812ULL, 0x000fe200078e4800ULL,
0x0000000121137824ULL, 0x000fc400078e021eULL, 0x000000011a117824ULL, 0x000fe400078e0221ULL,
0x0000001828207836ULL, 0x040fe40000000000ULL, 0x0000000109097824ULL, 0x000fe400078e0a14ULL,
0x0000000121157824ULL, 0x000fe400078e0220ULL, 0x0000002028227836ULL, 0x000fe20000000000ULL,
0x000000091e00720cULL, 0x080fe20003fa6070ULL, 0x000001000d0c7825ULL, 0x002fe200078e000aULL,
0x000000092000720cULL, 0x000fc40003f86070ULL, 0x000000092200720cULL, 0x000fe20003f66070ULL,
0x0000010013127825ULL, 0x000fe200078e000aULL, 0x000000230c167210ULL, 0x000fc60007f1e0ffULL,
0x0000010011107825ULL, 0x000fc800078e000aULL, 0x000000ffff177224ULL, 0x000fe200000e060dULL,
0x00000023120c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010015147825ULL, 0x000fe200078e000aULL,
0x0000002310187210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e0613ULL,
0x000000092800720cULL, 0x000fe20003f06070ULL, 0x0000000121137824ULL, 0x000fe400078e0222ULL,
0x000000ffff197224ULL, 0x000fe200008e0611ULL, 0x0000002314107210ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fe200078e000aULL, 0x0000000947147c11ULL, 0x000fc6000f8e68ffULL,
0x000000ffff117224ULL, 0x000fe200008e0615ULL, 0x0ffffffc0f157812ULL, 0x000fe200078ef800ULL,
0x00002000141c7836ULL, 0x000fe20000000000ULL, 0x0000002312147210ULL, 0x000fe20007f5e0ffULL,
0x0000002828247836ULL, 0x000fe20000000000ULL, 0x000000091a00720cULL, 0x080fe20003f26070ULL,
0x00000010151d7824ULL, 0x000fe400078e021cULL, 0x000000ffff157224ULL, 0x000fe200010e0613ULL,
0x000000092400720cULL, 0x000fe20003f46070ULL, 0x0000000121137824ULL, 0x000fe200078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000161d7faeULL, 0x0003e2000c101c46ULL,
0x000000041a1a7824ULL, 0x000fc400078e00ffULL, 0x0000010013127825ULL, 0x000fc600078e000aULL,
0xfffffffc1a1b7812ULL, 0x000fe200078ee20fULL, 0x0000003028267836ULL, 0x040fe20000000000ULL,
0x00000023121a7210ULL, 0x000fe20007fde0ffULL, 0x0000003828287836ULL, 0x000fe40000000000ULL,
0x000000101b1f7824ULL, 0x000fe400078e021cULL, 0x000000ffff1b7224ULL, 0x000fe200030e0613ULL,
0x000000092800720cULL, 0x080fe20003f06070ULL, 0x0000000121137824ULL, 0x000fe200078e0226ULL,
0x00000000181f7faeULL, 0x0007e2000c901c46ULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000092600720cULL, 0x000fe20003f26070ULL, 0x0000010013127825ULL, 0x000fc600078e000aULL,
0xfffffffc1e097812ULL, 0x000fe200078ee20fULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x0000002312127210ULL, 0x000fe20007fde0ffULL, 0x0000000121217824ULL, 0x000fe400078e0228ULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0xfffffffc20177812ULL, 0x002fe200078ee20fULL,
0x0000000424247824ULL, 0x000fe400078e00ffULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0xfffffffc22197812ULL, 0x008fe200078ee20fULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0xfffffffc241d7812ULL, 0x000fe200078ee20fULL, 0x00000100210a7825ULL, 0x000fe200078e000aULL,
0xfffffffc261f7812ULL, 0x000fc400078ee20fULL, 0xfffffffc280f7812ULL, 0x000fe200078ee20fULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x000000230a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001009097824ULL, 0x100fe400078e021cULL, 0x0000001017177824ULL, 0x100fe400078e021cULL,
0x0000001019197824ULL, 0x100fe200078e021cULL, 0x000000000c097faeULL, 0x0003e2000e901c46ULL,
0x000000101d1d7824ULL, 0x100fe400078e021cULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x0000000010177faeULL, 0x0003e2000e101c46ULL, 0x000000100f0f7824ULL, 0x000fc400078e021cULL,
0x000000ffff0b7224ULL, 0x000fe200030e060bULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x000000001a1d7faeULL, 0x0003e8000d101c46ULL, 0x00000000121f7faeULL, 0x0003e8000c901c46ULL,
0x000000000a0f7faeULL, 0x0003e2000c101c46ULL, 0x00000004003c7947ULL, 0x000fea0003800000ULL,
0x00008a00ff0a7b82ULL, 0x002e620000000a00ULL, 0x00000003ff117819ULL, 0x000fe40000011600ULL,
0x0000000800147811ULL, 0x040fe400078ff0ffULL, 0x0000000947127c11ULL, 0x000fe4000f8e68ffULL,
0x00000010000c7811ULL, 0x040fe400078ff0ffULL, 0x00000018000d7811ULL, 0x000fe200078ff0ffULL,
0x0000200012297836ULL, 0x000fe20000000000ULL, 0x00000020000f7811ULL, 0x000fe200078ff0ffULL,
0x000000040c127824ULL, 0x000fe200078e00ffULL, 0x00000003111b7812ULL, 0x000fe200078e4800ULL,
0x0000000114117824ULL, 0x000fe200078e0221ULL, 0x0000002800107811ULL, 0x000fe200078ff0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0000003000187811ULL, 0x040fe200078ff0ffULL,
0x000000040d167824ULL, 0x000fe200078e00ffULL, 0x00000038001c7811ULL, 0x040fe200078ff0ffULL,
0x0000000121177824ULL, 0x000fe200078e020fULL, 0x0000003009097812ULL, 0x000fe200078ec0ffULL,
0x000000040f1a7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1b0f7812ULL, 0x000fe200078ef800ULL,
0x0000000121137824ULL, 0x040fe200078e020cULL, 0xfffffffc140c7812ULL, 0x000fe200078ee21bULL,
0x0000000121157824ULL, 0x040fe200078e020dULL, 0x00000021000d7211ULL, 0x000fe200078ff0ffULL,
0x0000000121197824ULL, 0x000fe200078e0210ULL, 0xfffffffc1a147812ULL, 0x000fe200078ee21bULL,
0x00000004101e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc12107812ULL, 0x000fe200078ee21bULL,
0x0000000418207824ULL, 0x000fe200078e00ffULL, 0xfffffffc16127812ULL, 0x000fe200078ee21bULL,
0x000000041c227824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e167812ULL, 0x000fe200078ee21bULL,
0x000000100f2b7824ULL, 0x100fe200078e0229ULL, 0xfffffffc201a7812ULL, 0x000fe200078ee21bULL,
0x000000100c0f7824ULL, 0x100fe200078e0229ULL, 0xfffffffc221e7812ULL, 0x000fe200078ee21bULL,
0x00000010101d7824ULL, 0x000fc400078e0229ULL, 0x000001000d0c7825ULL, 0x002fc800078e000aULL,
0x00000001211b7824ULL, 0x040fe200078e0218ULL, 0x000000090c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000121277824ULL, 0x000fe400078e021cULL, 0x00000010121f7824ULL, 0x000fe400078e0229ULL,
0x0000010011107825ULL, 0x000fc800078e000aULL, 0x0000001014217824ULL, 0x000fe200078e0229ULL,
0x0000000910107210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fc800078e000aULL,
0x0000010015147825ULL, 0x000fe200078e000aULL, 0x0000000912127210ULL, 0x000fc60007f5e0ffULL,
0x0000001016237824ULL, 0x000fe200078e0229ULL, 0x0000000914147210ULL, 0x000fe20007f7e0ffULL,
0x0000010017167825ULL, 0x000fc800078e000aULL, 0x000000101a257824ULL, 0x000fe400078e0229ULL,
0x0000010019187825ULL, 0x000fc800078e000aULL, 0x000001001b1a7825ULL, 0x000fc800078e000aULL,
0x00000100270a7825ULL, 0x000fc800078e000aULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000000916167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200008e0611ULL,
0x0000000918187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x000000091a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x000000090a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc400008e0619ULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x00000000100f7faeULL, 0x0003e2000b901c46ULL, 0x000000101e297824ULL, 0x000fe400078e0229ULL,
0x000000ffff0b7224ULL, 0x000fe200018e060bULL, 0x00000000121d7faeULL, 0x0003e8000b901c46ULL,
0x00000000141f7faeULL, 0x0003e8000b901c46ULL, 0x0000000016217faeULL, 0x0003e8000b901c46ULL,
0x0000000018237faeULL, 0x0003e8000b901c46ULL, 0x000000001a257faeULL, 0x0003e8000b901c46ULL,
0x000000000a297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01060007ff0075a7ULL, 0x004ea20008000149ULL, 0x0000002047097824ULL, 0x002fc800078e0200ULL,
0x00000020090b7824ULL, 0x000fe200078e00ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011609ULL,
0x1ffffffe0a0a7812ULL, 0x000fe400078ec0ffULL, 0x000001e00b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000070a0c7812ULL, 0x000fe400078e7809ULL, 0x000000010a107812ULL, 0x000fc600078efcffULL,
0x000000010b0c7824ULL, 0x000fe200078e020cULL, 0x0000000710107812ULL, 0x000fc800078e7809ULL,
0x000000090c0c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000010b107824ULL, 0x000fe200078e0210ULL,
0x0000003800908947ULL, 0x004fec0003800000ULL, 0x0000000910107c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c187984ULL, 0x000e620000000c00ULL, 0x000000100a067836ULL, 0x040fe20000000000ULL,
0x0000000e4500720cULL, 0x000fe20003f26070ULL, 0x000000110a0a7836ULL, 0x000fe20000000000ULL,
0x0000000010147984ULL, 0x000ea40000000c00ULL, 0x0000000706067812ULL, 0x000fe400078e7809ULL,
0x000000070a0a7812ULL, 0x000fc600078e7809ULL, 0x000000010b067824ULL, 0x040fe400078e0206ULL,
0x000000010b0a7824ULL, 0x000fc600078e020aULL, 0x0000000906067c11ULL, 0x000fe4000f8e20ffULL,
0x000000090a0a7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1c7224ULL, 0x002fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001aULL, 0x000000ffff1e7224ULL, 0x004fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff207224ULL, 0x000fc400078e0019ULL,
0x000000ffff217224ULL, 0x000fe200078e001bULL, 0x0000001c0c007388ULL, 0x000fe20000000c00ULL,
0x000000ffff227224ULL, 0x000fe400078e0015ULL, 0x000000ffff237224ULL, 0x000fca00078e0017ULL,
0x0000002010007388ULL, 0x000fe80000000c00ULL, 0x000000000a147984ULL, 0x000e680000000c00ULL,
0x0000000006187984ULL, 0x000ea20000000c00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002406007388ULL, 0x0003e80000000c00ULL, 0x000000140a007388ULL, 0x0003e20000000c00ULL,
0x01060008ff0879a7ULL, 0x000ea40008500009ULL, 0x01060009ff0075a7ULL, 0x004ea40008000149ULL,
0x00000038001c8947ULL, 0x006fea0003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x3d80000005057820ULL, 0x020fe20000410000ULL, 0x0000000947067c11ULL, 0x040fe2000f8e18ffULL,
0xffffffff0e087836ULL, 0x000fe20000000000ULL, 0x0000000947077c11ULL, 0x000fe2000f8e28ffULL,
0x000000ffff097224ULL, 0x000fce00078e00ffULL, 0x00000100450b7824ULL, 0x000fca00078e0204ULL,
0x0000000b4400720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fce000001ff00ULL,
0x000000010a0d7836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff3d7224ULL, 0x000fe400078e000aULL, 0x000000ffff0a7224ULL, 0x100fe200078e000dULL,
0x00000002ff097819ULL, 0x000fe4000001160dULL, 0x000000040d00780cULL, 0x040fe40003f06070ULL,
0x000000030d107812ULL, 0x000fe200078ec0ffULL, 0x0000000209097224ULL, 0x000fc800078e0245ULL,
0x00000001090f7836ULL, 0x040fe40000000000ULL, 0x0000010009147824ULL, 0x000fe200078e0204ULL,
0x000000010c097812ULL, 0x000fe400078e0cffULL, 0x0000000e0f00720cULL, 0x000fe20003f26070ULL,
0x00000004030f7c24ULL, 0x000fd8000f8e0214ULL, 0x0000000400589947ULL, 0x000fea0003800000ULL,
0x00008a00ff127b82ULL, 0x000e620000000a00ULL, 0x00000014440d7248ULL, 0x000fe20007fe0000ULL,
0x0000000410157824ULL, 0x000fe200078e00ffULL, 0x00000002ff1e7819ULL, 0x100fe40000011600ULL,
0x00000003ff3f7819ULL, 0x000fe20000011600ULL, 0x000000010d117824ULL, 0x000fe200078e0a14ULL,
0x0000000947107c11ULL, 0x000fe2000f8e68ffULL, 0x000000081e1c7836ULL, 0x040fe20000000000ULL,
0x000000003f147212ULL, 0x000fe200078e3cffULL, 0x000000201e407836ULL, 0x000fe20000000000ULL,
0xfffffffc150d7812ULL, 0x000fe200078ee200ULL, 0x0000100009167824ULL, 0x000fe200078e0210ULL,
0x0000000314437812ULL, 0x000fe200078ec0ffULL, 0x000000011e157824ULL, 0x140fe200078e020fULL,
0x000000111e00720cULL, 0x080fe20003f26070ULL, 0x000000011c177824ULL, 0x040fe200078e020fULL,
0x000000111c00720cULL, 0x0c0fe20003f46070ULL, 0x000000041c3c7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc431d7812ULL, 0x000fe200078ef800ULL, 0x00002000161c7836ULL, 0x000fe20000000000ULL,
0x000000114000720cULL, 0x000fe20003f66070ULL, 0x000000281e427836ULL, 0x000fe20000000000ULL,
0xfffffffc3c1f7812ULL, 0x000fe200078ee243ULL, 0x0000010015147825ULL, 0x002fc600078e0012ULL,
0x000000114200720cULL, 0x000fe20003f86070ULL, 0x0000010017167825ULL, 0x000fc800078e0012ULL,
0x000000100d147825ULL, 0x000fc800078e0014ULL, 0x000000101d1d7824ULL, 0x100fe400078e021cULL,
0x000000101f1f7824ULL, 0x000fe400078e021cULL, 0x000000100d167825ULL, 0x000fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e6000c901c46ULL,
0x000000101e3c7836ULL, 0x040fe20000000000ULL, 0x00000000161f7faeULL, 0x0005e2000d101c46ULL,
0x000000181e3e7836ULL, 0x000fc40000000000ULL, 0x000000301e467836ULL, 0x000fe20000000000ULL,
0x000000113c00720cULL, 0x080fe20003f26070ULL, 0x000000381e1e7836ULL, 0x000fe20000000000ULL,
0x000000113e00720cULL, 0x080fe20003f46070ULL, 0x0000000146417824ULL, 0x140fe200078e020fULL,
0x000000114600720cULL, 0x080fe20003fa6070ULL, 0x00000001401d7824ULL, 0x102fe200078e020fULL,
0x000000111e00720cULL, 0x000fe20003fc6070ULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x00000001421f7824ULL, 0x004fc400078e020fULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0xfffffffc40497812ULL, 0x000fe200078ee243ULL, 0x000000013c157824ULL, 0x100fe400078e020fULL,
0x000000013e177824ULL, 0x100fe200078e020fULL, 0xfffffffc424b7812ULL, 0x000fe200078ee243ULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x000000011e4d7824ULL, 0x000fe400078e020fULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc464f7812ULL, 0x000fe200078ee243ULL,
0x000000043e3e7824ULL, 0x000fc400078e00ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c0f7812ULL, 0x000fe200078ee243ULL, 0x0000010015147825ULL, 0x000fe200078e0012ULL,
0xfffffffc3e117812ULL, 0x000fe400078ee243ULL, 0xfffffffc1e517812ULL, 0x000fe200078ee243ULL,
0x0000001049437824ULL, 0x100fe400078e021cULL, 0x000000104b497824ULL, 0x100fe400078e021cULL,
0x000000104f4b7824ULL, 0x000fc400078e021cULL, 0x000000100f0f7824ULL, 0x100fe400078e021cULL,
0x0000001011117824ULL, 0x100fe400078e021cULL, 0x00000010514f7824ULL, 0x000fe400078e021cULL,
0x0000010017167825ULL, 0x000fc800078e0012ULL, 0x000001001d1c7825ULL, 0x000fc800078e0012ULL,
0x000001001f1e7825ULL, 0x000fc800078e0012ULL, 0x0000010041407825ULL, 0x000fc800078e0012ULL,
0x000001004d127825ULL, 0x000fc800078e0012ULL, 0x000000100d147825ULL, 0x000fc800078e0014ULL,
0x000000100d167825ULL, 0x040fe200078e0016ULL, 0x00000000140f7faeULL, 0x0003e6000c901c46ULL,
0x000000100d1c7825ULL, 0x040fe200078e001cULL, 0x0000000016117faeULL, 0x0003e6000d101c46ULL,
0x000000100d1e7825ULL, 0x040fe200078e001eULL, 0x000000001c437faeULL, 0x0003e6000d901c46ULL,
0x000000100d407825ULL, 0x040fe200078e0040ULL, 0x000000001e497faeULL, 0x0003e6000e101c46ULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x00000000404b7faeULL, 0x0003e8000e901c46ULL,
0x00000000124f7faeULL, 0x0003e2000f101c46ULL, 0x0000000400287947ULL, 0x000fea0003800000ULL,
0x00008a00ff127b82ULL, 0x000e620000000a00ULL, 0x00000003ff3f7819ULL, 0x000fe20000011600ULL,
0x00000004105b7824ULL, 0x000fe200078e00ffULL, 0x0000001000167811ULL, 0x040fe400078ff0ffULL,
0x00000018001c7811ULL, 0x040fe400078ff0ffULL, 0x00000020001e7811ULL, 0x000fe200078ff0ffULL,
0x00000001161d7824ULL, 0x100fe200078e020fULL, 0x00000028003c7811ULL, 0x000fe200078ff0ffULL,
0x000000011c1f7824ULL, 0x100fe200078e020fULL, 0x0000000947107c11ULL, 0x000fe2000f8e68ffULL,
0x000000011e417824ULL, 0x100fe200078e020fULL, 0x0000000800147811ULL, 0x000fe200078ff0ffULL,
0x000000013c437824ULL, 0x000fe200078e020fULL, 0x00000030003e7811ULL, 0x000fe200078ff0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0x0000003800407811ULL, 0x000fe200078ff0ffULL,
0x0000000414427824ULL, 0x000fe200078e00ffULL, 0x000000003f0d7212ULL, 0x000fe200078e3cffULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x0000000f00157211ULL, 0x000fe200078ff0ffULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x000000030d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000043c3c7824ULL, 0x000fc400078e00ffULL, 0x0000100009117824ULL, 0x000fe200078e0210ULL,
0xfffffffc164b7812ULL, 0x000fe200078ee20dULL, 0x000000043e467824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c4d7812ULL, 0x000fe200078ee20dULL, 0x0000000440487824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e4f7812ULL, 0x000fe200078ee20dULL, 0x0000000114177824ULL, 0x100fe200078e020fULL,
0xfffffffc3c537812ULL, 0x000fe200078ee20dULL, 0x0000200011147836ULL, 0x000fe20000000000ULL,
0xfffffffc42117812ULL, 0x000fe200078ee20dULL, 0x000000013e497824ULL, 0x100fe200078e020fULL,
0xfffffffc46557812ULL, 0x000fe200078ee20dULL, 0x0000000140517824ULL, 0x000fe200078e020fULL,
0xfffffffc48597812ULL, 0x000fe200078ee20dULL, 0x000000104b0f7824ULL, 0x100fe200078e0214ULL,
0x0ffffffc0d0d7812ULL, 0x000fe200078ef800ULL, 0x000000104f4b7824ULL, 0x000fc400078e0214ULL,
0x00000010554f7824ULL, 0x100fe200078e0214ULL, 0xfffffffc5b557812ULL, 0x000fe200078ee200ULL,
0x000000100d577824ULL, 0x100fe400078e0214ULL, 0x00000010110d7824ULL, 0x100fe400078e0214ULL,
0x000000104d117824ULL, 0x100fe400078e0214ULL, 0x00000010534d7824ULL, 0x100fe400078e0214ULL,
0x0000001059537824ULL, 0x000fc400078e0214ULL, 0x0000010015147825ULL, 0x002fc800078e0012ULL,
0x0000010017167825ULL, 0x000fc800078e0012ULL, 0x000001001d1c7825ULL, 0x000fc800078e0012ULL,
0x000001001f1e7825ULL, 0x000fc800078e0012ULL, 0x0000010041407825ULL, 0x000fc800078e0012ULL,
0x0000010043427825ULL, 0x000fc800078e0012ULL, 0x0000010049487825ULL, 0x000fc800078e0012ULL,
0x0000001055147825ULL, 0x000fc800078e0014ULL, 0x0000010051127825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014577faeULL, 0x0003e6000b901c46ULL,
0x0000001055167825ULL, 0x000fc800078e0016ULL, 0x00000010551c7825ULL, 0x040fe200078e001cULL,
0x00000000160d7faeULL, 0x0003e6000b901c46ULL, 0x00000010551e7825ULL, 0x040fe200078e001eULL,
0x000000001c0f7faeULL, 0x0003e6000b901c46ULL, 0x0000001055407825ULL, 0x040fe200078e0040ULL,
0x000000001e117faeULL, 0x0003e6000b901c46ULL, 0x0000001055427825ULL, 0x040fe200078e0042ULL,
0x00000000404b7faeULL, 0x0003e6000b901c46ULL, 0x0000001055487825ULL, 0x040fe200078e0048ULL,
0x00000000424d7faeULL, 0x0003e6000b901c46ULL, 0x0000001055127825ULL, 0x000fe200078e0012ULL,
0x00000000484f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012537faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020000f7836ULL, 0x042fe20000000000ULL,
0xfffffff8000d7812ULL, 0x000fe200078ec0ffULL, 0x000010000c3c7824ULL, 0x000fe200078e0210ULL,
0x0000000700437812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ec0ffULL, 0x000020003c3c7836ULL, 0x000fe20000000000ULL,
0x000000070d3e7812ULL, 0x000fe400078ef800ULL, 0x000000070f407812ULL, 0x000fc400078ef800ULL,
0x00000001ff0d7819ULL, 0x000fe4000001163eULL, 0x00000001ff417819ULL, 0x000fe40000011640ULL,
0x00000008430f7812ULL, 0x000fe400078ef800ULL, 0x000000030d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000341417812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fcc0000000000ULL,
0x0000000c0d117212ULL, 0x080fe200078e3cffULL, 0x000000043d797824ULL, 0x000fe200078e020cULL,
0x0000000c41157212ULL, 0x000fc600078e3cffULL, 0x000000043e117824ULL, 0x000fe400078e0211ULL,
0x0000000440157824ULL, 0x000fe400078e0215ULL, 0x0000001011117824ULL, 0x100fe400078e023cULL,
0x0000001015157824ULL, 0x000fe400078e023cULL, 0x0000000279797824ULL, 0x000fe400078e00ffULL,
0x000000001110783bULL, 0x000e680000000200ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000018ff5c7819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010567816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x00008880115a7816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000018ff657819ULL, 0x000fc40000011412ULL, 0x0000888012747816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff647819ULL, 0x000fe20000011413ULL,
0x0000001000777306ULL, 0x0003e20000200c00ULL, 0x0000888013707816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff697819ULL, 0x004fe20000011414ULL, 0x0000001100607306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x002fe200078e00ffULL, 0x00008880146e7816ULL, 0x000fe200000000ffULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe40000011415ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013117824ULL, 0x044fe200078e00ffULL, 0x0000001c005b7306ULL, 0x000e620000200c00ULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00008880156a7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000001200727306ULL, 0x0005e20000200c00ULL, 0x00000018ff597819ULL, 0x000fe40000011416ULL,
0x00000018ff427819ULL, 0x000fe40000011417ULL, 0x0000888016677816ULL, 0x000fe400000000ffULL,
0x00008880175e7816ULL, 0x000fe200000000ffULL, 0x0000001100737306ULL, 0x0007e20000200c00ULL,
0x000000010c127836ULL, 0x004fc40000000000ULL, 0x000000020c0c7836ULL, 0x000fc60000000000ULL,
0x0000001241497212ULL, 0x080fe400078e3cffULL, 0x0000001300717306ULL, 0x0005e20000200c00ULL,
0x000000120d117212ULL, 0x008fe400078e3cffULL, 0x0000000440497824ULL, 0x000fe200078e0249ULL,
0x000000040c00780cULL, 0x000fc60003f25270ULL, 0x0000001049127824ULL, 0x100fe200078e023cULL,
0x0000001d005f7306ULL, 0x0007e20000200c00ULL, 0x000000043e137824ULL, 0x004fe400078e0211ULL,
0x0001000015117824ULL, 0x000fe400078e00ffULL, 0x0000001013137824ULL, 0x000fe400078e023cULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x0000001000757306ULL, 0x0005e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00000000131c783bULL, 0x008ee40000000200ULL,
0x00000018ff157819ULL, 0x000fc80000011415ULL, 0x00000015006b7306ULL, 0x000fe20000200c00ULL,
0x0001000014107824ULL, 0x044fe400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000011006d7306ULL, 0x000ff00000200c00ULL, 0x00000014006c7306ULL, 0x0005f00000200c00ULL,
0x00000010006f7306ULL, 0x0009e20000200c00ULL, 0x0001000017147824ULL, 0x004fc400078e00ffULL,
0x0000010017177824ULL, 0x000fc600078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0001000016107824ULL, 0x050fe200078e00ffULL,
0x0000001400637306ULL, 0x0005e20000200c00ULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x008fe2000001141cULL, 0x000100001d157824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011410ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x000000001210783bULL, 0x000ee20000000200ULL, 0x0000001700617306ULL, 0x000fe20000200c00ULL,
0x000100001c147824ULL, 0x004fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc40000011415ULL,
0x000088801c497816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011414ULL, 0x0000007900147211ULL, 0x000fe200078fe0ffULL,
0x0000001600667306ULL, 0x0005e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000000279797836ULL, 0x000fe20000000000ULL, 0x0000000714147812ULL, 0x000fe400078e780fULL,
0x00000018ff4f7819ULL, 0x000fc4000001141dULL, 0x000088801d507816ULL, 0x000fe200000000ffULL,
0x000000200f147824ULL, 0x000fe200078e0214ULL, 0x0000005c005c7306ULL, 0x000f220000200c00ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001141eULL,
0x0000000914147c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00517306ULL, 0x000be20000200c00ULL, 0x000088801e537816ULL, 0x000fe200000000ffULL,
0x000000001414783bULL, 0x004ea20000000200ULL, 0x00000018ff4d7819ULL, 0x000fca000001141fULL,
0x0000001d00547306ULL, 0x0003e20000200c00ULL, 0x000100001e1c7824ULL, 0x060fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x008fe20000011410ULL,
0x0000010010767824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x000088801f1d7816ULL, 0x002fe400000000ffULL,
0x00000018ff1e7819ULL, 0x000fc4000001141eULL, 0x00000018ff4b7819ULL, 0x000fe40000011411ULL,
0x00000018ff487819ULL, 0x000fe20000011413ULL, 0x0000001c00587306ULL, 0x0003e20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe40000011412ULL, 0x00000018ff767819ULL, 0x000fca0000011476ULL,
0x0000005d005d7306ULL, 0x000f620000200c00ULL, 0x00005410561c7816ULL, 0x002fe2000000005bULL,
0x000100001f5b7824ULL, 0x040fe400078e00ffULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000001d00567306ULL, 0x0009e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00005410771d7816ULL, 0x010fce000000005cULL, 0x0000001c1438723cULL, 0x004fe20000001838ULL,
0x0000007400747306ULL, 0x000e6c0000200c00ULL, 0x00010000101d7824ULL, 0x000fe200078e00ffULL,
0x000054105a1c7816ULL, 0x008fe2000000005fULL, 0x0000001e00577306ULL, 0x0005e60000200c00ULL,
0x00000018ff1d7819ULL, 0x000fca000001141dULL, 0x0000001d005f7306ULL, 0x000be20000200c00ULL,
0x00008880101e7816ULL, 0x004fe400000000ffULL, 0x0000007900107211ULL, 0x000fc800078fe0ffULL,
0x0000000710107812ULL, 0x000fe200078e780fULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x00005410601d7816ULL, 0x020fe4000000005dULL, 0x0000888011607816ULL, 0x000fe200000000ffULL,
0x000000200f107824ULL, 0x000fc800078e0210ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000001c1434723cULL, 0x000fe20000001834ULL, 0x0000000910107c11ULL, 0x000fcc000f8e20ffULL,
0x00005410741c7816ULL, 0x002fe20000000075ULL, 0x0000001e005a7306ULL, 0x0002e20000200c00ULL,
0x00005410721d7816ULL, 0x000fe20000000065ULL, 0x0000010011727824ULL, 0x000fcc00078e00ffULL,
0x0000006e006e7306ULL, 0x000f220000200c00ULL, 0x00010000111e7824ULL, 0x002fe200078e00ffULL,
0x0000001c1430723cULL, 0x000fe20000001830ULL, 0x0000541071117816ULL, 0x004fe40000000064ULL,
0x00000018ff647819ULL, 0x000fe40000011472ULL, 0x00000018ff657819ULL, 0x000fe2000001141eULL,
0x0000001f005c7306ULL, 0x0003e20000200c00ULL, 0x000054105a5a7816ULL, 0x008fce000000005fULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x00000000101c783bULL, 0x0022ee0000000200ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541070107816ULL, 0x002fce0000000073ULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x00000010142c723cULL, 0x000fee000000182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054106e107816ULL, 0x010fc6000000006fULL, 0x000000ffff6e7224ULL, 0x000fe200078e0011ULL,
0x000054106c117816ULL, 0x004fe20000000069ULL, 0x00010000126c7824ULL, 0x000fe400078e00ffULL,
0x0000006800687306ULL, 0x000ea60000200c00ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x000000101428723cULL, 0x000fe80000001828ULL, 0x0000005900597306ULL, 0x000f260000200c00ULL,
0x000054106a107816ULL, 0x002fc4000000006dULL, 0x000054106b117816ULL, 0x000fc60000000062ULL,
0x0000004200427306ULL, 0x000fe80000200c00ULL, 0x000000101424723cULL, 0x000fe80000001824ULL,
0x0000005e005e7306ULL, 0x000e660000200c00ULL, 0x0000010012117824ULL, 0x000fe200078e00ffULL,
0x0000541067107816ULL, 0x004fc80000000068ULL, 0x00000018ff677819ULL, 0x000fe20000011411ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000541066117816ULL, 0x010fe40000000059ULL,
0x0000888013597816ULL, 0x000fca00000000ffULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000000101420723cULL, 0x000fee0000001820ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000054105e107816ULL, 0x002fe40000000063ULL, 0x0000541061117816ULL, 0x000fe20000000042ULL,
0x000000ffff427224ULL, 0x000fc800078e0059ULL, 0x0000004e004e7306ULL, 0x000e640000200c00ULL,
0x000000101418723cULL, 0x000fec0000001818ULL, 0x0000005b005b7306ULL, 0x000f220000200c00ULL,
0x0001000013117824ULL, 0x000fe200078e00ffULL, 0x0000541049107816ULL, 0x004fe20000000052ULL,
0x0000010013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff157819ULL, 0x000fe40000011411ULL,
0x0000541051117816ULL, 0x000fe20000000046ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000541057597816ULL, 0x002fc6000000004eULL,
0x000000101c38723cULL, 0x008fe20000001838ULL, 0x0000541056567816ULL, 0x010fe2000000005bULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541054517816ULL, 0x004fce000000004fULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000054105c577816ULL, 0x002fce000000004dULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x000000561c2c723cULL, 0x000fee000000182cULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000004800487306ULL, 0x000ff00000200c00ULL,
0x0000005000507306ULL, 0x000ff00000200c00ULL, 0x0000005500557306ULL, 0x000e700000200c00ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541050507816ULL, 0x002fce0000000055ULL,
0x00000076005d7306ULL, 0x000e620000200c00ULL, 0x000000501c34723cULL, 0x000fe20000001834ULL,
0x0000541053587816ULL, 0x004fcc0000000058ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000581c30723cULL, 0x000fe20000001830ULL, 0x000054105d5b7816ULL, 0x002fcc000000004cULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0000005a1c28723cULL, 0x000fee0000001828ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541060607816ULL, 0x002fce0000000065ULL,
0x0000006e00697306ULL, 0x000fe20000200c00ULL, 0x0000541064617816ULL, 0x004fce000000004bULL,
0x0000006c00127306ULL, 0x000e620000200c00ULL, 0x000000601c24723cULL, 0x000fee0000001824ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x0000541069127816ULL, 0x002fce0000000012ULL,
0x0000004200147306ULL, 0x000ff00000200c00ULL, 0x0000001500117306ULL, 0x000e700000200c00ULL,
0x0000001300177306ULL, 0x0004e20000200c00ULL, 0x0000541014147816ULL, 0x002fc40000000011ULL,
0x0000541067137816ULL, 0x004fe4000000004aULL, 0x0000541017157816ULL, 0x008fca0000000048ULL,
0x000000121c20723cULL, 0x000fec0000001820ULL, 0x000000141c18723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xfffffff000301947ULL, 0x000fde000383ffffULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffffffe400308947ULL, 0x000fec000383ffffULL,
0x00000001ff0a7424ULL, 0x000fe200078e00ffULL, 0x00000009470f7c11ULL, 0x000fe2000f8e38ffULL,
0x0000000400107824ULL, 0x000fe400078e00ffULL, 0x0000000520147220ULL, 0x080fe20000410000ULL,
0x0106880a060c79a7ULL, 0x000e62000850003fULL, 0x0000000521167220ULL, 0x080fe20000410000ULL,
0x0000000538157220ULL, 0x080fe20000410000ULL, 0xfffffff010107812ULL, 0x000fe200078ec0ffULL,
0x0000000539397220ULL, 0x080fe20000410000ULL, 0x000000053a3a7220ULL, 0x080fe20000410000ULL,
0x000000053b3b7220ULL, 0x080fe20000410000ULL, 0x0000000534347220ULL, 0x080fe20000410000ULL,
0x0000000535357220ULL, 0x080fe20000410000ULL, 0x0000000536367220ULL, 0x080fe20000410000ULL,
0x0000000537377220ULL, 0x080fe20000410000ULL, 0x0000000530307220ULL, 0x080fe20000410000ULL,
0x0000000531317220ULL, 0x080fe20000410000ULL, 0x0000000532327220ULL, 0x080fe20000410000ULL,
0x0000000533337220ULL, 0x080fe20000410000ULL, 0x000000052c2c7220ULL, 0x080fe20000410000ULL,
0x000000052d2d7220ULL, 0x080fe20000410000ULL, 0x000000052e2e7220ULL, 0x080fe20000410000ULL,
0x000000052f2f7220ULL, 0x080fe20000410000ULL, 0x0000000528287220ULL, 0x080fe20000410000ULL,
0x0000000529297220ULL, 0x080fe20000410000ULL, 0x000000052a2a7220ULL, 0x080fe20000410000ULL,
0x000000052b2b7220ULL, 0x080fe20000410000ULL, 0x0000000524247220ULL, 0x080fe20000410000ULL,
0x0106880d060075a7ULL, 0x002e62000800017fULL, 0x0000000525257220ULL, 0x080fe20000410000ULL,
0x0000000526267220ULL, 0x080fe20000410000ULL, 0x0000000527277220ULL, 0x080fe20000410000ULL,
0x0000000522227220ULL, 0x080fe20000410000ULL, 0x0000000523237220ULL, 0x000fe20000410000ULL,
0x000000010f0f7824ULL, 0x000fc400078e0210ULL, 0x0000000518187220ULL, 0x080fe20000410000ULL,
0x0000000519197220ULL, 0x080fe20000410000ULL, 0x000000051a207220ULL, 0x080fe20000410000ULL,
0x000000051b217220ULL, 0x000fe20000410000ULL, 0x00000018005c8947ULL, 0x002fec0003800000ULL,
0x010400000f107984ULL, 0x0002a20000000c00ULL, 0x000000084500720cULL, 0x000fda0003f05270ULL,
0x0000000400080947ULL, 0x002fea0003800000ULL, 0x00000002000c7824ULL, 0x000fe400078e00ffULL,
0x00000001440b7824ULL, 0x000fc600078e0a0bULL, 0x000000060c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000010c1a7812ULL, 0x040fe400078efcffULL, 0x000000080c1c7812ULL, 0x000fe400078efcffULL,
0x0000000b1a00720cULL, 0x080fe40003f26070ULL, 0x000000100c1a7812ULL, 0x000fe400078efcffULL,
0x0000000b1c00720cULL, 0x080fe40003f06070ULL, 0x0000000b1a00720cULL, 0x000fc40003fc6070ULL,
0x000000110c1c7812ULL, 0x040fe400078efcffULL, 0x000000180c1a7812ULL, 0x040fe400078efcffULL,
0x0000000b0c00720cULL, 0x080fe40003f46070ULL, 0x0000000b1c00720cULL, 0x080fe40003fa6070ULL,
0x0000000b1a00720cULL, 0x000fe40003f66070ULL, 0x000000090c1e7812ULL, 0x000fc400078efcffULL,
0x000000190c1c7812ULL, 0x040fe400078efcffULL, 0x000000200c1a7812ULL, 0x000fe400078efcffULL,
0xff7fffff3a3a7808ULL, 0x000fe40005000000ULL, 0xff7fffff15157808ULL, 0x000fe40005000000ULL,
0xff7fffff3b3b7808ULL, 0x000fe40004800000ULL, 0xff7fffff39397808ULL, 0x000fc40004800000ULL,
0x0000000b1e00720cULL, 0x080fe40003f86070ULL, 0x0000000b1c00720cULL, 0x080fe40003f46070ULL,
0x0000000b1a00720cULL, 0x000fe40003f26070ULL, 0x000000210c1c7812ULL, 0x040fe400078efcffULL,
0x000000280c1a7812ULL, 0x000fe400078efcffULL, 0xff7fffff36367808ULL, 0x000fc40004000000ULL,
0xff7fffff34347808ULL, 0x000fe40004000000ULL, 0xff7fffff37377808ULL, 0x000fe40006000000ULL,
0xff7fffff35357808ULL, 0x000fe40006000000ULL, 0x0000000b1c00720cULL, 0x080fe40003f06070ULL,
0x0000000b1a00720cULL, 0x000fe40003f86070ULL, 0x000000290c1c7812ULL, 0x000fc400078efcffULL,
0x000000300c1a7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40007000000ULL,
0xff7fffff30307808ULL, 0x000fe40007000000ULL, 0xff7fffff33337808ULL, 0x000fe40006800000ULL,
0xff7fffff31317808ULL, 0x000fe40006800000ULL, 0x0000000b1c00720cULL, 0x000fc40003fc6070ULL,
0x0000000b1a00720cULL, 0x000fe40003fa6070ULL, 0x000000310c1c7812ULL, 0x040fe400078efcffULL,
0x000000380c1a7812ULL, 0x040fe400078efcffULL, 0x000000390c0c7812ULL, 0x000fe400078efcffULL,
0xff7fffff2e2e7808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL, 0xff7fffff28287808ULL, 0x000fe40004800000ULL,
0x0000000b1c00720cULL, 0x080fe40003f66070ULL, 0x0000000b1a00720cULL, 0x000fc40003f46070ULL,
0x0000000b0c00720cULL, 0x000fe40003f26070ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff26267808ULL, 0x000fe40006000000ULL,
0xff7fffff24247808ULL, 0x000fe40006000000ULL, 0xff7fffff27277808ULL, 0x000fc40007000000ULL,
0xff7fffff25257808ULL, 0x000fe40007000000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff14147808ULL, 0x000fe40006800000ULL, 0xff7fffff23237808ULL, 0x000fe40005800000ULL,
0xff7fffff16167808ULL, 0x000fe40005800000ULL, 0xff7fffff20207808ULL, 0x000fc40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fce0004800000ULL, 0x0000001510107209ULL, 0x004fe20007810000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000003a110c7209ULL, 0x000fe40007810000ULL,
0x00000039100b7209ULL, 0x000fe40007810000ULL, 0x0000003b0c0d7209ULL, 0x000fe40007810000ULL,
0x000000340b0c7209ULL, 0x000fe40007810000ULL, 0x000000360d107209ULL, 0x000fc40007810000ULL,
0x000000350c0b7209ULL, 0x000fe40007810000ULL, 0x00000037100d7209ULL, 0x000fe40007810000ULL,
0x000000300b0c7209ULL, 0x000fe40007810000ULL, 0x000000320d107209ULL, 0x000fe40007810000ULL,
0x000000310c0b7209ULL, 0x000fe40007810000ULL, 0x00000033100d7209ULL, 0x000fc40007810000ULL,
0x0000002c0b0c7209ULL, 0x000fe40007810000ULL, 0x0000002e0d107209ULL, 0x000fe40007810000ULL,
0x0000002d0c0b7209ULL, 0x000fe40007810000ULL, 0x0000002f100d7209ULL, 0x000fe40007810000ULL,
0x000000280b0c7209ULL, 0x000fe40007810000ULL, 0x0000002a0d107209ULL, 0x000fc40007810000ULL,
0x000000290c0b7209ULL, 0x000fe40007810000ULL, 0x0000002b100d7209ULL, 0x000fe40007810000ULL,
0x000000240b0c7209ULL, 0x000fe40007810000ULL, 0x000000260d107209ULL, 0x000fe40007810000ULL,
0x000000250c0b7209ULL, 0x000fe40007810000ULL, 0x00000027100d7209ULL, 0x000fc40007810000ULL,
0x000000140b0b7209ULL, 0x000fe40007810000ULL, 0x000000220d0c7209ULL, 0x000fe40007810000ULL,
0x000000160b0b7209ULL, 0x000fe40007810000ULL, 0x000000230c0d7209ULL, 0x000fe40007810000ULL,
0x000000180b0c7209ULL, 0x000fe40007810000ULL, 0x000000200d107209ULL, 0x000fc40007810000ULL,
0x000000190c0c7209ULL, 0x000fe40007810000ULL, 0x0000002110107209ULL, 0x000fe20007810000ULL,
0x0000001204d87947ULL, 0x000fec000b800000ULL, 0x0c401f000c0b7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0010117f89ULL, 0x000ea800000e0000ULL, 0x0c401f00121b7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00131a7f89ULL, 0x000f2200000e0000ULL, 0x0000000b0c0d7209ULL, 0x002fc40007810000ULL,
0x0000001110177209ULL, 0x004fc60007810000ULL, 0x0c201f000d1c7f89ULL, 0x000e6200000e0000ULL,
0x0000001b121b7209ULL, 0x008fc60007810000ULL, 0x0c201f00171e7f89ULL, 0x000ea200000e0000ULL,
0x0000001a130b7209ULL, 0x010fc60007810000ULL, 0x0c201f001b387f89ULL, 0x000ee800000e0000ULL,
0x0c201f000b0c7f89ULL, 0x00092200000e0000ULL, 0x0000001c0d107209ULL, 0x002fe40007810000ULL,
0x0000001e17117209ULL, 0x004fe40007810000ULL, 0x000000381b127209ULL, 0x008fce0007810000ULL,
0x3fb8aa3b100d7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b113d7820ULL, 0x000fc60000410000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b18187823ULL, 0x000fe2000001080dULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b3b3b7823ULL, 0x000fe2000001083dULL,
0x3fb8aa3b39397823ULL, 0x000fe2000001080dULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b37377823ULL, 0x000fe2000001083dULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b14147823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080dULL, 0x00000039001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b24247823ULL, 0x000fe2000001080dULL,
0x3fb8aa3b32327823ULL, 0x000fe2000001083dULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001080dULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe2000001083dULL, 0x00000018003c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b190d7823ULL, 0x000fe2000001080dULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001083dULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001083dULL,
0x0000003400347308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000003600177308ULL, 0x000ff00000000800ULL, 0x0000003700187308ULL, 0x000e700000000800ULL,
0x0000002c001e7308ULL, 0x000fe20000000800ULL, 0x000000171817723eULL, 0x002fce00000000ffULL,
0x00000014002c7308ULL, 0x0003f00000000800ULL, 0x0000002800137308ULL, 0x0005e20000000800ULL,
0x000000151a14723eULL, 0x002fe400000000ffULL, 0x0000003a3b15723eULL, 0x000fca00000000ffULL,
0x0000002900387308ULL, 0x0003e20000000800ULL, 0x3c003c00ff287424ULL, 0x004fce00078e00ffULL,
0x0000001600397308ULL, 0x0005e20000000800ULL, 0x3c003c00ff297424ULL, 0x002fce00078e00ffULL,
0x00000030001c7308ULL, 0x000fe20000000800ULL, 0x000000343516723eULL, 0x004fe200000000ffULL,
0x0000000000007948ULL, 0x000fec0003800000ULL, 0x000000281418723cULL, 0x000fe200000018ffULL,
0x0000002400307308ULL, 0x000ff00000000800ULL, 0x00000032001d7308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x0000001c311c723eULL, 0x002fce00000000ffULL, 0x0000003300247308ULL, 0x000e620000000800ULL,
0x0000001e2d1e723eULL, 0x004fce00000000ffULL, 0x0000002e001f7308ULL, 0x0005e20000000800ULL,
0x0000001d241d723eULL, 0x002fce00000000ffULL, 0x0000002f00327308ULL, 0x000e620000000800ULL,
0x3fb8aa3b272e7823ULL, 0x104fe2000001083dULL, 0x000000133824723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b20137823ULL, 0x100fe2000001083dULL, 0x3fb8aa3b213d7823ULL, 0x000fe2000001083dULL,
0x0000002c3920723eULL, 0x000fc600000000ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0000001f321f723eULL, 0x002fce00000000ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x000000281c18723cULL, 0x000fee0000001818ULL, 0x0000002b002b7308ULL, 0x000e700000000800ULL,
0x00000026002d7308ULL, 0x0005f00000000800ULL, 0x0000002e002e7308ULL, 0x000ee20000000800ULL,
0x000000302526723eULL, 0x004fc400000000ffULL, 0x0000002a2b25723eULL, 0x002fca00000000ffULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x0000002d2e27723eULL, 0x008fce00000000ffULL,
0x00000022002f7308ULL, 0x0003e20000000800ULL, 0x000000282418723cULL, 0x000fee0000001818ULL,
0x0000002300327308ULL, 0x000ea20000000800ULL, 0x0000003c0d22723eULL, 0x002fe400000000ffULL,
0xfffffffc000d7812ULL, 0x000fca00078ec0ffULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000002f3221723eULL, 0x004fce00000000ffULL, 0x0000003d002a7308ULL, 0x000e640000000800ULL,
0x000000132a23723eULL, 0x002fe400000000ffULL, 0x0000000c0b137209ULL, 0x010fca0007810000ULL,
0x000000282028723cULL, 0x000fee0000001818ULL, 0x0000000fff187424ULL, 0x000fca00078e00ffULL,
0x0000000d180d7219ULL, 0x000fd600000006ffULL, 0x001c1fff28187589ULL, 0x00026200000e0000ULL,
0x00000000002c7806ULL, 0x000fe200038e0100ULL, 0x000000000d1a73a1ULL, 0x000eb000000e8000ULL,
0x000000000d0473c4ULL, 0x000ee20000004000ULL, 0x0000000000057886ULL, 0x000fc400038e0100ULL,
0x000000050dff7c12ULL, 0x004fda000f80401aULL, 0x0000000e04f08947ULL, 0x00afea000b800000ULL,
0x001c1fff2a197589ULL, 0x0002a800000e0000ULL, 0x001c1fff1a1a7589ULL, 0x000ee800000e0000ULL,
0x001c1fff001b7589ULL, 0x00032400000e0000ULL, 0xfffffff8ff437812ULL, 0x000fe200078ee243ULL,
0x000000ffff307224ULL, 0x000fe200078e0014ULL, 0x000000033f2a7812ULL, 0x002fe200078ec0ffULL,
0x000000ffff317224ULL, 0x000fe200078e0016ULL, 0x0000000947297c11ULL, 0x000fe2000f8e58ffULL,
0x00000008430d7836ULL, 0x040fe20000000000ULL, 0x000000042a2c7812ULL, 0x000fe200078efcffULL,
0x00000008430b7824ULL, 0x000fe200078e00ffULL, 0x000000072a0c7812ULL, 0x000fe200078e7843ULL,
0x0000a00029297836ULL, 0x000fe20000000000ULL, 0x000000072c287812ULL, 0x000fe200078e7843ULL,
0x000000ffff327224ULL, 0x000fe200078e001cULL, 0x000000072a2a7812ULL, 0x000fe200078e780dULL,
0x000000ffff337224ULL, 0x000fe200078e001eULL, 0x000000072c2c7812ULL, 0x000fe200078e780dULL,
0x000000080d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000b0c0c7212ULL, 0x080fe200078efcffULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0x0000000b28287212ULL, 0x000fe200078efcffULL,
0x000000ffff347224ULL, 0x000fe200078e0024ULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x000000100c0c7824ULL, 0x100fe200078e0229ULL, 0x0000000d2a2a7212ULL, 0x080fe200078efcffULL,
0x0000001028287824ULL, 0x000fe200078e0229ULL, 0x0000000d2c2c7212ULL, 0x000fe200078efcffULL,
0x000000ffff357224ULL, 0x000fe200078e0026ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x000000300c007844ULL, 0x0003e20000000200ULL, 0x000000ffff367224ULL, 0x000fc400078e0020ULL,
0x000000ffff377224ULL, 0x000fe400078e0022ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000102a2a7824ULL, 0x000fe200078e0229ULL, 0x0000003428007844ULL, 0x0003e20000000200ULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff177224ULL, 0x000fe400078e001fULL,
0x000000102c2c7824ULL, 0x000fc400078e0229ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0025ULL,
0x000000142a007844ULL, 0x0003e20000000200ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0027ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0021ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0023ULL,
0x0000000102457824ULL, 0x000fc600078e0245ULL, 0x0000001c2c007844ULL, 0x0003e80000000200ULL,
0x010000100f008388ULL, 0x0003e80000000c00ULL, 0x010200180f008388ULL, 0x01c3e20000000c00ULL,
0x0000000e4500720cULL, 0x000fe20003f06070ULL, 0x0106080a07ff79a7ULL, 0x0003e2000850003fULL,
0x0106100a07ff79a7ULL, 0x0003e2000850003fULL, 0x0106180a07ff79a7ULL, 0x0003e2000850003fULL,
0x0106200a07ff79a7ULL, 0x0003f2000850003fULL, 0xffffffcc00fc8947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0106b819040075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b819040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xfffffef000a87947ULL, 0x008fea000383ffffULL, 0x010608190d0075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x010608190d00a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xfffffef400a47947ULL, 0x000fea000383ffffULL, 0x0106a869040075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a869040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xfffffef800a47947ULL, 0x000fea000383ffffULL, 0x0106b877040075a7ULL, 0x00026200080c017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000e95dULL, 0x000fea0003900000ULL,
0x0106b8770400e5a7ULL, 0x000e6400080c007fULL, 0xfffffffc00ece947ULL, 0x002fea000383ffffULL,
0xffffff0800f87947ULL, 0x000fea000383ffffULL, 0x0106b073040075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0730400a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff0c002c7947ULL, 0x000fea000383ffffULL, 0x0106b819040075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b819040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff1c00047947ULL, 0x002fea000383ffffULL, 0x010628190d0075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x010628190d00a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff1c00747947ULL, 0x000fea000383ffffULL, 0x0106a869040075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a869040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff2000507947ULL, 0x000fea000383ffffULL, 0x0106b873040075a7ULL, 0x00026200080c017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000e95dULL, 0x000fea0003900000ULL,
0x0106b8730400e5a7ULL, 0x000e6400080c007fULL, 0xfffffffc00ece947ULL, 0x002fea000383ffffULL,
0xffffff3000587947ULL, 0x000fea000383ffffULL, 0x0106b075040075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0750400a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff30007c7947ULL, 0x000fea000383ffffULL, 0x0106b819040075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b819040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff4000307947ULL, 0x002fea000383ffffULL, 0x010648190d0075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x010648190d00a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff4000a07947ULL, 0x000fea000383ffffULL, 0x0106a869040075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106a869040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff44007c7947ULL, 0x000fea000383ffffULL, 0x0106b873040075a7ULL, 0x00026200080c017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000e95dULL, 0x000fea0003900000ULL,
0x0106b8730400e5a7ULL, 0x000e6400080c007fULL, 0xfffffffc00ece947ULL, 0x002fea000383ffffULL,
0xffffff5400847947ULL, 0x000fea000383ffffULL, 0x0106b075040075a7ULL, 0x000262000804017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x0106b0750400a5a7ULL, 0x000e64000804007fULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xffffff5400a87947ULL, 0x000fea000383ffffULL, 0x0106b819040075a7ULL, 0x0004a2000800017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106b819040085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff6400587947ULL, 0x002fea000383ffffULL, 0x010668190d0075a7ULL, 0x000262000802017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x010668190d0095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff6400cc7947ULL, 0x000fea000383ffffULL, 0x0106a869040075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106a869040085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff6800a87947ULL, 0x000fea000383ffffULL, 0x0106b869040075a7ULL, 0x00026200080a017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000d95dULL, 0x000fea0003900000ULL,
0x0106b8690400d5a7ULL, 0x000e6400080a007fULL, 0xfffffffc00ecd947ULL, 0x002fea000383ffffULL,
0xffffff7800b47947ULL, 0x000fea000383ffffULL, 0x0106b06f040075a7ULL, 0x0004a2000802017fULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x0106b06f040095a7ULL, 0x000e64000802007fULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff7800d87947ULL, 0x002fea000383ffffULL, 0x00000009ff0d7e24ULL, 0x000fc8000f8e00ffULL,
0x010600070d0075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x010600070d0085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffc400547947ULL, 0x020fea000383ffffULL,
0x00000009ff077e24ULL, 0x000fc8000f8e00ffULL, 0x01060009070075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01060009070085a7ULL, 0x000e64000800007fULL, 0xfffffffc00e88947ULL, 0x002fea000383ffffULL,
0xffffffc400c87947ULL, 0x020fea000383ffffULL, 0x0106880d060075a7ULL, 0x000262000800017fULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x0106880d060085a7ULL, 0x000e64000800007fULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffffe4008c7947ULL, 0x000fea000383ffffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000cULL, 0x00000002ff3d7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fce00078e00ffULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003d1f1d7389ULL, 0x0006e4000000003eULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff1f7224ULL, 0x002fe400078e0010ULL, 0x00000002ff3d7424ULL, 0x000fe400078e00ffULL,
0x0000001fff3e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x004fce00078e001dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003d1f1d7389ULL, 0x000264000000003eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000000b0c0d7209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fce00078e001dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003d1f1d7389ULL, 0x000264000000003eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001110177209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0013ULL,
0x000000ffff1b7224ULL, 0x000fce00078e001dULL, 0x000000003c087348ULL, 0x000fea0003c00000ULL,
0x0c00003d1f1d7389ULL, 0x000264000000003eULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000001b121b7209ULL, 0x000fe20007810000ULL, 0x000000ffff1f7224ULL, 0x000fe400078e000dULL,
0x00000001ff3d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x000fce00078e001dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003d1f1d7389ULL, 0x000264000000003eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001a130b7209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0017ULL, 0x000000ffff1c7224ULL, 0x000fce00078e001dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003d1f1d7389ULL, 0x000264000000003eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001c0d107209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e001bULL, 0x000000ffff1e7224ULL, 0x000fce00078e001dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003d1f1d7389ULL, 0x000264000000003eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000001e17117209ULL, 0x000fe20007810000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e000bULL, 0x000000ffff387224ULL, 0x000fce00078e001dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0c00003d1f1d7389ULL, 0x000264000000003eULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x000000381b127209ULL, 0x000fe20007810000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e001dULL, 0xffffffe800807947ULL, 0x000fec000383ffffULL,
0x0000007000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e000dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff197224ULL, 0x004fe400078e001bULL,
0x000000ffff2a7224ULL, 0x002fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e000dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000009000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1a7224ULL, 0x004fe400078e001bULL,
0x000000ffff2a7224ULL, 0x002fe400078e0000ULL, 0x000000ffff1b7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff0b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff3c7224ULL, 0x000fce00078e000dULL,
0x000000003c087348ULL, 0x000fea0003c00000ULL, 0x0000001b2a1b7389ULL, 0x0006e4000000000bULL,
0x000000000000791bULL, 0x008fe20003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffec00a87947ULL, 0x006fea000383ffffULL, 0x018000003e037836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003e00038308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff3eff7812ULL, 0x040fe4000780c0ffULL,
0x800000003e057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000003e00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffffed004907950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL, 0x0000000e00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000618ULL, 0x0000000000000048ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000a00ULL, 0x0000000d00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001060ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000000ULL, 0x0000000d00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001080ULL, 0x0000000000000030ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000010b0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010f8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001100ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000012e80ULL, 0x0000000e00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000014010ULL, 0x0000000000000400ULL, 0x0000000d00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014010ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000014010ULL, 0x0000000000000260ULL, 0x0000000d00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000146f0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000146f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000010f8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000012e80ULL,
0x0000000000012e80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL, 0x0000000000000414ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000014010ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000260ULL, 0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin_len = 84032;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
