/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018390ULL, 0x0000000000017f10ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000016220ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000016390ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x00000000000163e0ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x0000000000016430ULL,
0x0000000000000150ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000016580ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001622000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x0057200400288080ULL, 0x0000000000000000ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8508288080820828ULL, 0x2880809308288080ULL, 0x8098082880809608ULL, 0x082880809b082880ULL,
0x8080a0082880809fULL, 0xa408288080a30828ULL, 0x288080a808288080ULL, 0x80ac08288080ab08ULL,
0x08288080ae082880ULL, 0x8080b408288080b3ULL, 0xc008288080b70828ULL, 0x288080c208288080ULL,
0x80d808288080d008ULL, 0x08288080d9082880ULL, 0x8080db08288080daULL, 0x8608288080dc0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808086920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001622000000000ULL, 0x0000017000000000ULL,
0x0000480400000000ULL, 0x8080288080850900ULL, 0x0000000000002880ULL, 0x000000c4ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8808288080820828ULL, 0x2880808b08288080ULL, 0x8092082880808e08ULL,
0x0828808093082880ULL, 0x80809b0828808096ULL, 0x9f082880809e0828ULL, 0x288080a008288080ULL,
0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080ac08288080a8ULL, 0xb308288080ae0828ULL,
0x288080c008288080ULL, 0x80d008288080c208ULL, 0x08288080d8082880ULL, 0x8080da08288080d9ULL,
0xdc08288080db0828ULL, 0x2880808908288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808089ULL, 0x0000002cffffffffULL, 0x0000017800000000ULL, 0x0001639000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8088288080890900ULL, 0x0000000000002880ULL,
0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8908288080880828ULL, 0x2880808b08288080ULL,
0x8092082880808e08ULL, 0x0828808093082880ULL, 0x80809b0828808096ULL, 0x9f082880809e0828ULL,
0x288080a008288080ULL, 0x80a308288080a208ULL, 0x08288080a4082880ULL, 0x8080ac08288080a8ULL,
0xb308288080ae0828ULL, 0x288080c008288080ULL, 0x80d008288080c208ULL, 0x08288080d8082880ULL,
0x8080da08288080d9ULL, 0xdc08288080db0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x00288080dc920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL,
0x000163e000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80d8288080dc0900ULL,
0x0000000000002880ULL, 0x000000c4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8908288080880828ULL,
0x2880808b08288080ULL, 0x8092082880808e08ULL, 0x0828808093082880ULL, 0x80809b0828808096ULL,
0x9f082880809e0828ULL, 0x288080a008288080ULL, 0x80a308288080a208ULL, 0x08288080a8082880ULL,
0x8080ae08288080acULL, 0xc008288080b30828ULL, 0x288080c208288080ULL, 0x80d808288080d008ULL,
0x08288080d9082880ULL, 0x8080db08288080daULL, 0xa408288080dc0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080a4920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000038800000000ULL, 0x0001643000000000ULL, 0x0000015000000000ULL, 0x0000000000000000ULL,
0x0000001200082f04ULL, 0x0008120400000094ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005001600000000eULL, 0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x000148e000014560ULL,
0x00014a30000148f0ULL, 0x00014a5000014a40ULL, 0xffffffff01c82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500001bffffffffULL,
0x0500001b0500001bULL, 0xffffffff0500001bULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01c82804ffffffffULL,
0x000000e0000000d0ULL, 0x0000158000001500ULL, 0x0000165000001620ULL, 0x00001a6000001a30ULL,
0x00001b4000001ad0ULL, 0x0000314000003120ULL, 0x00003200000031a0ULL, 0x000047e000004760ULL,
0x000049b000004890ULL, 0x00004c9000004c70ULL, 0x00004d5000004cf0ULL, 0x0000618000006160ULL,
0x00006240000061e0ULL, 0x000077b000007730ULL, 0x0000798000007860ULL, 0x00007c6000007c40ULL,
0x00007d2000007cc0ULL, 0x0000915000009130ULL, 0x00009210000091b0ULL, 0x0000a7800000a700ULL,
0x0000a9500000a830ULL, 0x0000ac300000ac10ULL, 0x0000acf00000ac90ULL, 0x0000c1500000c130ULL,
0x0000c2100000c1b0ULL, 0x0000d5000000d4f0ULL, 0x0000f8700000dc80ULL, 0x0000ff700000fab0ULL,
0x000107d00000ffb0ULL, 0x00014320000142f0ULL, 0x0001434000014330ULL, 0x0001439000014370ULL,
0x000143b0000143a0ULL, 0x00014a8000014a20ULL, 0x00014aa000014a90ULL, 0x000151f0000151b0ULL,
0x000152e000015260ULL, 0x000153c000015350ULL, 0x0001549000015420ULL, 0x00015520000154e0ULL,
0x0001560000015590ULL, 0x000156c000015650ULL, 0x0001579000015720ULL, 0x00015820000157e0ULL,
0x0001590000015890ULL, 0x000159c000015950ULL, 0x00015a9000015a20ULL, 0x00015b2000015ae0ULL,
0x00015c0000015b90ULL, 0x00015cc000015c50ULL, 0x00015da000015d30ULL, 0x00015e5000015e00ULL,
0x00015ef000015ea0ULL, 0x00015f9000015f40ULL, 0x0001603000015fe0ULL, 0x00016130000160b0ULL,
0x000161f000016190ULL, 0x0000021007003904ULL, 0x00010600000000ffULL, 0x00000250003f0100ULL,
0x0001060800000000ULL, 0x000002b0003f0120ULL, 0x0001068800000000ULL, 0x00000380003f0120ULL,
0x000106a800000000ULL, 0x000003c0003f0120ULL, 0x000106b8000000ffULL, 0x000004e0003f0100ULL,
0x00010600000000ffULL, 0x00000670003f0107ULL, 0x0001068c0000002fULL, 0x000009f0003f0102ULL,
0x000106880000002fULL, 0x00000b40003f0101ULL, 0x000106a8000000ffULL, 0x00000bc0003f0107ULL,
0x000106a8000000ffULL, 0x00000c20003f0101ULL, 0x000106b8000000ffULL, 0x00000d60003f0101ULL,
0x000106bc000000ffULL, 0x00000db0003f0105ULL, 0x000106bc000000ffULL, 0x00000e30003f0105ULL,
0x000106bc000000ffULL, 0x00001270003f0105ULL, 0x000106b0000000ffULL, 0x000012f0003f0107ULL,
0x000106b0000000ffULL, 0x00001300003f0101ULL, 0x000106ac000000ffULL, 0x00001370003f0105ULL,
0x000106080000002fULL, 0x00001390003f0101ULL, 0x0001060c0000002fULL, 0x00001420003f0105ULL,
0x0001060c0000002fULL, 0x00001910003f0105ULL, 0x000106ac000000ffULL, 0x00001990003f0105ULL,
0x000106ac000000ffULL, 0x00002b70003f0105ULL, 0x000106b8000000ffULL, 0x00002b80003f0101ULL,
0x000106bc000000ffULL, 0x00002bd0003f0105ULL, 0x000106bc000000ffULL, 0x00002c50003f0105ULL,
0x000106bc000000ffULL, 0x00002f20003f0105ULL, 0x000106a8000000ffULL, 0x00002fa0003f0107ULL,
0x000106a8000000ffULL, 0x00002fb0003f0101ULL, 0x000106b4000000ffULL, 0x00003010003f0105ULL,
0x000106b4000000ffULL, 0x00003090003f0105ULL, 0x000106b4000000ffULL, 0x00004110003f0105ULL,
0x000106b8000000ffULL, 0x00004180003f0101ULL, 0x00010688000000ffULL, 0x000041c0003f0101ULL,
0x000106bc000000ffULL, 0x00004210003f0105ULL, 0x000106bc000000ffULL, 0x00004290003f0105ULL,
0x000106bc000000ffULL, 0x00004520003f0105ULL, 0x000106b0000000ffULL, 0x000045a0003f0107ULL,
0x000106b0000000ffULL, 0x000045b0003f0101ULL, 0x000106ac000000ffULL, 0x00004620003f0105ULL,
0x000106280000002fULL, 0x00004640003f0101ULL, 0x0001062c0000002fULL, 0x000046d0003f0105ULL,
0x0001062c0000002fULL, 0x00004b60003f0105ULL, 0x000106ac000000ffULL, 0x00004be0003f0105ULL,
0x000106ac000000ffULL, 0x00005bf0003f0105ULL, 0x000106b8000000ffULL, 0x00005c00003f0101ULL,
0x000106bc000000ffULL, 0x00005c50003f0105ULL, 0x000106bc000000ffULL, 0x00005cd0003f0105ULL,
0x000106bc000000ffULL, 0x00005f60003f0105ULL, 0x000106a8000000ffULL, 0x00005fe0003f0107ULL,
0x000106a8000000ffULL, 0x00005ff0003f0101ULL, 0x000106b4000000ffULL, 0x00006050003f0105ULL,
0x000106b4000000ffULL, 0x000060d0003f0105ULL, 0x000106b4000000ffULL, 0x000070e0003f0105ULL,
0x000106b8000000ffULL, 0x00007150003f0101ULL, 0x00010690000000ffULL, 0x00007190003f0101ULL,
0x000106bc000000ffULL, 0x000071e0003f0105ULL, 0x000106bc000000ffULL, 0x00007260003f0105ULL,
0x000106bc000000ffULL, 0x000074f0003f0105ULL, 0x000106b0000000ffULL, 0x00007570003f0107ULL,
0x000106b0000000ffULL, 0x00007580003f0101ULL, 0x000106ac000000ffULL, 0x000075f0003f0105ULL,
0x000106480000002fULL, 0x00007610003f0101ULL, 0x0001064c0000002fULL, 0x000076a0003f0105ULL,
0x0001064c0000002fULL, 0x00007b30003f0105ULL, 0x000106ac000000ffULL, 0x00007bb0003f0105ULL,
0x000106ac000000ffULL, 0x00008bc0003f0105ULL, 0x000106b8000000ffULL, 0x00008bd0003f0101ULL,
0x000106bc000000ffULL, 0x00008c20003f0105ULL, 0x000106bc000000ffULL, 0x00008ca0003f0105ULL,
0x000106bc000000ffULL, 0x00008f30003f0105ULL, 0x000106a8000000ffULL, 0x00008fb0003f0107ULL,
0x000106a8000000ffULL, 0x00008fc0003f0101ULL, 0x000106b4000000ffULL, 0x00009020003f0105ULL,
0x000106b4000000ffULL, 0x000090a0003f0105ULL, 0x000106b4000000ffULL, 0x0000a0b0003f0105ULL,
0x000106b8000000ffULL, 0x0000a120003f0101ULL, 0x00010698000000ffULL, 0x0000a160003f0101ULL,
0x000106bc000000ffULL, 0x0000a1b0003f0105ULL, 0x000106bc000000ffULL, 0x0000a230003f0105ULL,
0x000106bc000000ffULL, 0x0000a4c0003f0105ULL, 0x000106b0000000ffULL, 0x0000a540003f0107ULL,
0x000106b0000000ffULL, 0x0000a550003f0101ULL, 0x000106ac000000ffULL, 0x0000a5c0003f0105ULL,
0x000106680000002fULL, 0x0000a5e0003f0101ULL, 0x0001066c0000002fULL, 0x0000a670003f0105ULL,
0x0001066c0000002fULL, 0x0000ab00003f0105ULL, 0x000106ac000000ffULL, 0x0000ab80003f0105ULL,
0x000106ac000000ffULL, 0x0000bb90003f0105ULL, 0x000106b8000000ffULL, 0x0000bba0003f0101ULL,
0x000106bc000000ffULL, 0x0000bbf0003f0105ULL, 0x000106bc000000ffULL, 0x0000bc70003f0105ULL,
0x000106bc000000ffULL, 0x0000bf30003f0105ULL, 0x000106a8000000ffULL, 0x0000bfb0003f0107ULL,
0x000106a8000000ffULL, 0x0000bfc0003f0101ULL, 0x000106b4000000ffULL, 0x0000c020003f0105ULL,
0x000106b4000000ffULL, 0x0000c0a0003f0105ULL, 0x000106b4000000ffULL, 0x0000d0b0003f0105ULL,
0x000106b8000000ffULL, 0x0000d110003f0101ULL, 0x000106a0000000ffULL, 0x00010ad0003f0101ULL,
0x00010600000000ffULL, 0x000115c0003f0101ULL, 0x00010604000000ffULL, 0x00011660003f0105ULL,
0x00010604000000ffULL, 0x00011980003f0105ULL, 0x00010600000000ffULL, 0x00011990003f0101ULL,
0x00010604000000ffULL, 0x00011a20003f0105ULL, 0x00010604000000ffULL, 0x000137f0003f0105ULL,
0x0000000000000028ULL, 0x00013830003f0101ULL, 0x0000000400000028ULL, 0x00013bf0003f0105ULL,
0x0000000400000028ULL, 0x00015010003f0105ULL, 0x000000000000002aULL, 0x00015070003f0101ULL,
0x000000080000002aULL, 0x000150d0003f0101ULL, 0x000000100000002aULL, 0x00015140003f0101ULL,
0x000000180000002aULL, 0x00053803003f0101ULL, 0x00010a2000101c04ULL, 0x00011b2000011a80ULL,
0x0000040100015180ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x000000000000046cULL, 0x0000001200000002ULL,
0x0000000000000364ULL, 0x0000001200000002ULL, 0x000000000000025cULL, 0x0000001200000002ULL,
0x0000000000000154ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x0000000000000442ULL, 0x0000001200000002ULL, 0x000000000000033aULL, 0x0000001200000002ULL,
0x0000000000000237ULL, 0x0000001200000002ULL, 0x000000000000012aULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000007919ULL, 0x000ea20000002300ULL, 0x0000001000067300ULL, 0x000ee600000e0000ULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x0000000000257919ULL, 0x000f620000002600ULL,
0x0000001000117309ULL, 0x0002a60000000000ULL, 0x0000000000307919ULL, 0x000ee80000002700ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x00000005ff027819ULL, 0x002fc60000011604ULL,
0x00000000002e7919ULL, 0x000e680000000000ULL, 0x00001fff000c7589ULL, 0x0049e800000e0000ULL,
0x00001fff02027589ULL, 0x000ea200000e0000ULL, 0x0000000100007824ULL, 0x010fe400078e0203ULL,
0x0000000825037824ULL, 0x020fc400078e00ffULL, 0x0000008000007824ULL, 0x000fe400078e0204ULL,
0x00005800ff047624ULL, 0x000fe200078e00ffULL, 0x000000070600720cULL, 0x008fe40003f02070ULL,
0x000000ff0000720cULL, 0x000fe20003f25270ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x0000000f0000780cULL, 0x040fe40003f44070ULL, 0x0000007f0000780cULL, 0x000fe20003f84070ULL,
0x0000003004037224ULL, 0x000fe200078e0203ULL, 0x000000030000780cULL, 0x000fe20003f64070ULL,
0x000000040c057824ULL, 0x004fcc00078e0202ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002050a7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000080a0b7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0005e20000000a00ULL,
0xff317217ff0dc424ULL, 0x000fe200078e00ffULL, 0x000000010a0f7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x010608060000a388ULL, 0x0007e20000008a00ULL,
0x000000010000780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff09b424ULL, 0x000fc400078e00ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0aULL, 0x0104000d0000c388ULL, 0x000fe20000004800ULL,
0x000000070a047812ULL, 0x004fc600078ec0ffULL, 0x010688080000b388ULL, 0x0005e20000008a00ULL,
0x0000001f04057812ULL, 0x002fe200078e782eULL, 0x0000000103047824ULL, 0x000fe200078e020aULL,
0x000000ff0b00720cULL, 0x040fe20003f63070ULL, 0x00000200ff077424ULL, 0x008fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f83070ULL, 0x000000200a0e7824ULL, 0x000fe400078e0205ULL,
0x3fffff80ff0a9424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fc400078e00ffULL,
0x3fffff00ff08a424ULL, 0x004fe400078e00ffULL, 0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL,
0x000000102e0d7824ULL, 0x000fe400078e00ffULL, 0x0000000103067824ULL, 0x000fe200078e020fULL,
0x0106a8080000a388ULL, 0x0003e20000008a00ULL, 0x000000070f037812ULL, 0x000fe200078ec0ffULL,
0x00005c0004047625ULL, 0x080fe200078e0007ULL, 0x000001f00d107812ULL, 0x000fe200078ec0ffULL,
0x0106b80aff009388ULL, 0x0005e20000000a00ULL, 0x0000001f03037812ULL, 0x000fe200078e782eULL,
0x00005c0006067625ULL, 0x000fc400078e0007ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001004047210ULL, 0x080fe20007fbe0ffULL, 0x000000200f037824ULL, 0x000fe200078e0203ULL,
0x0000001006067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe400010e0607ULL,
0x0000001003037824ULL, 0x000fc400078e00ffULL, 0x000000ffff007224ULL, 0x002fe200078e0a11ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040e7faeULL, 0x0003e8000d901c46ULL,
0x0000000006037faeULL, 0x0007e2000e101c46ULL, 0x00000004ff047424ULL, 0x002fc600078e00ffULL,
0x0000000000007918ULL, 0x008fe20000000000ULL, 0x0000600030047625ULL, 0x000fc600078e0004ULL,
0x01060400ffff038cULL, 0x0005e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000604037981ULL, 0x000ee2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff2c7e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff032d7810ULL, 0x008fc80007ffe0ffULL,
0x00000008ff2d7819ULL, 0x000fce000001162dULL, 0x0001045000008947ULL, 0x000fea0003800000ULL,
0x0000580025007a10ULL, 0x004fe20007ffe0ffULL, 0x0000000230307824ULL, 0x000fe200078e00ffULL,
0x000000012c047810ULL, 0x000fe20007ffe0ffULL, 0x00000008022f7824ULL, 0x000fe400078e00ffULL,
0x0000580030307a24ULL, 0x000fe200078e0200ULL, 0x0000002d0400720cULL, 0x000fe20003f06070ULL,
0x00000003ff007424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff077819ULL, 0x000fe2000001162eULL, 0x01068c002fff738cULL, 0x0003e20000000000ULL,
0x000000f00d147812ULL, 0x000fe200078ec0ffULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0x00000002070e7810ULL, 0x000fe20007ffe0ffULL, 0x000000012f057824ULL, 0x000fe200078e0207ULL,
0x0000000407107810ULL, 0x000fc40007ffe0ffULL, 0x0000000607127810ULL, 0x000fe20007ffe0ffULL,
0x000000012f087824ULL, 0x000fe200078e020eULL, 0x0000000705067812ULL, 0x000fe200078ec0ffULL,
0x000001002c007824ULL, 0x002fe400078e00ffULL, 0x000000012f0a7824ULL, 0x040fe200078e0210ULL,
0x0000000f06067812ULL, 0x000fe200078e782eULL, 0x000000012f137824ULL, 0x000fe200078e0212ULL,
0x0000000003047217ULL, 0x000fe40007800000ULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x00000010050d7824ULL, 0x000fe200078e0206ULL, 0x000000070a0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000104047824ULL, 0x000fe200078e0a00ULL, 0x0000000f09097812ULL, 0x000fe200078e782eULL,
0x0000620030007a24ULL, 0x000fe200078e0200ULL, 0x0000000f0b0b7812ULL, 0x000fc400078e782eULL,
0x0000002004067807ULL, 0x000fe20000000000ULL, 0x0000000100057824ULL, 0x000fe200078e0205ULL,
0x00000007130c7812ULL, 0x000fe200078ec0ffULL, 0x00000010080f7824ULL, 0x000fe200078e0209ULL,
0x000000062f067217ULL, 0x000fe20007800000ULL, 0x00005e0005047625ULL, 0x000fe200078e0015ULL,
0x0000c0000d0d7811ULL, 0x000fc600078e20ffULL, 0x000000100a117824ULL, 0x000fe200078e020bULL,
0x0000000f0c0b7812ULL, 0x000fe200078e782eULL, 0x0000000100097824ULL, 0x000fe200078e020aULL,
0x00000014040a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001060c7824ULL, 0x000fe400078e0a2fULL,
0x0000000100087824ULL, 0x040fe400078e0208ULL, 0x0000000100007824ULL, 0x000fe200078e0213ULL,
0x0000000c0700720cULL, 0x080fe20003f26070ULL, 0x0000001013137824ULL, 0x000fe200078e020bULL,
0x0000000c0e00720cULL, 0x080fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e0605ULL,
0x0000000c1000720cULL, 0x080fe20003f66070ULL, 0x00005e0008047625ULL, 0x000fe200078e0015ULL,
0x0000000c1200720cULL, 0x000fc60003f06070ULL, 0x00005e0009067625ULL, 0x000fe200078e0015ULL,
0x0000001404047210ULL, 0x000fc60007f9e0ffULL, 0x00005e0000087625ULL, 0x000fe200078e0015ULL,
0x0000001406067210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff057224ULL, 0x000fe200020e0605ULL,
0x0000001408087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff077224ULL, 0x000fc800028e0607ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x010688002fff7f8cULL, 0x0003e2000c80043fULL,
0x0000c00011117811ULL, 0x000fe200078e20ffULL, 0xff317217ff317424ULL, 0x000fe200078e00ffULL,
0x0000c00013137811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c901c46ULL, 0x0000002d2c00720cULL, 0x000fe20003f26070ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0003e2000d101c46ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000006117faeULL, 0x0003e2000d901c46ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000ffff157224ULL, 0x000fc600078e00ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff247f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff267f8cULL, 0x000ee2000c80043fULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000c4a000001947ULL, 0x000fea0003800000ULL, 0x0000000402337824ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x004fc400078e0025ULL, 0x000000ffff247224ULL, 0x008fe200078e0027ULL,
0x0000000233347810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff317424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fe400078e00ffULL, 0x000001002c007824ULL, 0x000fca00078e00ffULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000c3d000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007804824ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007804824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000202c007811ULL, 0x000fe200078e40ffULL, 0x00000100ff407424ULL, 0x000fe200078e00ffULL,
0x00000004ff3f7819ULL, 0x000fe2000001162eULL, 0x000000102e4a7824ULL, 0x000fe200078e00ffULL,
0x0000000003257217ULL, 0x000fe40007800000ULL, 0x000000012c247810ULL, 0x000fe20007ffe0ffULL,
0x000000012f367824ULL, 0x000fe200078e023fULL, 0x000000023f387810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x100fe200078e0a00ULL, 0x000000043f397810ULL, 0x000fe20007ffe0ffULL,
0x0000620030007a24ULL, 0x000fe200078e0200ULL, 0x0000002d2400720cULL, 0x000fe20003f06070ULL,
0x000000012f3b7824ULL, 0x000fe200078e0238ULL, 0x000000063f3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000012f3c7824ULL, 0x000fe200078e0239ULL, 0x0000002025267807ULL, 0x000fe20000000000ULL,
0x0000000136247824ULL, 0x100fe200078e0200ULL, 0x000000f04a377812ULL, 0x000fe200078ec0ffULL,
0x000000013b277824ULL, 0x100fe200078e0200ULL, 0x000000262f3e7217ULL, 0x000fe20007800000ULL,
0x000000013c287824ULL, 0x000fc400078e0200ULL, 0x00005e0024247625ULL, 0x000fc800078e0040ULL,
0x00005e0027267625ULL, 0x000fe200078e0040ULL, 0x00000037242a7210ULL, 0x000fc60007f3e0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0040ULL, 0x0000003726267210ULL, 0x000fc60007f5e0ffULL,
0x000000012f3d7824ULL, 0x000fe200078e023aULL, 0x0000003728287210ULL, 0x000fe20007f7e0ffULL,
0x000000013e3e7824ULL, 0x000fe400078e0a2fULL, 0x000000013d247824ULL, 0x000fe200078e0200ULL,
0x0000000736007812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2b7224ULL, 0x000fe200008e0625ULL,
0x0000003e3f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x0000003e3800720cULL, 0x080fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x0000003e3900720cULL, 0x000fe20003f66070ULL, 0x00005e0024247625ULL, 0x000fe200078e0040ULL,
0x0000003e3a00720cULL, 0x000fc40003f86070ULL, 0x000000073b3e7812ULL, 0x000fe400078ec0ffULL,
0x000000073c3f7812ULL, 0x000fe400078ec0ffULL, 0x000000073d407812ULL, 0x000fe400078ec0ffULL,
0x0000000f00007812ULL, 0x100fe400078e782eULL, 0x0000000f3e3e7812ULL, 0x100fe400078e782eULL,
0x0000000f3f3f7812ULL, 0x000fe200078e782eULL, 0x00000010365e7824ULL, 0x000fe200078e0200ULL,
0x0000000f40407812ULL, 0x000fe200078e782eULL, 0x000000103b5d7824ULL, 0x000fe200078e023eULL,
0x0000003724247210ULL, 0x000fe20007fbe0ffULL, 0x000000103c457824ULL, 0x000fe200078e023fULL,
0x0000e0005e467811ULL, 0x000fe200078e20ffULL, 0x000000103d447824ULL, 0x000fe200078e0240ULL,
0x0000e0005d477811ULL, 0x000fe200078e20ffULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x0000e00045487811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a467faeULL, 0x0003e2000c901c46ULL, 0x0000e00044497811ULL, 0x000fc600078e20ffULL,
0x0000000026477faeULL, 0x0003e8000d101c46ULL, 0x0000000028487faeULL, 0x0003e8000d901c46ULL,
0x0000000024497faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff427f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010608002f247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844841ULL, 0x01060c002f267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01060c002f267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff007819ULL, 0x000fe2000001162eULL,
0xffffffffff4b7424ULL, 0x000fe200078e00ffULL, 0x000000704a4a7812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x000000014a4a7824ULL, 0x000fca00078e0200ULL,
0x010000004a267984ULL, 0x000e680000000800ULL, 0x010200004a277984ULL, 0x0007220000000800ULL,
0x000000312600720bULL, 0x002fe20003f3d000ULL, 0x00013c927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00287812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff717424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fe40003f65270ULL,
0x000000312600720bULL, 0x000fe20003f34000ULL, 0x00013c527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000002631297209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x010400294a00b388ULL, 0x0003e20000000800ULL,
0x8000002931247221ULL, 0x000fe20000010000ULL, 0x0000000028ff7212ULL, 0x000fc6000782c0ffULL,
0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL, 0x00000024002a7308ULL, 0x0007240000000800ULL,
0x00000002ff247819ULL, 0x008fe2000001162eULL, 0x00013bf27f007947ULL, 0x000fea000b800000ULL,
0x00001f242a257589ULL, 0x0122e400000e0000ULL, 0x0000000824247810ULL, 0x002fe20007ffe0ffULL,
0x00013c427f007947ULL, 0x000fea000b800000ULL, 0x00001f242a247589ULL, 0x00032400000e0000ULL,
0x8000002926261221ULL, 0x100fe20000010000ULL, 0x0000002a32327220ULL, 0x000fe20000410000ULL,
0x0000002423237220ULL, 0x090fe20000410000ULL, 0x0000002422227220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL, 0x000000241f1f7220ULL, 0x080fe20000410000ULL,
0x000000241e1e7220ULL, 0x080fe20000410000ULL, 0x000000241b1b7220ULL, 0x080fe20000410000ULL,
0x0000002600351308ULL, 0x000f220000000800ULL, 0x000000241a1a7220ULL, 0x080fe20000410000ULL,
0x0000002417177220ULL, 0x080fe20000410000ULL, 0x0000002416167220ULL, 0x080fe20000410000ULL,
0x0000002413137220ULL, 0x080fe20000410000ULL, 0x0000002412127220ULL, 0x080fe20000410000ULL,
0x000000240f0f7220ULL, 0x080fe20000410000ULL, 0x000000240e0e7220ULL, 0x080fe20000410000ULL,
0x000000240b0b7220ULL, 0x080fe20000410000ULL, 0x000000240a0a7220ULL, 0x080fe20000410000ULL,
0x0000002407077220ULL, 0x080fe20000410000ULL, 0x0000002406067220ULL, 0x000fe20000410000ULL,
0x00000001ff717807ULL, 0x000fe20000800000ULL, 0x0000002521217220ULL, 0x088fe20000410000ULL,
0x0000002520207220ULL, 0x080fe20000410000ULL, 0x000000251d1d7220ULL, 0x080fe20000410000ULL,
0x000000251c1c7220ULL, 0x080fe20000410000ULL, 0x0000002519197220ULL, 0x080fe20000410000ULL,
0x0000002518187220ULL, 0x080fe20000410000ULL, 0x0000002515157220ULL, 0x080fe20000410000ULL,
0x0000002514147220ULL, 0x080fe20000410000ULL, 0x0000002511117220ULL, 0x080fe20000410000ULL,
0x0000002510107220ULL, 0x080fe20000410000ULL, 0x000000250d0d7220ULL, 0x080fe20000410000ULL,
0x000000250c0c7220ULL, 0x080fe20000410000ULL, 0x0000002509097220ULL, 0x080fe20000410000ULL,
0x0000002508087220ULL, 0x080fe20000410000ULL, 0x0000002505057220ULL, 0x080fe20000410000ULL,
0x0000002504047220ULL, 0x000fe20000410000ULL, 0x000000ffff317224ULL, 0x000fe200078e0029ULL,
0x0000003527271220ULL, 0x010fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003227327221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fe40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000035ff00723eULL, 0x000fe400000000ffULL, 0x00000004ff8b7819ULL, 0x000fc4000001162eULL,
0x00000002ff407819ULL, 0x000fe4000001162eULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000138e27f007947ULL, 0x000fea000b800000ULL, 0x00001f405a667589ULL, 0x00072400000e0000ULL,
0x00000008403e7810ULL, 0x000fe20007ffe0ffULL, 0x000139227f007947ULL, 0x000fea000b800000ULL,
0x00001f3e5a657589ULL, 0x0002e400000e0000ULL, 0x00000010403f7810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e003fULL,
0x00001ae0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0001490000007944ULL, 0x01efea0003c00000ULL,
0x0000001840407810ULL, 0x008fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e0040ULL, 0x00001b50005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001489000007944ULL, 0x016fea0003c00000ULL, 0x000000082e007812ULL, 0x044fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000332e247211ULL, 0x000fe400078fe0ffULL,
0x0000000700257812ULL, 0x140fe400078ec82eULL, 0x0000000700007812ULL, 0x000fe400078ef82eULL,
0x0000002425627212ULL, 0x000fe400078e3cffULL, 0x000000342e247211ULL, 0x000fc400078fe0ffULL,
0x000000072e607812ULL, 0x000fe200078ec0ffULL, 0x0000001000637824ULL, 0x000fe200078e0262ULL,
0x0000002425617212ULL, 0x000fe400078e3cffULL, 0x0000000860607812ULL, 0x000fe400078ef82eULL,
0x0000c000634c7811ULL, 0x000fe200078e20ffULL, 0x00000010005f7824ULL, 0x040fe200078e0261ULL,
0x0000010000007811ULL, 0x000fc600078e20ffULL, 0x000000004c50783bULL, 0x000ea20000004200ULL,
0x0000c0005f4d7811ULL, 0x000fe200078e20ffULL, 0x0000000162627824ULL, 0x100fe400078e0200ULL,
0x0000000161617824ULL, 0x000fe400078e0200ULL, 0x000000004d24783bULL, 0x000ee20000004200ULL,
0x0000c000624e7811ULL, 0x000fe400078e20ffULL, 0x0000c000614f7811ULL, 0x000fc600078e20ffULL,
0x000000004e54783bULL, 0x000fe80000004200ULL, 0x000000004f28783bULL, 0x002e620000004200ULL,
0x00000018ff727819ULL, 0x004fe20000011450ULL, 0x0000010050597824ULL, 0x040fe200078e00ffULL,
0x0000888050587816ULL, 0x040fe200000000ffULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe40000011451ULL, 0x0000005800747306ULL, 0x0005e20000200c00ULL,
0x00000018ff6e7819ULL, 0x008fc40000011425ULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff6d7819ULL, 0x000fe40000011424ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000005000767306ULL, 0x0007e20000200c00ULL, 0x0000888051587816ULL, 0x004fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011426ULL, 0x00000018ff6f7819ULL, 0x000fc40000011452ULL,
0x00000018ff707819ULL, 0x000fe20000011453ULL, 0x0000005900757306ULL, 0x000ea20000200c00ULL,
0x000000ffff507224ULL, 0x008fe200078e0058ULL, 0x00000018ff6c7819ULL, 0x000fe20000011427ULL,
0x0000010051587824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x002fe40000011429ULL,
0x00000018ff6a7819ULL, 0x000fe40000011454ULL, 0x0000005000777306ULL, 0x0003e20000200c00ULL,
0x00000018ff587819ULL, 0x000fc40000011458ULL, 0x00000018ff697819ULL, 0x000fe40000011455ULL,
0x00000018ff677819ULL, 0x000fe40000011428ULL, 0x00000018ff5c7819ULL, 0x000fe20000011456ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0001000051507824ULL, 0x002fe200078e00ffULL,
0x0000541074747816ULL, 0x004fe40000000075ULL, 0x00000018ff647819ULL, 0x000fe40000011457ULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x0000005800517306ULL, 0x0002a20000200c00ULL,
0x00000018ff007819ULL, 0x000fe4000001142aULL, 0x00000018ff417819ULL, 0x000fca000001142bULL,
0x0000005000787306ULL, 0x000be20000200c00ULL, 0x0000888052587816ULL, 0x002fe400000000ffULL,
0x0000541076727816ULL, 0x008fca0000000072ULL, 0x0000007300737306ULL, 0x000e620000200c00ULL,
0x000000ffff507224ULL, 0x020fe200078e0058ULL, 0x0000541077757816ULL, 0x004fe20000000051ULL,
0x0000010052587824ULL, 0x040fe400078e00ffULL, 0x0001000052527824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005000797306ULL, 0x0005e20000200c00ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000541078737816ULL, 0x002fca0000000073ULL,
0x00000058007a7306ULL, 0x0002e20000200c00ULL, 0x0000888053507816ULL, 0x004fce00000000ffULL,
0x00000050007b7306ULL, 0x0005e20000200c00ULL, 0x0000010053587824ULL, 0x042fe400078e00ffULL,
0x0001000053537824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000888024507816ULL, 0x004fe400000000ffULL, 0x00005410797a7816ULL, 0x008fca000000007aULL,
0x00000058007c7306ULL, 0x0002b00000200c00ULL, 0x00000050007d7306ULL, 0x0007e20000200c00ULL,
0x0000010024587824ULL, 0x042fe400078e00ffULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000888025507816ULL, 0x008fe400000000ffULL,
0x000054107b7b7816ULL, 0x004fca000000007cULL, 0x00000058007e7306ULL, 0x0002b00000200c00ULL,
0x00000050007f7306ULL, 0x0007e20000200c00ULL, 0x0000010025587824ULL, 0x042fe400078e00ffULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x0000002400807306ULL, 0x0003e20000200c00ULL,
0x000000078b507812ULL, 0x008fe400078e7860ULL, 0x000054107d7e7816ULL, 0x004fc6000000007eULL,
0x0000000860507824ULL, 0x000fe400078e0250ULL, 0x0000002500827306ULL, 0x0005e20000200c00ULL,
0x0000888026247816ULL, 0x002fce00000000ffULL, 0x0000005800817306ULL, 0x0002e20000200c00ULL,
0x0000010026257824ULL, 0x044fe400078e00ffULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400837306ULL, 0x0005e20000200c00ULL,
0x0000a00050587811ULL, 0x002fe400078e20ffULL, 0x00000018ff267819ULL, 0x000fc80000011426ULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x0000002500847306ULL, 0x000b220000200c00ULL,
0x0000888027247816ULL, 0x004fe400000000ffULL, 0x000054107f7f7816ULL, 0x008fca0000000081ULL,
0x0000002400857306ULL, 0x0005e20000200c00ULL, 0x0000010027257824ULL, 0x060fe400078e00ffULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002600867306ULL, 0x0007e20000200c00ULL, 0x0000888054247816ULL, 0x004fe400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000541083847816ULL, 0x010fc60000000084ULL,
0x0000002500877306ULL, 0x0005220000200c00ULL, 0x0000888057267816ULL, 0x008fce00000000ffULL,
0x0000002400897306ULL, 0x0007e20000200c00ULL, 0x0000010054257824ULL, 0x044fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000888055247816ULL, 0x008fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000541085857816ULL, 0x010fc60000000087ULL,
0x00000025008a7306ULL, 0x0007300000200c00ULL, 0x00000024008b7306ULL, 0x000be20000200c00ULL,
0x0000010055257824ULL, 0x048fe200078e00ffULL, 0x0000541052527816ULL, 0x004fe2000000006fULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000888056247816ULL, 0x020fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00005410898a7816ULL, 0x010fc6000000008aULL,
0x00000025008c7306ULL, 0x0007300000200c00ULL, 0x00000024008d7306ULL, 0x000be20000200c00ULL,
0x0000010056257824ULL, 0x048fe200078e00ffULL, 0x0000541053537816ULL, 0x004fe20000000070ULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000002700887306ULL, 0x000fe20000200c00ULL, 0x0000991071247816ULL, 0x020fe400000000ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x000000ff2400720cULL, 0x000fe20003f25270ULL,
0x000000ffff247224ULL, 0x000fe200078e0026ULL, 0x0000888029267816ULL, 0x000fe200000000ffULL,
0x0000002500717306ULL, 0x0005e20000200c00ULL, 0x000054108b8b7816ULL, 0x010fce000000008cULL,
0x00000024008e7306ULL, 0x0007e20000200c00ULL, 0x0000010057257824ULL, 0x044fe200078e00ffULL,
0x0000006658589232ULL, 0x082fe20000000000ULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x000000665a5a9232ULL, 0x000fe40000000000ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000006559599232ULL, 0x080fe20000000000ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000888028247816ULL, 0x008fe200000000ffULL, 0x000000655b5b9232ULL, 0x000fe20000000000ULL,
0x00000018ff577819ULL, 0x000fca0000011457ULL, 0x00000025008f7306ULL, 0x0005e20000200c00ULL,
0x000000745804723cULL, 0x040fee0000001804ULL, 0x0000002400907306ULL, 0x0007e20000200c00ULL,
0x0000010028257824ULL, 0x044fe200078e00ffULL, 0x000000725808723cULL, 0x000fe20000001808ULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x0000541080807816ULL, 0x002fc4000000006dULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000000738247812ULL, 0x008fe200078e7860ULL, 0x000000525810723cULL, 0x000fe20000001810ULL,
0x00000018ff287819ULL, 0x000fc60000011428ULL, 0x0000000860517824ULL, 0x000fe400078e0224ULL,
0x0000002500917306ULL, 0x0004e40000200c00ULL, 0x0000007a580c723cULL, 0x000fe2000000180cULL,
0x0000a00051247811ULL, 0x000fca00078e20ffULL, 0x0000006b006b7306ULL, 0x000f220000200c00ULL,
0x000000ffff257224ULL, 0x004fe200078e0026ULL, 0x0000541082817816ULL, 0x002fe2000000006eULL,
0x0000010029267824ULL, 0x040fe200078e00ffULL, 0x0000007e5814723cULL, 0x000fe20000001814ULL,
0x0001000029297824ULL, 0x000fc600078e00ffULL, 0x0000002500747306ULL, 0x0003e20000200c00ULL,
0x00000018ff727819ULL, 0x000fe40000011426ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x000000805818723cULL, 0x000fe20000001818ULL, 0x0000541090907816ULL, 0x008fc60000000091ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x000000002424783bULL, 0x002e620000000200ULL,
0x0000541086867816ULL, 0x010fe4000000006bULL, 0x00000084581c723cULL, 0x000fe8000000181cULL,
0x0000002900527306ULL, 0x0007f00000200c00ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000001002a297824ULL, 0x008fe200078e00ffULL, 0x0000541088877816ULL, 0x004fc8000000006cULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000000865820723cULL, 0x000fee0000001820ULL, 0x0000005400547306ULL, 0x000eb00000200c00ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x0000006624249232ULL, 0x002fc40000000000ULL,
0x0000006626269232ULL, 0x000fe40000000000ULL, 0x0000006525259232ULL, 0x080fe40000000000ULL,
0x0000006527279232ULL, 0x000fe20000000000ULL, 0x0000007200737306ULL, 0x000e620000200c00ULL,
0x0000541054547816ULL, 0x004fca000000006aULL, 0x0000008a2404723cULL, 0x000fe40000001804ULL,
0x0000002800727306ULL, 0x0005e20000200c00ULL, 0x0000541055557816ULL, 0x008fce0000000069ULL,
0x00000029006d7306ULL, 0x0007e20000200c00ULL, 0x000088802a287816ULL, 0x044fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fe200078e00ffULL, 0x000000542408723cULL, 0x000fe20000001808ULL,
0x0000541074917816ULL, 0x002fc60000000073ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002800537306ULL, 0x0003e20000200c00ULL, 0x000001002b297824ULL, 0x048fe400078e00ffULL,
0x000000902414723cULL, 0x000fe60000001814ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000088802b287816ULL, 0x042fe200000000ffULL,
0x000100002b2b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x0000002800667306ULL, 0x0003f00000200c00ULL, 0x0000002900587306ULL, 0x0007e20000200c00ULL,
0x000054108d287816ULL, 0x002fc40000000071ULL, 0x0000541072727816ULL, 0x004fca0000000067ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x000054108e297816ULL, 0x008fce000000008fULL,
0x00000028240c723cULL, 0x000fe2000000180cULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000541052737816ULL, 0x002fce0000000068ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000000722418723cULL, 0x000fee0000001818ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000005700297306ULL, 0x000eb00000200c00ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x0000541056287816ULL, 0x002fce000000005cULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000541029297816ULL, 0x004fce0000000064ULL, 0x0000002a00547306ULL, 0x0002b00000200c00ULL,
0x0000002b00557306ULL, 0x0007220000200c00ULL, 0x00005410532a7816ULL, 0x002fe4000000006dULL,
0x0000541054547816ULL, 0x004fc40000000000ULL, 0x00005410662b7816ULL, 0x008fe40000000058ULL,
0x0000541055557816ULL, 0x010fca0000000041ULL, 0x0000002a241c723cULL, 0x040ff0000000181cULL,
0x000000282428723cULL, 0x040ff00000001810ULL, 0x000000542424723cULL, 0x000fe20000001820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff107f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000402c007811ULL, 0x000fe200078e40ffULL, 0x00000100ff527424ULL, 0x000fe200078e00ffULL,
0x00000004ff237819ULL, 0x000fe4000001162eULL, 0x0000000003107217ULL, 0x000fe40007800000ULL,
0x0000c0005d537811ULL, 0x000fe400078e20ffULL, 0x0000c00045547811ULL, 0x000fe200078e20ffULL,
0x0000000110107824ULL, 0x100fe200078e0a00ULL, 0x0000c00044557811ULL, 0x000fe200078e20ffULL,
0x0000620030007a24ULL, 0x000fc600078e0200ULL, 0x0000002010107807ULL, 0x000fe20000000000ULL,
0x0000000136117824ULL, 0x100fe400078e0200ULL, 0x000000013b137824ULL, 0x100fe200078e0200ULL,
0x000000102f127217ULL, 0x000fe20007800000ULL, 0x000000013c207824ULL, 0x000fe400078e0200ULL,
0x00005e0011107625ULL, 0x000fc800078e0052ULL, 0x0000000112417824ULL, 0x000fe200078e0a2fULL,
0x0000003710107210ULL, 0x000fe20007f7e0ffULL, 0x00005e0013127625ULL, 0x000fc600078e0052ULL,
0x000000412300720cULL, 0x000fe20003f46070ULL, 0x00005e0020207625ULL, 0x000fe200078e0052ULL,
0x0000003712127210ULL, 0x000fc60007f9e0ffULL, 0x000000013d227824ULL, 0x000fe200078e0200ULL,
0x0000003720207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e0611ULL,
0x000000413800720cULL, 0x000fe20003f66070ULL, 0x00005e0022227625ULL, 0x000fe200078e0052ULL,
0x0000c0005e527811ULL, 0x000fc600078e20ffULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x000000413900720cULL, 0x080fe20003f86070ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x000000413a00720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010527faeULL, 0x0003e2000d101c46ULL, 0x0000003722227210ULL, 0x000fc60007fde0ffULL,
0x0000000012537faeULL, 0x0003e4000d901c46ULL, 0x000000ffff237224ULL, 0x000fc800030e0623ULL,
0x0000000020547faeULL, 0x0003e8000e101c46ULL, 0x0000000022557faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff107f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844843ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e0011ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000107305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x0106b400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007844843ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000035ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff5b7819ULL, 0x000fe4000001162eULL,
0x00005410005a7816ULL, 0x000fe20000000000ULL, 0x000122d27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b5a657589ULL, 0x0002a400000e0000ULL, 0x000123127f007947ULL, 0x000fea000b800000ULL,
0x00001f3e5a647589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x002fe200078e003fULL, 0x000031b0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001323000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x002fe200078e0040ULL, 0x00003210005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000131d000007944ULL, 0x01cfea0003c00000ULL, 0x0000e00063567811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000e0005f577811ULL, 0x000fe400078e20ffULL,
0x0000e00062447811ULL, 0x000fe200078e20ffULL, 0x000000005658783bULL, 0x00ae620000004200ULL,
0x0000e00061457811ULL, 0x000fc600078e20ffULL, 0x00000000575c783bULL, 0x000fe80000004200ULL,
0x000000004420783bULL, 0x000ee80000004200ULL, 0x000000004510783bULL, 0x000f620000004200ULL,
0x0000010058437824ULL, 0x042fe200078e00ffULL, 0x0000888058427816ULL, 0x000fc400000000ffULL,
0x00000018ff707819ULL, 0x000fe20000011458ULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004200727306ULL, 0x0003e20000200c00ULL,
0x00000018ff717819ULL, 0x000fe40000011459ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff6e7819ULL, 0x000fe4000001145aULL, 0x00000018ff6f7819ULL, 0x000fe2000001145bULL,
0x0000004300737306ULL, 0x0008a20000200c00ULL, 0x0000888059427816ULL, 0x002fc400000000ffULL,
0x00000018ff687819ULL, 0x008fe40000011421ULL, 0x00000018ff697819ULL, 0x000fe40000011420ULL,
0x00000018ff6c7819ULL, 0x000fe2000001145cULL, 0x0000004200757306ULL, 0x0003e20000200c00ULL,
0x0000010059437824ULL, 0x050fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001145dULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001145eULL,
0x00000018ff437819ULL, 0x000fc40000011443ULL, 0x0000005800747306ULL, 0x0007e20000200c00ULL,
0x000088805a427816ULL, 0x002fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff6b7819ULL, 0x000fe4000001145fULL, 0x00000018ff667819ULL, 0x000fe20000011422ULL,
0x0000004300767306ULL, 0x0003220000200c00ULL, 0x0000888021587816ULL, 0x008fe400000000ffULL,
0x0000541072727816ULL, 0x004fc40000000073ULL, 0x00000018ff677819ULL, 0x000fe40000011423ULL,
0x00000018ff637819ULL, 0x020fe20000011411ULL, 0x0000004200787306ULL, 0x0005e20000200c00ULL,
0x000001005a437824ULL, 0x042fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011410ULL,
0x000100005a5a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011413ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000005900777306ULL, 0x0003e20000200c00ULL,
0x000088805b427816ULL, 0x004fc400000000ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x0000541075737816ULL, 0x010fe40000000076ULL, 0x00000018ff007819ULL, 0x000fe20000011412ULL,
0x0000004300797306ULL, 0x0004e20000200c00ULL, 0x0000010021597824ULL, 0x042fe400078e00ffULL,
0x0001000021217824ULL, 0x000fca00078e00ffULL, 0x00000042007b7306ULL, 0x0003e20000200c00ULL,
0x000001005b437824ULL, 0x044fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x000100005b5b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005a007a7306ULL, 0x000fe20000200c00ULL,
0x000088805c427816ULL, 0x002fe400000000ffULL, 0x0000541078787816ULL, 0x008fca0000000079ULL,
0x00000043007c7306ULL, 0x0002b00000200c00ULL, 0x00000042007e7306ULL, 0x0007e20000200c00ULL,
0x000001005c437824ULL, 0x042fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000005b007d7306ULL, 0x000fe20000200c00ULL,
0x000088805d427816ULL, 0x008fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000054107b797816ULL, 0x004fc6000000007cULL, 0x00000043007f7306ULL, 0x0002b00000200c00ULL,
0x0000004200807306ULL, 0x0007e20000200c00ULL, 0x000001005d437824ULL, 0x042fe400078e00ffULL,
0x000100005d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x000088805e427816ULL, 0x008fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000054107e7e7816ULL, 0x004fc6000000007fULL,
0x0000004300817306ULL, 0x0004f00000200c00ULL, 0x0000004200827306ULL, 0x0009e20000200c00ULL,
0x000001005e437824ULL, 0x004fe200078e00ffULL, 0x0000541074707816ULL, 0x002fe20000000070ULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000088805f427816ULL, 0x010fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00005410807f7816ULL, 0x008fc60000000081ULL,
0x0000004300837306ULL, 0x0004f00000200c00ULL, 0x0000004200847306ULL, 0x0009e20000200c00ULL,
0x000001005f437824ULL, 0x004fe200078e00ffULL, 0x0000541077717816ULL, 0x002fe20000000071ULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000021008b7306ULL, 0x0003e20000200c00ULL, 0x0000888020427816ULL, 0x010fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000541082827816ULL, 0x008fc60000000083ULL,
0x0000004300857306ULL, 0x0004e20000200c00ULL, 0x0000010022217824ULL, 0x002fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000004200867306ULL, 0x0003e20000200c00ULL,
0x0000010020437824ULL, 0x044fe400078e00ffULL, 0x0001000020207824ULL, 0x000fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x00000018ff427819ULL, 0x002fe40000011443ULL, 0x0000000739437812ULL, 0x000fe400078e7860ULL,
0x0000541084837816ULL, 0x008fc60000000085ULL, 0x0000000860437824ULL, 0x000fe200078e0243ULL,
0x0000004200877306ULL, 0x0002e20000200c00ULL, 0x000054107a6e7816ULL, 0x004fce000000006eULL,
0x0000002000887306ULL, 0x0005e20000200c00ULL, 0x000000ffff427224ULL, 0x002fe200078e0058ULL,
0x0000a00043587811ULL, 0x000fcc00078e20ffULL, 0x0000004200897306ULL, 0x0003e20000200c00ULL,
0x0000888022207816ULL, 0x044fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000541086867816ULL, 0x008fc80000000087ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff427819ULL, 0x002fe40000011459ULL,
0x000000005858783bULL, 0x000e6a0000000200ULL, 0x00000042008a7306ULL, 0x0007300000200c00ULL,
0x00000021008d7306ULL, 0x000be20000200c00ULL, 0x000000073a427812ULL, 0x008fc400078e7860ULL,
0x000054107d6f7816ULL, 0x004fc6000000006fULL, 0x0000000860427824ULL, 0x000fe400078e0242ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000010023217824ULL, 0x020fe200078e00ffULL,
0x0000541089877816ULL, 0x010fc8000000008aULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000005c005c7306ULL, 0x000eb00000200c00ULL, 0x00000020008c7306ULL, 0x0007220000200c00ULL,
0x0000006558589232ULL, 0x002fc40000000000ULL, 0x000000655a5a9232ULL, 0x000fe40000000000ULL,
0x0000006459599232ULL, 0x000fc60000000000ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000000645b5b9232ULL, 0x000fe20000000000ULL, 0x0000888023207816ULL, 0x048fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x000054105c6c7816ULL, 0x004fc8000000006cULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000000725804723cULL, 0x000fe20000001804ULL,
0x00000018ff237819ULL, 0x000fe40000011423ULL, 0x000054108c8c7816ULL, 0x010fc8000000008dULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000705808723cULL, 0x000fe20000001808ULL,
0x0000010011737824ULL, 0x000fca00078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x0000888011717816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000006e5828723cULL, 0x040fe80000001828ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000005e005e7306ULL, 0x000ea60000200c00ULL,
0x00000078580c723cULL, 0x000fea000000180cULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000054105d6d7816ULL, 0x002fc4000000006dULL, 0x0000007e5814723cULL, 0x040fea0000001814ULL,
0x00000020008f7306ULL, 0x0003e20000200c00ULL, 0x000054105e6a7816ULL, 0x004fe4000000006aULL,
0x0000006c5818723cULL, 0x000fea0000001818ULL, 0x0000002100907306ULL, 0x0005220000200c00ULL,
0x0000a00042207811ULL, 0x002fc400078e20ffULL, 0x000054105f6b7816ULL, 0x008fe2000000006bULL,
0x00000082581c723cULL, 0x000fe8000000181cULL, 0x00000022008e7306ULL, 0x0003e20000200c00ULL,
0x0000888010217816ULL, 0x004fc600000000ffULL, 0x0000006a5824723cULL, 0x000fe80000001824ULL,
0x0000002300607306ULL, 0x000fe20000200c00ULL, 0x0000010010227824ULL, 0x042fe200078e00ffULL,
0x000054108f8d7816ULL, 0x010fe20000000090ULL, 0x0001000010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011422ULL, 0x0000002100727306ULL, 0x0003e20000200c00ULL,
0x00000018ff107819ULL, 0x000fce0000011410ULL, 0x00000011005c7306ULL, 0x0005e20000200c00ULL,
0x000000002020783bULL, 0x002e6e0000000200ULL, 0x00000010006e7306ULL, 0x0007e20000200c00ULL,
0x0000010012117824ULL, 0x004fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x0000888012107816ULL, 0x048fe200000000ffULL,
0x0001000012127824ULL, 0x000fca00078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000010005d7306ULL, 0x0007f00000200c00ULL, 0x0000001100587306ULL, 0x0009620000200c00ULL,
0x0000888013107816ULL, 0x008fc400000000ffULL, 0x0000541088887816ULL, 0x004fca0000000069ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000010013117824ULL, 0x050fe200078e00ffULL,
0x0000006520209232ULL, 0x082fe20000000000ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000006522229232ULL, 0x000fe40000000000ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006421219232ULL, 0x080fe20000000000ULL, 0x00000018ff5e7819ULL, 0x000fe20000011413ULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x0000006423239232ULL, 0x000fe20000000000ULL,
0x000054105d587816ULL, 0x020fc40000000058ULL, 0x000054108b897816ULL, 0x004fc80000000068ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000000862004723cULL, 0x040fee0000001804ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000054108e667816ULL, 0x002fe20000000066ULL,
0x000000882008723cULL, 0x040fec0000001808ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x0000541060677816ULL, 0x004fe20000000067ULL, 0x0000008c200c723cULL, 0x000fec000000180cULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000054106e627816ULL, 0x008fce0000000062ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054105c637816ULL, 0x002fce0000000063ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541072707816ULL, 0x004fe20000000070ULL,
0x000000622018723cULL, 0x000fec0000001818ULL, 0x0000001000597306ULL, 0x000ff00000200c00ULL,
0x00000011005b7306ULL, 0x000ea20000200c00ULL, 0x0000541071717816ULL, 0x002fce0000000073ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x000000702014723cULL, 0x000fee0000001814ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000541059597816ULL, 0x004fce000000005bULL,
0x00000012005a7306ULL, 0x0002a20000200c00ULL, 0x00000058201c723cULL, 0x040fee000000181cULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x000000662010723cULL, 0x002fe20000001828ULL,
0x000054105a5a7816ULL, 0x004fc40000000000ULL, 0x000054105e5b7816ULL, 0x008fce0000000061ULL,
0x0000005a2020723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000402c007811ULL, 0x000fe200078e40ffULL,
0x01068800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff247224ULL, 0x002fe400078e0025ULL,
0x000000000300720cULL, 0x000fda0003f24070ULL, 0x00008f7000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824824ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000602c007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff297819ULL, 0x000fe4000001162eULL, 0x0000000003247217ULL, 0x000fe20007800000ULL,
0x0000620030287a24ULL, 0x000fc800078e0200ULL, 0x0000000124247824ULL, 0x000fe400078e0a00ULL,
0x0000000136257824ULL, 0x100fe400078e0228ULL, 0x000000013b267824ULL, 0x000fe200078e0228ULL,
0x0000002024007807ULL, 0x000fe20000000000ULL, 0x00005e0025247625ULL, 0x000fc600078e0058ULL,
0x000000002f007217ULL, 0x000fe20007800000ULL, 0x00005e0026267625ULL, 0x000fe200078e0058ULL,
0x00000037242a7210ULL, 0x000fc60007f3e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2fULL,
0x0000003726267210ULL, 0x000fe20007f7e0ffULL, 0x000000013c247824ULL, 0x100fe400078e0228ULL,
0x000000013d287824ULL, 0x000fe200078e0228ULL, 0x000000002900720cULL, 0x080fe20003f46070ULL,
0x000000ffff2b7224ULL, 0x000fe200008e0625ULL, 0x000000003800720cULL, 0x000fe20003f26070ULL,
0x00005e0024247625ULL, 0x000fe200078e0058ULL, 0x000000003a00720cULL, 0x000fc60003f86070ULL,
0x00005e0028287625ULL, 0x000fe200078e0058ULL, 0x0000003724247210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e0627ULL, 0x000000003900720cULL, 0x000fe20003f66070ULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0x0000003728287210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a467faeULL, 0x0003e8000d101c46ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x0000000026477faeULL, 0x0003ea000c901c46ULL,
0x0000000024487faeULL, 0x0003e8000d901c46ULL, 0x0000000028497faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff607f8cULL, 0x000ea8000c80043fULL, 0x0106ac00ff007984ULL, 0x000ee20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010628002f247f8cULL, 0x002fe2000c80043fULL, 0x8000000000ff7812ULL, 0x008fc60007844841ULL,
0x01062c002f267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01062c002f267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010080004a267984ULL, 0x000e680000000800ULL, 0x010280004a277984ULL, 0x0007220000000800ULL,
0x000000312600720bULL, 0x002fe20003f3d000ULL, 0x00010d627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00287812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff727424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000010200780cULL, 0x000fe40003f65270ULL,
0x000000312600720bULL, 0x000fe20003f34000ULL, 0x00010d227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000002631247209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x8000002431257221ULL, 0x000fe20000010000ULL,
0x010480244a00b388ULL, 0x0003e20000000800ULL, 0x0000000028ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca000001162eULL,
0x0000002500257308ULL, 0x000ee40000000800ULL, 0x0000002532327220ULL, 0x008fe20000410000ULL,
0x00010cb27f007947ULL, 0x000fea000b800000ULL, 0x00001f0025007589ULL, 0x0022e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x00010c027f007947ULL, 0x000fea000b800000ULL, 0x00001f3e25007589ULL, 0x0004e400000e0000ULL,
0x0000002631317209ULL, 0x000fe20007810000ULL, 0x0000000006067220ULL, 0x08cfe20000410000ULL,
0x00000001ff727807ULL, 0x000fe20000800000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x000000000a0a7220ULL, 0x080fe20000410000ULL, 0x8000003126261221ULL, 0x000fe20000010000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x000000000f0f7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000002600351308ULL, 0x000ea20000000800ULL,
0x0000000017177220ULL, 0x080fe20000410000ULL, 0x000000001a1a7220ULL, 0x080fe20000410000ULL,
0x000000001b1b7220ULL, 0x080fe20000410000ULL, 0x000000001e1e7220ULL, 0x080fe20000410000ULL,
0x000000001f1f7220ULL, 0x080fe20000410000ULL, 0x0000000022227220ULL, 0x080fe20000410000ULL,
0x0000000023237220ULL, 0x000fe20000410000ULL, 0x0000002735271220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003227327221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ee40000000800ULL, 0x8000000000ff7812ULL, 0x008fc40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x000724000021f000ULL,
0x3fa0000000007823ULL, 0x008fe200000100ffULL, 0x000000240000735dULL, 0x010fe40003800000ULL,
0x0106ac00ff247984ULL, 0x000ee40000000800ULL, 0x8000000024ff7812ULL, 0x008fe40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000035ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff5b7819ULL, 0x000fc4000001162eULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x000109b27f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a657589ULL, 0x00072400000e0000ULL,
0x000109f27f007947ULL, 0x000fea000b800000ULL, 0x00001f3e5a647589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x008fe200078e003fULL,
0x00004d00005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000116e000007944ULL, 0x016fea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x008fe200078e0040ULL,
0x00004d60005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0001168000007944ULL, 0x016fea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004c58783bULL, 0x00ae620000004200ULL,
0x0000991072727816ULL, 0x000fc600000000ffULL, 0x000000004d5c783bULL, 0x000fe20000004200ULL,
0x000000ff7200720cULL, 0x000fc60003f25270ULL, 0x000000004e24783bULL, 0x000ee80000004200ULL,
0x000000004f28783bULL, 0x000f620000004200ULL, 0x00000018ff707819ULL, 0x002fe20000011458ULL,
0x0000010058747824ULL, 0x040fe200078e00ffULL, 0x0000888058737816ULL, 0x040fe200000000ffULL,
0x0001000058587824ULL, 0x000fe200078e00ffULL, 0x0000888059757816ULL, 0x000fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe20000011459ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff587819ULL, 0x000fc40000011458ULL, 0x00000018ff6e7819ULL, 0x000fe4000001145aULL,
0x00000018ff6f7819ULL, 0x000fe4000001145bULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000005800767306ULL, 0x0003220000200c00ULL, 0x00000018ff687819ULL, 0x008fe40000011425ULL,
0x00000018ff697819ULL, 0x000fe40000011424ULL, 0x00000018ff6c7819ULL, 0x000fc4000001145cULL,
0x00000018ff6d7819ULL, 0x000fe2000001145dULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000000ffff587224ULL, 0x002fe200078e0075ULL, 0x00000018ff6a7819ULL, 0x000fe2000001145eULL,
0x0000010059757824ULL, 0x040fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001145fULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011426ULL,
0x0000005800777306ULL, 0x0003e20000200c00ULL, 0x00000018ff757819ULL, 0x000fc40000011475ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000541076707816ULL, 0x010fe40000000070ULL,
0x00000018ff677819ULL, 0x000fe20000011427ULL, 0x0000005900787306ULL, 0x0007220000200c00ULL,
0x000088805a587816ULL, 0x002fe400000000ffULL, 0x00000018ff637819ULL, 0x020fe40000011429ULL,
0x00000018ff627819ULL, 0x000fc40000011428ULL, 0x00000018ff417819ULL, 0x000fe2000001142bULL,
0x0000005800797306ULL, 0x0003e20000200c00ULL, 0x000001005a597824ULL, 0x048fe200078e00ffULL,
0x00000018ff007819ULL, 0x004fe2000001142aULL, 0x000100005a5a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000088805b587816ULL, 0x002fe400000000ffULL,
0x0000541078717816ULL, 0x010fca0000000071ULL, 0x00000059007a7306ULL, 0x0002b00000200c00ULL,
0x00000058007b7306ULL, 0x0007e20000200c00ULL, 0x000001005b597824ULL, 0x042fe400078e00ffULL,
0x000100005b5b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005a007c7306ULL, 0x000fe20000200c00ULL,
0x000088805c587816ULL, 0x008fe400000000ffULL, 0x00005410797a7816ULL, 0x004fca000000007aULL,
0x00000059007d7306ULL, 0x0002b00000200c00ULL, 0x00000058007f7306ULL, 0x0007e20000200c00ULL,
0x000001005c597824ULL, 0x042fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005b007e7306ULL, 0x000fe20000200c00ULL,
0x000088805d587816ULL, 0x008fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x000054107b7b7816ULL, 0x004fc6000000007dULL, 0x0000005900807306ULL, 0x0002b00000200c00ULL,
0x0000005800817306ULL, 0x0007e20000200c00ULL, 0x000001005d597824ULL, 0x042fe400078e00ffULL,
0x000100005d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000088805e587816ULL, 0x008fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000054107f807816ULL, 0x004fc60000000080ULL,
0x0000005900827306ULL, 0x0004f00000200c00ULL, 0x0000005800837306ULL, 0x0009e20000200c00ULL,
0x000001005e597824ULL, 0x044fe200078e00ffULL, 0x0000541073747816ULL, 0x002fe20000000074ULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000007500757306ULL, 0x000e620000200c00ULL, 0x000088805f587816ULL, 0x010fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000541081817816ULL, 0x008fc60000000082ULL,
0x0000005900847306ULL, 0x0004f00000200c00ULL, 0x0000005800857306ULL, 0x0009e20000200c00ULL,
0x000001005f597824ULL, 0x004fe200078e00ffULL, 0x0000541077757816ULL, 0x002fe20000000075ULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000888024587816ULL, 0x010fe400000000ffULL, 0x0000541083847816ULL, 0x008fca0000000084ULL,
0x0000005900867306ULL, 0x0004f00000200c00ULL, 0x0000005800877306ULL, 0x0009e20000200c00ULL,
0x0000010024597824ULL, 0x004fe200078e00ffULL, 0x000054107c6e7816ULL, 0x002fe2000000006eULL,
0x0001000024247824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x0000888025587816ULL, 0x010fe400000000ffULL, 0x0000541085857816ULL, 0x008fca0000000086ULL,
0x0000005900887306ULL, 0x0004f00000200c00ULL, 0x0000005800897306ULL, 0x0009e20000200c00ULL,
0x0000010025597824ULL, 0x044fe200078e00ffULL, 0x000054107e6f7816ULL, 0x002fe2000000006fULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x00000024008a7306ULL, 0x0003e20000200c00ULL,
0x0000a80050587811ULL, 0x010fe400078e20ffULL, 0x0000541087887816ULL, 0x008fca0000000088ULL,
0x00000059008b7306ULL, 0x0004e20000200c00ULL, 0x0000888026247816ULL, 0x002fce00000000ffULL,
0x00000025008c7306ULL, 0x0003e20000200c00ULL, 0x000000005858783bULL, 0x004eae0000000200ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000010026257824ULL, 0x042fe200078e00ffULL,
0x0000541089897816ULL, 0x008fe2000000008bULL, 0x0001000026267824ULL, 0x000fc600078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x00000018ff267819ULL, 0x000fce0000011426ULL, 0x00000025008e7306ULL, 0x0007f00000200c00ULL,
0x00000024008d7306ULL, 0x0009620000200c00ULL, 0x0000010027257824ULL, 0x008fe200078e00ffULL,
0x000054105c6c7816ULL, 0x002fc8000000006cULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x0000006558589232ULL, 0x084fe20000000000ULL,
0x0000888027247816ULL, 0x050fe200000000ffULL, 0x000000655a5a9232ULL, 0x000fe20000000000ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000006459599232ULL, 0x080fe40000000000ULL,
0x000000645b5b9232ULL, 0x000fe20000000000ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x000054108d8e7816ULL, 0x020fc6000000008eULL,
0x000000745804723cULL, 0x040fe40000001804ULL, 0x0000006b006b7306ULL, 0x000fea0000200c00ULL,
0x0000010029747824ULL, 0x000fe200078e00ffULL, 0x000000705808723cULL, 0x000fe40000001808ULL,
0x0000005d005d7306ULL, 0x000e640000200c00ULL, 0x00000018ff747819ULL, 0x000fc60000011474ULL,
0x0000888029717816ULL, 0x040fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x0000006e5810723cULL, 0x000fe20000001810ULL, 0x0000005e005e7306ULL, 0x000ea60000200c00ULL,
0x00000018ff297819ULL, 0x000fc80000011429ULL, 0x0000007a580c723cULL, 0x000fe2000000180cULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x000054105d6d7816ULL, 0x002fcc000000006dULL,
0x000000805814723cULL, 0x000fe20000001814ULL, 0x00000024008f7306ULL, 0x0003e20000200c00ULL,
0x000054105e6a7816ULL, 0x004fcc000000006aULL, 0x0000006c5818723cULL, 0x000fe20000001818ULL,
0x0000002500907306ULL, 0x0005220000200c00ULL, 0x0000a80051247811ULL, 0x002fe400078e20ffULL,
0x000054105f6b7816ULL, 0x008fc8000000006bULL, 0x00000084581c723cULL, 0x000fe2000000181cULL,
0x0000002600727306ULL, 0x0003e20000200c00ULL, 0x0000888028257816ULL, 0x004fcc00000000ffULL,
0x0000006a5820723cULL, 0x000fe20000001820ULL, 0x0000002700917306ULL, 0x000fe20000200c00ULL,
0x0000010028267824ULL, 0x042fe200078e00ffULL, 0x000054108f8f7816ULL, 0x010fe20000000090ULL,
0x0001000028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011426ULL,
0x0000002500737306ULL, 0x0003e20000200c00ULL, 0x00000018ff287819ULL, 0x000fce0000011428ULL,
0x00000029005c7306ULL, 0x0005e20000200c00ULL, 0x000000002424783bULL, 0x002e6e0000000200ULL,
0x00000028006e7306ULL, 0x0007e20000200c00ULL, 0x000001002a297824ULL, 0x004fca00078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000088802a287816ULL, 0x048fe200000000ffULL, 0x000100002a2a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000028005d7306ULL, 0x0007f00000200c00ULL,
0x0000002900587306ULL, 0x0009620000200c00ULL, 0x000088802b287816ULL, 0x008fc400000000ffULL,
0x000054108a8a7816ULL, 0x004fca0000000069ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x000001002b297824ULL, 0x050fe200078e00ffULL, 0x0000006524249232ULL, 0x082fe20000000000ULL,
0x000100002b2b7824ULL, 0x000fe200078e00ffULL, 0x0000006526269232ULL, 0x000fe40000000000ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000006425259232ULL, 0x080fe20000000000ULL,
0x00000018ff5e7819ULL, 0x000fe2000001142bULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000006427279232ULL, 0x000fe20000000000ULL, 0x000054105d587816ULL, 0x020fc40000000058ULL,
0x000054108c8b7816ULL, 0x004fc80000000068ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000000882404723cULL, 0x040fee0000001804ULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x0000008a2408723cULL, 0x040fee0000001808ULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x0000008e240c723cULL, 0x000fee000000180cULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x000054106e627816ULL, 0x002fce0000000062ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x000054105c637816ULL, 0x004fce0000000063ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000541073707816ULL, 0x008fe20000000070ULL, 0x000000622418723cULL, 0x000fec0000001818ULL,
0x0000002800597306ULL, 0x0005f00000200c00ULL, 0x00000029005b7306ULL, 0x0007220000200c00ULL,
0x0000541072287816ULL, 0x004fc40000000066ULL, 0x0000541071717816ULL, 0x002fca0000000074ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541091297816ULL, 0x008fe20000000067ULL,
0x000000702414723cULL, 0x000fec0000001814ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000541059597816ULL, 0x010fce000000005bULL, 0x0000002a005a7306ULL, 0x0002a20000200c00ULL,
0x00000058241c723cULL, 0x040fee000000181cULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000000282428723cULL, 0x002fe20000001810ULL, 0x000054105a5a7816ULL, 0x004fc40000000000ULL,
0x000054105e5b7816ULL, 0x008fce0000000041ULL, 0x0000005a2424723cULL, 0x000fe20000001820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff107f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000127305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000802c007811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff417819ULL, 0x000fc4000001162eULL, 0x0000000003107217ULL, 0x000fe20007800000ULL,
0x0000620030237a24ULL, 0x000fc800078e0200ULL, 0x0000000110107824ULL, 0x000fe400078e0a00ULL,
0x0000000136117824ULL, 0x100fe400078e0223ULL, 0x000000013b127824ULL, 0x100fe200078e0223ULL,
0x0000002010007807ULL, 0x000fe20000000000ULL, 0x000000013c207824ULL, 0x000fe400078e0223ULL,
0x00005e0011107625ULL, 0x000fe200078e0058ULL, 0x000000002f007217ULL, 0x000fc60007800000ULL,
0x00005e0012127625ULL, 0x000fe200078e0058ULL, 0x0000003710227210ULL, 0x000fc60007f5e0ffULL,
0x00005e0020207625ULL, 0x000fe200078e0058ULL, 0x0000003712127210ULL, 0x000fc60007f9e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a2fULL, 0x0000003720207210ULL, 0x000fe20007fbe0ffULL,
0x000000013d107824ULL, 0x000fe400078e0223ULL, 0x000000ffff237224ULL, 0x000fe200010e0611ULL,
0x000000004100720cULL, 0x000fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fe200078e0058ULL,
0x000000003800720cULL, 0x000fc60003f66070ULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x000000003900720cULL, 0x080fe20003f86070ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x000000003a00720cULL, 0x000fe40003fa6070ULL, 0x0000003710107210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022527faeULL, 0x0003e4000d101c46ULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x0000000012537faeULL, 0x0003e8000d901c46ULL,
0x0000000020547faeULL, 0x0003e8000e101c46ULL, 0x0000000010557faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff107f8cULL, 0x002fe8000c80043fULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007844861ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e0011ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000107305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000100000735dULL, 0x004fe40003800000ULL, 0x0106b400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007844861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000035ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff5b7819ULL, 0x000fe4000001162eULL,
0x00005410005a7816ULL, 0x000fe20000000000ULL, 0x0000f5927f007947ULL, 0x000fea000b800000ULL,
0x00001f5b5a647589ULL, 0x0002a400000e0000ULL, 0x0000f5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f3e5a637589ULL, 0x00072400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x002fe200078e003fULL, 0x000061f0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000101f000007944ULL, 0x01cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x002fe200078e0040ULL, 0x00006250005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0001019000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005658783bULL, 0x00ae680000004200ULL, 0x00000000575c783bULL, 0x000fe80000004200ULL,
0x000000004420783bULL, 0x000ee80000004200ULL, 0x000000004510783bULL, 0x000f620000004200ULL,
0x00000018ff007819ULL, 0x006fe20000011458ULL, 0x0000010058707824ULL, 0x040fe200078e00ffULL,
0x00008880586f7816ULL, 0x040fe200000000ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x0000888059717816ULL, 0x000fe200000000ffULL, 0x0000000000727306ULL, 0x0003e20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc4000001145aULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000010021877824ULL, 0x008fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001145bULL,
0x00000018ff677819ULL, 0x000fe20000011421ULL, 0x0000005800737306ULL, 0x0004e20000200c00ULL,
0x00000018ff007819ULL, 0x002fe40000011459ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff687819ULL, 0x000fc40000011420ULL, 0x00000018ff6b7819ULL, 0x000fe2000001145cULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000ffff587224ULL, 0x004fe200078e0071ULL,
0x00000018ff6c7819ULL, 0x000fe2000001145dULL, 0x0000010059717824ULL, 0x040fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011422ULL, 0x0001000059597824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe4000001145eULL, 0x0000005800747306ULL, 0x0003e20000200c00ULL,
0x00000018ff717819ULL, 0x000fc40000011471ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff6a7819ULL, 0x000fe4000001145fULL, 0x00000018ff667819ULL, 0x000fe20000011423ULL,
0x0000005900767306ULL, 0x0005e20000200c00ULL, 0x000088805a587816ULL, 0x002fe400000000ffULL,
0x0000541073727816ULL, 0x008fe40000000072ULL, 0x00000018ff627819ULL, 0x020fc40000011411ULL,
0x00000018ff617819ULL, 0x000fe20000011410ULL, 0x0000005800777306ULL, 0x0003e20000200c00ULL,
0x000001005a597824ULL, 0x044fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011413ULL,
0x000100005a5a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000088805b587816ULL, 0x002fce00000000ffULL,
0x0000005900787306ULL, 0x0002f00000200c00ULL, 0x0000005800797306ULL, 0x000be20000200c00ULL,
0x000001005b597824ULL, 0x002fe200078e00ffULL, 0x000054106f707816ULL, 0x004fe20000000070ULL,
0x000100005b5b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005a007a7306ULL, 0x0003e20000200c00ULL, 0x000088805c587816ULL, 0x020fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x0000541077787816ULL, 0x008fc60000000078ULL,
0x00000059007b7306ULL, 0x0004e20000200c00ULL, 0x00008880215a7816ULL, 0x042fe200000000ffULL,
0x0001000021217824ULL, 0x000fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x00000058007d7306ULL, 0x0003e20000200c00ULL, 0x000001005c597824ULL, 0x044fe400078e00ffULL,
0x000100005c5c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005b007c7306ULL, 0x000fe20000200c00ULL, 0x000088805d587816ULL, 0x002fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000541079797816ULL, 0x008fc6000000007bULL,
0x00000059007e7306ULL, 0x0002b00000200c00ULL, 0x00000058007f7306ULL, 0x0007e20000200c00ULL,
0x000001005d597824ULL, 0x042fe400078e00ffULL, 0x000100005d5d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000021008a7306ULL, 0x0003e20000200c00ULL,
0x000088805e587816ULL, 0x008fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x000054107d7e7816ULL, 0x004fc6000000007eULL, 0x0000005900807306ULL, 0x0004e20000200c00ULL,
0x0000010022217824ULL, 0x002fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000005800817306ULL, 0x0003e20000200c00ULL, 0x000001005e597824ULL, 0x044fe400078e00ffULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000088805f587816ULL, 0x002fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x000054107f7f7816ULL, 0x008fc60000000080ULL,
0x0000005900827306ULL, 0x0002f00000200c00ULL, 0x0000005800837306ULL, 0x000be20000200c00ULL,
0x000001005f597824ULL, 0x042fe200078e00ffULL, 0x0000541074717816ULL, 0x004fe20000000071ULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000000000757306ULL, 0x0002a20000200c00ULL, 0x0000888020587816ULL, 0x020fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000541081827816ULL, 0x008fc60000000082ULL,
0x0000005900847306ULL, 0x0007620000200c00ULL, 0x00000018ff007819ULL, 0x002fce0000011412ULL,
0x0000005800857306ULL, 0x0003e20000200c00ULL, 0x0000010020597824ULL, 0x008fe200078e00ffULL,
0x0000541076737816ULL, 0x004fe20000000075ULL, 0x0001000020207824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x00000021008c7306ULL, 0x0005e20000200c00ULL, 0x0000a80043587811ULL, 0x002fe400078e20ffULL,
0x0000541083837816ULL, 0x020fca0000000084ULL, 0x0000005900867306ULL, 0x0002e20000200c00ULL,
0x0000010023217824ULL, 0x004fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000887306ULL, 0x0005e20000200c00ULL, 0x000000ffff597224ULL, 0x002fce00078e005aULL,
0x0000005900897306ULL, 0x0003e20000200c00ULL, 0x0000888022207816ULL, 0x044fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000541085867816ULL, 0x008fc80000000086ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000005858783bULL, 0x002e6e0000000200ULL, 0x0000006c006c7306ULL, 0x000ff00000200c00ULL,
0x0000005c005c7306ULL, 0x000eb00000200c00ULL, 0x0000005d005d7306ULL, 0x000ef00000200c00ULL,
0x00000020008b7306ULL, 0x000b220000200c00ULL, 0x000054105c5c7816ULL, 0x004fce000000006bULL,
0x00000021008f7306ULL, 0x0005e20000200c00ULL, 0x0000888023207816ULL, 0x060fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x0000006458589232ULL, 0x082fe20000000000ULL,
0x000054105d5d7816ULL, 0x008fe2000000006cULL, 0x000000645a5a9232ULL, 0x000fe40000000000ULL,
0x0000006359599232ULL, 0x090fe20000000000ULL, 0x00000020008d7306ULL, 0x0002e20000200c00ULL,
0x000000635b5b9232ULL, 0x000fe20000000000ULL, 0x00000018ff237819ULL, 0x000fc40000011423ULL,
0x0000888010217816ULL, 0x004fe400000000ffULL, 0x000054108b8c7816ULL, 0x000fe4000000008cULL,
0x00000022008e7306ULL, 0x0005e20000200c00ULL, 0x0000a80042207811ULL, 0x002fe200078e20ffULL,
0x000000705804723cULL, 0x040fec0000001804ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x0000010010227824ULL, 0x044fe200078e00ffULL, 0x000000725808723cULL, 0x000fe20000001808ULL,
0x0000888011717816ULL, 0x000fe200000000ffULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x000054108d8d7816ULL, 0x008fc4000000008fULL, 0x00000018ff6f7819ULL, 0x000fe20000011422ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000010011727824ULL, 0x040fe200078e00ffULL,
0x0000005c5818723cULL, 0x040fe20000001818ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x00000078580c723cULL, 0x000fe2000000180cULL, 0x000054107a7a7816ULL, 0x002fca000000006dULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054107c7b7816ULL, 0x004fe2000000006eULL,
0x0000007e5814723cULL, 0x040fec0000001814ULL, 0x0000005e005e7306ULL, 0x000e640000200c00ULL,
0x0000007a5828723cULL, 0x040fec0000001828ULL, 0x0000005f005f7306ULL, 0x000ea40000200c00ULL,
0x00000082581c723cULL, 0x000fec000000181cULL, 0x0000002300907306ULL, 0x000fe20000200c00ULL,
0x000054105e5e7816ULL, 0x002fce0000000069ULL, 0x0000002100707306ULL, 0x0003e20000200c00ULL,
0x000054105f5f7816ULL, 0x004fce000000006aULL, 0x00000011005c7306ULL, 0x0005e20000200c00ULL,
0x000000002020783bULL, 0x002e620000000200ULL, 0x0000005e5824723cULL, 0x000fec0000001824ULL,
0x00000010006d7306ULL, 0x0007e20000200c00ULL, 0x0000010012117824ULL, 0x004fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000888012107816ULL, 0x048fe200000000ffULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x00000010005d7306ULL, 0x0005f00000200c00ULL,
0x0000001100587306ULL, 0x0007220000200c00ULL, 0x0000888013107816ULL, 0x004fce00000000ffULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000010013117824ULL, 0x048fe200078e00ffULL,
0x0000006420209232ULL, 0x082fe20000000000ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000006422229232ULL, 0x000fe40000000000ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006321219232ULL, 0x080fe20000000000ULL, 0x00000018ff5e7819ULL, 0x000fe20000011413ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x0000006323239232ULL, 0x000fe20000000000ULL,
0x000054105d587816ULL, 0x010fcc0000000058ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000008c200c723cULL, 0x000fee000000180cULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541088687816ULL, 0x002fce0000000068ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000054108a697816ULL, 0x004fce0000000067ULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x000000682008723cULL, 0x000fee0000001808ULL, 0x0000006f006f7306ULL, 0x000eb00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541089877816ULL, 0x002fce0000000087ULL,
0x0000007200727306ULL, 0x000e620000200c00ULL, 0x0000541070707816ULL, 0x004fe2000000006fULL,
0x000000862004723cULL, 0x000fec0000001804ULL, 0x0000001000597306ULL, 0x0005f00000200c00ULL,
0x00000011005b7306ULL, 0x0007220000200c00ULL, 0x000054108e107816ULL, 0x004fc40000000065ULL,
0x0000541071717816ULL, 0x002fca0000000072ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x0000541090117816ULL, 0x008fe20000000066ULL, 0x000000702014723cULL, 0x000fec0000001814ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541059597816ULL, 0x010fce000000005bULL,
0x00000012005a7306ULL, 0x0002a20000200c00ULL, 0x00000058201c723cULL, 0x040fee000000181cULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x000000102010723cULL, 0x002fee0000001828ULL,
0x000054106d287816ULL, 0x000fc40000000061ULL, 0x000054105c297816ULL, 0x000fe40000000062ULL,
0x000054105a5a7816ULL, 0x004fe40000000000ULL, 0x000054105e5b7816ULL, 0x008fc60000000060ULL,
0x000000282018723cULL, 0x040ff00000001818ULL, 0x0000005a2020723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff247f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000802c007811ULL, 0x000fe200078e40ffULL, 0x01069000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff247224ULL, 0x002fc400078e0025ULL, 0x000000000300720cULL, 0x000fda0003f24070ULL,
0x00005fa000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824824ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000257305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007824824ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000a02c007811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff297819ULL, 0x000fe4000001162eULL,
0x0000000003247217ULL, 0x000fe20007800000ULL, 0x0000620030287a24ULL, 0x000fc800078e0200ULL,
0x0000000124247824ULL, 0x000fe400078e0a00ULL, 0x0000000136257824ULL, 0x100fe400078e0228ULL,
0x000000013b267824ULL, 0x000fe200078e0228ULL, 0x0000002024007807ULL, 0x000fe20000000000ULL,
0x00005e0025247625ULL, 0x000fc600078e0058ULL, 0x000000002f007217ULL, 0x000fe20007800000ULL,
0x00005e0026267625ULL, 0x000fe200078e0058ULL, 0x00000037242a7210ULL, 0x000fc60007f3e0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a2fULL, 0x0000003726267210ULL, 0x000fe20007f7e0ffULL,
0x000000013c247824ULL, 0x100fe400078e0228ULL, 0x000000013d287824ULL, 0x000fe200078e0228ULL,
0x000000002900720cULL, 0x080fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200008e0625ULL,
0x000000003800720cULL, 0x000fe20003f26070ULL, 0x00005e0024247625ULL, 0x000fe200078e0058ULL,
0x000000003a00720cULL, 0x000fc60003f86070ULL, 0x00005e0028287625ULL, 0x000fe200078e0058ULL,
0x0000003724247210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff277224ULL, 0x000fe200018e0627ULL,
0x000000003900720cULL, 0x000fe20003f66070ULL, 0x000000ffff257224ULL, 0x000fe200028e0625ULL,
0x0000003728287210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a467faeULL, 0x0003e8000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000000026477faeULL, 0x0003ea000c901c46ULL, 0x0000000024487faeULL, 0x0003e8000d901c46ULL,
0x0000000028497faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff607f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff007984ULL, 0x000ee20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010648002f247f8cULL, 0x002fe2000c80043fULL,
0x8000000000ff7812ULL, 0x008fc60007844841ULL, 0x01064c002f267984ULL, 0x000e640000000800ULL,
0x8000000026ff7812ULL, 0x002fe40007824825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000267305ULL, 0x0002e4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000260000735dULL, 0x008fe40003800000ULL,
0x01064c002f267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x010100004a267984ULL, 0x000e680000000800ULL,
0x010300004a277984ULL, 0x0007220000000800ULL, 0x000000312600720bULL, 0x002fe20003f3d000ULL,
0x0000e0927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x008fc800008e0100ULL,
0x0000ffff00287812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff727424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000020200780cULL, 0x000fe40003f65270ULL, 0x000000312600720bULL, 0x000fe20003f34000ULL,
0x0000e0527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000007806ULL, 0x000fe400008e0100ULL,
0x0000002631247209ULL, 0x000fe40007810000ULL, 0x0000ffff00007812ULL, 0x000fc600078e3cffULL,
0x8000002431257221ULL, 0x000fe20000010000ULL, 0x010500244a00b388ULL, 0x0003e20000000800ULL,
0x0000000028ff7212ULL, 0x000fe4000782c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fe20000410000ULL,
0x00000002ff007819ULL, 0x000fca000001162eULL, 0x0000002500257308ULL, 0x000ee40000000800ULL,
0x0000002532327220ULL, 0x008fe20000410000ULL, 0x0000dfe27f007947ULL, 0x000fea000b800000ULL,
0x00001f0025007589ULL, 0x0022e400000e0000ULL, 0x0000000004047220ULL, 0x08cfe20000410000ULL,
0x0000000005057220ULL, 0x080fe20000410000ULL, 0x0000000008087220ULL, 0x080fe20000410000ULL,
0x0000000009097220ULL, 0x080fe20000410000ULL, 0x000000000c0c7220ULL, 0x080fe20000410000ULL,
0x000000000d0d7220ULL, 0x080fe20000410000ULL, 0x0000000010107220ULL, 0x080fe20000410000ULL,
0x0000000011117220ULL, 0x080fe20000410000ULL, 0x0000000014147220ULL, 0x080fe20000410000ULL,
0x0000000015157220ULL, 0x080fe20000410000ULL, 0x0000000018187220ULL, 0x080fe20000410000ULL,
0x0000000019197220ULL, 0x080fe20000410000ULL, 0x000000001c1c7220ULL, 0x080fe20000410000ULL,
0x000000001d1d7220ULL, 0x080fe20000410000ULL, 0x0000000020207220ULL, 0x080fe20000410000ULL,
0x0000000021217220ULL, 0x000fe20000410000ULL, 0x0000df327f007947ULL, 0x000fea000b800000ULL,
0x00001f3e25007589ULL, 0x0004e400000e0000ULL, 0x0000002631317209ULL, 0x000fe20007810000ULL,
0x0000000006067220ULL, 0x08cfe20000410000ULL, 0x00000001ff727807ULL, 0x000fe20000800000ULL,
0x0000000007077220ULL, 0x080fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x8000003126261221ULL, 0x000fe20000010000ULL, 0x000000000b0b7220ULL, 0x080fe20000410000ULL,
0x000000000e0e7220ULL, 0x080fe20000410000ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL, 0x0000000012127220ULL, 0x080fe20000410000ULL,
0x0000000013137220ULL, 0x080fe20000410000ULL, 0x0000000016167220ULL, 0x080fe20000410000ULL,
0x0000002600351308ULL, 0x000ea20000000800ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x0000002735271220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000003227327221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff007984ULL, 0x000ee40000000800ULL,
0x8000000000ff7812ULL, 0x008fc40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000247305ULL, 0x000724000021f000ULL, 0x3fa0000000007823ULL, 0x008fe200000100ffULL,
0x000000240000735dULL, 0x010fe40003800000ULL, 0x0106ac00ff247984ULL, 0x000ee40000000800ULL,
0x8000000024ff7812ULL, 0x008fe40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000035ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff5b7819ULL, 0x000fc4000001162eULL,
0x00005410005a7816ULL, 0x000fe20000000000ULL, 0x0000dce27f007947ULL, 0x000fea000b800000ULL,
0x00001f5b5a657589ULL, 0x00072400000e0000ULL, 0x0000dd227f007947ULL, 0x000fea000b800000ULL,
0x00001f3e5a647589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x008fe200078e003fULL, 0x00007cd0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000e71000007944ULL, 0x016fea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff5b7224ULL, 0x008fe200078e0040ULL, 0x00007d30005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000e6b000007944ULL, 0x016fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000004c58783bULL, 0x00ae620000004200ULL, 0x0000991072727816ULL, 0x000fc600000000ffULL,
0x000000004d5c783bULL, 0x000fe20000004200ULL, 0x000000ff7200720cULL, 0x000fc60003f25270ULL,
0x000000004e24783bULL, 0x000ee80000004200ULL, 0x000000004f28783bULL, 0x000f620000004200ULL,
0x00000018ff707819ULL, 0x002fe20000011458ULL, 0x0000010058747824ULL, 0x040fe200078e00ffULL,
0x0000888058737816ULL, 0x040fe200000000ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x0000888059757816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe20000011459ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff587819ULL, 0x000fc40000011458ULL,
0x00000018ff6e7819ULL, 0x000fe4000001145aULL, 0x00000018ff6f7819ULL, 0x000fe4000001145bULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000005800767306ULL, 0x0003220000200c00ULL,
0x00000018ff687819ULL, 0x008fe40000011425ULL, 0x00000018ff697819ULL, 0x000fe40000011424ULL,
0x00000018ff6c7819ULL, 0x000fc4000001145cULL, 0x00000018ff6d7819ULL, 0x000fe2000001145dULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000ffff587224ULL, 0x002fe200078e0075ULL,
0x00000018ff6a7819ULL, 0x000fe2000001145eULL, 0x0000010059757824ULL, 0x040fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001145fULL, 0x0001000059597824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011426ULL, 0x0000005800777306ULL, 0x0003e20000200c00ULL,
0x00000018ff757819ULL, 0x000fc40000011475ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000541076707816ULL, 0x010fe40000000070ULL, 0x00000018ff677819ULL, 0x000fe20000011427ULL,
0x0000005900787306ULL, 0x0007220000200c00ULL, 0x000088805a587816ULL, 0x002fe400000000ffULL,
0x00000018ff637819ULL, 0x020fe40000011429ULL, 0x00000018ff627819ULL, 0x000fc40000011428ULL,
0x00000018ff417819ULL, 0x000fe2000001142bULL, 0x0000005800797306ULL, 0x0003e20000200c00ULL,
0x000001005a597824ULL, 0x048fe200078e00ffULL, 0x00000018ff007819ULL, 0x004fe2000001142aULL,
0x000100005a5a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000088805b587816ULL, 0x002fe400000000ffULL, 0x0000541078717816ULL, 0x010fca0000000071ULL,
0x00000059007a7306ULL, 0x0002b00000200c00ULL, 0x00000058007b7306ULL, 0x0007e20000200c00ULL,
0x000001005b597824ULL, 0x042fe400078e00ffULL, 0x000100005b5b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005a007c7306ULL, 0x000fe20000200c00ULL, 0x000088805c587816ULL, 0x008fe400000000ffULL,
0x00005410797a7816ULL, 0x004fca000000007aULL, 0x00000059007d7306ULL, 0x0002b00000200c00ULL,
0x00000058007f7306ULL, 0x0007e20000200c00ULL, 0x000001005c597824ULL, 0x042fe400078e00ffULL,
0x000100005c5c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005b007e7306ULL, 0x000fe20000200c00ULL, 0x000088805d587816ULL, 0x008fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x000054107b7b7816ULL, 0x004fc6000000007dULL,
0x0000005900807306ULL, 0x0002b00000200c00ULL, 0x0000005800817306ULL, 0x0007e20000200c00ULL,
0x000001005d597824ULL, 0x042fe400078e00ffULL, 0x000100005d5d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x000088805e587816ULL, 0x008fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x000054107f807816ULL, 0x004fc60000000080ULL, 0x0000005900827306ULL, 0x0004f00000200c00ULL,
0x0000005800837306ULL, 0x0009e20000200c00ULL, 0x000001005e597824ULL, 0x044fe200078e00ffULL,
0x0000541073747816ULL, 0x002fe20000000074ULL, 0x000100005e5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000088805f587816ULL, 0x010fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000541081817816ULL, 0x008fc60000000082ULL, 0x0000005900847306ULL, 0x0004f00000200c00ULL,
0x0000005800857306ULL, 0x0009e20000200c00ULL, 0x000001005f597824ULL, 0x004fe200078e00ffULL,
0x0000541077757816ULL, 0x002fe20000000075ULL, 0x000100005f5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000888024587816ULL, 0x010fe400000000ffULL,
0x0000541083847816ULL, 0x008fca0000000084ULL, 0x0000005900867306ULL, 0x0004f00000200c00ULL,
0x0000005800877306ULL, 0x0009e20000200c00ULL, 0x0000010024597824ULL, 0x004fe200078e00ffULL,
0x000054107c6e7816ULL, 0x002fe2000000006eULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000888025587816ULL, 0x010fe400000000ffULL,
0x0000541085857816ULL, 0x008fca0000000086ULL, 0x0000005900887306ULL, 0x0004f00000200c00ULL,
0x0000005800897306ULL, 0x0009e20000200c00ULL, 0x0000010025597824ULL, 0x044fe200078e00ffULL,
0x000054107e6f7816ULL, 0x002fe2000000006fULL, 0x0001000025257824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x00000024008a7306ULL, 0x0003e20000200c00ULL, 0x0000b00050587811ULL, 0x010fe400078e20ffULL,
0x0000541087887816ULL, 0x008fca0000000088ULL, 0x00000059008b7306ULL, 0x0004e20000200c00ULL,
0x0000888026247816ULL, 0x002fce00000000ffULL, 0x00000025008c7306ULL, 0x0003e20000200c00ULL,
0x000000005858783bULL, 0x004eae0000000200ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000010026257824ULL, 0x042fe200078e00ffULL, 0x0000541089897816ULL, 0x008fe2000000008bULL,
0x0001000026267824ULL, 0x000fc600078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00000018ff267819ULL, 0x000fce0000011426ULL,
0x00000025008e7306ULL, 0x0007f00000200c00ULL, 0x00000024008d7306ULL, 0x0009620000200c00ULL,
0x0000010027257824ULL, 0x008fe200078e00ffULL, 0x000054105c6c7816ULL, 0x002fc8000000006cULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000006558589232ULL, 0x084fe20000000000ULL, 0x0000888027247816ULL, 0x050fe200000000ffULL,
0x000000655a5a9232ULL, 0x000fe20000000000ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000006459599232ULL, 0x080fe40000000000ULL, 0x000000645b5b9232ULL, 0x000fe20000000000ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff277819ULL, 0x000fc40000011427ULL,
0x000054108d8e7816ULL, 0x020fc6000000008eULL, 0x000000745804723cULL, 0x040fe40000001804ULL,
0x0000006b006b7306ULL, 0x000fea0000200c00ULL, 0x0000010029747824ULL, 0x000fe200078e00ffULL,
0x000000705808723cULL, 0x000fe40000001808ULL, 0x0000005d005d7306ULL, 0x000e640000200c00ULL,
0x00000018ff747819ULL, 0x000fc60000011474ULL, 0x0000888029717816ULL, 0x040fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x0000006e5810723cULL, 0x000fe20000001810ULL,
0x0000005e005e7306ULL, 0x000ea60000200c00ULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x0000007a580c723cULL, 0x000fe2000000180cULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x000054105d6d7816ULL, 0x002fcc000000006dULL, 0x000000805814723cULL, 0x000fe20000001814ULL,
0x00000024008f7306ULL, 0x0003e20000200c00ULL, 0x000054105e6a7816ULL, 0x004fcc000000006aULL,
0x0000006c5818723cULL, 0x000fe20000001818ULL, 0x0000002500907306ULL, 0x0005220000200c00ULL,
0x0000b00051247811ULL, 0x002fe400078e20ffULL, 0x000054105f6b7816ULL, 0x008fc8000000006bULL,
0x00000084581c723cULL, 0x000fe2000000181cULL, 0x0000002600727306ULL, 0x0003e20000200c00ULL,
0x0000888028257816ULL, 0x004fcc00000000ffULL, 0x0000006a5820723cULL, 0x000fe20000001820ULL,
0x0000002700917306ULL, 0x000fe20000200c00ULL, 0x0000010028267824ULL, 0x042fe200078e00ffULL,
0x000054108f8f7816ULL, 0x010fe20000000090ULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011426ULL, 0x0000002500737306ULL, 0x0003e20000200c00ULL,
0x00000018ff287819ULL, 0x000fce0000011428ULL, 0x00000029005c7306ULL, 0x0005e20000200c00ULL,
0x000000002424783bULL, 0x002e6e0000000200ULL, 0x00000028006e7306ULL, 0x0007e20000200c00ULL,
0x000001002a297824ULL, 0x004fca00078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x000088802a287816ULL, 0x048fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x00000028005d7306ULL, 0x0007f00000200c00ULL, 0x0000002900587306ULL, 0x0009620000200c00ULL,
0x000088802b287816ULL, 0x008fc400000000ffULL, 0x000054108a8a7816ULL, 0x004fca0000000069ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000001002b297824ULL, 0x050fe200078e00ffULL,
0x0000006524249232ULL, 0x082fe20000000000ULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000006526269232ULL, 0x000fe40000000000ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000006425259232ULL, 0x080fe20000000000ULL, 0x00000018ff5e7819ULL, 0x000fe2000001142bULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x0000006427279232ULL, 0x000fe20000000000ULL,
0x000054105d587816ULL, 0x020fc40000000058ULL, 0x000054108c8b7816ULL, 0x004fc80000000068ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000000882404723cULL, 0x040fee0000001804ULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x0000008a2408723cULL, 0x040fee0000001808ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x0000008e240c723cULL, 0x000fee000000180cULL,
0x0000007000707306ULL, 0x000ee20000200c00ULL, 0x000054106e627816ULL, 0x002fce0000000062ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000054105c637816ULL, 0x004fce0000000063ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541073707816ULL, 0x008fe20000000070ULL,
0x000000622418723cULL, 0x000fec0000001818ULL, 0x0000002800597306ULL, 0x0005f00000200c00ULL,
0x00000029005b7306ULL, 0x0007220000200c00ULL, 0x0000541072287816ULL, 0x004fc40000000066ULL,
0x0000541071717816ULL, 0x002fca0000000074ULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x0000541091297816ULL, 0x008fe20000000067ULL, 0x000000702414723cULL, 0x000fec0000001814ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541059597816ULL, 0x010fce000000005bULL,
0x0000002a005a7306ULL, 0x0002a20000200c00ULL, 0x00000058241c723cULL, 0x040fee000000181cULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x000000282428723cULL, 0x002fe20000001810ULL,
0x000054105a5a7816ULL, 0x004fc40000000000ULL, 0x000054105e5b7816ULL, 0x008fce0000000041ULL,
0x0000005a2424723cULL, 0x000fe20000001820ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff107f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000127305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c02c007811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff417819ULL, 0x000fc4000001162eULL,
0x0000000003107217ULL, 0x000fe20007800000ULL, 0x0000620030237a24ULL, 0x000fc800078e0200ULL,
0x0000000110107824ULL, 0x000fe400078e0a00ULL, 0x0000000136117824ULL, 0x100fe400078e0223ULL,
0x000000013b127824ULL, 0x100fe200078e0223ULL, 0x0000002010007807ULL, 0x000fe20000000000ULL,
0x000000013c207824ULL, 0x000fe400078e0223ULL, 0x00005e0011107625ULL, 0x000fe200078e0058ULL,
0x000000002f007217ULL, 0x000fc60007800000ULL, 0x00005e0012127625ULL, 0x000fe200078e0058ULL,
0x0000003710227210ULL, 0x000fc60007f5e0ffULL, 0x00005e0020207625ULL, 0x000fe200078e0058ULL,
0x0000003712127210ULL, 0x000fc60007f9e0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a2fULL,
0x0000003720207210ULL, 0x000fe20007fbe0ffULL, 0x000000013d107824ULL, 0x000fe400078e0223ULL,
0x000000ffff237224ULL, 0x000fe200010e0611ULL, 0x000000004100720cULL, 0x000fe20003f46070ULL,
0x00005e0010107625ULL, 0x000fe200078e0058ULL, 0x000000003800720cULL, 0x000fc60003f66070ULL,
0x000000ffff137224ULL, 0x000fe200020e0613ULL, 0x000000003900720cULL, 0x080fe20003f86070ULL,
0x000000ffff217224ULL, 0x000fe200028e0621ULL, 0x000000003a00720cULL, 0x000fe40003fa6070ULL,
0x0000003710107210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022527faeULL, 0x0003e4000d101c46ULL, 0x000000ffff117224ULL, 0x000fe400030e0611ULL,
0x0000000012537faeULL, 0x0003e8000d901c46ULL, 0x0000000020547faeULL, 0x0003e8000e101c46ULL,
0x0000000010557faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff107f8cULL, 0x002fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fc40007844861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0011ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007844861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000107305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x0106b400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007844861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000035ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff5b7819ULL, 0x000fe4000001162eULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x0000c8c27f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a647589ULL, 0x0002a400000e0000ULL,
0x0000c9027f007947ULL, 0x000fea000b800000ULL, 0x00001f3e5a637589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e003fULL,
0x000091c0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000d22000007944ULL, 0x01cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x002fe200078e0040ULL,
0x00009220005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000d1c000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005658783bULL, 0x00ae680000004200ULL,
0x00000000575c783bULL, 0x000fe80000004200ULL, 0x000000004420783bULL, 0x000ee80000004200ULL,
0x000000004510783bULL, 0x000f620000004200ULL, 0x00000018ff007819ULL, 0x006fe20000011458ULL,
0x0000010058707824ULL, 0x040fe200078e00ffULL, 0x00008880586f7816ULL, 0x040fe200000000ffULL,
0x0001000058587824ULL, 0x000fe200078e00ffULL, 0x0000888059717816ULL, 0x000fe200000000ffULL,
0x0000000000727306ULL, 0x0003e20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fc4000001145aULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000010021877824ULL, 0x008fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001145bULL, 0x00000018ff677819ULL, 0x000fe20000011421ULL,
0x0000005800737306ULL, 0x0004e20000200c00ULL, 0x00000018ff007819ULL, 0x002fe40000011459ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff687819ULL, 0x000fc40000011420ULL,
0x00000018ff6b7819ULL, 0x000fe2000001145cULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000000ffff587224ULL, 0x004fe200078e0071ULL, 0x00000018ff6c7819ULL, 0x000fe2000001145dULL,
0x0000010059717824ULL, 0x040fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011422ULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe4000001145eULL,
0x0000005800747306ULL, 0x0003e20000200c00ULL, 0x00000018ff717819ULL, 0x000fc40000011471ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff6a7819ULL, 0x000fe4000001145fULL,
0x00000018ff667819ULL, 0x000fe20000011423ULL, 0x0000005900767306ULL, 0x0005e20000200c00ULL,
0x000088805a587816ULL, 0x002fe400000000ffULL, 0x0000541073727816ULL, 0x008fe40000000072ULL,
0x00000018ff627819ULL, 0x020fc40000011411ULL, 0x00000018ff617819ULL, 0x000fe20000011410ULL,
0x0000005800777306ULL, 0x0003e20000200c00ULL, 0x000001005a597824ULL, 0x044fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011413ULL, 0x000100005a5a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe40000011487ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x000088805b587816ULL, 0x002fce00000000ffULL, 0x0000005900787306ULL, 0x0002f00000200c00ULL,
0x0000005800797306ULL, 0x000be20000200c00ULL, 0x000001005b597824ULL, 0x002fe200078e00ffULL,
0x000054106f707816ULL, 0x004fe20000000070ULL, 0x000100005b5b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005a007a7306ULL, 0x0003e20000200c00ULL,
0x000088805c587816ULL, 0x020fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x0000541077787816ULL, 0x008fc60000000078ULL, 0x00000059007b7306ULL, 0x0004e20000200c00ULL,
0x00008880215a7816ULL, 0x042fe200000000ffULL, 0x0001000021217824ULL, 0x000fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe20000011421ULL, 0x00000058007d7306ULL, 0x0003e20000200c00ULL,
0x000001005c597824ULL, 0x044fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000005b007c7306ULL, 0x000fe20000200c00ULL,
0x000088805d587816ULL, 0x002fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000541079797816ULL, 0x008fc6000000007bULL, 0x00000059007e7306ULL, 0x0002b00000200c00ULL,
0x00000058007f7306ULL, 0x0007e20000200c00ULL, 0x000001005d597824ULL, 0x042fe400078e00ffULL,
0x000100005d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000021008a7306ULL, 0x0003e20000200c00ULL, 0x000088805e587816ULL, 0x008fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000054107d7e7816ULL, 0x004fc6000000007eULL,
0x0000005900807306ULL, 0x0004e20000200c00ULL, 0x0000010022217824ULL, 0x002fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000005800817306ULL, 0x0003e20000200c00ULL,
0x000001005e597824ULL, 0x044fe400078e00ffULL, 0x000100005e5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x000088805f587816ULL, 0x002fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x000054107f7f7816ULL, 0x008fc60000000080ULL, 0x0000005900827306ULL, 0x0002f00000200c00ULL,
0x0000005800837306ULL, 0x000be20000200c00ULL, 0x000001005f597824ULL, 0x042fe200078e00ffULL,
0x0000541074717816ULL, 0x004fe20000000071ULL, 0x000100005f5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000000000757306ULL, 0x0002a20000200c00ULL,
0x0000888020587816ULL, 0x020fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000541081827816ULL, 0x008fc60000000082ULL, 0x0000005900847306ULL, 0x0007620000200c00ULL,
0x00000018ff007819ULL, 0x002fce0000011412ULL, 0x0000005800857306ULL, 0x0003e20000200c00ULL,
0x0000010020597824ULL, 0x008fe200078e00ffULL, 0x0000541076737816ULL, 0x004fe20000000075ULL,
0x0001000020207824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x00000021008c7306ULL, 0x0005e20000200c00ULL,
0x0000b00043587811ULL, 0x002fe400078e20ffULL, 0x0000541083837816ULL, 0x020fca0000000084ULL,
0x0000005900867306ULL, 0x0002e20000200c00ULL, 0x0000010023217824ULL, 0x004fca00078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000002000887306ULL, 0x0005e20000200c00ULL,
0x000000ffff597224ULL, 0x002fce00078e005aULL, 0x0000005900897306ULL, 0x0003e20000200c00ULL,
0x0000888022207816ULL, 0x044fe200000000ffULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x0000541085867816ULL, 0x008fc80000000086ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000005858783bULL, 0x002e6e0000000200ULL,
0x0000006c006c7306ULL, 0x000ff00000200c00ULL, 0x0000005c005c7306ULL, 0x000eb00000200c00ULL,
0x0000005d005d7306ULL, 0x000ef00000200c00ULL, 0x00000020008b7306ULL, 0x000b220000200c00ULL,
0x000054105c5c7816ULL, 0x004fce000000006bULL, 0x00000021008f7306ULL, 0x0005e20000200c00ULL,
0x0000888023207816ULL, 0x060fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x0000006458589232ULL, 0x082fe20000000000ULL, 0x000054105d5d7816ULL, 0x008fe2000000006cULL,
0x000000645a5a9232ULL, 0x000fe40000000000ULL, 0x0000006359599232ULL, 0x090fe20000000000ULL,
0x00000020008d7306ULL, 0x0002e20000200c00ULL, 0x000000635b5b9232ULL, 0x000fe20000000000ULL,
0x00000018ff237819ULL, 0x000fc40000011423ULL, 0x0000888010217816ULL, 0x004fe400000000ffULL,
0x000054108b8c7816ULL, 0x000fe4000000008cULL, 0x00000022008e7306ULL, 0x0005e20000200c00ULL,
0x0000b00042207811ULL, 0x002fe200078e20ffULL, 0x000000705804723cULL, 0x040fec0000001804ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x0000010010227824ULL, 0x044fe200078e00ffULL,
0x000000725808723cULL, 0x000fe20000001808ULL, 0x0000888011717816ULL, 0x000fe200000000ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x000054108d8d7816ULL, 0x008fc4000000008fULL,
0x00000018ff6f7819ULL, 0x000fe20000011422ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000010011727824ULL, 0x040fe200078e00ffULL, 0x0000005c5818723cULL, 0x040fe20000001818ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x00000078580c723cULL, 0x000fe2000000180cULL,
0x000054107a7a7816ULL, 0x002fca000000006dULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000054107c7b7816ULL, 0x004fe2000000006eULL, 0x0000007e5814723cULL, 0x040fec0000001814ULL,
0x0000005e005e7306ULL, 0x000e640000200c00ULL, 0x0000007a5828723cULL, 0x040fec0000001828ULL,
0x0000005f005f7306ULL, 0x000ea40000200c00ULL, 0x00000082581c723cULL, 0x000fec000000181cULL,
0x0000002300907306ULL, 0x000fe20000200c00ULL, 0x000054105e5e7816ULL, 0x002fce0000000069ULL,
0x0000002100707306ULL, 0x0003e20000200c00ULL, 0x000054105f5f7816ULL, 0x004fce000000006aULL,
0x00000011005c7306ULL, 0x0005e20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x0000005e5824723cULL, 0x000fec0000001824ULL, 0x00000010006d7306ULL, 0x0007e20000200c00ULL,
0x0000010012117824ULL, 0x004fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000888012107816ULL, 0x048fe200000000ffULL,
0x0001000012127824ULL, 0x000fca00078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000010005d7306ULL, 0x0005f00000200c00ULL, 0x0000001100587306ULL, 0x0007220000200c00ULL,
0x0000888013107816ULL, 0x004fce00000000ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000010013117824ULL, 0x048fe200078e00ffULL, 0x0000006420209232ULL, 0x082fe20000000000ULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x0000006422229232ULL, 0x000fe40000000000ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000006321219232ULL, 0x080fe20000000000ULL,
0x00000018ff5e7819ULL, 0x000fe20000011413ULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x0000006323239232ULL, 0x000fe20000000000ULL, 0x000054105d587816ULL, 0x010fcc0000000058ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000008c200c723cULL, 0x000fee000000180cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000541088687816ULL, 0x002fce0000000068ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000054108a697816ULL, 0x004fce0000000067ULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x000000682008723cULL, 0x000fee0000001808ULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541089877816ULL, 0x002fce0000000087ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541070707816ULL, 0x004fe2000000006fULL, 0x000000862004723cULL, 0x000fec0000001804ULL,
0x0000001000597306ULL, 0x0005f00000200c00ULL, 0x00000011005b7306ULL, 0x0007220000200c00ULL,
0x000054108e107816ULL, 0x004fc40000000065ULL, 0x0000541071717816ULL, 0x002fca0000000072ULL,
0x0000000000007306ULL, 0x000fe20000200c00ULL, 0x0000541090117816ULL, 0x008fe20000000066ULL,
0x000000702014723cULL, 0x000fec0000001814ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541059597816ULL, 0x010fce000000005bULL, 0x00000012005a7306ULL, 0x0002a20000200c00ULL,
0x00000058201c723cULL, 0x040fee000000181cULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000000102010723cULL, 0x002fee0000001828ULL, 0x000054106d287816ULL, 0x000fc40000000061ULL,
0x000054105c297816ULL, 0x000fe40000000062ULL, 0x000054105a5a7816ULL, 0x004fe40000000000ULL,
0x000054105e5b7816ULL, 0x008fc60000000060ULL, 0x000000282018723cULL, 0x040ff00000001818ULL,
0x0000005a2020723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c02c007811ULL, 0x000fe200078e40ffULL,
0x01069800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff247224ULL, 0x002fc400078e0025ULL,
0x000000000300720cULL, 0x000fda0003f24070ULL, 0x00002fd000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824824ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fe40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000257305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000250000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc40007824824ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000e02c007811ULL, 0x000fe200078e40ffULL, 0x00000100ff597424ULL, 0x000fe200078e00ffULL,
0x00000004ff587819ULL, 0x000fe4000001162eULL, 0x0000000003247217ULL, 0x000fe20007800000ULL,
0x0000620030267a24ULL, 0x000fc800078e0200ULL, 0x0000000124247824ULL, 0x000fe400078e0a00ULL,
0x0000000136257824ULL, 0x100fe400078e0226ULL, 0x000000013b277824ULL, 0x000fe200078e0226ULL,
0x0000002024007807ULL, 0x000fe20000000000ULL, 0x00005e0025247625ULL, 0x000fc600078e0059ULL,
0x000000002f007217ULL, 0x000fe20007800000ULL, 0x000000013c287824ULL, 0x100fe200078e0226ULL,
0x00000037242a7210ULL, 0x000fe20007f1e0ffULL, 0x000000013d297824ULL, 0x000fe400078e0226ULL,
0x0000000100007824ULL, 0x000fe400078e0a2fULL, 0x000000ffff2b7224ULL, 0x000fe400000e0625ULL,
0x00005e0027247625ULL, 0x000fe200078e0059ULL, 0x000000005800720cULL, 0x000fc40003f06070ULL,
0x000000003800720cULL, 0x080fe20003f26070ULL, 0x00005e0028267625ULL, 0x080fe200078e0059ULL,
0x000000003900720cULL, 0x080fe40003f46070ULL, 0x000000003a00720cULL, 0x000fe20003f66070ULL,
0x00005e0029287625ULL, 0x000fe200078e0059ULL, 0x0000003724247210ULL, 0x080fe40007f9e0ffULL,
0x0000003726267210ULL, 0x080fe40007fbe0ffULL, 0x0000003728287210ULL, 0x000fe20007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a467faeULL, 0x0003e2000c101c46ULL, 0x000000ffff277224ULL, 0x000fc400028e0627ULL,
0x000000ffff297224ULL, 0x000fe200030e0629ULL, 0x0000000024477faeULL, 0x0003e8000c901c46ULL,
0x0000000026487faeULL, 0x0003e8000d101c46ULL, 0x0000000028497faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b000ff467f8cULL, 0x002e68000c80043fULL, 0x0106ac00ff007984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010668002f247f8cULL, 0x000fe2000c80043fULL, 0x8000000000ff7812ULL, 0x004fc60007804841ULL,
0x01066c002f267984ULL, 0x000ea40000000800ULL, 0x8000000026ff7812ULL, 0x004fe40007824825ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000267305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000260000735dULL, 0x008fe40003800000ULL, 0x01066c002f267984ULL, 0x000ea40000000800ULL,
0x8000000026ff7812ULL, 0x004fc40007824825ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x010180004a267984ULL, 0x000ea80000000800ULL, 0x010380004a277984ULL, 0x0007220000000800ULL,
0x000000312600720bULL, 0x004fe20003f3d000ULL, 0x0000b3c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800008e0100ULL, 0x0000ffff00287812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff667424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000030200780cULL, 0x000fe40003f45270ULL,
0x000000312600720bULL, 0x000fe20003f34000ULL, 0x0000b3827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x000fe400008e0100ULL, 0x0000002631257209ULL, 0x000fe40007810000ULL,
0x0000ffff00007812ULL, 0x000fc600078e3cffULL, 0x8000002531247221ULL, 0x000fe20000010000ULL,
0x010580254a00a388ULL, 0x0005e20000000800ULL, 0x0000000028ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b24247820ULL, 0x000fe20000410000ULL, 0x00000002ff007819ULL, 0x000fca000001162eULL,
0x0000002400247308ULL, 0x000ee40000000800ULL, 0x0000002432327220ULL, 0x008fe20000410000ULL,
0x0000b3127f007947ULL, 0x000fea000b800000ULL, 0x00001f0024007589ULL, 0x0044e400000e0000ULL,
0x0000000004047220ULL, 0x08cfe20000410000ULL, 0x0000000005057220ULL, 0x080fe20000410000ULL,
0x0000000008087220ULL, 0x080fe20000410000ULL, 0x0000000009097220ULL, 0x080fe20000410000ULL,
0x000000000c0c7220ULL, 0x080fe20000410000ULL, 0x000000000d0d7220ULL, 0x080fe20000410000ULL,
0x0000000010107220ULL, 0x080fe20000410000ULL, 0x0000000011117220ULL, 0x080fe20000410000ULL,
0x0000000014147220ULL, 0x080fe20000410000ULL, 0x0000000015157220ULL, 0x080fe20000410000ULL,
0x0000000018187220ULL, 0x080fe20000410000ULL, 0x0000000019197220ULL, 0x080fe20000410000ULL,
0x000000001c1c7220ULL, 0x080fe20000410000ULL, 0x000000001d1d7220ULL, 0x080fe20000410000ULL,
0x0000000020207220ULL, 0x080fe20000410000ULL, 0x0000000021217220ULL, 0x000fe20000410000ULL,
0x0000b2627f007947ULL, 0x000fea000b800000ULL, 0x00001f3e24007589ULL, 0x0004e400000e0000ULL,
0x8000002526261221ULL, 0x100fe20000010000ULL, 0x00000001ff667807ULL, 0x000fe20000800000ULL,
0x0000000006067220ULL, 0x08cfe20000410000ULL, 0x0000000007077220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b26261820ULL, 0x000fe20000410000ULL, 0x000000000a0a7220ULL, 0x080fe20000410000ULL,
0x000000000b0b7220ULL, 0x080fe20000410000ULL, 0x000000000e0e7220ULL, 0x080fe20000410000ULL,
0x0000002600351308ULL, 0x000ea20000000800ULL, 0x000000000f0f7220ULL, 0x080fe20000410000ULL,
0x0000000012127220ULL, 0x080fe20000410000ULL, 0x0000000013137220ULL, 0x080fe20000410000ULL,
0x0000000016167220ULL, 0x080fe20000410000ULL, 0x0000000017177220ULL, 0x080fe20000410000ULL,
0x000000001a1a7220ULL, 0x080fe20000410000ULL, 0x000000001b1b7220ULL, 0x080fe20000410000ULL,
0x000000001e1e7220ULL, 0x080fe20000410000ULL, 0x000000001f1f7220ULL, 0x080fe20000410000ULL,
0x0000000022227220ULL, 0x080fe20000410000ULL, 0x0000000023237220ULL, 0x000fe20000410000ULL,
0x000000ffff317224ULL, 0x000fe200078e0025ULL, 0x0000002735271220ULL, 0x014fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000003227327221ULL, 0x010fe20000010000ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x0106ac00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fc40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000247305ULL, 0x0004e4000021f000ULL,
0x3fa0000000007823ULL, 0x004fe200000100ffULL, 0x000000240000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff247984ULL, 0x000ea40000000800ULL, 0x8000000024ff7812ULL, 0x004fe40007804841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000035ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff5b7819ULL, 0x000fc4000001162eULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x0000b0127f007947ULL, 0x000fea000b800000ULL, 0x00001f5b5a5e7589ULL, 0x0004e400000e0000ULL,
0x0000b0527f007947ULL, 0x000fea000b800000ULL, 0x00001f3e5a5d7589ULL, 0x0008a400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x004fe200078e003fULL,
0x0000aca0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000b74000007944ULL, 0x01afea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x004fe200078e0040ULL,
0x0000ad00005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000b6e000007944ULL, 0x01afea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004c24783bULL, 0x000f620000004200ULL,
0x0000991066667816ULL, 0x000fc600000000ffULL, 0x000000004d28783bULL, 0x000f240000004200ULL,
0x000000ffff847224ULL, 0x000fe400078e0066ULL, 0x000000004e48783bULL, 0x000ee60000004200ULL,
0x000000ff8400720cULL, 0x000fe20003f05270ULL, 0x000000004f4c783bULL, 0x000ea20000004200ULL,
0x00000018ff657819ULL, 0x020fe20000011427ULL, 0x0000010027707824ULL, 0x040fe200078e00ffULL,
0x00008880276f7816ULL, 0x040fe200000000ffULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011426ULL, 0x00000100266e7824ULL, 0x040fe200078e00ffULL,
0x00008880266d7816ULL, 0x040fe200000000ffULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe20000011427ULL, 0x0000010024687824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x00000100256b7824ULL, 0x000fe200078e00ffULL,
0x0000002700727306ULL, 0x000be20000200c00ULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x00000018ff627819ULL, 0x010fe40000011428ULL, 0x00000018ff637819ULL, 0x000fe40000011429ULL,
0x00000018ff607819ULL, 0x000fe2000001142aULL, 0x0000007000717306ULL, 0x000fe20000200c00ULL,
0x0000010028277824ULL, 0x020fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe4000001142bULL,
0x00000018ff007819ULL, 0x004fe40000011424ULL, 0x00000018ff277819ULL, 0x000fc40000011427ULL,
0x0000002600707306ULL, 0x0005e20000200c00ULL, 0x0000888024677816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000888025697816ULL, 0x000fe400000000ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002700747306ULL, 0x0009e20000200c00ULL, 0x0000888028267816ULL, 0x044fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc4000001146bULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000002600737306ULL, 0x0005620000200c00ULL, 0x0000010029277824ULL, 0x050fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x008fe40000011449ULL, 0x00000018ff5c7819ULL, 0x000fe40000011448ULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002800767306ULL, 0x0007e20000200c00ULL,
0x0000888029267816ULL, 0x044fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc4000001144aULL, 0x00000018ff5b7819ULL, 0x000fe4000001144bULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000002700777306ULL, 0x0005e20000200c00ULL,
0x0000b80050287811ULL, 0x008fe400078e20ffULL, 0x0000541073747816ULL, 0x020fe40000000074ULL,
0x00000018ff587819ULL, 0x000fe4000001144cULL, 0x00000018ff597819ULL, 0x000fe2000001144dULL,
0x0000002600757306ULL, 0x0007220000200c00ULL, 0x000001002a277824ULL, 0x004fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fc8000001144fULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002900787306ULL, 0x000fe20000200c00ULL, 0x000088802a267816ULL, 0x048fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x0000002600797306ULL, 0x0005e20000200c00ULL, 0x0000541075757816ULL, 0x010fce0000000077ULL,
0x00000027007a7306ULL, 0x0007220000200c00ULL, 0x000088802b267816ULL, 0x004fce00000000ffULL,
0x0000002a007c7306ULL, 0x000fe20000200c00ULL, 0x000001002b277824ULL, 0x048fe400078e00ffULL,
0x000100002b2b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x00000000006a7306ULL, 0x0005e20000200c00ULL,
0x00005410797a7816ULL, 0x010fce000000007aULL, 0x0000002b007e7306ULL, 0x0007e20000200c00ULL,
0x00000018ff007819ULL, 0x004fe20000011425ULL, 0x0001000025257824ULL, 0x000fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe20000011425ULL, 0x00000027007d7306ULL, 0x0005e20000200c00ULL,
0x000000002828783bULL, 0x008eee0000000200ULL, 0x00000026007b7306ULL, 0x0009620000200c00ULL,
0x0000010048277824ULL, 0x004fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000000006c7306ULL, 0x0005e20000200c00ULL, 0x0000888048267816ULL, 0x050fe200000000ffULL,
0x0001000048487824ULL, 0x000fca00078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000002700807306ULL, 0x0009e20000200c00ULL, 0x000054107b7b7816ULL, 0x020fe4000000007dULL,
0x00000018ff007819ULL, 0x004fca000001144eULL, 0x0000002400247306ULL, 0x000ea20000200c00ULL,
0x0000010049277824ULL, 0x010fca00078e00ffULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000002500257306ULL, 0x000f220000200c00ULL, 0x0000005e28288232ULL, 0x088fe40000000000ULL,
0x0000005e2a2a8232ULL, 0x000fe40000000000ULL, 0x0000005d29298232ULL, 0x080fe40000000000ULL,
0x0000005d2b2b8232ULL, 0x000fe20000000000ULL, 0x0000002700507306ULL, 0x0007e20000200c00ULL,
0x0000541024247816ULL, 0x004fca000000006aULL, 0x000000742814723cULL, 0x000fe40000001814ULL,
0x00000026007f7306ULL, 0x0005620000200c00ULL, 0x000001004a277824ULL, 0x008fe200078e00ffULL,
0x0000541025257816ULL, 0x010fc8000000006cULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x0000007a281c723cULL, 0x000fe2000000181cULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x0000888049267816ULL, 0x044fe200000000ffULL, 0x0001000049497824ULL, 0x000fca00078e00ffULL,
0x000000242808723cULL, 0x000fe20000001808ULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x000054107f807816ULL, 0x020fca0000000080ULL,
0x0000002600817306ULL, 0x0007300000200c00ULL, 0x0000002700837306ULL, 0x000be20000200c00ULL,
0x000088804a267816ULL, 0x048fe200000000ffULL, 0x000100004a4a7824ULL, 0x000fe200078e00ffULL,
0x0000541067687816ULL, 0x004fc80000000068ULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x0000002600827306ULL, 0x0004e20000200c00ULL, 0x000001004b277824ULL, 0x020fe200078e00ffULL,
0x0000541081817816ULL, 0x010fc80000000050ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000088804b267816ULL, 0x044fe200000000ffULL,
0x000100004b4b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000002600667306ULL, 0x0005e20000200c00ULL, 0x0000541082827816ULL, 0x008fce0000000083ULL,
0x0000002700847306ULL, 0x0007220000200c00ULL, 0x0000b80051267811ULL, 0x004fe200078e20ffULL,
0x000001004c517824ULL, 0x000fca00078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000088804c277816ULL, 0x048fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000002700677306ULL, 0x0007e20000200c00ULL, 0x0000541066837816ULL, 0x010fce0000000084ULL,
0x0000006400647306ULL, 0x000f220000200c00ULL, 0x000000002624783bULL, 0x008ee20000000200ULL,
0x0000541069697816ULL, 0x004fcc000000006bULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x000000682804723cULL, 0x000fee0000001804ULL, 0x0000006200627306ULL, 0x000f620000200c00ULL,
0x0000541070647816ULL, 0x010fe20000000064ULL, 0x000001004d697824ULL, 0x040fe200078e00ffULL,
0x000088804d687816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000006300637306ULL, 0x000f220000200c00ULL,
0x0000541072657816ULL, 0x004fe40000000065ULL, 0x00000018ff4d7819ULL, 0x000fca000001144dULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x0000541076627816ULL, 0x020fe20000000062ULL,
0x000000642810723cULL, 0x000fec0000001810ULL, 0x0000006100617306ULL, 0x000f620000200c00ULL,
0x0000541078637816ULL, 0x010fe20000000063ULL, 0x0000005e24248232ULL, 0x008fc40000000000ULL,
0x0000005e26268232ULL, 0x000fe20000000000ULL, 0x000001004e5e7824ULL, 0x000fe200078e00ffULL,
0x0000005d25258232ULL, 0x080fe40000000000ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000054107c607816ULL, 0x004fe20000000060ULL, 0x000000622818723cULL, 0x000fe20000001818ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000005d27278232ULL, 0x000fc80000000000ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000054107e617816ULL, 0x020fe40000000061ULL,
0x000088804e627816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x000000802404723cULL, 0x000fe60000001804ULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fc8000001144eULL, 0x000000602820723cULL, 0x000fe20000001820ULL,
0x000054106d6e7816ULL, 0x004fe4000000006eULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000054106f6f7816ULL, 0x008fce0000000071ULL, 0x0000004900497306ULL, 0x000ea20000200c00ULL,
0x0000006e280c723cULL, 0x000fee000000180cULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000088804f287816ULL, 0x040fe200000000ffULL, 0x000001004f297824ULL, 0x000fc400078e00ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x0000541049497816ULL, 0x004fc6000000005fULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x00000018ff4f7819ULL, 0x000fca000001144fULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000082240c723cULL, 0x000fee000000180cULL, 0x0000005800587306ULL, 0x000ff00000200c00ULL,
0x0000005900597306ULL, 0x000ff00000200c00ULL, 0x0000004800487306ULL, 0x000eb00000200c00ULL,
0x0000004a004a7306ULL, 0x000ef00000200c00ULL, 0x0000004b004b7306ULL, 0x000f220000200c00ULL,
0x0000541048487816ULL, 0x004fce000000005cULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000054104a5a7816ULL, 0x008fe2000000005aULL, 0x000000482408723cULL, 0x000fec0000001808ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054104b5b7816ULL, 0x010fce000000005bULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000005a2410723cULL, 0x000fee0000001810ULL,
0x0000004c004c7306ULL, 0x000eb00000200c00ULL, 0x0000004d004d7306ULL, 0x000ef00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000054104c587816ULL, 0x004fce0000000058ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054104d597816ULL, 0x008fce0000000059ULL,
0x00000028002a7306ULL, 0x0007e20000200c00ULL, 0x000000582418723cULL, 0x000fee0000001818ULL,
0x00000029005f7306ULL, 0x0009620000200c00ULL, 0x0000541067287816ULL, 0x008fe40000000051ULL,
0x00005410625e7816ULL, 0x004fca000000005eULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x0000541068297816ULL, 0x010fce0000000069ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054102a5f7816ULL, 0x020fe2000000005fULL, 0x000000282414723cULL, 0x040fec0000001814ULL,
0x0000004e004e7306ULL, 0x000ea40000200c00ULL, 0x0000005e241c723cULL, 0x000fec000000181cULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x000054104e4e7816ULL, 0x004fc40000000000ULL,
0x000054104f4f7816ULL, 0x008fce0000000041ULL, 0x0000004e2424723cULL, 0x000fe20000001820ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff207f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x004fe40007824821ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff007984ULL, 0x000ea40000000800ULL,
0x8000000000ff7812ULL, 0x004fc40007824821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000227305ULL, 0x0004e4000021f000ULL, 0x3fa0000000007823ULL, 0x004fe200000100ffULL,
0x000000220000735dULL, 0x008fe40003800000ULL, 0x0106bc00ff227984ULL, 0x000ea40000000800ULL,
0x8000000022ff7812ULL, 0x004fe40007824821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000003002c007a10ULL, 0x000fe20007ffe0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x00000004ff297819ULL, 0x000fc4000001162eULL, 0x0000000100217810ULL, 0x040fe20007ffe0ffULL,
0x0000010000207824ULL, 0x000fc600078e00ffULL, 0x0000002d2100720cULL, 0x000fe20003f26070ULL,
0x0000620030007a24ULL, 0x000fe200078e0220ULL, 0x0000002003227217ULL, 0x000fc60007800000ULL,
0x000000013b237824ULL, 0x000fe400078e0200ULL, 0x0000000122227824ULL, 0x000fe400078e0a20ULL,
0x0000000136207824ULL, 0x000fc600078e0200ULL, 0x0000002022227807ULL, 0x000fe20000800000ULL,
0x00005e0020207625ULL, 0x000fc600078e0041ULL, 0x000000222f287217ULL, 0x000fe20007800000ULL,
0x00005e0023227625ULL, 0x000fe200078e0041ULL, 0x00000037202a7210ULL, 0x000fc60007f3e0ffULL,
0x0000000128367824ULL, 0x000fe200078e0a2fULL, 0x0000003722227210ULL, 0x000fe20007f7e0ffULL,
0x000000013c207824ULL, 0x100fe400078e0200ULL, 0x000000013d287824ULL, 0x000fe200078e0200ULL,
0x000000362900720cULL, 0x080fe20003f46070ULL, 0x000000ffff2b7224ULL, 0x000fe200008e0621ULL,
0x000000363800720cULL, 0x080fe20003f26070ULL, 0x00005e0020207625ULL, 0x000fe200078e0041ULL,
0x000000363a00720cULL, 0x000fc60003f86070ULL, 0x00005e0028287625ULL, 0x000fe200078e0041ULL,
0x0000003720207210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200018e0623ULL,
0x000000363900720cULL, 0x000fe20003f66070ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x0000003728287210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a527faeULL, 0x0005e8000d101c46ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0x0000000022537faeULL, 0x0005ea000c901c46ULL, 0x0000000020547faeULL, 0x0005e8000d901c46ULL,
0x0000000028557faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff207f8cULL, 0x004fe8000c80043fULL,
0x0106b400ff007984ULL, 0x000ea40000000800ULL, 0x8000000000ff7812ULL, 0x006fc40007824847ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0021ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe40007824847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000207305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000200000735dULL, 0x004fe40003800000ULL,
0x0106b400ff207984ULL, 0x000e640000000800ULL, 0x8000000020ff7812ULL, 0x002fc40007824847ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000035ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff397819ULL, 0x000fe4000001162eULL, 0x00005410005a7816ULL, 0x000fe20000000000ULL,
0x00009bc27f007947ULL, 0x000fea000b800000ULL, 0x00001f395a397589ULL, 0x0002a400000e0000ULL,
0x00009c127f007947ULL, 0x000fea000b800000ULL, 0x00001f3e5a3e7589ULL, 0x00072400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e003fULL,
0x0000c1c0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000a22000007944ULL, 0x01efea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0040ULL,
0x0000c220005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fc400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000a1c000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000005628783bULL, 0x000f680000004200ULL,
0x000000005754783bULL, 0x000fe80000004200ULL, 0x000000004420783bULL, 0x000e680000004200ULL,
0x000000004544783bULL, 0x000ee20000004200ULL, 0x00000018ff007819ULL, 0x024fe20000011428ULL,
0x00000100294e7824ULL, 0x040fe200078e00ffULL, 0x00008880294d7816ULL, 0x000fe200000000ffULL,
0x00000100284b7824ULL, 0x040fe200078e00ffULL, 0x00000000004c7306ULL, 0x0005e20000200c00ULL,
0x00008880284a7816ULL, 0x040fe200000000ffULL, 0x0001000028287824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x00000018ff3d7819ULL, 0x002fe40000011421ULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000004d004f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff007819ULL, 0x004fe20000011429ULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001144bULL, 0x00000018ff3c7819ULL, 0x000fe40000011420ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x00000028004d7306ULL, 0x0002a20000200c00ULL,
0x00000018ff3b7819ULL, 0x000fc40000011422ULL, 0x00000018ff3a7819ULL, 0x000fe40000011423ULL,
0x00000018ff487819ULL, 0x000fe40000011454ULL, 0x00000018ff497819ULL, 0x000fe20000011455ULL,
0x0000002900517306ULL, 0x000be20000200c00ULL, 0x000088802a287816ULL, 0x002fe400000000ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011456ULL, 0x00000018ff407819ULL, 0x000fc40000011457ULL,
0x00000018ff377819ULL, 0x008fe20000011444ULL, 0x0000002800527306ULL, 0x0003e20000200c00ULL,
0x000001002a297824ULL, 0x020fe200078e00ffULL, 0x000054104d4c7816ULL, 0x004fe4000000004cULL,
0x00000018ff387819ULL, 0x000fe40000011445ULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000000000507306ULL, 0x0004e20000200c00ULL, 0x000088802b287816ULL, 0x002fc400000000ffULL,
0x00000018ff367819ULL, 0x000fca0000011447ULL, 0x0000002900537306ULL, 0x0003620000200c00ULL,
0x00000018ff007819ULL, 0x004fe2000001142aULL, 0x000100002a2a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x00000028005a7306ULL, 0x0005e20000200c00ULL,
0x000001002b297824ULL, 0x002fe200078e00ffULL, 0x00005410514d7816ULL, 0x008fc80000000050ULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000000000587306ULL, 0x0003e20000200c00ULL,
0x0000888054287816ULL, 0x004fe400000000ffULL, 0x0000541052527816ULL, 0x020fca0000000053ULL,
0x00000029005b7306ULL, 0x0004e20000200c00ULL, 0x00000018ff007819ULL, 0x002fe2000001142bULL,
0x000100002b2b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001142bULL,
0x00000028005e7306ULL, 0x0003e20000200c00ULL, 0x0000010054297824ULL, 0x044fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000002a00597306ULL, 0x0005620000200c00ULL, 0x0000888055287816ULL, 0x002fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x000054105a537816ULL, 0x008fc6000000005bULL,
0x00000029005f7306ULL, 0x0002e20000200c00ULL, 0x00008880212a7816ULL, 0x004fce00000000ffULL,
0x0000002800607306ULL, 0x0005e20000200c00ULL, 0x0000010055297824ULL, 0x002fe200078e00ffULL,
0x0000541059587816ULL, 0x020fe20000000058ULL, 0x0001000055557824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000002b005d7306ULL, 0x000fe20000200c00ULL,
0x0000888056287816ULL, 0x004fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000054105e5e7816ULL, 0x008fc6000000005fULL, 0x0000002900617306ULL, 0x0002b00000200c00ULL,
0x0000002800627306ULL, 0x0007e20000200c00ULL, 0x0000010056297824ULL, 0x042fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff297819ULL, 0x000fe40000011429ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000888057287816ULL, 0x008fe400000000ffULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00005410605f7816ULL, 0x004fc60000000061ULL,
0x0000002900637306ULL, 0x0002b00000200c00ULL, 0x0000002800647306ULL, 0x0007e20000200c00ULL,
0x0000010057297824ULL, 0x042fe400078e00ffULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x0000888020287816ULL, 0x008fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000541062627816ULL, 0x004fc60000000063ULL, 0x0000002900657306ULL, 0x0004f00000200c00ULL,
0x0000002800667306ULL, 0x000be20000200c00ULL, 0x0000010020297824ULL, 0x004fe200078e00ffULL,
0x000054104a4a7816ULL, 0x002fe2000000004bULL, 0x0001000020207824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0000b80043287811ULL, 0x020fe200078e20ffULL, 0x0000010021437824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0001000021217824ULL, 0x000fe200078e00ffULL,
0x0000541064637816ULL, 0x008fe40000000065ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000002900677306ULL, 0x0004e20000200c00ULL, 0x00000018ff217819ULL, 0x000fce0000011421ULL,
0x00000021006a7306ULL, 0x000be20000200c00ULL, 0x000000ffff297224ULL, 0x004fe200078e002aULL,
0x000054104f4b7816ULL, 0x002fcc000000004eULL, 0x0000002900687306ULL, 0x0003e20000200c00ULL,
0x0000010022217824ULL, 0x020fe200078e00ffULL, 0x0000541066667816ULL, 0x008fc80000000067ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000004300697306ULL, 0x000ea20000200c00ULL,
0x000000002828783bULL, 0x002e6e0000000200ULL, 0x0000002000437306ULL, 0x0007f00000200c00ULL,
0x00000021006c7306ULL, 0x000be20000200c00ULL, 0x0000888022207816ULL, 0x048fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000541068677816ULL, 0x004fc80000000069ULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x00000020006b7306ULL, 0x0004e20000200c00ULL,
0x0000010023217824ULL, 0x020fca00078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00000022006e7306ULL, 0x000be20000200c00ULL, 0x0000888023207816ULL, 0x044fe200000000ffULL,
0x0001000023237824ULL, 0x000fca00078e00ffULL, 0x00000018ff237819ULL, 0x000fe20000011423ULL,
0x00000020006d7306ULL, 0x0005e20000200c00ULL, 0x0000003928288232ULL, 0x082fe20000000000ULL,
0x0000010044227824ULL, 0x020fe200078e00ffULL, 0x000000392a2a8232ULL, 0x000fe20000000000ULL,
0x000054106b6c7816ULL, 0x008fe2000000006cULL, 0x0000003e29298232ULL, 0x090fe40000000000ULL,
0x0000003e2b2b8232ULL, 0x000fe20000000000ULL, 0x00000021006f7306ULL, 0x0002e20000200c00ULL,
0x0000b80042207811ULL, 0x004fc400078e20ffULL, 0x00000018ff427819ULL, 0x000fc60000011422ULL,
0x0000004a2804723cULL, 0x000fe40000001804ULL, 0x0000002300707306ULL, 0x000fe20000200c00ULL,
0x0000888044217816ULL, 0x042fe200000000ffULL, 0x0001000044447824ULL, 0x000fc600078e00ffULL,
0x00008880454b7816ULL, 0x000fe200000000ffULL, 0x0000004c2808723cULL, 0x000fe20000001808ULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x00000021004a7306ULL, 0x0003e20000200c00ULL,
0x000054106d6d7816ULL, 0x008fc8000000006fULL, 0x00000100454c7824ULL, 0x040fe200078e00ffULL,
0x00000052280c723cULL, 0x040fe2000000180cULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000000005c7306ULL, 0x0004e20000200c00ULL, 0x000000002020783bULL, 0x002e620000000200ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x0000005e2814723cULL, 0x000fe40000001814ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x00000018ff007819ULL, 0x004fca0000011446ULL, 0x00000062281c723cULL, 0x000fe4000000181cULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000054105d597816ULL, 0x008fce000000005cULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000000582810723cULL, 0x000fee0000001810ULL,
0x0000004000407306ULL, 0x000ff00000200c00ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000003920208232ULL, 0x002fc40000000000ULL, 0x0000003922228232ULL, 0x000fe20000000000ULL,
0x0000010046397824ULL, 0x000fe200078e00ffULL, 0x0000003e21218232ULL, 0x080fe40000000000ULL,
0x0000003e23238232ULL, 0x000fe20000000000ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x00000018ff397819ULL, 0x000fca0000011439ULL, 0x000000662004723cULL, 0x000fe40000001804ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541054487816ULL, 0x004fca0000000048ULL,
0x0000006c200c723cULL, 0x000fe4000000180cULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x0000541055497816ULL, 0x002fe40000000049ULL, 0x0000541056567816ULL, 0x008fca000000003fULL,
0x000000482818723cULL, 0x000fe20000001818ULL, 0x0000003c003c7306ULL, 0x000e620000200c00ULL,
0x0000541057577816ULL, 0x004fca0000000040ULL, 0x0000888046487816ULL, 0x040fe200000000ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000000562824723cULL, 0x000fe40000001824ULL, 0x000000ffff3f7224ULL, 0x000fe200078e0048ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00005410433c7816ULL, 0x002fe4000000003cULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x0000888047287816ULL, 0x040fe200000000ffULL,
0x0000010047297824ULL, 0x000fc400078e00ffULL, 0x0001000047477824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000003a003a7306ULL, 0x000ee20000200c00ULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x000054106a3d7816ULL, 0x004fe4000000003dULL,
0x000054106e6e7816ULL, 0x002fc6000000003bULL, 0x0000003700377306ULL, 0x000fe40000200c00ULL,
0x0000003c2008723cULL, 0x000fec0000001808ULL, 0x0000003800387306ULL, 0x000fe20000200c00ULL,
0x00005410706f7816ULL, 0x008fce000000003aULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000006e2010723cULL, 0x000fee0000001810ULL, 0x0000004b004b7306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000ea20000200c00ULL, 0x000054104a427816ULL, 0x002fce0000000042ULL,
0x0000004400447306ULL, 0x000e700000200c00ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000054104b437816ULL, 0x004fce000000004cULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x002fe20000000037ULL, 0x000000422014723cULL, 0x000fec0000001814ULL,
0x0000003900397306ULL, 0x000e620000200c00ULL, 0x0000541045457816ULL, 0x008fce0000000038ULL,
0x00000028002a7306ULL, 0x0003e20000200c00ULL, 0x000000442018723cULL, 0x000fee0000001818ULL,
0x0000002900297306ULL, 0x000ea20000200c00ULL, 0x000054103f287816ULL, 0x002fce0000000039ULL,
0x0000000000007306ULL, 0x000ff00000200c00ULL, 0x0000003600367306ULL, 0x000fe20000200c00ULL,
0x000054102a297816ULL, 0x004fce0000000029ULL, 0x0000004600467306ULL, 0x000e620000200c00ULL,
0x00000028201c723cULL, 0x000fee000000181cULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000541046467816ULL, 0x002fe40000000000ULL, 0x0000541047477816ULL, 0x004fce0000000036ULL,
0x000000462020723cULL, 0x000fe20000001824ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff247f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff247224ULL, 0x002fc600078e0025ULL, 0x000003002c2c7a10ULL, 0x000fc80007ffe0ffULL,
0x0000002d2c00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff3bc000007947ULL, 0x000fea000383ffffULL, 0x0000000000357919ULL, 0x000e620000002500ULL,
0x000000ffff347224ULL, 0x000fe400078e0023ULL, 0x000000ffff337224ULL, 0x000fe400078e0022ULL,
0x000000ffff307224ULL, 0x000fe400078e0021ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0020ULL,
0x000000ffff2c7224ULL, 0x000fe400078e001fULL, 0x000000ffff2b7224ULL, 0x000fc400078e001eULL,
0x000000ffff2a7224ULL, 0x000fe400078e001dULL, 0x000000ffff297224ULL, 0x000fe400078e001cULL,
0x000000ffff287224ULL, 0x000fe400078e001bULL, 0x000000ffff277224ULL, 0x008fe400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0019ULL, 0x000000ffff257224ULL, 0x004fe200078e0018ULL,
0x0000002d3500720cULL, 0x002fe20003f06070ULL, 0x000000ffff247224ULL, 0x000fc400078e0017ULL,
0x000000ffff237224ULL, 0x000fe400078e0016ULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff217224ULL, 0x000fe400078e0014ULL, 0x000000ffff207224ULL, 0x000fe400078e0013ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0012ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0011ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0010ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000fULL,
0x000000ffff1b7224ULL, 0x000fe400078e000eULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff197224ULL, 0x000fe400078e000cULL, 0x000000ffff187224ULL, 0x000fc400078e000bULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff167224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x000fe400078e0008ULL, 0x000000ffff157224ULL, 0x000fe400078e0007ULL,
0x000000ffff147224ULL, 0x000fe400078e0006ULL, 0x000000ffff127224ULL, 0x000fc400078e0005ULL,
0x000000ffff117224ULL, 0x000fe200078e0004ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000032007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0032ULL,
0x0000d42000067802ULL, 0x000fe40000000f00ULL, 0x00008e0000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003200007308ULL, 0x000e640000001000ULL,
0xbf80000000037423ULL, 0x002fc80000000032ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x006fca00078e00ffULL,
0x0000000604047981ULL, 0x0002a8000c1e9900ULL, 0x0000000000057919ULL, 0x002e640000000000ULL,
0x00000002ff037819ULL, 0x002fe20000011605ULL, 0x0000000004007220ULL, 0x00cfe20000410000ULL,
0x0000000805047811ULL, 0x000fc800078ff0ffULL, 0x00001f0300037589ULL, 0x000e6800000e0000ULL,
0x00001f0400047589ULL, 0x000ea200000e0000ULL, 0x0000001103117220ULL, 0x042fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001303137220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000002103217220ULL, 0x040fe20000410000ULL,
0x0000002203227220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000002903297220ULL, 0x040fe20000410000ULL,
0x0000002a032a7220ULL, 0x040fe20000410000ULL, 0x0000002e032e7220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x000fe20000410000ULL, 0x0000001404147220ULL, 0x044fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x000fe20000410000ULL, 0x0000000000007919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000200037812ULL, 0x002fc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011600ULL, 0x00000001ff047819ULL, 0x000fe40000011603ULL,
0x0000000203057811ULL, 0x040fe400078ff8ffULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x00000006030c7811ULL, 0x000fe400078ff8ffULL, 0x0000000800107811ULL, 0x000fc400078ff0ffULL,
0x0000000704037812ULL, 0x100fe400078e780eULL, 0x0000000705067812ULL, 0x140fe400078e780eULL,
0x00000007080a7812ULL, 0x000fe200078e780eULL, 0x000000080e077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078e7810ULL, 0x000000080e097824ULL, 0x000fe200078e0206ULL,
0x000000070c0d7812ULL, 0x000fe200078e780eULL, 0x0000080002037824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078e7810ULL, 0x00000008100f7824ULL, 0x000fe200078e0208ULL,
0x0000000705057812ULL, 0x000fe200078e7810ULL, 0x000000080e0b7824ULL, 0x000fe200078e020aULL,
0x000000070c067812ULL, 0x000fe200078e7810ULL, 0x000000080e0d7824ULL, 0x000fc400078e020dULL,
0x00000008100c7824ULL, 0x000fe200078e0204ULL, 0x0000a00003047810ULL, 0x000fe20007ffe0ffULL,
0x0000000800087824ULL, 0x000fe400078e00ffULL, 0x00000008100e7824ULL, 0x000fe200078e0205ULL,
0x000000111205723eULL, 0x000fe200000000ffULL, 0x0000000810107824ULL, 0x000fe200078e0206ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000131606723eULL, 0x000fe200000000ffULL, 0x00000010090a7824ULL, 0x000fc400078e0204ULL,
0x000000100b0b7824ULL, 0x000fe200078e0204ULL, 0x0000541005127816ULL, 0x040fe20000000006ULL,
0x000000100c0c7824ULL, 0x000fe200078e0204ULL, 0x0000763205137816ULL, 0x000fe20000000006ULL,
0x000000100e0e7824ULL, 0x100fe200078e0204ULL, 0x000000212205723eULL, 0x000fe200000000ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0204ULL, 0x000000100f0f7824ULL, 0x100fe400078e0204ULL,
0x0000001010107824ULL, 0x000fc400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x000000191a07723eULL, 0x000fe200000000ffULL, 0x00000001080a7824ULL, 0x040fe400078e020aULL,
0x00000001080b7824ULL, 0x040fe200078e020bULL, 0x0000001209007388ULL, 0x0003e20000000a00ULL,
0x00000001080c7824ULL, 0x040fe400078e020cULL, 0x00000001080e7824ULL, 0x040fe400078e020eULL,
0x00000001080d7824ULL, 0x000fc400078e020dULL, 0x00000001080f7824ULL, 0x040fe400078e020fULL,
0x0000000108107824ULL, 0x000fe200078e0210ULL, 0x0000001d1e08723eULL, 0x000fe400000000ffULL,
0x000000141509723eULL, 0x002fe400000000ffULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe40000000008ULL, 0x0000002e3008723eULL, 0x000fc600000000ffULL,
0x000000060a007388ULL, 0x0003e40000000a00ULL, 0x000000252606723eULL, 0x002fe400000000ffULL,
0x000000292a07723eULL, 0x000fe400000000ffULL, 0x00000017180a723eULL, 0x000fe400000000ffULL,
0x0000541005127816ULL, 0x140fe40000000006ULL, 0x0000763205137816ULL, 0x000fc40000000006ULL,
0x0000541007067816ULL, 0x140fe40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000120b007388ULL, 0x0003e20000000a00ULL, 0x0000541009087816ULL, 0x140fe4000000000aULL,
0x0000763209097816ULL, 0x000fe2000000000aULL, 0x000000060d007388ULL, 0x0005e20000000a00ULL,
0x0000001b1c05723eULL, 0x000fe400000000ffULL, 0x00000033340a723eULL, 0x000fe200000000ffULL,
0x000000080c007388ULL, 0x0007e20000000a00ULL, 0x00000300ff137624ULL, 0x002fe200078e00ffULL,
0x0000001f2006723eULL, 0x004fc400000000ffULL, 0x000000232407723eULL, 0x000fe400000000ffULL,
0x000000272808723eULL, 0x008fe400000000ffULL, 0x000000011300780cULL, 0x000fe40003f05270ULL,
0x0000002b2c09723eULL, 0x000fe400000000ffULL, 0x00005410050c7816ULL, 0x140fe40000000006ULL,
0x00007632050d7816ULL, 0x000fc40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000c0e007388ULL, 0x0003e20000000a00ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x000000060f007388ULL, 0x0003e80000000a00ULL, 0x0000000810007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b4000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x002e620000002700ULL, 0x0000001000057824ULL, 0x000fe200078e0203ULL,
0x000000ff0200720cULL, 0x000fe20003f05270ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00000020000e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0000720cULL, 0x000fe20000725670ULL, 0x00a0000005147984ULL, 0x000ea80000000c00ULL,
0x00a2000005187984ULL, 0x0007240000000c00ULL, 0x0000580013057a24ULL, 0x008fc800078e02ffULL,
0x0000640005077a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x002fc600078e0206ULL,
0x00000fff07067811ULL, 0x040fe400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x0000030010057a24ULL, 0x000fc800078e02ffULL, 0x00000001050a7824ULL, 0x000fca00078e0235ULL,
0x0000000a06087211ULL, 0x000fca00078fa0ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x0000040002087825ULL, 0x000fcc00078e0008ULL, 0x000000100e0e7825ULL, 0x000fc800078e0008ULL,
0x00000010000c7825ULL, 0x000fe200078e0008ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x014fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011600ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008127812ULL, 0x000fe400078ec0ffULL, 0x0000000c091c7812ULL, 0x000fe200078ec0ffULL,
0x00006a000a087625ULL, 0x000fc800078e0011ULL, 0x00006a000b0a7625ULL, 0x000fe200078e0011ULL,
0x000000081c087210ULL, 0x000fc80007b5e012ULL, 0x0000000a1c0a7210ULL, 0x000fe40007d9e012ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000003108007986ULL, 0x0003e8000c101906ULL, 0x000000320a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x0145e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000180e007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x002fe200078e00ffULL,
0xffffffff130a7810ULL, 0x000fc60007ffe0ffULL, 0x0000680010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000a080879a8ULL, 0x000ee400099ee1c6ULL, 0x0000000a0800720cULL, 0x008fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000800000ULL,
0x00000009ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x002e640000000000ULL,
0x000000ff0800720cULL, 0x002fda0003f25270ULL, 0x0000278000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011600ULL, 0x00000080ff127424ULL, 0x000fe200078e00ffULL,
0x00000001050a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007008147812ULL, 0x004fe400078ec0ffULL,
0x0000000c09157812ULL, 0x000fe200078ec0ffULL, 0x00006a0005087625ULL, 0x000fc800078e0012ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e014ULL,
0x0000000a150a7210ULL, 0x000fe40007b5e014ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x00000006080c7981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021300780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000205087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e014ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080e7981ULL, 0x000362000c1e1900ULL,
0x000000041300780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000305087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e014ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041300780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000405087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000815087210ULL, 0x000fc8000791e014ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608107981ULL, 0x000362000c1e1900ULL,
0x000000061300780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000505087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fc8000791e014ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000061300780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081300780cULL, 0x002fe40003f06070ULL,
0x0000000605087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000815087210ULL, 0x000fe40007a3e014ULL, 0x00000007050a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0012ULL,
0x0000000608127981ULL, 0x000366000c1e1900ULL, 0x0000000a150a0210ULL, 0x000fc80007c7e014ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a0a0981ULL, 0x000368000c1e1900ULL,
0x0000000713087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0b7819ULL, 0x000fc80000011608ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x024fe400078e000cULL,
0x0000000813157824ULL, 0x040fe200078e00ffULL, 0x0000000113137810ULL, 0x000fc80007ffe0ffULL,
0x0000030015007a0cULL, 0x000fe40003f26070ULL, 0x0000000b1300720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000815087810ULL, 0x040fe40007ffe0ffULL,
0x0000000115097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000140c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007014147812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e014ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608147981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000915087810ULL, 0x042fe40007ffe0ffULL, 0x0000000215097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000d7824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000315097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000e0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e00eULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080e7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000415097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000515097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000100c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010107812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e010ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608107981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000615097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001000117824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000715097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000120c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011600ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007012127812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e012ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608127981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f15087810ULL, 0x002fe40007ffe0ffULL, 0x0000000a0c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011600ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700a0a7812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007a3e00aULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x00000006080a7981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ee40000000000ULL,
0x0000001000087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011600ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000c08007388ULL, 0x0203e40000000800ULL,
0x0000000506087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff437819ULL, 0x000fe20000011602ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000040002427824ULL, 0x040fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000100002217824ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000004208087210ULL, 0x000fe20007f3e0ffULL,
0x000000010a207824ULL, 0x000fe200078e020bULL, 0x00000020000a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001050c8824ULL, 0x004fe200078e0207ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x0000000020207984ULL, 0x000e620000000800ULL,
0x00006a000c0c8625ULL, 0x000fe200078e000dULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000001000107824ULL, 0x000fe400078e0221ULL,
0x0000001002118824ULL, 0x000fe400078e0200ULL, 0x0000001000087825ULL, 0x000fc600078e0008ULL,
0x0000458011118811ULL, 0x000fe200078e20ffULL, 0x00006a00050e8625ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008107faeULL, 0x0005e6000b901c46ULL,
0x0000001002128824ULL, 0x000fe200078e0200ULL, 0x003800000a107faeULL, 0x0007e2000b901c46ULL,
0x00000010000c8825ULL, 0x000fc800078e000cULL, 0x00000010000e8825ULL, 0x000fe200078e000eULL,
0x000000000c118faeULL, 0x0009e2000b901c46ULL, 0x0000418012098811ULL, 0x004fe400078e20ffULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x008fe2000001ff00ULL, 0x000000000e098faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000cf000009947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134357810ULL, 0x000fc80007ffe0ffULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x00000001051f7824ULL, 0x000fe200078e0235ULL,
0x000000070000780cULL, 0x000fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x00000001351e7812ULL, 0x040fe200078ec0ffULL, 0x00000800351a7824ULL, 0x000fe200078e00ffULL,
0x0000001f06187211ULL, 0x000fe400078fa0ffULL, 0x0000002000387810ULL, 0x000fe40007ffe0ffULL,
0x000008001a1c7812ULL, 0x000fe200078ec0ffULL, 0x00006a0018187625ULL, 0x000fc800078e0019ULL,
0x00000001071b9824ULL, 0x000fe200078e021fULL, 0x0000004218187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff369424ULL, 0x000fe400078e00ffULL, 0x00000002021d9824ULL, 0x140fe400078e021eULL,
0x0000000202399824ULL, 0x000fe400078e021eULL, 0x00006a001b1a9625ULL, 0x000fc800078e0036ULL,
0x00000080ff1e9424ULL, 0x000fe400078e00ffULL, 0x00000001211c7824ULL, 0x000fe400078e021cULL,
0x0000000119197824ULL, 0x000fe400000e0643ULL, 0x000000081d379824ULL, 0x000fe400078e0200ULL,
0x00006a001f1e9625ULL, 0x000fc600078e001eULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001000367824ULL, 0x040fe400078e021cULL, 0x0000000839399824ULL, 0x000fe400078e0200ULL,
0x00000010001c9825ULL, 0x000fc800078e001aULL, 0x00000010381a7825ULL, 0x000fe200078e0018ULL,
0x0000418039389811ULL, 0x000fc600078e20ffULL, 0x0000001000187825ULL, 0x000fc800078e0018ULL,
0x00000010001e9825ULL, 0x000fe200078e001eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018367faeULL, 0x0003e8000b901c46ULL, 0x003800001a367faeULL, 0x0003e8000b901c46ULL,
0x000000001c379faeULL, 0x0003e8000b901c46ULL, 0x000000001e389faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff377224ULL, 0x002fe200078e0034ULL,
0x00000001ff1a7819ULL, 0x100fe20000011600ULL, 0x0000001000197824ULL, 0x000fe200078e00ffULL,
0x00000002ff447819ULL, 0x000fe20000011600ULL, 0x0000008037187824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fc400078ec0ffULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00000008441b7824ULL, 0x000fe200078e00ffULL, 0x0000008018187812ULL, 0x000fe400078ec0ffULL,
0x00000044ff367212ULL, 0x000fe400078e33ffULL, 0x0000000744347812ULL, 0x000fe200078ec0ffULL,
0x0000010002187824ULL, 0x000fe200078e0218ULL, 0xfffffff81b367812ULL, 0x000fe400078ee236ULL,
0x0000000844457810ULL, 0x000fc40007ffe0ffULL, 0x000000181a187210ULL, 0x000fe20007ffe019ULL,
0x0000000844197824ULL, 0x000fe200078e00ffULL, 0x00000045ff3f7212ULL, 0x000fe200078e33ffULL,
0x0000000845387824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000181a7984ULL, 0x000e620000000800ULL, 0x00000001191b7812ULL, 0x100fe200078ef634ULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0x00000002191c7812ULL, 0x140fe200078ef634ULL,
0x0045800018417984ULL, 0x0004e20000000800ULL, 0x00000003191d7812ULL, 0x140fe400078ef634ULL,
0x00000004191e7812ULL, 0x140fe400078ef634ULL, 0x00000005191f7812ULL, 0x000fe400078ef634ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee23fULL, 0x0000000844187824ULL, 0x004fca00078e00ffULL,
0xfffffff818187812ULL, 0x100fe400078ee234ULL, 0x0000000619347812ULL, 0x000fe200078ef634ULL,
0x0000080037197824ULL, 0x000fca00078e00ffULL, 0x0000080019197812ULL, 0x000fc800078ec0ffULL,
0x0000018021197810ULL, 0x000fca0007ffe019ULL, 0x0000001018187824ULL, 0x100fe400078e0219ULL,
0x000000101b1b7824ULL, 0x100fe400078e0219ULL, 0x000000101d1d7824ULL, 0x100fe200078e0219ULL,
0x0000001a201a7221ULL, 0x002fe20000010100ULL, 0x000000101c1c7824ULL, 0x100fe400078e0219ULL,
0x000000101f1f7824ULL, 0x000fe200078e0219ULL, 0x3fb8aa3b1a377820ULL, 0x000fe20000410000ULL,
0x00000004001a7824ULL, 0x000fc400078e00ffULL, 0x000000101e1e7824ULL, 0x100fe200078e0219ULL,
0x0000003700407308ULL, 0x0002e20000000800ULL, 0x0000001034347824ULL, 0x100fe200078e0219ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001036367824ULL, 0x100fe400078e0219ULL,
0x000000103f3f7824ULL, 0x000fe400078e0219ULL, 0x0000000118187824ULL, 0x000fe400078e021aULL,
0x000000011a1b7824ULL, 0x040fe200078e021bULL, 0x0000000745377812ULL, 0x002fe200078ec0ffULL,
0x000000011a1d7824ULL, 0x000fc400078e021dULL, 0x0000000018187984ULL, 0x000e620000000800ULL,
0x000000011a1c7824ULL, 0x000fe200078e021cULL, 0xfffffff838387812ULL, 0x000fe200078ee237ULL,
0x000000011a1f7824ULL, 0x000fe200078e021fULL, 0x000000001b1b7984ULL, 0x000fe20000000800ULL,
0x00000001393a7812ULL, 0x140fe200078ef637ULL, 0x0000004140407220ULL, 0x008fe20000410000ULL,
0x000000011a1e7824ULL, 0x040fe200078e021eULL, 0x000000001d1d7984ULL, 0x000fe20000000800ULL,
0x000000011a347824ULL, 0x000fe200078e0234ULL, 0x00000002393b7812ULL, 0x040fe200078ef637ULL,
0x0000001038387824ULL, 0x000fe200078e0219ULL, 0x000000001c1c7984ULL, 0x000fe20000000800ULL,
0x00000003393c7812ULL, 0x040fe200078ef637ULL, 0x000000103a3a7824ULL, 0x000fe200078e0219ULL,
0x00000004393d7812ULL, 0x140fe200078ef637ULL, 0x000000001f1f7984ULL, 0x000fe20000000800ULL,
0x00000005393e7812ULL, 0x140fe200078ef637ULL, 0x000000011a387824ULL, 0x040fe200078e0238ULL,
0x0000000639377812ULL, 0x000fe200078ef637ULL, 0x000000001e1e7984ULL, 0x000fe20000000800ULL,
0x000000011a3a7824ULL, 0x000fe200078e023aULL, 0x0000003340337221ULL, 0x000fe20000010000ULL,
0x000000103b3b7824ULL, 0x100fe200078e0219ULL, 0x00001f4440397589ULL, 0x000ea200000e0000ULL,
0x000000103c3c7824ULL, 0x000fc400078e0219ULL, 0x000000011a3b7824ULL, 0x040fe200078e023bULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x000000011a3c7824ULL, 0x000fe400078e023cULL,
0x000000103d3d7824ULL, 0x100fe200078e0219ULL, 0x0000000038387984ULL, 0x000f220000000800ULL,
0x000000103e3e7824ULL, 0x000fe400078e0219ULL, 0x000000011a3d7824ULL, 0x040fe200078e023dULL,
0x000000003a3a7984ULL, 0x000f620000000800ULL, 0x000000011a3e7824ULL, 0x000fc400078e023eULL,
0x0000001037377824ULL, 0x000fe200078e0219ULL, 0x000000003b3b7984ULL, 0x000fe20000000800ULL,
0x20000018ff197230ULL, 0x102fe40000004100ULL, 0x30000018ff187230ULL, 0x000fe20000004100ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x000000011a367824ULL, 0x040fe400078e0236ULL,
0x000000011a377824ULL, 0x040fe200078e0237ULL, 0x000000003d3d7984ULL, 0x000fe20000000800ULL,
0x000000011a3f7824ULL, 0x000fe200078e023fULL, 0x0000003918317223ULL, 0x084fe20000010031ULL,
0x2000001bff187230ULL, 0x000fe20000004100ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x0000003919327223ULL, 0x000fe20000010032ULL, 0x2000001cff197230ULL, 0x000fc40000004100ULL,
0x0000000036367984ULL, 0x000fe20000000800ULL, 0x0000003918307223ULL, 0x080fe20000010030ULL,
0x2000001dff187230ULL, 0x000fe20000004100ULL, 0x00000039192d7223ULL, 0x080fe2000001002dULL,
0x0000000037377984ULL, 0x000fe20000000800ULL, 0x2000001eff197230ULL, 0x000fe40000004100ULL,
0x00000039182b7223ULL, 0x080fe2000001002bULL, 0x000000003f3f7984ULL, 0x000fe20000000800ULL,
0x2000001fff187230ULL, 0x000fe20000004100ULL, 0x0000003919297223ULL, 0x080fe20000010029ULL,
0x3000001bff1b7230ULL, 0x000fe20000004100ULL, 0x00001f4540407589ULL, 0x000e6200000e0000ULL,
0x3000001cff1c7230ULL, 0x000fe20000004100ULL, 0x0000003918277223ULL, 0x080fe20000010027ULL,
0x20000034ff187230ULL, 0x108fe20000004100ULL, 0x000000391b2e7223ULL, 0x080fe2000001002eULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x000000391c2c7223ULL, 0x080fe2000001002cULL,
0x20000038ff197230ULL, 0x010fe20000004100ULL, 0x0000003918257223ULL, 0x080fe20000010025ULL,
0x2000003aff187230ULL, 0x020fe20000004100ULL, 0x0000003934247223ULL, 0x000fe20000010024ULL,
0x000000ffff347224ULL, 0x000fc400078e0035ULL, 0x3000001dff1d7230ULL, 0x000fe40000004100ULL,
0x3000001eff1e7230ULL, 0x000fe20000004100ULL, 0x0000030034007a0cULL, 0x000fe20003f06070ULL,
0x3000001fff1f7230ULL, 0x000fe20000004100ULL, 0x000000391d2a7223ULL, 0x080fe2000001002aULL,
0x30000038ff387230ULL, 0x000fe20000004100ULL, 0x000000391e287223ULL, 0x080fe20000010028ULL,
0x3000003aff3a7230ULL, 0x000fe20000004100ULL, 0x000000391f267223ULL, 0x080fe20000010026ULL,
0x0000004019177223ULL, 0x082fe20000010017ULL, 0x0000004018157223ULL, 0x080fe20000010015ULL,
0x2000003bff197230ULL, 0x000fe20000004100ULL, 0x0000004038167223ULL, 0x080fe20000010016ULL,
0x2000003cff187230ULL, 0x000fe20000004100ULL, 0x000000403a147223ULL, 0x080fe20000010014ULL,
0x20000036ff1a7230ULL, 0x000fe20000004100ULL, 0x0000004019137223ULL, 0x080fe20000010013ULL,
0x2000003eff197230ULL, 0x000fe20000004100ULL, 0x0000004018117223ULL, 0x080fe20000010011ULL,
0x2000003dff187230ULL, 0x000fe20000004100ULL, 0x000000391a237223ULL, 0x080fe20000010023ULL,
0x30000036ff367230ULL, 0x000fe20000004100ULL, 0x00000040190d7223ULL, 0x080fe2000001000dULL,
0x2000003fff197230ULL, 0x000fe20000004100ULL, 0x00000040180f7223ULL, 0x080fe2000001000fULL,
0x20000037ff187230ULL, 0x000fe20000004100ULL, 0x0000003936227223ULL, 0x000fe20000010022ULL,
0x3000003bff3b7230ULL, 0x000fe20000004100ULL, 0x0000004019097223ULL, 0x080fe20000010009ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x00000040180b7223ULL, 0x080fe2000001000bULL,
0x3000003dff3d7230ULL, 0x000fe20000004100ULL, 0x000000403b127223ULL, 0x080fe20000010012ULL,
0x3000003eff3e7230ULL, 0x000fe20000004100ULL, 0x000000403c107223ULL, 0x080fe20000010010ULL,
0x30000037ff377230ULL, 0x000fe20000004100ULL, 0x000000403d0e7223ULL, 0x080fe2000001000eULL,
0x3000003fff3f7230ULL, 0x000fe20000004100ULL, 0x000000403e0c7223ULL, 0x000fc4000001000cULL,
0x00000040370a7223ULL, 0x080fe4000001000aULL, 0x000000403f087223ULL, 0x000fe20000010008ULL,
0xfffff33000008947ULL, 0x000fea000383ffffULL, 0x0180000033007810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000000007812ULL, 0x000fc600078ec0ffULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0033ULL,
0x0000fea000067802ULL, 0x000fe40000000f00ULL, 0x0000638000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003300027308ULL, 0x000e640000001000ULL, 0xbf80000002337423ULL, 0x002fc80000000033ULL,
0x800000ff33337221ULL, 0x000fc80000010100ULL, 0x0000003302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff187819ULL, 0x004fe20000011600ULL,
0x00000004001e7824ULL, 0x040fe200078e00ffULL, 0x00000008001d7811ULL, 0x000fe400078ff0ffULL,
0x00000018ff067212ULL, 0x000fe200078e33ffULL, 0x00001f1802057589ULL, 0x002e6200000e0000ULL,
0x0000001dff1c7212ULL, 0x000fe200078e33ffULL, 0x000000081d077824ULL, 0x040fe200078e00ffULL,
0x000000071d1b7812ULL, 0x000fe200078ec0ffULL, 0x00001f1d02027589ULL, 0x000ea200000e0000ULL,
0x00000008181f7824ULL, 0x000fe200078e00ffULL, 0x0000000c1e1e7812ULL, 0x000fc400078ec0ffULL,
0xfffffff8071c7812ULL, 0x000fe400078ee21cULL, 0x0000000718077812ULL, 0x040fe400078ec0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x0000000818067824ULL, 0x000fe200078e00ffULL,
0x000000041b197812ULL, 0x040fe200078e3cffULL, 0x000000101c1c7824ULL, 0x000fe200078e0204ULL,
0x000000051b1a7812ULL, 0x000fe400078e3cffULL, 0xfffffff806067812ULL, 0x000fe200078ee218ULL,
0x000000081d197824ULL, 0x000fc400078e0219ULL, 0x000000081d1a7824ULL, 0x000fe400078e021aULL,
0x0000001006067824ULL, 0x000fe200078e0204ULL, 0x0000003205327220ULL, 0x042fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x000fe20000410000ULL, 0x0000001702177220ULL, 0x044fe20000410000ULL,
0x0000001602167220ULL, 0x040fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001302137220ULL, 0x040fe20000410000ULL,
0x0000001202127220ULL, 0x040fe20000410000ULL, 0x0000001102117220ULL, 0x040fe20000410000ULL,
0x0000001002107220ULL, 0x040fe20000410000ULL, 0x0000000f020f7220ULL, 0x040fe20000410000ULL,
0x0000000e020e7220ULL, 0x040fe20000410000ULL, 0x0000000d020d7220ULL, 0x040fe20000410000ULL,
0x0000000c020c7220ULL, 0x040fe20000410000ULL, 0x0000000b020b7220ULL, 0x040fe20000410000ULL,
0x0000000a020a7220ULL, 0x040fe20000410000ULL, 0x0000000902097220ULL, 0x040fe20000410000ULL,
0x0000000802027220ULL, 0x000fe20000410000ULL, 0x0000000107087812ULL, 0x000fe200078e3cffULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x000000090202723eULL, 0x000fe200000000ffULL,
0x0000002b052b7220ULL, 0x000fe20000410000ULL, 0x0000000207097812ULL, 0x000fe200078e3cffULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000002905297220ULL, 0x000fe20000410000ULL, 0x00000003070b7812ULL, 0x000fe200078e3cffULL,
0x0000002805287220ULL, 0x040fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x0000002605267220ULL, 0x000fe20000410000ULL, 0x00000004070d7812ULL, 0x040fe200078e3cffULL,
0x000000011e067824ULL, 0x000fe200078e0206ULL, 0x00000005070f7812ULL, 0x000fe200078e3cffULL,
0x0000002505257220ULL, 0x000fe20000410000ULL, 0x0000000607117812ULL, 0x000fe200078e3cffULL,
0x0000000818077824ULL, 0x000fe200078e0208ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x0000000818087824ULL, 0x000fe200078e0209ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000000818097824ULL, 0x040fe200078e020bULL, 0x000000021b177812ULL, 0x000fe200078e3cffULL,
0x00000008180b7824ULL, 0x000fe200078e020dULL, 0x000000323131723eULL, 0x000fe200000000ffULL,
0x000000081d137824ULL, 0x000fe200078e00ffULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x00000008180d7824ULL, 0x040fe200078e020fULL, 0x0000002405247220ULL, 0x000fe20000410000ULL,
0x00000008180f7824ULL, 0x000fe200078e0211ULL, 0x000000011b117812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x100fe200078e0204ULL, 0x000000031b187812ULL, 0x000fe200078e3cffULL,
0x0000001008087824ULL, 0x100fe200078e0204ULL, 0xfffffff813137812ULL, 0x000fe200078ee21dULL,
0x0000001009097824ULL, 0x100fe200078e0204ULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x000000100b0b7824ULL, 0x100fe200078e0204ULL, 0x000000302e2e723eULL, 0x000fe200000000ffULL,
0x000000081d157824ULL, 0x000fe200078e0211ULL, 0x000000061b1b7812ULL, 0x000fe200078e3cffULL,
0x000000100d0d7824ULL, 0x100fe200078e0204ULL, 0x0000002205057220ULL, 0x000fe20000410000ULL,
0x000000011e077824ULL, 0x000fe200078e0207ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x000000081d177824ULL, 0x000fe200078e0217ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0204ULL, 0x000000292828723eULL, 0x000fe200000000ffULL,
0x000000011e087824ULL, 0x000fe200078e0208ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x000000081d187824ULL, 0x000fe200078e0218ULL, 0x0000003106007388ULL, 0x0003e20000000800ULL,
0x000000101f117824ULL, 0x100fe200078e0204ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x000000011e097824ULL, 0x040fe200078e0209ULL, 0x0000002e07007388ULL, 0x0003e20000000800ULL,
0x0000001013137824ULL, 0x100fe200078e0204ULL, 0x000000230505723eULL, 0x000fe200000000ffULL,
0x000000011e0b7824ULL, 0x000fe200078e020bULL, 0x0000002c08007388ULL, 0x0003e20000000800ULL,
0x0000001015157824ULL, 0x000fc400078e0204ULL, 0x000000011e0d7824ULL, 0x040fe200078e020dULL,
0x0000002a09007388ULL, 0x0003e20000000800ULL, 0x000000081d1b7824ULL, 0x000fe400078e021bULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x000000280b007388ULL, 0x0003e20000000800ULL,
0x000000011e0f7824ULL, 0x000fe400078e020fULL, 0x0000001018187824ULL, 0x000fe200078e0204ULL,
0x000000260d007388ULL, 0x0003e20000000800ULL, 0x000000011e117824ULL, 0x000fc400078e0211ULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x000000240f007388ULL, 0x0003e20000000800ULL,
0x000000011e137824ULL, 0x000fe400078e0213ULL, 0x000000101a1a7824ULL, 0x100fe200078e0204ULL,
0x0000000511007388ULL, 0x0003e20000000800ULL, 0x000000011e157824ULL, 0x040fe400078e0215ULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0x0000001613007388ULL, 0x0003e20000000800ULL,
0x000000011e177824ULL, 0x000fc400078e0217ULL, 0x000000011e187824ULL, 0x040fe200078e0218ULL,
0x0000001415007388ULL, 0x0003e20000000800ULL, 0x000000011e197824ULL, 0x040fe400078e0219ULL,
0x000000011e1a7824ULL, 0x040fe200078e021aULL, 0x0000001217007388ULL, 0x0003e20000000800ULL,
0x000000011e1b7824ULL, 0x040fe400078e021bULL, 0x000000011e1c7824ULL, 0x000fe200078e021cULL,
0x0000001018007388ULL, 0x0003e80000000800ULL, 0x0000000e19007388ULL, 0x0003e80000000800ULL,
0x0000000c1a007388ULL, 0x0003e80000000800ULL, 0x0000000a1b007388ULL, 0x0003e80000000800ULL,
0x000000021c007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000002000117810ULL, 0x002fe20007ffe0ffULL, 0x0000000000077919ULL, 0x000e620000002600ULL,
0x00000003ff027819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x00000003ff057819ULL, 0x100fe20000011611ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000702047812ULL, 0x000fe200078e4800ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fc400078e4811ULL, 0x0ffffff804047812ULL, 0x000fe400078ef800ULL,
0x0ffffff806067812ULL, 0x000fe400078ef811ULL, 0x0000000700107812ULL, 0x000fe200078ec0ffULL,
0x0000001004047824ULL, 0x100fe400078e0203ULL, 0x0000001006067824ULL, 0x000fc600078e0203ULL,
0x00a0000004087984ULL, 0x000f280000000c00ULL, 0x00a00000060c7984ULL, 0x0045620000000c00ULL,
0x0000000807037824ULL, 0x042fe400078e00ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x008fe4000f8e023fULL, 0xfffffff803027812ULL, 0x000fc400078ee202ULL,
0xfffffff807057812ULL, 0x000fe400078ee205ULL, 0x0000000402037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000711067812ULL, 0x004fe200078ec0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078248ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4c00ULL, 0x1ffffff810007812ULL, 0x000fe400078ef82fULL,
0x00005b0005057a11ULL, 0x000fe400008f4c07ULL, 0x1ffffff806067812ULL, 0x000fe200078ef82fULL,
0x0000001000027825ULL, 0x000fc800078e0002ULL, 0x0000001006047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000000c04007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604277981ULL, 0x000362000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000012c007810ULL, 0x004fe20007ffe0ffULL,
0x0000000230307824ULL, 0x000fe200078e00ffULL, 0x01060000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004002247824ULL, 0x000fe200078e00ffULL, 0x0000002d0000720cULL, 0x000fe20003f06070ULL,
0x0000580030257a24ULL, 0x000fe400078e0225ULL, 0x000001002c0b7824ULL, 0x000fc800078e0224ULL,
0x00006200251d7a24ULL, 0x000fcc00078e020bULL, 0x000005a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff167819ULL, 0x000fe2000001162eULL, 0x00000100ff197424ULL, 0x000fe200078e00ffULL,
0x0000000b03007217ULL, 0x000fe40007800000ULL, 0x0000000816107810ULL, 0x040fe20007ffe0ffULL,
0x0000000116067824ULL, 0x040fe200078e021dULL, 0x0000001016177810ULL, 0x000fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x00000018161a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110087824ULL, 0x000fe200078e021dULL, 0x000000300d187812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0019ULL, 0x0000002016147810ULL, 0x000fc40007ffe0ffULL,
0x00000003ff127819ULL, 0x100fe2000001162eULL, 0x00005e0008087625ULL, 0x080fe200078e0019ULL,
0x00000018060e7210ULL, 0x080fe40007f1e0ffULL, 0x0000000312127812ULL, 0x100fe200078e482eULL,
0x00000001170a7824ULL, 0x100fe200078e021dULL, 0x0000001808087210ULL, 0x000fe20007f3e0ffULL,
0x000000011a0c7824ULL, 0x000fe200078e021dULL, 0x0000200002137811ULL, 0x000fe200078e68ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0019ULL, 0x0ffffffc122e7812ULL, 0x000fc400078ef82eULL,
0x0000002816157810ULL, 0x000fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x080fe200078e0019ULL,
0x000000001700720cULL, 0x080fe40003fa6070ULL, 0x000000001a00720cULL, 0x000fe20003f86070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x000000180a0a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x000000180c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000011d067824ULL, 0x000fe200078e0214ULL, 0x000000001400720cULL, 0x080fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x000000001600720cULL, 0x000fe20003f06070ULL,
0x00005e0006067625ULL, 0x000fc800078e0019ULL, 0x0000000410117824ULL, 0x040fe400078e00ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000001000720cULL, 0x000fe20003f26070ULL,
0x000000102e2e7824ULL, 0x000fe200078e0213ULL, 0x0000001806107210ULL, 0x000fe20007f5e0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc11067812ULL, 0x000fe400078ee212ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e2e7faeULL, 0x0005e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x000000001500720cULL, 0x000fe20003f46070ULL,
0x0000001006067824ULL, 0x000fc400078e0213ULL, 0x000000011d077824ULL, 0x000fc600078e0215ULL,
0x0000000008067faeULL, 0x0007e4000c901c46ULL, 0x00005e0007067625ULL, 0x088fe200078e0019ULL,
0x0000003016087810ULL, 0x040fe40007ffe0ffULL, 0x0000003816097810ULL, 0x000fe20007ffe0ffULL,
0x0000000414167824ULL, 0x000fe200078e00ffULL, 0x00000018060e7210ULL, 0x004fe20007fde0ffULL,
0x000000011d067824ULL, 0x000fe200078e0208ULL, 0x000000000800720cULL, 0x0c0fe20003f26070ULL,
0x00000004081b7824ULL, 0x000fe200078e00ffULL, 0x000000000900720cULL, 0x000fe20003f06070ULL,
0x0000000417007824ULL, 0x000fe200078e00ffULL, 0xfffffffc1a147812ULL, 0x100fe200078ee212ULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0xfffffffc16157812ULL, 0x100fe200078ee212ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0xfffffffc00007812ULL, 0x100fe200078ee212ULL,
0x000000011d087824ULL, 0x000fe200078e0209ULL, 0xfffffffc17167812ULL, 0x100fe200078ee212ULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b177812ULL, 0x000fe200078ee212ULL,
0x00005e0006067625ULL, 0x000fc600078e0019ULL, 0xfffffffc09127812ULL, 0x000fe200078ee212ULL,
0x00005e0008087625ULL, 0x000fe200078e0019ULL, 0x0000001806067210ULL, 0x000fc60007fde0ffULL,
0x0000001000007824ULL, 0x000fe400078e0213ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001808087210ULL, 0x000fe20007fde0ffULL, 0x0000001014147824ULL, 0x100fe200078e0213ULL,
0x000000000a007faeULL, 0x0005e2000e901c46ULL, 0x0000001015157824ULL, 0x100fe400078e0213ULL,
0x0000001016167824ULL, 0x100fe200078e0213ULL, 0x000000000c147faeULL, 0x0005e2000e101c46ULL,
0x0000001017177824ULL, 0x000fc400078e0213ULL, 0x0000001012127824ULL, 0x000fe200078e0213ULL,
0x0000000010157faeULL, 0x0005e2000d901c46ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x000000000e167faeULL, 0x0005e8000d101c46ULL, 0x0000000006177faeULL, 0x0005e8000c901c46ULL,
0x0000000008127faeULL, 0x0005e2000c101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe2000001162eULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x000000082e087811ULL, 0x000fc400078ff0ffULL, 0x000000102e077811ULL, 0x040fe400078ff0ffULL,
0x0000001d2e067211ULL, 0x000fe200078ff0ffULL, 0x0000000408107824ULL, 0x000fe200078e00ffULL,
0x00000003001e7812ULL, 0x000fe200078e482eULL, 0x0000000108007824ULL, 0x000fe200078e021dULL,
0x000000282e0c7811ULL, 0x040fe200078ff0ffULL, 0x000000011d087824ULL, 0x000fe200078e0207ULL,
0x000000202e0b7811ULL, 0x000fe200078ff0ffULL, 0x0000000407117824ULL, 0x000fe200078e00ffULL,
0x000000300d207812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e001fULL,
0x000000182e097811ULL, 0x000fc400078ff0ffULL, 0x000000302e0d7811ULL, 0x040fe200078ff0ffULL,
0x000000011d197824ULL, 0x000fe200078e020cULL, 0x000000382e0e7811ULL, 0x000fe200078ff0ffULL,
0x000000040c137824ULL, 0x000fe200078e00ffULL, 0xfffffffc100c7812ULL, 0x100fe200078ee21eULL,
0x000000040b127824ULL, 0x000fe200078e00ffULL, 0x0000002006107210ULL, 0x000fe20007f1e0ffULL,
0x000000011d0a7824ULL, 0x000fe200078e0209ULL, 0x0000200002217811ULL, 0x000fe200078e68ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x000fe200078ee21eULL,
0x000000011d1b7824ULL, 0x000fe200078e020dULL, 0x0ffffffc1e2e7812ULL, 0x000fe200078ef82eULL,
0x000000040d157824ULL, 0x000fe200078e00ffULL, 0xfffffffc110d7812ULL, 0x100fe200078ee21eULL,
0x000000011d0f7824ULL, 0x000fe200078e020bULL, 0xfffffffc13137812ULL, 0x100fe200078ee21eULL,
0x000000ffff117224ULL, 0x000fe200000e0607ULL, 0xfffffffc15157812ULL, 0x000fe200078ee21eULL,
0x000000011d1d7824ULL, 0x000fc400078e020eULL, 0x000000040e0b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc090e7812ULL, 0x000fe200078ee21eULL, 0x00005e0000067625ULL, 0x000fc600078e001fULL,
0xfffffffc0b1e7812ULL, 0x000fe200078ee21eULL, 0x00005e0008087625ULL, 0x000fc800078e001fULL,
0x0000001012187824ULL, 0x000fe200078e0221ULL, 0x0000002006127210ULL, 0x080fe20007f1e0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e001fULL, 0x0000002008147210ULL, 0x000fc60007f3e0ffULL,
0x00000010131a7824ULL, 0x000fe400078e0221ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000200a0a7210ULL, 0x000fe20007f1e0ffULL, 0x00000010151c7824ULL, 0x000fe400078e0221ULL,
0x000000ffff157224ULL, 0x000fe400008e0609ULL, 0x00005e000f067625ULL, 0x000fc800078e001fULL,
0x000000100c007824ULL, 0x100fe400078e0221ULL, 0x000000100d167824ULL, 0x000fe400078e0221ULL,
0x00005e0019087625ULL, 0x000fc800078e001fULL, 0x000000100e177824ULL, 0x000fe200078e0221ULL,
0x0000002008087210ULL, 0x000fe20007f3e0ffULL, 0x00005e001b0c7625ULL, 0x000fc800078e001fULL,
0x00005e001d0e7625ULL, 0x000fe200078e001fULL, 0x000000200c0c7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000002006067210ULL, 0x080fe20007f1e0ffULL,
0x000000102e2e7824ULL, 0x000fe200078e0221ULL, 0x000000200e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff097224ULL, 0x000fe400008e0609ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102e7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff0d7224ULL, 0x000fe400010e060dULL, 0x000000101e1e7824ULL, 0x000fe200078e0221ULL,
0x0000000012007faeULL, 0x0005e2000b901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600018e060fULL,
0x0000000014167faeULL, 0x0005e8000b901c46ULL, 0x000000000a177faeULL, 0x0005e8000b901c46ULL,
0x0000000006187faeULL, 0x0005e8000b901c46ULL, 0x00000000081a7faeULL, 0x0005e8000b901c46ULL,
0x000000000c1c7faeULL, 0x0005e8000b901c46ULL, 0x000000000e1e7faeULL, 0x0005e4000b901c46ULL,
0x01060400ff007984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000000ff7812ULL, 0x006fc60007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000002002007824ULL, 0x002fc800078e0200ULL, 0x0000002000057824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL,
0x000001e005057812ULL, 0x000fe400078ec0ffULL, 0x0000000104077812ULL, 0x040fe400078efcffULL,
0x0000000704067812ULL, 0x140fe400078e7800ULL, 0x0000000707077812ULL, 0x000fe400078e7800ULL,
0x0000001004107810ULL, 0x040fe20007ffe0ffULL, 0x0000000105067824ULL, 0x040fe200078e0206ULL,
0x0000001104047810ULL, 0x000fe20007ffe0ffULL, 0x0000000105077824ULL, 0x000fe200078e0207ULL,
0x0000000710107812ULL, 0x000fc400078e7800ULL, 0x00000000060c7984ULL, 0x000e62000000cc00ULL,
0x0000000704047812ULL, 0x000fe400078e7800ULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x0000000007087984ULL, 0x000ea4000000cc00ULL, 0x0000000105047824ULL, 0x000fe400078e0204ULL,
0x000000ffff147224ULL, 0x002fe400078e000cULL, 0x000000ffff157224ULL, 0x000fc400078e000eULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fe400078e000aULL,
0x000000ffff187224ULL, 0x000fe400078e000dULL, 0x000000ffff197224ULL, 0x000fe200078e000fULL,
0x0000001406007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff1b7224ULL, 0x000fca00078e000bULL, 0x0000001807007388ULL, 0x000fe8000000cc00ULL,
0x0000000004087984ULL, 0x000e68000000cc00ULL, 0x00000000100c7984ULL, 0x000ea2000000cc00ULL,
0x000000ffff1f7224ULL, 0x002fe400078e000aULL, 0x000000ffff1e7224ULL, 0x000fc400078e0008ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x004fe400078e000cULL,
0x000000ffff1d7224ULL, 0x000fe400078e000eULL, 0x000000ffff087224ULL, 0x000fe400078e000dULL,
0x000000ffff097224ULL, 0x000fe200078e000fULL, 0x0000001c10007388ULL, 0x0003e8000000cc00ULL,
0x0000000804007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ff047f8cULL, 0x002fe8000c80043fULL, 0x01060400ff007984ULL, 0x000e640000000800ULL,
0x8000000000ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000067305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000060000735dULL, 0x004fe40003800000ULL,
0x01060400ff067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002d2c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000267919ULL, 0x000e620000000000ULL,
0x3d80000027277820ULL, 0x020fe20000410000ULL, 0x0001068802287811ULL, 0x040fe200078e18ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0xffffffff2d297810ULL, 0x000fe40007ffe0ffULL,
0x00010608022a7811ULL, 0x000fe400078e28ffULL, 0x000001002c2e7824ULL, 0x000fe200078e0224ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000002e0300720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff407224ULL, 0x000fe200078e002bULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x000000ffff007224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x00000001002f7810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe20003800000ULL, 0x000000ffff477224ULL, 0x000fc400078e0000ULL,
0x00000002ff2b7819ULL, 0x100fe2000001162fULL, 0x000000ffff007224ULL, 0x000fe200078e002fULL,
0x000000042f00780cULL, 0x000fc60003f06070ULL, 0x000003002b2b7a24ULL, 0x000fc800078e022cULL,
0x000001002b317824ULL, 0x040fe200078e0224ULL, 0x000000012b307810ULL, 0x000fe40007ffe0ffULL,
0x00000001402b7812ULL, 0x000fe200078e0cffULL, 0x00006200253e7a24ULL, 0x000fe200078e0231ULL,
0x0000002d3000720cULL, 0x000fe40003f26070ULL, 0x000000032f307812ULL, 0x000fd600078ec0ffULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x00000031032f7217ULL, 0x000fe20007800000ULL,
0x00000004303c7824ULL, 0x000fe200078e00ffULL, 0x00000002ff367819ULL, 0x102fe20000011626ULL,
0x00000002023d7824ULL, 0x000fe200078e022bULL, 0x00000003ff307819ULL, 0x100fe20000011626ULL,
0x000000012f2f7824ULL, 0x000fe200078e0a31ULL, 0x0000000836317810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000000330377812ULL, 0x000fe200078e4826ULL,
0x0000000136307824ULL, 0x140fe200078e023eULL, 0x0000002f3600720cULL, 0x080fe20003f26070ULL,
0x0000000131327824ULL, 0x040fe200078e023eULL, 0x0000002f3100720cULL, 0x040fe20003f46070ULL,
0x0000000431357824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c3c7812ULL, 0x000fe200078ee226ULL,
0x00005e0030307625ULL, 0x000fe200078e003bULL, 0x000020003d3d7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc37347812ULL, 0x000fe200078ef826ULL, 0x00005e0032327625ULL, 0x000fe200078e003bULL,
0xfffffffc35357812ULL, 0x000fe400078ee237ULL, 0x0000003036397810ULL, 0x000fe20007ffe0ffULL,
0x0000001034347824ULL, 0x000fe200078e023dULL, 0x00000038363f7810ULL, 0x000fe20007ffe0ffULL,
0x000000103c307825ULL, 0x040fe200078e0030ULL, 0x0000002f3900720cULL, 0x080fe40003fa6070ULL,
0x0000002f3f00720cULL, 0x000fe20003fc6070ULL, 0x0000001035357824ULL, 0x000fe200078e023dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030347faeULL, 0x0003e2000c901c46ULL,
0x000000103c327825ULL, 0x000fc800078e0032ULL, 0x0000000439427824ULL, 0x000fe200078e00ffULL,
0x0000000032357faeULL, 0x0005e2000d101c46ULL, 0x000000043f437824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x100fe200078e023eULL, 0xfffffffc42427812ULL, 0x000fe200078ee237ULL,
0x000000013f3a7824ULL, 0x100fe200078e023eULL, 0x0000001036317810ULL, 0x002fe20007ffe0ffULL,
0x00005e0038387625ULL, 0x000fe200078e003bULL, 0x0000001836347810ULL, 0x040fe40007ffe0ffULL,
0x0000002f3100720cULL, 0x0c0fe20003f26070ULL, 0x0000000131307824ULL, 0x100fe200078e023eULL,
0x0000002036337810ULL, 0x004fe20007ffe0ffULL, 0x0000000134327824ULL, 0x000fe200078e023eULL,
0x0000002836357810ULL, 0x000fe20007ffe0ffULL, 0x000000103c387825ULL, 0x000fe200078e0038ULL,
0x0000002f3400720cULL, 0x000fc40003f46070ULL, 0x0000002f3300720cULL, 0x080fe20003f66070ULL,
0x0000000435417824ULL, 0x040fe200078e00ffULL, 0x0000002f3500720cULL, 0x000fe20003f86070ULL,
0x00000004312f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc43437812ULL, 0x100fe200078ee237ULL,
0x0000000434317824ULL, 0x000fe200078e00ffULL, 0xfffffffc41417812ULL, 0x100fe200078ee237ULL,
0x0000000133347824ULL, 0x100fe200078e023eULL, 0xfffffffc2f2f7812ULL, 0x100fe200078ee237ULL,
0x0000000433337824ULL, 0x000fe400078e00ffULL, 0x0000000135367824ULL, 0x000fe200078e023eULL,
0xfffffffc313e7812ULL, 0x100fe200078ee237ULL, 0x00005e0030307625ULL, 0x000fe200078e003bULL,
0xfffffffc333f7812ULL, 0x000fc600078ee237ULL, 0x00005e0032327625ULL, 0x000fc800078e003bULL,
0x00005e0034347625ULL, 0x000fc800078e003bULL, 0x00005e0036367625ULL, 0x000fc800078e003bULL,
0x00005e003a3a7625ULL, 0x000fc800078e003bULL, 0x000000103c307825ULL, 0x000fc800078e0030ULL,
0x000000103c327825ULL, 0x000fc800078e0032ULL, 0x000000103c347825ULL, 0x000fc800078e0034ULL,
0x000000103c367825ULL, 0x000fc800078e0036ULL, 0x000000103c3a7825ULL, 0x000fc800078e003aULL,
0x000000102f2f7824ULL, 0x100fe400078e023dULL, 0x000000103e3c7824ULL, 0x100fe400078e023dULL,
0x000000103f3e7824ULL, 0x100fe200078e023dULL, 0x00000000302f7faeULL, 0x0003e2000c901c46ULL,
0x00000010413f7824ULL, 0x100fe400078e023dULL, 0x0000001042417824ULL, 0x100fe200078e023dULL,
0x00000000323c7faeULL, 0x0003e2000d101c46ULL, 0x00000010433d7824ULL, 0x000fc600078e023dULL,
0x00000000343e7faeULL, 0x0003e8000d901c46ULL, 0x00000000363f7faeULL, 0x0003e8000e101c46ULL,
0x0000000038417faeULL, 0x0003e8000e901c46ULL, 0x000000003a3d7faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x0000000202327824ULL, 0x000fe200078e022bULL,
0x0000000826347811ULL, 0x002fe200078ff0ffULL, 0x00000004302f7824ULL, 0x000fe200078e00ffULL,
0x0000001026357811ULL, 0x040fe200078ff0ffULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x0000001826377811ULL, 0x000fe200078ff0ffULL, 0x0000000434427824ULL, 0x000fe200078e00ffULL,
0x0000002026397811ULL, 0x040fe200078ff0ffULL, 0x0000000435437824ULL, 0x000fe200078e00ffULL,
0x00000028263b7811ULL, 0x040fe200078ff0ffULL, 0x0000000437447824ULL, 0x000fe200078e00ffULL,
0x00000030263d7811ULL, 0x040fe200078ff0ffULL, 0x0000000439457824ULL, 0x000fe200078e00ffULL,
0x0000003826417811ULL, 0x000fe200078ff0ffULL, 0x000000043b497824ULL, 0x000fe200078e00ffULL,
0x00000003ff317819ULL, 0x000fe20000011626ULL, 0x000000043d4a7824ULL, 0x000fe200078e00ffULL,
0x0000200032467811ULL, 0x000fe200078e60ffULL, 0x00000004414b7824ULL, 0x000fe200078e00ffULL,
0x0000003e26307211ULL, 0x000fe200078ff0ffULL, 0x0000000134327824ULL, 0x000fe200078e023eULL,
0x0000000331337812ULL, 0x000fe200078e4826ULL, 0x0000000135347824ULL, 0x000fe200078e023eULL,
0xfffffffc2f2f7812ULL, 0x000fe200078ee226ULL, 0x0000000137367824ULL, 0x100fe200078e023eULL,
0xfffffffc42427812ULL, 0x100fe200078ee233ULL, 0x0000000139387824ULL, 0x100fe200078e023eULL,
0xfffffffc43437812ULL, 0x100fe200078ee233ULL, 0x000000013b3a7824ULL, 0x100fe200078e023eULL,
0xfffffffc44447812ULL, 0x100fe200078ee233ULL, 0x000000013d3c7824ULL, 0x100fe200078e023eULL,
0xfffffffc45457812ULL, 0x100fe200078ee233ULL, 0x00000001413e7824ULL, 0x000fe200078e023eULL,
0xfffffffc49497812ULL, 0x100fe200078ee233ULL, 0x00005e0030307625ULL, 0x000fe200078e003fULL,
0xfffffffc4a4a7812ULL, 0x000fc400078ee233ULL, 0xfffffffc4b4b7812ULL, 0x000fe200078ee233ULL,
0x00005e0034347625ULL, 0x000fe200078e003fULL, 0x0ffffffc33417812ULL, 0x000fc600078ef826ULL,
0x00005e0032327625ULL, 0x000fc800078e003fULL, 0x00005e0036367625ULL, 0x000fc800078e003fULL,
0x00005e0038387625ULL, 0x000fc800078e003fULL, 0x00005e003a3a7625ULL, 0x000fc800078e003fULL,
0x00005e003c3c7625ULL, 0x000fc800078e003fULL, 0x00005e003e3e7625ULL, 0x000fc800078e003fULL,
0x000000102f307825ULL, 0x000fc800078e0030ULL, 0x000000102f327825ULL, 0x000fc800078e0032ULL,
0x000000102f347825ULL, 0x000fc800078e0034ULL, 0x000000102f367825ULL, 0x000fc800078e0036ULL,
0x000000102f387825ULL, 0x000fc800078e0038ULL, 0x000000102f3a7825ULL, 0x000fc800078e003aULL,
0x000000102f3c7825ULL, 0x000fc800078e003cULL, 0x000000102f3e7825ULL, 0x000fc800078e003eULL,
0x0000001041487824ULL, 0x100fe400078e0246ULL, 0x00000010422f7824ULL, 0x100fe400078e0246ULL,
0x0000001043417824ULL, 0x100fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030487faeULL, 0x0003e2000b901c46ULL, 0x0000001044427824ULL, 0x100fe400078e0246ULL,
0x0000001045437824ULL, 0x100fe200078e0246ULL, 0x00000000322f7faeULL, 0x0003e2000b901c46ULL,
0x0000001049447824ULL, 0x000fc400078e0246ULL, 0x000000104a457824ULL, 0x100fe200078e0246ULL,
0x0000000034417faeULL, 0x0003e2000b901c46ULL, 0x000000104b467824ULL, 0x000fc600078e0246ULL,
0x0000000036427faeULL, 0x0003e8000b901c46ULL, 0x0000000038437faeULL, 0x0003e8000b901c46ULL,
0x000000003a447faeULL, 0x0003e8000b901c46ULL, 0x000000003c457faeULL, 0x0003e8000b901c46ULL,
0x000000003e467faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002026307810ULL, 0x002fe20007ffe0ffULL,
0x00000002023f7824ULL, 0x000fe200078e0240ULL, 0xfffffff8263d7812ULL, 0x000fe200078ec0ffULL,
0x00000008472f7824ULL, 0x000fe200078e00ffULL, 0xfffffff830407812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000000073d3d7812ULL, 0x000fc400078ef826ULL,
0x0000000740407812ULL, 0x000fe400078ef826ULL, 0x00000007263e7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff417819ULL, 0x000fe4000001163dULL, 0x00000001ff427819ULL, 0x000fe40000011640ULL,
0x000020003f3f7811ULL, 0x000fe400078e60ffULL, 0x000000083e3e7812ULL, 0x000fc400078ef826ULL,
0x0000000341417812ULL, 0x000fe400078ec0ffULL, 0x0000000342427812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000003c41307212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000003c42347212ULL, 0x000fc600078e3cffULL,
0x000000043d307824ULL, 0x000fe400078e0230ULL, 0x0000000440347824ULL, 0x000fe400078e0234ULL,
0x0000001030307824ULL, 0x100fe400078e023fULL, 0x0000001034347824ULL, 0x000fc800078e023fULL,
0x000000003030783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x00000018ff387819ULL, 0x002fe20000011430ULL, 0x0001000030397824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011433ULL, 0x00000038004b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff467819ULL, 0x004fc40000011434ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff457819ULL, 0x000fe40000011435ULL, 0x00000018ff447819ULL, 0x000fe20000011436ULL,
0x00000039004a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff387819ULL, 0x002fe40000011431ULL,
0x00000018ff437819ULL, 0x000fca0000011437ULL, 0x00000038004f7306ULL, 0x0003f00000200c00ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000018ff387819ULL, 0x002fce0000011432ULL,
0x0000003800537306ULL, 0x0003f00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000888030387816ULL, 0x042fe200000000ffULL, 0x0000010030307824ULL, 0x000fca00078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0000003800497306ULL, 0x0002b00000200c00ULL,
0x00000030004c7306ULL, 0x0007220000200c00ULL, 0x0000888031387816ULL, 0x002fc400000000ffULL,
0x00005410494a7816ULL, 0x004fc6000000004aULL, 0x000000ffff307224ULL, 0x008fe400078e0038ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0001000031387824ULL, 0x040fe400078e00ffULL,
0x0000010031317824ULL, 0x000fc600078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x00000030004d7306ULL, 0x0003e20000200c00ULL,
0x000054104c4b7816ULL, 0x010fce000000004bULL, 0x0000003100507306ULL, 0x0004e20000200c00ULL,
0x0000888032307816ULL, 0x002fce00000000ffULL, 0x0000003000517306ULL, 0x0003e20000200c00ULL,
0x0001000032317824ULL, 0x044fe400078e00ffULL, 0x0000010032327824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x00000038004e7306ULL, 0x000ea20000200c00ULL, 0x0000888033307816ULL, 0x002fe400000000ffULL,
0x00005410504f7816ULL, 0x008fca000000004fULL, 0x0000003100527306ULL, 0x0002f00000200c00ULL,
0x0000003200547306ULL, 0x0009620000200c00ULL, 0x0001000033317824ULL, 0x002fe200078e00ffULL,
0x000054104d4e7816ULL, 0x004fe2000000004eULL, 0x0000010033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000003000557306ULL, 0x0003e20000200c00ULL, 0x000000013c327810ULL, 0x050fe40007ffe0ffULL,
0x0000541051527816ULL, 0x008fe40000000052ULL, 0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL,
0x0000541054537816ULL, 0x020fe20000000053ULL, 0x0000003100567306ULL, 0x0004e20000200c00ULL,
0x0000888034307816ULL, 0x002fc400000000ffULL, 0x000000043c00780cULL, 0x000fca0003f25270ULL,
0x0000003300577306ULL, 0x000e620000200c00ULL, 0x0001000034317824ULL, 0x044fe400078e00ffULL,
0x0000010034347824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003000587306ULL, 0x0005e20000200c00ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x0000541055567816ULL, 0x008fca0000000056ULL, 0x0000003100597306ULL, 0x0007220000200c00ULL,
0x0000888035307816ULL, 0x004fe400000000ffULL, 0x0000541057577816ULL, 0x002fca0000000047ULL,
0x00000030005b7306ULL, 0x0003e20000200c00ULL, 0x0000003241317212ULL, 0x088fe400078e3cffULL,
0x0000003242327212ULL, 0x000fc600078e3cffULL, 0x000000043d337824ULL, 0x000fe400078e0231ULL,
0x0001000035317824ULL, 0x000fe200078e00ffULL, 0x0000888036307816ULL, 0x002fe200000000ffULL,
0x0000001033337824ULL, 0x000fe200078e023fULL, 0x00000034005a7306ULL, 0x0002a20000200c00ULL,
0x0000000440327824ULL, 0x000fe200078e0232ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x0000010035357824ULL, 0x000fe200078e00ffULL, 0x000000003338783bULL, 0x000ee20000000200ULL,
0x0000001032327824ULL, 0x000fe200078e023fULL, 0x0000541058587816ULL, 0x010fc40000000059ULL,
0x00000031005c7306ULL, 0x0009620000200c00ULL, 0x0000888037347816ULL, 0x002fe400000000ffULL,
0x00000018ff357819ULL, 0x000fca0000011435ULL, 0x00000030005e7306ULL, 0x000fe20000200c00ULL,
0x0001000036317824ULL, 0x010fe200078e00ffULL, 0x000054105a597816ULL, 0x004fe20000000046ULL,
0x0000010036367824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x0000003400617306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x000054105b5c7816ULL, 0x020fca000000005cULL, 0x00000031005f7306ULL, 0x0002b00000200c00ULL,
0x00000035005d7306ULL, 0x0009620000200c00ULL, 0x000000003230783bULL, 0x002e620000000200ULL,
0x00000018ff347819ULL, 0x008fc40000011438ULL, 0x000088803a6c7816ULL, 0x000fc800000000ffULL,
0x0000003400667306ULL, 0x0007e20000200c00ULL, 0x0001000037357824ULL, 0x050fe200078e00ffULL,
0x000054105e5e7816ULL, 0x004fe2000000005fULL, 0x0000010037377824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003600607306ULL, 0x0005e20000200c00ULL,
0x00000018ff347819ULL, 0x008fe40000011439ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x000054105d5d7816ULL, 0x020fc60000000045ULL, 0x00000034006a7306ULL, 0x0007e20000200c00ULL,
0x0001000039367824ULL, 0x004fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x0000003500627306ULL, 0x0005220000200c00ULL, 0x00000018ff347819ULL, 0x008fce000001143aULL,
0x00000034006e7306ULL, 0x0007e20000200c00ULL, 0x0001000038357824ULL, 0x004fe200078e00ffULL,
0x0000888032467816ULL, 0x002fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe40000011433ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000003700637306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x008fe4000001143bULL, 0x0000541061627816ULL, 0x010fca0000000062ULL,
0x0000003400727306ULL, 0x0003f00000200c00ULL, 0x0000003500657306ULL, 0x0005e20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011430ULL, 0x0000003400747306ULL, 0x0003e20000200c00ULL,
0x0000888039357816ULL, 0x044fe200000000ffULL, 0x0000010039397824ULL, 0x000fca00078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000003500687306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011431ULL, 0x0000003400757306ULL, 0x0003f00000200c00ULL,
0x0000003600697306ULL, 0x000ea20000200c00ULL, 0x00000018ff347819ULL, 0x002fce0000011432ULL,
0x0000003400767306ULL, 0x0003f00000200c00ULL, 0x00000039006b7306ULL, 0x0007e20000200c00ULL,
0x0000888038347816ULL, 0x042fe200000000ffULL, 0x0000010038387824ULL, 0x000fe200078e00ffULL,
0x0000541068687816ULL, 0x004fca0000000069ULL, 0x0000003400647306ULL, 0x0002a20000200c00ULL,
0x000000ffff397224ULL, 0x008fe400078e006cULL, 0x000100003a6c7824ULL, 0x040fe400078e00ffULL,
0x000001003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000039006d7306ULL, 0x0007e20000200c00ULL,
0x00000018ff347819ULL, 0x002fe40000011438ULL, 0x0000002f26387211ULL, 0x000fe400078fe0ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000003400677306ULL, 0x0003220000200c00ULL, 0x000088803b397816ULL, 0x008fe400000000ffULL,
0x0000541064647816ULL, 0x004fc40000000065ULL, 0x000054106b697816ULL, 0x000fe4000000006aULL,
0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000003a006f7306ULL, 0x0005e20000200c00ULL,
0x0000000738347812ULL, 0x042fe400078e783eULL, 0x0000000238387810ULL, 0x000fc60007ffe0ffULL,
0x000000203e347824ULL, 0x000fe200078e0234ULL, 0x0000000738387812ULL, 0x000fe200078e783eULL,
0x0000003900707306ULL, 0x0003e20000200c00ULL, 0x000100003b3a7824ULL, 0x004fe200078e00ffULL,
0x0000541067657816ULL, 0x010fe20000000066ULL, 0x0000001034347824ULL, 0x000fe400078e00ffULL,
0x000001003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x000000203e387824ULL, 0x000fe200078e0238ULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000888030397816ULL, 0x002fe200000000ffULL,
0x0000001038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3b7819ULL, 0x000fc8000001143bULL,
0x0000003a00717306ULL, 0x0003300000200c00ULL, 0x0000003900497306ULL, 0x000be20000200c00ULL,
0x00010000303a7824ULL, 0x002fe200078e00ffULL, 0x00005410605f7816ULL, 0x004fe20000000044ULL,
0x0001000032447824ULL, 0x000fc400078e00ffULL, 0x0000010032327824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x0000010030397824ULL, 0x020fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff327819ULL, 0x000fe40000011432ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000003b00737306ULL, 0x000ea20000200c00ULL, 0x0000541070707816ULL, 0x010fce0000000071ULL,
0x0000003a00307306ULL, 0x000f220000200c00ULL, 0x0000004a3404723cULL, 0x008fe20000001804ULL,
0x0000541063637816ULL, 0x002fcc0000000043ULL, 0x00008880314b7816ULL, 0x000fe200000000ffULL,
0x00000039004a7306ULL, 0x0003e20000200c00ULL, 0x0000004e3408723cULL, 0x040fe20000001808ULL,
0x0000541073717816ULL, 0x004fe40000000072ULL, 0x000000ffff477224ULL, 0x000fe400078e004bULL,
0x00010000314b7824ULL, 0x000fe200078e00ffULL, 0x0000541049307816ULL, 0x010fe20000000030ULL,
0x0000010031317824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x002e620000000200ULL,
0x00000052340c723cULL, 0x000fe2000000180cULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff317819ULL, 0x000fca0000011431ULL,
0x000000563410723cULL, 0x040fe40000001810ULL, 0x0000003100457306ULL, 0x00072c0000200c00ULL,
0x000000583414723cULL, 0x000fe40000001814ULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000000ffff317224ULL, 0x008fe200078e0046ULL, 0x000054106d6c7816ULL, 0x004fc4000000006cULL,
0x000054106f6d7816ULL, 0x000fe4000000006eULL, 0x0000005c3418723cULL, 0x040fe40000001818ULL,
0x0000003100467306ULL, 0x0005ec0000200c00ULL, 0x0000005e341c723cULL, 0x000fe4000000181cULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000888033317816ULL, 0x004fca00000000ffULL,
0x000000623420723cULL, 0x000fe40000001820ULL, 0x0000003100357306ULL, 0x0005ea0000200c00ULL,
0x0001000033347824ULL, 0x040fe200078e00ffULL, 0x000000643804723cULL, 0x002fe20000001804ULL,
0x0000010033337824ULL, 0x000fe200078e00ffULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000054104a317816ULL, 0x004fc40000000074ULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x000000683808723cULL, 0x040fe40000001808ULL,
0x0000004400447306ULL, 0x000eac0000200c00ULL, 0x000000303814723cULL, 0x040fe40000001814ULL,
0x0000003400347306ULL, 0x000eea0000200c00ULL, 0x0000541045317816ULL, 0x010fe20000000075ULL,
0x0000006c380c723cULL, 0x000fe2000000180cULL, 0x0000541047307816ULL, 0x002fe2000000004bULL,
0x0000003200327306ULL, 0x000e620000200c00ULL, 0x0000541046447816ULL, 0x004fca0000000044ULL,
0x000000703810723cULL, 0x000fe40000001810ULL, 0x0000003300337306ULL, 0x000ea20000200c00ULL,
0x0000541035347816ULL, 0x008fca0000000034ULL, 0x000000303818723cULL, 0x000fe20000001818ULL,
0x0000541032457816ULL, 0x002fce0000000076ULL, 0x00000044381c723cULL, 0x000fe2000000181cULL,
0x0000541033357816ULL, 0x004fce0000000048ULL, 0x000000343820723cULL, 0x000fe20000001820ULL,
0xfffff0c000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff407224ULL, 0x000fe200078e002bULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe4c000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000028307f8cULL, 0x000fe2000c80043fULL,
0x0000001227377220ULL, 0x040fe20000410000ULL, 0x0000001327387220ULL, 0x040fe20000410000ULL,
0x0000001427127220ULL, 0x040fe20000410000ULL, 0x0000040028007984ULL, 0x000e620000000800ULL,
0x0000001527137220ULL, 0x040fe20000410000ULL, 0x00000006272f7220ULL, 0x040fe20000410000ULL,
0x0000000727327220ULL, 0x040fe20000410000ULL, 0x0000000a27337220ULL, 0x040fe20000410000ULL,
0x0000000b27347220ULL, 0x040fe20000410000ULL, 0x0000000e27357220ULL, 0x040fe20000410000ULL,
0x0000000f27367220ULL, 0x040fe20000410000ULL, 0x0000001827147220ULL, 0x040fe20000410000ULL,
0x0000001927157220ULL, 0x040fe20000410000ULL, 0x0000000427047220ULL, 0x040fe20000410000ULL,
0x0000000527057220ULL, 0x040fe20000410000ULL, 0x0000000827087220ULL, 0x040fe20000410000ULL,
0x0000000927097220ULL, 0x040fe20000410000ULL, 0x0000000c27067220ULL, 0x040fe20000410000ULL,
0x0000000d27077220ULL, 0x040fe20000410000ULL, 0x0000001627397220ULL, 0x040fe20000410000ULL,
0x00000017273a7220ULL, 0x040fe20000410000ULL, 0x0000001a27187220ULL, 0x040fe20000410000ULL,
0x0000001b27197220ULL, 0x040fe20000410000ULL, 0x0000001e273b7220ULL, 0x040fe20000410000ULL,
0x0000001f273c7220ULL, 0x040fe20000410000ULL, 0x0000001c27167220ULL, 0x040fe20000410000ULL,
0x0000001d27177220ULL, 0x040fe20000410000ULL, 0x00000020271a7220ULL, 0x040fe20000410000ULL,
0x00000021271b7220ULL, 0x040fe20000410000ULL, 0x00000022273d7220ULL, 0x040fe20000410000ULL,
0x00000023273e7220ULL, 0x040fe20000410000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e002fULL,
0x0000001027107220ULL, 0x040fe20000410000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0032ULL,
0x0000001127117220ULL, 0x000fe20000410000ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0033ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff207224ULL, 0x000fe400078e0035ULL,
0x000000ffff217224ULL, 0x000fe200078e0036ULL, 0x8000000000ff7812ULL, 0x002fe20007804831ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff227224ULL, 0x000fe400078e0037ULL, 0x000000ffff237224ULL, 0x000fe400078e0038ULL,
0x000000ffff2f7224ULL, 0x000fc400078e0039ULL, 0x000000ffff327224ULL, 0x000fe400078e003aULL,
0x000000ffff337224ULL, 0x000fe400078e0018ULL, 0x000000ffff347224ULL, 0x000fe400078e0019ULL,
0x000000ffff357224ULL, 0x000fe400078e003bULL, 0x000000ffff367224ULL, 0x000fe200078e003cULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff377224ULL, 0x000fc400078e003dULL, 0x000000ffff387224ULL, 0x000fe200078e003eULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000047305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000040000735dULL, 0x004fe40003800000ULL, 0x0000040028047984ULL, 0x000e640000000800ULL,
0x8000000004ff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000426197824ULL, 0x000fe200078e00ffULL, 0x000000292c00720cULL, 0x000fc80003f05270ULL,
0xfffffff019187812ULL, 0x000fca00078ec0ffULL, 0x0000008002187824ULL, 0x000fca00078e0218ULL,
0x0104000018047984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000226007824ULL, 0x000fe400078e00ffULL, 0x00000001032e7824ULL, 0x000fc600078e0a2eULL,
0x0000000600007812ULL, 0x000fc800078ec0ffULL, 0x0000000100087812ULL, 0x040fe400078efcffULL,
0x0000000800097812ULL, 0x000fe400078efcffULL, 0x0000002e0800720cULL, 0x080fe40003f26070ULL,
0x0000001000087812ULL, 0x000fe400078efcffULL, 0x0000002e0900720cULL, 0x080fe40003f06070ULL,
0x0000002e0800720cULL, 0x000fc40003fc6070ULL, 0x0000001100097812ULL, 0x040fe400078efcffULL,
0x0000001800087812ULL, 0x040fe400078efcffULL, 0x0000002e0000720cULL, 0x080fe40003f46070ULL,
0x0000002e0900720cULL, 0x080fe40003fa6070ULL, 0x0000002e0800720cULL, 0x000fe40003f66070ULL,
0x0000000900307812ULL, 0x000fc400078efcffULL, 0x0000001900097812ULL, 0x040fe400078efcffULL,
0x0000002000087812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fe40005000000ULL,
0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004800000ULL,
0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL, 0x0000002e3000720cULL, 0x080fe40003f86070ULL,
0x0000002e0900720cULL, 0x080fe40003f46070ULL, 0x0000002e0800720cULL, 0x000fe40003f26070ULL,
0x0000002100097812ULL, 0x040fe400078efcffULL, 0x0000002800087812ULL, 0x000fe400078efcffULL,
0xff7fffff1e1e7808ULL, 0x000fc40004000000ULL, 0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL,
0x0000002e0900720cULL, 0x080fe40003f06070ULL, 0x0000002e0800720cULL, 0x000fe40003f86070ULL,
0x0000002900097812ULL, 0x000fc400078efcffULL, 0x0000003000087812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40007000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL,
0xff7fffff21217808ULL, 0x000fe40006800000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL,
0x0000002e0900720cULL, 0x000fc40003fc6070ULL, 0x0000002e0800720cULL, 0x000fe40003fa6070ULL,
0x0000003100097812ULL, 0x040fe400078efcffULL, 0x0000003800087812ULL, 0x040fe400078efcffULL,
0x0000003900007812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005800000ULL,
0xff7fffff10107808ULL, 0x000fc40005800000ULL, 0xff7fffff23237808ULL, 0x000fe40005000000ULL,
0xff7fffff11117808ULL, 0x000fe40005000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40004800000ULL,
0xff7fffff12127808ULL, 0x000fe40004800000ULL, 0x0000002e0900720cULL, 0x080fe40003f66070ULL,
0x0000002e0800720cULL, 0x000fc40003f46070ULL, 0x0000002e0000720cULL, 0x000fe40003f26070ULL,
0xff7fffff32327808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40004000000ULL,
0xff7fffff33337808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff34347808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff35357808ULL, 0x000fe40006800000ULL, 0xff7fffff16167808ULL, 0x000fe40006800000ULL,
0xff7fffff36367808ULL, 0x000fe40005800000ULL, 0xff7fffff17177808ULL, 0x000fe40005800000ULL,
0xff7fffff37377808ULL, 0x000fc40005000000ULL, 0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL,
0xff7fffff38387808ULL, 0x000fe40004800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL,
0x0000000a04047209ULL, 0x004fe20007810000ULL, 0x0000001fff317424ULL, 0x000fe200078e00ffULL,
0x0000001c05057209ULL, 0x000fe20007810000ULL, 0xffffffffff397424ULL, 0x000fe200078e00ffULL,
0x0000000b04047209ULL, 0x000fe40007810000ULL, 0x0000001d05057209ULL, 0x000fc40007810000ULL,
0x0000000c04047209ULL, 0x000fe40007810000ULL, 0x0000001e05057209ULL, 0x000fe40007810000ULL,
0x0000000d04047209ULL, 0x000fe40007810000ULL, 0x0000001f05057209ULL, 0x000fe40007810000ULL,
0x0000000e04047209ULL, 0x000fe40007810000ULL, 0x0000002005057209ULL, 0x000fc40007810000ULL,
0x0000000f04047209ULL, 0x000fe40007810000ULL, 0x0000002105057209ULL, 0x000fe40007810000ULL,
0x0000001004047209ULL, 0x000fe40007810000ULL, 0x0000002205057209ULL, 0x000fe40007810000ULL,
0x0000001104047209ULL, 0x000fe40007810000ULL, 0x0000002305057209ULL, 0x000fc40007810000ULL,
0x0000001204047209ULL, 0x000fe40007810000ULL, 0x0000002f05057209ULL, 0x000fe40007810000ULL,
0x0000001304047209ULL, 0x000fe40007810000ULL, 0x0000003205057209ULL, 0x000fe40007810000ULL,
0x0000001404047209ULL, 0x000fe40007810000ULL, 0x0000003305057209ULL, 0x000fc40007810000ULL,
0x0000001504047209ULL, 0x000fe40007810000ULL, 0x0000003405057209ULL, 0x000fe40007810000ULL,
0x0000001604047209ULL, 0x000fe40007810000ULL, 0x0000003505057209ULL, 0x000fe40007810000ULL,
0x0000001704047209ULL, 0x000fe40007810000ULL, 0x0000003605057209ULL, 0x000fc40007810000ULL,
0x0000001a04047209ULL, 0x000fe40007810000ULL, 0x0000003705057209ULL, 0x000fe40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x00000038052e7209ULL, 0x000fe20007810000ULL,
0x00001ae27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0004007f89ULL, 0x0004e400000e0000ULL,
0x0000000004307209ULL, 0x00cfe20007810000ULL, 0x00001b027f007947ULL, 0x000fea000b800000ULL,
0x0c401f002e007f89ULL, 0x000ea800000e0000ULL, 0x0c401f0006047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0007057f89ULL, 0x000f2200000e0000ULL, 0x000000002e007209ULL, 0x004fc40007810000ULL,
0x0000000406067209ULL, 0x008fc60007810000ULL, 0x0c201f0000087f89ULL, 0x000ea200000e0000ULL,
0x0000000507077209ULL, 0x010fc60007810000ULL, 0x0c201f0030047f89ULL, 0x000ee800000e0000ULL,
0x0c201f0006097f89ULL, 0x000f2800000e0000ULL, 0x0c201f00072e7f89ULL, 0x00026200000e0000ULL,
0x0000000800057209ULL, 0x004fe40007810000ULL, 0x0000000430047209ULL, 0x008fc40007810000ULL,
0x0000000906067209ULL, 0x010fc60007810000ULL, 0x3fb8aa3b04007820ULL, 0x000fe20000410000ULL,
0x3c003c00ff307424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3c003c00ff317424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010800ULL,
0x0000000a00087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010800ULL,
0x0000000c000a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010800ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010800ULL,
0x3fb8aa3b1b007823ULL, 0x000fe20000010800ULL, 0x0000000fff1b7424ULL, 0x000fe200078e00ffULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x000000072e077209ULL, 0x002fe20007810000ULL,
0x0000000e000c7308ULL, 0x000ff00000000800ULL, 0x00000010000e7308ULL, 0x000ff00000000800ULL,
0x0000001200107308ULL, 0x000ff00000000800ULL, 0x0000001400127308ULL, 0x000ff00000000800ULL,
0x0000001600147308ULL, 0x000ff00000000800ULL, 0x0000001a00167308ULL, 0x0003f00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b051a7820ULL, 0x002fc80000410000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001081aULL,
0x0000000d000d7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001081aULL, 0x000000080b08723eULL, 0x004fe200000000ffULL,
0x0000001c00097308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b381a7823ULL, 0x000fc4000001081aULL, 0x0000001d001d7308ULL, 0x000ea20000000800ULL,
0x0000000a0d0a723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x000000091d09723eULL, 0x004fce00000000ffULL,
0x0000000f000f7308ULL, 0x000ea20000000800ULL, 0x0000001e1f0b723eULL, 0x002fce00000000ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x00000030081c723cULL, 0x000fe200000018ffULL,
0x0000000c0f0c723eULL, 0x004fcc00000000ffULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x0000000e110e723eULL, 0x002fce00000000ffULL,
0x0000002200227308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x00000020210d723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x00000022230f723eULL, 0x002fce00000000ffULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0x000000300c1c723cULL, 0x000fe2000000181cULL, 0x000000101310723eULL, 0x004fcc00000000ffULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x000000121512723eULL, 0x002fe400000000ffULL, 0xfffffffc26157812ULL, 0x000fc800078ec0ffULL,
0x000000151b1b7219ULL, 0x000fe200000006ffULL, 0x0000003300337308ULL, 0x000fe60000000800ULL,
0x000000001b2073a1ULL, 0x000e6200000e8000ULL, 0x000000001b0473c4ULL, 0x000ee80000004000ULL,
0x0000003400347308ULL, 0x000f220000000800ULL, 0x0000002f3211723eULL, 0x004fce00000000ffULL,
0x0000001700177308ULL, 0x000ea20000000800ULL, 0x000000333413723eULL, 0x010fce00000000ffULL,
0x0000000000007308ULL, 0x000f220000000800ULL, 0x000000051bff7c12ULL, 0x002fe2000f804020ULL,
0x00000030101c723cULL, 0x000fe2000000181cULL, 0x000000141714723eULL, 0x004fca00000000ffULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0x000000160016723eULL, 0x010fce00000000ffULL, 0x0000003700377308ULL, 0x000ff00000000800ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x000000353615723eULL, 0x002fe400000000ffULL,
0x000000371a17723eULL, 0x004fce00000000ffULL, 0x00000030141c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000164204008947ULL, 0x008fde000b800000ULL,
0x001c1fff1c1c7589ULL, 0x0002a400000e0000ULL, 0x000000001b0073a1ULL, 0x000ee200000e8000ULL,
0x000000001b0473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x000000051bff7c12ULL, 0x008fda000f804000ULL, 0x0000166204008947ULL, 0x010fea000b800000ULL,
0x001c1fff1e1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff1e1e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff007819ULL, 0x000fe40000011626ULL,
0x0000000c19367812ULL, 0x000fc400078ec0ffULL, 0x00000007001a7812ULL, 0x040fe200078ec0ffULL,
0x00000008001b7824ULL, 0x04afe200078e00ffULL, 0x00000000ff317212ULL, 0x000fe200078e33ffULL,
0x0000000800207824ULL, 0x000fe200078e00ffULL, 0x0000000326ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000800327824ULL, 0x040fe200078e00ffULL, 0x0000000800007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b1b7812ULL, 0x100fe400078ee21aULL, 0x0000000120217812ULL, 0x100fe200078ef61aULL,
0x00000008003a7824ULL, 0x000fe200078e00ffULL, 0x0000000220227812ULL, 0x100fe200078ef61aULL,
0x0000000800337824ULL, 0x000fe200078e00ffULL, 0x0000000320237812ULL, 0x000fc400078ef61aULL,
0x00000004202e7812ULL, 0x140fe400078ef61aULL, 0x00000005202f7812ULL, 0x140fe400078ef61aULL,
0x0000000620307812ULL, 0x000fe200078ef61aULL, 0x0000000800207824ULL, 0x000fe200078e00ffULL,
0xfffffff832317812ULL, 0x000fe400078ee231ULL, 0x00000000ff327212ULL, 0x000fe400078e33ffULL,
0x00000007001a7812ULL, 0x000fc400078ec0ffULL, 0x0000a00002007811ULL, 0x000fe400078e58ffULL,
0xfffffff83a3a7812ULL, 0x000fe400078ee232ULL, 0xfffffff833327812ULL, 0x000fe200078ee21aULL,
0x000000101b197824ULL, 0x000fe200078e0200ULL, 0x0000000120337812ULL, 0x000fe200078ef61aULL,
0x00000010221b7824ULL, 0x000fe200078e0200ULL, 0x0000000220347812ULL, 0x100fe200078ef61aULL,
0x0000000136197824ULL, 0x000fe200078e0219ULL, 0x0000000320357812ULL, 0x040fe200078ef61aULL,
0x000000102f227824ULL, 0x000fe200078e0200ULL, 0x0000000420377812ULL, 0x100fe200078ef61aULL,
0x00000001361b7824ULL, 0x000fe200078e021bULL, 0x0000000520387812ULL, 0x000fe200078ef61aULL,
0x00000010322f7824ULL, 0x000fe200078e0200ULL, 0x0000000620397812ULL, 0x000fe200078ef61aULL,
0x00000010211a7824ULL, 0x100fe200078e0200ULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x0000001023207824ULL, 0x000fc400078e0200ULL, 0x000000102e217824ULL, 0x000fe400078e0200ULL,
0x00000001361a7824ULL, 0x000fe400078e021aULL, 0x0000001030237824ULL, 0x100fe400078e0200ULL,
0x00000010312e7824ULL, 0x000fe200078e0200ULL, 0x0000000a1a007388ULL, 0x0003e20000000800ULL,
0x0000000136207824ULL, 0x040fe400078e0220ULL, 0x0000000136217824ULL, 0x000fe200078e0221ULL,
0x0000000c1b007388ULL, 0x0003e20000000800ULL, 0x0000001033307824ULL, 0x000fc400078e0200ULL,
0x0000000136227824ULL, 0x000fe200078e0222ULL, 0x0000000e20007388ULL, 0x0003e20000000800ULL,
0x0000001034317824ULL, 0x100fe400078e0200ULL, 0x0000000136237824ULL, 0x040fe200078e0223ULL,
0x0000001021007388ULL, 0x0003e20000000800ULL, 0x0000001035327824ULL, 0x000fe400078e0200ULL,
0x00000001362e7824ULL, 0x000fe200078e022eULL, 0x0000001222007388ULL, 0x0003e20000000800ULL,
0x0000001037337824ULL, 0x000fc400078e0200ULL, 0x00000001362f7824ULL, 0x000fe200078e022fULL,
0x0000001423007388ULL, 0x0003e20000000800ULL, 0x0000001038347824ULL, 0x000fe400078e0200ULL,
0x0000000136307824ULL, 0x040fe200078e0230ULL, 0x000000162e007388ULL, 0x0003e20000000800ULL,
0x0000001039357824ULL, 0x100fe400078e0200ULL, 0x0000000136317824ULL, 0x000fe200078e0231ULL,
0x000000092f007388ULL, 0x0003e20000000800ULL, 0x000000103a007824ULL, 0x000fc400078e0200ULL,
0x0000000136327824ULL, 0x040fe200078e0232ULL, 0x0000000b30007388ULL, 0x0003e20000000800ULL,
0x0000000136337824ULL, 0x040fe400078e0233ULL, 0x0000000136347824ULL, 0x040fe200078e0234ULL,
0x0000000d31007388ULL, 0x0003e20000000800ULL, 0x0000000136357824ULL, 0x040fe400078e0235ULL,
0x0000000136007824ULL, 0x000fe200078e0200ULL, 0x0000000f32007388ULL, 0x0003e80000000800ULL,
0x0000001133007388ULL, 0x0003e80000000800ULL, 0x0000001334007388ULL, 0x0003e80000000800ULL,
0x0000001535007388ULL, 0x0003e80000000800ULL, 0x0000001700007388ULL, 0x0003e80000000800ULL,
0x0100000418008388ULL, 0x0003e80000000c00ULL, 0x0102001c18008388ULL, 0x0143e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000002aff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008002aff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010002aff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003002c2c7a10ULL, 0x000fe20007ffe0ffULL,
0x000018002aff7f8cULL, 0x0003e6000c80043fULL, 0x0000002d2c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffc97000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff007807ULL, 0x008fe40004800000ULL,
0x000151c000247802ULL, 0x000fe40000000f00ULL, 0x0000127000007944ULL, 0x014fea0003c00000ULL,
0xfffec34000007947ULL, 0x000fea000383ffffULL, 0x00000001ff007807ULL, 0x000fe40004800000ULL,
0x0001520000247802ULL, 0x000fe40000000f00ULL, 0x0000123000007944ULL, 0x014fea0003c00000ULL,
0xfffec38000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x012fe200078e002aULL,
0x00015270005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0024ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fc400078e00ffULL,
0x0000117000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff257224ULL, 0x004fe200078e0000ULL,
0xfffec3a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0024ULL,
0x000152f0005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e002aULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000010f000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff247224ULL, 0x004fe200078e0000ULL,
0xfffec35000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0040ULL,
0x00015360005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000108000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff667224ULL, 0x004fe200078e0000ULL, 0xfffec6c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e003eULL, 0x000153d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000101000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff657224ULL, 0x004fe200078e0000ULL,
0xfffec68000007947ULL, 0x000fea000383ffffULL, 0x0000001fff597424ULL, 0x000fe200078e00ffULL,
0x00015430005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000fb000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff657224ULL, 0x004fe200078e0000ULL,
0xfffedce000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e003eULL,
0x000154a0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000f4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff647224ULL, 0x004fe200078e0000ULL, 0xfffedc9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x000154f000247802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x014fea0003c00000ULL, 0xfffef27000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001553000247802ULL, 0x000fc40000000f00ULL,
0x00000f0000007944ULL, 0x014fea0003c00000ULL, 0xfffef2b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e0000ULL, 0x000155a0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0025ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000e4000007944ULL, 0x014fea0003c00000ULL,
0xfffef2f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0025ULL,
0x00015610005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e003eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000dd000007944ULL, 0x012fea0003c00000ULL, 0xfffef3a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff597424ULL, 0x000fe200078e00ffULL, 0x00015660005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x00000d8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e0000ULL, 0xfffef60000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x008fe200078e003eULL, 0x000156d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000d1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xfffef5b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff597424ULL, 0x000fe200078e00ffULL,
0x00015730005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000cb000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xffff0a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e003eULL,
0x000157a0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000c4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e0000ULL, 0xffff09d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x000157f000247802ULL, 0x000fc40000000f00ULL,
0x00000c4000007944ULL, 0x014fea0003c00000ULL, 0xffff1f4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x0001583000247802ULL, 0x000fc40000000f00ULL,
0x00000c0000007944ULL, 0x014fea0003c00000ULL, 0xffff1f8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x002fe200078e0000ULL, 0x000158a0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0025ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x00000b4000007944ULL, 0x014fea0003c00000ULL,
0xffff1fc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0025ULL,
0x00015910005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e003eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000ad000007944ULL, 0x012fea0003c00000ULL, 0xffff207000007947ULL, 0x000fea000383ffffULL,
0x0000001fff597424ULL, 0x000fe200078e00ffULL, 0x00015960005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x00000a8000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e0000ULL, 0xffff22d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x008fe200078e003eULL, 0x000159d0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x00000a1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xffff228000007947ULL, 0x000fea000383ffffULL, 0x0000001fff597424ULL, 0x000fe200078e00ffULL,
0x00015a30005c7802ULL, 0x000fe20000000f00ULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000009b000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0000ULL,
0xffff36f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x002fe200078e003eULL,
0x00015aa0005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000094000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff637224ULL, 0x004fe200078e0000ULL, 0xffff36a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x008fe40004800000ULL, 0x00015af000247802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x012fea0003c00000ULL, 0xffff4c1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff007807ULL, 0x000fe40004800000ULL, 0x00015b3000247802ULL, 0x000fc40000000f00ULL,
0x0000090000007944ULL, 0x012fea0003c00000ULL, 0xffff4c5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x004fe200078e0000ULL, 0x00015ba0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0024ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x0000084000007944ULL, 0x012fea0003c00000ULL,
0xffff4c9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0024ULL,
0x00015c10005c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5b7224ULL, 0x000fe400078e003eULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x000007d000007944ULL, 0x012fea0003c00000ULL, 0xffff4d4000007947ULL, 0x000fea000383ffffULL,
0x0000001fff597424ULL, 0x000fe200078e00ffULL, 0x00015c60005c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff587424ULL, 0x000fc400078e00ffULL, 0x0000078000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff5e7224ULL, 0x004fe200078e0000ULL, 0xffff4fa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x004fe200078e003eULL, 0x00015cd0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fc400078e00ffULL, 0xffffffffff587424ULL, 0x000fe400078e00ffULL,
0x0000071000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff5d7224ULL, 0x004fe200078e0000ULL,
0xffff4f5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5b7224ULL, 0x000fe200078e0039ULL,
0x00015d40005c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff597424ULL, 0x000fe400078e00ffULL,
0xffffffffff587424ULL, 0x000fe400078e00ffULL, 0x000006a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff397224ULL, 0x004fe200078e0000ULL, 0xffff63e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5b7224ULL, 0x000fe200078e003eULL, 0x00015db0005c7802ULL, 0x000fe20000000f00ULL,
0x0000001fff597424ULL, 0x000fe400078e00ffULL, 0xffffffffff587424ULL, 0x000fc400078e00ffULL,
0x0000063000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff3e7224ULL, 0x004fe200078e0000ULL,
0xffff639000007947ULL, 0x000fea000383ffffULL, 0x000000ffff007224ULL, 0x000fe200078e0004ULL,
0x00015e1000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x0000058000007944ULL, 0x002fea0003c00000ULL, 0xffffe4e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff007224ULL, 0x000fe200078e002eULL, 0x00015e6000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x0000053000007944ULL, 0x002fea0003c00000ULL,
0x000000002e057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x00015eb000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff087424ULL, 0x000fc400078e00ffULL,
0x000004e000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x00015f0000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff087424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000000007077209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0030ULL,
0x00015f5000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x0000044000007944ULL, 0x000fea0003c00000ULL, 0x0000000030047209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0005ULL, 0x00015fa000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x000003f000007944ULL, 0x000fea0003c00000ULL,
0x0000000005057209ULL, 0x004fe20007810000ULL, 0x000000ffff007224ULL, 0x000fe200078e0006ULL,
0x00015ff000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff087424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000000006067209ULL, 0x004fe20007810000ULL,
0x000000ffff007224ULL, 0x000fe200078e0007ULL, 0x0001604000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff087424ULL, 0x000fc400078e00ffULL, 0x0000035000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0000ULL, 0xffffe39000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e001cULL, 0x000160c0005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fc400078e00ffULL, 0x00001c1fff597424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x000fe400078e001bULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1c7224ULL, 0x004fe200078e0000ULL, 0xffffe95000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e001eULL, 0x00016140005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff597424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x000fe400078e001bULL, 0x000002a000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e00ffULL, 0x000161a0005c7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff597424ULL, 0x000fc400078e00ffULL, 0x000000ffff587224ULL, 0x000fe400078e001bULL,
0x000000ffff1d7224ULL, 0x004fe400078e0000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff587224ULL, 0x000fe200078e001bULL, 0x00016200005c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5b7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff597424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e0000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e0000ULL, 0xffffe89000007947ULL, 0x000fea000383ffffULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000500008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000007ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000007ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe9c7006007950ULL, 0x000fea0003c3ffffULL, 0x0000003900007348ULL, 0x000fe80003800000ULL,
0x0c00000800007389ULL, 0x0002a400000e0031ULL, 0x000000ffff087224ULL, 0x002fe400078e0009ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffe9c2008007950ULL, 0x000fea0003c3ffffULL,
0x0000005800007348ULL, 0x000fe80003800000ULL, 0x0000005b5a007389ULL, 0x0002a400000e0059ULL,
0x000000ffff587224ULL, 0x002fe400078e005cULL, 0x00000000ff597424ULL, 0x000fc800078e00ffULL,
0xfffe9bd058007950ULL, 0x000fea0003c3ffffULL, 0x000000010000780cULL, 0x000fe20003f25070ULL,
0x00000000ff257424ULL, 0x000fe200078e00ffULL, 0x0000004b00007348ULL, 0x000ff60003800000ULL,
0x0000000000007806ULL, 0x000fc800048e0100ULL, 0x0000004b00007212ULL, 0x000fe200078ec0ffULL,
0xfffe9b7024007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000480ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000a60ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000af0ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001680ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000016a0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000016b0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000016d0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001760ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001768ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001778ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001980ULL, 0x0000000000016580ULL, 0x9400001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017f00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017f10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017f10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018390ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001760ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000167a0ULL, 0x00000000000167a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017f00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018390ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin_len = 99440;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
