/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000018590ULL, 0x0000000000018110ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000016570ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x00000000000166e0ULL, 0x0000000000000050ULL, 0x000e002200000131ULL,
0x0000000000016730ULL, 0x0000000000000050ULL, 0x000e00220000015bULL, 0x0000000000016780ULL,
0x0000000000000100ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000016880ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001657000000000ULL, 0x0000040400000000ULL, 0x810c000001580400ULL,
0x0057f40400288080ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9208288080910828ULL, 0x2880809408288080ULL, 0x809b082880809608ULL, 0x08288080a1082880ULL,
0x8080c208288080a3ULL, 0xd908288080d40828ULL, 0x288080da08288080ULL, 0x808608288080db08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080869200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001657000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8e082880808c0828ULL, 0x2880809008288080ULL,
0x8092082880809108ULL, 0x0828808094082880ULL, 0x80809b0828808096ULL, 0xa308288080a10828ULL,
0x288080c208288080ULL, 0x80d908288080d408ULL, 0x08288080da082880ULL, 0x80808908288080dbULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808992ULL, 0x0000002cffffffffULL,
0x0000012000000000ULL, 0x000166e000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x8088288080890900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8c08288080890828ULL, 0x2880808e08288080ULL, 0x8091082880809008ULL, 0x0828808092082880ULL,
0x8080960828808094ULL, 0xa1082880809b0828ULL, 0x288080a308288080ULL, 0x80d408288080c208ULL,
0x08288080d9082880ULL, 0x8080db08288080daULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x002200288080db92ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL, 0x0001673000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80c2288080db0900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880808e08288080ULL,
0x8092082880809008ULL, 0x0828808094082880ULL, 0x80809b0828808096ULL, 0xa308288080a10828ULL,
0x288080c208288080ULL, 0x80d908288080d408ULL, 0x08288080da082880ULL, 0x80809108288080dbULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880809192ULL, 0x0000002cffffffffULL,
0x000002c000000000ULL, 0x0001678000000000ULL, 0x0000010000000000ULL, 0x0000140400000000ULL,
0x8090288080910900ULL, 0x0000000000002880ULL, 0x0000001200082f04ULL, 0x0008120400000097ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL,
0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x00014960000144b0ULL, 0x00014ac000014970ULL, 0x00014ae000014ad0ULL,
0xffffffff01c82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x05000024ffffffffULL, 0x0500002405000024ULL, 0xffffffff05000024ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01c82804ffffffffULL, 0x000000f0000000e0ULL, 0x00001570000014f0ULL,
0x0000164000001610ULL, 0x00001a5000001a20ULL, 0x00001b5000001ad0ULL, 0x0000315000003130ULL,
0x00003230000031c0ULL, 0x00004850000047d0ULL, 0x00004a2000004900ULL, 0x00004d0000004ce0ULL,
0x00004de000004d70ULL, 0x0000623000006210ULL, 0x00006310000062a0ULL, 0x000078a000007820ULL,
0x00007a7000007950ULL, 0x00007d5000007d30ULL, 0x00007e3000007dc0ULL, 0x0000928000009260ULL,
0x00009360000092f0ULL, 0x0000a8f00000a870ULL, 0x0000aac00000a9a0ULL, 0x0000ada00000ad80ULL,
0x0000ae800000ae10ULL, 0x0000c2f00000c2d0ULL, 0x0000c3d00000c360ULL, 0x0000d5c00000d5b0ULL,
0x0000f8d00000dd40ULL, 0x000100200000fb70ULL, 0x0001088000010060ULL, 0x000143b000014380ULL,
0x000143d0000143c0ULL, 0x00014410000143f0ULL, 0x0001444000014430ULL, 0x00014b1000014ab0ULL,
0x00014b3000014b20ULL, 0x000152b000015250ULL, 0x000153b000015330ULL, 0x000154b000015430ULL,
0x000155a000015520ULL, 0x0001566000015600ULL, 0x00015730000156d0ULL, 0x0001581000015790ULL,
0x0001590000015880ULL, 0x000159c000015960ULL, 0x00015a9000015a30ULL, 0x00015b7000015af0ULL,
0x00015c6000015be0ULL, 0x00015d2000015cc0ULL, 0x00015e1000015da0ULL, 0x00015ef000015e70ULL,
0x00015ff000015f70ULL, 0x000160f000016070ULL, 0x000161d000016160ULL, 0x000162b000016240ULL,
0x0001639000016320ULL, 0x0001648000016400ULL, 0x00016540000164e0ULL, 0x0000021007003904ULL,
0x00010600000000ffULL, 0x00000250003f0100ULL, 0x0001060800000003ULL, 0x000002c0003f0120ULL,
0x0001068800000003ULL, 0x00000390003f0120ULL, 0x000106a800000003ULL, 0x000003c0003f0120ULL,
0x000106b8000000ffULL, 0x000004d0003f0100ULL, 0x00010600000000ffULL, 0x00000670003f0107ULL,
0x0001068c0000001aULL, 0x000009f0003f0102ULL, 0x000106880000001aULL, 0x00000b40003f0101ULL,
0x000106a8000000ffULL, 0x00000bc0003f0107ULL, 0x000106a8000000ffULL, 0x00000c20003f0101ULL,
0x000106b8000000ffULL, 0x00000d60003f0101ULL, 0x000106bc000000ffULL, 0x00000db0003f0105ULL,
0x000106bc000000ffULL, 0x00000e30003f0105ULL, 0x000106bc000000ffULL, 0x00001270003f0105ULL,
0x000106b0000000ffULL, 0x000012f0003f0107ULL, 0x000106b0000000ffULL, 0x00001300003f0101ULL,
0x000106ac000000ffULL, 0x00001370003f0105ULL, 0x000106080000001aULL, 0x00001390003f0101ULL,
0x0001060c0000001aULL, 0x00001420003f0105ULL, 0x0001060c0000001aULL, 0x00001900003f0105ULL,
0x000106ac000000ffULL, 0x00001980003f0105ULL, 0x000106ac000000ffULL, 0x00002b80003f0105ULL,
0x000106b8000000ffULL, 0x00002b90003f0101ULL, 0x000106bc000000ffULL, 0x00002be0003f0105ULL,
0x000106bc000000ffULL, 0x00002c60003f0105ULL, 0x000106bc000000ffULL, 0x00002f30003f0105ULL,
0x000106a8000000ffULL, 0x00002fb0003f0107ULL, 0x000106a8000000ffULL, 0x00002fc0003f0101ULL,
0x000106b4000000ffULL, 0x00003020003f0105ULL, 0x000106b4000000ffULL, 0x000030a0003f0105ULL,
0x000106b4000000ffULL, 0x00004180003f0105ULL, 0x000106b8000000ffULL, 0x000041f0003f0101ULL,
0x00010688000000ffULL, 0x00004230003f0101ULL, 0x000106bc000000ffULL, 0x00004280003f0105ULL,
0x000106bc000000ffULL, 0x00004300003f0105ULL, 0x000106bc000000ffULL, 0x00004590003f0105ULL,
0x000106b0000000ffULL, 0x00004610003f0107ULL, 0x000106b0000000ffULL, 0x00004620003f0101ULL,
0x000106ac000000ffULL, 0x00004690003f0105ULL, 0x000106280000001aULL, 0x000046b0003f0101ULL,
0x0001062c0000001aULL, 0x00004740003f0105ULL, 0x0001062c0000001aULL, 0x00004bd0003f0105ULL,
0x000106ac000000ffULL, 0x00004c50003f0105ULL, 0x000106ac000000ffULL, 0x00005ca0003f0105ULL,
0x000106b8000000ffULL, 0x00005cb0003f0101ULL, 0x000106bc000000ffULL, 0x00005d00003f0105ULL,
0x000106bc000000ffULL, 0x00005d80003f0105ULL, 0x000106bc000000ffULL, 0x00006010003f0105ULL,
0x000106a8000000ffULL, 0x00006090003f0107ULL, 0x000106a8000000ffULL, 0x000060a0003f0101ULL,
0x000106b4000000ffULL, 0x00006100003f0105ULL, 0x000106b4000000ffULL, 0x00006180003f0105ULL,
0x000106b4000000ffULL, 0x000071d0003f0105ULL, 0x000106b8000000ffULL, 0x00007240003f0101ULL,
0x00010690000000ffULL, 0x00007280003f0101ULL, 0x000106bc000000ffULL, 0x000072d0003f0105ULL,
0x000106bc000000ffULL, 0x00007350003f0105ULL, 0x000106bc000000ffULL, 0x000075e0003f0105ULL,
0x000106b0000000ffULL, 0x00007660003f0107ULL, 0x000106b0000000ffULL, 0x00007670003f0101ULL,
0x000106ac000000ffULL, 0x000076e0003f0105ULL, 0x000106480000001aULL, 0x00007700003f0101ULL,
0x0001064c0000001aULL, 0x00007790003f0105ULL, 0x0001064c0000001aULL, 0x00007c20003f0105ULL,
0x000106ac000000ffULL, 0x00007ca0003f0105ULL, 0x000106ac000000ffULL, 0x00008cf0003f0105ULL,
0x000106b8000000ffULL, 0x00008d00003f0101ULL, 0x000106bc000000ffULL, 0x00008d50003f0105ULL,
0x000106bc000000ffULL, 0x00008dd0003f0105ULL, 0x000106bc000000ffULL, 0x00009060003f0105ULL,
0x000106a8000000ffULL, 0x000090e0003f0107ULL, 0x000106a8000000ffULL, 0x000090f0003f0101ULL,
0x000106b4000000ffULL, 0x00009150003f0105ULL, 0x000106b4000000ffULL, 0x000091d0003f0105ULL,
0x000106b4000000ffULL, 0x0000a220003f0105ULL, 0x000106b8000000ffULL, 0x0000a290003f0101ULL,
0x00010698000000ffULL, 0x0000a2d0003f0101ULL, 0x000106bc000000ffULL, 0x0000a320003f0105ULL,
0x000106bc000000ffULL, 0x0000a3a0003f0105ULL, 0x000106bc000000ffULL, 0x0000a630003f0105ULL,
0x000106b0000000ffULL, 0x0000a6b0003f0107ULL, 0x000106b0000000ffULL, 0x0000a6c0003f0101ULL,
0x000106ac000000ffULL, 0x0000a730003f0105ULL, 0x000106680000001aULL, 0x0000a750003f0101ULL,
0x0001066c0000001aULL, 0x0000a7e0003f0105ULL, 0x0001066c0000001aULL, 0x0000ac70003f0105ULL,
0x000106ac000000ffULL, 0x0000acf0003f0105ULL, 0x000106ac000000ffULL, 0x0000bd30003f0105ULL,
0x000106b8000000ffULL, 0x0000bd40003f0101ULL, 0x000106bc000000ffULL, 0x0000bd90003f0105ULL,
0x000106bc000000ffULL, 0x0000be10003f0105ULL, 0x000106bc000000ffULL, 0x0000c0d0003f0105ULL,
0x000106a8000000ffULL, 0x0000c150003f0107ULL, 0x000106a8000000ffULL, 0x0000c160003f0101ULL,
0x000106b4000000ffULL, 0x0000c1c0003f0105ULL, 0x000106b4000000ffULL, 0x0000c240003f0105ULL,
0x000106b4000000ffULL, 0x0000d260003f0105ULL, 0x000106b8000000ffULL, 0x0000d2c0003f0101ULL,
0x000106a0000000ffULL, 0x00010b80003f0101ULL, 0x00010600000000ffULL, 0x00011670003f0101ULL,
0x00010604000000ffULL, 0x00011710003f0105ULL, 0x00010604000000ffULL, 0x00011a30003f0105ULL,
0x00010600000000ffULL, 0x00011a40003f0101ULL, 0x00010604000000ffULL, 0x00011ad0003f0105ULL,
0x00010604000000ffULL, 0x000138a0003f0105ULL, 0x0000000000000029ULL, 0x000138d0003f0101ULL,
0x0000000400000029ULL, 0x00013ca0003f0105ULL, 0x0000000400000029ULL, 0x000150a0003f0105ULL,
0x000000000000002bULL, 0x00015100003f0101ULL, 0x000000080000002bULL, 0x00015160003f0101ULL,
0x000000100000002bULL, 0x000151d0003f0101ULL, 0x000000180000002bULL, 0x00053803003f0101ULL,
0x00010ad000101c04ULL, 0x00011bd000011b30ULL, 0x0000040100015210ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000036cULL, 0x0000001200000002ULL, 0x000000000000029cULL, 0x0000001200000002ULL,
0x00000000000001ccULL, 0x0000001200000002ULL, 0x000000000000010cULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000348ULL, 0x0000001200000002ULL,
0x0000000000000278ULL, 0x0000001200000002ULL, 0x00000000000001a8ULL, 0x0000001200000002ULL,
0x00000000000000e9ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000047919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001000077300ULL, 0x000ee200000e0000ULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000f280000002200ULL, 0x0000000000117919ULL, 0x000f620000002600ULL,
0x0000001000137309ULL, 0x0002e60000000000ULL, 0x00000000001b7919ULL, 0x000ee80000002700ULL,
0x0000000000087919ULL, 0x000ee20000000000ULL, 0x00000005ff007819ULL, 0x002fc60000011604ULL,
0x00001fff020c7589ULL, 0x0049e800000e0000ULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x0000000102027824ULL, 0x010fc800078e0203ULL, 0x0000008002037824ULL, 0x000fe400078e0204ULL,
0x0000000000027919ULL, 0x000ea20000000000ULL, 0x0000000811047824ULL, 0x020fe200078e00ffULL,
0x000000080700720cULL, 0x008fe40003f02070ULL, 0x000000ff0300720cULL, 0x000fe20003f25270ULL,
0x0000001b050a7224ULL, 0x000fe200078e0204ULL, 0x0000000f0300780cULL, 0x040fe40003f44070ULL,
0x0000007f0300780cULL, 0x000fc40003f84070ULL, 0x000000030300780cULL, 0x000fe20003f64070ULL,
0x000000040c067824ULL, 0x002fcc00078e0200ULL, 0x3fffff80ff049424ULL, 0x000fe400078e00ffULL,
0x00000002060b7824ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x000000080b0d7817ULL, 0x040fe20007800000ULL,
0x7fffffc0ff07a424ULL, 0x000fe200078e00ffULL, 0x01060004ff009388ULL, 0x0003e20000000a00ULL,
0xff317217ff0ec424ULL, 0x000fe200078e00ffULL, 0x000000010b0f7810ULL, 0x000fe20007ffe0ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x010608060300a388ULL, 0x0007e20000008a00ULL,
0x000000010300780cULL, 0x000fe20003f44070ULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x000000070f107812ULL, 0x000fe200078ec0ffULL, 0x0104000e0300c388ULL, 0x0009e20000004800ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0bULL, 0x000000070b047812ULL, 0x002fc400078ec0ffULL,
0x010688080300b388ULL, 0x0003e20000008a00ULL, 0x0000001f10107812ULL, 0x104fe400078e7802ULL,
0x0000001f04057812ULL, 0x000fe200078e7802ULL, 0x000000010a047824ULL, 0x040fe200078e020bULL,
0x000000ff0d00720cULL, 0x040fe20003f63070ULL, 0x000000010a067824ULL, 0x008fe200078e020fULL,
0x000000010d00780cULL, 0x000fe20003f83070ULL, 0x000000200b0e7824ULL, 0x010fe400078e0205ULL,
0x3fffff80ff0a9424ULL, 0x000fc400078e00ffULL, 0x3fffff00ff08a424ULL, 0x002fe400078e00ffULL,
0x7fffff00ff09a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff0b9424ULL, 0x000fe400078e00ffULL,
0x00000200ff077424ULL, 0x000fe200078e00ffULL, 0x0106a8080300a388ULL, 0x0003e20000008a00ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00005c0004047625ULL, 0x080fe200078e0007ULL,
0x0106b80aff009388ULL, 0x0005e40000000a00ULL, 0x000001f00d127812ULL, 0x000fe200078ec0ffULL,
0x00005c0006067625ULL, 0x000fe200078e0007ULL, 0x0000000000007b1dULL, 0x000fe40000010000ULL,
0x0000001204047210ULL, 0x080fe20007fbe0ffULL, 0x000000200f107824ULL, 0x000fe200078e0210ULL,
0x0000001206067210ULL, 0x000fe20007f5e0ffULL, 0x000000100e0e7824ULL, 0x000fc400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400028e0605ULL, 0x000000ffff077224ULL, 0x000fe400010e0607ULL,
0x0000001010107824ULL, 0x000fe400078e00ffULL, 0x000000ffff037224ULL, 0x002fe200078e0a13ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040e7faeULL, 0x0003e8000d901c46ULL,
0x0000000006107faeULL, 0x0005e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x00000004ff047424ULL, 0x000fc600078e00ffULL, 0x01060403ffff038cULL, 0x0005e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01060000ff0079b0ULL, 0x000fe20008000a3fULL, 0x000060001b047625ULL, 0x000fc600078e0004ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000604037981ULL, 0x004ea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000e620000002500ULL, 0x000000ff0c00720cULL, 0x000fe20003f05270ULL,
0x00000004ff187e24ULL, 0x002fe2000f8e00ffULL, 0x000000ff03197810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff197819ULL, 0x000fce0000011619ULL, 0x0001050000008947ULL, 0x000fea0003800000ULL,
0x0000580011047a10ULL, 0x000fe20007ffe0ffULL, 0x000000021b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000118057810ULL, 0x000fe20007ffe0ffULL, 0x00000008001a7824ULL, 0x000fe400078e00ffULL,
0x000058001b1b7a24ULL, 0x000fe200078e0204ULL, 0x000000190500720cULL, 0x000fe20003f06070ULL,
0x00000003ff047424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000004ff087819ULL, 0x000fe20000011602ULL, 0x01068c041aff738cULL, 0x0003e20000000000ULL,
0x000000f00d167812ULL, 0x000fe200078ec0ffULL, 0x00000100ff177424ULL, 0x000fe200078e00ffULL,
0x00000002080e7810ULL, 0x000fe20007ffe0ffULL, 0x000000011a077824ULL, 0x000fe200078e0208ULL,
0x0000000408107810ULL, 0x000fc40007ffe0ffULL, 0x0000000608137810ULL, 0x000fe20007ffe0ffULL,
0x000000011a0a7824ULL, 0x000fe200078e020eULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x0000010018047824ULL, 0x002fe400078e00ffULL, 0x000000011a0b7824ULL, 0x040fe200078e0210ULL,
0x0000000f09097812ULL, 0x000fe200078e7802ULL, 0x000062001b067a24ULL, 0x000fe200078e0204ULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x000000011a147824ULL, 0x000fe200078e0213ULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x00000010070d7824ULL, 0x000fc400078e0209ULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x000000070a047812ULL, 0x000fe200078ec0ffULL,
0x0000000106117824ULL, 0x000fe200078e020bULL, 0x0000000f0c0c7812ULL, 0x000fe200078e7802ULL,
0x0000000106157824ULL, 0x000fe200078e0214ULL, 0x0000000f04097812ULL, 0x000fe200078e7802ULL,
0x0000000106047824ULL, 0x000fe200078e0207ULL, 0x0000002005077807ULL, 0x000fe20000000000ULL,
0x000000100b127824ULL, 0x000fe200078e020cULL, 0x0000c0000d0d7811ULL, 0x000fe200078e20ffULL,
0x000000100a0f7824ULL, 0x000fe200078e0209ULL, 0x000000071a077217ULL, 0x000fe20007800000ULL,
0x0000000106097824ULL, 0x000fe200078e020aULL, 0x00000007140a7812ULL, 0x000fe200078ec0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0017ULL, 0x0000000f0a0b7812ULL, 0x000fe200078e7802ULL,
0x00000001070c7824ULL, 0x000fe200078e0a1aULL, 0x00000016040a7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0011067625ULL, 0x000fc600078e0017ULL, 0x0000000c0800720cULL, 0x000fe20003f26070ULL,
0x0000001014147824ULL, 0x000fe200078e020bULL, 0x0000001606067210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0605ULL, 0x0000000c0e00720cULL, 0x080fe20003f46070ULL,
0x00005e0009047625ULL, 0x080fe200078e0017ULL, 0x0000000c1000720cULL, 0x080fe40003f66070ULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x00005e0015087625ULL, 0x000fe200078e0017ULL,
0x0000001604047210ULL, 0x000fc60007f9e0ffULL, 0x000000ffff077224ULL, 0x000fe200028e0607ULL,
0x0000001608087210ULL, 0x000fe20007fde0ffULL, 0x000000ffff057224ULL, 0x000fc800020e0605ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x010688001aff7f8cULL, 0x0003e2000c80043fULL,
0x0000c00012127811ULL, 0x000fe200078e20ffULL, 0xff317217ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000c00014147811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000c901c46ULL, 0x000000191800720cULL, 0x000fe20003f26070ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x00000000040f7faeULL, 0x0005e2000d101c46ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000006127faeULL, 0x0003e2000d901c46ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000008147faeULL, 0x0003e2000c101c46ULL, 0x000000ffff457224ULL, 0x000fc600078e00ffULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a800ff107f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106b800ff127f8cULL, 0x002e62000c80043fULL, 0x000000ffff447224ULL, 0x000fe200078e00ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000c65000001947ULL, 0x000fea0003800000ULL, 0x0000000400227824ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x004fc400078e0011ULL, 0x000000ffff107224ULL, 0x002fe200078e0013ULL,
0x0000000222237810ULL, 0x000fe20007ffe0ffULL, 0xff317217ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fe400078e00ffULL, 0x0000010018117824ULL, 0x000fca00078e00ffULL,
0x000000031100720cULL, 0x000fda0003f06070ULL, 0x0000c58000000947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804810ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff117424ULL, 0x000fc800078e00ffULL,
0x0000001100127305ULL, 0x0002a4000021f000ULL, 0x3fa0000011117823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007804810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002018107811ULL, 0x000fe200078e40ffULL, 0x00000100ff2d7424ULL, 0x000fe200078e00ffULL,
0x00000004ff2c7819ULL, 0x000fe20000011602ULL, 0x0000001002307824ULL, 0x000fe200078e00ffULL,
0x0000001003127217ULL, 0x000fe20007800000ULL, 0x000062001b207a24ULL, 0x000fe200078e0210ULL,
0x0000000118117810ULL, 0x000fe20007ffe0ffULL, 0x000000011a247824ULL, 0x000fe200078e022cULL,
0x000000022c267810ULL, 0x000fe20007ffe0ffULL, 0x0000000112127824ULL, 0x000fe200078e0a10ULL,
0x000000042c277810ULL, 0x000fe20007ffe0ffULL, 0x0000000124107824ULL, 0x000fe200078e0220ULL,
0x000000191100720cULL, 0x000fe20003f06070ULL, 0x000000011a297824ULL, 0x000fe200078e0226ULL,
0x000000062c287810ULL, 0x000fe20007ffe0ffULL, 0x000000011a2a7824ULL, 0x000fe200078e0227ULL,
0x0000002012127807ULL, 0x000fe20000000000ULL, 0x0000000129137824ULL, 0x100fe200078e0220ULL,
0x000000f030257812ULL, 0x000fe200078ec0ffULL, 0x000000012a1e7824ULL, 0x000fe200078e0220ULL,
0x000000121a217217ULL, 0x000fe20007800000ULL, 0x00005e0010107625ULL, 0x000fc800078e002dULL,
0x00005e0013127625ULL, 0x000fe200078e002dULL, 0x00000025102e7210ULL, 0x000fc60007f3e0ffULL,
0x00005e001e1e7625ULL, 0x000fe200078e002dULL, 0x0000002512127210ULL, 0x000fc60007f5e0ffULL,
0x000000011a2b7824ULL, 0x000fe200078e0228ULL, 0x000000251e1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000121217824ULL, 0x000fe400078e0a1aULL, 0x000000012b107824ULL, 0x000fe200078e0220ULL,
0x0000000724207812ULL, 0x000fe200078ec0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0611ULL,
0x000000212c00720cULL, 0x080fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x000000212600720cULL, 0x080fe20003f46070ULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000212700720cULL, 0x000fe20003f66070ULL, 0x00005e0010107625ULL, 0x000fe200078e002dULL,
0x000000212800720cULL, 0x000fc40003f86070ULL, 0x0000000f20207812ULL, 0x000fe400078e7802ULL,
0x0000000729217812ULL, 0x000fe400078ec0ffULL, 0x000000072a2c7812ULL, 0x000fe200078ec0ffULL,
0x00000010243b7824ULL, 0x000fe200078e0220ULL, 0x000000072b2d7812ULL, 0x000fe400078ec0ffULL,
0x0000000f21217812ULL, 0x100fe400078e7802ULL, 0x0000000f2c647812ULL, 0x000fc400078e7802ULL,
0x0000000f2d207812ULL, 0x000fe200078e7802ULL, 0x0000001029657824ULL, 0x000fe200078e0221ULL,
0x0000e0003b2c7811ULL, 0x000fe200078e20ffULL, 0x000000102a647824ULL, 0x000fe200078e0264ULL,
0x0000002510107210ULL, 0x000fe20007fbe0ffULL, 0x000000102b207824ULL, 0x000fe200078e0220ULL,
0x0000e000652d7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002e2c7faeULL, 0x0003e4000c901c46ULL, 0x000000ffff117224ULL, 0x000fe400028e0611ULL,
0x00000000122d7faeULL, 0x0005e2000d101c46ULL, 0x0000e000642e7811ULL, 0x002fc400078e20ffULL,
0x0000e000202f7811ULL, 0x000fc600078e20ffULL, 0x000000001e2e7faeULL, 0x0005e8000d901c46ULL,
0x00000000102f7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x002fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x0106b000ff1e7f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff127984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010608001a107f8cULL, 0x000fe2000c80043fULL,
0x8000000012ff7812ULL, 0x004fc60007844841ULL, 0x01060c001a137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007824811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0004e4000021f000ULL,
0x3fa0000012127823ULL, 0x004fe200000100ffULL, 0x000000130000735dULL, 0x008fe40003800000ULL,
0x01060c001a137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff107819ULL, 0x000fe40000011602ULL,
0x0000007030307812ULL, 0x000fe400078ec0ffULL, 0x0000000c10107812ULL, 0x000fca00078ec0ffULL,
0x0000000130307824ULL, 0x000fca00078e0210ULL, 0x0100000030127984ULL, 0x000ea80000000800ULL,
0x0102000030137984ULL, 0x0007220000000800ULL, 0x0000001c1200720bULL, 0x004fe20003f3d000ULL,
0x00013d327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800008e0100ULL,
0x0000ffff10217812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3a7424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fe40003f65270ULL, 0x0000001c1200720bULL, 0x000fe20003f34000ULL,
0x00013d127f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x000000121c327209ULL, 0x000fe40007810000ULL, 0x0000ffff10107812ULL, 0x000fc600078e3cffULL,
0x010400323000b388ULL, 0x0005e20000000800ULL, 0x800000321c117221ULL, 0x000fe20000010000ULL,
0x0000001021ff7212ULL, 0x000fe4000782c0ffULL, 0x00000002ff107819ULL, 0x000fe20000011602ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x00000011001c7308ULL, 0x0004e20000000800ULL,
0x00013cd27f007947ULL, 0x000fea000b800000ULL, 0x00001f101c117589ULL, 0x00c4e400000e0000ULL,
0x0000000810107810ULL, 0x004fe20007ffe0ffULL, 0x00013d227f007947ULL, 0x000fea000b800000ULL,
0x00001f101c107589ULL, 0x00052400000e0000ULL, 0x8000003212121221ULL, 0x000fe20000010000ULL,
0x00000001ff3a7807ULL, 0x000fe20000800000ULL, 0x0000001c1d1d7220ULL, 0x000fe40000410000ULL,
0x3fb8aa3b12121820ULL, 0x000fe40000410000ULL, 0x0000001053537220ULL, 0x090fe40000410000ULL,
0x0000001200311308ULL, 0x000f220000000800ULL, 0x0000001052527220ULL, 0x000fc40000410000ULL,
0x000000104f4f7220ULL, 0x080fe40000410000ULL, 0x000000104e4e7220ULL, 0x080fe40000410000ULL,
0x000000104b4b7220ULL, 0x080fe40000410000ULL, 0x000000104a4a7220ULL, 0x080fe40000410000ULL,
0x0000001047477220ULL, 0x080fe40000410000ULL, 0x0000001046467220ULL, 0x000fc40000410000ULL,
0x0000001017177220ULL, 0x080fe40000410000ULL, 0x0000001016167220ULL, 0x080fe40000410000ULL,
0x0000001007077220ULL, 0x080fe40000410000ULL, 0x0000001006067220ULL, 0x080fe40000410000ULL,
0x000000100b0b7220ULL, 0x080fe40000410000ULL, 0x000000100a0a7220ULL, 0x000fc40000410000ULL,
0x000000100f0f7220ULL, 0x080fe40000410000ULL, 0x000000100e0e7220ULL, 0x000fe40000410000ULL,
0x0000001151517220ULL, 0x088fe40000410000ULL, 0x0000001150507220ULL, 0x080fe40000410000ULL,
0x000000114d4d7220ULL, 0x080fe40000410000ULL, 0x000000114c4c7220ULL, 0x000fc40000410000ULL,
0x0000001149497220ULL, 0x080fe40000410000ULL, 0x0000001148487220ULL, 0x080fe40000410000ULL,
0x0000001145457220ULL, 0x080fe40000410000ULL, 0x0000001144447220ULL, 0x080fe40000410000ULL,
0x0000001115157220ULL, 0x080fe40000410000ULL, 0x0000001114147220ULL, 0x000fc40000410000ULL,
0x0000001105057220ULL, 0x080fe40000410000ULL, 0x0000001104047220ULL, 0x080fe40000410000ULL,
0x0000001109097220ULL, 0x080fe40000410000ULL, 0x0000001108087220ULL, 0x080fe40000410000ULL,
0x000000110d0d7220ULL, 0x080fe40000410000ULL, 0x000000110c0c7220ULL, 0x000fc40000410000ULL,
0x000000ffff1c7224ULL, 0x004fe400078e0032ULL, 0x0000003113131220ULL, 0x010fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000001d131d7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fe40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0004e4000021f000ULL,
0x3fa0000010107823ULL, 0x004fe200000100ffULL, 0x000000110000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fc40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000031ff10723eULL, 0x000fe400000000ffULL,
0x00000004ff867819ULL, 0x100fe40000011602ULL, 0x00000002ff347819ULL, 0x000fe40000011602ULL,
0x0000541010107816ULL, 0x000fe20000000010ULL, 0x000139c27f007947ULL, 0x000fea000b800000ULL,
0x00001f3410617589ULL, 0x0004e400000e0000ULL, 0x0000000834327810ULL, 0x000fe20007ffe0ffULL,
0x00013a127f007947ULL, 0x000fea000b800000ULL, 0x00001f3210607589ULL, 0x0008a400000e0000ULL,
0x0000001034337810ULL, 0x000fe20007ffe0ffULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00001ae0005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0033ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00014c5000007944ULL, 0x01efea0003c00000ULL,
0x0000001834347810ULL, 0x004fe20007ffe0ffULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00001b60005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0034ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00014bd000007944ULL, 0x01afea0003c00000ULL,
0x0000000802107812ULL, 0x050fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000002202117211ULL, 0x000fc400078fe0ffULL, 0x0000000710127812ULL, 0x140fe400078ec802ULL,
0x0000000710217812ULL, 0x000fe400078ef802ULL, 0x0000001112677212ULL, 0x000fe400078e3cffULL,
0x0000002302107211ULL, 0x000fe400078fe0ffULL, 0x000099103a3a7816ULL, 0x000fe200000000ffULL,
0x0000001021697824ULL, 0x000fe200078e0267ULL, 0x0000001012667212ULL, 0x000fc400078e3cffULL,
0x000000ff3a00720cULL, 0x000fe40003f25270ULL, 0x0000c00069357811ULL, 0x000fe200078e20ffULL,
0x0000001021687824ULL, 0x040fe200078e0266ULL, 0x0000010021217811ULL, 0x000fc600078e20ffULL,
0x000000003554783bULL, 0x000f220000004200ULL, 0x0000c00068367811ULL, 0x000fe200078e20ffULL,
0x0000000167677824ULL, 0x100fe400078e0221ULL, 0x0000000166667824ULL, 0x000fe400078e0221ULL,
0x000000003610783bULL, 0x000f620000004200ULL, 0x0000c00067377811ULL, 0x000fe400078e20ffULL,
0x0000c00066387811ULL, 0x000fc600078e20ffULL, 0x000000003740783bULL, 0x000ee80000004200ULL,
0x00000000383c783bULL, 0x000ea20000004200ULL, 0x0000888054217816ULL, 0x050fe200000000ffULL,
0x0000010054397824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x004fe40000011454ULL,
0x00000021005a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff597819ULL, 0x000fc40000011455ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff5f7819ULL, 0x020fe40000011411ULL,
0x00000018ff5e7819ULL, 0x000fe20000011410ULL, 0x0001000041887824ULL, 0x008fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011412ULL, 0x0001000054217824ULL, 0x004fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011413ULL, 0x0000003900547306ULL, 0x0004e20000200c00ULL,
0x00000018ff717819ULL, 0x000fe20000011440ULL, 0x0000010042897824ULL, 0x000fe200078e00ffULL,
0x00000018ff217819ULL, 0x000fc40000011421ULL, 0x00000018ff707819ULL, 0x000fe40000011441ULL,
0x00000018ff627819ULL, 0x000fe20000011456ULL, 0x00000021005b7306ULL, 0x0009e20000200c00ULL,
0x0000888055397816ULL, 0x044fe400000000ffULL, 0x00000018ff637819ULL, 0x000fe40000011457ULL,
0x00000018ff6e7819ULL, 0x000fe4000001143cULL, 0x00000018ff6f7819ULL, 0x000fe2000001143dULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000000ffff217224ULL, 0x010fe200078e0039ULL,
0x000054105a547816ULL, 0x008fe20000000054ULL, 0x0000010055397824ULL, 0x000fe200078e00ffULL,
0x000088803d5a7816ULL, 0x000fc400000000ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011442ULL,
0x0000002100727306ULL, 0x0007e20000200c00ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff6d7819ULL, 0x000fe40000011443ULL, 0x00000018ff6a7819ULL, 0x000fe4000001143eULL,
0x00000018ff6b7819ULL, 0x000fe2000001143fULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0001000055217824ULL, 0x008fe200078e00ffULL, 0x000054105b587816ULL, 0x004fc40000000058ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000003900557306ULL, 0x0004e20000200c00ULL, 0x00000018ff897819ULL, 0x000fce0000011489ULL,
0x0000002100737306ULL, 0x0009620000200c00ULL, 0x0000888056397816ULL, 0x004fe400000000ffULL,
0x0000541072557816ULL, 0x008fc60000000055ULL, 0x000000ffff217224ULL, 0x010fe400078e0039ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000010056397824ULL, 0x040fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000002100747306ULL, 0x0005e20000200c00ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000541073597816ULL, 0x020fca0000000059ULL, 0x0000003900757306ULL, 0x0007220000200c00ULL,
0x0000888057217816ULL, 0x004fce00000000ffULL, 0x0000002100767306ULL, 0x0005e20000200c00ULL,
0x0000010057397824ULL, 0x048fe400078e00ffULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000888010217816ULL, 0x004fe400000000ffULL,
0x0000541074747816ULL, 0x010fca0000000075ULL, 0x0000003900777306ULL, 0x0004f00000200c00ULL,
0x0000002100787306ULL, 0x0009e20000200c00ULL, 0x0000010010397824ULL, 0x044fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x0000888011217816ULL, 0x010fe400000000ffULL, 0x0000541076757816ULL, 0x008fca0000000077ULL,
0x0000003900797306ULL, 0x0007300000200c00ULL, 0x00000010007a7306ULL, 0x000be20000200c00ULL,
0x0000010011397824ULL, 0x048fe200078e00ffULL, 0x0000541056567816ULL, 0x004fe20000000062ULL,
0x0001000011117824ULL, 0x000fc400078e00ffULL, 0x000001003e627824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x00000021007b7306ULL, 0x0005e20000200c00ULL, 0x0000888012107816ULL, 0x020fe400000000ffULL,
0x0000541078787816ULL, 0x010fe40000000079ULL, 0x00000018ff627819ULL, 0x000fc60000011462ULL,
0x00000011007d7306ULL, 0x0007e20000200c00ULL, 0x0000000702217812ULL, 0x004fc800078ec0ffULL,
0x0000000821217812ULL, 0x000fc600078ef802ULL, 0x00000010007e7306ULL, 0x0005e20000200c00ULL,
0x0000010012117824ULL, 0x048fe400078e00ffULL, 0x0001000012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000039007c7306ULL, 0x0007220000200c00ULL,
0x0000888013107816ULL, 0x004fe400000000ffULL, 0x00000018ff127819ULL, 0x000fca0000011412ULL,
0x00000011007f7306ULL, 0x0005e20000200c00ULL, 0x0000000786397812ULL, 0x008fca00078e7821ULL,
0x0000000821397824ULL, 0x000fe400078e0239ULL, 0x0000001000817306ULL, 0x0007e20000200c00ULL,
0x0000010013117824ULL, 0x004fe200078e00ffULL, 0x000054107b797816ULL, 0x010fe2000000007cULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000001200807306ULL, 0x000fe20000200c00ULL,
0x0000888040107816ULL, 0x008fce00000000ffULL, 0x0000001100827306ULL, 0x0005f00000200c00ULL,
0x0000001000847306ULL, 0x0007e20000200c00ULL, 0x0000010040117824ULL, 0x044fe400078e00ffULL,
0x0001000040407824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001300837306ULL, 0x000fe20000200c00ULL, 0x0000888041107816ULL, 0x008fe400000000ffULL,
0x00000018ff407819ULL, 0x000fca0000011440ULL, 0x0000001100857306ULL, 0x0005f00000200c00ULL,
0x0000001000867306ULL, 0x0007e20000200c00ULL, 0x0000010041117824ULL, 0x004fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000004000417306ULL, 0x0005e20000200c00ULL,
0x0000a00039107811ULL, 0x008fce00078e20ffULL, 0x0000001100877306ULL, 0x0007e20000200c00ULL,
0x0000888042407816ULL, 0x044fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x00000040008a7306ULL, 0x0005e20000200c00ULL,
0x000000001010783bULL, 0x008eee0000000200ULL, 0x0000005700577306ULL, 0x000f220000200c00ULL,
0x0000888043407816ULL, 0x004fca00000000ffULL, 0x000000ffff3a7224ULL, 0x000fe400078e0040ULL,
0x0000010043407824ULL, 0x040fe200078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0001000043437824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000003a008b7306ULL, 0x0005e20000200c00ULL,
0x0000541057577816ULL, 0x010fce0000000063ULL, 0x00000040008c7306ULL, 0x0009e20000200c00ULL,
0x000088803c3a7816ULL, 0x004fce00000000ffULL, 0x0000003a008d7306ULL, 0x0005e20000200c00ULL,
0x000001003c407824ULL, 0x050fe200078e00ffULL, 0x0000006110109232ULL, 0x088fe20000000000ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x0000006112129232ULL, 0x000fe40000000000ULL,
0x0000006011119232ULL, 0x080fe20000000000ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000006013139232ULL, 0x000fe20000000000ULL, 0x00000007263a7812ULL, 0x004fe200078e7821ULL,
0x0000005f005f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fc6000001143cULL,
0x00000008213a7824ULL, 0x000fe200078e023aULL, 0x00000054100c723cULL, 0x040fe6000000180cULL,
0x00000040008e7306ULL, 0x0007e80000200c00ULL, 0x000000ffff547224ULL, 0x000fe200078e005aULL,
0x000000741004723cULL, 0x000fe20000001804ULL, 0x000001003d557824ULL, 0x000fc400078e00ffULL,
0x0000005400727306ULL, 0x000fe20000200c00ULL, 0x0000a0003a407811ULL, 0x008fe200078e20ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x000000581058723cULL, 0x040fe20000001808ULL, 0x000000004008783bULL, 0x0007220000000200ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000005c005c7306ULL, 0x000fea0000200c00ULL,
0x000000781044723cULL, 0x040fe60000001844ULL, 0x0000005500407306ULL, 0x0087f00000200c00ULL,
0x0000005d005d7306ULL, 0x000f620000200c00ULL, 0x000000561054723cULL, 0x008fee0000001814ULL,
0x000088803e147816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000054107d157816ULL, 0x004fe2000000005fULL, 0x0000006200747306ULL, 0x0005e20000200c00ULL,
0x00005410815f7816ULL, 0x000fc40000000082ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x0000541083637816ULL, 0x020fc6000000005dULL, 0x0000001400737306ULL, 0x0007e20000200c00ULL,
0x0000541080627816ULL, 0x004fe2000000005cULL, 0x0000006108089232ULL, 0x090fe40000000000ULL,
0x000000610a0a9232ULL, 0x000fe40000000000ULL, 0x0000006009099232ULL, 0x080fe40000000000ULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0x000054107a147816ULL, 0x008fe2000000005eULL,
0x000000600b0b9232ULL, 0x000fe20000000000ULL, 0x000054107e5e7816ULL, 0x000fe2000000007fULL,
0x000000621060723cULL, 0x040fe80000001850ULL, 0x0000007000707306ULL, 0x000fe60000200c00ULL,
0x0000541084507816ULL, 0x000fe20000000085ULL, 0x000000141014723cULL, 0x000fe20000001848ULL,
0x0000541086517816ULL, 0x000fc60000000087ULL, 0x0000006e006e7306ULL, 0x000fe60000200c00ULL,
0x000088803f487816ULL, 0x040fe200000000ffULL, 0x000001003f497824ULL, 0x040fe200078e00ffULL,
0x0000005e105c723cULL, 0x000fe2000000184cULL, 0x000100003f3f7824ULL, 0x000fe400078e00ffULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x000000500850723cULL, 0x000fe2000000180cULL,
0x0000541041107816ULL, 0x004fe40000000071ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000054108b4d7816ULL, 0x000fc6000000008cULL, 0x00005410730c7816ULL, 0x000fc80000000074ULL,
0x0000006d006d7306ULL, 0x000ff00000200c00ULL, 0x0000008800887306ULL, 0x000eb00000200c00ULL,
0x0000008900897306ULL, 0x000ef00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541088117816ULL, 0x004fce0000000070ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000054108a4c7816ULL, 0x008fe20000000089ULL, 0x000000100810723cULL, 0x040fec0000001858ULL,
0x0000004800757306ULL, 0x0005e40000200c00ULL, 0x0000004c084c723cULL, 0x000fec0000001804ULL,
0x0000004900767306ULL, 0x0007220000200c00ULL, 0x000054108d487816ULL, 0x004fce000000008eULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000541072497816ULL, 0x008fce0000000040ULL,
0x0000004300437306ULL, 0x000ee20000200c00ULL, 0x000000480848723cULL, 0x000fe20000001844ULL,
0x00005410750d7816ULL, 0x010fcc0000000076ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x000054103c447816ULL, 0x000fe2000000006eULL, 0x0000000c080c723cULL, 0x000fe2000000185cULL,
0x000054103d457816ULL, 0x000fe4000000006fULL, 0x00005410426c7816ULL, 0x004fc6000000006cULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00005410436d7816ULL, 0x008fe2000000006dULL,
0x000000440844723cULL, 0x040fec0000001814ULL, 0x0000003e003e7306ULL, 0x000ea40000200c00ULL,
0x0000006c0854723cULL, 0x000fec0000001854ULL, 0x0000003f003f7306ULL, 0x000ee20000200c00ULL,
0x000054103e6a7816ULL, 0x004fc4000000006aULL, 0x000054103f6b7816ULL, 0x008fce000000006bULL,
0x0000006a0808723cULL, 0x000fe20000001860ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff047f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff067984ULL, 0x000ea40000000800ULL,
0x8000000006ff7812ULL, 0x004fe40007844805ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff067984ULL, 0x000ea40000000800ULL, 0x8000000006ff7812ULL, 0x004fc40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff067424ULL, 0x000fc800078e00ffULL, 0x0000000600077305ULL, 0x0004e4000021f000ULL,
0x3fa0000006067823ULL, 0x004fe200000100ffULL, 0x000000070000735dULL, 0x008fe40003800000ULL,
0x0106bc00ff077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe40007844805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000004018047811ULL, 0x000fe200078e40ffULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x00000004ff177819ULL, 0x000fc40000011602ULL,
0x0000000403057217ULL, 0x000fe20007800000ULL, 0x000062001b167a24ULL, 0x100fe200078e0204ULL,
0x0000c0003b3b7811ULL, 0x000fe400078e20ffULL, 0x0000c000203e7811ULL, 0x000fe200078e20ffULL,
0x0000000105057824ULL, 0x000fe400078e0a04ULL, 0x0000000124047824ULL, 0x100fe400078e0216ULL,
0x0000000129077824ULL, 0x100fe200078e0216ULL, 0x0000002005057807ULL, 0x000fe20000000000ULL,
0x000000012a147824ULL, 0x000fc400078e0216ULL, 0x000000012b167824ULL, 0x000fe200078e0216ULL,
0x000000051a067217ULL, 0x000fe20007800000ULL, 0x00005e0004047625ULL, 0x000fc800078e003dULL,
0x00000001063c7824ULL, 0x000fe200078e0a1aULL, 0x0000002504047210ULL, 0x000fe20007f7e0ffULL,
0x00005e0007067625ULL, 0x000fc600078e003dULL, 0x0000003c1700720cULL, 0x000fe20003f46070ULL,
0x00005e0014147625ULL, 0x000fe200078e003dULL, 0x0000002506067210ULL, 0x000fc60007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200018e0605ULL, 0x0000002514147210ULL, 0x000fe20007fbe0ffULL,
0x00005e0016167625ULL, 0x000fe200078e003dULL, 0x0000003c2600720cULL, 0x080fe40003f66070ULL,
0x0000c000643d7811ULL, 0x000fe200078e20ffULL, 0x000000ffff077224ULL, 0x000fe200020e0607ULL,
0x0000003c2700720cULL, 0x080fe20003f86070ULL, 0x000000ffff157224ULL, 0x000fe200028e0615ULL,
0x0000003c2800720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000043b7faeULL, 0x0005e2000d101c46ULL, 0x0000002516167210ULL, 0x000fc40007fde0ffULL,
0x0000c000653c7811ULL, 0x000fc600078e20ffULL, 0x000000ffff177224ULL, 0x000fe400030e0617ULL,
0x00000000063c7faeULL, 0x0007e8000d901c46ULL, 0x00000000143d7faeULL, 0x0007e8000e101c46ULL,
0x00000000163e7faeULL, 0x0007e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106a800ff047f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff067984ULL, 0x008ea40000000800ULL, 0x8000000006ff7812ULL, 0x006fc4000784481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0005ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe4000784481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0106b400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc4000784481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000031ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff5a7819ULL, 0x000fe40000011602ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x000123b27f007947ULL, 0x000fea000b800000ULL, 0x00001f5a04657589ULL, 0x0002a400000e0000ULL,
0x000124027f007947ULL, 0x000fea000b800000ULL, 0x00001f3204647589ULL, 0x00072400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0004ULL,
0x000031d0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fe400078e0033ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fc400078e00ffULL,
0x0001356000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00003240005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x002fc400078e0034ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000134f000007944ULL, 0x01cfea0003c00000ULL,
0x0000e000693f7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000e00068407811ULL, 0x000fe400078e20ffULL, 0x0000e000671e7811ULL, 0x000fe200078e20ffULL,
0x000000003f04783bULL, 0x00ae620000004200ULL, 0x0000e000661f7811ULL, 0x000fc600078e20ffULL,
0x00000000405c783bULL, 0x000ee80000004200ULL, 0x000000001e58783bULL, 0x004ea80000004200ULL,
0x000000001f14783bULL, 0x000f620000004200ULL, 0x00000018ff727819ULL, 0x002fe20000011404ULL,
0x0000010004607824ULL, 0x040fe200078e00ffULL, 0x0000888004207816ULL, 0x040fe200000000ffULL,
0x0001000004047824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fc40000011405ULL,
0x0000002000617306ULL, 0x0003e20000200c00ULL, 0x00000018ff707819ULL, 0x000fe40000011406ULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x00000018ff717819ULL, 0x000fe40000011407ULL,
0x00000018ff6e7819ULL, 0x008fe2000001145cULL, 0x0000000400747306ULL, 0x0007e20000200c00ULL,
0x0000888005207816ULL, 0x002fe400000000ffULL, 0x00000018ff6d7819ULL, 0x004fc40000011458ULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x00000018ff6f7819ULL, 0x000fe2000001145dULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000000ffff047224ULL, 0x008fe200078e0020ULL,
0x00000018ff6c7819ULL, 0x000fe20000011459ULL, 0x0000010005207824ULL, 0x040fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001145eULL, 0x0001000005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001145fULL, 0x0000000400627306ULL, 0x0003e20000200c00ULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000018ff6a7819ULL, 0x000fe4000001145aULL, 0x00000018ff6b7819ULL, 0x000fe2000001145bULL,
0x0000000500757306ULL, 0x0005e20000200c00ULL, 0x0000888006047816ULL, 0x002fe400000000ffULL,
0x00000018ff687819ULL, 0x020fe40000011414ULL, 0x00000018ff697819ULL, 0x000fc40000011415ULL,
0x00000018ff427819ULL, 0x000fe20000011416ULL, 0x0000000400767306ULL, 0x0003e20000200c00ULL,
0x0000010006057824ULL, 0x044fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011417ULL,
0x0001000006067824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000002000637306ULL, 0x0005e20000200c00ULL, 0x0000888007047816ULL, 0x002fe400000000ffULL,
0x00000018ff067819ULL, 0x000fca0000011406ULL, 0x0000000500777306ULL, 0x0003e20000200c00ULL,
0x0000000727207812ULL, 0x004fca00078e7821ULL, 0x0000000821207824ULL, 0x000fe400078e0220ULL,
0x0000000400797306ULL, 0x0005e20000200c00ULL, 0x0000010007057824ULL, 0x042fe400078e00ffULL,
0x0001000007077824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000000600787306ULL, 0x0003e20000200c00ULL, 0x000088805c047816ULL, 0x004fe400000000ffULL,
0x00000018ff077819ULL, 0x000fca0000011407ULL, 0x00000005007a7306ULL, 0x0005e20000200c00ULL,
0x0000010059067824ULL, 0x002fce00078e00ffULL, 0x00000004007c7306ULL, 0x0003e20000200c00ULL,
0x000001005c057824ULL, 0x044fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x00000007007b7306ULL, 0x000fe20000200c00ULL, 0x000088805d047816ULL, 0x002fce00000000ffULL,
0x00000005007d7306ULL, 0x0003f00000200c00ULL, 0x00000004007f7306ULL, 0x0005e20000200c00ULL,
0x000001005d057824ULL, 0x042fe400078e00ffULL, 0x000100005d5d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000005c007e7306ULL, 0x0003e20000200c00ULL,
0x000088805e047816ULL, 0x004fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fca000001145dULL,
0x0000000500807306ULL, 0x0005e20000200c00ULL, 0x00000018ff5c7819ULL, 0x002fce0000011406ULL,
0x0000000400827306ULL, 0x0003e20000200c00ULL, 0x000001005e057824ULL, 0x044fe400078e00ffULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x000088805f047816ULL, 0x002fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fca000001145eULL, 0x0000000500837306ULL, 0x0003f00000200c00ULL,
0x0000000400857306ULL, 0x0007e20000200c00ULL, 0x000001005f057824ULL, 0x002fe200078e00ffULL,
0x0000541061607816ULL, 0x004fe20000000060ULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x0000541062617816ULL, 0x000fc40000000063ULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000888058047816ULL, 0x008fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fca000001145fULL, 0x0000000500867306ULL, 0x0005f00000200c00ULL,
0x0000000400887306ULL, 0x0007e20000200c00ULL, 0x0000010058057824ULL, 0x044fe400078e00ffULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff057819ULL, 0x000fe40000011405ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005d00817306ULL, 0x0003e20000200c00ULL,
0x0000888059047816ULL, 0x048fe200000000ffULL, 0x0001000059597824ULL, 0x000fca00078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000000500897306ULL, 0x0005e20000200c00ULL,
0x00005410755d7816ULL, 0x002fce0000000073ULL, 0x00000058008a7306ULL, 0x0003e20000200c00ULL,
0x000000ffff057224ULL, 0x004fe200078e0004ULL, 0x0000a00020047811ULL, 0x000fcc00078e20ffULL,
0x00000005008b7306ULL, 0x0005e20000200c00ULL, 0x000088805a587816ULL, 0x002fce00000000ffULL,
0x00000058008e7306ULL, 0x0003e20000200c00ULL, 0x000000000404783bULL, 0x004eae0000000200ULL,
0x0000005c008c7306ULL, 0x0007e20000200c00ULL, 0x000088805b587816ULL, 0x002fce00000000ffULL,
0x0000005800917306ULL, 0x0003e20000200c00ULL, 0x00005410745c7816ULL, 0x008fce0000000072ULL,
0x00000059008d7306ULL, 0x0007e20000200c00ULL, 0x0000000728587812ULL, 0x002fca00078e7821ULL,
0x0000000821217824ULL, 0x000fe200078e0258ULL, 0x0000888014587816ULL, 0x000fe200000000ffULL,
0x0000005e00847306ULL, 0x000fe20000200c00ULL, 0x000001005a597824ULL, 0x048fe400078e00ffULL,
0x000100005a5a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005f00877306ULL, 0x000fe20000200c00ULL, 0x0000006504049232ULL, 0x084fe20000000000ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006506069232ULL, 0x000fe40000000000ULL,
0x0000006405059232ULL, 0x090fe40000000000ULL, 0x0000006407079232ULL, 0x000fe20000000000ULL,
0x00000059008f7306ULL, 0x0003ec0000200c00ULL, 0x000000600460723cULL, 0x000fe40000001850ULL,
0x0000007000707306ULL, 0x000ea20000200c00ULL, 0x000001005b597824ULL, 0x002fc400078e00ffULL,
0x000100005b5b7824ULL, 0x000fe400078e00ffULL, 0x0000a00021507811ULL, 0x000fe200078e20ffULL,
0x0000005c045c723cULL, 0x000fe20000001810ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x000000ffff517224ULL, 0x000fe200078e0058ULL,
0x000000005010783bULL, 0x0007220000000200ULL, 0x0000541076587816ULL, 0x000fe20000000077ULL,
0x0000010014527824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0001000014147824ULL, 0x000fc400078e00ffULL, 0x0000005900927306ULL, 0x000be20000200c00ULL,
0x0000541078707816ULL, 0x004fe40000000070ULL, 0x0000888015507816ULL, 0x008fe400000000ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x0000541079597816ULL, 0x020fe4000000007aULL,
0x000054107b717816ULL, 0x002fca0000000071ULL, 0x0000006f006f7306ULL, 0x000fe40000200c00ULL,
0x000000700454723cULL, 0x000fec0000001854ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000006510109232ULL, 0x010fc40000000000ULL,
0x0000006512129232ULL, 0x000fe40000000000ULL, 0x0000006411119232ULL, 0x000fc60000000000ULL,
0x0000005a00907306ULL, 0x000fe20000200c00ULL, 0x0000541084667816ULL, 0x002fe20000000066ULL,
0x0000006413139232ULL, 0x000fcc0000000000ULL, 0x0000005b00937306ULL, 0x0003e20000200c00ULL,
0x0000541087677816ULL, 0x004fce0000000067ULL, 0x0000005100947306ULL, 0x0005e20000200c00ULL,
0x000000580458723cULL, 0x042fee000000184cULL, 0x00000100154d7824ULL, 0x000fe200078e00ffULL,
0x000054107f517816ULL, 0x004fe20000000080ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0050ULL,
0x000054107c507816ULL, 0x000fe2000000007dULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x000000660464723cULL, 0x000fe20000001808ULL,
0x0001000015157824ULL, 0x000fca00078e00ffULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff157819ULL, 0x000fce0000011415ULL, 0x0000005200727306ULL, 0x0007e20000200c00ULL,
0x000054108a087816ULL, 0x002fce000000006dULL, 0x0000004c00737306ULL, 0x0003e20000200c00ULL,
0x000000500450723cULL, 0x008fe20000001848ULL, 0x000054108d097816ULL, 0x004fcc000000006cULL,
0x0000004d00717306ULL, 0x0004e20000200c00ULL, 0x000054107e487816ULL, 0x000fe2000000006eULL,
0x000000081008723cULL, 0x000fe2000000185cULL, 0x0000541081497816ULL, 0x000fe4000000006fULL,
0x00005410824c7816ULL, 0x002fc60000000083ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x00005410854d7816ULL, 0x004fe20000000086ULL, 0x000000480448723cULL, 0x040fec0000001844ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541073457816ULL, 0x008fe20000000071ULL,
0x0000004c044c723cULL, 0x000fec000000180cULL, 0x0000001400707306ULL, 0x0007e20000200c00ULL,
0x0000010017057824ULL, 0x040fe200078e00ffULL, 0x0000888017047816ULL, 0x040fe200000000ffULL,
0x00000100160d7824ULL, 0x000fe200078e00ffULL, 0x00005410906a7816ULL, 0x002fe2000000006aULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fc40000011405ULL,
0x0000000400757306ULL, 0x0003e20000200c00ULL, 0x0000888016147816ULL, 0x048fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00005410936b7816ULL, 0x004fe4000000006bULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x000000ffff0c7224ULL, 0x000fe200078e0014ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x00000005005c7306ULL, 0x0004e20000200c00ULL,
0x000054108e047816ULL, 0x002fe4000000008fULL, 0x00000018ff447819ULL, 0x000fca0000011417ULL,
0x00000015006e7306ULL, 0x000fe20000200c00ULL, 0x0000541091057816ULL, 0x004fce0000000092ULL,
0x000000041004723cULL, 0x000fe20000001858ULL, 0x0000001600587306ULL, 0x0003e20000200c00ULL,
0x0000541075757816ULL, 0x008fce000000005cULL, 0x0000006800687306ULL, 0x000ea20000200c00ULL,
0x0000006a1014723cULL, 0x002fee0000001854ULL, 0x0000006900697306ULL, 0x000e700000200c00ULL,
0x0000004200427306ULL, 0x000ee20000200c00ULL, 0x0000541070687816ULL, 0x004fce0000000068ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000054106e697816ULL, 0x002fce0000000069ULL,
0x0000000c006f7306ULL, 0x0003e20000200c00ULL, 0x0000541058427816ULL, 0x008fe20000000042ULL,
0x000000681048723cULL, 0x000fec0000001848ULL, 0x0000000d00747306ULL, 0x0004e20000200c00ULL,
0x00005410880c7816ULL, 0x002fce0000000089ULL, 0x0000004400547306ULL, 0x0003220000200c00ULL,
0x000054108b0d7816ULL, 0x004fe4000000008cULL, 0x000054106f747816ULL, 0x008fca0000000074ULL,
0x0000000c100c723cULL, 0x000fe20000001860ULL, 0x0000541094447816ULL, 0x002fe40000000072ULL,
0x0000541054437816ULL, 0x010fca0000000043ULL, 0x000000441044723cULL, 0x040ff00000001850ULL,
0x00000074104c723cULL, 0x040ff0000000184cULL, 0x000000421050723cULL, 0x000fe20000001864ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004018107811ULL, 0x002fe200078e40ffULL, 0x01068800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000100300720cULL, 0x000fe20003f24070ULL, 0x000000ffff107224ULL, 0x000fd800078e0011ULL,
0x000090b000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007824810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fc800078e00ffULL, 0x0000001100127305ULL, 0x0002a4000021f000ULL,
0x3fa0000011117823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007824810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006018107811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff577819ULL, 0x000fe40000011602ULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x000062001b427a24ULL, 0x000fc800078e0210ULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x0000000124107824ULL, 0x100fe400078e0242ULL,
0x0000000129137824ULL, 0x000fe200078e0242ULL, 0x0000002011127807ULL, 0x000fe20000000000ULL,
0x00005e0010107625ULL, 0x000fc600078e0058ULL, 0x000000121a437217ULL, 0x000fe20007800000ULL,
0x00005e0013127625ULL, 0x000fe200078e0058ULL, 0x0000002510547210ULL, 0x000fc60007f3e0ffULL,
0x0000000143567824ULL, 0x000fe200078e0a1aULL, 0x0000002512127210ULL, 0x000fe20007f7e0ffULL,
0x000000012a107824ULL, 0x100fe400078e0242ULL, 0x000000012b427824ULL, 0x000fe200078e0242ULL,
0x000000565700720cULL, 0x080fe20003f46070ULL, 0x000000ffff557224ULL, 0x000fe200008e0611ULL,
0x000000562600720cULL, 0x000fe20003f26070ULL, 0x00005e0010107625ULL, 0x000fe200078e0058ULL,
0x000000562800720cULL, 0x000fc60003f86070ULL, 0x00005e0042427625ULL, 0x000fe200078e0058ULL,
0x0000002510107210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x000000562700720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x0000002542427210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000542c7faeULL, 0x0003e8000d101c46ULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x00000000122d7faeULL, 0x0003ea000c901c46ULL, 0x00000000102e7faeULL, 0x0005e8000d901c46ULL,
0x00000000422f7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106b000ff687f8cULL, 0x000e68000c80043fULL,
0x0106ac00ff127984ULL, 0x000ea20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010628001a107f8cULL, 0x000fe2000c80043fULL,
0x8000000012ff7812ULL, 0x004fc60007844841ULL, 0x01062c001a137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007824811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0004e4000021f000ULL,
0x3fa0000012127823ULL, 0x004fe200000100ffULL, 0x000000130000735dULL, 0x008fe40003800000ULL,
0x01062c001a137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0100800030127984ULL, 0x000ea80000000800ULL,
0x0102800030137984ULL, 0x0007220000000800ULL, 0x0000001c1200720bULL, 0x004fe20003f3d000ULL,
0x00010e027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800008e0100ULL,
0x0000ffff10437812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff717424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000010000780cULL, 0x000fe40003f65270ULL, 0x0000001c1200720bULL, 0x000fe20003f34000ULL,
0x00010de27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x000000121c117209ULL, 0x000fe40007810000ULL, 0x0000ffff10107812ULL, 0x000fe400078e3cffULL,
0x00000002ff587819ULL, 0x000fe20000011602ULL, 0x800000111c427221ULL, 0x000fe20000010000ULL,
0x010480113000b388ULL, 0x0005e20000000800ULL, 0x0000001043ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL, 0x0000004200597308ULL, 0x000ee40000000800ULL,
0x000000591d1d7220ULL, 0x008fe20000410000ULL, 0x00010d927f007947ULL, 0x000fea000b800000ULL,
0x00001f5859587589ULL, 0x0044e400000e0000ULL, 0x000000580c0c7220ULL, 0x08cfe40000410000ULL,
0x000000580d0d7220ULL, 0x080fe40000410000ULL, 0x0000005808087220ULL, 0x080fe40000410000ULL,
0x0000005809097220ULL, 0x080fe40000410000ULL, 0x0000005804047220ULL, 0x000fc40000410000ULL,
0x0000005805057220ULL, 0x080fe40000410000ULL, 0x0000005814147220ULL, 0x080fe40000410000ULL,
0x0000005815157220ULL, 0x080fe40000410000ULL, 0x0000005844447220ULL, 0x080fe40000410000ULL,
0x0000005845457220ULL, 0x080fe40000410000ULL, 0x0000005848487220ULL, 0x000fc40000410000ULL,
0x0000005849497220ULL, 0x080fe40000410000ULL, 0x000000584c4c7220ULL, 0x080fe40000410000ULL,
0x000000584d4d7220ULL, 0x080fe40000410000ULL, 0x0000005850507220ULL, 0x080fe40000410000ULL,
0x0000005851517220ULL, 0x000fe20000410000ULL, 0x00010cd27f007947ULL, 0x000fea000b800000ULL,
0x00001f3259587589ULL, 0x0004e400000e0000ULL, 0x000000121c1c7209ULL, 0x000fe20007810000ULL,
0x000000580e0e7220ULL, 0x08cfe20000410000ULL, 0x00000001ff717807ULL, 0x000fe20000800000ULL,
0x000000580f0f7220ULL, 0x000fc40000410000ULL, 0x8000001c12121221ULL, 0x000fe40000010000ULL,
0x000000580a0a7220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b12121820ULL, 0x000fe40000410000ULL,
0x000000580b0b7220ULL, 0x080fe40000410000ULL, 0x0000001200311308ULL, 0x000ea20000000800ULL,
0x0000005806067220ULL, 0x080fe40000410000ULL, 0x0000005807077220ULL, 0x000fc40000410000ULL,
0x0000005816167220ULL, 0x080fe40000410000ULL, 0x0000005817177220ULL, 0x080fe40000410000ULL,
0x0000005846467220ULL, 0x080fe40000410000ULL, 0x0000005847477220ULL, 0x080fe40000410000ULL,
0x000000584a4a7220ULL, 0x080fe40000410000ULL, 0x000000584b4b7220ULL, 0x000fc40000410000ULL,
0x000000584e4e7220ULL, 0x080fe40000410000ULL, 0x000000584f4f7220ULL, 0x080fe40000410000ULL,
0x0000005852527220ULL, 0x080fe40000410000ULL, 0x0000005853537220ULL, 0x000fe40000410000ULL,
0x0000001331131220ULL, 0x014fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000001d131d7221ULL, 0x010fe20000010000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106ac00ff107984ULL, 0x000ea40000000800ULL,
0x8000000010ff7812ULL, 0x004fc40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0004e4000021f000ULL, 0x3fa0000010107823ULL, 0x004fe200000100ffULL,
0x000000110000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe40007824841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000031ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff5a7819ULL, 0x000fc40000011602ULL,
0x0000541010107816ULL, 0x000fe20000000010ULL, 0x00010a727f007947ULL, 0x000fea000b800000ULL,
0x00001f5a10657589ULL, 0x0004e400000e0000ULL, 0x00010ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f3210647589ULL, 0x0008a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00004d80005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x004fe400078e0033ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000119b000007944ULL, 0x01afea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x00004df0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x004fe400078e0034ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0001194000007944ULL, 0x01afea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003554783bULL, 0x000f680000004200ULL, 0x00000000365c783bULL, 0x000f280000004200ULL,
0x000000003758783bULL, 0x004ea80000004200ULL, 0x000000003810783bULL, 0x010f220000004200ULL,
0x00000018ff6f7819ULL, 0x020fe20000011454ULL, 0x0000010054737824ULL, 0x040fe200078e00ffULL,
0x0000888054727816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x0000888055757816ULL, 0x000fc400000000ffULL, 0x00000018ff707819ULL, 0x000fe20000011455ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x00000018ff667819ULL, 0x000fe40000011456ULL, 0x00000018ff677819ULL, 0x000fe40000011457ULL,
0x00000018ff627819ULL, 0x000fe2000001145cULL, 0x0000005400747306ULL, 0x000be20000200c00ULL,
0x00000018ff737819ULL, 0x000fc40000011473ULL, 0x00000018ff6d7819ULL, 0x004fe40000011459ULL,
0x00000018ff6e7819ULL, 0x000fe40000011458ULL, 0x00000018ff6b7819ULL, 0x000fe2000001145aULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000000ffff547224ULL, 0x020fe200078e0075ULL,
0x00000018ff6c7819ULL, 0x000fe2000001145bULL, 0x0000010055757824ULL, 0x040fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe2000001145dULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc4000001145eULL, 0x0000005400767306ULL, 0x0005e20000200c00ULL,
0x00000018ff757819ULL, 0x000fe40000011475ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff617819ULL, 0x000fe4000001145fULL, 0x00000018ff437819ULL, 0x010fe20000011410ULL,
0x0000005500777306ULL, 0x0009e20000200c00ULL, 0x0000888056547816ULL, 0x004fe400000000ffULL,
0x00000018ff6a7819ULL, 0x000fc40000011411ULL, 0x00000018ff417819ULL, 0x000fe40000011412ULL,
0x00000018ff427819ULL, 0x000fe20000011413ULL, 0x0000005400787306ULL, 0x0005e20000200c00ULL,
0x0000010056557824ULL, 0x050fe400078e00ffULL, 0x0001000056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000007300737306ULL, 0x000f220000200c00ULL, 0x0000888057547816ULL, 0x004fce00000000ffULL,
0x0000005500797306ULL, 0x0005f00000200c00ULL, 0x00000054007b7306ULL, 0x000be20000200c00ULL,
0x0000010057557824ULL, 0x044fe200078e00ffULL, 0x0000541072727816ULL, 0x010fe20000000073ULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x00000056007a7306ULL, 0x000fe20000200c00ULL,
0x000088805c547816ULL, 0x020fce00000000ffULL, 0x00000055007c7306ULL, 0x0005f00000200c00ULL,
0x00000054007e7306ULL, 0x0009e20000200c00ULL, 0x000001005c557824ULL, 0x044fe400078e00ffULL,
0x000100005c5c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000057007d7306ULL, 0x000fe20000200c00ULL, 0x000088805d547816ULL, 0x010fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fca000001145cULL, 0x00000055007f7306ULL, 0x0005300000200c00ULL,
0x0000005400817306ULL, 0x000be20000200c00ULL, 0x000001005d557824ULL, 0x044fe400078e00ffULL,
0x000100005d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005c00807306ULL, 0x0005e20000200c00ULL, 0x000088805e547816ULL, 0x020fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000054107e7e7816ULL, 0x010fc6000000007fULL,
0x0000005500827306ULL, 0x0009620000200c00ULL, 0x00009910715c7816ULL, 0x004fc800000000ffULL,
0x000000ff5c00720cULL, 0x000fe40003f25270ULL, 0x0000a8003a5c7811ULL, 0x000fe200078e20ffULL,
0x0000005400847306ULL, 0x0005e20000200c00ULL, 0x000001005e557824ULL, 0x050fe400078e00ffULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000007500757306ULL, 0x000f220000200c00ULL, 0x000088805f547816ULL, 0x004fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x00005410817f7816ULL, 0x020fc60000000082ULL,
0x0000005500857306ULL, 0x0005f00000200c00ULL, 0x0000005400877306ULL, 0x000be20000200c00ULL,
0x000001005f557824ULL, 0x044fe200078e00ffULL, 0x0000541076737816ULL, 0x010fe20000000075ULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000888058547816ULL, 0x020fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fca000001145fULL, 0x0000005500887306ULL, 0x0005f00000200c00ULL,
0x00000054008a7306ULL, 0x0009e20000200c00ULL, 0x0000010058557824ULL, 0x044fe400078e00ffULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005d00837306ULL, 0x0005e20000200c00ULL,
0x0000888059547816ULL, 0x010fce00000000ffULL, 0x00000055008b7306ULL, 0x0009e20000200c00ULL,
0x00000100105d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x00000054008d7306ULL, 0x0005e20000200c00ULL, 0x0000010059557824ULL, 0x050fe400078e00ffULL,
0x0001000059597824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x00000058008c7306ULL, 0x0009e20000200c00ULL,
0x0000a80039547811ULL, 0x004fce00078e20ffULL, 0x00000055008e7306ULL, 0x0005e20000200c00ULL,
0x000088805a587816ULL, 0x010fce00000000ffULL, 0x00000059008f7306ULL, 0x0009e20000200c00ULL,
0x000000005454783bULL, 0x004eae0000000200ULL, 0x0000005800907306ULL, 0x000be20000200c00ULL,
0x000001005a597824ULL, 0x050fe400078e00ffULL, 0x000100005a5a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000006200627306ULL, 0x000f220000200c00ULL, 0x000088805b587816ULL, 0x020fce00000000ffULL,
0x0000005900917306ULL, 0x000bf00000200c00ULL, 0x0000005800927306ULL, 0x0007e20000200c00ULL,
0x000001005b597824ULL, 0x060fe200078e00ffULL, 0x0000541080627816ULL, 0x010fe20000000062ULL,
0x000100005b5b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000006554549232ULL, 0x08cfe20000000000ULL, 0x0000888010587816ULL, 0x040fe200000000ffULL,
0x0000006556569232ULL, 0x000fe20000000000ULL, 0x0000005900937306ULL, 0x0005e20000200c00ULL,
0x0000006455559232ULL, 0x080fe20000000000ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000006457579232ULL, 0x000fe20000000000ULL, 0x0001000010107824ULL, 0x000fc800078e00ffULL,
0x0000005a00717306ULL, 0x000fe20000200c00ULL, 0x0000541077597816ULL, 0x004fe20000000070ULL,
0x00000072540c723cULL, 0x000fe2000000180cULL, 0x0000888011707816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fc60000011410ULL, 0x0000005800727306ULL, 0x0005e40000200c00ULL,
0x0000007e5444723cULL, 0x000fec0000001844ULL, 0x0000005b00947306ULL, 0x0007e20000200c00ULL,
0x0000541074587816ULL, 0x004fce000000006fULL, 0x0000005d006f7306ULL, 0x0005e20000200c00ULL,
0x000000585458723cULL, 0x008fe20000001808ULL, 0x000000005c08783bULL, 0x00072c0000000200ULL,
0x0000006300637306ULL, 0x000f620000200c00ULL, 0x000054107b5d7816ULL, 0x004fe4000000007cULL,
0x00005410785c7816ULL, 0x008fca0000000079ULL, 0x0000005e00867306ULL, 0x000ff00000200c00ULL,
0x0000005f00897306ULL, 0x0005e20000200c00ULL, 0x0000541083637816ULL, 0x020fce0000000063ULL,
0x0000006600667306ULL, 0x000ee20000200c00ULL, 0x0000005c545c723cULL, 0x044fee0000001804ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x0000010011057824ULL, 0x040fe200078e00ffULL,
0x000000625448723cULL, 0x000fe20000001848ULL, 0x000000ffff047224ULL, 0x000fe200078e0070ULL,
0x0000006508089232ULL, 0x090fe20000000000ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x000000650a0a9232ULL, 0x000fe20000000000ULL,
0x0000006000607306ULL, 0x000f220000200c00ULL, 0x000054107a667816ULL, 0x008fe20000000066ULL,
0x0000006409099232ULL, 0x080fe20000000000ULL, 0x0000541084627816ULL, 0x000fe20000000085ULL,
0x000000640b0b9232ULL, 0x000fe20000000000ULL, 0x0000541087637816ULL, 0x000fc40000000088ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x000054107d677816ULL, 0x004fce0000000067ULL, 0x0000000500737306ULL, 0x0005e20000200c00ULL,
0x000000665414723cULL, 0x000fee0000001814ULL, 0x0000000400707306ULL, 0x000a620000200c00ULL,
0x0000010012057824ULL, 0x004fe200078e00ffULL, 0x0000541086667816ULL, 0x010fc40000000060ULL,
0x0000541089677816ULL, 0x008fe40000000061ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x000000625460723cULL, 0x000fe2000000184cULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000888012047816ULL, 0x060fe200000000ffULL, 0x0001000012127824ULL, 0x000fc800078e00ffULL,
0x00008880134c7816ULL, 0x000fe200000000ffULL, 0x000000665464723cULL, 0x000fe20000001850ULL,
0x0000006d006d7306ULL, 0x000ee20000200c00ULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00005410704d7816ULL, 0x002fca0000000073ULL, 0x0000000400747306ULL, 0x0003e20000200c00ULL,
0x000054108c507816ULL, 0x004fce000000006eULL, 0x0000000500757306ULL, 0x0005e20000200c00ULL,
0x000054108a047816ULL, 0x002fe4000000008bULL, 0x000054108f517816ULL, 0x008fca000000006dULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x000054108d057816ULL, 0x004fe2000000008eULL,
0x000000500850723cULL, 0x040fec0000001858ULL, 0x0000006c006c7306ULL, 0x000ea40000200c00ULL,
0x000000040804723cULL, 0x000fec000000180cULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00000100130d7824ULL, 0x000fe200078e00ffULL, 0x0000541071547816ULL, 0x002fe2000000006bULL,
0x0001000013137824ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e004cULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541094557816ULL, 0x004fe4000000006cULL,
0x00005410724c7816ULL, 0x000fca000000006fULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000000540854723cULL, 0x040fee0000001814ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000004c084c723cULL, 0x000fee0000001844ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x0000541074447816ULL, 0x000fce0000000075ULL, 0x0000001100117306ULL, 0x000eb00000200c00ULL,
0x0000000c00767306ULL, 0x0007e20000200c00ULL, 0x0000541010107816ULL, 0x002fce0000000043ULL,
0x0000000d00587306ULL, 0x0003220000200c00ULL, 0x00005410900c7816ULL, 0x008fe40000000091ULL,
0x0000541011117816ULL, 0x004fca000000006aULL, 0x0000001200127306ULL, 0x000ea20000200c00ULL,
0x00005410920d7816ULL, 0x002fe20000000093ULL, 0x000000100848723cULL, 0x040fec0000001848ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x0000541076457816ULL, 0x010fe20000000058ULL,
0x0000000c080c723cULL, 0x000fe2000000185cULL, 0x0000541012147816ULL, 0x004fce0000000041ULL,
0x000000440844723cULL, 0x000fe20000001860ULL, 0x0000541013157816ULL, 0x002fce0000000042ULL,
0x000000140814723cULL, 0x000fe20000001864ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0106b800ff087f8cULL, 0x000fe8000c80043fULL, 0x0106bc00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fe40007844809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007844809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007844809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008018087811ULL, 0x000fe200078e40ffULL,
0x00000100ff437424ULL, 0x000fe200078e00ffULL, 0x00000004ff427819ULL, 0x000fc40000011602ULL,
0x0000000803097217ULL, 0x000fe20007800000ULL, 0x000062001b137a24ULL, 0x000fc800078e0208ULL,
0x0000000109097824ULL, 0x000fe400078e0a08ULL, 0x0000000124087824ULL, 0x100fe400078e0213ULL,
0x00000001290b7824ULL, 0x100fe200078e0213ULL, 0x00000020090a7807ULL, 0x000fe20000000000ULL,
0x000000012a117824ULL, 0x000fe400078e0213ULL, 0x00005e0008087625ULL, 0x000fe200078e0043ULL,
0x0000000a1a107217ULL, 0x000fc60007800000ULL, 0x00005e000b0a7625ULL, 0x000fe200078e0043ULL,
0x0000002508127210ULL, 0x000fc60007f5e0ffULL, 0x0000000110417824ULL, 0x000fe200078e0a1aULL,
0x000000250a0a7210ULL, 0x000fe20007f9e0ffULL, 0x00005e0011107625ULL, 0x000fc600078e0043ULL,
0x000000412600720cULL, 0x000fe20003f66070ULL, 0x000000012b087824ULL, 0x000fe200078e0213ULL,
0x0000002510107210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0609ULL,
0x000000414200720cULL, 0x000fe20003f46070ULL, 0x00005e0008087625ULL, 0x000fc800078e0043ULL,
0x000000ffff0b7224ULL, 0x000fe200020e060bULL, 0x000000412700720cULL, 0x080fe20003f86070ULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x000000412800720cULL, 0x000fe40003fa6070ULL,
0x0000002508087210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e4000d101c46ULL, 0x000000ffff097224ULL, 0x000fe400030e0609ULL,
0x000000000a3c7faeULL, 0x0003e8000d901c46ULL, 0x00000000103d7faeULL, 0x0003e8000e101c46ULL,
0x00000000083e7faeULL, 0x0005e8000e901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106a800ff087f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0009ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106b400ff087984ULL, 0x000e640000000800ULL, 0x8000000008ff7812ULL, 0x002fe40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff087424ULL, 0x000fc800078e00ffULL, 0x0000000800097305ULL, 0x0002a4000021f000ULL,
0x3fa0000008087823ULL, 0x002fe200000100ffULL, 0x000000090000735dULL, 0x004fe40003800000ULL,
0x0106b400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007844869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000031ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff5a7819ULL, 0x000fe40000011602ULL, 0x0000541008087816ULL, 0x000fe20000000008ULL,
0x0000f6327f007947ULL, 0x000fea000b800000ULL, 0x00001f5a08657589ULL, 0x0002a400000e0000ULL,
0x0000f6827f007947ULL, 0x000fea000b800000ULL, 0x00001f3208647589ULL, 0x00072400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0008ULL,
0x000062b0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fe400078e0033ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fc400078e00ffULL,
0x0001048000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0008ULL, 0x00006320005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x002fc400078e0034ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0001041000007944ULL, 0x01cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003f08783bULL, 0x00ae680000004200ULL,
0x00000000405c783bULL, 0x000ee80000004200ULL, 0x000000001e58783bULL, 0x004ea20000004200ULL,
0x00000018ff107819ULL, 0x002fe20000011408ULL, 0x0000010008617824ULL, 0x040fe200078e00ffULL,
0x0000888008607816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x0000888009627816ULL, 0x000fe200000000ffULL, 0x0000001000727306ULL, 0x0003e20000200c00ULL,
0x00000018ff717819ULL, 0x000fc4000001140aULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000018ff707819ULL, 0x000fe4000001140bULL, 0x00000018ff617819ULL, 0x000fe20000011461ULL,
0x0000000800737306ULL, 0x000be20000200c00ULL, 0x00000018ff107819ULL, 0x002fe40000011409ULL,
0x00000018ff6e7819ULL, 0x008fe4000001145cULL, 0x00000018ff6d7819ULL, 0x004fc40000011458ULL,
0x00000018ff6f7819ULL, 0x000fe2000001145dULL, 0x0000001000747306ULL, 0x0003e20000200c00ULL,
0x000000ffff087224ULL, 0x020fe200078e0062ULL, 0x00000018ff667819ULL, 0x000fe2000001145eULL,
0x0000010009627824ULL, 0x040fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001145fULL,
0x0001000009097824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe40000011459ULL,
0x0000000800637306ULL, 0x0005e20000200c00ULL, 0x000000001f10783bULL, 0x002e620000004200ULL,
0x00000018ff097819ULL, 0x000fc40000011409ULL, 0x00000018ff627819ULL, 0x000fe40000011462ULL,
0x00000018ff6a7819ULL, 0x000fe4000001145aULL, 0x0000000900757306ULL, 0x0007e20000200c00ULL,
0x000088800a087816ULL, 0x004fe400000000ffULL, 0x00000018ff6b7819ULL, 0x000fca000001145bULL,
0x0000000800767306ULL, 0x0005e20000200c00ULL, 0x000001000a097824ULL, 0x048fe400078e00ffULL,
0x000100000a0a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff0a7819ULL, 0x000fe2000001140aULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000088800b087816ULL, 0x004fce00000000ffULL, 0x0000000900777306ULL, 0x0005f00000200c00ULL,
0x0000000800797306ULL, 0x0007e20000200c00ULL, 0x000001000b097824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x002fe20000011410ULL, 0x000100000b0b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fc40000011411ULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000000a00787306ULL, 0x0003e20000200c00ULL, 0x000088805c087816ULL, 0x008fe400000000ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x00000018ff427819ULL, 0x000fe40000011412ULL,
0x00000018ff437819ULL, 0x000fe20000011413ULL, 0x00000009007a7306ULL, 0x0005e20000200c00ULL,
0x00008880590a7816ULL, 0x002fce00000000ffULL, 0x00000008007c7306ULL, 0x0003e20000200c00ULL,
0x000001005c097824ULL, 0x044fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000000b007b7306ULL, 0x000fe20000200c00ULL,
0x000088805d087816ULL, 0x002fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fca000001145cULL,
0x00000009007d7306ULL, 0x0003f00000200c00ULL, 0x00000008007f7306ULL, 0x0005e20000200c00ULL,
0x000001005d097824ULL, 0x042fe400078e00ffULL, 0x000100005d5d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x000088805e087816ULL, 0x004fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fca000001145dULL,
0x0000000900807306ULL, 0x0005f00000200c00ULL, 0x0000000800827306ULL, 0x0007e20000200c00ULL,
0x000001005e097824ULL, 0x004fe200078e00ffULL, 0x0000541060607816ULL, 0x002fe20000000061ULL,
0x000100005e5e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000006200627306ULL, 0x000e620000200c00ULL, 0x000088805f087816ULL, 0x008fe400000000ffULL,
0x00000018ff5e7819ULL, 0x000fca000001145eULL, 0x0000000900837306ULL, 0x0005f00000200c00ULL,
0x0000000800857306ULL, 0x0007e20000200c00ULL, 0x000001005f097824ULL, 0x004fe200078e00ffULL,
0x0000541063617816ULL, 0x002fe20000000062ULL, 0x000100005f5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000005c007e7306ULL, 0x0003e20000200c00ULL,
0x0000888058087816ULL, 0x008fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fca000001145fULL,
0x0000000900867306ULL, 0x0005e20000200c00ULL, 0x00000100595c7824ULL, 0x042fe400078e00ffULL,
0x0001000059597824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe4000001145cULL,
0x0000000800887306ULL, 0x0003e20000200c00ULL, 0x0000010058097824ULL, 0x044fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0001000058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000005d00817306ULL, 0x0005e20000200c00ULL, 0x0000a80020087811ULL, 0x002fce00078e20ffULL,
0x0000000900897306ULL, 0x0003e20000200c00ULL, 0x00005410755d7816ULL, 0x004fce0000000074ULL,
0x00000058008a7306ULL, 0x0005e20000200c00ULL, 0x000000ffff097224ULL, 0x002fce00078e000aULL,
0x00000009008b7306ULL, 0x0003e20000200c00ULL, 0x000088805a587816ULL, 0x004fce00000000ffULL,
0x0000005c008c7306ULL, 0x0005e20000200c00ULL, 0x000000000808783bULL, 0x002e6e0000000200ULL,
0x00000058008e7306ULL, 0x0007e20000200c00ULL, 0x00005410735c7816ULL, 0x004fce0000000072ULL,
0x0000005e00847306ULL, 0x000fe20000200c00ULL, 0x000088805b587816ULL, 0x008fce00000000ffULL,
0x0000005f00877306ULL, 0x000ff00000200c00ULL, 0x00000059008d7306ULL, 0x0005f00000200c00ULL,
0x0000005800917306ULL, 0x0007e20000200c00ULL, 0x0000006508089232ULL, 0x082fe20000000000ULL,
0x000001005a597824ULL, 0x044fe200078e00ffULL, 0x000000650a0a9232ULL, 0x000fe20000000000ULL,
0x000100005a5a7824ULL, 0x000fe200078e00ffULL, 0x0000006409099232ULL, 0x010fc40000000000ULL,
0x000000640b0b9232ULL, 0x000fe20000000000ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000888010587816ULL, 0x048fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x000000600860723cULL, 0x040fe40000001804ULL,
0x0000007000707306ULL, 0x000fea0000200c00ULL, 0x0000a80021047811ULL, 0x000fe200078e20ffULL,
0x0000005c085c723cULL, 0x000fe20000001850ULL, 0x000000ffff057224ULL, 0x000fe200078e0058ULL,
0x00000059008f7306ULL, 0x0002a20000200c00ULL, 0x0000010010067824ULL, 0x040fe200078e00ffULL,
0x000000000450783bULL, 0x0007220000000200ULL, 0x0000888011587816ULL, 0x000fe200000000ffULL,
0x0001000010107824ULL, 0x000fc400078e00ffULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x0000000500947306ULL, 0x000be20000200c00ULL, 0x000001005b597824ULL, 0x042fe200078e00ffULL,
0x0000541076047816ULL, 0x008fe20000000077ULL, 0x000100005b5b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541079057816ULL, 0x020fc4000000007aULL,
0x00000018ff5b7819ULL, 0x000fe4000001145bULL, 0x000054108e8e7816ULL, 0x004fc6000000008fULL,
0x0000006f006f7306ULL, 0x000eb00000200c00ULL, 0x0000000600727306ULL, 0x0007e20000200c00ULL,
0x000054107e6e7816ULL, 0x002fce000000006eULL, 0x0000005900927306ULL, 0x0003620000200c00ULL,
0x000000040804723cULL, 0x048fe2000000180cULL, 0x00005410816f7816ULL, 0x004fe2000000006fULL,
0x0000006550509232ULL, 0x090fe40000000000ULL, 0x0000006552529232ULL, 0x000fe40000000000ULL,
0x0000006451519232ULL, 0x080fe20000000000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0058ULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x00000100110d7824ULL, 0x000fe200078e00ffULL,
0x0000541078587816ULL, 0x000fe20000000071ULL, 0x0000006e0848723cULL, 0x000fe20000001848ULL,
0x000054107b597816ULL, 0x002fe20000000070ULL, 0x0000006453539232ULL, 0x000fe20000000000ULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x00005410918f7816ULL, 0x020fc60000000092ULL,
0x00000018ff117819ULL, 0x000fc80000011411ULL, 0x0000005a00907306ULL, 0x000fe20000200c00ULL,
0x0000541084667816ULL, 0x004fe20000000066ULL, 0x0000008e5004723cULL, 0x000fec0000001804ULL,
0x0000005b00937306ULL, 0x0005e20000200c00ULL, 0x0000541087677816ULL, 0x002fce0000000067ULL,
0x0000000d00707306ULL, 0x0003e20000200c00ULL, 0x000000580858723cULL, 0x044fee0000001854ULL,
0x000054107c547816ULL, 0x000fe2000000007dULL, 0x00000100120d7824ULL, 0x002fe200078e00ffULL,
0x000054107f557816ULL, 0x000fe20000000080ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000000660864723cULL, 0x000fe40000001814ULL, 0x00000018ff0d7819ULL, 0x000fca000001140dULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000000540854723cULL, 0x000fe2000000184cULL,
0x0000010013147824ULL, 0x000fca00078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000000c00737306ULL, 0x0004e20000200c00ULL, 0x00005410824c7816ULL, 0x000fe40000000083ULL,
0x00005410854d7816ULL, 0x000fca0000000086ULL, 0x0000000d006f7306ULL, 0x0009e20000200c00ULL,
0x00008880120c7816ULL, 0x044fe200000000ffULL, 0x0000004c084c723cULL, 0x000fe20000001844ULL,
0x0001000012127824ULL, 0x000fca00078e00ffULL, 0x0000000c006e7306ULL, 0x0005620000200c00ULL,
0x000054108b0d7816ULL, 0x010fe4000000008cULL, 0x0000888013087816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000054108d097816ULL, 0x002fe4000000006cULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x00005410880c7816ULL, 0x004fe40000000089ULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x0000541094447816ULL, 0x000fe40000000072ULL, 0x0000541073457816ULL, 0x008fe20000000070ULL,
0x0000000c500c723cULL, 0x000fe20000001860ULL, 0x0000000800607306ULL, 0x0005e20000200c00ULL,
0x000054106e6e7816ULL, 0x020fe4000000006fULL, 0x00005410906a7816ULL, 0x002fca000000006aULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x000054108a087816ULL, 0x004fe2000000006dULL,
0x000000445044723cULL, 0x040fec0000001854ULL, 0x0000006800687306ULL, 0x000fe40000200c00ULL,
0x000000085008723cULL, 0x000fec000000185cULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410936b7816ULL, 0x002fce000000006bULL, 0x0000001000107306ULL, 0x000e700000200c00ULL,
0x0000001100117306ULL, 0x000eb00000200c00ULL, 0x00000014005c7306ULL, 0x0007220000200c00ULL,
0x0000541010687816ULL, 0x002fce0000000068ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541011697816ULL, 0x004fe20000000069ULL, 0x0000006a5014723cULL, 0x048fec0000001858ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00005410606f7816ULL, 0x010fe2000000005cULL,
0x000000685048723cULL, 0x040fec0000001848ULL, 0x0000001200127306ULL, 0x000e640000200c00ULL,
0x0000006e504c723cULL, 0x000fec000000184cULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541012427816ULL, 0x002fc40000000042ULL, 0x0000541013437816ULL, 0x004fce0000000043ULL,
0x000000425050723cULL, 0x000fe20000001864ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0106b800ff107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008018107811ULL, 0x002fe200078e40ffULL,
0x01069000ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000100300720cULL, 0x000fe20003f24070ULL,
0x000000ffff107224ULL, 0x000fd800078e0011ULL, 0x0000606000009947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007824810ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff117424ULL, 0x000fc800078e00ffULL,
0x0000001100127305ULL, 0x0002a4000021f000ULL, 0x3fa0000011117823ULL, 0x002fe200000100ffULL,
0x000000120000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fc40007824810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000a018107811ULL, 0x000fe200078e40ffULL, 0x00000100ff587424ULL, 0x000fe200078e00ffULL,
0x00000004ff577819ULL, 0x000fe40000011602ULL, 0x0000001003117217ULL, 0x000fe20007800000ULL,
0x000062001b427a24ULL, 0x000fc800078e0210ULL, 0x0000000111117824ULL, 0x000fe400078e0a10ULL,
0x0000000124107824ULL, 0x100fe400078e0242ULL, 0x0000000129137824ULL, 0x000fe200078e0242ULL,
0x0000002011127807ULL, 0x000fe20000000000ULL, 0x00005e0010107625ULL, 0x000fc600078e0058ULL,
0x000000121a437217ULL, 0x000fe20007800000ULL, 0x00005e0013127625ULL, 0x000fe200078e0058ULL,
0x0000002510547210ULL, 0x000fc60007f3e0ffULL, 0x0000000143567824ULL, 0x000fe200078e0a1aULL,
0x0000002512127210ULL, 0x000fe20007f7e0ffULL, 0x000000012a107824ULL, 0x100fe400078e0242ULL,
0x000000012b427824ULL, 0x000fe200078e0242ULL, 0x000000565700720cULL, 0x080fe20003f46070ULL,
0x000000ffff557224ULL, 0x000fe200008e0611ULL, 0x000000562600720cULL, 0x000fe20003f26070ULL,
0x00005e0010107625ULL, 0x000fe200078e0058ULL, 0x000000562800720cULL, 0x000fc60003f86070ULL,
0x00005e0042427625ULL, 0x000fe200078e0058ULL, 0x0000002510107210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e0613ULL, 0x000000562700720cULL, 0x000fe20003f66070ULL,
0x000000ffff117224ULL, 0x000fe200028e0611ULL, 0x0000002542427210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000542c7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff437224ULL, 0x000fe200030e0643ULL, 0x00000000122d7faeULL, 0x0003ea000c901c46ULL,
0x00000000102e7faeULL, 0x0005e8000d901c46ULL, 0x00000000422f7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106b000ff687f8cULL, 0x000e68000c80043fULL, 0x0106ac00ff127984ULL, 0x000ea20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x010648001a107f8cULL, 0x000fe2000c80043fULL, 0x8000000012ff7812ULL, 0x004fc60007844841ULL,
0x01064c001a137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007824811ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff127424ULL, 0x000fc800078e00ffULL,
0x0000001200137305ULL, 0x0004e4000021f000ULL, 0x3fa0000012127823ULL, 0x004fe200000100ffULL,
0x000000130000735dULL, 0x008fe40003800000ULL, 0x01064c001a137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fc40007824811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0101000030127984ULL, 0x000ea80000000800ULL, 0x0103000030137984ULL, 0x0007220000000800ULL,
0x0000001c1200720bULL, 0x004fe20003f3d000ULL, 0x0000e1127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800008e0100ULL, 0x0000ffff10437812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff717424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000020000780cULL, 0x000fe40003f65270ULL,
0x0000001c1200720bULL, 0x000fe20003f34000ULL, 0x0000e0f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fe400008e0100ULL, 0x000000121c117209ULL, 0x000fe40007810000ULL,
0x0000ffff10107812ULL, 0x000fe400078e3cffULL, 0x00000002ff587819ULL, 0x000fe20000011602ULL,
0x800000111c427221ULL, 0x000fe20000010000ULL, 0x010500113000b388ULL, 0x0005e20000000800ULL,
0x0000001043ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b42427820ULL, 0x000fc80000410000ULL,
0x0000004200597308ULL, 0x000ee40000000800ULL, 0x000000591d1d7220ULL, 0x008fe20000410000ULL,
0x0000e0a27f007947ULL, 0x000fea000b800000ULL, 0x00001f5859587589ULL, 0x0044e400000e0000ULL,
0x000000580c0c7220ULL, 0x08cfe40000410000ULL, 0x000000580d0d7220ULL, 0x080fe40000410000ULL,
0x0000005808087220ULL, 0x080fe40000410000ULL, 0x0000005809097220ULL, 0x080fe40000410000ULL,
0x0000005804047220ULL, 0x000fc40000410000ULL, 0x0000005805057220ULL, 0x080fe40000410000ULL,
0x0000005814147220ULL, 0x080fe40000410000ULL, 0x0000005815157220ULL, 0x080fe40000410000ULL,
0x0000005844447220ULL, 0x080fe40000410000ULL, 0x0000005845457220ULL, 0x080fe40000410000ULL,
0x0000005848487220ULL, 0x000fc40000410000ULL, 0x0000005849497220ULL, 0x080fe40000410000ULL,
0x000000584c4c7220ULL, 0x080fe40000410000ULL, 0x000000584d4d7220ULL, 0x080fe40000410000ULL,
0x0000005850507220ULL, 0x080fe40000410000ULL, 0x0000005851517220ULL, 0x000fe20000410000ULL,
0x0000dfe27f007947ULL, 0x000fea000b800000ULL, 0x00001f3259587589ULL, 0x0004e400000e0000ULL,
0x000000121c1c7209ULL, 0x000fe20007810000ULL, 0x000000580e0e7220ULL, 0x08cfe20000410000ULL,
0x00000001ff717807ULL, 0x000fe20000800000ULL, 0x000000580f0f7220ULL, 0x000fc40000410000ULL,
0x8000001c12121221ULL, 0x000fe40000010000ULL, 0x000000580a0a7220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b12121820ULL, 0x000fe40000410000ULL, 0x000000580b0b7220ULL, 0x080fe40000410000ULL,
0x0000001200311308ULL, 0x000ea20000000800ULL, 0x0000005806067220ULL, 0x080fe40000410000ULL,
0x0000005807077220ULL, 0x000fc40000410000ULL, 0x0000005816167220ULL, 0x080fe40000410000ULL,
0x0000005817177220ULL, 0x080fe40000410000ULL, 0x0000005846467220ULL, 0x080fe40000410000ULL,
0x0000005847477220ULL, 0x080fe40000410000ULL, 0x000000584a4a7220ULL, 0x080fe40000410000ULL,
0x000000584b4b7220ULL, 0x000fc40000410000ULL, 0x000000584e4e7220ULL, 0x080fe40000410000ULL,
0x000000584f4f7220ULL, 0x080fe40000410000ULL, 0x0000005852527220ULL, 0x080fe40000410000ULL,
0x0000005853537220ULL, 0x000fe40000410000ULL, 0x0000001331131220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x0000001d131d7221ULL, 0x010fe20000010000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x0106ac00ff107984ULL, 0x000ea40000000800ULL, 0x8000000010ff7812ULL, 0x004fc40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0004e4000021f000ULL,
0x3fa0000010107823ULL, 0x004fe200000100ffULL, 0x000000110000735dULL, 0x008fe40003800000ULL,
0x0106ac00ff117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007824841ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000031ff10723eULL, 0x000fe400000000ffULL,
0x00000002ff5a7819ULL, 0x000fc40000011602ULL, 0x0000541010107816ULL, 0x000fe20000000010ULL,
0x0000dd827f007947ULL, 0x000fea000b800000ULL, 0x00001f5a10657589ULL, 0x0004e400000e0000ULL,
0x0000ddd27f007947ULL, 0x000fea000b800000ULL, 0x00001f3210647589ULL, 0x0008a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x00007dd0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x004fe400078e0033ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000e96000007944ULL, 0x01afea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00007e40005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x004fe400078e0034ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000e8f000007944ULL, 0x01afea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003554783bULL, 0x000f680000004200ULL,
0x00000000365c783bULL, 0x000f280000004200ULL, 0x000000003758783bULL, 0x004ea80000004200ULL,
0x000000003810783bULL, 0x010f220000004200ULL, 0x00000018ff6f7819ULL, 0x020fe20000011454ULL,
0x0000010054737824ULL, 0x040fe200078e00ffULL, 0x0000888054727816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x0000888055757816ULL, 0x000fc400000000ffULL,
0x00000018ff707819ULL, 0x000fe20000011455ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff667819ULL, 0x000fe40000011456ULL,
0x00000018ff677819ULL, 0x000fe40000011457ULL, 0x00000018ff627819ULL, 0x000fe2000001145cULL,
0x0000005400747306ULL, 0x000be20000200c00ULL, 0x00000018ff737819ULL, 0x000fc40000011473ULL,
0x00000018ff6d7819ULL, 0x004fe40000011459ULL, 0x00000018ff6e7819ULL, 0x000fe40000011458ULL,
0x00000018ff6b7819ULL, 0x000fe2000001145aULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x000000ffff547224ULL, 0x020fe200078e0075ULL, 0x00000018ff6c7819ULL, 0x000fe2000001145bULL,
0x0000010055757824ULL, 0x040fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe2000001145dULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fc4000001145eULL,
0x0000005400767306ULL, 0x0005e20000200c00ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff617819ULL, 0x000fe4000001145fULL,
0x00000018ff437819ULL, 0x010fe20000011410ULL, 0x0000005500777306ULL, 0x0009e20000200c00ULL,
0x0000888056547816ULL, 0x004fe400000000ffULL, 0x00000018ff6a7819ULL, 0x000fc40000011411ULL,
0x00000018ff417819ULL, 0x000fe40000011412ULL, 0x00000018ff427819ULL, 0x000fe20000011413ULL,
0x0000005400787306ULL, 0x0005e20000200c00ULL, 0x0000010056557824ULL, 0x050fe400078e00ffULL,
0x0001000056567824ULL, 0x000fc600078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x0000888057547816ULL, 0x004fce00000000ffULL, 0x0000005500797306ULL, 0x0005f00000200c00ULL,
0x00000054007b7306ULL, 0x000be20000200c00ULL, 0x0000010057557824ULL, 0x044fe200078e00ffULL,
0x0000541072727816ULL, 0x010fe20000000073ULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x00000056007a7306ULL, 0x000fe20000200c00ULL, 0x000088805c547816ULL, 0x020fce00000000ffULL,
0x00000055007c7306ULL, 0x0005f00000200c00ULL, 0x00000054007e7306ULL, 0x0009e20000200c00ULL,
0x000001005c557824ULL, 0x044fe400078e00ffULL, 0x000100005c5c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000057007d7306ULL, 0x000fe20000200c00ULL,
0x000088805d547816ULL, 0x010fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fca000001145cULL,
0x00000055007f7306ULL, 0x0005300000200c00ULL, 0x0000005400817306ULL, 0x000be20000200c00ULL,
0x000001005d557824ULL, 0x044fe400078e00ffULL, 0x000100005d5d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005c00807306ULL, 0x0005e20000200c00ULL,
0x000088805e547816ULL, 0x020fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x000054107e7e7816ULL, 0x010fc6000000007fULL, 0x0000005500827306ULL, 0x0009620000200c00ULL,
0x00009910715c7816ULL, 0x004fc800000000ffULL, 0x000000ff5c00720cULL, 0x000fe40003f25270ULL,
0x0000b0003a5c7811ULL, 0x000fe200078e20ffULL, 0x0000005400847306ULL, 0x0005e20000200c00ULL,
0x000001005e557824ULL, 0x050fe400078e00ffULL, 0x000100005e5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x000088805f547816ULL, 0x004fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00005410817f7816ULL, 0x020fc60000000082ULL, 0x0000005500857306ULL, 0x0005f00000200c00ULL,
0x0000005400877306ULL, 0x000be20000200c00ULL, 0x000001005f557824ULL, 0x044fe200078e00ffULL,
0x0000541076737816ULL, 0x010fe20000000075ULL, 0x000100005f5f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x0000888058547816ULL, 0x020fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fca000001145fULL,
0x0000005500887306ULL, 0x0005f00000200c00ULL, 0x00000054008a7306ULL, 0x0009e20000200c00ULL,
0x0000010058557824ULL, 0x044fe400078e00ffULL, 0x0001000058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x0000005d00837306ULL, 0x0005e20000200c00ULL, 0x0000888059547816ULL, 0x010fce00000000ffULL,
0x00000055008b7306ULL, 0x0009e20000200c00ULL, 0x00000100105d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000054008d7306ULL, 0x0005e20000200c00ULL,
0x0000010059557824ULL, 0x050fe400078e00ffULL, 0x0001000059597824ULL, 0x000fc600078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x00000058008c7306ULL, 0x0009e20000200c00ULL, 0x0000b00039547811ULL, 0x004fce00078e20ffULL,
0x00000055008e7306ULL, 0x0005e20000200c00ULL, 0x000088805a587816ULL, 0x010fce00000000ffULL,
0x00000059008f7306ULL, 0x0009e20000200c00ULL, 0x000000005454783bULL, 0x004eae0000000200ULL,
0x0000005800907306ULL, 0x000be20000200c00ULL, 0x000001005a597824ULL, 0x050fe400078e00ffULL,
0x000100005a5a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000006200627306ULL, 0x000f220000200c00ULL,
0x000088805b587816ULL, 0x020fce00000000ffULL, 0x0000005900917306ULL, 0x000bf00000200c00ULL,
0x0000005800927306ULL, 0x0007e20000200c00ULL, 0x000001005b597824ULL, 0x060fe200078e00ffULL,
0x0000541080627816ULL, 0x010fe20000000062ULL, 0x000100005b5b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x0000006554549232ULL, 0x08cfe20000000000ULL,
0x0000888010587816ULL, 0x040fe200000000ffULL, 0x0000006556569232ULL, 0x000fe20000000000ULL,
0x0000005900937306ULL, 0x0005e20000200c00ULL, 0x0000006455559232ULL, 0x080fe20000000000ULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000006457579232ULL, 0x000fe20000000000ULL,
0x0001000010107824ULL, 0x000fc800078e00ffULL, 0x0000005a00717306ULL, 0x000fe20000200c00ULL,
0x0000541077597816ULL, 0x004fe20000000070ULL, 0x00000072540c723cULL, 0x000fe2000000180cULL,
0x0000888011707816ULL, 0x000fe400000000ffULL, 0x00000018ff107819ULL, 0x000fc60000011410ULL,
0x0000005800727306ULL, 0x0005e40000200c00ULL, 0x0000007e5444723cULL, 0x000fec0000001844ULL,
0x0000005b00947306ULL, 0x0007e20000200c00ULL, 0x0000541074587816ULL, 0x004fce000000006fULL,
0x0000005d006f7306ULL, 0x0005e20000200c00ULL, 0x000000585458723cULL, 0x008fe20000001808ULL,
0x000000005c08783bULL, 0x00072c0000000200ULL, 0x0000006300637306ULL, 0x000f620000200c00ULL,
0x000054107b5d7816ULL, 0x004fe4000000007cULL, 0x00005410785c7816ULL, 0x008fca0000000079ULL,
0x0000005e00867306ULL, 0x000ff00000200c00ULL, 0x0000005f00897306ULL, 0x0005e20000200c00ULL,
0x0000541083637816ULL, 0x020fce0000000063ULL, 0x0000006600667306ULL, 0x000ee20000200c00ULL,
0x0000005c545c723cULL, 0x044fee0000001804ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000010011057824ULL, 0x040fe200078e00ffULL, 0x000000625448723cULL, 0x000fe20000001848ULL,
0x000000ffff047224ULL, 0x000fe200078e0070ULL, 0x0000006508089232ULL, 0x090fe20000000000ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x000000650a0a9232ULL, 0x000fe20000000000ULL, 0x0000006000607306ULL, 0x000f220000200c00ULL,
0x000054107a667816ULL, 0x008fe20000000066ULL, 0x0000006409099232ULL, 0x080fe20000000000ULL,
0x0000541084627816ULL, 0x000fe20000000085ULL, 0x000000640b0b9232ULL, 0x000fe20000000000ULL,
0x0000541087637816ULL, 0x000fc40000000088ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x000054107d677816ULL, 0x004fce0000000067ULL,
0x0000000500737306ULL, 0x0005e20000200c00ULL, 0x000000665414723cULL, 0x000fee0000001814ULL,
0x0000000400707306ULL, 0x000a620000200c00ULL, 0x0000010012057824ULL, 0x004fe200078e00ffULL,
0x0000541086667816ULL, 0x010fc40000000060ULL, 0x0000541089677816ULL, 0x008fe40000000061ULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x000000625460723cULL, 0x000fe2000000184cULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000888012047816ULL, 0x060fe200000000ffULL,
0x0001000012127824ULL, 0x000fc800078e00ffULL, 0x00008880134c7816ULL, 0x000fe200000000ffULL,
0x000000665464723cULL, 0x000fe20000001850ULL, 0x0000006d006d7306ULL, 0x000ee20000200c00ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00005410704d7816ULL, 0x002fca0000000073ULL,
0x0000000400747306ULL, 0x0003e20000200c00ULL, 0x000054108c507816ULL, 0x004fce000000006eULL,
0x0000000500757306ULL, 0x0005e20000200c00ULL, 0x000054108a047816ULL, 0x002fe4000000008bULL,
0x000054108f517816ULL, 0x008fca000000006dULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000054108d057816ULL, 0x004fe2000000008eULL, 0x000000500850723cULL, 0x040fec0000001858ULL,
0x0000006c006c7306ULL, 0x000ea40000200c00ULL, 0x000000040804723cULL, 0x000fec000000180cULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x00000100130d7824ULL, 0x000fe200078e00ffULL,
0x0000541071547816ULL, 0x002fe2000000006bULL, 0x0001000013137824ULL, 0x000fc400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e004cULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541094557816ULL, 0x004fe4000000006cULL, 0x00005410724c7816ULL, 0x000fca000000006fULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x000000540854723cULL, 0x040fee0000001814ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000004c084c723cULL, 0x000fee0000001844ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x0000541074447816ULL, 0x000fce0000000075ULL,
0x0000001100117306ULL, 0x000eb00000200c00ULL, 0x0000000c00767306ULL, 0x0007e20000200c00ULL,
0x0000541010107816ULL, 0x002fce0000000043ULL, 0x0000000d00587306ULL, 0x0003220000200c00ULL,
0x00005410900c7816ULL, 0x008fe40000000091ULL, 0x0000541011117816ULL, 0x004fca000000006aULL,
0x0000001200127306ULL, 0x000ea20000200c00ULL, 0x00005410920d7816ULL, 0x002fe20000000093ULL,
0x000000100848723cULL, 0x040fec0000001848ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x0000541076457816ULL, 0x010fe20000000058ULL, 0x0000000c080c723cULL, 0x000fe2000000185cULL,
0x0000541012147816ULL, 0x004fce0000000041ULL, 0x000000440844723cULL, 0x000fe20000001860ULL,
0x0000541013157816ULL, 0x002fce0000000042ULL, 0x000000140814723cULL, 0x000fe20000001864ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff087f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff0a7984ULL, 0x000e640000000800ULL, 0x800000000aff7812ULL, 0x002fe40007844809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106bc00ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc40007844809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x3fa000000a0a7823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007844809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000c018087811ULL, 0x000fe200078e40ffULL, 0x00000100ff437424ULL, 0x000fe200078e00ffULL,
0x00000004ff427819ULL, 0x000fc40000011602ULL, 0x0000000803097217ULL, 0x000fe20007800000ULL,
0x000062001b137a24ULL, 0x000fc800078e0208ULL, 0x0000000109097824ULL, 0x000fe400078e0a08ULL,
0x0000000124087824ULL, 0x100fe400078e0213ULL, 0x00000001290b7824ULL, 0x100fe200078e0213ULL,
0x00000020090a7807ULL, 0x000fe20000000000ULL, 0x000000012a117824ULL, 0x000fe400078e0213ULL,
0x00005e0008087625ULL, 0x000fe200078e0043ULL, 0x0000000a1a107217ULL, 0x000fc60007800000ULL,
0x00005e000b0a7625ULL, 0x000fe200078e0043ULL, 0x0000002508127210ULL, 0x000fc60007f5e0ffULL,
0x0000000110417824ULL, 0x000fe200078e0a1aULL, 0x000000250a0a7210ULL, 0x000fe20007f9e0ffULL,
0x00005e0011107625ULL, 0x000fc600078e0043ULL, 0x000000412600720cULL, 0x000fe20003f66070ULL,
0x000000012b087824ULL, 0x000fe200078e0213ULL, 0x0000002510107210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0609ULL, 0x000000414200720cULL, 0x000fe20003f46070ULL,
0x00005e0008087625ULL, 0x000fc800078e0043ULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x000000412700720cULL, 0x080fe20003f86070ULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000000412800720cULL, 0x000fe40003fa6070ULL, 0x0000002508087210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0003e4000d101c46ULL,
0x000000ffff097224ULL, 0x000fe400030e0609ULL, 0x000000000a3c7faeULL, 0x0003e8000d901c46ULL,
0x00000000103d7faeULL, 0x0003e8000e101c46ULL, 0x00000000083e7faeULL, 0x0005e8000e901c46ULL,
0x0000000000007918ULL, 0x004fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x002fec0000008000ULL,
0x0106a800ff087f8cULL, 0x000fe8000c80043fULL, 0x0106b400ff0a7984ULL, 0x000e640000000800ULL,
0x800000000aff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x000000ffff417224ULL, 0x000fe200078e0009ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x0106b400ff087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x0106b400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007844869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000031ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff5a7819ULL, 0x000fe40000011602ULL,
0x0000541008087816ULL, 0x000fe20000000008ULL, 0x0000c9427f007947ULL, 0x000fea000b800000ULL,
0x00001f5a08657589ULL, 0x0002a400000e0000ULL, 0x0000c9927f007947ULL, 0x000fea000b800000ULL,
0x00001f3208647589ULL, 0x00072400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0008ULL, 0x00009300005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x002fe400078e0033ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fc400078e00ffULL, 0x0000d43000007944ULL, 0x01cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0008ULL,
0x00009370005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fc400078e0034ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000d3c000007944ULL, 0x01cfea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000003f08783bULL, 0x00ae680000004200ULL, 0x00000000405c783bULL, 0x000ee80000004200ULL,
0x000000001e58783bULL, 0x004ea20000004200ULL, 0x00000018ff107819ULL, 0x002fe20000011408ULL,
0x0000010008617824ULL, 0x040fe200078e00ffULL, 0x0000888008607816ULL, 0x040fe200000000ffULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x0000888009627816ULL, 0x000fe200000000ffULL,
0x0000001000727306ULL, 0x0003e20000200c00ULL, 0x00000018ff717819ULL, 0x000fc4000001140aULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff707819ULL, 0x000fe4000001140bULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000000800737306ULL, 0x000be20000200c00ULL,
0x00000018ff107819ULL, 0x002fe40000011409ULL, 0x00000018ff6e7819ULL, 0x008fe4000001145cULL,
0x00000018ff6d7819ULL, 0x004fc40000011458ULL, 0x00000018ff6f7819ULL, 0x000fe2000001145dULL,
0x0000001000747306ULL, 0x0003e20000200c00ULL, 0x000000ffff087224ULL, 0x020fe200078e0062ULL,
0x00000018ff667819ULL, 0x000fe2000001145eULL, 0x0000010009627824ULL, 0x040fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001145fULL, 0x0001000009097824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe40000011459ULL, 0x0000000800637306ULL, 0x0005e20000200c00ULL,
0x000000001f10783bULL, 0x002e620000004200ULL, 0x00000018ff097819ULL, 0x000fc40000011409ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff6a7819ULL, 0x000fe4000001145aULL,
0x0000000900757306ULL, 0x0007e20000200c00ULL, 0x000088800a087816ULL, 0x004fe400000000ffULL,
0x00000018ff6b7819ULL, 0x000fca000001145bULL, 0x0000000800767306ULL, 0x0005e20000200c00ULL,
0x000001000a097824ULL, 0x048fe400078e00ffULL, 0x000100000a0a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x00000018ff0a7819ULL, 0x000fe2000001140aULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000088800b087816ULL, 0x004fce00000000ffULL,
0x0000000900777306ULL, 0x0005f00000200c00ULL, 0x0000000800797306ULL, 0x0007e20000200c00ULL,
0x000001000b097824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x002fe20000011410ULL,
0x000100000b0b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fc40000011411ULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000000a00787306ULL, 0x0003e20000200c00ULL,
0x000088805c087816ULL, 0x008fe400000000ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000018ff427819ULL, 0x000fe40000011412ULL, 0x00000018ff437819ULL, 0x000fe20000011413ULL,
0x00000009007a7306ULL, 0x0005e20000200c00ULL, 0x00008880590a7816ULL, 0x002fce00000000ffULL,
0x00000008007c7306ULL, 0x0003e20000200c00ULL, 0x000001005c097824ULL, 0x044fe400078e00ffULL,
0x000100005c5c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000000b007b7306ULL, 0x000fe20000200c00ULL, 0x000088805d087816ULL, 0x002fe400000000ffULL,
0x00000018ff5c7819ULL, 0x000fca000001145cULL, 0x00000009007d7306ULL, 0x0003f00000200c00ULL,
0x00000008007f7306ULL, 0x0005e20000200c00ULL, 0x000001005d097824ULL, 0x042fe400078e00ffULL,
0x000100005d5d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x000088805e087816ULL, 0x004fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fca000001145dULL, 0x0000000900807306ULL, 0x0005f00000200c00ULL,
0x0000000800827306ULL, 0x0007e20000200c00ULL, 0x000001005e097824ULL, 0x004fe200078e00ffULL,
0x0000541060607816ULL, 0x002fe20000000061ULL, 0x000100005e5e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff097819ULL, 0x000fe40000011409ULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x000088805f087816ULL, 0x008fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fca000001145eULL,
0x0000000900837306ULL, 0x0005f00000200c00ULL, 0x0000000800857306ULL, 0x0007e20000200c00ULL,
0x000001005f097824ULL, 0x004fe200078e00ffULL, 0x0000541063617816ULL, 0x002fe20000000062ULL,
0x000100005f5f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x0000005c007e7306ULL, 0x0003e20000200c00ULL, 0x0000888058087816ULL, 0x008fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fca000001145fULL, 0x0000000900867306ULL, 0x0005e20000200c00ULL,
0x00000100595c7824ULL, 0x042fe400078e00ffULL, 0x0001000059597824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000000800887306ULL, 0x0003e20000200c00ULL,
0x0000010058097824ULL, 0x044fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0001000058587824ULL, 0x000fc600078e00ffULL, 0x00000018ff097819ULL, 0x000fe40000011409ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0000005d00817306ULL, 0x0005e20000200c00ULL,
0x0000b00020087811ULL, 0x002fce00078e20ffULL, 0x0000000900897306ULL, 0x0003e20000200c00ULL,
0x00005410755d7816ULL, 0x004fce0000000074ULL, 0x00000058008a7306ULL, 0x0005e20000200c00ULL,
0x000000ffff097224ULL, 0x002fce00078e000aULL, 0x00000009008b7306ULL, 0x0003e20000200c00ULL,
0x000088805a587816ULL, 0x004fce00000000ffULL, 0x0000005c008c7306ULL, 0x0005e20000200c00ULL,
0x000000000808783bULL, 0x002e6e0000000200ULL, 0x00000058008e7306ULL, 0x0007e20000200c00ULL,
0x00005410735c7816ULL, 0x004fce0000000072ULL, 0x0000005e00847306ULL, 0x000fe20000200c00ULL,
0x000088805b587816ULL, 0x008fce00000000ffULL, 0x0000005f00877306ULL, 0x000ff00000200c00ULL,
0x00000059008d7306ULL, 0x0005f00000200c00ULL, 0x0000005800917306ULL, 0x0007e20000200c00ULL,
0x0000006508089232ULL, 0x082fe20000000000ULL, 0x000001005a597824ULL, 0x044fe200078e00ffULL,
0x000000650a0a9232ULL, 0x000fe20000000000ULL, 0x000100005a5a7824ULL, 0x000fe200078e00ffULL,
0x0000006409099232ULL, 0x010fc40000000000ULL, 0x000000640b0b9232ULL, 0x000fe20000000000ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000888010587816ULL, 0x048fe400000000ffULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x000000600860723cULL, 0x040fe40000001804ULL, 0x0000007000707306ULL, 0x000fea0000200c00ULL,
0x0000b00021047811ULL, 0x000fe200078e20ffULL, 0x0000005c085c723cULL, 0x000fe20000001850ULL,
0x000000ffff057224ULL, 0x000fe200078e0058ULL, 0x00000059008f7306ULL, 0x0002a20000200c00ULL,
0x0000010010067824ULL, 0x040fe200078e00ffULL, 0x000000000450783bULL, 0x0007220000000200ULL,
0x0000888011587816ULL, 0x000fe200000000ffULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x00000018ff067819ULL, 0x000fe40000011406ULL, 0x0000000500947306ULL, 0x000be20000200c00ULL,
0x000001005b597824ULL, 0x042fe200078e00ffULL, 0x0000541076047816ULL, 0x008fe20000000077ULL,
0x000100005b5b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541079057816ULL, 0x020fc4000000007aULL, 0x00000018ff5b7819ULL, 0x000fe4000001145bULL,
0x000054108e8e7816ULL, 0x004fc6000000008fULL, 0x0000006f006f7306ULL, 0x000eb00000200c00ULL,
0x0000000600727306ULL, 0x0007e20000200c00ULL, 0x000054107e6e7816ULL, 0x002fce000000006eULL,
0x0000005900927306ULL, 0x0003620000200c00ULL, 0x000000040804723cULL, 0x048fe2000000180cULL,
0x00005410816f7816ULL, 0x004fe2000000006fULL, 0x0000006550509232ULL, 0x090fe40000000000ULL,
0x0000006552529232ULL, 0x000fe40000000000ULL, 0x0000006451519232ULL, 0x080fe20000000000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0058ULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x00000100110d7824ULL, 0x000fe200078e00ffULL, 0x0000541078587816ULL, 0x000fe20000000071ULL,
0x0000006e0848723cULL, 0x000fe20000001848ULL, 0x000054107b597816ULL, 0x002fe20000000070ULL,
0x0000006453539232ULL, 0x000fe20000000000ULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x00005410918f7816ULL, 0x020fc60000000092ULL, 0x00000018ff117819ULL, 0x000fc80000011411ULL,
0x0000005a00907306ULL, 0x000fe20000200c00ULL, 0x0000541084667816ULL, 0x004fe20000000066ULL,
0x0000008e5004723cULL, 0x000fec0000001804ULL, 0x0000005b00937306ULL, 0x0005e20000200c00ULL,
0x0000541087677816ULL, 0x002fce0000000067ULL, 0x0000000d00707306ULL, 0x0003e20000200c00ULL,
0x000000580858723cULL, 0x044fee0000001854ULL, 0x000054107c547816ULL, 0x000fe2000000007dULL,
0x00000100120d7824ULL, 0x002fe200078e00ffULL, 0x000054107f557816ULL, 0x000fe20000000080ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000660864723cULL, 0x000fe40000001814ULL,
0x00000018ff0d7819ULL, 0x000fca000001140dULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x000000540854723cULL, 0x000fe2000000184cULL, 0x0000010013147824ULL, 0x000fca00078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000000c00737306ULL, 0x0004e20000200c00ULL,
0x00005410824c7816ULL, 0x000fe40000000083ULL, 0x00005410854d7816ULL, 0x000fca0000000086ULL,
0x0000000d006f7306ULL, 0x0009e20000200c00ULL, 0x00008880120c7816ULL, 0x044fe200000000ffULL,
0x0000004c084c723cULL, 0x000fe20000001844ULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x0000000c006e7306ULL, 0x0005620000200c00ULL, 0x000054108b0d7816ULL, 0x010fe4000000008cULL,
0x0000888013087816ULL, 0x040fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000054108d097816ULL, 0x002fe4000000006cULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x00005410880c7816ULL, 0x004fe40000000089ULL,
0x00000018ff137819ULL, 0x000fc40000011413ULL, 0x0000541094447816ULL, 0x000fe40000000072ULL,
0x0000541073457816ULL, 0x008fe20000000070ULL, 0x0000000c500c723cULL, 0x000fe20000001860ULL,
0x0000000800607306ULL, 0x0005e20000200c00ULL, 0x000054106e6e7816ULL, 0x020fe4000000006fULL,
0x00005410906a7816ULL, 0x002fca000000006aULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000054108a087816ULL, 0x004fe2000000006dULL, 0x000000445044723cULL, 0x040fec0000001854ULL,
0x0000006800687306ULL, 0x000fe40000200c00ULL, 0x000000085008723cULL, 0x000fec000000185cULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00005410936b7816ULL, 0x002fce000000006bULL,
0x0000001000107306ULL, 0x000e700000200c00ULL, 0x0000001100117306ULL, 0x000eb00000200c00ULL,
0x00000014005c7306ULL, 0x0007220000200c00ULL, 0x0000541010687816ULL, 0x002fce0000000068ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541011697816ULL, 0x004fe20000000069ULL,
0x0000006a5014723cULL, 0x048fec0000001858ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00005410606f7816ULL, 0x010fe2000000005cULL, 0x000000685048723cULL, 0x040fec0000001848ULL,
0x0000001200127306ULL, 0x000e640000200c00ULL, 0x0000006e504c723cULL, 0x000fec000000184cULL,
0x0000001300137306ULL, 0x000ea20000200c00ULL, 0x0000541012427816ULL, 0x002fc40000000042ULL,
0x0000541013437816ULL, 0x004fce0000000043ULL, 0x000000425050723cULL, 0x000fe20000001864ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c018107811ULL, 0x002fe200078e40ffULL, 0x01069800ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000100300720cULL, 0x000fe20003f24070ULL, 0x000000ffff107224ULL, 0x000fd800078e0011ULL,
0x0000301000009947ULL, 0x000fea0003800000ULL, 0x0106bc00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000e000007945ULL, 0x000fe20003800000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106bc00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007824810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff117424ULL, 0x000fc800078e00ffULL, 0x0000001100127305ULL, 0x0002a4000021f000ULL,
0x3fa0000011117823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x0106bc00ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007824810ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000e018107811ULL, 0x000fe200078e40ffULL,
0x00000100ff587424ULL, 0x000fe200078e00ffULL, 0x00000004ff577819ULL, 0x000fe40000011602ULL,
0x0000001003117217ULL, 0x000fe20007800000ULL, 0x000062001b127a24ULL, 0x000fc800078e0210ULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x0000000124107824ULL, 0x100fe400078e0212ULL,
0x0000000129427824ULL, 0x000fe200078e0212ULL, 0x0000002011137807ULL, 0x000fe20000000000ULL,
0x00005e0010107625ULL, 0x000fc600078e0058ULL, 0x000000131a137217ULL, 0x000fe20007800000ULL,
0x000000012b437824ULL, 0x000fe200078e0212ULL, 0x0000002510547210ULL, 0x000fc60007f1e0ffULL,
0x0000000113567824ULL, 0x000fe400078e0a1aULL, 0x000000012a137824ULL, 0x000fe400078e0212ULL,
0x000000ffff557224ULL, 0x000fe200000e0611ULL, 0x000000565700720cULL, 0x000fe20003f06070ULL,
0x00005e0042107625ULL, 0x000fe200078e0058ULL, 0x000000562600720cULL, 0x080fe40003f26070ULL,
0x000000562700720cULL, 0x000fe20003f46070ULL, 0x00005e0013127625ULL, 0x000fe200078e0058ULL,
0x000000562800720cULL, 0x000fc40003f66070ULL, 0x0000002510107210ULL, 0x080fe20007f9e0ffULL,
0x00005e0043427625ULL, 0x000fe200078e0058ULL, 0x0000002512127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0611ULL, 0x0000002542427210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000542c7faeULL, 0x0003e6000c101c46ULL, 0x000000ffff437224ULL, 0x000fe200030e0643ULL,
0x00000000102d7faeULL, 0x0005e8000c901c46ULL, 0x00000000122e7faeULL, 0x0003e8000d101c46ULL,
0x00000000422f7faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106b000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0106b000ff607f8cULL, 0x000ea8000c80043fULL,
0x0106ac00ff127984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x010668001a107f8cULL, 0x000fe2000c80043fULL,
0x8000000012ff7812ULL, 0x002fc60007804841ULL, 0x01066c001a137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007824811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff127424ULL, 0x000fc800078e00ffULL, 0x0000001200137305ULL, 0x0002e4000021f000ULL,
0x3fa0000012127823ULL, 0x002fe200000100ffULL, 0x000000130000735dULL, 0x008fe40003800000ULL,
0x01066c001a137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0101800030127984ULL, 0x000e680000000800ULL,
0x0103800030137984ULL, 0x0007220000000800ULL, 0x0000001c1200720bULL, 0x002fe20003f3d000ULL,
0x0000b4227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800008e0100ULL,
0x0000ffff102c7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff5e7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000030000780cULL, 0x000fe40003f45270ULL, 0x0000001c1200720bULL, 0x000fe20003f34000ULL,
0x0000b4027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fe400008e0100ULL,
0x000000121c2d7209ULL, 0x000fe40007810000ULL, 0x0000ffff10107812ULL, 0x000fe400078e3cffULL,
0x00000002ff587819ULL, 0x000fe20000011602ULL, 0x8000002d1c117221ULL, 0x000fe20000010000ULL,
0x0105802d3000a388ULL, 0x0003e20000000800ULL, 0x000000102cff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b11117820ULL, 0x000fcc0000410000ULL, 0x0000001100117308ULL, 0x000ee40000000800ULL,
0x000000111d1d7220ULL, 0x008fe20000410000ULL, 0x0000b3b27f007947ULL, 0x000fea000b800000ULL,
0x00001f5811587589ULL, 0x0022e400000e0000ULL, 0x000000580c0c7220ULL, 0x08cfe40000410000ULL,
0x000000580d0d7220ULL, 0x080fe40000410000ULL, 0x0000005808087220ULL, 0x080fe40000410000ULL,
0x0000005809097220ULL, 0x080fe40000410000ULL, 0x0000005804047220ULL, 0x000fc40000410000ULL,
0x0000005805057220ULL, 0x080fe40000410000ULL, 0x0000005814147220ULL, 0x080fe40000410000ULL,
0x0000005815157220ULL, 0x080fe40000410000ULL, 0x0000005844447220ULL, 0x080fe40000410000ULL,
0x0000005845457220ULL, 0x080fe40000410000ULL, 0x0000005848487220ULL, 0x000fc40000410000ULL,
0x0000005849497220ULL, 0x080fe40000410000ULL, 0x000000584c4c7220ULL, 0x080fe40000410000ULL,
0x000000584d4d7220ULL, 0x080fe40000410000ULL, 0x0000005850507220ULL, 0x080fe40000410000ULL,
0x0000005851517220ULL, 0x000fe20000410000ULL, 0x0000b3027f007947ULL, 0x000fea000b800000ULL,
0x00001f3211587589ULL, 0x0004e400000e0000ULL, 0x8000002d12121221ULL, 0x000fe20000010000ULL,
0x00000001ff5e7807ULL, 0x000fe20000800000ULL, 0x000000580e0e7220ULL, 0x00cfc40000410000ULL,
0x3fb8aa3b12121820ULL, 0x000fe40000410000ULL, 0x000000580f0f7220ULL, 0x080fe40000410000ULL,
0x0000001200311308ULL, 0x000ea20000000800ULL, 0x000000580a0a7220ULL, 0x080fe40000410000ULL,
0x000000580b0b7220ULL, 0x080fe40000410000ULL, 0x0000005806067220ULL, 0x080fe40000410000ULL,
0x0000005807077220ULL, 0x000fc40000410000ULL, 0x0000005816167220ULL, 0x080fe40000410000ULL,
0x0000005817177220ULL, 0x080fe40000410000ULL, 0x0000005846467220ULL, 0x080fe40000410000ULL,
0x0000005847477220ULL, 0x080fe40000410000ULL, 0x000000584a4a7220ULL, 0x080fe40000410000ULL,
0x000000584b4b7220ULL, 0x000fc40000410000ULL, 0x000000584e4e7220ULL, 0x080fe40000410000ULL,
0x000000584f4f7220ULL, 0x080fe40000410000ULL, 0x0000005852527220ULL, 0x080fe40000410000ULL,
0x0000005853537220ULL, 0x000fe40000410000ULL, 0x000000ffff1c7224ULL, 0x000fe400078e002dULL,
0x0000001331131220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0x0000001d131d7221ULL, 0x010fe20000010000ULL,
0x000000c000000947ULL, 0x000fea0003800000ULL, 0x0106ac00ff107984ULL, 0x000ee40000000800ULL,
0x8000000010ff7812ULL, 0x008fc40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0022e4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x008fe40003800000ULL, 0x0106ac00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000031ff10723eULL, 0x000fe400000000ffULL, 0x00000002ff5a7819ULL, 0x000fc40000011602ULL,
0x0000541010107816ULL, 0x000fe20000000010ULL, 0x0000b0b27f007947ULL, 0x000fea000b800000ULL,
0x00001f5a10627589ULL, 0x00072400000e0000ULL, 0x0000b1027f007947ULL, 0x000fea000b800000ULL,
0x00001f3210417589ULL, 0x0002e400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x0000ae20005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x008fe400078e0033ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000b91000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x0000ae90005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x008fe400078e0034ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000b8a000007944ULL, 0x016fea0003c00000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000352c783bULL, 0x000f620000004200ULL, 0x0000b8003a3a7811ULL, 0x000fc600078e20ffULL,
0x000000003654783bULL, 0x000e680000004200ULL, 0x000000003758783bULL, 0x00cea20000004200ULL,
0x00000018ff107819ULL, 0x022fe2000001142cULL, 0x000001002d6b7824ULL, 0x040fe200078e00ffULL,
0x000088802d697816ULL, 0x000fe200000000ffULL, 0x000001002c687824ULL, 0x040fe200078e00ffULL,
0x00000010006a7306ULL, 0x0003e20000200c00ULL, 0x000088802c5f7816ULL, 0x040fe200000000ffULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fc4000001146bULL,
0x00000018ff5c7819ULL, 0x000fe4000001142eULL, 0x00000018ff2c7819ULL, 0x000fe2000001142cULL,
0x0000006b006c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff107819ULL, 0x002fe2000001142dULL,
0x000100002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001142fULL,
0x00000018ff647819ULL, 0x000fe40000011456ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000002c006b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff677819ULL, 0x000fc40000011455ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff667819ULL, 0x000fe40000011454ULL,
0x00000018ff657819ULL, 0x000fe20000011457ULL, 0x0000002d006e7306ULL, 0x0007e20000200c00ULL,
0x000088802e2c7816ULL, 0x002fe400000000ffULL, 0x00000018ff437819ULL, 0x004fe40000011458ULL,
0x00000018ff637819ULL, 0x000fc40000011459ULL, 0x00000018ff427819ULL, 0x000fe2000001145bULL,
0x0000002c006f7306ULL, 0x0003e20000200c00ULL, 0x000001002e2d7824ULL, 0x048fe400078e00ffULL,
0x000100002e2e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2e7819ULL, 0x000fe2000001142eULL, 0x00000010006d7306ULL, 0x0005e20000200c00ULL,
0x000088802f2c7816ULL, 0x002fce00000000ffULL, 0x0000002d00707306ULL, 0x0003e20000200c00ULL,
0x000000003810783bULL, 0x0044ee0000004200ULL, 0x0000002c00727306ULL, 0x000be20000200c00ULL,
0x000001002f2d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff387819ULL, 0x004fe2000001145aULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e00717306ULL, 0x000fe20000200c00ULL,
0x00008880542c7816ULL, 0x020fce00000000ffULL, 0x0000002d00737306ULL, 0x0003f00000200c00ULL,
0x0000002c00757306ULL, 0x0005e20000200c00ULL, 0x00000100542d7824ULL, 0x042fe400078e00ffULL,
0x0001000054547824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002f00747306ULL, 0x000fe20000200c00ULL, 0x00008880552c7816ULL, 0x004fe400000000ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff367819ULL, 0x008fe40000011410ULL,
0x00000018ff377819ULL, 0x000fe20000011411ULL, 0x0000002d00767306ULL, 0x0002a20000200c00ULL,
0x00000018ff307819ULL, 0x000fc40000011412ULL, 0x00000018ff357819ULL, 0x000fca0000011413ULL,
0x0000002c00777306ULL, 0x0007e20000200c00ULL, 0x00000100552d7824ULL, 0x042fe400078e00ffULL,
0x0001000055557824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00008880562c7816ULL, 0x008fe400000000ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000541075767816ULL, 0x004fc60000000076ULL,
0x0000002d00797306ULL, 0x0002b00000200c00ULL, 0x0000002c007b7306ULL, 0x0007e20000200c00ULL,
0x00000100562d7824ULL, 0x042fe400078e00ffULL, 0x0001000056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x00008880572c7816ULL, 0x008fe400000000ffULL,
0x0000541077777816ULL, 0x004fca0000000079ULL, 0x0000002d007c7306ULL, 0x0004f00000200c00ULL,
0x0000002c007d7306ULL, 0x000be20000200c00ULL, 0x00000100572d7824ULL, 0x004fe200078e00ffULL,
0x000054105f687816ULL, 0x002fe20000000068ULL, 0x0001000057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000056007e7306ULL, 0x0003e20000200c00ULL,
0x00008880582c7816ULL, 0x020fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x000054107b7c7816ULL, 0x008fc6000000007cULL, 0x0000002d007f7306ULL, 0x0004e20000200c00ULL,
0x000099105e567816ULL, 0x002fe400000000ffULL, 0x00008880115e7816ULL, 0x000fe400000000ffULL,
0x000000ff5600720cULL, 0x000fc60003f05270ULL, 0x0000002c00817306ULL, 0x0003e20000200c00ULL,
0x00000100582d7824ULL, 0x044fe400078e00ffULL, 0x0001000058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x00008880592c7816ULL, 0x002fe400000000ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x000054107d7d7816ULL, 0x008fc6000000007fULL, 0x0000002d00827306ULL, 0x0003f00000200c00ULL,
0x0000002c00837306ULL, 0x0007e20000200c00ULL, 0x00000100592d7824ULL, 0x002fe200078e00ffULL,
0x0000541069697816ULL, 0x004fe2000000006cULL, 0x0001000059597824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000055007a7306ULL, 0x0003e20000200c00ULL,
0x0000b800392c7811ULL, 0x008fe400078e20ffULL, 0x00000018ff597819ULL, 0x000fca0000011459ULL,
0x0000002d00847306ULL, 0x0005e20000200c00ULL, 0x000001005a557824ULL, 0x002fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005400787306ULL, 0x0003e20000200c00ULL,
0x000000002c2c783bULL, 0x004eae0000000200ULL, 0x0000005500877306ULL, 0x0007e20000200c00ULL,
0x000088805a547816ULL, 0x042fe200000000ffULL, 0x000100005a5a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005400867306ULL, 0x0003e20000200c00ULL,
0x000001005b557824ULL, 0x008fca00078e00ffULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x0000005700807306ULL, 0x000fe20000200c00ULL, 0x000088805b547816ULL, 0x042fe200000000ffULL,
0x000100005b5b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005400897306ULL, 0x0003f00000200c00ULL, 0x00000055008a7306ULL, 0x0007e20000200c00ULL,
0x000000622c2c8232ULL, 0x094fe20000000000ULL, 0x0000888010547816ULL, 0x002fe200000000ffULL,
0x000000622e2e8232ULL, 0x000fc40000000000ULL, 0x000000412d2d8232ULL, 0x080fe40000000000ULL,
0x000000412f2f8232ULL, 0x000fe20000000000ULL, 0x0000005800397306ULL, 0x0003e20000200c00ULL,
0x000054106e557816ULL, 0x008fca000000006dULL, 0x000000682c0c723cULL, 0x000fe4000000180cULL,
0x0000005400687306ULL, 0x0005e20000200c00ULL, 0x0000010010587824ULL, 0x042fe400078e00ffULL,
0x0001000010107824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe20000011458ULL,
0x000000762c44723cULL, 0x000fe20000001844ULL, 0x0000005900857306ULL, 0x0003e20000200c00ULL,
0x000054106b547816ULL, 0x004fe4000000006aULL, 0x00000018ff107819ULL, 0x000fc80000011410ULL,
0x0000007c2c4c723cULL, 0x000fe2000000184cULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x0000541072597816ULL, 0x002fcc0000000073ULL, 0x000000542c54723cULL, 0x000fe20000001808ULL,
0x000000003a08783bULL, 0x0002e20000000200ULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x00005410715c7816ULL, 0x004fce000000005cULL, 0x00000058003a7306ULL, 0x0022b00000200c00ULL,
0x0000005a00887306ULL, 0x000fe20000200c00ULL, 0x000054106f587816ULL, 0x002fe40000000070ULL,
0x00005410745d7816ULL, 0x010fca000000005dULL, 0x0000005b008b7306ULL, 0x0003e20000200c00ULL,
0x0000541068687816ULL, 0x004fce000000003aULL, 0x0000006600667306ULL, 0x000ea20000200c00ULL,
0x000000582c58723cULL, 0x002fe20000001804ULL, 0x0000006208088232ULL, 0x008fcc0000000000ULL,
0x0000010011057824ULL, 0x040fe200078e00ffULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000000ffff047224ULL, 0x000fe200078e005eULL, 0x000000620a0a8232ULL, 0x000fe20000000000ULL,
0x0000005c2c5c723cULL, 0x000fe20000001814ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000004109098232ULL, 0x080fe20000000000ULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x000000410b0b8232ULL, 0x000fe20000000000ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x0000541078667816ULL, 0x004fc40000000066ULL, 0x0000888013147816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000541089157816ULL, 0x000fe2000000008aULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x000054107a677816ULL, 0x002fce0000000067ULL,
0x00000005006a7306ULL, 0x0003e20000200c00ULL, 0x000054107e647816ULL, 0x008fe20000000064ULL,
0x000000662c48723cULL, 0x000fec0000001848ULL, 0x0000000400697306ULL, 0x0007220000200c00ULL,
0x0000010012057824ULL, 0x002fe200078e00ffULL, 0x0000541080657816ULL, 0x004fc80000000065ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000888012047816ULL, 0x048fe200000000ffULL, 0x000000642c2c723cULL, 0x000fe20000001850ULL,
0x0001000012127824ULL, 0x000fca00078e00ffULL, 0x0000003800387306ULL, 0x000e620000200c00ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x0000541069697816ULL, 0x010fca000000006aULL,
0x0000004200427306ULL, 0x000ea40000200c00ULL, 0x000000680844723cULL, 0x000fec0000001844ULL,
0x0000000400627306ULL, 0x0007e20000200c00ULL, 0x0000541088387816ULL, 0x002fce0000000038ULL,
0x0000000500417306ULL, 0x0003e20000200c00ULL, 0x0000541081047816ULL, 0x008fce0000000082ULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0000541083057816ULL, 0x002fce0000000084ULL,
0x000000040804723cULL, 0x000fe2000000180cULL, 0x0000003700377306ULL, 0x000fec0000200c00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0014ULL, 0x0000010013147824ULL, 0x040fe200078e00ffULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff137819ULL, 0x000fe40000011413ULL,
0x0000000c00507306ULL, 0x0007f00000200c00ULL, 0x0000001100117306ULL, 0x000f220000200c00ULL,
0x00005410390c7816ULL, 0x008fc40000000043ULL, 0x000054108b397816ULL, 0x004fe40000000042ULL,
0x0000541010367816ULL, 0x002fe40000000036ULL, 0x0000541062107816ULL, 0x000fe20000000041ULL,
0x0000006300637306ULL, 0x000e640000200c00ULL, 0x00000038085c723cULL, 0x000fec000000185cULL,
0x0000001400517306ULL, 0x0004e20000200c00ULL, 0x0000541011377816ULL, 0x010fce0000000037ULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x00005410850d7816ULL, 0x002fe20000000063ULL,
0x000000360848723cULL, 0x000fe20000001848ULL, 0x0000541086147816ULL, 0x004fca0000000087ULL,
0x0000003500357306ULL, 0x000fe20000200c00ULL, 0x0000541050117816ULL, 0x008fe20000000051ULL,
0x0000000c080c723cULL, 0x040fec0000001854ULL, 0x0000001200437306ULL, 0x000e640000200c00ULL,
0x000000140814723cULL, 0x040fec0000001858ULL, 0x0000001300387306ULL, 0x0004e20000200c00ULL,
0x0000541043367816ULL, 0x002fe20000000030ULL, 0x000000100810723cULL, 0x004fe2000000184cULL,
0x0000541038377816ULL, 0x008fce0000000035ULL, 0x000000360808723cULL, 0x000fe2000000182cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0106b800ff2c7f8cULL, 0x000fe8000c80043fULL,
0x0106bc00ff2e7984ULL, 0x000e640000000800ULL, 0x800000002eff7812ULL, 0x002fe4000782482dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000e000007945ULL, 0x000fe20003800000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x0106bc00ff2e7984ULL, 0x000e640000000800ULL,
0x800000002eff7812ULL, 0x002fc4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff2e7424ULL, 0x000fc800078e00ffULL,
0x0000002e002f7305ULL, 0x0002a4000021f000ULL, 0x3fa000002e2e7823ULL, 0x002fe200000100ffULL,
0x0000002f0000735dULL, 0x004fe40003800000ULL, 0x0106bc00ff2f7984ULL, 0x000e640000000800ULL,
0x800000002fff7812ULL, 0x002fe4000782482dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000300182c7a10ULL, 0x000fe20007ffe0ffULL, 0x00000100ff357424ULL, 0x000fc800078e00ffULL,
0x000001002c2d7824ULL, 0x040fe200078e00ffULL, 0x000000012c2c7810ULL, 0x000fc60007ffe0ffULL,
0x000062001b307a24ULL, 0x100fe200078e022dULL, 0x0000002d032e7217ULL, 0x000fe40007800000ULL,
0x000000192c00720cULL, 0x000fe20003f26070ULL, 0x00000001242c7824ULL, 0x100fe400078e0230ULL,
0x000000012e2e7824ULL, 0x000fe400078e0a2dULL, 0x00000001292f7824ULL, 0x000fe200078e0230ULL,
0x00000004ff297819ULL, 0x000fe20000011602ULL, 0x00005e002c2c7625ULL, 0x000fe200078e0035ULL,
0x000000202e2e7807ULL, 0x000fc60000800000ULL, 0x000000012a2a7824ULL, 0x000fe200078e0230ULL,
0x0000002e1a247217ULL, 0x000fe20007800000ULL, 0x00005e002f2e7625ULL, 0x000fe200078e0035ULL,
0x000000252c367210ULL, 0x000fc60007f3e0ffULL, 0x0000000124247824ULL, 0x000fe200078e0a1aULL,
0x000000252e2e7210ULL, 0x000fe20007f7e0ffULL, 0x000000012b2c7824ULL, 0x000fe400078e0230ULL,
0x000000ffff377224ULL, 0x000fe200008e062dULL, 0x000000242900720cULL, 0x080fe20003f46070ULL,
0x00005e002a2a7625ULL, 0x080fe200078e0035ULL, 0x000000242600720cULL, 0x080fe40003f26070ULL,
0x000000242800720cULL, 0x000fe20003f86070ULL, 0x00005e002c2c7625ULL, 0x000fc800078e0035ULL,
0x000000ffff2f7224ULL, 0x000fe200018e062fULL, 0x000000242700720cULL, 0x000fe40003f66070ULL,
0x000000252a247210ULL, 0x080fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000363b7faeULL, 0x0003e2000d101c46ULL, 0x000000252c267210ULL, 0x000fc60007fde0ffULL,
0x000000ffff257224ULL, 0x000fe200028e062bULL, 0x000000002e3c7faeULL, 0x0003e2000c901c46ULL,
0x000000ffff277224ULL, 0x000fc800030e062dULL, 0x00000000243d7faeULL, 0x0005e8000d901c46ULL,
0x00000000263e7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x004fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0106a800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x002fec0000008000ULL, 0x0106a800ff247f8cULL, 0x000fe8000c80043fULL,
0x0106b400ff267984ULL, 0x000e640000000800ULL, 0x8000000026ff7812ULL, 0x002fc40007824861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000f000007945ULL, 0x000fe20003800000ULL,
0x000000ffff417224ULL, 0x000fe200078e0025ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x0106b400ff247984ULL, 0x000e640000000800ULL, 0x8000000024ff7812ULL, 0x002fe40007824861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff247424ULL, 0x000fc800078e00ffULL, 0x0000002400257305ULL, 0x0002a4000021f000ULL,
0x3fa0000024247823ULL, 0x002fe200000100ffULL, 0x000000250000735dULL, 0x004fe40003800000ULL,
0x0106b400ff257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fc40007824861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000031ff24723eULL, 0x000fe400000000ffULL,
0x00000002ff357819ULL, 0x000fe40000011602ULL, 0x0000541024247816ULL, 0x000fe20000000024ULL,
0x00009c527f007947ULL, 0x000fea000b800000ULL, 0x00001f3524357589ULL, 0x0002a400000e0000ULL,
0x00009cb27f007947ULL, 0x000fea000b800000ULL, 0x00001f3224367589ULL, 0x00072400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e0033ULL,
0x0000c370005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fe400078e0024ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fc400078e00ffULL,
0x0000a3c000007944ULL, 0x01efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000ffff597224ULL, 0x000fe200078e0024ULL, 0x0000c3e0005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0034ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000a35000007944ULL, 0x01efea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000003f3c783bULL, 0x000f620000004200ULL,
0x0000b80020207811ULL, 0x000fe400078e20ffULL, 0x0000b80021217811ULL, 0x000fe200078e20ffULL,
0x00000000402c783bULL, 0x000e680000004200ULL, 0x000000001e28783bULL, 0x000ee20000004200ULL,
0x000001003e517824ULL, 0x060fe200078e00ffULL, 0x000088803e507816ULL, 0x000fe200000000ffULL,
0x000001003c437824ULL, 0x000fe200078e00ffULL, 0x00000018ff247819ULL, 0x00afe2000001143cULL,
0x000001003d4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000005000547306ULL, 0x0003e20000200c00ULL, 0x00000018ff407819ULL, 0x000fc4000001142dULL,
0x00000018ff3b7819ULL, 0x000fe4000001142cULL, 0x00000018ff397819ULL, 0x000fe4000001142eULL,
0x00000018ff3a7819ULL, 0x000fe2000001142fULL, 0x0000005100557306ULL, 0x0007620000200c00ULL,
0x000088803f507816ULL, 0x002fe400000000ffULL, 0x000088803c427816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011443ULL,
0x00000018ff387819ULL, 0x000fe20000011429ULL, 0x0000005000577306ULL, 0x0003e20000200c00ULL,
0x000001003f517824ULL, 0x008fe200078e00ffULL, 0x000088803d4d7816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000024004c7306ULL, 0x0007e20000200c00ULL, 0x000088802c507816ULL, 0x002fc400000000ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff377819ULL, 0x000fe40000011428ULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000005100587306ULL, 0x0042a20000200c00ULL, 0x000000001f24783bULL, 0x008ee20000004200ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff347819ULL, 0x000fe4000001142aULL,
0x00000018ff337819ULL, 0x000fc4000001142bULL, 0x00000050005a7306ULL, 0x0009e20000200c00ULL,
0x000001002c517824ULL, 0x002fe200078e00ffULL, 0x0000541054547816ULL, 0x020fe20000000055ULL,
0x000100002c2c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000088802d507816ULL, 0x010fe400000000ffULL, 0x0000541057557816ULL, 0x004fca0000000058ULL,
0x00000051005b7306ULL, 0x0002b00000200c00ULL, 0x0000002c00607306ULL, 0x0009e20000200c00ULL,
0x000001002d517824ULL, 0x042fe400078e00ffULL, 0x000100002d2d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x0000005000617306ULL, 0x0003e20000200c00ULL, 0x000088802e2c7816ULL, 0x010fe400000000ffULL,
0x000054105a5a7816ULL, 0x004fe4000000005bULL, 0x00000018ff307819ULL, 0x008fe40000011424ULL,
0x00000018ff327819ULL, 0x000fe20000011425ULL, 0x0000002d00637306ULL, 0x0005e20000200c00ULL,
0x0000010029507824ULL, 0x002fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fc80000011427ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x0000002c00647306ULL, 0x0003e20000200c00ULL,
0x000001002e2d7824ULL, 0x044fe400078e00ffULL, 0x000100002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x000088802f2c7816ULL, 0x002fce00000000ffULL,
0x0000002d00657306ULL, 0x0002f00000200c00ULL, 0x0000002c00677306ULL, 0x0009e20000200c00ULL,
0x000001002f2d7824ULL, 0x042fe200078e00ffULL, 0x0000541042427816ULL, 0x004fe20000000043ULL,
0x000100002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x00000018ff2f7819ULL, 0x000fe2000001142fULL, 0x0000002e00667306ULL, 0x000fe20000200c00ULL,
0x00008880282c7816ULL, 0x010fe400000000ffULL, 0x0000541064647816ULL, 0x008fca0000000065ULL,
0x0000002d00687306ULL, 0x0002b00000200c00ULL, 0x0000002c006a7306ULL, 0x0007e20000200c00ULL,
0x00000100282d7824ULL, 0x042fe400078e00ffULL, 0x0001000028287824ULL, 0x000fc600078e00ffULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x0000002f00697306ULL, 0x000fe20000200c00ULL,
0x00008880292c7816ULL, 0x048fe200000000ffULL, 0x0001000029297824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe40000011428ULL, 0x0000541067657816ULL, 0x004fe40000000068ULL,
0x00000018ff297819ULL, 0x000fe20000011429ULL, 0x0000002d006b7306ULL, 0x000ff00000200c00ULL,
0x0000002c006c7306ULL, 0x0003f00000200c00ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x00000000202c783bULL, 0x002e6e0000000200ULL, 0x0000004e004e7306ULL, 0x000eb00000200c00ULL,
0x00000029006e7306ULL, 0x0007f00000200c00ULL, 0x0000001e004f7306ULL, 0x0009e20000200c00ULL,
0x000001002a297824ULL, 0x008fe200078e00ffULL, 0x000054104d437816ULL, 0x004fc8000000004eULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1e7819ULL, 0x010fe2000001143eULL, 0x000100003e3e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000000352c2c8232ULL, 0x082fe40000000000ULL, 0x000000352e2e8232ULL, 0x000fe40000000000ULL,
0x000000362d2d8232ULL, 0x080fe40000000000ULL, 0x000000362f2f8232ULL, 0x000fe20000000000ULL,
0x0000002800207306ULL, 0x0003ec0000200c00ULL, 0x000000422c04723cULL, 0x000fe40000001804ULL,
0x0000005100627306ULL, 0x000ea20000200c00ULL, 0x000088802a287816ULL, 0x042fe200000000ffULL,
0x000100002a2a7824ULL, 0x000fc600078e00ffULL, 0x0000010024427824ULL, 0x000fe200078e00ffULL,
0x000000542c14723cULL, 0x000fe20000001814ULL, 0x00000018ff2a7819ULL, 0x000fe2000001142aULL,
0x00000050006d7306ULL, 0x0003e40000200c00ULL, 0x00000018ff427819ULL, 0x000fc80000011442ULL,
0x000000642c10723cULL, 0x000fe40000001810ULL, 0x00000028006f7306ULL, 0x0007e20000200c00ULL,
0x000000002150783bULL, 0x002e620000000200ULL, 0x00005410615b7816ULL, 0x004fcc0000000062ULL,
0x0000002900707306ULL, 0x0005e20000200c00ULL, 0x000088802b287816ULL, 0x048fe200000000ffULL,
0x0000005a2c44723cULL, 0x000fec0000001844ULL, 0x0000002800727306ULL, 0x0007e20000200c00ULL,
0x000001002b297824ULL, 0x044fe400078e00ffULL, 0x000100002b2b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff297819ULL, 0x000fe40000011429ULL, 0x0000001e00567306ULL, 0x0005e20000200c00ULL,
0x0000888024287816ULL, 0x048fe200000000ffULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fc8000001142bULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000002900737306ULL, 0x0007e20000200c00ULL, 0x00000018ff1e7819ULL, 0x004fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000002800437306ULL, 0x0005e20000200c00ULL, 0x000054103d297816ULL, 0x008fe2000000004fULL,
0x0000003550508232ULL, 0x082fe40000000000ULL, 0x0000003552528232ULL, 0x000fe40000000000ULL,
0x0000003651518232ULL, 0x080fe40000000000ULL, 0x0000002a00717306ULL, 0x000fe20000200c00ULL,
0x000054103c287816ULL, 0x004fe2000000004cULL, 0x0000003653538232ULL, 0x000fcc0000000000ULL,
0x0000002b00747306ULL, 0x0003f00000200c00ULL, 0x0000001e00597306ULL, 0x0005e20000200c00ULL,
0x000000282c28723cULL, 0x002fee000000180cULL, 0x00000100250d7824ULL, 0x040fe200078e00ffULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x00008880250c7816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x004fc40000011426ULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0000004000407306ULL, 0x000eb00000200c00ULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x0000541060607816ULL, 0x002fce000000003bULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x0000541063617816ULL, 0x004fce0000000040ULL, 0x0000003900397306ULL, 0x000ea20000200c00ULL,
0x000054103e3e7816ULL, 0x008fe20000000056ULL, 0x000000602c48723cULL, 0x000fec0000001848ULL,
0x0000003a003a7306ULL, 0x000ee20000200c00ULL, 0x000054103f3f7816ULL, 0x002fce0000000059ULL,
0x0000000d003c7306ULL, 0x0003e20000200c00ULL, 0x0000541066667816ULL, 0x004fe20000000039ULL,
0x0000003e2c5c723cULL, 0x000fec000000185cULL, 0x0000000c00217306ULL, 0x0005e20000200c00ULL,
0x00000100260d7824ULL, 0x002fe200078e00ffULL, 0x0000541069677816ULL, 0x008fc8000000003aULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x0000003700377306ULL, 0x000fe20000200c00ULL,
0x00008880260c7816ULL, 0x044fe200000000ffULL, 0x000000662c2c723cULL, 0x000fe20000001808ULL,
0x0001000026267824ULL, 0x000fca00078e00ffULL, 0x0000000c00357306ULL, 0x0003e20000200c00ULL,
0x0000888027087816ULL, 0x000fe400000000ffULL, 0x00000018ff267819ULL, 0x000fca0000011426ULL,
0x0000000d00367306ULL, 0x0004e20000200c00ULL, 0x000054106a0c7816ULL, 0x002fce000000006bULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x000054106c0d7816ULL, 0x004fce000000006dULL,
0x0000000c500c723cULL, 0x000fe20000001804ULL, 0x0000003800387306ULL, 0x000ea20000200c00ULL,
0x0000541035367816ULL, 0x008fca0000000036ULL, 0x0000010027057824ULL, 0x000fe200078e00ffULL,
0x0000541043427816ULL, 0x002fe20000000042ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x000000ffff047224ULL, 0x000fe200078e0008ULL,
0x00000018ff057819ULL, 0x000fe40000011405ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x0000541020087816ULL, 0x000fe40000000037ULL, 0x0000003300337306ULL, 0x000fe20000200c00ULL,
0x000054106e097816ULL, 0x004fc40000000038ULL, 0x0000541021437816ULL, 0x000fca000000003cULL,
0x0000003000307306ULL, 0x000fe20000200c00ULL, 0x000000085008723cULL, 0x040fee0000001828ULL,
0x0000003200327306ULL, 0x000fe20000200c00ULL, 0x000000425044723cULL, 0x000fee0000001844ULL,
0x0000002400247306ULL, 0x000e700000200c00ULL, 0x0000002500257306ULL, 0x000eb00000200c00ULL,
0x0000000400397306ULL, 0x0007e20000200c00ULL, 0x0000541024247816ULL, 0x002fce0000000030ULL,
0x0000000500377306ULL, 0x0003220000200c00ULL, 0x000054106f047816ULL, 0x008fe40000000070ULL,
0x0000541025257816ULL, 0x004fca0000000032ULL, 0x0000001e001e7306ULL, 0x000fe20000200c00ULL,
0x0000541072057816ULL, 0x002fe20000000073ULL, 0x000000245048723cULL, 0x040fec0000001848ULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x0000541039377816ULL, 0x010fe20000000037ULL,
0x000000045004723cULL, 0x040fec0000001814ULL, 0x0000002600267306ULL, 0x000e620000200c00ULL,
0x0000541071147816ULL, 0x000fe20000000034ULL, 0x00000036504c723cULL, 0x000fe20000001810ULL,
0x0000541074157816ULL, 0x000fca0000000033ULL, 0x0000002700277306ULL, 0x000ea40000200c00ULL,
0x000000145014723cULL, 0x000fe2000000185cULL, 0x00005410261e7816ULL, 0x002fe4000000001eULL,
0x00005410271f7816ULL, 0x004fce000000001fULL, 0x0000001e5050723cULL, 0x000fe2000000182cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0106b800ff107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0106a000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff107224ULL, 0x002fc600078e0011ULL,
0x0000030018187a10ULL, 0x000fc80007ffe0ffULL, 0x000000191800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff3a1000007947ULL, 0x000fea000383ffffULL,
0x0000000000257919ULL, 0x000ee20000002500ULL, 0x000000ffff247224ULL, 0x000fe400078e0017ULL,
0x000000ffff237224ULL, 0x000fe400078e0016ULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff217224ULL, 0x000fe400078e0014ULL, 0x000000ffff207224ULL, 0x000fe400078e0007ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0006ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0005ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0004ULL, 0x000000ffff187224ULL, 0x000fe400078e000bULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff167224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x002fe200078e0008ULL, 0x000000192500720cULL, 0x008fe20003f06070ULL,
0x000000ffff157224ULL, 0x000fc400078e000fULL, 0x000000ffff147224ULL, 0x000fe400078e000eULL,
0x000000ffff127224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x004fcc00078e000cULL,
0x0000038000000947ULL, 0x000fea0003800000ULL, 0x018000001d027810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff337224ULL, 0x000fe200078e001dULL, 0x0000d4d000067802ULL, 0x000fe40000000f00ULL,
0x000090a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0002ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001d00047308ULL, 0x000e640000001000ULL,
0xbf80000004027423ULL, 0x002fc8000000001dULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000204047223ULL, 0x000fe40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006600ff027624ULL, 0x000fe400078e00ffULL, 0x00006700ff037624ULL, 0x000fca00078e00ffULL,
0x0000000602027981ULL, 0x0004e8000c1e9900ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe20000011605ULL, 0x0000000402027220ULL, 0x008fe20000410000ULL,
0x0000000805047811ULL, 0x000fc800078ff0ffULL, 0x00001f0302037589ULL, 0x000ea800000e0000ULL,
0x00001f0402047589ULL, 0x000ee200000e0000ULL, 0x0000001103117220ULL, 0x044fe40000410000ULL,
0x0000001203127220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000001603167220ULL, 0x000fc40000410000ULL, 0x0000001b031b7220ULL, 0x040fe40000410000ULL,
0x0000001e031e7220ULL, 0x040fe40000410000ULL, 0x0000002103217220ULL, 0x040fe40000410000ULL,
0x0000002203227220ULL, 0x040fe40000410000ULL, 0x0000004403447220ULL, 0x040fe40000410000ULL,
0x0000004503457220ULL, 0x000fc40000410000ULL, 0x0000004803487220ULL, 0x040fe40000410000ULL,
0x0000004903497220ULL, 0x040fe40000410000ULL, 0x0000004c034c7220ULL, 0x040fe40000410000ULL,
0x0000004d034d7220ULL, 0x040fe40000410000ULL, 0x0000005003507220ULL, 0x040fe40000410000ULL,
0x0000005103517220ULL, 0x000fc40000410000ULL, 0x0000001404147220ULL, 0x048fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001704177220ULL, 0x040fe40000410000ULL,
0x0000001804187220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x040fe40000410000ULL,
0x0000002004207220ULL, 0x000fc40000410000ULL, 0x0000002304237220ULL, 0x040fe40000410000ULL,
0x0000002404247220ULL, 0x040fe40000410000ULL, 0x0000004604467220ULL, 0x040fe40000410000ULL,
0x0000004704477220ULL, 0x040fe40000410000ULL, 0x0000004a044a7220ULL, 0x040fe40000410000ULL,
0x0000004b044b7220ULL, 0x000fc40000410000ULL, 0x0000004e044e7220ULL, 0x040fe40000410000ULL,
0x0000004f044f7220ULL, 0x040fe40000410000ULL, 0x0000005204527220ULL, 0x040fe40000410000ULL,
0x0000005304537220ULL, 0x000fe40000410000ULL, 0x0000000000027919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000202037812ULL, 0x004fc400078ec0ffULL,
0x00000002ff0e7819ULL, 0x000fe40000011602ULL, 0x00000001ff047819ULL, 0x000fe40000011603ULL,
0x0000000203057811ULL, 0x040fe400078ff8ffULL, 0x0000000403087811ULL, 0x040fe400078ff8ffULL,
0x00000006030c7811ULL, 0x000fe400078ff8ffULL, 0x0000000802107811ULL, 0x000fc400078ff0ffULL,
0x0000000704037812ULL, 0x100fe400078e780eULL, 0x0000000705067812ULL, 0x140fe400078e780eULL,
0x00000007080a7812ULL, 0x000fe200078e780eULL, 0x000000080e077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078e7810ULL, 0x000000080e097824ULL, 0x000fe200078e0206ULL,
0x000000070c0d7812ULL, 0x000fe200078e780eULL, 0x0000080000037824ULL, 0x000fe200078e00ffULL,
0x0000000704047812ULL, 0x000fe200078e7810ULL, 0x00000008100f7824ULL, 0x000fe200078e0208ULL,
0x0000000705057812ULL, 0x000fe200078e7810ULL, 0x000000080e0b7824ULL, 0x000fe200078e020aULL,
0x000000070c067812ULL, 0x000fe200078e7810ULL, 0x000000080e0d7824ULL, 0x000fc400078e020dULL,
0x00000008100c7824ULL, 0x000fe200078e0204ULL, 0x0000a00003047810ULL, 0x000fe20007ffe0ffULL,
0x0000000802087824ULL, 0x000fe400078e00ffULL, 0x00000008100e7824ULL, 0x000fe200078e0205ULL,
0x000000111205723eULL, 0x000fe200000000ffULL, 0x0000000810107824ULL, 0x000fe200078e0206ULL,
0x0000000808087812ULL, 0x000fe200078ec0ffULL, 0x0000001007077824ULL, 0x100fe200078e0204ULL,
0x000000131606723eULL, 0x000fe200000000ffULL, 0x00000010090a7824ULL, 0x000fc400078e0204ULL,
0x000000100b0b7824ULL, 0x000fe200078e0204ULL, 0x0000541005127816ULL, 0x040fe20000000006ULL,
0x000000100c0c7824ULL, 0x000fe200078e0204ULL, 0x0000763205137816ULL, 0x000fe20000000006ULL,
0x000000100e0e7824ULL, 0x100fe200078e0204ULL, 0x000000444505723eULL, 0x000fe200000000ffULL,
0x000000100d0d7824ULL, 0x100fe400078e0204ULL, 0x000000100f0f7824ULL, 0x100fe400078e0204ULL,
0x0000001010107824ULL, 0x000fc400078e0204ULL, 0x0000000107097824ULL, 0x000fe200078e0208ULL,
0x0000001b1e07723eULL, 0x000fe200000000ffULL, 0x00000001080a7824ULL, 0x040fe400078e020aULL,
0x00000001080b7824ULL, 0x040fe200078e020bULL, 0x0000001209007388ULL, 0x0005e20000000a00ULL,
0x00000001080c7824ULL, 0x040fe400078e020cULL, 0x00000001080e7824ULL, 0x040fe400078e020eULL,
0x00000001080d7824ULL, 0x000fc400078e020dULL, 0x00000001080f7824ULL, 0x040fe400078e020fULL,
0x0000000108107824ULL, 0x000fe200078e0210ULL, 0x000000212208723eULL, 0x000fe400000000ffULL,
0x000000141509723eULL, 0x004fe400000000ffULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe40000000008ULL, 0x000000505108723eULL, 0x000fc600000000ffULL,
0x000000060a007388ULL, 0x0005e40000000a00ULL, 0x000000484906723eULL, 0x004fe400000000ffULL,
0x0000004c4d07723eULL, 0x000fe400000000ffULL, 0x00000017180a723eULL, 0x000fe200000000ffULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x0000541005127816ULL, 0x140fe40000000006ULL,
0x0000763205137816ULL, 0x000fc40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000120b007388ULL, 0x000fe20000000a00ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x000000060d007388ULL, 0x0005e20000000a00ULL, 0x0000001f2005723eULL, 0x000fe400000000ffULL,
0x000000011800780cULL, 0x000fe20003f05270ULL, 0x000000080c007388ULL, 0x0007e20000000a00ULL,
0x00000052530a723eULL, 0x000fc400000000ffULL, 0x000000232406723eULL, 0x004fe400000000ffULL,
0x000000464707723eULL, 0x000fe400000000ffULL, 0x0000004a4b08723eULL, 0x008fe400000000ffULL,
0x0000004e4f09723eULL, 0x000fe400000000ffULL, 0x00005410050c7816ULL, 0x140fe40000000006ULL,
0x00007632050d7816ULL, 0x000fc40000000006ULL, 0x0000541007067816ULL, 0x140fe40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x0000000c0e007388ULL, 0x0005e20000000a00ULL,
0x0000541009087816ULL, 0x140fe4000000000aULL, 0x0000763209097816ULL, 0x000fe2000000000aULL,
0x000000060f007388ULL, 0x0005e80000000a00ULL, 0x0000000810007388ULL, 0x0005e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002b3000008947ULL, 0x000fea0003800000ULL,
0x0000000000107919ULL, 0x004ea20000002700ULL, 0x0000001002057824ULL, 0x000fe200078e0203ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00001000ff097424ULL, 0x000fe200078e00ffULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00000020020e7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0200720cULL, 0x000fe20000725670ULL, 0x00a0000005147984ULL, 0x000ee80000000c00ULL,
0x00a2000005207984ULL, 0x0008640000000c00ULL, 0x0000580018057a24ULL, 0x010fc800078e02ffULL,
0x0000640005077a24ULL, 0x000fe400078e02ffULL, 0x0000580010107a24ULL, 0x004fc600078e0206ULL,
0x00000fff07067811ULL, 0x040fe400078e40ffULL, 0x01ffffff07077812ULL, 0x000fe200078ec0ffULL,
0x0000030010057a24ULL, 0x000fc800078e02ffULL, 0x00000001050a7824ULL, 0x000fca00078e0225ULL,
0x0000000a06087211ULL, 0x000fca00078fa0ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x0000040000087825ULL, 0x000fcc00078e0008ULL, 0x000000100e0e7825ULL, 0x000fc800078e0008ULL,
0x00000010020c7825ULL, 0x000fe200078e0008ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000001002087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011602ULL,
0x00000080ff117424ULL, 0x000fe400078e00ffULL, 0x000000010a0b7824ULL, 0x000fe200078e0207ULL,
0x0000007008127812ULL, 0x000fe400078ec0ffULL, 0x0000000c09137812ULL, 0x000fe200078ec0ffULL,
0x00006a000a087625ULL, 0x000fc800078e0011ULL, 0x00006a000b0a7625ULL, 0x000fe200078e0011ULL,
0x0000000813087210ULL, 0x000fc80007b5e012ULL, 0x0000000a130a7210ULL, 0x000fe40007d9e012ULL,
0x00000009ff097210ULL, 0x000fe400017e64ffULL, 0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL,
0x0000001c08007986ULL, 0x0003e8000c101906ULL, 0x0000001d0a007986ULL, 0x0003e4000c101906ULL,
0x000000140c007986ULL, 0x00a3e2000c101d06ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x000000200e007986ULL, 0x0003e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x00000004ff087424ULL, 0x000fe200078e00ffULL,
0xffffffff180a7810ULL, 0x000fc60007ffe0ffULL, 0x0000680010087625ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000a080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000a0800720cULL, 0x004fe20003f25270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff097807ULL, 0x000fca0000800000ULL,
0x00000009ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff087984ULL, 0x000ee40000000000ULL,
0x000000ff0800720cULL, 0x008fda0003f25270ULL, 0x0000277000009947ULL, 0x000fea0003800000ULL,
0x00000d1000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x004fe20000011602ULL, 0x00000080ff127424ULL, 0x000fe200078e00ffULL,
0x00000001050a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007008137812ULL, 0x000fe400078ec0ffULL,
0x0000000c09147812ULL, 0x002fe200078ec0ffULL, 0x00006a0005087625ULL, 0x000fc800078e0012ULL,
0x00006a000a0a7625ULL, 0x000fe200078e0012ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x0000000a140a7210ULL, 0x000fe40007b5e013ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x00000006080c7981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x000000021800780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000205087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000006080e7981ULL, 0x000362000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000305087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000405087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0012ULL, 0x0000000814087210ULL, 0x000fc8000791e013ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608107981ULL, 0x000362000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000505087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000814087210ULL, 0x000fc8000791e013ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608117981ULL, 0x000362000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000081800780cULL, 0x002fe40003f06070ULL,
0x0000000605087810ULL, 0x000fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0012ULL,
0x0000000814087210ULL, 0x000fe40007a3e013ULL, 0x00000007050a0810ULL, 0x000fe40007ffe0ffULL,
0x00000009ff097210ULL, 0x000fc60000fe44ffULL, 0x00006a000a0a0625ULL, 0x000fe400078e0012ULL,
0x0000000608127981ULL, 0x000366000c1e1900ULL, 0x0000000a140a0210ULL, 0x000fc80007c7e013ULL,
0x0000000bff0b0210ULL, 0x000fca0001fe84ffULL, 0x000000060a130981ULL, 0x000368000c1e1900ULL,
0x0000000718087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff147224ULL, 0x020fe400078e000cULL,
0x000000080b157824ULL, 0x040fe200078e00ffULL, 0x000000010b0b7810ULL, 0x000fc80007ffe0ffULL,
0x0000030015007a0cULL, 0x000fe40003f26070ULL, 0x0000000a0b00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000815087810ULL, 0x040fe40007ffe0ffULL,
0x0000000115097810ULL, 0x004fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000140c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002147824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007014147812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e014ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608147981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000915087810ULL, 0x042fe40007ffe0ffULL, 0x0000000215097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010020d7824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e00dULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080d7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000315097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000e0c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x00000010020e7824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e00eULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080e7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000415097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x00000010020f7824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x000000700f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000515097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000100c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002107824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007010107812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e010ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608107981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d15087810ULL, 0x042fe40007ffe0ffULL, 0x0000000615097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff167819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001002117824ULL, 0x000fe200078e00ffULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007011117812ULL, 0x000fc800078ec0ffULL, 0x0000000816087210ULL, 0x000fc80007b3e011ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608117981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e15087810ULL, 0x042fe40007ffe0ffULL,
0x0000000715097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x000000120c0c7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000105087824ULL, 0x000fe200078e0208ULL,
0x00000001ff167819ULL, 0x000fe20000011602ULL, 0x00000080ff097424ULL, 0x000fe400078e00ffULL,
0x0000001002127824ULL, 0x000fe200078e00ffULL, 0x0000000c16167812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fc600078e0009ULL, 0x0000007012127812ULL, 0x000fc800078ec0ffULL,
0x0000000816087210ULL, 0x000fc80007b3e012ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608127981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f15087810ULL, 0x002fe40007ffe0ffULL, 0x000000130c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000105087824ULL, 0x000fe200078e0208ULL, 0x00000001ff157819ULL, 0x000fe20000011602ULL,
0x00000080ff097424ULL, 0x000fe400078e00ffULL, 0x0000001002137824ULL, 0x000fe200078e00ffULL,
0x0000000c15157812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fc600078e0009ULL,
0x0000007013137812ULL, 0x000fc800078ec0ffULL, 0x0000000815087210ULL, 0x000fc80007a3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe44ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000ee40000000000ULL,
0x0000001002087824ULL, 0x00afe200078e00ffULL, 0x00000001ff097819ULL, 0x004fc80000011602ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108087824ULL, 0x000fca00078e0209ULL, 0x0000000c08007388ULL, 0x0203e40000000800ULL,
0x0000000506087211ULL, 0x002fe200078fa0ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00001000ff097424ULL, 0x004fe200078e00ffULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x00000010020a7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe20000011602ULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x00000016ff437819ULL, 0x000fe20000011600ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000040000427824ULL, 0x040fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000100000227824ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000004208087210ULL, 0x000fe20007f3e0ffULL,
0x000000010a1b7824ULL, 0x000fe200078e020bULL, 0x00000020020a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001050c8824ULL, 0x000fe200078e0207ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000109097824ULL, 0x000fe200008e0643ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0d8424ULL, 0x000fe200078e00ffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000080ff0e8424ULL, 0x000fe200078e00ffULL, 0x000000001b1b7984ULL, 0x000e620000000800ULL,
0x00006a000c0c8625ULL, 0x000fe200078e000dULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x000000100a0a7825ULL, 0x000fe200078e0008ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001002107824ULL, 0x000fc400078e0222ULL, 0x0000001000118824ULL, 0x000fe400078e0202ULL,
0x0000001002087825ULL, 0x000fc600078e0008ULL, 0x0000458011118811ULL, 0x000fe200078e20ffULL,
0x00006a00050e8625ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008107faeULL, 0x0005e6000b901c46ULL, 0x0000001000128824ULL, 0x000fe200078e0202ULL,
0x003800000a107faeULL, 0x0007e2000b901c46ULL, 0x00000010020c8825ULL, 0x000fc800078e000cULL,
0x00000010020e8825ULL, 0x000fe200078e000eULL, 0x000000000c118faeULL, 0x0009e2000b901c46ULL,
0x0000418012098811ULL, 0x004fe400078e20ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x008fe4000001ff00ULL, 0x000000000e098faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000c7805ULL, 0x010fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000cf000009947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x002fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fca00078e00ffULL,
0x0000000134357810ULL, 0x000fc80007ffe0ffULL, 0x0000030035007a0cULL, 0x000fda0003f06070ULL,
0x0000023000000947ULL, 0x000fea0003800000ULL, 0x0000000105217824ULL, 0x000fe200078e0235ULL,
0x000000070200780cULL, 0x000fe20003f24070ULL, 0x00001000ff197424ULL, 0x000fe200078e00ffULL,
0x0000000135207812ULL, 0x040fe200078ec0ffULL, 0x00000800351c7824ULL, 0x000fe200078e00ffULL,
0x0000002106187211ULL, 0x000fe400078fa0ffULL, 0x0000002002387810ULL, 0x000fe40007ffe0ffULL,
0x000008001c1e7812ULL, 0x000fe200078ec0ffULL, 0x00006a0018187625ULL, 0x000fc800078e0019ULL,
0x00000001071d9824ULL, 0x000fe200078e0221ULL, 0x0000004218187210ULL, 0x000fe20007f1e0ffULL,
0x00000080ff369424ULL, 0x000fe400078e00ffULL, 0x00000002001f9824ULL, 0x140fe400078e0220ULL,
0x0000000200399824ULL, 0x000fe400078e0220ULL, 0x00006a001d1c9625ULL, 0x000fc800078e0036ULL,
0x00000080ff209424ULL, 0x000fe400078e00ffULL, 0x00000001221e7824ULL, 0x000fe400078e021eULL,
0x0000000119197824ULL, 0x000fe400000e0643ULL, 0x000000081f379824ULL, 0x000fe400078e0202ULL,
0x00006a0021209625ULL, 0x000fc600078e0020ULL, 0x0000458037379811ULL, 0x000fe200078e20ffULL,
0x0000001002367824ULL, 0x040fe400078e021eULL, 0x0000000839399824ULL, 0x000fe400078e0202ULL,
0x00000010021e9825ULL, 0x000fc800078e001cULL, 0x00000010381c7825ULL, 0x000fe200078e0018ULL,
0x0000418039389811ULL, 0x000fc600078e20ffULL, 0x0000001002187825ULL, 0x000fc800078e0018ULL,
0x0000001002209825ULL, 0x000fe200078e0020ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000018367faeULL, 0x0003e8000b901c46ULL, 0x003800001c367faeULL, 0x0003e8000b901c46ULL,
0x000000001e379faeULL, 0x0003e8000b901c46ULL, 0x0000000020389faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff377224ULL, 0x002fe200078e0034ULL,
0x00000001ff1c7819ULL, 0x100fe20000011602ULL, 0x0000001002197824ULL, 0x000fe200078e00ffULL,
0x00000002ff447819ULL, 0x000fe20000011602ULL, 0x0000008037187824ULL, 0x000fe200078e00ffULL,
0x0000000c1c1c7812ULL, 0x000fc400078ec0ffULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00000008441d7824ULL, 0x000fe200078e00ffULL, 0x0000008018187812ULL, 0x000fe400078ec0ffULL,
0x00000044ff367212ULL, 0x000fe400078e33ffULL, 0x0000000744347812ULL, 0x000fe200078ec0ffULL,
0x0000010000187824ULL, 0x000fe200078e0218ULL, 0xfffffff81d367812ULL, 0x000fe400078ee236ULL,
0x0000000844457810ULL, 0x000fc40007ffe0ffULL, 0x000000181c187210ULL, 0x000fe20007ffe019ULL,
0x0000000844197824ULL, 0x000fe200078e00ffULL, 0x00000045ff3f7212ULL, 0x000fe200078e33ffULL,
0x0000000845387824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000181c7984ULL, 0x000e620000000800ULL, 0x00000001191d7812ULL, 0x100fe200078ef634ULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0x00000002191e7812ULL, 0x140fe200078ef634ULL,
0x0045800018417984ULL, 0x0004e20000000800ULL, 0x00000003191f7812ULL, 0x140fe400078ef634ULL,
0x0000000419207812ULL, 0x140fe400078ef634ULL, 0x0000000519217812ULL, 0x000fe400078ef634ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee23fULL, 0x0000000844187824ULL, 0x004fca00078e00ffULL,
0xfffffff818187812ULL, 0x100fe400078ee234ULL, 0x0000000619347812ULL, 0x000fe200078ef634ULL,
0x0000080037197824ULL, 0x000fca00078e00ffULL, 0x0000080019197812ULL, 0x000fc800078ec0ffULL,
0x0000018022197810ULL, 0x000fca0007ffe019ULL, 0x0000001018187824ULL, 0x100fe400078e0219ULL,
0x000000101d1d7824ULL, 0x100fe400078e0219ULL, 0x000000101f1f7824ULL, 0x100fe400078e0219ULL,
0x0000001c1b1c7221ULL, 0x002fe40000010100ULL, 0x000000101e1e7824ULL, 0x000fe400078e0219ULL,
0x3fb8aa3b1c377820ULL, 0x000fc40000410000ULL, 0x00000004021c7824ULL, 0x000fe400078e00ffULL,
0x0000003700407308ULL, 0x0002e20000000800ULL, 0x0000001021217824ULL, 0x100fe400078e0219ULL,
0x0000000c1c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000001020207824ULL, 0x100fe400078e0219ULL,
0x0000001034347824ULL, 0x000fe400078e0219ULL, 0x0000000118187824ULL, 0x000fe200078e021cULL,
0x0000000745377812ULL, 0x002fe200078ec0ffULL, 0x000000011c1d7824ULL, 0x000fc400078e021dULL,
0x000000011c1f7824ULL, 0x000fe200078e021fULL, 0xfffffff838387812ULL, 0x100fe200078ee237ULL,
0x0000000018187984ULL, 0x000e620000000800ULL, 0x000000011c1e7824ULL, 0x040fe200078e021eULL,
0x00000001393a7812ULL, 0x040fe200078ef637ULL, 0x000000011c217824ULL, 0x000fe200078e0221ULL,
0x000000001d1d7984ULL, 0x000fe20000000800ULL, 0x0000004140407220ULL, 0x008fe20000410000ULL,
0x00000002393b7812ULL, 0x140fe200078ef637ULL, 0x000000011c207824ULL, 0x040fe200078e0220ULL,
0x000000001f1f7984ULL, 0x000fe20000000800ULL, 0x000000011c347824ULL, 0x000fe200078e0234ULL,
0x00000003393c7812ULL, 0x040fe200078ef637ULL, 0x0000001038387824ULL, 0x000fe200078e0219ULL,
0x000000001e1e7984ULL, 0x000fe20000000800ULL, 0x00000004393d7812ULL, 0x040fe200078ef637ULL,
0x000000103a3a7824ULL, 0x000fe200078e0219ULL, 0x00000005393e7812ULL, 0x140fe200078ef637ULL,
0x0000000021217984ULL, 0x000fe20000000800ULL, 0x0000000639377812ULL, 0x000fe200078ef637ULL,
0x000000011c387824ULL, 0x000fc400078e0238ULL, 0x00001f4440397589ULL, 0x000ea200000e0000ULL,
0x000000011c3a7824ULL, 0x000fe400078e023aULL, 0x000000103b3b7824ULL, 0x100fe200078e0219ULL,
0x0000000020207984ULL, 0x000ee20000000800ULL, 0x000000103c3c7824ULL, 0x000fe400078e0219ULL,
0x000000011c3b7824ULL, 0x040fe200078e023bULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x000000011c3c7824ULL, 0x000fe400078e023cULL, 0x000000103d3d7824ULL, 0x100fe200078e0219ULL,
0x0000000038387984ULL, 0x000f220000000800ULL, 0x000000103e3e7824ULL, 0x000fc400078e0219ULL,
0x000000011c3d7824ULL, 0x040fe200078e023dULL, 0x000000003a3a7984ULL, 0x000f620000000800ULL,
0x000000011c3e7824ULL, 0x000fe400078e023eULL, 0x0000001036367824ULL, 0x100fe200078e0219ULL,
0x000000003b3b7984ULL, 0x000fe20000000800ULL, 0x0000001037377824ULL, 0x100fe400078e0219ULL,
0x000000103f3f7824ULL, 0x000fe200078e0219ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x20000018ff197230ULL, 0x102fe20000004100ULL, 0x000000011c367824ULL, 0x040fe200078e0236ULL,
0x30000018ff187230ULL, 0x000fe20000004100ULL, 0x000000011c377824ULL, 0x040fe200078e0237ULL,
0x000000003d3d7984ULL, 0x000fe20000000800ULL, 0x000000011c3f7824ULL, 0x000fc400078e023fULL,
0x0000003918317223ULL, 0x084fe20000010031ULL, 0x000000003e3e7984ULL, 0x000fe20000000800ULL,
0x2000001dff187230ULL, 0x100fe20000004100ULL, 0x0000003340337221ULL, 0x000fe20000010000ULL,
0x3000001dff1d7230ULL, 0x000fe20000004100ULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x0000003919327223ULL, 0x080fe20000010032ULL, 0x2000001eff197230ULL, 0x100fe20000004100ULL,
0x0000003918307223ULL, 0x080fe20000010030ULL, 0x0000000037377984ULL, 0x000fe20000000800ULL,
0x2000001fff187230ULL, 0x000fe20000004100ULL, 0x000000391d2f7223ULL, 0x080fe2000001002fULL,
0x3000001eff1e7230ULL, 0x000fe20000004100ULL, 0x000000003f3f7984ULL, 0x000fe20000000800ULL,
0x00000039192e7223ULL, 0x080fe2000001002eULL, 0x20000020ff197230ULL, 0x008fe20000004100ULL,
0x00000039182c7223ULL, 0x080fe2000001002cULL, 0x00001f4540407589ULL, 0x000e6200000e0000ULL,
0x20000021ff187230ULL, 0x000fe20000004100ULL, 0x000000391e2d7223ULL, 0x080fe2000001002dULL,
0x3000001fff1f7230ULL, 0x000fe20000004100ULL, 0x00000039192a7223ULL, 0x080fe2000001002aULL,
0x20000038ff197230ULL, 0x010fe20000004100ULL, 0x0000003918287223ULL, 0x080fe20000010028ULL,
0x20000034ff187230ULL, 0x100fe20000004100ULL, 0x000000391f2b7223ULL, 0x000fe2000001002bULL,
0x30000034ff347230ULL, 0x000fc40000004100ULL, 0x30000020ff207230ULL, 0x000fe20000004100ULL,
0x0000003918267223ULL, 0x080fe20000010026ULL, 0x2000003aff187230ULL, 0x020fe20000004100ULL,
0x0000003934257223ULL, 0x080fe20000010025ULL, 0x30000021ff217230ULL, 0x000fe20000004100ULL,
0x000000ffff347224ULL, 0x000fe200078e0035ULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x0000003920297223ULL, 0x080fe20000010029ULL, 0x3000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000003921277223ULL, 0x080fe20000010027ULL, 0x0000030034007a0cULL, 0x000fe20003f06070ULL,
0x0000004019177223ULL, 0x082fe20000010017ULL, 0x2000003bff197230ULL, 0x000fe20000004100ULL,
0x0000004018157223ULL, 0x080fe20000010015ULL, 0x2000003cff187230ULL, 0x000fe20000004100ULL,
0x0000004038167223ULL, 0x080fe20000010016ULL, 0x20000036ff1c7230ULL, 0x000fe20000004100ULL,
0x0000004019137223ULL, 0x080fe20000010013ULL, 0x2000003eff197230ULL, 0x000fe20000004100ULL,
0x0000004018117223ULL, 0x080fe20000010011ULL, 0x2000003dff187230ULL, 0x000fe20000004100ULL,
0x000000391c247223ULL, 0x080fe20000010024ULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x00000040190d7223ULL, 0x080fe2000001000dULL, 0x2000003fff197230ULL, 0x000fe20000004100ULL,
0x00000040180f7223ULL, 0x080fe2000001000fULL, 0x20000037ff187230ULL, 0x000fe20000004100ULL,
0x0000003936237223ULL, 0x000fe20000010023ULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x000000403a147223ULL, 0x080fe20000010014ULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x00000040180b7223ULL, 0x080fe2000001000bULL, 0x3000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000403b127223ULL, 0x080fe20000010012ULL, 0x3000003eff3e7230ULL, 0x000fe20000004100ULL,
0x000000403c107223ULL, 0x080fe20000010010ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x000000403d0e7223ULL, 0x080fe2000001000eULL, 0x3000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000403e0c7223ULL, 0x000fc4000001000cULL, 0x00000040370a7223ULL, 0x080fe4000001000aULL,
0x0000004019097223ULL, 0x080fe40000010009ULL, 0x000000403f087223ULL, 0x000fe20000010008ULL,
0xfffff33000008947ULL, 0x000fea000383ffffULL, 0x0180000033007810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000000007812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000ff5000067802ULL, 0x000fe40000000f00ULL,
0x0000662000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0002ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300007308ULL, 0x000e640000001000ULL,
0xbf80000000337423ULL, 0x002fc80000000033ULL, 0x800000ff33337221ULL, 0x000fc80000010100ULL,
0x0000003300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff187819ULL, 0x004fe20000011602ULL, 0x00000004021f7824ULL, 0x040fe200078e00ffULL,
0x00000008021e7811ULL, 0x000fe400078ff0ffULL, 0x00000018ff067212ULL, 0x000fe200078e33ffULL,
0x00001f1800057589ULL, 0x000ea200000e0000ULL, 0x0000001eff1d7212ULL, 0x000fe200078e33ffULL,
0x000000081e077824ULL, 0x040fe200078e00ffULL, 0x000000071e1c7812ULL, 0x000fe200078ec0ffULL,
0x00001f1e00007589ULL, 0x000ee200000e0000ULL, 0x0000000818207824ULL, 0x000fe200078e00ffULL,
0x0000000c1f1f7812ULL, 0x000fc400078ec0ffULL, 0xfffffff8071d7812ULL, 0x000fe400078ee21dULL,
0x0000000718077812ULL, 0x000fe400078ec0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee206ULL,
0x0000000818067824ULL, 0x000fe200078e00ffULL, 0x000000041c197812ULL, 0x040fe200078e3cffULL,
0x000000101d1d7824ULL, 0x000fe200078e0204ULL, 0x000000051c1b7812ULL, 0x000fe400078e3cffULL,
0xfffffff806067812ULL, 0x000fe200078ee218ULL, 0x000000081e197824ULL, 0x000fc400078e0219ULL,
0x000000081e1b7824ULL, 0x000fe400078e021bULL, 0x0000001006067824ULL, 0x000fe400078e0204ULL,
0x0000003205327220ULL, 0x044fe40000410000ULL, 0x0000003105317220ULL, 0x000fe40000410000ULL,
0x0000001700177220ULL, 0x048fe40000410000ULL, 0x0000001600167220ULL, 0x040fe20000410000ULL,
0x000000323131723eULL, 0x000fe200000000ffULL, 0x0000001500157220ULL, 0x000fc40000410000ULL,
0x0000001400147220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000001300137220ULL, 0x000fe20000410000ULL, 0x000000021c177812ULL, 0x000fe200078e3cffULL,
0x0000001200127220ULL, 0x000fe20000410000ULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000001100117220ULL, 0x040fe40000410000ULL, 0x0000001000107220ULL, 0x000fe20000410000ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000f000f7220ULL, 0x000fc40000410000ULL,
0x0000000e000e7220ULL, 0x000fe20000410000ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000d000d7220ULL, 0x040fe20000410000ULL, 0x0000000607117812ULL, 0x040fe200078e3cffULL,
0x0000000c000c7220ULL, 0x000fe20000410000ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x0000000b000b7220ULL, 0x040fe20000410000ULL, 0x00000005070f7812ULL, 0x040fe200078e3cffULL,
0x0000000a000a7220ULL, 0x000fe20000410000ULL, 0x0000000d0c0c723eULL, 0x000fe200000000ffULL,
0x0000000900097220ULL, 0x040fe20000410000ULL, 0x00000004070d7812ULL, 0x040fe200078e3cffULL,
0x0000000800007220ULL, 0x000fe20000410000ULL, 0x0000000107087812ULL, 0x000fe200078e3cffULL,
0x000000081e137824ULL, 0x000fe200078e00ffULL, 0x0000000b0a0a723eULL, 0x000fe200000000ffULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x000000090000723eULL, 0x000fe200000000ffULL,
0x0000002f052f7220ULL, 0x000fe20000410000ULL, 0x0000000207097812ULL, 0x000fe200078e3cffULL,
0x0000002e052e7220ULL, 0x000fe20000410000ULL, 0x00000003070b7812ULL, 0x000fe200078e3cffULL,
0x0000000818077824ULL, 0x040fe200078e0208ULL, 0xfffffff813137812ULL, 0x000fe200078ee21eULL,
0x0000000818087824ULL, 0x040fe200078e0209ULL, 0x000000302f2f723eULL, 0x000fe200000000ffULL,
0x0000000818097824ULL, 0x000fc400078e020bULL, 0x00000008180b7824ULL, 0x040fe400078e020dULL,
0x00000008180d7824ULL, 0x040fe400078e020fULL, 0x00000008180f7824ULL, 0x000fe200078e0211ULL,
0x000000011c117812ULL, 0x040fe200078e3cffULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x000000031c187812ULL, 0x040fe200078e3cffULL, 0x0000001007077824ULL, 0x000fe200078e0204ULL,
0x000000061c1c7812ULL, 0x000fe200078e3cffULL, 0x0000002c052c7220ULL, 0x000fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x0000002b052b7220ULL, 0x000fc40000410000ULL,
0x0000001008087824ULL, 0x100fe400078e0204ULL, 0x0000002a052a7220ULL, 0x000fe20000410000ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000002905297220ULL, 0x000fe40000410000ULL,
0x0000001009097824ULL, 0x000fe400078e0204ULL, 0x0000002805287220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000002705277220ULL, 0x000fc40000410000ULL,
0x000000011f067824ULL, 0x000fe400078e0206ULL, 0x000000100b0b7824ULL, 0x100fe200078e0204ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000003106007388ULL, 0x0005e20000000800ULL, 0x0000002505257220ULL, 0x040fe40000410000ULL,
0x0000002405247220ULL, 0x000fe40000410000ULL, 0x000000081e157824ULL, 0x000fe200078e0211ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x000fc400078e0204ULL,
0x000000011f077824ULL, 0x000fe400078e0207ULL, 0x0000002305057220ULL, 0x000fe40000410000ULL,
0x000000081e177824ULL, 0x040fe200078e0217ULL, 0x0000002f07007388ULL, 0x0005e20000000800ULL,
0x000000100f0f7824ULL, 0x000fe200078e0204ULL, 0x000000240505723eULL, 0x000fe200000000ffULL,
0x000000011f087824ULL, 0x000fe400078e0208ULL, 0x000000081e187824ULL, 0x000fc400078e0218ULL,
0x0000001020117824ULL, 0x100fe200078e0204ULL, 0x0000002d08007388ULL, 0x0005e20000000800ULL,
0x000000011f097824ULL, 0x000fe400078e0209ULL, 0x0000001013137824ULL, 0x100fe400078e0204ULL,
0x000000011f0b7824ULL, 0x000fe200078e020bULL, 0x0000002b09007388ULL, 0x0005e20000000800ULL,
0x0000001015157824ULL, 0x000fe400078e0204ULL, 0x000000011f0d7824ULL, 0x000fe200078e020dULL,
0x000000290b007388ULL, 0x0005e20000000800ULL, 0x000000081e1c7824ULL, 0x000fc400078e021cULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x000000270d007388ULL, 0x0005e20000000800ULL,
0x000000011f0f7824ULL, 0x040fe400078e020fULL, 0x0000001018187824ULL, 0x100fe400078e0204ULL,
0x000000011f117824ULL, 0x000fe200078e0211ULL, 0x000000250f007388ULL, 0x0005e20000000800ULL,
0x0000001019197824ULL, 0x100fe400078e0204ULL, 0x000000011f137824ULL, 0x000fe200078e0213ULL,
0x0000000511007388ULL, 0x0005e20000000800ULL, 0x000000101b1b7824ULL, 0x000fc400078e0204ULL,
0x000000011f157824ULL, 0x040fe200078e0215ULL, 0x0000001613007388ULL, 0x0005e20000000800ULL,
0x000000101c1c7824ULL, 0x000fe400078e0204ULL, 0x000000011f177824ULL, 0x040fe200078e0217ULL,
0x0000001415007388ULL, 0x0005e20000000800ULL, 0x000000011f187824ULL, 0x040fe400078e0218ULL,
0x000000011f197824ULL, 0x040fe200078e0219ULL, 0x0000001217007388ULL, 0x0005e20000000800ULL,
0x000000011f1b7824ULL, 0x000fc400078e021bULL, 0x000000011f1c7824ULL, 0x040fe200078e021cULL,
0x0000001018007388ULL, 0x0005e20000000800ULL, 0x000000011f1d7824ULL, 0x000fc600078e021dULL,
0x0000000e19007388ULL, 0x0005e80000000800ULL, 0x0000000c1b007388ULL, 0x0005e80000000800ULL,
0x0000000a1c007388ULL, 0x0005e80000000800ULL, 0x000000001d007388ULL, 0x0005e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000002002117810ULL, 0x004fe20007ffe0ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x00000003ff007819ULL, 0x100fe20000011602ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x00000003ff057819ULL, 0x100fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000700047812ULL, 0x000fe200078e4802ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000705067812ULL, 0x000fc400078e4811ULL,
0x0ffffff804047812ULL, 0x000fe400078ef802ULL, 0x0ffffff806067812ULL, 0x000fe400078ef811ULL,
0x0000000702107812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x100fe400078e0203ULL,
0x0000001006067824ULL, 0x000fc600078e0203ULL, 0x00a0000004087984ULL, 0x000f280000000c00ULL,
0x00a00000060c7984ULL, 0x0023620000000c00ULL, 0x0000000807037824ULL, 0x044fe400078e00ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x008fe4000f8e023fULL,
0xfffffff803007812ULL, 0x000fc400078ee200ULL, 0xfffffff807057812ULL, 0x000fe400078ee205ULL,
0x0000000400007c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000405057c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000711067812ULL, 0x002fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0000027a11ULL, 0x000fe200078048ffULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x000fc400078248ffULL, 0x00005b0000037a11ULL, 0x000fe400000f4c03ULL,
0x1ffffff810007812ULL, 0x100fe400078ef81aULL, 0x00005b0005057a11ULL, 0x000fe400008f4c07ULL,
0x1ffffff806067812ULL, 0x000fe200078ef81aULL, 0x0000001000027825ULL, 0x000fc800078e0002ULL,
0x0000001006047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff047624ULL, 0x000fe400078e00ffULL, 0x00006700ff057624ULL, 0x000fca00078e00ffULL,
0x0000000604287981ULL, 0x000362000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000118067810ULL, 0x000fe20007ffe0ffULL, 0x000000021b1b7824ULL, 0x000fe200078e00ffULL,
0x01060000ff047f8cULL, 0x002e62000c80043fULL, 0x00000040001a7824ULL, 0x000fe200078e00ffULL,
0x000000190600720cULL, 0x000fe20003f06070ULL, 0x000058001b1b7a24ULL, 0x000fe400078e0211ULL,
0x0000010018127824ULL, 0x000fc800078e021aULL, 0x000062001b217a24ULL, 0x000fcc00078e0212ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff177819ULL, 0x000fe20000011602ULL,
0x00000100ff1d7424ULL, 0x000fe200078e00ffULL, 0x00000012030a7217ULL, 0x000fe40007800000ULL,
0x0000000817107810ULL, 0x040fe20007ffe0ffULL, 0x0000000117067824ULL, 0x140fe200078e0221ULL,
0x00000010171e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010a127824ULL, 0x000fe200078e0a12ULL,
0x00000018171f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110087824ULL, 0x000fe200078e0221ULL,
0x000000300d1c7812ULL, 0x000fe200078ec0ffULL, 0x00005e0006067625ULL, 0x000fe200078e001dULL,
0x0000002017157810ULL, 0x000fc40007ffe0ffULL, 0x00000003ff137819ULL, 0x100fe20000011602ULL,
0x00005e0008087625ULL, 0x080fe200078e001dULL, 0x0000001c060e7210ULL, 0x080fe40007f1e0ffULL,
0x0000000313137812ULL, 0x100fe200078e4802ULL, 0x000000011e0b7824ULL, 0x100fe200078e0221ULL,
0x0000001c08087210ULL, 0x000fe20007f3e0ffULL, 0x000000011f0c7824ULL, 0x000fe200078e0221ULL,
0x0000200000147811ULL, 0x000fe200078e68ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e001dULL,
0x0ffffffc13027812ULL, 0x000fc400078ef802ULL, 0x0000002817167810ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x080fe200078e001dULL, 0x000000121e00720cULL, 0x080fe40003fa6070ULL,
0x000000121f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200000e0607ULL,
0x0000001c0a0a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000001c0c0c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000121067824ULL, 0x000fe200078e0215ULL,
0x000000121500720cULL, 0x080fe20003f66070ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x000000121700720cULL, 0x000fe20003f06070ULL, 0x00005e0006067625ULL, 0x000fc800078e001dULL,
0x0000000410117824ULL, 0x040fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000121000720cULL, 0x000fe20003f26070ULL, 0x0000001002027824ULL, 0x100fe200078e0214ULL,
0x0000001c06107210ULL, 0x000fe20007f5e0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc11067812ULL, 0x000fe200078ee213ULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e027faeULL, 0x0005e2000c101c46ULL,
0x000000ffff117224ULL, 0x000fe200010e0607ULL, 0x000000121600720cULL, 0x000fe20003f46070ULL,
0x0000001006067824ULL, 0x000fe200078e0214ULL, 0xfffffffc15157812ULL, 0x000fe200078ee213ULL,
0x0000000121077824ULL, 0x000fc400078e0216ULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x0000000008067faeULL, 0x0007e2000c901c46ULL, 0x0000001015157824ULL, 0x000fe200078e0214ULL,
0x0000003017027810ULL, 0x004fe40007ffe0ffULL, 0xfffffffc16167812ULL, 0x000fe400078ee213ULL,
0x000000120200720cULL, 0x000fc60003f26070ULL, 0x0000001016167824ULL, 0x000fe200078e0214ULL,
0x0000003817087810ULL, 0x008fe20007ffe0ffULL, 0x00005e0007067625ULL, 0x000fc600078e001dULL,
0x000000120800720cULL, 0x000fe20003f06070ULL, 0x000000041f127824ULL, 0x000fe200078e00ffULL,
0x0000001c060e7210ULL, 0x000fe20007fde0ffULL, 0x0000000121067824ULL, 0x040fe400078e0202ULL,
0x0000000402177824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e027812ULL, 0x000fe200078ee213ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0xfffffffc12127812ULL, 0x100fe200078ee213ULL,
0x0000000121097824ULL, 0x000fe200078e0208ULL, 0xfffffffc17177812ULL, 0x000fe200078ee213ULL,
0x0000000408087824ULL, 0x000fc400078e00ffULL, 0x00005e0006067625ULL, 0x000fc600078e001dULL,
0xfffffffc08137812ULL, 0x000fe200078ee213ULL, 0x00005e0009087625ULL, 0x000fe200078e001dULL,
0x0000001c06067210ULL, 0x000fc60007fde0ffULL, 0x0000001002027824ULL, 0x100fe400078e0214ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000001c08087210ULL, 0x000fe20007fde0ffULL,
0x0000001012127824ULL, 0x100fe200078e0214ULL, 0x000000000a027faeULL, 0x0005e2000e901c46ULL,
0x0000001017177824ULL, 0x100fe400078e0214ULL, 0x0000001013137824ULL, 0x000fe200078e0214ULL,
0x000000000c127faeULL, 0x0005e2000e101c46ULL, 0x000000ffff097224ULL, 0x000fc600030e0609ULL,
0x0000000010157faeULL, 0x0005e8000d901c46ULL, 0x000000000e167faeULL, 0x0005e8000d101c46ULL,
0x0000000006177faeULL, 0x0005e8000c901c46ULL, 0x0000000008137faeULL, 0x0005e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff087819ULL, 0x000fe20000011602ULL,
0x00000100ff237424ULL, 0x000fe200078e00ffULL, 0x0000000802097811ULL, 0x000fc400078ff0ffULL,
0x0000001002077811ULL, 0x040fe400078ff0ffULL, 0x0000002102067211ULL, 0x000fe200078ff0ffULL,
0x0000000409117824ULL, 0x000fe200078e00ffULL, 0x000000300d247812ULL, 0x000fe200078ec0ffULL,
0x0000000407127824ULL, 0x000fe200078e00ffULL, 0x0000000308157812ULL, 0x000fe200078e4802ULL,
0x0000000109087824ULL, 0x000fe200078e0221ULL, 0x00000018020a7811ULL, 0x040fe200078ff0ffULL,
0x0000000121097824ULL, 0x000fe200078e0207ULL, 0x00000020020c7811ULL, 0x000fe200078ff0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0023ULL, 0x00000028020d7811ULL, 0x000fc400078ff0ffULL,
0x00000030020f7811ULL, 0x040fe200078ff0ffULL, 0x00000001210b7824ULL, 0x040fe200078e020aULL,
0x0000003802107811ULL, 0x000fe200078ff0ffULL, 0x00000001210e7824ULL, 0x000fe200078e020cULL,
0x0ffffffc15147812ULL, 0x000fe200078ef802ULL, 0x00000001211d7824ULL, 0x000fe200078e020dULL,
0xfffffffc11027812ULL, 0x000fe200078ee215ULL, 0x00000001211f7824ULL, 0x040fe200078e020fULL,
0x0000200000227811ULL, 0x000fe200078e68ffULL, 0x0000000121217824ULL, 0x000fe400078e0210ULL,
0x00000004101c7824ULL, 0x000fe200078e00ffULL, 0x0000002406107210ULL, 0x000fe20007f1e0ffULL,
0x000000040d167824ULL, 0x000fc400078e00ffULL, 0x000000040c137824ULL, 0x000fe200078e00ffULL,
0xfffffffc120c7812ULL, 0x100fe200078ee215ULL, 0x000000040f177824ULL, 0x000fe200078e00ffULL,
0xfffffffc16127812ULL, 0x000fe200078ee215ULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0xfffffffc130f7812ULL, 0x100fe200078ee215ULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc17137812ULL, 0x000fe200078ee215ULL, 0x00005e0008067625ULL, 0x000fc600078e0023ULL,
0xfffffffc0a0d7812ULL, 0x100fe200078ee215ULL, 0x00005e0009087625ULL, 0x000fe200078e0023ULL,
0xfffffffc1c157812ULL, 0x000fc600078ee215ULL, 0x00000010121e7824ULL, 0x000fe200078e0222ULL,
0x0000002406127210ULL, 0x000fe20007f1e0ffULL, 0x00005e000b0a7625ULL, 0x000fc800078e0023ULL,
0x0000001014257824ULL, 0x100fe200078e0222ULL, 0x0000002408147210ULL, 0x000fe20007f3e0ffULL,
0x0000001013207824ULL, 0x100fe400078e0222ULL, 0x0000001002027824ULL, 0x100fe200078e0222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010257faeULL, 0x0005e2000b901c46ULL,
0x000000100c167824ULL, 0x100fe400078e0222ULL, 0x000000100d177824ULL, 0x100fe400078e0222ULL,
0x000000100f1c7824ULL, 0x000fc400078e0222ULL, 0x000000ffff137224ULL, 0x000fe200000e0607ULL,
0x000000240a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001015227824ULL, 0x000fe400078e0222ULL,
0x000000ffff157224ULL, 0x000fe200008e0609ULL, 0x0000000012027faeULL, 0x0005e2000b901c46ULL,
0x00005e000e067625ULL, 0x000fc600078e0023ULL, 0x0000000014167faeULL, 0x0005e2000b901c46ULL,
0x00005e001d087625ULL, 0x000fc800078e0023ULL, 0x00005e001f0c7625ULL, 0x000fe200078e0023ULL,
0x0000002408087210ULL, 0x000fc60007f3e0ffULL, 0x00005e00210e7625ULL, 0x000fe200078e0023ULL,
0x000000240c0c7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000002406067210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x000000240e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e060dULL,
0x000000000a177faeULL, 0x0005e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x000000ffff0f7224ULL, 0x000fc600018e060fULL, 0x00000000061c7faeULL, 0x0005e8000b901c46ULL,
0x00000000081e7faeULL, 0x0005e8000b901c46ULL, 0x000000000c207faeULL, 0x0005e8000b901c46ULL,
0x000000000e227faeULL, 0x0005e4000b901c46ULL, 0x01060400ff027984ULL, 0x004ea80000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000002ff7812ULL, 0x006fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200067305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fc800078e0202ULL,
0x0000002002057824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x1ffffffe04047812ULL, 0x000fe400078ec0ffULL, 0x000001e005057812ULL, 0x000fe400078ec0ffULL,
0x0000000104077812ULL, 0x040fe400078efcffULL, 0x0000000704067812ULL, 0x140fe400078e7802ULL,
0x0000000707077812ULL, 0x000fe400078e7802ULL, 0x0000001004107810ULL, 0x040fe20007ffe0ffULL,
0x0000000105067824ULL, 0x040fe200078e0206ULL, 0x0000001104047810ULL, 0x000fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0207ULL, 0x0000000710107812ULL, 0x000fc400078e7802ULL,
0x00000000060c7984ULL, 0x000e62000000cc00ULL, 0x0000000704047812ULL, 0x000fe400078e7802ULL,
0x0000000105107824ULL, 0x040fe200078e0210ULL, 0x0000000007087984ULL, 0x000ea4000000cc00ULL,
0x0000000105047824ULL, 0x000fe400078e0204ULL, 0x000000ffff147224ULL, 0x002fe400078e000cULL,
0x000000ffff157224ULL, 0x000fc400078e000eULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff1c7224ULL, 0x000fe400078e000dULL,
0x000000ffff1d7224ULL, 0x000fe200078e000fULL, 0x0000001406007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1f7224ULL, 0x000fca00078e000bULL,
0x0000001c07007388ULL, 0x000fe8000000cc00ULL, 0x0000000004087984ULL, 0x000e68000000cc00ULL,
0x00000000100c7984ULL, 0x000ea2000000cc00ULL, 0x000000ffff237224ULL, 0x002fe400078e000aULL,
0x000000ffff227224ULL, 0x000fc400078e0008ULL, 0x000000ffff0a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff207224ULL, 0x004fe400078e000cULL, 0x000000ffff217224ULL, 0x000fe400078e000eULL,
0x000000ffff087224ULL, 0x000fe400078e000dULL, 0x000000ffff097224ULL, 0x000fe200078e000fULL,
0x0000002010007388ULL, 0x0003e8000000cc00ULL, 0x0000000804007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01060000ff047f8cULL, 0x002fe8000c80043fULL,
0x01060400ff027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fc40007804805ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200067305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000060000735dULL, 0x004fe40003800000ULL, 0x01060400ff067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000191800720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3d80000028287820ULL, 0x020fe20000410000ULL,
0x0001068800297811ULL, 0x040fe200078e18ffULL, 0x000000ffff2c7224ULL, 0x000fe200078e00ffULL,
0xffffffff192a7810ULL, 0x000fe40007ffe0ffULL, 0x00010608002b7811ULL, 0x000fe400078e28ffULL,
0x00000100182d7824ULL, 0x000fe200078e021aULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000002d0300720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000ffff407224ULL, 0x000fe200078e002cULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x000000012e2f7810ULL, 0x000fe20007ffe0ffULL, 0x00000a9000007945ULL, 0x000fe20003800000ULL,
0x000000ffff477224ULL, 0x000fc400078e002eULL, 0x00000002ff2c7819ULL, 0x100fe2000001162fULL,
0x000000ffff2e7224ULL, 0x000fe200078e002fULL, 0x000000042f00780cULL, 0x000fc60003f06070ULL,
0x000003002c2c7a24ULL, 0x000fc800078e0218ULL, 0x000001002c317824ULL, 0x040fe200078e021aULL,
0x000000012c307810ULL, 0x000fe40007ffe0ffULL, 0x00000001402c7812ULL, 0x000fe200078e0cffULL,
0x000062001b3e7a24ULL, 0x000fe200078e0231ULL, 0x000000193000720cULL, 0x000fe40003f26070ULL,
0x000000032f307812ULL, 0x000fd600078ec0ffULL, 0x0000054000009947ULL, 0x000fea0003800000ULL,
0x00000031032f7217ULL, 0x000fe20007800000ULL, 0x00000004303c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff367819ULL, 0x002fe20000011602ULL, 0x00000002003d7824ULL, 0x000fe200078e022cULL,
0x00000003ff307819ULL, 0x100fe20000011602ULL, 0x000000012f2f7824ULL, 0x000fe200078e0a31ULL,
0x0000000836317810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000000330377812ULL, 0x000fe200078e4802ULL, 0x0000000136307824ULL, 0x140fe200078e023eULL,
0x0000002f3600720cULL, 0x080fe20003f26070ULL, 0x0000000131327824ULL, 0x040fe200078e023eULL,
0x0000002f3100720cULL, 0x040fe20003f46070ULL, 0x0000000431357824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c3c7812ULL, 0x000fe200078ee202ULL, 0x00005e0030307625ULL, 0x000fe200078e003bULL,
0x000020003d3d7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc37347812ULL, 0x000fe200078ef802ULL,
0x00005e0032327625ULL, 0x000fe200078e003bULL, 0xfffffffc35357812ULL, 0x000fe400078ee237ULL,
0x0000003036397810ULL, 0x000fe20007ffe0ffULL, 0x0000001034347824ULL, 0x000fe200078e023dULL,
0x00000038363f7810ULL, 0x000fe20007ffe0ffULL, 0x000000103c307825ULL, 0x040fe200078e0030ULL,
0x0000002f3900720cULL, 0x080fe40003fa6070ULL, 0x0000002f3f00720cULL, 0x000fe20003fc6070ULL,
0x0000001035357824ULL, 0x000fe200078e023dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030347faeULL, 0x0003e2000c901c46ULL, 0x000000103c327825ULL, 0x000fc800078e0032ULL,
0x0000000439427824ULL, 0x000fe200078e00ffULL, 0x0000000032357faeULL, 0x0005e2000d101c46ULL,
0x000000043f437824ULL, 0x000fe400078e00ffULL, 0x0000000139387824ULL, 0x100fe200078e023eULL,
0xfffffffc42427812ULL, 0x000fe200078ee237ULL, 0x000000013f3a7824ULL, 0x100fe200078e023eULL,
0x0000001036317810ULL, 0x002fe20007ffe0ffULL, 0x00005e0038387625ULL, 0x000fe200078e003bULL,
0x0000001836347810ULL, 0x040fe40007ffe0ffULL, 0x0000002f3100720cULL, 0x0c0fe20003f26070ULL,
0x0000000131307824ULL, 0x100fe200078e023eULL, 0x0000002036337810ULL, 0x004fe20007ffe0ffULL,
0x0000000134327824ULL, 0x000fe200078e023eULL, 0x0000002836357810ULL, 0x000fe20007ffe0ffULL,
0x000000103c387825ULL, 0x000fe200078e0038ULL, 0x0000002f3400720cULL, 0x000fc40003f46070ULL,
0x0000002f3300720cULL, 0x080fe20003f66070ULL, 0x0000000435417824ULL, 0x040fe200078e00ffULL,
0x0000002f3500720cULL, 0x000fe20003f86070ULL, 0x00000004312f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc43437812ULL, 0x100fe200078ee237ULL, 0x0000000434317824ULL, 0x000fe200078e00ffULL,
0xfffffffc41417812ULL, 0x100fe200078ee237ULL, 0x0000000133347824ULL, 0x100fe200078e023eULL,
0xfffffffc2f2f7812ULL, 0x100fe200078ee237ULL, 0x0000000433337824ULL, 0x000fe400078e00ffULL,
0x0000000135367824ULL, 0x000fe200078e023eULL, 0xfffffffc313e7812ULL, 0x100fe200078ee237ULL,
0x00005e0030307625ULL, 0x000fe200078e003bULL, 0xfffffffc333f7812ULL, 0x000fc600078ee237ULL,
0x00005e0032327625ULL, 0x000fc800078e003bULL, 0x00005e0034347625ULL, 0x000fc800078e003bULL,
0x00005e0036367625ULL, 0x000fc800078e003bULL, 0x00005e003a3a7625ULL, 0x000fc800078e003bULL,
0x000000103c307825ULL, 0x000fc800078e0030ULL, 0x000000103c327825ULL, 0x000fc800078e0032ULL,
0x000000103c347825ULL, 0x000fc800078e0034ULL, 0x000000103c367825ULL, 0x000fc800078e0036ULL,
0x000000103c3a7825ULL, 0x000fc800078e003aULL, 0x000000102f2f7824ULL, 0x100fe400078e023dULL,
0x000000103e3c7824ULL, 0x100fe400078e023dULL, 0x000000103f3e7824ULL, 0x100fe200078e023dULL,
0x00000000302f7faeULL, 0x0003e2000c901c46ULL, 0x00000010413f7824ULL, 0x100fe400078e023dULL,
0x0000001042417824ULL, 0x100fe200078e023dULL, 0x00000000323c7faeULL, 0x0003e2000d101c46ULL,
0x00000010433d7824ULL, 0x000fc600078e023dULL, 0x00000000343e7faeULL, 0x0003e8000d901c46ULL,
0x00000000363f7faeULL, 0x0003e8000e101c46ULL, 0x0000000038417faeULL, 0x0003e8000e901c46ULL,
0x000000003a3d7faeULL, 0x0003e2000f101c46ULL, 0x0000048000007947ULL, 0x000fea0003800000ULL,
0x0000000200327824ULL, 0x000fe200078e022cULL, 0x0000000802347811ULL, 0x002fe200078ff0ffULL,
0x00000004302f7824ULL, 0x000fe200078e00ffULL, 0x0000001002357811ULL, 0x040fe200078ff0ffULL,
0x00000100ff3f7424ULL, 0x000fe200078e00ffULL, 0x0000001802377811ULL, 0x000fe200078ff0ffULL,
0x0000000434427824ULL, 0x000fe200078e00ffULL, 0x0000002002397811ULL, 0x040fe200078ff0ffULL,
0x0000000435437824ULL, 0x000fe200078e00ffULL, 0x00000028023b7811ULL, 0x040fe200078ff0ffULL,
0x0000000437447824ULL, 0x000fe200078e00ffULL, 0x00000030023d7811ULL, 0x040fe200078ff0ffULL,
0x0000000439457824ULL, 0x000fe200078e00ffULL, 0x0000003802417811ULL, 0x000fe200078ff0ffULL,
0x000000043b497824ULL, 0x000fe200078e00ffULL, 0x00000003ff317819ULL, 0x000fe20000011602ULL,
0x000000043d4a7824ULL, 0x000fe200078e00ffULL, 0x0000200032467811ULL, 0x000fe200078e60ffULL,
0x00000004414b7824ULL, 0x000fe200078e00ffULL, 0x0000003e02307211ULL, 0x000fe200078ff0ffULL,
0x0000000134327824ULL, 0x000fe200078e023eULL, 0x0000000331337812ULL, 0x000fe200078e4802ULL,
0x0000000135347824ULL, 0x000fe200078e023eULL, 0xfffffffc2f2f7812ULL, 0x000fe200078ee202ULL,
0x0000000137367824ULL, 0x100fe200078e023eULL, 0xfffffffc42427812ULL, 0x100fe200078ee233ULL,
0x0000000139387824ULL, 0x100fe200078e023eULL, 0xfffffffc43437812ULL, 0x100fe200078ee233ULL,
0x000000013b3a7824ULL, 0x100fe200078e023eULL, 0xfffffffc44447812ULL, 0x100fe200078ee233ULL,
0x000000013d3c7824ULL, 0x100fe200078e023eULL, 0xfffffffc45457812ULL, 0x100fe200078ee233ULL,
0x00000001413e7824ULL, 0x000fe200078e023eULL, 0xfffffffc49497812ULL, 0x100fe200078ee233ULL,
0x00005e0030307625ULL, 0x000fe200078e003fULL, 0xfffffffc4a4a7812ULL, 0x000fc400078ee233ULL,
0xfffffffc4b4b7812ULL, 0x000fe200078ee233ULL, 0x00005e0034347625ULL, 0x000fe200078e003fULL,
0x0ffffffc33417812ULL, 0x000fc600078ef802ULL, 0x00005e0032327625ULL, 0x000fc800078e003fULL,
0x00005e0036367625ULL, 0x000fc800078e003fULL, 0x00005e0038387625ULL, 0x000fc800078e003fULL,
0x00005e003a3a7625ULL, 0x000fc800078e003fULL, 0x00005e003c3c7625ULL, 0x000fc800078e003fULL,
0x00005e003e3e7625ULL, 0x000fc800078e003fULL, 0x000000102f307825ULL, 0x000fc800078e0030ULL,
0x000000102f327825ULL, 0x000fc800078e0032ULL, 0x000000102f347825ULL, 0x000fc800078e0034ULL,
0x000000102f367825ULL, 0x000fc800078e0036ULL, 0x000000102f387825ULL, 0x000fc800078e0038ULL,
0x000000102f3a7825ULL, 0x000fc800078e003aULL, 0x000000102f3c7825ULL, 0x000fc800078e003cULL,
0x000000102f3e7825ULL, 0x000fc800078e003eULL, 0x0000001041487824ULL, 0x100fe400078e0246ULL,
0x00000010422f7824ULL, 0x100fe400078e0246ULL, 0x0000001043417824ULL, 0x100fe200078e0246ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030487faeULL, 0x0003e2000b901c46ULL,
0x0000001044427824ULL, 0x100fe400078e0246ULL, 0x0000001045437824ULL, 0x100fe200078e0246ULL,
0x00000000322f7faeULL, 0x0003e2000b901c46ULL, 0x0000001049447824ULL, 0x000fc400078e0246ULL,
0x000000104a457824ULL, 0x100fe200078e0246ULL, 0x0000000034417faeULL, 0x0003e2000b901c46ULL,
0x000000104b467824ULL, 0x000fc600078e0246ULL, 0x0000000036427faeULL, 0x0003e8000b901c46ULL,
0x0000000038437faeULL, 0x0003e8000b901c46ULL, 0x000000003a447faeULL, 0x0003e8000b901c46ULL,
0x000000003c457faeULL, 0x0003e8000b901c46ULL, 0x000000003e467faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002307810ULL, 0x002fe20007ffe0ffULL, 0x00000002003f7824ULL, 0x000fe200078e0240ULL,
0xfffffff8023d7812ULL, 0x000fe200078ec0ffULL, 0x00000008472f7824ULL, 0x000fe200078e00ffULL,
0xfffffff830407812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000000073d3d7812ULL, 0x000fc400078ef802ULL, 0x0000000740407812ULL, 0x000fe400078ef802ULL,
0x00000007023e7812ULL, 0x000fe400078ec0ffULL, 0x00000001ff417819ULL, 0x000fe4000001163dULL,
0x00000001ff427819ULL, 0x000fe40000011640ULL, 0x000020003f3f7811ULL, 0x000fe400078e60ffULL,
0x000000083e3e7812ULL, 0x000fc400078ef802ULL, 0x0000000341417812ULL, 0x000fe400078ec0ffULL,
0x0000000342427812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000003c41307212ULL, 0x080fe200078e3cffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000003c42347212ULL, 0x000fc600078e3cffULL, 0x000000043d307824ULL, 0x000fe400078e0230ULL,
0x0000000440347824ULL, 0x000fe400078e0234ULL, 0x0000001030307824ULL, 0x100fe400078e023fULL,
0x0000001034347824ULL, 0x000fc800078e023fULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x00000018ff387819ULL, 0x002fe20000011430ULL,
0x0001000030397824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011433ULL,
0x00000038004b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff467819ULL, 0x004fc40000011434ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x00000018ff457819ULL, 0x000fe40000011435ULL,
0x00000018ff447819ULL, 0x000fe20000011436ULL, 0x00000039004a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x002fe40000011431ULL, 0x00000018ff437819ULL, 0x000fca0000011437ULL,
0x00000038004f7306ULL, 0x0003f00000200c00ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff387819ULL, 0x002fce0000011432ULL, 0x0000003800537306ULL, 0x0003f00000200c00ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000888030387816ULL, 0x042fe200000000ffULL,
0x0000010030307824ULL, 0x000fca00078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003800497306ULL, 0x0002b00000200c00ULL, 0x00000030004c7306ULL, 0x0007220000200c00ULL,
0x0000888031387816ULL, 0x002fc400000000ffULL, 0x00005410494a7816ULL, 0x004fc6000000004aULL,
0x000000ffff307224ULL, 0x008fe400078e0038ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0001000031387824ULL, 0x040fe400078e00ffULL, 0x0000010031317824ULL, 0x000fc600078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff317819ULL, 0x000fe20000011431ULL,
0x00000030004d7306ULL, 0x0003e20000200c00ULL, 0x000054104c4b7816ULL, 0x010fce000000004bULL,
0x0000003100507306ULL, 0x0004e20000200c00ULL, 0x0000888032307816ULL, 0x002fce00000000ffULL,
0x0000003000517306ULL, 0x0003e20000200c00ULL, 0x0001000032317824ULL, 0x044fe400078e00ffULL,
0x0000010032327824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff327819ULL, 0x000fe20000011432ULL, 0x00000038004e7306ULL, 0x000ea20000200c00ULL,
0x0000888033307816ULL, 0x002fe400000000ffULL, 0x00005410504f7816ULL, 0x008fca000000004fULL,
0x0000003100527306ULL, 0x0002f00000200c00ULL, 0x0000003200547306ULL, 0x0009620000200c00ULL,
0x0001000033317824ULL, 0x002fe200078e00ffULL, 0x000054104d4e7816ULL, 0x004fe2000000004eULL,
0x0000010033337824ULL, 0x000fc600078e00ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff337819ULL, 0x000fe20000011433ULL, 0x0000003000557306ULL, 0x0003e20000200c00ULL,
0x000000013c327810ULL, 0x050fe40007ffe0ffULL, 0x0000541051527816ULL, 0x008fe40000000052ULL,
0x000000023c3c7810ULL, 0x000fe40007ffe0ffULL, 0x0000541054537816ULL, 0x020fe20000000053ULL,
0x0000003100567306ULL, 0x0004e20000200c00ULL, 0x0000888034307816ULL, 0x002fc400000000ffULL,
0x000000043c00780cULL, 0x000fca0003f25270ULL, 0x0000003300577306ULL, 0x000e620000200c00ULL,
0x0001000034317824ULL, 0x044fe400078e00ffULL, 0x0000010034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003000587306ULL, 0x0005e20000200c00ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x0000541055567816ULL, 0x008fca0000000056ULL,
0x0000003100597306ULL, 0x0007220000200c00ULL, 0x0000888035307816ULL, 0x004fe400000000ffULL,
0x0000541057577816ULL, 0x002fca0000000047ULL, 0x00000030005b7306ULL, 0x0003e20000200c00ULL,
0x0000003241317212ULL, 0x088fe400078e3cffULL, 0x0000003242327212ULL, 0x000fc600078e3cffULL,
0x000000043d337824ULL, 0x000fe400078e0231ULL, 0x0001000035317824ULL, 0x000fe200078e00ffULL,
0x0000888036307816ULL, 0x002fe200000000ffULL, 0x0000001033337824ULL, 0x000fe200078e023fULL,
0x00000034005a7306ULL, 0x0002a20000200c00ULL, 0x0000000440327824ULL, 0x000fe200078e0232ULL,
0x00000018ff317819ULL, 0x000fe20000011431ULL, 0x0000010035357824ULL, 0x000fe200078e00ffULL,
0x000000003338783bULL, 0x000ee20000000200ULL, 0x0000001032327824ULL, 0x000fe200078e023fULL,
0x0000541058587816ULL, 0x010fc40000000059ULL, 0x00000031005c7306ULL, 0x0009620000200c00ULL,
0x0000888037347816ULL, 0x002fe400000000ffULL, 0x00000018ff357819ULL, 0x000fca0000011435ULL,
0x00000030005e7306ULL, 0x000fe20000200c00ULL, 0x0001000036317824ULL, 0x010fe200078e00ffULL,
0x000054105a597816ULL, 0x004fe20000000046ULL, 0x0000010036367824ULL, 0x000fc600078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x0000003400617306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x000054105b5c7816ULL, 0x020fca000000005cULL,
0x00000031005f7306ULL, 0x0002b00000200c00ULL, 0x00000035005d7306ULL, 0x0009620000200c00ULL,
0x000000003230783bULL, 0x002e620000000200ULL, 0x00000018ff347819ULL, 0x008fc40000011438ULL,
0x000088803a6c7816ULL, 0x000fc800000000ffULL, 0x0000003400667306ULL, 0x0007e20000200c00ULL,
0x0001000037357824ULL, 0x050fe200078e00ffULL, 0x000054105e5e7816ULL, 0x004fe2000000005fULL,
0x0000010037377824ULL, 0x000fc600078e00ffULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003600607306ULL, 0x0005e20000200c00ULL, 0x00000018ff347819ULL, 0x008fe40000011439ULL,
0x00000018ff377819ULL, 0x000fe40000011437ULL, 0x000054105d5d7816ULL, 0x020fc60000000045ULL,
0x00000034006a7306ULL, 0x0007e20000200c00ULL, 0x0001000039367824ULL, 0x004fca00078e00ffULL,
0x00000018ff367819ULL, 0x000fe40000011436ULL, 0x0000003500627306ULL, 0x0005220000200c00ULL,
0x00000018ff347819ULL, 0x008fce000001143aULL, 0x00000034006e7306ULL, 0x0007e20000200c00ULL,
0x0001000038357824ULL, 0x004fe200078e00ffULL, 0x0000888032467816ULL, 0x002fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe40000011433ULL, 0x00000018ff357819ULL, 0x000fe40000011435ULL,
0x0000003700637306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x008fe4000001143bULL,
0x0000541061627816ULL, 0x010fca0000000062ULL, 0x0000003400727306ULL, 0x0003f00000200c00ULL,
0x0000003500657306ULL, 0x0005e20000200c00ULL, 0x00000018ff347819ULL, 0x002fce0000011430ULL,
0x0000003400747306ULL, 0x0003e20000200c00ULL, 0x0000888039357816ULL, 0x044fe200000000ffULL,
0x0000010039397824ULL, 0x000fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003500687306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x002fce0000011431ULL,
0x0000003400757306ULL, 0x0003f00000200c00ULL, 0x0000003600697306ULL, 0x000ea20000200c00ULL,
0x00000018ff347819ULL, 0x002fce0000011432ULL, 0x0000003400767306ULL, 0x0003f00000200c00ULL,
0x00000039006b7306ULL, 0x0007e20000200c00ULL, 0x0000888038347816ULL, 0x042fe200000000ffULL,
0x0000010038387824ULL, 0x000fe200078e00ffULL, 0x0000541068687816ULL, 0x004fca0000000069ULL,
0x0000003400647306ULL, 0x0002a20000200c00ULL, 0x000000ffff397224ULL, 0x008fe400078e006cULL,
0x000100003a6c7824ULL, 0x040fe400078e00ffULL, 0x000001003a3a7824ULL, 0x000fc600078e00ffULL,
0x00000039006d7306ULL, 0x0007e20000200c00ULL, 0x00000018ff347819ULL, 0x002fe40000011438ULL,
0x0000002f02387211ULL, 0x000fe400078fe0ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000003400677306ULL, 0x0003220000200c00ULL,
0x000088803b397816ULL, 0x008fe400000000ffULL, 0x0000541064647816ULL, 0x004fc40000000065ULL,
0x000054106b697816ULL, 0x000fe4000000006aULL, 0x000000042f2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000003a006f7306ULL, 0x0005e20000200c00ULL, 0x0000000738347812ULL, 0x042fe400078e783eULL,
0x0000000238387810ULL, 0x000fc60007ffe0ffULL, 0x000000203e347824ULL, 0x000fe200078e0234ULL,
0x0000000738387812ULL, 0x000fe200078e783eULL, 0x0000003900707306ULL, 0x0003e20000200c00ULL,
0x000100003b3a7824ULL, 0x004fe200078e00ffULL, 0x0000541067657816ULL, 0x010fe20000000066ULL,
0x0000001034347824ULL, 0x000fe400078e00ffULL, 0x000001003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x000000203e387824ULL, 0x000fe200078e0238ULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x0000888030397816ULL, 0x002fe200000000ffULL, 0x0000001038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc8000001143bULL, 0x0000003a00717306ULL, 0x0003300000200c00ULL,
0x0000003900497306ULL, 0x000be20000200c00ULL, 0x00010000303a7824ULL, 0x002fe200078e00ffULL,
0x00005410605f7816ULL, 0x004fe20000000044ULL, 0x0001000032447824ULL, 0x000fc400078e00ffULL,
0x0000010032327824ULL, 0x000fe200078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x0000010030397824ULL, 0x020fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff327819ULL, 0x000fe40000011432ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003b00737306ULL, 0x000ea20000200c00ULL,
0x0000541070707816ULL, 0x010fce0000000071ULL, 0x0000003a00307306ULL, 0x000f220000200c00ULL,
0x0000004a3404723cULL, 0x008fe20000001804ULL, 0x0000541063637816ULL, 0x002fcc0000000043ULL,
0x00008880314b7816ULL, 0x000fe200000000ffULL, 0x00000039004a7306ULL, 0x0003e20000200c00ULL,
0x0000004e3408723cULL, 0x040fe20000001808ULL, 0x0000541073717816ULL, 0x004fe40000000072ULL,
0x000000ffff477224ULL, 0x000fe400078e004bULL, 0x00010000314b7824ULL, 0x000fe200078e00ffULL,
0x0000541049307816ULL, 0x010fe20000000030ULL, 0x0000010031317824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x002e620000000200ULL, 0x00000052340c723cULL, 0x000fe2000000180cULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff317819ULL, 0x000fca0000011431ULL, 0x000000563410723cULL, 0x040fe40000001810ULL,
0x0000003100457306ULL, 0x00072c0000200c00ULL, 0x000000583414723cULL, 0x000fe40000001814ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x000000ffff317224ULL, 0x008fe200078e0046ULL,
0x000054106d6c7816ULL, 0x004fc4000000006cULL, 0x000054106f6d7816ULL, 0x000fe4000000006eULL,
0x0000005c341c723cULL, 0x040fe4000000181cULL, 0x0000003100467306ULL, 0x0005ec0000200c00ULL,
0x0000005e3420723cULL, 0x000fe40000001820ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000888033317816ULL, 0x004fca00000000ffULL, 0x000000623424723cULL, 0x000fe40000001824ULL,
0x0000003100357306ULL, 0x0005ea0000200c00ULL, 0x0001000033347824ULL, 0x040fe200078e00ffULL,
0x000000643804723cULL, 0x002fe20000001804ULL, 0x0000010033337824ULL, 0x000fe200078e00ffULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000054104a317816ULL, 0x004fc40000000074ULL,
0x00000018ff347819ULL, 0x000fe40000011434ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x000000683808723cULL, 0x040fe40000001808ULL, 0x0000004400447306ULL, 0x000eac0000200c00ULL,
0x000000303814723cULL, 0x040fe40000001814ULL, 0x0000003400347306ULL, 0x000eea0000200c00ULL,
0x0000541045317816ULL, 0x010fe20000000075ULL, 0x0000006c380c723cULL, 0x000fe2000000180cULL,
0x0000541047307816ULL, 0x002fe2000000004bULL, 0x0000003200327306ULL, 0x000e620000200c00ULL,
0x0000541046447816ULL, 0x004fca0000000044ULL, 0x000000703810723cULL, 0x000fe40000001810ULL,
0x0000003300337306ULL, 0x000ea20000200c00ULL, 0x0000541035347816ULL, 0x008fca0000000034ULL,
0x00000030381c723cULL, 0x000fe2000000181cULL, 0x0000541032457816ULL, 0x002fce0000000076ULL,
0x000000443820723cULL, 0x000fe20000001820ULL, 0x0000541033357816ULL, 0x004fce0000000048ULL,
0x000000343824723cULL, 0x000fe20000001824ULL, 0xfffff0c000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff407224ULL, 0x000fe200078e002cULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe4c000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000292e7f8cULL, 0x000fe2000c80043fULL, 0x0000001228377220ULL, 0x040fe40000410000ULL,
0x0000001328387220ULL, 0x040fe20000410000ULL, 0x0000040029307984ULL, 0x000e620000000800ULL,
0x0000001428127220ULL, 0x040fe40000410000ULL, 0x0000001528137220ULL, 0x040fe40000410000ULL,
0x0000000628317220ULL, 0x000fc40000410000ULL, 0x0000000728327220ULL, 0x040fe40000410000ULL,
0x0000000a28337220ULL, 0x040fe40000410000ULL, 0x0000000b28347220ULL, 0x040fe40000410000ULL,
0x0000000e28357220ULL, 0x040fe40000410000ULL, 0x0000001c28147220ULL, 0x040fe40000410000ULL,
0x0000001d28157220ULL, 0x000fc40000410000ULL, 0x0000000428047220ULL, 0x040fe40000410000ULL,
0x0000000528057220ULL, 0x040fe40000410000ULL, 0x0000000828087220ULL, 0x040fe40000410000ULL,
0x0000000928097220ULL, 0x040fe40000410000ULL, 0x0000000c28067220ULL, 0x040fe40000410000ULL,
0x0000000d28077220ULL, 0x000fc40000410000ULL, 0x0000000f28367220ULL, 0x040fe40000410000ULL,
0x0000001628397220ULL, 0x040fe40000410000ULL, 0x00000017283a7220ULL, 0x040fe40000410000ULL,
0x0000001e281c7220ULL, 0x040fe40000410000ULL, 0x0000001f281d7220ULL, 0x000fe20000410000ULL,
0x8000000030ff7812ULL, 0x002fe2000780482fULL, 0x00000022283b7220ULL, 0x000fc40000410000ULL,
0x00000023283c7220ULL, 0x040fe40000410000ULL, 0x0000002028167220ULL, 0x040fe40000410000ULL,
0x0000002128177220ULL, 0x040fe40000410000ULL, 0x00000024281e7220ULL, 0x040fe40000410000ULL,
0x00000025281f7220ULL, 0x040fe40000410000ULL, 0x00000026283d7220ULL, 0x000fc40000410000ULL,
0x00000027283e7220ULL, 0x000fe40000410000ULL, 0x000000ffff207224ULL, 0x000fe400078e0031ULL,
0x000000ffff217224ULL, 0x000fe400078e0032ULL, 0x000000ffff227224ULL, 0x000fe400078e0033ULL,
0x000000ffff237224ULL, 0x000fe400078e0034ULL, 0x000000ffff247224ULL, 0x000fc400078e0035ULL,
0x0000001028107220ULL, 0x040fe40000410000ULL, 0x0000001128117220ULL, 0x000fe40000410000ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0004ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0005ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0009ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0007ULL,
0x000000ffff257224ULL, 0x000fe400078e0036ULL, 0x000000ffff267224ULL, 0x000fe400078e0037ULL,
0x000000ffff277224ULL, 0x000fe400078e0038ULL, 0x000000ffff307224ULL, 0x000fc400078e0039ULL,
0x000000ffff317224ULL, 0x000fe400078e003aULL, 0x000000ffff327224ULL, 0x000fe400078e001cULL,
0x000000ffff337224ULL, 0x000fe400078e001dULL, 0x000000ffff347224ULL, 0x000fe400078e003bULL,
0x000000ffff357224ULL, 0x000fe200078e003cULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fc400078e003dULL,
0x000000ffff377224ULL, 0x000fe200078e003eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x0000040029057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780482fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004021d7824ULL, 0x000fe200078e00ffULL,
0x0000002a1800720cULL, 0x000fc80003f05270ULL, 0xfffffff01d1c7812ULL, 0x000fca00078ec0ffULL,
0x00000080001c7824ULL, 0x000fca00078e021cULL, 0x010400001c047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202087824ULL, 0x000fe400078e00ffULL,
0x00000001032d7824ULL, 0x000fc600078e0a2dULL, 0x0000000608087812ULL, 0x000fc800078ec0ffULL,
0x0000000108097812ULL, 0x040fe400078efcffULL, 0x00000008082e7812ULL, 0x040fe400078efcffULL,
0x0000002d0900720cULL, 0x080fe40003f26070ULL, 0x0000001008097812ULL, 0x000fe400078efcffULL,
0x0000002d2e00720cULL, 0x080fe40003f06070ULL, 0x0000002d0900720cULL, 0x000fc40003fc6070ULL,
0x00000011082e7812ULL, 0x040fe400078efcffULL, 0x0000001808097812ULL, 0x040fe400078efcffULL,
0x0000002d0800720cULL, 0x080fe40003f46070ULL, 0x0000002d2e00720cULL, 0x080fe40003fa6070ULL,
0x0000002d0900720cULL, 0x000fe40003f66070ULL, 0x00000009082f7812ULL, 0x000fc400078efcffULL,
0x00000019082e7812ULL, 0x040fe400078efcffULL, 0x0000002008097812ULL, 0x000fe400078efcffULL,
0xff7fffff20207808ULL, 0x000fe40005000000ULL, 0xff7fffff0a0a7808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40004800000ULL, 0xff7fffff0b0b7808ULL, 0x000fc40004800000ULL,
0x0000002d2f00720cULL, 0x080fe40003f86070ULL, 0x0000002d2e00720cULL, 0x080fe40003f46070ULL,
0x0000002d0900720cULL, 0x000fe40003f26070ULL, 0x00000021082e7812ULL, 0x040fe400078efcffULL,
0x0000002808097812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fc40004000000ULL,
0xff7fffff0c0c7808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40006000000ULL, 0x0000002d2e00720cULL, 0x080fe40003f06070ULL,
0x0000002d0900720cULL, 0x000fe40003f86070ULL, 0x00000029082e7812ULL, 0x000fc400078efcffULL,
0x0000003008097812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40006800000ULL, 0x0000002d2e00720cULL, 0x000fc40003fc6070ULL,
0x0000002d0900720cULL, 0x000fe40003fa6070ULL, 0x00000031082e7812ULL, 0x040fe400078efcffULL,
0x0000003808097812ULL, 0x040fe400078efcffULL, 0x0000003908087812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005800000ULL,
0xff7fffff27277808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40005000000ULL,
0xff7fffff30307808ULL, 0x000fe40004800000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0x0000002d2e00720cULL, 0x080fe40003f66070ULL, 0x0000002d0900720cULL, 0x000fc40003f46070ULL,
0x0000002d0800720cULL, 0x000fe40003f26070ULL, 0xff7fffff31317808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff32327808ULL, 0x000fe40006000000ULL,
0xff7fffff14147808ULL, 0x000fe40006000000ULL, 0xff7fffff33337808ULL, 0x000fc40007000000ULL,
0xff7fffff15157808ULL, 0x000fe40007000000ULL, 0xff7fffff34347808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff35357808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fe40005800000ULL, 0xff7fffff36367808ULL, 0x000fc40005000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff37377808ULL, 0x000fe40004800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40004800000ULL, 0x0000000a04047209ULL, 0x004fe40007810000ULL,
0x0000002005057209ULL, 0x000fe40007810000ULL, 0x0000000b04047209ULL, 0x000fe40007810000ULL,
0x0000002105057209ULL, 0x000fc40007810000ULL, 0x0000000c04047209ULL, 0x000fe40007810000ULL,
0x0000002205057209ULL, 0x000fe40007810000ULL, 0x0000000d04047209ULL, 0x000fe40007810000ULL,
0x0000002305057209ULL, 0x000fe40007810000ULL, 0x0000000e04047209ULL, 0x000fe40007810000ULL,
0x0000002405057209ULL, 0x000fc40007810000ULL, 0x0000000f04047209ULL, 0x000fe40007810000ULL,
0x0000002505057209ULL, 0x000fe40007810000ULL, 0x0000001004047209ULL, 0x000fe40007810000ULL,
0x0000002605057209ULL, 0x000fe40007810000ULL, 0x0000001104047209ULL, 0x000fe40007810000ULL,
0x0000002705057209ULL, 0x000fc40007810000ULL, 0x0000001204047209ULL, 0x000fe40007810000ULL,
0x0000003005057209ULL, 0x000fe40007810000ULL, 0x0000001304047209ULL, 0x000fe40007810000ULL,
0x0000003105057209ULL, 0x000fe40007810000ULL, 0x0000001404047209ULL, 0x000fe40007810000ULL,
0x0000003205057209ULL, 0x000fc40007810000ULL, 0x0000001504047209ULL, 0x000fe40007810000ULL,
0x0000003305057209ULL, 0x000fe40007810000ULL, 0x0000001604047209ULL, 0x000fe40007810000ULL,
0x0000003405057209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x0000003505057209ULL, 0x000fc40007810000ULL, 0x0000001e04047209ULL, 0x000fe40007810000ULL,
0x0000003605057209ULL, 0x000fe40007810000ULL, 0x0000001f042d7209ULL, 0x000fe40007810000ULL,
0x0000003705057209ULL, 0x000fe20007810000ULL, 0x00001ca27f007947ULL, 0x000fea000b800000ULL,
0x0c401f002d047f89ULL, 0x0004e400000e0000ULL, 0x000000042d2f7209ULL, 0x008fe20007810000ULL,
0x00001cf27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006087f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007097f89ULL, 0x000f6200000e0000ULL,
0x0000000405057209ULL, 0x008fc60007810000ULL, 0x0c201f002f047f89ULL, 0x000ee200000e0000ULL,
0x0000000806067209ULL, 0x010fc60007810000ULL, 0x0c201f0005087f89ULL, 0x000f2200000e0000ULL,
0x0000000907077209ULL, 0x020fc60007810000ULL, 0x0c201f00062d7f89ULL, 0x004ea800000e0000ULL,
0x0c201f00072e7f89ULL, 0x00026200000e0000ULL, 0x000000042f047209ULL, 0x008fe40007810000ULL,
0x0000000805057209ULL, 0x010fe40007810000ULL, 0x0000002d06067209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b052d7820ULL, 0x000fe20000410000ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010808ULL, 0x000000072e077209ULL, 0x006fe20007810000ULL,
0x3fb8aa3b0b0b7823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010808ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b22227823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b20207823ULL, 0x000fe2000001082dULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b10107823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010808ULL, 0x0000000c000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b14147823ULL, 0x000fc40000010808ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b1f087823ULL, 0x000fe20000010808ULL, 0x0000002000097308ULL, 0x000fe20000000800ULL,
0x3c003c00ff387424ULL, 0x000fc400078e00ffULL, 0x3c003c00ff397424ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b30307823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001082dULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001082dULL,
0x0000002300237308ULL, 0x000ea20000000800ULL, 0x000000092109723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b36367823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b372d7823ULL, 0x000fc8000001082dULL,
0x00000008001f7308ULL, 0x0003f00000000800ULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000a0b08723eULL, 0x002fe400000000ffULL, 0x0000000c0d0a723eULL, 0x000fc400000000ffULL,
0x00000022230b723eULL, 0x004fc600000000ffULL, 0x0000000f000f7308ULL, 0x000e680000000800ULL,
0x000000380820723cULL, 0x000fe800000018ffULL, 0x0000001000107308ULL, 0x000ff00000000800ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000e0f0c723eULL, 0x002fce00000000ffULL,
0x0000002400247308ULL, 0x000ff00000000800ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x00000010110e723eULL, 0x004fce00000000ffULL, 0x0000002600267308ULL, 0x000ff00000000800ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x00000024250d723eULL, 0x002fe200000000ffULL,
0x0000000fff247424ULL, 0x000fcc00078e00ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x00000026270f723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x000000380c20723cULL, 0x000fee0000001820ULL, 0x0000001400147308ULL, 0x000ff00000000800ULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x000000121310723eULL, 0x002fce00000000ffULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x000000141512723eULL, 0x004fe400000000ffULL, 0xfffffffc02147812ULL, 0x000fc800078ec0ffULL,
0x0000001424247219ULL, 0x000fe200000006ffULL, 0x0000003200327308ULL, 0x000fe60000000800ULL,
0x00000000242573a1ULL, 0x000ea200000e8000ULL, 0x00000000240473c4ULL, 0x000ee80000004000ULL,
0x0000003300337308ULL, 0x000f220000000800ULL, 0x000000303111723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000fe20000000800ULL, 0x000000323313723eULL, 0x010fce00000000ffULL,
0x0000001700177308ULL, 0x000e620000000800ULL, 0x0000000524ff7c12ULL, 0x004fe2000f804025ULL,
0x000000381020723cULL, 0x000fec0000001820ULL, 0x0000001e001e7308ULL, 0x000eb00000000800ULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000161714723eULL, 0x002fce00000000ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x0000001e1f16723eULL, 0x004fce00000000ffULL,
0x0000003600367308ULL, 0x000ff00000000800ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x000000343515723eULL, 0x002fe400000000ffULL, 0x000000362d17723eULL, 0x004fce00000000ffULL,
0x000000381420723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000190204008947ULL, 0x008fde000b800000ULL, 0x001c1fff20207589ULL, 0x0002a400000e0000ULL,
0x00000000241e73a1ULL, 0x000ee200000e8000ULL, 0x00000000240473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x0000000524ff7c12ULL, 0x008fda000f80401eULL,
0x0000192204008947ULL, 0x010fea000b800000ULL, 0x001c1fff22217589ULL, 0x00072800000e0000ULL,
0x001c1fff22227589ULL, 0x00066800000e0000ULL, 0x001c1fff23237589ULL, 0x0006a400000e0000ULL,
0x00000002ff1e7819ULL, 0x000fe40000011602ULL, 0x0000000c1d367812ULL, 0x000fc400078ec0ffULL,
0x000000071e1f7812ULL, 0x040fe200078ec0ffULL, 0x000000081e247824ULL, 0x04afe200078e00ffULL,
0x0000001eff317212ULL, 0x000fe200078e33ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x000000081e327824ULL, 0x040fe200078e00ffULL,
0x000000081e1e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824247812ULL, 0x100fe400078ee21fULL,
0x0000000125267812ULL, 0x140fe200078ef61fULL, 0x000000081e3a7824ULL, 0x040fe200078e00ffULL,
0x0000000225277812ULL, 0x140fe200078ef61fULL, 0x000000081e337824ULL, 0x000fe200078e00ffULL,
0x00000003252d7812ULL, 0x000fc400078ef61fULL, 0x00000004252e7812ULL, 0x140fe400078ef61fULL,
0x00000005252f7812ULL, 0x140fe400078ef61fULL, 0x0000000625307812ULL, 0x000fe200078ef61fULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0xfffffff832317812ULL, 0x000fe400078ee231ULL,
0x0000001eff327212ULL, 0x000fe400078e33ffULL, 0x000000071e1f7812ULL, 0x000fc400078ec0ffULL,
0x0000a000001e7811ULL, 0x000fe400078e58ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee232ULL,
0xfffffff833327812ULL, 0x100fe200078ee21fULL, 0x00000010241d7824ULL, 0x100fe200078e021eULL,
0x0000000125337812ULL, 0x100fe200078ef61fULL, 0x0000001027247824ULL, 0x100fe200078e021eULL,
0x0000000225347812ULL, 0x040fe200078ef61fULL, 0x00000001361d7824ULL, 0x040fe200078e021dULL,
0x0000000325357812ULL, 0x100fe200078ef61fULL, 0x000000102f277824ULL, 0x000fe200078e021eULL,
0x0000000425377812ULL, 0x140fe200078ef61fULL, 0x0000000136247824ULL, 0x000fe200078e0224ULL,
0x0000000525387812ULL, 0x140fe200078ef61fULL, 0x00000010322f7824ULL, 0x100fe200078e021eULL,
0x0000000625397812ULL, 0x000fe200078ef61fULL, 0x00000010261f7824ULL, 0x100fe200078e021eULL,
0x000000081d007388ULL, 0x0003e20000000800ULL, 0x000000102d257824ULL, 0x000fc400078e021eULL,
0x000000102e267824ULL, 0x100fe400078e021eULL, 0x00000001361f7824ULL, 0x000fe400078e021fULL,
0x00000010302d7824ULL, 0x100fe400078e021eULL, 0x00000010312e7824ULL, 0x000fe200078e021eULL,
0x0000000a1f007388ULL, 0x0003e20000000800ULL, 0x0000000136257824ULL, 0x040fe400078e0225ULL,
0x0000000136267824ULL, 0x000fe200078e0226ULL, 0x0000000c24007388ULL, 0x0003e20000000800ULL,
0x0000001033307824ULL, 0x000fc400078e021eULL, 0x0000000136277824ULL, 0x000fe200078e0227ULL,
0x0000000e25007388ULL, 0x0003e20000000800ULL, 0x0000001034317824ULL, 0x100fe400078e021eULL,
0x00000001362d7824ULL, 0x040fe200078e022dULL, 0x0000001026007388ULL, 0x0003e20000000800ULL,
0x0000001035327824ULL, 0x000fe400078e021eULL, 0x00000001362e7824ULL, 0x000fe200078e022eULL,
0x0000001227007388ULL, 0x0003e20000000800ULL, 0x0000001037337824ULL, 0x000fc400078e021eULL,
0x00000001362f7824ULL, 0x000fe200078e022fULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x0000001038347824ULL, 0x000fe400078e021eULL, 0x0000000136307824ULL, 0x040fe200078e0230ULL,
0x000000162e007388ULL, 0x0003e20000000800ULL, 0x0000001039357824ULL, 0x100fe400078e021eULL,
0x0000000136317824ULL, 0x000fe200078e0231ULL, 0x000000092f007388ULL, 0x0003e20000000800ULL,
0x000000103a1e7824ULL, 0x000fc400078e021eULL, 0x0000000136327824ULL, 0x040fe200078e0232ULL,
0x0000000b30007388ULL, 0x0003e20000000800ULL, 0x0000000136337824ULL, 0x040fe400078e0233ULL,
0x0000000136347824ULL, 0x040fe200078e0234ULL, 0x0000000d31007388ULL, 0x0003e20000000800ULL,
0x0000000136357824ULL, 0x040fe400078e0235ULL, 0x00000001361e7824ULL, 0x000fe200078e021eULL,
0x0000000f32007388ULL, 0x0003e80000000800ULL, 0x0000001133007388ULL, 0x0003e80000000800ULL,
0x0000001334007388ULL, 0x0003e80000000800ULL, 0x0000001535007388ULL, 0x0003e80000000800ULL,
0x000000171e007388ULL, 0x0003e80000000800ULL, 0x010000041c008388ULL, 0x0003e80000000c00ULL,
0x010200201c008388ULL, 0x0143e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008002bff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010002bff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000030018187a10ULL, 0x000fe20007ffe0ffULL, 0x000018002bff7f8cULL, 0x0003e6000c80043fULL,
0x000000191800720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc99000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x008fe20004800000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x0001526000117802ULL, 0x000fe40000000f00ULL, 0x0000152000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0042ULL, 0xfffec28000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004800000ULL, 0xffffffffff427424ULL, 0x000fe200078e00ffULL,
0x000152c000117802ULL, 0x000fe40000000f00ULL, 0x000014c000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0042ULL, 0xfffec2a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x008fe200078e001cULL, 0x00015340005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0010ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000013f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0058ULL, 0xfffec2c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0010ULL, 0x000153c0005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e001cULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000137000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0058ULL, 0xfffec27000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00015440005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fc400078e0034ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000012f000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff617224ULL, 0x004fe200078e0058ULL, 0xfffec5d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x000154c0005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0032ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000127000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff607224ULL, 0x004fe200078e0058ULL, 0xfffec58000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0004ULL, 0x00015530005b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fc400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000120000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff657224ULL, 0x004fe200078e0058ULL,
0xfffedbf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0004ULL,
0x000155b0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fe400078e0032ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000118000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0058ULL,
0xfffedb9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x0001561000117802ULL, 0x000fc40000000f00ULL,
0x0000117000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xfffef1b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x0001567000117802ULL, 0x000fc40000000f00ULL,
0x0000111000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xfffef1d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x004fe200078e0058ULL,
0x000156e0005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000105000007944ULL, 0x012fea0003c00000ULL,
0xfffef22000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0032ULL,
0x00015740005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000ff000007944ULL, 0x012fea0003c00000ULL,
0xfffef2e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x000157a0005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000f9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e0058ULL, 0xfffef53000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00015820005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x004fc400078e0032ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000f1000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff647224ULL, 0x004fe200078e0058ULL, 0xfffef4d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0008ULL, 0x00015890005b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x00000ea000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff657224ULL, 0x004fe200078e0058ULL,
0xffff097000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0008ULL,
0x00015910005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fc400078e0032ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x00000e2000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0058ULL,
0xffff091000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x0001597000117802ULL, 0x000fe40000000f00ULL,
0x00000e1000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xffff1ea000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x000159d000117802ULL, 0x000fe40000000f00ULL,
0x00000db000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xffff1ec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x004fe200078e0058ULL,
0x00015a40005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000cf000007944ULL, 0x012fea0003c00000ULL,
0xffff1f1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x000fe200078e0032ULL,
0x00015aa0005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000c9000007944ULL, 0x012fea0003c00000ULL,
0xffff1fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x00015b00005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000c3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff657224ULL, 0x004fe200078e0058ULL, 0xffff222000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00015b80005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x004fc400078e0032ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x00000bb000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff647224ULL, 0x004fe200078e0058ULL, 0xffff21c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0008ULL, 0x00015bf0005b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x00000b4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff657224ULL, 0x004fe200078e0058ULL,
0xffff366000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0008ULL,
0x00015c70005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x002fc400078e0032ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x00000ac000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff647224ULL, 0x004fe200078e0058ULL,
0xffff360000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x008fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x00015cd000117802ULL, 0x000fe40000000f00ULL,
0x00000ab000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xffff4b9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004800000ULL,
0xffffffffff427424ULL, 0x000fe200078e00ffULL, 0x00015d3000117802ULL, 0x000fe40000000f00ULL,
0x00000a5000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0042ULL,
0xffff4bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff5a7224ULL, 0x002fe200078e0058ULL,
0x00015db0005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff597224ULL, 0x000fc400078e0011ULL,
0x0000001fff437424ULL, 0x000fe400078e00ffULL, 0xffffffffff427424ULL, 0x000fe400078e00ffULL,
0x0000098000007944ULL, 0x014fea0003c00000ULL, 0xffff4bf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0011ULL, 0x00015e20005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0032ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000091000007944ULL, 0x012fea0003c00000ULL,
0xffff4ca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0010ULL,
0x00015e80005b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff437424ULL, 0x000fc400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000008b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff627224ULL, 0x004fe200078e0058ULL, 0xffff4ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff597224ULL, 0x000fe200078e0010ULL, 0x00015f00005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff5a7224ULL, 0x008fe400078e0032ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff417224ULL, 0x004fe200078e0058ULL, 0xffff4e9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0035ULL, 0x00015f80005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fc400078e0024ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x000007b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff357224ULL, 0x004fe200078e0058ULL, 0xffff634000007947ULL, 0x000fea000383ffffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0032ULL, 0x00016000005b7802ULL, 0x000fe20000000f00ULL,
0x000000ffff597224ULL, 0x000fe400078e0024ULL, 0x0000001fff437424ULL, 0x000fe400078e00ffULL,
0xffffffffff427424ULL, 0x000fe400078e00ffULL, 0x0000073000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff367224ULL, 0x004fe200078e0058ULL, 0xffff62e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e002dULL, 0x0001608000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002eULL, 0xffffe2f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x0001610000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x000005e000007944ULL, 0x006fea0003c00000ULL,
0x0000002e05057209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001617000097802ULL, 0x000fe20000000f00ULL, 0x00000002ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x0000057000007944ULL, 0x000fea0003c00000ULL, 0x0000002e06067209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x000161e000097802ULL, 0x000fe20000000f00ULL,
0x00000002ff2e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x0000002e07077209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e002fULL,
0x0001625000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x0000049000007944ULL, 0x000fea0003c00000ULL, 0x0000002e2f047209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0005ULL, 0x000162c000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000002e05057209ULL, 0x004fe20007810000ULL, 0x000000ffff087224ULL, 0x000fe200078e0006ULL,
0x0001633000097802ULL, 0x000fe20000000f00ULL, 0x00000001ff2e7424ULL, 0x000fc400078e00ffULL,
0x0000001fff387424ULL, 0x000fe400078e00ffULL, 0xffffffffff397424ULL, 0x000fe400078e00ffULL,
0x000003b000007944ULL, 0x000fea0003c00000ULL, 0x0000002e06067209ULL, 0x004fe20007810000ULL,
0x000000ffff087224ULL, 0x000fe200078e0007ULL, 0x000163a000097802ULL, 0x000fe20000000f00ULL,
0x00000001ff2e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff397424ULL, 0x000fe400078e00ffULL, 0x0000034000007944ULL, 0x000fea0003c00000ULL,
0xffffe0d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0020ULL,
0x00016410005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff437424ULL, 0x000fe400078e00ffULL, 0x000000ffff427224ULL, 0x000fe400078e0024ULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e0058ULL,
0xffffe69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff597224ULL, 0x000fe200078e0022ULL,
0x00016490005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff437424ULL, 0x000fe400078e00ffULL, 0x000000ffff427224ULL, 0x000fe400078e0024ULL,
0x000002a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e00ffULL,
0x000164f0005b7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff437424ULL, 0x000fc400078e00ffULL,
0x000000ffff427224ULL, 0x000fe400078e0024ULL, 0x000000ffff217224ULL, 0x004fe400078e0058ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff427224ULL, 0x000fe200078e0024ULL,
0x00016550005b7802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x00001c1fff437424ULL, 0x000fe400078e00ffULL, 0x000000ffff227224ULL, 0x004fe400078e0058ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff237224ULL, 0x004fe200078e0058ULL,
0xffffe5d000007947ULL, 0x000fea000383ffffULL, 0x0180000033027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000003300028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000205ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff33ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000205ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000033057812ULL, 0x000fd600078ec0ffULL, 0x0080000005020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000003300027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe992006007950ULL, 0x000fea0003c3ffffULL,
0x0000003900007348ULL, 0x000fe80003800000ULL, 0x0c00002e082e7389ULL, 0x0002a400000e0038ULL,
0x000000ffff087224ULL, 0x002fe400078e0009ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffe98d008007950ULL, 0x000fea0003c3ffffULL, 0x0000004200007348ULL, 0x000fe80003800000ULL,
0x0000005a59587389ULL, 0x0002a400000e0043ULL, 0x000000ffff427224ULL, 0x002fe400078e005bULL,
0x00000000ff437424ULL, 0x000fc800078e00ffULL, 0xfffe988042007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f25070ULL, 0x0000004200007348ULL, 0x000fd80003800000ULL,
0x0000000000107806ULL, 0x000fc800048e0100ULL, 0x0000004210427212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffe981010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000390ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000970ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000a00ULL, 0x0000000000000b90ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001590ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015b0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015c0ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000015e0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001670ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001688ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000016880ULL, 0x9700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018100ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000018110ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000018110ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000018590ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001670ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016a90ULL, 0x0000000000016a90ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000018100ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000018590ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 99952;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
