/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016610ULL, 0x0000000000016190ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000014ac0ULL, 0x0000000000000190ULL, 0x000e002200000106ULL, 0x0000000000014c50ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000014c90ULL, 0x00000000000000f0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000014d80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00014ac000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x0052100400288080ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9e08288080820828ULL,
0x2880808508288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808085ULL,
0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00014ac000000000ULL, 0x0000019000000000ULL,
0x0000580400000000ULL, 0x8089288080820900ULL, 0x0900000004042880ULL, 0x2880808228808085ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880809908288080ULL,
0x828016288080b608ULL, 0x0000000003102880ULL, 0x8080b69200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000010800000000ULL, 0x00014c5000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL,
0x2880809908288080ULL, 0x80a808288080b608ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080a89200ULL, 0x0000001cffffffffULL, 0x0000019000000000ULL, 0x00014c9000000000ULL,
0x000000f000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x0008120400000097ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00013a4000183104ULL, 0x00013fa000013f90ULL, 0x0001407000014060ULL,
0x0108290400014080ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002d0500002dULL, 0x0500002d0500002dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000b001082804ULL, 0x00001560000000f0ULL,
0x00001680000015f0ULL, 0x00002140000016a0ULL, 0x000035a000002180ULL, 0x000044c0000035e0ULL,
0x000045b000004540ULL, 0x00004e30000045e0ULL, 0x000061d000004e70ULL, 0x0000719000006210ULL,
0x0000728000007210ULL, 0x00007b00000072b0ULL, 0x00008ea000007b40ULL, 0x00009e4000008ee0ULL,
0x00009f3000009ec0ULL, 0x0000a86000009f60ULL, 0x0000bc100000a8a0ULL, 0x0000c7d00000bc40ULL,
0x0000cf600000c7e0ULL, 0x0000edf00000ebe0ULL, 0x0000f4000000f3c0ULL, 0x000139200000fc20ULL,
0x0001396000013950ULL, 0x000139a000013970ULL, 0x000139d0000139c0ULL, 0x00014050000139e0ULL,
0x000140c0000140b0ULL, 0x000146f0000140d0ULL, 0x000147a000014750ULL, 0x00014840000147f0ULL,
0x000148e000014890ULL, 0x0001499000014930ULL, 0x00014a5000014a00ULL, 0x05e0390400014aa0ULL,
0x000000ff00000160ULL, 0x003f010000010600ULL, 0x0000000f00000190ULL, 0x003f013000010608ULL,
0x0000000f000001c0ULL, 0x003f013000010610ULL, 0x0000000f00000220ULL, 0x003f012000010648ULL,
0x000000ff00000230ULL, 0x003f010000010658ULL, 0x000000ff000005a0ULL, 0x003f010700010600ULL,
0x00000000000007d0ULL, 0x003f010200000004ULL, 0x0000000000000a90ULL, 0x003f010100000000ULL,
0x000000ff00000c50ULL, 0x003f010700010648ULL, 0x000000ff00000cd0ULL, 0x003f010100010658ULL,
0x000000ff00000e10ULL, 0x003f01060001065cULL, 0x000000ff00000e60ULL, 0x003f01060001065cULL,
0x000000ff00000ee0ULL, 0x003f01060001065cULL, 0x000000ff00001310ULL, 0x003f010700010650ULL,
0x000000ff00001380ULL, 0x003f01060001064cULL, 0x000000ff000013a0ULL, 0x003f01060001060cULL,
0x000000ff000014a0ULL, 0x003f01060001060cULL, 0x000000ff00001900ULL, 0x003f01060001064cULL,
0x000000ff000019a0ULL, 0x003f01060001064cULL, 0x000000ff00002a30ULL, 0x003f010100010658ULL,
0x000000ff00002a40ULL, 0x003f01060001065cULL, 0x000000ff00002a80ULL, 0x003f01060001065cULL,
0x000000ff00002b00ULL, 0x003f01060001065cULL, 0x000000ff00002dc0ULL, 0x003f010700010648ULL,
0x000000ff00002e30ULL, 0x003f010600010654ULL, 0x000000ff00002ea0ULL, 0x003f010600010654ULL,
0x000000ff00002f40ULL, 0x003f010600010654ULL, 0x000000ff00003ed0ULL, 0x003f010100010658ULL,
0x000000ff00003f40ULL, 0x003f010100010610ULL, 0x000000ff00003f90ULL, 0x003f01060001065cULL,
0x000000ff00003fd0ULL, 0x003f01060001065cULL, 0x000000ff00004050ULL, 0x003f01060001065cULL,
0x000000ff000042d0ULL, 0x003f010700010650ULL, 0x000000ff00004340ULL, 0x003f01060001064cULL,
0x000000ff00004360ULL, 0x003f01060001061cULL, 0x000000ff00004440ULL, 0x003f01060001061cULL,
0x000000ff00004850ULL, 0x003f01060001064cULL, 0x000000ff000048f0ULL, 0x003f01060001064cULL,
0x000000ff00005800ULL, 0x003f010100010658ULL, 0x000000ff00005810ULL, 0x003f01060001065cULL,
0x000000ff00005850ULL, 0x003f01060001065cULL, 0x000000ff000058d0ULL, 0x003f01060001065cULL,
0x000000ff00005b50ULL, 0x003f010700010648ULL, 0x000000ff00005bc0ULL, 0x003f010600010654ULL,
0x000000ff00005c10ULL, 0x003f010600010654ULL, 0x000000ff00005ca0ULL, 0x003f010600010654ULL,
0x000000ff00006ba0ULL, 0x003f010100010658ULL, 0x000000ff00006c10ULL, 0x003f010100010620ULL,
0x000000ff00006c60ULL, 0x003f01060001065cULL, 0x000000ff00006ca0ULL, 0x003f01060001065cULL,
0x000000ff00006d20ULL, 0x003f01060001065cULL, 0x000000ff00006fa0ULL, 0x003f010700010650ULL,
0x000000ff00007010ULL, 0x003f01060001064cULL, 0x000000ff00007030ULL, 0x003f01060001062cULL,
0x000000ff00007110ULL, 0x003f01060001062cULL, 0x000000ff00007520ULL, 0x003f01060001064cULL,
0x000000ff000075c0ULL, 0x003f01060001064cULL, 0x000000ff000084d0ULL, 0x003f010100010658ULL,
0x000000ff000084e0ULL, 0x003f01060001065cULL, 0x000000ff00008520ULL, 0x003f01060001065cULL,
0x000000ff000085a0ULL, 0x003f01060001065cULL, 0x000000ff00008820ULL, 0x003f010700010648ULL,
0x000000ff00008890ULL, 0x003f010600010654ULL, 0x000000ff000088e0ULL, 0x003f010600010654ULL,
0x000000ff00008970ULL, 0x003f010600010654ULL, 0x000000ff00009870ULL, 0x003f010100010658ULL,
0x000000ff000098e0ULL, 0x003f010100010630ULL, 0x000000ff00009930ULL, 0x003f01060001065cULL,
0x000000ff00009970ULL, 0x003f01060001065cULL, 0x000000ff000099f0ULL, 0x003f01060001065cULL,
0x000000ff00009c70ULL, 0x003f010700010650ULL, 0x000000ff00009ce0ULL, 0x003f01060001064cULL,
0x000000ff00009d00ULL, 0x003f01060001063cULL, 0x000000ff00009dc0ULL, 0x003f01060001063cULL,
0x000000ff0000a1d0ULL, 0x003f01060001064cULL, 0x000000ff0000a270ULL, 0x003f01060001064cULL,
0x000000ff0000b190ULL, 0x003f010100010658ULL, 0x000000ff0000b1a0ULL, 0x003f01060001065cULL,
0x000000ff0000b1e0ULL, 0x003f01060001065cULL, 0x000000ff0000b260ULL, 0x003f01060001065cULL,
0x000000ff0000b510ULL, 0x003f010700010648ULL, 0x000000ff0000b580ULL, 0x003f010600010654ULL,
0x000000ff0000b5d0ULL, 0x003f010600010654ULL, 0x000000ff0000b660ULL, 0x003f010600010654ULL,
0x000000ff0000c560ULL, 0x003f010100010658ULL, 0x000000ff0000c5c0ULL, 0x003f010100010640ULL,
0x000000ff00010c00ULL, 0x003f010600010604ULL, 0x000000ff00010c90ULL, 0x003f010600010604ULL,
0x000000ff00010fc0ULL, 0x003f010100010600ULL, 0x000000ff00010fd0ULL, 0x003f010600010604ULL,
0x000000ff00011050ULL, 0x003f010600010604ULL, 0x0000000500012db0ULL, 0x003f010600010614ULL,
0x0000000500013200ULL, 0x003f010600010614ULL, 0x0000000500014650ULL, 0x003f010100010608ULL,
0x00101c0400053803ULL, 0x000110a000010080ULL, 0x000146b000011140ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x0000000000000204ULL, 0x0000001100000002ULL, 0x000000000000017cULL,
0x0000001100000002ULL, 0x00000000000000dcULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x00000000000001e1ULL, 0x0000001100000002ULL, 0x0000000000000154ULL,
0x0000001100000002ULL, 0x00000000000000b7ULL, 0x0000001100000002ULL, 0x0000002043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000a7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000d7919ULL, 0x000ea80000002100ULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x0000000000167919ULL, 0x000f220000002600ULL,
0x000000010a007824ULL, 0x002fc800078e0203ULL, 0x00000080000f7824ULL, 0x104fe200078e020dULL,
0x00000005ff0d7819ULL, 0x000fe2000001160dULL, 0x00001fff0a007589ULL, 0x000e6200000e0000ULL,
0x0000600014107625ULL, 0x008fe400078e0011ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe40003f24070ULL, 0x000000010f00780cULL, 0x000fce0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01060002ff00b388ULL, 0x0007e20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x010608040f008388ULL, 0x0007e2000000ca00ULL,
0xff317217ff0c9424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL,
0x010610060f008388ULL, 0x0007e2000000ca00ULL, 0x000000ff0000720cULL, 0x002fe20003f05270ULL,
0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0ab424ULL, 0x000fe200078e00ffULL,
0x0104000c0f009388ULL, 0x0007e20000004800ULL, 0x7fffff80ff0bb424ULL, 0x000fc600078e00ffULL,
0x010648080f00a388ULL, 0x0007e80000008a00ULL, 0x0106580aff00b388ULL, 0x0007e80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003b000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x01ce620000000000ULL, 0x000000040d047824ULL, 0x000fc400078e00ffULL,
0x00005800ff027624ULL, 0x000fe400078e00ffULL, 0x0000001016037824ULL, 0x000fe400078e00ffULL,
0x0000001002027824ULL, 0x000fe400078e00ffULL, 0x00000200ff157424ULL, 0x000fe200078e00ffULL,
0x000000040f057211ULL, 0x002fe200078fd8ffULL, 0x0000001402047224ULL, 0x000fc600078e0203ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x00000003050b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000705027812ULL, 0x000fe400078ec0ffULL, 0x0000000707037812ULL, 0x000fe400078ec0ffULL,
0x000000070b0a7812ULL, 0x000fe400078ec0ffULL, 0x0000001f02027812ULL, 0x000fc400078e780fULL,
0x0000000205097810ULL, 0x000fe40007ffe0ffULL, 0x0000001f03067812ULL, 0x100fe200078e780fULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x0000001f0a127812ULL, 0x000fe200078e780fULL,
0x00000020050a7824ULL, 0x000fe200078e0202ULL, 0x0000000709087812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x000fe200078e0205ULL, 0x000001f003137812ULL, 0x000fe200078ec0ffULL,
0x00000020070c7824ULL, 0x000fe200078e0206ULL, 0x0000001f08087812ULL, 0x000fe200078e780fULL,
0x00005c0002027625ULL, 0x000fc800078e0015ULL, 0x0000000104057824ULL, 0x000fe200078e0207ULL,
0x0000001302027210ULL, 0x000fe20007f1e0ffULL, 0x0000000104067824ULL, 0x040fe400078e0209ULL,
0x00000001040f7824ULL, 0x000fe400078e020bULL, 0x00005c0005047625ULL, 0x000fc800078e0015ULL,
0x00000020090e7824ULL, 0x000fe200078e0208ULL, 0x0000001304047210ULL, 0x000fe20007f3e0ffULL,
0x00005c0006067625ULL, 0x000fc800078e0015ULL, 0x00005c000f087625ULL, 0x000fc800078e0015ULL,
0x000000ffff037224ULL, 0x000fe200000e0603ULL, 0x0000001306067210ULL, 0x080fe20007f1e0ffULL,
0x000000200b127824ULL, 0x000fe200078e0212ULL, 0x0000001308087210ULL, 0x000fe20007f5e0ffULL,
0x000000100a0b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100c0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400000e0607ULL,
0x000000100e137824ULL, 0x000fe200078e00ffULL, 0x00000000040f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fe400010e0609ULL, 0x0000001012157824ULL, 0x000fe200078e00ffULL,
0x0000000006137faeULL, 0x0003e8000b901c46ULL, 0x0000000008157faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01060000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006100c7981ULL, 0x01cea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x00000004ff0e7e24ULL, 0x008fe2000f8e00ffULL, 0x000000ff0c0b7810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff0b7819ULL, 0x000fce000001160bULL, 0x0000fa1000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0x000001000e027824ULL, 0x000fe200078e00ffULL,
0x0000580016007a10ULL, 0x000fe20007ffe0ffULL, 0x0000000214097824ULL, 0x000fe200078e00ffULL,
0x000000010e047810ULL, 0x000fe20007ffe0ffULL, 0x00000003ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000020c037217ULL, 0x000fe20007800000ULL, 0x0000580009097a24ULL, 0x000fe200078e0200ULL,
0x0000000b0400720cULL, 0x000fe20003f06070ULL, 0x000000080d087824ULL, 0x040fe200078e00ffULL,
0x000106100d007811ULL, 0x000fe200078e20ffULL, 0x0000000103037824ULL, 0x000fe200078e0a02ULL,
0x00000004ff067819ULL, 0x002fe2000001160aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000108077824ULL, 0x000fe200078e0206ULL, 0x0000002003037807ULL, 0x000fe20000000000ULL,
0x0000620009047a24ULL, 0x000fe200078e0202ULL, 0x0000040f00ff738cULL, 0x0003e20000000000ULL,
0x00000100ff187424ULL, 0x000fe200078e00ffULL, 0x0000000707057812ULL, 0x000fe200078ec0ffULL,
0x000000100a177824ULL, 0x000fe200078e00ffULL, 0x0000000803037217ULL, 0x000fc40007800000ULL,
0x0000000f05027812ULL, 0x000fe400078e780aULL, 0x0000000206107810ULL, 0x040fe20007ffe0ffULL,
0x0000000103057824ULL, 0x000fe200078e0a08ULL, 0x0000000406117810ULL, 0x000fe20007ffe0ffULL,
0x00000010070f7824ULL, 0x002fe200078e0202ULL, 0x000000f017177812ULL, 0x000fe200078ec0ffULL,
0x0000000104027824ULL, 0x000fe200078e0207ULL, 0x000000050600720cULL, 0x080fe20003f66070ULL,
0x0000000108077824ULL, 0x000fe200078e0210ULL, 0x0000000606067810ULL, 0x000fe20007ffe0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0018ULL, 0x000000051000720cULL, 0x000fc40003f46070ULL,
0x000000051100720cULL, 0x080fe20003f26070ULL, 0x0000000108137824ULL, 0x000fe200078e0211ULL,
0x000000050600720cULL, 0x000fe20003f06070ULL, 0x0000000108157824ULL, 0x000fe200078e0206ULL,
0x0000001702107210ULL, 0x000fe40007f9e0ffULL, 0x0000000707057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff117224ULL, 0x000fe200020e0603ULL, 0x0000000f05027812ULL, 0x000fe400078e780aULL,
0x0000000713037812ULL, 0x000fe400078ec0ffULL, 0x0000000715057812ULL, 0x000fe200078ec0ffULL,
0x0000001007127824ULL, 0x000fe200078e0202ULL, 0x0000000f03067812ULL, 0x100fe200078e780aULL,
0x0000000104027824ULL, 0x040fe200078e0207ULL, 0x0000000f05147812ULL, 0x000fe200078e780aULL,
0x0000000104057824ULL, 0x000fc400078e0213ULL, 0x0000000104077824ULL, 0x000fe400078e0215ULL,
0x0000001013137824ULL, 0x000fe400078e0206ULL, 0x0000001015167824ULL, 0x000fe400078e0214ULL,
0x00005e0002027625ULL, 0x000fc800078e0018ULL, 0x00005e0005047625ULL, 0x000fc800078e0018ULL,
0x00005e0007067625ULL, 0x000fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000001702027210ULL, 0x080fe20007f9e0ffULL, 0x0000000000ff7f8cULL, 0x0003e2000c80043fULL,
0x0000001704047210ULL, 0x080fe20007fbe0ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000001706147210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe200020e0603ULL,
0x0000c0000f0f7811ULL, 0x000fe200078e20ffULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000c00012177811ULL, 0x000fe200078e20ffULL, 0x000000ffff157224ULL, 0x000fe200030e0607ULL,
0x0000c00013197811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100f7faeULL, 0x0005e2000d901c46ULL, 0x0000c000161b7811ULL, 0x000fe200078e20ffULL,
0xff317217ff077424ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000002177faeULL, 0x0003e2000d101c46ULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000004197faeULL, 0x0003e2000c901c46ULL, 0x0000000b0e00720cULL, 0x000fe20003f26070ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000141b7faeULL, 0x0003e2000c101c46ULL, 0x0000000000107805ULL, 0x004fe2000001ff00ULL,
0x000000ffff297224ULL, 0x000fc400078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000b8d000001947ULL, 0x000fea0003800000ULL,
0x000000040d057824ULL, 0x002fe200078e00ffULL, 0x00007610ff5f7816ULL, 0x000fe2000000005fULL,
0xff317217ff077424ULL, 0x000fe200078e00ffULL, 0x00007610ff047816ULL, 0x000fe20000000004ULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x0000000205037810ULL, 0x000fc40007ffe0ffULL,
0x000001000e0f7824ULL, 0x000fca00078e00ffULL, 0x0000000c0f00720cULL, 0x000fda0003f06070ULL,
0x0000b7e000000947ULL, 0x000fea0003800000ULL, 0x01065c00ff027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000076105f027816ULL, 0x000fe20000000002ULL, 0x000000c000000947ULL, 0x000fea0003800000ULL,
0x01065c00ff0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00147305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000140000735dULL, 0x004fe40003800000ULL,
0x01065c00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fc4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000200e0f7811ULL, 0x000fe200078e40ffULL, 0x00000100ff3d7424ULL, 0x000fe200078e00ffULL,
0x00000004ff1f7819ULL, 0x000fe2000001160aULL, 0x000000100a597824ULL, 0x000fe200078e00ffULL,
0x0000000f0c167217ULL, 0x000fe20007800000ULL, 0x00006200091b7a24ULL, 0x000fe200078e020fULL,
0x000000010e147810ULL, 0x000fe20007ffe0ffULL, 0x0000000108467824ULL, 0x000fe200078e021fULL,
0x000000021f457810ULL, 0x040fe20007ffe0ffULL, 0x0000000116167824ULL, 0x000fe200078e0a0fULL,
0x0000000b1400720cULL, 0x000fe20003f06070ULL, 0x0000000146147824ULL, 0x000fe200078e021bULL,
0x000000041f437810ULL, 0x040fe20007ffe0ffULL, 0x0000000108427824ULL, 0x000fe200078e0245ULL,
0x0000002016177807ULL, 0x000fe20000000000ULL, 0x00005e0014147625ULL, 0x000fe200078e003dULL,
0x000000061f417810ULL, 0x000fc40007ffe0ffULL, 0x000000f059447812ULL, 0x000fe200078ec0ffULL,
0x0000000108407824ULL, 0x040fe200078e0243ULL, 0x00000017081d7217ULL, 0x000fe20007800000ULL,
0x0000000142167824ULL, 0x100fe200078e021bULL, 0x0000004414147210ULL, 0x000fe20007f3e0ffULL,
0x0000000140187824ULL, 0x000fe400078e021bULL, 0x00000001080f7824ULL, 0x000fe400078e0241ULL,
0x00005e0016167625ULL, 0x000fc600078e003dULL, 0x000000070f3f7812ULL, 0x000fe200078ec0ffULL,
0x00005e0018187625ULL, 0x000fe200078e003dULL, 0x0000004416167210ULL, 0x000fc60007f5e0ffULL,
0x000000011d1c7824ULL, 0x000fe200078e0a08ULL, 0x0000004418187210ULL, 0x000fe20007f7e0ffULL,
0x000000010f1b7824ULL, 0x000fe200078e021bULL, 0x00000007461d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000001c1f00720cULL, 0x000fe20003f26070ULL,
0x00005e001b1a7625ULL, 0x000fe200078e003dULL, 0x00000007421f7812ULL, 0x000fe400078ec0ffULL,
0x00000007403d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000000f1d1d7812ULL, 0x100fe200078e780aULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x0000000f1f1f7812ULL, 0x000fc400078e780aULL, 0x0000001c4500720cULL, 0x080fe20003f46070ULL,
0x0000001046507824ULL, 0x000fe200078e021dULL, 0x0000001c4300720cULL, 0x080fe20003f66070ULL,
0x00000010424f7824ULL, 0x000fe200078e021fULL, 0x0000001c4100720cULL, 0x000fe40003f86070ULL,
0x0000000f3d3d7812ULL, 0x100fe400078e780aULL, 0x0000000f3f1c7812ULL, 0x000fe400078e780aULL,
0x000000441a1a7210ULL, 0x000fe20007fbe0ffULL, 0x00000010404e7824ULL, 0x000fe200078e023dULL,
0x0000e000505d7811ULL, 0x000fe200078e20ffULL, 0x000000100f4d7824ULL, 0x000fe200078e021cULL,
0x0000e0004f5c7811ULL, 0x000fe200078e20ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e061bULL,
0x0000e0004e5b7811ULL, 0x000fe200078e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000145d7faeULL, 0x0003e2000c901c46ULL, 0x0000e0004d5a7811ULL, 0x000fc600078e20ffULL,
0x00000000165c7faeULL, 0x0003e8000d101c46ULL, 0x00000000185b7faeULL, 0x0003e8000d901c46ULL,
0x000000001a5a7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff177984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01060c00ff167984ULL, 0x000ea20000000800ULL, 0x0000ffff5f147812ULL, 0x000fc400078ec0ffULL,
0x0000ffff04157812ULL, 0x000fe400078ec0ffULL, 0x0000888014197816ULL, 0x000fe400000000ffULL,
0x0000888015577816ULL, 0x000fc600000000ffULL, 0x8000000019147824ULL, 0x000fe400078e00ffULL,
0x8000000057157824ULL, 0x000fc600078e00ffULL, 0x8000000017ff7812ULL, 0x002fe40007824814ULL,
0x8000000016ff7812ULL, 0x004fe20007844815ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fe400078e00ffULL,
0x8000000057167824ULL, 0x000fe400078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01060c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007844816ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x00000001ff147819ULL, 0x000fe2000001160aULL, 0x00000001ff657424ULL, 0x000fe200078e00ffULL,
0x0000007059597812ULL, 0x000fe400078ec0ffULL, 0x0000000c14147812ULL, 0x000fca00078ec0ffULL,
0x0000000159597824ULL, 0x000fca00078e0214ULL, 0x0100000059147984ULL, 0x000e680000000800ULL,
0x0102000059157984ULL, 0x0004e20000000800ULL, 0x000000071400720bULL, 0x002fda0003f5d000ULL,
0x0000000000167806ULL, 0x000fc800010e0100ULL, 0x0000ffff161a7812ULL, 0x000fda000784c0ffULL,
0x000003500000a947ULL, 0x000fea0003800000ULL, 0x000000071400720bULL, 0x00cfe40003f54000ULL,
0x00000014071c7209ULL, 0x000fe40007810000ULL, 0x00000002ff177819ULL, 0x000fc6000001160aULL,
0x8000001c07167221ULL, 0x000fe20000010000ULL, 0x0000000817187810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b16167820ULL, 0x000fe40000410000ULL, 0x0000000000077806ULL, 0x000fe400010e0100ULL,
0x00000016001b7308ULL, 0x000e620000000800ULL, 0x000000ff0d00720cULL, 0x000fe40003f45270ULL,
0x0000ffff07077812ULL, 0x000fc800078e3cffULL, 0x000000071aff7212ULL, 0x000fe2000786c0ffULL,
0x000000ffff077224ULL, 0x000fc600078e001cULL, 0x00000001ff657807ULL, 0x000fc60001800000ULL,
0x0104001c5900a388ULL, 0x000fe20000000800ULL, 0x0000001b06067220ULL, 0x002fc60000410000ULL,
0x00001f181b187589ULL, 0x000e6400000e0000ULL, 0x8000001c14143221ULL, 0x000fe40000010000ULL,
0x00001f171b177589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b14143820ULL, 0x000fc80000410000ULL,
0x0000001400003308ULL, 0x000ee20000000800ULL, 0x0000001813137220ULL, 0x082fe20000410000ULL,
0x0000001812127220ULL, 0x080fe20000410000ULL, 0x0000001823237220ULL, 0x080fe20000410000ULL,
0x0000001822227220ULL, 0x080fe20000410000ULL, 0x0000001827277220ULL, 0x080fe20000410000ULL,
0x0000001826267220ULL, 0x080fe20000410000ULL, 0x000000182b2b7220ULL, 0x080fe20000410000ULL,
0x000000182a2a7220ULL, 0x080fe20000410000ULL, 0x000000182f2f7220ULL, 0x080fe20000410000ULL,
0x000000182e2e7220ULL, 0x080fe20000410000ULL, 0x0000001833337220ULL, 0x080fe20000410000ULL,
0x0000001832327220ULL, 0x080fe20000410000ULL, 0x0000001837377220ULL, 0x080fe20000410000ULL,
0x0000001836367220ULL, 0x080fe20000410000ULL, 0x000000183b3b7220ULL, 0x080fe20000410000ULL,
0x000000183a3a7220ULL, 0x000fe20000410000ULL, 0x0000001711117220ULL, 0x084fe20000410000ULL,
0x0000001710107220ULL, 0x080fe20000410000ULL, 0x0000001721217220ULL, 0x080fe20000410000ULL,
0x0000001720207220ULL, 0x080fe20000410000ULL, 0x0000001725257220ULL, 0x080fe20000410000ULL,
0x0000001724247220ULL, 0x080fe20000410000ULL, 0x0000001729297220ULL, 0x080fe20000410000ULL,
0x0000001728287220ULL, 0x080fe20000410000ULL, 0x000000172d2d7220ULL, 0x080fe20000410000ULL,
0x000000172c2c7220ULL, 0x080fe20000410000ULL, 0x0000001731317220ULL, 0x080fe20000410000ULL,
0x0000001730307220ULL, 0x080fe20000410000ULL, 0x0000001735357220ULL, 0x080fe20000410000ULL,
0x0000001734347220ULL, 0x080fe20000410000ULL, 0x0000001739397220ULL, 0x080fe20000410000ULL,
0x0000001738387220ULL, 0x000fe20000410000ULL, 0x0000000015153220ULL, 0x008fc80000410000ULL,
0x0000000615067221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff147984ULL, 0x000e620000000800ULL, 0x8000000019157824ULL, 0x000fca00078e00ffULL,
0x8000000014ff7812ULL, 0x002fe20007824815ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000019167824ULL, 0x000fe400078e00ffULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01064c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007824816ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000080a157812ULL, 0x040fe400078ec0ffULL, 0x000000050a147211ULL, 0x040fe400078fe0ffULL,
0x0000000715177812ULL, 0x140fe400078ec80aULL, 0x0000000715157812ULL, 0x000fe400078ef80aULL,
0x0000001417147212ULL, 0x000fe400078e3cffULL, 0x000000030a167211ULL, 0x000fc400078fe0ffULL,
0x00000004ff557819ULL, 0x000fe2000001160aULL, 0x0000001015517824ULL, 0x000fe200078e0214ULL,
0x0000001617167212ULL, 0x000fe400078e3cffULL, 0x00000002ff797819ULL, 0x000fe4000001160aULL,
0x0000c00051587811ULL, 0x000fe200078e20ffULL, 0x00000010154c7824ULL, 0x040fe200078e0216ULL,
0x0000010015157811ULL, 0x000fc600078e20ffULL, 0x00000000581c783bULL, 0x000e620000004200ULL,
0x0000c0004c567811ULL, 0x000fe200078e20ffULL, 0x0000000114497824ULL, 0x100fe400078e0215ULL,
0x0000000116487824ULL, 0x000fe400078e0215ULL, 0x00000000563c783bULL, 0x000fe20000004200ULL,
0x0000c00049547811ULL, 0x000fe400078e20ffULL, 0x0000c00048537811ULL, 0x000fc600078e20ffULL,
0x000000005414783bULL, 0x000ea80000004200ULL, 0x000000005318783bULL, 0x000ee20000004200ULL,
0x00000018ff6f7819ULL, 0x002fe2000001141dULL, 0x000001001d4a7824ULL, 0x040fe200078e00ffULL,
0x000088801d527816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001141cULL, 0x000001001c477824ULL, 0x040fe200078e00ffULL,
0x000088801c647816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fc4000001144aULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000010014737824ULL, 0x044fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x00010000146e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe2000001141eULL,
0x0000001d00907306ULL, 0x0003e20000200c00ULL, 0x00000018ff777819ULL, 0x000fe2000001141fULL,
0x0000010015727824ULL, 0x040fe200078e00ffULL, 0x000088801e8d7816ULL, 0x000fe200000000ffULL,
0x00010000156d7824ULL, 0x000fe200078e00ffULL, 0x000088801f707816ULL, 0x000fe200000000ffULL,
0x0000010018927824ULL, 0x008fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001143cULL,
0x0000001c008f7306ULL, 0x0005e20000200c00ULL, 0x000001003d1d7824ULL, 0x002fe200078e00ffULL,
0x000088803c877816ULL, 0x000fe200000000ffULL, 0x00000100166b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011414ULL, 0x0000010017697824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x0000004a00917306ULL, 0x000e620000200c00ULL,
0x000001001e1c7824ULL, 0x004fe200078e00ffULL, 0x0000888014747816ULL, 0x000fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000000ff14723eULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d00857306ULL, 0x0005e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff667819ULL, 0x000fc40000011415ULL,
0x0000888015717816ULL, 0x000fe400000000ffULL, 0x0000991065157816ULL, 0x000fe200000000ffULL,
0x0000001c008c7306ULL, 0x0007e20000200c00ULL, 0x000001003f1d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001143dULL, 0x000000ff1500720cULL, 0x000fe40003f25270ULL,
0x00000018ff7e7819ULL, 0x000fe4000001141dULL, 0x000000070a1d7812ULL, 0x000fe200078ec0ffULL,
0x000001003c1c7824ULL, 0x048fe200078e00ffULL, 0x0000004700937306ULL, 0x0005e20000200c00ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x000000081d4a7812ULL, 0x000fc400078ef80aULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000000755557812ULL, 0x000fe400078e784aULL,
0x0000001c00867306ULL, 0x0007e20000200c00ULL, 0x000001001f477824ULL, 0x044fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x000088803d787816ULL, 0x040fe200000000ffULL, 0x000000084a557824ULL, 0x000fe200078e0255ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x000001003e1c7824ULL, 0x008fe200078e00ffULL,
0x0000001e00897306ULL, 0x000fe20000200c00ULL, 0x0000541052157816ULL, 0x002fc40000000091ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff767819ULL, 0x000fe2000001143eULL, 0x0000001f008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff757819ULL, 0x000fe4000001143fULL, 0x000088803e817816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f7b7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011418ULL,
0x0000001c00807306ULL, 0x0003e20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000888018657816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x00000047008b7306ULL, 0x0005e20000200c00ULL, 0x0000a000551c7811ULL, 0x002fe400078e20ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff627819ULL, 0x000fc40000011419ULL,
0x000000001c1c783bULL, 0x000fe20000000200ULL, 0x0000003c00837306ULL, 0x0003e20000200c00ULL,
0x0000000879477810ULL, 0x004fe40007ffe0ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff6d7819ULL, 0x000fe4000001146dULL, 0x00008880166c7816ULL, 0x000fe200000000ffULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x00005410143c7816ULL, 0x002fc40000000014ULL,
0x0000888017147816ULL, 0x000fe400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x00001f793c797589ULL, 0x000e6200000e0000ULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff5e7819ULL, 0x000fe2000001141aULL,
0x00001f473c7a7589ULL, 0x00072200000e0000ULL, 0x00000018ff927819ULL, 0x000fe40000011492ULL,
0x00000018ff607819ULL, 0x000fc40000011417ULL, 0x00000018ff617819ULL, 0x000fe20000011416ULL,
0x0000006f006f7306ULL, 0x000f620000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe4000001141bULL, 0x00008880193c7816ULL, 0x008fe400000000ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000014006a7306ULL, 0x0005e20000200c00ULL,
0x000000791c1c9232ULL, 0x002fce0000000000ULL, 0x0000003d00847306ULL, 0x0003e20000200c00ULL,
0x000000791e1e9232ULL, 0x000fe20000000000ULL, 0x0000541064147816ULL, 0x004fe20000000093ULL,
0x0000007a1d1d9232ULL, 0x090fe40000000000ULL, 0x0000007a1f1f9232ULL, 0x000fc60000000000ULL,
0x0000008d008d7306ULL, 0x000ea20000200c00ULL, 0x00000007453d7812ULL, 0x002fc600078e784aULL,
0x000000141c38723cULL, 0x000fe40000001838ULL, 0x000000084a527824ULL, 0x000fe200078e023dULL,
0x00005410903d7816ULL, 0x020fe2000000006fULL, 0x0000007000707306ULL, 0x000e660000200c00ULL,
0x0000010019147824ULL, 0x040fe200078e00ffULL, 0x0000a00052157811ULL, 0x000fe200078e20ffULL,
0x0001000019197824ULL, 0x000fc600078e00ffULL, 0x0000003c00687306ULL, 0x0007e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff197819ULL, 0x000fca0000011419ULL,
0x0000008800887306ULL, 0x000f220000200c00ULL, 0x000054108f3c7816ULL, 0x008fce000000008eULL,
0x0000007700777306ULL, 0x000ef00000200c00ULL, 0x0000003e007f7306ULL, 0x000ff00000200c00ULL,
0x0000003f007c7306ULL, 0x000bf00000200c00ULL, 0x00000014006f7306ULL, 0x0005e20000200c00ULL,
0x0000003c1c3c723cULL, 0x020fe20000001834ULL, 0x000000001534783bULL, 0x00036c0000000200ULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000054108d147816ULL, 0x004fc4000000008cULL,
0x0000541070157816ULL, 0x002fe4000000008bULL, 0x00000018ff707819ULL, 0x000fe40000011418ULL,
0x000088801a187816ULL, 0x000fe200000000ffULL, 0x0000007800787306ULL, 0x000e640000200c00ULL,
0x000000141c30723cULL, 0x000fec0000001830ULL, 0x0000008200827306ULL, 0x000ea20000200c00ULL,
0x0000541089147816ULL, 0x010fc40000000088ULL, 0x000054108a157816ULL, 0x008fca0000000077ULL,
0x0000007d007d7306ULL, 0x000ee40000200c00ULL, 0x000000141c2c723cULL, 0x040fec000000182cULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541087147816ULL, 0x000fe20000000086ULL,
0x0000007934349232ULL, 0x0a0fe20000000000ULL, 0x0000541078157816ULL, 0x002fe20000000085ULL,
0x000000ffff787224ULL, 0x000fe200078e0018ULL, 0x0000007936369232ULL, 0x000fe20000000000ULL,
0x000001001a187824ULL, 0x040fe200078e00ffULL, 0x0000007a35359232ULL, 0x080fe20000000000ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x0000007a37379232ULL, 0x000fe20000000000ULL,
0x000000141c28723cULL, 0x000fe20000001828ULL, 0x000100001a1a7824ULL, 0x000fca00078e00ffULL,
0x0000007600767306ULL, 0x000fe20000200c00ULL, 0x0000541083147816ULL, 0x004fe40000000082ULL,
0x0000541084157816ULL, 0x008fe4000000007dULL, 0x000088801b7d7816ULL, 0x000fc600000000ffULL,
0x0000007500757306ULL, 0x000e640000200c00ULL, 0x000000141c24723cULL, 0x000fec0000001824ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000018ff147819ULL, 0x000fce0000011418ULL,
0x0000007300737306ULL, 0x000ea20000200c00ULL, 0x000054107c157816ULL, 0x002fce0000000075ULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000007200727306ULL, 0x000e700000200c00ULL,
0x0000001900777306ULL, 0x0007f00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054107b197816ULL, 0x008fce000000007eULL, 0x00000014007b7306ULL, 0x0007f00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000054107f147816ULL, 0x008fce0000000076ULL,
0x0000006e006e7306ULL, 0x000ee20000200c00ULL, 0x000000141c10723cULL, 0x000fee0000001810ULL,
0x0000006d006d7306ULL, 0x000f220000200c00ULL, 0x0000541074147816ULL, 0x004fe40000000073ULL,
0x0000541071157816ULL, 0x002fca0000000072ULL, 0x0000008100817306ULL, 0x000e640000200c00ULL,
0x000000143438723cULL, 0x000fec0000001838ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000054106e147816ULL, 0x008fe40000000067ULL, 0x000054106d157816ULL, 0x010fca0000000066ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541081187816ULL, 0x002fe20000000080ULL,
0x00000014343c723cULL, 0x000fec000000183cULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x00000018ff147819ULL, 0x000fe2000001141aULL, 0x00010000171a7824ULL, 0x000fe200078e00ffULL,
0x000000181c20723cULL, 0x000fe80000001820ULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x0000006500657306ULL, 0x000fe40000200c00ULL, 0x000001001b197824ULL, 0x000fca00078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000009200647306ULL, 0x000ea20000200c00ULL,
0x000054106a157816ULL, 0x002fce0000000069ULL, 0x0000001400177306ULL, 0x0003f00000200c00ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000054106c147816ULL, 0x002fce000000006bULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000000143430723cULL, 0x000fee0000001830ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x000100001b157824ULL, 0x000fe200078e00ffULL,
0x0000541065147816ULL, 0x004fc80000000064ULL, 0x00000018ff1c7819ULL, 0x000fe40000011415ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541068157816ULL, 0x000fce000000006fULL,
0x0000007d00187306ULL, 0x000fe20000200c00ULL, 0x000000143428723cULL, 0x000fee0000001828ULL,
0x0000001900197306ULL, 0x000ee20000200c00ULL, 0x0000541070147816ULL, 0x002fe40000000063ULL,
0x0000541077157816ULL, 0x000fca0000000062ULL, 0x0000006100617306ULL, 0x000fe40000200c00ULL,
0x000000143424723cULL, 0x000fec0000001824ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541078147816ULL, 0x004fe4000000007bULL, 0x0000541018157816ULL, 0x008fca0000000019ULL,
0x0000001600167306ULL, 0x000e640000200c00ULL, 0x000000143420723cULL, 0x000fec0000001820ULL,
0x0000001a001b7306ULL, 0x000eb00000200c00ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x0000541016147816ULL, 0x002fce0000000061ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x000054101b157816ULL, 0x004fce0000000060ULL, 0x0000001c001c7306ULL, 0x000e620000200c00ULL,
0x00000014342c723cULL, 0x000fee000000182cULL, 0x0000541017147816ULL, 0x008fe4000000005eULL,
0x000054101c157816ULL, 0x002fce000000004bULL, 0x000000143434723cULL, 0x000fe20000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000400e107811ULL, 0x000fe200078e40ffULL, 0x00000100ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff197819ULL, 0x000fc4000001160aULL, 0x000000100c117217ULL, 0x000fe40007800000ULL,
0x0000c00050507811ULL, 0x000fe400078e20ffULL, 0x0000c0004f4f7811ULL, 0x000fe200078e20ffULL,
0x0000000111127824ULL, 0x100fe200078e0a10ULL, 0x0000c0004e4e7811ULL, 0x000fe200078e20ffULL,
0x0000620009117a24ULL, 0x000fe200078e0210ULL, 0x0000c0004d4d7811ULL, 0x000fe400078e20ffULL,
0x0000002012137807ULL, 0x000fe20000000000ULL, 0x0000000146167824ULL, 0x000fc400078e0211ULL,
0x0000000142147824ULL, 0x100fe200078e0211ULL, 0x0000001308137217ULL, 0x000fe20007800000ULL,
0x0000000140127824ULL, 0x000fe400078e0211ULL, 0x00005e0016167625ULL, 0x000fc800078e001bULL,
0x0000000113187824ULL, 0x000fe200078e0a08ULL, 0x0000004416167210ULL, 0x000fe20007f7e0ffULL,
0x00005e0014147625ULL, 0x000fc600078e001bULL, 0x000000181900720cULL, 0x000fe20003f46070ULL,
0x00005e0012127625ULL, 0x000fe200078e001bULL, 0x0000004414147210ULL, 0x000fc60007f9e0ffULL,
0x000000010f117824ULL, 0x000fe200078e0211ULL, 0x0000004412127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0617ULL, 0x000000184500720cULL, 0x000fe20003f66070ULL,
0x00005e0011107625ULL, 0x000fc800078e001bULL, 0x000000ffff157224ULL, 0x000fe200020e0615ULL,
0x000000184300720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000184100720cULL, 0x000fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016507faeULL, 0x0003e2000d101c46ULL, 0x0000004410107210ULL, 0x000fc60007fde0ffULL,
0x00000000144f7faeULL, 0x0003e4000d901c46ULL, 0x000000ffff117224ULL, 0x000fc800030e0611ULL,
0x00000000124e7faeULL, 0x0003e8000e101c46ULL, 0x00000000104d7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff117984ULL, 0x002e620000000800ULL,
0x0000ffff5f107812ULL, 0x000fc800078ec0ffULL, 0x0000888010127816ULL, 0x000fca00000000ffULL,
0x8000000012107824ULL, 0x000fca00078e00ffULL, 0x8000000011ff7812ULL, 0x002fe20007844810ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x01065400ff117984ULL, 0x000e620000000800ULL, 0x8000000012107824ULL, 0x000fca00078e00ffULL,
0x8000000011ff7812ULL, 0x002fe20007844810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000012117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000127305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000120000735dULL, 0x004fe40003800000ULL,
0x01065400ff127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fc40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0000e00051517811ULL, 0x000fe400078e20ffULL, 0x0000e0004c4c7811ULL, 0x000fe400078e20ffULL,
0x0000e00049497811ULL, 0x000fe200078e20ffULL, 0x000000005118783bULL, 0x000e620000004200ULL,
0x0000e00048487811ULL, 0x000fe400078e20ffULL, 0x00000002ff777819ULL, 0x000fe2000001160aULL,
0x000000004c1c783bULL, 0x000fe80000004200ULL, 0x000000004910783bULL, 0x000ea80000004200ULL,
0x000000004814783bULL, 0x000ee20000004200ULL, 0x00000018ff8d7819ULL, 0x002fe20000011418ULL,
0x00000100184b7824ULL, 0x040fe200078e00ffULL, 0x0000888018907816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011419ULL,
0x0000010019687824ULL, 0x040fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000010010727824ULL, 0x044fe200078e00ffULL, 0x0000888019677816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001141aULL,
0x00010000106d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe2000001141bULL,
0x00000018008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000010011717824ULL, 0x040fe200078e00ffULL, 0x000088801a8c7816ULL, 0x040fe200000000ffULL,
0x00010000116e7824ULL, 0x000fe200078e00ffULL, 0x000088801b6f7816ULL, 0x000fe200000000ffULL,
0x000001001f7d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001141cULL,
0x0000004b00917306ULL, 0x0005e20000200c00ULL, 0x000001001a187824ULL, 0x002fe200078e00ffULL,
0x000088801c867816ULL, 0x000fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011410ULL, 0x000100001f7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000100001e7e7824ULL, 0x000fe200078e00ffULL,
0x00000019008f7306ULL, 0x0003e20000200c00ULL, 0x000001001b4b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000888010737816ULL, 0x000fe200000000ffULL, 0x0000010013697824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fc4000001144bULL, 0x00000018008b7306ULL, 0x0005e20000200c00ULL,
0x000001001d197824ULL, 0x002fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x00000000ff10723eULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000004b008a7306ULL, 0x0003e20000200c00ULL, 0x000001001c187824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fc40000011411ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001a00887306ULL, 0x000fe20000200c00ULL, 0x00000007434b7812ULL, 0x002fe400078e784aULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000888011707816ULL, 0x000fe200000000ffULL,
0x000000084a4b7824ULL, 0x000fe200078e024bULL, 0x0000000741117812ULL, 0x000fe200078e784aULL,
0x0000001800857306ULL, 0x0003e20000200c00ULL, 0x00000018ff7c7819ULL, 0x000fc4000001141dULL,
0x000088801d797816ULL, 0x040fe200000000ffULL, 0x000000084a4a7824ULL, 0x000fe200078e0211ULL,
0x00000018ff747819ULL, 0x000fe2000001141fULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801f7a7816ULL, 0x000fe200000000ffULL, 0x0000001b00897306ULL, 0x000fe20000200c00ULL,
0x000001001e187824ULL, 0x002fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011412ULL,
0x00010000121f7824ULL, 0x040fe200078e00ffULL, 0x00008880126b7816ULL, 0x000fe400000000ffULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x0000001900847306ULL, 0x000fe20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff757819ULL, 0x000fe4000001141eULL,
0x000088801e807816ULL, 0x000fe200000000ffULL, 0x00010000131e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011413ULL, 0x00000018007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff627819ULL, 0x008fe40000011414ULL, 0x00000018ff7d7819ULL, 0x000fc4000001147dULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000001c00827306ULL, 0x0005e20000200c00ULL, 0x0000a0004b187811ULL, 0x002fe400078e20ffULL,
0x00000018ff617819ULL, 0x000fe40000011415ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x000000001818783bULL, 0x000fe20000000200ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00005410101c7816ULL, 0x004fe20000000010ULL, 0x0000010012107824ULL, 0x000fe200078e00ffULL,
0x0000888014127816ULL, 0x000fc400000000ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x00001f771c777589ULL, 0x000e6200000e0000ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x00001f471c787589ULL, 0x000ea200000e0000ULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0000006800927306ULL, 0x0007220000200c00ULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x00000018ff607819ULL, 0x000fe40000011416ULL, 0x00000018ff5e7819ULL, 0x000fc60000011417ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000888013687816ULL, 0x008fe400000000ffULL,
0x0000a0004a137811ULL, 0x000fca00078e20ffULL, 0x0000008c008c7306ULL, 0x000ee20000200c00ULL,
0x0000541067117816ULL, 0x010fe20000000092ULL, 0x000000ffff677224ULL, 0x000fe400078e0012ULL,
0x0000010014127824ULL, 0x040fe400078e00ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000007718189232ULL, 0x082fe20000000000ULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x000000771a1a9232ULL, 0x000fe40000000000ULL, 0x0000007819199232ULL, 0x084fe20000000000ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000781b1b9232ULL, 0x000fc60000000000ULL,
0x00000010006a7306ULL, 0x0005e20000200c00ULL, 0x000054108c1c7816ULL, 0x008fce000000008bULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x0000541090107816ULL, 0x004fce0000000091ULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000000101838723cULL, 0x000fee0000001838ULL,
0x000054108e107816ULL, 0x000fe2000000008dULL, 0x0000001d00837306ULL, 0x0003e20000200c00ULL,
0x000054108f117816ULL, 0x000fc4000000006cULL, 0x00000018ff6c7819ULL, 0x000fe40000011412ULL,
0x00008880158d7816ULL, 0x000fc600000000ffULL, 0x0000008600867306ULL, 0x000f220000200c00ULL,
0x000054106f1d7816ULL, 0x002fe2000000008aULL, 0x00000010183c723cULL, 0x000fe2000000183cULL,
0x000000001310783bULL, 0x000e620000000200ULL, 0x00000100158a7824ULL, 0x000fc800078e00ffULL,
0x0000007900797306ULL, 0x000f640000200c00ULL, 0x0000001c1830723cULL, 0x000fec0000001830ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00005410881c7816ULL, 0x008fe40000000087ULL,
0x00005410891d7816ULL, 0x004fc40000000076ULL, 0x00000018ff767819ULL, 0x000fc6000001148aULL,
0x0000007c007c7306ULL, 0x000ea40000200c00ULL, 0x0000001c182c723cULL, 0x000fec000000182cULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410861c7816ULL, 0x010fe40000000085ULL,
0x00005410791d7816ULL, 0x020fca0000000084ULL, 0x0000007d007d7306ULL, 0x000ee40000200c00ULL,
0x0000001c1828723cULL, 0x000fe20000001828ULL, 0x0000007710109232ULL, 0x082fe40000000000ULL,
0x0000007712129232ULL, 0x000fe40000000000ULL, 0x0000007811119232ULL, 0x080fe20000000000ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x00010000151c7824ULL, 0x000fe200078e00ffULL,
0x0000541083157816ULL, 0x004fe2000000007cULL, 0x0000007813139232ULL, 0x000fe20000000000ULL,
0x00008880167c7816ULL, 0x000fc800000000ffULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x000054107a1d7816ULL, 0x008fce000000007dULL, 0x0000007400747306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000007b007b7306ULL, 0x000ef00000200c00ULL,
0x0000001400797306ULL, 0x0009f00000200c00ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541082147816ULL, 0x010fce0000000081ULL, 0x0000007200727306ULL, 0x000f220000200c00ULL,
0x000000141824723cULL, 0x000fee0000001824ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe4000001141cULL, 0x00005410801c7816ULL, 0x002fc4000000007fULL,
0x000054107e147816ULL, 0x004fc60000000075ULL, 0x0000007100717306ULL, 0x000e640000200c00ULL,
0x0000001c1820723cULL, 0x000fec0000001820ULL, 0x00000015007a7306ULL, 0x0007e20000200c00ULL,
0x00000100161d7824ULL, 0x040fe400078e00ffULL, 0x0001000016167824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000054107b157816ULL, 0x008fe40000000074ULL, 0x00000018ff167819ULL, 0x000fca0000011416ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000141818723cULL, 0x000fee0000001834ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x0000541073147816ULL, 0x010fe40000000072ULL,
0x0000541070157816ULL, 0x002fc40000000071ULL, 0x0000888017347816ULL, 0x000fc600000000ffULL,
0x0000006e006e7306ULL, 0x000e640000200c00ULL, 0x000000141038723cULL, 0x000fe20000001838ULL,
0x000000ffff707224ULL, 0x000fca00078e0034ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000010017147824ULL, 0x000fe200078e00ffULL, 0x000054106d347816ULL, 0x004fc80000000066ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000054106e357816ULL, 0x002fce0000000065ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000000341034723cULL, 0x000fee000000183cULL, 0x0000006400647306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000541068157816ULL, 0x002fce0000000069ULL,
0x0000001f001f7306ULL, 0x000e700000200c00ULL, 0x0000001e001e7306ULL, 0x000eb00000200c00ULL,
0x00000014003d7306ULL, 0x0007f00000200c00ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x000054106b147816ULL, 0x008fce000000006aULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x000000141030723cULL, 0x000fee0000001830ULL, 0x0000008d006f7306ULL, 0x000fe20000200c00ULL,
0x0001000017157824ULL, 0x000fe200078e00ffULL, 0x000054101f147816ULL, 0x002fc80000000064ULL,
0x00000018ff3c7819ULL, 0x000fe40000011415ULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054101e157816ULL, 0x004fce0000000063ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x00000014102c723cULL, 0x000fee000000182cULL, 0x0000006100617306ULL, 0x000f220000200c00ULL,
0x0000541067147816ULL, 0x008fe4000000006cULL, 0x000054106f157816ULL, 0x002fca0000000076ULL,
0x0000007c001c7306ULL, 0x000fe40000200c00ULL, 0x000000141028723cULL, 0x000fec0000001828ULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x0000541079147816ULL, 0x004fe40000000062ULL,
0x000054107a157816ULL, 0x010fca0000000061ULL, 0x0000007000707306ULL, 0x000ea40000200c00ULL,
0x000000141024723cULL, 0x000fec0000001824ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000054101c147816ULL, 0x002fce000000001dULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541070157816ULL, 0x004fce000000003dULL, 0x0000001600177306ULL, 0x000e620000200c00ULL,
0x000000141020723cULL, 0x000fee0000001820ULL, 0x0000003c001f7306ULL, 0x000ea20000200c00ULL,
0x0000541017147816ULL, 0x002fe40000000060ULL, 0x000054101f157816ULL, 0x004fce000000005eULL,
0x000000141010723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000400e157811ULL, 0x000fe200078e40ffULL,
0x01061000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff5fff7812ULL, 0x000fe4000782c0ffULL,
0x000000150c00720cULL, 0x000fe40003f44070ULL, 0x00000001ff5f7807ULL, 0x000fd60000800000ULL,
0x000086600000a947ULL, 0x000fea0003800000ULL, 0x01065c00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01065c00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000600e147811ULL, 0x000fe200078e40ffULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x00000004ff1d7819ULL, 0x000fe4000001160aULL,
0x000000140c157217ULL, 0x000fe20007800000ULL, 0x0000620009177a24ULL, 0x000fc800078e0214ULL,
0x0000000115157824ULL, 0x000fe400078e0a14ULL, 0x0000000146147824ULL, 0x100fe400078e0217ULL,
0x0000000142187824ULL, 0x000fe200078e0217ULL, 0x0000002015197807ULL, 0x000fe20000000000ULL,
0x00005e0014147625ULL, 0x000fc600078e001fULL, 0x00000019081b7217ULL, 0x000fe20007800000ULL,
0x00005e0018187625ULL, 0x000fe200078e001fULL, 0x00000044141a7210ULL, 0x000fc60007f3e0ffULL,
0x000000011b1c7824ULL, 0x000fe200078e0a08ULL, 0x0000004418187210ULL, 0x000fe20007f7e0ffULL,
0x0000000140167824ULL, 0x100fe400078e0217ULL, 0x000000010f147824ULL, 0x000fe200078e0217ULL,
0x0000001c1d00720cULL, 0x080fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x000fe200008e0615ULL,
0x0000001c4500720cULL, 0x080fe20003f26070ULL, 0x00005e0016167625ULL, 0x000fe200078e001fULL,
0x0000001c4100720cULL, 0x000fc60003f86070ULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0x0000004416167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x0000001c4300720cULL, 0x000fe20003f66070ULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000004414147210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a5d7faeULL, 0x0003e8000d101c46ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x00000000185c7faeULL, 0x0003ea000c901c46ULL, 0x00000000165b7faeULL, 0x0003e8000d901c46ULL,
0x00000000145a7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff157984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01061c00ff167984ULL, 0x000ea20000000800ULL, 0x000000ff02ff7812ULL, 0x000fe2000782c0ffULL,
0x8000000057177824ULL, 0x000fc600078e00ffULL, 0x00000001ff5e7807ULL, 0x000fca0000800000ULL,
0x800000005e147824ULL, 0x000fca00078e00ffULL, 0x8000000015ff7812ULL, 0x002fe40007824814ULL,
0x8000000016ff7812ULL, 0x004fe20007844817ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fe400078e00ffULL,
0x8000000057167824ULL, 0x000fe400078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01061c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007844816ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x0100800059147984ULL, 0x000e620000000800ULL, 0x00000001ff677424ULL, 0x000fc600078e00ffULL,
0x0102800059157984ULL, 0x0004e20000000800ULL, 0x000000071400720bULL, 0x002fda0003f5d000ULL,
0x0000000000167806ULL, 0x000fc800010e0100ULL, 0x0000ffff16187812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000071400720bULL, 0x00cfe40003f54000ULL,
0x0000001407167209ULL, 0x000fe40007810000ULL, 0x00000002ff1a7819ULL, 0x000fc6000001160aULL,
0x8000001607177221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b17177820ULL, 0x000fe40000410000ULL,
0x0000000000077806ULL, 0x000fe400010e0100ULL, 0x000000010d00780cULL, 0x000fe40003f45270ULL,
0x0000ffff07197812ULL, 0x000fe200078e3cffULL, 0x0000001700177308ULL, 0x000e660000000800ULL,
0x0000001918ff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ff677807ULL, 0x000fc60001800000ULL,
0x010480165900a388ULL, 0x000fe80000000800ULL, 0x00001f1a17077589ULL, 0x002e6400000e0000ULL,
0x8000001614183221ULL, 0x000fe20000010000ULL, 0x0000001706067220ULL, 0x000fe20000410000ULL,
0x00001f4717147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b18183820ULL, 0x000fc80000410000ULL,
0x0000001800003308ULL, 0x000ee20000000800ULL, 0x0000000738387220ULL, 0x082fe20000410000ULL,
0x0000000739397220ULL, 0x080fe20000410000ULL, 0x0000000734347220ULL, 0x080fe20000410000ULL,
0x0000000735357220ULL, 0x080fe20000410000ULL, 0x0000000730307220ULL, 0x080fe20000410000ULL,
0x0000000731317220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000720207220ULL, 0x080fe20000410000ULL,
0x0000000721217220ULL, 0x080fe20000410000ULL, 0x0000000710107220ULL, 0x080fe20000410000ULL,
0x0000000711117220ULL, 0x000fe20000410000ULL, 0x000000143a3a7220ULL, 0x084fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fe20000410000ULL, 0x000000ffff077224ULL, 0x000fe200078e0016ULL,
0x0000001500153220ULL, 0x008fc80000410000ULL, 0x0000000615067221ULL, 0x00cfe20000010000ULL,
0x000000e000001947ULL, 0x000fea0003800000ULL, 0x01064c00ff147984ULL, 0x000e620000000800ULL,
0x800000005e157824ULL, 0x000fca00078e00ffULL, 0x8000000014ff7812ULL, 0x002fe20007824815ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fe400078e00ffULL, 0x800000005e167824ULL, 0x000fe400078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01064c00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007824816ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000005814783bULL, 0x000e620000004200ULL,
0x00000002ff797819ULL, 0x000fc6000001160aULL, 0x00000000563c783bULL, 0x000fe80000004200ULL,
0x00000000541c783bULL, 0x000ea80000004200ULL, 0x000000005318783bULL, 0x000ee20000004200ULL,
0x00000018ff8d7819ULL, 0x002fe20000011414ULL, 0x0000010014687824ULL, 0x040fe200078e00ffULL,
0x0000888014917816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011415ULL, 0x0000010015697824ULL, 0x040fe200078e00ffULL,
0x0000888015907816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000001001c727824ULL, 0x044fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x000100001c6d7824ULL, 0x000fe200078e00ffULL,
0x00000014008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000001001d717824ULL, 0x040fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe20000011416ULL,
0x000100001d6e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011417ULL,
0x000001001e6a7824ULL, 0x000fe200078e00ffULL, 0x00008880168c7816ULL, 0x040fe200000000ffULL,
0x0000006800927306ULL, 0x0005e20000200c00ULL, 0x0000010016147824ULL, 0x042fe200078e00ffULL,
0x00008880176f7816ULL, 0x000fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001143cULL, 0x000001003e7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000001003f7d7824ULL, 0x000fe200078e00ffULL,
0x00000015008f7306ULL, 0x0003e20000200c00ULL, 0x0000010017687824ULL, 0x044fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x000088803c867816ULL, 0x000fe200000000ffULL, 0x000100003e7e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001141cULL, 0x000100003f7b7824ULL, 0x000fe200078e00ffULL,
0x00000014008b7306ULL, 0x0005e20000200c00ULL, 0x000001003d157824ULL, 0x002fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fc40000011417ULL, 0x000088801c737816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001600887306ULL, 0x000fe20000200c00ULL,
0x000001003c147824ULL, 0x044fe200078e00ffULL, 0x00000000ff1c723eULL, 0x000fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x0000001700897306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff657819ULL, 0x000fe4000001141dULL,
0x000088801d707816ULL, 0x000fe200000000ffULL, 0x000001001f1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe20000011468ULL, 0x0000001400857306ULL, 0x0003e20000200c00ULL,
0x00000018ff647819ULL, 0x000fe4000001141eULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x000088801e6b7816ULL, 0x040fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001143dULL, 0x0000001500847306ULL, 0x0005e20000200c00ULL,
0x0000a80055147811ULL, 0x002fe400078e20ffULL, 0x000088803d777816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe4000001143eULL,
0x00000018ff747819ULL, 0x000fe2000001143fULL, 0x0000003c00827306ULL, 0x0003e20000200c00ULL,
0x000000001414783bULL, 0x004fe20000000200ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x000088803e807816ULL, 0x000fe200000000ffULL, 0x000100001f3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f7a7816ULL, 0x000fe400000000ffULL, 0x0000009100917306ULL, 0x000ea20000200c00ULL,
0x000054101c3c7816ULL, 0x002fe4000000001cULL, 0x00009910671c7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe2000001141eULL, 0x00001f793c797589ULL, 0x000e6200000e0000ULL,
0x000000ff1c00720cULL, 0x000fe20003f25270ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00008880181e7816ULL, 0x008fe200000000ffULL, 0x00001f473c787589ULL, 0x000ee200000e0000ULL,
0x00000018ff637819ULL, 0x000fc4000001141fULL, 0x00000018ff627819ULL, 0x000fe20000011418ULL,
0x000000ffff3f7224ULL, 0x000fe200078e001eULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000006900937306ULL, 0x000fe20000200c00ULL, 0x00005410911c7816ULL, 0x004fe20000000092ULL,
0x00000100181e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x00000018ff617819ULL, 0x000fe40000011419ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000007914149232ULL, 0x082fe20000000000ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000007916169232ULL, 0x000fe20000000000ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000007815159232ULL, 0x088fe20000000000ULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000007817179232ULL, 0x000fe20000000000ULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x00000018ff3e7819ULL, 0x000fc4000001143eULL,
0x00000018ff607819ULL, 0x000fe4000001141aULL, 0x00000018ff5f7819ULL, 0x000fc6000001141bULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x00000068008a7306ULL, 0x0004e20000200c00ULL,
0x000054108c3c7816ULL, 0x002fce000000008bULL, 0x0000001d00697306ULL, 0x0003e20000200c00ULL,
0x000088801f687816ULL, 0x004fe400000000ffULL, 0x0000a800521f7811ULL, 0x000fca00078e20ffULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x00005410901d7816ULL, 0x002fce0000000093ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000001c1438723cULL, 0x000fee0000001838ULL,
0x000054108e1c7816ULL, 0x000fe2000000008dULL, 0x0000003d00837306ULL, 0x0007e20000200c00ULL,
0x000054108f1d7816ULL, 0x000fc4000000006cULL, 0x00000018ff6c7819ULL, 0x000fe4000001141eULL,
0x00008880198d7816ULL, 0x000fc600000000ffULL, 0x0000008600867306ULL, 0x000f220000200c00ULL,
0x000054106f3d7816ULL, 0x008fe2000000008aULL, 0x0000001c1434723cULL, 0x000fe20000001834ULL,
0x000000001f1c783bULL, 0x000ee20000000200ULL, 0x00000100198a7824ULL, 0x000fc800078e00ffULL,
0x0000007700777306ULL, 0x000f640000200c00ULL, 0x0000003c1430723cULL, 0x000fec0000001830ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00005410883c7816ULL, 0x004fe40000000087ULL,
0x00005410893d7816ULL, 0x002fc40000000076ULL, 0x00000018ff767819ULL, 0x000fc6000001148aULL,
0x0000007c007c7306ULL, 0x000e640000200c00ULL, 0x0000003c142c723cULL, 0x000fec000000182cULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410863c7816ULL, 0x010fe40000000085ULL,
0x00005410773d7816ULL, 0x020fca0000000084ULL, 0x0000007d007d7306ULL, 0x000ea40000200c00ULL,
0x0000003c1428723cULL, 0x000fe20000001828ULL, 0x000000791c1c9232ULL, 0x088fe40000000000ULL,
0x000000791e1e9232ULL, 0x000fe40000000000ULL, 0x000000781d1d9232ULL, 0x080fe20000000000ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00010000193c7824ULL, 0x000fe200078e00ffULL,
0x0000541083197816ULL, 0x002fe2000000007cULL, 0x000000781f1f9232ULL, 0x000fe20000000000ULL,
0x000088801a7c7816ULL, 0x000fc800000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000054107a3d7816ULL, 0x004fce000000007dULL, 0x0000008000807306ULL, 0x000ff00000200c00ULL,
0x0000007f007f7306ULL, 0x000e700000200c00ULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000007b007b7306ULL, 0x000ef00000200c00ULL, 0x0000001800777306ULL, 0x0009f00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541082187816ULL, 0x010fce0000000081ULL,
0x0000007200727306ULL, 0x000f220000200c00ULL, 0x000000181424723cULL, 0x000fee0000001824ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff197819ULL, 0x000fe4000001143cULL,
0x00005410803c7816ULL, 0x002fc4000000007fULL, 0x000054107e187816ULL, 0x004fc60000000075ULL,
0x0000007100717306ULL, 0x000e640000200c00ULL, 0x0000003c1420723cULL, 0x000fec0000001820ULL,
0x00000019007a7306ULL, 0x0007e20000200c00ULL, 0x000001001a3d7824ULL, 0x040fe400078e00ffULL,
0x000100001a1a7824ULL, 0x000fca00078e00ffULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000054107b197816ULL, 0x008fe40000000074ULL, 0x00000018ff1a7819ULL, 0x000fca000001141aULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000000181410723cULL, 0x000fee0000001810ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x0000541073147816ULL, 0x010fe20000000072ULL,
0x000001001b187824ULL, 0x000fe200078e00ffULL, 0x0000541070157816ULL, 0x002fc40000000071ULL,
0x00000018ff177819ULL, 0x000fe4000001143dULL, 0x000088801b167816ULL, 0x000fe200000000ffULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000000141c38723cULL, 0x000fec0000001838ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000054106d147816ULL, 0x004fce0000000066ULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x000054106e157816ULL, 0x002fce0000000065ULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x000000141c34723cULL, 0x000fee0000001834ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000054106b147816ULL, 0x004fce000000006aULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541068157816ULL, 0x002fce0000000069ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000000141c30723cULL, 0x000fee0000001830ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000100001b147824ULL, 0x000fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011414ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x002fce0000000064ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000054103e157816ULL, 0x004fce0000000063ULL,
0x0000008d006f7306ULL, 0x000fe20000200c00ULL, 0x000000141c2c723cULL, 0x000fee000000182cULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054103f147816ULL, 0x002fce000000006cULL,
0x0000006200627306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x000054106f157816ULL, 0x004fce0000000076ULL, 0x0000007c003c7306ULL, 0x000fe20000200c00ULL,
0x000000141c28723cULL, 0x000fee0000001828ULL, 0x0000001700177306ULL, 0x000ea20000200c00ULL,
0x0000541077147816ULL, 0x002fe40000000062ULL, 0x000054107a157816ULL, 0x008fca0000000061ULL,
0x0000001600167306ULL, 0x000fe40000200c00ULL, 0x000000141c24723cULL, 0x000fec0000001824ULL,
0x0000001800197306ULL, 0x000e620000200c00ULL, 0x000054103c147816ULL, 0x004fce0000000017ULL,
0x0000006000607306ULL, 0x000ff00000200c00ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000541016157816ULL, 0x002fce0000000019ULL, 0x0000001a001b7306ULL, 0x000e620000200c00ULL,
0x000000141c20723cULL, 0x000fee0000001820ULL, 0x0000003d00187306ULL, 0x000ea20000200c00ULL,
0x000054101b147816ULL, 0x002fe40000000060ULL, 0x0000541018157816ULL, 0x004fce000000005fULL,
0x000000141c1c723cULL, 0x000fe20000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe8000c80043fULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000002947ULL, 0x000fea0003800000ULL, 0x01065c00ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fc40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065c00ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007840cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000800e107811ULL, 0x000fe200078e40ffULL,
0x00000100ff1b7424ULL, 0x000fe200078e00ffULL, 0x00000004ff197819ULL, 0x000fc4000001160aULL,
0x000000100c117217ULL, 0x000fe20007800000ULL, 0x0000620009177a24ULL, 0x000fc800078e0210ULL,
0x0000000111117824ULL, 0x000fe400078e0a10ULL, 0x0000000146107824ULL, 0x100fe400078e0217ULL,
0x0000000142147824ULL, 0x100fe200078e0217ULL, 0x0000002011137807ULL, 0x000fe20000000000ULL,
0x0000000140127824ULL, 0x000fe400078e0217ULL, 0x00005e0010107625ULL, 0x000fe200078e001bULL,
0x0000001308137217ULL, 0x000fc60007800000ULL, 0x00005e0014147625ULL, 0x000fe200078e001bULL,
0x0000004410167210ULL, 0x000fc60007f5e0ffULL, 0x0000000113187824ULL, 0x000fe200078e0a08ULL,
0x0000004414147210ULL, 0x000fe20007f9e0ffULL, 0x00005e0012127625ULL, 0x000fc600078e001bULL,
0x000000184500720cULL, 0x000fe20003f66070ULL, 0x000000010f107824ULL, 0x000fe200078e0217ULL,
0x0000004412127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200010e0611ULL,
0x000000181900720cULL, 0x000fe20003f46070ULL, 0x00005e0010107625ULL, 0x000fc800078e001bULL,
0x000000ffff157224ULL, 0x000fe200020e0615ULL, 0x000000184300720cULL, 0x080fe20003f86070ULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x000000184100720cULL, 0x000fe40003fa6070ULL,
0x0000004410107210ULL, 0x000fc60007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016507faeULL, 0x0003e4000d101c46ULL, 0x000000ffff117224ULL, 0x000fe400030e0611ULL,
0x00000000144f7faeULL, 0x0003e8000d901c46ULL, 0x00000000124e7faeULL, 0x0003e8000e101c46ULL,
0x00000000104d7faeULL, 0x0003e8000e901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff107984ULL, 0x002e620000000800ULL, 0x800000005e117824ULL, 0x000fca00078e00ffULL,
0x8000000010ff7812ULL, 0x002fe20007844811ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000002947ULL, 0x000fea0003800000ULL, 0x01065400ff107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007844811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fe400078e00ffULL,
0x800000005e127824ULL, 0x000fe400078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065400ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007844812ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000005118783bULL, 0x000e620000004200ULL, 0x00000002ff797819ULL, 0x000fc6000001160aULL,
0x000000004c3c783bULL, 0x000fe80000004200ULL, 0x000000004910783bULL, 0x000ea80000004200ULL,
0x000000004814783bULL, 0x000ee20000004200ULL, 0x00000018ff8d7819ULL, 0x002fe20000011418ULL,
0x0000010018677824ULL, 0x040fe200078e00ffULL, 0x0000888018917816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe20000011419ULL,
0x0000010019687824ULL, 0x040fe200078e00ffULL, 0x0000888019907816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000010010727824ULL, 0x044fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x00010000106d7824ULL, 0x000fe200078e00ffULL, 0x00000018008e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000010011717824ULL, 0x040fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001141aULL, 0x00010000116e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe2000001141bULL, 0x000001003f7d7824ULL, 0x000fe200078e00ffULL,
0x000088801a8c7816ULL, 0x040fe200000000ffULL, 0x0000006700927306ULL, 0x0005e20000200c00ULL,
0x000001001a187824ULL, 0x042fe200078e00ffULL, 0x000088801b6f7816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe2000001143cULL,
0x000100003e7e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000100003f7b7824ULL, 0x000fe200078e00ffULL, 0x00000019008f7306ULL, 0x0003e20000200c00ULL,
0x000001001b677824ULL, 0x044fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000088803c867816ULL, 0x000fe200000000ffULL,
0x0000010013697824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fc40000011410ULL,
0x00000018008b7306ULL, 0x0005e20000200c00ULL, 0x000001003d197824ULL, 0x002fe200078e00ffULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000888010737816ULL, 0x000fe400000000ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x0000001a00887306ULL, 0x000fe20000200c00ULL,
0x000001003c187824ULL, 0x044fe200078e00ffULL, 0x00000000ff10723eULL, 0x000fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fc40000011468ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000001b00897306ULL, 0x000fe20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff677819ULL, 0x000fe40000011467ULL,
0x00000018ff647819ULL, 0x000fe40000011412ULL, 0x00008880126b7816ULL, 0x000fe200000000ffULL,
0x0000001800857306ULL, 0x0003e20000200c00ULL, 0x00000018ff7c7819ULL, 0x000fc4000001143dULL,
0x00000018ff657819ULL, 0x000fe40000011411ULL, 0x000088803d777816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000888011707816ULL, 0x000fe200000000ffULL,
0x0000001900847306ULL, 0x000fe20000200c00ULL, 0x000001003e187824ULL, 0x002fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe4000001143eULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff187819ULL, 0x000fc40000011418ULL, 0x0000003c00827306ULL, 0x0003e20000200c00ULL,
0x00000018ff747819ULL, 0x000fe4000001143fULL, 0x000088803e807816ULL, 0x000fe200000000ffULL,
0x00010000133e7824ULL, 0x000fe200078e00ffULL, 0x000088803f7a7816ULL, 0x000fe400000000ffULL,
0x00000018ff637819ULL, 0x000fe20000011413ULL, 0x00000018007f7306ULL, 0x0005e20000200c00ULL,
0x00005410103c7816ULL, 0x002fe20000000010ULL, 0x0000010012107824ULL, 0x040fe200078e00ffULL,
0x00000018ff627819ULL, 0x008fe20000011414ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x00001f793c797589ULL, 0x000fe200000e0000ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x0000a8004b187811ULL, 0x004fe200078e20ffULL, 0x00001f473c787589ULL, 0x000fe200000e0000ULL,
0x00000018ff7e7819ULL, 0x000fc4000001147eULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00000018ff617819ULL, 0x000fe40000011415ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000006800937306ULL, 0x0004e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fc4000001146eULL,
0x00000018ff697819ULL, 0x000fe40000011469ULL, 0x00000018ff3e7819ULL, 0x000fe4000001143eULL,
0x00000018ff607819ULL, 0x000fe20000011416ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x0000888013687816ULL, 0x004fe400000000ffULL, 0x0000a8004a137811ULL, 0x000fe400078e20ffULL,
0x00000018ff5f7819ULL, 0x000fc60000011417ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000541090117816ULL, 0x008fce0000000093ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x0000007918189232ULL, 0x002fce0000000000ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000000791a1a9232ULL, 0x000fe40000000000ULL, 0x0000007819199232ULL, 0x080fe40000000000ULL,
0x000000781b1b9232ULL, 0x000fc60000000000ULL, 0x00000067008a7306ULL, 0x0002e20000200c00ULL,
0x000054108c3c7816ULL, 0x004fce000000008bULL, 0x00000010006a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff677819ULL, 0x002fe40000011412ULL, 0x0000888014127816ULL, 0x000fca00000000ffULL,
0x0000008700877306ULL, 0x000e620000200c00ULL, 0x0000541091107816ULL, 0x004fe20000000092ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0012ULL, 0x0000010014127824ULL, 0x040fe400078e00ffULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x000000101838723cULL, 0x000fe40000001838ULL, 0x00000018ff147819ULL, 0x000fca0000011414ULL,
0x000054108e107816ULL, 0x000fe2000000008dULL, 0x0000003d00837306ULL, 0x0007e20000200c00ULL,
0x000054108f117816ULL, 0x000fe4000000006cULL, 0x00000018ff6c7819ULL, 0x000fe40000011412ULL,
0x00008880158d7816ULL, 0x000fc600000000ffULL, 0x0000008600867306ULL, 0x000f220000200c00ULL,
0x000054106f3d7816ULL, 0x008fe2000000008aULL, 0x000000101834723cULL, 0x000fe20000001834ULL,
0x000000001310783bULL, 0x000ee20000000200ULL, 0x00000100158a7824ULL, 0x000fc800078e00ffULL,
0x0000007700777306ULL, 0x000f640000200c00ULL, 0x0000003c1830723cULL, 0x000fec0000001830ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x00005410883c7816ULL, 0x002fe40000000087ULL,
0x00005410893d7816ULL, 0x004fc40000000076ULL, 0x00000018ff767819ULL, 0x000fc6000001148aULL,
0x0000007c007c7306ULL, 0x000e640000200c00ULL, 0x0000003c182c723cULL, 0x000fec000000182cULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410863c7816ULL, 0x010fe40000000085ULL,
0x00005410773d7816ULL, 0x020fca0000000084ULL, 0x0000007d007d7306ULL, 0x000ea40000200c00ULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x0000007910109232ULL, 0x088fe40000000000ULL,
0x0000007912129232ULL, 0x000fe40000000000ULL, 0x0000007811119232ULL, 0x080fe20000000000ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00010000153c7824ULL, 0x000fe200078e00ffULL,
0x0000541083157816ULL, 0x002fe2000000007cULL, 0x0000007813139232ULL, 0x000fe20000000000ULL,
0x00008880167c7816ULL, 0x000fc800000000ffULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000054107a3d7816ULL, 0x004fce000000007dULL, 0x0000007e007e7306ULL, 0x000e700000200c00ULL,
0x0000007b007b7306ULL, 0x000eb00000200c00ULL, 0x0000001400777306ULL, 0x0007f00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541082147816ULL, 0x008fce0000000081ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x00000018ff157819ULL, 0x000fe4000001143cULL,
0x000054107e147816ULL, 0x002fca0000000075ULL, 0x0000007100717306ULL, 0x000e700000200c00ULL,
0x00000015007a7306ULL, 0x0005f00000200c00ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000054107b157816ULL, 0x004fce0000000074ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000014181c723cULL, 0x000fee000000181cULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x0000541073147816ULL, 0x008fe40000000072ULL, 0x0000541070157816ULL, 0x002fca0000000071ULL,
0x0000006e006e7306ULL, 0x000e640000200c00ULL, 0x000000141038723cULL, 0x000fec0000001838ULL,
0x0000008000807306ULL, 0x000ee20000200c00ULL, 0x000054106d147816ULL, 0x004fce0000000066ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000054106e157816ULL, 0x002fce0000000065ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00005410803c7816ULL, 0x008fe2000000007fULL,
0x000000141034723cULL, 0x000fec0000001834ULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x000054106b147816ULL, 0x004fe2000000006aULL, 0x0000003c1820723cULL, 0x000fec0000001820ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00000100163d7824ULL, 0x000fe200078e00ffULL,
0x0000888017187816ULL, 0x040fe200000000ffULL, 0x00000100171a7824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe4000001143dULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000541068157816ULL, 0x002fe40000000069ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff167819ULL, 0x000fc60000011416ULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x000000141030723cULL, 0x000fee0000001830ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0001000017147824ULL, 0x000fca00078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe40000011414ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x0000541067147816ULL, 0x002fce0000000064ULL, 0x0000006c006c7306ULL, 0x000e620000200c00ULL,
0x000054103e157816ULL, 0x004fce0000000063ULL, 0x0000008d006f7306ULL, 0x000fe20000200c00ULL,
0x00000014102c723cULL, 0x000fee000000182cULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x000054103f147816ULL, 0x002fce000000006cULL, 0x0000006200627306ULL, 0x000e700000200c00ULL,
0x0000006100617306ULL, 0x000ee20000200c00ULL, 0x000054106f157816ULL, 0x004fce0000000076ULL,
0x0000007c003c7306ULL, 0x000fe20000200c00ULL, 0x000000141028723cULL, 0x000fee0000001828ULL,
0x0000001900197306ULL, 0x000ea20000200c00ULL, 0x0000541077147816ULL, 0x002fe40000000062ULL,
0x000054107a157816ULL, 0x008fca0000000061ULL, 0x0000001800187306ULL, 0x000fe40000200c00ULL,
0x000000141024723cULL, 0x000fec0000001824ULL, 0x0000001a001b7306ULL, 0x000e620000200c00ULL,
0x000054103c147816ULL, 0x004fce0000000019ULL, 0x0000006000607306ULL, 0x000ff00000200c00ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x0000541018157816ULL, 0x002fce000000001bULL,
0x0000001600177306ULL, 0x000e620000200c00ULL, 0x000000141020723cULL, 0x000fee0000001820ULL,
0x0000003d001a7306ULL, 0x000ea20000200c00ULL, 0x0000541017147816ULL, 0x002fe40000000060ULL,
0x000054101a157816ULL, 0x004fce000000005fULL, 0x000000141010723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000800e157811ULL, 0x000fe200078e40ffULL, 0x01062000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000ff02ff7812ULL, 0x000fe4000784c0ffULL, 0x000000150c00720cULL, 0x000fe40003f24070ULL,
0x00000001ff5f7807ULL, 0x000fd60005000000ULL, 0x0000599000009947ULL, 0x000fea0003800000ULL,
0x01065c00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01065c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc4000782c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000a00e147811ULL, 0x000fe200078e40ffULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff1d7819ULL, 0x000fe4000001160aULL, 0x000000140c157217ULL, 0x000fe20007800000ULL,
0x0000620009177a24ULL, 0x000fc800078e0214ULL, 0x0000000115157824ULL, 0x000fe400078e0a14ULL,
0x0000000146147824ULL, 0x100fe400078e0217ULL, 0x0000000142187824ULL, 0x000fe200078e0217ULL,
0x0000002015197807ULL, 0x000fe20000000000ULL, 0x00005e0014147625ULL, 0x000fc600078e001fULL,
0x00000019081b7217ULL, 0x000fe20007800000ULL, 0x00005e0018187625ULL, 0x000fe200078e001fULL,
0x00000044141a7210ULL, 0x000fc60007f3e0ffULL, 0x000000011b1c7824ULL, 0x000fe200078e0a08ULL,
0x0000004418187210ULL, 0x000fe20007f7e0ffULL, 0x0000000140167824ULL, 0x100fe400078e0217ULL,
0x000000010f147824ULL, 0x000fe200078e0217ULL, 0x0000001c1d00720cULL, 0x080fe20003f46070ULL,
0x000000ffff1b7224ULL, 0x000fe200008e0615ULL, 0x0000001c4500720cULL, 0x080fe20003f26070ULL,
0x00005e0016167625ULL, 0x000fe200078e001fULL, 0x0000001c4100720cULL, 0x000fc60003f86070ULL,
0x00005e0014147625ULL, 0x000fe200078e001fULL, 0x0000004416167210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x0000001c4300720cULL, 0x000fe20003f66070ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000004414147210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a5d7faeULL, 0x0003e8000d101c46ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x00000000185c7faeULL, 0x0003ea000c901c46ULL,
0x00000000165b7faeULL, 0x0003e8000d901c46ULL, 0x00000000145a7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01065000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01064c00ff157984ULL, 0x002e620000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01062c00ff167984ULL, 0x000ea20000000800ULL,
0x000000ff02ff7812ULL, 0x000fe2000782c0ffULL, 0x8000000057177824ULL, 0x000fc600078e00ffULL,
0x00000001ff5f7807ULL, 0x000fca0004800000ULL, 0x800000005f147824ULL, 0x000fca00078e00ffULL,
0x8000000015ff7812ULL, 0x002fe40007824814ULL, 0x8000000016ff7812ULL, 0x004fe20007844817ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fe400078e00ffULL, 0x8000000057167824ULL, 0x000fe400078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01062c00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007844816ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x0101000059147984ULL, 0x000e620000000800ULL,
0x00000001ff687424ULL, 0x000fc600078e00ffULL, 0x0103000059157984ULL, 0x0004e20000000800ULL,
0x000000071400720bULL, 0x002fda0003f5d000ULL, 0x0000000000167806ULL, 0x000fc800010e0100ULL,
0x0000ffff16187812ULL, 0x000fda000784c0ffULL, 0x000003400000a947ULL, 0x000fea0003800000ULL,
0x000000071400720bULL, 0x00cfe40003f54000ULL, 0x0000001407167209ULL, 0x000fe40007810000ULL,
0x00000002ff1a7819ULL, 0x000fc6000001160aULL, 0x8000001607177221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b17177820ULL, 0x000fe40000410000ULL, 0x0000000000077806ULL, 0x000fe400010e0100ULL,
0x000000020d00780cULL, 0x000fe40003f45270ULL, 0x0000ffff07197812ULL, 0x000fe200078e3cffULL,
0x0000001700177308ULL, 0x000e660000000800ULL, 0x0000001918ff7212ULL, 0x000fc8000786c0ffULL,
0x00000001ff687807ULL, 0x000fc60001800000ULL, 0x010500165900a388ULL, 0x000fe80000000800ULL,
0x00001f1a17077589ULL, 0x002e6400000e0000ULL, 0x8000001614183221ULL, 0x000fe20000010000ULL,
0x0000001706067220ULL, 0x000fe20000410000ULL, 0x00001f4717147589ULL, 0x000ea400000e0000ULL,
0x3fb8aa3b18183820ULL, 0x000fc80000410000ULL, 0x0000001800003308ULL, 0x000ee20000000800ULL,
0x0000000738387220ULL, 0x082fe20000410000ULL, 0x0000000739397220ULL, 0x080fe20000410000ULL,
0x0000000734347220ULL, 0x080fe20000410000ULL, 0x0000000735357220ULL, 0x080fe20000410000ULL,
0x0000000730307220ULL, 0x080fe20000410000ULL, 0x0000000731317220ULL, 0x080fe20000410000ULL,
0x000000072c2c7220ULL, 0x080fe20000410000ULL, 0x000000072d2d7220ULL, 0x080fe20000410000ULL,
0x0000000728287220ULL, 0x080fe20000410000ULL, 0x0000000729297220ULL, 0x080fe20000410000ULL,
0x0000000724247220ULL, 0x080fe20000410000ULL, 0x0000000725257220ULL, 0x080fe20000410000ULL,
0x0000000720207220ULL, 0x080fe20000410000ULL, 0x0000000721217220ULL, 0x080fe20000410000ULL,
0x0000000710107220ULL, 0x080fe20000410000ULL, 0x0000000711117220ULL, 0x000fe20000410000ULL,
0x000000143a3a7220ULL, 0x084fe20000410000ULL, 0x000000143b3b7220ULL, 0x080fe20000410000ULL,
0x0000001436367220ULL, 0x080fe20000410000ULL, 0x0000001437377220ULL, 0x080fe20000410000ULL,
0x0000001432327220ULL, 0x080fe20000410000ULL, 0x0000001433337220ULL, 0x080fe20000410000ULL,
0x000000142e2e7220ULL, 0x080fe20000410000ULL, 0x000000142f2f7220ULL, 0x080fe20000410000ULL,
0x000000142a2a7220ULL, 0x080fe20000410000ULL, 0x000000142b2b7220ULL, 0x080fe20000410000ULL,
0x0000001426267220ULL, 0x080fe20000410000ULL, 0x0000001427277220ULL, 0x080fe20000410000ULL,
0x0000001422227220ULL, 0x080fe20000410000ULL, 0x0000001423237220ULL, 0x080fe20000410000ULL,
0x0000001412127220ULL, 0x080fe20000410000ULL, 0x0000001413137220ULL, 0x000fe20000410000ULL,
0x000000ffff077224ULL, 0x000fe200078e0016ULL, 0x0000001500153220ULL, 0x008fc80000410000ULL,
0x0000000615067221ULL, 0x00cfe20000010000ULL, 0x000000e000001947ULL, 0x000fea0003800000ULL,
0x01064c00ff147984ULL, 0x000e620000000800ULL, 0x800000005f157824ULL, 0x000fca00078e00ffULL,
0x8000000014ff7812ULL, 0x002fe20007824815ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fe400078e00ffULL,
0x800000005f167824ULL, 0x000fe400078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01064c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007824816ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000005818783bULL, 0x000e620000004200ULL, 0x00000002ff797819ULL, 0x000fc6000001160aULL,
0x00000000563c783bULL, 0x000fe80000004200ULL, 0x00000000541c783bULL, 0x000ea80000004200ULL,
0x000000005314783bULL, 0x000ee20000004200ULL, 0x00000018ff8e7819ULL, 0x002fe20000011418ULL,
0x0000010018697824ULL, 0x040fe200078e00ffULL, 0x0000888018927816ULL, 0x040fe200000000ffULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011419ULL,
0x00000100196a7824ULL, 0x040fe200078e00ffULL, 0x0000888019917816ULL, 0x040fe200000000ffULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001001c737824ULL, 0x044fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x000100001c6e7824ULL, 0x000fe200078e00ffULL, 0x00000018008f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x000001001d727824ULL, 0x040fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001141aULL, 0x000100001d6f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe2000001141bULL, 0x000001001e6b7824ULL, 0x000fe200078e00ffULL,
0x000088801a8d7816ULL, 0x040fe200000000ffULL, 0x0000006900937306ULL, 0x0005e20000200c00ULL,
0x000001001a187824ULL, 0x042fe200078e00ffULL, 0x000088801b707816ULL, 0x000fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001143cULL,
0x000001003e807824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x000001003f7e7824ULL, 0x000fe200078e00ffULL, 0x0000001900907306ULL, 0x0003e20000200c00ULL,
0x000001001b697824ULL, 0x044fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000088803c877816ULL, 0x000fe200000000ffULL,
0x000100003e7f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001141cULL,
0x000100003f7c7824ULL, 0x000fe200078e00ffULL, 0x00000018008c7306ULL, 0x0005e20000200c00ULL,
0x000001003d197824ULL, 0x002fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fc4000001141bULL,
0x000088801c747816ULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001a00897306ULL, 0x000fe20000200c00ULL, 0x000001003c187824ULL, 0x044fe200078e00ffULL,
0x00000000ff1c723eULL, 0x000fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x0000001b008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff667819ULL, 0x000fe4000001141dULL, 0x000088801d717816ULL, 0x000fe200000000ffULL,
0x000001001f1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000001800867306ULL, 0x0003e20000200c00ULL, 0x00000018ff657819ULL, 0x000fe4000001141eULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x000088801e6c7816ULL, 0x040fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001143dULL,
0x0000001900857306ULL, 0x0005e20000200c00ULL, 0x0000b00055187811ULL, 0x002fe400078e20ffULL,
0x000088803d787816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe4000001143eULL, 0x00000018ff757819ULL, 0x000fe2000001143fULL,
0x0000003c00837306ULL, 0x0003e20000200c00ULL, 0x000000001818783bULL, 0x004fe20000000200ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x000088803e817816ULL, 0x000fe400000000ffULL,
0x000088803f7b7816ULL, 0x000fe200000000ffULL, 0x000100001f3f7824ULL, 0x000fe200078e00ffULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054101c3c7816ULL, 0x002fe4000000001cULL,
0x00009910681c7816ULL, 0x000fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe2000001141eULL,
0x00001f793c797589ULL, 0x000e6200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f25270ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x00008880141e7816ULL, 0x008fe200000000ffULL,
0x00001f473c7a7589ULL, 0x000ee200000e0000ULL, 0x00000018ff647819ULL, 0x000fc4000001141fULL,
0x00000018ff637819ULL, 0x000fe20000011414ULL, 0x000000ffff3e7224ULL, 0x000fe200078e001eULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006a00947306ULL, 0x000fe20000200c00ULL,
0x00005410921c7816ULL, 0x004fe20000000093ULL, 0x00000100141e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x00000018ff627819ULL, 0x000fe20000011415ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff737819ULL, 0x000fe40000011473ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000007918189232ULL, 0x082fe20000000000ULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x000000791a1a9232ULL, 0x000fe20000000000ULL, 0x00000018ff807819ULL, 0x000fe20000011480ULL,
0x0000007a19199232ULL, 0x088fe20000000000ULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000007a1b1b9232ULL, 0x000fe20000000000ULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x00000018ff3f7819ULL, 0x000fc4000001143fULL, 0x00000018ff617819ULL, 0x000fe40000011416ULL,
0x00000018ff607819ULL, 0x000fc60000011417ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x00000069008b7306ULL, 0x0004e20000200c00ULL, 0x000054108d3c7816ULL, 0x002fce000000008cULL,
0x0000001d006a7306ULL, 0x0003e20000200c00ULL, 0x000088801f697816ULL, 0x004fe400000000ffULL,
0x0000b000521f7811ULL, 0x000fca00078e20ffULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x00005410911d7816ULL, 0x002fce0000000094ULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000001c1838723cULL, 0x000fee0000001838ULL, 0x000054108f1c7816ULL, 0x000fe2000000008eULL,
0x0000003d00847306ULL, 0x0007e20000200c00ULL, 0x00005410901d7816ULL, 0x000fc4000000006dULL,
0x00000018ff6d7819ULL, 0x000fe4000001141eULL, 0x00008880158e7816ULL, 0x000fc600000000ffULL,
0x0000008700877306ULL, 0x000f220000200c00ULL, 0x00005410703d7816ULL, 0x008fe2000000008bULL,
0x0000001c1834723cULL, 0x000fe20000001834ULL, 0x000000001f1c783bULL, 0x000ee20000000200ULL,
0x00000100158b7824ULL, 0x000fc800078e00ffULL, 0x0000007800787306ULL, 0x000f640000200c00ULL,
0x0000003c1830723cULL, 0x000fec0000001830ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x00005410893c7816ULL, 0x004fe40000000088ULL, 0x000054108a3d7816ULL, 0x002fc40000000077ULL,
0x00000018ff777819ULL, 0x000fc6000001148bULL, 0x0000007d007d7306ULL, 0x000e640000200c00ULL,
0x0000003c182c723cULL, 0x000fec000000182cULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x00005410873c7816ULL, 0x010fe40000000086ULL, 0x00005410783d7816ULL, 0x020fca0000000085ULL,
0x0000007e007e7306ULL, 0x000ea40000200c00ULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x000000791c1c9232ULL, 0x088fe40000000000ULL, 0x000000791e1e9232ULL, 0x000fe40000000000ULL,
0x0000007a1d1d9232ULL, 0x080fe20000000000ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x00010000153c7824ULL, 0x000fe200078e00ffULL, 0x0000541084157816ULL, 0x002fe2000000007dULL,
0x0000007a1f1f9232ULL, 0x000fe20000000000ULL, 0x00008880167d7816ULL, 0x000fc800000000ffULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107b3d7816ULL, 0x004fce000000007eULL,
0x0000007f007f7306ULL, 0x000e700000200c00ULL, 0x0000007c007c7306ULL, 0x000eb00000200c00ULL,
0x0000001400787306ULL, 0x0007f00000200c00ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541083147816ULL, 0x008fce0000000082ULL, 0x0000007300737306ULL, 0x000ee20000200c00ULL,
0x000000141824723cULL, 0x000fee0000001824ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe4000001143cULL, 0x000054107f147816ULL, 0x002fca0000000076ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x00000015007b7306ULL, 0x0005f00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054107c157816ULL, 0x004fce0000000075ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000000141810723cULL, 0x000fee0000001810ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000541074147816ULL, 0x008fe40000000073ULL,
0x0000541071157816ULL, 0x002fca0000000072ULL, 0x0000006f006f7306ULL, 0x000e640000200c00ULL,
0x000000141c38723cULL, 0x000fec0000001838ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000054106e147816ULL, 0x004fce0000000067ULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x000054106f157816ULL, 0x002fce0000000066ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000000141c34723cULL, 0x000fee0000001834ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x00005410813c7816ULL, 0x004fce0000000080ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000003c1820723cULL, 0x000fee0000001820ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x000054106c147816ULL, 0x002fe2000000006bULL, 0x00000100163d7824ULL, 0x000fe200078e00ffULL,
0x0000888017187816ULL, 0x040fe200000000ffULL, 0x00000100171a7824ULL, 0x000fc400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe2000001143dULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541069157816ULL, 0x004fe2000000006aULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000006800687306ULL, 0x000e620000200c00ULL, 0x000000141c30723cULL, 0x000fee0000001830ULL,
0x0000003f003f7306ULL, 0x000eb00000200c00ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x0000541068147816ULL, 0x002fce0000000065ULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x000054103f157816ULL, 0x004fce0000000064ULL, 0x0000008e00707306ULL, 0x000fe20000200c00ULL,
0x000000141c2c723cULL, 0x000fee000000182cULL, 0x0000007700777306ULL, 0x000ea20000200c00ULL,
0x000054103e147816ULL, 0x002fce000000006dULL, 0x0000006300637306ULL, 0x000e700000200c00ULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x0000541070157816ULL, 0x004fce0000000077ULL,
0x0000007d003c7306ULL, 0x000fe20000200c00ULL, 0x000000141c28723cULL, 0x000fee0000001828ULL,
0x0000001900197306ULL, 0x000ea20000200c00ULL, 0x0000541078147816ULL, 0x002fe40000000063ULL,
0x000054107b157816ULL, 0x008fca0000000062ULL, 0x0000001800187306ULL, 0x000fe40000200c00ULL,
0x000000141c24723cULL, 0x000fec0000001824ULL, 0x0000001a001b7306ULL, 0x000e620000200c00ULL,
0x000054103c147816ULL, 0x004fce0000000019ULL, 0x0000006100617306ULL, 0x000ff00000200c00ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541018157816ULL, 0x002fce000000001bULL,
0x0000001600167306ULL, 0x000e620000200c00ULL, 0x000000141c20723cULL, 0x000fee0000001820ULL,
0x0000001700177306ULL, 0x000ea20000200c00ULL, 0x0000541016147816ULL, 0x002fe40000000061ULL,
0x0000541017157816ULL, 0x004fce0000000060ULL, 0x000000141c1c723cULL, 0x000fe20000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000002947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000002947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007840cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x000000c00e107811ULL, 0x000fe200078e40ffULL, 0x00000100ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff197819ULL, 0x000fc4000001160aULL, 0x000000100c117217ULL, 0x000fe20007800000ULL,
0x0000620009177a24ULL, 0x000fc800078e0210ULL, 0x0000000111117824ULL, 0x000fe400078e0a10ULL,
0x0000000146107824ULL, 0x100fe400078e0217ULL, 0x0000000142147824ULL, 0x100fe200078e0217ULL,
0x0000002011137807ULL, 0x000fe20000000000ULL, 0x0000000140127824ULL, 0x000fe400078e0217ULL,
0x00005e0010107625ULL, 0x000fe200078e001bULL, 0x0000001308137217ULL, 0x000fc60007800000ULL,
0x00005e0014147625ULL, 0x000fe200078e001bULL, 0x0000004410167210ULL, 0x000fc60007f5e0ffULL,
0x0000000113187824ULL, 0x000fe200078e0a08ULL, 0x0000004414147210ULL, 0x000fe20007f9e0ffULL,
0x00005e0012127625ULL, 0x000fc600078e001bULL, 0x000000184500720cULL, 0x000fe20003f66070ULL,
0x000000010f107824ULL, 0x000fe200078e0217ULL, 0x0000004412127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0611ULL, 0x000000181900720cULL, 0x000fe20003f46070ULL,
0x00005e0010107625ULL, 0x000fc800078e001bULL, 0x000000ffff157224ULL, 0x000fe200020e0615ULL,
0x000000184300720cULL, 0x080fe20003f86070ULL, 0x000000ffff137224ULL, 0x000fe200028e0613ULL,
0x000000184100720cULL, 0x000fe40003fa6070ULL, 0x0000004410107210ULL, 0x000fc60007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016507faeULL, 0x0003e4000d101c46ULL,
0x000000ffff117224ULL, 0x000fe400030e0611ULL, 0x00000000144f7faeULL, 0x0003e8000d901c46ULL,
0x00000000124e7faeULL, 0x0003e8000e101c46ULL, 0x00000000104d7faeULL, 0x0003e8000e901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01064800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01065400ff107984ULL, 0x002e620000000800ULL,
0x800000005f117824ULL, 0x000fca00078e00ffULL, 0x8000000010ff7812ULL, 0x002fe20007844811ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000002947ULL, 0x000fea0003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007844811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000002947ULL, 0x000fea0003800000ULL,
0x800000005f127824ULL, 0x000fe400078e00ffULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01065400ff117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fc40007844812ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff900000a947ULL, 0x000fea000383ffffULL, 0x000000005118783bULL, 0x000e620000004200ULL,
0x00000002ff797819ULL, 0x000fc6000001160aULL, 0x000000004c3c783bULL, 0x000fe80000004200ULL,
0x000000004910783bULL, 0x000ea80000004200ULL, 0x000000004814783bULL, 0x000ee20000004200ULL,
0x00000018ff8d7819ULL, 0x002fe20000011418ULL, 0x0000010018677824ULL, 0x040fe200078e00ffULL,
0x0000888018917816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011419ULL, 0x0000010019687824ULL, 0x040fe200078e00ffULL,
0x0000888019907816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000010010727824ULL, 0x044fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x00010000106d7824ULL, 0x000fe200078e00ffULL,
0x00000018008e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000010011717824ULL, 0x040fe200078e00ffULL, 0x00000018ff877819ULL, 0x000fe2000001141aULL,
0x00010000116e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fe2000001141bULL,
0x000001003f7d7824ULL, 0x000fe200078e00ffULL, 0x000088801a8c7816ULL, 0x040fe200000000ffULL,
0x0000006700927306ULL, 0x0005e20000200c00ULL, 0x000001001a187824ULL, 0x042fe200078e00ffULL,
0x000088801b6f7816ULL, 0x000fe200000000ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001143cULL, 0x000100003e7e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x000100003f7b7824ULL, 0x000fe200078e00ffULL,
0x00000019008f7306ULL, 0x0003e20000200c00ULL, 0x000001001b677824ULL, 0x044fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x000088803c867816ULL, 0x000fe200000000ffULL, 0x0000010013697824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fc40000011410ULL, 0x00000018008b7306ULL, 0x0005e20000200c00ULL,
0x000001003d197824ULL, 0x002fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000888010737816ULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001a00887306ULL, 0x000fe20000200c00ULL, 0x000001003c187824ULL, 0x044fe200078e00ffULL,
0x00000000ff10723eULL, 0x000fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011468ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001b00897306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff677819ULL, 0x000fe40000011467ULL, 0x00000018ff647819ULL, 0x000fe40000011412ULL,
0x00008880126b7816ULL, 0x000fe200000000ffULL, 0x0000001800857306ULL, 0x0003e20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fc4000001143dULL, 0x00000018ff657819ULL, 0x000fe40000011411ULL,
0x000088803d777816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x0000888011707816ULL, 0x000fe200000000ffULL, 0x0000001900847306ULL, 0x000fe20000200c00ULL,
0x000001003e187824ULL, 0x002fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x0000003c00827306ULL, 0x0003e20000200c00ULL, 0x00000018ff747819ULL, 0x000fe4000001143fULL,
0x000088803e807816ULL, 0x000fe200000000ffULL, 0x00010000133e7824ULL, 0x000fe200078e00ffULL,
0x000088803f7a7816ULL, 0x000fe400000000ffULL, 0x00000018ff637819ULL, 0x000fe20000011413ULL,
0x00000018007f7306ULL, 0x0005e20000200c00ULL, 0x00005410103c7816ULL, 0x002fe20000000010ULL,
0x0000010012107824ULL, 0x040fe200078e00ffULL, 0x00000018ff627819ULL, 0x008fe20000011414ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x00001f793c797589ULL, 0x000fe200000e0000ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x0000b0004b187811ULL, 0x004fe200078e20ffULL,
0x00001f473c787589ULL, 0x000fe200000e0000ULL, 0x00000018ff7e7819ULL, 0x000fc4000001147eULL,
0x00000018ff7b7819ULL, 0x000fe4000001147bULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x00000018ff617819ULL, 0x000fe40000011415ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff717819ULL, 0x000fe40000011471ULL,
0x00000018ff6d7819ULL, 0x000fe2000001146dULL, 0x0000006800937306ULL, 0x0004e20000200c00ULL,
0x00000018ff6e7819ULL, 0x000fc4000001146eULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff607819ULL, 0x000fe20000011416ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x0000888013687816ULL, 0x004fe400000000ffULL,
0x0000b0004a137811ULL, 0x000fe400078e20ffULL, 0x00000018ff5f7819ULL, 0x000fc60000011417ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000541090117816ULL, 0x008fce0000000093ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x0000007918189232ULL, 0x002fce0000000000ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000791a1a9232ULL, 0x000fe40000000000ULL,
0x0000007819199232ULL, 0x080fe40000000000ULL, 0x000000781b1b9232ULL, 0x000fc60000000000ULL,
0x00000067008a7306ULL, 0x0002e20000200c00ULL, 0x000054108c3c7816ULL, 0x004fce000000008bULL,
0x00000010006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff677819ULL, 0x002fe40000011412ULL,
0x0000888014127816ULL, 0x000fca00000000ffULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x0000541091107816ULL, 0x004fe20000000092ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0012ULL,
0x0000010014127824ULL, 0x040fe400078e00ffULL, 0x0001000014147824ULL, 0x000fe400078e00ffULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000000101838723cULL, 0x000fe40000001838ULL,
0x00000018ff147819ULL, 0x000fca0000011414ULL, 0x000054108e107816ULL, 0x000fe2000000008dULL,
0x0000003d00837306ULL, 0x0007e20000200c00ULL, 0x000054108f117816ULL, 0x000fe4000000006cULL,
0x00000018ff6c7819ULL, 0x000fe40000011412ULL, 0x00008880158d7816ULL, 0x000fc600000000ffULL,
0x0000008600867306ULL, 0x000f220000200c00ULL, 0x000054106f3d7816ULL, 0x008fe2000000008aULL,
0x000000101834723cULL, 0x000fe20000001834ULL, 0x000000001310783bULL, 0x000ee20000000200ULL,
0x00000100158a7824ULL, 0x000fc800078e00ffULL, 0x0000007700777306ULL, 0x000f640000200c00ULL,
0x0000003c1830723cULL, 0x000fec0000001830ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00005410883c7816ULL, 0x002fe40000000087ULL, 0x00005410893d7816ULL, 0x004fc40000000076ULL,
0x00000018ff767819ULL, 0x000fc6000001148aULL, 0x0000007c007c7306ULL, 0x000e640000200c00ULL,
0x0000003c182c723cULL, 0x000fec000000182cULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410863c7816ULL, 0x010fe40000000085ULL, 0x00005410773d7816ULL, 0x020fca0000000084ULL,
0x0000007d007d7306ULL, 0x000ea40000200c00ULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x0000007910109232ULL, 0x088fe40000000000ULL, 0x0000007912129232ULL, 0x000fe40000000000ULL,
0x0000007811119232ULL, 0x080fe20000000000ULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0x00010000153c7824ULL, 0x000fe200078e00ffULL, 0x0000541083157816ULL, 0x002fe2000000007cULL,
0x0000007813139232ULL, 0x000fe20000000000ULL, 0x00008880167c7816ULL, 0x000fc800000000ffULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000054107a3d7816ULL, 0x004fce000000007dULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007b007b7306ULL, 0x000eb00000200c00ULL,
0x0000001400777306ULL, 0x0007f00000200c00ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x0000541082147816ULL, 0x008fce0000000081ULL, 0x0000007200727306ULL, 0x000ee20000200c00ULL,
0x000000141824723cULL, 0x000fee0000001824ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe4000001143cULL, 0x000054107e147816ULL, 0x002fca0000000075ULL,
0x0000007100717306ULL, 0x000e700000200c00ULL, 0x00000015007a7306ULL, 0x0005f00000200c00ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000054107b157816ULL, 0x004fce0000000074ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00000014181c723cULL, 0x000fee000000181cULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x0000541073147816ULL, 0x008fe40000000072ULL,
0x0000541070157816ULL, 0x002fca0000000071ULL, 0x0000006e006e7306ULL, 0x000e640000200c00ULL,
0x000000141038723cULL, 0x000fec0000001838ULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x000054106d147816ULL, 0x004fce0000000066ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x000054106e157816ULL, 0x002fce0000000065ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x00005410803c7816ULL, 0x008fe2000000007fULL, 0x000000141034723cULL, 0x000fec0000001834ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x000054106b147816ULL, 0x004fe2000000006aULL,
0x0000003c1820723cULL, 0x000fec0000001820ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x00000100163d7824ULL, 0x000fe200078e00ffULL, 0x0000888017187816ULL, 0x040fe200000000ffULL,
0x00000100171a7824ULL, 0x000fc400078e00ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe4000001143dULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541068157816ULL, 0x002fe40000000069ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x00000018ff167819ULL, 0x000fc60000011416ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000000141030723cULL, 0x000fee0000001830ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0001000017147824ULL, 0x000fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe40000011414ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x002fce0000000064ULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000054103e157816ULL, 0x004fce0000000063ULL,
0x0000008d006f7306ULL, 0x000fe20000200c00ULL, 0x00000014102c723cULL, 0x000fee000000182cULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x000054103f147816ULL, 0x002fce000000006cULL,
0x0000006200627306ULL, 0x000e700000200c00ULL, 0x0000006100617306ULL, 0x000ee20000200c00ULL,
0x000054106f157816ULL, 0x004fce0000000076ULL, 0x0000007c003c7306ULL, 0x000fe20000200c00ULL,
0x000000141028723cULL, 0x000fee0000001828ULL, 0x0000001900197306ULL, 0x000ea20000200c00ULL,
0x0000541077147816ULL, 0x002fe40000000062ULL, 0x000054107a157816ULL, 0x008fca0000000061ULL,
0x0000001800187306ULL, 0x000fe40000200c00ULL, 0x000000141024723cULL, 0x000fec0000001824ULL,
0x0000001a001b7306ULL, 0x000e620000200c00ULL, 0x000054103c147816ULL, 0x004fce0000000019ULL,
0x0000006000607306ULL, 0x000ff00000200c00ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000541018157816ULL, 0x002fce000000001bULL, 0x0000001600177306ULL, 0x000e620000200c00ULL,
0x000000141020723cULL, 0x000fee0000001820ULL, 0x0000003d001a7306ULL, 0x000ea20000200c00ULL,
0x0000541017147816ULL, 0x002fe40000000060ULL, 0x000054101a157816ULL, 0x004fce000000005fULL,
0x000000141010723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c00e157811ULL, 0x000fe200078e40ffULL,
0x01063000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff02ff7812ULL, 0x000fe4000784c0ffULL,
0x000000150c00720cULL, 0x000fe40003f24070ULL, 0x00000001ff5f7807ULL, 0x000fd60001000000ULL,
0x00002cc000009947ULL, 0x000fea0003800000ULL, 0x01065c00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000c000001947ULL, 0x000fea0003800000ULL, 0x01065c00ff147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff147424ULL, 0x000fc800078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01065c00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc4000782c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000e00e147811ULL, 0x000fe200078e40ffULL,
0x00000100ff1f7424ULL, 0x000fe200078e00ffULL, 0x00000004ff1d7819ULL, 0x000fe4000001160aULL,
0x000000140c157217ULL, 0x000fe20007800000ULL, 0x0000620009177a24ULL, 0x000fc800078e0214ULL,
0x0000000115157824ULL, 0x000fe400078e0a14ULL, 0x0000000146147824ULL, 0x100fe400078e0217ULL,
0x0000000142187824ULL, 0x000fe200078e0217ULL, 0x0000002015197807ULL, 0x000fe20000000000ULL,
0x00005e0014147625ULL, 0x000fc600078e001fULL, 0x0000001908197217ULL, 0x000fe20007800000ULL,
0x0000000140167824ULL, 0x100fe200078e0217ULL, 0x00000044141a7210ULL, 0x000fe20007f1e0ffULL,
0x000000010f147824ULL, 0x000fe400078e0217ULL, 0x00000001191c7824ULL, 0x000fe400078e0a08ULL,
0x000000ffff1b7224ULL, 0x000fe400000e0615ULL, 0x00005e0018187625ULL, 0x000fe200078e001fULL,
0x0000001c1d00720cULL, 0x000fc40003f06070ULL, 0x0000001c4500720cULL, 0x080fe20003f26070ULL,
0x00005e0016167625ULL, 0x080fe200078e001fULL, 0x0000001c4300720cULL, 0x080fe40003f46070ULL,
0x0000001c4100720cULL, 0x000fe20003f66070ULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0x0000004418187210ULL, 0x080fe40007f9e0ffULL, 0x0000004416167210ULL, 0x080fe40007fbe0ffULL,
0x0000004414147210ULL, 0x000fe20007fde0ffULL, 0x000000ffff197224ULL, 0x000fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a5d7faeULL, 0x0003e2000c101c46ULL,
0x000000ffff177224ULL, 0x000fc400028e0617ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x00000000185c7faeULL, 0x0003e8000c901c46ULL, 0x00000000165b7faeULL, 0x0003e8000d101c46ULL,
0x00000000145a7faeULL, 0x0003e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01065000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01064c00ff147984ULL, 0x002e620000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01063c00ff157984ULL, 0x000ea20000000800ULL, 0x800000005e177824ULL, 0x000fc400078e00ffULL,
0x8000000057167824ULL, 0x000fc600078e00ffULL, 0x8000000014ff7812ULL, 0x002fe40007804817ULL,
0x8000000015ff7812ULL, 0x004fe20007824816ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x8000000057167824ULL, 0x000fe400078e00ffULL,
0x3e000000ff147424ULL, 0x000fc800078e00ffULL, 0x0000001400157305ULL, 0x0002a4000021f000ULL,
0x3fa0000014147823ULL, 0x002fe200000100ffULL, 0x000000150000735dULL, 0x004fe40003800000ULL,
0x01063c00ff157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fc40007824816ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0101800059147984ULL, 0x000e620000000800ULL, 0x00000001ff5c7424ULL, 0x000fc600078e00ffULL,
0x0103800059157984ULL, 0x0004e20000000800ULL, 0x000000071400720bULL, 0x002fda0003f3d000ULL,
0x0000000000167806ULL, 0x000fc800008e0100ULL, 0x0000ffff16177812ULL, 0x000fda000782c0ffULL,
0x0000034000009947ULL, 0x000fea0003800000ULL, 0x000000071400720bULL, 0x00cfe40003f34000ULL,
0x00000014071a7209ULL, 0x000fe40007810000ULL, 0x00000002ff197819ULL, 0x000fc6000001160aULL,
0x8000001a07167221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b16167820ULL, 0x000fe40000410000ULL,
0x0000000000077806ULL, 0x000fe400008e0100ULL, 0x000000030d00780cULL, 0x000fe40003f25270ULL,
0x0000ffff07187812ULL, 0x000fe200078e3cffULL, 0x0000001600167308ULL, 0x000e660000000800ULL,
0x0000001817ff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ff5c7807ULL, 0x000fc60001000000ULL,
0x0105801a59009388ULL, 0x000fe80000000800ULL, 0x00001f1916077589ULL, 0x002e6400000e0000ULL,
0x8000001a14172221ULL, 0x000fe20000010000ULL, 0x0000001606067220ULL, 0x000fe20000410000ULL,
0x00001f4716147589ULL, 0x000ea400000e0000ULL, 0x3fb8aa3b17172820ULL, 0x000fc80000410000ULL,
0x0000001700002308ULL, 0x000ee20000000800ULL, 0x0000000738387220ULL, 0x082fe20000410000ULL,
0x0000000739397220ULL, 0x080fe20000410000ULL, 0x0000000734347220ULL, 0x080fe20000410000ULL,
0x0000000735357220ULL, 0x080fe20000410000ULL, 0x0000000730307220ULL, 0x080fe20000410000ULL,
0x0000000731317220ULL, 0x080fe20000410000ULL, 0x000000072c2c7220ULL, 0x080fe20000410000ULL,
0x000000072d2d7220ULL, 0x080fe20000410000ULL, 0x0000000728287220ULL, 0x080fe20000410000ULL,
0x0000000729297220ULL, 0x080fe20000410000ULL, 0x0000000724247220ULL, 0x080fe20000410000ULL,
0x0000000725257220ULL, 0x080fe20000410000ULL, 0x0000000720207220ULL, 0x080fe20000410000ULL,
0x0000000721217220ULL, 0x080fe20000410000ULL, 0x0000000710107220ULL, 0x080fe20000410000ULL,
0x0000000711117220ULL, 0x000fe20000410000ULL, 0x000000143a3a7220ULL, 0x084fe20000410000ULL,
0x000000143b3b7220ULL, 0x080fe20000410000ULL, 0x0000001436367220ULL, 0x080fe20000410000ULL,
0x0000001437377220ULL, 0x080fe20000410000ULL, 0x0000001432327220ULL, 0x080fe20000410000ULL,
0x0000001433337220ULL, 0x080fe20000410000ULL, 0x000000142e2e7220ULL, 0x080fe20000410000ULL,
0x000000142f2f7220ULL, 0x080fe20000410000ULL, 0x000000142a2a7220ULL, 0x080fe20000410000ULL,
0x000000142b2b7220ULL, 0x080fe20000410000ULL, 0x0000001426267220ULL, 0x080fe20000410000ULL,
0x0000001427277220ULL, 0x080fe20000410000ULL, 0x0000001422227220ULL, 0x080fe20000410000ULL,
0x0000001423237220ULL, 0x080fe20000410000ULL, 0x0000001412127220ULL, 0x080fe20000410000ULL,
0x0000001413137220ULL, 0x000fe20000410000ULL, 0x000000ffff077224ULL, 0x000fe200078e001aULL,
0x0000001500152220ULL, 0x008fc80000410000ULL, 0x0000000615067221ULL, 0x00cfe20000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x01064c00ff147984ULL, 0x000e620000000800ULL,
0x800000005e157824ULL, 0x000fca00078e00ffULL, 0x8000000014ff7812ULL, 0x002fe20007804815ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff147424ULL, 0x000fe400078e00ffULL, 0x800000005e167824ULL, 0x000fe400078e00ffULL,
0x0000001400157305ULL, 0x0002a4000021f000ULL, 0x3fa0000014147823ULL, 0x002fe200000100ffULL,
0x000000150000735dULL, 0x004fe40003800000ULL, 0x01064c00ff157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fc40007804816ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000005818783bULL, 0x000e620000004200ULL,
0x00000002ff6d7819ULL, 0x000fc6000001160aULL, 0x00000000563c783bULL, 0x000ea80000004200ULL,
0x00000000541c783bULL, 0x000ee80000004200ULL, 0x000000005314783bULL, 0x000f220000004200ULL,
0x00000018ff817819ULL, 0x002fe20000011418ULL, 0x00000100185d7824ULL, 0x040fe200078e00ffULL,
0x0000888018887816ULL, 0x040fe200000000ffULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011419ULL, 0x0000010019607824ULL, 0x040fe200078e00ffULL,
0x0000888019837816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x00000018ff5d7819ULL, 0x000fc4000001145dULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff7b7819ULL, 0x000fe4000001141aULL, 0x00000018ff6b7819ULL, 0x000fe2000001141bULL,
0x0000001800847306ULL, 0x0003e20000200c00ULL, 0x000088801a807816ULL, 0x000fe400000000ffULL,
0x000088801b687816ULL, 0x000fe400000000ffULL, 0x00000018ff757819ULL, 0x004fc4000001143cULL,
0x00000018ff5b7819ULL, 0x008fe2000001141cULL, 0x0000001900827306ULL, 0x0005e20000200c00ULL,
0x000001001b187824ULL, 0x042fe200078e00ffULL, 0x000088803c7a7816ULL, 0x000fe200000000ffULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000088801c667816ULL, 0x000fe400000000ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x0000005d00857306ULL, 0x0002e20000200c00ULL,
0x000001003c197824ULL, 0x044fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe2000001141bULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fc4000001141dULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018007d7306ULL, 0x0005e20000200c00ULL,
0x000001001a5d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x000088801d637816ULL, 0x000fe400000000ffULL,
0x00000018ff607819ULL, 0x000fe40000011460ULL, 0x0000001900797306ULL, 0x0003e20000200c00ULL,
0x000001003d187824ULL, 0x004fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fc4000001141aULL,
0x00000018ff697819ULL, 0x000fe4000001143eULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x0000001a007e7306ULL, 0x000fe20000200c00ULL, 0x000001003e197824ULL, 0x042fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x000088803e747816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fc40000011419ULL,
0x0000001800777306ULL, 0x0003e20000200c00ULL, 0x00000018ff597819ULL, 0x000fe4000001141eULL,
0x00000018ff677819ULL, 0x000fe4000001143fULL, 0x000088803f6e7816ULL, 0x040fe400000000ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000001900737306ULL, 0x0005e20000200c00ULL,
0x000001003f187824ULL, 0x042fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001143dULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x000088803d707816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x0000001b007c7306ULL, 0x000fe20000200c00ULL, 0x000001001c197824ULL, 0x044fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe4000001141fULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000001800717306ULL, 0x0003e20000200c00ULL, 0x00000018ff627819ULL, 0x000fe4000001141cULL,
0x00000000ff1c723eULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff577819ULL, 0x010fe20000011414ULL, 0x0000001900657306ULL, 0x0005e20000200c00ULL,
0x000001001d187824ULL, 0x042fe200078e00ffULL, 0x00000018ff567819ULL, 0x000fe20000011415ULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011416ULL,
0x00000018ff647819ULL, 0x000fe40000011418ULL, 0x0000b80055187811ULL, 0x000fe200078e20ffULL,
0x0000003c00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x000088801f557816ULL, 0x000fe400000000ffULL, 0x000000001818783bULL, 0x004fe20000000200ULL,
0x00000018ff537819ULL, 0x000fe40000011417ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x000054101c3c7816ULL, 0x002fe4000000001cULL, 0x000099105c1c7816ULL, 0x000fc600000000ffULL,
0x00001f6d3c6d7589ULL, 0x000e6200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x0000006000867306ULL, 0x0005220000200c00ULL, 0x00005410881c7816ULL, 0x008fe20000000085ULL,
0x00001f473c6a7589ULL, 0x000eec00000e0000ULL, 0x0000001d00617306ULL, 0x000be20000200c00ULL,
0x000088801e607816ULL, 0x004fce00000000ffULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000001001f1d7824ULL, 0x020fca00078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000005f005f7306ULL, 0x000f620000200c00ULL, 0x0000006d18188232ULL, 0x082fe40000000000ULL,
0x0000006d1a1a8232ULL, 0x000fca0000000000ULL, 0x0000005d007f7306ULL, 0x0003e20000200c00ULL,
0x0000006a19198232ULL, 0x088fe40000000000ULL, 0x0000006a1b1b8232ULL, 0x000fca0000000000ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x000001001e5d7824ULL, 0x042fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001145dULL,
0x0000006800687306ULL, 0x000e700000200c00ULL, 0x0000001d005c7306ULL, 0x0009f00000200c00ULL,
0x0000003e00727306ULL, 0x0007e20000200c00ULL, 0x00005410831d7816ULL, 0x010fce0000000086ULL,
0x0000007b007b7306ULL, 0x000f220000200c00ULL, 0x00000018ff3e7819ULL, 0x008fe2000001141eULL,
0x0000001c1838723cULL, 0x000fe20000001838ULL, 0x00008880141e7816ULL, 0x000fca00000000ffULL,
0x0000006b006b7306ULL, 0x000ee20000200c00ULL, 0x00005410841c7816ULL, 0x004fe20000000081ULL,
0x000000ffff3c7224ULL, 0x000fe200078e001eULL, 0x00005410821d7816ULL, 0x020fe2000000005fULL,
0x00000100141e7824ULL, 0x040fe200078e00ffULL, 0x0000888015817816ULL, 0x000fe200000000ffULL,
0x0001000014147824ULL, 0x000fe400078e00ffULL, 0x0000003f006c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe2000001141eULL, 0x0000001c1834723cULL, 0x000fe20000001834ULL,
0x00000018ff147819ULL, 0x000fca0000011414ULL, 0x0000003d00767306ULL, 0x0003e20000200c00ULL,
0x000100001f3f7824ULL, 0x004fe200078e00ffULL, 0x0000b800521f7811ULL, 0x000fc800078e20ffULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000003c00527306ULL, 0x0005e20000200c00ULL,
0x00005410683d7816ULL, 0x002fe2000000007dULL, 0x000000001f1c783bULL, 0x000e620000000200ULL,
0x00000100157d7824ULL, 0x000fca00078e00ffULL, 0x0000007a007a7306ULL, 0x000f620000200c00ULL,
0x00005410803c7816ULL, 0x004fce000000007fULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000003c1830723cULL, 0x000fee0000001830ULL, 0x000054107e3c7816ULL, 0x010fe2000000007bULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054107c3d7816ULL, 0x008fc4000000006bULL,
0x00000018ff6b7819ULL, 0x000fca000001147dULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x0000003c182c723cULL, 0x000fee000000182cULL, 0x000054107a3c7816ULL, 0x020fe20000000079ULL,
0x0000006900697306ULL, 0x000f220000200c00ULL, 0x00005410703d7816ULL, 0x004fe20000000077ULL,
0x0000006d1c1c8232ULL, 0x002fc40000000000ULL, 0x0000006d1e1e8232ULL, 0x000fe40000000000ULL,
0x0000006a1d1d8232ULL, 0x080fe40000000000ULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0000003c1828723cULL, 0x000fe20000001828ULL, 0x0000006a1f1f8232ULL, 0x000fcc0000000000ULL,
0x00010000153c7824ULL, 0x000fe200078e00ffULL, 0x0000001400707306ULL, 0x0005e20000200c00ULL,
0x0000541076157816ULL, 0x008fc6000000006fULL, 0x00000018ff6f7819ULL, 0x000fc8000001143cULL,
0x0000006600667306ULL, 0x000ee20000200c00ULL, 0x0000541078147816ULL, 0x004fce0000000075ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000141824723cULL, 0x000fee0000001824ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541072147816ULL, 0x010fe40000000069ULL,
0x000054106c157816ULL, 0x002fca0000000067ULL, 0x0000007400747306ULL, 0x000e640000200c00ULL,
0x000000141810723cULL, 0x000fec0000001810ULL, 0x0000006e006e7306ULL, 0x000f220000200c00ULL,
0x0000541066147816ULL, 0x008fe40000000065ULL, 0x0000541063157816ULL, 0x004fca0000000064ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00005410743c7816ULL, 0x002fe20000000073ULL,
0x000000141c38723cULL, 0x000fec0000001838ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054106e3d7816ULL, 0x010fe40000000071ULL, 0x00008880166e7816ULL, 0x000fca00000000ffULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x0000003c1820723cULL, 0x000fee0000001820ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541061157816ULL, 0x002fe2000000005aULL,
0x00000100163d7824ULL, 0x000fe200078e00ffULL, 0x0000888017187816ULL, 0x040fe200000000ffULL,
0x00000100171a7824ULL, 0x000fc400078e00ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe2000001143dULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000541062147816ULL, 0x004fe2000000005bULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000000ffff3c7224ULL, 0x000fe200078e006eULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000000141c34723cULL, 0x000fee0000001834ULL,
0x0000541060147816ULL, 0x002fe2000000005dULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541055157816ULL, 0x004fce000000005cULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000000141c30723cULL, 0x000fee0000001830ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000005600567306ULL, 0x000ff00000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x00005410706e7816ULL, 0x002fce0000000057ULL, 0x0000003f003f7306ULL, 0x000e700000200c00ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x000054103e3e7816ULL, 0x004fce0000000059ULL,
0x0000008100687306ULL, 0x000fe20000200c00ULL, 0x000054103f3f7816ULL, 0x002fce0000000058ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x00005410526a7816ULL, 0x008fe2000000005fULL,
0x0000003e1c2c723cULL, 0x000fec000000182cULL, 0x0000006f006f7306ULL, 0x000eb00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00005410686b7816ULL, 0x002fce000000006bULL,
0x0000001900197306ULL, 0x000e620000200c00ULL, 0x000054106f6f7816ULL, 0x004fe20000000056ULL,
0x0000006a1c28723cULL, 0x040fec0000001828ULL, 0x0000001800187306ULL, 0x000fe40000200c00ULL,
0x0000006e1c24723cULL, 0x000fec0000001824ULL, 0x0000001a003d7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fce0000000019ULL, 0x0000005400547306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00005410183d7816ULL, 0x004fce000000003dULL,
0x0000001600157306ULL, 0x000e620000200c00ULL, 0x0000003c1c20723cULL, 0x000fee0000001820ULL,
0x0000001700147306ULL, 0x000ea20000200c00ULL, 0x0000541015527816ULL, 0x002fe40000000054ULL,
0x0000541014537816ULL, 0x004fce0000000053ULL, 0x000000521c1c723cULL, 0x000fe20000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x01065800ffff7f8cULL, 0x000fe8000c80043fULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000c000001947ULL, 0x000fea0003800000ULL,
0x01065c00ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01065c00ff117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007820cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000003000e107a10ULL, 0x000fe20007ffe0ffULL, 0x00000100ff1b7424ULL, 0x000fe200078e00ffULL,
0x00000004ff197819ULL, 0x000fc6000001160aULL, 0x0000010010117824ULL, 0x040fe200078e00ffULL,
0x0000000110107810ULL, 0x000fc60007ffe0ffULL, 0x0000620009157a24ULL, 0x000fe200078e0211ULL,
0x000000110c127217ULL, 0x000fe40007800000ULL, 0x0000000b1000720cULL, 0x000fe20003f26070ULL,
0x0000000146107824ULL, 0x000fe400078e0215ULL, 0x0000000112127824ULL, 0x000fe400078e0a11ULL,
0x00005e0010107625ULL, 0x000fc600078e001bULL, 0x0000002012137807ULL, 0x000fe20000800000ULL,
0x0000000142127824ULL, 0x100fe200078e0215ULL, 0x0000004410167210ULL, 0x000fe20007f3e0ffULL,
0x0000000140107824ULL, 0x000fe200078e0215ULL, 0x0000001308177217ULL, 0x000fe20007800000ULL,
0x00005e0012127625ULL, 0x000fc800078e001bULL, 0x0000000117187824ULL, 0x000fe200078e0a08ULL,
0x0000004412127210ULL, 0x000fe20007f7e0ffULL, 0x000000010f157824ULL, 0x000fe400078e0215ULL,
0x000000ffff177224ULL, 0x000fe200008e0611ULL, 0x000000181900720cULL, 0x080fe20003f46070ULL,
0x00005e0010107625ULL, 0x080fe200078e001bULL, 0x000000184500720cULL, 0x080fe40003f26070ULL,
0x000000184100720cULL, 0x000fe20003f86070ULL, 0x00005e0015147625ULL, 0x000fe200078e001bULL,
0x0000004410107210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0613ULL,
0x000000184300720cULL, 0x000fe20003f66070ULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x0000004414447210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016507faeULL, 0x0003e8000d101c46ULL, 0x000000ffff457224ULL, 0x000fe200030e0615ULL,
0x00000000124f7faeULL, 0x0003ea000c901c46ULL, 0x00000000104e7faeULL, 0x0003e8000d901c46ULL,
0x00000000444d7faeULL, 0x0003e8000e101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01064800ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01065400ff0f7984ULL, 0x000ea20000000800ULL, 0x800000005e107824ULL, 0x002fca00078e00ffULL,
0x800000000fff7812ULL, 0x004fe20007824810ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01065400ff0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007824810ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x800000005e117824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0f7424ULL, 0x000fc800078e00ffULL, 0x0000000f00107305ULL, 0x0002a4000021f000ULL,
0x3fa000000f0f7823ULL, 0x002fe200000100ffULL, 0x000000100000735dULL, 0x004fe40003800000ULL,
0x01065400ff107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fc40007824811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000005110783bULL, 0x000e620000004200ULL, 0x00000002ff557819ULL, 0x000fc6000001160aULL,
0x000000004c18783bULL, 0x000ea80000004200ULL, 0x000000004814783bULL, 0x0007e80000004200ULL,
0x00000000493c783bULL, 0x0009620000004200ULL, 0x00000018ff6e7819ULL, 0x002fe20000011410ULL,
0x0000010010487824ULL, 0x048fe200078e00ffULL, 0x0000888010717816ULL, 0x040fe200000000ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011411ULL,
0x0000010011497824ULL, 0x050fe200078e00ffULL, 0x0000888011727816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x004fc40000011418ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000888018667816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011419ULL, 0x00000010006f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff537819ULL, 0x000fe4000001141aULL, 0x00000018ff527819ULL, 0x000fe4000001141bULL,
0x0000888019637816ULL, 0x000fc400000000ffULL, 0x000088801a5f7816ULL, 0x000fe200000000ffULL,
0x0000001100707306ULL, 0x0005e20000200c00ULL, 0x0000010013107824ULL, 0x002fe200078e00ffULL,
0x000088801b5a7816ULL, 0x000fe400000000ffULL, 0x00000018ff487819ULL, 0x000fe40000011448ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000004800747306ULL, 0x0003e20000200c00ULL,
0x0000010018117824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011412ULL,
0x0001000018187824ULL, 0x000fe200078e00ffULL, 0x00008880126b7816ULL, 0x000fc400000000ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000010006c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000010012487824ULL, 0x042fe200078e00ffULL,
0x0000888013577816ULL, 0x040fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe20000011413ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000001100657306ULL, 0x0003e20000200c00ULL,
0x0000010019107824ULL, 0x044fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001800617306ULL, 0x0005e20000200c00ULL,
0x000001001a117824ULL, 0x042fe200078e00ffULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe40000011449ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001000647306ULL, 0x0003e20000200c00ULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x0000b8004b187811ULL, 0x004fe400078e20ffULL,
0x00000018ff457819ULL, 0x020fe4000001143cULL, 0x000088803c507816ULL, 0x000fe200000000ffULL,
0x00000011005e7306ULL, 0x0005e20000200c00ULL, 0x000001001b107824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe2000001143eULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011414ULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff1b7819ULL, 0x000fe2000001141bULL, 0x000001003c117824ULL, 0x044fe200078e00ffULL,
0x0000001900627306ULL, 0x000fe20000200c00ULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe4000001143dULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000001a005c7306ULL, 0x000fe20000200c00ULL,
0x000088803d517816ULL, 0x000fc400000000ffULL, 0x00000018ff447819ULL, 0x000fe4000001143fULL,
0x00000018ff417819ULL, 0x000fe40000011415ULL, 0x00000018ff407819ULL, 0x000fe20000011416ULL,
0x0000001b00597306ULL, 0x0003e20000200c00ULL, 0x00000018ff0f7819ULL, 0x000fce0000011417ULL,
0x00000011004f7306ULL, 0x0005e20000200c00ULL, 0x000000001818783bULL, 0x002fee0000000200ULL,
0x0000001200697306ULL, 0x0003e20000200c00ULL, 0x00000000ff11723eULL, 0x004fce00000000ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x0000541011127816ULL, 0x002fe20000000011ULL,
0x000001003f117824ULL, 0x000fc800078e00ffULL, 0x00001f5512557589ULL, 0x000e6200000e0000ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000004800567306ULL, 0x0004e40000200c00ULL,
0x00001f4712587589ULL, 0x00096c00000e0000ULL, 0x0000005700577306ULL, 0x000f620000200c00ULL,
0x000088803e487816ULL, 0x004fc400000000ffULL, 0x0000b8004a127811ULL, 0x010fe200078e20ffULL,
0x00000100154a7824ULL, 0x040fe200078e00ffULL, 0x0000888015477816ULL, 0x000fc600000000ffULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000054106b567816ULL, 0x008fe40000000056ULL,
0x00000018ff4a7819ULL, 0x000fe2000001144aULL, 0x0000005518188232ULL, 0x002fc80000000000ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000000551a1a8232ULL, 0x000fe20000000000ULL,
0x0000541057577816ULL, 0x020fe2000000006cULL, 0x0000005819198232ULL, 0x080fe40000000000ULL,
0x000000581b1b8232ULL, 0x000fc60000000000ULL, 0x00000013006a7306ULL, 0x0002e80000200c00ULL,
0x000000561830723cULL, 0x000fe80000001830ULL, 0x00000010005d7306ULL, 0x0009e20000200c00ULL,
0x0000010014137824ULL, 0x002fe400078e00ffULL, 0x0000541069567816ULL, 0x004fca0000000068ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000001003d107824ULL, 0x050fe200078e00ffULL,
0x000054106a577816ULL, 0x008fe20000000067ULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000004900737306ULL, 0x0003e20000200c00ULL,
0x00000056182c723cULL, 0x000fe2000000182cULL, 0x00000018ff3d7819ULL, 0x000fcc000001143dULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x000088803f497816ULL, 0x042fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fcc00078e00ffULL, 0x0000006300637306ULL, 0x000e700000200c00ULL,
0x0000001000547306ULL, 0x0007e20000200c00ULL, 0x0000541066567816ULL, 0x004fce0000000065ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x000001003e107824ULL, 0x048fe200078e00ffULL,
0x0000541063577816ULL, 0x002fe20000000064ULL, 0x000100003e3e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000000561828723cULL, 0x000fee0000001828ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0001000015567824ULL, 0x000fce00078e00ffULL, 0x0000005b005b7306ULL, 0x000e700000200c00ULL,
0x0000003c004e7306ULL, 0x0005f00000200c00ULL, 0x00000010004b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff3c7819ULL, 0x004fc4000001143eULL, 0x00008880143e7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000541062157816ULL, 0x002fe4000000005bULL,
0x00008880165b7816ULL, 0x000fe200000000ffULL, 0x00000011004c7306ULL, 0x0003e20000200c00ULL,
0x0000541071107816ULL, 0x008fe40000000074ULL, 0x00000018ff147819ULL, 0x000fca0000011414ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000541072117816ULL, 0x002fce0000000073ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000000101838723cULL, 0x000fee0000001838ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000054106f107816ULL, 0x000fe4000000006eULL,
0x0000541070117816ULL, 0x000fc4000000006dULL, 0x000054105a577816ULL, 0x004fc6000000005dULL,
0x0000005f005f7306ULL, 0x000e640000200c00ULL, 0x000000101834723cULL, 0x000fec0000001834ULL,
0x0000001400637306ULL, 0x0005f00000200c00ULL, 0x0000003d004d7306ULL, 0x0007e20000200c00ULL,
0x0000541061147816ULL, 0x004fce0000000060ULL, 0x000000141824723cULL, 0x000fe20000001824ULL,
0x00000018ff3d7819ULL, 0x008fe2000001143fULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe40000011413ULL, 0x000000001210783bULL, 0x000ea40000000200ULL,
0x00000018ff157819ULL, 0x000fe40000011456ULL, 0x000054105f567816ULL, 0x002fe2000000005eULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054105c147816ULL, 0x000fe20000000053ULL,
0x0000010016537824ULL, 0x000fc400078e00ffULL, 0x0001000016167824ULL, 0x000fe400078e00ffULL,
0x000000561820723cULL, 0x000fe40000001820ULL, 0x00000015005a7306ULL, 0x0007e20000200c00ULL,
0x00000018ff167819ULL, 0x000fce0000011416ULL, 0x0000003c003c7306ULL, 0x000f220000200c00ULL,
0x0000541059157816ULL, 0x008fe20000000052ULL, 0x000000ffff527224ULL, 0x000fe200078e005bULL,
0x0000541050507816ULL, 0x002fca000000004fULL, 0x00000014181c723cULL, 0x000fe2000000181cULL,
0x0000003e003e7306ULL, 0x000fec0000200c00ULL, 0x0000010017187824ULL, 0x040fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011453ULL, 0x0001000017197824ULL, 0x040fe200078e00ffULL,
0x0000888017147816ULL, 0x000fe200000000ffULL, 0x0000003f003f7306ULL, 0x000e620000200c00ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000005510108232ULL, 0x084fe20000000000ULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x0000005512128232ULL, 0x000fe20000000000ULL,
0x000054103c3c7816ULL, 0x010fe20000000043ULL, 0x0000005811118232ULL, 0x000fc40000000000ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x0000005813138232ULL, 0x000fce0000000000ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000054103e3e7816ULL, 0x002fce000000003fULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x000054104e4e7816ULL, 0x004fce0000000045ULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x000054104d4f7816ULL, 0x008fce0000000046ULL,
0x0000004100417306ULL, 0x000ea20000200c00ULL, 0x0000004e1034723cULL, 0x000fee0000001834ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000541063427816ULL, 0x002fce0000000042ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000054105a437816ULL, 0x004fce0000000041ULL,
0x0000004900497306ULL, 0x000ea20000200c00ULL, 0x0000541051517816ULL, 0x008fe20000000054ULL,
0x000000421024723cULL, 0x040fec0000001824ULL, 0x0000003d003d7306ULL, 0x000ee20000200c00ULL,
0x0000541048487816ULL, 0x002fe2000000004bULL, 0x000000501038723cULL, 0x000fec0000001838ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000541049497816ULL, 0x004fce000000004cULL,
0x0000004a004a7306ULL, 0x000e620000200c00ULL, 0x000054103d3d7816ULL, 0x008fe20000000044ULL,
0x000000481030723cULL, 0x040fec0000001830ULL, 0x0000005200527306ULL, 0x000fe40000200c00ULL,
0x0000003c102c723cULL, 0x000fec000000182cULL, 0x0000001500157306ULL, 0x000ea20000200c00ULL,
0x00005410473f7816ULL, 0x002fce000000004aULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x0000003e1028723cULL, 0x000fee0000001828ULL, 0x0000001800537306ULL, 0x000e620000200c00ULL,
0x0000541052527816ULL, 0x004fce0000000015ULL, 0x0000004000407306ULL, 0x000ff00000200c00ULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x0000541014537816ULL, 0x002fce0000000053ULL,
0x0000001600177306ULL, 0x000e620000200c00ULL, 0x000000521020723cULL, 0x000fee0000001820ULL,
0x0000001900187306ULL, 0x000ea20000200c00ULL, 0x0000541017407816ULL, 0x002fe40000000040ULL,
0x0000541018417816ULL, 0x004fce000000000fULL, 0x000000401010723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01065800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01064000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ff02ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff5f7807ULL, 0x000fe40004000000ULL, 0x000003000e0e7a10ULL, 0x000fe40007ffe0ffULL,
0x000000ff04ff7812ULL, 0x000fe4000780c0ffULL, 0x0000000b0e00720cULL, 0x000fe40003f26070ULL,
0x00000001ff047807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff479000007947ULL, 0x000fea000383ffffULL, 0x00000000000c7919ULL, 0x000ea40000002500ULL,
0x0000000b0c00720cULL, 0x004fda0003f06070ULL, 0x0000037000000947ULL, 0x000fea0003800000ULL,
0x0180000006007810ULL, 0x002fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000c6f000057802ULL, 0x000fe40000000f00ULL,
0x000083d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x000fe200078e0009ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000600037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000006ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000ea8000c1e9900ULL, 0x0000000000057919ULL, 0x000ee40000000000ULL,
0x00000002ff097819ULL, 0x008fe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x004fca0000410000ULL, 0x00001f0900047589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000003804387220ULL, 0x044fe20000410000ULL,
0x0000003904397220ULL, 0x040fe20000410000ULL, 0x0000003404347220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002804287220ULL, 0x040fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x000fe20000410000ULL, 0x0000003a053a7220ULL, 0x048fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000001305137220ULL, 0x000fe20000410000ULL, 0x0000000000167919ULL, 0x000ea20000000000ULL,
0x000000282928723eULL, 0x000fc400000000ffULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000101110723eULL, 0x000fe400000000ffULL,
0x000000363736723eULL, 0x000fe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fc400000000ffULL,
0x000000121311723eULL, 0x000fe400000000ffULL, 0x0000000216007812ULL, 0x006fe400078ec0ffULL,
0x00000002ff157819ULL, 0x000fe40000011616ULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000000200037811ULL, 0x040fe400078ff8ffULL, 0x0000000400097811ULL, 0x000fc400078ff8ffULL,
0x00000006000e7811ULL, 0x000fe400078ff8ffULL, 0x00000008161d7811ULL, 0x000fe400078ff0ffULL,
0x0000000702007812ULL, 0x140fe400078e7815ULL, 0x00000007090a7812ULL, 0x040fe400078e7815ULL,
0x0000000709097812ULL, 0x000fe200078e781dULL, 0x0000000815057824ULL, 0x000fe200078e0200ULL,
0x0000000703047812ULL, 0x000fe200078e7815ULL, 0x000008000d007824ULL, 0x000fe200078e00ffULL,
0x0000000702027812ULL, 0x000fe200078e781dULL, 0x000000081d1b7824ULL, 0x000fe200078e0209ULL,
0x0000000703037812ULL, 0x000fe200078e781dULL, 0x00000008150b7824ULL, 0x040fe200078e0204ULL,
0x000000070e147812ULL, 0x000fe200078e7815ULL, 0x0000000816097824ULL, 0x000fe200078e00ffULL,
0x0000a00000047810ULL, 0x000fe20007ffe0ffULL, 0x00000008150f7824ULL, 0x000fe200078e020aULL,
0x000000070e0e7812ULL, 0x000fe200078e781dULL, 0x000000081d177824ULL, 0x000fe200078e0202ULL,
0x00000008090a7812ULL, 0x000fe200078ec0ffULL, 0x000000081d197824ULL, 0x000fe200078e0203ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x000000343503723eULL, 0x000fe200000000ffULL, 0x0000000815157824ULL, 0x000fe200078e0214ULL,
0x000000242514723eULL, 0x000fe200000000ffULL, 0x000000081d1d7824ULL, 0x000fe200078e020eULL,
0x00005410021e7816ULL, 0x140fe20000000003ULL, 0x000000100b097824ULL, 0x000fe200078e0204ULL,
0x00007632021f7816ULL, 0x000fe20000000003ULL, 0x00000001050b7824ULL, 0x000fe200078e020aULL,
0x000000303105723eULL, 0x000fe200000000ffULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x0000003a3b02723eULL, 0x000fe200000000ffULL, 0x0000001019197824ULL, 0x100fe200078e0204ULL,
0x0000001e0b007388ULL, 0x0003e20000000a00ULL, 0x000000100f0f7824ULL, 0x000fc400078e0204ULL,
0x0000001015157824ULL, 0x100fe400078e0204ULL, 0x000000101b1b7824ULL, 0x100fe400078e0204ULL,
0x000000101d1d7824ULL, 0x000fe400078e0204ULL, 0x000000010a0e7824ULL, 0x040fe200078e0209ULL,
0x0000002c2d09723eULL, 0x000fe200000000ffULL, 0x000000010a177824ULL, 0x040fe400078e0217ULL,
0x000000010a187824ULL, 0x040fe200078e0219ULL, 0x00007632050b7816ULL, 0x002fe20000000009ULL,
0x000000010a0f7824ULL, 0x040fe200078e020fULL, 0x0000002e2f19723eULL, 0x000fe200000000ffULL,
0x000000010a167824ULL, 0x040fe200078e0215ULL, 0x000000262715723eULL, 0x000fe200000000ffULL,
0x000000010a1b7824ULL, 0x000fe200078e021bULL, 0x0000763232037816ULL, 0x000fe20000000019ULL,
0x000000010a1d7824ULL, 0x000fe200078e021dULL, 0x00005410050a7816ULL, 0x000fe20000000009ULL,
0x00000300ff097624ULL, 0x000fc800078e00ffULL, 0x0000000a0e007388ULL, 0x0003e20000000a00ULL,
0x000000010900780cULL, 0x000fe40003f05270ULL, 0x00005410280a7816ULL, 0x142fe40000000014ULL,
0x00007632280b7816ULL, 0x000fe40000000014ULL, 0x000054102a147816ULL, 0x140fe40000000015ULL,
0x000076322a157816ULL, 0x000fe20000000015ULL, 0x0000000a0f007388ULL, 0x0003e40000000a00ULL,
0x00005410200a7816ULL, 0x002fc40000000010ULL, 0x00007632200b7816ULL, 0x000fe40000000010ULL,
0x0000541022107816ULL, 0x140fe40000000011ULL, 0x0000763222117816ULL, 0x000fe20000000011ULL,
0x0000000a16007388ULL, 0x0003e40000000a00ULL, 0x00005410020a7816ULL, 0x142fe40000000036ULL,
0x00007632020b7816ULL, 0x000fe40000000036ULL, 0x0000541032027816ULL, 0x000fc60000000019ULL,
0x0000000a17007388ULL, 0x0003e80000000a00ULL, 0x0000000218007388ULL, 0x0003e80000000a00ULL,
0x000000141b007388ULL, 0x0003e80000000a00ULL, 0x000000101d007388ULL, 0x0003e20000000a00ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002cb000008947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x002e620000000000ULL, 0x0000580009037a24ULL, 0x000fe200078e02ffULL,
0x000000ff0d00720cULL, 0x000fe20003f25270ULL, 0x00002000ff0f7424ULL, 0x000fe200078e00ffULL,
0x00000000000b7919ULL, 0x000ea20000002700ULL, 0x0000640003057a24ULL, 0x000fc600078e02ffULL,
0x00000000000a7919ULL, 0x000ea20000002600ULL, 0x0000001002207824ULL, 0x042fe200078e0200ULL,
0x0000002002257810ULL, 0x040fe40007ffe0ffULL, 0x0000004002277810ULL, 0x040fe40007ffe0ffULL,
0x00a0000020107984ULL, 0x0002e20000000c00ULL, 0x0000006002297810ULL, 0x000fe20007ffe0ffULL,
0x000058000b0b7a24ULL, 0x004fe400078e020aULL, 0x00a2000020147984ULL, 0x0002a20000000c00ULL,
0x00001fff050a7811ULL, 0x000fe200078e40ffULL, 0x000003000b037a24ULL, 0x000fc400078e02ffULL,
0x00a4000020187984ULL, 0x0003220000000c00ULL, 0x000000ff0200720cULL, 0x000fe20003f05270ULL,
0x0000000103217824ULL, 0x000fe400078e020cULL, 0x00a60000201c7984ULL, 0x0002620000000c00ULL,
0x000000ff0d00720cULL, 0x000fe40000705670ULL, 0x01ffffff050c7812ULL, 0x000fe400078ec0ffULL,
0x000000210a0e7211ULL, 0x000fca00078f98ffULL, 0x00006a000e0e7625ULL, 0x000fcc00078e000fULL,
0x000008000d0e7825ULL, 0x000fcc00078e000eULL, 0x0000001025247825ULL, 0x000fc800078e000eULL,
0x0000001027267825ULL, 0x000fc800078e000eULL, 0x0000001029287825ULL, 0x000fc800078e000eULL,
0x0000001002227825ULL, 0x000fe200078e000eULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x00000000000e7919ULL, 0x00cea20000000000ULL, 0x00000080ff057424ULL, 0x000fe400078e00ffULL,
0x0000000121207824ULL, 0x042fe400078e020cULL, 0x000000100e2a7824ULL, 0x004fe200078e00ffULL,
0x00000001ff2b7819ULL, 0x000fe2000001160eULL, 0x00006a00210e7625ULL, 0x000fc600078e0005ULL,
0x0000000c2b2b7812ULL, 0x000fe200078ec0ffULL, 0x00006a0020207625ULL, 0x000fe200078e0005ULL,
0x000000702a057812ULL, 0x000fc800078ec0ffULL, 0x0000000e2b0e7210ULL, 0x140fe40007b5e005ULL,
0x000000202b207210ULL, 0x000fe40007d9e005ULL, 0x0000000fff0f7210ULL, 0x000fe400017e64ffULL,
0x00000021ff217210ULL, 0x000fc600027ea4ffULL, 0x000000070e007986ULL, 0x0003e8000c101906ULL,
0x0000000620007986ULL, 0x0003e4000c101906ULL, 0x0000001022007986ULL, 0x00c5e2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000001424007986ULL, 0x0005e8000c101d06ULL,
0x0000001826007986ULL, 0x0105e8000c101d06ULL, 0x0000001c28007986ULL, 0x0025e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0xffffffff09057810ULL, 0x000fc60007ffe0ffULL,
0x000068000b067625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000005060679a8ULL, 0x000ee400099ee1c6ULL,
0x000000050600720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff0b7807ULL, 0x000fca0000000000ULL, 0x0000000bff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff057984ULL, 0x000ee40000000000ULL, 0x000000ff0500720cULL, 0x008fda0003f05270ULL,
0x0000284000008947ULL, 0x000fea0003800000ULL, 0x00000d1000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x00000001ff067819ULL, 0x000fe20000011602ULL, 0x0000001002057824ULL, 0x000fe200078e00ffULL,
0x00000001030e7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff197424ULL, 0x004fe200078e00ffULL,
0x0000000c061a7812ULL, 0x000fe400078ec0ffULL, 0x00000070050b7812ULL, 0x002fe200078ec0ffULL,
0x00006a0003067625ULL, 0x000fc800078e0019ULL, 0x00006a000e0e7625ULL, 0x000fe200078e0019ULL,
0x000000061a107210ULL, 0x000fc8000791e00bULL, 0x0000000e1a067210ULL, 0x000fe40007b5e00bULL,
0x00000007ff117210ULL, 0x000fe400007e24ffULL, 0x0000000fff077210ULL, 0x000fc600017e64ffULL,
0x0000000610057981ULL, 0x000368000c1e1900ULL, 0x0000000606067981ULL, 0x000362000c1e1900ULL,
0x000000020900780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002030e7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000e0e7625ULL, 0x000fca00078e0019ULL,
0x0000000e1a0e7210ULL, 0x000fc8000791e00bULL, 0x0000000fff0f7210ULL, 0x000fca00007e24ffULL,
0x000000060e0e7981ULL, 0x000362000c1e1900ULL, 0x000000040900780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000303107810ULL, 0x002fca0007ffe0ffULL,
0x00006a0010107625ULL, 0x000fca00078e0019ULL, 0x000000101a107210ULL, 0x000fc8000791e00bULL,
0x00000011ff117210ULL, 0x000fca00007e24ffULL, 0x0000000610107981ULL, 0x000362000c1e1900ULL,
0x000000040900780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000403127810ULL, 0x002fca0007ffe0ffULL, 0x00006a0012127625ULL, 0x000fca00078e0019ULL,
0x000000121a127210ULL, 0x000fc8000791e00bULL, 0x00000013ff137210ULL, 0x000fca00007e24ffULL,
0x0000000612127981ULL, 0x000362000c1e1900ULL, 0x000000060900780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000503147810ULL, 0x002fca0007ffe0ffULL,
0x00006a0014147625ULL, 0x000fca00078e0019ULL, 0x000000141a147210ULL, 0x000fc8000791e00bULL,
0x00000015ff157210ULL, 0x000fca00007e24ffULL, 0x0000000614147981ULL, 0x000362000c1e1900ULL,
0x000000060900780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000080900780cULL, 0x002fe40003f06070ULL, 0x0000000603167810ULL, 0x000fca0007ffe0ffULL,
0x00006a0016167625ULL, 0x000fca00078e0019ULL, 0x000000161a167210ULL, 0x000fe40007a3e00bULL,
0x0000000703180810ULL, 0x000fe40007ffe0ffULL, 0x00000017ff177210ULL, 0x000fc60000fe44ffULL,
0x00006a0018180625ULL, 0x000fca00078e0019ULL, 0x000000181a180210ULL, 0x000fe40007c7e00bULL,
0x00000006161a7981ULL, 0x000364000c1e1900ULL, 0x00000019ff190210ULL, 0x000fca0001fe84ffULL,
0x0000000618180981ULL, 0x000368000c1e1900ULL, 0x0000000709097810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff097819ULL, 0x000fc80000011609ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000008d000008947ULL, 0x000fea0003800000ULL, 0x000000ffff1c7224ULL, 0x004fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x020fe400078e0005ULL, 0x000000081c0b7824ULL, 0x040fe200078e00ffULL,
0x000000011c1c7810ULL, 0x000fc80007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000000091c00720cULL, 0x000fd60003f06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080b167810ULL, 0x040fe40007ffe0ffULL, 0x000000010b077810ULL, 0x000fe40007ffe0ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001e05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103167824ULL, 0x000fe200078e0216ULL, 0x00000001ff0f7819ULL, 0x000fe20000011602ULL,
0x00000080ff177424ULL, 0x000fe400078e00ffULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006a0016167625ULL, 0x000fc600078e0017ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x000000160f167210ULL, 0x000fc80007b3e007ULL,
0x00000017ff177210ULL, 0x000fca0000fe64ffULL, 0x00000006161e7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090b167810ULL, 0x042fe40007ffe0ffULL,
0x000000020b077810ULL, 0x000fe40007ffe0ffULL, 0x0000030016007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000605057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103067824ULL, 0x000fe200078e0216ULL,
0x00000001ff117819ULL, 0x000fe20000011602ULL, 0x00000080ff077424ULL, 0x000fe400078e00ffULL,
0x00000010020f7824ULL, 0x000fe200078e00ffULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x00006a0006067625ULL, 0x000fc600078e0007ULL, 0x000000700f0f7812ULL, 0x000fc800078ec0ffULL,
0x0000000611067210ULL, 0x000fc80007b3e00fULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606067981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0b167810ULL, 0x040fe40007ffe0ffULL, 0x000000030b077810ULL, 0x002fe40007ffe0ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000e05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001030e7824ULL, 0x000fe200078e0216ULL, 0x00000001ff117819ULL, 0x000fe20000011602ULL,
0x00000080ff0f7424ULL, 0x000fe400078e00ffULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x00006a000e0e7625ULL, 0x000fc600078e000fULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x0000000e110e7210ULL, 0x000fc80007b3e007ULL,
0x0000000fff0f7210ULL, 0x000fca0000fe64ffULL, 0x000000060e0e7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0b167810ULL, 0x040fe40007ffe0ffULL,
0x000000040b077810ULL, 0x000fe40007ffe0ffULL, 0x0000030016007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001005057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103107824ULL, 0x000fe200078e0216ULL,
0x00000001ff0f7819ULL, 0x002fe20000011602ULL, 0x00000080ff117424ULL, 0x000fe400078e00ffULL,
0x0000001002077824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006a0010107625ULL, 0x000fc600078e0011ULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x000000100f107210ULL, 0x000fc80007b3e007ULL, 0x00000011ff117210ULL, 0x000fca0000fe64ffULL,
0x0000000610107981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0b167810ULL, 0x040fe40007ffe0ffULL, 0x000000050b077810ULL, 0x000fe40007ffe0ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103127824ULL, 0x000fe200078e0216ULL, 0x00000001ff0f7819ULL, 0x002fe20000011602ULL,
0x00000080ff137424ULL, 0x000fe400078e00ffULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006a0012127625ULL, 0x000fc600078e0013ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x000000120f127210ULL, 0x000fc80007b3e007ULL,
0x00000013ff137210ULL, 0x000fca0000fe64ffULL, 0x0000000612127981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0b167810ULL, 0x040fe40007ffe0ffULL,
0x000000060b077810ULL, 0x000fe40007ffe0ffULL, 0x0000030016007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001405057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103147824ULL, 0x000fe200078e0216ULL,
0x00000001ff0f7819ULL, 0x002fe20000011602ULL, 0x00000080ff157424ULL, 0x000fe400078e00ffULL,
0x0000001002077824ULL, 0x000fe200078e00ffULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x00006a0014147625ULL, 0x000fc600078e0015ULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x000000140f147210ULL, 0x000fc80007b3e007ULL, 0x00000015ff157210ULL, 0x000fca0000fe64ffULL,
0x0000000614147981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0b167810ULL, 0x040fe40007ffe0ffULL, 0x000000070b077810ULL, 0x000fe40007ffe0ffULL,
0x0000030016007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001a05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000103167824ULL, 0x000fe200078e0216ULL, 0x00000001ff0f7819ULL, 0x002fe20000011602ULL,
0x00000080ff177424ULL, 0x000fe400078e00ffULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x00006a0016167625ULL, 0x000fc600078e0017ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x000000160f167210ULL, 0x000fc80007b3e007ULL,
0x00000017ff177210ULL, 0x000fca0000fe64ffULL, 0x00000006161a7981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0b167810ULL, 0x002fe40007ffe0ffULL,
0x0000001805057209ULL, 0x000fe40007810000ULL, 0x0000030016007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000103167824ULL, 0x000fe200078e0216ULL,
0x00000001ff0b7819ULL, 0x000fe20000011602ULL, 0x00000080ff177424ULL, 0x000fe400078e00ffULL,
0x0000001002077824ULL, 0x000fe200078e00ffULL, 0x0000000c0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00006a0016167625ULL, 0x000fc600078e0017ULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x000000160b167210ULL, 0x000fc80007a3e007ULL, 0x00000017ff177210ULL, 0x000fca0000fe44ffULL,
0x0000000616187981ULL, 0x000368000c1e1900ULL, 0xfffff75000008947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000ee40000000000ULL, 0x0000001002067824ULL, 0x028fe200078e00ffULL,
0x00000001ff077819ULL, 0x002fc80000011602ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106067824ULL, 0x000fca00078e0207ULL,
0x0000000506007388ULL, 0x0003e40000000800ULL, 0x000000030a0e7211ULL, 0x000fe200078f98ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00002000ff0f7424ULL, 0x000fe200078e00ffULL,
0x000000070200780cULL, 0x040fe20003f04070ULL, 0x0000001002077824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011602ULL, 0x00006a000e0e7625ULL, 0x000fe200078e000fULL,
0x00000015ff067819ULL, 0x002fe2000001160dULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000007007077812ULL, 0x000fe200078ec0ffULL, 0x000008000d057824ULL, 0x000fe200078e00ffULL,
0x0000000c09107812ULL, 0x004fe200078ec0ffULL, 0x000000ffff0b7224ULL, 0x000fe200078e00ffULL,
0x0000002002117810ULL, 0x000fe20007ffe0ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x000000050e0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000103168824ULL, 0x000fe200078e020cULL,
0x0000004002137810ULL, 0x040fe20007ffe0ffULL, 0x00000080ff178424ULL, 0x000fe200078e00ffULL,
0x0000006002157810ULL, 0x000fe20007ffe0ffULL, 0x0000000107097824ULL, 0x000fe200078e0210ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000010f0f7824ULL, 0x000fe200008e0606ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff188424ULL, 0x000fe200078e00ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x000010000d077824ULL, 0x000fe200078e00ffULL,
0x0000000009097984ULL, 0x000e620000000800ULL, 0x00006a0016168625ULL, 0x000fe200078e0017ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000001011107825ULL, 0x000fc800078e000eULL,
0x0000001013127825ULL, 0x000fc800078e000eULL, 0x0000001015147825ULL, 0x000fc800078e000eULL,
0x000000100d1f8824ULL, 0x000fe400078e0202ULL, 0x00006a0003188625ULL, 0x000fc600078e0018ULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x00000010021b7824ULL, 0x040fe400078e0207ULL,
0x00000010020e7825ULL, 0x000fc800078e000eULL, 0x000000100d258824ULL, 0x000fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e1b7faeULL, 0x0005e2000b901c46ULL,
0x0000001002168825ULL, 0x000fc600078e0016ULL, 0x0000418025258811ULL, 0x000fe200078e20ffULL,
0x0000001002188825ULL, 0x000fe200078e0018ULL, 0x00380000101b7faeULL, 0x0007e8000b901c46ULL,
0x00580000121b7faeULL, 0x0009e2000b901c46ULL, 0x00000000000e7805ULL, 0x004fc6000001ff00ULL,
0x00780000141b7faeULL, 0x0005e8000b901c46ULL, 0x00000000161f8faeULL, 0x000be2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x0000000018258faeULL, 0x0007e2000b901c46ULL,
0x0000000000127805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000147805ULL, 0x004fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x020fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x008fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000d6000009947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x002fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fca00078e00ffULL, 0x000000012f2e7810ULL, 0x000fc80007ffe0ffULL,
0x000003002e007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x0000000103417824ULL, 0x000fe200078e022eULL, 0x000000070200780cULL, 0x000fe20003f24070ULL,
0x00002000ff317424ULL, 0x000fe200078e00ffULL, 0x000000012e347812ULL, 0x000fe400078ec0ffULL,
0x000000410a307211ULL, 0x000fe400078f98ffULL, 0x0000002002357810ULL, 0x040fe40007ffe0ffULL,
0x0000004002397810ULL, 0x000fe20007ffe0ffULL, 0x00006a0030307625ULL, 0x000fe200078e0031ULL,
0x00000060023f7810ULL, 0x000fc60007ffe0ffULL, 0x000000010c369824ULL, 0x000fe200078e0241ULL,
0x0000000530327210ULL, 0x000fe20007f1e0ffULL, 0x000008002e307824ULL, 0x000fe400078e00ffULL,
0x00000080ff379424ULL, 0x000fe400078e00ffULL, 0x0000000131337824ULL, 0x000fe200000e0606ULL,
0x0000080030307812ULL, 0x000fe200078ec0ffULL, 0x000000020d3b9824ULL, 0x140fe400078e0234ULL,
0x000000020d439824ULL, 0x000fc400078e0234ULL, 0x0000000107317824ULL, 0x000fe400078e0230ULL,
0x00000080ff3a9424ULL, 0x000fe400078e00ffULL, 0x00000010023d7824ULL, 0x000fe400078e0231ULL,
0x0000001035307825ULL, 0x000fc800078e0032ULL, 0x0000001039347825ULL, 0x000fc800078e0032ULL,
0x0000001002387825ULL, 0x000fc800078e0032ULL, 0x000000103f327825ULL, 0x000fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000383d7faeULL, 0x0003e6000b901c46ULL,
0x00006a0036369625ULL, 0x000fe200078e0037ULL, 0x00380000303d7faeULL, 0x0003e6000b901c46ULL,
0x000000083b3f9824ULL, 0x000fe200078e0202ULL, 0x00580000343d7faeULL, 0x0003e2000b901c46ULL,
0x00006a00413a9625ULL, 0x000fc600078e003aULL, 0x000045803f3f9811ULL, 0x000fe200078e20ffULL,
0x0000000843419824ULL, 0x000fe200078e0202ULL, 0x00780000323d7faeULL, 0x0003e2000b901c46ULL,
0x0000001002369825ULL, 0x000fc600078e0036ULL, 0x0000418041419811ULL, 0x000fe200078e20ffULL,
0x00000010023a9825ULL, 0x000fe200078e003aULL, 0x00000000363f9faeULL, 0x0003e8000b901c46ULL,
0x000000003a419faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff337224ULL, 0x002fe200078e002fULL, 0x00000001ff327819ULL, 0x100fe20000011602ULL,
0x0000001002317824ULL, 0x000fe200078e00ffULL, 0x00000002ff397819ULL, 0x000fe20000011602ULL,
0x00000080332f7824ULL, 0x000fe200078e00ffULL, 0x0000000c32327812ULL, 0x000fc400078ec0ffULL,
0x0000007031317812ULL, 0x000fe200078ec0ffULL, 0x0000000839357824ULL, 0x000fe200078e00ffULL,
0x000000802f307812ULL, 0x000fe200078ec0ffULL, 0x00000008392f7824ULL, 0x040fe200078e00ffULL,
0x0000000739427812ULL, 0x000fe400078ec0ffULL, 0x00000039ff407212ULL, 0x000fe200078e33ffULL,
0x000001000d307824ULL, 0x000fc600078e0230ULL, 0xfffffff82f407812ULL, 0x000fe400078ee240ULL,
0x0000003032327210ULL, 0x000fe20007ffe031ULL, 0x0000000839317824ULL, 0x040fe200078e00ffULL,
0x00000008392f7810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000323e7984ULL, 0x000e620000000800ULL, 0x0000000131347812ULL, 0x100fe200078ef642ULL,
0x000000082f447824ULL, 0x000fe200078e00ffULL, 0x0000000231367812ULL, 0x140fe200078ef642ULL,
0x0045800032507984ULL, 0x0002a20000000800ULL, 0x0000000331387812ULL, 0x140fe400078ef642ULL,
0x00000004313a7812ULL, 0x140fe400078ef642ULL, 0x00000005313c7812ULL, 0x100fe400078ef642ULL,
0xfffffff835307812ULL, 0x000fe200078ee242ULL, 0x000000082f357824ULL, 0x000fe200078e00ffULL,
0x0000002fff4e7212ULL, 0x000fc800078e33ffULL, 0xfffffff8354e7812ULL, 0x000fe400078ee24eULL,
0x000000072f357812ULL, 0x000fe200078ec0ffULL, 0x0000003e09327221ULL, 0x002fe20000010100ULL,
0x00000006313e7812ULL, 0x000fe200078ef642ULL, 0x0000080033317824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b32377820ULL, 0x000fe20000410000ULL, 0x0000000402337824ULL, 0x000fe400078e00ffULL,
0x0000080031327812ULL, 0x000fe200078ec0ffULL, 0x000000082f427824ULL, 0x000fc400078e00ffULL,
0x0000000c33337812ULL, 0x000fe200078ec0ffULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x0000018007317810ULL, 0x000fe40007ffe032ULL, 0xfffffff844327812ULL, 0x100fe400078ee235ULL,
0x0000000242467812ULL, 0x000fe200078ef635ULL, 0x0000001034347824ULL, 0x000fe200078e0231ULL,
0x0000000142447812ULL, 0x000fe200078ef635ULL, 0x0000001030307824ULL, 0x000fe200078e0231ULL,
0x0000000342487812ULL, 0x140fe200078ef635ULL, 0x0000000133347824ULL, 0x000fe200078e0234ULL,
0x00000004424a7812ULL, 0x000fe200078ef635ULL, 0x0000001038387824ULL, 0x000fe200078e0231ULL,
0x00000005424c7812ULL, 0x000fe200078ef635ULL, 0x0000000130307824ULL, 0x000fe200078e0233ULL,
0x0000000642427812ULL, 0x000fe200078ef635ULL, 0x0000001040407824ULL, 0x100fe200078e0231ULL,
0x0000000034347984ULL, 0x000fe20000000800ULL, 0x0000001036367824ULL, 0x000fe200078e0231ULL,
0x0000005037527220ULL, 0x004fe20000410000ULL, 0x0000000133387824ULL, 0x040fe200078e0238ULL,
0x0000000030307984ULL, 0x000e620000000800ULL, 0x0000000133407824ULL, 0x040fe200078e0240ULL,
0x0000002d522d7221ULL, 0x000fe20000010000ULL, 0x000000103c3c7824ULL, 0x000fe200078e0231ULL,
0x00001f3952357589ULL, 0x000fe200000e0000ULL, 0x0000000133367824ULL, 0x000fc400078e0236ULL,
0x000000103a3a7824ULL, 0x100fe200078e0231ULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x00000001333c7824ULL, 0x040fe400078e023cULL, 0x0000001032327824ULL, 0x100fe200078e0231ULL,
0x0000000040407984ULL, 0x000ea20000000800ULL, 0x00000001333a7824ULL, 0x040fe400078e023aULL,
0x000000103e3e7824ULL, 0x000fe200078e0231ULL, 0x0000000036367984ULL, 0x000ee20000000800ULL,
0x0000000133327824ULL, 0x000fc400078e0232ULL, 0x0000001046467824ULL, 0x100fe200078e0231ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x00000001333e7824ULL, 0x040fe400078e023eULL,
0x0000001044447824ULL, 0x100fe200078e0231ULL, 0x000000003a3a7984ULL, 0x000f220000000800ULL,
0x0000000133467824ULL, 0x040fe400078e0246ULL, 0x0000000133447824ULL, 0x000fe200078e0244ULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x0000001048487824ULL, 0x000fc400078e0231ULL,
0x000000104a4a7824ULL, 0x100fe200078e0231ULL, 0x000000003e3e7984ULL, 0x000f620000000800ULL,
0x0000000133487824ULL, 0x040fe400078e0248ULL, 0x000000104c4c7824ULL, 0x100fe200078e0231ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x00000001334a7824ULL, 0x040fe400078e024aULL,
0x00000001334c7824ULL, 0x000fe200078e024cULL, 0x0000000044447984ULL, 0x000f620000000800ULL,
0x000000104e4e7824ULL, 0x000fc400078e0231ULL, 0x0000001042427824ULL, 0x000fe200078e0231ULL,
0x0000000048487984ULL, 0x000fe20000000800ULL, 0x00000001334e7824ULL, 0x040fe400078e024eULL,
0x0000000133427824ULL, 0x000fe200078e0242ULL, 0x00001f2f52527589ULL, 0x00076200000e0000ULL,
0x30000030ff317230ULL, 0x102fe40000004100ULL, 0x20000030ff507230ULL, 0x000fe20000004100ULL,
0x000000004a4a7984ULL, 0x000e620000000800ULL, 0x20000040ff307230ULL, 0x104fe20000004100ULL,
0x00000035311e7223ULL, 0x080fe2000001001eULL, 0x30000040ff337230ULL, 0x000fe20000004100ULL,
0x000000004c4c7984ULL, 0x000ea20000000800ULL, 0x30000036ff317230ULL, 0x008fe20000004100ULL,
0x00000035301d7223ULL, 0x080fe2000001001dULL, 0x30000034ff2f7230ULL, 0x100fe20000004100ULL,
0x000000004e4e7984ULL, 0x000ee20000000800ULL, 0x20000034ff307230ULL, 0x000fe20000004100ULL,
0x0000003531187223ULL, 0x080fe20000010018ULL, 0x20000036ff347230ULL, 0x000fe20000004100ULL,
0x000000352f1a7223ULL, 0x080fe2000001001aULL, 0x0000000042427984ULL, 0x000ee20000000800ULL,
0x30000038ff2f7230ULL, 0x000fe20000004100ULL, 0x00000035301b7223ULL, 0x080fe2000001001bULL,
0x3000003aff317230ULL, 0x010fe20000004100ULL, 0x00000035331c7223ULL, 0x080fe2000001001cULL,
0x20000038ff307230ULL, 0x000fe20000004100ULL, 0x000000352f167223ULL, 0x080fe20000010016ULL,
0x3000003cff2f7230ULL, 0x000fe20000004100ULL, 0x0000003531147223ULL, 0x080fe20000010014ULL,
0x3000003eff317230ULL, 0x020fe20000004100ULL, 0x0000003530177223ULL, 0x080fe20000010017ULL,
0x2000003cff307230ULL, 0x000fe20000004100ULL, 0x000000352f127223ULL, 0x080fe20000010012ULL,
0x30000032ff2f7230ULL, 0x000fe20000004100ULL, 0x0000003531107223ULL, 0x080fe20000010010ULL,
0x20000044ff317230ULL, 0x000fe20000004100ULL, 0x0000003530137223ULL, 0x080fe20000010013ULL,
0x2000003eff307230ULL, 0x000fe20000004100ULL, 0x000000522f0e7223ULL, 0x080fe2000001000eULL,
0x30000046ff2f7230ULL, 0x000fe20000004100ULL, 0x00000052312c7223ULL, 0x080fe2000001002cULL,
0x20000048ff317230ULL, 0x000fe20000004100ULL, 0x0000003530117223ULL, 0x080fe20000010011ULL,
0x0000003534197223ULL, 0x080fe20000010019ULL, 0x000000522f267223ULL, 0x080fe20000010026ULL,
0x000000ffff2f7224ULL, 0x000fe200078e002eULL, 0x00000052312a7223ULL, 0x080fe2000001002aULL,
0x20000046ff307230ULL, 0x000fe20000004100ULL, 0x00000035501f7223ULL, 0x080fe2000001001fULL,
0x2000003aff347230ULL, 0x000fe20000004100ULL, 0x000003002f007a0cULL, 0x000fe20003f06070ULL,
0x2000004aff317230ULL, 0x002fe20000004100ULL, 0x0000005230277223ULL, 0x080fe20000010027ULL,
0x2000004cff337230ULL, 0x004fe20000004100ULL, 0x0000003534157223ULL, 0x000fe20000010015ULL,
0x2000004eff307230ULL, 0x008fe20000004100ULL, 0x0000005231207223ULL, 0x080fe20000010020ULL,
0x20000032ff347230ULL, 0x000fe20000004100ULL, 0x0000005233247223ULL, 0x080fe20000010024ULL,
0x30000044ff447230ULL, 0x000fe20000004100ULL, 0x0000005230217223ULL, 0x080fe20000010021ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x00000052340f7223ULL, 0x080fe2000001000fULL,
0x3000004aff4a7230ULL, 0x000fe20000004100ULL, 0x00000052442b7223ULL, 0x080fe2000001002bULL,
0x3000004cff317230ULL, 0x000fe20000004100ULL, 0x0000005248297223ULL, 0x080fe20000010029ULL,
0x20000042ff2e7230ULL, 0x100fe20000004100ULL, 0x000000524a257223ULL, 0x080fe20000010025ULL,
0x30000042ff337230ULL, 0x000fe20000004100ULL, 0x0000005231287223ULL, 0x080fe20000010028ULL,
0x3000004eff4e7230ULL, 0x000fe20000004100ULL, 0x000000522e237223ULL, 0x000fc40000010023ULL,
0x0000005233227223ULL, 0x080fe40000010022ULL, 0x000000524e0b7223ULL, 0x000fe2000001000bULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x018000002d027810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000002027812ULL, 0x000fc600078ec0ffULL,
0x000000c000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e002dULL,
0x0000f30000057802ULL, 0x000fe40000000f00ULL, 0x000057c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e0009ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002d00027308ULL, 0x000e640000001000ULL, 0xbf80000002037423ULL, 0x002fc8000000002dULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fe40000000002ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x002e680000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff2f7819ULL, 0x002fe40000011606ULL,
0x0000000806317811ULL, 0x000fe400078ff0ffULL, 0x0000002fff077212ULL, 0x000fe200078e33ffULL,
0x00001f2f02037589ULL, 0x000e6200000e0000ULL, 0x000000082f0a7824ULL, 0x000fe200078e00ffULL,
0x00000031ff2d7212ULL, 0x000fe200078e33ffULL, 0x00000008310c7824ULL, 0x040fe200078e00ffULL,
0x00001f3102057589ULL, 0x000ea200000e0000ULL, 0x00000008312e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a337812ULL, 0x000fc400078ee207ULL, 0x000000072f077812ULL, 0x000fe400078ec0ffULL,
0xfffffff80c2d7812ULL, 0x000fe400078ee22dULL, 0x00000002070c7812ULL, 0x000fc600078e3cffULL,
0x000000102d2d7824ULL, 0x000fe400078e0204ULL, 0x000000082f097824ULL, 0x000fc800078e020cULL,
0x0000001009097824ULL, 0x000fe200078e0204ULL, 0x0000001f031f7220ULL, 0x042fe20000410000ULL,
0x0000001e031e7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000001a031a7220ULL, 0x040fe20000410000ULL, 0x0000001903197220ULL, 0x040fe20000410000ULL,
0x0000001803187220ULL, 0x040fe20000410000ULL, 0x0000001703177220ULL, 0x040fe20000410000ULL,
0x0000001603167220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001303137220ULL, 0x040fe20000410000ULL,
0x0000001203127220ULL, 0x040fe20000410000ULL, 0x0000001103117220ULL, 0x040fe20000410000ULL,
0x0000001003107220ULL, 0x040fe20000410000ULL, 0x0000001d031d7220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x000fe20000410000ULL, 0x0000002405247220ULL, 0x044fe20000410000ULL,
0x0000002805037220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000000b05027220ULL, 0x040fe20000410000ULL, 0x0000000f050f7220ULL, 0x040fe20000410000ULL,
0x0000000e050e7220ULL, 0x040fe20000410000ULL, 0x0000002c052c7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002905297220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x000fe20000410000ULL, 0xfffffff80a057812ULL, 0x000fc400078ee22fULL,
0x000000240303723eULL, 0x000fe400000000ffULL, 0x00000001070a7812ULL, 0x000fe200078e3cffULL,
0x0000001005057824ULL, 0x000fe200078e0204ULL, 0x000000210202723eULL, 0x000fe200000000ffULL,
0x0000000406217824ULL, 0x000fe200078e00ffULL, 0x0000000307247812ULL, 0x000fe400078e3cffULL,
0x0000001f1e1e723eULL, 0x000fe400000000ffULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x000000082f0b7824ULL, 0x000fe200078e0224ULL, 0x0000002a2929723eULL, 0x000fc400000000ffULL,
0x0000000407287812ULL, 0x000fe200078e3cffULL, 0x000000100b0b7824ULL, 0x000fe200078e0204ULL,
0x00000007311f7812ULL, 0x000fe400078ec0ffULL, 0x00000005072a7812ULL, 0x000fe200078e3cffULL,
0x000000082f0d7824ULL, 0x000fe200078e0228ULL, 0x00000006072c7812ULL, 0x000fe200078e3cffULL,
0x000000082f077824ULL, 0x000fe200078e020aULL, 0x0000000c21247812ULL, 0x000fe200078ec0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0204ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x000000082f0f7824ULL, 0x000fe200078e022aULL, 0x000000011f067812ULL, 0x000fe200078e3cffULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x000000082f117824ULL, 0x000fe200078e022cULL, 0x000000021f0a7812ULL, 0x000fe200078e3cffULL,
0x0000000124057824ULL, 0x000fe200078e0205ULL, 0x0000001b1a1a723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0204ULL, 0x000000131212723eULL, 0x000fe200000000ffULL,
0x0000000124077824ULL, 0x000fe200078e0207ULL, 0x000000031f0c7812ULL, 0x000fe200078e3cffULL,
0x0000001011117824ULL, 0x000fe200078e0204ULL, 0x0000001d1c1c723eULL, 0x000fe200000000ffULL,
0x0000000124097824ULL, 0x000fe200078e0209ULL, 0xfffffff82e137812ULL, 0x000fe200078ee231ULL,
0x00000001240b7824ULL, 0x040fe200078e020bULL, 0x000000041f1b7812ULL, 0x000fe200078e3cffULL,
0x00000001240d7824ULL, 0x000fe200078e020dULL, 0x000000151414723eULL, 0x000fe200000000ffULL,
0x0000000831157824ULL, 0x000fe200078e0206ULL, 0x000000051f1d7812ULL, 0x000fe200078e3cffULL,
0x0000001033067824ULL, 0x000fe200078e0204ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000000831177824ULL, 0x000fe200078e020aULL, 0x000000061f1f7812ULL, 0x000fe200078e3cffULL,
0x00000008311b7824ULL, 0x040fe200078e021bULL, 0x000000191818723eULL, 0x000fe200000000ffULL,
0x0000000831197824ULL, 0x000fe200078e020cULL, 0x0000001e05007388ULL, 0x0003e20000000800ULL,
0x00000010130a7824ULL, 0x100fe200078e0204ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x00000008311d7824ULL, 0x000fe200078e021dULL, 0x0000001a07007388ULL, 0x0003e20000000800ULL,
0x00000010150c7824ULL, 0x100fe200078e0204ULL, 0x000000202520723eULL, 0x000fe200000000ffULL,
0x00000001240f7824ULL, 0x000fe200078e020fULL, 0x0000001809007388ULL, 0x0003e20000000800ULL,
0x00000008311f7824ULL, 0x000fe200078e021fULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001017177824ULL, 0x000fe200078e0204ULL, 0x000000160b007388ULL, 0x0003e20000000800ULL,
0x0000000124117824ULL, 0x000fc400078e0211ULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x000000140d007388ULL, 0x0003e20000000800ULL, 0x0000000124137824ULL, 0x040fe400078e0206ULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0x000000120f007388ULL, 0x0003e20000000800ULL,
0x0000000124157824ULL, 0x040fe400078e020aULL, 0x000000101d1d7824ULL, 0x000fe200078e0204ULL,
0x0000001011007388ULL, 0x0003e20000000800ULL, 0x00000001240c7824ULL, 0x000fc400078e020cULL,
0x000000101f1f7824ULL, 0x000fe200078e0204ULL, 0x0000001c13007388ULL, 0x0003e20000000800ULL,
0x0000000124177824ULL, 0x040fe400078e0217ULL, 0x0000000124047824ULL, 0x040fe200078e0219ULL,
0x0000000e15007388ULL, 0x0003e20000000800ULL, 0x00000001241b7824ULL, 0x040fe400078e021bULL,
0x0000000124067824ULL, 0x040fe200078e021dULL, 0x0000002b0c007388ULL, 0x0003e20000000800ULL,
0x00000001241f7824ULL, 0x000fc400078e021fULL, 0x00000001242d7824ULL, 0x000fe200078e022dULL,
0x0000002617007388ULL, 0x0003e80000000800ULL, 0x0000002904007388ULL, 0x0003e80000000800ULL,
0x000000201b007388ULL, 0x0003e80000000800ULL, 0x0000000306007388ULL, 0x0003e80000000800ULL,
0x000000221f007388ULL, 0x0003e80000000800ULL, 0x000000022d007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000000000187919ULL, 0x006e620000002600ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000580000057ab9ULL, 0x000fc40000000800ULL,
0x0000000000197919ULL, 0x000ee20000000000ULL, 0x0000000405057899ULL, 0x000fe2000800063fULL,
0x0000001018037824ULL, 0x002fc600078e00ffULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x00000010180a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff027819ULL, 0x008fe40000011619ULL,
0x00000020191c7810ULL, 0x040fe40007ffe0ffULL, 0x00000040191b7810ULL, 0x040fe40007ffe0ffULL,
0x00000060191d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff003047812ULL, 0x000fc400078ee202ULL,
0x00000003ff037819ULL, 0x100fe4000001161cULL, 0x00000003ff097819ULL, 0x000fe4000001161bULL,
0x00000003ff0b7819ULL, 0x000fe4000001161dULL, 0x0000000702027812ULL, 0x000fe400078e4819ULL,
0x0000000703057812ULL, 0x000fe400078e481cULL, 0x0000000709067812ULL, 0x000fc400078e481bULL,
0xfffffff00a0a7812ULL, 0x000fe400078ee203ULL, 0x000000070b0c7812ULL, 0x000fe400078e481dULL,
0x0ffffff802037812ULL, 0x000fe400078ef819ULL, 0x0ffffff805057812ULL, 0x000fe400078ef81cULL,
0x0ffffff806077812ULL, 0x000fe200078ef81bULL, 0x0000001003067824ULL, 0x100fe200078e0200ULL,
0x0ffffff80c0d7812ULL, 0x000fe200078ef81dULL, 0x00000010050c7824ULL, 0x100fe200078e0200ULL,
0x0000000404037c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001007107824ULL, 0x000fc400078e0200ULL,
0x000000100d147824ULL, 0x000fe200078e0200ULL, 0x00a0000006047984ULL, 0x000e620000000c00ULL,
0x0000001018007824ULL, 0x040fe400078e00ffULL, 0x0000001018187824ULL, 0x000fe200078e00ffULL,
0x00a000000c0c7984ULL, 0x000ea20000000c00ULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0xfffffff000007812ULL, 0x000fe400078ee209ULL, 0x00a0000010107984ULL, 0x000ee20000000c00ULL,
0xfffffff018187812ULL, 0x000fc400078ee20bULL, 0x00005a0003027a11ULL, 0x000fe200078048ffULL,
0x00a0000014147984ULL, 0x000f220000000c00ULL, 0x0000000719097812ULL, 0x000fe400078ec0ffULL,
0x000000071c0b7812ULL, 0x000fe400078ec0ffULL, 0x000000071b197812ULL, 0x000fe400078ec0ffULL,
0x000000071d1b7812ULL, 0x000fe400078ec0ffULL, 0x00005b0003037a11ULL, 0x000fc400000f4c1aULL,
0x1ffffff80b1d7812ULL, 0x100fe400078ef808ULL, 0x000000040a0b7c10ULL, 0x000fe4000ff1e0ffULL,
0x1ffffff8191f7812ULL, 0x000fe400078ef808ULL, 0x0000000400197c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x0000000418007c10ULL, 0x000fe4000ff5e0ffULL,
0x00005a000b0a7a11ULL, 0x000fe200078048ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005a0019187a11ULL, 0x000fe200078248ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x00005a00001a7a11ULL, 0x000fc400078448ffULL, 0x1ffffff809097812ULL, 0x000fe400078ef808ULL,
0x00005b000b0b7a11ULL, 0x000fe400000f4c1eULL, 0x1ffffff81b217812ULL, 0x000fe200078ef808ULL,
0x0000001009027825ULL, 0x000fe200078e0002ULL, 0x00005b0019197a11ULL, 0x000fe400008f4c1cULL,
0x00005b00001b7a11ULL, 0x000fe200010f4c23ULL, 0x000000101d087825ULL, 0x000fe200078e000aULL,
0x0000000402007986ULL, 0x002fe6000c101d06ULL, 0x000000101f0a7825ULL, 0x000fe200078e0018ULL,
0x0000000c08007986ULL, 0x004fe6000c101d06ULL, 0x0000001021187825ULL, 0x000fe200078e001aULL,
0x000000100a007986ULL, 0x008fe8000c101d06ULL, 0x0000001418007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff047624ULL, 0x000fe400078e00ffULL,
0x00006700ff057624ULL, 0x000fca00078e00ffULL, 0x0000000604047981ULL, 0x000362000c1e9900ULL,
0x000000010e007810ULL, 0x000fe20007ffe0ffULL, 0x0000000214077824ULL, 0x000fe400078e00ffULL,
0x000000400d037824ULL, 0x000fe200078e00ffULL, 0x0000000b0000720cULL, 0x000fe20003f06070ULL,
0x0000580007007a24ULL, 0x000fe400078e0216ULL, 0x000001000e0f7824ULL, 0x000fc800078e0203ULL,
0x00006200001e7a24ULL, 0x000fcc00078e020fULL, 0x000005c000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x002e620000000000ULL, 0x00000100ff297424ULL, 0x000fe200078e00ffULL,
0x0000000f0c027217ULL, 0x000fca0007800000ULL, 0x0000000102027824ULL, 0x000fe200078e0a0fULL,
0x000020000d0f7811ULL, 0x000fe400078e68ffULL, 0x00000002ff257819ULL, 0x102fe2000001160aULL,
0x000000100a277824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fe4000001160aULL,
0x0000000825197810ULL, 0x040fe20007ffe0ffULL, 0x0000000125067824ULL, 0x140fe200078e021eULL,
0x00000010252b7810ULL, 0x000fe40007ffe0ffULL, 0x0000003027277812ULL, 0x000fe200078ec0ffULL,
0x0000000119087824ULL, 0x000fe200078e021eULL, 0x00000020251f7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0006067625ULL, 0x000fe200078e0029ULL, 0x00000018252d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000305057812ULL, 0x000fe200078e480aULL, 0x00005e0008087625ULL, 0x000fe200078e0029ULL,
0x0000002706147210ULL, 0x080fe40007f1e0ffULL, 0x0000002825217810ULL, 0x000fe20007ffe0ffULL,
0x000000012b107824ULL, 0x000fe200078e021eULL, 0x0000002708167210ULL, 0x000fe20007f3e0ffULL,
0x000000011e087824ULL, 0x000fe200078e021fULL, 0x0ffffffc050a7812ULL, 0x000fe200078ef80aULL,
0x00005e0010107625ULL, 0x000fe200078e0029ULL, 0x0000003025237810ULL, 0x000fc40007ffe0ffULL,
0x000000022b00720cULL, 0x080fe20003fa6070ULL, 0x000000012d127824ULL, 0x040fe200078e021eULL,
0x000000022d00720cULL, 0x080fe20003f86070ULL, 0x000000ffff157224ULL, 0x000fe200000e0607ULL,
0x0000002710067210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0609ULL,
0x000000021f00720cULL, 0x000fe20003f66070ULL, 0x00005e0008087625ULL, 0x000fc800078e0029ULL,
0x0000000419107824ULL, 0x000fe200078e00ffULL, 0x0000002708187210ULL, 0x000fe20007f5e0ffULL,
0x00005e0012127625ULL, 0x000fc600078e0029ULL, 0xfffffffc10087812ULL, 0x000fe200078ee205ULL,
0x000000ffff077224ULL, 0x000fe200000e0611ULL, 0x0000002712127210ULL, 0x000fe20007f3e0ffULL,
0x000000100a117824ULL, 0x100fe200078e020fULL, 0x000000022500720cULL, 0x0c0fe20003f06070ULL,
0x00000010081d7824ULL, 0x000fe200078e020fULL, 0x0000003825257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0x000000021900720cULL, 0x080fe20003f26070ULL,
0x000000011e087824ULL, 0x000fe400078e0221ULL, 0x000000ffff197224ULL, 0x000fe200010e0609ULL,
0x000000022100720cULL, 0x000fe20003f46070ULL, 0x00005e0008087625ULL, 0x000fc800078e0029ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014117faeULL, 0x0003e2000c101c46ULL,
0x00000027081a7210ULL, 0x000fe20007fde0ffULL, 0x000000011e087824ULL, 0x000fe200078e0223ULL,
0x000000022500720cULL, 0x080fe20003f06070ULL, 0x00000000161d7faeULL, 0x0005e2000c901c46ULL,
0x000000022300720cULL, 0x000fe20003f26070ULL, 0x000000ffff1b7224ULL, 0x000fe400030e0609ULL,
0x00005e0008087625ULL, 0x000fc800078e0029ULL, 0x000000042b027824ULL, 0x000fe200078e00ffULL,
0x0000002708087210ULL, 0x000fe20007fde0ffULL, 0x000000042d0a7824ULL, 0x000fe400078e00ffULL,
0x000000011e107824ULL, 0x000fe200078e0225ULL, 0xfffffffc02027812ULL, 0x100fe200078ee205ULL,
0x000000041f147824ULL, 0x002fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe200078ee205ULL,
0x0000000421167824ULL, 0x004fe400078e00ffULL, 0x00000004231c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x100fe200078ee205ULL, 0x00000004251e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x100fe200078ee205ULL, 0x00005e0010107625ULL, 0x000fe200078e0029ULL,
0xfffffffc1c1c7812ULL, 0x000fc400078ee205ULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee205ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000002710107210ULL, 0x000fe20007fde0ffULL,
0x0000001002057824ULL, 0x100fe400078e020fULL, 0x000000100a157824ULL, 0x100fe400078e020fULL,
0x0000001014177824ULL, 0x100fe200078e020fULL, 0x0000000006057faeULL, 0x0003e2000e901c46ULL,
0x00000010161d7824ULL, 0x100fe400078e020fULL, 0x000000101c1f7824ULL, 0x100fe200078e020fULL,
0x0000000012157faeULL, 0x0003e2000e101c46ULL, 0x000000101e0f7824ULL, 0x000fc400078e020fULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000000018177faeULL, 0x0003e8000d901c46ULL,
0x000000001a1d7faeULL, 0x0003e8000d101c46ULL, 0x00000000081f7faeULL, 0x0003e8000c901c46ULL,
0x00000000100f7faeULL, 0x0003e2000c101c46ULL, 0x0000050000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x002e620000000000ULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x000020000d257811ULL, 0x000fc400078e68ffULL, 0x0000001817077811ULL, 0x042fe200078ff0ffULL,
0x0000001017087824ULL, 0x040fe200078e00ffULL, 0x0000001e17067211ULL, 0x040fe400078ff0ffULL,
0x00000003ff027819ULL, 0x000fe20000011617ULL, 0x000000011e107824ULL, 0x000fe200078e0207ULL,
0x0000000817137811ULL, 0x000fe200078ff0ffULL, 0x00000004071d7824ULL, 0x000fe200078e00ffULL,
0x00000028170a7811ULL, 0x040fe200078ff0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0027ULL,
0x0000002017097811ULL, 0x000fc400078ff0ffULL, 0x0000003008297812ULL, 0x000fe200078ec0ffULL,
0x0000000413197824ULL, 0x000fe200078e00ffULL, 0x00000030170f7811ULL, 0x040fe200078ff0ffULL,
0x000000040a1f7824ULL, 0x000fe200078e00ffULL, 0x0000001017057811ULL, 0x000fe200078ff0ffULL,
0x000000011e157824ULL, 0x000fe200078e020aULL, 0x00000003021a7812ULL, 0x000fe200078e4817ULL,
0x0000000113027824ULL, 0x000fe200078e021eULL, 0x0000003817117811ULL, 0x000fe200078ff0ffULL,
0x000000011e137824ULL, 0x000fe200078e0209ULL, 0x0000002906167210ULL, 0x000fe20007f1e0ffULL,
0x0000000409097824ULL, 0x000fe200078e00ffULL, 0xfffffffc1f187812ULL, 0x100fe200078ee21aULL,
0x000000011e1c7824ULL, 0x000fe200078e020fULL, 0xfffffffc1d127812ULL, 0x100fe200078ee21aULL,
0x000000040f217824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1a0f7812ULL, 0x000fe200078ef817ULL,
0x000000011e087824ULL, 0x040fe200078e0205ULL, 0xfffffffc09147812ULL, 0x100fe200078ee21aULL,
0x00000004051b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19057812ULL, 0x100fe200078ee21aULL,
0x000000011e1e7824ULL, 0x000fe200078e0211ULL, 0xfffffffc21197812ULL, 0x100fe200078ee21aULL,
0x000000ffff177224ULL, 0x000fe200000e0607ULL, 0xfffffffc1b0a7812ULL, 0x000fe200078ee21aULL,
0x0000000411117824ULL, 0x000fc400078e00ffULL, 0x00005e0002067625ULL, 0x000fc600078e0027ULL,
0xfffffffc111b7812ULL, 0x000fe200078ee21aULL, 0x00005e0008087625ULL, 0x000fc800078e0027ULL,
0x0000001018217824ULL, 0x000fe200078e0225ULL, 0x0000002906187210ULL, 0x000fe20007f1e0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0027ULL, 0x00000029081a7210ULL, 0x000fc60007f3e0ffULL,
0x000000100f2b7824ULL, 0x100fe400078e0225ULL, 0x0000001019237824ULL, 0x100fe400078e0225ULL,
0x0000001005057824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162b7faeULL, 0x0003e2000b901c46ULL, 0x000000100a0f7824ULL, 0x100fe400078e0225ULL,
0x00000010121d7824ULL, 0x100fe400078e0225ULL, 0x00000010141f7824ULL, 0x000fc400078e0225ULL,
0x000000ffff197224ULL, 0x000fe200000e0607ULL, 0x0000002910107210ULL, 0x000fe20007f1e0ffULL,
0x000000101b257824ULL, 0x000fe400078e0225ULL, 0x000000ffff1b7224ULL, 0x000fe200008e0609ULL,
0x0000000018057faeULL, 0x0003e2000b901c46ULL, 0x00005e0013067625ULL, 0x000fc600078e0027ULL,
0x000000001a0f7faeULL, 0x0003e2000b901c46ULL, 0x00005e0015087625ULL, 0x000fc800078e0027ULL,
0x00005e001c127625ULL, 0x000fe200078e0027ULL, 0x0000002908087210ULL, 0x000fc60007f3e0ffULL,
0x00005e001e147625ULL, 0x000fe200078e0027ULL, 0x0000002912127210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000002906067210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff097224ULL, 0x000fe200008e0609ULL, 0x0000002914147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x00000000101d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fe400000e0607ULL, 0x000000ffff157224ULL, 0x000fc600018e0615ULL,
0x00000000061f7faeULL, 0x0003e8000b901c46ULL, 0x0000000008217faeULL, 0x0003e8000b901c46ULL,
0x0000000012237faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e4000b901c46ULL,
0x01060400ff027984ULL, 0x000ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000002ff7812ULL, 0x004fc6000780c0ffULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200057305ULL, 0x0022a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780c0ffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x000000030d00780cULL, 0x000fda0003f04070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x000000200d027824ULL, 0x004fc800078e0202ULL, 0x0000002002067824ULL, 0x002fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fc80000011602ULL, 0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL,
0x000001e006067812ULL, 0x000fe400078ec0ffULL, 0x0000000105097812ULL, 0x040fe400078efcffULL,
0x0000000705077812ULL, 0x100fe400078e7802ULL, 0x0000000709097812ULL, 0x100fe400078e7802ULL,
0x00000010050f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x040fe200078e0207ULL,
0x0000001105057810ULL, 0x000fe20007ffe0ffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000070f0f7812ULL, 0x000fc400078e7802ULL, 0x0000000007147984ULL, 0x000e62000000cc00ULL,
0x0000000705057812ULL, 0x000fe400078e7802ULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x0000000009107984ULL, 0x000ea4000000cc00ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x000000ffff187224ULL, 0x002fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fc400078e0016ULL,
0x000000ffff1a7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0015ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0017ULL,
0x0000001807007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1f7224ULL, 0x000fca00078e0013ULL, 0x0000001c09007388ULL, 0x000fe8000000cc00ULL,
0x0000000005107984ULL, 0x000e68000000cc00ULL, 0x000000000f147984ULL, 0x000ea2000000cc00ULL,
0x000000ffff237224ULL, 0x002fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fc400078e0010ULL,
0x000000ffff127224ULL, 0x000fe400078e0011ULL, 0x000000ffff207224ULL, 0x004fe400078e0014ULL,
0x000000ffff217224ULL, 0x000fe400078e0016ULL, 0x000000ffff107224ULL, 0x000fe400078e0015ULL,
0x000000ffff117224ULL, 0x000fe200078e0017ULL, 0x000000200f007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e4000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01060000ffff7f8cULL, 0x000fe8000c80043fULL, 0x01060400ff027984ULL, 0x000ea40000000800ULL,
0x8000000002ff7812ULL, 0x004fc40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200057305ULL, 0x0022a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01060400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007800cffULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000b0e00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000ea20000000000ULL,
0x3d80000004047820ULL, 0x020fe20000410000ULL, 0x000000100d057824ULL, 0x002fe200078e00ffULL,
0xffffffff0b077810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff067224ULL, 0x000fe200078e00ffULL,
0x00007610ff087816ULL, 0x000fe40000000008ULL, 0x000001000e097824ULL, 0x008fe200078e0203ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000090c00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000ffff107224ULL, 0x000fe200078e0006ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x000000010a117810ULL, 0x000fe20007ffe0ffULL,
0x00000a9000007945ULL, 0x000fe60003800000ULL, 0x00000002ff0f7819ULL, 0x000fc40000011611ULL,
0x000000041100780cULL, 0x000fc60003f06070ULL, 0x000003000f067a24ULL, 0x000fe400078e020eULL,
0x000000ffff0f7224ULL, 0x000fe400078e000aULL, 0x0000010006137824ULL, 0x040fe200078e0203ULL,
0x0000000106127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0011ULL,
0x0000000110067812ULL, 0x000fe200078e0cffULL, 0x00006200001f7a24ULL, 0x000fe200078e0213ULL,
0x0000000b1200720cULL, 0x000fe40003f26070ULL, 0x0000000311127812ULL, 0x000fd600078ec0ffULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x000000130c117217ULL, 0x000fe20007800000ULL,
0x00000004123f7824ULL, 0x000fe200078e00ffULL, 0x00000002ff167819ULL, 0x004fe20000011602ULL,
0x000000020d3e7824ULL, 0x000fe200078e0206ULL, 0x00000003ff157819ULL, 0x100fe20000011602ULL,
0x0000000111117824ULL, 0x000fe200078e0a13ULL, 0x00000008161c7810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff3d7424ULL, 0x000fe200078e00ffULL, 0x0000000315417812ULL, 0x100fe200078e4802ULL,
0x0000000116127824ULL, 0x100fe200078e021fULL, 0x000000111c00720cULL, 0x0c0fe20003f46070ULL,
0x000000011c147824ULL, 0x000fe200078e021fULL, 0x000000111600720cULL, 0x000fe20003f26070ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3f3f7812ULL, 0x000fe200078ee202ULL,
0x00005e0012127625ULL, 0x000fe200078e003dULL, 0x000020003e3e7811ULL, 0x000fc400078e60ffULL,
0x0ffffffc41177812ULL, 0x000fe200078ef802ULL, 0x00005e0014147625ULL, 0x000fe200078e003dULL,
0xfffffffc1c1d7812ULL, 0x000fe400078ee241ULL, 0x00000010161c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e023eULL, 0x00000018161e7810ULL, 0x040fe20007ffe0ffULL,
0x000000103f127825ULL, 0x000fe200078e0012ULL, 0x00000020163c7810ULL, 0x040fe40007ffe0ffULL,
0x0000002816407810ULL, 0x040fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e023eULL,
0x0000003016427810ULL, 0x040fe20007ffe0ffULL, 0x000000103f147825ULL, 0x000fe200078e0014ULL,
0x0000003816447810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012177faeULL, 0x0003e2000c901c46ULL, 0x000000111c00720cULL, 0x0c0fe20003f26070ULL,
0x000000041c467824ULL, 0x000fe200078e00ffULL, 0x000000113c00720cULL, 0x080fe20003f66070ULL,
0x00000000141d7faeULL, 0x0005e2000d101c46ULL, 0x000000111e00720cULL, 0x0c0fe20003f46070ULL,
0x000000041e487824ULL, 0x000fe200078e00ffULL, 0x000000114000720cULL, 0x080fe20003f86070ULL,
0x000000013c167824ULL, 0x100fe200078e021fULL, 0x000000114200720cULL, 0x080fe20003fa6070ULL,
0x000000043c4a7824ULL, 0x000fe200078e00ffULL, 0x000000114400720cULL, 0x000fe20003fc6070ULL,
0x000000011c127824ULL, 0x002fe200078e021fULL, 0xfffffffc46117812ULL, 0x000fe200078ee241ULL,
0x00000001401c7824ULL, 0x000fe200078e021fULL, 0xfffffffc48437812ULL, 0x000fe200078ee241ULL,
0x000000011e147824ULL, 0x004fe200078e021fULL, 0xfffffffc4a457812ULL, 0x000fe200078ee241ULL,
0x00000001421e7824ULL, 0x000fc400078e021fULL, 0x00000001443c7824ULL, 0x000fe400078e021fULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x00005e0012127625ULL, 0x000fc600078e003dULL,
0xfffffffc40477812ULL, 0x000fe200078ee241ULL, 0x00005e0014147625ULL, 0x000fc800078e003dULL,
0x00005e0016167625ULL, 0x000fc800078e003dULL, 0x00005e001c1c7625ULL, 0x000fc800078e003dULL,
0x00005e001e1e7625ULL, 0x000fc800078e003dULL, 0x0000000442427824ULL, 0x000fe400078e00ffULL,
0x00005e003c3c7625ULL, 0x000fc600078e003dULL, 0xfffffffc42497812ULL, 0x000fe200078ee241ULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x000000103f127825ULL, 0x000fc600078e0012ULL,
0xfffffffc444b7812ULL, 0x000fe200078ee241ULL, 0x000000103f147825ULL, 0x000fc800078e0014ULL,
0x000000103f167825ULL, 0x000fc800078e0016ULL, 0x000000103f1c7825ULL, 0x000fc800078e001cULL,
0x000000103f1e7825ULL, 0x000fc800078e001eULL, 0x000000103f3c7825ULL, 0x000fc800078e003cULL,
0x0000001011117824ULL, 0x100fe400078e023eULL, 0x00000010433f7824ULL, 0x100fe400078e023eULL,
0x0000001045417824ULL, 0x100fe200078e023eULL, 0x0000000012117faeULL, 0x0003e2000c901c46ULL,
0x0000001047437824ULL, 0x100fe400078e023eULL, 0x0000001049457824ULL, 0x100fe200078e023eULL,
0x00000000143f7faeULL, 0x0003e2000d101c46ULL, 0x000000104b477824ULL, 0x000fc600078e023eULL,
0x0000000016417faeULL, 0x0003e8000d901c46ULL, 0x000000001c437faeULL, 0x0003e8000e101c46ULL,
0x000000001e457faeULL, 0x0003e8000e901c46ULL, 0x000000003c477faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x000000020d147824ULL, 0x000fe200078e0206ULL,
0x0000000802167811ULL, 0x004fe200078ff0ffULL, 0x0000000412117824ULL, 0x000fe200078e00ffULL,
0x00000010021c7811ULL, 0x040fe200078ff0ffULL, 0x00000100ff417424ULL, 0x000fe200078e00ffULL,
0x00000018021e7811ULL, 0x000fe200078ff0ffULL, 0x0000000416447824ULL, 0x000fe200078e00ffULL,
0x00000020023c7811ULL, 0x000fe200078ff0ffULL, 0x000000041c467824ULL, 0x000fe200078e00ffULL,
0x00000028023e7811ULL, 0x000fe200078ff0ffULL, 0x000000041e487824ULL, 0x000fe200078e00ffULL,
0x0000003002407811ULL, 0x000fe200078ff0ffULL, 0x000000043c4a7824ULL, 0x000fe200078e00ffULL,
0x0000003802427811ULL, 0x000fe200078ff0ffULL, 0x000000043e4c7824ULL, 0x000fe200078e00ffULL,
0x00002000144d7811ULL, 0x000fe200078e60ffULL, 0x0000000116147824ULL, 0x100fe200078e021fULL,
0x00000003ff137819ULL, 0x100fe20000011602ULL, 0x000000011c167824ULL, 0x100fe200078e021fULL,
0x0000001f02127211ULL, 0x000fe200078ff0ffULL, 0x000000011e1c7824ULL, 0x100fe200078e021fULL,
0x0000000313157812ULL, 0x100fe200078e4802ULL, 0x000000013c1e7824ULL, 0x000fe200078e021fULL,
0xfffffffc11117812ULL, 0x000fe200078ee202ULL, 0x00000004404e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc44447812ULL, 0x100fe200078ee215ULL, 0x0000000442507824ULL, 0x000fe200078e00ffULL,
0xfffffffc46467812ULL, 0x000fe200078ee215ULL, 0x000000013e3c7824ULL, 0x000fe200078e021fULL,
0xfffffffc48487812ULL, 0x000fe200078ee215ULL, 0x00000001403e7824ULL, 0x000fe200078e021fULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee215ULL, 0x0000000142407824ULL, 0x000fe200078e021fULL,
0xfffffffc4c4c7812ULL, 0x100fe200078ee215ULL, 0x00005e0012127625ULL, 0x000fe200078e0041ULL,
0xfffffffc4e4e7812ULL, 0x000fc400078ee215ULL, 0xfffffffc50507812ULL, 0x000fe200078ee215ULL,
0x00005e0016167625ULL, 0x000fe200078e0041ULL, 0x0ffffffc15427812ULL, 0x000fc600078ef802ULL,
0x00005e0014147625ULL, 0x000fc800078e0041ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0041ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0041ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0041ULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x0000001011127825ULL, 0x000fc800078e0012ULL, 0x0000001011147825ULL, 0x000fc800078e0014ULL,
0x0000001011167825ULL, 0x000fc800078e0016ULL, 0x00000010111c7825ULL, 0x000fc800078e001cULL,
0x00000010111e7825ULL, 0x000fc800078e001eULL, 0x00000010113c7825ULL, 0x000fc800078e003cULL,
0x00000010113e7825ULL, 0x000fc800078e003eULL, 0x0000001011407825ULL, 0x000fc800078e0040ULL,
0x00000010424f7824ULL, 0x100fe400078e024dULL, 0x0000001044117824ULL, 0x100fe400078e024dULL,
0x0000001046437824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000124f7faeULL, 0x0003e2000b901c46ULL, 0x0000001048457824ULL, 0x100fe400078e024dULL,
0x000000104a477824ULL, 0x100fe200078e024dULL, 0x0000000014117faeULL, 0x0003e2000b901c46ULL,
0x000000104c497824ULL, 0x000fc400078e024dULL, 0x000000104e4b7824ULL, 0x100fe200078e024dULL,
0x0000000016437faeULL, 0x0003e2000b901c46ULL, 0x00000010504d7824ULL, 0x000fc600078e024dULL,
0x000000001c457faeULL, 0x0003e8000b901c46ULL, 0x000000001e477faeULL, 0x0003e8000b901c46ULL,
0x000000003c497faeULL, 0x0003e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0003e8000b901c46ULL,
0x00000000404d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002117810ULL, 0x042fe20007ffe0ffULL,
0x000000020d3e7824ULL, 0x000fe200078e0210ULL, 0xfffffff802417812ULL, 0x000fe200078ec0ffULL,
0x000000080f3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000000741417812ULL, 0x000fc400078ef802ULL,
0x0000000711427812ULL, 0x000fe400078ef802ULL, 0x00000007023d7812ULL, 0x000fe400078ec0ffULL,
0x00000001ff3c7819ULL, 0x000fe40000011641ULL, 0x00000001ff407819ULL, 0x000fe40000011642ULL,
0x000020003e3e7811ULL, 0x000fe400078e60ffULL, 0x000000083d3d7812ULL, 0x000fc400078ef802ULL,
0x000000033c3c7812ULL, 0x000fe400078ec0ffULL, 0x0000000340407812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000f3c107212ULL, 0x080fe200078e3cffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000f40157212ULL, 0x000fe400078e3cffULL,
0x000000010f457810ULL, 0x000fe20007ffe0ffULL, 0x0000000441117824ULL, 0x000fe200078e0210ULL,
0x0000003f02767211ULL, 0x000fe200078fe0ffULL, 0x0000000442157824ULL, 0x000fe200078e0215ULL,
0x000000020f0f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x100fe200078e023eULL,
0x000000043f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e023eULL,
0x000000040f00780cULL, 0x000fc60003f25270ULL, 0x000000001110783bULL, 0x000e680000000200ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000018ff717819ULL, 0x002fe20000011410ULL,
0x00010000101c7824ULL, 0x040fe200078e00ffULL, 0x0000888010737816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011411ULL,
0x00010000111d7824ULL, 0x040fe200078e00ffULL, 0x00008880116f7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fc40000011412ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880126d7816ULL, 0x000fe400000000ffULL,
0x00000018ff647819ULL, 0x000fe20000011413ULL, 0x0000001000787306ULL, 0x0003e20000200c00ULL,
0x00008880135f7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff557819ULL, 0x004fe20000011414ULL,
0x0000001100727306ULL, 0x0005e20000200c00ULL, 0x0001000012107824ULL, 0x002fe200078e00ffULL,
0x0000888014547816ULL, 0x000fe200000000ffULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011415ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x0000001c007a7306ULL, 0x000fe20000200c00ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x0000888015657816ULL, 0x000fc400000000ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000012006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff577819ULL, 0x000fe40000011416ULL, 0x00000018ff437819ULL, 0x000fe40000011417ULL,
0x0000888016637816ULL, 0x000fe400000000ffULL, 0x00008880175b7816ULL, 0x000fe200000000ffULL,
0x0000001300697306ULL, 0x0005e20000200c00ULL, 0x000000453c127212ULL, 0x002fc400078e3cffULL,
0x0000004540457212ULL, 0x000fca00078e3cffULL, 0x0000001d00747306ULL, 0x0003e20000200c00ULL,
0x0000000441137824ULL, 0x004fe400078e0212ULL, 0x0000000442457824ULL, 0x000fe400078e0245ULL,
0x0000001013137824ULL, 0x100fe400078e023eULL, 0x0000001045127824ULL, 0x000fe200078e023eULL,
0x0000001000707306ULL, 0x0005e40000200c00ULL, 0x00000000131c783bULL, 0x002e6c0000000200ULL,
0x00000011006e7306ULL, 0x0007e20000200c00ULL, 0x0001000014107824ULL, 0x004fc400078e00ffULL,
0x0000010014147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0001000015117824ULL, 0x048fe200078e00ffULL,
0x0000001000677306ULL, 0x0005e20000200c00ULL, 0x0000010015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000014006c7306ULL, 0x0007e20000200c00ULL, 0x0001000016107824ULL, 0x044fe400078e00ffULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011410ULL,
0x0000001500687306ULL, 0x0003e20000200c00ULL, 0x0001000017147824ULL, 0x048fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x000100001d157824ULL, 0x042fe200078e00ffULL, 0x00000014005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001141cULL, 0x00000018ff4b7819ULL, 0x000fe4000001141dULL,
0x00000018ff527819ULL, 0x000fe40000011415ULL, 0x000088801c457816ULL, 0x040fe200000000ffULL,
0x0000001600627306ULL, 0x000fe20000200c00ULL, 0x000100001c147824ULL, 0x042fe200078e00ffULL,
0x000088801d4d7816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe2000001141eULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc40000011414ULL, 0x0000000776147812ULL, 0x000fe200078e783dULL,
0x00000017005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000000203d147824ULL, 0x000fe200078e0214ULL,
0x000088801e517816ULL, 0x000fe400000000ffULL, 0x0000000276767810ULL, 0x000fe20007ffe0ffULL,
0x0000001014147824ULL, 0x000fe200078e00ffULL, 0x00000011006a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x000fc4000001141fULL, 0x0000000776767812ULL, 0x000fe400078e783dULL,
0x000000001414783bULL, 0x002fe20000000200ULL, 0x000088801f567816ULL, 0x000fe400000000ffULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x000000001210783bULL, 0x004ea20000000200ULL,
0x000000203d767824ULL, 0x000fcc00078e0276ULL, 0x0000001c004f7306ULL, 0x0007f00000200c00ULL,
0x0000001d00507306ULL, 0x0009e20000200c00ULL, 0x000100001e1c7824ULL, 0x048fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000100001f1d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000006f006f7306ULL, 0x000ee20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000001c00587306ULL, 0x0003e20000200c00ULL,
0x00000018ff487819ULL, 0x004fe40000011410ULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x00000018ff447819ULL, 0x000fe40000011413ULL, 0x00000018ff467819ULL, 0x000fe20000011412ULL,
0x0000001d00597306ULL, 0x0005e20000200c00ULL, 0x00005410731c7816ULL, 0x002fce000000007aULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00005410781d7816ULL, 0x004fce0000000071ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x0000001c1438723cULL, 0x000fee0000001838ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000054106f1c7816ULL, 0x008fe20000000074ULL,
0x00010000106f7824ULL, 0x000fe200078e00ffULL, 0x00005410721d7816ULL, 0x000fc8000000005dULL,
0x00000018ff6f7819ULL, 0x000fe2000001146fULL, 0x0000005400547306ULL, 0x000ee40000200c00ULL,
0x0000001c1434723cULL, 0x000fec0000001834ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x000054106d1c7816ULL, 0x002fc40000000070ULL, 0x000054106b1d7816ULL, 0x000fe40000000060ULL,
0x000054106c557816ULL, 0x004fe40000000055ULL, 0x00008880116b7816ULL, 0x000fe200000000ffULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000541054547816ULL, 0x008fe20000000067ULL,
0x0000001c1430723cULL, 0x040fec0000001830ULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x00005410691d7816ULL, 0x010fe20000000064ULL, 0x000000541428723cULL, 0x000fe20000001828ULL,
0x0001000011697824ULL, 0x000fc400078e00ffULL, 0x000000ffff647224ULL, 0x000fc600078e006bULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000054105f1c7816ULL, 0x002fe2000000006eULL,
0x0000010011547824ULL, 0x000fe200078e00ffULL, 0x00000018ff557819ULL, 0x000fc80000011469ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000001e00537306ULL, 0x0003e20000200c00ULL,
0x0000001c142c723cULL, 0x000fe2000000182cULL, 0x0000541068117816ULL, 0x004fe40000000061ULL,
0x0000888012617816ULL, 0x000fc800000000ffULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00008880101e7816ULL, 0x042fe200000000ffULL, 0x0000010010107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000001e005d7306ULL, 0x0005f00000200c00ULL,
0x00000010005f7306ULL, 0x0007e20000200c00ULL, 0x00000010761e7824ULL, 0x004fce00078e00ffULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x0000541065107816ULL, 0x008fce000000006aULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000000101424723cULL, 0x000fee0000001824ULL,
0x0000001f005a7306ULL, 0x0007e20000200c00ULL, 0x0000541063107816ULL, 0x002fe40000000066ULL,
0x0000541062117816ULL, 0x000fe20000000057ULL, 0x000000ffff577224ULL, 0x000fc400078e0061ULL,
0x0001000012617824ULL, 0x000fe400078e00ffULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000001e1c783bULL, 0x008ee20000000200ULL, 0x000000101420723cULL, 0x000fe20000001820ULL,
0x00000018ff617819ULL, 0x000fca0000011461ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x000054105b107816ULL, 0x004fe4000000005eULL, 0x000054105c117816ULL, 0x000fca0000000043ULL,
0x0000005200527306ULL, 0x000ea40000200c00ULL, 0x000000101418723cULL, 0x000fec0000001818ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000010012107824ULL, 0x000fe200078e00ffULL,
0x0000541050117816ULL, 0x002fc4000000004bULL, 0x0000888013147816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000005600567306ULL, 0x000e700000200c00ULL,
0x0000001000157306ULL, 0x0005f00000200c00ULL, 0x0000004c004c7306ULL, 0x000f220000200c00ULL,
0x000054104d107816ULL, 0x004fce0000000052ULL, 0x000000101c34723cULL, 0x008fe20000001834ULL,
0x0000004a004a7306ULL, 0x000eac0000200c00ULL, 0x000000ffff117224ULL, 0x000fe200078e0014ULL,
0x0000541056107816ULL, 0x002fe20000000059ULL, 0x0001000013147824ULL, 0x040fe200078e00ffULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x000054104f4f7816ULL, 0x010fc4000000004cULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000001100167306ULL, 0x0007e20000200c00ULL,
0x0000541053537816ULL, 0x004fce000000004aULL, 0x0000001400177306ULL, 0x000ea20000200c00ULL,
0x000054105a117816ULL, 0x008fe40000000049ULL, 0x000054105f5f7816ULL, 0x002fca0000000048ULL,
0x000000101c2c723cULL, 0x000fe2000000182cULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x0000541016167816ULL, 0x004fce0000000017ULL, 0x0000004600467306ULL, 0x000ff00000200c00ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000ff00000200c00ULL,
0x0000004e004e7306ULL, 0x000e700000200c00ULL, 0x0000005100517306ULL, 0x000eb00000200c00ULL,
0x0000006f00607306ULL, 0x000ee20000200c00ULL, 0x00005410454e7816ULL, 0x002fce000000004eULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000541051527816ULL, 0x004fe20000000058ULL,
0x0000004e1c38723cULL, 0x040fec0000001838ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000054105d5e7816ULL, 0x008fe20000000060ULL, 0x000000521c30723cULL, 0x040fec0000001830ULL,
0x0000005400547306ULL, 0x000ea40000200c00ULL, 0x0000005e1c28723cULL, 0x000fec0000001828ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541064647816ULL, 0x002fce0000000055ULL,
0x0000006100127306ULL, 0x000e620000200c00ULL, 0x0000541054657816ULL, 0x004fce0000000047ULL,
0x0000001300117306ULL, 0x0004e20000200c00ULL, 0x000000641c24723cULL, 0x000fe20000001824ULL,
0x0000541057127816ULL, 0x002fe40000000012ULL, 0x0000541015137816ULL, 0x004fe40000000046ULL,
0x0000541011177816ULL, 0x008fca0000000044ULL, 0x000000121c20723cULL, 0x040ff00000001820ULL,
0x000000161c18723cULL, 0x000fe20000001818ULL, 0xfffff0d000001947ULL, 0x000fee000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff107224ULL, 0x000fe200078e0006ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe4d000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x01061400050f7984ULL, 0x000e620000000800ULL,
0x0000ffff080a7812ULL, 0x000fe200078ec0ffULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000003604147220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x000fe20000410000ULL,
0x000088800a407816ULL, 0x000fe200000000ffULL, 0x0000002b041e7220ULL, 0x040fe20000410000ULL,
0x00000026041f7220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x000fe20000410000ULL, 0x80000000400a7824ULL, 0x000fe200078e00ffULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504107220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000003204117220ULL, 0x040fe20000410000ULL, 0x0000003304127220ULL, 0x040fe20000410000ULL,
0x0000002e04137220ULL, 0x040fe20000410000ULL, 0x0000002f041c7220ULL, 0x040fe20000410000ULL,
0x0000002a041d7220ULL, 0x040fe20000410000ULL, 0x0000002704367220ULL, 0x040fe20000410000ULL,
0x00000022043c7220ULL, 0x040fe20000410000ULL, 0x00000023043d7220ULL, 0x040fe20000410000ULL,
0x00000025042a7220ULL, 0x040fe20000410000ULL, 0x0000002804167220ULL, 0x040fe20000410000ULL,
0x00000019042e7220ULL, 0x040fe20000410000ULL, 0x0000001a043e7220ULL, 0x040fe20000410000ULL,
0x000000ffff257224ULL, 0x000fe200078e0024ULL, 0x0000003104157220ULL, 0x040fe20000410000ULL,
0x0000002c04177220ULL, 0x040fe20000410000ULL, 0x0000001804277220ULL, 0x040fe20000410000ULL,
0x0000001b043f7220ULL, 0x040fe20000410000ULL, 0x000000ffff287224ULL, 0x000fe200078e002dULL,
0x0000002904297220ULL, 0x000fe20000410000ULL, 0x000000ffff227224ULL, 0x000fc400078e0020ULL,
0x000000ffff247224ULL, 0x000fe200078e0021ULL, 0x800000000fff7812ULL, 0x002fe2000780480aULL,
0x000000ffff197224ULL, 0x000fe400078e001eULL, 0x000000ffff1a7224ULL, 0x000fe400078e001fULL,
0x000000ffff357224ULL, 0x000fe400078e0038ULL, 0x000000ffff337224ULL, 0x000fe400078e0039ULL,
0x000000ffff327224ULL, 0x000fc400078e0034ULL, 0x000000ffff317224ULL, 0x000fe400078e0010ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0030ULL, 0x000000ffff267224ULL, 0x000fe400078e003aULL,
0x000000ffff2d7224ULL, 0x000fe400078e003bULL, 0x000000ffff2c7224ULL, 0x000fe400078e0037ULL,
0x000000ffff217224ULL, 0x000fc400078e0011ULL, 0x000000ffff237224ULL, 0x000fe400078e0012ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0013ULL, 0x000000ffff1b7224ULL, 0x000fe400078e001cULL,
0x000000ffff187224ULL, 0x000fe400078e001dULL, 0x000000ffff207224ULL, 0x000fe400078e0036ULL,
0x000000ffff1e7224ULL, 0x000fc400078e003cULL, 0x000000ffff1f7224ULL, 0x000fe200078e003dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000d000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1d7224ULL, 0x000fe400078e003eULL, 0x000000ffff1c7224ULL, 0x000fe200078e003fULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x8000000040407824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000f7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000f0000735dULL, 0x004fe40003800000ULL,
0x01061400050f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fc40007804840ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004020a7824ULL, 0x000fe200078e00ffULL,
0x000000070e00720cULL, 0x000fe20003f05270ULL, 0x0000047000007945ULL, 0x000fe60003800000ULL,
0xfffffff00a107812ULL, 0x000fca00078ec0ffULL, 0x000000800d0f7824ULL, 0x000fca00078e0210ULL,
0x010400000f107984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000202307824ULL, 0x000fe400078e00ffULL, 0x000000010c097824ULL, 0x000fc600078e0a09ULL,
0x0000000630307812ULL, 0x000fc800078ec0ffULL, 0x0000000130347812ULL, 0x040fe400078efcffULL,
0x0000000830367812ULL, 0x000fe400078efcffULL, 0x000000093400720cULL, 0x080fe40003f26070ULL,
0x0000001030347812ULL, 0x000fe400078efcffULL, 0x000000093600720cULL, 0x080fe40003f06070ULL,
0x000000093400720cULL, 0x000fc40003fc6070ULL, 0x0000001130367812ULL, 0x040fe400078efcffULL,
0x0000001830347812ULL, 0x040fe400078efcffULL, 0x000000093000720cULL, 0x080fe40003f46070ULL,
0x000000093600720cULL, 0x080fe40003fa6070ULL, 0x000000093400720cULL, 0x000fe40003f66070ULL,
0x0000000930387812ULL, 0x000fc400078efcffULL, 0x0000001930367812ULL, 0x040fe400078efcffULL,
0x0000002030347812ULL, 0x000fe400078efcffULL, 0xff7fffff26267808ULL, 0x000fe40005000000ULL,
0xff7fffff35357808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40004800000ULL,
0xff7fffff33337808ULL, 0x000fc40004800000ULL, 0x000000093800720cULL, 0x080fe40003f86070ULL,
0x000000093600720cULL, 0x080fe40003f46070ULL, 0x000000093400720cULL, 0x000fe40003f26070ULL,
0x0000002130367812ULL, 0x040fe400078efcffULL, 0x0000002830347812ULL, 0x000fe400078efcffULL,
0xff7fffff14147808ULL, 0x000fc40004000000ULL, 0xff7fffff32327808ULL, 0x000fe40004000000ULL,
0xff7fffff2c2c7808ULL, 0x000fe40006000000ULL, 0xff7fffff31317808ULL, 0x000fe40006000000ULL,
0x000000093600720cULL, 0x080fe40003f06070ULL, 0x000000093400720cULL, 0x000fe40003f86070ULL,
0x0000002930367812ULL, 0x000fc400078efcffULL, 0x0000003030347812ULL, 0x000fe400078efcffULL,
0xff7fffff21217808ULL, 0x000fe40007000000ULL, 0xff7fffff2f2f7808ULL, 0x000fe40007000000ULL,
0xff7fffff23237808ULL, 0x000fe40006800000ULL, 0xff7fffff15157808ULL, 0x000fe40006800000ULL,
0x000000093600720cULL, 0x000fc40003fc6070ULL, 0x000000093400720cULL, 0x000fe40003fa6070ULL,
0x0000003130367812ULL, 0x040fe400078efcffULL, 0x0000003830347812ULL, 0x040fe400078efcffULL,
0x0000003930307812ULL, 0x000fe400078efcffULL, 0xff7fffff2b2b7808ULL, 0x000fe40005800000ULL,
0xff7fffff17177808ULL, 0x000fc40005800000ULL, 0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL,
0xff7fffff28287808ULL, 0x000fe40005000000ULL, 0xff7fffff18187808ULL, 0x000fe40004800000ULL,
0xff7fffff16167808ULL, 0x000fe40004800000ULL, 0x000000093600720cULL, 0x080fe40003f66070ULL,
0x000000093400720cULL, 0x000fc40003f46070ULL, 0x000000093000720cULL, 0x000fe40003f26070ULL,
0xff7fffff19197808ULL, 0x000fe40004000000ULL, 0xff7fffff29297808ULL, 0x000fe40004000000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40006000000ULL, 0xff7fffff25257808ULL, 0x000fe40006000000ULL,
0xff7fffff20207808ULL, 0x000fc40007000000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40007000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40006800000ULL, 0xff7fffff22227808ULL, 0x000fe40006800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005800000ULL, 0xff7fffff24247808ULL, 0x000fe40005800000ULL,
0xff7fffff1d1d7808ULL, 0x000fc40005000000ULL, 0xff7fffff27277808ULL, 0x000fe40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004800000ULL, 0xff7fffff2e2e7808ULL, 0x000fe40004800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003510107209ULL, 0x004fe20007810000ULL,
0x0000001fff347424ULL, 0x000fe200078e00ffULL, 0x0000002611307209ULL, 0x000fe20007810000ULL,
0xffffffffff3d7424ULL, 0x000fe200078e00ffULL, 0x0000003310097209ULL, 0x000fe40007810000ULL,
0x0000002d30117209ULL, 0x000fc40007810000ULL, 0x0000003209107209ULL, 0x000fe40007810000ULL,
0x0000001411117209ULL, 0x000fe40007810000ULL, 0x0000003110107209ULL, 0x000fe40007810000ULL,
0x0000002c11307209ULL, 0x000fe40007810000ULL, 0x0000002f10107209ULL, 0x000fe40007810000ULL,
0x0000002130307209ULL, 0x000fc40007810000ULL, 0x0000001510107209ULL, 0x000fe40007810000ULL,
0x0000002330307209ULL, 0x000fe40007810000ULL, 0x0000001710097209ULL, 0x000fe40007810000ULL,
0x0000002b30307209ULL, 0x000fe40007810000ULL, 0x0000002809097209ULL, 0x000fe40007810000ULL,
0x0000001b30117209ULL, 0x000fc40007810000ULL, 0x0000001609107209ULL, 0x000fe40007810000ULL,
0x0000001811307209ULL, 0x000fe40007810000ULL, 0x0000002910107209ULL, 0x000fe40007810000ULL,
0x0000001930097209ULL, 0x000fe40007810000ULL, 0x0000002510117209ULL, 0x000fe40007810000ULL,
0x0000001a09097209ULL, 0x000fc40007810000ULL, 0x0000002a11117209ULL, 0x000fe40007810000ULL,
0x0000002009097209ULL, 0x000fe40007810000ULL, 0x0000002211117209ULL, 0x000fe40007810000ULL,
0x0000001e09107209ULL, 0x000fe40007810000ULL, 0x0000002411307209ULL, 0x000fe40007810000ULL,
0x0000001f10107209ULL, 0x000fc40007810000ULL, 0x0000002730097209ULL, 0x000fe40007810000ULL,
0x0000001d10117209ULL, 0x000fe40007810000ULL, 0x0000002e09107209ULL, 0x000fe40007810000ULL,
0x0000001c11387209ULL, 0x000fe20007810000ULL, 0x00000da27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0010097f89ULL, 0x0004e400000e0000ULL, 0x00000009103a7209ULL, 0x008fe20007810000ULL,
0x00000dd27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0038097f89ULL, 0x000ee800000e0000ULL,
0x0c401f0012117f89ULL, 0x000f2800000e0000ULL, 0x0c401f0013107f89ULL, 0x004ea200000e0000ULL,
0x0000000938347209ULL, 0x00afc40007810000ULL, 0x0000001112367209ULL, 0x010fc60007810000ULL,
0x0c201f0034377f89ULL, 0x000fe200000e0000ULL, 0x0000001013097209ULL, 0x004fc60007810000ULL,
0x0c201f003a117f89ULL, 0x000e6800000e0000ULL, 0x0c201f0036397f89ULL, 0x000ea800000e0000ULL,
0x0c201f0009307f89ULL, 0x00072200000e0000ULL, 0x000000113a107209ULL, 0x002fe40007810000ULL,
0x0000003734117209ULL, 0x000fc40007810000ULL, 0x0000003936127209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b10347820ULL, 0x00afe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b2e2e7823ULL, 0x000fe20000010834ULL, 0x3fb8aa3b11347820ULL, 0x000fe20000410000ULL,
0x0000001700137308ULL, 0x0003e60000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010834ULL,
0x0000001500387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b14177823ULL, 0x102fe20000010834ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010834ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fc60000010834ULL,
0x0000002200397308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000ff00000000800ULL,
0x0000003300367308ULL, 0x000e700000000800ULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000353614723eULL, 0x002fce00000000ffULL,
0x0000002600157308ULL, 0x000ff00000000800ULL, 0x0000002d00227308ULL, 0x0002f00000000800ULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a2d7823ULL, 0x002fce0000010834ULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x000000152215723eULL, 0x008fce00000000ffULL,
0x00000028003a7308ULL, 0x0007700000000800ULL, 0x0000001600337308ULL, 0x0009e20000000800ULL,
0x000000172c17723eULL, 0x002fe200000000ffULL, 0x3c003c00ff287424ULL, 0x008fe200078e00ffULL,
0x3fb8aa3b192c7823ULL, 0x000fca0000010834ULL, 0x00000029003c7308ULL, 0x0002e20000000800ULL,
0x000000323116723eULL, 0x010fe400000000ffULL, 0x000000133a1a723eULL, 0x020fe200000000ffULL,
0x3fb8aa3b20137823ULL, 0x000fc80000010834ULL, 0x0000002500377308ULL, 0x000fe20000000800ULL,
0x3c003c00ff297424ULL, 0x002fce00078e00ffULL, 0x00000024003e7308ULL, 0x000fe20000000800ULL,
0x000000333c20723eULL, 0x008fce00000000ffULL, 0x00000027003b7308ULL, 0x0003f00000000800ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x000000281424723cULL, 0x002fee00000018ffULL,
0x0000002100217308ULL, 0x000ff00000000800ULL, 0x0000002300407308ULL, 0x0003300000000800ULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18237823ULL, 0x002fe20000010834ULL,
0x0000002f3818723eULL, 0x008fcc00000000ffULL, 0x0000001b00227308ULL, 0x000e620000000800ULL,
0x000000214019723eULL, 0x010fce00000000ffULL, 0x0000002a002a7308ULL, 0x000ee20000000800ULL,
0x0000002b221b723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000281824723cULL, 0x000fe20000001824ULL, 0x000000372a22723eULL, 0x008fcc00000000ffULL,
0x0000002c002c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1d2a7823ULL, 0x100fe20000010834ULL,
0x3fb8aa3b1c347823ULL, 0x000fe20000010834ULL, 0xfffffffc021c7812ULL, 0x000fca00078ec0ffULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x0000001300327308ULL, 0x000ee20000000800ULL,
0x000000232c21723eULL, 0x002fce00000000ffULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x0000002d3223723eULL, 0x008fe200000000ffULL, 0x0000000fff2d7424ULL, 0x000fcc00078e00ffULL,
0x0000001e002b7308ULL, 0x0003e20000000800ULL, 0x0000001c2d2d7219ULL, 0x000fe200000006ffULL,
0x000000282024723cULL, 0x000fe20000001824ULL, 0x000000393e1c723eULL, 0x000fca00000000ffULL,
0x0000001f00367308ULL, 0x000ee20000000800ULL, 0x000000002d2c73a1ULL, 0x000f2200000e8000ULL,
0x000000002d0473c4ULL, 0x000f620000004000ULL, 0x0000003b2e1e723eULL, 0x002fca00000000ffULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000003400137308ULL, 0x000e620000000800ULL,
0x0000002b361d723eULL, 0x008fe400000000ffULL, 0x000000052dff7c12ULL, 0x010fc4000f80402cULL,
0x0000002a131f723eULL, 0x002fe400000000ffULL, 0x0000000930137209ULL, 0x004fca0007810000ULL,
0x000000281c28723cULL, 0x000fe80000001824ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x0000090204008947ULL, 0x020fde000b800000ULL, 0x001c1fff28247589ULL, 0x0002a400000e0000ULL,
0x000000002d2673a1ULL, 0x000ee200000e8000ULL, 0x000000002d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000052dff7c12ULL, 0x008fda000f804026ULL,
0x0000091204008947ULL, 0x010fea000b800000ULL, 0x001c1fff2a257589ULL, 0x00072800000e0000ULL,
0x001c1fff26267589ULL, 0x00066800000e0000ULL, 0x001c1fff00277589ULL, 0x0006a400000e0000ULL,
0x00000002ff097819ULL, 0x002fe40000011602ULL, 0x0000000c0a3d7812ULL, 0x000fc400078ec0ffULL,
0x0000000709287812ULL, 0x040fe200078ec0ffULL, 0x00000008092d7824ULL, 0x048fe200078e00ffULL,
0x00000009ff2b7212ULL, 0x000fe200078e33ffULL, 0x0000000809297824ULL, 0x040fe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000809387824ULL, 0x040fe200078e00ffULL,
0x0000000809097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d2a7812ULL, 0x100fe400078ee228ULL,
0x00000001292c7812ULL, 0x100fe200078ef628ULL, 0x0000000809487824ULL, 0x000fe200078e00ffULL,
0x00000002292e7812ULL, 0x100fe200078ef628ULL, 0x00000008092d7824ULL, 0x000fe200078e00ffULL,
0x0000000329307812ULL, 0x000fc400078ef628ULL, 0x0000000429327812ULL, 0x140fe400078ef628ULL,
0x0000000529347812ULL, 0x140fe400078ef628ULL, 0x0000000629367812ULL, 0x000fe200078ef628ULL,
0x0000000809297824ULL, 0x040fe200078e00ffULL, 0xfffffff838387812ULL, 0x000fe400078ee22bULL,
0x00000009ff2b7212ULL, 0x000fe400078e33ffULL, 0x0000000709287812ULL, 0x000fc400078ec0ffULL,
0x0000a0000d097811ULL, 0x000fe400078e58ffULL, 0xfffffff82d3a7812ULL, 0x100fe400078ee228ULL,
0x00000001293c7812ULL, 0x140fe200078ef628ULL, 0x000000102a0a7824ULL, 0x000fe200078e0209ULL,
0xfffffff848487812ULL, 0x000fe200078ee22bULL, 0x000000102e2a7824ULL, 0x100fe200078e0209ULL,
0x00000002293e7812ULL, 0x140fe200078ef628ULL, 0x00000010322e7824ULL, 0x100fe200078e0209ULL,
0x0000000329407812ULL, 0x140fe200078ef628ULL, 0x0000001036327824ULL, 0x100fe200078e0209ULL,
0x0000000429427812ULL, 0x140fe200078ef628ULL, 0x000000103c367824ULL, 0x100fe200078e0209ULL,
0x0000000529447812ULL, 0x140fe200078ef628ULL, 0x000000103e377824ULL, 0x100fe200078e0209ULL,
0x0000000629467812ULL, 0x000fe200078ef628ULL, 0x000000102c287824ULL, 0x000fc400078e0209ULL,
0x00000010302c7824ULL, 0x100fe400078e0209ULL, 0x0000001034307824ULL, 0x100fe400078e0209ULL,
0x000000013d297824ULL, 0x000fe400078e020aULL, 0x0000001038347824ULL, 0x100fe400078e0209ULL,
0x000000103a0a7824ULL, 0x100fe200078e0209ULL, 0x0000001429007388ULL, 0x0003e20000000800ULL,
0x0000001040387824ULL, 0x000fc400078e0209ULL, 0x0000001042397824ULL, 0x100fe400078e0209ULL,
0x00000010443a7824ULL, 0x100fe400078e0209ULL, 0x00000010463b7824ULL, 0x100fe400078e0209ULL,
0x00000010483c7824ULL, 0x000fe400078e0209ULL, 0x000000013d097824ULL, 0x040fe400078e0228ULL,
0x000000013d2b7824ULL, 0x000fc400078e022aULL, 0x000000013d2d7824ULL, 0x040fe200078e022cULL,
0x0000001609007388ULL, 0x0007e20000000800ULL, 0x000000013d2f7824ULL, 0x040fe400078e022eULL,
0x000000013d317824ULL, 0x040fe200078e0230ULL, 0x000000182b007388ULL, 0x0007e20000000800ULL,
0x000000013d337824ULL, 0x040fe400078e0232ULL, 0x000000013d357824ULL, 0x040fe200078e0234ULL,
0x0000001a2d007388ULL, 0x0007e20000000800ULL, 0x000000013d0a7824ULL, 0x000fc400078e020aULL,
0x000000013d367824ULL, 0x040fe200078e0236ULL, 0x000000202f007388ULL, 0x0007e20000000800ULL,
0x000000013d287824ULL, 0x040fe400078e0237ULL, 0x000000013d387824ULL, 0x040fe200078e0238ULL,
0x0000002231007388ULL, 0x0007e20000000800ULL, 0x000000013d147824ULL, 0x042fe400078e0239ULL,
0x000000013d3a7824ULL, 0x040fe200078e023aULL, 0x0000001c33007388ULL, 0x0007e20000000800ULL,
0x000000013d2a7824ULL, 0x000fc400078e023bULL, 0x000000013d3c7824ULL, 0x000fe200078e023cULL,
0x0000001e35007388ULL, 0x0007e80000000800ULL, 0x000000150a007388ULL, 0x0007e80000000800ULL,
0x0000001736007388ULL, 0x0007e80000000800ULL, 0x0000001928007388ULL, 0x0007e80000000800ULL,
0x0000001b38007388ULL, 0x0007e80000000800ULL, 0x0000002114007388ULL, 0x0007e80000000800ULL,
0x000000233a007388ULL, 0x0007e80000000800ULL, 0x0000001d2a007388ULL, 0x0007e80000000800ULL,
0x0000001f3c007388ULL, 0x0007e80000000800ULL, 0x010000100f008388ULL, 0x0007e80000000c00ULL,
0x010200240f008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000003000e0e7a10ULL, 0x000fe20007ffe0ffULL, 0x0106080005ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ff08ff7812ULL, 0x000fc4000780c0ffULL, 0x0000000b0e00720cULL, 0x000fe40003f26070ULL,
0x00000001ff087807ULL, 0x000fd60000000000ULL, 0x0000001000001944ULL, 0x002fe20003c00000ULL,
0xffffca6000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e0010ULL, 0x0001470000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x000fe400078e00ffULL, 0x0000055000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0030ULL, 0xfffff21000007947ULL, 0x000fea000383ffffULL,
0x000000ffff307224ULL, 0x000fe200078e0038ULL, 0x0001476000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x002fe400078e00ffULL, 0x000004f000007944ULL, 0x004fea0003c00000ULL,
0x0000003038117209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e0012ULL,
0x000147b000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff397424ULL, 0x002fe400078e00ffULL,
0x000004a000007944ULL, 0x000fea0003c00000ULL, 0x00000030123b7209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0013ULL, 0x0001480000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff397424ULL, 0x002fc400078e00ffULL, 0x0000045000007944ULL, 0x000fea0003c00000ULL,
0x0000003013097209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e003aULL,
0x0001485000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x002fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000303a107209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0011ULL, 0x000148a000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x002fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000003011117209ULL, 0x004fe20007810000ULL, 0x000000ffff307224ULL, 0x000fe200078e003bULL,
0x000148f000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff397424ULL, 0x002fc400078e00ffULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000303b127209ULL, 0x004fe20007810000ULL,
0x000000ffff307224ULL, 0x000fe200078e0009ULL, 0x0001494000367802ULL, 0x000fe20000000f00ULL,
0x00000001ff397424ULL, 0x002fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0xfffff0d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff097224ULL, 0x000fe200078e0028ULL,
0x000149a000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff2c7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff247224ULL, 0x004fe200078e0027ULL, 0xfffff6a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff097224ULL, 0x002fe200078e002aULL, 0x00014a1000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff2c7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x0000028000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2c7224ULL, 0x002fe200078e00ffULL,
0x00014a6000287802ULL, 0x000fe20000000f00ULL, 0x00001c1fff2b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff257224ULL, 0x004fe400078e0027ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x002fe200078e00ffULL, 0x00014ab000287802ULL, 0x000fe20000000f00ULL,
0x00001c1fff2b7424ULL, 0x000fc400078e00ffULL, 0x000000ffff267224ULL, 0x004fe400078e0027ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0xfffff62000007947ULL, 0x000fea000383ffffULL,
0x0180000006027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000600028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000203ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000203ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000006037812ULL, 0x000fd600078ec0ffULL,
0x0080000003020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff097224ULL, 0x00cfe400078e0002ULL,
0x000000ffff027224ULL, 0x000fe400078e0005ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffeb3b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff377424ULL, 0x000fe200078e00ffULL,
0x0000003d00007348ULL, 0x000fe80003800000ULL, 0x0c00003930307389ULL, 0x0002a200000e0034ULL,
0xfffeb37036007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff297424ULL, 0x000fe200078e00ffULL,
0x0000002d00007348ULL, 0x000fe80003800000ULL, 0x0000002c09277389ULL, 0x0002a200000e002bULL,
0xfffeb33028007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000010680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x0000000000000218ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007b0ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000828ULL, 0x00000000000008ecULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001114ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001138ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001148ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001168ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011d8ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000011e0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000011f0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001400ULL, 0x0000000000014d80ULL, 0x9700001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016180ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000016190ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016190ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000011d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014fa8ULL, 0x0000000000014fa8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016610ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_86_cubin_len = 91888;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
