/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017810ULL, 0x0000000000017390ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x65722e00705f7864ULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL,
0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL,
0x656e72656b2e3074ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL, 0x2e6c65722e00656dULL,
0x74736e6f632e766eULL, 0x65722e0034746e61ULL, 0x5f67756265642e6cULL, 0x722e00656d617266ULL,
0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL, 0x6e2e006870617267ULL,
0x746f746f72702e76ULL, 0x2e766e2e00657079ULL, 0x697463612e6c6572ULL, 0x656e72656b006e6fULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e000300000032ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000006dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00010000007bULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000085ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000f000300000096ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000f0001000000a6ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0003000000afULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00110003000000bdULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00110001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000e0022000000d3ULL,
0x0000000000015f70ULL, 0x0000000000000170ULL, 0x000e002200000106ULL, 0x00000000000160e0ULL,
0x0000000000000040ULL, 0x000e002200000131ULL, 0x0000000000016120ULL, 0x00000000000000e0ULL,
0x000d0003000001a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000001bcULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001feULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000800030000021aULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000e101200000229ULL, 0x0000000000000000ULL, 0x0000000000016200ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00015f7000000000ULL, 0x0000040400000000ULL, 0x810c000000940400ULL, 0x00573c0400288080ULL,
0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00015f7000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x8016288080aa0828ULL, 0x0000000310288082ULL, 0x80aa920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x000000e000000000ULL, 0x000160e000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8e08288080aa0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000015800000000ULL, 0x0001612000000000ULL,
0x000000e000000000ULL, 0x0000000000000000ULL, 0x0000001100082f04ULL, 0x00081204000000d2ULL,
0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL,
0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008120400000000ULL,
0x0000000000000011ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000dULL,
0x000c170400501903ULL, 0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL,
0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL,
0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL,
0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00014e0000183104ULL, 0x0001531000015300ULL, 0x0001542000015410ULL,
0x00e8290400015430ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002005000020ULL, 0x0500002005000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0000009000e82804ULL, 0x00001c40000000f0ULL,
0x00001d5000001cd0ULL, 0x00002b2000001d80ULL, 0x00004a5000002bc0ULL, 0x00004b4000004ad0ULL,
0x0000565000004b70ULL, 0x000075e000005690ULL, 0x000076d000007660ULL, 0x0000830000007700ULL,
0x0000a20000008390ULL, 0x0000a3000000a280ULL, 0x0000b0400000a320ULL, 0x0000c7200000b130ULL,
0x0000ceb00000c730ULL, 0x0000ed600000ec20ULL, 0x0000f3400000f310ULL, 0x00014cd00000fb80ULL,
0x00014d1000014d00ULL, 0x00014d4000014d20ULL, 0x00014d8000014d60ULL, 0x0001540000014d90ULL,
0x0001547000015460ULL, 0x00015ac000015480ULL, 0x00015bb000015b40ULL, 0x00015c9000015c20ULL,
0x00015d7000015d00ULL, 0x00015e4000015de0ULL, 0x00015f0000015eb0ULL, 0x03e0390400015f50ULL,
0x000000ff00000160ULL, 0x003f01000001c600ULL, 0x0000000f00000190ULL, 0x003f01300001c608ULL,
0x0000000f000001c0ULL, 0x003f01300001c610ULL, 0x0000000f00000220ULL, 0x003f01200001c648ULL,
0x000000ff00000230ULL, 0x003f01000001c658ULL, 0x000000ff000005a0ULL, 0x003f01070001c600ULL,
0x0000000500000810ULL, 0x003f01020001c614ULL, 0x0000000500000be0ULL, 0x003f01010001c610ULL,
0x000000ff00000f40ULL, 0x003f01070001c648ULL, 0x000000ff00000fc0ULL, 0x003f01010001c658ULL,
0x000000ff00001110ULL, 0x003f01060001c65cULL, 0x000000ff000011b0ULL, 0x003f01060001c65cULL,
0x000000ff00001240ULL, 0x003f01060001c65cULL, 0x00000050000019e0ULL, 0x003f01070001c648ULL,
0x0000005200001a50ULL, 0x003f01060001c64cULL, 0x000000ff00001a70ULL, 0x003f01060001c60cULL,
0x000000ff00001b80ULL, 0x003f01060001c60cULL, 0x0000005200001fe0ULL, 0x003f010600000004ULL,
0x0000005200002080ULL, 0x003f010600000004ULL, 0x000000ff000040c0ULL, 0x003f01010001c658ULL,
0x000000ff00004130ULL, 0x003f01010001c610ULL, 0x000000ff000041e0ULL, 0x003f01060001c65cULL,
0x000000ff00004230ULL, 0x003f01060001c65cULL, 0x000000ff000042c0ULL, 0x003f01060001c65cULL,
0x0000004800004850ULL, 0x003f01070001c648ULL, 0x00000018000048c0ULL, 0x003f01060001c64cULL,
0x000000ff000048e0ULL, 0x003f01060001c61cULL, 0x000000ff000049d0ULL, 0x003f01060001c61cULL,
0x0000001a00004e10ULL, 0x003f01060001c64cULL, 0x0000001a00004ea0ULL, 0x003f01060001c64cULL,
0x000000ff00006ca0ULL, 0x003f01010001c658ULL, 0x000000ff00006d10ULL, 0x003f01010001c620ULL,
0x000000ff00006da0ULL, 0x003f01060001c65cULL, 0x000000ff00006e00ULL, 0x003f01060001c65cULL,
0x000000ff00006e90ULL, 0x003f01060001c65cULL, 0x0000004a000073f0ULL, 0x003f01070001c648ULL,
0x0000001800007460ULL, 0x003f01060001c64cULL, 0x000000ff00007480ULL, 0x003f01060001c62cULL,
0x000000ff00007560ULL, 0x003f01060001c62cULL, 0x00000018000079b0ULL, 0x003f01060001c64cULL,
0x0000001a00007a90ULL, 0x003f010600000004ULL, 0x000000ff00009890ULL, 0x003f01010001c658ULL,
0x000000ff00009900ULL, 0x003f01010001c630ULL, 0x000000ff000099b0ULL, 0x003f01060001c65cULL,
0x000000ff00009a00ULL, 0x003f01060001c65cULL, 0x000000ff00009a90ULL, 0x003f01060001c65cULL,
0x0000003c0000a010ULL, 0x003f01070001c648ULL, 0x0000006f0000a080ULL, 0x003f01060001c64cULL,
0x000000ff0000a0a0ULL, 0x003f01060001c63cULL, 0x000000ff0000a180ULL, 0x003f01060001c63cULL,
0x0000000e0000a5d0ULL, 0x003f01060001c64cULL, 0x0000000d0000a6c0ULL, 0x003f010600000004ULL,
0x000000ff0000c490ULL, 0x003f01010001c658ULL, 0x000000ff0000c4f0ULL, 0x003f01010001c640ULL,
0x000000ff00011690ULL, 0x003f01060001c604ULL, 0x000000ff00011720ULL, 0x003f01060001c604ULL,
0x000000ff00011a50ULL, 0x003f01010001c600ULL, 0x000000ff00011a60ULL, 0x003f01060001c604ULL,
0x000000ff00011ae0ULL, 0x003f01060001c604ULL, 0x0000003300014240ULL, 0x003f01060001c614ULL,
0x00000033000145d0ULL, 0x003f01060001c614ULL, 0x0000003300015a00ULL, 0x003f01010001c608ULL,
0x00101c0400053803ULL, 0x00011b300000ffc0ULL, 0x00015a6000011bd0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x00000000ffffffffULL,
0x00000000fffffffeULL, 0x00000000fffffffdULL, 0x00000000fffffffcULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL,
0x0000000600000002ULL, 0x00000000000001c4ULL, 0x0000001100000002ULL, 0x0000000000000144ULL,
0x0000001100000002ULL, 0x00000000000000ccULL, 0x0000001100000002ULL, 0x0000000000000044ULL,
0x0000001100000002ULL, 0x000000000000019aULL, 0x0000001100000002ULL, 0x000000000000011dULL,
0x0000001100000002ULL, 0x00000000000000a8ULL, 0x0000001100000002ULL, 0x0000004043e00000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000e7919ULL, 0x000e620000002300ULL,
0x00000004ff117424ULL, 0x000fe200078e00ffULL, 0x0000460000067ab9ULL, 0x000fe40000000a00ULL,
0x0000000000037919ULL, 0x000e680000002200ULL, 0x00000000000b7919ULL, 0x000ea80000002100ULL,
0x0000000000147919ULL, 0x000ee80000002700ULL, 0x0000000000157919ULL, 0x000f220000002600ULL,
0x000000010e007824ULL, 0x002fc600078e0203ULL, 0x00001fff0e0e7589ULL, 0x000e6200000e0000ULL,
0x00000080000f7824ULL, 0x104fe200078e020bULL, 0x00000005ff4c7819ULL, 0x000fe2000001160bULL,
0x00006000140a7625ULL, 0x008fc600078e0011ULL, 0x000000ff0f00720cULL, 0x040fe40003f65270ULL,
0x000000030f00780cULL, 0x040fe20003f04070ULL, 0x00001fff4c4c7589ULL, 0x000ea200000e0000ULL,
0x0000007f0f00780cULL, 0x040fe40003f24070ULL, 0x000000010f00780cULL, 0x000fce0003f44070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x3fffffe0ff048424ULL, 0x000fe400078e00ffULL, 0x7fffffe0ff058424ULL, 0x000fe200078e00ffULL,
0x01c60002ff00b388ULL, 0x0007e20000000a00ULL, 0x3fffff80ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff078424ULL, 0x000fe200078e00ffULL, 0x01c608040f008388ULL, 0x0007e2000000ca00ULL,
0xff317217ff009424ULL, 0x000fc400078e00ffULL, 0x3fffff80ff08a424ULL, 0x000fe200078e00ffULL,
0x01c610060f008388ULL, 0x0007e2000000ca00ULL, 0x000000ff0e00720cULL, 0x002fe20003f05270ULL,
0x7fffff80ff09a424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff0cb424ULL, 0x000fe200078e00ffULL,
0x01c400000f009388ULL, 0x0007e20000004800ULL, 0x7fffff80ff0db424ULL, 0x000fc600078e00ffULL,
0x01c648080f00a388ULL, 0x0007e80000008a00ULL, 0x01c6580cff00b388ULL, 0x0007e80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000003b000000947ULL, 0x000fea0003800000ULL,
0x00000000000f7919ULL, 0x01ce620000000000ULL, 0x000000044c027824ULL, 0x000fc400078e00ffULL,
0x00005800ff007624ULL, 0x000fe400078e00ffULL, 0x0000001015037824ULL, 0x000fe400078e00ffULL,
0x0000001000007824ULL, 0x000fe400078e00ffULL, 0x00000200ff137424ULL, 0x000fe400078e00ffULL,
0x0000001400007224ULL, 0x000fe200078e0203ULL, 0x000000020f057211ULL, 0x002fc800078fd8ffULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x00000003050d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000705027812ULL, 0x000fe400078ec0ffULL, 0x0000000707037812ULL, 0x000fe200078ec0ffULL,
0x0000000100107824ULL, 0x000fe200078e020dULL, 0x000000070d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000001f02027812ULL, 0x000fc400078e780fULL, 0x0000000205097810ULL, 0x000fe40007ffe0ffULL,
0x0000001f03047812ULL, 0x100fe200078e780fULL, 0x000000100f037824ULL, 0x000fe200078e00ffULL,
0x0000001f0c127812ULL, 0x000fe200078e780fULL, 0x00000020050c7824ULL, 0x000fe200078e0202ULL,
0x0000000709067812ULL, 0x000fe200078ec0ffULL, 0x0000000100027824ULL, 0x000fe200078e0205ULL,
0x000001f003117812ULL, 0x000fe200078ec0ffULL, 0x000000200d127824ULL, 0x000fe200078e0212ULL,
0x0000001f06087812ULL, 0x000fe200078e780fULL, 0x00000020070f7824ULL, 0x000fc400078e0204ULL,
0x00005c0002027625ULL, 0x000fc800078e0013ULL, 0x0000000100047824ULL, 0x000fe200078e0207ULL,
0x0000001102027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100067824ULL, 0x000fe400078e0209ULL,
0x00005c0004047625ULL, 0x000fc800078e0013ULL, 0x0000002009007824ULL, 0x000fe200078e0208ULL,
0x0000001104047210ULL, 0x000fe20007f3e0ffULL, 0x00005c0006067625ULL, 0x000fc800078e0013ULL,
0x00005c0010087625ULL, 0x000fc800078e0013ULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x0000001106067210ULL, 0x080fe20007f1e0ffULL, 0x000000100c0d7824ULL, 0x000fe200078e00ffULL,
0x0000001108087210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fe400000e0607ULL,
0x0000001000117824ULL, 0x000fe200078e00ffULL, 0x00000000040f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fc400010e0609ULL, 0x0000001012137824ULL, 0x000fe200078e00ffULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x0000000008137faeULL, 0x0003e8000b901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000060a007981ULL, 0x01cea2000c1e1900ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x00000004ff4d7e24ULL, 0x008fe2000f8e00ffULL, 0x000000ff00027810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff027819ULL, 0x000fce0000011602ULL, 0x0000f95000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000580015057a10ULL, 0x000fe20007ffe0ffULL,
0x0000000214047824ULL, 0x000fe200078e00ffULL, 0x000000014d097810ULL, 0x040fe20007ffe0ffULL,
0x000001004d077824ULL, 0x000fe400078e00ffULL, 0x0000580004047a24ULL, 0x000fe200078e0205ULL,
0x000000020900720cULL, 0x000fe20003f06070ULL, 0x000000104c057824ULL, 0x000fe200078e00ffULL,
0x0000000700067217ULL, 0x000fe20007800000ULL, 0x0000620004167a24ULL, 0x000fc400078e0207ULL,
0x00000003ff0c7424ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a07ULL,
0x00000100ff1e7424ULL, 0x000fe200078e00ffULL, 0x00000004ff147819ULL, 0x002fe20000011603ULL,
0x0000001003217824ULL, 0x000fc800078e00ffULL, 0x0000000105097824ULL, 0x000fc800078e0214ULL,
0x0000000116077824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004006087807ULL, 0x000fe20000000000ULL, 0x00005e0007067625ULL, 0x000fe200078e001eULL,
0x000000f021217812ULL, 0x000fe200078ec0ffULL, 0x01c6140c05ff738cULL, 0x0003e20000000000ULL,
0x0000000805087217ULL, 0x000fe40007800000ULL, 0x00000007090a7812ULL, 0x000fe400078ec0ffULL,
0x00000021060e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000108157824ULL, 0x000fe200078e0a05ULL,
0x0000000214067810ULL, 0x000fc40007ffe0ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078e7803ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x0000000414087810ULL, 0x000fe20007ffe0ffULL,
0x0000000105077824ULL, 0x000fe200078e0206ULL, 0x000000150600720cULL, 0x080fe20003f86070ULL,
0x0000001009177824ULL, 0x000fe200078e020aULL, 0x00000006140a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x00000008140c7810ULL, 0x002fe40007ffe0ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x00000001050b7824ULL, 0x040fe200078e020aULL,
0x000000150800720cULL, 0x000fe20003f66070ULL, 0x00000001050d7824ULL, 0x000fe200078e020cULL,
0x0000000709087812ULL, 0x000fc400078ec0ffULL, 0x0000000f06067812ULL, 0x100fe400078e7803ULL,
0x000000150a00720cULL, 0x080fe40003f46070ULL, 0x0000000f08087812ULL, 0x000fe200078e7803ULL,
0x0000001007187824ULL, 0x000fe200078e0206ULL, 0x000000070b0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000116077824ULL, 0x000fe200078e0207ULL, 0x000000070d067812ULL, 0x000fe200078ec0ffULL,
0x0000001009197824ULL, 0x000fe200078e0208ULL, 0x000000150c00720cULL, 0x000fe20003f26070ULL,
0x0000000116097824ULL, 0x000fe200078e0209ULL, 0x0000000f0a0a7812ULL, 0x000fc400078e7803ULL,
0x0000000f060c7812ULL, 0x000fe200078e7803ULL, 0x00005e0009087625ULL, 0x000fe200078e001eULL,
0x0001400017177811ULL, 0x000fc600078e20ffULL, 0x000000100b1a7824ULL, 0x000fe200078e020aULL,
0x0000002108127210ULL, 0x000fe20007fbe0ffULL, 0x00000001160b7824ULL, 0x000fe400078e020bULL,
0x00005e0007067625ULL, 0x000fc800078e001eULL, 0x000000100d1b7824ULL, 0x000fe200078e020cULL,
0x0000002106107210ULL, 0x000fe20007f1e0ffULL, 0x00000001160d7824ULL, 0x000fe200078e020dULL,
0x0000000a14067810ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fc800078e001eULL,
0x00005e000d0c7625ULL, 0x000fe200078e001eULL, 0x000000210a0a7210ULL, 0x000fc60007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0609ULL, 0x000000210c0c7210ULL, 0x000fe20007fbe0ffULL,
0x00000001051d7824ULL, 0x000fe400078e0206ULL, 0x000000ffff117224ULL, 0x000fe200000e0607ULL,
0x000000150600720cULL, 0x080fe20003f06070ULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x000000151400720cULL, 0x000fe20003fc6070ULL, 0x000000ffff0d7224ULL, 0x000fe400028e060dULL,
0x0000000116067824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000c14087810ULL, 0x000fe20007ffe0ffULL, 0x00005e0006067625ULL, 0x080fe200078e001eULL,
0x01c6100005ff7f8cULL, 0x0003e2000c80043fULL, 0x0000000e141c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0001400018097811ULL, 0x000fe200078e20ffULL,
0x00000001051f7824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0005e2000f101c46ULL, 0x0000002106147210ULL, 0x000fe20007fde0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000116067824ULL, 0x000fe200078e021fULL,
0x0000000010097faeULL, 0x0007e2000e101c46ULL, 0x000000150800720cULL, 0x080fe20003fa6070ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x000000151c00720cULL, 0x000fe20003f86070ULL,
0x000000ffff157224ULL, 0x000fe200030e0607ULL, 0x000000071d087812ULL, 0x000fe200078ec0ffULL,
0x00005e0006067625ULL, 0x080fe200078e001eULL, 0x000000071f187812ULL, 0x000fe200078ec0ffULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0001400019197811ULL, 0x000fe200078e20ffULL,
0x0000000105177824ULL, 0x004fe200078e021cULL, 0x00000021060e7210ULL, 0x080fe20007fde0ffULL,
0xff317217ff067424ULL, 0x000fe200078e00ffULL, 0x0000000f18187812ULL, 0x000fe200078e7803ULL,
0x00000001160f7824ULL, 0x000fe200078e0217ULL, 0x0000000717107812ULL, 0x008fe200078ec0ffULL,
0x0000000012197faeULL, 0x0003e2000d901c46ULL, 0x0000000f08167812ULL, 0x100fe200078e7803ULL,
0x00005e000f087625ULL, 0x000fe200078e001eULL, 0x0000000f10107812ULL, 0x000fe200078e7803ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x000140001b1b7811ULL, 0x000fe200078e20ffULL,
0x000000101d167824ULL, 0x000fe200078e0216ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200030e0607ULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x000000101f187824ULL, 0x000fe200078e0218ULL, 0x000140001a077811ULL, 0x000fe200078e20ffULL,
0x0000001017107824ULL, 0x000fe200078e0210ULL, 0x0001400016117811ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0001400018177811ULL, 0x000fe200078e20ffULL,
0x000000000a077faeULL, 0x0005e2000d101c46ULL, 0x00014000101d7811ULL, 0x000fe200078e20ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000000000c1b7faeULL, 0x0003e8000c901c46ULL, 0x0000000014117faeULL, 0x0003e2000c101c46ULL,
0x000000024d00720cULL, 0x000fc60003f06070ULL, 0x000000000e177faeULL, 0x0003e2000e901c46ULL,
0x000000ffff077224ULL, 0x004fc600078e00ffULL, 0x00000000081d7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01c64800ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000b53000000947ULL, 0x000fea0003800000ULL, 0x000000024c087811ULL, 0x002fe200078e10ffULL,
0xff317217ff067424ULL, 0x000fe200078e00ffULL, 0x00007610ff777816ULL, 0x000fe20000000077ULL,
0x000000ffff787224ULL, 0x000fe200078e00ffULL, 0x00007610ff767816ULL, 0x000fe20000000076ULL,
0x000000ffff3b7224ULL, 0x000fe200078e00ffULL, 0x00007610ff097816ULL, 0x000fc40000000009ULL,
0x000001004d0b7824ULL, 0x000fca00078e00ffULL, 0x000000000b00720cULL, 0x000fda0003f06070ULL,
0x0000b43000000947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e620000000800ULL,
0x0000ffff770a7812ULL, 0x000fc800078ec0ffULL, 0x000088800a0e7816ULL, 0x000fe200000000ffULL,
0x000000ffff0a7224ULL, 0x000fc800078e0078ULL, 0x800000000e0c7824ULL, 0x000fca00078e00ffULL,
0x800000000bff7812ULL, 0x002fe2000780480cULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x00007610766e7816ULL, 0x000fe4000000006eULL, 0x00007610770b7816ULL, 0x000fe2000000000bULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000000e0e7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0c7424ULL, 0x000fc800078e00ffULL, 0x0000000c000d7305ULL, 0x0002a4000021f000ULL,
0x3fa000000c0c7823ULL, 0x002fe200000100ffULL, 0x0000000d0000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004ff247819ULL, 0x000fe20000011603ULL, 0x00000100ff4f7424ULL, 0x000fe200078e00ffULL,
0x000000404d0d7811ULL, 0x000fe200078e40ffULL, 0x0000001003167824ULL, 0x000fe200078e00ffULL,
0x00000004243e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105137824ULL, 0x000fe200078e0224ULL,
0x0000000d00107217ULL, 0x000fe20007800000ULL, 0x0000620004147a24ULL, 0x100fe200078e020dULL,
0x000000014d117810ULL, 0x000fe20007ffe0ffULL, 0x00000001051d7824ULL, 0x000fe200078e023eULL,
0x0000000713127812ULL, 0x040fe200078ec0ffULL, 0x00000001130e7824ULL, 0x000fe200078e0214ULL,
0x0000000624487810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a0dULL,
0x0000000f12127812ULL, 0x000fe200078e7803ULL, 0x00005e000e0e7625ULL, 0x000fe200078e004fULL,
0x0000000824507810ULL, 0x000fc40007ffe0ffULL, 0x0000000224267810ULL, 0x040fe20007ffe0ffULL,
0x00000010130d7824ULL, 0x000fe200078e0212ULL, 0x000000021100720cULL, 0x000fe20003f06070ULL,
0x0000000105117824ULL, 0x040fe200078e0248ULL, 0x0000000c24567810ULL, 0x000fe20007ffe0ffULL,
0x0000000105137824ULL, 0x040fe200078e0250ULL, 0x000000f0160c7812ULL, 0x000fe200078ec0ffULL,
0x00000001051b7824ULL, 0x040fe200078e0226ULL, 0x0000000a24547810ULL, 0x000fe20007ffe0ffULL,
0x0000000105157824ULL, 0x000fe200078e0256ULL, 0x000000071d127812ULL, 0x000fe200078ec0ffULL,
0x00000001111e7824ULL, 0x000fe200078e0214ULL, 0x00000040101a7807ULL, 0x000fe20000000000ULL,
0x00000001053d7824ULL, 0x000fe200078e0254ULL, 0x0000000711107812ULL, 0x000fe200078ec0ffULL,
0x00000001133c7824ULL, 0x040fe200078e0214ULL, 0x0000000e24587810ULL, 0x000fe20007ffe0ffULL,
0x0000400078517824ULL, 0x000fe200078e00ffULL, 0x00000007131c7812ULL, 0x000fc400078ec0ffULL,
0x0000000c0e187210ULL, 0x000fe20007f3e0ffULL, 0x00000001051f7824ULL, 0x000fe200078e0258ULL,
0x000000071b0e7812ULL, 0x000fe400078ec0ffULL, 0x0000000f12127812ULL, 0x000fe200078e7803ULL,
0x000000ffff197224ULL, 0x000fe200008e060fULL, 0x0000000f10107812ULL, 0x100fe400078e7803ULL,
0x0000000f1c1c7812ULL, 0x100fe200078e7803ULL, 0x000000101d0f7824ULL, 0x000fe200078e0212ULL,
0x00000007154a7812ULL, 0x000fe200078ec0ffULL, 0x0000001011107824ULL, 0x000fe200078e0210ULL,
0x0000000f0e0e7812ULL, 0x100fe200078e7803ULL, 0x0000001013117824ULL, 0x000fe200078e021cULL,
0x000000073d127812ULL, 0x000fe200078ec0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0214ULL,
0x0000000f4a4a7812ULL, 0x100fe200078e7803ULL, 0x000000101b0e7824ULL, 0x000fe200078e020eULL,
0x000000071f4e7812ULL, 0x000fe200078ec0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0214ULL,
0x0000001a051c7217ULL, 0x000fe20007800000ULL, 0x0000001015137824ULL, 0x040fe200078e024aULL,
0x0000000f12127812ULL, 0x100fe200078e7803ULL, 0x00000001154a7824ULL, 0x000fe200078e0214ULL,
0x0000000f4e527812ULL, 0x000fe200078e7803ULL, 0x000000011c157824ULL, 0x000fc400078e0a05ULL,
0x00005e001b1a7625ULL, 0x000fc600078e004fULL, 0x000000152400720cULL, 0x080fe20003f86070ULL,
0x000000103d127824ULL, 0x040fe200078e0212ULL, 0x0000000c1a247210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3d7824ULL, 0x100fe200078e0214ULL, 0x000000152600720cULL, 0x000fe20003fa6070ULL,
0x000000011f4e7824ULL, 0x040fe400078e0214ULL, 0x000000101f147824ULL, 0x000fe400078e0252ULL,
0x00005e001e1e7625ULL, 0x000fc800078e004fULL, 0x00005e001d1c7625ULL, 0x000fe200078e004fULL,
0x0000000c1e1e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e061bULL,
0x0000000c1c267210ULL, 0x000fe20007f3e0ffULL, 0x00005e003c1a7625ULL, 0x000fe200078e004fULL,
0x000000153e00720cULL, 0x000fc60003f06070ULL, 0x0000000878527824ULL, 0x000fe200078e00ffULL,
0x0000000c1a3c7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000155000720cULL, 0x000fe20003f46070ULL, 0x000000ffff277224ULL, 0x000fe200008e061dULL,
0x0000000852507812ULL, 0x000fe200078e0cffULL, 0x00005e003d1c7625ULL, 0x000fe200078e004fULL,
0x00004000511a7812ULL, 0x000fe400078e0cffULL, 0x000000154800720cULL, 0x000fe20003f26070ULL,
0x00000000500473c2ULL, 0x000e6200000e0000ULL, 0x000140001a487810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200018e061bULL, 0x0000000c1c3e7210ULL, 0x000fe20007fde0ffULL,
0x00005e004a1a7625ULL, 0x000fe200078e004fULL, 0x000000155400720cULL, 0x000fc60003f66070ULL,
0x000000100d497824ULL, 0x100fe400078e0248ULL, 0x000000100e4b7824ULL, 0x100fe400078e0248ULL,
0x000000ffff3f7224ULL, 0x000fe200030e061dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0005e2000e101c46ULL, 0x0000000c1a1a7210ULL, 0x080fe20007f9e0ffULL,
0x00005e004e1c7625ULL, 0x000fe400078e004fULL, 0x00000000244b7faeULL, 0x0007e2000e901c46ULL,
0x000000155600720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1b7224ULL, 0x000fe200020e061bULL,
0x000000155800720cULL, 0x000fe20003f86070ULL, 0x000000100f157824ULL, 0x100fe200078e0248ULL,
0x0000000c1c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010104f7824ULL, 0x100fe200078e0248ULL,
0x0001c64804047890ULL, 0x002fe2000fffe03fULL, 0x0000001011197824ULL, 0x104fe200078e0248ULL,
0x0000000026157faeULL, 0x0003e2000c101c46ULL, 0x0000001013497824ULL, 0x000fc400078e0248ULL,
0x0000001012257824ULL, 0x108fe200078e0248ULL, 0x000000001e4f7faeULL, 0x0003e2000c901c46ULL,
0x000000ffff1d7224ULL, 0x000fe400030e061dULL, 0x00000010144b7824ULL, 0x000fe200078e0248ULL,
0x000000003c197faeULL, 0x0003e8000d101c46ULL, 0x000000003e257faeULL, 0x0003e8000d901c46ULL,
0x000000001a497faeULL, 0x0003e8000e901c46ULL, 0x000000001c4b7faeULL, 0x0003e8000e101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c64c0052197984ULL, 0x0022a20000000800ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01c60c00ff1b7984ULL, 0x000ee20000000800ULL,
0x0000ffff76157812ULL, 0x000fc400078ec0ffULL, 0x0000ffff09187812ULL, 0x000fe400078ec0ffULL,
0x00008880151d7816ULL, 0x000fe400000000ffULL, 0x0000888018157816ULL, 0x000fc600000000ffULL,
0x800000001d187824ULL, 0x000fe400078e00ffULL, 0x80000000151a7824ULL, 0x000fc600078e00ffULL,
0x8000000019ff7812ULL, 0x004fe40007804818ULL, 0x800000001bff7812ULL, 0x008fe2000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0001c64852527810ULL, 0x002fe20007ffe0ffULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000151a7824ULL, 0x000fe400078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01c60c00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x00000001ff187819ULL, 0x000fe20000011603ULL, 0x00000001ffc17424ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe400078ec0ffULL, 0x0000000c18197812ULL, 0x000fca00078ec0ffULL,
0x0000000116167824ULL, 0x000fca00078e0219ULL, 0x01c0000016197984ULL, 0x000e680000000800ULL,
0x01c2000016187984ULL, 0x0004e20000000800ULL, 0x000000061900720bULL, 0x002fda0003f3d000ULL,
0x00000000001a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff1a1e7812ULL, 0x000fda000782c0ffULL,
0x0000035000009947ULL, 0x000fea0003800000ULL, 0x000000061900720bULL, 0x00cfe40003f34000ULL,
0x0000001906257209ULL, 0x000fe40007810000ULL, 0x00000002ff1b7819ULL, 0x000fc60000011603ULL,
0x80000025061a7221ULL, 0x000fe20000010000ULL, 0x000000081b1c7810ULL, 0x000fc60007ffe0ffULL,
0x3fb8aa3b1a1a7820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x000000ff4c00720cULL, 0x000fe40003f25270ULL, 0x0000ffff061f7812ULL, 0x000fe200078e3cffULL,
0x0000001a001a7308ULL, 0x000e620000000800ULL, 0x000000ffff067224ULL, 0x000fe400078e0025ULL,
0x0000001f1eff7212ULL, 0x000fc8000784c0ffULL, 0x00000001ffc17807ULL, 0x000fc60001000000ULL,
0x01c4002516009388ULL, 0x000fe80000000800ULL, 0x00001f1c1a1c7589ULL, 0x002e6400000e0000ULL,
0x8000002519192221ULL, 0x000fe40000010000ULL, 0x0000001a07077220ULL, 0x000fe20000410000ULL,
0x00001f1b1a1b7589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b19192820ULL, 0x000fc80000410000ULL,
0x0000001900172308ULL, 0x000ee20000000800ULL, 0x0000001c3b3b7220ULL, 0x082fe40000410000ULL,
0x0000001c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000001c43437220ULL, 0x080fe40000410000ULL,
0x0000001c42427220ULL, 0x080fe40000410000ULL, 0x0000001c47477220ULL, 0x080fe40000410000ULL,
0x0000001c46467220ULL, 0x000fc40000410000ULL, 0x0000001c37377220ULL, 0x080fe40000410000ULL,
0x0000001c36367220ULL, 0x080fe40000410000ULL, 0x0000001c33337220ULL, 0x080fe40000410000ULL,
0x0000001c32327220ULL, 0x080fe40000410000ULL, 0x0000001c23237220ULL, 0x080fe40000410000ULL,
0x0000001c22227220ULL, 0x000fc40000410000ULL, 0x0000001c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000001c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000001c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000001c2e2e7220ULL, 0x000fe40000410000ULL, 0x0000001b39397220ULL, 0x084fe40000410000ULL,
0x0000001b38387220ULL, 0x000fc40000410000ULL, 0x0000001b41417220ULL, 0x080fe40000410000ULL,
0x0000001b40407220ULL, 0x080fe40000410000ULL, 0x0000001b45457220ULL, 0x080fe40000410000ULL,
0x0000001b44447220ULL, 0x080fe40000410000ULL, 0x0000001b35357220ULL, 0x080fe40000410000ULL,
0x0000001b34347220ULL, 0x000fc40000410000ULL, 0x0000001b31317220ULL, 0x080fe40000410000ULL,
0x0000001b30307220ULL, 0x080fe40000410000ULL, 0x0000001b21217220ULL, 0x080fe40000410000ULL,
0x0000001b20207220ULL, 0x080fe40000410000ULL, 0x0000001b29297220ULL, 0x080fe40000410000ULL,
0x0000001b28287220ULL, 0x000fc40000410000ULL, 0x0000001b2d2d7220ULL, 0x080fe40000410000ULL,
0x0000001b2c2c7220ULL, 0x000fe40000410000ULL, 0x0000001718182220ULL, 0x008fc80000410000ULL,
0x0000000718077221ULL, 0x00cfe20000010000ULL, 0x000000e000000947ULL, 0x000fea0003800000ULL,
0x0000040052187984ULL, 0x000e620000000800ULL, 0x800000001d197824ULL, 0x000fca00078e00ffULL,
0x8000000018ff7812ULL, 0x002fe20007804819ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001d1a7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x0000040052197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000780481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x00000004ff1b7819ULL, 0x000fe40000011603ULL, 0x0000000803187812ULL, 0x000fe400078ec0ffULL,
0x00014000781e7811ULL, 0x000fe200078e70ffULL, 0x000000044c197824ULL, 0x000fe200078e021bULL,
0x00000007181a7812ULL, 0x140fe400078ec803ULL, 0x00000007181c7812ULL, 0x000fe400078ef803ULL,
0x000000191a1d7212ULL, 0x000fe200078e3cffULL, 0x000000011b197824ULL, 0x000fe200078e0208ULL,
0x0001400051187810ULL, 0x000fc40007ffe0ffULL, 0x000002001c247811ULL, 0x040fe200078e20ffULL,
0x000000101c727824ULL, 0x000fe200078e021dULL, 0x000000191a5f7212ULL, 0x000fe400078e3cffULL,
0x00000007038a7812ULL, 0x000fe200078ec0ffULL, 0x00000010723c7824ULL, 0x000fe400078e0218ULL,
0x000000101c657824ULL, 0x000fe200078e025fULL, 0x000000088a8a7812ULL, 0x000fe200078ef803ULL,
0x000000011d627824ULL, 0x000fe400078e0224ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000001065507824ULL, 0x000fe200078e0218ULL, 0x000001001c187811ULL, 0x040fe200078e20ffULL,
0x000000015f617824ULL, 0x000fe200078e0224ULL, 0x000003001c1c7811ULL, 0x000fc600078e20ffULL,
0x000000005050783bULL, 0x000ea20000004200ULL, 0x000000011d647824ULL, 0x100fe400078e0218ULL,
0x000000015f637824ULL, 0x000fe400078e0218ULL, 0x0000001064547824ULL, 0x100fe400078e021eULL,
0x0000001063587824ULL, 0x100fe400078e021eULL, 0x0000001062187824ULL, 0x100fe400078e021eULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x0000001061487824ULL, 0x000fc400078e021eULL,
0x000000011d607824ULL, 0x100fe200078e021cULL, 0x000000005858783bULL, 0x000ee20000004200ULL,
0x000000015f5f7824ULL, 0x000fe400078e021cULL, 0x0000001060247824ULL, 0x100fe200078e021eULL,
0x000000001818783bULL, 0x000f220000004200ULL, 0x000000105f1e7824ULL, 0x000fc600078e021eULL,
0x000000004848783bULL, 0x000f680000004200ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000001e1c783bULL, 0x000f620000004200ULL, 0x00000018ffbb7819ULL, 0x002fe2000001143cULL,
0x000001003c4e7824ULL, 0x040fe200078e00ffULL, 0x000088803cbf7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001143dULL,
0x000001003d4f7824ULL, 0x040fe200078e00ffULL, 0x000088803dbd7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000bf00bf7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x00000018ffb57819ULL, 0x000fe4000001143eULL,
0x00000018ffb37819ULL, 0x000fe2000001143fULL, 0x0000003c00c07306ULL, 0x0003e20000200c00ULL,
0x000088803ebe7816ULL, 0x040fe400000000ffULL, 0x000088803f7b7816ULL, 0x000fe400000000ffULL,
0x00000018ff8c7819ULL, 0x004fe20000011451ULL, 0x000001005b927824ULL, 0x008fe200078e00ffULL,
0x0000888051af7816ULL, 0x000fe200000000ffULL, 0x0000003d00b97306ULL, 0x0005e20000200c00ULL,
0x000001003e3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff797819ULL, 0x010fe20000011419ULL,
0x0000010019867824ULL, 0x040fe200078e00ffULL, 0x0000888019837816ULL, 0x040fe200000000ffULL,
0x0001000019827824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000004e00c47306ULL, 0x0003e20000200c00ULL,
0x00000100513d7824ULL, 0x044fe200078e00ffULL, 0x00000004ff197819ULL, 0x000fe20000011603ULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010018857824ULL, 0x040fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0001000018817824ULL, 0x000fe200078e00ffULL, 0x0000003c00b77306ULL, 0x0005e20000200c00ULL,
0x000001003f4e7824ULL, 0x002fe200078e00ffULL, 0x0000000719197812ULL, 0x000fe200078e788aULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000001001a7d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x000100001a7c7824ULL, 0x000fe200078e00ffULL, 0x0000003d00b47306ULL, 0x0003e20000200c00ULL,
0x00000100503c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000100005b8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ffab7819ULL, 0x000fe20000011450ULL,
0x000001001b7e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100005a8e7824ULL, 0x000fe200078e00ffULL, 0x0000004e00bc7306ULL, 0x0005e20000200c00ULL,
0x00000100533d7824ULL, 0x002fe200078e00ffULL, 0x0000888050b67816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fc40000011418ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000003c00b17306ULL, 0x0003e20000200c00ULL,
0x000000088a4e7824ULL, 0x004fe200078e0219ULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000888018847816ULL, 0x000fe400000000ffULL, 0x00000017ff18723eULL, 0x000fe400000000ffULL,
0x0000003d00ae7306ULL, 0x0005e20000200c00ULL, 0x00000100523c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fc4000001141aULL, 0x00000018ff507819ULL, 0x000fe40000011450ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003e00ba7306ULL, 0x000fe20000200c00ULL,
0x00000100553d7824ULL, 0x004fe200078e00ffULL, 0x000088801a807816ULL, 0x000fe400000000ffULL,
0x00005410181a7816ULL, 0x000fe40000000018ULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000003c00a97306ULL, 0x0003e20000200c00ULL, 0x00009910c1197816ULL, 0x000fe400000000ffULL,
0x00000018ff907819ULL, 0x000fe40000011453ULL, 0x0000888053877816ULL, 0x040fe200000000ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x000000ff1900720cULL, 0x000fe20003f05270ULL,
0x0000003d00a87306ULL, 0x0005e20000200c00ULL, 0x00000100543c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc40000011459ULL, 0x0000888059977816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003f00b87306ULL, 0x000fe20000200c00ULL,
0x00000100573d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000888049187816ULL, 0x020fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000003c00aa7306ULL, 0x0003e20000200c00ULL, 0x00000018ffa57819ULL, 0x000fe40000011452ULL,
0x0000888052b07816ULL, 0x040fe200000000ffULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145bULL, 0x000088805b8d7816ULL, 0x000fe200000000ffULL,
0x0000003d00a27306ULL, 0x0005e20000200c00ULL, 0x00000100563c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fc4000001141bULL, 0x000088801b5b7816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005100ad7306ULL, 0x0003e20000200c00ULL,
0x00000100593d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe20000011457ULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff3d7819ULL, 0x000fc4000001143dULL, 0x0000003c009d7306ULL, 0x0005e20000200c00ULL,
0x00000002ff517819ULL, 0x002fe40000011603ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00008880579b7816ULL, 0x040fe200000000ffULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x00000018ff987819ULL, 0x000fe20000011454ULL, 0x0000003d009a7306ULL, 0x000fe20000200c00ULL,
0x00000100583c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fc40000011455ULL,
0x00000018ff937819ULL, 0x000fe40000011456ULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004f00c27306ULL, 0x0003e20000200c00ULL, 0x00000018ff897819ULL, 0x000fe40000011458ULL,
0x0000888054a37816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe200078e00ffULL,
0x0000888055a17816ULL, 0x040fe200000000ffULL, 0x0001000055557824ULL, 0x000fe200078e00ffULL,
0x0000888056a47816ULL, 0x040fe200000000ffULL, 0x0000003c00997306ULL, 0x0005e20000200c00ULL,
0x00000008514f7810ULL, 0x002fe20007ffe0ffULL, 0x0001000056567824ULL, 0x000fe200078e00ffULL,
0x00001f511a517589ULL, 0x000fe200000e0000ULL, 0x00000018ff577819ULL, 0x000fc40000011457ULL,
0x00008880589c7816ULL, 0x040fe200000000ffULL, 0x0001000058587824ULL, 0x000fe200078e00ffULL,
0x0000005000b27306ULL, 0x0003e20000200c00ULL, 0x000001005a3c7824ULL, 0x004fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x000000bd00bd7306ULL, 0x000ea20000200c00ULL,
0x00001f4f1a507589ULL, 0x0023e200000e0000ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff7f7819ULL, 0x000fe4000001145aULL,
0x0000003c008f7306ULL, 0x0007e20000200c00ULL, 0x000088805a947816ULL, 0x000fe400000000ffULL,
0x000088804a1a7816ULL, 0x002fe400000000ffULL, 0x00000018ff737819ULL, 0x000fe40000011448ULL,
0x00000018ff717819ULL, 0x000fe20000011449ULL, 0x000000bb00bb7306ULL, 0x000e620000200c00ULL,
0x000120004e3c7811ULL, 0x008fc400078e20ffULL, 0x00005410bd197816ULL, 0x004fe400000000c2ULL,
0x00008880485a7816ULL, 0x000fe400000000ffULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x00000018ff6d7819ULL, 0x000fe40000011424ULL,
0x00000018ff6c7819ULL, 0x000fe40000011425ULL, 0x00000018ff927819ULL, 0x000fc40000011492ULL,
0x00000018ff8e7819ULL, 0x000fe2000001148eULL, 0x0000005300a77306ULL, 0x000fe20000200c00ULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x00000018ff857819ULL, 0x000fe40000011485ULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000001800537306ULL, 0x0009e20000200c00ULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x000000be00be7306ULL, 0x000f620000200c00ULL,
0x00005410bf187816ULL, 0x010fe400000000c4ULL, 0x00000018ff697819ULL, 0x000fe4000001141cULL,
0x00000018ff707819ULL, 0x000fc4000001144aULL, 0x00000018ff6f7819ULL, 0x000fe2000001144bULL,
0x0000007b007b7306ULL, 0x000f220000200c00ULL, 0x00000018ff687819ULL, 0x000fe4000001141dULL,
0x00000018ff6b7819ULL, 0x000fe40000011426ULL, 0x00000018ff6a7819ULL, 0x000fe20000011427ULL,
0x000000513c3c8232ULL, 0x084fe40000000000ULL, 0x0000005900957306ULL, 0x0005e20000200c00ULL,
0x000000513e3e8232ULL, 0x000fe20000000000ULL, 0x00000018ff677819ULL, 0x000fe2000001141eULL,
0x000000503d3d8232ULL, 0x080fe20000000000ULL, 0x00000018ff667819ULL, 0x000fe2000001141fULL,
0x000000503f3f8232ULL, 0x000fc60000000000ULL, 0x000000b500b57306ULL, 0x000f220000200c00ULL,
0x000100001b597824ULL, 0x004fe200078e00ffULL, 0x00000002031b7811ULL, 0x000fe400078fe0ffULL,
0x000000183c2c723cULL, 0x000fe4000000182cULL, 0x000000071b1b7812ULL, 0x000fe400078e788aULL,
0x000000b300b37306ULL, 0x000ea20000200c00ULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x00005410c0187816ULL, 0x002fc400000000bbULL, 0x00005410b9197816ULL, 0x008fe2000000005cULL,
0x000000088a5c7824ULL, 0x000fe400078e021bULL, 0x0000005200ac7306ULL, 0x0003e60000200c00ULL,
0x000120005c1b7811ULL, 0x000fe200078e20ffULL, 0x000000183c28723cULL, 0x000fe80000001828ULL,
0x000000b600b67306ULL, 0x000ee20000200c00ULL, 0x000000ffff527224ULL, 0x002fc400078e001aULL,
0x000001004a1a7824ULL, 0x000fe200078e00ffULL, 0x00005410be187816ULL, 0x020fe200000000b7ULL,
0x000001004bb77824ULL, 0x000fe200078e00ffULL, 0x000054107b197816ULL, 0x010fe400000000bcULL,
0x000000af00af7306ULL, 0x000e640000200c00ULL, 0x00000018ffb77819ULL, 0x000fc600000114b7ULL,
0x000000183c20723cULL, 0x000fe60000001820ULL, 0x00000057009e7306ULL, 0x0009f00000200c00ULL,
0x00000054009f7306ULL, 0x000be20000200c00ULL, 0x00000018ff577819ULL, 0x010fc4000001141aULL,
0x000088804b1a7816ULL, 0x000fca00000000ffULL, 0x0000005500a67306ULL, 0x0009e20000200c00ULL,
0x0001000049547824ULL, 0x020fe400078e00ffULL, 0x000000ffff7b7224ULL, 0x000fe400078e001aULL,
0x000000001b18783bULL, 0x000f620000000200ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000005600a07306ULL, 0x0003e20000200c00ULL, 0x0000010048557824ULL, 0x010fca00078e00ffULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x0000005800967306ULL, 0x0009e20000200c00ULL,
0x0001000048567824ULL, 0x002fe200078e00ffULL, 0x00005410ba487816ULL, 0x000fc800000000b5ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x000000ab00ab7306ULL, 0x000e620000200c00ULL,
0x0000010049587824ULL, 0x010fe200078e00ffULL, 0x00005410b8497816ULL, 0x004fe200000000b3ULL,
0x000100004ab37824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000000483c30723cULL, 0x000fe20000001830ULL,
0x00000018ffb37819ULL, 0x000fcc00000114b3ULL, 0x000000b000b07306ULL, 0x000f220000200c00ULL,
0x00005410b6487816ULL, 0x008fe400000000b1ULL, 0x00005410af497816ULL, 0x000fe200000000b4ULL,
0x000100004baf7824ULL, 0x000fe200078e00ffULL, 0x0000005118188232ULL, 0x0a0fe40000000000ULL,
0x000000511a1a8232ULL, 0x000fe20000000000ULL, 0x0000008700877306ULL, 0x000ee20000200c00ULL,
0x0000005019198232ULL, 0x080fe20000000000ULL, 0x000000483c34723cULL, 0x000fe20000001834ULL,
0x000000501b1b8232ULL, 0x000fca0000000000ULL, 0x000000a500a57306ULL, 0x000f620000200c00ULL,
0x00005410b2487816ULL, 0x002fe400000000abULL, 0x00005410ad497816ULL, 0x004fe4000000008cULL,
0x0000888024ab7816ULL, 0x000fe400000000ffULL, 0x00000018ff8c7819ULL, 0x000fe200000114afULL,
0x0000009000907306ULL, 0x000e640000200c00ULL, 0x000000483c44723cULL, 0x000fec0000001844ULL,
0x000000a300a37306ULL, 0x000ea20000200c00ULL, 0x00005410b0487816ULL, 0x010fe200000000a9ULL,
0x0000010024a97824ULL, 0x040fe200078e00ffULL, 0x0000541087497816ULL, 0x008fe200000000aeULL,
0x0001000024247824ULL, 0x000fc800078e00ffULL, 0x000000a100a17306ULL, 0x000ee40000200c00ULL,
0x000000483c40723cULL, 0x000fec0000001840ULL, 0x0000009800987306ULL, 0x000f220000200c00ULL,
0x00005410ac487816ULL, 0x020fe400000000a5ULL, 0x00005410a7497816ULL, 0x002fc40000000090ULL,
0x00000018ff907819ULL, 0x000fc600000114a9ULL, 0x0000005d005d7306ULL, 0x000e640000200c00ULL,
0x000000483c38723cULL, 0x000fec0000001838ULL, 0x000000a400a47306ULL, 0x000f620000200c00ULL,
0x00005410a33c7816ULL, 0x004fe200000000aaULL, 0x00000100253e7824ULL, 0x000fe200078e00ffULL,
0x00005410a13d7816ULL, 0x008fc400000000a8ULL, 0x0000888025487816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000009b009b7306ULL, 0x000ea40000200c00ULL, 0x0000003c182c723cULL, 0x000fe2000000182cULL,
0x00000018ff257819ULL, 0x000fca0000011425ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x00000004033d7811ULL, 0x000fe400078fe0ffULL, 0x000054109f3c7816ULL, 0x010fe40000000098ULL,
0x000000073d3f7812ULL, 0x000fe400078e788aULL, 0x00005410a63d7816ULL, 0x002fe2000000005dULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x00000018ff987819ULL, 0x000fe20000011424ULL,
0x000000088a5d7824ULL, 0x000fc800078e023fULL, 0x0000003c1828723cULL, 0x000fe20000001828ULL,
0x000120005d247811ULL, 0x000fe200078e20ffULL, 0x0000009c009c7306ULL, 0x000eea0000200c00ULL,
0x00005410a43c7816ULL, 0x020fe4000000009dULL, 0x000054109b3d7816ULL, 0x004fe200000000a2ULL,
0x0000009700977306ULL, 0x000ea20000200c00ULL, 0x00008880269d7816ULL, 0x000fce00000000ffULL,
0x0000003e00497306ULL, 0x0009f00000200c00ULL, 0x00000025009b7306ULL, 0x0003e20000200c00ULL,
0x0000003c183c723cULL, 0x010fe20000001820ULL, 0x000000002420783bULL, 0x00096c0000000200ULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x000054109e257816ULL, 0x002fe20000000091ULL,
0x000000ffff917224ULL, 0x000fe200078e009dULL, 0x00005410a0247816ULL, 0x010fe20000000093ULL,
0x0000010026937824ULL, 0x000fc400078e00ffULL, 0x0001000026267824ULL, 0x000fe400078e00ffULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000000241830723cULL, 0x000fe20000001830ULL, 0x00000018ff267819ULL, 0x000fca0000011426ULL,
0x0000009400947306ULL, 0x000f220000200c00ULL, 0x000054109c247816ULL, 0x008fe40000000099ULL,
0x0000541097257816ULL, 0x004fe4000000009aULL, 0x0000888027977816ULL, 0x000fc600000000ffULL,
0x0000008d008d7306ULL, 0x000fe40000200c00ULL, 0x000000241834723cULL, 0x040fec0000001834ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x0000541096247816ULL, 0x000fe20000000089ULL,
0x0000010027897824ULL, 0x000fe200078e00ffULL, 0x0000541095257816ULL, 0x002fe20000000088ULL,
0x0000005120208232ULL, 0x0a0fe20000000000ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x0000005122228232ULL, 0x000fe20000000000ULL, 0x000000ffff887224ULL, 0x000fe200078e0097ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000005021218232ULL, 0x080fe20000000000ULL,
0x000000241844723cULL, 0x000fe20000001844ULL, 0x0000005023238232ULL, 0x000fe20000000000ULL,
0x00000018ff277819ULL, 0x000fc80000011427ULL, 0x0000008e008e7306ULL, 0x000e620000200c00ULL,
0x0000541094247816ULL, 0x010fe4000000008fULL, 0x000054108d257816ULL, 0x004fca0000000092ULL,
0x0000005e005e7306ULL, 0x000fe40000200c00ULL, 0x000000241840723cULL, 0x000fec0000001840ULL,
0x0000008b008b7306ULL, 0x000ea20000200c00ULL, 0x00000018ff257819ULL, 0x000fe40000011489ULL,
0x000054108e247816ULL, 0x002fc4000000007fULL, 0x0000000603897811ULL, 0x000fc600078fe0ffULL,
0x0000008400847306ULL, 0x000fe20000200c00ULL, 0x0000000789897812ULL, 0x000fce00078e788aULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000008300837306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000ef00000200c00ULL, 0x00000025007f7306ULL, 0x0005f00000200c00ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x000054108b257816ULL, 0x004fe2000000005eULL,
0x000000088a5e7824ULL, 0x000fcc00078e0289ULL, 0x0000007900797306ULL, 0x000fe20000200c00ULL,
0x000000241818723cULL, 0x000fee0000001838ULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x0000541084247816ULL, 0x002fe20000000085ULL, 0x000001001c397824ULL, 0x000fe200078e00ffULL,
0x0000541083257816ULL, 0x008fc40000000086ULL, 0x000088801c387816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x0000008200827306ULL, 0x000e640000200c00ULL,
0x00000024202c723cULL, 0x000fe2000000182cULL, 0x000000ffff837224ULL, 0x000fe200078e0038ULL,
0x000120005e387811ULL, 0x000fe400078e20ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x0000541081247816ULL, 0x004fc4000000007aULL,
0x00000018ff7a7819ULL, 0x000fe40000011439ULL, 0x000000003838783bULL, 0x000ea60000000200ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x0000541082257816ULL, 0x002fe40000000079ULL,
0x000088801d797816ULL, 0x000fca00000000ffULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x000000242028723cULL, 0x000fee0000001828ULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x0000541080247816ULL, 0x008fce000000007dULL, 0x0000007500757306ULL, 0x000ff00000200c00ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x000054105b257816ULL, 0x002fe2000000007eULL,
0x000000ffff5b7224ULL, 0x000fc400078e0079ULL, 0x000001001d797824ULL, 0x000fe200078e00ffULL,
0x0000005138388232ULL, 0x084fe40000000000ULL, 0x000000513a3a8232ULL, 0x000fe20000000000ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x00000024203c723cULL, 0x000fe2000000183cULL,
0x0000005039398232ULL, 0x080fe40000000000ULL, 0x000000503b3b8232ULL, 0x000fc80000000000ULL,
0x0000005900597306ULL, 0x000eb00000200c00ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000054107c247816ULL, 0x002fce0000000075ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x0000541059257816ULL, 0x004fe40000000074ULL, 0x00000018ff747819ULL, 0x000fca0000011479ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000000242030723cULL, 0x000fee0000001830ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x000054105a247816ULL, 0x002fce0000000055ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541053257816ULL, 0x004fce0000000058ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000242034723cULL, 0x000fee0000001834ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000100001d257824ULL, 0x000fca00078e00ffULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000007000707306ULL, 0x000ff00000200c00ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00005410541d7816ULL, 0x002fce0000000071ULL,
0x0000005200527306ULL, 0x000ff00000200c00ULL, 0x0000005700577306ULL, 0x000e700000200c00ULL,
0x0000007b007b7306ULL, 0x000ff00000200c00ULL, 0x000000b7004a7306ULL, 0x000ea20000200c00ULL,
0x0000541052527816ULL, 0x002fce0000000057ULL, 0x000000b3004b7306ULL, 0x000e700000200c00ULL,
0x0000008c008c7306ULL, 0x000ee20000200c00ULL, 0x000054107b537816ULL, 0x004fe4000000004aULL,
0x000088801e4a7816ULL, 0x000fca00000000ffULL, 0x0000001c00247306ULL, 0x0005e20000200c00ULL,
0x000054104b707816ULL, 0x002fe20000000070ULL, 0x000000522040723cULL, 0x000fec0000001840ULL,
0x000000ab00877306ULL, 0x000fe20000200c00ULL, 0x00005410561c7816ULL, 0x004fe40000000073ULL,
0x000054108c717816ULL, 0x008fca000000006fULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x0000001c2044723cULL, 0x040fee0000001844ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x000001001e1c7824ULL, 0x040fe200078e00ffULL, 0x000000702018723cULL, 0x000fe20000001818ULL,
0x000100001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000088801f207816ULL, 0x000fe400000000ffULL, 0x00005410481d7816ULL, 0x002fca0000000049ULL,
0x0000001c004b7306ULL, 0x0002b00000200c00ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x00005410871c7816ULL, 0x002fce0000000090ULL, 0x0000001c382c723cULL, 0x000fe2000000182cULL,
0x0000006c006c7306ULL, 0x000e620000200c00ULL, 0x000054104a4a7816ULL, 0x004fca000000004bULL,
0x000000ffff1d7224ULL, 0x000fe400078e0020ULL, 0x000001001f207824ULL, 0x040fe200078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000100001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe40000011420ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054109b997816ULL, 0x002fce000000006cULL,
0x0000006900697306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000ff00000200c00ULL,
0x0000009800987306ULL, 0x000ea20000200c00ULL, 0x0000541024247816ULL, 0x002fce0000000069ULL,
0x0000009100917306ULL, 0x000ff00000200c00ULL, 0x00000093009a7306ULL, 0x000e620000200c00ULL,
0x0000541098987816ULL, 0x004fce000000006dULL, 0x0000008800887306ULL, 0x000ea20000200c00ULL,
0x000000983828723cULL, 0x000fee0000001828ULL, 0x0000002600267306ULL, 0x000ee20000200c00ULL,
0x0000541091207816ULL, 0x002fce000000009aULL, 0x0000002700277306ULL, 0x000e620000200c00ULL,
0x0000541088217816ULL, 0x004fce000000007fULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000541026267816ULL, 0x008fe2000000006bULL, 0x000000203820723cULL, 0x000fec000000183cULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x0000541027277816ULL, 0x002fce000000006aULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000000263830723cULL, 0x000fee0000001830ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x00005410835a7816ULL, 0x004fce000000007aULL,
0x0000002500257306ULL, 0x000eb00000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x000054105b5b7816ULL, 0x002fce0000000074ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x0000541025257816ULL, 0x004fe20000000068ULL, 0x0000005a3834723cULL, 0x040fec0000001834ULL,
0x0000006700677306ULL, 0x000fe40000200c00ULL, 0x000000243844723cULL, 0x000fec0000001844ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x000054101d4b7816ULL, 0x002fce0000000048ULL,
0x0000001e001e7306ULL, 0x000e620000200c00ULL, 0x0000004a3840723cULL, 0x000fee0000001840ULL,
0x0000001f001f7306ULL, 0x000ea20000200c00ULL, 0x000054101e1e7816ULL, 0x002fe40000000067ULL,
0x000054101f1f7816ULL, 0x004fce0000000066ULL, 0x0000001e3838723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff76ff7812ULL, 0x000fe2000782c0ffULL, 0x01c61000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000404d197811ULL, 0x000fe400078e40ffULL, 0x00000001ff597807ULL, 0x000fe40000800000ULL,
0x000000190000720cULL, 0x000fe40003f24070ULL, 0x000000ff77ff7812ULL, 0x000fc4000784c0ffULL,
0x000000010a00780cULL, 0x000fe40003f05270ULL, 0x00000001ff717807ULL, 0x000fe40001000000ULL,
0x0000007659767207ULL, 0x000fe40004000000ULL, 0x0000000178787812ULL, 0x000fe400078e0cffULL,
0x0000761071777816ULL, 0x000fe20000000077ULL, 0x0000836000009947ULL, 0x000fea0003800000ULL,
0x01c65c00ff197984ULL, 0x000e620000000800ULL, 0x8000000071187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x002fe20007824818ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000000d000001947ULL, 0x000fea0003800000ULL, 0x01c65c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe40007824818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000711a7824ULL, 0x000fe400078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01c65c00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000782481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000804d1b7811ULL, 0x040fe200078e40ffULL, 0x00000100ff3f7424ULL, 0x000fe200078e00ffULL,
0x00000004ff4a7819ULL, 0x000fe20000011603ULL, 0x000000080a6f7824ULL, 0x000fe200078e00ffULL,
0x0000001b001a7217ULL, 0x000fe20007800000ULL, 0x00006200043e7a24ULL, 0x100fe200078e021bULL,
0x000000014d1d7810ULL, 0x000fe20007ffe0ffULL, 0x000040000a707824ULL, 0x000fe200078e00ffULL,
0x000000084a567810ULL, 0x000fe20007ffe0ffULL, 0x000000011a3c7824ULL, 0x000fe200078e0a1bULL,
0x0000004a3e187210ULL, 0x000fc40007ffe005ULL, 0x000000021d00720cULL, 0x000fe40003f26070ULL,
0x000000024a527810ULL, 0x000fe20007ffe0ffULL, 0x00005e0018187625ULL, 0x080fe200078e003fULL,
0x000000064a587810ULL, 0x000fe40007ffe0ffULL, 0x000000563e247210ULL, 0x100fe40007ffe005ULL,
0x000000403c487807ULL, 0x000fe40000800000ULL, 0x000000523e1c7210ULL, 0x100fe20007ffe005ULL,
0x00005e0024247625ULL, 0x000fe200078e003fULL, 0x000000583e1e7210ULL, 0x000fc40007ffe005ULL,
0x0000000c4a507810ULL, 0x000fe20007ffe0ffULL, 0x00005e001c1a7625ULL, 0x080fe200078e003fULL,
0x000000044a667810ULL, 0x000fe40007ffe0ffULL, 0x0000004805487217ULL, 0x000fe20007800000ULL,
0x00005e001e1e7625ULL, 0x080fe200078e003fULL, 0x0000000c18187210ULL, 0x000fe40007f5e0ffULL,
0x000000503e3d7210ULL, 0x100fe20007ffe005ULL, 0x0000000148497824ULL, 0x100fe200078e0a05ULL,
0x000000663e1c7210ULL, 0x000fe20007ffe005ULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000000a4a547810ULL, 0x040fe20007ffe0ffULL, 0x00005e003d3c7625ULL, 0x000fe200078e003fULL,
0x0000000e4a5a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c24247210ULL, 0x080fe20007f9e0ffULL,
0x00005e001c1c7625ULL, 0x080fe200078e003fULL, 0x000000086f487812ULL, 0x000fe400078ec0ffULL,
0x0000000c1a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200020e0625ULL,
0x000000543e267210ULL, 0x000fe20007ffe005ULL, 0x00000000480473c2ULL, 0x000e6200000e0000ULL,
0x0000000c1e1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000005a3e3e7210ULL, 0x000fe20007ffe005ULL, 0x00005e0026267625ULL, 0x000fe200078e003fULL,
0x0000400070737812ULL, 0x000fc400078ec0ffULL, 0x0000000c3c3c7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e061fULL, 0x000000494a00720cULL, 0x000fe20003f86070ULL,
0x00005e003e3e7625ULL, 0x000fe200078e003fULL, 0x0000000c1c1c7210ULL, 0x000fe40007f5e0ffULL,
0x000000495200720cULL, 0x080fe20003fa6070ULL, 0x000000ffff3d7224ULL, 0x000fe200008e063dULL,
0x000000496600720cULL, 0x000fe20003f66070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x0001400073737810ULL, 0x000fc40007ffe0ffULL, 0x0000000c3e3e7210ULL, 0x080fe40007f3e0ffULL,
0x0000000c26267210ULL, 0x000fe20007f5e0ffULL, 0x000000100d4b7824ULL, 0x100fe400078e0273ULL,
0x000000100e517824ULL, 0x100fe200078e0273ULL, 0x0001c64804047890ULL, 0x002fe2000fffe03fULL,
0x000000100f537824ULL, 0x000fe200078e0273ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000184b7faeULL, 0x0003e2000e101c46ULL, 0x000000ffff3f7224ULL, 0x000fe200008e063fULL,
0x000000495800720cULL, 0x080fe20003f26070ULL, 0x000000ffff277224ULL, 0x000fe200010e0627ULL,
0x000000495600720cULL, 0x080fe20003f46070ULL, 0x000000001a517faeULL, 0x0005e2000e901c46ULL,
0x000000495400720cULL, 0x080fe20003f86070ULL, 0x0000001010557824ULL, 0x100fe200078e0273ULL,
0x000000495000720cULL, 0x080fe20003fa6070ULL, 0x000000001c537faeULL, 0x0007e2000d901c46ULL,
0x000000495a00720cULL, 0x000fe20003f66070ULL, 0x0000001011497824ULL, 0x100fe200078e0273ULL,
0x000000086f187812ULL, 0x002fe200078e0cffULL, 0x0000001012577824ULL, 0x000fc400078e0273ULL,
0x0000001013197824ULL, 0x100fe200078e0273ULL, 0x000000001e557faeULL, 0x0007e2000c901c46ULL,
0x00000010141b7824ULL, 0x004fc600078e0273ULL, 0x0000000024497faeULL, 0x0007e8000d101c46ULL,
0x0000000026577faeULL, 0x0007e8000e101c46ULL, 0x000000003c197faeULL, 0x0007e8000e901c46ULL,
0x000000003e1b7faeULL, 0x0007e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c0018197984ULL, 0x0082a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c61c00ff1a7984ULL, 0x000ee20000000800ULL, 0x0000006e596e7207ULL, 0x000fe20004000000ULL,
0x80000000151b7824ULL, 0x000fc600078e00ffULL, 0x0000ffff6e187812ULL, 0x002fc800078ec0ffULL,
0x00008880181c7816ULL, 0x000fca00000000ffULL, 0x800000001c187824ULL, 0x000fca00078e00ffULL,
0x8000000019ff7812ULL, 0x004fe40007804818ULL, 0x800000001aff7812ULL, 0x008fe2000782481bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff187424ULL, 0x000fe400078e00ffULL, 0x80000000151a7824ULL, 0x000fe400078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01c61c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000782481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x01c0800016197984ULL, 0x000e620000000800ULL,
0x00000001ffcf7424ULL, 0x000fc600078e00ffULL, 0x01c2800016187984ULL, 0x0004e20000000800ULL,
0x000000061900720bULL, 0x002fda0003f3d000ULL, 0x00000000001a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL, 0x0000034000009947ULL, 0x000fea0003800000ULL,
0x000000061900720bULL, 0x00cfe40003f34000ULL, 0x00000019061d7209ULL, 0x000fe40007810000ULL,
0x00000002ff1f7819ULL, 0x000fc60000011603ULL, 0x8000001d061a7221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1a1a7820ULL, 0x000fe40000410000ULL, 0x0000000000067806ULL, 0x000fe400008e0100ULL,
0x000000014c00780cULL, 0x000fe40003f25270ULL, 0x0000ffff061e7812ULL, 0x000fe200078e3cffULL,
0x0000001a001a7308ULL, 0x000e660000000800ULL, 0x0000001e1bff7212ULL, 0x000fc8000784c0ffULL,
0x00000001ffcf7807ULL, 0x000fc60001000000ULL, 0x01c4801d16009388ULL, 0x000fe80000000800ULL,
0x00001f1f1a067589ULL, 0x002e6400000e0000ULL, 0x8000001d191b2221ULL, 0x000fe40000010000ULL,
0x0000001a07077220ULL, 0x000fe20000410000ULL, 0x00001f4f1a197589ULL, 0x000ea200000e0000ULL,
0x3fb8aa3b1b1b2820ULL, 0x000fc80000410000ULL, 0x0000001b00172308ULL, 0x000ee20000000800ULL,
0x000000062c2c7220ULL, 0x082fe40000410000ULL, 0x000000062d2d7220ULL, 0x080fe40000410000ULL,
0x0000000628287220ULL, 0x080fe40000410000ULL, 0x0000000629297220ULL, 0x080fe40000410000ULL,
0x0000000620207220ULL, 0x080fe40000410000ULL, 0x0000000621217220ULL, 0x000fc40000410000ULL,
0x0000000630307220ULL, 0x080fe40000410000ULL, 0x0000000631317220ULL, 0x080fe40000410000ULL,
0x0000000634347220ULL, 0x080fe40000410000ULL, 0x0000000635357220ULL, 0x080fe40000410000ULL,
0x0000000644447220ULL, 0x080fe40000410000ULL, 0x0000000645457220ULL, 0x000fc40000410000ULL,
0x0000000640407220ULL, 0x080fe40000410000ULL, 0x0000000641417220ULL, 0x080fe40000410000ULL,
0x0000000638387220ULL, 0x080fe40000410000ULL, 0x0000000639397220ULL, 0x000fe40000410000ULL,
0x000000192e2e7220ULL, 0x084fe40000410000ULL, 0x000000192f2f7220ULL, 0x000fc40000410000ULL,
0x000000192a2a7220ULL, 0x080fe40000410000ULL, 0x000000192b2b7220ULL, 0x080fe40000410000ULL,
0x0000001922227220ULL, 0x080fe40000410000ULL, 0x0000001923237220ULL, 0x080fe40000410000ULL,
0x0000001932327220ULL, 0x080fe40000410000ULL, 0x0000001933337220ULL, 0x000fc40000410000ULL,
0x0000001936367220ULL, 0x080fe40000410000ULL, 0x0000001937377220ULL, 0x080fe40000410000ULL,
0x0000001946467220ULL, 0x080fe40000410000ULL, 0x0000001947477220ULL, 0x080fe40000410000ULL,
0x0000001942427220ULL, 0x080fe40000410000ULL, 0x0000001943437220ULL, 0x000fc40000410000ULL,
0x000000193a3a7220ULL, 0x080fe40000410000ULL, 0x000000193b3b7220ULL, 0x000fe40000410000ULL,
0x000000ffff067224ULL, 0x000fe400078e001dULL, 0x0000001817182220ULL, 0x008fc80000410000ULL,
0x0000000718077221ULL, 0x00cfe20000010000ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x000000080a1a7824ULL, 0x000fe400078e00ffULL, 0x800000001c197824ULL, 0x000fc600078e00ffULL,
0x000000081a1a7812ULL, 0x000fca00078e0cffULL, 0x01c64c001a187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x0000009000000947ULL, 0x000fea0003800000ULL, 0x800000001c1c7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff187424ULL, 0x000fc800078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01c64c001a197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000780481cULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000010a747812ULL, 0x000fc800078e0cffULL, 0x0001400074747811ULL, 0x000fca00078e70ffULL,
0x00000010726d7824ULL, 0x100fe400078e0274ULL, 0x00000010656c7824ULL, 0x100fe400078e0274ULL,
0x0000001062697824ULL, 0x100fe200078e0274ULL, 0x000000006d3c783bULL, 0x000e620000004200ULL,
0x00000010636a7824ULL, 0x100fe400078e0274ULL, 0x0000001061687824ULL, 0x100fe200078e0274ULL,
0x000000006c50783bULL, 0x000fe20000004200ULL, 0x00000010646b7824ULL, 0x000fc400078e0274ULL,
0x0000001060677824ULL, 0x100fe200078e0274ULL, 0x000000006948783bULL, 0x000ea20000004200ULL,
0x000000105f667824ULL, 0x000fc600078e0274ULL, 0x000000006a58783bULL, 0x000ee80000004200ULL,
0x000000006818783bULL, 0x000fe80000004200ULL, 0x000000006b54783bULL, 0x000f280000004200ULL,
0x000000006724783bULL, 0x000fe80000004200ULL, 0x00000000661c783bULL, 0x000fe20000004200ULL,
0x00000018ffc87819ULL, 0x002fe2000001143cULL, 0x000001003c857824ULL, 0x040fe200078e00ffULL,
0x000088803ccc7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ffc77819ULL, 0x000fe2000001143dULL, 0x000001003d867824ULL, 0x040fe200078e00ffULL,
0x000088803dcb7816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000010048937824ULL, 0x044fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x00010000488d7824ULL, 0x000fe200078e00ffULL,
0x0000003c00c97306ULL, 0x0003e20000200c00ULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x000001005b9b7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000100005b997824ULL, 0x000fe200078e00ffULL, 0x00000018ffc17819ULL, 0x000fe2000001143eULL,
0x000001004a887824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe2000001143fULL,
0x0000008500cd7306ULL, 0x0005e20000200c00ULL, 0x000001003e3c7824ULL, 0x042fe200078e00ffULL,
0x000088803ec67816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011451ULL, 0x0000010049967824ULL, 0x040fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x00010000498e7824ULL, 0x000fe200078e00ffULL,
0x0000008600ce7306ULL, 0x0003e20000200c00ULL, 0x000088803f857816ULL, 0x004fe200000000ffULL,
0x0001000052b87824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000010055b47824ULL, 0x010fe200078e00ffULL, 0x00008880518f7816ULL, 0x000fe200000000ffULL,
0x0001000055b07824ULL, 0x000fe200078e00ffULL, 0x00000018ffbb7819ULL, 0x000fe20000011450ULL,
0x0000003c00c57306ULL, 0x0005e20000200c00ULL, 0x000001003f867824ULL, 0x042fe200078e00ffULL,
0x0000888050c07816ULL, 0x000fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011448ULL, 0x0000010056ab7824ULL, 0x000fe200078e00ffULL,
0x0000888048927816ULL, 0x000fe200000000ffULL, 0x0000010057ac7824ULL, 0x040fe200078e00ffULL,
0x0000003d00ca7306ULL, 0x0003e20000200c00ULL, 0x00000100503c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001143fULL, 0x0001000050507824ULL, 0x000fe200078e00ffULL,
0x00000017ff48723eULL, 0x000fe200000000ffULL, 0x0001000056aa7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0001000057a77824ULL, 0x000fe200078e00ffULL,
0x0000003e00c27306ULL, 0x000fe20000200c00ULL, 0x00000100513d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001145bULL, 0x0001000051517824ULL, 0x000fe200078e00ffULL,
0x000088805b9a7816ULL, 0x000fe200000000ffULL, 0x000100004a5b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000010059a47824ULL, 0x040fe200078e00ffULL,
0x0000003c00bf7306ULL, 0x0003e20000200c00ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0001000059a07824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe2000001144aULL,
0x0000010054b57824ULL, 0x040fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x0001000054ad7824ULL, 0x000fe200078e00ffULL, 0x000088804a897816ULL, 0x000fe200000000ffULL,
0x0000003f00c37306ULL, 0x000fe20000200c00ULL, 0x00000100523c7824ULL, 0x002fe200078e00ffULL,
0x00005410484a7816ULL, 0x000fe20000000048ULL, 0x0000010053b77824ULL, 0x040fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011449ULL, 0x0001000053b67824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000010058a57824ULL, 0x040fe200078e00ffULL,
0x0000003d00be7306ULL, 0x000fe20000200c00ULL, 0x0000888049917816ULL, 0x000fe200000000ffULL,
0x0001000058a27824ULL, 0x000fe200078e00ffULL, 0x00009910cf497816ULL, 0x000fe200000000ffULL,
0x000001005a9c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x000100005a987824ULL, 0x000fe200078e00ffULL, 0x000000ff4900720cULL, 0x000fe20003f05270ULL,
0x0000003c00b97306ULL, 0x0003e20000200c00ULL, 0x0000888019487816ULL, 0x000fe200000000ffULL,
0x000001004b877824ULL, 0x000fe200078e00ffULL, 0x00000018ffb37819ULL, 0x000fc40000011452ULL,
0x00000018ffa17819ULL, 0x000fe40000011455ULL, 0x00000018ff9f7819ULL, 0x000fe20000011456ULL,
0x0000005100bd7306ULL, 0x0005e20000200c00ULL, 0x000128004e3c7811ULL, 0x002fe400078e20ffULL,
0x00000018ff9e7819ULL, 0x000fe40000011457ULL, 0x00000018ff957819ULL, 0x000fe40000011459ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000005000bc7306ULL, 0x0003e20000200c00ULL,
0x00000002ff517819ULL, 0x004fc40000011603ULL, 0x0000888052ba7816ULL, 0x000fe200000000ffULL,
0x0001000019527824ULL, 0x000fe200078e00ffULL, 0x0000888055b17816ULL, 0x000fe200000000ffULL,
0x0001000018557824ULL, 0x000fe200078e00ffULL, 0x00001f514a517589ULL, 0x000ea200000e0000ULL,
0x000000cc00cc7306ULL, 0x000ee20000200c00ULL, 0x0000888056ae7816ULL, 0x000fe200000000ffULL,
0x0000010018567824ULL, 0x000fe200078e00ffULL, 0x00001f4f4a507589ULL, 0x002e6200000e0000ULL,
0x0000888057a97816ULL, 0x000fe200000000ffULL, 0x0000010019577824ULL, 0x000fe200078e00ffULL,
0x0000888059a37816ULL, 0x000fc400000000ffULL, 0x000000cb00cb7306ULL, 0x000f220000200c00ULL,
0x00000018ffa87819ULL, 0x000fe40000011454ULL, 0x00000018ff807819ULL, 0x000fe40000011418ULL,
0x00000018ff7f7819ULL, 0x000fe40000011419ULL, 0x0000888054b27816ULL, 0x000fe200000000ffULL,
0x000000c800c87306ULL, 0x000f620000200c00ULL, 0x0000888018597816ULL, 0x000fe400000000ffULL,
0x00005410cc187816ULL, 0x008fc400000000cdULL, 0x00000018ffaf7819ULL, 0x000fe40000011453ULL,
0x0000888053907816ULL, 0x000fe200000000ffULL, 0x000000c700c77306ULL, 0x000ee20000200c00ULL,
0x00005410cb197816ULL, 0x010fe400000000ceULL, 0x00000018ff977819ULL, 0x000fe40000011458ULL,
0x0000888058a67816ULL, 0x000fe200000000ffULL, 0x000000513c3c8232ULL, 0x084fe40000000000ULL,
0x000000c600c67306ULL, 0x000fe20000200c00ULL, 0x000000513e3e8232ULL, 0x000fe20000000000ULL,
0x00000018ff8b7819ULL, 0x000fe2000001145aULL, 0x000000503d3d8232ULL, 0x082fe20000000000ULL,
0x000088805a9d7816ULL, 0x000fe200000000ffULL, 0x000000503f3f8232ULL, 0x000fe20000000000ULL,
0x00000018ff817819ULL, 0x000fe2000001144bULL, 0x000100004b5a7824ULL, 0x000fe200078e00ffULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x00000018ffb77819ULL, 0x000fc400000114b7ULL,
0x00000018ffb87819ULL, 0x000fe200000114b8ULL, 0x000000183c2c723cULL, 0x000fe2000000182cULL,
0x00000018ffb67819ULL, 0x000fe400000114b6ULL, 0x00000018ffb57819ULL, 0x000fe200000114b5ULL,
0x0000008600c47306ULL, 0x0002a20000200c00ULL, 0x00000018ffb47819ULL, 0x000fe400000114b4ULL,
0x00005410c9187816ULL, 0x020fe400000000c8ULL, 0x00005410ca197816ULL, 0x008fc400000000c7ULL,
0x00000018ff7e7819ULL, 0x000fe2000001141aULL, 0x0000004800547306ULL, 0x0007e20000200c00ULL,
0x000088804b867816ULL, 0x002fe400000000ffULL, 0x00000018ffad7819ULL, 0x000fe200000114adULL,
0x000000183c28723cULL, 0x000fe20000001828ULL, 0x00000018ffb07819ULL, 0x000fe400000114b0ULL,
0x00000018ff7d7819ULL, 0x000fe2000001141bULL, 0x000000c100c17306ULL, 0x000fe20000200c00ULL,
0x000088801a487816ULL, 0x008fc400000000ffULL, 0x0000541085497816ULL, 0x004fe200000000c4ULL,
0x000001001bc47824ULL, 0x040fe200078e00ffULL, 0x000128005c197811ULL, 0x000fe200078e20ffULL,
0x000000ffff537224ULL, 0x000fe200078e0048ULL, 0x000088801b187816ULL, 0x040fe200000000ffULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000001001a487824ULL, 0x040fe200078e00ffULL,
0x00000018ffaa7819ULL, 0x000fe200000114aaULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ffa77819ULL, 0x000fe200000114a7ULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fc40000011448ULL, 0x00005410c6487816ULL, 0x000fe200000000c5ULL,
0x000000c000c07306ULL, 0x000ea20000200c00ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x00000018ffab7819ULL, 0x000fe400000114abULL, 0x00000018ffac7819ULL, 0x000fe200000114acULL,
0x000000483c48723cULL, 0x000fe20000001820ULL, 0x000000001920783bULL, 0x0002e20000000200ULL,
0x0000008f008f7306ULL, 0x000f220000200c00ULL, 0x00000018ffa57819ULL, 0x000fc400000114a5ULL,
0x00000018ffa47819ULL, 0x000fe400000114a4ULL, 0x00000018ff7c7819ULL, 0x000fe40000011424ULL,
0x00005410c3197816ULL, 0x002fe2000000008cULL, 0x0000001800857306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011425ULL, 0x00000018ffa27819ULL, 0x000fe400000114a2ULL,
0x00000018ffa07819ULL, 0x000fc400000114a0ULL, 0x00000018ff9c7819ULL, 0x000fe2000001149cULL,
0x000000bb00bb7306ULL, 0x000f620000200c00ULL, 0x00005410c2187816ULL, 0x002fe400000000c1ULL,
0x00000018ff9b7819ULL, 0x000fe4000001149bULL, 0x00000018ff987819ULL, 0x000fe40000011498ULL,
0x00000018ff997819ULL, 0x000fe20000011499ULL, 0x0000009400947306ULL, 0x000e620000200c00ULL,
0x000000183c30723cULL, 0x000fe20000001830ULL, 0x00000018ff937819ULL, 0x000fc40000011493ULL,
0x00000018ff967819ULL, 0x000fe40000011496ULL, 0x00000018ff7a7819ULL, 0x000fe40000011426ULL,
0x000000ba00ba7306ULL, 0x000e620000200c00ULL, 0x00005410c0187816ULL, 0x004fe400000000bfULL,
0x000054108f197816ULL, 0x010fe400000000beULL, 0x00000018ff8f7819ULL, 0x000fe4000001141aULL,
0x00008880241a7816ULL, 0x000fe200000000ffULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x0000005120208232ULL, 0x088fe20000000000ULL, 0x000000183c34723cULL, 0x000fe20000001834ULL,
0x0000005122228232ULL, 0x000fe20000000000ULL, 0x00000018ff8d7819ULL, 0x000fe2000001148dULL,
0x0000005021218232ULL, 0x080fe20000000000ULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0000005023238232ULL, 0x000fe20000000000ULL, 0x000000b700b77306ULL, 0x000ea20000200c00ULL,
0x00005410bc187816ULL, 0x020fc400000000bbULL, 0x00005410bd197816ULL, 0x002fe40000000094ULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff877819ULL, 0x000fe20000011487ULL,
0x000000b300b37306ULL, 0x000fe20000200c00ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x000000183c44723cULL, 0x000fe20000001844ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x000000af00af7306ULL, 0x000fe20000200c00ULL, 0x00005410ba187816ULL, 0x000fe400000000b9ULL,
0x0000541090197816ULL, 0x004fe200000000b7ULL, 0x000000ffff907224ULL, 0x000fe200078e001aULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x00000100241a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x000000b800b87306ULL, 0x000e620000200c00ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x000000183c40723cULL, 0x000fe20000001840ULL,
0x00000018ff1a7819ULL, 0x000fc4000001141aULL, 0x00000018ff8c7819ULL, 0x000fe400000114c4ULL,
0x00000018ff247819ULL, 0x000fe20000011424ULL, 0x000000b600b67306ULL, 0x000ea20000200c00ULL,
0x00000018ff787819ULL, 0x000fe4000001141cULL, 0x00000018ff797819ULL, 0x000fe40000011427ULL,
0x00000018ff777819ULL, 0x000fe4000001141dULL, 0x00000018ff767819ULL, 0x000fe2000001141eULL,
0x000000b200b27306ULL, 0x000fe20000200c00ULL, 0x00005410b8187816ULL, 0x002fc400000000b3ULL,
0x00000018ff757819ULL, 0x000fca000001141fULL, 0x000000b500b57306ULL, 0x000fe20000200c00ULL,
0x00005410b6197816ULL, 0x004fce00000000afULL, 0x000000b100b17306ULL, 0x000fe20000200c00ULL,
0x000000183c38723cULL, 0x000fee0000001838ULL, 0x000000b400b47306ULL, 0x000e620000200c00ULL,
0x0000888025187816ULL, 0x000fe400000000ffULL, 0x00008880263e7816ULL, 0x000fca00000000ffULL,
0x000000a800a87306ULL, 0x000ff00000200c00ULL, 0x000000a100a17306ULL, 0x000fe20000200c00ULL,
0x00005410b1197816ULL, 0x002fce00000000b4ULL, 0x000000ad00ad7306ULL, 0x000e700000200c00ULL,
0x000000b000b07306ULL, 0x000eb00000200c00ULL, 0x0000009f009f7306ULL, 0x000ff00000200c00ULL,
0x0000009e009e7306ULL, 0x000ff00000200c00ULL, 0x000000aa00aa7306ULL, 0x000ff00000200c00ULL,
0x000000a700a77306ULL, 0x000ff00000200c00ULL, 0x0000001b00947306ULL, 0x0007f00000200c00ULL,
0x00000018003c7306ULL, 0x0009e20000200c00ULL, 0x00000100251b7824ULL, 0x008fc400078e00ffULL,
0x0001000025257824ULL, 0x000fc600078e00ffULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x000000ae00ae7306ULL, 0x000fe20000200c00ULL, 0x00005410b2187816ULL, 0x010fe400000000b5ULL,
0x00000018ff257819ULL, 0x000fca0000011425ULL, 0x000000ab00ab7306ULL, 0x000ee20000200c00ULL,
0x00000018202c723cULL, 0x000fee000000182cULL, 0x000000a900a97306ULL, 0x000fe20000200c00ULL,
0x00005410ad187816ULL, 0x002fe400000000a8ULL, 0x00005410b0197816ULL, 0x004fca00000000a1ULL,
0x000000ac00ac7306ULL, 0x000e640000200c00ULL, 0x000000182028723cULL, 0x000fec0000001828ULL,
0x000000a600a67306ULL, 0x000fe20000200c00ULL, 0x00005410ae187816ULL, 0x008fce00000000abULL,
0x000000a500a57306ULL, 0x000ea20000200c00ULL, 0x00005410a9197816ULL, 0x002fce00000000acULL,
0x000000a300a37306ULL, 0x000fe20000200c00ULL, 0x000000182048723cULL, 0x000fee0000001848ULL,
0x000000a400a47306ULL, 0x000e700000200c00ULL, 0x0000002400a17306ULL, 0x0007f00000200c00ULL,
0x0000002500a87306ULL, 0x0009e20000200c00ULL, 0x00005410aa247816ULL, 0x008fce000000009fULL,
0x0000009700977306ULL, 0x000fe20000200c00ULL, 0x00005410a7257816ULL, 0x010fe2000000009eULL,
0x000000ffff9e7224ULL, 0x000fe400078e003eULL, 0x00000100263e7824ULL, 0x000fc800078e00ffULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x000000242030723cULL, 0x000fe20000001830ULL,
0x00000018ff9f7819ULL, 0x000fe4000001143eULL, 0x00008880273e7816ULL, 0x000fc800000000ffULL,
0x000000a200a27306ULL, 0x000ee20000200c00ULL, 0x00005410a6247816ULL, 0x004fe400000000a5ULL,
0x00005410a3257816ULL, 0x002fca00000000a4ULL, 0x000000a000a07306ULL, 0x000e640000200c00ULL,
0x000000242034723cULL, 0x000fec0000001834ULL, 0x0000009d009d7306ULL, 0x000fe20000200c00ULL,
0x00005410a2247816ULL, 0x008fce0000000097ULL, 0x0000009c009c7306ULL, 0x000ea20000200c00ULL,
0x00005410a0257816ULL, 0x002fe20000000095ULL, 0x000000ffff957224ULL, 0x000fe400078e003eULL,
0x00000100273e7824ULL, 0x000fc800078e00ffULL, 0x0000009a009a7306ULL, 0x000fe20000200c00ULL,
0x000000242044723cULL, 0x000fee0000001844ULL, 0x0000009b009b7306ULL, 0x000e620000200c00ULL,
0x000054109d247816ULL, 0x004fce000000009cULL, 0x0000001a003d7306ULL, 0x0005f00000200c00ULL,
0x0000001b003f7306ULL, 0x0007220000200c00ULL, 0x000128005d1a7811ULL, 0x004fe400078e20ffULL,
0x000054109a257816ULL, 0x002fca000000009bULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x000000001a18783bULL, 0x008e620000000200ULL, 0x000000242040723cULL, 0x000fec0000001840ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff247819ULL, 0x000fe2000001143eULL,
0x00010000263e7824ULL, 0x000fe200078e00ffULL, 0x000054103c3f7816ULL, 0x010fc8000000003fULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000009800987306ULL, 0x000ff00000200c00ULL,
0x0000009900997306ULL, 0x000eb00000200c00ULL, 0x0000002400267306ULL, 0x0007e20000200c00ULL,
0x0000541099257816ULL, 0x004fce000000008aULL, 0x0000009200927306ULL, 0x000fe20000200c00ULL,
0x0000541098247816ULL, 0x008fe2000000008bULL, 0x0000005118188232ULL, 0x082fe20000000000ULL,
0x000088801c8b7816ULL, 0x000fe200000000ffULL, 0x000000511a1a8232ULL, 0x000fe40000000000ULL,
0x0000005019198232ULL, 0x080fe40000000000ULL, 0x0000009300937306ULL, 0x000e620000200c00ULL,
0x000000242020723cULL, 0x000fe20000001838ULL, 0x000000501b1b8232ULL, 0x000fcc0000000000ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x0001000027257824ULL, 0x000fe200078e00ffULL,
0x000128005e387811ULL, 0x000fe200078e20ffULL, 0x000001001c397824ULL, 0x040fe400078e00ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x0000009600967306ULL, 0x000ea20000200c00ULL, 0x0000541092247816ULL, 0x002fe40000000093ULL,
0x00000018ff1c7819ULL, 0x000fca000001141cULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000008300837306ULL, 0x000ff00000200c00ULL, 0x0000008d008d7306ULL, 0x000e700000200c00ULL,
0x0000008e008e7306ULL, 0x000ef00000200c00ULL, 0x00000025008a7306ULL, 0x0005f00000200c00ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x0000541091257816ULL, 0x004fce0000000096ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x00000024182c723cULL, 0x000fee000000182cULL,
0x0000008600867306ULL, 0x000fe20000200c00ULL, 0x000054108d247816ULL, 0x002fe40000000084ULL,
0x000054108e257816ULL, 0x008fc40000000083ULL, 0x000088801d837816ULL, 0x000fe400000000ffULL,
0x00000018ff847819ULL, 0x000fe20000011439ULL, 0x0000008700877306ULL, 0x000e620000200c00ULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x000000241828723cULL, 0x000fec0000001828ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x0000541089247816ULL, 0x004fce0000000088ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541086257816ULL, 0x002fce0000000087ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x000000241848723cULL, 0x000fee0000001848ULL,
0x0000005a005a7306ULL, 0x000eb00000200c00ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000054105b247816ULL, 0x002fe20000000082ULL, 0x0000005138388232ULL, 0x008fc40000000000ULL,
0x000000513a3a8232ULL, 0x000fe40000000000ULL, 0x0000005039398232ULL, 0x080fe40000000000ULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x000054105a257816ULL, 0x004fe20000000081ULL,
0x000000503b3b8232ULL, 0x000fcc0000000000ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000000241830723cULL, 0x000fee0000001830ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000541059247816ULL, 0x002fce0000000056ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541054257816ULL, 0x004fce0000000057ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x000000241834723cULL, 0x000fee0000001834ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000100001d247824ULL, 0x000fce00078e00ffULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000005800587306ULL, 0x000ff00000200c00ULL, 0x0000008c008c7306ULL, 0x000e700000200c00ULL,
0x0000007e007e7306ULL, 0x000ff00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000541085257816ULL, 0x002fce000000008cULL, 0x0000008f008f7306ULL, 0x000e700000200c00ULL,
0x0000003e00277306ULL, 0x0005f00000200c00ULL, 0x0000001c00577306ULL, 0x0007e20000200c00ULL,
0x000001001d3e7824ULL, 0x004fe200078e00ffULL, 0x00005410521d7816ULL, 0x000fc4000000007fULL,
0x00000018ff527819ULL, 0x000fe40000011424ULL, 0x0000541053247816ULL, 0x000fe40000000058ULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x00005410551c7816ULL, 0x008fe40000000080ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x000000241840723cULL, 0x040fe60000001840ULL,
0x0000003e005a7306ULL, 0x0005e80000200c00ULL, 0x000001001e257824ULL, 0x040fe200078e00ffULL,
0x0000001c1844723cULL, 0x000fe60000001844ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x000088801e3e7816ULL, 0x044fe200000000ffULL, 0x000100001e1e7824ULL, 0x000fc400078e00ffULL,
0x000054108f1c7816ULL, 0x002fe4000000007eULL, 0x00005410941d7816ULL, 0x000fe2000000007dULL,
0x000000ffff247224ULL, 0x000fe200078e003eULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000007900797306ULL, 0x000e680000200c00ULL, 0x0000001c1818723cULL, 0x000fe20000001820ULL,
0x00005410a87d7816ULL, 0x008fc6000000007bULL, 0x0000007c007c7306ULL, 0x000ea60000200c00ULL,
0x000001001f207824ULL, 0x000fe200078e00ffULL, 0x0000541095217816ULL, 0x000fe20000000026ULL,
0x000100001f267824ULL, 0x040fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe40000011425ULL,
0x000088801f1c7816ULL, 0x000fe200000000ffULL, 0x0000007a007a7306ULL, 0x000ee20000200c00ULL,
0x00000018ff257819ULL, 0x000fc40000011420ULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x000054108a7b7816ULL, 0x002fe40000000079ULL, 0x00005410a17c7816ULL, 0x004fe2000000007cULL,
0x0000007800787306ULL, 0x000e6c0000200c00ULL, 0x0000007c3828723cULL, 0x000fe40000001828ULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x00005410277a7816ULL, 0x008fce000000007aULL,
0x0000009000907306ULL, 0x000ea20000200c00ULL, 0x0000541057787816ULL, 0x002fe20000000078ULL,
0x0000007a3830723cULL, 0x000fec0000001830ULL, 0x0000009e009e7306ULL, 0x000ff00000200c00ULL,
0x0000009f009f7306ULL, 0x000e620000200c00ULL, 0x00005410903e7816ULL, 0x004fce000000003dULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000003e382c723cULL, 0x000fee000000182cULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000054109e207816ULL, 0x002fce000000009fULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x000000203820723cULL, 0x000fee0000001848ULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x000054108b827816ULL, 0x004fce0000000084ULL,
0x0000002400247306ULL, 0x000fe20000200c00ULL, 0x0000541083837816ULL, 0x002fce000000005aULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x0000541052797816ULL, 0x008fe20000000077ULL,
0x000000823834723cULL, 0x040fec0000001834ULL, 0x0000001c001c7306ULL, 0x000fe40000200c00ULL,
0x000000783844723cULL, 0x000fec0000001844ULL, 0x0000002500257306ULL, 0x000ea20000200c00ULL,
0x0000541024247816ULL, 0x002fce000000001dULL, 0x0000007600767306ULL, 0x000ff00000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054101c257816ULL, 0x004fce0000000025ULL,
0x0000001e001f7306ULL, 0x000e620000200c00ULL, 0x000000243840723cULL, 0x000fee0000001840ULL,
0x0000002600267306ULL, 0x000ea20000200c00ULL, 0x000054101f767816ULL, 0x002fe40000000076ULL,
0x0000541026777816ULL, 0x004fce0000000075ULL, 0x000000763838723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ff6eff7812ULL, 0x000fe2000784c0ffULL, 0x01c62000ffff7f8cULL, 0x000fe2000c80043fULL,
0x000000804d197811ULL, 0x000fe400078e40ffULL, 0x00000001ff757807ULL, 0x000fe40001000000ULL,
0x000000190000720cULL, 0x000fe40003f44070ULL, 0x000000ff0bff7812ULL, 0x000fc4000780c0ffULL,
0x000000010a787812ULL, 0x000fe4000782c0ffULL, 0x00000001ff777807ULL, 0x000fe40004000000ULL,
0x0000006e75767207ULL, 0x000fca0004800000ULL, 0x000057a00000a947ULL, 0x000fea0003800000ULL,
0x01c65c00ff197984ULL, 0x000e620000000800ULL, 0x00000001ff1a7807ULL, 0x000fca0004000000ULL,
0x800000001a187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x002fe20007824818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fe40007824818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x800000001a1a7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fc4000782481aULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000000c04d1b7811ULL, 0x040fe200078e40ffULL,
0x00000100ff4a7424ULL, 0x000fe200078e00ffULL, 0x00000004ff497819ULL, 0x000fe40000011603ULL,
0x000000014d197810ULL, 0x000fe20007ffe0ffULL, 0x00006200043c7a24ULL, 0x000fe200078e021bULL,
0x0000000249597810ULL, 0x000fe40007ffe0ffULL, 0x0000001b001a7217ULL, 0x000fe40007800000ULL,
0x000000493c187210ULL, 0x000fc40007ffe005ULL, 0x000000021900720cULL, 0x000fe20003f86070ULL,
0x000000011a267824ULL, 0x000fe200078e0a1bULL, 0x000000593c1c7210ULL, 0x000fe20007ffe005ULL,
0x00005e0018187625ULL, 0x080fe200078e004aULL, 0x0000000849577810ULL, 0x040fe40007ffe0ffULL,
0x0000000449557810ULL, 0x040fe20007ffe0ffULL, 0x00005e001c1a7625ULL, 0x000fe200078e004aULL,
0x0000000c18187210ULL, 0x000fe40007f3e0ffULL, 0x00000006494b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000a49517810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000000c49537810ULL, 0x040fe40007ffe0ffULL, 0x0000000e495b7810ULL, 0x000fe40007ffe0ffULL,
0x000000573c247210ULL, 0x100fe40007ffe005ULL, 0x00000040263e7807ULL, 0x000fe40002000000ULL,
0x000000553c1d7210ULL, 0x100fe20007ffe005ULL, 0x00005e0024247625ULL, 0x000fe200078e004aULL,
0x0000004b3c1e7210ULL, 0x000fc40007ffe005ULL, 0x000000513c277210ULL, 0x140fe20007ffe005ULL,
0x00005e001d1c7625ULL, 0x080fe200078e004aULL, 0x000000533c3d7210ULL, 0x140fe40007ffe005ULL,
0x0000005b3c3f7210ULL, 0x000fe20007ffe005ULL, 0x00005e001e1e7625ULL, 0x000fe200078e004aULL,
0x0000000c1a1a7210ULL, 0x000fe40007f3e0ffULL, 0x0000003e05487217ULL, 0x000fe20007800000ULL,
0x00005e0027267625ULL, 0x000fe200078e004aULL, 0x0000000c1e1e7210ULL, 0x000fc40007f7e0ffULL,
0x0000000c1c1c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e003d3c7625ULL, 0x000fc800078e004aULL,
0x00005e003f3e7625ULL, 0x000fc800078e004aULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x0000000c24247210ULL, 0x000fe20007f3e0ffULL, 0x000000080a4a7824ULL, 0x000fe400078e00ffULL,
0x0000000148487824ULL, 0x000fe400078e0a05ULL, 0x000000ffff257224ULL, 0x000fe200008e0625ULL,
0x000000084a4a7812ULL, 0x000fe200078e0cffULL, 0x000000ffff1f7224ULL, 0x000fe200018e061fULL,
0x000000484900720cULL, 0x000fe20003f86070ULL, 0x000000100d497824ULL, 0x100fe200078e0274ULL,
0x0000000c26267210ULL, 0x000fe20007f3e0ffULL, 0x000000004a0473c2ULL, 0x000e6200000e0000ULL,
0x000000485900720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1d7224ULL, 0x000fe200010e061dULL,
0x000000485500720cULL, 0x000fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200008e0627ULL,
0x0000000c3c3c7210ULL, 0x080fe20007f3e0ffULL, 0x0000001011557824ULL, 0x000fe200078e0274ULL,
0x0000000c3e3e7210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e063dULL,
0x000000484b00720cULL, 0x080fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018497faeULL, 0x0005e2000e101c46ULL, 0x000000100e4b7824ULL, 0x100fe200078e0274ULL,
0x000000485100720cULL, 0x080fe20003f86070ULL, 0x000000100f517824ULL, 0x100fe400078e0274ULL,
0x000000ffff3f7224ULL, 0x000fe200010e063fULL, 0x000000485700720cULL, 0x080fe20003f46070ULL,
0x000000001a4b7faeULL, 0x0007e2000e901c46ULL, 0x000000485300720cULL, 0x000fe20003fa6070ULL,
0x0000001010537824ULL, 0x000fc400078e0274ULL, 0x000000001c517faeULL, 0x0009e2000d901c46ULL,
0x000000485b00720cULL, 0x000fe20003f66070ULL, 0x0000001012577824ULL, 0x100fe200078e0274ULL,
0x0001c64804047890ULL, 0x002fe2000fffe03fULL, 0x0000001013197824ULL, 0x104fe200078e0274ULL,
0x000000001e537faeULL, 0x0009e2000c901c46ULL, 0x000000086f187812ULL, 0x000fe200078ec0ffULL,
0x00000010141b7824ULL, 0x008fe400078e0274ULL, 0x0000000024557faeULL, 0x0009e8000d101c46ULL,
0x0000000026577faeULL, 0x0009e8000e101c46ULL, 0x000000003c197faeULL, 0x0009e8000e901c46ULL,
0x000000003e1b7faeULL, 0x0009e8000d901c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c0018197984ULL, 0x0102a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c62c00ff1a7984ULL, 0x000ee20000000800ULL, 0x0000ffff76767812ULL, 0x000fe200078ec0ffULL,
0x80000000151b7824ULL, 0x000fc600078e00ffULL, 0x0000888076187816ULL, 0x002fca00000000ffULL,
0x8000000018187824ULL, 0x000fca00078e00ffULL, 0x8000000019ff7812ULL, 0x004fe40007824818ULL,
0x800000001aff7812ULL, 0x008fe2000784481bULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fe400078e00ffULL,
0x80000000151a7824ULL, 0x000fe400078e00ffULL, 0x0000001800197305ULL, 0x0002a4000021f000ULL,
0x3fa0000018187823ULL, 0x002fe200000100ffULL, 0x000000190000735dULL, 0x004fe40003800000ULL,
0x01c62c00ff197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000784481aULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c1000016197984ULL, 0x000e620000000800ULL, 0x00000001ffc17424ULL, 0x000fc600078e00ffULL,
0x01c3000016187984ULL, 0x0004e20000000800ULL, 0x000000061900720bULL, 0x002fda0003f5d000ULL,
0x00000000001a7806ULL, 0x000fc800010e0100ULL, 0x0000ffff1a1c7812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000061900720bULL, 0x00cfe40003f54000ULL,
0x00000019061b7209ULL, 0x000fe40007810000ULL, 0x00000002ff1f7819ULL, 0x000fc60000011603ULL,
0x8000001b061a7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1a1a7820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x000000024c00780cULL, 0x000fe40003f45270ULL,
0x0000ffff061d7812ULL, 0x000fe200078e3cffULL, 0x0000001a001a7308ULL, 0x000e660000000800ULL,
0x0000001d1cff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ffc17807ULL, 0x000fc60001800000ULL,
0x01c5001b1600a388ULL, 0x000fe80000000800ULL, 0x00001f1f1a067589ULL, 0x002e6400000e0000ULL,
0x8000001b191c3221ULL, 0x000fe40000010000ULL, 0x0000001a07077220ULL, 0x000fe20000410000ULL,
0x00001f4f1a197589ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b1c1c3820ULL, 0x000fc80000410000ULL,
0x0000001c00173308ULL, 0x000ee20000000800ULL, 0x000000062c2c7220ULL, 0x082fe40000410000ULL,
0x000000062d2d7220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x080fe40000410000ULL,
0x0000000629297220ULL, 0x080fe40000410000ULL, 0x0000000620207220ULL, 0x080fe40000410000ULL,
0x0000000621217220ULL, 0x000fc40000410000ULL, 0x0000000630307220ULL, 0x080fe40000410000ULL,
0x0000000631317220ULL, 0x080fe40000410000ULL, 0x0000000634347220ULL, 0x080fe40000410000ULL,
0x0000000635357220ULL, 0x080fe40000410000ULL, 0x0000000644447220ULL, 0x080fe40000410000ULL,
0x0000000645457220ULL, 0x000fc40000410000ULL, 0x0000000640407220ULL, 0x080fe40000410000ULL,
0x0000000641417220ULL, 0x080fe40000410000ULL, 0x0000000638387220ULL, 0x080fe40000410000ULL,
0x0000000639397220ULL, 0x000fe40000410000ULL, 0x000000192e2e7220ULL, 0x084fe40000410000ULL,
0x000000192f2f7220ULL, 0x000fc40000410000ULL, 0x000000192a2a7220ULL, 0x080fe40000410000ULL,
0x000000192b2b7220ULL, 0x080fe40000410000ULL, 0x0000001922227220ULL, 0x080fe40000410000ULL,
0x0000001923237220ULL, 0x080fe40000410000ULL, 0x0000001932327220ULL, 0x080fe40000410000ULL,
0x0000001933337220ULL, 0x000fc40000410000ULL, 0x0000001936367220ULL, 0x080fe40000410000ULL,
0x0000001937377220ULL, 0x080fe40000410000ULL, 0x0000001946467220ULL, 0x080fe40000410000ULL,
0x0000001947477220ULL, 0x080fe40000410000ULL, 0x0000001942427220ULL, 0x080fe40000410000ULL,
0x0000001943437220ULL, 0x000fc40000410000ULL, 0x000000193a3a7220ULL, 0x080fe40000410000ULL,
0x000000193b3b7220ULL, 0x000fe40000410000ULL, 0x000000ffff067224ULL, 0x000fe400078e001bULL,
0x0000001817183220ULL, 0x008fc80000410000ULL, 0x0000000718077221ULL, 0x00cfe20000010000ULL,
0x0000016000001947ULL, 0x000fea0003800000ULL, 0x000000080a187824ULL, 0x040fe200078e00ffULL,
0x000000010aff7812ULL, 0x000fc8000782c0ffULL, 0x0000000818187812ULL, 0x000fe400078ec0ffULL,
0x0000006e75197207ULL, 0x000fc80004800000ULL, 0x01c64c0018187984ULL, 0x000e620000000800ULL,
0x0000ffff19197812ULL, 0x000fc800078ec0ffULL, 0x00008880191a7816ULL, 0x000fca00000000ffULL,
0x800000001a197824ULL, 0x000fca00078e00ffULL, 0x8000000018ff7812ULL, 0x002fe20007824819ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000b000001947ULL, 0x000fea0003800000ULL,
0x000000010a187812ULL, 0x000fe200078ec0ffULL, 0x800000001a1b7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff197424ULL, 0x000fe200078e00ffULL, 0x0001c648181a7811ULL, 0x000fc600078e18ffULL,
0x0000001900187305ULL, 0x0002a4000021f000ULL, 0x3fa0000019197823ULL, 0x002fe200000100ffULL,
0x000000180000735dULL, 0x004fe40003800000ULL, 0x000004001a187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc4000782481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x00000010723c7824ULL, 0x100fe400078e0273ULL,
0x0000001065507824ULL, 0x100fe400078e0273ULL, 0x0000001064547824ULL, 0x100fe400078e0273ULL,
0x000000003c3c783bULL, 0x000e620000004200ULL, 0x0000001062487824ULL, 0x100fe400078e0273ULL,
0x0000001063587824ULL, 0x100fe200078e0273ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000001061187824ULL, 0x000fc400078e0273ULL, 0x0000001060247824ULL, 0x100fe200078e0273ULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x000000105f1c7824ULL, 0x000fc600078e0273ULL,
0x000000004848783bULL, 0x000ea80000004200ULL, 0x000000005858783bULL, 0x000ee80000004200ULL,
0x000000001818783bULL, 0x000f280000004200ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000001c1c783bULL, 0x000fe20000004200ULL, 0x00000018ffbb7819ULL, 0x002fe2000001143cULL,
0x000001003c7c7824ULL, 0x040fe200078e00ffULL, 0x000088803cc37816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001143dULL,
0x000001003d7e7824ULL, 0x040fe200078e00ffULL, 0x000088803dc27816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000000c300c37306ULL, 0x000fe20000200c00ULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x00000100488a7824ULL, 0x044fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe2000001143eULL, 0x0001000048847824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe2000001143fULL, 0x0000003c00c07306ULL, 0x0003e20000200c00ULL,
0x000088803ebf7816ULL, 0x040fe200000000ffULL, 0x0000010059997824ULL, 0x008fe200078e00ffULL,
0x000088803fba7816ULL, 0x000fe200000000ffULL, 0x0001000059977824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe20000011451ULL, 0x00000100498b7824ULL, 0x000fe200078e00ffULL,
0x0000888051b47816ULL, 0x000fe200000000ffULL, 0x0000003d00be7306ULL, 0x0005e20000200c00ULL,
0x000001003e3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe20000011450ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000888050b77816ULL, 0x000fe200000000ffULL,
0x0001000049837824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000100589a7824ULL, 0x040fe200078e00ffULL, 0x0000007c00c47306ULL, 0x0002e20000200c00ULL,
0x00000100513d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0001000051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0001000058967824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000001005a937824ULL, 0x000fe200078e00ffULL, 0x0000003c00bc7306ULL, 0x0005e20000200c00ULL,
0x000001003f7c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe20000011448ULL,
0x000001005b917824ULL, 0x040fe200078e00ffULL, 0x0000888048897816ULL, 0x000fe200000000ffULL,
0x000100005a8c7824ULL, 0x000fe200078e00ffULL, 0x0000003d00b57306ULL, 0x0003e20000200c00ULL,
0x00000100503c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x00000017ff48723eULL, 0x000fe200000000ffULL,
0x000100005b8f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x0000003e00b87306ULL, 0x000fe20000200c00ULL, 0x00000100533d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011459ULL, 0x0000888059987816ULL, 0x000fe200000000ffULL,
0x000100004a597824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00b67306ULL, 0x0003e20000200c00ULL, 0x00000018ff787819ULL, 0x000fe4000001144aULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x000088804a7f7816ULL, 0x000fe400000000ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011449ULL, 0x0000003d00af7306ULL, 0x0005e20000200c00ULL,
0x00000100523c7824ULL, 0x002fe200078e00ffULL, 0x0000888049887816ULL, 0x000fe400000000ffULL,
0x00009910c1497816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000003f00b97306ULL, 0x000fe20000200c00ULL, 0x00000100553d7824ULL, 0x004fe200078e00ffULL,
0x00000018ffa67819ULL, 0x000fc40000011453ULL, 0x0000888053ae7816ULL, 0x040fe200000000ffULL,
0x0001000053537824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003c00b07306ULL, 0x0003e20000200c00ULL, 0x000000ff4900720cULL, 0x000fe40003f25270ULL,
0x00000018ffa77819ULL, 0x000fe40000011452ULL, 0x00000018ff9e7819ULL, 0x000fe40000011454ULL,
0x00000018ff9d7819ULL, 0x000fe20000011455ULL, 0x0000003d00ab7306ULL, 0x0005e20000200c00ULL,
0x00000100543c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff957819ULL, 0x000fc40000011456ULL,
0x0000888052b17816ULL, 0x040fe200000000ffULL, 0x0001000052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000007e00c57306ULL, 0x0003e20000200c00ULL,
0x00000100573d7824ULL, 0x004fe200078e00ffULL, 0x0000888054a97816ULL, 0x040fe200000000ffULL,
0x0001000054547824ULL, 0x000fe200078e00ffULL, 0x0000888055a87816ULL, 0x040fe200000000ffULL,
0x0001000055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fc4000001143dULL,
0x0000003c00aa7306ULL, 0x0005e20000200c00ULL, 0x000001004a7e7824ULL, 0x002fe200078e00ffULL,
0x00005410484a7816ULL, 0x000fe40000000048ULL, 0x0000888056a37816ULL, 0x040fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x0000003d00a17306ULL, 0x000fe20000200c00ULL,
0x00000100563c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0001000056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc40000011454ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000005100b27306ULL, 0x0003e20000200c00ULL,
0x00000018ff557819ULL, 0x000fe40000011455ULL, 0x00000018ff567819ULL, 0x000fe40000011456ULL,
0x0000888019487816ULL, 0x010fe400000000ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000003c00a27306ULL, 0x0005e20000200c00ULL, 0x00000002ff517819ULL, 0x002fc40000011603ULL,
0x00000018ff907819ULL, 0x000fe40000011457ULL, 0x00000018ff777819ULL, 0x000fe40000011418ULL,
0x00001f514a517589ULL, 0x000fe200000e0000ULL, 0x0000005000b37306ULL, 0x0003e20000200c00ULL,
0x000130004e3c7811ULL, 0x004fe400078e20ffULL, 0x00000018ff767819ULL, 0x000fe40000011419ULL,
0x0000888057a07816ULL, 0x040fe200000000ffULL, 0x0001000057577824ULL, 0x000fe200078e00ffULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0x000000c200c27306ULL, 0x000f220000200c00ULL,
0x00000018ff877819ULL, 0x000fc40000011458ULL, 0x00001f4f4a507589ULL, 0x002e6200000e0000ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00008880589b7816ULL, 0x000fe400000000ffULL,
0x000000bb00bb7306ULL, 0x000e620000200c00ULL, 0x00000018ff817819ULL, 0x000fe4000001145aULL,
0x00000018ff807819ULL, 0x000fe4000001145bULL, 0x000088805a947816ULL, 0x000fe200000000ffULL,
0x000100004b5a7824ULL, 0x000fe200078e00ffULL, 0x000088805b8e7816ULL, 0x000fe200000000ffULL,
0x0000007d007d7306ULL, 0x000e620000200c00ULL, 0x00000018ff797819ULL, 0x000fc4000001144bULL,
0x000088804b5b7816ULL, 0x000fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe4000001141aULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x0000005300ad7306ULL, 0x000fe20000200c00ULL,
0x00000018ff997819ULL, 0x000fe40000011499ULL, 0x00000018ff737819ULL, 0x000fe4000001141bULL,
0x00000018ff727819ULL, 0x020fc40000011424ULL, 0x00000018ff967819ULL, 0x000fe20000011496ULL,
0x0000005200ac7306ULL, 0x000be20000200c00ULL, 0x00000018ff977819ULL, 0x000fe40000011497ULL,
0x00000018ff657819ULL, 0x000fe40000011425ULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000000513c3c9232ULL, 0x084fe40000000000ULL, 0x0000005400a57306ULL, 0x0005e20000200c00ULL,
0x0001000018527824ULL, 0x020fe200078e00ffULL, 0x000000513e3e9232ULL, 0x000fe20000000000ULL,
0x00000018ff917819ULL, 0x000fe20000011491ULL, 0x000000503d3d9232ULL, 0x082fe20000000000ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x000000503f3f9232ULL, 0x000fe20000000000ULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0000005500a47306ULL, 0x0003e20000200c00ULL,
0x0000010019547824ULL, 0x004fe200078e00ffULL, 0x00000018ff8a7819ULL, 0x000fc4000001148aULL,
0x00000018ff8b7819ULL, 0x000fe4000001148bULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000056009c7306ULL, 0x0005e20000200c00ULL, 0x0000010018557824ULL, 0x002fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011426ULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x00000018ff637819ULL, 0x000fc40000011427ULL, 0x0000004800537306ULL, 0x0003e20000200c00ULL,
0x0000888018567816ULL, 0x004fe400000000ffULL, 0x00005410c3187816ULL, 0x008fe400000000c4ULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x000000bf00bf7306ULL, 0x000fe20000200c00ULL, 0x0001000019487824ULL, 0x002fe200078e00ffULL,
0x00005410c2197816ULL, 0x010fc400000000c5ULL, 0x00000018ff557819ULL, 0x000fe40000011455ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x000000ba00ba7306ULL, 0x000fe20000200c00ULL,
0x000000183c2c723cULL, 0x000fe2000000182cULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff597819ULL, 0x000fe40000011459ULL, 0x00000018ff627819ULL, 0x000fc4000001141cULL,
0x0000007c00bd7306ULL, 0x0002a20000200c00ULL, 0x00005410c0187816ULL, 0x000fe400000000bbULL,
0x00005410be197816ULL, 0x000fe4000000007dULL, 0x00000018ff617819ULL, 0x000fe4000001141dULL,
0x00000018ff607819ULL, 0x000fe2000001141eULL, 0x00000057009f7306ULL, 0x0007e20000200c00ULL,
0x000001004b7c7824ULL, 0x002fe200078e00ffULL, 0x000000183c28723cULL, 0x000fe20000001828ULL,
0x00000018ff5f7819ULL, 0x000fc6000001141fULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x00000018ff577819ULL, 0x008fe20000011448ULL,
0x000001001a187824ULL, 0x040fe200078e00ffULL, 0x000088801a487816ULL, 0x040fe200000000ffULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x00005410ba497816ULL, 0x004fe400000000bdULL,
0x000130005c197811ULL, 0x000fe200078e20ffULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x000000ffff587224ULL, 0x000fe200078e0048ULL, 0x00005410bf487816ULL, 0x000fc400000000bcULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x000088801bba7816ULL, 0x000fe400000000ffULL,
0x000000b700b77306ULL, 0x000ea20000200c00ULL, 0x000000483c48723cULL, 0x000fe20000001820ULL,
0x000000001920783bULL, 0x0002ec0000000200ULL, 0x000000b400b47306ULL, 0x000f220000200c00ULL,
0x00005410b9197816ULL, 0x002fce0000000082ULL, 0x00000018007d7306ULL, 0x0003f00000200c00ULL,
0x0000009200927306ULL, 0x000f620000200c00ULL, 0x00005410b8187816ULL, 0x002fe20000000085ULL,
0x000001001b857824ULL, 0x000fca00078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011485ULL,
0x0000008d008d7306ULL, 0x000e620000200c00ULL, 0x000000183c30723cULL, 0x000fee0000001830ULL,
0x000000b100b17306ULL, 0x000e620000200c00ULL, 0x00005410b7187816ULL, 0x004fe200000000b6ULL,
0x0000005120209232ULL, 0x088fe20000000000ULL, 0x00005410b4197816ULL, 0x010fe200000000b5ULL,
0x0000005122229232ULL, 0x000fc40000000000ULL, 0x0000005021219232ULL, 0x080fe40000000000ULL,
0x000000ae00ae7306ULL, 0x000ea20000200c00ULL, 0x0000005023239232ULL, 0x000fe20000000000ULL,
0x000000183c34723cULL, 0x000fec0000001834ULL, 0x000000a700a77306ULL, 0x000ee20000200c00ULL,
0x00005410b3187816ULL, 0x020fe20000000092ULL, 0x000100001b927824ULL, 0x000fe200078e00ffULL,
0x00005410b2197816ULL, 0x002fc4000000008dULL, 0x00000018ff8d7819ULL, 0x000fe2000001141aULL,
0x00000100241a7824ULL, 0x040fe200078e00ffULL, 0x00008880241b7816ULL, 0x040fe200000000ffULL,
0x000000a600a67306ULL, 0x000e620000200c00ULL, 0x0001000024247824ULL, 0x000fe200078e00ffULL,
0x000000183c44723cULL, 0x000fe20000001844ULL, 0x00000018ff927819ULL, 0x000fc60000011492ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x000000a900a97306ULL, 0x000f220000200c00ULL,
0x00005410b1187816ULL, 0x000fe400000000b0ULL, 0x00005410ae197816ULL, 0x004fca00000000afULL,
0x000000a800a87306ULL, 0x000ea40000200c00ULL, 0x000000183c40723cULL, 0x000fec0000001840ULL,
0x0000009e009e7306ULL, 0x000f620000200c00ULL, 0x00005410ac187816ULL, 0x008fe400000000a7ULL,
0x00005410ad197816ULL, 0x002fca00000000a6ULL, 0x0000009d009d7306ULL, 0x000e640000200c00ULL,
0x000000183c38723cULL, 0x000fec0000001838ULL, 0x0000009500957306ULL, 0x000fe20000200c00ULL,
0x00005410a9187816ULL, 0x010fe400000000aaULL, 0x00005410a8197816ULL, 0x004fc400000000abULL,
0x00000018ff3c7819ULL, 0x000fe4000001141aULL, 0x00008880251a7816ULL, 0x040fe200000000ffULL,
0x0000009000907306ULL, 0x000ea40000200c00ULL, 0x00000018202c723cULL, 0x000fe4000000182cULL,
0x000000ffff3e7224ULL, 0x000fe400078e001aULL, 0x00000100251a7824ULL, 0x000fe400078e00ffULL,
0x000000a300a37306ULL, 0x000ee20000200c00ULL, 0x00005410a5187816ULL, 0x020fe2000000009eULL,
0x00010000259e7824ULL, 0x000fe200078e00ffULL, 0x00005410a4197816ULL, 0x002fc4000000009dULL,
0x00000018ff3f7819ULL, 0x000fe4000001141aULL, 0x000130005d1a7811ULL, 0x000fe200078e20ffULL,
0x000000a000a07306ULL, 0x000e620000200c00ULL, 0x000054109f257816ULL, 0x004fe20000000090ULL,
0x000000182028723cULL, 0x000fe20000001828ULL, 0x00000018ff907819ULL, 0x000fca000001149eULL,
0x0000009b009b7306ULL, 0x000fe20000200c00ULL, 0x00005410a3187816ULL, 0x008fce00000000a2ULL,
0x0000009a009a7306ULL, 0x000ea20000200c00ULL, 0x00005410a0197816ULL, 0x002fce00000000a1ULL,
0x0000009800987306ULL, 0x000fe20000200c00ULL, 0x000000182048723cULL, 0x000fee0000001848ULL,
0x0000009900997306ULL, 0x000e700000200c00ULL, 0x00000024009d7306ULL, 0x0007f00000200c00ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054109c247816ULL, 0x008fc40000000095ULL,
0x0000888026957816ULL, 0x000fca00000000ffULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x000000242030723cULL, 0x000fee0000001830ULL, 0x0000009600967306ULL, 0x000ee20000200c00ULL,
0x000054109b247816ULL, 0x004fe4000000009aULL, 0x0000541098257816ULL, 0x002fe20000000099ULL,
0x0000010026987824ULL, 0x000fc400078e00ffULL, 0x0001000026267824ULL, 0x000fe400078e00ffULL,
0x0000009700977306ULL, 0x000e640000200c00ULL, 0x000000242034723cULL, 0x000fec0000001834ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x0000541096247816ULL, 0x008fc40000000087ULL,
0x0000888027877816ULL, 0x000fca00000000ffULL, 0x0000009300937306ULL, 0x000ea20000200c00ULL,
0x0000541097257816ULL, 0x002fe40000000086ULL, 0x00000018ff867819ULL, 0x000fca0000011498ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000000242044723cULL, 0x000fee0000001844ULL,
0x0000009100917306ULL, 0x000e620000200c00ULL, 0x0000541094247816ULL, 0x004fce0000000093ULL,
0x0000001b003d7306ULL, 0x0005f00000200c00ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x000000001a18783bULL, 0x004ea20000000200ULL, 0x000054108e257816ULL, 0x002fcc0000000091ULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000000242040723cULL, 0x000fee0000001840ULL,
0x0000008000807306ULL, 0x000fe20000200c00ULL, 0x0000010027257824ULL, 0x000fce00078e00ffULL,
0x0000008f008f7306ULL, 0x000ee20000200c00ULL, 0x000054108c247816ULL, 0x002fe40000000081ULL,
0x00000018ff817819ULL, 0x000fca0000011425ULL, 0x0000008900897306ULL, 0x000ff00000200c00ULL,
0x0000008a008a7306ULL, 0x000fe20000200c00ULL, 0x000054108f257816ULL, 0x008fe20000000080ULL,
0x0000005118189232ULL, 0x004fc40000000000ULL, 0x000000511a1a9232ULL, 0x000fe40000000000ULL,
0x0000005019199232ULL, 0x080fe40000000000ULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x000000242020723cULL, 0x000fe20000001838ULL, 0x000000501b1b9232ULL, 0x000fcc0000000000ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x00000018ff247819ULL, 0x000fe20000011426ULL,
0x0001000027387824ULL, 0x000fe200078e00ffULL, 0x000088801c397816ULL, 0x000fc800000000ffULL,
0x00000018ff807819ULL, 0x000fe20000011438ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x000130005e387811ULL, 0x000fce00078e20ffULL, 0x0000008300837306ULL, 0x000ea20000200c00ULL,
0x0000541088257816ULL, 0x002fce000000008bULL, 0x0000002400277306ULL, 0x0003f00000200c00ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541089247816ULL, 0x002fce000000008aULL,
0x0000008400847306ULL, 0x000e620000200c00ULL, 0x00000024182c723cULL, 0x000fee000000182cULL,
0x0000541083257816ULL, 0x004fe2000000007aULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000000ffff7a7224ULL, 0x000fc400078e0039ULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x0000541084247816ULL, 0x002fc8000000007bULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x000001001c7b7824ULL, 0x040fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000000241828723cULL, 0x000fe80000001828ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fce000001141cULL, 0x0000007c007c7306ULL, 0x000ee20000200c00ULL,
0x000054107f247816ULL, 0x002fce000000007eULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000054105b257816ULL, 0x008fe2000000007cULL,
0x0000005138389232ULL, 0x084fe20000000000ULL, 0x00000018ff5b7819ULL, 0x000fe2000001147bULL,
0x000000513a3a9232ULL, 0x000fe20000000000ULL, 0x000088801e517816ULL, 0x000fe200000000ffULL,
0x0000005039399232ULL, 0x000fc40000000000ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000000241848723cULL, 0x000fe20000001848ULL, 0x000000503b3b9232ULL, 0x000fcc0000000000ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000088801d247816ULL, 0x000fe400000000ffULL,
0x000054105a797816ULL, 0x002fc60000000079ULL, 0x000000ffff5a7224ULL, 0x000fe400078e0024ULL,
0x0000005400547306ULL, 0x000e700000200c00ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000541056247816ULL, 0x004fce0000000055ULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x0000541053257816ULL, 0x002fce0000000054ULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x000000241834723cULL, 0x000fee0000001834ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x000100001d247824ULL, 0x000fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe40000011424ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0000541052527816ULL, 0x002fce0000000077ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x0000541057537816ULL, 0x004fce0000000076ULL,
0x0000005800587306ULL, 0x000ea20000200c00ULL, 0x000000521844723cULL, 0x000fee0000001844ULL,
0x000000ba00827306ULL, 0x000fe20000200c00ULL, 0x0000541059787816ULL, 0x002fe20000000078ULL,
0x000001001d597824ULL, 0x000fca00078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011459ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000541058587816ULL, 0x004fe2000000007dULL,
0x000000781830723cULL, 0x000fec0000001830ULL, 0x0000007400747306ULL, 0x000ff00000200c00ULL,
0x0000007300737306ULL, 0x000fe20000200c00ULL, 0x0000541082597816ULL, 0x002fce0000000085ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000000581840723cULL, 0x000fee0000001840ULL,
0x0000009200927306ULL, 0x000e700000200c00ULL, 0x0000003c003c7306ULL, 0x000eb00000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x00005410921d7816ULL, 0x002fce0000000073ULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054103d3c7816ULL, 0x004fce000000003cULL,
0x0000008700877306ULL, 0x000ff00000200c00ULL, 0x0000008100267306ULL, 0x000ea20000200c00ULL,
0x000054103e3d7816ULL, 0x002fce000000003fULL, 0x0000001c00537306ULL, 0x0003e20000200c00ULL,
0x0000003c382c723cULL, 0x000fee000000182cULL, 0x000001001f3d7824ULL, 0x000fe200078e00ffULL,
0x000054108d1c7816ULL, 0x002fe20000000074ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000541087877816ULL, 0x004fe20000000026ULL, 0x000100001f267824ULL, 0x040fe200078e00ffULL,
0x000088801f3c7816ULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x0000001c1818723cULL, 0x000fe20000001820ULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0000009000907306ULL, 0x000e6a0000200c00ULL, 0x000001001e1d7824ULL, 0x040fe400078e00ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0051ULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff1e7819ULL, 0x000fc8000001141eULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000541090737816ULL, 0x002fce0000000065ULL, 0x0000001c001c7306ULL, 0x000ff00000200c00ULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x0000541080657816ULL, 0x004fce0000000063ULL,
0x0000007200727306ULL, 0x000eb00000200c00ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x000054101c1c7816ULL, 0x002fce000000001dULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x000054109d727816ULL, 0x004fce0000000072ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541027647816ULL, 0x008fe20000000064ULL, 0x000000723828723cULL, 0x040fec0000001828ULL,
0x0000009500957306ULL, 0x000fe20000200c00ULL, 0x0000541053627816ULL, 0x002fe20000000062ULL,
0x000000643830723cULL, 0x000fec0000001830ULL, 0x0000008600867306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000ff00000200c00ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541095867816ULL, 0x002fce0000000086ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000000863820723cULL, 0x000fee0000001848ULL, 0x0000002500257306ULL, 0x000e620000200c00ULL,
0x000054107a7a7816ULL, 0x004fce000000005bULL, 0x0000002400247306ULL, 0x000eb00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054105a7b7816ULL, 0x002fce0000000025ULL,
0x0000003d003d7306ULL, 0x000e620000200c00ULL, 0x0000541024637816ULL, 0x004fe20000000061ULL,
0x0000007a3834723cULL, 0x040fec0000001834ULL, 0x0000006000607306ULL, 0x000fe40000200c00ULL,
0x000000623844723cULL, 0x000fec0000001844ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000054103c1d7816ULL, 0x002fce000000003dULL, 0x0000001e001f7306ULL, 0x000e620000200c00ULL,
0x0000001c3840723cULL, 0x000fee0000001840ULL, 0x0000002600267306ULL, 0x000ea20000200c00ULL,
0x000000010a1c7812ULL, 0x000fc800078ec0ffULL, 0x000000011c00780cULL, 0x000fe40003f25070ULL,
0x000054101f607816ULL, 0x002fe40000000060ULL, 0x0000541026617816ULL, 0x004fce000000005fULL,
0x000000603838723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000756e187207ULL, 0x000fe20004800000ULL,
0x01c63000ffff7f8cULL, 0x000fe2000c80043fULL, 0x000000c04d197811ULL, 0x000fe400078e40ffULL,
0x000000ff18ff7812ULL, 0x000fe4000784c0ffULL, 0x000000ff0bff7812ULL, 0x000fe4000786c0ffULL,
0x00000001ff187807ULL, 0x000fc40001000000ULL, 0x000000190000720cULL, 0x000fe40003f44070ULL,
0x0000007518187207ULL, 0x000fe40004800000ULL, 0x00000001ff777807ULL, 0x000fe40001800000ULL,
0x000000010a787812ULL, 0x000fe400078e0cffULL, 0x0000761018767816ULL, 0x000fca0000000076ULL,
0x00002b900000a947ULL, 0x000fea0003800000ULL, 0x01c65c00ff0b7984ULL, 0x000e620000000800ULL,
0x8000000071187824ULL, 0x000fca00078e00ffULL, 0x800000000bff7812ULL, 0x002fe20007824818ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000d000001947ULL, 0x000fea0003800000ULL,
0x01c65c00ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007824818ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000009000001947ULL, 0x000fea0003800000ULL,
0x8000000071717824ULL, 0x000fe400078e00ffULL, 0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL,
0x0000000b00187305ULL, 0x0002a4000021f000ULL, 0x3fa000000b0b7823ULL, 0x002fe200000100ffULL,
0x000000180000735dULL, 0x004fe40003800000ULL, 0x01c65c00ff187984ULL, 0x000e640000000800ULL,
0x8000000018ff7812ULL, 0x002fc40007824871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x000003004d0b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000100ff557424ULL, 0x000fe200078e00ffULL, 0x00000004ff3f7819ULL, 0x000fe40000011603ULL,
0x0000400070707812ULL, 0x000fe200078ec0ffULL, 0x000001000b1b7824ULL, 0x040fe200078e00ffULL,
0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL, 0x000000063f517810ULL, 0x000fe20007ffe0ffULL,
0x00006200043e7a24ULL, 0x000fe200078e021bULL, 0x000000020b00720cULL, 0x000fc40003f26070ULL,
0x000000043f0b7810ULL, 0x040fe40007ffe0ffULL, 0x0000003f3e187210ULL, 0x100fe40007ffe005ULL,
0x0000001b001e7217ULL, 0x000fe40007800000ULL, 0x000000513e1f7210ULL, 0x000fe20007ffe005ULL,
0x00005e0018187625ULL, 0x000fe200078e0055ULL, 0x000000083f4b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000a3f497810ULL, 0x000fe20007ffe0ffULL, 0x000000011e1e7824ULL, 0x000fe200078e0a1bULL,
0x0000000c181a7210ULL, 0x000fc40007f5e0ffULL, 0x0000000b3e187210ULL, 0x000fe40007ffe005ULL,
0x000000401e247807ULL, 0x000fe20000800000ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0619ULL,
0x0000004b3e257210ULL, 0x100fe20007ffe005ULL, 0x00005e0018187625ULL, 0x000fe200078e0055ULL,
0x00000024053c7217ULL, 0x000fe40007800000ULL, 0x000000493e3d7210ULL, 0x000fe20007ffe005ULL,
0x00005e001f1e7625ULL, 0x000fe200078e0055ULL, 0x0000000c18267210ULL, 0x000fc40007f3e0ffULL,
0x000000023f537810ULL, 0x000fe20007ffe0ffULL, 0x000000013c487824ULL, 0x000fe200078e0a05ULL,
0x0001400070707810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff277224ULL, 0x000fe200008e0619ULL,
0x0000000c1e187210ULL, 0x000fe20007f3e0ffULL, 0x00005e0025247625ULL, 0x000fe200078e0055ULL,
0x000000483f00720cULL, 0x080fe40003f86070ULL, 0x000000533e1c7210ULL, 0x000fe20007ffe005ULL,
0x00005e003d3c7625ULL, 0x000fe200078e0055ULL, 0x000000485300720cULL, 0x000fc60003fa6070ULL,
0x000000ffff197224ULL, 0x000fe200008e061fULL, 0x0000000c241e7210ULL, 0x080fe20007f3e0ffULL,
0x00005e001c1c7625ULL, 0x000fe200078e0055ULL, 0x0000000c3c247210ULL, 0x000fe40007f5e0ffULL,
0x000000086f3c7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e0625ULL,
0x000000480b00720cULL, 0x080fe20003f26070ULL, 0x000000ffff257224ULL, 0x000fe200010e063dULL,
0x0000000c3f3d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0b7824ULL, 0x100fe200078e0270ULL,
0x000000003c0473c2ULL, 0x000e6200000e0000ULL, 0x000000100e0d7824ULL, 0x100fe200078e0270ULL,
0x0000003d3e0e7210ULL, 0x100fe20007ffe005ULL, 0x0000001011117824ULL, 0x100fe200078e0270ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a0b7faeULL, 0x0005e2000e101c46ULL,
0x000000484900720cULL, 0x000fe20003f86070ULL, 0x0000001013137824ULL, 0x100fe200078e0270ULL,
0x0000000e3f497810ULL, 0x000fe20007ffe0ffULL, 0x000000100f3f7824ULL, 0x000fe200078e0270ULL,
0x0000000c1c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0055ULL,
0x000000493e3e7210ULL, 0x000fc40007ffe005ULL, 0x000000485100720cULL, 0x000fe20003f46070ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x0000000c0e0e7210ULL, 0x000fe20007fde0ffULL,
0x00005e003e1a7625ULL, 0x004fe200078e0055ULL, 0x000000484b00720cULL, 0x080fe40003f66070ULL,
0x000000001c0d7faeULL, 0x0005e2000e901c46ULL, 0x000000483d00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e060fULL, 0x000000484900720cULL, 0x000fe20003fc6070ULL,
0x00000000263f7faeULL, 0x0007e2000c901c46ULL, 0x0000000c1a0c7210ULL, 0x000fe20007f3e0ffULL,
0x00000010103d7824ULL, 0x100fe200078e0270ULL, 0x0001c64804047890ULL, 0x002fe2000fffe03fULL,
0x00000010140b7824ULL, 0x000fe200078e0270ULL, 0x000000086f6f7812ULL, 0x000fc400078e0cffULL,
0x00000000183d7faeULL, 0x0007e2000d101c46ULL, 0x00000010121d7824ULL, 0x004fe400078e0270ULL,
0x000000ffff0d7224ULL, 0x000fe200008e061bULL, 0x000000001e117faeULL, 0x0007e8000d901c46ULL,
0x00000000241d7faeULL, 0x0007e8000e101c46ULL, 0x000000000e137faeULL, 0x0007e8000e901c46ULL,
0x000000000c0b7faeULL, 0x0007e8000f101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c64c006f0c7984ULL, 0x0082a20000000800ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x01c63c00ff0d7984ULL, 0x000ee20000000800ULL, 0x0000ffff760b7812ULL, 0x000fe200078ec0ffULL,
0x80000000150e7824ULL, 0x000fc800078e00ffULL, 0x800000000b0b7824ULL, 0x000fca00078e00ffULL,
0x800000000cff7812ULL, 0x004fe4000782480bULL, 0x800000000dff7812ULL, 0x008fe2000784480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x000000010a127812ULL, 0x000fe200078e0cffULL,
0x0000009000002947ULL, 0x000fea0003800000ULL, 0x8000000015157824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000c7305ULL, 0x0004e4000021f000ULL,
0x3fa000000b0b7823ULL, 0x004fe200000100ffULL, 0x0000000c0000735dULL, 0x008fe40003800000ULL,
0x01c63c00ff0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fc40007844815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff900000a947ULL, 0x000fea000383ffffULL,
0x01c18000160b7984ULL, 0x000ea20000000800ULL, 0x00000001ffaa7424ULL, 0x000fc600078e00ffULL,
0x01c38000160c7984ULL, 0x0007220000000800ULL, 0x000000060b00720bULL, 0x004fda0003f5d000ULL,
0x00000000000d7806ULL, 0x000fc800010e0100ULL, 0x0000ffff0d0f7812ULL, 0x000fda000784c0ffULL,
0x000003400000a947ULL, 0x000fea0003800000ULL, 0x000000060b00720bULL, 0x018fe40003f54000ULL,
0x0000000b06117209ULL, 0x000fe40007810000ULL, 0x00000002ff137819ULL, 0x000fc60000011603ULL,
0x80000011060d7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fe40000410000ULL,
0x0000000000067806ULL, 0x000fe400010e0100ULL, 0x0000000d000e7308ULL, 0x000ea20000000800ULL,
0x000000034c00780cULL, 0x000fe40003f45270ULL, 0x0000ffff06107812ULL, 0x000fc800078e3cffULL,
0x000000100fff7212ULL, 0x000fc8000786c0ffULL, 0x00000001ffaa7807ULL, 0x000fc60001800000ULL,
0x01c580111600a388ULL, 0x000fe20000000800ULL, 0x0000000e07077220ULL, 0x004fc60000410000ULL,
0x00001f130e067589ULL, 0x000ea400000e0000ULL, 0x800000110b0f3221ULL, 0x000fe40000010000ULL,
0x00001f4f0e0b7589ULL, 0x000ee400000e0000ULL, 0x3fb8aa3b0f0f3820ULL, 0x000fc80000410000ULL,
0x0000000f00173308ULL, 0x000f220000000800ULL, 0x000000062c2c7220ULL, 0x084fe40000410000ULL,
0x000000062d2d7220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x080fe40000410000ULL,
0x0000000629297220ULL, 0x080fe40000410000ULL, 0x0000000620207220ULL, 0x080fe40000410000ULL,
0x0000000621217220ULL, 0x000fc40000410000ULL, 0x0000000630307220ULL, 0x080fe40000410000ULL,
0x0000000631317220ULL, 0x080fe40000410000ULL, 0x0000000634347220ULL, 0x080fe40000410000ULL,
0x0000000635357220ULL, 0x080fe40000410000ULL, 0x0000000644447220ULL, 0x080fe40000410000ULL,
0x0000000645457220ULL, 0x000fc40000410000ULL, 0x0000000640407220ULL, 0x080fe40000410000ULL,
0x0000000641417220ULL, 0x080fe40000410000ULL, 0x0000000638387220ULL, 0x080fe40000410000ULL,
0x0000000639397220ULL, 0x000fe40000410000ULL, 0x0000000b2e2e7220ULL, 0x088fe40000410000ULL,
0x0000000b2f2f7220ULL, 0x000fc40000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000b22227220ULL, 0x080fe40000410000ULL,
0x0000000b23237220ULL, 0x080fe40000410000ULL, 0x0000000b32327220ULL, 0x080fe40000410000ULL,
0x0000000b33337220ULL, 0x000fc40000410000ULL, 0x0000000b36367220ULL, 0x080fe40000410000ULL,
0x0000000b37377220ULL, 0x080fe40000410000ULL, 0x0000000b46467220ULL, 0x080fe40000410000ULL,
0x0000000b47477220ULL, 0x080fe40000410000ULL, 0x0000000b42427220ULL, 0x080fe40000410000ULL,
0x0000000b43437220ULL, 0x000fc40000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000b3b3b7220ULL, 0x000fe40000410000ULL, 0x000000ffff067224ULL, 0x000fe400078e0011ULL,
0x0000000c170c3220ULL, 0x010fc80000410000ULL, 0x000000070c077221ULL, 0x018fe20000010000ULL,
0x0000017000001947ULL, 0x000fea0003800000ULL, 0x000000080a0b7824ULL, 0x040fe200078e00ffULL,
0x000000010aff7812ULL, 0x000fc8000784c0ffULL, 0x000000080b0e7812ULL, 0x000fe400078e0cffULL,
0x0000006e750b7207ULL, 0x000fc80005000000ULL, 0x01c64c000e0e7984ULL, 0x000ea20000000800ULL,
0x000000ff0bff7812ULL, 0x000fc8000782c0ffULL, 0x00000001ff0c7807ULL, 0x000fc80000800000ULL,
0x0000000c750c7207ULL, 0x000fc80005000000ULL, 0x0000ffff0c0c7812ULL, 0x000fca00078ec0ffULL,
0x800000000c0b7824ULL, 0x000fca00078e00ffULL, 0x800000000eff7812ULL, 0x004fe2000782480bULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0001c648120d7811ULL, 0x000fe200078e18ffULL, 0x800000000c0f7824ULL, 0x000fe400078e00ffULL,
0x3e000000ff0b7424ULL, 0x000fc800078e00ffULL, 0x0000000b000c7305ULL, 0x0004e4000021f000ULL,
0x3fa000000b0b7823ULL, 0x004fe200000100ffULL, 0x0000000c0000735dULL, 0x008fe40003800000ULL,
0x000004000d0c7984ULL, 0x000ea40000000800ULL, 0x800000000cff7812ULL, 0x004fc4000782480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x000000006d10783bULL, 0x000ea20000004200ULL, 0x00009910aaaa7816ULL, 0x000fc600000000ffULL,
0x000000006c18783bULL, 0x000ee80000004200ULL, 0x000000006b1c783bULL, 0x000f280000004200ULL,
0x000000006654783bULL, 0x000be80000004200ULL, 0x000000006a24783bULL, 0x000e680000004200ULL,
0x00000000693c783bULL, 0x000e680000004200ULL, 0x000000006848783bULL, 0x0002680000004200ULL,
0x000000006750783bULL, 0x000e620000004200ULL, 0x00000018ffa67819ULL, 0x004fe20000011410ULL,
0x0000010010657824ULL, 0x040fe200078e00ffULL, 0x0000888010af7816ULL, 0x040fe200000000ffULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ffa47819ULL, 0x000fe20000011411ULL,
0x0000010011667824ULL, 0x060fe200078e00ffULL, 0x0000888011ac7816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000000af00af7306ULL, 0x000fe20000200c00ULL, 0x00000018ff657819ULL, 0x000fc40000011465ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff9c7819ULL, 0x000fe40000011412ULL,
0x0000888012a87816ULL, 0x000fe200000000ffULL, 0x0000001000ab7306ULL, 0x0005e20000200c00ULL,
0x00000018ff9a7819ULL, 0x000fe40000011413ULL, 0x0000888013a27816ULL, 0x000fe400000000ffULL,
0x00000018ff947819ULL, 0x008fc40000011418ULL, 0x0000888018a07816ULL, 0x000fe200000000ffULL,
0x0000001100a97306ULL, 0x0007e20000200c00ULL, 0x0000010013107824ULL, 0x044fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x010fe2000001141eULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000088801e8b7816ULL, 0x000fe400000000ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000006500ae7306ULL, 0x0005e20000200c00ULL, 0x0000010018117824ULL, 0x048fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0001000018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x002fc40000011425ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001000a57306ULL, 0x0003e20000200c00ULL, 0x0000010012657824ULL, 0x044fe200078e00ffULL,
0x00008880257e7816ULL, 0x000fe200000000ffULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe4000001141aULL, 0x000088801a987816ULL, 0x000fe400000000ffULL,
0x00000011009f7306ULL, 0x0005e20000200c00ULL, 0x0000010019107824ULL, 0x002fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fc40000011412ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001200a37306ULL, 0x000fe20000200c00ULL,
0x000001001a117824ULL, 0x044fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011424ULL,
0x000100001a1a7824ULL, 0x000fe200078e00ffULL, 0x0000888024817816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x00000010009e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000018ff627819ULL, 0x000fe4000001143cULL,
0x000088803c717816ULL, 0x000fe400000000ffULL, 0x00000018ff667819ULL, 0x000fe20000011466ULL,
0x0000001100977306ULL, 0x0005e20000200c00ULL, 0x000001001b107824ULL, 0x002fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fc4000001143eULL, 0x000088803e687816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000001300a17306ULL, 0x000fe20000200c00ULL,
0x000001001c117824ULL, 0x004fe200078e00ffULL, 0x00000018ff927819ULL, 0x000fe40000011419ULL,
0x00008880199d7816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fc40000011411ULL, 0x0000001000967306ULL, 0x0003e20000200c00ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff877819ULL, 0x000fe4000001141cULL, 0x00000018ff847819ULL, 0x000fe2000001141dULL,
0x00000011008e7306ULL, 0x0005e20000200c00ULL, 0x000001001d107824ULL, 0x042fe200078e00ffULL,
0x000088801c917816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d887816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x00000018009b7306ULL, 0x0003e20000200c00ULL,
0x000001001e117824ULL, 0x004fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000010008f7306ULL, 0x0005e20000200c00ULL, 0x00000017ff18723eULL, 0x002fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001143fULL, 0x00000018ff857819ULL, 0x000fe4000001141bULL,
0x000088801b957816ULL, 0x000fe200000000ffULL, 0x00000011008a7306ULL, 0x0003e20000200c00ULL,
0x000001001f107824ULL, 0x004fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001141fULL,
0x000100001b1b7824ULL, 0x000fe200078e00ffULL, 0x000088801f897816ULL, 0x040fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011410ULL,
0x000100001e107824ULL, 0x000fe200078e00ffULL, 0x0000001a00937306ULL, 0x0005e20000200c00ULL,
0x0000010024117824ULL, 0x042fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011426ULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000001000827306ULL, 0x0003e20000200c00ULL,
0x00000018ff247819ULL, 0x000fe40000011424ULL, 0x00005410181a7816ULL, 0x004fe20000000018ULL,
0x0000010048187824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe4000001143dULL,
0x0000888026797816ULL, 0x000fe200000000ffULL, 0x0000001100807306ULL, 0x0005e20000200c00ULL,
0x0000010025107824ULL, 0x002fe200078e00ffULL, 0x000088803d6f7816ULL, 0x000fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fc4000001141bULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000012001e7306ULL, 0x000fe20000200c00ULL,
0x0000010026117824ULL, 0x044fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011425ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000010007f7306ULL, 0x0003e20000200c00ULL,
0x00000018ff267819ULL, 0x000fc40000011426ULL, 0x00000018ff5b7819ULL, 0x000fe40000011448ULL,
0x00000018ff597819ULL, 0x000fe4000001144aULL, 0x00000018ff167819ULL, 0x000fe20000011450ULL,
0x0000001100787306ULL, 0x0005e20000200c00ULL, 0x0000010027107824ULL, 0x042fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011451ULL, 0x0000888027767816ULL, 0x000fe400000000ffULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x00000025007d7306ULL, 0x0003e20000200c00ULL,
0x000001003c117824ULL, 0x044fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011427ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011449ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001000777306ULL, 0x0005e20000200c00ULL, 0x00000002ff257819ULL, 0x002fe40000011603ULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00001f251a257589ULL, 0x000fe200000e0000ULL, 0x0000001100707306ULL, 0x0003e20000200c00ULL,
0x000001003d107824ULL, 0x044fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe2000001144bULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe40000011453ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000024007c7306ULL, 0x0005e20000200c00ULL,
0x000001003e117824ULL, 0x042fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe2000001143dULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fc40000011452ULL,
0x00000018ff677819ULL, 0x000fe20000011411ULL, 0x000001003f117824ULL, 0x000fe200078e00ffULL,
0x0000001000727306ULL, 0x0003e20000200c00ULL, 0x00001f4f1a247589ULL, 0x0045e200000e0000ULL,
0x00000018ff3e7819ULL, 0x000fe4000001143eULL, 0x00000018ff697819ULL, 0x000fe40000011411ULL,
0x00000018ff0f7819ULL, 0x000fe40000011454ULL, 0x0000003c006d7306ULL, 0x0007e20000200c00ULL,
0x000138004e107811ULL, 0x002fc400078e20ffULL, 0x000088804a1a7816ULL, 0x004fe400000000ffULL,
0x000088804b4f7816ULL, 0x000fe400000000ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000000ac00ac7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3c7819ULL, 0x008fe20000011418ULL,
0x000000ffff187224ULL, 0x000fe200078e00aaULL, 0x00000018ff0e7819ULL, 0x000fe40000011455ULL,
0x00000018ff0b7819ULL, 0x000fc40000011456ULL, 0x000000ff1800720cULL, 0x000fe20003f25270ULL,
0x0000006600ad7306ULL, 0x0004e20000200c00ULL, 0x0000010049187824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fc80000011457ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x000000a600a67306ULL, 0x000f220000200c00ULL, 0x000088803f667816ULL, 0x044fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x000000a400a47306ULL, 0x000eb00000200c00ULL, 0x0000009c009c7306ULL, 0x000fe20000200c00ULL,
0x0000002510109232ULL, 0x002fce0000000000ULL, 0x0000009a009a7306ULL, 0x000fe20000200c00ULL,
0x0000002512129232ULL, 0x000fe40000000000ULL, 0x0000002411119232ULL, 0x080fe40000000000ULL,
0x0000002413139232ULL, 0x000fc60000000000ULL, 0x0000006500a77306ULL, 0x000ff00000200c00ULL,
0x0000003e00657306ULL, 0x000ff00000200c00ULL, 0x0000001900997306ULL, 0x0007f00000200c00ULL,
0x00000018003e7306ULL, 0x0003e20000200c00ULL, 0x00005410ac197816ULL, 0x008fce00000000adULL,
0x000000a800a87306ULL, 0x000ee20000200c00ULL, 0x00005410af187816ULL, 0x002fce00000000aeULL,
0x000000a200a27306ULL, 0x000e620000200c00ULL, 0x00000018102c723cULL, 0x000fee000000182cULL,
0x000000a000a07306ULL, 0x000f620000200c00ULL, 0x00005410ab187816ULL, 0x010fe400000000a6ULL,
0x00005410a9197816ULL, 0x004fca00000000a4ULL, 0x0000009d009d7306ULL, 0x000ea40000200c00ULL,
0x000000181028723cULL, 0x000fec0000001828ULL, 0x0000001c008c7306ULL, 0x0009e20000200c00ULL,
0x00005410a8187816ULL, 0x008fe400000000a7ULL, 0x00005410a2197816ULL, 0x002fca00000000a5ULL,
0x0000001d008d7306ULL, 0x0003e20000200c00ULL, 0x00005410a31c7816ULL, 0x010fe2000000009cULL,
0x000000181020723cULL, 0x000fec0000001820ULL, 0x0000009400947306ULL, 0x000fe20000200c00ULL,
0x00005410a11d7816ULL, 0x002fce000000009aULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x0000001c1030723cULL, 0x000fee0000001830ULL, 0x0000003f004e7306ULL, 0x0007e20000200c00ULL,
0x00005410a01c7816ULL, 0x020fe4000000009fULL, 0x000054109d1d7816ULL, 0x004fca000000009eULL,
0x0000001b00907306ULL, 0x0005e20000200c00ULL, 0x000000ffff3f7224ULL, 0x008fe200078e001aULL,
0x000138005c1a7811ULL, 0x000fe200078e20ffULL, 0x0000001c1034723cULL, 0x000fea0000001834ULL,
0x0000001f00837306ULL, 0x0007e20000200c00ULL, 0x000001004a1b7824ULL, 0x004fe200078e00ffULL,
0x00005410991d7816ULL, 0x002fe20000000092ULL, 0x0000010050927824ULL, 0x000fca00078e00ffULL,
0x0000009800987306ULL, 0x000e620000200c00ULL, 0x000001004b1f7824ULL, 0x048fe400078e00ffULL,
0x000100004b4b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141fULL,
0x000100004a1f7824ULL, 0x000fe200078e00ffULL, 0x0000009500957306ULL, 0x000ea20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fc6000001144bULL, 0x00000018ff1f7819ULL, 0x000fc8000001141fULL,
0x0000002600737306ULL, 0x0007f00000200c00ULL, 0x0000003d006c7306ULL, 0x0009e20000200c00ULL,
0x0001000048267824ULL, 0x008fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000001c004a7306ULL, 0x0007e20000200c00ULL, 0x00008880483d7816ULL, 0x010fe400000000ffULL,
0x00000018ff487819ULL, 0x000fe4000001141bULL, 0x000000001a18783bULL, 0x000f260000000200ULL,
0x0000008600867306ULL, 0x000f620000200c00ULL, 0x000054109b1c7816ULL, 0x008fce0000000094ULL,
0x0000008500857306ULL, 0x000ee20000200c00ULL, 0x0000001c1044723cULL, 0x000fee0000001844ULL,
0x00005410981c7816ULL, 0x002fe20000000097ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x00005410951d7816ULL, 0x004fce0000000096ULL, 0x0000001c1040723cULL, 0x000fe20000001840ULL,
0x0000007b007b7306ULL, 0x000fec0000200c00ULL, 0x00008880501d7816ULL, 0x040fe200000000ffULL,
0x0001000050507824ULL, 0x000fe200078e00ffULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x00005410931c7816ULL, 0x020fc40000000086ULL, 0x000000ffff867224ULL, 0x000fe200078e001dULL,
0x00005410901d7816ULL, 0x008fe20000000085ULL, 0x0000002518189232ULL, 0x090fe20000000000ULL,
0x00000018ff857819ULL, 0x000fe20000011492ULL, 0x000000251a1a9232ULL, 0x000fe20000000000ULL,
0x0000001f005c7306ULL, 0x0007e20000200c00ULL, 0x0000002419199232ULL, 0x080fe40000000000ULL,
0x0000001c1010723cULL, 0x000fe20000001838ULL, 0x000000241b1b9232ULL, 0x000fc80000000000ULL,
0x0000008100817306ULL, 0x000f220000200c00ULL, 0x00008880511f7816ULL, 0x048fe200000000ffULL,
0x00010000513a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011450ULL,
0x00000100523b7824ULL, 0x000fe200078e00ffULL, 0x00005410881d7816ULL, 0x002fe2000000008fULL,
0x000000ffff887224ULL, 0x000fe200078e001fULL, 0x0000541083397816ULL, 0x004fe2000000007aULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x00000100511f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3a7819ULL, 0x000fc4000001143aULL, 0x00000018ff3b7819ULL, 0x000fc8000001143bULL,
0x0000003800517306ULL, 0x0005f00000200c00ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x0000541082387816ULL, 0x004fce000000007bULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x000000381830723cULL, 0x000fee0000001830ULL, 0x0000007900797306ULL, 0x000f620000200c00ULL,
0x0000541081387816ULL, 0x010fe40000000080ULL, 0x000054107e397816ULL, 0x002fca000000007fULL,
0x0000007600767306ULL, 0x000e640000200c00ULL, 0x000000381834723cULL, 0x000fec0000001834ULL,
0x0000009100917306ULL, 0x000f220000200c00ULL, 0x000054107c387816ULL, 0x008fe4000000006bULL,
0x000054107d397816ULL, 0x004fc4000000006aULL, 0x00008880536b7816ULL, 0x000fc600000000ffULL,
0x0000008700877306ULL, 0x000ea40000200c00ULL, 0x000000381844723cULL, 0x000fec0000001844ULL,
0x0000008400847306ULL, 0x000ee20000200c00ULL, 0x0000541079387816ULL, 0x020fe40000000078ULL,
0x0000541076397816ULL, 0x002fc40000000077ULL, 0x00005410911c7816ULL, 0x010fe4000000008eULL,
0x000000010a787812ULL, 0x000fe2000784c0ffULL, 0x0000006400647306ULL, 0x000e640000200c00ULL,
0x000000381840723cULL, 0x000fe20000001840ULL, 0x0000006e756e7207ULL, 0x000fca0005000000ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000010053397824ULL, 0x040fe200078e00ffULL,
0x0000001c182c723cULL, 0x000fe2000000182cULL, 0x0001000053537824ULL, 0x000fca00078e00ffULL,
0x0000002700747306ULL, 0x0009e20000200c00ULL, 0x000054108c1c7816ULL, 0x004fe40000000087ULL,
0x000054108d1d7816ULL, 0x008fe40000000084ULL, 0x0000541073387816ULL, 0x002fe40000000064ULL,
0x00000018ff877819ULL, 0x000fe2000001141fULL, 0x0000008b008b7306ULL, 0x000e620000200c00ULL,
0x000138005d1f7811ULL, 0x000fe200078e20ffULL, 0x0000001c1828723cULL, 0x000fe20000001828ULL,
0x0000888049277816ULL, 0x050fe200000000ffULL, 0x0001000049497824ULL, 0x000fe200078e00ffULL,
0x00008880525d7816ULL, 0x040fe200000000ffULL, 0x0001000052527824ULL, 0x000fc400078e00ffULL,
0x0000008900897306ULL, 0x000ea20000200c00ULL, 0x00000018ff497819ULL, 0x000fce0000011449ULL,
0x0000003a00507306ULL, 0x0007e20000200c00ULL, 0x000054108b1c7816ULL, 0x002fe4000000008aULL,
0x00005410891d7816ULL, 0x004fca000000001eULL, 0x0000003b006a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x008fe40000011439ULL, 0x0000541074397816ULL, 0x000fe20000000063ULL,
0x0000001c1820723cULL, 0x040fe20000001820ULL, 0x000000001f1c783bULL, 0x000e660000000200ULL,
0x0000003d003d7306ULL, 0x000fe80000200c00ULL, 0x000000381810723cULL, 0x000fe80000001810ULL,
0x0000003a001a7306ULL, 0x0005e60000200c00ULL, 0x000138005e387811ULL, 0x000fc400078e20ffULL,
0x00000018ff197819ULL, 0x000fc60000011453ULL, 0x0000003c003c7306ULL, 0x000ee20000200c00ULL,
0x0000888055537816ULL, 0x000fe200000000ffULL, 0x000000003838783bULL, 0x004ea20000000200ULL,
0x00000018ff187819ULL, 0x000fe20000011452ULL, 0x0000010054527824ULL, 0x040fe200078e00ffULL,
0x00008880541b7816ULL, 0x040fe200000000ffULL, 0x0001000054547824ULL, 0x000fe400078e00ffULL,
0x0000002700277306ULL, 0x000f220000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff547819ULL, 0x000fca0000011454ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000054103d3c7816ULL, 0x008fe2000000003cULL, 0x000000251c1c9232ULL, 0x002fcc0000000000ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x00005410273d7816ULL, 0x010fe2000000003eULL,
0x000000251e1e9232ULL, 0x080fe40000000000ULL, 0x000000241d1d9232ULL, 0x080fe40000000000ULL,
0x000000241f1f9232ULL, 0x000fe40000000000ULL, 0x0000007100717306ULL, 0x000eea0000200c00ULL,
0x0000003c1c34723cULL, 0x000fe60000001834ULL, 0x0000004f004f7306ULL, 0x000f220000200c00ULL,
0x0000541049277816ULL, 0x002fe2000000005aULL, 0x0000002538389232ULL, 0x004fc40000000000ULL,
0x000000253a3a9232ULL, 0x000fe20000000000ULL, 0x0000888056257816ULL, 0x000fe200000000ffULL,
0x0000002439399232ULL, 0x080fe40000000000ULL, 0x0000006200627306ULL, 0x000e620000200c00ULL,
0x0000541071707816ULL, 0x008fe20000000070ULL, 0x000000243b3b9232ULL, 0x000fe20000000000ULL,
0x0000888057247816ULL, 0x000fe400000000ffULL, 0x000000ff6eff7812ULL, 0x000fc6000782c0ffULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x000054104f497816ULL, 0x010fe4000000004aULL,
0x00000001ff767807ULL, 0x000fc80000800000ULL, 0x0000007675757207ULL, 0x000fe20005000000ULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x000054106d627816ULL, 0x002fce0000000062ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000054106c637816ULL, 0x004fce0000000061ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00005410655e7816ULL, 0x008fe20000000060ULL,
0x000000621c28723cULL, 0x000fec0000001828ULL, 0x0000005900597306ULL, 0x000ea20000200c00ULL,
0x000054104e5f7816ULL, 0x002fe2000000005fULL, 0x000000ffff4e7224ULL, 0x000fc400078e0053ULL,
0x0000010055537824ULL, 0x040fe400078e00ffULL, 0x0001000055557824ULL, 0x000fe400078e00ffULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000005e1c30723cULL, 0x000fe20000001830ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x00000018ff557819ULL, 0x000fc80000011455ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x000054105c4a7816ULL, 0x004fce0000000059ULL,
0x0000006800687306ULL, 0x000ff00000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054106f717816ULL, 0x002fce0000000072ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x000000701c2c723cULL, 0x000fee000000182cULL, 0x0000006900697306ULL, 0x000e620000200c00ULL,
0x0000541068687816ULL, 0x004fce0000000067ULL, 0x0000002600267306ULL, 0x000eb00000200c00ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x0000541066697816ULL, 0x002fce0000000069ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000541026267816ULL, 0x004fe2000000005bULL,
0x000000681c20723cULL, 0x040fec0000001820ULL, 0x0000004b004b7306ULL, 0x000ea40000200c00ULL,
0x000000261c44723cULL, 0x000fec0000001844ULL, 0x0000001600167306ULL, 0x000ee20000200c00ULL,
0x000054103f487816ULL, 0x002fc40000000048ULL, 0x000054104b4b7816ULL, 0x004fca0000000058ULL,
0x0000001500157306ULL, 0x000e620000200c00ULL, 0x000000481c40723cULL, 0x040fee0000001840ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x0000004a1c10723cULL, 0x000fee0000001810ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0025ULL, 0x0000001400147306ULL, 0x000fe20000200c00ULL,
0x00000100561d7824ULL, 0x000fc400078e00ffULL, 0x0001000056567824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c001e7306ULL, 0x0007e20000200c00ULL,
0x00000018ff567819ULL, 0x000fce0000011456ULL, 0x0000001d001f7306ULL, 0x0002a20000200c00ULL,
0x00005410511c7816ULL, 0x008fe20000000016ULL, 0x0000010057167824ULL, 0x040fe400078e00ffULL,
0x0001000057577824ULL, 0x000fc600078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x00005410501d7816ULL, 0x002fe20000000015ULL,
0x000000ffff157224ULL, 0x000fe200078e0024ULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000054101e1e7816ULL, 0x004fe2000000001fULL,
0x0000001c3828723cULL, 0x000fec0000001828ULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008500857306ULL, 0x000e700000200c00ULL, 0x0000008800887306ULL, 0x000ff00000200c00ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x0000541086867816ULL, 0x002fce0000000085ULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000006b006b7306ULL, 0x000ee20000200c00ULL,
0x0000541088877816ULL, 0x004fce0000000087ULL, 0x0000001800187306ULL, 0x000ea20000200c00ULL,
0x000054105d6a7816ULL, 0x002fe2000000006aULL, 0x00000086382c723cULL, 0x000fec000000182cULL,
0x0000001900197306ULL, 0x000e620000200c00ULL, 0x000054106b6b7816ULL, 0x008fce000000001aULL,
0x0000001b001b7306ULL, 0x000fe20000200c00ULL, 0x0000541018187816ULL, 0x004fe2000000000dULL,
0x0000006a3820723cULL, 0x000fec0000001820ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x0000541019197816ULL, 0x002fce0000000014ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x000000183830723cULL, 0x000fee0000001830ULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000054101b527816ULL, 0x004fce0000000052ULL, 0x0000005400547306ULL, 0x000eb00000200c00ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000054104e537816ULL, 0x002fce0000000053ULL,
0x0000001500157306ULL, 0x000fe20000200c00ULL, 0x0000541054547816ULL, 0x004fe2000000000fULL,
0x000000523834723cULL, 0x000fec0000001834ULL, 0x0000001600167306ULL, 0x000e620000200c00ULL,
0x0000541055557816ULL, 0x008fce000000000eULL, 0x0000000b000b7306ULL, 0x000fe20000200c00ULL,
0x000000543844723cULL, 0x000fee0000001844ULL, 0x0000000c000c7306ULL, 0x000fe20000200c00ULL,
0x00005410151f7816ULL, 0x002fce0000000016ULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x0000001e3840723cULL, 0x000fee0000001840ULL, 0x0000005700577306ULL, 0x000ea20000200c00ULL,
0x0000541056567816ULL, 0x002fe4000000000bULL, 0x0000541057577816ULL, 0x004fce000000000cULL,
0x000000563838723cULL, 0x000fe20000001810ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c65800ffff7f8cULL, 0x000fe2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c64000ffff7f8cULL, 0x000fe2000c80043fULL,
0x00009910750a7816ULL, 0x000fe400000000ffULL, 0x00000001ff777807ULL, 0x000fe40004000000ULL,
0x000000ff0a00720cULL, 0x000fc80003f25270ULL, 0x00000001ff76a807ULL, 0x000fe40000800000ULL,
0x000003004d4d7a10ULL, 0x000fe40007ffe0ffULL, 0x000000ff09ff7812ULL, 0x000fe4000780c0ffULL,
0x000000024d00720cULL, 0x000fe40003f26070ULL, 0x00000001ff097807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff4b4000007947ULL, 0x000fea000383ffffULL,
0x0000000000097919ULL, 0x002e640000002500ULL, 0x000000020900720cULL, 0x002fda0003f06070ULL,
0x0000037000000947ULL, 0x000fea0003800000ULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000c64000047802ULL, 0x000fe40000000f00ULL, 0x0000993000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000ea8000c1e9900ULL,
0x0000000000057919ULL, 0x000ee40000000000ULL, 0x00000002ff0b7819ULL, 0x008fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x004fca0000410000ULL,
0x00001f0b00047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000002c042c7220ULL, 0x044fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000002804287220ULL, 0x040fe40000410000ULL, 0x0000002904297220ULL, 0x000fc40000410000ULL,
0x0000002004207220ULL, 0x040fe40000410000ULL, 0x0000002104217220ULL, 0x040fe40000410000ULL,
0x0000003004307220ULL, 0x040fe40000410000ULL, 0x0000003104317220ULL, 0x040fe40000410000ULL,
0x0000003404347220ULL, 0x040fe40000410000ULL, 0x0000003504357220ULL, 0x000fc40000410000ULL,
0x0000004404447220ULL, 0x040fe40000410000ULL, 0x0000004504457220ULL, 0x040fe40000410000ULL,
0x0000004004407220ULL, 0x040fe40000410000ULL, 0x0000004104417220ULL, 0x040fe40000410000ULL,
0x0000003804387220ULL, 0x040fe40000410000ULL, 0x0000003904397220ULL, 0x000fc40000410000ULL,
0x0000002e052e7220ULL, 0x048fe40000410000ULL, 0x0000002f052f7220ULL, 0x040fe40000410000ULL,
0x0000002a052a7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x040fe40000410000ULL,
0x0000002205227220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x000fc40000410000ULL,
0x0000003205327220ULL, 0x040fe40000410000ULL, 0x0000003305337220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x040fe40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000004605467220ULL, 0x040fe40000410000ULL, 0x0000004705477220ULL, 0x000fc40000410000ULL,
0x0000004205427220ULL, 0x040fe40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x000fe40000410000ULL,
0x0000000000107919ULL, 0x000ea20000000000ULL, 0x00000300ff277624ULL, 0x000fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fe40000010000ULL, 0x000000012700780cULL, 0x000fe40003f05270ULL,
0x0000000210007812ULL, 0x004fe400078ec0ffULL, 0x00000002ff117819ULL, 0x000fe40000011610ULL,
0x00000001ff027819ULL, 0x000fe40000011600ULL, 0x0000000200037811ULL, 0x000fc400078ff8ffULL,
0x0000000400087811ULL, 0x040fe400078ff8ffULL, 0x00000006000c7811ULL, 0x000fe400078ff8ffULL,
0x0000000810197811ULL, 0x000fe400078ff0ffULL, 0x0000000702007812ULL, 0x100fe400078e7811ULL,
0x00000007080a7812ULL, 0x040fe400078e7811ULL, 0x0000000708087812ULL, 0x100fe200078e7819ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000702027812ULL, 0x000fe200078e7819ULL,
0x000008004c007824ULL, 0x000fe200078e00ffULL, 0x0000000703047812ULL, 0x100fe200078e7811ULL,
0x0000000819177824ULL, 0x040fe200078e0208ULL, 0x000000070c0e7812ULL, 0x000fe200078e7811ULL,
0x00000008190f7824ULL, 0x000fe200078e0202ULL, 0x0000000703037812ULL, 0x100fe200078e7819ULL,
0x0000000810087824ULL, 0x000fe200078e00ffULL, 0x000000070c0c7812ULL, 0x000fe200078e7819ULL,
0x00000008110b7824ULL, 0x040fe200078e0204ULL, 0x0001200000027810ULL, 0x000fe20007ffe0ffULL,
0x00000008110d7824ULL, 0x000fe200078e020aULL, 0x0000000808087812ULL, 0x000fe200078ec0ffULL,
0x0000000819157824ULL, 0x000fe200078e0203ULL, 0x0000002c2d03723eULL, 0x000fe200000000ffULL,
0x0000000811117824ULL, 0x000fe200078e020eULL, 0x000000282904723eULL, 0x000fe200000000ffULL,
0x0000000819197824ULL, 0x000fe200078e020cULL, 0x0000002e2f0a723eULL, 0x000fe200000000ffULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x00005410031a7816ULL, 0x000fe20000000004ULL,
0x000000100f137824ULL, 0x000fe200078e0202ULL, 0x00007632031b7816ULL, 0x000fe20000000004ULL,
0x000000100b0b7824ULL, 0x100fe200078e0202ULL, 0x000000343503723eULL, 0x000fe200000000ffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x000000444504723eULL, 0x000fe200000000ffULL,
0x000000100d0f7824ULL, 0x000fc400078e0202ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x0000001017177824ULL, 0x100fe400078e0202ULL, 0x0000001019197824ULL, 0x000fe400078e0202ULL,
0x00000001050c7824ULL, 0x000fe200078e0208ULL, 0x000000202105723eULL, 0x000fe200000000ffULL,
0x0000000108137824ULL, 0x040fe400078e0213ULL, 0x00000001080d7824ULL, 0x040fe200078e020bULL,
0x0000001a0c007388ULL, 0x0005e20000000a00ULL, 0x0000000108157824ULL, 0x040fe200078e0215ULL,
0x0000002a2b0b723eULL, 0x000fe200000000ffULL, 0x00000001080f7824ULL, 0x000fc400078e020fULL,
0x0000000108117824ULL, 0x040fe400078e0211ULL, 0x0000000108177824ULL, 0x040fe400078e0217ULL,
0x0000000108197824ULL, 0x000fe200078e0219ULL, 0x000000303108723eULL, 0x000fe400000000ffULL,
0x00005410030c7816ULL, 0x004fe40000000004ULL, 0x00005410051a7816ULL, 0x140fe40000000008ULL,
0x00007632051b7816ULL, 0x000fc40000000008ULL, 0x000000404105723eULL, 0x000fe400000000ffULL,
0x000000383908723eULL, 0x000fe200000000ffULL, 0x0000001a0d007388ULL, 0x0005e40000000a00ULL,
0x00007632030d7816ULL, 0x004fe40000000004ULL, 0x000000222303723eULL, 0x000fe400000000ffULL,
0x000000323304723eULL, 0x000fe200000000ffULL, 0x0000000c0f007388ULL, 0x0005e40000000a00ULL,
0x00005410050c7816ULL, 0x004fc40000000008ULL, 0x00007632050d7816ULL, 0x000fe40000000008ULL,
0x000000363705723eULL, 0x000fe400000000ffULL, 0x000000464708723eULL, 0x000fe200000000ffULL,
0x0000000c11007388ULL, 0x0005e40000000a00ULL, 0x000054100a0c7816ULL, 0x144fe4000000000bULL,
0x000076320a0d7816ULL, 0x000fe4000000000bULL, 0x00000042430a723eULL, 0x000fc400000000ffULL,
0x0000003a3b0b723eULL, 0x000fe200000000ffULL, 0x0000000c13007388ULL, 0x0005e40000000a00ULL,
0x00005410030c7816ULL, 0x144fe40000000004ULL, 0x00007632030d7816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000008ULL, 0x0000763205057816ULL, 0x000fe20000000008ULL,
0x0000000c15007388ULL, 0x0005e80000000a00ULL, 0x0000000417007388ULL, 0x0007e20000000a00ULL,
0x000054100a0c7816ULL, 0x004fc4000000000bULL, 0x000076320a0d7816ULL, 0x000fca000000000bULL,
0x0000000c19007388ULL, 0x0007e20000000a00ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002cc000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x0000580027047a24ULL, 0x008fe200078e02ffULL, 0x000000ff4c00720cULL, 0x000fe40003f25270ULL,
0x0000000000267919ULL, 0x000ee20000002700ULL, 0x00006400040a7a24ULL, 0x000fc600078e02ffULL,
0x0000000000057919ULL, 0x000ee20000002600ULL, 0x00000010030b7824ULL, 0x044fe200078e0200ULL,
0x0000002003217810ULL, 0x040fe40007ffe0ffULL, 0x0000004003237810ULL, 0x040fe40007ffe0ffULL,
0x012000000b0c7984ULL, 0x0005220000000c00ULL, 0x0000006003257810ULL, 0x000fe20007ffe0ffULL,
0x0000580026267a24ULL, 0x008fe400078e0205ULL, 0x012200000b107984ULL, 0x0004e20000000c00ULL,
0x00001fff0a057811ULL, 0x000fe200078e40ffULL, 0x0000030026047a24ULL, 0x000fc400078e02ffULL,
0x012400000b147984ULL, 0x0004620000000c00ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x00000001041c7824ULL, 0x000fe400078e0209ULL, 0x012600000b187984ULL, 0x0004620000000c00ULL,
0x00002000ff097424ULL, 0x000fe200078e00ffULL, 0x000000ff4c00720cULL, 0x000fe40000705670ULL,
0x0000001c05087211ULL, 0x000fca00078f98ffULL, 0x00006a0008087625ULL, 0x000fcc00078e0009ULL,
0x000008004c087825ULL, 0x000fcc00078e0008ULL, 0x0000001021207825ULL, 0x000fc800078e0008ULL,
0x0000001023227825ULL, 0x000fc800078e0008ULL, 0x0000001025247825ULL, 0x000fc800078e0008ULL,
0x00000010031e7825ULL, 0x000fe200078e0008ULL, 0x01ffffff0a097812ULL, 0x000fe200078ec0ffULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x01cea20000000000ULL,
0x00000080ff087424ULL, 0x000fe400078e00ffULL, 0x000000011c1d7824ULL, 0x000fe400078e0209ULL,
0x000000100a287824ULL, 0x004fe200078e00ffULL, 0x00000001ff2a7819ULL, 0x000fe2000001160aULL,
0x00006a001c0a7625ULL, 0x000fc600078e0008ULL, 0x0000007028297812ULL, 0x000fe200078ec0ffULL,
0x00006a001d1c7625ULL, 0x000fe200078e0008ULL, 0x0000000c2a2a7812ULL, 0x000fc800078ec0ffULL,
0x0000000a2a0a7210ULL, 0x140fe40007b5e029ULL, 0x0000001c2a1c7210ULL, 0x000fe40007d9e029ULL,
0x0000000bff0b7210ULL, 0x000fe400017e64ffULL, 0x0000001dff1d7210ULL, 0x000fc600027ea4ffULL,
0x000000060a007986ULL, 0x0005e8000c101906ULL, 0x000000071c007986ULL, 0x0005e4000c101906ULL,
0x0000000c1e007986ULL, 0x01c5e2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000001020007986ULL, 0x0005e8000c101d06ULL, 0x0000001422007986ULL, 0x0025e8000c101d06ULL,
0x0000001824007986ULL, 0x0005e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000e000000947ULL, 0x000fea0003800000ULL, 0x00000004ff077424ULL, 0x000fe200078e00ffULL,
0xffffffff270b7810ULL, 0x000fc60007ffe0ffULL, 0x0000680026067625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b060679a8ULL, 0x000ee400099ee1c6ULL, 0x0000000b0600720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff087807ULL, 0x000fca0000000000ULL,
0x00000008ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x000ee40000000000ULL,
0x000000ff0600720cULL, 0x008fda0003f05270ULL, 0x0000285000008947ULL, 0x000fea0003800000ULL,
0x00000d1000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fe20000011603ULL, 0x00000080ff0d7424ULL, 0x004fe200078e00ffULL,
0x00000001040a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007006177812ULL, 0x000fe400078ec0ffULL,
0x0000000c07087812ULL, 0x002fe200078ec0ffULL, 0x00006a0004067625ULL, 0x000fc800078e000dULL,
0x00006a000a0a7625ULL, 0x000fe200078e000dULL, 0x0000000608067210ULL, 0x000fc8000791e017ULL,
0x0000000a080a7210ULL, 0x000fe40007b5e017ULL, 0x00000007ff077210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000606067981ULL, 0x000368000c1e1900ULL,
0x000000060a0f7981ULL, 0x000362000c1e1900ULL, 0x000000022700780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x00000002040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a080a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a077981ULL, 0x000362000c1e1900ULL,
0x000000042700780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x00000003040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a080a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a117981ULL, 0x000362000c1e1900ULL, 0x000000042700780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x00000004040a7810ULL, 0x002fca0007ffe0ffULL,
0x00006a000a0a7625ULL, 0x000fca00078e000dULL, 0x0000000a080a7210ULL, 0x000fc8000791e017ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a137981ULL, 0x000362000c1e1900ULL,
0x000000062700780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005040a7810ULL, 0x002fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a080a7210ULL, 0x000fc8000791e017ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a157981ULL, 0x000362000c1e1900ULL, 0x000000062700780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000082700780cULL, 0x002fe40003f06070ULL,
0x00000006040a7810ULL, 0x000fca0007ffe0ffULL, 0x00006a000a0a7625ULL, 0x000fca00078e000dULL,
0x0000000a080a7210ULL, 0x000fe40007a3e017ULL, 0x00000007040c0810ULL, 0x000fe40007ffe0ffULL,
0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL, 0x00006a000c0c0625ULL, 0x000fca00078e000dULL,
0x0000000c080c0210ULL, 0x000fe40007c7e017ULL, 0x000000060a177981ULL, 0x000364000c1e1900ULL,
0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL, 0x000000060c190981ULL, 0x000368000c1e1900ULL,
0x0000000727087810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff087819ULL, 0x000fc80000011608ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000008d000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0d7224ULL, 0x004fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x020fe400078e0006ULL,
0x000000080d0c7824ULL, 0x040fe200078e00ffULL, 0x000000010d0d7810ULL, 0x000fc80007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000000080d00720cULL, 0x000fd60003f06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x000000080c0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000010c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001b06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e1b7812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e01bULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a1b7981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x000000090c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000020c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e00fULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a0f7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000030c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001003077824ULL, 0x000fe200078e00ffULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e0a7210ULL, 0x000fc80007b3e007ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a077981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b0c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000040c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001106067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e117812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e011ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000050c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001306067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e137812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e013ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d0c0b7810ULL, 0x042fe40007ffe0ffULL, 0x000000060c0a7810ULL, 0x000fe40007ffe0ffULL,
0x000003000b007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001506067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff107819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10107812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700e157812ULL, 0x000fc800078ec0ffULL, 0x0000000a100a7210ULL, 0x000fc80007b3e015ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a157981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c0b7810ULL, 0x042fe40007ffe0ffULL,
0x000000070c0a7810ULL, 0x000fe40007ffe0ffULL, 0x000003000b007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001706067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000001040a7824ULL, 0x000fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011603ULL, 0x00000080ff0b7424ULL, 0x000fe400078e00ffULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x0000000c10107812ULL, 0x000fe200078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fc600078e000bULL, 0x000000700e177812ULL, 0x000fc800078ec0ffULL,
0x0000000a100a7210ULL, 0x000fc80007b3e017ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a177981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f0c0b7810ULL, 0x002fe40007ffe0ffULL, 0x0000001906067209ULL, 0x000fe40007810000ULL,
0x000003000b007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000001040a7824ULL, 0x000fe200078e020bULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000080ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x00006a000a0a7625ULL, 0x000fc600078e000bULL,
0x000000700c197812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fc80007a3e019ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL, 0x000000060a197981ULL, 0x000368000c1e1900ULL,
0xfffff75000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000001003077824ULL, 0x028fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011603ULL,
0x0000007007077812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fca00078ec0ffULL,
0x0000000107077824ULL, 0x000fca00078e0208ULL, 0x0000000607007388ULL, 0x0007e40000000800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000004050a7211ULL, 0x002fe200078f98ffULL,
0x00002000ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000001003087824ULL, 0x040fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x004fe20000011603ULL,
0x00006a000a0a7625ULL, 0x000fe200078e000bULL, 0x00000015ff077819ULL, 0x008fe2000001164cULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x000008004c067824ULL, 0x000fe200078e00ffULL, 0x0000000c0c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000020030f7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000000060a0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000104108824ULL, 0x000fe200078e0209ULL, 0x0000004003157810ULL, 0x040fe20007ffe0ffULL,
0x00000080ff118424ULL, 0x000fe200078e00ffULL, 0x0000006003177810ULL, 0x000fe20007ffe0ffULL,
0x0000000108127824ULL, 0x000fe200078e020dULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x00000080ff1b8424ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000010b0b7824ULL, 0x000fe200008e0607ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x000010004c087824ULL, 0x000fc400078e00ffULL, 0x00006a0010108625ULL, 0x000fc800078e0011ULL,
0x000000104c1f8824ULL, 0x000fe400078e0203ULL, 0x00006a00041a8625ULL, 0x000fc600078e001bULL,
0x000045801f1f8811ULL, 0x000fe200078e20ffULL, 0x00000010031d7824ULL, 0x040fe400078e0208ULL,
0x00000010030c7825ULL, 0x000fc800078e000aULL, 0x000000104c218824ULL, 0x000fe400078e0203ULL,
0x000000100f0e7825ULL, 0x000fc600078e000aULL, 0x0000418021218811ULL, 0x000fe200078e20ffULL,
0x0000001015147825ULL, 0x000fc800078e000aULL, 0x0000001017167825ULL, 0x000fe400078e000aULL,
0x00000000120a7984ULL, 0x0002a40000000800ULL, 0x0000001003188825ULL, 0x040fe400078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1d7faeULL, 0x0007e2000b901c46ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000010031a8825ULL, 0x000fe400078e001aULL,
0x003800000e1d7faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e00ffULL, 0x00580000141d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2c7224ULL, 0x000fc600078e00ffULL, 0x00780000161d7faeULL, 0x000be2000b901c46ULL,
0x00000000000c7805ULL, 0x008fc6000001ff00ULL, 0x00000000181f8faeULL, 0x0007e2000b901c46ULL,
0x00000000000e7805ULL, 0x010fc6000001ff00ULL, 0x000000001a218faeULL, 0x0009e2000b901c46ULL,
0x0000000000147805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000167805ULL, 0x020fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x008fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x010fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000d6000009947ULL, 0x000fea0003800000ULL, 0x000000ffff0b7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2d7224ULL, 0x000fca00078e00ffULL, 0x000000012d2b7810ULL, 0x000fc80007ffe0ffULL,
0x000003002b007a0cULL, 0x000fda0003f06070ULL, 0x0000029000000947ULL, 0x000fea0003800000ULL,
0x00000001043a7824ULL, 0x000fe200078e022bULL, 0x000000070300780cULL, 0x000fe20003f24070ULL,
0x00002000ff2f7424ULL, 0x000fe200078e00ffULL, 0x000000012b337812ULL, 0x040fe200078ec0ffULL,
0x000008002b307824ULL, 0x000fe200078e00ffULL, 0x0000003a052e7211ULL, 0x000fe400078f98ffULL,
0x0000002003357810ULL, 0x040fe40007ffe0ffULL, 0x0000080030317812ULL, 0x000fe200078ec0ffULL,
0x00006a002e2e7625ULL, 0x000fe200078e002fULL, 0x0000004003397810ULL, 0x000fc40007ffe0ffULL,
0x00000060033d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108307824ULL, 0x000fe200078e0231ULL,
0x000000062e2e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109369824ULL, 0x000fe400078e023aULL,
0x00000080ff379424ULL, 0x000fe400078e00ffULL, 0x000000012f2f7824ULL, 0x000fe400000e0607ULL,
0x000000024c389824ULL, 0x140fe400078e0233ULL, 0x000000024c3c9824ULL, 0x000fc400078e0233ULL,
0x00000080ff3f9424ULL, 0x000fe400078e00ffULL, 0x00000010033b7824ULL, 0x000fe400078e0230ULL,
0x0000001035327825ULL, 0x000fc800078e002eULL, 0x0000001039347825ULL, 0x000fc800078e002eULL,
0x0000001003307825ULL, 0x000fc800078e002eULL, 0x000000103d2e7825ULL, 0x000fe200078e002eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000303b7faeULL, 0x0003e6000b901c46ULL,
0x00006a0036369625ULL, 0x000fe200078e0037ULL, 0x00380000323b7faeULL, 0x0003e6000b901c46ULL,
0x00000008383d9824ULL, 0x000fe200078e0203ULL, 0x00580000343b7faeULL, 0x0003e2000b901c46ULL,
0x00006a003a389625ULL, 0x000fc600078e003fULL, 0x000045803d3d9811ULL, 0x000fe200078e20ffULL,
0x000000083c3c9824ULL, 0x000fe200078e0203ULL, 0x007800002e3b7faeULL, 0x0003e2000b901c46ULL,
0x0000001003369825ULL, 0x000fc600078e0036ULL, 0x000041803c3f9811ULL, 0x000fe200078e20ffULL,
0x0000001003389825ULL, 0x000fe200078e0038ULL, 0x00000000363d9faeULL, 0x0003e8000b901c46ULL,
0x00000000383f9faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff307224ULL, 0x002fe200078e002dULL, 0x00000001ff2f7819ULL, 0x100fe20000011603ULL,
0x00000010032e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff367819ULL, 0x000fe20000011603ULL,
0x00000080302d7824ULL, 0x000fe200078e00ffULL, 0x0000000c2f2f7812ULL, 0x000fc400078ec0ffULL,
0x000000702e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000836347824ULL, 0x040fe200078e00ffULL,
0x000000802d2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000836327824ULL, 0x040fe200078e00ffULL,
0x00000007363f7812ULL, 0x000fe400078ec0ffULL, 0x00000036ff3d7212ULL, 0x000fe200078e33ffULL,
0x000001004c2d7824ULL, 0x000fe200078e022dULL, 0x0000000836387810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8343d7812ULL, 0x000fc400078ee23dULL, 0x0000002d2f2f7210ULL, 0x000fe20007ffe02eULL,
0x00000008362e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8322d7812ULL, 0x000fe200078ee23fULL,
0x0000000838327824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002f3b7984ULL, 0x000e620000000800ULL, 0x000000012e317812ULL, 0x100fe200078ef63fULL,
0x0000000838417824ULL, 0x000fe200078e00ffULL, 0x000000022e337812ULL, 0x140fe200078ef63fULL,
0x004580002f4d7984ULL, 0x0002e20000000800ULL, 0x000000032e357812ULL, 0x140fe400078ef63fULL,
0x000000042e377812ULL, 0x140fe400078ef63fULL, 0x000000052e397812ULL, 0x000fe400078ef63fULL,
0x00000038ff4b7212ULL, 0x000fc800078e33ffULL, 0xfffffff8324b7812ULL, 0x000fe400078ee24bULL,
0x0000000738327812ULL, 0x000fe200078ec0ffULL, 0x0000003b0a2f7221ULL, 0x006fe20000010100ULL,
0x000000062e3b7812ULL, 0x000fe200078ef63fULL, 0x00000800302e7824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b2f347820ULL, 0x000fe40000410000ULL, 0x0000000403307824ULL, 0x000fe200078e00ffULL,
0x000008002e2f7812ULL, 0x000fe200078ec0ffULL, 0x00000008383f7824ULL, 0x000fc400078e00ffULL,
0x0000003400347308ULL, 0x000ee20000000800ULL, 0x00000180082e7810ULL, 0x000fe40007ffe02fULL,
0x0000000c30307812ULL, 0x000fe400078ec0ffULL, 0xfffffff8412f7812ULL, 0x000fe200078ee232ULL,
0x000000102d2d7824ULL, 0x000fe200078e022eULL, 0x000000013f417812ULL, 0x000fe200078ef632ULL,
0x0000001035357824ULL, 0x000fe200078e022eULL, 0x000000033f457812ULL, 0x000fe200078ef632ULL,
0x000000012d2d7824ULL, 0x000fe200078e0230ULL, 0x000000023f437812ULL, 0x140fe200078ef632ULL,
0x0000000130357824ULL, 0x040fe200078e0235ULL, 0x000000043f477812ULL, 0x000fe200078ef632ULL,
0x0000001039397824ULL, 0x000fe200078e022eULL, 0x000000053f497812ULL, 0x000fe200078ef632ULL,
0x000000002d2d7984ULL, 0x000e620000000800ULL, 0x000000103d3d7824ULL, 0x000fe200078e022eULL,
0x000000063f3f7812ULL, 0x000fe200078ef632ULL, 0x0000001031317824ULL, 0x000fe200078e022eULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x0000000130397824ULL, 0x000fc400078e0239ULL,
0x000000103b3b7824ULL, 0x100fe400078e022eULL, 0x00000001303d7824ULL, 0x040fe400078e023dULL,
0x0000000130317824ULL, 0x040fe200078e0231ULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000001033337824ULL, 0x100fe400078e022eULL, 0x00000001303b7824ULL, 0x000fe200078e023bULL,
0x000000003d3d7984ULL, 0x000ea20000000800ULL, 0x0000001041417824ULL, 0x000fc400078e022eULL,
0x0000000130337824ULL, 0x000fe200078e0233ULL, 0x0000000031317984ULL, 0x000fe20000000800ULL,
0x0000004d344d7220ULL, 0x008fe40000410000ULL, 0x0000001037377824ULL, 0x100fe200078e022eULL,
0x000000003b3b7984ULL, 0x000fe20000000800ULL, 0x0000000130417824ULL, 0x040fe400078e0241ULL,
0x0000001045457824ULL, 0x000fe200078e022eULL, 0x0000000033337984ULL, 0x000fe20000000800ULL,
0x0000000130377824ULL, 0x000fc400078e0237ULL, 0x000000102f2f7824ULL, 0x100fe200078e022eULL,
0x00001f364d327589ULL, 0x000ee200000e0000ULL, 0x0000000130457824ULL, 0x040fe400078e0245ULL,
0x00000001302f7824ULL, 0x040fe200078e022fULL, 0x0000000041417984ULL, 0x000fe20000000800ULL,
0x0000001043437824ULL, 0x100fe400078e022eULL, 0x0000001047477824ULL, 0x000fe200078e022eULL,
0x0000000037377984ULL, 0x000f220000000800ULL, 0x0000000130437824ULL, 0x000fc400078e0243ULL,
0x0000001049497824ULL, 0x100fe200078e022eULL, 0x0000000045457984ULL, 0x000fe20000000800ULL,
0x000000103f3f7824ULL, 0x100fe400078e022eULL, 0x000000104b4b7824ULL, 0x000fe200078e022eULL,
0x000000002f2f7984ULL, 0x000fe20000000800ULL, 0x0000000130477824ULL, 0x040fe200078e0247ULL,
0x2000002dff2e7230ULL, 0x102fe20000004100ULL, 0x0000000130497824ULL, 0x000fe200078e0249ULL,
0x0000000043437984ULL, 0x000fe20000000800ULL, 0x3000002dff2d7230ULL, 0x000fe20000004100ULL,
0x0000002c4d2c7221ULL, 0x000fc40000010000ULL, 0x00000001303f7824ULL, 0x040fe200078e023fULL,
0x00001f384d4d7589ULL, 0x000e6200000e0000ULL, 0x00000001304b7824ULL, 0x000fe200078e024bULL,
0x2000003dff307230ULL, 0x004fe20000004100ULL, 0x000000322d247223ULL, 0x088fe20000010024ULL,
0x0000000047477984ULL, 0x000ea20000000800ULL, 0x20000035ff2d7230ULL, 0x000fe20000004100ULL,
0x000000322e257223ULL, 0x080fe20000010025ULL, 0x20000031ff2e7230ULL, 0x100fe20000004100ULL,
0x0000000049497984ULL, 0x000ee20000000800ULL, 0x0000003230117223ULL, 0x080fe20000010011ULL,
0x30000031ff317230ULL, 0x000fe20000004100ULL, 0x000000322d1c7223ULL, 0x080fe2000001001cULL,
0x000000003f3f7984ULL, 0x000f620000000800ULL, 0x20000039ff2d7230ULL, 0x000fe20000004100ULL,
0x000000322e237223ULL, 0x080fe20000010023ULL, 0x20000033ff307230ULL, 0x000fe20000004100ULL,
0x000000004b4b7984ULL, 0x000f620000000800ULL, 0x30000035ff2e7230ULL, 0x000fe20000004100ULL,
0x000000322d167223ULL, 0x080fe20000010016ULL, 0x2000003bff2d7230ULL, 0x000fe20000004100ULL,
0x00000032301f7223ULL, 0x080fe2000001001fULL, 0x3000003dff3d7230ULL, 0x000fe20000004100ULL,
0x000000322e1b7223ULL, 0x080fe2000001001bULL, 0x30000037ff307230ULL, 0x010fe20000004100ULL,
0x000000322d0e7223ULL, 0x080fe2000001000eULL, 0x20000041ff2d7230ULL, 0x000fe20000004100ULL,
0x0000003231227223ULL, 0x080fe20000010022ULL, 0x30000039ff2e7230ULL, 0x000fe20000004100ULL,
0x0000003230197223ULL, 0x080fe20000010019ULL, 0x3000003bff307230ULL, 0x000fe20000004100ULL,
0x0000004d2d2a7223ULL, 0x082fe2000001002aULL, 0x20000045ff2d7230ULL, 0x000fe20000004100ULL,
0x000000322e157223ULL, 0x080fe20000010015ULL, 0x3000002fff2e7230ULL, 0x000fe20000004100ULL,
0x00000032300d7223ULL, 0x080fe2000001000dULL, 0x20000037ff317230ULL, 0x000fe20000004100ULL,
0x0000004d2d287223ULL, 0x080fe20000010028ULL, 0x30000043ff307230ULL, 0x000fe20000004100ULL,
0x000000ffff2d7224ULL, 0x000fe200078e002bULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000004d2e217223ULL, 0x080fe20000010021ULL, 0x30000041ff2e7230ULL, 0x000fe20000004100ULL,
0x00000032311a7223ULL, 0x080fe2000001001aULL, 0x000003002d007a0cULL, 0x000fe20003f06070ULL,
0x2000002fff317230ULL, 0x000fe20000004100ULL, 0x0000004d301d7223ULL, 0x080fe2000001001dULL,
0x20000043ff2f7230ULL, 0x000fe20000004100ULL, 0x0000004d2e297223ULL, 0x080fe20000010029ULL,
0x30000045ff2e7230ULL, 0x000fe20000004100ULL, 0x000000323d107223ULL, 0x080fe20000010010ULL,
0x20000047ff307230ULL, 0x004fe20000004100ULL, 0x00000032331e7223ULL, 0x000fe2000001001eULL,
0x20000049ff327230ULL, 0x008fe20000004100ULL, 0x0000004d2f207223ULL, 0x080fe20000010020ULL,
0x30000047ff477230ULL, 0x000fe20000004100ULL, 0x0000004d2e277223ULL, 0x080fe20000010027ULL,
0x30000049ff497230ULL, 0x000fe20000004100ULL, 0x0000004d300f7223ULL, 0x080fe2000001000fULL,
0x2000003fff2b7230ULL, 0x120fe20000004100ULL, 0x0000004d310c7223ULL, 0x080fe2000001000cULL,
0x3000003fff2e7230ULL, 0x000fe20000004100ULL, 0x0000004d47187223ULL, 0x080fe20000010018ULL,
0x2000004bff2f7230ULL, 0x100fe20000004100ULL, 0x0000004d32177223ULL, 0x080fe20000010017ULL,
0x3000004bff307230ULL, 0x000fe20000004100ULL, 0x0000004d49267223ULL, 0x000fc40000010026ULL,
0x0000004d2b147223ULL, 0x080fe40000010014ULL, 0x0000004d2e137223ULL, 0x080fe40000010013ULL,
0x0000004d2f127223ULL, 0x080fe40000010012ULL, 0x0000004d300b7223ULL, 0x000fe2000001000bULL,
0xfffff2c000008947ULL, 0x000fea000383ffffULL, 0x018000002c037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000b000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e002cULL,
0x0000f26000047802ULL, 0x000fe40000000f00ULL, 0x00006d1000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002c00037308ULL, 0x000e640000001000ULL,
0xbf80000003047423ULL, 0x002fc8000000002cULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fe40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000002ff087819ULL, 0x010fe40000011606ULL, 0x0000000806337811ULL, 0x000fe400078ff0ffULL,
0x0000000708077812ULL, 0x046fe200078ec0ffULL, 0x00001f0803047589ULL, 0x008e6200000e0000ULL,
0x00000008080a7824ULL, 0x000fe200078e00ffULL, 0x00000033ff357212ULL, 0x000fc400078e33ffULL,
0x00001f3303057589ULL, 0x0004e200000e0000ULL, 0x0000000107097812ULL, 0x000fe400078e3cffULL,
0x00000008ff037212ULL, 0x004fc800078e33ffULL, 0xfffffff80a377812ULL, 0x000fe200078ee203ULL,
0x0000000808037824ULL, 0x000fe400078e00ffULL, 0x00000008330a7824ULL, 0x000fe400078e00ffULL,
0x0000002504257220ULL, 0x042fe20000410000ULL, 0xfffffff803037812ULL, 0x000fe200078ee208ULL,
0x0000002404247220ULL, 0x040fe40000410000ULL, 0x0000002304237220ULL, 0x040fe40000410000ULL,
0x0000002204227220ULL, 0x000fe20000410000ULL, 0x000000252424723eULL, 0x000fe200000000ffULL,
0x0000001f041f7220ULL, 0x000fc40000410000ULL, 0x0000001e041e7220ULL, 0x000fe20000410000ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000000607237812ULL, 0x040fe200078e3cffULL, 0x0000001b041b7220ULL, 0x000fe20000410000ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x00000004071f7812ULL, 0x000fe200078e3cffULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x0000001604167220ULL, 0x000fc40000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001a1919723eULL, 0x000fe200000000ffULL,
0x0000000e040e7220ULL, 0x040fe40000410000ULL, 0x0000000d040d7220ULL, 0x040fe20000410000ULL,
0x000000161515723eULL, 0x000fe200000000ffULL, 0x0000001104117220ULL, 0x040fe40000410000ULL,
0x0000001004047220ULL, 0x000fe20000410000ULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x0000000c050c7220ULL, 0x008fc40000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x000000110404723eULL, 0x000fe200000000ffULL, 0x0000002a052a7220ULL, 0x000fe20000410000ULL,
0x0000000307117812ULL, 0x000fe200078e3cffULL, 0x0000002905297220ULL, 0x000fe20000410000ULL,
0x0000000c210c723eULL, 0x000fe200000000ffULL, 0x0000002005207220ULL, 0x000fe20000410000ULL,
0x0000000507217812ULL, 0x000fe200078e3cffULL, 0x0000001d051d7220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000002805287220ULL, 0x000fc40000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x000000201d1d723eULL, 0x000fe200000000ffULL,
0x0000000f050f7220ULL, 0x040fe40000410000ULL, 0x0000001805187220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000001705177220ULL, 0x040fe40000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000000f180f723eULL, 0x000fe200000000ffULL,
0x0000001405147220ULL, 0x000fc40000410000ULL, 0x0000001305137220ULL, 0x040fe20000410000ULL,
0x000000172617723eULL, 0x000fe200000000ffULL, 0x0000001205127220ULL, 0x040fe40000410000ULL,
0x0000000b05057220ULL, 0x000fe20000410000ULL, 0x00000002070b7812ULL, 0x000fe200078e3cffULL,
0x0000000808077824ULL, 0x040fe200078e0209ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000000833107824ULL, 0x000fe200078e00ffULL, 0x000000120505723eULL, 0x000fe200000000ffULL,
0x0000000808097824ULL, 0x040fe200078e020bULL, 0x0000000733127812ULL, 0x000fe200078ec0ffULL,
0x00000008080b7824ULL, 0x000fe200078e0211ULL, 0xfffffff810357812ULL, 0x000fe200078ee235ULL,
0x0000000808117824ULL, 0x000fe200078e021fULL, 0x00000004120e7812ULL, 0x000fe200078e3cffULL,
0x00000008081f7824ULL, 0x000fe200078e0221ULL, 0x0000000512107812ULL, 0x000fe200078e3cffULL,
0x0000000808217824ULL, 0x000fe200078e0223ULL, 0xfffffff80a237812ULL, 0x000fe200078ee233ULL,
0x0000000406147824ULL, 0x000fe200078e00ffULL, 0x0000000112067812ULL, 0x040fe200078e3cffULL,
0x0000001003037824ULL, 0x000fe200078e0202ULL, 0x0000000212087812ULL, 0x040fe200078e3cffULL,
0x00000008332f7824ULL, 0x040fe200078e020eULL, 0x00000003120a7812ULL, 0x040fe200078e3cffULL,
0x0000000833257824ULL, 0x040fe200078e0206ULL, 0x0000000612127812ULL, 0x000fe200078e3cffULL,
0x00000008332b7824ULL, 0x040fe200078e0208ULL, 0x0000000c14187812ULL, 0x000fe200078ec0ffULL,
0x00000008332d7824ULL, 0x000fc400078e020aULL, 0x0000000833317824ULL, 0x000fe400078e0210ULL,
0x0000001007077824ULL, 0x000fe400078e0202ULL, 0x0000000833337824ULL, 0x000fe400078e0212ULL,
0x0000001009097824ULL, 0x100fe400078e0202ULL, 0x0000001037067824ULL, 0x100fe400078e0202ULL,
0x000000100b0b7824ULL, 0x000fc400078e0202ULL, 0x0000001023087824ULL, 0x100fe400078e0202ULL,
0x0000000118037824ULL, 0x040fe400078e0203ULL, 0x0000001011117824ULL, 0x100fe400078e0202ULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x0000002403007388ULL, 0x0003e20000000800ULL,
0x0000000118077824ULL, 0x000fe400078e0207ULL, 0x0000001035357824ULL, 0x000fc400078e0202ULL,
0x0000001021217824ULL, 0x100fe200078e0202ULL, 0x0000002207007388ULL, 0x0003e20000000800ULL,
0x00000010250e7824ULL, 0x100fe400078e0202ULL, 0x000000102b2b7824ULL, 0x100fe400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe400078e0202ULL, 0x000000102f2f7824ULL, 0x100fe400078e0202ULL,
0x0000001031317824ULL, 0x000fc400078e0202ULL, 0x0000001033337824ULL, 0x000fe400078e0202ULL,
0x0000000118097824ULL, 0x040fe400078e0209ULL, 0x0000000118237824ULL, 0x040fe400078e0206ULL,
0x0000000118027824ULL, 0x040fe200078e020bULL, 0x0000001e09007388ULL, 0x0003e20000000800ULL,
0x0000000118257824ULL, 0x040fe400078e0208ULL, 0x0000000118067824ULL, 0x040fe200078e0211ULL,
0x0000001b02007388ULL, 0x0003e20000000800ULL, 0x0000000118087824ULL, 0x000fc400078e021fULL,
0x00000001180a7824ULL, 0x040fe200078e0221ULL, 0x0000001906007388ULL, 0x0003e20000000800ULL,
0x00000001180e7824ULL, 0x040fe400078e020eULL, 0x0000000118107824ULL, 0x040fe200078e022bULL,
0x0000001508007388ULL, 0x0003e20000000800ULL, 0x0000000118127824ULL, 0x040fe400078e022dULL,
0x0000000118147824ULL, 0x040fe200078e022fULL, 0x0000000d0a007388ULL, 0x0003e20000000800ULL,
0x00000001181a7824ULL, 0x000fc400078e0235ULL, 0x0000000118167824ULL, 0x040fe200078e0231ULL,
0x0000000423007388ULL, 0x0003e20000000800ULL, 0x0000000118187824ULL, 0x000fc600078e0233ULL,
0x0000000c25007388ULL, 0x0003e80000000800ULL, 0x000000290e007388ULL, 0x0003e80000000800ULL,
0x0000001d10007388ULL, 0x0003e80000000800ULL, 0x0000002712007388ULL, 0x0003e80000000800ULL,
0x0000000f14007388ULL, 0x0003e80000000800ULL, 0x0000001716007388ULL, 0x0003e80000000800ULL,
0x0000001318007388ULL, 0x0003e80000000800ULL, 0x000000051a007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000001b7919ULL, 0x006e620000000000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x0000580000057ab9ULL, 0x000fe20000000800ULL,
0x000000084c4c7824ULL, 0x000fe200078e00ffULL, 0x0000000000187919ULL, 0x000f220000002600ULL,
0x0000000405057899ULL, 0x000fc6000800063fULL, 0x1ffffff84c4c7812ULL, 0x000fe400078ec0ffULL,
0x000000201b1d7810ULL, 0x042fe20007ffe0ffULL, 0x00000004050472a4ULL, 0x004fe2000f8e023fULL,
0x000000401b1f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001018037824ULL, 0x050fe200078e00ffULL,
0x00000003ff027819ULL, 0x000fe2000001161bULL, 0x0000001018197824ULL, 0x008fe200078e00ffULL,
0x000000601b217810ULL, 0x000fe40007ffe0ffULL, 0x00000003ff157819ULL, 0x000fc4000001161dULL,
0x00000003ff167819ULL, 0x000fe4000001161fULL, 0xfffffff003147812ULL, 0x000fe400078ee202ULL,
0x00000003ff177819ULL, 0x000fe40000011621ULL, 0x0000000702027812ULL, 0x000fe400078e481bULL,
0x0000000715047812ULL, 0x000fe400078e481dULL, 0x0000000716067812ULL, 0x000fc400078e481fULL,
0x0000000717087812ULL, 0x000fe400078e4821ULL, 0x0ffffff802037812ULL, 0x000fe400078ef81bULL,
0x0ffffff804057812ULL, 0x000fe400078ef81dULL, 0x0ffffff806077812ULL, 0x000fe200078ef81fULL,
0x0000001003047824ULL, 0x100fe200078e0200ULL, 0x0ffffff808097812ULL, 0x000fe200078ef821ULL,
0x0000001005087824ULL, 0x100fe200078e0200ULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x00000010070c7824ULL, 0x000fe200078e0200ULL, 0xfffffff019167812ULL, 0x000fe200078ee216ULL,
0x0000001009107824ULL, 0x000fe200078e0200ULL, 0x0120000004047984ULL, 0x000e620000000c00ULL,
0x0000001018007824ULL, 0x000fe200078e00ffULL, 0x00000004161a7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x0120000008087984ULL, 0x000ea20000000c00ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005a0014027a11ULL, 0x000fc400078048ffULL,
0x012000000c0c7984ULL, 0x000ee20000000c00ULL, 0xfffffff000157812ULL, 0x000fe400078ee215ULL,
0xfffffff018177812ULL, 0x000fe200078ee217ULL, 0x0120000010107984ULL, 0x000f220000000c00ULL,
0x00005b0014037a11ULL, 0x000fe400000f4c03ULL, 0x0000000415157c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000417007c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005a001a167a11ULL, 0x000fe200078248ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005a0015147a11ULL, 0x000fe200078048ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005a0000187a11ULL, 0x000fc400078448ffULL, 0x000000074c1b7812ULL, 0x040fe400078ef81bULL,
0x000000074c1d7812ULL, 0x040fe400078ef81dULL, 0x00005b0015157a11ULL, 0x000fe200000f4c1cULL,
0x000000101b027825ULL, 0x000fe200078e0002ULL, 0x000000074c1f7812ULL, 0x000fe400078ef81fULL,
0x00005b001a177a11ULL, 0x000fe200008f4c17ULL, 0x000000101d147825ULL, 0x000fe200078e0014ULL,
0x000000074c217812ULL, 0x000fc400078ef821ULL, 0x00005b0000197a11ULL, 0x000fe200010f4c19ULL,
0x000000101f167825ULL, 0x000fe200078e0016ULL, 0x0000000402007986ULL, 0x002fe6000c101d06ULL,
0x0000001021187825ULL, 0x000fe200078e0018ULL, 0x0000000814007986ULL, 0x004fe8000c101d06ULL,
0x0000000c16007986ULL, 0x008fe8000c101d06ULL, 0x0000001018007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff327624ULL, 0x000fe400078e00ffULL,
0x00006700ff337624ULL, 0x000fca00078e00ffULL, 0x0000000632327981ULL, 0x000362000c1e9900ULL,
0x000000014d037810ULL, 0x000fe20007ffe0ffULL, 0x0000000214147824ULL, 0x000fe400078e00ffULL,
0x000000404c307824ULL, 0x000fe200078e00ffULL, 0x000000020300720cULL, 0x000fe20003f06070ULL,
0x0000580014037a24ULL, 0x000fe400078e0215ULL, 0x000001004d0a7824ULL, 0x000fc800078e0230ULL,
0x0000620003047a24ULL, 0x000fcc00078e020aULL, 0x00000ba000008947ULL, 0x000fea0003800000ULL,
0x0000000000277919ULL, 0x002e620000000000ULL, 0x0000000a00057217ULL, 0x000fe20007800000ULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x000020004c1a7811ULL, 0x000fc600078e70ffULL,
0x0000000105057824ULL, 0x000fe200078e0a0aULL, 0x00000003ff227819ULL, 0x002fe20000011627ULL,
0x00000010270d7824ULL, 0x000fc600078e00ffULL, 0x0000000422087810ULL, 0x040fe40007ffe0ffULL,
0x0000000822097810ULL, 0x000fe40007ffe0ffULL, 0x0000002708067212ULL, 0x0c0fe200078e3cffULL,
0x0000000808197824ULL, 0x000fe200078e00ffULL, 0x0000000c220a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008090c7824ULL, 0x040fe200078e00ffULL, 0x0000002709077212ULL, 0x080fe400078e3cffULL,
0xfffffff819197812ULL, 0x000fe200078ee206ULL, 0x0000000122067824ULL, 0x000fe200078e0204ULL,
0xfffffff80c1f7812ULL, 0x000fe200078ee207ULL, 0x000000080a0e7824ULL, 0x040fe200078e00ffULL,
0x000000270a0b7212ULL, 0x000fe200078e3cffULL, 0x00005e0006067625ULL, 0x000fe200078e0029ULL,
0x000000700d2b7812ULL, 0x000fc400078ec0ffULL, 0xfffffff80e217812ULL, 0x000fe200078ee20bULL,
0x00000010191d7824ULL, 0x100fe200078e021aULL, 0x00000010220c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x000000062b0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000104067824ULL, 0x000fe200078e0208ULL, 0x000000270c0b7212ULL, 0x040fe200078e3cffULL,
0x000000080c107824ULL, 0x000fe200078e00ffULL, 0x000000050900720cULL, 0x080fe20003f46070ULL,
0x000000ffff0f7224ULL, 0x000fe200000e0607ULL, 0x000000050800720cULL, 0x000fe20003f86070ULL,
0x00005e0006067625ULL, 0x000fe200078e0029ULL, 0xfffffff810237812ULL, 0x000fc400078ee20bULL,
0x000000050a00720cULL, 0x000fe20003f66070ULL, 0x0000000104097824ULL, 0x040fe200078e0209ULL,
0x000000062b107210ULL, 0x000fe20007f3e0ffULL, 0x00000001040a7824ULL, 0x000fe200078e020aULL,
0x0000001422167810ULL, 0x000fe20007ffe0ffULL, 0x00005e0009087625ULL, 0x000fe200078e0029ULL,
0x000000050c00720cULL, 0x000fe40003f06070ULL, 0x0000000722187812ULL, 0x000fe200078e4827ULL,
0x000000ffff117224ULL, 0x000fe200008e0607ULL, 0x000000082b127210ULL, 0x000fe20007f3e0ffULL,
0x00000001040b7824ULL, 0x000fe200078e020cULL, 0x0000001c221e7810ULL, 0x000fe20007ffe0ffULL,
0x00005e000a067625ULL, 0x000fe200078e0029ULL, 0x0000002716087212ULL, 0x000fc400078e3cffULL,
0x0ffffff8181b7812ULL, 0x000fe200078ef827ULL, 0x00000001040c7824ULL, 0x000fe200078e0216ULL,
0x0000002022207810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0609ULL,
0x0000001822097810ULL, 0x000fe20007ffe0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0029ULL,
0x000000062b147210ULL, 0x000fe40007f3e0ffULL, 0x00000027091c7212ULL, 0x000fe200078e3cffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0029ULL, 0x0000000a2b0a7210ULL, 0x000fc60007fbe0ffULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000000c2b0c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0607ULL, 0x000000051600720cULL, 0x000fe20003f26070ULL,
0x00005e0006067625ULL, 0x000fc800078e0029ULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x000000052200720cULL, 0x000fe20003fa6070ULL, 0x000000ffff0d7224ULL, 0x000fe400030e060dULL,
0x0000000816257824ULL, 0x000fe200078e00ffULL, 0x000000062b167210ULL, 0x000fe20007fde0ffULL,
0x0000000104067824ULL, 0x000fe400078e021eULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0xfffffff825257812ULL, 0x000fe200078ee208ULL, 0x000000ffff177224ULL, 0x000fc400030e0607ULL,
0x00005e0006067625ULL, 0x000fe400078e0029ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1b7faeULL, 0x0003e2000e901c46ULL, 0x000000050900720cULL, 0x000fe20003fa6070ULL,
0x0000001021217824ULL, 0x000fe200078e021aULL, 0x000000062b187210ULL, 0x000fe20007fde0ffULL,
0x0000000104087824ULL, 0x000fe200078e0220ULL, 0x00000000101d7faeULL, 0x0005e2000e101c46ULL,
0x000000271e067212ULL, 0x040fe200078e3cffULL, 0x00000008092d7824ULL, 0x000fe200078e00ffULL,
0x000000051e00720cULL, 0x000fe20003f86070ULL, 0x00000000121f7faeULL, 0x0007e2000d101c46ULL,
0x00005e0008087625ULL, 0x000fe200078e0029ULL, 0x00000024220e7810ULL, 0x002fc40007ffe0ffULL,
0x0000000014217faeULL, 0x0003e2000d901c46ULL, 0x000000081e1b7824ULL, 0x000fe200078e00ffULL,
0x000000052000720cULL, 0x040fe20003f66070ULL, 0x000000ffff197224ULL, 0x000fe200030e0607ULL,
0x00000027200f7212ULL, 0x040fe200078e3cffULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000000104067824ULL, 0x000fe200078e020eULL,
0xfffffff82d117812ULL, 0x004fe200078ee21cULL, 0x0000001023237824ULL, 0x000fe200078e021aULL,
0x000000082b087210ULL, 0x000fe20007fde0ffULL, 0x00005e0006067625ULL, 0x000fe200078e0029ULL,
0xfffffff820137812ULL, 0x008fc400078ee20fULL, 0x000000050e00720cULL, 0x040fe20003f46070ULL,
0x0000001025257824ULL, 0x100fe200078e021aULL, 0x000000270e107212ULL, 0x000fe200078e3cffULL,
0x0000001011117824ULL, 0x100fe200078e021aULL, 0x000000000a237faeULL, 0x0005e2000c101c46ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000003022127810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1d7824ULL, 0x000fe200078e00ffULL, 0x000000062b0e7210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x0000002822067810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e021aULL, 0x000000000c257faeULL, 0x0007e2000c901c46ULL,
0xfffffff81d157812ULL, 0x002fe200078ee210ULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x000000050600720cULL, 0x040fe20003fc6070ULL, 0x0000000016117faeULL, 0x0003e2000e901c46ULL,
0x0000002706077212ULL, 0x000fe200078e3cffULL, 0x0000001015157824ULL, 0x000fe200078e021aULL,
0x0000002c22107810ULL, 0x040fe20007ffe0ffULL, 0x00000000181b7faeULL, 0x0009e2000e101c46ULL,
0x0000003422147810ULL, 0x000fc40007ffe0ffULL, 0x00000038221c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000008137faeULL, 0x0003e2000d901c46ULL, 0x0000003c221d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001040c7824ULL, 0x008fe200078e0212ULL, 0x000000051200720cULL, 0x040fe20003f86070ULL,
0x000000000e157faeULL, 0x0007e2000d101c46ULL, 0x00000027120b7212ULL, 0x044fe200078e3cffULL,
0x0000000812127824ULL, 0x000fe200078e00ffULL, 0x000000051000720cULL, 0x080fe20003fa6070ULL,
0x000000081c197824ULL, 0x010fe200078e00ffULL, 0x000000051400720cULL, 0x080fe20003f66070ULL,
0x000000081d1b7824ULL, 0x040fe200078e00ffULL, 0x000000051c00720cULL, 0x080fe20003f26070ULL,
0x0000000806087824ULL, 0x002fe200078e00ffULL, 0x000000051d00720cULL, 0x000fe20003f06070ULL,
0x0000000104067824ULL, 0x000fe200078e0206ULL, 0x0000002710057212ULL, 0x000fc400078e3cffULL,
0xfffffff808117812ULL, 0x000fe200078ee207ULL, 0x00005e0006067625ULL, 0x000fe200078e0029ULL,
0xfffffff812157812ULL, 0x008fc600078ee20bULL, 0x0000000104087824ULL, 0x000fe200078e0210ULL,
0x000000062b0a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000810107824ULL, 0x000fe400078e00ffULL,
0x00005e0008087625ULL, 0x000fc600078e0029ULL, 0xfffffff810137812ULL, 0x000fe200078ee205ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0607ULL, 0x0000002714057212ULL, 0x000fe200078e3cffULL,
0x00005e000c067625ULL, 0x000fe200078e0029ULL, 0x000000082b0c7210ULL, 0x000fc60007f5e0ffULL,
0x0000000814107824ULL, 0x000fe400078e00ffULL, 0x0000000104087824ULL, 0x000fe400078e0214ULL,
0x000000ffff0d7224ULL, 0x000fe200010e0609ULL, 0x000000062b0e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0029ULL, 0xfffffff810177812ULL, 0x000fe400078ee205ULL,
0x000000271c067212ULL, 0x080fe200078e3cffULL, 0x0000000104057824ULL, 0x040fe200078e021cULL,
0x000000271d107212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200010e0607ULL,
0x000000082b087210ULL, 0x000fe20007f5e0ffULL, 0x0000000104077824ULL, 0x000fe200078e021dULL,
0xfffffff819197812ULL, 0x000fe200078ee206ULL, 0x00005e0005047625ULL, 0x000fe200078e0029ULL,
0xfffffff81b1b7812ULL, 0x000fc600078ee210ULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x000000042b047210ULL, 0x000fe20007f5e0ffULL, 0x00005e0007067625ULL, 0x000fc800078e0029ULL,
0x000000ffff057224ULL, 0x000fe200010e0605ULL, 0x000000062b067210ULL, 0x000fe20007f5e0ffULL,
0x0000001011117824ULL, 0x100fe400078e021aULL, 0x0000001013137824ULL, 0x100fe400078e021aULL,
0x0000001015157824ULL, 0x100fe200078e021aULL, 0x000000000a117faeULL, 0x0003e2000f101c46ULL,
0x0000001017177824ULL, 0x100fe400078e021aULL, 0x0000001019197824ULL, 0x100fe200078e021aULL,
0x000000000c137faeULL, 0x0003e2000e901c46ULL, 0x000000101b1b7824ULL, 0x000fc400078e021aULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x000000000e157faeULL, 0x0003e8000e101c46ULL,
0x0000000008177faeULL, 0x0003e8000d901c46ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x00000000061b7faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x002e620000000000ULL, 0x00000100ff227424ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x002fc80000011606ULL, 0x00000004050b7810ULL, 0x040fe40007ffe0ffULL,
0x00000008050f7810ULL, 0x000fe40007ffe0ffULL, 0x000000060b077212ULL, 0x040fe200078e3cffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x00000014051b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0a7824ULL, 0x000fe200078e00ffULL, 0x0000001005177810ULL, 0x000fe20007ffe0ffULL,
0x00000001040b7824ULL, 0x000fe200078e020bULL, 0xfffffff8080d7812ULL, 0x000fc400078ee207ULL,
0x000000060f077212ULL, 0x080fe200078e3cffULL, 0x00000008170c7824ULL, 0x000fe200078e00ffULL,
0x0000002005277810ULL, 0x000fe20007ffe0ffULL, 0x00000001040f7824ULL, 0x000fe200078e020fULL,
0xfffffff80a117812ULL, 0x000fe200078ee207ULL, 0x000000081b0a7824ULL, 0x040fe200078e00ffULL,
0x000000061b077212ULL, 0x080fe200078e3cffULL, 0x00000001041b7824ULL, 0x040fe200078e021bULL,
0x0000000617097212ULL, 0x000fe200078e3cffULL, 0x0000000104177824ULL, 0x040fe200078e0217ULL,
0x0000001c05237810ULL, 0x040fe20007ffe0ffULL, 0x0000000104377824ULL, 0x000fe200078e0227ULL,
0x0000000c05137810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80a1d7812ULL, 0x000fe200078ee207ULL,
0x00000008270a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c197812ULL, 0x000fe200078ee209ULL,
0x00000008230c7824ULL, 0x000fe200078e00ffULL, 0x0000000627077212ULL, 0x080fe200078e3cffULL,
0x0000000813157824ULL, 0x000fe200078e00ffULL, 0x0000002c052d7810ULL, 0x040fe40007ffe0ffULL,
0x00000018051f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000623097212ULL, 0x080fe200078e3cffULL,
0x0000000104237824ULL, 0x040fe200078e0223ULL, 0x00000028052b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x0000000613087212ULL, 0x080fe200078e3cffULL,
0x0000000104137824ULL, 0x000fe200078e0213ULL, 0xfffffff80a397812ULL, 0x000fe200078ee207ULL,
0x000000082d0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c357812ULL, 0x000fe200078ee209ULL,
0x000000082b0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x00000001043f7824ULL, 0x040fe200078e022bULL, 0x0000002405297810ULL, 0x000fe20007ffe0ffULL,
0x0000000104437824ULL, 0x000fe200078e022dULL, 0x000000062d077212ULL, 0x000fc400078e3cffULL,
0x000000061f087212ULL, 0x080fe200078e3cffULL, 0x00000008293d7824ULL, 0x000fe200078e00ffULL,
0x000000062b097212ULL, 0x000fe200078e3cffULL, 0x00000001041f7824ULL, 0x040fe200078e021fULL,
0x0000003405317810ULL, 0x000fe20007ffe0ffULL, 0x00000001043b7824ULL, 0x000fe200078e0229ULL,
0xfffffff80a457812ULL, 0x000fe200078ee207ULL, 0x0000001006077824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x00000001044b7824ULL, 0x000fe200078e0231ULL,
0xfffffff80c417812ULL, 0x000fe200078ee209ULL, 0x00000008310c7824ULL, 0x000fe200078e00ffULL,
0x00000030052f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000629087212ULL, 0x080fe400078e3cffULL,
0x0000000631097212ULL, 0x080fe200078e3cffULL, 0x000000082f497824ULL, 0x000fe200078e00ffULL,
0x0000003805337810ULL, 0x040fe20007ffe0ffULL, 0x0000000104477824ULL, 0x040fe200078e022fULL,
0x0000003c05537810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL,
0x0000000104517824ULL, 0x040fe200078e0233ULL, 0x0000007007257812ULL, 0x000fe200078ec0ffULL,
0x0000000105077824ULL, 0x000fe200078e0204ULL, 0x000000062f087212ULL, 0x000fe200078e3cffULL,
0x0000000104557824ULL, 0x000fe200078e0253ULL, 0xfffffff80c4f7812ULL, 0x000fe200078ee209ULL,
0x0000000853577824ULL, 0x000fe200078e00ffULL, 0x0000000705097812ULL, 0x000fe200078e4806ULL,
0x00005e0007047625ULL, 0x000fe200078e0022ULL, 0xfffffff849497812ULL, 0x000fc400078ee208ULL,
0x0ffffff809097812ULL, 0x000fe200078ef806ULL, 0x0000000833087824ULL, 0x040fe200078e00ffULL,
0x0000000633077212ULL, 0x080fe400078e3cffULL, 0x0000000653067212ULL, 0x000fe400078e3cffULL,
0x0000000425047210ULL, 0x000fe40007f1e0ffULL, 0xfffffff808537812ULL, 0x000fe400078ee207ULL,
0xfffffff857577812ULL, 0x000fe200078ee206ULL, 0x00005e000b067625ULL, 0x000fe200078e0022ULL,
0x000020004c0c7811ULL, 0x000fc600078e70ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000000625067210ULL, 0x000fe20007f1e0ffULL, 0x0000001009277824ULL, 0x100fe400078e020cULL,
0x000000100d297824ULL, 0x100fe400078e020cULL, 0x00000010112b7824ULL, 0x100fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004277faeULL, 0x0003e2000b901c46ULL,
0x00000010152d7824ULL, 0x100fe400078e020cULL, 0x00000010192f7824ULL, 0x000fc400078e020cULL,
0x000000101d317824ULL, 0x100fe400078e020cULL, 0x0000001021337824ULL, 0x100fe400078e020cULL,
0x0000001035357824ULL, 0x100fe400078e020cULL, 0x0000001039397824ULL, 0x100fe400078e020cULL,
0x000000103d3d7824ULL, 0x100fe400078e020cULL, 0x0000001041417824ULL, 0x000fc400078e020cULL,
0x0000001045457824ULL, 0x100fe400078e020cULL, 0x0000001049497824ULL, 0x100fe400078e020cULL,
0x000000104f4f7824ULL, 0x100fe400078e020cULL, 0x0000001053537824ULL, 0x100fe400078e020cULL,
0x0000001057577824ULL, 0x000fe400078e020cULL, 0x00005e00170c7625ULL, 0x000fc800078e0022ULL,
0x00005e000f087625ULL, 0x000fc800078e0022ULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000c250c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e001f107625ULL, 0x000fe200078e0022ULL,
0x0000000825087210ULL, 0x000fe40007f3e0ffULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x00005e001b0e7625ULL, 0x000fc800078e0022ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000001025107210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff097224ULL, 0x000fe200008e0609ULL,
0x0000000e250e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e00130a7625ULL, 0x000fc600078e0022ULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0037147625ULL, 0x000fe200078e0022ULL,
0x0000000a250a7210ULL, 0x000fc60007f5e0ffULL, 0x00005e0023127625ULL, 0x000fc800078e0022ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001425147210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x0000001225127210ULL, 0x000fe20007f3e0ffULL,
0x00005e00431a7625ULL, 0x000fc800078e0022ULL, 0x00005e003b167625ULL, 0x000fc800078e0022ULL,
0x00005e003f187625ULL, 0x000fc800078e0022ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x0000001a251a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff137224ULL, 0x000fe200008e0613ULL,
0x0000001625167210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000001825187210ULL, 0x000fe20007f5e0ffULL, 0x00005e00471c7625ULL, 0x000fc600078e0022ULL,
0x000000000a2d7faeULL, 0x0003e2000b901c46ULL, 0x00005e004b1e7625ULL, 0x000fc600078e0022ULL,
0x000000000c2f7faeULL, 0x0003e2000b901c46ULL, 0x00005e0051207625ULL, 0x000fc600078e0022ULL,
0x000000000e317faeULL, 0x0003e2000b901c46ULL, 0x00005e0055227625ULL, 0x000fc600078e0022ULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000001c251c7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x0000001e251e7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000002025207210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000002225227210ULL, 0x000fe20007f7e0ffULL, 0x0000000012357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1f7224ULL, 0x000fc400008e061fULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000000014397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff237224ULL, 0x000fc600018e0623ULL,
0x00000000163d7faeULL, 0x0003e8000b901c46ULL, 0x0000000018417faeULL, 0x0003e8000b901c46ULL,
0x000000001a457faeULL, 0x0003e8000b901c46ULL, 0x000000001c497faeULL, 0x0003e8000b901c46ULL,
0x000000001e4f7faeULL, 0x0003e8000b901c46ULL, 0x0000000020537faeULL, 0x0003e8000b901c46ULL,
0x0000000022577faeULL, 0x0003e4000b901c46ULL, 0x01c60400ff047984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000004ff7812ULL, 0x002fc6000780c0ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01c60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780c0ffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000034c00780cULL, 0x000fda0003f04070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000204c047824ULL, 0x002fc800078e0205ULL,
0x0000002004067824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fc80000011604ULL,
0x1ffffffe05057812ULL, 0x000fe400078ec0ffULL, 0x000001e006067812ULL, 0x000fe400078ec0ffULL,
0x0000000105097812ULL, 0x040fe400078efcffULL, 0x0000000705077812ULL, 0x100fe400078e7804ULL,
0x0000000709097812ULL, 0x100fe400078e7804ULL, 0x00000010050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001105057810ULL, 0x000fe20007ffe0ffULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fc400078e7804ULL,
0x0000000007107984ULL, 0x000e62000000cc00ULL, 0x0000000705057812ULL, 0x000fe400078e7804ULL,
0x00000001060b7824ULL, 0x040fe200078e020bULL, 0x00000000090c7984ULL, 0x000ea4000000cc00ULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fe200078e0013ULL, 0x0000001407007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fca00078e000fULL,
0x0000001809007388ULL, 0x000fe8000000cc00ULL, 0x00000000050c7984ULL, 0x000e68000000cc00ULL,
0x000000000b107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff1f7224ULL, 0x002fe400078e000eULL,
0x000000ffff1e7224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff1c7224ULL, 0x004fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000001c0b007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e4000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c60000ffff7f8cULL, 0x000fe8000c80043fULL,
0x01c60400ff047984ULL, 0x000ea40000000800ULL, 0x8000000004ff7812ULL, 0x004fc40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0022a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01c60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007800cffULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x000000024d00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000317919ULL, 0x000ea20000000000ULL, 0x3d80000032327820ULL, 0x020fe20000410000ULL,
0xffffffff02347810ULL, 0x000fe20007ffe0ffULL, 0x000000104c337824ULL, 0x000fe200078e00ffULL,
0x00007610ff367816ULL, 0x000fe20000000036ULL, 0x000000ffff357224ULL, 0x000fe400078e00ffULL,
0x000001004d377824ULL, 0x000fe200078e0230ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000370000720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x008fea0003800000ULL,
0x000000ffff1d7224ULL, 0x002fe200078e0035ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x00000001381e7810ULL, 0x000fe20007ffe0ffULL, 0x000014e000007945ULL, 0x000fe20003800000ULL,
0x000000011d357812ULL, 0x000fc400078e0cffULL, 0x00000001ff1c7819ULL, 0x000fe4000001161eULL,
0x000000021e00780cULL, 0x040fe40003f06070ULL, 0x000000011e287812ULL, 0x000fe200078ec0ffULL,
0x000003001c1f7a24ULL, 0x000fe400078e024dULL, 0x000000ffff1c7224ULL, 0x000fe400078e0038ULL,
0x000001001f397824ULL, 0x040fe200078e0230ULL, 0x000000011f297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff387224ULL, 0x000fc400078e001eULL, 0x00006200031f7a24ULL, 0x000fe200078e0239ULL,
0x000000022900720cULL, 0x000fda0003f26070ULL, 0x00000aa000009947ULL, 0x000fea0003800000ULL,
0x00000003ff427819ULL, 0x004fe20000011631ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x00000039001e7217ULL, 0x000fe40007800000ULL, 0x00000004422e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001442407810ULL, 0x000fe20007ffe0ffULL, 0x000000011e397824ULL, 0x000fe200078e0a39ULL,
0x0000000c423c7810ULL, 0x000fe20007ffe0ffULL, 0x000000082e2a7824ULL, 0x040fe200078e00ffULL,
0x000000312e297212ULL, 0x000fe200078e3cffULL, 0x0000000840447824ULL, 0x000fe200078e00ffULL,
0x00000008423a7810ULL, 0x000fe20007ffe0ffULL, 0x000000083c2c7824ULL, 0x000fe200078e00ffULL,
0x00000010423e7810ULL, 0x000fc40007ffe0ffULL, 0x00000031402b7212ULL, 0x080fe200078e3cffULL,
0x000000083a437824ULL, 0x000fe200078e00ffULL, 0xfffffff82a417812ULL, 0x000fe200078ee229ULL,
0x000000083e477824ULL, 0x000fe200078e00ffULL, 0x000000313c297212ULL, 0x000fe400078e3cffULL,
0x0000001c42467810ULL, 0x000fe40007ffe0ffULL, 0xfffffff844497812ULL, 0x000fe400078ee22bULL,
0x0000001842447810ULL, 0x000fc40007ffe0ffULL, 0x0000002042487810ULL, 0x000fe40007ffe0ffULL,
0x000000313a1e7212ULL, 0x080fe200078e3cffULL, 0x00000008444b7824ULL, 0x000fe200078e00ffULL,
0x000000313e2a7212ULL, 0x080fe200078e3cffULL, 0x0000000848517824ULL, 0x000fe200078e00ffULL,
0xfffffff82c457812ULL, 0x000fe200078ee229ULL, 0x00000008462c7824ULL, 0x000fe200078e00ffULL,
0x00000024424a7810ULL, 0x000fe40007ffe0ffULL, 0x0000003146297212ULL, 0x000fc400078e3cffULL,
0xfffffff843437812ULL, 0x000fe200078ee21eULL, 0x000000084a4e7824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe400078ee22aULL, 0x00000031441e7212ULL, 0x080fe400078e3cffULL,
0x00000031482a7212ULL, 0x000fe400078e3cffULL, 0xfffffff82c4f7812ULL, 0x000fe200078ee229ULL,
0x00000100ff297424ULL, 0x000fe200078e00ffULL, 0x00000007422c7812ULL, 0x000fc400078e4831ULL,
0x000000314a2b7212ULL, 0x000fe400078e3cffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee21eULL,
0x000000024c1e7824ULL, 0x000fe200078e0235ULL, 0xfffffff851517812ULL, 0x000fe200078ee22aULL,
0x00000001422a7824ULL, 0x000fe200078e021fULL, 0x0ffffff82c3f7812ULL, 0x000fe200078ef831ULL,
0x000000012e2c7824ULL, 0x000fe200078e021fULL, 0x000000394200720cULL, 0x000fe40003f26070ULL,
0xfffffff84e537812ULL, 0x000fe200078ee22bULL, 0x00005e002a2a7625ULL, 0x000fe200078e0029ULL,
0x000000392e00720cULL, 0x000fc40003f46070ULL, 0x000000393a00720cULL, 0x040fe20003f66070ULL,
0x000000013a2e7824ULL, 0x000fe200078e021fULL, 0xfffffff828287812ULL, 0x000fe200078ee231ULL,
0x000000013c3a7824ULL, 0x100fe200078e021fULL, 0x000020001e1e7811ULL, 0x000fe200078e68ffULL,
0x00005e002c2c7625ULL, 0x000fe200078e0029ULL, 0x000000393c00720cULL, 0x080fe40003f86070ULL,
0x000000393e00720cULL, 0x040fe20003fa6070ULL, 0x000000013e3c7824ULL, 0x000fe400078e021fULL,
0x00005e002e2e7625ULL, 0x000fc800078e0029ULL, 0x00005e003a3a7625ULL, 0x000fc800078e0029ULL,
0x000000103f3f7824ULL, 0x000fe400078e021eULL, 0x00000010282a7825ULL, 0x000fc800078e002aULL,
0x00005e003c3c7625ULL, 0x000fe200078e0029ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a3f7faeULL, 0x0003e2000c901c46ULL, 0x000000394000720cULL, 0x000fe40003f26070ULL,
0x0000001041417824ULL, 0x000fe400078e021eULL, 0x00000010282c7825ULL, 0x000fc800078e002cULL,
0x0000001043437824ULL, 0x000fe200078e021eULL, 0x000000002c417faeULL, 0x0005e2000d101c46ULL,
0x00000010282e7825ULL, 0x000fe200078e002eULL, 0x000000394400720cULL, 0x000fc60003f46070ULL,
0x0000001045457824ULL, 0x000fe200078e021eULL, 0x000000002e437faeULL, 0x0007e2000d901c46ULL,
0x00000010283a7825ULL, 0x000fe200078e003aULL, 0x000000394600720cULL, 0x000fc60003f66070ULL,
0x0000001047477824ULL, 0x000fe200078e021eULL, 0x000000003a457faeULL, 0x0009e2000e101c46ULL,
0x00000010283c7825ULL, 0x000fe200078e003cULL, 0x000000394800720cULL, 0x000fc60003f86070ULL,
0x00000001402a7824ULL, 0x102fe200078e021fULL, 0x000000003c477faeULL, 0x0003e2000e901c46ULL,
0x00000001442c7824ULL, 0x004fe200078e021fULL, 0x000000394a00720cULL, 0x000fe20003fa6070ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0029ULL, 0x0000003442447810ULL, 0x000fc60007ffe0ffULL,
0x00000001463e7824ULL, 0x100fe200078e021fULL, 0x0000003842467810ULL, 0x000fe20007ffe0ffULL,
0x0000000148407824ULL, 0x000fe400078e021fULL, 0x00005e002c2c7625ULL, 0x000fc800078e0029ULL,
0x000000014a3c7824ULL, 0x002fe400078e021fULL, 0x00005e003e2e7625ULL, 0x008fe200078e0029ULL,
0x0000002c423e7810ULL, 0x000fc60007ffe0ffULL, 0x00005e00403a7625ULL, 0x010fe200078e0029ULL,
0x0000003042407810ULL, 0x000fc60007ffe0ffULL, 0x00000010493f7824ULL, 0x000fe400078e021eULL,
0x00000010282a7825ULL, 0x000fc800078e002aULL, 0x00005e003c3c7625ULL, 0x000fe200078e0029ULL,
0x000000002a3f7faeULL, 0x0003e6000c901c46ULL, 0x000000104b417824ULL, 0x000fe400078e021eULL,
0x00000010282c7825ULL, 0x000fc800078e002cULL, 0x000000104f437824ULL, 0x000fe200078e021eULL,
0x000000002c417faeULL, 0x0005e2000d101c46ULL, 0x00000010282e7825ULL, 0x000fe200078e002eULL,
0x00000028422a7810ULL, 0x042fe40007ffe0ffULL, 0x0000003c42427810ULL, 0x000fe20007ffe0ffULL,
0x0000001051457824ULL, 0x000fe200078e021eULL, 0x000000002e437faeULL, 0x0003e2000d901c46ULL,
0x00000010283a7825ULL, 0x000fe200078e003aULL, 0x000000392a00720cULL, 0x080fe40003f26070ULL,
0x000000393e00720cULL, 0x000fe20003f46070ULL, 0x00000010532b7824ULL, 0x000fe200078e021eULL,
0x000000003a457faeULL, 0x0007e2000e101c46ULL, 0x00000010283c7825ULL, 0x000fe200078e003cULL,
0x000000312a2c7212ULL, 0x004fc400078e3cffULL, 0x000000394000720cULL, 0x080fe20003f66070ULL,
0x000000082a2d7824ULL, 0x000fe200078e00ffULL, 0x000000003c2b7faeULL, 0x0005e2000e901c46ULL,
0x000000083e2e7824ULL, 0x002fe200078e00ffULL, 0x000000394400720cULL, 0x080fe20003f86070ULL,
0x000000012a2a7824ULL, 0x100fe200078e021fULL, 0x000000394600720cULL, 0x080fe40003fa6070ULL,
0x000000394200720cULL, 0x000fe20003fc6070ULL, 0x00000001443a7824ULL, 0x108fe200078e021fULL,
0xfffffff82d397812ULL, 0x000fe200078ee22cULL, 0x000000013e2c7824ULL, 0x100fe200078e021fULL,
0x00000031442d7212ULL, 0x0c0fe200078e3cffULL, 0x0000000844447824ULL, 0x000fe200078e00ffULL,
0x000000313e2b7212ULL, 0x084fe200078e3cffULL, 0x00000001423e7824ULL, 0x040fe200078e021fULL,
0x00000031422f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0xfffffff82e417812ULL, 0x000fe200078ee22bULL, 0x00000001402e7824ULL, 0x040fe200078e021fULL,
0x00000031402b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0xfffffff844457812ULL, 0x000fe200078ee22dULL, 0x00000001463c7824ULL, 0x040fe200078e021fULL,
0x00000031461f7212ULL, 0x040fe200078e3cffULL, 0x0000000846467824ULL, 0x000fe200078e00ffULL,
0xfffffff840437812ULL, 0x000fe200078ee22bULL, 0x00005e002a2a7625ULL, 0x000fe200078e0029ULL,
0xfffffff842497812ULL, 0x000fc400078ee22fULL, 0xfffffff846477812ULL, 0x000fe200078ee21fULL,
0x00005e002c2c7625ULL, 0x000fc800078e0029ULL, 0x00005e002e2e7625ULL, 0x000fc800078e0029ULL,
0x00005e003a3a7625ULL, 0x000fc800078e0029ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0029ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0029ULL, 0x00000010282a7825ULL, 0x000fc800078e002aULL,
0x00000010391f7824ULL, 0x000fe400078e021eULL, 0x00000010282c7825ULL, 0x000fc600078e002cULL,
0x000000002a1f7faeULL, 0x0003e2000c901c46ULL, 0x0000001041297824ULL, 0x000fe400078e021eULL,
0x00000010282e7825ULL, 0x000fc600078e002eULL, 0x000000002c297faeULL, 0x0003e2000d101c46ULL,
0x0000001043397824ULL, 0x000fe400078e021eULL, 0x00000010283a7825ULL, 0x000fc600078e003aULL,
0x000000002e397faeULL, 0x0003e2000d901c46ULL, 0x0000001045417824ULL, 0x000fe400078e021eULL,
0x00000010283c7825ULL, 0x000fc600078e003cULL, 0x000000003a417faeULL, 0x0003e2000e101c46ULL,
0x0000001047437824ULL, 0x000fe400078e021eULL, 0x00000010283e7825ULL, 0x000fc600078e003eULL,
0x000000003c437faeULL, 0x0003e2000e901c46ULL, 0x0000001049457824ULL, 0x000fca00078e021eULL,
0x000000003e457faeULL, 0x0003e2000f101c46ULL, 0x0000097000007947ULL, 0x000fea0003800000ULL,
0x00000003ff1e7819ULL, 0x004fe20000011631ULL, 0x0000000828287824ULL, 0x000fe400078e00ffULL,
0x000000024c3d7824ULL, 0x000fe200078e0235ULL, 0x000000041e427810ULL, 0x040fe20007ffe0ffULL,
0x00000100ff5d7424ULL, 0x000fe200078e00ffULL, 0x000000081e447810ULL, 0x000fe40007ffe0ffULL,
0x00000031422a7212ULL, 0x040fe200078e3cffULL, 0x0000000842297824ULL, 0x000fe200078e00ffULL,
0x000000141e4a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008442b7824ULL, 0x000fe200078e00ffULL,
0x0000000c1e467810ULL, 0x000fe20007ffe0ffULL, 0x0000000142427824ULL, 0x000fe200078e021fULL,
0x000000101e487810ULL, 0x000fc40007ffe0ffULL, 0x00000031442c7212ULL, 0x080fe200078e3cffULL,
0x00000008462e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8292a7812ULL, 0x000fe200078ee22aULL,
0x000000084a297824ULL, 0x000fe200078e00ffULL, 0x0000001c1e507810ULL, 0x000fe20007ffe0ffULL,
0x00000008483c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2c7812ULL, 0x000fe200078ee22cULL,
0x0000000144447824ULL, 0x100fe200078e021fULL, 0x000000314a3a7212ULL, 0x080fe200078e3cffULL,
0x00000008503e7824ULL, 0x000fe200078e00ffULL, 0x000000201e527810ULL, 0x000fe20007ffe0ffULL,
0x000000014a4a7824ULL, 0x100fe200078e021fULL, 0x00000031462b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000146467824ULL, 0x100fe200078e021fULL, 0x00000031483b7212ULL, 0x040fe200078e3cffULL,
0x0000000148487824ULL, 0x000fe200078e021fULL, 0x000000181e4e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8293a7812ULL, 0x000fe200078ee23aULL, 0x0000000852297824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2b7812ULL, 0x000fe400078ee22bULL, 0xfffffff83c3b7812ULL, 0x000fe200078ee23bULL,
0x000000084e3c7824ULL, 0x000fe200078e00ffULL, 0x00000031502f7212ULL, 0x0c0fe200078e3cffULL,
0x0000000150507824ULL, 0x100fe200078e021fULL, 0x000000241e547810ULL, 0x000fe40007ffe0ffULL,
0x00000031522e7212ULL, 0x040fe200078e3cffULL, 0x0000000152527824ULL, 0x000fe200078e021fULL,
0x000000281e567810ULL, 0x000fc40007ffe0ffULL, 0x000000314e397212ULL, 0x0c0fe200078e3cffULL,
0x000000014e4e7824ULL, 0x000fe200078e021fULL, 0xfffffff83e2f7812ULL, 0x000fe200078ee22fULL,
0x00000008543e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8292e7812ULL, 0x000fe200078ee22eULL,
0x0000000856297824ULL, 0x000fe200078e00ffULL, 0x0000002c1e587810ULL, 0x000fe40007ffe0ffULL,
0xfffffff83c397812ULL, 0x000fe400078ee239ULL, 0x00000031542d7212ULL, 0x080fe200078e3cffULL,
0x00000008583f7824ULL, 0x000fe200078e00ffULL, 0x00000031563c7212ULL, 0x000fe200078e3cffULL,
0x0000000154547824ULL, 0x100fe200078e021fULL, 0x000000301e5a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000156567824ULL, 0x000fe200078e021fULL, 0x000000341e5e7810ULL, 0x000fc40007ffe0ffULL,
0x000000381e607810ULL, 0x000fe20007ffe0ffULL, 0x000000015a5c7824ULL, 0x000fe200078e021fULL,
0x0000003c1e647810ULL, 0x000fe20007ffe0ffULL, 0x000000085a687824ULL, 0x000fe200078e00ffULL,
0xfffffff828417812ULL, 0x000fe200078ee231ULL, 0x000000011e287824ULL, 0x000fe200078e021fULL,
0xfffffff83e2d7812ULL, 0x000fe200078ee22dULL, 0x0000000160627824ULL, 0x100fe200078e021fULL,
0x0000003158407212ULL, 0x0c0fe200078e3cffULL, 0x0000000158587824ULL, 0x100fe200078e021fULL,
0xfffffff8293c7812ULL, 0x000fe200078ee23cULL, 0x0000000164667824ULL, 0x000fe200078e021fULL,
0x000000071e3e7812ULL, 0x000fe200078e4831ULL, 0x0000000860457824ULL, 0x000fe200078e00ffULL,
0x000000315a297212ULL, 0x000fe200078e3cffULL, 0x000000015e5a7824ULL, 0x000fe200078e021fULL,
0xfffffff83f407812ULL, 0x000fe200078ee240ULL, 0x00005e00281e7625ULL, 0x000fe200078e005dULL,
0x000020003d3d7811ULL, 0x000fc400078e68ffULL, 0x0ffffff83e3e7812ULL, 0x000fe200078ef831ULL,
0x000000085e6a7824ULL, 0x000fe200078e00ffULL, 0x0000003160287212ULL, 0x080fe200078e3cffULL,
0x00000008646c7824ULL, 0x000fe200078e00ffULL, 0x000000315e3f7212ULL, 0x080fe200078e3cffULL,
0x000000103e557824ULL, 0x000fe200078e023dULL, 0x0000003164437212ULL, 0x000fe200078e3cffULL,
0x00000010411e7825ULL, 0x000fe200078e001eULL, 0xfffffff8685e7812ULL, 0x000fe400078ee229ULL,
0xfffffff845647812ULL, 0x000fe200078ee228ULL, 0x00005e0042287625ULL, 0x080fe200078e005dULL,
0xfffffff86a607812ULL, 0x000fe200078ee23fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e557faeULL, 0x0003e2000b901c46ULL, 0xfffffff86c687812ULL, 0x000fe200078ee243ULL,
0x00005e00443e7625ULL, 0x000fc800078e005dULL, 0x00005e0046427625ULL, 0x000fc800078e005dULL,
0x00005e0048447625ULL, 0x000fc800078e005dULL, 0x00005e004a467625ULL, 0x000fc800078e005dULL,
0x00005e004e487625ULL, 0x000fc800078e005dULL, 0x00005e00504a7625ULL, 0x000fc800078e005dULL,
0x00005e0054507625ULL, 0x000fc800078e005dULL, 0x00000010411e7825ULL, 0x002fc800078e0028ULL,
0x00005e00524e7625ULL, 0x000fc800078e005dULL, 0x00005e0058547625ULL, 0x000fc800078e005dULL,
0x0000001041287825ULL, 0x000fc800078e003eULL, 0x00005e0056527625ULL, 0x000fc800078e005dULL,
0x00005e005a587625ULL, 0x000fc800078e005dULL, 0x00000010413e7825ULL, 0x000fc800078e0042ULL,
0x00005e005c567625ULL, 0x000fc800078e005dULL, 0x00005e00625a7625ULL, 0x000fc800078e005dULL,
0x0000001041427825ULL, 0x000fc800078e0044ULL, 0x00005e00665c7625ULL, 0x000fc800078e005dULL,
0x0000001041447825ULL, 0x000fc800078e0046ULL, 0x0000001041467825ULL, 0x000fc800078e0048ULL,
0x0000001041487825ULL, 0x000fc800078e004aULL, 0x00000010414a7825ULL, 0x000fc800078e004eULL,
0x00000010414e7825ULL, 0x000fc800078e0050ULL, 0x0000001041507825ULL, 0x000fc800078e0052ULL,
0x0000001041527825ULL, 0x000fc800078e0054ULL, 0x0000001041567825ULL, 0x000fc800078e0056ULL,
0x0000001041587825ULL, 0x000fc800078e0058ULL, 0x00000010415a7825ULL, 0x000fc800078e005aULL,
0x00000010415c7825ULL, 0x000fc800078e005cULL, 0x000000102a417824ULL, 0x100fe400078e023dULL,
0x000000102c557824ULL, 0x100fe400078e023dULL, 0x000000102b2b7824ULL, 0x100fe200078e023dULL,
0x000000001e417faeULL, 0x0003e2000b901c46ULL, 0x000000103b3b7824ULL, 0x100fe400078e023dULL,
0x000000103a5f7824ULL, 0x100fe200078e023dULL, 0x0000000028557faeULL, 0x0003e2000b901c46ULL,
0x0000001039397824ULL, 0x000fc400078e023dULL, 0x000000102f2f7824ULL, 0x100fe200078e023dULL,
0x000000003e2b7faeULL, 0x0003e2000b901c46ULL, 0x000000102e617824ULL, 0x100fe400078e023dULL,
0x000000102d2d7824ULL, 0x100fe200078e023dULL, 0x00000000423b7faeULL, 0x0003e2000b901c46ULL,
0x000000103c637824ULL, 0x100fe400078e023dULL, 0x0000001040657824ULL, 0x100fe200078e023dULL,
0x00000000445f7faeULL, 0x0003e2000b901c46ULL, 0x000000105e677824ULL, 0x000fc400078e023dULL,
0x0000001060697824ULL, 0x100fe200078e023dULL, 0x0000000046397faeULL, 0x0003e2000b901c46ULL,
0x00000010646b7824ULL, 0x100fe400078e023dULL, 0x00000010683d7824ULL, 0x000fe200078e023dULL,
0x00000000482f7faeULL, 0x0003e8000b901c46ULL, 0x000000004a617faeULL, 0x0003e8000b901c46ULL,
0x000000004e2d7faeULL, 0x0003e8000b901c46ULL, 0x0000000050637faeULL, 0x0003e8000b901c46ULL,
0x0000000052657faeULL, 0x0003e8000b901c46ULL, 0x0000000056677faeULL, 0x0003e8000b901c46ULL,
0x0000000058697faeULL, 0x0003e8000b901c46ULL, 0x000000005a6b7faeULL, 0x0003e8000b901c46ULL,
0x000000005c3d7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020313e7810ULL, 0x042fe20007ffe0ffULL,
0x000000101c3a7824ULL, 0x000fe200078e00ffULL, 0x00000007311c7812ULL, 0x040fe200078ec0ffULL,
0x000000024c3d7824ULL, 0x000fe200078e021dULL, 0xfffffff8313c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fc400078ec0ffULL,
0x000020003d3d7811ULL, 0x000fe400078e68ffULL, 0x000000081c3b7812ULL, 0x100fe400078ef831ULL,
0x000000073c3c7812ULL, 0x100fe400078ef831ULL, 0x000000073e3e7812ULL, 0x000fe200078ef831ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000007391d7812ULL, 0x040fe200078e783cULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000739297812ULL, 0x040fe400078e783eULL,
0x0000000139417810ULL, 0x000fe20007ffe0ffULL, 0x000000083c1c7824ULL, 0x000fe200078e021dULL,
0x0000003a31787211ULL, 0x000fe200078fe0ffULL, 0x000000083e287824ULL, 0x000fe200078e0229ULL,
0x0000000239397810ULL, 0x000fe20007ffe0ffULL, 0x000000101c1c7824ULL, 0x100fe200078e023dULL,
0x000000043a3a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001028287824ULL, 0x000fe200078e023dULL,
0x000000083900780cULL, 0x000fc60003f25270ULL, 0x000000001c1c783bULL, 0x000e680000000200ULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x00000018ff597819ULL, 0x002fe2000001141dULL,
0x000100001d2d7824ULL, 0x040fe200078e00ffULL, 0x000088801d6c7816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001141cULL,
0x000100001c2c7824ULL, 0x040fe200078e00ffULL, 0x000088801c6b7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fc4000001141eULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801e697816ULL, 0x000fe400000000ffULL,
0x00000018ff2c7819ULL, 0x000fe2000001142cULL, 0x0000001d00767306ULL, 0x0003e20000200c00ULL,
0x00000018ff2d7819ULL, 0x000fe4000001142dULL, 0x00000018ff517819ULL, 0x004fe40000011428ULL,
0x0000888028637816ULL, 0x000fc400000000ffULL, 0x00000018ff527819ULL, 0x000fe2000001141fULL,
0x0000001c00717306ULL, 0x0005e20000200c00ULL, 0x000100001f1d7824ULL, 0x042fe200078e00ffULL,
0x000088801f677816ULL, 0x040fe200000000ffULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011429ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000002c00747306ULL, 0x000fe20000200c00ULL, 0x000100001e1c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x000001001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888029617816ULL, 0x000fc400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001d006e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x00000018ff497819ULL, 0x000fe4000001142aULL, 0x00000018ff3f7819ULL, 0x000fe4000001142bULL,
0x000088802a5d7816ULL, 0x000fe200000000ffULL, 0x0000001e00727306ULL, 0x0005e20000200c00ULL,
0x00000007411d7812ULL, 0x002fc400078e783cULL, 0x0000000741417812ULL, 0x000fe400078e783eULL,
0x000088802b4f7816ULL, 0x000fc600000000ffULL, 0x0000002d006f7306ULL, 0x0003e20000200c00ULL,
0x000000083c1e7824ULL, 0x004fe400078e021dULL, 0x00010000291d7824ULL, 0x040fe400078e00ffULL,
0x000000101e1e7824ULL, 0x000fe400078e023dULL, 0x0000010029297824ULL, 0x000fe200078e00ffULL,
0x0000001c00707306ULL, 0x0005e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000000001e2c783bULL, 0x002e640000000200ULL, 0x00000018ff297819ULL, 0x000fc80000011429ULL,
0x0000001f006d7306ULL, 0x000fe20000200c00ULL, 0x00010000281c7824ULL, 0x044fe400078e00ffULL,
0x0000010028287824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000002900657306ULL, 0x000ff00000200c00ULL,
0x00000028006a7306ULL, 0x0005f00000200c00ULL, 0x0000001c00687306ULL, 0x0007e20000200c00ULL,
0x000000083e287824ULL, 0x004fc800078e0241ULL, 0x00000010281f7824ULL, 0x000fe400078e023dULL,
0x000100002b287824ULL, 0x040fe200078e00ffULL, 0x0000001d00667306ULL, 0x0005e20000200c00ULL,
0x000100002a1c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff487819ULL, 0x002fe2000001142cULL,
0x000001002a2a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x000001002b2b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe2000001141cULL,
0x000100002d297824ULL, 0x000fe200078e00ffULL, 0x0000002800547306ULL, 0x0003e20000200c00ULL,
0x00000018ff2a7819ULL, 0x000fe2000001142aULL, 0x000000001f1c783bULL, 0x004ea20000000200ULL,
0x00000018ff2b7819ULL, 0x000fc4000001142bULL, 0x00000018ff557819ULL, 0x000fe40000011429ULL,
0x00000018ff477819ULL, 0x000fe2000001142dULL, 0x0000002a00627306ULL, 0x000fe20000200c00ULL,
0x000100002c287824ULL, 0x042fe200078e00ffULL, 0x000088802c417816ULL, 0x040fe200000000ffULL,
0x000001002c2c7824ULL, 0x000fe200078e00ffULL, 0x000088802d4e7816ULL, 0x040fe200000000ffULL,
0x000001002d2d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011428ULL,
0x0000000778287812ULL, 0x000fe200078e783bULL, 0x0000002b00567306ULL, 0x0003e20000200c00ULL,
0x00000018ff2c7819ULL, 0x000fc4000001142cULL, 0x00000018ff2d7819ULL, 0x000fe2000001142dULL,
0x000000203b287824ULL, 0x000fe200078e0228ULL, 0x00000018ff467819ULL, 0x000fe4000001142eULL,
0x00000018ff457819ULL, 0x000fe2000001142fULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000088802e577816ULL, 0x000fe400000000ffULL,
0x000088802f5a7816ULL, 0x000fe400000000ffULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000000278787810ULL, 0x000fc40007ffe0ffULL, 0x0000006b006b7306ULL, 0x000ee40000200c00ULL,
0x0000000778787812ULL, 0x000fca00078e783bULL, 0x000000203b787824ULL, 0x000fe200078e0278ULL,
0x0000002c004b7306ULL, 0x0009e20000200c00ULL, 0x00000018ff447819ULL, 0x004fe4000001141cULL,
0x00000018ff437819ULL, 0x000fe4000001141dULL, 0x00000018ff427819ULL, 0x000fe4000001141eULL,
0x00000018ff407819ULL, 0x000fe2000001141fULL, 0x0000002d00587306ULL, 0x0005e20000200c00ULL,
0x000100002e2c7824ULL, 0x010fc400078e00ffULL, 0x000001002e2e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x0000006c006c7306ULL, 0x000f220000200c00ULL,
0x000100002f2d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff2e7819ULL, 0x000fe2000001142eULL,
0x000001002f2f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff2d7819ULL, 0x000fe4000001142dULL,
0x0000002c005c7306ULL, 0x0007e20000200c00ULL, 0x00000018ff2f7819ULL, 0x000fce000001142fULL,
0x0000002d005f7306ULL, 0x0005e20000200c00ULL, 0x000054106b2c7816ULL, 0x008fce0000000074ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x00005410712d7816ULL, 0x004fe20000000064ULL,
0x000100001c647824ULL, 0x000fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000002c2824723cULL, 0x002fee0000001824ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054106c2c7816ULL, 0x010fc4000000006fULL,
0x00005410762d7816ULL, 0x000fca0000000059ULL, 0x0000005000507306ULL, 0x000f240000200c00ULL,
0x0000002c2820723cULL, 0x000fec0000001820ULL, 0x0000006700677306ULL, 0x000f620000200c00ULL,
0x00005410692c7816ULL, 0x008fe40000000070ULL, 0x00005410722d7816ULL, 0x004fc40000000053ULL,
0x000054106a697816ULL, 0x002fe20000000051ULL, 0x000001001d517824ULL, 0x000fe400078e00ffULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x010fe20000000050ULL,
0x0000002c2818723cULL, 0x000fe20000001818ULL, 0x000088801e507816ULL, 0x000fe400000000ffULL,
0x00000018ff517819ULL, 0x000fc60000011451ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x00005410676c7816ULL, 0x020fe2000000006eULL, 0x00000010782c7824ULL, 0x000fe200078e00ffULL,
0x000088801d677816ULL, 0x000fca00000000ffULL, 0x0000005200527306ULL, 0x000e700000200c00ULL,
0x0000003f003f7306ULL, 0x000ff00000200c00ULL, 0x0000006300637306ULL, 0x000ea20000200c00ULL,
0x000054106d6d7816ULL, 0x002fe20000000052ULL, 0x000000ffff527224ULL, 0x000fcc00078e0067ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000006c2814723cULL, 0x000fee0000001814ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000541063687816ULL, 0x004fce0000000068ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x000000682810723cULL, 0x000fee0000001810ULL,
0x0000002e005b7306ULL, 0x0007e20000200c00ULL, 0x000054105d607816ULL, 0x002fe20000000060ULL,
0x000100001e5d7824ULL, 0x000fc400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0000002f005e7306ULL, 0x0003e20000200c00ULL,
0x000088801c2e7816ULL, 0x008fe400000000ffULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x0000002e00597306ULL, 0x0007e20000200c00ULL, 0x000001001c2f7824ULL, 0x002fca00078e00ffULL,
0x00000018ff537819ULL, 0x000fe4000001142fULL, 0x00000064001c7306ULL, 0x0003e20000200c00ULL,
0x000000002c2c783bULL, 0x008eee0000000200ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x000100001d647824ULL, 0x002fca00078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x00000064001d7306ULL, 0x0003f00000200c00ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000541061647816ULL, 0x002fc40000000066ULL,
0x0000541062617816ULL, 0x000fe20000000049ULL, 0x000000ffff497224ULL, 0x000fe200078e0050ULL,
0x000054104f507816ULL, 0x004fc60000000054ULL, 0x0000005100667306ULL, 0x0003e20000200c00ULL,
0x00000064280c723cULL, 0x040fee000000180cULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x0000541056517816ULL, 0x002fe2000000003fULL, 0x000000602808723cULL, 0x040fec0000001808ULL,
0x0000004700477306ULL, 0x000e640000200c00ULL, 0x000000502804723cULL, 0x000fec0000001804ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000100001f2b7824ULL, 0x040fe200078e00ffULL,
0x000088801f2a7816ULL, 0x040fe200000000ffULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x000054104b4b7816ULL, 0x004fc40000000048ULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x00005410584f7816ULL, 0x002fce0000000047ULL, 0x0000002b002b7306ULL, 0x000e700000200c00ULL,
0x0000004300437306ULL, 0x000ff00000200c00ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x000054102a2a7816ULL, 0x002fce000000002bULL, 0x0000004000407306ULL, 0x000ff00000200c00ULL,
0x0000004100417306ULL, 0x000ff00000200c00ULL, 0x0000004a004a7306ULL, 0x000e700000200c00ULL,
0x0000004e004e7306ULL, 0x000ff00000200c00ULL, 0x0000005500557306ULL, 0x000ea20000200c00ULL,
0x00005410414a7816ULL, 0x002fce000000004aULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x0000004a2c24723cULL, 0x008fee0000001824ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x000054104e4e7816ULL, 0x004fce0000000055ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x00005410575c7816ULL, 0x002fe2000000005cULL, 0x0000004e2c20723cULL, 0x000fec0000001820ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000054105a5a7816ULL, 0x008fce000000005fULL,
0x0000005d00287306ULL, 0x0002e20000200c00ULL, 0x0000541052527816ULL, 0x004fce000000001dULL,
0x0000001e00297306ULL, 0x0005220000200c00ULL, 0x000054105b5d7816ULL, 0x002fe40000000046ULL,
0x000054105e5b7816ULL, 0x000fca0000000045ULL, 0x0000001f003f7306ULL, 0x0003620000200c00ULL,
0x00005410591e7816ULL, 0x004fe2000000001cULL, 0x0000005c2c18723cULL, 0x000fe20000001818ULL,
0x0000541049287816ULL, 0x008fe40000000028ULL, 0x0000541029297816ULL, 0x010fe40000000042ULL,
0x00005410531f7816ULL, 0x002fc60000000044ULL, 0x0000005a2c14723cULL, 0x000fe20000001814ULL,
0x0000541066537816ULL, 0x000fe40000000043ULL, 0x000054103f2b7816ULL, 0x020fca0000000040ULL,
0x0000001e2c10723cULL, 0x040ff00000001810ULL, 0x000000522c0c723cULL, 0x040ff0000000180cULL,
0x000000282c08723cULL, 0x040ff00000001808ULL, 0x0000002a2c04723cULL, 0x000fe20000001804ULL,
0xfffff0e000001947ULL, 0x000fee000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0035ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffdad000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x01c61400331d7984ULL, 0x000e620000000800ULL, 0x00000027322a7220ULL, 0x000fc40000410000ULL,
0x0000002132277220ULL, 0x040fe40000410000ULL, 0x0000001032217220ULL, 0x000fe20000410000ULL,
0x0000ffff36107812ULL, 0x000fe200078ec0ffULL, 0x0000000c321f7220ULL, 0x040fe40000410000ULL,
0x0000001b322f7220ULL, 0x000fe20000410000ULL, 0x00008880100c7816ULL, 0x000fe200000000ffULL,
0x00000004321b7220ULL, 0x040fe40000410000ULL, 0x00000023322c7220ULL, 0x000fc40000410000ULL,
0x800000000c047824ULL, 0x000fe400078e00ffULL, 0x0000000832087220ULL, 0x040fe40000410000ULL,
0x0000001432237220ULL, 0x040fe40000410000ULL, 0x0000001632167220ULL, 0x040fe40000410000ULL,
0x0000001732147220ULL, 0x040fe40000410000ULL, 0x0000002532297220ULL, 0x000fc40000410000ULL,
0x0000001332137220ULL, 0x040fe40000410000ULL, 0x0000002632257220ULL, 0x040fe40000410000ULL,
0x00000022322b7220ULL, 0x040fe40000410000ULL, 0x0000001a322e7220ULL, 0x040fe40000410000ULL,
0x0000000e320e7220ULL, 0x040fe40000410000ULL, 0x0000002032287220ULL, 0x000fc40000410000ULL,
0x0000001532227220ULL, 0x040fe20000410000ULL, 0x800000001dff7812ULL, 0x002fe20007804804ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0008ULL, 0x000000ffff087224ULL, 0x000fe400078e0016ULL,
0x00000024322d7220ULL, 0x040fe40000410000ULL, 0x0000001132207220ULL, 0x040fe40000410000ULL,
0x0000001232157220ULL, 0x000fc40000410000ULL, 0x000000ffff167224ULL, 0x000fe400078e0014ULL,
0x0000001832267220ULL, 0x040fe40000410000ULL, 0x0000001932247220ULL, 0x040fe40000410000ULL,
0x0000000f32127220ULL, 0x040fe40000410000ULL, 0x00000009321c7220ULL, 0x040fe40000410000ULL,
0x0000000a32117220ULL, 0x000fc40000410000ULL, 0x0000000b32107220ULL, 0x040fe40000410000ULL,
0x000000ffff147224ULL, 0x000fe400078e0013ULL, 0x0000000d321e7220ULL, 0x040fe40000410000ULL,
0x0000000532197220ULL, 0x040fe40000410000ULL, 0x00000006320f7220ULL, 0x040fe40000410000ULL,
0x0000000732077220ULL, 0x000fc40000410000ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff187224ULL, 0x000fe400078e002aULL, 0x000000ffff177224ULL, 0x000fe400078e002bULL,
0x000000ffff0b7224ULL, 0x000fe400078e002cULL, 0x000000ffff0a7224ULL, 0x000fe400078e002eULL,
0x000000ffff097224ULL, 0x000fc400078e002fULL, 0x000000ffff137224ULL, 0x000fe200078e000eULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0007ULL, 0x0000009000000947ULL, 0x000fea0003800000ULL,
0x800000000c0c7824ULL, 0x000fe400078e00ffULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400057305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000050000735dULL, 0x004fe40003800000ULL, 0x01c6140033057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc4000780480cULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004310c7824ULL, 0x000fe200078e00ffULL, 0x000000344d00720cULL, 0x000fe20003f05270ULL,
0x0000047000007945ULL, 0x000fe60003800000ULL, 0xfffffff00c0d7812ULL, 0x000fca00078ec0ffULL,
0x000000804c0d7824ULL, 0x000fca00078e020dULL, 0x01c400000d047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000231257824ULL, 0x000fe400078e00ffULL,
0x0000000100377824ULL, 0x000fc600078e0a37ULL, 0x00000006252a7812ULL, 0x000fc800078ec0ffULL,
0x000000012a2c7812ULL, 0x040fe400078efcffULL, 0x000000082a2e7812ULL, 0x000fe400078efcffULL,
0x000000372c00720cULL, 0x080fe40003f26070ULL, 0x000000102a2c7812ULL, 0x000fe400078efcffULL,
0x000000372e00720cULL, 0x080fe40003f06070ULL, 0x000000372c00720cULL, 0x000fc40003fc6070ULL,
0x000000112a2e7812ULL, 0x040fe400078efcffULL, 0x000000182a2c7812ULL, 0x040fe400078efcffULL,
0x000000372a00720cULL, 0x080fe40003f46070ULL, 0x000000372e00720cULL, 0x080fe40003fa6070ULL,
0x000000372c00720cULL, 0x000fe40003f66070ULL, 0x000000092a387812ULL, 0x000fc400078efcffULL,
0x000000192a2e7812ULL, 0x040fe400078efcffULL, 0x000000202a2c7812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40005000000ULL, 0xff7fffff2d2d7808ULL, 0x000fe40005000000ULL,
0xff7fffff18187808ULL, 0x000fe40004800000ULL, 0xff7fffff29297808ULL, 0x000fc40004800000ULL,
0x000000373800720cULL, 0x080fe40003f86070ULL, 0x000000372e00720cULL, 0x080fe40003f46070ULL,
0x000000372c00720cULL, 0x000fe40003f26070ULL, 0x000000212a2e7812ULL, 0x040fe400078efcffULL,
0x000000282a2c7812ULL, 0x000fe400078efcffULL, 0xff7fffff17177808ULL, 0x000fc40004000000ULL,
0xff7fffff28287808ULL, 0x000fe40004000000ULL, 0xff7fffff0b0b7808ULL, 0x000fe40006000000ULL,
0xff7fffff27277808ULL, 0x000fe40006000000ULL, 0x000000372e00720cULL, 0x080fe40003f06070ULL,
0x000000372c00720cULL, 0x000fe40003f86070ULL, 0x000000292a2e7812ULL, 0x000fc400078efcffULL,
0x000000302a2c7812ULL, 0x000fe400078efcffULL, 0xff7fffff0a0a7808ULL, 0x000fe40007000000ULL,
0xff7fffff26267808ULL, 0x000fe40007000000ULL, 0xff7fffff09097808ULL, 0x000fe40006800000ULL,
0xff7fffff24247808ULL, 0x000fe40006800000ULL, 0x000000372e00720cULL, 0x000fc40003fc6070ULL,
0x000000372c00720cULL, 0x000fe40003fa6070ULL, 0x000000312a2e7812ULL, 0x040fe400078efcffULL,
0x000000382a2c7812ULL, 0x040fe400078efcffULL, 0x000000392a2a7812ULL, 0x000fe400078efcffULL,
0xff7fffff08087808ULL, 0x000fe40005800000ULL, 0xff7fffff23237808ULL, 0x000fc40005800000ULL,
0xff7fffff16167808ULL, 0x000fe40005000000ULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff15157808ULL, 0x000fe40004800000ULL, 0xff7fffff21217808ULL, 0x000fe40004800000ULL,
0x000000372e00720cULL, 0x080fe40003f66070ULL, 0x000000372c00720cULL, 0x000fc40003f46070ULL,
0x000000372a00720cULL, 0x000fe40003f26070ULL, 0xff7fffff14147808ULL, 0x000fe40004000000ULL,
0xff7fffff20207808ULL, 0x000fe40004000000ULL, 0xff7fffff13137808ULL, 0x000fe40006000000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL, 0xff7fffff12127808ULL, 0x000fc40007000000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40007000000ULL, 0xff7fffff11117808ULL, 0x000fe40006800000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40006800000ULL, 0xff7fffff10107808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40005800000ULL, 0xff7fffff0f0f7808ULL, 0x000fc40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40005000000ULL, 0xff7fffff0e0e7808ULL, 0x000fe40004800000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002d04047209ULL, 0x004fe40007810000ULL, 0x0000001a05257209ULL, 0x000fe40007810000ULL,
0x0000002904057209ULL, 0x000fe40007810000ULL, 0x0000001825047209ULL, 0x000fc40007810000ULL,
0x00000028052a7209ULL, 0x000fe40007810000ULL, 0x0000001704047209ULL, 0x000fe40007810000ULL,
0x000000272a057209ULL, 0x000fe40007810000ULL, 0x0000000b04257209ULL, 0x000fe40007810000ULL,
0x0000002605057209ULL, 0x000fe40007810000ULL, 0x0000000a25047209ULL, 0x000fc40007810000ULL,
0x00000024052a7209ULL, 0x000fe40007810000ULL, 0x0000000904057209ULL, 0x000fe40007810000ULL,
0x000000232a257209ULL, 0x000fe40007810000ULL, 0x0000000805057209ULL, 0x000fe40007810000ULL,
0x0000002225047209ULL, 0x000fe40007810000ULL, 0x00000016052a7209ULL, 0x000fc40007810000ULL,
0x0000002104057209ULL, 0x000fe40007810000ULL, 0x000000152a257209ULL, 0x000fe40007810000ULL,
0x0000002005047209ULL, 0x000fe40007810000ULL, 0x00000014252a7209ULL, 0x000fe40007810000ULL,
0x0000001f04057209ULL, 0x000fe40007810000ULL, 0x000000132a257209ULL, 0x000fc40007810000ULL,
0x0000001e05047209ULL, 0x000fe40007810000ULL, 0x00000012252a7209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x000000112a257209ULL, 0x000fe40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x00000010252a7209ULL, 0x000fc40007810000ULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x0000000f2a057209ULL, 0x000fe40007810000ULL,
0x0000001904257209ULL, 0x000fe40007810000ULL, 0x0000000e05377209ULL, 0x000fe20007810000ULL,
0x00000da27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0025047f89ULL, 0x0004e400000e0000ULL,
0x0000000425397209ULL, 0x008fe20007810000ULL, 0x00000df27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0037047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f00072c7f89ULL, 0x000f6200000e0000ULL, 0x00000004372a7209ULL, 0x008fc60007810000ULL,
0x0c201f0039047f89ULL, 0x000ee200000e0000ULL, 0x00000005062b7209ULL, 0x010fc60007810000ULL,
0x0c201f002a057f89ULL, 0x000f2200000e0000ULL, 0x0000002c07257209ULL, 0x024fc60007810000ULL,
0x0c201f002b2e7f89ULL, 0x002e6800000e0000ULL, 0x0c201f00252c7f89ULL, 0x0004a200000e0000ULL,
0x0000000439047209ULL, 0x008fe40007810000ULL, 0x000000052a057209ULL, 0x010fe40007810000ULL,
0x0000002e2b067209ULL, 0x002fe40007810000ULL, 0x3fb8aa3b042a7820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b052b7820ULL, 0x000fe20000410000ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b2d2d7823ULL, 0x000fc4000001082aULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001082aULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b24247823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b23237823ULL, 0x000fc4000001082aULL, 0x3fb8aa3b22227823ULL, 0x100fe2000001082aULL,
0x00000029002e7308ULL, 0x002e620000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b20207823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001082aULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc4000001082aULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001082aULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001082aULL, 0x3fb8aa3b19197823ULL, 0x000fe2000001082aULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b17177823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b0b2a7823ULL, 0x000fc4000001082bULL,
0x3fb8aa3b18187823ULL, 0x100fe2000001082bULL, 0x0000001a001a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b08397823ULL, 0x100fe2000001082bULL, 0x0000002d2e08723eULL, 0x002fe200000000ffULL,
0x3c003c00ff2e7424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b13137823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe2000001082bULL, 0x00000018002f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fce000001082bULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e700000000800ULL, 0x0000002400077308ULL, 0x000ff00000000800ULL,
0x0000001900297308ULL, 0x0007e20000000800ULL, 0x000000172a0b723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b16177823ULL, 0x000fc4000001082bULL, 0x3fb8aa3b142a7823ULL, 0x000fc8000001082bULL,
0x0000001b00247308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b09197823ULL, 0x008fe2000001082bULL,
0x0000001a2f09723eULL, 0x000fe200000000ffULL, 0x3c003c00ff2f7424ULL, 0x000fca00078e00ffULL,
0x0000001900387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0a1b7823ULL, 0x102fe2000001082bULL,
0x00000028270a723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b15277823ULL, 0x000fca000001082bULL,
0x0000001b00377308ULL, 0x0002f00000000800ULL, 0x0000002600267308ULL, 0x000f220000000800ULL,
0x0000002e0818723cULL, 0x002fee00000018ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000373815723eULL, 0x008fce00000000ffULL, 0x0000002200227308ULL, 0x000e620000000800ULL,
0x000000260714723eULL, 0x010fe200000000ffULL, 0x3fb8aa3b12077823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b10267823ULL, 0x000fc8000001082bULL, 0x0000003900397308ULL, 0x000ff00000000800ULL,
0x0000001700287308ULL, 0x000ee20000000800ULL, 0x000000232216723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b11237823ULL, 0x000fcc000001082bULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000392817723eULL, 0x008fce00000000ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0x0000002e1418723cULL, 0x000fee0000001818ULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x0000001e001e7308ULL, 0x000ee20000000800ULL, 0x000000212010723eULL, 0x002fe200000000ffULL,
0x0000000fff207424ULL, 0x000fcc00078e00ffULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x0000001f1e12723eULL, 0x008fce00000000ffULL,
0x0000001300137308ULL, 0x000ff00000000800ULL, 0x0000000700227308ULL, 0x0007220000000800ULL,
0x000000272a11723eULL, 0x002fce00000000ffULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0xfffffffc31077812ULL, 0x008fc800078ec0ffULL, 0x0000000720207219ULL, 0x000fe400000006ffULL,
0x000000132213723eULL, 0x010fe200000000ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x00000000200773a1ULL, 0x000ee200000e8000ULL, 0x00000000200473c4ULL, 0x000f280000004000ULL,
0x0000002e1038723cULL, 0x000fe40000001818ULL, 0x0000002300237308ULL, 0x000fea0000000800ULL,
0x00000024291a723eULL, 0x000fc600000000ffULL, 0x0000002600267308ULL, 0x000f620000000800ULL,
0x0000001d1c18723eULL, 0x002fce00000000ffULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000520ff7c12ULL, 0x008fe4000f804007ULL, 0x000000252c077209ULL, 0x004fca0007810000ULL,
0x0000000e000e7308ULL, 0x000e620000000800ULL, 0x000000232619723eULL, 0x020fe400000000ffULL,
0x0000000f0e1b723eULL, 0x002fce00000000ffULL, 0x0000002e1838723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x00000a0204008947ULL, 0x010fde000b800000ULL,
0x001c1fff381c7589ULL, 0x0002a400000e0000ULL, 0x00000000200f73a1ULL, 0x000ee200000e8000ULL,
0x00000000200473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000520ff7c12ULL, 0x008fda000f80400fULL, 0x00000a1204008947ULL, 0x010fea000b800000ULL,
0x001c1fff3a1d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff0e7819ULL, 0x000fe40000011631ULL,
0x0000000c0c3d7812ULL, 0x000fc400078ec0ffULL, 0x000000070e0f7812ULL, 0x040fe200078ec0ffULL,
0x000000080e247824ULL, 0x040fe200078e00ffULL, 0x0000000eff227212ULL, 0x002fe200078e33ffULL,
0x000000080e207824ULL, 0x048fe200078e00ffULL, 0x0000000331ff7812ULL, 0x000fe2000780c0ffULL,
0x000000080e2d7824ULL, 0x040fe200078e00ffULL, 0x000000080e0e7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824217812ULL, 0x100fe400078ee20fULL, 0x0000000120237812ULL, 0x100fe200078ef60fULL,
0x000000080e477824ULL, 0x000fe200078e00ffULL, 0x0000000220257812ULL, 0x100fe200078ef60fULL,
0x000000080e2f7824ULL, 0x000fe200078e00ffULL, 0x0000000320277812ULL, 0x100fe200078ef60fULL,
0x000000080e377824ULL, 0x000fe200078e00ffULL, 0x0000000420297812ULL, 0x000fc400078ef60fULL,
0x00000005202b7812ULL, 0x140fe400078ef60fULL, 0x00000006200f7812ULL, 0x000fe400078ef60fULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL, 0x0000000eff227212ULL, 0x000fe400078e33ffULL,
0x000000070e207812ULL, 0x000fe400078ec0ffULL, 0x000120004c0e7811ULL, 0x000fc400078e58ffULL,
0xfffffff82f2f7812ULL, 0x100fe400078ee220ULL, 0x0000000137397812ULL, 0x000fe200078ef620ULL,
0x00000010210c7824ULL, 0x000fe200078e020eULL, 0x00000002373b7812ULL, 0x000fe200078ef620ULL,
0x0000001027247824ULL, 0x000fe200078e020eULL, 0x00000003373f7812ULL, 0x000fe200078ef620ULL,
0x000000100f2a7824ULL, 0x000fe200078e020eULL, 0x0000000437417812ULL, 0x000fe200078ef620ULL,
0x0000001029267824ULL, 0x000fe200078e020eULL, 0x0000000537437812ULL, 0x000fe200078ef620ULL,
0x000000013d0f7824ULL, 0x000fe200078e020cULL, 0x0000000637457812ULL, 0x000fe200078ef620ULL,
0x0000001023207824ULL, 0x000fe200078e020eULL, 0xfffffff847477812ULL, 0x000fe200078ee222ULL,
0x0000001025227824ULL, 0x100fe200078e020eULL, 0x000000080f007388ULL, 0x0003e20000000800ULL,
0x000000102b287824ULL, 0x000fc400078e020eULL, 0x000000013d217824ULL, 0x040fe400078e0220ULL,
0x000000013d237824ULL, 0x000fe400078e0222ULL, 0x000000102d2c7824ULL, 0x000fe200078e020eULL,
0x0000000a21007388ULL, 0x0007e20000000800ULL, 0x000000013d257824ULL, 0x000fe400078e0224ULL,
0x000000102f0c7824ULL, 0x000fe200078e020eULL, 0x0000001423007388ULL, 0x0007e20000000800ULL,
0x000000013d277824ULL, 0x000fc400078e0226ULL, 0x00000010392e7824ULL, 0x000fe200078e020eULL,
0x0000001625007388ULL, 0x0007e20000000800ULL, 0x000000013d297824ULL, 0x000fe400078e0228ULL,
0x000000103b2f7824ULL, 0x000fe200078e020eULL, 0x0000001027007388ULL, 0x0007e20000000800ULL,
0x000000013d2b7824ULL, 0x000fe400078e022aULL, 0x000000103f377824ULL, 0x000fe200078e020eULL,
0x0000001229007388ULL, 0x0007e20000000800ULL, 0x000000013d2d7824ULL, 0x000fc400078e022cULL,
0x0000001041387824ULL, 0x000fe200078e020eULL, 0x000000182b007388ULL, 0x0007e20000000800ULL,
0x000000013d0c7824ULL, 0x000fe400078e020cULL, 0x0000001043397824ULL, 0x100fe200078e020eULL,
0x0000001a2d007388ULL, 0x0007e20000000800ULL, 0x00000010453a7824ULL, 0x100fe400078e020eULL,
0x00000010473b7824ULL, 0x000fe200078e020eULL, 0x000000090c007388ULL, 0x0007e20000000800ULL,
0x000000013d2e7824ULL, 0x000fc400078e022eULL, 0x000000013d0e7824ULL, 0x040fe400078e022fULL,
0x000000013d087824ULL, 0x042fe200078e0237ULL, 0x0000000b2e007388ULL, 0x0007e20000000800ULL,
0x000000013d387824ULL, 0x040fe400078e0238ULL, 0x000000013d207824ULL, 0x040fe200078e0239ULL,
0x000000150e007388ULL, 0x0007e20000000800ULL, 0x000000013d3a7824ULL, 0x040fe400078e023aULL,
0x000000013d227824ULL, 0x000fe200078e023bULL, 0x0000001708007388ULL, 0x0007e80000000800ULL,
0x0000001138007388ULL, 0x0007e80000000800ULL, 0x0000001320007388ULL, 0x0007e80000000800ULL,
0x000000193a007388ULL, 0x0007e80000000800ULL, 0x0000001b22007388ULL, 0x0007e80000000800ULL,
0x01c000040d008388ULL, 0x0007e80000000c00ULL, 0x01c2001c0d008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000003004d4d7a10ULL, 0x000fe20007ffe0ffULL,
0x01c6080033ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ff36ff7812ULL, 0x000fc4000780c0ffULL,
0x000000024d00720cULL, 0x000fe40003f26070ULL, 0x00000001ff367807ULL, 0x000fd60000000000ULL,
0x0000001000001944ULL, 0x002fe20003c00000ULL, 0xffffc14000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0025ULL,
0x00015ad0002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x000fe400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000061000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e002cULL,
0xfffff1f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2c7224ULL, 0x000fe200078e0037ULL,
0x00015b50002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x002fe400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fc400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x0000059000007944ULL, 0x004fea0003c00000ULL, 0x0000002c37057209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0006ULL, 0x00015bc0002a7802ULL, 0x000fe20000000f00ULL,
0x00000002ff2f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff2e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000052000007944ULL, 0x000fea0003c00000ULL,
0x0000002c06377209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0007ULL,
0x00015c30002a7802ULL, 0x000fe20000000f00ULL, 0x00000002ff2f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000004b000007944ULL, 0x000fea0003c00000ULL, 0x0000002c07257209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0039ULL, 0x00015ca0002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff2e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000044000007944ULL, 0x000fea0003c00000ULL,
0x0000002c39047209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0005ULL,
0x00015d10002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x0000002c05057209ULL, 0x004fe20007810000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0037ULL, 0x00015d80002a7802ULL, 0x000fe20000000f00ULL,
0x00000001ff2f7424ULL, 0x002fe400078e00ffULL, 0x0000001fff2e7424ULL, 0x000fe400078e00ffULL,
0xffffffffff3b7424ULL, 0x000fe400078e00ffULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x0000002c37067209ULL, 0x004fe20007810000ULL, 0x000000ffff2c7224ULL, 0x000fe200078e0025ULL,
0x00015df0002a7802ULL, 0x000fe20000000f00ULL, 0x00000001ff2f7424ULL, 0x002fc400078e00ffULL,
0x0000001fff2e7424ULL, 0x000fe400078e00ffULL, 0xffffffffff3b7424ULL, 0x000fe400078e00ffULL,
0x000002f000007944ULL, 0x000fea0003c00000ULL, 0xffffefd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0038ULL, 0x00015e50000e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff227224ULL, 0x000fe400078e00ffULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000002d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e001fULL,
0xfffff5a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x002fe200078e003aULL,
0x00015ec0000e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff227224ULL, 0x000fe400078e00ffULL,
0x00001c1fff237424ULL, 0x000fc400078e00ffULL, 0x0000026000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff227224ULL, 0x002fe200078e00ffULL, 0x00015f10000e7802ULL, 0x000fe20000000f00ULL,
0x00001c1fff237424ULL, 0x000fc400078e00ffULL, 0x000000ffff1d7224ULL, 0x004fe400078e001fULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff227224ULL, 0x002fe200078e00ffULL,
0x00015f60000e7802ULL, 0x000fe20000000f00ULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000001c000007944ULL, 0x000fea0003c00000ULL,
0xfffff52000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff087807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000308ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000308ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x000fc800078e00ffULL, 0xfffe9f2004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2b7424ULL, 0x000fe200078e00ffULL, 0x0000003b00007348ULL, 0x000fe80003800000ULL,
0x0c00002f2c2c7389ULL, 0x0002a200000e002eULL, 0xfffe9ee02a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000002000007348ULL, 0x000fe80003800000ULL,
0x00000022211f7389ULL, 0x0002a200000e0023ULL, 0xfffe9ea00e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x0000000000000234ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000003e8ULL, 0x00000000000001b0ULL, 0x0000001100000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000598ULL, 0x00000000000001d8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000770ULL, 0x0000000000000078ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000007e8ULL, 0x00000000000006acULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e94ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000eb8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ec8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ee8ULL, 0x0000000000000070ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f58ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000000f70ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016200ULL, 0xd200001100000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017380ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017390ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017390ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017810ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000f58ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016428ULL, 0x0000000000016428ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017810ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_int8_nqpkv_16_m_16_sm_80_cubin_len = 96496;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
