/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000016678ULL, 0x00000000000161f8ULL, 0x00380040005a0d5aULL, 0x0001001200400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x2e00000000003374ULL,
0x61626f6c672e766eULL, 0x2e0074696e692e6cULL, 0x74736e6f632e766eULL, 0x0000000034746e61ULL,
0x626f6c672e766e2eULL, 0x2e6c65722e006c61ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL,
0x65742e616c65722eULL, 0x656e72656b2e7478ULL, 0x642e0061686d5f6cULL, 0x6172665f67756265ULL,
0x2e6c65722e00656dULL, 0x74736e6f632e766eULL, 0x006369702e746e61ULL, 0x766e2e616c65722eULL,
0x6e6174736e6f632eULL, 0x722e000000003474ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c61632e766e2e00ULL, 0x2e0068706172676cULL,
0x6f746f72702e766eULL, 0x766e2e0065707974ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL,
0x00000061686d5f6cULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x7472747368732e00ULL, 0x747274732e006261ULL,
0x746d79732e006261ULL, 0x746d79732e006261ULL, 0x78646e68735f6261ULL, 0x666e692e766e2e00ULL,
0x2e747865742e006fULL, 0x6d5f6c656e72656bULL, 0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL,
0x2e0061686d5f6c65ULL, 0x65726168732e766eULL, 0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL,
0x6e6174736e6f632eULL, 0x6b00000000003374ULL, 0x58414d5f334d3445ULL, 0x5456656863616300ULL,
0x654c716553656c69ULL, 0x6c672e766e2e006eULL, 0x696e692e6c61626fULL, 0x69536d656d730074ULL,
0x632e766e2e00657aULL, 0x34746e6174736e6fULL, 0x2e766e2e00000000ULL, 0x6b006c61626f6c67ULL,
0x7079546c656e7265ULL, 0x0000000000000065ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL, 0x2e006369702e746eULL,
0x2e766e2e616c6572ULL, 0x746e6174736e6f63ULL, 0x65722e006369702eULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x6c6c61632e766e2eULL,
0x6e2e006870617267ULL, 0x746f746f72702e76ULL, 0x6e72656b00657079ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000d000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007fULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000089ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000e00030000009aULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e0001000000aaULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000b3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100003000000c4ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00100001000000cfULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000d0022000000efULL, 0x0000000000015080ULL, 0x0000000000000280ULL, 0x000400030000014dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000001a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000d1012000001c4ULL, 0x0000000000000000ULL, 0x0000000000015300ULL,
0x00110003000001cfULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x0000002cffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001508000000000ULL, 0x0000100400000000ULL, 0x01d8288080810c00ULL, 0x0000000000540404ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808292ULL, 0x0000001cffffffffULL, 0x0000006800000000ULL, 0x0001508000000000ULL,
0x0000028000000000ULL, 0x0000000000000000ULL, 0x0000000e00082f04ULL, 0x0008120400000080ULL,
0x000000d80000000bULL, 0x0000000b00081104ULL, 0x00081204000000d8ULL, 0x000000d80000000eULL,
0x0000000e00081104ULL, 0x00081204000000d8ULL, 0x000000d80000000eULL, 0x0000007c00043704ULL,
0x00000000000c1704ULL, 0x0021f00000500007ULL, 0x00000000000c1704ULL, 0x0021f00000480006ULL,
0x00000000000c1704ULL, 0x0021f00000400005ULL, 0x00000000000c1704ULL, 0x0011f00000380004ULL,
0x00000000000c1704ULL, 0x0081f00000180003ULL, 0x00000000000c1704ULL, 0x0021f00000100002ULL,
0x00000000000c1704ULL, 0x0021f00000080001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x00801b0380005003ULL, 0x0000a78000183104ULL, 0x000144f00000acf0ULL, 0x0001451000014500ULL,
0x0134290400014520ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x0500002405000021ULL,
0x0500002105000024ULL, 0x0500002105000021ULL, 0x0500003405000034ULL, 0x0500003405000034ULL,
0x0500003405000034ULL, 0x0500003405000034ULL, 0x0500003405000034ULL, 0x0134280405000034ULL,
0x000000c0000000b0ULL, 0x000029e0000019e0ULL, 0x00002b1000002aa0ULL, 0x00002eb000002b40ULL,
0x000032c000002ee0ULL, 0x00003d1000003ce0ULL, 0x0000492000004020ULL, 0x00004a10000049c0ULL,
0x00004d6000004a40ULL, 0x00004fb000004d70ULL, 0x0000573000005720ULL, 0x000062d0000059d0ULL,
0x000063c000006370ULL, 0x00006710000063f0ULL, 0x0000696000006720ULL, 0x000070f0000070e0ULL,
0x00007c8000007380ULL, 0x00007d8000007d20ULL, 0x0000810000007db0ULL, 0x0000833000008110ULL,
0x00008ab000008aa0ULL, 0x00008ec000008eb0ULL, 0x0000a780000093a0ULL, 0x0000b1200000acf0ULL,
0x0000b5d00000b150ULL, 0x0000ba600000b5f0ULL, 0x00013e3000013e20ULL, 0x00013e5000013e40ULL,
0x00013ea000013e80ULL, 0x00013ed000013ec0ULL, 0x00014500000144e0ULL, 0x0001455000014510ULL,
0x0001457000014560ULL, 0x00014c1000014b80ULL, 0x00014cd000014c70ULL, 0x00014da000014d40ULL,
0x00014e6000014e00ULL, 0x00014fa000014f00ULL, 0x01f0390400015040ULL, 0x000000ff000001c0ULL,
0x000401000001c600ULL, 0x00000002000002a0ULL, 0x003f01000001c608ULL, 0x00000002000003b0ULL,
0x003f01000001c688ULL, 0x000000ff000006f0ULL, 0x000601070001c600ULL, 0x0000000300000850ULL,
0x000601010001c688ULL, 0x00000024000028f0ULL, 0x000601010001c608ULL, 0x0000002900002960ULL,
0x000601090001c608ULL, 0x000000ff00003f20ULL, 0x000601010001c688ULL, 0x0000000900004880ULL,
0x000601010001c628ULL, 0x00000009000048a0ULL, 0x000601090001c628ULL, 0x000000ff000058d0ULL,
0x000601010001c690ULL, 0x0000000900006230ULL, 0x000601010001c648ULL, 0x0000000900006250ULL,
0x000601090001c648ULL, 0x000000ff00007280ULL, 0x000601010001c698ULL, 0x0000000900007be0ULL,
0x000601010001c668ULL, 0x0000000900007c00ULL, 0x000601090001c668ULL, 0x000000ff00008b70ULL,
0x000601010001c6a0ULL, 0x000000ff0000bd00ULL, 0x000601010001c600ULL, 0x000000ff0000daa0ULL,
0x000601090001c600ULL, 0x000000ff00013440ULL, 0x000901010001c688ULL, 0x000000ff00013490ULL,
0x000901090001c688ULL, 0x0000000b00014870ULL, 0x003f01010001c608ULL, 0x0000000b00014880ULL,
0x003f01010001c610ULL, 0x0000000b00014890ULL, 0x003f01010001c618ULL, 0x0000000b000148a0ULL,
0x003f01010001c620ULL, 0x000000ff000148d0ULL, 0x001801090001c608ULL, 0x000000ff00014930ULL,
0x001801090001c628ULL, 0x000000ff00014990ULL, 0x001801090001c648ULL, 0x000000ff000149f0ULL,
0x001801090001c668ULL, 0x000000ff00014a50ULL, 0x000601090001c600ULL, 0x0000000500014ac0ULL,
0x003f01090001c688ULL, 0x00101c0400033803ULL, 0x0000dad00000bcd0ULL, 0x000148c00000db50ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x00080a0400581903ULL,
0x005802100000000fULL, 0x0000000800043604ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x0000000000000000ULL,
0x00000000000000c4ULL, 0x0000000e00000002ULL, 0x0000000000015080ULL, 0x0000000000000044ULL,
0x0000000e00000002ULL, 0x0000000000000000ULL, 0x00000000000000a0ULL, 0x0000000e00000002ULL,
0x0000000000000000ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0xffffff2801017836ULL, 0x002fe20000000000ULL,
0x000001c000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000e620000002300ULL,
0x0000000000007919ULL, 0x000f280000002200ULL, 0x00008800ff047b82ULL, 0x000f700000000a00ULL,
0x00000000000879c3ULL, 0x000f700000002700ULL, 0x00000000000e79c3ULL, 0x000f620000002600ULL,
0x00000005ff027819ULL, 0x004fe20000011609ULL, 0x00001fff03077589ULL, 0x002fea00000e0000ULL,
0x00001fff02027589ULL, 0x000e6200000e0000ULL, 0x0000000103007824ULL, 0x010fc800078e0200ULL,
0x0000008000067824ULL, 0x000fca00078e0209ULL, 0x000000ff0600720cULL, 0x040fe40003f05270ULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000030600780cULL, 0x000fe40003f44070ULL,
0x00000000021072caULL, 0x002fe200000e0000ULL, 0x00000004ff027e24ULL, 0x008fca000f8e00ffULL,
0x0000040201007387ULL, 0x0003ee0000100800ULL, 0x0000001007007c11ULL, 0x000fe2000f8e10ffULL,
0x0000000000240947ULL, 0x022fec0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01c60006043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000406027c11ULL, 0x002fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x002fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01c60804063f75b2ULL, 0x0042f00008000100ULL,
0xfffffffd00e81947ULL, 0x008fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x002e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000406027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x004fca0000000000ULL,
0x00000000020612caULL, 0x002fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01c68804063f75b2ULL, 0x0042f00008000100ULL, 0xfffffffd00e81947ULL, 0x008fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000779c3ULL, 0x000ee20000008800ULL,
0x00000000001e7919ULL, 0x000f220000000000ULL, 0x0000007f0600780cULL, 0x000fe20003f04070ULL,
0x0000040000067882ULL, 0x002fe20000000000ULL, 0x00008400000f7ab9ULL, 0x000fe20000000800ULL,
0x0000000200087824ULL, 0x000fe200078e00ffULL, 0x000000030e047899ULL, 0x000fe4000800063fULL,
0x000000030f057899ULL, 0x000fe2000800063fULL, 0x00000001080a7836ULL, 0x040fe20000000000ULL,
0x0000000808037848ULL, 0x000fe20007fe0000ULL, 0x00008200000c7ab9ULL, 0x000fe20000000a00ULL,
0x00000008050472a4ULL, 0x000fc6000f8e0204ULL, 0xff317217ff0f8424ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a08ULL, 0x0000000408097c36ULL, 0x000fe40008000000ULL,
0x000000040a0b7c36ULL, 0x000fe20008000000ULL, 0x000000ff0300720cULL, 0x040fe20003f23070ULL,
0x0000065407067896ULL, 0x008fe20008000006ULL, 0x000000010300780cULL, 0x000fe20003f43070ULL,
0x0000020009027825ULL, 0x000fe200078e0004ULL, 0x0000000708097812ULL, 0x000fe200078ec0ffULL,
0x0001c60006047890ULL, 0x000fc4000fffe03fULL, 0x0000000606068c11ULL, 0x000fe2000f8e10ffULL,
0x000002000b047825ULL, 0x000fe200078e0004ULL, 0x000000070a0b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f09097812ULL, 0x010fe200078e781eULL, 0x01c4000f06008388ULL, 0x0003e20000000800ULL,
0x000000101e007824ULL, 0x000fe200078e00ffULL, 0x0000001f0b0b7812ULL, 0x000fe400078e781eULL,
0x0000002008097824ULL, 0x000fe400078e0209ULL, 0x000001f0000d7812ULL, 0x000fe200078ec0ffULL,
0x000000200a0b7824ULL, 0x000fc400078e020bULL, 0x0000000609097c11ULL, 0x000fe2000f8e20ffULL,
0x0000000000007b1dULL, 0x004fe20000010000ULL, 0x0000000d02027210ULL, 0x000fe40007f7e0ffULL,
0x0000000d04047210ULL, 0x000fe40007f9e0ffULL, 0x000000060b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff037224ULL, 0x000fe400018e0603ULL, 0x000000ffff057224ULL, 0x000fc600020e0605ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c901c4cULL,
0x00000000040b7faeULL, 0x0003e2000d101c4cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fc40000000a00ULL,
0x00000004080478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff027e24ULL, 0x002fe4000f8e00ffULL,
0x00000005ff037e24ULL, 0x000fca000f8e00ffULL, 0x0000000c02027981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fe20003f05270ULL, 0x0000030000117ab9ULL, 0x000fe20000000800ULL,
0x00000000021472caULL, 0x004fda00000e0000ULL, 0x0000003f14047890ULL, 0x000fe4000fffe03fULL,
0x000000ff14057890ULL, 0x000fe4000fffe03fULL, 0x000000063f047899ULL, 0x000fe40008011604ULL,
0x000000083f057899ULL, 0x000fe20008011605ULL, 0x000000b400388947ULL, 0x000ff60003800000ULL,
0x0000040001207983ULL, 0x000ea20000100800ULL, 0x0000000310127899ULL, 0x000fe2000800063fULL,
0x00000004ff007424ULL, 0x000fe200078e00ffULL, 0xffffffff000a7882ULL, 0x000fc80000000000ULL,
0x00000012ff037e24ULL, 0x000fc8000f8e00ffULL, 0x01c6880003ff79a7ULL, 0x0003e20008500006ULL,
0x00000000200772caULL, 0x044fe200000e0000ULL, 0x0000000120047836ULL, 0x000fd80000000000ULL,
0x0000000207077899ULL, 0x000fc8000800063fULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000280947ULL, 0x002fea0003800000ULL,
0x00009000000b7ab9ULL, 0x000fe20000000800ULL, 0x0000000108097899ULL, 0x000fe4000800063fULL,
0x0000000b070a7290ULL, 0x000fc8000fffe03fULL, 0x0000000b090972a4ULL, 0x000fc6000f8e020aULL,
0x00008c00000a7ab9ULL, 0x000fe40000000a00ULL, 0x00000004090a78a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff027e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff037e24ULL, 0x000fca000f8e00ffULL,
0x0000000c02027981ULL, 0x000ea4000c1e1900ULL, 0x00000000020a72caULL, 0x004fde00000e0000ULL,
0x0000000504007c0cULL, 0x000fe2000bf06070ULL, 0x0000000f0a0972a4ULL, 0x000fe4000f8e023fULL,
0x0000001206187290ULL, 0x000fe4000fffe03fULL, 0x00000006090b7899ULL, 0x000fd0000800063fULL,
0x0000000400d88947ULL, 0x000fea0003800000ULL, 0x0000010020007824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe2000001161eULL, 0x0000000eff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x000000ffff057224ULL, 0x000fe200078e0a00ULL,
0x0000001400027c48ULL, 0x000fe2000ffe0000ULL, 0x0000000413037836ULL, 0x040fe20000000000ULL,
0x00000003100f7899ULL, 0x000fe2000800063fULL, 0x000000400e0e7824ULL, 0x000fe200078e0213ULL,
0x0000002002007446ULL, 0x000fe20003800005ULL, 0x0000000813057836ULL, 0x000fe20000000000ULL,
0x0000001e03027212ULL, 0x040fe200078e3cffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x000000000300720cULL, 0x000fe20003f46070ULL, 0x0000000805147824ULL, 0x040fe200078e00ffULL,
0x0000001e05037212ULL, 0x040fe200078e3cffULL, 0x000000100e097836ULL, 0x040fe20000000000ULL,
0xfffffff807127812ULL, 0x000fe200078ee202ULL, 0x000000040e027836ULL, 0x040fe20000000000ULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x000000080e037836ULL, 0x040fe20000000000ULL,
0x000000000500720cULL, 0x000fe20003f26070ULL, 0x0000000610097291ULL, 0x000fe2000f8e683fULL,
0x0000000b02057c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000fff157e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b03037c10ULL, 0x000fe2000ff9e0ffULL, 0x0000000c13117836ULL, 0x000fe20000000000ULL,
0x0000000b0e077c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x0000001605047c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000001603027c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000001705057c11ULL, 0x000fe200098f4c08ULL, 0x0000000c0e087836ULL, 0x040fe20000000000ULL,
0x0000001703037c11ULL, 0x000fe2000a0f4c0aULL, 0x000000140e0a7836ULL, 0x000fe20000000000ULL,
0x0000001607067c11ULL, 0x000fe2000f8048ffULL, 0x0001400009097890ULL, 0x000fe2000fffe03fULL,
0x0000000b090b7c10ULL, 0x000fe2000ff7e0ffULL, 0x00000008111b7824ULL, 0x000fe200078e00ffULL,
0x0000000b0a0d7c10ULL, 0x000fe2000ff9e0ffULL, 0x00000018131d7836ULL, 0x000fe20000000000ULL,
0x0000001707077c11ULL, 0x000fe200080f4c0cULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000000b080f7c10ULL, 0x000fe2000ff1e0ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000160d0c7c11ULL, 0x000fc4000f8848ffULL, 0x000000160b0a7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x000000170d0d7c11ULL, 0x000fe2000a0f4c10ULL,
0x000000180e107836ULL, 0x040fe20000000000ULL, 0x000000160f087c11ULL, 0x000fe2000f8048ffULL,
0x0000001c0e0e7836ULL, 0x000fe20000000000ULL, 0x000000170b0b7c11ULL, 0x000fe400098f4c16ULL,
0x000000170f097c11ULL, 0x000fe400080f4c18ULL, 0x00000007130f7812ULL, 0x000fc400078e481eULL,
0x0000000b0e187c10ULL, 0x000fe4000ffbe0ffULL, 0x000000001300720cULL, 0x000fe40003f66070ULL,
0x0ffffff80f0f7812ULL, 0x000fe200078ef81eULL, 0x000000ffff197224ULL, 0x000fe200028e06ffULL,
0x0000000b101a7c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff815157812ULL, 0x000fe400078ee21eULL,
0x0000001e11167212ULL, 0x000fc400078e3cffULL, 0x0000001618107c11ULL, 0x000fe2000f8a48ffULL,
0x0000001015067825ULL, 0x000fe200078e0006ULL, 0x000000090f177c11ULL, 0x000fe4000f8e20ffULL,
0xfffffff81b167812ULL, 0x000fe200078ee216ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x000000001100720cULL, 0x080fe20003f06070ULL, 0x00000014131b7836ULL, 0x040fe20000000000ULL,
0x000000161a0e7c11ULL, 0x000fe2000f8848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006177faeULL, 0x0003e2000d901c4cULL, 0x0000001718117c11ULL, 0x000fe2000a8f4c19ULL,
0x0000001013197836ULL, 0x040fe20000000000ULL, 0x000000171a0f7c11ULL, 0x000fe2000a0f4c0fULL,
0x0000001c13137836ULL, 0x000fe20000000000ULL, 0x000000001b00720cULL, 0x080fe20003f86070ULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0x000000001900720cULL, 0x080fe20003f66070ULL,
0x00000008131c7824ULL, 0x000fe200078e00ffULL, 0x000000001d00720cULL, 0x080fe20003fa6070ULL,
0x0000001015047825ULL, 0x000fe200078e0004ULL, 0x000000001300720cULL, 0x000fc40003fc6070ULL,
0x0000001e1b067212ULL, 0x0c2fe200078e3cffULL, 0x000000081b1b7824ULL, 0x000fe200078e00ffULL,
0x0000001e1d077212ULL, 0x080fe200078e3cffULL, 0x0000001015027825ULL, 0x000fe200078e0002ULL,
0x0000001e19007212ULL, 0x080fe400078e3cffULL, 0x0000001e13177212ULL, 0x000fe200078e3cffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0xfffffff81b187812ULL, 0x000fe400078ee206ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x0000001015067825ULL, 0x000fe200078e0008ULL,
0xfffffff819007812ULL, 0x000fc400078ee200ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x0000001015087825ULL, 0x040fe200078e000aULL, 0x0000000912137c11ULL, 0x000fe4000f8e20ffULL,
0x0000000914177c11ULL, 0x000fe2000f8e20ffULL, 0x00000010150a7825ULL, 0x040fe200078e000cULL,
0x0000000918197c11ULL, 0x000fe2000f8e20ffULL, 0x0000000004137faeULL, 0x0003e2000d101c4cULL,
0x000000091a1b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000010150c7825ULL, 0x040fe200078e000eULL,
0x000000091c1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000002177faeULL, 0x0003e4000c901c4cULL,
0x00000010150e7825ULL, 0x000fe200078e0010ULL, 0x0000000916117c11ULL, 0x000fc4000f8e20ffULL,
0x0000000900157c11ULL, 0x000fc6000f8e20ffULL, 0x0000000006117faeULL, 0x0003e8000c101c4cULL,
0x0000000008157faeULL, 0x0003e8000d901c4cULL, 0x000000000a197faeULL, 0x0003e8000e101c4cULL,
0x000000000c1b7faeULL, 0x0003e8000e901c4cULL, 0x000000000e1d7faeULL, 0x0003e2000f101c4cULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001161eULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x00000003100f7899ULL, 0x000fe4000800063fULL,
0x0000000610097291ULL, 0x000fe2000f8e683fULL, 0x0000000400027836ULL, 0x040fe40000000000ULL,
0x0000000c00047836ULL, 0x000fe20000000000ULL, 0x0001400009097890ULL, 0x000fe2000fffe03fULL,
0x0000000802127824ULL, 0x040fe200078e00ffULL, 0x0000001e02037212ULL, 0x000fe200078e3cffULL,
0x0000000800027836ULL, 0x000fc40000000000ULL, 0x0000001000057836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000000802147824ULL, 0x040fe200078e00ffULL,
0x0000001e02037212ULL, 0x080fe200078e3cffULL, 0x0000000804077824ULL, 0x040fe200078e00ffULL,
0x0000001e04027212ULL, 0x080fe200078e3cffULL, 0x0000000fff137e24ULL, 0x000fe2000f8e00ffULL,
0x0000001e05047212ULL, 0x040fe200078e3cffULL, 0x0000000805057824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee203ULL, 0x0000001400037836ULL, 0x000fe20000000000ULL,
0xfffffff807167812ULL, 0x000fc400078ee202ULL, 0xfffffff805187812ULL, 0x000fe200078ee204ULL,
0x0000001800047836ULL, 0x000fe20000000000ULL, 0x0000001e03027212ULL, 0x0c0fe200078e3cffULL,
0x00000008031b7824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee21eULL,
0x0000000eff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000001e04037212ULL, 0x0c0fe200078e3cffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x0000001c00027836ULL, 0x000fe20000000000ULL, 0x0000000912177c11ULL, 0x000fe2000f8e20ffULL,
0x00000040050a7824ULL, 0x000fe200078e0200ULL, 0xfffffff8041d7812ULL, 0x000fe200078ee203ULL,
0x0000000802087824ULL, 0x040fe200078e00ffULL, 0x0000001e02077212ULL, 0x000fe200078e3cffULL,
0x000000040a057836ULL, 0x040fe20000000000ULL, 0x0000000b0a037c10ULL, 0x000fe2000ff1e0ffULL,
0x000000080a067836ULL, 0x040fe20000000000ULL, 0xfffffff8081f7812ULL, 0x000fe200078ee207ULL,
0x0000000c0a097836ULL, 0x040fe20000000000ULL, 0x0000000b05057c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000b06077c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100a0b7836ULL, 0x040fe20000000000ULL, 0x0000001603027c11ULL, 0x000fe2000f8048ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000001607067c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000001703037c11ULL, 0x000fe200080f4c04ULL,
0x000000180a0e7836ULL, 0x000fe20000000000ULL, 0x0000000b09097c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001605047c11ULL, 0x000fe2000f8048ffULL, 0x0000001013027825ULL, 0x000fe200078e0002ULL,
0x0000001707077c11ULL, 0x000fe400088f4c0cULL, 0x0000001705057c11ULL, 0x000fe200080f4c08ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x0000001609087c11ULL, 0x000fe2000f8048ffULL,
0x0000001013067825ULL, 0x000fe200078e0006ULL, 0x0000000700007812ULL, 0x000fe400078e481eULL,
0x0000001709097c11ULL, 0x000fe200080f4c0cULL, 0x000000140a0c7836ULL, 0x040fe20000000000ULL,
0x0ffffff800007812ULL, 0x000fe200078ef81eULL, 0x0000001c0a0a7836ULL, 0x000fe20000000000ULL,
0x0000000b0b0b7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001013047825ULL, 0x000fe200078e0004ULL,
0x0000000b0c0d7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000b0e0f7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001013087825ULL, 0x000fe200078e0008ULL, 0x0000000b0a117c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000900157c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x000000160b0a7c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x000000160d0c7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x000000160f0e7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x0000001611107c11ULL, 0x000fe2000f8648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c4cULL, 0x000000170b0b7c11ULL, 0x000fc400080f4c00ULL,
0x000000170d0d7c11ULL, 0x000fe200088f4c1aULL, 0x0000000004177faeULL, 0x0005e2000b901c4cULL,
0x000000170f0f7c11ULL, 0x000fe200090f4c1cULL, 0x00000010130a7825ULL, 0x000fe200078e000aULL,
0x0000001711117c11ULL, 0x000fe400098f4c1eULL, 0x0000000914197c11ULL, 0x000fe2000f8e20ffULL,
0x00000010130c7825ULL, 0x000fe200078e000cULL, 0x000000091b1b7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000916037c11ULL, 0x002fe2000f8e20ffULL, 0x00000010130e7825ULL, 0x000fe200078e000eULL,
0x000000091d1d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006197faeULL, 0x0005e2000b901c4cULL,
0x000000091f1f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001013107825ULL, 0x000fe200078e0010ULL,
0x0000000918137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000008037faeULL, 0x0005e8000b901c4cULL,
0x000000000a137faeULL, 0x0005e8000b901c4cULL, 0x000000000c1b7faeULL, 0x0005e8000b901c4cULL,
0x000000000e1d7faeULL, 0x0005e8000b901c4cULL, 0x00000000101f7faeULL, 0x0005e4000b901c4cULL,
0x0000000520007c0cULL, 0x000fe2000bf06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff087424ULL, 0x006fe200078e00ffULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fc4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000074001c0947ULL, 0x000fec0003800000ULL, 0x0000000108087899ULL, 0x000fe2000800063fULL,
0xff317217ff087424ULL, 0x000fe200078e00ffULL, 0x0000900000097ab9ULL, 0x000fe20000000800ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x00000009080872a4ULL, 0x000fd8000f8e0209ULL,
0x0000040001027983ULL, 0x000ea40000100800ULL, 0x0000010002007824ULL, 0x004fca00078e00ffULL,
0x0000001400007c0cULL, 0x000fda000bf06070ULL, 0x0000007000e40947ULL, 0x000fea0003800000ULL,
0x0000000102027836ULL, 0x000fe20000000000ULL, 0x0000000000457919ULL, 0x000e620000000000ULL,
0x0000840000097ab9ULL, 0x000fe40000000800ULL, 0x000000090a0a72a4ULL, 0x000fe2000f8e023fULL,
0x0000000502007c0cULL, 0x000fc6000bf06070ULL, 0x000000060a0a7899ULL, 0x000fe2000800063fULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000000400d88947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fe20000011645ULL, 0x0000002000007836ULL, 0x000fe20000000000ULL,
0x000000200e0b7891ULL, 0x000fe2000f8e303fULL, 0x0000000745647812ULL, 0x000fe200078ec0ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000000406057836ULL, 0x000fe20000000000ULL,
0x0000001400027c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0a00ULL,
0x0000000610157291ULL, 0x000fe2000f8e683fULL, 0x0000001406007836ULL, 0x000fe20000000000ULL,
0x0000004505487212ULL, 0x040fe200078e3cffULL, 0x0000000805037824ULL, 0x040fe200078e00ffULL,
0x00000020020f7446ULL, 0x000fe2000380000fULL, 0x00000008000d7824ULL, 0x040fe200078e00ffULL,
0x00000045000a7212ULL, 0x080fe200078e3cffULL, 0x0000000b06627c36ULL, 0x040fe20008000000ULL,
0xfffffff803487812ULL, 0x000fe200078ee248ULL, 0x0000001006027836ULL, 0x040fe20000000000ULL,
0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000b055f7c36ULL, 0x000fe20008000000ULL,
0x0000000a62107c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000c06037836ULL, 0x000fe20000000000ULL,
0x0000004502097212ULL, 0x0c0fe200078e3cffULL, 0x00000008020e7824ULL, 0x000fe200078e00ffULL,
0x0000000a5f0d7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000806047836ULL, 0x000fe20000000000ULL,
0x0000004503127212ULL, 0x0c0fe200078e3cffULL, 0x00000008030b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0x0000001610367c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0xfffffff80b127812ULL, 0x000fe200078ee212ULL, 0x0000000b04597c36ULL, 0x040fe20008000000ULL,
0x000000160d347c11ULL, 0x040fe2000f8448ffULL, 0x00000008040c7824ULL, 0x040fe200078e00ffULL,
0x0000004504137212ULL, 0x080fe200078e3cffULL, 0x0000000b02557c36ULL, 0x000fe20008000000ULL,
0x0000001710377c11ULL, 0x000fe200088f4c11ULL, 0x00000018060b7836ULL, 0x000fe20000000000ULL,
0x000000170d357c11ULL, 0x000fe200090f4c0eULL, 0x0000000b03577c36ULL, 0x000fe20008000000ULL,
0x0000000a59247c10ULL, 0x000fe2000ff3e0ffULL, 0x000000080b257824ULL, 0x040fe200078e00ffULL,
0xfffffff80c137812ULL, 0x000fe200078ee213ULL, 0x0000000b00537c36ULL, 0x000fe20008000000ULL,
0x0000000a550e7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x000000450b0c7212ULL, 0x040fe200078e3cffULL, 0x0000000b0b517c36ULL, 0x000fe20008000000ULL,
0x0000000a57107c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0xfffffff8250c7812ULL, 0x000fe200078ee20cULL, 0x0001500015197890ULL, 0x000fe2000fffe03fULL,
0x00000016242a7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x000000160e267c11ULL, 0x000fc4000f8648ffULL, 0x0000000a530d7c10ULL, 0x000fe4000ff9e0ffULL,
0x0000001610287c11ULL, 0x000fe4000f8448ffULL, 0x00000017242b7c11ULL, 0x000fe400088f4c27ULL,
0x000000170e277c11ULL, 0x000fe200098f4c11ULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x0000001710297c11ULL, 0x000fe400090f4c25ULL, 0x000000160d107c11ULL, 0x000fc4000f8248ffULL,
0x0000004506247212ULL, 0x040fe400078e3cffULL, 0x000000170d117c11ULL, 0x000fe200088f4c0eULL,
0x0000001c060e7836ULL, 0x000fe20000000000ULL, 0x0000000724247812ULL, 0x000fe200078ec0ffULL,
0x00000012640d7c36ULL, 0x000fe20008000000ULL, 0x0000000f0600720cULL, 0x080fe20003f26070ULL,
0x0000000b0e4f7c36ULL, 0x000fe20008000000ULL, 0x0000000f0500720cULL, 0x000fe20003f46070ULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x0000000a51257c10ULL, 0x000fc4000ff9e0ffULL,
0x0000000f0400720cULL, 0x080fe20003f66070ULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0ffffff8244b7812ULL, 0x000fe400078ef845ULL, 0x00000019485e7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x0000001625247c11ULL, 0x000fe2000f8848ffULL,
0x000000100d387825ULL, 0x000fe200078e002aULL, 0x000000194b607c11ULL, 0x000fe4000f8e20ffULL,
0x0000001913587c11ULL, 0x000fe2000f8e20ffULL, 0x000000080e447824ULL, 0x000fe200078e00ffULL,
0x0000001725257c11ULL, 0x000fe2000a0f4c3aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036607faeULL, 0x0003e2000c901c4cULL, 0x0000000a4f2b7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000000f0300720cULL, 0x080fe20003f26070ULL,
0x00000000345e7faeULL, 0x0003e2000d101c4cULL, 0x0000000f0000720cULL, 0x080fe20003f46070ULL,
0x000000ffff3a7224ULL, 0x000fe200020e06ffULL, 0x000000162b2a7c11ULL, 0x000fe2000f8c48ffULL,
0x0000000038587faeULL, 0x0003e2000d901c4cULL, 0x0000000f0200720cULL, 0x080fe20003f66070ULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x0000000f0b00720cULL, 0x000fc40003f86070ULL,
0x000000450e3b7212ULL, 0x040fe200078e3cffULL, 0x000000100d107825ULL, 0x000fe200078e0010ULL,
0x0000000f0e00720cULL, 0x000fe40003fa6070ULL, 0x000000172b2b7c11ULL, 0x000fe2000b0f4c3aULL,
0x000000100d247825ULL, 0x040fe200078e0024ULL, 0xfffffff8440f7812ULL, 0x000fe400078ee23bULL,
0x0000001912567c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x0000001909547c11ULL, 0x000fc4000f8e20ffULL, 0x000000190a527c11ULL, 0x000fe2000f8e20ffULL,
0x0000000028567faeULL, 0x0003e2000c901c4cULL, 0x000000190c507c11ULL, 0x000fe4000f8e20ffULL,
0x000000190f4e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000026547faeULL, 0x0003e8000d901c4cULL,
0x0000000010527faeULL, 0x0003e8000d101c4cULL, 0x0000000024507faeULL, 0x0003e8000e101c4cULL,
0x000000002a4e7faeULL, 0x0003e2000e901c4cULL, 0x0000000400a47947ULL, 0x000fea0003800000ULL,
0x00000003ff067819ULL, 0x002fe20000011645ULL, 0x000000200e0b7891ULL, 0x000fe2000f8e303fULL,
0x0000000745647812ULL, 0x000fe200078ec0ffULL, 0x00008a0000167ab9ULL, 0x000fe20000000a00ULL,
0x0000000610157291ULL, 0x000fe2000f8e683fULL, 0x0000000806047836ULL, 0x040fe40000000000ULL,
0x0000000406057836ULL, 0x000fe20000000000ULL, 0x0001500015197890ULL, 0x000fe2000fffe03fULL,
0x0000000804007824ULL, 0x040fe200078e00ffULL, 0x0000004504137212ULL, 0x080fe200078e3cffULL,
0x0000000c06037836ULL, 0x040fe20000000000ULL, 0x0000004505487212ULL, 0x0c0fe200078e3cffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff800137812ULL, 0x000fe200078ee213ULL,
0x0000001406007836ULL, 0x000fe20000000000ULL, 0x0000004503127212ULL, 0x0c0fe200078e3cffULL,
0x00000008030b7824ULL, 0x000fe200078e00ffULL, 0xfffffff809487812ULL, 0x000fe200078ee248ULL,
0x00000008000d7824ULL, 0x040fe200078e00ffULL, 0x00000045000a7212ULL, 0x080fe200078e3cffULL,
0x0000000b06627c36ULL, 0x040fe20008000000ULL, 0xfffffff80b127812ULL, 0x000fe200078ee212ULL,
0x0000001006027836ULL, 0x040fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x00000018060b7836ULL, 0x000fe20000000000ULL, 0x0000000a620d7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000008020e7824ULL, 0x040fe200078e00ffULL, 0x0000004502097212ULL, 0x080fe200078e3cffULL,
0x0000000b055f7c36ULL, 0x000fe20008000000ULL, 0x000000450b0c7212ULL, 0x0c0fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x000000160d347c11ULL, 0x040fe2000f8248ffULL,
0x0000001c060e7836ULL, 0x000fe20000000000ULL, 0x0000000a5f117c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000b04597c36ULL, 0x000fe20008000000ULL, 0xfffffff80f0c7812ULL, 0x000fe200078ee20cULL,
0x000000080e247824ULL, 0x040fe200078e00ffULL, 0x000000170d357c11ULL, 0x000fe200088f4c10ULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x000000450e0f7212ULL, 0x000fe200078e3cffULL,
0x0000000b03577c36ULL, 0x000fe20008000000ULL, 0x0000000a590d7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000b02557c36ULL, 0x000fe20008000000ULL, 0x0000001611387c11ULL, 0x000fe2000f8248ffULL,
0x0000000b00537c36ULL, 0x000fe20008000000ULL, 0xfffffff8240f7812ULL, 0x000fe200078ee20fULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x000000160d367c11ULL, 0x000fe2000f8448ffULL,
0x0000000b0b517c36ULL, 0x000fe20008000000ULL, 0x0000001711397c11ULL, 0x000fe200088f4c10ULL,
0x0000000b0e4f7c36ULL, 0x000fe20008000000ULL, 0x0000000a57107c10ULL, 0x000fc4000ff3e0ffULL,
0x000000170d377c11ULL, 0x000fe400090f4c24ULL, 0x0000000a55117c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x0000000a53257c10ULL, 0x000fe4000ff7e0ffULL,
0x00000016102a7c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x0000001611287c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00000017102b7c11ULL, 0x000fc400088f4c0dULL, 0x0000001625107c11ULL, 0x000fe4000f8248ffULL,
0x00000045060d7212ULL, 0x000fe400078e3cffULL, 0x0000001711297c11ULL, 0x000fe400090f4c24ULL,
0x0000001725117c11ULL, 0x000fe400088f4c26ULL, 0x000000070d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000a51257c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000a4f277c10ULL, 0x000fe4000ff5e0ffULL,
0x0ffffff80d4b7812ULL, 0x000fe200078ef845ULL, 0x00000012640d7c36ULL, 0x000fe20008000000ULL,
0x00000019485e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x0000001625247c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff447224ULL, 0x000fe200010e06ffULL,
0x0000001627267c11ULL, 0x000fe2000f8448ffULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x000000194b607c11ULL, 0x000fc4000f8e20ffULL, 0x0000001725257c11ULL, 0x000fe200088f4c3aULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x0000001913587c11ULL, 0x000fe2000f8e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034607faeULL, 0x0003e2000b901c4cULL,
0x0000001727277c11ULL, 0x000fe200090f4c44ULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x0000001912567c11ULL, 0x000fe2000f8e20ffULL, 0x00000000385e7faeULL, 0x0003e2000b901c4cULL,
0x0000001909547c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d2a7825ULL, 0x040fe200078e002aULL,
0x000000190a527c11ULL, 0x000fe2000f8e20ffULL, 0x0000000036587faeULL, 0x0003e2000b901c4cULL,
0x000000190c507c11ULL, 0x000fe2000f8e20ffULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x000000190f4e7c11ULL, 0x000fe2000f8e20ffULL, 0x000000002a567faeULL, 0x0003e4000b901c4cULL,
0x000000100d107825ULL, 0x000fc400078e0010ULL, 0x0000000028547faeULL, 0x0003e4000b901c4cULL,
0x000000100d247825ULL, 0x040fe400078e0024ULL, 0x0000000010527faeULL, 0x0003e4000b901c4cULL,
0x000000100d267825ULL, 0x000fe400078e0026ULL, 0x0000000024507faeULL, 0x0003e8000b901c4cULL,
0x00000000264e7faeULL, 0x0003e4000b901c4cULL, 0x00000003070a7892ULL, 0x000fe2000f8ec03fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xfffffffd110f7891ULL, 0x000fe4000f8e103fULL,
0x000000030a00788cULL, 0x000fc8000bf05270ULL, 0x000000010f0a7887ULL, 0x000fc8000c000000ULL,
0x0000000a07077290ULL, 0x000fc8000fffe03fULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f2f008ULL, 0x0000000807138290ULL, 0x000fe2000fffe03fULL,
0x00008c00000a8ab9ULL, 0x000fc60000000a00ULL, 0x00000004130a88a5ULL, 0x000fe2000f8e000aULL,
0x00000012ff247e24ULL, 0x002fe4000f8e00ffULL, 0x00000001ff107424ULL, 0x000fc600078e00ffULL,
0x0000000aff267e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff277e24ULL, 0x000fca000f8e00ffULL,
0x0000000c26639981ULL, 0x000362000c1e1900ULL, 0x01c60810242479a7ULL, 0x0004e20008500006ULL,
0x00000012ff297e24ULL, 0x000fe2000f8e00ffULL, 0x00000001ff117819ULL, 0x000fc80000011645ULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x0000001045107824ULL, 0x004fca00078e00ffULL,
0x0000007010107812ULL, 0x000fc800078ec0ffULL, 0x0000000611107c10ULL, 0x000fe2000fffe010ULL,
0x01c60825290075a7ULL, 0x008ea40008040146ULL, 0x0000011c00d4a947ULL, 0x006fea0003800000ULL,
0x01c0000010257984ULL, 0x000e620000000800ULL, 0x00000001ff247424ULL, 0x000fe200078e00ffULL,
0x0000000000737919ULL, 0x000ea40000000000ULL, 0x01c20000104d7984ULL, 0x0006e20000000800ULL,
0x00000004ff347819ULL, 0x004fe40000011673ULL, 0x000000082500720bULL, 0x002fda0003f5d000ULL,
0x0000000000117806ULL, 0x000fc800010e0100ULL, 0x0000ffff11297812ULL, 0x000fe4000784c0ffULL,
0x0000000864117812ULL, 0x000fe400078ef873ULL, 0x0000000864647812ULL, 0x000fe400078ef873ULL,
0x0000000734287812ULL, 0x000fce00078e7811ULL, 0x0000000000d4a947ULL, 0x008fea0003800000ULL,
0x000000082500720bULL, 0x000fe40003f54000ULL, 0x00000025082b7209ULL, 0x000fe40007810000ULL,
0x00000002ff267819ULL, 0x000fc60000011673ULL, 0x8000002b08247221ULL, 0x100fe40000010000ULL,
0x0000000826277836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b24247820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x00000010ff007c0cULL, 0x000fe4000bf45270ULL,
0x0000ffff08087812ULL, 0x000fe200078e3cffULL, 0x0000002400247308ULL, 0x000e660000000800ULL,
0x0000000829ff7212ULL, 0x000fe2000786c0ffULL, 0x000000ffff087224ULL, 0x000fcc00078e002bULL,
0x01c4002b1000a388ULL, 0x000fe80000000800ULL, 0x00001f2724277589ULL, 0x002e6400000e0000ULL,
0x8000002b25253221ULL, 0x000fe20000010000ULL, 0x0000002407077220ULL, 0x000fe20000410000ULL,
0x00001f2624267589ULL, 0x0004e400000e0000ULL, 0x3fb8aa3b25253820ULL, 0x000fc80000410000ULL,
0x00000025005c3308ULL, 0x000f220000000800ULL, 0x00000001ff247807ULL, 0x004fe20001800000ULL,
0x0000002723237220ULL, 0x082fe20000410000ULL, 0x0000002722227220ULL, 0x080fe20000410000ULL,
0x0000002733337220ULL, 0x080fe20000410000ULL, 0x0000002732327220ULL, 0x080fe20000410000ULL,
0x000000271f1f7220ULL, 0x080fe20000410000ULL, 0x000000271e1e7220ULL, 0x080fe20000410000ULL,
0x000000271b1b7220ULL, 0x080fe20000410000ULL, 0x000000271a1a7220ULL, 0x080fe20000410000ULL,
0x0000002717177220ULL, 0x080fe20000410000ULL, 0x0000002716167220ULL, 0x080fe20000410000ULL,
0x000000273f3f7220ULL, 0x080fe20000410000ULL, 0x000000273e3e7220ULL, 0x080fe20000410000ULL,
0x0000002743437220ULL, 0x080fe20000410000ULL, 0x0000002742427220ULL, 0x080fe20000410000ULL,
0x000000272f2f7220ULL, 0x080fe20000410000ULL, 0x000000272e2e7220ULL, 0x000fe20000410000ULL,
0x0000002621217220ULL, 0x088fe20000410000ULL, 0x0000002620207220ULL, 0x080fe20000410000ULL,
0x0000002631317220ULL, 0x080fe20000410000ULL, 0x0000002630307220ULL, 0x080fe20000410000ULL,
0x000000261d1d7220ULL, 0x080fe20000410000ULL, 0x000000261c1c7220ULL, 0x080fe20000410000ULL,
0x0000002619197220ULL, 0x080fe20000410000ULL, 0x0000002618187220ULL, 0x080fe20000410000ULL,
0x0000002615157220ULL, 0x080fe20000410000ULL, 0x0000002614147220ULL, 0x080fe20000410000ULL,
0x000000263d3d7220ULL, 0x080fe20000410000ULL, 0x000000263c3c7220ULL, 0x080fe20000410000ULL,
0x0000002641417220ULL, 0x080fe20000410000ULL, 0x0000002640407220ULL, 0x080fe20000410000ULL,
0x000000262d2d7220ULL, 0x080fe20000410000ULL, 0x000000262c2c7220ULL, 0x000fe20000410000ULL,
0x0000005c4d4d3220ULL, 0x010fce0000410000ULL, 0x0000000811287824ULL, 0x000fe200078e0228ULL,
0x0000000734617812ULL, 0x000fe200078e7864ULL, 0x0001400015157890ULL, 0x000fe2000fffe03fULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000628777c11ULL, 0x000fe2000f8e20ffULL,
0x0000000864697824ULL, 0x000fe200078e0261ULL, 0x00000002ff257819ULL, 0x000fe20000011673ULL,
0x0000000234657836ULL, 0x000fe20000000000ULL, 0x0000005cff4c723eULL, 0x000fe200000000ffULL,
0x012000007728783bULL, 0x000fe20000000200ULL, 0x0000001569787c11ULL, 0x000fe2000f8e20ffULL,
0x0000000825747836ULL, 0x000fe20000000000ULL, 0x000054104c4c7816ULL, 0x000fe2000000004cULL,
0x00000004345b7836ULL, 0x000fe20000000000ULL, 0x0000991024247816ULL, 0x000fe200000000ffULL,
0x000000007844783bULL, 0x000fe20000004200ULL, 0x00000006345d7836ULL, 0x000fe20000000000ULL,
0x00000007655a7812ULL, 0x000fc400078e7864ULL, 0x00001f254c4a7589ULL, 0x0002a200000e0000ULL,
0x000000ff2400720cULL, 0x000fe40003f45270ULL, 0x000000075b5b7812ULL, 0x000fe200078e7864ULL,
0x00001f744c497589ULL, 0x000ee200000e0000ULL, 0x000000075d5d7812ULL, 0x000fe200078e7864ULL,
0x00000008646a7824ULL, 0x040fe400078e025aULL, 0x00000008646d7824ULL, 0x040fe400078e025bULL,
0x00000008646c7824ULL, 0x040fe200078e025dULL, 0x0000008064647811ULL, 0x000fc400078e18ffULL,
0x000000156a7a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000156c257c11ULL, 0x002fe2000f8e20ffULL,
0x000000015b5b7824ULL, 0x100fe200078e0264ULL, 0x000000156d7d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000015d5d7824ULL, 0x100fe200078e0264ULL, 0x000000007a38783bULL, 0x000e620000004200ULL,
0x00000001616b7824ULL, 0x100fe200078e0264ULL, 0x000000155b667c11ULL, 0x000fe2000f8e20ffULL,
0x000000015a5a7824ULL, 0x000fe200078e0264ULL, 0x0000082501007387ULL, 0x000fe40000100800ULL,
0x000000156b797c11ULL, 0x000fc4000f8e20ffULL, 0x00000c6601007387ULL, 0x000fe20000100800ULL,
0x000000155a7b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000004a2828a232ULL, 0x084fe40000000000ULL,
0x000000007d34783bULL, 0x000ea20000004200ULL, 0x0000004a2a2aa232ULL, 0x000fe40000000000ULL,
0x000000492929a232ULL, 0x088fe20000000000ULL, 0x000000002524783bULL, 0x000ee20000004200ULL,
0x000000492b2ba232ULL, 0x000fce0000000000ULL, 0x00000044282c723cULL, 0x000fec000000182cULL,
0x000000462840723cULL, 0x000fe20000001840ULL, 0x000000155d447c11ULL, 0x000fca000f8e20ffULL,
0x0000004401007387ULL, 0x000fe80000100800ULL, 0x0000040001727983ULL, 0x0009220000100800ULL,
0x00000038283c723cULL, 0x002fe6000000183cULL, 0x000000004444783bULL, 0x000fe60000004200ULL,
0x0000003a2814723cULL, 0x000fe20000001814ULL, 0x0000000765387812ULL, 0x000fca00078e7811ULL,
0x0000000811387824ULL, 0x000fe200078e0238ULL, 0x000000342818723cULL, 0x004fe80000001818ULL,
0x00000006387c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000362834723cULL, 0x000fe2000000181cULL,
0x000000007938783bULL, 0x000fe80000004200ULL, 0x012000007c1c783bULL, 0x000e620000000200ULL,
0x000000242830723cULL, 0x008fec0000001830ULL, 0x000000262820723cULL, 0x000fe20000001820ULL,
0x000000007b24783bULL, 0x000ea80000004200ULL, 0x000000006628783bULL, 0x000ee20000004200ULL,
0x00000000630b92caULL, 0x020fe200000e0000ULL, 0xffffffff000a7882ULL, 0x000fe20000000000ULL,
0x000000074d077221ULL, 0x000fd60000010000ULL, 0x0000000b000a8c82ULL, 0x000fe40008000000ULL,
0x000000090a0b72a4ULL, 0x000fc8000f8e023fULL, 0x000000060b0b7899ULL, 0x000fe2000800063fULL,
0x0000004a1c1ca232ULL, 0x082fe40000000000ULL, 0x0000004a1e1ea232ULL, 0x000fe40000000000ULL,
0x000000491d1da232ULL, 0x080fe40000000000ULL, 0x000000491f1fa232ULL, 0x000fce0000000000ULL,
0x000000381c2c723cULL, 0x000fec000000182cULL, 0x0000003a1c40723cULL, 0x000fec0000001840ULL,
0x000000241c3c723cULL, 0x004fec000000183cULL, 0x000000261c14723cULL, 0x000fec0000001814ULL,
0x000000281c18723cULL, 0x008fec0000001818ULL, 0x0000002a1c34723cULL, 0x000fec0000001834ULL,
0x000000441c30723cULL, 0x000fec0000001830ULL, 0x000000461c20723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400448947ULL, 0x010fde0003800000ULL, 0x0000000eff1d7e24ULL, 0x000fe2000f8e00ffULL,
0x00000040721c7811ULL, 0x000fe400078e40ffULL, 0x000000154b677c11ULL, 0x000fe2000f8e20ffULL,
0x000000401d247824ULL, 0x000fe200078e0206ULL, 0x000000141c257c48ULL, 0x000fe2000ffe0000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e0a1cULL, 0x0000001513637c11ULL, 0x000fe2000f8e20ffULL,
0x0000000424717836ULL, 0x040fe20000000000ULL, 0x0000000b241e7c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010246e7836ULL, 0x040fe20000000000ULL, 0x0000002025257446ULL, 0x000fe2000380002aULL,
0x0000000824707836ULL, 0x000fe20000000000ULL, 0x0000000b711d7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x000000161e287c11ULL, 0x000fe2000f8248ffULL,
0x0000001424687836ULL, 0x040fe20000000000ULL, 0x0000000b702b7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x000000161d267c11ULL, 0x040fe2000f8648ffULL,
0x0000000c246f7836ULL, 0x000fe20000000000ULL, 0x000000171e297c11ULL, 0x000fe200088f4c1fULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x000000171d277c11ULL, 0x000fe200098f4c1cULL,
0x0000001824657836ULL, 0x000fe20000000000ULL, 0x0000000b6e1f7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x000000250600720cULL, 0x000fc40003f26070ULL,
0x000000162b2a7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x000000161f1e7c11ULL, 0x000fe2000f8648ffULL, 0x000000100d267825ULL, 0x000fe200078e0026ULL,
0x000000172b2b7c11ULL, 0x000fe4000a0f4c44ULL, 0x000000171f1f7c11ULL, 0x000fe200098f4c38ULL,
0x0000001c24647836ULL, 0x000fe20000000000ULL, 0x000000250500720cULL, 0x080fe20003f66070ULL,
0x000000100d2a7825ULL, 0x040fe200078e002aULL, 0x0000000b68137c10ULL, 0x000fe2000ff9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028677faeULL, 0x0003e2000c901c4cULL,
0x000000250400720cULL, 0x000fe20003f26070ULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x0000000b6f1d7c10ULL, 0x000fc4000ffbe0ffULL, 0x0000001548667c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x000000250e00720cULL, 0x000fe20003fc6070ULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x000000161d1c7c11ULL, 0x000fe2000f8a48ffULL,
0x0000000026667faeULL, 0x000fe2000d901c4cULL, 0x0000001512617c11ULL, 0x000fe4000f8e20ffULL,
0x0000001613287c11ULL, 0x002fe2000f8848ffULL, 0x000000002a637faeULL, 0x0003e2000c901c4cULL,
0x000000171d1d7c11ULL, 0x000fc4000a8f4c3aULL, 0x0000001713297c11ULL, 0x000fe4000a0f4c38ULL,
0x0000000b65397c10ULL, 0x000fe2000ff9e0ffULL, 0x000000100d1c7825ULL, 0x000fe200078e001cULL,
0x0000000b64137c10ULL, 0x000fe4000ff7e0ffULL, 0x000000250b00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x000000250000720cULL, 0x000fe20003f86070ULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00000016392a7c11ULL, 0x002fe2000f8248ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000001613387c11ULL, 0x000fc4000f8648ffULL,
0x00000017392b7c11ULL, 0x000fe400088f4c44ULL, 0x0000001713397c11ULL, 0x000fe400098f4c3aULL,
0x000000250300720cULL, 0x080fe20003f26070ULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x000000250200720cULL, 0x000fe40003f66070ULL, 0x0000001509267c11ULL, 0x000fe2000f8e20ffULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x000000150a257c11ULL, 0x000fc4000f8e20ffULL,
0x000000150c0c7c11ULL, 0x000fe4000f8e20ffULL, 0x000000150f0f7c11ULL, 0x000fc6000f8e20ffULL,
0x000000001c617faeULL, 0x0003e8000c901c4cULL, 0x000000001e267faeULL, 0x0003e8000d901c4cULL,
0x0000000028257faeULL, 0x0003e8000e101c4cULL, 0x000000002a0c7faeULL, 0x0003e8000e901c4cULL,
0x00000000380f7faeULL, 0x0003e2000f101c4cULL, 0x0000000400107947ULL, 0x000fea0003800000ULL,
0x0000000eff1d7e24ULL, 0x000fe2000f8e00ffULL, 0x000000154b677c11ULL, 0x000fe4000f8e20ffULL,
0x0000001548667c11ULL, 0x000fe2000f8e20ffULL, 0x000000401d247824ULL, 0x000fe200078e0206ULL,
0x0000001513637c11ULL, 0x000fe4000f8e20ffULL, 0x0000001512617c11ULL, 0x000fe2000f8e20ffULL,
0x0000000424717836ULL, 0x040fe20000000000ULL, 0x0000000b241c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000824707836ULL, 0x000fe20000000000ULL, 0x000000150c0c7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c246f7836ULL, 0x000fe20000000000ULL, 0x0000000b711e7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x000000161c387c11ULL, 0x000fe2000f8248ffULL,
0x00000010246e7836ULL, 0x000fe20000000000ULL, 0x000000150f0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0x000000171c397c11ULL, 0x000fe200088f4c1dULL,
0x0000001424687836ULL, 0x000fe20000000000ULL, 0x000000161e2a7c11ULL, 0x000fe2000f8648ffULL,
0x0000001824657836ULL, 0x040fe20000000000ULL, 0x0000000b701d7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001c24647836ULL, 0x000fe20000000000ULL, 0x000000171e2b7c11ULL, 0x000fe200098f4c1fULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x0000000b6f1f7c10ULL, 0x000fc4000ff7e0ffULL,
0x0000000b6e257c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x000000161d267c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x000000161f1c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff447224ULL, 0x000fe200020e06ffULL,
0x000000171d277c11ULL, 0x000fe200088f4c28ULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x0000000b68297c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038677faeULL, 0x0003e2000b901c4cULL, 0x000000171f1d7c11ULL, 0x000fe200098f4c3aULL,
0x000000100d267825ULL, 0x000fe200078e0026ULL, 0x00000016251e7c11ULL, 0x000fe2000f8848ffULL,
0x000000002a667faeULL, 0x0005e2000b901c4cULL, 0x0000000b64137c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000001629287c11ULL, 0x000fe2000f8248ffULL,
0x0000000026637faeULL, 0x0007e2000b901c4cULL, 0x00000017251f7c11ULL, 0x000fe2000a0f4c44ULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x0000001729297c11ULL, 0x000fe200088f4c3aULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x0000000b65257c10ULL, 0x000fc4000ff3e0ffULL,
0x0000001613387c11ULL, 0x002fe2000f8648ffULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x000000001c617faeULL, 0x0003e4000b901c4cULL, 0x0000001713397c11ULL, 0x000fe200098f4c44ULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00000016252a7c11ULL, 0x004fe2000f8248ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000001509267c11ULL, 0x008fe4000f8e20ffULL,
0x00000017252b7c11ULL, 0x000fe200088f4c3aULL, 0x000000100d387825ULL, 0x040fe200078e0038ULL,
0x000000150a257c11ULL, 0x000fe2000f8e20ffULL, 0x000000001e267faeULL, 0x0003e4000b901c4cULL,
0x000000100d2a7825ULL, 0x000fc400078e002aULL, 0x0000000028257faeULL, 0x0003e8000b901c4cULL,
0x000000002a0c7faeULL, 0x0003e8000b901c4cULL, 0x00000000380f7faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004730a7811ULL, 0x000fe200078fe0ffULL,
0x000000ffff127224ULL, 0x000fe200078e0072ULL, 0x0000001969757c11ULL, 0x000fe2000f8e20ffULL,
0x00000001ff4d7424ULL, 0x000fe200078e00ffULL, 0x000000070a0a7812ULL, 0x000fe400078e7811ULL,
0x00000002ff097819ULL, 0x000fe40000011673ULL, 0x000000196c727c11ULL, 0x000fe2000f8e20ffULL,
0x00000008110a7824ULL, 0x000fe200078e020aULL, 0x000000196b6c7c11ULL, 0x000fc4000f8e20ffULL,
0x00001f094c097589ULL, 0x000fe200000e0000ULL, 0x000000195a6b7c11ULL, 0x000fe4000f8e20ffULL,
0x000000060a767c11ULL, 0x000fe2000f8e20ffULL, 0x00001f744c4c7589ULL, 0x0005e200000e0000ULL,
0x00000006730a7811ULL, 0x000fe400078fe0ffULL, 0x000000196d737c11ULL, 0x000fe4000f8e20ffULL,
0x000000070a0a7812ULL, 0x000fe200078e7811ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01200000761c783bULL, 0x002e620000000200ULL, 0x000000196a747c11ULL, 0x004fe2000f8e20ffULL,
0x00000008110a7824ULL, 0x000fe200078e020aULL, 0x000000195b6a7c11ULL, 0x000fe2000f8e20ffULL,
0x000000007528783bULL, 0x000ea20000004200ULL, 0x000000195d697c11ULL, 0x000fe4000f8e20ffULL,
0x000000060a6d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000007438783bULL, 0x000ee80000004200ULL,
0x000000007348783bULL, 0x000f280000004200ULL, 0x000000007244783bULL, 0x000f620000004200ULL,
0x000000091c1ca232ULL, 0x002fc40000000000ULL, 0x000000091e1ea232ULL, 0x000fe40000000000ULL,
0x0000004c1d1da232ULL, 0x080fe40000000000ULL, 0x0000004c1f1fa232ULL, 0x000fce0000000000ULL,
0x000000281c2c723cULL, 0x004fec000000182cULL, 0x0000002a1c40723cULL, 0x000fe20000001840ULL,
0x012000006d28783bULL, 0x000e6a0000000200ULL, 0x000000381c3c723cULL, 0x008fec000000183cULL,
0x0000003a1c14723cULL, 0x000fe20000001814ULL, 0x000000006938783bULL, 0x000eaa0000004200ULL,
0x000000481c18723cULL, 0x010fec0000001818ULL, 0x0000004a1c34723cULL, 0x000fe20000001834ULL,
0x000000006c48783bULL, 0x000eea0000004200ULL, 0x000000441c30723cULL, 0x020fec0000001830ULL,
0x000000461c20723cULL, 0x000fe20000001820ULL, 0x000000006a1c783bULL, 0x000f280000004200ULL,
0x000000006b44783bULL, 0x000f620000004200ULL, 0x000000092828a232ULL, 0x082fe20000000000ULL,
0x01c6884dffff79a7ULL, 0x0003e20008500006ULL, 0x000000092a2aa232ULL, 0x000fe20000000000ULL,
0x0000004012097811ULL, 0x000fe200078e40ffULL, 0x0000004c2929a232ULL, 0x000fc40000000000ULL,
0x0000004c2b2ba232ULL, 0x000fe20000000000ULL, 0x0000001409007c0cULL, 0x000fcc000bf26070ULL,
0x000000382830723cULL, 0x004fec0000001830ULL, 0x0000003a2820723cULL, 0x000fec0000001820ULL,
0x00000048282c723cULL, 0x008fec000000182cULL, 0x0000004a2840723cULL, 0x000fec0000001840ULL,
0x0000001c2818723cULL, 0x010fec0000001818ULL, 0x00000044283c723cULL, 0x020fec000000183cULL,
0x000000462814723cULL, 0x000fec0000001814ULL, 0x0000001e281c723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000004c003c1947ULL, 0x002fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400008947ULL, 0x000fea0003800000ULL,
0x0000000b62117c10ULL, 0x000fe2000ff3e0ffULL, 0x0000002009097836ULL, 0x000fe20000000000ULL,
0x0000000b59277c10ULL, 0x000fc6000ff7e0ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000001611347c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x00000014090a7c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff097224ULL, 0x000fe200078e0a09ULL,
0x0000001711357c11ULL, 0x000fe400088f4c12ULL, 0x0000000b5f297c10ULL, 0x000fe4000ff3e0ffULL,
0x000000200a097446ULL, 0x000fe20003800009ULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0000000b570a7c10ULL, 0x000fc4000ff9e0ffULL, 0x00000016292a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x000000090600720cULL, 0x000fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000001627287c11ULL, 0x000fe4000f8648ffULL,
0x0000000b55117c10ULL, 0x000fe4000ffbe0ffULL, 0x000000160a127c11ULL, 0x000fe4000f8848ffULL,
0x00000017292b7c11ULL, 0x000fe200090f4c38ULL, 0x000000ffff387224ULL, 0x000fe200028e06ffULL,
0x0000001727297c11ULL, 0x000fc400098f4c36ULL, 0x000000090500720cULL, 0x080fe20003f66070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034607faeULL, 0x0003e2000c901c4cULL,
0x000000170a137c11ULL, 0x000fe2000a0f4c13ULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x0000001611367c11ULL, 0x000fe4000f8848ffULL, 0x0000000b530a7c10ULL, 0x000fe2000ffbe0ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x000000090400720cULL, 0x080fe40003f46070ULL,
0x0000001711377c11ULL, 0x000fe2000a0f4c38ULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0x000000090b00720cULL, 0x080fe20003f86070ULL, 0x000000002a5e7faeULL, 0x0005e2000d901c4cULL,
0x000000160a347c11ULL, 0x002fe2000f8248ffULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x000000090e00720cULL, 0x000fc40003fa6070ULL, 0x000000170a357c11ULL, 0x000fe200088f4c11ULL,
0x000000100d367825ULL, 0x040fe200078e0036ULL, 0x0000000b51277c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000028587faeULL, 0x0003e2000d101c4cULL, 0x0000000b4f0a7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d347825ULL, 0x000fc800078e0034ULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x00000016272a7c11ULL, 0x044fe2000f8248ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x000000090000720cULL, 0x080fe40003f66070ULL, 0x00000017272b7c11ULL, 0x000fe400088f4c38ULL,
0x000000160a287c11ULL, 0x042fe4000f8448ffULL, 0x000000090300720cULL, 0x000fe20003f26070ULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x000000170a297c11ULL, 0x000fc400090f4c11ULL,
0x000000090200720cULL, 0x000fe20003f46070ULL, 0x000000100d287825ULL, 0x000fd000078e0028ULL,
0x0000000012567faeULL, 0x0003e8000c901c4cULL, 0x0000000036547faeULL, 0x0003e8000d101c4cULL,
0x0000000034527faeULL, 0x0003e8000d901c4cULL, 0x000000002a507faeULL, 0x0003e8000e101c4cULL,
0x00000000284e7faeULL, 0x0003e2000e901c4cULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000000b62097c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000b5f117c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000b59277c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001609127c11ULL, 0x000fc6000f8248ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000001709137c11ULL, 0x000fe200088f4c0aULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x0000001611347c11ULL, 0x000fe4000f8248ffULL, 0x0000001627367c11ULL, 0x000fe2000f8448ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000001711357c11ULL, 0x000fe400088f4c0aULL,
0x0000001727377c11ULL, 0x000fe400090f4c28ULL, 0x0000000b57097c10ULL, 0x000fe2000ff3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012607faeULL, 0x0003e2000b901c4cULL,
0x0000000b55117c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0000000b53277c10ULL, 0x000fc6000ff7e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00000000345e7faeULL, 0x0005e2000b901c4cULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x0000001611287c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00000016272a7c11ULL, 0x000fe2000f8648ffULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x0000001609127c11ULL, 0x002fe4000f8248ffULL, 0x0000001711297c11ULL, 0x000fe400090f4c38ULL,
0x0000001709137c11ULL, 0x000fe200088f4c0aULL, 0x0000000036587faeULL, 0x0003e2000b901c4cULL,
0x0000000b51097c10ULL, 0x000fe2000ff3e0ffULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x0000000b4f117c10ULL, 0x000fc4000ff5e0ffULL, 0x00000017272b7c11ULL, 0x000fe200098f4c3aULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001609347c11ULL, 0x004fe2000f8248ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x0000001611387c11ULL, 0x000fe2000f8448ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000001709357c11ULL, 0x000fe400088f4c0aULL,
0x0000001711397c11ULL, 0x000fe200090f4c3aULL, 0x000000100d2a7825ULL, 0x040fe200078e002aULL,
0x0000000012567faeULL, 0x0003e6000b901c4cULL, 0x000000100d347825ULL, 0x040fe200078e0034ULL,
0x0000000028547faeULL, 0x0003e6000b901c4cULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x000000002a527faeULL, 0x0003e8000b901c4cULL, 0x0000000034507faeULL, 0x0003e8000b901c4cULL,
0x00000000384e7faeULL, 0x0003e4000b901c4cULL, 0x00000003070a7892ULL, 0x000fe2000f8ec03fULL,
0x00000012ff097e24ULL, 0x000fc6000f8e00ffULL, 0x000000030a00788cULL, 0x000fc8000bf05270ULL,
0x000000010f0a7887ULL, 0x000fc8000c000000ULL, 0x0000000a07077290ULL, 0x000fc6000fffe03fULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f2f008ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000807137290ULL, 0x000fe2000fffe03fULL, 0x00008c00000a7ab9ULL, 0x000fc60000000a00ULL,
0x00000004130a78a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff127e24ULL, 0x002fe4000f8e00ffULL,
0x0000000bff137e24ULL, 0x000fca000f8e00ffULL, 0x0000000c12127981ULL, 0x000ea4000c1e1900ULL,
0x00000000120a72caULL, 0x004fde00000e0000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c6284d091279a7ULL, 0x0022a40008500006ULL, 0x00000012ff097e24ULL, 0x002fc8000f8e00ffULL,
0x01c62813090075a7ULL, 0x004e640008020146ULL, 0x00000100001c9947ULL, 0x002fea0003800000ULL,
0x01c0800010097984ULL, 0x000e620000000800ULL, 0x0000000000117919ULL, 0x000ea40000000000ULL,
0x00000002ff5a7819ULL, 0x004fe20000011611ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x000000080900720bULL, 0x002fc60003f3d000ULL, 0x000000085a4c7836ULL, 0x000fd40000000000ULL,
0x00000000000a7806ULL, 0x000fc800008e0100ULL, 0x0000ffff0a137812ULL, 0x000fe4000782c0ffULL,
0x01c28000100a7984ULL, 0x0002b60000000800ULL, 0x0000000000d49947ULL, 0x002fea0003800000ULL,
0x000000080900720bULL, 0x000fe20003f34000ULL, 0x000000011000788cULL, 0x000fe2000bf05270ULL,
0x0000000908117209ULL, 0x000fca0007810000ULL, 0x8000001108127221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f4f008ULL, 0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fc800008e0100ULL, 0x0000ffff08287812ULL, 0x000fe200078e3cffULL,
0x0000001200127308ULL, 0x000e660000000800ULL, 0x0000002813ff7212ULL, 0x000fe2000782c0ffULL,
0x01c480111000a388ULL, 0x000fe80000000800ULL, 0x00001f5a12087589ULL, 0x002e7000000e0000ULL,
0x8000001109131221ULL, 0x000fe20000010000ULL, 0x0000001207077220ULL, 0x000fe20000410000ULL,
0x00001f4c12097589ULL, 0x00072400000e0000ULL, 0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL,
0x00000013005c1308ULL, 0x000f620000000800ULL, 0x00000001ff127807ULL, 0x008fe20000800000ULL,
0x000000082c2c7220ULL, 0x082fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fc400078e0011ULL, 0x000000092e2e7220ULL, 0x090fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x0000000942427220ULL, 0x080fe20000410000ULL,
0x0000000943437220ULL, 0x080fe20000410000ULL, 0x000000093e3e7220ULL, 0x080fe20000410000ULL,
0x000000093f3f7220ULL, 0x080fe20000410000ULL, 0x0000000916167220ULL, 0x080fe20000410000ULL,
0x0000000917177220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x080fe20000410000ULL,
0x000000091b1b7220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x080fe20000410000ULL, 0x0000000932327220ULL, 0x080fe20000410000ULL,
0x0000000933337220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x000fe20000410000ULL, 0x0000761012117816ULL, 0x000fe20000000011ULL,
0x0000000a5c0a1220ULL, 0x024fce0000410000ULL, 0x0000080001487983ULL, 0x000ee20000100800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000c0001277983ULL, 0x000f280000100800ULL,
0x0000000001137983ULL, 0x004ea20000100800ULL, 0x0000005cff09723eULL, 0x000fe400000000ffULL,
0x0000991011117816ULL, 0x000fe200000000ffULL, 0x00000400014d7983ULL, 0x0003620000100800ULL,
0x0000541009097816ULL, 0x000fe40000000009ULL, 0x000000ff1100720cULL, 0x000fe20003f25270ULL,
0x012800007728783bULL, 0x000fe80000000200ULL, 0x000000007844783bULL, 0x000fe80000004200ULL,
0x00001f5a09117589ULL, 0x000e6800000e0000ULL, 0x00001f4c09127589ULL, 0x000e6800000e0000ULL,
0x000000007a38783bULL, 0x000e680000004200ULL, 0x000000007d34783bULL, 0x000e640000004200ULL,
0x0000001128289232ULL, 0x002fc40000000000ULL, 0x000000112a2a9232ULL, 0x000fe40000000000ULL,
0x0000001229299232ULL, 0x080fe40000000000ULL, 0x000000122b2b9232ULL, 0x000fce0000000000ULL,
0x00000044282c723cULL, 0x000fec000000182cULL, 0x000000462840723cULL, 0x000fec0000001840ULL,
0x00000038283c723cULL, 0x000fec000000183cULL, 0x0000003a2814723cULL, 0x000fe20000001814ULL,
0x012800007c38783bULL, 0x000e6a0000000200ULL, 0x000000342818723cULL, 0x000fec0000001818ULL,
0x000000362834723cULL, 0x000fe2000000181cULL, 0x00000000791c783bULL, 0x000e620000004200ULL,
0x000000090a0b72a4ULL, 0x000fe2000f8e023fULL, 0x000000070a077221ULL, 0x000fc60000010000ULL,
0x000000060b0b7899ULL, 0x000fe2000800063fULL, 0x0000001138389232ULL, 0x082fe40000000000ULL,
0x000000113a3a9232ULL, 0x000fe40000000000ULL, 0x0000001239399232ULL, 0x080fe40000000000ULL,
0x000000123b3b9232ULL, 0x000fce0000000000ULL, 0x0000001c382c723cULL, 0x000fec000000182cULL,
0x0000001e3840723cULL, 0x000fe20000001840ULL, 0x000000004844783bULL, 0x008e680000004200ULL,
0x000000007b48783bULL, 0x000ee20000004200ULL, 0x000000442830723cULL, 0x002fec0000001830ULL,
0x000000462820723cULL, 0x000fe20000001820ULL, 0x000000002728783bULL, 0x010e680000004200ULL,
0x000000001344783bULL, 0x004ea20000004200ULL, 0x00000048383c723cULL, 0x008fec000000183cULL,
0x0000004a3814723cULL, 0x000fec0000001814ULL, 0x000000283818723cULL, 0x002fec0000001818ULL,
0x0000002a3834723cULL, 0x000fec0000001834ULL, 0x000000443830723cULL, 0x004fec0000001830ULL,
0x000000463838723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400008947ULL, 0x000fde0003800000ULL,
0x0000000b24137c10ULL, 0x000fe4000ff5e0ffULL, 0x000000804d0a7811ULL, 0x020fe400078e40ffULL,
0x0000000b71127c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x000000140a117c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0a0aULL,
0x0000001613207c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x00000016121e7c11ULL, 0x000fc4000f8648ffULL, 0x0000001713217c11ULL, 0x000fe400090f4c1cULL,
0x00000020110a7446ULL, 0x000fe4000380000aULL, 0x0000000b70137c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d207825ULL, 0x040fe200078e0020ULL, 0x00000017121f7c11ULL, 0x000fe400098f4c1dULL,
0x0000000a0600720cULL, 0x080fe20003f66070ULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x0000000b6f117c10ULL, 0x000fe2000ffbe0ffULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x0000000a0500720cULL, 0x000fc40003f46070ULL, 0x00000016131c7c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x0000001611127c11ULL, 0x000fe4000f8a48ffULL,
0x00000017131d7c11ULL, 0x000fe4000a0f4c28ULL, 0x0000001711137c11ULL, 0x000fe2000a8f4c22ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x000fe2000d901c4cULL,
0x0000000b6e237c10ULL, 0x000fe2000ff9e0ffULL, 0x000000100d1c7825ULL, 0x000fe200078e001cULL,
0x0000000b68117c10ULL, 0x000fe2000ffbe0ffULL, 0x000000001e667faeULL, 0x0003e2000d101c4cULL,
0x0000000a0400720cULL, 0x080fe20003f66070ULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x0000001611227c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x0000000a0b00720cULL, 0x080fe20003fa6070ULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x0000000a0e00720cULL, 0x000fc40003fc6070ULL, 0x00000016231e7c11ULL, 0x002fca000f8448ffULL,
0x000000001c637faeULL, 0x0003e2000d901c4cULL, 0x00000017231f7c11ULL, 0x000fe400090f4c2aULL,
0x0000000b65217c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001711237c11ULL, 0x000fe2000a0f4c28ULL,
0x000000100d1e7825ULL, 0x000fe200078e001eULL, 0x0000000b64117c10ULL, 0x000fc6000ff9e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x0000001621207c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00000016111c7c11ULL, 0x002fe2000f8648ffULL,
0x000000100d227825ULL, 0x000fe200078e0022ULL, 0x0000001721217c11ULL, 0x000fe400090f4c2aULL,
0x00000017111d7c11ULL, 0x000fe400098f4c28ULL, 0x0000000a0300720cULL, 0x080fe20003f46070ULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x0000000a0200720cULL, 0x000fc40003f66070ULL,
0x0000000a0000720cULL, 0x000fe20003f86070ULL, 0x000000100d1c7825ULL, 0x000fd000078e001cULL,
0x0000000012617faeULL, 0x0003e8000d101c4cULL, 0x000000001e267faeULL, 0x0003e8000d901c4cULL,
0x0000000022257faeULL, 0x0003e8000e101c4cULL, 0x00000000200c7faeULL, 0x0003e8000e901c4cULL,
0x000000001c0f7faeULL, 0x0003e2000f101c4cULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000000b240a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000b71127c10ULL, 0x000fe4000ff7e0ffULL,
0x0000000b701d7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000160a207c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x000000161d1c7c11ULL, 0x000fe4000f8648ffULL, 0x000000170a217c11ULL, 0x000fe200090f4c11ULL,
0x000000ffff0a7224ULL, 0x000fe200020e06ffULL, 0x0000000b6f117c10ULL, 0x000fc4000ff9e0ffULL,
0x00000016121e7c11ULL, 0x040fe2000f8448ffULL, 0x000000100d207825ULL, 0x000fe200078e0020ULL,
0x000000171d1d7c11ULL, 0x000fe400098f4c0aULL, 0x00000017121f7c11ULL, 0x000fe200090f4c13ULL,
0x000000ffff0a7224ULL, 0x000fe200020e06ffULL, 0x0000001611127c11ULL, 0x000fe2000f8448ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020677faeULL, 0x0003e2000b901c4cULL,
0x0000000b6e237c10ULL, 0x000fe2000ffbe0ffULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x0000001711137c11ULL, 0x000fc400090f4c0aULL, 0x0000000b680a7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x0000001623227c11ULL, 0x000fe2000f8648ffULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x000000001e667faeULL, 0x0005e4000b901c4cULL,
0x0000001723237c11ULL, 0x000fe200098f4c28ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000160a207c11ULL, 0x042fe2000f8448ffULL, 0x000000001c637faeULL, 0x0003e2000b901c4cULL,
0x0000000b64277c10ULL, 0x000fe2000ff7e0ffULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x000000170a217c11ULL, 0x000fc400090f4c11ULL, 0x0000000b650a7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x0000000012617faeULL, 0x0007e2000b901c4cULL,
0x000000100d227825ULL, 0x000fc800078e0022ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x000000160a1e7c11ULL, 0x044fe2000f8448ffULL, 0x000000100d207825ULL, 0x000fe200078e0020ULL,
0x00000016271c7c11ULL, 0x042fe2000f8648ffULL, 0x0000000022267faeULL, 0x0007e2000b901c4cULL,
0x000000170a1f7c11ULL, 0x000fe400090f4c11ULL, 0x00000017271d7c11ULL, 0x000fe200098f4c28ULL,
0x0000000020257faeULL, 0x0007e2000b901c4cULL, 0x000000100d1e7825ULL, 0x000fc800078e001eULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x000000001e0c7faeULL, 0x0007e8000b901c4cULL,
0x000000001c0f7faeULL, 0x0007e4000b901c4cULL, 0x00000000000079afULL, 0x000e280000000000ULL,
0x00001f5a090a7589ULL, 0x000fe800000e0000ULL, 0x00001f4c09097589ULL, 0x0005e400000e0000ULL,
0x00000001ff4c7424ULL, 0x004fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x01280000761c783bULL, 0x00ae680000000200ULL, 0x000000007520783bULL, 0x000ea80000004200ULL,
0x000000007428783bULL, 0x000ee80000004200ULL, 0x000000007348783bULL, 0x000f280000004200ULL,
0x000000007244783bULL, 0x000ee20000004200ULL, 0x0000000a1c1c9232ULL, 0x002fc40000000000ULL,
0x0000000a1e1e9232ULL, 0x000fe40000000000ULL, 0x000000091d1d9232ULL, 0x080fe40000000000ULL,
0x000000091f1f9232ULL, 0x000fce0000000000ULL, 0x000000201c2c723cULL, 0x004fec000000182cULL,
0x000000221c40723cULL, 0x000fe20000001840ULL, 0x012800006d20783bULL, 0x000e6a0000000200ULL,
0x000000281c3c723cULL, 0x008fec000000183cULL, 0x0000002a1c14723cULL, 0x000fe20000001814ULL,
0x000000006928783bULL, 0x000eaa0000004200ULL, 0x000000481c18723cULL, 0x010fec0000001818ULL,
0x0000004a1c34723cULL, 0x000fe20000001834ULL, 0x000000006c48783bULL, 0x000eea0000004200ULL,
0x000000441c30723cULL, 0x000fec0000001830ULL, 0x000000461c38723cULL, 0x000fe20000001838ULL,
0x000000006a1c783bULL, 0x000f280000004200ULL, 0x000000006b44783bULL, 0x000f220000004200ULL,
0x0000000921219232ULL, 0x082fe20000000000ULL, 0x01c6904cffff79a7ULL, 0x0003e20008500006ULL,
0x0000000923239232ULL, 0x000fe20000000000ULL, 0x000000804d097811ULL, 0x020fe200078e40ffULL,
0x0000000a20209232ULL, 0x000fc40000000000ULL, 0x0000000a22229232ULL, 0x000fe20000000000ULL,
0x0000001409007c0cULL, 0x000fcc000bf26070ULL, 0x000000282030723cULL, 0x004fec0000001830ULL,
0x00000048202c723cULL, 0x008fec000000182cULL, 0x0000004a2040723cULL, 0x000fec0000001840ULL,
0x0000001c2018723cULL, 0x010fec0000001818ULL, 0x00000044203c723cULL, 0x000fec000000183cULL,
0x000000462014723cULL, 0x000fec0000001814ULL, 0x0000001e201c723cULL, 0x000fec0000001834ULL,
0x0000002a2020723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000003000d01947ULL, 0x002fde0003800000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400008947ULL, 0x000fea0003800000ULL, 0x0000000b62117c10ULL, 0x000fe2000ff3e0ffULL,
0x0000002009097836ULL, 0x000fe20000000000ULL, 0x0000000b59277c10ULL, 0x000fc6000ff7e0ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x0000001611347c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00000014090a7c48ULL, 0x000fe2000ffe0000ULL,
0x000000ffff097224ULL, 0x000fe200078e0a09ULL, 0x0000001711357c11ULL, 0x000fe400088f4c12ULL,
0x0000000b5f297c10ULL, 0x000fe4000ff3e0ffULL, 0x000000200a097446ULL, 0x000fe20003800009ULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x0000000b570a7c10ULL, 0x000fc4000ff9e0ffULL,
0x00000016292a7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x000000090600720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000001627287c11ULL, 0x000fe4000f8648ffULL, 0x0000000b55117c10ULL, 0x000fe4000ffbe0ffULL,
0x000000160a127c11ULL, 0x000fe4000f8848ffULL, 0x00000017292b7c11ULL, 0x000fe200090f4c38ULL,
0x000000ffff387224ULL, 0x000fe200028e06ffULL, 0x0000001727297c11ULL, 0x000fc400098f4c36ULL,
0x000000090500720cULL, 0x080fe20003f66070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034607faeULL, 0x0003e2000c901c4cULL, 0x000000170a137c11ULL, 0x000fe2000a0f4c13ULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000001611367c11ULL, 0x000fe4000f8848ffULL,
0x0000000b530a7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x000000090400720cULL, 0x080fe40003f46070ULL, 0x0000001711377c11ULL, 0x000fe2000a0f4c38ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x000000090b00720cULL, 0x080fe20003f86070ULL,
0x000000002a5e7faeULL, 0x0005e2000d901c4cULL, 0x000000160a347c11ULL, 0x002fe2000f8248ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x000000090e00720cULL, 0x000fc40003fa6070ULL,
0x000000170a357c11ULL, 0x000fe200088f4c11ULL, 0x000000100d367825ULL, 0x040fe200078e0036ULL,
0x0000000b51277c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000028587faeULL, 0x0003e2000d101c4cULL,
0x0000000b4f0a7c10ULL, 0x000fe2000ff7e0ffULL, 0x000000100d347825ULL, 0x000fc800078e0034ULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00000016272a7c11ULL, 0x044fe2000f8248ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x000000090000720cULL, 0x080fe40003f66070ULL,
0x00000017272b7c11ULL, 0x000fe400088f4c38ULL, 0x000000160a287c11ULL, 0x042fe4000f8448ffULL,
0x000000090300720cULL, 0x000fe20003f26070ULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x000000170a297c11ULL, 0x000fc400090f4c11ULL, 0x000000090200720cULL, 0x000fe20003f46070ULL,
0x000000100d287825ULL, 0x000fd000078e0028ULL, 0x0000000012567faeULL, 0x0003e8000c901c4cULL,
0x0000000036547faeULL, 0x0003e8000d101c4cULL, 0x0000000034527faeULL, 0x0003e8000d901c4cULL,
0x000000002a507faeULL, 0x0003e8000e101c4cULL, 0x00000000284e7faeULL, 0x0003e2000e901c4cULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000000b62097c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000b5f117c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000b59277c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001609127c11ULL, 0x000fc6000f8248ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x0000001709137c11ULL, 0x000fe200088f4c0aULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000001611347c11ULL, 0x000fe4000f8248ffULL,
0x0000001627367c11ULL, 0x000fe2000f8448ffULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x0000001711357c11ULL, 0x000fe400088f4c0aULL, 0x0000001727377c11ULL, 0x000fe400090f4c28ULL,
0x0000000b57097c10ULL, 0x000fe2000ff3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012607faeULL, 0x0003e2000b901c4cULL, 0x0000000b55117c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x0000000b53277c10ULL, 0x000fc6000ff7e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00000000345e7faeULL, 0x0005e2000b901c4cULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000001611287c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff3a7224ULL, 0x000fe200018e06ffULL, 0x00000016272a7c11ULL, 0x000fe2000f8648ffULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x0000001609127c11ULL, 0x002fe4000f8248ffULL,
0x0000001711297c11ULL, 0x000fe400090f4c38ULL, 0x0000001709137c11ULL, 0x000fe200088f4c0aULL,
0x0000000036587faeULL, 0x0003e2000b901c4cULL, 0x0000000b51097c10ULL, 0x000fe2000ff3e0ffULL,
0x000000100d287825ULL, 0x000fe200078e0028ULL, 0x0000000b4f117c10ULL, 0x000fc4000ff5e0ffULL,
0x00000017272b7c11ULL, 0x000fe200098f4c3aULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x0000001609347c11ULL, 0x004fe2000f8248ffULL, 0x000000ffff3a7224ULL, 0x000fe200010e06ffULL,
0x0000001611387c11ULL, 0x000fe2000f8448ffULL, 0x000000100d127825ULL, 0x000fe200078e0012ULL,
0x0000001709357c11ULL, 0x000fe400088f4c0aULL, 0x0000001711397c11ULL, 0x000fe200090f4c3aULL,
0x000000100d2a7825ULL, 0x040fe200078e002aULL, 0x0000000012567faeULL, 0x0003e6000b901c4cULL,
0x000000100d347825ULL, 0x040fe200078e0034ULL, 0x0000000028547faeULL, 0x0003e6000b901c4cULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x000000002a527faeULL, 0x0003e8000b901c4cULL,
0x0000000034507faeULL, 0x0003e8000b901c4cULL, 0x00000000384e7faeULL, 0x0003e4000b901c4cULL,
0x00000003070a7892ULL, 0x000fe2000f8ec03fULL, 0x00000012ff097e24ULL, 0x000fc6000f8e00ffULL,
0x000000030a00788cULL, 0x000fc8000bf05270ULL, 0x000000010f0a7887ULL, 0x000fc8000c000000ULL,
0x0000000a07077290ULL, 0x000fc6000fffe03fULL, 0xffffffff000a7882ULL, 0x000fe20000000000ULL,
0x000000040700728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f2f008ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000807137290ULL, 0x000fe2000fffe03fULL,
0x00008c00000a7ab9ULL, 0x000fc60000000a00ULL, 0x00000004130a78a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff127e24ULL, 0x002fe4000f8e00ffULL, 0x0000000bff137e24ULL, 0x000fca000f8e00ffULL,
0x0000000c12127981ULL, 0x000ea4000c1e1900ULL, 0x00000000120a72caULL, 0x004fde00000e0000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x01c6484c091279a7ULL, 0x0022a40008500006ULL,
0x00000012ff097e24ULL, 0x002fc8000f8e00ffULL, 0x01c64813090075a7ULL, 0x004e640008020146ULL,
0x000000e400c89947ULL, 0x002fea0003800000ULL, 0x01c1000010097984ULL, 0x000e620000000800ULL,
0x0000000000117919ULL, 0x000ea40000000000ULL, 0x00000002ff5a7819ULL, 0x004fe20000011611ULL,
0x00000001ff117424ULL, 0x000fe200078e00ffULL, 0x000000080900720bULL, 0x002fc60003f3d000ULL,
0x000000085a4d7836ULL, 0x000fd40000000000ULL, 0x00000000000a7806ULL, 0x000fc800008e0100ULL,
0x0000ffff0a137812ULL, 0x000fe4000782c0ffULL, 0x01c30000100a7984ULL, 0x0002b60000000800ULL,
0x0000000000d49947ULL, 0x002fea0003800000ULL, 0x000000080900720bULL, 0x000fe20003f34000ULL,
0x000000021000788cULL, 0x000fe2000bf05270ULL, 0x0000000908117209ULL, 0x000fca0007810000ULL,
0x8000001108127221ULL, 0x000fe20000010000ULL, 0x000000000000781cULL, 0x000fc60003f4f008ULL,
0x3fb8aa3b12127820ULL, 0x000fe40000410000ULL, 0x0000000000087806ULL, 0x000fc800008e0100ULL,
0x0000ffff08287812ULL, 0x000fe200078e3cffULL, 0x0000001200127308ULL, 0x000e660000000800ULL,
0x0000002813ff7212ULL, 0x000fe2000782c0ffULL, 0x01c500111000a388ULL, 0x000fe80000000800ULL,
0x00001f5a12087589ULL, 0x002e7000000e0000ULL, 0x8000001109131221ULL, 0x000fe20000010000ULL,
0x0000001207077220ULL, 0x000fe20000410000ULL, 0x00001f4d12097589ULL, 0x00072400000e0000ULL,
0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL, 0x00000013005c1308ULL, 0x000f620000000800ULL,
0x00000001ff127807ULL, 0x008fe20000800000ULL, 0x000000082c2c7220ULL, 0x082fe20000410000ULL,
0x000000082d2d7220ULL, 0x080fe20000410000ULL, 0x0000000840407220ULL, 0x080fe20000410000ULL,
0x0000000841417220ULL, 0x080fe20000410000ULL, 0x000000083c3c7220ULL, 0x080fe20000410000ULL,
0x000000083d3d7220ULL, 0x080fe20000410000ULL, 0x0000000814147220ULL, 0x080fe20000410000ULL,
0x0000000815157220ULL, 0x080fe20000410000ULL, 0x0000000818187220ULL, 0x080fe20000410000ULL,
0x0000000819197220ULL, 0x080fe20000410000ULL, 0x000000081c1c7220ULL, 0x080fe20000410000ULL,
0x000000081d1d7220ULL, 0x080fe20000410000ULL, 0x0000000830307220ULL, 0x080fe20000410000ULL,
0x0000000831317220ULL, 0x080fe20000410000ULL, 0x0000000820207220ULL, 0x080fe20000410000ULL,
0x0000000821217220ULL, 0x000fe20000410000ULL, 0x000000ffff087224ULL, 0x000fc400078e0011ULL,
0x000000092e2e7220ULL, 0x090fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000942427220ULL, 0x080fe20000410000ULL, 0x0000000943437220ULL, 0x080fe20000410000ULL,
0x000000093e3e7220ULL, 0x080fe20000410000ULL, 0x000000093f3f7220ULL, 0x080fe20000410000ULL,
0x0000000916167220ULL, 0x080fe20000410000ULL, 0x0000000917177220ULL, 0x080fe20000410000ULL,
0x000000091a1a7220ULL, 0x080fe20000410000ULL, 0x000000091b1b7220ULL, 0x080fe20000410000ULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000091f1f7220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x000fe20000410000ULL,
0x0000761012117816ULL, 0x000fe20000000011ULL, 0x0000000a5c0a1220ULL, 0x024fce0000410000ULL,
0x0000080001487983ULL, 0x000ee20000100800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000c0001277983ULL, 0x000f280000100800ULL, 0x0000000001137983ULL, 0x004ea20000100800ULL,
0x0000005cff09723eULL, 0x000fe400000000ffULL, 0x0000991011117816ULL, 0x000fe200000000ffULL,
0x00000400014c7983ULL, 0x0003620000100800ULL, 0x0000541009097816ULL, 0x000fe40000000009ULL,
0x000000ff1100720cULL, 0x000fe20003f25270ULL, 0x013000007728783bULL, 0x000fe80000000200ULL,
0x000000007844783bULL, 0x000fe80000004200ULL, 0x00001f5a09117589ULL, 0x000e6800000e0000ULL,
0x00001f4d09127589ULL, 0x000e6800000e0000ULL, 0x000000007a38783bULL, 0x000e680000004200ULL,
0x000000007d34783bULL, 0x000e640000004200ULL, 0x0000001128289232ULL, 0x002fc40000000000ULL,
0x000000112a2a9232ULL, 0x000fe40000000000ULL, 0x0000001229299232ULL, 0x080fe40000000000ULL,
0x000000122b2b9232ULL, 0x000fce0000000000ULL, 0x00000044282c723cULL, 0x000fec000000182cULL,
0x000000462840723cULL, 0x000fec0000001840ULL, 0x00000038283c723cULL, 0x000fec000000183cULL,
0x0000003a2814723cULL, 0x000fe20000001814ULL, 0x013000007c38783bULL, 0x000e6a0000000200ULL,
0x000000342818723cULL, 0x000fec0000001818ULL, 0x000000362834723cULL, 0x000fe2000000181cULL,
0x00000000791c783bULL, 0x000e620000004200ULL, 0x000000090a0b72a4ULL, 0x000fe2000f8e023fULL,
0x000000070a077221ULL, 0x000fc60000010000ULL, 0x000000060b0b7899ULL, 0x000fe2000800063fULL,
0x0000001138389232ULL, 0x082fe40000000000ULL, 0x000000113a3a9232ULL, 0x000fe40000000000ULL,
0x0000001239399232ULL, 0x080fe40000000000ULL, 0x000000123b3b9232ULL, 0x000fce0000000000ULL,
0x0000001c382c723cULL, 0x000fec000000182cULL, 0x0000001e3840723cULL, 0x000fe20000001840ULL,
0x000000004844783bULL, 0x008e680000004200ULL, 0x000000007b48783bULL, 0x000ee20000004200ULL,
0x000000442830723cULL, 0x002fec0000001830ULL, 0x000000462820723cULL, 0x000fe20000001820ULL,
0x000000002728783bULL, 0x010e680000004200ULL, 0x000000001344783bULL, 0x004ea20000004200ULL,
0x00000048383c723cULL, 0x008fec000000183cULL, 0x0000004a3814723cULL, 0x000fec0000001814ULL,
0x000000283818723cULL, 0x002fec0000001818ULL, 0x0000002a3834723cULL, 0x000fec0000001834ULL,
0x000000443830723cULL, 0x004fec0000001830ULL, 0x000000463838723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400008947ULL, 0x000fde0003800000ULL, 0x0000000b24137c10ULL, 0x000fe4000ff5e0ffULL,
0x000000c04c0a7811ULL, 0x020fe400078e40ffULL, 0x0000000b71127c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000140a117c48ULL, 0x000fe2000ffe0000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0a0aULL, 0x0000001613207c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e06ffULL, 0x00000016121e7c11ULL, 0x000fc4000f8648ffULL,
0x0000001713217c11ULL, 0x000fe400090f4c1cULL, 0x00000020110a7446ULL, 0x000fe4000380000aULL,
0x0000000b70137c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d207825ULL, 0x040fe200078e0020ULL,
0x00000017121f7c11ULL, 0x000fe400098f4c1dULL, 0x0000000a0600720cULL, 0x080fe20003f66070ULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x0000000b6f117c10ULL, 0x000fe2000ffbe0ffULL,
0x000000100d1e7825ULL, 0x000fe200078e001eULL, 0x0000000a0500720cULL, 0x000fc40003f46070ULL,
0x00000016131c7c11ULL, 0x000fe2000f8848ffULL, 0x000000ffff227224ULL, 0x000fe200028e06ffULL,
0x0000001611127c11ULL, 0x000fe4000f8a48ffULL, 0x00000017131d7c11ULL, 0x000fe4000a0f4c28ULL,
0x0000001711137c11ULL, 0x000fe2000a8f4c22ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020677faeULL, 0x000fe2000d901c4cULL, 0x0000000b6e237c10ULL, 0x000fe2000ff9e0ffULL,
0x000000100d1c7825ULL, 0x000fe200078e001cULL, 0x0000000b68117c10ULL, 0x000fe2000ffbe0ffULL,
0x000000001e667faeULL, 0x0003e2000d101c4cULL, 0x0000000a0400720cULL, 0x080fe20003f66070ULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x0000001611227c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x0000000a0b00720cULL, 0x080fe20003fa6070ULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000000a0e00720cULL, 0x000fc40003fc6070ULL,
0x00000016231e7c11ULL, 0x002fca000f8448ffULL, 0x000000001c637faeULL, 0x0003e2000d901c4cULL,
0x00000017231f7c11ULL, 0x000fe400090f4c2aULL, 0x0000000b65217c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001711237c11ULL, 0x000fe2000a0f4c28ULL, 0x000000100d1e7825ULL, 0x000fe200078e001eULL,
0x0000000b64117c10ULL, 0x000fc6000ff9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000001621207c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff287224ULL, 0x000fe200020e06ffULL,
0x00000016111c7c11ULL, 0x002fe2000f8648ffULL, 0x000000100d227825ULL, 0x000fe200078e0022ULL,
0x0000001721217c11ULL, 0x000fe400090f4c2aULL, 0x00000017111d7c11ULL, 0x000fe400098f4c28ULL,
0x0000000a0300720cULL, 0x080fe20003f46070ULL, 0x000000100d207825ULL, 0x000fe200078e0020ULL,
0x0000000a0200720cULL, 0x000fc40003f66070ULL, 0x0000000a0000720cULL, 0x000fe20003f86070ULL,
0x000000100d1c7825ULL, 0x000fd000078e001cULL, 0x0000000012617faeULL, 0x0003e8000d101c4cULL,
0x000000001e267faeULL, 0x0003e8000d901c4cULL, 0x0000000022257faeULL, 0x0003e8000e101c4cULL,
0x00000000200c7faeULL, 0x0003e8000e901c4cULL, 0x000000001c0f7faeULL, 0x0003e2000f101c4cULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000000b240a7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000b71127c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b701d7c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160a207c11ULL, 0x040fe2000f8448ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x000000161d1c7c11ULL, 0x000fe4000f8648ffULL,
0x000000170a217c11ULL, 0x000fe200090f4c11ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000000b6f117c10ULL, 0x000fc4000ff9e0ffULL, 0x00000016121e7c11ULL, 0x040fe2000f8448ffULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x000000171d1d7c11ULL, 0x000fe400098f4c0aULL,
0x00000017121f7c11ULL, 0x000fe200090f4c13ULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000001611127c11ULL, 0x000fe2000f8448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020677faeULL, 0x0003e2000b901c4cULL, 0x0000000b6e237c10ULL, 0x000fe2000ffbe0ffULL,
0x000000100d1e7825ULL, 0x000fe200078e001eULL, 0x0000001711137c11ULL, 0x000fc400090f4c0aULL,
0x0000000b680a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x0000001623227c11ULL, 0x000fe2000f8648ffULL, 0x000000100d1c7825ULL, 0x000fe200078e001cULL,
0x000000001e667faeULL, 0x0005e4000b901c4cULL, 0x0000001723237c11ULL, 0x000fe200098f4c28ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160a207c11ULL, 0x042fe2000f8448ffULL,
0x000000001c637faeULL, 0x0003e2000b901c4cULL, 0x0000000b64277c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x000000170a217c11ULL, 0x000fc400090f4c11ULL,
0x0000000b650a7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x0000000012617faeULL, 0x0007e2000b901c4cULL, 0x000000100d227825ULL, 0x000fc800078e0022ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x000000160a1e7c11ULL, 0x044fe2000f8448ffULL,
0x000000100d207825ULL, 0x000fe200078e0020ULL, 0x00000016271c7c11ULL, 0x042fe2000f8648ffULL,
0x0000000022267faeULL, 0x0007e2000b901c4cULL, 0x000000170a1f7c11ULL, 0x000fe400090f4c11ULL,
0x00000017271d7c11ULL, 0x000fe200098f4c28ULL, 0x0000000020257faeULL, 0x0007e2000b901c4cULL,
0x000000100d1e7825ULL, 0x000fc800078e001eULL, 0x000000100d1c7825ULL, 0x000fe200078e001cULL,
0x000000001e0c7faeULL, 0x0007e8000b901c4cULL, 0x000000001c0f7faeULL, 0x0007e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff277424ULL, 0x000fc600078e00ffULL,
0x00001f5a090a7589ULL, 0x000fe800000e0000ULL, 0x00001f4d09097589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x01300000761c783bULL, 0x00ae680000000200ULL,
0x000000007520783bULL, 0x000ea80000004200ULL, 0x000000007428783bULL, 0x000ee80000004200ULL,
0x000000007348783bULL, 0x000f280000004200ULL, 0x000000007244783bULL, 0x000ee20000004200ULL,
0x0000000a1c1c9232ULL, 0x002fc40000000000ULL, 0x0000000a1e1e9232ULL, 0x000fe40000000000ULL,
0x000000091d1d9232ULL, 0x080fe40000000000ULL, 0x000000091f1f9232ULL, 0x000fce0000000000ULL,
0x000000201c2c723cULL, 0x004fec000000182cULL, 0x000000221c40723cULL, 0x000fe20000001840ULL,
0x013000006d20783bULL, 0x000e6a0000000200ULL, 0x000000281c3c723cULL, 0x008fec000000183cULL,
0x0000002a1c14723cULL, 0x000fe20000001814ULL, 0x000000006928783bULL, 0x000eaa0000004200ULL,
0x000000481c18723cULL, 0x010fec0000001818ULL, 0x0000004a1c34723cULL, 0x000fe20000001834ULL,
0x000000006c48783bULL, 0x000eea0000004200ULL, 0x000000441c30723cULL, 0x000fec0000001830ULL,
0x000000461c38723cULL, 0x000fe20000001838ULL, 0x000000006a1c783bULL, 0x000f280000004200ULL,
0x000000006b44783bULL, 0x000f220000004200ULL, 0x0000000921219232ULL, 0x082fe20000000000ULL,
0x01c69827ffff79a7ULL, 0x0003e20008500006ULL, 0x0000000923239232ULL, 0x000fe20000000000ULL,
0x000000c04c097811ULL, 0x020fe200078e40ffULL, 0x0000000a20209232ULL, 0x000fc40000000000ULL,
0x0000000a22229232ULL, 0x000fe20000000000ULL, 0x0000001409007c0cULL, 0x000fcc000bf26070ULL,
0x000000282030723cULL, 0x004fec0000001830ULL, 0x00000048202c723cULL, 0x008fec000000182cULL,
0x0000004a2040723cULL, 0x000fec0000001840ULL, 0x0000001c2018723cULL, 0x010fec0000001818ULL,
0x00000044203c723cULL, 0x000fec000000183cULL, 0x000000462014723cULL, 0x000fec0000001814ULL,
0x0000001e201c723cULL, 0x000fec0000001834ULL, 0x0000002a2020723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000001800641947ULL, 0x002fde0003800000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400008947ULL, 0x000fea0003800000ULL,
0x0000002009097836ULL, 0x000fe20000000000ULL, 0x0000000b5f5f7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000b62627c10ULL, 0x000fe4000ff1e0ffULL, 0x00000014090a7c48ULL, 0x000fe2000ffe0000ULL,
0x000000ffff097224ULL, 0x000fe200078e0a09ULL, 0x0000000b55557c10ULL, 0x000fe2000ff5e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x000000165f287c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000001662127c11ULL, 0x000fc4000f8048ffULL,
0x000000200a097446ULL, 0x000fe20003800009ULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x000000175f297c11ULL, 0x000fe400088f4c2aULL, 0x00000016552a7c11ULL, 0x000fe4000f8448ffULL,
0x0000001762137c11ULL, 0x000fe200080f4c11ULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x0000000b59597c10ULL, 0x000fe4000ff1e0ffULL, 0x00000017552b7c11ULL, 0x000fe200090f4c0aULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000000b51517c10ULL, 0x000fc4000ff5e0ffULL,
0x0000000b57577c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x0000001659367c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff467224ULL, 0x000fe200010e06ffULL,
0x000000090600720cULL, 0x080fe20003f46070ULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x0000001759377c11ULL, 0x000fe200080f4c3aULL, 0x000000100d2a7825ULL, 0x000fe200078e002aULL,
0x000000090500720cULL, 0x000fe40003f66070ULL, 0x0000000b53537c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x0000001657347c11ULL, 0x000fc4000f8248ffULL,
0x0000000b4f4f7c10ULL, 0x000fe2000ffbe0ffULL, 0x000000ffff487224ULL, 0x000fe200000e06ffULL,
0x0000001757357c11ULL, 0x000fe200088f4c38ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012607faeULL, 0x0003e2000d101c4cULL, 0x0000001653447c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff0a7224ULL, 0x000fe200028e06ffULL, 0x00000016513a7c11ULL, 0x000fe2000f8848ffULL,
0x00000000285e7faeULL, 0x0003e2000d901c4cULL, 0x000000164f387c11ULL, 0x000fe2000f8a48ffULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x000000090400720cULL, 0x000fc40003f06070ULL,
0x0000001753457c11ULL, 0x000fe400088f4c48ULL, 0x000000090300720cULL, 0x080fe40003f26070ULL,
0x000000090200720cULL, 0x080fe20003f46070ULL, 0x000000100d447825ULL, 0x000fe200078e0044ULL,
0x00000017513b7c11ULL, 0x000fe4000a0f4c46ULL, 0x000000090000720cULL, 0x080fe40003f66070ULL,
0x000000174f397c11ULL, 0x000fe2000a8f4c0aULL, 0x000000100d3a7825ULL, 0x000fe200078e003aULL,
0x000000090b00720cULL, 0x080fe20003f86070ULL, 0x0000000036587faeULL, 0x0003e2000c101c4cULL,
0x000000090e00720cULL, 0x000fe20003fa6070ULL, 0x000000100d387825ULL, 0x000fc400078e0038ULL,
0x0000000034567faeULL, 0x0003e8000c901c4cULL, 0x000000002a547faeULL, 0x0003e8000d101c4cULL,
0x0000000044527faeULL, 0x0003e8000d901c4cULL, 0x000000003a507faeULL, 0x0003e8000e101c4cULL,
0x00000000384e7faeULL, 0x0003e2000e901c4cULL, 0x0000000000cc7947ULL, 0x000fea0003800000ULL,
0x0000000b5f5f7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000b62627c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000b59597c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x000000165f287c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000001662127c11ULL, 0x000fe4000f8048ffULL, 0x0000000b57577c10ULL, 0x000fc4000ff7e0ffULL,
0x000000175f297c11ULL, 0x000fe200088f4c0aULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x0000001762137c11ULL, 0x000fe200080f4c09ULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x0000001659347c11ULL, 0x000fe2000f8048ffULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x0000000b55557c10ULL, 0x000fe4000ff5e0ffULL, 0x00000016572a7c11ULL, 0x000fe2000f8248ffULL,
0x000000100d127825ULL, 0x000fe200078e0012ULL, 0x0000000b53537c10ULL, 0x000fc4000ff7e0ffULL,
0x0000001759357c11ULL, 0x000fe200080f4c0aULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x00000017572b7c11ULL, 0x000fe200088f4c36ULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x0000001655367c11ULL, 0x000fe2000f8048ffULL, 0x000000100d347825ULL, 0x040fe200078e0034ULL,
0x0000000b51517c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012607faeULL, 0x0003e2000b901c4cULL, 0x0000000b4f4f7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000001653387c11ULL, 0x000fe2000f8248ffULL,
0x00000000285e7faeULL, 0x0003e2000b901c4cULL, 0x0000001755377c11ULL, 0x000fe200080f4c0aULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x0000001753397c11ULL, 0x000fe200088f4c3aULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x0000001651447c11ULL, 0x000fe2000f8048ffULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x000000164f3a7c11ULL, 0x000fe2000f8248ffULL,
0x0000000034587faeULL, 0x0003e2000b901c4cULL, 0x0000001751457c11ULL, 0x000fe200080f4c0aULL,
0x000000100d387825ULL, 0x000fe200078e0038ULL, 0x000000174f3b7c11ULL, 0x000fe200088f4c46ULL,
0x000000002a567faeULL, 0x0003e4000b901c4cULL, 0x000000100d447825ULL, 0x000fc400078e0044ULL,
0x0000000036547faeULL, 0x0003e4000b901c4cULL, 0x000000100d3a7825ULL, 0x000fe400078e003aULL,
0x0000000038527faeULL, 0x0003e8000b901c4cULL, 0x0000000044507faeULL, 0x0003e8000b901c4cULL,
0x000000003a4e7faeULL, 0x0003e4000b901c4cULL, 0x00000003070a7892ULL, 0x000fe2000f8ec03fULL,
0x00000012ff097e24ULL, 0x000fc6000f8e00ffULL, 0x000000030a00788cULL, 0x000fc6000bf05270ULL,
0xffffffff000a7882ULL, 0x000fe20000000000ULL, 0x000000010f0f7887ULL, 0x000fc8000c000000ULL,
0x0000000f07077290ULL, 0x000fc8000fffe03fULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x00000000001c0947ULL, 0x000fea0003800000ULL,
0x00000008070f7290ULL, 0x000fe2000fffe03fULL, 0x00008c00000a7ab9ULL, 0x000fc60000000a00ULL,
0x000000040f0a78a5ULL, 0x000fcc000f8e000aULL, 0x0000000aff127e24ULL, 0x002fe4000f8e00ffULL,
0x0000000bff137e24ULL, 0x000fca000f8e00ffULL, 0x0000000c12127981ULL, 0x000ea4000c1e1900ULL,
0x00000000120a72caULL, 0x004fde00000e0000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c66827091279a7ULL, 0x0022a40008500006ULL, 0x00000012ff097e24ULL, 0x002fc8000f8e00ffULL,
0x01c66813090075a7ULL, 0x004e640008000146ULL, 0x000000cc00748947ULL, 0x002fea0003800000ULL,
0x01c1800010117984ULL, 0x000e620000000800ULL, 0x00000001ff287424ULL, 0x000fe200078e00ffULL,
0x00000000000a7919ULL, 0x000ea40000000000ULL, 0x00000002ff5f7819ULL, 0x004fe4000001160aULL,
0x000000081100720bULL, 0x002fc60003f1d000ULL, 0x000000085f5e7836ULL, 0x000fd40000000000ULL,
0x0000000000097806ULL, 0x000fc800000e0100ULL, 0x0000ffff09127812ULL, 0x000fe4000780c0ffULL,
0x01c3800010097984ULL, 0x0002b60000000800ULL, 0x0000000000d08947ULL, 0x002fea0003800000ULL,
0x000000081100720bULL, 0x000fe20003f14000ULL, 0x000000031000788cULL, 0x000fe2000bf05270ULL,
0x0000001108137209ULL, 0x000fca0007810000ULL, 0x80000013080a7221ULL, 0x000fe20000010000ULL,
0x000000000000781cULL, 0x000fc60003f2f008ULL, 0x3fb8aa3b0a0a7820ULL, 0x000fe40000410000ULL,
0x0000000000087806ULL, 0x000fc800000e0100ULL, 0x0000ffff08277812ULL, 0x000fe200078e3cffULL,
0x0000000a000a7308ULL, 0x000e660000000800ULL, 0x0000002712ff7212ULL, 0x000fe2000780c0ffULL,
0x01c5801310009388ULL, 0x000fe60000000800ULL, 0x00000001ff287807ULL, 0x000fe20000000000ULL,
0x00001f5f0a087589ULL, 0x002e7000000e0000ULL, 0x8000001311120221ULL, 0x000fe20000010000ULL,
0x0000000a07077220ULL, 0x000fe20000410000ULL, 0x00001f5e0a117589ULL, 0x000ee400000e0000ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x00000012005c0308ULL, 0x000f220000000800ULL,
0x000000082c2c7220ULL, 0x082fe20000410000ULL, 0x000000082d2d7220ULL, 0x080fe20000410000ULL,
0x0000000840407220ULL, 0x080fe20000410000ULL, 0x0000000841417220ULL, 0x080fe20000410000ULL,
0x000000083c3c7220ULL, 0x080fe20000410000ULL, 0x000000083d3d7220ULL, 0x080fe20000410000ULL,
0x0000000814147220ULL, 0x080fe20000410000ULL, 0x0000000815157220ULL, 0x080fe20000410000ULL,
0x0000000818187220ULL, 0x080fe20000410000ULL, 0x0000000819197220ULL, 0x080fe20000410000ULL,
0x000000081c1c7220ULL, 0x080fe20000410000ULL, 0x000000081d1d7220ULL, 0x080fe20000410000ULL,
0x0000000830307220ULL, 0x080fe20000410000ULL, 0x0000000831317220ULL, 0x080fe20000410000ULL,
0x0000000820207220ULL, 0x080fe20000410000ULL, 0x0000000821217220ULL, 0x000fe20000410000ULL,
0x000000112e2e7220ULL, 0x088fe20000410000ULL, 0x000000112f2f7220ULL, 0x080fe20000410000ULL,
0x0000001142427220ULL, 0x080fe20000410000ULL, 0x0000001143437220ULL, 0x080fe20000410000ULL,
0x000000113e3e7220ULL, 0x080fe20000410000ULL, 0x000000113f3f7220ULL, 0x080fe20000410000ULL,
0x0000001116167220ULL, 0x080fe20000410000ULL, 0x0000001117177220ULL, 0x080fe20000410000ULL,
0x000000111a1a7220ULL, 0x080fe20000410000ULL, 0x000000111b1b7220ULL, 0x080fe20000410000ULL,
0x000000111e1e7220ULL, 0x080fe20000410000ULL, 0x000000111f1f7220ULL, 0x080fe20000410000ULL,
0x0000001132327220ULL, 0x080fe20000410000ULL, 0x0000001133337220ULL, 0x080fe20000410000ULL,
0x0000001122227220ULL, 0x080fe20000410000ULL, 0x0000001123237220ULL, 0x000fe20000410000ULL,
0x000000ffff087224ULL, 0x000fc400078e0013ULL, 0x000000095c090220ULL, 0x014fce0000410000ULL,
0x0000080001297983ULL, 0x000ee20000300800ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000c0001547983ULL, 0x000f280000300800ULL, 0x0000000001587983ULL, 0x000f680000300800ULL,
0x0000040001607983ULL, 0x004ea20000100800ULL, 0x0000005cff0a723eULL, 0x000fe200000000ffULL,
0x000000090a0972a4ULL, 0x000fe2000f8e023fULL, 0x0000991028287816ULL, 0x000fe200000000ffULL,
0x013800007744783bULL, 0x000fe20000000200ULL, 0x000054100a0a7816ULL, 0x000fe2000000000aULL,
0x0000000609097899ULL, 0x000fe2000800063fULL, 0x000000ff2800720cULL, 0x000fe20003f05270ULL,
0x000000007810783bULL, 0x000fe20000004200ULL, 0x0000000709077221ULL, 0x000fc60000010000ULL,
0x000000007a50783bULL, 0x000fe80000004200ULL, 0x000000007d4c783bULL, 0x000fe80000004200ULL,
0x00001f5f0a277589ULL, 0x000e6800000e0000ULL, 0x00001f5e0a5d7589ULL, 0x000e6800000e0000ULL,
0x000000007938783bULL, 0x000fe80000004200ULL, 0x000000007b34783bULL, 0x000fe20000004200ULL,
0x0000002744448232ULL, 0x002fc40000000000ULL, 0x0000002746468232ULL, 0x000fe40000000000ULL,
0x0000005d45458232ULL, 0x080fe40000000000ULL, 0x0000005d47478232ULL, 0x000fce0000000000ULL,
0x00000010442c723cULL, 0x000fec000000182cULL, 0x000000124410723cULL, 0x000fec0000001840ULL,
0x00000050443c723cULL, 0x000fec000000183cULL, 0x000000524414723cULL, 0x000fec0000001814ULL,
0x0000004c4418723cULL, 0x000fec0000001818ULL, 0x0000004e441c723cULL, 0x000fe2000000181cULL,
0x000000002948783bULL, 0x008e680000004200ULL, 0x013800007c28783bULL, 0x000ee80000000200ULL,
0x000000005454783bULL, 0x010f280000004200ULL, 0x000000005858783bULL, 0x020f620000004200ULL,
0x000000484430723cULL, 0x002fe20000001830ULL, 0x0000002728288232ULL, 0x008fca0000000000ULL,
0x0000004a4420723cULL, 0x000fe20000001820ULL, 0x000000272a2a8232ULL, 0x000fe40000000000ULL,
0x0000005d29298232ULL, 0x080fe40000000000ULL, 0x0000005d2b2b8232ULL, 0x000fce0000000000ULL,
0x00000038282c723cULL, 0x000fec000000182cULL, 0x0000003a2810723cULL, 0x000fec0000001810ULL,
0x00000034283c723cULL, 0x000fec000000183cULL, 0x000000362814723cULL, 0x000fec0000001814ULL,
0x000000542818723cULL, 0x010fec0000001818ULL, 0x00000056281c723cULL, 0x000fec000000181cULL,
0x000000582830723cULL, 0x020fec0000001830ULL, 0x0000005a2820723cULL, 0x000fee0000001820ULL,
0x0000001160287c36ULL, 0x004fc80008000000ULL, 0x0000000128277836ULL, 0x000fca0000000000ULL,
0x0000000527007c0cULL, 0x000fe2000bf26070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x0000000400009947ULL, 0x000fea0003800000ULL, 0x0000000924277c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010028097824ULL, 0x000fe200078e00ffULL, 0x0000000970707c10ULL, 0x000fe4000ff7e0ffULL,
0x000000096f6f7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x0000001627287c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff2b7224ULL, 0x000fe200018e06ffULL,
0x0000001409247c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff097224ULL, 0x000fe200078e0a09ULL,
0x0000001727297c11ULL, 0x000fc400088f4c2aULL, 0x000000096e6e7c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000971717c10ULL, 0x000fe2000ff5e0ffULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x0000002024097446ULL, 0x000fe40003800009ULL, 0x0000001670367c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x000000166e347c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff247224ULL, 0x000fe200020e06ffULL, 0x000000166f2a7c11ULL, 0x000fe2000f8848ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x000000176e357c11ULL, 0x000fc400088f4c27ULL,
0x0000000968687c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001770377c11ULL, 0x000fe200098f4c2bULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x0000001671387c11ULL, 0x000fe4000f8448ffULL,
0x000000176f2b7c11ULL, 0x000fe2000a0f4c24ULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x000000090600720cULL, 0x000fe20003fa6070ULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x0000000964647c10ULL, 0x000fc4000ff9e0ffULL, 0x000000090500720cULL, 0x000fe20003f26070ULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000000965657c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001771397c11ULL, 0x000fe200090f4c3aULL, 0x000000ffff277224ULL, 0x000fe200020e06ffULL,
0x0000001668427c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00000016643a7c11ULL, 0x000fe2000f8848ffULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x0000001665407c11ULL, 0x000fe2000f8648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028677faeULL, 0x0003e2000e901c4cULL, 0x0000001768437c11ULL, 0x000fc400090f4c3bULL,
0x00000017643b7c11ULL, 0x000fe2000a0f4c27ULL, 0x0000000038667faeULL, 0x0003e2000c901c4cULL,
0x000000090400720cULL, 0x080fe20003f46070ULL, 0x000000100d427825ULL, 0x000fe200078e0042ULL,
0x0000001765417c11ULL, 0x000fe400098f4c06ULL, 0x000000090300720cULL, 0x080fe20003f86070ULL,
0x000000100d3a7825ULL, 0x040fe200078e003aULL, 0x000000090200720cULL, 0x080fe40003f66070ULL,
0x000000090000720cULL, 0x080fe20003fa6070ULL, 0x000000100d407825ULL, 0x000fe200078e0040ULL,
0x000000090b00720cULL, 0x000fc40003f26070ULL, 0x000000090e00720cULL, 0x000fe20003fc6070ULL,
0x0000000036637faeULL, 0x0003e8000d101c4cULL, 0x000000002a617faeULL, 0x0003e8000e101c4cULL,
0x0000000034267faeULL, 0x0003e8000d901c4cULL, 0x0000000042257faeULL, 0x0003e8000e901c4cULL,
0x00000000400c7faeULL, 0x0003e8000c901c4cULL, 0x000000003a0f7faeULL, 0x0003e2000f101c4cULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x0000000924247c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000971717c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000970707c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff037224ULL, 0x000fe200010e06ffULL, 0x000000096f6f7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff007224ULL, 0x000fe200018e06ffULL, 0x00000016242a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x0000001671287c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x0000001670047c11ULL, 0x000fc4000f8848ffULL,
0x000000166f027c11ULL, 0x000fe4000f8248ffULL, 0x00000017242b7c11ULL, 0x000fe400090f4c03ULL,
0x0000001771297c11ULL, 0x000fe400098f4c00ULL, 0x000000096e6e7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000100d2a7825ULL, 0x000fe200078e002aULL, 0x0000001770057c11ULL, 0x000fe4000a0f4c05ULL,
0x0000000968687c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x000000176f037c11ULL, 0x000fe200088f4c06ULL, 0x000000100d287825ULL, 0x000fe200078e0028ULL,
0x0000000965657c10ULL, 0x000fe2000ff9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a677faeULL, 0x0003e2000b901c4cULL, 0x0000000964647c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e06ffULL, 0x000000166e3a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x0000001668387c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff277224ULL, 0x000fe200008e06ffULL, 0x0000001665367c11ULL, 0x000fe2000f8848ffULL,
0x000000100d047825ULL, 0x040fe200078e0004ULL, 0x0000001664347c11ULL, 0x000fe2000f8248ffULL,
0x0000000028667faeULL, 0x0003e2000b901c4cULL, 0x000000176e3b7c11ULL, 0x000fe200090f4c09ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000001768397c11ULL, 0x000fe200098f4c0bULL,
0x0000000004637faeULL, 0x0003e2000b901c4cULL, 0x0000001765377c11ULL, 0x000fe2000a0f4c00ULL,
0x000000100d3a7825ULL, 0x040fe200078e003aULL, 0x0000001764357c11ULL, 0x000fe200088f4c27ULL,
0x0000000002617faeULL, 0x0003e4000b901c4cULL, 0x000000100d387825ULL, 0x000fc400078e0038ULL,
0x000000003a267faeULL, 0x0003e4000b901c4cULL, 0x000000100d367825ULL, 0x040fe400078e0036ULL,
0x0000000038257faeULL, 0x0003e4000b901c4cULL, 0x000000100d347825ULL, 0x000fe400078e0034ULL,
0x00000000360c7faeULL, 0x0003e8000b901c4cULL, 0x00000000340f7faeULL, 0x0003e4000b901c4cULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000001ff027424ULL, 0x002fc600078e00ffULL,
0x00001f5f0a037589ULL, 0x000fe800000e0000ULL, 0x00001f5e0a007589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x01380000760c783bULL, 0x000e680000000200ULL,
0x000000007528783bULL, 0x000ea80000004200ULL, 0x000000007434783bULL, 0x000fe80000004200ULL,
0x000000007338783bULL, 0x000fe80000004200ULL, 0x000000007240783bULL, 0x000fe80000004200ULL,
0x013800006d24783bULL, 0x000ee80000000200ULL, 0x000000006c50783bULL, 0x000f280000004200ULL,
0x000000006b4c783bULL, 0x000f680000004200ULL, 0x000000006a48783bULL, 0x000f280000004200ULL,
0x000000006944783bULL, 0x000f220000004200ULL, 0x01c6a002ffff79a7ULL, 0x0005e20008500006ULL,
0x000000030c0c8232ULL, 0x002fc40000000000ULL, 0x000000030e0e8232ULL, 0x000fe40000000000ULL,
0x000000000d0d8232ULL, 0x080fe40000000000ULL, 0x000000000f0f8232ULL, 0x000fce0000000000ULL,
0x000000280c2c723cULL, 0x004fec000000182cULL, 0x0000002a0c10723cULL, 0x000fe20000001810ULL,
0x0000000324248232ULL, 0x088fe40000000000ULL, 0x0000000326268232ULL, 0x000fe40000000000ULL,
0x0000000025258232ULL, 0x080fe20000000000ULL, 0x000000340c3c723cULL, 0x000fe2000000183cULL,
0x0000000027278232ULL, 0x000fca0000000000ULL, 0x000000360c14723cULL, 0x000fec0000001814ULL,
0x000000380c18723cULL, 0x000fec0000001818ULL, 0x0000003a0c1c723cULL, 0x000fec000000181cULL,
0x000000400c30723cULL, 0x000fec0000001830ULL, 0x000000420c20723cULL, 0x000fec0000001820ULL,
0x00000050242c723cULL, 0x010fec000000182cULL, 0x000000522440723cULL, 0x000fec0000001810ULL,
0x0000004c243c723cULL, 0x020fec000000183cULL, 0x0000004e2414723cULL, 0x000fec0000001814ULL,
0x000000482418723cULL, 0x000fec0000001818ULL, 0x0000004a241c723cULL, 0x000fec000000181cULL,
0x000000442430723cULL, 0x000fec0000001830ULL, 0x000000462420723cULL, 0x000fde0000001820ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000040001007983ULL, 0x000ea40000300800ULL,
0x0000001100007c36ULL, 0x004fca0008000000ULL, 0x0000040001007387ULL, 0x0003e20000100800ULL,
0x0000000500007c0cULL, 0x000fda000bf06070ULL, 0xffffff8800f88947ULL, 0x002fea000383ffffULL,
0x00000000001379c3ULL, 0x000e620000002500ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0016ULL,
0x000000051300728cULL, 0x002fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x0180000007007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e0007ULL,
0x00008e2000027802ULL, 0x000fce0000000f00ULL, 0x000000c000987944ULL, 0x000fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000037919ULL, 0x000f240000000000ULL,
0x00000002ff057819ULL, 0x010fe40000011603ULL, 0x0000000803037811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0300037589ULL, 0x000ee200000e0000ULL, 0x0000002c022c7220ULL, 0x044fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000002002207220ULL, 0x040fe20000410000ULL,
0x0000002102217220ULL, 0x000fe20000410000ULL, 0x0000002e032e7220ULL, 0x048fe20000410000ULL,
0x0000002f032f7220ULL, 0x040fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000000a030a7220ULL, 0x040fe20000410000ULL,
0x0000001703177220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000003203327220ULL, 0x040fe20000410000ULL,
0x0000003303337220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x000fce0000410000ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000610067291ULL, 0x000fe2000f8e583fULL, 0x0000002c2d0c723eULL, 0x000fe200000000ffULL,
0x000000011100788cULL, 0x000fe2000bf05270ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0001200006167890ULL, 0x000fe2000fffe03fULL, 0x0000003c3d0e723eULL, 0x000fe400000000ffULL,
0x00000014150f723eULL, 0x000fe400000000ffULL, 0x000000000000781cULL, 0x000fc40003f0f008ULL,
0x000000181910723eULL, 0x000fe400000000ffULL, 0x0000001c1d11723eULL, 0x000fe400000000ffULL,
0x000000303112723eULL, 0x000fe400000000ffULL, 0x000000202113723eULL, 0x000fe400000000ffULL,
0x0000002e2f14723eULL, 0x000fe400000000ffULL, 0x000000424315723eULL, 0x000fc400000000ffULL,
0x0000003e3f16723eULL, 0x000fe400000000ffULL, 0x0000000a1717723eULL, 0x000fe400000000ffULL,
0x0000001a1b18723eULL, 0x000fe400000000ffULL, 0x0000001e1f19723eULL, 0x000fe400000000ffULL,
0x00000003ff037819ULL, 0x004fe40000011600ULL, 0xfffffff8ff057812ULL, 0x000fc400078ee200ULL,
0x0000000303027812ULL, 0x000fe400078ec0ffULL, 0x00000032331a723eULL, 0x000fe200000000ffULL,
0x00000008050b7836ULL, 0x040fe20000000000ULL, 0x0000000402067812ULL, 0x000fe200078efcffULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0x0000000702097812ULL, 0x000fe400078e7805ULL,
0x00000007020d7812ULL, 0x000fe200078e780bULL, 0x000000080b027824ULL, 0x000fe200078e00ffULL,
0x0000000706057812ULL, 0x000fc400078e7805ULL, 0x00000007060b7812ULL, 0x000fe400078e780bULL,
0x0000000409097212ULL, 0x080fe400078efcffULL, 0x0000000405057212ULL, 0x000fe400078efcffULL,
0x000000020d047212ULL, 0x080fe400078efcffULL, 0x000000020b0b7212ULL, 0x000fe400078efcffULL,
0x00000040410d723eULL, 0x000fc400000000ffULL, 0x0000001609097c11ULL, 0x000fe4000f8e20ffULL,
0x0000001605057c11ULL, 0x000fe4000f8e20ffULL, 0x0000001604047c11ULL, 0x000fe2000f8e20ffULL,
0x0000000c09007844ULL, 0x0005e20000000200ULL, 0x00000022231b723eULL, 0x000fe400000000ffULL,
0x000000160b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x0000001005007844ULL, 0x0005e80000000200ULL,
0x0000001404007844ULL, 0x0005e80000000200ULL, 0x000000180b007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000002400ac8947ULL, 0x000fea0003800000ULL,
0x0000000600027c11ULL, 0x000fe2000f8e20ffULL, 0x00000000000979c3ULL, 0x000fe20000002700ULL,
0x00000010ff007c0cULL, 0x000fe2000bf05270ULL, 0x0000840000057ab9ULL, 0x000fe20000000800ULL,
0x0000920000087ab9ULL, 0x000fe20000000800ULL, 0x01200000020c7984ULL, 0x0045280000000c00ULL,
0x00000000000479c3ULL, 0x000ee20000002600ULL, 0x0122000002107984ULL, 0x0004620000000c00ULL,
0x00000005090972a4ULL, 0x008fc4000f8e0204ULL, 0x00000005110472a4ULL, 0x000fe4000f8e023fULL,
0x00000011090772a4ULL, 0x000fe4000f8e023fULL, 0x00000008040872a4ULL, 0x000fe4000f8e023fULL,
0x00000013070a7290ULL, 0x000fe4000fffe03fULL, 0x01ffffff08177892ULL, 0x000fe2000f8ec03fULL,
0x0000000000380947ULL, 0x004ff60003800000ULL, 0x000000170a0b7290ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x0000980000047ab9ULL, 0x000fe20000000a00ULL,
0x00000001ff047819ULL, 0x000fe20000011600ULL, 0x000000800a0e78a5ULL, 0x000fe4000f8e0004ULL,
0x000000800b0478a5ULL, 0x000fe2000f8e0004ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c040b7812ULL, 0x000fc800078ec0ffULL, 0x0000000e0b047c10ULL, 0x140fe4000fa3e002ULL,
0x000000040b0a7c10ULL, 0x000fe4000fc7e002ULL, 0x0000000fff057c10ULL, 0x000fe40008fe44ffULL,
0x00000005ff0b7c10ULL, 0x000fc60009fe84ffULL, 0x0000000804007986ULL, 0x0005e8000c10190cULL,
0x000000070a007986ULL, 0x0005e4000c10190cULL, 0x00000fff08087891ULL, 0x000fe2000f8e403fULL,
0x000000ff0000720cULL, 0x040fe20000725670ULL, 0x0000980000147ab9ULL, 0x000fe20000000a00ULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x0000000a08047291ULL, 0x000fe2000f8fa03fULL,
0x0000021000007945ULL, 0x000fe60003800000ULL, 0x00001000040478a5ULL, 0x000fc8000f8e0014ULL,
0x00000400100478a5ULL, 0x000fcc000f8e0004ULL, 0x00000004ff067e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff077e24ULL, 0x004fe4000f8e00ffULL, 0x0000001000047825ULL, 0x000fc800078e0006ULL,
0x0000001009067825ULL, 0x000fe200078e0006ULL, 0x0000000c04007986ULL, 0x0105e8000c101d0cULL,
0x0000001006007986ULL, 0x0025e2000c101d0cULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000000000581947ULL, 0x000fea0003800000ULL, 0x0000960000047ab9ULL, 0x000fe20000000a00ULL,
0xffffffff110a7890ULL, 0x000fe4000fffe03fULL, 0x00000004090478a5ULL, 0x000fc8000f8e0004ULL,
0x0000000aff077e24ULL, 0x004fe4000f8e00ffULL, 0x00000004ff047e24ULL, 0x000fe4000f8e00ffULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x0003ec0000008000ULL,
0x0000000000007992ULL, 0x002fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000007040479a8ULL, 0x000ea800099ee1ccULL,
0x00000000ff00798fULL, 0x004fe20002000000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fc40000000000ULL, 0x0000065405047896ULL, 0x002fe20008000004ULL,
0x0000000a04007c0cULL, 0x000fc8000bf25270ULL, 0x00000001ff027807ULL, 0x000fca0000800000ULL,
0x00000002ff007988ULL, 0x0003e80008000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ef00000008800ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x0000040000097882ULL, 0x000fc40000000000ULL, 0x0000065404097896ULL, 0x008fd20008000009ULL,
0x00000009ff027984ULL, 0x002e640008000000ULL, 0x000000ff0200720cULL, 0x002fda0003f25270ULL,
0x0000002000809947ULL, 0x000fea0003800000ULL, 0x0000000c008c0947ULL, 0x000fea0003800000ULL,
0x00000011ff007c0cULL, 0x000fda000bf05270ULL, 0x0000000000f08947ULL, 0x000fea0003800000ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011600ULL, 0x00000080070a78a5ULL, 0x000fe4000f8e0014ULL,
0x00000080040478a5ULL, 0x000fe2000f8e0014ULL, 0x0000007002087812ULL, 0x000fe400078ec0ffULL,
0x0000000c03117812ULL, 0x004fc800078ec0ffULL, 0x0000000a11027c10ULL, 0x140fe4000f91e008ULL,
0x0000000411047c10ULL, 0x000fe4000fb5e008ULL, 0x0000000bff037c10ULL, 0x000fe400087e24ffULL,
0x00000005ff057c10ULL, 0x000fc600097e64ffULL, 0x0000000c02067981ULL, 0x000368000c1e1900ULL,
0x0000000c04077981ULL, 0x000362000c1e1900ULL, 0x000000021100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000000207047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c02097981ULL, 0x000362000c1e1900ULL, 0x000000041100788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000908947ULL, 0x002fea0003800000ULL,
0x0000000307047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020b7981ULL, 0x000362000c1e1900ULL, 0x000000041100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000708947ULL, 0x002fea0003800000ULL,
0x0000000407047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020d7981ULL, 0x000362000c1e1900ULL, 0x000000061100788cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000508947ULL, 0x002fea0003800000ULL,
0x0000000507047890ULL, 0x000fc8000fffe03fULL, 0x00000080040478a5ULL, 0x000fcc000f8e0014ULL,
0x0000000411027c10ULL, 0x000fc8000f91e008ULL, 0x00000005ff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020f7981ULL, 0x000362000c1e1900ULL, 0x000000061100788cULL, 0x000fcc000bf05270ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x000000081100788cULL, 0x000fe4000bf06070ULL, 0x0000000607047890ULL, 0x000fc8000fffe03fULL,
0x000000000000781cULL, 0x000fe20003f8f008ULL, 0x00000080040478a5ULL, 0x000fc8000f8e0014ULL,
0x00000007070a0890ULL, 0x000fe4000fffe03fULL, 0x0000000411027c10ULL, 0x000fe4000f91e008ULL,
0x000000800a0a08a5ULL, 0x000fe4000f8e0014ULL, 0x00000005ff037c10ULL, 0x000fc800087e24ffULL,
0x0000000a11044c10ULL, 0x000fe4000fb5e008ULL, 0x0000000c02117981ULL, 0x000364000c1e1900ULL,
0x0000000bff054c10ULL, 0x000fca00097e64ffULL, 0x0000000c04134981ULL, 0x000368000c1e1900ULL,
0x00000007110a7890ULL, 0x000fc8000fffe03fULL, 0x000000033f0a7899ULL, 0x000fcc000801160aULL,
0x0000000aff007c0cULL, 0x000fda000bf05270ULL, 0x0000000800688947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x026fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00000007000b7c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000980000187ab9ULL, 0x000fca0000000a00ULL, 0x000000110400728cULL, 0x000fe4000bf06070ULL,
0x0000000105057890ULL, 0x000fc8000fffe03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000000a0500728cULL, 0x000fd8000bf06070ULL, 0x0000000800300947ULL, 0x022fea0003800000ULL,
0x00000008040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000506067209ULL, 0x000fe20007810000ULL,
0x00000001040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000080b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c02057981ULL, 0x000368000c1e1900ULL, 0x0000000400e82947ULL, 0x000fea0003800000ULL,
0x00000009040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fe20007810000ULL,
0x00000002040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x000000090b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c02077981ULL, 0x000368000c1e1900ULL, 0x0000000400a02947ULL, 0x000fea0003800000ULL,
0x0000000a040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000906067209ULL, 0x000fe20007810000ULL,
0x00000003040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000a0b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c02097981ULL, 0x000368000c1e1900ULL, 0x0000000400582947ULL, 0x000fea0003800000ULL,
0x0000000b040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fe20007810000ULL,
0x00000004040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000b0b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020b7981ULL, 0x000368000c1e1900ULL, 0x0000000400102947ULL, 0x000fea0003800000ULL,
0x0000000c040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fe20007810000ULL,
0x00000005040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000c0b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020d7981ULL, 0x000368000c1e1900ULL, 0x0000000000c82947ULL, 0x000fea0003800000ULL,
0x0000000d040e7890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fe20007810000ULL,
0x00000006040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000d0b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c020f7981ULL, 0x000368000c1e1900ULL, 0x0000000000802947ULL, 0x000fea0003800000ULL,
0x0000000e040e7890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fe20007810000ULL,
0x00000007040f7890ULL, 0x000fe4000fffe03fULL, 0x000000110e00728cULL, 0x000fe4000bf26070ULL,
0x000000110f00728cULL, 0x000fc8000bf46070ULL, 0x000000000000781cULL, 0x000fe40003f0f018ULL,
0x000000000000781cULL, 0x000fd60003f4f028ULL, 0x0000000000240947ULL, 0x000fea0003800000ULL,
0x0000000e0b0e7890ULL, 0x000fe2000fffe03fULL, 0x0000001000027824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe40000011600ULL, 0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000000e03027c10ULL, 0x000fc8000f91e002ULL, 0x0000000fff037c10ULL, 0x000fca00087e24ffULL,
0x0000000c02117981ULL, 0x000368000c1e1900ULL, 0x0000000000382947ULL, 0x000fea0003800000ULL,
0x0000000f040e7890ULL, 0x000fe2000fffe03fULL, 0x0000001306067209ULL, 0x000fc60007810000ULL,
0x000000110e00728cULL, 0x000fcc000bf26070ULL, 0x000000000000781cULL, 0x000fda0003f0f018ULL,
0x0000000000240947ULL, 0x000fea0003800000ULL, 0x0000000f0b0e7890ULL, 0x000fe2000fffe03fULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011600ULL,
0x000000800e0e78a5ULL, 0x000fe4000f8e0018ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000e03027c10ULL, 0x000fc8000f91e002ULL,
0x0000000fff037c10ULL, 0x000fca00087e24ffULL, 0x0000000c02137981ULL, 0x000368000c1e1900ULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x0000000804047890ULL, 0x000fe4000fffe03fULL,
0x000000080b0b7890ULL, 0x000fd4000fffe03fULL, 0xfffffff400ac8947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x0000001000027824ULL, 0x00afe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011600ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fc800078ec0ffULL, 0x0000000903037c10ULL, 0x000fca000fffe002ULL,
0x0000000603007388ULL, 0x0203e40000000800ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000007080e7291ULL, 0x000fe2000f8fa03fULL,
0x0000001000027824ULL, 0x040fe200078e00ffULL, 0x00000017070f7290ULL, 0x000fe2000fffe03fULL,
0x00000001ff037819ULL, 0x002fe20000011600ULL, 0x00000009101a7291ULL, 0x000fe2000f8e603fULL,
0x0000002000077836ULL, 0x004fe20000000000ULL, 0x00009800000a7ab9ULL, 0x000fe20000000a00ULL,
0x0000007002027812ULL, 0x000fe200078ec0ffULL, 0x000010000e0478a5ULL, 0x000fe2000f8e000aULL,
0x0000000c03037812ULL, 0x000fe200078ec0ffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x00000000003f7886ULL, 0x000fe20000000000ULL, 0x00000011ff007c0cULL, 0x000fe2000bf25270ULL,
0x00000400100478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000903147c10ULL, 0x000fc4000fffe002ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x000000800f1888a5ULL, 0x000fe2000f8e000aULL,
0x0000001a000d7c11ULL, 0x040fe2000f8e20ffULL, 0x00000080070a88a5ULL, 0x000fe2000f8e000aULL,
0x00000004ff047e24ULL, 0x000fe2000f8e00ffULL, 0x00000009101b8291ULL, 0x000fe2000f8e403fULL,
0x00000005ff057e24ULL, 0x000fe2000f8e00ffULL, 0x0000000910048291ULL, 0x000fe2000f8e403fULL,
0x00000018ff087e24ULL, 0x000fe2000f8e00ffULL, 0x0000000014147984ULL, 0x000e620000000800ULL,
0x00000019ff097e24ULL, 0x000fe2000f8e00ffULL, 0x0000001b000f8c11ULL, 0x040fe2000f8e20ffULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x0000000400118c11ULL, 0x000fc4000f8e20ffULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000aff0a7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000bff0b7e24ULL, 0x000fe2000f8e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fc4000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000001000088825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000040d7faeULL, 0x0005e2000b901c4cULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000010000a8825ULL, 0x000fe200078e000aULL,
0x00380000060d7faeULL, 0x0005e2000b901c4cULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x04580000080f8faeULL, 0x0005e2000b901c4cULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x041800000a118faeULL, 0x0005e8000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800909947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x104fe20000011600ULL,
0x000000010f0f7890ULL, 0x000fe2000fffe03fULL, 0xfffffff8ff057812ULL, 0x000fe200078ee200ULL,
0x0000000107047890ULL, 0x000fe2000fffe03fULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000000910057291ULL, 0x000fe2000f8e403fULL, 0x00000002ff3b7819ULL, 0x000fe20000011600ULL,
0x0000000805077836ULL, 0x040fe20000000000ULL, 0x0000000404067812ULL, 0x000fe200078efcffULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000704377812ULL, 0x000fe200078e7805ULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000704047812ULL, 0x000fe200078e7807ULL,
0x0000000fff367e24ULL, 0x000fe2000f8e00ffULL, 0x00000007063a7812ULL, 0x000fe200078e7807ULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000706057812ULL, 0x000fe200078e7805ULL,
0x00000004ff3c7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003837377212ULL, 0x080fe200078efcffULL,
0x00000005ff3f7e24ULL, 0x000fe2000f8e00ffULL, 0x0000003805387212ULL, 0x000fe200078efcffULL,
0x000000083b3d7836ULL, 0x000fe20000000000ULL, 0x0000000704397212ULL, 0x080fe200078efcffULL,
0x000000010e0e7890ULL, 0x000fe2000fffe03fULL, 0x000000073a3a7212ULL, 0x000fe200078efcffULL,
0x00000001000a7882ULL, 0x000fe20000000000ULL, 0x0000980000187ab9ULL, 0x000fd20000000a00ULL,
0x000000110a00728cULL, 0x000fcc000bf06070ULL, 0x000000000000781cULL, 0x000fda0003f0f008ULL,
0x0000000000900947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x040fe20003f04070ULL,
0x000000010a0f7892ULL, 0x000fe2000f8ec03fULL, 0x00000018ff0a7e24ULL, 0x000fe2000f8e00ffULL,
0x000010000e0478a5ULL, 0x000fe4000f8e0018ULL, 0x00000019ff0b7e24ULL, 0x000fe2000f8e00ffULL,
0x0000000b0a0b7899ULL, 0x000fe2000800063fULL, 0x0000002000077836ULL, 0x000fe20000000000ULL,
0x00000400100478a5ULL, 0x000fe2000f8e0004ULL, 0x0000000fff0e7e24ULL, 0x000fe2000f8e00ffULL,
0x000008000b0b7892ULL, 0x000fc6000f8ec03fULL, 0x00000000003f7886ULL, 0x000fe20000000000ULL,
0x0000008036048825ULL, 0x000fe200078e000aULL, 0x0000000b1a0b7290ULL, 0x000fc6000fffe03fULL,
0x00000009101b8291ULL, 0x000fe2000f8e403fULL, 0x00000004ff0c7e24ULL, 0x000fe2000f8e00ffULL,
0x00000009100f8291ULL, 0x000fe2000f8e403fULL, 0x00000005ff0d7e24ULL, 0x000fe4000f8e00ffULL,
0x000000803c0a8825ULL, 0x000fc800078e000aULL, 0x0000001bff3f8e24ULL, 0x000fe4000f8e00ffULL,
0x0000001000088825ULL, 0x000fc800078e0004ULL, 0x000000800e0f8824ULL, 0x000fe400078e023fULL,
0x0000000fff3f8e24ULL, 0x000fe4000f8e00ffULL, 0x0000001007067825ULL, 0x000fc800078e000cULL,
0x0000001000047825ULL, 0x040fe200078e000cULL, 0x0000000b000d7c11ULL, 0x000fc6000f8e20ffULL,
0x000000800e118824ULL, 0x000fe400078e023fULL, 0x00000010000f8824ULL, 0x040fe200078e020fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000040d7faeULL, 0x0005e2000b901c4cULL,
0x00000010000a8825ULL, 0x000fc600078e000aULL, 0x00380000060d7faeULL, 0x0005e2000b901c4cULL,
0x0000001000118824ULL, 0x000fc600078e0211ULL, 0x04580000080f8faeULL, 0x0005e8000b901c4cULL,
0x041800000a118faeULL, 0x0005e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff0a047890ULL, 0x000fe2000fffe03fULL, 0x0000000136367836ULL, 0x000fe20000000000ULL,
0x000000110a00728cULL, 0x000fe2000bf06070ULL, 0x000000013c3c7836ULL, 0x000fe20000000000ULL,
0x0000000704057899ULL, 0x000fe4000800063fULL, 0x0000000b04047899ULL, 0x000fe4000800063fULL,
0x0000008005057892ULL, 0x000fe2000f8ec03fULL, 0x000000000000781cULL, 0x000fe20003f0f008ULL,
0x0000080004047892ULL, 0x000fc4000f8ec03fULL, 0x000000010a0a7890ULL, 0x000fe4000fffe03fULL,
0x0000000502047c10ULL, 0x004fe2000fffe03fULL, 0x000001801a047890ULL, 0x000fe4000fffe004ULL,
0x000000010e0e7890ULL, 0x000fe4000fffe03fULL, 0x00000001033e7824ULL, 0x000fe400078e0204ULL,
0x0000000437047c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180003e0d7984ULL, 0x000ea20000000800ULL, 0x0000000438087c11ULL, 0x000fe4000f8e20ffULL,
0x00000004390c7c11ULL, 0x000fe2000f8e20ffULL, 0x004580003e417984ULL, 0x000fe20000000800ULL,
0x000000043a107c11ULL, 0x000fc6000f8e20ffULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000000808783bULL, 0x000f220000000200ULL, 0x0000000d14117221ULL, 0x006fc60000010100ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x3fb8aa3b11427820ULL, 0x000fc60000410000ULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x20000005ff437230ULL, 0x008fe40000004100ULL,
0x0000004200427308ULL, 0x000ee20000000800ULL, 0x30000005ff3e7230ULL, 0x000fe40000004100ULL,
0x20000007ff457230ULL, 0x000fe40000004100ULL, 0x30000007ff407230ULL, 0x000fe40000004100ULL,
0x20000009ff477230ULL, 0x010fc40000004100ULL, 0x2000000bff497230ULL, 0x000fe40000004100ULL,
0x3000000bff447230ULL, 0x000fe40000004100ULL, 0x20000006ff057230ULL, 0x000fe40000004100ULL,
0x00000041424e7220ULL, 0x008fe20000410000ULL, 0x30000009ff427230ULL, 0x000fe40000004100ULL,
0x20000004ff417230ULL, 0x000fe40000004100ULL, 0x000000354e357221ULL, 0x000fe20000010000ULL,
0x00001f3b4e507589ULL, 0x000ee200000e0000ULL, 0x20000008ff077230ULL, 0x000fc40000004100ULL,
0x2000000aff097230ULL, 0x000fe20000004100ULL, 0x00001f3d4e527589ULL, 0x000f2200000e0000ULL,
0x30000004ff047230ULL, 0x000fe40000004100ULL, 0x30000006ff067230ULL, 0x000fe40000004100ULL,
0x30000008ff087230ULL, 0x000fe40000004100ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x2000000dff4b7230ULL, 0x002fc40000004100ULL, 0x3000000dff467230ULL, 0x000fe40000004100ULL,
0x2000000fff4d7230ULL, 0x000fe40000004100ULL, 0x3000000fff487230ULL, 0x000fe40000004100ULL,
0x20000011ff4f7230ULL, 0x004fe40000004100ULL, 0x30000011ff4a7230ULL, 0x000fe40000004100ULL,
0x0000005041347223ULL, 0x008fe20000010034ULL, 0x2000000cff0b7230ULL, 0x000fc40000004100ULL,
0x0000005004337223ULL, 0x080fe20000010033ULL, 0x2000000eff0d7230ULL, 0x000fe40000004100ULL,
0x0000005043327223ULL, 0x080fe20000010032ULL, 0x20000010ff0f7230ULL, 0x000fe40000004100ULL,
0x000000503e2f7223ULL, 0x080fe2000001002fULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x00000050052e7223ULL, 0x000fe2000001002eULL, 0x3000000cff0c7230ULL, 0x000fc40000004100ULL,
0x00000050062b7223ULL, 0x080fe2000001002bULL, 0x3000000eff0e7230ULL, 0x000fe40000004100ULL,
0x00000050452a7223ULL, 0x080fe2000001002aULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x0000005040277223ULL, 0x080fe20000010027ULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x0000005007267223ULL, 0x000fe20000010026ULL, 0x20000013ff517230ULL, 0x000fc40000004100ULL,
0x0000005008237223ULL, 0x080fe20000010023ULL, 0x30000013ff4c7230ULL, 0x000fe40000004100ULL,
0x0000005047227223ULL, 0x080fe20000010022ULL, 0x00000050421f7223ULL, 0x080fe2000001001fULL,
0x00000050091e7223ULL, 0x080fe2000001001eULL, 0x000000500a1b7223ULL, 0x080fe2000001001bULL,
0x00000050491a7223ULL, 0x080fe2000001001aULL, 0x0000005044177223ULL, 0x000fe20000010017ULL,
0x000000520b167223ULL, 0x090fe20000010016ULL, 0x000000520c317223ULL, 0x080fe20000010031ULL,
0x000000524b307223ULL, 0x080fe20000010030ULL, 0x00000052462d7223ULL, 0x080fe2000001002dULL,
0x000000520d2c7223ULL, 0x080fe2000001002cULL, 0x000000520e297223ULL, 0x080fe20000010029ULL,
0x000000524d287223ULL, 0x080fe20000010028ULL, 0x0000005248257223ULL, 0x080fe20000010025ULL,
0x000000520f247223ULL, 0x080fe20000010024ULL, 0x0000005210217223ULL, 0x080fe20000010021ULL,
0x000000524f207223ULL, 0x080fe20000010020ULL, 0x000000524a1d7223ULL, 0x080fe2000001001dULL,
0x00000052111c7223ULL, 0x080fe2000001001cULL, 0x0000005212197223ULL, 0x080fe20000010019ULL,
0x0000005251187223ULL, 0x080fe20000010018ULL, 0x000000524c157223ULL, 0x000fe20000010015ULL,
0xfffffff400dc8947ULL, 0x000fec000383ffffULL, 0x0180000035007836ULL, 0x000fe20000000000ULL,
0x0000000000007b1dULL, 0x000fe80000010000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000b52000027802ULL, 0x000fce0000000f00ULL, 0x0000009800d87944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000003500027308ULL, 0x000ee40000001000ULL, 0xbf80000002007423ULL, 0x008fc80000000035ULL,
0x800000ff00037221ULL, 0x000fc80000010100ULL, 0x0000000302027223ULL, 0x000fce0000000002ULL,
0x0000000000007919ULL, 0x000ee40000000000ULL, 0x00000002ff097819ULL, 0x10cfe40000011600ULL,
0x00000008000d7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0902047589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff0f7812ULL, 0x000fc600078ee200ULL, 0x00001f0d020d7589ULL, 0x00072400000e0000ULL,
0x000000080f0e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000003404347220ULL, 0x044fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003204057220ULL, 0x040fe20000410000ULL, 0x0000002f04067220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002a04077220ULL, 0x040fe20000410000ULL, 0x0000002704087220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002204097220ULL, 0x040fe20000410000ULL, 0x0000001f04027220ULL, 0x048fe20000410000ULL,
0x0000001e040a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a040b7220ULL, 0x040fe20000410000ULL, 0x00000017040c7220ULL, 0x000fe20000410000ULL,
0x0000000303047812ULL, 0x000fe200078ec0ffULL, 0x000000160d167220ULL, 0x050fe20000410000ULL,
0x000000310d317220ULL, 0x040fe20000410000ULL, 0x000000300d307220ULL, 0x040fe20000410000ULL,
0x0000002d0d2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0d2c7220ULL, 0x040fe20000410000ULL,
0x000000290d297220ULL, 0x040fe20000410000ULL, 0x000000280d287220ULL, 0x040fe20000410000ULL,
0x000000250d257220ULL, 0x040fe20000410000ULL, 0x000000240d247220ULL, 0x040fe20000410000ULL,
0x000000210d217220ULL, 0x040fe20000410000ULL, 0x000000200d207220ULL, 0x040fe20000410000ULL,
0x0000001d0d1d7220ULL, 0x040fe20000410000ULL, 0x0000001c0d1c7220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000180d187220ULL, 0x040fe20000410000ULL,
0x000000150d0d7220ULL, 0x000fe20000410000ULL, 0x000000080f157836ULL, 0x000fe20000000000ULL,
0x0000000404107812ULL, 0x000fc400078efcffULL, 0x0000000704117812ULL, 0x000fe400078e780fULL,
0x0000000704177812ULL, 0x000fe200078e7815ULL, 0x0000000815047824ULL, 0x000fe200078e00ffULL,
0x0000000710137812ULL, 0x000fe400078e780fULL, 0x0000000710157812ULL, 0x000fe400078e7815ULL,
0x0000000e110f7212ULL, 0x080fe400078efcffULL, 0x0000000e130e7212ULL, 0x000fc400078efcffULL,
0x0000000417177212ULL, 0x080fe400078efcffULL, 0x0000000415157212ULL, 0x000fe400078efcffULL,
0x000000050605723eULL, 0x000fe400000000ffULL, 0x000000343304723eULL, 0x000fe400000000ffULL,
0x0000002e2b06723eULL, 0x000fe400000000ffULL, 0x000000070807723eULL, 0x000fc400000000ffULL,
0x000000160f0f7c11ULL, 0x000fe4000f8e20ffULL, 0x000000262308723eULL, 0x000fe400000000ffULL,
0x000000090209723eULL, 0x000fe200000000ffULL, 0x000000040f007844ULL, 0x0005e20000000200ULL,
0x0000000a1b0a723eULL, 0x000fe400000000ffULL, 0x0000000b0c0b723eULL, 0x000fe400000000ffULL,
0x000000160e0e7c11ULL, 0x000fc4000f8e20ffULL, 0x000000163110723eULL, 0x000fe400000000ffULL,
0x000000302d11723eULL, 0x000fe200000000ffULL, 0x000000080e007844ULL, 0x0005e20000000200ULL,
0x0000002c2912723eULL, 0x000fe400000000ffULL, 0x000000282513723eULL, 0x000fe400000000ffULL,
0x0000001617177c11ULL, 0x000fe4000f8e20ffULL, 0x000000242124723eULL, 0x000fc400000000ffULL,
0x000000201d25723eULL, 0x000fe200000000ffULL, 0x0000001017007844ULL, 0x0005e20000000200ULL,
0x0000001c1926723eULL, 0x000fe400000000ffULL, 0x000000180d27723eULL, 0x000fe400000000ffULL,
0x0000001615157c11ULL, 0x000fca000f8e20ffULL, 0x0000002415007844ULL, 0x0005e20000000200ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000057919ULL, 0x004ea20000002600ULL,
0x0000002000117836ULL, 0x000fe20000000000ULL, 0x0000000703077812ULL, 0x000fe200078e4800ULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000012ff127e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff027819ULL, 0x000fe20000011611ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0ffffff807077812ULL, 0x000fe200078ef800ULL,
0x00000012ff137e24ULL, 0x000fe2000f8e00ffULL, 0x0000000702047812ULL, 0x000fc400078e4811ULL,
0x0000000607087c11ULL, 0x000fe4000f8e20ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef811ULL,
0x0000000700077812ULL, 0x000fe400078ec0ffULL, 0x0000000604047c11ULL, 0x000fe2000f8e20ffULL,
0x0120000008087984ULL, 0x000f220000000c00ULL, 0x0000000711007812ULL, 0x000fe400078ec0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef812ULL, 0x01200000040c7984ULL, 0x000b220000000c00ULL,
0x1ffffff800117812ULL, 0x000fe200078ef813ULL, 0x00000005040472a4ULL, 0x008fe2000f8e023fULL,
0x0000000805067824ULL, 0x004fc400078e00ffULL, 0x0000000805057824ULL, 0x000fc600078e00ffULL,
0xfffffff806037812ULL, 0x000fe400078ee203ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402057c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe40000000a00ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x0000000403027c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x0000000405047c11ULL, 0x020fc4000f8248ffULL, 0x0000000503037c11ULL, 0x000fe400080f4c10ULL,
0x0000000505057c11ULL, 0x000fe200088f4c06ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d0cULL,
0x0000000c04007986ULL, 0x002fe2000c101d0cULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000040001387983ULL, 0x000ea20000100800ULL, 0x00000001ff027424ULL, 0x000fcc00078e00ffULL,
0x01c60002ff0279a7ULL, 0x000e620008500006ULL, 0x00000000380772caULL, 0x004fda00000e0000ULL,
0x0000001007077291ULL, 0x000fc8000f8e103fULL, 0x000000040700728cULL, 0x000fcc000bf06070ULL,
0x000000000000781cULL, 0x000fca0003f0f008ULL, 0x0000000108098899ULL, 0x000fe2000800063fULL,
0x00009000000a8ab9ULL, 0x000fc60000000800ULL, 0x0000000a090982a4ULL, 0x000fc6000f8e0207ULL,
0x00008c00000a8ab9ULL, 0x000fe40000000a00ULL, 0x00000004090a88a5ULL, 0x000fcc000f8e000aULL,
0x0000000aff047e24ULL, 0x000fe4000f8e00ffULL, 0x0000000bff057e24ULL, 0x000fca000f8e00ffULL,
0x0000000c04048981ULL, 0x000ea2000c1e1900ULL, 0x0000000138067836ULL, 0x000fe20000000000ULL,
0x000000060f0a7899ULL, 0x000fe2000800063fULL, 0x0000000000227919ULL, 0x000e620000000000ULL,
0xffffffff00137882ULL, 0x000fe20000000000ULL, 0x0000000610157899ULL, 0x000fe2000800063fULL,
0x00000000040982caULL, 0x004fe400000e0000ULL, 0x0000000506007c0cULL, 0x000fd6000bf06070ULL,
0x0000000900138c82ULL, 0x000fe40008000000ULL, 0x0000000a130b72a4ULL, 0x000fe2000f8e023fULL,
0x0000000c00ac8947ULL, 0x002ff60003800000ULL, 0x0000001538047c11ULL, 0x000fe2000f8e40ffULL,
0x0000000eff087e24ULL, 0x000fe2000f8e00ffULL, 0x00000003ff077819ULL, 0x000fe20000011622ULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000001404057c48ULL, 0x000fe2000ffe0000ULL,
0x0000000610097291ULL, 0x000fe2000f8e703fULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000407097836ULL, 0x000fe40000000000ULL, 0x0000000105047824ULL, 0x000fe200078e0a04ULL,
0x0000200009097890ULL, 0x000fe2000fffe03fULL, 0x00000008090e7824ULL, 0x040fe200078e00ffULL,
0x0000002209057212ULL, 0x000fe200078e3cffULL, 0x00000008070b7836ULL, 0x000fe20000000000ULL,
0x000000040900720cULL, 0x000fe20003f06070ULL, 0x0000000c07097836ULL, 0x000fe20000000000ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL, 0x000000080b127824ULL, 0x040fe200078e00ffULL,
0x000000220b057212ULL, 0x000fe200078e3cffULL, 0x0000001807177836ULL, 0x000fe20000000000ULL,
0x000000040b00720cULL, 0x000fe20003f46070ULL, 0x00000008090b7824ULL, 0x040fe200078e00ffULL,
0x0000002209067212ULL, 0x000fe200078e3cffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000004008057824ULL, 0x000fe200078e0207ULL,
0xfffffff80b147812ULL, 0x000fc400078ee206ULL, 0x000000040900720cULL, 0x000fe20003f26070ULL,
0x0000000405067836ULL, 0x000fe20000000000ULL, 0x0000000b050a7c10ULL, 0x000fe2000ff7e0ffULL,
0x0000001007097836ULL, 0x000fe40000000000ULL, 0x00000008050c7836ULL, 0x000fe20000000000ULL,
0x0000000b06067c10ULL, 0x000fe2000ffbe0ffULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0x0000002209087212ULL, 0x040fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x000000040900720cULL, 0x000fe20003f86070ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00000016060b7c11ULL, 0x000fe2000f8a48ffULL, 0x00000018051c7836ULL, 0x040fe20000000000ULL,
0x000000160a0d7c11ULL, 0x000fe2000f8648ffULL, 0x0000001c051a7836ULL, 0x000fe20000000000ULL,
0xfffffff811167812ULL, 0x000fe200078ee208ULL, 0x0000001407117836ULL, 0x000fe20000000000ULL,
0x0000001706067c11ULL, 0x000fc4000a8f4c09ULL, 0x000000170a0a7c11ULL, 0x000fe200098f4c0fULL,
0x0000000811197824ULL, 0x000fe200078e00ffULL, 0x0000000707097812ULL, 0x000fe400078e4822ULL,
0x0000000d00087210ULL, 0x000fe40007fbe0ffULL, 0x000000040700720cULL, 0x000fe40003f66070ULL,
0x0ffffff8090d7812ULL, 0x000fe200078ef822ULL, 0x000000ffff097224ULL, 0x000fe200028e060aULL,
0x0000000b000a7210ULL, 0x000fc40007fbe0ffULL, 0x0000000b0c0c7c10ULL, 0x000fe4000ffde0ffULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200028e0606ULL,
0x0000002211107212ULL, 0x000fe200078e3cffULL, 0x0000000c05067836ULL, 0x000fe20000000000ULL,
0x000000041100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x000000160c157c11ULL, 0x000fe2000f8c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000d901c4cULL, 0xfffffff819197812ULL, 0x000fe200078ee210ULL,
0x0000001005107836ULL, 0x000fe20000000000ULL, 0x0000000b06067c10ULL, 0x000fc4000ff7e0ffULL,
0x000000170c0c7c11ULL, 0x000fe4000b0f4c0fULL, 0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000000b10107c10ULL, 0x000fe4000ffde0ffULL,
0x0000001606117c11ULL, 0x040fe2000f8648ffULL, 0x000000000a0f7faeULL, 0x0005e2000c101c4cULL,
0x00000022170e7212ULL, 0x040fe200078e3cffULL, 0x000000ffff097224ULL, 0x002fe200030e06ffULL,
0x000000041700720cULL, 0x000fe20003f06070ULL, 0x0000001c070d7836ULL, 0x000fe20000000000ULL,
0x0000001706067c11ULL, 0x000fc400098f4c13ULL, 0x0000001610177c11ULL, 0x040fe2000f8c48ffULL,
0x000000080d217824ULL, 0x000fe200078e00ffULL, 0x0000001500087210ULL, 0x000fe40007f7e0ffULL,
0x0000001710107c11ULL, 0x000fe2000b0f4c09ULL, 0x00000014050a7836ULL, 0x004fe20000000000ULL,
0xfffffff81b207812ULL, 0x000fe200078ee20eULL, 0x000000ffff097224ULL, 0x000fe200018e060cULL,
0x000000220d0e7212ULL, 0x000fe400078e3cffULL, 0x0000000b0a0c7c10ULL, 0x000fc4000ffde0ffULL,
0x00000011000a7210ULL, 0x000fe20007f7e0ffULL, 0x0000002007117836ULL, 0x000fe20000000000ULL,
0xfffffff821217812ULL, 0x000fe200078ee20eULL, 0x000000ffff0f7224ULL, 0x000fe200030e06ffULL,
0x000000160c157c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200018e0606ULL,
0x000000040d00720cULL, 0x000fe40003f66070ULL, 0x00000009120d7c11ULL, 0x000fe4000f8e20ffULL,
0x000000170c0c7c11ULL, 0x000fc4000b0f4c0fULL, 0x00000009140f7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000080d7faeULL, 0x0003e2000d101c4cULL, 0x0000000b1c1c7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000b1a1a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000000a0f7faeULL, 0x0005e2000c901c4cULL,
0x0000002211067212ULL, 0x040fe200078e3cffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x000000161c1d7c11ULL, 0x040fe4000f8448ffULL, 0x000000041100720cULL, 0x040fe20003f26070ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x000000171c1c7c11ULL, 0x000fe200090f4c13ULL,
0x000000ffff097224ULL, 0x002fe200030e06ffULL, 0x000000161a1b7c11ULL, 0x000fe2000f8c48ffULL,
0x00000024070d7836ULL, 0x000fe20000000000ULL, 0x0000001700087210ULL, 0x000fc40007f5e0ffULL,
0xfffffff8110e7812ULL, 0x000fe200078ee206ULL, 0x0000002005067836ULL, 0x000fe20000000000ULL,
0x000000171a1a7c11ULL, 0x000fe2000b0f4c09ULL, 0x000000ffff097224ULL, 0x000fe200010e0610ULL,
0x00000015000a7210ULL, 0x004fe20007f5e0ffULL, 0x000000080d117824ULL, 0x040fe200078e00ffULL,
0x0000000b06187c10ULL, 0x000fe4000ffde0ffULL, 0x000000220d067212ULL, 0x040fe200078e3cffULL,
0x000000ffff0b7224ULL, 0x000fe200010e060cULL, 0x000000040d00720cULL, 0x000fe20003f46070ULL,
0x000000ffff0f7224ULL, 0x000fe200030e06ffULL, 0xfffffff811107812ULL, 0x000fe200078ee206ULL,
0x0000002405067836ULL, 0x000fe20000000000ULL, 0x00000009160d7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002807117836ULL, 0x000fe20000000000ULL, 0x0000001618157c11ULL, 0x000fc6000f8c48ffULL,
0x00000000080d7faeULL, 0x0003e2000e101c4cULL, 0x0000000b06167c10ULL, 0x000fe2000ff9e0ffULL,
0x0000002805067836ULL, 0x000fe20000000000ULL, 0x0000001718187c11ULL, 0x000fe4000b0f4c0fULL,
0x00000009190f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x0000001616197c11ULL, 0x040fe4000f8848ffULL, 0x0000000b061f7c10ULL, 0x000fe2000ffde0ffULL,
0x0000002c05067836ULL, 0x000fe20000000000ULL, 0x0000001716167c11ULL, 0x000fe2000a0f4c13ULL,
0x0000002c070d7836ULL, 0x002fe20000000000ULL, 0x0000001d00087210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000161f177c11ULL, 0x000fe2000f8c48ffULL,
0x000000000a0f7faeULL, 0x0003e2000e901c4cULL, 0x00000022110c7212ULL, 0x040fe200078e3cffULL,
0x000000ffff097224ULL, 0x000fe200020e061cULL, 0x000000041100720cULL, 0x040fe20003fa6070ULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0x000000171f1f7c11ULL, 0x000fe2000b0f4c14ULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x0000000b061e7c10ULL, 0x000fc4000ffde0ffULL,
0x000000220d067212ULL, 0x000fe400078e3cffULL, 0xfffffff811127812ULL, 0x000fe200078ee20cULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000001b000a7210ULL, 0x002fe40007f9e0ffULL,
0xfffffff813147812ULL, 0x000fe200078ee206ULL, 0x0000003005067836ULL, 0x000fe20000000000ULL,
0x000000161e1b7c11ULL, 0x000fe2000f8c48ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e061aULL,
0x000000040d00720cULL, 0x000fe20003f86070ULL, 0x00000030070d7836ULL, 0x000fe20000000000ULL,
0x00000009200f7c11ULL, 0x000fc4000f8e20ffULL, 0x000000171e1e7c11ULL, 0x000fe2000b0f4c11ULL,
0x000000080d1a7824ULL, 0x040fe200078e00ffULL, 0x000000220d137212ULL, 0x000fe200078e3cffULL,
0x00000000080f7faeULL, 0x0003e2000c101c4cULL, 0x0000000b061c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000003405067836ULL, 0x000fe20000000000ULL, 0x0000000921117c11ULL, 0x000fe4000f8e20ffULL,
0x00000015000c7210ULL, 0x000fe40007f1e0ffULL, 0xfffffff81a157812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200030e06ffULL, 0x000000000a117faeULL, 0x0005e2000d901c4cULL,
0x000000040d00720cULL, 0x000fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e0618ULL,
0x000000161c0f7c11ULL, 0x002fc4000f8c48ffULL, 0x0000001900087210ULL, 0x000fe20007f1e0ffULL,
0x0000003c07197836ULL, 0x000fe20000000000ULL, 0x000000171c1c7c11ULL, 0x000fe4000b0f4c13ULL,
0x0000000b061a7c10ULL, 0x000fe2000ffde0ffULL, 0x000000ffff097224ULL, 0x000fe200000e0616ULL,
0x0000000915157c11ULL, 0x000fe2000f8e20ffULL, 0x00000034070b7836ULL, 0x004fe20000000000ULL,
0x000000090e117c11ULL, 0x000fe2000f8e20ffULL, 0x00000038050a7836ULL, 0x000fe40000000000ULL,
0x000000080b137824ULL, 0x040fe200078e00ffULL, 0x000000220b067212ULL, 0x040fe200078e3cffULL,
0x000000000c117faeULL, 0x0003e2000c901c4cULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0xfffffff813167812ULL, 0x000fe200078ee206ULL,
0x0000003c05057836ULL, 0x000fe20000000000ULL, 0x0000000910137c11ULL, 0x000fc4000f8e20ffULL,
0x000000161a1d7c11ULL, 0x040fe4000f8c48ffULL, 0x0000000b0a187c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000008137faeULL, 0x0005e2000d101c4cULL, 0x0000001700067210ULL, 0x000fe20007f5e0ffULL,
0x0000003807177836ULL, 0x000fe20000000000ULL, 0x000000171a1a7c11ULL, 0x000fe2000b0f4c0bULL,
0x000000ffff0d7224ULL, 0x002fe200008e06ffULL, 0x0000001b000a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200010e061fULL, 0x00000016181b7c11ULL, 0x000fc4000f8248ffULL,
0x0000000f000e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e061eULL,
0x0000001718187c11ULL, 0x000fe200088f4c0dULL, 0x0000000817097824ULL, 0x044fe200078e00ffULL,
0x0000000b05107c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x000000041700720cULL, 0x080fe20003fc6070ULL, 0x0000000819087824ULL, 0x040fe200078e00ffULL,
0x000000041900720cULL, 0x000fe20003f46070ULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x0000002217047212ULL, 0x000fc400078e3cffULL, 0x0000001610177c11ULL, 0x000fe4000f8248ffULL,
0x0000000912117c11ULL, 0x000fe4000f8e20ffULL, 0x0000001710107c11ULL, 0x000fe400088f4c13ULL,
0x0000000914137c11ULL, 0x000fe2000f8e20ffULL, 0x0000000006117faeULL, 0x0003e2000e901c4cULL,
0x0000002219057212ULL, 0x000fe400078e3cffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x000000000a137faeULL, 0x0003e2000e101c4cULL, 0xfffffff8080d7812ULL, 0x000fc400078ee205ULL,
0x0000001d00047210ULL, 0x000fe20007f3e0ffULL, 0x000000000e157faeULL, 0x0003e2000d901c4cULL,
0x0000001b00087210ULL, 0x000fe40007f7e0ffULL, 0x00000017000c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200008e061aULL, 0x0000000916177c11ULL, 0x000fe4000f8e20ffULL,
0x0000000909197c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff097224ULL, 0x000fe200018e0618ULL,
0x000000090d1b7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0610ULL,
0x0000000004177faeULL, 0x0003e8000c101c4cULL, 0x0000000008197faeULL, 0x0003e8000f101c4cULL,
0x000000000c1b7faeULL, 0x0003e2000d101c4cULL, 0x0000000c005c7947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011622ULL, 0x0000000eff167e24ULL, 0x000fe2000f8e00ffULL,
0x00008a0000167ab9ULL, 0x000fe20000000a00ULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x0000000610097291ULL, 0x000fe2000f8e703fULL, 0x0000000413047836ULL, 0x040fe40000000000ULL,
0x0000000813067836ULL, 0x040fe20000000000ULL, 0x0000200009097890ULL, 0x000fe2000fffe03fULL,
0x0000000c13087836ULL, 0x040fe20000000000ULL, 0x0000002204057212ULL, 0x0c0fe200078e3cffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000002206077212ULL, 0x0c0fe200078e3cffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x0000002208067212ULL, 0x0c0fe200078e3cffULL,
0x0000000808097824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee205ULL,
0x0000001013057836ULL, 0x040fe20000000000ULL, 0xfffffff80a077812ULL, 0x000fe200078ee207ULL,
0x0000001c130b7836ULL, 0x040fe20000000000ULL, 0xfffffff809067812ULL, 0x000fe200078ee206ULL,
0x0000001413097836ULL, 0x000fe20000000000ULL, 0x0000002205087212ULL, 0x0c0fe200078e3cffULL,
0x0000000805057824ULL, 0x000fe200078e00ffULL, 0x0000000907077c11ULL, 0x000fe2000f8e20ffULL,
0x00000008090d7824ULL, 0x040fe200078e00ffULL, 0x00000022090a7212ULL, 0x080fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff805057812ULL, 0x000fe200078ee208ULL,
0x0000001813087836ULL, 0x040fe20000000000ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee20aULL,
0x00000028130d7836ULL, 0x000fe20000000000ULL, 0x0000000905057c11ULL, 0x000fe2000f8e20ffULL,
0x00000008080c7824ULL, 0x040fe200078e00ffULL, 0x0000002208097212ULL, 0x080fe200078e3cffULL,
0x0000003413117836ULL, 0x000fe20000000000ULL, 0x000000220b087212ULL, 0x000fe200078e3cffULL,
0x00000020130b7836ULL, 0x040fe20000000000ULL, 0xfffffff80c097812ULL, 0x000fe200078ee209ULL,
0x00000024130c7836ULL, 0x000fe20000000000ULL, 0xfffffff80f087812ULL, 0x000fc400078ee208ULL,
0x000000220b107212ULL, 0x0c0fe200078e3cffULL, 0x000000080b0b7824ULL, 0x000fe200078e00ffULL,
0x000000220c0f7212ULL, 0x0c0fe200078e3cffULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0x000000220d0e7212ULL, 0x0c0fe200078e3cffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b107812ULL, 0x000fe200078ee210ULL, 0x0000002c130b7836ULL, 0x040fe20000000000ULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee20fULL, 0x00000030130c7836ULL, 0x000fe20000000000ULL,
0xfffffff80d0e7812ULL, 0x000fe200078ee20eULL, 0x000000080b147824ULL, 0x040fe200078e00ffULL,
0x000000220b0d7212ULL, 0x000fc400078e3cffULL, 0x000000220c0b7212ULL, 0x0c0fe200078e3cffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000002211127212ULL, 0x0c0fe200078e3cffULL,
0x0000000811117824ULL, 0x000fe200078e00ffULL, 0xfffffff8140d7812ULL, 0x000fe200078ee20dULL,
0x0000004016147824ULL, 0x000fe200078e0213ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x0000003c13167836ULL, 0x040fe20000000000ULL, 0xfffffff8110b7812ULL, 0x000fe200078ee212ULL,
0x0000000414117836ULL, 0x000fe20000000000ULL, 0x0000000b14157c10ULL, 0x000fe2000ff1e0ffULL,
0x0000003813127836ULL, 0x000fe20000000000ULL, 0x00000022161c7212ULL, 0x000fc400078e3cffULL,
0x0000000b11187c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000816117824ULL, 0x000fe200078e00ffULL,
0x00000022121a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000001615177c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff197224ULL, 0x000fe200008e06ffULL,
0x00000016181b7c11ULL, 0x000fe2000f8248ffULL, 0x00000008121d7824ULL, 0x000fe200078e00ffULL,
0x0000001715167c11ULL, 0x000fe200080f4c16ULL, 0x0000000814157836ULL, 0x000fe20000000000ULL,
0x0000001718197c11ULL, 0x000fe200088f4c19ULL, 0x0000000c14187836ULL, 0x040fe20000000000ULL,
0xfffffff81d127812ULL, 0x000fe200078ee21aULL, 0x00000014141d7836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fc4000ff1e0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee21cULL,
0x00000010141c7836ULL, 0x040fe20000000000ULL, 0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000b1d1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x00000016151d7c11ULL, 0x040fe2000f8048ffULL, 0x000000ffff217224ULL, 0x000fe200008e06ffULL,
0x0000000b1c1c7c10ULL, 0x000fe2000ff5e0ffULL, 0x000000ffff297224ULL, 0x000fe200018e06ffULL,
0x00000017151f7c11ULL, 0x000fe200080f4c18ULL, 0x0000001814157836ULL, 0x000fe20000000000ULL,
0x000000161a237c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff257224ULL, 0x000fe200010e06ffULL,
0x000000161c277c11ULL, 0x000fe2000f8448ffULL, 0x0000001c14187836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fc4000ff1e0ffULL, 0x000000171c257c11ULL, 0x000fe200090f4c25ULL,
0x00000020141c7836ULL, 0x000fe20000000000ULL, 0x000000171a217c11ULL, 0x000fe400088f4c21ULL,
0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00000016152d7c11ULL, 0x000fe4000f8048ffULL, 0x000000161e2b7c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff2f7224ULL, 0x000fe200008e06ffULL, 0x0000000b1c1c7c10ULL, 0x000fc4000ff5e0ffULL,
0x00000017152c7c11ULL, 0x000fe200080f4c18ULL, 0x0000002814157836ULL, 0x000fe20000000000ULL,
0x000000171e297c11ULL, 0x000fe200098f4c29ULL, 0x00000024141e7836ULL, 0x000fe20000000000ULL,
0x000000161a317c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff337224ULL, 0x000fe200010e06ffULL,
0x000000161c357c11ULL, 0x000fe2000f8448ffULL, 0x0000002c14187836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000b1e1e7c10ULL, 0x000fc4000ff7e0ffULL,
0x000000171c337c11ULL, 0x000fe200090f4c33ULL, 0x00000030141c7836ULL, 0x000fe20000000000ULL,
0x000000171a2f7c11ULL, 0x000fe200088f4c2fULL, 0x000000ffff377224ULL, 0x000fe200018e06ffULL,
0x0000000b181a7c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00000016153b7c11ULL, 0x000fe4000f8048ffULL, 0x000000161e397c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x0000000b1c1c7c10ULL, 0x000fc4000ff5e0ffULL,
0x0000001715347c11ULL, 0x000fe200080f4c18ULL, 0x0000003814157836ULL, 0x000fe20000000000ULL,
0x000000171e377c11ULL, 0x000fe200098f4c37ULL, 0x00000034141e7836ULL, 0x000fe20000000000ULL,
0x000000161a3f7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff417224ULL, 0x000fe200010e06ffULL,
0x000000161c437c11ULL, 0x000fe2000f8448ffULL, 0x0000003c14147836ULL, 0x000fe20000000000ULL,
0x0000000b15157c10ULL, 0x000fe4000ff1e0ffULL, 0x000000171a3d7c11ULL, 0x000fc400088f4c3dULL,
0x000000171c417c11ULL, 0x000fe200090f4c41ULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000000b141a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000b1e1e7c10ULL, 0x000fe4000ff7e0ffULL,
0x0000001615497c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x0000001700147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff457224ULL, 0x000fe200018e06ffULL,
0x0000000713137812ULL, 0x000fc400078e4822ULL, 0x000000161a4d7c11ULL, 0x000fe4000f8448ffULL,
0x000000161e477c11ULL, 0x000fe4000f8648ffULL, 0x0000001715367c11ULL, 0x000fe200088f4c18ULL,
0x000000ffff157224ULL, 0x000fe200000e0616ULL, 0x0ffffff813137812ULL, 0x000fe400078ef822ULL,
0x000000171a4b7c11ULL, 0x000fe400090f4c4bULL, 0x0000001b00167210ULL, 0x000fc40007f3e0ffULL,
0x000000171e457c11ULL, 0x000fe400098f4c45ULL, 0x0000001d00187210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0619ULL, 0x00000023001a7210ULL, 0x000fe40007f7e0ffULL,
0x00000027001c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff197224ULL, 0x000fe200010e061fULL,
0x0000000913137c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff1b7224ULL, 0x000fe200018e0621ULL,
0x0000002b001e7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200028e0625ULL,
0x0000002d00207210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014137faeULL, 0x000fe2000b901c4cULL, 0x0000000904277c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e0629ULL, 0x0000003100227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e062cULL, 0x0000003500247210ULL, 0x000fe20007f5e0ffULL,
0x0000000016277faeULL, 0x0003e2000b901c4cULL, 0x00000009062b7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff237224ULL, 0x000fe200008e062fULL, 0x0000003900287210ULL, 0x000fe20007f7e0ffULL,
0x0000000018077faeULL, 0x000fe2000b901c4cULL, 0x0000003b00267210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e0633ULL, 0x000000090a2d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000001a2b7faeULL, 0x0005e2000b901c4cULL, 0x0000003f002a7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e0637ULL, 0x0000000909097c11ULL, 0x000fe2000f8e20ffULL,
0x000000001c057faeULL, 0x000fe2000b901c4cULL, 0x00000043002c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff277224ULL, 0x002fe200028e0634ULL, 0x0000000908137c11ULL, 0x000fe2000f8e20ffULL,
0x000000001e2d7faeULL, 0x0003e2000b901c4cULL, 0x00000047002e7210ULL, 0x000fc40007f3e0ffULL,
0x0000000910157c11ULL, 0x000fe2000f8e20ffULL, 0x0000000020097faeULL, 0x0007e2000b901c4cULL,
0x0000004900307210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2b7224ULL, 0x004fe200020e063dULL,
0x000000090f0f7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000022137faeULL, 0x0009e2000b901c4cULL,
0x0000004d00327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2f7224ULL, 0x000fe200008e0645ULL,
0x000000090e077c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff2d7224ULL, 0x002fe200000e0641ULL,
0x000000090d0d7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000024157faeULL, 0x0009e2000b901c4cULL,
0x000000090c057c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff317224ULL, 0x000fe200010e0636ULL,
0x000000090b0b7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000280f7faeULL, 0x0009e2000b901c4cULL,
0x0000000912097c11ULL, 0x008fe2000f8e20ffULL, 0x000000ffff337224ULL, 0x000fe200018e064bULL,
0x0000000911117c11ULL, 0x000fe2000f8e20ffULL, 0x0000000026077faeULL, 0x0009e8000b901c4cULL,
0x000000002a0d7faeULL, 0x0009e8000b901c4cULL, 0x000000002c057faeULL, 0x0009e8000b901c4cULL,
0x000000002e0b7faeULL, 0x0009e8000b901c4cULL, 0x0000000030097faeULL, 0x0009e8000b901c4cULL,
0x0000000032117faeULL, 0x0009e4000b901c4cULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01c60003ff0075a7ULL, 0x000ea20008000146ULL, 0x0000000538007c0cULL, 0x000fe2000bf26070ULL,
0x0000006c00e08947ULL, 0x004fd80003800000ULL, 0x000000000000194dULL, 0x000fea0003800000ULL,
0x00009000000b7ab9ULL, 0x000fe40000000800ULL, 0x0000000b080b72a4ULL, 0x000fd8000f8e023fULL,
0x0000040001007983ULL, 0x000ea40000100800ULL, 0x00000000001272caULL, 0x004fda00000e0000ULL,
0x0000001512127291ULL, 0x000fc8000f8e403fULL, 0x000000121400728cULL, 0x000fcc000bf04070ULL,
0x000000000000781cULL, 0x000fda0003f0f008ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000100007836ULL, 0x000fe20000000000ULL, 0x00000000002e7919ULL, 0x010ea20000000000ULL,
0x000000130a1672a4ULL, 0x000fc6000f8e023fULL, 0x0000000500007c0cULL, 0x000fda000bf06070ULL,
0x0000000c00d48947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x004fe2000001162eULL,
0x0000000eff077e24ULL, 0x002fe2000f8e00ffULL, 0x00008a0000187ab9ULL, 0x000fe20000000a00ULL,
0x8000001214097290ULL, 0x000fe4000fffe03fULL, 0x0000000800677836ULL, 0x040fe20000000000ULL,
0x0000000610087291ULL, 0x000fe2000f8e703fULL, 0x0000000400687836ULL, 0x040fe40000000000ULL,
0x0000000867037824ULL, 0x040fe200078e00ffULL, 0x0000002e675e7212ULL, 0x080fe200078e3cffULL,
0x0000000c00667836ULL, 0x000fe20000000000ULL, 0x0000002e685f7212ULL, 0x0c0fe200078e3cffULL,
0x0000000868027824ULL, 0x000fe200078e00ffULL, 0xfffffff8035e7812ULL, 0x000fe200078ee25eULL,
0x0000001800637836ULL, 0x000fe20000000000ULL, 0x0000002e665d7212ULL, 0x080fe200078e3cffULL,
0x0000001000657836ULL, 0x040fe20000000000ULL, 0xfffffff8025f7812ULL, 0x000fe200078ee25fULL,
0x0000001400647836ULL, 0x000fe20000000000ULL, 0x0000002e635a7212ULL, 0x080fe200078e3cffULL,
0x0000000866047824ULL, 0x000fe200078e00ffULL, 0x0000002e655c7212ULL, 0x080fe200078e3cffULL,
0x0000000863037824ULL, 0x000fe200078e00ffULL, 0x0000002e645b7212ULL, 0x080fe200078e3cffULL,
0x0000000865057824ULL, 0x000fe200078e00ffULL, 0xfffffff8045d7812ULL, 0x000fe200078ee25dULL,
0x0000001c00627836ULL, 0x000fe20000000000ULL, 0xfffffff8035a7812ULL, 0x000fe200078ee25aULL,
0x0000000864027824ULL, 0x000fe200078e00ffULL, 0xfffffff8055c7812ULL, 0x000fe200078ee25cULL,
0x0000002800697836ULL, 0x000fe20000000000ULL, 0x0000002e62597212ULL, 0x080fe200078e3cffULL,
0x0000002000617836ULL, 0x040fe20000000000ULL, 0xfffffff8025b7812ULL, 0x000fe200078ee25bULL,
0x00000024006a7836ULL, 0x000fe20000000000ULL, 0x0000002e69567212ULL, 0x080fe200078e3cffULL,
0x0000000862047824ULL, 0x000fe200078e00ffULL, 0x0000002e61587212ULL, 0x080fe200078e3cffULL,
0x0000000869037824ULL, 0x000fe200078e00ffULL, 0x0000002e6a577212ULL, 0x080fe200078e3cffULL,
0x0000000861057824ULL, 0x000fe200078e00ffULL, 0xfffffff804597812ULL, 0x000fe200078ee259ULL,
0x0000002c00757836ULL, 0x000fe20000000000ULL, 0xfffffff803567812ULL, 0x000fe200078ee256ULL,
0x000000086a027824ULL, 0x000fe200078e00ffULL, 0xfffffff805587812ULL, 0x000fe200078ee258ULL,
0x00000038006b7836ULL, 0x040fe20000000000ULL, 0x0000002e75557212ULL, 0x0c0fe200078e3cffULL,
0x00000030006d7836ULL, 0x040fe20000000000ULL, 0xfffffff802577812ULL, 0x000fe200078ee257ULL,
0x0000000875047824ULL, 0x000fe200078e00ffULL, 0x0000002e6b527212ULL, 0x0c0fe200078e3cffULL,
0x000000086b037824ULL, 0x000fe200078e00ffULL, 0x0000002e6d547212ULL, 0x0c0fe200078e3cffULL,
0x000000086d057824ULL, 0x000fe200078e00ffULL, 0xfffffff804557812ULL, 0x000fe200078ee255ULL,
0x00000034006c7836ULL, 0x040fe20000000000ULL, 0xfffffff803527812ULL, 0x000fe200078ee252ULL,
0x0000004007027824ULL, 0x000fe200078e0200ULL, 0xfffffff805547812ULL, 0x000fe200078ee254ULL,
0x0000003c00767836ULL, 0x000fe20000000000ULL, 0x0000002e6c537212ULL, 0x0c0fe200078e3cffULL,
0x000000086c047824ULL, 0x000fe200078e00ffULL, 0x0000001602037c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000876067824ULL, 0x040fe200078e00ffULL, 0x0000002e76057212ULL, 0x000fe200078e3cffULL,
0x0000000402087836ULL, 0x040fe20000000000ULL, 0xfffffff804537812ULL, 0x000fe200078ee253ULL,
0x00000008020b7836ULL, 0x040fe20000000000ULL, 0xfffffff806057812ULL, 0x000fe200078ee205ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x0000001608047c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000c020c7836ULL, 0x040fe20000000000ULL, 0x0000001803067c11ULL, 0x040fe2000f8248ffULL,
0x0000800801007387ULL, 0x0003e20000100800ULL, 0x0000001002107836ULL, 0x040fe20000000000ULL,
0x00004000080f7890ULL, 0x000fe2000fffe03fULL, 0x000000ffff097224ULL, 0x000fe200010e06ffULL,
0x00007c0b01007387ULL, 0x0005e20000100800ULL, 0x0000001903077c11ULL, 0x000fe200088f4c0aULL,
0x00000014020f7836ULL, 0x040fe20000000000ULL, 0x000000160c037c10ULL, 0x000fe2000ff9e0ffULL,
0x0000780c01007387ULL, 0x0007e20000100800ULL, 0x0000001802137836ULL, 0x000fe20000000000ULL,
0x0000001804087c11ULL, 0x002fe2000f8448ffULL, 0x0000001c02147836ULL, 0x040fe20000000000ULL,
0x0000741001007387ULL, 0x0003e20000100800ULL, 0x0000002002187836ULL, 0x040fe20000000000ULL,
0x000000160b0b7c10ULL, 0x004fe2000ff7e0ffULL, 0x0000002402177836ULL, 0x000fe20000000000ULL,
0x0000001904097c11ULL, 0x000fe200090f4c09ULL, 0x000000ffff047224ULL, 0x000fe200020e06ffULL,
0x000000180b0a7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00000018030c7c11ULL, 0x008fe2000f8448ffULL, 0x0000700f01007387ULL, 0x0005e20000100800ULL,
0x00000028021b7836ULL, 0x040fe20000000000ULL, 0x0000000f5f7b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000002c021c7836ULL, 0x040fe20000000000ULL, 0x000000190b0b7c11ULL, 0x000fe200088f4c0eULL,
0x00006c1301007387ULL, 0x0007e20000100800ULL, 0x00000019030d7c11ULL, 0x000fe200090f4c04ULL,
0x0000003802227836ULL, 0x040fe20000000000ULL, 0x0000001610037c10ULL, 0x000fe2000ff3e0ffULL,
0x0000681401007387ULL, 0x0009e20000100800ULL, 0x000000160f047c10ULL, 0x000fe2000ff5e0ffULL,
0x00000030021f7836ULL, 0x000fe20000000000ULL, 0x0000000f5e7d7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00000018030e7c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x0000001804107c11ULL, 0x002fe2000f8448ffULL,
0x0000641801007387ULL, 0x000fe20000100800ULL, 0x00000019030f7c11ULL, 0x004fe200088f4c12ULL,
0x0000003c02207836ULL, 0x040fe20000000000ULL, 0x0000001613137c10ULL, 0x008fe2000ff7e0ffULL,
0x0000601701007387ULL, 0x000fe20000100800ULL, 0x0000001614037c10ULL, 0x000fe2000ff9e0ffULL,
0x0000003402217836ULL, 0x000fe20000000000ULL, 0x0000001904117c11ULL, 0x000fe200090f4c11ULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x0000001813127c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x0000001803147c11ULL, 0x010fe2000f8448ffULL,
0x0000841b01007387ULL, 0x0003e20000100800ULL, 0x0000001913137c11ULL, 0x000fc400088f4c16ULL,
0x0000001903157c11ULL, 0x000fe200090f4c04ULL, 0x00005c1c01007387ULL, 0x0005e20000100800ULL,
0x0000001618037c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001617047c10ULL, 0x000fe2000ff5e0ffULL,
0x0000581f01007387ULL, 0x0007e20000100800ULL, 0x0000000f5d2f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x0000001803167c11ULL, 0x040fe2000f8248ffULL,
0x000000ffff197224ULL, 0x000fe200010e06ffULL, 0x000000161b1b7c10ULL, 0x002fe2000ff7e0ffULL,
0x0000542101007387ULL, 0x0003e20000100800ULL, 0x0000001903177c11ULL, 0x000fc400088f4c1aULL,
0x0000001804187c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x000000161c037c10ULL, 0x000fe2000ff9e0ffULL, 0x0000502201007387ULL, 0x0009e20000100800ULL,
0x000000181b1a7c11ULL, 0x000fe4000f8248ffULL, 0x0000001904197c11ULL, 0x000fe200090f4c19ULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00000018031c7c11ULL, 0x004fe2000f8448ffULL,
0x00004c2001007387ULL, 0x0005e20000100800ULL, 0x000000191b1b7c11ULL, 0x000fc400088f4c1eULL,
0x0000002e001e7212ULL, 0x000fe200078e3cffULL, 0x0000002f01007387ULL, 0x000be20000100800ULL,
0x00000019031d7c11ULL, 0x000fe400090f4c04ULL, 0x000000072e037812ULL, 0x000fe400078ec0ffULL,
0x0000000900007c0cULL, 0x000fe4000bf26070ULL, 0x000000071e1e7812ULL, 0x000fe400078ec0ffULL,
0x0000000803047812ULL, 0x000fc400078efcffULL, 0x0ffffff81e607812ULL, 0x000fe400078ef82eULL,
0x0000001622237c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001004247825ULL, 0x000fe200078e0006ULL,
0x0000001620267c10ULL, 0x000fe4000ff7e0ffULL, 0x000000161f1f7c10ULL, 0x008fe2000ff9e0ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x0000001621217c10ULL, 0x002fe2000ffbe0ffULL,
0x000000ffff277224ULL, 0x000fe200018e06ffULL, 0x0000000f60797c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000001823227c11ULL, 0x010fe2000f8448ffULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x0000001826507c11ULL, 0x000fe2000f8648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024797faeULL, 0x0003e2000c901c4cULL,
0x000000181f1e7c11ULL, 0x000fc4000f8848ffULL, 0x0000001821207c11ULL, 0x004fe4000f8a48ffULL,
0x0000001923237c11ULL, 0x000fe200090f4c28ULL, 0x0000001004287825ULL, 0x000fe200078e000cULL,
0x0000000968007c0cULL, 0x000fe4000bf26070ULL, 0x0000001926517c11ULL, 0x000fe200098f4c27ULL,
0x0000001004267825ULL, 0x040fe200078e000aULL, 0x0000000967007c0cULL, 0x000fe4000bf46070ULL,
0x000000191f1f7c11ULL, 0x000fe2000a0f4c2cULL, 0x0000001004247825ULL, 0x002fe200078e0008ULL,
0x0000000966007c0cULL, 0x000fc4000bf66070ULL, 0x0000001921217c11ULL, 0x000fe2000a8f4c2aULL,
0x00000010042a7825ULL, 0x000fe200078e000eULL, 0x0000000965007c0cULL, 0x000fe2000bf86070ULL,
0x00000000247b7faeULL, 0x0003e2000c901c4cULL, 0x0000000964007c0cULL, 0x000fe2000bfa6070ULL,
0x00000010042c7825ULL, 0x000fe200078e0010ULL, 0x0000000f5c7c7c11ULL, 0x000fe2000f8e20ffULL,
0x00000000267d7faeULL, 0x0005e2000d101c4cULL, 0x0000000f5b7a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000963007c0cULL, 0x000fe2000bf26070ULL, 0x00000000282f7faeULL, 0x0007e2000d901c4cULL,
0x0000000962007c0cULL, 0x000fc4000bf46070ULL, 0x0000000961007c0cULL, 0x000fe2000bf66070ULL,
0x000000002a7c7faeULL, 0x0009e2000e101c4cULL, 0x000000096a007c0cULL, 0x000fe2000bf86070ULL,
0x0000001004247825ULL, 0x002fe200078e0012ULL, 0x0000000f5a337c11ULL, 0x000fe2000f8e20ffULL,
0x000000002c7a7faeULL, 0x0003e2000e901c4cULL, 0x0000000969007c0cULL, 0x000fe2000bfa6070ULL,
0x0000001004267825ULL, 0x004fe200078e0014ULL, 0x0000000f59327c11ULL, 0x000fe2000f8e20ffULL,
0x0000000024337faeULL, 0x0005e2000c901c4cULL, 0x0000000f58317c11ULL, 0x000fe2000f8e20ffULL,
0x0000001004287825ULL, 0x008fe200078e0016ULL, 0x0000000f57307c11ULL, 0x000fe2000f8e20ffULL,
0x0000000026327faeULL, 0x0007e2000d101c4cULL, 0x0000000f562f7c11ULL, 0x020fe2000f8e20ffULL,
0x00000010042a7825ULL, 0x050fe200078e0018ULL, 0x0000000975007c0cULL, 0x000fe2000bf26070ULL,
0x0000000028317faeULL, 0x0009e2000d901c4cULL, 0x000000096d007c0cULL, 0x000fe2000bf46070ULL,
0x00000010042c7825ULL, 0x002fe200078e001aULL, 0x000000096c007c0cULL, 0x000fe2000bf66070ULL,
0x000000002a307faeULL, 0x0003e2000e101c4cULL, 0x000000096b007c0cULL, 0x000fe2000bf86070ULL,
0x0000001004247825ULL, 0x004fc400078e001cULL, 0x000000002c2f7faeULL, 0x0005e2000e901c4cULL,
0x0000000976007c0cULL, 0x000fe2000bfa6070ULL, 0x0000001004267825ULL, 0x048fe400078e001eULL,
0x0000203301007387ULL, 0x0007e40000100800ULL, 0x0000001004287825ULL, 0x050fe400078e0020ULL,
0x00001c3201007387ULL, 0x0009e40000100800ULL, 0x00000010042a7825ULL, 0x002fc400078e0022ULL,
0x0000243101007387ULL, 0x0003e20000100800ULL, 0x0000000f55337c11ULL, 0x008fe2000f8e20ffULL,
0x00000010042c7825ULL, 0x004fe400078e0050ULL, 0x00002c3001007387ULL, 0x0005e20000100800ULL,
0x0000000f54327c11ULL, 0x010fc6000f8e20ffULL, 0x0000282f01007387ULL, 0x0007e20000100800ULL,
0x0000000f53317c11ULL, 0x002fc6000f8e20ffULL, 0x0000183301007387ULL, 0x0003e20000100800ULL,
0x0000000f52307c11ULL, 0x004fc6000f8e20ffULL, 0x0000000024337faeULL, 0x0003e2000c901c4cULL,
0x0000000f052f7c11ULL, 0x008fc6000f8e20ffULL, 0x0000143201007387ULL, 0x0003e80000100800ULL,
0x0000000026327faeULL, 0x0003e8000d101c4cULL, 0x0000103101007387ULL, 0x0003e80000100800ULL,
0x0000000028317faeULL, 0x0003e8000d901c4cULL, 0x00000c3001007387ULL, 0x0003e80000100800ULL,
0x000000002a307faeULL, 0x0003e8000e101c4cULL, 0x0000082f01007387ULL, 0x0003e80000100800ULL,
0x000000002c2f7faeULL, 0x0003e2000e901c4cULL, 0x0000000c008c7947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x004fe2000001162eULL, 0x00008a0000187ab9ULL, 0x000fe20000000a00ULL,
0x0000000610087291ULL, 0x000fc6000f8e703fULL, 0x0000000400687836ULL, 0x040fe20000000000ULL,
0x00004000080f7890ULL, 0x000fe2000fffe03fULL, 0x0000000c00667836ULL, 0x000fe40000000000ULL,
0x0000000868027824ULL, 0x040fe200078e00ffULL, 0x0000002e685f7212ULL, 0x080fe200078e3cffULL,
0x0000000800677836ULL, 0x000fe20000000000ULL, 0x0000002e665d7212ULL, 0x080fe200078e3cffULL,
0x0000001400647836ULL, 0x000fe20000000000ULL, 0xfffffff8025f7812ULL, 0x000fe200078ee25fULL,
0x0000000866027824ULL, 0x000fe200078e00ffULL, 0x0000002e675e7212ULL, 0x0c0fe200078e3cffULL,
0x0000001000657836ULL, 0x000fe20000000000ULL, 0x0000002e645b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000867037824ULL, 0x000fe200078e00ffULL, 0xfffffff8025d7812ULL, 0x000fe200078ee25dULL,
0x0000000864027824ULL, 0x000fe200078e00ffULL, 0x0000002e655c7212ULL, 0x0c0fe200078e3cffULL,
0x0000001800637836ULL, 0x040fe20000000000ULL, 0xfffffff8035e7812ULL, 0x000fe200078ee25eULL,
0x0000000865057824ULL, 0x002fe200078e00ffULL, 0xfffffff8025b7812ULL, 0x000fe200078ee25bULL,
0x00000024006a7836ULL, 0x040fe20000000000ULL, 0x0000002e635a7212ULL, 0x0c0fe200078e3cffULL,
0x0000002800697836ULL, 0x000fe20000000000ULL, 0xfffffff8055c7812ULL, 0x000fe200078ee25cULL,
0x0000000863037824ULL, 0x000fe200078e00ffULL, 0x0000002e6a577212ULL, 0x0c0fe200078e3cffULL,
0x000000086a027824ULL, 0x000fe200078e00ffULL, 0x0000002e69567212ULL, 0x0c0fe200078e3cffULL,
0x0000002000617836ULL, 0x040fe20000000000ULL, 0xfffffff8035a7812ULL, 0x000fe200078ee25aULL,
0x0000000869057824ULL, 0x000fe200078e00ffULL, 0xfffffff802577812ULL, 0x000fe200078ee257ULL,
0x0000002c00757836ULL, 0x040fe20000000000ULL, 0x0000002e61587212ULL, 0x0c0fe200078e3cffULL,
0x0000000861037824ULL, 0x000fe200078e00ffULL, 0xfffffff805567812ULL, 0x000fe200078ee256ULL,
0x0000001c00627836ULL, 0x040fe20000000000ULL, 0x0000002e75557212ULL, 0x0c0fe200078e3cffULL,
0x0000000875027824ULL, 0x000fe200078e00ffULL, 0xfffffff803587812ULL, 0x000fe200078ee258ULL,
0x00000030006d7836ULL, 0x000fe20000000000ULL, 0x0000002e62597212ULL, 0x0c0fe200078e3cffULL,
0x0000000eff057e24ULL, 0x000fe2000f8e00ffULL, 0xfffffff802557812ULL, 0x000fe200078ee255ULL,
0x0000000862047824ULL, 0x000fe200078e00ffULL, 0x0000002e6d547212ULL, 0x0c0fe200078e3cffULL,
0x000000086d037824ULL, 0x000fe200078e00ffULL, 0x0000000f5f7b7c11ULL, 0x000fe2000f8e20ffULL,
0x00000034006c7836ULL, 0x000fe20000000000ULL, 0xfffffff804597812ULL, 0x000fe200078ee259ULL,
0x0000004005027824ULL, 0x000fe200078e0200ULL, 0xfffffff803547812ULL, 0x000fe200078ee254ULL,
0x000000086c047824ULL, 0x040fe200078e00ffULL, 0x0000002e6c537212ULL, 0x080fe200078e3cffULL,
0x00000038006b7836ULL, 0x000fe20000000000ULL, 0x0000001602037c10ULL, 0x000fe2000ff3e0ffULL,
0x00000004020b7836ULL, 0x000fe20000000000ULL, 0xfffffff804537812ULL, 0x000fe200078ee253ULL,
0x000000086b077824ULL, 0x040fe200078e00ffULL, 0x0000002e6b527212ULL, 0x080fe200078e3cffULL,
0x000000ffff047224ULL, 0x000fe200008e06ffULL, 0x0000001803067c11ULL, 0x040fe2000f8248ffULL,
0x0000003c00767836ULL, 0x000fe20000000000ULL, 0xfffffff807527812ULL, 0x000fe200078ee252ULL,
0x00000008020a7836ULL, 0x000fe20000000000ULL, 0x0000001903077c11ULL, 0x000fe200088f4c04ULL,
0x0000000876087824ULL, 0x000fe200078e00ffULL, 0x000000160b037c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000c02097836ULL, 0x000fe20000000000ULL, 0x0000002e76057212ULL, 0x000fe200078e3cffULL,
0x0000800b01007387ULL, 0x0003e20000100800ULL, 0x00000010020f7836ULL, 0x000fe20000000000ULL,
0x0000000f5e7d7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0xfffffff808057812ULL, 0x000fe200078ee205ULL, 0x00007c0a01007387ULL, 0x0005e20000100800ULL,
0x0000001803087c11ULL, 0x000fe2000f8248ffULL, 0x0000001402117836ULL, 0x040fe20000000000ULL,
0x00000016090d7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000780901007387ULL, 0x0007e20000100800ULL,
0x000000160a0b7c10ULL, 0x002fe2000ff5e0ffULL, 0x0000001802137836ULL, 0x040fe20000000000ULL,
0x0000000f5d2f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x000000180d0c7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x000000180b0a7c11ULL, 0x004fe2000f8448ffULL, 0x0000001c02127836ULL, 0x040fe20000000000ULL,
0x0000740f01007387ULL, 0x0003e20000100800ULL, 0x0000001903097c11ULL, 0x008fe200088f4c04ULL,
0x00000020021a7836ULL, 0x040fe20000000000ULL, 0x000000160f037c10ULL, 0x000fe2000ff3e0ffULL,
0x0000701101007387ULL, 0x0005e20000100800ULL, 0x000000190b0b7c11ULL, 0x000fe200090f4c0eULL,
0x0000002802177836ULL, 0x040fe20000000000ULL, 0x000000190d0d7c11ULL, 0x000fe200098f4c10ULL,
0x000000ffff047224ULL, 0x000fe200008e06ffULL, 0x00000018030e7c11ULL, 0x040fe2000f8248ffULL,
0x00006c1301007387ULL, 0x000fe20000100800ULL, 0x0000001612157c10ULL, 0x000fe2000ff9e0ffULL,
0x0000002402197836ULL, 0x040fe20000000000ULL, 0x00000019030f7c11ULL, 0x002fe200088f4c04ULL,
0x0000681201007387ULL, 0x0003e20000100800ULL, 0x0000001613037c10ULL, 0x000fe2000ff7e0ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x0000001611117c10ULL, 0x004fe2000ff5e0ffULL,
0x0000641a01007387ULL, 0x000fe20000100800ULL, 0x0000002c021d7836ULL, 0x000fe20000000000ULL,
0x0000000f5c7c7c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x0000001815147c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff047224ULL, 0x000fe200010e06ffULL,
0x0000001811107c11ULL, 0x000fe2000f8248ffULL, 0x0000601901007387ULL, 0x0005e20000100800ULL,
0x0000001803127c11ULL, 0x002fe2000f8448ffULL, 0x00000030021f7836ULL, 0x040fe20000000000ULL,
0x0000001915157c11ULL, 0x000fe200098f4c18ULL, 0x0000841701007387ULL, 0x000fe20000100800ULL,
0x0000001911117c11ULL, 0x000fe200088f4c04ULL, 0x0000003402217836ULL, 0x040fe20000000000ULL,
0x0000001903137c11ULL, 0x000fe200090f4c16ULL, 0x00005c1d01007387ULL, 0x0003e20000100800ULL,
0x00000016171b7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000003c02207836ULL, 0x040fe20000000000ULL,
0x000000161a037c10ULL, 0x000fe2000ff3e0ffULL, 0x0000003802227836ULL, 0x000fe20000000000ULL,
0x0000001619197c10ULL, 0x004fe2000ff5e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x000000181b1a7c11ULL, 0x000fe2000f8648ffULL, 0x000000ffff047224ULL, 0x000fe200008e06ffULL,
0x0000001803167c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x000000161d1d7c10ULL, 0x002fe2000ff9e0ffULL, 0x0000581f01007387ULL, 0x0003e20000100800ULL,
0x0000001819187c11ULL, 0x000fc4000f8448ffULL, 0x000000191b1b7c11ULL, 0x000fe200098f4c1eULL,
0x0000542101007387ULL, 0x0005e20000100800ULL, 0x0000001903177c11ULL, 0x000fe200088f4c04ULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x0000002e001e7212ULL, 0x000fe200078e3cffULL,
0x0000502201007387ULL, 0x000fe20000100800ULL, 0x0000001919197c11ULL, 0x000fe400090f4c1cULL,
0x000000181d1c7c11ULL, 0x000fe2000f8248ffULL, 0x00004c2001007387ULL, 0x0007e20000100800ULL,
0x000000072e037812ULL, 0x000fc400078ec0ffULL, 0x000000071e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000002f01007387ULL, 0x0009e20000100800ULL, 0x000000191d1d7c11ULL, 0x000fe400088f4c04ULL,
0x0000000803047812ULL, 0x000fe400078efcffULL, 0x0ffffff81e607812ULL, 0x000fe400078ef82eULL,
0x000000161f1f7c10ULL, 0x002fe2000ff5e0ffULL, 0x0000001004247825ULL, 0x000fe200078e0006ULL,
0x0000001620277c10ULL, 0x000fc4000ff3e0ffULL, 0x0000001621217c10ULL, 0x004fe2000ff7e0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x0000001622237c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200008e06ffULL, 0x0000000f60797c11ULL, 0x000fe2000f8e20ffULL,
0x000000ffff287224ULL, 0x000fe200018e06ffULL, 0x000000181f1e7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x0000001827507c11ULL, 0x000fe2000f8248ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024797faeULL, 0x0003e2000b901c4cULL,
0x0000001821207c11ULL, 0x008fc4000f8648ffULL, 0x0000001823227c11ULL, 0x000fe4000f8848ffULL,
0x000000191f1f7c11ULL, 0x000fe400090f4c26ULL, 0x0000001927517c11ULL, 0x000fe200088f4c2cULL,
0x0000001004267825ULL, 0x040fe200078e000aULL, 0x0000001921217c11ULL, 0x000fe400098f4c28ULL,
0x0000001923237c11ULL, 0x000fe2000a0f4c2aULL, 0x0000001004247825ULL, 0x002fe200078e0008ULL,
0x0000000f5b7a7c11ULL, 0x000fc4000f8e20ffULL, 0x0000000f5a337c11ULL, 0x000fe2000f8e20ffULL,
0x0000001004287825ULL, 0x040fe200078e000cULL, 0x00000000247b7faeULL, 0x0003e2000b901c4cULL,
0x0000000f59327c11ULL, 0x000fe4000f8e20ffULL, 0x00000010042a7825ULL, 0x000fe200078e000eULL,
0x00000000267d7faeULL, 0x0005e2000b901c4cULL, 0x0000000f58317c11ULL, 0x000fe4000f8e20ffULL,
0x00000010042c7825ULL, 0x000fe200078e0010ULL, 0x00000000282f7faeULL, 0x0007e2000b901c4cULL,
0x0000000f57307c11ULL, 0x000fc4000f8e20ffULL, 0x0000001004247825ULL, 0x042fe200078e0012ULL,
0x000000002a7c7faeULL, 0x0003e6000b901c4cULL, 0x0000001004267825ULL, 0x044fe200078e0014ULL,
0x000000002c7a7faeULL, 0x0005e6000b901c4cULL, 0x0000001004287825ULL, 0x008fe200078e0016ULL,
0x0000000f562f7c11ULL, 0x010fe2000f8e20ffULL, 0x0000203301007387ULL, 0x0007e40000100800ULL,
0x00000010042a7825ULL, 0x002fc400078e0018ULL, 0x0000000024337faeULL, 0x0007e4000b901c4cULL,
0x00000010042c7825ULL, 0x044fe400078e001aULL, 0x00001c3201007387ULL, 0x0003e80000100800ULL,
0x0000000026327faeULL, 0x0003e2000b901c4cULL, 0x0000000f55337c11ULL, 0x008fe2000f8e20ffULL,
0x0000001004247825ULL, 0x000fc400078e001cULL, 0x0000243101007387ULL, 0x0005e80000100800ULL,
0x0000000028317faeULL, 0x0005e2000b901c4cULL, 0x0000000f54327c11ULL, 0x002fe2000f8e20ffULL,
0x0000001004267825ULL, 0x040fe400078e001eULL, 0x00002c3001007387ULL, 0x0003e80000100800ULL,
0x000000002a307faeULL, 0x0003e2000b901c4cULL, 0x0000000f53317c11ULL, 0x004fe2000f8e20ffULL,
0x0000001004287825ULL, 0x000fc400078e0020ULL, 0x0000282f01007387ULL, 0x0005e80000100800ULL,
0x000000002c2f7faeULL, 0x0005e2000b901c4cULL, 0x0000000f52307c11ULL, 0x002fe2000f8e20ffULL,
0x00000010042a7825ULL, 0x040fe400078e0022ULL, 0x0000183301007387ULL, 0x0003e80000100800ULL,
0x0000000024337faeULL, 0x0003e2000b901c4cULL, 0x0000000f052f7c11ULL, 0x004fe2000f8e20ffULL,
0x00000010042c7825ULL, 0x000fc400078e0050ULL, 0x0000143201007387ULL, 0x0003e80000100800ULL,
0x0000000026327faeULL, 0x0003e8000b901c4cULL, 0x0000103101007387ULL, 0x0003e80000100800ULL,
0x0000000028317faeULL, 0x0003e8000b901c4cULL, 0x00000c3001007387ULL, 0x0003e80000100800ULL,
0x000000002a307faeULL, 0x0003e8000b901c4cULL, 0x0000082f01007387ULL, 0x0003e80000100800ULL,
0x000000002c2f7faeULL, 0x0003e4000b901c4cULL, 0x00000004ff267819ULL, 0x002fe2000001162eULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000200008087890ULL, 0x000fe2000fffe03fULL,
0x0000000100787812ULL, 0x000fe400078ec0ffULL, 0x0000000826047824ULL, 0x000fca00078e00ffULL,
0xfffffff804777812ULL, 0x000fe400078ee203ULL, 0x0000000803047812ULL, 0x000fe400078ef82eULL,
0x0000000777737812ULL, 0x040fe200078ec0ffULL, 0x0000001077717836ULL, 0x040fe20000000000ULL,
0x0000000726277812ULL, 0x000fe200078e7804ULL, 0x0000000877727824ULL, 0x040fe200078e00ffULL,
0x0000000173257812ULL, 0x000fe200078e7800ULL, 0x0000002077747836ULL, 0x000fe20000000000ULL,
0x0000000771707812ULL, 0x000fe200078ec0ffULL, 0x0000002004247824ULL, 0x000fe200078e0227ULL,
0x0000007225257212ULL, 0x000fe200078efcffULL, 0x0000000226277836ULL, 0x000fe20000000000ULL,
0x0000000170267812ULL, 0x000fe200078e7800ULL, 0x0000000871717824ULL, 0x000fe200078e00ffULL,
0x0000000624247c11ULL, 0x000fe2000f8e20ffULL, 0x0000302501007387ULL, 0x0003e20000100800ULL,
0x0000000825287c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002440783bULL, 0x0005e20000000200ULL, 0x0000003077777836ULL, 0x000fe20000000000ULL,
0x0000000727277812ULL, 0x000fe400078e7804ULL, 0x0000007126257212ULL, 0x002fe200078efcffULL,
0x00009c2801007387ULL, 0x000fe20000100800ULL, 0x00000007746f7812ULL, 0x040fe200078ec0ffULL,
0x0000000874747824ULL, 0x000fe200078e00ffULL, 0x0000000825247c11ULL, 0x004fe2000f8e20ffULL,
0x0000342501007387ULL, 0x0003e20000100800ULL, 0x00000007776e7812ULL, 0x040fe200078ec0ffULL,
0x0000000877777824ULL, 0x000fe200078e00ffULL, 0x000000016f267812ULL, 0x000fe200078e7800ULL,
0x000000002444783bULL, 0x000fe60000000200ULL, 0x0000007426297212ULL, 0x000fe200078efcffULL,
0x0000b82401007387ULL, 0x0005e20000100800ULL, 0x000000016e257812ULL, 0x002fc600078e7800ULL,
0x000000002834783bULL, 0x0002e20000000200ULL, 0x0000000829267c11ULL, 0x000fe4000f8e20ffULL,
0x00000077252c7212ULL, 0x000fe400078efcffULL, 0x0000000273247812ULL, 0x004fe200078e1e78ULL,
0x000000002638783bULL, 0x000fe20000000200ULL, 0x0000002004287824ULL, 0x002fe200078e0227ULL,
0x000000082c257c11ULL, 0x000fe4000f8e20ffULL, 0x0000007224277212ULL, 0x000fc400078efcffULL,
0x0000000270247812ULL, 0x000fe200078e1e78ULL, 0x00000000254c783bULL, 0x000e620000000200ULL,
0x0000000628287c11ULL, 0x000fe4000f8e20ffULL, 0x0000007124247212ULL, 0x000fe200078efcffULL,
0x0000482701007387ULL, 0x0005e80000100800ULL, 0x0000382901007387ULL, 0x000fe80000100800ULL,
0x0000402c01007387ULL, 0x0007e20000100800ULL, 0x0000000827277c11ULL, 0x004fc6000f8e20ffULL,
0x000000002828783bULL, 0x000fe80000000200ULL, 0x0000d02701007387ULL, 0x000fe80000100800ULL,
0x0000882401007387ULL, 0x0005e20000100800ULL, 0x00000034402c723cULL, 0x008fe600000018ffULL,
0x0000bc2601007387ULL, 0x000fe80000100800ULL, 0x0000c82501007387ULL, 0x000fe20000100800ULL,
0x000000364034723cULL, 0x000fe200000018ffULL, 0x0000000824247c11ULL, 0x004fc4000f8e20ffULL,
0x000000002730783bULL, 0x000ea80000000200ULL, 0x000000002448783bULL, 0x000ee20000000200ULL,
0x0000004c403c723cULL, 0x002fe600000018ffULL, 0x0000d42401007387ULL, 0x0003e60000100800ULL,
0x000000444024723cULL, 0x002fec00000018ffULL, 0x000000464044723cULL, 0x000fec00000018ffULL,
0x00000030282c723cULL, 0x004fd8000000182cULL, 0x000000482824723cULL, 0x008fec0000001824ULL,
0x0000004a2848723cULL, 0x000fec0000001844ULL, 0x000000322830723cULL, 0x000fe20000001834ULL,
0x000000026f447812ULL, 0x000fc400078e1e78ULL, 0x000000026e457812ULL, 0x000fe400078e1e78ULL,
0x00000074444c7212ULL, 0x000fe200078efcffULL, 0x000000384034723cULL, 0x000fe200000018ffULL,
0x00000077454d7212ULL, 0x000fe400078efcffULL, 0x000000084c467c11ULL, 0x000fe2000f8e20ffULL,
0x00003c4c01007387ULL, 0x0003e40000100800ULL, 0x0000003a4038723cULL, 0x000fe400000018ffULL,
0x0000444d01007387ULL, 0x000fe80000100800ULL, 0x0000c44601007387ULL, 0x000fe20000100800ULL,
0x0000004e4040723cULL, 0x000fe200000018ffULL, 0x000000084d4c7c11ULL, 0x002fc4000f8e20ffULL,
0x000000004644783bULL, 0x000e680000000200ULL, 0x0000cc4c01007387ULL, 0x000fe80000100800ULL,
0x000000004c4c783bULL, 0x000ea20000000200ULL, 0x000000442834723cULL, 0x002fe20000001834ULL,
0x0000000000457919ULL, 0x000e6a0000000000ULL, 0x000000462838723cULL, 0x000fec0000001838ULL,
0x0000004c283c723cULL, 0x004fec000000183cULL, 0x0000004e2840723cULL, 0x000fe20000001840ULL,
0x000000046f4d7812ULL, 0x000fc400078e1e78ULL, 0x000000046e4c7812ULL, 0x000fe400078e1e78ULL,
0x000000744d4d7212ULL, 0x000fe400078efcffULL, 0x0000000473287812ULL, 0x000fe400078e1e78ULL,
0x0000000673737812ULL, 0x000fe400078e1e78ULL, 0x00000072284f7212ULL, 0x080fe400078efcffULL,
0x0000007273737212ULL, 0x000fc400078efcffULL, 0x00000004ff457819ULL, 0x002fe40000011645ULL,
0x000000084f2a7c11ULL, 0x000fe4000f8e20ffULL, 0x000000084d727c11ULL, 0x000fe2000f8e20ffULL,
0x0000000445297836ULL, 0x000fe20000000000ULL, 0x000000774c4c7212ULL, 0x000fe200078efcffULL,
0x0000c02a01007387ULL, 0x000fe20000100800ULL, 0x000000066e6e7812ULL, 0x000fe400078e1e78ULL,
0x0000000729297812ULL, 0x000fc400078e7804ULL, 0x000000776e777212ULL, 0x000fe400078efcffULL,
0x000000066f6f7812ULL, 0x000fe200078e1e78ULL, 0x0000002004297824ULL, 0x000fc600078e0229ULL,
0x000000746f6f7212ULL, 0x000fe400078efcffULL, 0x0000000629297c11ULL, 0x000fca000f8e20ffULL,
0x000000002944783bULL, 0x000fe80000000200ULL, 0x000000002a28783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000000182cULL, 0x0000002a4430723cULL, 0x000fe20000001830ULL,
0x0000000470287812ULL, 0x000fc400078e1e78ULL, 0x0000000670707812ULL, 0x000fe400078e1e78ULL,
0x00000071284e7212ULL, 0x080fe400078efcffULL, 0x0000007170707212ULL, 0x000fe400078efcffULL,
0x000000084e297c11ULL, 0x000fe4000f8e20ffULL, 0x000000084c717c11ULL, 0x000fe4000f8e20ffULL,
0x00000008706e7c11ULL, 0x000fe2000f8e20ffULL, 0x0000b42901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x0000a87201007387ULL, 0x000fe80000100800ULL,
0x0000b07101007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x002fec0000001824ULL,
0x0000002a4448723cULL, 0x000fe20000001848ULL, 0x000000007228783bULL, 0x0002a40000000200ULL,
0x0000000000727919ULL, 0x002e660000000000ULL, 0x000000284434723cULL, 0x004fe20000001834ULL,
0x00000004ff727819ULL, 0x002fca0000011672ULL, 0x0000002a4438723cULL, 0x000fe20000001838ULL,
0x000000007128783bULL, 0x0002a40000000200ULL, 0x0000000873717c11ULL, 0x002fca000f8e20ffULL,
0x0000987101007387ULL, 0x000fe80000100800ULL, 0x0000a46e01007387ULL, 0x000fe20000100800ULL,
0x00000028443c723cULL, 0x004fec000000183cULL, 0x0000002a4440723cULL, 0x000fe20000001840ULL,
0x0000000672287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fca00078e7804ULL,
0x0000002004287824ULL, 0x000fca00078e0228ULL, 0x0000000628287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007128783bULL, 0x000e640000000200ULL,
0x00000028442c723cULL, 0x002fec000000182cULL, 0x0000002a4430723cULL, 0x000fe20000001830ULL,
0x000000006e28783bULL, 0x0002a40000000200ULL, 0x000000086f6e7c11ULL, 0x002fca000f8e20ffULL,
0x0000946e01007387ULL, 0x000fe20000100800ULL, 0x000000284424723cULL, 0x004fec0000001824ULL,
0x0000002a4448723cULL, 0x000fe20000001848ULL, 0x000000006e28783bULL, 0x0002a40000000200ULL,
0x00000008776e7c11ULL, 0x002fca000f8e20ffULL, 0x0000906e01007387ULL, 0x000fe20000100800ULL,
0x000000284434723cULL, 0x004fec0000001834ULL, 0x0000002a4438723cULL, 0x000fe20000001838ULL,
0x000000006e28783bULL, 0x000e6a0000000200ULL, 0x00000028443c723cULL, 0x002fec000000183cULL,
0x0000002a4440723cULL, 0x000fe20000001840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000400188947ULL, 0x000fde0003800000ULL, 0x8000001214097290ULL, 0x000fe2000fffe03fULL,
0x00000010032a7812ULL, 0x000fe400078efcffULL, 0x0000000860607c11ULL, 0x000fe4000f8e20ffULL,
0x000000085f5f7c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x000fe200078e0006ULL,
0x0000000900007c0cULL, 0x000fe4000bf26070ULL, 0x000000085e5e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000085d5d7c11ULL, 0x000fc4000f8e20ffULL, 0x000000085c5c7c11ULL, 0x000fe4000f8e20ffULL,
0x000000085b5b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000085a5a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000859597c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028607faeULL, 0x0003e2000c901c4cULL, 0x0000000968007c0cULL, 0x000fe4000bf26070ULL,
0x0000000858587c11ULL, 0x000fc4000f8e20ffULL, 0x0000000857577c11ULL, 0x000fe4000f8e20ffULL,
0x0000000856567c11ULL, 0x000fe4000f8e20ffULL, 0x0000000855557c11ULL, 0x000fe4000f8e20ffULL,
0x0000000854547c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x0000000853537c11ULL, 0x000fe4000f8e20ffULL, 0x0000000852527c11ULL, 0x000fc4000f8e20ffULL,
0x00000000285f7faeULL, 0x0003e2000c901c4cULL, 0x0000000967007c0cULL, 0x000fe4000bf26070ULL,
0x0000000805057c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fd400078e000aULL,
0x00000000285e7faeULL, 0x0003e2000c901c4cULL, 0x0000000966007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e000cULL, 0x00000000285d7faeULL, 0x0003e2000c901c4cULL,
0x0000000965007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e000eULL,
0x00000000285c7faeULL, 0x0003e2000c901c4cULL, 0x0000000964007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0010ULL, 0x00000000285b7faeULL, 0x0003e2000c901c4cULL,
0x0000000963007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0012ULL,
0x00000000285a7faeULL, 0x0003e2000c901c4cULL, 0x0000000962007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0014ULL, 0x0000000028597faeULL, 0x0003e2000c901c4cULL,
0x0000000961007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e0016ULL,
0x0000000028587faeULL, 0x0003e2000c901c4cULL, 0x000000096a007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0018ULL, 0x0000000028577faeULL, 0x0003e2000c901c4cULL,
0x0000000969007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001aULL,
0x0000000028567faeULL, 0x0003e2000c901c4cULL, 0x0000000975007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e001cULL, 0x0000000028557faeULL, 0x0003e2000c901c4cULL,
0x000000096d007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fd800078e001eULL,
0x0000000028547faeULL, 0x0003e2000c901c4cULL, 0x000000096c007c0cULL, 0x000fe2000bf26070ULL,
0x000000102a287825ULL, 0x002fd800078e0020ULL, 0x0000000028537faeULL, 0x0003e2000c901c4cULL,
0x000000096b007c0cULL, 0x000fe2000bf26070ULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fd000078e0050ULL, 0x0000000028527faeULL, 0x0003e2000c901c4cULL,
0x0000000976007c0cULL, 0x000fda000bf26070ULL, 0x000000002a057faeULL, 0x0003e2000c901c4cULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000010032a7812ULL, 0x000fe400078efcffULL,
0x0000000860607c11ULL, 0x000fe4000f8e20ffULL, 0x000000085f5f7c11ULL, 0x000fe2000f8e20ffULL,
0x000000102a287825ULL, 0x000fe200078e0006ULL, 0x000000085e5e7c11ULL, 0x000fe4000f8e20ffULL,
0x000000085d5d7c11ULL, 0x000fe4000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028607faeULL, 0x0003e2000b901c4cULL, 0x000000085c5c7c11ULL, 0x000fc4000f8e20ffULL,
0x000000085b5b7c11ULL, 0x000fe4000f8e20ffULL, 0x000000085a5a7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000859597c11ULL, 0x000fe4000f8e20ffULL, 0x0000000858587c11ULL, 0x000fe4000f8e20ffULL,
0x0000000857577c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fe200078e0008ULL,
0x0000000856567c11ULL, 0x000fc4000f8e20ffULL, 0x0000000855557c11ULL, 0x000fe4000f8e20ffULL,
0x00000000285f7faeULL, 0x0003e2000b901c4cULL, 0x0000000854547c11ULL, 0x000fe4000f8e20ffULL,
0x0000000853537c11ULL, 0x000fe4000f8e20ffULL, 0x0000000852527c11ULL, 0x000fe4000f8e20ffULL,
0x0000000805057c11ULL, 0x000fe2000f8e20ffULL, 0x000000102a287825ULL, 0x002fca00078e000aULL,
0x00000000285e7faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e000cULL,
0x00000000285d7faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e000eULL,
0x00000000285c7faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0010ULL,
0x00000000285b7faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0012ULL,
0x00000000285a7faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0014ULL,
0x0000000028597faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0016ULL,
0x0000000028587faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0018ULL,
0x0000000028577faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e001aULL,
0x0000000028567faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e001cULL,
0x0000000028557faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e001eULL,
0x0000000028547faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fca00078e0020ULL,
0x0000000028537faeULL, 0x0003e4000b901c4cULL, 0x000000102a287825ULL, 0x002fc800078e0022ULL,
0x000000102a2a7825ULL, 0x000fe200078e0050ULL, 0x0000000028527faeULL, 0x0003e8000b901c4cULL,
0x000000002a057faeULL, 0x0003e4000b901c4cULL, 0x0000300001297983ULL, 0x002ea80000300800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000872287836ULL, 0x000fc60000000000ULL,
0x0000480001787983ULL, 0x000ee40000300800ULL, 0x0000000728287812ULL, 0x000fe400078e7804ULL,
0x0000880001747983ULL, 0x000f260000300800ULL, 0x0000002004287824ULL, 0x000fe200078e0228ULL,
0x00003c0001717983ULL, 0x000f680000300800ULL, 0x0000000628287c11ULL, 0x000fe2000f8e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002844783bULL, 0x000fe20000000200ULL,
0x0000000f29297c11ULL, 0x004fca000f8e20ffULL, 0x0000ac2901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e680000000200ULL, 0x00004400016e7983ULL, 0x000ea20000300800ULL,
0x00000028442c723cULL, 0x002fe6000000182cULL, 0x0000340001297983ULL, 0x000ea60000300800ULL,
0x0000002a4430723cULL, 0x000fe20000001830ULL, 0x0000000f29297c11ULL, 0x004fca000f8e20ffULL,
0x0000a02901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284424723cULL, 0x002fe40000001824ULL, 0x0000380001297983ULL, 0x000ea80000300800ULL,
0x0000002a4448723cULL, 0x000fe20000001848ULL, 0x0000000f29297c11ULL, 0x004fca000f8e20ffULL,
0x00008c2901007387ULL, 0x000fe80000100800ULL, 0x000000002928783bULL, 0x000e640000000200ULL,
0x000000284434723cULL, 0x002fe40000001834ULL, 0x0000400001297983ULL, 0x000ea80000300800ULL,
0x0000002a4438723cULL, 0x000fe20000001838ULL, 0x0000000f78787c11ULL, 0x008fc4000f8e20ffULL,
0x0000000f74747c11ULL, 0x010fe4000f8e20ffULL, 0x0000000f71717c11ULL, 0x020fe4000f8e20ffULL,
0x0000000f29297c11ULL, 0x004fca000f8e20ffULL, 0x0000402901007387ULL, 0x000fe80000100800ULL,
0x000000002928783bULL, 0x000e640000000200ULL, 0x00000028443c723cULL, 0x002fee000000183cULL,
0x0000000a72287836ULL, 0x000fca0000000000ULL, 0x0000000728287812ULL, 0x000fca00078e7804ULL,
0x0000002004287824ULL, 0x000fe200078e0228ULL, 0x0000002a4440723cULL, 0x000fe80000001840ULL,
0x0000000628287c11ULL, 0x000fca000f8e20ffULL, 0x000000002844783bULL, 0x000fe80000000200ULL,
0x000000007828783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000000182cULL,
0x0000002a4430723cULL, 0x000fe20000001830ULL, 0x000000007428783bULL, 0x000e680000000200ULL,
0x0000387801007387ULL, 0x0005e20000100800ULL, 0x000000284424723cULL, 0x002fec0000001824ULL,
0x0000002a4448723cULL, 0x000fe20000001848ULL, 0x000000007128783bULL, 0x000e620000000200ULL,
0x0000000f6e787c11ULL, 0x004fc8000f8e20ffULL, 0x000000284434723cULL, 0x002fec0000001834ULL,
0x0000002a4438723cULL, 0x000fe20000001838ULL, 0x000000007828783bULL, 0x000e680000000200ULL,
0x0000347401007387ULL, 0x0005e40000100800ULL, 0x0000000f4f747c11ULL, 0x004fe2000f8e20ffULL,
0x00000028443c723cULL, 0x002fee000000183cULL, 0x0000000c72287836ULL, 0x000fca0000000000ULL,
0x0000000728287812ULL, 0x000fca00078e7804ULL, 0x0000002004287824ULL, 0x000fe200078e0228ULL,
0x0000002a4440723cULL, 0x000fe80000001840ULL, 0x0000000628287c11ULL, 0x000fca000f8e20ffULL,
0x000000002844783bULL, 0x000fe80000000200ULL, 0x000000007428783bULL, 0x000e620000000200ULL,
0x0000000f4e727c11ULL, 0x000fc6000f8e20ffULL, 0x0000307101007387ULL, 0x0005e20000100800ULL,
0x00000028442c723cULL, 0x002fec000000182cULL, 0x0000002a4430723cULL, 0x000fe20000001830ULL,
0x000000007228783bULL, 0x000e620000000200ULL, 0x0000000f4d717c11ULL, 0x004fe4000f8e20ffULL,
0x0000000f4c6e7c11ULL, 0x000fc4000f8e20ffULL, 0x000000284424723cULL, 0x002fec0000001824ULL,
0x0000002a4448723cULL, 0x000fe20000001848ULL, 0x000000007128783bULL, 0x000e620000000200ULL,
0x00000000004f7919ULL, 0x000ea80000000000ULL, 0x000000284434723cULL, 0x002fec0000001834ULL,
0x0000002a4438723cULL, 0x000fe20000001838ULL, 0x000000006e28783bULL, 0x000e620000000200ULL,
0x00000004ff4f7819ULL, 0x004fc4000001164fULL, 0x0000000f704e7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000f6f4d7c11ULL, 0x000fe2000f8e20ffULL, 0x00000c0001707983ULL, 0x0005620000100800ULL,
0x0000000f774c7c11ULL, 0x000fc6000f8e20ffULL, 0x00001000016f7983ULL, 0x0005680000100800ULL,
0x0000140001777983ULL, 0x0005620000100800ULL, 0x00000028443c723cULL, 0x002fee000000183cULL,
0x0000000e4f287836ULL, 0x000fe20000000000ULL, 0x0000000f734f7c11ULL, 0x000fc4000f8e20ffULL,
0x0000080001737983ULL, 0x0005640000100800ULL, 0x0000000728287812ULL, 0x000fe200078e7804ULL,
0x0000002a4440723cULL, 0x000fe80000001840ULL, 0x0000002004287824ULL, 0x000fca00078e0228ULL,
0x0000000628447c11ULL, 0x000fe4000f8e20ffULL, 0x000000004f28783bULL, 0x000fe80000000200ULL,
0x000000004444783bULL, 0x000e640000000200ULL, 0x00000028442c723cULL, 0x002fec000000182cULL,
0x0000002a4430723cULL, 0x000fe20000001830ULL, 0x000000004e28783bULL, 0x000e6a0000000200ULL,
0x000000284424723cULL, 0x002fec0000001824ULL, 0x0000002a4448723cULL, 0x000fe20000001848ULL,
0x000000004d28783bULL, 0x000e6a0000000200ULL, 0x000000284434723cULL, 0x002fec0000001834ULL,
0x0000002a4438723cULL, 0x000fe20000001838ULL, 0x000000004c28783bULL, 0x000e6a0000000200ULL,
0x00000028443c723cULL, 0x002fec000000183cULL, 0x0000002a4440723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000f48947ULL, 0x004fde0003800000ULL,
0x00000000012b7983ULL, 0x000ea20000300800ULL, 0x8000001214087290ULL, 0x000fe2000fffe03fULL,
0x0000001803287812ULL, 0x000fe400078efcffULL, 0x0000200001457983ULL, 0x000ee60000300800ULL,
0x0000000800007c0cULL, 0x000fe2000bf06070ULL, 0x0000001028067825ULL, 0x040fe200078e0006ULL,
0x0000000867007c0cULL, 0x000fe2000bf26070ULL, 0x00001c0001467983ULL, 0x000f240000300800ULL,
0x0000001028087825ULL, 0x000fc400078e0008ULL, 0x0000240001297983ULL, 0x000ee40000300800ULL,
0x00000010280a7825ULL, 0x040fe400078e000aULL, 0x00002c0001477983ULL, 0x000ee40000300800ULL,
0x00000010280c7825ULL, 0x000fe400078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006797faeULL, 0x000fe2000c101c4cULL, 0x0000000868007c0cULL, 0x000fc6000bf06070ULL,
0x00002800012a7983ULL, 0x000ef40000300800ULL, 0x00000000087b7faeULL, 0x000fe2000c101c4cULL,
0x0000000866007c0cULL, 0x000fc6000bf06070ULL, 0x000000000a7d7faeULL, 0x000fe2000c901c4cULL,
0x0000000865007c0cULL, 0x000fd2000bf26070ULL, 0x000000000c2b7faeULL, 0x004fe8000c101c4cULL,
0x00001800012b7983ULL, 0x000ea20000300800ULL, 0x00000010280e7825ULL, 0x000fe200078e000eULL,
0x0000000864007c0cULL, 0x000fe4000bf06070ULL, 0x0000000862007c0cULL, 0x000fe4000bf46070ULL,
0x000000000e7c7faeULL, 0x000fe2000c901c4cULL, 0x0000000863007c0cULL, 0x000fc4000bf26070ULL,
0x0000000861007c0cULL, 0x000fe2000bf66070ULL, 0x0000001028107825ULL, 0x000fc800078e0010ULL,
0x0000001028127825ULL, 0x040fe200078e0012ULL, 0x00000000107a7faeULL, 0x000fe6000c101c4cULL,
0x0000001028147825ULL, 0x000fe200078e0014ULL, 0x000000086a007c0cULL, 0x000fe2000bf06070ULL,
0x0000000012457faeULL, 0x008fe4000c901c4cULL, 0x0000001028167825ULL, 0x000fe200078e0016ULL,
0x0000000869007c0cULL, 0x000fe2000bf26070ULL, 0x0000000014467faeULL, 0x010fe2000d101c4cULL,
0x0000000875007c0cULL, 0x000fc6000bf46070ULL, 0x0000000016297faeULL, 0x0007e2000d901c4cULL,
0x000000086d007c0cULL, 0x000fe4000bf66070ULL, 0x000000086c007c0cULL, 0x000fe4000bf86070ULL,
0x000000086b007c0cULL, 0x000fe4000bfa6070ULL, 0x0000000876007c0cULL, 0x000fe2000bfc6070ULL,
0x0000001028187825ULL, 0x000fc800078e0018ULL, 0x00000010281a7825ULL, 0x040fe200078e001aULL,
0x0000000018477faeULL, 0x0003e6000c101c4cULL, 0x00000010281c7825ULL, 0x040fe200078e001cULL,
0x000000001a2a7faeULL, 0x0003e6000c901c4cULL, 0x00000010281e7825ULL, 0x000fc800078e001eULL,
0x0000001028207825ULL, 0x000fc800078e0020ULL, 0x0000001028227825ULL, 0x000fc800078e0022ULL,
0x0000001028287825ULL, 0x008fe200078e0050ULL, 0x000000001c2b7faeULL, 0x0043e8000d101c4cULL,
0x000000001e777faeULL, 0x0203e8000d901c4cULL, 0x00000000206f7faeULL, 0x0003e8000e101c4cULL,
0x0000000022707faeULL, 0x0003e8000e901c4cULL, 0x0000000028737faeULL, 0x0003e2000f101c4cULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x0000000001297983ULL, 0x000ea80000300800ULL,
0x0000200001477983ULL, 0x000ee80000300800ULL, 0x00001c0001467983ULL, 0x000f280000300800ULL,
0x0000240001457983ULL, 0x000ee80000300800ULL, 0x00002c0001447983ULL, 0x000f280000300800ULL,
0x00002800012b7983ULL, 0x000f280000300800ULL, 0x00001800012a7983ULL, 0x000f220000300800ULL,
0x0000001803287812ULL, 0x000fca00078efcffULL, 0x0000001028067825ULL, 0x000fc800078e0006ULL,
0x0000001028087825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006797faeULL, 0x000fe6000b901c4cULL, 0x00000010280a7825ULL, 0x040fe200078e000aULL,
0x00000000087b7faeULL, 0x000fe6000b901c4cULL, 0x00000010280c7825ULL, 0x040fe200078e000cULL,
0x000000000a7d7faeULL, 0x000fe6000b901c4cULL, 0x00000010280e7825ULL, 0x000fc800078e000eULL,
0x0000001028107825ULL, 0x000fc800078e0010ULL, 0x0000001028127825ULL, 0x000fc800078e0012ULL,
0x0000001028147825ULL, 0x000fc800078e0014ULL, 0x0000001028167825ULL, 0x000fc800078e0016ULL,
0x0000001028187825ULL, 0x000fc800078e0018ULL, 0x00000010281a7825ULL, 0x000fc800078e001aULL,
0x00000010281c7825ULL, 0x000fc800078e001cULL, 0x00000010281e7825ULL, 0x000fc800078e001eULL,
0x0000001028207825ULL, 0x000fc800078e0020ULL, 0x0000001028227825ULL, 0x040fe200078e0022ULL,
0x000000000c297faeULL, 0x0045e8000b901c4cULL, 0x000000000e7c7faeULL, 0x0003e8000b901c4cULL,
0x00000000107a7faeULL, 0x0003e8000b901c4cULL, 0x0000000012477faeULL, 0x0083e2000b901c4cULL,
0x0000001028287825ULL, 0x004fc600078e0050ULL, 0x0000000014467faeULL, 0x0103e8000b901c4cULL,
0x0000000016457faeULL, 0x0003e8000b901c4cULL, 0x0000000018447faeULL, 0x0003e8000b901c4cULL,
0x000000001a2b7faeULL, 0x0003e8000b901c4cULL, 0x000000001c2a7faeULL, 0x0003e8000b901c4cULL,
0x000000001e777faeULL, 0x0203e8000b901c4cULL, 0x00000000206f7faeULL, 0x0003e8000b901c4cULL,
0x0000000022707faeULL, 0x0003e8000b901c4cULL, 0x0000000028737faeULL, 0x0003e4000b901c4cULL,
0x00009c0001087983ULL, 0x002ea80000300800ULL, 0x0000b80001137983ULL, 0x000ee80000300800ULL,
0x0000bc0001127983ULL, 0x000f280000300800ULL, 0x0000c80001117983ULL, 0x000f680000300800ULL,
0x0000d00001107983ULL, 0x000ee20000300800ULL, 0x0000000000067919ULL, 0x000e660000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004ff477819ULL, 0x002fe40000011606ULL, 0x0000d40001067983ULL, 0x000f280000300800ULL,
0x0000c40001187983ULL, 0x000f220000300800ULL, 0x0000001047077836ULL, 0x000fc60000000000ULL,
0x0000cc0001177983ULL, 0x000f240000300800ULL, 0x0000000707077812ULL, 0x000fe400078e7804ULL,
0x0000c00001167983ULL, 0x000f260000300800ULL, 0x0000002004077824ULL, 0x000fe200078e0207ULL,
0x0000b40001157983ULL, 0x000f280000300800ULL, 0x0000000607077c11ULL, 0x000fe2000f8e20ffULL,
0x0000a80001147983ULL, 0x000f280000300800ULL, 0x0000b000011d7983ULL, 0x000f280000300800ULL,
0x00009800011b7983ULL, 0x000f280000300800ULL, 0x0000a400011a7983ULL, 0x000f220000300800ULL,
0x0000000711077291ULL, 0x000fc6000f8e103fULL, 0x0000940001197983ULL, 0x000f220000300800ULL,
0x000000040700728cULL, 0x000fc6000bf06070ULL, 0x00000000080c783bULL, 0x004ff00000000200ULL,
0x00008c0000088ab9ULL, 0x000fe20000000a00ULL, 0x000000000708783bULL, 0x000e640000000200ULL,
0x0000000c082c723cULL, 0x002fec000000182cULL, 0x0000000e0830723cULL, 0x000fe20000001830ULL,
0x00000000130c783bULL, 0x008e6a0000000200ULL, 0x0000000c0824723cULL, 0x002fec0000001824ULL,
0x0000000e0848723cULL, 0x000fe20000001848ULL, 0x00000000120c783bULL, 0x010e620000000200ULL,
0x0000001247077836ULL, 0x000fca0000000000ULL, 0x0000000707077812ULL, 0x000fe200078e7804ULL,
0x0000000c0834723cULL, 0x002fec0000001834ULL, 0x0000000e0838723cULL, 0x000fe20000001838ULL,
0x00000000110c783bULL, 0x020e620000000200ULL, 0x0000002004077824ULL, 0x000fc600078e0207ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000000c083c723cULL, 0x002fec000000183cULL,
0x0000000e0840723cULL, 0x000fe20000001840ULL, 0x000000070b0f8291ULL, 0x000fe2000f8e083fULL,
0x000000000000781cULL, 0x000fe20003f0f008ULL, 0x00000000060c783bULL, 0x0003e80000000200ULL,
0x0000000607087c11ULL, 0x000fcc000f8e20ffULL, 0x000000000808783bULL, 0x000ea20000000200ULL,
0x000000040f0888a5ULL, 0x000fcc000f8e0008ULL, 0x00000008ff067e24ULL, 0x002fe4000f8e00ffULL,
0x00000009ff077e24ULL, 0x000fca000f8e00ffULL, 0x0000000c06068981ULL, 0x0002e2000c1e1900ULL,
0x00000010082c723cULL, 0x004fec000000182cULL, 0x000000120830723cULL, 0x000fe20000001830ULL,
0x000000001810783bULL, 0x0005280000000200ULL, 0x0000900001187983ULL, 0x004ea80000300800ULL,
0x00000400011c7983ULL, 0x000ea80000100800ULL, 0x00007800017d7983ULL, 0x0003680000100800ULL,
0x00007400017c7983ULL, 0x0003680000100800ULL, 0x00007000017b7983ULL, 0x0003680000100800ULL,
0x00006c00017a7983ULL, 0x0003680000100800ULL, 0x0000680001797983ULL, 0x0003680000100800ULL,
0x0000640001777983ULL, 0x0003680000100800ULL, 0x0000600001737983ULL, 0x0003680000100800ULL,
0x0000840001707983ULL, 0x0003680000100800ULL, 0x00005c00016f7983ULL, 0x0003680000100800ULL,
0x0000580001447983ULL, 0x0003680000100800ULL, 0x0000540001517983ULL, 0x0003680000100800ULL,
0x0000500001507983ULL, 0x0003680000100800ULL, 0x00004c0001467983ULL, 0x0003620000100800ULL,
0x0000000c0824723cULL, 0x000fec0000001824ULL, 0x0000000e0848723cULL, 0x000fe20000001848ULL,
0x00000000170c783bULL, 0x000e6a0000000200ULL, 0x000000100834723cULL, 0x010fec0000001834ULL,
0x000000120838723cULL, 0x000fe20000001838ULL, 0x000000001510783bULL, 0x000fea0000000200ULL,
0x0000000c083c723cULL, 0x002fec000000183cULL, 0x0000000e0840723cULL, 0x000fe20000001840ULL,
0x00000000160c783bULL, 0x000fe80000000200ULL, 0x000000001414783bULL, 0x000fe40000000200ULL,
0x0000001447097836ULL, 0x000fca0000000000ULL, 0x0000000709097812ULL, 0x000fca00078e7804ULL,
0x0000002004097824ULL, 0x000fca00078e0209ULL, 0x0000000609097c11ULL, 0x000fcc000f8e20ffULL,
0x000000000908783bULL, 0x000e620000000200ULL, 0x0000001647077836ULL, 0x000fca0000000000ULL,
0x0000000707077812ULL, 0x000fe200078e7804ULL, 0x000000140834723cULL, 0x002fec0000001834ULL,
0x000000160838723cULL, 0x000fe20000001838ULL, 0x000000001d14783bULL, 0x000e620000000200ULL,
0x0000002004077824ULL, 0x000fc800078e0207ULL, 0x0000000c082c723cULL, 0x000fee000000182cULL,
0x00000006070c7c11ULL, 0x000fe2000f8e20ffULL, 0x0000000e0830723cULL, 0x000fea0000001830ULL,
0x000000000c0c783bULL, 0x000fe20000000200ULL, 0x000000100824723cULL, 0x000fec0000001824ULL,
0x000000120848723cULL, 0x000fe20000001848ULL, 0x000000001b10783bULL, 0x000fea0000000200ULL,
0x00000014083c723cULL, 0x002fec000000183cULL, 0x000000160840723cULL, 0x000fe20000001840ULL,
0x000000001a08783bULL, 0x000e680000000200ULL, 0x000000001914783bULL, 0x000f220000000200ULL,
0x0000000000457919ULL, 0x000e620000000000ULL, 0xffffffff00137882ULL, 0x000fe20000000000ULL,
0x00000000060882caULL, 0x008fe200000e0000ULL, 0x000000080c24723cULL, 0x002fe20000001824ULL,
0x000000001818783bULL, 0x004e6c0000000200ULL, 0x000000111c087c36ULL, 0x000fc80008000000ULL,
0x0000000108067836ULL, 0x000fca0000000000ULL, 0x0000000506007c0cULL, 0x000fe2000bf06070ULL,
0x0000000800138c82ULL, 0x000fe20008000000ULL, 0x000000100c2c723cULL, 0x000fe2000000182cULL,
0x0000000a130872a4ULL, 0x000fca000f8e023fULL, 0x000000120c30723cULL, 0x000fec0000001830ULL,
0x0000000a0c48723cULL, 0x000fec0000001848ULL, 0x000000140c34723cULL, 0x010fec0000001834ULL,
0x000000160c38723cULL, 0x000fec0000001838ULL, 0x000000180c3c723cULL, 0x002fec000000183cULL,
0x0000001a0c40723cULL, 0x000fe20000001840ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000008002c8947ULL, 0x000fde0003800000ULL, 0x00008000011d7983ULL, 0x000ea80000300800ULL,
0x00007c00011c7983ULL, 0x000ee20000300800ULL, 0x0000000802077c10ULL, 0x000fe4000ff1e0ffULL,
0x0000001508027c11ULL, 0x000fe4000f8e40ffULL, 0x00000008462a7c10ULL, 0x020fe2000ff9e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000001807117c11ULL, 0x000fc4000f8048ffULL,
0x0000001402097c48ULL, 0x000fe2000ffe0000ULL, 0x000000ffff2b7224ULL, 0x000fe200020e06ffULL,
0x0000001907077c11ULL, 0x000fc600080f4c0cULL, 0x0000000109027824ULL, 0x000fe200078e0a02ULL,
0x000000087a097c10ULL, 0x000fe4000ff7e0ffULL, 0x000000081d0b7c10ULL, 0x004fe4000ff3e0ffULL,
0x000000081c1a7c10ULL, 0x008fc6000ff5e0ffULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x000000180b237c11ULL, 0x040fe2000f8248ffULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x000000181a0a7c11ULL, 0x040fe4000f8448ffULL, 0x000000190b0b7c11ULL, 0x000fe200088f4c06ULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x000000191a1a7c11ULL, 0x000fe400090f4c0dULL,
0x000000087d0d7c10ULL, 0x000fe4000ff1e0ffULL, 0x000000087b0f7c10ULL, 0x000fc4000ff5e0ffULL,
0x000000087c107c10ULL, 0x000fe2000ff3e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x000000180d227c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x000000180f0c7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff137224ULL, 0x000fe200008e06ffULL,
0x000000190d0d7c11ULL, 0x000fe400080f4c14ULL, 0x00000018090e7c11ULL, 0x000fe4000f8648ffULL,
0x0000000879157c10ULL, 0x000fc4000ff1e0ffULL, 0x00000018101e7c11ULL, 0x040fe4000f8248ffULL,
0x000000190f0f7c11ULL, 0x000fe200090f4c12ULL, 0x0000001045127824ULL, 0x000fe200078e00ffULL,
0x0000000877147c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001909097c11ULL, 0x000fe200098f4c06ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000001910107c11ULL, 0x000fe200088f4c13ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000001815177c11ULL, 0x000fc4000f8248ffULL,
0x0000000873187c10ULL, 0x000fe4000ff7e0ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x0000001814167c11ULL, 0x000fe4000f8448ffULL, 0x000000020000720cULL, 0x000fe40003f06070ULL,
0x0000001915157c11ULL, 0x000fe400088f4c06ULL, 0x0000001112067210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x0000001914147c11ULL, 0x000fc400090f4c13ULL,
0x0000001818137c11ULL, 0x040fe2000f8448ffULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x00000008701b7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000001918117c11ULL, 0x000fe400090f4c11ULL,
0x000000086f1c7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006607faeULL, 0x0003e2000c101c4cULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x000000181b197c11ULL, 0x000fe4000f8048ffULL, 0x000000ffff1d7224ULL, 0x000fe200010e06ffULL,
0x00000008441f7c10ULL, 0x000fc4000ff5e0ffULL, 0x000000181c187c11ULL, 0x040fe4000f8248ffULL,
0x000000191b1b7c11ULL, 0x000fe200080f4c20ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x000000191c1c7c11ULL, 0x000fe400088f4c1dULL, 0x0000000851217c10ULL, 0x000fe4000ff5e0ffULL,
0x000000181f1d7c11ULL, 0x040fe4000f8048ffULL, 0x000000026800720cULL, 0x000fe20003f26070ULL,
0x000000ffff067224ULL, 0x002fe200010e06ffULL, 0x000000191f1f7c11ULL, 0x000fc400080f4c20ULL,
0x0000001821207c11ULL, 0x040fe4000f8048ffULL, 0x0000000850297c10ULL, 0x000fe4000ff5e0ffULL,
0x0000001921217c11ULL, 0x000fe400080f4c06ULL, 0x000000026700720cULL, 0x000fe20003f06070ULL,
0x000000ffff067224ULL, 0x000fe200010e06ffULL, 0x0000001829287c11ULL, 0x000fe4000f8448ffULL,
0x0000000a120a7210ULL, 0x000fc40007f9e0ffULL, 0x0000001929297c11ULL, 0x000fe400090f4c06ULL,
0x0000002312067210ULL, 0x000fe40007f5e0ffULL, 0x000000182a237c11ULL, 0x000fe4000f8a48ffULL,
0x000000026600720cULL, 0x080fe20003f66070ULL, 0x000000ffff077224ULL, 0x000fe200010e060bULL,
0x000000192a2a7c11ULL, 0x000fe2000a8f4c2bULL, 0x000000ffff0b7224ULL, 0x000fe200020e061aULL,
0x000000026500720cULL, 0x000fc40003fa6070ULL, 0x00000000065f7faeULL, 0x0003e2000c901c4cULL,
0x000000026400720cULL, 0x080fe40003f86070ULL, 0x0000000c120c7210ULL, 0x000fe20007f5e0ffULL,
0x000000000a5e7faeULL, 0x0005e2000c101c4cULL, 0x000000026300720cULL, 0x000fe40003f06070ULL,
0x0000002212067210ULL, 0x002fe40007f3e0ffULL, 0x0000001e120a7210ULL, 0x004fc60007fde0ffULL,
0x000000ffff077224ULL, 0x000fe200008e060dULL, 0x000000026200720cULL, 0x080fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200010e060fULL, 0x000000026100720cULL, 0x000fe20003f46070ULL,
0x000000ffff0b7224ULL, 0x000fe200030e0610ULL, 0x00000000065d7faeULL, 0x0003e2000d901c4cULL,
0x0000001612167210ULL, 0x000fc60007f7e0ffULL, 0x000000000a5c7faeULL, 0x0005e2000e901c4cULL,
0x0000000e120e7210ULL, 0x000fc60007fbe0ffULL, 0x000000000c5b7faeULL, 0x000fe2000e101c4cULL,
0x000000026a00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0f7224ULL, 0x000fe200028e0609ULL,
0x000000026900720cULL, 0x080fe40003fa6070ULL, 0x0000001712067210ULL, 0x002fe20007fde0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0614ULL, 0x000000000e5a7faeULL, 0x000fe2000c101c4cULL,
0x000000027500720cULL, 0x000fe40003f66070ULL, 0x000000ffff077224ULL, 0x000fe200030e0615ULL,
0x00000019120a7210ULL, 0x004fc80007fde0ffULL, 0x0000000006597faeULL, 0x0005e2000c901c4cULL,
0x000000ffff0b7224ULL, 0x000fe200030e061bULL, 0x000000026d00720cULL, 0x000fe40003f26070ULL,
0x0000000016587faeULL, 0x0003e2000d101c4cULL, 0x0000001812187210ULL, 0x000fca0007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200010e061cULL, 0x000000026b00720cULL, 0x000fe40003f46070ULL,
0x0000001312067210ULL, 0x004fca0007f1e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0611ULL,
0x000000026c00720cULL, 0x000fc80003f06070ULL, 0x0000000006577faeULL, 0x0003e2000e101c4cULL,
0x0000001d120c7210ULL, 0x000fc60007f9e0ffULL, 0x000000000a567faeULL, 0x0003e2000e901c4cULL,
0x0000002012207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e061fULL,
0x0000002812287210ULL, 0x000fe20007f9e0ffULL, 0x0000000018557faeULL, 0x0003e2000d901c4cULL,
0x000000027600720cULL, 0x000fe20003f66070ULL, 0x000000ffff217224ULL, 0x000fe200028e0621ULL,
0x0000002312127210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200020e0629ULL,
0x000000000c547faeULL, 0x0003e6000c901c4cULL, 0x000000ffff137224ULL, 0x000fe200028e062aULL,
0x0000000020537faeULL, 0x0003e8000c101c4cULL, 0x0000000028527faeULL, 0x0003e8000d101c4cULL,
0x0000000012057faeULL, 0x0003e2000d901c4cULL, 0x0000000400dc7947ULL, 0x000fea0003800000ULL,
0x00008000010a7983ULL, 0x000ea80000300800ULL, 0x00007c0001097983ULL, 0x000ee20000300800ULL,
0x0000000802027c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010451d7824ULL, 0x000fe200078e00ffULL,
0x000000087d0f7c10ULL, 0x020fe4000ff7e0ffULL, 0x000000087c117c10ULL, 0x000fe2000ff9e0ffULL,
0x000000ffff077224ULL, 0x000fe200000e06ffULL, 0x0000001802067c11ULL, 0x040fe2000f8048ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x0000001811107c11ULL, 0x000fe2000f8648ffULL,
0x000000ffff167224ULL, 0x000fe200020e06ffULL, 0x0000001902077c11ULL, 0x000fc400080f4c07ULL,
0x000000701d1d7812ULL, 0x000fe400078ec0ffULL, 0x0000001911117c11ULL, 0x000fe400098f4c16ULL,
0x000000101d107210ULL, 0x000fca0007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x000000080a0b7c10ULL, 0x004fe4000ff3e0ffULL, 0x00000008090d7c10ULL, 0x008fc6000ff5e0ffULL,
0x000000ffff027224ULL, 0x000fe200008e06ffULL, 0x000000180b0a7c11ULL, 0x000fe4000f8048ffULL,
0x000000180d0c7c11ULL, 0x000fe2000f8248ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x000000180f0e7c11ULL, 0x000fe4000f8448ffULL, 0x000000190b0b7c11ULL, 0x000fe400080f4c02ULL,
0x000000190f0f7c11ULL, 0x000fe400090f4c14ULL, 0x0000000879177c10ULL, 0x000fc4000ff5e0ffULL,
0x000000190d0d7c11ULL, 0x000fe400088f4c12ULL, 0x000000087b137c10ULL, 0x000fe2000ff1e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000087a157c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000877097c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x0000001817167c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000001813127c11ULL, 0x000fe2000f8048ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x0000001815147c11ULL, 0x000fc4000f8248ffULL, 0x0000001809187c11ULL, 0x000fe4000f8648ffULL,
0x0000001917177c11ULL, 0x000fe400090f4c1cULL, 0x0000001913137c11ULL, 0x000fe400080f4c02ULL,
0x000000086f1f7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000001915157c11ULL, 0x000fe400088f4c1aULL,
0x0000001909027c11ULL, 0x000fe200098f4c1eULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00000008731b7c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000870097c10ULL, 0x000fe4000ff3e0ffULL,
0x000000181f1e7c11ULL, 0x000fe2000f8448ffULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x0000000844217c10ULL, 0x000fe2000ff7e0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x000000181b1a7c11ULL, 0x000fe4000f8048ffULL, 0x00000018091c7c11ULL, 0x000fe2000f8248ffULL,
0x000000ffff447224ULL, 0x000fe200018e06ffULL, 0x000000191f1f7c11ULL, 0x000fc400090f4c2aULL,
0x00000008462b7c10ULL, 0x000fe4000ff5e0ffULL, 0x000000191b1b7c11ULL, 0x000fe400080f4c22ULL,
0x0000001909097c11ULL, 0x000fe400088f4c28ULL, 0x0000001821207c11ULL, 0x040fe4000f8648ffULL,
0x0000000851237c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000850297c10ULL, 0x000fe2000ff3e0ffULL,
0x000000ffff507224ULL, 0x000fe200010e06ffULL, 0x0000001921217c11ULL, 0x000fe200098f4c44ULL,
0x000000ffff447224ULL, 0x000fe200000e06ffULL, 0x000000182b2a7c11ULL, 0x000fe2000f8448ffULL,
0x000000ffff467224ULL, 0x000fe200008e06ffULL, 0x0000001823227c11ULL, 0x000fc4000f8048ffULL,
0x0000001829287c11ULL, 0x000fe4000f8248ffULL, 0x000000192b2b7c11ULL, 0x000fe400090f4c50ULL,
0x000000061d067210ULL, 0x000fe40007f5e0ffULL, 0x0000001923237c11ULL, 0x000fe400080f4c44ULL,
0x0000001929297c11ULL, 0x000fe200088f4c46ULL, 0x000000ffff077224ULL, 0x000fe200010e0607ULL,
0x0000000a1d0a7210ULL, 0x000fc40007fde0ffULL, 0x0000000c1d0c7210ULL, 0x000fe40007f3e0ffULL,
0x0000000e1d0e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e060bULL,
0x000000121d127210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000141d147210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200000e060fULL,
0x000000161d167210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0613ULL,
0x000000181d187210ULL, 0x000fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006607faeULL, 0x0003e2000b901c4cULL, 0x0000001a1d1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000001c1d1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000000a5f7faeULL, 0x0003e2000b901c4cULL, 0x0000001e1d1e7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x000000201d207210ULL, 0x000fe20007f7e0ffULL,
0x000000000c5e7faeULL, 0x0003e2000b901c4cULL, 0x000000221d227210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0602ULL, 0x000000281d287210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x000000000e5d7faeULL, 0x0003e2000b901c4cULL,
0x0000002a1d2a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1d7224ULL, 0x000fc400028e0609ULL,
0x00000000105c7faeULL, 0x0003e2000b901c4cULL, 0x000000ffff1f7224ULL, 0x000fe400020e061fULL,
0x000000ffff217224ULL, 0x000fe200018e0621ULL, 0x00000000125b7faeULL, 0x0003e2000b901c4cULL,
0x000000ffff237224ULL, 0x000fe400010e0623ULL, 0x000000ffff297224ULL, 0x000fe200008e0629ULL,
0x00000000145a7faeULL, 0x0003e2000b901c4cULL, 0x000000ffff2b7224ULL, 0x000fc600000e062bULL,
0x0000000016597faeULL, 0x0003e8000b901c4cULL, 0x0000000018587faeULL, 0x0003e8000b901c4cULL,
0x000000001a577faeULL, 0x0003e8000b901c4cULL, 0x000000001c567faeULL, 0x0003e8000b901c4cULL,
0x000000001e557faeULL, 0x0003e8000b901c4cULL, 0x0000000020547faeULL, 0x0003e8000b901c4cULL,
0x0000000022537faeULL, 0x0003e8000b901c4cULL, 0x0000000028527faeULL, 0x0003e8000b901c4cULL,
0x000000002a057faeULL, 0x0003e4000b901c4cULL, 0x0000ac00010c7983ULL, 0x002ea80000300800ULL,
0x0000a000010b7983ULL, 0x000ee80000300800ULL, 0x00008c0001077983ULL, 0x000f280000300800ULL,
0x00004000010a7983ULL, 0x000f680000300800ULL, 0x0000380001097983ULL, 0x000f680000300800ULL,
0x0000340001067983ULL, 0x000f680000300800ULL, 0x0000300001027983ULL, 0x000f620000300800ULL,
0x0000001847057836ULL, 0x000fe20000000000ULL, 0x0000000610097291ULL, 0x000fc4000f8e183fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000610087291ULL, 0x000fe2000f8e383fULL,
0x0000000705057812ULL, 0x000fca00078e7804ULL, 0x0000002004057824ULL, 0x000fca00078e0205ULL,
0x0000000605057c11ULL, 0x000fe2000f8e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000518783bULL, 0x0003e80000000200ULL, 0x000000007878783bULL, 0x000fe20000000200ULL,
0x0000001c47057836ULL, 0x002fc60000000000ULL, 0x000000007474783bULL, 0x000fe40000000200ULL,
0x0000000705057812ULL, 0x000fe400078e7804ULL, 0x000000006e6c783bULL, 0x000fe60000000200ULL,
0x0000002004057824ULL, 0x000fca00078e0205ULL, 0x0000000605057c11ULL, 0x000fe2000f8e20ffULL,
0x000000000c0c783bULL, 0x004e680000000200ULL, 0x000000000b28783bULL, 0x008ea80000000200ULL,
0x000000000710783bULL, 0x0107280000000200ULL, 0x000000000a20783bULL, 0x020f620000000200ULL,
0x0000001a47077836ULL, 0x008fc60000000000ULL, 0x000000000914783bULL, 0x0007e40000000200ULL,
0x0000000707077812ULL, 0x000fe200078e7804ULL, 0x0000000445097824ULL, 0x008fc800078e00ffULL,
0x0000002004077824ULL, 0x000fe200078e0207ULL, 0xfffffff009097812ULL, 0x000fc800078ec0ffULL,
0x0000000607077c11ULL, 0x000fca000f8e20ffULL, 0x00000000071c783bULL, 0x0007e20000000200ULL,
0x0000000c182c723cULL, 0x002fe2000000182cULL, 0x0000001e47077836ULL, 0x008fca0000000000ULL,
0x0000000e1830723cULL, 0x000fe20000001830ULL, 0x00000000060c783bULL, 0x000e620000000200ULL,
0x0000000707077812ULL, 0x000fc800078e7804ULL, 0x000000281824723cULL, 0x004fe20000001824ULL,
0x0000002004077824ULL, 0x000fca00078e0207ULL, 0x0000002a1848723cULL, 0x000fe20000001848ULL,
0x000000000228783bULL, 0x0004e20000000200ULL, 0x0000000607077c11ULL, 0x000fc8000f8e20ffULL,
0x000000101834723cULL, 0x010fe20000001834ULL, 0x00000001ff027424ULL, 0x004fca00078e00ffULL,
0x000000121838723cULL, 0x000fe20000001838ULL, 0x000000000510783bULL, 0x000fe80000000200ULL,
0x000000000704783bULL, 0x000fe20000000200ULL, 0x00000020183c723cULL, 0x020fec000000183cULL,
0x000000221840723cULL, 0x000fe20000001840ULL, 0x000000007218783bULL, 0x000ea80000000200ULL,
0x000000004d20783bULL, 0x000fe20000000200ULL, 0x0000000c1c24723cULL, 0x002fec0000001824ULL,
0x000000141c2c723cULL, 0x000fec000000182cULL, 0x000000161c30723cULL, 0x000fe20000001830ULL,
0x000000007114783bULL, 0x000e6a0000000200ULL, 0x000000281c34723cULL, 0x008fec0000001834ULL,
0x0000000e1c48723cULL, 0x000fe20000001848ULL, 0x000000004f0c783bULL, 0x000eea0000000200ULL,
0x0000002a1c38723cULL, 0x000fec0000001838ULL, 0x000000781c3c723cULL, 0x000fec000000183cULL,
0x0000007a1c40723cULL, 0x000fe20000001840ULL, 0x000000004e1c783bULL, 0x000f2a0000000200ULL,
0x000000181028723cULL, 0x004fe20000001824ULL, 0x000000004c24783bULL, 0x000ea20000000200ULL,
0x01c68802ff0a79a7ULL, 0x000f680008500009ULL, 0x00000074102c723cULL, 0x000fec000000182cULL,
0x000000761030723cULL, 0x000fec0000001830ULL, 0x000000141034723cULL, 0x002fec0000001834ULL,
0x0000001a1048723cULL, 0x000fe20000001848ULL, 0x01c6880bff0075a7ULL, 0x020e6a0008000149ULL,
0x000000161014723cULL, 0x000fec0000001838ULL, 0x0000006c103c723cULL, 0x000fec000000183cULL,
0x0000006e1040723cULL, 0x000fec0000001840ULL, 0x0000000c042c723cULL, 0x008fec000000182cULL,
0x0000000e0430723cULL, 0x000fec0000001830ULL, 0x0000001c0418723cULL, 0x010fec0000001828ULL,
0x0000001e041c723cULL, 0x000fec0000001848ULL, 0x000000200410723cULL, 0x000fec0000001834ULL,
0x000000220414723cULL, 0x000fe20000001814ULL, 0x3d8000002c217820ULL, 0x000fe20000410000ULL,
0x3d8000002d207820ULL, 0x000fe20000410000ULL, 0x3d80000030307820ULL, 0x000fe20000410000ULL,
0x3d80000031317820ULL, 0x000fe20000410000ULL, 0x3d80000032327820ULL, 0x000fe20000410000ULL,
0x00000024040c723cULL, 0x004fe2000000183cULL, 0x3d8000002e227820ULL, 0x000fe20000410000ULL,
0x3d8000002f237820ULL, 0x000fe20000410000ULL, 0x3d80000033337820ULL, 0x000fe20000410000ULL,
0x3d80000018187820ULL, 0x000fe20000410000ULL, 0x3d80000019197820ULL, 0x000fe20000410000ULL,
0x000000260404723cULL, 0x000fe20000001840ULL, 0x3d8000001a1a7820ULL, 0x000fe20000410000ULL,
0x3d8000001b1b7820ULL, 0x000fe20000410000ULL, 0x3d8000001c1c7820ULL, 0x000fe20000410000ULL,
0x3d8000001d1d7820ULL, 0x000fe20000410000ULL, 0x3d8000001e1e7820ULL, 0x000fe20000410000ULL,
0x3d8000001f1f7820ULL, 0x000fe20000410000ULL, 0x3d80000010107820ULL, 0x000fe20000410000ULL,
0x3d80000011117820ULL, 0x000fe20000410000ULL, 0x3d80000012127820ULL, 0x000fe20000410000ULL,
0x3d80000013137820ULL, 0x000fc40000410000ULL, 0x3d80000014147820ULL, 0x000fe20000410000ULL,
0x3d80000015157820ULL, 0x000fe20000410000ULL, 0x3d80000016167820ULL, 0x000fe20000410000ULL,
0x3d80000017177820ULL, 0x000fc60000410000ULL, 0x3d8000000c247820ULL, 0x000fe20000410000ULL,
0x3d8000000d257820ULL, 0x000fe20000410000ULL, 0x3d8000000e0e7820ULL, 0x000fe20000410000ULL,
0x3d8000000f0f7820ULL, 0x000fc60000410000ULL, 0x3d80000004267820ULL, 0x000fe20000410000ULL,
0x3d80000005277820ULL, 0x000fe20000410000ULL, 0x3d800000060c7820ULL, 0x000fe20000410000ULL,
0x3d800000070d7820ULL, 0x000fe20000410000ULL, 0x0000001000d48947ULL, 0x002fec0003800000ULL,
0x0000040001287983ULL, 0x000ea20000300800ULL, 0xffffffff05097890ULL, 0x000fc6000fffe03fULL,
0x01c4000809047984ULL, 0x0002620008000c00ULL, 0x0000000000387919ULL, 0x000e640000000000ULL,
0x0000000928007c0cULL, 0x004fda000bf05270ULL, 0x0000000400080947ULL, 0x002fea0003800000ULL,
0x00000002380a7824ULL, 0x000fe200078e00ffULL, 0x8000001214127290ULL, 0x000fc8000fffe03fULL,
0x000000060a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000010a0b7812ULL, 0x040fe400078efcffULL,
0x000000080a287812ULL, 0x040fe400078efcffULL, 0x000000120b007c0cULL, 0x000fe4000bf26070ULL,
0x000000100a0b7812ULL, 0x000fe400078efcffULL, 0x0000001228007c0cULL, 0x000fe4000bf06070ULL,
0x000000120b007c0cULL, 0x000fc4000bfc6070ULL, 0x000000110a287812ULL, 0x040fe400078efcffULL,
0x000000180a0b7812ULL, 0x040fe400078efcffULL, 0x000000120a007c0cULL, 0x000fe4000bf46070ULL,
0x0000001228007c0cULL, 0x000fe4000bfa6070ULL, 0x000000120b007c0cULL, 0x000fe4000bf66070ULL,
0x000000090a297812ULL, 0x000fc400078efcffULL, 0x000000190a287812ULL, 0x040fe400078efcffULL,
0x000000200a0b7812ULL, 0x000fe400078efcffULL, 0xff7fffff22227808ULL, 0x000fe40005000000ULL,
0xff7fffff21217808ULL, 0x000fe40005000000ULL, 0xff7fffff23237808ULL, 0x000fe40004800000ULL,
0xff7fffff20207808ULL, 0x000fc40004800000ULL, 0x0000001229007c0cULL, 0x000fe4000bf86070ULL,
0x0000001228007c0cULL, 0x000fe4000bf46070ULL, 0x000000120b007c0cULL, 0x000fe4000bf26070ULL,
0x000000210a287812ULL, 0x040fe400078efcffULL, 0x000000280a0b7812ULL, 0x000fe400078efcffULL,
0xff7fffff32327808ULL, 0x000fc40004000000ULL, 0xff7fffff30307808ULL, 0x000fe40004000000ULL,
0xff7fffff33337808ULL, 0x000fe40006000000ULL, 0xff7fffff31317808ULL, 0x000fe40006000000ULL,
0x0000001228007c0cULL, 0x000fe4000bf06070ULL, 0x000000120b007c0cULL, 0x000fe4000bf86070ULL,
0x000000290a287812ULL, 0x000fc400078efcffULL, 0x000000300a0b7812ULL, 0x000fe400078efcffULL,
0xff7fffff1a1a7808ULL, 0x000fe40007000000ULL, 0xff7fffff18187808ULL, 0x000fe40007000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40006800000ULL, 0xff7fffff19197808ULL, 0x000fe40006800000ULL,
0x0000001228007c0cULL, 0x000fc4000bfc6070ULL, 0x000000120b007c0cULL, 0x000fe4000bfa6070ULL,
0x000000310a287812ULL, 0x040fe400078efcffULL, 0x000000380a0b7812ULL, 0x040fe400078efcffULL,
0x000000390a0a7812ULL, 0x000fe400078efcffULL, 0xff7fffff1e1e7808ULL, 0x000fe40005800000ULL,
0xff7fffff1c1c7808ULL, 0x000fc40005800000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL,
0xff7fffff1d1d7808ULL, 0x000fe40005000000ULL, 0xff7fffff12127808ULL, 0x000fe40004800000ULL,
0xff7fffff10107808ULL, 0x000fe40004800000ULL, 0x0000001228007c0cULL, 0x000fe4000bf66070ULL,
0x000000120b007c0cULL, 0x000fc4000bf46070ULL, 0x000000120a007c0cULL, 0x000fe4000bf26070ULL,
0xff7fffff13137808ULL, 0x000fe40004000000ULL, 0xff7fffff11117808ULL, 0x000fe40004000000ULL,
0xff7fffff16167808ULL, 0x000fe40006000000ULL, 0xff7fffff14147808ULL, 0x000fe40006000000ULL,
0xff7fffff17177808ULL, 0x000fc40007000000ULL, 0xff7fffff15157808ULL, 0x000fe40007000000ULL,
0xff7fffff0e0e7808ULL, 0x000fe40006800000ULL, 0xff7fffff24247808ULL, 0x000fe40006800000ULL,
0xff7fffff0f0f7808ULL, 0x000fe40005800000ULL, 0xff7fffff25257808ULL, 0x000fe40005800000ULL,
0xff7fffff0c0c7808ULL, 0x000fc40005000000ULL, 0xff7fffff26267808ULL, 0x000fe40005000000ULL,
0xff7fffff0d0d7808ULL, 0x000fe40004800000ULL, 0xff7fffff27277808ULL, 0x000fce0004800000ULL,
0x00000021040b7209ULL, 0x000fe20007810000ULL, 0x00000010ff287e24ULL, 0x000fe2000f8e00ffULL,
0x0000002205047209ULL, 0x000fe20007810000ULL, 0xffffffff00097882ULL, 0x000fe20000000000ULL,
0x000000200b0b7209ULL, 0x000fe40007810000ULL, 0x0000002304057209ULL, 0x000fe40007810000ULL,
0x000000300b047209ULL, 0x000fe40007810000ULL, 0x00000032050a7209ULL, 0x000fc40007810000ULL,
0x0000003104057209ULL, 0x000fe40007810000ULL, 0x000000330a0b7209ULL, 0x000fe40007810000ULL,
0x0000001805047209ULL, 0x000fe40007810000ULL, 0x0000001a0b0a7209ULL, 0x000fe40007810000ULL,
0x0000001904057209ULL, 0x000fe40007810000ULL, 0x0000001b0a0b7209ULL, 0x000fc40007810000ULL,
0x0000001c05047209ULL, 0x000fe40007810000ULL, 0x0000001e0b0a7209ULL, 0x000fe40007810000ULL,
0x0000001d04057209ULL, 0x000fe40007810000ULL, 0x0000001f0a0b7209ULL, 0x000fe40007810000ULL,
0x0000001005047209ULL, 0x000fe40007810000ULL, 0x000000120b0a7209ULL, 0x000fc40007810000ULL,
0x0000001104057209ULL, 0x000fe40007810000ULL, 0x000000130a0b7209ULL, 0x000fe40007810000ULL,
0x0000001405047209ULL, 0x000fe40007810000ULL, 0x000000160b0a7209ULL, 0x000fe40007810000ULL,
0x0000001504057209ULL, 0x000fe40007810000ULL, 0x000000170a0b7209ULL, 0x000fc40007810000ULL,
0x0000002405047209ULL, 0x000fe40007810000ULL, 0x0000000e0b0a7209ULL, 0x000fe40007810000ULL,
0x0000002504057209ULL, 0x000fe40007810000ULL, 0x0000000f0a0b7209ULL, 0x000fe40007810000ULL,
0x0000002605047209ULL, 0x000fe40007810000ULL, 0x0000000c0b0a7209ULL, 0x000fc40007810000ULL,
0x00000006280b7c11ULL, 0x000fe4000f8e28ffULL, 0x0000002704047209ULL, 0x000fe40007810000ULL,
0x0000000d0a057209ULL, 0x000fe20007810000ULL, 0x0000000e09407947ULL, 0x000fec000b800000ULL,
0x0c401f0004297f89ULL, 0x000e6800000e0000ULL, 0x0c401f00050a7f89ULL, 0x000ea800000e0000ULL,
0x0c401f00062b7f89ULL, 0x000ee800000e0000ULL, 0x0c401f00072c7f89ULL, 0x000f2200000e0000ULL,
0x0000002904287209ULL, 0x002fc40007810000ULL, 0x0000000a052a7209ULL, 0x004fc60007810000ULL,
0x0c201f00282d7f89ULL, 0x000e6200000e0000ULL, 0x0000002b062b7209ULL, 0x008fc60007810000ULL,
0x0c201f002a2f7f89ULL, 0x000ea200000e0000ULL, 0x0000002c070a7209ULL, 0x010fc60007810000ULL,
0x0c201f002b2e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a297f89ULL, 0x00092200000e0000ULL,
0x0000002d28047209ULL, 0x002fe40007810000ULL, 0x0000002f2a057209ULL, 0x004fe40007810000ULL,
0x0000002e2b067209ULL, 0x008fce0007810000ULL, 0x3fb8aa3b04077820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b27077823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05277820ULL, 0x000fe20000410000ULL, 0x0000002100217308ULL, 0x000fe60000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010827ULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fcc0000010827ULL,
0x00000019002b7308ULL, 0x000ff00000000800ULL, 0x00000010002c7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000002200197308ULL, 0x0003f00000000800ULL, 0x0000002300107308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b1e227823ULL, 0x002fce0000010827ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f237823ULL, 0x004fe20000010827ULL, 0x000000191019723eULL, 0x008fcc00000000ffULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000001800287308ULL, 0x0002b00000000800ULL,
0x00000011002f7308ULL, 0x0007e20000000800ULL, 0x000000212018723eULL, 0x002fe200000000ffULL,
0x3c003c00ff207424ULL, 0x000fc400078e00ffULL, 0x3c003c00ff217424ULL, 0x000fe200078e00ffULL,
0x000000282b10723eULL, 0x004fc600000000ffULL, 0x00000014002e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1a117823ULL, 0x108fe20000010827ULL, 0x00000030311a723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b12307823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b13317823ULL, 0x000fc80000010827ULL,
0x0000001c002a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1b147823ULL, 0x002fe20000010827ULL,
0x00000032331b723eULL, 0x000fcc00000000ffULL, 0x0000001d002d7308ULL, 0x0002b00000000800ULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00000020181c723cULL, 0x002fe200000018ffULL, 0x0000002a2d12723eULL, 0x004fe200000000ffULL,
0x0000001400147308ULL, 0x000e700000000800ULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x000000111411723eULL, 0x002fce00000000ffULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000002c2f14723eULL, 0x000fce00000000ffULL, 0x0000001500157308ULL, 0x000ea20000000800ULL,
0x000000222313723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b17227823ULL, 0x000fcc0000010827ULL,
0x0000003000307308ULL, 0x000fe20000000800ULL, 0x00000020101c723cULL, 0x000fee000000181cULL,
0x0000003100317308ULL, 0x000e700000000800ULL, 0x0000001600287308ULL, 0x0005f00000000800ULL,
0x0000002200177308ULL, 0x000ee20000000800ULL, 0x0000002e1516723eULL, 0x004fc400000000ffULL,
0x000000303115723eULL, 0x002fca00000000ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000281717723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b0c287823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0d277823ULL, 0x000fca0000010827ULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x00000020141c723cULL, 0x000fee000000181cULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x00000024250c723eULL, 0x002fce00000000ffULL, 0x0000000700077308ULL, 0x000e700000000800ULL,
0x0000000e00237308ULL, 0x0003f00000000800ULL, 0x0000000f002a7308ULL, 0x000ea20000000800ULL,
0x00000026070e723eULL, 0x002fc400000000ffULL, 0xfffffffc38077812ULL, 0x000fca00078ec0ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000232a0d723eULL, 0x004fce00000000ffULL,
0x0000002700277308ULL, 0x000e640000000800ULL, 0x00000028270f723eULL, 0x002fce00000000ffULL,
0x000000200c20723cULL, 0x000fee000000181cULL, 0x0000000fff1c7424ULL, 0x000fda00078e00ffULL,
0x000000071c217219ULL, 0x000fe400000006ffULL, 0x000000290a077209ULL, 0x010fe20007810000ULL,
0x001c1fff201c7589ULL, 0x00026200000e0000ULL, 0x0000000000247806ULL, 0x000fe200038e0100ULL,
0x00000000211e73a1ULL, 0x000eb000000e8000ULL, 0x00000000210973c4ULL, 0x000ee20000004000ULL,
0x00000000000f7886ULL, 0x000fc400038e0100ULL, 0x0000000f21ff7c12ULL, 0x004fda000f80401eULL,
0x0000000a09588947ULL, 0x00afea000b800000ULL, 0x001c1fff221d7589ULL, 0x0002a800000e0000ULL,
0x001c1fff1e1e7589ULL, 0x000ee800000e0000ULL, 0x001c1fff001f7589ULL, 0x00032400000e0000ULL,
0xfffffff8ff037812ULL, 0x000fe200078ee203ULL, 0x0000000610097291ULL, 0x000fe2000f8e583fULL,
0x0000000300237812ULL, 0x000fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200078e0018ULL,
0x0000000338ff7812ULL, 0x000fe2000780c0ffULL, 0x00000008030a7836ULL, 0x000fe20000000000ULL,
0x0000000423257812ULL, 0x000fe200078efcffULL, 0x0000000803007824ULL, 0x002fe200078e00ffULL,
0x0000000723217812ULL, 0x000fe200078e7803ULL, 0x00000009ff207e24ULL, 0x000fe2000f8e00ffULL,
0x0000000725037812ULL, 0x000fe200078e7803ULL, 0x000000ffff297224ULL, 0x000fe200078e001aULL,
0x0000000723237812ULL, 0x000fe200078e780aULL, 0x0001200020207836ULL, 0x000fe20000000000ULL,
0x0000000725257812ULL, 0x000fe200078e780aULL, 0x000000080a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000021217212ULL, 0x080fe200078efcffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0010ULL,
0x0000000003037212ULL, 0x000fe200078efcffULL, 0x000000ffff2b7224ULL, 0x000fe200078e0012ULL,
0x0000000a23237212ULL, 0x080fe200078efcffULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x0000000a25257212ULL, 0x000fe200078efcffULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000040801007387ULL, 0x0003e20000100800ULL, 0x0000001003037824ULL, 0x000fc400078e0220ULL,
0x000000ffff2c7224ULL, 0x000fe200078e0014ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000002821007844ULL, 0x0003e20000000200ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0016ULL,
0x000000ffff2e7224ULL, 0x000fe400078e000cULL, 0x000000ffff2f7224ULL, 0x000fc400078e000eULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x0000002c03007844ULL, 0x0003e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0011ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0013ULL, 0x0000001025257824ULL, 0x000fe400078e0220ULL,
0x000000ffff107224ULL, 0x000fe200078e0015ULL, 0x0000001823007844ULL, 0x0003e20000000200ULL,
0x000000ffff117224ULL, 0x000fc400078e0017ULL, 0x000000ffff127224ULL, 0x000fe400078e000dULL,
0x000000ffff137224ULL, 0x000fca00078e000fULL, 0x0000001025007844ULL, 0x0003e80000000200ULL,
0x01c0000409008988ULL, 0x0003e80008000c08ULL, 0x01c2001c09008988ULL, 0x01c3e20008000c08ULL,
0x0000000508007c0cULL, 0x000fe2000bf06070ULL, 0x01c608020bff79a7ULL, 0x0003e2000850003fULL,
0x01c610020bff79a7ULL, 0x0003e2000850003fULL, 0x01c618020bff79a7ULL, 0x0003e2000850003fULL,
0x01c620020bff79a7ULL, 0x0003f2000850003fULL, 0xffffff9000908947ULL, 0x002fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x01c60825ff0075a7ULL, 0x0002620008040158ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000a95dULL, 0x000fea0003900000ULL,
0x01c60825ff00a5a7ULL, 0x000e640008040058ULL, 0xfffffffc00eca947ULL, 0x002fea000383ffffULL,
0xfffffee000147947ULL, 0x020fea000383ffffULL, 0x01c62813ff0075a7ULL, 0x0002620008020158ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01c62813ff0095a7ULL, 0x000e640008020058ULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xfffffefc00cc7947ULL, 0x000fea000383ffffULL, 0x01c64813ff0075a7ULL, 0x0002620008020158ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000995dULL, 0x000fea0003900000ULL,
0x01c64813ff0095a7ULL, 0x000e640008020058ULL, 0xfffffffc00ec9947ULL, 0x002fea000383ffffULL,
0xffffff1800207947ULL, 0x000fea000383ffffULL, 0x01c66813ff0075a7ULL, 0x0002620008000158ULL,
0x000090000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c66813ff0085a7ULL, 0x000e640008000058ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff3000747947ULL, 0x000fea000383ffffULL, 0x01c60003ff0075a7ULL, 0x0004a20008000146ULL,
0x0000a0000000791aULL, 0x000fc80000000000ULL, 0x009896800000895dULL, 0x000fea0003900000ULL,
0x01c60003ff0085a7ULL, 0x000e640008000046ULL, 0xfffffffc00ec8947ULL, 0x002fea000383ffffULL,
0xffffff9000087947ULL, 0x012fea000383ffffULL, 0x00000009ff057e24ULL, 0x000fc8000f8e00ffULL,
0x01c6880b050075a7ULL, 0x000262000800017fULL, 0x000090000000791aULL, 0x000fc80000000000ULL,
0x009896800000895dULL, 0x000fea0003900000ULL, 0x01c6880b050085a7ULL, 0x000e64000800007fULL,
0xfffffffc00e88947ULL, 0x002fea000383ffffULL, 0xffffffec00107947ULL, 0x000fea000383ffffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0x000000ffff377224ULL, 0x000fe400078e0004ULL,
0x00000002ff367424ULL, 0x000fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fce00078e00ffULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00003637357389ULL, 0x0006e40000000039ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff377224ULL, 0x002fe400078e0005ULL,
0x00000002ff367424ULL, 0x000fe400078e00ffULL, 0x0000001fff397424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff297224ULL, 0x004fce00078e0035ULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00003637357389ULL, 0x0002640000000039ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002904287209ULL, 0x000fe20007810000ULL,
0x000000ffff377224ULL, 0x000fe400078e0006ULL, 0x000000ffff0a7224ULL, 0x000fce00078e0035ULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00003637357389ULL, 0x0002640000000039ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000000a052a7209ULL, 0x000fe20007810000ULL,
0x000000ffff377224ULL, 0x000fe400078e0007ULL, 0x000000ffff2b7224ULL, 0x000fce00078e0035ULL,
0x0000000034087348ULL, 0x000fea0003c00000ULL, 0x0c00003637357389ULL, 0x0002640000000039ULL,
0x000000000000791bULL, 0x002fe20003800000ULL, 0x0000002b062b7209ULL, 0x000fe20007810000ULL,
0x000000ffff377224ULL, 0x000fe400078e0028ULL, 0x00000001ff367424ULL, 0x000fe400078e00ffULL,
0x000000ffff2c7224ULL, 0x000fce00078e0035ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00003637357389ULL, 0x0002640000000039ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002c070a7209ULL, 0x000fe20007810000ULL, 0x000000ffff377224ULL, 0x000fe400078e002aULL,
0x000000ffff2d7224ULL, 0x000fce00078e0035ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00003637357389ULL, 0x0002640000000039ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002d28047209ULL, 0x000fe20007810000ULL, 0x000000ffff377224ULL, 0x000fe400078e002bULL,
0x000000ffff2f7224ULL, 0x000fce00078e0035ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00003637357389ULL, 0x0002640000000039ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002f2a057209ULL, 0x000fe20007810000ULL, 0x000000ffff377224ULL, 0x000fe400078e000aULL,
0x000000ffff2e7224ULL, 0x000fce00078e0035ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0c00003637357389ULL, 0x0002640000000039ULL, 0x000000000000791bULL, 0x002fe20003800000ULL,
0x0000002e2b067209ULL, 0x000fe20007810000ULL, 0x000000ffff297224ULL, 0x000fe200078e0035ULL,
0xfffffff000187947ULL, 0x000fec000383ffffULL, 0x0000007000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0021ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0000001f221f7389ULL, 0x0006e40000000023ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1d7224ULL, 0x004fe400078e001fULL, 0x000000ffff227224ULL, 0x002fe400078e001eULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0021ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0000001f221f7389ULL, 0x0006e40000000023ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000009000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x004fe400078e001fULL, 0x000000ffff227224ULL, 0x002fe400078e0000ULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff237424ULL, 0x000fe400078e00ffULL,
0x000000ffff347224ULL, 0x000fce00078e0021ULL, 0x0000000034087348ULL, 0x000fea0003c00000ULL,
0x0000001f221f7389ULL, 0x0006e40000000023ULL, 0x000000000000791bULL, 0x008fe20003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xfffffff400407947ULL, 0x006fea000383ffffULL,
0x0180000035007836ULL, 0x000fe20000000000ULL, 0x0000016000007945ULL, 0x000fe80003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000003500008308ULL, 0x0002a20000001000ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x008000000300780cULL, 0x040fe40003f22070ULL, 0x000000ff0300720cULL, 0x000fe40003f05070ULL,
0xffffffffff007807ULL, 0x004fe40004800000ULL, 0x00000001ff037807ULL, 0x000fc60000000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000000000248947ULL, 0x000fea0003800000ULL, 0x007fffff35007812ULL, 0x000fc800078ec0ffULL,
0x000000ff0000720cULL, 0x000fc80003f02070ULL, 0xffffffffff007807ULL, 0x000fca0004000000ULL,
0x000000ffff007224ULL, 0x000fca00078e0a00ULL, 0x0000000003ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000035037812ULL, 0x000fd600078ec0ffULL, 0x0080000003000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0003ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000003500007308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffffeac02787950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000166ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000001d0ULL, 0x00000000000001e8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000003b8ULL, 0x0000000000000180ULL,
0x0000000e00000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000d6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000538ULL, 0x00000000000000d8ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000610ULL, 0x0000000000000048ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000658ULL, 0x0000000000000558ULL,
0x0000000d00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000131ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bb0ULL, 0x0000000000000020ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x00000004000000c0ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000000ULL,
0x0000000d00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000f8ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL, 0x0000000000000030ULL,
0x0000000c00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000040000011fULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000c00ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000006dULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c48ULL, 0x0000000000000008ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008fULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000c50ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000000ULL, 0x0000000100000032ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL, 0x0000000000015300ULL,
0x0000000e00000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007fULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f80ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL,
0x0000000000000043ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000400ULL,
0x0000000d00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000008000000a0ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000014dULL,
0x0000000000000042ULL, 0x0000000000000000ULL, 0x0000000000015f90ULL, 0x0000000000000268ULL,
0x0000000d00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000016678ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000016678ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000c48ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000018ULL, 0x0000000000000018ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000c80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000015300ULL, 0x0000000000015300ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000015f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000010ULL,
0x0000000000000414ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000015f90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000268ULL, 0x0000000000000268ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 92104;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
