/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001b890ULL, 0x000000000001b410ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000019ee0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x000000000001a050ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x000000000001a090ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x000000000001a0d0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x000000000001a200ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00019ee000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x0066700400288080ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x9b08288080940828ULL, 0x288080af08288080ULL, 0x828016288080a808ULL, 0x0000000003102880ULL,
0x8080a89200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00019ee000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080900828808081ULL, 0xa8082880809b0828ULL, 0x288080af08288080ULL, 0x8280162880809408ULL,
0x0000000003102880ULL, 0x8080949200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x000000f800000000ULL, 0x0001a05000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080940828808081ULL, 0xa8082880809b0828ULL, 0x288080af08288080ULL,
0x8280162880809008ULL, 0x0000000003102880ULL, 0x8080909200000000ULL, 0x0000000000220028ULL,
0x0000001cffffffffULL, 0x0000018000000000ULL, 0x0001a09000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080940828808081ULL, 0xa8082880809b0828ULL,
0x288080af08288080ULL, 0x8280162880809008ULL, 0x0000000003102880ULL, 0x8080909200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000020800000000ULL, 0x0001a0d000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x000812040000007eULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005801600000000eULL, 0x000c170400581903ULL,
0x0050000700000000ULL, 0x000c17040021f000ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL,
0x0040000500000000ULL, 0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x000189d000018690ULL, 0x00018aa0000189e0ULL, 0x00018ac000018ab0ULL,
0xffffffff01a82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002dffffffffULL, 0x0500002d0500002dULL, 0xffffffff0500002dULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01a82804ffffffffULL, 0x0000015000000110ULL, 0x0000264000001670ULL,
0x00002760000026c0ULL, 0x00002a9000002790ULL, 0x00002b1000002aa0ULL, 0x0000304000002b80ULL,
0x00003f6000003f50ULL, 0x00005190000041c0ULL, 0x000052c000005210ULL, 0x000055c0000053e0ULL,
0x00005630000055d0ULL, 0x0000593000005690ULL, 0x000066f0000066e0ULL, 0x000078c0000069c0ULL,
0x000079f000007940ULL, 0x00007cf000007b10ULL, 0x00007d6000007d00ULL, 0x0000804000007dc0ULL,
0x00008e2000008e10ULL, 0x0000a0d0000090f0ULL, 0x0000a2000000a150ULL, 0x0000a5000000a320ULL,
0x0000a5700000a510ULL, 0x0000a8a00000a5d0ULL, 0x0000b6600000b650ULL, 0x0000bac00000bab0ULL,
0x0000e0900000c3b0ULL, 0x0000e7000000e250ULL, 0x0000ef700000e730ULL, 0x0001839000018360ULL,
0x000183b0000183a0ULL, 0x00018400000183e0ULL, 0x0001842000018410ULL, 0x00018af000018a90ULL,
0x00018b1000018b00ULL, 0x0001927000019220ULL, 0x00019350000192e0ULL, 0x00019430000193c0ULL,
0x000194d000019480ULL, 0x000195a000019530ULL, 0x0001966000019600ULL, 0x00019700000196b0ULL,
0x000197d000019760ULL, 0x0001989000019830ULL, 0x00019930000198e0ULL, 0x00019a0000019990ULL,
0x00019ac000019a60ULL, 0x00019b7000019b10ULL, 0x00019c1000019bc0ULL, 0x00019cb000019c60ULL,
0x00019d5000019d00ULL, 0x00019e2000019db0ULL, 0x00019ec000019e70ULL, 0x0000022002003904ULL,
0x00014600000000ffULL, 0x00000250003f0100ULL, 0x0001460800000003ULL, 0x000002a0003f0120ULL,
0x0001468800000003ULL, 0x00000480003f0120ULL, 0x00014600000000ffULL, 0x00000600003f0107ULL,
0x0001468c0000006aULL, 0x00000660003f0102ULL, 0x000146880000006aULL, 0x000024b0003f0101ULL,
0x000146080000006aULL, 0x000024c0003f0101ULL, 0x0001460c0000006aULL, 0x00002550003f0105ULL,
0x0001460c0000006aULL, 0x000041a0003f0105ULL, 0x00014688000000ffULL, 0x00005060003f0101ULL,
0x000146280000006aULL, 0x00005070003f0101ULL, 0x0001462c0000006aULL, 0x00005100003f0105ULL,
0x0001462c0000006aULL, 0x00006990003f0105ULL, 0x00014690000000ffULL, 0x00007790003f0101ULL,
0x000146480000006aULL, 0x000077a0003f0101ULL, 0x0001464c0000006aULL, 0x00007830003f0105ULL,
0x0001464c0000006aULL, 0x000090c0003f0105ULL, 0x00014698000000ffULL, 0x00009fa0003f0101ULL,
0x000146680000006aULL, 0x00009fb0003f0101ULL, 0x0001466c0000006aULL, 0x0000a040003f0105ULL,
0x0001466c0000006aULL, 0x0000b900003f0105ULL, 0x000146a0000000ffULL, 0x0000f300003f0101ULL,
0x00014600000000ffULL, 0x000100b0003f0101ULL, 0x00014604000000ffULL, 0x00010150003f0105ULL,
0x00014604000000ffULL, 0x000179b0003f0105ULL, 0x0000000000000006ULL, 0x000179f0003f0101ULL,
0x0000000400000006ULL, 0x00017c60003f0105ULL, 0x0000000400000006ULL, 0x00019080003f0105ULL,
0x0001460800000008ULL, 0x000190e0003f0101ULL, 0x0001461000000008ULL, 0x00019140003f0101ULL,
0x0001461800000008ULL, 0x000191b0003f0101ULL, 0x0001462000000008ULL, 0x00033803003f0101ULL,
0x0000f1d000101c04ULL, 0x00010240000101b0ULL, 0x00000401000191f0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000027cULL, 0x0000001200000002ULL, 0x00000000000001f4ULL, 0x0000001200000002ULL,
0x000000000000016cULL, 0x0000001200000002ULL, 0x00000000000000e4ULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000254ULL, 0x0000001200000002ULL,
0x00000000000001ccULL, 0x0000001200000002ULL, 0x0000000000000144ULL, 0x0000001200000002ULL,
0x00000000000000bcULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000067919ULL, 0x000e620000002300ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff127624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000e620000002200ULL,
0x00000200ff157424ULL, 0x000fe400078e00ffULL, 0x0000000812097824ULL, 0x000fe200078e00ffULL,
0x0000000000077919ULL, 0x000ea20000002100ULL, 0x00000004ff677424ULL, 0x000fc600078e00ffULL,
0x0000000000027919ULL, 0x000ee80000002600ULL, 0x00000000000a7919ULL, 0x000f280000000000ULL,
0x0000000000057919ULL, 0x000f680000002700ULL, 0x0000000000047919ULL, 0x000f220000000000ULL,
0x0000000106007824ULL, 0x002fe200078e0203ULL, 0x00000005ff637819ULL, 0x004fc60000011607ULL,
0x0000008000037824ULL, 0x000fe400078e0207ULL, 0x00001fff06007589ULL, 0x0003e200000e0000ULL,
0x0000001400077300ULL, 0x000ea200000e0000ULL, 0x0000000802087824ULL, 0x008fe200078e00ffULL,
0x000000ff0300720cULL, 0x040fe20003f25270ULL, 0x00001fff63637589ULL, 0x000ee200000e0000ULL,
0x0000000f0300780cULL, 0x040fe40003f44070ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x000000030300780cULL, 0x000fe20003f64070ULL, 0x00000005090c7224ULL, 0x020fe200078e0208ULL,
0x0000001400147309ULL, 0x000f620000000000ULL, 0x00000010040f7824ULL, 0x010fc800078e00ffULL,
0x3fffff80ff069424ULL, 0x002fe200078e00ffULL, 0x0000000a0700720cULL, 0x004fe20003f02070ULL,
0x7fffff80ff079424ULL, 0x000fe200078e00ffULL, 0x000001f00f137812ULL, 0x000fe200078ec0ffULL,
0x3fffffc0ff08a424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff09a424ULL, 0x000fe200078e00ffULL,
0x01460006ff009388ULL, 0x0003e20000000a00ULL, 0xff317217ff10c424ULL, 0x000fe400078e00ffULL,
0x3fffff60ff0ab424ULL, 0x000fe200078e00ffULL, 0x014608080300a388ULL, 0x0005e20000008a00ULL,
0x00000004000d7824ULL, 0x008fc400078e0263ULL, 0x7fffff60ff0bb424ULL, 0x000fe200078e00ffULL,
0x014400100300c388ULL, 0x000fe20000004800ULL, 0x000000020d0d7824ULL, 0x000fc600078e00ffULL,
0x0146880a0300b388ULL, 0x0007e20000008a00ULL, 0x000000010c067824ULL, 0x002fe200078e020dULL,
0x000000080d0e7817ULL, 0x040fe40007800000ULL, 0x000000010d117810ULL, 0x000fe20007ffe0ffULL,
0x00005c0006067625ULL, 0x000fc800078e0015ULL, 0x000000010e0e7824ULL, 0x000fe400078e0a0dULL,
0x000000010c087824ULL, 0x004fe200078e0211ULL, 0x000000070d037812ULL, 0x008fe400078ec0ffULL,
0x00000007110b7812ULL, 0x000fe200078ec0ffULL, 0x00005c0008087625ULL, 0x000fe200078e0015ULL,
0x0000001f030c7812ULL, 0x000fe200078e7804ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000013060a7210ULL, 0x080fe40007f7e0ffULL, 0x000000ff0e00720cULL, 0x040fe20003f23070ULL,
0x000000200d0c7824ULL, 0x000fe200078e020cULL, 0x0000001f0b067812ULL, 0x000fe200078e7804ULL,
0x000000ffff0b7224ULL, 0x000fe200018e0607ULL, 0x000000010e00780cULL, 0x000fe20003f43070ULL,
0x000000100c037824ULL, 0x000fe200078e00ffULL, 0x0000001308087210ULL, 0x000fe20007f9e0ffULL,
0x0000002011067824ULL, 0x000fc400078e0206ULL, 0x000000ffff0c7224ULL, 0x020fe400078e0a14ULL,
0x000000ffff097224ULL, 0x000fe400020e0609ULL, 0x00000010060d7824ULL, 0x000fe400078e00ffULL,
0x0000620005067625ULL, 0x000fe200078e0067ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a037faeULL, 0x0003e8000c901c46ULL, 0x00000000080d7faeULL, 0x0003e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0146040cffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000606627981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0000720cULL, 0x000fe20003f05270ULL, 0x00000004ff647e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f62617810ULL, 0x004fc40007ffe0ffULL, 0x000000ff62177810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff617819ULL, 0x000fe40000011661ULL, 0x00000008ff177819ULL, 0x000fca0000011617ULL,
0x0000ec5000008947ULL, 0x000fea0003800000ULL, 0x0000000264687824ULL, 0x040fe200078e00ffULL,
0x0000000164007810ULL, 0x000fe20007ffe0ffULL, 0x00000008636a7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x002fe200078e00ffULL, 0x000000170000720cULL, 0x000fe40003f26070ULL,
0x000000616800720cULL, 0x000fe20003f06070ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01468c036aff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014688006aff7f8cULL, 0x0005e2000c80043fULL, 0xffffffffff667424ULL, 0x000fe200078e00ffULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000640068037a10ULL, 0x002fe20007ffe0ffULL,
0x0000000205007824ULL, 0x000fc800078e00ffULL, 0x0000640000007a24ULL, 0x000fc800078e0203ULL,
0x0000600000667625ULL, 0x000fcc00078e0067ULL, 0x0000000666667981ULL, 0x000364000c1e1900ULL,
0x0000580066007a24ULL, 0x020fc800078e02ffULL, 0x0000008000237824ULL, 0x000fe200078e00ffULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000010064037824ULL, 0x002fe200078e00ffULL,
0x00000003ff0d7819ULL, 0x000fc80000011604ULL, 0x0000000362007217ULL, 0x000fe40007800000ULL,
0x000000080d117810ULL, 0x040fe40007ffe0ffULL, 0x000000040d0f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x000000100d157810ULL, 0x040fe20007ffe0ffULL,
0x0000008002037824ULL, 0x000fe200078e020dULL, 0x0000000c0d137810ULL, 0x000fe20007ffe0ffULL,
0x0000000811187824ULL, 0x040fe200078e00ffULL, 0x0000000411077212ULL, 0x080fe200078e3cffULL,
0x000000080f097824ULL, 0x000fe200078e00ffULL, 0x00000003230a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x000000040f067212ULL, 0x080fe200078e3cffULL,
0x00000008131a7824ULL, 0x000fe200078e00ffULL, 0x000000140d1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e06ffULL, 0x0000000415087212ULL, 0x000fc400078e3cffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff809167812ULL, 0x000fe400078ee206ULL, 0x0000000413077212ULL, 0x080fe400078e3cffULL,
0x00005e000a067a11ULL, 0x000fe400078048ffULL, 0xfffffff8191c7812ULL, 0x000fe400078ee208ULL,
0x000000041d097212ULL, 0x000fc400078e3cffULL, 0x0000000403087810ULL, 0x040fe40007ffe0ffULL,
0xfffffff81a1a7812ULL, 0x000fe400078ee207ULL, 0x00005f000a077a11ULL, 0x000fe400000f4c0bULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee209ULL, 0x0000000c030a7810ULL, 0x000fe40007ffe0ffULL,
0x00000008231b7210ULL, 0x000fc40007f9e0ffULL, 0x0000000803097810ULL, 0x000fe40007ffe0ffULL,
0x0000000a23147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x0000001c0d217810ULL, 0x000fe40007ffe0ffULL, 0x00000010030b7810ULL, 0x040fe40007ffe0ffULL,
0x00000014030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0x0000000923197210ULL, 0x000fc40007f5e0ffULL, 0x00005e001b087a11ULL, 0x000fe400078c48ffULL,
0x000000180d1f7810ULL, 0x000fe40007ffe0ffULL, 0x00000018030e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c03037810ULL, 0x000fe20007ffe0ffULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0x0000000b23107210ULL, 0x040fe40007f3e0ffULL, 0x0000000c23127210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005f001b097a11ULL, 0x000fe200030f4c0aULL,
0x00000008631b7824ULL, 0x000fe200078e00ffULL, 0x00000004210b7212ULL, 0x000fc400078e3cffULL,
0x00005e00190a7a11ULL, 0x000fe400078448ffULL, 0x0000000e23257210ULL, 0x040fe40007fbe0ffULL,
0x0000002000007817ULL, 0x000fe40003800000ULL, 0x0000000323237210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x000000041f037212ULL, 0x000fe400078e3cffULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005f00190b7a11ULL, 0x000fc400010f4c0cULL, 0x000000000d00720cULL, 0x040fe40003f46070ULL,
0x000000070d0d7812ULL, 0x100fe400078e4804ULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005e00140c7a11ULL, 0x000fe400078c48ffULL,
0x0000c00063197811ULL, 0x000fe400078e68ffULL, 0x0ffffff80d0e7812ULL, 0x000fc400078ef804ULL,
0x00005f00140d7a11ULL, 0x000fe400030f4c03ULL, 0x000000000f00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0xfffffff81b037812ULL, 0x000fe200078ee204ULL,
0x000000100e1b7824ULL, 0x000fe200078e0219ULL, 0x00005e00100e7a11ULL, 0x040fe400078c48ffULL,
0x000000001100720cULL, 0x000fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005f00100f7a11ULL, 0x000fe200030f4c0fULL, 0x0000001003067825ULL, 0x000fe200078e0006ULL,
0x00005e0012107a11ULL, 0x000fc400078c48ffULL, 0x000000001300720cULL, 0x080fe40003f66070ULL,
0x00005f0012117a11ULL, 0x000fe200030f4c11ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000061b7faeULL, 0x0003e2000d101c46ULL, 0x00005e0025127a11ULL, 0x000fe400078a48ffULL,
0x00005e0023147a11ULL, 0x000fe400078c48ffULL, 0x000000001500720cULL, 0x080fe40003f46070ULL,
0x000000001d00720cULL, 0x080fe20003f86070ULL, 0x00000010181d7824ULL, 0x100fe200078e0219ULL,
0x00005f0025137a11ULL, 0x000fe200028f4c26ULL, 0x0000001020257824ULL, 0x100fe200078e0219ULL,
0x000000001f00720cULL, 0x080fe20003fa6070ULL, 0x00000010161b7824ULL, 0x002fe200078e0219ULL,
0x00005f0023157a11ULL, 0x000fe200030f4c24ULL, 0x0000001003067825ULL, 0x000fe200078e0008ULL,
0x000000002100720cULL, 0x000fc60003fc6070ULL, 0x0000001003087825ULL, 0x040fe200078e000aULL,
0x00000000061b7faeULL, 0x0003e6000c101c46ULL, 0x000000101a1f7824ULL, 0x000fe200078e0219ULL,
0x00000000081d7faeULL, 0x0003e2000c901c46ULL, 0x00000010030a7825ULL, 0x000fc800078e000cULL,
0x000000101c217824ULL, 0x000fe200078e0219ULL, 0x000000000a1f7faeULL, 0x0003e2000d901c46ULL,
0x00000010030c7825ULL, 0x000fc800078e000eULL, 0x000000101e237824ULL, 0x000fe200078e0219ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x00000010030e7825ULL, 0x000fc800078e0010ULL,
0x0000001003107825ULL, 0x040fe200078e0012ULL, 0x000000000e237faeULL, 0x0003e6000e101c46ULL,
0x0000001022197824ULL, 0x000fe200078e0219ULL, 0x0000000010257faeULL, 0x0003e2000e901c46ULL,
0x0000001003127825ULL, 0x000fca00078e0014ULL, 0x0000000012197faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x002fe20000011604ULL,
0x00000008632b7824ULL, 0x000fc600078e00ffULL, 0x0000000403077810ULL, 0x040fe40007ffe0ffULL,
0x0000000c030b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000407007212ULL, 0x0c0fe200078e3cffULL,
0x00000008070d7824ULL, 0x000fe200078e00ffULL, 0x000000040b077212ULL, 0x040fe200078e3cffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x0000000803097810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80d0b7812ULL, 0x000fe200078ee200ULL, 0x0000008002007824ULL, 0x000fe200078e0203ULL,
0xfffffff808117812ULL, 0x000fe200078ee207ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x0000001003077810ULL, 0x000fc40007ffe0ffULL, 0x0000000409067212ULL, 0x080fe400078e3cffULL,
0x0000000407097212ULL, 0x040fe200078e3cffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000023077210ULL, 0x000fe40007f1e0ffULL, 0x00000014030d7810ULL, 0x040fe40007ffe0ffULL,
0x0000001803137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee206ULL, 0x000000080d257824ULL, 0x000fe200078e00ffULL,
0x00005e0007067a11ULL, 0x000fe200078048ffULL, 0x0000000813277824ULL, 0x000fe200078e00ffULL,
0x000000040d0a7212ULL, 0x000fc400078e3cffULL, 0x00000004130c7212ULL, 0x000fe400078e3cffULL,
0x00005f0007077a11ULL, 0x000fe400000f4c08ULL, 0x0000000400087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e157812ULL, 0x000fe400078ee209ULL, 0xfffffff825257812ULL, 0x000fe400078ee20aULL,
0xfffffff827277812ULL, 0x000fc400078ee20cULL, 0x00000008000a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c000c7810ULL, 0x040fe40007ffe0ffULL, 0x00000010000e7810ULL, 0x040fe40007ffe0ffULL,
0x0000001400127810ULL, 0x040fe40007ffe0ffULL, 0x0000001800147810ULL, 0x000fe40007ffe0ffULL,
0x0000001c03197810ULL, 0x000fc40007ffe0ffULL, 0x0000001c00007810ULL, 0x000fe40007ffe0ffULL,
0x0000000823097210ULL, 0x000fe20007fde0ffULL, 0x0000000819297824ULL, 0x000fe200078e00ffULL,
0x0000000703037812ULL, 0x000fe400078e4804ULL, 0x0000000a230d7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200030e06ffULL, 0x0000000c23107210ULL, 0x040fe40007f9e0ffULL,
0x0000000e23137210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x0000001223167210ULL, 0x000fc40007f1e0ffULL, 0x0000001423187210ULL, 0x040fe40007f3e0ffULL,
0x0000000023237210ULL, 0x000fe40007f5e0ffULL, 0x0000c00063007811ULL, 0x000fe400078e68ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef804ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00000004190c7212ULL, 0x000fe200078e3cffULL, 0x000000100b1b7824ULL, 0x100fe200078e0200ULL,
0x00005e0009087a11ULL, 0x000fe200078c48ffULL, 0x0000001003197824ULL, 0x000fe200078e0200ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x00005f0009097a11ULL, 0x000fe200030f4c0aULL, 0x000000100f1d7824ULL, 0x100fe200078e0200ULL,
0x00005e000d0a7a11ULL, 0x000fe200078a48ffULL, 0x00000010111f7824ULL, 0x100fe200078e0200ULL,
0x00005e00100c7a11ULL, 0x040fe200078848ffULL, 0x0000001015217824ULL, 0x000fe200078e0200ULL,
0x00005f000d0b7a11ULL, 0x000fe200028f4c0eULL, 0x0000001025257824ULL, 0x100fe200078e0200ULL,
0x00005f00100d7a11ULL, 0x000fe200020f4c03ULL, 0x0000001027277824ULL, 0x000fe200078e0200ULL,
0xfffffff82b037812ULL, 0x000fe200078ee204ULL, 0x0000001029297824ULL, 0x000fe200078e0200ULL,
0x00005e0023147a11ULL, 0x000fe200078448ffULL, 0x000000ffff007224ULL, 0x000fe200018e06ffULL,
0x00005e00130e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e0016107a11ULL, 0x000fe200078048ffULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005e0018127a11ULL, 0x000fe200078248ffULL, 0x0000001003067825ULL, 0x000fe200078e0006ULL,
0x00005f00130f7a11ULL, 0x000fc400018f4c00ULL, 0x00005f0016117a11ULL, 0x000fe200000f4c11ULL,
0x0000001003087825ULL, 0x000fe200078e0008ULL, 0x00005f0018137a11ULL, 0x000fe200008f4c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006197faeULL, 0x0003e2000b901c46ULL,
0x00005f0023157a11ULL, 0x000fe200010f4c1aULL, 0x00000010030a7825ULL, 0x040fe400078e000aULL,
0x00000000081b7faeULL, 0x0003e4000b901c46ULL, 0x00000010030c7825ULL, 0x040fe400078e000cULL,
0x000000000a1d7faeULL, 0x0003e4000b901c46ULL, 0x00000010030e7825ULL, 0x000fc400078e000eULL,
0x000000000c1f7faeULL, 0x0003e4000b901c46ULL, 0x0000001003107825ULL, 0x040fe400078e0010ULL,
0x000000000e217faeULL, 0x0003e4000b901c46ULL, 0x0000001003127825ULL, 0x040fe400078e0012ULL,
0x0000000010257faeULL, 0x0003e4000b901c46ULL, 0x0000001003147825ULL, 0x000fc400078e0014ULL,
0x0000000012277faeULL, 0x0003e8000b901c46ULL, 0x0000000014297faeULL, 0x0003e4000b901c46ULL,
0x000000176400720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff657424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000a38000000947ULL, 0x000fea0003800000ULL, 0x0000000205007824ULL, 0x000fe400078e00ffULL,
0x00006400ff5f7624ULL, 0x000fc400078e00ffULL, 0xff317217ff657424ULL, 0x000fe400078e00ffULL,
0x000000ffff1b7224ULL, 0x000fe400078e00ffULL, 0x00006400005f7624ULL, 0x000fe400078e025fULL,
0x0000010064037824ULL, 0x000fca00078e00ffULL, 0x000000620300720cULL, 0x000fda0003f06070ULL,
0x0000a2c000000947ULL, 0x004fea0003800000ULL, 0x0000000164007810ULL, 0x000fe20007ffe0ffULL,
0x0000580066757a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000170000720cULL, 0x000fe20003f06070ULL, 0x000000ffff5e7224ULL, 0x000fe400078e0068ULL,
0x0000008075757824ULL, 0x000fd400078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff117819ULL, 0x000fe40000011604ULL, 0x0000002064037811ULL, 0x000fe400078e40ffULL,
0x0000000411097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c11137810ULL, 0x000fe40007ffe0ffULL,
0x0000000409057212ULL, 0x040fe200078e3cffULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0x0000000362007217ULL, 0x000fe20007800000ULL, 0x00000008130a7824ULL, 0x000fe200078e00ffULL,
0x00000008110b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8061f7812ULL, 0x000fe200078ee205ULL,
0x0000000100007824ULL, 0x000fe200078e0a03ULL, 0x0000001011257810ULL, 0x000fe20007ffe0ffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x0000000413057212ULL, 0x080fe400078e3cffULL,
0x00000018112d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0xfffffff80a237812ULL, 0x000fe400078ee205ULL, 0x000000040b037212ULL, 0x080fe200078e3cffULL,
0x000000082d0a7824ULL, 0x000fe200078e00ffULL, 0x0000000425067212ULL, 0x000fc400078e3cffULL,
0x0000001411297810ULL, 0x000fe40007ffe0ffULL, 0x0000002002057811ULL, 0x000fe400078e38ffULL,
0xfffffff808217812ULL, 0x000fe200078ee203ULL, 0x0000000829087824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee206ULL, 0x0000000111067824ULL, 0x000fe200078e0205ULL,
0x000000042d077212ULL, 0x000fe400078e3cffULL, 0x0000001c11317810ULL, 0x000fc40007ffe0ffULL,
0x0000000429037212ULL, 0x000fe400078e3cffULL, 0xfffffff80a2f7812ULL, 0x000fe200078ee207ULL,
0x00000008310a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8082b7812ULL, 0x000fe400078ee203ULL,
0x0000000675077210ULL, 0x000fe20007f3e0ffULL, 0x0000000109067824ULL, 0x000fe200078e0205ULL,
0x0000000431037212ULL, 0x000fe400078e3cffULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0xfffffff80a337812ULL, 0x000fe200078ee203ULL,
0x00000001250a7824ULL, 0x100fe200078e0205ULL, 0x0000000675037210ULL, 0x000fe20007f5e0ffULL,
0x000000010b067824ULL, 0x000fe200078e0205ULL, 0x00005e00070c7a11ULL, 0x000fc400078248ffULL,
0x000000000900720cULL, 0x000fe20003fa6070ULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00005f00070d7a11ULL, 0x000fe200008f4c08ULL, 0x0000000113087824ULL, 0x000fe200078e0205ULL,
0x00005e00030e7a11ULL, 0x000fe400078248ffULL, 0x0000000675097210ULL, 0x000fe40007f5e0ffULL,
0x00005f00030f7a11ULL, 0x000fe400008f4c10ULL, 0x0000000875077210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200010e06ffULL, 0x0000000a75037210ULL, 0x000fc40007f9e0ffULL,
0x00005e00090a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e0007087a11ULL, 0x000fe200078648ffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x00005e0003067a11ULL, 0x000fe400078848ffULL, 0x000000000b00720cULL, 0x080fe40003f26070ULL,
0x00005f00090b7a11ULL, 0x000fe200010f4c14ULL, 0x0000000131147824ULL, 0x100fe200078e0205ULL,
0x00005f0007097a11ULL, 0x000fe200018f4c12ULL, 0x000000012d127824ULL, 0x100fe200078e0205ULL,
0x00005f0003077a11ULL, 0x000fe200020f4c10ULL, 0x0000000129107824ULL, 0x000fe200078e0205ULL,
0x000000001100720cULL, 0x000fc40003f46070ULL, 0x0000000711117812ULL, 0x100fe400078e4804ULL,
0x0000000704037812ULL, 0x000fe400078ec0ffULL, 0x0ffffff8111d7812ULL, 0x000fe400078ef804ULL,
0x0000001075117210ULL, 0x000fe20007f7e0ffULL, 0x000000016a037824ULL, 0x000fe200078e0203ULL,
0x0000d00063167811ULL, 0x000fe400078e68ffULL, 0x000000001300720cULL, 0x000fe20003f86070ULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078648ffULL,
0x000000101d1d7824ULL, 0x000fc400078e0216ULL, 0x00000010030c7825ULL, 0x000fe200078e000cULL,
0x00005f0011117a11ULL, 0x000fe400018f4c1cULL, 0x0000001275137210ULL, 0x000fe20007f7e0ffULL,
0x000000101f057824ULL, 0x000fe200078e0216ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1d7faeULL, 0x0003e2000d101c46ULL, 0x0000001475157210ULL, 0x000fe20007f5e0ffULL,
0x00000010030e7825ULL, 0x000fe200078e000eULL, 0x00005e0013127a11ULL, 0x000fc600078c48ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x000000002500720cULL, 0x080fe20003f66070ULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x000000000e057faeULL, 0x0007e2000e901c46ULL,
0x000000002d00720cULL, 0x080fe20003fa6070ULL, 0x00000010030a7825ULL, 0x000fe200078e000aULL,
0x00005f0013137a11ULL, 0x000fe400030f4c14ULL, 0x00005e0015147a11ULL, 0x000fe200078448ffULL,
0x00000010211d7824ULL, 0x102fe200078e0216ULL, 0x000000002900720cULL, 0x080fe20003fc6070ULL,
0x00000010231f7824ULL, 0x000fe200078e0216ULL, 0x00005f0015157a11ULL, 0x000fe200010f4c1cULL,
0x0000001003087825ULL, 0x000fe200078e0008ULL, 0x000000003100720cULL, 0x000fe20003f46070ULL,
0x000000000a1d7faeULL, 0x0003e4000c901c46ULL, 0x0000001027217824ULL, 0x000fc400078e0216ULL,
0x0000001003067825ULL, 0x000fe200078e0006ULL, 0x00000000081f7faeULL, 0x0003e6000e101c46ULL,
0x000000102b237824ULL, 0x000fe200078e0216ULL, 0x0000000006217faeULL, 0x0003e2000d901c46ULL,
0x00000010030c7825ULL, 0x000fc800078e0010ULL, 0x000000102f257824ULL, 0x000fe200078e0216ULL,
0x000000000c237faeULL, 0x0003e2000f101c46ULL, 0x00000010030e7825ULL, 0x008fc800078e0012ULL,
0x0000001033277824ULL, 0x000fe200078e0216ULL, 0x000000000e257faeULL, 0x0003e2000e901c46ULL,
0x0000001003107825ULL, 0x000fca00078e0014ULL, 0x0000000010277faeULL, 0x0003e2000d101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fc80000011604ULL,
0x0000000403077810ULL, 0x040fe40007ffe0ffULL, 0x00000008030b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000407007212ULL, 0x000fe200078e3cffULL, 0x000000080b067824ULL, 0x000fe200078e00ffULL,
0x00000014031d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fc400078ee200ULL, 0x000000040b057212ULL, 0x080fe200078e3cffULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x000000040f007212ULL, 0x080fe400078e3cffULL,
0x0000001003137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8060d7812ULL, 0x000fe400078ee205ULL,
0xfffffff811117812ULL, 0x000fe200078ee200ULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0x000000041d067212ULL, 0x000fc400078e3cffULL, 0x0000002002007811ULL, 0x000fe400078e38ffULL,
0x0000000413057212ULL, 0x000fe400078e3cffULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x0000000103067824ULL, 0x140fe200078e0200ULL, 0x00000018031f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001070a7824ULL, 0x100fe200078e0200ULL, 0xfffffff808157812ULL, 0x000fe200078ee205ULL,
0x000000010b0c7824ULL, 0x000fe200078e0200ULL, 0x0000000703057812ULL, 0x000fe200078e4804ULL,
0x000000081f107824ULL, 0x000fe200078e00ffULL, 0x0000001c03217810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x100fe200078e0200ULL, 0x0000000675037210ULL, 0x000fe20007f3e0ffULL,
0x0000000113127824ULL, 0x100fe200078e0200ULL, 0x000000041f077212ULL, 0x080fe200078e3cffULL,
0x000000011d147824ULL, 0x100fe200078e0200ULL, 0x0000d00063087811ULL, 0x000fe200078e68ffULL,
0x000000011f167824ULL, 0x100fe200078e0200ULL, 0xfffffff8100b7812ULL, 0x000fe200078ee207ULL,
0x00000001211c7824ULL, 0x040fe200078e0200ULL, 0x00000004210f7212ULL, 0x000fe200078e3cffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005e0003067a11ULL, 0x000fe200078248ffULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0x0ffffff805057812ULL, 0x000fe200078ef804ULL,
0x000000100b277824ULL, 0x000fe200078e0208ULL, 0x00005f0003077a11ULL, 0x000fe200008f4c00ULL,
0x000000100d1f7824ULL, 0x100fe200078e0208ULL, 0xfffffff81e0f7812ULL, 0x000fe200078ee20fULL,
0x00000010091d7824ULL, 0x100fe200078e0208ULL, 0x0000000a75007210ULL, 0x000fe20007f3e0ffULL,
0x0000001005057824ULL, 0x100fe200078e0208ULL, 0x0000000c750b7210ULL, 0x000fe20007f5e0ffULL,
0x0000001011217824ULL, 0x100fe200078e0208ULL, 0x0000000e750d7210ULL, 0x000fe20007f7e0ffULL,
0x0000001015237824ULL, 0x100fe200078e0208ULL, 0x0000000704037812ULL, 0x000fe200078ec0ffULL,
0x0000001025257824ULL, 0x100fe200078e0208ULL, 0x0000001675137210ULL, 0x000fe20007f9e0ffULL,
0x000000100f297824ULL, 0x000fc400078e0208ULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x00005e0000087a11ULL, 0x000fe200078248ffULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00005e000b0a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078648ffULL, 0x000000016a037824ULL, 0x000fe200078e0203ULL,
0x00005f0000097a11ULL, 0x000fe400008f4c09ULL, 0x00005f000b0b7a11ULL, 0x000fe200010f4c0eULL,
0x0000001003067825ULL, 0x000fe200078e0006ULL, 0x00005f000d0d7a11ULL, 0x000fc400018f4c10ULL,
0x0000001275007210ULL, 0x000fe20007f5e0ffULL, 0x0000001003087825ULL, 0x000fe200078e0008ULL,
0x0000001475117210ULL, 0x040fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0x0000001c75157210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e06ffULL, 0x00005e00000e7a11ULL, 0x040fe200078448ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078648ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078848ffULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078248ffULL,
0x00000010030a7825ULL, 0x000fe200078e000aULL, 0x00005f00000f7a11ULL, 0x000fe200010f4c0fULL,
0x00000000081d7faeULL, 0x0003e2000b901c46ULL, 0x00005f0011117a11ULL, 0x000fe200018f4c16ULL,
0x00000010030c7825ULL, 0x000fe200078e000cULL, 0x00005f0013137a11ULL, 0x000fe200020f4c1cULL,
0x000000000a1f7faeULL, 0x0003e2000b901c46ULL, 0x00005f0015157a11ULL, 0x000fe200008f4c1eULL,
0x00000010030e7825ULL, 0x000fc400078e000eULL, 0x000000000c217faeULL, 0x0003e4000b901c46ULL,
0x0000001003107825ULL, 0x040fe400078e0010ULL, 0x000000000e237faeULL, 0x0003e4000b901c46ULL,
0x0000001003127825ULL, 0x040fe400078e0012ULL, 0x0000000010257faeULL, 0x0003e4000b901c46ULL,
0x0000001003147825ULL, 0x000fc400078e0014ULL, 0x0000000012277faeULL, 0x0003e8000b901c46ULL,
0x0000000014297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014608006a067f8cULL, 0x002fe8000c80043fULL,
0x01460c006a037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007824807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff007424ULL, 0x000fc800078e00ffULL,
0x0000000000037305ULL, 0x0002e4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x008fe40003800000ULL, 0x01460c006a037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007824807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010045d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fe20000011604ULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0x000000705d5d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c00007812ULL, 0x000fca00078ec0ffULL, 0x000000015d5d7824ULL, 0x000fca00078e0200ULL,
0x014000005d007984ULL, 0x000e680000000800ULL, 0x014200005d037984ULL, 0x0007220000000800ULL,
0x000000650000720bULL, 0x002fe20003f3d000ULL, 0x00016bc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000057806ULL, 0x008fc800008e0100ULL, 0x0000ffff05077812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff057424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff6300720cULL, 0x000fe40003f25270ULL,
0x000000650000720bULL, 0x000fe20003f54000ULL, 0x00016b927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000057806ULL, 0x000fe400010e0100ULL, 0x00000000650a7209ULL, 0x000fe40007810000ULL,
0x0000ffff05087812ULL, 0x000fe400078e3cffULL, 0x00000002ff057819ULL, 0x000fe20000011604ULL,
0x8000000a65067221ULL, 0x000fe20000010000ULL, 0x0144000a5d009388ULL, 0x0003e20000000800ULL,
0x0000000807ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b06067820ULL, 0x000fc80000410000ULL,
0x00000006002e7308ULL, 0x0002e20000000800ULL, 0x00016b427f007947ULL, 0x000fec000b800000ULL,
0x00001f052e067589ULL, 0x00a2e400000e0000ULL, 0x0000000805057810ULL, 0x002fe20007ffe0ffULL,
0x00016b827f007947ULL, 0x000fea000b800000ULL, 0x00001f052e057589ULL, 0x0002a400000e0000ULL,
0x8000000a00001221ULL, 0x100fe20000010000ULL, 0x000000051b1b7220ULL, 0x084fe20000410000ULL,
0x000000051a1a7220ULL, 0x080fe20000410000ULL, 0x0000000537377220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b00001820ULL, 0x000fe20000410000ULL, 0x0000000536367220ULL, 0x080fe20000410000ULL,
0x000000054b4b7220ULL, 0x080fe20000410000ULL, 0x000000054a4a7220ULL, 0x080fe20000410000ULL,
0x00000000005c1308ULL, 0x000ea20000000800ULL, 0x000000054f4f7220ULL, 0x080fe20000410000ULL,
0x000000054e4e7220ULL, 0x080fe20000410000ULL, 0x0000000547477220ULL, 0x080fe20000410000ULL,
0x0000000546467220ULL, 0x080fe20000410000ULL, 0x0000000543437220ULL, 0x080fe20000410000ULL,
0x0000000542427220ULL, 0x080fe20000410000ULL, 0x000000053f3f7220ULL, 0x080fe20000410000ULL,
0x000000053e3e7220ULL, 0x080fe20000410000ULL, 0x000000053b3b7220ULL, 0x080fe20000410000ULL,
0x000000053a3a7220ULL, 0x000fe20000410000ULL, 0x0000002e60607220ULL, 0x000fe20000410000ULL,
0x00000001ff057807ULL, 0x000fe20000800000ULL, 0x0000000619197220ULL, 0x088fe20000410000ULL,
0x0000000618187220ULL, 0x080fe20000410000ULL, 0x0000000635357220ULL, 0x080fe20000410000ULL,
0x0000000634347220ULL, 0x080fe20000410000ULL, 0x0000000649497220ULL, 0x080fe20000410000ULL,
0x0000000648487220ULL, 0x080fe20000410000ULL, 0x000000064d4d7220ULL, 0x080fe20000410000ULL,
0x000000064c4c7220ULL, 0x080fe20000410000ULL, 0x0000000645457220ULL, 0x080fe20000410000ULL,
0x0000000644447220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x000fe20000410000ULL, 0x000000ffff657224ULL, 0x000fe200078e000aULL,
0x0000005c03031220ULL, 0x014fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005cff00723eULL, 0x000fe200000000ffULL, 0x0000006003607221ULL, 0x010fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff037819ULL, 0x000fe40000011604ULL,
0x00005410002e7816ULL, 0x002fe20000000000ULL, 0x000169027f007947ULL, 0x000fea000b800000ULL,
0x0000000803167810ULL, 0x000fe20007ffe0ffULL, 0x00001f032e737589ULL, 0x0002e800000e0000ULL,
0x00001f162e6c7589ULL, 0x00032400000e0000ULL, 0x0000001003157810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0015ULL,
0x00002b2000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0001757000007944ULL, 0x01cfea0003c00000ULL,
0x0000001803147810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2f7224ULL, 0x002fe200078e0014ULL, 0x00002b9000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0001750000007944ULL, 0x01cfea0003c00000ULL, 0x00000007040d7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff007819ULL, 0x100fe40000011604ULL,
0x000000080d6d7812ULL, 0x000fe400078ef804ULL, 0x0000000804037812ULL, 0x002fc400078ec0ffULL,
0x0000000700067812ULL, 0x000fca00078e786dULL, 0x000000086d0f7824ULL, 0x000fca00078e0206ULL,
0x0000a0000f2c7811ULL, 0x000fca00078e20ffULL, 0x0000000703067812ULL, 0x140fe200078ef804ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x0000000703037812ULL, 0x000fe400078ec804ULL,
0x0000000200087810ULL, 0x040fe40007ffe0ffULL, 0x00000004000a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000600107810ULL, 0x000fe40007ffe0ffULL, 0x0000000003777212ULL, 0x000fc400078e3cffULL,
0x00000008036b7212ULL, 0x040fe400078e3cffULL, 0x0000000a03697212ULL, 0x040fe200078e3cffULL,
0x0000000806717824ULL, 0x040fe200078e0277ULL, 0x0000001003037212ULL, 0x000fe200078e3cffULL,
0x00000008067b7824ULL, 0x040fe200078e026bULL, 0x0000c000630c7811ULL, 0x000fe200078e68ffULL,
0x00000008066f7824ULL, 0x000fe200078e0269ULL, 0x0000000708007812ULL, 0x000fe200078e786dULL,
0x0000000806797824ULL, 0x000fe200078e0203ULL, 0x0000991005057816ULL, 0x000fe200000000ffULL,
0x00000010710b7824ULL, 0x000fc400078e020cULL, 0x000000106f097824ULL, 0x100fe200078e020cULL,
0x000000ff0500720cULL, 0x000fe20003f25270ULL, 0x000000107b0a7824ULL, 0x100fe200078e020cULL,
0x000000000b58783bULL, 0x000f620000004200ULL, 0x0000001079087824ULL, 0x000fe400078e020cULL,
0x000000086d077824ULL, 0x000fe200078e0200ULL, 0x000000000950783bULL, 0x000f220000004200ULL,
0x0000008006007811ULL, 0x000fc600078e18ffULL, 0x000000000a54783bULL, 0x000fe20000004200ULL,
0x0000a00007107811ULL, 0x000fe200078e20ffULL, 0x0000000177777824ULL, 0x100fe400078e0200ULL,
0x000000000830783bULL, 0x000fe20000004200ULL, 0x0000000169697824ULL, 0x100fe200078e0200ULL,
0x000000732c2c9232ULL, 0x08afe20000000000ULL, 0x000000016b6b7824ULL, 0x100fe200078e0200ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000000103677824ULL, 0x000fe200078e0200ULL,
0x000000732e2e9232ULL, 0x000fe20000000000ULL, 0x0000001077067824ULL, 0x100fe200078e020cULL,
0x0000006c2d2d9232ULL, 0x090fe20000000000ULL, 0x0000001069037824ULL, 0x100fe200078e020cULL,
0x0000006c2f2f9232ULL, 0x000fe20000000000ULL, 0x000000106b057824ULL, 0x100fe200078e020cULL,
0x000000000628783bULL, 0x004ea20000004200ULL, 0x0000001067007824ULL, 0x000fc600078e020cULL,
0x000000000320783bULL, 0x000ee80000004200ULL, 0x000000000524783bULL, 0x000f280000004200ULL,
0x00000000001c783bULL, 0x000ea20000004200ULL, 0x000000582c38723cULL, 0x060ff00000001838ULL,
0x0000005a2c3c723cULL, 0x040ff0000000183cULL, 0x000000502c4c723cULL, 0x000fe2000000184cULL,
0x0000007310109232ULL, 0x002fc40000000000ULL, 0x0000007312129232ULL, 0x000fe20000000000ULL,
0x0000004064737811ULL, 0x000fe200078e40ffULL, 0x0000006c11119232ULL, 0x080fe40000000000ULL,
0x0000006c13139232ULL, 0x000fe20000000000ULL, 0x000000542c40723cULL, 0x040ff00000001840ULL,
0x000000562c44723cULL, 0x040ff00000001844ULL, 0x000000522c48723cULL, 0x040ff00000001848ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x000000322c18723cULL, 0x000ff00000001818ULL,
0x000000281038723cULL, 0x044ff00000001838ULL, 0x0000002a103c723cULL, 0x040ff0000000183cULL,
0x00000020104c723cULL, 0x048ff0000000184cULL, 0x000000241040723cULL, 0x050ff00000001840ULL,
0x000000261044723cULL, 0x040ff00000001844ULL, 0x000000221020723cULL, 0x040ff00000001848ULL,
0x0000001c1034723cULL, 0x040ff00000001834ULL, 0x0000001e1028723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x00000003ff277819ULL, 0x000fe40000011604ULL, 0x0000004002267811ULL, 0x000fe400078e38ffULL,
0x0000000427137810ULL, 0x040fe40007ffe0ffULL, 0x0000007362107217ULL, 0x000fe20007800000ULL,
0x0000000127127824ULL, 0x100fe200078e0226ULL, 0x0000000413187212ULL, 0x040fe200078e3cffULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0x00000008272d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a73ULL, 0x0000001275117210ULL, 0x000fe20007f5e0ffULL,
0x0000000113127824ULL, 0x000fe200078e0226ULL, 0xfffffff831317812ULL, 0x000fe200078ee218ULL,
0x000000082d307824ULL, 0x000fe200078e00ffULL, 0x00000020102c7817ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078448ffULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0x0000002c1300720cULL, 0x000fc40003f66070ULL,
0x00005f0011117a11ULL, 0x000fe200010f4c18ULL, 0x000000012d187824ULL, 0x100fe200078e0226ULL,
0x0000001275197210ULL, 0x000fe40007f5e0ffULL, 0x0000000c27497810ULL, 0x000fe40007ffe0ffULL,
0x0000001875137210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200010e06ffULL,
0x00000010274b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000149187824ULL, 0x100fe200078e0226ULL,
0x00005e00191c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff1e7224ULL, 0x000fe200020e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078848ffULL, 0x000000014b1a7824ULL, 0x000fe200078e0226ULL,
0x00005f00191d7a11ULL, 0x000fc400010f4c24ULL, 0x00000018751b7210ULL, 0x000fe40007f5e0ffULL,
0x00005f0013137a11ULL, 0x000fe400020f4c1eULL, 0x0000001a75197210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x0000001427517810ULL, 0x000fe40007ffe0ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078848ffULL, 0x00000001511e7824ULL, 0x000fe200078e0226ULL,
0x0000001827537810ULL, 0x000fc40007ffe0ffULL, 0x00005f001b1b7a11ULL, 0x000fe400010f4c2eULL,
0x00005f0019197a11ULL, 0x000fe200020f4c24ULL, 0x0000000153247824ULL, 0x000fe200078e0226ULL,
0x0000001e751f7210ULL, 0x000fe40007f5e0ffULL, 0x000000042d2f7212ULL, 0x000fe400078e3cffULL,
0x0000002475257210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e001f1e7a11ULL, 0x000fc400078448ffULL, 0x0000001c27557810ULL, 0x000fe40007ffe0ffULL,
0xfffffff830337812ULL, 0x000fe400078ee22fULL, 0x00005f001f1f7a11ULL, 0x000fe200010f4c2eULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00000007272f7812ULL, 0x000fe200078e4804ULL,
0x0000000155267824ULL, 0x000fe200078e0226ULL, 0x0000002c2700720cULL, 0x080fe20003fa6070ULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0x0000002c2d00720cULL, 0x000fe20003f86070ULL,
0x000000016a2d7824ULL, 0x000fe200078e020dULL, 0x0ffffff82f2f7812ULL, 0x000fc400078ef804ULL,
0x00005e0025247a11ULL, 0x000fe200078448ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x0000002675277210ULL, 0x000fe40007fde0ffULL, 0x00005f0025257a11ULL, 0x000fe200010f4c2eULL,
0x000000102f2f7824ULL, 0x000fe200078e020cULL, 0x0000000449307212ULL, 0x000fe200078e3cffULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x0000002c4900720cULL, 0x080fe40003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000e901c46ULL,
0x000000ffff2e7224ULL, 0x000fe200030e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078c48ffULL,
0x000000102d127825ULL, 0x000fe200078e0012ULL, 0x000000001c317faeULL, 0x0005e2000d901c46ULL,
0x0000002c4b00720cULL, 0x000fc40003f66070ULL, 0x00005f0027277a11ULL, 0x000fe200030f4c2eULL,
0x0000000012337faeULL, 0x0007e2000e101c46ULL, 0x0000002c5100720cULL, 0x080fe20003f86070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x0000002c5300720cULL, 0x080fe20003fa6070ULL,
0x00000008552f7824ULL, 0x042fe200078e00ffULL, 0x0000002c5500720cULL, 0x000fe20003fc6070ULL,
0x000000102d1a7825ULL, 0x000fe200078e001aULL, 0x000000044b2c7212ULL, 0x080fe400078e3cffULL,
0x00000004512e7212ULL, 0x080fe200078e3cffULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0x0000000453107212ULL, 0x080fe200078e3cffULL, 0x0000000851517824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee230ULL, 0x00000008531d7824ULL, 0x004fe200078e00ffULL,
0x0000000455127212ULL, 0x008fe200078e3cffULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0xfffffff84b117812ULL, 0x000fc400078ee22cULL, 0xfffffff851137812ULL, 0x000fe200078ee22eULL,
0x0000001049497824ULL, 0x000fe200078e020cULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x0000001011117824ULL, 0x000fe200078e020cULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee212ULL,
0x000000102d1e7825ULL, 0x000fe200078e001eULL, 0x000000001a497faeULL, 0x0003e6000d101c46ULL,
0x0000001013137824ULL, 0x000fe200078e020cULL, 0x0000000018117faeULL, 0x0003e2000d901c46ULL,
0x000000102d247825ULL, 0x000fc600078e0024ULL, 0x000000001e137faeULL, 0x0003e2000e101c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e020cULL, 0x000000102d267825ULL, 0x000fc600078e0026ULL,
0x00000000241d7faeULL, 0x0003e2000e901c46ULL, 0x000000102f2f7824ULL, 0x000fca00078e020cULL,
0x00000000262f7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe20000011604ULL, 0x000000016a2d7824ULL, 0x000fc600078e020dULL,
0x0000000413117810ULL, 0x040fe40007ffe0ffULL, 0x0000000813197810ULL, 0x000fe40007ffe0ffULL,
0x0000000411107212ULL, 0x0c0fe200078e3cffULL, 0x0000000811317824ULL, 0x000fe200078e00ffULL,
0x0000000419127212ULL, 0x040fe200078e3cffULL, 0x0000000819337824ULL, 0x000fe200078e00ffULL,
0x0000000c131b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fc400078ee210ULL,
0x0000004002107811ULL, 0x000fe200078e38ffULL, 0x000000081b497824ULL, 0x000fe200078e00ffULL,
0x00000010131d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0xfffffff833337812ULL, 0x000fe200078ee212ULL, 0x0000000113127824ULL, 0x100fe200078e0210ULL,
0x000000041b187212ULL, 0x080fe200078e3cffULL, 0x000000081d4b7824ULL, 0x040fe200078e00ffULL,
0x000000041d1a7212ULL, 0x000fe200078e3cffULL, 0x000000011b1c7824ULL, 0x100fe200078e0210ULL,
0x00000014131f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d267824ULL, 0x000fe200078e0210ULL,
0x0000001813257810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e020cULL,
0x0000001c13277810ULL, 0x000fe20007ffe0ffULL, 0x000000011f2c7824ULL, 0x000fe200078e0210ULL,
0x0000001275127210ULL, 0x000fe20007f5e0ffULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee218ULL, 0x0000000111187824ULL, 0x000fe200078e0210ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee21aULL, 0x00000001191a7824ULL, 0x100fe200078e0210ULL,
0x000000041f197212ULL, 0x080fe200078e3cffULL, 0x00000001252e7824ULL, 0x140fe200078e0210ULL,
0x00000004251b7212ULL, 0x080fe200078e3cffULL, 0x0000000127327824ULL, 0x000fe200078e0210ULL,
0xfffffff81e517812ULL, 0x000fe200078ee219ULL, 0x0000000825247824ULL, 0x000fe200078e00ffULL,
0x00000004271d7212ULL, 0x040fe200078e3cffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x00005e0012107a11ULL, 0x000fe200078448ffULL, 0x0000000827307824ULL, 0x000fe200078e00ffULL,
0xfffffff824557812ULL, 0x000fe200078ee21bULL, 0x0000001049497824ULL, 0x100fe200078e020cULL,
0x00005f0012117a11ULL, 0x000fe200010f4c11ULL, 0x000000104b4b7824ULL, 0x100fe200078e020cULL,
0x0000001875197210ULL, 0x000fe20007f5e0ffULL, 0x0000001051517824ULL, 0x000fe200078e020cULL,
0x0000001c75247210ULL, 0x000fe20007f9e0ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x0000000713137812ULL, 0x000fc400078e4804ULL, 0x0000001a751e7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0xfffffff830597812ULL, 0x000fe200078ee21dULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x0ffffff8131d7812ULL, 0x000fe200078ef804ULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0x00005e00191a7a11ULL, 0x000fe200078448ffULL,
0x0000001055557824ULL, 0x100fe200078e020cULL, 0x00005e0024127a11ULL, 0x000fe200078848ffULL,
0x000000101d2f7824ULL, 0x100fe200078e020cULL, 0x00005e001e187a11ULL, 0x000fe200078648ffULL,
0x0000001059597824ULL, 0x000fe200078e020cULL, 0x00005f00191b7a11ULL, 0x000fc400010f4c1cULL,
0x00005f0024137a11ULL, 0x000fe200020f4c25ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102f7faeULL, 0x0003e2000b901c46ULL, 0x00005f001e197a11ULL, 0x000fe200018f4c1fULL,
0x000000102d1a7825ULL, 0x000fe200078e001aULL, 0x00000026751d7210ULL, 0x040fe40007f9e0ffULL,
0x0000002c751f7210ULL, 0x000fe20007fbe0ffULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x0000002e75307210ULL, 0x040fe20007f5e0ffULL, 0x000000001a317faeULL, 0x0003e2000b901c46ULL,
0x0000003275327210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005e001d267a11ULL, 0x000fe200078848ffULL, 0x000000ffff2e7224ULL, 0x000fe200028e06ffULL,
0x00005e001f247a11ULL, 0x000fe200078a48ffULL, 0x000000ffff537224ULL, 0x000fe200010e06ffULL,
0x00005e00301e7a11ULL, 0x000fe200078448ffULL, 0x000000ffff577224ULL, 0x000fe200018e06ffULL,
0x00005e00321c7a11ULL, 0x000fe200078648ffULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x00005f001d277a11ULL, 0x000fe200020f4c2cULL, 0x0000000018337faeULL, 0x0003e2000b901c46ULL,
0x00005f001f257a11ULL, 0x000fc400028f4c2eULL, 0x00005f00301f7a11ULL, 0x000fe200010f4c53ULL,
0x000000102d267825ULL, 0x040fe200078e0026ULL, 0x00005f00321d7a11ULL, 0x000fe200018f4c57ULL,
0x0000000012497faeULL, 0x0003e4000b901c46ULL, 0x000000102d247825ULL, 0x040fe400078e0024ULL,
0x00000000264b7faeULL, 0x0003e4000b901c46ULL, 0x000000102d1e7825ULL, 0x040fe400078e001eULL,
0x0000000024517faeULL, 0x0003e4000b901c46ULL, 0x000000102d1c7825ULL, 0x000fc400078e001cULL,
0x000000001e557faeULL, 0x0003e8000b901c46ULL, 0x000000001c597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000404107811ULL, 0x002fe400078fe0ffULL,
0x000010000c747810ULL, 0x000fe40007ffe0ffULL, 0x0000000710107812ULL, 0x000fe400078e786dULL,
0x0000005cff11723eULL, 0x000fe200000000ffULL, 0x000000106f6f7824ULL, 0x000fc400078e0274ULL,
0x000000086d727824ULL, 0x000fe200078e0210ULL, 0x0000000604107811ULL, 0x000fe200078fe0ffULL,
0x0000001071717824ULL, 0x100fe400078e0274ULL, 0x000000107b707824ULL, 0x100fe200078e0274ULL,
0x0000a000722c7811ULL, 0x000fe200078e20ffULL, 0x00000010796e7824ULL, 0x100fe200078e0274ULL,
0x0000000710107812ULL, 0x000fe200078e786dULL, 0x0000001069697824ULL, 0x100fe200078e0274ULL,
0x00005410117b7816ULL, 0x000fe20000000011ULL, 0x00000010776c7824ULL, 0x000fc400078e0274ULL,
0x000000086d6d7824ULL, 0x000fe200078e0210ULL, 0x00000002ff107819ULL, 0x000fe20000011604ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x0000a0006d187811ULL, 0x000fe200078e20ffULL, 0x000000106b6b7824ULL, 0x100fe400078e0274ULL,
0x000000006f50783bULL, 0x000fe20000004200ULL, 0x0000001067677824ULL, 0x000fc600078e0274ULL,
0x000000007158783bULL, 0x000fe80000004200ULL, 0x000000007054783bULL, 0x000fe80000004200ULL,
0x000000006e30783bULL, 0x000fe80000004200ULL, 0x00001f107b797589ULL, 0x000e6800000e0000ULL,
0x00001f167b767589ULL, 0x000ea800000e0000ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006c24783bULL, 0x000f680000004200ULL,
0x000000006b1c783bULL, 0x000f280000004200ULL, 0x000000006710783bULL, 0x000f220000004200ULL,
0x000000792c2c9232ULL, 0x002fc40000000000ULL, 0x000000792e2e9232ULL, 0x000fe40000000000ULL,
0x000000762d2d9232ULL, 0x084fe40000000000ULL, 0x000000762f2f9232ULL, 0x000fce0000000000ULL,
0x000000502c4c723cULL, 0x040ff0000000184cULL, 0x000000582c38723cULL, 0x000fe20000001838ULL,
0x0000007918189232ULL, 0x088fe40000000000ULL, 0x000000791a1a9232ULL, 0x000fc40000000000ULL,
0x0000007619199232ULL, 0x000fc60000000000ULL, 0x0000005a2c3c723cULL, 0x000fe2000000183cULL,
0x000000761b1b9232ULL, 0x000fce0000000000ULL, 0x000000542c40723cULL, 0x040ff00000001840ULL,
0x000000562c44723cULL, 0x040ff00000001844ULL, 0x000000522c20723cULL, 0x040ff00000001820ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x000000322c28723cULL, 0x000ff00000001828ULL,
0x00000048184c723cULL, 0x050ff0000000184cULL, 0x000000241838723cULL, 0x060ff00000001838ULL,
0x00000026183c723cULL, 0x040ff0000000183cULL, 0x0000001c1840723cULL, 0x040ff00000001840ULL,
0x0000001e1844723cULL, 0x040ff00000001844ULL, 0x0000004a1848723cULL, 0x040ff00000001820ULL,
0x000000101834723cULL, 0x040ff00000001834ULL, 0x000000121818723cULL, 0x000fe20000001828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000627300720cULL, 0x000fe20003f26070ULL,
0x01468800ffff7f8cULL, 0x000fd8000c80043fULL, 0x0000775000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe20000011604ULL, 0x000000016a297824ULL, 0x000fe200078e020dULL,
0x00000060021c7811ULL, 0x000fe400078e38ffULL, 0x0000002073117810ULL, 0x000fe40007ffe0ffULL,
0x000000041f237810ULL, 0x040fe20007ffe0ffULL, 0x000000011f107824ULL, 0x000fe200078e021cULL,
0x0000001162127217ULL, 0x000fe40007800000ULL, 0x00000004231d7212ULL, 0x040fe200078e3cffULL,
0x0000000823227824ULL, 0x000fe200078e00ffULL, 0x0000001075137210ULL, 0x000fe20007f3e0ffULL,
0x0000000112127824ULL, 0x000fe200078e0a11ULL, 0x000000081f257810ULL, 0x000fc40007ffe0ffULL,
0xfffffff822277812ULL, 0x000fe200078ee21dULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x00005e0013107a11ULL, 0x000fe200078248ffULL, 0x00000008252b7824ULL, 0x000fe200078e00ffULL,
0x0000002012267817ULL, 0x000fe20003800000ULL, 0x0000001027277824ULL, 0x000fe200078e0274ULL,
0x00005f0013117a11ULL, 0x000fe200008f4c1eULL, 0x00000001231e7824ULL, 0x000fe200078e021cULL,
0x000000071f137812ULL, 0x040fe400078e4804ULL, 0x0000000c1f2d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x0ffffff813137812ULL, 0x000fc400078ef804ULL,
0x0000001e751e7210ULL, 0x000fe20007f5e0ffULL, 0x000000082d2f7824ULL, 0x000fe200078e00ffULL,
0x0000000425207212ULL, 0x000fe200078e3cffULL, 0x00000010131d7824ULL, 0x000fe200078e0274ULL,
0x000000261f00720cULL, 0x040fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00005e001e127a11ULL, 0x000fe400078448ffULL, 0x000000101f317810ULL, 0x040fe40007ffe0ffULL,
0x000000141f517810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee220ULL,
0x0000000831247824ULL, 0x000fe200078e00ffULL, 0x00005f001e137a11ULL, 0x000fe200010f4c13ULL,
0x00000001251e7824ULL, 0x000fe200078e021cULL, 0x000000042d207212ULL, 0x080fe200078e3cffULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0x0000000431217212ULL, 0x080fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c901c46ULL,
0x0000000451227212ULL, 0x000fe400078e3cffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee220ULL,
0x000000012d207824ULL, 0x000fe200078e021cULL, 0x000000181f557810ULL, 0x000fc40007ffe0ffULL,
0x0000001c1f597810ULL, 0x000fe40007ffe0ffULL, 0x0000001e751e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000155287824ULL, 0x100fe200078e021cULL, 0xfffffff824337812ULL, 0x000fe200078ee221ULL,
0x0000000151247824ULL, 0x000fe200078e021cULL, 0xfffffff853537812ULL, 0x000fe200078ee222ULL,
0x0000000131227824ULL, 0x100fe200078e021cULL, 0x0000002075207210ULL, 0x000fe20007f7e0ffULL,
0x00000001591c7824ULL, 0x000fe200078e021cULL, 0x00005e001e107a11ULL, 0x002fe200078c48ffULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00000022751f7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e06ffULL, 0x0000002475247210ULL, 0x000fe20007f9e0ffULL,
0x0000000855577824ULL, 0x000fe200078e00ffULL, 0x0000002875217210ULL, 0x000fe20007fbe0ffULL,
0x00000008595b7824ULL, 0x000fe200078e00ffULL, 0x0000001c75757210ULL, 0x000fc40007f5e0ffULL,
0x00005f001e117a11ULL, 0x000fe200030f4c11ULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0x00005e00201c7a11ULL, 0x040fe200078c48ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00000004551e7212ULL, 0x080fe200078e3cffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x0000000459227212ULL, 0x000fe400078e3cffULL, 0x000000262300720cULL, 0x000fe40003f66070ULL,
0x00005f00201d7a11ULL, 0x000fe200030f4c1dULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0xfffffff857577812ULL, 0x000fc400078ee21eULL, 0x00005e001f1e7a11ULL, 0x000fe200078c48ffULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0xfffffff85b5b7812ULL, 0x000fe400078ee222ULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c20ULL, 0x0000001029227825ULL, 0x000fe200078e0012ULL,
0x00005e0024127a11ULL, 0x000fe400078c48ffULL, 0x000000262500720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200020e06ffULL, 0x0000000022277faeULL, 0x0003e2000d901c46ULL,
0x000000262d00720cULL, 0x080fe20003f66070ULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x000000263100720cULL, 0x000fc40003f86070ULL, 0x00005f0024137a11ULL, 0x000fe200030f4c13ULL,
0x00000010572d7824ULL, 0x000fe200078e0274ULL, 0x00005e0021247a11ULL, 0x000fe400078a48ffULL,
0x00005e0075207a11ULL, 0x000fe200078c48ffULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x000000265100720cULL, 0x080fe40003f46070ULL, 0x00005f0021257a11ULL, 0x000fe200028f4c2aULL,
0x000000102b237824ULL, 0x102fe200078e0274ULL, 0x000000265500720cULL, 0x080fe20003fa6070ULL,
0x000000102f277824ULL, 0x000fe200078e0274ULL, 0x00005f0075217a11ULL, 0x000fe200030f4c28ULL,
0x0000001029247825ULL, 0x000fe200078e0024ULL, 0x000000265900720cULL, 0x000fe20003fc6070ULL,
0x0000000010237faeULL, 0x0003e4000c901c46ULL, 0x0000001029207825ULL, 0x000fc400078e0020ULL,
0x000000001c277faeULL, 0x0003e4000d901c46ULL, 0x0000001033297824ULL, 0x100fe400078e0274ULL,
0x00000010532b7824ULL, 0x100fe400078e0274ULL, 0x000000105b2f7824ULL, 0x000fe200078e0274ULL,
0x000000001e297faeULL, 0x0003e8000e101c46ULL, 0x00000000122b7faeULL, 0x0003e8000d101c46ULL,
0x00000000242d7faeULL, 0x0003e8000e901c46ULL, 0x00000000202f7faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x000fe40000011604ULL,
0x00000060021c7811ULL, 0x000fc400078e38ffULL, 0x000000041f137810ULL, 0x040fe40007ffe0ffULL,
0x000000081f217810ULL, 0x000fe40007ffe0ffULL, 0x0000000413107212ULL, 0x0c0fe200078e3cffULL,
0x00000008132d7824ULL, 0x000fe200078e00ffULL, 0x0000000c1f237810ULL, 0x000fe20007ffe0ffULL,
0x00000008211e7824ULL, 0x040fe200078e00ffULL, 0x0000000421117212ULL, 0x000fe400078e3cffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL, 0x000000011f107824ULL, 0x000fe200078e021cULL,
0xfffffff81e2f7812ULL, 0x000fe200078ee211ULL, 0x0000000823317824ULL, 0x000fe200078e00ffULL,
0x000000101f257810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0274ULL,
0x0000001075117210ULL, 0x000fe20007f3e0ffULL, 0x0000000113107824ULL, 0x000fe200078e021cULL,
0x0000000423127212ULL, 0x080fe200078e3cffULL, 0x0000000825247824ULL, 0x040fe200078e00ffULL,
0x0000000425137212ULL, 0x000fe200078e3cffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0xfffffff831317812ULL, 0x000fe200078ee212ULL, 0x000000102f2f7824ULL, 0x000fe200078e0274ULL,
0x00005e0011127a11ULL, 0x000fc400078248ffULL, 0x00000010751d7210ULL, 0x000fe20007f5e0ffULL,
0x0000001031317824ULL, 0x000fe200078e0274ULL, 0xfffffff824337812ULL, 0x000fe400078ee213ULL,
0x00005f0011137a11ULL, 0x000fe200008f4c1eULL, 0x00000001211e7824ULL, 0x000fe200078e021cULL,
0x000000141f277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x00005e001d107a11ULL, 0x000fe200078448ffULL, 0x0000001033337824ULL, 0x000fe200078e0274ULL,
0x0000001e751e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000127247824ULL, 0x000fe200078e021cULL,
0x000000181f297810ULL, 0x000fe20007ffe0ffULL, 0x0000000827517824ULL, 0x040fe200078e00ffULL,
0x0000000427227212ULL, 0x000fc400078e3cffULL, 0x00005f001d117a11ULL, 0x000fe200010f4c20ULL,
0x0000000123207824ULL, 0x000fe200078e021cULL, 0x0000001c1f2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200018e06ffULL, 0x00000024752a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000829247824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee222ULL,
0x0000000125227824ULL, 0x100fe200078e021cULL, 0x0000000429217212ULL, 0x040fe200078e3cffULL,
0x0000000129267824ULL, 0x100fe200078e021cULL, 0x0000002075207210ULL, 0x000fe20007f5e0ffULL,
0x000000012b287824ULL, 0x000fe200078e021cULL, 0x000000071f1f7812ULL, 0x000fe200078e4804ULL,
0x000000082b557824ULL, 0x000fe200078e00ffULL, 0x00005e001e1c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0xfffffff824537812ULL, 0x000fe200078ee221ULL,
0x000000016a297824ULL, 0x000fe200078e020dULL, 0x0000002275257210ULL, 0x000fe20007f3e0ffULL,
0x0000001051517824ULL, 0x000fe200078e0274ULL, 0x0ffffff81f217812ULL, 0x000fe200078ef804ULL,
0x0000001029127825ULL, 0x000fe200078e0012ULL, 0x00005f001e1d7a11ULL, 0x000fc400030f4c1dULL,
0x00000026752c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x00005e00201e7a11ULL, 0x040fe400078448ffULL, 0x0000002875757210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x000000042b227212ULL, 0x000fe200078e3cffULL,
0x00000010212b7824ULL, 0x000fe200078e0274ULL, 0x00005f00201f7a11ULL, 0x000fe200010f4c23ULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078248ffULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0xfffffff855557812ULL, 0x000fe200078ee222ULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00005e002a247a11ULL, 0x000fe200078448ffULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0x00005e002c227a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000122b7faeULL, 0x0003e2000b901c46ULL,
0x00005e0075207a11ULL, 0x000fe200078848ffULL, 0x00000010291e7825ULL, 0x000fe200078e001eULL,
0x00005f0025277a11ULL, 0x000fe200008f4c28ULL, 0x00000000102d7faeULL, 0x0003e2000b901c46ULL,
0x00005f002a257a11ULL, 0x000fe200010f4c21ULL, 0x0000001053537824ULL, 0x000fe200078e0274ULL,
0x00005f002c237a11ULL, 0x000fe200018f4c23ULL, 0x0000001029267825ULL, 0x000fe200078e0026ULL,
0x00005f0075217a11ULL, 0x000fe200020f4c2eULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x000fc400078e0024ULL, 0x000000001e317faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x040fe400078e0022ULL, 0x0000000026337faeULL, 0x0003e4000b901c46ULL,
0x0000001029207825ULL, 0x000fe400078e0020ULL, 0x0000000024517faeULL, 0x0003e4000b901c46ULL,
0x0000001055557824ULL, 0x000fc400078e0274ULL, 0x0000000022537faeULL, 0x0003e8000b901c46ULL,
0x0000000020557faeULL, 0x0003e4000b901c46ULL, 0x00000300ff757624ULL, 0x000fe200078e00ffULL,
0x0000000168107812ULL, 0x002fe200078ec0ffULL, 0xffffffffff667424ULL, 0x000fc600078e00ffULL,
0x000000011000780cULL, 0x000fe40003f25070ULL, 0xffffffff75757811ULL, 0x000fc800078e08ffULL,
0x0000000175757807ULL, 0x000fca0004800000ULL, 0x0000000168687824ULL, 0x000fca00078e0275ULL,
0x000000616800720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000755f107210ULL, 0x000fe20007ffe05eULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610667981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014628006a127f8cULL, 0x000fe8000c80043fULL, 0x01462c006a117984ULL, 0x002e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01462c006a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x014080005d127984ULL, 0x000e680000000800ULL,
0x014280005d137984ULL, 0x0004e20000000800ULL, 0x000000651200720bULL, 0x002fe20003f3d000ULL,
0x000142d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800008e0100ULL,
0x0000ffff101d7812ULL, 0x000fe2000782c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1c7424ULL, 0x000fd600078e00ffULL, 0x0000037000009947ULL, 0x000fea0003800000ULL,
0x000000016300780cULL, 0x000fe40003f25270ULL, 0x000000651200720bULL, 0x000fe20003f54000ULL,
0x000142a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x000fe400010e0100ULL,
0x00000012651c7209ULL, 0x040fe40007810000ULL, 0x0000ffff10107812ULL, 0x000fe400078e3cffULL,
0x00000002ff2f7819ULL, 0x000fe20000011604ULL, 0x8000001c65117221ULL, 0x000fe20000010000ULL,
0x0144801c5d009388ULL, 0x0003e20000000800ULL, 0x000000101dff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x00000011002e7308ULL, 0x000ea40000000800ULL,
0x0000002e60607220ULL, 0x004fe20000410000ULL, 0x000142427f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2e107589ULL, 0x0022a400000e0000ULL, 0x0000001038387220ULL, 0x084fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x000000103c3c7220ULL, 0x080fe20000410000ULL,
0x000000103d3d7220ULL, 0x080fe20000410000ULL, 0x0000001040407220ULL, 0x080fe20000410000ULL,
0x0000001041417220ULL, 0x080fe20000410000ULL, 0x0000001044447220ULL, 0x080fe20000410000ULL,
0x0000001045457220ULL, 0x080fe20000410000ULL, 0x000000104c4c7220ULL, 0x080fe20000410000ULL,
0x000000104d4d7220ULL, 0x080fe20000410000ULL, 0x0000001048487220ULL, 0x080fe20000410000ULL,
0x0000001049497220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fe20000410000ULL, 0x000141827f007947ULL, 0x000fea000b800000ULL,
0x00001f162e107589ULL, 0x00052400000e0000ULL, 0x0000001265657209ULL, 0x000fe20007810000ULL,
0x000000103a3a7220ULL, 0x090fe20000410000ULL, 0x00000001ff1c7807ULL, 0x000fe20000800000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x000000103e3e7220ULL, 0x080fe20000410000ULL,
0x8000006512121221ULL, 0x000fe20000010000ULL, 0x000000103f3f7220ULL, 0x080fe20000410000ULL,
0x0000001042427220ULL, 0x080fe20000410000ULL, 0x0000001043437220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b12121820ULL, 0x000fe20000410000ULL, 0x0000001046467220ULL, 0x080fe20000410000ULL,
0x0000001047477220ULL, 0x080fe20000410000ULL, 0x000000104e4e7220ULL, 0x080fe20000410000ULL,
0x00000012005c1308ULL, 0x000f220000000800ULL, 0x000000104f4f7220ULL, 0x080fe20000410000ULL,
0x000000104a4a7220ULL, 0x080fe20000410000ULL, 0x000000104b4b7220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fe20000410000ULL,
0x000000135c131220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005cff10723eULL, 0x000fe200000000ffULL, 0x0000006013607221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff2f7819ULL, 0x002fe40000011604ULL,
0x00005410102e7816ULL, 0x004fe20000000010ULL, 0x000140127f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2e777589ULL, 0x0002a800000e0000ULL, 0x00001f162e767589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0015ULL,
0x0000564000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x00014a5000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0014ULL,
0x000056a000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000149f000007944ULL, 0x02cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000a8000f2c7811ULL, 0x000fcc00078e20ffULL,
0x000000002c2c783bULL, 0x002e620000000200ULL, 0x0000a80007107811ULL, 0x000fe400078e20ffULL,
0x000099101c1c7816ULL, 0x000fe200000000ffULL, 0x000000000b58783bULL, 0x000f260000004200ULL,
0x000000ff1c00720cULL, 0x000fe20003f25270ULL, 0x000000000950783bULL, 0x000fe80000004200ULL,
0x000000000a54783bULL, 0x000fe80000004200ULL, 0x000000000830783bULL, 0x000fe80000004200ULL,
0x000000001010783bULL, 0x000ee80000000200ULL, 0x000000000628783bULL, 0x004ea80000004200ULL,
0x000000000320783bULL, 0x000ea80000004200ULL, 0x000000000524783bULL, 0x000ea80000004200ULL,
0x00000000001c783bULL, 0x000ea20000004200ULL, 0x000000772c2c9232ULL, 0x002fc40000000000ULL,
0x000000772e2e9232ULL, 0x000fe40000000000ULL, 0x000000762d2d9232ULL, 0x088fe40000000000ULL,
0x000000762f2f9232ULL, 0x000fce0000000000ULL, 0x000000582c38723cULL, 0x010fe20000001838ULL,
0x0000007710109232ULL, 0x000fce0000000000ULL, 0x0000005a2c3c723cULL, 0x040fe2000000183cULL,
0x0000007712129232ULL, 0x000fe40000000000ULL, 0x0000007611119232ULL, 0x080fe40000000000ULL,
0x0000007613139232ULL, 0x000fe20000000000ULL, 0x0000580066767a24ULL, 0x020fe400078e02ffULL,
0x000000502c4c723cULL, 0x000fe4000000184cULL, 0x0000008076767824ULL, 0x000fcc00078e00ffULL,
0x000000542c40723cULL, 0x040ff00000001840ULL, 0x000000562c44723cULL, 0x040ff00000001844ULL,
0x000000522c48723cULL, 0x040ff00000001848ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c18723cULL, 0x000ff00000001818ULL, 0x000000281038723cULL, 0x044ff00000001838ULL,
0x0000002a103c723cULL, 0x040ff0000000183cULL, 0x00000020104c723cULL, 0x040ff0000000184cULL,
0x000000241040723cULL, 0x040ff00000001840ULL, 0x000000261044723cULL, 0x040ff00000001844ULL,
0x000000221020723cULL, 0x040ff00000001848ULL, 0x0000001c1034723cULL, 0x040ff00000001834ULL,
0x0000001e1028723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe40000011604ULL,
0x0000004073117810ULL, 0x000fe40007ffe0ffULL, 0x000000081d257810ULL, 0x040fe20007ffe0ffULL,
0x0000008002277824ULL, 0x000fe200078e021dULL, 0x000000041d197810ULL, 0x000fe40007ffe0ffULL,
0x0000001162107217ULL, 0x000fe20007800000ULL, 0x0000000825187824ULL, 0x040fe200078e00ffULL,
0x0000000425137212ULL, 0x000fe200078e3cffULL, 0x00000008192d7824ULL, 0x000fe200078e00ffULL,
0x0000000c1d2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0xfffffff818497812ULL, 0x000fc400078ee213ULL, 0x000000101d517810ULL, 0x000fe20007ffe0ffULL,
0x000000082f187824ULL, 0x000fe200078e00ffULL, 0x0000000419127212ULL, 0x080fe200078e3cffULL,
0x0000001049497824ULL, 0x000fe200078e020cULL, 0x000000141d557810ULL, 0x000fe20007ffe0ffULL,
0x0000000851537824ULL, 0x000fe200078e00ffULL, 0x000000042f117212ULL, 0x000fe400078e3cffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL, 0x00000008551a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8184b7812ULL, 0x000fc400078ee211ULL, 0x000000181d597810ULL, 0x000fe20007ffe0ffULL,
0x000000102d337824ULL, 0x100fe200078e020cULL, 0x0000001c1d797810ULL, 0x000fe20007ffe0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e020cULL, 0x0000000451127212ULL, 0x000fe200078e3cffULL,
0x0000000859777824ULL, 0x000fe200078e00ffULL, 0x0000007627117210ULL, 0x000fe20007f5e0ffULL,
0x00000008791c7824ULL, 0x000fe200078e00ffULL, 0x0000000455137212ULL, 0x000fe400078e3cffULL,
0xfffffff853537812ULL, 0x000fe200078ee212ULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0xfffffff81a577812ULL, 0x000fc400078ee213ULL, 0x0000000459127212ULL, 0x080fe200078e3cffULL,
0x0000001053537824ULL, 0x100fe200078e020cULL, 0x00000004791b7212ULL, 0x000fe200078e3cffULL,
0x0000001057577824ULL, 0x000fe200078e020cULL, 0x0000000427137810ULL, 0x000fe40007ffe0ffULL,
0x00005e00111a7a11ULL, 0x000fe400078448ffULL, 0xfffffff877777812ULL, 0x000fe400078ee212ULL,
0xfffffff81c7b7812ULL, 0x000fc400078ee21bULL, 0x0000007613127210ULL, 0x080fe20007f7e0ffULL,
0x0000001077777824ULL, 0x000fe200078e020cULL, 0x00005f00111b7a11ULL, 0x000fe200010f4c18ULL,
0x000000107b7b7824ULL, 0x000fe200078e020cULL, 0x0000000827117810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x0000000c27317810ULL, 0x000fe40007ffe0ffULL,
0x0000007611117210ULL, 0x000fe40007f9e0ffULL, 0x00000020102c7817ULL, 0x000fc40003800000ULL,
0x00005e00121e7a11ULL, 0x040fe200078448ffULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x0000007631107210ULL, 0x000fe40007fbe0ffULL, 0x00005f00121f7a11ULL, 0x000fe400010f4c13ULL,
0x00005e0011187a11ULL, 0x000fe200078448ffULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x0000001027317810ULL, 0x000fe40007ffe0ffULL, 0x00005e0010127a11ULL, 0x000fc400078848ffULL,
0x0000002c1900720cULL, 0x000fe40003f66070ULL, 0x00005f0011197a11ULL, 0x000fe400010f4c1cULL,
0x0000007631117210ULL, 0x000fe40007f5e0ffULL, 0x00005f0010137a11ULL, 0x000fe400020f4c13ULL,
0x0000002c1d00720cULL, 0x040fe20003f86070ULL, 0x000000ffff1c7224ULL, 0x000fe200010e06ffULL,
0x000000071d1d7812ULL, 0x000fc400078e4804ULL, 0x0000002c2500720cULL, 0x080fe40003fa6070ULL,
0x00005e0011107a11ULL, 0x000fe400078c48ffULL, 0x0000001427317810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff81d257812ULL, 0x000fe400078ef804ULL, 0x0000002c2f00720cULL, 0x000fe20003f46070ULL,
0x000000016a2f7824ULL, 0x000fe200078e020dULL, 0x00005f0011117a11ULL, 0x000fc400030f4c1cULL,
0x00000076311d7210ULL, 0x000fe20007fde0ffULL, 0x0000001025317824ULL, 0x000fe200078e020cULL,
0x00000018275b7810ULL, 0x000fe20007ffe0ffULL, 0x000000102f247825ULL, 0x000fe200078e001aULL,
0x0000001c272d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200030e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000e101c46ULL,
0x000000102f1e7825ULL, 0x000fe200078e001eULL, 0x000000765b1b7210ULL, 0x080fe40007f9e0ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078c48ffULL, 0x000000102f127825ULL, 0x000fe200078e0012ULL,
0x000000001e337faeULL, 0x0003e2000d901c46ULL, 0x000000762d2d7210ULL, 0x000fe40007f7e0ffULL,
0x00005f001d1d7a11ULL, 0x000fe200030f4c26ULL, 0x000000ffff2e7224ULL, 0x000fe200020e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078c48ffULL, 0x000000102f267825ULL, 0x000fe200078e0018ULL,
0x0000002c5100720cULL, 0x000fc40003f86070ULL, 0x00005f001b1b7a11ULL, 0x000fe200030f4c2eULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002d187a11ULL, 0x000fe200078648ffULL,
0x0000000026497faeULL, 0x0003e2000e901c46ULL, 0x0000002c5500720cULL, 0x080fe20003fc6070ULL,
0x000000102f107825ULL, 0x000fe200078e0010ULL, 0x0000002c5900720cULL, 0x080fe20003fa6070ULL,
0x00000000124b7faeULL, 0x0003e2000d101c46ULL, 0x00005f002d197a11ULL, 0x000fe200018f4c2eULL,
0x000000102f1c7825ULL, 0x000fe200078e001cULL, 0x0000002c7900720cULL, 0x000fe20003f66070ULL,
0x0000000010537faeULL, 0x0003e4000e101c46ULL, 0x000000102f1a7825ULL, 0x000fc800078e001aULL,
0x000000102f187825ULL, 0x000fe200078e0018ULL, 0x000000001c577faeULL, 0x0003e8000f101c46ULL,
0x000000001a777faeULL, 0x0003e8000e901c46ULL, 0x00000000187b7faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff117819ULL, 0x000fe20000011604ULL,
0x000000016a2d7824ULL, 0x000fc600078e020dULL, 0x0000000411137810ULL, 0x040fe40007ffe0ffULL,
0x0000000c111b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000413107212ULL, 0x0c0fe200078e3cffULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0x000000041b137212ULL, 0x040fe200078e3cffULL,
0x000000081b1a7824ULL, 0x000fe200078e00ffULL, 0x00000010111d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000811197810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a497812ULL, 0x000fe200078ee213ULL,
0x000000081d4b7824ULL, 0x000fe200078e00ffULL, 0x0000001411137810ULL, 0x000fe20007ffe0ffULL,
0x0000000819337824ULL, 0x040fe200078e00ffULL, 0x0000000419127212ULL, 0x080fe200078e3cffULL,
0x0000001049497824ULL, 0x000fe200078e020cULL, 0x000000041d187212ULL, 0x000fe200078e3cffULL,
0x0000000813517824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee210ULL,
0x00000080021d7824ULL, 0x000fe200078e0211ULL, 0x0000001c111b7810ULL, 0x000fc40007ffe0ffULL,
0x0000001811197810ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0x0000000413107212ULL, 0x080fe400078e3cffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x000000081b187824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee212ULL,
0x0000000819557824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee210ULL,
0x000000104b4b7824ULL, 0x100fe200078e020cULL, 0x0000000419127212ULL, 0x080fe200078e3cffULL,
0x0000001033337824ULL, 0x100fe200078e020cULL, 0x000000041b137212ULL, 0x000fe200078e3cffULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x000000761d107210ULL, 0x000fc40007f5e0ffULL,
0x000000041d197810ULL, 0x040fe40007ffe0ffULL, 0x000000081d1b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1d1f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818597812ULL, 0x000fe200078ee213ULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff855557812ULL, 0x000fe400078ee212ULL,
0x0000007619197210ULL, 0x080fe20007f7e0ffULL, 0x0000001059597824ULL, 0x100fe200078e020cULL,
0x00005e0010127a11ULL, 0x000fe200078448ffULL, 0x0000001055557824ULL, 0x000fe200078e020cULL,
0x000000761b1e7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000761f247210ULL, 0x000fc40007fbe0ffULL, 0x00005f0010137a11ULL, 0x000fe200010f4c13ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x00005e00191a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x00005e001e187a11ULL, 0x000fe200078648ffULL,
0x000000102d127825ULL, 0x000fe200078e0012ULL, 0x00005e0024107a11ULL, 0x000fe400078848ffULL,
0x00005f00191b7a11ULL, 0x000fe400010f4c1cULL, 0x00000007111f7812ULL, 0x000fc400078e4804ULL,
0x00005f001e197a11ULL, 0x000fe200018f4c25ULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0x00005f0024117a11ULL, 0x000fe400020f4c27ULL, 0x000000101d257810ULL, 0x000fe20007ffe0ffULL,
0x000000102d187825ULL, 0x000fe200078e0018ULL, 0x000000141d277810ULL, 0x040fe40007ffe0ffULL,
0x000000181d537810ULL, 0x000fe20007ffe0ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x0000001c1d577810ULL, 0x000fc40007ffe0ffULL, 0x0000007625257210ULL, 0x080fe40007f9e0ffULL,
0x00000076271d7210ULL, 0x080fe40007fbe0ffULL, 0x0000007653537210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000007657577210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef804ULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005e0025267a11ULL, 0x000fe200078848ffULL,
0x000000ffff327224ULL, 0x000fe200018e06ffULL, 0x00005e001d247a11ULL, 0x000fe200078a48ffULL,
0x000000101f2f7824ULL, 0x000fe200078e020cULL, 0x00005e00531e7a11ULL, 0x000fc400078448ffULL,
0x00005e00571c7a11ULL, 0x000fe400078648ffULL, 0x00005f0025277a11ULL, 0x000fe200020f4c2cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000122f7faeULL, 0x0003e2000b901c46ULL,
0x00005f001d257a11ULL, 0x000fe400028f4c2eULL, 0x00005f00531f7a11ULL, 0x000fe200010f4c30ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x00005f00571d7a11ULL, 0x000fe200018f4c32ULL,
0x000000001a317faeULL, 0x0003e4000b901c46ULL, 0x000000102d247825ULL, 0x000fc400078e0024ULL,
0x0000000018337faeULL, 0x0003e4000b901c46ULL, 0x000000102d1e7825ULL, 0x040fe400078e001eULL,
0x0000000010497faeULL, 0x0003e4000b901c46ULL, 0x000000102d1c7825ULL, 0x000fe400078e001cULL,
0x00000000264b7faeULL, 0x0003e8000b901c46ULL, 0x0000000024517faeULL, 0x0003e8000b901c46ULL,
0x000000001e557faeULL, 0x0003e8000b901c46ULL, 0x000000001c597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000a800722c7811ULL, 0x000fc400078e20ffULL,
0x0000005cff10723eULL, 0x002fe400000000ffULL, 0x00000002ff777819ULL, 0x000fe40000011604ULL,
0x0000541010797816ULL, 0x000fe40000000010ULL, 0x0000a8006d187811ULL, 0x000fc600078e20ffULL,
0x00001f7779777589ULL, 0x000fe800000e0000ULL, 0x00001f1679787589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002c2c783bULL, 0x000e680000000200ULL,
0x000000006f50783bULL, 0x000ea80000004200ULL, 0x000000007158783bULL, 0x000fe80000004200ULL,
0x000000007054783bULL, 0x000fe80000004200ULL, 0x000000006e30783bULL, 0x000fe80000004200ULL,
0x000000001818783bULL, 0x000ee80000000200ULL, 0x000000006948783bULL, 0x000f280000004200ULL,
0x000000006c24783bULL, 0x000f680000004200ULL, 0x000000006b1c783bULL, 0x000f280000004200ULL,
0x000000006710783bULL, 0x000f220000004200ULL, 0x000000772c2c9232ULL, 0x002fc40000000000ULL,
0x000000772e2e9232ULL, 0x000fe40000000000ULL, 0x000000782d2d9232ULL, 0x080fe40000000000ULL,
0x000000782f2f9232ULL, 0x000fce0000000000ULL, 0x000000502c4c723cULL, 0x004fe2000000184cULL,
0x0000007718189232ULL, 0x008fce0000000000ULL, 0x000000582c38723cULL, 0x000fe20000001838ULL,
0x000000771a1a9232ULL, 0x000fe40000000000ULL, 0x0000007819199232ULL, 0x080fe40000000000ULL,
0x000000781b1b9232ULL, 0x000fc60000000000ULL, 0x0000005a2c3c723cULL, 0x040ff0000000183cULL,
0x000000542c40723cULL, 0x040ff00000001840ULL, 0x000000562c44723cULL, 0x040ff00000001844ULL,
0x000000522c20723cULL, 0x040ff00000001820ULL, 0x000000302c34723cULL, 0x040ff00000001834ULL,
0x000000322c28723cULL, 0x000ff00000001828ULL, 0x00000048184c723cULL, 0x050ff0000000184cULL,
0x000000241838723cULL, 0x060ff00000001838ULL, 0x00000026183c723cULL, 0x040ff0000000183cULL,
0x0000001c1840723cULL, 0x040ff00000001840ULL, 0x0000001e1844723cULL, 0x040ff00000001844ULL,
0x0000004a1848723cULL, 0x040ff00000001820ULL, 0x000000101834723cULL, 0x040ff00000001834ULL,
0x000000121818723cULL, 0x000fe20000001828ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004073117810ULL, 0x000fe20007ffe0ffULL, 0x01469000ffff7f8cULL, 0x000fe6000c80043fULL,
0x000000621100720cULL, 0x000fda0003f26070ULL, 0x00004f5000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1d7819ULL, 0x000fe40000011604ULL, 0x0000006073117810ULL, 0x000fe40007ffe0ffULL,
0x000000041d137810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1d2f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001162107217ULL, 0x000fe20007800000ULL, 0x0000000813277824ULL, 0x040fe200078e00ffULL,
0x0000000413127212ULL, 0x000fe200078e3cffULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0x000000081d217810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0xfffffff827277812ULL, 0x000fc400078ee212ULL, 0x000000042f297212ULL, 0x080fe200078e3cffULL,
0x0000000821127824ULL, 0x000fe200078e00ffULL, 0x000000101d337810ULL, 0x000fe40007ffe0ffULL,
0x0000000421117212ULL, 0x080fe400078e3cffULL, 0xfffffff81c297812ULL, 0x000fe200078ee229ULL,
0x00000008331c7824ULL, 0x000fe200078e00ffULL, 0xfffffff812317812ULL, 0x000fe400078ee211ULL,
0x000000141d537810ULL, 0x000fe20007ffe0ffULL, 0x0000001029297824ULL, 0x100fe200078e0274ULL,
0x0000000433117212ULL, 0x000fe200078e3cffULL, 0x0000001031317824ULL, 0x000fe200078e0274ULL,
0x00000020022a7811ULL, 0x000fe200078e38ffULL, 0x0000000853557824ULL, 0x000fe200078e00ffULL,
0xfffffff81c517812ULL, 0x000fc400078ee211ULL, 0x000000181d577810ULL, 0x040fe20007ffe0ffULL,
0x000000011d117824ULL, 0x100fe200078e022aULL, 0x0000000453127212ULL, 0x080fe200078e3cffULL,
0x00000001131f7824ULL, 0x000fe200078e022aULL, 0x0000002010287817ULL, 0x000fe20003800000ULL,
0x00000008575b7824ULL, 0x000fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fe200078ee212ULL,
0x0000000133257824ULL, 0x100fe200078e022aULL, 0x0000000457127212ULL, 0x000fe200078e3cffULL,
0x00000001532b7824ULL, 0x100fe200078e022aULL, 0x0000007611117210ULL, 0x000fe20007f3e0ffULL,
0x0000000157597824ULL, 0x000fe200078e022aULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee212ULL,
0x0000001051517824ULL, 0x100fe200078e0274ULL, 0x000000281300720cULL, 0x000fe20003fa6070ULL,
0x000000ffff127224ULL, 0x000fe200008e06ffULL, 0x00005e0011227a11ULL, 0x000fe200078248ffULL,
0x0000001055557824ULL, 0x100fe200078e0274ULL, 0x0000001c1d777810ULL, 0x000fe20007ffe0ffULL,
0x000000105b5b7824ULL, 0x000fe200078e0274ULL, 0x00005f0011237a11ULL, 0x000fe200008f4c12ULL,
0x0000000121117824ULL, 0x100fe200078e022aULL, 0x000000761f127210ULL, 0x000fe20007f5e0ffULL,
0x000000012f1f7824ULL, 0x000fe200078e022aULL, 0x000000282100720cULL, 0x000fe20003f26070ULL,
0x0000000877797824ULL, 0x000fe200078e00ffULL, 0x0000007611107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e0012207a11ULL, 0x000fc400078448ffULL,
0x00000004771c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e00101e7a11ULL, 0x000fe400078648ffULL, 0x00005f0012217a11ULL, 0x000fe400010f4c13ULL,
0x000000761f137210ULL, 0x080fe40007f9e0ffULL, 0x00005f00101f7a11ULL, 0x000fe400018f4c11ULL,
0x0000007625107210ULL, 0x000fe20007fde0ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0xfffffff879797812ULL, 0x000fc400078ee21cULL, 0x00005e00131c7a11ULL, 0x000fe200078648ffULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x00005e0010127a11ULL, 0x040fe200078848ffULL,
0x0000001079797824ULL, 0x000fe200078e0274ULL, 0x000000281d00720cULL, 0x040fe40003f46070ULL,
0x000000071d257812ULL, 0x000fe400078e4804ULL, 0x00005f00131d7a11ULL, 0x000fe400018f4c24ULL,
0x00005f0010137a11ULL, 0x000fc400020f4c11ULL, 0x000000762b117210ULL, 0x000fe20007f7e0ffULL,
0x000000016a2b7824ULL, 0x000fe200078e020dULL, 0x0ffffff825257812ULL, 0x000fe400078ef804ULL,
0x000000282f00720cULL, 0x000fe20003f86070ULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078648ffULL, 0x00000010252d7824ULL, 0x000fe400078e0274ULL,
0x000000102b247825ULL, 0x000fe200078e0022ULL, 0x00005f0011117a11ULL, 0x000fc400018f4c26ULL,
0x0000007659237210ULL, 0x080fe20007f7e0ffULL, 0x00000001772f7824ULL, 0x000fe200078e022aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000242d7faeULL, 0x0003e2000d101c46ULL,
0x000000102b1e7825ULL, 0x000fe200078e001eULL, 0x00005e0023227a11ULL, 0x000fe400078c48ffULL,
0x000000762f2a7210ULL, 0x000fe20007f5e0ffULL, 0x00000010272f7824ULL, 0x000fe400078e0274ULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x000000283300720cULL, 0x000fe20003f66070ULL,
0x000000102b267825ULL, 0x000fc600078e0020ULL, 0x00005f0023237a11ULL, 0x000fe200030f4c2cULL,
0x000000ffff217224ULL, 0x000fe200010e06ffULL, 0x00005e002a207a11ULL, 0x040fe200078448ffULL,
0x00000000262f7faeULL, 0x0003e2000e901c46ULL, 0x000000285300720cULL, 0x080fe20003fc6070ULL,
0x000000102b1c7825ULL, 0x000fe200078e001cULL, 0x000000285700720cULL, 0x080fe20003fa6070ULL,
0x000000001e317faeULL, 0x0003e2000c901c46ULL, 0x00005f002a217a11ULL, 0x000fe200010f4c21ULL,
0x000000102b127825ULL, 0x000fe200078e0012ULL, 0x000000287700720cULL, 0x000fe20003f46070ULL,
0x000000001c297faeULL, 0x0003e4000e101c46ULL, 0x000000102b107825ULL, 0x000fc400078e0010ULL,
0x0000000012517faeULL, 0x0003e4000d901c46ULL, 0x000000102b227825ULL, 0x040fe400078e0022ULL,
0x0000000010557faeULL, 0x0003e4000f101c46ULL, 0x000000102b207825ULL, 0x000fe400078e0020ULL,
0x00000000225b7faeULL, 0x0003e8000e901c46ULL, 0x0000000020797faeULL, 0x0003e2000d101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fc80000011604ULL,
0x00000004131d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008131f7810ULL, 0x000fe40007ffe0ffULL,
0x000000041d107212ULL, 0x0c0fe200078e3cffULL, 0x000000081d2d7824ULL, 0x000fe200078e00ffULL,
0x000000041f117212ULL, 0x040fe200078e3cffULL, 0x000000081f1e7824ULL, 0x000fe200078e00ffULL,
0x0000000c13217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fc400078ee210ULL,
0x0000002002107811ULL, 0x000fe200078e38ffULL, 0x0000000821317824ULL, 0x000fe200078e00ffULL,
0xfffffff81e2f7812ULL, 0x000fe200078ee211ULL, 0x000000102d2d7824ULL, 0x000fe200078e0274ULL,
0x0000001013237810ULL, 0x040fe20007ffe0ffULL, 0x0000000113117824ULL, 0x100fe200078e0210ULL,
0x0000000421127212ULL, 0x000fe200078e3cffULL, 0x000000011d1d7824ULL, 0x100fe200078e0210ULL,
0x0000001413257810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0210ULL,
0x0000001813297810ULL, 0x000fe20007ffe0ffULL, 0x0000000121217824ULL, 0x100fe200078e0210ULL,
0x0000001c132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123277824ULL, 0x100fe200078e0210ULL,
0x0000007611117210ULL, 0x000fe20007f3e0ffULL, 0x0000000125517824ULL, 0x000fe200078e0210ULL,
0xfffffff831317812ULL, 0x000fe200078ee212ULL, 0x0000000129557824ULL, 0x100fe200078e0210ULL,
0x00000004231c7212ULL, 0x080fe200078e3cffULL, 0x000000012b597824ULL, 0x000fe200078e0210ULL,
0x00000004291e7212ULL, 0x080fe200078e3cffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078248ffULL, 0x0000000823337824ULL, 0x000fe200078e00ffULL,
0x000000042b207212ULL, 0x000fe200078e3cffULL, 0x0000000829577824ULL, 0x000fe200078e00ffULL,
0x00005f0011117a11ULL, 0x000fe200008f4c12ULL, 0x000000082b5b7824ULL, 0x000fe200078e00ffULL,
0x000000761d1d7210ULL, 0x080fe20007f3e0ffULL, 0x0000000825537824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee21cULL, 0x000000016a297824ULL, 0x000fe200078e020dULL,
0x000000761f227210ULL, 0x000fe20007f5e0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0274ULL,
0x00000004251c7212ULL, 0x000fe200078e3cffULL, 0x0000001029107825ULL, 0x000fe200078e0010ULL,
0x0000007621247210ULL, 0x000fc40007f7e0ffULL, 0xfffffff857577812ULL, 0x000fe200078ee21eULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee220ULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0xfffffff853537812ULL, 0x000fe200078ee21cULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005e001d207a11ULL, 0x000fe200078248ffULL,
0x0000001031317824ULL, 0x000fe200078e0274ULL, 0x0000000713137812ULL, 0x000fe200078e4804ULL,
0x0000001033337824ULL, 0x100fe200078e0274ULL, 0x00005e00221c7a11ULL, 0x000fe200078448ffULL,
0x0000001053537824ULL, 0x100fe200078e0274ULL, 0x00005e0024127a11ULL, 0x000fe200078648ffULL,
0x0000001057577824ULL, 0x000fe200078e0274ULL, 0x00005f001d217a11ULL, 0x000fe200008f4c1eULL,
0x000000105b5b7824ULL, 0x000fe200078e0274ULL, 0x0ffffff8131f7812ULL, 0x000fc400078ef804ULL,
0x00005f00221d7a11ULL, 0x000fe200010f4c23ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x00005f0024137a11ULL, 0x000fe400018f4c25ULL, 0x0000007627277210ULL, 0x080fe20007f5e0ffULL,
0x000000101f2b7824ULL, 0x000fe200078e0274ULL, 0x0000007651517210ULL, 0x080fe20007f7e0ffULL,
0x00000010291c7825ULL, 0x000fe200078e001cULL, 0x0000007655557210ULL, 0x080fe40007f9e0ffULL,
0x0000007659597210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e0027267a11ULL, 0x000fe200078448ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e0051247a11ULL, 0x000fe200078648ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x00005e0055227a11ULL, 0x000fe200078848ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e00591e7a11ULL, 0x000fe200078248ffULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x00005f0027277a11ULL, 0x000fe200010f4c28ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000b901c46ULL, 0x00005f0051257a11ULL, 0x000fc400018f4c2aULL,
0x00005f0055237a11ULL, 0x000fe200020f4c2cULL, 0x0000001029267825ULL, 0x000fe200078e0026ULL,
0x00005f00591f7a11ULL, 0x000fe200008f4c2eULL, 0x00000000202d7faeULL, 0x0003e4000b901c46ULL,
0x0000001029247825ULL, 0x040fe400078e0024ULL, 0x000000001c2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029227825ULL, 0x040fe400078e0022ULL, 0x0000000012317faeULL, 0x0003e4000b901c46ULL,
0x00000010291e7825ULL, 0x000fc400078e001eULL, 0x0000000026337faeULL, 0x0003e8000b901c46ULL,
0x0000000024537faeULL, 0x0003e8000b901c46ULL, 0x0000000022577faeULL, 0x0003e8000b901c46ULL,
0x000000001e5b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x014648006a127f8cULL, 0x002fe8000c80043fULL,
0x01464c006a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007824813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x0000001000117305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x000000110000735dULL, 0x004fe40003800000ULL, 0x01464c006a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007824813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x014100005d127984ULL, 0x000e680000000800ULL, 0x014300005d137984ULL, 0x0004e20000000800ULL,
0x000000651200720bULL, 0x002fe20003f3d000ULL, 0x00011dd27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800008e0100ULL, 0x0000ffff101d7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1c7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000026300780cULL, 0x000fe40003f25270ULL,
0x000000651200720bULL, 0x000fe20003f54000ULL, 0x00011da27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x000fe400010e0100ULL, 0x00000012651c7209ULL, 0x040fe40007810000ULL,
0x0000ffff10107812ULL, 0x000fe400078e3cffULL, 0x00000002ff2f7819ULL, 0x000fe20000011604ULL,
0x8000001c65117221ULL, 0x000fe20000010000ULL, 0x0145001c5d009388ULL, 0x0003e20000000800ULL,
0x000000101dff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL,
0x00000011002e7308ULL, 0x000ea40000000800ULL, 0x0000002e60607220ULL, 0x004fe20000410000ULL,
0x00011d427f007947ULL, 0x000fea000b800000ULL, 0x00001f2f2e107589ULL, 0x0022a400000e0000ULL,
0x0000001038387220ULL, 0x084fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x000000103c3c7220ULL, 0x080fe20000410000ULL, 0x000000103d3d7220ULL, 0x080fe20000410000ULL,
0x0000001040407220ULL, 0x080fe20000410000ULL, 0x0000001041417220ULL, 0x080fe20000410000ULL,
0x0000001044447220ULL, 0x080fe20000410000ULL, 0x0000001045457220ULL, 0x080fe20000410000ULL,
0x000000104c4c7220ULL, 0x080fe20000410000ULL, 0x000000104d4d7220ULL, 0x080fe20000410000ULL,
0x0000001048487220ULL, 0x080fe20000410000ULL, 0x0000001049497220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fe20000410000ULL,
0x00011c827f007947ULL, 0x000fea000b800000ULL, 0x00001f162e107589ULL, 0x00052400000e0000ULL,
0x0000001265657209ULL, 0x000fe20007810000ULL, 0x000000103a3a7220ULL, 0x090fe20000410000ULL,
0x00000001ff1c7807ULL, 0x000fe20000800000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000103e3e7220ULL, 0x080fe20000410000ULL, 0x8000006512121221ULL, 0x000fe20000010000ULL,
0x000000103f3f7220ULL, 0x080fe20000410000ULL, 0x0000001042427220ULL, 0x080fe20000410000ULL,
0x0000001043437220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b12121820ULL, 0x000fe20000410000ULL,
0x0000001046467220ULL, 0x080fe20000410000ULL, 0x0000001047477220ULL, 0x080fe20000410000ULL,
0x000000104e4e7220ULL, 0x080fe20000410000ULL, 0x00000012005c1308ULL, 0x000f220000000800ULL,
0x000000104f4f7220ULL, 0x080fe20000410000ULL, 0x000000104a4a7220ULL, 0x080fe20000410000ULL,
0x000000104b4b7220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fe20000410000ULL, 0x000000135c131220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005cff10723eULL, 0x000fe200000000ffULL,
0x0000006013607221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2f7819ULL, 0x002fe40000011604ULL, 0x00005410102e7816ULL, 0x004fe20000000010ULL,
0x00011b127f007947ULL, 0x000fea000b800000ULL, 0x00001f2f2e777589ULL, 0x0002a800000e0000ULL,
0x00001f162e787589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2f7224ULL, 0x002fe200078e0015ULL, 0x00007d7000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0001232000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff2f7224ULL, 0x002fe200078e0014ULL, 0x00007dd000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000122c000007944ULL, 0x00cfea0003c00000ULL, 0x0000b0000f2c7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b58783bULL, 0x000fe20000004200ULL,
0x0000b00007107811ULL, 0x000fe400078e20ffULL, 0x000099101c1c7816ULL, 0x000fe200000000ffULL,
0x000000002c2c783bULL, 0x002e660000000200ULL, 0x000000ff1c00720cULL, 0x000fe20003f25270ULL,
0x000000000950783bULL, 0x000fe80000004200ULL, 0x000000000a54783bULL, 0x000fe80000004200ULL,
0x000000000830783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x000f280000000200ULL,
0x000000000628783bULL, 0x004ea80000004200ULL, 0x000000000320783bULL, 0x000f680000004200ULL,
0x000000000524783bULL, 0x000ee80000004200ULL, 0x00000000001c783bULL, 0x000ea20000004200ULL,
0x000000772c2c9232ULL, 0x002fc40000000000ULL, 0x000000772e2e9232ULL, 0x000fe40000000000ULL,
0x000000782d2d9232ULL, 0x088fe40000000000ULL, 0x000000782f2f9232ULL, 0x000fce0000000000ULL,
0x000000582c38723cULL, 0x000fe20000001838ULL, 0x0000007710109232ULL, 0x090fe40000000000ULL,
0x0000007712129232ULL, 0x000fe40000000000ULL, 0x0000007811119232ULL, 0x000fc60000000000ULL,
0x0000005a2c3c723cULL, 0x000fe2000000183cULL, 0x0000007813139232ULL, 0x000fce0000000000ULL,
0x000000502c4c723cULL, 0x040ff0000000184cULL, 0x000000542c40723cULL, 0x040ff00000001840ULL,
0x000000562c44723cULL, 0x040ff00000001844ULL, 0x000000522c48723cULL, 0x040ff00000001848ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x000000322c18723cULL, 0x000ff00000001818ULL,
0x000000281038723cULL, 0x044ff00000001838ULL, 0x0000002a103c723cULL, 0x040ff0000000183cULL,
0x00000020104c723cULL, 0x060ff0000000184cULL, 0x000000241040723cULL, 0x040ff00000001840ULL,
0x000000261044723cULL, 0x040ff00000001844ULL, 0x000000221020723cULL, 0x040ff00000001848ULL,
0x0000001c1034723cULL, 0x040ff00000001834ULL, 0x0000001e1028723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff257819ULL, 0x000fe40000011604ULL, 0x0000008073117810ULL, 0x000fe40007ffe0ffULL,
0x0000000425197810ULL, 0x040fe40007ffe0ffULL, 0x0000001162107217ULL, 0x000fe40007800000ULL,
0x00000010254b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0x0000001425537810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a11ULL,
0x0000000419127212ULL, 0x080fe200078e3cffULL, 0x000000084b1a7824ULL, 0x000fe200078e00ffULL,
0x00000040022e7811ULL, 0x000fe200078e38ffULL, 0x0000000853557824ULL, 0x000fe200078e00ffULL,
0x000000044b117212ULL, 0x000fc400078e3cffULL, 0x00000008252f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff827277812ULL, 0x000fe400078ee212ULL, 0xfffffff81a517812ULL, 0x000fe200078ee211ULL,
0x0000000125117824ULL, 0x000fe200078e022eULL, 0x0000000453127212ULL, 0x080fe200078e3cffULL,
0x000000082f187824ULL, 0x040fe200078e00ffULL, 0x000000042f137212ULL, 0x000fe200078e3cffULL,
0x0000001027337824ULL, 0x000fe200078e020cULL, 0xfffffff855557812ULL, 0x000fe200078ee212ULL,
0x0000001051517824ULL, 0x000fe200078e020cULL, 0x0000007611127210ULL, 0x080fe20007f5e0ffULL,
0x0000000119117824ULL, 0x000fe200078e022eULL, 0xfffffff818497812ULL, 0x000fe200078ee213ULL,
0x0000001055557824ULL, 0x100fe200078e020cULL, 0x0000000c25317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00005e00121c7a11ULL, 0x040fe200078448ffULL,
0x0000001049497824ULL, 0x000fe200078e020cULL, 0x0000007611117210ULL, 0x000fe20007f7e0ffULL,
0x0000000831187824ULL, 0x000fe200078e00ffULL, 0x00005f00121d7a11ULL, 0x000fe200010f4c13ULL,
0x000000012f137824ULL, 0x100fe200078e022eULL, 0x0000001c25777810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200018e06ffULL, 0x0000001825577810ULL, 0x000fe20007ffe0ffULL,
0x00000001311b7824ULL, 0x100fe200078e022eULL, 0x00005e00111e7a11ULL, 0x000fe200078448ffULL,
0x0000000877797824ULL, 0x000fe200078e00ffULL, 0x00000004312d7212ULL, 0x000fe200078e3cffULL,
0x00000008575b7824ULL, 0x040fe200078e00ffULL, 0x00000020102c7817ULL, 0x000fe20003800000ULL,
0x0000000157597824ULL, 0x100fe200078e022eULL, 0x0000007613107210ULL, 0x000fe20007f9e0ffULL,
0x0000000177277824ULL, 0x040fe200078e022eULL, 0x00000004771a7212ULL, 0x000fc400078e3cffULL,
0x00005f00111f7a11ULL, 0x000fe200010f4c12ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0xfffffff8182d7812ULL, 0x000fe400078ee22dULL, 0x000000761b117210ULL, 0x000fe40007fbe0ffULL,
0x0000000457187212ULL, 0x000fe200078e3cffULL, 0x000000102d2d7824ULL, 0x000fe200078e020cULL,
0xfffffff879797812ULL, 0x000fe200078ee21aULL, 0x000000ffff127224ULL, 0x000fe200028e06ffULL,
0x0000002c1900720cULL, 0x000fe20003f66070ULL, 0x000000014b197824ULL, 0x000fe200078e022eULL,
0x00005e00101a7a11ULL, 0x000fe200078448ffULL, 0x0000001079797824ULL, 0x000fe200078e020cULL,
0xfffffff85b5b7812ULL, 0x000fc400078ee218ULL, 0x00005e0011187a11ULL, 0x000fe400078848ffULL,
0x00005f00101b7a11ULL, 0x000fe200010f4c13ULL, 0x000000105b5b7824ULL, 0x000fe200078e020cULL,
0x0000007619107210ULL, 0x000fe40007f5e0ffULL, 0x00005f0011197a11ULL, 0x000fe400020f4c12ULL,
0x0000002c2500720cULL, 0x040fe20003f86070ULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x0000000725257812ULL, 0x000fc400078e4804ULL, 0x0000002c3100720cULL, 0x080fe20003f46070ULL,
0x0000000153317824ULL, 0x000fe200078e022eULL, 0x00005e0010127a11ULL, 0x000fe400078c48ffULL,
0x0ffffff825257812ULL, 0x000fe400078ef804ULL, 0x0000002c2f00720cULL, 0x000fe20003fa6070ULL,
0x000000016a2f7824ULL, 0x000fe200078e020dULL, 0x00005f0010137a11ULL, 0x000fe400030f4c11ULL,
0x0000007631117210ULL, 0x000fe20007fde0ffULL, 0x0000001025317824ULL, 0x000fc400078e020cULL,
0x000000102f247825ULL, 0x000fc800078e001cULL, 0x000000102f1e7825ULL, 0x000fe200078e001eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024317faeULL, 0x0003e2000e101c46ULL,
0x00000076591d7210ULL, 0x080fe40007f9e0ffULL, 0x000000ffff267224ULL, 0x000fe200030e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078c48ffULL, 0x000000001e337faeULL, 0x0003e2000d901c46ULL,
0x00000076272e7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff307224ULL, 0x000fe200020e06ffULL,
0x00005f0011117a11ULL, 0x000fe200030f4c26ULL, 0x000000102f267825ULL, 0x000fe200078e001aULL,
0x00005e001d1c7a11ULL, 0x000fc400078c48ffULL, 0x0000002c4b00720cULL, 0x080fe20003f86070ULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x00005e002e1a7a11ULL, 0x040fe200078648ffULL,
0x0000000026497faeULL, 0x0003e2000e901c46ULL, 0x00005f001d1d7a11ULL, 0x000fe200030f4c30ULL,
0x000000102f187825ULL, 0x000fe200078e0018ULL, 0x0000002c5300720cULL, 0x080fe40003fc6070ULL,
0x0000002c5700720cULL, 0x080fe20003fa6070ULL, 0x000000102f127825ULL, 0x000fe200078e0012ULL,
0x00005f002e1b7a11ULL, 0x000fe200018f4c1bULL, 0x00000000182d7faeULL, 0x0003e2000d101c46ULL,
0x0000002c7700720cULL, 0x000fe20003f66070ULL, 0x000000102f107825ULL, 0x000fc400078e0010ULL,
0x0000000012517faeULL, 0x0003e4000e101c46ULL, 0x000000102f1c7825ULL, 0x040fe400078e001cULL,
0x0000000010557faeULL, 0x0003e4000f101c46ULL, 0x000000102f1a7825ULL, 0x000fe400078e001aULL,
0x000000001c5b7faeULL, 0x0003e8000e901c46ULL, 0x000000001a797faeULL, 0x0003e2000d901c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x000fc80000011604ULL,
0x0000000413197810ULL, 0x040fe40007ffe0ffULL, 0x00000008131b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000419107212ULL, 0x0c0fe200078e3cffULL, 0x0000000819317824ULL, 0x000fe200078e00ffULL,
0x000000041b117212ULL, 0x040fe200078e3cffULL, 0x000000081b1a7824ULL, 0x000fe200078e00ffULL,
0x0000000c131d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fc400078ee210ULL,
0x0000004002107811ULL, 0x000fe200078e38ffULL, 0x000000081d497824ULL, 0x000fe200078e00ffULL,
0xfffffff81a337812ULL, 0x000fe200078ee211ULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0x00000010131f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000113117824ULL, 0x100fe200078e0210ULL,
0x000000041d127212ULL, 0x040fe200078e3cffULL, 0x000000011d1d7824ULL, 0x100fe200078e0210ULL,
0x0000001413257810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x100fe200078e0210ULL,
0x00000018132d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x100fe200078e0210ULL,
0x0000001c132f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f277824ULL, 0x100fe200078e0210ULL,
0x0000007611117210ULL, 0x000fe20007f5e0ffULL, 0x0000000125517824ULL, 0x000fe200078e0210ULL,
0xfffffff849497812ULL, 0x000fe200078ee212ULL, 0x000000012d557824ULL, 0x100fe200078e0210ULL,
0x000000041f187212ULL, 0x000fe200078e3cffULL, 0x000000012f597824ULL, 0x000fe200078e0210ULL,
0x000000761d247210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078448ffULL, 0x000000081f4b7824ULL, 0x000fe200078e00ffULL,
0x000000042d1a7212ULL, 0x040fe200078e3cffULL, 0x000000082d577824ULL, 0x000fe200078e00ffULL,
0x00005f0011117a11ULL, 0x000fe200010f4c12ULL, 0x000000082f5b7824ULL, 0x000fe200078e00ffULL,
0x0000007619197210ULL, 0x000fe20007f5e0ffULL, 0x0000000825537824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL, 0x000000016a2d7824ULL, 0x000fe200078e020dULL,
0x000000042f1c7212ULL, 0x000fe200078e3cffULL, 0x0000001033337824ULL, 0x000fe200078e020cULL,
0x000000761b1e7210ULL, 0x000fe20007f7e0ffULL, 0x000000102d107825ULL, 0x000fe200078e0010ULL,
0x0000000425187212ULL, 0x000fc400078e3cffULL, 0x0000000713137812ULL, 0x000fe200078e4804ULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0xfffffff857577812ULL, 0x000fe200078ee21aULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x00005e0024127a11ULL, 0x000fe200078848ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee21cULL,
0x0000001049497824ULL, 0x000fe200078e020cULL, 0xfffffff853537812ULL, 0x000fe200078ee218ULL,
0x000000104b4b7824ULL, 0x100fe200078e020cULL, 0x00005e00191c7a11ULL, 0x000fe200078448ffULL,
0x0000001057577824ULL, 0x100fe200078e020cULL, 0x00005e001e187a11ULL, 0x000fe200078648ffULL,
0x0000001053537824ULL, 0x000fe200078e020cULL, 0x0ffffff8131b7812ULL, 0x000fe200078ef804ULL,
0x000000105b5b7824ULL, 0x000fe200078e020cULL, 0x00005f0024137a11ULL, 0x000fc400020f4c25ULL,
0x0000007627277210ULL, 0x080fe20007f9e0ffULL, 0x000000101b2f7824ULL, 0x000fe200078e020cULL,
0x00005f00191d7a11ULL, 0x000fe200010f4c1aULL, 0x000000102d127825ULL, 0x000fe200078e0012ULL,
0x0000007651517210ULL, 0x080fe40007fbe0ffULL, 0x00005f001e197a11ULL, 0x000fe200018f4c1fULL,
0x000000ffff2c7224ULL, 0x000fe200020e06ffULL, 0x0000007655557210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x0000007659597210ULL, 0x000fe20007f7e0ffULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0x00005e0027267a11ULL, 0x000fe200078848ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000102f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0051247a11ULL, 0x000fe200078a48ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e00551e7a11ULL, 0x000fe200078448ffULL, 0x000000ffff327224ULL, 0x000fe200018e06ffULL,
0x00005e00591a7a11ULL, 0x000fe200078648ffULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x00005f0027277a11ULL, 0x000fe200020f4c2cULL, 0x000000001c317faeULL, 0x0003e2000b901c46ULL,
0x00005f0051257a11ULL, 0x000fc400028f4c2eULL, 0x00005f00551f7a11ULL, 0x000fe200010f4c30ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x00005f00591b7a11ULL, 0x000fe200018f4c32ULL,
0x0000000018337faeULL, 0x0003e4000b901c46ULL, 0x000000102d247825ULL, 0x040fe400078e0024ULL,
0x0000000012497faeULL, 0x0003e4000b901c46ULL, 0x000000102d1e7825ULL, 0x040fe400078e001eULL,
0x00000000264b7faeULL, 0x0003e4000b901c46ULL, 0x000000102d1a7825ULL, 0x000fc400078e001aULL,
0x0000000024537faeULL, 0x0003e8000b901c46ULL, 0x000000001e577faeULL, 0x0003e8000b901c46ULL,
0x000000001a5b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b000722c7811ULL, 0x000fe400078e20ffULL, 0x0000005cff10723eULL, 0x002fc400000000ffULL,
0x00000002ff777819ULL, 0x000fe40000011604ULL, 0x0000541010797816ULL, 0x000fe40000000010ULL,
0x0000b0006d187811ULL, 0x000fc600078e20ffULL, 0x00001f7779777589ULL, 0x000fe800000e0000ULL,
0x00001f1679787589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002c2c783bULL, 0x000e680000000200ULL, 0x000000006f50783bULL, 0x000ea80000004200ULL,
0x000000007158783bULL, 0x000fe80000004200ULL, 0x000000007054783bULL, 0x000fe80000004200ULL,
0x000000006e30783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006c24783bULL, 0x000f680000004200ULL,
0x000000006b1c783bULL, 0x000f280000004200ULL, 0x000000006710783bULL, 0x000f220000004200ULL,
0x000000772c2c9232ULL, 0x002fc40000000000ULL, 0x000000772e2e9232ULL, 0x000fe40000000000ULL,
0x000000782d2d9232ULL, 0x080fe40000000000ULL, 0x000000782f2f9232ULL, 0x000fce0000000000ULL,
0x000000502c4c723cULL, 0x004fe2000000184cULL, 0x0000007718189232ULL, 0x008fce0000000000ULL,
0x000000582c38723cULL, 0x000fe20000001838ULL, 0x000000771a1a9232ULL, 0x000fe40000000000ULL,
0x0000007819199232ULL, 0x080fe40000000000ULL, 0x000000781b1b9232ULL, 0x000fc60000000000ULL,
0x0000005a2c3c723cULL, 0x040ff0000000183cULL, 0x000000542c40723cULL, 0x040ff00000001840ULL,
0x000000562c44723cULL, 0x040ff00000001844ULL, 0x000000522c20723cULL, 0x040ff00000001820ULL,
0x000000302c34723cULL, 0x040ff00000001834ULL, 0x000000322c28723cULL, 0x000ff00000001828ULL,
0x00000048184c723cULL, 0x050ff0000000184cULL, 0x000000241838723cULL, 0x060ff00000001838ULL,
0x00000026183c723cULL, 0x040ff0000000183cULL, 0x0000001c1840723cULL, 0x040ff00000001840ULL,
0x0000001e1844723cULL, 0x040ff00000001844ULL, 0x0000004a1848723cULL, 0x040ff00000001820ULL,
0x000000101834723cULL, 0x040ff00000001834ULL, 0x000000121818723cULL, 0x000fe20000001828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008073117810ULL, 0x000fe20007ffe0ffULL,
0x01469800ffff7f8cULL, 0x000fe6000c80043fULL, 0x000000621100720cULL, 0x000fda0003f26070ULL,
0x0000282000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000003ff237819ULL, 0x000fe40000011604ULL,
0x000000a073737810ULL, 0x000fe40007ffe0ffULL, 0x00000008232f7810ULL, 0x000fe40007ffe0ffULL,
0x0000007362107217ULL, 0x000fe40007800000ULL, 0x0000006002207811ULL, 0x000fe200078e38ffULL,
0x000000082f1c7824ULL, 0x000fe200078e00ffULL, 0x0000000423297810ULL, 0x000fe20007ffe0ffULL,
0x0000000110737824ULL, 0x000fe200078e0a73ULL, 0x000000042f117212ULL, 0x080fe200078e3cffULL,
0x0000000123137824ULL, 0x140fe200078e0220ULL, 0x0000000c23337810ULL, 0x000fe20007ffe0ffULL,
0x00000008292d7824ULL, 0x040fe200078e00ffULL, 0xfffffff81c317812ULL, 0x000fe200078ee211ULL,
0x0000000129117824ULL, 0x040fe200078e0220ULL, 0x0000000429107212ULL, 0x000fe200078e3cffULL,
0x0000000833517824ULL, 0x000fe200078e00ffULL, 0x0000001023537810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e0274ULL, 0xfffffff82d2d7812ULL, 0x000fc400078ee210ULL,
0x0000007613137210ULL, 0x080fe20007f1e0ffULL, 0x0000000853227824ULL, 0x000fe200078e00ffULL,
0x0000007611107210ULL, 0x000fe20007f3e0ffULL, 0x0000000153217824ULL, 0x000fe200078e0220ULL,
0x0000000433127212ULL, 0x080fe200078e3cffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x00000004531d7212ULL, 0x000fe200078e3cffULL, 0x000000ffff117224ULL, 0x000fe200008e06ffULL,
0xfffffff851517812ULL, 0x000fe200078ee212ULL, 0x000000102d2d7824ULL, 0x000fe200078e0274ULL,
0x0000001423577810ULL, 0x000fc40007ffe0ffULL, 0x00005e00131c7a11ULL, 0x000fe200078048ffULL,
0x0000001051517824ULL, 0x000fe200078e0274ULL, 0x00005e0010127a11ULL, 0x000fe200078248ffULL,
0x0000000857247824ULL, 0x040fe200078e00ffULL, 0xfffffff822557812ULL, 0x000fe200078ee21dULL,
0x0000000157257824ULL, 0x000fe200078e0220ULL, 0x00005f00131d7a11ULL, 0x000fe400000f4c1eULL,
0x00005f0010137a11ULL, 0x000fe200008f4c11ULL, 0x000000012f117824ULL, 0x000fe200078e0220ULL,
0x00000004571f7212ULL, 0x000fe200078e3cffULL, 0x0000001055557824ULL, 0x000fe200078e0274ULL,
0x00000018235b7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff824597812ULL, 0x000fe200078ee21fULL,
0x00000001331f7824ULL, 0x100fe200078e0220ULL, 0x0000001c23797810ULL, 0x000fe20007ffe0ffULL,
0x000000015b277824ULL, 0x100fe200078e0220ULL, 0x0000007611117210ULL, 0x080fe20007f1e0ffULL,
0x000000085b777824ULL, 0x000fe200078e00ffULL, 0x000000761f1f7210ULL, 0x000fe20007f7e0ffULL,
0x00000001792b7824ULL, 0x000fe200078e0220ULL, 0x000000045b207212ULL, 0x000fe200078e3cffULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078048ffULL,
0x00000008797b7824ULL, 0x000fe200078e00ffULL, 0x0000007625227210ULL, 0x080fe20007f9e0ffULL,
0x0000001059597824ULL, 0x000fe200078e0274ULL, 0x0000007627257210ULL, 0x000fc40007fbe0ffULL,
0xfffffff877777812ULL, 0x000fe200078ee220ULL, 0x000000ffff207224ULL, 0x000fe200018e06ffULL,
0x0000002073737817ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x0000000723277812ULL, 0x000fe200078e4804ULL, 0x0000001077777824ULL, 0x000fe200078e0274ULL,
0x0000000479247212ULL, 0x000fe400078e3cffULL, 0x0000007621217210ULL, 0x000fe40007f3e0ffULL,
0x00005f0011117a11ULL, 0x000fc400000f4c1eULL, 0x00005e001f1e7a11ULL, 0x000fe400078c48ffULL,
0x000000732300720cULL, 0x080fe40003f66070ULL, 0x0ffffff827277812ULL, 0x000fe400078ef804ULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee224ULL, 0x000000ffff247224ULL, 0x000fe200008e06ffULL,
0x000000732900720cULL, 0x000fe20003f06070ULL, 0x000000016a297824ULL, 0x000fe200078e020dULL,
0x00005f001f1f7a11ULL, 0x000fe200030f4c20ULL, 0x000000107b7b7824ULL, 0x000fe200078e0274ULL,
0x00005e0021207a11ULL, 0x000fe200078c48ffULL, 0x0000001029127825ULL, 0x000fe200078e0012ULL,
0x000000762b767210ULL, 0x000fc40007f5e0ffULL, 0x00005f0021217a11ULL, 0x000fe200030f4c24ULL,
0x00000010272b7824ULL, 0x000fe200078e0274ULL, 0x00005e0025247a11ULL, 0x000fe200078a48ffULL,
0x0000001029267825ULL, 0x000fe200078e001cULL, 0x00005e00221c7a11ULL, 0x040fe400078c48ffULL,
0x000000732f00720cULL, 0x080fe20003f26070ULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000262b7faeULL, 0x0003e2000d901c46ULL,
0x000000ffff237224ULL, 0x000fe200010e06ffULL, 0x000000733300720cULL, 0x080fe20003f66070ULL,
0x0000001029107825ULL, 0x040fe200078e0010ULL, 0x00005f00221d7a11ULL, 0x000fe200030f4c1dULL,
0x00000000122d7faeULL, 0x0003e2000c101c46ULL, 0x00005e0076227a11ULL, 0x000fe200078c48ffULL,
0x00000010291e7825ULL, 0x000fe200078e001eULL, 0x000000735300720cULL, 0x000fc40003f86070ULL,
0x000000735700720cULL, 0x080fe20003f46070ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x00005f0025257a11ULL, 0x000fe200028f4c28ULL, 0x0000000010317faeULL, 0x0003e2000c901c46ULL,
0x000000735b00720cULL, 0x080fe20003fa6070ULL, 0x00000010291c7825ULL, 0x000fe200078e001cULL,
0x00005f0076237a11ULL, 0x000fe200030f4c23ULL, 0x000000001e517faeULL, 0x0003e2000d901c46ULL,
0x000000737900720cULL, 0x000fe20003fc6070ULL, 0x0000001029247825ULL, 0x040fe400078e0024ULL,
0x0000000020557faeULL, 0x0003e4000e101c46ULL, 0x0000001029227825ULL, 0x000fc400078e0022ULL,
0x000000001c597faeULL, 0x0003e8000d101c46ULL, 0x0000000024777faeULL, 0x0003e8000e901c46ULL,
0x00000000227b7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff137819ULL, 0x000fe40000011604ULL, 0x0000006002127811ULL, 0x000fc400078e38ffULL,
0x00000008131f7810ULL, 0x040fe40007ffe0ffULL, 0x00000004131d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113117824ULL, 0x100fe200078e0212ULL, 0x000000041f1c7212ULL, 0x0c0fe200078e3cffULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0x000000041d107212ULL, 0x040fe200078e3cffULL,
0x000000081d217824ULL, 0x000fe200078e00ffULL, 0x0000007611117210ULL, 0x000fe20007f1e0ffULL,
0x000000011d1d7824ULL, 0x100fe200078e0212ULL, 0x0000000c13257810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0212ULL, 0x0000001013297810ULL, 0x000fc40007ffe0ffULL,
0x00000014132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000825277824ULL, 0x000fe200078e00ffULL,
0x00000018132d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000829337824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x0000001c13317810ULL, 0x000fe20007ffe0ffULL, 0x000000082b517824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x000000012d2f7824ULL, 0x100fe200078e0212ULL,
0x00005e0011107a11ULL, 0x000fe200078048ffULL, 0x0000000131537824ULL, 0x100fe200078e0212ULL,
0x00000004251e7212ULL, 0x0c0fe200078e3cffULL, 0x0000000125257824ULL, 0x100fe200078e0212ULL,
0x0000000429207212ULL, 0x0c0fe200078e3cffULL, 0x0000000129297824ULL, 0x100fe200078e0212ULL,
0x000000042b227212ULL, 0x040fe200078e3cffULL, 0x000000012b2b7824ULL, 0x000fe200078e0212ULL,
0x00005f0011117a11ULL, 0x000fc400000f4c1cULL, 0x0000000713137812ULL, 0x000fe400078e4804ULL,
0x000000761d1c7210ULL, 0x080fe40007fde0ffULL, 0xfffffff833337812ULL, 0x000fe400078ee220ULL,
0x000000761f207210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200030e06ffULL,
0x0000007625257210ULL, 0x080fe20007f9e0ffULL, 0x0000001033337824ULL, 0x000fe200078e0274ULL,
0x0000007629287210ULL, 0x080fe20007f7e0ffULL, 0x000000082d297824ULL, 0x000fe200078e00ffULL,
0x000000762b2a7210ULL, 0x000fc40007f1e0ffULL, 0x000000762f2c7210ULL, 0x080fe20007f3e0ffULL,
0x00000010232f7824ULL, 0x000fe200078e0274ULL, 0x0000007653767210ULL, 0x000fe20007f5e0ffULL,
0x0000000831537824ULL, 0x000fe200078e00ffULL, 0x0ffffff8131d7812ULL, 0x000fe200078ef804ULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21eULL,
0x000000ffff577224ULL, 0x000fe200010e06ffULL, 0xfffffff851517812ULL, 0x000fe200078ee222ULL,
0x000000101d2b7824ULL, 0x100fe200078e0274ULL, 0x000000042d1e7212ULL, 0x080fe200078e3cffULL,
0x000000ffff1d7224ULL, 0x000fe200028e06ffULL, 0x0000000431227212ULL, 0x000fe200078e3cffULL,
0x00000010212d7824ULL, 0x000fe200078e0274ULL, 0x00005e001c127a11ULL, 0x040fe200078c48ffULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x0000001027317824ULL, 0x000fe200078e0274ULL, 0xfffffff853537812ULL, 0x000fe200078ee222ULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005f001c137a11ULL, 0x000fe200030f4c1fULL,
0x0000001029557824ULL, 0x100fe200078e0274ULL, 0x00005e00201e7a11ULL, 0x000fe200078a48ffULL,
0x0000001053597824ULL, 0x000fe200078e0274ULL, 0x00005e00251c7a11ULL, 0x000fe200078848ffULL,
0x000000016a297824ULL, 0x000fe200078e020dULL, 0x00005f00201f7a11ULL, 0x000fe200028f4c1dULL,
0x000000ffff537224ULL, 0x000fe200008e06ffULL, 0x00005e0028267a11ULL, 0x000fe200078648ffULL,
0x0000001029107825ULL, 0x000fe200078e0010ULL, 0x00005f00251d7a11ULL, 0x000fc400020f4c22ULL,
0x00005e002a247a11ULL, 0x000fe200078048ffULL, 0x0000001029127825ULL, 0x040fe200078e0012ULL,
0x00005e002c227a11ULL, 0x000fe200078248ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000102b7faeULL, 0x0003e2000b901c46ULL, 0x00005e0076207a11ULL, 0x000fe200078448ffULL,
0x00000010291e7825ULL, 0x040fe200078e001eULL, 0x00005f0028277a11ULL, 0x000fe200018f4c21ULL,
0x00000000122d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002a257a11ULL, 0x000fe200000f4c23ULL,
0x00000010291c7825ULL, 0x040fe200078e001cULL, 0x00005f002c237a11ULL, 0x000fe200008f4c53ULL,
0x000000001e2f7faeULL, 0x0003e2000b901c46ULL, 0x00005f0076217a11ULL, 0x000fe200010f4c57ULL,
0x0000001029267825ULL, 0x000fc400078e0026ULL, 0x000000001c317faeULL, 0x0003e4000b901c46ULL,
0x0000001051517824ULL, 0x000fe400078e0274ULL, 0x0000001029247825ULL, 0x040fe200078e0024ULL,
0x0000000026337faeULL, 0x0003e6000b901c46ULL, 0x0000001029227825ULL, 0x040fe200078e0022ULL,
0x0000000024517faeULL, 0x0003e6000b901c46ULL, 0x0000001029207825ULL, 0x000fe200078e0020ULL,
0x0000000022557faeULL, 0x0003e8000b901c46ULL, 0x0000000020597faeULL, 0x0003e4000b901c46ULL,
0x000000015e757824ULL, 0x000fe400078e0275ULL, 0x00000300ff107624ULL, 0x002fc400078e00ffULL,
0xffffffffff667424ULL, 0x000fe200078e00ffULL, 0x0000000175117812ULL, 0x000fe400078ec0ffULL,
0xffffffff10107811ULL, 0x000fe400078e08ffULL, 0x000000011100780cULL, 0x000fc80003f05070ULL,
0x0000000110687807ULL, 0x000fca0004000000ULL, 0x0000000175687824ULL, 0x000fca00078e0268ULL,
0x000000616800720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000168107824ULL, 0x000fe400078e025fULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610667981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x014668006a127f8cULL, 0x000fe8000c80043fULL, 0x01466c006a117984ULL, 0x002e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff107424ULL, 0x000fc800078e00ffULL, 0x0000001000117305ULL, 0x0002a4000021f000ULL,
0x3fa0000010107823ULL, 0x002fe200000100ffULL, 0x000000110000735dULL, 0x004fe40003800000ULL,
0x01466c006a117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fc40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x014180005d127984ULL, 0x000e680000000800ULL,
0x014380005d137984ULL, 0x0004e20000000800ULL, 0x000000651200720bULL, 0x002fe20003f1d000ULL,
0x0000f7f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x0000ffff101d7812ULL, 0x000fe2000780c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff2c7424ULL, 0x000fd600078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000036300780cULL, 0x000fe40003f05270ULL, 0x000000651200720bULL, 0x000fe20003f34000ULL,
0x0000f7c27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000e7806ULL, 0x000fe400008e0100ULL,
0x00000012651c7209ULL, 0x040fe40007810000ULL, 0x0000ffff0e0e7812ULL, 0x000fe400078e3cffULL,
0x00000002ff2f7819ULL, 0x000fe20000011604ULL, 0x8000001c65107221ULL, 0x000fe20000010000ULL,
0x0145801c5d008388ULL, 0x0003e20000000800ULL, 0x0000000e1dff7212ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010002e7308ULL, 0x000ea40000000800ULL,
0x0000002e60607220ULL, 0x004fe20000410000ULL, 0x0000f7627f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2e0e7589ULL, 0x0022a400000e0000ULL, 0x0000000e38387220ULL, 0x084fe20000410000ULL,
0x0000000e39397220ULL, 0x080fe20000410000ULL, 0x0000000e3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000e40407220ULL, 0x080fe20000410000ULL,
0x0000000e41417220ULL, 0x080fe20000410000ULL, 0x0000000e44447220ULL, 0x080fe20000410000ULL,
0x0000000e45457220ULL, 0x080fe20000410000ULL, 0x0000000e4c4c7220ULL, 0x080fe20000410000ULL,
0x0000000e4d4d7220ULL, 0x080fe20000410000ULL, 0x0000000e48487220ULL, 0x080fe20000410000ULL,
0x0000000e49497220ULL, 0x080fe20000410000ULL, 0x0000000e34347220ULL, 0x080fe20000410000ULL,
0x0000000e35357220ULL, 0x080fe20000410000ULL, 0x0000000e18187220ULL, 0x080fe20000410000ULL,
0x0000000e19197220ULL, 0x000fe20000410000ULL, 0x0000f6a27f007947ULL, 0x000fea000b800000ULL,
0x00001f162e0e7589ULL, 0x00052400000e0000ULL, 0x8000001c12120221ULL, 0x100fe20000010000ULL,
0x00000001ff2c7807ULL, 0x000fe20000000000ULL, 0x0000000e3a3a7220ULL, 0x090fe20000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b12120820ULL, 0x000fe20000410000ULL,
0x0000000e3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e42427220ULL, 0x080fe20000410000ULL, 0x00000012005c0308ULL, 0x000f220000000800ULL,
0x0000000e43437220ULL, 0x080fe20000410000ULL, 0x0000000e46467220ULL, 0x080fe20000410000ULL,
0x0000000e47477220ULL, 0x080fe20000410000ULL, 0x0000000e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000e4a4a7220ULL, 0x080fe20000410000ULL,
0x0000000e4b4b7220ULL, 0x080fe20000410000ULL, 0x0000000e36367220ULL, 0x080fe20000410000ULL,
0x0000000e37377220ULL, 0x080fe20000410000ULL, 0x0000000e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000e1b1b7220ULL, 0x000fe20000410000ULL, 0x000000ffff657224ULL, 0x000fe200078e001cULL,
0x000000135c130220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005cff0e723eULL, 0x000fe200000000ffULL, 0x0000006013607221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff2f7819ULL, 0x002fe40000011604ULL,
0x000054100e2e7816ULL, 0x004fe2000000000eULL, 0x0000f5327f007947ULL, 0x000fea000b800000ULL,
0x00001f2f2e5d7589ULL, 0x0002a800000e0000ULL, 0x00001f162e0e7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0015ULL,
0x0000a58000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x0000fb1000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e0014ULL,
0x0000a5e000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000fab000007944ULL, 0x02cfea0003c00000ULL,
0x0000b8000f0f7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000b1c783bULL, 0x000fe20000004200ULL, 0x0000b80007077811ULL, 0x000fe400078e20ffULL,
0x000099102c147816ULL, 0x000fe200000000ffULL, 0x000000000f10783bULL, 0x000f260000000200ULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x000000000a20783bULL, 0x000fe80000004200ULL,
0x000000000924783bULL, 0x000fe80000004200ULL, 0x000000000828783bULL, 0x004fe80000004200ULL,
0x00000000072c783bULL, 0x002e680000000200ULL, 0x000000000630783bULL, 0x000ea80000004200ULL,
0x000000000550783bULL, 0x0006a80000004200ULL, 0x000000000354783bULL, 0x0006a80000004200ULL,
0x000000000058783bULL, 0x0008a20000004200ULL, 0x0000580066057a24ULL, 0x028fe200078e02ffULL,
0x0000030064037a10ULL, 0x000fe20007ffe0ffULL, 0x0000005d10108232ULL, 0x010fc60000000000ULL,
0x0000000103007810ULL, 0x000fe20007ffe0ffULL, 0x0000005d12128232ULL, 0x000fe40000000000ULL,
0x0000000e11118232ULL, 0x080fe20000000000ULL, 0x000000170000720cULL, 0x000fe20003f26070ULL,
0x0000000e13138232ULL, 0x000fe20000000000ULL, 0x0000008005007824ULL, 0x000fcc00078e00ffULL,
0x0000001c1038723cULL, 0x000fe20000001838ULL, 0x0000005d2c2c8232ULL, 0x082fe40000000000ULL,
0x0000005d2e2e8232ULL, 0x000fe40000000000ULL, 0x0000000e2d2d8232ULL, 0x000fc60000000000ULL,
0x000000201040723cULL, 0x000fe20000001840ULL, 0x0000000e2f2f8232ULL, 0x000fce0000000000ULL,
0x00000024104c723cULL, 0x040ff0000000184cULL, 0x0000001e101c723cULL, 0x040ff0000000183cULL,
0x000000221020723cULL, 0x040ff00000001844ULL, 0x000000261024723cULL, 0x040ff00000001848ULL,
0x000000281034723cULL, 0x040ff00000001834ULL, 0x0000002a1010723cULL, 0x000ff00000001818ULL,
0x000000302c38723cULL, 0x044ff00000001838ULL, 0x000000322c1c723cULL, 0x040ff0000000181cULL,
0x000000502c40723cULL, 0x040ff00000001840ULL, 0x000000522c20723cULL, 0x040ff00000001820ULL,
0x000000542c4c723cULL, 0x040ff0000000184cULL, 0x000000562c24723cULL, 0x040ff00000001824ULL,
0x000000582c34723cULL, 0x040ff00000001834ULL, 0x0000005a2c10723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000009947ULL, 0x000fea0003800000ULL,
0x00000003ff157819ULL, 0x000fe20000011604ULL, 0x0000010003037824ULL, 0x000fe400078e00ffULL,
0x000000016a297824ULL, 0x000fe200078e020dULL, 0x0000000815187810ULL, 0x040fe20007ffe0ffULL,
0x00000080020b7824ULL, 0x000fe200078e0215ULL, 0x0000000415147810ULL, 0x000fe40007ffe0ffULL,
0x0000000418097212ULL, 0x040fe200078e3cffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x000000000b057210ULL, 0x000fe20007f3e0ffULL, 0x00000008140e7824ULL, 0x000fe200078e00ffULL,
0x0000000362067217ULL, 0x000fc40007800000ULL, 0xfffffff81a2d7812ULL, 0x000fe200078ee209ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0005087a11ULL, 0x000fe200078248ffULL,
0x0000000106067824ULL, 0x000fe200078e0a03ULL, 0x0000000414077212ULL, 0x000fe200078e3cffULL,
0x000000102d2d7824ULL, 0x000fe200078e020cULL, 0x00005f0005097a11ULL, 0x000fe400008f4c0aULL,
0x000000040b057810ULL, 0x000fe40007ffe0ffULL, 0x0000000715037812ULL, 0x000fe200078e4804ULL,
0x0000001029087825ULL, 0x000fe200078e0008ULL, 0xfffffff80e197812ULL, 0x000fc400078ee207ULL,
0x0000000005057210ULL, 0x000fe40007f5e0ffULL, 0x0ffffff803077812ULL, 0x000fe400078ef804ULL,
0x0000002006037817ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x00000010151b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010070d7824ULL, 0x000fe200078e020cULL,
0x000000031500720cULL, 0x000fe40003f26070ULL, 0x00005e0005067a11ULL, 0x000fe200078448ffULL,
0x000000081b2c7824ULL, 0x040fe200078e00ffULL, 0x000000041b0f7212ULL, 0x000fc400078e3cffULL,
0x00005f0005077a11ULL, 0x000fe400010f4c0aULL, 0x000000080b057810ULL, 0x000fe40007ffe0ffULL,
0x0000000c151a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029067825ULL, 0x000fe200078e0006ULL,
0xfffffff82c317812ULL, 0x000fe200078ee20fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080d7faeULL, 0x0003e2000c901c46ULL, 0x00000000050a7210ULL, 0x000fe20007f5e0ffULL,
0x000000081a2f7824ULL, 0x000fe200078e00ffULL, 0x0000000c0b0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0x000000100b2b7810ULL, 0x000fc40007ffe0ffULL,
0x000000140b337810ULL, 0x040fe40007ffe0ffULL, 0x000000180b3f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c0b457810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x002fe200010e06ffULL,
0x000000041a0e7212ULL, 0x000fe400078e3cffULL, 0x000000000f0b7210ULL, 0x000fe40007f7e0ffULL,
0x00005e000a087a11ULL, 0x000fc400078c48ffULL, 0x00000014152a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x000000002b0f7210ULL, 0x000fe20007f3e0ffULL, 0x000000082a3d7824ULL, 0x000fe200078e00ffULL,
0x00005f000a097a11ULL, 0x000fe200030f4c09ULL, 0x00000010192b7824ULL, 0x100fe200078e020cULL,
0x00005e000b0a7a11ULL, 0x000fe200078c48ffULL, 0x000000102f2f7824ULL, 0x000fe200078e020cULL,
0x000000031400720cULL, 0x000fe20003f66070ULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00000018152c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029087825ULL, 0x000fe200078e0008ULL,
0x0000001c152e7810ULL, 0x000fc40007ffe0ffULL, 0x000000042a287212ULL, 0x000fe200078e3cffULL,
0x000000082c307824ULL, 0x000fe200078e00ffULL, 0x0000000033057210ULL, 0x080fe40007f9e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe400030f4c0eULL, 0x00005e000f0e7a11ULL, 0x000fe200078c48ffULL,
0x00000000062b7faeULL, 0x0003e2000d901c46ULL, 0x000000003f0d7210ULL, 0x000fe20007fbe0ffULL,
0x000000082e3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee228ULL,
0x00000010290a7825ULL, 0x000fe200078e000aULL, 0x000000031800720cULL, 0x000fc40003f26070ULL,
0x000000042c157212ULL, 0x080fe200078e3cffULL, 0x000000ffff187224ULL, 0x000fe200020e06ffULL,
0x000000042e287212ULL, 0x000fe200078e3cffULL, 0x000000103d3d7824ULL, 0x000fe200078e020cULL,
0x00005f000f0f7a11ULL, 0x000fe400030f4c14ULL, 0x0000000045007210ULL, 0x000fe40007f5e0ffULL,
0x00005e0005147a11ULL, 0x000fe200078c48ffULL, 0x0000001029067825ULL, 0x002fe200078e000eULL,
0xfffffff830337812ULL, 0x000fe200078ee215ULL, 0x00000000082d7faeULL, 0x0003e2000c901c46ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee228ULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x00005f0005157a11ULL, 0x000fe200030f4c18ULL, 0x000000ffff057224ULL, 0x000fe200010e06ffULL,
0x000000031a00720cULL, 0x000fe20003f66070ULL, 0x0000001033337824ULL, 0x100fe200078e020cULL,
0x00005e000d187a11ULL, 0x000fe200078a48ffULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0x00005e00001a7a11ULL, 0x000fc400078c48ffULL, 0x000000031b00720cULL, 0x080fe40003f86070ULL,
0x000000032a00720cULL, 0x080fe40003f46070ULL, 0x00005f000d197a11ULL, 0x000fe200028f4c28ULL,
0x00000010290c7825ULL, 0x040fe200078e0014ULL, 0x000000032c00720cULL, 0x080fe20003fa6070ULL,
0x000000000a2f7faeULL, 0x0003e2000d901c46ULL, 0x00005f00001b7a11ULL, 0x000fe200030f4c05ULL,
0x00000010290e7825ULL, 0x000fe200078e0018ULL, 0x000000032e00720cULL, 0x000fc60003fc6070ULL,
0x0000001029147825ULL, 0x000fe200078e001aULL, 0x0000000006317faeULL, 0x0003e8000e101c46ULL,
0x000000000c3d7faeULL, 0x0003e8000d101c46ULL, 0x000000000e337faeULL, 0x0003e8000e901c46ULL,
0x00000000143f7faeULL, 0x0003e2000f101c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fc80000011604ULL, 0x0000000403057810ULL, 0x040fe40007ffe0ffULL,
0x0000000803077810ULL, 0x040fe40007ffe0ffULL, 0x0000000c03097810ULL, 0x000fe20007ffe0ffULL,
0x0000000805157824ULL, 0x040fe200078e00ffULL, 0x0000000405067212ULL, 0x080fe200078e3cffULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0x0000000407057212ULL, 0x080fe200078e3cffULL,
0x00000008090a7824ULL, 0x040fe200078e00ffULL, 0x0000000409077212ULL, 0x000fc400078e3cffULL,
0x0000001003097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff808197812ULL, 0x000fe200078ee205ULL,
0x0000008002057824ULL, 0x000fe200078e0203ULL, 0xfffffff80a1b7812ULL, 0x000fe200078ee207ULL,
0x00000008092f7824ULL, 0x000fe200078e00ffULL, 0x0000001403077810ULL, 0x000fe40007ffe0ffULL,
0xfffffff815157812ULL, 0x000fe400078ee206ULL, 0x0000000409067212ULL, 0x000fe200078e3cffULL,
0x0000000807317824ULL, 0x000fe200078e00ffULL, 0x00000018030b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000405097810ULL, 0x000fe40007ffe0ffULL, 0x0000000407087212ULL, 0x000fe200078e3cffULL,
0x000000080b337824ULL, 0x000fe200078e00ffULL, 0x0000000005077210ULL, 0x000fe40007f3e0ffULL,
0x000000040b147212ULL, 0x000fe400078e3cffULL, 0x00000000090e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00000007030b7812ULL, 0x000fc400078e4804ULL,
0xfffffff831317812ULL, 0x000fe200078ee208ULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x0000001c033d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee206ULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0x00005e0007087a11ULL, 0x000fe400078248ffULL,
0x0ffffff80b037812ULL, 0x000fe200078ef804ULL, 0x000000102f2f7824ULL, 0x000fe200078e020cULL,
0x00005e000e067a11ULL, 0x000fc400078448ffULL, 0x00000008050b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0007097a11ULL, 0x000fe400008f4c0aULL, 0x00005f000e077a11ULL, 0x000fe400010f4c0fULL,
0x000000000b0b7210ULL, 0x000fe40007f9e0ffULL, 0x0000000c050f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff833337812ULL, 0x000fe200078ee214ULL, 0x000000ffff0e7224ULL, 0x000fe200020e06ffULL,
0x0000001005297810ULL, 0x000fc40007ffe0ffULL, 0x00000014052b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0x00000018052d7810ULL, 0x000fe40007ffe0ffULL,
0x000000043d147212ULL, 0x040fe200078e3cffULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0x0000001c05057810ULL, 0x000fe40007ffe0ffULL, 0x000000000f0f7210ULL, 0x000fe40007f5e0ffULL,
0x00005e000b0a7a11ULL, 0x000fc400078c48ffULL, 0x0000000029287210ULL, 0x080fe20007f7e0ffULL,
0x0000001015297824ULL, 0x100fe200078e020cULL, 0x000000002b2a7210ULL, 0x080fe20007f3e0ffULL,
0x00000010192b7824ULL, 0x100fe200078e020cULL, 0x000000002d2c7210ULL, 0x080fe20007f9e0ffULL,
0x000000101b2d7824ULL, 0x000fe200078e020cULL, 0x00000000052e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee214ULL,
0x0000001003057824ULL, 0x000fe200078e020cULL, 0x00005f000b0b7a11ULL, 0x000fe200030f4c0eULL,
0x000000016a037824ULL, 0x000fe200078e020dULL, 0x00005e000f0e7a11ULL, 0x000fe200078448ffULL,
0x000000103d3d7824ULL, 0x000fc400078e020cULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200010f4c00ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005e00280c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005e002a147a11ULL, 0x000fe200078248ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0x00005e002c187a11ULL, 0x000fe200078648ffULL, 0x0000001003087825ULL, 0x040fe200078e0008ULL,
0x00005e002e1a7a11ULL, 0x000fe400078848ffULL, 0x00005f00280d7a11ULL, 0x000fe200010f4c0dULL,
0x0000001003067825ULL, 0x040fe200078e0006ULL, 0x00005f002a157a11ULL, 0x000fe200008f4c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008057faeULL, 0x0003e2000b901c46ULL,
0x00005f002c197a11ULL, 0x000fe200018f4c19ULL, 0x00000010030a7825ULL, 0x040fe200078e000aULL,
0x00005f002e1b7a11ULL, 0x000fe200020f4c1bULL, 0x0000000006297faeULL, 0x0003e4000b901c46ULL,
0x00000010030e7825ULL, 0x000fc400078e000eULL, 0x000000000a2b7faeULL, 0x0003e4000b901c46ULL,
0x00000010030c7825ULL, 0x040fe400078e000cULL, 0x000000000e2d7faeULL, 0x0003e4000b901c46ULL,
0x0000001003147825ULL, 0x040fe400078e0014ULL, 0x000000000c2f7faeULL, 0x0003e4000b901c46ULL,
0x0000001003187825ULL, 0x000fc400078e0018ULL, 0x0000000014317faeULL, 0x0003e4000b901c46ULL,
0x00000010031a7825ULL, 0x000fe400078e001aULL, 0x0000000018337faeULL, 0x0003e8000b901c46ULL,
0x000000001a3d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b80072087811ULL, 0x002fe400078e20ffULL, 0x0000005cff00723eULL, 0x000fc400000000ffULL,
0x00000002ff037819ULL, 0x000fe40000011604ULL, 0x0000541000007816ULL, 0x000fe40000000000ULL,
0x0000b8006d187811ULL, 0x000fc600078e20ffULL, 0x00001f0300037589ULL, 0x000fe800000e0000ULL,
0x00001f1600167589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000e680000000200ULL, 0x00000000710c783bULL, 0x000ea80000004200ULL,
0x000000007028783bULL, 0x000fe80000004200ULL, 0x000000006f2c783bULL, 0x000fe80000004200ULL,
0x000000006e30783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000ee80000000200ULL,
0x000000006c3c783bULL, 0x000f280000004200ULL, 0x000000006b44783bULL, 0x000f680000004200ULL,
0x000000006948783bULL, 0x000f280000004200ULL, 0x000000006750783bULL, 0x000f220000004200ULL,
0x0000000308088232ULL, 0x002fc40000000000ULL, 0x000000030a0a8232ULL, 0x000fe40000000000ULL,
0x0000001609098232ULL, 0x080fe40000000000ULL, 0x000000160b0b8232ULL, 0x000fce0000000000ULL,
0x0000000c0838723cULL, 0x004fe20000001838ULL, 0x0000000318188232ULL, 0x008fce0000000000ULL,
0x000000280840723cULL, 0x000fe20000001840ULL, 0x000000031a1a8232ULL, 0x000fe40000000000ULL,
0x0000001619198232ULL, 0x080fe40000000000ULL, 0x000000161b1b8232ULL, 0x000fc60000000000ULL,
0x0000002c084c723cULL, 0x040ff0000000184cULL, 0x0000000e081c723cULL, 0x040ff0000000181cULL,
0x0000002a0820723cULL, 0x040ff00000001820ULL, 0x0000002e0824723cULL, 0x040ff00000001824ULL,
0x000000300834723cULL, 0x040ff00000001834ULL, 0x000000320810723cULL, 0x000ff00000001810ULL,
0x0000003c1838723cULL, 0x050ff00000001838ULL, 0x000000441840723cULL, 0x060ff00000001840ULL,
0x00000048184c723cULL, 0x040ff0000000184cULL, 0x0000003e183c723cULL, 0x040ff0000000181cULL,
0x000000461844723cULL, 0x040ff00000001820ULL, 0x0000004a1848723cULL, 0x040ff00000001824ULL,
0x000000501834723cULL, 0x040ff00000001834ULL, 0x000000521818723cULL, 0x000fe20000001810ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030064647a10ULL, 0x000fc80007ffe0ffULL,
0x000000176400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff5cd000007947ULL, 0x000fea000383ffffULL, 0x0000000000067919ULL, 0x000e640000002500ULL,
0x000000170600720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000060007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e0060ULL,
0x0000ba0000287802ULL, 0x000fe40000000f00ULL, 0x0000e4e000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000006000037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000060ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ee80000000000ULL,
0x0000000000027919ULL, 0x000f220000000000ULL, 0x0000000803037811ULL, 0x008fe400078ff0ffULL,
0x00000002ff057819ULL, 0x010fc80000011602ULL, 0x00001f0300037589ULL, 0x000ee800000e0000ULL,
0x00001f0500027589ULL, 0x000f2200000e0000ULL, 0x0000003a033a7220ULL, 0x048fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000003e033e7220ULL, 0x040fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x050fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000004402447220ULL, 0x040fe20000410000ULL,
0x0000004502457220ULL, 0x040fe20000410000ULL, 0x0000004c024c7220ULL, 0x040fe20000410000ULL,
0x0000004d024d7220ULL, 0x040fe20000410000ULL, 0x0000004802487220ULL, 0x040fe20000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000001802187220ULL, 0x040fe20000410000ULL,
0x0000001902197220ULL, 0x000fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000004603467220ULL, 0x040fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000004e034e7220ULL, 0x040fe20000410000ULL,
0x0000004f034f7220ULL, 0x040fe20000410000ULL, 0x0000004a034a7220ULL, 0x040fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000003603367220ULL, 0x040fe20000410000ULL,
0x0000003703377220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x000fc40000410000ULL, 0x00000000001c7919ULL, 0x000ee20000000000ULL,
0x00000018190b723eULL, 0x000fc400000000ffULL, 0x0000001a1b13723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000383903723eULL, 0x000fe400000000ffULL,
0x0000003c3d04723eULL, 0x000fe400000000ffULL, 0x000000404105723eULL, 0x000fe400000000ffULL,
0x000000444507723eULL, 0x000fe400000000ffULL, 0x0000004c4d08723eULL, 0x000fc400000000ffULL,
0x000000484909723eULL, 0x000fe400000000ffULL, 0x00000034350a723eULL, 0x000fe400000000ffULL,
0x0000003a3b0c723eULL, 0x000fe400000000ffULL, 0x0000003e3f0d723eULL, 0x000fe400000000ffULL,
0x00000042430e723eULL, 0x000fe400000000ffULL, 0x00000002ff217819ULL, 0x008fc4000001161cULL,
0x000000081c2f7811ULL, 0x000fe400078ff0ffULL, 0x00000021ff237212ULL, 0x000fe200078e33ffULL,
0x0000000821147824ULL, 0x000fe200078e00ffULL, 0x0000002fff317212ULL, 0x000fe200078e33ffULL,
0x000000082f167824ULL, 0x000fe200078e00ffULL, 0x0000000721007812ULL, 0x040fe200078ec0ffULL,
0x0000000821027824ULL, 0x000fe200078e00ffULL, 0xfffffff814237812ULL, 0x000fe400078ee223ULL,
0xfffffff816317812ULL, 0x000fc400078ee231ULL, 0xfffffff802157812ULL, 0x000fe400078ee221ULL,
0x0000000100027812ULL, 0x040fe400078e3cffULL, 0x0000000200147812ULL, 0x040fe400078e3cffULL,
0x0000000300167812ULL, 0x040fe200078e3cffULL, 0x0000000821177824ULL, 0x040fe200078e0202ULL,
0x0000000400187812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0214ULL,
0x00000005001a7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0216ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x00000008211d7824ULL, 0x000fe200078e0218ULL,
0x000000072f167812ULL, 0x000fe200078ec0ffULL, 0x00000008211f7824ULL, 0x000fe200078e021aULL,
0x00000046470f723eULL, 0x000fe200000000ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x00000002161a7812ULL, 0x040fe200078e3cffULL, 0x0000080063007824ULL, 0x000fe200078e00ffULL,
0x00000004161e7812ULL, 0x000fe200078e3cffULL, 0x000000041c147824ULL, 0x000fe200078e00ffULL,
0x00000003161c7812ULL, 0x000fe200078e3cffULL, 0x000000082f187824ULL, 0x040fe200078e00ffULL,
0x0000a00000027810ULL, 0x000fe20007ffe0ffULL, 0x000000082f297824ULL, 0x040fe200078e021aULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x000000082f2b7824ULL, 0x000fe200078e021cULL,
0xfffffff818257812ULL, 0x000fe200078ee22fULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000000116187812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000000516207812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0202ULL,
0x0000000616227812ULL, 0x000fe200078e3cffULL, 0x0000000115167824ULL, 0x000fe200078e0214ULL,
0x0000004e4f10723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000004a4b11723eULL, 0x000fe200000000ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0202ULL,
0x0000000316007388ULL, 0x0007e20000000800ULL, 0x000000082f277824ULL, 0x002fe200078e0218ULL,
0x000000363712723eULL, 0x000fe200000000ffULL, 0x000000101f1f7824ULL, 0x000fc400078e0202ULL,
0x0000000114177824ULL, 0x040fe400078e0217ULL, 0x0000001021217824ULL, 0x100fe400078e0202ULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0x0000000417007388ULL, 0x0003e20000000800ULL,
0x0000000114167824ULL, 0x048fe400078e0219ULL, 0x0000000114187824ULL, 0x000fe400078e021bULL,
0x000000082f157824ULL, 0x000fe200078e021eULL, 0x0000000516007388ULL, 0x0003e20000000800ULL,
0x0000001025257824ULL, 0x000fc400078e0202ULL, 0x00000001141d7824ULL, 0x040fe200078e021dULL,
0x0000000718007388ULL, 0x0003e20000000800ULL, 0x00000001ff037424ULL, 0x000fe400078e00ffULL,
0x000000082f2d7824ULL, 0x000fe200078e0220ULL, 0x000000081d007388ULL, 0x0003e20000000800ULL,
0x0000001027277824ULL, 0x000fe200078e0202ULL, 0x0000030003007a0cULL, 0x000fe20003f05270ULL,
0x00000001141a7824ULL, 0x000fe400078e021fULL, 0x000000082f2f7824ULL, 0x000fc400078e0222ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x000000091a007388ULL, 0x0003e20000000800ULL,
0x0000000114217824ULL, 0x040fe400078e0221ULL, 0x00000001141c7824ULL, 0x040fe400078e0223ULL,
0x000000102b2b7824ULL, 0x100fe200078e0202ULL, 0x0000000a21007388ULL, 0x0003e20000000800ULL,
0x0000000114257824ULL, 0x000fe400078e0225ULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x0000000b1c007388ULL, 0x0003e20000000800ULL, 0x000000102d2d7824ULL, 0x000fc400078e0202ULL,
0x00000001141e7824ULL, 0x040fe200078e0227ULL, 0x0000000c25007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x100fe400078e0202ULL, 0x0000000114297824ULL, 0x040fe200078e0229ULL,
0x0000000d1e007388ULL, 0x0003e20000000800ULL, 0x0000001031317824ULL, 0x000fe400078e0202ULL,
0x0000000114207824ULL, 0x040fe200078e022bULL, 0x0000000e29007388ULL, 0x0003e20000000800ULL,
0x0000000114157824ULL, 0x000fc400078e0215ULL, 0x0000000114227824ULL, 0x040fe200078e022dULL,
0x0000000f20007388ULL, 0x0003e20000000800ULL, 0x00000001142f7824ULL, 0x040fe400078e022fULL,
0x0000000114247824ULL, 0x000fe200078e0231ULL, 0x0000001015007388ULL, 0x0003e80000000800ULL,
0x0000001122007388ULL, 0x0003e80000000800ULL, 0x000000122f007388ULL, 0x0003e80000000800ULL,
0x0000001324007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002bb000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x002e620000000000ULL,
0x00005800ff057624ULL, 0x000fe200078e00ffULL, 0x000000ff6300720cULL, 0x000fe20003f25270ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000077919ULL, 0x000ee20000002700ULL,
0x0000030005057a24ULL, 0x000fc600078e02ffULL, 0x0000000000087919ULL, 0x000ee20000002600ULL,
0x0000660005057a24ULL, 0x000fe400078e02ffULL, 0x00000010040a7824ULL, 0x042fe200078e0200ULL,
0x0000002004117810ULL, 0x040fe40007ffe0ffULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x00a000000a147984ULL, 0x0003240000000c00ULL, 0x000000ff6300720cULL, 0x000fe20000705670ULL,
0x0000580007077a24ULL, 0x008fe200078e0208ULL, 0x00a200000a187984ULL, 0x0002e60000000c00ULL,
0x0000030007037a24ULL, 0x000fc800078e02ffULL, 0x00000001030b7824ULL, 0x000fe200078e0206ULL,
0x00000fff05067811ULL, 0x000fc800078e40ffULL, 0x0000000b06087211ULL, 0x000fca00078fa0ffULL,
0x00006c0008087625ULL, 0x000fcc00078e0009ULL, 0x0000040063087825ULL, 0x000fcc00078e0008ULL,
0x0000001011107825ULL, 0x000fc800078e0008ULL, 0x00000010040e7825ULL, 0x000fe200078e0008ULL,
0x01ffffff05087812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x00000080ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000010b0c7824ULL, 0x040fe400078e0208ULL, 0x00006c000b0a7625ULL, 0x000fc800078e000dULL,
0x00006c000c0c7625ULL, 0x000fc800078e000dULL, 0x0000001005097824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011605ULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000000a050a7210ULL, 0x140fe40007b5e009ULL,
0x0000000c050c7210ULL, 0x000fe40007d9e009ULL, 0x0000000bff0b7210ULL, 0x000fe400017e64ffULL,
0x0000000dff0d7210ULL, 0x000fc600027ea4ffULL, 0x000000650a007986ULL, 0x0003e8000c101906ULL,
0x000000600c007986ULL, 0x0003e4000c101906ULL, 0x000000140e007986ULL, 0x0123e2000c101d06ULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x0000001810007986ULL, 0x0083e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x00000001ff057424ULL, 0x000fe400078e00ffULL, 0x00000004ff0a7424ULL, 0x000fc600078e00ffULL,
0x0000030005057a10ULL, 0x000fe20007ffe1ffULL, 0x00006a00070a7625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x000000050a0a79a8ULL, 0x000ee400099ee1c6ULL, 0x000000050a00720cULL, 0x008fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff077807ULL, 0x000fca0000000000ULL,
0x00000007ff007388ULL, 0x0007e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff057984ULL, 0x000f240000000000ULL,
0x000000ff0500720cULL, 0x010fda0003f05270ULL, 0x000027a000008947ULL, 0x000fea0003800000ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x00000001ff0a7819ULL, 0x000fe20000011604ULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x00000001030c7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x008fe200078e00ffULL, 0x0000000c0a0f7812ULL, 0x002fe400078ec0ffULL,
0x0000007005097812ULL, 0x000fe200078ec0ffULL, 0x00006c00030a7625ULL, 0x000fc800078e0007ULL,
0x00006c000c0c7625ULL, 0x000fe200078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000c0f0c7210ULL, 0x000fe40007b5e009ULL, 0x0000000bff0b7210ULL, 0x000fe400007e24ffULL,
0x0000000dff0d7210ULL, 0x000fc600017e64ffULL, 0x000000060a057981ULL, 0x000368000c1e1900ULL,
0x000000060c0e7981ULL, 0x000362000c1e1900ULL, 0x00000300ff117624ULL, 0x000fca00078e00ffULL,
0x000000021100780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x00000002030a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0007ULL,
0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a107981ULL, 0x000362000c1e1900ULL, 0x000000041100780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x00000003030a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a127981ULL, 0x000362000c1e1900ULL,
0x000000041100780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x00000004030a7810ULL, 0x002fca0007ffe0ffULL, 0x00006c000a0a7625ULL, 0x000fca00078e0007ULL,
0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL, 0x0000000bff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a147981ULL, 0x000362000c1e1900ULL, 0x000000061100780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005030a7810ULL, 0x002fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fc8000791e009ULL,
0x0000000bff0b7210ULL, 0x000fca00007e24ffULL, 0x000000060a167981ULL, 0x000362000c1e1900ULL,
0x000000061100780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000081100780cULL, 0x002fe40003f06070ULL, 0x00000006030a7810ULL, 0x000fca0007ffe0ffULL,
0x00006c000a0a7625ULL, 0x000fca00078e0007ULL, 0x0000000a0f0a7210ULL, 0x000fe40007a3e009ULL,
0x00000007030c0810ULL, 0x000fe40007ffe0ffULL, 0x0000000bff0b7210ULL, 0x000fc60000fe44ffULL,
0x00006c000c0c0625ULL, 0x000fe400078e0007ULL, 0x000000060a187981ULL, 0x000366000c1e1900ULL,
0x0000000c0f0c0210ULL, 0x000fc80007c7e009ULL, 0x0000000dff0d0210ULL, 0x000fca0001fe84ffULL,
0x000000060c0c0981ULL, 0x000368000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff0f7224ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x008fe400078e0003ULL,
0x000000ffff1a7224ULL, 0x020fe400078e0005ULL, 0x000000ffff117224ULL, 0x000fc600078e00ffULL,
0x000003000f007a0cULL, 0x000fe40003f26070ULL, 0x0000000111117810ULL, 0x000fc80007ffe0ffULL,
0x0000000411007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x000000080f097810ULL, 0x040fe40007ffe0ffULL, 0x000000010f0a7810ULL, 0x000fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001a05057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x00000008070a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a1a7981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x000000090f097810ULL, 0x040fe40007ffe0ffULL,
0x000000020f0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000000e05057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x00000009070a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x0000001004097824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a0e7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f097810ULL, 0x040fe40007ffe0ffULL, 0x000000030f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001005057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a070a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a107981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b0f097810ULL, 0x040fe40007ffe0ffULL,
0x000000040f0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001205057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b070a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x0000001004097824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a127981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f097810ULL, 0x040fe40007ffe0ffULL, 0x000000050f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001405057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a147981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d0f097810ULL, 0x040fe40007ffe0ffULL,
0x000000060f0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000030009007a0cULL, 0x000fe40003f26070ULL,
0x000003000a007a0cULL, 0x000fe40003f46070ULL, 0x0000001605057209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d070a7810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fe20000011604ULL,
0x0000001004097824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL,
0x000000060a167981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f097810ULL, 0x040fe40007ffe0ffULL, 0x000000070f0a7810ULL, 0x002fe40007ffe0ffULL,
0x0000030009007a0cULL, 0x000fe40003f26070ULL, 0x000003000a007a0cULL, 0x000fe40003f46070ULL,
0x0000001805057209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e070a7810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff0b7424ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fe20000011604ULL, 0x0000001004097824ULL, 0x000fe400078e00ffULL,
0x00006c000a0a7625ULL, 0x000fe200078e000bULL, 0x0000000c0d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x0000000a0d0a7210ULL, 0x000fc80007b3e009ULL,
0x0000000bff0b7210ULL, 0x000fca0000fe64ffULL, 0x000000060a187981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f0f097810ULL, 0x000fe40007ffe0ffULL,
0x0000000c05057209ULL, 0x000fe40007810000ULL, 0x0000030009007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f070a7810ULL, 0x002fe20007ffe0ffULL,
0x00000080ff0b7424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011604ULL,
0x0000001004097824ULL, 0x000fe400078e00ffULL, 0x00006c000a0a7625ULL, 0x000fe200078e000bULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x0000007009097812ULL, 0x000fc800078ec0ffULL,
0x0000000a0c0a7210ULL, 0x000fc80007a3e009ULL, 0x0000000bff0b7210ULL, 0x000fca0000fe44ffULL,
0x000000060a0c7981ULL, 0x000368000c1e1900ULL, 0x000000080f0f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000807077810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x000f240000000000ULL, 0x0000001004077824ULL, 0x018fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011604ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c090a7812ULL, 0x002fca00078ec0ffULL, 0x00000001070a7824ULL, 0x000fca00078e020aULL,
0x000000050a007388ULL, 0x0203e40000000800ULL, 0x000000070400780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000001ff077819ULL, 0x008fe20000011604ULL,
0x0000001004057824ULL, 0x002fe200078e00ffULL, 0x0000000306297211ULL, 0x000fe200078fa0ffULL,
0x00001000ff067424ULL, 0x000fe200078e00ffULL, 0x0000000c070a7812ULL, 0x000fe200078ec0ffULL,
0x0000000103287824ULL, 0x000fe200078e0208ULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00006c0029067625ULL, 0x000fe200078e0006ULL, 0x0000002004117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0b8424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000080ff148424ULL, 0x000fe200078e00ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000040063067825ULL, 0x000fe200078e0006ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000001050d7824ULL, 0x000fe200078e020aULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000100063057824ULL, 0x000fc400078e00ffULL, 0x00006c00280a8625ULL, 0x000fc800078e000bULL,
0x0000001063178824ULL, 0x000fe400078e0204ULL, 0x00006c0003148625ULL, 0x000fc600078e0014ULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x0000001063198824ULL, 0x000fe400078e0204ULL,
0x00000010040f7824ULL, 0x040fe400078e0205ULL, 0x0000001004087825ULL, 0x000fe200078e0006ULL,
0x0000418019198811ULL, 0x000fc600078e20ffULL, 0x0000001011107825ULL, 0x000fe400078e0006ULL,
0x000000000d067984ULL, 0x0002e40000000800ULL, 0x0000001004128825ULL, 0x040fe400078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000080f7faeULL, 0x0009e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000001004148825ULL, 0x000fe400078e0014ULL,
0x00380000100f7faeULL, 0x000be2000b901c46ULL, 0x00000000000c7805ULL, 0x002fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fc400078e00ffULL, 0x0000000012178faeULL, 0x0003e8000b901c46ULL,
0x0000000014198faeULL, 0x0005e2000b901c46ULL, 0x0000000000087805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000e7805ULL, 0x020fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000d1000009947ULL, 0x000fea0003800000ULL,
0x00000001032a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001ff037424ULL, 0x000fe200078e00ffULL,
0x0000000128287810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000030003007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070400780cULL, 0x040fe20003f04070ULL,
0x00001000ff2c7424ULL, 0x000fe200078e00ffULL, 0x0000000103307812ULL, 0x040fe200078ec0ffULL,
0x00000800032b7824ULL, 0x000fe200078e00ffULL, 0x0000002004377810ULL, 0x000fe20007ffe0ffULL,
0x00006c00292c7625ULL, 0x000fc600078e002cULL, 0x000008002b2e7812ULL, 0x000fc600078ec0ffULL,
0x00000400632c7825ULL, 0x000fc800078e002cULL, 0x00000080ff318424ULL, 0x000fe400078e00ffULL,
0x00000002632f8824ULL, 0x140fe400078e0230ULL, 0x00000080ff338424ULL, 0x000fe400078e00ffULL,
0x0000000263398824ULL, 0x000fe400078e0230ULL, 0x00000001052b7824ULL, 0x000fe400078e022eULL,
0x00006c0028308625ULL, 0x000fc800078e0031ULL, 0x000000082f358824ULL, 0x000fe400078e0204ULL,
0x00006c002a328625ULL, 0x000fc600078e0033ULL, 0x0000458035358811ULL, 0x000fe200078e20ffULL,
0x0000000839398824ULL, 0x000fe400078e0204ULL, 0x00000010372e7825ULL, 0x000fc600078e002cULL,
0x0000418039378811ULL, 0x000fe200078e20ffULL, 0x00000010042b7824ULL, 0x040fe400078e022bULL,
0x00000010042c7825ULL, 0x000fc800078e002cULL, 0x0000001004308825ULL, 0x040fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001004328825ULL, 0x000fe200078e0032ULL, 0x003800002e2b7faeULL, 0x0003e8000b901c46ULL,
0x0000000030358faeULL, 0x0003e8000b901c46ULL, 0x0000000032378faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff032b7810ULL, 0x002fe20007ffe0ffULL,
0x00000010042d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff2e7819ULL, 0x000fc40000011604ULL,
0x00000002ff337819ULL, 0x000fe20000011604ULL, 0x000000802b2c7824ULL, 0x000fe200078e00ffULL,
0x000000702d2d7812ULL, 0x000fe200078ec0ffULL, 0x000008002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c2e2e7812ULL, 0x000fe200078ec0ffULL, 0x0000000833357824ULL, 0x040fe200078e00ffULL,
0x000000802c2c7812ULL, 0x000fe200078ec0ffULL, 0x0000000833317824ULL, 0x040fe200078e00ffULL,
0x00000007333a7812ULL, 0x040fe400078ec0ffULL, 0x0000000833377810ULL, 0x000fe20007ffe0ffULL,
0x00000100632c7824ULL, 0x000fe200078e022cULL, 0x0000030003007a0cULL, 0x000fc40003f06070ULL,
0x00000037ff487212ULL, 0x000fe200078e33ffULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0x0000002c2e2e7210ULL, 0x000fe20007ffe02dULL, 0x00000008332d7824ULL, 0x000fe200078e00ffULL,
0x00000033ff2c7212ULL, 0x000fe200078e33ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002e2f7984ULL, 0x000e620000000800ULL, 0xfffffff835427812ULL, 0x000fe200078ee22cULL,
0x0000000404357824ULL, 0x000fe200078e00ffULL, 0xfffffff8312c7812ULL, 0x100fe200078ee23aULL,
0x004580002e4a7984ULL, 0x0005220000000800ULL, 0x000000012d307812ULL, 0x100fe200078ef63aULL,
0x0000000837317824ULL, 0x000fe200078e00ffULL, 0x000000022d327812ULL, 0x100fe200078ef63aULL,
0x00000008373c7824ULL, 0x000fe200078e00ffULL, 0x000000032d347812ULL, 0x140fe400078ef63aULL,
0x000000042d367812ULL, 0x000fc400078ef63aULL, 0x000008002b2e7812ULL, 0x004fe400078ec0ffULL,
0x000000052d387812ULL, 0x000fe400078ef63aULL, 0x00000180052b7810ULL, 0x000fe40007ffe02eULL,
0x000000062d3a7812ULL, 0x000fe400078ef63aULL, 0x0000000c35357812ULL, 0x000fe200078ec0ffULL,
0x000000102c2c7824ULL, 0x100fe200078e022bULL, 0xfffffff831487812ULL, 0x000fe200078ee248ULL,
0x0000001030307824ULL, 0x100fe200078e022bULL, 0x0000000103037810ULL, 0x000fe20007ffe0ffULL,
0x00000001352c7824ULL, 0x040fe200078e022cULL, 0x0000000128287810ULL, 0x000fe20007ffe0ffULL,
0x0000000135307824ULL, 0x000fe200078e0230ULL, 0x0000000129297810ULL, 0x000fe20007ffe0ffULL,
0x0000001032327824ULL, 0x100fe200078e022bULL, 0x000000012a2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000002c2c7984ULL, 0x000ea20000000800ULL, 0x0000001034347824ULL, 0x000fc400078e022bULL,
0x0000000135327824ULL, 0x040fe200078e0232ULL, 0x0000000030307984ULL, 0x000fe20000000800ULL,
0x0000001038387824ULL, 0x000fe400078e022bULL, 0x0000000135347824ULL, 0x000fe200078e0234ULL,
0x0000002f062d7221ULL, 0x00afe20000010100ULL, 0x00000007372f7812ULL, 0x000fe200078ec0ffULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x0000000135387824ULL, 0x000fe200078e0238ULL,
0x3fb8aa3b2d317820ULL, 0x000fe20000410000ULL, 0x00000010422d7824ULL, 0x000fe200078e022bULL,
0xfffffff83e2e7812ULL, 0x000fe200078ee22fULL, 0x000000103a3a7824ULL, 0x000fe200078e022bULL,
0x000000013c3e7812ULL, 0x000fe200078ef62fULL, 0x00000001352d7824ULL, 0x040fe200078e022dULL,
0x0000003100317308ULL, 0x000f220000000800ULL, 0x000000102e2e7824ULL, 0x000fe200078e022bULL,
0x000000023c407812ULL, 0x140fe200078ef62fULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0x00000001353a7824ULL, 0x040fe200078e023aULL, 0x000000033c427812ULL, 0x000fe200078ef62fULL,
0x00000001352e7824ULL, 0x040fe200078e022eULL, 0x000000002d2d7984ULL, 0x000fe20000000800ULL,
0x000000103e3e7824ULL, 0x000fe200078e022bULL, 0x000000043c447812ULL, 0x000fe200078ef62fULL,
0x0000001040407824ULL, 0x000fe200078e022bULL, 0x0000000038387984ULL, 0x000fe20000000800ULL,
0x00000001353e7824ULL, 0x040fe200078e023eULL, 0x000000053c467812ULL, 0x000fe200078ef62fULL,
0x0000000135407824ULL, 0x000fe200078e0240ULL, 0x000000003a3a7984ULL, 0x000fe20000000800ULL,
0x0000004a314c7220ULL, 0x010fe20000410000ULL, 0x0000001036367824ULL, 0x000fe200078e022bULL,
0x000000063c3c7812ULL, 0x000fe200078ef62fULL, 0x000000002e2e7984ULL, 0x000fe20000000800ULL,
0x0000001042427824ULL, 0x000fe200078e022bULL, 0x000000274c277221ULL, 0x000fe20000010000ULL,
0x0000001044447824ULL, 0x000fe200078e022bULL, 0x00001f334c317589ULL, 0x000e6200000e0000ULL,
0x0000000135367824ULL, 0x000fc400078e0236ULL, 0x0000000135427824ULL, 0x040fe200078e0242ULL,
0x000000003e3e7984ULL, 0x000ee20000000800ULL, 0x0000000135447824ULL, 0x040fe400078e0244ULL,
0x0000001046467824ULL, 0x100fe200078e022bULL, 0x0000000040407984ULL, 0x000fe20000000800ULL,
0x000000103c3c7824ULL, 0x100fe400078e022bULL, 0x0000001048487824ULL, 0x000fe200078e022bULL,
0x0000000036367984ULL, 0x000f220000000800ULL, 0x0000000135467824ULL, 0x000fc400078e0246ULL,
0x00000001353c7824ULL, 0x040fe200078e023cULL, 0x0000000042427984ULL, 0x000fe20000000800ULL,
0x0000000135487824ULL, 0x000fe400078e0248ULL, 0x3000002cff2b7230ULL, 0x104fe20000004100ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x2000002cff4a7230ULL, 0x000fc60000004100ULL,
0x0000000046467984ULL, 0x000fe20000000800ULL, 0x000000312b227223ULL, 0x082fe20000010022ULL,
0x30000030ff2b7230ULL, 0x000fe20000004100ULL, 0x000000314a237223ULL, 0x080fe20000010023ULL,
0x000000003c3c7984ULL, 0x000fe20000000800ULL, 0x2000002dff2c7230ULL, 0x100fe40000004100ULL,
0x000000312b1e7223ULL, 0x080fe2000001001eULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x3000002dff2d7230ULL, 0x000fe20000004100ULL, 0x000000312c0b7223ULL, 0x080fe2000001000bULL,
0x30000032ff2b7230ULL, 0x000fe20000004100ULL, 0x00001f374c4c7589ULL, 0x000e6200000e0000ULL,
0x20000030ff2c7230ULL, 0x000fe20000004100ULL, 0x000000312d0a7223ULL, 0x080fe2000001000aULL,
0x30000034ff2d7230ULL, 0x000fe20000004100ULL, 0x000000312b1a7223ULL, 0x080fe2000001001aULL,
0x30000038ff2b7230ULL, 0x000fe20000004100ULL, 0x000000312c1f7223ULL, 0x080fe2000001001fULL,
0x20000034ff2c7230ULL, 0x000fe20000004100ULL, 0x000000312d167223ULL, 0x080fe20000010016ULL,
0x3000003aff2d7230ULL, 0x000fe20000004100ULL, 0x000000312b107223ULL, 0x080fe20000010010ULL,
0x3000002eff2b7230ULL, 0x000fe20000004100ULL, 0x000000312c177223ULL, 0x080fe20000010017ULL,
0x20000038ff2c7230ULL, 0x000fe20000004100ULL, 0x000000312d0e7223ULL, 0x000fe2000001000eULL,
0x3000003eff2d7230ULL, 0x008fc40000004100ULL, 0x20000036ff2f7230ULL, 0x010fe20000004100ULL,
0x000000312c117223ULL, 0x080fe20000010011ULL, 0x2000002eff2c7230ULL, 0x000fe40000004100ULL,
0x20000032ff307230ULL, 0x000fe20000004100ULL, 0x000000312f147223ULL, 0x080fe20000010014ULL,
0x20000040ff2e7230ULL, 0x100fe20000004100ULL, 0x0000004c2b207223ULL, 0x082fe20000010020ULL,
0x30000040ff2b7230ULL, 0x000fe20000004100ULL, 0x0000004c2d1c7223ULL, 0x080fe2000001001cULL,
0x0000004c2c217223ULL, 0x080fe20000010021ULL, 0x30000044ff2d7230ULL, 0x000fe20000004100ULL,
0x00000031301b7223ULL, 0x080fe2000001001bULL, 0x0000004c2b187223ULL, 0x080fe20000010018ULL,
0x30000042ff2b7230ULL, 0x000fe20000004100ULL, 0x0000004c2e197223ULL, 0x080fe20000010019ULL,
0x2000003eff2c7230ULL, 0x000fe20000004100ULL, 0x0000004c2d127223ULL, 0x080fe20000010012ULL,
0x20000046ff2f7230ULL, 0x000fe20000004100ULL, 0x0000004c2b087223ULL, 0x080fe20000010008ULL,
0x2000003cff2b7230ULL, 0x000fe20000004100ULL, 0x0000004c2c1d7223ULL, 0x080fe2000001001dULL,
0x20000048ff2d7230ULL, 0x000fe20000004100ULL, 0x0000004c2f267223ULL, 0x080fe20000010026ULL,
0x30000036ff367230ULL, 0x000fe20000004100ULL, 0x0000004c2b247223ULL, 0x080fe20000010024ULL,
0x2000003aff307230ULL, 0x000fe20000004100ULL, 0x0000004c2d0c7223ULL, 0x080fe2000001000cULL,
0x20000042ff2c7230ULL, 0x000fe20000004100ULL, 0x0000003136137223ULL, 0x080fe20000010013ULL,
0x20000044ff2e7230ULL, 0x000fe20000004100ULL, 0x00000031300f7223ULL, 0x000fe2000001000fULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004c2c097223ULL, 0x080fe20000010009ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000004c2e157223ULL, 0x080fe20000010015ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000004c46257223ULL, 0x000fc40000010025ULL,
0x0000004c3c0d7223ULL, 0x080fe4000001000dULL, 0x0000004c48077223ULL, 0x000fe20000010007ULL,
0xfffff34000008947ULL, 0x000fea000383ffffULL, 0x0180000027037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000e65000287802ULL, 0x000fe40000000f00ULL,
0x0000b89000007944ULL, 0x008fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002700047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000027ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x008ee80000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000002ff287819ULL, 0x008fe40000011606ULL,
0x00000008062a7811ULL, 0x040fe200078ff0ffULL, 0x0000000406067824ULL, 0x000fe400078e00ffULL,
0x00001f2803047589ULL, 0x004ea200000e0000ULL, 0x00000008282c7824ULL, 0x000fc400078e00ffULL,
0x000000082a297824ULL, 0x000fe200078e00ffULL, 0x00001f2a03057589ULL, 0x00072200000e0000ULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x00000028ff037212ULL, 0x008fc800078e33ffULL,
0xfffffff82c277812ULL, 0x002fe200078ee203ULL, 0x0000000828037824ULL, 0x000fc800078e00ffULL,
0x0000001027277824ULL, 0x000fe200078e0202ULL, 0x0000002304237220ULL, 0x044fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000000f040f7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000000b040b7220ULL, 0x040fe20000410000ULL,
0x0000002105217220ULL, 0x050fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000001c051c7220ULL, 0x040fe20000410000ULL,
0x0000001905197220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000000905097220ULL, 0x040fe20000410000ULL, 0x0000000805087220ULL, 0x040fe20000410000ULL,
0x0000001505157220ULL, 0x040fe20000410000ULL, 0x0000001205127220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000002405247220ULL, 0x040fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000000c050c7220ULL, 0x040fe20000410000ULL, 0x0000000a04047220ULL, 0x000fe20000410000ULL,
0x0000000705057220ULL, 0x000fe20000410000ULL, 0x0000000728077812ULL, 0x000fe200078ec0ffULL,
0x0000000106277824ULL, 0x000fe200078e0227ULL, 0x0000002aff0a7212ULL, 0x000fc400078e33ffULL,
0x000000090808723eULL, 0x000fe400000000ffULL, 0x0000000b0404723eULL, 0x000fe400000000ffULL,
0x0000000107097812ULL, 0x000fe400078e3cffULL, 0xfffffff829297812ULL, 0x000fe400078ee20aULL,
0x0000000f0e0e723eULL, 0x000fe200000000ffULL, 0x0000000828097824ULL, 0x000fe200078e0209ULL,
0x00000002070b7812ULL, 0x000fe200078e3cffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000111010723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0x000000072a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008280b7824ULL, 0x000fe200078e020bULL,
0x00000003070f7812ULL, 0x000fe200078e3cffULL, 0x0000000106097824ULL, 0x000fe200078e0209ULL,
0x000000151212723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0202ULL,
0xfffffff803037812ULL, 0x000fe200078ee228ULL, 0x00000008280f7824ULL, 0x000fe200078e020fULL,
0x0000000407117812ULL, 0x040fe200078e3cffULL, 0x00000001060b7824ULL, 0x000fe200078e020bULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x000000082a177824ULL, 0x000fe200078e00ffULL,
0x0000000507157812ULL, 0x000fe200078e3cffULL, 0x0000000828117824ULL, 0x000fe200078e0211ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000001003037824ULL, 0x100fe200078e0202ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000000828157824ULL, 0x000fe200078e0215ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0202ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000000103037824ULL, 0x000fe200078e0206ULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0202ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x000fe200078e0202ULL,
0x0000000607077812ULL, 0x000fe200078e3cffULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x000000010a197812ULL, 0x040fe200078e3cffULL, 0x0000002203007388ULL, 0x0003e20000000800ULL,
0x000000020a1b7812ULL, 0x000fe200078e3cffULL, 0x0000000828077824ULL, 0x000fe200078e0207ULL,
0x000000030a1d7812ULL, 0x000fe200078e3cffULL, 0x000000082a197824ULL, 0x000fe200078e0219ULL,
0x000000040a1f7812ULL, 0x000fe200078e3cffULL, 0x000000082a1b7824ULL, 0x000fe200078e021bULL,
0x000000050a217812ULL, 0x000fe200078e3cffULL, 0x000000082a1d7824ULL, 0x000fe200078e021dULL,
0x000000060a237812ULL, 0x000fe200078e3cffULL, 0x000000082a1f7824ULL, 0x040fe200078e021fULL,
0xfffffff817177812ULL, 0x000fe200078ee22aULL, 0x000000082a217824ULL, 0x040fe200078e0221ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000000082a237824ULL, 0x000fe200078e0223ULL,
0x0000001e09007388ULL, 0x0003e20000000800ULL, 0x0000001007077824ULL, 0x100fe200078e0202ULL,
0x0000000c0505723eULL, 0x000fe200000000ffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000001a0b007388ULL, 0x0003e20000000800ULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x000000160f007388ULL, 0x0003e20000000800ULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x000000240d0d723eULL, 0x000fe200000000ffULL, 0x000000101f1f7824ULL, 0x000fc400078e0202ULL,
0x0000001021217824ULL, 0x100fe400078e0202ULL, 0x0000001023237824ULL, 0x000fe400078e0202ULL,
0x0000000106027824ULL, 0x040fe400078e0211ULL, 0x0000000106157824ULL, 0x040fe400078e0215ULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001302007388ULL, 0x0003e20000000800ULL,
0x0000000106177824ULL, 0x000fc400078e0217ULL, 0x0000000106197824ULL, 0x040fe200078e0219ULL,
0x0000001015007388ULL, 0x0003e20000000800ULL, 0x00000001061b7824ULL, 0x040fe400078e021bULL,
0x00000001061d7824ULL, 0x040fe200078e021dULL, 0x0000000e07007388ULL, 0x0003e20000000800ULL,
0x00000001061f7824ULL, 0x040fe400078e021fULL, 0x00000001060c7824ULL, 0x040fe200078e0229ULL,
0x0000000427007388ULL, 0x0003e20000000800ULL, 0x00000001060a7824ULL, 0x000fc400078e0221ULL,
0x0000000106067824ULL, 0x000fe200078e0223ULL, 0x0000002017007388ULL, 0x0003e80000000800ULL,
0x0000001c19007388ULL, 0x0003e80000000800ULL, 0x000000181b007388ULL, 0x0003e80000000800ULL,
0x000000081d007388ULL, 0x0003e80000000800ULL, 0x000000121f007388ULL, 0x0003e80000000800ULL,
0x000000250a007388ULL, 0x0003e80000000800ULL, 0x0000000d06007388ULL, 0x0003e80000000800ULL,
0x000000050c007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x000f620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020050d7810ULL, 0x002fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008040f7824ULL, 0x020fe200078e00ffULL,
0x0000000706087812ULL, 0x000fe400078e4805ULL, 0x0000000702037812ULL, 0x000fe400078e480dULL,
0x0ffffff808077812ULL, 0x008fe400078ef805ULL, 0x0ffffff803037812ULL, 0x000fc400078ef80dULL,
0xfffffff80f027812ULL, 0x000fe200078ee202ULL, 0x0000001007087824ULL, 0x100fe200078e0200ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x000fe400078e0200ULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef86aULL,
0x00a0000008087984ULL, 0x000e660000000c00ULL, 0xfffffff807007812ULL, 0x000fe200078ee206ULL,
0x00a0000003107984ULL, 0x0007220000000c00ULL, 0x0000000705077812ULL, 0x000fc400078ec0ffULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef86aULL, 0x000000ffff037224ULL, 0x008fe200000e06ffULL,
0x00005a0006027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe400078248ffULL, 0x00005b0006037a11ULL, 0x000fc400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x002fe20000011663ULL, 0xffffffffff6c7424ULL, 0x000fc800078e00ffULL,
0x0000000264607824ULL, 0x000fca00078e0203ULL, 0x000000616000720cULL, 0x000fda0003f06070ULL,
0x0000000205038824ULL, 0x000fc800078e00ffULL, 0x0000640003088a24ULL, 0x000fc800078e0260ULL,
0x0000600008088625ULL, 0x000fe200078e0067ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000006086c8981ULL, 0x000ea2000c1e1900ULL, 0x00000001640a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004063007824ULL, 0x000fe400078e00ffULL, 0x0000008002027824ULL, 0x000fe200078e00ffULL,
0x000000170a00720cULL, 0x000fe20003f06070ULL, 0x00000100640b7824ULL, 0x000fe200078e0200ULL,
0x01460000ff067f8cULL, 0x000e62000c80043fULL, 0x0000008012037824ULL, 0x000fc600078e00ffULL,
0x0000004002187812ULL, 0x000fe200078ef80bULL, 0x000000036c257224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff217819ULL, 0x002fe40000011604ULL,
0x0000000b62087217ULL, 0x000fe40007800000ULL, 0x0000000821197810ULL, 0x040fe20007ffe0ffULL,
0x0000000118097824ULL, 0x000fe200078e0221ULL, 0x0000001821277810ULL, 0x040fe20007ffe0ffULL,
0x00000001080e7824ULL, 0x000fe200078e0a0bULL, 0x00000010211b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118087824ULL, 0x000fe200078e0219ULL, 0x0000000925097210ULL, 0x000fc40007f1e0ffULL,
0x00000003ff137819ULL, 0x000fe40000011604ULL, 0x000000300f237812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005e0009107a11ULL, 0x000fe400078048ffULL,
0x00002000630f7811ULL, 0x000fe400078e68ffULL, 0x00005f0009157a11ULL, 0x000fe200000f4c0aULL,
0x00000001180a7824ULL, 0x040fe200078e0227ULL, 0x0000000825147210ULL, 0x000fe20007f1e0ffULL,
0x0000000118097824ULL, 0x000fe200078e021bULL, 0x00000028211d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000a250a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00000009250d7210ULL, 0x000fe40007f3e0ffULL, 0x00005e00140b7a11ULL, 0x000fe200078048ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000a127a11ULL, 0x000fe200078448ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005f0014147a11ULL, 0x000fe400000f4c11ULL,
0x0000000313117812ULL, 0x000fc400078e4804ULL, 0x00005e000d0c7a11ULL, 0x000fe400078248ffULL,
0x00005f000a167a11ULL, 0x000fe200010f4c09ULL, 0x00000004190a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc11047812ULL, 0x000fe400078ef804ULL, 0x00005f000d0d7a11ULL, 0x000fe400008f4c08ULL,
0x0000001023087210ULL, 0x000fe20007f7e0ffULL, 0x000000041b107824ULL, 0x000fe200078e00ffULL,
0x0000000e2100720cULL, 0x080fe20003f06070ULL, 0x0000001004137824ULL, 0x000fe200078e020fULL,
0x0000000e1b00720cULL, 0x000fe20003f46070ULL, 0x000000ffff097224ULL, 0x000fe200018e0615ULL,
0xfffffffc0a047812ULL, 0x000fc400078ee211ULL, 0x00000020211b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e1900720cULL, 0x080fe20003f26070ULL, 0x0000001004157824ULL, 0x000fe200078e020fULL,
0xfffffffc10107812ULL, 0x000fe200078ee211ULL, 0x0000000118047824ULL, 0x000fe200078e021bULL,
0x000000230b0a7210ULL, 0x080fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x000000230c0c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001010197824ULL, 0x000fe200078e020fULL, 0x00000030211f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000427107824ULL, 0x000fe200078e00ffULL, 0x0000003821217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0614ULL, 0x0000000e1b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x0000000e2700720cULL, 0x000fc40003f86070ULL,
0x000000000a157faeULL, 0x0005e2000c901c46ULL, 0x0000000425097210ULL, 0x002fe40007f1e0ffULL,
0xfffffffc10047812ULL, 0x000fe200078ee211ULL, 0x000000000c197faeULL, 0x0003e2000d101c46ULL,
0x00005e0009147a11ULL, 0x000fe400078c48ffULL, 0x0000002312087210ULL, 0x000fe40007fbe0ffULL,
0x0000000e1d00720cULL, 0x080fe40003f46070ULL, 0x0000000e1f00720cULL, 0x080fe20003f26070ULL,
0x000000ffff0a7224ULL, 0x004fe200000e06ffULL, 0x0000000e2100720cULL, 0x000fe20003f06070ULL,
0x00000010040b7824ULL, 0x000fc400078e020fULL, 0x0000000118047824ULL, 0x040fe200078e021dULL,
0x00005f00090e7a11ULL, 0x000fe200030f4c0aULL, 0x000000ffff097224ULL, 0x000fe400028e0616ULL,
0x00000001180a7824ULL, 0x040fe200078e021fULL, 0x0000000425127210ULL, 0x000fe20007fbe0ffULL,
0x00000001180c7824ULL, 0x002fe200078e0221ULL, 0x00000000080b7faeULL, 0x0003e2000e101c46ULL,
0x0000000421167824ULL, 0x000fe200078e00ffULL, 0x0000000a25107210ULL, 0x000fe20007f9e0ffULL,
0x000000041b047824ULL, 0x000fe200078e00ffULL, 0x0000000c250d7210ULL, 0x000fe20007fde0ffULL,
0x000000041d0a7824ULL, 0x000fc400078e00ffULL, 0x000000041f0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc04047812ULL, 0x100fe400078ee211ULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee211ULL,
0xfffffffc16087812ULL, 0x002fe200078ee211ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e00120b7a11ULL, 0x000fe200078a48ffULL, 0x000000100a137824ULL, 0x000fe200078e020fULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee211ULL, 0x0000001008197824ULL, 0x000fe200078e020fULL,
0x00005f0012127a11ULL, 0x000fe200028f4c09ULL, 0x0000001004117824ULL, 0x100fe200078e020fULL,
0x0000002314087210ULL, 0x000fe20007fbe0ffULL, 0x000000100c157824ULL, 0x000fc400078e020fULL,
0x000000ffff0f7224ULL, 0x000fe200020e06ffULL, 0x00005e00100c7a11ULL, 0x040fe200078848ffULL,
0x000000ffff097224ULL, 0x000fe200028e060eULL, 0x000000230b0a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200030e06ffULL, 0x00005e000d0e7a11ULL, 0x040fe400078c48ffULL,
0x00005f00100f7a11ULL, 0x000fe200020f4c0fULL, 0x000000ffff0b7224ULL, 0x000fe200028e0612ULL,
0x000000230c0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000008117faeULL, 0x0003e2000d901c46ULL,
0x00005f000d047a11ULL, 0x000fc400030f4c04ULL, 0x000000230e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x000000000a137faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0604ULL, 0x000000000c157faeULL, 0x0003e8000c901c46ULL,
0x000000000e197faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000001804087211ULL, 0x042fe400078ff0ffULL, 0x00000008041d7811ULL, 0x000fc400078ff0ffULL,
0x0000000825087210ULL, 0x040fe40007f1e0ffULL, 0x00000018040b7811ULL, 0x040fe400078ff0ffULL,
0x0000002804107811ULL, 0x000fe200078ff0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0008227a11ULL, 0x000fe200078048ffULL, 0x00000001180c7824ULL, 0x000fe200078e020bULL,
0x00000020040d7811ULL, 0x000fe200078ff0ffULL, 0x00000004101a7824ULL, 0x000fe200078e00ffULL,
0x00005f0008247a11ULL, 0x000fe200000f4c09ULL, 0x0000000118087824ULL, 0x000fe200078e021dULL,
0x0000001004097811ULL, 0x000fe200078ff0ffULL, 0x00000001180e7824ULL, 0x000fe200078e020dULL,
0x0000003004127811ULL, 0x000fe200078ff0ffULL, 0x0000000118117824ULL, 0x040fe200078e0210ULL,
0x00000003ff197819ULL, 0x000fe20000011604ULL, 0x00000001180a7824ULL, 0x000fe200078e0209ULL,
0x0000003804147811ULL, 0x000fe200078ff0ffULL, 0x0000000118137824ULL, 0x000fe200078e0212ULL,
0x0000000825207210ULL, 0x040fe20007fde0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000c251c7210ULL, 0x000fe20007f1e0ffULL, 0x000000040b0c7824ULL, 0x000fe200078e00ffULL,
0x00000003191b7812ULL, 0x000fe200078e4804ULL, 0x000000041d087824ULL, 0x000fe200078e00ffULL,
0x0000000a25167210ULL, 0x000fe20007fbe0ffULL, 0x0000000118157824ULL, 0x000fe200078e0214ULL,
0x0000200063277811ULL, 0x000fe200078e68ffULL, 0x00000004090a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0c097812ULL, 0x100fe200078ee21bULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x00005e00201e7a11ULL, 0x000fe200078c48ffULL, 0x000000040d187824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a0b7812ULL, 0x000fe200078ee21bULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x0000000e250e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010091f7824ULL, 0x100fe200078e0227ULL,
0x0ffffffc1b107812ULL, 0x000fe200078ef804ULL, 0x000000100b237824ULL, 0x000fe200078e0227ULL,
0xfffffffc120c7812ULL, 0x100fe200078ee21bULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0xfffffffc08047812ULL, 0x000fe200078ee21bULL, 0x00000010102b7824ULL, 0x000fe200078e0227ULL,
0xfffffffc0a087812ULL, 0x000fe200078ee21bULL, 0x000000ffff297224ULL, 0x000fe200028e06ffULL,
0x00005f0020207a11ULL, 0x000fe200030f4c19ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0xfffffffc180a7812ULL, 0x000fe200078ee21bULL, 0x00000010081d7824ULL, 0x000fe200078e0227ULL,
0x0000001125117210ULL, 0x000fc40007f5e0ffULL, 0x0000001325137210ULL, 0x040fe20007f7e0ffULL,
0x000000100a217824ULL, 0x100fe200078e0227ULL, 0x0000001525157210ULL, 0x000fe20007f9e0ffULL,
0x000000100c257824ULL, 0x000fe200078e0227ULL, 0xfffffffc140d7812ULL, 0x000fe200078ee21bULL,
0x00000010041b7824ULL, 0x100fe200078e0227ULL, 0x00005e001c0b7a11ULL, 0x000fe200078048ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e000e107a11ULL, 0x000fe200078248ffULL,
0x000000100d277824ULL, 0x000fe200078e0227ULL, 0x000000300f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff047224ULL, 0x000fe200020e06ffULL, 0x00005e00160c7a11ULL, 0x000fc400078a48ffULL,
0x00005f001c1c7a11ULL, 0x000fe400000f4c19ULL, 0x00005f000e1a7a11ULL, 0x000fe400008f4c09ULL,
0x000000220f087210ULL, 0x000fe40007f1e0ffULL, 0x00005f00160d7a11ULL, 0x000fe200028f4c29ULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005e0011127a11ULL, 0x000fe200078248ffULL,
0x000000ffff097224ULL, 0x000fe200000e0624ULL, 0x00005e0013147a11ULL, 0x000fc400078448ffULL,
0x00005e0015187a11ULL, 0x000fe400078648ffULL, 0x00005f0011197a11ULL, 0x000fe200008f4c0aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082b7faeULL, 0x0003e2000b901c46ULL,
0x0000001e0f0a7210ULL, 0x000fe40007f1e0ffULL, 0x00005f0013167a11ULL, 0x000fe400010f4c16ULL,
0x0000000c0f0c7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0015047a11ULL, 0x000fc400018f4c04ULL,
0x0000000b0f0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0620ULL,
0x000000100f107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000120f127210ULL, 0x040fe40007f9e0ffULL, 0x000000140f147210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e061aULL, 0x000000180f187210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e061cULL, 0x000000000a1b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400020e0619ULL, 0x000000ffff157224ULL, 0x000fe200028e0616ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc600000e0604ULL,
0x000000000e1f7faeULL, 0x0003e8000b901c46ULL, 0x0000000010217faeULL, 0x0003e8000b901c46ULL,
0x0000000012237faeULL, 0x0003e8000b901c46ULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e4000b901c46ULL, 0x01460400ff097984ULL, 0x002e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000009ff7812ULL, 0x002fc60007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff047424ULL, 0x000fc800078e00ffULL,
0x0000000400087305ULL, 0x0002a4000021f000ULL, 0x3fa0000004047823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x01460400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000176400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x0000640005057a24ULL, 0x000fe200078e02ffULL,
0x0001468863067811ULL, 0x040fe200078e18ffULL, 0x0000002063087824ULL, 0x000fe200078e00ffULL,
0xffffffff17077810ULL, 0x000fe40007ffe0ffULL, 0x0000010064097824ULL, 0x000fe200078e0200ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000096200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x00000001640a7810ULL, 0x000fe20007ffe0ffULL,
0x0000006c036c7224ULL, 0x000fe200078e02ffULL, 0x00000040096d7812ULL, 0x000fe400078ec0ffULL,
0x000000170a00720cULL, 0x000fc60003f06070ULL, 0x00000001026d7824ULL, 0x000fd400078e026dULL,
0x000006a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1b7819ULL, 0x002fe40000011604ULL,
0x00000003046f7812ULL, 0x000fe400078ec0ffULL, 0x000000101b247810ULL, 0x040fe20007ffe0ffULL,
0x000000011b0b7824ULL, 0x140fe200078e026dULL, 0x000000201b277810ULL, 0x040fe40007ffe0ffULL,
0x000000081b1c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001240d7824ULL, 0x100fe200078e026dULL,
0x0000000b6c0b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000127117824ULL, 0x000fe200078e026dULL,
0x000000181b267810ULL, 0x000fc40007ffe0ffULL, 0x0000000d6c0d7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e000b127a11ULL, 0x000fe200078248ffULL,
0x00000001260f7824ULL, 0x100fe200078e026dULL, 0x000000281b287810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005f000b137a11ULL, 0x000fe200008f4c0aULL,
0x000000011c0b7824ULL, 0x000fe200078e026dULL, 0x000000116c117210ULL, 0x000fe40007f3e0ffULL,
0x00005e000d187a11ULL, 0x000fc400078648ffULL, 0x0000000b6c0b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e00110c7a11ULL, 0x000fe400078248ffULL,
0x00005f000d197a11ULL, 0x000fe200018f4c16ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005e000b147a11ULL, 0x000fe400078448ffULL, 0x00005f00110d7a11ULL, 0x000fe200008f4c0aULL,
0x00000001620a7824ULL, 0x000fe200078e0a09ULL, 0x00000003ff117819ULL, 0x000fc40000011604ULL,
0x0000000f6c0f7210ULL, 0x000fe40007f9e0ffULL, 0x00005f000b157a11ULL, 0x000fe400010f4c1aULL,
0x00000004110b7212ULL, 0x000fe200078e3cffULL, 0x000000ffff107224ULL, 0x000fe200020e06ffULL,
0x000000301b297810ULL, 0x040fe40007ffe0ffULL, 0x000000381b2a7810ULL, 0x000fe40007ffe0ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078848ffULL, 0x00000001291d7824ULL, 0x100fe200078e026dULL,
0x0000000a1c00720cULL, 0x0c0fe20003f26070ULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x000000030b0b7812ULL, 0x000fe200078ec0ffULL, 0x000000012a1f7824ULL, 0x100fe200078e026dULL,
0x0000000a1b00720cULL, 0x000fe20003f46070ULL, 0x00000001281b7824ULL, 0x000fe200078e026dULL,
0x00005f000f0f7a11ULL, 0x000fc400020f4c10ULL, 0x0000300063107811ULL, 0x000fe400078e68ffULL,
0x000000046f217812ULL, 0x000fe400078efcffULL, 0x0ffffffc0b717812ULL, 0x000fe400078ef804ULL,
0xfffffffc1c257812ULL, 0x000fe200078ee20bULL, 0x0000001021127825ULL, 0x000fe200078e0012ULL,
0x0000001b6c1b7210ULL, 0x040fe40007f9e0ffULL, 0x0000001d6c1d7210ULL, 0x040fe20007fbe0ffULL,
0x0000001071237824ULL, 0x100fe200078e0210ULL, 0x0000001f6c1f7210ULL, 0x000fe20007f7e0ffULL,
0x0000001025257824ULL, 0x000fe200078e0210ULL, 0x0000000a2a00720cULL, 0x080fe20003fc6070ULL,
0x0000001021147825ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012237faeULL, 0x0003e2000d101c46ULL, 0x0000000a2600720cULL, 0x000fc40003f46070ULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005e001b1a7a11ULL, 0x000fe200078848ffULL,
0x000000ffff207224ULL, 0x000fe200028e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078a48ffULL,
0x000000ffff167224ULL, 0x000fe200018e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078648ffULL,
0x0000000014257faeULL, 0x0005e2000c901c46ULL, 0x0000000a2400720cULL, 0x0c0fe20003f26070ULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x00005f001b1b7a11ULL, 0x000fe200020f4c22ULL,
0x0000000426267824ULL, 0x000fe200078e00ffULL, 0x00005f001d1d7a11ULL, 0x000fe200028f4c20ULL,
0x0000000429127824ULL, 0x002fe200078e00ffULL, 0x00005f001f1f7a11ULL, 0x000fe200018f4c16ULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000a2700720cULL, 0x080fe20003f66070ULL,
0x00000010210e7825ULL, 0x000fe200078e000eULL, 0x0000000a2800720cULL, 0x000fc40003f86070ULL,
0x0000000a2900720cULL, 0x000fe20003fa6070ULL, 0x00000004270a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc24237812ULL, 0x100fe200078ee20bULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0xfffffffc26257812ULL, 0x004fe200078ee20bULL, 0x00000010210c7825ULL, 0x000fe200078e000cULL,
0xfffffffc0a277812ULL, 0x100fe400078ee20bULL, 0xfffffffc28297812ULL, 0x100fe200078ee20bULL,
0x0000001023237824ULL, 0x000fe200078e0210ULL, 0xfffffffc122b7812ULL, 0x000fe200078ee20bULL,
0x0000001021127825ULL, 0x000fe200078e0018ULL, 0xfffffffc2a2d7812ULL, 0x000fc600078ee20bULL,
0x0000001025257824ULL, 0x100fe200078e0210ULL, 0x0000000012237faeULL, 0x0003e2000c901c46ULL,
0x0000001027277824ULL, 0x100fe400078e0210ULL, 0x0000001029297824ULL, 0x000fe200078e0210ULL,
0x000000000e257faeULL, 0x0003e2000d101c46ULL, 0x0000001021147825ULL, 0x000fc600078e001aULL,
0x000000000c277faeULL, 0x0003e2000d901c46ULL, 0x000000102b2b7824ULL, 0x000fe400078e0210ULL,
0x0000001021187825ULL, 0x000fe200078e001cULL, 0x0000000014297faeULL, 0x0003e6000e101c46ULL,
0x000000102d2d7824ULL, 0x000fe200078e0210ULL, 0x00000000182b7faeULL, 0x0003e2000e901c46ULL,
0x00000010211a7825ULL, 0x000fca00078e001eULL, 0x000000001a2d7faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000804207811ULL, 0x042fe400078ff0ffULL,
0x0000001004227811ULL, 0x040fe400078ff0ffULL, 0x0000006d040b7211ULL, 0x000fe200078ff0ffULL,
0x00000001200d7824ULL, 0x100fe200078e026dULL, 0x0000001804247811ULL, 0x000fe200078ff0ffULL,
0x00000001220f7824ULL, 0x100fe200078e026dULL, 0x0000000b6c117210ULL, 0x000fe20007f3e0ffULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x0000000d6c0d7210ULL, 0x000fe20007f5e0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x0000000f6c0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00000030042a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff107224ULL, 0x000fe200010e06ffULL, 0x00005e000d0e7a11ULL, 0x040fe200078448ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e06ffULL, 0x00005e000a0c7a11ULL, 0x000fe200078648ffULL,
0x000000012a197824ULL, 0x000fe200078e026dULL, 0x0000002804287811ULL, 0x000fe200078ff0ffULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x00005f000d0f7a11ULL, 0x000fc400010f4c10ULL,
0x00005f000a0d7a11ULL, 0x000fe200018f4c0bULL, 0x00000001240b7824ULL, 0x100fe200078e026dULL,
0x00005e0011127a11ULL, 0x040fe200078248ffULL, 0x0000000128157824ULL, 0x100fe200078e026dULL,
0x0000002004267811ULL, 0x000fe200078ff0ffULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x00005f0011137a11ULL, 0x000fe200008f4c14ULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0x0000000b6c1b7210ULL, 0x000fe20007f5e0ffULL, 0x0000000126117824ULL, 0x000fe200078e026dULL,
0x000000196c0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x000000156c107210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x000000116c167210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00005e001b147a11ULL, 0x000fe200078448ffULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x00005e000a1c7a11ULL, 0x000fe200078248ffULL, 0x000000ffff197224ULL, 0x000fe200018e06ffULL,
0x00005e00101a7a11ULL, 0x000fc400078848ffULL, 0x00005f001b157a11ULL, 0x000fe400010f4c1eULL,
0x00005f000a1d7a11ULL, 0x000fe400008f4c0bULL, 0x00005f00101b7a11ULL, 0x000fe400020f4c11ULL,
0x00000038040a7811ULL, 0x040fe400078ff0ffULL, 0x00000003ff117819ULL, 0x000fe40000011604ULL,
0x00000003046f7812ULL, 0x000fe200078ec0ffULL, 0x000000010a1f7824ULL, 0x040fe200078e026dULL,
0x00000004110b7212ULL, 0x000fe200078e3cffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x00005e0016187a11ULL, 0x000fc400078648ffULL, 0x000000030b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f6c1f7210ULL, 0x000fe40007f3e0ffULL, 0x0000300063107811ULL, 0x000fe400078e68ffULL,
0x000000046f2f7812ULL, 0x000fe400078efcffULL, 0x0ffffffc0b717812ULL, 0x000fe400078ef804ULL,
0xfffffffc20217812ULL, 0x000fe200078ee20bULL, 0x000000102f127825ULL, 0x000fe200078e0012ULL,
0xfffffffc0a2d7812ULL, 0x000fc400078ee20bULL, 0xfffffffc22237812ULL, 0x100fe200078ee20bULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0xfffffffc24257812ULL, 0x000fe200078ee20bULL,
0x0000001071317824ULL, 0x100fe200078e0210ULL, 0x00005e001f1e7a11ULL, 0x000fe200078248ffULL,
0x0000001021217824ULL, 0x000fe200078e0210ULL, 0x00005f0016197a11ULL, 0x000fe200018f4c19ULL,
0x000000102f0e7825ULL, 0x000fe200078e000eULL, 0xfffffffc26277812ULL, 0x100fe200078ee20bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012317faeULL, 0x0003e2000b901c46ULL,
0xfffffffc28297812ULL, 0x100fe200078ee20bULL, 0x0000001023237824ULL, 0x000fe200078e0210ULL,
0xfffffffc2a2b7812ULL, 0x000fe200078ee20bULL, 0x000000102f0c7825ULL, 0x000fe200078e000cULL,
0x00005f001f1f7a11ULL, 0x000fe200008f4c0aULL, 0x000000000e217faeULL, 0x0003e4000b901c46ULL,
0x0000001025257824ULL, 0x000fc400078e0210ULL, 0x000000102f147825ULL, 0x000fe200078e0014ULL,
0x000000000c237faeULL, 0x0003e6000b901c46ULL, 0x0000001027277824ULL, 0x000fe200078e0210ULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x000000102f187825ULL, 0x000fc800078e0018ULL,
0x0000001029297824ULL, 0x000fe200078e0210ULL, 0x0000000018277faeULL, 0x0003e2000b901c46ULL,
0x000000102f1a7825ULL, 0x000fc800078e001aULL, 0x000000102b2b7824ULL, 0x000fe200078e0210ULL,
0x000000001a297faeULL, 0x0003e2000b901c46ULL, 0x000000102f1c7825ULL, 0x000fc800078e001cULL,
0x000000102d2d7824ULL, 0x000fe200078e0210ULL, 0x000000001c2b7faeULL, 0x0003e2000b901c46ULL,
0x000000102f1e7825ULL, 0x000fca00078e001eULL, 0x000000001e2d7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff0a7819ULL, 0x000fe20000011604ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000007040d7812ULL, 0x002fe200078ec0ffULL, 0x0000200063707824ULL, 0x000fe200078e00ffULL,
0x000000020a247810ULL, 0x040fe20007ffe0ffULL, 0x000000080a0e7824ULL, 0x000fc600078e00ffULL,
0x00002000700c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee20dULL,
0x000000080d0d7812ULL, 0x000fe400078ef804ULL, 0x00000001ff0f7819ULL, 0x000fe2000001160eULL,
0x000000040e127824ULL, 0x000fe200078e00ffULL, 0x000000070a107812ULL, 0x000fe400078e780dULL,
0x000000100e137810ULL, 0x000fc40007ffe0ffULL, 0x000000200e147810ULL, 0x040fe40007ffe0ffULL,
0x000000300e157810ULL, 0x000fe20007ffe0ffULL, 0x000000200d0e7824ULL, 0x000fe200078e0210ULL,
0x000000030f107812ULL, 0x000fe200078ec0ffULL, 0x0000000413167824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011613ULL, 0x00000004141e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff137819ULL, 0x000fe20000011614ULL, 0x0000000415227824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe20000011615ULL, 0x000000100e0e7824ULL, 0x000fe200078e00ffULL,
0x000000030f147812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000003131c7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000318207812ULL, 0x000fe400078ec0ffULL, 0x00000001100f7812ULL, 0x100fe200078e7811ULL,
0x000000000e18783bULL, 0x0003e20000000200ULL, 0x0000000114497812ULL, 0x100fe400078e7811ULL,
0x000000011c4b7812ULL, 0x100fe400078e7811ULL, 0x00000001204d7812ULL, 0x000fc400078e7811ULL,
0x000000120f0f7212ULL, 0x000fe400078efcffULL, 0x0000001649497212ULL, 0x000fe400078efcffULL,
0x0000001e4b4b7212ULL, 0x000fe200078efcffULL, 0x000000100f6e7824ULL, 0x100fe200078e020cULL,
0x000000224d4d7212ULL, 0x000fe200078efcffULL, 0x00000010496b7824ULL, 0x100fe200078e020cULL,
0x0000000111117812ULL, 0x000fe200078ec0ffULL, 0x000000104b6a7824ULL, 0x100fe200078e020cULL,
0x000000006e3c783bULL, 0x000ea20000000200ULL, 0x000000104d697824ULL, 0x000fe200078e020cULL,
0x0000000210777812ULL, 0x000fc400078e1e11ULL, 0x000000006b38783bULL, 0x000ee20000000200ULL,
0x0000000724247812ULL, 0x000fe400078e780dULL, 0x0000000214757812ULL, 0x100fe200078e1e11ULL,
0x000000006a34783bULL, 0x000f220000000200ULL, 0x000000021c157812ULL, 0x100fe200078e1e11ULL,
0x000000200d0e7824ULL, 0x002fe200078e0224ULL, 0x0000000220737812ULL, 0x000fe200078e1e11ULL,
0x000000006940783bULL, 0x000e620000000200ULL, 0x0000001277777212ULL, 0x000fe200078efcffULL,
0x000000100e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001675757212ULL, 0x000fc400078efcffULL,
0x0000001e15157212ULL, 0x000fe200078efcffULL, 0x0000001077687824ULL, 0x100fe200078e020cULL,
0x0000002273737212ULL, 0x000fe200078efcffULL, 0x0000001075677824ULL, 0x100fe200078e020cULL,
0x000000000e20783bULL, 0x000fe20000000200ULL, 0x0000001015667824ULL, 0x100fe400078e020cULL,
0x0000001073657824ULL, 0x000fe200078e020cULL, 0x000000006844783bULL, 0x000f680000000200ULL,
0x000000006730783bULL, 0x000e680000000200ULL, 0x000000006628783bULL, 0x000e680000000200ULL,
0x000000006510783bULL, 0x000e620000000200ULL, 0x0000003c182c723cULL, 0x044ff000000018ffULL,
0x000000381854723cULL, 0x048ff000000018ffULL, 0x00000034181c723cULL, 0x050ff000000018ffULL,
0x0000003e183c723cULL, 0x040ff000000018ffULL, 0x0000003a1838723cULL, 0x040ff000000018ffULL,
0x000000361834723cULL, 0x040ff000000018ffULL, 0x000000401824723cULL, 0x042ff000000018ffULL,
0x000000421818723cULL, 0x000ff000000018ffULL, 0x00000044202c723cULL, 0x060ff0000000182cULL,
0x000000302054723cULL, 0x040ff00000001854ULL, 0x00000028201c723cULL, 0x040ff0000000181cULL,
0x000000462044723cULL, 0x040ff0000000183cULL, 0x000000322030723cULL, 0x040ff00000001838ULL,
0x0000002a2028723cULL, 0x040ff00000001834ULL, 0x000000102024723cULL, 0x040ff00000001824ULL,
0x000000122020723cULL, 0x000fe20000001818ULL, 0x0000064000008947ULL, 0x000fee0003800000ULL,
0x00000002ff0e7819ULL, 0x000fc80000011604ULL, 0x000000080e167810ULL, 0x040fe20007ffe0ffULL,
0x000000010e117824ULL, 0x140fe200078e026dULL, 0x000000100e3c7810ULL, 0x040fe40007ffe0ffULL,
0x000000180e3e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000116137824ULL, 0x100fe200078e026dULL,
0x000000116c117210ULL, 0x000fe20007f5e0ffULL, 0x000000013c197824ULL, 0x100fe200078e026dULL,
0x000000200e407810ULL, 0x000fe20007ffe0ffULL, 0x000000013e1b7824ULL, 0x000fe200078e026dULL,
0x000000136c137210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff147224ULL, 0x000fe200010e06ffULL,
0x000000196c357210ULL, 0x000fc40007f9e0ffULL, 0x0000001b6c377210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005e00111a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff367224ULL, 0x000fe200020e06ffULL, 0x00005e0013187a11ULL, 0x000fe200078648ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0035127a11ULL, 0x000fe400078848ffULL,
0x00005e0037107a11ULL, 0x000fe400078248ffULL, 0x000000280e427810ULL, 0x000fc40007ffe0ffULL,
0x00005f00111b7a11ULL, 0x000fe200010f4c14ULL, 0x0000000162147824ULL, 0x000fe200078e0a09ULL,
0x00005f0013197a11ULL, 0x000fe400018f4c34ULL, 0x00005f0035137a11ULL, 0x000fe200020f4c36ULL,
0x0000000140357824ULL, 0x100fe200078e026dULL, 0x00005f0037117a11ULL, 0x000fe200008f4c38ULL,
0x0000000142377824ULL, 0x000fe200078e026dULL, 0x000000300e437810ULL, 0x000fe40007ffe0ffULL,
0x000000356c357210ULL, 0x000fc40007f5e0ffULL, 0x000000376c377210ULL, 0x000fe20007f7e0ffULL,
0x0000000143397824ULL, 0x100fe200078e026dULL, 0x000000380e4a7810ULL, 0x040fe40007ffe0ffULL,
0x000000140e00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0e7224ULL, 0x000fe200010e06ffULL,
0x00005e0035387a11ULL, 0x000fe200078448ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078648ffULL, 0x000000014a3d7824ULL, 0x000fe200078e026dULL,
0x000000396c3b7210ULL, 0x000fc40007f9e0ffULL, 0x00005f0035397a11ULL, 0x000fe200010f4c0eULL,
0x00000010710e7824ULL, 0x000fe200078e020cULL, 0x00005f0037377a11ULL, 0x000fe200018f4c3aULL,
0x00000004163a7824ULL, 0x040fe200078e00ffULL, 0x000000141600720cULL, 0x000fe20003f46070ULL,
0x000000ffff487224ULL, 0x000fe200020e06ffULL, 0x0000003d6c167210ULL, 0x000fe40007f7e0ffULL,
0x000000086f3d7812ULL, 0x000fe400078efcffULL, 0xfffffffc3a3f7812ULL, 0x000fc400078ee20bULL,
0x00005e003b347a11ULL, 0x000fe200078848ffULL, 0x000000103d1a7825ULL, 0x000fe200078e001aULL,
0x000000144300720cULL, 0x080fe40003fa6070ULL, 0x00005f003b357a11ULL, 0x000fe200020f4c48ULL,
0x000000103f3f7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0e7faeULL, 0x0003e2000c901c46ULL, 0x000000103d187825ULL, 0x040fe200078e0018ULL,
0x000000143c00720cULL, 0x080fe40003f26070ULL, 0x000000144200720cULL, 0x080fe20003f86070ULL,
0x000000ffff3b7224ULL, 0x000fe200018e06ffULL, 0x00005e00163a7a11ULL, 0x000fe200078648ffULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x00000000183f7faeULL, 0x0005e2000d101c46ULL,
0x000000143e00720cULL, 0x0c0fe20003f46070ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x00005f00163b7a11ULL, 0x000fe200018f4c3bULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0xfffffffc3c417812ULL, 0x000fe200078ee20bULL, 0x000000103d127825ULL, 0x000fe200078e0012ULL,
0x000000144000720cULL, 0x000fc40003f66070ULL, 0x000000144a00720cULL, 0x000fe20003fc6070ULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000000443147824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e197812ULL, 0x104fe200078ee20bULL, 0x0000001041417824ULL, 0x000fe200078e020cULL,
0xfffffffc401b7812ULL, 0x102fe200078ee20bULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc143f7812ULL, 0x000fe200078ee20bULL, 0x000000103d107825ULL, 0x040fe200078e0010ULL,
0x0000000012417faeULL, 0x0003e4000c901c46ULL, 0xfffffffc4a437812ULL, 0x000fe200078ee20bULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d367825ULL, 0x000fc800078e0036ULL,
0x000000103d347825ULL, 0x000fc800078e0034ULL, 0x000000103d3a7825ULL, 0x000fe200078e003aULL,
0xfffffffc423d7812ULL, 0x000fc600078ee20bULL, 0x0000001019137824ULL, 0x102fe400078e020cULL,
0x000000101b197824ULL, 0x100fe400078e020cULL, 0x000000103d1b7824ULL, 0x100fe200078e020cULL,
0x0000000010137faeULL, 0x0003e2000d101c46ULL, 0x000000103f3d7824ULL, 0x100fe400078e020cULL,
0x00000010433f7824ULL, 0x000fe200078e020cULL, 0x0000000038197faeULL, 0x0003e8000d901c46ULL,
0x00000000361b7faeULL, 0x0003e8000e101c46ULL, 0x00000000343d7faeULL, 0x0003e8000e901c46ULL,
0x000000003a3f7faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000804147811ULL, 0x040fe400078ff0ffULL, 0x0000006d04117211ULL, 0x000fc400078ff0ffULL,
0x0000001004167811ULL, 0x000fe200078ff0ffULL, 0x0000000114137824ULL, 0x100fe200078e026dULL,
0x000000116c117210ULL, 0x000fe20007f3e0ffULL, 0x00000004144a7824ULL, 0x000fe200078e00ffULL,
0x00000018043c7811ULL, 0x000fe200078ff0ffULL, 0x00000004164c7824ULL, 0x000fe200078e00ffULL,
0x000000136c137210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e06ffULL,
0x00005e00111a7a11ULL, 0x000fe200078248ffULL, 0x000000013c197824ULL, 0x100fe200078e026dULL,
0x0000002804407811ULL, 0x000fe200078ff0ffULL, 0x000000ffff127224ULL, 0x000fe200010e06ffULL,
0x00005e0013107a11ULL, 0x000fe200078448ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x00005f00111b7a11ULL, 0x000fe200008f4c0eULL, 0x0000000140397824ULL, 0x100fe200078e026dULL,
0x00005f0013117a11ULL, 0x000fe200010f4c12ULL, 0x0000000116137824ULL, 0x000fe200078e026dULL,
0x00000020043e7811ULL, 0x000fe200078ff0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000000196c347210ULL, 0x000fc40007f5e0ffULL, 0x000000136c137210ULL, 0x000fe20007f3e0ffULL,
0x000000013e377824ULL, 0x000fe200078e026dULL, 0x000000396c397210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff357224ULL, 0x000fe200010e06ffULL, 0x00005e0034127a11ULL, 0x000fe200078448ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005e0013187a11ULL, 0x040fe200078248ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x000000376c377210ULL, 0x000fe20007f7e0ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x00005f0013197a11ULL, 0x000fc400008f4c0eULL,
0x00005f0034137a11ULL, 0x000fe200010f4c35ULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0x00005e0039347a11ULL, 0x040fe400078448ffULL, 0x0000003004427811ULL, 0x040fe400078ff0ffULL,
0x0000003804487811ULL, 0x000fe400078ff0ffULL, 0x00005f0039357a11ULL, 0x000fe200010f4c38ULL,
0x0000000142397824ULL, 0x100fe200078e026dULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x00000001483b7824ULL, 0x000fe200078e026dULL, 0x000000086f417812ULL, 0x000fe200078efcffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x00005f0037377a11ULL, 0x000fe200008f4c0eULL,
0x00000010710e7824ULL, 0x000fe200078e020cULL, 0x000000396c397210ULL, 0x040fe20007f3e0ffULL,
0x00000010411a7825ULL, 0x000fe200078e001aULL, 0x0000003b6c437210ULL, 0x000fc40007f5e0ffULL,
0xfffffffc4a3d7812ULL, 0x100fe200078ee20bULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0x00005e00393a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005e0043387a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0e7faeULL, 0x0003e2000b901c46ULL, 0x00005f00393b7a11ULL, 0x000fe200008f4c14ULL,
0x000000103d3d7824ULL, 0x000fe200078e020cULL, 0xfffffffc4c3f7812ULL, 0x000fe200078ee20bULL,
0x0000001041107825ULL, 0x000fe200078e0010ULL, 0x00005f0043397a11ULL, 0x000fc400010f4c16ULL,
0xfffffffc40437812ULL, 0x100fe200078ee20bULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0xfffffffc424f7812ULL, 0x000fe200078ee20bULL, 0x000000103f3f7824ULL, 0x000fe200078e020cULL,
0x00000000103d7faeULL, 0x0005e2000b901c46ULL, 0x0000001041187825ULL, 0x040fe200078e0018ULL,
0xfffffffc3c1b7812ULL, 0x102fe400078ee20bULL, 0xfffffffc48517812ULL, 0x000fe200078ee20bULL,
0x0000001041127825ULL, 0x040fe200078e0012ULL, 0x00000000183f7faeULL, 0x0003e6000b901c46ULL,
0x0000001041367825ULL, 0x000fc800078e0036ULL, 0x0000001041347825ULL, 0x000fc800078e0034ULL,
0x00000010413a7825ULL, 0x000fc800078e003aULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0xfffffffc3e417812ULL, 0x000fc600078ee20bULL, 0x000000101b117824ULL, 0x104fe400078e020cULL,
0x0000001041197824ULL, 0x102fe400078e020cULL, 0x00000010431b7824ULL, 0x100fe200078e020cULL,
0x0000000012117faeULL, 0x0003e2000b901c46ULL, 0x000000104f3d7824ULL, 0x100fe400078e020cULL,
0x00000010513f7824ULL, 0x000fe200078e020cULL, 0x0000000036197faeULL, 0x0003e8000b901c46ULL,
0x00000000341b7faeULL, 0x0003e8000b901c46ULL, 0x000000003a3d7faeULL, 0x0003e8000b901c46ULL,
0x00000000383f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000040a107810ULL, 0x002fc40007ffe0ffULL, 0x0000300070707810ULL, 0x000fe40007ffe0ffULL,
0x0000000710107812ULL, 0x100fe400078e780dULL, 0x000000060a147810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe400078e0270ULL, 0x000000200d107824ULL, 0x000fe200078e0210ULL,
0x0000000714147812ULL, 0x000fe200078e780dULL, 0x000000104b117824ULL, 0x000fe400078e0270ULL,
0x0000001010487824ULL, 0x000fc400078e00ffULL, 0x0000001049107824ULL, 0x100fe400078e0270ULL,
0x000000104d127824ULL, 0x000fe400078e0270ULL, 0x000000200d147824ULL, 0x000fe400078e0214ULL,
0x0000001077137824ULL, 0x000fe200078e0270ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000f5c783bULL, 0x000fe20000000200ULL, 0x0000001014347824ULL, 0x000fe400078e00ffULL,
0x0000001075147824ULL, 0x100fe200078e0270ULL, 0x000000004848783bULL, 0x000e620000000200ULL,
0x0000001015157824ULL, 0x100fe400078e0270ULL, 0x0000001073167824ULL, 0x000fe200078e0270ULL,
0x000000001058783bULL, 0x000ea80000000200ULL, 0x000000001150783bULL, 0x000ee80000000200ULL,
0x00000000124c783bULL, 0x000f280000000200ULL, 0x000000001340783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f680000000200ULL, 0x00000000143c783bULL, 0x000f280000000200ULL,
0x000000001538783bULL, 0x000f280000000200ULL, 0x000000001618783bULL, 0x000f220000000200ULL,
0x0000005c482c723cULL, 0x042ff0000000182cULL, 0x000000584854723cULL, 0x044ff00000001854ULL,
0x00000050481c723cULL, 0x048ff0000000181cULL, 0x0000005e4844723cULL, 0x040ff00000001844ULL,
0x0000005a4830723cULL, 0x040ff00000001830ULL, 0x000000524828723cULL, 0x040ff00000001828ULL,
0x0000004c4824723cULL, 0x050ff00000001824ULL, 0x0000004e4820723cULL, 0x000ff00000001820ULL,
0x00000040342c723cULL, 0x060ff0000000182cULL, 0x0000003c3454723cULL, 0x040ff00000001854ULL,
0x00000038341c723cULL, 0x040ff0000000181cULL, 0x000000423440723cULL, 0x040ff00000001844ULL,
0x0000003e343c723cULL, 0x040ff00000001830ULL, 0x0000003a3438723cULL, 0x040ff00000001828ULL,
0x000000183424723cULL, 0x040ff00000001824ULL, 0x0000001a3434723cULL, 0x000fe20000001820ULL,
0x0000064000008947ULL, 0x000fee0003800000ULL, 0x00000002ff287819ULL, 0x000fe20000011604ULL,
0x0000001071717824ULL, 0x000fc600078e0270ULL, 0x0000001828487810ULL, 0x040fe20007ffe0ffULL,
0x0000000128197824ULL, 0x140fe200078e026dULL, 0x0000000828327810ULL, 0x040fe40007ffe0ffULL,
0x0000001028467810ULL, 0x000fe20007ffe0ffULL, 0x0000000148237824ULL, 0x100fe200078e026dULL,
0x000000196c197210ULL, 0x000fe20007f5e0ffULL, 0x00000001321b7824ULL, 0x100fe200078e026dULL,
0x00000028284b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000146217824ULL, 0x000fe200078e026dULL,
0x000000236c2b7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000001b6c1b7210ULL, 0x000fc40007f7e0ffULL, 0x000000216c297210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200008e06ffULL, 0x00005e0019227a11ULL, 0x000fe200078448ffULL,
0x000000ffff307224ULL, 0x000fe200018e06ffULL, 0x00005e002b187a11ULL, 0x000fe200078248ffULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005f0019237a11ULL, 0x000fe400010f4c2aULL,
0x00005e001b207a11ULL, 0x000fe400078648ffULL, 0x00005f002b197a11ULL, 0x000fe200008f4c4aULL,
0x000000014b2b7824ULL, 0x000fe200078e026dULL, 0x00005e00291a7a11ULL, 0x000fc400078848ffULL,
0x00000020284a7810ULL, 0x040fe40007ffe0ffULL, 0x00000030284d7810ULL, 0x000fe40007ffe0ffULL,
0x00005f001b217a11ULL, 0x000fe400018f4c30ULL, 0x00005f00291b7a11ULL, 0x000fe200020f4c44ULL,
0x000000014a297824ULL, 0x100fe200078e026dULL, 0x0000002b6c2b7210ULL, 0x000fe20007f7e0ffULL,
0x000000014d317824ULL, 0x000fe200078e026dULL, 0x00000038284f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000162447824ULL, 0x000fe200078e0a09ULL, 0x000000296c297210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff4e7224ULL, 0x000fe200018e06ffULL, 0x000000316c337210ULL, 0x000fe20007f9e0ffULL,
0x000000014f457824ULL, 0x000fe200078e026dULL, 0x000000442800720cULL, 0x000fe20003f26070ULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e0029307a11ULL, 0x000fe200078448ffULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0x00005e002b2a7a11ULL, 0x000fc400078648ffULL,
0x00005e0033287a11ULL, 0x000fe400078848ffULL, 0x00005f0029317a11ULL, 0x000fe400010f4c4cULL,
0x00005f002b2b7a11ULL, 0x000fe400018f4c4eULL, 0x00005f0033297a11ULL, 0x000fe400020f4c50ULL,
0x000000456c337210ULL, 0x000fe40007f7e0ffULL, 0x000000443200720cULL, 0x0c0fe20003f46070ULL,
0x0000000432327824ULL, 0x000fe200078e00ffULL, 0x0000000c6f457812ULL, 0x000fe200078efcffULL,
0x000000ffff4c7224ULL, 0x000fe200018e06ffULL, 0x000000444b00720cULL, 0x000fc40003f86070ULL,
0xfffffffc32477812ULL, 0x000fe200078ee20bULL, 0x0000001045227825ULL, 0x000fe200078e0022ULL,
0x00005e0033327a11ULL, 0x000fe400078648ffULL, 0x000000444d00720cULL, 0x080fe20003fa6070ULL,
0x0000001047477824ULL, 0x000fe200078e0270ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022717faeULL, 0x0003e2000c901c46ULL, 0x0000001045207825ULL, 0x000fe200078e0020ULL,
0x000000444600720cULL, 0x0c0fe40003f26070ULL, 0x00005f0033337a11ULL, 0x000fe200018f4c4cULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x0000000020477faeULL, 0x0005e2000d101c46ULL,
0x000000444800720cULL, 0x0c0fe20003f46070ULL, 0x0000000448487824ULL, 0x000fe200078e00ffULL,
0x000000444a00720cULL, 0x0c0fe20003f66070ULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46497812ULL, 0x000fe200078ee20bULL, 0x000000044d227824ULL, 0x002fe200078e00ffULL,
0x000000444f00720cULL, 0x000fe20003fc6070ULL, 0x00000010451a7825ULL, 0x000fe200078e001aULL,
0xfffffffc4a237812ULL, 0x000fc600078ee20bULL, 0x000000044b207824ULL, 0x004fe200078e00ffULL,
0xfffffffc48217812ULL, 0x100fe200078ee20bULL, 0x0000001049497824ULL, 0x000fe200078e0270ULL,
0xfffffffc22477812ULL, 0x000fe200078ee20bULL, 0x000000044f447824ULL, 0x000fe400078e00ffULL,
0x0000001045187825ULL, 0x040fe200078e0018ULL, 0x000000001a497faeULL, 0x0003e4000c901c46ULL,
0xfffffffc444b7812ULL, 0x000fe200078ee20bULL, 0x0000001045307825ULL, 0x000fc800078e0030ULL,
0x00000010452a7825ULL, 0x000fc800078e002aULL, 0x0000001045287825ULL, 0x000fc800078e0028ULL,
0x0000001045327825ULL, 0x000fe200078e0032ULL, 0xfffffffc20457812ULL, 0x000fc600078ee20bULL,
0x00000010211b7824ULL, 0x102fe400078e0270ULL, 0x0000001023217824ULL, 0x100fe400078e0270ULL,
0x0000001045237824ULL, 0x100fe200078e0270ULL, 0x00000000181b7faeULL, 0x0003e2000d101c46ULL,
0x0000001047457824ULL, 0x100fe400078e0270ULL, 0x000000104b477824ULL, 0x000fe200078e0270ULL,
0x0000000030217faeULL, 0x0003e8000d901c46ULL, 0x000000002a237faeULL, 0x0003e8000e101c46ULL,
0x0000000028457faeULL, 0x0003e8000e901c46ULL, 0x0000000032477faeULL, 0x0003e2000f101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000804307811ULL, 0x040fe200078ff0ffULL,
0x0000001071717824ULL, 0x000fe200078e0270ULL, 0x0000006d04197211ULL, 0x000fc400078ff0ffULL,
0x0000001004327811ULL, 0x000fe200078ff0ffULL, 0x00000001301b7824ULL, 0x100fe200078e026dULL,
0x000000196c197210ULL, 0x000fe20007f3e0ffULL, 0x0000000430527824ULL, 0x000fe200078e00ffULL,
0x0000001804447811ULL, 0x000fe200078ff0ffULL, 0x0000000432587824ULL, 0x000fe200078e00ffULL,
0x0000001b6c1b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005e0019227a11ULL, 0x000fe200078248ffULL, 0x0000000144217824ULL, 0x100fe200078e026dULL,
0x00000028044a7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x00005e001b187a11ULL, 0x000fe200078448ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x00005f0019237a11ULL, 0x000fe200008f4c1aULL, 0x000000014a317824ULL, 0x100fe200078e026dULL,
0x00005f001b197a11ULL, 0x000fe200010f4c20ULL, 0x00000001321b7824ULL, 0x000fe200078e026dULL,
0x0000002004467811ULL, 0x000fe200078ff0ffULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x000000216c297210ULL, 0x000fc40007f5e0ffULL, 0x0000001b6c1b7210ULL, 0x000fe20007f3e0ffULL,
0x00000001462b7824ULL, 0x000fe200078e026dULL, 0x000000316c317210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e00291a7a11ULL, 0x000fe200078448ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x00005e001b207a11ULL, 0x040fe200078248ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000002b6c2b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005f001b217a11ULL, 0x000fc400008f4c28ULL,
0x00005f00291b7a11ULL, 0x000fe200010f4c2aULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005e0031287a11ULL, 0x040fe400078448ffULL, 0x00000030044e7811ULL, 0x040fe400078ff0ffULL,
0x0000003804507811ULL, 0x000fe400078ff0ffULL, 0x00005f0031297a11ULL, 0x000fe200010f4c4cULL,
0x000000014e317824ULL, 0x100fe200078e026dULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x0000000150337824ULL, 0x000fe200078e026dULL, 0x0000000c6f497812ULL, 0x000fe200078efcffULL,
0x000000044e4e7824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c48ULL,
0x0000000450507824ULL, 0x000fe200078e00ffULL, 0x000000316c317210ULL, 0x040fe20007f3e0ffULL,
0x0000001049227825ULL, 0x000fe200078e0022ULL, 0x000000336c4b7210ULL, 0x000fc40007f5e0ffULL,
0xfffffffc52457812ULL, 0x100fe200078ee20bULL, 0x000000ffff487224ULL, 0x000fe200008e06ffULL,
0x00005e0031327a11ULL, 0x000fe200078248ffULL, 0x000000ffff4c7224ULL, 0x000fe200010e06ffULL,
0x00005e004b307a11ULL, 0x000fe200078448ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022717faeULL, 0x0003e2000b901c46ULL, 0x00005f0031337a11ULL, 0x000fe200008f4c48ULL,
0x0000001045457824ULL, 0x000fe200078e0270ULL, 0xfffffffc58477812ULL, 0x000fe200078ee20bULL,
0x0000001049187825ULL, 0x000fe200078e0018ULL, 0x00005f004b317a11ULL, 0x000fc400010f4c4cULL,
0xfffffffc4a4b7812ULL, 0x100fe200078ee20bULL, 0x0000001047477824ULL, 0x000fe200078e0270ULL,
0xfffffffc4e4d7812ULL, 0x000fe200078ee20bULL, 0x0000001049207825ULL, 0x040fe200078e0020ULL,
0x0000000018457faeULL, 0x0005e2000b901c46ULL, 0xfffffffc44237812ULL, 0x002fe400078ee20bULL,
0x00000010491a7825ULL, 0x040fe200078e001aULL, 0xfffffffc504f7812ULL, 0x000fe200078ee20bULL,
0x0000000020477faeULL, 0x0003e4000b901c46ULL, 0x00000010492a7825ULL, 0x000fc800078e002aULL,
0x0000001049287825ULL, 0x000fc800078e0028ULL, 0x0000001049327825ULL, 0x000fc800078e0032ULL,
0x0000001049307825ULL, 0x000fe200078e0030ULL, 0xfffffffc46497812ULL, 0x000fc600078ee20bULL,
0x0000001023197824ULL, 0x104fe400078e0270ULL, 0x0000001049217824ULL, 0x102fe400078e0270ULL,
0x000000104b237824ULL, 0x100fe200078e0270ULL, 0x000000001a197faeULL, 0x0003e2000b901c46ULL,
0x000000104d457824ULL, 0x100fe400078e0270ULL, 0x000000104f477824ULL, 0x000fe200078e0270ULL,
0x000000002a217faeULL, 0x0003e8000b901c46ULL, 0x0000000028237faeULL, 0x0003e8000b901c46ULL,
0x0000000032457faeULL, 0x0003e8000b901c46ULL, 0x0000000030477faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000080a187810ULL, 0x002fc80007ffe0ffULL,
0x0000000718187812ULL, 0x000fca00078e780dULL, 0x000000200d187824ULL, 0x000fc800078e0218ULL,
0x0000001018447824ULL, 0x000fe200078e00ffULL, 0x0000000a0a187810ULL, 0x000fc80007ffe0ffULL,
0x0000000718187812ULL, 0x000fe200078e780dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006e5c783bULL, 0x000fe20000000200ULL, 0x000000200d187824ULL, 0x000fc600078e0218ULL,
0x000000004444783bULL, 0x000e620000000200ULL, 0x0000001018287824ULL, 0x000fc600078e00ffULL,
0x000000006b50783bULL, 0x000ea80000000200ULL, 0x000000006a4c783bULL, 0x000ee80000000200ULL,
0x000000006948783bULL, 0x000f280000000200ULL, 0x000000006858783bULL, 0x000fe80000000200ULL,
0x000000002828783bULL, 0x000f680000000200ULL, 0x000000006718783bULL, 0x000f280000000200ULL,
0x000000006620783bULL, 0x000f280000000200ULL, 0x000000006530783bULL, 0x000f220000000200ULL,
0x0000005c442c723cULL, 0x042ff0000000182cULL, 0x000000504454723cULL, 0x044ff00000001854ULL,
0x0000004c441c723cULL, 0x048ff0000000181cULL, 0x0000005e4440723cULL, 0x040ff00000001840ULL,
0x00000052443c723cULL, 0x040ff0000000183cULL, 0x0000004e4438723cULL, 0x040ff00000001838ULL,
0x000000484424723cULL, 0x050ff00000001824ULL, 0x0000004a4434723cULL, 0x000ff00000001834ULL,
0x00000058282c723cULL, 0x060ff0000000182cULL, 0x000000182854723cULL, 0x040ff00000001854ULL,
0x00000020281c723cULL, 0x040ff0000000181cULL, 0x0000005a2858723cULL, 0x040ff00000001840ULL,
0x0000001a2818723cULL, 0x040ff0000000183cULL, 0x000000222820723cULL, 0x040ff00000001838ULL,
0x000000302824723cULL, 0x040ff00000001824ULL, 0x000000322828723cULL, 0x000fe20000001834ULL,
0x0000063000008947ULL, 0x000fee0003800000ULL, 0x00000002ff397819ULL, 0x000fe20000011604ULL,
0x0000000162407824ULL, 0x000fc600078e0a09ULL, 0x00000008393d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000139317824ULL, 0x140fe200078e026dULL, 0x0000001839447810ULL, 0x040fe40007ffe0ffULL,
0x0000001039427810ULL, 0x000fe20007ffe0ffULL, 0x000000013d337824ULL, 0x100fe200078e026dULL,
0x000000316c317210ULL, 0x000fe20007f3e0ffULL, 0x00000001443b7824ULL, 0x100fe200078e026dULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x0000000142357824ULL, 0x100fe200078e026dULL,
0x000000336c337210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e0031347a11ULL, 0x000fe200078248ffULL, 0x00000001473f7824ULL, 0x000fe200078e026dULL,
0x0000003b6c3b7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0033307a11ULL, 0x000fe200078448ffULL, 0x000000043d4a7824ULL, 0x000fe200078e00ffULL,
0x000000356c377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005f0031357a11ULL, 0x000fc400008f4c32ULL, 0x00005f0033317a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e003b327a11ULL, 0x000fe400078448ffULL,
0x0000002039467810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b337a11ULL, 0x000fe400010f4c3aULL,
0x0000003039487810ULL, 0x000fe20007ffe0ffULL, 0x00000001463b7824ULL, 0x000fe200078e026dULL,
0x0000003f6c3f7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0037367a11ULL, 0x040fe200078248ffULL,
0x0000000148417824ULL, 0x000fe200078e026dULL, 0x0000003b6c3b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x00005f0037377a11ULL, 0x000fe400008f4c38ULL,
0x00005e003f387a11ULL, 0x000fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x000000416c417210ULL, 0x000fe40007f9e0ffULL, 0x00005e003b3a7a11ULL, 0x000fc400078448ffULL,
0x0000003839497810ULL, 0x040fe40007ffe0ffULL, 0x000000403900720cULL, 0x080fe40003f26070ULL,
0x00005f003f397a11ULL, 0x000fe200018f4c3eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL, 0x00000001493f7824ULL, 0x000fe200078e026dULL,
0x00005e00413c7a11ULL, 0x000fe400078648ffULL, 0x000000403d00720cULL, 0x000fc40003f46070ULL,
0x00005f00413d7a11ULL, 0x000fe400018f4c3eULL, 0x0000003f6c457210ULL, 0x000fe40007f9e0ffULL,
0x000000106f417812ULL, 0x000fe400078efcffULL, 0xfffffffc4a3f7812ULL, 0x000fe200078ee20bULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005e00453e7a11ULL, 0x000fe200078648ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x000000404800720cULL, 0x000fc40003fa6070ULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x000000103f437824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000340e7faeULL, 0x0003e2000c901c46ULL,
0x0000001041307825ULL, 0x000fe200078e0030ULL, 0x000000404200720cULL, 0x0c0fe40003f26070ULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x0000000030437faeULL, 0x0005e2000d101c46ULL, 0x000000404400720cULL, 0x0c0fe20003f46070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000404600720cULL, 0x0c0fe20003f66070ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc42457812ULL, 0x100fe200078ee20bULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x000000404900720cULL, 0x040fe20003fc6070ULL,
0x0000000449347824ULL, 0x002fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc44317812ULL, 0x004fc600078ee20bULL,
0x0000000447307824ULL, 0x000fe200078e00ffULL, 0xfffffffc48437812ULL, 0x000fe200078ee20bULL,
0x0000001041327825ULL, 0x000fe200078e0032ULL, 0xfffffffc34477812ULL, 0x000fc600078ee20bULL,
0x00000010413a7825ULL, 0x000fc800078e003aULL, 0x0000001041387825ULL, 0x000fc800078e0038ULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0xfffffffc30417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e020cULL,
0x0000001031317824ULL, 0x100fe400078e020cULL, 0x0000001035357824ULL, 0x100fe200078e020cULL,
0x0000000036457faeULL, 0x0003e2000c901c46ULL, 0x0000001041417824ULL, 0x100fe400078e020cULL,
0x0000001043437824ULL, 0x100fe200078e020cULL, 0x0000000032317faeULL, 0x0003e2000d101c46ULL,
0x0000001047477824ULL, 0x000fc600078e020cULL, 0x000000003a357faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e8000e101c46ULL, 0x000000003c437faeULL, 0x0003e8000e901c46ULL,
0x000000003e477faeULL, 0x0003e2000f101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008043c7811ULL, 0x040fe400078ff0ffULL, 0x0000006d04317211ULL, 0x000fc400078ff0ffULL,
0x00000010043e7811ULL, 0x000fe200078ff0ffULL, 0x000000013c337824ULL, 0x100fe200078e026dULL,
0x000000316c317210ULL, 0x000fe20007f3e0ffULL, 0x000000043c4e7824ULL, 0x000fe200078e00ffULL,
0x0000001804407811ULL, 0x000fe200078ff0ffULL, 0x000000013e357824ULL, 0x000fe200078e026dULL,
0x000000336c337210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00005e0031367a11ULL, 0x000fe200078248ffULL, 0x000000043e507824ULL, 0x000fe200078e00ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e0033307a11ULL, 0x000fc400078448ffULL, 0x00005f0031377a11ULL, 0x000fe200008f4c32ULL,
0x0000000142397824ULL, 0x100fe200078e026dULL, 0x00005f0033317a11ULL, 0x000fe200010f4c34ULL,
0x0000000140337824ULL, 0x100fe200078e026dULL, 0x000000356c357210ULL, 0x000fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x000000336c337210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078248ffULL,
0x00000001463b7824ULL, 0x100fe200078e026dULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078448ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4c38ULL,
0x000000014a3f7824ULL, 0x000fe200078e026dULL, 0x000000396c397210ULL, 0x000fe20007f3e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00005f0033337a11ULL, 0x000fc400010f4c3aULL,
0x0000003b6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e00393a7a11ULL, 0x000fe400078248ffULL, 0x00000038044c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d387a11ULL, 0x000fe400078448ffULL,
0x00005f00393b7a11ULL, 0x000fe400008f4c44ULL, 0x00005f003d397a11ULL, 0x000fe200010f4c48ULL,
0x000000014c3d7824ULL, 0x000fe200078e026dULL, 0x0000003f6c3f7210ULL, 0x000fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x000000106f417812ULL, 0x000fc400078efcffULL,
0x0000003d6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078248ffULL, 0x0000001041367825ULL, 0x000fe200078e0036ULL,
0xfffffffc4e437812ULL, 0x100fe400078ee20bULL, 0x00005f003f3f7a11ULL, 0x000fe200008f4c44ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x0000001043437824ULL, 0x000fe200078e020cULL, 0xfffffffc50457812ULL, 0x000fe200078ee20bULL,
0x0000001041307825ULL, 0x000fe200078e0030ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c48ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000360e7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc46477812ULL, 0x000fe200078ee20bULL, 0x0000001041347825ULL, 0x040fe200078e0034ULL,
0xfffffffc4a497812ULL, 0x000fe200078ee20bULL, 0x0000000030437faeULL, 0x0005e4000b901c46ULL,
0x0000001041327825ULL, 0x000fc800078e0032ULL, 0x00000010413a7825ULL, 0x000fe200078e003aULL,
0xfffffffc40377812ULL, 0x002fc600078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0xfffffffc4c317812ULL, 0x004fc600078ee20bULL, 0x00000010413e7825ULL, 0x000fc800078e003eULL,
0x00000010413c7825ULL, 0x000fe200078e003cULL, 0xfffffffc42417812ULL, 0x000fc600078ee20bULL,
0x0000001045457824ULL, 0x100fe400078e020cULL, 0x0000001037377824ULL, 0x100fe400078e020cULL,
0x0000001041417824ULL, 0x100fe200078e020cULL, 0x0000000034457faeULL, 0x0003e2000b901c46ULL,
0x0000001047477824ULL, 0x100fe400078e020cULL, 0x0000001049497824ULL, 0x100fe200078e020cULL,
0x0000000032377faeULL, 0x0003e2000b901c46ULL, 0x0000001031317824ULL, 0x000fc600078e020cULL,
0x000000003a417faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x000000003c317faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000c0a307810ULL, 0x000fc80007ffe0ffULL,
0x0000000730307812ULL, 0x000fca00078e780dULL, 0x000000200d307824ULL, 0x000fc800078e0230ULL,
0x0000001030447824ULL, 0x000fe200078e00ffULL, 0x0000000e0a307810ULL, 0x000fc80007ffe0ffULL,
0x0000000730307812ULL, 0x000fe200078e780dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000f5c783bULL, 0x000fe20000000200ULL, 0x000000200d307824ULL, 0x000fc600078e0230ULL,
0x000000004444783bULL, 0x002e620000000200ULL, 0x0000001030307824ULL, 0x000fc600078e00ffULL,
0x000000001050783bULL, 0x000ea80000000200ULL, 0x00000000114c783bULL, 0x000ee80000000200ULL,
0x000000001248783bULL, 0x000f280000000200ULL, 0x000000001340783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000f680000000200ULL, 0x00000000143c783bULL, 0x000ee80000000200ULL,
0x000000001538783bULL, 0x000ee80000000200ULL, 0x000000001634783bULL, 0x000ee20000000200ULL,
0x0000005c442c723cULL, 0x042ff0000000182cULL, 0x0000005e4458723cULL, 0x040ff00000001858ULL,
0x000000504454723cULL, 0x044ff00000001854ULL, 0x000000524418723cULL, 0x040ff00000001818ULL,
0x0000004c441c723cULL, 0x048ff0000000181cULL, 0x0000004e4420723cULL, 0x040ff00000001820ULL,
0x000000484424723cULL, 0x050ff00000001824ULL, 0x0000004a4428723cULL, 0x000ff00000001828ULL,
0x00000040302c723cULL, 0x060ff0000000182cULL, 0x000000423058723cULL, 0x040ff00000001858ULL,
0x0000003c3054723cULL, 0x040ff00000001854ULL, 0x0000003e3018723cULL, 0x040ff00000001818ULL,
0x00000038301c723cULL, 0x040ff0000000181cULL, 0x0000003a3020723cULL, 0x040ff00000001820ULL,
0x000000343024723cULL, 0x040ff00000001824ULL, 0x000000363030723cULL, 0x000fe20000001828ULL,
0x0000063000008947ULL, 0x000fee0003800000ULL, 0x00000002ff397819ULL, 0x000fe20000011604ULL,
0x0000000162407824ULL, 0x000fc600078e0a09ULL, 0x00000008393d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000139297824ULL, 0x140fe200078e026dULL, 0x0000001839447810ULL, 0x040fe40007ffe0ffULL,
0x0000001039427810ULL, 0x000fe20007ffe0ffULL, 0x000000013d2b7824ULL, 0x100fe200078e026dULL,
0x000000296c297210ULL, 0x000fe20007f3e0ffULL, 0x00000001443b7824ULL, 0x100fe200078e026dULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x0000000142357824ULL, 0x100fe200078e026dULL,
0x0000002b6c2b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029347a11ULL, 0x000fe200078248ffULL, 0x00000001473f7824ULL, 0x000fe200078e026dULL,
0x0000003b6c3b7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fe200078448ffULL, 0x000000043d4a7824ULL, 0x000fe200078e00ffULL,
0x000000356c377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005f0029357a11ULL, 0x000fc400008f4c2aULL, 0x00005f002b297a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e003b2a7a11ULL, 0x000fe400078448ffULL,
0x0000002039467810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b2b7a11ULL, 0x000fe400010f4c3aULL,
0x0000003039487810ULL, 0x000fe20007ffe0ffULL, 0x00000001463b7824ULL, 0x000fe200078e026dULL,
0x0000003f6c3f7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0037367a11ULL, 0x040fe200078248ffULL,
0x0000000148417824ULL, 0x000fe200078e026dULL, 0x0000003b6c3b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x00005f0037377a11ULL, 0x000fe400008f4c38ULL,
0x00005e003f387a11ULL, 0x000fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x000000416c417210ULL, 0x000fe40007f9e0ffULL, 0x00005e003b3a7a11ULL, 0x000fc400078448ffULL,
0x0000003839497810ULL, 0x040fe40007ffe0ffULL, 0x000000403900720cULL, 0x080fe40003f26070ULL,
0x00005f003f397a11ULL, 0x000fe200018f4c3eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL, 0x00000001493f7824ULL, 0x000fe200078e026dULL,
0x00005e00413c7a11ULL, 0x000fe400078648ffULL, 0x000000403d00720cULL, 0x000fc40003f46070ULL,
0x00005f00413d7a11ULL, 0x000fe400018f4c3eULL, 0x0000003f6c457210ULL, 0x000fe40007f9e0ffULL,
0x000000146f417812ULL, 0x000fe400078efcffULL, 0xfffffffc4a3f7812ULL, 0x000fe200078ee20bULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005e00453e7a11ULL, 0x000fe200078648ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x000000404800720cULL, 0x000fc40003fa6070ULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x000000103f437824ULL, 0x000fe200078e0270ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034717faeULL, 0x0003e2000c901c46ULL,
0x0000001041287825ULL, 0x000fe200078e0028ULL, 0x000000404200720cULL, 0x0c0fe40003f26070ULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x0000000028437faeULL, 0x0005e2000d101c46ULL, 0x000000404400720cULL, 0x0c0fe20003f46070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000404600720cULL, 0x0c0fe20003f66070ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc42457812ULL, 0x100fe200078ee20bULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x000000404900720cULL, 0x040fe20003fc6070ULL,
0x0000000449347824ULL, 0x002fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc44297812ULL, 0x004fc600078ee20bULL,
0x0000000447287824ULL, 0x000fe200078e00ffULL, 0xfffffffc48437812ULL, 0x000fe200078ee20bULL,
0x00000010412a7825ULL, 0x000fe200078e002aULL, 0xfffffffc34477812ULL, 0x000fc600078ee20bULL,
0x00000010413a7825ULL, 0x000fc800078e003aULL, 0x0000001041387825ULL, 0x000fc800078e0038ULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0xfffffffc28417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e0270ULL,
0x0000001029297824ULL, 0x100fe400078e0270ULL, 0x0000001035357824ULL, 0x100fe200078e0270ULL,
0x0000000036457faeULL, 0x0003e2000c901c46ULL, 0x0000001041417824ULL, 0x100fe400078e0270ULL,
0x0000001043437824ULL, 0x100fe200078e0270ULL, 0x000000002a297faeULL, 0x0003e2000d101c46ULL,
0x0000001047477824ULL, 0x000fc600078e0270ULL, 0x000000003a357faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e8000e101c46ULL, 0x000000003c437faeULL, 0x0003e8000e901c46ULL,
0x000000003e477faeULL, 0x0003e2000f101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008043c7811ULL, 0x040fe400078ff0ffULL, 0x0000006d04297211ULL, 0x000fc400078ff0ffULL,
0x00000010043e7811ULL, 0x000fe200078ff0ffULL, 0x000000013c2b7824ULL, 0x100fe200078e026dULL,
0x000000296c297210ULL, 0x000fe20007f3e0ffULL, 0x000000043c4e7824ULL, 0x000fe200078e00ffULL,
0x0000001804407811ULL, 0x000fe200078ff0ffULL, 0x000000013e357824ULL, 0x000fe200078e026dULL,
0x0000002b6c2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029367a11ULL, 0x000fe200078248ffULL, 0x000000043e507824ULL, 0x000fe200078e00ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x00005f0029377a11ULL, 0x000fe200008f4c2aULL,
0x0000000142397824ULL, 0x100fe200078e026dULL, 0x00005f002b297a11ULL, 0x000fe200010f4c34ULL,
0x00000001402b7824ULL, 0x100fe200078e026dULL, 0x000000356c357210ULL, 0x000fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000002b6c2b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078248ffULL,
0x00000001463b7824ULL, 0x100fe200078e026dULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078448ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4c38ULL,
0x000000014a3f7824ULL, 0x000fe200078e026dULL, 0x000000396c397210ULL, 0x000fe20007f3e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fc400010f4c3aULL,
0x0000003b6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e00393a7a11ULL, 0x000fe400078248ffULL, 0x00000038044c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d387a11ULL, 0x000fe400078448ffULL,
0x00005f00393b7a11ULL, 0x000fe400008f4c44ULL, 0x00005f003d397a11ULL, 0x000fe200010f4c48ULL,
0x000000014c3d7824ULL, 0x000fe200078e026dULL, 0x0000003f6c3f7210ULL, 0x000fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x000000146f417812ULL, 0x000fc400078efcffULL,
0x0000003d6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078248ffULL, 0x0000001041367825ULL, 0x000fe200078e0036ULL,
0xfffffffc4e437812ULL, 0x100fe400078ee20bULL, 0x00005f003f3f7a11ULL, 0x000fe200008f4c44ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x0000001043437824ULL, 0x000fe200078e0270ULL, 0xfffffffc50457812ULL, 0x000fe200078ee20bULL,
0x0000001041287825ULL, 0x000fe200078e0028ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c48ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036717faeULL, 0x0003e2000b901c46ULL,
0xfffffffc46477812ULL, 0x000fe200078ee20bULL, 0x0000001041347825ULL, 0x040fe200078e0034ULL,
0xfffffffc4a497812ULL, 0x000fe200078ee20bULL, 0x0000000028437faeULL, 0x0005e4000b901c46ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x00000010413a7825ULL, 0x000fe200078e003aULL,
0xfffffffc40377812ULL, 0x002fc600078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0xfffffffc4c297812ULL, 0x004fc600078ee20bULL, 0x00000010413e7825ULL, 0x000fc800078e003eULL,
0x00000010413c7825ULL, 0x000fe200078e003cULL, 0xfffffffc42417812ULL, 0x000fc600078ee20bULL,
0x0000001045457824ULL, 0x100fe400078e0270ULL, 0x0000001037377824ULL, 0x100fe400078e0270ULL,
0x0000001041417824ULL, 0x100fe200078e0270ULL, 0x0000000034457faeULL, 0x0003e2000b901c46ULL,
0x0000001047477824ULL, 0x100fe400078e0270ULL, 0x0000001049497824ULL, 0x100fe200078e0270ULL,
0x000000002a377faeULL, 0x0003e2000b901c46ULL, 0x0000001029297824ULL, 0x000fc600078e0270ULL,
0x000000003a417faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x000000003c297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000100a287810ULL, 0x000fc40007ffe0ffULL,
0x000000120a347810ULL, 0x002fe40007ffe0ffULL, 0x0000000728287812ULL, 0x100fe400078e780dULL,
0x0000000734347812ULL, 0x000fc600078e780dULL, 0x000000200d287824ULL, 0x040fe400078e0228ULL,
0x000000200d347824ULL, 0x000fe400078e0234ULL, 0x0000001028487824ULL, 0x000fe400078e00ffULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006e28783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x000000006b5c783bULL, 0x000ea80000000200ULL, 0x000000006a50783bULL, 0x000ee80000000200ULL,
0x00000000694c783bULL, 0x000f280000000200ULL, 0x000000006844783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f680000000200ULL, 0x000000006740783bULL, 0x000ee80000000200ULL,
0x00000000663c783bULL, 0x000ee80000000200ULL, 0x000000006538783bULL, 0x000ee20000000200ULL,
0x00000028482c723cULL, 0x042ff0000000182cULL, 0x0000002a4858723cULL, 0x040ff00000001858ULL,
0x0000005c4854723cULL, 0x044ff00000001854ULL, 0x0000005e4818723cULL, 0x040ff00000001818ULL,
0x00000050481c723cULL, 0x048ff0000000181cULL, 0x000000524820723cULL, 0x040ff00000001820ULL,
0x0000004c4824723cULL, 0x050ff00000001824ULL, 0x0000004e4830723cULL, 0x000ff00000001830ULL,
0x00000044342c723cULL, 0x060ff0000000182cULL, 0x000000463458723cULL, 0x040ff00000001858ULL,
0x000000403454723cULL, 0x040ff00000001854ULL, 0x000000423418723cULL, 0x040ff00000001818ULL,
0x0000003c341c723cULL, 0x040ff0000000181cULL, 0x0000003e3420723cULL, 0x040ff00000001820ULL,
0x000000383424723cULL, 0x040ff00000001824ULL, 0x0000003a3430723cULL, 0x000fe20000001830ULL,
0x0000063000008947ULL, 0x000fee0003800000ULL, 0x00000002ff397819ULL, 0x000fe20000011604ULL,
0x0000000162407824ULL, 0x000fc600078e0a09ULL, 0x00000008393d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000139297824ULL, 0x140fe200078e026dULL, 0x0000001839447810ULL, 0x040fe40007ffe0ffULL,
0x0000001039427810ULL, 0x000fe20007ffe0ffULL, 0x000000013d2b7824ULL, 0x100fe200078e026dULL,
0x000000296c297210ULL, 0x000fe20007f3e0ffULL, 0x00000001443b7824ULL, 0x100fe200078e026dULL,
0x0000002839477810ULL, 0x000fe20007ffe0ffULL, 0x0000000142357824ULL, 0x100fe200078e026dULL,
0x0000002b6c2b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029347a11ULL, 0x000fe200078248ffULL, 0x00000001473f7824ULL, 0x000fe200078e026dULL,
0x0000003b6c3b7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fe200078448ffULL, 0x000000043d4a7824ULL, 0x000fe200078e00ffULL,
0x000000356c377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005f0029357a11ULL, 0x000fc400008f4c2aULL, 0x00005f002b297a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00005e003b2a7a11ULL, 0x000fe400078448ffULL,
0x0000002039467810ULL, 0x000fe40007ffe0ffULL, 0x00005f003b2b7a11ULL, 0x000fe400010f4c3aULL,
0x0000003039487810ULL, 0x000fe20007ffe0ffULL, 0x00000001463b7824ULL, 0x000fe200078e026dULL,
0x0000003f6c3f7210ULL, 0x000fc40007f7e0ffULL, 0x00005e0037367a11ULL, 0x040fe200078248ffULL,
0x0000000148417824ULL, 0x000fe200078e026dULL, 0x0000003b6c3b7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x00005f0037377a11ULL, 0x000fe400008f4c38ULL,
0x00005e003f387a11ULL, 0x000fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x000000416c417210ULL, 0x000fe40007f9e0ffULL, 0x00005e003b3a7a11ULL, 0x000fc400078448ffULL,
0x0000003839497810ULL, 0x040fe40007ffe0ffULL, 0x000000403900720cULL, 0x080fe40003f26070ULL,
0x00005f003f397a11ULL, 0x000fe200018f4c3eULL, 0x000000ffff3e7224ULL, 0x000fe200020e06ffULL,
0x00005f003b3b7a11ULL, 0x000fe200010f4c3cULL, 0x00000001493f7824ULL, 0x000fe200078e026dULL,
0x00005e00413c7a11ULL, 0x000fe400078648ffULL, 0x000000403d00720cULL, 0x000fc40003f46070ULL,
0x00005f00413d7a11ULL, 0x000fe400018f4c3eULL, 0x0000003f6c457210ULL, 0x000fe40007f9e0ffULL,
0x000000186f417812ULL, 0x000fe400078efcffULL, 0xfffffffc4a3f7812ULL, 0x000fe200078ee20bULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0x00005e00453e7a11ULL, 0x000fe200078648ffULL,
0x0000001041347825ULL, 0x000fe200078e0034ULL, 0x000000404800720cULL, 0x000fc40003fa6070ULL,
0x000000404700720cULL, 0x080fe20003f86070ULL, 0x000000103f437824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000340e7faeULL, 0x0003e2000c901c46ULL,
0x0000001041287825ULL, 0x000fe200078e0028ULL, 0x000000404200720cULL, 0x0c0fe40003f26070ULL,
0x00005f00453f7a11ULL, 0x000fe200018f4c4aULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x0000000028437faeULL, 0x0005e2000d101c46ULL, 0x000000404400720cULL, 0x0c0fe20003f46070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000404600720cULL, 0x0c0fe20003f66070ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0xfffffffc42457812ULL, 0x100fe200078ee20bULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0x000000404900720cULL, 0x040fe20003fc6070ULL,
0x0000000449347824ULL, 0x002fe200078e00ffULL, 0xfffffffc46357812ULL, 0x000fe200078ee20bULL,
0x0000001041367825ULL, 0x000fe200078e0036ULL, 0xfffffffc44297812ULL, 0x004fc600078ee20bULL,
0x0000000447287824ULL, 0x000fe200078e00ffULL, 0xfffffffc48437812ULL, 0x000fe200078ee20bULL,
0x00000010412a7825ULL, 0x000fe200078e002aULL, 0xfffffffc34477812ULL, 0x000fc600078ee20bULL,
0x00000010413a7825ULL, 0x000fc800078e003aULL, 0x0000001041387825ULL, 0x000fc800078e0038ULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0xfffffffc28417812ULL, 0x000fc600078ee20bULL, 0x0000001045457824ULL, 0x100fe400078e020cULL,
0x0000001029297824ULL, 0x100fe400078e020cULL, 0x0000001035357824ULL, 0x100fe200078e020cULL,
0x0000000036457faeULL, 0x0003e2000c901c46ULL, 0x0000001041417824ULL, 0x100fe400078e020cULL,
0x0000001043437824ULL, 0x100fe200078e020cULL, 0x000000002a297faeULL, 0x0003e2000d101c46ULL,
0x0000001047477824ULL, 0x000fc600078e020cULL, 0x000000003a357faeULL, 0x0003e8000d901c46ULL,
0x0000000038417faeULL, 0x0003e8000e101c46ULL, 0x000000003c437faeULL, 0x0003e8000e901c46ULL,
0x000000003e477faeULL, 0x0003e2000f101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008043c7811ULL, 0x040fe400078ff0ffULL, 0x0000006d04297211ULL, 0x000fc400078ff0ffULL,
0x00000010043e7811ULL, 0x000fe200078ff0ffULL, 0x000000013c2b7824ULL, 0x100fe200078e026dULL,
0x000000296c297210ULL, 0x000fe20007f3e0ffULL, 0x000000043c4e7824ULL, 0x000fe200078e00ffULL,
0x0000001804407811ULL, 0x000fe200078ff0ffULL, 0x000000013e357824ULL, 0x000fe200078e026dULL,
0x0000002b6c2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029367a11ULL, 0x000fe200078248ffULL, 0x000000043e507824ULL, 0x000fe200078e00ffULL,
0x0000002004427811ULL, 0x000fe200078ff0ffULL, 0x000000ffff347224ULL, 0x000fe200010e06ffULL,
0x00005e002b287a11ULL, 0x000fc400078448ffULL, 0x00005f0029377a11ULL, 0x000fe200008f4c2aULL,
0x0000000142397824ULL, 0x100fe200078e026dULL, 0x00005f002b297a11ULL, 0x000fe200010f4c34ULL,
0x00000001402b7824ULL, 0x100fe200078e026dULL, 0x000000356c357210ULL, 0x000fe20007f3e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000002804467811ULL, 0x000fe200078ff0ffULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000002b6c2b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005e0035347a11ULL, 0x000fe200078248ffULL,
0x00000001463b7824ULL, 0x100fe200078e026dULL, 0x00000030044a7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff3a7224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078448ffULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005f0035357a11ULL, 0x000fe200008f4c38ULL,
0x000000014a3f7824ULL, 0x000fe200078e026dULL, 0x000000396c397210ULL, 0x000fe20007f3e0ffULL,
0x000000044a4a7824ULL, 0x000fe200078e00ffULL, 0x00005f002b2b7a11ULL, 0x000fc400010f4c3aULL,
0x0000003b6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e00393a7a11ULL, 0x000fe400078248ffULL, 0x00000038044c7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d387a11ULL, 0x000fe400078448ffULL,
0x00005f00393b7a11ULL, 0x000fe400008f4c44ULL, 0x00005f003d397a11ULL, 0x000fe200010f4c48ULL,
0x000000014c3d7824ULL, 0x000fe200078e026dULL, 0x0000003f6c3f7210ULL, 0x000fe20007f3e0ffULL,
0x000000044c4c7824ULL, 0x000fe200078e00ffULL, 0x000000186f417812ULL, 0x000fc400078efcffULL,
0x0000003d6c3d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff447224ULL, 0x000fe200008e06ffULL,
0x00005e003f3e7a11ULL, 0x000fe200078248ffULL, 0x0000001041367825ULL, 0x000fe200078e0036ULL,
0xfffffffc4e437812ULL, 0x100fe400078ee20bULL, 0x00005f003f3f7a11ULL, 0x000fe200008f4c44ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x0000001043437824ULL, 0x000fe200078e020cULL, 0xfffffffc50457812ULL, 0x000fe200078ee20bULL,
0x0000001041287825ULL, 0x000fe200078e0028ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c48ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000360e7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc46477812ULL, 0x000fe200078ee20bULL, 0x0000001041347825ULL, 0x040fe200078e0034ULL,
0xfffffffc4a497812ULL, 0x000fe200078ee20bULL, 0x0000000028437faeULL, 0x0005e4000b901c46ULL,
0x00000010412a7825ULL, 0x000fc800078e002aULL, 0x00000010413a7825ULL, 0x000fe200078e003aULL,
0xfffffffc40377812ULL, 0x002fc600078ee20bULL, 0x0000001041387825ULL, 0x000fe200078e0038ULL,
0xfffffffc4c297812ULL, 0x004fc600078ee20bULL, 0x00000010413e7825ULL, 0x000fc800078e003eULL,
0x00000010413c7825ULL, 0x000fe200078e003cULL, 0xfffffffc42417812ULL, 0x000fc600078ee20bULL,
0x0000001045457824ULL, 0x100fe400078e020cULL, 0x0000001037377824ULL, 0x100fe400078e020cULL,
0x0000001041417824ULL, 0x100fe200078e020cULL, 0x0000000034457faeULL, 0x0003e2000b901c46ULL,
0x0000001047477824ULL, 0x100fe400078e020cULL, 0x0000001049497824ULL, 0x100fe200078e020cULL,
0x000000002a377faeULL, 0x0003e2000b901c46ULL, 0x0000001029297824ULL, 0x000fc600078e020cULL,
0x000000003a417faeULL, 0x0003e8000b901c46ULL, 0x0000000038477faeULL, 0x0003e8000b901c46ULL,
0x000000003e497faeULL, 0x0003e8000b901c46ULL, 0x000000003c297faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000140a287810ULL, 0x000fc40007ffe0ffULL,
0x000000160a347810ULL, 0x002fe40007ffe0ffULL, 0x0000000728287812ULL, 0x100fe400078e780dULL,
0x0000000734347812ULL, 0x000fc600078e780dULL, 0x000000200d287824ULL, 0x040fe400078e0228ULL,
0x000000200d347824ULL, 0x000fe400078e0234ULL, 0x0000001028487824ULL, 0x000fe400078e00ffULL,
0x0000001034347824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000f28783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000e680000000200ULL,
0x00000000105c783bULL, 0x000ea80000000200ULL, 0x000000001150783bULL, 0x000ee80000000200ULL,
0x00000000124c783bULL, 0x000f280000000200ULL, 0x000000001344783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f680000000200ULL, 0x000000001440783bULL, 0x000ee80000000200ULL,
0x00000000153c783bULL, 0x000ee80000000200ULL, 0x000000001638783bULL, 0x000ee20000000200ULL,
0x00000028482c723cULL, 0x042ff0000000182cULL, 0x0000002a4858723cULL, 0x040ff00000001858ULL,
0x0000005c4854723cULL, 0x044ff00000001854ULL, 0x0000005e4818723cULL, 0x040ff00000001818ULL,
0x00000050481c723cULL, 0x048ff0000000181cULL, 0x000000524820723cULL, 0x040ff00000001820ULL,
0x0000004c4824723cULL, 0x050ff00000001824ULL, 0x0000004e4830723cULL, 0x000ff00000001830ULL,
0x00000044342c723cULL, 0x060ff0000000182cULL, 0x000000463458723cULL, 0x040ff00000001858ULL,
0x000000403454723cULL, 0x040ff00000001854ULL, 0x000000423418723cULL, 0x040ff00000001818ULL,
0x0000003c341c723cULL, 0x040ff0000000181cULL, 0x0000003e3420723cULL, 0x040ff00000001820ULL,
0x000000383424723cULL, 0x040ff00000001824ULL, 0x0000003a3430723cULL, 0x000fe20000001830ULL,
0x0000063000008947ULL, 0x000fee0003800000ULL, 0x00000002ff367819ULL, 0x000fe20000011604ULL,
0x0000000162407824ULL, 0x000fe200078e0a09ULL, 0x0000001c6f6f7812ULL, 0x000fc400078efcffULL,
0x0000001036427810ULL, 0x040fe20007ffe0ffULL, 0x0000000136297824ULL, 0x140fe200078e026dULL,
0x0000000836417810ULL, 0x040fe40007ffe0ffULL, 0x0000001836437810ULL, 0x000fe20007ffe0ffULL,
0x0000000142357824ULL, 0x100fe200078e026dULL, 0x000000296c297210ULL, 0x000fe20007f1e0ffULL,
0x00000001412b7824ULL, 0x100fe200078e026dULL, 0x0000002036447810ULL, 0x000fe40007ffe0ffULL,
0x000000356c377210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff387224ULL, 0x000fe200000e06ffULL,
0x0000002b6c2b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000144397824ULL, 0x000fe200078e026dULL,
0x00005e0029347a11ULL, 0x000fe200078048ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e0037287a11ULL, 0x000fe200078448ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005f0029357a11ULL, 0x000fc400000f4c38ULL, 0x00005f0037297a11ULL, 0x000fe200010f4c3cULL,
0x0000000143377824ULL, 0x000fe200078e026dULL, 0x00005e002b2a7a11ULL, 0x000fe200078248ffULL,
0x000000106f347825ULL, 0x040fe200078e0034ULL, 0x0000002836457810ULL, 0x040fe40007ffe0ffULL,
0x0000003036477810ULL, 0x040fe20007ffe0ffULL, 0x000000106f287825ULL, 0x000fe200078e0028ULL,
0x00000038364b7810ULL, 0x000fe40007ffe0ffULL, 0x00005f002b2b7a11ULL, 0x000fe200008f4c3aULL,
0x00000001453b7824ULL, 0x100fe200078e026dULL, 0x000000376c377210ULL, 0x000fe20007f3e0ffULL,
0x00000001473d7824ULL, 0x100fe200078e026dULL, 0x000000403600720cULL, 0x000fe20003f06070ULL,
0x000000014b6d7824ULL, 0x000fe200078e026dULL, 0x000000396c397210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x0000003b6c3b7210ULL, 0x000fe20007fbe0ffULL,
0x000000106f2a7825ULL, 0x000fe200078e002aULL, 0x00005e0037367a11ULL, 0x000fc400078648ffULL,
0x0000003d6c497210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff467224ULL, 0x000fe200020e06ffULL,
0x0000006d6c6d7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0x00005f0037377a11ULL, 0x000fe200018f4c38ULL, 0x000000ffff4a7224ULL, 0x000fe200010e06ffULL,
0x00005e00393e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e003b3c7a11ULL, 0x000fe200078848ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034717faeULL, 0x0003e2000c101c46ULL, 0x00005e00493a7a11ULL, 0x000fe200078248ffULL,
0x000000106f367825ULL, 0x000fe200078e0036ULL, 0x00005e006d387a11ULL, 0x000fc400078448ffULL,
0x00005f00393f7a11ULL, 0x000fe200018f4c46ULL, 0x0000000443467824ULL, 0x000fe200078e00ffULL,
0x00005f003b3d7a11ULL, 0x000fe200020f4c48ULL, 0x0000000447487824ULL, 0x000fe200078e00ffULL,
0x00005f00493b7a11ULL, 0x000fe200008f4c4aULL, 0x000000044b4a7824ULL, 0x000fe200078e00ffULL,
0x00005f006d397a11ULL, 0x000fe200010f4c4cULL, 0x0000000445347824ULL, 0x002fe200078e00ffULL,
0x000000404100720cULL, 0x080fe20003f06070ULL, 0x000000106f3e7825ULL, 0x000fe200078e003eULL,
0x000000404200720cULL, 0x000fc40003f26070ULL, 0x000000404300720cULL, 0x080fe20003f46070ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x000000404400720cULL, 0x0c0fe20003f66070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000404500720cULL, 0x080fe20003f86070ULL,
0x000000106f3c7825ULL, 0x000fe200078e003cULL, 0x000000404700720cULL, 0x080fe40003fa6070ULL,
0x000000404b00720cULL, 0x000fe20003fc6070ULL, 0x0000000441407824ULL, 0x000fe200078e00ffULL,
0xfffffffc42417812ULL, 0x000fe200078ee20bULL, 0x000000106f3a7825ULL, 0x000fe200078e003aULL,
0xfffffffc46437812ULL, 0x000fc400078ee20bULL, 0xfffffffc40357812ULL, 0x100fe200078ee20bULL,
0x0000001041417824ULL, 0x100fe200078e0270ULL, 0xfffffffc44457812ULL, 0x100fe200078ee20bULL,
0x0000001043437824ULL, 0x100fe200078e0270ULL, 0xfffffffc34477812ULL, 0x100fe200078ee20bULL,
0x0000001035357824ULL, 0x100fe200078e0270ULL, 0xfffffffc48497812ULL, 0x100fe200078ee20bULL,
0x0000001045457824ULL, 0x100fe200078e0270ULL, 0xfffffffc4a4b7812ULL, 0x000fe200078ee20bULL,
0x0000001047477824ULL, 0x100fe200078e0270ULL, 0x000000002a357faeULL, 0x0003e2000c101c46ULL,
0x0000001049497824ULL, 0x000fc400078e0270ULL, 0x000000104b4b7824ULL, 0x000fe200078e0270ULL,
0x0000000028417faeULL, 0x0003e2000c901c46ULL, 0x000000106f387825ULL, 0x000fc600078e0038ULL,
0x0000000036437faeULL, 0x0003e8000d101c46ULL, 0x000000003e457faeULL, 0x0003e8000d901c46ULL,
0x000000003c477faeULL, 0x0003e8000e101c46ULL, 0x000000003a497faeULL, 0x0003e8000e901c46ULL,
0x00000000384b7faeULL, 0x0003e2000f101c46ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000006d04297211ULL, 0x040fe400078ff0ffULL, 0x0000000804347811ULL, 0x000fc400078ff0ffULL,
0x000000296c297210ULL, 0x000fe40007f1e0ffULL, 0x00000018043a7811ULL, 0x000fe200078ff0ffULL,
0x00000001342b7824ULL, 0x100fe200078e026dULL, 0x0000001004387811ULL, 0x040fe200078ff0ffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00000020043c7811ULL, 0x000fe200078ff0ffULL,
0x000000013a397824ULL, 0x100fe200078e026dULL, 0x00005e0029287a11ULL, 0x040fe200078048ffULL,
0x0000000138357824ULL, 0x100fe200078e026dULL, 0x00000028043e7811ULL, 0x000fe200078ff0ffULL,
0x000000013c3d7824ULL, 0x100fe200078e026dULL, 0x0000002b6c2b7210ULL, 0x000fe20007f7e0ffULL,
0x0000000434347824ULL, 0x000fe200078e00ffULL, 0x0000003004407811ULL, 0x000fe200078ff0ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000003804467811ULL, 0x000fe200078ff0ffULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x00005f0029297a11ULL, 0x000fe200000f4c2aULL,
0x000000013e417824ULL, 0x100fe200078e026dULL, 0x000000396c3b7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x000000356c377210ULL, 0x000fe20007f3e0ffULL,
0x0000000140437824ULL, 0x100fe200078e026dULL, 0x00005e002b2a7a11ULL, 0x040fe200078c48ffULL,
0x00000001466d7824ULL, 0x000fe200078e026dULL, 0x0000003d6c3f7210ULL, 0x000fe20007f5e0ffULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0xfffffffc34357812ULL, 0x100fe200078ee20bULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3a3d7812ULL, 0x100fe200078ee20bULL,
0x000000ffff3a7224ULL, 0x000fe200000e06ffULL, 0xfffffffc38397812ULL, 0x100fe200078ee20bULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0x000000416c427210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4c36ULL,
0x0000000446467824ULL, 0x000fe200078e00ffULL, 0x00005e003b347a11ULL, 0x000fe200078048ffULL,
0x0000001035417824ULL, 0x100fe200078e0270ULL, 0x000000436c447210ULL, 0x040fe20007fbe0ffULL,
0x0000001039437824ULL, 0x100fe200078e0270ULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x0000006d6c6d7210ULL, 0x000fe20007f9e0ffULL,
0x000000103d457824ULL, 0x000fe200078e0270ULL, 0xfffffffc404b7812ULL, 0x100fe200078ee20bULL,
0x000000ffff407224ULL, 0x000fe200010e06ffULL, 0xfffffffc3c477812ULL, 0x000fc400078ee20bULL,
0x00005f003b357a11ULL, 0x000fe200000f4c3aULL, 0x000000ffff3b7224ULL, 0x000fe200028e06ffULL,
0xfffffffc3e497812ULL, 0x100fe200078ee20bULL, 0x0000001047477824ULL, 0x000fe200078e0270ULL,
0x00005f0037377a11ULL, 0x000fe200008f4c38ULL, 0x000000104b4b7824ULL, 0x100fe200078e0270ULL,
0x0000001c6f6f7812ULL, 0x000fe200078efcffULL, 0x0000001049497824ULL, 0x000fe200078e0270ULL,
0x00005e003f3c7a11ULL, 0x000fe400078048ffULL, 0xfffffffc464d7812ULL, 0x000fe200078ee20bULL,
0x000000ffff467224ULL, 0x000fe200020e06ffULL, 0x00005e00423e7a11ULL, 0x000fe200078248ffULL,
0x000000106f287825ULL, 0x000fe200078e0028ULL, 0x00005e00443a7a11ULL, 0x000fc400078448ffULL,
0x00005e006d387a11ULL, 0x000fe200078648ffULL, 0x000000106f2a7825ULL, 0x000fe200078e002aULL,
0x00005f003f3d7a11ULL, 0x000fe200000f4c40ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028717faeULL, 0x0003e2000b901c46ULL, 0x00005f00423f7a11ULL, 0x000fe200008f4c39ULL,
0x000000106f367825ULL, 0x000fe200078e0036ULL, 0x00005f00443b7a11ULL, 0x000fe200010f4c3bULL,
0x000000002a417faeULL, 0x0003e2000b901c46ULL, 0x00005f006d397a11ULL, 0x000fe200018f4c46ULL,
0x000000106f347825ULL, 0x040fe400078e0034ULL, 0x0000000036437faeULL, 0x0003e4000b901c46ULL,
0x000000106f3c7825ULL, 0x000fc400078e003cULL, 0x0000000034457faeULL, 0x0003e4000b901c46ULL,
0x000000106f3e7825ULL, 0x040fe400078e003eULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x000000106f3a7825ULL, 0x000fe400078e003aULL, 0x000000003e497faeULL, 0x0003e4000b901c46ULL,
0x000000104d4d7824ULL, 0x000fc400078e0270ULL, 0x000000106f387825ULL, 0x000fe200078e0038ULL,
0x000000003a4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000384d7faeULL, 0x0003e4000b901c46ULL,
0x00000300ff297624ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff6c7424ULL, 0x000fe400078e00ffULL, 0x0000000229607824ULL, 0x000fca00078e0260ULL,
0x000000616000720cULL, 0x000fda0003f06070ULL, 0x0000000205348824ULL, 0x000fe400078e0260ULL,
0x00000004ff358424ULL, 0x000fe200078e00ffULL, 0x000000180a287810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600034348625ULL, 0x000fe200078e0035ULL,
0x0000000728287812ULL, 0x000fe200078e780dULL, 0x000000006b5c783bULL, 0x000fe80000000200ULL,
0x00000006346c8981ULL, 0x0002a2000c1e1900ULL, 0x000000200d287824ULL, 0x000fc600078e0228ULL,
0x000000006a50783bULL, 0x000fe20000000200ULL, 0x0000001028487824ULL, 0x000fc600078e00ffULL,
0x000000006e28783bULL, 0x000fe20000000200ULL, 0x0000001a0a347810ULL, 0x002fc60007ffe0ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x00000000694c783bULL, 0x000ee40000000200ULL, 0x000000200d347824ULL, 0x000fe400078e0234ULL,
0x000000006844783bULL, 0x000fe40000000200ULL, 0x0000001034347824ULL, 0x000fe400078e00ffULL,
0x000000006740783bULL, 0x000fe80000000200ULL, 0x00000000663c783bULL, 0x000fe80000000200ULL,
0x000000003434783bULL, 0x000f280000000200ULL, 0x000000006538783bULL, 0x000f620000000200ULL,
0x00000028482c723cULL, 0x042ff0000000182cULL, 0x0000002a4858723cULL, 0x040ff00000001858ULL,
0x0000005c4854723cULL, 0x040fee0000001854ULL, 0x00000300645c7a10ULL, 0x000fe20007ffe0ffULL,
0x0000005e4818723cULL, 0x000fe60000001818ULL, 0x000000015c287810ULL, 0x040fe20007ffe0ffULL,
0x000001005c2b7824ULL, 0x000fc600078e0200ULL, 0x000000172800720cULL, 0x000fe20003f06070ULL,
0x00000050481c723cULL, 0x000fe2000000181cULL, 0x000000402b297812ULL, 0x000fce00078ec0ffULL,
0x000000524820723cULL, 0x040ff00000001820ULL, 0x0000004c4824723cULL, 0x048ff00000001824ULL,
0x0000004e4830723cULL, 0x000ff00000001830ULL, 0x00000044342c723cULL, 0x050ff0000000182cULL,
0x000000463458723cULL, 0x040ff00000001858ULL, 0x000000403454723cULL, 0x040ff00000001854ULL,
0x000000423418723cULL, 0x040ff00000001818ULL, 0x0000003c341c723cULL, 0x040fee000000181cULL,
0x00000001023d7824ULL, 0x000fe200078e0229ULL, 0x0000003e3420723cULL, 0x040ff00000001820ULL,
0x000000383424723cULL, 0x060ff00000001824ULL, 0x0000003a3430723cULL, 0x000fe20000001830ULL,
0x000000036c3f7224ULL, 0x004fe200078e02ffULL, 0x000006d000008947ULL, 0x000fec0003800000ULL,
0x00000002ff3e7819ULL, 0x000fe20000011604ULL, 0x0000001004407824ULL, 0x000fe200078e00ffULL,
0x0000002b62287217ULL, 0x000fc40007800000ULL, 0x000000083e427810ULL, 0x040fe20007ffe0ffULL,
0x000000013e297824ULL, 0x040fe200078e023dULL, 0x000000103e437810ULL, 0x000fe20007ffe0ffULL,
0x0000000128367824ULL, 0x000fe200078e0a2bULL, 0x000000183e447810ULL, 0x000fe20007ffe0ffULL,
0x0000000142287824ULL, 0x100fe200078e023dULL, 0x000000293f3c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000143297824ULL, 0x100fe200078e023dULL, 0x0000003040417812ULL, 0x000fe200078ec0ffULL,
0x00000001442a7824ULL, 0x000fe200078e023dULL, 0x000000283f377210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e06ffULL, 0x000000293f297210ULL, 0x000fc40007f5e0ffULL,
0x00005e003c3b7a11ULL, 0x040fe200078048ffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x0000002a3f2a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005f003c3c7a11ULL, 0x000fe400000f4c2bULL, 0x00005e0029347a11ULL, 0x000fe200078248ffULL,
0x000000ffff397224ULL, 0x000fe200018e06ffULL, 0x00005e00372b7a11ULL, 0x000fe400078048ffULL,
0x00005f0029357a11ULL, 0x000fc400008f4c28ULL, 0x00005e002a387a11ULL, 0x000fe400078448ffULL,
0x00005f0037377a11ULL, 0x000fe200000f4c3aULL, 0x00000004433a7824ULL, 0x000fe200078e00ffULL,
0x000000413b287210ULL, 0x000fe40007f7e0ffULL, 0x000000363e00720cULL, 0x080fe40003f06070ULL,
0x00005f002a397a11ULL, 0x000fe200010f4c39ULL, 0x000000ffff297224ULL, 0x000fe200018e063cULL,
0x000000364200720cULL, 0x0c0fe20003f26070ULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x000000364300720cULL, 0x000fc40003f46070ULL, 0x000000412b2a7210ULL, 0x080fe40007f7e0ffULL,
0xfffffffc3a437812ULL, 0x000fe400078ee20bULL, 0x000000203e3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200018e0637ULL, 0xfffffffc423b7812ULL, 0x000fe200078ee20bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000280e7faeULL, 0x0003e2000c101c46ULL,
0x0000004134347210ULL, 0x000fe20007f9e0ffULL, 0x000000013a377824ULL, 0x000fe200078e023dULL,
0x000000283e3c7810ULL, 0x040fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020cULL,
0x000000303e407810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200020e0635ULL,
0x000000373f377210ULL, 0x000fe20007f1e0ffULL, 0x0000001043437824ULL, 0x000fe200078e020cULL,
0x000000002a3b7faeULL, 0x0005e2000c901c46ULL, 0x000000364400720cULL, 0x0c0fe20003f86070ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x000000383e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000034437faeULL, 0x0007e2000d101c46ULL, 0x000000ffff0e7224ULL, 0x002fe200000e06ffULL,
0x000000363a00720cULL, 0x0c0fe20003f66070ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x000000363c00720cULL, 0x000fc40003f46070ULL, 0x000000364000720cULL, 0x080fe40003f26070ULL,
0x000000363e00720cULL, 0x000fe20003f06070ULL, 0x00000001402a7824ULL, 0x004fe200078e023dULL,
0x0000004138287210ULL, 0x000fe20007fbe0ffULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x00005e0037347a11ULL, 0x048fe400078c48ffULL, 0xfffffffc442b7812ULL, 0x000fe200078ee20bULL,
0x000000ffff297224ULL, 0x000fe200028e0639ULL, 0x00005f0037367a11ULL, 0x000fe200030f4c0eULL,
0x000000013c0e7824ULL, 0x000fe200078e023dULL, 0xfffffffc3a397812ULL, 0x000fe200078ee20bULL,
0x000000102b377824ULL, 0x000fc400078e020cULL, 0x000000013e2b7824ULL, 0x000fe200078e023dULL,
0x0000000e3f357210ULL, 0x040fe20007fbe0ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x0000000028377faeULL, 0x0003e2000e101c46ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000002a3f0e7210ULL, 0x000fe20007f9e0ffULL, 0x0000001039397824ULL, 0x100fe200078e020cULL,
0xfffffffc3c3b7812ULL, 0x100fe400078ee20bULL, 0xfffffffc403d7812ULL, 0x100fe400078ee20bULL,
0xfffffffc3e0b7812ULL, 0x000fe200078ee20bULL, 0x000000103b3b7824ULL, 0x100fe200078e020cULL,
0x0000002b3f2b7210ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x000fc400078e020cULL,
0x000000ffff287224ULL, 0x002fe200028e06ffULL, 0x00005e00352a7a11ULL, 0x000fe200078a48ffULL,
0x000000100b3f7824ULL, 0x000fe400078e020cULL, 0x000000ffff0b7224ULL, 0x000fe200020e06ffULL,
0x00005f0035357a11ULL, 0x000fe200028f4c28ULL, 0x000000ffff0c7224ULL, 0x000fe200030e06ffULL,
0x0000004134287210ULL, 0x000fe40007fbe0ffULL, 0x00005e000e347a11ULL, 0x000fc600078848ffULL,
0x000000ffff297224ULL, 0x000fe200028e0636ULL, 0x00005e002b367a11ULL, 0x040fe400078c48ffULL,
0x000000412a2a7210ULL, 0x080fe40007fbe0ffULL, 0x00005f000e0e7a11ULL, 0x000fe200020f4c0bULL,
0x0000000028397faeULL, 0x0003e2000d901c46ULL, 0x00005f002b0b7a11ULL, 0x000fe200030f4c0cULL,
0x000000ffff2b7224ULL, 0x000fe200028e0635ULL, 0x0000004134347210ULL, 0x080fe40007f9e0ffULL,
0x0000004136367210ULL, 0x000fc40007fbe0ffULL, 0x000000002a3b7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff357224ULL, 0x000fe400020e060eULL, 0x000000ffff377224ULL, 0x000fc600028e060bULL,
0x00000000343d7faeULL, 0x0003e8000c901c46ULL, 0x00000000363f7faeULL, 0x0003e2000c101c46ULL,
0x0000061000007947ULL, 0x000fea0003800000ULL, 0x0000002004387811ULL, 0x040fe400078ff0ffULL,
0x0000003d04287211ULL, 0x040fe400078ff0ffULL, 0x00000008042a7811ULL, 0x000fe200078ff0ffULL,
0x00000001382b7824ULL, 0x100fe200078e023dULL, 0x0000001004347811ULL, 0x000fe200078ff0ffULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0000001804367811ULL, 0x000fe200078ff0ffULL,
0x000000042a407824ULL, 0x000fe200078e00ffULL, 0x00000028043a7811ULL, 0x000fe200078ff0ffULL,
0x0000000134297824ULL, 0x100fe200078e023dULL, 0x00000030043c7811ULL, 0x000fe200078ff0ffULL,
0x0000000434427824ULL, 0x000fe200078e00ffULL, 0x00000038043e7811ULL, 0x000fe200078ff0ffULL,
0x0000000436467824ULL, 0x000fe200078e00ffULL, 0x000000283f447210ULL, 0x040fe20007f1e0ffULL,
0x000000012a287824ULL, 0x000fe200078e023dULL, 0xfffffffc38417812ULL, 0x000fe200078ee20bULL,
0x00000001362a7824ULL, 0x000fe200078e023dULL, 0xfffffffc40397812ULL, 0x000fe200078ee20bULL,
0x000000013a347824ULL, 0x100fe200078e023dULL, 0x000000283f287210ULL, 0x040fe20007fde0ffULL,
0x000000013c357824ULL, 0x000fe200078e023dULL, 0xfffffffc423b7812ULL, 0x000fe200078ee20bULL,
0x000000013e367824ULL, 0x000fe200078e023dULL, 0xfffffffc463d7812ULL, 0x100fe200078ee20bULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000002b3f2b7210ULL, 0x040fe20007f3e0ffULL,
0x000000043c3c7824ULL, 0x000fe200078e00ffULL, 0x000000293f297210ULL, 0x000fe20007fbe0ffULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3a457812ULL, 0x100fe200078ee20bULL,
0x000000ffff377224ULL, 0x000fe200000e06ffULL, 0x00005e0044437a11ULL, 0x000fe200078048ffULL,
0x00000010414d7824ULL, 0x100fe200078e020cULL, 0xfffffffc3c517812ULL, 0x100fe200078ee20bULL,
0x000000103d4b7824ULL, 0x100fe200078e020cULL, 0xfffffffc3e537812ULL, 0x000fe200078ee20bULL,
0x000000ffff0b7224ULL, 0x000fe200030e06ffULL, 0x00005e0028417a11ULL, 0x000fe200078c48ffULL,
0x0000001039477824ULL, 0x100fe200078e020cULL, 0x00005f0044447a11ULL, 0x000fe200000f4c37ULL,
0x000000103b497824ULL, 0x100fe200078e020cULL, 0x0000002a3f2a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010454f7824ULL, 0x100fe200078e020cULL, 0x00005f0028427a11ULL, 0x000fe200030f4c0bULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x000000343f347210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e06ffULL, 0x00005e002a377a11ULL, 0x040fe200078048ffULL,
0x0000001051517824ULL, 0x100fe200078e020cULL, 0x000000300b457812ULL, 0x000fe200078ec0ffULL,
0x0000001053537824ULL, 0x000fe200078e020cULL, 0x000000353f357210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x000000363f367210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff407224ULL, 0x000fe200028e06ffULL, 0x00005e002b387a11ULL, 0x000fe200078248ffULL,
0x000000ffff3b7224ULL, 0x000fe200010e06ffULL, 0x00005f002a3d7a11ULL, 0x000fe200000f4c3dULL,
0x000000ffff0b7224ULL, 0x000fe200020e06ffULL, 0x00005e00293f7a11ULL, 0x000fc400078a48ffULL,
0x0000004543287210ULL, 0x000fe40007f1e0ffULL, 0x00005f002b397a11ULL, 0x000fe200008f4c0cULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005e00343a7a11ULL, 0x000fe400078248ffULL,
0x00005e00353c7a11ULL, 0x000fe400078448ffULL, 0x00005e00363e7a11ULL, 0x000fe400078648ffULL,
0x00005f0029407a11ULL, 0x000fe200028f4c40ULL, 0x000000ffff297224ULL, 0x000fe200000e0644ULL,
0x00005f00343b7a11ULL, 0x000fc400008f4c3bULL, 0x00000045412a7210ULL, 0x080fe40007f1e0ffULL,
0x00005f00350c7a11ULL, 0x000fe200010f4c0cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000280e7faeULL, 0x0003e2000b901c46ULL, 0x00005f00360b7a11ULL, 0x000fe200018f4c0bULL,
0x000000ffff2b7224ULL, 0x000fe200000e0642ULL, 0x000000453f347210ULL, 0x080fe40007f3e0ffULL,
0x0000004537367210ULL, 0x080fe40007f5e0ffULL, 0x0000004538387210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff357224ULL, 0x000fe200008e0640ULL, 0x000000453a3a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff377224ULL, 0x000fe200010e063dULL, 0x000000453c3c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200018e0639ULL, 0x000000453e3e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x000000002a477faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3d7224ULL, 0x000fc400028e060cULL, 0x000000ffff3f7224ULL, 0x000fe200000e060bULL,
0x0000000034497faeULL, 0x0003e8000b901c46ULL, 0x00000000364b7faeULL, 0x0003e8000b901c46ULL,
0x00000000384d7faeULL, 0x0003e8000b901c46ULL, 0x000000003a4f7faeULL, 0x0003e8000b901c46ULL,
0x000000003c517faeULL, 0x0003e8000b901c46ULL, 0x000000003e537faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001c0a0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000001e0a0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000070c0c7812ULL, 0x100fe400078e780dULL,
0x000000070a0a7812ULL, 0x000fc600078e780dULL, 0x000000200d0c7824ULL, 0x040fe400078e020cULL,
0x000000200d0a7824ULL, 0x000fe400078e020aULL, 0x000000100c347824ULL, 0x002fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000001038783bULL, 0x000e680000000200ULL,
0x00000000113c783bULL, 0x000ea80000000200ULL, 0x000000000f28783bULL, 0x000ee80000000200ULL,
0x000000001240783bULL, 0x000f280000000200ULL, 0x000000000a44783bULL, 0x000fe80000000200ULL,
0x00000000140c783bULL, 0x000f680000000200ULL, 0x00000000154c783bULL, 0x000ee80000000200ULL,
0x000000001348783bULL, 0x0003280000000200ULL, 0x000000001650783bULL, 0x000f220000000200ULL,
0x000000383454723cULL, 0x042ff00000001854ULL, 0x0000003a3418723cULL, 0x040ff00000001818ULL,
0x0000003c341c723cULL, 0x044ff0000000181cULL, 0x00000028342c723cULL, 0x048ff0000000182cULL,
0x0000002a3458723cULL, 0x040ff00000001858ULL, 0x0000003e3420723cULL, 0x040ff00000001820ULL,
0x000000403424723cULL, 0x050ff00000001824ULL, 0x000000423430723cULL, 0x000ff00000001830ULL,
0x0000000c4454723cULL, 0x060ff00000001854ULL, 0x0000000e440c723cULL, 0x040ff00000001818ULL,
0x0000004c4410723cULL, 0x040ff0000000181cULL, 0x00000048442c723cULL, 0x040ff0000000182cULL,
0x0000004a4458723cULL, 0x040ff00000001858ULL, 0x0000004e444c723cULL, 0x040ff00000001820ULL,
0x000000504418723cULL, 0x040ff00000001824ULL, 0x000000524444723cULL, 0x000fe20000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000ff40000008000ULL, 0x0000000006147f8cULL, 0x000fe2000c80043fULL,
0x3d8000002f0a7820ULL, 0x000fe20000410000ULL, 0x3d800000121c7820ULL, 0x000fe20000410000ULL,
0x3d800000131d7820ULL, 0x000fe20000410000ULL, 0x00000400060b7984ULL, 0x000e620000000800ULL,
0x3d80000018167820ULL, 0x000fe20000410000ULL, 0x3d8000002c337820ULL, 0x000fe20000410000ULL,
0x3d8000002d317820ULL, 0x000fe20000410000ULL, 0x3d8000002e227820ULL, 0x000fe20000410000ULL,
0x3d800000102a7820ULL, 0x000fe20000410000ULL, 0x3d80000011297820ULL, 0x000fe20000410000ULL,
0x3d80000019187820ULL, 0x000fe20000410000ULL, 0x3d8000001a127820ULL, 0x000fe20000410000ULL,
0x3d8000001b137820ULL, 0x000fe20000410000ULL, 0x3d80000058307820ULL, 0x000fe20000410000ULL,
0x3d800000592f7820ULL, 0x000fe20000410000ULL, 0x3d8000005a217820ULL, 0x000fe20000410000ULL,
0x3d8000005b237820ULL, 0x000fe20000410000ULL, 0x3d800000542e7820ULL, 0x000fe20000410000ULL,
0x3d800000552d7820ULL, 0x000fe20000410000ULL, 0x3d80000056247820ULL, 0x000fe20000410000ULL,
0x3d80000057257820ULL, 0x000fe20000410000ULL, 0x3d8000000c2c7820ULL, 0x000fe20000410000ULL,
0x3d8000000d2b7820ULL, 0x000fe20000410000ULL, 0x3d8000000e267820ULL, 0x000fe20000410000ULL,
0x3d8000000f1f7820ULL, 0x000fe20000410000ULL, 0x3d8000004c287820ULL, 0x000fe20000410000ULL,
0x3d8000004d277820ULL, 0x000fe20000410000ULL, 0x3d8000004e1e7820ULL, 0x000fe20000410000ULL,
0x3d8000004f207820ULL, 0x000fe20000410000ULL, 0x3d80000044197820ULL, 0x000fe20000410000ULL,
0x3d800000451a7820ULL, 0x000fe20000410000ULL, 0x3d80000046107820ULL, 0x000fe20000410000ULL,
0x3d80000047117820ULL, 0x000fe20000410000ULL, 0x000000ffff1b7224ULL, 0x000fe200078e000aULL,
0x800000000bff7812ULL, 0x002fe20007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x00000400060b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004040a7824ULL, 0x000fe200078e00ffULL,
0x000000076400720cULL, 0x000fc80003f05270ULL, 0xfffffff00a0c7812ULL, 0x000fca00078ec0ffULL,
0x00000080630b7824ULL, 0x000fca00078e020cULL, 0x014400000b0c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000204147824ULL, 0x000fe400078e00ffULL,
0x0000000162347824ULL, 0x000fc600078e0a09ULL, 0x0000000614147812ULL, 0x000fc800078ec0ffULL,
0x0000000114097812ULL, 0x040fe400078efcffULL, 0x0000000814157812ULL, 0x040fe400078efcffULL,
0x000000340900720cULL, 0x080fe40003f26070ULL, 0x0000001014097812ULL, 0x000fe400078efcffULL,
0x000000341500720cULL, 0x080fe40003f06070ULL, 0x000000340900720cULL, 0x000fc40003fc6070ULL,
0x0000001114157812ULL, 0x040fe400078efcffULL, 0x0000001814097812ULL, 0x040fe400078efcffULL,
0x000000341400720cULL, 0x0c0fe40003f46070ULL, 0x000000341500720cULL, 0x080fe40003fa6070ULL,
0x000000340900720cULL, 0x000fe40003f66070ULL, 0x0000000914327812ULL, 0x000fc400078efcffULL,
0x0000001914157812ULL, 0x040fe400078efcffULL, 0x0000002014097812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005000000ULL, 0xff7fffff33337808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff31317808ULL, 0x000fc40004800000ULL,
0x000000343200720cULL, 0x080fe40003f86070ULL, 0x000000341500720cULL, 0x080fe40003f46070ULL,
0x000000340900720cULL, 0x000fe40003f26070ULL, 0x0000002114157812ULL, 0x040fe400078efcffULL,
0x0000002814097812ULL, 0x000fe400078efcffULL, 0xff7fffff21217808ULL, 0x000fc40004000000ULL,
0xff7fffff30307808ULL, 0x000fe40004000000ULL, 0xff7fffff23237808ULL, 0x000fe40006000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40006000000ULL, 0x000000341500720cULL, 0x080fe40003f06070ULL,
0x000000340900720cULL, 0x000fe40003f86070ULL, 0x0000002914157812ULL, 0x000fc400078efcffULL,
0x0000003014097812ULL, 0x000fe400078efcffULL, 0xff7fffff24247808ULL, 0x000fe40007000000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40007000000ULL, 0xff7fffff25257808ULL, 0x000fe40006800000ULL,
0xff7fffff2d2d7808ULL, 0x000fe40006800000ULL, 0x000000341500720cULL, 0x000fc40003fc6070ULL,
0x000000340900720cULL, 0x000fe40003fa6070ULL, 0x0000003114157812ULL, 0x040fe400078efcffULL,
0x0000003814097812ULL, 0x040fe400078efcffULL, 0x0000003914147812ULL, 0x000fe400078efcffULL,
0xff7fffff26267808ULL, 0x000fe40005800000ULL, 0xff7fffff2c2c7808ULL, 0x000fc40005800000ULL,
0xff7fffff1f1f7808ULL, 0x000fe40005000000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40005000000ULL,
0xff7fffff1c1c7808ULL, 0x000fe40004800000ULL, 0xff7fffff2a2a7808ULL, 0x000fe40004800000ULL,
0x000000341500720cULL, 0x080fe40003f66070ULL, 0x000000340900720cULL, 0x000fc40003f46070ULL,
0x000000341400720cULL, 0x000fe40003f26070ULL, 0xff7fffff1d1d7808ULL, 0x000fe40004000000ULL,
0xff7fffff29297808ULL, 0x000fe40004000000ULL, 0xff7fffff1e1e7808ULL, 0x000fe40006000000ULL,
0xff7fffff28287808ULL, 0x000fe40006000000ULL, 0xff7fffff20207808ULL, 0x000fc40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40007000000ULL, 0xff7fffff12127808ULL, 0x000fe40006800000ULL,
0xff7fffff16167808ULL, 0x000fe40006800000ULL, 0xff7fffff13137808ULL, 0x000fe40005800000ULL,
0xff7fffff18187808ULL, 0x000fe40005800000ULL, 0xff7fffff10107808ULL, 0x000fc40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40005000000ULL, 0xff7fffff11117808ULL, 0x000fe40004800000ULL,
0xff7fffff1a1a7808ULL, 0x000fe40004800000ULL, 0x000000330c0c7209ULL, 0x004fe20007810000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x000000220d147209ULL, 0x000fe20007810000ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x000000310c097209ULL, 0x000fe40007810000ULL,
0x0000001b14147209ULL, 0x000fc40007810000ULL, 0x00000030090c7209ULL, 0x000fe40007810000ULL,
0x0000002114147209ULL, 0x000fe40007810000ULL, 0x0000002f0c097209ULL, 0x000fe40007810000ULL,
0x00000023140d7209ULL, 0x000fe40007810000ULL, 0x0000002e090c7209ULL, 0x000fe40007810000ULL,
0x000000240d147209ULL, 0x000fc40007810000ULL, 0x0000002d0c097209ULL, 0x000fe40007810000ULL,
0x00000025140d7209ULL, 0x000fe40007810000ULL, 0x0000002c090c7209ULL, 0x000fe40007810000ULL,
0x000000260d147209ULL, 0x000fe40007810000ULL, 0x0000002b0c097209ULL, 0x000fe40007810000ULL,
0x0000001f140d7209ULL, 0x000fc40007810000ULL, 0x0000002a090c7209ULL, 0x000fe40007810000ULL,
0x0000001c0d147209ULL, 0x000fe40007810000ULL, 0x000000290c097209ULL, 0x000fe40007810000ULL,
0x0000001d140d7209ULL, 0x000fe40007810000ULL, 0x00000028090c7209ULL, 0x000fe40007810000ULL,
0x0000001e0d0d7209ULL, 0x000fc40007810000ULL, 0x000000270c097209ULL, 0x000fe40007810000ULL,
0x000000200d0d7209ULL, 0x000fe40007810000ULL, 0x0000001609097209ULL, 0x000fe40007810000ULL,
0x000000120d0c7209ULL, 0x000fe40007810000ULL, 0x0000001809147209ULL, 0x000fe40007810000ULL,
0x000000130c097209ULL, 0x000fc40007810000ULL, 0x00000019140d7209ULL, 0x000fe40007810000ULL,
0x00000010090c7209ULL, 0x000fe40007810000ULL, 0x0000001a0d327209ULL, 0x000fe40007810000ULL,
0x000000110c367209ULL, 0x000fe20007810000ULL, 0x000017927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032097f89ULL, 0x0004e400000e0000ULL, 0x0000000932377209ULL, 0x008fe20007810000ULL,
0x000017b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0036097f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f0c7f89ULL, 0x000f6200000e0000ULL,
0x0000000936147209ULL, 0x008fc40007810000ULL, 0x0000000d0e157209ULL, 0x010fc60007810000ULL,
0x0c201f0014357f89ULL, 0x002fe200000e0000ULL, 0x0000000c0f097209ULL, 0x020fc60007810000ULL,
0x0c201f00370d7f89ULL, 0x000e6800000e0000ULL, 0x0c201f0015327f89ULL, 0x004ea800000e0000ULL,
0x0c201f0009347f89ULL, 0x00072200000e0000ULL, 0x0000000d370c7209ULL, 0x002fe40007810000ULL,
0x00000035140d7209ULL, 0x000fc40007810000ULL, 0x00000032150e7209ULL, 0x004fe40007810000ULL,
0x3fb8aa3b0c0f7820ULL, 0x008fe20000410000ULL, 0x3fb8aa3b0d367820ULL, 0x000fe20000410000ULL,
0x3c003c00ff157424ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010836ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b18187823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080fULL,
0x0000003100147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080fULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001080fULL, 0x3fb8aa3b1a0f7823ULL, 0x000fe2000001080fULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010836ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26397823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010836ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000002f002f7308ULL, 0x000ef00000000800ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002300387308ULL, 0x0023620000000800ULL, 0x000000302f1a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b1e2f7823ULL, 0x000fcc0000010836ULL, 0x0000001800357308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b1d237823ULL, 0x002fce0000010836ULL, 0x0000001900327308ULL, 0x0003e20000000800ULL,
0x000000331418723eULL, 0x008fe200000000ffULL, 0x3c003c00ff147424ULL, 0x000fcc00078e00ffULL,
0x0000002700317308ULL, 0x000fe20000000800ULL, 0x000000221b19723eULL, 0x002fe400000000ffULL,
0x00000021381b723eULL, 0x020fe200000000ffULL, 0x3fb8aa3b1c217823ULL, 0x000fc80000010836ULL,
0x0000002400377308ULL, 0x000ff00000000800ULL, 0x00000025003a7308ULL, 0x0002f00000000800ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000141824723cULL, 0x002fee00000018ffULL,
0x0000002d002d7308ULL, 0x000e620000000800ULL, 0x000000373a1d723eULL, 0x008fce00000000ffULL,
0x0000002c002c7308ULL, 0x000ff00000000800ULL, 0x0000002b002b7308ULL, 0x000ee20000000800ULL,
0x0000002e2d1c723eULL, 0x002fe200000000ffULL, 0x0000000fff2d7424ULL, 0x000fcc00078e00ffULL,
0x0000003900397308ULL, 0x000ff00000000800ULL, 0x0000001f00227308ULL, 0x000e620000000800ULL,
0x0000002c2b1e723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b202b7823ULL, 0x000fcc0000010836ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x00000039221f723eULL, 0x002fce00000000ffULL,
0x0000002900297308ULL, 0x000e620000000800ULL, 0x000000141c24723cULL, 0x000fee0000001824ULL,
0x0000002800287308ULL, 0x000ef00000000800ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x0000002a2920723eULL, 0x002fce00000000ffULL, 0x0000002300307308ULL, 0x000e620000000800ULL,
0x000000283122723eULL, 0x008fce00000000ffULL, 0x0000002f002f7308ULL, 0x000ff00000000800ULL,
0x0000002b002c7308ULL, 0x000ee20000000800ULL, 0x000000213021723eULL, 0x002fce00000000ffULL,
0x0000001600167308ULL, 0x000e620000000800ULL, 0x0000002f2c23723eULL, 0x008fce00000000ffULL,
0x0000000f000f7308ULL, 0x000ee20000000800ULL, 0x000000142028723cULL, 0x000fee0000001824ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0xfffffffc04247812ULL, 0x000fce00078ec0ffULL,
0x0000001300137308ULL, 0x000f620000000800ULL, 0x000000242d2d7219ULL, 0x000fe400000006ffULL,
0x000000163524723eULL, 0x002fe400000000ffULL, 0x000000002d2c73a1ULL, 0x000e6200000e8000ULL,
0x000000002d0473c4ULL, 0x000f220000004000ULL, 0x000000320f26723eULL, 0x008fe200000000ffULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x00000009340f7209ULL, 0x014fce0007810000ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x000000121325723eULL, 0x020fe400000000ffULL,
0x000000052dff7c12ULL, 0x002fe4000f80402cULL, 0x000000101127723eULL, 0x004fce00000000ffULL,
0x000000142430723cULL, 0x000fe80000001828ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000012e204008947ULL, 0x000fde000b800000ULL, 0x001c1fff30287589ULL, 0x0002a400000e0000ULL,
0x000000002d1073a1ULL, 0x000ee200000e8000ULL, 0x000000002d0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000052dff7c12ULL, 0x008fda000f804010ULL,
0x000012f204008947ULL, 0x010fea000b800000ULL, 0x001c1fff32297589ULL, 0x00072800000e0000ULL,
0x001c1fff2a2a7589ULL, 0x00066800000e0000ULL, 0x001c1fff002b7589ULL, 0x0006a400000e0000ULL,
0x00000002ff097819ULL, 0x000fe40000011604ULL, 0x0000000c0a3b7812ULL, 0x000fc400078ec0ffULL,
0x0000000709107812ULL, 0x040fe200078ec0ffULL, 0x0000000809157824ULL, 0x040fe200078e00ffULL,
0x00000009ff137212ULL, 0x000fe200078e33ffULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0x0000000304ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000809347824ULL, 0x040fe200078e00ffULL,
0x0000000809097810ULL, 0x000fe40007ffe0ffULL, 0xfffffff815127812ULL, 0x100fe400078ee210ULL,
0x0000000111147812ULL, 0x100fe200078ef610ULL, 0x0000000809447824ULL, 0x000fe200078e00ffULL,
0x0000000211167812ULL, 0x100fe200078ef610ULL, 0x0000000809157824ULL, 0x000fe200078e00ffULL,
0x00000003112c7812ULL, 0x000fc400078ef610ULL, 0x00000004112e7812ULL, 0x142fe400078ef610ULL,
0x0000000511307812ULL, 0x140fe400078ef610ULL, 0x0000000611327812ULL, 0x008fe200078ef610ULL,
0x0000000809117824ULL, 0x040fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe400078ee213ULL,
0x00000009ff137212ULL, 0x000fe400078e33ffULL, 0x0000000709107812ULL, 0x000fc400078ec0ffULL,
0x0000a00063097811ULL, 0x000fe400078e58ffULL, 0xfffffff815367812ULL, 0x100fe400078ee210ULL,
0x0000000111387812ULL, 0x140fe200078ef610ULL, 0x00000010120a7824ULL, 0x000fe200078e0209ULL,
0xfffffff844447812ULL, 0x000fe200078ee213ULL, 0x0000001016127824ULL, 0x100fe200078e0209ULL,
0x00000002113a7812ULL, 0x140fe200078ef610ULL, 0x000000102e167824ULL, 0x100fe200078e0209ULL,
0x00000003113c7812ULL, 0x140fe200078ef610ULL, 0x00000010322e7824ULL, 0x100fe200078e0209ULL,
0x00000004113e7812ULL, 0x140fe200078ef610ULL, 0x0000001038327824ULL, 0x100fe200078e0209ULL,
0x0000000511407812ULL, 0x140fe200078ef610ULL, 0x000000103c357824ULL, 0x100fe200078e0209ULL,
0x0000000611427812ULL, 0x000fe200078ef610ULL, 0x0000001014107824ULL, 0x000fc400078e0209ULL,
0x000000102c147824ULL, 0x100fe400078e0209ULL, 0x00000010302c7824ULL, 0x100fe400078e0209ULL,
0x000000013b117824ULL, 0x000fe400078e020aULL, 0x0000001034307824ULL, 0x100fe400078e0209ULL,
0x00000010360a7824ULL, 0x100fe200078e0209ULL, 0x0000001811007388ULL, 0x0003e20000000800ULL,
0x000000103a347824ULL, 0x000fc400078e0209ULL, 0x000000103e367824ULL, 0x100fe400078e0209ULL,
0x0000001040377824ULL, 0x100fe400078e0209ULL, 0x0000001042387824ULL, 0x100fe400078e0209ULL,
0x0000001044397824ULL, 0x000fe400078e0209ULL, 0x000000013b097824ULL, 0x040fe400078e0210ULL,
0x000000013b137824ULL, 0x000fc400078e0212ULL, 0x000000013b157824ULL, 0x040fe200078e0214ULL,
0x0000001a09007388ULL, 0x0003e20000000800ULL, 0x000000013b2d7824ULL, 0x040fe400078e0216ULL,
0x000000013b2f7824ULL, 0x040fe200078e022cULL, 0x0000001c13007388ULL, 0x0003e20000000800ULL,
0x000000013b317824ULL, 0x040fe400078e022eULL, 0x000000013b337824ULL, 0x040fe200078e0230ULL,
0x0000001e15007388ULL, 0x0003e20000000800ULL, 0x000000013b0a7824ULL, 0x000fc400078e020aULL,
0x000000013b327824ULL, 0x040fe200078e0232ULL, 0x000000202d007388ULL, 0x0003e20000000800ULL,
0x000000013b347824ULL, 0x040fe400078e0234ULL, 0x000000013b107824ULL, 0x040fe200078e0235ULL,
0x000000222f007388ULL, 0x0003e20000000800ULL, 0x000000013b367824ULL, 0x040fe400078e0236ULL,
0x000000013b127824ULL, 0x040fe200078e0237ULL, 0x0000002431007388ULL, 0x0003e20000000800ULL,
0x000000013b387824ULL, 0x000fc400078e0238ULL, 0x000000013b147824ULL, 0x000fe200078e0239ULL,
0x0000002633007388ULL, 0x0003e80000000800ULL, 0x000000190a007388ULL, 0x0003e80000000800ULL,
0x0000001b32007388ULL, 0x0003e80000000800ULL, 0x0000001d34007388ULL, 0x0003e80000000800ULL,
0x0000001f10007388ULL, 0x0003e80000000800ULL, 0x0000002136007388ULL, 0x0003e80000000800ULL,
0x0000002312007388ULL, 0x0003e80000000800ULL, 0x0000002538007388ULL, 0x0003e80000000800ULL,
0x0000002714007388ULL, 0x0003e80000000800ULL, 0x0140000c0b008388ULL, 0x0003e80000000c00ULL,
0x014200280b008388ULL, 0x0143e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146080008ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146100008ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146180008ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000175c00720cULL, 0x000fe20003f06070ULL, 0x0146200008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff647224ULL, 0x000fd600078e005cULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff702000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff117807ULL, 0x008fe40004800000ULL, 0x0001923000107802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff057224ULL, 0x000fe200078e001cULL,
0xfffe940000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x0001928000107802ULL, 0x000fe40000000f00ULL, 0x00000e5000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e001cULL, 0xfffe943000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x000fe200078e0005ULL, 0x000192f000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e002bULL,
0xfffe946000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x000fe200078e0005ULL,
0x0001936000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000d3000007944ULL, 0x01cfea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e002bULL, 0xfffe942000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x000fe200078e0003ULL, 0x000193d000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000cc000007944ULL, 0x004fea0003c00000ULL, 0x0000000803167810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff737224ULL, 0x004fe200078e002bULL, 0x0001944000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x002fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e0016ULL, 0x00000c5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x004fe200078e002bULL, 0xfffe965000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004800000ULL, 0x0001949000107802ULL, 0x000fe40000000f00ULL,
0x00000c4000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xfffebcf000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40005000000ULL,
0x000194e000107802ULL, 0x000fe40000000f00ULL, 0x00000bf000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xfffebd2000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x002fe200078e00ffULL, 0x0001954000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x00000b5000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e002bULL, 0xfffebd7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x002fe200078e0016ULL, 0x000195b000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000ae000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e002bULL,
0xfffebe2000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x0001961000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000a8000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff777224ULL, 0x004fe200078e002bULL,
0x0001967000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x002fe400078e0016ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x00000a2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff767224ULL, 0x004fe200078e002bULL,
0xfffebf5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004800000ULL,
0x000196c000107802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e001cULL, 0xfffee1f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40005000000ULL, 0x0001971000107802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xfffee22000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x002fe200078e00ffULL,
0x0001977000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fc400078e00ffULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e002bULL,
0xfffee27000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2f7224ULL, 0x002fe200078e0016ULL,
0x000197e000107802ULL, 0x000fe20000000f00ULL, 0x0000001fff307424ULL, 0x000fc400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000008b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e002bULL, 0xfffee32000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x000fe200078e00ffULL, 0x0001984000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x0000085000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff777224ULL, 0x004fe200078e002bULL, 0x000198a000107802ULL, 0x000fe20000000f00ULL,
0x000000ffff2f7224ULL, 0x002fe400078e0016ULL, 0x0000001fff307424ULL, 0x000fe400078e00ffULL,
0xffffffffff2d7424ULL, 0x000fe400078e00ffULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff787224ULL, 0x004fe200078e002bULL, 0xfffee45000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x000198f000107802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001cULL,
0xffff07d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004800000ULL,
0x0001994000107802ULL, 0x000fc40000000f00ULL, 0x0000079000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001cULL, 0xffff080000007947ULL, 0x000fea000383ffffULL,
0x0000001fff307424ULL, 0x002fe200078e00ffULL, 0x000199a000107802ULL, 0x000fe20000000f00ULL,
0xffffffffff2d7424ULL, 0x000fc400078e00ffULL, 0x000006f000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e002bULL, 0xffff085000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2f7224ULL, 0x002fe200078e0016ULL, 0x00019a1000107802ULL, 0x000fe20000000f00ULL,
0x0000001fff307424ULL, 0x000fc400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000068000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e002bULL,
0xffff090000007947ULL, 0x000fea000383ffffULL, 0x0000001fff307424ULL, 0x000fe200078e00ffULL,
0x00019a7000107802ULL, 0x000fe20000000f00ULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x0000062000007944ULL, 0x020fea0003c00000ULL, 0x000000ffff5d7224ULL, 0x004fe200078e002bULL,
0x00019ad000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x002fe400078e0016ULL,
0x0000001fff307424ULL, 0x000fe400078e00ffULL, 0xffffffffff2d7424ULL, 0x000fe400078e00ffULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e002bULL,
0xffff0a3000007947ULL, 0x000fea000383ffffULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x00019b2000147802ULL, 0x000fc40000000f00ULL, 0x0000053000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0034ULL, 0xffffe83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0036ULL, 0x00019b8000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x00000034360d7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e000eULL,
0x00019bd000147802ULL, 0x000fe20000000f00ULL, 0x00000002ff357424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000340e397209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e000fULL, 0x00019c2000147802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000340f097209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0037ULL,
0x00019c7000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fc400078e00ffULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x00000034370c7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e000dULL, 0x00019cc000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000340d0d7209ULL, 0x004fe20007810000ULL, 0x000000ffff327224ULL, 0x002fe200078e0039ULL,
0x00019d1000147802ULL, 0x000fe20000000f00ULL, 0x00000001ff357424ULL, 0x000fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0x00000034390e7209ULL, 0x004fe20007810000ULL,
0x000000ffff327224ULL, 0x002fe200078e0009ULL, 0x00019d6000147802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xffffe6f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2e7224ULL, 0x000fe200078e0030ULL,
0x00019dc000107802ULL, 0x000fe20000000f00ULL, 0x000000ffff2f7224ULL, 0x000fc400078e00ffULL,
0x00001c1fff307424ULL, 0x000fe400078e00ffULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e002bULL, 0xffffecc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2e7224ULL, 0x002fe200078e0032ULL, 0x00019e3000107802ULL, 0x000fe20000000f00ULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x0000026000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff2f7224ULL, 0x002fe200078e00ffULL,
0x00019e8000107802ULL, 0x000fe20000000f00ULL, 0x00001c1fff307424ULL, 0x000fe400078e00ffULL,
0x000000ffff297224ULL, 0x004fe400078e002bULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2f7224ULL, 0x002fe200078e00ffULL, 0x00019ed000107802ULL, 0x000fe20000000f00ULL,
0x00001c1fff307424ULL, 0x000fc400078e00ffULL, 0x000000ffff2a7224ULL, 0x004fe400078e002bULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xffffec4000007947ULL, 0x000fea000383ffffULL,
0x0180000027037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000002700038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000027047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002700037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff297424ULL, 0x000fc800078e00ffULL,
0xfffe5fb028007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff157424ULL, 0x000fe200078e00ffULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c00003532347389ULL, 0x0002a200000e0038ULL,
0xfffe5f7014007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000002d00007348ULL, 0x000fe80003800000ULL, 0x0000002f2e2b7389ULL, 0x0002a200000e0030ULL,
0xfffe5f3010007950ULL, 0x000fea0003c3ffffULL, 0x000000011100780cULL, 0x000fe20003f45070ULL,
0x0000000e00007348ULL, 0x000fd80003800000ULL, 0x0000000000117806ULL, 0x000fc800050e0100ULL,
0x0000000e111c7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffe5ed010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000290ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000870ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000900ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f50ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f70ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fa0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001030ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001038ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001048ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001200ULL, 0x000000000001a200ULL, 0x7e00001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b400ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001b410ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001b410ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001b890ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001030ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000001a3d0ULL, 0x000000000001a3d0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001b400ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001b890ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 113008;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
