/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x000000000001a610ULL, 0x000000000001a190ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000018b30ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000018ca0ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000018ce0ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000018d20ULL,
0x0000000000000160ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000018e80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00018b3000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x0061800400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8c08288080880828ULL, 0x2880809908288080ULL, 0x80a2082880809d08ULL, 0x08288080a8082880ULL,
0x8080b508288080adULL, 0xda08288080b60828ULL, 0x2880809408288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x0000220028808094ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00018b3000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080840828808081ULL, 0x9908288080850828ULL, 0x2880809d08288080ULL, 0x80a808288080a208ULL,
0x08288080ad082880ULL, 0x8080b608288080b5ULL, 0x8c08288080da0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x002880808c920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x00018ca000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8c08288080880828ULL, 0x2880809908288080ULL,
0x80a2082880809d08ULL, 0x08288080ad082880ULL, 0x8080b608288080b5ULL, 0xa808288080da0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a8920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000001c000000000ULL, 0x00018ce000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8c08288080880828ULL,
0x2880809908288080ULL, 0x80a2082880809d08ULL, 0x08288080a8082880ULL, 0x8080b608288080b5ULL,
0xad08288080da0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080ad920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL, 0x00018d2000000000ULL,
0x0000016000000000ULL, 0x0000180400000000ULL, 0x80a8288080ad0900ULL, 0x0000000000002880ULL,
0x0000001200082f04ULL, 0x00081204000000d7ULL, 0x000000000000000dULL, 0x0000000d00081104ULL,
0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL, 0x0008120400000000ULL,
0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL, 0x000000000000000aULL,
0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL, 0x00080a0400003501ULL,
0x005801600000000eULL, 0x000c170400581903ULL, 0x0050000700000000ULL, 0x000c17040021f000ULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL, 0x0001721000016f00ULL,
0x0001751000017250ULL, 0x0001753000017520ULL, 0xffffffff01a82904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x05000024ffffffffULL,
0x0500002405000024ULL, 0xffffffff05000024ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01a82804ffffffffULL,
0x00000110000000f0ULL, 0x0000263000001670ULL, 0x00002750000026b0ULL, 0x00002a8000002780ULL,
0x00002b0000002a90ULL, 0x0000303000002b70ULL, 0x00003f5000003ea0ULL, 0x00005180000041b0ULL,
0x000052b000005200ULL, 0x000055c0000053d0ULL, 0x00005630000055d0ULL, 0x0000593000005690ULL,
0x000066f0000066e0ULL, 0x000078c0000069c0ULL, 0x000079f000007940ULL, 0x00007cf000007b10ULL,
0x00007d6000007d00ULL, 0x0000804000007dc0ULL, 0x00008e2000008e10ULL, 0x0000a0d0000090f0ULL,
0x0000a2000000a150ULL, 0x0000a5000000a320ULL, 0x0000a5700000a510ULL, 0x0000a8a00000a5d0ULL,
0x0000b6600000b650ULL, 0x0000bac00000bab0ULL, 0x0000e0700000c3b0ULL, 0x0000e7300000e280ULL,
0x0000ef900000e750ULL, 0x00016e0000016dd0ULL, 0x00016e2000016e10ULL, 0x00016e7000016e50ULL,
0x00016e9000016e80ULL, 0x0001756000017500ULL, 0x0001758000017570ULL, 0x00017d0000017ca0ULL,
0x00017de000017d70ULL, 0x00017ec000017e50ULL, 0x00017f8000017f20ULL, 0x0001805000017fe0ULL,
0x00018110000180b0ULL, 0x000181d000018170ULL, 0x000182a000018230ULL, 0x0001836000018300ULL,
0x00018420000183c0ULL, 0x000184f000018480ULL, 0x000185b000018550ULL, 0x000186a000018630ULL,
0x0001878000018710ULL, 0x00018860000187f0ULL, 0x00018940000188d0ULL, 0x00018a40000189c0ULL,
0x00018b0000018aa0ULL, 0x000001f002003904ULL, 0x0001c600000000ffULL, 0x00000230003f0100ULL,
0x0001c6080000000bULL, 0x00000290003f0120ULL, 0x0001c6880000000bULL, 0x00000480003f0120ULL,
0x0001c600000000ffULL, 0x00000600003f0107ULL, 0x0001c68c0000002cULL, 0x00000660003f0102ULL,
0x0001c6880000002cULL, 0x000024b0003f0101ULL, 0x0001c6080000002cULL, 0x000024c0003f0101ULL,
0x0001c60c0000002cULL, 0x00002550003f0105ULL, 0x0001c60c0000002cULL, 0x00004190003f0105ULL,
0x0001c688000000ffULL, 0x00005050003f0101ULL, 0x0001c6280000002cULL, 0x00005060003f0101ULL,
0x0001c62c0000002cULL, 0x000050f0003f0105ULL, 0x0001c62c0000002cULL, 0x00006990003f0105ULL,
0x0001c690000000ffULL, 0x00007790003f0101ULL, 0x0001c6480000002cULL, 0x000077a0003f0101ULL,
0x0001c64c0000002cULL, 0x00007830003f0105ULL, 0x0001c64c0000002cULL, 0x000090c0003f0105ULL,
0x0001c698000000ffULL, 0x00009fa0003f0101ULL, 0x0001c6680000002cULL, 0x00009fb0003f0101ULL,
0x0001c66c0000002cULL, 0x0000a040003f0105ULL, 0x0001c66c0000002cULL, 0x0000b900003f0105ULL,
0x0001c6a0000000ffULL, 0x0000f320003f0101ULL, 0x0001c600000000ffULL, 0x00010f20003f0101ULL,
0x0001c604000000ffULL, 0x00010fc0003f0105ULL, 0x0001c604000000ffULL, 0x00016430003f0105ULL,
0x0000000000000002ULL, 0x00016460003f0101ULL, 0x0000000400000002ULL, 0x000166f0003f0105ULL,
0x0000000400000002ULL, 0x00017af0003f0105ULL, 0x0001c60800000004ULL, 0x00017b50003f0101ULL,
0x0001c61000000004ULL, 0x00017bb0003f0101ULL, 0x0001c61800000004ULL, 0x00017c20003f0101ULL,
0x0001c62000000004ULL, 0x00033803003f0101ULL, 0x0000f1f000101c04ULL, 0x000110b000011020ULL,
0x0000040100017c60ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL, 0xfffffffc00000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL, 0x0000000900000002ULL,
0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000002fcULL, 0x0000001200000002ULL,
0x0000000000000254ULL, 0x0000001200000002ULL, 0x00000000000001acULL, 0x0000001200000002ULL,
0x0000000000000104ULL, 0x0000001200000002ULL, 0x0000000000000044ULL, 0x0000001200000002ULL,
0x00000000000002d2ULL, 0x0000001200000002ULL, 0x000000000000022aULL, 0x0000001200000002ULL,
0x0000000000000182ULL, 0x0000001200000002ULL, 0x00000000000000dfULL, 0x0000001200000002ULL,
0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000107806ULL, 0x000fe200038e0000ULL, 0x00005800ff2e7624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001000027300ULL, 0x000ee200000e0000ULL, 0x000000082e057824ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ea20000002200ULL, 0x00000200ff137424ULL, 0x000fc600078e00ffULL,
0x00000000002f7919ULL, 0x000f220000002600ULL, 0x0000001000107309ULL, 0x000f660000000000ULL,
0x00000000002d7919ULL, 0x000ee80000002700ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000005ff7d7819ULL, 0x002fcc000001160bULL, 0x00001fff7d7d7589ULL, 0x000fe200000e0000ULL,
0x0000000104007824ULL, 0x004fc600078e0203ULL, 0x00001fff04047589ULL, 0x000e6200000e0000ULL,
0x00000080000b7824ULL, 0x000fc600078e020bULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000000082f067824ULL, 0x010fe200078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f25270ULL,
0x0000000f0b00780cULL, 0x000fe20003f44070ULL, 0x0000002d050a7224ULL, 0x008fe200078e0206ULL,
0x0000007f0b00780cULL, 0x040fe40003f84070ULL, 0x000000030b00780cULL, 0x000fe40003f64070ULL,
0x000000070200720cULL, 0x000fca0003f02070ULL, 0x3fffff80ff029424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff039424ULL, 0x000fe400078e00ffULL, 0x0000000404057824ULL, 0x002fe400078e027dULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01c60002ff009388ULL, 0x0003e20000000a00ULL,
0x7fffffc0ff07a424ULL, 0x000fe400078e00ffULL, 0xff317217ff0ec424ULL, 0x000fc400078e00ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x01c608060b00a388ULL, 0x0007e20000008a00ULL,
0x7fffff60ff09b424ULL, 0x000fe400078e00ffULL, 0x00000002050d7824ULL, 0x000fe200078e00ffULL,
0x01c4000e0b00c388ULL, 0x000fe20000004800ULL, 0x0000001000057824ULL, 0x004fe400078e00ffULL,
0x000000010a027824ULL, 0x002fe200078e020dULL, 0x01c688080b00b388ULL, 0x0003e20000008a00ULL,
0x000000080d0c7817ULL, 0x000fc40007800000ULL, 0x000000010d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00005c0002027625ULL, 0x000fe200078e0013ULL, 0x000001f005117812ULL, 0x000fc600078ec0ffULL,
0x000000010c0c7824ULL, 0x000fe400078e0a0dULL, 0x000000010a067824ULL, 0x008fe200078e020fULL,
0x000000070d097812ULL, 0x002fe400078ec0ffULL, 0x000000070f0b7812ULL, 0x000fe200078ec0ffULL,
0x00005c0006067625ULL, 0x000fe200078e0013ULL, 0x0000001f090a7812ULL, 0x000fe200078e7800ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001102087210ULL, 0x080fe40007f7e0ffULL,
0x000000ff0c00720cULL, 0x040fe20003f23070ULL, 0x000000200d0a7824ULL, 0x000fe200078e020aULL,
0x0000001f0b027812ULL, 0x000fe200078e7800ULL, 0x000000ffff097224ULL, 0x000fe200018e0603ULL,
0x000000010c00780cULL, 0x000fe20003f43070ULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x0000001106067210ULL, 0x000fe20007f9e0ffULL, 0x000000200f027824ULL, 0x000fc400078e0202ULL,
0x000000ffff0a7224ULL, 0x020fe400078e0a10ULL, 0x000000ffff077224ULL, 0x000fe400020e0607ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000062002d027625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e8000c901c46ULL, 0x00000000060d7faeULL, 0x0003e8000d101c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01c6040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006027c7981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0400720cULL, 0x000fe20003f05270ULL, 0x00000004ff7e7e24ULL, 0x008fe2000f8e00ffULL,
0x0000007f7c7b7810ULL, 0x004fc40007ffe0ffULL, 0x000000ff7c797810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff7b7819ULL, 0x000fe4000001167bULL, 0x00000008ff797819ULL, 0x000fca0000011679ULL,
0x0000ec7000008947ULL, 0x000fea0003800000ULL, 0x000000027e267824ULL, 0x040fe200078e00ffULL,
0x000000017e027810ULL, 0x000fe20007ffe0ffULL, 0x000000087d2c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x000000790200720cULL, 0x000fe40003f26070ULL,
0x0000007b2600720cULL, 0x000fe20003f06070ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c68c032cff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c688002cff7f8cULL, 0x0007e2000c80043fULL, 0xffffffffff237424ULL, 0x000fe200078e00ffULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x0000640026037a10ULL, 0x004fe20007ffe0ffULL,
0x000000022d027824ULL, 0x000fc800078e00ffULL, 0x0000640002027a24ULL, 0x000fc800078e0203ULL,
0x0000600002027625ULL, 0x000fca00078e000fULL, 0x0000000602237981ULL, 0x000564000c1e1900ULL,
0x0000580023027a24ULL, 0x024fc800078e02ffULL, 0x00000080021f7824ULL, 0x000fe200078e00ffULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x002fe20000011600ULL,
0x000001007e037824ULL, 0x000fc600078e00ffULL, 0x00000004090b7810ULL, 0x040fe40007ffe0ffULL,
0x00000008090d7810ULL, 0x000fe40007ffe0ffULL, 0x000000000b047212ULL, 0x0c0fe200078e3cffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x0000001009117810ULL, 0x000fe20007ffe0ffULL,
0x000000080d167824ULL, 0x040fe200078e00ffULL, 0x000000000d057212ULL, 0x000fe400078e3cffULL,
0xfffffff80f147812ULL, 0x000fe200078ee204ULL, 0x000000802f047824ULL, 0x000fe200078e0209ULL,
0x0000001409197810ULL, 0x000fe20007ffe0ffULL, 0x00000008111a7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fc400078ee205ULL, 0x0000000011057212ULL, 0x000fe200078e3cffULL,
0x0000000819157824ULL, 0x000fe200078e00ffULL, 0x000000037c027217ULL, 0x000fe40007800000ULL,
0x0000000c090f7810ULL, 0x000fe40007ffe0ffULL, 0x000000041f087210ULL, 0x000fe20007f1e0ffULL,
0x0000000102077824ULL, 0x000fe200078e0a03ULL, 0x0000000019067212ULL, 0x000fe200078e3cffULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL,
0x000000ffff137224ULL, 0x000fe200000e06ffULL, 0x0000000404057810ULL, 0x000fc40007ffe0ffULL,
0x000000000f037212ULL, 0x000fe400078e3cffULL, 0xfffffff8151c7812ULL, 0x000fe400078ee206ULL,
0x00005e0008027a11ULL, 0x000fe400078048ffULL, 0x0000000804067810ULL, 0x000fe40007ffe0ffULL,
0x000000051f057210ULL, 0x000fe40007f9e0ffULL, 0xfffffff818187812ULL, 0x000fc400078ee203ULL,
0x00005f0008037a11ULL, 0x000fe400000f4c13ULL, 0x000000061f157210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff067224ULL, 0x000fe200020e06ffULL, 0x0000000c04087810ULL, 0x040fe40007ffe0ffULL,
0x00000010040a7810ULL, 0x040fe40007ffe0ffULL, 0x00000014040c7810ULL, 0x040fe40007ffe0ffULL,
0x00000018040e7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c04107810ULL, 0x000fe40007ffe0ffULL,
0x00005e0005047a11ULL, 0x000fe400078c48ffULL, 0x00000018091b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1f227210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x0000001c091d7810ULL, 0x000fe20007ffe0ffULL, 0x000000081b177824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a11ULL, 0x000fc400030f4c06ULL, 0x00005e0015067a11ULL, 0x000fe200078448ffULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x0000002007127817ULL, 0x000fe40003800000ULL,
0x000000081f137210ULL, 0x040fe40007f1e0ffULL, 0x0000000a1f247210ULL, 0x000fe40007f3e0ffULL,
0x000000001b087212ULL, 0x080fe400078e3cffULL, 0x00005f0015077a11ULL, 0x000fe200010f4c0cULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000001d0a7212ULL, 0x000fc400078e3cffULL,
0x000000120900720cULL, 0x040fe40003f46070ULL, 0x0000000709097812ULL, 0x000fe400078e4800ULL,
0xfffffff8171e7812ULL, 0x000fe200078ee208ULL, 0x000000087d177824ULL, 0x000fe200078e00ffULL,
0xfffffff825207812ULL, 0x000fe400078ee20aULL, 0x00005e0013087a11ULL, 0x000fe400078c48ffULL,
0x000140007d157811ULL, 0x000fc400078e68ffULL, 0x0ffffff8090a7812ULL, 0x000fe400078ef800ULL,
0x00005f0013097a11ULL, 0x000fe400030f4c0cULL, 0x000000120b00720cULL, 0x080fe20003f06070ULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0xfffffff817137812ULL, 0x000fe200078ee200ULL,
0x000000100a177824ULL, 0x000fe200078e0215ULL, 0x00005e00240a7a11ULL, 0x040fe400078c48ffULL,
0x000000120d00720cULL, 0x000fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200018e06ffULL,
0x0000000e1f217210ULL, 0x000fe20007fbe0ffULL, 0x0000001013027825ULL, 0x000fe200078e0002ULL,
0x00005f00240b7a11ULL, 0x000fc400030f4c0bULL, 0x000000101f1f7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e00220c7a11ULL, 0x040fe200078c48ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e2000d101c46ULL,
0x00005e00210e7a11ULL, 0x000fe400078a48ffULL, 0x00005f00220d7a11ULL, 0x000fe200030f4c0dULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005e001f107a11ULL, 0x000fe400078c48ffULL,
0x000000120f00720cULL, 0x000fc40003f66070ULL, 0x000000121100720cULL, 0x080fe40003f46070ULL,
0x000000121900720cULL, 0x080fe20003f86070ULL, 0x0000001014177824ULL, 0x002fe200078e0215ULL,
0x00005f00210f7a11ULL, 0x000fe200028f4c24ULL, 0x0000001013027825ULL, 0x000fe200078e0004ULL,
0x000000121b00720cULL, 0x080fe40003fa6070ULL, 0x00005f001f117a11ULL, 0x000fe200030f4c22ULL,
0x0000001016197824ULL, 0x000fe200078e0215ULL, 0x000000121d00720cULL, 0x000fe20003fc6070ULL,
0x0000001013047825ULL, 0x040fe200078e0006ULL, 0x0000000002177faeULL, 0x0003e6000c101c46ULL,
0x00000010181b7824ULL, 0x000fe200078e0215ULL, 0x0000000004197faeULL, 0x0003e2000c901c46ULL,
0x0000001013067825ULL, 0x000fc800078e0008ULL, 0x000000101a1d7824ULL, 0x000fe200078e0215ULL,
0x00000000061b7faeULL, 0x0003e2000d901c46ULL, 0x0000001013087825ULL, 0x000fc800078e000aULL,
0x000000101c1f7824ULL, 0x000fe200078e0215ULL, 0x00000000081d7faeULL, 0x0003e2000d101c46ULL,
0x00000010130a7825ULL, 0x000fc800078e000cULL, 0x000000101e217824ULL, 0x000fe200078e0215ULL,
0x000000000a1f7faeULL, 0x0003e2000e101c46ULL, 0x00000010130c7825ULL, 0x000fc800078e000eULL,
0x0000001020157824ULL, 0x000fe200078e0215ULL, 0x000000000c217faeULL, 0x0003e2000e901c46ULL,
0x00000010130e7825ULL, 0x000fca00078e0010ULL, 0x000000000e157faeULL, 0x0003e2000f101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fe20000011600ULL,
0x000000087d137824ULL, 0x000fc600078e00ffULL, 0x0000000404037810ULL, 0x040fe20007ffe0ffULL,
0x000000802f067824ULL, 0x002fe200078e0204ULL, 0x0000000804057810ULL, 0x040fe40007ffe0ffULL,
0x0000000c04077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803097824ULL, 0x040fe200078e00ffULL,
0x0000000003027212ULL, 0x080fe200078e3cffULL, 0x00000008050e7824ULL, 0x040fe200078e00ffULL,
0x0000000005037212ULL, 0x080fe200078e3cffULL, 0x0000000807127824ULL, 0x040fe200078e00ffULL,
0x0000000007057212ULL, 0x000fc400078e3cffULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee203ULL,
0x0000001004037810ULL, 0x000fe40007ffe0ffULL, 0xfffffff812127812ULL, 0x000fe400078ee205ULL,
0x0000000003057212ULL, 0x040fe200078e3cffULL, 0x0000000803167824ULL, 0x000fe200078e00ffULL,
0x000000061f037210ULL, 0x000fe40007f1e0ffULL, 0x0000001404077810ULL, 0x000fc40007ffe0ffULL,
0x00000018040b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee202ULL, 0x00000008071a7824ULL, 0x000fe200078e00ffULL,
0x00005e0003027a11ULL, 0x000fe200078048ffULL, 0x000000080b1e7824ULL, 0x000fe200078e00ffULL,
0x0000000007097212ULL, 0x080fe400078e3cffULL, 0x000000000b077212ULL, 0x000fe400078e3cffULL,
0x00005f0003037a11ULL, 0x000fc400000f4c08ULL, 0x0000000406087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee207ULL, 0x0000001c04077810ULL, 0x000fe40007ffe0ffULL,
0x00000008060c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c06107810ULL, 0x040fe20007ffe0ffULL,
0x0000000807207824ULL, 0x000fe200078e00ffULL, 0x0000001006147810ULL, 0x000fc40007ffe0ffULL,
0x0000001406187810ULL, 0x040fe40007ffe0ffULL, 0x00000018061c7810ULL, 0x000fe40007ffe0ffULL,
0x000000081f087210ULL, 0x000fe40007fde0ffULL, 0xfffffff816167812ULL, 0x000fe400078ee205ULL,
0x0000001c06067810ULL, 0x000fe40007ffe0ffULL, 0x0000000704057812ULL, 0x000fc400078e4800ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x000000061f117210ULL, 0x000fe40007f5e0ffULL, 0x00000000070b7212ULL, 0x000fe400078e3cffULL,
0x0000000c1f0c7210ULL, 0x000fe40007fbe0ffULL, 0x00005e0008047a11ULL, 0x000fe400078c48ffULL,
0x000140007d077811ULL, 0x000fc400078e68ffULL, 0x0ffffff805067812ULL, 0x100fe400078ef800ULL,
0x000000101f107210ULL, 0x040fe20007f9e0ffULL, 0x000000100a177824ULL, 0x000fe200078e0207ULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x0000001006157824ULL, 0x000fe200078e0207ULL,
0x00005f0008057a11ULL, 0x000fe200030f4c09ULL, 0x000000ffff097224ULL, 0x000fe200028e06ffULL,
0x00005e000c067a11ULL, 0x000fe200078a48ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e06ffULL,
0x000000141f147210ULL, 0x040fe20007f7e0ffULL, 0x000000100e197824ULL, 0x100fe200078e0207ULL,
0x00005e0010087a11ULL, 0x000fe200078848ffULL, 0x00000010121b7824ULL, 0x100fe200078e0207ULL,
0x000000181f187210ULL, 0x040fe20007f1e0ffULL, 0x00000010161d7824ULL, 0x100fe200078e0207ULL,
0x0000001c1f1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101a1f7824ULL, 0x100fe200078e0207ULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x000000101e217824ULL, 0x000fc400078e0207ULL,
0x0000001020257824ULL, 0x000fe200078e0207ULL, 0x00005f000c077a11ULL, 0x000fe200028f4c09ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005f0010097a11ULL, 0x000fe200020f4c0bULL,
0x000000ffff0b7224ULL, 0x000fe200018e06ffULL, 0x00005e00140a7a11ULL, 0x000fe200078648ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0x00005e00180c7a11ULL, 0x000fe200078048ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x00005e001c0e7a11ULL, 0x000fe200078248ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x00005e0011107a11ULL, 0x000fc400078448ffULL,
0x00005f00140b7a11ULL, 0x000fe200018f4c0bULL, 0x0000001013047825ULL, 0x040fe200078e0004ULL,
0x00005f00180d7a11ULL, 0x000fe200000f4c0dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002157faeULL, 0x0003e2000b901c46ULL, 0x00005f001c0f7a11ULL, 0x000fe200008f4c0fULL,
0x0000001013067825ULL, 0x000fe200078e0006ULL, 0x00005f0011117a11ULL, 0x000fe200010f4c12ULL,
0x0000000004177faeULL, 0x0003e4000b901c46ULL, 0x0000001013087825ULL, 0x040fe400078e0008ULL,
0x0000000006197faeULL, 0x0003e4000b901c46ULL, 0x00000010130a7825ULL, 0x000fc400078e000aULL,
0x00000000081b7faeULL, 0x0003e4000b901c46ULL, 0x00000010130c7825ULL, 0x040fe400078e000cULL,
0x000000000a1d7faeULL, 0x0003e4000b901c46ULL, 0x00000010130e7825ULL, 0x040fe400078e000eULL,
0x000000000c1f7faeULL, 0x0003e4000b901c46ULL, 0x0000001013107825ULL, 0x000fc400078e0010ULL,
0x000000000e217faeULL, 0x0003e8000b901c46ULL, 0x0000000010257faeULL, 0x0003e4000b901c46ULL,
0x000000797e00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff027424ULL, 0x002fe200078e00ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000a38000000947ULL, 0x000fea0003800000ULL, 0x000000022d2d7824ULL, 0x000fe400078e00ffULL,
0x00006400ff047624ULL, 0x000fc400078e00ffULL, 0xff317217ff027424ULL, 0x000fe400078e00ffULL,
0x000000ffff337224ULL, 0x000fe400078e00ffULL, 0x000064002d047624ULL, 0x000fe400078e0204ULL,
0x000001007e057824ULL, 0x000fca00078e00ffULL, 0x0000007c0500720cULL, 0x000fda0003f06070ULL,
0x0000a2c000000947ULL, 0x008fea0003800000ULL, 0x000000017e067810ULL, 0x000fe20007ffe0ffULL,
0x0000580023247a24ULL, 0x000fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000790600720cULL, 0x000fe20003f06070ULL, 0x000000ffff057224ULL, 0x000fe400078e0026ULL,
0x0000008024247824ULL, 0x000fd400078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x000fe40000011600ULL, 0x000000207e097811ULL, 0x000fe400078e40ffULL,
0x0000000c17217810ULL, 0x040fe40007ffe0ffULL, 0x000000097c067217ULL, 0x000fe40007800000ULL,
0x0000001017277810ULL, 0x000fe20007ffe0ffULL, 0x00000008210c7824ULL, 0x000fe200078e00ffULL,
0x00000004170d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106067824ULL, 0x000fe200078e0a09ULL,
0x0000001817357810ULL, 0x000fe20007ffe0ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0x0000000817197810ULL, 0x000fe20007ffe0ffULL, 0x000000080d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000021097212ULL, 0x080fe200078e3cffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x00000000270a7212ULL, 0x000fe200078e3cffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x000000202f147811ULL, 0x000fc400078e38ffULL, 0x000000000d087212ULL, 0x080fe400078e3cffULL,
0xfffffff80c257812ULL, 0x000fe200078ee209ULL, 0x0000000117097824ULL, 0x000fe200078e0214ULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000001270f7824ULL, 0x000fe200078e0214ULL,
0xfffffff81d1d7812ULL, 0x000fe400078ee208ULL, 0x00000014172b7810ULL, 0x000fe40007ffe0ffULL,
0x00000000350a7212ULL, 0x000fc400078e3cffULL, 0x0000000019087212ULL, 0x080fe200078e3cffULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0x0000001c17397810ULL, 0x000fe40007ffe0ffULL,
0xfffffff837377812ULL, 0x000fe400078ee20aULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL,
0x00000008393b7824ULL, 0x000fe200078e00ffULL, 0x00000009240a7210ULL, 0x000fe20007f3e0ffULL,
0x000000010d097824ULL, 0x000fe200078e0214ULL, 0x000000002b087212ULL, 0x000fc400078e3cffULL,
0x00000000390c7212ULL, 0x000fe200078e3cffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee208ULL, 0x00005e000a087a11ULL, 0x000fe400078248ffULL,
0xfffffff83b3b7812ULL, 0x000fe400078ee20cULL, 0x00000009240c7210ULL, 0x000fe40007f5e0ffULL,
0x0000002006067817ULL, 0x000fc40003800000ULL, 0x00005f000a097a11ULL, 0x000fe200008f4c0bULL,
0x00000001190b7824ULL, 0x100fe200078e0214ULL, 0x000000060d00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff117224ULL, 0x000fe200010e06ffULL, 0x00005e000c0a7a11ULL, 0x000fe200078248ffULL,
0x00000001210d7824ULL, 0x000fe200078e0214ULL, 0x0000000b24157210ULL, 0x000fe40007f5e0ffULL,
0x00005f000c0b7a11ULL, 0x000fe400008f4c11ULL, 0x0000000d24137210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e00150c7a11ULL, 0x000fc400078448ffULL,
0x00005e00130e7a11ULL, 0x000fe200078648ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x00005f00150d7a11ULL, 0x000fe200010f4c18ULL, 0x000000012b157824ULL, 0x000fe200078e0214ULL,
0x0000000f24117210ULL, 0x000fe40007f9e0ffULL, 0x00005f00130f7a11ULL, 0x000fe400018f4c16ULL,
0x0000000700137812ULL, 0x000fe200078ec0ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x000000061700720cULL, 0x000fc40003f46070ULL, 0x0000001524167210ULL, 0x000fe20007f7e0ffULL,
0x0000000135157824ULL, 0x000fe200078e0214ULL, 0x00005e0011107a11ULL, 0x000fe400078848ffULL,
0x0000000717177812ULL, 0x000fe400078e4800ULL, 0x000000061900720cULL, 0x000fe20003f26070ULL,
0x000000012c197824ULL, 0x000fe200078e0213ULL, 0x00005f0011117a11ULL, 0x000fe200020f4c12ULL,
0x000000ffff137224ULL, 0x000fe200018e06ffULL, 0x000150007d187811ULL, 0x000fe200078e68ffULL,
0x0000001019087825ULL, 0x000fe200078e0008ULL, 0x0ffffff817177812ULL, 0x000fc400078ef800ULL,
0x00005e0016127a11ULL, 0x040fe200078648ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0218ULL,
0x000000062100720cULL, 0x080fe20003f86070ULL, 0x00000010171b7824ULL, 0x000fe200078e0218ULL,
0x00005f0016137a11ULL, 0x000fe200018f4c13ULL, 0x0000000139177824ULL, 0x000fe200078e0214ULL,
0x0000001524157210ULL, 0x040fe20007f7e0ffULL, 0x00000010190a7825ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000081b7faeULL, 0x0003e4000d101c46ULL,
0x0000001724177210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078c48ffULL, 0x000000000a1d7faeULL, 0x0005e2000e901c46ULL,
0x000000062700720cULL, 0x080fe20003f66070ULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005f0015157a11ULL, 0x000fe200030f4c16ULL, 0x0000001029217824ULL, 0x100fe200078e0218ULL,
0x00005e0017167a11ULL, 0x000fe200078448ffULL, 0x0000001037277824ULL, 0x100fe200078e0218ULL,
0x000000062b00720cULL, 0x080fe20003fc6070ULL, 0x000000101f1b7824ULL, 0x002fe200078e0218ULL,
0x000000063500720cULL, 0x000fe20003fa6070ULL, 0x0000001019087825ULL, 0x000fe200078e000cULL,
0x00005f0017177a11ULL, 0x000fc400010f4c1aULL, 0x000000063900720cULL, 0x000fe20003f46070ULL,
0x00000010251f7824ULL, 0x000fe200078e0218ULL, 0x00000000081b7faeULL, 0x0003e2000c901c46ULL,
0x00000010190a7825ULL, 0x004fc800078e000eULL, 0x00000010190c7825ULL, 0x000fe200078e0010ULL,
0x000000000a1f7faeULL, 0x0003e6000e101c46ULL, 0x000000102d257824ULL, 0x000fe200078e0218ULL,
0x000000000c217faeULL, 0x0003e2000d901c46ULL, 0x00000010190e7825ULL, 0x000fc800078e0012ULL,
0x0000001019107825ULL, 0x000fe200078e0014ULL, 0x000000000e257faeULL, 0x0003e6000f101c46ULL,
0x000000103b297824ULL, 0x000fe200078e0218ULL, 0x0000000010277faeULL, 0x0003e2000e901c46ULL,
0x0000001019127825ULL, 0x000fca00078e0016ULL, 0x0000000012297faeULL, 0x0003e2000d101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fc80000011600ULL,
0x00000004090f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c09177810ULL, 0x000fe40007ffe0ffULL,
0x000000000f067212ULL, 0x0c0fe200078e3cffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0x0000000809137810ULL, 0x000fe20007ffe0ffULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0x00000010091b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee206ULL,
0x0000000813157824ULL, 0x000fe200078e00ffULL, 0x0000000017067212ULL, 0x080fe200078e3cffULL,
0x000000081b277824ULL, 0x000fe200078e00ffULL, 0x0000000013087212ULL, 0x000fc400078e3cffULL,
0xfffffff819197812ULL, 0x000fe400078ee206ULL, 0x000000202f067811ULL, 0x000fe400078e38ffULL,
0x00000014091d7810ULL, 0x040fe40007ffe0ffULL, 0x00000018091f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090b7824ULL, 0x140fe200078e0206ULL, 0x0000001c09217810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0f7824ULL, 0x000fe200078e0206ULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x0000000113137824ULL, 0x100fe200078e0206ULL, 0x0000000b240b7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117177824ULL, 0x100fe200078e0206ULL, 0x000000001b087212ULL, 0x0c0fe200078e3cffULL,
0x000000011b257824ULL, 0x000fe200078e0206ULL, 0x00000007090d7812ULL, 0x000fe200078e4800ULL,
0x000000011d297824ULL, 0x000fe200078e0206ULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x000000011f2d7824ULL, 0x140fe200078e0206ULL, 0x000000001f097212ULL, 0x080fe200078e3cffULL,
0x0000000121377824ULL, 0x000fe200078e0206ULL, 0x000000001d0a7212ULL, 0x080fe200078e3cffULL,
0x000000081f0e7824ULL, 0x000fe200078e00ffULL, 0x00000000210c7212ULL, 0x000fe200078e3cffULL,
0x000000081d2b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80d0d7812ULL, 0x000fe200078ef800ULL,
0x000000ffff067224ULL, 0x000fe200008e06ffULL, 0x00005e000b087a11ULL, 0x000fe200078248ffULL,
0x0000000821397824ULL, 0x000fe200078e00ffULL, 0xfffffff80e357812ULL, 0x000fc400078ee209ULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee20aULL, 0x00005f000b097a11ULL, 0x000fe400008f4c06ULL,
0x000150007d0a7811ULL, 0x000fe400078e68ffULL, 0xfffffff839397812ULL, 0x000fe400078ee20cULL,
0x0000000f240f7210ULL, 0x040fe20007f3e0ffULL, 0x000000100d1b7824ULL, 0x100fe200078e020aULL,
0x0000001324137210ULL, 0x040fe20007f5e0ffULL, 0x00000010111d7824ULL, 0x100fe200078e020aULL,
0x0000001724177210ULL, 0x000fe20007f7e0ffULL, 0x00000010151f7824ULL, 0x100fe200078e020aULL,
0x0000000700117812ULL, 0x000fe200078ec0ffULL, 0x0000001019217824ULL, 0x100fe200078e020aULL,
0x0000002d242d7210ULL, 0x000fe20007f9e0ffULL, 0x0000001027277824ULL, 0x000fc400078e020aULL,
0x000000102b2b7824ULL, 0x100fe400078e020aULL, 0x0000001035357824ULL, 0x100fe400078e020aULL,
0x0000001039397824ULL, 0x000fe400078e020aULL, 0x000000ffff067224ULL, 0x000fe200008e06ffULL,
0x00005e000f0a7a11ULL, 0x000fe200078248ffULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0x00005e00130c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x00005e00170e7a11ULL, 0x000fe200078648ffULL, 0x000000012c197824ULL, 0x000fe200078e0211ULL,
0x00005f000f0b7a11ULL, 0x000fe200008f4c06ULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005f00130d7a11ULL, 0x000fe200010f4c10ULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0x00005f00170f7a11ULL, 0x000fc400018f4c12ULL, 0x0000002524257210ULL, 0x040fe20007f5e0ffULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0x0000002924297210ULL, 0x040fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000081b7faeULL, 0x0003e2000b901c46ULL,
0x0000003724377210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x00005e0025107a11ULL, 0x000fe200078448ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x00005e0029127a11ULL, 0x000fe200078648ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e002d147a11ULL, 0x000fe200078848ffULL, 0x00000010190c7825ULL, 0x000fe200078e000cULL,
0x00005e0037167a11ULL, 0x000fe200078248ffULL, 0x000000000a1d7faeULL, 0x0003e2000b901c46ULL,
0x00005f0025117a11ULL, 0x000fe200010f4c06ULL, 0x00000010190e7825ULL, 0x000fe200078e000eULL,
0x00005f0029137a11ULL, 0x000fe200018f4c18ULL, 0x000000000c1f7faeULL, 0x0003e2000b901c46ULL,
0x00005f002d157a11ULL, 0x000fe200020f4c1aULL, 0x0000001019107825ULL, 0x000fe200078e0010ULL,
0x00005f0037177a11ULL, 0x000fe200008f4c1cULL, 0x000000000e217faeULL, 0x0003e4000b901c46ULL,
0x0000001019127825ULL, 0x000fc400078e0012ULL, 0x0000000010277faeULL, 0x0003e4000b901c46ULL,
0x0000001019147825ULL, 0x040fe400078e0014ULL, 0x00000000122b7faeULL, 0x0003e4000b901c46ULL,
0x0000001019167825ULL, 0x000fe400078e0016ULL, 0x0000000014357faeULL, 0x0003e8000b901c46ULL,
0x0000000016397faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c608002c087f8cULL, 0x002fe8000c80043fULL,
0x01c60c002c0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007824809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff067424ULL, 0x000fc800078e00ffULL,
0x00000006000a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000006067823ULL, 0x002fe200000100ffULL,
0x0000000a0000735dULL, 0x004fe20003800000ULL, 0x01c60c002c0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000067824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fc80000011600ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c08097812ULL, 0x000fca00078ec0ffULL,
0x0000000106067824ULL, 0x000fca00078e0209ULL, 0x01c0000006097984ULL, 0x000e680000000800ULL,
0x01c2000006087984ULL, 0x0005220000000800ULL, 0x000000020900720bULL, 0x002fe20003f3d000ULL,
0x000156427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000a7806ULL, 0x004fc800008e0100ULL,
0x0000ffff0a0b7812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff137424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff7d00720cULL, 0x000fe40003f25270ULL, 0x000000020900720bULL, 0x000fe20003f54000ULL,
0x000156227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000a7806ULL, 0x000fe400010e0100ULL,
0x00000009020d7209ULL, 0x000fe40007810000ULL, 0x0000ffff0a0a7812ULL, 0x000fc600078e3cffULL,
0x8000000d02027221ULL, 0x000fe20000010000ULL, 0x01c4000d06009388ULL, 0x0003e20000000800ULL,
0x0000000a0bff7212ULL, 0x000fe4000782c0ffULL, 0x3fb8aa3b02027820ULL, 0x000fe20000410000ULL,
0x00000002ff0a7819ULL, 0x000fc60000011600ULL, 0x0000000200357308ULL, 0x0002a20000000800ULL,
0x000155e27f007947ULL, 0x000fec000b800000ULL, 0x00001f0a35027589ULL, 0x0062a400000e0000ULL,
0x000000080a0a7810ULL, 0x002fe20007ffe0ffULL, 0x000156227f007947ULL, 0x000fea000b800000ULL,
0x00001f0a350a7589ULL, 0x0002e400000e0000ULL, 0x8000000d09091221ULL, 0x000fe20000010000ULL,
0x00000001ff137807ULL, 0x000fe20000800000ULL, 0x0000000231317220ULL, 0x084fe40000410000ULL,
0x3fb8aa3b09091820ULL, 0x000fe40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000900071308ULL, 0x000ea20000000800ULL, 0x000000024d4d7220ULL, 0x000fc40000410000ULL,
0x000000024c4c7220ULL, 0x080fe40000410000ULL, 0x0000000261617220ULL, 0x080fe40000410000ULL,
0x0000000260607220ULL, 0x080fe40000410000ULL, 0x0000000265657220ULL, 0x080fe40000410000ULL,
0x0000000264647220ULL, 0x080fe40000410000ULL, 0x000000025d5d7220ULL, 0x000fc40000410000ULL,
0x000000025c5c7220ULL, 0x080fe40000410000ULL, 0x0000000259597220ULL, 0x080fe40000410000ULL,
0x0000000258587220ULL, 0x080fe40000410000ULL, 0x0000000255557220ULL, 0x080fe40000410000ULL,
0x0000000254547220ULL, 0x080fe40000410000ULL, 0x0000000251517220ULL, 0x000fc40000410000ULL,
0x0000000250507220ULL, 0x000fe40000410000ULL, 0x0000003503037220ULL, 0x000fe40000410000ULL,
0x0000000a33337220ULL, 0x088fe40000410000ULL, 0x0000000a32327220ULL, 0x080fe40000410000ULL,
0x0000000a4f4f7220ULL, 0x080fe40000410000ULL, 0x0000000a4e4e7220ULL, 0x000fc40000410000ULL,
0x0000000a63637220ULL, 0x080fe40000410000ULL, 0x0000000a62627220ULL, 0x080fe40000410000ULL,
0x0000000a67677220ULL, 0x080fe40000410000ULL, 0x0000000a66667220ULL, 0x080fe40000410000ULL,
0x0000000a5f5f7220ULL, 0x080fe40000410000ULL, 0x0000000a5e5e7220ULL, 0x000fc40000410000ULL,
0x0000000a5b5b7220ULL, 0x080fe40000410000ULL, 0x0000000a5a5a7220ULL, 0x080fe40000410000ULL,
0x0000000a57577220ULL, 0x080fe40000410000ULL, 0x0000000a56567220ULL, 0x080fe40000410000ULL,
0x0000000a53537220ULL, 0x080fe40000410000ULL, 0x0000000a52527220ULL, 0x000fc40000410000ULL,
0x000000ffff027224ULL, 0x000fe400078e000dULL, 0x0000000708081220ULL, 0x014fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000308037221ULL, 0x010fe20000010000ULL,
0x00000007ff08723eULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff0a7819ULL, 0x000fe40000011600ULL, 0x0000541008357816ULL, 0x002fe20000000008ULL,
0x000153a27f007947ULL, 0x000fea000b800000ULL, 0x000000080a087810ULL, 0x000fe20007ffe0ffULL,
0x00001f0a35177589ULL, 0x0002a800000e0000ULL, 0x00001f0835767589ULL, 0x00032400000e0000ULL,
0x000000100a097810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x002fe200078e0009ULL, 0x00002b1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x000161d000007944ULL, 0x01cfea0003c00000ULL, 0x000000180a0a7810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x000fe200078e000aULL,
0x00002b8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0001616000007944ULL, 0x01cfea0003c00000ULL,
0x00000007000b7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff0e7819ULL, 0x100fe40000011600ULL, 0x000000080b217812ULL, 0x000fe400078ef800ULL,
0x00000008000d7812ULL, 0x000fc400078ec0ffULL, 0x000000070e0c7812ULL, 0x000fca00078e7821ULL,
0x00000008210c7824ULL, 0x000fca00078e020cULL, 0x000120000c1c7811ULL, 0x000fca00078e20ffULL,
0x000000070d0f7812ULL, 0x140fe200078ec800ULL, 0x000000001c1c783bULL, 0x000f620000000200ULL,
0x000000020e107810ULL, 0x040fe40007ffe0ffULL, 0x000000040e127810ULL, 0x040fe40007ffe0ffULL,
0x000000060e167810ULL, 0x000fe40007ffe0ffULL, 0x000000070d147812ULL, 0x000fe400078ef800ULL,
0x0000000e0f157212ULL, 0x000fc400078e3cffULL, 0x000000100f197212ULL, 0x040fe400078e3cffULL,
0x000000120f1b7212ULL, 0x040fe200078e3cffULL, 0x00000008146e7824ULL, 0x040fe200078e0215ULL,
0x000000160f257212ULL, 0x000fe200078e3cffULL, 0x00000008146c7824ULL, 0x040fe200078e0219ULL,
0x000140007d0d7811ULL, 0x000fe200078e68ffULL, 0x00000008144a7824ULL, 0x000fe200078e021bULL,
0x0000000710127812ULL, 0x000fe200078e7821ULL, 0x0000000814487824ULL, 0x040fe200078e0225ULL,
0x0000008014147811ULL, 0x000fe200078e18ffULL, 0x000000106e0e7824ULL, 0x100fe200078e020dULL,
0x0000991013137816ULL, 0x000fe200000000ffULL, 0x000000106c0f7824ULL, 0x000fc400078e020dULL,
0x000000104a107824ULL, 0x100fe200078e020dULL, 0x000000000e70783bULL, 0x000e620000004200ULL,
0x0000001048117824ULL, 0x000fe200078e020dULL, 0x000000ff1300720cULL, 0x000fe20003f25270ULL,
0x0000000821127824ULL, 0x000fe200078e0212ULL, 0x000000000f68783bULL, 0x000ee20000004200ULL,
0x0000000115207824ULL, 0x100fe400078e0214ULL, 0x0000000119747824ULL, 0x100fe200078e0214ULL,
0x000000001044783bULL, 0x000f220000004200ULL, 0x0001200012347811ULL, 0x004fe200078e20ffULL,
0x000000011b227824ULL, 0x000fc400078e0214ULL, 0x000000001128783bULL, 0x000fe20000004200ULL,
0x00000001252e7824ULL, 0x000fe400078e0214ULL, 0x0000001020137824ULL, 0x100fe200078e020dULL,
0x000000003434783bULL, 0x002e620000000200ULL, 0x0000001074147824ULL, 0x100fe200078e020dULL,
0x000000171c1c9232ULL, 0x0a0fe20000000000ULL, 0x0000001022157824ULL, 0x100fe200078e020dULL,
0x000000001340783bULL, 0x000ea20000004200ULL, 0x000000102e167824ULL, 0x000fe200078e020dULL,
0x000000171e1e9232ULL, 0x000fc40000000000ULL, 0x00000000143c783bULL, 0x000f620000004200ULL,
0x000000761d1d9232ULL, 0x090fe40000000000ULL, 0x000000761f1f9232ULL, 0x000fe20000000000ULL,
0x000000001538783bULL, 0x000f280000004200ULL, 0x000000001618783bULL, 0x000ea40000004200ULL,
0x000000701c50723cULL, 0x040ff00000001850ULL, 0x000000681c58723cULL, 0x048ff00000001858ULL,
0x000000441c64723cULL, 0x000fe20000001864ULL, 0x0000001734349232ULL, 0x002fc40000000000ULL,
0x0000001736369232ULL, 0x000fe20000000000ULL, 0x000000407e177811ULL, 0x000fe200078e40ffULL,
0x0000007635359232ULL, 0x080fe40000000000ULL, 0x0000007637379232ULL, 0x000fe20000000000ULL,
0x000000721c54723cULL, 0x040ff00000001854ULL, 0x0000006a1c5c723cULL, 0x040ff0000000185cULL,
0x000000461c44723cULL, 0x040ff00000001860ULL, 0x000000281c4c723cULL, 0x040ff0000000184cULL,
0x0000002a1c1c723cULL, 0x000ff00000001830ULL, 0x000000403450723cULL, 0x044ff00000001850ULL,
0x0000003c3458723cULL, 0x060ff00000001858ULL, 0x000000383464723cULL, 0x050ff00000001864ULL,
0x000000423440723cULL, 0x040ff00000001854ULL, 0x0000003e343c723cULL, 0x040ff0000000185cULL,
0x0000003a3438723cULL, 0x040ff00000001844ULL, 0x00000018344c723cULL, 0x040ff0000000184cULL,
0x0000001a3434723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff447819ULL, 0x000fe40000011600ULL,
0x000000402f277811ULL, 0x000fe400078e38ffULL, 0x00000004441c7810ULL, 0x000fe40007ffe0ffULL,
0x000000177c187217ULL, 0x000fe20007800000ULL, 0x0000000144197824ULL, 0x000fe200078e0227ULL,
0x000000001c1a7212ULL, 0x040fe200078e3cffULL, 0x000000081c1b7824ULL, 0x000fe200078e00ffULL,
0x0000000844327810ULL, 0x000fe20007ffe0ffULL, 0x0000000118187824ULL, 0x000fe200078e0a17ULL,
0x0000001924197210ULL, 0x000fc40007f5e0ffULL, 0xfffffff81b467812ULL, 0x000fe200078ee21aULL,
0x000000011c1b7824ULL, 0x100fe200078e0227ULL, 0x0000002018257817ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x00005e0019187a11ULL, 0x040fe200078448ffULL,
0x00000001321d7824ULL, 0x000fe200078e0227ULL, 0x0000000c44567810ULL, 0x000fe20007ffe0ffULL,
0x0000000832547824ULL, 0x000fe200078e00ffULL, 0x00005f0019197a11ULL, 0x000fe200010f4c1aULL,
0x0000001046477824ULL, 0x000fe200078e020dULL, 0x0000001b241b7210ULL, 0x000fc40007f5e0ffULL,
0x0000001d241e7210ULL, 0x000fe20007f9e0ffULL, 0x00000001561d7824ULL, 0x100fe200078e0227ULL,
0x00000010445c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e001b1a7a11ULL, 0x040fe200078448ffULL, 0x000000ffff297224ULL, 0x000fe200020e06ffULL,
0x000000251c00720cULL, 0x000fe20003f66070ULL, 0x000000015c1f7824ULL, 0x000fe200078e0227ULL,
0x00005f001b1b7a11ULL, 0x000fe400010f4c28ULL, 0x0000001d242d7210ULL, 0x000fc40007f5e0ffULL,
0x00005e001e1c7a11ULL, 0x000fe400078848ffULL, 0x00000014445e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff307224ULL, 0x000fe200010e06ffULL, 0x00005f001e1d7a11ULL, 0x000fe400020f4c29ULL,
0x00005e002d1e7a11ULL, 0x000fe200078448ffULL, 0x000000015e2b7824ULL, 0x000fe200078e0227ULL,
0x0000001f24297210ULL, 0x000fe40007f9e0ffULL, 0x0000001844607810ULL, 0x000fc40007ffe0ffULL,
0x00005f002d1f7a11ULL, 0x000fe200010f4c30ULL, 0x000000ffff2a7224ULL, 0x000fe200020e06ffULL,
0x0000002b24307210ULL, 0x000fe20007f5e0ffULL, 0x00000001602b7824ULL, 0x000fe200078e0227ULL,
0x00005e0029287a11ULL, 0x040fe400078848ffULL, 0x0000000032337212ULL, 0x000fe200078e3cffULL,
0x000000ffff317224ULL, 0x000fe200010e06ffULL, 0x00005f0029297a11ULL, 0x000fe400020f4c2aULL,
0x0000002b242d7210ULL, 0x000fc40007fbe0ffULL, 0x00005e00302a7a11ULL, 0x000fe400078448ffULL,
0x0000001c44627810ULL, 0x000fe40007ffe0ffULL, 0x000000253200720cULL, 0x000fe20003f86070ULL,
0x000000ffff327224ULL, 0x000fe200028e06ffULL, 0x00005f00302b7a11ULL, 0x000fe200010f4c31ULL,
0x0000000162277824ULL, 0x000fe200078e0227ULL, 0xfffffff854547812ULL, 0x000fe400078ee233ULL,
0x00005e002d307a11ULL, 0x000fc400078448ffULL, 0x0000000744337812ULL, 0x000fe200078e4800ULL,
0x0000001054497824ULL, 0x000fe200078e020dULL, 0x000000254400720cULL, 0x000fe20003fa6070ULL,
0x000000085e547824ULL, 0x000fe200078e00ffULL, 0x00005f002d317a11ULL, 0x000fe200010f4c32ULL,
0x000000012c2d7824ULL, 0x000fe200078e020bULL, 0x0ffffff833327812ULL, 0x000fe400078ef800ULL,
0x0000002724277210ULL, 0x000fe20007fde0ffULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0x0000000056337212ULL, 0x000fc400078e3cffULL, 0x000000255600720cULL, 0x080fe20003f46070ULL,
0x0000001032457824ULL, 0x000fe400078e020dULL, 0x0000000856567824ULL, 0x000fe400078e00ffULL,
0x000000102d1a7825ULL, 0x000fe200078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018457faeULL, 0x0003e2000e901c46ULL, 0x000000256000720cULL, 0x080fe40003fa6070ULL,
0x000000ffff447224ULL, 0x000fe200030e06ffULL, 0x00005e0027327a11ULL, 0x000fe200078c48ffULL,
0x000000102d1c7825ULL, 0x000fe200078e001cULL, 0xfffffff856467812ULL, 0x000fe200078ee233ULL,
0x000000001a477faeULL, 0x0005e2000d901c46ULL, 0x00005f0027337a11ULL, 0x000fe200030f4c44ULL,
0x000000085c447824ULL, 0x040fe200078e00ffULL, 0x000000255c00720cULL, 0x080fe20003f66070ULL,
0x000000001c497faeULL, 0x0007e2000e101c46ULL, 0x000000255e00720cULL, 0x000fc40003f86070ULL,
0x000000256200720cULL, 0x000fe40003fc6070ULL, 0x000000005c257212ULL, 0x080fe200078e3cffULL,
0x00000008625c7824ULL, 0x000fe200078e00ffULL, 0x000000005e277212ULL, 0x080fe200078e3cffULL,
0x00000008601b7824ULL, 0x044fe200078e00ffULL, 0x0000000060187212ULL, 0x082fe400078e3cffULL,
0x0000000062197212ULL, 0x000fe200078e3cffULL, 0x000000102d1c7825ULL, 0x008fe200078e002aULL,
0xfffffff844447812ULL, 0x000fc400078ee225ULL, 0xfffffff854547812ULL, 0x000fe200078ee227ULL,
0x0000001046257824ULL, 0x000fe200078e020dULL, 0xfffffff81b567812ULL, 0x000fe200078ee218ULL,
0x000000102d1a7825ULL, 0x000fe200078e0028ULL, 0xfffffff85c5c7812ULL, 0x000fc600078ee219ULL,
0x000000102d187825ULL, 0x000fc800078e001eULL, 0x0000001044277824ULL, 0x000fe200078e020dULL,
0x0000000018257faeULL, 0x0003e2000d101c46ULL, 0x000000102d1e7825ULL, 0x000fc600078e0030ULL,
0x000000001a277faeULL, 0x0003e2000d901c46ULL, 0x000000102d287825ULL, 0x000fc800078e0032ULL,
0x00000010542b7824ULL, 0x100fe400078e020dULL, 0x00000010562d7824ULL, 0x100fe400078e020dULL,
0x000000105c317824ULL, 0x000fe200078e020dULL, 0x000000001c2b7faeULL, 0x0003e8000e101c46ULL,
0x000000001e2d7faeULL, 0x0003e8000e901c46ULL, 0x0000000028317faeULL, 0x0003e2000f101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x000fc80000011600ULL,
0x000000041b1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000081b1f7810ULL, 0x000fe40007ffe0ffULL,
0x000000001d187212ULL, 0x0c0fe200078e3cffULL, 0x000000081d197824ULL, 0x000fe200078e00ffULL,
0x000000101b297810ULL, 0x000fe20007ffe0ffULL, 0x000000081f467824ULL, 0x000fe200078e00ffULL,
0x0000000c1b277810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819447812ULL, 0x000fe200078ee218ULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0x000000001f197212ULL, 0x000fe200078e3cffULL,
0x0000000827257824ULL, 0x000fe200078e00ffULL, 0x000000402f187811ULL, 0x000fc400078e38ffULL,
0x00000000291c7212ULL, 0x080fe400078e3cffULL, 0xfffffff846467812ULL, 0x000fe200078ee219ULL,
0x000000011b197824ULL, 0x000fe200078e0218ULL, 0xfffffff82b5c7812ULL, 0x000fe200078ee21cULL,
0x000000011d1d7824ULL, 0x100fe200078e0218ULL, 0x000000141b2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000129297824ULL, 0x100fe200078e0218ULL, 0x00000000271a7212ULL, 0x040fe200078e3cffULL,
0x0000000127277824ULL, 0x100fe200078e0218ULL, 0x000000181b317810ULL, 0x000fe20007ffe0ffULL,
0x000000012b2d7824ULL, 0x000fe200078e0218ULL, 0x0000001c1b337810ULL, 0x000fe20007ffe0ffULL,
0x000000082b477824ULL, 0x000fe200078e00ffULL, 0x0000001924197210ULL, 0x000fc40007f5e0ffULL,
0xfffffff825547812ULL, 0x000fe200078ee21aULL, 0x000000011f257824ULL, 0x100fe200078e0218ULL,
0x000000002b1c7212ULL, 0x080fe200078e3cffULL, 0x00000001312b7824ULL, 0x100fe200078e0218ULL,
0x00000000331f7212ULL, 0x0c0fe200078e3cffULL, 0x0000000133457824ULL, 0x000fe200078e0218ULL,
0x00000000311e7212ULL, 0x000fe200078e3cffULL, 0x0000000833707824ULL, 0x000fe200078e00ffULL,
0x0000002524257210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200010e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078448ffULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0xfffffff870707812ULL, 0x000fe200078ee21fULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005f0019197a11ULL, 0x000fc400010f4c1aULL, 0x0000001d241f7210ULL, 0x000fe20007f5e0ffULL,
0x0000001070497824ULL, 0x000fe200078e020dULL, 0x0000002724277210ULL, 0x000fe40007f9e0ffULL,
0xfffffff847607812ULL, 0x000fe200078ee21cULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x00005e001f1a7a11ULL, 0x000fe200078448ffULL, 0x000000ffff307224ULL, 0x000fe200020e06ffULL,
0xfffffff831687812ULL, 0x000fe400078ee21eULL, 0x000000071b1d7812ULL, 0x000fc400078e4800ULL,
0x00005e00251c7a11ULL, 0x000fe200078648ffULL, 0x0000001068477824ULL, 0x000fe200078e020dULL,
0x00005e00271e7a11ULL, 0x000fe400078848ffULL, 0x00005f001f1b7a11ULL, 0x000fe400010f4c28ULL,
0x0ffffff81d287812ULL, 0x000fe400078ef800ULL, 0x00005f00251d7a11ULL, 0x000fe200018f4c2aULL,
0x000000012c257824ULL, 0x000fe200078e020bULL, 0x00005f00271f7a11ULL, 0x000fe200020f4c30ULL,
0x0000001028277824ULL, 0x000fe200078e020dULL, 0x0000002924297210ULL, 0x040fe20007f9e0ffULL,
0x0000001025187825ULL, 0x000fe200078e0018ULL, 0x0000002d242d7210ULL, 0x000fc40007fbe0ffULL,
0x0000002b24317210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff567224ULL, 0x000fe200020e06ffULL,
0x0000004524457210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200028e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078848ffULL, 0x000000ffff627224ULL, 0x000fe200010e06ffULL,
0x00005e002d2a7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff6a7224ULL, 0x000fe200018e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078448ffULL, 0x00000010251a7825ULL, 0x000fe200078e001aULL,
0x00005e0045327a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018277faeULL, 0x0003e2000b901c46ULL, 0x00005f0029297a11ULL, 0x000fe200020f4c56ULL,
0x00000010251c7825ULL, 0x000fe200078e001cULL, 0x00005f002d2b7a11ULL, 0x000fc400028f4c5eULL,
0x00005f0031317a11ULL, 0x000fe200010f4c62ULL, 0x00000010442d7824ULL, 0x100fe200078e020dULL,
0x00005f0045337a11ULL, 0x000fe200018f4c6aULL, 0x0000001046457824ULL, 0x000fe400078e020dULL,
0x00000010251e7825ULL, 0x040fe200078e001eULL, 0x000000001a2d7faeULL, 0x0005e6000b901c46ULL,
0x0000001025287825ULL, 0x040fe200078e0028ULL, 0x000000001c457faeULL, 0x0005e6000b901c46ULL,
0x00000010252a7825ULL, 0x000fc800078e002aULL, 0x0000001025307825ULL, 0x000fc800078e0030ULL,
0x0000001025327825ULL, 0x000fc800078e0032ULL, 0x0000001054197824ULL, 0x102fe400078e020dULL,
0x000000105c257824ULL, 0x100fe400078e020dULL, 0x0000001060277824ULL, 0x000fe200078e020dULL,
0x000000001e197faeULL, 0x0005e8000b901c46ULL, 0x0000000028257faeULL, 0x0005e8000b901c46ULL,
0x000000002a277faeULL, 0x0005e8000b901c46ULL, 0x0000000030477faeULL, 0x0005e8000b901c46ULL,
0x0000000032497faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000400187811ULL, 0x002fc400078fe0ffULL, 0x00000006001a7811ULL, 0x004fe400078fe0ffULL,
0x0000000718187812ULL, 0x100fe400078e7821ULL, 0x000000071a1c7812ULL, 0x000fe400078e7821ULL,
0x000010000d197810ULL, 0x000fe20007ffe0ffULL, 0x0000000821187824ULL, 0x040fe200078e0218ULL,
0x00000007ff1f723eULL, 0x000fe200000000ffULL, 0x00000008211b7824ULL, 0x000fe200078e021cULL,
0x00000002ff257819ULL, 0x000fe20000011600ULL, 0x000000106e1a7824ULL, 0x100fe200078e0219ULL,
0x0001200018447811ULL, 0x000fe200078e20ffULL, 0x000000106c1c7824ULL, 0x000fe200078e0219ULL,
0x000054101f277816ULL, 0x000fe2000000001fULL, 0x000000104a1d7824ULL, 0x100fe200078e0219ULL,
0x000120001b307811ULL, 0x000fe200078e20ffULL, 0x00000010481e7824ULL, 0x000fc400078e0219ULL,
0x00001f2527257589ULL, 0x000fe200000e0000ULL, 0x00000010201f7824ULL, 0x000fe200078e0219ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001074207824ULL, 0x100fe400078e0219ULL, 0x0000001022217824ULL, 0x100fe200078e0219ULL,
0x000000001a70783bULL, 0x000fe20000004200ULL, 0x000000102e227824ULL, 0x000fc600078e0219ULL,
0x000000001c6c783bULL, 0x000fe80000004200ULL, 0x000000001d68783bULL, 0x000fe80000004200ULL,
0x000000001e48783bULL, 0x000fe80000004200ULL, 0x00001f0827767589ULL, 0x000ea800000e0000ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000001f54783bULL, 0x000f280000004200ULL,
0x00000000205c783bULL, 0x000f680000004200ULL, 0x000000002160783bULL, 0x000f280000004200ULL,
0x000000002228783bULL, 0x000f220000004200ULL, 0x0000002544449232ULL, 0x002fc40000000000ULL,
0x0000002546469232ULL, 0x000fe40000000000ULL, 0x0000007645459232ULL, 0x084fe40000000000ULL,
0x0000007647479232ULL, 0x000fce0000000000ULL, 0x000000704450723cULL, 0x040ff00000001850ULL,
0x0000006c4458723cULL, 0x000fe20000001858ULL, 0x0000002530309232ULL, 0x088fe40000000000ULL,
0x0000002532329232ULL, 0x000fc40000000000ULL, 0x0000007631319232ULL, 0x000fc60000000000ULL,
0x000000684464723cULL, 0x000fe20000001864ULL, 0x0000007633339232ULL, 0x000fce0000000000ULL,
0x000000724440723cULL, 0x040ff00000001840ULL, 0x0000006e443c723cULL, 0x040ff0000000183cULL,
0x0000006a4438723cULL, 0x040ff00000001838ULL, 0x00000048444c723cULL, 0x040ff0000000184cULL,
0x0000004a4434723cULL, 0x000ff00000001834ULL, 0x000000543050723cULL, 0x050ff00000001850ULL,
0x0000005c3058723cULL, 0x060ff00000001858ULL, 0x000000603064723cULL, 0x040ff00000001864ULL,
0x000000563054723cULL, 0x040ff00000001840ULL, 0x0000005e305c723cULL, 0x040ff0000000183cULL,
0x000000623060723cULL, 0x040ff00000001838ULL, 0x00000028304c723cULL, 0x040ff0000000184cULL,
0x0000002a3030723cULL, 0x000fe20000001834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000007c1700720cULL, 0x000fe20003f26070ULL, 0x01c68800ffff7f8cULL, 0x000fd8000c80043fULL,
0x0000776000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000003ff347819ULL, 0x100fe20000011600ULL,
0x000000012c3f7824ULL, 0x000fe200078e020bULL, 0x000000602f257811ULL, 0x000fe400078e38ffULL,
0x0000002017237810ULL, 0x000fe40007ffe0ffULL, 0x0000000434367810ULL, 0x040fe20007ffe0ffULL,
0x0000000134277824ULL, 0x000fe200078e0225ULL, 0x000000237c2a7217ULL, 0x000fe40007800000ULL,
0x00000008343a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000836387824ULL, 0x000fe200078e00ffULL,
0x0000002724277210ULL, 0x000fe20007f3e0ffULL, 0x000000012a2a7824ULL, 0x000fe200078e0a23ULL,
0x0000000036297212ULL, 0x000fe200078e3cffULL, 0x000000083a3e7824ULL, 0x000fe200078e00ffULL,
0x0000000734237812ULL, 0x000fe200078e4800ULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e0027287a11ULL, 0x000fc400078248ffULL, 0xfffffff838387812ULL, 0x000fe400078ee229ULL,
0x00005f0027297a11ULL, 0x000fe200008f4c2eULL, 0x0000000136277824ULL, 0x000fe200078e0225ULL,
0x000000003a2b7212ULL, 0x000fe400078e3cffULL, 0x0000000c343c7810ULL, 0x000fe20007ffe0ffULL,
0x000000103f287825ULL, 0x000fe200078e0028ULL, 0x0ffffff8232e7812ULL, 0x000fe400078ef800ULL,
0x000000202a237817ULL, 0x000fe20003800000ULL, 0x000000083c407824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fc400078ee22bULL, 0x0000001034427810ULL, 0x000fe40007ffe0ffULL,
0x00000027242b7210ULL, 0x000fe20007f5e0ffULL, 0x000000102e277824ULL, 0x000fe200078e0219ULL,
0x000000003c2d7212ULL, 0x080fe200078e3cffULL, 0x0000000842447824ULL, 0x000fe200078e00ffULL,
0x000000233400720cULL, 0x040fe20003f26070ULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x0000001434467810ULL, 0x000fe40007ffe0ffULL, 0xfffffff840407812ULL, 0x000fe200078ee22dULL,
0x000000013a2d7824ULL, 0x100fe200078e0225ULL, 0x0000000042357212ULL, 0x080fe200078e3cffULL,
0x0000000846487824ULL, 0x040fe200078e00ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078448ffULL,
0x0000000146397824ULL, 0x040fe200078e0225ULL, 0x0000000046377212ULL, 0x000fc400078e3cffULL,
0x00000018344a7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028277faeULL, 0x0003e2000c901c46ULL, 0xfffffff844447812ULL, 0x000fe200078ee235ULL,
0x000000013c357824ULL, 0x100fe200078e0225ULL, 0x00005f002b2b7a11ULL, 0x000fe200010f4c2eULL,
0x000000014a3b7824ULL, 0x000fe200078e0225ULL, 0x0000001c346a7810ULL, 0x000fe20007ffe0ffULL,
0x000000084a687824ULL, 0x000fe200078e00ffULL, 0x0000002d242e7210ULL, 0x000fe40007f5e0ffULL,
0xfffffff848487812ULL, 0x000fe200078ee237ULL, 0x0000000142377824ULL, 0x100fe200078e0225ULL,
0x0000003524357210ULL, 0x000fe20007f7e0ffULL, 0x000000016a257824ULL, 0x000fe200078e0225ULL,
0x00005e002e287a11ULL, 0x002fe200078c48ffULL, 0x000000ffff277224ULL, 0x000fe200010e06ffULL,
0x0000003724377210ULL, 0x000fe20007f3e0ffULL, 0x000000086a6c7824ULL, 0x000fe200078e00ffULL,
0x0000003924397210ULL, 0x000fc40007f9e0ffULL, 0x0000003b243b7210ULL, 0x040fe40007fbe0ffULL,
0x00000025242d7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x00005f002e297a11ULL, 0x000fe200030f4c27ULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x00005e0035347a11ULL, 0x000fe400078c48ffULL, 0x000000233600720cULL, 0x000fe40003f66070ULL,
0x000000004a257212ULL, 0x000fc400078e3cffULL, 0x000000006a277212ULL, 0x000fe400078e3cffULL,
0x00005f0035357a11ULL, 0x000fe400030f4c24ULL, 0x00005e0037367a11ULL, 0x000fe400078c48ffULL,
0xfffffff868687812ULL, 0x000fe200078ee225ULL, 0x000000103f247825ULL, 0x000fe200078e002aULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee227ULL, 0x00005f0037377a11ULL, 0x000fe200030f4c2eULL,
0x0000001038277824ULL, 0x000fe200078e0219ULL, 0x00005e0039387a11ULL, 0x000fe200078c48ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x000000233a00720cULL, 0x080fe20003f26070ULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x0000000024277faeULL, 0x0003e2000d901c46ULL,
0x000000233c00720cULL, 0x000fc40003f66070ULL, 0x00005f0039397a11ULL, 0x000fe200030f4c2aULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005e003b3a7a11ULL, 0x000fe400078a48ffULL,
0x00005e002d3c7a11ULL, 0x000fe400078c48ffULL, 0x000000234200720cULL, 0x080fe40003f86070ULL,
0x000000234600720cULL, 0x000fe20003f46070ULL, 0x000000103f247825ULL, 0x002fe200078e0028ULL,
0x00005f003b3b7a11ULL, 0x000fc400028f4c2eULL, 0x000000234a00720cULL, 0x080fe20003fa6070ULL,
0x000000103f287825ULL, 0x000fe200078e0034ULL, 0x00005f002d3d7a11ULL, 0x000fe400030f4c2aULL,
0x000000236a00720cULL, 0x000fe20003fc6070ULL, 0x000000103e237824ULL, 0x000fe400078e0219ULL,
0x000000103f2a7825ULL, 0x000fc600078e0036ULL, 0x0000000024237faeULL, 0x0003e2000c901c46ULL,
0x0000001040277824ULL, 0x000fe400078e0219ULL, 0x000000103f347825ULL, 0x000fc600078e0038ULL,
0x0000000028277faeULL, 0x0003e2000d901c46ULL, 0x000000103f367825ULL, 0x000fc800078e003aULL,
0x00000010442d7824ULL, 0x000fe400078e0219ULL, 0x000000103f387825ULL, 0x000fc600078e003cULL,
0x000000002a2d7faeULL, 0x0003e2000e101c46ULL, 0x00000010483b7824ULL, 0x100fe400078e0219ULL,
0x00000010683d7824ULL, 0x100fe400078e0219ULL, 0x000000106c3f7824ULL, 0x000fe200078e0219ULL,
0x00000000343b7faeULL, 0x0003e8000d101c46ULL, 0x00000000363d7faeULL, 0x0003e8000e901c46ULL,
0x00000000383f7faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff237819ULL, 0x000fe40000011600ULL, 0x000000602f2e7811ULL, 0x000fc400078e38ffULL,
0x0000000423277810ULL, 0x040fe40007ffe0ffULL, 0x00000008232d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000027257212ULL, 0x0c0fe200078e3cffULL, 0x00000008273e7824ULL, 0x000fe200078e00ffULL,
0x0000001423397810ULL, 0x000fe20007ffe0ffULL, 0x0000000127277824ULL, 0x100fe200078e022eULL,
0x000000002d287212ULL, 0x0c0fe200078e3cffULL, 0x000000082d2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c23357810ULL, 0x000fe20007ffe0ffULL, 0x0000000839487824ULL, 0x000fe200078e00ffULL,
0x0000002724277210ULL, 0x000fe20007f5e0ffULL, 0x000000012d2d7824ULL, 0x100fe200078e022eULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee225ULL, 0x0000000123257824ULL, 0x000fe200078e022eULL,
0xfffffff82b407812ULL, 0x000fe200078ee228ULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00000000392b7212ULL, 0x000fe200078e3cffULL, 0x0000000835427824ULL, 0x000fe200078e00ffULL,
0x0000001023377810ULL, 0x000fe20007ffe0ffULL, 0x0000000139397824ULL, 0x000fe200078e022eULL,
0x00005e00272a7a11ULL, 0x000fc400078448ffULL, 0x0000000035297212ULL, 0x000fe200078e3cffULL,
0x0000000837447824ULL, 0x000fe200078e00ffULL, 0x0000002524257210ULL, 0x000fe20007f3e0ffULL,
0x0000000135357824ULL, 0x000fe200078e022eULL, 0xfffffff848487812ULL, 0x000fe400078ee22bULL,
0x00005f00272b7a11ULL, 0x000fe200010f4c36ULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0xfffffff842427812ULL, 0x000fe400078ee229ULL, 0x0000001823277810ULL, 0x000fc40007ffe0ffULL,
0x0000001c233d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000037297212ULL, 0x040fe200078e3cffULL,
0x0000000137377824ULL, 0x100fe200078e022eULL, 0x0000002d242d7210ULL, 0x000fe20007f7e0ffULL,
0x00000001273b7824ULL, 0x100fe200078e022eULL, 0x00005e0025287a11ULL, 0x000fe200078248ffULL,
0x000000013d3f7824ULL, 0x000fe200078e022eULL, 0xfffffff844447812ULL, 0x000fe200078ee229ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005f0025297a11ULL, 0x000fe200008f4c34ULL,
0x0000000827687824ULL, 0x000fe200078e00ffULL, 0x00005e002d347a11ULL, 0x000fe200078c48ffULL,
0x000000083d6c7824ULL, 0x000fe200078e00ffULL, 0x0000003524257210ULL, 0x000fc40007f5e0ffULL,
0x0000000723237812ULL, 0x000fe400078e4800ULL, 0x00005f002d357a11ULL, 0x000fe200030f4c2eULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00000000272d7212ULL, 0x080fe400078e3cffULL,
0x000000003d277212ULL, 0x000fe400078e3cffULL, 0x0ffffff8232e7812ULL, 0x000fe200078ef800ULL,
0x000000012c237824ULL, 0x000fe200078e020bULL, 0x0000003724377210ULL, 0x000fc40007f3e0ffULL,
0x0000003924397210ULL, 0x040fe20007f7e0ffULL, 0x0000001023287825ULL, 0x000fe200078e0028ULL,
0x0000003b243b7210ULL, 0x040fe40007f9e0ffULL, 0x0000003f243f7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005e0025247a11ULL, 0x040fe200078448ffULL,
0x000000ffff4a7224ULL, 0x000fe200020e06ffULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee227ULL,
0x000000102e277824ULL, 0x000fe200078e0219ULL, 0x00005f0025257a11ULL, 0x000fe200010f4c36ULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078248ffULL,
0x000000ffff6a7224ULL, 0x000fe200028e06ffULL, 0x00005e0039387a11ULL, 0x000fe200078448ffULL,
0x00000010232a7825ULL, 0x000fe200078e002aULL, 0x00005e003b3a7a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028277faeULL, 0x0003e2000b901c46ULL,
0x00005e003f3c7a11ULL, 0x000fe200078848ffULL, 0x0000001023347825ULL, 0x000fe200078e0034ULL,
0x00005f0037377a11ULL, 0x000fc400008f4c2eULL, 0x00005f0039397a11ULL, 0x000fe200010f4c46ULL,
0x0000001023247825ULL, 0x000fe200078e0024ULL, 0x00005f003b3b7a11ULL, 0x000fe400018f4c4aULL,
0x00005f003f3d7a11ULL, 0x000fe200020f4c6aULL, 0x00000010403f7824ULL, 0x000fe200078e0219ULL,
0xfffffff868687812ULL, 0x000fe200078ee22dULL, 0x000000103e2d7824ULL, 0x000fe400078e0219ULL,
0x0000001023367825ULL, 0x000fc600078e0036ULL, 0x000000002a2d7faeULL, 0x0005e2000b901c46ULL,
0x0000001023387825ULL, 0x000fc600078e0038ULL, 0x00000000343f7faeULL, 0x0005e2000b901c46ULL,
0x00000010233a7825ULL, 0x000fc800078e003aULL, 0x00000010233c7825ULL, 0x000fc800078e003cULL,
0x0000001042237824ULL, 0x100fe400078e0219ULL, 0x0000001044277824ULL, 0x102fe400078e0219ULL,
0x0000001048297824ULL, 0x100fe200078e0219ULL, 0x0000000024237faeULL, 0x0005e2000b901c46ULL,
0x0000001068417824ULL, 0x100fe400078e0219ULL, 0x000000106c437824ULL, 0x000fe200078e0219ULL,
0x0000000036277faeULL, 0x0005e8000b901c46ULL, 0x0000000038297faeULL, 0x0005e8000b901c46ULL,
0x000000003a417faeULL, 0x0005e8000b901c46ULL, 0x000000003c437faeULL, 0x0005e4000b901c46ULL,
0x00000300ff247624ULL, 0x006fe200078e00ffULL, 0x0000000126237812ULL, 0x000fc800078ec0ffULL,
0x000000012300780cULL, 0x000fe20003f25070ULL, 0xffffffffff237424ULL, 0x000fe200078e00ffULL,
0xffffffff24247811ULL, 0x000fc800078e08ffULL, 0x0000000124247807ULL, 0x000fca0004800000ULL,
0x0000000126267824ULL, 0x000fca00078e0224ULL, 0x0000007b2600720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000002404287210ULL, 0x000fe20007ffe005ULL,
0x00000004ff297424ULL, 0x000fc800078e00ffULL, 0x0000600028287625ULL, 0x000fca00078e0029ULL,
0x0000000628237981ULL, 0x000364000c1e1900ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c628002c287f8cULL, 0x002fe8000c80043fULL,
0x01c62c002c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007824829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff257424ULL, 0x000fc800078e00ffULL,
0x0000002500277305ULL, 0x0002a4000021f000ULL, 0x3fa0000025257823ULL, 0x002fe200000100ffULL,
0x000000270000735dULL, 0x004fe40003800000ULL, 0x01c62c002c277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fc40007824829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c0800006257984ULL, 0x000e680000000800ULL, 0x01c28000062a7984ULL, 0x0004e20000000800ULL,
0x000000022500720bULL, 0x002fe20003f3d000ULL, 0x00012d727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000277806ULL, 0x004fc800008e0100ULL, 0x0000ffff272e7812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff277424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000017d00780cULL, 0x000fe40003f25270ULL,
0x000000022500720bULL, 0x000fe20003f54000ULL, 0x00012d527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000277806ULL, 0x000fe400010e0100ULL, 0x0000002502297209ULL, 0x040fe40007810000ULL,
0x0000ffff27277812ULL, 0x000fe400078e3cffULL, 0x00000002ff367819ULL, 0x000fe20000011600ULL,
0x8000002902287221ULL, 0x000fe20000010000ULL, 0x01c4802906009388ULL, 0x0003e20000000800ULL,
0x000000272eff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x0000002800357308ULL, 0x000ea40000000800ULL, 0x0000003503037220ULL, 0x004fe20000410000ULL,
0x00012d027f007947ULL, 0x000fea000b800000ULL, 0x00001f3635277589ULL, 0x0022a400000e0000ULL,
0x0000002750507220ULL, 0x084fe40000410000ULL, 0x0000002751517220ULL, 0x080fe40000410000ULL,
0x0000002754547220ULL, 0x080fe40000410000ULL, 0x0000002755557220ULL, 0x080fe40000410000ULL,
0x0000002758587220ULL, 0x000fc40000410000ULL, 0x0000002759597220ULL, 0x080fe40000410000ULL,
0x000000275c5c7220ULL, 0x080fe40000410000ULL, 0x000000275d5d7220ULL, 0x080fe40000410000ULL,
0x0000002764647220ULL, 0x080fe40000410000ULL, 0x0000002765657220ULL, 0x080fe40000410000ULL,
0x0000002760607220ULL, 0x000fc40000410000ULL, 0x0000002761617220ULL, 0x080fe40000410000ULL,
0x000000274c4c7220ULL, 0x080fe40000410000ULL, 0x000000274d4d7220ULL, 0x080fe40000410000ULL,
0x0000002730307220ULL, 0x080fe40000410000ULL, 0x0000002731317220ULL, 0x000fe20000410000ULL,
0x00012c427f007947ULL, 0x000fea000b800000ULL, 0x00001f0835277589ULL, 0x00052400000e0000ULL,
0x0000002502027209ULL, 0x000fe20007810000ULL, 0x0000002752527220ULL, 0x090fe20000410000ULL,
0x00000001ff287807ULL, 0x000fe20000800000ULL, 0x0000002753537220ULL, 0x000fc40000410000ULL,
0x8000000225251221ULL, 0x000fe40000010000ULL, 0x0000002756567220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b25251820ULL, 0x000fe40000410000ULL, 0x0000002757577220ULL, 0x080fe40000410000ULL,
0x0000002500071308ULL, 0x000f220000000800ULL, 0x000000275a5a7220ULL, 0x080fe40000410000ULL,
0x000000275b5b7220ULL, 0x000fc40000410000ULL, 0x000000275e5e7220ULL, 0x080fe40000410000ULL,
0x000000275f5f7220ULL, 0x080fe40000410000ULL, 0x0000002766667220ULL, 0x080fe40000410000ULL,
0x0000002767677220ULL, 0x080fe40000410000ULL, 0x0000002762627220ULL, 0x080fe40000410000ULL,
0x0000002763637220ULL, 0x000fc40000410000ULL, 0x000000274e4e7220ULL, 0x080fe40000410000ULL,
0x000000274f4f7220ULL, 0x080fe40000410000ULL, 0x0000002732327220ULL, 0x080fe40000410000ULL,
0x0000002733337220ULL, 0x000fe20000410000ULL, 0x0000761028277816ULL, 0x000fe20000000027ULL,
0x0000002a072a1220ULL, 0x018fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007ff25723eULL, 0x000fe200000000ffULL, 0x000000032a037221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff367819ULL, 0x002fe40000011600ULL,
0x0000541025357816ULL, 0x004fe20000000025ULL, 0x00012ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f3635257589ULL, 0x0002a800000e0000ULL, 0x00001f08352e7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x002fe200078e0009ULL,
0x0000564000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x000136a000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x002fe200078e000aULL,
0x000056a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0001364000007944ULL, 0x02cfea0003c00000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000128000c447811ULL, 0x000fcc00078e20ffULL,
0x000000004444783bULL, 0x000f220000000200ULL, 0x0001280012287811ULL, 0x000fe400078e20ffULL,
0x0000991027277816ULL, 0x000fe200000000ffULL, 0x000000000e70783bULL, 0x000e660000004200ULL,
0x000000ff2700720cULL, 0x000fe20003f25270ULL, 0x000000001068783bULL, 0x000fe80000004200ULL,
0x000000000f6c783bULL, 0x000fe80000004200ULL, 0x000000001148783bULL, 0x000fe80000004200ULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x000000001340783bULL, 0x000ea80000004200ULL,
0x000000001538783bULL, 0x002e680000004200ULL, 0x00000000143c783bULL, 0x000e680000004200ULL,
0x000000001634783bULL, 0x004ea20000004200ULL, 0x0000002544449232ULL, 0x010fc40000000000ULL,
0x0000002546469232ULL, 0x000fe40000000000ULL, 0x0000002e45459232ULL, 0x088fe40000000000ULL,
0x0000002e47479232ULL, 0x000fce0000000000ULL, 0x000000704450723cULL, 0x000fe20000001850ULL,
0x0000002528289232ULL, 0x000fce0000000000ULL, 0x000000724454723cULL, 0x040fe20000001854ULL,
0x000000252a2a9232ULL, 0x000fe20000000000ULL, 0x0000580023257a24ULL, 0x020fe200078e02ffULL,
0x0000002e29299232ULL, 0x080fe40000000000ULL, 0x0000002e2b2b9232ULL, 0x000fe20000000000ULL,
0x0000008025257824ULL, 0x000fe400078e00ffULL, 0x000000684464723cULL, 0x040ff00000001864ULL,
0x0000006c4458723cULL, 0x040ff00000001858ULL, 0x0000006e445c723cULL, 0x040ff0000000185cULL,
0x0000006a4460723cULL, 0x040ff00000001860ULL, 0x00000048444c723cULL, 0x040ff0000000184cULL,
0x0000004a4430723cULL, 0x000ff00000001830ULL, 0x000000402850723cULL, 0x040ff00000001850ULL,
0x000000422854723cULL, 0x040ff00000001854ULL, 0x000000382864723cULL, 0x042ff00000001864ULL,
0x0000003c2858723cULL, 0x040ff00000001858ULL, 0x0000003e285c723cULL, 0x040ff0000000185cULL,
0x0000003a2838723cULL, 0x040ff00000001860ULL, 0x00000034284c723cULL, 0x044ff0000000184cULL,
0x000000362840723cULL, 0x000fe20000001830ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x00000003ff367819ULL, 0x000fe20000011600ULL,
0x000000012c457824ULL, 0x000fe200078e020bULL, 0x0000004017277810ULL, 0x000fe40007ffe0ffULL,
0x0000000836357810ULL, 0x040fe20007ffe0ffULL, 0x000000802f3c7824ULL, 0x000fe200078e0236ULL,
0x0000000436307810ULL, 0x000fe40007ffe0ffULL, 0x000000277c287217ULL, 0x000fe20007800000ULL,
0x00000008352b7824ULL, 0x040fe200078e00ffULL, 0x00000000352a7212ULL, 0x000fe200078e3cffULL,
0x00000008303e7824ULL, 0x000fe200078e00ffULL, 0x0000000c363d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128277824ULL, 0x000fe200078e0a27ULL, 0x0000001036487810ULL, 0x000fc40007ffe0ffULL,
0x0000000030297212ULL, 0x080fe400078e3cffULL, 0xfffffff82b447812ULL, 0x000fe200078ee22aULL,
0x000000083d2b7824ULL, 0x040fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee229ULL,
0x0000000848607824ULL, 0x000fe200078e00ffULL, 0x00000014364b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001044497824ULL, 0x100fe200078e020dULL, 0x0000001836617810ULL, 0x000fe20007ffe0ffULL,
0x000000103e477824ULL, 0x000fe200078e020dULL, 0x000000003d287212ULL, 0x080fe200078e3cffULL,
0x000000084b2d7824ULL, 0x000fe200078e00ffULL, 0x0000000048297212ULL, 0x000fe200078e3cffULL,
0x0000000861687824ULL, 0x000fe200078e00ffULL, 0xfffffff82b467812ULL, 0x000fc400078ee228ULL,
0xfffffff860607812ULL, 0x000fe400078ee229ULL, 0x000000004b2a7212ULL, 0x080fe400078e3cffULL,
0x000000253c297210ULL, 0x000fe40007f5e0ffULL, 0x00000000612b7212ULL, 0x000fe400078e3cffULL,
0x0000001c36637810ULL, 0x000fe40007ffe0ffULL, 0x000000043c2e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82d627812ULL, 0x000fe200078ee22aULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0xfffffff868687812ULL, 0x000fe200078ee22bULL, 0x00000008636a7824ULL, 0x000fe200078e00ffULL,
0x000000252e2b7210ULL, 0x000fe40007f7e0ffULL, 0x00005e0029287a11ULL, 0x000fe400078448ffULL,
0x00000000632d7212ULL, 0x000fe200078e3cffULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x000000083c327810ULL, 0x000fc40007ffe0ffULL, 0x00005f0029297a11ULL, 0x000fe400010f4c2aULL,
0xfffffff86a6a7812ULL, 0x000fe400078ee22dULL, 0x00005e002b2a7a11ULL, 0x000fe200078448ffULL,
0x0000001045287825ULL, 0x000fe200078e0028ULL, 0x0000000c3c347810ULL, 0x000fe40007ffe0ffULL,
0x00000025322d7210ULL, 0x000fe40007f9e0ffULL, 0x0000002027277817ULL, 0x000fc40003800000ULL,
0x00005f002b2b7a11ULL, 0x000fe400010f4c2eULL, 0x00000025342e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x000000273000720cULL, 0x000fe20003f66070ULL,
0x00000010452a7825ULL, 0x000fe200078e002aULL, 0x00005e002d307a11ULL, 0x040fe400078448ffULL,
0x000000103c4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff337224ULL, 0x000fe200028e06ffULL,
0x00005f002d317a11ULL, 0x000fc400010f4c34ULL, 0x00005e002e327a11ULL, 0x000fe400078848ffULL,
0x000000254a2d7210ULL, 0x000fe20007f5e0ffULL, 0x0000001045307825ULL, 0x000fe200078e0030ULL,
0x00005f002e337a11ULL, 0x000fe400020f4c33ULL, 0x00005e002d347a11ULL, 0x000fe200078c48ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x000000273600720cULL, 0x040fe40003f86070ULL,
0x0000000736377812ULL, 0x000fc400078e4800ULL, 0x000000143c367810ULL, 0x000fe40007ffe0ffULL,
0x000000273500720cULL, 0x000fe40003fa6070ULL, 0x00005f002d357a11ULL, 0x000fe400030f4c2eULL,
0x0ffffff8372e7812ULL, 0x000fe400078ef800ULL, 0x00000025362d7210ULL, 0x000fe40007fde0ffULL,
0x000000183c4a7810ULL, 0x000fe20007ffe0ffULL, 0x000000102e3f7824ULL, 0x000fe200078e020dULL,
0x0000001c3c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x00005e002d367a11ULL, 0x000fc400078c48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000283f7faeULL, 0x0003e2000e101c46ULL, 0x000000273d00720cULL, 0x000fe40003f46070ULL,
0x00005f002d377a11ULL, 0x000fe200030f4c2eULL, 0x000000002a477faeULL, 0x0005e2000d901c46ULL,
0x000000254a2e7210ULL, 0x080fe40007f9e0ffULL, 0x000000253c2d7210ULL, 0x000fe20007f7e0ffULL,
0x0000000030497faeULL, 0x0007e2000e901c46ULL, 0x00005e002e3c7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff3d7224ULL, 0x000fe200020e06ffULL, 0x000000274800720cULL, 0x080fe20003f86070ULL,
0x0000001045287825ULL, 0x002fe200078e0032ULL, 0x000000276100720cULL, 0x000fc40003fa6070ULL,
0x00005f002e3d7a11ULL, 0x000fe200030f4c3dULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005e002d3e7a11ULL, 0x000fe200078648ffULL, 0x00000010452a7825ULL, 0x004fe200078e0034ULL,
0x000000274b00720cULL, 0x080fe40003fc6070ULL, 0x00005f002d3f7a11ULL, 0x000fe200018f4c2eULL,
0x00000010602d7824ULL, 0x100fe200078e020dULL, 0x000000276300720cULL, 0x000fe20003f66070ULL,
0x0000001046277824ULL, 0x000fe400078e020dULL, 0x0000001045327825ULL, 0x000fc600078e0036ULL,
0x0000000028277faeULL, 0x0003e2000d101c46ULL, 0x0000001045347825ULL, 0x000fc600078e003cULL,
0x000000002a2d7faeULL, 0x0003e2000e101c46ULL, 0x0000001062317824ULL, 0x008fe400078e020dULL,
0x0000001045367825ULL, 0x000fc600078e003eULL, 0x0000000032317faeULL, 0x0003e2000f101c46ULL,
0x00000010683d7824ULL, 0x100fe400078e020dULL, 0x000000106a3f7824ULL, 0x000fc600078e020dULL,
0x00000000343d7faeULL, 0x0003e8000e901c46ULL, 0x00000000363f7faeULL, 0x0003e2000d901c46ULL,
0x0000063000007947ULL, 0x000fea0003800000ULL, 0x00000003ff277819ULL, 0x000fc80000011600ULL,
0x0000000427297810ULL, 0x000fe20007ffe0ffULL, 0x000000802f2e7824ULL, 0x000fe200078e0227ULL,
0x00000008272b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c272d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000829337824ULL, 0x000fe200078e00ffULL, 0x0000001027317810ULL, 0x000fe20007ffe0ffULL,
0x000000082b467824ULL, 0x000fe200078e00ffULL, 0x0000000029287212ULL, 0x080fe400078e3cffULL,
0x000000002d2a7212ULL, 0x0c0fe200078e3cffULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000000002b297212ULL, 0x080fe200078e3cffULL, 0x00000008314a7824ULL, 0x040fe200078e00ffULL,
0x00000000312b7212ULL, 0x000fc400078e3cffULL, 0xfffffff846467812ULL, 0x000fe400078ee229ULL,
0xfffffff82d487812ULL, 0x000fe400078ee22aULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee22bULL,
0x0000001046477824ULL, 0x000fe200078e020dULL, 0x0000001427297810ULL, 0x040fe40007ffe0ffULL,
0x00000018272b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c272d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff833447812ULL, 0x000fe200078ee228ULL, 0x000000082b317824ULL, 0x000fe200078e00ffULL,
0x0000000029287212ULL, 0x0c0fe200078e3cffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000000002b2a7212ULL, 0x080fe200078e3cffULL, 0x000000082d6e7824ULL, 0x040fe200078e00ffULL,
0x000000002d2b7212ULL, 0x000fe200078e3cffULL, 0x0000001044457824ULL, 0x000fe200078e020dULL,
0x000000042e307810ULL, 0x040fe40007ffe0ffULL, 0x000000082e327810ULL, 0x000fc40007ffe0ffULL,
0x0000000c2e347810ULL, 0x040fe40007ffe0ffULL, 0xfffffff829627812ULL, 0x000fe400078ee228ULL,
0x000000252e297210ULL, 0x080fe40007f5e0ffULL, 0xfffffff8316a7812ULL, 0x000fe400078ee22aULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x00000025302b7210ULL, 0x080fe20007f7e0ffULL, 0x000000106a497824ULL, 0x100fe200078e020dULL,
0x0000002532317210ULL, 0x080fe20007f9e0ffULL, 0x000000106e4b7824ULL, 0x000fe200078e020dULL,
0x0000002534337210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078448ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0x00005e0031307a11ULL, 0x000fe200078648ffULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x00005e0033327a11ULL, 0x000fc400078848ffULL, 0x00005f0029297a11ULL, 0x000fe400010f4c2aULL,
0x00005e002b2a7a11ULL, 0x000fe400078448ffULL, 0x00005f0031317a11ULL, 0x000fe400018f4c36ULL,
0x00005f0033337a11ULL, 0x000fe400020f4c3cULL, 0x00000007272d7812ULL, 0x000fe200078e4800ULL,
0x000000012c277824ULL, 0x000fe200078e020bULL, 0x000000102e367810ULL, 0x000fc40007ffe0ffULL,
0x000000142e3c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001027287825ULL, 0x040fe200078e0028ULL,
0x000000182e3e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001c2e607810ULL, 0x000fe20007ffe0ffULL,
0x0000001027307825ULL, 0x000fe200078e0030ULL, 0x00005f002b2b7a11ULL, 0x000fe400010f4c34ULL,
0x0ffffff82d347812ULL, 0x000fe200078ef800ULL, 0x0000001027327825ULL, 0x000fe200078e0032ULL,
0x00000025362e7210ULL, 0x000fc40007f9e0ffULL, 0x000000253c377210ULL, 0x080fe20007fbe0ffULL,
0x00000010342d7824ULL, 0x000fe200078e020dULL, 0x000000253e3d7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff357224ULL, 0x000fe200020e06ffULL, 0x00000025603f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff607224ULL, 0x000fe200028e06ffULL, 0x00005e002e347a11ULL, 0x040fe200078848ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078a48ffULL,
0x000000ffff6c7224ULL, 0x000fe200018e06ffULL, 0x00005e003d3c7a11ULL, 0x000fe200078448ffULL,
0x00000010272a7825ULL, 0x000fe200078e002aULL, 0x00005e003f3e7a11ULL, 0x000fe200078648ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000282d7faeULL, 0x0003e2000b901c46ULL,
0x00005f002e357a11ULL, 0x000fc400020f4c35ULL, 0x00005f0037377a11ULL, 0x000fe200028f4c60ULL,
0x000000002a457faeULL, 0x0005e2000b901c46ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c68ULL,
0x0000001027347825ULL, 0x000fe200078e0034ULL, 0x00005f003f3f7a11ULL, 0x000fe200018f4c6cULL,
0x0000000030477faeULL, 0x0005e4000b901c46ULL, 0x0000001027367825ULL, 0x000fc800078e0036ULL,
0x00000010273c7825ULL, 0x000fc800078e003cULL, 0x00000010273e7825ULL, 0x000fc800078e003eULL,
0x0000001048277824ULL, 0x100fe400078e020dULL, 0x000000104a297824ULL, 0x102fe400078e020dULL,
0x00000010622d7824ULL, 0x000fe200078e020dULL, 0x0000000032277faeULL, 0x0005e8000b901c46ULL,
0x0000000034297faeULL, 0x0005e8000b901c46ULL, 0x00000000362d7faeULL, 0x0005e8000b901c46ULL,
0x000000003c497faeULL, 0x0005e8000b901c46ULL, 0x000000003e4b7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0001280018447811ULL, 0x000fc400078e20ffULL,
0x00000007ff28723eULL, 0x002fe400000000ffULL, 0x00000002ff277819ULL, 0x004fe40000011600ULL,
0x00005410282d7816ULL, 0x000fe40000000028ULL, 0x000128001b307811ULL, 0x000fc600078e20ffULL,
0x00001f272d277589ULL, 0x000fe800000e0000ULL, 0x00001f082d2e7589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000004444783bULL, 0x000e680000000200ULL,
0x000000001d68783bULL, 0x000ea80000004200ULL, 0x000000001a70783bULL, 0x000fe80000004200ULL,
0x000000001c6c783bULL, 0x000fe80000004200ULL, 0x000000001e48783bULL, 0x000fe80000004200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002160783bULL, 0x000f280000004200ULL,
0x000000001f3c783bULL, 0x000f680000004200ULL, 0x000000002034783bULL, 0x000f280000004200ULL,
0x000000002228783bULL, 0x000f220000004200ULL, 0x0000002744449232ULL, 0x002fc40000000000ULL,
0x0000002746469232ULL, 0x000fe40000000000ULL, 0x0000002e45459232ULL, 0x080fe40000000000ULL,
0x0000002e47479232ULL, 0x000fce0000000000ULL, 0x000000684464723cULL, 0x004fe20000001864ULL,
0x0000002730309232ULL, 0x008fce0000000000ULL, 0x000000704450723cULL, 0x000fe20000001850ULL,
0x0000002732329232ULL, 0x000fe40000000000ULL, 0x0000002e31319232ULL, 0x080fe40000000000ULL,
0x0000002e33339232ULL, 0x000fc60000000000ULL, 0x000000724454723cULL, 0x040ff00000001854ULL,
0x0000006c4458723cULL, 0x040ff00000001858ULL, 0x0000006e445c723cULL, 0x040ff0000000185cULL,
0x0000006a4438723cULL, 0x040ff00000001838ULL, 0x00000048444c723cULL, 0x040ff0000000184cULL,
0x0000004a4440723cULL, 0x000ff00000001840ULL, 0x000000603064723cULL, 0x050ff00000001864ULL,
0x0000003c3050723cULL, 0x060ff00000001850ULL, 0x0000003e3054723cULL, 0x040ff00000001854ULL,
0x000000343058723cULL, 0x040ff00000001858ULL, 0x00000036305c723cULL, 0x040ff0000000185cULL,
0x000000623060723cULL, 0x040ff00000001838ULL, 0x00000028304c723cULL, 0x040ff0000000184cULL,
0x0000002a3030723cULL, 0x000fe20000001840ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x0000004017277810ULL, 0x000fe20007ffe0ffULL, 0x01c69000ffff7f8cULL, 0x000fe6000c80043fULL,
0x0000007c2700720cULL, 0x000fda0003f26070ULL, 0x00004f5000001947ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x000fe20000011600ULL, 0x000000012c417824ULL, 0x000fe200078e020bULL,
0x0000006017277810ULL, 0x000fe40007ffe0ffULL, 0x00000008392d7810ULL, 0x040fe40007ffe0ffULL,
0x000000277c287217ULL, 0x000fe40007800000ULL, 0x00000004392b7810ULL, 0x000fe20007ffe0ffULL,
0x000000082d357824ULL, 0x000fe200078e00ffULL, 0x0000000c393d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128277824ULL, 0x000fe200078e0a27ULL, 0x000000002d287212ULL, 0x080fe200078e3cffULL,
0x000000082b3e7824ULL, 0x000fe200078e00ffULL, 0x00000010393f7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d427824ULL, 0x000fe200078e00ffULL, 0x000000002b297212ULL, 0x000fc400078e3cffULL,
0xfffffff835407812ULL, 0x000fe200078ee228ULL, 0x000000083f357824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee229ULL, 0x0000001439477810ULL, 0x000fe40007ffe0ffULL,
0x000000003d297212ULL, 0x080fe200078e3cffULL, 0x000000103e457824ULL, 0x000fe200078e0219ULL,
0x000000003f287212ULL, 0x000fe200078e3cffULL, 0x0000000847487824ULL, 0x000fe200078e00ffULL,
0x000000202f3c7811ULL, 0x000fc400078e38ffULL, 0xfffffff842427812ULL, 0x000fe400078ee229ULL,
0xfffffff835447812ULL, 0x000fe200078ee228ULL, 0x0000000139287824ULL, 0x140fe200078e023cULL,
0x0000001839497810ULL, 0x000fe20007ffe0ffULL, 0x000000013d387824ULL, 0x100fe200078e023cULL,
0x0000000047297212ULL, 0x080fe200078e3cffULL, 0x000000013f3a7824ULL, 0x100fe200078e023cULL,
0x00000000492a7212ULL, 0x040fe200078e3cffULL, 0x0000000849357824ULL, 0x000fe200078e00ffULL,
0xfffffff848487812ULL, 0x000fe200078ee229ULL, 0x0000000147467824ULL, 0x000fe200078e023cULL,
0x0000002528297210ULL, 0x000fc40007f3e0ffULL, 0x0000001c394b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8354a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e0029287a11ULL, 0x000fe200078248ffULL, 0x000000084b377824ULL, 0x040fe200078e00ffULL,
0x000000004b2e7212ULL, 0x000fe400078e3cffULL, 0x00005f0029297a11ULL, 0x000fe200008f4c2aULL,
0x000000012d2a7824ULL, 0x000fe200078e023cULL, 0x0000002027277817ULL, 0x000fc40003800000ULL,
0xfffffff837687812ULL, 0x000fe200078ee22eULL, 0x000000012b2e7824ULL, 0x000fe200078e023cULL,
0x000000272d00720cULL, 0x000fe20003f26070ULL, 0x0000001041287825ULL, 0x000fe200078e0028ULL,
0x000000252a2d7210ULL, 0x000fe40007f7e0ffULL, 0x000000272b00720cULL, 0x000fe40003fa6070ULL,
0x000000252e2b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005e002d347a11ULL, 0x000fc400078648ffULL, 0x0000002538377210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005f002d357a11ULL, 0x000fe400018f4c2eULL,
0x000000253a2d7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005e002b2a7a11ULL, 0x000fe400078448ffULL, 0x00005e002d387a11ULL, 0x000fe200078848ffULL,
0x000000ffff2e7224ULL, 0x000fe200030e06ffULL, 0x00005f002b2b7a11ULL, 0x000fc400010f4c36ULL,
0x00005e0037367a11ULL, 0x000fe400078648ffULL, 0x00000007393b7812ULL, 0x000fe200078e4800ULL,
0x00000010412a7825ULL, 0x000fe200078e002aULL, 0x000000273900720cULL, 0x000fe40003f46070ULL,
0x00005f002d397a11ULL, 0x000fe400020f4c2eULL, 0x00005f0037377a11ULL, 0x000fe400018f4c3aULL,
0x0ffffff83b2e7812ULL, 0x000fc400078ef800ULL, 0x00000025462d7210ULL, 0x000fe20007f7e0ffULL,
0x0000000149467824ULL, 0x100fe200078e023cULL, 0x000000273d00720cULL, 0x000fe20003f86070ULL,
0x000000102e437824ULL, 0x000fe400078e0219ULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x00005e002d3a7a11ULL, 0x000fe200078648ffULL, 0x000000014b3c7824ULL, 0x000fe200078e023cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028437faeULL, 0x0003e4000d101c46ULL,
0x00005f002d3b7a11ULL, 0x000fc400018f4c2eULL, 0x00000025462e7210ULL, 0x080fe20007f7e0ffULL,
0x000000002a457faeULL, 0x0005e2000e901c46ULL, 0x000000253c2d7210ULL, 0x000fe40007f5e0ffULL,
0x00005e002e3c7a11ULL, 0x040fe200078c48ffULL, 0x000000ffff3d7224ULL, 0x000fe200018e06ffULL,
0x000000273f00720cULL, 0x080fe40003f66070ULL, 0x000000274900720cULL, 0x000fe20003fa6070ULL,
0x0000001041287825ULL, 0x002fe200078e0034ULL, 0x00005f002e3d7a11ULL, 0x000fc400030f4c3dULL,
0x000000274700720cULL, 0x000fe20003fc6070ULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e002d3e7a11ULL, 0x000fe200078448ffULL, 0x0000001041347825ULL, 0x000fc600078e0036ULL,
0x00005f002d3f7a11ULL, 0x000fe200010f4c2eULL, 0x0000001041367825ULL, 0x000fe200078e0038ULL,
0x000000274b00720cULL, 0x000fc60003f46070ULL, 0x0000001040277824ULL, 0x000fe400078e0219ULL,
0x0000001041387825ULL, 0x000fc600078e003aULL, 0x0000000028277faeULL, 0x0003e2000c901c46ULL,
0x00000010413a7825ULL, 0x000fc800078e003cULL, 0x00000010422d7824ULL, 0x000fe400078e0219ULL,
0x00000010412a7825ULL, 0x004fc600078e003eULL, 0x00000000342d7faeULL, 0x0003e2000e101c46ULL,
0x00000010443d7824ULL, 0x100fe400078e0219ULL, 0x00000010483f7824ULL, 0x100fe400078e0219ULL,
0x000000104a417824ULL, 0x100fe200078e0219ULL, 0x00000000363d7faeULL, 0x0003e2000d901c46ULL,
0x0000001068437824ULL, 0x000fc600078e0219ULL, 0x00000000383f7faeULL, 0x0003e8000f101c46ULL,
0x000000003a417faeULL, 0x0003e8000e901c46ULL, 0x000000002a437faeULL, 0x0003e2000d101c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff277819ULL, 0x000fc80000011600ULL,
0x0000000427297810ULL, 0x040fe40007ffe0ffULL, 0x00000008272b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000029287212ULL, 0x0c0fe200078e3cffULL, 0x0000000829357824ULL, 0x000fe200078e00ffULL,
0x0000000c272d7810ULL, 0x000fe20007ffe0ffULL, 0x000000082b377824ULL, 0x040fe200078e00ffULL,
0x000000002b2a7212ULL, 0x000fe400078e3cffULL, 0xfffffff835407812ULL, 0x000fe200078ee228ULL,
0x000000082d397824ULL, 0x000fe200078e00ffULL, 0x0000001027357810ULL, 0x000fc40007ffe0ffULL,
0x000000202f287811ULL, 0x000fe200078e38ffULL, 0x0000001040417824ULL, 0x100fe200078e0219ULL,
0xfffffff837427812ULL, 0x000fe200078ee22aULL, 0x00000008353b7824ULL, 0x000fe200078e00ffULL,
0x000000002d2e7212ULL, 0x080fe200078e3cffULL, 0x00000001272a7824ULL, 0x100fe200078e0228ULL,
0x0000000035347212ULL, 0x080fe200078e3cffULL, 0x000000012d367824ULL, 0x000fe200078e0228ULL,
0xfffffff839447812ULL, 0x000fe200078ee22eULL, 0x00000001292e7824ULL, 0x000fe200078e0228ULL,
0xfffffff83b467812ULL, 0x000fe200078ee234ULL, 0x000000012b347824ULL, 0x100fe200078e0228ULL,
0x0000001427377810ULL, 0x000fe20007ffe0ffULL, 0x00000001353c7824ULL, 0x100fe200078e0228ULL,
0x0000001827397810ULL, 0x040fe20007ffe0ffULL, 0x0000001042437824ULL, 0x000fe200078e0219ULL,
0x0000001c273b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001373e7824ULL, 0x100fe200078e0228ULL,
0x000000252a2a7210ULL, 0x080fe20007f3e0ffULL, 0x0000000139487824ULL, 0x100fe200078e0228ULL,
0x00000000372b7212ULL, 0x080fe200078e3cffULL, 0x000000013b687824ULL, 0x000fe200078e0228ULL,
0x00000000392d7212ULL, 0x000fe200078e3cffULL, 0x000000ffff297224ULL, 0x000fe200008e06ffULL,
0x00005e002a287a11ULL, 0x000fe200078248ffULL, 0x00000008374a7824ULL, 0x000fe200078e00ffULL,
0x0000002536377210ULL, 0x080fe20007f7e0ffULL, 0x00000008396a7824ULL, 0x000fe200078e00ffULL,
0x00005f002a297a11ULL, 0x000fe200008f4c29ULL, 0x000000083b6e7824ULL, 0x000fe200078e00ffULL,
0x000000252e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200018e06ffULL,
0xfffffff84a4a7812ULL, 0x000fc400078ee22bULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2b7224ULL, 0x000fe200008e06ffULL, 0x00000025342d7210ULL, 0x000fe40007f5e0ffULL,
0x00005e002e2a7a11ULL, 0x000fe200078248ffULL, 0x000000106a457824ULL, 0x000fe200078e0219ULL,
0x0000000727277812ULL, 0x000fe200078e4800ULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x000000003b357212ULL, 0x000fe400078e3cffULL, 0x00005f002e2b7a11ULL, 0x000fc400008f4c2bULL,
0x00005e002d347a11ULL, 0x000fe400078448ffULL, 0x0ffffff8272e7812ULL, 0x000fe200078ef800ULL,
0x000000012c277824ULL, 0x000fe200078e020bULL, 0x00005e0037367a11ULL, 0x000fe400078648ffULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee235ULL, 0x0000001027287825ULL, 0x000fe200078e0028ULL,
0x00005f002d357a11ULL, 0x000fe400010f4c38ULL, 0x00005f0037377a11ULL, 0x000fe200018f4c3aULL,
0x000000102e2d7824ULL, 0x000fe200078e0219ULL, 0x000000253c2e7210ULL, 0x080fe20007f5e0ffULL,
0x00000010272a7825ULL, 0x000fe200078e002aULL, 0x000000253e3b7210ULL, 0x000fc40007f7e0ffULL,
0x00000025483d7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff397224ULL, 0x000fe200010e06ffULL,
0x00000025683f7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff487224ULL, 0x000fe200018e06ffULL,
0x00005e002e387a11ULL, 0x040fe200078448ffULL, 0x000000ffff687224ULL, 0x000fe200020e06ffULL,
0x00005e003b3a7a11ULL, 0x000fe200078648ffULL, 0x000000ffff6c7224ULL, 0x000fe200008e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078848ffULL, 0x0000001027347825ULL, 0x000fe200078e0034ULL,
0x00005e003f3e7a11ULL, 0x000fe200078248ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002e397a11ULL, 0x000fe200010f4c39ULL,
0x0000001027367825ULL, 0x000fe200078e0036ULL, 0x00005f003b3b7a11ULL, 0x000fe200018f4c48ULL,
0x000000002a417faeULL, 0x0005e2000b901c46ULL, 0x00005f003d3d7a11ULL, 0x000fe200020f4c68ULL,
0x0000001027387825ULL, 0x000fe200078e0038ULL, 0x00005f003f3f7a11ULL, 0x000fe200008f4c6cULL,
0x0000000034437faeULL, 0x0005e4000b901c46ULL, 0x00000010273a7825ULL, 0x000fc800078e003aULL,
0x00000010273c7825ULL, 0x000fc800078e003cULL, 0x00000010273e7825ULL, 0x000fc800078e003eULL,
0x0000001044277824ULL, 0x100fe400078e0219ULL, 0x0000001046297824ULL, 0x102fe400078e0219ULL,
0x000000104a2d7824ULL, 0x100fe200078e0219ULL, 0x0000000036277faeULL, 0x0005e2000b901c46ULL,
0x000000106e477824ULL, 0x000fc600078e0219ULL, 0x0000000038297faeULL, 0x0005e8000b901c46ULL,
0x000000003a2d7faeULL, 0x0005e8000b901c46ULL, 0x000000003c457faeULL, 0x0005e8000b901c46ULL,
0x000000003e477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c648002c287f8cULL, 0x006fe8000c80043fULL,
0x01c64c002c277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fc40007824829ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff277424ULL, 0x000fc800078e00ffULL,
0x00000027002a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000027277823ULL, 0x002fe200000100ffULL,
0x0000002a0000735dULL, 0x004fe20003800000ULL, 0x01c64c002c2b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007824829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c1000006277984ULL, 0x000e680000000800ULL, 0x01c30000062a7984ULL, 0x0004e20000000800ULL,
0x000000022700720bULL, 0x002fe20003f3d000ULL, 0x000108827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x004fc800008e0100ULL, 0x0000ffff282e7812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff2b7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000027d00780cULL, 0x000fe40003f25270ULL,
0x000000022700720bULL, 0x000fe20003f54000ULL, 0x000108627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000287806ULL, 0x000fe400010e0100ULL, 0x0000002702297209ULL, 0x000fe40007810000ULL,
0x0000ffff282d7812ULL, 0x000fe400078e3cffULL, 0x00000002ff367819ULL, 0x000fe20000011600ULL,
0x80000029022b7221ULL, 0x000fe20000010000ULL, 0x01c5002906009388ULL, 0x0003e20000000800ULL,
0x0000002d2eff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b2b2b7820ULL, 0x000fc80000410000ULL,
0x0000002b00357308ULL, 0x000ea40000000800ULL, 0x0000003503037220ULL, 0x004fe20000410000ULL,
0x000108127f007947ULL, 0x000fea000b800000ULL, 0x00001f3635287589ULL, 0x0022a400000e0000ULL,
0x0000002850507220ULL, 0x084fe40000410000ULL, 0x0000002851517220ULL, 0x080fe40000410000ULL,
0x0000002854547220ULL, 0x080fe40000410000ULL, 0x0000002855557220ULL, 0x080fe40000410000ULL,
0x0000002858587220ULL, 0x000fc40000410000ULL, 0x0000002859597220ULL, 0x080fe40000410000ULL,
0x000000285c5c7220ULL, 0x080fe40000410000ULL, 0x000000285d5d7220ULL, 0x080fe40000410000ULL,
0x0000002864647220ULL, 0x080fe40000410000ULL, 0x0000002865657220ULL, 0x080fe40000410000ULL,
0x0000002860607220ULL, 0x000fc40000410000ULL, 0x0000002861617220ULL, 0x080fe40000410000ULL,
0x000000284c4c7220ULL, 0x080fe40000410000ULL, 0x000000284d4d7220ULL, 0x080fe40000410000ULL,
0x0000002830307220ULL, 0x080fe40000410000ULL, 0x0000002831317220ULL, 0x000fe20000410000ULL,
0x000107527f007947ULL, 0x000fea000b800000ULL, 0x00001f0835287589ULL, 0x00052400000e0000ULL,
0x0000002702027209ULL, 0x000fe20007810000ULL, 0x0000002852527220ULL, 0x090fe20000410000ULL,
0x00000001ff2b7807ULL, 0x000fe20000800000ULL, 0x0000002853537220ULL, 0x000fc40000410000ULL,
0x8000000227271221ULL, 0x000fe40000010000ULL, 0x0000002856567220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b27271820ULL, 0x000fe40000410000ULL, 0x0000002857577220ULL, 0x080fe40000410000ULL,
0x0000002700071308ULL, 0x000f220000000800ULL, 0x000000285a5a7220ULL, 0x080fe40000410000ULL,
0x000000285b5b7220ULL, 0x000fc40000410000ULL, 0x000000285e5e7220ULL, 0x080fe40000410000ULL,
0x000000285f5f7220ULL, 0x080fe40000410000ULL, 0x0000002866667220ULL, 0x080fe40000410000ULL,
0x0000002867677220ULL, 0x080fe40000410000ULL, 0x0000002862627220ULL, 0x080fe40000410000ULL,
0x0000002863637220ULL, 0x000fc40000410000ULL, 0x000000284e4e7220ULL, 0x080fe40000410000ULL,
0x000000284f4f7220ULL, 0x080fe40000410000ULL, 0x0000002832327220ULL, 0x080fe40000410000ULL,
0x0000002833337220ULL, 0x000fe40000410000ULL, 0x0000002a072a1220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007ff27723eULL, 0x000fe200000000ffULL,
0x000000032a037221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff367819ULL, 0x002fe40000011600ULL, 0x0000541027357816ULL, 0x004fe20000000027ULL,
0x000105e27f007947ULL, 0x000fea000b800000ULL, 0x00001f3635277589ULL, 0x0002a800000e0000ULL,
0x00001f08352e7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x002fe200078e0009ULL, 0x00007d7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x00010f7000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff367224ULL, 0x002fe200078e000aULL, 0x00007dd000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x00010f1000007944ULL, 0x00cfea0003c00000ULL, 0x000130000c447811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000e70783bULL, 0x000fe20000004200ULL,
0x0001300012287811ULL, 0x000fe400078e20ffULL, 0x000099102b2d7816ULL, 0x000fe200000000ffULL,
0x000000004444783bULL, 0x000f260000000200ULL, 0x000000ff2d00720cULL, 0x000fe20003f25270ULL,
0x000000001068783bULL, 0x000fe80000004200ULL, 0x000000000f6c783bULL, 0x000fe80000004200ULL,
0x000000001148783bULL, 0x000fe80000004200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000001340783bULL, 0x000e680000004200ULL, 0x000000001538783bULL, 0x002e680000004200ULL,
0x00000000143c783bULL, 0x000ee80000004200ULL, 0x000000001634783bULL, 0x004ea20000004200ULL,
0x0000002744449232ULL, 0x010fc40000000000ULL, 0x0000002746469232ULL, 0x000fe40000000000ULL,
0x0000002e45459232ULL, 0x088fe40000000000ULL, 0x0000002e47479232ULL, 0x000fce0000000000ULL,
0x000000704450723cULL, 0x000fe20000001850ULL, 0x0000002728289232ULL, 0x0a0fe40000000000ULL,
0x000000272a2a9232ULL, 0x000fe40000000000ULL, 0x0000002e29299232ULL, 0x000fc60000000000ULL,
0x000000724454723cULL, 0x000fe20000001854ULL, 0x0000002e2b2b9232ULL, 0x000fce0000000000ULL,
0x000000684464723cULL, 0x040ff00000001864ULL, 0x0000006c4458723cULL, 0x040ff00000001858ULL,
0x0000006e445c723cULL, 0x040ff0000000185cULL, 0x0000006a4460723cULL, 0x040ff00000001860ULL,
0x00000048444c723cULL, 0x040ff0000000184cULL, 0x0000004a4430723cULL, 0x000ff00000001830ULL,
0x000000402850723cULL, 0x040ff00000001850ULL, 0x000000422854723cULL, 0x040ff00000001854ULL,
0x000000382864723cULL, 0x042ff00000001864ULL, 0x0000003c2858723cULL, 0x040ff00000001858ULL,
0x0000003e285c723cULL, 0x040ff0000000185cULL, 0x0000003a2838723cULL, 0x040ff00000001860ULL,
0x00000034284c723cULL, 0x044ff0000000184cULL, 0x000000362840723cULL, 0x000fe20000001830ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000071000008947ULL, 0x000fea0003800000ULL,
0x00000003ff357819ULL, 0x000fe20000011600ULL, 0x000000012c457824ULL, 0x000fe200078e020bULL,
0x0000008017277810ULL, 0x000fe40007ffe0ffULL, 0x0000000835377810ULL, 0x040fe40007ffe0ffULL,
0x0000000435317810ULL, 0x000fe40007ffe0ffULL, 0x000000277c287217ULL, 0x000fe20007800000ULL,
0x00000008372b7824ULL, 0x040fe200078e00ffULL, 0x00000000372a7212ULL, 0x000fe200078e3cffULL,
0x0000000831367824ULL, 0x000fe200078e00ffULL, 0x0000000c353d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128277824ULL, 0x000fe200078e0a27ULL, 0xfffffff82b3e7812ULL, 0x000fc400078ee22aULL,
0x00000010354b7810ULL, 0x000fe20007ffe0ffULL, 0x000000083d2b7824ULL, 0x000fe200078e00ffULL,
0x0000000031297212ULL, 0x080fe200078e3cffULL, 0x000000103e497824ULL, 0x000fe200078e020dULL,
0x000000402f3c7811ULL, 0x000fe200078e38ffULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x000000003d287212ULL, 0x080fe400078e3cffULL, 0xfffffff836367812ULL, 0x000fe200078ee229ULL,
0x00000001312e7824ULL, 0x100fe200078e023cULL, 0x0000001435617810ULL, 0x000fe20007ffe0ffULL,
0x0000000137307824ULL, 0x000fe200078e023cULL, 0xfffffff82b447812ULL, 0x000fe200078ee228ULL,
0x0000000135287824ULL, 0x140fe200078e023cULL, 0x0000001835637810ULL, 0x000fe20007ffe0ffULL,
0x00000008612d7824ULL, 0x000fe200078e00ffULL, 0x000000004b297212ULL, 0x080fe200078e3cffULL,
0x000000013d327824ULL, 0x100fe200078e023cULL, 0x00000000612a7212ULL, 0x000fe200078e3cffULL,
0x0000000863607824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee229ULL,
0x000000014b467824ULL, 0x000fe200078e023cULL, 0x0000001c35697810ULL, 0x000fe20007ffe0ffULL,
0x0000001036477824ULL, 0x000fe200078e020dULL, 0x0000002528297210ULL, 0x000fc40007f5e0ffULL,
0x00000000632b7212ULL, 0x080fe200078e3cffULL, 0x0000000869627824ULL, 0x000fe200078e00ffULL,
0xfffffff82d4a7812ULL, 0x000fe200078ee22aULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0xfffffff860607812ULL, 0x000fe400078ee22bULL, 0x000000252e2b7210ULL, 0x000fe40007f7e0ffULL,
0x00000000692d7212ULL, 0x000fe400078e3cffULL, 0x00005e0029287a11ULL, 0x000fe200078448ffULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0xfffffff862627812ULL, 0x000fc400078ee22dULL,
0x00005f0029297a11ULL, 0x000fe400010f4c2aULL, 0x00005e002b2a7a11ULL, 0x000fe400078448ffULL,
0x00000025302d7210ULL, 0x080fe20007f9e0ffULL, 0x0000001045287825ULL, 0x000fe200078e0028ULL,
0x00005f002b2b7a11ULL, 0x000fe400010f4c2eULL, 0x0000002027277817ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200020e06ffULL, 0x00000025322e7210ULL, 0x000fe20007fbe0ffULL,
0x00000010452a7825ULL, 0x000fe200078e002aULL, 0x00005e002d307a11ULL, 0x000fc400078448ffULL,
0x000000273100720cULL, 0x000fe20003f66070ULL, 0x000000ffff337224ULL, 0x000fe200028e06ffULL,
0x00005f002d317a11ULL, 0x000fe400010f4c34ULL, 0x00005e002e327a11ULL, 0x000fe400078848ffULL,
0x00000025462d7210ULL, 0x000fe20007f5e0ffULL, 0x0000000161467824ULL, 0x000fe200078e023cULL,
0x00005f002e337a11ULL, 0x000fe200020f4c33ULL, 0x0000001045307825ULL, 0x000fe200078e0030ULL,
0x000000273700720cULL, 0x000fc40003fa6070ULL, 0x00005e002d347a11ULL, 0x000fe200078c48ffULL,
0x000000ffff2e7224ULL, 0x000fe200010e06ffULL, 0x0000000735377812ULL, 0x040fe400078e4800ULL,
0x000000273500720cULL, 0x000fe40003f86070ULL, 0x00005f002d357a11ULL, 0x000fe400030f4c2eULL,
0x0ffffff8372e7812ULL, 0x000fe400078ef800ULL, 0x00000025462d7210ULL, 0x000fe20007fde0ffULL,
0x0000000163467824ULL, 0x000fe200078e023cULL, 0x000000273d00720cULL, 0x000fe20003f46070ULL,
0x000000102e3f7824ULL, 0x000fc400078e020dULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x00005e002d367a11ULL, 0x000fe200078c48ffULL, 0x00000001693c7824ULL, 0x000fe200078e023cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000283f7faeULL, 0x0003e4000e101c46ULL,
0x00005f002d377a11ULL, 0x000fe400030f4c2eULL, 0x00000025462e7210ULL, 0x080fe20007f9e0ffULL,
0x000000002a477faeULL, 0x0005e2000d901c46ULL, 0x000000253c2d7210ULL, 0x000fe40007f7e0ffULL,
0x00005e002e3c7a11ULL, 0x040fe200078c48ffULL, 0x000000ffff3d7224ULL, 0x000fe200020e06ffULL,
0x000000274b00720cULL, 0x080fe20003f86070ULL, 0x0000000030497faeULL, 0x0007e2000e901c46ULL,
0x000000276300720cULL, 0x000fe20003fa6070ULL, 0x0000001045287825ULL, 0x002fe200078e0032ULL,
0x00005f002e3d7a11ULL, 0x000fc400030f4c3dULL, 0x000000276100720cULL, 0x000fe20003fc6070ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e002d3e7a11ULL, 0x000fe200078648ffULL,
0x00000010452a7825ULL, 0x004fc600078e0034ULL, 0x00005f002d3f7a11ULL, 0x000fe200018f4c2eULL,
0x00000010482d7824ULL, 0x100fe200078e020dULL, 0x000000276900720cULL, 0x000fe20003f66070ULL,
0x0000001044277824ULL, 0x000fe400078e020dULL, 0x0000001045327825ULL, 0x000fc600078e0036ULL,
0x0000000028277faeULL, 0x0003e2000d101c46ULL, 0x0000001045347825ULL, 0x000fc600078e003cULL,
0x000000002a2d7faeULL, 0x0003e2000e101c46ULL, 0x000000104a317824ULL, 0x008fe400078e020dULL,
0x0000001045367825ULL, 0x000fc600078e003eULL, 0x0000000032317faeULL, 0x0003e2000f101c46ULL,
0x00000010603d7824ULL, 0x100fe400078e020dULL, 0x00000010623f7824ULL, 0x000fc600078e020dULL,
0x00000000343d7faeULL, 0x0003e8000e901c46ULL, 0x00000000363f7faeULL, 0x0003e2000d901c46ULL,
0x0000064000007947ULL, 0x000fea0003800000ULL, 0x00000003ff277819ULL, 0x000fc80000011600ULL,
0x0000000427297810ULL, 0x040fe40007ffe0ffULL, 0x00000008272b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000029287212ULL, 0x0c0fe200078e3cffULL, 0x0000000829317824ULL, 0x000fe200078e00ffULL,
0x0000000c272d7810ULL, 0x000fe20007ffe0ffULL, 0x000000082b337824ULL, 0x040fe200078e00ffULL,
0x000000002b2a7212ULL, 0x000fe400078e3cffULL, 0xfffffff831447812ULL, 0x000fe200078ee228ULL,
0x000000082d357824ULL, 0x000fe200078e00ffULL, 0x0000001027317810ULL, 0x000fc40007ffe0ffULL,
0x000000402f287811ULL, 0x000fe200078e38ffULL, 0x0000001044457824ULL, 0x100fe200078e020dULL,
0xfffffff833467812ULL, 0x000fe200078ee22aULL, 0x0000000831377824ULL, 0x000fe200078e00ffULL,
0x000000002d2e7212ULL, 0x080fe200078e3cffULL, 0x00000001272a7824ULL, 0x100fe200078e0228ULL,
0x0000000031307212ULL, 0x080fe200078e3cffULL, 0x000000012d327824ULL, 0x000fe200078e0228ULL,
0xfffffff835487812ULL, 0x000fe200078ee22eULL, 0x00000001292e7824ULL, 0x000fe200078e0228ULL,
0xfffffff8374a7812ULL, 0x000fe200078ee230ULL, 0x000000012b307824ULL, 0x100fe200078e0228ULL,
0x0000001427337810ULL, 0x000fe20007ffe0ffULL, 0x00000001313c7824ULL, 0x100fe200078e0228ULL,
0x0000001827357810ULL, 0x040fe20007ffe0ffULL, 0x0000001046477824ULL, 0x000fe200078e020dULL,
0x0000001c27377810ULL, 0x000fe20007ffe0ffULL, 0x00000001333e7824ULL, 0x100fe200078e0228ULL,
0x000000252a2a7210ULL, 0x080fe20007f5e0ffULL, 0x0000000135607824ULL, 0x100fe200078e0228ULL,
0x00000000332b7212ULL, 0x080fe200078e3cffULL, 0x0000000137687824ULL, 0x000fe200078e0228ULL,
0x00000000352d7212ULL, 0x000fe200078e3cffULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00005e002a287a11ULL, 0x000fe200078448ffULL, 0x0000000833627824ULL, 0x000fe200078e00ffULL,
0x0000002532337210ULL, 0x080fe20007f9e0ffULL, 0x00000008356a7824ULL, 0x000fe200078e00ffULL,
0x00005f002a297a11ULL, 0x000fe200010f4c29ULL, 0x00000008376e7824ULL, 0x000fe200078e00ffULL,
0x000000252e2e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff367224ULL, 0x000fe200020e06ffULL,
0xfffffff862627812ULL, 0x000fc400078ee22bULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee22dULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00000025302d7210ULL, 0x000fe40007f7e0ffULL,
0x00005e002e2a7a11ULL, 0x000fe200078448ffULL, 0x000000106a497824ULL, 0x000fe200078e020dULL,
0x0000000727277812ULL, 0x000fe200078e4800ULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x0000000037317212ULL, 0x000fe400078e3cffULL, 0x00005f002e2b7a11ULL, 0x000fc400010f4c2bULL,
0x00005e002d307a11ULL, 0x000fe400078648ffULL, 0x0ffffff8272e7812ULL, 0x000fe200078ef800ULL,
0x000000012c277824ULL, 0x000fe200078e020bULL, 0x00005e0033327a11ULL, 0x000fe400078848ffULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee231ULL, 0x0000001027287825ULL, 0x000fe200078e0028ULL,
0x00005f002d317a11ULL, 0x000fe400018f4c34ULL, 0x00005f0033337a11ULL, 0x000fe200020f4c36ULL,
0x000000102e2d7824ULL, 0x000fe200078e020dULL, 0x000000253c2e7210ULL, 0x080fe20007f9e0ffULL,
0x00000010272a7825ULL, 0x000fe200078e002aULL, 0x000000253e377210ULL, 0x000fc40007fbe0ffULL,
0x00000025603d7210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff357224ULL, 0x000fe200020e06ffULL,
0x00000025683f7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff607224ULL, 0x000fe200028e06ffULL,
0x00005e002e347a11ULL, 0x040fe200078848ffULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x00005e0037367a11ULL, 0x000fe200078a48ffULL, 0x000000ffff6c7224ULL, 0x000fe200018e06ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078448ffULL, 0x0000001027307825ULL, 0x000fe200078e0030ULL,
0x00005e003f3e7a11ULL, 0x000fe200078648ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000282d7faeULL, 0x0003e2000b901c46ULL, 0x00005f002e357a11ULL, 0x000fe200020f4c35ULL,
0x0000001027327825ULL, 0x000fe200078e0032ULL, 0x00005f0037377a11ULL, 0x000fe200028f4c60ULL,
0x000000002a457faeULL, 0x0005e2000b901c46ULL, 0x00005f003d3d7a11ULL, 0x000fe200010f4c68ULL,
0x0000001027347825ULL, 0x000fe200078e0034ULL, 0x00005f003f3f7a11ULL, 0x000fe200018f4c6cULL,
0x0000000030477faeULL, 0x0005e4000b901c46ULL, 0x0000001027367825ULL, 0x000fc800078e0036ULL,
0x00000010273c7825ULL, 0x000fc800078e003cULL, 0x00000010273e7825ULL, 0x000fc800078e003eULL,
0x0000001048277824ULL, 0x100fe400078e020dULL, 0x000000104a297824ULL, 0x102fe400078e020dULL,
0x00000010622d7824ULL, 0x100fe200078e020dULL, 0x0000000032277faeULL, 0x0005e2000b901c46ULL,
0x000000106e4b7824ULL, 0x000fc600078e020dULL, 0x0000000034297faeULL, 0x0005e8000b901c46ULL,
0x00000000362d7faeULL, 0x0005e8000b901c46ULL, 0x000000003c497faeULL, 0x0005e8000b901c46ULL,
0x000000003e4b7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0001300018447811ULL, 0x000fc400078e20ffULL, 0x00000007ff28723eULL, 0x002fe400000000ffULL,
0x00000002ff277819ULL, 0x004fe40000011600ULL, 0x00005410282d7816ULL, 0x000fe40000000028ULL,
0x000130001b307811ULL, 0x000fc600078e20ffULL, 0x00001f272d277589ULL, 0x000fe800000e0000ULL,
0x00001f082d2e7589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000004444783bULL, 0x000e680000000200ULL, 0x000000001d68783bULL, 0x000ea80000004200ULL,
0x000000001a70783bULL, 0x000fe80000004200ULL, 0x000000001c6c783bULL, 0x000fe80000004200ULL,
0x000000001e48783bULL, 0x000fe80000004200ULL, 0x000000003030783bULL, 0x000ee80000000200ULL,
0x000000002160783bULL, 0x000f280000004200ULL, 0x000000001f3c783bULL, 0x000f680000004200ULL,
0x000000002034783bULL, 0x000f280000004200ULL, 0x000000002228783bULL, 0x000f220000004200ULL,
0x0000002744449232ULL, 0x002fc40000000000ULL, 0x0000002746469232ULL, 0x000fe40000000000ULL,
0x0000002e45459232ULL, 0x080fe40000000000ULL, 0x0000002e47479232ULL, 0x000fce0000000000ULL,
0x000000684464723cULL, 0x004fe20000001864ULL, 0x0000002730309232ULL, 0x008fce0000000000ULL,
0x000000704450723cULL, 0x000fe20000001850ULL, 0x0000002732329232ULL, 0x000fe40000000000ULL,
0x0000002e31319232ULL, 0x080fe40000000000ULL, 0x0000002e33339232ULL, 0x000fc60000000000ULL,
0x000000724454723cULL, 0x040ff00000001854ULL, 0x0000006c4458723cULL, 0x040ff00000001858ULL,
0x0000006e445c723cULL, 0x040ff0000000185cULL, 0x0000006a4438723cULL, 0x040ff00000001838ULL,
0x00000048444c723cULL, 0x040ff0000000184cULL, 0x0000004a4440723cULL, 0x000ff00000001840ULL,
0x000000603064723cULL, 0x050ff00000001864ULL, 0x0000003c3050723cULL, 0x060ff00000001850ULL,
0x0000003e3054723cULL, 0x040ff00000001854ULL, 0x000000343058723cULL, 0x040ff00000001858ULL,
0x00000036305c723cULL, 0x040ff0000000185cULL, 0x000000623060723cULL, 0x040ff00000001838ULL,
0x00000028304c723cULL, 0x040ff0000000184cULL, 0x0000002a3030723cULL, 0x000fe20000001840ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000008017277810ULL, 0x000fe20007ffe0ffULL,
0x01c69800ffff7f8cULL, 0x000fe6000c80043fULL, 0x0000007c2700720cULL, 0x000fda0003f26070ULL,
0x0000282000001947ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x000000a017177810ULL, 0x000fe40007ffe0ffULL,
0x00000003ff377819ULL, 0x000fe40000011600ULL, 0x000000177c267217ULL, 0x000fe40007800000ULL,
0x00000008373d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c37437810ULL, 0x000fe20007ffe0ffULL,
0x0000000126177824ULL, 0x000fe200078e0a17ULL, 0x000000602f347811ULL, 0x000fe200078e38ffULL,
0x000000083d297824ULL, 0x040fe200078e00ffULL, 0x000000003d267212ULL, 0x000fe200078e3cffULL,
0x0000000843447824ULL, 0x000fe200078e00ffULL, 0x00000004373b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff829427812ULL, 0x000fe200078ee226ULL, 0x0000000137267824ULL, 0x100fe200078e0234ULL,
0x0000000043277212ULL, 0x080fe200078e3cffULL, 0x000000083b407824ULL, 0x040fe200078e00ffULL,
0x000000003b237212ULL, 0x040fe400078e3cffULL, 0xfffffff844447812ULL, 0x000fe400078ee227ULL,
0x0000002526277210ULL, 0x000fe20007f1e0ffULL, 0x000000013b267824ULL, 0x000fe200078e0234ULL,
0x0000001037457810ULL, 0x000fc40007ffe0ffULL, 0xfffffff840407812ULL, 0x000fe200078ee223ULL,
0x000000ffff2e7224ULL, 0x000fe200000e06ffULL, 0x0000002526237210ULL, 0x000fe20007f3e0ffULL,
0x0000000845467824ULL, 0x040fe200078e00ffULL, 0x0000000045297212ULL, 0x0c0fe200078e3cffULL,
0x0000000145367824ULL, 0x100fe200078e0234ULL, 0x0000001437477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0027287a11ULL, 0x000fe400078048ffULL,
0x00005e0023267a11ULL, 0x000fe200078248ffULL, 0x0000000847487824ULL, 0x040fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe200078ee229ULL, 0x0000000147387824ULL, 0x000fe200078e0234ULL,
0x00005f0027297a11ULL, 0x000fe200000f4c2eULL, 0x00000001432e7824ULL, 0x000fe200078e0234ULL,
0x00005f0023277a11ULL, 0x000fe200008f4c2aULL, 0x000000013d2a7824ULL, 0x000fe200078e0234ULL,
0x00000000472b7212ULL, 0x000fc400078e3cffULL, 0x0000001837497810ULL, 0x040fe40007ffe0ffULL,
0xfffffff848487812ULL, 0x000fe400078ee22bULL, 0x0000001c374b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001493a7824ULL, 0x140fe200078e0234ULL, 0x000000252a2b7210ULL, 0x080fe20007f1e0ffULL,
0x00000008494a7824ULL, 0x000fe200078e00ffULL, 0x000000252e357210ULL, 0x080fe20007f7e0ffULL,
0x000000014b3c7824ULL, 0x000fe200078e0234ULL, 0x0000000049397212ULL, 0x000fe200078e3cffULL,
0x000000ffff347224ULL, 0x000fe200000e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078048ffULL,
0x000000084b3f7824ULL, 0x000fe200078e00ffULL, 0x00000025362e7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00005f002b2b7a11ULL, 0x000fc400000f4c34ULL,
0x0000002017177817ULL, 0x000fe40003800000ULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee239ULL,
0x00005e0035347a11ULL, 0x000fe400078c48ffULL, 0x0000000737397812ULL, 0x000fe400078e4800ULL,
0x000000004b3e7212ULL, 0x000fe400078e3cffULL, 0x000000173700720cULL, 0x000fe20003f66070ULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00000025382d7210ULL, 0x000fc40007f9e0ffULL,
0x00005f0035357a11ULL, 0x000fe400030f4c36ULL, 0x0ffffff839387812ULL, 0x000fe400078ef800ULL,
0x00005e002e367a11ULL, 0x000fe400078c48ffULL, 0xfffffff83f687812ULL, 0x000fe200078ee23eULL,
0x000000012c3f7824ULL, 0x000fe200078e020bULL, 0x00005f002e377a11ULL, 0x000fe200030f4c37ULL,
0x0000001038417824ULL, 0x000fe200078e0219ULL, 0x000000253a237210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff2e7224ULL, 0x000fe200020e06ffULL, 0x000000253c257210ULL, 0x000fe20007f5e0ffULL,
0x000000103f287825ULL, 0x000fe200078e0028ULL, 0x00005e002d387a11ULL, 0x000fc400078c48ffULL,
0x000000173b00720cULL, 0x080fe20003f06070ULL, 0x000000ffff3e7224ULL, 0x000fe200028e06ffULL,
0x00005f002d397a11ULL, 0x000fe200030f4c2eULL, 0x000000ffff2e7224ULL, 0x000fe200010e06ffULL,
0x00005e00233a7a11ULL, 0x000fe200078a48ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028417faeULL, 0x0003e2000d901c46ULL, 0x000000173d00720cULL, 0x080fe20003f26070ULL,
0x000000103f267825ULL, 0x000fe200078e0026ULL, 0x00005e00253c7a11ULL, 0x000fe400078c48ffULL,
0x000000174300720cULL, 0x080fe20003f66070ULL, 0x00000010462d7824ULL, 0x100fe200078e0219ULL,
0x000000174500720cULL, 0x080fe20003f86070ULL, 0x000000104a437824ULL, 0x000fe200078e0219ULL,
0x000000174700720cULL, 0x000fc40003f46070ULL, 0x00005f00233b7a11ULL, 0x000fe200028f4c3eULL,
0x0000001042237824ULL, 0x000fe200078e0219ULL, 0x000000174900720cULL, 0x080fe20003fa6070ULL,
0x000000103f287825ULL, 0x002fe200078e002aULL, 0x00005f00253d7a11ULL, 0x000fe400030f4c2eULL,
0x000000174b00720cULL, 0x000fe20003fc6070ULL, 0x0000001040177824ULL, 0x100fe400078e0219ULL,
0x0000001044257824ULL, 0x000fe400078e0219ULL, 0x000000103f2a7825ULL, 0x040fe200078e0034ULL,
0x0000000026177faeULL, 0x0003e6000c101c46ULL, 0x000000103f347825ULL, 0x040fe200078e0036ULL,
0x0000000028237faeULL, 0x0003e6000c901c46ULL, 0x0000001048417824ULL, 0x000fe200078e0219ULL,
0x000000002a257faeULL, 0x0003e2000d901c46ULL, 0x000000103f367825ULL, 0x000fc600078e0038ULL,
0x00000000342d7faeULL, 0x0003e2000e101c46ULL, 0x000000103f387825ULL, 0x000fc600078e003aULL,
0x0000000036417faeULL, 0x0003e2000d101c46ULL, 0x0000001068197824ULL, 0x000fe400078e0219ULL,
0x000000103f3a7825ULL, 0x000fe200078e003cULL, 0x0000000038437faeULL, 0x0003e8000e901c46ULL,
0x000000003a197faeULL, 0x0003e2000f101c46ULL, 0x0000064000007947ULL, 0x000fea0003800000ULL,
0x00000003ff177819ULL, 0x000fe40000011600ULL, 0x000000602f287811ULL, 0x000fc400078e38ffULL,
0x0000000417297810ULL, 0x040fe40007ffe0ffULL, 0x00000008172b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000117267824ULL, 0x100fe200078e0228ULL, 0x0000000029237212ULL, 0x0c0fe200078e3cffULL,
0x0000000829347824ULL, 0x000fe200078e00ffULL, 0x0000000c172d7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b367824ULL, 0x000fe200078e00ffULL, 0x0000001017357810ULL, 0x000fe40007ffe0ffULL,
0xfffffff834347812ULL, 0x000fe200078ee223ULL, 0x000000082d3a7824ULL, 0x000fe200078e00ffULL,
0x000000002b277212ULL, 0x000fe200078e3cffULL, 0x0000000835397824ULL, 0x000fe200078e00ffULL,
0x0000001417377810ULL, 0x000fe20007ffe0ffULL, 0x00000001353c7824ULL, 0x000fe200078e0228ULL,
0x0000002526237210ULL, 0x000fc40007f1e0ffULL, 0xfffffff836367812ULL, 0x000fe200078ee227ULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x000000002d277212ULL, 0x080fe200078e3cffULL,
0x000000ffff2a7224ULL, 0x000fe200000e06ffULL, 0x00000000352e7212ULL, 0x080fe200078e3cffULL,
0x0000000137407824ULL, 0x040fe200078e0228ULL, 0x0000000037387212ULL, 0x000fe400078e3cffULL,
0x00005e0023267a11ULL, 0x000fe400078048ffULL, 0xfffffff83a3a7812ULL, 0x000fc400078ee227ULL,
0xfffffff8393e7812ULL, 0x000fe200078ee22eULL, 0x000000012b2e7824ULL, 0x000fe200078e0228ULL,
0xfffffff83b427812ULL, 0x000fe200078ee238ULL, 0x000000012d387824ULL, 0x000fe200078e0228ULL,
0x00005f0023277a11ULL, 0x000fe200000f4c2aULL, 0x00000001292a7824ULL, 0x100fe200078e0228ULL,
0x0000001817397810ULL, 0x040fe20007ffe0ffULL, 0x00000010362d7824ULL, 0x100fe200078e0219ULL,
0x0000001c173b7810ULL, 0x000fe20007ffe0ffULL, 0x000000103a3f7824ULL, 0x100fe200078e0219ULL,
0x000000252a237210ULL, 0x080fe20007fde0ffULL, 0x0000000139447824ULL, 0x000fe200078e0228ULL,
0x0000000717177812ULL, 0x000fe200078e4800ULL, 0x000000013b287824ULL, 0x040fe200078e0228ULL,
0x000000252e2b7210ULL, 0x080fe20007fbe0ffULL, 0x000000083b467824ULL, 0x040fe200078e00ffULL,
0x000000003b297212ULL, 0x000fe200078e3cffULL, 0x000000ffff2e7224ULL, 0x000fe200030e06ffULL,
0x00000025283d7210ULL, 0x080fe20007f5e0ffULL, 0x000000103e417824ULL, 0x100fe200078e0219ULL,
0x000000253c377210ULL, 0x080fe20007f7e0ffULL, 0x00000008393c7824ULL, 0x000fe200078e00ffULL,
0x00005e0023287a11ULL, 0x000fe200078c48ffULL, 0x0000001042437824ULL, 0x000fe200078e0219ULL,
0x0ffffff8172a7812ULL, 0x000fe200078ef800ULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x0000002538387210ULL, 0x000fc40007f9e0ffULL, 0x0000002540407210ULL, 0x080fe40007f1e0ffULL,
0x0000002544447210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x0000000039257212ULL, 0x000fe400078e3cffULL, 0xfffffff846467812ULL, 0x000fe200078ee229ULL,
0x000000ffff3b7224ULL, 0x000fe200008e06ffULL, 0x00005f0023297a11ULL, 0x000fe200030f4c2eULL,
0x000000102a237824ULL, 0x000fe200078e0219ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee225ULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00005e002b2a7a11ULL, 0x040fe200078a48ffULL,
0x0000001034257824ULL, 0x100fe200078e0219ULL, 0x00005e0038347a11ULL, 0x000fe200078848ffULL,
0x000000103c457824ULL, 0x100fe200078e0219ULL, 0x00005f002b2b7a11ULL, 0x000fe200028f4c2eULL,
0x0000001046477824ULL, 0x000fe200078e0219ULL, 0x00005f0038357a11ULL, 0x000fe200020f4c17ULL,
0x000000ffff2e7224ULL, 0x000fe200018e06ffULL, 0x00005e0037367a11ULL, 0x000fe200078648ffULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e0040387a11ULL, 0x000fe200078048ffULL,
0x000000012c177824ULL, 0x000fe200078e020bULL, 0x00005e00443a7a11ULL, 0x000fc400078248ffULL,
0x00005e003d3c7a11ULL, 0x000fe200078448ffULL, 0x0000001017267825ULL, 0x000fe200078e0026ULL,
0x00005f0037377a11ULL, 0x000fe400018f4c2eULL, 0x00005f0040397a11ULL, 0x000fe200000f4c19ULL,
0x0000001017287825ULL, 0x000fe200078e0028ULL, 0x00005f00443b7a11ULL, 0x000fe200008f4c3bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026237faeULL, 0x0003e2000b901c46ULL,
0x00005f003d3d7a11ULL, 0x000fe200010f4c3eULL, 0x00000010172a7825ULL, 0x040fe400078e002aULL,
0x0000000028257faeULL, 0x0003e4000b901c46ULL, 0x0000001017347825ULL, 0x000fc400078e0034ULL,
0x000000002a2d7faeULL, 0x0003e4000b901c46ULL, 0x0000001017367825ULL, 0x040fe400078e0036ULL,
0x00000000343f7faeULL, 0x0003e4000b901c46ULL, 0x0000001017387825ULL, 0x040fe400078e0038ULL,
0x0000000036417faeULL, 0x0003e4000b901c46ULL, 0x00000010173a7825ULL, 0x000fc400078e003aULL,
0x0000000038437faeULL, 0x0003e4000b901c46ULL, 0x00000010173c7825ULL, 0x000fe400078e003cULL,
0x000000003a457faeULL, 0x0003e8000b901c46ULL, 0x000000003c477faeULL, 0x0003e4000b901c46ULL,
0x0000000105177824ULL, 0x002fe400078e0224ULL, 0x00000300ff057624ULL, 0x000fc400078e00ffULL,
0xffffffffff237424ULL, 0x000fe200078e00ffULL, 0x0000000117197812ULL, 0x000fe400078ec0ffULL,
0xffffffff05057811ULL, 0x000fe400078e08ffULL, 0x000000011900780cULL, 0x000fc80003f05070ULL,
0x0000000105267807ULL, 0x000fca0004000000ULL, 0x0000000117267824ULL, 0x000fca00078e0226ULL,
0x0000007b2600720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000126247824ULL, 0x000fe400078e0204ULL, 0x00000004ff257424ULL, 0x000fc800078e00ffULL,
0x0000600024247625ULL, 0x000fca00078e0025ULL, 0x0000000624237981ULL, 0x000364000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c668002c247f8cULL, 0x002fe8000c80043fULL, 0x01c66c002c057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804825ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff057424ULL, 0x000fc800078e00ffULL, 0x0000000500177305ULL, 0x0002a4000021f000ULL,
0x3fa0000005057823ULL, 0x002fe200000100ffULL, 0x000000170000735dULL, 0x004fe40003800000ULL,
0x01c66c002c177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fc40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c1800006057984ULL, 0x000e680000000800ULL,
0x01c3800006247984ULL, 0x0004e20000000800ULL, 0x000000020500720bULL, 0x002fe20003f1d000ULL,
0x0000e2c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x004fc800000e0100ULL,
0x0000ffff17197812ULL, 0x000fe2000780c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff177424ULL, 0x000fd600078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000037d00780cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f34000ULL,
0x0000e2a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x000fe400008e0100ULL,
0x0000000502257209ULL, 0x040fe40007810000ULL, 0x0000ffff17287812ULL, 0x000fe400078e3cffULL,
0x00000002ff367819ULL, 0x000fe20000011600ULL, 0x8000002502027221ULL, 0x000fe20000010000ULL,
0x01c5802506008388ULL, 0x0003e20000000800ULL, 0x0000002819ff7212ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x0000000200357308ULL, 0x000ea40000000800ULL,
0x0000003503037220ULL, 0x004fe20000410000ULL, 0x0000e2527f007947ULL, 0x000fea000b800000ULL,
0x00001f3635027589ULL, 0x0022a400000e0000ULL, 0x0000000250507220ULL, 0x084fe40000410000ULL,
0x0000000251517220ULL, 0x080fe40000410000ULL, 0x0000000254547220ULL, 0x080fe40000410000ULL,
0x0000000255557220ULL, 0x080fe40000410000ULL, 0x0000000258587220ULL, 0x000fc40000410000ULL,
0x0000000259597220ULL, 0x080fe40000410000ULL, 0x000000025c5c7220ULL, 0x080fe40000410000ULL,
0x000000025d5d7220ULL, 0x080fe40000410000ULL, 0x0000000264647220ULL, 0x080fe40000410000ULL,
0x0000000265657220ULL, 0x080fe40000410000ULL, 0x0000000260607220ULL, 0x000fc40000410000ULL,
0x0000000261617220ULL, 0x080fe40000410000ULL, 0x000000024c4c7220ULL, 0x080fe40000410000ULL,
0x000000024d4d7220ULL, 0x080fe40000410000ULL, 0x0000000230307220ULL, 0x080fe40000410000ULL,
0x0000000231317220ULL, 0x000fe20000410000ULL, 0x0000e1927f007947ULL, 0x000fea000b800000ULL,
0x00001f0835027589ULL, 0x00052400000e0000ULL, 0x8000002505050221ULL, 0x000fe20000010000ULL,
0x00000001ff177807ULL, 0x000fe20000000000ULL, 0x0000000252527220ULL, 0x010fc40000410000ULL,
0x3fb8aa3b05050820ULL, 0x000fe40000410000ULL, 0x0000000253537220ULL, 0x080fe40000410000ULL,
0x0000000500070308ULL, 0x000f220000000800ULL, 0x0000000256567220ULL, 0x080fe40000410000ULL,
0x0000000257577220ULL, 0x080fe40000410000ULL, 0x000000025a5a7220ULL, 0x080fe40000410000ULL,
0x000000025b5b7220ULL, 0x000fc40000410000ULL, 0x000000025e5e7220ULL, 0x080fe40000410000ULL,
0x000000025f5f7220ULL, 0x080fe40000410000ULL, 0x0000000266667220ULL, 0x080fe40000410000ULL,
0x0000000267677220ULL, 0x080fe40000410000ULL, 0x0000000262627220ULL, 0x080fe40000410000ULL,
0x0000000263637220ULL, 0x000fc40000410000ULL, 0x000000024e4e7220ULL, 0x080fe40000410000ULL,
0x000000024f4f7220ULL, 0x080fe40000410000ULL, 0x0000000232327220ULL, 0x080fe40000410000ULL,
0x0000000233337220ULL, 0x000fe40000410000ULL, 0x000000ffff027224ULL, 0x000fe400078e0025ULL,
0x0000002407240220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007ff05723eULL, 0x000fe200000000ffULL, 0x0000000324037221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff367819ULL, 0x002fe40000011600ULL,
0x0000541005357816ULL, 0x004fe20000000005ULL, 0x0000e0227f007947ULL, 0x000fea000b800000ULL,
0x00001f3635057589ULL, 0x0002a800000e0000ULL, 0x00001f0835067589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x002fe200078e0009ULL,
0x0000a58000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x0000e76000007944ULL, 0x02cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff367224ULL, 0x002fe200078e000aULL,
0x0000a5e000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000e70000007944ULL, 0x02cfea0003c00000ULL,
0x000138000c0c7811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000000e38783bULL, 0x002fe20000004200ULL, 0x0001380012127811ULL, 0x000fe400078e20ffULL,
0x0000991017097816ULL, 0x000fe200000000ffULL, 0x000000000c28783bULL, 0x000e660000000200ULL,
0x000000ff0900720cULL, 0x000fe20003f05270ULL, 0x000000000f3c783bULL, 0x000fe20000004200ULL,
0x0000580023097a24ULL, 0x020fc600078e02ffULL, 0x000000001044783bULL, 0x000fe20000004200ULL,
0x00000080092d7824ULL, 0x000fc600078e00ffULL, 0x000000001134783bULL, 0x004fe80000004200ULL,
0x000000001240783bULL, 0x000ea80000000200ULL, 0x000000001348783bULL, 0x000f280000004200ULL,
0x000000001468783bULL, 0x000ee80000004200ULL, 0x00000000156c783bULL, 0x000ee80000004200ULL,
0x000000001670783bULL, 0x0008e20000004200ULL, 0x0000000528288232ULL, 0x002fc40000000000ULL,
0x000000052a2a8232ULL, 0x000fe40000000000ULL, 0x0000000629298232ULL, 0x088fe40000000000ULL,
0x000000062b2b8232ULL, 0x000fce0000000000ULL, 0x000000382850723cULL, 0x000fe20000001850ULL,
0x0000000540408232ULL, 0x084fe40000000000ULL, 0x0000000542428232ULL, 0x000fe20000000000ULL,
0x000003007e057a10ULL, 0x000fe20007ffe0ffULL, 0x0000000641418232ULL, 0x000fc60000000000ULL,
0x0000003c2858723cULL, 0x000fe20000001858ULL, 0x0000000643438232ULL, 0x000fe20000000000ULL,
0x0000000105067810ULL, 0x000fc80007ffe0ffULL, 0x000000790600720cULL, 0x000fe40003f26070ULL,
0x0000003a2838723cULL, 0x040ff00000001854ULL, 0x0000003e283c723cULL, 0x040ff0000000185cULL,
0x000000442864723cULL, 0x040ff00000001864ULL, 0x000000462844723cULL, 0x040ff00000001860ULL,
0x00000034284c723cULL, 0x040ff0000000184cULL, 0x000000362854723cULL, 0x000ff00000001830ULL,
0x0000004a4014723cULL, 0x050ff00000001838ULL, 0x0000006a4030723cULL, 0x040ff0000000183cULL,
0x000000484010723cULL, 0x040ff00000001850ULL, 0x000000684028723cULL, 0x040ff00000001858ULL,
0x0000006c4034723cULL, 0x040ff00000001864ULL, 0x0000006e4038723cULL, 0x040ff00000001844ULL,
0x00000070403c723cULL, 0x040ff0000000184cULL, 0x000000724040723cULL, 0x000fe20000001854ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000070000009947ULL, 0x000fea0003800000ULL,
0x00000003ff457819ULL, 0x000fe20000011600ULL, 0x0000010005057824ULL, 0x000fe400078e00ffULL,
0x000000012c4d7824ULL, 0x000fe200078e020bULL, 0x0000000445477810ULL, 0x000fe20007ffe0ffULL,
0x000000802f2e7824ULL, 0x000fe200078e0245ULL, 0x0000000845497810ULL, 0x000fe40007ffe0ffULL,
0x000000057c067217ULL, 0x000fe20007800000ULL, 0x0000000847197824ULL, 0x000fe200078e00ffULL,
0x0000002d2e097210ULL, 0x000fe20007f3e0ffULL, 0x00000008494c7824ULL, 0x000fe200078e00ffULL,
0x00000000470c7212ULL, 0x080fe200078e3cffULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000000490f7212ULL, 0x000fe200078e3cffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e00090e7a11ULL, 0x000fc400078248ffULL, 0xfffffff819467812ULL, 0x000fe400078ee20cULL,
0x0000000745057812ULL, 0x000fe400078e4800ULL, 0x000000042e0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff84c4c7812ULL, 0x000fe400078ee20fULL, 0x00005f00090f7a11ULL, 0x000fe400008f4c0aULL,
0x00000010454f7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff8050a7812ULL, 0x000fe400078ef800ULL,
0x0000002d0c057210ULL, 0x000fe20007f5e0ffULL, 0x000000084f507824ULL, 0x040fe200078e00ffULL,
0x0000002006067817ULL, 0x000fe20003800000ULL, 0x000000100a097824ULL, 0x000fe200078e020dULL,
0x000000004f257212ULL, 0x000fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x000fe200010e06ffULL,
0x000000064500720cULL, 0x000fe20003f26070ULL, 0x000000104d0a7825ULL, 0x000fe200078e000eULL,
0x00005e0005247a11ULL, 0x000fc400078448ffULL, 0xfffffff850507812ULL, 0x000fe400078ee225ULL,
0x0000000c454b7810ULL, 0x040fe40007ffe0ffULL, 0x0000001445517810ULL, 0x000fe40007ffe0ffULL,
0x00005f0005257a11ULL, 0x000fe200010f4c0cULL, 0x000000084b4e7824ULL, 0x000fe200078e00ffULL,
0x000000082e0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000851527824ULL, 0x000fe200078e00ffULL,
0x000000004b197212ULL, 0x000fe200078e3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a097faeULL, 0x0003e2000c901c46ULL, 0x0000002d0c0f7210ULL, 0x000fc40007f5e0ffULL,
0x0000000051277212ULL, 0x000fe400078e3cffULL, 0x0000000c2e0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000102e447810ULL, 0x040fe40007ffe0ffULL, 0x000000142e487810ULL, 0x040fe40007ffe0ffULL,
0x000000182e4a7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x002fe200010e06ffULL,
0x0000001c2e2e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff84e4e7812ULL, 0x000fe400078ee219ULL,
0xfffffff852527812ULL, 0x000fe400078ee227ULL, 0x0000002d0e277210ULL, 0x080fe40007f7e0ffULL,
0x0000002d44197210ULL, 0x080fe40007f3e0ffULL, 0x0000002d480c7210ULL, 0x080fe40007f9e0ffULL,
0x0000002d4a097210ULL, 0x000fc40007fbe0ffULL, 0x0000002d2e057210ULL, 0x000fe40007f5e0ffULL,
0x0000001c452d7810ULL, 0x000fe40007ffe0ffULL, 0x00005e000f0e7a11ULL, 0x000fe400078c48ffULL,
0x0000001845537810ULL, 0x000fe20007ffe0ffULL, 0x000000082d457824ULL, 0x000fe200078e00ffULL,
0x00005f000f0f7a11ULL, 0x000fe200030f4c0aULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x000000002d2e7212ULL, 0x000fe200078e3cffULL, 0x0000000853547824ULL, 0x000fe200078e00ffULL,
0x00005e0027447a11ULL, 0x000fc400078c48ffULL, 0xfffffff845567812ULL, 0x000fe200078ee22eULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005f0027457a11ULL, 0x000fe200030f4c0aULL,
0x0000001046277824ULL, 0x000fe200078e020dULL, 0x000000064700720cULL, 0x000fe40003f66070ULL,
0x00000000530b7212ULL, 0x000fe400078e3cffULL, 0x00005e0019467a11ULL, 0x000fe400078c48ffULL,
0xfffffff854547812ULL, 0x000fe200078ee20bULL, 0x000000104d0a7825ULL, 0x000fe200078e0024ULL,
0x00005f0019477a11ULL, 0x000fc400030f4c2eULL, 0x00005e000c247a11ULL, 0x040fe200078c48ffULL,
0x000000ffff197224ULL, 0x000fe200020e06ffULL, 0x000000064900720cULL, 0x080fe20003f26070ULL,
0x000000ffff2e7224ULL, 0x000fe200028e06ffULL, 0x00005e0009487a11ULL, 0x000fe200078a48ffULL,
0x000000000a277faeULL, 0x0003e2000d901c46ULL, 0x00005f000c257a11ULL, 0x000fe200030f4c19ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e00054a7a11ULL, 0x000fe200078c48ffULL,
0x0000001050197824ULL, 0x000fe200078e020dULL, 0x000000064b00720cULL, 0x080fe20003f66070ULL,
0x000000104d247825ULL, 0x000fe200078e0024ULL, 0x000000064f00720cULL, 0x000fc40003f86070ULL,
0x000000065100720cULL, 0x080fe20003f46070ULL, 0x00000010564f7824ULL, 0x100fe200078e020dULL,
0x00005f0009497a11ULL, 0x000fe200028f4c2eULL, 0x000000104e097824ULL, 0x100fe200078e020dULL,
0x000000065300720cULL, 0x080fe20003fa6070ULL, 0x0000001052277824ULL, 0x102fe200078e020dULL,
0x00005f00054b7a11ULL, 0x000fe200030f4c0cULL, 0x000000104c057824ULL, 0x100fe200078e020dULL,
0x000000062d00720cULL, 0x000fe20003fc6070ULL, 0x00000010542d7824ULL, 0x000fe400078e020dULL,
0x000000104d0a7825ULL, 0x000fc800078e000eULL, 0x000000104d0c7825ULL, 0x040fe200078e0044ULL,
0x000000000a057faeULL, 0x0003e6000c901c46ULL, 0x000000104d0e7825ULL, 0x040fe200078e0046ULL,
0x000000000c097faeULL, 0x0003e6000d901c46ULL, 0x000000104d447825ULL, 0x040fe200078e0048ULL,
0x000000000e197faeULL, 0x0003e6000e101c46ULL, 0x000000104d467825ULL, 0x000fe200078e004aULL,
0x0000000024277faeULL, 0x0003e8000d101c46ULL, 0x00000000442d7faeULL, 0x0003e8000e901c46ULL,
0x00000000464f7faeULL, 0x0003e2000f101c46ULL, 0x0000063000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011600ULL, 0x0000000c05197810ULL, 0x040fe40007ffe0ffULL,
0x0000000405097810ULL, 0x000fe40007ffe0ffULL, 0x00000000190a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x0000000009067212ULL, 0x040fe200078e3cffULL,
0x0000000809257824ULL, 0x000fe200078e00ffULL, 0x00000008050f7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff819487812ULL, 0x000fc400078ee20aULL, 0x0000001405197810ULL, 0x000fe20007ffe0ffULL,
0x000000080f467824ULL, 0x000fe200078e00ffULL, 0xfffffff8252e7812ULL, 0x000fe200078ee206ULL,
0x000000802f067824ULL, 0x000fe200078e0205ULL, 0x00000000190c7212ULL, 0x0c0fe200078e3cffULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x000000000f097212ULL, 0x000fe400078e3cffULL,
0x00000010050f7810ULL, 0x000fe40007ffe0ffULL, 0x00000004060a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff819507812ULL, 0x000fe200078ee20cULL, 0x000000080f4c7824ULL, 0x040fe200078e00ffULL,
0xfffffff846467812ULL, 0x000fe400078ee209ULL, 0x0000002d0a0c7210ULL, 0x000fe20007f5e0ffULL,
0x00000010504f7824ULL, 0x100fe200078e020dULL, 0x000000000f097212ULL, 0x000fe200078e3cffULL,
0x0000001046277824ULL, 0x000fe200078e020dULL, 0x00000018050f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x00005e000c247a11ULL, 0x000fc400078448ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee209ULL, 0x000000080f547824ULL, 0x040fe200078e00ffULL,
0x0000002d06097210ULL, 0x000fe40007f3e0ffULL, 0x000000000f197212ULL, 0x000fe200078e3cffULL,
0x000000104c4d7824ULL, 0x000fe200078e020dULL, 0x00005f000c257a11ULL, 0x000fe200010f4c25ULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00000008060c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff854547812ULL, 0x000fc400078ee219ULL, 0x0000000705197812ULL, 0x000fe400078e4800ULL,
0x00005e00090e7a11ULL, 0x000fe200078248ffULL, 0x0000001054517824ULL, 0x000fe200078e020dULL,
0x0000001c05057810ULL, 0x000fe40007ffe0ffULL, 0x0000002d0c0c7210ULL, 0x000fe40007f9e0ffULL,
0x0000000c06447810ULL, 0x000fe20007ffe0ffULL, 0x0000000805587824ULL, 0x000fe200078e00ffULL,
0x00005f00090f7a11ULL, 0x000fc400008f4c0aULL, 0x00000010064a7810ULL, 0x040fe40007ffe0ffULL,
0x00000014064e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001806527810ULL, 0x040fe40007ffe0ffULL,
0x0000001c06567810ULL, 0x000fe40007ffe0ffULL, 0x0000000005097212ULL, 0x000fe200078e3cffULL,
0x000000ffff057224ULL, 0x000fe200020e06ffULL, 0x0000002d44067210ULL, 0x000fc40007f5e0ffULL,
0x00005e000c447a11ULL, 0x000fe400078c48ffULL, 0x0000002d4a477210ULL, 0x080fe40007f7e0ffULL,
0x0ffffff8190a7812ULL, 0x000fe200078ef800ULL, 0x000000102e197824ULL, 0x000fe200078e020dULL,
0xfffffff8584a7812ULL, 0x000fe400078ee209ULL, 0x00005f000c457a11ULL, 0x000fe200030f4c05ULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x00005e00060c7a11ULL, 0x000fe200078448ffULL,
0x000000100a097824ULL, 0x100fe200078e020dULL, 0x0000002d4e4e7210ULL, 0x080fe20007f3e0ffULL,
0x000000104a557824ULL, 0x000fe200078e020dULL, 0x0000002d52527210ULL, 0x000fc40007f9e0ffULL,
0x0000002d56567210ULL, 0x000fe20007fbe0ffULL, 0x00000010482d7824ULL, 0x000fe200078e020dULL,
0x00005f00060d7a11ULL, 0x000fe200010f4c05ULL, 0x000000ffff067224ULL, 0x000fe200018e06ffULL,
0x00005e00470a7a11ULL, 0x040fe200078448ffULL, 0x000000ffff497224ULL, 0x000fe200008e06ffULL,
0x00005e004e467a11ULL, 0x000fe200078248ffULL, 0x000000012c057824ULL, 0x000fe200078e020bULL,
0x00005e0052487a11ULL, 0x000fe200078648ffULL, 0x000000ffff4b7224ULL, 0x000fe200020e06ffULL,
0x00005e00564a7a11ULL, 0x000fe200078848ffULL, 0x000000ffff537224ULL, 0x000fe200028e06ffULL,
0x00005f00470b7a11ULL, 0x000fe200010f4c06ULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x00005f004e477a11ULL, 0x000fc400008f4c49ULL, 0x00005f0052497a11ULL, 0x000fe200018f4c4bULL,
0x0000001005247825ULL, 0x040fe200078e0024ULL, 0x00005f00564b7a11ULL, 0x000fe200020f4c53ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e097faeULL, 0x0003e4000b901c46ULL,
0x0000001005447825ULL, 0x040fe400078e0044ULL, 0x0000000024197faeULL, 0x0003e4000b901c46ULL,
0x00000010050c7825ULL, 0x040fe400078e000cULL, 0x0000000044277faeULL, 0x0003e4000b901c46ULL,
0x00000010050a7825ULL, 0x000fc400078e000aULL, 0x000000000c2d7faeULL, 0x0003e4000b901c46ULL,
0x0000001005467825ULL, 0x040fe400078e0046ULL, 0x000000000a4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001005487825ULL, 0x040fe400078e0048ULL, 0x00000000464f7faeULL, 0x0003e4000b901c46ULL,
0x00000010054a7825ULL, 0x000fc400078e004aULL, 0x0000000048517faeULL, 0x0003e8000b901c46ULL,
0x000000004a557faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0001380018187811ULL, 0x000fe400078e20ffULL, 0x00000007ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff057819ULL, 0x002fe40000011600ULL, 0x0000541006067816ULL, 0x000fc40000000006ULL,
0x000138001b1b7811ULL, 0x000fc600078e20ffULL, 0x00001f0506057589ULL, 0x000fe800000e0000ULL,
0x00001f0806087589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000180c783bULL, 0x000e680000000200ULL, 0x000000001c48783bULL, 0x000ea80000004200ULL,
0x000000001a44783bULL, 0x000fe80000004200ULL, 0x000000001d4c783bULL, 0x000fe80000004200ULL,
0x000000001e50783bULL, 0x000fe80000004200ULL, 0x000000001b68783bULL, 0x000ee80000000200ULL,
0x00000000205c783bULL, 0x000f280000004200ULL, 0x000000001f54783bULL, 0x000f680000004200ULL,
0x000000002160783bULL, 0x000f280000004200ULL, 0x00000000226c783bULL, 0x000f220000004200ULL,
0x000000050c0c8232ULL, 0x002fc40000000000ULL, 0x000000050e0e8232ULL, 0x000fe40000000000ULL,
0x000000080d0d8232ULL, 0x080fe40000000000ULL, 0x000000080f0f8232ULL, 0x000fce0000000000ULL,
0x000000480c28723cULL, 0x004fe20000001828ULL, 0x0000000568688232ULL, 0x008fce0000000000ULL,
0x000000440c10723cULL, 0x000fe20000001810ULL, 0x000000056a6a8232ULL, 0x000fe40000000000ULL,
0x0000000869698232ULL, 0x080fe40000000000ULL, 0x000000086b6b8232ULL, 0x000fc60000000000ULL,
0x0000004a0c30723cULL, 0x040ff00000001830ULL, 0x0000004c0c34723cULL, 0x040ff00000001834ULL,
0x000000460c14723cULL, 0x040ff00000001814ULL, 0x0000004e0c38723cULL, 0x040ff00000001838ULL,
0x000000500c3c723cULL, 0x040ff0000000183cULL, 0x000000520c40723cULL, 0x000ff00000001840ULL,
0x0000005c6858723cULL, 0x050ff00000001828ULL, 0x000000546850723cULL, 0x060ff00000001810ULL,
0x0000005e685c723cULL, 0x040ff00000001830ULL, 0x000000606864723cULL, 0x040ff00000001834ULL,
0x000000566854723cULL, 0x040ff00000001814ULL, 0x000000626860723cULL, 0x040ff00000001838ULL,
0x0000006c684c723cULL, 0x040ff0000000183cULL, 0x0000006e6830723cULL, 0x000fe20000001840ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x000003007e7e7a10ULL, 0x000fc80007ffe0ffULL,
0x000000797e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff5cd000007947ULL, 0x000fea000383ffffULL, 0x0000000000267919ULL, 0x000e640000002500ULL,
0x000000792600720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000003007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0003ULL,
0x0000ba0000147802ULL, 0x000fe40000000f00ULL, 0x0000d13000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x000e640000001000ULL, 0xbf80000000047423ULL, 0x002fc80000000003ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000500007223ULL, 0x000fe40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000f220000000000ULL, 0x0000000805057811ULL, 0x004fe400078ff0ffULL,
0x00000002ff077819ULL, 0x010fc80000011604ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f0700047589ULL, 0x000f2200000e0000ULL, 0x0000005205527220ULL, 0x044fe40000410000ULL,
0x0000005305537220ULL, 0x000fe40000410000ULL, 0x0000005004507220ULL, 0x050fe40000410000ULL,
0x0000005104517220ULL, 0x000fc40000410000ULL, 0x0000005404547220ULL, 0x040fe40000410000ULL,
0x0000005504557220ULL, 0x040fe40000410000ULL, 0x0000005804587220ULL, 0x040fe40000410000ULL,
0x0000005904597220ULL, 0x040fe40000410000ULL, 0x0000005c045c7220ULL, 0x040fe40000410000ULL,
0x0000005d045d7220ULL, 0x000fc40000410000ULL, 0x0000006404647220ULL, 0x040fe40000410000ULL,
0x0000006504657220ULL, 0x040fe40000410000ULL, 0x0000006004607220ULL, 0x040fe40000410000ULL,
0x0000006104617220ULL, 0x040fe40000410000ULL, 0x0000004c044c7220ULL, 0x040fe40000410000ULL,
0x0000004d044d7220ULL, 0x000fc40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000003104317220ULL, 0x000fe40000410000ULL, 0x0000005605567220ULL, 0x040fe40000410000ULL,
0x0000005705577220ULL, 0x040fe40000410000ULL, 0x0000005a055a7220ULL, 0x040fe40000410000ULL,
0x0000005b055b7220ULL, 0x000fc40000410000ULL, 0x0000005e055e7220ULL, 0x040fe40000410000ULL,
0x0000005f055f7220ULL, 0x040fe40000410000ULL, 0x0000006605667220ULL, 0x040fe40000410000ULL,
0x0000006705677220ULL, 0x040fe40000410000ULL, 0x0000006205627220ULL, 0x040fe40000410000ULL,
0x0000006305637220ULL, 0x000fc40000410000ULL, 0x0000004e054e7220ULL, 0x040fe40000410000ULL,
0x0000004f054f7220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x000fe40000410000ULL, 0x00000000001e7919ULL, 0x000ea20000000000ULL,
0x00000030310c723eULL, 0x000fe400000000ffULL, 0x000000505105723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000545506723eULL, 0x002fc400000000ffULL,
0x000000585907723eULL, 0x000fe400000000ffULL, 0x0000005c5d08723eULL, 0x000fe400000000ffULL,
0x000000646509723eULL, 0x000fe400000000ffULL, 0x00000060610a723eULL, 0x000fe400000000ffULL,
0x0000004c4d0b723eULL, 0x000fe400000000ffULL, 0x00000052530d723eULL, 0x000fc400000000ffULL,
0x00000056570e723eULL, 0x000fe400000000ffULL, 0x0000005a5b0f723eULL, 0x000fe400000000ffULL,
0x0000005e5f10723eULL, 0x000fe400000000ffULL, 0x00000002ff217819ULL, 0x004fe4000001161eULL,
0x000000081e2f7811ULL, 0x000fe400078ff0ffULL, 0x00000021ff237212ULL, 0x000fe200078e33ffULL,
0x0000000821167824ULL, 0x000fe200078e00ffULL, 0x0000002fff317212ULL, 0x000fe200078e33ffULL,
0x000000082f187824ULL, 0x000fe200078e00ffULL, 0x0000000721007812ULL, 0x040fe200078ec0ffULL,
0x0000000821047824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fc400078ee223ULL,
0xfffffff818317812ULL, 0x000fe400078ee231ULL, 0xfffffff804157812ULL, 0x000fe400078ee221ULL,
0x0000000100047812ULL, 0x040fe400078e3cffULL, 0x0000000200167812ULL, 0x040fe400078e3cffULL,
0x0000000300187812ULL, 0x040fe200078e3cffULL, 0x0000000821177824ULL, 0x040fe200078e0204ULL,
0x00000004001a7812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0216ULL,
0x00000005001c7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0218ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x00000008211d7824ULL, 0x000fe200078e021aULL,
0x000000072f187812ULL, 0x000fe200078ec0ffULL, 0x00000008211f7824ULL, 0x000fe200078e021cULL,
0x000000666711723eULL, 0x000fe200000000ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x00000002181c7812ULL, 0x040fe200078e3cffULL, 0x000008007d007824ULL, 0x000fe200078e00ffULL,
0x0000000418207812ULL, 0x000fe200078e3cffULL, 0x000000041e167824ULL, 0x000fe200078e00ffULL,
0x00000003181e7812ULL, 0x000fe200078e3cffULL, 0x000000082f1a7824ULL, 0x040fe200078e00ffULL,
0x0001200000047810ULL, 0x000fe20007ffe0ffULL, 0x000000082f297824ULL, 0x040fe200078e021cULL,
0x0000000c16167812ULL, 0x000fe200078ec0ffULL, 0x000000082f2b7824ULL, 0x000fe200078e021eULL,
0xfffffff81a257812ULL, 0x000fe200078ee22fULL, 0x0000001015157824ULL, 0x100fe200078e0204ULL,
0x00000001181a7812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x0000000518227812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0204ULL,
0x0000000618247812ULL, 0x000fe200078e3cffULL, 0x0000000115187824ULL, 0x000fe200078e0216ULL,
0x000000626312723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0204ULL,
0x0000004e4f13723eULL, 0x000fe200000000ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0204ULL,
0x0000000518007388ULL, 0x0003e20000000800ULL, 0x000000082f277824ULL, 0x000fe200078e021aULL,
0x000000323314723eULL, 0x000fe200000000ffULL, 0x000000101f1f7824ULL, 0x000fc400078e0204ULL,
0x0000000116177824ULL, 0x040fe400078e0217ULL, 0x0000001021217824ULL, 0x100fe400078e0204ULL,
0x0000001023237824ULL, 0x000fe200078e0204ULL, 0x0000000617007388ULL, 0x0005e20000000800ULL,
0x0000000116187824ULL, 0x042fe400078e0219ULL, 0x00000001161b7824ULL, 0x000fe400078e021bULL,
0x000000082f157824ULL, 0x000fe200078e0220ULL, 0x0000000718007388ULL, 0x0005e20000000800ULL,
0x0000001025257824ULL, 0x000fc400078e0204ULL, 0x00000001161a7824ULL, 0x040fe200078e021dULL,
0x000000081b007388ULL, 0x0005e20000000800ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x000000082f2d7824ULL, 0x000fe200078e0222ULL, 0x000000091a007388ULL, 0x0005e20000000800ULL,
0x0000001027277824ULL, 0x000fe200078e0204ULL, 0x0000030005007a0cULL, 0x000fe20003f05270ULL,
0x00000001161f7824ULL, 0x000fe400078e021fULL, 0x000000082f2f7824ULL, 0x000fc400078e0224ULL,
0x0000001029297824ULL, 0x100fe200078e0204ULL, 0x0000000a1f007388ULL, 0x0005e20000000800ULL,
0x00000001161c7824ULL, 0x040fe400078e0221ULL, 0x0000000116237824ULL, 0x040fe400078e0223ULL,
0x000000102b2b7824ULL, 0x100fe200078e0204ULL, 0x0000000b1c007388ULL, 0x0005e20000000800ULL,
0x00000001161e7824ULL, 0x000fe400078e0225ULL, 0x0000001015157824ULL, 0x100fe200078e0204ULL,
0x0000000c23007388ULL, 0x0005e20000000800ULL, 0x0000001031317824ULL, 0x000fc400078e0204ULL,
0x000000102d2d7824ULL, 0x100fe200078e0204ULL, 0x0000000d1e007388ULL, 0x0005e20000000800ULL,
0x0000000116277824ULL, 0x040fe400078e0227ULL, 0x000000102f2f7824ULL, 0x000fe400078e0204ULL,
0x0000000116207824ULL, 0x040fe200078e0229ULL, 0x0000000e27007388ULL, 0x0005e20000000800ULL,
0x00000001162b7824ULL, 0x040fe400078e022bULL, 0x0000000116227824ULL, 0x040fe200078e0215ULL,
0x0000000f20007388ULL, 0x0005e20000000800ULL, 0x0000000116317824ULL, 0x000fc400078e0231ULL,
0x00000001162d7824ULL, 0x040fe200078e022dULL, 0x000000102b007388ULL, 0x0005e20000000800ULL,
0x0000000116167824ULL, 0x000fc600078e022fULL, 0x0000001122007388ULL, 0x0005e80000000800ULL,
0x000000122d007388ULL, 0x0005e80000000800ULL, 0x0000001316007388ULL, 0x0005e80000000800ULL,
0x0000001431007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002bd000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x004e620000000000ULL,
0x00005800ff077624ULL, 0x000fe200078e00ffULL, 0x000000ff7d00720cULL, 0x000fe20003f25270ULL,
0x00001000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000000107919ULL, 0x000ea20000002700ULL,
0x0000030007077a24ULL, 0x000fc600078e02ffULL, 0x0000000000057919ULL, 0x000ea20000002600ULL,
0x0000660007077a24ULL, 0x000fca00078e02ffULL, 0x00000fff07117811ULL, 0x040fe400078e40ffULL,
0x01ffffff07077812ULL, 0x000fe200078ec0ffULL, 0x00000010060b7824ULL, 0x042fe200078e0200ULL,
0x00000020060f7810ULL, 0x040fe40007ffe0ffULL, 0x000000ff0600720cULL, 0x000fe40003f05270ULL,
0x012000000b147984ULL, 0x0003240000000c00ULL, 0x000000ff7d00720cULL, 0x000fe20000705670ULL,
0x0000580010107a24ULL, 0x004fe200078e0205ULL, 0x012200000b187984ULL, 0x0002a60000000c00ULL,
0x0000030010057a24ULL, 0x000fc800078e02ffULL, 0x00000001050a7824ULL, 0x000fca00078e0226ULL,
0x0000000a11087211ULL, 0x000fca00078fa0ffULL, 0x00006c0008087625ULL, 0x000fcc00078e0009ULL,
0x000004007d087825ULL, 0x000fcc00078e0008ULL, 0x000000100f0e7825ULL, 0x000fc800078e0008ULL,
0x00000010060c7825ULL, 0x000fe200078e0008ULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x00000080ff127424ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x000fe400078e0207ULL, 0x0000001008137824ULL, 0x002fe200078e00ffULL,
0x00000001ff1c7819ULL, 0x000fe20000011608ULL, 0x00006c000a087625ULL, 0x000fc600078e0012ULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x00006c000b0a7625ULL, 0x000fe200078e0012ULL,
0x0000000c1c1c7812ULL, 0x000fc800078ec0ffULL, 0x000000081c087210ULL, 0x140fe40007b5e013ULL,
0x0000000a1c0a7210ULL, 0x000fe40007d9e013ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000000208007986ULL, 0x0003e8000c101906ULL,
0x000000030a007986ULL, 0x0003e4000c101906ULL, 0x000000140c007986ULL, 0x0123e2000c101d06ULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x000000180e007986ULL, 0x0043e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x00000001ff097424ULL, 0x000fe400078e00ffULL, 0x00000004ff037424ULL, 0x000fc600078e00ffULL,
0x0000030009097a10ULL, 0x000fe20007ffe1ffULL, 0x00006a0010027625ULL, 0x000fe200078e0003ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000009020279a8ULL, 0x000ea400099ee1c6ULL, 0x000000090200720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff087807ULL, 0x000fca0000000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff027984ULL, 0x000f240000000000ULL,
0x000000ff0200720cULL, 0x010fda0003f05270ULL, 0x000027c000008947ULL, 0x000fea0003800000ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fe20000011606ULL, 0x00000080ff157424ULL, 0x002fe200078e00ffULL,
0x0000000105087810ULL, 0x004fe40007ffe0ffULL, 0x0000007002197812ULL, 0x000fe400078ec0ffULL,
0x0000000c030c7812ULL, 0x000fe200078ec0ffULL, 0x00006c0005027625ULL, 0x000fc800078e0015ULL,
0x00006c0008087625ULL, 0x000fe200078e0015ULL, 0x000000020c027210ULL, 0x000fc8000791e019ULL,
0x000000080c087210ULL, 0x000fe40007b5e019ULL, 0x00000003ff037210ULL, 0x000fe400007e24ffULL,
0x00000009ff097210ULL, 0x000fc600017e64ffULL, 0x00000006020a7981ULL, 0x000368000c1e1900ULL,
0x00000006080b7981ULL, 0x000362000c1e1900ULL, 0x00000300ff0e7624ULL, 0x000fca00078e00ffULL,
0x000000020e00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000205027810ULL, 0x002fca0007ffe0ffULL, 0x00006c0002027625ULL, 0x000fca00078e0015ULL,
0x000000020c027210ULL, 0x000fc8000791e019ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x00000006020d7981ULL, 0x000362000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000305027810ULL, 0x002fca0007ffe0ffULL,
0x00006c0002027625ULL, 0x000fca00078e0015ULL, 0x000000020c027210ULL, 0x000fc8000791e019ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x00000006020f7981ULL, 0x000362000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000405027810ULL, 0x002fca0007ffe0ffULL, 0x00006c0002027625ULL, 0x000fca00078e0015ULL,
0x000000020c027210ULL, 0x000fc8000791e019ULL, 0x00000003ff037210ULL, 0x000fca00007e24ffULL,
0x0000000602137981ULL, 0x000362000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000505027810ULL, 0x002fca0007ffe0ffULL,
0x00006c0002027625ULL, 0x000fca00078e0015ULL, 0x000000020c027210ULL, 0x000fc8000791e019ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x0000000602177981ULL, 0x000362000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000080e00780cULL, 0x002fe40003f06070ULL, 0x0000000605027810ULL, 0x000fca0007ffe0ffULL,
0x00006c0002027625ULL, 0x000fca00078e0015ULL, 0x000000020c027210ULL, 0x000fe40007a3e019ULL,
0x0000000705080810ULL, 0x000fe40007ffe0ffULL, 0x00000003ff037210ULL, 0x000fc60000fe44ffULL,
0x00006c0008080625ULL, 0x000fca00078e0015ULL, 0x000000080c080210ULL, 0x000fe40007c7e019ULL,
0x0000000602197981ULL, 0x000364000c1e1900ULL, 0x00000009ff090210ULL, 0x000fca0001fe84ffULL,
0x00000006081b0981ULL, 0x000368000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x004fe400078e0005ULL,
0x000000ffff097224ULL, 0x020fe400078e000aULL, 0x000000ffff127224ULL, 0x000fc600078e00ffULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000000412007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x0000000810027810ULL, 0x040fe40007ffe0ffULL, 0x0000000110037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x000000090a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000808027810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011606ULL, 0x0000001006097824ULL, 0x000fe400078e00ffULL,
0x00006c0002027625ULL, 0x000fe200078e0003ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000007009097812ULL, 0x000fc800078ec0ffULL, 0x000000020c027210ULL, 0x000fc80007b3e009ULL,
0x00000003ff037210ULL, 0x000fca0000fe64ffULL, 0x0000000602097981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x0000000910027810ULL, 0x042fe40007ffe0ffULL,
0x0000000210037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000b0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000908027810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011606ULL,
0x00000010060b7824ULL, 0x000fe400078e00ffULL, 0x00006c0002027625ULL, 0x000fe200078e0003ULL,
0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x000000020c027210ULL, 0x000fc80007b3e00bULL, 0x00000003ff037210ULL, 0x000fca0000fe64ffULL,
0x00000006020b7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a10027810ULL, 0x042fe40007ffe0ffULL, 0x0000000310037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a08027810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011606ULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x00006c0002027625ULL, 0x000fe200078e0003ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c0d7812ULL, 0x000fc800078ec0ffULL, 0x000000020e027210ULL, 0x000fc80007b3e00dULL,
0x00000003ff037210ULL, 0x000fca0000fe64ffULL, 0x00000006020d7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000410037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x0000000f0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b08027810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011606ULL,
0x00000010060c7824ULL, 0x000fe400078e00ffULL, 0x00006c0002027625ULL, 0x000fe200078e0003ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0f7812ULL, 0x000fc800078ec0ffULL,
0x000000020e027210ULL, 0x000fc80007b3e00fULL, 0x00000003ff037210ULL, 0x000fca0000fe64ffULL,
0x00000006020f7981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c10027810ULL, 0x042fe40007ffe0ffULL, 0x0000000510037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x000000130a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c08027810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011606ULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x00006c0002027625ULL, 0x000fe200078e0003ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c137812ULL, 0x000fc800078ec0ffULL, 0x000000020e027210ULL, 0x000fc80007b3e013ULL,
0x00000003ff037210ULL, 0x000fca0000fe64ffULL, 0x0000000602137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d10027810ULL, 0x042fe40007ffe0ffULL,
0x0000000610037810ULL, 0x000fe40007ffe0ffULL, 0x0000030002007a0cULL, 0x000fe40003f26070ULL,
0x0000030003007a0cULL, 0x000fe40003f46070ULL, 0x000000170a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d08027810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011606ULL,
0x00000010060c7824ULL, 0x000fe400078e00ffULL, 0x00006c0002027625ULL, 0x000fe200078e0003ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c157812ULL, 0x000fc800078ec0ffULL,
0x000000020e027210ULL, 0x000fc80007b3e015ULL, 0x00000003ff037210ULL, 0x000fca0000fe64ffULL,
0x0000000602177981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e10027810ULL, 0x042fe40007ffe0ffULL, 0x0000000710037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x000000190a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e08027810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff037424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011606ULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x00006c0002027625ULL, 0x000fe200078e0003ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x000000020e027210ULL, 0x000fc80007b3e015ULL,
0x00000003ff037210ULL, 0x000fca0000fe64ffULL, 0x0000000602197981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f10027810ULL, 0x002fe40007ffe0ffULL,
0x0000001b0a0a7209ULL, 0x000fe40007810000ULL, 0x0000030002007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f08027810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011606ULL,
0x00000010060c7824ULL, 0x000fe400078e00ffULL, 0x00006c0002027625ULL, 0x000fe200078e0003ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c157812ULL, 0x000fc800078ec0ffULL,
0x000000020e027210ULL, 0x000fc80007a3e015ULL, 0x00000003ff037210ULL, 0x000fca0000fe44ffULL,
0x00000006021b7981ULL, 0x000368000c1e1900ULL, 0x0000000810107810ULL, 0x000fe40007ffe0ffULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000f240000000000ULL, 0x0000001006027824ULL, 0x012fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011606ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fca00078ec0ffULL, 0x0000000102037824ULL, 0x000fca00078e0203ULL,
0x0000000a03007388ULL, 0x0203e40000000800ULL, 0x000000070600780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000001006027824ULL, 0x000fe200078e00ffULL,
0x00000001ff037819ULL, 0x002fe20000011606ULL, 0x00001000ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000511147211ULL, 0x000fe200078fa0ffULL, 0x0000000105157824ULL, 0x000fe200078e0207ULL,
0x0000007002087812ULL, 0x004fe200078ec0ffULL, 0x000010007d1d7824ULL, 0x000fe200078e00ffULL,
0x0000000c03097812ULL, 0x000fe200078ec0ffULL, 0x00006c0014027625ULL, 0x000fe200078e000bULL,
0x00000020060b7810ULL, 0x000fe20007ffe0ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000300ff007a0cULL, 0x000fe20003f25270ULL, 0x00000080ff0c8424ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000080ff0e8424ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000004007d027825ULL, 0x000fe200078e0002ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00006c00150c8625ULL, 0x000fe200078e000cULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x000000107d138824ULL, 0x000fe400078e0206ULL, 0x00006c00050e8625ULL, 0x000fc600078e000eULL,
0x0000458013138811ULL, 0x000fe200078e20ffULL, 0x00000001081c7824ULL, 0x000fe400078e0209ULL,
0x000000107d178824ULL, 0x000fe400078e0206ULL, 0x0000001006117824ULL, 0x040fe400078e021dULL,
0x0000001006087825ULL, 0x100fe200078e0002ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x000000001c1c7984ULL, 0x000e640000000800ULL, 0x000000100b0a7825ULL, 0x000fc400078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008117faeULL, 0x0005e2000b901c46ULL,
0x0000000000027805ULL, 0x000fe2000001ff00ULL, 0x00000010060c8825ULL, 0x040fe400078e000cULL,
0x003800000a117faeULL, 0x0009e4000b901c46ULL, 0x00000010060e8825ULL, 0x000fe400078e000eULL,
0x000000000c138faeULL, 0x000be4000b901c46ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x000000000e178faeULL, 0x0007e2000b901c46ULL, 0x0000000000087805ULL, 0x004fe2000001ff00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000a7805ULL, 0x010fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00000000000c7805ULL, 0x020fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x008fe2000001ff00ULL,
0x00000d1000009947ULL, 0x000fea0003800000ULL, 0x0000000105337810ULL, 0x000fe20007ffe0ffULL,
0x00000001ff057424ULL, 0x000fe200078e00ffULL, 0x0000000115317810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff027224ULL, 0x000fe200078e00ffULL, 0x0000000114327810ULL, 0x000fc40007ffe0ffULL,
0x0000030005007a0cULL, 0x000fda0003f06070ULL, 0x000001f000000947ULL, 0x000fea0003800000ULL,
0x000000070600780cULL, 0x040fe20003f04070ULL, 0x0000080005147824ULL, 0x040fe200078e00ffULL,
0x0000000105187812ULL, 0x000fe200078ec0ffULL, 0x00001000ff157424ULL, 0x000fe200078e00ffULL,
0x0000002006397810ULL, 0x000fe40007ffe0ffULL, 0x0000080014167812ULL, 0x000fe200078ec0ffULL,
0x00006c0032147625ULL, 0x000fc800078e0015ULL, 0x000000011d177824ULL, 0x000fe400078e0216ULL,
0x000000027d198824ULL, 0x140fe400078e0218ULL, 0x000000027d1b8824ULL, 0x040fe400078e0218ULL,
0x00000080ff188424ULL, 0x000fe400078e00ffULL, 0x00000080ff1a8424ULL, 0x000fe400078e00ffULL,
0x000004007d147825ULL, 0x000fc800078e0014ULL, 0x0000000819378824ULL, 0x100fe400078e0206ULL,
0x000000081b348824ULL, 0x000fe400078e0206ULL, 0x00006c0031188625ULL, 0x000fe200078e0018ULL,
0x0000458037378811ULL, 0x000fc600078e20ffULL, 0x00006c00331a8625ULL, 0x000fc800078e001aULL,
0x0000001006357824ULL, 0x000fe400078e0217ULL, 0x0000001039167825ULL, 0x000fe200078e0014ULL,
0x0000418034398811ULL, 0x000fc600078e20ffULL, 0x0000001006147825ULL, 0x000fc800078e0014ULL,
0x0000001006188825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000014357faeULL, 0x0005e6000b901c46ULL, 0x00000010061a8825ULL, 0x000fe200078e001aULL,
0x0038000016357faeULL, 0x0005e8000b901c46ULL, 0x0000000018378faeULL, 0x0005e8000b901c46ULL,
0x000000001a398faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff05147810ULL, 0x004fe20007ffe0ffULL, 0x0000001006177824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fc40000011606ULL, 0x00000002ff347819ULL, 0x000fe20000011606ULL,
0x0000008014157824ULL, 0x040fe200078e00ffULL, 0x0000007017177812ULL, 0x000fe200078ec0ffULL,
0x0000080014147824ULL, 0x000fe200078e00ffULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x0000000834367824ULL, 0x040fe200078e00ffULL, 0x0000008015167812ULL, 0x000fe200078ec0ffULL,
0x00000008341a7824ULL, 0x040fe200078e00ffULL, 0x00000034ff157212ULL, 0x000fe400078e33ffULL,
0x0000000734397812ULL, 0x000fe200078ec0ffULL, 0x000001007d167824ULL, 0x000fe200078e0216ULL,
0xfffffff836437812ULL, 0x000fc400078ee215ULL, 0x0000080014147812ULL, 0x000fe400078ec0ffULL,
0x0000001618187210ULL, 0x000fe20007ffe017ULL, 0x0000000834167824ULL, 0x000fe200078e00ffULL,
0xfffffff81a157812ULL, 0x000fe200078ee239ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000183b7984ULL, 0x000ea20000000800ULL, 0x0000000116177812ULL, 0x140fe400078ef639ULL,
0x0000000216197812ULL, 0x140fe200078ef639ULL, 0x00458000184b7984ULL, 0x0007220000000800ULL,
0x00000003161b7812ULL, 0x140fe400078ef639ULL, 0x0000000416357812ULL, 0x140fe400078ef639ULL,
0x0000000516377812ULL, 0x140fe400078ef639ULL, 0x0000000616397812ULL, 0x000fe200078ef639ULL,
0x0000000406167824ULL, 0x000fe200078e00ffULL, 0x000001801d147810ULL, 0x000fc40007ffe014ULL,
0x0000000834387810ULL, 0x000fe40007ffe0ffULL, 0x0000000c16367812ULL, 0x000fe200078ec0ffULL,
0x0000001015157824ULL, 0x100fe200078e0214ULL, 0x00000038ff497212ULL, 0x000fe200078e33ffULL,
0x0000001043167824ULL, 0x100fe200078e0214ULL, 0x0000030005007a0cULL, 0x040fe20003f06070ULL,
0x0000000136157824ULL, 0x000fe200078e0215ULL, 0x0000000105057810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x100fe200078e0214ULL, 0x0000000131317810ULL, 0x000fe20007ffe0ffULL,
0x0000001019197824ULL, 0x000fe200078e0214ULL, 0x0000000132327810ULL, 0x000fe20007ffe0ffULL,
0x0000000015157984ULL, 0x000fe20000000800ULL, 0x0000000838187824ULL, 0x008fe200078e00ffULL,
0x0000000133337810ULL, 0x000fe20007ffe0ffULL, 0x0000000136167824ULL, 0x000fc400078e0216ULL,
0x0000000136177824ULL, 0x000fe200078e0217ULL, 0xfffffff818497812ULL, 0x000fe200078ee249ULL,
0x0000000136197824ULL, 0x000fe200078e0219ULL, 0x0000000738187812ULL, 0x000fe200078ec0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0214ULL, 0x0000000016167984ULL, 0x000ee20000000800ULL,
0x0000001035357824ULL, 0x000fe400078e0214ULL, 0x0000003b1c3b7221ULL, 0x006fe20000010100ULL,
0x0000000017177984ULL, 0x000fe20000000800ULL, 0x00000008383d7824ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b3b1a7820ULL, 0x000fe20000410000ULL, 0x0000000019197984ULL, 0x000fe20000000800ULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0x000000013d3f7812ULL, 0x140fe200078ef618ULL,
0x00000001361b7824ULL, 0x040fe200078e021bULL, 0x000000023d417812ULL, 0x100fe200078ef618ULL,
0x0000001a001a7308ULL, 0x000f220000000800ULL, 0x0000000136357824ULL, 0x040fe200078e0235ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee218ULL, 0x0000001037377824ULL, 0x100fe200078e0214ULL,
0x000000001b1b7984ULL, 0x000fe20000000800ULL, 0x0000001039397824ULL, 0x000fe200078e0214ULL,
0x000000033d437812ULL, 0x140fe200078ef618ULL, 0x0000000136377824ULL, 0x040fe200078e0237ULL,
0x0000000035357984ULL, 0x000fe20000000800ULL, 0x0000000136397824ULL, 0x040fe200078e0239ULL,
0x000000043d457812ULL, 0x000fe200078ef618ULL, 0x000000103b3b7824ULL, 0x000fe200078e0214ULL,
0x000000053d477812ULL, 0x000fe200078ef618ULL, 0x000000103f3f7824ULL, 0x000fe200078e0214ULL,
0x0000000037377984ULL, 0x000fe20000000800ULL, 0x00000001363b7824ULL, 0x000fe200078e023bULL,
0x000000063d3d7812ULL, 0x000fe200078ef618ULL, 0x0000004b1a4b7220ULL, 0x010fe20000410000ULL,
0x0000000039397984ULL, 0x000fe20000000800ULL, 0x00000001363f7824ULL, 0x000fc400078e023fULL,
0x0000001041417824ULL, 0x100fe200078e0214ULL, 0x00001f344b1a7589ULL, 0x000e6200000e0000ULL,
0x0000001043437824ULL, 0x100fe400078e0214ULL, 0x0000000136417824ULL, 0x040fe200078e0241ULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x0000000136437824ULL, 0x000fe200078e0243ULL,
0x20000016ff187230ULL, 0x008fe20000004100ULL, 0x0000001045457824ULL, 0x100fe200078e0214ULL,
0x000000003f3f7984ULL, 0x000ee20000000800ULL, 0x0000001047477824ULL, 0x000fc400078e0214ULL,
0x0000000136457824ULL, 0x040fe200078e0245ULL, 0x0000000041417984ULL, 0x000f220000000800ULL,
0x0000000136477824ULL, 0x040fe400078e0247ULL, 0x0000001049497824ULL, 0x100fe200078e0214ULL,
0x0000000043437984ULL, 0x000fe20000000800ULL, 0x000000103d3d7824ULL, 0x000fe200078e0214ULL,
0x20000015ff147230ULL, 0x100fe20000004100ULL, 0x0000000136497824ULL, 0x040fe200078e0249ULL,
0x0000000045457984ULL, 0x000fe20000000800ULL, 0x00000001363d7824ULL, 0x000fe200078e023dULL,
0x30000015ff157230ULL, 0x000fe20000004100ULL, 0x000000304b307221ULL, 0x000fe20000010000ULL,
0x0000000047477984ULL, 0x000fe20000000800ULL, 0x0000001a142f7223ULL, 0x082fe2000001002fULL,
0x20000017ff147230ULL, 0x000fe20000004100ULL, 0x0000001a152e7223ULL, 0x080fe2000001002eULL,
0x0000000049497984ULL, 0x000fe20000000800ULL, 0x30000016ff157230ULL, 0x000fe20000004100ULL,
0x0000001a181f7223ULL, 0x080fe2000001001fULL, 0x20000019ff167230ULL, 0x000fe20000004100ULL,
0x000000003d3d7984ULL, 0x000fe20000000800ULL, 0x0000001a142b7223ULL, 0x080fe2000001002bULL,
0x2000001bff147230ULL, 0x000fe20000004100ULL, 0x0000001a151e7223ULL, 0x080fe2000001001eULL,
0x00001f384b4b7589ULL, 0x000e6200000e0000ULL, 0x0000001a16297223ULL, 0x080fe20000010029ULL,
0x20000035ff167230ULL, 0x000fe20000004100ULL, 0x0000001a14277223ULL, 0x000fe20000010027ULL,
0x20000037ff147230ULL, 0x000fc40000004100ULL, 0x30000017ff177230ULL, 0x000fe20000004100ULL,
0x0000001a16257223ULL, 0x080fe20000010025ULL, 0x20000039ff167230ULL, 0x000fe20000004100ULL,
0x0000001a14237223ULL, 0x080fe20000010023ULL, 0x2000003bff147230ULL, 0x004fe20000004100ULL,
0x0000001a172a7223ULL, 0x080fe2000001002aULL, 0x2000003fff157230ULL, 0x008fe20000004100ULL,
0x0000001a16217223ULL, 0x000fe20000010021ULL, 0x3000003bff167230ULL, 0x000fe40000004100ULL,
0x20000041ff177230ULL, 0x010fc40000004100ULL, 0x30000019ff197230ULL, 0x000fe40000004100ULL,
0x3000001bff1b7230ULL, 0x000fe40000004100ULL, 0x30000035ff357230ULL, 0x000fe20000004100ULL,
0x0000001a19287223ULL, 0x080fe20000010028ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x0000004b142d7223ULL, 0x082fe2000001002dULL, 0x3000003fff147230ULL, 0x000fe20000004100ULL,
0x0000004b16137223ULL, 0x080fe20000010013ULL, 0x30000041ff167230ULL, 0x000fe20000004100ULL,
0x0000004b15127223ULL, 0x080fe20000010012ULL, 0x20000043ff157230ULL, 0x100fe20000004100ULL,
0x0000004b14117223ULL, 0x080fe20000010011ULL, 0x30000043ff147230ULL, 0x000fe20000004100ULL,
0x0000004b160f7223ULL, 0x080fe2000001000fULL, 0x30000045ff167230ULL, 0x000fe20000004100ULL,
0x0000004b150e7223ULL, 0x080fe2000001000eULL, 0x20000047ff157230ULL, 0x000fe20000004100ULL,
0x0000004b17107223ULL, 0x080fe20000010010ULL, 0x20000049ff187230ULL, 0x000fe20000004100ULL,
0x0000004b140d7223ULL, 0x080fe2000001000dULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x0000004b160b7223ULL, 0x080fe2000001000bULL, 0x20000045ff177230ULL, 0x000fe20000004100ULL,
0x0000004b150a7223ULL, 0x000fe2000001000aULL, 0x30000047ff147230ULL, 0x000fe20000004100ULL,
0x0000001a1b267223ULL, 0x080fe20000010026ULL, 0x2000003dff157230ULL, 0x100fe20000004100ULL,
0x0000001a35247223ULL, 0x080fe20000010024ULL, 0x3000003dff167230ULL, 0x000fe20000004100ULL,
0x0000001a37227223ULL, 0x080fe20000010022ULL, 0x30000049ff497230ULL, 0x000fe20000004100ULL,
0x0000001a39207223ULL, 0x000fc40000010020ULL, 0x0000004b170c7223ULL, 0x080fe4000001000cULL,
0x0000004b14097223ULL, 0x080fe40000010009ULL, 0x0000004b15087223ULL, 0x080fe40000010008ULL,
0x0000004b16077223ULL, 0x080fe40000010007ULL, 0x0000004b18037223ULL, 0x080fe40000010003ULL,
0x0000004b49027223ULL, 0x000fe20000010002ULL, 0xfffff34000008947ULL, 0x000fea000383ffffULL,
0x0180000030057810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fe60000010000ULL,
0x7f80000005057812ULL, 0x000fc600078ec0ffULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0030ULL, 0x0000e67000147802ULL, 0x000fe40000000f00ULL,
0x0000a4c000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000003000057308ULL, 0x000ea40000001000ULL, 0xbf80000005067423ULL, 0x004fc80000000030ULL,
0x800000ff06067221ULL, 0x000fc80000010100ULL, 0x0000000605057223ULL, 0x000fe40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008151a7811ULL, 0x050fe400078ff0ffULL,
0x00000002ff187819ULL, 0x000fe20000011615ULL, 0x0000000415157824ULL, 0x000fe200078e00ffULL,
0x0000001aff177212ULL, 0x000fe200078e33ffULL, 0x00001f1a05147589ULL, 0x00cea400000e0000ULL,
0x00000008181c7824ULL, 0x002fc400078e00ffULL, 0x00001f1805067589ULL, 0x0002e400000e0000ULL,
0x00000018ff057212ULL, 0x002fc800078e33ffULL, 0xfffffff81c317812ULL, 0x000fe400078ee205ULL,
0x0000000718057812ULL, 0x000fc600078ec0ffULL, 0x0000001031317824ULL, 0x000fe200078e0204ULL,
0x0000000305197812ULL, 0x040fe200078e3cffULL, 0x0000000314037220ULL, 0x044fe20000410000ULL,
0x00000004051b7812ULL, 0x040fe200078e3cffULL, 0x0000000214027220ULL, 0x000fe20000410000ULL,
0x00000005051d7812ULL, 0x000fe200078e3cffULL, 0x0000002f062f7220ULL, 0x048fe40000410000ULL,
0x0000002e062e7220ULL, 0x000fe20000410000ULL, 0x000000030202723eULL, 0x000fe200000000ffULL,
0x0000002b062b7220ULL, 0x000fc40000410000ULL, 0x0000002a062a7220ULL, 0x000fe20000410000ULL,
0x0000002f2e2e723eULL, 0x000fe200000000ffULL, 0x0000002906297220ULL, 0x040fe40000410000ULL,
0x0000002806287220ULL, 0x000fe20000410000ULL, 0x0000002b2a2a723eULL, 0x000fe200000000ffULL,
0x0000002706277220ULL, 0x040fe40000410000ULL, 0x0000002606267220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000002506257220ULL, 0x000fc40000410000ULL,
0x0000002406247220ULL, 0x000fe20000410000ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000002306237220ULL, 0x040fe40000410000ULL, 0x0000002206227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002106217220ULL, 0x040fe40000410000ULL,
0x0000002006207220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001f061f7220ULL, 0x000fc40000410000ULL, 0x0000001e06067220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x000000081a1e7824ULL, 0x000fe400078e00ffULL,
0x0000000814087220ULL, 0x000fe20000410000ULL, 0x0000001f0606723eULL, 0x000fe200000000ffULL,
0x0000000714077220ULL, 0x000fe20000410000ULL, 0xfffffff81e337812ULL, 0x000fe200078ee217ULL,
0x0000000818037824ULL, 0x000fe200078e00ffULL, 0x0000000205177812ULL, 0x040fe200078e3cffULL,
0x0000001314167220ULL, 0x000fe20000410000ULL, 0x0000000105137812ULL, 0x000fe200078e3cffULL,
0x000000081a1f7824ULL, 0x000fe200078e00ffULL, 0x000000080707723eULL, 0x000fe200000000ffULL,
0x0000000818177824ULL, 0x000fe200078e0217ULL, 0x000000071a087812ULL, 0x000fe200078ec0ffULL,
0x0000000818137824ULL, 0x040fe200078e0213ULL, 0xfffffff803037812ULL, 0x000fe200078ee218ULL,
0x0000000818197824ULL, 0x040fe200078e0219ULL, 0x0000000605057812ULL, 0x000fe200078e3cffULL,
0x00000008181b7824ULL, 0x000fe200078e021bULL, 0x0000000108217812ULL, 0x040fe200078e3cffULL,
0x0000001003037824ULL, 0x100fe200078e0204ULL, 0x0000000208237812ULL, 0x000fe200078e3cffULL,
0x00000008181d7824ULL, 0x000fe200078e021dULL, 0x0000000308257812ULL, 0x040fe200078e3cffULL,
0x0000001013137824ULL, 0x100fe200078e0204ULL, 0x0000000408277812ULL, 0x000fe200078e3cffULL,
0x0000000818057824ULL, 0x000fe200078e0205ULL, 0x0000000508297812ULL, 0x040fe200078e3cffULL,
0x0000001017177824ULL, 0x100fe200078e0204ULL, 0x00000006082b7812ULL, 0x000fe200078e3cffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x0000000c15087812ULL, 0x000fe200078ec0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee21aULL,
0x000000081a217824ULL, 0x000fc400078e0221ULL, 0x0000000103037824ULL, 0x000fe400078e0208ULL,
0x000000101d1d7824ULL, 0x100fe400078e0204ULL, 0x0000000108137824ULL, 0x000fe200078e0213ULL,
0x0000002e03007388ULL, 0x0003e20000000800ULL, 0x000000081a237824ULL, 0x000fe400078e0223ULL,
0x0000001005057824ULL, 0x000fe200078e0204ULL, 0x0000002a13007388ULL, 0x0003e20000000800ULL,
0x0000000108177824ULL, 0x000fc400078e0217ULL, 0x0000002d142d7220ULL, 0x000fe40000410000ULL,
0x000000081a257824ULL, 0x000fe200078e0225ULL, 0x0000002817007388ULL, 0x0003e20000000800ULL,
0x0000000108197824ULL, 0x000fe200078e0219ULL, 0x0000002d1616723eULL, 0x000fe200000000ffULL,
0x0000001214127220ULL, 0x040fe40000410000ULL, 0x0000001114117220ULL, 0x040fe20000410000ULL,
0x0000002619007388ULL, 0x0003e20000000800ULL, 0x0000000a140a7220ULL, 0x000fc40000410000ULL,
0x0000000914097220ULL, 0x000fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x000000081a277824ULL, 0x040fe400078e0227ULL, 0x000000081a297824ULL, 0x040fe200078e0229ULL,
0x0000000a0909723eULL, 0x000fe200000000ffULL, 0x000000081a2b7824ULL, 0x000fe400078e022bULL,
0x000000101f1f7824ULL, 0x000fe400078e0204ULL, 0x00000001081b7824ULL, 0x000fc400078e021bULL,
0x0000001014107220ULL, 0x040fe40000410000ULL, 0x0000000f140f7220ULL, 0x040fe20000410000ULL,
0x000000241b007388ULL, 0x0003e20000000800ULL, 0x0000000c140c7220ULL, 0x040fe40000410000ULL,
0x0000000b140b7220ULL, 0x000fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x000fe400078e0204ULL, 0x00000001081d7824ULL, 0x000fe200078e021dULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000000e140e7220ULL, 0x000fc40000410000ULL,
0x0000000d140d7220ULL, 0x000fe20000410000ULL, 0x000000221d007388ULL, 0x0003e20000000800ULL,
0x0000001023237824ULL, 0x100fe400078e0204ULL, 0x0000000108057824ULL, 0x040fe200078e0205ULL,
0x0000000e0d0d723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x100fe400078e0204ULL,
0x0000000108317824ULL, 0x000fe200078e0231ULL, 0x0000002005007388ULL, 0x0003e20000000800ULL,
0x0000001033337824ULL, 0x000fc400078e0204ULL, 0x0000001027277824ULL, 0x100fe200078e0204ULL,
0x0000000631007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x100fe400078e0204ULL,
0x000000102b2b7824ULL, 0x000fe400078e0204ULL, 0x00000001081f7824ULL, 0x040fe400078e021fULL,
0x0000000108047824ULL, 0x040fe400078e0221ULL, 0x00000001080a7824ULL, 0x040fe200078e0223ULL,
0x000000161f007388ULL, 0x0003e20000000800ULL, 0x00000001080c7824ULL, 0x000fc400078e0225ULL,
0x00000001080e7824ULL, 0x040fe200078e0227ULL, 0x0000001104007388ULL, 0x0003e20000000800ULL,
0x0000000108337824ULL, 0x040fe400078e0233ULL, 0x0000000108107824ULL, 0x040fe200078e0229ULL,
0x0000000f0a007388ULL, 0x0003e20000000800ULL, 0x0000000108087824ULL, 0x000fc600078e022bULL,
0x0000000d0c007388ULL, 0x0003e80000000800ULL, 0x0000000b0e007388ULL, 0x0003e80000000800ULL,
0x0000000910007388ULL, 0x0003e80000000800ULL, 0x0000000708007388ULL, 0x0003e80000000800ULL,
0x0000000233007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x00000000000579c3ULL, 0x000f220000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x000f620000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020050d7810ULL, 0x006fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x010fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008040f7824ULL, 0x020fe200078e00ffULL,
0x0000000706087812ULL, 0x000fe400078e4805ULL, 0x0000000702037812ULL, 0x000fe400078e480dULL,
0x0ffffff808077812ULL, 0x000fe400078ef805ULL, 0x0ffffff803037812ULL, 0x000fc400078ef80dULL,
0xfffffff80f027812ULL, 0x000fe200078ee202ULL, 0x0000001007087824ULL, 0x100fe200078e0200ULL,
0x000000070d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x000fe400078e0200ULL,
0x0000000804077824ULL, 0x000fe200078e00ffULL, 0x1ffffff80d0d7812ULL, 0x000fe200078ef82cULL,
0x0120000008087984ULL, 0x000e660000000c00ULL, 0xfffffff807007812ULL, 0x000fe200078ee206ULL,
0x0120000003107984ULL, 0x0005220000000c00ULL, 0x0000000705077812ULL, 0x000fc400078ec0ffULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL,
0x1ffffff807077812ULL, 0x000fe200078ef82cULL, 0x000000ffff037224ULL, 0x004fe200000e06ffULL,
0x00005a0006027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fe400078248ffULL, 0x00005b0006037a11ULL, 0x000fc400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe2000001167dULL, 0xffffffffff917424ULL, 0x000fc800078e00ffULL,
0x000000027e7a7824ULL, 0x000fca00078e0203ULL, 0x0000007b7a00720cULL, 0x000fda0003f06070ULL,
0x000000022d038824ULL, 0x000fc800078e00ffULL, 0x0000640003068a24ULL, 0x002fc800078e027aULL,
0x0000600006068625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000606918981ULL, 0x000ea2000c1e1900ULL, 0x000000017e047810ULL, 0x000fe20007ffe0ffULL,
0x000000407d787824ULL, 0x000fe400078e00ffULL, 0x000000802f2f7824ULL, 0x000fe200078e00ffULL,
0x000000790400720cULL, 0x000fe20003f06070ULL, 0x000001007e097824ULL, 0x000fe200078e0278ULL,
0x01c60000ff027f8cULL, 0x000e62000c80043fULL, 0x000000802e2e7824ULL, 0x000fc600078e00ffULL,
0x000000402f1c7812ULL, 0x000fe200078ef809ULL, 0x0000002e91047224ULL, 0x004fcc00078e02ffULL,
0x00000e7000008947ULL, 0x000fea0003800000ULL, 0x000000097c067217ULL, 0x002fe40007800000ULL,
0x00000003ff1f7819ULL, 0x000fe40000011600ULL, 0x0000007005217812ULL, 0x000fe200078ec0ffULL,
0x0000000106107824ULL, 0x000fe200078e0a09ULL, 0x000000041f097810ULL, 0x040fe20007ffe0ffULL,
0x000000011c077824ULL, 0x000fe200078e021fULL, 0x000000081f0b7810ULL, 0x000fe40007ffe0ffULL,
0x000000100900720cULL, 0x040fe20003f06070ULL, 0x00000008090d7824ULL, 0x040fe200078e00ffULL,
0x0000000704187210ULL, 0x000fe20007f3e0ffULL, 0x000000011c077824ULL, 0x000fe200078e0209ULL,
0x0000000009067212ULL, 0x000fe200078e3cffULL, 0x000000080b117824ULL, 0x000fe200078e00ffULL,
0x0000000c1f197810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000704077210ULL, 0x000fc40007f5e0ffULL, 0x00005e0018177a11ULL, 0x040fe200078248ffULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0x000000141f237810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200010e06ffULL, 0x00005e00070f7a11ULL, 0x040fe400078448ffULL,
0x00005f0018187a11ULL, 0x000fe200008f4c09ULL, 0x000000011c097824ULL, 0x040fe200078e0219ULL,
0x00005f0007167a11ULL, 0x000fe200010f4c16ULL, 0x000000011c077824ULL, 0x000fe200078e020bULL,
0x000000000b087212ULL, 0x000fc400078e3cffULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee206ULL,
0x000000011c0d7824ULL, 0x000fe200078e0223ULL, 0x0000000704077210ULL, 0x040fe40007f9e0ffULL,
0x0000000904097210ULL, 0x000fe40007fbe0ffULL, 0xfffffff811207812ULL, 0x000fe200078ee208ULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x00005e00070a7a11ULL, 0x000fe200078848ffULL,
0x000000ffff087224ULL, 0x000fe200028e06ffULL, 0x000000101f1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000d040d7210ULL, 0x000fe40007f7e0ffULL, 0x00005e0009137a11ULL, 0x000fe200078a48ffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0x00005f0007117a11ULL, 0x000fe200020f4c12ULL,
0x000000ffff067224ULL, 0x000fe200018e06ffULL, 0x000000071f077812ULL, 0x040fe400078e4800ULL,
0x000000181f257810ULL, 0x000fe40007ffe0ffULL, 0x000000100b00720cULL, 0x000fe20003f26070ULL,
0x000000011c0b7824ULL, 0x000fe200078e021dULL, 0x00005f0009157a11ULL, 0x000fc400028f4c08ULL,
0x0ffffff807087812ULL, 0x000fe200078ef800ULL, 0x000000011c077824ULL, 0x000fe200078e0225ULL,
0x00005e000d147a11ULL, 0x040fe400078648ffULL, 0x0000000b040b7210ULL, 0x040fe40007f5e0ffULL,
0x00005f000d1b7a11ULL, 0x000fe400018f4c06ULL, 0x00000007041a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0e7224ULL, 0x000fe200010e06ffULL, 0x0000001721067210ULL, 0x000fc40007f7e0ffULL,
0x00005e000b0c7a11ULL, 0x000fe200078448ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x000020007d057811ULL, 0x000fe200078e70ffULL, 0x000000ffff077224ULL, 0x000fe200018e0618ULL,
0x000000101d00720cULL, 0x000fe20003f86070ULL, 0x0000000825187824ULL, 0x000fe200078e00ffULL,
0x000000001d177212ULL, 0x000fe200078e3cffULL, 0x00000010080d7824ULL, 0x000fe200078e0205ULL,
0x00005e001a127a11ULL, 0x000fe400078648ffULL, 0x00005f000b0e7a11ULL, 0x000fc400010f4c0eULL,
0x0000001c1f1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000101f00720cULL, 0x080fe40003f46070ULL,
0x00005f001a1a7a11ULL, 0x000fe400018f4c09ULL, 0x0000000f21087210ULL, 0x000fe20007f7e0ffULL,
0x000000011c0f7824ULL, 0x000fe200078e021dULL, 0x000000101900720cULL, 0x040fe40003fa6070ULL,
0x00000000190b7212ULL, 0x000fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200018e0616ULL,
0x0000000f04197210ULL, 0x000fe20007fde0ffULL, 0x000000101e0f7824ULL, 0x000fe200078e0205ULL,
0xfffffff824247812ULL, 0x000fe200078ee217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0003e2000d101c46ULL, 0x0000000a210a7210ULL, 0x000fc40007f7e0ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20bULL, 0x00000000080f7faeULL, 0x0005e2000c101c46ULL,
0x000000102300720cULL, 0x040fe20003f46070ULL, 0x000000ffff0b7224ULL, 0x000fe200018e0611ULL,
0x0000000023167212ULL, 0x000fe200078e3cffULL, 0x0000001020117824ULL, 0x100fe200078e0205ULL,
0x000000101d00720cULL, 0x080fe20003f06070ULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0x000000102500720cULL, 0x000fe20003f66070ULL, 0x000000ffff067224ULL, 0x002fe200030e06ffULL,
0x00005e0019177a11ULL, 0x000fe200078c48ffULL, 0x000000000a117faeULL, 0x0003e2000c901c46ULL,
0x0000000025077212ULL, 0x000fe200078e3cffULL, 0x00000010240f7824ULL, 0x004fe200078e0205ULL,
0x00005f0019197a11ULL, 0x000fc400030f4c06ULL, 0x0000001321067210ULL, 0x000fe40007fde0ffULL,
0x000000201f137810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8181e7812ULL, 0x000fe200078ee207ULL,
0x000000ffff077224ULL, 0x000fe200030e0615ULL, 0x0000000c210c7210ULL, 0x000fe20007f3e0ffULL,
0x000000011c157824ULL, 0x000fe200078e0213ULL, 0x0000000013087212ULL, 0x000fe200078e3cffULL,
0x00000010220b7824ULL, 0x002fe200078e0205ULL, 0xfffffff823267812ULL, 0x000fe200078ee216ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060eULL, 0x0000001504187210ULL, 0x000fc40007fde0ffULL,
0x000000101300720cULL, 0x040fe20003f26070ULL, 0x0000000813137824ULL, 0x000fe200078e00ffULL,
0x000000001d167212ULL, 0x040fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e0018157a11ULL, 0x040fe200078c48ffULL, 0x000000081d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8130e7812ULL, 0x000fe200078ee208ULL, 0x00000000060b7faeULL, 0x0003e2000e901c46ULL,
0x00005f0018187a11ULL, 0x000fe400030f4c09ULL, 0x000000241f097810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0f7faeULL, 0x0005e2000e101c46ULL, 0x0000001421087210ULL, 0x000fc40007fbe0ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee216ULL, 0x000000011c117824ULL, 0x000fe200078e0209ULL,
0x000000100900720cULL, 0x040fe40003f86070ULL, 0x00000000090a7212ULL, 0x040fe400078e3cffULL,
0x0000001104137210ULL, 0x000fe20007fde0ffULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0x000000381f1d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff097224ULL, 0x000fe200028e061bULL,
0x0000001221067210ULL, 0x002fe20007fbe0ffULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e0013147a11ULL, 0x000fc400078c48ffULL, 0xfffffff811127812ULL, 0x000fe200078ee20aULL,
0x0000001026117824ULL, 0x100fe200078e0205ULL, 0x00005f00130f7a11ULL, 0x004fe200030f4c16ULL,
0x000000ffff077224ULL, 0x000fe200028e061aULL, 0x000000341f1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000101e137824ULL, 0x100fe200078e0205ULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x00000017210a7210ULL, 0x040fe20007f5e0ffULL, 0x000000100e177824ULL, 0x000fe400078e0205ULL,
0x0000000006137faeULL, 0x0005e2000d901c46ULL, 0x00000015210c7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e0619ULL, 0x00000014210e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001020157824ULL, 0x000fc400078e0205ULL, 0x000000ffff0d7224ULL, 0x000fe400018e0618ULL,
0x0000001012197824ULL, 0x000fe200078e0205ULL, 0x000000000a157faeULL, 0x0007e2000c101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000002c1f117810ULL, 0x002fe20007ffe0ffULL,
0x000000081d127824ULL, 0x000fe200078e00ffULL, 0x000000281f077810ULL, 0x044fe20007ffe0ffULL,
0x000000000c177faeULL, 0x0003e2000c901c46ULL, 0x000000301f137810ULL, 0x000fe40007ffe0ffULL,
0x000000100700720cULL, 0x040fe20003fa6070ULL, 0x000000011c097824ULL, 0x000fe200078e0207ULL,
0x000000000e197faeULL, 0x0005e2000e101c46ULL, 0x0000000007067212ULL, 0x0c0fe200078e3cffULL,
0x00000008070b7824ULL, 0x008fe200078e00ffULL, 0x0000000011077212ULL, 0x000fc400078e3cffULL,
0x0000000904097210ULL, 0x000fe20007f1e0ffULL, 0x00000008110c7824ULL, 0x002fe200078e00ffULL,
0xfffffff80b0a7812ULL, 0x000fe400078ee206ULL, 0x00005e0009087a11ULL, 0x000fe200078c48ffULL,
0x000000ffff0e7224ULL, 0x004fe200000e06ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x00000008130f7824ULL, 0x000fe200078e00ffULL, 0x000000101100720cULL, 0x000fe20003f86070ULL,
0x000000011c117824ULL, 0x000fe200078e0211ULL, 0x00005f0009077a11ULL, 0x000fc400030f4c0eULL,
0x0000000821067210ULL, 0x000fe40007fde0ffULL, 0x0000003c1f1f7810ULL, 0x000fe40007ffe0ffULL,
0x000000101300720cULL, 0x080fe20003f66070ULL, 0x000000ffff077224ULL, 0x000fe200030e0607ULL,
0x0000001104117210ULL, 0x000fe40007fde0ffULL, 0x000000101b00720cULL, 0x080fe40003f46070ULL,
0x000000101d00720cULL, 0x080fe20003f26070ULL, 0x000000ffff147224ULL, 0x000fe200030e06ffULL,
0x000000101f00720cULL, 0x000fe20003f06070ULL, 0x000000081b107824ULL, 0x040fe200078e00ffULL,
0x000000001b097212ULL, 0x080fe200078e3cffULL, 0x000000011c1b7824ULL, 0x040fe200078e021bULL,
0x0000000013087212ULL, 0x000fe200078e3cffULL, 0x000000011c137824ULL, 0x000fe200078e0213ULL,
0x00005e00110d7a11ULL, 0x000fc400078c48ffULL, 0xfffffff810107812ULL, 0x000fe400078ee209ULL,
0xfffffff80f0e7812ULL, 0x000fe200078ee208ULL, 0x000000011c0f7824ULL, 0x000fe200078e021fULL,
0x00005f0011097a11ULL, 0x000fe200030f4c14ULL, 0x0000001010117824ULL, 0x100fe200078e0205ULL,
0x0000000d21087210ULL, 0x000fe20007fde0ffULL, 0x000000100c0d7824ULL, 0x000fe200078e0205ULL,
0x000000001d0b7212ULL, 0x080fe200078e3cffULL, 0x000000011c1d7824ULL, 0x000fe200078e021dULL,
0x000000001f007212ULL, 0x040fe200078e3cffULL, 0x000000ffff097224ULL, 0x000fe200030e0609ULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x000000100a0b7824ULL, 0x000fe200078e0205ULL,
0x0000001304137210ULL, 0x000fe20007fde0ffULL, 0x000000081f1f7824ULL, 0x000fc600078e00ffULL,
0x00000000060b7faeULL, 0x0003e2000e901c46ULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e0013147a11ULL, 0x040fe400078c48ffULL, 0x0000001b041b7210ULL, 0x000fe20007fbe0ffULL,
0x00000000080d7faeULL, 0x0005e2000e101c46ULL, 0x00005f00130a7a11ULL, 0x000fe200030f4c16ULL,
0x0000001012137824ULL, 0x100fe200078e0205ULL, 0x0000001d041d7210ULL, 0x040fe40007f9e0ffULL,
0x0000000f040c7210ULL, 0x000fe20007fde0ffULL, 0x000000100e0f7824ULL, 0x000fe200078e0205ULL,
0xfffffff81f007812ULL, 0x000fe200078ee200ULL, 0x000000ffff047224ULL, 0x000fe200028e06ffULL,
0x00005e001b0e7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff077224ULL, 0x002fc400030e06ffULL,
0x0000001000157824ULL, 0x000fe200078e0205ULL, 0x00005f001b0b7a11ULL, 0x000fe200028f4c04ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x0000001421047210ULL, 0x000fe40007fbe0ffULL,
0x00005e001d087a11ULL, 0x004fc600078848ffULL, 0x000000ffff057224ULL, 0x000fe200028e060aULL,
0x00005e000c0a7a11ULL, 0x040fe400078c48ffULL, 0x0000000e21067210ULL, 0x000fe40007fbe0ffULL,
0x00005f001d097a11ULL, 0x000fe200020f4c00ULL, 0x00000000040f7faeULL, 0x0003e2000d901c46ULL,
0x00005f000c007a11ULL, 0x000fe200030f4c07ULL, 0x000000ffff077224ULL, 0x000fe200028e060bULL,
0x0000000821087210ULL, 0x040fe40007f9e0ffULL, 0x0000000a210a7210ULL, 0x000fc40007fbe0ffULL,
0x0000000006117faeULL, 0x0003e2000d101c46ULL, 0x000000ffff097224ULL, 0x000fe400020e0609ULL,
0x000000ffff0b7224ULL, 0x000fc600028e0600ULL, 0x0000000008137faeULL, 0x0003e8000c901c46ULL,
0x000000000a157faeULL, 0x0003e2000c101c46ULL, 0x00000d4000007947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x002fc80000011600ULL, 0x0000000c07157810ULL, 0x040fe40007ffe0ffULL,
0x0000001c07217810ULL, 0x000fe40007ffe0ffULL, 0x0000000015097212ULL, 0x0c0fe200078e3cffULL,
0x00000008150c7824ULL, 0x000fe200078e00ffULL, 0x0000000807117810ULL, 0x040fe20007ffe0ffULL,
0x000000011c157824ULL, 0x000fe200078e0215ULL, 0x0000001007197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80c177812ULL, 0x000fe200078ee209ULL, 0x00000008210c7824ULL, 0x040fe200078e00ffULL,
0x0000000021097212ULL, 0x000fe200078e3cffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0x0000002c07397810ULL, 0x000fe20007ffe0ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x00000004070d7810ULL, 0x040fe20007ffe0ffULL, 0x000000011c217824ULL, 0x000fe200078e0221ULL,
0x00000018071f7810ULL, 0x000fc40007ffe0ffULL, 0x0000002007257810ULL, 0x000fe20007ffe0ffULL,
0x000000080d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c317812ULL, 0x000fe200078ee209ULL,
0x00000008390c7824ULL, 0x000fe200078e00ffULL, 0x0000000011087212ULL, 0x080fe200078e3cffULL,
0x000000081f2b7824ULL, 0x000fe200078e00ffULL, 0x00000000190a7212ULL, 0x080fe200078e3cffULL,
0x0000000825337824ULL, 0x000fe200078e00ffULL, 0x00000014071d7810ULL, 0x000fe20007ffe0ffULL,
0x000000011c197824ULL, 0x040fe200078e0219ULL, 0x0000000039097212ULL, 0x080fe200078e3cffULL,
0x000000011c117824ULL, 0x040fe200078e0211ULL, 0x000000000d067212ULL, 0x000fe200078e3cffULL,
0x000000081d237824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x000000011c0d7824ULL, 0x040fe200078e020dULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x000000011c397824ULL, 0x000fe200078e0239ULL, 0x0000002807297810ULL, 0x000fc40007ffe0ffULL,
0x00000030073d7810ULL, 0x000fe40007ffe0ffULL, 0x000000001f087212ULL, 0x080fe200078e3cffULL,
0x0000000829377824ULL, 0x000fe200078e00ffULL, 0x00000000250a7212ULL, 0x080fe200078e3cffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c3b7812ULL, 0x000fe200078ee209ULL,
0x000000011c097824ULL, 0x040fe200078e0207ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee206ULL,
0x000000011c257824ULL, 0x040fe200078e0225ULL, 0x0000002407277810ULL, 0x000fe20007ffe0ffULL,
0x000000011c1f7824ULL, 0x040fe200078e021fULL, 0x000000001d067212ULL, 0x000fe200078e3cffULL,
0x000000011c1d7824ULL, 0x000fe200078e021dULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee208ULL,
0x0000000827357824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fc400078ee20aULL,
0x0000000029087212ULL, 0x080fe200078e3cffULL, 0x000000011c297824ULL, 0x040fe200078e0229ULL,
0x000000003d0a7212ULL, 0x000fe200078e3cffULL, 0x000000011c3d7824ULL, 0x000fe200078e023dULL,
0xfffffff823237812ULL, 0x000fe400078ee206ULL, 0x00000007070b7812ULL, 0x040fe400078e4800ULL,
0x0000003407417810ULL, 0x040fe40007ffe0ffULL, 0x0000003807457810ULL, 0x000fc40007ffe0ffULL,
0x0000003c07497810ULL, 0x000fe20007ffe0ffULL, 0x00000008410c7824ULL, 0x000fe200078e00ffULL,
0x0000000904097210ULL, 0x000fe20007f1e0ffULL, 0x000000011c477824ULL, 0x040fe200078e0245ULL,
0x0000000027067212ULL, 0x000fe200078e3cffULL, 0x000000011c4b7824ULL, 0x040fe200078e0249ULL,
0xfffffff837377812ULL, 0x000fe200078ee208ULL, 0x000000011c437824ULL, 0x040fe200078e0241ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20aULL, 0x000000011c277824ULL, 0x000fe200078e0227ULL,
0x0ffffff80b0b7812ULL, 0x000fc400078ef800ULL, 0x0000000041077212ULL, 0x080fe400078e3cffULL,
0x0000000045087212ULL, 0x0c0fe200078e3cffULL, 0x0000000845457824ULL, 0x000fe200078e00ffULL,
0x00000000490a7212ULL, 0x000fe200078e3cffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0xfffffff835357812ULL, 0x000fe200078ee206ULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0x0000001904197210ULL, 0x000fe40007f7e0ffULL, 0x00005e0009067a11ULL, 0x000fc400078048ffULL,
0x0000001104117210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff147224ULL, 0x000fe200018e06ffULL,
0x00005f0009007a11ULL, 0x000fe400000f4c00ULL, 0x0000000d040d7210ULL, 0x040fe40007f1e0ffULL,
0x0000001504157210ULL, 0x000fe40007f5e0ffULL, 0x00005e0019167a11ULL, 0x000fe400078648ffULL,
0xfffffff80c417812ULL, 0x000fe200078ee207ULL, 0x000000ffff0c7224ULL, 0x000fe200008e06ffULL,
0xfffffff845457812ULL, 0x000fe200078ee208ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005f0019197a11ULL, 0x000fe200018f4c14ULL, 0x000000ffff107224ULL, 0x000fe200010e06ffULL,
0xfffffff849497812ULL, 0x000fc400078ee20aULL, 0x00005e00110e7a11ULL, 0x000fe400078248ffULL,
0x0000002504257210ULL, 0x000fe40007f7e0ffULL, 0x00005e000d0a7a11ULL, 0x000fe400078048ffULL,
0x00005e0015127a11ULL, 0x000fe200078448ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x00005f0011117a11ULL, 0x000fe400008f4c0cULL, 0x00005f000d0d7a11ULL, 0x000fc400000f4c08ULL,
0x00005f0015157a11ULL, 0x000fe400010f4c10ULL, 0x0000001f041f7210ULL, 0x040fe40007f3e0ffULL,
0x0000001d041d7210ULL, 0x040fe40007f1e0ffULL, 0x0000002104217210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078648ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005e001f147a11ULL, 0x000fe200078248ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f0025227a11ULL, 0x000fc400018f4c22ULL,
0x0000002704277210ULL, 0x000fe40007f7e0ffULL, 0x00005e001d107a11ULL, 0x000fe400078048ffULL,
0x00005e00211e7a11ULL, 0x000fe400078448ffULL, 0x00005f001f1c7a11ULL, 0x000fe200008f4c0cULL,
0x000000ffff0c7224ULL, 0x000fe200018e06ffULL, 0x00005f001d1a7a11ULL, 0x000fe400000f4c08ULL,
0x00005f0021207a11ULL, 0x000fc400010f4c18ULL, 0x0000003904397210ULL, 0x040fe40007f1e0ffULL,
0x0000003d043d7210ULL, 0x040fe40007f3e0ffULL, 0x00005e0027187a11ULL, 0x000fe400078c48ffULL,
0x0000002904077210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200008e06ffULL,
0x000020007d087811ULL, 0x000fe400078e70ffULL, 0x00005f0027267a11ULL, 0x000fe200030f4c0cULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000004304437210ULL, 0x040fe20007f7e0ffULL,
0x000000100b1d7824ULL, 0x100fe200078e0208ULL, 0x0000004704477210ULL, 0x040fe20007f9e0ffULL,
0x000000100f1f7824ULL, 0x100fe200078e0208ULL, 0x0000004b044b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff047224ULL, 0x000fe200010e06ffULL, 0x00005e00392a7a11ULL, 0x000fe200078048ffULL,
0x0000001013217824ULL, 0x100fe200078e0208ULL, 0x00005e003d307a11ULL, 0x000fe200078248ffULL,
0x0000001017257824ULL, 0x100fe200078e0208ULL, 0x00005e0007287a11ULL, 0x000fe200078448ffULL,
0x000000101b277824ULL, 0x000fe200078e0208ULL, 0x00005f0039397a11ULL, 0x000fe200000f4c0cULL,
0x0000001023297824ULL, 0x000fe200078e0208ULL, 0x00005f003d2c7a11ULL, 0x000fe200008f4c2cULL,
0x000000102b2b7824ULL, 0x000fe200078e0208ULL, 0x00005f00071b7a11ULL, 0x000fe200010f4c04ULL,
0x0000001031317824ULL, 0x100fe200078e0208ULL, 0x0000007005237812ULL, 0x000fe200078ec0ffULL,
0x0000001033337824ULL, 0x100fe200078e0208ULL, 0x00005e0043327a11ULL, 0x000fe200078248ffULL,
0x0000001035357824ULL, 0x100fe200078e0208ULL, 0x00005e0047347a11ULL, 0x000fe200078448ffULL,
0x0000001037377824ULL, 0x100fe200078e0208ULL, 0x0000000623047210ULL, 0x000fe20007f1e0ffULL,
0x000000103b3b7824ULL, 0x000fc400078e0208ULL, 0x000000103f3f7824ULL, 0x100fe400078e0208ULL,
0x0000001041417824ULL, 0x100fe400078e0208ULL, 0x0000001045457824ULL, 0x100fe400078e0208ULL,
0x0000001049497824ULL, 0x000fe400078e0208ULL, 0x000000ffff087224ULL, 0x000fe200018e06ffULL,
0x00005e004b387a11ULL, 0x000fe200078648ffULL, 0x000000ffff0c7224ULL, 0x000fc400020e06ffULL,
0x000000ffff367224ULL, 0x000fe200028e06ffULL, 0x00005f0043437a11ULL, 0x000fe200008f4c08ULL,
0x000000ffff057224ULL, 0x000fe200000e0600ULL, 0x00005f0047477a11ULL, 0x000fe400010f4c0cULL,
0x0000000a23067210ULL, 0x000fe40007f3e0ffULL, 0x00005f004b367a11ULL, 0x000fe200018f4c36ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000b901c46ULL,
0x0000000e23087210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200008e060dULL,
0x00000012230a7210ULL, 0x000fc40007f7e0ffULL, 0x00000016230c7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200010e0611ULL, 0x00000010230e7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0615ULL, 0x0000001423107210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e0619ULL, 0x0000001e23127210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200020e061aULL, 0x0000002423147210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e061cULL, 0x0000001823167210ULL, 0x040fe20007f7e0ffULL,
0x00000000061f7faeULL, 0x0005e2000b901c46ULL, 0x0000002823187210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e0620ULL, 0x0000002a231a7210ULL, 0x040fe20007f9e0ffULL,
0x0000000008217faeULL, 0x0007e2000b901c46ULL, 0x00000030231c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200010e0622ULL, 0x00000032231e7210ULL, 0x040fe20007f3e0ffULL,
0x000000000a257faeULL, 0x0009e2000b901c46ULL, 0x0000003423207210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200018e0626ULL, 0x0000003823227210ULL, 0x000fe20007f7e0ffULL,
0x000000000c277faeULL, 0x0009e2000b901c46ULL, 0x000000ffff197224ULL, 0x000fc400028e061bULL,
0x000000ffff1b7224ULL, 0x000fe200020e0639ULL, 0x000000000e297faeULL, 0x0009e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x002fe400000e062cULL, 0x000000ffff1f7224ULL, 0x004fe200008e0643ULL,
0x00000000102b7faeULL, 0x0009e2000b901c46ULL, 0x000000ffff217224ULL, 0x008fe400010e0647ULL,
0x000000ffff237224ULL, 0x000fe200018e0636ULL, 0x0000000012317faeULL, 0x0009e8000b901c46ULL,
0x0000000014337faeULL, 0x0009e8000b901c46ULL, 0x0000000016357faeULL, 0x0009e8000b901c46ULL,
0x0000000018377faeULL, 0x0009e8000b901c46ULL, 0x000000001a3b7faeULL, 0x0009e8000b901c46ULL,
0x000000001c3f7faeULL, 0x0009e8000b901c46ULL, 0x000000001e417faeULL, 0x0009e8000b901c46ULL,
0x0000000020457faeULL, 0x0009e8000b901c46ULL, 0x0000000022497faeULL, 0x0009e4000b901c46ULL,
0x01c60400ff057984ULL, 0x002e680000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x002fc60007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff007424ULL, 0x000fc800078e00ffULL, 0x0000000000047305ULL, 0x0002a4000021f000ULL,
0x3fa0000000007823ULL, 0x002fe200000100ffULL, 0x000000040000735dULL, 0x004fe20003800000ULL,
0x01c60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000797e00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000064002d2d7a24ULL, 0x000fe200078e02ffULL, 0x0001c6887d027811ULL, 0x040fe200078e18ffULL,
0x000000207d047824ULL, 0x000fe200078e00ffULL, 0xffffffff79037810ULL, 0x000fe40007ffe0ffULL,
0x000001007e057824ULL, 0x008fe200078e0278ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000057c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x000000017e067810ULL, 0x000fe40007ffe0ffULL, 0x0000004005087812ULL, 0x000fe400078ec0ffULL,
0x000000790600720cULL, 0x000fe20003f06070ULL, 0x000000912e067224ULL, 0x000fe400078e02ffULL,
0x000000012f127824ULL, 0x010fd400078e0208ULL, 0x00000d8000008947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x002fe40000011600ULL, 0x0000000700a17812ULL, 0x000fe400078ec0ffULL,
0x0000000c070d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000407097810ULL, 0x000fe40007ffe0ffULL,
0x000000000d9c7212ULL, 0x0c0fe200078e3cffULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0x00000008070b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008090f7824ULL, 0x040fe200078e00ffULL,
0x00000000099e7212ULL, 0x040fe200078e3cffULL, 0x00000001091f7824ULL, 0x000fe200078e0212ULL,
0xfffffff8119c7812ULL, 0x000fe200078ee29cULL, 0x000000080b087824ULL, 0x000fe200078e00ffULL,
0x0000001407117810ULL, 0x000fe20007ffe0ffULL, 0x000000010b217824ULL, 0x000fe200078e0212ULL,
0x0000002407197810ULL, 0x000fc40007ffe0ffULL, 0x00000000119a7212ULL, 0x0c0fe200078e3cffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff80f9e7812ULL, 0x000fe200078ee29eULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x000000000b9d7212ULL, 0x000fe400078e3cffULL,
0x00000010070f7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8159a7812ULL, 0x000fe400078ee29aULL,
0x0000001c07157810ULL, 0x000fc40007ffe0ffULL, 0x0000000019967212ULL, 0x080fe400078e3cffULL,
0xfffffff8089d7812ULL, 0x000fe200078ee29dULL, 0x000000080f087824ULL, 0x040fe200078e00ffULL,
0x000000000f9b7212ULL, 0x080fe200078e3cffULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000002007177810ULL, 0x000fe40007ffe0ffULL, 0x0000000015987212ULL, 0x000fe400078e3cffULL,
0xfffffff81d967812ULL, 0x000fe200078ee296ULL, 0x00000001071d7824ULL, 0x040fe200078e0212ULL,
0x0000001807137810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8089b7812ULL, 0x000fe200078ee29bULL,
0x0000000817087824ULL, 0x000fe200078e00ffULL, 0xfffffff81b987812ULL, 0x000fe200078ee298ULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0x0000000017977212ULL, 0x080fe400078e3cffULL,
0x00000028071b7810ULL, 0x000fe40007ffe0ffULL, 0x0000001d061d7210ULL, 0x000fe40007f3e0ffULL,
0x0000000013997212ULL, 0x000fc400078e3cffULL, 0x0000001f061f7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0xfffffff808977812ULL, 0x000fe200078ee297ULL,
0x000000081b087824ULL, 0x040fe200078e00ffULL, 0xfffffff80a997812ULL, 0x000fe200078ee299ULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x000000001b957212ULL, 0x000fe400078e3cffULL,
0x0000002106217210ULL, 0x000fe40007f7e0ffULL, 0x00005e001dd27a11ULL, 0x000fc400078248ffULL,
0x00005e001fd07a11ULL, 0x000fe400078448ffULL, 0xfffffff808957812ULL, 0x000fe200078ee295ULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005f001dd37a11ULL, 0x000fe200008f4c0cULL,
0x000000010d1d7824ULL, 0x000fe200078e0212ULL, 0x00005e0021ce7a11ULL, 0x000fe400078648ffULL,
0x00005f001fd17a11ULL, 0x000fe200010f4c0aULL, 0x000000010f1f7824ULL, 0x000fe200078e0212ULL,
0x00005f0021cf7a11ULL, 0x000fe200018f4c08ULL, 0x0000000111217824ULL, 0x100fe200078e0212ULL,
0x0000001d06087210ULL, 0x040fe20007f3e0ffULL, 0x00000001131d7824ULL, 0x000fe200078e0212ULL,
0x0000001f061f7210ULL, 0x000fc40007f5e0ffULL, 0x0000002106217210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff237224ULL, 0x000fe200008e06ffULL, 0x00005e0008cc7a11ULL, 0x040fe200078248ffULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e001fca7a11ULL, 0x000fe200078448ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00005f0008cd7a11ULL, 0x000fe400008f4c23ULL,
0x0000001d06087210ULL, 0x000fe20007f3e0ffULL, 0x00000001151d7824ULL, 0x000fe200078e0212ULL,
0x00005f001fcb7a11ULL, 0x000fe200010f4c0cULL, 0x00000001171f7824ULL, 0x000fe200078e0212ULL,
0x00005e0021c87a11ULL, 0x000fe200078648ffULL, 0x000000ffff237224ULL, 0x000fe200008e06ffULL,
0x00005e0008c67a11ULL, 0x000fc400078248ffULL, 0x00005f0021c97a11ULL, 0x000fe200018f4c0aULL,
0x0000000119217824ULL, 0x000fe200078e0212ULL, 0x0000001d061d7210ULL, 0x040fe40007f5e0ffULL,
0x0000001f061f7210ULL, 0x000fe40007f7e0ffULL, 0x00005f0008c77a11ULL, 0x000fe200008f4c23ULL,
0x000000ffff0c7224ULL, 0x000fe200010e06ffULL, 0x00005e001dc47a11ULL, 0x000fe200078248ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0x00005e001fc27a11ULL, 0x000fc400078448ffULL,
0x0000002106217210ULL, 0x000fe40007f9e0ffULL, 0x00005f001dc57a11ULL, 0x000fe400008f4c0cULL,
0x00005f001fc37a11ULL, 0x000fe200010f4c08ULL, 0x000000017c087824ULL, 0x000fe200078e0a05ULL,
0x00000000070c7212ULL, 0x040fe200078e3cffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x00000030071f7810ULL, 0x000fe40007ffe0ffULL, 0x00005e0021be7a11ULL, 0x000fc400078648ffULL,
0x0000002c071d7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f257824ULL, 0x100fe200078e0212ULL,
0x000000070c9f7812ULL, 0x000fe400078ec0ffULL, 0x000000080700720cULL, 0x080fe20003f46070ULL,
0x000000011d237824ULL, 0x000fe200078e0212ULL, 0x00005f0021bf7a11ULL, 0x000fe200018f4c0aULL,
0x000000011b217824ULL, 0x000fe200078e0212ULL, 0x000000080900720cULL, 0x000fe40003f26070ULL,
0x000040007d0a7811ULL, 0x000fc400078e70ffULL, 0x00000008a1337812ULL, 0x000fe400078efcffULL,
0x0ffffff89f9f7812ULL, 0x000fe200078ef800ULL, 0x000000109e277824ULL, 0x100fe200078e020aULL,
0x00000025060c7210ULL, 0x000fe20007f7e0ffULL, 0x000000109c357824ULL, 0x100fe200078e020aULL,
0x0000002106107210ULL, 0x040fe20007f9e0ffULL, 0x000000109f257824ULL, 0x000fe200078e020aULL,
0x00000023060e7210ULL, 0x000fe20007fbe0ffULL, 0x0000001033207825ULL, 0x000fe200078e00d2ULL,
0x000000001d947212ULL, 0x000fc400078e3cffULL, 0x000000001f937212ULL, 0x000fe200078e3cffULL,
0x0000001033227825ULL, 0x000fe200078e00d0ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020257faeULL, 0x0003e2000d101c46ULL, 0x000000080d00720cULL, 0x080fe40003f46070ULL,
0x000000ffff297224ULL, 0x000fe200018e06ffULL, 0x00005e000cb87a11ULL, 0x000fe200078648ffULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x00005e0010bc7a11ULL, 0x000fe200078848ffULL,
0x0000000022277faeULL, 0x0005e2000c901c46ULL, 0x000000080b00720cULL, 0x080fe20003f26070ULL,
0x000000ffff2b7224ULL, 0x000fe200028e06ffULL, 0x00005f000cb97a11ULL, 0x000fe200018f4c29ULL,
0x000000109b377824ULL, 0x100fe200078e020aULL, 0x00005f0010bd7a11ULL, 0x000fe200020f4c31ULL,
0x000000109d317824ULL, 0x000fe200078e020aULL, 0x000000080f00720cULL, 0x080fe20003f66070ULL,
0x0000001033247825ULL, 0x002fe200078e00ccULL, 0x000000081100720cULL, 0x000fc40003f86070ULL,
0x00005e000eba7a11ULL, 0x040fe200078a48ffULL, 0x0000001033227825ULL, 0x004fe200078e00ceULL,
0x0000003407217810ULL, 0x000fe40007ffe0ffULL, 0x00005f000ebb7a11ULL, 0x000fe200028f4c2bULL,
0x0000001033267825ULL, 0x000fe200078e00caULL, 0x000000081300720cULL, 0x080fe20003fa6070ULL,
0x0000000022317faeULL, 0x0003e2000c901c46ULL, 0x000000081500720cULL, 0x000fe20003f26070ULL,
0x000000109a397824ULL, 0x000fe200078e020aULL, 0x0000000021927212ULL, 0x000fe200078e3cffULL,
0x0000001033287825ULL, 0x000fe200078e00c8ULL, 0x0000000024357faeULL, 0x0005e2000d101c46ULL,
0x000000081700720cULL, 0x000fc40003f46070ULL, 0x00000010993b7824ULL, 0x000fe200078e020aULL,
0x0000000026377faeULL, 0x0007e2000d901c46ULL, 0x000000081900720cULL, 0x080fe20003f66070ULL,
0x00000010332a7825ULL, 0x000fe200078e00c6ULL, 0x0000003807237810ULL, 0x002fe20007ffe0ffULL,
0x0000000028397faeULL, 0x0003e2000e101c46ULL, 0x000000081b00720cULL, 0x000fe20003f86070ULL,
0x00000010983d7824ULL, 0x100fe200078e020aULL, 0x0000000023917212ULL, 0x000fe200078e3cffULL,
0x000000002a3b7faeULL, 0x0009e2000e901c46ULL, 0x00000010973f7824ULL, 0x100fe200078e020aULL,
0x0000003c07257810ULL, 0x004fe20007ffe0ffULL, 0x0000001096357824ULL, 0x000fe200078e020aULL,
0x000000082300720cULL, 0x000fe20003fa6070ULL, 0x0000001033267825ULL, 0x008fe200078e00c4ULL,
0x0000000025907212ULL, 0x000fc600078e3cffULL, 0x0000001033287825ULL, 0x002fe200078e00c2ULL,
0x00000000263d7faeULL, 0x0003e2000c901c46ULL, 0x000000081d00720cULL, 0x080fe40003f26070ULL,
0x00000010332a7825ULL, 0x010fe200078e00beULL, 0x00000000283f7faeULL, 0x0005e2000d101c46ULL,
0x000000082100720cULL, 0x080fe40003f46070ULL, 0x0000001095377824ULL, 0x000fe200078e020aULL,
0x000000002a357faeULL, 0x0007e2000d901c46ULL, 0x0000001033307825ULL, 0x000fe200078e00bcULL,
0x000000081f00720cULL, 0x000fc60003f66070ULL, 0x0000000121397824ULL, 0x100fe200078e0212ULL,
0x0000000030377faeULL, 0x0009e2000e101c46ULL, 0x0000000123277824ULL, 0x002fc600078e0212ULL,
0x0000003906397210ULL, 0x000fe20007f9e0ffULL, 0x000000081d2b7824ULL, 0x008fc600078e00ffULL,
0x00005e0039b47a11ULL, 0x000fe200078c48ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x000000082500720cULL, 0x000fe40003f86070ULL, 0xfffffff82b947812ULL, 0x000fe200078ee294ULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0x00005f0039b57a11ULL, 0x000fe200030f4c0cULL,
0x000000081f0c7824ULL, 0x000fe200078e00ffULL, 0x0000002706087210ULL, 0x000fe20007fde0ffULL,
0x0000000125277824ULL, 0x000fe200078e0212ULL, 0xfffffff82b907812ULL, 0x000fe200078ee290ULL,
0x0000001094357824ULL, 0x000fe200078e020aULL, 0xfffffff80c937812ULL, 0x000fe200078ee293ULL,
0x000000ffff297224ULL, 0x004fe200030e06ffULL, 0x00005e0008b07a11ULL, 0x000fe200078c48ffULL,
0x00000010332a7825ULL, 0x000fc600078e00b4ULL, 0x00005f0008b17a11ULL, 0x000fe200030f4c29ULL,
0x0000000821297824ULL, 0x000fe200078e00ffULL, 0x0000002706277210ULL, 0x000fe20007fde0ffULL,
0x0000000823087824ULL, 0x000fe400078e00ffULL, 0x0000001093377824ULL, 0x010fe200078e020aULL,
0xfffffff829927812ULL, 0x000fe200078ee292ULL, 0x000000ffff067224ULL, 0x000fe200030e06ffULL,
0x00005e0027ae7a11ULL, 0x000fe200078c48ffULL, 0x0000001033287825ULL, 0x000fe200078e00b8ULL,
0xfffffff808917812ULL, 0x000fc400078ee291ULL, 0x00005f0027af7a11ULL, 0x000fe200030f4c06ULL,
0x0000001033267825ULL, 0x000fc800078e00baULL, 0x0000001092397824ULL, 0x100fe200078e020aULL,
0x0000000026357faeULL, 0x0003e2000c901c46ULL, 0x00000010913b7824ULL, 0x000fe400078e020aULL,
0x0000001033307825ULL, 0x040fe200078e00b0ULL, 0x0000000028377faeULL, 0x0003e6000d901c46ULL,
0x00000010903d7824ULL, 0x000fe200078e020aULL, 0x000000002a397faeULL, 0x0003e2000d101c46ULL,
0x0000001033327825ULL, 0x000fc600078e00aeULL, 0x00000000303b7faeULL, 0x0003e8000e901c46ULL,
0x00000000323d7faeULL, 0x0003e2000e101c46ULL, 0x00000c6000007947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x002fe40000011600ULL, 0x0000000700a17812ULL, 0x000fe400078ec0ffULL,
0x0000000c070d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000107257824ULL, 0x040fe200078e0212ULL,
0x0000000407097810ULL, 0x000fc40007ffe0ffULL, 0x000000000d9c7212ULL, 0x0c0fe200078e3cffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0x0000002407197810ULL, 0x000fe20007ffe0ffULL,
0x00000008090f7824ULL, 0x000fe200078e00ffULL, 0x00000008070b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109277824ULL, 0x000fe200078e0212ULL, 0xfffffff8119c7812ULL, 0x000fe200078ee29cULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x0000001407117810ULL, 0x000fe20007ffe0ffULL,
0x000000080b087824ULL, 0x000fe200078e00ffULL, 0x00000000099e7212ULL, 0x000fc400078e3cffULL,
0x00000000119a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000811157824ULL, 0x000fe200078e00ffULL,
0x0000000019967212ULL, 0x080fe200078e3cffULL, 0x00000001112b7824ULL, 0x000fe200078e0212ULL,
0xfffffff80f9e7812ULL, 0x000fe400078ee29eULL, 0x000000000b9d7212ULL, 0x000fe400078e3cffULL,
0x00000010070f7810ULL, 0x040fe40007ffe0ffULL, 0x0000001807137810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8159a7812ULL, 0x000fe400078ee29aULL, 0x0000001c07157810ULL, 0x000fe20007ffe0ffULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d967812ULL, 0x000fe400078ee296ULL,
0x0000002c071d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8089d7812ULL, 0x000fe200078ee29dULL, 0x000000080f087824ULL, 0x040fe200078e00ffULL,
0x000000000f9b7212ULL, 0x080fe200078e3cffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x0000000013997212ULL, 0x000fc400078e3cffULL, 0x0000002007177810ULL, 0x040fe40007ffe0ffULL,
0x00000030071f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000015987212ULL, 0x080fe400078e3cffULL,
0x000000001d947212ULL, 0x000fe400078e3cffULL, 0xfffffff8089b7812ULL, 0x000fe200078ee29bULL,
0x0000000817087824ULL, 0x000fe200078e00ffULL, 0xfffffff80a997812ULL, 0x000fe200078ee299ULL,
0x000000081f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b987812ULL, 0x000fc400078ee298ULL,
0x0000000017977212ULL, 0x080fe400078e3cffULL, 0x00000028071b7810ULL, 0x000fe40007ffe0ffULL,
0x000000001f937212ULL, 0x000fe400078e3cffULL, 0x0000002706277210ULL, 0x000fe40007f5e0ffULL,
0xfffffff821947812ULL, 0x000fe400078ee294ULL, 0x0000003407217810ULL, 0x000fc40007ffe0ffULL,
0xfffffff808977812ULL, 0x000fe200078ee297ULL, 0x000000081b087824ULL, 0x040fe200078e00ffULL,
0xfffffff80a937812ULL, 0x000fe200078ee293ULL, 0x000000ffff0a7224ULL, 0x000fe200010e06ffULL,
0x000000001b957212ULL, 0x080fe200078e3cffULL, 0x0000000821297824ULL, 0x040fe200078e00ffULL,
0x0000002506257210ULL, 0x000fe20007f3e0ffULL, 0x0000000121317824ULL, 0x000fe200078e0212ULL,
0x00005e0027d07a11ULL, 0x000fe400078448ffULL, 0x0000000021927212ULL, 0x000fc400078e3cffULL,
0xfffffff808957812ULL, 0x000fe200078ee295ULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005f0027d17a11ULL, 0x000fe200010f4c0aULL, 0x000000010d277824ULL, 0x000fe200078e0212ULL,
0x0000003807237810ULL, 0x000fe40007ffe0ffULL, 0x00005e0025d27a11ULL, 0x000fe400078248ffULL,
0xfffffff829927812ULL, 0x000fe200078ee292ULL, 0x000000010f297824ULL, 0x000fe200078e0212ULL,
0x00005f0025d37a11ULL, 0x000fe200008f4c08ULL, 0x00000008230c7824ULL, 0x000fe200078e00ffULL,
0x0000002706277210ULL, 0x040fe20007f7e0ffULL, 0x000000010b257824ULL, 0x100fe200078e0212ULL,
0x0000000023917212ULL, 0x040fe200078e3cffULL, 0x0000000123337824ULL, 0x000fe200078e0212ULL,
0x0000002906297210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0xfffffff80c917812ULL, 0x000fc400078ee291ULL, 0x0000002506257210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200020e06ffULL, 0x00005e0027cc7a11ULL, 0x000fe400078648ffULL,
0x0000002b062b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x00005e0029ca7a11ULL, 0x000fe400078848ffULL, 0x00005f0027cd7a11ULL, 0x000fe200018f4c0aULL,
0x0000000115277824ULL, 0x000fe200078e0212ULL, 0x00005e0025ce7a11ULL, 0x000fe200078448ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005f0029cb7a11ULL, 0x000fe200020f4c0cULL,
0x0000000117297824ULL, 0x000fe200078e0212ULL, 0x00005e002bc87a11ULL, 0x000fc400078248ffULL,
0x00005f0025cf7a11ULL, 0x000fe200010f4c08ULL, 0x0000000113257824ULL, 0x000fe200078e0212ULL,
0x0000002706277210ULL, 0x040fe40007f7e0ffULL, 0x00005f002bc97a11ULL, 0x000fe200008f4c0eULL,
0x00000001192b7824ULL, 0x000fe200078e0212ULL, 0x0000002906297210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x0000002506257210ULL, 0x040fe40007f5e0ffULL,
0x00005e0027c47a11ULL, 0x000fe200078648ffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x0000002b062b7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x00005e0029c27a11ULL, 0x000fc400078848ffULL, 0x00005f0027c57a11ULL, 0x000fe200018f4c0aULL,
0x000000011b277824ULL, 0x000fe200078e0212ULL, 0x00005e0025c67a11ULL, 0x000fe200078448ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e06ffULL, 0x00005f0029c37a11ULL, 0x000fe200020f4c0cULL,
0x000000011d297824ULL, 0x000fe200078e0212ULL, 0x00005e002bbe7a11ULL, 0x000fe400078248ffULL,
0x00005f0025c77a11ULL, 0x000fe400010f4c08ULL, 0x0000002706277210ULL, 0x000fc40007f7e0ffULL,
0x0000003c07257810ULL, 0x000fe40007ffe0ffULL, 0x00005f002bbf7a11ULL, 0x000fe200008f4c0eULL,
0x000000011f2b7824ULL, 0x100fe200078e0212ULL, 0x0000000007087212ULL, 0x000fe200078e3cffULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x0000002906297210ULL, 0x000fe20007f5e0ffULL,
0x0000000125357824ULL, 0x000fe200078e0212ULL, 0x00005e0027bc7a11ULL, 0x000fe400078c48ffULL,
0x00000007089f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200010e06ffULL,
0x0000002b062b7210ULL, 0x000fc40007f3e0ffULL, 0x00005e0029ba7a11ULL, 0x000fe400078448ffULL,
0x0000003106317210ULL, 0x040fe40007f7e0ffULL, 0x0000003306337210ULL, 0x040fe40007f9e0ffULL,
0x00005f0027bd7a11ULL, 0x000fe200030f4c0aULL, 0x0000000825277824ULL, 0x040fe200078e00ffULL,
0x0000003506357210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x0000000025907212ULL, 0x000fe200078e3cffULL, 0x000000ffff0c7224ULL, 0x000fe200020e06ffULL,
0x000040007d067811ULL, 0x000fe200078e70ffULL, 0x000000ffff0e7224ULL, 0x000fe200028e06ffULL,
0x0ffffff89f9f7812ULL, 0x000fc400078ef800ULL, 0x00005f0029bb7a11ULL, 0x000fe200010f4c08ULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00000008a1377812ULL, 0x000fe200078efcffULL,
0x000000109f397824ULL, 0x100fe200078e0206ULL, 0x00005e002bb87a11ULL, 0x000fe200078248ffULL,
0x000000109e3b7824ULL, 0x000fe200078e0206ULL, 0x00005e0031b47a11ULL, 0x000fe200078448ffULL,
0x0000001037287825ULL, 0x000fe200078e00d0ULL, 0xfffffff827907812ULL, 0x000fe400078ee290ULL,
0x00005e0033b07a11ULL, 0x000fe200078648ffULL, 0x0000001037267825ULL, 0x000fe200078e00d2ULL,
0x00005e0035ae7a11ULL, 0x000fc400078848ffULL, 0x00005f002bb97a11ULL, 0x000fe200008f4c08ULL,
0x000000109d3d7824ULL, 0x000fe200078e0206ULL, 0x00005f0031b57a11ULL, 0x000fe200010f4c0aULL,
0x00000010372a7825ULL, 0x000fe200078e00ceULL, 0x00005f0033b17a11ULL, 0x000fe200018f4c0cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026397faeULL, 0x0003e2000b901c46ULL,
0x00005f0035af7a11ULL, 0x000fe200020f4c0eULL, 0x000000109c3f7824ULL, 0x000fe400078e0206ULL,
0x0000001037307825ULL, 0x000fe200078e00ccULL, 0x00000000283b7faeULL, 0x0005e6000b901c46ULL,
0x000000109b417824ULL, 0x000fe200078e0206ULL, 0x000000002a3d7faeULL, 0x0007e2000b901c46ULL,
0x0000001037327825ULL, 0x000fc600078e00caULL, 0x00000000303f7faeULL, 0x0009e2000b901c46ULL,
0x000000109a437824ULL, 0x000fe400078e0206ULL, 0x0000001037347825ULL, 0x000fe200078e00c8ULL,
0x0000000032417faeULL, 0x000be6000b901c46ULL, 0x0000001099397824ULL, 0x002fe200078e0206ULL,
0x0000000034437faeULL, 0x0003e2000b901c46ULL, 0x0000001037267825ULL, 0x000fc800078e00c6ULL,
0x0000001098457824ULL, 0x000fe200078e0206ULL, 0x0000000026397faeULL, 0x0003e2000b901c46ULL,
0x0000001037287825ULL, 0x004fc800078e00c4ULL, 0x0000001097477824ULL, 0x000fe200078e0206ULL,
0x0000000028457faeULL, 0x0005e2000b901c46ULL, 0x00000010372a7825ULL, 0x008fc800078e00c2ULL,
0x0000001096497824ULL, 0x000fe200078e0206ULL, 0x000000002a477faeULL, 0x0007e2000b901c46ULL,
0x0000001037307825ULL, 0x010fc800078e00beULL, 0x00000010954b7824ULL, 0x000fe200078e0206ULL,
0x0000000030497faeULL, 0x0009e2000b901c46ULL, 0x0000001037327825ULL, 0x020fc800078e00bcULL,
0x00000010943b7824ULL, 0x000fe200078e0206ULL, 0x00000000324b7faeULL, 0x0005e2000b901c46ULL,
0x0000001037347825ULL, 0x002fc800078e00baULL, 0x00000010933d7824ULL, 0x000fe200078e0206ULL,
0x00000000343b7faeULL, 0x0003e2000b901c46ULL, 0x0000001037267825ULL, 0x000fc800078e00b8ULL,
0x00000010923f7824ULL, 0x000fe200078e0206ULL, 0x00000000263d7faeULL, 0x0003e2000b901c46ULL,
0x0000001037287825ULL, 0x004fc800078e00b4ULL, 0x0000001091417824ULL, 0x000fe200078e0206ULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x00000010372a7825ULL, 0x008fc800078e00b0ULL,
0x0000001090437824ULL, 0x000fe200078e0206ULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x0000001037307825ULL, 0x010fca00078e00aeULL, 0x0000000030437faeULL, 0x0003e4000b901c46ULL,
0x00000004ff067819ULL, 0x100fe20000011600ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008a1277812ULL, 0x002fe200078ef800ULL, 0x000040007dab7824ULL, 0x000fe200078e00ffULL,
0x00000002060c7810ULL, 0x040fe20007ffe0ffULL, 0x00000008060a7824ULL, 0x040fe200078e00ffULL,
0x0000000706087812ULL, 0x000fe400078e7827ULL, 0x00002000ab757810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee2a1ULL, 0x0000002027087824ULL, 0x000fe200078e0208ULL,
0x000000070c0c7812ULL, 0x000fc400078e7827ULL, 0x000000070a577812ULL, 0x040fe200078ec0ffULL,
0x000000080aa77824ULL, 0x040fe200078e00ffULL, 0x000000100aaa7810ULL, 0x000fe20007ffe0ffULL,
0x0000001008287824ULL, 0x000fe200078e00ffULL, 0x0000000157d47812ULL, 0x000fe200078e7807ULL,
0x00000020270c7824ULL, 0x000fe200078e020cULL, 0x000000200aa97810ULL, 0x000fe40007ffe0ffULL,
0x000000a7d4d47212ULL, 0x000fe200078efcffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x00000007aa517812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000010d4a07824ULL, 0x000fe200078e0275ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x0000000107087812ULL, 0x000fe200078ec0ffULL,
0x00000008aaaa7824ULL, 0x000fe200078e00ffULL, 0x000000300a0a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000a034783bULL, 0x000e620000000200ULL, 0x00000007a9537812ULL, 0x040fe200078ec0ffULL,
0x00000008a9a97824ULL, 0x000fe200078e00ffULL, 0x0000000151317812ULL, 0x000fe200078e7807ULL,
0x000000080aa87824ULL, 0x040fe200078e00ffULL, 0x00000002572c7812ULL, 0x000fe200078e1e08ULL,
0x000000000c60783bULL, 0x0005e20000000200ULL, 0x000000070a557812ULL, 0x000fc400078ec0ffULL,
0x0000000153b27812ULL, 0x100fe400078e7807ULL, 0x000000aa31c07212ULL, 0x000fe400078efcffULL,
0x000000a72c2c7212ULL, 0x000fe400078efcffULL, 0x0000000155317812ULL, 0x000fe200078e7807ULL,
0x00000010c08f7824ULL, 0x100fe200078e0275ULL, 0x000000a9b2b27212ULL, 0x000fe200078efcffULL,
0x000000102c8c7824ULL, 0x000fe200078e0275ULL, 0x000000a831b67212ULL, 0x000fc400078efcffULL,
0x0000000253807812ULL, 0x100fe200078e1e08ULL, 0x00000010b28e7824ULL, 0x100fe200078e0275ULL,
0x000000008c58783bULL, 0x000ee20000000200ULL, 0x00000010b68d7824ULL, 0x100fe200078e0275ULL,
0x000000a980807212ULL, 0x000fe400078efcffULL, 0x000000008e30783bULL, 0x000f220000000200ULL,
0x0000000251397812ULL, 0x000fe400078e1e08ULL, 0x00000010808a7824ULL, 0x000fe200078e0275ULL,
0x000000008d48783bULL, 0x000f620000000200ULL, 0x000000aa39ac7212ULL, 0x000fc400078efcffULL,
0x00000004060a7810ULL, 0x000fe20007ffe0ffULL, 0x000000008f4c783bULL, 0x000f220000000200ULL,
0x0000000457767812ULL, 0x100fe200078e1e08ULL, 0x00000010ac8b7824ULL, 0x000fe200078e0275ULL,
0x000000070a0a7812ULL, 0x000fe200078e7827ULL, 0x000000008a38783bULL, 0x000f220000000200ULL,
0x000000342844723cULL, 0x002fe200000018ffULL, 0x0000000453747812ULL, 0x000fe400078e1e08ULL,
0x000000008b40783bULL, 0x000e620000000200ULL, 0x000000a776767212ULL, 0x000fe200078efcffULL,
0x00000020270a7824ULL, 0x000fe200078e020aULL, 0x000000a974747212ULL, 0x000fc400078efcffULL,
0x000000362834723cULL, 0x000fe200000018ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x00000006570c7812ULL, 0x004fe200078e1e08ULL, 0x0000001076887824ULL, 0x100fe200078e0275ULL,
0x00000006060e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001074867824ULL, 0x000fe200078e0275ULL,
0x000000a70ca77212ULL, 0x000fe400078efcffULL, 0x000000008870783bULL, 0x000fe20000000200ULL,
0x000000070e0c7812ULL, 0x000fe400078e7827ULL, 0x00000010a7847824ULL, 0x000fe200078e0275ULL,
0x000000008664783bULL, 0x000fe40000000200ULL, 0x00000020270c7824ULL, 0x000fc400078e020cULL,
0x000000586044723cULL, 0x008fe40000001844ULL, 0x000000100c0c7824ULL, 0x000fcc00078e00ffULL,
0x0000005a6058723cULL, 0x000ff00000001834ULL, 0x000000302834723cULL, 0x050ff000000018ffULL,
0x000000322830723cULL, 0x040ff000000018ffULL, 0x00000048283c723cULL, 0x060fee00000018ffULL,
0x0000000255497812ULL, 0x000fe200078e1e08ULL, 0x0000004c286c723cULL, 0x000fe600000018ffULL,
0x000000a849a27212ULL, 0x000fca00078efcffULL, 0x00000010a2897824ULL, 0x000fe200078e0275ULL,
0x0000004e284c723cULL, 0x040ff000000018ffULL, 0x0000004a2828723cULL, 0x000fe200000018ffULL,
0x000000008948783bULL, 0x000eae0000000200ULL, 0x000000386034723cULL, 0x040ff00000001834ULL,
0x0000003a6038723cULL, 0x040fee0000001830ULL, 0x0000000451317812ULL, 0x100fe200078e1e08ULL,
0x00000040606c723cULL, 0x002fe2000000186cULL, 0x0000000455337812ULL, 0x000fc400078e1e08ULL,
0x000000aa31a67212ULL, 0x000fe400078efcffULL, 0x000000a833a47212ULL, 0x000fe400078efcffULL,
0x000000000a30783bULL, 0x0002e20000000200ULL, 0x00000010a6877824ULL, 0x100fe200078e0275ULL,
0x0000000651517812ULL, 0x100fe200078e1e08ULL, 0x00000010a4857824ULL, 0x000fe200078e0275ULL,
0x0000000655557812ULL, 0x000fe200078e1e08ULL, 0x000000426040723cULL, 0x000fe2000000184cULL,
0x000000008768783bULL, 0x000f220000000200ULL, 0x000000aa51aa7212ULL, 0x000fc400078efcffULL,
0x00000006530a7812ULL, 0x002fe200078e1e08ULL, 0x00000000855c783bULL, 0x000e620000000200ULL,
0x000000a855a87212ULL, 0x000fe200078efcffULL, 0x00000010aa837824ULL, 0x100fe200078e0275ULL,
0x000000a90aa97212ULL, 0x000fe200078efcffULL, 0x00000048603c723cULL, 0x044fe2000000183cULL,
0x00000000844c783bULL, 0x000fe20000000200ULL, 0x00000010a8817824ULL, 0x100fe400078e0275ULL,
0x00000010a9827824ULL, 0x000fe200078e0275ULL, 0x000000008354783bULL, 0x000fe60000000200ULL,
0x0000004a6060723cULL, 0x000fe20000001828ULL, 0x000000000c48783bULL, 0x000ea80000000200ULL,
0x000000008250783bULL, 0x000f680000000200ULL, 0x000000008128783bULL, 0x000e620000000200ULL,
0x000000703044723cULL, 0x048ff00000001844ULL, 0x00000068306c723cULL, 0x050ff0000000186cULL,
0x000000643034723cULL, 0x040ff00000001834ULL, 0x000000723058723cULL, 0x040ff00000001858ULL,
0x0000006a3040723cULL, 0x040ff00000001840ULL, 0x000000663038723cULL, 0x040ff00000001838ULL,
0x0000005c303c723cULL, 0x042ff0000000183cULL, 0x0000005e3030723cULL, 0x000ff00000001860ULL,
0x0000004c4844723cULL, 0x044ff00000001844ULL, 0x00000054486c723cULL, 0x040ff0000000186cULL,
0x000000504834723cULL, 0x060ff00000001834ULL, 0x0000004e484c723cULL, 0x040ff00000001858ULL,
0x000000564854723cULL, 0x040ff00000001840ULL, 0x000000524850723cULL, 0x040ff00000001838ULL,
0x00000028483c723cULL, 0x040ff0000000183cULL, 0x0000002a4848723cULL, 0x000fe20000001830ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x000000017c1e7824ULL, 0x000fe200078e0a05ULL,
0x00000010a1417812ULL, 0x000fe200078efcffULL, 0x000000109f087824ULL, 0x000fc400078e0275ULL,
0x000000109e0a7824ULL, 0x000fe200078e0275ULL, 0x0000001e0700720cULL, 0x080fe20003f26070ULL,
0x0000001041327825ULL, 0x000fe200078e00d2ULL, 0x0000001e0900720cULL, 0x080fe40003f46070ULL,
0x0000001e0b00720cULL, 0x080fe20003f66070ULL, 0x00000010413a7825ULL, 0x000fe200078e00d0ULL,
0x0000001e0f00720cULL, 0x080fe40003f86070ULL, 0x0000001e1900720cULL, 0x080fe20003fa6070ULL,
0x000000109d0c7824ULL, 0x000fe200078e0275ULL, 0x0000001e2500720cULL, 0x000fe20003fc6070ULL,
0x0000001041307825ULL, 0x000fc400078e00ceULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032087faeULL, 0x0003e2000c901c46ULL, 0x0000001e0d00720cULL, 0x080fe20003f26070ULL,
0x000000109c0e7824ULL, 0x000fe400078e0275ULL, 0x000000003a0a7faeULL, 0x0005e2000d101c46ULL,
0x0000001e1100720cULL, 0x080fe20003f46070ULL, 0x0000001041287825ULL, 0x000fe400078e00ccULL,
0x00000000300c7faeULL, 0x0007e2000d901c46ULL, 0x0000001e1300720cULL, 0x000fe20003f66070ULL,
0x000000109b107824ULL, 0x000fc400078e0275ULL, 0x00000010412a7825ULL, 0x000fe400078e00caULL,
0x00000000280e7faeULL, 0x0009e2000c901c46ULL, 0x0000001e1b00720cULL, 0x080fe20003f26070ULL,
0x000000109a127824ULL, 0x000fe400078e0275ULL, 0x0000001041387825ULL, 0x000fe200078e00c8ULL,
0x000000002a107faeULL, 0x000be2000e101c46ULL, 0x0000001e1500720cULL, 0x080fe40003f86070ULL,
0x0000001099147824ULL, 0x000fe200078e0275ULL, 0x0000000038127faeULL, 0x0005e2000d101c46ULL,
0x0000001e1700720cULL, 0x000fe20003f46070ULL, 0x0000001041327825ULL, 0x002fc800078e00c6ULL,
0x0000001098167824ULL, 0x000fe200078e0275ULL, 0x0000000032147faeULL, 0x0003e2000d901c46ULL,
0x0000001041307825ULL, 0x008fe200078e00c4ULL, 0x0000001e1f00720cULL, 0x000fc60003f66070ULL,
0x0000001097187824ULL, 0x000fe200078e0275ULL, 0x0000000030167faeULL, 0x0007e2000e101c46ULL,
0x00000010412a7825ULL, 0x020fe200078e00c2ULL, 0x0000001e2100720cULL, 0x000fc60003f86070ULL,
0x00000010961a7824ULL, 0x000fe200078e0275ULL, 0x000000002a187faeULL, 0x000be2000d101c46ULL,
0x0000001041287825ULL, 0x010fe200078e00beULL, 0x0000001e1d00720cULL, 0x000fc60003f46070ULL,
0x00000010951c7824ULL, 0x000fe200078e0275ULL, 0x00000000281a7faeULL, 0x0009e2000e901c46ULL,
0x0000001e2300720cULL, 0x000fe20003fa6070ULL, 0x00000010413a7825ULL, 0x004fc800078e00bcULL,
0x00000010941e7824ULL, 0x000fe200078e0275ULL, 0x000000003a1c7faeULL, 0x0005e2000c901c46ULL,
0x0000001041387825ULL, 0x000fc800078e00baULL, 0x0000001093207824ULL, 0x000fe200078e0275ULL,
0x00000000381e7faeULL, 0x0005e2000d101c46ULL, 0x0000001041327825ULL, 0x002fc800078e00b8ULL,
0x0000001092227824ULL, 0x000fe200078e0275ULL, 0x0000000032207faeULL, 0x0005e2000d901c46ULL,
0x0000001041307825ULL, 0x008fc800078e00b4ULL, 0x0000001091247824ULL, 0x000fe200078e0275ULL,
0x0000000030227faeULL, 0x0005e2000e101c46ULL, 0x00000010412a7825ULL, 0x020fc800078e00b0ULL,
0x0000001090267824ULL, 0x000fe200078e0275ULL, 0x000000002a247faeULL, 0x0005e2000e901c46ULL,
0x0000001041287825ULL, 0x010fca00078e00aeULL, 0x0000000028267faeULL, 0x0005e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x00000010a1437812ULL, 0x000fe200078efcffULL,
0x000000109f087824ULL, 0x100fe400078e0275ULL, 0x000000109e0a7824ULL, 0x000fe400078e0275ULL,
0x00000010432a7825ULL, 0x000fc800078e00d2ULL, 0x0000001043307825ULL, 0x000fe200078e00d0ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a087faeULL, 0x0003e6000b901c46ULL,
0x000000109d0c7824ULL, 0x000fe200078e0275ULL, 0x00000000300a7faeULL, 0x0005e2000b901c46ULL,
0x0000001043407825ULL, 0x000fc800078e00ceULL, 0x000000109c0e7824ULL, 0x000fe200078e0275ULL,
0x00000000400c7faeULL, 0x0007e2000b901c46ULL, 0x0000001043287825ULL, 0x000fc800078e00ccULL,
0x000000109b107824ULL, 0x000fe200078e0275ULL, 0x00000000280e7faeULL, 0x0009e2000b901c46ULL,
0x00000010433a7825ULL, 0x000fc800078e00caULL, 0x000000109a127824ULL, 0x000fe200078e0275ULL,
0x000000003a107faeULL, 0x000be2000b901c46ULL, 0x0000001043387825ULL, 0x000fc800078e00c8ULL,
0x0000001099147824ULL, 0x000fe200078e0275ULL, 0x0000000038127faeULL, 0x0003e2000b901c46ULL,
0x0000001043327825ULL, 0x000fc800078e00c6ULL, 0x0000001098167824ULL, 0x000fe200078e0275ULL,
0x0000000032147faeULL, 0x0007e2000b901c46ULL, 0x0000001043307825ULL, 0x004fc800078e00c4ULL,
0x0000001097187824ULL, 0x000fe200078e0275ULL, 0x0000000030167faeULL, 0x0005e2000b901c46ULL,
0x00000010432a7825ULL, 0x002fc800078e00c2ULL, 0x00000010961a7824ULL, 0x000fe200078e0275ULL,
0x000000002a187faeULL, 0x0003e2000b901c46ULL, 0x0000001043287825ULL, 0x010fc800078e00beULL,
0x00000010951c7824ULL, 0x000fe200078e0275ULL, 0x00000000281a7faeULL, 0x0009e2000b901c46ULL,
0x00000010433a7825ULL, 0x020fc800078e00bcULL, 0x00000010941e7824ULL, 0x000fe200078e0275ULL,
0x000000003a1c7faeULL, 0x0003e2000b901c46ULL, 0x0000001043387825ULL, 0x000fc800078e00baULL,
0x0000001093207824ULL, 0x000fe200078e0275ULL, 0x00000000381e7faeULL, 0x0003e2000b901c46ULL,
0x0000001043327825ULL, 0x008fc800078e00b8ULL, 0x0000001092227824ULL, 0x000fe200078e0275ULL,
0x0000000032207faeULL, 0x0007e2000b901c46ULL, 0x0000001043307825ULL, 0x004fc800078e00b4ULL,
0x0000001091247824ULL, 0x000fe200078e0275ULL, 0x0000000030227faeULL, 0x0007e2000b901c46ULL,
0x00000010432a7825ULL, 0x002fc800078e00b0ULL, 0x0000001090267824ULL, 0x000fe200078e0275ULL,
0x000000002a247faeULL, 0x0007e2000b901c46ULL, 0x0000001043287825ULL, 0x010fca00078e00aeULL,
0x0000000028267faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000806287810ULL, 0x00cfe40007ffe0ffULL, 0x00004000abab7810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x000fe400078e7827ULL, 0x0000000a062a7810ULL, 0x000fe20007ffe0ffULL,
0x000000102c2c7824ULL, 0x000fe400078e02abULL, 0x0000002027297824ULL, 0x000fe200078e0228ULL,
0x000000072a407812ULL, 0x000fe200078e7827ULL, 0x00000010d4287824ULL, 0x000fc400078e02abULL,
0x0000001029587824ULL, 0x000fe400078e00ffULL, 0x00000010c0297824ULL, 0x100fe400078e02abULL,
0x0000002027407824ULL, 0x000fe400078e0240ULL, 0x00000010b22a7824ULL, 0x000fe400078e02abULL,
0x0000001040407824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002830783bULL, 0x000fe20000000200ULL, 0x00000010ac7f7824ULL, 0x100fe400078e02abULL,
0x00000010b62b7824ULL, 0x100fe200078e02abULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x0000001080807824ULL, 0x100fe400078e02abULL, 0x00000010a2a27824ULL, 0x100fe200078e02abULL,
0x000000002938783bULL, 0x000ea20000000200ULL, 0x0000001076a37824ULL, 0x100fe400078e02abULL,
0x00000010a6a67824ULL, 0x100fe200078e02abULL, 0x000000002c70783bULL, 0x000fe20000000200ULL,
0x0000001074a57824ULL, 0x000fc400078e02abULL, 0x00000010a4a47824ULL, 0x100fe200078e02abULL,
0x000000004040783bULL, 0x000ee20000000200ULL, 0x00000010a7a77824ULL, 0x100fe400078e02abULL,
0x00000010aaaa7824ULL, 0x100fe200078e02abULL, 0x000000002a60783bULL, 0x000f220000000200ULL,
0x00000010a9a97824ULL, 0x100fe400078e02abULL, 0x00000010a8a87824ULL, 0x000fe200078e02abULL,
0x000000002b5c783bULL, 0x000fe80000000200ULL, 0x00000000a374783bULL, 0x000fe80000000200ULL,
0x00000000a668783bULL, 0x000fe80000000200ULL, 0x00000000a564783bULL, 0x000fe20000000200ULL,
0x000000305844723cULL, 0x042ff00000001844ULL, 0x00000032584c723cULL, 0x040fe2000000184cULL,
0x000000007f30783bULL, 0x000e6e0000000200ULL, 0x00000038586c723cULL, 0x044ff0000000186cULL,
0x0000003a5854723cULL, 0x000fe20000001854ULL, 0x000000008038783bULL, 0x000eae0000000200ULL,
0x000000704044723cULL, 0x048ff00000001844ULL, 0x000000724070723cULL, 0x000fe2000000184cULL,
0x00000000a24c783bULL, 0x000eee0000000200ULL, 0x000000605834723cULL, 0x050ff00000001834ULL,
0x000000625850723cULL, 0x000fe20000001850ULL, 0x00000000a460783bULL, 0x000fee0000000200ULL,
0x00000030406c723cULL, 0x002fee000000186cULL, 0x0000000c06307810ULL, 0x000fe20007ffe0ffULL,
0x0000005c583c723cULL, 0x040ff0000000183cULL, 0x0000005e5848723cULL, 0x000fee0000001848ULL,
0x0000000730587812ULL, 0x000fe200078e7827ULL, 0x000000384034723cULL, 0x004fe80000001834ULL,
0x0000002027587824ULL, 0x000fc800078e0258ULL, 0x0000001058587824ULL, 0x000fe200078e00ffULL,
0x0000003a4038723cULL, 0x040fe80000001850ULL, 0x00000000585c783bULL, 0x000e660000000200ULL,
0x0000000e06507810ULL, 0x000fe20007ffe0ffULL, 0x000000324030723cULL, 0x000fe20000001854ULL,
0x00000000a758783bULL, 0x000fe40000000200ULL, 0x0000000750507812ULL, 0x000fc400078e7827ULL,
0x00000000aa54783bULL, 0x000fe60000000200ULL, 0x0000002027507824ULL, 0x000fe200078e0250ULL,
0x0000004c403c723cULL, 0x048fe6000000183cULL, 0x0000001050ac7824ULL, 0x000fe400078e00ffULL,
0x00000000a950783bULL, 0x000fe60000000200ULL, 0x0000004e4040723cULL, 0x000fe20000001848ULL,
0x00000000ac48783bULL, 0x000ea80000000200ULL, 0x00000000a84c783bULL, 0x000ee60000000200ULL,
0x000000745c44723cULL, 0x042ff00000001844ULL, 0x000000765c70723cULL, 0x040ff00000001870ULL,
0x000000685c6c723cULL, 0x040ff0000000186cULL, 0x0000006a5c30723cULL, 0x040ff00000001830ULL,
0x000000645c34723cULL, 0x040ff00000001834ULL, 0x000000665c38723cULL, 0x040ff00000001838ULL,
0x000000605c3c723cULL, 0x040ff0000000183cULL, 0x000000625c40723cULL, 0x000ff00000001840ULL,
0x000000584844723cULL, 0x044ff00000001844ULL, 0x0000005a4870723cULL, 0x040ff00000001870ULL,
0x00000054486c723cULL, 0x040ff0000000186cULL, 0x000000564830723cULL, 0x040ff00000001830ULL,
0x000000504834723cULL, 0x040ff00000001834ULL, 0x000000524838723cULL, 0x040ff00000001838ULL,
0x0000004c483c723cULL, 0x048ff0000000183cULL, 0x0000004e4848723cULL, 0x000fe20000001840ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x000000017c407824ULL, 0x000fe200078e0a05ULL,
0x00000018a1a17812ULL, 0x000fe200078efcffULL, 0x000000109f9f7824ULL, 0x000fc400078e02abULL,
0x000000109e417824ULL, 0x000fe200078e02abULL, 0x000000400700720cULL, 0x080fe20003f06070ULL,
0x00000010a1d27825ULL, 0x000fe200078e00d2ULL, 0x000000400900720cULL, 0x080fe40003f26070ULL,
0x000000400f00720cULL, 0x080fe20003f46070ULL, 0x00000010a1d07825ULL, 0x000fe200078e00d0ULL,
0x000000401100720cULL, 0x080fe40003f66070ULL, 0x000000401300720cULL, 0x080fe20003f86070ULL,
0x000000109d9d7824ULL, 0x000fe200078e02abULL, 0x000000401500720cULL, 0x080fe20003fa6070ULL,
0x00000010a1ce7825ULL, 0x000fe200078e00ceULL, 0x000000401700720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000d29f7faeULL, 0x0003e2000c101c46ULL,
0x000000400b00720cULL, 0x000fe20003f06070ULL, 0x000000109c437824ULL, 0x000fc400078e02abULL,
0x00000000d0417faeULL, 0x0005e2000c901c46ULL, 0x000000400d00720cULL, 0x000fe20003f26070ULL,
0x00000010a1cc7825ULL, 0x000fc800078e00ccULL, 0x000000109b9b7824ULL, 0x000fe400078e02abULL,
0x00000010a1ca7825ULL, 0x000fe400078e00caULL, 0x00000000ce9d7faeULL, 0x0003e2000c101c46ULL,
0x000000401900720cULL, 0x080fe20003f06070ULL, 0x000000109a4d7824ULL, 0x000fe400078e02abULL,
0x00000010a1c87825ULL, 0x000fe200078e00c8ULL, 0x00000000cc437faeULL, 0x0003e2000c901c46ULL,
0x000000401b00720cULL, 0x000fc40003f26070ULL, 0x0000001099997824ULL, 0x000fe200078e02abULL,
0x00000000ca9b7faeULL, 0x0003e2000d101c46ULL, 0x00000010a1c67825ULL, 0x000fe200078e00c6ULL,
0x000000401d00720cULL, 0x080fe40003f46070ULL, 0x00000000c84d7faeULL, 0x0003e2000d901c46ULL,
0x00000010984f7824ULL, 0x000fe200078e02abULL, 0x000000401f00720cULL, 0x080fe20003f66070ULL,
0x00000010a1c47825ULL, 0x000fe200078e00c4ULL, 0x00000000c6997faeULL, 0x0003e2000e101c46ULL,
0x000000402100720cULL, 0x000fc40003f86070ULL, 0x0000001097977824ULL, 0x000fe200078e02abULL,
0x00000000c44f7faeULL, 0x0003e2000e901c46ULL, 0x00000010a1c27825ULL, 0x000fe200078e00c2ULL,
0x000000402300720cULL, 0x000fc60003fa6070ULL, 0x0000001096517824ULL, 0x000fe200078e02abULL,
0x00000000c2977faeULL, 0x0003e2000f101c46ULL, 0x000000402500720cULL, 0x000fe20003fc6070ULL,
0x00000010a1be7825ULL, 0x000fc800078e00beULL, 0x0000001095957824ULL, 0x000fe200078e02abULL,
0x00000000be517faeULL, 0x0003e2000c101c46ULL, 0x00000010a1bc7825ULL, 0x000fc800078e00bcULL,
0x0000001094537824ULL, 0x000fe200078e02abULL, 0x00000000bc957faeULL, 0x0003e2000c901c46ULL,
0x00000010a1ba7825ULL, 0x000fc800078e00baULL, 0x0000001093937824ULL, 0x000fe200078e02abULL,
0x00000000ba537faeULL, 0x0003e2000d101c46ULL, 0x00000010a1b87825ULL, 0x000fc800078e00b8ULL,
0x0000001092417824ULL, 0x004fe200078e02abULL, 0x00000000b8937faeULL, 0x0003e2000d901c46ULL,
0x00000010a1b47825ULL, 0x000fc800078e00b4ULL, 0x0000001091917824ULL, 0x000fe200078e02abULL,
0x00000000b4417faeULL, 0x0003e2000e101c46ULL, 0x00000010a1b07825ULL, 0x000fc800078e00b0ULL,
0x0000001090ab7824ULL, 0x000fe200078e02abULL, 0x00000000b0917faeULL, 0x0003e2000e901c46ULL,
0x00000010a1ae7825ULL, 0x000fca00078e00aeULL, 0x00000000aeab7faeULL, 0x0003e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x00000018a1a17812ULL, 0x000fe200078efcffULL,
0x000000109f9f7824ULL, 0x100fe400078e02abULL, 0x000000109e417824ULL, 0x000fe400078e02abULL,
0x00000010a1d27825ULL, 0x000fc800078e00d2ULL, 0x00000010a1d07825ULL, 0x000fe200078e00d0ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000d29f7faeULL, 0x0003e6000b901c46ULL,
0x000000109d9d7824ULL, 0x000fe200078e02abULL, 0x00000000d0417faeULL, 0x0003e2000b901c46ULL,
0x00000010a1ce7825ULL, 0x000fc800078e00ceULL, 0x000000109c437824ULL, 0x000fe200078e02abULL,
0x00000000ce9d7faeULL, 0x0003e2000b901c46ULL, 0x00000010a1cc7825ULL, 0x000fc800078e00ccULL,
0x000000109b9b7824ULL, 0x000fe200078e02abULL, 0x00000000cc437faeULL, 0x0003e2000b901c46ULL,
0x00000010a1ca7825ULL, 0x000fc800078e00caULL, 0x000000109a4d7824ULL, 0x000fe200078e02abULL,
0x00000000ca9b7faeULL, 0x0003e2000b901c46ULL, 0x00000010a1c87825ULL, 0x000fc800078e00c8ULL,
0x0000001099997824ULL, 0x000fe200078e02abULL, 0x00000000c84d7faeULL, 0x0003e2000b901c46ULL,
0x00000010a1c67825ULL, 0x000fc800078e00c6ULL, 0x00000010984f7824ULL, 0x000fe200078e02abULL,
0x00000000c6997faeULL, 0x0003e2000b901c46ULL, 0x00000010a1c47825ULL, 0x000fc800078e00c4ULL,
0x0000001097977824ULL, 0x000fe200078e02abULL, 0x00000000c44f7faeULL, 0x0003e2000b901c46ULL,
0x00000010a1c27825ULL, 0x000fc800078e00c2ULL, 0x0000001096517824ULL, 0x000fe200078e02abULL,
0x00000000c2977faeULL, 0x0003e2000b901c46ULL, 0x00000010a1be7825ULL, 0x000fc800078e00beULL,
0x0000001095957824ULL, 0x000fe200078e02abULL, 0x00000000be517faeULL, 0x0003e2000b901c46ULL,
0x00000010a1bc7825ULL, 0x000fc800078e00bcULL, 0x0000001094537824ULL, 0x000fe200078e02abULL,
0x00000000bc957faeULL, 0x0003e2000b901c46ULL, 0x00000010a1ba7825ULL, 0x000fc800078e00baULL,
0x0000001093937824ULL, 0x000fe200078e02abULL, 0x00000000ba537faeULL, 0x0003e2000b901c46ULL,
0x00000010a1b87825ULL, 0x000fc800078e00b8ULL, 0x0000001092557824ULL, 0x000fe200078e02abULL,
0x00000000b8937faeULL, 0x0003e2000b901c46ULL, 0x00000010a1b47825ULL, 0x000fc800078e00b4ULL,
0x0000001091917824ULL, 0x000fe200078e02abULL, 0x00000000b4557faeULL, 0x0003e2000b901c46ULL,
0x00000010a1b07825ULL, 0x000fc800078e00b0ULL, 0x0000001090ab7824ULL, 0x000fe200078e02abULL,
0x00000000b0917faeULL, 0x0003e2000b901c46ULL, 0x00000010a1ae7825ULL, 0x000fca00078e00aeULL,
0x00000000aeab7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff417624ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff917424ULL, 0x000fe400078e00ffULL,
0x00000002417a7824ULL, 0x000fca00078e027aULL, 0x0000007b7a00720cULL, 0x000fda0003f06070ULL,
0x000000022d4c8824ULL, 0x000fe400078e027aULL, 0x00000004ff4d8424ULL, 0x000fe200078e00ffULL,
0x0000001006407810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000060004c4c8625ULL, 0x000fe200078e004dULL, 0x0000000740407812ULL, 0x100fe200078e7827ULL,
0x00000000a064783bULL, 0x000fe80000000200ULL, 0x000000064c918981ULL, 0x0002a2000c1e1900ULL,
0x0000002027407824ULL, 0x000fe200078e0240ULL, 0x00000012064e7810ULL, 0x000fe40007ffe0ffULL,
0x000000008e5c783bULL, 0x000fe20000000200ULL, 0x0000001040547824ULL, 0x000fe200078e00ffULL,
0x000000074e4e7812ULL, 0x000fc400078e7827ULL, 0x000000008f40783bULL, 0x000fe60000000200ULL,
0x00000020274e7824ULL, 0x000fe200078e024eULL, 0x000000005454783bULL, 0x000ee60000000200ULL,
0x000000104e4e7824ULL, 0x000fe200078e00ffULL, 0x000000008d58783bULL, 0x000fe80000000200ULL,
0x000000008c50783bULL, 0x000fe80000000200ULL, 0x000000004e4c783bULL, 0x002fe80000000200ULL,
0x000000008474783bULL, 0x000fe80000000200ULL, 0x000000008368783bULL, 0x000fe20000000200ULL,
0x000000645460723cULL, 0x048fe60000001844ULL, 0x000000008b44783bULL, 0x000e6a0000000200ULL,
0x00000040546c723cULL, 0x040ff0000000186cULL, 0x000000665470723cULL, 0x040fe20000001870ULL,
0x000000008a64783bULL, 0x000eee0000000200ULL, 0x000000425430723cULL, 0x040fe20000001830ULL,
0x000000008940783bULL, 0x000f2e0000000200ULL, 0x0000005c5434723cULL, 0x040ff00000001834ULL,
0x0000005e5438723cULL, 0x000fe20000001838ULL, 0x00000000855c783bULL, 0x000fee0000000200ULL,
0x000000444c6c723cULL, 0x002fee000000186cULL, 0x0000001406447810ULL, 0x000fe20007ffe0ffULL,
0x00000058543c723cULL, 0x000fe6000000183cULL, 0x0000000744447812ULL, 0x000fca00078e7827ULL,
0x0000002027447824ULL, 0x000fe200078e0244ULL, 0x0000005a5448723cULL, 0x000fe20000001848ULL,
0x000000008654783bULL, 0x000fe40000000200ULL, 0x0000001044587824ULL, 0x000fca00078e00ffULL,
0x000000504c60723cULL, 0x040fe20000001860ULL, 0x000000005858783bULL, 0x000fee0000000200ULL,
0x000000524c70723cULL, 0x040fe20000001870ULL, 0x000000008750783bULL, 0x000fee0000000200ULL,
0x000000464c30723cULL, 0x040fe20000001830ULL, 0x000000008844783bULL, 0x000e6e0000000200ULL,
0x000000644c34723cULL, 0x048fee0000001834ULL, 0x0000001606647810ULL, 0x000fe20007ffe0ffULL,
0x000000664c38723cULL, 0x000fe60000001838ULL, 0x0000000764647812ULL, 0x000fca00078e7827ULL,
0x0000002027647824ULL, 0x000fe200078e0264ULL, 0x000000404c3c723cULL, 0x050fee000000183cULL,
0x0000001064407824ULL, 0x000fe200078e00ffULL, 0x000000424c48723cULL, 0x000fe20000001848ULL,
0x000000008264783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000ee60000000200ULL,
0x000000445860723cULL, 0x042fe20000001860ULL, 0x00000000814c783bULL, 0x000e6e0000000200ULL,
0x000000465870723cULL, 0x040ff00000001870ULL, 0x00000050586c723cULL, 0x040ff0000000186cULL,
0x000000525830723cULL, 0x040ff00000001830ULL, 0x000000545834723cULL, 0x040ff00000001834ULL,
0x000000565838723cULL, 0x040ff00000001838ULL, 0x0000005c583c723cULL, 0x040ff0000000183cULL,
0x0000005e5848723cULL, 0x000ff00000001848ULL, 0x000000744060723cULL, 0x048ff00000001860ULL,
0x000000764070723cULL, 0x040ff00000001870ULL, 0x00000068406c723cULL, 0x040ff0000000186cULL,
0x0000006a4030723cULL, 0x040ff00000001830ULL, 0x000000644034723cULL, 0x040ff00000001834ULL,
0x000000664038723cULL, 0x040ff00000001838ULL, 0x0000004c403c723cULL, 0x042ff0000000183cULL,
0x0000004e4048723cULL, 0x000fee0000001848ULL, 0x000003007e407a10ULL, 0x000fe20007ffe0ffULL,
0x0000002e91417224ULL, 0x004fc600078e02ffULL, 0x0000000140427810ULL, 0x040fe20007ffe0ffULL,
0x0000010040437824ULL, 0x000fc600078e0278ULL, 0x000000794200720cULL, 0x000fe40003f06070ULL,
0x0000004043427812ULL, 0x000fca00078ec0ffULL, 0x000000012f567824ULL, 0x000fcc00078e0242ULL,
0x0000098000008947ULL, 0x000fea0003800000ULL, 0x000000437c427217ULL, 0x000fe20007800000ULL,
0x0000000107447824ULL, 0x000fc800078e0256ULL, 0x00000001424c7824ULL, 0x000fe200078e0a43ULL,
0x00000044414f7210ULL, 0x000fe20007f1e0ffULL, 0x0000000109427824ULL, 0x100fe400078e0256ULL,
0x000000010b447824ULL, 0x100fe200078e0256ULL, 0x0000004c0700720cULL, 0x000fe20003fa6070ULL,
0x000000ffff467224ULL, 0x000fe200000e06ffULL, 0x00005e004f437a11ULL, 0x000fe400078048ffULL,
0x00000042414d7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d427824ULL, 0x000fe200078e0256ULL,
0x0000004441447210ULL, 0x000fc40007f9e0ffULL, 0x00005f004f4f7a11ULL, 0x000fe200000f4c46ULL,
0x000000ffff467224ULL, 0x000fe200018e06ffULL, 0x00005e0044477a11ULL, 0x040fe200078648ffULL,
0x000000ffff077224ULL, 0x000fe200020e06ffULL, 0x00005e004d457a11ULL, 0x000fe400078048ffULL,
0x0000004c0900720cULL, 0x000fe40003f46070ULL, 0x00005f0044547a11ULL, 0x000fe200018f4c07ULL,
0x000000010f447824ULL, 0x000fe200078e0256ULL, 0x00005f004d4d7a11ULL, 0x000fe200000f4c46ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x0000004241537210ULL, 0x000fe20007f1e0ffULL,
0x0000000111427824ULL, 0x000fe200078e0256ULL, 0x0000004441447210ULL, 0x000fc40007fde0ffULL,
0x00005e0053097a11ULL, 0x000fe200078648ffULL, 0x000000ffff467224ULL, 0x000fe200000e06ffULL,
0x0000007007587812ULL, 0x000fe200078ec0ffULL, 0x000000ffff077224ULL, 0x000fe200030e06ffULL,
0x0000004c0b00720cULL, 0x000fe40003f26070ULL, 0x00005e00440b7a11ULL, 0x000fe400078048ffULL,
0x00005f0053537a11ULL, 0x000fe200018f4c46ULL, 0x0000000113467824ULL, 0x000fe200078e0256ULL,
0x0000004241517210ULL, 0x000fc40007f7e0ffULL, 0x0000004358427210ULL, 0x000fe40007fde0ffULL,
0x00005f0044527a11ULL, 0x000fe200000f4c07ULL, 0x000000ffff4e7224ULL, 0x000fe200018e06ffULL,
0x0000004558447210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff437224ULL, 0x000fe200030e064fULL,
0x0000004c0d00720cULL, 0x000fe40003f86070ULL, 0x00005e00510d7a11ULL, 0x000fe200078c48ffULL,
0x000000ffff457224ULL, 0x000fe200000e064dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000042087faeULL, 0x0003e2000e901c46ULL, 0x00000046414f7210ULL, 0x000fc40007fbe0ffULL,
0x00005f0051517a11ULL, 0x000fe200030f4c4eULL, 0x00000000440a7faeULL, 0x0005e2000d101c46ULL,
0x0000004758467210ULL, 0x000fe20007f5e0ffULL, 0x00000001154e7824ULL, 0x000fe200078e0256ULL,
0x0000004c1100720cULL, 0x000fe20003f06070ULL, 0x000000ffff507224ULL, 0x000fe200028e06ffULL,
0x00005e004f4d7a11ULL, 0x000fe200078a48ffULL, 0x000000ffff477224ULL, 0x000fe200010e0654ULL,
0x0000004e414e7210ULL, 0x000fe20007fde0ffULL, 0x0000000117087824ULL, 0x002fe200078e0256ULL,
0x0000004c1300720cULL, 0x000fc40003f46070ULL, 0x00005f004f4f7a11ULL, 0x000fe200028f4c50ULL,
0x000000ffff077224ULL, 0x000fe200030e06ffULL, 0x00000000460c7faeULL, 0x0003e2000c901c46ULL,
0x00005e004e117a11ULL, 0x000fe400078a48ffULL, 0x0000000841137210ULL, 0x000fe40007f3e0ffULL,
0x0000000958087210ULL, 0x000fe40007fde0ffULL, 0x00005f004e457a11ULL, 0x004fe200028f4c07ULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x0000000b580a7210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e0653ULL, 0x0000004c0f00720cULL, 0x080fe20003f66070ULL,
0x00000001190c7824ULL, 0x002fe200078e0256ULL, 0x00005e0013077a11ULL, 0x000fe200078248ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e0652ULL, 0x0000004c1700720cULL, 0x000fe20003fa6070ULL,
0x00000000080e7faeULL, 0x0003e2000e101c46ULL, 0x00005f0013137a11ULL, 0x000fe200008f4c42ULL,
0x000000011b427824ULL, 0x100fe200078e0256ULL, 0x0000000c41177210ULL, 0x000fe20007f9e0ffULL,
0x0000000123467824ULL, 0x000fe200078e0256ULL, 0x0000000d580c7210ULL, 0x000fc40007f3e0ffULL,
0x0000004c1500720cULL, 0x000fe20003fc6070ULL, 0x000000000a107faeULL, 0x0005e2000d901c46ULL,
0x000000ffff447224ULL, 0x000fe200020e06ffULL, 0x00005e00170f7a11ULL, 0x000fe200078848ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e0651ULL, 0x0000004241157210ULL, 0x000fe40007f3e0ffULL,
0x0000004d58427210ULL, 0x040fe40007f7e0ffULL, 0x00005f0017177a11ULL, 0x000fe200020f4c44ULL,
0x000000ffff0e7224ULL, 0x002fe200008e06ffULL, 0x0000001158087210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff437224ULL, 0x000fe200018e064fULL, 0x00005e0015117a11ULL, 0x000fe200078648ffULL,
0x000000000c127faeULL, 0x0003e2000c101c46ULL, 0x000000011f107824ULL, 0x004fe200078e0256ULL,
0x0000004c1900720cULL, 0x000fe20003f26070ULL, 0x000000ffff097224ULL, 0x000fe200020e0645ULL,
0x00005f0015157a11ULL, 0x000fe200018f4c0eULL, 0x000000011d0e7824ULL, 0x100fe200078e0256ULL,
0x00000007580a7210ULL, 0x000fe20007f9e0ffULL, 0x0000000121447824ULL, 0x000fe200078e0256ULL,
0x0000000042147faeULL, 0x0005e2000d101c46ULL, 0x0000001041107210ULL, 0x000fc40007f5e0ffULL,
0x0000000e41077210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200020e0613ULL,
0x0000000008167faeULL, 0x0007e2000f101c46ULL, 0x00000001250e7824ULL, 0x000fe200078e0256ULL,
0x00005e00070c7a11ULL, 0x002fe400078c48ffULL, 0x000000000a187faeULL, 0x0003e2000e901c46ULL,
0x0000004441447210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff147224ULL, 0x004fe200000e06ffULL,
0x0000000e41127210ULL, 0x040fe40007f7e0ffULL, 0x0000004641467210ULL, 0x000fc40007f1e0ffULL,
0x0000000f58087210ULL, 0x008fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x00005f00070d7a11ULL, 0x000fe200030f4c14ULL, 0x000000ffff077224ULL, 0x000fe200010e06ffULL,
0x00005e0010137a11ULL, 0x000fe200078c48ffULL, 0x000000ffff097224ULL, 0x000fe200020e0617ULL,
0x00005e00440e7a11ULL, 0x000fe400078a48ffULL, 0x0000004c1b00720cULL, 0x080fe40003f46070ULL,
0x0000004c1d00720cULL, 0x000fe20003f86070ULL, 0x00000000081a7faeULL, 0x0005e2000c901c46ULL,
0x00005f0010147a11ULL, 0x000fc400030f4c07ULL, 0x00000011580a7210ULL, 0x002fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005f00440f7a11ULL, 0x000fe400028f4c0fULL,
0x0000000c580c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0615ULL,
0x00005e0046107a11ULL, 0x000fe400078048ffULL, 0x0000004c1f00720cULL, 0x000fe20003f26070ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x000000000a1c7faeULL, 0x0003e2000d101c46ULL,
0x000000ffff097224ULL, 0x004fe200018e06ffULL, 0x0000001358087210ULL, 0x000fc40007f7e0ffULL,
0x000000000c1e7faeULL, 0x0005e2000e101c46ULL, 0x00005e0012077a11ULL, 0x000fe400078848ffULL,
0x0000000e580e7210ULL, 0x000fe40007f5e0ffULL, 0x0000004c2100720cULL, 0x080fe40003fc6070ULL,
0x0000004c2300720cULL, 0x080fe20003fa6070ULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x00005f0046117a11ULL, 0x000fe400000f4c11ULL, 0x0000004c2500720cULL, 0x000fc40003f06070ULL,
0x00005f0012127a11ULL, 0x000fe200020f4c09ULL, 0x000000ffff097224ULL, 0x000fe200018e0614ULL,
0x0000001058107210ULL, 0x040fe40007f7e0ffULL, 0x00000007580a7210ULL, 0x002fe40007f5e0ffULL,
0x0000000008207faeULL, 0x0005e2000c901c46ULL, 0x000000ffff117224ULL, 0x000fe400018e0611ULL,
0x000000ffff0b7224ULL, 0x000fe200010e0612ULL, 0x000000000e227faeULL, 0x0005e8000f101c46ULL,
0x0000000010247faeULL, 0x0005e8000e901c46ULL, 0x000000000a267faeULL, 0x0005e2000c101c46ULL,
0x0000085000007947ULL, 0x000fea0003800000ULL, 0x0000000107427824ULL, 0x100fe400078e0256ULL,
0x0000000109447824ULL, 0x000fc400078e0256ULL, 0x000000010f4e7824ULL, 0x100fe200078e0256ULL,
0x0000004241427210ULL, 0x000fe20007f1e0ffULL, 0x0000000111507824ULL, 0x100fe200078e0256ULL,
0x0000004441447210ULL, 0x000fe20007f3e0ffULL, 0x000000010b467824ULL, 0x100fe200078e0256ULL,
0x0000004e414e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e06ffULL,
0x00005e0042437a11ULL, 0x000fe200078048ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000005041507210ULL, 0x000fe20007f7e0ffULL, 0x000000010d4c7824ULL, 0x100fe200078e0256ULL,
0x00005e0044457a11ULL, 0x000fe200078248ffULL, 0x000000ffff117224ULL, 0x000fe200010e06ffULL,
0x00005f0042077a11ULL, 0x000fe200000f4c07ULL, 0x0000000117587824ULL, 0x100fe200078e0256ULL,
0x0000004641467210ULL, 0x000fe20007f1e0ffULL, 0x0000000113527824ULL, 0x100fe200078e0256ULL,
0x00005e004e4f7a11ULL, 0x000fe200078448ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005f00440b7a11ULL, 0x000fe200008f4c09ULL, 0x00000001195a7824ULL, 0x100fe200078e0256ULL,
0x0000004c414c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e0050517a11ULL, 0x000fe200078648ffULL, 0x0000000115547824ULL, 0x100fe200078e0256ULL,
0x00005f004e117a11ULL, 0x000fe200010f4c11ULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005e0046477a11ULL, 0x000fe200078048ffULL, 0x000000011b5c7824ULL, 0x100fe200078e0256ULL,
0x0000005841587210ULL, 0x000fe20007f5e0ffULL, 0x000000011d5e7824ULL, 0x100fe200078e0256ULL,
0x00005f0050137a11ULL, 0x000fe200018f4c13ULL, 0x000000011f647824ULL, 0x100fe200078e0256ULL,
0x0000005a415a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff197224ULL, 0x000fe200010e06ffULL,
0x00005e004c4d7a11ULL, 0x000fe200078248ffULL, 0x0000000121667824ULL, 0x100fe200078e0256ULL,
0x00005f00460d7a11ULL, 0x000fe200000f4c09ULL, 0x000000ffff1b7224ULL, 0x000fe200018e06ffULL,
0x0000005241527210ULL, 0x000fe20007f1e0ffULL, 0x0000000123687824ULL, 0x100fe200078e0256ULL,
0x00005e0058577a11ULL, 0x000fe200078448ffULL, 0x0000000125567824ULL, 0x000fe200078e0256ULL,
0x00005f004c0f7a11ULL, 0x000fe200008f4c0fULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x0000005441547210ULL, 0x000fc40007f3e0ffULL, 0x00005e005a597a11ULL, 0x000fe400078648ffULL,
0x00005f0058197a11ULL, 0x000fe200010f4c19ULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e0052537a11ULL, 0x000fe400078048ffULL, 0x0000005c415c7210ULL, 0x040fe40007f5e0ffULL,
0x00005f005a1b7a11ULL, 0x000fe400018f4c1bULL, 0x0000005e415e7210ULL, 0x000fc40007f7e0ffULL,
0x00005e0054557a11ULL, 0x000fe400078248ffULL, 0x00005f0052157a11ULL, 0x000fe200000f4c09ULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e005c5b7a11ULL, 0x000fe200078448ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0x00005f0054177a11ULL, 0x000fe400008f4c17ULL,
0x0000006841257210ULL, 0x040fe40007f3e0ffULL, 0x0000005641567210ULL, 0x000fc40007f7e0ffULL,
0x00005f005c1d7a11ULL, 0x000fe200010f4c09ULL, 0x0000001000097824ULL, 0x000fe200078e00ffULL,
0x0000006641667210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff427224ULL, 0x000fe200008e06ffULL,
0x0000006441647210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff417224ULL, 0x000fe200018e06ffULL,
0x00005e0025677a11ULL, 0x000fe200078248ffULL, 0x000000ffff237224ULL, 0x000fe200000e06ffULL,
0x00005e0056697a11ULL, 0x000fe200078448ffULL, 0x000000ffff217224ULL, 0x000fe200028e06ffULL,
0x0000007009687812ULL, 0x000fc400078ec0ffULL, 0x00005e0066657a11ULL, 0x000fe400078048ffULL,
0x00005e00645f7a11ULL, 0x000fe400078a48ffULL, 0x00005f0025257a11ULL, 0x000fe400008f4c42ULL,
0x00005f0056417a11ULL, 0x000fe400010f4c41ULL, 0x00005e005e5d7a11ULL, 0x000fe400078848ffULL,
0x0000004368427210ULL, 0x000fc40007f5e0ffULL, 0x0000004568447210ULL, 0x000fe40007fde0ffULL,
0x00005f0066237a11ULL, 0x000fe200000f4c23ULL, 0x000000ffff437224ULL, 0x000fe200010e0607ULL,
0x0000004768467210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff457224ULL, 0x000fe200030e060bULL,
0x00005f0064217a11ULL, 0x000fe400028f4c21ULL, 0x0000004d684c7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff477224ULL, 0x000fe200008e060dULL, 0x00005f005e1f7a11ULL, 0x000fe200020f4c1fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000042087faeULL, 0x0003e2000b901c46ULL,
0x0000004f684e7210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff4d7224ULL, 0x000fe200000e060fULL,
0x0000005168507210ULL, 0x040fe20007f9e0ffULL, 0x00000000440a7faeULL, 0x0003e2000b901c46ULL,
0x0000005368527210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff4f7224ULL, 0x000fe200028e0611ULL,
0x0000005568547210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff517224ULL, 0x000fe200020e0613ULL,
0x0000005768567210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff537224ULL, 0x000fe200018e0615ULL,
0x0000005968587210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff557224ULL, 0x000fe200010e0617ULL,
0x0000005b685a7210ULL, 0x040fe20007fbe0ffULL, 0x00000000460c7faeULL, 0x0003e2000b901c46ULL,
0x0000005d685c7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff577224ULL, 0x000fe200008e0619ULL,
0x0000005f685e7210ULL, 0x040fe20007f7e0ffULL, 0x000000004c0e7faeULL, 0x0003e2000b901c46ULL,
0x0000006568647210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff597224ULL, 0x000fe200000e061bULL,
0x0000006768667210ULL, 0x040fe20007f3e0ffULL, 0x000000004e107faeULL, 0x0003e2000b901c46ULL,
0x0000006968687210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff5b7224ULL, 0x000fc400028e061dULL,
0x0000000050127faeULL, 0x0003e2000b901c46ULL, 0x000000ffff5d7224ULL, 0x000fe400020e061fULL,
0x000000ffff5f7224ULL, 0x000fe200018e0621ULL, 0x0000000052147faeULL, 0x0003e2000b901c46ULL,
0x000000ffff657224ULL, 0x000fe400010e0623ULL, 0x000000ffff677224ULL, 0x000fe200008e0625ULL,
0x0000000054167faeULL, 0x0003e2000b901c46ULL, 0x000000ffff697224ULL, 0x000fc600000e0641ULL,
0x0000000056187faeULL, 0x0003e8000b901c46ULL, 0x00000000581a7faeULL, 0x0003e8000b901c46ULL,
0x000000005a1c7faeULL, 0x0003e8000b901c46ULL, 0x000000005c1e7faeULL, 0x0003e8000b901c46ULL,
0x000000005e207faeULL, 0x0003e8000b901c46ULL, 0x0000000064227faeULL, 0x0003e8000b901c46ULL,
0x0000000066247faeULL, 0x0003e8000b901c46ULL, 0x0000000068267faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001806087810ULL, 0x006fc80007ffe0ffULL,
0x0000000708087812ULL, 0x000fca00078e7827ULL, 0x0000002027087824ULL, 0x000fc800078e0208ULL,
0x0000001008077824ULL, 0x000fe200078e00ffULL, 0x0000001a06087810ULL, 0x000fc80007ffe0ffULL,
0x0000000708087812ULL, 0x000fe200078e7827ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002810783bULL, 0x000fe20000000200ULL, 0x0000002027087824ULL, 0x000fc600078e0208ULL,
0x00000000070c783bULL, 0x000e620000000200ULL, 0x0000001008087824ULL, 0x000fc600078e00ffULL,
0x000000002914783bULL, 0x000ea80000000200ULL, 0x000000002a18783bULL, 0x000ee80000000200ULL,
0x000000002b1c783bULL, 0x000f280000000200ULL, 0x000000002c20783bULL, 0x000fe80000000200ULL,
0x000000000808783bULL, 0x000f680000000200ULL, 0x000000007f44783bULL, 0x000ee80000000200ULL,
0x000000008080783bULL, 0x000ee80000000200ULL, 0x00000000a628783bULL, 0x000fe80000000200ULL,
0x00000000a44c783bULL, 0x000fe20000000200ULL, 0x000000100c60723cULL, 0x042fe60000001860ULL,
0x00000000a950783bULL, 0x000fe80000000200ULL, 0x00000000a854783bULL, 0x000fe20000000200ULL,
0x000000120c10723cULL, 0x040ff00000001870ULL, 0x000000140c6c723cULL, 0x044ff0000000186cULL,
0x000000160c30723cULL, 0x040ff00000001830ULL, 0x000000180c34723cULL, 0x048ff00000001834ULL,
0x0000001a0c38723cULL, 0x040fe20000001838ULL, 0x00000000a218783bULL, 0x000e6e0000000200ULL,
0x0000001c0c3c723cULL, 0x050fee000000183cULL, 0x0000001c061c7810ULL, 0x040fe20007ffe0ffULL,
0x0000001e0c48723cULL, 0x000fe20000001848ULL, 0x0000001e06067810ULL, 0x000fc40007ffe0ffULL,
0x000000071c1c7812ULL, 0x100fe400078e7827ULL, 0x0000000706067812ULL, 0x000fc600078e7827ULL,
0x00000020271c7824ULL, 0x040fe200078e021cULL, 0x00000020080c723cULL, 0x020fe20000001860ULL,
0x0000002027067824ULL, 0x000fe400078e0206ULL, 0x000000101c1c7824ULL, 0x000fe200078e00ffULL,
0x00000000aa24783bULL, 0x000fe20000000200ULL, 0x0000001006067824ULL, 0x000fc600078e00ffULL,
0x000000220810723cULL, 0x040fe20000001810ULL, 0x00000000a320783bULL, 0x000fe80000000200ULL,
0x000000001c1c783bULL, 0x000ea60000000200ULL, 0x000000440814723cULL, 0x040ff0000000186cULL,
0x000000460830723cULL, 0x040fe20000001830ULL, 0x00000000a544783bULL, 0x000eee0000000200ULL,
0x000000800834723cULL, 0x040ff00000001834ULL, 0x000000820838723cULL, 0x040ff00000001838ULL,
0x00000018083c723cULL, 0x042ff0000000183cULL, 0x0000001a0848723cULL, 0x000fe20000001848ULL,
0x00000000a718783bULL, 0x000fe80000000200ULL, 0x000000000608783bULL, 0x000e660000000200ULL,
0x000000201c0c723cULL, 0x044ff0000000180cULL, 0x000000221c10723cULL, 0x040ff00000001810ULL,
0x000000281c14723cULL, 0x040ff00000001814ULL, 0x0000002a1c30723cULL, 0x040ff00000001830ULL,
0x000000441c34723cULL, 0x048ff00000001834ULL, 0x000000461c38723cULL, 0x040ff00000001838ULL,
0x0000004c1c3c723cULL, 0x040ff0000000183cULL, 0x0000004e1c48723cULL, 0x000ff00000001848ULL,
0x00000018080c723cULL, 0x042ff0000000180cULL, 0x0000001a0810723cULL, 0x040ff00000001810ULL,
0x000000240814723cULL, 0x040ff00000001814ULL, 0x000000260830723cULL, 0x040ff00000001830ULL,
0x000000500834723cULL, 0x040ff00000001834ULL, 0x000000520838723cULL, 0x040ff00000001838ULL,
0x00000054083c723cULL, 0x040ff0000000183cULL, 0x000000560848723cULL, 0x000fe20000001848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x0000000002067f8cULL, 0x000fe2000c80043fULL,
0x3d8000000c0c7820ULL, 0x000fc40000410000ULL, 0x3d8000000d0d7820ULL, 0x000fe20000410000ULL,
0x0000040002097984ULL, 0x000e620000000800ULL, 0x3d8000000e0e7820ULL, 0x000fe40000410000ULL,
0x3d8000000f0f7820ULL, 0x000fe40000410000ULL, 0x3d80000010107820ULL, 0x000fe40000410000ULL,
0x3d80000011117820ULL, 0x000fe40000410000ULL, 0x3d80000012127820ULL, 0x000fc40000410000ULL,
0x3d80000013137820ULL, 0x000fe40000410000ULL, 0x3d80000014147820ULL, 0x000fe40000410000ULL,
0x3d80000015157820ULL, 0x000fe40000410000ULL, 0x3d80000016167820ULL, 0x000fe40000410000ULL,
0x3d80000017177820ULL, 0x000fe40000410000ULL, 0x3d80000030307820ULL, 0x000fc40000410000ULL,
0x3d80000031317820ULL, 0x000fe40000410000ULL, 0x3d80000032327820ULL, 0x000fe40000410000ULL,
0x3d80000033337820ULL, 0x000fe40000410000ULL, 0x3d80000034347820ULL, 0x000fe40000410000ULL,
0x3d80000035357820ULL, 0x000fe40000410000ULL, 0x3d80000036367820ULL, 0x000fc40000410000ULL,
0x3d80000037377820ULL, 0x000fe40000410000ULL, 0x3d80000038387820ULL, 0x000fe40000410000ULL,
0x3d80000039397820ULL, 0x000fe20000410000ULL, 0x8000000009ff7812ULL, 0x002fe20007804807ULL,
0x3d8000003a3a7820ULL, 0x000fe40000410000ULL, 0x3d8000003b3b7820ULL, 0x000fe40000410000ULL,
0x3d8000003c3c7820ULL, 0x000fc40000410000ULL, 0x3d8000003d3d7820ULL, 0x000fe40000410000ULL,
0x3d8000003e3e7820ULL, 0x000fe40000410000ULL, 0x3d8000003f3f7820ULL, 0x000fe40000410000ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe40000410000ULL,
0x000000ffff197224ULL, 0x000fe400078e000cULL, 0x000000ffff187224ULL, 0x000fe200078e000dULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x0000040002097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400077824ULL, 0x000fe200078e00ffULL, 0x000000037e00720cULL, 0x000fc80003f05270ULL,
0xfffffff007067812ULL, 0x000fca00078ec0ffULL, 0x000000807d067824ULL, 0x000fca00078e0206ULL,
0x01c4000006087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002000c7824ULL, 0x000fe400078e00ffULL, 0x000000017c1c7824ULL, 0x000fc600078e0a05ULL,
0x000000060c0c7812ULL, 0x000fc800078ec0ffULL, 0x000000010c057812ULL, 0x040fe400078efcffULL,
0x000000080c0d7812ULL, 0x040fe400078efcffULL, 0x0000001c0500720cULL, 0x080fe40003f26070ULL,
0x000000100c057812ULL, 0x000fe400078efcffULL, 0x0000001c0d00720cULL, 0x080fe40003f06070ULL,
0x0000001c0500720cULL, 0x000fc40003fc6070ULL, 0x000000110c0d7812ULL, 0x040fe400078efcffULL,
0x000000180c057812ULL, 0x040fe400078efcffULL, 0x0000001c0c00720cULL, 0x0c0fe40003f46070ULL,
0x0000001c0d00720cULL, 0x080fe40003fa6070ULL, 0x0000001c0500720cULL, 0x000fe40003f66070ULL,
0x000000090c1a7812ULL, 0x000fc400078efcffULL, 0x000000190c0d7812ULL, 0x040fe400078efcffULL,
0x000000200c057812ULL, 0x000fe400078efcffULL, 0xff7fffff0e0e7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40005000000ULL, 0xff7fffff0f0f7808ULL, 0x000fe40004800000ULL,
0xff7fffff18187808ULL, 0x000fc40004800000ULL, 0x0000001c1a00720cULL, 0x080fe40003f86070ULL,
0x0000001c0d00720cULL, 0x080fe40003f46070ULL, 0x0000001c0500720cULL, 0x000fe40003f26070ULL,
0x000000210c0d7812ULL, 0x040fe400078efcffULL, 0x000000280c057812ULL, 0x000fe400078efcffULL,
0xff7fffff12127808ULL, 0x000fc40004000000ULL, 0xff7fffff10107808ULL, 0x000fe40004000000ULL,
0xff7fffff13137808ULL, 0x000fe40006000000ULL, 0xff7fffff11117808ULL, 0x000fe40006000000ULL,
0x0000001c0d00720cULL, 0x080fe40003f06070ULL, 0x0000001c0500720cULL, 0x000fe40003f86070ULL,
0x000000290c0d7812ULL, 0x000fc400078efcffULL, 0x000000300c057812ULL, 0x000fe400078efcffULL,
0xff7fffff16167808ULL, 0x000fe40007000000ULL, 0xff7fffff14147808ULL, 0x000fe40007000000ULL,
0xff7fffff17177808ULL, 0x000fe40006800000ULL, 0xff7fffff15157808ULL, 0x000fe40006800000ULL,
0x0000001c0d00720cULL, 0x000fc40003fc6070ULL, 0x0000001c0500720cULL, 0x000fe40003fa6070ULL,
0x000000310c0d7812ULL, 0x040fe400078efcffULL, 0x000000380c057812ULL, 0x040fe400078efcffULL,
0x000000390c0c7812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40005800000ULL,
0xff7fffff30307808ULL, 0x000fc40005800000ULL, 0xff7fffff33337808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40005000000ULL, 0xff7fffff36367808ULL, 0x000fe40004800000ULL,
0xff7fffff34347808ULL, 0x000fe40004800000ULL, 0x0000001c0d00720cULL, 0x080fe40003f66070ULL,
0x0000001c0500720cULL, 0x000fc40003f46070ULL, 0x0000001c0c00720cULL, 0x000fe40003f26070ULL,
0xff7fffff37377808ULL, 0x000fe40004000000ULL, 0xff7fffff35357808ULL, 0x000fe40004000000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40006000000ULL, 0xff7fffff38387808ULL, 0x000fe40006000000ULL,
0xff7fffff3b3b7808ULL, 0x000fc40007000000ULL, 0xff7fffff39397808ULL, 0x000fe40007000000ULL,
0xff7fffff3e3e7808ULL, 0x000fe40006800000ULL, 0xff7fffff3c3c7808ULL, 0x000fe40006800000ULL,
0xff7fffff3f3f7808ULL, 0x000fe40005800000ULL, 0xff7fffff3d3d7808ULL, 0x000fe40005800000ULL,
0xff7fffff4a4a7808ULL, 0x000fc40005000000ULL, 0xff7fffff48487808ULL, 0x000fe40005000000ULL,
0xff7fffff4b4b7808ULL, 0x000fe40004800000ULL, 0xff7fffff49497808ULL, 0x000fe40004800000ULL,
0x0000001908057209ULL, 0x004fe40007810000ULL, 0x0000000e09087209ULL, 0x000fe40007810000ULL,
0x0000001805057209ULL, 0x000fe40007810000ULL, 0x0000000f08097209ULL, 0x000fc40007810000ULL,
0x0000001005087209ULL, 0x000fe40007810000ULL, 0x00000012090c7209ULL, 0x000fe40007810000ULL,
0x0000001108057209ULL, 0x000fe40007810000ULL, 0x000000130c097209ULL, 0x000fe40007810000ULL,
0x0000001405087209ULL, 0x000fe40007810000ULL, 0x00000016090c7209ULL, 0x000fc40007810000ULL,
0x0000001508057209ULL, 0x000fe40007810000ULL, 0x000000170c097209ULL, 0x000fe40007810000ULL,
0x0000003005087209ULL, 0x000fe40007810000ULL, 0x00000032090c7209ULL, 0x000fe40007810000ULL,
0x0000003108057209ULL, 0x000fe40007810000ULL, 0x000000330c097209ULL, 0x000fc40007810000ULL,
0x0000003405087209ULL, 0x000fe40007810000ULL, 0x00000036090c7209ULL, 0x000fe40007810000ULL,
0x0000003508057209ULL, 0x000fe40007810000ULL, 0x000000370c097209ULL, 0x000fe40007810000ULL,
0x0000003805087209ULL, 0x000fe40007810000ULL, 0x0000003a090c7209ULL, 0x000fc40007810000ULL,
0x0000003908057209ULL, 0x000fe40007810000ULL, 0x0000003b0c097209ULL, 0x000fe40007810000ULL,
0x0000003c05087209ULL, 0x000fe40007810000ULL, 0x0000003e090c7209ULL, 0x000fe40007810000ULL,
0x0000003d08057209ULL, 0x000fe40007810000ULL, 0x0000003f0c097209ULL, 0x000fc40007810000ULL,
0x0000004805087209ULL, 0x000fe40007810000ULL, 0x0000004a090c7209ULL, 0x000fe40007810000ULL,
0x0000004908087209ULL, 0x000fe40007810000ULL, 0x0000004b0c1e7209ULL, 0x000fe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0008057f89ULL, 0x0004e400000e0000ULL,
0x0000000508207209ULL, 0x00cfe20007810000ULL, 0x000018527f007947ULL, 0x000fea000b800000ULL,
0x0c401f001e057f89ULL, 0x000ea800000e0000ULL, 0x0c401f000a097f89ULL, 0x000ee800000e0000ULL,
0x0c401f000b087f89ULL, 0x000f2200000e0000ULL, 0x000000051e057209ULL, 0x004fc40007810000ULL,
0x000000090a0c7209ULL, 0x008fc60007810000ULL, 0x0c201f00051a7f89ULL, 0x002fe200000e0000ULL,
0x000000080b1c7209ULL, 0x010fc60007810000ULL, 0x0c201f0020097f89ULL, 0x000e6800000e0000ULL,
0x0c201f000c0d7f89ULL, 0x000ea800000e0000ULL, 0x0c201f001c1d7f89ULL, 0x00072200000e0000ULL,
0x0000000920087209ULL, 0x002fe40007810000ULL, 0x0000001a05097209ULL, 0x000fc40007810000ULL,
0x0000000d0c0a7209ULL, 0x004fe40007810000ULL, 0x3fb8aa3b08057820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff267424ULL, 0x000fe200078e00ffULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010805ULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010805ULL, 0x00000019000c7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe40000010805ULL, 0x3fb8aa3b18187823ULL, 0x000fc40000010805ULL,
0x3c003c00ff277424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010805ULL,
0x00000018000b7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b09197820ULL, 0x004fe40000410000ULL,
0x3fb8aa3b15157823ULL, 0x000fe40000010805ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010819ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010819ULL, 0x0000001000107308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc40000010819ULL, 0x3fb8aa3b0f0f7823ULL, 0x000fe40000010819ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010805ULL, 0x3fb8aa3b31317823ULL, 0x000fe20000010805ULL,
0x0000001100117308ULL, 0x000ea20000000800ULL, 0x0000000c0b0c723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010819ULL, 0xfffffffc000b7812ULL, 0x000fe200078ec0ffULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010819ULL, 0x3fb8aa3b32327823ULL, 0x000fc40000010819ULL,
0x0000000e000d7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b33337823ULL, 0x000fe40000010819ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010805ULL, 0x3fb8aa3b35357823ULL, 0x100fe40000010805ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010805ULL, 0x0000000f001e7308ULL, 0x000ee20000000800ULL,
0x00000010110e723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b39397823ULL, 0x000fc40000010805ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010819ULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010819ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe40000010819ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe40000010819ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe40000010805ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010805ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x0000000d1e0d723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b48487823ULL, 0x000fc40000010805ULL,
0x0000000fff247424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b49057823ULL, 0x000fe40000010805ULL,
0x0000001400147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010819ULL,
0x0000000b24247219ULL, 0x000fe200000006ffULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010819ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010819ULL, 0x00000000240b73a1ULL, 0x000ee200000e8000ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fe20000010819ULL, 0x00000012130f723eULL, 0x004fe200000000ffULL,
0x0000001500157308ULL, 0x000ea20000000800ULL, 0x00000000240473c4ULL, 0x000f6a0000004000ULL,
0x000000260c20723cULL, 0x002fe400000018ffULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000e620000000800ULL, 0x000000141510723eULL, 0x004fc400000000ffULL,
0x0000000524ff7c12ULL, 0x008fe4000f80400bULL, 0x0000001c1d0b7209ULL, 0x010fc60007810000ULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x000000303112723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000ff00000000800ULL,
0x0000003300137308ULL, 0x000e620000000800ULL, 0x000000161711723eULL, 0x004fce00000000ffULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x000000321313723eULL, 0x002fce00000000ffULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x000000261020723cULL, 0x000fee0000001820ULL,
0x0000003800387308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000ea20000000800ULL,
0x000000343514723eULL, 0x002fce00000000ffULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000383916723eULL, 0x004fce00000000ffULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003b00177308ULL, 0x000ea20000000800ULL,
0x000000363715723eULL, 0x002fce00000000ffULL, 0x0000003c00187308ULL, 0x000fe20000000800ULL,
0x0000003a1717723eULL, 0x004fce00000000ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x000000261420723cULL, 0x000fee0000001820ULL, 0x00000048001a7308ULL, 0x000ff00000000800ULL,
0x0000000500057308ULL, 0x000ea20000000800ULL, 0x000000183d18723eULL, 0x002fce00000000ffULL,
0x0000003e003e7308ULL, 0x000ff00000000800ULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x0000001a051a723eULL, 0x004fce00000000ffULL, 0x0000004a001b7308ULL, 0x000ff00000000800ULL,
0x0000004b001e7308ULL, 0x000ea20000000800ULL, 0x0000003e3f19723eULL, 0x002fe400000000ffULL,
0x0000001b1e1b723eULL, 0x004fce00000000ffULL, 0x000000261820723cULL, 0x000fe20000001820ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000147204008947ULL, 0x020fde000b800000ULL,
0x001c1fff201c7589ULL, 0x0002a400000e0000ULL, 0x00000000240573a1ULL, 0x000ee200000e8000ULL,
0x00000000240473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000524ff7c12ULL, 0x008fda000f804005ULL, 0x0000149204008947ULL, 0x010fea000b800000ULL,
0x001c1fff221d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff057819ULL, 0x000fe40000011600ULL,
0x0000000c07377812ULL, 0x002fc400078ec0ffULL, 0x0000000705207812ULL, 0x040fe200078ec0ffULL,
0x0000000805257824ULL, 0x040fe200078e00ffULL, 0x00000005ff237212ULL, 0x000fe200078e33ffULL,
0x0000000805217824ULL, 0x040fe200078e00ffULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x0000000805327824ULL, 0x040fe200078e00ffULL, 0x0000000805057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff825227812ULL, 0x108fe400078ee220ULL, 0x0000000121247812ULL, 0x100fe200078ef620ULL,
0x0000000805257824ULL, 0x000fe200078e00ffULL, 0x0000000221267812ULL, 0x100fe200078ef620ULL,
0x0000000805447824ULL, 0x000fe200078e00ffULL, 0x0000000321287812ULL, 0x000fc400078ef620ULL,
0x00000004212a7812ULL, 0x140fe400078ef620ULL, 0x00000005212c7812ULL, 0x140fe400078ef620ULL,
0x0000000621307812ULL, 0x000fe200078ef620ULL, 0x0000000805217824ULL, 0x040fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe400078ee223ULL, 0x00000005ff237212ULL, 0x000fe400078e33ffULL,
0x0000000705207812ULL, 0x000fc400078ec0ffULL, 0x000120007d057811ULL, 0x000fe400078e58ffULL,
0xfffffff825347812ULL, 0x100fe400078ee220ULL, 0x0000000121367812ULL, 0x140fe200078ef620ULL,
0x0000001022077824ULL, 0x000fe200078e0205ULL, 0xfffffff844447812ULL, 0x000fe200078ee223ULL,
0x0000001028227824ULL, 0x100fe200078e0205ULL, 0x0000000221387812ULL, 0x140fe200078ef620ULL,
0x0000001030287824ULL, 0x100fe200078e0205ULL, 0x00000003213a7812ULL, 0x140fe200078ef620ULL,
0x0000001036307824ULL, 0x000fe200078e0205ULL, 0x00000004213c7812ULL, 0x100fe200078ef620ULL,
0x0000000137077824ULL, 0x000fe200078e0207ULL, 0x00000005213e7812ULL, 0x140fe200078ef620ULL,
0x0000001038317824ULL, 0x100fe200078e0205ULL, 0x0000000621427812ULL, 0x000fe200078ef620ULL,
0x0000001024207824ULL, 0x100fe200078e0205ULL, 0x0000000c07007388ULL, 0x0003e20000000800ULL,
0x0000001026217824ULL, 0x000fc400078e0205ULL, 0x000000102a247824ULL, 0x100fe400078e0205ULL,
0x000000102c267824ULL, 0x100fe400078e0205ULL, 0x00000010322a7824ULL, 0x100fe400078e0205ULL,
0x00000010342c7824ULL, 0x100fe400078e0205ULL, 0x000000103a327824ULL, 0x100fe400078e0205ULL,
0x000000103c337824ULL, 0x000fc400078e0205ULL, 0x000000103e347824ULL, 0x100fe400078e0205ULL,
0x0000001042357824ULL, 0x100fe400078e0205ULL, 0x0000001044367824ULL, 0x000fe400078e0205ULL,
0x0000000137057824ULL, 0x040fe400078e0220ULL, 0x0000000137217824ULL, 0x040fe400078e0221ULL,
0x0000000137237824ULL, 0x040fe200078e0222ULL, 0x0000000e05007388ULL, 0x0007e20000000800ULL,
0x0000000137257824ULL, 0x000fc400078e0224ULL, 0x0000000137277824ULL, 0x040fe200078e0226ULL,
0x0000001021007388ULL, 0x0007e20000000800ULL, 0x0000000137297824ULL, 0x040fe400078e0228ULL,
0x00000001372b7824ULL, 0x040fe200078e022aULL, 0x0000001223007388ULL, 0x0007e20000000800ULL,
0x00000001372c7824ULL, 0x040fe400078e022cULL, 0x0000000137307824ULL, 0x040fe200078e0230ULL,
0x0000001425007388ULL, 0x0007e20000000800ULL, 0x0000000137207824ULL, 0x000fc400078e0231ULL,
0x0000000137327824ULL, 0x040fe200078e0232ULL, 0x0000001627007388ULL, 0x0007e20000000800ULL,
0x00000001370c7824ULL, 0x042fe400078e0233ULL, 0x0000000137347824ULL, 0x040fe200078e0234ULL,
0x0000001829007388ULL, 0x0007e20000000800ULL, 0x0000000137227824ULL, 0x040fe400078e0235ULL,
0x0000000137367824ULL, 0x000fe200078e0236ULL, 0x0000001a2b007388ULL, 0x0007e80000000800ULL,
0x0000000d2c007388ULL, 0x0007e80000000800ULL, 0x0000000f30007388ULL, 0x0007e80000000800ULL,
0x0000001120007388ULL, 0x0007e80000000800ULL, 0x0000001332007388ULL, 0x0007e80000000800ULL,
0x000000150c007388ULL, 0x0007e80000000800ULL, 0x0000001734007388ULL, 0x0007e80000000800ULL,
0x0000001922007388ULL, 0x0007e80000000800ULL, 0x0000001b36007388ULL, 0x0007e80000000800ULL,
0x01c0000806008388ULL, 0x0007e80000000c00ULL, 0x01c2001c06008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080004ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6100004ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6180004ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000794000720cULL, 0x000fe20003f06070ULL,
0x01c6200004ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff7e7224ULL, 0x000fd600078e0040ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff942000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x004fe20004800000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00017cb0002d7802ULL, 0x000fe40000000f00ULL,
0x0000107000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e002bULL,
0xfffea97000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005000000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00017d10002d7802ULL, 0x000fe40000000f00ULL,
0x0000101000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e002bULL,
0xfffea99000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e000aULL,
0x00017d8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x00000f6000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0034ULL, 0xfffea9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x000fe200078e000aULL, 0x00017df000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x00000ef000007944ULL, 0x01cfea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e0034ULL,
0xfffea98000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x000fe200078e000aULL,
0x00017e6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x00000e8000007944ULL, 0x008fea0003c00000ULL,
0x000000080a087810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0034ULL,
0x00017ed000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x002fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x000000ffff367224ULL, 0x000fe400078e0008ULL,
0x00000e1000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff767224ULL, 0x004fe200078e0034ULL,
0xfffeabb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004800000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00017f30002d7802ULL, 0x000fe40000000f00ULL,
0x00000df000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff277224ULL, 0x000fe200078e002bULL,
0xfffed24000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005000000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00017f90002d7802ULL, 0x000fe40000000f00ULL,
0x00000d9000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff277224ULL, 0x000fe200078e002bULL,
0xfffed26000007947ULL, 0x000fea000383ffffULL, 0x0000001fff377424ULL, 0x002fe200078e00ffULL,
0x00017ff000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x00000cf000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e0034ULL,
0xfffed2b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x002fe200078e0008ULL,
0x0001806000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x00000c8000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff277224ULL, 0x004fe200078e0034ULL, 0xfffed36000007947ULL, 0x000fea000383ffffULL,
0x0000001fff377424ULL, 0x000fe200078e00ffULL, 0x000180c000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x00000c2000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff257224ULL, 0x004fe200078e0034ULL, 0x0001812000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff367224ULL, 0x002fe400078e0008ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x00000bc000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2e7224ULL, 0x004fe200078e0034ULL, 0xfffed4a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004800000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x00018180002d7802ULL, 0x000fc40000000f00ULL, 0x00000ba000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xfffef73000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005000000ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x000181e0002d7802ULL, 0x000fc40000000f00ULL, 0x00000b4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff287224ULL, 0x000fe200078e002bULL, 0xfffef75000007947ULL, 0x000fea000383ffffULL,
0x0000001fff377424ULL, 0x002fe200078e00ffULL, 0x0001824000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fc400078e00ffULL, 0x00000aa000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff287224ULL, 0x004fe200078e0034ULL, 0xfffef7a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff367224ULL, 0x002fe200078e0008ULL, 0x000182b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x00000a3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff287224ULL, 0x004fe200078e0034ULL,
0xfffef85000007947ULL, 0x000fea000383ffffULL, 0x0000001fff377424ULL, 0x000fe200078e00ffULL,
0x0001831000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x000009d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff277224ULL, 0x004fe200078e0034ULL,
0x0001837000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x002fe400078e0008ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff387424ULL, 0x000fe400078e00ffULL,
0x0000097000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0034ULL,
0xfffef98000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x000183d0002d7802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e002bULL,
0xffff1cf000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20004800000ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00018430002d7802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff177224ULL, 0x000fe200078e002bULL,
0xffff1d1000007947ULL, 0x000fea000383ffffULL, 0x0000001fff377424ULL, 0x002fe200078e00ffULL,
0x0001849000287802ULL, 0x000fe20000000f00ULL, 0xffffffffff387424ULL, 0x000fc400078e00ffULL,
0x0000085000007944ULL, 0x028fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0034ULL,
0xffff1d6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff367224ULL, 0x002fe200078e0008ULL,
0x0001850000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x000007e000007944ULL, 0x028fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0034ULL, 0xffff1e1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff377424ULL, 0x000fe200078e00ffULL, 0x0001856000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000078000007944ULL, 0x020fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0034ULL, 0x000185c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff367224ULL, 0x002fe400078e0008ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff387424ULL, 0x000fe400078e00ffULL, 0x0000072000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0034ULL, 0xffff1f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff057224ULL, 0x000fe200078e0008ULL, 0x00018640000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x000fc400078e00ffULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x0000066000007944ULL, 0x002fea0003c00000ULL,
0xffffe79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff057224ULL, 0x000fe200078e001eULL,
0x000186b0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x002fe400078e00ffULL,
0x0000001fff1b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff227424ULL, 0x000fe400078e00ffULL,
0x000005f000007944ULL, 0x000fea0003c00000ULL, 0x000000051e1e7209ULL, 0x004fe20007810000ULL,
0x000000ffff057224ULL, 0x000fe200078e000aULL, 0x00018720000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff1a7424ULL, 0x002fc400078e00ffULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x0000058000007944ULL, 0x000fea0003c00000ULL,
0x000000050a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff057224ULL, 0x000fe200078e000bULL,
0x00018790000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff1a7424ULL, 0x002fe400078e00ffULL,
0x0000001fff1b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff227424ULL, 0x000fe400078e00ffULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000050b1c7209ULL, 0x004fe20007810000ULL,
0x000000ffff057224ULL, 0x000fe200078e0020ULL, 0x00018800000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff1a7424ULL, 0x002fc400078e00ffULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000000520087209ULL, 0x004fe20007810000ULL, 0x000000ffff057224ULL, 0x000fe200078e001eULL,
0x00018870000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x002fe400078e00ffULL,
0x0000001fff1b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff227424ULL, 0x000fe400078e00ffULL,
0x0000043000007944ULL, 0x000fea0003c00000ULL, 0x000000051e097209ULL, 0x004fe20007810000ULL,
0x000000ffff057224ULL, 0x000fe200078e000aULL, 0x000188e0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff1a7424ULL, 0x002fc400078e00ffULL, 0x0000001fff1b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff227424ULL, 0x000fe400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000050a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff057224ULL, 0x000fe200078e001cULL,
0x00018950000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff1a7424ULL, 0x002fe400078e00ffULL,
0x0000001fff1b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff227424ULL, 0x000fe400078e00ffULL,
0x0000035000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x004fe200078e0005ULL,
0xffffe56000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0020ULL,
0x000189d000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fc400078e00ffULL,
0x00001c1fff377424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fe400078e0024ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x004fe200078e0034ULL,
0xffffeb2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x002fe200078e0022ULL,
0x00018a5000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fe400078e00ffULL,
0x00001c1fff377424ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fe400078e0024ULL,
0x0000029000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff367224ULL, 0x002fe200078e00ffULL,
0x00018ab000287802ULL, 0x000fe20000000f00ULL, 0x00001c1fff377424ULL, 0x000fc400078e00ffULL,
0x000000ffff387224ULL, 0x000fe400078e0024ULL, 0x000000ffff1d7224ULL, 0x004fe400078e0034ULL,
0x0000023000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff387224ULL, 0x002fe200078e0024ULL,
0x00018b1000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff367224ULL, 0x000fe400078e00ffULL,
0x00001c1fff377424ULL, 0x000fe400078e00ffULL, 0x000000ffff1e7224ULL, 0x004fe400078e0034ULL,
0x000001d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x004fe200078e0034ULL,
0xffffea6000007947ULL, 0x000fea000383ffffULL, 0x0180000006057810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000005157812ULL, 0x000fc800078ec0ffULL,
0x018000001500780cULL, 0x000fda0003f05070ULL, 0x0000000600058308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff1500720cULL, 0x040fe40003f25070ULL,
0x008000001500780cULL, 0x000fe40003f02070ULL, 0x00000001ff167807ULL, 0x000fe40000800000ULL,
0x00000001ff057807ULL, 0x004fc80004000000ULL, 0x0000000516ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000006067812ULL, 0x002fe400078ec0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x0000000516ff7212ULL, 0x000fda000780c0ffULL, 0x0080000006050812ULL, 0x000fe200078efcffULL,
0x000000ffff058224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000600057308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff157424ULL, 0x000fc800078e00ffULL, 0xfffe736014007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000002200007348ULL, 0x000fe80003800000ULL,
0x0c00001a05057389ULL, 0x0002a200000e001bULL, 0xfffe73200c007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff297424ULL, 0x000fe200078e00ffULL, 0x0000003800007348ULL, 0x000fe80003800000ULL,
0x0000003635347389ULL, 0x0002a200000e0037ULL, 0xfffe72e028007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f45070ULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x00000000ff297424ULL, 0x000fd000078e00ffULL, 0x0000000000287806ULL, 0x000fc800050e0100ULL,
0x0000002b282b7212ULL, 0x000fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fc800078e002dULL,
0xfffe727028007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000320ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000900ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000990ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fe0ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001010ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000001030ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000010c8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000010d8ULL, 0x00000000000001b8ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001300ULL, 0x0000000000018e80ULL, 0xd700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a180ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x000000000001a190ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x000000000001a190ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x000000000001a610ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000010c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000190c0ULL, 0x00000000000190c0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x000000000001a180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x000000000001a610ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 108272;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
