/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017f90ULL, 0x0000000000017b10ULL, 0x0038004000560556ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x00000000000165e0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000016750ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000016790ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x00000000000167d0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000016900ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000165e000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x0058300400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0xa808288080980828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a8920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x000165e000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080980828808081ULL,
0x8c08288080a80828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808c920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x0001675000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9808288080a80828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808098920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x0000017000000000ULL, 0x0001679000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x9808288080a80828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808098920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x000167d000000000ULL,
0x0000013000000000ULL, 0x0000000000000000ULL, 0x0000001200082f04ULL, 0x0008120400000077ULL,
0x000000000000000dULL, 0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL,
0x0000000c00081104ULL, 0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL,
0x0008120400000000ULL, 0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000007c00043704ULL, 0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL,
0x0048000700000000ULL, 0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000020001c3104ULL, 0x000150e000014b90ULL, 0x000151a0000150f0ULL, 0x000151c0000151b0ULL,
0xffffffff01a82904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0500002bffffffffULL, 0x0500002b0500002bULL, 0xffffffff0500002bULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x01a82804ffffffffULL, 0x00000110000000f0ULL, 0x00001f60000012a0ULL,
0x0000208000001fe0ULL, 0x000023b0000020b0ULL, 0x00002430000023c0ULL, 0x00002970000024a0ULL,
0x0000359000003580ULL, 0x0000440000003800ULL, 0x0000453000004480ULL, 0x0000483000004650ULL,
0x000048a000004840ULL, 0x00004ba000004900ULL, 0x0000567000005660ULL, 0x0000654000005940ULL,
0x00006670000065c0ULL, 0x0000697000006790ULL, 0x000069e000006980ULL, 0x00006ce000006a40ULL,
0x000077b0000077a0ULL, 0x0000868000007a80ULL, 0x000087b000008700ULL, 0x00008ab0000088d0ULL,
0x00008b2000008ac0ULL, 0x00008e5000008b80ULL, 0x0000992000009910ULL, 0x00009d8000009d70ULL,
0x0000c3400000a670ULL, 0x0000c9c00000c510ULL, 0x0000d2300000ca00ULL, 0x00014a9000014a60ULL,
0x00014ab000014aa0ULL, 0x00014af000014ad0ULL, 0x00014b2000014b10ULL, 0x000151f000015190ULL,
0x0001521000015200ULL, 0x0001597000015920ULL, 0x00015a50000159e0ULL, 0x00015b3000015ac0ULL,
0x00015bd000015b80ULL, 0x00015ca000015c30ULL, 0x00015d6000015d00ULL, 0x00015e0000015db0ULL,
0x00015ed000015e60ULL, 0x00015f9000015f30ULL, 0x0001603000015fe0ULL, 0x0001610000016090ULL,
0x000161c000016160ULL, 0x0001627000016210ULL, 0x00016310000162c0ULL, 0x000163b000016360ULL,
0x0001645000016400ULL, 0x00016520000164b0ULL, 0x000165c000016570ULL, 0x0000021002003904ULL,
0x00014600000000ffULL, 0x00000250003f0100ULL, 0x000146080000000bULL, 0x000002c0003f0120ULL,
0x000146880000000bULL, 0x00000480003f0120ULL, 0x00014600000000ffULL, 0x000005a0003f0107ULL,
0x0001468c00000064ULL, 0x00000650003f0102ULL, 0x0001468800000064ULL, 0x00001dd0003f0101ULL,
0x0001460800000064ULL, 0x00001de0003f0101ULL, 0x0001460c00000064ULL, 0x00001e70003f0105ULL,
0x0001460c00000064ULL, 0x000037d0003f0105ULL, 0x00014688000000ffULL, 0x000042d0003f0101ULL,
0x0001462800000064ULL, 0x000042e0003f0101ULL, 0x0001462c00000064ULL, 0x00004370003f0105ULL,
0x0001462c00000064ULL, 0x00005910003f0105ULL, 0x00014690000000ffULL, 0x00006410003f0101ULL,
0x0001464800000064ULL, 0x00006420003f0101ULL, 0x0001464c00000064ULL, 0x000064b0003f0105ULL,
0x0001464c00000064ULL, 0x00007a50003f0105ULL, 0x00014698000000ffULL, 0x00008550003f0101ULL,
0x0001466800000064ULL, 0x00008560003f0101ULL, 0x0001466c00000064ULL, 0x000085f0003f0105ULL,
0x0001466c00000064ULL, 0x00009bc0003f0105ULL, 0x000146a0000000ffULL, 0x0000d510003f0101ULL,
0x00014600000000ffULL, 0x0000dfe0003f0101ULL, 0x00014604000000ffULL, 0x0000e080003f0105ULL,
0x00014604000000ffULL, 0x00014020003f0105ULL, 0x0000000000000005ULL, 0x00014060003f0101ULL,
0x0000000400000005ULL, 0x00014360003f0105ULL, 0x0000000400000005ULL, 0x00015780003f0105ULL,
0x0001460800000007ULL, 0x000157e0003f0101ULL, 0x0001461000000007ULL, 0x00015840003f0101ULL,
0x0001461800000007ULL, 0x000158b0003f0101ULL, 0x0001462000000007ULL, 0x00033803003f0101ULL,
0x0000d49000101c04ULL, 0x0000e1600000e0e0ULL, 0x00000401000158f0ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL,
0xfffffffd00000000ULL, 0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x0000000000000008ULL, 0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL,
0x000000000000025cULL, 0x0000001200000002ULL, 0x00000000000001dcULL, 0x0000001200000002ULL,
0x000000000000015cULL, 0x0000001200000002ULL, 0x00000000000000dcULL, 0x0000001200000002ULL,
0x0000000000000044ULL, 0x0000001200000002ULL, 0x0000000000000232ULL, 0x0000001200000002ULL,
0x00000000000001b2ULL, 0x0000001200000002ULL, 0x0000000000000132ULL, 0x0000001200000002ULL,
0x00000000000000b2ULL, 0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff057624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000d7919ULL, 0x000ea20000002300ULL,
0x0000001200027300ULL, 0x000ee400000e0000ULL, 0x0000000305057819ULL, 0x000fe200000006ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x00000000000e7919ULL, 0x000f220000002600ULL,
0x0000001200127309ULL, 0x000f660000000000ULL, 0x0000000000637919ULL, 0x000ee80000002700ULL,
0x0000000000037919ULL, 0x000f620000000000ULL, 0x00000005ff607819ULL, 0x002fc6000001160bULL,
0x0000000000047919ULL, 0x000e680000000000ULL, 0x00001fff60607589ULL, 0x000fe200000e0000ULL,
0x000000010d007824ULL, 0x004fc600078e0200ULL, 0x00001fff0d0d7589ULL, 0x000ea200000e0000ULL,
0x00000080000b7824ULL, 0x000fe400078e020bULL, 0x000000080e007824ULL, 0x010fc600078e00ffULL,
0x000000ff0b00720cULL, 0x000fe20003f25270ULL, 0x0000006305007224ULL, 0x008fe200078e0200ULL,
0x0000000f0b00780cULL, 0x040fe40003f44070ULL, 0x0000007f0b00780cULL, 0x040fe40003f84070ULL,
0x000000030b00780cULL, 0x000fe40003f64070ULL, 0x000000030200720cULL, 0x020fe20003f02070ULL,
0x00000010040c7824ULL, 0x002fc800078e00ffULL, 0x3fffff80ff029424ULL, 0x000fe200078e00ffULL,
0x000001f00c137812ULL, 0x000fe200078ec0ffULL, 0x7fffff80ff039424ULL, 0x000fe200078e00ffULL,
0x7fffffc00007a802ULL, 0x000fe20000000f00ULL, 0x000000040d057824ULL, 0x004fe400078e0260ULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01460002ff009388ULL, 0x0003e20000000a00ULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x00000001050f7819ULL, 0x000fe200000006ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x014608060b00a388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000080f0a7817ULL, 0x040fe20007800000ULL,
0x00000200ff057424ULL, 0x000fe200078e00ffULL, 0x014400100b00c388ULL, 0x000fe20000004800ULL,
0x000000010f117810ULL, 0x000fe20007ffe0ffULL, 0x0000000100027824ULL, 0x002fc400078e020fULL,
0x014688080b00b388ULL, 0x0003e20000008a00ULL, 0x000000010a0a7824ULL, 0x000fe400078e0a0fULL,
0x00005c0002027625ULL, 0x000fe200078e0005ULL, 0x0000001100067210ULL, 0x004fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000ff0a00720cULL, 0x040fe40003f23070ULL,
0x000000010a00780cULL, 0x000fe20003f43070ULL, 0x00005c0006067625ULL, 0x000fe200078e0005ULL,
0x000000070f097812ULL, 0x002fc400078ec0ffULL, 0x00000007110b7812ULL, 0x000fe400078ec0ffULL,
0x0000001f09007812ULL, 0x100fe400078e7804ULL, 0x0000001302087210ULL, 0x080fe40007f7e0ffULL,
0x0000001f0b027812ULL, 0x000fe200078e7804ULL, 0x000000200f007824ULL, 0x000fe200078e0200ULL,
0x0000001306067210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fe400018e0603ULL,
0x0000002011027824ULL, 0x000fe200078e0202ULL, 0x00000004000b7819ULL, 0x000fe200000006ffULL,
0x000000ffff077224ULL, 0x000fc400020e0607ULL, 0x00000010020f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe200078e0a12ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c901c46ULL, 0x00000004ff027424ULL, 0x000fc600078e00ffULL,
0x00000000060f7faeULL, 0x0003e2000d101c46ULL, 0x0000600063027625ULL, 0x000fc600078e0002ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01460400ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01460000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000602177981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000004ff617e24ULL, 0x008fe2000f8e00ffULL,
0x000000ff17007810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff007819ULL, 0x000fce0000011600ULL,
0x0000cf3000008947ULL, 0x000fea0003800000ULL, 0x0000000360647819ULL, 0x000fe200000006ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01468c0364ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000161037810ULL, 0x002fe20007ffe0ffULL, 0x0000000263637824ULL, 0x000fe200078e00ffULL,
0x000058000e027a10ULL, 0x000fe20007ffe0ffULL, 0x0000010061067824ULL, 0x000fe200078e00ffULL,
0x000000000300720cULL, 0x000fe20003f06070ULL, 0x0146880064ff7f8cULL, 0x0003e4000c80043fULL,
0x0000580063637a24ULL, 0x000fc800078e0202ULL, 0x0000620063107a24ULL, 0x000fcc00078e0206ULL,
0x0000059000008947ULL, 0x000fea0003800000ULL, 0x0000000617027217ULL, 0x002fe20007800000ULL,
0x0000000860137824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x100fe40000011604ULL,
0x0000000206027210ULL, 0x000fe40007ffe1ffULL, 0x0000000707037812ULL, 0x100fe200078e4804ULL,
0x0000000110087824ULL, 0x000fe200078e0207ULL, 0x0000002002067817ULL, 0x000fe40003800000ULL,
0x0ffffff803097812ULL, 0x000fe200078ef804ULL, 0x00005e0008027625ULL, 0x000fe200078e0005ULL,
0x000000060700720cULL, 0x000fc40003f06070ULL, 0xfffffff813137812ULL, 0x000fe400078ee204ULL,
0x0000c00060127811ULL, 0x000fe400078e68ffULL, 0x00000004070b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001013027825ULL, 0x000fe200078e0002ULL, 0x0000000c070f7810ULL, 0x040fe40007ffe0ffULL,
0x00000008070d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b157824ULL, 0x000fe200078e00ffULL,
0x0000001209097211ULL, 0x000fe200078e20ffULL, 0x000000080f1b7824ULL, 0x000fe200078e00ffULL,
0x00000014071d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x0000001007117810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c101c46ULL, 0x00000018071f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d167824ULL, 0x000fe200078e00ffULL, 0x0000001c07217810ULL, 0x000fc40007ffe0ffULL,
0x000000040b087212ULL, 0x080fe200078e3cffULL, 0x00000001100e7824ULL, 0x040fe200078e021fULL,
0x000000040f0c7212ULL, 0x080fe200078e3cffULL, 0x00000008211a7824ULL, 0x000fe200078e00ffULL,
0x000000040d0a7212ULL, 0x080fe400078e3cffULL, 0x0000000311147819ULL, 0x040fe200000006ffULL,
0x0000000110027824ULL, 0x002fe200078e020bULL, 0x0000000411037212ULL, 0x000fe400078e3cffULL,
0x000000060b00720cULL, 0x000fc40003f06070ULL, 0x000000060d00720cULL, 0x080fe40003f26070ULL,
0x000000060f00720cULL, 0x080fe40003f46070ULL, 0x000000061100720cULL, 0x080fe40003f66070ULL,
0x000000061d00720cULL, 0x080fe40003f86070ULL, 0x000000061f00720cULL, 0x080fe40003fa6070ULL,
0x000000062100720cULL, 0x000fe20003fc6070ULL, 0x0000000110067824ULL, 0x000fe200078e020dULL,
0x000000041d077212ULL, 0x000fc400078e3cffULL, 0xfffffff815157812ULL, 0x000fe200078ee208ULL,
0x0000000110087824ULL, 0x040fe200078e020fULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x00000001100c7824ULL, 0x000fe200078e021dULL, 0x000000041f097212ULL, 0x0c0fe200078e3cffULL,
0x00005e000e0e7625ULL, 0x080fe200078e0005ULL, 0x000000031f187819ULL, 0x000fe400000006ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x00000001100a7824ULL, 0x040fe200078e0211ULL,
0x00000004210b7212ULL, 0x000fe200078e3cffULL, 0x0000000110107824ULL, 0x000fe200078e0221ULL,
0xfffffff8141d7812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x000fe200078e0005ULL,
0xfffffff8161f7812ULL, 0x000fc400078ee207ULL, 0xfffffff818217812ULL, 0x000fe200078ee209ULL,
0x00005e0006067625ULL, 0x080fe200078e0005ULL, 0xfffffff81a237812ULL, 0x000fe400078ee20bULL,
0x000000121d1d7211ULL, 0x000fe200078e20ffULL, 0x00005e0008087625ULL, 0x000fc800078e0005ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0005ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0005ULL,
0x00005e0010107625ULL, 0x000fc800078e0005ULL, 0x0000001013027825ULL, 0x000fc800078e0002ULL,
0x0000001015157824ULL, 0x000fe400078e0212ULL, 0x0000001013067825ULL, 0x000fc600078e0006ULL,
0x0000000002157faeULL, 0x0003e2000c101c46ULL, 0x0000001019197824ULL, 0x000fe400078e0212ULL,
0x0000001013087825ULL, 0x000fc600078e0008ULL, 0x0000000006197faeULL, 0x0003e2000c901c46ULL,
0x000000101b1b7824ULL, 0x000fe400078e0212ULL, 0x00000010130a7825ULL, 0x000fc600078e000aULL,
0x00000000081b7faeULL, 0x0003e2000d101c46ULL, 0x00000010130c7825ULL, 0x000fc600078e000cULL,
0x000000000a1d7faeULL, 0x0003e2000d901c46ULL, 0x000000101f1f7824ULL, 0x000fe400078e0212ULL,
0x00000010130e7825ULL, 0x000fc600078e000eULL, 0x000000000c1f7faeULL, 0x0003e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe400078e0212ULL, 0x0000001013107825ULL, 0x000fc600078e0010ULL,
0x000000000e217faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fca00078e0212ULL,
0x0000000010237faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x002fe20000011604ULL, 0x0000000860157824ULL, 0x040fe200078e00ffULL,
0x0000c00060147811ULL, 0x000fe400078e68ffULL, 0x0000000c030d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000403097810ULL, 0x040fe40007ffe0ffULL, 0x00000008030b7810ULL, 0x000fe20007ffe0ffULL,
0x000000080d087824ULL, 0x040fe200078e00ffULL, 0x000000040d077212ULL, 0x080fe200078e3cffULL,
0x00000008091b7824ULL, 0x040fe200078e00ffULL, 0x0000000409027212ULL, 0x080fe200078e3cffULL,
0x00000001100a7824ULL, 0x000fe200078e020dULL, 0x000000040b067212ULL, 0x000fc400078e3cffULL,
0x000000030b1d7819ULL, 0x000fe400000006ffULL, 0xfffffff8081f7812ULL, 0x000fe400078ee207ULL,
0x00000010030f7810ULL, 0x040fe40007ffe0ffULL, 0x0000000703077812ULL, 0x000fe200078e4804ULL,
0x000000101f1f7824ULL, 0x000fe200078e0214ULL, 0x0000001403117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f187824ULL, 0x000fe200078e00ffULL, 0x0000001803137810ULL, 0x040fe20007ffe0ffULL,
0x00000001100c7824ULL, 0x040fe200078e020fULL, 0x0000001c03197810ULL, 0x000fe20007ffe0ffULL,
0x00000001100e7824ULL, 0x040fe200078e0211ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL,
0x0000000110027824ULL, 0x040fe200078e0203ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x0000000110067824ULL, 0x040fe200078e0209ULL, 0x0ffffff807077812ULL, 0x000fe200078ef804ULL,
0x0000000110127824ULL, 0x040fe200078e0213ULL, 0x0000000b10087210ULL, 0x040fe20007ffe0ffULL,
0x0000000110167824ULL, 0x000fe200078e0219ULL, 0x000000040f097212ULL, 0x080fe200078e3cffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x00000004110b7212ULL, 0x080fe200078e3cffULL,
0x00000008191c7824ULL, 0x000fe200078e00ffULL, 0x00000003111a7819ULL, 0x000fe200000006ffULL,
0x00005e0002027625ULL, 0x000fe200078e0005ULL, 0x00000004130d7212ULL, 0x000fc400078e3cffULL,
0x00000004190f7212ULL, 0x000fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0214ULL,
0x0000001407197211ULL, 0x000fe200078e20ffULL, 0x00005e0006067625ULL, 0x080fe200078e0005ULL,
0xfffffff815157812ULL, 0x000fe400078ee204ULL, 0xfffffff818217812ULL, 0x000fe200078ee209ULL,
0x00005e0008087625ULL, 0x080fe200078e0005ULL, 0xfffffff81a237812ULL, 0x000fe400078ee20bULL,
0xfffffff810257812ULL, 0x000fe200078ee20dULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0xfffffff81c277812ULL, 0x000fc400078ee20fULL, 0x0000001423237211ULL, 0x000fe200078e20ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0005ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0005ULL,
0x0000001015027825ULL, 0x000fc800078e0002ULL, 0x00005e0012107625ULL, 0x080fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002197faeULL, 0x0003e6000b901c46ULL,
0x00005e0016127625ULL, 0x000fc800078e0005ULL, 0x0000001015067825ULL, 0x000fc800078e0006ULL,
0x0000001015087825ULL, 0x000fe200078e0008ULL, 0x00000000061b7faeULL, 0x0003e6000b901c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e0214ULL, 0x00000010150a7825ULL, 0x000fc600078e000aULL,
0x00000000081d7faeULL, 0x0003e2000b901c46ULL, 0x00000010150c7825ULL, 0x000fc600078e000cULL,
0x000000000a1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001021217824ULL, 0x000fe400078e0214ULL,
0x00000010150e7825ULL, 0x000fc600078e000eULL, 0x000000000c217faeULL, 0x0003e2000b901c46ULL,
0x0000001015107825ULL, 0x000fc600078e0010ULL, 0x000000000e237faeULL, 0x0003e2000b901c46ULL,
0x0000001025257824ULL, 0x000fe400078e0214ULL, 0x0000001015127825ULL, 0x000fc600078e0012ULL,
0x0000000010257faeULL, 0x0003e2000b901c46ULL, 0x0000001027277824ULL, 0x000fca00078e0214ULL,
0x0000000012277faeULL, 0x0003e4000b901c46ULL, 0x000000006100720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff627424ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x000089d000000947ULL, 0x000fea0003800000ULL,
0xff31721700627802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e00ffULL,
0x0000010061027824ULL, 0x000fca00078e00ffULL, 0x000000170200720cULL, 0x000fda0003f06070ULL,
0x0000894000000947ULL, 0x000fea0003800000ULL, 0x0000000161037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000000300720cULL, 0x000fe40003f06070ULL,
0x0000002061107811ULL, 0x000fca00078e40ffULL, 0x00006200630e7a24ULL, 0x000fcc00078e0210ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000003ff0d7819ULL, 0x000fe20000011604ULL,
0x00000200ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001017037217ULL, 0x000fe40007800000ULL,
0x000000040d0b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000704057812ULL, 0x000fe400078ec0ffULL,
0x0000000310037210ULL, 0x000fe20007ffe1ffULL, 0x000000080b137824ULL, 0x040fe200078e00ffULL,
0x000000040b027212ULL, 0x000fe200078e3cffULL, 0x0000000164117824ULL, 0x000fe200078e0205ULL,
0x0000002003057817ULL, 0x000fe20003800000ULL, 0x000000010b067824ULL, 0x000fe200078e020eULL,
0x000000080d157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x000000010d027824ULL, 0x040fe200078e020eULL, 0x000000070d077812ULL, 0x000fe200078e4804ULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0d197810ULL, 0x040fe20007ffe0ffULL,
0x00005e0002027625ULL, 0x000fe200078e000fULL, 0x0000d00060127811ULL, 0x000fe400078e68ffULL,
0x000000050d00720cULL, 0x080fe40003f26070ULL, 0x000000050b00720cULL, 0x000fe20003f46070ULL,
0x00000010130b7824ULL, 0x000fe200078e0212ULL, 0x0ffffff807097812ULL, 0x000fe200078ef804ULL,
0x00005e0006067625ULL, 0x000fe200078e000fULL, 0x0000000415087212ULL, 0x000fc400078e3cffULL,
0x00000004190a7212ULL, 0x000fe200078e3cffULL, 0x0000001011027825ULL, 0x000fe200078e0002ULL,
0x0000000319217819ULL, 0x000fe400000006ffULL, 0xfffffff81b137812ULL, 0x000fe200078ee208ULL,
0x0000001009097824ULL, 0x000fe200078e0212ULL, 0xfffffff8211b7812ULL, 0x000fe200078ee20aULL,
0x0000001011067825ULL, 0x000fe200078e0006ULL, 0x000000100d217810ULL, 0x040fe40007ffe0ffULL,
0x000000140d237810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002097faeULL, 0x0003e2000c901c46ULL, 0x000000180d257810ULL, 0x000fe20007ffe0ffULL,
0x0000000821187824ULL, 0x000fe200078e00ffULL, 0x0000001c0d0d7810ULL, 0x000fe20007ffe0ffULL,
0x00000000060b7faeULL, 0x0005e2000d101c46ULL, 0x0000000e21087210ULL, 0x000fe20007ffe0ffULL,
0x0000000825207824ULL, 0x000fe200078e00ffULL, 0x000000051500720cULL, 0x080fe20003f26070ULL,
0x000000080d227824ULL, 0x000fe200078e00ffULL, 0x000000051900720cULL, 0x080fe20003f46070ULL,
0x00000001230a7824ULL, 0x100fe200078e020eULL, 0x000000052100720cULL, 0x000fe20003f66070ULL,
0x0000000115027824ULL, 0x102fe200078e020eULL, 0x0000000421037212ULL, 0x080fe200078e3cffULL,
0x00000001250c7824ULL, 0x100fe200078e020eULL, 0x000000040d097212ULL, 0x080fe200078e3cffULL,
0x0000000119067824ULL, 0x004fe200078e020eULL, 0x0000000425077212ULL, 0x000fe200078e3cffULL,
0x00000008231a7824ULL, 0x000fe200078e00ffULL, 0x0000000e0d0e7210ULL, 0x000fe20007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e000fULL, 0x000000052300720cULL, 0x000fc40003f86070ULL,
0x000000052500720cULL, 0x080fe40003fa6070ULL, 0x000000050d00720cULL, 0x000fe20003fc6070ULL,
0x00005e000c0c7625ULL, 0x080fe200078e000fULL, 0x0000000423057212ULL, 0x000fe400078e3cffULL,
0xfffffff818157812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x080fe200078e000fULL,
0xfffffff820217812ULL, 0x000fe400078ee207ULL, 0xfffffff822237812ULL, 0x000fe200078ee209ULL,
0x00005e0006067625ULL, 0x000fe200078e000fULL, 0xfffffff81a197812ULL, 0x000fc600078ee205ULL,
0x00005e0008087625ULL, 0x000fc800078e000fULL, 0x00005e000e0e7625ULL, 0x000fc800078e000fULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001011067825ULL, 0x000fc800078e0006ULL,
0x0000001011087825ULL, 0x000fc800078e0008ULL, 0x00000010110a7825ULL, 0x000fc800078e000aULL,
0x00000010110c7825ULL, 0x000fc800078e000cULL, 0x00000010110e7825ULL, 0x000fc800078e000eULL,
0x0000001013057824ULL, 0x100fe200078e0212ULL, 0x0000001215137211ULL, 0x000fe200078e20ffULL,
0x000000101b117824ULL, 0x100fe400078e0212ULL, 0x0000001019157824ULL, 0x100fe200078e0212ULL,
0x0000000002057faeULL, 0x0003e2000c901c46ULL, 0x0000001021197824ULL, 0x100fe400078e0212ULL,
0x00000010231b7824ULL, 0x000fe200078e0212ULL, 0x0000000006117faeULL, 0x0003e8000d101c46ULL,
0x0000000008137faeULL, 0x0003e8000d901c46ULL, 0x000000000a157faeULL, 0x0003e8000e101c46ULL,
0x000000000c197faeULL, 0x0003e8000e901c46ULL, 0x000000000e1b7faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011604ULL,
0x00000200ff197424ULL, 0x000fe200078e00ffULL, 0x0000d000601a7811ULL, 0x000fc400078e68ffULL,
0x0000000403097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c030d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000809157824ULL, 0x040fe200078e00ffULL,
0x0000000409027212ULL, 0x080fe200078e3cffULL, 0x000000080d217824ULL, 0x040fe200078e00ffULL,
0x000000040d067212ULL, 0x040fe200078e3cffULL, 0x000000010d0a7824ULL, 0x000fe200078e020eULL,
0x0000000703077812ULL, 0x000fc400078e4804ULL, 0x00000010030f7810ULL, 0x000fe40007ffe0ffULL,
0x000000040b057212ULL, 0x040fe400078e3cffULL, 0x000000030b087819ULL, 0x000fe200000006ffULL,
0x000000080f227824ULL, 0x000fe200078e00ffULL, 0x0000001403117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0c7824ULL, 0x000fe200078e020eULL, 0x0000001803137810ULL, 0x040fe40007ffe0ffULL,
0x0000001c03237810ULL, 0x000fe20007ffe0ffULL, 0x0000000811247824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee202ULL, 0x0000000103027824ULL, 0x000fe200078e020eULL,
0xfffffff821217812ULL, 0x000fe200078ee206ULL, 0x0000000813267824ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef804ULL, 0x0000000113187824ULL, 0x100fe200078e020eULL,
0xfffffff8081b7812ULL, 0x000fe200078ee205ULL, 0x000000010b087824ULL, 0x100fe200078e020eULL,
0x0000000e09067210ULL, 0x000fe20007ffe0ffULL, 0x0000000123207824ULL, 0x000fe200078e020eULL,
0x0000000704057812ULL, 0x000fe200078ec0ffULL, 0x00005e0002027625ULL, 0x000fe200078e0019ULL,
0x000000040f097212ULL, 0x000fc400078e3cffULL, 0x00000004110b7212ULL, 0x040fe200078e3cffULL,
0x0000000164057824ULL, 0x000fe200078e0205ULL, 0x0000000e11127210ULL, 0x000fe20007ffe0ffULL,
0x0000001007117824ULL, 0x000fe200078e021aULL, 0x00000004130d7212ULL, 0x080fe200078e3cffULL,
0x00005e0006067625ULL, 0x000fe200078e0019ULL, 0x00000004230e7212ULL, 0x040fe400078e3cffULL,
0x0000000323297819ULL, 0x000fe200000006ffULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0xfffffff822237812ULL, 0x000fc400078ee209ULL, 0xfffffff824257812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x080fe200078e0019ULL, 0xfffffff826277812ULL, 0x000fe200078ee20dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002117faeULL, 0x0003e2000b901c46ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x00005e000a0a7625ULL, 0x000fe200078e0019ULL,
0x0000001a23237211ULL, 0x000fc600078e20ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0019ULL,
0x00005e00120e7625ULL, 0x000fc800078e0019ULL, 0x00005e0018127625ULL, 0x000fc800078e0019ULL,
0x00005e0020187625ULL, 0x000fc800078e0019ULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x0000001015157824ULL, 0x000fe400078e021aULL, 0x0000001005087825ULL, 0x000fc600078e0008ULL,
0x0000000006157faeULL, 0x0003e2000b901c46ULL, 0x000000101b1b7824ULL, 0x000fe400078e021aULL,
0x00000010050a7825ULL, 0x000fc600078e000aULL, 0x00000000081b7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e021aULL, 0x00000010050c7825ULL, 0x000fc600078e000cULL,
0x000000000a217faeULL, 0x0003e2000b901c46ULL, 0x00000010050e7825ULL, 0x000fc600078e000eULL,
0x000000000c237faeULL, 0x0003e2000b901c46ULL, 0x0000001025257824ULL, 0x000fe400078e021aULL,
0x0000001005127825ULL, 0x000fc600078e0012ULL, 0x000000000e257faeULL, 0x0003e2000b901c46ULL,
0x0000001027277824ULL, 0x000fe400078e021aULL, 0x0000001005187825ULL, 0x000fc600078e0018ULL,
0x0000000012277faeULL, 0x0003e2000b901c46ULL, 0x0000001029297824ULL, 0x000fca00078e021aULL,
0x0000000018297faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146080064067f8cULL, 0x002fe8000c80043fULL,
0x01460c0064037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007824807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff027424ULL, 0x000fc800078e00ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x3fa0000002027823ULL, 0x002fe200000100ffULL,
0x000000030000735dULL, 0x004fe40003800000ULL, 0x01460c0064037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007824807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000404157819ULL, 0x000fe200000006ffULL, 0xffffffffff0e7424ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe40000011604ULL, 0x0000007015157812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fca00078ec0ffULL, 0x0000000115157824ULL, 0x000fca00078e0202ULL,
0x0140000015037984ULL, 0x000e680000000800ULL, 0x0142000015057984ULL, 0x0004e20000000800ULL,
0x000000620300720bULL, 0x002fe20003f3d000ULL, 0x000139a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x004fc800008e0100ULL, 0x0000ffff02077812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff027424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000ff6000720cULL, 0x000fe40003f25270ULL,
0x000000620300720bULL, 0x000fe20003f54000ULL, 0x000139727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x000fe400010e0100ULL, 0x0000000362087209ULL, 0x000fe40007810000ULL,
0x0000ffff02027812ULL, 0x000fc600078e3cffULL, 0x8000000862067221ULL, 0x000fe20000010000ULL,
0x0144000815009388ULL, 0x0003e20000000800ULL, 0x0000000207ff7212ULL, 0x000fe4000782c0ffULL,
0x3fb8aa3b06067820ULL, 0x000fe20000410000ULL, 0x00000002ff027819ULL, 0x000fc60000011604ULL,
0x0000000600287308ULL, 0x0002a20000000800ULL, 0x000139227f007947ULL, 0x000fec000b800000ULL,
0x00001f0228067589ULL, 0x0062a400000e0000ULL, 0x0000000802027810ULL, 0x002fe20007ffe0ffULL,
0x000139627f007947ULL, 0x000fea000b800000ULL, 0x00001f0228027589ULL, 0x00032400000e0000ULL,
0x8000000803031221ULL, 0x100fe20000010000ULL, 0x000000021f1f7220ULL, 0x090fe20000410000ULL,
0x000000021e1e7220ULL, 0x080fe20000410000ULL, 0x000000023b3b7220ULL, 0x080fe20000410000ULL,
0x3fb8aa3b03031820ULL, 0x000fe20000410000ULL, 0x000000023a3a7220ULL, 0x080fe20000410000ULL,
0x000000024f4f7220ULL, 0x080fe20000410000ULL, 0x000000024e4e7220ULL, 0x080fe20000410000ULL,
0x0000000300141308ULL, 0x000f220000000800ULL, 0x0000000253537220ULL, 0x080fe20000410000ULL,
0x0000000252527220ULL, 0x080fe20000410000ULL, 0x000000024b4b7220ULL, 0x080fe20000410000ULL,
0x000000024a4a7220ULL, 0x080fe20000410000ULL, 0x0000000247477220ULL, 0x080fe20000410000ULL,
0x0000000246467220ULL, 0x080fe20000410000ULL, 0x0000000243437220ULL, 0x080fe20000410000ULL,
0x0000000242427220ULL, 0x080fe20000410000ULL, 0x000000023f3f7220ULL, 0x080fe20000410000ULL,
0x000000023e3e7220ULL, 0x000fe20000410000ULL, 0x0000002816167220ULL, 0x000fe20000410000ULL,
0x00000001ff027807ULL, 0x000fe20000800000ULL, 0x000000061d1d7220ULL, 0x084fe20000410000ULL,
0x000000061c1c7220ULL, 0x080fe20000410000ULL, 0x0000000639397220ULL, 0x080fe20000410000ULL,
0x0000000638387220ULL, 0x080fe20000410000ULL, 0x000000064d4d7220ULL, 0x080fe20000410000ULL,
0x000000064c4c7220ULL, 0x080fe20000410000ULL, 0x0000000651517220ULL, 0x080fe20000410000ULL,
0x0000000650507220ULL, 0x080fe20000410000ULL, 0x0000000649497220ULL, 0x080fe20000410000ULL,
0x0000000648487220ULL, 0x080fe20000410000ULL, 0x0000000645457220ULL, 0x080fe20000410000ULL,
0x0000000644447220ULL, 0x080fe20000410000ULL, 0x0000000641417220ULL, 0x080fe20000410000ULL,
0x0000000640407220ULL, 0x080fe20000410000ULL, 0x000000063d3d7220ULL, 0x080fe20000410000ULL,
0x000000063c3c7220ULL, 0x000fe20000410000ULL, 0x000000ffff627224ULL, 0x000fe200078e0008ULL,
0x0000001405051220ULL, 0x018fc40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000014ff03723eULL, 0x000fe200000000ffULL, 0x0000001605167221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff117819ULL, 0x000fe40000011604ULL,
0x0000541003287816ULL, 0x002fe20000000003ULL, 0x000136e27f007947ULL, 0x000fea000b800000ULL,
0x0000000811137810ULL, 0x000fe20007ffe0ffULL, 0x00001f11286f7589ULL, 0x0002a800000e0000ULL,
0x00001f13286e7589ULL, 0x0002e400000e0000ULL, 0x0000001011127810ULL, 0x000fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff317224ULL, 0x002fe200078e0012ULL,
0xffffffff002b7802ULL, 0x000fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe200078e00ffULL,
0x0000244000187802ULL, 0x000fc40000000f00ULL, 0x0001435000007944ULL, 0x00cfea0003c00000ULL,
0x0000001811117810ULL, 0x002fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x000fe200078e0011ULL, 0x000024b000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x000142e000007944ULL, 0x00cfea0003c00000ULL, 0x00000007040f7812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004ff067819ULL, 0x100fe40000011604ULL,
0x000000080f697812ULL, 0x000fe400078ef804ULL, 0x0000000804037812ULL, 0x000fe400078ec0ffULL,
0x0000000706087812ULL, 0x000fca00078e7869ULL, 0x00000008690d7824ULL, 0x000fca00078e0208ULL,
0x0000a0000d307811ULL, 0x000fca00078e20ffULL, 0x0000000703057812ULL, 0x140fe200078ef804ULL,
0x000000003030783bULL, 0x002e620000000200ULL, 0x0000000703037812ULL, 0x000fe400078ec804ULL,
0x0000000206087810ULL, 0x040fe40007ffe0ffULL, 0x00000004060a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000606187810ULL, 0x000fe40007ffe0ffULL, 0x0000000603067212ULL, 0x000fc400078e3cffULL,
0x0000000803207212ULL, 0x040fe400078e3cffULL, 0x0000000a03667212ULL, 0x040fe400078e3cffULL,
0x0000001803227212ULL, 0x000fe200078e3cffULL, 0x00000008056c7824ULL, 0x040fe200078e0220ULL,
0x0000c000600c7811ULL, 0x000fe200078e68ffULL, 0x00000008056b7824ULL, 0x040fe200078e0266ULL,
0x00000006056d7211ULL, 0x040fe200078e18ffULL, 0x00000008056a7824ULL, 0x000fe200078e0222ULL,
0x0000000708187812ULL, 0x000fe200078e7869ULL, 0x000000106b097824ULL, 0x100fe200078e020cULL,
0x0000000c6c0a7211ULL, 0x080fe200078e20ffULL, 0x000000106d0b7824ULL, 0x100fe200078e020cULL,
0x0000008005057811ULL, 0x000fe200078e18ffULL, 0x000000106a087824ULL, 0x000fe200078e020cULL,
0x000000000954783bULL, 0x000f220000004200ULL, 0x0000000869077824ULL, 0x000fe200078e0218ULL,
0x0000991002027816ULL, 0x000fe200000000ffULL, 0x0000000166667824ULL, 0x100fe200078e0205ULL,
0x000000000b5c783bULL, 0x000f620000004200ULL, 0x0000000106687824ULL, 0x100fe200078e0205ULL,
0x0000a00007187811ULL, 0x000fe200078e20ffULL, 0x0000000122657824ULL, 0x000fe200078e0205ULL,
0x000000000a58783bULL, 0x000fe20000004200ULL, 0x0000000520677210ULL, 0x000fe20007ffe0ffULL,
0x0000001068067824ULL, 0x100fe200078e020cULL, 0x000000ff0200720cULL, 0x000fe20003f25270ULL,
0x000000000834783bULL, 0x000fe20000004200ULL, 0x0000000c66037211ULL, 0x000fe200078e20ffULL,
0x0000001067057824ULL, 0x100fe200078e020cULL, 0x0000002010707810ULL, 0x000fe20007ffe0ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000001065027824ULL, 0x000fc600078e020cULL,
0x00000000062c783bULL, 0x004ea80000004200ULL, 0x000000000324783bULL, 0x000ea20000004200ULL,
0x0000006f30309232ULL, 0x082fe40000000000ULL, 0x0000006f32329232ULL, 0x080fe20000000000ULL,
0x000000000528783bULL, 0x000e620000004200ULL, 0x0000006e31319232ULL, 0x088fe40000000000ULL,
0x0000006e33339232ULL, 0x000fe20000000000ULL, 0x000000000220783bULL, 0x000eec0000004200ULL,
0x000000543050723cULL, 0x050ff00000001850ULL, 0x0000005c303c723cULL, 0x060ff0000000183cULL,
0x0000005e3040723cULL, 0x000fe20000001840ULL, 0x0000006f18189232ULL, 0x000fc40000000000ULL,
0x0000006f1a1a9232ULL, 0x000fe40000000000ULL, 0x0000006e19199232ULL, 0x080fe40000000000ULL,
0x0000006e1b1b9232ULL, 0x000fe20000000000ULL, 0x000000583044723cULL, 0x040ff00000001844ULL,
0x0000005a3048723cULL, 0x040ff00000001848ULL, 0x00000056304c723cULL, 0x040ff0000000184cULL,
0x000000343038723cULL, 0x040ff00000001838ULL, 0x00000036301c723cULL, 0x000ff0000000181cULL,
0x0000002c183c723cULL, 0x044ff0000000183cULL, 0x0000002e1840723cULL, 0x040ff00000001840ULL,
0x000000241850723cULL, 0x040ff00000001850ULL, 0x000000281844723cULL, 0x042ff00000001844ULL,
0x0000002a1848723cULL, 0x040ff00000001848ULL, 0x000000261824723cULL, 0x040ff0000000184cULL,
0x000000201838723cULL, 0x048fee0000001838ULL, 0x0000620063207a24ULL, 0x000fe200078e0270ULL,
0x00000022182c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x000fe20000011604ULL,
0x00000200ff217424ULL, 0x000fe200078e00ffULL, 0x0000007017197217ULL, 0x000fe20007800000ULL,
0x0000000164237824ULL, 0x000fe200078e020fULL, 0x000000041f1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000081f317810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x000fe200078e0a70ULL,
0x0000000c1f357810ULL, 0x000fe20007ffe0ffULL, 0x000000081d2b7824ULL, 0x040fe200078e00ffULL,
0x000000041d187212ULL, 0x000fe200078e3cffULL, 0x0000000831337824ULL, 0x000fe200078e00ffULL,
0x000000101f4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee218ULL, 0x0000000431187212ULL, 0x080fe400078e3cffULL,
0x00000004351a7212ULL, 0x080fe200078e3cffULL, 0x000000102b2b7824ULL, 0x000fe200078e020cULL,
0x000000044d1b7212ULL, 0x040fe400078e3cffULL, 0x000000034d1c7819ULL, 0x000fe400000006ffULL,
0x00000020191e7817ULL, 0x000fe40003800000ULL, 0xfffffff833337812ULL, 0x000fe200078ee218ULL,
0x000000011f187824ULL, 0x000fe200078e0220ULL, 0xfffffff837377812ULL, 0x000fc400078ee21aULL,
0xfffffff81c4f7812ULL, 0x000fe200078ee21bULL, 0x00000001311c7824ULL, 0x000fe200078e0220ULL,
0x000000071f1b7812ULL, 0x000fe200078e4804ULL, 0x00005e0018187625ULL, 0x080fe200078e0021ULL,
0x000000201d1a7210ULL, 0x000fe40007ffe0ffULL, 0x0000001e1f00720cULL, 0x080fe20003f46070ULL,
0x0000001037377824ULL, 0x000fe200078e020cULL, 0x0000001e1d00720cULL, 0x000fe20003f66070ULL,
0x00005e001c1c7625ULL, 0x000fe200078e0021ULL, 0x0ffffff81b297812ULL, 0x000fc400078ef804ULL,
0x0000001e3100720cULL, 0x000fe20003f86070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0021ULL,
0x000000141f557810ULL, 0x040fe40007ffe0ffULL, 0x000000181f577810ULL, 0x000fe20007ffe0ffULL,
0x0000001029297824ULL, 0x000fe200078e020cULL, 0x0000000455227212ULL, 0x040fe200078e3cffULL,
0x0000000855317824ULL, 0x000fe200078e00ffULL, 0x0000000c33337211ULL, 0x000fe200078e20ffULL,
0x0000001023187825ULL, 0x000fe200078e0018ULL, 0x0000001c1f597810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee222ULL, 0x00000010231a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018297faeULL, 0x0003e2000d101c46ULL,
0x00000004571f7212ULL, 0x000fe400078e3cffULL, 0x00000010231c7825ULL, 0x000fe200078e001cULL,
0x000000001a2b7faeULL, 0x0005e2000d901c46ULL, 0x0000001e3500720cULL, 0x080fe40003f46070ULL,
0x0000000857227824ULL, 0x000fe200078e00ffULL, 0x000000001c337faeULL, 0x0007e2000e101c46ULL,
0x0000001e4d00720cULL, 0x080fe20003f66070ULL, 0x000000104f4f7824ULL, 0x000fe200078e020cULL,
0x0000001e5500720cULL, 0x080fe20003f86070ULL, 0x0000000135187824ULL, 0x002fe200078e0220ULL,
0x0000001e5700720cULL, 0x000fc40003fa6070ULL, 0x0000001e5900720cULL, 0x000fe20003fc6070ULL,
0x000000014d1a7824ULL, 0x104fe200078e0220ULL, 0x00000020571e7210ULL, 0x000fe20007ffe0ffULL,
0x00000008592b7824ULL, 0x000fe200078e00ffULL, 0xfffffff822297812ULL, 0x000fe200078ee21fULL,
0x00000001551c7824ULL, 0x108fe200078e0220ULL, 0x0000000459227212ULL, 0x040fe200078e3cffULL,
0x0000000159207824ULL, 0x000fe200078e0220ULL, 0x0000000c31317211ULL, 0x000fe200078e20ffULL,
0x00005e0018187625ULL, 0x000fe200078e0021ULL, 0xfffffff82b2b7812ULL, 0x000fc600078ee222ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x0000001023187825ULL, 0x000fc800078e0018ULL, 0x00000010231a7825ULL, 0x040fe200078e001aULL,
0x0000000018377faeULL, 0x0003e6000d101c46ULL, 0x00000010231c7825ULL, 0x040fe200078e001cULL,
0x000000001a4f7faeULL, 0x0003e6000d901c46ULL, 0x00000010231e7825ULL, 0x000fe200078e001eULL,
0x000000001c317faeULL, 0x0003e6000e101c46ULL, 0x0000001029297824ULL, 0x000fc400078e020cULL,
0x0000001023207825ULL, 0x000fc600078e0020ULL, 0x000000001e297faeULL, 0x0003e2000e901c46ULL,
0x000000102b2b7824ULL, 0x000fca00078e020cULL, 0x00000000202b7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe20000011604ULL,
0x00000200ff2b7424ULL, 0x000fe400078e00ffULL, 0x0000000164317824ULL, 0x000fe200078e020fULL,
0x0000000c19217810ULL, 0x040fe40007ffe0ffULL, 0x00000004191d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008191f7810ULL, 0x000fe20007ffe0ffULL, 0x00000001211e7824ULL, 0x040fe200078e0220ULL,
0x00000004211b7212ULL, 0x080fe200078e3cffULL, 0x000000081d357824ULL, 0x000fe200078e00ffULL,
0x00000003211c7819ULL, 0x000fe200000006ffULL, 0x000000081f377824ULL, 0x000fe200078e00ffULL,
0x000000041d187212ULL, 0x000fc400078e3cffULL, 0x000000041f1a7212ULL, 0x000fe400078e3cffULL,
0xfffffff81c4d7812ULL, 0x000fe400078ee21bULL, 0x0000001019237810ULL, 0x040fe40007ffe0ffULL,
0x00000007191b7812ULL, 0x000fe200078e4804ULL, 0x000000104d4d7824ULL, 0x000fe200078e020cULL,
0x0000001419297810ULL, 0x000fe20007ffe0ffULL, 0x0000000823327824ULL, 0x000fe200078e00ffULL,
0x0000001819337810ULL, 0x000fe20007ffe0ffULL, 0x0000000123227824ULL, 0x100fe200078e0220ULL,
0x0000001c194f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129287824ULL, 0x000fe200078e0220ULL,
0xfffffff835357812ULL, 0x000fe200078ee218ULL, 0x0000000119187824ULL, 0x000fe200078e0220ULL,
0xfffffff837377812ULL, 0x000fe200078ee21aULL, 0x000000011d1a7824ULL, 0x000fe200078e0220ULL,
0x0ffffff81b1b7812ULL, 0x000fe200078ef804ULL, 0x00000001332a7824ULL, 0x100fe200078e0220ULL,
0x000000201f1c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014f307824ULL, 0x000fe200078e0220ULL,
0x00000004231d7212ULL, 0x080fe200078e3cffULL, 0x0000000833577824ULL, 0x000fe200078e00ffULL,
0x00000004291f7212ULL, 0x080fe200078e3cffULL, 0x000000084f367824ULL, 0x000fe200078e00ffULL,
0x0000000329347819ULL, 0x000fe200000006ffULL, 0x00005e0018187625ULL, 0x000fe200078e002bULL,
0x0000000433207212ULL, 0x000fc400078e3cffULL, 0x000000044f217212ULL, 0x000fe200078e3cffULL,
0x0000001035357824ULL, 0x000fe200078e020cULL, 0x0000000c1b337211ULL, 0x080fe200078e20ffULL,
0x00005e001a1a7625ULL, 0x080fe200078e002bULL, 0xfffffff8324f7812ULL, 0x000fe400078ee21dULL,
0xfffffff834557812ULL, 0x000fe200078ee21fULL, 0x00005e001c1c7625ULL, 0x080fe200078e002bULL,
0xfffffff857577812ULL, 0x000fe400078ee220ULL, 0xfffffff836597812ULL, 0x000fe200078ee221ULL,
0x00005e001e1e7625ULL, 0x000fe200078e002bULL, 0x0000000c55557211ULL, 0x000fc600078e20ffULL,
0x00005e0022207625ULL, 0x000fc800078e002bULL, 0x00005e0028227625ULL, 0x000fc800078e002bULL,
0x0000001031187825ULL, 0x000fc800078e0018ULL, 0x00005e002a287625ULL, 0x080fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018337faeULL, 0x0003e6000b901c46ULL,
0x00005e00302a7625ULL, 0x000fc800078e002bULL, 0x00000010311a7825ULL, 0x000fc800078e001aULL,
0x0000001037377824ULL, 0x000fe200078e020cULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x00000010311c7825ULL, 0x000fc800078e001cULL, 0x00000010311e7825ULL, 0x040fe200078e001eULL,
0x000000001c377faeULL, 0x0003e6000b901c46ULL, 0x0000001031207825ULL, 0x000fe200078e0020ULL,
0x000000001e4d7faeULL, 0x0003e6000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e020cULL,
0x0000001031227825ULL, 0x000fc600078e0022ULL, 0x00000000204f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031287825ULL, 0x000fc600078e0028ULL, 0x0000000022557faeULL, 0x0003e2000b901c46ULL,
0x0000001057577824ULL, 0x000fe400078e020cULL, 0x00000010312a7825ULL, 0x000fc600078e002aULL,
0x0000000028577faeULL, 0x0003e2000b901c46ULL, 0x0000001059597824ULL, 0x000fca00078e020cULL,
0x000000002a597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000404187811ULL, 0x002fe400078fe0ffULL, 0x000010000c6f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000718187812ULL, 0x000fe400078e7869ULL, 0x00000002ff717819ULL, 0x000fe20000011604ULL,
0x000000106b6b7824ULL, 0x100fe200078e026fULL, 0x0000006f67677211ULL, 0x000fe200078e20ffULL,
0x00000008696e7824ULL, 0x000fe200078e0218ULL, 0x0000000604187811ULL, 0x000fe200078fe0ffULL,
0x000000106d6d7824ULL, 0x000fc400078e026fULL, 0x000000106c6c7824ULL, 0x100fe200078e026fULL,
0x0000a0006e307811ULL, 0x000fe200078e20ffULL, 0x000000106a6a7824ULL, 0x000fe200078e026fULL,
0x0000000718187812ULL, 0x000fe200078e7869ULL, 0x0000001066667824ULL, 0x100fe400078e026fULL,
0x0000001068687824ULL, 0x100fe200078e026fULL, 0x0000001869697211ULL, 0x000fe200078e18ffULL,
0x0000001065657824ULL, 0x000fe200078e026fULL, 0x00000014ff18723eULL, 0x000fe200000000ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003030783bULL, 0x000fe20000000200ULL,
0x0000541018747816ULL, 0x000fe40000000018ULL, 0x0000a000691c7811ULL, 0x000fe200078e20ffULL,
0x000000006b54783bULL, 0x000fe80000004200ULL, 0x000000006d5c783bULL, 0x000fe80000004200ULL,
0x000000006c58783bULL, 0x000fe80000004200ULL, 0x000000006a34783bULL, 0x000fe80000004200ULL,
0x00001f7174717589ULL, 0x000e6800000e0000ULL, 0x00001f1374727589ULL, 0x000ea800000e0000ULL,
0x000000001c1c783bULL, 0x000ee80000000200ULL, 0x00000000664c783bULL, 0x000f280000004200ULL,
0x000000006828783bULL, 0x000f680000004200ULL, 0x000000006720783bULL, 0x000f280000004200ULL,
0x000000006518783bULL, 0x000f220000004200ULL, 0x0000007130309232ULL, 0x002fc40000000000ULL,
0x0000007132329232ULL, 0x000fe40000000000ULL, 0x0000007231319232ULL, 0x084fe40000000000ULL,
0x0000007233339232ULL, 0x000fce0000000000ULL, 0x000000543050723cULL, 0x040ff00000001850ULL,
0x0000005c303c723cULL, 0x000fe2000000183cULL, 0x000000711c1c9232ULL, 0x088fe40000000000ULL,
0x000000711e1e9232ULL, 0x000fc40000000000ULL, 0x000000721d1d9232ULL, 0x000fc60000000000ULL,
0x0000005e3040723cULL, 0x000fe20000001840ULL, 0x000000721f1f9232ULL, 0x000fce0000000000ULL,
0x000000583044723cULL, 0x040ff00000001844ULL, 0x0000005a3048723cULL, 0x040ff00000001848ULL,
0x000000563024723cULL, 0x040ff00000001824ULL, 0x000000343038723cULL, 0x040ff00000001838ULL,
0x00000036302c723cULL, 0x000ff0000000182cULL, 0x0000004c1c50723cULL, 0x050ff00000001850ULL,
0x000000281c3c723cULL, 0x060ff0000000183cULL, 0x0000002a1c40723cULL, 0x040ff00000001840ULL,
0x000000201c44723cULL, 0x040ff00000001844ULL, 0x000000221c48723cULL, 0x040ff00000001848ULL,
0x0000004e1c4c723cULL, 0x040ff00000001824ULL, 0x000000181c38723cULL, 0x040ff00000001838ULL,
0x0000001a1c1c723cULL, 0x000fe2000000182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000177000720cULL, 0x000fe20003f26070ULL, 0x01468800ffff7f8cULL, 0x000fd8000c80043fULL,
0x000063e000001947ULL, 0x000fea0003800000ULL, 0x00000040101a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620063267a24ULL, 0x000fe200078e021aULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff257819ULL, 0x100fe20000011604ULL,
0x00000200ff277424ULL, 0x000fe200078e00ffULL, 0x0000001a17187217ULL, 0x000fe40007800000ULL,
0x0000000425217810ULL, 0x040fe40007ffe0ffULL, 0x00000007251b7812ULL, 0x000fe200078e4804ULL,
0x0000000118187824ULL, 0x000fe200078e0a1aULL, 0x0000000421197212ULL, 0x040fe200078e3cffULL,
0x0000000821247824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x00000001211a7824ULL, 0x000fe200078e0226ULL, 0x0000002018207817ULL, 0x000fc40003800000ULL,
0xfffffff824247812ULL, 0x000fe200078ee219ULL, 0x0000000125197824ULL, 0x040fe200078e0226ULL,
0x0000000c252d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008292f7824ULL, 0x000fe200078e00ffULL,
0x000000202500720cULL, 0x080fe20003f26070ULL, 0x00005e0019187625ULL, 0x080fe200078e0027ULL,
0x000000202100720cULL, 0x000fe40003f46070ULL, 0x0ffffff81b227812ULL, 0x000fe200078ef804ULL,
0x00005e001a1a7625ULL, 0x000fe200078e0027ULL, 0x0000000f642b7210ULL, 0x000fc40007ffe0ffULL,
0x0000000429287212ULL, 0x080fe200078e3cffULL, 0x0000001022217824ULL, 0x000fe200078e026fULL,
0x000000042d2a7212ULL, 0x000fe200078e3cffULL, 0x000000102b187825ULL, 0x000fe200078e0018ULL,
0x000000032d317819ULL, 0x000fe400000006ffULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000001024237824ULL, 0x000fe200078e026fULL, 0xfffffff8312a7812ULL, 0x000fe200078ee22aULL,
0x000000102b1a7825ULL, 0x000fe200078e001aULL, 0x00000010252f7810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018217faeULL, 0x0003e2000c901c46ULL,
0x0000001425317810ULL, 0x000fc40007ffe0ffULL, 0x0000001825337810ULL, 0x040fe20007ffe0ffULL,
0x000000001a237faeULL, 0x0005e2000d101c46ULL, 0x0000001c25257810ULL, 0x000fe20007ffe0ffULL,
0x000000082f2c7824ULL, 0x000fe200078e00ffULL, 0x000000202900720cULL, 0x080fe20003f26070ULL,
0x00000008312e7824ULL, 0x000fe200078e00ffULL, 0x000000202d00720cULL, 0x080fe20003f46070ULL,
0x0000000833307824ULL, 0x000fe200078e00ffULL, 0x000000202f00720cULL, 0x080fe20003f66070ULL,
0x0000000825327824ULL, 0x000fe200078e00ffULL, 0x000000203100720cULL, 0x080fe20003f86070ULL,
0x0000000129187824ULL, 0x102fe200078e0226ULL, 0x000000203300720cULL, 0x080fe20003fa6070ULL,
0x000000012d1a7824ULL, 0x104fe200078e0226ULL, 0x000000202500720cULL, 0x000fe20003fc6070ULL,
0x0000000131227824ULL, 0x100fe200078e0226ULL, 0x000000262f207210ULL, 0x000fe20007ffe0ffULL,
0x0000000133247824ULL, 0x000fe200078e0226ULL, 0x000000042f197212ULL, 0x080fe200078e3cffULL,
0x0000001028297824ULL, 0x000fe200078e026fULL, 0x00000004311b7212ULL, 0x000fc400078e3cffULL,
0x0000000433217212ULL, 0x080fe400078e3cffULL, 0x0000000425237212ULL, 0x040fe400078e3cffULL,
0x0000002625267210ULL, 0x000fe20007ffe0ffULL, 0x00005e0024247625ULL, 0x080fe200078e0027ULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee219ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee21bULL,
0x00005e0018187625ULL, 0x000fe200078e0027ULL, 0xfffffff830307812ULL, 0x000fc400078ee221ULL,
0xfffffff832327812ULL, 0x000fe200078ee223ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0027ULL,
0x0000006f2c2d7211ULL, 0x000fc600078e20ffULL, 0x00005e0020207625ULL, 0x000fc800078e0027ULL,
0x00005e0022227625ULL, 0x000fc800078e0027ULL, 0x00005e0026267625ULL, 0x000fc800078e0027ULL,
0x000000102b187825ULL, 0x000fc800078e0018ULL, 0x000000102b1a7825ULL, 0x040fe200078e001aULL,
0x0000000018297faeULL, 0x0003e6000c901c46ULL, 0x000000102b207825ULL, 0x000fc800078e0020ULL,
0x000000102b227825ULL, 0x000fc800078e0022ULL, 0x000000102b247825ULL, 0x000fc800078e0024ULL,
0x000000102b267825ULL, 0x000fc800078e0026ULL, 0x000000102a2b7824ULL, 0x100fe400078e026fULL,
0x000000102e2f7824ULL, 0x100fe400078e026fULL, 0x0000001030317824ULL, 0x100fe200078e026fULL,
0x000000001a2b7faeULL, 0x0003e2000d101c46ULL, 0x0000001032337824ULL, 0x000fc600078e026fULL,
0x00000000202d7faeULL, 0x0003e8000d901c46ULL, 0x00000000222f7faeULL, 0x0003e8000e101c46ULL,
0x0000000024317faeULL, 0x0003e8000e901c46ULL, 0x0000000026337faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe20000011604ULL,
0x00000200ff2b7424ULL, 0x000fc400078e00ffULL, 0x00000001642d7824ULL, 0x000fe200078e020fULL,
0x0000000419217810ULL, 0x040fe40007ffe0ffULL, 0x0000000c19257810ULL, 0x040fe40007ffe0ffULL,
0x0000000819237810ULL, 0x000fe20007ffe0ffULL, 0x0000000821277824ULL, 0x040fe200078e00ffULL,
0x0000000421187212ULL, 0x080fe200078e3cffULL, 0x0000000825307824ULL, 0x000fe200078e00ffULL,
0x00000004231a7212ULL, 0x0c0fe200078e3cffULL, 0x0000000123227824ULL, 0x140fe200078e0226ULL,
0x0000000323297819ULL, 0x000fe200000006ffULL, 0x0000000125247824ULL, 0x040fe200078e0226ULL,
0x00000004251b7212ULL, 0x000fc400078e3cffULL, 0xfffffff8272c7812ULL, 0x000fe200078ee218ULL,
0x0000000119187824ULL, 0x000fe200078e0226ULL, 0xfffffff8292e7812ULL, 0x000fe400078ee21aULL,
0xfffffff830307812ULL, 0x000fe400078ee21bULL, 0x0000001019277810ULL, 0x040fe20007ffe0ffULL,
0x000000102e337824ULL, 0x000fe200078e026fULL, 0x00000007191b7812ULL, 0x040fe400078e4804ULL,
0x0000001419297810ULL, 0x000fe20007ffe0ffULL, 0x0000000827327824ULL, 0x000fe200078e00ffULL,
0x00000018192f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000127287824ULL, 0x000fe200078e0226ULL,
0x0000001c19317810ULL, 0x000fe20007ffe0ffULL, 0x0000000829347824ULL, 0x000fe200078e00ffULL,
0x0ffffff81b1a7812ULL, 0x000fe200078ef804ULL, 0x000000082f547824ULL, 0x000fe200078e00ffULL,
0x0000002621207210ULL, 0x000fe20007ffe0ffULL, 0x000000012f367824ULL, 0x000fe200078e0226ULL,
0x00000004271b7212ULL, 0x080fe200078e3cffULL, 0x00005e0018187625ULL, 0x000fe200078e002bULL,
0x0000000429217212ULL, 0x000fc400078e3cffULL, 0x000000042f237212ULL, 0x080fe200078e3cffULL,
0x000000101a2f7824ULL, 0x000fe200078e026fULL, 0x0000000431257212ULL, 0x040fe200078e3cffULL,
0x0000000131567824ULL, 0x040fe200078e0226ULL, 0x0000000331587819ULL, 0x000fe200000006ffULL,
0x000000102d187825ULL, 0x000fe200078e0018ULL, 0x00000026292a7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff832327812ULL, 0x000fe200078ee21bULL, 0x00005e00201a7625ULL, 0x080fe200078e002bULL,
0xfffffff834347812ULL, 0x000fe200078ee221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000182f7faeULL, 0x0003e2000b901c46ULL, 0xfffffff854547812ULL, 0x000fe200078ee223ULL,
0x00005e0022207625ULL, 0x000fe200078e002bULL, 0xfffffff858587812ULL, 0x000fc600078ee225ULL,
0x00005e0024227625ULL, 0x000fc800078e002bULL, 0x00005e0028247625ULL, 0x000fc800078e002bULL,
0x00005e002a267625ULL, 0x000fc800078e002bULL, 0x00005e0036287625ULL, 0x000fc800078e002bULL,
0x00005e00562a7625ULL, 0x000fc800078e002bULL, 0x000000102c317824ULL, 0x000fe400078e026fULL,
0x000000102d1a7825ULL, 0x000fc800078e001aULL, 0x000000102d207825ULL, 0x040fe200078e0020ULL,
0x000000001a317faeULL, 0x0005e6000b901c46ULL, 0x000000102d227825ULL, 0x040fe200078e0022ULL,
0x0000000020337faeULL, 0x0005e6000b901c46ULL, 0x000000102d247825ULL, 0x000fc800078e0024ULL,
0x000000102d267825ULL, 0x000fc800078e0026ULL, 0x000000102d287825ULL, 0x000fc800078e0028ULL,
0x000000102d2a7825ULL, 0x000fe200078e002aULL, 0x0000006f322d7211ULL, 0x000fc600078e20ffULL,
0x0000001030197824ULL, 0x102fe400078e026fULL, 0x00000010342f7824ULL, 0x100fe400078e026fULL,
0x0000001054357824ULL, 0x100fe200078e026fULL, 0x0000000022197faeULL, 0x0005e2000b901c46ULL,
0x0000001058377824ULL, 0x000fc600078e026fULL, 0x00000000242d7faeULL, 0x0005e8000b901c46ULL,
0x00000000262f7faeULL, 0x0005e8000b901c46ULL, 0x0000000028357faeULL, 0x0005e8000b901c46ULL,
0x000000002a377faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01462800641a7f8cULL, 0x006fe8000c80043fULL,
0x01462c0064197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff187424ULL, 0x000fc800078e00ffULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01462c0064197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe4000782481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01408000151b7984ULL, 0x000e680000000800ULL, 0x0142800015217984ULL, 0x0004e20000000800ULL,
0x000000621b00720bULL, 0x002fe20003f3d000ULL, 0x000117627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800008e0100ULL, 0x0000ffff18207812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1a7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000016000780cULL, 0x000fe40003f25270ULL,
0x000000621b00720bULL, 0x000fe20003f54000ULL, 0x000117327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x000fe400010e0100ULL, 0x0000001b62197209ULL, 0x000fe40007810000ULL,
0x0000ffff18237812ULL, 0x000fe400078e3cffULL, 0x00000002ff317819ULL, 0x000fe20000011604ULL,
0x80000019621a7221ULL, 0x000fe20000010000ULL, 0x0144801915009388ULL, 0x0003e20000000800ULL,
0x0000002320ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b1a1a7820ULL, 0x000fc80000410000ULL,
0x0000001a00287308ULL, 0x000ea40000000800ULL, 0x0000002816167220ULL, 0x004fe20000410000ULL,
0x000116d27f007947ULL, 0x000fea000b800000ULL, 0x00001f3128187589ULL, 0x0022a400000e0000ULL,
0x000000183c3c7220ULL, 0x084fe20000410000ULL, 0x000000183d3d7220ULL, 0x080fe20000410000ULL,
0x0000001840407220ULL, 0x080fe20000410000ULL, 0x0000001841417220ULL, 0x080fe20000410000ULL,
0x0000001844447220ULL, 0x080fe20000410000ULL, 0x0000001845457220ULL, 0x080fe20000410000ULL,
0x0000001848487220ULL, 0x080fe20000410000ULL, 0x0000001849497220ULL, 0x080fe20000410000ULL,
0x0000001850507220ULL, 0x080fe20000410000ULL, 0x0000001851517220ULL, 0x080fe20000410000ULL,
0x000000184c4c7220ULL, 0x080fe20000410000ULL, 0x000000184d4d7220ULL, 0x080fe20000410000ULL,
0x0000001838387220ULL, 0x080fe20000410000ULL, 0x0000001839397220ULL, 0x080fe20000410000ULL,
0x000000181c1c7220ULL, 0x080fe20000410000ULL, 0x000000181d1d7220ULL, 0x000fe20000410000ULL,
0x000116127f007947ULL, 0x000fea000b800000ULL, 0x00001f1328187589ULL, 0x00052400000e0000ULL,
0x0000001b62627209ULL, 0x000fe20007810000ULL, 0x000000183e3e7220ULL, 0x090fe20000410000ULL,
0x00000001ff1a7807ULL, 0x000fe20000800000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001842427220ULL, 0x080fe20000410000ULL, 0x800000621b1b1221ULL, 0x000fe20000010000ULL,
0x0000001843437220ULL, 0x080fe20000410000ULL, 0x0000001846467220ULL, 0x080fe20000410000ULL,
0x0000001847477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b1b1b1820ULL, 0x000fe20000410000ULL,
0x000000184a4a7220ULL, 0x080fe20000410000ULL, 0x000000184b4b7220ULL, 0x080fe20000410000ULL,
0x0000001852527220ULL, 0x080fe20000410000ULL, 0x0000001b00141308ULL, 0x000f220000000800ULL,
0x0000001853537220ULL, 0x080fe20000410000ULL, 0x000000184e4e7220ULL, 0x080fe20000410000ULL,
0x000000184f4f7220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000181e1e7220ULL, 0x080fe20000410000ULL,
0x000000181f1f7220ULL, 0x000fe20000410000ULL, 0x0000002114211220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000014ff18723eULL, 0x000fe200000000ffULL,
0x0000001621167221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff317819ULL, 0x002fe40000011604ULL, 0x0000541018287816ULL, 0x004fe20000000018ULL,
0x000114a27f007947ULL, 0x000fea000b800000ULL, 0x00001f3128717589ULL, 0x0002a800000e0000ULL,
0x00001f1328707589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0012ULL, 0x000048b000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00011ee000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000001100317202ULL, 0x002fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe200078e00ffULL,
0x0000491000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00011e8000007944ULL, 0x00cfea0003c00000ULL, 0x0000a8000d307811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b5c783bULL, 0x000fe20000004200ULL,
0x0000a80007187811ULL, 0x000fc400078e20ffULL, 0x000099101a207816ULL, 0x000fe200000000ffULL,
0x000000003030783bULL, 0x002e660000000200ULL, 0x000000ff2000720cULL, 0x000fe20003f25270ULL,
0x000000000954783bULL, 0x000fe80000004200ULL, 0x000000000a58783bULL, 0x000fe80000004200ULL,
0x000000000834783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000f280000000200ULL,
0x00000000062c783bULL, 0x004ea80000004200ULL, 0x000000000324783bULL, 0x000f680000004200ULL,
0x000000000528783bULL, 0x000ee80000004200ULL, 0x000000000220783bULL, 0x000ea20000004200ULL,
0x0000007130309232ULL, 0x002fc40000000000ULL, 0x0000007132329232ULL, 0x000fe40000000000ULL,
0x0000007031319232ULL, 0x088fe40000000000ULL, 0x0000007033339232ULL, 0x000fce0000000000ULL,
0x0000005c303c723cULL, 0x000fe2000000183cULL, 0x0000007118189232ULL, 0x090fe40000000000ULL,
0x000000711a1a9232ULL, 0x000fe40000000000ULL, 0x0000007019199232ULL, 0x000fc60000000000ULL,
0x0000005e3040723cULL, 0x000fe20000001840ULL, 0x000000701b1b9232ULL, 0x000fe20000000000ULL,
0x0000006010707810ULL, 0x000fcc0007ffe0ffULL, 0x000000543050723cULL, 0x040ff00000001850ULL,
0x000000583044723cULL, 0x040ff00000001844ULL, 0x0000005a3048723cULL, 0x040ff00000001848ULL,
0x00000056304c723cULL, 0x040ff0000000184cULL, 0x000000343038723cULL, 0x040ff00000001838ULL,
0x00000036301c723cULL, 0x000ff0000000181cULL, 0x0000002c183c723cULL, 0x044ff0000000183cULL,
0x0000002e1840723cULL, 0x040ff00000001840ULL, 0x000000241850723cULL, 0x060ff00000001850ULL,
0x000000281844723cULL, 0x040ff00000001844ULL, 0x0000002a1848723cULL, 0x040ff00000001848ULL,
0x000000261824723cULL, 0x040ff0000000184cULL, 0x000000201838723cULL, 0x040fee0000001838ULL,
0x0000620063207a24ULL, 0x000fe200078e0270ULL, 0x00000022182c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe20000011604ULL, 0x00000200ff217424ULL, 0x000fe200078e00ffULL,
0x0000007017197217ULL, 0x000fe20007800000ULL, 0x0000000164237824ULL, 0x000fe200078e020fULL,
0x000000041f1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000081f317810ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x000fe200078e0a70ULL, 0x000000041d187212ULL, 0x040fe200078e3cffULL,
0x000000081d2b7824ULL, 0x000fe200078e00ffULL, 0x000000101f4d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000831337824ULL, 0x000fe200078e00ffULL, 0x0000000c1f357810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee218ULL, 0x000000084d1c7824ULL, 0x000fe200078e00ffULL,
0x0000000431187212ULL, 0x080fe400078e3cffULL, 0x000000044d1b7212ULL, 0x080fe400078e3cffULL,
0x00000004351a7212ULL, 0x040fe400078e3cffULL, 0x0000000335377819ULL, 0x000fe400000006ffULL,
0xfffffff833337812ULL, 0x000fc400078ee218ULL, 0x00000020191e7817ULL, 0x000fe40003800000ULL,
0xfffffff81c4f7812ULL, 0x000fe200078ee21bULL, 0x00000001311c7824ULL, 0x000fe200078e0220ULL,
0x000000201f187210ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e020cULL,
0xfffffff837377812ULL, 0x000fe200078ee21aULL, 0x000000011d1a7824ULL, 0x000fe200078e0220ULL,
0x000000071f1b7812ULL, 0x040fe200078e4804ULL, 0x00005e0018187625ULL, 0x000fe200078e0021ULL,
0x0000001e1f00720cULL, 0x000fc40003f46070ULL, 0x0000001e1d00720cULL, 0x080fe20003f66070ULL,
0x00005e001c1c7625ULL, 0x080fe200078e0021ULL, 0x0ffffff81b297812ULL, 0x000fe400078ef804ULL,
0x0000001e3100720cULL, 0x000fe20003f86070ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0021ULL,
0x000000141f557810ULL, 0x000fe40007ffe0ffULL, 0x0000000c2b2b7211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x000fe200078e020cULL, 0x0000000455227212ULL, 0x040fe200078e3cffULL,
0x0000000855317824ULL, 0x000fe200078e00ffULL, 0x000000181f577810ULL, 0x000fe20007ffe0ffULL,
0x0000001023187825ULL, 0x000fe200078e0018ULL, 0x0000001c1f597810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe200078ee222ULL, 0x00000010231a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018297faeULL, 0x0003e2000d101c46ULL,
0x00000004571f7212ULL, 0x000fe400078e3cffULL, 0x00000010231c7825ULL, 0x000fe200078e001cULL,
0x000000001a2b7faeULL, 0x0005e2000d901c46ULL, 0x0000001e3500720cULL, 0x080fe40003f46070ULL,
0x0000000857227824ULL, 0x000fe200078e00ffULL, 0x000000001c337faeULL, 0x0007e2000e101c46ULL,
0x0000001e4d00720cULL, 0x080fe20003f66070ULL, 0x0000001037377824ULL, 0x000fe200078e020cULL,
0x0000001e5500720cULL, 0x080fe20003f86070ULL, 0x0000000135187824ULL, 0x002fe200078e0220ULL,
0x0000001e5700720cULL, 0x080fe20003fa6070ULL, 0x0000001031317824ULL, 0x000fe200078e020cULL,
0x0000001e5900720cULL, 0x000fe20003fc6070ULL, 0x000000014d1a7824ULL, 0x104fe200078e0220ULL,
0xfffffff822297812ULL, 0x000fe200078ee21fULL, 0x00000001571e7824ULL, 0x100fe200078e0220ULL,
0x0000000459227212ULL, 0x040fe200078e3cffULL, 0x00000008592b7824ULL, 0x000fe200078e00ffULL,
0x00000020551c7210ULL, 0x008fe20007ffe0ffULL, 0x0000000159207824ULL, 0x000fe200078e0220ULL,
0x0000000c4f4f7211ULL, 0x000fe200078e20ffULL, 0x00005e0018187625ULL, 0x000fe200078e0021ULL,
0xfffffff82b2b7812ULL, 0x000fc600078ee222ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0021ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0021ULL,
0x00005e0020207625ULL, 0x000fc800078e0021ULL, 0x0000001023187825ULL, 0x000fc800078e0018ULL,
0x00000010231a7825ULL, 0x040fe200078e001aULL, 0x0000000018377faeULL, 0x0003e6000d101c46ULL,
0x00000010231c7825ULL, 0x040fe200078e001cULL, 0x000000001a4f7faeULL, 0x0003e6000d901c46ULL,
0x00000010231e7825ULL, 0x000fe200078e001eULL, 0x000000001c317faeULL, 0x0003e6000e101c46ULL,
0x0000001029297824ULL, 0x000fc400078e020cULL, 0x0000001023207825ULL, 0x000fc600078e0020ULL,
0x000000001e297faeULL, 0x0003e2000e901c46ULL, 0x000000102b2b7824ULL, 0x000fca00078e020cULL,
0x00000000202b7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff197819ULL, 0x000fe20000011604ULL, 0x00000200ff2b7424ULL, 0x000fe400078e00ffULL,
0x0000000164317824ULL, 0x000fe200078e020fULL, 0x0000000c19217810ULL, 0x040fe40007ffe0ffULL,
0x00000004191d7810ULL, 0x000fe40007ffe0ffULL, 0x00000004211b7212ULL, 0x0c0fe200078e3cffULL,
0x00000008211c7824ULL, 0x000fe200078e00ffULL, 0x00000008191f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d357824ULL, 0x040fe200078e00ffULL, 0x000000041d187212ULL, 0x080fe200078e3cffULL,
0x00000001211e7824ULL, 0x100fe200078e0220ULL, 0xfffffff81c4d7812ULL, 0x000fe200078ee21bULL,
0x000000011f1c7824ULL, 0x040fe200078e0220ULL, 0x000000041f1a7212ULL, 0x000fc400078e3cffULL,
0x000000031f377819ULL, 0x000fe200000006ffULL, 0x000000104d4d7824ULL, 0x000fe200078e020cULL,
0x00000007191b7812ULL, 0x040fe400078e4804ULL, 0x0000001019237810ULL, 0x040fe40007ffe0ffULL,
0x0000001419297810ULL, 0x040fe40007ffe0ffULL, 0x0000001819337810ULL, 0x000fe20007ffe0ffULL,
0x0000000823327824ULL, 0x000fe200078e00ffULL, 0x0000001c194f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000829347824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee218ULL,
0x0000000119187824ULL, 0x000fe200078e0220ULL, 0xfffffff837377812ULL, 0x000fe200078ee21aULL,
0x0000000123227824ULL, 0x000fe200078e0220ULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef804ULL,
0x00000001332a7824ULL, 0x100fe200078e0220ULL, 0x000000201d1a7210ULL, 0x000fe20007ffe0ffULL,
0x000000014f307824ULL, 0x000fe200078e0220ULL, 0x00000004231d7212ULL, 0x000fe200078e3cffULL,
0x0000000833577824ULL, 0x000fe200078e00ffULL, 0x0000002029287210ULL, 0x040fe20007ffe0ffULL,
0x00005e0018187625ULL, 0x000fe200078e002bULL, 0x00000004291f7212ULL, 0x000fc400078e3cffULL,
0x0000000433207212ULL, 0x080fe200078e3cffULL, 0x000000101b337824ULL, 0x000fe200078e020cULL,
0x000000044f217212ULL, 0x040fe200078e3cffULL, 0x00005e001a1a7625ULL, 0x080fe200078e002bULL,
0x000000034f367819ULL, 0x000fe400000006ffULL, 0xfffffff8324f7812ULL, 0x000fe200078ee21dULL,
0x00005e001c1c7625ULL, 0x080fe200078e002bULL, 0xfffffff834557812ULL, 0x000fe400078ee21fULL,
0xfffffff857577812ULL, 0x000fe200078ee220ULL, 0x00005e001e1e7625ULL, 0x000fe200078e002bULL,
0xfffffff836597812ULL, 0x000fc400078ee221ULL, 0x0000000c4f4f7211ULL, 0x000fe200078e20ffULL,
0x00005e0022207625ULL, 0x000fc800078e002bULL, 0x00005e0028227625ULL, 0x000fc800078e002bULL,
0x0000001031187825ULL, 0x000fc800078e0018ULL, 0x00005e002a287625ULL, 0x080fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018337faeULL, 0x0003e6000b901c46ULL,
0x00005e00302a7625ULL, 0x000fc800078e002bULL, 0x0000001035357824ULL, 0x000fe400078e020cULL,
0x00000010311a7825ULL, 0x000fc800078e001aULL, 0x0000001037377824ULL, 0x000fe200078e020cULL,
0x000000001a357faeULL, 0x0003e2000b901c46ULL, 0x00000010311c7825ULL, 0x000fc800078e001cULL,
0x00000010311e7825ULL, 0x040fe200078e001eULL, 0x000000001c377faeULL, 0x0003e6000b901c46ULL,
0x0000001031207825ULL, 0x040fe200078e0020ULL, 0x000000001e4d7faeULL, 0x0003e6000b901c46ULL,
0x0000001031227825ULL, 0x000fe200078e0022ULL, 0x00000000204f7faeULL, 0x0003e6000b901c46ULL,
0x0000001055557824ULL, 0x000fc400078e020cULL, 0x0000001031287825ULL, 0x000fc600078e0028ULL,
0x0000000022557faeULL, 0x0003e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e020cULL,
0x00000010312a7825ULL, 0x000fc600078e002aULL, 0x0000000028577faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fca00078e020cULL, 0x000000002a597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000a8006e307811ULL, 0x000fe400078e20ffULL,
0x00000014ff18723eULL, 0x002fe400000000ffULL, 0x00000002ff717819ULL, 0x000fe40000011604ULL,
0x0000541018747816ULL, 0x000fe40000000018ULL, 0x0000a800691c7811ULL, 0x000fc600078e20ffULL,
0x00001f7174717589ULL, 0x000fe800000e0000ULL, 0x00001f1374727589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000006b54783bULL, 0x000ea80000004200ULL, 0x000000006d5c783bULL, 0x000fe80000004200ULL,
0x000000006c58783bULL, 0x000fe80000004200ULL, 0x000000006a34783bULL, 0x000fe80000004200ULL,
0x000000001c1c783bULL, 0x000ee80000000200ULL, 0x00000000664c783bULL, 0x000f280000004200ULL,
0x000000006828783bULL, 0x000f680000004200ULL, 0x000000006720783bULL, 0x000f280000004200ULL,
0x000000006518783bULL, 0x000f220000004200ULL, 0x0000007130309232ULL, 0x002fc40000000000ULL,
0x0000007132329232ULL, 0x000fe40000000000ULL, 0x0000007231319232ULL, 0x080fe40000000000ULL,
0x0000007233339232ULL, 0x000fce0000000000ULL, 0x000000543050723cULL, 0x004fe20000001850ULL,
0x000000711c1c9232ULL, 0x008fce0000000000ULL, 0x0000005c303c723cULL, 0x000fe2000000183cULL,
0x000000711e1e9232ULL, 0x000fe40000000000ULL, 0x000000721d1d9232ULL, 0x080fe40000000000ULL,
0x000000721f1f9232ULL, 0x000fc60000000000ULL, 0x0000005e3040723cULL, 0x040ff00000001840ULL,
0x000000583044723cULL, 0x040ff00000001844ULL, 0x0000005a3048723cULL, 0x040ff00000001848ULL,
0x000000563024723cULL, 0x040ff00000001824ULL, 0x000000343038723cULL, 0x040ff00000001838ULL,
0x00000036302c723cULL, 0x000ff0000000182cULL, 0x0000004c1c50723cULL, 0x050ff00000001850ULL,
0x000000281c3c723cULL, 0x060ff0000000183cULL, 0x0000002a1c40723cULL, 0x040ff00000001840ULL,
0x000000201c44723cULL, 0x040ff00000001844ULL, 0x000000221c48723cULL, 0x040ff00000001848ULL,
0x0000004e1c4c723cULL, 0x040ff00000001824ULL, 0x000000181c38723cULL, 0x040ff00000001838ULL,
0x0000001a1c1c723cULL, 0x000fe2000000182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000177000720cULL, 0x000fe20003f26070ULL, 0x01469000ffff7f8cULL, 0x000fd8000c80043fULL,
0x000042a000001947ULL, 0x000fea0003800000ULL, 0x00000080101a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620063267a24ULL, 0x000fe200078e021aULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff217819ULL, 0x000fe20000011604ULL,
0x00000200ff277424ULL, 0x000fe200078e00ffULL, 0x0000001a17187217ULL, 0x000fe20007800000ULL,
0x0000000164297824ULL, 0x000fe200078e020fULL, 0x0000000421237810ULL, 0x000fe40007ffe0ffULL,
0x000000181a187210ULL, 0x000fe40007ffe1ffULL, 0x0000000423197212ULL, 0x040fe200078e3cffULL,
0x0000000823247824ULL, 0x040fe200078e00ffULL, 0x0000002018207817ULL, 0x000fe20003800000ULL,
0x00000001231a7824ULL, 0x000fe200078e0226ULL, 0x00000007211b7812ULL, 0x000fc400078e4804ULL,
0xfffffff824247812ULL, 0x000fe200078ee219ULL, 0x0000000121197824ULL, 0x040fe200078e0226ULL,
0x0000000c212d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008212b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0019187625ULL, 0x080fe200078e0027ULL, 0x000000202100720cULL, 0x080fe40003f26070ULL,
0x000000202300720cULL, 0x000fe20003f46070ULL, 0x000000082d317824ULL, 0x000fe200078e00ffULL,
0x0ffffff81b227812ULL, 0x000fe200078ef804ULL, 0x00005e001a1a7625ULL, 0x000fe200078e0027ULL,
0x000000042b287212ULL, 0x000fc400078e3cffULL, 0x000000032b2f7819ULL, 0x000fe200000006ffULL,
0x0000001022237824ULL, 0x000fe200078e026fULL, 0x000000042d2a7212ULL, 0x000fe200078e3cffULL,
0x0000001029187825ULL, 0x000fe200078e0018ULL, 0xfffffff82f287812ULL, 0x000fe400078ee228ULL,
0xfffffff8312a7812ULL, 0x000fe200078ee22aULL, 0x0000001024257824ULL, 0x000fe200078e026fULL,
0x00000010212f7810ULL, 0x000fe20007ffe0ffULL, 0x00000010291a7825ULL, 0x000fe200078e001aULL,
0x0000001421317810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018237faeULL, 0x0003e2000c901c46ULL, 0x0000001821337810ULL, 0x000fe20007ffe0ffULL,
0x000000082f2c7824ULL, 0x000fe200078e00ffULL, 0x0000001c21357810ULL, 0x000fe20007ffe0ffULL,
0x000000001a257faeULL, 0x0005e2000d101c46ULL, 0x00000008312e7824ULL, 0x000fe200078e00ffULL,
0x000000202b00720cULL, 0x080fe20003f26070ULL, 0x0000000833307824ULL, 0x000fe200078e00ffULL,
0x000000202d00720cULL, 0x080fe20003f46070ULL, 0x0000000835327824ULL, 0x000fe200078e00ffULL,
0x000000202f00720cULL, 0x080fe20003f66070ULL, 0x0000000131227824ULL, 0x140fe200078e0226ULL,
0x000000203100720cULL, 0x080fe20003f86070ULL, 0x000000012b187824ULL, 0x102fe200078e0226ULL,
0x000000203300720cULL, 0x080fe20003fa6070ULL, 0x00000010282b7824ULL, 0x000fe200078e026fULL,
0x000000203500720cULL, 0x000fe20003fc6070ULL, 0x000000012f207824ULL, 0x000fe200078e0226ULL,
0x000000262d1a7210ULL, 0x004fc40007ffe0ffULL, 0x000000042f197212ULL, 0x080fe400078e3cffULL,
0x00000004311b7212ULL, 0x000fe400078e3cffULL, 0x0000002633247210ULL, 0x000fe20007ffe0ffULL,
0x0000000135267824ULL, 0x000fe200078e0226ULL, 0x0000000433217212ULL, 0x080fe400078e3cffULL,
0x0000000435237212ULL, 0x000fe200078e3cffULL, 0x00005e0024247625ULL, 0x000fe200078e0027ULL,
0xfffffff82c2c7812ULL, 0x000fc400078ee219ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee21bULL,
0x00005e0018187625ULL, 0x080fe200078e0027ULL, 0xfffffff830307812ULL, 0x000fe400078ee221ULL,
0xfffffff832327812ULL, 0x000fe200078ee223ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0027ULL,
0x00005e0020207625ULL, 0x000fc800078e0027ULL, 0x00005e0022227625ULL, 0x000fc800078e0027ULL,
0x00005e0026267625ULL, 0x000fc800078e0027ULL, 0x0000001029187825ULL, 0x000fc800078e0018ULL,
0x00000010291a7825ULL, 0x040fe200078e001aULL, 0x00000000182b7faeULL, 0x0003e6000c901c46ULL,
0x0000001029207825ULL, 0x000fc800078e0020ULL, 0x0000001029227825ULL, 0x000fc800078e0022ULL,
0x0000001029247825ULL, 0x000fc800078e0024ULL, 0x0000001029267825ULL, 0x000fe200078e0026ULL,
0x0000006f2a297211ULL, 0x000fc600078e20ffULL, 0x000000102c2d7824ULL, 0x100fe400078e026fULL,
0x000000102e2f7824ULL, 0x100fe200078e026fULL, 0x000000001a297faeULL, 0x0003e2000d101c46ULL,
0x0000001030317824ULL, 0x100fe400078e026fULL, 0x0000001032337824ULL, 0x000fe200078e026fULL,
0x00000000202d7faeULL, 0x0003e8000d901c46ULL, 0x00000000222f7faeULL, 0x0003e8000e101c46ULL,
0x0000000024317faeULL, 0x0003e8000e901c46ULL, 0x0000000026337faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe20000011604ULL,
0x00000200ff2b7424ULL, 0x000fc400078e00ffULL, 0x00000001642d7824ULL, 0x000fe200078e020fULL,
0x0000000819237810ULL, 0x040fe40007ffe0ffULL, 0x0000000c19257810ULL, 0x040fe40007ffe0ffULL,
0x0000000419217810ULL, 0x000fe20007ffe0ffULL, 0x0000000823297824ULL, 0x040fe200078e00ffULL,
0x00000004231a7212ULL, 0x080fe200078e3cffULL, 0x0000000825307824ULL, 0x040fe200078e00ffULL,
0x00000004251b7212ULL, 0x080fe200078e3cffULL, 0x0000000121207824ULL, 0x140fe200078e0226ULL,
0x0000000421187212ULL, 0x000fe200078e3cffULL, 0x0000000123227824ULL, 0x100fe200078e0226ULL,
0x0000000321277819ULL, 0x000fe200000006ffULL, 0x0000000125247824ULL, 0x000fe200078e0226ULL,
0xfffffff8292e7812ULL, 0x000fc400078ee21aULL, 0xfffffff830307812ULL, 0x000fe400078ee21bULL,
0xfffffff8272c7812ULL, 0x000fe200078ee218ULL, 0x000000102e337824ULL, 0x000fe200078e026fULL,
0x00000007191b7812ULL, 0x040fe400078e4804ULL, 0x0000001419297810ULL, 0x040fe40007ffe0ffULL,
0x0000001019277810ULL, 0x040fe40007ffe0ffULL, 0x0000001c19317810ULL, 0x000fe20007ffe0ffULL,
0x0000000829347824ULL, 0x000fe200078e00ffULL, 0x00000018192f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127287824ULL, 0x000fe200078e0226ULL, 0x0000002619187210ULL, 0x000fe20007ffe0ffULL,
0x0000000831587824ULL, 0x000fe200078e00ffULL, 0x0ffffff81b1a7812ULL, 0x000fe200078ef804ULL,
0x000000012f367824ULL, 0x000fe200078e0226ULL, 0x00000004271b7212ULL, 0x040fe200078e3cffULL,
0x00005e0018187625ULL, 0x000fe200078e002bULL, 0x0000000327327819ULL, 0x000fc400000006ffULL,
0x0000000429217212ULL, 0x0c0fe200078e3cffULL, 0x00000001292a7824ULL, 0x100fe200078e0226ULL,
0x000000042f237212ULL, 0x080fe200078e3cffULL, 0x0000000131567824ULL, 0x000fe200078e0226ULL,
0x000000032f547819ULL, 0x000fe200000006ffULL, 0x000000101a2f7824ULL, 0x000fe200078e026fULL,
0x0000000431257212ULL, 0x000fe200078e3cffULL, 0x00005e002a267625ULL, 0x080fe200078e002bULL,
0xfffffff832327812ULL, 0x000fe400078ee21bULL, 0xfffffff834347812ULL, 0x000fe200078ee221ULL,
0x00005e00201a7625ULL, 0x000fe200078e002bULL, 0xfffffff854547812ULL, 0x000fc400078ee223ULL,
0xfffffff858587812ULL, 0x000fe200078ee225ULL, 0x00005e0022207625ULL, 0x000fc800078e002bULL,
0x00005e0024227625ULL, 0x000fc800078e002bULL, 0x00005e0028247625ULL, 0x000fc800078e002bULL,
0x00005e0036287625ULL, 0x000fc800078e002bULL, 0x000000102d187825ULL, 0x000fc800078e0018ULL,
0x00005e00562a7625ULL, 0x000fe200078e002bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000182f7faeULL, 0x0003e6000b901c46ULL, 0x000000102c317824ULL, 0x000fe400078e026fULL,
0x000000102d1a7825ULL, 0x000fc800078e001aULL, 0x000000102d207825ULL, 0x040fe200078e0020ULL,
0x000000001a317faeULL, 0x0005e2000b901c46ULL, 0x0000006f30197211ULL, 0x002fe400078e20ffULL,
0x000000102d227825ULL, 0x040fe200078e0022ULL, 0x0000000020337faeULL, 0x0005e6000b901c46ULL,
0x000000102d247825ULL, 0x040fe200078e0024ULL, 0x0000000022197faeULL, 0x0005e6000b901c46ULL,
0x000000102d267825ULL, 0x000fc800078e0026ULL, 0x000000102d287825ULL, 0x000fc800078e0028ULL,
0x000000102d2a7825ULL, 0x000fc800078e002aULL, 0x00000010322d7824ULL, 0x100fe400078e026fULL,
0x00000010342f7824ULL, 0x100fe400078e026fULL, 0x0000001054357824ULL, 0x100fe200078e026fULL,
0x00000000242d7faeULL, 0x0005e2000b901c46ULL, 0x0000001058377824ULL, 0x000fc600078e026fULL,
0x00000000262f7faeULL, 0x0005e8000b901c46ULL, 0x0000000028357faeULL, 0x0005e8000b901c46ULL,
0x000000002a377faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01464800641a7f8cULL, 0x006fe8000c80043fULL,
0x01464c0064197984ULL, 0x000e640000000800ULL, 0x8000000019ff7812ULL, 0x002fc4000782481bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e00000000187802ULL, 0x000fc80000000f00ULL,
0x0000001800197305ULL, 0x0002a4000021f000ULL, 0x3fa0000018187823ULL, 0x002fe200000100ffULL,
0x000000190000735dULL, 0x004fe40003800000ULL, 0x01464c0064197984ULL, 0x000e640000000800ULL,
0x8000000019ff7812ULL, 0x002fe4000782481bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01410000151b7984ULL, 0x000e680000000800ULL, 0x0143000015217984ULL, 0x0004e20000000800ULL,
0x000000621b00720bULL, 0x002fe20003f3d000ULL, 0x0000f8527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x004fc800008e0100ULL, 0x0000ffff18207812ULL, 0x000fe2000782c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff1a7424ULL, 0x000fd600078e00ffULL,
0x0000037000009947ULL, 0x000fea0003800000ULL, 0x000000026000780cULL, 0x000fe40003f25270ULL,
0x000000621b00720bULL, 0x000fe20003f54000ULL, 0x0000f8227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000187806ULL, 0x000fe400010e0100ULL, 0x0000001b62197209ULL, 0x000fe40007810000ULL,
0x0000ffff18237812ULL, 0x000fe400078e3cffULL, 0x00000002ff317819ULL, 0x000fe20000011604ULL,
0x80000019621a7221ULL, 0x000fe20000010000ULL, 0x0145001915009388ULL, 0x0003e20000000800ULL,
0x0000002320ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b1a1a7820ULL, 0x000fc80000410000ULL,
0x0000001a00287308ULL, 0x000ea40000000800ULL, 0x0000002816167220ULL, 0x004fe20000410000ULL,
0x0000f7c27f007947ULL, 0x000fea000b800000ULL, 0x00001f3128187589ULL, 0x0022a400000e0000ULL,
0x000000183c3c7220ULL, 0x084fe20000410000ULL, 0x000000183d3d7220ULL, 0x080fe20000410000ULL,
0x0000001840407220ULL, 0x080fe20000410000ULL, 0x0000001841417220ULL, 0x080fe20000410000ULL,
0x0000001844447220ULL, 0x080fe20000410000ULL, 0x0000001845457220ULL, 0x080fe20000410000ULL,
0x0000001848487220ULL, 0x080fe20000410000ULL, 0x0000001849497220ULL, 0x080fe20000410000ULL,
0x0000001850507220ULL, 0x080fe20000410000ULL, 0x0000001851517220ULL, 0x080fe20000410000ULL,
0x000000184c4c7220ULL, 0x080fe20000410000ULL, 0x000000184d4d7220ULL, 0x080fe20000410000ULL,
0x0000001838387220ULL, 0x080fe20000410000ULL, 0x0000001839397220ULL, 0x080fe20000410000ULL,
0x000000181c1c7220ULL, 0x080fe20000410000ULL, 0x000000181d1d7220ULL, 0x000fe20000410000ULL,
0x0000f7027f007947ULL, 0x000fea000b800000ULL, 0x00001f1328187589ULL, 0x00052400000e0000ULL,
0x0000001b62627209ULL, 0x000fe20007810000ULL, 0x000000183e3e7220ULL, 0x090fe20000410000ULL,
0x00000001ff1a7807ULL, 0x000fe20000800000ULL, 0x000000183f3f7220ULL, 0x080fe20000410000ULL,
0x0000001842427220ULL, 0x080fe20000410000ULL, 0x800000621b1b1221ULL, 0x000fe20000010000ULL,
0x0000001843437220ULL, 0x080fe20000410000ULL, 0x0000001846467220ULL, 0x080fe20000410000ULL,
0x0000001847477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b1b1b1820ULL, 0x000fe20000410000ULL,
0x000000184a4a7220ULL, 0x080fe20000410000ULL, 0x000000184b4b7220ULL, 0x080fe20000410000ULL,
0x0000001852527220ULL, 0x080fe20000410000ULL, 0x0000001b00141308ULL, 0x000f220000000800ULL,
0x0000001853537220ULL, 0x080fe20000410000ULL, 0x000000184e4e7220ULL, 0x080fe20000410000ULL,
0x000000184f4f7220ULL, 0x080fe20000410000ULL, 0x000000183a3a7220ULL, 0x080fe20000410000ULL,
0x000000183b3b7220ULL, 0x080fe20000410000ULL, 0x000000181e1e7220ULL, 0x080fe20000410000ULL,
0x000000181f1f7220ULL, 0x000fe20000410000ULL, 0x0000002114211220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000014ff18723eULL, 0x000fe200000000ffULL,
0x0000001621167221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff317819ULL, 0x002fe40000011604ULL, 0x0000541018287816ULL, 0x004fe20000000018ULL,
0x0000f5927f007947ULL, 0x000fea000b800000ULL, 0x00001f3128717589ULL, 0x0002a800000e0000ULL,
0x00001f1328707589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0012ULL, 0xffffffff002b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe200078e00ffULL, 0x000069f000187802ULL, 0x000fc40000000f00ULL,
0x0000fda000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0011ULL, 0x00006a5000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x0000fd4000007944ULL, 0x00cfea0003c00000ULL, 0x0000b0000d307811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b5c783bULL, 0x000fe20000004200ULL,
0x0000b00007187811ULL, 0x000fe400078e20ffULL, 0x000099101a207816ULL, 0x000fe200000000ffULL,
0x000000003030783bULL, 0x002e660000000200ULL, 0x000000ff2000720cULL, 0x000fe20003f25270ULL,
0x000000000954783bULL, 0x000fe80000004200ULL, 0x000000000a58783bULL, 0x000fe80000004200ULL,
0x000000000834783bULL, 0x000fe80000004200ULL, 0x000000001818783bULL, 0x000f280000000200ULL,
0x00000000062c783bULL, 0x004ea80000004200ULL, 0x000000000324783bULL, 0x000f680000004200ULL,
0x000000000528783bULL, 0x000ee80000004200ULL, 0x000000000220783bULL, 0x000ea20000004200ULL,
0x0000007130309232ULL, 0x002fc40000000000ULL, 0x0000007132329232ULL, 0x000fe40000000000ULL,
0x0000007031319232ULL, 0x088fe40000000000ULL, 0x0000007033339232ULL, 0x000fce0000000000ULL,
0x0000005c303c723cULL, 0x000fe2000000183cULL, 0x0000007118189232ULL, 0x090fe40000000000ULL,
0x000000711a1a9232ULL, 0x000fe40000000000ULL, 0x0000007019199232ULL, 0x000fc60000000000ULL,
0x0000005e3040723cULL, 0x000fe20000001840ULL, 0x000000701b1b9232ULL, 0x000fe20000000000ULL,
0x000000a010707810ULL, 0x000fcc0007ffe0ffULL, 0x000000543050723cULL, 0x040ff00000001850ULL,
0x000000583044723cULL, 0x040ff00000001844ULL, 0x0000005a3048723cULL, 0x040ff00000001848ULL,
0x00000056304c723cULL, 0x040ff0000000184cULL, 0x000000343038723cULL, 0x040ff00000001838ULL,
0x00000036301c723cULL, 0x000ff0000000181cULL, 0x0000002c183c723cULL, 0x044ff0000000183cULL,
0x0000002e1840723cULL, 0x040ff00000001840ULL, 0x000000241850723cULL, 0x060ff00000001850ULL,
0x000000281844723cULL, 0x040ff00000001844ULL, 0x0000002a1848723cULL, 0x040ff00000001848ULL,
0x000000261824723cULL, 0x040ff0000000184cULL, 0x000000201838723cULL, 0x040fee0000001838ULL,
0x0000620063207a24ULL, 0x000fe200078e0270ULL, 0x00000022182c723cULL, 0x000fe2000000181cULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe20000011604ULL, 0x0000000164237824ULL, 0x000fe200078e020fULL,
0x0000007017197217ULL, 0x000fe40007800000ULL, 0x000000041f1d7810ULL, 0x040fe40007ffe0ffULL,
0x000000101f4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x000fe200078e0a70ULL,
0x000000041d187212ULL, 0x040fe200078e3cffULL, 0x000000081d2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c1f357810ULL, 0x000fe20007ffe0ffULL, 0x000000084d1c7824ULL, 0x000fe200078e00ffULL,
0x000000081f317810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee218ULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0x0000000431187212ULL, 0x0c0fe400078e3cffULL,
0x0000000331337819ULL, 0x000fe200000006ffULL, 0x000000102b2b7824ULL, 0x000fe200078e020cULL,
0x000000044d1b7212ULL, 0x080fe400078e3cffULL, 0x00000004351a7212ULL, 0x000fe400078e3cffULL,
0x00000020191e7817ULL, 0x000fc40003800000ULL, 0xfffffff833337812ULL, 0x000fe200078ee218ULL,
0x000000011f187824ULL, 0x100fe200078e0220ULL, 0xfffffff81c4f7812ULL, 0x000fe200078ee21bULL,
0x00000001311c7824ULL, 0x000fe200078e0220ULL, 0x0000020000217802ULL, 0x000fe20000000f00ULL,
0x0000001033337824ULL, 0x000fe200078e020cULL, 0xfffffff837377812ULL, 0x000fe200078ee21aULL,
0x000000011d1a7824ULL, 0x000fe200078e0220ULL, 0x000000071f1b7812ULL, 0x040fe200078e4804ULL,
0x00005e0018187625ULL, 0x000fe200078e0021ULL, 0x0000001e1f00720cULL, 0x000fc40003f46070ULL,
0x0000001e1d00720cULL, 0x080fe20003f66070ULL, 0x00005e001c1c7625ULL, 0x080fe200078e0021ULL,
0x0ffffff81b297812ULL, 0x000fe400078ef804ULL, 0x000000141f557810ULL, 0x000fe20007ffe0ffULL,
0x00005e001a1a7625ULL, 0x000fe200078e0021ULL, 0x0000001e3100720cULL, 0x000fe40003f86070ULL,
0x0000000c29297211ULL, 0x000fe200078e20ffULL, 0x0000000855317824ULL, 0x040fe200078e00ffULL,
0x0000000455227212ULL, 0x000fe200078e3cffULL, 0x0000001023187825ULL, 0x000fe200078e0018ULL,
0x000000181f577810ULL, 0x000fc40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe200078ee222ULL,
0x00000010231a7825ULL, 0x000fe200078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018297faeULL, 0x0003e2000d101c46ULL, 0x0000001c1f597810ULL, 0x000fe40007ffe0ffULL,
0x00000010231c7825ULL, 0x000fe200078e001cULL, 0x000000001a2b7faeULL, 0x0005e2000d901c46ULL,
0x00000004571f7212ULL, 0x040fe400078e3cffULL, 0x0000000857227824ULL, 0x000fe200078e00ffULL,
0x000000001c337faeULL, 0x0007e2000e101c46ULL, 0x0000001e3500720cULL, 0x080fe20003f46070ULL,
0x000000104f4f7824ULL, 0x000fe200078e020cULL, 0x0000001e4d00720cULL, 0x080fe20003f66070ULL,
0x0000000135187824ULL, 0x002fe200078e0220ULL, 0x0000001e5500720cULL, 0x080fe20003f86070ULL,
0x0000001031317824ULL, 0x000fe200078e020cULL, 0x0000001e5700720cULL, 0x000fe20003fa6070ULL,
0x00000008592b7824ULL, 0x004fe200078e00ffULL, 0x000000204d1a7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0021ULL, 0x0000001e5900720cULL, 0x000fc40003fc6070ULL,
0xfffffff822297812ULL, 0x000fe200078ee21fULL, 0x00000001551c7824ULL, 0x108fe200078e0220ULL,
0x0000000459227212ULL, 0x000fe200078e3cffULL, 0x00000001571e7824ULL, 0x100fe200078e0220ULL,
0x0000000c37377211ULL, 0x000fe200078e20ffULL, 0x0000000159207824ULL, 0x000fe200078e0220ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee222ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0021ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0021ULL,
0x00005e0020207625ULL, 0x000fc800078e0021ULL, 0x0000001023187825ULL, 0x000fc800078e0018ULL,
0x00000010231a7825ULL, 0x040fe200078e001aULL, 0x0000000018377faeULL, 0x0003e6000d101c46ULL,
0x00000010231c7825ULL, 0x040fe200078e001cULL, 0x000000001a4f7faeULL, 0x0003e6000d901c46ULL,
0x00000010231e7825ULL, 0x000fe200078e001eULL, 0x000000001c317faeULL, 0x0003e6000e101c46ULL,
0x0000001029297824ULL, 0x000fc400078e020cULL, 0x0000001023207825ULL, 0x000fc600078e0020ULL,
0x000000001e297faeULL, 0x0003e2000e901c46ULL, 0x000000102b2b7824ULL, 0x000fca00078e020cULL,
0x00000000202b7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff197819ULL, 0x000fe20000011604ULL, 0x00000200ff2b7424ULL, 0x000fe400078e00ffULL,
0x0000000164317824ULL, 0x000fe200078e020fULL, 0x0000000c19217810ULL, 0x040fe40007ffe0ffULL,
0x00000008191f7810ULL, 0x040fe40007ffe0ffULL, 0x00000004191d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008211c7824ULL, 0x040fe200078e00ffULL, 0x00000004211b7212ULL, 0x080fe200078e3cffULL,
0x000000081f377824ULL, 0x000fe200078e00ffULL, 0x000000041d187212ULL, 0x000fe200078e3cffULL,
0x00000001211e7824ULL, 0x000fe200078e0220ULL, 0x000000031d357819ULL, 0x000fc400000006ffULL,
0xfffffff81c4d7812ULL, 0x000fe200078ee21bULL, 0x000000011f1c7824ULL, 0x040fe200078e0220ULL,
0x000000041f1a7212ULL, 0x000fe400078e3cffULL, 0x00000007191b7812ULL, 0x040fe400078e4804ULL,
0x0000001419297810ULL, 0x040fe40007ffe0ffULL, 0x0000001019237810ULL, 0x040fe40007ffe0ffULL,
0x0000001819337810ULL, 0x000fe20007ffe0ffULL, 0x0000000829347824ULL, 0x000fe200078e00ffULL,
0x0000001c194f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000123227824ULL, 0x000fe200078e0220ULL,
0xfffffff835357812ULL, 0x000fe200078ee218ULL, 0x0000000129287824ULL, 0x000fe200078e0220ULL,
0xfffffff837377812ULL, 0x000fe200078ee21aULL, 0x000000011d1a7824ULL, 0x100fe200078e0220ULL,
0x0000002019187210ULL, 0x000fe20007ffe0ffULL, 0x00000001332a7824ULL, 0x000fe200078e0220ULL,
0x0ffffff81b1b7812ULL, 0x000fe200078ef804ULL, 0x000000014f307824ULL, 0x000fe200078e0220ULL,
0x00000004231d7212ULL, 0x080fe200078e3cffULL, 0x000000084f367824ULL, 0x000fe200078e00ffULL,
0x0000000323327819ULL, 0x000fe200000006ffULL, 0x00005e0018187625ULL, 0x000fe200078e002bULL,
0x00000004291f7212ULL, 0x000fc400078e3cffULL, 0x0000000433207212ULL, 0x080fe200078e3cffULL,
0x0000001035357824ULL, 0x100fe200078e020cULL, 0x0000000333577819ULL, 0x000fe200000006ffULL,
0x000000101b337824ULL, 0x000fe200078e020cULL, 0x000000044f217212ULL, 0x000fe200078e3cffULL,
0x00005e001a1a7625ULL, 0x080fe200078e002bULL, 0xfffffff8324f7812ULL, 0x000fe400078ee21dULL,
0xfffffff834557812ULL, 0x000fe200078ee21fULL, 0x00005e001c1c7625ULL, 0x000fe200078e002bULL,
0xfffffff857577812ULL, 0x000fc400078ee220ULL, 0xfffffff836597812ULL, 0x000fe200078ee221ULL,
0x00005e001e1e7625ULL, 0x000fe200078e002bULL, 0x0000000c4d4d7211ULL, 0x000fc600078e20ffULL,
0x00005e0022207625ULL, 0x000fc800078e002bULL, 0x00005e0028227625ULL, 0x000fc800078e002bULL,
0x0000001031187825ULL, 0x000fc800078e0018ULL, 0x00005e002a287625ULL, 0x080fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018337faeULL, 0x0003e6000b901c46ULL,
0x00005e00302a7625ULL, 0x000fc800078e002bULL, 0x00000010311a7825ULL, 0x000fc800078e001aULL,
0x0000001037377824ULL, 0x000fe200078e020cULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x00000010311c7825ULL, 0x000fc800078e001cULL, 0x00000010311e7825ULL, 0x040fe200078e001eULL,
0x000000001c377faeULL, 0x0003e6000b901c46ULL, 0x0000001031207825ULL, 0x000fe200078e0020ULL,
0x000000001e4d7faeULL, 0x0003e6000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e020cULL,
0x0000001031227825ULL, 0x000fc600078e0022ULL, 0x00000000204f7faeULL, 0x0003e2000b901c46ULL,
0x0000001055557824ULL, 0x000fe400078e020cULL, 0x0000001031287825ULL, 0x000fc600078e0028ULL,
0x0000000022557faeULL, 0x0003e2000b901c46ULL, 0x0000001057577824ULL, 0x000fe400078e020cULL,
0x00000010312a7825ULL, 0x000fc600078e002aULL, 0x0000000028577faeULL, 0x0003e2000b901c46ULL,
0x0000001059597824ULL, 0x000fca00078e020cULL, 0x000000002a597faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000b0006e307811ULL, 0x000fe400078e20ffULL,
0x00000014ff18723eULL, 0x002fe400000000ffULL, 0x00000002ff717819ULL, 0x000fe40000011604ULL,
0x0000541018747816ULL, 0x000fe40000000018ULL, 0x0000b000691c7811ULL, 0x000fc600078e20ffULL,
0x00001f7174717589ULL, 0x000fe800000e0000ULL, 0x00001f1374727589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003030783bULL, 0x000e680000000200ULL,
0x000000006b54783bULL, 0x000ea80000004200ULL, 0x000000006d5c783bULL, 0x000fe80000004200ULL,
0x000000006c58783bULL, 0x000fe80000004200ULL, 0x000000006a34783bULL, 0x000fe80000004200ULL,
0x000000001c1c783bULL, 0x000ee80000000200ULL, 0x00000000664c783bULL, 0x000f280000004200ULL,
0x000000006828783bULL, 0x000f680000004200ULL, 0x000000006720783bULL, 0x000f280000004200ULL,
0x000000006518783bULL, 0x000f220000004200ULL, 0x0000007130309232ULL, 0x002fc40000000000ULL,
0x0000007132329232ULL, 0x000fe40000000000ULL, 0x0000007231319232ULL, 0x080fe40000000000ULL,
0x0000007233339232ULL, 0x000fce0000000000ULL, 0x000000543050723cULL, 0x004fe20000001850ULL,
0x000000711c1c9232ULL, 0x008fce0000000000ULL, 0x0000005c303c723cULL, 0x000fe2000000183cULL,
0x000000711e1e9232ULL, 0x000fe40000000000ULL, 0x000000721d1d9232ULL, 0x080fe40000000000ULL,
0x000000721f1f9232ULL, 0x000fc60000000000ULL, 0x0000005e3040723cULL, 0x040ff00000001840ULL,
0x000000583044723cULL, 0x040ff00000001844ULL, 0x0000005a3048723cULL, 0x040ff00000001848ULL,
0x000000563024723cULL, 0x040ff00000001824ULL, 0x000000343038723cULL, 0x040ff00000001838ULL,
0x00000036302c723cULL, 0x000ff0000000182cULL, 0x0000004c1c50723cULL, 0x050ff00000001850ULL,
0x000000281c3c723cULL, 0x060ff0000000183cULL, 0x0000002a1c40723cULL, 0x040ff00000001840ULL,
0x000000201c44723cULL, 0x040ff00000001844ULL, 0x000000221c48723cULL, 0x040ff00000001848ULL,
0x0000004e1c4c723cULL, 0x040ff00000001824ULL, 0x000000181c38723cULL, 0x040ff00000001838ULL,
0x0000001a1c1c723cULL, 0x000fe2000000182cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000177000720cULL, 0x000fe20003f26070ULL, 0x01469800ffff7f8cULL, 0x000fd8000c80043fULL,
0x0000216000001947ULL, 0x000fea0003800000ULL, 0x000000c010187810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000620063287a24ULL, 0x000fe200078e0218ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x0000001817107217ULL, 0x000fe20007800000ULL,
0x00000200ff297424ULL, 0x000fe200078e00ffULL, 0x00000003ff1b7819ULL, 0x000fe40000011604ULL,
0x0000000f642b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a18ULL,
0x000000071b197812ULL, 0x040fe200078e4804ULL, 0x000000011b187824ULL, 0x040fe200078e0228ULL,
0x0000000c1b277810ULL, 0x000fe40007ffe0ffULL, 0x0000002010107817ULL, 0x000fc40003800000ULL,
0x000000041b237810ULL, 0x000fe20007ffe0ffULL, 0x0000000827317824ULL, 0x000fe200078e00ffULL,
0x000000081b257810ULL, 0x040fe40007ffe0ffULL, 0x000000101b00720cULL, 0x000fe20003f06070ULL,
0x00000008232d7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8191a7812ULL, 0x000fe200078ef804ULL,
0x00005e0018187625ULL, 0x000fe200078e0029ULL, 0x0000000425227212ULL, 0x0c0fe400078e3cffULL,
0x00000003252f7819ULL, 0x000fe200000006ffULL, 0x000000101a217824ULL, 0x000fe200078e026fULL,
0x0000000427247212ULL, 0x080fe200078e3cffULL, 0x000000102b187825ULL, 0x000fe200078e0018ULL,
0x0000000423207212ULL, 0x000fc400078e3cffULL, 0xfffffff82f2c7812ULL, 0x000fe200078ee222ULL,
0x00000001251a7824ULL, 0x000fe200078e0228ULL, 0xfffffff8312e7812ULL, 0x000fe200078ee224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018217faeULL, 0x0003e2000c101c46ULL,
0x000000141b2f7810ULL, 0x040fe40007ffe0ffULL, 0x000000181b317810ULL, 0x040fe40007ffe0ffULL,
0x0000001c1b337810ULL, 0x000fe20007ffe0ffULL, 0x000000082f307824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee220ULL, 0x0000000831327824ULL, 0x000fe200078e00ffULL,
0x000000101b2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000833347824ULL, 0x000fe200078e00ffULL,
0x0000002827207210ULL, 0x000fe20007ffe0ffULL, 0x0000000123187824ULL, 0x102fe200078e0228ULL,
0x000000042f197212ULL, 0x000fe200078e3cffULL, 0x000000012d227824ULL, 0x100fe200078e0228ULL,
0x0000002831267210ULL, 0x000fe20007ffe0ffULL, 0x000000012f247824ULL, 0x100fe200078e0228ULL,
0x00000004311b7212ULL, 0x080fe200078e3cffULL, 0x0000000133287824ULL, 0x040fe200078e0228ULL,
0x0000000433217212ULL, 0x000fc400078e3cffULL, 0x000000102300720cULL, 0x080fe20003f06070ULL,
0x00005e0022227625ULL, 0x080fe200078e0029ULL, 0x000000102500720cULL, 0x080fe40003f26070ULL,
0x000000102700720cULL, 0x080fe20003f46070ULL, 0x00005e0024247625ULL, 0x080fe200078e0029ULL,
0x000000102d00720cULL, 0x080fe40003f66070ULL, 0x000000102f00720cULL, 0x080fe20003f86070ULL,
0x00005e0026267625ULL, 0x000fe200078e0029ULL, 0x000000103100720cULL, 0x000fc40003fa6070ULL,
0x000000103300720cULL, 0x000fe20003fc6070ULL, 0x000000102b227825ULL, 0x000fe200078e0022ULL,
0xfffffff830307812ULL, 0x000fe400078ee219ULL, 0xfffffff832327812ULL, 0x000fe200078ee21bULL,
0x00005e0018187625ULL, 0x080fe200078e0029ULL, 0xfffffff834347812ULL, 0x000fe400078ee221ULL,
0x000000042d107212ULL, 0x000fe200078e3cffULL, 0x00005e001a1a7625ULL, 0x000fc800078e0029ULL,
0x00005e0020207625ULL, 0x000fc800078e0029ULL, 0x000000082d2d7824ULL, 0x000fe400078e00ffULL,
0x00005e0028287625ULL, 0x000fc600078e0029ULL, 0xfffffff82d107812ULL, 0x000fe200078ee210ULL,
0x000000102b187825ULL, 0x000fe200078e0018ULL, 0x0000006f2c2d7211ULL, 0x000fc600078e20ffULL,
0x000000102b1a7825ULL, 0x000fc800078e001aULL, 0x000000102b207825ULL, 0x000fc800078e0020ULL,
0x000000102b247825ULL, 0x000fc800078e0024ULL, 0x000000102b267825ULL, 0x000fc800078e0026ULL,
0x000000102b287825ULL, 0x000fc800078e0028ULL, 0x000000102a2b7824ULL, 0x100fe400078e026fULL,
0x000000102e2f7824ULL, 0x100fe400078e026fULL, 0x0000001010317824ULL, 0x100fe200078e026fULL,
0x00000000182b7faeULL, 0x0003e2000c101c46ULL, 0x0000001030337824ULL, 0x100fe400078e026fULL,
0x0000001032357824ULL, 0x000fe200078e026fULL, 0x0000006f346f7211ULL, 0x000fe200078e20ffULL,
0x000000001a2d7faeULL, 0x0003e8000c901c46ULL, 0x00000000202f7faeULL, 0x0003e8000d101c46ULL,
0x0000000022317faeULL, 0x0003e8000d901c46ULL, 0x0000000024337faeULL, 0x0003e8000e101c46ULL,
0x0000000026357faeULL, 0x0003e8000e901c46ULL, 0x00000000286f7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff197819ULL, 0x000fe20000011604ULL,
0x00000001642d7824ULL, 0x000fe200078e020fULL, 0x00000200002b7802ULL, 0x000fc40000000f00ULL,
0x0000000419217810ULL, 0x040fe40007ffe0ffULL, 0x0000000819237810ULL, 0x040fe40007ffe0ffULL,
0x0000000c19257810ULL, 0x000fe20007ffe0ffULL, 0x00000008211b7824ULL, 0x040fe200078e00ffULL,
0x0000000421107212ULL, 0x080fe200078e3cffULL, 0x0000000823277824ULL, 0x040fe200078e00ffULL,
0x0000000423187212ULL, 0x080fe200078e3cffULL, 0x0000000825297824ULL, 0x040fe200078e00ffULL,
0x00000004251a7212ULL, 0x000fe200078e3cffULL, 0x0000000123207824ULL, 0x000fe200078e0228ULL,
0xfffffff81b2c7812ULL, 0x000fe200078ee210ULL, 0x0000000125227824ULL, 0x000fe200078e0228ULL,
0xfffffff8272e7812ULL, 0x000fe200078ee218ULL, 0x0000000119187824ULL, 0x000fe200078e0228ULL,
0xfffffff829307812ULL, 0x000fe200078ee21aULL, 0x00000001211a7824ULL, 0x000fe200078e0228ULL,
0x00000007191b7812ULL, 0x000fc400078e4804ULL, 0x0000001019277810ULL, 0x040fe40007ffe0ffULL,
0x0000001419297810ULL, 0x040fe40007ffe0ffULL, 0x00000018192f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000827327824ULL, 0x000fe200078e00ffULL, 0x0000001c19317810ULL, 0x000fe20007ffe0ffULL,
0x0000000129267824ULL, 0x000fe200078e0228ULL, 0x0ffffff81b107812ULL, 0x000fe200078ef804ULL,
0x0000000829347824ULL, 0x000fe200078e00ffULL, 0x0000002827247210ULL, 0x000fe20007ffe0ffULL,
0x000000012f2a7824ULL, 0x000fe200078e0228ULL, 0x00000004271b7212ULL, 0x000fe200078e3cffULL,
0x0000000831547824ULL, 0x040fe200078e00ffULL, 0x0000002831367210ULL, 0x000fe20007ffe0ffULL,
0x000000082f287824ULL, 0x000fe200078e00ffULL, 0x0000000429217212ULL, 0x080fe200078e3cffULL,
0x00005e0018187625ULL, 0x000fe200078e002bULL, 0x000000042f237212ULL, 0x000fc400078e3cffULL,
0x0000000431257212ULL, 0x000fe200078e3cffULL, 0x00000010102f7824ULL, 0x000fe200078e026fULL,
0xfffffff832107812ULL, 0x000fe200078ee21bULL, 0x00005e001a1a7625ULL, 0x080fe200078e002bULL,
0xfffffff834327812ULL, 0x000fe400078ee221ULL, 0xfffffff828347812ULL, 0x000fe200078ee223ULL,
0x00005e0020207625ULL, 0x000fe200078e002bULL, 0xfffffff854547812ULL, 0x000fc600078ee225ULL,
0x00005e0022227625ULL, 0x000fc800078e002bULL, 0x00005e0024247625ULL, 0x000fc800078e002bULL,
0x00005e0026267625ULL, 0x000fc800078e002bULL, 0x00005e002a287625ULL, 0x000fc800078e002bULL,
0x000000102d187825ULL, 0x000fc800078e0018ULL, 0x00005e00362a7625ULL, 0x000fe200078e002bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000182f7faeULL, 0x0003e6000b901c46ULL,
0x000000102d1a7825ULL, 0x000fc800078e001aULL, 0x000000102d207825ULL, 0x000fc800078e0020ULL,
0x000000102d227825ULL, 0x000fc800078e0022ULL, 0x000000102d247825ULL, 0x000fc800078e0024ULL,
0x000000102d267825ULL, 0x000fc800078e0026ULL, 0x000000102d287825ULL, 0x000fc800078e0028ULL,
0x000000102d2a7825ULL, 0x000fe200078e002aULL, 0x0000006f2e2d7211ULL, 0x000fc600078e20ffULL,
0x000000102c197824ULL, 0x102fe400078e026fULL, 0x00000010302f7824ULL, 0x100fe400078e026fULL,
0x0000001010317824ULL, 0x100fe200078e026fULL, 0x000000001a197faeULL, 0x0003e2000b901c46ULL,
0x0000001032337824ULL, 0x100fe400078e026fULL, 0x0000001034357824ULL, 0x000fe200078e026fULL,
0x0000006f546f7211ULL, 0x000fe200078e20ffULL, 0x00000000202d7faeULL, 0x0003e8000b901c46ULL,
0x00000000222f7faeULL, 0x0003e8000b901c46ULL, 0x0000000024317faeULL, 0x0003e8000b901c46ULL,
0x0000000026337faeULL, 0x0003e8000b901c46ULL, 0x0000000028357faeULL, 0x0003e8000b901c46ULL,
0x000000002a6f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0146680064187f8cULL, 0x002fe8000c80043fULL,
0x01466c00641b7984ULL, 0x000e640000000800ULL, 0x800000001bff7812ULL, 0x002fc40007804819ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e000000ff107424ULL, 0x000fc800078e00ffULL,
0x00000010001a7305ULL, 0x0002a4000021f000ULL, 0x3fa0000010107823ULL, 0x002fe200000100ffULL,
0x0000001a0000735dULL, 0x004fe20003800000ULL, 0x01466c00641b7984ULL, 0x000e640000000800ULL,
0x800000001bff7812ULL, 0x002fe40007804819ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01418000151b7984ULL, 0x000e680000000800ULL, 0x0143800015217984ULL, 0x0004e20000000800ULL,
0x000000621b00720bULL, 0x002fe20003f1d000ULL, 0x0000d9427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x004fc800000e0100ULL, 0x0000ffff10207812ULL, 0x000fe2000780c0ffULL,
0x000003a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x000000036000780cULL, 0x000fe40003f05270ULL,
0x000000621b00720bULL, 0x000fe20003f34000ULL, 0x0000d9127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000e7806ULL, 0x000fe400008e0100ULL, 0x0000001b62107209ULL, 0x000fe40007810000ULL,
0x0000ffff0e197812ULL, 0x000fe400078e3cffULL, 0x00000002ff317819ULL, 0x000fe20000011604ULL,
0x8000001062187221ULL, 0x000fe20000010000ULL, 0x0145801015008388ULL, 0x0003e20000000800ULL,
0x0000001920ff7212ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b18187820ULL, 0x000fc80000410000ULL,
0x0000001800287308ULL, 0x000ea40000000800ULL, 0x0000002816167220ULL, 0x004fe20000410000ULL,
0x0000d8b27f007947ULL, 0x000fea000b800000ULL, 0x00001f31280e7589ULL, 0x0022a400000e0000ULL,
0x0000000e3c3c7220ULL, 0x084fe20000410000ULL, 0x0000000e3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000e40407220ULL, 0x080fe20000410000ULL, 0x0000000e41417220ULL, 0x080fe20000410000ULL,
0x0000000e44447220ULL, 0x080fe20000410000ULL, 0x0000000e45457220ULL, 0x080fe20000410000ULL,
0x0000000e48487220ULL, 0x080fe20000410000ULL, 0x0000000e49497220ULL, 0x080fe20000410000ULL,
0x0000000e50507220ULL, 0x080fe20000410000ULL, 0x0000000e51517220ULL, 0x080fe20000410000ULL,
0x0000000e4c4c7220ULL, 0x080fe20000410000ULL, 0x0000000e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000000e38387220ULL, 0x080fe20000410000ULL, 0x0000000e39397220ULL, 0x080fe20000410000ULL,
0x0000000e1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000e1d1d7220ULL, 0x000fe20000410000ULL,
0x0000d7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f13280e7589ULL, 0x00052400000e0000ULL,
0x0000001b62627209ULL, 0x000fe20007810000ULL, 0x0000000e3e3e7220ULL, 0x090fe20000410000ULL,
0x00000001ff107807ULL, 0x000fe20000000000ULL, 0x0000000e3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000e42427220ULL, 0x080fe20000410000ULL, 0x800000621b1b0221ULL, 0x000fe20000010000ULL,
0x0000000e43437220ULL, 0x080fe20000410000ULL, 0x0000000e46467220ULL, 0x080fe20000410000ULL,
0x0000000e47477220ULL, 0x080fe20000410000ULL, 0x3fb8aa3b1b1b0820ULL, 0x000fe20000410000ULL,
0x0000000e4a4a7220ULL, 0x080fe20000410000ULL, 0x0000000e4b4b7220ULL, 0x080fe20000410000ULL,
0x0000000e52527220ULL, 0x080fe20000410000ULL, 0x0000001b00140308ULL, 0x000f220000000800ULL,
0x0000000e53537220ULL, 0x080fe20000410000ULL, 0x0000000e4e4e7220ULL, 0x080fe20000410000ULL,
0x0000000e4f4f7220ULL, 0x080fe20000410000ULL, 0x0000000e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000e1f1f7220ULL, 0x000fe20000410000ULL, 0x0000002114210220ULL, 0x018fc40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000014ff0e723eULL, 0x000fe200000000ffULL,
0x0000001621167221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff317819ULL, 0x002fe40000011604ULL, 0x000054100e287816ULL, 0x004fe2000000000eULL,
0x0000d6827f007947ULL, 0x000fea000b800000ULL, 0x00001f3128157589ULL, 0x0002a800000e0000ULL,
0x00001f13280e7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0012ULL, 0x0000001f002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00008b3000187802ULL, 0x000fc40000000f00ULL,
0x0000dc6000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff317224ULL, 0x002fe200078e0011ULL, 0x00008b9000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x0000dc0000007944ULL, 0x00cfea0003c00000ULL, 0x0000b8000d0d7811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000000b20783bULL, 0x000fe20000004200ULL,
0x0000b80007077811ULL, 0x000fe400078e20ffULL, 0x0000991010107816ULL, 0x000fe200000000ffULL,
0x000000000d18783bULL, 0x000f260000000200ULL, 0x000000ff1000720cULL, 0x000fe20003f05270ULL,
0x000000000a24783bULL, 0x000fe80000004200ULL, 0x000000000928783bULL, 0x002fe80000004200ULL,
0x00000000082c783bULL, 0x004fe80000004200ULL, 0x000000000730783bULL, 0x000e680000000200ULL,
0x000000000634783bULL, 0x000ea80000004200ULL, 0x000000000554783bULL, 0x000f680000004200ULL,
0x000000000358783bULL, 0x000ee80000004200ULL, 0x00000000025c783bULL, 0x0008a40000004200ULL,
0x0000001518188232ULL, 0x090fe20000000000ULL, 0x0000030061027a10ULL, 0x000fe20007ffe0ffULL,
0x000000151a1a8232ULL, 0x000fc40000000000ULL, 0x0000000e19198232ULL, 0x088fe20000000000ULL,
0x0000000102037810ULL, 0x040fe20007ffe0ffULL, 0x0000000e1b1b8232ULL, 0x000fe20000000000ULL,
0x0000000802067819ULL, 0x000fe400000006ffULL, 0x000000000300720cULL, 0x000fc60003f26070ULL,
0x0000620063107a24ULL, 0x000fe200078e0206ULL, 0x00000020183c723cULL, 0x000fe2000000183cULL,
0x0000001530308232ULL, 0x082fe40000000000ULL, 0x0000001532328232ULL, 0x000fe40000000000ULL,
0x0000000e31318232ULL, 0x000fc60000000000ULL, 0x000000241844723cULL, 0x000fe20000001844ULL,
0x0000000e33338232ULL, 0x000fce0000000000ULL, 0x000000281850723cULL, 0x040ff00000001850ULL,
0x000000221820723cULL, 0x040ff00000001840ULL, 0x000000261824723cULL, 0x040ff00000001848ULL,
0x0000002a1828723cULL, 0x040ff0000000184cULL, 0x0000002c1838723cULL, 0x040ff00000001838ULL,
0x0000002e1818723cULL, 0x000ff0000000181cULL, 0x00000034303c723cULL, 0x044ff0000000183cULL,
0x000000363020723cULL, 0x040ff00000001820ULL, 0x000000543044723cULL, 0x060ff00000001844ULL,
0x000000563024723cULL, 0x040ff00000001824ULL, 0x000000583050723cULL, 0x040ff00000001850ULL,
0x0000005a3028723cULL, 0x040ff00000001828ULL, 0x0000005c3038723cULL, 0x040ff00000001838ULL,
0x0000005e3018723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000058000009947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x100fe20000011604ULL,
0x00000001640d7824ULL, 0x000fe200078e020fULL, 0x0000000617027217ULL, 0x000fe20007800000ULL,
0x00000200ff117424ULL, 0x000fe200078e00ffULL, 0x0000000409157810ULL, 0x040fe40007ffe0ffULL,
0x0000000709077812ULL, 0x000fe200078e4804ULL, 0x0000000102027824ULL, 0x000fe200078e0a06ULL,
0x0000000415037212ULL, 0x040fe200078e3cffULL, 0x0000000815087824ULL, 0x000fe200078e00ffULL,
0x0ffffff8070b7812ULL, 0x000fe200078ef804ULL, 0x0000000115067824ULL, 0x000fe200078e0210ULL,
0x0000002002057817ULL, 0x000fc40003800000ULL, 0xfffffff8080f7812ULL, 0x000fe200078ee203ULL,
0x00005e0006067625ULL, 0x000fe200078e0011ULL, 0x0000001009037210ULL, 0x040fe40007ffe0ffULL,
0x000000050900720cULL, 0x080fe20003f26070ULL, 0x000000100b0b7824ULL, 0x000fe200078e020cULL,
0x000000051500720cULL, 0x000fe20003f46070ULL, 0x00005e0003027625ULL, 0x000fe200078e0011ULL,
0x00000008091d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c091f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x00000010092f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c0f0f7211ULL, 0x000fe200078e20ffULL, 0x000000100d027825ULL, 0x000fe200078e0002ULL,
0x0000001409317810ULL, 0x040fe40007ffe0ffULL, 0x0000001809337810ULL, 0x000fe20007ffe0ffULL,
0x000000081d157824ULL, 0x040fe200078e00ffULL, 0x000000041d087212ULL, 0x080fe200078e3cffULL,
0x000000081f2d7824ULL, 0x040fe200078e00ffULL, 0x000000041f0a7212ULL, 0x080fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000c901c46ULL,
0x0000001c09357810ULL, 0x000fe20007ffe0ffULL, 0x000000082f127824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee208ULL, 0x00000000060f7faeULL, 0x0005e2000d101c46ULL,
0x00000008311c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x00000008331e7824ULL, 0x040fe200078e00ffULL, 0x0000000433097212ULL, 0x080fe200078e3cffULL,
0x000000012f087824ULL, 0x100fe200078e0210ULL, 0x000000051d00720cULL, 0x080fe20003f26070ULL,
0x00000001330e7824ULL, 0x100fe200078e0210ULL, 0x000000042f037212ULL, 0x082fe200078e3cffULL,
0x000000011d027824ULL, 0x000fe200078e0210ULL, 0x000000051f00720cULL, 0x080fe20003f46070ULL,
0x0000001015157824ULL, 0x000fe200078e020cULL, 0x0000000431077212ULL, 0x004fe200078e3cffULL,
0x000000011f067824ULL, 0x000fe200078e0210ULL, 0x000000052f00720cULL, 0x000fe20003f66070ULL,
0x00005e000e0e7625ULL, 0x000fe200078e0011ULL, 0x000000053100720cULL, 0x000fc40003f86070ULL,
0x000000053300720cULL, 0x080fe20003fa6070ULL, 0x000000102d2d7824ULL, 0x000fe200078e020cULL,
0x000000053500720cULL, 0x000fe20003fc6070ULL, 0x000000100d0e7825ULL, 0x000fe200078e000eULL,
0x00000010310a7210ULL, 0x000fe40007ffe0ffULL, 0x00000004350b7212ULL, 0x040fe200078e3cffULL,
0x0000000135107824ULL, 0x040fe200078e0210ULL, 0x00000003352c7819ULL, 0x000fe400000006ffULL,
0xfffffff812057812ULL, 0x000fe200078ee203ULL, 0x00005e0002027625ULL, 0x000fe200078e0011ULL,
0xfffffff81c1d7812ULL, 0x000fc400078ee207ULL, 0xfffffff81e1f7812ULL, 0x000fe200078ee209ULL,
0x00005e0006067625ULL, 0x080fe200078e0011ULL, 0xfffffff82c2f7812ULL, 0x000fe400078ee20bULL,
0x0000000c1f1f7211ULL, 0x000fe200078e20ffULL, 0x00005e0008087625ULL, 0x000fc800078e0011ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0011ULL, 0x00005e0010107625ULL, 0x000fc800078e0011ULL,
0x000000100d027825ULL, 0x000fc800078e0002ULL, 0x000000100d067825ULL, 0x040fe200078e0006ULL,
0x0000000002157faeULL, 0x0003e6000c901c46ULL, 0x000000100d087825ULL, 0x000fe200078e0008ULL,
0x00000000062d7faeULL, 0x0003e6000d101c46ULL, 0x0000001005057824ULL, 0x000fe400078e020cULL,
0x000000100d0a7825ULL, 0x000fc600078e000aULL, 0x0000000008057faeULL, 0x0003e2000d901c46ULL,
0x000000101d1d7824ULL, 0x000fe400078e020cULL, 0x000000100d107825ULL, 0x000fc600078e0010ULL,
0x000000000a1d7faeULL, 0x0003e2000e101c46ULL, 0x000000102f2f7824ULL, 0x000fc600078e020cULL,
0x000000000e1f7faeULL, 0x0003e8000e901c46ULL, 0x00000000102f7faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011604ULL,
0x00000200ff1f7424ULL, 0x000fc600078e00ffULL, 0x00000008030b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000403097810ULL, 0x040fe40007ffe0ffULL, 0x0000000c030d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b087824ULL, 0x040fe200078e00ffULL, 0x000000040b057212ULL, 0x080fe200078e3cffULL,
0x0000000809157824ULL, 0x040fe200078e00ffULL, 0x0000000409027212ULL, 0x000fe200078e3cffULL,
0x000000080d2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8082d7812ULL, 0x000fe200078ee205ULL,
0x000000010b087824ULL, 0x000fe200078e0210ULL, 0x0000000f64057210ULL, 0x000fc40007ffe0ffULL,
0x000000040d067212ULL, 0x080fe200078e3cffULL, 0x000000102d2d7824ULL, 0x000fe200078e020cULL,
0x0000000703077812ULL, 0x040fe400078e4804ULL, 0x00000010030f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001403117810ULL, 0x040fe40007ffe0ffULL, 0x00000018031d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080f2c7824ULL, 0x000fe200078e00ffULL, 0x0000001c03317810ULL, 0x000fe20007ffe0ffULL,
0x00000008112e7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee202ULL,
0x0000000103027824ULL, 0x000fe200078e0210ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee206ULL,
0x0000000109067824ULL, 0x000fe200078e0210ULL, 0x0ffffff807077812ULL, 0x000fe200078ef804ULL,
0x000000010f0e7824ULL, 0x140fe200078e0210ULL, 0x000000040f097212ULL, 0x000fe200078e3cffULL,
0x000000081d307824ULL, 0x000fe200078e00ffULL, 0x000000100d0a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000111127824ULL, 0x140fe200078e0210ULL, 0x00000004110b7212ULL, 0x000fe200078e3cffULL,
0x00000001311e7824ULL, 0x000fe200078e0210ULL, 0x000000101d1c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000831377824ULL, 0x000fe200078e00ffULL, 0x000000041d0f7212ULL, 0x080fe200078e3cffULL,
0x00005e0002027625ULL, 0x000fe200078e001fULL, 0x0000000431107212ULL, 0x000fc400078e3cffULL,
0xfffffff82c317812ULL, 0x000fe200078ee209ULL, 0x00000010070d7824ULL, 0x000fe200078e020cULL,
0xfffffff82e337812ULL, 0x000fe200078ee20bULL, 0x00005e0006067625ULL, 0x080fe200078e001fULL,
0xfffffff830357812ULL, 0x000fe400078ee20fULL, 0xfffffff837377812ULL, 0x000fe200078ee210ULL,
0x00005e0008087625ULL, 0x080fe200078e001fULL, 0x0000000c15157211ULL, 0x080fe400078e20ffULL,
0x0000000c35357211ULL, 0x000fe200078e20ffULL, 0x00005e000a0a7625ULL, 0x000fc800078e001fULL,
0x00005e000e0e7625ULL, 0x000fc800078e001fULL, 0x00005e0012107625ULL, 0x000fc800078e001fULL,
0x0000001005027825ULL, 0x000fc800078e0002ULL, 0x00005e001c1c7625ULL, 0x080fe200078e001fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e6000b901c46ULL,
0x00005e001e1e7625ULL, 0x000fc800078e001fULL, 0x0000001005067825ULL, 0x000fc800078e0006ULL,
0x0000001005087825ULL, 0x040fe200078e0008ULL, 0x0000000006157faeULL, 0x0003e6000b901c46ULL,
0x00000010050a7825ULL, 0x000fe200078e000aULL, 0x00000000082d7faeULL, 0x0003e6000b901c46ULL,
0x000000102f2f7824ULL, 0x000fe400078e020cULL, 0x00000010050e7825ULL, 0x000fc600078e000eULL,
0x000000000a2f7faeULL, 0x0003e2000b901c46ULL, 0x0000001031317824ULL, 0x000fe400078e020cULL,
0x0000001005107825ULL, 0x000fc600078e0010ULL, 0x000000000e317faeULL, 0x0003e2000b901c46ULL,
0x0000001033337824ULL, 0x000fe400078e020cULL, 0x00000010051c7825ULL, 0x000fc600078e001cULL,
0x0000000010337faeULL, 0x0003e2000b901c46ULL, 0x00000010051e7825ULL, 0x000fc600078e001eULL,
0x000000001c357faeULL, 0x0003e2000b901c46ULL, 0x0000001037377824ULL, 0x000fca00078e020cULL,
0x000000001e377faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000b8006e087811ULL, 0x002fe400078e20ffULL, 0x00000014ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe40000011604ULL, 0x0000541002067816ULL, 0x000fe40000000002ULL,
0x0000b800691c7811ULL, 0x000fc600078e20ffULL, 0x00001f0306037589ULL, 0x000fe800000e0000ULL,
0x00001f1306027589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000e680000000200ULL, 0x000000006c2c783bULL, 0x000ea80000004200ULL,
0x000000006b30783bULL, 0x000fe80000004200ULL, 0x000000006d0c783bULL, 0x000fe80000004200ULL,
0x000000006a40783bULL, 0x000fe80000004200ULL, 0x000000001c1c783bULL, 0x000ee80000000200ULL,
0x000000006748783bULL, 0x000f280000004200ULL, 0x00000000664c783bULL, 0x000f680000004200ULL,
0x000000006854783bULL, 0x000f280000004200ULL, 0x000000006534783bULL, 0x000f220000004200ULL,
0x0000000308088232ULL, 0x002fc40000000000ULL, 0x000000030a0a8232ULL, 0x000fe40000000000ULL,
0x0000000209098232ULL, 0x080fe40000000000ULL, 0x000000020b0b8232ULL, 0x000fce0000000000ULL,
0x0000002c0844723cULL, 0x004fe20000001844ULL, 0x000000031c1c8232ULL, 0x008fce0000000000ULL,
0x000000300850723cULL, 0x000fe20000001850ULL, 0x000000031e1e8232ULL, 0x000fe40000000000ULL,
0x000000021d1d8232ULL, 0x080fe40000000000ULL, 0x000000021f1f8232ULL, 0x000fc60000000000ULL,
0x0000000c083c723cULL, 0x040ff0000000183cULL, 0x0000000e0820723cULL, 0x040ff00000001820ULL,
0x0000002e0824723cULL, 0x040ff00000001824ULL, 0x000000320828723cULL, 0x040ff00000001828ULL,
0x000000400838723cULL, 0x040ff00000001838ULL, 0x000000420818723cULL, 0x000ff00000001818ULL,
0x000000481c44723cULL, 0x050ff00000001844ULL, 0x0000004c1c50723cULL, 0x060ff00000001850ULL,
0x000000541c3c723cULL, 0x040ff0000000183cULL, 0x000000561c40723cULL, 0x040ff00000001820ULL,
0x0000004a1c48723cULL, 0x040ff00000001824ULL, 0x0000004e1c4c723cULL, 0x040ff00000001828ULL,
0x000000341c38723cULL, 0x040ff00000001838ULL, 0x000000361c1c723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0146a000ffff7f8cULL, 0x000fe4000c80043fULL, 0x0000030061617a10ULL, 0x000fc80007ffe0ffULL,
0x000000006100720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff765000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000e640000002500ULL,
0x000000000500720cULL, 0x002fda0003f06070ULL, 0x0000035000000947ULL, 0x000fea0003800000ULL,
0x0180000016007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e0016ULL,
0x00009cc000287802ULL, 0x000fe40000000f00ULL, 0x0000c92000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001600037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000016ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fe40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000027919ULL, 0x000ee20000000000ULL, 0x0000000803037811ULL, 0x004fe400078ff0ffULL,
0x00000002ff077819ULL, 0x008fc80000011602ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0700027589ULL, 0x000ee200000e0000ULL, 0x0000003e033e7220ULL, 0x044fe20000410000ULL,
0x0000003f033f7220ULL, 0x040fe20000410000ULL, 0x0000004203427220ULL, 0x040fe20000410000ULL,
0x0000004303437220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x048fe20000410000ULL,
0x0000003d023d7220ULL, 0x040fe20000410000ULL, 0x0000004002407220ULL, 0x040fe20000410000ULL,
0x0000004102417220ULL, 0x040fe20000410000ULL, 0x0000004402447220ULL, 0x040fe20000410000ULL,
0x0000004502457220ULL, 0x040fe20000410000ULL, 0x0000004802487220ULL, 0x040fe20000410000ULL,
0x0000004902497220ULL, 0x040fe20000410000ULL, 0x0000005002507220ULL, 0x040fe20000410000ULL,
0x0000005102517220ULL, 0x040fe20000410000ULL, 0x0000004c024c7220ULL, 0x040fe20000410000ULL,
0x0000004d024d7220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000001c021c7220ULL, 0x040fe20000410000ULL,
0x0000001d021d7220ULL, 0x000fe20000410000ULL, 0x0000004603467220ULL, 0x040fe20000410000ULL,
0x0000004703477220ULL, 0x040fe20000410000ULL, 0x0000004a034a7220ULL, 0x040fe20000410000ULL,
0x0000004b034b7220ULL, 0x040fe20000410000ULL, 0x0000005203527220ULL, 0x040fe20000410000ULL,
0x0000005303537220ULL, 0x040fe20000410000ULL, 0x0000004e034e7220ULL, 0x040fe20000410000ULL,
0x0000004f034f7220ULL, 0x040fe20000410000ULL, 0x0000003a033a7220ULL, 0x040fe20000410000ULL,
0x0000003b033b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x000fc40000410000ULL, 0x0000000000207919ULL, 0x000ea20000000000ULL,
0x0000001c1d0b723eULL, 0x000fc400000000ffULL, 0x0000001e1f13723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000003c3d03723eULL, 0x000fe400000000ffULL,
0x000000404104723eULL, 0x000fe400000000ffULL, 0x000000444506723eULL, 0x000fe400000000ffULL,
0x000000484907723eULL, 0x000fe400000000ffULL, 0x000000505108723eULL, 0x000fc400000000ffULL,
0x0000004c4d09723eULL, 0x000fe400000000ffULL, 0x00000038390a723eULL, 0x000fe400000000ffULL,
0x0000003e3f0c723eULL, 0x000fe400000000ffULL, 0x00000042430d723eULL, 0x000fe400000000ffULL,
0x00000046470e723eULL, 0x000fe400000000ffULL, 0x00000002ff217819ULL, 0x004fc40000011620ULL,
0x00000008202f7811ULL, 0x000fe400078ff0ffULL, 0x00000021ff237212ULL, 0x000fe200078e33ffULL,
0x0000000821147824ULL, 0x040fe200078e00ffULL, 0x0000002fff317212ULL, 0x000fe200078e33ffULL,
0x0000000821027824ULL, 0x000fe200078e00ffULL, 0x000000032f187819ULL, 0x000fe400000006ffULL,
0x0000000721007812ULL, 0x000fe400078ec0ffULL, 0xfffffff814237812ULL, 0x000fc400078ee223ULL,
0xfffffff818317812ULL, 0x000fe400078ee231ULL, 0xfffffff802157812ULL, 0x000fe400078ee221ULL,
0x0000000100027812ULL, 0x040fe400078e3cffULL, 0x0000000200147812ULL, 0x040fe400078e3cffULL,
0x0000000300187812ULL, 0x040fe200078e3cffULL, 0x0000000821177824ULL, 0x040fe200078e0202ULL,
0x00000004001a7812ULL, 0x040fe200078e3cffULL, 0x0000000821197824ULL, 0x040fe200078e0214ULL,
0x00000005001c7812ULL, 0x040fe200078e3cffULL, 0x00000008211b7824ULL, 0x040fe200078e0218ULL,
0x0000000600007812ULL, 0x000fe200078e3cffULL, 0x0000000420147824ULL, 0x000fe200078e00ffULL,
0x0000001a211d7211ULL, 0x040fe200078e18ffULL, 0x00000008211f7824ULL, 0x000fe200078e021cULL,
0x000000032f1a7819ULL, 0x000fe200000006ffULL, 0x0000000821217824ULL, 0x000fe200078e0200ULL,
0x000000072f187812ULL, 0x000fe200078ec0ffULL, 0x0000080060007824ULL, 0x000fe200078e00ffULL,
0x0000000c14147812ULL, 0x000fc400078ec0ffULL, 0xfffffff81a257812ULL, 0x000fe400078ee22fULL,
0x0000a00000027810ULL, 0x000fe40007ffe0ffULL, 0x00000001181a7812ULL, 0x040fe400078e3cffULL,
0x00000002181c7812ULL, 0x040fe200078e3cffULL, 0x0000001015157824ULL, 0x100fe200078e0202ULL,
0x00000003181e7812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000000418207812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0202ULL,
0x0000000518227812ULL, 0x040fe200078e3cffULL, 0x000000082f277824ULL, 0x002fe200078e021aULL,
0x0000000618247812ULL, 0x000fe200078e3cffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000001415187210ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x000000021d1d7211ULL, 0x080fe200078e20ffULL, 0x0000000114177824ULL, 0x040fe200078e0217ULL,
0x0000000225257211ULL, 0x080fe200078e20ffULL, 0x000000082f297824ULL, 0x040fe200078e021cULL,
0x0000000318007388ULL, 0x0003e20000000800ULL, 0x000000082f2b7824ULL, 0x000fe200078e021eULL,
0x0000000227277211ULL, 0x000fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x0000001d141d7210ULL, 0x040fe20007ffe0ffULL, 0x0000000114197824ULL, 0x040fe200078e0219ULL,
0x0000000417007388ULL, 0x0005e20000000800ULL, 0x000000082f157824ULL, 0x000fe200078e0220ULL,
0x0000004a4b0f723eULL, 0x000fe200000000ffULL, 0x000000082f2d7824ULL, 0x000fe200078e0222ULL,
0x0000000619007388ULL, 0x0005e20000000800ULL, 0x0000001023237824ULL, 0x000fe200078e0202ULL,
0x000000525310723eULL, 0x000fe200000000ffULL, 0x0000000114187824ULL, 0x042fe200078e021bULL,
0x0000004e4f11723eULL, 0x000fe200000000ffULL, 0x000000082f2f7824ULL, 0x000fe200078e0224ULL,
0x0000003a3b12723eULL, 0x000fe200000000ffULL, 0x00000001ff037424ULL, 0x000fe200078e00ffULL,
0x0000000718007388ULL, 0x0005e20000000800ULL, 0x00000001141a7824ULL, 0x040fe200078e021fULL,
0x000000022f2f7211ULL, 0x000fe200078e20ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000081d007388ULL, 0x0005e20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0202ULL,
0x0000030003007a0cULL, 0x000fe20003f05270ULL, 0x0000000114217824ULL, 0x040fe200078e0221ULL,
0x000000091a007388ULL, 0x0005e20000000800ULL, 0x00000001141c7824ULL, 0x040fe200078e0223ULL,
0x0000002b14207210ULL, 0x040fe20007ffe0ffULL, 0x0000000114257824ULL, 0x000fe200078e0225ULL,
0x0000000a21007388ULL, 0x0005e20000000800ULL, 0x0000001015157824ULL, 0x000fc400078e0202ULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0x0000000b1c007388ULL, 0x0005e20000000800ULL,
0x00000001141e7824ULL, 0x040fe400078e0227ULL, 0x0000000114297824ULL, 0x040fe200078e0229ULL,
0x0000000c25007388ULL, 0x0005e20000000800ULL, 0x0000001031317824ULL, 0x000fe400078e0202ULL,
0x0000000114157824ULL, 0x040fe200078e0215ULL, 0x0000000d1e007388ULL, 0x0005e20000000800ULL,
0x0000000114227824ULL, 0x000fc400078e022dULL, 0x00000001142f7824ULL, 0x040fe200078e022fULL,
0x0000000e29007388ULL, 0x0005e20000000800ULL, 0x0000000114247824ULL, 0x000fc600078e0231ULL,
0x0000000f20007388ULL, 0x0005e80000000800ULL, 0x0000001015007388ULL, 0x0005e80000000800ULL,
0x0000001122007388ULL, 0x0005e80000000800ULL, 0x000000122f007388ULL, 0x0005e80000000800ULL,
0x0000001324007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00002bb000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00005800ff067624ULL, 0x004fe200078e00ffULL, 0x000000ff6000720cULL, 0x000fe40003f25270ULL,
0x0000000000107919ULL, 0x000ea20000002700ULL, 0x0000030006067a24ULL, 0x000fc600078e02ffULL,
0x0000000000077919ULL, 0x000ea20000002600ULL, 0x0000640006087a24ULL, 0x000fe200078e02ffULL,
0x0000000003097211ULL, 0x042fe400078e20ffULL, 0x00000020030f7810ULL, 0x040fe40007ffe0ffULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x00a0000009187984ULL, 0x0002e20000000c00ULL,
0x0000580010107a24ULL, 0x004fc600078e0207ULL, 0x00a20000091c7984ULL, 0x0002a20000000c00ULL,
0x00001000ff077424ULL, 0x000fe200078e00ffULL, 0x000000ff6000720cULL, 0x000fe20000705670ULL,
0x0000030010047a24ULL, 0x000fc800078e02ffULL, 0x00000001040a7824ULL, 0x000fe200078e0205ULL,
0x00000fff08057811ULL, 0x000fc800078e40ffULL, 0x0000000a05067211ULL, 0x000fca00078fa0ffULL,
0x00006a0006067625ULL, 0x000fcc00078e0007ULL, 0x0000040060067825ULL, 0x000fcc00078e0006ULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x00000010030c7825ULL, 0x000fe200078e0006ULL,
0x01ffffff08077812ULL, 0x000fe200078ec0ffULL, 0x000000f000001947ULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x002e620000000000ULL, 0x00000080ff067424ULL, 0x000fe200078e00ffULL,
0x000000070a0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000001008117824ULL, 0x002fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011608ULL, 0x00006a000a087625ULL, 0x000fc600078e0006ULL,
0x0000007011117812ULL, 0x000fe200078ec0ffULL, 0x00006a000b0a7625ULL, 0x000fe200078e0006ULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000812087210ULL, 0x140fe40007b5e011ULL,
0x0000000a120a7210ULL, 0x000fe40007d9e011ULL, 0x00000009ff097210ULL, 0x000fe400017e64ffULL,
0x0000000bff0b7210ULL, 0x000fc600027ea4ffULL, 0x0000006208007986ULL, 0x0003e8000c101906ULL,
0x000000160a007986ULL, 0x0003e4000c101906ULL, 0x000000180c007986ULL, 0x00a3e2000c101d06ULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x0000001c0e007986ULL, 0x0043e8000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x000000f000000947ULL, 0x000fea0003800000ULL,
0x00000001ff0b7424ULL, 0x000fe400078e00ffULL, 0x00000004ff097424ULL, 0x000fc600078e00ffULL,
0x000003000b0b7a10ULL, 0x000fe20007ffe1ffULL, 0x0000680010087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x0000000b080879a8ULL, 0x000ea400099ee1c6ULL, 0x0000000b0800720cULL, 0x004fe20003f05270ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000001ff067807ULL, 0x000fca0000000000ULL,
0x00000006ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000010000ULL, 0x00000000ff067984ULL, 0x004ea40000000000ULL,
0x000000ff0600720cULL, 0x004fda0003f05270ULL, 0x000027a000008947ULL, 0x000fea0003800000ULL,
0x00000d6000001947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x0000038000008947ULL, 0x000fea0003800000ULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x0000008000177802ULL, 0x000fe40000000f00ULL,
0x00000001040a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c080e7812ULL, 0x002fe200078ec0ffULL,
0x00006a0004087625ULL, 0x000fe200078e0017ULL, 0x0000007006197812ULL, 0x000fc600078ec0ffULL,
0x00006a000a0a7625ULL, 0x000fe200078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x0000000a0e0a7210ULL, 0x000fe40007b5e019ULL, 0x00000009ff097210ULL, 0x000fe400007e24ffULL,
0x0000000bff0b7210ULL, 0x000fc600017e64ffULL, 0x0000000608067981ULL, 0x000368000c1e1900ULL,
0x000000060a0d7981ULL, 0x000362000c1e1900ULL, 0x00000300ff0c7624ULL, 0x000fca00078e00ffULL,
0x000000020c00780cULL, 0x000fda0003f05270ULL, 0x0000027000008947ULL, 0x000fea0003800000ULL,
0x0000000204087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x00000006080f7981ULL, 0x000362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f06070ULL,
0x0000020000008947ULL, 0x000fea0003800000ULL, 0x0000000304087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608117981ULL, 0x000362000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f05270ULL, 0x0000019000008947ULL, 0x000fea0003800000ULL,
0x0000000404087810ULL, 0x002fca0007ffe0ffULL, 0x00006a0008087625ULL, 0x000fca00078e0017ULL,
0x000000080e087210ULL, 0x000fc8000791e019ULL, 0x00000009ff097210ULL, 0x000fca00007e24ffULL,
0x0000000608137981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f06070ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x0000000504087810ULL, 0x002fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fc8000791e019ULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608157981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f05270ULL, 0x000000b000008947ULL, 0x000fea0003800000ULL,
0x000000080c00780cULL, 0x002fe40003f06070ULL, 0x0000000604087810ULL, 0x000fca0007ffe0ffULL,
0x00006a0008087625ULL, 0x000fca00078e0017ULL, 0x000000080e087210ULL, 0x000fe40007a3e019ULL,
0x00000007040a0810ULL, 0x000fe40007ffe0ffULL, 0x00000009ff097210ULL, 0x000fc60000fe44ffULL,
0x00006a000a0a0625ULL, 0x000fe400078e0017ULL, 0x0000000608177981ULL, 0x000366000c1e1900ULL,
0x0000000a0e0a0210ULL, 0x000fc80007c7e019ULL, 0x0000000bff0b0210ULL, 0x000fcc0001fe84ffULL,
0x000000060a0b0981ULL, 0x000366000c1e1900ULL, 0x0000030000047ab9ULL, 0x002fe40000000800ULL,
0x0000000704047890ULL, 0x000fc8000fffe03fULL, 0x000000033f047899ULL, 0x000fcc0008011604ULL,
0x00000004ff007c0cULL, 0x000fda000bf05270ULL, 0x0000090000008947ULL, 0x000fea0003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000000ff00127202ULL, 0x000fe20000000f00ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0004ULL, 0x000000ffff197224ULL, 0x020fe400078e0006ULL,
0x0000030010007a0cULL, 0x000fe40003f26070ULL, 0x0000000112127810ULL, 0x000fc80007ffe0ffULL,
0x0000000412007c0cULL, 0x000fce000bf06070ULL, 0x0000085000001947ULL, 0x022fea0003800000ULL,
0x0000000810087810ULL, 0x040fe40007ffe0ffULL, 0x0000000110097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001906067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x000000080a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c197812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e019ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608197981ULL, 0x000368000c1e1900ULL,
0x0000074000002947ULL, 0x000fea0003800000ULL, 0x0000000910087810ULL, 0x042fe40007ffe0ffULL,
0x0000000210097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000000d06067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x000000090a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e00dULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x00000006080d7981ULL, 0x000368000c1e1900ULL, 0x0000063000002947ULL, 0x000fea0003800000ULL,
0x0000000a10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000310097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f06067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000a0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000008000097802ULL, 0x000fe40000000f00ULL, 0x00000001ff0e7819ULL, 0x000fe40000011603ULL,
0x000000700c0f7812ULL, 0x000fe200078ec0ffULL, 0x00006a0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e00fULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x00000006080f7981ULL, 0x000368000c1e1900ULL,
0x0000052000002947ULL, 0x000fea0003800000ULL, 0x0000000b10087810ULL, 0x042fe40007ffe0ffULL,
0x0000000410097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001106067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000b0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c117812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e011ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608117981ULL, 0x000368000c1e1900ULL, 0x0000041000002947ULL, 0x000fea0003800000ULL,
0x0000000c10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000510097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001306067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000c0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000004030c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x000000700c137812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e013ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608137981ULL, 0x000368000c1e1900ULL,
0x0000030000002947ULL, 0x000fea0003800000ULL, 0x0000000d10087810ULL, 0x042fe40007ffe0ffULL,
0x0000000610097810ULL, 0x000fe40007ffe0ffULL, 0x0000030008007a0cULL, 0x000fe40003f26070ULL,
0x0000030009007a0cULL, 0x000fe40003f46070ULL, 0x0000001506067209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000d0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff097424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0008087625ULL, 0x000fe200078e0009ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c157812ULL, 0x000fc800078ec0ffULL,
0x000000080e087210ULL, 0x000fc80007b3e015ULL, 0x00000009ff097210ULL, 0x000fca0000fe64ffULL,
0x0000000608157981ULL, 0x000368000c1e1900ULL, 0x000001f000002947ULL, 0x000fea0003800000ULL,
0x0000000e10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000710097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001706067209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000e0a087810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff097424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c177812ULL, 0x000fc800078ec0ffULL, 0x000000080e087210ULL, 0x000fc80007b3e017ULL,
0x00000009ff097210ULL, 0x000fca0000fe64ffULL, 0x0000000608177981ULL, 0x000368000c1e1900ULL,
0x000000e000002947ULL, 0x000fea0003800000ULL, 0x0000000f10087810ULL, 0x002fe40007ffe0ffULL,
0x0000000b06067209ULL, 0x000fe40007810000ULL, 0x0000030008007a0cULL, 0x000fda0003f26070ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000f0a087810ULL, 0x000fe20007ffe0ffULL,
0x00000010030b7824ULL, 0x000fe200078e00ffULL, 0x0000008000097802ULL, 0x000fe40000000f00ULL,
0x00000001ff0c7819ULL, 0x000fe40000011603ULL, 0x000000700b0b7812ULL, 0x000fe200078ec0ffULL,
0x00006a0008087625ULL, 0x000fe200078e0009ULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000080c087210ULL, 0x000fc80007a3e00bULL, 0x00000009ff097210ULL, 0x000fca0000fe44ffULL,
0x00000006080b7981ULL, 0x000368000c1e1900ULL, 0x0000000810107810ULL, 0x000fe40007ffe0ffULL,
0x000000080a0a7810ULL, 0x000fe20007ffe0ffULL, 0xfffff74000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003087824ULL, 0x006fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fca00078ec0ffULL, 0x0000000108097824ULL, 0x000fca00078e0209ULL,
0x0000000609007388ULL, 0x0203e40000000800ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000001ff087819ULL, 0x000fe20000011603ULL,
0x0000001003067824ULL, 0x002fe200078e00ffULL, 0x0000000405297211ULL, 0x000fe200078fa0ffULL,
0x0000000104287824ULL, 0x000fe200078e0207ULL, 0x00001000000a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000c08057812ULL, 0x000fe200078ec0ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000007006067812ULL, 0x000fe200078ec0ffULL,
0x00006a0029087625ULL, 0x000fe200078e000aULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x00000080ff0b8424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000040060087825ULL, 0x000fe200078e0008ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000080ff158424ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000106057824ULL, 0x000fe200078e0205ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000100060067824ULL, 0x000fc400078e00ffULL, 0x00006a00280a8625ULL, 0x000fe400078e000bULL,
0x0000000005057984ULL, 0x000e620000000800ULL, 0x00000006030f7211ULL, 0x000fe200078e20ffULL,
0x0000001060178824ULL, 0x000fe400078e0203ULL, 0x00006a0004148625ULL, 0x000fc600078e0015ULL,
0x0000458017178811ULL, 0x000fe200078e20ffULL, 0x0000001060198824ULL, 0x000fe400078e0203ULL,
0x0000001011107825ULL, 0x000fc600078e0008ULL, 0x0000418019198811ULL, 0x000fe200078e20ffULL,
0x0000001003087825ULL, 0x000fc800078e0008ULL, 0x0000001003128825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000080f7faeULL, 0x0005e2000b901c46ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x0000001003148825ULL, 0x000fe200078e0014ULL,
0x00380000100f7faeULL, 0x0007e8000b901c46ULL, 0x0000000012178faeULL, 0x0009e8000b901c46ULL,
0x0000000014198faeULL, 0x000be2000b901c46ULL, 0x0000000000087805ULL, 0x004fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000000e7805ULL, 0x008fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x020fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000d1000009947ULL, 0x000fea0003800000ULL,
0x00000001042a7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x0000000128287810ULL, 0x000fe40007ffe0ffULL, 0x0000000129297810ULL, 0x000fc40007ffe0ffULL,
0x0000000100047802ULL, 0x000fc80000000f00ULL, 0x0000030004007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00001000ff2c7424ULL, 0x000fe200078e00ffULL, 0x00000001042f7812ULL, 0x040fe200078ec0ffULL,
0x00000800042b7824ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x000fe20007ffe0ffULL,
0x00006a00292c7625ULL, 0x000fc600078e002cULL, 0x000008002b2b7812ULL, 0x000fc600078ec0ffULL,
0x00000400602c7825ULL, 0x040fe400078e002cULL, 0x0000002f60328211ULL, 0x040fe400078e08ffULL,
0x0000000260308824ULL, 0x000fe400078e022fULL, 0x00000080ff318424ULL, 0x000fe200078e00ffULL,
0x0000000332348211ULL, 0x000fe200078e18ffULL, 0x00000080ff338424ULL, 0x000fe400078e00ffULL,
0x00000001062e7824ULL, 0x000fc400078e022bULL, 0x0000000830358824ULL, 0x000fe400078e0203ULL,
0x00006a0028308625ULL, 0x000fc600078e0031ULL, 0x0000458035358811ULL, 0x000fe200078e20ffULL,
0x00006a002a328625ULL, 0x000fc800078e0033ULL, 0x00000010032b7824ULL, 0x000fe400078e022eULL,
0x00000010372e7825ULL, 0x000fe200078e002cULL, 0x0000418034378811ULL, 0x000fc600078e20ffULL,
0x00000010032c7825ULL, 0x000fc800078e002cULL, 0x0000001003308825ULL, 0x040fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800002c2b7faeULL, 0x0003e6000b901c46ULL,
0x0000001003328825ULL, 0x000fe200078e0032ULL, 0x003800002e2b7faeULL, 0x0003e8000b901c46ULL,
0x0000000030358faeULL, 0x0003e8000b901c46ULL, 0x0000000032378faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff042b7810ULL, 0x002fe20007ffe0ffULL,
0x00000010032e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff2f7819ULL, 0x000fc40000011603ULL,
0x00000002ff337819ULL, 0x000fe20000011603ULL, 0x000000802b2c7824ULL, 0x040fe200078e00ffULL,
0x000000702e2e7812ULL, 0x000fe200078ec0ffULL, 0x000008002b2b7824ULL, 0x000fe200078e00ffULL,
0x0000000c2f2f7812ULL, 0x000fe200078ec0ffULL, 0x0000000833317824ULL, 0x040fe200078e00ffULL,
0x000000802c2d7812ULL, 0x000fe400078ec0ffULL, 0x00000033ff2c7212ULL, 0x000fe400078e33ffULL,
0x0000000333357819ULL, 0x040fe200000006ffULL, 0x00000100602d7824ULL, 0x000fe200078e022dULL,
0x0000000733387812ULL, 0x000fc400078ec0ffULL, 0x000008002b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000002d2f2f7210ULL, 0x000fe20007ffe02eULL, 0x00000008332d7824ULL, 0x000fe200078e00ffULL,
0xfffffff835427812ULL, 0x000fe200078ee22cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180002f3a7984ULL, 0x000e620000000800ULL, 0xfffffff8312c7812ULL, 0x100fe400078ee238ULL,
0x000000012d2e7812ULL, 0x140fe200078ef638ULL, 0x004580002f4a7984ULL, 0x0004e20000000800ULL,
0x000000022d307812ULL, 0x140fe400078ef638ULL, 0x000000032d327812ULL, 0x140fe400078ef638ULL,
0x000000042d347812ULL, 0x140fe400078ef638ULL, 0x000000052d367812ULL, 0x000fc400078ef638ULL,
0x00000180062b7810ULL, 0x000fe40007ffe02bULL, 0x000000062d387812ULL, 0x000fe400078ef638ULL,
0x00000002032d7819ULL, 0x000fe200000006ffULL, 0x000000102c2c7824ULL, 0x100fe200078e022bULL,
0x0000000833377810ULL, 0x000fe20007ffe0ffULL, 0x000000102e2e7824ULL, 0x100fe200078e022bULL,
0x0000000c2d357812ULL, 0x000fe200078ec0ffULL, 0x00000010422d7824ULL, 0x000fe200078e022bULL,
0x00000037ff487212ULL, 0x000fe200078e33ffULL, 0x00000008372f7824ULL, 0x004fe200078e00ffULL,
0x0000002c352c7210ULL, 0x040fe20007ffe0ffULL, 0x00000001352d7824ULL, 0x040fe200078e022dULL,
0x0000002e352e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001030307824ULL, 0x100fe200078e022bULL,
0xfffffff82f487812ULL, 0x000fe200078ee248ULL, 0x0000001032327824ULL, 0x100fe200078e022bULL,
0x000000002c2c7984ULL, 0x000ea20000000800ULL, 0x00000007372f7812ULL, 0x000fe200078ec0ffULL,
0x0000000135307824ULL, 0x040fe200078e0230ULL, 0x0000030004007a0cULL, 0x000fe20003f06070ULL,
0x000000002e2e7984ULL, 0x000fe20000000800ULL, 0x0000001036367824ULL, 0x100fe200078e022bULL,
0x0000003235327210ULL, 0x000fe20007ffe0ffULL, 0x00000008373c7824ULL, 0x000fe200078e00ffULL,
0x000000002d2d7984ULL, 0x000f220000000800ULL, 0x0000003a053a7221ULL, 0x002fe20000010100ULL,
0x0000003635367210ULL, 0x000fe20007ffe0ffULL, 0x0000001038387824ULL, 0x000fe200078e022bULL,
0x0000000030307984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3a317820ULL, 0x000fe20000410000ULL,
0x00000008373a7824ULL, 0x000fe200078e00ffULL, 0x000000013c3e7812ULL, 0x140fe200078ef62fULL,
0x0000000032327984ULL, 0x000fe20000000800ULL, 0x000000023c407812ULL, 0x100fe200078ef62fULL,
0x0000000135387824ULL, 0x040fe200078e0238ULL, 0x0000003100317308ULL, 0x000ee20000000800ULL,
0xfffffff83a3a7812ULL, 0x100fe200078ee22fULL, 0x0000000036367984ULL, 0x000fe20000000800ULL,
0x000000033c427812ULL, 0x000fe200078ef62fULL, 0x000000103e3e7824ULL, 0x100fe200078e022bULL,
0x0000002b3a3a7211ULL, 0x000fe200078e20ffULL, 0x0000001040407824ULL, 0x000fe200078e022bULL,
0x000000043c447812ULL, 0x140fe200078ef62fULL, 0x00000001353e7824ULL, 0x040fe200078e023eULL,
0x0000000038387984ULL, 0x000fe20000000800ULL, 0x00000001353a7824ULL, 0x040fe200078e023aULL,
0x000000053c467812ULL, 0x140fe200078ef62fULL, 0x0000000135407824ULL, 0x000fe200078e0240ULL,
0x000000063c3c7812ULL, 0x000fe200078ef62fULL, 0x0000001042427824ULL, 0x100fe200078e022bULL,
0x000000003e3e7984ULL, 0x000fe20000000800ULL, 0x0000004a314c7220ULL, 0x008fe20000410000ULL,
0x0000001034347824ULL, 0x100fe200078e022bULL, 0x0000000104047810ULL, 0x000fe20007ffe0ffULL,
0x000000003a3a7984ULL, 0x000fe20000000800ULL, 0x0000001044447824ULL, 0x000fe200078e022bULL,
0x0000004235427210ULL, 0x040fe20007ffe0ffULL, 0x0000000135347824ULL, 0x040fe200078e0234ULL,
0x00001f334c317589ULL, 0x000e6200000e0000ULL, 0x0000000135447824ULL, 0x040fe200078e0244ULL,
0x000000274c277221ULL, 0x000fe20000010000ULL, 0x0000001046467824ULL, 0x100fe200078e022bULL,
0x0000000040407984ULL, 0x000fe20000000800ULL, 0x000000103c3c7824ULL, 0x100fe200078e022bULL,
0x0000000128287810ULL, 0x000fe20007ffe0ffULL, 0x0000001048487824ULL, 0x000fe200078e022bULL,
0x0000000034347984ULL, 0x000ee20000000800ULL, 0x0000000135467824ULL, 0x000fe200078e0246ULL,
0x0000000129297810ULL, 0x000fe20007ffe0ffULL, 0x00000001353c7824ULL, 0x040fe200078e023cULL,
0x0000000042427984ULL, 0x000fe20000000800ULL, 0x0000000135487824ULL, 0x000fe200078e0248ULL,
0x000000012a2a7810ULL, 0x000fe20007ffe0ffULL, 0x3000002cff2b7230ULL, 0x104fe20000004100ULL,
0x0000000044447984ULL, 0x000fe20000000800ULL, 0x2000002cff4a7230ULL, 0x000fc40000004100ULL,
0x2000002dff2c7230ULL, 0x110fe20000004100ULL, 0x0000000046467984ULL, 0x000fe20000000800ULL,
0x3000002dff2d7230ULL, 0x000fc60000004100ULL, 0x000000003c3c7984ULL, 0x000fe20000000800ULL,
0x000000312b227223ULL, 0x082fe20000010022ULL, 0x3000002eff2b7230ULL, 0x100fe20000004100ULL,
0x000000312c0b7223ULL, 0x080fe2000001000bULL, 0x0000000048487984ULL, 0x000fe20000000800ULL,
0x2000002eff2c7230ULL, 0x000fe20000004100ULL, 0x000000312d0a7223ULL, 0x080fe2000001000aULL,
0x000000312b1e7223ULL, 0x080fe2000001001eULL, 0x00001f374c4c7589ULL, 0x000e6200000e0000ULL,
0x30000030ff2b7230ULL, 0x000fe20000004100ULL, 0x000000312c1f7223ULL, 0x080fe2000001001fULL,
0x30000032ff2d7230ULL, 0x100fe20000004100ULL, 0x000000314a237223ULL, 0x080fe20000010023ULL,
0x20000032ff2c7230ULL, 0x000fe20000004100ULL, 0x000000312b1a7223ULL, 0x080fe2000001001aULL,
0x30000036ff2b7230ULL, 0x000fe20000004100ULL, 0x000000312d167223ULL, 0x080fe20000010016ULL,
0x30000038ff2d7230ULL, 0x000fe20000004100ULL, 0x000000312c177223ULL, 0x080fe20000010017ULL,
0x20000030ff2e7230ULL, 0x000fe20000004100ULL, 0x000000312b107223ULL, 0x080fe20000010010ULL,
0x3000003aff2b7230ULL, 0x000fe20000004100ULL, 0x000000312d0e7223ULL, 0x080fe2000001000eULL,
0x20000036ff2c7230ULL, 0x000fe20000004100ULL, 0x000000312e1b7223ULL, 0x000fe2000001001bULL,
0x3000003eff2d7230ULL, 0x000fc40000004100ULL, 0x20000038ff2e7230ULL, 0x000fe20000004100ULL,
0x000000312c117223ULL, 0x080fe20000010011ULL, 0x2000003aff2c7230ULL, 0x000fe40000004100ULL,
0x20000034ff2f7230ULL, 0x008fe20000004100ULL, 0x0000004c2b207223ULL, 0x082fe20000010020ULL,
0x30000040ff2b7230ULL, 0x000fe20000004100ULL, 0x0000004c2d1c7223ULL, 0x080fe2000001001cULL,
0x000000312e0f7223ULL, 0x080fe2000001000fULL, 0x0000004c2c217223ULL, 0x080fe20000010021ULL,
0x30000044ff2d7230ULL, 0x000fe20000004100ULL, 0x0000004c2b187223ULL, 0x080fe20000010018ULL,
0x30000042ff2b7230ULL, 0x000fe20000004100ULL, 0x000000312f147223ULL, 0x080fe20000010014ULL,
0x2000003eff2c7230ULL, 0x000fe20000004100ULL, 0x0000004c2d127223ULL, 0x080fe20000010012ULL,
0x20000040ff2e7230ULL, 0x000fe20000004100ULL, 0x0000004c2b087223ULL, 0x080fe20000010008ULL,
0x20000046ff2f7230ULL, 0x000fe20000004100ULL, 0x0000004c2c1d7223ULL, 0x080fe2000001001dULL,
0x2000003cff2b7230ULL, 0x000fe20000004100ULL, 0x0000004c2e197223ULL, 0x080fe20000010019ULL,
0x20000048ff2d7230ULL, 0x000fe20000004100ULL, 0x0000004c2f267223ULL, 0x080fe20000010026ULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x0000004c2b247223ULL, 0x080fe20000010024ULL,
0x20000042ff2c7230ULL, 0x000fe20000004100ULL, 0x0000004c2d0c7223ULL, 0x080fe2000001000cULL,
0x20000044ff2e7230ULL, 0x000fe20000004100ULL, 0x0000003134137223ULL, 0x000fe20000010013ULL,
0x30000046ff467230ULL, 0x000fe20000004100ULL, 0x0000004c2c097223ULL, 0x080fe20000010009ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000004c2e157223ULL, 0x080fe20000010015ULL,
0x30000048ff487230ULL, 0x000fe20000004100ULL, 0x0000004c46257223ULL, 0x000fc40000010025ULL,
0x0000004c3c0d7223ULL, 0x080fe4000001000dULL, 0x0000004c48077223ULL, 0x000fe20000010007ULL,
0xfffff34000008947ULL, 0x000fea000383ffffULL, 0x0180000027037810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000c91000287802ULL, 0x000fe40000000f00ULL,
0x00009cd000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002700047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000027ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x00000008062a7811ULL, 0x050fe400078ff0ffULL,
0x00000002ff287819ULL, 0x000fe20000011606ULL, 0x0000000406067824ULL, 0x000fe400078e00ffULL,
0x00001f2a03057589ULL, 0x00cea200000e0000ULL, 0x00000003282c7819ULL, 0x000fe200000006ffULL,
0x000000082a297824ULL, 0x000fe200078e00ffULL, 0x0000000c06067812ULL, 0x000fe200078ec0ffULL,
0x00001f2803047589ULL, 0x00072400000e0000ULL, 0x00000028ff037212ULL, 0x008fc800078e33ffULL,
0xfffffff82c277812ULL, 0x002fe200078ee203ULL, 0x0000000828037824ULL, 0x000fc800078e00ffULL,
0x0000001027277824ULL, 0x000fe200078e0202ULL, 0x0000002105217220ULL, 0x044fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000000905097220ULL, 0x040fe20000410000ULL,
0x0000000805087220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002505257220ULL, 0x040fe20000410000ULL, 0x0000002405247220ULL, 0x040fe20000410000ULL,
0x0000000d050d7220ULL, 0x040fe20000410000ULL, 0x0000000c050c7220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x050fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001404147220ULL, 0x040fe20000410000ULL, 0x0000001304137220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000000b040b7220ULL, 0x040fe20000410000ULL, 0x0000000705057220ULL, 0x000fe20000410000ULL,
0x0000000a04047220ULL, 0x000fe20000410000ULL, 0x0000000728077812ULL, 0x000fe200078ec0ffULL,
0x0000000106277824ULL, 0x000fe200078e0227ULL, 0x0000002aff0a7212ULL, 0x000fc400078e33ffULL,
0x000000090808723eULL, 0x000fe400000000ffULL, 0x0000000107097812ULL, 0x000fe400078e3cffULL,
0xfffffff829297812ULL, 0x000fe400078ee20aULL, 0x000000111010723eULL, 0x000fe200000000ffULL,
0x0000000828097824ULL, 0x000fe200078e0209ULL, 0x0000000b0404723eULL, 0x000fe200000000ffULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x0000000f0e0e723eULL, 0x000fe200000000ffULL,
0x0000001009097824ULL, 0x000fe200078e0202ULL, 0x000000072a0a7812ULL, 0x000fc400078ec0ffULL,
0x00000002070b7812ULL, 0x040fe400078e3cffULL, 0x0000000407117812ULL, 0x040fe400078e3cffULL,
0x000000151212723eULL, 0x000fe400000000ffULL, 0x00000003070f7812ULL, 0x040fe200078e3cffULL,
0x0000000828117824ULL, 0x000fe200078e0211ULL, 0x0000000507157812ULL, 0x000fe400078e3cffULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x00000008280f7824ULL, 0x000fe200078e020fULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000000828157824ULL, 0x000fe200078e0215ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x000000082a177824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fe200078ee228ULL, 0x000000100f0f7824ULL, 0x100fe200078e0202ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000001015157824ULL, 0x000fe200078e0202ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x00000001060f7824ULL, 0x000fe200078e020fULL,
0x0000001d1c1c723eULL, 0x000fc400000000ffULL, 0x000000191818723eULL, 0x000fe400000000ffULL,
0x0000000607077812ULL, 0x000fe400078e3cffULL, 0x0000000b280b7211ULL, 0x000fe400078e18ffULL,
0x000000020a1b7812ULL, 0x040fe400078e3cffULL, 0x000000060a237812ULL, 0x040fe200078e3cffULL,
0x000000100b0b7824ULL, 0x000fe200078e0202ULL, 0x000000010a197812ULL, 0x000fe200078e3cffULL,
0x000000082a1b7824ULL, 0x000fe200078e021bULL, 0x000000030a1d7812ULL, 0x000fe200078e3cffULL,
0x000000082a237824ULL, 0x000fe200078e0223ULL, 0x000000040a1f7812ULL, 0x000fe200078e3cffULL,
0x000000082a197824ULL, 0x000fe200078e0219ULL, 0x000000050a217812ULL, 0x000fe200078e3cffULL,
0x00000001060b7824ULL, 0x000fe200078e020bULL, 0x0000000203037211ULL, 0x080fe200078e20ffULL,
0x000000082a1f7824ULL, 0x000fe200078e021fULL, 0x0000000728077211ULL, 0x000fe200078e18ffULL,
0x000000082a217824ULL, 0x040fe200078e0221ULL, 0xfffffff817177812ULL, 0x000fe200078ee22aULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x0000001d2a1d7211ULL, 0x000fe200078e18ffULL,
0x0000001007077824ULL, 0x100fe200078e0202ULL, 0x0000000211117211ULL, 0x000fe200078e20ffULL,
0x0000001017177824ULL, 0x100fe200078e0202ULL, 0x0000000603037210ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0x0000000906097210ULL, 0x040fe20007ffe0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x000000021b1b7211ULL, 0x080fe200078e20ffULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x0000000223237211ULL, 0x000fe200078e20ffULL,
0x0000000106027824ULL, 0x040fe200078e0211ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000002203007388ULL, 0x0003e20000000800ULL, 0x0000001506157210ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x040fe200078e0207ULL, 0x0000001d061d7210ULL, 0x040fe20007ffe0ffULL,
0x0000001e09007388ULL, 0x0003e20000000800ULL, 0x0000000106177824ULL, 0x040fe200078e0217ULL,
0x0000000c0505723eULL, 0x000fe200000000ffULL, 0x0000000106197824ULL, 0x040fe200078e0219ULL,
0x0000001a0b007388ULL, 0x0003e20000000800ULL, 0x00000001061b7824ULL, 0x040fe200078e021bULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x00000001061f7824ULL, 0x040fe200078e021fULL,
0x000000160f007388ULL, 0x0003e20000000800ULL, 0x00000001060c7824ULL, 0x040fe200078e0229ULL,
0x000000240d0d723eULL, 0x000fe200000000ffULL, 0x00000001060a7824ULL, 0x040fe200078e0221ULL,
0x0000001302007388ULL, 0x0003e20000000800ULL, 0x0000000106067824ULL, 0x000fc600078e0223ULL,
0x0000001015007388ULL, 0x0003e80000000800ULL, 0x0000000e07007388ULL, 0x0003e80000000800ULL,
0x0000000427007388ULL, 0x0003e80000000800ULL, 0x0000002017007388ULL, 0x0003e80000000800ULL,
0x0000001c19007388ULL, 0x0003e80000000800ULL, 0x000000181b007388ULL, 0x0003e80000000800ULL,
0x000000081d007388ULL, 0x0003e80000000800ULL, 0x000000121f007388ULL, 0x0003e80000000800ULL,
0x000000250a007388ULL, 0x0003e80000000800ULL, 0x0000000d06007388ULL, 0x0003e80000000800ULL,
0x000000050c007388ULL, 0x0003e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x004ea20000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020050d7810ULL, 0x002fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x008fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008040f7824ULL, 0x004fe200078e00ffULL,
0x0000000706087812ULL, 0x000fe400078e4805ULL, 0x0000000702037812ULL, 0x000fe400078e480dULL,
0x0ffffff808077812ULL, 0x000fe400078ef805ULL, 0x0ffffff803037812ULL, 0x000fc400078ef80dULL,
0x0000000007087211ULL, 0x000fe200078e20ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0xfffffff80f027812ULL, 0x000fe200078ee202ULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0x000000070d0d7812ULL, 0x000fe400078ec0ffULL, 0x00a0000008087984ULL, 0x000e620000000c00ULL,
0xfffffff807007812ULL, 0x000fe400078ee206ULL, 0x0000000705077812ULL, 0x000fe200078ec0ffULL,
0x00a0000003107984ULL, 0x0004e20000000c00ULL, 0x0000000400067c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL, 0x1ffffff807077812ULL, 0x100fe400078ef864ULL,
0x1ffffff80d0d7812ULL, 0x000fe200078ef864ULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x000000ffff037210ULL, 0x004fe400007fe4ffULL, 0x00005a0006027a11ULL, 0x000fe400078048ffULL,
0x00005a0000047a11ULL, 0x000fc400078248ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000161097810ULL, 0x000fe20007ffe0ffULL,
0x0000004060027824ULL, 0x000fe200078e00ffULL, 0x01460000ff067f8cULL, 0x000e62000c80043fULL,
0x0000000263037824ULL, 0x000fe200078e00ffULL, 0x000000000900720cULL, 0x000fc40003f06070ULL,
0x0000000261107211ULL, 0x000fe200078e40ffULL, 0x0000580003037a24ULL, 0x000fc800078e020eULL,
0x0000620003237a24ULL, 0x000fcc00078e0210ULL, 0x0000059000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x000fe40000011604ULL, 0x000000300c217812ULL, 0x000fe400078ec0ffULL,
0x000000081a147810ULL, 0x040fe20007ffe0ffULL, 0x0000000123087824ULL, 0x040fe200078e021aULL,
0x000000101a1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000181a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001230a7824ULL, 0x000fe200078e0214ULL, 0x00000010170c7217ULL, 0x000fe20007800000ULL,
0x00000001230e7824ULL, 0x040fe200078e021cULL, 0x0000001e23127210ULL, 0x000fe20007ffe0ffULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0x000000201a167810ULL, 0x000fc40007ffe0ffULL,
0x00000003ff197819ULL, 0x000fe20000011604ULL, 0x000000010c157824ULL, 0x000fe200078e0a10ULL,
0x000000210a0a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e000e0c7625ULL, 0x080fe200078e0005ULL,
0x0000000319197812ULL, 0x100fe400078e4804ULL, 0x00002000601b7811ULL, 0x000fe200078e68ffULL,
0x00005e0008087625ULL, 0x080fe200078e0005ULL, 0x000000281a187810ULL, 0x000fe40007ffe0ffULL,
0x0ffffffc19047812ULL, 0x000fe200078ef804ULL, 0x00005e00120e7625ULL, 0x000fe200078e0005ULL,
0x0000002108107210ULL, 0x000fc40007f1e0ffULL, 0x0000001623087210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000210e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200000e0609ULL, 0x000000210c0c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x0000001b041d7211ULL, 0x000fe400078e20ffULL,
0x000000301a047810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000151400720cULL, 0x040fe20003f26070ULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x0000002108127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000151a00720cULL, 0x000fc40003f06070ULL, 0xfffffffc14087812ULL, 0x000fe200078ee219ULL,
0x000000ffff137224ULL, 0x000fe200010e0609ULL, 0x000000381a1a7810ULL, 0x000fe40007ffe0ffULL,
0x000000151c00720cULL, 0x080fe20003fa6070ULL, 0x00000010081f7824ULL, 0x000fe200078e021bULL,
0x000000151e00720cULL, 0x080fe20003f86070ULL, 0x0000000123087824ULL, 0x000fe200078e0218ULL,
0x000000151600720cULL, 0x0c0fe20003f66070ULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0x000000151800720cULL, 0x000fe20003f46070ULL, 0x00005e0008087625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0005e2000c101c46ULL,
0x000000151a00720cULL, 0x000fc40003f06070ULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x0000002108147210ULL, 0x000fe20007fde0ffULL, 0x000000000a1f7faeULL, 0x0007e2000c901c46ULL,
0x0000000423087210ULL, 0x040fe40007ffe0ffULL, 0x000000150400720cULL, 0x000fe40003f26070ULL,
0x00000009ff157210ULL, 0x000fe200037fe4ffULL, 0x00005e0008087625ULL, 0x000fe200078e0005ULL,
0xfffffffc16167812ULL, 0x100fe400078ee219ULL, 0xfffffffc18187812ULL, 0x100fe200078ee219ULL,
0x000000041e107824ULL, 0x004fe200078e00ffULL, 0x0000002108087210ULL, 0x000fe20007fde0ffULL,
0x000000041c0a7824ULL, 0x008fe200078e00ffULL, 0x000000021a1e7819ULL, 0x000fe200000006ffULL,
0x00000004041c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc10107812ULL, 0x100fe200078ee219ULL,
0x0000000123047824ULL, 0x000fe200078e021aULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0xfffffffc1c1a7812ULL, 0x100fe200078ee219ULL,
0x00005e0004047625ULL, 0x000fe200078e0005ULL, 0xfffffffc1e1c7812ULL, 0x000fc400078ee219ULL,
0x0000001b16197211ULL, 0x000fe200078e20ffULL, 0x000000100a0b7824ULL, 0x100fe200078e021bULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x0000001010117824ULL, 0x100fe400078e021bULL,
0x00000010181d7824ULL, 0x100fe200078e021bULL, 0x00000005ff057210ULL, 0x000fe200037fe4ffULL,
0x000000101a1f7824ULL, 0x100fe200078e021bULL, 0x000000000c0b7faeULL, 0x0005e2000e901c46ULL,
0x000000101c1b7824ULL, 0x000fc600078e021bULL, 0x000000000e117faeULL, 0x0005e8000e101c46ULL,
0x0000000012197faeULL, 0x0005e8000d901c46ULL, 0x00000000141d7faeULL, 0x0005e8000d101c46ULL,
0x00000000081f7faeULL, 0x0005e8000c901c46ULL, 0x00000000041b7faeULL, 0x0005e2000c101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000300c277812ULL, 0x000fe400078ec0ffULL,
0x00000008040c7811ULL, 0x000fc400078ff0ffULL, 0x0000001004097811ULL, 0x040fe400078ff0ffULL,
0x0000002304087211ULL, 0x000fe200078ff0ffULL, 0x00000001230a7824ULL, 0x040fe200078e020cULL,
0x00000003ff117819ULL, 0x000fe20000011604ULL, 0x000000040c147824ULL, 0x000fe200078e00ffULL,
0x00000018040b7811ULL, 0x040fe200078ff0ffULL, 0x00000001230c7824ULL, 0x000fe200078e0209ULL,
0x00000028040e7811ULL, 0x040fe400078ff0ffULL, 0x0000003804107811ULL, 0x000fe200078ff0ffULL,
0x000000040b207824ULL, 0x000fe200078e00ffULL, 0x00000002091e7819ULL, 0x000fe200000006ffULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x00000020040d7811ULL, 0x000fc400078ff0ffULL,
0x00000030040f7811ULL, 0x000fe200078ff0ffULL, 0x000000040e247824ULL, 0x000fe200078e00ffULL,
0x0000000311117812ULL, 0x000fe200078e4804ULL, 0x00000001231c7824ULL, 0x000fe200078e0210ULL,
0x000000020d227819ULL, 0x000fe200000006ffULL, 0x0000000410287824ULL, 0x000fe200078e00ffULL,
0x000000020f267819ULL, 0x000fe200000006ffULL, 0x0000000123187824ULL, 0x040fe200078e020eULL,
0x0000002708107210ULL, 0x000fe20007f1e0ffULL, 0x00000001231a7824ULL, 0x000fe200078e020fULL,
0x0ffffffc11197812ULL, 0x000fe200078ef804ULL, 0x0000000123127824ULL, 0x040fe200078e020bULL,
0xfffffffc14047812ULL, 0x000fe200078ee211ULL, 0x0000000123167824ULL, 0x000fe200078e020dULL,
0xfffffffc1e0e7812ULL, 0x000fc400078ee211ULL, 0xfffffffc200f7812ULL, 0x100fe400078ee211ULL,
0xfffffffc22137812ULL, 0x100fe400078ee211ULL, 0xfffffffc24147812ULL, 0x100fe400078ee211ULL,
0xfffffffc26157812ULL, 0x100fe400078ee211ULL, 0xfffffffc281e7812ULL, 0x000fe200078ee211ULL,
0x000000ffff117224ULL, 0x000fe200000e0609ULL, 0x0000200060257811ULL, 0x000fe200078e68ffULL,
0x00005e000a087625ULL, 0x000fc600078e0005ULL, 0x00000025131f7211ULL, 0x000fe200078e20ffULL,
0x00005e000c0a7625ULL, 0x000fe200078e0005ULL, 0x0000002519297211ULL, 0x000fc600078e20ffULL,
0x00005e00120c7625ULL, 0x000fe200078e0005ULL, 0x0000002708127210ULL, 0x080fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010297faeULL, 0x0005e4000b901c46ULL,
0x0000001014217824ULL, 0x100fe200078e0225ULL, 0x000000270a147210ULL, 0x000fe20007f3e0ffULL,
0x0000001015237824ULL, 0x000fe200078e0225ULL, 0x00000009ff137210ULL, 0x000fe200007fe4ffULL,
0x00005e0016087625ULL, 0x000fe200078e0005ULL, 0x000000270c0c7210ULL, 0x000fc60007f1e0ffULL,
0x000000100e1b7824ULL, 0x100fe400078e0225ULL, 0x000000100f1d7824ULL, 0x000fe400078e0225ULL,
0x000000ffff157224ULL, 0x000fe400008e060bULL, 0x0000001004197824ULL, 0x000fe400078e0225ULL,
0x00005e00180a7625ULL, 0x000fc600078e0005ULL, 0x0000000012197faeULL, 0x0005e2000b901c46ULL,
0x00005e001a0e7625ULL, 0x000fe200078e0005ULL, 0x000000270a0a7210ULL, 0x000fe40007f3e0ffULL,
0x00000000141b7faeULL, 0x0005e2000b901c46ULL, 0x00005e001c047625ULL, 0x000fe200078e0005ULL,
0x000000270e0e7210ULL, 0x000fe40007f5e0ffULL, 0x0000000bff0b7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000002708087210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060fULL, 0x0000002704047210ULL, 0x000fe20007f7e0ffULL,
0x000000101e257824ULL, 0x000fe200078e0225ULL, 0x000000000c1d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff097224ULL, 0x000fc400000e0609ULL, 0x000000ffff057224ULL, 0x000fc600018e0605ULL,
0x00000000081f7faeULL, 0x0005e8000b901c46ULL, 0x000000000a217faeULL, 0x0005e8000b901c46ULL,
0x000000000e237faeULL, 0x0005e8000b901c46ULL, 0x0000000004257faeULL, 0x0005e4000b901c46ULL,
0x01460400ff057984ULL, 0x004ea80000000800ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x8000000005ff7812ULL, 0x006fc60007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff047424ULL, 0x000fc800078e00ffULL, 0x0000000400057305ULL, 0x0002a4000021f000ULL,
0x3fa0000004047823ULL, 0x002fe200000100ffULL, 0x000000050000735dULL, 0x004fe40003800000ULL,
0x01460400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000006100720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x0001468860057811ULL, 0x000fe400078e18ffULL, 0xffffffff00067810ULL, 0x000fe40007ffe0ffULL,
0x0000000560077819ULL, 0x000fe400000006ffULL, 0x0000010061087824ULL, 0x008fe200078e0202ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000081700720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x014fea0003800000ULL, 0x0000000161097810ULL, 0x000fe20007ffe0ffULL,
0x0000620003697a24ULL, 0x000fc600078e0208ULL, 0x000000000900720cULL, 0x000fe20003f06070ULL,
0x00000200ff097424ULL, 0x000fd800078e00ffULL, 0x0000052000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x002fe20000011604ULL, 0x00000001170a7824ULL, 0x000fe200078e0a08ULL,
0x00000003ff117819ULL, 0x000fe40000011604ULL, 0x00000008120f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004110b7212ULL, 0x000fe400078e3cffULL, 0x00000069120c7210ULL, 0x000fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x040fe200078e0269ULL, 0x00000003046c7812ULL, 0x000fe200078ec0ffULL,
0x000000040f147824ULL, 0x000fe200078e00ffULL, 0x000000030b0b7812ULL, 0x000fe200078ec0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0009ULL, 0x0000000a1200720cULL, 0x000fc40003f26070ULL,
0x0000000a0f00720cULL, 0x000fe20003f46070ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0009ULL,
0x000000046c1d7812ULL, 0x000fe400078efcffULL, 0x0000300060107811ULL, 0x000fe400078e68ffULL,
0x0ffffffc0b6d7812ULL, 0x000fe200078ef804ULL, 0x000000101d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc14157812ULL, 0x000fe400078ee20bULL, 0x0000001012167810ULL, 0x040fe20007ffe0ffULL,
0x000000106d137824ULL, 0x000fe200078e0210ULL, 0x0000001015157211ULL, 0x000fe200078e20ffULL,
0x000000101d0e7825ULL, 0x000fe200078e000eULL, 0x00000018121c7810ULL, 0x000fc40007ffe0ffULL,
0x00000020121e7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x00000028121f7810ULL, 0x040fe40007ffe0ffULL,
0x0000003012207810ULL, 0x040fe20007ffe0ffULL, 0x000000000e157faeULL, 0x0005e2000d101c46ULL,
0x0000003812217810ULL, 0x000fe20007ffe0ffULL, 0x000000011e127824ULL, 0x100fe200078e0269ULL,
0x000000691f147210ULL, 0x000fe20007ffe0ffULL, 0x0000000120187824ULL, 0x100fe200078e0269ULL,
0x0000000a1600720cULL, 0x080fe20003f26070ULL, 0x00000001211a7824ULL, 0x100fe200078e0269ULL,
0x0000000a1c00720cULL, 0x080fe20003f46070ULL, 0x00000001160c7824ULL, 0x002fe200078e0269ULL,
0x0000000a1e00720cULL, 0x080fe20003f66070ULL, 0x00005e0012127625ULL, 0x000fe200078e0009ULL,
0x0000000a1f00720cULL, 0x000fc40003f86070ULL, 0x0000000a2000720cULL, 0x080fe20003fa6070ULL,
0x000000011c0e7824ULL, 0x044fe200078e0269ULL, 0x000000021c1c7819ULL, 0x000fe200000006ffULL,
0x00005e000c0c7625ULL, 0x080fe200078e0009ULL, 0x0000000a2100720cULL, 0x040fe40003fc6070ULL,
0x0000000221227819ULL, 0x000fe200000006ffULL, 0x00005e000e0e7625ULL, 0x000fc600078e0009ULL,
0xfffffffc22277812ULL, 0x000fe200078ee20bULL, 0x00005e0014147625ULL, 0x000fc800078e0009ULL,
0x00005e0018187625ULL, 0x000fc800078e0009ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0009ULL,
0x0000000416167824ULL, 0x000fe400078e00ffULL, 0x000000041e1e7824ULL, 0x000fe400078e00ffULL,
0x000000101d0c7825ULL, 0x000fc600078e000cULL, 0xfffffffc1e217812ULL, 0x000fe200078ee20bULL,
0x000000101d0e7825ULL, 0x000fc800078e000eULL, 0x000000101d127825ULL, 0x000fc800078e0012ULL,
0x000000101d147825ULL, 0x000fc800078e0014ULL, 0x000000101d187825ULL, 0x000fc800078e0018ULL,
0x000000101d1a7825ULL, 0x000fe200078e001aULL, 0xfffffffc161d7812ULL, 0x000fc600078ee20bULL,
0x000000041f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c1f7812ULL, 0x100fe200078ee20bULL,
0x0000000420207824ULL, 0x000fe400078e00ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0210ULL,
0xfffffffc0a237812ULL, 0x100fe200078ee20bULL, 0x000000101f1f7824ULL, 0x100fe200078e0210ULL,
0xfffffffc20257812ULL, 0x000fe200078ee20bULL, 0x0000001021217824ULL, 0x100fe200078e0210ULL,
0x0000001023237211ULL, 0x000fe200078e20ffULL, 0x0000001027277824ULL, 0x100fe200078e0210ULL,
0x000000000c1d7faeULL, 0x0003e2000c901c46ULL, 0x0000001025257824ULL, 0x000fc600078e0210ULL,
0x000000000e1f7faeULL, 0x0003e8000d101c46ULL, 0x0000000012217faeULL, 0x0003e8000d901c46ULL,
0x0000000014237faeULL, 0x0003e8000e101c46ULL, 0x0000000018257faeULL, 0x0003e8000e901c46ULL,
0x000000001a277faeULL, 0x0003e2000f101c46ULL, 0x0000047000007947ULL, 0x000fea0003800000ULL,
0x00000069040a7211ULL, 0x042fe400078ff0ffULL, 0x00000003046c7812ULL, 0x000fc400078ec0ffULL,
0x0000000804107811ULL, 0x000fe200078ff0ffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0009ULL,
0x000000046c217812ULL, 0x000fe400078efcffULL, 0x0000001004167811ULL, 0x000fe200078ff0ffULL,
0x00000001100e7824ULL, 0x000fe200078e0269ULL, 0x0000001804207811ULL, 0x040fe200078ff0ffULL,
0x00000010210c7825ULL, 0x000fe200078e000aULL, 0x0000002004227811ULL, 0x040fe400078ff0ffULL,
0x0000002804247811ULL, 0x000fe200078ff0ffULL, 0x00005e000e0a7625ULL, 0x000fe200078e0009ULL,
0x0000003004267811ULL, 0x000fc400078ff0ffULL, 0x0000003804287811ULL, 0x000fe200078ff0ffULL,
0x0000000120147824ULL, 0x100fe200078e0269ULL, 0x00000003ff117819ULL, 0x000fe20000011604ULL,
0x0000000122187824ULL, 0x100fe200078e0269ULL, 0x0000006916127210ULL, 0x080fe20007ffe0ffULL,
0x00000001241a7824ULL, 0x100fe200078e0269ULL, 0x00000069261c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001281e7824ULL, 0x000fe200078e0269ULL, 0x0000000220207819ULL, 0x000fe200000006ffULL,
0x00000010210e7825ULL, 0x000fe200078e000aULL, 0x00000004110b7212ULL, 0x000fc400078e3cffULL,
0x00003000600a7811ULL, 0x000fe200078e68ffULL, 0x00005e0012127625ULL, 0x080fe200078e0009ULL,
0x000000030b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000228287819ULL, 0x000fe200000006ffULL,
0x00005e0014147625ULL, 0x080fe200078e0009ULL, 0x0ffffffc0b6d7812ULL, 0x000fe400078ef804ULL,
0xfffffffc20257812ULL, 0x000fe200078ee20bULL, 0x00005e0018187625ULL, 0x000fe200078e0009ULL,
0x0000000a6d2f7211ULL, 0x000fc400078e20ffULL, 0xfffffffc282d7812ULL, 0x000fe200078ee20bULL,
0x00005e001a1a7625ULL, 0x080fe400078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c2f7faeULL, 0x0003e2000b901c46ULL, 0x0000000a2d2d7211ULL, 0x000fe200078e20ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e0009ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0009ULL,
0x0000000410107824ULL, 0x000fe400078e00ffULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x0000000422227824ULL, 0x000fe400078e00ffULL, 0x0000001021127825ULL, 0x040fe200078e0012ULL,
0xfffffffc16237812ULL, 0x100fe400078ee20bULL, 0xfffffffc22277812ULL, 0x000fe200078ee20bULL,
0x0000001021147825ULL, 0x000fc800078e0014ULL, 0x0000001021187825ULL, 0x000fc800078e0018ULL,
0x00000010211a7825ULL, 0x000fc800078e001aULL, 0x00000010211c7825ULL, 0x000fc800078e001cULL,
0x00000010211e7825ULL, 0x000fe200078e001eULL, 0xfffffffc10217812ULL, 0x000fc600078ee20bULL,
0x0000000424247824ULL, 0x000fe400078e00ffULL, 0x0000000426267824ULL, 0x000fe400078e00ffULL,
0x0000001021217824ULL, 0x100fe200078e020aULL, 0xfffffffc24297812ULL, 0x100fe200078ee20bULL,
0x0000001023237824ULL, 0x100fe200078e020aULL, 0xfffffffc262b7812ULL, 0x000fe200078ee20bULL,
0x0000001025257824ULL, 0x100fe200078e020aULL, 0x000000000e217faeULL, 0x0003e2000b901c46ULL,
0x0000001027277824ULL, 0x000fc400078e020aULL, 0x0000001029297824ULL, 0x100fe200078e020aULL,
0x0000000012237faeULL, 0x0003e2000b901c46ULL, 0x000000102b2b7824ULL, 0x000fc600078e020aULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000018277faeULL, 0x0003e8000b901c46ULL,
0x000000001a297faeULL, 0x0003e8000b901c46ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e2d7faeULL, 0x0003e4000b901c46ULL, 0x00000004ff0a7819ULL, 0x000fe20000011604ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000007040d7812ULL, 0x002fe200078ec0ffULL,
0x00002000606a7824ULL, 0x000fe200078e00ffULL, 0x000000020a247810ULL, 0x040fe20007ffe0ffULL,
0x000000080a0e7824ULL, 0x000fc600078e00ffULL, 0x000020006a0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe400078ee20dULL, 0x000000080d0d7812ULL, 0x000fe400078ef804ULL,
0x00000001ff0f7819ULL, 0x000fe2000001160eULL, 0x000000040e127824ULL, 0x000fe200078e00ffULL,
0x000000070a107812ULL, 0x000fe400078e780dULL, 0x000000100e137810ULL, 0x000fc40007ffe0ffULL,
0x000000200e147810ULL, 0x040fe40007ffe0ffULL, 0x000000300e157810ULL, 0x000fe20007ffe0ffULL,
0x0000000413167824ULL, 0x000fe200078e00ffULL, 0x000000100d0e7211ULL, 0x000fe200078e28ffULL,
0x00000004141e7824ULL, 0x000fe200078e00ffULL, 0x000000030f107812ULL, 0x000fe200078ec0ffULL,
0x0000000415227824ULL, 0x000fe200078e00ffULL, 0x00000001ff0f7819ULL, 0x000fe20000011613ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000001ff137819ULL, 0x000fe20000011614ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001ff187819ULL, 0x000fe40000011615ULL,
0x000000030f147812ULL, 0x000fe400078ec0ffULL, 0x00000003131c7812ULL, 0x000fe400078ec0ffULL,
0x0000000318207812ULL, 0x000fe400078ec0ffULL, 0x00000001100f7812ULL, 0x000fc400078e7811ULL,
0x0000000114497812ULL, 0x100fe400078e7811ULL, 0x000000011c4b7812ULL, 0x100fe400078e7811ULL,
0x00000001204d7812ULL, 0x000fe400078e7811ULL, 0x000000120f0f7212ULL, 0x000fe400078efcffULL,
0x0000001649497212ULL, 0x000fe400078efcffULL, 0x0000001e4b4b7212ULL, 0x000fe200078efcffULL,
0x000000100f6b7824ULL, 0x100fe200078e020cULL, 0x000000224d4d7212ULL, 0x000fe200078efcffULL,
0x0000001049687824ULL, 0x100fe200078e020cULL, 0x000000040e0e7819ULL, 0x000fe200000006ffULL,
0x000000104b677824ULL, 0x000fe200078e020cULL, 0x0000000c4d667211ULL, 0x000fe200078e20ffULL,
0x000000006b3c783bULL, 0x000fe20000000200ULL, 0x0000000111117812ULL, 0x000fc400078ec0ffULL,
0x0000000724247812ULL, 0x000fe200078e780dULL, 0x000000000e18783bULL, 0x0002a20000000200ULL,
0x0000000210737812ULL, 0x100fe400078e1e11ULL, 0x000000021c157812ULL, 0x100fe200078e1e11ULL,
0x000000006838783bULL, 0x000ee20000000200ULL, 0x0000000214717812ULL, 0x100fe400078e1e11ULL,
0x00000002206f7812ULL, 0x000fe200078e1e11ULL, 0x000000006734783bULL, 0x000f220000000200ULL,
0x0000001273737212ULL, 0x000fe200078efcffULL, 0x000000200d0e7824ULL, 0x002fe200078e0224ULL,
0x0000001e15157212ULL, 0x000fe200078efcffULL, 0x000000006640783bULL, 0x000e620000000200ULL,
0x0000001671717212ULL, 0x000fe200078efcffULL, 0x000000100e0e7824ULL, 0x000fe200078e00ffULL,
0x000000226f6f7212ULL, 0x000fe200078efcffULL, 0x0000001073657824ULL, 0x100fe200078e020cULL,
0x0000000c71647211ULL, 0x000fe200078e20ffULL, 0x0000001015637824ULL, 0x100fe200078e020cULL,
0x000000000e20783bULL, 0x000fe20000000200ULL, 0x000000106f627824ULL, 0x000fc600078e020cULL,
0x000000006544783bULL, 0x000f680000000200ULL, 0x000000006430783bULL, 0x000e680000000200ULL,
0x000000006328783bULL, 0x000e680000000200ULL, 0x000000006210783bULL, 0x000e620000000200ULL,
0x0000003c182c723cULL, 0x044ff000000018ffULL, 0x000000381854723cULL, 0x048ff000000018ffULL,
0x00000034181c723cULL, 0x050ff000000018ffULL, 0x0000003e183c723cULL, 0x040ff000000018ffULL,
0x0000003a1838723cULL, 0x040ff000000018ffULL, 0x000000361834723cULL, 0x040ff000000018ffULL,
0x000000401824723cULL, 0x042ff000000018ffULL, 0x000000421818723cULL, 0x000ff000000018ffULL,
0x00000044202c723cULL, 0x060ff0000000182cULL, 0x000000302054723cULL, 0x040ff00000001854ULL,
0x00000028201c723cULL, 0x040ff0000000181cULL, 0x000000462044723cULL, 0x040ff0000000183cULL,
0x000000322030723cULL, 0x040ff00000001838ULL, 0x0000002a2028723cULL, 0x040ff00000001834ULL,
0x000000102024723cULL, 0x040ff00000001824ULL, 0x000000122020723cULL, 0x000fe20000001818ULL,
0x000004c000008947ULL, 0x000fee0003800000ULL, 0x00000002ff167819ULL, 0x000fe20000011604ULL,
0x0000000117147824ULL, 0x000fe200078e0a08ULL, 0x000000086c397812ULL, 0x000fc400078efcffULL,
0x00000008160e7810ULL, 0x040fe40007ffe0ffULL, 0x0000006916107210ULL, 0x000fe40007ffe0ffULL,
0x000000140e00720cULL, 0x0c0fe20003f46070ULL, 0x000000010e127824ULL, 0x000fe200078e0269ULL,
0x000000141600720cULL, 0x000fe20003f26070ULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000001016187810ULL, 0x000fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0009ULL,
0x0000001816387810ULL, 0x000fc40007ffe0ffULL, 0xfffffffc0e197812ULL, 0x000fe200078ee20bULL,
0x00005e0012127625ULL, 0x000fe200078e0009ULL, 0x00000020163a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c19197211ULL, 0x000fe200078e20ffULL, 0x000000106d0e7824ULL, 0x000fe200078e020cULL,
0x00000028163c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001039107825ULL, 0x040fe200078e0010ULL,
0x00000030163d7810ULL, 0x040fe40007ffe0ffULL, 0x0000003816167810ULL, 0x000fe20007ffe0ffULL,
0x0000001039127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100e7faeULL, 0x0003e2000c901c46ULL, 0x000000141800720cULL, 0x000fc40003f26070ULL,
0x000000143a00720cULL, 0x080fe20003f66070ULL, 0x0000000012197faeULL, 0x0005e2000d101c46ULL,
0x000000143800720cULL, 0x080fe20003f46070ULL, 0x00000001181a7824ULL, 0x100fe200078e0269ULL,
0x000000143c00720cULL, 0x080fe20003f86070ULL, 0x000000013d347824ULL, 0x140fe200078e0269ULL,
0x000000143d00720cULL, 0x0c0fe20003fa6070ULL, 0x0000000116367824ULL, 0x140fe200078e0269ULL,
0x000000141600720cULL, 0x000fe20003fc6070ULL, 0x0000000418147824ULL, 0x000fe400078e00ffULL,
0x0000000138107824ULL, 0x102fe200078e0269ULL, 0x000000693a127210ULL, 0x004fe20007ffe0ffULL,
0x000000013c187824ULL, 0x000fe200078e0269ULL, 0xfffffffc143b7812ULL, 0x000fe200078ee20bULL,
0x00005e001a1a7625ULL, 0x000fe200078e0009ULL, 0x000000023d147819ULL, 0x000fc400000006ffULL,
0x0000000c3b3b7211ULL, 0x000fe200078e20ffULL, 0x00005e0010107625ULL, 0x000fe200078e0009ULL,
0xfffffffc14417812ULL, 0x000fc600078ee20bULL, 0x00005e0012127625ULL, 0x000fc800078e0009ULL,
0x00005e0018187625ULL, 0x000fc800078e0009ULL, 0x00005e0034347625ULL, 0x000fc800078e0009ULL,
0x00005e0036367625ULL, 0x000fc800078e0009ULL, 0x0000000438387824ULL, 0x000fe400078e00ffULL,
0x000000043a3a7824ULL, 0x000fe400078e00ffULL, 0x000000043c3c7824ULL, 0x000fe400078e00ffULL,
0x00000010391a7825ULL, 0x040fe200078e001aULL, 0xfffffffc3a3d7812ULL, 0x100fe400078ee20bULL,
0xfffffffc3c3f7812ULL, 0x000fe200078ee20bULL, 0x0000001039107825ULL, 0x040fe200078e0010ULL,
0x000000001a3b7faeULL, 0x0003e6000c901c46ULL, 0x0000001039127825ULL, 0x000fc800078e0012ULL,
0x0000001039187825ULL, 0x000fc800078e0018ULL, 0x0000001039347825ULL, 0x000fe200078e0034ULL,
0x0000000c3f3b7211ULL, 0x002fc600078e20ffULL, 0x0000001039367825ULL, 0x000fe200078e0036ULL,
0xfffffffc38397812ULL, 0x000fc600078ee20bULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x00000010391b7824ULL, 0x100fe400078e020cULL, 0x000000103d397824ULL, 0x100fe200078e020cULL,
0xfffffffc16437812ULL, 0x000fe200078ee20bULL, 0x00000010413d7824ULL, 0x100fe200078e020cULL,
0x00000000101b7faeULL, 0x0003e6000d101c46ULL, 0x00000010433f7824ULL, 0x000fe200078e020cULL,
0x0000000012397faeULL, 0x0003e8000d901c46ULL, 0x00000000183b7faeULL, 0x0003e8000e101c46ULL,
0x00000000343d7faeULL, 0x0003e8000e901c46ULL, 0x00000000363f7faeULL, 0x0003e2000f101c46ULL,
0x0000041000007947ULL, 0x000fea0003800000ULL, 0x0000006904107211ULL, 0x000fe200078ff0ffULL,
0x000000106d0e7824ULL, 0x000fe200078e020cULL, 0x000000086c3f7812ULL, 0x000fc400078efcffULL,
0x0000000804127811ULL, 0x000fe200078ff0ffULL, 0x00005e0010107625ULL, 0x000fe200078e0009ULL,
0x0000001004147811ULL, 0x040fe400078ff0ffULL, 0x0000001804167811ULL, 0x000fe200078ff0ffULL,
0x0000000412427824ULL, 0x000fe200078e00ffULL, 0x00000020043a7811ULL, 0x040fe200078ff0ffULL,
0x000000103f107825ULL, 0x000fe200078e0010ULL, 0x00000028043c7811ULL, 0x040fe400078ff0ffULL,
0x00000030043e7811ULL, 0x000fe200078ff0ffULL, 0x0000000114367824ULL, 0x100fe200078e0269ULL,
0x0000003804407811ULL, 0x000fe200078ff0ffULL, 0x0000000414487824ULL, 0x000fe200078e00ffULL,
0x0000006912347210ULL, 0x080fe20007ffe0ffULL, 0x000000013a147824ULL, 0x100fe200078e0269ULL,
0x0000006916127210ULL, 0x080fe20007ffe0ffULL, 0x000000013c187824ULL, 0x100fe200078e0269ULL,
0x0000006940387210ULL, 0x000fe20007ffe0ffULL, 0x000000013e1a7824ULL, 0x000fe200078e0269ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100e7faeULL, 0x0003e2000b901c46ULL,
0x00005e0034347625ULL, 0x000fe200078e0009ULL, 0xfffffffc423b7812ULL, 0x000fc400078ee20bULL,
0xfffffffc483d7812ULL, 0x000fe200078ee20bULL, 0x00005e0036367625ULL, 0x000fe200078e0009ULL,
0x000000023a3a7819ULL, 0x000fc600000006ffULL, 0x00005e0018187625ULL, 0x000fe200078e0009ULL,
0xfffffffc3a417812ULL, 0x000fc600078ee20bULL, 0x00005e0012107625ULL, 0x002fc800078e0009ULL,
0x00005e0014127625ULL, 0x000fc800078e0009ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0009ULL,
0x00005e0038387625ULL, 0x000fc800078e0009ULL, 0x0000000416167824ULL, 0x000fe400078e00ffULL,
0x000000043c3c7824ULL, 0x000fe400078e00ffULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x000000103b3b7824ULL, 0x000fe200078e020cULL, 0xfffffffc3c437812ULL, 0x000fe200078ee20bULL,
0x000000103f347825ULL, 0x000fe200078e0034ULL, 0xfffffffc3e4f7812ULL, 0x000fc600078ee20bULL,
0x000000103d3d7824ULL, 0x000fe200078e020cULL, 0x00000000343b7faeULL, 0x0003e2000b901c46ULL,
0x000000103f367825ULL, 0x000fc800078e0036ULL, 0x000000103f107825ULL, 0x040fe200078e0010ULL,
0x00000000363d7faeULL, 0x0005e6000b901c46ULL, 0x000000103f127825ULL, 0x000fc800078e0012ULL,
0x000000103f187825ULL, 0x000fc800078e0018ULL, 0x000000103f1a7825ULL, 0x000fc800078e001aULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0xfffffffc163f7812ULL, 0x000fc600078ee20bULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000000c3f357211ULL, 0x082fe200078e20ffULL,
0x0000001041377824ULL, 0x104fe400078e020cULL, 0x00000010433b7824ULL, 0x100fe200078e020cULL,
0xfffffffc40517812ULL, 0x000fe200078ee20bULL, 0x000000104f3d7824ULL, 0x000fe200078e020cULL,
0x0000000010357faeULL, 0x0003e4000b901c46ULL, 0x0000000c513f7211ULL, 0x000fe400078e20ffULL,
0x0000000012377faeULL, 0x0003e8000b901c46ULL, 0x00000000183b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a3d7faeULL, 0x0003e8000b901c46ULL, 0x00000000383f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000040a107810ULL, 0x002fc40007ffe0ffULL,
0x000030006a6a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000710107812ULL, 0x100fe400078e780dULL,
0x000000060a147810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e026aULL,
0x0000006a73137211ULL, 0x080fe200078e20ffULL, 0x000000200d107824ULL, 0x000fe200078e0210ULL,
0x0000000714147812ULL, 0x000fe200078e780dULL, 0x000000104b117824ULL, 0x100fe200078e026aULL,
0x0000006a6f167211ULL, 0x080fe200078e20ffULL, 0x0000001010487824ULL, 0x000fe200078e00ffULL,
0x0000006a49107211ULL, 0x000fe200078e20ffULL, 0x000000104d127824ULL, 0x000fc400078e026aULL,
0x000000200d147824ULL, 0x000fe400078e0214ULL, 0x0000001015157824ULL, 0x000fe400078e026aULL,
0x0000001014347824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000f5c783bULL, 0x000fe20000000200ULL, 0x0000001071147824ULL, 0x000fc600078e026aULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x000000001058783bULL, 0x000ea80000000200ULL,
0x000000001150783bULL, 0x000ee80000000200ULL, 0x00000000124c783bULL, 0x000f280000000200ULL,
0x000000001340783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x00000000143c783bULL, 0x000f280000000200ULL, 0x000000001538783bULL, 0x000f280000000200ULL,
0x000000001618783bULL, 0x000f220000000200ULL, 0x0000005c482c723cULL, 0x042ff0000000182cULL,
0x000000584854723cULL, 0x044ff00000001854ULL, 0x00000050481c723cULL, 0x048ff0000000181cULL,
0x0000005e4844723cULL, 0x040ff00000001844ULL, 0x0000005a4830723cULL, 0x040ff00000001830ULL,
0x000000524828723cULL, 0x040ff00000001828ULL, 0x0000004c4824723cULL, 0x050ff00000001824ULL,
0x0000004e4820723cULL, 0x000ff00000001820ULL, 0x00000040342c723cULL, 0x060ff0000000182cULL,
0x0000003c3454723cULL, 0x040ff00000001854ULL, 0x00000038341c723cULL, 0x040ff0000000181cULL,
0x000000423440723cULL, 0x040ff00000001844ULL, 0x0000003e343c723cULL, 0x040ff00000001830ULL,
0x0000003a3438723cULL, 0x040ff00000001828ULL, 0x000000183424723cULL, 0x040ff00000001824ULL,
0x0000001a3434723cULL, 0x000fe20000001820ULL, 0x000004c000008947ULL, 0x000fee0003800000ULL,
0x00000002ff227819ULL, 0x000fe20000011604ULL, 0x0000000117207824ULL, 0x000fe200078e0a08ULL,
0x0000000c6c317812ULL, 0x000fe200078efcffULL, 0x000000106d6d7824ULL, 0x000fe200078e026aULL,
0x0000000822197810ULL, 0x040fe20007ffe0ffULL, 0x0000000122187824ULL, 0x040fe200078e0269ULL,
0x000000202200720cULL, 0x000fc40003f26070ULL, 0x0000000219287819ULL, 0x040fe200000006ffULL,
0x00000001191a7824ULL, 0x040fe200078e0269ULL, 0x000000201900720cULL, 0x000fe20003f46070ULL,
0x00005e0018187625ULL, 0x080fe200078e0009ULL, 0xfffffffc28217812ULL, 0x000fe400078ee20bULL,
0x0000001022237810ULL, 0x000fe20007ffe0ffULL, 0x00005e001a1a7625ULL, 0x000fe200078e0009ULL,
0x0000001822307810ULL, 0x040fe40007ffe0ffULL, 0x0000002022327810ULL, 0x040fe20007ffe0ffULL,
0x0000001031187825ULL, 0x000fe200078e0018ULL, 0x0000002822447810ULL, 0x000fc40007ffe0ffULL,
0x0000003022457810ULL, 0x040fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e026aULL,
0x0000003822467810ULL, 0x000fe20007ffe0ffULL, 0x00000010311a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000186d7faeULL, 0x0003e2000c901c46ULL,
0x000000202300720cULL, 0x0c0fe40003f26070ULL, 0x000000203200720cULL, 0x080fe20003f66070ULL,
0x000000001a217faeULL, 0x0005e2000d101c46ULL, 0x000000203000720cULL, 0x080fe20003f46070ULL,
0x0000000123227824ULL, 0x100fe200078e0269ULL, 0x000000204400720cULL, 0x080fe20003f86070ULL,
0x00000001462a7824ULL, 0x000fe200078e0269ULL, 0x000000204500720cULL, 0x000fc40003fa6070ULL,
0x000000204600720cULL, 0x000fe20003fc6070ULL, 0x0000000130187824ULL, 0x102fe200078e0269ULL,
0x0000006945287210ULL, 0x000fe20007ffe0ffULL, 0x0000000144207824ULL, 0x100fe200078e0269ULL,
0x0000000223487819ULL, 0x000fe200000006ffULL, 0x00000001321a7824ULL, 0x044fe200078e0269ULL,
0x0000000232327819ULL, 0x000fe200000006ffULL, 0x00005e0022227625ULL, 0x000fe200078e0009ULL,
0xfffffffc48337812ULL, 0x000fc600078ee20bULL, 0x00005e0018187625ULL, 0x000fc800078e0009ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0009ULL, 0x00005e0020207625ULL, 0x000fc800078e0009ULL,
0x00005e0028287625ULL, 0x000fc800078e0009ULL, 0x00005e002a2a7625ULL, 0x000fc800078e0009ULL,
0x0000000430307824ULL, 0x000fe400078e00ffULL, 0x0000000444447824ULL, 0x000fe400078e00ffULL,
0x0000000445487824ULL, 0x000fe200078e00ffULL, 0xfffffffc32457812ULL, 0x100fe200078ee20bULL,
0x0000001033337824ULL, 0x000fe200078e026aULL, 0xfffffffc44477812ULL, 0x000fe200078ee20bULL,
0x0000001031227825ULL, 0x000fe200078e0022ULL, 0xfffffffc48497812ULL, 0x000fc600078ee20bULL,
0x0000001031187825ULL, 0x040fe200078e0018ULL, 0x0000000022337faeULL, 0x0003e6000c901c46ULL,
0x00000010311a7825ULL, 0x000fc800078e001aULL, 0x0000001031207825ULL, 0x000fc800078e0020ULL,
0x0000001031287825ULL, 0x000fc800078e0028ULL, 0x00000010312a7825ULL, 0x000fe200078e002aULL,
0xfffffffc30317812ULL, 0x000fc600078ee20bULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x0000006a31237211ULL, 0x082fe200078e20ffULL, 0x0000001045317824ULL, 0x100fe400078e026aULL,
0x0000001047337824ULL, 0x100fe200078e026aULL, 0xfffffffc464b7812ULL, 0x000fe200078ee20bULL,
0x0000001049457824ULL, 0x000fe200078e026aULL, 0x0000000018237faeULL, 0x0003e4000d101c46ULL,
0x0000006a4b477211ULL, 0x000fe400078e20ffULL, 0x000000001a317faeULL, 0x0003e8000d901c46ULL,
0x0000000020337faeULL, 0x0003e8000e101c46ULL, 0x0000000028457faeULL, 0x0003e8000e901c46ULL,
0x000000002a477faeULL, 0x0003e2000f101c46ULL, 0x0000041000007947ULL, 0x000fea0003800000ULL,
0x0000006904187211ULL, 0x000fe200078ff0ffULL, 0x000000106d6d7824ULL, 0x000fe200078e026aULL,
0x0000000c6c477812ULL, 0x000fc400078efcffULL, 0x00000008041a7811ULL, 0x000fe200078ff0ffULL,
0x00005e0018187625ULL, 0x000fe200078e0009ULL, 0x0000001004207811ULL, 0x040fe400078ff0ffULL,
0x0000001804327811ULL, 0x000fe200078ff0ffULL, 0x000000011a287824ULL, 0x000fe200078e0269ULL,
0x0000002004447811ULL, 0x040fe200078ff0ffULL, 0x0000001047187825ULL, 0x000fe200078e0018ULL,
0x0000002804467811ULL, 0x040fe400078ff0ffULL, 0x0000003004487811ULL, 0x000fe200078ff0ffULL,
0x000000041a4e7824ULL, 0x000fe200078e00ffULL, 0x00000038044a7811ULL, 0x000fe200078ff0ffULL,
0x0000000420507824ULL, 0x040fe200078e00ffULL, 0x00000069202a7210ULL, 0x080fe20007ffe0ffULL,
0x00000001321a7824ULL, 0x100fe200078e0269ULL, 0x0000006946227210ULL, 0x000fe20007ffe0ffULL,
0x0000000144207824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000186d7faeULL, 0x0003e2000b901c46ULL, 0x0000000148307824ULL, 0x000fe200078e0269ULL,
0xfffffffc4e337812ULL, 0x000fe200078ee20bULL, 0x000000014a4c7824ULL, 0x000fe200078e0269ULL,
0xfffffffc50457812ULL, 0x000fe200078ee20bULL, 0x00005e0028287625ULL, 0x000fe200078e0009ULL,
0x0000000248487819ULL, 0x000fc400000006ffULL, 0x0000006a45457211ULL, 0x000fe200078e20ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0009ULL, 0xfffffffc484d7812ULL, 0x000fc600078ee20bULL,
0x00005e001a187625ULL, 0x002fc800078e0009ULL, 0x00005e00201a7625ULL, 0x000fc800078e0009ULL,
0x00005e0022207625ULL, 0x000fc800078e0009ULL, 0x00005e0030227625ULL, 0x000fc800078e0009ULL,
0x00005e004c307625ULL, 0x000fc800078e0009ULL, 0x0000000432327824ULL, 0x000fe400078e00ffULL,
0x0000000444447824ULL, 0x000fe400078e00ffULL, 0x0000000446467824ULL, 0x000fe400078e00ffULL,
0x0000001033337824ULL, 0x000fe200078e026aULL, 0xfffffffc44497812ULL, 0x000fe200078ee20bULL,
0x0000001047287825ULL, 0x000fe200078e0028ULL, 0xfffffffc464b7812ULL, 0x000fc600078ee20bULL,
0x00000010472a7825ULL, 0x040fe200078e002aULL, 0x0000000028337faeULL, 0x0003e6000b901c46ULL,
0x0000001047187825ULL, 0x040fe200078e0018ULL, 0x000000002a457faeULL, 0x0005e6000b901c46ULL,
0x00000010471a7825ULL, 0x000fc800078e001aULL, 0x0000001047207825ULL, 0x000fe200078e0020ULL,
0x0000006a4b337211ULL, 0x002fc600078e20ffULL, 0x0000001047227825ULL, 0x000fc800078e0022ULL,
0x0000001047307825ULL, 0x000fe200078e0030ULL, 0xfffffffc32477812ULL, 0x000fc600078ee20bULL,
0x000000044a4a7824ULL, 0x000fe400078e00ffULL, 0x0000001047297824ULL, 0x100fe400078e026aULL,
0x00000010492b7824ULL, 0x104fe200078e026aULL, 0xfffffffc4a4f7812ULL, 0x000fe200078ee20bULL,
0x000000104d457824ULL, 0x100fe200078e026aULL, 0x0000000018297faeULL, 0x0003e6000b901c46ULL,
0x000000104f477824ULL, 0x000fe200078e026aULL, 0x000000001a2b7faeULL, 0x0003e8000b901c46ULL,
0x0000000020337faeULL, 0x0003e8000b901c46ULL, 0x0000000022457faeULL, 0x0003e8000b901c46ULL,
0x0000000030477faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000080a187810ULL, 0x002fc80007ffe0ffULL, 0x0000000718187812ULL, 0x000fca00078e780dULL,
0x000000200d187824ULL, 0x000fca00078e0218ULL, 0x0000000418447819ULL, 0x000fe400000006ffULL,
0x0000000a0a187810ULL, 0x000fc80007ffe0ffULL, 0x0000000718187812ULL, 0x000fe200078e780dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006b5c783bULL, 0x000fe20000000200ULL,
0x000000200d187824ULL, 0x000fc600078e0218ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001018287824ULL, 0x000fc600078e00ffULL, 0x000000006850783bULL, 0x000ea80000000200ULL,
0x00000000674c783bULL, 0x000ee80000000200ULL, 0x000000006648783bULL, 0x000f280000000200ULL,
0x000000006558783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000006418783bULL, 0x000f280000000200ULL, 0x000000006320783bULL, 0x000f280000000200ULL,
0x000000006230783bULL, 0x000f220000000200ULL, 0x0000005c442c723cULL, 0x042ff0000000182cULL,
0x000000504454723cULL, 0x044ff00000001854ULL, 0x0000004c441c723cULL, 0x048ff0000000181cULL,
0x0000005e4440723cULL, 0x040ff00000001840ULL, 0x00000052443c723cULL, 0x040ff0000000183cULL,
0x0000004e4438723cULL, 0x040ff00000001838ULL, 0x000000484424723cULL, 0x050ff00000001824ULL,
0x0000004a4434723cULL, 0x000ff00000001834ULL, 0x00000058282c723cULL, 0x060ff0000000182cULL,
0x000000182854723cULL, 0x040ff00000001854ULL, 0x00000020281c723cULL, 0x040ff0000000181cULL,
0x0000005a2858723cULL, 0x040ff00000001840ULL, 0x0000001a2818723cULL, 0x040ff0000000183cULL,
0x000000222820723cULL, 0x040ff00000001838ULL, 0x000000302824723cULL, 0x040ff00000001824ULL,
0x000000322828723cULL, 0x000fe20000001834ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff357819ULL, 0x000fe20000011604ULL, 0x0000000117347824ULL, 0x000fe200078e0a08ULL,
0x000000106c3d7812ULL, 0x000fc400078efcffULL, 0x0000000835317810ULL, 0x040fe40007ffe0ffULL,
0x0000006935307210ULL, 0x040fe40007ffe0ffULL, 0x000000343500720cULL, 0x080fe20003f26070ULL,
0x0000000131327824ULL, 0x040fe200078e0269ULL, 0x000000343100720cULL, 0x040fe20003f46070ULL,
0x0000000431367824ULL, 0x000fe200078e00ffULL, 0x00000018353c7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0030307625ULL, 0x000fe200078e0009ULL, 0x00000020353e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc36377812ULL, 0x000fe200078ee20bULL, 0x00005e0032327625ULL, 0x000fe200078e0009ULL,
0x0000001035367810ULL, 0x040fe40007ffe0ffULL, 0x0000002835407810ULL, 0x000fe20007ffe0ffULL,
0x000000103d307825ULL, 0x000fe200078e0030ULL, 0x0000003035417810ULL, 0x040fe40007ffe0ffULL,
0x0000003835427810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300e7faeULL, 0x0003e2000c901c46ULL,
0x000000103d327825ULL, 0x000fe200078e0032ULL, 0x000000343600720cULL, 0x000fc40003f26070ULL,
0x000000343e00720cULL, 0x080fe20003f66070ULL, 0x00000001413a7824ULL, 0x140fe200078e0269ULL,
0x0000000032377faeULL, 0x0005e2000d101c46ULL, 0x000000343c00720cULL, 0x080fe20003f46070ULL,
0x0000000142447824ULL, 0x100fe200078e0269ULL, 0x000000344000720cULL, 0x080fe40003f86070ULL,
0x000000344100720cULL, 0x080fe40003fa6070ULL, 0x0000006936307210ULL, 0x0c2fe20007ffe0ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x000000344200720cULL, 0x000fe20003fc6070ULL,
0x000000013e347824ULL, 0x100fe200078e0269ULL, 0x0000006940387210ULL, 0x000fe20007ffe0ffULL,
0x000000013c327824ULL, 0x004fe200078e0269ULL, 0xfffffffc363f7812ULL, 0x000fe200078ee20bULL,
0x00005e0030367625ULL, 0x000fe200078e0009ULL, 0x000000023c3c7819ULL, 0x000fc400000006ffULL,
0x0000000242427819ULL, 0x000fe200000006ffULL, 0x00005e0032307625ULL, 0x000fc600078e0009ULL,
0xfffffffc42477812ULL, 0x000fe200078ee20bULL, 0x00005e0034327625ULL, 0x000fc800078e0009ULL,
0x00005e0038347625ULL, 0x000fc800078e0009ULL, 0x00005e003a387625ULL, 0x000fc800078e0009ULL,
0x00005e00443a7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x000000103d367825ULL, 0x000fc600078e0036ULL,
0xfffffffc40437812ULL, 0x000fe200078ee20bULL, 0x000000103d307825ULL, 0x000fc800078e0030ULL,
0x000000103d327825ULL, 0x000fc800078e0032ULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d3a7825ULL, 0x000fe200078e003aULL,
0xfffffffc3c3d7812ULL, 0x000fc600078ee20bULL, 0x0000000441447824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e417812ULL, 0x100fe200078ee20bULL, 0x000000103f3f7824ULL, 0x100fe400078e020cULL,
0x000000103d3d7824ULL, 0x100fe200078e020cULL, 0xfffffffc44457812ULL, 0x000fe200078ee20bULL,
0x0000001041417824ULL, 0x100fe200078e020cULL, 0x00000000363f7faeULL, 0x0003e2000c901c46ULL,
0x0000001043437824ULL, 0x100fe200078e020cULL, 0x0000000c45457211ULL, 0x000fe200078e20ffULL,
0x0000001047477824ULL, 0x000fe200078e020cULL, 0x00000000303d7faeULL, 0x0003e8000d101c46ULL,
0x0000000032417faeULL, 0x0003e8000d901c46ULL, 0x0000000034437faeULL, 0x0003e8000e101c46ULL,
0x0000000038457faeULL, 0x0003e8000e901c46ULL, 0x000000003a477faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x0000006904307211ULL, 0x000fe400078ff0ffULL,
0x000000106c3f7812ULL, 0x000fc400078efcffULL, 0x0000000804327811ULL, 0x000fe200078ff0ffULL,
0x00005e0030307625ULL, 0x000fe200078e0009ULL, 0x0000001004347811ULL, 0x040fe400078ff0ffULL,
0x00000018043e7811ULL, 0x000fe200078ff0ffULL, 0x0000000132387824ULL, 0x000fe200078e0269ULL,
0x0000002004407811ULL, 0x040fe200078ff0ffULL, 0x000000103f307825ULL, 0x000fe200078e0030ULL,
0x0000002804427811ULL, 0x040fe400078ff0ffULL, 0x0000003004447811ULL, 0x000fe200078ff0ffULL,
0x00000004324a7824ULL, 0x000fe200078e00ffULL, 0x0000003804467811ULL, 0x000fe200078ff0ffULL,
0x00000004344c7824ULL, 0x040fe200078e00ffULL, 0x00000069343a7210ULL, 0x080fe20007ffe0ffULL,
0x000000013e327824ULL, 0x100fe200078e0269ULL, 0x0000006942367210ULL, 0x000fe20007ffe0ffULL,
0x0000000140347824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000300e7faeULL, 0x0003e2000b901c46ULL, 0x00000001443c7824ULL, 0x000fe200078e0269ULL,
0xfffffffc4a417812ULL, 0x000fe200078ee20bULL, 0x0000000146487824ULL, 0x000fe200078e0269ULL,
0x0000000244447819ULL, 0x000fe200000006ffULL, 0x00005e0038387625ULL, 0x000fe200078e0009ULL,
0xfffffffc4c437812ULL, 0x000fc400078ee20bULL, 0xfffffffc44497812ULL, 0x000fe200078ee20bULL,
0x00005e003a3a7625ULL, 0x000fe200078e0009ULL, 0x0000000c43437211ULL, 0x000fc600078e20ffULL,
0x00005e0032307625ULL, 0x002fc800078e0009ULL, 0x00005e0034327625ULL, 0x000fc800078e0009ULL,
0x00005e0036347625ULL, 0x000fc800078e0009ULL, 0x00005e003c367625ULL, 0x000fc800078e0009ULL,
0x00005e00483c7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000001041417824ULL, 0x000fe400078e020cULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0xfffffffc40457812ULL, 0x000fc600078ee20bULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000038417faeULL, 0x0003e2000b901c46ULL,
0x000000103f3a7825ULL, 0x000fc600078e003aULL, 0xfffffffc42477812ULL, 0x000fe200078ee20bULL,
0x000000103f307825ULL, 0x000fe200078e0030ULL, 0x000000003a437faeULL, 0x0005e4000b901c46ULL,
0x0000000c47477211ULL, 0x000fe200078e20ffULL, 0x000000103f327825ULL, 0x000fc800078e0032ULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f3c7825ULL, 0x000fe200078e003cULL, 0xfffffffc3e3f7812ULL, 0x000fc600078ee20bULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x000000103f3f7824ULL, 0x100fe400078e020cULL,
0x0000001045457824ULL, 0x100fe200078e020cULL, 0xfffffffc46397812ULL, 0x002fe200078ee20bULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x00000000303f7faeULL, 0x0005e6000b901c46ULL,
0x0000001039397824ULL, 0x000fe200078e020cULL, 0x0000000032457faeULL, 0x0005e8000b901c46ULL,
0x0000000034477faeULL, 0x0005e8000b901c46ULL, 0x0000000036497faeULL, 0x0005e8000b901c46ULL,
0x000000003c397faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c0a307810ULL, 0x006fc80007ffe0ffULL, 0x0000000730307812ULL, 0x000fca00078e780dULL,
0x000000200d307824ULL, 0x000fca00078e0230ULL, 0x0000000430447819ULL, 0x000fe400000006ffULL,
0x0000000e0a307810ULL, 0x000fc80007ffe0ffULL, 0x0000000730307812ULL, 0x000fe200078e780dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000f5c783bULL, 0x000fe20000000200ULL,
0x000000200d307824ULL, 0x000fc600078e0230ULL, 0x000000004444783bULL, 0x000e620000000200ULL,
0x0000001030307824ULL, 0x000fc600078e00ffULL, 0x000000001050783bULL, 0x000ea80000000200ULL,
0x00000000114c783bULL, 0x000ee80000000200ULL, 0x000000001248783bULL, 0x000f280000000200ULL,
0x000000001340783bULL, 0x000fe80000000200ULL, 0x000000003030783bULL, 0x000f680000000200ULL,
0x00000000143c783bULL, 0x000ee80000000200ULL, 0x000000001538783bULL, 0x000ee80000000200ULL,
0x000000001634783bULL, 0x000ee20000000200ULL, 0x0000005c442c723cULL, 0x042ff0000000182cULL,
0x0000005e4458723cULL, 0x040ff00000001858ULL, 0x000000504454723cULL, 0x044ff00000001854ULL,
0x000000524418723cULL, 0x040ff00000001818ULL, 0x0000004c441c723cULL, 0x048ff0000000181cULL,
0x0000004e4420723cULL, 0x040ff00000001820ULL, 0x000000484424723cULL, 0x050ff00000001824ULL,
0x0000004a4428723cULL, 0x000ff00000001828ULL, 0x00000040302c723cULL, 0x060ff0000000182cULL,
0x000000423058723cULL, 0x040ff00000001858ULL, 0x0000003c3054723cULL, 0x040ff00000001854ULL,
0x0000003e3018723cULL, 0x040ff00000001818ULL, 0x00000038301c723cULL, 0x040ff0000000181cULL,
0x0000003a3020723cULL, 0x040ff00000001820ULL, 0x000000343024723cULL, 0x040ff00000001824ULL,
0x000000363030723cULL, 0x000fe20000001828ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff357819ULL, 0x000fe20000011604ULL, 0x0000000117347824ULL, 0x000fe200078e0a08ULL,
0x000000146c3d7812ULL, 0x000fc400078efcffULL, 0x0000000835297810ULL, 0x040fe40007ffe0ffULL,
0x0000006935287210ULL, 0x040fe40007ffe0ffULL, 0x000000343500720cULL, 0x080fe20003f26070ULL,
0x00000001292a7824ULL, 0x040fe200078e0269ULL, 0x000000342900720cULL, 0x040fe20003f46070ULL,
0x0000000429367824ULL, 0x000fe200078e00ffULL, 0x00000018353c7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x00000020353e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc36377812ULL, 0x000fe200078ee20bULL, 0x00005e002a2a7625ULL, 0x000fe200078e0009ULL,
0x0000001035367810ULL, 0x040fe40007ffe0ffULL, 0x0000002835407810ULL, 0x000fe20007ffe0ffULL,
0x000000103d287825ULL, 0x000fe200078e0028ULL, 0x0000003035417810ULL, 0x040fe40007ffe0ffULL,
0x0000003835427810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e026aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286d7faeULL, 0x0003e2000c901c46ULL,
0x000000103d2a7825ULL, 0x000fe200078e002aULL, 0x000000343600720cULL, 0x000fc40003f26070ULL,
0x000000343e00720cULL, 0x080fe20003f66070ULL, 0x00000001413a7824ULL, 0x140fe200078e0269ULL,
0x000000002a377faeULL, 0x0005e2000d101c46ULL, 0x000000343c00720cULL, 0x080fe20003f46070ULL,
0x0000000142447824ULL, 0x100fe200078e0269ULL, 0x000000344000720cULL, 0x080fe40003f86070ULL,
0x000000344100720cULL, 0x080fe40003fa6070ULL, 0x0000006936287210ULL, 0x0c2fe20007ffe0ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x000000344200720cULL, 0x000fe20003fc6070ULL,
0x000000013e347824ULL, 0x100fe200078e0269ULL, 0x0000006940387210ULL, 0x000fe20007ffe0ffULL,
0x000000013c2a7824ULL, 0x004fe200078e0269ULL, 0xfffffffc363f7812ULL, 0x000fe200078ee20bULL,
0x00005e0028367625ULL, 0x000fe200078e0009ULL, 0x000000023c3c7819ULL, 0x000fc400000006ffULL,
0x0000000242427819ULL, 0x000fe200000006ffULL, 0x00005e002a287625ULL, 0x000fc600078e0009ULL,
0xfffffffc42477812ULL, 0x000fe200078ee20bULL, 0x00005e00342a7625ULL, 0x000fc800078e0009ULL,
0x00005e0038347625ULL, 0x000fc800078e0009ULL, 0x00005e003a387625ULL, 0x000fc800078e0009ULL,
0x00005e00443a7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x000000103d367825ULL, 0x000fc600078e0036ULL,
0xfffffffc40437812ULL, 0x000fe200078ee20bULL, 0x000000103d287825ULL, 0x000fc800078e0028ULL,
0x000000103d2a7825ULL, 0x000fc800078e002aULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d3a7825ULL, 0x000fe200078e003aULL,
0xfffffffc3c3d7812ULL, 0x000fc600078ee20bULL, 0x0000000441447824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e417812ULL, 0x100fe200078ee20bULL, 0x000000103f3f7824ULL, 0x100fe400078e026aULL,
0x000000103d3d7824ULL, 0x100fe200078e026aULL, 0xfffffffc44457812ULL, 0x000fe200078ee20bULL,
0x0000001041417824ULL, 0x100fe200078e026aULL, 0x00000000363f7faeULL, 0x0003e2000c901c46ULL,
0x0000001043437824ULL, 0x100fe200078e026aULL, 0x0000006a45457211ULL, 0x000fe200078e20ffULL,
0x0000001047477824ULL, 0x000fe200078e026aULL, 0x00000000283d7faeULL, 0x0003e8000d101c46ULL,
0x000000002a417faeULL, 0x0003e8000d901c46ULL, 0x0000000034437faeULL, 0x0003e8000e101c46ULL,
0x0000000038457faeULL, 0x0003e8000e901c46ULL, 0x000000003a477faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x0000006904287211ULL, 0x000fe400078ff0ffULL,
0x000000146c3f7812ULL, 0x000fc400078efcffULL, 0x00000008042a7811ULL, 0x000fe200078ff0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x0000001004347811ULL, 0x040fe400078ff0ffULL,
0x00000018043e7811ULL, 0x000fe200078ff0ffULL, 0x000000012a387824ULL, 0x000fe200078e0269ULL,
0x0000002004407811ULL, 0x040fe200078ff0ffULL, 0x000000103f287825ULL, 0x000fe200078e0028ULL,
0x0000002804427811ULL, 0x040fe400078ff0ffULL, 0x0000003004447811ULL, 0x000fe200078ff0ffULL,
0x000000042a4a7824ULL, 0x000fe200078e00ffULL, 0x0000003804467811ULL, 0x000fe200078ff0ffULL,
0x00000004344c7824ULL, 0x040fe200078e00ffULL, 0x00000069343a7210ULL, 0x080fe20007ffe0ffULL,
0x000000013e2a7824ULL, 0x100fe200078e0269ULL, 0x0000006942367210ULL, 0x000fe20007ffe0ffULL,
0x0000000140347824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286d7faeULL, 0x0003e2000b901c46ULL, 0x00000001443c7824ULL, 0x000fe200078e0269ULL,
0xfffffffc4a417812ULL, 0x000fe200078ee20bULL, 0x0000000146487824ULL, 0x000fe200078e0269ULL,
0x0000000244447819ULL, 0x000fe200000006ffULL, 0x00005e0038387625ULL, 0x000fe200078e0009ULL,
0xfffffffc4c437812ULL, 0x000fc400078ee20bULL, 0xfffffffc44497812ULL, 0x000fe200078ee20bULL,
0x00005e003a3a7625ULL, 0x000fe200078e0009ULL, 0x0000006a43437211ULL, 0x000fc600078e20ffULL,
0x00005e002a287625ULL, 0x002fc800078e0009ULL, 0x00005e00342a7625ULL, 0x000fc800078e0009ULL,
0x00005e0036347625ULL, 0x000fc800078e0009ULL, 0x00005e003c367625ULL, 0x000fc800078e0009ULL,
0x00005e00483c7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000001041417824ULL, 0x000fe400078e026aULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0xfffffffc40457812ULL, 0x000fc600078ee20bULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000038417faeULL, 0x0003e2000b901c46ULL,
0x000000103f3a7825ULL, 0x000fc600078e003aULL, 0xfffffffc42477812ULL, 0x000fe200078ee20bULL,
0x000000103f287825ULL, 0x000fe200078e0028ULL, 0x000000003a437faeULL, 0x0005e4000b901c46ULL,
0x0000006a47477211ULL, 0x000fe200078e20ffULL, 0x000000103f2a7825ULL, 0x000fc800078e002aULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f3c7825ULL, 0x000fe200078e003cULL, 0xfffffffc3e3f7812ULL, 0x000fc600078ee20bULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x000000103f3f7824ULL, 0x100fe400078e026aULL,
0x0000001045457824ULL, 0x100fe200078e026aULL, 0xfffffffc46397812ULL, 0x002fe200078ee20bULL,
0x0000001049497824ULL, 0x100fe200078e026aULL, 0x00000000283f7faeULL, 0x0005e6000b901c46ULL,
0x0000001039397824ULL, 0x000fe200078e026aULL, 0x000000002a457faeULL, 0x0005e8000b901c46ULL,
0x0000000034477faeULL, 0x0005e8000b901c46ULL, 0x0000000036497faeULL, 0x0005e8000b901c46ULL,
0x000000003c397faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a287810ULL, 0x006fc40007ffe0ffULL, 0x000000120a347810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e780dULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x000000200d287824ULL, 0x040fe400078e0228ULL, 0x000000200d347824ULL, 0x000fc600078e0234ULL,
0x0000000428487819ULL, 0x000fe200000006ffULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006b28783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x00000000685c783bULL, 0x000ea80000000200ULL,
0x000000006750783bULL, 0x000ee80000000200ULL, 0x00000000664c783bULL, 0x000f280000000200ULL,
0x000000006544783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000006440783bULL, 0x000ee80000000200ULL, 0x00000000633c783bULL, 0x000ee80000000200ULL,
0x000000006238783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042ff0000000182cULL,
0x0000002a4858723cULL, 0x040ff00000001858ULL, 0x0000005c4854723cULL, 0x044ff00000001854ULL,
0x0000005e4818723cULL, 0x040ff00000001818ULL, 0x00000050481c723cULL, 0x048ff0000000181cULL,
0x000000524820723cULL, 0x040ff00000001820ULL, 0x0000004c4824723cULL, 0x050ff00000001824ULL,
0x0000004e4830723cULL, 0x000ff00000001830ULL, 0x00000044342c723cULL, 0x060ff0000000182cULL,
0x000000463458723cULL, 0x040ff00000001858ULL, 0x000000403454723cULL, 0x040ff00000001854ULL,
0x000000423418723cULL, 0x040ff00000001818ULL, 0x0000003c341c723cULL, 0x040ff0000000181cULL,
0x0000003e3420723cULL, 0x040ff00000001820ULL, 0x000000383424723cULL, 0x040ff00000001824ULL,
0x0000003a3430723cULL, 0x000fe20000001830ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff357819ULL, 0x000fe20000011604ULL, 0x0000000117347824ULL, 0x000fe200078e0a08ULL,
0x000000186c3d7812ULL, 0x000fc400078efcffULL, 0x0000000835297810ULL, 0x040fe40007ffe0ffULL,
0x0000006935287210ULL, 0x040fe40007ffe0ffULL, 0x000000343500720cULL, 0x080fe20003f26070ULL,
0x00000001292a7824ULL, 0x040fe200078e0269ULL, 0x000000342900720cULL, 0x040fe20003f46070ULL,
0x0000000429367824ULL, 0x000fe200078e00ffULL, 0x00000018353c7810ULL, 0x040fe20007ffe0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x00000020353e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffffc36377812ULL, 0x000fe200078ee20bULL, 0x00005e002a2a7625ULL, 0x000fe200078e0009ULL,
0x0000001035367810ULL, 0x040fe40007ffe0ffULL, 0x0000002835407810ULL, 0x000fe20007ffe0ffULL,
0x000000103d287825ULL, 0x000fe200078e0028ULL, 0x0000003035417810ULL, 0x040fe40007ffe0ffULL,
0x0000003835427810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000280e7faeULL, 0x0003e2000c901c46ULL,
0x000000103d2a7825ULL, 0x000fe200078e002aULL, 0x000000343600720cULL, 0x000fc40003f26070ULL,
0x000000343e00720cULL, 0x080fe20003f66070ULL, 0x00000001413a7824ULL, 0x140fe200078e0269ULL,
0x000000002a377faeULL, 0x0005e2000d101c46ULL, 0x000000343c00720cULL, 0x080fe20003f46070ULL,
0x0000000142447824ULL, 0x100fe200078e0269ULL, 0x000000344000720cULL, 0x080fe40003f86070ULL,
0x000000344100720cULL, 0x080fe40003fa6070ULL, 0x0000006936287210ULL, 0x0c2fe20007ffe0ffULL,
0x0000000436367824ULL, 0x000fe200078e00ffULL, 0x000000344200720cULL, 0x000fe20003fc6070ULL,
0x000000013e347824ULL, 0x100fe200078e0269ULL, 0x0000006940387210ULL, 0x000fe20007ffe0ffULL,
0x000000013c2a7824ULL, 0x004fe200078e0269ULL, 0xfffffffc363f7812ULL, 0x000fe200078ee20bULL,
0x00005e0028367625ULL, 0x000fe200078e0009ULL, 0x000000023c3c7819ULL, 0x000fc400000006ffULL,
0x0000000242427819ULL, 0x000fe200000006ffULL, 0x00005e002a287625ULL, 0x000fc600078e0009ULL,
0xfffffffc42477812ULL, 0x000fe200078ee20bULL, 0x00005e00342a7625ULL, 0x000fc800078e0009ULL,
0x00005e0038347625ULL, 0x000fc800078e0009ULL, 0x00005e003a387625ULL, 0x000fc800078e0009ULL,
0x00005e00443a7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x000000103d367825ULL, 0x000fc600078e0036ULL,
0xfffffffc40437812ULL, 0x000fe200078ee20bULL, 0x000000103d287825ULL, 0x000fc800078e0028ULL,
0x000000103d2a7825ULL, 0x000fc800078e002aULL, 0x000000103d347825ULL, 0x000fc800078e0034ULL,
0x000000103d387825ULL, 0x000fc800078e0038ULL, 0x000000103d3a7825ULL, 0x000fe200078e003aULL,
0xfffffffc3c3d7812ULL, 0x000fc600078ee20bULL, 0x0000000441447824ULL, 0x000fe200078e00ffULL,
0xfffffffc3e417812ULL, 0x100fe200078ee20bULL, 0x000000103f3f7824ULL, 0x100fe400078e020cULL,
0x000000103d3d7824ULL, 0x100fe200078e020cULL, 0xfffffffc44457812ULL, 0x000fe200078ee20bULL,
0x0000001041417824ULL, 0x100fe200078e020cULL, 0x00000000363f7faeULL, 0x0003e2000c901c46ULL,
0x0000001043437824ULL, 0x100fe200078e020cULL, 0x0000000c45457211ULL, 0x000fe200078e20ffULL,
0x0000001047477824ULL, 0x000fe200078e020cULL, 0x00000000283d7faeULL, 0x0003e8000d101c46ULL,
0x000000002a417faeULL, 0x0003e8000d901c46ULL, 0x0000000034437faeULL, 0x0003e8000e101c46ULL,
0x0000000038457faeULL, 0x0003e8000e901c46ULL, 0x000000003a477faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x0000006904287211ULL, 0x000fe400078ff0ffULL,
0x000000186c3f7812ULL, 0x000fc400078efcffULL, 0x00000008042a7811ULL, 0x000fe200078ff0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x0000001004347811ULL, 0x040fe400078ff0ffULL,
0x00000018043e7811ULL, 0x000fe200078ff0ffULL, 0x000000012a387824ULL, 0x000fe200078e0269ULL,
0x0000002004407811ULL, 0x040fe200078ff0ffULL, 0x000000103f287825ULL, 0x000fe200078e0028ULL,
0x0000002804427811ULL, 0x040fe400078ff0ffULL, 0x0000003004447811ULL, 0x000fe200078ff0ffULL,
0x000000042a4a7824ULL, 0x000fe200078e00ffULL, 0x0000003804467811ULL, 0x000fe200078ff0ffULL,
0x00000004344c7824ULL, 0x040fe200078e00ffULL, 0x00000069343a7210ULL, 0x080fe20007ffe0ffULL,
0x000000013e2a7824ULL, 0x100fe200078e0269ULL, 0x0000006942367210ULL, 0x000fe20007ffe0ffULL,
0x0000000140347824ULL, 0x100fe200078e0269ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000280e7faeULL, 0x0003e2000b901c46ULL, 0x00000001443c7824ULL, 0x000fe200078e0269ULL,
0xfffffffc4a417812ULL, 0x000fe200078ee20bULL, 0x0000000146487824ULL, 0x000fe200078e0269ULL,
0x0000000244447819ULL, 0x000fe200000006ffULL, 0x00005e0038387625ULL, 0x000fe200078e0009ULL,
0xfffffffc4c437812ULL, 0x000fc400078ee20bULL, 0xfffffffc44497812ULL, 0x000fe200078ee20bULL,
0x00005e003a3a7625ULL, 0x000fe200078e0009ULL, 0x0000000c43437211ULL, 0x000fc600078e20ffULL,
0x00005e002a287625ULL, 0x002fc800078e0009ULL, 0x00005e00342a7625ULL, 0x000fc800078e0009ULL,
0x00005e0036347625ULL, 0x000fc800078e0009ULL, 0x00005e003c367625ULL, 0x000fc800078e0009ULL,
0x00005e00483c7625ULL, 0x000fc800078e0009ULL, 0x000000043e3e7824ULL, 0x000fe400078e00ffULL,
0x0000000440407824ULL, 0x000fe400078e00ffULL, 0x0000001041417824ULL, 0x000fe400078e020cULL,
0x000000103f387825ULL, 0x000fe200078e0038ULL, 0xfffffffc40457812ULL, 0x000fc600078ee20bULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0x0000000038417faeULL, 0x0003e2000b901c46ULL,
0x000000103f3a7825ULL, 0x000fc600078e003aULL, 0xfffffffc42477812ULL, 0x000fe200078ee20bULL,
0x000000103f287825ULL, 0x000fe200078e0028ULL, 0x000000003a437faeULL, 0x0005e4000b901c46ULL,
0x0000000c47477211ULL, 0x000fe200078e20ffULL, 0x000000103f2a7825ULL, 0x000fc800078e002aULL,
0x000000103f347825ULL, 0x000fc800078e0034ULL, 0x000000103f367825ULL, 0x000fc800078e0036ULL,
0x000000103f3c7825ULL, 0x000fe200078e003cULL, 0xfffffffc3e3f7812ULL, 0x000fc600078ee20bULL,
0x0000000446467824ULL, 0x000fe400078e00ffULL, 0x000000103f3f7824ULL, 0x100fe400078e020cULL,
0x0000001045457824ULL, 0x100fe200078e020cULL, 0xfffffffc46397812ULL, 0x002fe200078ee20bULL,
0x0000001049497824ULL, 0x100fe200078e020cULL, 0x00000000283f7faeULL, 0x0005e6000b901c46ULL,
0x0000001039397824ULL, 0x000fe200078e020cULL, 0x000000002a457faeULL, 0x0005e8000b901c46ULL,
0x0000000034477faeULL, 0x0005e8000b901c46ULL, 0x0000000036497faeULL, 0x0005e8000b901c46ULL,
0x000000003c397faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000140a287810ULL, 0x006fc40007ffe0ffULL, 0x000000160a347810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e780dULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x000000200d287824ULL, 0x040fe400078e0228ULL, 0x000000200d347824ULL, 0x000fc600078e0234ULL,
0x0000000428487819ULL, 0x000fe200000006ffULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000f28783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x00000000105c783bULL, 0x000ea80000000200ULL,
0x000000001150783bULL, 0x000ee80000000200ULL, 0x00000000124c783bULL, 0x000f280000000200ULL,
0x000000001344783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000001440783bULL, 0x000ee80000000200ULL, 0x00000000153c783bULL, 0x000ee80000000200ULL,
0x000000001638783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042ff0000000182cULL,
0x0000002a4858723cULL, 0x040ff00000001858ULL, 0x0000005c4854723cULL, 0x044ff00000001854ULL,
0x0000005e4818723cULL, 0x040ff00000001818ULL, 0x00000050481c723cULL, 0x048ff0000000181cULL,
0x000000524820723cULL, 0x040ff00000001820ULL, 0x0000004c4824723cULL, 0x050ff00000001824ULL,
0x0000004e4830723cULL, 0x000ff00000001830ULL, 0x00000044342c723cULL, 0x060ff0000000182cULL,
0x000000463458723cULL, 0x040ff00000001858ULL, 0x000000403454723cULL, 0x040ff00000001854ULL,
0x000000423418723cULL, 0x040ff00000001818ULL, 0x0000003c341c723cULL, 0x040ff0000000181cULL,
0x0000003e3420723cULL, 0x040ff00000001820ULL, 0x000000383424723cULL, 0x040ff00000001824ULL,
0x0000003a3430723cULL, 0x000fe20000001830ULL, 0x000004b000008947ULL, 0x000fee0003800000ULL,
0x00000002ff2b7819ULL, 0x000fe20000011604ULL, 0x00000001172a7824ULL, 0x000fe200078e0a08ULL,
0x0000001c6c3f7812ULL, 0x000fc400078efcffULL, 0x000000692b287210ULL, 0x040fe40007ffe0ffULL,
0x0000002a2b00720cULL, 0x040fe40003f06070ULL, 0x000000082b347810ULL, 0x040fe20007ffe0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x000000182b367810ULL, 0x040fe40007ffe0ffULL,
0x000000282b387810ULL, 0x040fe20007ffe0ffULL, 0x0000000434407824ULL, 0x000fe200078e00ffULL,
0x000000102b357810ULL, 0x000fe20007ffe0ffULL, 0x000000103f287825ULL, 0x000fe200078e0028ULL,
0x000000202b377810ULL, 0x000fc40007ffe0ffULL, 0x000000302b397810ULL, 0x040fe20007ffe0ffULL,
0x0000000436447824ULL, 0x000fe200078e00ffULL, 0x000000382b2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001383a7824ULL, 0x140fe200078e0269ULL, 0x0000002a3800720cULL, 0x0c0fe20003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286d7faeULL, 0x0003e2000c101c46ULL,
0x0000000235427819ULL, 0x000fe200000006ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x0000000237467819ULL, 0x000fe200000006ffULL, 0x000000012b3e7824ULL, 0x140fe200078e0269ULL,
0x0000002a3400720cULL, 0x080fe20003f06070ULL, 0x000000042b4a7824ULL, 0x000fe200078e00ffULL,
0x0000002a3500720cULL, 0x080fe20003f26070ULL, 0x00000001393c7824ULL, 0x000fe200078e0269ULL,
0x0000002a3600720cULL, 0x000fc40003f46070ULL, 0x0000002a3700720cULL, 0x080fe20003f66070ULL,
0x0000000134287824ULL, 0x102fe200078e0269ULL, 0x0000002a3900720cULL, 0x080fe20003fa6070ULL,
0x0000000136347824ULL, 0x100fe200078e0269ULL, 0x0000002a2b00720cULL, 0x000fe20003fc6070ULL,
0x00000001352a7824ULL, 0x000fe200078e0269ULL, 0xfffffffc40297812ULL, 0x000fe200078ee20bULL,
0x0000000137367824ULL, 0x000fe200078e0269ULL, 0x0000000239487819ULL, 0x000fe400000006ffULL,
0xfffffffc422b7812ULL, 0x100fe200078ee20bULL, 0x0000001029417824ULL, 0x000fe200078e026aULL,
0xfffffffc44357812ULL, 0x100fe200078ee20bULL, 0x00005e0028287625ULL, 0x000fe200078e0009ULL,
0xfffffffc46377812ULL, 0x000fc400078ee20bULL, 0xfffffffc38397812ULL, 0x100fe200078ee20bULL,
0x0000001035457824ULL, 0x100fe200078e026aULL, 0xfffffffc483b7812ULL, 0x100fe200078ee20bULL,
0x0000001037477824ULL, 0x000fe200078e026aULL, 0xfffffffc4a3d7812ULL, 0x000fe200078ee20bULL,
0x00005e0034347625ULL, 0x080fe200078e0009ULL, 0x0000006a2b437211ULL, 0x080fe400078e20ffULL,
0x0000006a3b4b7211ULL, 0x000fe200078e20ffULL, 0x00005e002a2a7625ULL, 0x000fc800078e0009ULL,
0x0000001039497824ULL, 0x000fe400078e026aULL, 0x00005e0036367625ULL, 0x000fc800078e0009ULL,
0x00005e003a387625ULL, 0x000fc800078e0009ULL, 0x000000103d4d7824ULL, 0x000fe400078e026aULL,
0x00005e003c3a7625ULL, 0x000fc800078e0009ULL, 0x00005e003e3c7625ULL, 0x000fc800078e0009ULL,
0x000000103f287825ULL, 0x000fc800078e0028ULL, 0x000000103f2a7825ULL, 0x040fe200078e002aULL,
0x0000000028417faeULL, 0x0003e6000c101c46ULL, 0x000000103f347825ULL, 0x040fe200078e0034ULL,
0x000000002a437faeULL, 0x0003e6000c901c46ULL, 0x000000103f367825ULL, 0x040fe200078e0036ULL,
0x0000000034457faeULL, 0x0003e6000d101c46ULL, 0x000000103f387825ULL, 0x040fe200078e0038ULL,
0x0000000036477faeULL, 0x0003e6000d901c46ULL, 0x000000103f3a7825ULL, 0x040fe200078e003aULL,
0x0000000038497faeULL, 0x0003e6000e101c46ULL, 0x000000103f3c7825ULL, 0x000fe200078e003cULL,
0x000000003a4b7faeULL, 0x0003e8000e901c46ULL, 0x000000003c4d7faeULL, 0x0003e2000f101c46ULL,
0x0000040000007947ULL, 0x000fea0003800000ULL, 0x0000006904287211ULL, 0x000fe400078ff0ffULL,
0x0000001c6c3f7812ULL, 0x000fc400078efcffULL, 0x00000008042a7811ULL, 0x000fe200078ff0ffULL,
0x00005e0028287625ULL, 0x000fe200078e0009ULL, 0x0000001004367811ULL, 0x040fe400078ff0ffULL,
0x0000001804387811ULL, 0x000fe200078ff0ffULL, 0x000000012a347824ULL, 0x000fe200078e0269ULL,
0x00000020043a7811ULL, 0x040fe200078ff0ffULL, 0x000000103f287825ULL, 0x000fe200078e0028ULL,
0x00000028043c7811ULL, 0x040fe400078ff0ffULL, 0x00000030043e7811ULL, 0x000fe200078ff0ffULL,
0x000000042a427824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286d7faeULL, 0x0003e2000b901c46ULL, 0x0000003804407811ULL, 0x000fe200078ff0ffULL,
0x0000000436447824ULL, 0x040fe200078e00ffULL, 0x00000069362a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000138367824ULL, 0x000fc400078e0269ULL, 0x000000043a467824ULL, 0x000fe200078e00ffULL,
0xfffffffc442b7812ULL, 0x100fe200078ee20bULL, 0x000000043c487824ULL, 0x000fe400078e00ffULL,
0x000000043e4a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc46377812ULL, 0x000fe200078ee20bULL,
0x0000000438287824ULL, 0x002fe200078e00ffULL, 0x000000693a387210ULL, 0x080fe20007ffe0ffULL,
0x000000013c3a7824ULL, 0x100fe200078e0269ULL, 0x000000693e3c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001403e7824ULL, 0x000fe200078e0269ULL, 0xfffffffc42297812ULL, 0x100fe200078ee20bULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0xfffffffc28357812ULL, 0x100fe200078ee20bULL,
0x000000102b437824ULL, 0x000fe200078e026aULL, 0xfffffffc48397812ULL, 0x100fe200078ee20bULL,
0x00005e002a2a7625ULL, 0x000fe200078e0009ULL, 0xfffffffc4a3b7812ULL, 0x000fc400078ee20bULL,
0x0000006a29417211ULL, 0x080fe200078e20ffULL, 0x00005e0034287625ULL, 0x080fe200078e0009ULL,
0xfffffffc403d7812ULL, 0x000fe400078ee20bULL, 0x0000006a39497211ULL, 0x000fe200078e20ffULL,
0x0000001035457824ULL, 0x100fe400078e026aULL, 0x0000001037477824ULL, 0x000fe400078e026aULL,
0x00005e0036347625ULL, 0x000fc800078e0009ULL, 0x00005e0038367625ULL, 0x000fc800078e0009ULL,
0x000000103b4b7824ULL, 0x000fe400078e026aULL, 0x00005e003a387625ULL, 0x000fc800078e0009ULL,
0x000000103d4d7824ULL, 0x000fe400078e026aULL, 0x00005e003c3a7625ULL, 0x000fc800078e0009ULL,
0x00005e003e3c7625ULL, 0x000fc800078e0009ULL, 0x000000103f287825ULL, 0x000fc800078e0028ULL,
0x000000103f2a7825ULL, 0x040fe200078e002aULL, 0x0000000028417faeULL, 0x0003e6000b901c46ULL,
0x000000103f347825ULL, 0x040fe200078e0034ULL, 0x000000002a437faeULL, 0x0003e6000b901c46ULL,
0x000000103f367825ULL, 0x040fe200078e0036ULL, 0x0000000034457faeULL, 0x0003e6000b901c46ULL,
0x000000103f387825ULL, 0x040fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000b901c46ULL,
0x000000103f3a7825ULL, 0x040fe200078e003aULL, 0x0000000038497faeULL, 0x0003e6000b901c46ULL,
0x000000103f3c7825ULL, 0x000fe200078e003cULL, 0x000000003a4b7faeULL, 0x0003e8000b901c46ULL,
0x000000003c4d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000180a287810ULL, 0x002fc40007ffe0ffULL, 0x0000001a0a347810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e780dULL, 0x0000000734347812ULL, 0x000fc600078e780dULL,
0x000000200d287824ULL, 0x040fe400078e0228ULL, 0x000000200d347824ULL, 0x000fc600078e0234ULL,
0x0000000428487819ULL, 0x000fe200000006ffULL, 0x0000001034347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006b28783bULL, 0x000fe80000000200ULL,
0x000000004848783bULL, 0x000e680000000200ULL, 0x00000000685c783bULL, 0x000ea80000000200ULL,
0x000000006750783bULL, 0x000ee80000000200ULL, 0x00000000664c783bULL, 0x000f280000000200ULL,
0x000000006544783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000006440783bULL, 0x000ee80000000200ULL, 0x00000000633c783bULL, 0x000ee80000000200ULL,
0x000000006238783bULL, 0x000ee20000000200ULL, 0x00000028482c723cULL, 0x042fee000000182cULL,
0x0000030061297a10ULL, 0x000fe20007ffe0ffULL, 0x0000002a4858723cULL, 0x040fee0000001858ULL,
0x00000001292b7810ULL, 0x000fe20007ffe0ffULL, 0x0000005c4854723cULL, 0x004fe60000001854ULL,
0x000000002b00720cULL, 0x000fca0003f06070ULL, 0x0000005e4818723cULL, 0x040ff00000001818ULL,
0x00000050481c723cULL, 0x048ff0000000181cULL, 0x000000524820723cULL, 0x040ff00000001820ULL,
0x0000004c4824723cULL, 0x050ff00000001824ULL, 0x0000004e4830723cULL, 0x000ff00000001830ULL,
0x00000044342c723cULL, 0x060ff0000000182cULL, 0x000000463458723cULL, 0x040ff00000001858ULL,
0x000000403454723cULL, 0x040ff00000001854ULL, 0x000000423418723cULL, 0x040ff00000001818ULL,
0x0000003c341c723cULL, 0x040ff0000000181cULL, 0x0000003e3420723cULL, 0x040ff00000001820ULL,
0x000000383424723cULL, 0x040ff00000001824ULL, 0x0000003a3430723cULL, 0x000fee0000001830ULL,
0x0000010029367824ULL, 0x000fc800078e0202ULL, 0x0000620003417a24ULL, 0x000fe200078e0236ULL,
0x0000055000008947ULL, 0x000fea0003800000ULL, 0x00000002ff3e7819ULL, 0x000fe40000011604ULL,
0x00000004042b7819ULL, 0x000fe400000006ffULL, 0x0000003617287217ULL, 0x000fe20007800000ULL,
0x000000013e2a7824ULL, 0x040fe200078e0241ULL, 0x000000083e387810ULL, 0x000fe40007ffe0ffULL,
0x000000302b437812ULL, 0x000fe200078ec0ffULL, 0x00005e002a2a7625ULL, 0x000fe200078e0009ULL,
0x000000103e407810ULL, 0x000fc40007ffe0ffULL, 0x000000283e467810ULL, 0x000fe20007ffe0ffULL,
0x0000000128287824ULL, 0x000fe200078e0a36ULL, 0x000000432a3a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000138347824ULL, 0x000fe200078e0241ULL, 0x00000041402a7210ULL, 0x000fe40007ffe0ffULL,
0x000000283800720cULL, 0x000fe20003f26070ULL, 0x00005e0034347625ULL, 0x000fe200078e0009ULL,
0x000000203e447810ULL, 0x040fe40007ffe0ffULL, 0x000000183e427810ULL, 0x000fe20007ffe0ffULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x000000303e477810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e062bULL, 0x00000043343c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0009ULL, 0xfffffffc38397812ULL, 0x000fc400078ee20bULL,
0x00000035ff3d7210ULL, 0x000fe200007fe4ffULL, 0x0000000146387824ULL, 0x100fe200078e0241ULL,
0x000000283e00720cULL, 0x080fe20003f06070ULL, 0x0000000144367824ULL, 0x100fe200078e0241ULL,
0x000000432a2a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001039457824ULL, 0x000fe200078e020cULL,
0x000000383e487810ULL, 0x000fe20007ffe0ffULL, 0x0000000142347824ULL, 0x000fe200078e0241ULL,
0x000000284000720cULL, 0x080fe20003fa6070ULL, 0x00005e0038387625ULL, 0x000fe200078e0009ULL,
0x000000284200720cULL, 0x000fc40003f86070ULL, 0x0000000240407819ULL, 0x000fe200000006ffULL,
0x00005e0036367625ULL, 0x000fe200078e0009ULL, 0x00000043383e7210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a0e7faeULL, 0x0003e2000c101c46ULL,
0x000000284800720cULL, 0x080fe20003f06070ULL, 0x00005e0034347625ULL, 0x000fe200078e0009ULL,
0x0000004336367210ULL, 0x000fe20007f7e0ffULL, 0x000000003c457faeULL, 0x0005e2000c901c46ULL,
0x000000284700720cULL, 0x0c0fe20003f26070ULL, 0x0000000147387824ULL, 0x000fe200078e0241ULL,
0x00000037ff377210ULL, 0x000fe20001ffe4ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e062bULL,
0x0000004334347210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200030e0639ULL,
0x000000284400720cULL, 0x000fe20003f66070ULL, 0x00005e0038387625ULL, 0x000fc800078e0009ULL,
0x0000000442427824ULL, 0x000fe200078e00ffULL, 0xfffffffc403d7812ULL, 0x004fe200078ee20bULL,
0x00000001483a7824ULL, 0x002fe200078e0241ULL, 0x0000004338387210ULL, 0x000fe20007fde0ffULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0xfffffffc42417812ULL, 0x000fe200078ee20bULL,
0x000000ffff357224ULL, 0x000fe200010e0635ULL, 0x000000284600720cULL, 0x040fe20003f46070ULL,
0x00000004470e7824ULL, 0x000fe200078e00ffULL, 0x0000000246467819ULL, 0x000fe200000006ffULL,
0x0000000448487824ULL, 0x000fe200078e00ffULL, 0xfffffffc44457812ULL, 0x100fe200078ee20bULL,
0x00005e003a3a7625ULL, 0x000fe200078e0009ULL, 0xfffffffc46477812ULL, 0x000fc400078ee20bULL,
0xfffffffc0e497812ULL, 0x100fe200078ee20bULL, 0x000000103d3d7824ULL, 0x100fe200078e020cULL,
0x00000039ff397210ULL, 0x000fe200037fe4ffULL, 0x0000001041417824ULL, 0x100fe200078e020cULL,
0xfffffffc480b7812ULL, 0x000fe200078ee20bULL, 0x0000001045457824ULL, 0x100fe200078e020cULL,
0x000000433a3a7210ULL, 0x000fe20007fde0ffULL, 0x0000001049497824ULL, 0x100fe200078e020cULL,
0x0000000c47477211ULL, 0x000fe200078e20ffULL, 0x000000100b0b7824ULL, 0x000fe200078e020cULL,
0x000000002a3d7faeULL, 0x0003e2000e901c46ULL, 0x000000ffff3b7224ULL, 0x000fc600030e063bULL,
0x0000000034417faeULL, 0x0003e8000e101c46ULL, 0x0000000036457faeULL, 0x0003e8000d901c46ULL,
0x000000003e477faeULL, 0x0003e8000d101c46ULL, 0x0000000038497faeULL, 0x0003e8000c901c46ULL,
0x000000003a0b7faeULL, 0x0003e2000c101c46ULL, 0x0000049000007947ULL, 0x000fea0003800000ULL,
0x0000000404287819ULL, 0x040fe400000006ffULL, 0x00000041042a7211ULL, 0x000fc400078ff0ffULL,
0x0000000804347811ULL, 0x040fe400078ff0ffULL, 0x0000001004367811ULL, 0x000fe200078ff0ffULL,
0x00005e002a2a7625ULL, 0x000fe200078e0009ULL, 0x0000001804387811ULL, 0x040fe400078ff0ffULL,
0x00000020043a7811ULL, 0x000fe200078ff0ffULL, 0x0000000434467824ULL, 0x000fe200078e00ffULL,
0x00000028043c7811ULL, 0x000fe200078ff0ffULL, 0x00000004384a7824ULL, 0x000fe200078e00ffULL,
0x0000003028437812ULL, 0x000fe200078ec0ffULL, 0x0000000134287824ULL, 0x100fe200078e0241ULL,
0x0000000236487819ULL, 0x040fe200000006ffULL, 0x0000000136347824ULL, 0x100fe200078e0241ULL,
0x000000023a4c7819ULL, 0x000fe200000006ffULL, 0x0000000138367824ULL, 0x100fe200078e0241ULL,
0x00000030043e7811ULL, 0x000fe200078ff0ffULL, 0x000000013a387824ULL, 0x100fe200078e0241ULL,
0x0000003804407811ULL, 0x000fe200078ff0ffULL, 0x000000013c3a7824ULL, 0x000fe200078e0241ULL,
0xfffffffc4a3f7812ULL, 0x000fe200078ee20bULL, 0x000000043c4e7824ULL, 0x000fe200078e00ffULL,
0x000000432a3c7210ULL, 0x000fe20007f1e0ffULL, 0x000000013e427824ULL, 0x140fe200078e0241ULL,
0x000000023e3e7819ULL, 0x000fe200000006ffULL, 0x0000000140447824ULL, 0x000fe200078e0241ULL,
0xfffffffc4c417812ULL, 0x000fe200078ee20bULL, 0x000000ffff3d7224ULL, 0x000fe200000e062bULL,
0xfffffffc3e4d7812ULL, 0x100fe200078ee20bULL, 0x00005e00282a7625ULL, 0x000fe200078e0009ULL,
0xfffffffc483b7812ULL, 0x000fc400078ee20bULL, 0xfffffffc46397812ULL, 0x100fe200078ee20bULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x000000432a3e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0034347625ULL, 0x080fe200078e0009ULL, 0xfffffffc4e4b7812ULL, 0x100fe200078ee20bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003c0e7faeULL, 0x0003e2000b901c46ULL,
0xfffffffc404f7812ULL, 0x000fe200078ee20bULL, 0x00005e0036367625ULL, 0x000fe200078e0009ULL,
0x0000004334407210ULL, 0x080fe40007f3e0ffULL, 0x0000000c390b7211ULL, 0x080fe200078e20ffULL,
0x000000103f477824ULL, 0x100fe200078e020cULL, 0x0000000c4b4b7211ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e062bULL, 0x0000004336367210ULL, 0x000fe20007f1e0ffULL,
0x0000001041497824ULL, 0x000fe200078e020cULL, 0x00000035ff417210ULL, 0x000fe20000ffe4ffULL,
0x00005e00382a7625ULL, 0x080fe200078e0009ULL, 0x000000003e0b7faeULL, 0x0003e6000b901c46ULL,
0x00005e003a347625ULL, 0x000fc800078e0009ULL, 0x000000103b457824ULL, 0x000fe200078e020cULL,
0x0000004334347210ULL, 0x000fe20007f3e0ffULL, 0x00005e0042387625ULL, 0x000fc600078e0009ULL,
0x0000000040457faeULL, 0x0003e2000b901c46ULL, 0x00005e00443a7625ULL, 0x000fe200078e0009ULL,
0x0000004338387210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x000000432a2a7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x000000433a3a7210ULL, 0x000fe20007f7e0ffULL, 0x000000104d4d7824ULL, 0x100fe200078e020cULL,
0x00000039ff397210ULL, 0x000fe200017fe4ffULL, 0x000000ffff2b7224ULL, 0x000fe200000e062bULL,
0x0000000036477faeULL, 0x0003e2000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e020cULL,
0x000000ffff3b7224ULL, 0x000fe200018e063bULL, 0x000000002a497faeULL, 0x0003e8000b901c46ULL,
0x00000000344b7faeULL, 0x0003e8000b901c46ULL, 0x00000000384d7faeULL, 0x0003e8000b901c46ULL,
0x000000003a4f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001c0a0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001e0a0a7810ULL, 0x000fe40007ffe0ffULL,
0x000000070c0c7812ULL, 0x100fe400078e780dULL, 0x000000070a0a7812ULL, 0x000fc600078e780dULL,
0x000000200d0c7824ULL, 0x040fe200078e020cULL, 0x0000000a0d0a7211ULL, 0x000fc600078e28ffULL,
0x000000100c0c7824ULL, 0x000fe400078e00ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000c38783bULL, 0x002fe80000000200ULL,
0x00000000103c783bULL, 0x000e680000000200ULL, 0x000000000f34783bULL, 0x000ea80000000200ULL,
0x000000001144783bULL, 0x000ee80000000200ULL, 0x000000001248783bULL, 0x000f280000000200ULL,
0x000000000a40783bULL, 0x000fe80000000200ULL, 0x000000001450783bULL, 0x000f680000000200ULL,
0x00000000154c783bULL, 0x000ee80000000200ULL, 0x00000000160c783bULL, 0x000ee80000000200ULL,
0x00000000135c783bULL, 0x0008e20000000200ULL, 0x0000003c3854723cULL, 0x042ff00000001854ULL,
0x00000034382c723cULL, 0x044ff0000000182cULL, 0x000000363858723cULL, 0x040ff00000001858ULL,
0x0000003e3818723cULL, 0x040ff00000001818ULL, 0x000000443834723cULL, 0x048ff0000000181cULL,
0x000000483810723cULL, 0x050ff00000001824ULL, 0x000000463820723cULL, 0x040ff00000001820ULL,
0x0000004a3830723cULL, 0x000ff00000001830ULL, 0x00000050401c723cULL, 0x060ff00000001854ULL,
0x000000524050723cULL, 0x040ff00000001818ULL, 0x0000004c4018723cULL, 0x040ff00000001834ULL,
0x0000000c4010723cULL, 0x040ff00000001810ULL, 0x0000005c402c723cULL, 0x040ff0000000182cULL,
0x0000005e4058723cULL, 0x040ff00000001858ULL, 0x0000004e404c723cULL, 0x040ff00000001820ULL,
0x0000000e400c723cULL, 0x000fe20000001830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x00000000050a7f8cULL, 0x000fe2000c80043fULL, 0x3d8000002c2c7820ULL, 0x000fe20000410000ULL,
0x3d8000002d2d7820ULL, 0x000fe20000410000ULL, 0x3d8000002f147820ULL, 0x000fe20000410000ULL,
0x0000040005337984ULL, 0x000e620000000800ULL, 0x3d8000005a5a7820ULL, 0x000fe20000410000ULL,
0x3d80000050507820ULL, 0x000fe20000410000ULL, 0x3d8000002e097820ULL, 0x000fe20000410000ULL,
0x3d8000005b5b7820ULL, 0x000fe20000410000ULL, 0x3d80000051517820ULL, 0x000fe20000410000ULL,
0x3d800000192a7820ULL, 0x000fe20000410000ULL, 0x3d80000012127820ULL, 0x000fe20000410000ULL,
0x3d8000001a197820ULL, 0x000fe20000410000ULL, 0x3d8000001b1a7820ULL, 0x000fe20000410000ULL,
0x3d8000001c2f7820ULL, 0x000fe20000410000ULL, 0x3d8000001d2e7820ULL, 0x000fe20000410000ULL,
0x3d8000001e207820ULL, 0x000fe20000410000ULL, 0x3d8000001f217820ULL, 0x000fe20000410000ULL,
0x3d800000182b7820ULL, 0x000fe20000410000ULL, 0x3d80000013157820ULL, 0x000fe20000410000ULL,
0x000000ffff327224ULL, 0x000fe200078e002dULL, 0x3d80000058317820ULL, 0x000fe20000410000ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0014ULL, 0x3d80000059307820ULL, 0x000fe20000410000ULL,
0x3d80000052227820ULL, 0x000fe20000410000ULL, 0x3d800000531e7820ULL, 0x000fe20000410000ULL,
0x3d8000004c287820ULL, 0x000fe20000410000ULL, 0x3d8000004d277820ULL, 0x000fe20000410000ULL,
0x3d8000004e1d7820ULL, 0x000fe20000410000ULL, 0x3d8000004f167820ULL, 0x000fe20000410000ULL,
0x3d80000010267820ULL, 0x000fe20000410000ULL, 0x3d80000011257820ULL, 0x000fe20000410000ULL,
0x3d8000000c247820ULL, 0x000fe20000410000ULL, 0x3d8000000d237820ULL, 0x000fe20000410000ULL,
0x3d8000000e0e7820ULL, 0x000fe20000410000ULL, 0x3d8000000f137820ULL, 0x000fe20000410000ULL,
0x00000050002d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff187224ULL, 0x000fe200078e0009ULL,
0x0000005a001c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e005bULL,
0x000000ffff147224ULL, 0x000fe200078e0012ULL, 0x8000000033ff7812ULL, 0x002fe2000780480bULL,
0x000000ffff337224ULL, 0x000fe400078e002cULL, 0x000000ffff2c7224ULL, 0x000fe200078e0051ULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x000000b000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e000eULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e00000000097802ULL, 0x000fc80000000f00ULL, 0x00000009000c7305ULL, 0x0002a4000021f000ULL,
0x3fa0000009097823ULL, 0x002fe200000100ffULL, 0x0000000c0000735dULL, 0x004fe20003800000ULL,
0x00000400050d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000404107824ULL, 0x000fe200078e00ffULL,
0x000000066100720cULL, 0x000fc80003f05270ULL, 0xfffffff010117812ULL, 0x000fca00078ec0ffULL,
0x0000008060117824ULL, 0x000fca00078e0211ULL, 0x01440000110c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000204097824ULL, 0x000fe200078e00ffULL,
0x8000000817357210ULL, 0x000fc80007ffe0ffULL, 0x0000000609097812ULL, 0x000fc800078ec0ffULL,
0x0000000109087812ULL, 0x040fe400078efcffULL, 0x00000008090a7812ULL, 0x040fe400078efcffULL,
0x000000350800720cULL, 0x080fe40003f26070ULL, 0x0000001009087812ULL, 0x000fe400078efcffULL,
0x000000350a00720cULL, 0x080fe40003f06070ULL, 0x000000350800720cULL, 0x000fc40003fc6070ULL,
0x00000011090a7812ULL, 0x040fe400078efcffULL, 0x0000001809087812ULL, 0x040fe400078efcffULL,
0x000000350900720cULL, 0x0c0fe40003f46070ULL, 0x000000350a00720cULL, 0x080fe40003fa6070ULL,
0x000000350800720cULL, 0x000fe40003f66070ULL, 0x00000009090b7812ULL, 0x000fc400078efcffULL,
0x00000019090a7812ULL, 0x040fe400078efcffULL, 0x0000002009087812ULL, 0x000fe400078efcffULL,
0xff7fffff18187808ULL, 0x000fe40005000000ULL, 0xff7fffff33337808ULL, 0x000fe40005000000ULL,
0xff7fffff1b1b7808ULL, 0x000fe40004800000ULL, 0xff7fffff32327808ULL, 0x000fc40004800000ULL,
0x000000350b00720cULL, 0x080fe40003f86070ULL, 0x000000350a00720cULL, 0x080fe40003f46070ULL,
0x000000350800720cULL, 0x000fe40003f26070ULL, 0x00000021090a7812ULL, 0x040fe400078efcffULL,
0x0000002809087812ULL, 0x000fe400078efcffULL, 0xff7fffff1c1c7808ULL, 0x000fc40004000000ULL,
0xff7fffff31317808ULL, 0x000fe40004000000ULL, 0xff7fffff1f1f7808ULL, 0x000fe40006000000ULL,
0xff7fffff30307808ULL, 0x000fe40006000000ULL, 0x000000350a00720cULL, 0x080fe40003f06070ULL,
0x000000350800720cULL, 0x000fe40003f86070ULL, 0x00000029090a7812ULL, 0x000fc400078efcffULL,
0x0000003009087812ULL, 0x000fe400078efcffULL, 0xff7fffff20207808ULL, 0x000fe40007000000ULL,
0xff7fffff2f2f7808ULL, 0x000fe40007000000ULL, 0xff7fffff21217808ULL, 0x000fe40006800000ULL,
0xff7fffff2e2e7808ULL, 0x000fe40006800000ULL, 0x000000350a00720cULL, 0x000fc40003fc6070ULL,
0x000000350800720cULL, 0x000fe40003fa6070ULL, 0x00000031090a7812ULL, 0x040fe400078efcffULL,
0x0000003809087812ULL, 0x040fe400078efcffULL, 0x0000003909097812ULL, 0x000fe400078efcffULL,
0xff7fffff22227808ULL, 0x000fe40005800000ULL, 0xff7fffff2d2d7808ULL, 0x000fc40005800000ULL,
0xff7fffff1e1e7808ULL, 0x000fe40005000000ULL, 0xff7fffff2c2c7808ULL, 0x000fe40005000000ULL,
0xff7fffff19197808ULL, 0x000fe40004800000ULL, 0xff7fffff2b2b7808ULL, 0x000fe40004800000ULL,
0x000000350a00720cULL, 0x080fe40003f66070ULL, 0x000000350800720cULL, 0x000fc40003f46070ULL,
0x000000350900720cULL, 0x000fe40003f26070ULL, 0xff7fffff1a1a7808ULL, 0x000fe40004000000ULL,
0xff7fffff2a2a7808ULL, 0x000fe40004000000ULL, 0xff7fffff1d1d7808ULL, 0x000fe40006000000ULL,
0xff7fffff28287808ULL, 0x000fe40006000000ULL, 0xff7fffff16167808ULL, 0x000fc40007000000ULL,
0xff7fffff27277808ULL, 0x000fe40007000000ULL, 0xff7fffff14147808ULL, 0x000fe40006800000ULL,
0xff7fffff26267808ULL, 0x000fe40006800000ULL, 0xff7fffff15157808ULL, 0x000fe40005800000ULL,
0xff7fffff25257808ULL, 0x000fe40005800000ULL, 0xff7fffff12127808ULL, 0x000fc40005000000ULL,
0xff7fffff24247808ULL, 0x000fe40005000000ULL, 0xff7fffff13137808ULL, 0x000fe40004800000ULL,
0xff7fffff23237808ULL, 0x000fe40004800000ULL, 0x000000330c097209ULL, 0x004fe20007810000ULL,
0x0000001fff387424ULL, 0x000fe200078e00ffULL, 0x000000180d0a7209ULL, 0x000fe20007810000ULL,
0xffffffffff3b7424ULL, 0x000fe200078e00ffULL, 0x0000003209087209ULL, 0x000fe40007810000ULL,
0x0000001b0a097209ULL, 0x000fc40007810000ULL, 0x00000031080b7209ULL, 0x000fe40007810000ULL,
0x0000001c09087209ULL, 0x000fe40007810000ULL, 0x000000300b0a7209ULL, 0x000fe40007810000ULL,
0x0000001f08097209ULL, 0x000fe40007810000ULL, 0x0000002f0a0b7209ULL, 0x000fe40007810000ULL,
0x0000002009087209ULL, 0x000fc40007810000ULL, 0x0000002e0b0a7209ULL, 0x000fe40007810000ULL,
0x0000002108097209ULL, 0x000fe40007810000ULL, 0x0000002d0a0b7209ULL, 0x000fe40007810000ULL,
0x0000002209097209ULL, 0x000fe40007810000ULL, 0x0000002c0b087209ULL, 0x000fe40007810000ULL,
0x0000001e090a7209ULL, 0x000fc40007810000ULL, 0x0000002b08097209ULL, 0x000fe40007810000ULL,
0x000000190a0b7209ULL, 0x000fe40007810000ULL, 0x0000002a09097209ULL, 0x000fe40007810000ULL,
0x0000001a0b087209ULL, 0x000fe40007810000ULL, 0x00000028090a7209ULL, 0x000fe40007810000ULL,
0x0000001d08097209ULL, 0x000fc40007810000ULL, 0x000000270a0b7209ULL, 0x000fe40007810000ULL,
0x0000001609097209ULL, 0x000fe40007810000ULL, 0x000000260b087209ULL, 0x000fe40007810000ULL,
0x00000014090a7209ULL, 0x000fe40007810000ULL, 0x0000002508097209ULL, 0x000fe40007810000ULL,
0x000000150a0b7209ULL, 0x000fc40007810000ULL, 0x0000002409087209ULL, 0x000fe40007810000ULL,
0x000000120b0a7209ULL, 0x000fe40007810000ULL, 0x0000002308347209ULL, 0x000fe40007810000ULL,
0x000000130a377209ULL, 0x000fe20007810000ULL, 0x000017927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034087f89ULL, 0x0004e400000e0000ULL, 0x0000000834397209ULL, 0x008fe20007810000ULL,
0x000017b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0037087f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e097f89ULL, 0x000f2800000e0000ULL, 0x0c401f000f0a7f89ULL, 0x000f6200000e0000ULL,
0x00000008370c7209ULL, 0x008fc60007810000ULL, 0x0c201f0039087f89ULL, 0x000ee200000e0000ULL,
0x000000090e0d7209ULL, 0x010fc60007810000ULL, 0x0c201f000c097f89ULL, 0x000f2200000e0000ULL,
0x0000000a0f0b7209ULL, 0x020fc60007810000ULL, 0x0c201f000d347f89ULL, 0x006e6800000e0000ULL,
0x0c201f000b367f89ULL, 0x0004a200000e0000ULL, 0x0000000839087209ULL, 0x008fe40007810000ULL,
0x000000090c097209ULL, 0x010fe40007810000ULL, 0x000000340d0a7209ULL, 0x002fe40007810000ULL,
0x3fb8aa3b080c7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b09377820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000000057886ULL, 0x000fe200038e0100ULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010837ULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080cULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b230c7823ULL, 0x000fe2000001080cULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b22387823ULL, 0x102fe20000010837ULL, 0x00000031000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b12127823ULL, 0x100fe20000010837ULL,
0x3fb8aa3b13137823ULL, 0x000fe20000010837ULL, 0x00000030000d7308ULL, 0x000e620000000800ULL,
0x0000000b360b7209ULL, 0x004fce0007810000ULL, 0x0000002400347308ULL, 0x000ff00000000800ULL,
0x0000001800187308ULL, 0x000fe20000000800ULL, 0x0000000e0d0e723eULL, 0x002fce00000000ffULL,
0x0000001b001b7308ULL, 0x000e700000000800ULL, 0x0000001c000f7308ULL, 0x000ff00000000800ULL,
0x0000001f00247308ULL, 0x000ea20000000800ULL, 0x000000181b0d723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b1e187823ULL, 0x100fe20000010837ULL, 0x3fb8aa3b1d1b7823ULL, 0x000fca0000010837ULL,
0x0000000c00357308ULL, 0x0003e20000000800ULL, 0x0000000f240f723eULL, 0x004fce00000000ffULL,
0x0000002600307308ULL, 0x000fe20000000800ULL, 0x00000033320c723eULL, 0x002fe200000000ffULL,
0x3c003c00ff327424ULL, 0x000fe200078e00ffULL, 0x3c003c0000337802ULL, 0x000fca0000000f00ULL,
0x0000002500317308ULL, 0x000ff00000000800ULL, 0x0000002000257308ULL, 0x000ff00000000800ULL,
0x0000002100267308ULL, 0x0002b00000000800ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000320c20723cULL, 0x002fee00000018ffULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x00000025261d723eULL, 0x004fce00000000ffULL, 0x0000002d002d7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x0000002f2e1c723eULL, 0x002fce00000000ffULL,
0x0000003800387308ULL, 0x000ff00000000800ULL, 0x00000018001f7308ULL, 0x000e620000000800ULL,
0x0000002d2c1e723eULL, 0x004fce00000000ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000381f1f723eULL, 0x002fce00000000ffULL, 0x0000002700277308ULL, 0x000e620000000800ULL,
0x000000321c20723cULL, 0x000fee0000001820ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x000000282726723eULL, 0x002fce00000000ffULL,
0x0000001900197308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x0000002b2a24723eULL, 0x004fe200000000ffULL, 0x0000000fff2b7424ULL, 0x000fcc00078e00ffULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x0000001600167308ULL, 0x000ea20000000800ULL,
0x000000191a25723eULL, 0x002fce00000000ffULL, 0x0000001400147308ULL, 0x000fe20000000800ULL,
0x0000001b1627723eULL, 0x004fce00000000ffULL, 0x0000001500157308ULL, 0x000e620000000800ULL,
0xfffffffc04167812ULL, 0x000fc800078ec0ffULL, 0x000000162b2b7219ULL, 0x000fe200000006ffULL,
0x000000322418723cULL, 0x000fe40000001820ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000002b1673a1ULL, 0x000ea200000e8000ULL, 0x000000002b0473c4ULL, 0x000ee60000004000ULL,
0x000000303120723eULL, 0x000fe400000000ffULL, 0x000000343522723eULL, 0x000fe200000000ffULL,
0x0000001300137308ULL, 0x000f220000000800ULL, 0x000000141521723eULL, 0x002fc400000000ffULL,
0x000000121323723eULL, 0x010fe400000000ffULL, 0x000000052bff7c12ULL, 0x004fd2000f804016ULL,
0x000000322018723cULL, 0x000fe80000001818ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x000012e204008947ULL, 0x008fde000b800000ULL, 0x001c1fff182c7589ULL, 0x0002a400000e0000ULL,
0x000000002b1273a1ULL, 0x000ee200000e8000ULL, 0x000000002b0473c4ULL, 0x000f220000004000ULL,
0x0000000000057886ULL, 0x000fe400038e0100ULL, 0x000000052bff7c12ULL, 0x008fda000f804012ULL,
0x000012f204008947ULL, 0x010fea000b800000ULL, 0x001c1fff1a2d7589ULL, 0x00072800000e0000ULL,
0x001c1fff2e2e7589ULL, 0x00066800000e0000ULL, 0x001c1fff002f7589ULL, 0x0006a400000e0000ULL,
0x00000002ff127819ULL, 0x000fe40000011604ULL, 0x0000000c103b7812ULL, 0x000fc400078ec0ffULL,
0x0000000712137812ULL, 0x040fe200078ec0ffULL, 0x0000000812187824ULL, 0x042fe200078e00ffULL,
0x0000000312147819ULL, 0x040fe200000006ffULL, 0x0000000812357824ULL, 0x040fe200078e00ffULL,
0x00000012ff167212ULL, 0x000fe400078e33ffULL, 0x0000000812127810ULL, 0x000fe40007ffe0ffULL,
0xfffffff818157812ULL, 0x100fe400078ee213ULL, 0x0000000114197812ULL, 0x100fe200078ef613ULL,
0x0000000812477824ULL, 0x000fe200078e00ffULL, 0x00000002141b7812ULL, 0x100fe200078ef613ULL,
0x0000000812377824ULL, 0x000fe200078e00ffULL, 0x00000003142b7812ULL, 0x008fc400078ef613ULL,
0x0000000414317812ULL, 0x140fe400078ef613ULL, 0x0000000514337812ULL, 0x140fe400078ef613ULL,
0x0000000614137812ULL, 0x000fe400078ef613ULL, 0xfffffff835357812ULL, 0x000fe400078ee216ULL,
0x00000012ff167212ULL, 0x000fe400078e33ffULL, 0x0000000712147812ULL, 0x000fc400078ec0ffULL,
0x0000000312397819ULL, 0x000fe400000006ffULL, 0x0000a00060127811ULL, 0x000fe400078e58ffULL,
0x00000001393d7812ULL, 0x140fe400078ef614ULL, 0x00000002393f7812ULL, 0x000fe200078ef614ULL,
0x0000001015107824ULL, 0x000fe200078e0212ULL, 0x0000000339417812ULL, 0x000fe200078ef614ULL,
0x00000010132a7824ULL, 0x000fe200078e0212ULL, 0x0000000439437812ULL, 0x000fe200078ef614ULL,
0x00000010311a7824ULL, 0x000fe200078e0212ULL, 0x0000000539457812ULL, 0x000fe200078ef614ULL,
0x000000013b137824ULL, 0x000fe200078e0210ULL, 0xfffffff837377812ULL, 0x000fe200078ee214ULL,
0x0000001033287824ULL, 0x000fe200078e0212ULL, 0x0000000639397812ULL, 0x000fe200078ef614ULL,
0x0000001019147824ULL, 0x000fe200078e0212ULL, 0xfffffff847477812ULL, 0x000fe200078ee216ULL,
0x000000101b167824ULL, 0x000fe200078e0212ULL, 0x000000122b187211ULL, 0x080fe200078e20ffULL,
0x000000013b157824ULL, 0x000fe200078e0214ULL, 0x0000001235307211ULL, 0x000fe200078e20ffULL,
0x000000013b197824ULL, 0x040fe200078e0216ULL, 0x000000183b1b7210ULL, 0x000fe20007ffe0ffULL,
0x0000001037107824ULL, 0x000fe200078e0212ULL, 0x000000123f347211ULL, 0x000fe200078e20ffULL,
0x000000013b2b7824ULL, 0x000fe200078e021aULL, 0x0000000c13007388ULL, 0x0003e20000000800ULL,
0x000000103d327824ULL, 0x000fe200078e0212ULL, 0x000000303b357210ULL, 0x040fe20007ffe0ffULL,
0x000000013b317824ULL, 0x000fe200078e0228ULL, 0x0000000e15007388ULL, 0x0007e20000000800ULL,
0x0000001041367824ULL, 0x000fe200078e0212ULL, 0x0000000304ff7812ULL, 0x000fe2000780c0ffULL,
0x000000013b337824ULL, 0x000fe200078e022aULL, 0x0000001c19007388ULL, 0x0007e20000000800ULL,
0x0000001043377824ULL, 0x000fe200078e0212ULL, 0x0000001239397211ULL, 0x000fe200078e20ffULL,
0x000000013b107824ULL, 0x000fe200078e0210ULL, 0x0000001e1b007388ULL, 0x0007e20000000800ULL,
0x0000001045387824ULL, 0x000fe200078e0212ULL, 0x000000363b367210ULL, 0x040fe20007ffe0ffULL,
0x000000013b327824ULL, 0x000fe200078e0232ULL, 0x000000242b007388ULL, 0x0007e20000000800ULL,
0x00000010473a7824ULL, 0x000fc400078e0212ULL, 0x000000013b347824ULL, 0x040fe200078e0234ULL,
0x0000002631007388ULL, 0x0007e20000000800ULL, 0x000000013b0c7824ULL, 0x042fe200078e0237ULL,
0x0000003a3b3a7210ULL, 0x040fe20007ffe0ffULL, 0x000000013b387824ULL, 0x040fe200078e0238ULL,
0x0000002033007388ULL, 0x0007e20000000800ULL, 0x000000013b127824ULL, 0x000fc600078e0239ULL,
0x0000002235007388ULL, 0x0007e80000000800ULL, 0x0000000d10007388ULL, 0x0007e80000000800ULL,
0x0000000f32007388ULL, 0x0007e80000000800ULL, 0x0000001d34007388ULL, 0x0007e80000000800ULL,
0x0000001f36007388ULL, 0x0007e80000000800ULL, 0x000000250c007388ULL, 0x0007e80000000800ULL,
0x0000002738007388ULL, 0x0007e80000000800ULL, 0x0000002112007388ULL, 0x0007e80000000800ULL,
0x000000233a007388ULL, 0x0007e80000000800ULL, 0x0140000811008388ULL, 0x0007e80000000c00ULL,
0x0142002c11008388ULL, 0x0147e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146080007ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146100007ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0146180007ff7f8cULL, 0x0009e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000002900720cULL, 0x000fe20003f06070ULL, 0x0146200007ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff617224ULL, 0x000fd600078e0029ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff884000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff197807ULL, 0x004fe40004800000ULL, 0x0001593000187802ULL, 0x000fe40000000f00ULL,
0x00000ea000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff027224ULL, 0x000fe200078e001aULL,
0xfffec62000007947ULL, 0x000fea000383ffffULL, 0x00000001ff197807ULL, 0x000fe40005000000ULL,
0x0001598000187802ULL, 0x000fe40000000f00ULL, 0x00000e5000007944ULL, 0x008fea0003c00000ULL,
0x0000001a00027202ULL, 0x000fe20000000f00ULL, 0xfffec65000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x000fe200078e0002ULL, 0x000159f000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e002fULL,
0xfffec68000007947ULL, 0x000fea000383ffffULL, 0x0000000200317202ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe200078e00ffULL, 0x00015a6000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000d3000007944ULL, 0x00cfea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e002fULL, 0xfffec64000007947ULL, 0x000fea000383ffffULL,
0x0000001100317202ULL, 0x000fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe200078e00ffULL,
0x00015ad000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x000fea0003c00000ULL, 0x0000000811137810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6f7224ULL, 0x004fe200078e002fULL, 0xffffffff002b7802ULL, 0x002fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe200078e00ffULL, 0x00015b4000187802ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fc400078e0013ULL, 0x00000c5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6e7224ULL, 0x004fe200078e002fULL, 0xfffec87000007947ULL, 0x000fea000383ffffULL,
0x00000001ff197807ULL, 0x004fe40004800000ULL, 0x00015b9000187802ULL, 0x000fc40000000f00ULL,
0x00000c4000007944ULL, 0x008fea0003c00000ULL, 0x0000001a00187202ULL, 0x000fe20000000f00ULL,
0xfffee86000007947ULL, 0x000fea000383ffffULL, 0x00000001ff197807ULL, 0x000fe40005000000ULL,
0x00015be000187802ULL, 0x000fc40000000f00ULL, 0x00000bf000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e001aULL, 0xfffee89000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2a7424ULL, 0x002fe200078e00ffULL, 0x00015c4000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x008fea0003c00000ULL,
0x0000002f00187202ULL, 0x004fe20000000f00ULL, 0xfffee8e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0013ULL, 0x00015cb000187802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fe400078e00ffULL,
0x00000ae000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002fULL,
0xfffee99000007947ULL, 0x000fea000383ffffULL, 0x0000001f002a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00015d1000187802ULL, 0x000fe40000000f00ULL,
0x00000a8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff717224ULL, 0x004fe200078e002fULL,
0xffffffff002b7802ULL, 0x002fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fe200078e0013ULL,
0x00015d7000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe400078e00ffULL,
0x00000a2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff707224ULL, 0x004fe200078e002fULL,
0xfffeeac000007947ULL, 0x000fea000383ffffULL, 0x00000001ff197807ULL, 0x004fe40004800000ULL,
0x00015dc000187802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff187224ULL, 0x000fe200078e001aULL, 0xffff077000007947ULL, 0x000fea000383ffffULL,
0x00000001ff197807ULL, 0x000fe40005000000ULL, 0x00015e1000187802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x000fe200078e001aULL,
0xffff07a000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2a7424ULL, 0x002fe200078e00ffULL,
0xffffffff002b7802ULL, 0x000fc40000000f00ULL, 0x00015e7000187802ULL, 0x000fe40000000f00ULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff187224ULL, 0x004fe200078e002fULL,
0xffff07f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x002fe200078e0013ULL,
0x00015ee000187802ULL, 0x000fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fe400078e00ffULL, 0x000008b000007944ULL, 0x008fea0003c00000ULL,
0x0000002f00187202ULL, 0x004fe20000000f00ULL, 0xffff08a000007947ULL, 0x000fea000383ffffULL,
0x0000001fff2a7424ULL, 0x000fe200078e00ffULL, 0x00015f4000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fe400078e00ffULL, 0x0000085000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff717224ULL, 0x004fe200078e002fULL, 0x0000001f002a7802ULL, 0x002fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fe200078e0013ULL, 0x00015fa000187802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff707224ULL, 0x004fe200078e002fULL, 0xffff09d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff197807ULL, 0x004fe40004000000ULL, 0x00015ff000187802ULL, 0x000fc40000000f00ULL,
0x000007e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001aULL,
0xffff268000007947ULL, 0x000fea000383ffffULL, 0x00000001ff197807ULL, 0x000fe40004800000ULL,
0x0001604000187802ULL, 0x000fc40000000f00ULL, 0x0000079000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e001aULL, 0xffff26b000007947ULL, 0x000fea000383ffffULL,
0x0000001f002a7802ULL, 0x002fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fe200078e00ffULL,
0x000160a000187802ULL, 0x000fc40000000f00ULL, 0x000006f000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e002fULL, 0xffff270000007947ULL, 0x000fea000383ffffULL,
0x000000ffff317224ULL, 0x002fe200078e0013ULL, 0xffffffff002b7802ULL, 0x000fe20000000f00ULL,
0x0000001fff2a7424ULL, 0x000fe200078e00ffULL, 0x0001611000187802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e002fULL,
0xffff27b000007947ULL, 0x000fea000383ffffULL, 0x0000001fff2a7424ULL, 0x000fe200078e00ffULL,
0x0001617000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e002fULL,
0x0000001300317202ULL, 0x002fe20000000f00ULL, 0x0000001fff2a7424ULL, 0x000fe200078e00ffULL,
0x000161d000187802ULL, 0x000fe20000000f00ULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e002fULL,
0xffff28e000007947ULL, 0x000fea000383ffffULL, 0x00000002ff357424ULL, 0x000fe200078e00ffULL,
0x00016220000c7802ULL, 0x000fc40000000f00ULL, 0x0000053000007944ULL, 0x002fea0003c00000ULL,
0x0000003600087202ULL, 0x004fe20000000f00ULL, 0xffffe83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x006fe200078e0037ULL, 0x00016280000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fc400078e00ffULL, 0x000004d000007944ULL, 0x000fea0003c00000ULL,
0x0000003637097209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e000eULL,
0x0000000200357802ULL, 0x000fc40000000f00ULL, 0x000162d0000c7802ULL, 0x000fe40000000f00ULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000360e377209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e000fULL, 0x00016320000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff357424ULL, 0x000fe400078e00ffULL, 0x0000043000007944ULL, 0x000fea0003c00000ULL,
0x000000360f0b7209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0039ULL,
0x0000000100357802ULL, 0x000fe40000000f00ULL, 0x00016370000c7802ULL, 0x000fe40000000f00ULL,
0x000003e000007944ULL, 0x000fea0003c00000ULL, 0x0000003639087209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e0009ULL, 0x000163c0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000003609097209ULL, 0x004fe20007810000ULL, 0x000000ffff347224ULL, 0x002fe200078e0037ULL,
0x0000000100357802ULL, 0x000fc40000000f00ULL, 0x00016410000c7802ULL, 0x000fe40000000f00ULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0x00000036370a7209ULL, 0x004fe20007810000ULL,
0x000000ffff347224ULL, 0x002fe200078e000bULL, 0x00016460000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff357424ULL, 0x000fe400078e00ffULL, 0x000002f000007944ULL, 0x000fea0003c00000ULL,
0xffffe6f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff287224ULL, 0x000fe200078e0018ULL,
0x00001c1f002a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0x000164c000187802ULL, 0x000fe40000000f00ULL, 0x000002d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff2c7224ULL, 0x004fe200078e002fULL, 0xffffecc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff287224ULL, 0x002fe200078e001aULL, 0x00001c1f002a7802ULL, 0x000fe20000000f00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0001653000187802ULL, 0x000fc40000000f00ULL,
0x0000026000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff317224ULL, 0x002fe200078e00ffULL,
0x0001658000187802ULL, 0x000fe20000000f00ULL, 0x00001c1fff2a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2d7224ULL, 0x004fe400078e002fULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000ff00317202ULL, 0x002fe20000000f00ULL, 0x00001c1fff2a7424ULL, 0x000fe200078e00ffULL,
0x000165d000187802ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x004fe400078e002fULL,
0x000001c000007944ULL, 0x000fea0003c00000ULL, 0xffffec4000007947ULL, 0x000fea000383ffffULL,
0x0180000027037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000002700038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000027047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002700037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff297424ULL, 0x000fc800078e00ffULL,
0xfffe98b028007950ULL, 0x000fea0003c3ffffULL, 0x00000000000d7802ULL, 0x000fe20000000f00ULL,
0x0000003b00007348ULL, 0x000fe80003800000ULL, 0x0c00003534367389ULL, 0x0002a200000e0038ULL,
0xfffe98700c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff197424ULL, 0x000fe200078e00ffULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x00000031282f7389ULL, 0x0002a200000e002aULL,
0xfffe983018007950ULL, 0x000fea0003c3ffffULL, 0x000000011900780cULL, 0x000fe20003f45070ULL,
0x0000000e00007348ULL, 0x000fd80003800000ULL, 0x0000000000197806ULL, 0x000fc800050e0100ULL,
0x0000000e191a7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff197424ULL, 0x000fc800078e00ffULL,
0xfffe97d018007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000014700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x0000000000000270ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000850ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x00000000000008e0ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f30ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000f50ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f60ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000f80ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001010ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001018ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x0000000000001028ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001200ULL, 0x0000000000016900ULL, 0x7700001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017b00ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017b10ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017b10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017f90ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001010ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000016af0ULL, 0x0000000000016af0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017b00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017f90ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_8_m_8_sm_86_cubin_len = 98416;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
