/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007c00be0002ULL, 0x0000000000000000ULL,
0x0000000000017510ULL, 0x0000000000017090ULL, 0x0038004000500550ULL, 0x0001001200400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x666e692e766e2e00ULL, 0x2e747865742e006fULL, 0x6d5f6c656e72656bULL,
0x692e766e2e006168ULL, 0x6e72656b2e6f666eULL, 0x2e0061686d5f6c65ULL, 0x65726168732e766eULL,
0x6c656e72656b2e64ULL, 0x766e2e0061686d5fULL, 0x6e6174736e6f632eULL, 0x672e766e2e003374ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x34746e6174736e6fULL, 0x6f6c672e766e2e00ULL,
0x6c65722e006c6162ULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x2e766e2e6c65722eULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL,
0x65642e0061686d5fULL, 0x6d6172665f677562ULL, 0x6e2e6c65722e0065ULL, 0x6174736e6f632e76ULL,
0x6c65722e0034746eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x676c6c61632e766eULL, 0x766e2e0068706172ULL, 0x79746f746f72702eULL,
0x722e766e2e006570ULL, 0x6f697463612e6c65ULL, 0x747368732e00006eULL, 0x74732e0062617472ULL,
0x79732e0062617472ULL, 0x79732e006261746dULL, 0x6e68735f6261746dULL, 0x692e766e2e007864ULL,
0x7865742e006f666eULL, 0x6c656e72656b2e74ULL, 0x766e2e0061686d5fULL, 0x656b2e6f666e692eULL,
0x61686d5f6c656e72ULL, 0x6168732e766e2e00ULL, 0x6e72656b2e646572ULL, 0x2e0061686d5f6c65ULL,
0x74736e6f632e766eULL, 0x34456b0033746e61ULL, 0x630058414d5f334dULL, 0x6c69545665686361ULL,
0x006e654c71655365ULL, 0x626f6c672e766e2eULL, 0x0074696e692e6c61ULL, 0x657a69536d656d73ULL,
0x6e6f632e766e2e00ULL, 0x2e0034746e617473ULL, 0x61626f6c672e766eULL, 0x6c656e72656b006cULL,
0x5f5f240065707954ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x2e6c65722e006168ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x736e6f632e766e2eULL, 0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x6f632e766e2e6c65ULL, 0x0034746e6174736eULL, 0x6265642e6c65722eULL,
0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL, 0x632e766e2e00656dULL,
0x68706172676c6c61ULL, 0x6f72702e766e2e00ULL, 0x2e00657079746f74ULL, 0x612e6c65722e766eULL,
0x656b006e6f697463ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000e000300000032ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000006dULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00010000007bULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000085ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000f000300000096ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000f0001000000a6ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0003000000afULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110003000000bdULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00110001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000e0022000000d3ULL, 0x0000000000015ae0ULL, 0x0000000000000170ULL,
0x000e002200000106ULL, 0x0000000000015c50ULL, 0x0000000000000040ULL, 0x000e002200000131ULL,
0x0000000000015c90ULL, 0x0000000000000040ULL, 0x000e00220000015bULL, 0x0000000000015cd0ULL,
0x0000000000000130ULL, 0x000d0003000001ceULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00040003000001e7ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0007000300000229ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0008000300000245ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000e101200000254ULL, 0x0000000000000000ULL, 0x0000000000015e00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00015ae000000000ULL, 0x0000040400000000ULL, 0x810c0000013c0400ULL,
0x00556c0400288080ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x8908288080880828ULL, 0x2880808a08288080ULL, 0x8098082880809208ULL, 0x0828808099082880ULL,
0x8080cc08288080c8ULL, 0x8016288080940828ULL, 0x0000000310288082ULL, 0x8094920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00015ae000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x8a08288080870828ULL, 0x2880809208288080ULL, 0x8098082880809408ULL, 0x08288080c8082880ULL,
0x80808808288080ccULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808892ULL,
0x0000001cffffffffULL, 0x0000011000000000ULL, 0x00015c5000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8808288080870828ULL,
0x2880808a08288080ULL, 0x8094082880809208ULL, 0x0828808098082880ULL, 0x8080c808288080ccULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080c892ULL, 0x0000001cffffffffULL,
0x000001a800000000ULL, 0x00015c9000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8808288080870828ULL, 0x2880808a08288080ULL,
0x8094082880809208ULL, 0x0828808098082880ULL, 0x8080c808288080ccULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080c892ULL, 0x0000002cffffffffULL, 0x0000024000000000ULL,
0x00015cd000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL, 0x8088288080c80900ULL,
0x0000000000002880ULL, 0x0000001200082f04ULL, 0x00081204000000d6ULL, 0x000000000000000dULL,
0x0000000d00081104ULL, 0x0008120400000000ULL, 0x000000000000000cULL, 0x0000000c00081104ULL,
0x0008120400000000ULL, 0x000000000000000bULL, 0x0000000b00081104ULL, 0x0008120400000000ULL,
0x000000000000000aULL, 0x0000000a00081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000007c00043704ULL,
0x00080a0400003501ULL, 0x005001600000000eULL, 0x000c170400501903ULL, 0x0048000700000000ULL,
0x000c17040021f000ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000020001c3104ULL,
0x000142b000013ec0ULL, 0x000144d0000142c0ULL, 0x000144f0000144e0ULL, 0xffffffff01a82904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x05000020ffffffffULL, 0x0500002005000020ULL, 0xffffffff05000020ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01a82804ffffffffULL, 0x00000100000000e0ULL, 0x00001f50000012a0ULL, 0x0000207000001fd0ULL,
0x000023a0000020a0ULL, 0x00002420000023b0ULL, 0x0000296000002490ULL, 0x0000358000003570ULL,
0x000043f0000037f0ULL, 0x0000452000004470ULL, 0x0000483000004640ULL, 0x000048a000004840ULL,
0x00004ba000004900ULL, 0x0000567000005660ULL, 0x0000654000005940ULL, 0x00006670000065c0ULL,
0x0000698000006790ULL, 0x000069f000006990ULL, 0x00006cf000006a50ULL, 0x000077c0000077b0ULL,
0x0000869000007a90ULL, 0x000087c000008710ULL, 0x00008ac0000088e0ULL, 0x00008b3000008ad0ULL,
0x00008e6000008b90ULL, 0x000099a000009990ULL, 0x00009df000009de0ULL, 0x0000c3d00000a6e0ULL,
0x0000ca400000c500ULL, 0x0000d2b00000ca80ULL, 0x00013dc000013d90ULL, 0x00013de000013dd0ULL,
0x00013e2000013e00ULL, 0x00013e5000013e40ULL, 0x00014520000144c0ULL, 0x0001454000014530ULL,
0x00014cc000014c60ULL, 0x00014da000014d30ULL, 0x00014e8000014e10ULL, 0x00014f4000014ee0ULL,
0x0001501000014fa0ULL, 0x000150d000015070ULL, 0x0001519000015130ULL, 0x00015260000151f0ULL,
0x00015320000152c0ULL, 0x000153e000015380ULL, 0x000154b000015440ULL, 0x0001557000015510ULL,
0x00015660000155e0ULL, 0x00015740000156d0ULL, 0x00015820000157b0ULL, 0x0001590000015890ULL,
0x000159f000015970ULL, 0x00015ab000015a50ULL, 0x000001f002003904ULL, 0x0001c600000000ffULL,
0x00000230003f0100ULL, 0x0001c60800000003ULL, 0x000002b0003f0120ULL, 0x0001c68800000003ULL,
0x00000480003f0120ULL, 0x0001c600000000ffULL, 0x000005a0003f0107ULL, 0x0001c68c00000036ULL,
0x00000650003f0102ULL, 0x0001c68800000036ULL, 0x00001dd0003f0101ULL, 0x0001c60800000036ULL,
0x00001de0003f0101ULL, 0x0001c60c00000036ULL, 0x00001e70003f0105ULL, 0x0001c60c00000036ULL,
0x000037c0003f0105ULL, 0x0001c688000000ffULL, 0x000042c0003f0101ULL, 0x0001c62800000036ULL,
0x000042d0003f0101ULL, 0x0001c62c00000036ULL, 0x00004360003f0105ULL, 0x0001c62c00000036ULL,
0x00005910003f0105ULL, 0x0001c690000000ffULL, 0x00006410003f0101ULL, 0x0001c64800000036ULL,
0x00006420003f0101ULL, 0x0001c64c00000036ULL, 0x000064b0003f0105ULL, 0x0001c64c00000036ULL,
0x00007a60003f0105ULL, 0x0001c698000000ffULL, 0x00008560003f0101ULL, 0x0001c66800000036ULL,
0x00008570003f0101ULL, 0x0001c66c00000036ULL, 0x00008600003f0105ULL, 0x0001c66c00000036ULL,
0x00009bd0003f0105ULL, 0x0001c6a0000000ffULL, 0x0000d5a0003f0101ULL, 0x0001c600000000ffULL,
0x0000ebb0003f0101ULL, 0x0001c604000000ffULL, 0x0000ec50003f0105ULL, 0x0001c604000000ffULL,
0x00013410003f0105ULL, 0x000000000000002dULL, 0x00013440003f0101ULL, 0x000000040000002dULL,
0x000136b0003f0105ULL, 0x000000040000002dULL, 0x00014ab0003f0105ULL, 0x0001c60800000003ULL,
0x00014b10003f0101ULL, 0x0001c61000000003ULL, 0x00014b70003f0101ULL, 0x0001c61800000003ULL,
0x00014be0003f0101ULL, 0x0001c62000000003ULL, 0x00033803003f0101ULL, 0x0000d51000101c04ULL,
0x0000ed300000ecb0ULL, 0x0000040100014c20ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0xffffffff00000000ULL, 0xfffffffe00000000ULL, 0xfffffffd00000000ULL,
0xfffffffc00000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000008ULL,
0x0000000900000002ULL, 0x0000000000000000ULL, 0x0000000600000002ULL, 0x00000000000002c4ULL,
0x0000001200000002ULL, 0x000000000000022cULL, 0x0000001200000002ULL, 0x0000000000000194ULL,
0x0000001200000002ULL, 0x00000000000000fcULL, 0x0000001200000002ULL, 0x0000000000000044ULL,
0x0000001200000002ULL, 0x00000000000002a0ULL, 0x0000001200000002ULL, 0x0000000000000208ULL,
0x0000001200000002ULL, 0x0000000000000170ULL, 0x0000001200000002ULL, 0x00000000000000d5ULL,
0x0000001200000002ULL, 0x0000002043e00000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x00000000000b7919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee400000e0000ULL, 0x0000000307077819ULL, 0x000fe200000006ffULL,
0x0000000000007919ULL, 0x000ea80000002200ULL, 0x00000000002f7919ULL, 0x000f220000002600ULL,
0x0000001200127309ULL, 0x000f660000000000ULL, 0x0000000000357919ULL, 0x000ee80000002700ULL,
0x0000000000057919ULL, 0x000ee20000000000ULL, 0x00000005ff7a7819ULL, 0x002fcc0000011603ULL,
0x00001fff7a7a7589ULL, 0x000fe200000e0000ULL, 0x000000010b007824ULL, 0x004fc600078e0200ULL,
0x00001fff0b0b7589ULL, 0x000e6200000e0000ULL, 0x0000008000037824ULL, 0x000fc600078e0203ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000082f027824ULL, 0x010fe200078e00ffULL,
0x000000ff0300720cULL, 0x040fe40003f25270ULL, 0x0000000f0300780cULL, 0x000fe20003f44070ULL,
0x00000035070a7224ULL, 0x008fe200078e0202ULL, 0x0000007f0300780cULL, 0x040fe40003f84070ULL,
0x000000030300780cULL, 0x000fe40003f64070ULL, 0x000000050400720cULL, 0x000fca0003f02070ULL,
0x3fffff80ff049424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff059424ULL, 0x000fe200078e00ffULL,
0x7fffffc00007a802ULL, 0x000fe20000000f00ULL, 0x000000040b027824ULL, 0x002fe400078e027aULL,
0x3fffffc0ff06a424ULL, 0x000fe200078e00ffULL, 0x01c60004ff009388ULL, 0x0003e20000000a00ULL,
0xff317217ff10c424ULL, 0x000fe200078e00ffULL, 0x00000001020d7819ULL, 0x000fe200000006ffULL,
0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL, 0x01c608060300a388ULL, 0x0007e20000008a00ULL,
0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL, 0x000000080d0c7817ULL, 0x040fe20007800000ULL,
0x00000200ff027424ULL, 0x000fe200078e00ffULL, 0x01c400100300c388ULL, 0x000fe20000004800ULL,
0x00000010000e7824ULL, 0x004fe200078e00ffULL, 0x000000010d0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010a057824ULL, 0x102fe200078e020dULL, 0x01c688080300b388ULL, 0x0003e20000008a00ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0dULL, 0x000001f00e117812ULL, 0x000fe200078ec0ffULL,
0x00005c0005047625ULL, 0x000fe200078e0002ULL, 0x0000000f0a077210ULL, 0x008fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x000000ff0c00720cULL, 0x000fc40003f23070ULL,
0x000000010c00780cULL, 0x000fe20003f43070ULL, 0x00005c0007067625ULL, 0x000fe200078e0002ULL,
0x000000070d037812ULL, 0x002fe400078ec0ffULL, 0x000000070f097812ULL, 0x000fe400078ec0ffULL,
0x0000001f030a7812ULL, 0x100fe400078e7800ULL, 0x0000001104087210ULL, 0x080fe40007f7e0ffULL,
0x0000001f09047812ULL, 0x000fe200078e7800ULL, 0x000000200d0a7824ULL, 0x000fe200078e020aULL,
0x0000001106067210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff097224ULL, 0x000fc400018e0605ULL,
0x000000200f047824ULL, 0x000fe200078e0204ULL, 0x000000040a037819ULL, 0x000fe200000006ffULL,
0x000000ffff077224ULL, 0x000fe400020e0607ULL, 0x00000010040d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x020fe200078e0a12ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008037faeULL, 0x0003e2000c901c46ULL, 0x00000004ff047424ULL, 0x000fc600078e00ffULL,
0x00000000060d7faeULL, 0x0003e2000d101c46ULL, 0x0000600035047625ULL, 0x000fc600078e0004ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01c6040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01c60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000604797981ULL, 0x000ea2000c1e1900ULL, 0x00000000000479c3ULL, 0x000ee20000002500ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x00000004ff7b7e24ULL, 0x008fe2000f8e00ffULL,
0x000000ff79787810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff787819ULL, 0x000fce0000011678ULL,
0x0000cfb000008947ULL, 0x000fea0003800000ULL, 0x000000037a367819ULL, 0x000fe200000006ffULL,
0x00000003ff037424ULL, 0x002fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c68c0336ff738cULL, 0x0003e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000017b037810ULL, 0x002fe20007ffe0ffULL, 0x0000000235357824ULL, 0x000fe200078e00ffULL,
0x000058002f047a10ULL, 0x000fe20007ffe0ffULL, 0x000001007b087824ULL, 0x000fe200078e00ffULL,
0x000000780300720cULL, 0x000fe20003f06070ULL, 0x01c6880036ff7f8cULL, 0x0003e4000c80043fULL,
0x0000580035357a24ULL, 0x000fc800078e0204ULL, 0x0000620035217a24ULL, 0x000fcc00078e0208ULL,
0x0000059000008947ULL, 0x000fea0003800000ULL, 0x0000000879037217ULL, 0x002fe20007800000ULL,
0x000000087a117824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fe40000011600ULL,
0x0000000308037210ULL, 0x000fe40007ffe1ffULL, 0x0000000c060c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000121057824ULL, 0x000fe200078e0206ULL, 0x0000002003037817ULL, 0x000fe40003800000ULL,
0x00000008060a7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0005047625ULL, 0x000fe200078e0002ULL,
0x0000000706077812ULL, 0x000fc400078e4800ULL, 0x000000030600720cULL, 0x000fe20003f06070ULL,
0x000000080c147824ULL, 0x000fe200078e00ffULL, 0x0000000406087810ULL, 0x000fe20007ffe0ffULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x100fe400078ee200ULL,
0x000140007a107811ULL, 0x000fe200078e68ffULL, 0x00000008080e7824ULL, 0x000fe200078e00ffULL,
0x0ffffff807077812ULL, 0x000fe200078ef800ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x000000000c0d7212ULL, 0x000fc400078e3cffULL, 0x000000000a0b7212ULL, 0x080fe400078e3cffULL,
0x0000000008097212ULL, 0x000fe400078e3cffULL, 0x0000001007077211ULL, 0x000fe400078e20ffULL,
0xfffffff814177812ULL, 0x000fe400078ee20dULL, 0xfffffff812157812ULL, 0x000fe200078ee20bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c46ULL,
0x00000014060d7810ULL, 0x040fe20007ffe0ffULL, 0x0000001017177824ULL, 0x100fe200078e0210ULL,
0x00000010060b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e0210ULL,
0xfffffff80e137812ULL, 0x000fe200078ee209ULL, 0x000000080d1b7824ULL, 0x000fe200078e00ffULL,
0x0000001c06127810ULL, 0x040fe20007ffe0ffULL, 0x0000000121097824ULL, 0x040fe200078e020cULL,
0x00000018060e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001210f7824ULL, 0x000fe200078e020dULL,
0x000000030b197819ULL, 0x000fe200000006ffULL, 0x0000000121057824ULL, 0x002fe200078e0208ULL,
0x000000000b047212ULL, 0x080fe200078e3cffULL, 0x0000000121077824ULL, 0x000fe200078e020aULL,
0x000000030800720cULL, 0x080fe20003f06070ULL, 0x0000000812237824ULL, 0x000fe200078e00ffULL,
0x000000000d067212ULL, 0x080fe200078e3cffULL, 0x00000001211d7824ULL, 0x000fe200078e020eULL,
0x000000030a00720cULL, 0x000fe20003f26070ULL, 0x0000001013137824ULL, 0x000fe200078e0210ULL,
0x000000000e087212ULL, 0x000fc400078e3cffULL, 0x000000030e1f7819ULL, 0x000fe400000006ffULL,
0x000000030c00720cULL, 0x080fe40003f46070ULL, 0x000000030b00720cULL, 0x080fe40003f66070ULL,
0x000000030d00720cULL, 0x080fe20003f86070ULL, 0x00005e000f0c7625ULL, 0x000fe200078e0002ULL,
0x000000030e00720cULL, 0x080fe40003fa6070ULL, 0x000000031200720cULL, 0x040fe20003fc6070ULL,
0x0000000121037824ULL, 0x040fe200078e020bULL, 0x00000000120a7212ULL, 0x000fe200078e3cffULL,
0x0000000121217824ULL, 0x000fe200078e0212ULL, 0xfffffff819197812ULL, 0x000fe200078ee204ULL,
0x00005e0005047625ULL, 0x000fe200078e0002ULL, 0xfffffff81b1b7812ULL, 0x000fc400078ee206ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x00005e0007067625ULL, 0x000fe200078e0002ULL,
0xfffffff823237812ULL, 0x000fe400078ee20aULL, 0x0000001019197211ULL, 0x000fe200078e20ffULL,
0x00005e0009087625ULL, 0x000fc800078e0002ULL, 0x00005e00030a7625ULL, 0x000fc800078e0002ULL,
0x00005e001d0e7625ULL, 0x000fc800078e0002ULL, 0x00005e0021027625ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fc800078e0004ULL, 0x0000001011067825ULL, 0x040fe200078e0006ULL,
0x0000000004137faeULL, 0x0003e6000c101c46ULL, 0x0000001011087825ULL, 0x040fe200078e0008ULL,
0x0000000006157faeULL, 0x0003e6000c901c46ULL, 0x00000010110a7825ULL, 0x040fe200078e000aULL,
0x0000000008177faeULL, 0x0003e6000d101c46ULL, 0x00000010110c7825ULL, 0x000fe200078e000cULL,
0x000000000a197faeULL, 0x0003e6000d901c46ULL, 0x000000101b1b7824ULL, 0x000fc400078e0210ULL,
0x00000010110e7825ULL, 0x000fc600078e000eULL, 0x000000000c1b7faeULL, 0x0003e2000e101c46ULL,
0x000000101f1f7824ULL, 0x000fe400078e0210ULL, 0x0000001011027825ULL, 0x000fc600078e0002ULL,
0x000000000e1f7faeULL, 0x0003e2000e901c46ULL, 0x0000001023237824ULL, 0x000fca00078e0210ULL,
0x0000000002237faeULL, 0x0003e2000f101c46ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x002fe20000011600ULL, 0x000000087a137824ULL, 0x040fe200078e00ffULL,
0x000140007a127811ULL, 0x000fe400078e68ffULL, 0x0000000403047810ULL, 0x040fe40007ffe0ffULL,
0x0000000c03087810ULL, 0x040fe40007ffe0ffULL, 0x0000000803067810ULL, 0x000fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x040fe200078e00ffULL, 0x0000000004057212ULL, 0x080fe200078e3cffULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0x0000000006077212ULL, 0x040fe200078e3cffULL,
0x00000001210b7824ULL, 0x000fe200078e0208ULL, 0x00000003060c7819ULL, 0x000fc400000006ffULL,
0x0000000008097212ULL, 0x000fe400078e3cffULL, 0xfffffff80a177812ULL, 0x000fe200078ee205ULL,
0x0000000121057824ULL, 0x000fe200078e0203ULL, 0xfffffff80c197812ULL, 0x000fe400078ee207ULL,
0xfffffff80e1b7812ULL, 0x000fe200078ee209ULL, 0x0000001017177824ULL, 0x100fe200078e0212ULL,
0x00000010030a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001019197824ULL, 0x100fe200078e0212ULL,
0x00000014030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0212ULL,
0x00000018030e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080a1d7824ULL, 0x040fe200078e00ffULL,
0x0000001c03107810ULL, 0x000fe20007ffe0ffULL, 0x00000001210d7824ULL, 0x000fe200078e020aULL,
0x0000000703077812ULL, 0x000fe200078e4800ULL, 0x0000000121037824ULL, 0x040fe200078e0204ULL,
0x0000000621097210ULL, 0x040fe20007ffe0ffULL, 0x00000001210f7824ULL, 0x000fe200078e020cULL,
0x0ffffff807077812ULL, 0x000fe200078ef800ULL, 0x0000000121117824ULL, 0x040fe200078e020eULL,
0x000000000a067212ULL, 0x080fe200078e3cffULL, 0x0000000121237824ULL, 0x000fe200078e0210ULL,
0x000000000c087212ULL, 0x080fe200078e3cffULL, 0x000000080e217824ULL, 0x000fe200078e00ffULL,
0x000000030c1f7819ULL, 0x000fe200000006ffULL, 0x0000000810257824ULL, 0x000fe200078e00ffULL,
0x000000000e0a7212ULL, 0x000fe200078e3cffULL, 0x00005e0005047625ULL, 0x000fe200078e0002ULL,
0x00000000100c7212ULL, 0x000fc400078e3cffULL, 0x0000001207157211ULL, 0x000fe200078e20ffULL,
0x00005e000f0e7625ULL, 0x080fe200078e0002ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee206ULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x00005e0003067625ULL, 0x080fe200078e0002ULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee208ULL, 0xfffffff821217812ULL, 0x000fe200078ee20aULL,
0x00005e0009087625ULL, 0x000fe200078e0002ULL, 0xfffffff825257812ULL, 0x000fc400078ee20cULL,
0x000000121f1f7211ULL, 0x000fe200078e20ffULL, 0x00005e000b0a7625ULL, 0x000fc800078e0002ULL,
0x00005e000d0c7625ULL, 0x000fc800078e0002ULL, 0x0000001013047825ULL, 0x000fc800078e0004ULL,
0x00005e0011107625ULL, 0x080fe200078e0002ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e6000b901c46ULL, 0x00005e0023027625ULL, 0x000fc800078e0002ULL,
0x0000001013067825ULL, 0x000fc800078e0006ULL, 0x0000001013087825ULL, 0x040fe200078e0008ULL,
0x0000000006177faeULL, 0x0003e6000b901c46ULL, 0x00000010130a7825ULL, 0x040fe200078e000aULL,
0x0000000008197faeULL, 0x0003e6000b901c46ULL, 0x00000010130c7825ULL, 0x000fe200078e000cULL,
0x000000000a1b7faeULL, 0x0003e6000b901c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e0212ULL,
0x00000010130e7825ULL, 0x000fc600078e000eULL, 0x000000000c1d7faeULL, 0x0003e2000b901c46ULL,
0x0000001013107825ULL, 0x000fc600078e0010ULL, 0x000000000e1f7faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x000fe400078e0212ULL, 0x0000001013027825ULL, 0x000fc600078e0002ULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000001025257824ULL, 0x000fca00078e0212ULL,
0x0000000002257faeULL, 0x0003e4000b901c46ULL, 0x000000787b00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff347424ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x002fe2000001ff00ULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000000e7805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x000089e000000947ULL, 0x000fea0003800000ULL,
0xff31721700347802ULL, 0x000fe20000000f00ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x000001007b027824ULL, 0x000fca00078e00ffULL, 0x000000790200720cULL, 0x000fda0003f06070ULL,
0x0000895000000947ULL, 0x000fea0003800000ULL, 0x000000017b037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000780300720cULL, 0x000fe40003f06070ULL,
0x000000207b327811ULL, 0x000fca00078e40ffULL, 0x00006200351c7a24ULL, 0x000fcc00078e0232ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x000fe20000011600ULL,
0x00000200ff1d7424ULL, 0x000fe200078e00ffULL, 0x0000003279037217ULL, 0x000fe40007800000ULL,
0x000000041b197810ULL, 0x000fe40007ffe0ffULL, 0x0000000700097812ULL, 0x000fe400078ec0ffULL,
0x0000000332037210ULL, 0x000fe20007ffe1ffULL, 0x0000000819217824ULL, 0x040fe200078e00ffULL,
0x0000000019027212ULL, 0x000fe200078e3cffULL, 0x00000001361f7824ULL, 0x000fe200078e0209ULL,
0x00000020030a7817ULL, 0x000fe20003800000ULL, 0x0000000119087824ULL, 0x000fe200078e021cULL,
0xfffffff821217812ULL, 0x000fe200078ee202ULL, 0x000000011b027824ULL, 0x040fe200078e021cULL,
0x000000081b237810ULL, 0x000fc40007ffe0ffULL, 0x000000071b097812ULL, 0x040fe200078e4800ULL,
0x00005e0002027625ULL, 0x080fe200078e001dULL, 0x0000000c1b257810ULL, 0x040fe40007ffe0ffULL,
0x0000000a1b00720cULL, 0x080fe20003f26070ULL, 0x0000000823277824ULL, 0x000fe200078e00ffULL,
0x000150007a1e7811ULL, 0x000fe200078e68ffULL, 0x000000101f027825ULL, 0x000fe200078e0002ULL,
0x0000000a1900720cULL, 0x000fe40003f46070ULL, 0x0ffffff8090b7812ULL, 0x000fe200078ef800ULL,
0x00005e0008087625ULL, 0x000fe200078e001dULL, 0x0000000023187212ULL, 0x000fc400078e3cffULL,
0x00000000251a7212ULL, 0x000fe200078e3cffULL, 0x0000001021197824ULL, 0x100fe200078e021eULL,
0x0000000325297819ULL, 0x000fe200000006ffULL, 0x000000100b0b7824ULL, 0x000fe200078e021eULL,
0xfffffff827217812ULL, 0x000fe200078ee218ULL, 0x000000101f087825ULL, 0x000fe200078e0008ULL,
0xfffffff829277812ULL, 0x000fe400078ee21aULL, 0x000000101b297810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020b7faeULL, 0x0003e2000c901c46ULL,
0x000000141b2b7810ULL, 0x000fc40007ffe0ffULL, 0x000000181b2d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000008197faeULL, 0x0005e2000d101c46ULL, 0x0000001c1b1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000829207824ULL, 0x000fe200078e00ffULL, 0x0000000a2300720cULL, 0x080fe20003f26070ULL,
0x000000082b227824ULL, 0x000fe200078e00ffULL, 0x0000000a2500720cULL, 0x080fe20003f46070ULL,
0x000000082d247824ULL, 0x000fe200078e00ffULL, 0x0000000a2900720cULL, 0x080fe20003f66070ULL,
0x000000081b267824ULL, 0x000fe200078e00ffULL, 0x0000000a2b00720cULL, 0x080fe20003f86070ULL,
0x0000000123027824ULL, 0x102fe200078e021cULL, 0x0000000a2d00720cULL, 0x080fe20003fa6070ULL,
0x0000000125087824ULL, 0x104fe200078e021cULL, 0x0000000a1b00720cULL, 0x000fe20003fc6070ULL,
0x000000012b187824ULL, 0x100fe200078e021cULL, 0x0000001c290a7210ULL, 0x000fe20007ffe0ffULL,
0x000000012d1a7824ULL, 0x000fe200078e021cULL, 0x0000000029037212ULL, 0x000fc400078e3cffULL,
0x000000002b097212ULL, 0x080fe400078e3cffULL, 0x000000002d0b7212ULL, 0x080fe400078e3cffULL,
0x000000001b197212ULL, 0x040fe400078e3cffULL, 0x0000001c1b1c7210ULL, 0x000fe20007ffe0ffULL,
0x00005e001a1a7625ULL, 0x080fe200078e001dULL, 0xfffffff820237812ULL, 0x000fe400078ee203ULL,
0xfffffff822257812ULL, 0x000fe200078ee209ULL, 0x00005e0002027625ULL, 0x000fe200078e001dULL,
0xfffffff824297812ULL, 0x000fc400078ee20bULL, 0xfffffff8262b7812ULL, 0x000fe200078ee219ULL,
0x00005e0008087625ULL, 0x000fe200078e001dULL, 0x0000001e23237211ULL, 0x000fc600078e20ffULL,
0x00005e000a0a7625ULL, 0x000fc800078e001dULL, 0x00005e0018187625ULL, 0x000fc800078e001dULL,
0x00005e001c1c7625ULL, 0x000fc800078e001dULL, 0x000000101f027825ULL, 0x000fc800078e0002ULL,
0x000000101f087825ULL, 0x000fc800078e0008ULL, 0x000000101f0a7825ULL, 0x000fc800078e000aULL,
0x000000101f187825ULL, 0x000fc800078e0018ULL, 0x000000101f1a7825ULL, 0x000fc800078e001aULL,
0x000000101f1c7825ULL, 0x000fc800078e001cULL, 0x00000010211f7824ULL, 0x100fe400078e021eULL,
0x0000001027217824ULL, 0x100fe400078e021eULL, 0x0000001025257824ULL, 0x100fe200078e021eULL,
0x00000000021f7faeULL, 0x0003e2000c901c46ULL, 0x0000001029277824ULL, 0x100fe400078e021eULL,
0x000000102b297824ULL, 0x000fe200078e021eULL, 0x0000000008217faeULL, 0x0003e8000d101c46ULL,
0x000000000a237faeULL, 0x0003e8000d901c46ULL, 0x0000000018257faeULL, 0x0003e8000e101c46ULL,
0x000000001a277faeULL, 0x0003e8000e901c46ULL, 0x000000001c297faeULL, 0x0003e2000f101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x00000200ff217424ULL, 0x000fe200078e00ffULL, 0x0000000700097812ULL, 0x000fc400078ec0ffULL,
0x00000004030b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c031b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000136237824ULL, 0x000fe200078e0209ULL, 0x0000000803197810ULL, 0x000fe20007ffe0ffULL,
0x000000080b277824ULL, 0x040fe200078e00ffULL, 0x000000000b027212ULL, 0x080fe200078e3cffULL,
0x000000081b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000019087212ULL, 0x000fe200078e3cffULL,
0x000000011b187824ULL, 0x000fe200078e021cULL, 0x0000000319297819ULL, 0x000fc400000006ffULL,
0x0000000703097812ULL, 0x040fe400078e4800ULL, 0x00000010031d7810ULL, 0x000fe40007ffe0ffULL,
0x000000001b0a7212ULL, 0x000fe400078e3cffULL, 0x00000014031f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081d267824ULL, 0x000fe200078e00ffULL, 0x0000001803257810ULL, 0x000fe20007ffe0ffULL,
0x000000011d1a7824ULL, 0x000fe200078e021cULL, 0x0000001c032d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f287824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee202ULL,
0x0000000103027824ULL, 0x000fe200078e021cULL, 0xfffffff829297812ULL, 0x000fe200078ee208ULL,
0x00000008252a7824ULL, 0x040fe200078e00ffULL, 0x000150007a227811ULL, 0x000fe200078e68ffULL,
0x0000000125207824ULL, 0x000fe200078e021cULL, 0x0ffffff809097812ULL, 0x000fe200078ef800ULL,
0x000000012d247824ULL, 0x000fe200078e021cULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20aULL,
0x00000001190a7824ULL, 0x000fe200078e021cULL, 0x0000001c0b087210ULL, 0x000fe20007ffe0ffULL,
0x00005e0002027625ULL, 0x000fe200078e0021ULL, 0x000000001d0b7212ULL, 0x000fc400078e3cffULL,
0x000000001f197212ULL, 0x000fe200078e3cffULL, 0x0000001027277824ULL, 0x000fe200078e0222ULL,
0x0000001c1f1e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001023027825ULL, 0x000fe200078e0002ULL,
0x00000000251b7212ULL, 0x080fe400078e3cffULL, 0x000000002d1c7212ULL, 0x000fe200078e3cffULL,
0x0000001009257824ULL, 0x000fe200078e0222ULL, 0x000000032d377819ULL, 0x000fe200000006ffULL,
0x00005e0008087625ULL, 0x000fe200078e0021ULL, 0xfffffff8262d7812ULL, 0x000fc400078ee20bULL,
0xfffffff8282f7812ULL, 0x000fe200078ee219ULL, 0x00005e000a0a7625ULL, 0x080fe200078e0021ULL,
0xfffffff82a317812ULL, 0x000fe200078ee21bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002257faeULL, 0x0003e2000b901c46ULL, 0xfffffff837377812ULL, 0x000fe200078ee21cULL,
0x00005e0018187625ULL, 0x000fe200078e0021ULL, 0x000000222d2d7211ULL, 0x000fc600078e20ffULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1c7625ULL, 0x000fc800078e0021ULL,
0x00005e00201e7625ULL, 0x000fc800078e0021ULL, 0x00005e0024207625ULL, 0x000fc800078e0021ULL,
0x0000001023087825ULL, 0x000fc800078e0008ULL, 0x00000010230a7825ULL, 0x000fe200078e000aULL,
0x0000000008277faeULL, 0x0003e6000b901c46ULL, 0x0000001029297824ULL, 0x000fe400078e0222ULL,
0x0000001023187825ULL, 0x000fc600078e0018ULL, 0x000000000a297faeULL, 0x0003e2000b901c46ULL,
0x000000102b2b7824ULL, 0x000fe400078e0222ULL, 0x00000010231a7825ULL, 0x000fc600078e001aULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x00000010231c7825ULL, 0x000fc600078e001cULL,
0x000000001a2d7faeULL, 0x0003e2000b901c46ULL, 0x000000102f2f7824ULL, 0x000fe400078e0222ULL,
0x00000010231e7825ULL, 0x000fc600078e001eULL, 0x000000001c2f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031317824ULL, 0x000fe400078e0222ULL, 0x0000001023207825ULL, 0x000fc600078e0020ULL,
0x000000001e317faeULL, 0x0003e2000b901c46ULL, 0x0000001037377824ULL, 0x000fca00078e0222ULL,
0x0000000020377faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080036027f8cULL, 0x002fe8000c80043fULL,
0x01c60c0036097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007824803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff087424ULL, 0x000fc800078e00ffULL,
0x0000000800097305ULL, 0x0002a4000021f000ULL, 0x3fa0000008087823ULL, 0x002fe200000100ffULL,
0x000000090000735dULL, 0x004fe40003800000ULL, 0x01c60c0036097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007824803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400317819ULL, 0x000fe400000006ffULL, 0x00000001ff027819ULL, 0x000fe40000011600ULL,
0x0000007031317812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fca00078ec0ffULL,
0x0000000131317824ULL, 0x000fca00078e0202ULL, 0x01c0000031037984ULL, 0x000e680000000800ULL,
0x01c2000031027984ULL, 0x0004e20000000800ULL, 0x000000340300720bULL, 0x002fe20003f3d000ULL,
0x00012ce27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800008e0100ULL,
0x0000ffff080a7812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000ff7a00720cULL, 0x000fe40003f25270ULL, 0x000000340300720bULL, 0x000fe20003f54000ULL,
0x00012cc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x0000000334187209ULL, 0x000fe40007810000ULL, 0x0000ffff080b7812ULL, 0x000fe400078e3cffULL,
0x00000002ff087819ULL, 0x000fe20000011600ULL, 0x8000001834097221ULL, 0x000fe20000010000ULL,
0x01c4001831009388ULL, 0x0003e20000000800ULL, 0x0000000b0aff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009004b7308ULL, 0x0002a20000000800ULL,
0x00012c827f007947ULL, 0x000fec000b800000ULL, 0x00001f084b097589ULL, 0x0062a400000e0000ULL,
0x0000000808087810ULL, 0x002fe20007ffe0ffULL, 0x00012cc27f007947ULL, 0x000fea000b800000ULL,
0x00001f084b087589ULL, 0x00032400000e0000ULL, 0x8000001803031221ULL, 0x000fe20000010000ULL,
0x0000001800347202ULL, 0x000fe20000000f00ULL, 0x0000000807077220ULL, 0x090fe40000410000ULL,
0x3fb8aa3b03031820ULL, 0x000fe40000410000ULL, 0x0000000806067220ULL, 0x080fe40000410000ULL,
0x0000000300301308ULL, 0x000f220000000800ULL, 0x0000000847477220ULL, 0x000fc40000410000ULL,
0x0000000846467220ULL, 0x080fe40000410000ULL, 0x0000000843437220ULL, 0x080fe40000410000ULL,
0x0000000842427220ULL, 0x080fe40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x000000083a3a7220ULL, 0x080fe40000410000ULL, 0x000000083f3f7220ULL, 0x000fc40000410000ULL,
0x000000083e3e7220ULL, 0x080fe40000410000ULL, 0x0000000817177220ULL, 0x080fe40000410000ULL,
0x0000000816167220ULL, 0x080fe40000410000ULL, 0x0000000813137220ULL, 0x080fe40000410000ULL,
0x0000000812127220ULL, 0x080fe40000410000ULL, 0x000000080f0f7220ULL, 0x000fc40000410000ULL,
0x000000080e0e7220ULL, 0x000fe20000410000ULL, 0x00000001ff087807ULL, 0x000fe20000800000ULL,
0x0000004b33337220ULL, 0x000fe40000410000ULL, 0x0000000905057220ULL, 0x084fe40000410000ULL,
0x0000000904047220ULL, 0x080fe40000410000ULL, 0x0000000945457220ULL, 0x080fe40000410000ULL,
0x0000000944447220ULL, 0x000fc40000410000ULL, 0x0000000941417220ULL, 0x080fe40000410000ULL,
0x0000000940407220ULL, 0x080fe40000410000ULL, 0x0000000939397220ULL, 0x080fe40000410000ULL,
0x0000000938387220ULL, 0x080fe40000410000ULL, 0x000000093d3d7220ULL, 0x080fe40000410000ULL,
0x000000093c3c7220ULL, 0x000fc40000410000ULL, 0x0000000915157220ULL, 0x080fe40000410000ULL,
0x0000000914147220ULL, 0x080fe40000410000ULL, 0x0000000911117220ULL, 0x080fe40000410000ULL,
0x0000000910107220ULL, 0x080fe40000410000ULL, 0x000000090d0d7220ULL, 0x080fe40000410000ULL,
0x000000090c0c7220ULL, 0x000fc40000410000ULL, 0x0000003002021220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000003302337221ULL, 0x008fe20000010000ULL,
0x00000030ff02723eULL, 0x000fe200000000ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff2c7819ULL, 0x000fe40000011600ULL, 0x00005410024b7816ULL, 0x002fe20000000002ULL,
0x00012a427f007947ULL, 0x000fea000b800000ULL, 0x000000082c2f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f2c4b617589ULL, 0x0002a800000e0000ULL, 0x00001f2f4b207589ULL, 0x0002e400000e0000ULL,
0x000000102c2e7810ULL, 0x000fe20007ffe0ffULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4c7224ULL, 0x002fe200078e002eULL, 0x0000001f004d7802ULL, 0x000fe20000000f00ULL,
0xffffffffff4e7424ULL, 0x000fe200078e00ffULL, 0x0000243000487802ULL, 0x000fc40000000f00ULL,
0x0001386000007944ULL, 0x00cfea0003c00000ULL, 0x000000182c2c7810ULL, 0x002fe20007ffe0ffULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e002cULL,
0x000024a000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x000137f000007944ULL, 0x00cfea0003c00000ULL,
0x00000007002d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004ff037819ULL, 0x100fe40000011600ULL, 0x000000082d587812ULL, 0x000fe400078ef800ULL,
0x0000000800097812ULL, 0x000fe400078ec0ffULL, 0x00000007032b7812ULL, 0x000fc800078e7858ULL,
0x0000002b582b7211ULL, 0x000fc800078e18ffULL, 0x000120002b187811ULL, 0x000fca00078e20ffULL,
0x00000007090a7812ULL, 0x140fe200078ec800ULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x0000000709027812ULL, 0x000fe400078ef800ULL, 0x0000000203097810ULL, 0x040fe40007ffe0ffULL,
0x00000004031d7810ULL, 0x040fe40007ffe0ffULL, 0x00000006031f7810ULL, 0x000fe40007ffe0ffULL,
0x000000030a037212ULL, 0x000fc400078e3cffULL, 0x000000090a0b7212ULL, 0x000fe400078e3cffULL,
0x000140007a2a7811ULL, 0x000fe200078e68ffULL, 0x00000008025b7824ULL, 0x000fe200078e0203ULL,
0x0000001d0a377212ULL, 0x000fe200078e3cffULL, 0x0000000802607824ULL, 0x000fe200078e020bULL,
0x0000001f0a217212ULL, 0x000fe200078e3cffULL, 0x000000105b297824ULL, 0x000fe200078e022aULL,
0x0000000709257812ULL, 0x000fe200078e7858ULL, 0x00000008025a7824ULL, 0x040fe200078e0237ULL,
0x0000002102597211ULL, 0x000fe200078e18ffULL, 0x0000001060287824ULL, 0x100fe200078e022aULL,
0x00000000291c783bULL, 0x000f620000004200ULL, 0x000000105a277824ULL, 0x100fe200078e022aULL,
0x0000008002647811ULL, 0x000fe200078e18ffULL, 0x0000001059267824ULL, 0x000fe200078e022aULL,
0x000000002848783bULL, 0x006e620000004200ULL, 0x0000000858257824ULL, 0x000fe200078e0225ULL,
0x0000006403027210ULL, 0x000fe20007ffe0ffULL, 0x000000010b037824ULL, 0x100fe200078e0264ULL,
0x000000002750783bULL, 0x000fe20000004200ULL, 0x0000991008087816ULL, 0x000fe200000000ffULL,
0x0000000137377824ULL, 0x000fe200078e0264ULL, 0x00012000254c7811ULL, 0x000fe200078e20ffULL,
0x000000002654783bULL, 0x000fe20000004200ULL, 0x0000001002247824ULL, 0x000fe200078e022aULL,
0x000000ff0800720cULL, 0x000fe20003f25270ULL, 0x0000000121647824ULL, 0x000fe200078e0264ULL,
0x0000002a03237211ULL, 0x000fe200078e20ffULL, 0x000000004c4c783bULL, 0x000ea20000000200ULL,
0x0000001037227824ULL, 0x000fc400078e022aULL, 0x0000001064217824ULL, 0x000fe200078e022aULL,
0x00000000246c783bULL, 0x000ee80000004200ULL, 0x000000002368783bULL, 0x000ee40000004200ULL,
0x0000006118189232ULL, 0x090fe40000000000ULL, 0x00000000225c783bULL, 0x000f220000004200ULL,
0x000000611a1a9232ULL, 0x000fc40000000000ULL, 0x0000002019199232ULL, 0x088fe20000000000ULL,
0x000000002108783bULL, 0x000ee20000004200ULL, 0x000000201b1b9232ULL, 0x000fce0000000000ULL,
0x0000001c180c723cULL, 0x060ff0000000180cULL, 0x0000001e1810723cULL, 0x040ff00000001810ULL,
0x000000481814723cULL, 0x002fe20000001814ULL, 0x000000614c4c9232ULL, 0x004fc40000000000ULL,
0x000000614e4e9232ULL, 0x000fe40000000000ULL, 0x000000204d4d9232ULL, 0x080fe40000000000ULL,
0x000000204f4f9232ULL, 0x000fe20000000000ULL, 0x0000004a183c723cULL, 0x040ff0000000183cULL,
0x000000521840723cULL, 0x040ff00000001840ULL, 0x000000501838723cULL, 0x040ff00000001838ULL,
0x00000054181c723cULL, 0x040ff00000001844ULL, 0x000000561804723cULL, 0x000ff00000001804ULL,
0x0000006c4c44723cULL, 0x040fee000000180cULL, 0x00000020326c7810ULL, 0x000fe20007ffe0ffULL,
0x0000006e4c0c723cULL, 0x000fe80000001810ULL, 0x0000620035187a24ULL, 0x000fc800078e026cULL,
0x000000684c10723cULL, 0x040ff00000001814ULL, 0x0000006a4c14723cULL, 0x040ff0000000183cULL,
0x0000005e4c3c723cULL, 0x050ff00000001840ULL, 0x0000005c4c38723cULL, 0x040ff00000001838ULL,
0x000000084c40723cULL, 0x048ff0000000181cULL, 0x0000000a4c4c723cULL, 0x000fe20000001804ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff0b7819ULL, 0x000fe20000011600ULL, 0x00000200ff197424ULL, 0x000fe200078e00ffULL,
0x0000006c79057217ULL, 0x000fe20007800000ULL, 0x00000001361b7824ULL, 0x000fe200078e022dULL,
0x000000040b097810ULL, 0x040fe40007ffe0ffULL, 0x000000080b497810ULL, 0x000fe20007ffe0ffULL,
0x0000000105057824ULL, 0x000fe200078e0a6cULL, 0x0000000009047212ULL, 0x040fe200078e3cffULL,
0x00000008091f7824ULL, 0x000fe200078e00ffULL, 0x000000100b557810ULL, 0x000fe20007ffe0ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0x0000000c0b517810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x0000000855087824ULL, 0x000fe200078e00ffULL,
0x0000000049047212ULL, 0x080fe400078e3cffULL, 0x0000000055077212ULL, 0x080fe400078e3cffULL,
0x0000000051067212ULL, 0x040fe400078e3cffULL, 0x0000000351537819ULL, 0x000fe400000006ffULL,
0xfffffff84b4b7812ULL, 0x000fc400078ee204ULL, 0x00000020050a7817ULL, 0x000fe40003800000ULL,
0xfffffff808577812ULL, 0x000fe200078ee207ULL, 0x0000000149087824ULL, 0x000fe200078e0218ULL,
0x000000180b047210ULL, 0x000fe20007ffe0ffULL, 0x000000104b4b7824ULL, 0x000fe200078e022aULL,
0xfffffff853537812ULL, 0x000fe200078ee206ULL, 0x0000000109067824ULL, 0x000fe200078e0218ULL,
0x000000070b077812ULL, 0x040fe200078e4800ULL, 0x00005e0004047625ULL, 0x000fe200078e0019ULL,
0x0000000a0b00720cULL, 0x000fc40003f46070ULL, 0x0000000a0900720cULL, 0x080fe20003f66070ULL,
0x00005e0008087625ULL, 0x080fe200078e0019ULL, 0x0ffffff8071d7812ULL, 0x000fe400078ef800ULL,
0x0000000a4900720cULL, 0x000fe20003f86070ULL, 0x00005e0006067625ULL, 0x000fe200078e0019ULL,
0x000000140b5d7810ULL, 0x000fe40007ffe0ffULL, 0x0000002a1f1f7211ULL, 0x000fe200078e20ffULL,
0x000000101d1d7824ULL, 0x000fe200078e022aULL, 0x000000005d1a7212ULL, 0x040fe200078e3cffULL,
0x000000085d497824ULL, 0x000fe200078e00ffULL, 0x000000180b5f7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b047825ULL, 0x000fe200078e0004ULL, 0x0000001c0b617810ULL, 0x000fc40007ffe0ffULL,
0xfffffff849497812ULL, 0x000fe200078ee21aULL, 0x000000101b067825ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000d101c46ULL,
0x000000005f0b7212ULL, 0x000fe400078e3cffULL, 0x000000101b087825ULL, 0x000fe200078e0008ULL,
0x00000000061f7faeULL, 0x0005e2000d901c46ULL, 0x0000000a5100720cULL, 0x080fe40003f46070ULL,
0x000000085f1a7824ULL, 0x000fe200078e00ffULL, 0x00000000084b7faeULL, 0x0007e2000e101c46ULL,
0x0000000a5500720cULL, 0x080fe20003f66070ULL, 0x0000001053537824ULL, 0x000fe200078e022aULL,
0x0000000a5d00720cULL, 0x080fe20003f86070ULL, 0x0000000151047824ULL, 0x002fe200078e0218ULL,
0x0000000a5f00720cULL, 0x080fe20003fa6070ULL, 0x0000001049497824ULL, 0x000fe200078e022aULL,
0x0000000a6100720cULL, 0x000fe20003fc6070ULL, 0x0000000155067824ULL, 0x104fe200078e0218ULL,
0xfffffff81a1d7812ULL, 0x000fe200078ee20bULL, 0x000000015f0a7824ULL, 0x100fe200078e0218ULL,
0x00000000611a7212ULL, 0x040fe200078e3cffULL, 0x00000008611f7824ULL, 0x000fe200078e00ffULL,
0x000000185d087210ULL, 0x008fe20007ffe0ffULL, 0x0000000161187824ULL, 0x000fe200078e0218ULL,
0x0000002a57577211ULL, 0x000fe200078e20ffULL, 0x00005e0004047625ULL, 0x000fe200078e0019ULL,
0xfffffff81f1f7812ULL, 0x000fc600078ee21aULL, 0x00005e0006067625ULL, 0x000fc800078e0019ULL,
0x00005e0008087625ULL, 0x000fc800078e0019ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0019ULL,
0x00005e0018187625ULL, 0x000fc800078e0019ULL, 0x000000101b047825ULL, 0x000fc800078e0004ULL,
0x000000101b067825ULL, 0x040fe200078e0006ULL, 0x0000000004537faeULL, 0x0003e6000d101c46ULL,
0x000000101b087825ULL, 0x040fe200078e0008ULL, 0x0000000006577faeULL, 0x0003e6000d901c46ULL,
0x000000101b0a7825ULL, 0x000fe200078e000aULL, 0x0000000008497faeULL, 0x0003e6000e101c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e022aULL, 0x000000101b187825ULL, 0x000fc600078e0018ULL,
0x000000000a1d7faeULL, 0x0003e2000e901c46ULL, 0x000000101f1f7824ULL, 0x000fca00078e022aULL,
0x00000000181f7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fe20000011600ULL, 0x00000200ff1f7424ULL, 0x000fe400078e00ffULL,
0x0000000136497824ULL, 0x000fe200078e022dULL, 0x0000000c05197810ULL, 0x040fe40007ffe0ffULL,
0x0000000405097810ULL, 0x000fe40007ffe0ffULL, 0x0000000019077212ULL, 0x0c0fe200078e3cffULL,
0x0000000819087824ULL, 0x000fe200078e00ffULL, 0x00000008050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809517824ULL, 0x040fe200078e00ffULL, 0x0000000009047212ULL, 0x080fe200078e3cffULL,
0x00000001190a7824ULL, 0x100fe200078e0218ULL, 0xfffffff808557812ULL, 0x000fe200078ee207ULL,
0x000000010b087824ULL, 0x040fe200078e0218ULL, 0x000000000b067212ULL, 0x000fc400078e3cffULL,
0x000000030b537819ULL, 0x000fe200000006ffULL, 0x0000001055557824ULL, 0x000fe200078e022aULL,
0x0000000705077812ULL, 0x040fe400078e4800ULL, 0x00000010051b7810ULL, 0x040fe40007ffe0ffULL,
0x00000014051d7810ULL, 0x040fe40007ffe0ffULL, 0x00000018054b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081b487824ULL, 0x000fe200078e00ffULL, 0x0000001c05577810ULL, 0x000fe20007ffe0ffULL,
0x000000081d4a7824ULL, 0x000fe200078e00ffULL, 0xfffffff851517812ULL, 0x000fe200078ee204ULL,
0x0000000105047824ULL, 0x000fe200078e0218ULL, 0xfffffff853537812ULL, 0x000fe200078ee206ULL,
0x000000011b1a7824ULL, 0x000fe200078e0218ULL, 0x0ffffff807077812ULL, 0x000fe200078ef800ULL,
0x000000014b1e7824ULL, 0x100fe200078e0218ULL, 0x0000001809067210ULL, 0x000fe20007ffe0ffULL,
0x0000000157207824ULL, 0x000fe200078e0218ULL, 0x000000001b097212ULL, 0x000fe200078e3cffULL,
0x000000084b5f7824ULL, 0x000fe200078e00ffULL, 0x000000181d1c7210ULL, 0x040fe20007ffe0ffULL,
0x00005e0004047625ULL, 0x000fe200078e001fULL, 0x000000001d0b7212ULL, 0x000fc400078e3cffULL,
0x000000004b187212ULL, 0x080fe200078e3cffULL, 0x00000010074b7824ULL, 0x000fe200078e022aULL,
0x0000000057197212ULL, 0x040fe200078e3cffULL, 0x00005e0006067625ULL, 0x080fe200078e001fULL,
0x0000000357507819ULL, 0x000fe400000006ffULL, 0xfffffff848577812ULL, 0x000fe200078ee209ULL,
0x00005e0008087625ULL, 0x080fe200078e001fULL, 0xfffffff84a5d7812ULL, 0x000fe400078ee20bULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee218ULL, 0x00005e000a0a7625ULL, 0x000fe200078e001fULL,
0xfffffff850617812ULL, 0x000fc400078ee219ULL, 0x0000002a57577211ULL, 0x000fe200078e20ffULL,
0x00005e001a187625ULL, 0x000fc800078e001fULL, 0x00005e001c1a7625ULL, 0x000fc800078e001fULL,
0x0000001049047825ULL, 0x000fc800078e0004ULL, 0x00005e001e1c7625ULL, 0x080fe200078e001fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000044b7faeULL, 0x0003e6000b901c46ULL,
0x00005e00201e7625ULL, 0x000fc800078e001fULL, 0x0000001051517824ULL, 0x000fe400078e022aULL,
0x0000001049067825ULL, 0x000fc800078e0006ULL, 0x0000001053537824ULL, 0x000fe200078e022aULL,
0x0000000006517faeULL, 0x0003e2000b901c46ULL, 0x0000001049087825ULL, 0x000fc800078e0008ULL,
0x00000010490a7825ULL, 0x040fe200078e000aULL, 0x0000000008537faeULL, 0x0003e6000b901c46ULL,
0x0000001049187825ULL, 0x040fe200078e0018ULL, 0x000000000a557faeULL, 0x0003e6000b901c46ULL,
0x00000010491a7825ULL, 0x000fe200078e001aULL, 0x0000000018577faeULL, 0x0003e6000b901c46ULL,
0x000000105d5d7824ULL, 0x000fc400078e022aULL, 0x00000010491c7825ULL, 0x000fc600078e001cULL,
0x000000001a5d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e022aULL,
0x00000010491e7825ULL, 0x000fc600078e001eULL, 0x000000001c5f7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x000fca00078e022aULL, 0x000000001e617faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000400057811ULL, 0x002fe400078fe0ffULL,
0x000010002a1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000705057812ULL, 0x000fe400078e7858ULL,
0x0000001f5b1e7211ULL, 0x000fe200078e20ffULL, 0x00000010601c7824ULL, 0x000fe200078e021fULL,
0x00000030ff04723eULL, 0x000fe200000000ffULL, 0x0000000858207824ULL, 0x000fe200078e0205ULL,
0x0000000600057811ULL, 0x000fe200078fe0ffULL, 0x000000105a1b7824ULL, 0x100fe200078e021fULL,
0x00000002ff6d7819ULL, 0x000fe20000011600ULL, 0x00000010591a7824ULL, 0x100fe200078e021fULL,
0x0001200020507811ULL, 0x000fe200078e20ffULL, 0x0000001003187824ULL, 0x100fe200078e021fULL,
0x0000000705057812ULL, 0x000fe200078e7858ULL, 0x0000001037037824ULL, 0x000fe200078e021fULL,
0x0000541004707816ULL, 0x000fc40000000004ULL, 0x0000001f02197211ULL, 0x000fe200078e20ffULL,
0x00000008581d7824ULL, 0x000fe200078e0205ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000005050783bULL, 0x000fe20000000200ULL, 0x000120001d047811ULL, 0x000fe200078e20ffULL,
0x0000001064027824ULL, 0x000fe400078e021fULL, 0x000000001e54783bULL, 0x000fe80000004200ULL,
0x000000001c60783bULL, 0x000fe80000004200ULL, 0x000000001b5c783bULL, 0x000fe80000004200ULL,
0x000000001a58783bULL, 0x000fe80000004200ULL, 0x00001f6d706d7589ULL, 0x000e6800000e0000ULL,
0x00001f2f706e7589ULL, 0x000ea800000e0000ULL, 0x000000000404783bULL, 0x000ee80000000200ULL,
0x000000001968783bULL, 0x000f280000004200ULL, 0x000000001864783bULL, 0x000f680000004200ULL,
0x000000000348783bULL, 0x000f280000004200ULL, 0x000000000208783bULL, 0x000f220000004200ULL,
0x0000006d50509232ULL, 0x002fc40000000000ULL, 0x0000006d52529232ULL, 0x000fe40000000000ULL,
0x0000006e51519232ULL, 0x084fe40000000000ULL, 0x0000006e53539232ULL, 0x000fce0000000000ULL,
0x000000545044723cULL, 0x040ff00000001844ULL, 0x000000605070723cULL, 0x000fe20000001810ULL,
0x0000006d04049232ULL, 0x088fe40000000000ULL, 0x0000006d06069232ULL, 0x000fc40000000000ULL,
0x0000006e05059232ULL, 0x000fc60000000000ULL, 0x0000005c5038723cULL, 0x000fe20000001838ULL,
0x0000006e07079232ULL, 0x000fce0000000000ULL, 0x0000005e5074723cULL, 0x040ff0000000183cULL,
0x000000565054723cULL, 0x040ff0000000180cULL, 0x000000625060723cULL, 0x040ff00000001814ULL,
0x00000058505c723cULL, 0x040ff00000001840ULL, 0x0000005a504c723cULL, 0x000ff0000000184cULL,
0x00000068040c723cULL, 0x050ff00000001844ULL, 0x0000006a0410723cULL, 0x040ff00000001854ULL,
0x000000640414723cULL, 0x060ff00000001870ULL, 0x00000066043c723cULL, 0x040ff00000001860ULL,
0x000000480438723cULL, 0x040ff00000001838ULL, 0x0000004a0440723cULL, 0x040ff00000001874ULL,
0x000000080444723cULL, 0x040ff0000000185cULL, 0x0000000a0404723cULL, 0x000fe2000000184cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000796c00720cULL, 0x000fe20003f26070ULL,
0x01c68800ffff7f8cULL, 0x000fd8000c80043fULL, 0x0000640000001947ULL, 0x000fea0003800000ULL,
0x00000040320a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00006200354e7a24ULL, 0x000fe200078e020aULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff4d7819ULL, 0x000fe20000011600ULL, 0x00000200ff4f7424ULL, 0x000fe200078e00ffULL,
0x0000000a79087217ULL, 0x000fe20007800000ULL, 0x0000000136517824ULL, 0x000fe200078e022dULL,
0x000000044d497810ULL, 0x000fe40007ffe0ffULL, 0x000000080a087210ULL, 0x000fe40007ffe1ffULL,
0x0000000049097212ULL, 0x040fe200078e3cffULL, 0x00000008494a7824ULL, 0x040fe200078e00ffULL,
0x0000002008377817ULL, 0x000fe20003800000ULL, 0x00000001490a7824ULL, 0x000fe200078e024eULL,
0x0000000c4d557810ULL, 0x000fc40007ffe0ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee209ULL,
0x000000014d097824ULL, 0x040fe200078e024eULL, 0x000000074d0b7812ULL, 0x100fe200078e4800ULL,
0x0000000855597824ULL, 0x000fe200078e00ffULL, 0x000000084d537810ULL, 0x000fe20007ffe0ffULL,
0x00005e0009087625ULL, 0x000fe200078e004fULL, 0x000000374d00720cULL, 0x080fe40003f26070ULL,
0x000000374900720cULL, 0x000fe20003f46070ULL, 0x000000104a4b7824ULL, 0x000fe200078e021fULL,
0x0ffffff80b487812ULL, 0x000fe200078ef800ULL, 0x00005e000a0a7625ULL, 0x000fe200078e004fULL,
0x00000000534c7212ULL, 0x000fc400078e3cffULL, 0x0000000353577819ULL, 0x000fe200000006ffULL,
0x0000001048497824ULL, 0x000fe200078e021fULL, 0x0000000055527212ULL, 0x000fe200078e3cffULL,
0x0000001051087825ULL, 0x000fe200078e0008ULL, 0xfffffff857507812ULL, 0x000fe400078ee24cULL,
0xfffffff859527812ULL, 0x000fe200078ee252ULL, 0x00000010510a7825ULL, 0x000fe200078e000aULL,
0x000000104d577810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008497faeULL, 0x0003e2000c901c46ULL, 0x000000144d597810ULL, 0x000fc40007ffe0ffULL,
0x000000184d5b7810ULL, 0x040fe20007ffe0ffULL, 0x000000000a4b7faeULL, 0x0005e2000d101c46ULL,
0x0000001c4d4d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000857547824ULL, 0x000fe200078e00ffULL,
0x0000004e5b4c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000859567824ULL, 0x000fe200078e00ffULL,
0x000000375300720cULL, 0x080fe20003f26070ULL, 0x000000084d5a7824ULL, 0x040fe200078e00ffULL,
0x000000374d00720cULL, 0x000fe20003fc6070ULL, 0x0000000153087824ULL, 0x102fe200078e024eULL,
0x0000000057097212ULL, 0x0c0fe200078e3cffULL, 0x0000000157487824ULL, 0x100fe200078e024eULL,
0x000000004d497212ULL, 0x000fe200078e3cffULL, 0x00000001594a7824ULL, 0x100fe200078e024eULL,
0x0000004e550a7210ULL, 0x004fe20007ffe0ffULL, 0x000000014d4e7824ULL, 0x000fe200078e024eULL,
0x00000000590b7212ULL, 0x000fe200078e3cffULL, 0x00005e004a4a7625ULL, 0x000fe200078e004fULL,
0xfffffff854547812ULL, 0x000fc400078ee209ULL, 0xfffffff856567812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x000fe200078e004fULL, 0xfffffff85a5a7812ULL, 0x000fe400078ee249ULL,
0x000000375500720cULL, 0x000fe20003f46070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e004fULL,
0x000000375700720cULL, 0x080fe40003f66070ULL, 0x000000375900720cULL, 0x000fe20003f86070ULL,
0x00005e0048487625ULL, 0x000fe200078e004fULL, 0x000000375b00720cULL, 0x000fc40003fa6070ULL,
0x000000005b377212ULL, 0x000fe200078e3cffULL, 0x00005e004c4c7625ULL, 0x000fc800078e004fULL,
0x000000085b587824ULL, 0x000fe400078e00ffULL, 0x00005e004e4e7625ULL, 0x000fc600078e004fULL,
0xfffffff858587812ULL, 0x000fe200078ee237ULL, 0x0000001050377824ULL, 0x000fe400078e021fULL,
0x0000001051087825ULL, 0x000fc800078e0008ULL, 0x00000010510a7825ULL, 0x040fe200078e000aULL,
0x0000000008377faeULL, 0x0003e6000c901c46ULL, 0x0000001051487825ULL, 0x000fc800078e0048ULL,
0x00000010514a7825ULL, 0x000fc800078e004aULL, 0x00000010514c7825ULL, 0x000fc800078e004cULL,
0x00000010514e7825ULL, 0x000fe200078e004eULL, 0x0000001f52517211ULL, 0x000fc600078e20ffULL,
0x0000001054537824ULL, 0x100fe400078e021fULL, 0x0000001056557824ULL, 0x100fe200078e021fULL,
0x000000000a517faeULL, 0x0003e2000d101c46ULL, 0x0000001058577824ULL, 0x100fe400078e021fULL,
0x000000105a597824ULL, 0x000fe200078e021fULL, 0x0000000048537faeULL, 0x0003e8000d901c46ULL,
0x000000004a557faeULL, 0x0003e8000e101c46ULL, 0x000000004c577faeULL, 0x0003e8000e901c46ULL,
0x000000004e597faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011600ULL, 0x00000200ff537424ULL, 0x000fc600078e00ffULL,
0x0000000c094d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008094b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000409497810ULL, 0x000fe20007ffe0ffULL, 0x000000084d587824ULL, 0x040fe200078e00ffULL,
0x000000004d0b7212ULL, 0x080fe200078e3cffULL, 0x000000084b4f7824ULL, 0x040fe200078e00ffULL,
0x000000004b0a7212ULL, 0x080fe200078e3cffULL, 0x0000000149487824ULL, 0x140fe200078e024eULL,
0x0000000049087212ULL, 0x000fe200078e3cffULL, 0x000000014b4a7824ULL, 0x100fe200078e024eULL,
0x0000000349377819ULL, 0x000fe200000006ffULL, 0x000000014d4c7824ULL, 0x000fe200078e024eULL,
0xfffffff858587812ULL, 0x000fc400078ee20bULL, 0xfffffff84f567812ULL, 0x000fe400078ee20aULL,
0x00000007090b7812ULL, 0x040fe400078e4800ULL, 0x0000001409517810ULL, 0x040fe20007ffe0ffULL,
0x0000001056597824ULL, 0x000fe200078e021fULL, 0x00000010094f7810ULL, 0x040fe40007ffe0ffULL,
0x0000001c09577810ULL, 0x000fe20007ffe0ffULL, 0x00000008515c7824ULL, 0x000fe200078e00ffULL,
0xfffffff837547812ULL, 0x000fe200078ee208ULL, 0x000000014f507824ULL, 0x100fe200078e024eULL,
0x0000001809557810ULL, 0x000fe20007ffe0ffULL, 0x0000000857647824ULL, 0x000fe200078e00ffULL,
0x0000004e09087210ULL, 0x000fe20007ffe0ffULL, 0x0000000151527824ULL, 0x000fe200078e024eULL,
0x0ffffff80b0a7812ULL, 0x000fe200078ef800ULL, 0x00000001555e7824ULL, 0x000fe200078e024eULL,
0x000000004f0b7212ULL, 0x040fe200078e3cffULL, 0x00005e0008087625ULL, 0x000fe200078e0053ULL,
0x000000034f5a7819ULL, 0x000fc400000006ffULL, 0x0000000051497212ULL, 0x080fe200078e3cffULL,
0x0000000136377824ULL, 0x000fe200078e022dULL, 0x00000000554b7212ULL, 0x080fe200078e3cffULL,
0x0000000157627824ULL, 0x000fe200078e024eULL, 0x0000000355607819ULL, 0x000fe200000006ffULL,
0x000000100a557824ULL, 0x000fe200078e021fULL, 0x00000000574d7212ULL, 0x000fe200078e3cffULL,
0x00005e00524e7625ULL, 0x080fe200078e0053ULL, 0xfffffff85a5a7812ULL, 0x000fe400078ee20bULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee249ULL, 0x00005e00480a7625ULL, 0x000fe200078e0053ULL,
0xfffffff860607812ULL, 0x000fc400078ee24bULL, 0xfffffff864647812ULL, 0x000fe200078ee24dULL,
0x00005e004a487625ULL, 0x000fc800078e0053ULL, 0x00005e004c4a7625ULL, 0x000fc800078e0053ULL,
0x00005e00504c7625ULL, 0x000fc800078e0053ULL, 0x00005e005e507625ULL, 0x000fc800078e0053ULL,
0x0000001037087825ULL, 0x000fc800078e0008ULL, 0x00005e0062527625ULL, 0x000fe200078e0053ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008557faeULL, 0x0003e6000b901c46ULL,
0x0000001054577824ULL, 0x000fe400078e021fULL, 0x00000010370a7825ULL, 0x000fc800078e000aULL,
0x0000001037487825ULL, 0x040fe200078e0048ULL, 0x000000000a577faeULL, 0x0005e2000b901c46ULL,
0x0000001f58097211ULL, 0x002fe400078e20ffULL, 0x00000010374a7825ULL, 0x040fe200078e004aULL,
0x0000000048597faeULL, 0x0005e6000b901c46ULL, 0x00000010374c7825ULL, 0x040fe200078e004cULL,
0x000000004a097faeULL, 0x0005e6000b901c46ULL, 0x00000010374e7825ULL, 0x000fc800078e004eULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001037527825ULL, 0x000fc800078e0052ULL,
0x000000105a377824ULL, 0x100fe400078e021fULL, 0x000000105c557824ULL, 0x100fe400078e021fULL,
0x00000010605b7824ULL, 0x100fe200078e021fULL, 0x000000004c377faeULL, 0x0005e2000b901c46ULL,
0x00000010645d7824ULL, 0x000fc600078e021fULL, 0x000000004e557faeULL, 0x0005e8000b901c46ULL,
0x00000000505b7faeULL, 0x0005e8000b901c46ULL, 0x00000000525d7faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6280036087f8cULL, 0x006fe8000c80043fULL, 0x01c62c00360b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007824809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x3e000000000a7802ULL, 0x000fc80000000f00ULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x01c62c00360b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007824809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000009947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c08000310b7984ULL, 0x000e680000000800ULL,
0x01c28000310a7984ULL, 0x0004e20000000800ULL, 0x000000340b00720bULL, 0x002fe20003f3d000ULL,
0x00010ac27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800008e0100ULL,
0x0000ffff08497812ULL, 0x000fe2000782c0ffULL, 0x000003b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fd600078e00ffULL, 0x0000038000009947ULL, 0x000fea0003800000ULL,
0x000000017a00780cULL, 0x000fe40003f25270ULL, 0x000000340b00720bULL, 0x000fe20003f54000ULL,
0x00010aa27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fe400010e0100ULL,
0x0000000b34097209ULL, 0x000fe40007810000ULL, 0x0000ffff08087812ULL, 0x000fe400078e3cffULL,
0x00000002ff4c7819ULL, 0x000fe20000011600ULL, 0x8000000934377221ULL, 0x000fe20000010000ULL,
0x01c4800931009388ULL, 0x0003e20000000800ULL, 0x0000000849ff7212ULL, 0x000fc4000782c0ffULL,
0x3fb8aa3b37377820ULL, 0x000fc80000410000ULL, 0x00000037004b7308ULL, 0x000ea40000000800ULL,
0x0000004b33337220ULL, 0x004fe20000410000ULL, 0x00010a527f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b087589ULL, 0x0022a400000e0000ULL, 0x000000080c0c7220ULL, 0x084fe40000410000ULL,
0x000000080d0d7220ULL, 0x080fe40000410000ULL, 0x0000000810107220ULL, 0x080fe40000410000ULL,
0x0000000811117220ULL, 0x080fe40000410000ULL, 0x0000000814147220ULL, 0x000fc40000410000ULL,
0x0000000815157220ULL, 0x080fe40000410000ULL, 0x000000083c3c7220ULL, 0x080fe40000410000ULL,
0x000000083d3d7220ULL, 0x080fe40000410000ULL, 0x0000000838387220ULL, 0x080fe40000410000ULL,
0x0000000839397220ULL, 0x080fe40000410000ULL, 0x0000000840407220ULL, 0x000fc40000410000ULL,
0x0000000841417220ULL, 0x080fe40000410000ULL, 0x0000000844447220ULL, 0x080fe40000410000ULL,
0x0000000845457220ULL, 0x080fe40000410000ULL, 0x0000000804047220ULL, 0x080fe40000410000ULL,
0x0000000805057220ULL, 0x000fe20000410000ULL, 0x000109927f007947ULL, 0x000fea000b800000ULL,
0x00001f2f4b087589ULL, 0x00052400000e0000ULL, 0x0000000b34347209ULL, 0x000fe20007810000ULL,
0x000000080e0e7220ULL, 0x090fe20000410000ULL, 0x00000001ff097807ULL, 0x000fe20000800000ULL,
0x000000080f0f7220ULL, 0x000fc40000410000ULL, 0x800000340b0b1221ULL, 0x000fe40000010000ULL,
0x0000000812127220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b0b0b1820ULL, 0x000fe40000410000ULL,
0x0000000813137220ULL, 0x080fe40000410000ULL, 0x0000000b00301308ULL, 0x000f220000000800ULL,
0x0000000816167220ULL, 0x080fe40000410000ULL, 0x0000000817177220ULL, 0x000fc40000410000ULL,
0x000000083e3e7220ULL, 0x080fe40000410000ULL, 0x000000083f3f7220ULL, 0x080fe40000410000ULL,
0x000000083a3a7220ULL, 0x080fe40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x0000000842427220ULL, 0x080fe40000410000ULL, 0x0000000843437220ULL, 0x000fc40000410000ULL,
0x0000000846467220ULL, 0x080fe40000410000ULL, 0x0000000847477220ULL, 0x080fe40000410000ULL,
0x0000000806067220ULL, 0x080fe40000410000ULL, 0x0000000807077220ULL, 0x000fe20000410000ULL,
0x0000761009087816ULL, 0x000fe20000000008ULL, 0x0000000a300a1220ULL, 0x018fe40000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000030ff09723eULL, 0x000fe200000000ffULL,
0x000000330a337221ULL, 0x008fe20000010000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000002ff4c7819ULL, 0x002fe40000011600ULL, 0x00005410094b7816ULL, 0x004fe20000000009ULL,
0x000108127f007947ULL, 0x000fea000b800000ULL, 0x00001f4c4b377589ULL, 0x0002a800000e0000ULL,
0x00001f2f4b6c7589ULL, 0x0002e400000e0000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x0000002e004c7202ULL, 0x002fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe200078e00ffULL,
0x000048b000487802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fc400078e00ffULL,
0x000113e000007944ULL, 0x00cfea0003c00000ULL, 0x000000537f007947ULL, 0x000fea000b800000ULL,
0x000000ffff4c7224ULL, 0x002fe200078e002cULL, 0xffffffff004e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0x0000491000487802ULL, 0x000fc40000000f00ULL,
0x0001138000007944ULL, 0x00cfea0003c00000ULL, 0x000128002b547811ULL, 0x000fe200078e20ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002968783bULL, 0x000fe20000004200ULL,
0x0000991008487816ULL, 0x000fc400000000ffULL, 0x0001280025087811ULL, 0x000fe200078e20ffULL,
0x000000005454783bULL, 0x000f220000000200ULL, 0x000000ff4800720cULL, 0x000fe40003f25270ULL,
0x0000006032707810ULL, 0x000fe20007ffe0ffULL, 0x000000002864783bULL, 0x000fe80000004200ULL,
0x000000002758783bULL, 0x000fe80000004200ULL, 0x00000000265c783bULL, 0x000fe80000004200ULL,
0x000000000808783bULL, 0x000f680000000200ULL, 0x000000002460783bULL, 0x000e680000004200ULL,
0x000000002350783bULL, 0x000ee80000004200ULL, 0x00000000224c783bULL, 0x002e680000004200ULL,
0x000000002148783bULL, 0x004ea20000004200ULL, 0x0000003754549232ULL, 0x010fc40000000000ULL,
0x0000003756569232ULL, 0x000fe40000000000ULL, 0x0000006c55559232ULL, 0x088fe40000000000ULL,
0x0000006c57579232ULL, 0x000fce0000000000ULL, 0x00000068540c723cULL, 0x000fe2000000180cULL,
0x0000003708089232ULL, 0x0a0fe40000000000ULL, 0x000000370a0a9232ULL, 0x000fe40000000000ULL,
0x0000006c09099232ULL, 0x000fc60000000000ULL, 0x0000006a5410723cULL, 0x000fe20000001810ULL,
0x0000006c0b0b9232ULL, 0x000fce0000000000ULL, 0x000000645414723cULL, 0x040ff00000001814ULL,
0x00000066543c723cULL, 0x040ff0000000183cULL, 0x000000585438723cULL, 0x040ff00000001838ULL,
0x0000005a5440723cULL, 0x040ff00000001840ULL, 0x0000005c5444723cULL, 0x040ff00000001844ULL,
0x0000005e5454723cULL, 0x000ff00000001804ULL, 0x000000600804723cULL, 0x040ff0000000180cULL,
0x00000062080c723cULL, 0x040ff00000001810ULL, 0x000000500810723cULL, 0x040ff00000001814ULL,
0x0000004c0838723cULL, 0x042ff00000001838ULL, 0x000000520850723cULL, 0x040ff0000000183cULL,
0x0000004e084c723cULL, 0x040fee0000001840ULL, 0x0000620035407a24ULL, 0x000fe200078e0270ULL,
0x000000480814723cULL, 0x044ff00000001844ULL, 0x0000004a0854723cULL, 0x000fe20000001854ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3f7819ULL, 0x000fe20000011600ULL, 0x00000200ff417424ULL, 0x000fe200078e00ffULL,
0x0000007079097217ULL, 0x000fe20007800000ULL, 0x0000000136437824ULL, 0x000fe200078e022dULL,
0x000000043f3d7810ULL, 0x040fe40007ffe0ffULL, 0x000000083f497810ULL, 0x040fe40007ffe0ffULL,
0x000000103f5d7810ULL, 0x000fe20007ffe0ffULL, 0x000000083d477824ULL, 0x040fe200078e00ffULL,
0x000000003d087212ULL, 0x000fe200078e3cffULL, 0x00000008494b7824ULL, 0x000fe200078e00ffULL,
0x0000000c3f597810ULL, 0x000fe20007ffe0ffULL, 0x000000085d3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fc400078ee208ULL, 0x0000000970097210ULL, 0x000fe20007ffe1ffULL,
0x00000008595b7824ULL, 0x000fe200078e00ffULL, 0x0000000049087212ULL, 0x080fe200078e3cffULL,
0x0000001047477824ULL, 0x000fe200078e022aULL, 0x000000005d0b7212ULL, 0x080fe400078e3cffULL,
0x00000000590a7212ULL, 0x000fe400078e3cffULL, 0x0000002009377817ULL, 0x000fe40003800000ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL, 0x000000013f087824ULL, 0x000fe200078e0240ULL,
0xfffffff83c5f7812ULL, 0x000fc400078ee20bULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee20aULL,
0x000000013d0a7824ULL, 0x000fe200078e0240ULL, 0x000000073f0b7812ULL, 0x000fe200078e4800ULL,
0x00005e0008087625ULL, 0x000fe200078e0041ULL, 0x00000040493c7210ULL, 0x000fe40007ffe0ffULL,
0x000000373f00720cULL, 0x080fe20003f46070ULL, 0x000000104b4b7824ULL, 0x000fe200078e022aULL,
0x000000373d00720cULL, 0x000fe20003f66070ULL, 0x00005e003c3c7625ULL, 0x000fe200078e0041ULL,
0x000000143f617810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff80b457812ULL, 0x000fe200078ef800ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0041ULL, 0x000000374900720cULL, 0x000fe40003f86070ULL,
0x00000000613e7212ULL, 0x040fe200078e3cffULL, 0x0000000861497824ULL, 0x000fe200078e00ffULL,
0x000000183f637810ULL, 0x000fe20007ffe0ffULL, 0x0000001045457824ULL, 0x000fe200078e022aULL,
0x0000001c3f3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001043087825ULL, 0x000fe200078e0008ULL,
0xfffffff849497812ULL, 0x000fc400078ee23eULL, 0x00000000633e7212ULL, 0x080fe200078e3cffULL,
0x00000010430a7825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008457faeULL, 0x0003e2000d101c46ULL, 0x0000000363657819ULL, 0x000fe400000006ffULL,
0x00000010433c7825ULL, 0x000fe200078e003cULL, 0x000000000a477faeULL, 0x0005e2000d901c46ULL,
0x000000375900720cULL, 0x080fe40003f46070ULL, 0x000000375d00720cULL, 0x080fe20003f66070ULL,
0x000000003c4b7faeULL, 0x0007e2000e101c46ULL, 0x000000376100720cULL, 0x080fe20003f86070ULL,
0x000000105b5b7824ULL, 0x000fe200078e022aULL, 0x000000376300720cULL, 0x080fe20003fa6070ULL,
0x0000000159087824ULL, 0x002fe200078e0240ULL, 0x000000373f00720cULL, 0x040fe20003fc6070ULL,
0x000000083f457824ULL, 0x000fe200078e00ffULL, 0xfffffff865377812ULL, 0x000fe200078ee23eULL,
0x000000015d0a7824ULL, 0x104fe200078e0240ULL, 0x000000003f427212ULL, 0x000fe200078e3cffULL,
0x00000001633e7824ULL, 0x100fe200078e0240ULL, 0x0000002a37377211ULL, 0x000fe200078e20ffULL,
0x00000001613c7824ULL, 0x008fe200078e0240ULL, 0x000000403f407210ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0041ULL, 0xfffffff845457812ULL, 0x000fc600078ee242ULL,
0x00005e000a0a7625ULL, 0x000fc800078e0041ULL, 0x00005e003c3c7625ULL, 0x000fc800078e0041ULL,
0x00005e003e3e7625ULL, 0x000fc800078e0041ULL, 0x00005e0040407625ULL, 0x000fc800078e0041ULL,
0x0000001043087825ULL, 0x000fc800078e0008ULL, 0x00000010430a7825ULL, 0x000fe200078e000aULL,
0x00000000085b7faeULL, 0x0003e6000d101c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e022aULL,
0x00000010433c7825ULL, 0x000fc600078e003cULL, 0x000000000a5f7faeULL, 0x0003e2000d901c46ULL,
0x0000001049497824ULL, 0x000fe400078e022aULL, 0x00000010433e7825ULL, 0x000fc600078e003eULL,
0x000000003c497faeULL, 0x0003e2000e101c46ULL, 0x0000001043407825ULL, 0x000fc600078e0040ULL,
0x000000003e377faeULL, 0x0003e2000e901c46ULL, 0x0000001045457824ULL, 0x000fca00078e022aULL,
0x0000000040457faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe20000011600ULL, 0x00000200ff477424ULL, 0x000fe200078e00ffULL,
0x0000002d36377210ULL, 0x000fe40007ffe0ffULL, 0x0000000c09417810ULL, 0x040fe40007ffe0ffULL,
0x00000004093d7810ULL, 0x040fe40007ffe0ffULL, 0x00000008093f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008413c7824ULL, 0x040fe200078e00ffULL, 0x00000000410b7212ULL, 0x080fe200078e3cffULL,
0x000000083d4b7824ULL, 0x040fe200078e00ffULL, 0x000000003d087212ULL, 0x080fe200078e3cffULL,
0x000000083f597824ULL, 0x040fe200078e00ffULL, 0xfffffff83c5b7812ULL, 0x000fe200078ee20bULL,
0x000000013f3c7824ULL, 0x040fe200078e0240ULL, 0x000000003f0a7212ULL, 0x000fc400078e3cffULL,
0x00000007090b7812ULL, 0x000fe200078e4800ULL, 0x000000105b5b7824ULL, 0x000fe200078e022aULL,
0x0000001009437810ULL, 0x040fe40007ffe0ffULL, 0x0000001409457810ULL, 0x040fe40007ffe0ffULL,
0x0000001809497810ULL, 0x000fe20007ffe0ffULL, 0x00000008434a7824ULL, 0x000fe200078e00ffULL,
0x0000001c095d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000845587824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x000fe200078e0240ULL,
0xfffffff859597812ULL, 0x000fe200078ee20aULL, 0x000000013d0a7824ULL, 0x000fe200078e0240ULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL, 0x0000000143427824ULL, 0x140fe200078e0240ULL,
0x00000000433d7212ULL, 0x000fe200078e3cffULL, 0x0000000145447824ULL, 0x100fe200078e0240ULL,
0x00000040413e7210ULL, 0x000fe20007ffe0ffULL, 0x000000015d487824ULL, 0x000fe200078e0240ULL,
0x00000000453f7212ULL, 0x000fe200078e3cffULL, 0x0000000849617824ULL, 0x040fe200078e00ffULL,
0x0000004049467210ULL, 0x000fe20007ffe0ffULL, 0x000000085d5a7824ULL, 0x000fe200078e00ffULL,
0x0000000049407212ULL, 0x080fe200078e3cffULL, 0x00005e0008087625ULL, 0x000fe200078e0047ULL,
0x000000005d417212ULL, 0x000fc400078e3cffULL, 0xfffffff84a5d7812ULL, 0x000fe200078ee23dULL,
0x000000100b497824ULL, 0x000fe200078e022aULL, 0xfffffff8585f7812ULL, 0x000fe200078ee23fULL,
0x00005e000a0a7625ULL, 0x080fe200078e0047ULL, 0xfffffff861617812ULL, 0x000fe400078ee240ULL,
0xfffffff85a637812ULL, 0x000fe200078ee241ULL, 0x00005e003c3c7625ULL, 0x080fe200078e0047ULL,
0x0000002a4b4b7211ULL, 0x080fe400078e20ffULL, 0x0000002a61617211ULL, 0x000fe200078e20ffULL,
0x00005e003e3e7625ULL, 0x000fc800078e0047ULL, 0x00005e0042407625ULL, 0x000fc800078e0047ULL,
0x00005e0044427625ULL, 0x000fc800078e0047ULL, 0x0000001037087825ULL, 0x000fc800078e0008ULL,
0x00005e0046447625ULL, 0x080fe200078e0047ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008497faeULL, 0x0003e6000b901c46ULL, 0x00005e0048467625ULL, 0x000fc800078e0047ULL,
0x00000010370a7825ULL, 0x000fc800078e000aULL, 0x0000001059597824ULL, 0x000fe200078e022aULL,
0x000000000a4b7faeULL, 0x0003e2000b901c46ULL, 0x00000010373c7825ULL, 0x000fc800078e003cULL,
0x00000010373e7825ULL, 0x040fe200078e003eULL, 0x000000003c597faeULL, 0x0003e6000b901c46ULL,
0x0000001037407825ULL, 0x000fe200078e0040ULL, 0x000000003e5b7faeULL, 0x0003e6000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e022aULL, 0x0000001037427825ULL, 0x000fc600078e0042ULL,
0x00000000405d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e022aULL,
0x0000001037447825ULL, 0x000fc600078e0044ULL, 0x00000000425f7faeULL, 0x0003e2000b901c46ULL,
0x0000001037467825ULL, 0x000fc600078e0046ULL, 0x0000000044617faeULL, 0x0003e2000b901c46ULL,
0x0000001063637824ULL, 0x000fca00078e022aULL, 0x0000000046637faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0001280020587811ULL, 0x000fe400078e20ffULL,
0x00000030ff08723eULL, 0x002fe400000000ffULL, 0x00000002ff377819ULL, 0x000fe40000011600ULL,
0x0000541008687816ULL, 0x000fe40000000008ULL, 0x000128001d087811ULL, 0x000fc600078e20ffULL,
0x00001f3768377589ULL, 0x000fe800000e0000ULL, 0x00001f2f68727589ULL, 0x000fe200000e0000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005858783bULL, 0x000e680000000200ULL,
0x000000001e64783bULL, 0x000ea80000004200ULL, 0x000000001b60783bULL, 0x000fe80000004200ULL,
0x000000001c6c783bULL, 0x000fe80000004200ULL, 0x000000001a5c783bULL, 0x000fe80000004200ULL,
0x000000000808783bULL, 0x000ee80000000200ULL, 0x000000001944783bULL, 0x000f280000004200ULL,
0x00000000183c783bULL, 0x000f680000004200ULL, 0x000000000340783bULL, 0x000f280000004200ULL,
0x000000000248783bULL, 0x000f220000004200ULL, 0x0000003758589232ULL, 0x002fc40000000000ULL,
0x000000375a5a9232ULL, 0x000fe40000000000ULL, 0x0000007259599232ULL, 0x080fe40000000000ULL,
0x000000725b5b9232ULL, 0x000fce0000000000ULL, 0x000000645804723cULL, 0x004fe20000001804ULL,
0x0000003708089232ULL, 0x008fce0000000000ULL, 0x000000605838723cULL, 0x000fe20000001838ULL,
0x000000370a0a9232ULL, 0x000fe40000000000ULL, 0x0000007209099232ULL, 0x080fe40000000000ULL,
0x000000720b0b9232ULL, 0x000fc60000000000ULL, 0x000000665864723cULL, 0x040ff0000000180cULL,
0x0000006c5868723cULL, 0x040ff00000001810ULL, 0x000000625860723cULL, 0x040ff0000000184cULL,
0x0000006e5850723cULL, 0x040ff00000001850ULL, 0x0000005c584c723cULL, 0x040ff00000001814ULL,
0x0000005e5854723cULL, 0x000ff00000001854ULL, 0x00000044080c723cULL, 0x050ff00000001804ULL,
0x000000460810723cULL, 0x040ff00000001864ULL, 0x0000003c0814723cULL, 0x060ff00000001868ULL,
0x000000400838723cULL, 0x040ff00000001838ULL, 0x0000003e083c723cULL, 0x040ff00000001850ULL,
0x000000420840723cULL, 0x040ff00000001860ULL, 0x000000480844723cULL, 0x040ff0000000184cULL,
0x0000004a0804723cULL, 0x000fe20000001854ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fee0000008000ULL,
0x000000797000720cULL, 0x000fe20003f26070ULL, 0x01c69000ffff7f8cULL, 0x000fd8000c80043fULL,
0x000042b000001947ULL, 0x000fea0003800000ULL, 0x00000080320a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00006200354e7a24ULL, 0x000fe200078e020aULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff497819ULL, 0x000fe20000011600ULL,
0x0000000136517824ULL, 0x000fe200078e022dULL, 0x0000000a79087217ULL, 0x000fe40007800000ULL,
0x00000004494b7810ULL, 0x000fe40007ffe0ffULL, 0x00000200004f7802ULL, 0x000fe20000000f00ULL,
0x0000000108087824ULL, 0x000fe200078e0a0aULL, 0x000000004b097212ULL, 0x040fe200078e3cffULL,
0x000000084b4a7824ULL, 0x000fe200078e00ffULL, 0x0000000849537810ULL, 0x000fe20007ffe0ffULL,
0x000000014b0a7824ULL, 0x000fe200078e024eULL, 0x0000002008377817ULL, 0x000fc40003800000ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee209ULL, 0x0000000149097824ULL, 0x040fe200078e024eULL,
0x0000000c49557810ULL, 0x000fe20007ffe0ffULL, 0x0000000853577824ULL, 0x000fe200078e00ffULL,
0x00000007490b7812ULL, 0x100fe200078e4800ULL, 0x00005e0009087625ULL, 0x000fe200078e004fULL,
0x000000374900720cULL, 0x080fe40003f26070ULL, 0x000000374b00720cULL, 0x000fe20003f46070ULL,
0x0000000855597824ULL, 0x000fe200078e00ffULL, 0x0ffffff80b487812ULL, 0x000fe200078ef800ULL,
0x00005e000a0a7625ULL, 0x000fe200078e004fULL, 0x00000000534c7212ULL, 0x000fc400078e3cffULL,
0x0000000055527212ULL, 0x080fe200078e3cffULL, 0x0000001051087825ULL, 0x000fe200078e0008ULL,
0xfffffff857507812ULL, 0x000fe400078ee24cULL, 0xfffffff859527812ULL, 0x000fe200078ee252ULL,
0x000000104a4d7824ULL, 0x000fe200078e021fULL, 0x0000001f484b7211ULL, 0x000fe200078e20ffULL,
0x00000010510a7825ULL, 0x000fe200078e000aULL, 0x0000001049577810ULL, 0x040fe40007ffe0ffULL,
0x0000001449597810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000084b7faeULL, 0x0003e2000c901c46ULL, 0x00000018495b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000157487824ULL, 0x100fe200078e024eULL, 0x0000001c49497810ULL, 0x000fe20007ffe0ffULL,
0x000000000a4d7faeULL, 0x0005e2000d101c46ULL, 0x0000000859567824ULL, 0x000fe200078e00ffULL,
0x0000000357547819ULL, 0x000fe200000006ffULL, 0x00000001594a7824ULL, 0x100fe200078e024eULL,
0x000000375300720cULL, 0x080fe20003f26070ULL, 0x00000008495a7824ULL, 0x040fe200078e00ffULL,
0x000000374900720cULL, 0x000fe20003fc6070ULL, 0x000000015b4c7824ULL, 0x100fe200078e024eULL,
0x0000000057097212ULL, 0x082fe200078e3cffULL, 0x0000000153087824ULL, 0x000fe200078e024eULL,
0x00000000494b7212ULL, 0x000fc400078e3cffULL, 0x00000000590b7212ULL, 0x004fe200078e3cffULL,
0x00000001550a7824ULL, 0x100fe200078e024eULL, 0xfffffff854547812ULL, 0x000fe200078ee209ULL,
0x00000001494e7824ULL, 0x000fe200078e024eULL, 0xfffffff856567812ULL, 0x000fe200078ee20bULL,
0x00005e0008087625ULL, 0x000fe200078e004fULL, 0xfffffff85a5a7812ULL, 0x000fe400078ee24bULL,
0x000000375500720cULL, 0x000fe20003f46070ULL, 0x00005e000a0a7625ULL, 0x000fe200078e004fULL,
0x000000375700720cULL, 0x000fc40003f66070ULL, 0x000000375900720cULL, 0x000fe20003f86070ULL,
0x00005e0048487625ULL, 0x000fe200078e004fULL, 0x000000375b00720cULL, 0x040fe40003fa6070ULL,
0x000000005b377212ULL, 0x040fe200078e3cffULL, 0x00005e004a4a7625ULL, 0x000fe200078e004fULL,
0x000000035b587819ULL, 0x000fe400000006ffULL, 0x0000001f56557211ULL, 0x000fe200078e20ffULL,
0x00005e004c4c7625ULL, 0x000fe200078e004fULL, 0xfffffff858587812ULL, 0x000fc600078ee237ULL,
0x00005e004e4e7625ULL, 0x000fc800078e004fULL, 0x0000001050377824ULL, 0x000fe400078e021fULL,
0x0000001051087825ULL, 0x000fc800078e0008ULL, 0x00000010510a7825ULL, 0x040fe200078e000aULL,
0x0000000008377faeULL, 0x0003e6000c901c46ULL, 0x0000001051487825ULL, 0x000fc800078e0048ULL,
0x00000010514a7825ULL, 0x000fc800078e004aULL, 0x00000010514c7825ULL, 0x000fc800078e004cULL,
0x00000010514e7825ULL, 0x000fc800078e004eULL, 0x0000001052517824ULL, 0x100fe400078e021fULL,
0x0000001054537824ULL, 0x100fe400078e021fULL, 0x0000001058577824ULL, 0x100fe200078e021fULL,
0x000000000a517faeULL, 0x0003e2000d101c46ULL, 0x000000105a597824ULL, 0x000fc600078e021fULL,
0x0000000048537faeULL, 0x0003e8000d901c46ULL, 0x000000004a557faeULL, 0x0003e8000e101c46ULL,
0x000000004c577faeULL, 0x0003e8000e901c46ULL, 0x000000004e597faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x00000200ff537424ULL, 0x000fc600078e00ffULL, 0x00000008094b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c094d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000409497810ULL, 0x000fe20007ffe0ffULL,
0x000000084b4f7824ULL, 0x040fe200078e00ffULL, 0x000000004b0a7212ULL, 0x080fe200078e3cffULL,
0x000000014d4c7824ULL, 0x140fe200078e024eULL, 0x000000004d0b7212ULL, 0x000fe200078e3cffULL,
0x0000000849377824ULL, 0x000fe200078e00ffULL, 0x000000034d587819ULL, 0x000fe200000006ffULL,
0x0000000149487824ULL, 0x000fe200078e024eULL, 0xfffffff84f567812ULL, 0x000fc400078ee20aULL,
0xfffffff858587812ULL, 0x000fe400078ee20bULL, 0x00000010094f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001056597824ULL, 0x000fe200078e021fULL, 0x0000000049087212ULL, 0x000fe400078e3cffULL,
0x00000007090b7812ULL, 0x000fe200078e4800ULL, 0x000000084f5a7824ULL, 0x000fe200078e00ffULL,
0x0000001809557810ULL, 0x000fe20007ffe0ffULL, 0x000000014f507824ULL, 0x000fe200078e024eULL,
0x0000001409517810ULL, 0x000fc40007ffe0ffULL, 0x0000001c09577810ULL, 0x000fe20007ffe0ffULL,
0x0000000855607824ULL, 0x000fe200078e00ffULL, 0xfffffff837547812ULL, 0x000fe200078ee208ULL,
0x0000000109087824ULL, 0x000fe200078e024eULL, 0x0ffffff80b0a7812ULL, 0x000fe200078ef800ULL,
0x0000000857647824ULL, 0x000fe200078e00ffULL, 0x000000004f0b7212ULL, 0x000fe200078e3cffULL,
0x00000001555e7824ULL, 0x000fe200078e024eULL, 0x0000004e4b4a7210ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0053ULL, 0x0000000051497212ULL, 0x000fc400078e3cffULL,
0x00000003515c7819ULL, 0x040fe200000006ffULL, 0x0000000151527824ULL, 0x100fe200078e024eULL,
0x00000000554b7212ULL, 0x080fe200078e3cffULL, 0x0000000136377824ULL, 0x000fe200078e022dULL,
0x00000000574d7212ULL, 0x040fe200078e3cffULL, 0x0000000157627824ULL, 0x000fe200078e024eULL,
0x0000001f0a557211ULL, 0x000fe200078e20ffULL, 0x00005e00524e7625ULL, 0x080fe200078e0053ULL,
0xfffffff85a5a7812ULL, 0x000fe400078ee20bULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee249ULL,
0x00005e00480a7625ULL, 0x000fe200078e0053ULL, 0xfffffff860607812ULL, 0x000fc400078ee24bULL,
0xfffffff864647812ULL, 0x000fe200078ee24dULL, 0x00005e004a487625ULL, 0x000fc800078e0053ULL,
0x00005e004c4a7625ULL, 0x000fc800078e0053ULL, 0x00005e00504c7625ULL, 0x000fc800078e0053ULL,
0x00005e005e507625ULL, 0x000fc800078e0053ULL, 0x0000001037087825ULL, 0x000fc800078e0008ULL,
0x00005e0062527625ULL, 0x000fe200078e0053ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008557faeULL, 0x0003e6000b901c46ULL, 0x0000001054577824ULL, 0x000fe400078e021fULL,
0x00000010370a7825ULL, 0x000fc800078e000aULL, 0x0000001037487825ULL, 0x040fe200078e0048ULL,
0x000000000a577faeULL, 0x0005e2000b901c46ULL, 0x0000001f5c557211ULL, 0x002fe400078e20ffULL,
0x00000010374a7825ULL, 0x040fe200078e004aULL, 0x0000000048597faeULL, 0x0005e6000b901c46ULL,
0x00000010374c7825ULL, 0x000fc800078e004cULL, 0x00000010374e7825ULL, 0x000fc800078e004eULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001037527825ULL, 0x000fc800078e0052ULL,
0x0000001058097824ULL, 0x100fe400078e021fULL, 0x000000105a377824ULL, 0x100fe400078e021fULL,
0x00000010605b7824ULL, 0x100fe200078e021fULL, 0x000000004a097faeULL, 0x0005e2000b901c46ULL,
0x00000010645d7824ULL, 0x000fc600078e021fULL, 0x000000004c377faeULL, 0x0005e8000b901c46ULL,
0x000000004e557faeULL, 0x0005e8000b901c46ULL, 0x00000000505b7faeULL, 0x0005e8000b901c46ULL,
0x00000000525d7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6480036087f8cULL, 0x006fe8000c80043fULL,
0x01c64c00360b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007824809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL,
0x0000000a000b7305ULL, 0x0002a4000021f000ULL, 0x3fa000000a0a7823ULL, 0x002fe200000100ffULL,
0x0000000b0000735dULL, 0x004fe40003800000ULL, 0x01c64c00360b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007824809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000009947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01c10000310b7984ULL, 0x000e680000000800ULL, 0x01c30000310a7984ULL, 0x0004e20000000800ULL,
0x000000340b00720bULL, 0x002fe20003f3d000ULL, 0x0000ebc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x004fc800008e0100ULL, 0x0000ffff08497812ULL, 0x000fe2000782c0ffULL,
0x000003b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff087424ULL, 0x000fd600078e00ffULL,
0x0000038000009947ULL, 0x000fea0003800000ULL, 0x000000027a00780cULL, 0x000fe40003f25270ULL,
0x000000340b00720bULL, 0x000fe20003f54000ULL, 0x0000eba27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x000fe400010e0100ULL, 0x0000000b34097209ULL, 0x000fe40007810000ULL,
0x0000ffff08087812ULL, 0x000fe400078e3cffULL, 0x00000002ff4c7819ULL, 0x000fe20000011600ULL,
0x8000000934377221ULL, 0x000fe20000010000ULL, 0x01c5000931009388ULL, 0x0003e20000000800ULL,
0x0000000849ff7212ULL, 0x000fc4000782c0ffULL, 0x3fb8aa3b37377820ULL, 0x000fc80000410000ULL,
0x00000037004b7308ULL, 0x000ea40000000800ULL, 0x0000004b33337220ULL, 0x004fe20000410000ULL,
0x0000eb527f007947ULL, 0x000fea000b800000ULL, 0x00001f4c4b087589ULL, 0x0022a400000e0000ULL,
0x000000080c0c7220ULL, 0x084fe40000410000ULL, 0x000000080d0d7220ULL, 0x080fe40000410000ULL,
0x0000000810107220ULL, 0x080fe40000410000ULL, 0x0000000811117220ULL, 0x080fe40000410000ULL,
0x0000000814147220ULL, 0x000fc40000410000ULL, 0x0000000815157220ULL, 0x080fe40000410000ULL,
0x000000083c3c7220ULL, 0x080fe40000410000ULL, 0x000000083d3d7220ULL, 0x080fe40000410000ULL,
0x0000000838387220ULL, 0x080fe40000410000ULL, 0x0000000839397220ULL, 0x080fe40000410000ULL,
0x0000000840407220ULL, 0x000fc40000410000ULL, 0x0000000841417220ULL, 0x080fe40000410000ULL,
0x0000000844447220ULL, 0x080fe40000410000ULL, 0x0000000845457220ULL, 0x080fe40000410000ULL,
0x0000000804047220ULL, 0x080fe40000410000ULL, 0x0000000805057220ULL, 0x000fe20000410000ULL,
0x0000ea927f007947ULL, 0x000fea000b800000ULL, 0x00001f2f4b087589ULL, 0x00052400000e0000ULL,
0x0000000b34347209ULL, 0x000fe20007810000ULL, 0x000000080e0e7220ULL, 0x090fe20000410000ULL,
0x00000001ff097807ULL, 0x000fe20000800000ULL, 0x000000080f0f7220ULL, 0x000fc40000410000ULL,
0x800000340b0b1221ULL, 0x000fe40000010000ULL, 0x0000000812127220ULL, 0x080fe40000410000ULL,
0x3fb8aa3b0b0b1820ULL, 0x000fe40000410000ULL, 0x0000000813137220ULL, 0x080fe40000410000ULL,
0x0000000b00301308ULL, 0x000f220000000800ULL, 0x0000000816167220ULL, 0x080fe40000410000ULL,
0x0000000817177220ULL, 0x000fc40000410000ULL, 0x000000083e3e7220ULL, 0x080fe40000410000ULL,
0x000000083f3f7220ULL, 0x080fe40000410000ULL, 0x000000083a3a7220ULL, 0x080fe40000410000ULL,
0x000000083b3b7220ULL, 0x080fe40000410000ULL, 0x0000000842427220ULL, 0x080fe40000410000ULL,
0x0000000843437220ULL, 0x000fc40000410000ULL, 0x0000000846467220ULL, 0x080fe40000410000ULL,
0x0000000847477220ULL, 0x080fe40000410000ULL, 0x0000000806067220ULL, 0x080fe40000410000ULL,
0x0000000807077220ULL, 0x000fe20000410000ULL, 0x0000761009087816ULL, 0x000fe20000000008ULL,
0x0000000a300a1220ULL, 0x018fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000030ff09723eULL, 0x000fe200000000ffULL, 0x000000330a337221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff4c7819ULL, 0x002fe40000011600ULL,
0x00005410094b7816ULL, 0x004fe20000000009ULL, 0x0000e9127f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b377589ULL, 0x0002a800000e0000ULL, 0x00001f2f4b6c7589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002eULL,
0xffffffff004e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe200078e00ffULL,
0x00006a0000487802ULL, 0x000fc40000000f00ULL, 0x0000f29000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002cULL,
0x00006a6000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0000f23000007944ULL, 0x00cfea0003c00000ULL,
0x000130002b547811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000002968783bULL, 0x000fe20000004200ULL, 0x0000991008487816ULL, 0x000fe400000000ffULL,
0x0001300025087811ULL, 0x000fe200078e20ffULL, 0x000000005454783bULL, 0x000f220000000200ULL,
0x000000ff4800720cULL, 0x000fe40003f25270ULL, 0x000000a032707810ULL, 0x000fe20007ffe0ffULL,
0x000000002864783bULL, 0x000fe80000004200ULL, 0x000000002758783bULL, 0x000fe80000004200ULL,
0x00000000265c783bULL, 0x000fe80000004200ULL, 0x000000000808783bULL, 0x000f680000000200ULL,
0x000000002460783bULL, 0x000e680000004200ULL, 0x000000002350783bULL, 0x000ee80000004200ULL,
0x00000000224c783bULL, 0x002e680000004200ULL, 0x000000002148783bULL, 0x004ea20000004200ULL,
0x0000003754549232ULL, 0x010fc40000000000ULL, 0x0000003756569232ULL, 0x000fe40000000000ULL,
0x0000006c55559232ULL, 0x088fe40000000000ULL, 0x0000006c57579232ULL, 0x000fce0000000000ULL,
0x00000068540c723cULL, 0x000fe2000000180cULL, 0x0000003708089232ULL, 0x0a0fe40000000000ULL,
0x000000370a0a9232ULL, 0x000fe40000000000ULL, 0x0000006c09099232ULL, 0x000fc60000000000ULL,
0x0000006a5410723cULL, 0x000fe20000001810ULL, 0x0000006c0b0b9232ULL, 0x000fce0000000000ULL,
0x000000645414723cULL, 0x040ff00000001814ULL, 0x00000066543c723cULL, 0x040ff0000000183cULL,
0x000000585438723cULL, 0x040ff00000001838ULL, 0x0000005a5440723cULL, 0x040ff00000001840ULL,
0x0000005c5444723cULL, 0x040ff00000001844ULL, 0x0000005e5454723cULL, 0x000ff00000001804ULL,
0x000000600804723cULL, 0x040ff0000000180cULL, 0x00000062080c723cULL, 0x040ff00000001810ULL,
0x000000500810723cULL, 0x040ff00000001814ULL, 0x0000004c0838723cULL, 0x042ff00000001838ULL,
0x000000520850723cULL, 0x040ff0000000183cULL, 0x0000004e084c723cULL, 0x040fee0000001840ULL,
0x0000620035407a24ULL, 0x000fe200078e0270ULL, 0x000000480814723cULL, 0x044ff00000001844ULL,
0x0000004a0854723cULL, 0x000fe20000001854ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000058000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x000fe20000011600ULL,
0x0000000136437824ULL, 0x000fe200078e022dULL, 0x0000007079097217ULL, 0x000fe40007800000ULL,
0x000000043f3d7810ULL, 0x040fe40007ffe0ffULL, 0x000000103f5d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a70ULL, 0x000000003d087212ULL, 0x040fe200078e3cffULL,
0x000000083d477824ULL, 0x000fe200078e00ffULL, 0x0000000c3f597810ULL, 0x000fe20007ffe0ffULL,
0x000000085d3c7824ULL, 0x000fe200078e00ffULL, 0x000000083f497810ULL, 0x000fc40007ffe0ffULL,
0xfffffff847477812ULL, 0x000fe200078ee208ULL, 0x00000008595b7824ULL, 0x000fe200078e00ffULL,
0x0000000049087212ULL, 0x0c0fe400078e3cffULL, 0x00000003494b7819ULL, 0x000fe200000006ffULL,
0x0000001047477824ULL, 0x000fe200078e022aULL, 0x000000005d0b7212ULL, 0x080fe400078e3cffULL,
0x00000000590a7212ULL, 0x000fe400078e3cffULL, 0x0000002009377817ULL, 0x000fc40003800000ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL, 0x000000013f087824ULL, 0x100fe200078e0240ULL,
0xfffffff83c5f7812ULL, 0x000fe200078ee20bULL, 0x00000001493c7824ULL, 0x000fe200078e0240ULL,
0x0000020000417802ULL, 0x000fe20000000f00ULL, 0x000000104b4b7824ULL, 0x000fe200078e022aULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee20aULL, 0x000000013d0a7824ULL, 0x000fe200078e0240ULL,
0x000000073f0b7812ULL, 0x040fe200078e4800ULL, 0x00005e0008087625ULL, 0x000fe200078e0041ULL,
0x000000373f00720cULL, 0x000fc40003f46070ULL, 0x000000373d00720cULL, 0x000fe20003f66070ULL,
0x00005e003c3c7625ULL, 0x080fe200078e0041ULL, 0x000000143f617810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff80b457812ULL, 0x000fe200078ef800ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0041ULL,
0x000000374900720cULL, 0x000fe40003f86070ULL, 0x000000183f637810ULL, 0x000fe20007ffe0ffULL,
0x0000000861497824ULL, 0x040fe200078e00ffULL, 0x00000000613e7212ULL, 0x000fe200078e3cffULL,
0x0000001043087825ULL, 0x000fe200078e0008ULL, 0x0000002a45457211ULL, 0x000fc400078e20ffULL,
0xfffffff849497812ULL, 0x000fe200078ee23eULL, 0x00000010430a7825ULL, 0x000fe200078e000aULL,
0x0000001c3f3f7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008457faeULL, 0x0003e2000d101c46ULL, 0x00000000633e7212ULL, 0x080fe200078e3cffULL,
0x00000010433c7825ULL, 0x000fe200078e003cULL, 0x000000375900720cULL, 0x080fe20003f46070ULL,
0x000000000a477faeULL, 0x0005e2000d901c46ULL, 0x000000375d00720cULL, 0x080fe20003f66070ULL,
0x0000000863657824ULL, 0x040fe200078e00ffULL, 0x000000376300720cULL, 0x080fe20003fa6070ULL,
0x000000003c4b7faeULL, 0x0007e2000e101c46ULL, 0x000000376100720cULL, 0x080fe20003f86070ULL,
0x000000105f5f7824ULL, 0x000fe200078e022aULL, 0x000000373f00720cULL, 0x000fe20003fc6070ULL,
0x0000000159087824ULL, 0x002fe200078e0240ULL, 0xfffffff865377812ULL, 0x000fe200078ee23eULL,
0x00000001633e7824ULL, 0x000fe200078e0240ULL, 0x000000003f427212ULL, 0x040fe200078e3cffULL,
0x000000083f457824ULL, 0x000fe200078e00ffULL, 0x000000405d0a7210ULL, 0x004fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0041ULL, 0x0000002a5b5b7211ULL, 0x000fc400078e20ffULL,
0xfffffff845457812ULL, 0x000fe200078ee242ULL, 0x00000001613c7824ULL, 0x108fe400078e0240ULL,
0x000000013f407824ULL, 0x000fe400078e0240ULL, 0x00005e000a0a7625ULL, 0x000fc800078e0041ULL,
0x00005e003c3c7625ULL, 0x000fc800078e0041ULL, 0x00005e003e3e7625ULL, 0x000fc800078e0041ULL,
0x00005e0040407625ULL, 0x000fc800078e0041ULL, 0x0000001043087825ULL, 0x000fc800078e0008ULL,
0x00000010430a7825ULL, 0x040fe200078e000aULL, 0x00000000085b7faeULL, 0x0003e6000d101c46ULL,
0x00000010433c7825ULL, 0x000fe200078e003cULL, 0x000000000a5f7faeULL, 0x0003e6000d901c46ULL,
0x0000001049497824ULL, 0x000fe400078e022aULL, 0x00000010433e7825ULL, 0x000fc600078e003eULL,
0x000000003c497faeULL, 0x0003e2000e101c46ULL, 0x0000001037377824ULL, 0x000fe400078e022aULL,
0x0000001043407825ULL, 0x000fc600078e0040ULL, 0x000000003e377faeULL, 0x0003e2000e901c46ULL,
0x0000001045457824ULL, 0x000fca00078e022aULL, 0x0000000040457faeULL, 0x0003e2000f101c46ULL,
0x000004c000007947ULL, 0x000fea0003800000ULL, 0x00000003ff097819ULL, 0x000fe20000011600ULL,
0x00000200ff477424ULL, 0x000fe400078e00ffULL, 0x0000000136377824ULL, 0x000fe200078e022dULL,
0x0000000c09417810ULL, 0x040fe40007ffe0ffULL, 0x00000008093f7810ULL, 0x040fe40007ffe0ffULL,
0x00000004093d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008413c7824ULL, 0x040fe200078e00ffULL,
0x00000000410b7212ULL, 0x080fe200078e3cffULL, 0x000000083f597824ULL, 0x000fe200078e00ffULL,
0x000000003d087212ULL, 0x000fe200078e3cffULL, 0x00000001413e7824ULL, 0x000fe200078e0240ULL,
0x000000033d4b7819ULL, 0x000fc400000006ffULL, 0xfffffff83c5b7812ULL, 0x000fe200078ee20bULL,
0x000000013f3c7824ULL, 0x040fe200078e0240ULL, 0x000000003f0a7212ULL, 0x000fe400078e3cffULL,
0x00000007090b7812ULL, 0x040fe400078e4800ULL, 0x0000001409457810ULL, 0x040fe40007ffe0ffULL,
0x0000001009437810ULL, 0x040fe40007ffe0ffULL, 0x0000001809497810ULL, 0x000fe20007ffe0ffULL,
0x0000000845587824ULL, 0x000fe200078e00ffULL, 0x0000001c095d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000143427824ULL, 0x000fe200078e0240ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL,
0x0000000145447824ULL, 0x000fe200078e0240ULL, 0xfffffff859597812ULL, 0x000fe200078ee20aULL,
0x000000013d0a7824ULL, 0x100fe200078e0240ULL, 0x0000004009087210ULL, 0x000fe20007ffe0ffULL,
0x0000000149467824ULL, 0x000fe200078e0240ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef800ULL,
0x000000015d487824ULL, 0x000fe200078e0240ULL, 0x00000000433d7212ULL, 0x080fe200078e3cffULL,
0x000000085d5a7824ULL, 0x000fe200078e00ffULL, 0x00000003434a7819ULL, 0x000fe200000006ffULL,
0x00005e0008087625ULL, 0x000fe200078e0047ULL, 0x00000000453f7212ULL, 0x000fc400078e3cffULL,
0x0000000049407212ULL, 0x080fe200078e3cffULL, 0x000000104b4b7824ULL, 0x100fe200078e022aULL,
0x0000000349617819ULL, 0x000fe200000006ffULL, 0x000000100b497824ULL, 0x000fe200078e022aULL,
0x000000005d417212ULL, 0x000fe200078e3cffULL, 0x00005e000a0a7625ULL, 0x080fe200078e0047ULL,
0xfffffff84a5d7812ULL, 0x000fe400078ee23dULL, 0xfffffff8585f7812ULL, 0x000fe200078ee23fULL,
0x00005e003c3c7625ULL, 0x000fe200078e0047ULL, 0xfffffff861617812ULL, 0x000fc400078ee240ULL,
0xfffffff85a637812ULL, 0x000fe200078ee241ULL, 0x00005e003e3e7625ULL, 0x000fe200078e0047ULL,
0x0000002a5b5b7211ULL, 0x000fc600078e20ffULL, 0x00005e0042407625ULL, 0x000fc800078e0047ULL,
0x00005e0044427625ULL, 0x000fc800078e0047ULL, 0x0000001037087825ULL, 0x000fc800078e0008ULL,
0x00005e0046447625ULL, 0x080fe200078e0047ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008497faeULL, 0x0003e6000b901c46ULL, 0x00005e0048467625ULL, 0x000fc800078e0047ULL,
0x00000010370a7825ULL, 0x000fc800078e000aULL, 0x0000001059597824ULL, 0x000fe200078e022aULL,
0x000000000a4b7faeULL, 0x0003e2000b901c46ULL, 0x00000010373c7825ULL, 0x000fc800078e003cULL,
0x00000010373e7825ULL, 0x040fe200078e003eULL, 0x000000003c597faeULL, 0x0003e6000b901c46ULL,
0x0000001037407825ULL, 0x000fe200078e0040ULL, 0x000000003e5b7faeULL, 0x0003e6000b901c46ULL,
0x000000105d5d7824ULL, 0x000fe400078e022aULL, 0x0000001037427825ULL, 0x000fc600078e0042ULL,
0x00000000405d7faeULL, 0x0003e2000b901c46ULL, 0x000000105f5f7824ULL, 0x000fe400078e022aULL,
0x0000001037447825ULL, 0x000fc600078e0044ULL, 0x00000000425f7faeULL, 0x0003e2000b901c46ULL,
0x0000001061617824ULL, 0x000fe400078e022aULL, 0x0000001037467825ULL, 0x000fc600078e0046ULL,
0x0000000044617faeULL, 0x0003e2000b901c46ULL, 0x0000001063637824ULL, 0x000fca00078e022aULL,
0x0000000046637faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0001300020587811ULL, 0x000fe400078e20ffULL, 0x00000030ff08723eULL, 0x002fe400000000ffULL,
0x00000002ff377819ULL, 0x000fe40000011600ULL, 0x0000541008687816ULL, 0x000fe40000000008ULL,
0x000130001d087811ULL, 0x000fc600078e20ffULL, 0x00001f3768377589ULL, 0x000fe800000e0000ULL,
0x00001f2f68727589ULL, 0x000fe200000e0000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000005858783bULL, 0x000e680000000200ULL, 0x000000001e64783bULL, 0x000ea80000004200ULL,
0x000000001b60783bULL, 0x000fe80000004200ULL, 0x000000001c6c783bULL, 0x000fe80000004200ULL,
0x000000001a5c783bULL, 0x000fe80000004200ULL, 0x000000000808783bULL, 0x000ee80000000200ULL,
0x000000001944783bULL, 0x000f280000004200ULL, 0x00000000183c783bULL, 0x000f680000004200ULL,
0x000000000340783bULL, 0x000f280000004200ULL, 0x000000000248783bULL, 0x000f220000004200ULL,
0x0000003758589232ULL, 0x002fc40000000000ULL, 0x000000375a5a9232ULL, 0x000fe40000000000ULL,
0x0000007259599232ULL, 0x080fe40000000000ULL, 0x000000725b5b9232ULL, 0x000fce0000000000ULL,
0x000000645804723cULL, 0x004fe20000001804ULL, 0x0000003708089232ULL, 0x008fce0000000000ULL,
0x000000605838723cULL, 0x000fe20000001838ULL, 0x000000370a0a9232ULL, 0x000fe40000000000ULL,
0x0000007209099232ULL, 0x080fe40000000000ULL, 0x000000720b0b9232ULL, 0x000fc60000000000ULL,
0x000000665864723cULL, 0x040ff0000000180cULL, 0x0000006c5868723cULL, 0x040ff00000001810ULL,
0x000000625860723cULL, 0x040ff0000000184cULL, 0x0000006e5850723cULL, 0x040ff00000001850ULL,
0x0000005c584c723cULL, 0x040ff00000001814ULL, 0x0000005e5854723cULL, 0x000ff00000001854ULL,
0x00000044080c723cULL, 0x050ff00000001804ULL, 0x000000460810723cULL, 0x040ff00000001864ULL,
0x0000003c0814723cULL, 0x060ff00000001868ULL, 0x000000400838723cULL, 0x040ff00000001838ULL,
0x0000003e083c723cULL, 0x040ff00000001850ULL, 0x000000420840723cULL, 0x040ff00000001860ULL,
0x000000480844723cULL, 0x040ff0000000184cULL, 0x0000004a0804723cULL, 0x000fe20000001854ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000797000720cULL, 0x000fe20003f26070ULL,
0x01c69800ffff7f8cULL, 0x000fd8000c80043fULL, 0x0000216000001947ULL, 0x000fea0003800000ULL,
0x000000c032327810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000620035507a24ULL, 0x000fe200078e0232ULL, 0x0000058000008947ULL, 0x000fea0003800000ULL,
0x0000003279087217ULL, 0x000fe20007800000ULL, 0x00000200ff517424ULL, 0x000fe200078e00ffULL,
0x00000003ff0b7819ULL, 0x000fe40000011600ULL, 0x0000002d36377210ULL, 0x000fe20007ffe0ffULL,
0x0000000108087824ULL, 0x000fe200078e0a32ULL, 0x000000070b497812ULL, 0x040fe200078e4800ULL,
0x000000010b097824ULL, 0x040fe200078e0250ULL, 0x000000040b4b7810ULL, 0x000fe40007ffe0ffULL,
0x00000020080a7817ULL, 0x000fe20003800000ULL, 0x00005e0009087625ULL, 0x000fe200078e0051ULL,
0x0000000c0b4f7810ULL, 0x000fc40007ffe0ffULL, 0x000000080b4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000084b537824ULL, 0x000fe200078e00ffULL, 0x0000000a0b00720cULL, 0x000fe20003f06070ULL,
0x000000084f577824ULL, 0x000fe200078e00ffULL, 0x0ffffff849327812ULL, 0x000fe200078ef800ULL,
0x0000001037087825ULL, 0x000fe200078e0008ULL, 0x000000004b487212ULL, 0x080fe400078e3cffULL,
0x000000004d4a7212ULL, 0x040fe200078e3cffULL, 0x0000001032497824ULL, 0x000fe200078e021fULL,
0x000000034d557819ULL, 0x000fc400000006ffULL, 0x000000004f4c7212ULL, 0x000fe400078e3cffULL,
0xfffffff853327812ULL, 0x000fe200078ee248ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008497faeULL, 0x0003e2000c101c46ULL, 0xfffffff855527812ULL, 0x000fe400078ee24aULL,
0xfffffff857547812ULL, 0x000fe400078ee24cULL, 0x000000100b537810ULL, 0x040fe40007ffe0ffULL,
0x000000140b557810ULL, 0x000fc40007ffe0ffULL, 0x000000180b577810ULL, 0x000fe20007ffe0ffULL,
0x0000000853567824ULL, 0x000fe200078e00ffULL, 0x0000001c0b597810ULL, 0x000fe20007ffe0ffULL,
0x000000014b087824ULL, 0x142fe200078e0250ULL, 0x0000000a4b00720cULL, 0x080fe20003f06070ULL,
0x0000000855587824ULL, 0x000fe200078e00ffULL, 0x0000000a4d00720cULL, 0x080fe20003f26070ULL,
0x00000008575a7824ULL, 0x000fe200078e00ffULL, 0x0000000a4f00720cULL, 0x080fe20003f46070ULL,
0x00000008595c7824ULL, 0x000fe200078e00ffULL, 0x0000000a5300720cULL, 0x0c0fe20003f66070ULL,
0x00000001534a7824ULL, 0x100fe200078e0250ULL, 0x0000000a5500720cULL, 0x0c0fe20003f86070ULL,
0x00000001554c7824ULL, 0x000fe200078e0250ULL, 0x0000000a5700720cULL, 0x000fc40003fa6070ULL,
0x0000000a5900720cULL, 0x000fe20003fc6070ULL, 0x000000014d0a7824ULL, 0x100fe200078e0250ULL,
0x000000504f487210ULL, 0x000fe20007ffe0ffULL, 0x00005e004c4c7625ULL, 0x000fe200078e0051ULL,
0x0000000053097212ULL, 0x080fe400078e3cffULL, 0x00000000550b7212ULL, 0x000fe200078e3cffULL,
0x0000001054557824ULL, 0x000fe200078e021fULL, 0x00000050574e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000159507824ULL, 0x000fe200078e0250ULL, 0x0000000057497212ULL, 0x080fe200078e3cffULL,
0x00000010374c7825ULL, 0x000fe200078e004cULL, 0x00000000594b7212ULL, 0x000fc400078e3cffULL,
0xfffffff856567812ULL, 0x000fe200078ee209ULL, 0x00005e0008087625ULL, 0x080fe200078e0051ULL,
0xfffffff858587812ULL, 0x000fe400078ee20bULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee249ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0051ULL, 0xfffffff85c5c7812ULL, 0x000fe400078ee24bULL,
0x0000001f52537211ULL, 0x000fe200078e20ffULL, 0x00005e0048487625ULL, 0x000fc800078e0051ULL,
0x00005e004a4a7625ULL, 0x000fc800078e0051ULL, 0x00005e004e4e7625ULL, 0x000fc800078e0051ULL,
0x00005e0050507625ULL, 0x000fc800078e0051ULL, 0x0000001037087825ULL, 0x000fc800078e0008ULL,
0x00000010370a7825ULL, 0x000fc800078e000aULL, 0x0000001037487825ULL, 0x000fc800078e0048ULL,
0x00000010374a7825ULL, 0x000fc800078e004aULL, 0x00000010374e7825ULL, 0x000fc800078e004eULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001032377824ULL, 0x100fe400078e021fULL,
0x0000001056577824ULL, 0x100fe400078e021fULL, 0x0000001058597824ULL, 0x100fe200078e021fULL,
0x0000000008377faeULL, 0x0003e2000c101c46ULL, 0x000000105a5b7824ULL, 0x000fe200078e021fULL,
0x0000001f5c1f7211ULL, 0x000fe400078e20ffULL, 0x000000000a537faeULL, 0x0003e8000c901c46ULL,
0x0000000048557faeULL, 0x0003e8000d101c46ULL, 0x000000004a577faeULL, 0x0003e8000d901c46ULL,
0x000000004c597faeULL, 0x0003e8000e101c46ULL, 0x000000004e5b7faeULL, 0x0003e8000e901c46ULL,
0x00000000501f7faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff097819ULL, 0x000fe40000011600ULL, 0x0000020000537802ULL, 0x000fc40000000f00ULL,
0x00000008094b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c094d7810ULL, 0x040fe40007ffe0ffULL,
0x0000000409497810ULL, 0x000fe20007ffe0ffULL, 0x000000084b4f7824ULL, 0x040fe200078e00ffULL,
0x000000004b0a7212ULL, 0x080fe200078e3cffULL, 0x000000084d587824ULL, 0x040fe200078e00ffULL,
0x000000004d0b7212ULL, 0x080fe200078e3cffULL, 0x0000000849377824ULL, 0x040fe200078e00ffULL,
0x0000000049087212ULL, 0x040fe200078e3cffULL, 0x0000000149327824ULL, 0x000fe200078e0250ULL,
0xfffffff84f567812ULL, 0x000fe200078ee20aULL, 0x000000014b487824ULL, 0x100fe200078e0250ULL,
0xfffffff858587812ULL, 0x000fe200078ee20bULL, 0x000000014d4a7824ULL, 0x000fe200078e0250ULL,
0x00000010094f7810ULL, 0x000fc40007ffe0ffULL, 0x0000001409517810ULL, 0x040fe40007ffe0ffULL,
0x0000001809557810ULL, 0x000fe20007ffe0ffULL, 0x000000084f5a7824ULL, 0x000fe200078e00ffULL,
0x0000001c09577810ULL, 0x000fe20007ffe0ffULL, 0x00000008515c7824ULL, 0x000fe200078e00ffULL,
0xfffffff837547812ULL, 0x000fe200078ee208ULL, 0x0000000109087824ULL, 0x040fe200078e0250ULL,
0x00000007090b7812ULL, 0x100fe200078e4800ULL, 0x00000008555e7824ULL, 0x000fe200078e00ffULL,
0x000000504f4c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000857627824ULL, 0x000fe200078e00ffULL,
0x0ffffff80b0a7812ULL, 0x000fe200078ef800ULL, 0x00005e0008087625ULL, 0x000fe200078e0053ULL,
0x000000004f0b7212ULL, 0x000fc400078e3cffULL, 0x0000000051497212ULL, 0x0c0fe200078e3cffULL,
0x00000001514e7824ULL, 0x100fe200078e0250ULL, 0x00000000554b7212ULL, 0x0c0fe200078e3cffULL,
0x0000000155527824ULL, 0x000fe200078e0250ULL, 0x00000000574d7212ULL, 0x040fe200078e3cffULL,
0x0000000136377824ULL, 0x000fe200078e022dULL, 0x0000005057607210ULL, 0x000fe20007ffe0ffULL,
0x000000100a557824ULL, 0x000fe200078e021fULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee20bULL,
0x00005e00320a7625ULL, 0x000fe200078e0053ULL, 0xfffffff85c5c7812ULL, 0x000fc400078ee249ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee24bULL, 0x00005e0048487625ULL, 0x000fe200078e0053ULL,
0xfffffff862627812ULL, 0x000fc600078ee24dULL, 0x00005e004a4a7625ULL, 0x000fc800078e0053ULL,
0x00005e004c4c7625ULL, 0x000fc800078e0053ULL, 0x00005e004e4e7625ULL, 0x000fc800078e0053ULL,
0x00005e0052507625ULL, 0x000fc800078e0053ULL, 0x0000001037087825ULL, 0x000fc800078e0008ULL,
0x00005e0060527625ULL, 0x000fe200078e0053ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008557faeULL, 0x0003e6000b901c46ULL, 0x00000010370a7825ULL, 0x000fc800078e000aULL,
0x0000001037487825ULL, 0x000fc800078e0048ULL, 0x00000010374a7825ULL, 0x000fc800078e004aULL,
0x00000010374c7825ULL, 0x000fc800078e004cULL, 0x00000010374e7825ULL, 0x000fc800078e004eULL,
0x0000001037507825ULL, 0x000fc800078e0050ULL, 0x0000001037527825ULL, 0x000fe200078e0052ULL,
0x0000001f56377211ULL, 0x000fc600078e20ffULL, 0x0000001054097824ULL, 0x102fe400078e021fULL,
0x0000001058557824ULL, 0x100fe400078e021fULL, 0x000000105a577824ULL, 0x100fe200078e021fULL,
0x000000000a097faeULL, 0x0003e2000b901c46ULL, 0x000000105c597824ULL, 0x100fe400078e021fULL,
0x000000105e5b7824ULL, 0x000fe200078e021fULL, 0x0000001f621f7211ULL, 0x000fe200078e20ffULL,
0x0000000048377faeULL, 0x0003e8000b901c46ULL, 0x000000004a557faeULL, 0x0003e8000b901c46ULL,
0x000000004c577faeULL, 0x0003e8000b901c46ULL, 0x000000004e597faeULL, 0x0003e8000b901c46ULL,
0x00000000505b7faeULL, 0x0003e8000b901c46ULL, 0x00000000521f7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01c6680036087f8cULL, 0x002fe8000c80043fULL, 0x01c66c00360b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x3e000000ff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000a000b7305ULL, 0x0002a4000021f000ULL,
0x3fa000000a0a7823ULL, 0x002fe200000100ffULL, 0x0000000b0000735dULL, 0x004fe40003800000ULL,
0x01c66c00360b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xffffff9000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x01c18000310b7984ULL, 0x000e680000000800ULL,
0x01c38000310a7984ULL, 0x0004e20000000800ULL, 0x000000340b00720bULL, 0x002fe20003f1d000ULL,
0x0000ccc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x0000ffff08327812ULL, 0x000fe2000780c0ffULL, 0x000003a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1f7424ULL, 0x000fd600078e00ffULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x000000037a00780cULL, 0x000fe40003f05270ULL, 0x000000340b00720bULL, 0x000fe20003f34000ULL,
0x0000cca27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fe400008e0100ULL,
0x0000000b34097209ULL, 0x000fe40007810000ULL, 0x0000ffff08377812ULL, 0x000fe400078e3cffULL,
0x00000002ff4c7819ULL, 0x000fe20000011600ULL, 0x80000009341f7221ULL, 0x000fe20000010000ULL,
0x01c5800931008388ULL, 0x0003e20000000800ULL, 0x0000003732ff7212ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL, 0x0000001f004b7308ULL, 0x000ea40000000800ULL,
0x0000004b33337220ULL, 0x004fe20000410000ULL, 0x0000cc527f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b087589ULL, 0x0022a400000e0000ULL, 0x000000080c0c7220ULL, 0x084fe40000410000ULL,
0x000000080d0d7220ULL, 0x080fe40000410000ULL, 0x0000000810107220ULL, 0x080fe40000410000ULL,
0x0000000811117220ULL, 0x080fe40000410000ULL, 0x0000000814147220ULL, 0x000fc40000410000ULL,
0x0000000815157220ULL, 0x080fe40000410000ULL, 0x000000083c3c7220ULL, 0x080fe40000410000ULL,
0x000000083d3d7220ULL, 0x080fe40000410000ULL, 0x0000000838387220ULL, 0x080fe40000410000ULL,
0x0000000839397220ULL, 0x080fe40000410000ULL, 0x0000000840407220ULL, 0x000fc40000410000ULL,
0x0000000841417220ULL, 0x080fe40000410000ULL, 0x0000000844447220ULL, 0x080fe40000410000ULL,
0x0000000845457220ULL, 0x080fe40000410000ULL, 0x0000000804047220ULL, 0x080fe40000410000ULL,
0x0000000805057220ULL, 0x000fe20000410000ULL, 0x0000cb927f007947ULL, 0x000fea000b800000ULL,
0x00001f2f4b087589ULL, 0x00052400000e0000ULL, 0x0000000b34347209ULL, 0x000fe20007810000ULL,
0x000000080e0e7220ULL, 0x090fe20000410000ULL, 0x00000001ff1f7807ULL, 0x000fe20000000000ULL,
0x000000080f0f7220ULL, 0x000fc40000410000ULL, 0x800000340b0b0221ULL, 0x000fe40000010000ULL,
0x0000000812127220ULL, 0x080fe40000410000ULL, 0x3fb8aa3b0b0b0820ULL, 0x000fe40000410000ULL,
0x0000000813137220ULL, 0x080fe40000410000ULL, 0x0000000b00300308ULL, 0x000f220000000800ULL,
0x0000000816167220ULL, 0x080fe40000410000ULL, 0x0000000817177220ULL, 0x000fc40000410000ULL,
0x000000083e3e7220ULL, 0x080fe40000410000ULL, 0x000000083f3f7220ULL, 0x080fe40000410000ULL,
0x000000083a3a7220ULL, 0x080fe40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x0000000842427220ULL, 0x080fe40000410000ULL, 0x0000000843437220ULL, 0x000fc40000410000ULL,
0x0000000846467220ULL, 0x080fe40000410000ULL, 0x0000000847477220ULL, 0x080fe40000410000ULL,
0x0000000806067220ULL, 0x080fe40000410000ULL, 0x0000000807077220ULL, 0x000fe40000410000ULL,
0x0000000a300a0220ULL, 0x018fe40000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000030ff08723eULL, 0x000fe200000000ffULL, 0x000000330a337221ULL, 0x008fe20000010000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000002ff4c7819ULL, 0x002fe40000011600ULL,
0x00005410084b7816ULL, 0x004fe20000000008ULL, 0x0000ca227f007947ULL, 0x000fea000b800000ULL,
0x00001f4c4b317589ULL, 0x0002a800000e0000ULL, 0x00001f2f4b327589ULL, 0x0002e400000e0000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002eULL,
0x00008b4000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x0000d15000007944ULL, 0x00cfea0003c00000ULL,
0x000000537f007947ULL, 0x000fea000b800000ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002cULL,
0x0000001f004d7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x00008ba000487802ULL, 0x000fc40000000f00ULL, 0x0000d0f000007944ULL, 0x00cfea0003c00000ULL,
0x000138002b087811ULL, 0x000fe200078e20ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000294c783bULL, 0x002fe20000004200ULL, 0x0001380025257811ULL, 0x000fc400078e20ffULL,
0x000099101f1f7816ULL, 0x000fe200000000ffULL, 0x000000000808783bULL, 0x000e660000000200ULL,
0x000000ff1f00720cULL, 0x000fe20003f05270ULL, 0x000000002850783bULL, 0x000fe20000004200ULL,
0x000003007b1f7a10ULL, 0x000fc60007ffe0ffULL, 0x000000002754783bULL, 0x000fe80000004200ULL,
0x000000002658783bULL, 0x000fe80000004200ULL, 0x000000002548783bULL, 0x004ea80000000200ULL,
0x00000000245c783bULL, 0x000f280000004200ULL, 0x000000002360783bULL, 0x000f680000004200ULL,
0x000000002264783bULL, 0x0007280000004200ULL, 0x000000002168783bULL, 0x0003220000004200ULL,
0x000001001f227824ULL, 0x048fe200078e00ffULL, 0x0000003108088232ULL, 0x082fe20000000000ULL,
0x000000011f217810ULL, 0x000fe20007ffe0ffULL, 0x000000310a0a8232ULL, 0x000fc40000000000ULL,
0x0000003209098232ULL, 0x080fe20000000000ULL, 0x000000782100720cULL, 0x000fe20003f26070ULL,
0x000000320b0b8232ULL, 0x000fce0000000000ULL, 0x0000004c080c723cULL, 0x000fe2000000180cULL,
0x0000003148488232ULL, 0x084fe40000000000ULL, 0x000000314a4a8232ULL, 0x000fe40000000000ULL,
0x0000003249498232ULL, 0x000fc60000000000ULL, 0x0000004e0810723cULL, 0x000fe20000001810ULL,
0x000000324b4b8232ULL, 0x000fce0000000000ULL, 0x000000500814723cULL, 0x040ff00000001814ULL,
0x00000052083c723cULL, 0x040ff0000000183cULL, 0x000000540838723cULL, 0x040ff00000001838ULL,
0x000000580844723cULL, 0x040ff00000001844ULL, 0x000000560824723cULL, 0x040ff00000001840ULL,
0x0000005a0858723cULL, 0x000ff00000001804ULL, 0x0000005c4804723cULL, 0x050ff0000000180cULL,
0x0000005e4808723cULL, 0x040ff00000001810ULL, 0x00000060480c723cULL, 0x060ff00000001814ULL,
0x000000624810723cULL, 0x040ff0000000183cULL, 0x000000644814723cULL, 0x040ff00000001838ULL,
0x000000664824723cULL, 0x040ff00000001824ULL, 0x000000684838723cULL, 0x040fee0000001844ULL,
0x0000620035447a24ULL, 0x000fe200078e0222ULL, 0x0000006a483c723cULL, 0x000fe20000001858ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000058000009947ULL, 0x000fea0003800000ULL,
0x00000003ff217819ULL, 0x000fe20000011600ULL, 0x00000200ff457424ULL, 0x000fe200078e00ffULL,
0x00000022791f7217ULL, 0x000fe40007800000ULL, 0x0000000421297810ULL, 0x000fe40007ffe0ffULL,
0x0000002d362b7210ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0a22ULL,
0x0000000029237212ULL, 0x040fe200078e3cffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x0000000821377810ULL, 0x040fe20007ffe0ffULL, 0x0000000121227824ULL, 0x000fe200078e0244ULL,
0x000000201f1f7817ULL, 0x000fc40003800000ULL, 0xfffffff828317812ULL, 0x000fe200078ee223ULL,
0x0000000129287824ULL, 0x000fe200078e0244ULL, 0x0000000721237812ULL, 0x000fe200078e4800ULL,
0x0000000837477824ULL, 0x000fe200078e00ffULL, 0x0000001f2100720cULL, 0x000fe20003f26070ULL,
0x0000001031317824ULL, 0x000fe200078e022aULL, 0x0ffffff8232d7812ULL, 0x000fe200078ef800ULL,
0x00005e0022227625ULL, 0x000fe200078e0045ULL, 0x0000001f2900720cULL, 0x000fe40003f46070ULL,
0x00000018214d7810ULL, 0x040fe20007ffe0ffULL, 0x00005e0028287625ULL, 0x000fe200078e0045ULL,
0x0000000c21417810ULL, 0x000fc40007ffe0ffULL, 0x0000001c214f7810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e022aULL, 0x00000000372c7212ULL, 0x080fe200078e3cffULL,
0x000000102b227825ULL, 0x000fe200078e0022ULL, 0x0000001021437810ULL, 0x000fe40007ffe0ffULL,
0x00000000412e7212ULL, 0x000fe200078e3cffULL, 0x000000102b287825ULL, 0x000fe200078e0028ULL,
0x0000000341497819ULL, 0x000fe200000006ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000222d7faeULL, 0x0003e2000c901c46ULL, 0x00000014214b7810ULL, 0x000fe20007ffe0ffULL,
0x000000084d467824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee22cULL,
0x0000000028317faeULL, 0x0005e2000d101c46ULL, 0x000000084f487824ULL, 0x000fe200078e00ffULL,
0x00000044432c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014b407824ULL, 0x000fe200078e0244ULL,
0xfffffff849497812ULL, 0x000fe200078ee22eULL, 0x00000008432e7824ULL, 0x000fe200078e00ffULL,
0x0000001f3700720cULL, 0x080fe20003f26070ULL, 0x000000084b327824ULL, 0x000fe200078e00ffULL,
0x000000004d237212ULL, 0x082fe200078e3cffULL, 0x0000000137227824ULL, 0x100fe200078e0244ULL,
0x0000001f4100720cULL, 0x080fe20003f46070ULL, 0x000000014d427824ULL, 0x100fe200078e0244ULL,
0x000000004f297212ULL, 0x004fe200078e3cffULL, 0x0000000141287824ULL, 0x000fe200078e0244ULL,
0x0000001f4300720cULL, 0x000fe20003f66070ULL, 0x00005e002c2c7625ULL, 0x000fe200078e0045ULL,
0x0000001f4b00720cULL, 0x000fc40003f86070ULL, 0x0000001f4d00720cULL, 0x000fe20003fa6070ULL,
0x00005e0040407625ULL, 0x000fe200078e0045ULL, 0x0000001f4f00720cULL, 0x000fe40003fc6070ULL,
0xfffffff846317812ULL, 0x000fe200078ee223ULL, 0x00005e0022227625ULL, 0x080fe200078e0045ULL,
0x00000000431f7212ULL, 0x080fe400078e3cffULL, 0x000000004b217212ULL, 0x000fe200078e3cffULL,
0x00005e0042427625ULL, 0x000fe200078e0045ULL, 0x000000444f447210ULL, 0x000fc40007ffe0ffULL,
0xfffffff848377812ULL, 0x000fe200078ee229ULL, 0x00005e0028287625ULL, 0x080fe200078e0045ULL,
0xfffffff82e1f7812ULL, 0x000fe400078ee21fULL, 0xfffffff832217812ULL, 0x000fe200078ee221ULL,
0x00005e0044447625ULL, 0x000fe200078e0045ULL, 0x0000002a1f1f7211ULL, 0x000fc600078e20ffULL,
0x000000102b227825ULL, 0x000fc800078e0022ULL, 0x0000001047477824ULL, 0x000fe400078e022aULL,
0x000000102b287825ULL, 0x000fc600078e0028ULL, 0x0000000022477faeULL, 0x0003e2000c901c46ULL,
0x0000001049497824ULL, 0x000fe400078e022aULL, 0x000000102b2c7825ULL, 0x000fc600078e002cULL,
0x0000000028497faeULL, 0x0003e2000d101c46ULL, 0x000000102b407825ULL, 0x000fc600078e0040ULL,
0x000000002c1f7faeULL, 0x0003e2000d901c46ULL, 0x0000001021217824ULL, 0x000fe400078e022aULL,
0x000000102b427825ULL, 0x000fc600078e0042ULL, 0x0000000040217faeULL, 0x0003e2000e101c46ULL,
0x0000001031317824ULL, 0x000fe400078e022aULL, 0x000000102b447825ULL, 0x000fc600078e0044ULL,
0x0000000042317faeULL, 0x0003e2000e901c46ULL, 0x0000001037377824ULL, 0x000fca00078e022aULL,
0x0000000044377faeULL, 0x0003e2000f101c46ULL, 0x000004c000007947ULL, 0x000fea0003800000ULL,
0x00000003ff1f7819ULL, 0x000fe20000011600ULL, 0x00000200ff497424ULL, 0x000fc600078e00ffULL,
0x000000041f297810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1f417810ULL, 0x000fe40007ffe0ffULL,
0x0000000029217212ULL, 0x0c0fe200078e3cffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x000000081f317810ULL, 0x000fe20007ffe0ffULL, 0x00000008412c7824ULL, 0x040fe200078e00ffULL,
0x0000000041237212ULL, 0x040fe200078e3cffULL, 0x0000000141407824ULL, 0x000fe200078e0244ULL,
0xfffffff8282b7812ULL, 0x000fe200078ee221ULL, 0x0000000136217824ULL, 0x000fe200078e022dULL,
0x000000101f2d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000031227212ULL, 0x000fe200078e3cffULL,
0x000000102b2b7824ULL, 0x000fe200078e022aULL, 0x0000000331377819ULL, 0x000fe200000006ffULL,
0x000000082d4a7824ULL, 0x000fe200078e00ffULL, 0x000000141f437810ULL, 0x000fe20007ffe0ffULL,
0x000000012d427824ULL, 0x100fe200078e0244ULL, 0x000000181f457810ULL, 0x040fe40007ffe0ffULL,
0x0000001c1f477810ULL, 0x000fe20007ffe0ffULL, 0x00000008434c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c4b7812ULL, 0x000fe200078ee223ULL, 0x00000001312c7824ULL, 0x000fe200078e0244ULL,
0xfffffff837377812ULL, 0x000fe200078ee222ULL, 0x000000011f227824ULL, 0x040fe200078e0244ULL,
0x000000071f237812ULL, 0x000fe200078e4800ULL, 0x0000000145467824ULL, 0x100fe200078e0244ULL,
0x0000004429287210ULL, 0x000fe20007ffe0ffULL, 0x0000000147487824ULL, 0x000fe200078e0244ULL,
0x000000002d297212ULL, 0x000fe200078e3cffULL, 0x00000008454f7824ULL, 0x000fe200078e00ffULL,
0x00000044432e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e022aULL,
0x00000000432d7212ULL, 0x080fe200078e3cffULL, 0x00005e0042427625ULL, 0x000fe200078e0049ULL,
0x0000000047417212ULL, 0x000fc400078e3cffULL, 0x0000000347447819ULL, 0x000fe200000006ffULL,
0x00005e0046467625ULL, 0x080fe200078e0049ULL, 0x0ffffff8231f7812ULL, 0x000fe400078ef800ULL,
0xfffffff84a317812ULL, 0x000fe200078ee229ULL, 0x00005e0022227625ULL, 0x080fe200078e0049ULL,
0xfffffff84c4d7812ULL, 0x000fe400078ee22dULL, 0xfffffff844517812ULL, 0x000fe200078ee241ULL,
0x00005e0028287625ULL, 0x000fe200078e0049ULL, 0x0000000045327212ULL, 0x000fc400078e3cffULL,
0x0000002a31317211ULL, 0x000fe200078e20ffULL, 0x00005e002c2c7625ULL, 0x000fe200078e0049ULL,
0xfffffff84f4f7812ULL, 0x000fc600078ee232ULL, 0x00005e0040407625ULL, 0x000fc800078e0049ULL,
0x00005e002e447625ULL, 0x000fc800078e0049ULL, 0x000000101f1f7824ULL, 0x000fe400078e022aULL,
0x0000001021227825ULL, 0x000fc800078e0022ULL, 0x00005e0048487625ULL, 0x000fe200078e0049ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000221f7faeULL, 0x0003e6000b901c46ULL,
0x0000001021287825ULL, 0x000fc800078e0028ULL, 0x00000010212c7825ULL, 0x040fe200078e002cULL,
0x00000000282b7faeULL, 0x0003e6000b901c46ULL, 0x0000001021407825ULL, 0x000fe200078e0040ULL,
0x000000002c377faeULL, 0x0003e6000b901c46ULL, 0x000000104b4b7824ULL, 0x000fe400078e022aULL,
0x0000001021427825ULL, 0x000fc600078e0042ULL, 0x00000000404b7faeULL, 0x0003e2000b901c46ULL,
0x0000001021447825ULL, 0x000fc600078e0044ULL, 0x0000000042317faeULL, 0x0003e2000b901c46ULL,
0x000000104d4d7824ULL, 0x000fe400078e022aULL, 0x0000001021467825ULL, 0x000fc600078e0046ULL,
0x00000000444d7faeULL, 0x0003e2000b901c46ULL, 0x000000104f4f7824ULL, 0x000fe400078e022aULL,
0x0000001021487825ULL, 0x000fc600078e0048ULL, 0x00000000464f7faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x000fca00078e022aULL, 0x0000000048517faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0001380020207811ULL, 0x000fe400078e20ffULL,
0x00000030ff2c723eULL, 0x002fe400000000ffULL, 0x00000002ff1f7819ULL, 0x000fe40000011600ULL,
0x000138001d1d7811ULL, 0x000fe200078e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002020783bULL, 0x000fe80000000200ULL, 0x000000001e28783bULL, 0x000fe80000004200ULL,
0x000000001c40783bULL, 0x0003e80000004200ULL, 0x000000001b44783bULL, 0x000fe80000004200ULL,
0x000000001a48783bULL, 0x000fe20000004200ULL, 0x000054102c1c7816ULL, 0x002fc6000000002cULL,
0x000000001d4c783bULL, 0x000fe80000000200ULL, 0x00001f1f1c1f7589ULL, 0x000e6800000e0000ULL,
0x00001f2f1c2c7589ULL, 0x000ea800000e0000ULL, 0x000000001950783bULL, 0x000ee80000004200ULL,
0x000000001854783bULL, 0x0009680000004200ULL, 0x000000000358783bULL, 0x000ee80000004200ULL,
0x00000000025c783bULL, 0x000ee20000004200ULL, 0x0000001f20208232ULL, 0x002fc40000000000ULL,
0x0000001f22228232ULL, 0x080fe40000000000ULL, 0x0000002c21218232ULL, 0x084fe40000000000ULL,
0x0000002c23238232ULL, 0x000fe40000000000ULL, 0x0000001f4c4c8232ULL, 0x000fca0000000000ULL,
0x000000282004723cULL, 0x000fe20000001804ULL, 0x0000001f4e4e8232ULL, 0x000fe40000000000ULL,
0x0000002c4d4d8232ULL, 0x080fe40000000000ULL, 0x0000002c4f4f8232ULL, 0x000fc60000000000ULL,
0x0000002a2008723cULL, 0x040ff00000001808ULL, 0x000000402028723cULL, 0x040ff0000000180cULL,
0x000000442018723cULL, 0x050ff00000001814ULL, 0x000000462024723cULL, 0x040ff00000001824ULL,
0x000000422040723cULL, 0x040ff00000001810ULL, 0x000000482044723cULL, 0x040ff00000001838ULL,
0x0000004a2020723cULL, 0x000ff0000000183cULL, 0x000000504c0c723cULL, 0x048ff00000001804ULL,
0x000000564c3c723cULL, 0x060ff00000001840ULL, 0x000000524c10723cULL, 0x040ff00000001808ULL,
0x000000544c14723cULL, 0x040ff00000001828ULL, 0x000000584c38723cULL, 0x040ff00000001818ULL,
0x0000005a4c40723cULL, 0x040ff00000001824ULL, 0x0000005c4c44723cULL, 0x040ff00000001844ULL,
0x0000005e4c04723cULL, 0x000fe20000001820ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x01c6a000ffff7f8cULL, 0x000fe4000c80043fULL,
0x000003007b7b7a10ULL, 0x000fc80007ffe0ffULL, 0x000000787b00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff764000007947ULL, 0x000fea000383ffffULL,
0x0000000000317919ULL, 0x000e620000002500ULL, 0x0000000600187202ULL, 0x000fe20000000f00ULL,
0x000000ffff0a7224ULL, 0x000fe400078e0005ULL, 0x000000ffff197224ULL, 0x000fe400078e0007ULL,
0x000000ffff0b7224ULL, 0x000fe400078e0004ULL, 0x000000ffff067224ULL, 0x000fe400078e0015ULL,
0x000000ffff057224ULL, 0x000fe200078e0014ULL, 0x000000783100720cULL, 0x002fda0003f06070ULL,
0x0000035000000947ULL, 0x000fea0003800000ULL, 0x0180000033007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x00000033002f7202ULL, 0x000fe40000000f00ULL, 0x00009d3000147802ULL, 0x000fe40000000f00ULL,
0x0000bdb000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000003300007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000033ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fe40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000027919ULL, 0x000ee20000000000ULL,
0x0000000803037811ULL, 0x004fe400078ff0ffULL, 0x00000002ff077819ULL, 0x008fc80000011602ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0700027589ULL, 0x000ee200000e0000ULL,
0x0000000e030e7220ULL, 0x044fe40000410000ULL, 0x0000000f030f7220ULL, 0x000fe40000410000ULL,
0x0000000c020c7220ULL, 0x048fe40000410000ULL, 0x0000000d020d7220ULL, 0x000fc40000410000ULL,
0x0000001002107220ULL, 0x040fe40000410000ULL, 0x0000001102117220ULL, 0x040fe40000410000ULL,
0x0000000502057220ULL, 0x040fe40000410000ULL, 0x0000000602067220ULL, 0x040fe40000410000ULL,
0x0000003c023c7220ULL, 0x040fe40000410000ULL, 0x0000003d023d7220ULL, 0x000fc40000410000ULL,
0x0000003802387220ULL, 0x040fe40000410000ULL, 0x0000003902397220ULL, 0x040fe40000410000ULL,
0x0000004002407220ULL, 0x040fe40000410000ULL, 0x0000004102417220ULL, 0x040fe40000410000ULL,
0x0000004402447220ULL, 0x040fe40000410000ULL, 0x0000004502457220ULL, 0x000fc40000410000ULL,
0x0000000b020b7220ULL, 0x040fe40000410000ULL, 0x0000000a020a7220ULL, 0x000fe40000410000ULL,
0x0000001203127220ULL, 0x040fe40000410000ULL, 0x0000001303137220ULL, 0x040fe40000410000ULL,
0x0000001603167220ULL, 0x040fe40000410000ULL, 0x0000001703177220ULL, 0x000fc40000410000ULL,
0x0000003e033e7220ULL, 0x040fe40000410000ULL, 0x0000003f033f7220ULL, 0x040fe40000410000ULL,
0x0000003a033a7220ULL, 0x040fe40000410000ULL, 0x0000003b033b7220ULL, 0x040fe40000410000ULL,
0x0000004203427220ULL, 0x040fe40000410000ULL, 0x0000004303437220ULL, 0x000fc40000410000ULL,
0x0000004603467220ULL, 0x040fe40000410000ULL, 0x0000004703477220ULL, 0x040fe40000410000ULL,
0x0000001803187220ULL, 0x040fe40000410000ULL, 0x0000001903197220ULL, 0x000fe40000410000ULL,
0x00000000001c7919ULL, 0x000ea20000000000ULL, 0x0000000c0d03723eULL, 0x000fe400000000ffULL,
0x00000016170d723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x00000012130c723eULL, 0x000fc400000000ffULL, 0x000000181912723eULL, 0x000fe400000000ffULL,
0x000000101104723eULL, 0x000fe400000000ffULL, 0x000000050605723eULL, 0x000fe400000000ffULL,
0x0000003c3d06723eULL, 0x000fe400000000ffULL, 0x000000383907723eULL, 0x000fe400000000ffULL,
0x000000404108723eULL, 0x000fc400000000ffULL, 0x000000444509723eULL, 0x000fe400000000ffULL,
0x0000000b0a0a723eULL, 0x000fe400000000ffULL, 0x0000000e0f0b723eULL, 0x000fe400000000ffULL,
0x00000002ff1f7819ULL, 0x004fe4000001161cULL, 0x000000081c2d7811ULL, 0x000fe400078ff0ffULL,
0x0000001fff217212ULL, 0x000fe200078e33ffULL, 0x000000081f147824ULL, 0x000fe200078e00ffULL,
0x0000002dff2f7212ULL, 0x002fe200078e33ffULL, 0x000000082d167824ULL, 0x000fe200078e00ffULL,
0x000000071f007812ULL, 0x040fe200078ec0ffULL, 0x000000081f027824ULL, 0x000fe200078e00ffULL,
0xfffffff814217812ULL, 0x000fc400078ee221ULL, 0xfffffff8162f7812ULL, 0x000fe400078ee22fULL,
0xfffffff802137812ULL, 0x000fe400078ee21fULL, 0x0000000200147812ULL, 0x040fe400078e3cffULL,
0x0000000300167812ULL, 0x040fe400078e3cffULL, 0x0000000400187812ULL, 0x040fe200078e3cffULL,
0x000000081f177824ULL, 0x040fe200078e0214ULL, 0x00000005001a7812ULL, 0x040fe200078e3cffULL,
0x000000081f197824ULL, 0x040fe200078e0216ULL, 0x0000000100027812ULL, 0x040fe200078e3cffULL,
0x000000081f1b7824ULL, 0x040fe200078e0218ULL, 0x0000000600007812ULL, 0x000fe200078e3cffULL,
0x000000081f1d7824ULL, 0x040fe200078e021aULL, 0x000000021f157211ULL, 0x040fe200078e18ffULL,
0x000000041c147824ULL, 0x000fe200078e00ffULL, 0x000000001f1f7211ULL, 0x000fe200078e18ffULL,
0x000008007a007824ULL, 0x000fe200078e00ffULL, 0x000000072d167812ULL, 0x040fe200078ec0ffULL,
0x000000082d187824ULL, 0x000fe200078e00ffULL, 0x0000000c14147812ULL, 0x000fc400078ec0ffULL,
0x0001200000027810ULL, 0x000fe40007ffe0ffULL, 0xfffffff818237812ULL, 0x000fe400078ee22dULL,
0x0000000116187812ULL, 0x040fe200078e3cffULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x00000002161a7812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x00000003161c7812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x00000004161e7812ULL, 0x040fe200078e3cffULL, 0x000000101b1b7824ULL, 0x000fe200078e0202ULL,
0x0000000516207812ULL, 0x040fe200078e3cffULL, 0x000000082d297824ULL, 0x000fe200078e021cULL,
0x0000000616227812ULL, 0x000fe200078e3cffULL, 0x0000000113167824ULL, 0x000fe200078e0214ULL,
0x0000000215157211ULL, 0x000fe200078e20ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0202ULL,
0x000000182d257211ULL, 0x040fe200078e18ffULL, 0x000000082d277824ULL, 0x000fe200078e021aULL,
0x0000000316007388ULL, 0x0003e20000000800ULL, 0x0000001514157210ULL, 0x040fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0202ULL, 0x000000021f1f7211ULL, 0x000fe200078e20ffULL,
0x0000000114197824ULL, 0x040fe200078e0219ULL, 0x000000202d2b7211ULL, 0x040fe200078e18ffULL,
0x000000082d137824ULL, 0x000fe200078e021eULL, 0x0000000229297211ULL, 0x000fe200078e20ffULL,
0x0000001023237824ULL, 0x100fe200078e0202ULL, 0x0000001f141a7210ULL, 0x040fe20007ffe0ffULL,
0x0000000114167824ULL, 0x042fe200078e0217ULL, 0x0000000415007388ULL, 0x0003e20000000800ULL,
0x0000000114187824ULL, 0x040fe200078e021bULL, 0x0000003e3f0e723eULL, 0x000fe200000000ffULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x0000000516007388ULL, 0x0003e20000000800ULL,
0x0000001025257824ULL, 0x000fe200078e0202ULL, 0x0000003a3b0f723eULL, 0x000fe200000000ffULL,
0x00000001141d7824ULL, 0x040fe200078e021dULL, 0x0000000619007388ULL, 0x0003e20000000800ULL,
0x000000082d2d7824ULL, 0x000fe200078e0222ULL, 0x0000030003007a0cULL, 0x000fe20003f05270ULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x0000000718007388ULL, 0x0003e20000000800ULL,
0x0000000114217824ULL, 0x040fe200078e0221ULL, 0x000000424310723eULL, 0x000fe200000000ffULL,
0x00000001141c7824ULL, 0x000fe200078e0223ULL, 0x000000081d007388ULL, 0x0003e20000000800ULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x000000464711723eULL, 0x000fe200000000ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0202ULL, 0x000000091a007388ULL, 0x0003e20000000800ULL,
0x000000102f2f7824ULL, 0x000fc400078e0202ULL, 0x0000000114257824ULL, 0x040fe200078e0225ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x0000002b142b7210ULL, 0x040fe20007ffe0ffULL, 0x00000001141e7824ULL, 0x040fe200078e0227ULL,
0x0000000b1c007388ULL, 0x0003e20000000800ULL, 0x0000000114297824ULL, 0x040fe400078e0229ULL,
0x0000000114207824ULL, 0x040fe200078e0213ULL, 0x0000000c25007388ULL, 0x0003e20000000800ULL,
0x00000001142f7824ULL, 0x000fc400078e022fULL, 0x0000000114147824ULL, 0x000fe200078e022dULL,
0x0000000d1e007388ULL, 0x0003e80000000800ULL, 0x0000000e29007388ULL, 0x0003e80000000800ULL,
0x0000000f20007388ULL, 0x0003e80000000800ULL, 0x000000102b007388ULL, 0x0003e80000000800ULL,
0x0000001114007388ULL, 0x0003e80000000800ULL, 0x000000122f007388ULL, 0x0003e20000000800ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x00002bc000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x00005800ff047624ULL, 0x002fe200078e00ffULL,
0x000000ff7a00720cULL, 0x000fe20003f25270ULL, 0x00001000ff077424ULL, 0x000fe200078e00ffULL,
0x00000000000e7919ULL, 0x000e680000002700ULL, 0x0000000000057919ULL, 0x000e620000002600ULL,
0x0000001003097824ULL, 0x044fe200078e0200ULL, 0x00000020030d7810ULL, 0x000fc40007ffe0ffULL,
0x000000ff0300720cULL, 0x000fe40003f05270ULL, 0x0120000009107984ULL, 0x0004e40000000c00ULL,
0x000000ff7a00720cULL, 0x000fe20000705670ULL, 0x000058000e0e7a24ULL, 0x002fe200078e0205ULL,
0x0122000009147984ULL, 0x0004620000000c00ULL, 0x0000030004057a24ULL, 0x000fe400078e02ffULL,
0x000003000e047a24ULL, 0x000fe400078e02ffULL, 0x0000640005057a24ULL, 0x000fc600078e02ffULL,
0x0000003104087210ULL, 0x000fe40007ffe0ffULL, 0x00000fff050f7811ULL, 0x040fe400078e40ffULL,
0x01ffffff05057812ULL, 0x000fe400078ec0ffULL, 0x000000080f067211ULL, 0x000fca00078fa0ffULL,
0x00006a0006067625ULL, 0x000fcc00078e0007ULL, 0x000004007a067825ULL, 0x000fcc00078e0006ULL,
0x000000100d0c7825ULL, 0x000fc800078e0006ULL, 0x00000010030a7825ULL, 0x000fe200078e0006ULL,
0x000000f000001947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x00cea20000000000ULL,
0x00000080ff187424ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x000fe400078e0205ULL,
0x0000001006197824ULL, 0x004fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011606ULL,
0x00006a0008067625ULL, 0x000fc600078e0018ULL, 0x0000007019197812ULL, 0x000fe200078ec0ffULL,
0x00006a0009087625ULL, 0x000fe200078e0018ULL, 0x0000000c1a1a7812ULL, 0x000fc800078ec0ffULL,
0x000000061a067210ULL, 0x140fe40007b5e019ULL, 0x000000081a087210ULL, 0x000fe40007d9e019ULL,
0x00000007ff077210ULL, 0x000fe400017e64ffULL, 0x00000009ff097210ULL, 0x000fc600027ea4ffULL,
0x0000003406007986ULL, 0x0005e8000c101906ULL, 0x0000003308007986ULL, 0x0005e4000c101906ULL,
0x000000100a007986ULL, 0x00c5e2000c101d06ULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x000000140c007986ULL, 0x0025e8000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x000000f000000947ULL, 0x000fea0003800000ULL, 0x0000000100097802ULL, 0x000fe20000000f00ULL,
0x00000004ff077424ULL, 0x000fc600078e00ffULL, 0x0000030009097a10ULL, 0x000fe20007ffe1ffULL,
0x000068000e067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000009060679a8ULL, 0x000ee400099ee1c6ULL,
0x000000090600720cULL, 0x008fe20003f05270ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000001ff087807ULL, 0x000fca0000000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000010000ULL,
0x00000000ff067984ULL, 0x000ee40000000000ULL, 0x000000ff0600720cULL, 0x008fda0003f05270ULL,
0x000027b000008947ULL, 0x000fea0003800000ULL, 0x00000d6000001947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x0000038000008947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe20000011603ULL,
0x00000080ff157424ULL, 0x004fe200078e00ffULL, 0x0000000104087810ULL, 0x002fe40007ffe0ffULL,
0x0000007006197812ULL, 0x000fe400078ec0ffULL, 0x0000000c070e7812ULL, 0x000fe200078ec0ffULL,
0x00006a0004067625ULL, 0x000fc800078e0015ULL, 0x00006a0008087625ULL, 0x000fe200078e0015ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x000000080e087210ULL, 0x000fe40007b5e019ULL,
0x00000007ff077210ULL, 0x000fe400007e24ffULL, 0x00000009ff097210ULL, 0x000fc600017e64ffULL,
0x00000006060a7981ULL, 0x000368000c1e1900ULL, 0x00000006080b7981ULL, 0x000362000c1e1900ULL,
0x00000300ff0c7624ULL, 0x000fca00078e00ffULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x0000027000008947ULL, 0x000fea0003800000ULL, 0x0000000204067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0015ULL, 0x000000060e067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x00000006060d7981ULL, 0x000362000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000020000008947ULL, 0x000fea0003800000ULL,
0x0000000304067810ULL, 0x002fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0015ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606117981ULL, 0x000362000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000019000008947ULL, 0x000fea0003800000ULL, 0x0000000404067810ULL, 0x002fca0007ffe0ffULL,
0x00006a0006067625ULL, 0x000fca00078e0015ULL, 0x000000060e067210ULL, 0x000fc8000791e019ULL,
0x00000007ff077210ULL, 0x000fca00007e24ffULL, 0x0000000606137981ULL, 0x000362000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x0000000504067810ULL, 0x002fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0015ULL,
0x000000060e067210ULL, 0x000fc8000791e019ULL, 0x00000007ff077210ULL, 0x000fca00007e24ffULL,
0x0000000606177981ULL, 0x000362000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x000000b000008947ULL, 0x000fea0003800000ULL, 0x000000080c00780cULL, 0x002fe40003f06070ULL,
0x0000000604067810ULL, 0x000fca0007ffe0ffULL, 0x00006a0006067625ULL, 0x000fca00078e0015ULL,
0x000000060e067210ULL, 0x000fe40007a3e019ULL, 0x0000000704080810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff077210ULL, 0x000fc60000fe44ffULL, 0x00006a0008080625ULL, 0x000fca00078e0015ULL,
0x000000080e080210ULL, 0x000fe40007c7e019ULL, 0x0000000606197981ULL, 0x000364000c1e1900ULL,
0x00000009ff090210ULL, 0x000fca0001fe84ffULL, 0x00000006081b0981ULL, 0x000368000c1e1900ULL,
0x0000030000047ab9ULL, 0x002fe40000000800ULL, 0x0000000704047890ULL, 0x000fc8000fffe03fULL,
0x000000033f047899ULL, 0x000fcc0008011604ULL, 0x00000004ff007c0cULL, 0x000fda000bf05270ULL,
0x0000090000008947ULL, 0x000fea0003800000ULL, 0x000000ff00107202ULL, 0x004fe20000000f00ULL,
0x000000ffff087224ULL, 0x000fe400078e0004ULL, 0x000000ffff097224ULL, 0x020fe400078e000aULL,
0x000000ffff127224ULL, 0x000fc600078e00ffULL, 0x0000030010007a0cULL, 0x000fe40003f26070ULL,
0x0000000112127810ULL, 0x000fc80007ffe0ffULL, 0x0000000412007c0cULL, 0x000fce000bf06070ULL,
0x0000085000001947ULL, 0x022fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000090a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000808067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x0000000403097819ULL, 0x000fe400000006ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ec0ffULL,
0x000000060c067210ULL, 0x000fc80007b3e009ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606097981ULL, 0x000368000c1e1900ULL, 0x0000074000002947ULL, 0x000fea0003800000ULL,
0x0000000910067810ULL, 0x042fe40007ffe0ffULL, 0x0000000210077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000b0a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000908067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fe20000011603ULL, 0x00000010030b7824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fc800078ec0ffULL, 0x000000060c067210ULL, 0x000fc80007b3e00bULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x00000006060b7981ULL, 0x000368000c1e1900ULL,
0x0000063000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d0a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000a08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c0d7812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e00dULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x00000006060d7981ULL, 0x000368000c1e1900ULL, 0x0000052000002947ULL, 0x000fea0003800000ULL,
0x0000000b10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000410077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000110a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000b08067810ULL, 0x000fe20007ffe0ffULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x0000008000077802ULL, 0x000fe40000000f00ULL, 0x00000001ff0e7819ULL, 0x000fe40000011603ULL,
0x000000700c117812ULL, 0x000fe200078ec0ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e011ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606117981ULL, 0x000368000c1e1900ULL,
0x0000041000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000130a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000c08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c137812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e013ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606137981ULL, 0x000368000c1e1900ULL, 0x0000030000002947ULL, 0x000fea0003800000ULL,
0x0000000d10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000610077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x000000170a0a7209ULL, 0x000fd20007810000ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000d08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000004030c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x000000700c157812ULL, 0x000fe400078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007b3e015ULL,
0x00000007ff077210ULL, 0x000fca0000fe64ffULL, 0x0000000606177981ULL, 0x000368000c1e1900ULL,
0x000001f000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x000000190a0a7209ULL, 0x000fd20007810000ULL,
0x000000a000001947ULL, 0x000fea0003800000ULL, 0x0000000e08067810ULL, 0x000fe20007ffe0ffULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x000fe20000011603ULL,
0x00000010030c7824ULL, 0x000fe400078e00ffULL, 0x00006a0006067625ULL, 0x000fe200078e0007ULL,
0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL, 0x000000700c157812ULL, 0x000fc800078ec0ffULL,
0x000000060e067210ULL, 0x000fc80007b3e015ULL, 0x00000007ff077210ULL, 0x000fca0000fe64ffULL,
0x0000000606197981ULL, 0x000368000c1e1900ULL, 0x000000e000002947ULL, 0x000fea0003800000ULL,
0x0000000f10067810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0a0a7209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x000000a000001947ULL, 0x000fea0003800000ULL,
0x0000000f08067810ULL, 0x000fe20007ffe0ffULL, 0x00000080ff077424ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011603ULL, 0x00000010030c7824ULL, 0x000fe400078e00ffULL,
0x00006a0006067625ULL, 0x000fe200078e0007ULL, 0x0000000c0e0e7812ULL, 0x000fe400078ec0ffULL,
0x000000700c157812ULL, 0x000fc800078ec0ffULL, 0x000000060e067210ULL, 0x000fc80007a3e015ULL,
0x00000007ff077210ULL, 0x000fca0000fe44ffULL, 0x00000006061b7981ULL, 0x000368000c1e1900ULL,
0x0000000810107810ULL, 0x000fe40007ffe0ffULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0xfffff74000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ee40000000000ULL,
0x0000000403067819ULL, 0x00afe400000006ffULL, 0x00000001ff077819ULL, 0x000fe40000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000a07007388ULL, 0x0203e40000000800ULL,
0x000000070300780cULL, 0x040fe20003f04070ULL, 0x0000000000007b1dULL, 0x000fe20000010000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x002fe20000011603ULL,
0x00001000ff0b7424ULL, 0x004fe200078e00ffULL, 0x000000040f147211ULL, 0x000fe200078fa0ffULL,
0x000010007a1e7824ULL, 0x000fe200078e00ffULL, 0x0000007006087812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000000c07097812ULL, 0x000fe200078ec0ffULL,
0x00006a0014067625ULL, 0x000fe200078e000bULL, 0x0000000504157210ULL, 0x000fe20007ffe0ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000080000f8802ULL, 0x000fe20000000f00ULL,
0x00000080ff0c8424ULL, 0x000fe200078e00ffULL, 0x00000020030b7810ULL, 0x000fe20007ffe0ffULL,
0x000004007a067825ULL, 0x040fe200078e0006ULL, 0x00000300ff007a0cULL, 0x000fe20003f25270ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00006a00150c8625ULL, 0x000fe200078e000cULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000107a138824ULL, 0x000fe200078e0203ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00006a00040e8625ULL, 0x000fe200078e000fULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x0000458013138811ULL, 0x000fe200078e20ffULL, 0x00000001081c7824ULL, 0x000fe400078e0209ULL,
0x000000107a178824ULL, 0x000fe400078e0203ULL, 0x0000001003117824ULL, 0x040fe400078e021eULL,
0x0000001003087825ULL, 0x100fe200078e0006ULL, 0x0000418017178811ULL, 0x000fe200078e20ffULL,
0x000000001c1c7984ULL, 0x000e640000000800ULL, 0x000000100b0a7825ULL, 0x000fc400078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000008117faeULL, 0x0005e2000b901c46ULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x00000010030c8825ULL, 0x040fe400078e000cULL,
0x003800000a117faeULL, 0x0007e4000b901c46ULL, 0x00000010030e8825ULL, 0x000fe400078e000eULL,
0x000000000c138faeULL, 0x0009e4000b901c46ULL, 0x000000ffff057224ULL, 0x000fc400078e00ffULL,
0x000000000e178faeULL, 0x000be2000b901c46ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x0000000000087805ULL, 0x004fe4000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000a7805ULL, 0x008fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x010fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x020fe2000001ff00ULL, 0x00000d1000009947ULL, 0x000fea0003800000ULL,
0x0000000104327810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000115307810ULL, 0x000fc40007ffe0ffULL, 0x0000000114317810ULL, 0x000fe40007ffe0ffULL,
0x0000000100047802ULL, 0x000fc80000000f00ULL, 0x0000030004007a0cULL, 0x000fda0003f06070ULL,
0x000001f000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x0000080004147824ULL, 0x040fe200078e00ffULL, 0x0000000104197812ULL, 0x000fe200078ec0ffULL,
0x00001000ff167424ULL, 0x000fe200078e00ffULL, 0x0000002003377810ULL, 0x000fe40007ffe0ffULL,
0x0000080014177812ULL, 0x000fe200078ec0ffULL, 0x00006a0031147625ULL, 0x000fc800078e0016ULL,
0x000000011e167824ULL, 0x000fe400078e0217ULL, 0x000000027a188824ULL, 0x040fe200078e0219ULL,
0x000000197a1a8211ULL, 0x000fe200078e08ffULL, 0x00000080ff198424ULL, 0x000fe400078e00ffULL,
0x00000080ff1b8424ULL, 0x000fe200078e00ffULL, 0x000000031a348211ULL, 0x000fe200078e18ffULL,
0x000004007a147825ULL, 0x000fc800078e0014ULL, 0x0000000818358824ULL, 0x000fe400078e0203ULL,
0x00006a0030188625ULL, 0x000fc600078e0019ULL, 0x0000458035358811ULL, 0x000fe200078e20ffULL,
0x00006a00321a8625ULL, 0x000fc800078e001bULL, 0x0000001003337824ULL, 0x000fe400078e0216ULL,
0x0000001037167825ULL, 0x000fe200078e0014ULL, 0x0000418034378811ULL, 0x000fc600078e20ffULL,
0x0000001003147825ULL, 0x000fc800078e0014ULL, 0x0000001003188825ULL, 0x040fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000014337faeULL, 0x0005e6000b901c46ULL,
0x00000010031a8825ULL, 0x000fe200078e001aULL, 0x0038000016337faeULL, 0x0005e8000b901c46ULL,
0x0000000018358faeULL, 0x0005e8000b901c46ULL, 0x000000001a378faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff04147810ULL, 0x004fe20007ffe0ffULL,
0x0000001003167824ULL, 0x000fe200078e00ffULL, 0x00000001ff177819ULL, 0x000fc40000011603ULL,
0x00000002ff4b7819ULL, 0x000fe20000011603ULL, 0x0000008014157824ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fe200078ec0ffULL, 0x0000080014147824ULL, 0x000fe200078e00ffULL,
0x0000000c17177812ULL, 0x000fe200078ec0ffULL, 0x000000084b187824ULL, 0x000fe200078e00ffULL,
0x0000008015157812ULL, 0x000fe400078ec0ffULL, 0x000000034b1a7819ULL, 0x040fe400000006ffULL,
0x000000074b397812ULL, 0x040fe200078ec0ffULL, 0x000001007a157824ULL, 0x000fe200078e0215ULL,
0x000000084b4d7810ULL, 0x000fc40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f06070ULL,
0x0000001517177210ULL, 0x000fe20007ffe016ULL, 0x000000084b167824ULL, 0x000fe200078e00ffULL,
0x0000004bff157212ULL, 0x000fe200078e33ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000173b7984ULL, 0x000ea20000000800ULL, 0xfffffff81a417812ULL, 0x000fe200078ee215ULL,
0x000000084d3d7824ULL, 0x040fe200078e00ffULL, 0xfffffff818157812ULL, 0x100fe200078ee239ULL,
0x0045800017497984ULL, 0x0007220000000800ULL, 0x0000000116197812ULL, 0x140fe200078ef639ULL,
0x000000084d187824ULL, 0x000fe200078e00ffULL, 0x00000002161b7812ULL, 0x140fe400078ef639ULL,
0x0000000316337812ULL, 0x140fe400078ef639ULL, 0x0000000416357812ULL, 0x000fc400078ef639ULL,
0x0000080014177812ULL, 0x008fe400078ec0ffULL, 0x0000000516377812ULL, 0x000fe400078ef639ULL,
0x000001801e147810ULL, 0x000fe40007ffe017ULL, 0x0000000616397812ULL, 0x000fe400078ef639ULL,
0x0000000203167819ULL, 0x000fe200000006ffULL, 0x0000001015157824ULL, 0x100fe200078e0214ULL,
0x0000004dff477212ULL, 0x000fe200078e33ffULL, 0x0000001019197824ULL, 0x100fe200078e0214ULL,
0x0000000c16387812ULL, 0x000fe200078ec0ffULL, 0x0000001041167824ULL, 0x100fe200078e0214ULL,
0xfffffff818477812ULL, 0x000fe200078ee247ULL, 0x0000001033337824ULL, 0x000fe200078e0214ULL,
0x0000001538157210ULL, 0x040fe20007ffe0ffULL, 0x0000000138167824ULL, 0x040fe200078e0216ULL,
0x0000001938197210ULL, 0x040fe20007ffe0ffULL, 0x0000001037377824ULL, 0x100fe200078e0214ULL,
0x000000074d187812ULL, 0x000fe200078ec0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0214ULL,
0x0000000015157984ULL, 0x000ee20000000800ULL, 0x0000003338337210ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e0214ULL, 0xfffffff83d177812ULL, 0x100fe200078ee218ULL,
0x0000000019197984ULL, 0x000fe20000000800ULL, 0x0000003b1c3b7221ULL, 0x006fe20000010100ULL,
0x0000003738377210ULL, 0x040fe20007ffe0ffULL, 0x00000001381b7824ULL, 0x040fe200078e021bULL,
0x0000000016167984ULL, 0x000e620000000800ULL, 0x3fb8aa3b3b1a7820ULL, 0x000fe20000410000ULL,
0x0000001417177211ULL, 0x000fe200078e20ffULL, 0x000000084d3b7824ULL, 0x000fe200078e00ffULL,
0x0000000033337984ULL, 0x000fe20000000800ULL, 0x0000000138357824ULL, 0x000fe200078e0235ULL,
0x0000000104047810ULL, 0x000fe20007ffe0ffULL, 0x0000001a001a7308ULL, 0x000f220000000800ULL,
0x000000013b3d7812ULL, 0x140fe200078ef618ULL, 0x000000001b1b7984ULL, 0x000fe20000000800ULL,
0x000000023b3f7812ULL, 0x140fe200078ef618ULL, 0x0000000138177824ULL, 0x040fe200078e0217ULL,
0x000000033b417812ULL, 0x000fe200078ef618ULL, 0x0000000037377984ULL, 0x000fe20000000800ULL,
0x0000001039397824ULL, 0x000fe200078e0214ULL, 0x000000043b437812ULL, 0x000fe200078ef618ULL,
0x000000103d3d7824ULL, 0x100fe200078e0214ULL, 0x0000000035357984ULL, 0x000fe20000000800ULL,
0x000000103f3f7824ULL, 0x000fe200078e0214ULL, 0x000000053b457812ULL, 0x140fe200078ef618ULL,
0x0000000138397824ULL, 0x040fe200078e0239ULL, 0x0000000017177984ULL, 0x000fe20000000800ULL,
0x00000001383d7824ULL, 0x000fe200078e023dULL, 0x000000063b3b7812ULL, 0x000fe200078ef618ULL,
0x000000491a1a7220ULL, 0x010fe20000410000ULL, 0x0000000130307810ULL, 0x000fe20007ffe0ffULL,
0x00000001383f7824ULL, 0x040fe200078e023fULL, 0x0000000039397984ULL, 0x000fe20000000800ULL,
0x0000001041417824ULL, 0x100fe200078e0214ULL, 0x0000000131317810ULL, 0x000fe20007ffe0ffULL,
0x0000001043437824ULL, 0x100fe200078e0214ULL, 0x00001f4b1a347589ULL, 0x000ea200000e0000ULL,
0x0000001045457824ULL, 0x100fe200078e0214ULL, 0x0000004138417210ULL, 0x040fe20007ffe0ffULL,
0x0000000138437824ULL, 0x040fe200078e0243ULL, 0x000000003d3d7984ULL, 0x000fe20000000800ULL,
0x0000000138457824ULL, 0x040fe200078e0245ULL, 0x20000015ff497230ULL, 0x108fe20000004100ULL,
0x000000103b3b7824ULL, 0x100fe200078e0214ULL, 0x000000003f3f7984ULL, 0x000ee20000000800ULL,
0x0000001047477824ULL, 0x000fe200078e0214ULL, 0x30000015ff147230ULL, 0x000fe20000004100ULL,
0x00000001383b7824ULL, 0x040fe200078e023bULL, 0x0000000041417984ULL, 0x000fe20000000800ULL,
0x0000000138477824ULL, 0x000fe200078e0247ULL, 0x20000016ff187230ULL, 0x002fe20000004100ULL,
0x0000002f1a2f7221ULL, 0x000fe20000010000ULL, 0x0000000043437984ULL, 0x000fe20000000800ULL,
0x0000000132327810ULL, 0x000fc60007ffe0ffULL, 0x0000000045457984ULL, 0x000fe80000000800ULL,
0x00001f4d1a1a7589ULL, 0x000e6200000e0000ULL, 0x00000034142d7223ULL, 0x084fe2000001002dULL,
0x20000019ff147230ULL, 0x000fe20000004100ULL, 0x00000034181f7223ULL, 0x080fe2000001001fULL,
0x000000003b3b7984ULL, 0x000ea20000000800ULL, 0x30000016ff187230ULL, 0x000fe20000004100ULL,
0x00000034492e7223ULL, 0x080fe2000001002eULL, 0x2000001bff167230ULL, 0x000fe20000004100ULL,
0x0000000047477984ULL, 0x000f220000000800ULL, 0x00000034142b7223ULL, 0x080fe2000001002bULL,
0x20000033ff147230ULL, 0x000fe20000004100ULL, 0x00000034181d7223ULL, 0x080fe2000001001dULL,
0x20000017ff157230ULL, 0x000fe20000004100ULL, 0x0000003416297223ULL, 0x080fe20000010029ULL,
0x20000035ff167230ULL, 0x000fe20000004100ULL, 0x0000003414277223ULL, 0x000fe20000010027ULL,
0x20000037ff147230ULL, 0x000fc40000004100ULL, 0x30000019ff197230ULL, 0x000fe20000004100ULL,
0x0000003416257223ULL, 0x080fe20000010025ULL, 0x20000039ff167230ULL, 0x000fe20000004100ULL,
0x0000003414237223ULL, 0x080fe20000010023ULL, 0x30000017ff147230ULL, 0x000fe20000004100ULL,
0x00000034192a7223ULL, 0x000fe2000001002aULL, 0x2000003fff177230ULL, 0x008fe20000004100ULL,
0x0000001a152c7223ULL, 0x082fe2000001002cULL, 0x2000003dff157230ULL, 0x000fe20000004100ULL,
0x0000001a14137223ULL, 0x000fe20000010013ULL, 0x3000003fff147230ULL, 0x000fe20000004100ULL,
0x0000003416217223ULL, 0x000fe20000010021ULL, 0x3000003dff167230ULL, 0x000fe20000004100ULL,
0x0000001a15127223ULL, 0x080fe20000010012ULL, 0x20000041ff157230ULL, 0x100fe20000004100ULL,
0x0000001a140f7223ULL, 0x080fe2000001000fULL, 0x30000041ff147230ULL, 0x000fe20000004100ULL,
0x0000001a16117223ULL, 0x080fe20000010011ULL, 0x30000043ff167230ULL, 0x100fe20000004100ULL,
0x0000001a17107223ULL, 0x080fe20000010010ULL, 0x20000043ff177230ULL, 0x000fe20000004100ULL,
0x0000001a150e7223ULL, 0x080fe2000001000eULL, 0x20000045ff157230ULL, 0x100fe20000004100ULL,
0x0000001a140d7223ULL, 0x080fe2000001000dULL, 0x30000045ff147230ULL, 0x000fe20000004100ULL,
0x0000001a170c7223ULL, 0x080fe2000001000cULL, 0x3000001bff1b7230ULL, 0x000fe20000004100ULL,
0x0000001a160b7223ULL, 0x080fe2000001000bULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000001a150a7223ULL, 0x080fe2000001000aULL, 0x30000035ff357230ULL, 0x000fe20000004100ULL,
0x0000001a14097223ULL, 0x000fe20000010009ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x000000341b287223ULL, 0x080fe20000010028ULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x0000003433267223ULL, 0x080fe20000010026ULL, 0x2000003bff157230ULL, 0x104fe20000004100ULL,
0x0000003435247223ULL, 0x080fe20000010024ULL, 0x3000003bff167230ULL, 0x000fe20000004100ULL,
0x0000003437227223ULL, 0x080fe20000010022ULL, 0x20000047ff177230ULL, 0x110fe20000004100ULL,
0x0000003439207223ULL, 0x000fe20000010020ULL, 0x30000047ff147230ULL, 0x000fe20000004100ULL,
0x0000001a15087223ULL, 0x000fc40000010008ULL, 0x0000001a16077223ULL, 0x080fe40000010007ULL,
0x0000001a17067223ULL, 0x080fe40000010006ULL, 0x0000001a14057223ULL, 0x000fe20000010005ULL,
0xfffff34000008947ULL, 0x000fea000383ffffULL, 0x018000002f037810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fe60000010000ULL, 0x7f80000003037812ULL, 0x000fc600078ec0ffULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000c99000147802ULL, 0x000fe40000000f00ULL,
0x0000915000007944ULL, 0x002fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002f00047308ULL, 0x000ea40000001000ULL, 0xbf80000004037423ULL, 0x004fc8000000002fULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fe40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000157919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fe20000010000ULL, 0x0000000815187811ULL, 0x050fe400078ff0ffULL,
0x00000002ff167819ULL, 0x000fe40000011615ULL, 0x00000018ff177212ULL, 0x000fe200078e33ffULL,
0x00001f1803147589ULL, 0x00cea200000e0000ULL, 0x00000003161a7819ULL, 0x000fe200000006ffULL,
0x00000008181c7824ULL, 0x002fe200078e00ffULL, 0x0000000215157819ULL, 0x000fe200000006ffULL,
0x00001f1603047589ULL, 0x0002e600000e0000ULL, 0xfffffff81c357812ULL, 0x000fc800078ee217ULL,
0x0000000235357211ULL, 0x000fe400078e20ffULL, 0x00000016ff037212ULL, 0x002fc800078e33ffULL,
0xfffffff81a2f7812ULL, 0x000fe200078ee203ULL, 0x0000000816037824ULL, 0x000fc800078e00ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0202ULL, 0xfffffff803037812ULL, 0x000fe200078ee216ULL,
0x0000000614067220ULL, 0x044fe40000410000ULL, 0x0000000514057220ULL, 0x000fe40000410000ULL,
0x0000002e042e7220ULL, 0x048fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x000000060505723eULL, 0x000fe200000000ffULL, 0x0000002b042b7220ULL, 0x000fe20000410000ULL,
0x0000000716067812ULL, 0x000fe200078ec0ffULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002e2d2d723eULL, 0x000fe200000000ffULL, 0x0000002904297220ULL, 0x000fe20000410000ULL,
0x0000000106177812ULL, 0x000fe200078e3cffULL, 0x0000002804287220ULL, 0x000fe20000410000ULL,
0x0000000206197812ULL, 0x000fe200078e3cffULL, 0x0000002704277220ULL, 0x000fe20000410000ULL,
0x00000003061b7812ULL, 0x000fe200078e3cffULL, 0x0000002604267220ULL, 0x000fe20000410000ULL,
0x0000001916197211ULL, 0x000fe200078e18ffULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000002404247220ULL, 0x000fe20000410000ULL,
0x000000272626723eULL, 0x000fe200000000ffULL, 0x0000002304237220ULL, 0x000fe20000410000ULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x0000002204227220ULL, 0x000fe20000410000ULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000002104217220ULL, 0x000fc40000410000ULL,
0x0000002004207220ULL, 0x000fe20000410000ULL, 0x000000232222723eULL, 0x000fe200000000ffULL,
0x0000001f041f7220ULL, 0x040fe40000410000ULL, 0x0000001d04047220ULL, 0x000fe20000410000ULL,
0x00000004061d7812ULL, 0x000fe200078e3cffULL, 0x0000000814087220ULL, 0x000fe20000410000ULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x0000000714077220ULL, 0x000fe20000410000ULL,
0x0000001f0404723eULL, 0x000fe200000000ffULL, 0x0000000818237824ULL, 0x000fe200078e00ffULL,
0x00000005061f7812ULL, 0x000fe200078e3cffULL, 0x0000000816177824ULL, 0x040fe200078e0217ULL,
0x000000080707723eULL, 0x000fe200000000ffULL, 0x00000008161b7824ULL, 0x000fe200078e021bULL,
0x0000000718087812ULL, 0x000fe200078ec0ffULL, 0x00000008161d7824ULL, 0x000fe200078e021dULL,
0x0000000606217812ULL, 0x000fe200078e3cffULL, 0x0000001003037824ULL, 0x100fe200078e0202ULL,
0x0000000c15067812ULL, 0x000fe200078ec0ffULL, 0x00000008161f7824ULL, 0x000fe200078e021fULL,
0x0000000108257812ULL, 0x040fe200078e3cffULL, 0x0000001017177824ULL, 0x100fe200078e0202ULL,
0x0000000208277812ULL, 0x000fe200078e3cffULL, 0x0000000816217824ULL, 0x000fe200078e0221ULL,
0x0000000308297812ULL, 0x040fe200078e3cffULL, 0x0000001019197824ULL, 0x000fe200078e0202ULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x00000004082b7812ULL, 0x000fe200078e3cffULL, 0x0000000818257824ULL, 0x000fe200078e0225ULL,
0x0000000508317812ULL, 0x040fe200078e3cffULL, 0x000000101f1f7824ULL, 0x000fe200078e0202ULL,
0x0000000608337812ULL, 0x000fe200078e3cffULL, 0x0000000103087824ULL, 0x000fe200078e0206ULL,
0x000000021d1d7211ULL, 0x000fe200078e20ffULL, 0x0000000106177824ULL, 0x000fe200078e0217ULL,
0x0000003118317211ULL, 0x040fe200078e18ffULL, 0x0000000818277824ULL, 0x000fe200078e0227ULL,
0x0000001d061d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000818297824ULL, 0x000fe200078e0229ULL,
0x0000002d08007388ULL, 0x0003e20000000800ULL, 0x0000001021217824ULL, 0x000fc400078e0202ULL,
0x0000000106197824ULL, 0x000fe200078e0219ULL, 0x0000002a17007388ULL, 0x0005e20000000800ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000000229297211ULL, 0x000fe200078e20ffULL,
0x0000001314137220ULL, 0x040fe20000410000ULL, 0x0000002819007388ULL, 0x0005e20000000800ULL,
0x0000000a140a7220ULL, 0x040fe40000410000ULL, 0x0000000914097220ULL, 0x000fe20000410000ULL,
0x0000002c1313723eULL, 0x000fe200000000ffULL, 0x00000008182b7824ULL, 0x000fc400078e022bULL,
0x0000000818337824ULL, 0x000fe200078e0233ULL, 0x0000000a0909723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x000fe400078e0202ULL, 0x00000001061b7824ULL, 0x000fe400078e021bULL,
0x0000001214127220ULL, 0x040fe40000410000ULL, 0x0000001114117220ULL, 0x040fe20000410000ULL,
0x000000261b007388ULL, 0x0005e20000000800ULL, 0x0000001014107220ULL, 0x000fc40000410000ULL,
0x0000000f140f7220ULL, 0x040fe20000410000ULL, 0x000000121111723eULL, 0x000fe200000000ffULL,
0x0000000c140c7220ULL, 0x040fe20000410000ULL, 0x000000241d007388ULL, 0x0005e20000000800ULL,
0x0000000b140b7220ULL, 0x000fe20000410000ULL, 0x000000100f0f723eULL, 0x000fe200000000ffULL,
0x0000001025257824ULL, 0x100fe400078e0202ULL, 0x00000001061f7824ULL, 0x000fe200078e021fULL,
0x0000000c0b0b723eULL, 0x000fe200000000ffULL, 0x0000000e140e7220ULL, 0x000fe20000410000ULL,
0x00000029060c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000d140d7220ULL, 0x000fe20000410000ULL,
0x000000221f007388ULL, 0x0005e20000000800ULL, 0x0000001027277824ULL, 0x000fc400078e0202ULL,
0x0000000106217824ULL, 0x040fe200078e0221ULL, 0x0000000e0d0d723eULL, 0x000fe200000000ffULL,
0x000000102b2b7824ULL, 0x100fe400078e0202ULL, 0x0000001031317824ULL, 0x100fe200078e0202ULL,
0x0000002021007388ULL, 0x0005e20000000800ULL, 0x0000001033337824ULL, 0x000fe200078e0202ULL,
0x0000002306027210ULL, 0x040fe20007ffe0ffULL, 0x00000001062f7824ULL, 0x040fe400078e022fULL,
0x00000001060a7824ULL, 0x000fc400078e0225ULL, 0x0000000106087824ULL, 0x042fe200078e0227ULL,
0x000000042f007388ULL, 0x0005e20000000800ULL, 0x00000001060e7824ULL, 0x040fe400078e022bULL,
0x0000000106127824ULL, 0x040fe200078e0235ULL, 0x0000001302007388ULL, 0x0005e20000000800ULL,
0x0000000106107824ULL, 0x040fe400078e0231ULL, 0x0000000106067824ULL, 0x000fe200078e0233ULL,
0x000000110a007388ULL, 0x0005e80000000800ULL, 0x0000000f08007388ULL, 0x0005e80000000800ULL,
0x0000000d0c007388ULL, 0x0005e80000000800ULL, 0x0000000b0e007388ULL, 0x0005e80000000800ULL,
0x0000000910007388ULL, 0x0005e80000000800ULL, 0x0000000706007388ULL, 0x0005e80000000800ULL,
0x0000000512007388ULL, 0x0005e20000000800ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000057919ULL, 0x006e620000000000ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x0000580000047ab9ULL, 0x000fc40000000800ULL, 0x0000000000047919ULL, 0x000ee20000002600ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x00000020050d7810ULL, 0x002fc60007ffe0ffULL,
0x00000005040472a4ULL, 0x004fe2000f8e023fULL, 0x00000003ff067819ULL, 0x000fe40000011605ULL,
0x00000003ff027819ULL, 0x000fe2000001160dULL, 0x00000008040f7824ULL, 0x008fe200078e00ffULL,
0x0000000706087812ULL, 0x000fe400078e4805ULL, 0x0000000702037812ULL, 0x000fe400078e480dULL,
0x0ffffff808077812ULL, 0x000fe400078ef805ULL, 0x0ffffff803037812ULL, 0x000fc400078ef80dULL,
0xfffffff80f027812ULL, 0x000fe200078ee202ULL, 0x0000001007087824ULL, 0x000fe200078e0200ULL,
0x0000000003037211ULL, 0x000fe200078e20ffULL, 0x0000000804077824ULL, 0x000fe200078e00ffULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0120000008087984ULL, 0x000e620000000c00ULL,
0xfffffff807007812ULL, 0x000fe400078ee206ULL, 0x0000000705077812ULL, 0x000fe200078ec0ffULL,
0x0120000003107984ULL, 0x0004e20000000c00ULL, 0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000402007c10ULL, 0x000fe4000ff3e0ffULL, 0x1ffffff807077812ULL, 0x100fe400078ef836ULL,
0x1ffffff80d0d7812ULL, 0x000fe200078ef836ULL, 0x000000ffff037224ULL, 0x004fe200000e06ffULL,
0x00005a0006027a11ULL, 0x000fe200078048ffULL, 0x000000ffff057224ULL, 0x000fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fc400078248ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4c03ULL,
0x00005b0000057a11ULL, 0x000fc600008f4c05ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000017b037810ULL, 0x002fe20007ffe0ffULL,
0x000000407a2e7824ULL, 0x000fe200078e00ffULL, 0x0000000135087819ULL, 0x000fe200000006ffULL,
0x01c60000ff047f8cULL, 0x000e62000c80043fULL, 0x000000780300720cULL, 0x000fe20003f06070ULL,
0x000001007b067824ULL, 0x000fc400078e022eULL, 0x00005800082f7a24ULL, 0x000fc800078e022fULL,
0x000062002f1f7a24ULL, 0x000fcc00078e0206ULL, 0x00000b7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1e7819ULL, 0x000fe40000011600ULL, 0x0000000679037217ULL, 0x000fe40007800000ULL,
0x000000041e087810ULL, 0x040fe20007ffe0ffULL, 0x000000011f077824ULL, 0x000fe200078e021eULL,
0x000000081e0a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a06ULL,
0x0000000c1e0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008081d7824ULL, 0x000fe200078e00ffULL,
0x000000000a097212ULL, 0x000fc400078e3cffULL, 0x000000030a107819ULL, 0x000fe200000006ffULL,
0x000000011f0d7824ULL, 0x000fe200078e020cULL, 0x0000000008067212ULL, 0x000fe400078e3cffULL,
0xfffffff810237812ULL, 0x000fe200078ee209ULL, 0x000000080c107824ULL, 0x040fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x00005e0007067625ULL, 0x000fe200078e0002ULL,
0x000000000c097212ULL, 0x000fe400078e3cffULL, 0x000000101e127810ULL, 0x000fc40007ffe0ffULL,
0x000000700e217812ULL, 0x000fe400078ec0ffULL, 0xfffffff810257812ULL, 0x000fe200078ee209ULL,
0x0000000812107824ULL, 0x040fe200078e00ffULL, 0x00000006210e7210ULL, 0x000fe20007f1e0ffULL,
0x000000011f097824ULL, 0x000fe200078e0208ULL, 0x00000000120b7212ULL, 0x000fe400078e3cffULL,
0x00000007ff0f7210ULL, 0x000fe200007fe4ffULL, 0x00005e0009067625ULL, 0x000fe200078e0002ULL,
0xfffffff810277812ULL, 0x000fc400078ee20bULL, 0x000000030800720cULL, 0x080fe20003f86070ULL,
0x000000011f0b7824ULL, 0x000fe200078e020aULL, 0x000000141e167810ULL, 0x000fe40007ffe0ffULL,
0x0000000621107210ULL, 0x000fe20007f3e0ffULL, 0x00005e000b087625ULL, 0x000fe200078e0002ULL,
0x000000031200720cULL, 0x000fe40003f06070ULL, 0x00000007ff117210ULL, 0x000fe20000ffe4ffULL,
0x000000011f0b7824ULL, 0x000fe200078e0212ULL, 0x0000000821127210ULL, 0x000fe20007f3e0ffULL,
0x000000011f137824ULL, 0x000fe200078e0216ULL, 0x000000030c00720cULL, 0x000fe20003f66070ULL,
0x00005e000d067625ULL, 0x000fe200078e0002ULL, 0x000000181e187810ULL, 0x000fc40007ffe0ffULL,
0x000000030a00720cULL, 0x000fe20003f46070ULL, 0x00005e00130c7625ULL, 0x000fe200078e0002ULL,
0x0000000016087212ULL, 0x000fe400078e3cffULL, 0x000000071e177812ULL, 0x040fe200078e4800ULL,
0x000000ffff137224ULL, 0x000fe200008e0609ULL, 0x0000000621147210ULL, 0x000fe20007f3e0ffULL,
0x00005e000b0a7625ULL, 0x000fe200078e0002ULL, 0x0000000c210c7210ULL, 0x000fe40007fde0ffULL,
0x0000001c1e227810ULL, 0x000fe20007ffe0ffULL, 0x000000011f097824ULL, 0x000fe200078e0218ULL,
0x0000000a210a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0607ULL,
0x0000000dff0d7210ULL, 0x000fe200037fe4ffULL, 0x00005e0009067625ULL, 0x000fe200078e0002ULL,
0x000000031600720cULL, 0x000fc40003f26070ULL, 0x000020007a1a7811ULL, 0x000fe200078e70ffULL,
0x0000000816297824ULL, 0x000fe200078e00ffULL, 0x0000000621167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e060bULL, 0x000000031e00720cULL, 0x000fe20003fa6070ULL,
0x00000008182b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8171b7812ULL, 0x000fe200078ef800ULL,
0x000000ffff177224ULL, 0x000fe200030e0607ULL, 0x000000221f077210ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x000000201e1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x0000000018207212ULL, 0x000fe200078e3cffULL,
0x00005e0007067625ULL, 0x000fe200078e0002ULL, 0xfffffff829297812ULL, 0x000fc400078ee208ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1b7faeULL, 0x0005e2000e901c46ULL, 0x000000031800720cULL, 0x080fe20003fa6070ULL,
0x000000011f097824ULL, 0x000fe200078e021cULL, 0x0000000621187210ULL, 0x000fe20007fde0ffULL,
0x00000008222d7824ULL, 0x040fe200078e00ffULL, 0x00000000101d7faeULL, 0x0007e2000e101c46ULL,
0x00005e0009087625ULL, 0x000fe200078e0002ULL, 0x0000000022067212ULL, 0x040fe400078e3cffULL,
0x000000032200720cULL, 0x000fe20003f86070ULL, 0x000000ffff197224ULL, 0x000fe200030e0607ULL,
0x0000000821087210ULL, 0x000fe20007fde0ffULL, 0x00000010251b7824ULL, 0x004fe200078e021aULL,
0x000000241e0e7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL,
0x000000ffff097224ULL, 0x000fe200030e0609ULL, 0x0000001a23117211ULL, 0x008fe200078e20ffULL,
0x000000011f077824ULL, 0x000fe200078e020eULL, 0x000000001c0f7212ULL, 0x080fe400078e3cffULL,
0x000000000e107212ULL, 0x040fe200078e3cffULL, 0x00005e0007067625ULL, 0x000fe200078e0002ULL,
0x0000000012117faeULL, 0x0005e2000d101c46ULL, 0x000000030e00720cULL, 0x0c0fe40003f46070ULL,
0x000000030e237819ULL, 0x000fe200000006ffULL, 0x00000000141b7faeULL, 0x0007e2000d901c46ULL,
0x000000031c00720cULL, 0x040fe20003f66070ULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0x00000006210e7210ULL, 0x000fc40007fde0ffULL, 0x000000281e067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81c1d7812ULL, 0x000fe200078ee20fULL, 0x0000001027117824ULL, 0x104fe200078e021aULL,
0x000000301e127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200030e0607ULL,
0x000000030600720cULL, 0x000fe20003fc6070ULL, 0x0000001029077824ULL, 0x100fe200078e021aULL,
0x0000001a2d157211ULL, 0x008fe200078e20ffULL, 0x000000102b137824ULL, 0x100fe200078e021aULL,
0x000000000a117faeULL, 0x0005e2000c101c46ULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0xfffffff8231b7812ULL, 0x000fc400078ee210ULL, 0x000000000c077faeULL, 0x0007e2000c901c46ULL,
0x0000002c1e107810ULL, 0x040fe40007ffe0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0x0000000016137faeULL, 0x0009e2000e901c46ULL, 0x000000341e147810ULL, 0x040fe40007ffe0ffULL,
0x000000381e1c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000018157faeULL, 0x000be2000e101c46ULL,
0x0000003c1e1e7810ULL, 0x000fe40007ffe0ffULL, 0x000000031200720cULL, 0x080fe20003f86070ULL,
0x00000000081d7faeULL, 0x0003e2000d901c46ULL, 0x0000000006077212ULL, 0x088fe200078e3cffULL,
0x000000011f0d7824ULL, 0x000fe200078e0212ULL, 0x00000000120b7212ULL, 0x044fe200078e3cffULL,
0x000000000e1b7faeULL, 0x0005e2000d101c46ULL, 0x0000000812127824ULL, 0x000fe200078e00ffULL,
0x000000031000720cULL, 0x000fc40003fa6070ULL, 0x000000031400720cULL, 0x080fe20003f66070ULL,
0x000000011f197824ULL, 0x060fe200078e021cULL, 0x000000031c00720cULL, 0x080fe20003f26070ULL,
0x0000000806087824ULL, 0x002fe200078e00ffULL, 0x000000101f097210ULL, 0x040fe20007ffe0ffULL,
0x000000081e1d7824ULL, 0x040fe200078e00ffULL, 0x000000031e00720cULL, 0x000fe40003f06070ULL,
0xfffffff808117812ULL, 0x000fe200078ee207ULL, 0x000000011f077824ULL, 0x000fe200078e0206ULL,
0x0000000010037212ULL, 0x000fe200078e3cffULL, 0x00005e0009087625ULL, 0x000fe200078e0002ULL,
0xfffffff812157812ULL, 0x000fc400078ee20bULL, 0x0000000314177819ULL, 0x010fe200000006ffULL,
0x00005e0007067625ULL, 0x000fe200078e0002ULL, 0x0000001e1f1b7210ULL, 0x004fe40007ffe0ffULL,
0x0000001a11117211ULL, 0x000fe200078e20ffULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000006210a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001015157824ULL, 0x000fc600078e021aULL,
0xfffffff810137812ULL, 0x000fe200078ee203ULL, 0x000000ffff0b7224ULL, 0x000fe200010e0607ULL,
0x00000008210c7210ULL, 0x000fe20007f5e0ffULL, 0x00005e000d067625ULL, 0x000fe200078e0002ULL,
0x0000000014087212ULL, 0x000fe400078e3cffULL, 0x000000000a117faeULL, 0x0003e2000f101c46ULL,
0x000000011f037824ULL, 0x000fe200078e0214ULL, 0xfffffff817177812ULL, 0x000fe200078ee208ULL,
0x000000ffff0d7224ULL, 0x000fe200010e0609ULL, 0x00000006210e7210ULL, 0x000fe20007f5e0ffULL,
0x00005e0003087625ULL, 0x000fe200078e0002ULL, 0x000000001c037212ULL, 0x000fc400078e3cffULL,
0x000000001e007212ULL, 0x000fe200078e3cffULL, 0x000000ffff0f7224ULL, 0x000fe200010e0607ULL,
0x0000000821087210ULL, 0x000fe20007f5e0ffULL, 0x00005e0019067625ULL, 0x000fe200078e0002ULL,
0xfffffff81d1d7812ULL, 0x000fc600078ee200ULL, 0x000000081c1c7824ULL, 0x000fe200078e00ffULL,
0x0000001a1d1d7211ULL, 0x000fe200078e20ffULL, 0x000000ffff097224ULL, 0x000fe200010e0609ULL,
0x0000000621067210ULL, 0x000fe20007f5e0ffULL, 0x0000001013137824ULL, 0x000fe200078e021aULL,
0xfffffff81c197812ULL, 0x000fe200078ee203ULL, 0x00005e001b027625ULL, 0x000fc600078e0002ULL,
0x000000000c137faeULL, 0x0003e2000e901c46ULL, 0x000000ffff077224ULL, 0x000fe200010e0607ULL,
0x0000000221027210ULL, 0x000fe20007f5e0ffULL, 0x0000001017177824ULL, 0x100fe200078e021aULL,
0x000000000e157faeULL, 0x0003e2000e101c46ULL, 0x0000001019197824ULL, 0x000fe400078e021aULL,
0x000000ffff037224ULL, 0x000fe200010e0603ULL, 0x0000000008177faeULL, 0x0003e8000d901c46ULL,
0x0000000006197faeULL, 0x0003e8000c901c46ULL, 0x00000000021d7faeULL, 0x0003e2000c101c46ULL,
0x00000a4000007947ULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe40000011600ULL,
0x000000700e277812ULL, 0x000fc400078ec0ffULL, 0x0000000403067810ULL, 0x040fe40007ffe0ffULL,
0x0000000803087810ULL, 0x040fe40007ffe0ffULL, 0x0000000006077212ULL, 0x0c0fe200078e3cffULL,
0x00000008060c7824ULL, 0x000fe200078e00ffULL, 0x0000000c030a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0x0000001403107810ULL, 0x040fe40007ffe0ffULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee207ULL, 0x000000080a147824ULL, 0x000fe200078e00ffULL,
0x00000010030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000810187824ULL, 0x000fe200078e00ffULL,
0x0000000008077212ULL, 0x000fc400078e3cffULL, 0x000000000a097212ULL, 0x080fe200078e3cffULL,
0x000000011f157824ULL, 0x000fe200078e020cULL, 0x000000000c0b7212ULL, 0x0c0fe400078e3cffULL,
0x000000030c167819ULL, 0x000fe400000006ffULL, 0xfffffff812117812ULL, 0x000fe400078ee207ULL,
0xfffffff814137812ULL, 0x000fe400078ee209ULL, 0x00000000100d7212ULL, 0x000fc400078e3cffULL,
0x0000001803127810ULL, 0x040fe40007ffe0ffULL, 0x0000001c03147810ULL, 0x040fe40007ffe0ffULL,
0xfffffff816177812ULL, 0x000fe200078ee20bULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0x0000002003167810ULL, 0x000fe20007ffe0ffULL, 0x00000008141c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8181b7812ULL, 0x000fe200078ee20dULL, 0x000000011f1d7824ULL, 0x000fe200078e0212ULL,
0x0000002403187810ULL, 0x000fe20007ffe0ffULL, 0x00000008161e7824ULL, 0x000fe200078e00ffULL,
0x0000000012077212ULL, 0x080fe200078e3cffULL, 0x000000011f237824ULL, 0x040fe200078e0214ULL,
0x0000000014097212ULL, 0x080fe200078e3cffULL, 0x000000011f3b7824ULL, 0x040fe200078e0216ULL,
0x00000000160b7212ULL, 0x080fe200078e3cffULL, 0x000000011f3f7824ULL, 0x000fe200078e0218ULL,
0x00000000180d7212ULL, 0x000fc400078e3cffULL, 0x0000000318207819ULL, 0x000fe400000006ffULL,
0xfffffff81a217812ULL, 0x000fe400078ee207ULL, 0xfffffff81c257812ULL, 0x000fe400078ee209ULL,
0x00000028031a7810ULL, 0x040fe40007ffe0ffULL, 0x0000002c031c7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff81e3d7812ULL, 0x000fe200078ee20bULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0xfffffff820417812ULL, 0x000fe200078ee20dULL, 0x000000081c247824ULL, 0x000fe200078e00ffULL,
0x00000030031e7810ULL, 0x000fe20007ffe0ffULL, 0x000000011f477824ULL, 0x000fe200078e021cULL,
0x0000003403207810ULL, 0x000fc40007ffe0ffULL, 0x000000001a077212ULL, 0x080fe200078e3cffULL,
0x000000081e267824ULL, 0x000fe200078e00ffULL, 0x000000001c097212ULL, 0x080fe200078e3cffULL,
0x0000000820287824ULL, 0x000fe200078e00ffULL, 0x000000001e0b7212ULL, 0x080fe200078e3cffULL,
0x000000011f4b7824ULL, 0x040fe200078e021eULL, 0x00000000200d7212ULL, 0x000fe200078e3cffULL,
0x000000011f4f7824ULL, 0x000fe200078e0220ULL, 0xfffffff822457812ULL, 0x000fe400078ee207ULL,
0xfffffff824497812ULL, 0x000fc400078ee209ULL, 0x00000038030e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000703097812ULL, 0x000fe400078e4800ULL, 0x000000031f077210ULL, 0x040fe20007ffe0ffULL,
0x000000011f537824ULL, 0x000fe200078e020eULL, 0x0000003c03227810ULL, 0x000fe20007ffe0ffULL,
0x000000011f037824ULL, 0x040fe200078e0206ULL, 0xfffffff8264d7812ULL, 0x000fe200078ee20bULL,
0x000000011f0b7824ULL, 0x040fe200078e0208ULL, 0xfffffff828517812ULL, 0x000fe200078ee20dULL,
0x000000011f0d7824ULL, 0x000fe200078e020aULL, 0x0ffffff809097812ULL, 0x000fe200078ef800ULL,
0x00005e0007067625ULL, 0x000fe200078e0002ULL, 0x000000101f197210ULL, 0x000fc40007ffe0ffULL,
0x0000001a1f437210ULL, 0x040fe20007ffe0ffULL, 0x0000000822597824ULL, 0x000fe200078e00ffULL,
0x000000221f577210ULL, 0x000fe20007ffe0ffULL, 0x000000080e1f7824ULL, 0x040fe200078e00ffULL,
0x000000000e087212ULL, 0x000fe200078e3cffULL, 0x00005e000d0c7625ULL, 0x000fe200078e0002ULL,
0x00000000220a7212ULL, 0x000fe400078e3cffULL, 0x000020007a007811ULL, 0x000fe400078e70ffULL,
0x0000000627067210ULL, 0x000fc40007f1e0ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL,
0x0000001009297824ULL, 0x000fe200078e0200ULL, 0xfffffff859597812ULL, 0x000fe200078ee20aULL,
0x00005e0003087625ULL, 0x000fe200078e0002ULL, 0x000000000f2b7211ULL, 0x000fe400078e20ffULL,
0x0000000c270c7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff077224ULL, 0x000fe200000e0607ULL,
0x0000000827087210ULL, 0x000fe20007f1e0ffULL, 0x00005e000b0a7625ULL, 0x000fe200078e0002ULL,
0x0000000021377211ULL, 0x000fc400078e20ffULL, 0x00000009ff097210ULL, 0x000fe200007fe4ffULL,
0x00005e00150e7625ULL, 0x000fe200078e0002ULL, 0x0000000a270a7210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0005e2000b901c46ULL,
0x0000000049497211ULL, 0x000fe200078e20ffULL, 0x00000010112d7824ULL, 0x100fe200078e0200ULL,
0x0000000e270e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001013317824ULL, 0x000fe200078e0200ULL,
0x00000000082b7faeULL, 0x0005e2000b901c46ULL, 0x00005e0019107625ULL, 0x000fc800078e0002ULL,
0x00005e001d127625ULL, 0x000fc800078e0002ULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000001027107210ULL, 0x000fe20007f3e0ffULL, 0x0000001017337824ULL, 0x000fe400078e0200ULL,
0x000000ffff0f7224ULL, 0x000fe200000e060fULL, 0x0000001227127210ULL, 0x000fe20007f1e0ffULL,
0x00005e0023147625ULL, 0x080fe200078e0002ULL, 0x000000000a2d7faeULL, 0x0005e4000b901c46ULL,
0x00000013ff137210ULL, 0x000fe200007fe4ffULL, 0x00005e003b167625ULL, 0x000fc800078e0002ULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001427147210ULL, 0x000fe20007f3e0ffULL,
0x000000101b357824ULL, 0x000fe200078e0200ULL, 0x0000001627167210ULL, 0x000fe20007f1e0ffULL,
0x00005e003f187625ULL, 0x000fc800078e0002ULL, 0x00005e00471c7625ULL, 0x000fc800078e0002ULL,
0x00005e00431a7625ULL, 0x000fc800078e0002ULL, 0x000000101f557824ULL, 0x000fe400078e0200ULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000001827187210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000001c271c7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200010e060dULL, 0x0000001a271a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e004b1e7625ULL, 0x080fe200078e0002ULL, 0x0000001dff1d7210ULL, 0x000fe400007fe4ffULL,
0x000000000c317faeULL, 0x0005e2000b901c46ULL, 0x00005e004f207625ULL, 0x000fc600078e0002ULL,
0x000000000e337faeULL, 0x0005e2000b901c46ULL, 0x0000001025397824ULL, 0x100fe400078e0200ULL,
0x00005e0053227625ULL, 0x080fe200078e0002ULL, 0x0000000010357faeULL, 0x0005e6000b901c46ULL,
0x00005e0057247625ULL, 0x000fe200078e0002ULL, 0x0000001e27027210ULL, 0x040fe20007f1e0ffULL,
0x0000000012377faeULL, 0x0005e4000b901c46ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x00000020271e7210ULL, 0x000fe20007f3e0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e0200ULL,
0x0000000014397faeULL, 0x0005e2000b901c46ULL, 0x000000ffff1b7224ULL, 0x000fe200010e061bULL,
0x0000002227207210ULL, 0x000fe20007f5e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0200ULL,
0x0000002427227210ULL, 0x000fe20007f7e0ffULL, 0x0000001045457824ULL, 0x100fe200078e0200ULL,
0x00000000163d7faeULL, 0x0005e2000b901c46ULL, 0x000000104d4d7824ULL, 0x000fc400078e0200ULL,
0x000000ffff037224ULL, 0x000fe200000e061fULL, 0x0000000018417faeULL, 0x0005e2000b901c46ULL,
0x0000001051517824ULL, 0x100fe400078e0200ULL, 0x000000ffff1f7224ULL, 0x000fe200008e0621ULL,
0x000000001a457faeULL, 0x0005e2000b901c46ULL, 0x000000ffff217224ULL, 0x000fe400010e0623ULL,
0x0000001059597824ULL, 0x000fe200078e0200ULL, 0x000000001c497faeULL, 0x0005e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc600018e0625ULL, 0x00000000024d7faeULL, 0x0005e8000b901c46ULL,
0x000000001e517faeULL, 0x0005e8000b901c46ULL, 0x0000000020557faeULL, 0x0005e8000b901c46ULL,
0x0000000022597faeULL, 0x0005e4000b901c46ULL, 0x01c60400ff037984ULL, 0x006e680000000800ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x8000000003ff7812ULL, 0x002fc60007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e00000000007802ULL, 0x000fc80000000f00ULL,
0x0000000000027305ULL, 0x0002a4000021f000ULL, 0x3fa0000000007823ULL, 0x002fe200000100ffULL,
0x000000020000735dULL, 0x004fe20003800000ULL, 0x01c60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000787b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0001c6887a2d7811ULL, 0x040fe200078e18ffULL,
0x000000207a037824ULL, 0x000fe200078e00ffULL, 0xffffffff78027810ULL, 0x000fe40007ffe0ffULL,
0x000001007b047824ULL, 0x008fe200078e022eULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000047900720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x014fea0003800000ULL,
0x000000017b057810ULL, 0x000fe20007ffe0ffULL, 0x000062002f0c7a24ULL, 0x000fc600078e0204ULL,
0x000000780500720cULL, 0x000fda0003f06070ULL, 0x00000a9000008947ULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x002fe40000011600ULL, 0x00000007009d7812ULL, 0x000fe400078ec0ffULL,
0x0000000405077810ULL, 0x040fe40007ffe0ffULL, 0x00000014050f7810ULL, 0x000fe40007ffe0ffULL,
0x00000000079b7212ULL, 0x0c0fe200078e3cffULL, 0x0000000807067824ULL, 0x000fe200078e00ffULL,
0x0000000c050b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f087824ULL, 0x040fe200078e00ffULL,
0x000000000f977212ULL, 0x080fe200078e3cffULL, 0x0000000107cf7824ULL, 0x100fe200078e020cULL,
0xfffffff8069b7812ULL, 0x000fe200078ee29bULL, 0x000000010bcb7824ULL, 0x040fe200078e020cULL,
0x000000000b997212ULL, 0x000fc400078e3cffULL, 0x000000030b067819ULL, 0x000fe400000006ffULL,
0xfffffff808977812ULL, 0x000fe200078ee297ULL, 0x0000000179087824ULL, 0x000fe200078e0a04ULL,
0x00000000050e7212ULL, 0x040fe400078e3cffULL, 0xfffffff806997812ULL, 0x000fe200078ee299ULL,
0x00000200ff067424ULL, 0x000fe200078e00ffULL, 0x0000000c05d37210ULL, 0x040fe40007ffe0ffULL,
0x000000080500720cULL, 0x000fe20003f26070ULL, 0x00005e00cfce7625ULL, 0x000fe200078e0006ULL,
0x000000070e197812ULL, 0x000fc400078ec0ffULL, 0x000000089d317812ULL, 0x000fe200078efcffULL,
0x00005e00d3d27625ULL, 0x080fe200078e0006ULL, 0x000040007a0a7811ULL, 0x000fe400078e70ffULL,
0x0ffffff8199c7812ULL, 0x000fe200078ef800ULL, 0x00005e00cbca7625ULL, 0x000fe200078e0006ULL,
0x0000000805097810ULL, 0x000fe40007ffe0ffULL, 0x0000000a9c1b7211ULL, 0x000fe200078e20ffULL,
0x0000001031187825ULL, 0x000fe200078e00d2ULL, 0x00000010050d7810ULL, 0x000fc40007ffe0ffULL,
0x00000000099a7212ULL, 0x040fe200078e3cffULL, 0x0000000809117824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181b7faeULL, 0x0003e2000c901c46ULL,
0x0000000109cd7824ULL, 0x000fe200078e020cULL, 0x000000080700720cULL, 0x080fe20003f26070ULL,
0x000000080d137824ULL, 0x000fe200078e00ffULL, 0x000000080900720cULL, 0x000fe20003f46070ULL,
0x00005e00cdcc7625ULL, 0x000fe200078e0006ULL, 0xfffffff8119a7812ULL, 0x000fe400078ee29aULL,
0x000000000d987212ULL, 0x040fe200078e3cffULL, 0x000000010dc97824ULL, 0x000fe200078e020cULL,
0x0000001805117810ULL, 0x000fe20007ffe0ffULL, 0x000000109b237824ULL, 0x000fe200078e020aULL,
0x0000002005157810ULL, 0x000fe20007ffe0ffULL, 0x0000001031187825ULL, 0x002fe200078e00ceULL,
0x0000000c0fc77210ULL, 0x000fc40007ffe0ffULL, 0x000000080b00720cULL, 0x080fe20003f66070ULL,
0x00000008111d7824ULL, 0x000fe200078e00ffULL, 0xfffffff813987812ULL, 0x000fe200078ee298ULL,
0x00000008151f7824ULL, 0x000fe200078e00ffULL, 0x000000080d00720cULL, 0x000fe20003f86070ULL,
0x00005e00c9c87625ULL, 0x000fe200078e0006ULL, 0x0000001c05137810ULL, 0x000fe20007ffe0ffULL,
0x0000000018237faeULL, 0x0003e2000c901c46ULL, 0x000000080f00720cULL, 0x000fe20003fa6070ULL,
0x000000109a257824ULL, 0x000fe200078e020aULL, 0x0000000011967212ULL, 0x080fe200078e3cffULL,
0x00000010311a7825ULL, 0x000fe200078e00ccULL, 0x0000000015947212ULL, 0x000fc400078e3cffULL,
0xfffffff81d967812ULL, 0x000fe200078ee296ULL, 0x00005e00c7c67625ULL, 0x000fe200078e0006ULL,
0x0000000013957212ULL, 0x000fe200078e3cffULL, 0x000000001a257faeULL, 0x0005e2000d101c46ULL,
0xfffffff81f947812ULL, 0x000fe200078ee294ULL, 0x0000000111c57824ULL, 0x140fe200078e020cULL,
0x000000081100720cULL, 0x080fe20003f26070ULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0x0000002405177810ULL, 0x000fe20007ffe0ffULL, 0x0000000113c37824ULL, 0x040fe200078e020cULL,
0x000000081300720cULL, 0x000fe20003f46070ULL, 0x0000001099277824ULL, 0x000fe200078e020aULL,
0x0000000a972b7211ULL, 0x000fe200078e20ffULL, 0x00000010311c7825ULL, 0x000fe200078e00caULL,
0xfffffff80e957812ULL, 0x000fc400078ee295ULL, 0x0000000017937212ULL, 0x000fe200078e3cffULL,
0x0000001098297824ULL, 0x000fe200078e020aULL, 0x000000001c277faeULL, 0x0007e2000d901c46ULL,
0x00000010311e7825ULL, 0x000fe200078e00c8ULL, 0x000000081500720cULL, 0x080fe40003f66070ULL,
0x0000002805197810ULL, 0x002fe20007ffe0ffULL, 0x0000001031207825ULL, 0x000fe200078e00c6ULL,
0x000000001e297faeULL, 0x0003e2000e101c46ULL, 0x000000081700720cULL, 0x000fe40003f86070ULL,
0x00005e00c5c47625ULL, 0x000fe200078e0006ULL, 0x00000000202b7faeULL, 0x0009e2000e901c46ULL,
0x0000002c051b7810ULL, 0x004fc40007ffe0ffULL, 0x00005e00c3c27625ULL, 0x000fe200078e0006ULL,
0x0000000019927212ULL, 0x080fe400078e3cffULL, 0x00000030051d7810ULL, 0x008fe20007ffe0ffULL,
0x0000000115c17824ULL, 0x100fe200078e020cULL, 0x00000034051f7810ULL, 0x002fe20007ffe0ffULL,
0x0000000817107824ULL, 0x000fe200078e00ffULL, 0x000000001b917212ULL, 0x000fe200078e3cffULL,
0x0000000117bf7824ULL, 0x000fe200078e020cULL, 0x0000000a962b7211ULL, 0x010fe200078e20ffULL,
0x0000001031227825ULL, 0x000fe200078e00c4ULL, 0xfffffff810937812ULL, 0x000fc400078ee293ULL,
0x0000003805217810ULL, 0x000fe20007ffe0ffULL, 0x00005e00c1c07625ULL, 0x000fe200078e0006ULL,
0x00000000222b7faeULL, 0x0003e2000c901c46ULL, 0x000000081900720cULL, 0x080fe40003f26070ULL,
0x0000001095337824ULL, 0x000fe200078e020aULL, 0x000000031b0e7819ULL, 0x000fe200000006ffULL,
0x0000001031247825ULL, 0x000fe200078e00c2ULL, 0x000000082100720cULL, 0x000fe40003fa6070ULL,
0x000000001d907212ULL, 0x000fe200078e3cffULL, 0x00005e00bfbe7625ULL, 0x000fe200078e0006ULL,
0x0000000024337faeULL, 0x0005e2000d101c46ULL, 0x000000081b00720cULL, 0x000fc40003f46070ULL,
0x0000001094357824ULL, 0x000fe200078e020aULL, 0x0000003c05237810ULL, 0x002fe20007ffe0ffULL,
0x0000001031267825ULL, 0x000fe200078e00c0ULL, 0x0000000c21af7210ULL, 0x000fe40007ffe0ffULL,
0x000000082300720cULL, 0x080fe20003fc6070ULL, 0x0000000119bb7824ULL, 0x000fe200078e020cULL,
0x0000000026357faeULL, 0x0003e2000d901c46ULL, 0x0000001093377824ULL, 0x000fe200078e020aULL,
0x000000081d00720cULL, 0x000fe20003f66070ULL, 0x0000000819257824ULL, 0x004fe200078e00ffULL,
0x000000001f8f7212ULL, 0x000fe200078e3cffULL, 0x0000001031287825ULL, 0x000fe200078e00beULL,
0xfffffff80e917812ULL, 0x000fc400078ee291ULL, 0xfffffff825927812ULL, 0x000fe200078ee292ULL,
0x00005e00bbba7625ULL, 0x000fe200078e0006ULL, 0x0000000028377faeULL, 0x0005e2000e101c46ULL,
0x000000081f00720cULL, 0x000fe40003f86070ULL, 0x000000011bb97824ULL, 0x100fe200078e020cULL,
0x00000000218e7212ULL, 0x080fe200078e3cffULL, 0x000000011db77824ULL, 0x100fe200078e020cULL,
0x00000000238d7212ULL, 0x000fe200078e3cffULL, 0x000000081f087824ULL, 0x000fe200078e00ffULL,
0x00000003230e7819ULL, 0x000fe200000006ffULL, 0x000000011fb57824ULL, 0x000fc400078e020cULL,
0x00000008212b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8088f7812ULL, 0x000fe200078ee28fULL,
0x000000081d297824ULL, 0x004fe200078e00ffULL, 0xfffffff80e8d7812ULL, 0x000fe200078ee28dULL,
0x0000001092277824ULL, 0x002fe200078e020aULL, 0xfffffff82b8e7812ULL, 0x000fe200078ee28eULL,
0x0000001031247825ULL, 0x000fe200078e00baULL, 0xfffffff829907812ULL, 0x000fe400078ee290ULL,
0x0000000a8e397211ULL, 0x000fe200078e20ffULL, 0x0000000123ab7824ULL, 0x000fe200078e020cULL,
0x0000000024277faeULL, 0x0003e2000c901c46ULL, 0x00005e00b9b87625ULL, 0x000fc800078e0006ULL,
0x00005e00b7b67625ULL, 0x000fc800078e0006ULL, 0x00005e00b5b47625ULL, 0x000fc800078e0006ULL,
0x00005e00afae7625ULL, 0x000fc800078e0006ULL, 0x00005e00abaa7625ULL, 0x000fc800078e0006ULL,
0x0000001091337824ULL, 0x000fe400078e020aULL, 0x0000001031247825ULL, 0x002fc800078e00b8ULL,
0x0000001090357824ULL, 0x000fe200078e020aULL, 0x0000000024337faeULL, 0x0003e2000d101c46ULL,
0x0000001031267825ULL, 0x000fc800078e00b6ULL, 0x000000108f377824ULL, 0x000fe200078e020aULL,
0x0000000026357faeULL, 0x0003e2000d901c46ULL, 0x0000001031287825ULL, 0x000fc800078e00b4ULL,
0x00000010312a7825ULL, 0x000fe200078e00aeULL, 0x0000000028377faeULL, 0x0003e6000e101c46ULL,
0x000000108d3b7824ULL, 0x000fe200078e020aULL, 0x000000002a397faeULL, 0x0003e2000e901c46ULL,
0x0000001031307825ULL, 0x000fca00078e00aaULL, 0x00000000303b7faeULL, 0x0003e2000f101c46ULL,
0x0000097000007947ULL, 0x000fea0003800000ULL, 0x00000003ff057819ULL, 0x002fe40000011600ULL,
0x00000007009d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c050b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105d37824ULL, 0x140fe200078e020cULL, 0x0000000405077810ULL, 0x040fe40007ffe0ffULL,
0x0000000805097810ULL, 0x000fe20007ffe0ffULL, 0x000000080b087824ULL, 0x040fe200078e00ffULL,
0x000000000b997212ULL, 0x080fe200078e3cffULL, 0x0000000807067824ULL, 0x000fe200078e00ffULL,
0x0000001805117810ULL, 0x000fe20007ffe0ffULL, 0x00000008090d7824ULL, 0x000fe200078e00ffULL,
0x0000001c05137810ULL, 0x000fe20007ffe0ffULL, 0x0000000109cd7824ULL, 0x100fe200078e020cULL,
0x00000000079b7212ULL, 0x080fe200078e3cffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x00000000099a7212ULL, 0x080fe200078e3cffULL, 0x000000010bcb7824ULL, 0x100fe200078e020cULL,
0xfffffff808997812ULL, 0x000fe200078ee299ULL, 0x0000000813087824ULL, 0x000fe200078e00ffULL,
0x00000014050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000113c37824ULL, 0x000fe200078e020cULL,
0x0000000011967212ULL, 0x000fc400078e3cffULL, 0x0000000013957212ULL, 0x080fe200078e3cffULL,
0x000000010fc77824ULL, 0x000fe200078e020cULL, 0x0000002c051b7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8069b7812ULL, 0x000fe200078ee29bULL, 0x000000080f067824ULL, 0x000fe200078e00ffULL,
0xfffffff80d9a7812ULL, 0x000fe400078ee29aULL, 0x00000010050d7810ULL, 0x000fe40007ffe0ffULL,
0x000000000f977212ULL, 0x000fc400078e3cffULL, 0xfffffff817967812ULL, 0x000fe200078ee296ULL,
0x000000010dc97824ULL, 0x100fe200078e020cULL, 0xfffffff808957812ULL, 0x000fe200078ee295ULL,
0x000000081b087824ULL, 0x000fe200078e00ffULL, 0x0000002405177810ULL, 0x000fe40007ffe0ffULL,
0x000000001b917212ULL, 0x080fe400078e3cffULL, 0x000000000d987212ULL, 0x000fe200078e3cffULL,
0x0000000117bf7824ULL, 0x000fe200078e020cULL, 0x000000030d157819ULL, 0x000fc400000006ffULL,
0xfffffff806977812ULL, 0x000fe400078ee297ULL, 0x0000000017937212ULL, 0x0c0fe400078e3cffULL,
0x0000000317067819ULL, 0x000fe400000006ffULL, 0xfffffff808917812ULL, 0x000fe400078ee291ULL,
0xfffffff815987812ULL, 0x000fe400078ee298ULL, 0x0000000005087212ULL, 0x000fc400078e3cffULL,
0x0000002005157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff806937812ULL, 0x000fe200078ee293ULL,
0x00000200ff067424ULL, 0x000fe200078e00ffULL, 0x0000000708257812ULL, 0x000fe200078ec0ffULL,
0x00000008151d7824ULL, 0x000fe200078e00ffULL, 0x0000002805197810ULL, 0x000fe20007ffe0ffULL,
0x00005e00d3d27625ULL, 0x000fe200078e0006ULL, 0x0000000015947212ULL, 0x000fe400078e3cffULL,
0x000040007a0a7811ULL, 0x000fe200078e70ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x000000089d337812ULL, 0x000fe200078efcffULL, 0x00005e00cdcc7625ULL, 0x000fe200078e0006ULL,
0x0ffffff8259c7812ULL, 0x000fc400078ef800ULL, 0x0000000c07cf7210ULL, 0x000fe20007ffe0ffULL,
0x0000001033247825ULL, 0x000fe200078e00d2ULL, 0xfffffff81d947812ULL, 0x000fe400078ee294ULL,
0x0000003805217810ULL, 0x040fe20007ffe0ffULL, 0x000000109c277824ULL, 0x000fe200078e020aULL,
0x00000030051d7810ULL, 0x000fe20007ffe0ffULL, 0x00005e00cfce7625ULL, 0x000fe200078e0006ULL,
0x0000000019927212ULL, 0x000fe400078e3cffULL, 0x0000000c11c57210ULL, 0x000fe20007ffe0ffULL,
0x00005e00cbca7625ULL, 0x000fe200078e0006ULL, 0x000000001d907212ULL, 0x040fe200078e3cffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024277faeULL, 0x0003e2000b901c46ULL,
0x000000031d297819ULL, 0x000fe200000006ffULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f927812ULL, 0x000fe200078ee292ULL, 0x00005e00c9c87625ULL, 0x000fe200078e0006ULL,
0x00000000218e7212ULL, 0x000fc400078e3cffULL, 0x00000034051f7810ULL, 0x000fe20007ffe0ffULL,
0x00005e00c7c67625ULL, 0x000fe200078e0006ULL, 0x0000000a9b357211ULL, 0x000fe400078e20ffULL,
0x0000003c05237810ULL, 0x000fe20007ffe0ffULL, 0x0000000115c17824ULL, 0x000fe200078e020cULL,
0xfffffff829907812ULL, 0x000fe200078ee290ULL, 0x0000001033247825ULL, 0x002fe200078e00ceULL,
0x0000000c1bb97210ULL, 0x000fe40007ffe0ffULL, 0xfffffff82b8e7812ULL, 0x000fe200078ee28eULL,
0x0000000119bb7824ULL, 0x000fe200078e020cULL, 0x000000001f8f7212ULL, 0x000fe200078e3cffULL,
0x00005e00c5c47625ULL, 0x000fe200078e0006ULL, 0x0000000024357faeULL, 0x0003e2000b901c46ULL,
0x00000000238d7212ULL, 0x000fc400078e3cffULL, 0x000000109a377824ULL, 0x000fe400078e020aULL,
0x0000001033267825ULL, 0x000fc800078e00ccULL, 0x00005e00c3c27625ULL, 0x000fe200078e0006ULL,
0x0000000026377faeULL, 0x0005e2000b901c46ULL, 0x0000000a96357211ULL, 0x002fe400078e20ffULL,
0x0000001099397824ULL, 0x000fe400078e020aULL, 0x0000001033287825ULL, 0x000fc800078e00caULL,
0x00005e00c1c07625ULL, 0x000fe200078e0006ULL, 0x0000000028397faeULL, 0x0003e6000b901c46ULL,
0x00000010983b7824ULL, 0x000fe400078e020aULL, 0x00000010332a7825ULL, 0x000fc800078e00c8ULL,
0x00005e00bfbe7625ULL, 0x000fe200078e0006ULL, 0x000000002a3b7faeULL, 0x0007e6000b901c46ULL,
0x000000011db77824ULL, 0x000fe400078e020cULL, 0x000000081f087824ULL, 0x000fe400078e00ffULL,
0x00000010973d7824ULL, 0x000fe400078e020aULL, 0x0000001033307825ULL, 0x000fe200078e00c6ULL,
0xfffffff8088f7812ULL, 0x000fc600078ee28fULL, 0x00005e00bbba7625ULL, 0x000fe200078e0006ULL,
0x00000000303d7faeULL, 0x0009e6000b901c46ULL, 0x000000011fb57824ULL, 0x100fe400078e020cULL,
0x0000000121af7824ULL, 0x000fe400078e020cULL, 0x00000008230e7824ULL, 0x000fe400078e00ffULL,
0x0000001033247825ULL, 0x000fc600078e00c4ULL, 0xfffffff80e8d7812ULL, 0x000fe200078ee28dULL,
0x0000000123ab7824ULL, 0x000fe200078e020cULL, 0x0000000024357faeULL, 0x000be2000b901c46ULL,
0x00005e00b9b87625ULL, 0x000fc800078e0006ULL, 0x0000001095377824ULL, 0x004fe400078e020aULL,
0x0000001033267825ULL, 0x000fc800078e00c2ULL, 0x00005e00b7b67625ULL, 0x000fe200078e0006ULL,
0x0000000026377faeULL, 0x0005e2000b901c46ULL, 0x0000000a91357211ULL, 0x020fe400078e20ffULL,
0x0000001094397824ULL, 0x002fe400078e020aULL, 0x0000001033287825ULL, 0x000fc800078e00c0ULL,
0x00005e00b5b47625ULL, 0x000fe200078e0006ULL, 0x0000000028397faeULL, 0x0003e6000b901c46ULL,
0x00000010933b7824ULL, 0x008fe400078e020aULL, 0x00000010332a7825ULL, 0x000fc800078e00beULL,
0x00005e00afae7625ULL, 0x000fe200078e0006ULL, 0x000000002a3b7faeULL, 0x0007e6000b901c46ULL,
0x00000010923d7824ULL, 0x010fe400078e020aULL, 0x0000001033307825ULL, 0x000fc800078e00baULL,
0x00005e00abaa7625ULL, 0x000fe200078e0006ULL, 0x00000000303d7faeULL, 0x0009e6000b901c46ULL,
0x0000001033247825ULL, 0x000fc800078e00b8ULL, 0x0000001090377824ULL, 0x004fe200078e020aULL,
0x0000000024357faeULL, 0x0005e2000b901c46ULL, 0x0000001033267825ULL, 0x000fc800078e00b6ULL,
0x000000108f397824ULL, 0x002fe200078e020aULL, 0x0000000026377faeULL, 0x0005e2000b901c46ULL,
0x0000001033287825ULL, 0x000fc800078e00b4ULL, 0x000000108e3b7824ULL, 0x008fe200078e020aULL,
0x0000000028397faeULL, 0x0005e2000b901c46ULL, 0x00000010332a7825ULL, 0x000fc800078e00aeULL,
0x000000108d3d7824ULL, 0x010fe200078e020aULL, 0x000000002a3b7faeULL, 0x0005e2000b901c46ULL,
0x0000001033307825ULL, 0x000fca00078e00aaULL, 0x00000000303d7faeULL, 0x0005e4000b901c46ULL,
0x00000004ff087819ULL, 0x100fe20000011600ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000089d257812ULL, 0x006fe200078ef800ULL, 0x000040007aa87824ULL, 0x000fe200078e00ffULL,
0x00000003080c7819ULL, 0x040fe400000006ffULL, 0x00000007080a7812ULL, 0x000fe400078e7825ULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee29dULL, 0x00002000a82c7810ULL, 0x000fe20007ffe0ffULL,
0x00000020250a7824ULL, 0x000fe200078e020aULL, 0x000000070c557812ULL, 0x040fe200078ec0ffULL,
0x000000080ca47824ULL, 0x000fe200078e00ffULL, 0x00000002080e7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a287824ULL, 0x000fe200078e00ffULL, 0x0000000155d17812ULL, 0x000fc400078e7805ULL,
0x000000070e0e7812ULL, 0x000fe400078e7825ULL, 0x000000a4d1d17212ULL, 0x000fe400078efcffULL,
0x000000100ca77810ULL, 0x000fe20007ffe0ffULL, 0x00000020250e7824ULL, 0x000fe200078e020eULL,
0x0000002cd19e7211ULL, 0x000fe200078e20ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x000000200ca67810ULL, 0x000fe20007ffe0ffULL, 0x000000100e607824ULL, 0x000fe200078e00ffULL,
0x000000300c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000009e34783bULL, 0x000e620000000200ULL,
0x00000001050a7812ULL, 0x000fe400078ec0ffULL, 0x00000007a7277812ULL, 0x040fe200078ec0ffULL,
0x00000008a7a77824ULL, 0x000fe200078e00ffULL, 0x00000007a6517812ULL, 0x000fe200078ec0ffULL,
0x000000080ca57824ULL, 0x040fe200078e00ffULL, 0x000000070c537812ULL, 0x000fe200078ec0ffULL,
0x000000006060783bULL, 0x000fe20000000200ULL, 0x0000000255ad7812ULL, 0x000fc400078e1e0aULL,
0x00000001270e7812ULL, 0x100fe400078e7805ULL, 0x00000003a6a67819ULL, 0x000fe400000006ffULL,
0x0000000151b17812ULL, 0x100fe400078e7805ULL, 0x00000001530c7812ULL, 0x000fe400078e7805ULL,
0x000000a4adad7212ULL, 0x000fe400078efcffULL, 0x000000a70ebd7212ULL, 0x000fc400078efcffULL,
0x000000a6b1b17212ULL, 0x080fe200078efcffULL, 0x00000010ad897824ULL, 0x100fe200078e022cULL,
0x000000a50cb37212ULL, 0x000fe200078efcffULL, 0x00000010bd8c7824ULL, 0x000fe200078e022cULL,
0x00000002517d7812ULL, 0x000fe200078e1e0aULL, 0x00000010b18b7824ULL, 0x100fe200078e022cULL,
0x000000008958783bULL, 0x000ea20000000200ULL, 0x00000010b38a7824ULL, 0x000fe200078e022cULL,
0x000000a67d7d7212ULL, 0x000fe400078efcffULL, 0x000000008c4c783bULL, 0x000ee20000000200ULL,
0x00000002270c7812ULL, 0x000fc400078e1e0aULL, 0x000000107d877824ULL, 0x000fe200078e022cULL,
0x000000008b30783bULL, 0x000f220000000200ULL, 0x000000a70ca97212ULL, 0x000fe200078efcffULL,
0x000000342844723cULL, 0x042fe400000018ffULL, 0x000000008a48783bULL, 0x000e620000000200ULL,
0x00000002530c7812ULL, 0x000fe400078e1e0aULL, 0x0000002ca9887211ULL, 0x000fe200078e20ffULL,
0x000000008738783bULL, 0x000f620000000200ULL, 0x000000a50c9f7212ULL, 0x000fe200078efcffULL,
0x000000362834723cULL, 0x000fe400000018ffULL, 0x000000008840783bULL, 0x000e620000000200ULL,
0x00000004080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000109f867824ULL, 0x000fe200078e022cULL,
0x00000004270e7812ULL, 0x000fc400078e1e0aULL, 0x000000070c0c7812ULL, 0x000fe400078e7825ULL,
0x0000000451757812ULL, 0x100fe400078e1e0aULL, 0x0000000455777812ULL, 0x000fe200078e1e0aULL,
0x00000020250c7824ULL, 0x000fe200078e020cULL, 0x0000000453107812ULL, 0x000fe400078e1e0aULL,
0x000000a70ea37212ULL, 0x000fe200078efcffULL, 0x000000100c0c7824ULL, 0x000fe200078e00ffULL,
0x000000a675757212ULL, 0x000fc400078efcffULL, 0x000000a477777212ULL, 0x000fe200078efcffULL,
0x00000010a3847824ULL, 0x100fe200078e022cULL, 0x000000a510a17212ULL, 0x000fe200078efcffULL,
0x000000586044723cULL, 0x044fe20000001844ULL, 0x0000002c77857211ULL, 0x000fe200078e20ffULL,
0x0000001075837824ULL, 0x100fe200078e022cULL, 0x000000008468783bULL, 0x000fe20000000200ULL,
0x00000010a1827824ULL, 0x000fe200078e022cULL, 0x00000006080e7810ULL, 0x000fe40007ffe0ffULL,
0x000000008570783bULL, 0x000fe20000000200ULL, 0x0000005a6058723cULL, 0x000fe20000001834ULL,
0x000000070e0e7812ULL, 0x000fc400078e7825ULL, 0x000000008364783bULL, 0x000fe20000000200ULL,
0x0000000655557812ULL, 0x100fe400078e1e0aULL, 0x0000000651517812ULL, 0x000fe200078e1e0aULL,
0x00000000825c783bULL, 0x000fe20000000200ULL, 0x0000004c286c723cULL, 0x008fe200000018ffULL,
0x000000a455a47212ULL, 0x000fe200078efcffULL, 0x00000020250e7824ULL, 0x000fe200078e020eULL,
0x000000a651a67212ULL, 0x000fc600078efcffULL, 0x00000010a4817824ULL, 0x100fe200078e022cULL,
0x000000040e0e7819ULL, 0x000fe200000006ffULL, 0x000000302834723cULL, 0x010fe200000018ffULL,
0x00000010a67f7824ULL, 0x000fce00078e022cULL, 0x0000004e284c723cULL, 0x040ff000000018ffULL,
0x000000322830723cULL, 0x040ff000000018ffULL, 0x00000048283c723cULL, 0x042ff000000018ffULL,
0x0000004a2828723cULL, 0x000fe200000018ffULL, 0x000000008648783bULL, 0x000e6e0000000200ULL,
0x000000386034723cULL, 0x060ff00000001834ULL, 0x0000003a6038723cULL, 0x040fe20000001830ULL,
0x000000000c30783bULL, 0x0004ee0000000200ULL, 0x00000040606c723cULL, 0x000fe2000000186cULL,
0x00000006270c7812ULL, 0x004fc400078e1e0aULL, 0x00000006530a7812ULL, 0x000fe400078e1e0aULL,
0x000000a70ca77212ULL, 0x000fe200078efcffULL, 0x000000007f50783bULL, 0x000fe20000000200ULL,
0x000000a50aa57212ULL, 0x000fe200078efcffULL, 0x000000426040723cULL, 0x000fe4000000184cULL,
0x00000010a7807824ULL, 0x100fe200078e022cULL, 0x00000000814c783bULL, 0x000fe20000000200ULL,
0x00000010a57e7824ULL, 0x000fc600078e022cULL, 0x000000008054783bULL, 0x000fe20000000200ULL,
0x00000048603c723cULL, 0x042ff0000000183cULL, 0x0000004a6060723cULL, 0x000fe20000001828ULL,
0x000000000e48783bULL, 0x000e680000000200ULL, 0x000000007e28783bULL, 0x000ea60000000200ULL,
0x000000703044723cULL, 0x048ff00000001844ULL, 0x00000068306c723cULL, 0x040ff0000000186cULL,
0x000000643034723cULL, 0x040ff00000001834ULL, 0x000000723058723cULL, 0x040ff00000001858ULL,
0x0000006a3040723cULL, 0x040ff00000001840ULL, 0x000000663038723cULL, 0x040ff00000001838ULL,
0x0000005c303c723cULL, 0x040ff0000000183cULL, 0x0000005e3030723cULL, 0x000ff00000001860ULL,
0x0000004c4844723cULL, 0x042ff00000001844ULL, 0x00000054486c723cULL, 0x040ff0000000186cULL,
0x000000504834723cULL, 0x040ff00000001834ULL, 0x0000004e484c723cULL, 0x040ff00000001858ULL,
0x000000564854723cULL, 0x040ff00000001840ULL, 0x000000524850723cULL, 0x040ff00000001838ULL,
0x00000028483c723cULL, 0x044ff0000000183cULL, 0x0000002a4848723cULL, 0x000fe20000001830ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x8000000479207210ULL, 0x000fe20007ffe0ffULL,
0x000000109c0a7824ULL, 0x100fe200078e022cULL, 0x000000109d417812ULL, 0x000fe200078efcffULL,
0x000000109b0c7824ULL, 0x100fe200078e022cULL, 0x000000200500720cULL, 0x080fe20003f26070ULL,
0x000000109a0e7824ULL, 0x000fe200078e022cULL, 0x000000200700720cULL, 0x080fe20003f46070ULL,
0x0000001041267825ULL, 0x000fe200078e00d2ULL, 0x000000200900720cULL, 0x000fc40003f66070ULL,
0x000000200d00720cULL, 0x000fe20003f86070ULL, 0x0000001041287825ULL, 0x000fe200078e00ceULL,
0x0000002c98127211ULL, 0x000fe400078e20ffULL, 0x000000201700720cULL, 0x000fe20003fa6070ULL,
0x00000010412a7825ULL, 0x000fe200078e00ccULL, 0x0000002c931c7211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000260a7faeULL, 0x0003e2000c901c46ULL,
0x000000200b00720cULL, 0x080fe20003f26070ULL, 0x0000001099107824ULL, 0x000fe200078e022cULL,
0x000000202300720cULL, 0x080fe20003fc6070ULL, 0x00000000280c7faeULL, 0x0005e2000d101c46ULL,
0x000000200f00720cULL, 0x000fe20003f46070ULL, 0x0000001041307825ULL, 0x000fc400078e00caULL,
0x000000002a0e7faeULL, 0x0007e2000d901c46ULL, 0x000000201100720cULL, 0x000fe20003f66070ULL,
0x0000001041327825ULL, 0x000fc800078e00c8ULL, 0x0000001097147824ULL, 0x000fe200078e022cULL,
0x0000000030107faeULL, 0x0009e2000c901c46ULL, 0x0000001041267825ULL, 0x002fe200078e00c6ULL,
0x000000201900720cULL, 0x080fe40003f26070ULL, 0x0000000032127faeULL, 0x0003e2000e101c46ULL,
0x000000201300720cULL, 0x080fe20003f86070ULL, 0x0000001096167824ULL, 0x100fe400078e022cULL,
0x0000000026147faeULL, 0x000be2000d101c46ULL, 0x000000201500720cULL, 0x000fe20003f46070ULL,
0x0000001095187824ULL, 0x000fc400078e022cULL, 0x0000001041307825ULL, 0x010fc800078e00c4ULL,
0x00000010412a7825ULL, 0x008fe200078e00c2ULL, 0x0000000030167faeULL, 0x0007e2000d901c46ULL,
0x000000201d00720cULL, 0x080fe40003f66070ULL, 0x00000010941a7824ULL, 0x000fe200078e022cULL,
0x000000002a187faeULL, 0x0009e2000e101c46ULL, 0x0000001041287825ULL, 0x004fe200078e00c0ULL,
0x000000201f00720cULL, 0x000fc60003f86070ULL, 0x0000001041267825ULL, 0x020fe200078e00beULL,
0x00000000281a7faeULL, 0x0005e2000d101c46ULL, 0x000000201b00720cULL, 0x080fe40003f46070ULL,
0x00000010921e7824ULL, 0x000fe200078e022cULL, 0x00000000261c7faeULL, 0x000be2000e901c46ULL,
0x000000202100720cULL, 0x000fe20003fa6070ULL, 0x00000010413a7825ULL, 0x000fc800078e00baULL,
0x0000001091207824ULL, 0x000fe200078e022cULL, 0x000000003a1e7faeULL, 0x0005e2000c901c46ULL,
0x0000001041387825ULL, 0x000fc800078e00b8ULL, 0x0000001090227824ULL, 0x000fe200078e022cULL,
0x0000002c8e267211ULL, 0x020fe200078e20ffULL, 0x0000001041327825ULL, 0x002fe200078e00b6ULL,
0x0000000038207faeULL, 0x0003e6000d101c46ULL, 0x000000108f247824ULL, 0x000fe200078e022cULL,
0x0000000032227faeULL, 0x0003e2000d901c46ULL, 0x0000001041307825ULL, 0x008fc800078e00b4ULL,
0x00000010412a7825ULL, 0x010fe200078e00aeULL, 0x0000000030247faeULL, 0x0003e6000e101c46ULL,
0x000000108d277824ULL, 0x000fe200078e022cULL, 0x000000002a267faeULL, 0x0003e2000e901c46ULL,
0x0000001041287825ULL, 0x004fca00078e00aaULL, 0x0000000028277faeULL, 0x0003e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x000000109d437812ULL, 0x000fe200078efcffULL,
0x000000109c0a7824ULL, 0x100fe200078e022cULL, 0x0000002c99107211ULL, 0x080fe200078e20ffULL,
0x000000109b0c7824ULL, 0x000fe200078e022cULL, 0x0000002c941a7211ULL, 0x080fe200078e20ffULL,
0x0000001043267825ULL, 0x000fe200078e00d2ULL, 0x0000002c8f247211ULL, 0x000fc600078e20ffULL,
0x0000001043287825ULL, 0x040fe200078e00ceULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000260a7faeULL, 0x0003e6000b901c46ULL, 0x000000109a0e7824ULL, 0x000fe200078e022cULL,
0x00000000280c7faeULL, 0x0005e2000b901c46ULL, 0x00000010432a7825ULL, 0x000fc800078e00ccULL,
0x0000001043327825ULL, 0x040fe200078e00caULL, 0x000000002a0e7faeULL, 0x0007e6000b901c46ULL,
0x0000001098127824ULL, 0x000fe200078e022cULL, 0x0000000032107faeULL, 0x0009e2000b901c46ULL,
0x0000001043387825ULL, 0x000fc800078e00c8ULL, 0x0000001097147824ULL, 0x000fe200078e022cULL,
0x0000000038127faeULL, 0x000be2000b901c46ULL, 0x0000001043407825ULL, 0x000fc800078e00c6ULL,
0x0000001096167824ULL, 0x000fe200078e022cULL, 0x0000000040147faeULL, 0x0005e2000b901c46ULL,
0x0000001043267825ULL, 0x002fc800078e00c4ULL, 0x0000001095187824ULL, 0x000fe200078e022cULL,
0x0000000026167faeULL, 0x0003e2000b901c46ULL, 0x0000001043307825ULL, 0x000fc800078e00c2ULL,
0x00000010432a7825ULL, 0x008fe200078e00c0ULL, 0x0000000030187faeULL, 0x0007e6000b901c46ULL,
0x00000010931c7824ULL, 0x000fe200078e022cULL, 0x000000002a1a7faeULL, 0x0003e2000b901c46ULL,
0x0000001043287825ULL, 0x004fc800078e00beULL, 0x00000010921e7824ULL, 0x000fe200078e022cULL,
0x00000000281c7faeULL, 0x0005e2000b901c46ULL, 0x00000010433a7825ULL, 0x000fc800078e00baULL,
0x0000001091207824ULL, 0x000fe200078e022cULL, 0x000000003a1e7faeULL, 0x0003e2000b901c46ULL,
0x0000001043387825ULL, 0x020fc800078e00b8ULL, 0x0000001090227824ULL, 0x000fe200078e022cULL,
0x0000000038207faeULL, 0x0005e2000b901c46ULL, 0x0000001043327825ULL, 0x010fc800078e00b6ULL,
0x0000001043307825ULL, 0x048fe200078e00b4ULL, 0x0000000032227faeULL, 0x0007e6000b901c46ULL,
0x000000108e267824ULL, 0x002fe200078e022cULL, 0x0000000030247faeULL, 0x0007e2000b901c46ULL,
0x00000010432a7825ULL, 0x000fc800078e00aeULL, 0x000000108d277824ULL, 0x000fe200078e022cULL,
0x000000002a267faeULL, 0x0007e2000b901c46ULL, 0x0000001043287825ULL, 0x004fca00078e00aaULL,
0x0000000028277faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000808287810ULL, 0x00afe40007ffe0ffULL, 0x00004000a8a87810ULL, 0x000fe40007ffe0ffULL,
0x0000000728287812ULL, 0x100fe400078e7825ULL, 0x0000000a082a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010a97c7824ULL, 0x000fe200078e02a8ULL, 0x000000a8a1a17211ULL, 0x080fe200078e20ffULL,
0x0000002025297824ULL, 0x000fe200078e0228ULL, 0x000000072a2c7812ULL, 0x000fe200078e7825ULL,
0x00000010d1287824ULL, 0x100fe200078e02a8ULL, 0x000000a8a6a67211ULL, 0x000fe200078e20ffULL,
0x00000010b12a7824ULL, 0x100fe200078e02a8ULL, 0x0000000429587819ULL, 0x000fe200000006ffULL,
0x00000010bd297824ULL, 0x000fc400078e02a8ULL, 0x0000002025407824ULL, 0x000fe200078e022cULL,
0x000000a8ad2c7211ULL, 0x000fe200078e20ffULL, 0x00000010b32b7824ULL, 0x000fe400078e02a8ULL,
0x0000001040407824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002830783bULL, 0x000fe20000000200ULL, 0x000000107d7d7824ULL, 0x100fe400078e02a8ULL,
0x000000109f9f7824ULL, 0x100fe200078e02a8ULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x0000001077a07824ULL, 0x100fe400078e02a8ULL, 0x00000010a3a37824ULL, 0x100fe200078e02a8ULL,
0x000000002938783bULL, 0x000ea20000000200ULL, 0x0000001075a27824ULL, 0x100fe400078e02a8ULL,
0x00000010a4a47824ULL, 0x100fe200078e02a8ULL, 0x000000002c70783bULL, 0x000fe20000000200ULL,
0x00000010a7a77824ULL, 0x000fc400078e02a8ULL, 0x00000010a5a57824ULL, 0x000fe200078e02a8ULL,
0x000000004040783bULL, 0x000ee80000000200ULL, 0x000000002a60783bULL, 0x000f280000000200ULL,
0x000000002b5c783bULL, 0x000fe80000000200ULL, 0x00000000a074783bULL, 0x000fe80000000200ULL,
0x00000000a368783bULL, 0x000fe80000000200ULL, 0x00000000a264783bULL, 0x000fe20000000200ULL,
0x000000305844723cULL, 0x042ff00000001844ULL, 0x00000032584c723cULL, 0x040fe2000000184cULL,
0x000000007c30783bULL, 0x000e6e0000000200ULL, 0x00000038586c723cULL, 0x044ff0000000186cULL,
0x0000003a5854723cULL, 0x000fe20000001854ULL, 0x000000007d38783bULL, 0x000eae0000000200ULL,
0x000000704044723cULL, 0x048ff00000001844ULL, 0x000000724070723cULL, 0x000fe2000000184cULL,
0x000000009f4c783bULL, 0x000eee0000000200ULL, 0x000000605834723cULL, 0x050ff00000001834ULL,
0x000000625850723cULL, 0x000fe20000001850ULL, 0x00000000a160783bULL, 0x000fee0000000200ULL,
0x00000030406c723cULL, 0x002fee000000186cULL, 0x0000000c08307810ULL, 0x000fe20007ffe0ffULL,
0x0000005c583c723cULL, 0x040ff0000000183cULL, 0x0000005e5848723cULL, 0x000fee0000001848ULL,
0x0000000730587812ULL, 0x000fe200078e7825ULL, 0x000000384034723cULL, 0x004fe60000001834ULL,
0x0000005825587211ULL, 0x000fca00078e28ffULL, 0x0000001058587824ULL, 0x000fe200078e00ffULL,
0x0000003a4038723cULL, 0x040fe80000001850ULL, 0x00000000585c783bULL, 0x000e660000000200ULL,
0x0000000e08507810ULL, 0x000fe20007ffe0ffULL, 0x000000324030723cULL, 0x000fe20000001854ULL,
0x00000000a458783bULL, 0x000fe40000000200ULL, 0x0000000750507812ULL, 0x000fc400078e7825ULL,
0x00000000a754783bULL, 0x000fe60000000200ULL, 0x0000002025507824ULL, 0x000fe200078e0250ULL,
0x0000004c403c723cULL, 0x048fe6000000183cULL, 0x0000001050a97824ULL, 0x000fe400078e00ffULL,
0x00000000a650783bULL, 0x000fe60000000200ULL, 0x0000004e4040723cULL, 0x000fe20000001848ULL,
0x00000000a948783bULL, 0x000ea80000000200ULL, 0x00000000a54c783bULL, 0x000ee60000000200ULL,
0x000000745c44723cULL, 0x042ff00000001844ULL, 0x000000765c70723cULL, 0x040ff00000001870ULL,
0x000000685c6c723cULL, 0x040ff0000000186cULL, 0x0000006a5c30723cULL, 0x040ff00000001830ULL,
0x000000645c34723cULL, 0x040ff00000001834ULL, 0x000000665c38723cULL, 0x040ff00000001838ULL,
0x000000605c3c723cULL, 0x040ff0000000183cULL, 0x000000625c40723cULL, 0x000ff00000001840ULL,
0x000000584844723cULL, 0x044ff00000001844ULL, 0x0000005a4870723cULL, 0x040ff00000001870ULL,
0x00000054486c723cULL, 0x040ff0000000186cULL, 0x000000564830723cULL, 0x040ff00000001830ULL,
0x000000504834723cULL, 0x040ff00000001834ULL, 0x000000524838723cULL, 0x040ff00000001838ULL,
0x0000004c483c723cULL, 0x048ff0000000183cULL, 0x0000004e4848723cULL, 0x000fe20000001840ULL,
0x0000046000008947ULL, 0x000fee0003800000ULL, 0x0000000179407824ULL, 0x000fe200078e0a04ULL,
0x000000189d9d7812ULL, 0x000fe200078efcffULL, 0x000000109c417824ULL, 0x100fe200078e02a8ULL,
0x000000a89a437211ULL, 0x000fe200078e20ffULL, 0x000000109b9b7824ULL, 0x000fe200078e02a8ULL,
0x000000400500720cULL, 0x080fe20003f06070ULL, 0x000000109dd27825ULL, 0x000fe200078e00d2ULL,
0x000000400700720cULL, 0x000fc40003f26070ULL, 0x000000400d00720cULL, 0x080fe20003f46070ULL,
0x000000109dce7825ULL, 0x000fe200078e00ceULL, 0x000000400f00720cULL, 0x080fe40003f66070ULL,
0x000000401100720cULL, 0x080fe20003f86070ULL, 0x000000109dcc7825ULL, 0x000fe200078e00ccULL,
0x000000401300720cULL, 0x080fe40003fa6070ULL, 0x000000401500720cULL, 0x080fe20003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000d2417faeULL, 0x0003e2000c101c46ULL,
0x000000400900720cULL, 0x000fe20003f06070ULL, 0x0000001099997824ULL, 0x000fe200078e02a8ULL,
0x000000a895957211ULL, 0x000fe200078e20ffULL, 0x00000000ce9b7faeULL, 0x0005e2000c901c46ULL,
0x000000400b00720cULL, 0x000fe20003f26070ULL, 0x000000109dca7825ULL, 0x000fc800078e00caULL,
0x00000010984d7824ULL, 0x000fe400078e02a8ULL, 0x000000109dc87825ULL, 0x000fe200078e00c8ULL,
0x000000a890417211ULL, 0x002fe200078e20ffULL, 0x00000000cc437faeULL, 0x0005e2000c101c46ULL,
0x000000401700720cULL, 0x080fe20003f06070ULL, 0x0000001097977824ULL, 0x000fe400078e02a8ULL,
0x000000109dc67825ULL, 0x000fe200078e00c6ULL, 0x00000000ca997faeULL, 0x0005e2000c901c46ULL,
0x000000401900720cULL, 0x000fc40003f26070ULL, 0x00000010964f7824ULL, 0x000fe200078e02a8ULL,
0x00000000c84d7faeULL, 0x0005e2000d101c46ULL, 0x000000109dc47825ULL, 0x000fe200078e00c4ULL,
0x000000401b00720cULL, 0x080fe40003f46070ULL, 0x00000000c6977faeULL, 0x0005e2000d901c46ULL,
0x000000109dc27825ULL, 0x000fe200078e00c2ULL, 0x000000401d00720cULL, 0x080fe40003f66070ULL,
0x00000000c44f7faeULL, 0x0005e2000e101c46ULL, 0x0000001094517824ULL, 0x000fe200078e02a8ULL,
0x000000401f00720cULL, 0x080fe20003f86070ULL, 0x000000109dc07825ULL, 0x000fe200078e00c0ULL,
0x00000000c2957faeULL, 0x0005e2000e901c46ULL, 0x000000402100720cULL, 0x000fc40003fa6070ULL,
0x0000001093937824ULL, 0x000fe200078e02a8ULL, 0x00000000c0517faeULL, 0x0005e2000f101c46ULL,
0x000000402300720cULL, 0x000fe20003fc6070ULL, 0x000000109dbe7825ULL, 0x000fc800078e00beULL,
0x0000001092537824ULL, 0x000fe200078e02a8ULL, 0x00000000be937faeULL, 0x0005e2000c101c46ULL,
0x000000109dba7825ULL, 0x000fc800078e00baULL, 0x0000001091917824ULL, 0x000fe200078e02a8ULL,
0x00000000ba537faeULL, 0x0005e2000c901c46ULL, 0x000000109db87825ULL, 0x000fc800078e00b8ULL,
0x000000109db67825ULL, 0x000fe200078e00b6ULL, 0x00000000b8917faeULL, 0x0005e6000d101c46ULL,
0x000000108f8f7824ULL, 0x000fe200078e02a8ULL, 0x00000000b6417faeULL, 0x0005e2000d901c46ULL,
0x000000109db47825ULL, 0x000fc800078e00b4ULL, 0x000000108e557824ULL, 0x000fe200078e02a8ULL,
0x00000000b48f7faeULL, 0x0005e2000e101c46ULL, 0x000000109dae7825ULL, 0x000fc800078e00aeULL,
0x000000108d8d7824ULL, 0x000fe200078e02a8ULL, 0x00000000ae557faeULL, 0x0005e2000e901c46ULL,
0x000000109daa7825ULL, 0x000fca00078e00aaULL, 0x00000000aa8d7faeULL, 0x0005e2000f101c46ULL,
0x0000034000007947ULL, 0x000fea0003800000ULL, 0x000000189d9d7812ULL, 0x000fe200078efcffULL,
0x000000109b9b7824ULL, 0x100fe200078e02a8ULL, 0x000000a89c417211ULL, 0x080fe200078e20ffULL,
0x000000109a437824ULL, 0x000fe200078e02a8ULL, 0x000000a8984d7211ULL, 0x080fe200078e20ffULL,
0x000000109dd27825ULL, 0x040fe200078e00d2ULL, 0x000000a894517211ULL, 0x080fe400078e20ffULL,
0x000000a890557211ULL, 0x000fe200078e20ffULL, 0x000000109dce7825ULL, 0x040fe200078e00ceULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000d2417faeULL, 0x0003e6000b901c46ULL,
0x000000109dcc7825ULL, 0x000fe200078e00ccULL, 0x00000000ce9b7faeULL, 0x0003e6000b901c46ULL,
0x0000001099997824ULL, 0x000fe200078e02a8ULL, 0x00000000cc437faeULL, 0x0003e2000b901c46ULL,
0x000000109dca7825ULL, 0x000fc800078e00caULL, 0x000000109dc87825ULL, 0x000fe200078e00c8ULL,
0x00000000ca997faeULL, 0x0003e6000b901c46ULL, 0x0000001097977824ULL, 0x000fe200078e02a8ULL,
0x00000000c84d7faeULL, 0x0003e2000b901c46ULL, 0x000000109dc67825ULL, 0x000fc800078e00c6ULL,
0x00000010964f7824ULL, 0x000fe200078e02a8ULL, 0x00000000c6977faeULL, 0x0003e2000b901c46ULL,
0x000000109dc47825ULL, 0x000fc800078e00c4ULL, 0x0000001095957824ULL, 0x000fe200078e02a8ULL,
0x00000000c44f7faeULL, 0x0003e2000b901c46ULL, 0x000000109dc27825ULL, 0x000fc800078e00c2ULL,
0x000000109dc07825ULL, 0x000fe200078e00c0ULL, 0x00000000c2957faeULL, 0x0003e6000b901c46ULL,
0x0000001093937824ULL, 0x000fe200078e02a8ULL, 0x00000000c0517faeULL, 0x0003e2000b901c46ULL,
0x000000109dbe7825ULL, 0x000fc800078e00beULL, 0x0000001092537824ULL, 0x000fe200078e02a8ULL,
0x00000000be937faeULL, 0x0003e2000b901c46ULL, 0x000000109dba7825ULL, 0x000fc800078e00baULL,
0x0000001091917824ULL, 0x000fe200078e02a8ULL, 0x00000000ba537faeULL, 0x0003e2000b901c46ULL,
0x000000109db87825ULL, 0x000fc800078e00b8ULL, 0x000000109db67825ULL, 0x000fe200078e00b6ULL,
0x00000000b8917faeULL, 0x0003e6000b901c46ULL, 0x000000108f8f7824ULL, 0x000fe200078e02a8ULL,
0x00000000b6557faeULL, 0x0003e2000b901c46ULL, 0x000000109db47825ULL, 0x000fc800078e00b4ULL,
0x000000108e577824ULL, 0x000fe200078e02a8ULL, 0x00000000b48f7faeULL, 0x0003e2000b901c46ULL,
0x000000109dae7825ULL, 0x000fc800078e00aeULL, 0x000000108d8d7824ULL, 0x000fe200078e02a8ULL,
0x00000000ae577faeULL, 0x0003e2000b901c46ULL, 0x000000109daa7825ULL, 0x000fca00078e00aaULL,
0x00000000aa8d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001008407810ULL, 0x040fe40007ffe0ffULL, 0x00000012084c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000740407812ULL, 0x100fe400078e7825ULL, 0x000000074c4c7812ULL, 0x000fe400078e7825ULL,
0x0000004025407211ULL, 0x000fc600078e28ffULL, 0x00000020254c7824ULL, 0x000fe400078e024cULL,
0x0000001040547824ULL, 0x000fe400078e00ffULL, 0x000000104c4c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000009e64783bULL, 0x000fe80000000200ULL,
0x000000005454783bULL, 0x006e680000000200ULL, 0x000000008c40783bULL, 0x000ea80000000200ULL,
0x000000008b5c783bULL, 0x000ee80000000200ULL, 0x000000004c4c783bULL, 0x000fe80000000200ULL,
0x000000008a58783bULL, 0x000fe80000000200ULL, 0x000000008950783bULL, 0x000fe80000000200ULL,
0x000000008174783bULL, 0x000fe80000000200ULL, 0x000000008068783bULL, 0x000fe20000000200ULL,
0x000000645460723cULL, 0x042fe60000001844ULL, 0x000000008844783bULL, 0x000e6a0000000200ULL,
0x00000040546c723cULL, 0x044ff0000000186cULL, 0x000000665470723cULL, 0x040fe20000001870ULL,
0x000000008764783bULL, 0x000eae0000000200ULL, 0x000000425430723cULL, 0x040fe20000001830ULL,
0x000000008640783bULL, 0x000f2e0000000200ULL, 0x0000005c5434723cULL, 0x048ff00000001834ULL,
0x0000005e5438723cULL, 0x000fe20000001838ULL, 0x00000000825c783bULL, 0x000fee0000000200ULL,
0x000000444c6c723cULL, 0x002fee000000186cULL, 0x0000001408447810ULL, 0x000fe20007ffe0ffULL,
0x00000058543c723cULL, 0x000fe6000000183cULL, 0x0000000744447812ULL, 0x000fc800078e7825ULL,
0x0000004425447211ULL, 0x000fe200078e28ffULL, 0x0000005a5448723cULL, 0x000fe20000001848ULL,
0x000000008354783bULL, 0x000fe60000000200ULL, 0x0000001044587824ULL, 0x000fc800078e00ffULL,
0x000000504c60723cULL, 0x040fe40000001860ULL, 0x000000005858783bULL, 0x000fec0000000200ULL,
0x000000524c70723cULL, 0x040fe20000001870ULL, 0x000000008450783bULL, 0x000fee0000000200ULL,
0x000000464c30723cULL, 0x040fe20000001830ULL, 0x000000008544783bULL, 0x000e6e0000000200ULL,
0x000000644c34723cULL, 0x044fee0000001834ULL, 0x0000001608647810ULL, 0x000fe20007ffe0ffULL,
0x000000664c38723cULL, 0x000fe60000001838ULL, 0x0000000764647812ULL, 0x000fca00078e7825ULL,
0x0000002025647824ULL, 0x000fe200078e0264ULL, 0x000000404c3c723cULL, 0x050fee000000183cULL,
0x0000001064407824ULL, 0x000fe200078e00ffULL, 0x000000424c48723cULL, 0x000fe20000001848ULL,
0x000000007f64783bULL, 0x000fe80000000200ULL, 0x000000004040783bULL, 0x000ea60000000200ULL,
0x000000445860723cULL, 0x042fe20000001860ULL, 0x000000007e4c783bULL, 0x000e6e0000000200ULL,
0x000000465870723cULL, 0x040ff00000001870ULL, 0x00000050586c723cULL, 0x040ff0000000186cULL,
0x000000525830723cULL, 0x040ff00000001830ULL, 0x000000545834723cULL, 0x040ff00000001834ULL,
0x000000565838723cULL, 0x040ff00000001838ULL, 0x0000005c583c723cULL, 0x040ff0000000183cULL,
0x0000005e5848723cULL, 0x000ff00000001848ULL, 0x000000744060723cULL, 0x044ff00000001860ULL,
0x000000764070723cULL, 0x040ff00000001870ULL, 0x00000068406c723cULL, 0x040ff0000000186cULL,
0x0000006a4030723cULL, 0x040ff00000001830ULL, 0x000000644034723cULL, 0x040ff00000001834ULL,
0x000000664038723cULL, 0x040ff00000001838ULL, 0x0000004c403c723cULL, 0x042ff0000000183cULL,
0x0000004e4048723cULL, 0x000fee0000001848ULL, 0x000003007b417a10ULL, 0x000fc80007ffe0ffULL,
0x0000000141437810ULL, 0x040fe40007ffe0ffULL, 0x0000002e41427211ULL, 0x000fe400078e40ffULL,
0x000000784300720cULL, 0x000fc60003f06070ULL, 0x000062002f567a24ULL, 0x000fd400078e0242ULL,
0x0000068000008947ULL, 0x000fea0003800000ULL, 0x0000004279407217ULL, 0x000fe20007800000ULL,
0x0000000105437824ULL, 0x000fe200078e0256ULL, 0x0000005607457210ULL, 0x000fe20007ffe0ffULL,
0x0000001000447824ULL, 0x000fe400078e00ffULL, 0x0000000140407824ULL, 0x000fe400078e0a42ULL,
0x00005e0043427625ULL, 0x000fe200078e0006ULL, 0x0000007044577812ULL, 0x000fe400078ec0ffULL,
0x000000400900720cULL, 0x000fe20003f86070ULL, 0x00005e0045447625ULL, 0x000fe200078e0006ULL,
0x00000042574c7210ULL, 0x000fc40007f1e0ffULL, 0x000000400500720cULL, 0x000fe20003f66070ULL,
0x0000000109097824ULL, 0x100fe200078e0256ULL, 0x000000560d057210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff4d7224ULL, 0x000fe200000e0643ULL, 0x00000044574e7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0009427625ULL, 0x000fe200078e0006ULL, 0x000000400700720cULL, 0x080fe40003f46070ULL,
0x000000400b00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff4f7224ULL, 0x000fe200000e0645ULL,
0x0000004257507210ULL, 0x000fe20007f3e0ffULL, 0x00005e0005447625ULL, 0x000fe200078e0006ULL,
0x000000400d00720cULL, 0x000fe20003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000004c0a7faeULL, 0x0003e2000d901c46ULL, 0x00000056170d7210ULL, 0x000fe20007ffe0ffULL,
0x000000010b477824ULL, 0x000fc400078e0256ULL, 0x000000ffff517224ULL, 0x000fe200008e0643ULL,
0x0000004457527210ULL, 0x000fe20007f3e0ffULL, 0x00005e0047467625ULL, 0x000fe200078e0006ULL,
0x000000004e0c7faeULL, 0x0005e2000d101c46ULL, 0x000000401100720cULL, 0x000fe40003f46070ULL,
0x000000010f077824ULL, 0x100fe200078e0256ULL, 0x0000004657467210ULL, 0x000fe20007fde0ffULL,
0x000000ffff537224ULL, 0x000fe200008e0645ULL, 0x000000400f00720cULL, 0x000fe20003f26070ULL,
0x00005e0007427625ULL, 0x000fe200078e0006ULL, 0x00000047ff477210ULL, 0x000fe200037fe4ffULL,
0x00000000500e7faeULL, 0x0007e2000e101c46ULL, 0x000000401700720cULL, 0x000fe20003f86070ULL,
0x0000000111057824ULL, 0x100fe200078e0256ULL, 0x0000004257547210ULL, 0x000fe20007fde0ffULL,
0x00000001150b7824ULL, 0x100fe200078e0256ULL, 0x0000000046107faeULL, 0x0009e2000e901c46ULL,
0x0000000113077824ULL, 0x000fe200078e0256ULL, 0x00000043ff557210ULL, 0x000fe200037fe4ffULL,
0x00005e0005447625ULL, 0x000fe200078e0006ULL, 0x0000000052127faeULL, 0x000be2000c101c46ULL,
0x000000401900720cULL, 0x000fc40003f06070ULL, 0x00005e000b0a7625ULL, 0x002fe200078e0006ULL,
0x0000000054147faeULL, 0x0003e2000c901c46ULL, 0x0000004457447210ULL, 0x000fe40007f7e0ffULL,
0x00005e0007427625ULL, 0x000fe200078e0006ULL, 0x0000000a570e7210ULL, 0x008fe40007f3e0ffULL,
0x000000401500720cULL, 0x000fe20003fa6070ULL, 0x00005e000d0c7625ULL, 0x004fe200078e0006ULL,
0x0000004257427210ULL, 0x000fc60007fde0ffULL, 0x0000000119197824ULL, 0x100fe400078e0256ULL,
0x000000ffff457224ULL, 0x000fe200018e0645ULL, 0x000000401300720cULL, 0x080fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200008e060bULL, 0x000000401b00720cULL, 0x000fe20003f26070ULL,
0x000000ffff437224ULL, 0x000fe200030e0643ULL, 0x0000000c57107210ULL, 0x010fe20007fde0ffULL,
0x00005e00190a7625ULL, 0x000fe200078e0006ULL, 0x0000000044167faeULL, 0x0005e4000d101c46ULL,
0x0000000dff117210ULL, 0x000fe200037fe4ffULL, 0x000000011b057824ULL, 0x100fe200078e0256ULL,
0x0000000a57127210ULL, 0x020fe20007f5e0ffULL, 0x000000011f077824ULL, 0x000fc400078e0256ULL,
0x00005e00050c7625ULL, 0x000fe200078e0006ULL, 0x0000000042187faeULL, 0x0007e6000d901c46ULL,
0x000000011d057824ULL, 0x100fe200078e0256ULL, 0x0000000c57147210ULL, 0x002fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x000000000e1a7faeULL, 0x0007e2000e901c46ULL,
0x00005e00050a7625ULL, 0x000fe200078e0006ULL, 0x0000000dff157210ULL, 0x000fe400037fe4ffULL,
0x000000401d00720cULL, 0x000fe20003f46070ULL, 0x0000000121057824ULL, 0x000fe200078e0256ULL,
0x0000000a57167210ULL, 0x004fe20007f7e0ffULL, 0x00005e00070c7625ULL, 0x000fe200078e0006ULL,
0x00000000101c7faeULL, 0x0007e2000e101c46ULL, 0x000000402100720cULL, 0x000fc40003f86070ULL,
0x000000ffff177224ULL, 0x000fe200018e060bULL, 0x0000000c570c7210ULL, 0x000fe20007fde0ffULL,
0x00005e00050a7625ULL, 0x000fe200078e0006ULL, 0x000000401f00720cULL, 0x000fe20003f66070ULL,
0x00000000121e7faeULL, 0x0007e2000c101c46ULL, 0x0000000dff0d7210ULL, 0x000fe200037fe4ffULL,
0x0000000123077824ULL, 0x000fe200078e0256ULL, 0x0000000a570a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000014207faeULL, 0x0007e4000c901c46ULL, 0x00005e0007067625ULL, 0x000fc400078e0006ULL,
0x0000000016227faeULL, 0x0007e4000d101c46ULL, 0x000000ffff0b7224ULL, 0x000fe200028e060bULL,
0x000000402300720cULL, 0x000fe20003fa6070ULL, 0x000000000c247faeULL, 0x0007e2000d901c46ULL,
0x0000000657067210ULL, 0x000fc60007fde0ffULL, 0x000000000a267faeULL, 0x0007e4000e101c46ULL,
0x000000ffff077224ULL, 0x000fcc00030e0607ULL, 0x0000000006277faeULL, 0x0007e2000e901c46ULL,
0x0000055000007947ULL, 0x000fea0003800000ULL, 0x0000000105437824ULL, 0x000fe200078e0256ULL,
0x0000005607457210ULL, 0x080fe20007ffe0ffULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x000000560f517210ULL, 0x000fe20007ffe0ffULL, 0x00005e0043427625ULL, 0x000fe200078e0006ULL,
0x0000005617597210ULL, 0x000fe40007ffe0ffULL, 0x0000007005057812ULL, 0x000fe200078ec0ffULL,
0x00005e0045447625ULL, 0x000fe200078e0006ULL, 0x000000561d5f7210ULL, 0x000fc40007ffe0ffULL,
0x0000004205427210ULL, 0x000fe20007f1e0ffULL, 0x0000000109477824ULL, 0x100fe400078e0256ULL,
0x000000010d4f7824ULL, 0x000fe200078e0256ULL, 0x00000043ff437210ULL, 0x000fe200007fe4ffULL,
0x00005e0047467625ULL, 0x000fe200078e0006ULL, 0x0000004405447210ULL, 0x000fc60007f1e0ffULL,
0x00005e004f4e7625ULL, 0x000fe200078e0006ULL, 0x0000004605467210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000420a7faeULL, 0x0003e4000b901c46ULL,
0x0000000111537824ULL, 0x000fe400078e0256ULL, 0x000000ffff457224ULL, 0x000fe200000e0645ULL,
0x0000004e054e7210ULL, 0x000fe20007f1e0ffULL, 0x00005e0051507625ULL, 0x000fc600078e0006ULL,
0x0000004fff4f7210ULL, 0x000fe200007fe4ffULL, 0x00005e0053527625ULL, 0x000fe200078e0006ULL,
0x00000000440c7faeULL, 0x0003e6000b901c46ULL, 0x0000000113557824ULL, 0x100fe200078e0256ULL,
0x0000005205527210ULL, 0x000fe20007f1e0ffULL, 0x0000000115577824ULL, 0x100fe400078e0256ULL,
0x000000010b4d7824ULL, 0x100fe400078e0256ULL, 0x000000ffff477224ULL, 0x000fe200008e0647ULL,
0x0000005005507210ULL, 0x000fe20007f3e0ffULL, 0x00000001195b7824ULL, 0x000fc400078e0256ULL,
0x000000011b5d7824ULL, 0x100fe200078e0256ULL, 0x00000000460e7faeULL, 0x0003e2000b901c46ULL,
0x000000011f657824ULL, 0x100fe400078e0256ULL, 0x0000000121677824ULL, 0x100fe400078e0256ULL,
0x0000000123697824ULL, 0x000fe400078e0256ULL, 0x00005e0055547625ULL, 0x000fc800078e0006ULL,
0x00005e0057567625ULL, 0x000fc800078e0006ULL, 0x00005e004d4c7625ULL, 0x000fc800078e0006ULL,
0x000000ffff517224ULL, 0x000fe200008e0651ULL, 0x0000005405547210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff537224ULL, 0x000fe200000e0653ULL, 0x0000005605567210ULL, 0x000fe20007f1e0ffULL,
0x00005e005d5c7625ULL, 0x000fe200078e0006ULL, 0x0000004c054c7210ULL, 0x000fe40007f5e0ffULL,
0x00000057ff577210ULL, 0x000fe200007fe4ffULL, 0x00005e0059587625ULL, 0x000fe200078e0006ULL,
0x0000005c055c7210ULL, 0x000fc60007f1e0ffULL, 0x00005e005b5a7625ULL, 0x000fc800078e0006ULL,
0x000000ffff557224ULL, 0x000fe200008e0655ULL, 0x0000005805587210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff4d7224ULL, 0x000fe200010e064dULL, 0x0000005a055a7210ULL, 0x000fe20007f5e0ffULL,
0x00005e005f5e7625ULL, 0x000fc600078e0006ULL, 0x000000004c107faeULL, 0x0003e2000b901c46ULL,
0x00005e0065647625ULL, 0x000fc600078e0006ULL, 0x000000004e127faeULL, 0x0003e2000b901c46ULL,
0x00005e0067667625ULL, 0x000fc600078e0006ULL, 0x0000000050147faeULL, 0x0003e2000b901c46ULL,
0x00005e0069687625ULL, 0x000fc600078e0006ULL, 0x0000000052167faeULL, 0x0003e2000b901c46ULL,
0x000000ffff5d7224ULL, 0x000fe200000e065dULL, 0x0000005e05067210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff597224ULL, 0x000fe200008e0659ULL, 0x00000064055e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff5b7224ULL, 0x000fe200010e065bULL, 0x0000006605647210ULL, 0x040fe20007f5e0ffULL,
0x0000000054187faeULL, 0x0003e2000b901c46ULL, 0x0000006805667210ULL, 0x000fe40007f7e0ffULL,
0x0000005fff077210ULL, 0x000fe200007fe4ffULL, 0x000000ffff5f7224ULL, 0x000fe200008e0665ULL,
0x00000000561a7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff657224ULL, 0x000fc400010e0667ULL,
0x000000ffff677224ULL, 0x000fe200018e0669ULL, 0x00000000581c7faeULL, 0x0003e8000b901c46ULL,
0x000000005a1e7faeULL, 0x0003e8000b901c46ULL, 0x000000005c207faeULL, 0x0003e8000b901c46ULL,
0x0000000006227faeULL, 0x0003e8000b901c46ULL, 0x000000005e247faeULL, 0x0003e8000b901c46ULL,
0x0000000064267faeULL, 0x0003e8000b901c46ULL, 0x0000000066277faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001808067810ULL, 0x00afc40007ffe0ffULL,
0x0000001a080a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000706067812ULL, 0x100fe400078e7825ULL,
0x000000070a0a7812ULL, 0x000fe400078e7825ULL, 0x0000000625067211ULL, 0x000fc600078e28ffULL,
0x00000020250a7824ULL, 0x000fe400078e020aULL, 0x0000001006067824ULL, 0x000fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002814783bULL, 0x000fe80000000200ULL, 0x000000000610783bULL, 0x0002a80000000200ULL,
0x000000002a1c783bULL, 0x000ee80000000200ULL, 0x000000002918783bULL, 0x000f220000000200ULL,
0x0000001c08067810ULL, 0x002fc40007ffe0ffULL, 0x0000001e08087810ULL, 0x000fe20007ffe0ffULL,
0x000000002b20783bULL, 0x000e620000000200ULL, 0x0000000706067812ULL, 0x100fe400078e7825ULL,
0x0000000708087812ULL, 0x000fe200078e7825ULL, 0x000000000a0c783bULL, 0x000fe20000000200ULL,
0x0000000625067211ULL, 0x000fc600078e28ffULL, 0x000000002c44783bULL, 0x000fe20000000200ULL,
0x0000002025087824ULL, 0x000fe400078e0208ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000000007c4c783bULL, 0x000fe20000000200ULL, 0x0000001008087824ULL, 0x000fc600078e00ffULL,
0x000000009f9c783bULL, 0x000fe80000000200ULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x00000000a724783bULL, 0x000fe20000000200ULL, 0x000000141060723cULL, 0x044fe60000001860ULL,
0x00000000a628783bULL, 0x000fea0000000200ULL, 0x000000161070723cULL, 0x040fe20000001870ULL,
0x000000007d14783bULL, 0x000eae0000000200ULL, 0x0000001c1034723cULL, 0x048ff00000001834ULL,
0x0000001e1038723cULL, 0x040fe20000001838ULL, 0x00000000a31c783bULL, 0x000fee0000000200ULL,
0x00000018106c723cULL, 0x050ff0000000186cULL, 0x0000001a1030723cULL, 0x040fe20000001830ULL,
0x00000000a018783bULL, 0x000fee0000000200ULL, 0x00000020103c723cULL, 0x042ff0000000183cULL,
0x000000221048723cULL, 0x000fe20000001848ULL, 0x000000000610783bULL, 0x000e680000000200ULL,
0x00000000a220783bULL, 0x000ee60000000200ULL, 0x000000140c34723cULL, 0x044ff00000001834ULL,
0x000000160c38723cULL, 0x040fe20000001838ULL, 0x00000000a114783bULL, 0x000eae0000000200ULL,
0x000000440c60723cULL, 0x040ff00000001860ULL, 0x000000460c70723cULL, 0x040fe20000001870ULL,
0x00000000a544783bULL, 0x000fee0000000200ULL, 0x0000004c0c6c723cULL, 0x040ff0000000186cULL,
0x0000004e0c30723cULL, 0x040ff00000001830ULL, 0x0000009c0c3c723cULL, 0x040ff0000000183cULL,
0x0000009e0c48723cULL, 0x000fe20000001848ULL, 0x00000000a40c783bULL, 0x000f2e0000000200ULL,
0x000000181060723cULL, 0x042ff00000001860ULL, 0x0000001a1070723cULL, 0x040ff00000001870ULL,
0x0000001c106c723cULL, 0x040ff0000000186cULL, 0x0000001e1030723cULL, 0x040ff00000001830ULL,
0x000000201034723cULL, 0x048ff00000001834ULL, 0x000000221038723cULL, 0x040ff00000001838ULL,
0x00000014103c723cULL, 0x044ff0000000183cULL, 0x000000161048723cULL, 0x000ff00000001848ULL,
0x0000000c0860723cULL, 0x050ff00000001860ULL, 0x0000000e0870723cULL, 0x040ff00000001870ULL,
0x00000024086c723cULL, 0x040ff0000000186cULL, 0x000000260830723cULL, 0x040ff00000001830ULL,
0x000000280834723cULL, 0x040ff00000001834ULL, 0x0000002a0838723cULL, 0x040ff00000001838ULL,
0x00000044083c723cULL, 0x040ff0000000183cULL, 0x000000460848723cULL, 0x000fe20000001848ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fee0000008000ULL, 0x000000002d067f8cULL, 0x000fe2000c80043fULL,
0x3d80000060607820ULL, 0x000fc40000410000ULL, 0x3d80000061617820ULL, 0x000fe20000410000ULL,
0x000004002d057984ULL, 0x000e620000000800ULL, 0x3d80000062627820ULL, 0x000fe40000410000ULL,
0x3d80000063637820ULL, 0x000fe40000410000ULL, 0x3d80000070707820ULL, 0x000fe40000410000ULL,
0x3d80000071717820ULL, 0x000fe40000410000ULL, 0x3d80000072727820ULL, 0x000fc40000410000ULL,
0x3d80000073737820ULL, 0x000fe40000410000ULL, 0x3d8000006c6c7820ULL, 0x000fe40000410000ULL,
0x3d8000006d6d7820ULL, 0x000fe40000410000ULL, 0x3d8000006e6e7820ULL, 0x000fe40000410000ULL,
0x3d8000006f6f7820ULL, 0x000fe40000410000ULL, 0x3d80000030307820ULL, 0x000fc40000410000ULL,
0x3d80000031317820ULL, 0x000fe40000410000ULL, 0x3d80000032327820ULL, 0x000fe40000410000ULL,
0x3d80000033337820ULL, 0x000fe40000410000ULL, 0x3d80000034347820ULL, 0x000fe40000410000ULL,
0x3d80000035357820ULL, 0x000fe40000410000ULL, 0x3d80000036367820ULL, 0x000fc40000410000ULL,
0x3d80000037377820ULL, 0x000fe40000410000ULL, 0x3d80000038387820ULL, 0x000fe40000410000ULL,
0x3d80000039397820ULL, 0x000fe20000410000ULL, 0x8000000005ff7812ULL, 0x002fe20007804807ULL,
0x3d8000003a3a7820ULL, 0x000fe40000410000ULL, 0x3d8000003b3b7820ULL, 0x000fe40000410000ULL,
0x3d8000003c3c7820ULL, 0x000fc40000410000ULL, 0x3d8000003d3d7820ULL, 0x000fe40000410000ULL,
0x3d8000003e3e7820ULL, 0x000fe40000410000ULL, 0x3d8000003f3f7820ULL, 0x000fe40000410000ULL,
0x3d80000048487820ULL, 0x000fe40000410000ULL, 0x3d80000049497820ULL, 0x000fe40000410000ULL,
0x3d8000004a4a7820ULL, 0x000fc40000410000ULL, 0x3d8000004b4b7820ULL, 0x000fe20000410000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x3e00000000057802ULL, 0x000fc80000000f00ULL,
0x0000000500087305ULL, 0x0002a4000021f000ULL, 0x3fa0000005057823ULL, 0x002fe200000100ffULL,
0x000000080000735dULL, 0x004fe20003800000ULL, 0x000004002d097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xffffff9000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400197824ULL, 0x000fe200078e00ffULL, 0x000000027b00720cULL, 0x000fc80003f05270ULL,
0xfffffff019057812ULL, 0x000fca00078ec0ffULL, 0x000000807a187824ULL, 0x000fca00078e0205ULL,
0x01c4000018087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000200057824ULL, 0x000fe200078e00ffULL, 0x80000004790d7210ULL, 0x000fc80007ffe0ffULL,
0x0000000605057812ULL, 0x000fc800078ec0ffULL, 0x0000000105047812ULL, 0x040fe400078efcffULL,
0x0000000805067812ULL, 0x040fe400078efcffULL, 0x0000000d0400720cULL, 0x080fe40003f26070ULL,
0x0000001005047812ULL, 0x000fe400078efcffULL, 0x0000000d0600720cULL, 0x080fe40003f06070ULL,
0x0000000d0400720cULL, 0x000fc40003fc6070ULL, 0x0000001105067812ULL, 0x040fe400078efcffULL,
0x0000001805047812ULL, 0x040fe400078efcffULL, 0x0000000d0500720cULL, 0x0c0fe40003f46070ULL,
0x0000000d0600720cULL, 0x080fe40003fa6070ULL, 0x0000000d0400720cULL, 0x000fe40003f66070ULL,
0x0000000905077812ULL, 0x000fc400078efcffULL, 0x0000001905067812ULL, 0x040fe400078efcffULL,
0x0000002005047812ULL, 0x000fe400078efcffULL, 0xff7fffff62627808ULL, 0x000fe40005000000ULL,
0xff7fffff60607808ULL, 0x000fe40005000000ULL, 0xff7fffff63637808ULL, 0x000fe40004800000ULL,
0xff7fffff61617808ULL, 0x000fc40004800000ULL, 0x0000000d0700720cULL, 0x080fe40003f86070ULL,
0x0000000d0600720cULL, 0x080fe40003f46070ULL, 0x0000000d0400720cULL, 0x000fe40003f26070ULL,
0x0000002105067812ULL, 0x040fe400078efcffULL, 0x0000002805047812ULL, 0x000fe400078efcffULL,
0xff7fffff72727808ULL, 0x000fc40004000000ULL, 0xff7fffff70707808ULL, 0x000fe40004000000ULL,
0xff7fffff73737808ULL, 0x000fe40006000000ULL, 0xff7fffff71717808ULL, 0x000fe40006000000ULL,
0x0000000d0600720cULL, 0x080fe40003f06070ULL, 0x0000000d0400720cULL, 0x000fe40003f86070ULL,
0x0000002905067812ULL, 0x000fc400078efcffULL, 0x0000003005047812ULL, 0x000fe400078efcffULL,
0xff7fffff6e6e7808ULL, 0x000fe40007000000ULL, 0xff7fffff6c6c7808ULL, 0x000fe40007000000ULL,
0xff7fffff6f6f7808ULL, 0x000fe40006800000ULL, 0xff7fffff6d6d7808ULL, 0x000fe40006800000ULL,
0x0000000d0600720cULL, 0x000fc40003fc6070ULL, 0x0000000d0400720cULL, 0x000fe40003fa6070ULL,
0x0000003105067812ULL, 0x040fe400078efcffULL, 0x0000003805047812ULL, 0x040fe400078efcffULL,
0x0000003905057812ULL, 0x000fe400078efcffULL, 0xff7fffff32327808ULL, 0x000fe40005800000ULL,
0xff7fffff30307808ULL, 0x000fc40005800000ULL, 0xff7fffff33337808ULL, 0x000fe40005000000ULL,
0xff7fffff31317808ULL, 0x000fe40005000000ULL, 0xff7fffff36367808ULL, 0x000fe40004800000ULL,
0xff7fffff34347808ULL, 0x000fe40004800000ULL, 0x0000000d0600720cULL, 0x080fe40003f66070ULL,
0x0000000d0400720cULL, 0x000fc40003f46070ULL, 0x0000000d0500720cULL, 0x000fe40003f26070ULL,
0xff7fffff37377808ULL, 0x000fe40004000000ULL, 0xff7fffff35357808ULL, 0x000fe40004000000ULL,
0xff7fffff3a3a7808ULL, 0x000fe40006000000ULL, 0xff7fffff38387808ULL, 0x000fe40006000000ULL,
0xff7fffff3b3b7808ULL, 0x000fc40007000000ULL, 0xff7fffff39397808ULL, 0x000fe40007000000ULL,
0xff7fffff3e3e7808ULL, 0x000fe40006800000ULL, 0xff7fffff3c3c7808ULL, 0x000fe40006800000ULL,
0xff7fffff3f3f7808ULL, 0x000fe40005800000ULL, 0xff7fffff3d3d7808ULL, 0x000fe40005800000ULL,
0xff7fffff4a4a7808ULL, 0x000fc40005000000ULL, 0xff7fffff48487808ULL, 0x000fe40005000000ULL,
0xff7fffff4b4b7808ULL, 0x000fe40004800000ULL, 0xff7fffff49497808ULL, 0x000fe40004800000ULL,
0x0000006008087209ULL, 0x004fe40007810000ULL, 0x0000006209047209ULL, 0x000fe40007810000ULL,
0x0000006108057209ULL, 0x000fe40007810000ULL, 0x0000006304077209ULL, 0x000fc40007810000ULL,
0x0000007005047209ULL, 0x000fe40007810000ULL, 0x0000007207067209ULL, 0x000fe40007810000ULL,
0x0000007104057209ULL, 0x000fe40007810000ULL, 0x0000007306077209ULL, 0x000fe40007810000ULL,
0x0000006c05047209ULL, 0x000fe40007810000ULL, 0x0000006e07067209ULL, 0x000fc40007810000ULL,
0x0000006d04057209ULL, 0x000fe40007810000ULL, 0x0000006f06077209ULL, 0x000fe40007810000ULL,
0x0000003005047209ULL, 0x000fe40007810000ULL, 0x0000003207067209ULL, 0x000fe40007810000ULL,
0x0000003104057209ULL, 0x000fe40007810000ULL, 0x0000003306077209ULL, 0x000fc40007810000ULL,
0x0000003405047209ULL, 0x000fe40007810000ULL, 0x0000003607067209ULL, 0x000fe40007810000ULL,
0x0000003504057209ULL, 0x000fe40007810000ULL, 0x0000003706077209ULL, 0x000fe40007810000ULL,
0x0000003805047209ULL, 0x000fe40007810000ULL, 0x0000003a07067209ULL, 0x000fc40007810000ULL,
0x0000003904057209ULL, 0x000fe40007810000ULL, 0x0000003b06077209ULL, 0x000fe40007810000ULL,
0x0000003c05047209ULL, 0x000fe40007810000ULL, 0x0000003e07067209ULL, 0x000fe40007810000ULL,
0x0000003d04057209ULL, 0x000fe40007810000ULL, 0x0000003f06077209ULL, 0x000fc40007810000ULL,
0x0000004805047209ULL, 0x000fe40007810000ULL, 0x0000004a07067209ULL, 0x000fe40007810000ULL,
0x0000004904077209ULL, 0x000fe40007810000ULL, 0x0000004b060d7209ULL, 0x000fe20007810000ULL,
0x000018127f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x00000004070e7209ULL, 0x008fe20007810000ULL, 0x000018527f007947ULL, 0x000fea000b800000ULL,
0x0c401f000d047f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a057f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b067f89ULL, 0x000f6200000e0000ULL, 0x000000040d077209ULL, 0x00efc60007810000ULL,
0x0c201f000e047f89ULL, 0x000e6200000e0000ULL, 0x000000050a087209ULL, 0x010fc60007810000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x000000060b1a7209ULL, 0x020fc60007810000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f001a1b7f89ULL, 0x00092200000e0000ULL,
0x000000040e047209ULL, 0x002fe40007810000ULL, 0x0000000c07057209ULL, 0x004fe40007810000ULL,
0x0000000908067209ULL, 0x008fe40007810000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b05157820ULL, 0x000fe20000410000ULL,
0x0000000000057886ULL, 0x000fe200038e0100ULL, 0x3fb8aa3b61617823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b71717823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b60607823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b70707823ULL, 0x000fe20000010807ULL, 0x0000006100617308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b62627823ULL, 0x100fe40000010815ULL, 0x3fb8aa3b63637823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b72727823ULL, 0x000fc40000010815ULL, 0x3fb8aa3b73737823ULL, 0x000fe20000010815ULL,
0x0000006000087308ULL, 0x000e620000000800ULL, 0x3c003c00ff227424ULL, 0x000fe400078e00ffULL,
0x3c003c00ff237424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b6d6d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x00000070000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b6c6c7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b30307823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b6e6e7823ULL, 0x100fe40000010815ULL, 0x3fb8aa3b6f6f7823ULL, 0x100fe20000010815ULL,
0x0000007100717308ULL, 0x000ee20000000800ULL, 0x000000086108723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010815ULL, 0x3fb8aa3b33337823ULL, 0x000fe40000010815ULL,
0x3fb8aa3b35357823ULL, 0x000fc40000010807ULL, 0x0000006200097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b38387823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010815ULL,
0x00000063001c7308ULL, 0x000e620000000800ULL, 0x0000000a710a723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b37377823ULL, 0x000fc40000010815ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe40000010815ULL, 0x00000072000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b48487823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010815ULL,
0x00000073001e7308ULL, 0x000ee20000000800ULL, 0x000000091c09723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b3f3f7823ULL, 0x000fc40000010815ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe40000010815ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fe20000010815ULL, 0xfffffffc00157812ULL, 0x000fe200078ec0ffULL,
0x0000006c000c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b49077823ULL, 0x000fe20000010807ULL,
0x0000000b1e0b723eULL, 0x008fcc00000000ffULL, 0x0000006d006d7308ULL, 0x000e620000000800ULL,
0x000000220824723cULL, 0x000fee00000018ffULL, 0x00000030000e7308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ee20000000800ULL, 0x0000000c6d0c723eULL, 0x002fce00000000ffULL,
0x0000006e000d7308ULL, 0x000ff00000000800ULL, 0x0000006f00207308ULL, 0x000e620000000800ULL,
0x0000000e310e723eULL, 0x008fce00000000ffULL, 0x00000032000f7308ULL, 0x000ff00000000800ULL,
0x00000033001c7308ULL, 0x000ee20000000800ULL, 0x0000000d200d723eULL, 0x002fe200000000ffULL,
0x0000000fff207424ULL, 0x000fca00078e00ffULL, 0x0000001520207219ULL, 0x000fe200000006ffULL,
0x0000003400107308ULL, 0x000fe60000000800ULL, 0x00000000201d73a1ULL, 0x000e6200000e8000ULL,
0x00000000200473c4ULL, 0x000f620000004000ULL, 0x0000000f1c0f723eULL, 0x008fc600000000ffULL,
0x0000003500357308ULL, 0x000ee80000000800ULL, 0x000000220c24723cULL, 0x000fe80000001824ULL,
0x0000003800127308ULL, 0x000ff00000000800ULL, 0x0000003900397308ULL, 0x000f220000000800ULL,
0x000000103510723eULL, 0x008fc400000000ffULL, 0x0000000520ff7c12ULL, 0x002fca000f80401dULL,
0x0000003600117308ULL, 0x000ff00000000800ULL, 0x00000037001e7308ULL, 0x000e620000000800ULL,
0x000000123912723eULL, 0x010fce00000000ffULL, 0x0000003a00137308ULL, 0x000ff00000000800ULL,
0x0000003b001c7308ULL, 0x000ee20000000800ULL, 0x000000111e11723eULL, 0x002fce00000000ffULL,
0x0000003c00147308ULL, 0x000fe20000000800ULL, 0x000000131c13723eULL, 0x008fce00000000ffULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x000000221024723cULL, 0x000fee0000001824ULL,
0x0000004800167308ULL, 0x000ff00000000800ULL, 0x0000000700077308ULL, 0x000ee20000000800ULL,
0x000000143d14723eULL, 0x002fce00000000ffULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x000000160716723eULL, 0x008fe400000000ffULL,
0x0000001a1b077209ULL, 0x004fca0007810000ULL, 0x0000004a00177308ULL, 0x000ff00000000800ULL,
0x0000004b001c7308ULL, 0x000ea20000000800ULL, 0x0000003e3f15723eULL, 0x002fe400000000ffULL,
0x000000171c17723eULL, 0x004fce00000000ffULL, 0x000000221424723cULL, 0x000fe20000001824ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000146204008947ULL, 0x020fde000b800000ULL,
0x001c1fff241c7589ULL, 0x0002a400000e0000ULL, 0x00000000201b73a1ULL, 0x000ee200000e8000ULL,
0x00000000200473c4ULL, 0x000f220000004000ULL, 0x0000000000057886ULL, 0x000fe400038e0100ULL,
0x0000000520ff7c12ULL, 0x008fda000f80401bULL, 0x0000148204008947ULL, 0x010fea000b800000ULL,
0x001c1fff261d7589ULL, 0x00072800000e0000ULL, 0x001c1fff011e7589ULL, 0x00066800000e0000ULL,
0x001c1fff1f1f7589ULL, 0x0006a400000e0000ULL, 0x00000002ff1a7819ULL, 0x000fe40000011600ULL,
0x0000000c19377812ULL, 0x000fc400078ec0ffULL, 0x000000071a1b7812ULL, 0x040fe200078ec0ffULL,
0x000000081a247824ULL, 0x042fe200078e00ffULL, 0x0000001aff227212ULL, 0x000fe200078e33ffULL,
0x000000081a207824ULL, 0x048fe200078e00ffULL, 0x000000031a337819ULL, 0x040fe400000006ffULL,
0x000000081a1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff824217812ULL, 0x100fe400078ee21bULL,
0x0000000120237812ULL, 0x100fe200078ef61bULL, 0x000000081a477824ULL, 0x000fe200078e00ffULL,
0x0000000220257812ULL, 0x100fe200078ef61bULL, 0x000000081a247824ULL, 0x000fe200078e00ffULL,
0x0000000320277812ULL, 0x000fc400078ef61bULL, 0x0000000420297812ULL, 0x140fe400078ef61bULL,
0x00000005202b7812ULL, 0x140fe400078ef61bULL, 0x0000000620317812ULL, 0x000fe200078ef61bULL,
0x000000081a207824ULL, 0x040fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe400078ee222ULL,
0x0000001aff227212ULL, 0x000fe400078e33ffULL, 0x000000071a1b7812ULL, 0x000fc400078ec0ffULL,
0x000120007a1a7811ULL, 0x000fe400078e58ffULL, 0xfffffff824357812ULL, 0x100fe400078ee21bULL,
0x0000000120397812ULL, 0x140fe200078ef61bULL, 0x000000102b267824ULL, 0x100fe200078e021aULL,
0x00000002203b7812ULL, 0x140fe200078ef61bULL, 0x0000001031287824ULL, 0x100fe200078e021aULL,
0x00000003203d7812ULL, 0x140fe200078ef61bULL, 0x00000010332a7824ULL, 0x100fe200078e021aULL,
0x00000004203f7812ULL, 0x140fe200078ef61bULL, 0x00000010352c7824ULL, 0x100fe200078e021aULL,
0x0000000520437812ULL, 0x140fe200078ef61bULL, 0x0000001039307824ULL, 0x100fe200078e021aULL,
0x0000000620457812ULL, 0x000fe200078ef61bULL, 0x00000010231b7824ULL, 0x100fe200078e021aULL,
0x0000001a21197211ULL, 0x080fe200078e20ffULL, 0x0000001025207824ULL, 0x000fe200078e021aULL,
0xfffffff847477812ULL, 0x000fe200078ee222ULL, 0x0000001027227824ULL, 0x000fe200078e021aULL,
0x0000001a29247211ULL, 0x000fe200078e20ffULL, 0x00000001371b7824ULL, 0x040fe200078e021bULL,
0x0000001937197210ULL, 0x040fe20007ffe0ffULL, 0x0000000137217824ULL, 0x040fe200078e0220ULL,
0x0000002437257210ULL, 0x040fe20007ffe0ffULL, 0x0000000137237824ULL, 0x000fe200078e0222ULL,
0x0000001a3d327211ULL, 0x000fe200078e20ffULL, 0x0000000819007388ULL, 0x0003e20000000800ULL,
0x0000000137277824ULL, 0x040fe200078e0226ULL, 0x0000002c372c7210ULL, 0x000fe20007ffe0ffULL,
0x000000103b317824ULL, 0x000fe200078e021aULL, 0x0000000a1b007388ULL, 0x0007e20000000800ULL,
0x0000000137297824ULL, 0x000fe200078e0228ULL, 0x0000000300ff7812ULL, 0x000fe2000780c0ffULL,
0x000000103f337824ULL, 0x000fe200078e021aULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x00000001372b7824ULL, 0x000fe200078e022aULL, 0x0000001a47367211ULL, 0x000fe200078e20ffULL,
0x0000001043347824ULL, 0x100fe200078e021aULL, 0x0000000e23007388ULL, 0x0007e20000000800ULL,
0x0000001045357824ULL, 0x000fe200078e021aULL, 0x0000003337087210ULL, 0x042fe20007ffe0ffULL,
0x0000000137307824ULL, 0x040fe200078e0230ULL, 0x0000001025007388ULL, 0x0007e20000000800ULL,
0x00000001371a7824ULL, 0x000fc400078e0231ULL, 0x0000000137327824ULL, 0x040fe200078e0232ULL,
0x0000001227007388ULL, 0x0007e20000000800ULL, 0x0000000137347824ULL, 0x040fe400078e0234ULL,
0x0000000137207824ULL, 0x040fe200078e0235ULL, 0x0000001429007388ULL, 0x0007e20000000800ULL,
0x0000000137367824ULL, 0x000fc600078e0236ULL, 0x000000162b007388ULL, 0x0007e80000000800ULL,
0x000000092c007388ULL, 0x0007e80000000800ULL, 0x0000000b30007388ULL, 0x0007e80000000800ULL,
0x0000000d1a007388ULL, 0x0007e80000000800ULL, 0x0000000f32007388ULL, 0x0007e80000000800ULL,
0x0000001108007388ULL, 0x0007e80000000800ULL, 0x0000001334007388ULL, 0x0007e80000000800ULL,
0x0000001520007388ULL, 0x0007e80000000800ULL, 0x0000001736007388ULL, 0x0007e80000000800ULL,
0x01c0000418008388ULL, 0x0007e80000000c00ULL, 0x01c2001c18008388ULL, 0x0147e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6080003ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6100003ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01c6180003ff7f8cULL, 0x0009e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000784100720cULL, 0x000fe20003f06070ULL,
0x01c6200003ff7f8cULL, 0x0003e2000c80043fULL, 0x00000041007b7202ULL, 0x000fd60000000f00ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa0e000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff087807ULL, 0x004fe20004800000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x00014c7000487802ULL, 0x000fe40000000f00ULL,
0x0000106000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0037ULL,
0xfffed2d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff087807ULL, 0x000fe40005000000ULL,
0xffffffff00377802ULL, 0x000fe40000000f00ULL, 0x00014cd000487802ULL, 0x000fe40000000f00ULL,
0x0000100000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0037ULL,
0xfffed2f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e0008ULL,
0x00014d4000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00000f5000007944ULL, 0x00efea0003c00000ULL,
0x0000004a00097202ULL, 0x004fe20000000f00ULL, 0xfffed32000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x000fe200078e0008ULL, 0x00014db000487802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000ee000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e004aULL,
0xfffed2e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x000fe200078e002cULL,
0x00014e2000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00000e7000007944ULL, 0x000fea0003c00000ULL,
0x000000082c2f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff617224ULL, 0x004fe200078e004aULL,
0x0000001f004d7802ULL, 0x002fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x00014e9000487802ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fc400078e002fULL,
0x00000e0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff207224ULL, 0x004fe200078e004aULL,
0xfffed51000007947ULL, 0x000fea000383ffffULL, 0x00000001ff087807ULL, 0x004fe20004800000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x00014ef000487802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0037ULL,
0xfffef4f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff087807ULL, 0x000fe20005000000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x00014f5000487802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x008fea0003c00000ULL, 0x0000003700087202ULL, 0x000fe20000000f00ULL,
0xfffef51000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4d7424ULL, 0x002fe200078e00ffULL,
0x00014fb000487802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fc400078e00ffULL,
0x00000ce000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e004aULL,
0xfffef56000007947ULL, 0x000fea000383ffffULL, 0x000000ffff4c7224ULL, 0x002fe200078e002fULL,
0x0000001f004d7802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe200078e00ffULL,
0x0001502000487802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e004aULL, 0xfffef61000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0x0001508000487802ULL, 0x000fe20000000f00ULL,
0xffffffffff4e7424ULL, 0x000fc400078e00ffULL, 0x00000c1000007944ULL, 0x000fea0003c00000ULL,
0x0000004a00377202ULL, 0x004fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x002fe200078e002fULL,
0x000150e000487802ULL, 0x000fe20000000f00ULL, 0x0000001fff4d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x00000bb000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x004fe200078e004aULL, 0xfffef75000007947ULL, 0x000fea000383ffffULL,
0x00000001ff087807ULL, 0x004fe20004800000ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x0001514000487802ULL, 0x000fe40000000f00ULL, 0x00000b9000007944ULL, 0x008fea0003c00000ULL,
0x0000003700087202ULL, 0x000fe20000000f00ULL, 0xffff13f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff087807ULL, 0x000fe20005000000ULL, 0xffffffffff377424ULL, 0x000fe200078e00ffULL,
0x000151a000487802ULL, 0x000fe40000000f00ULL, 0x00000b3000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0037ULL, 0xffff141000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4d7424ULL, 0x002fe200078e00ffULL, 0xffffffff004e7802ULL, 0x000fe40000000f00ULL,
0x0001520000487802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e004aULL, 0xffff146000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4c7224ULL, 0x002fe200078e002fULL, 0x0001527000487802ULL, 0x000fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x00000a2000007944ULL, 0x008fea0003c00000ULL, 0x0000004a00087202ULL, 0x004fe20000000f00ULL,
0xffff151000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4d7424ULL, 0x000fe200078e00ffULL,
0x000152d000487802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x000009c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff377224ULL, 0x004fe200078e004aULL,
0x0000001f004d7802ULL, 0x002fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fe200078e002fULL,
0x0001533000487802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x0000096000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x004fe200078e004aULL,
0xffff165000007947ULL, 0x000fea000383ffffULL, 0x00000001ff087807ULL, 0x004fe20004000000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x0001539000487802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0037ULL,
0xffff32f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff087807ULL, 0x000fe40004800000ULL,
0xffffffff00377802ULL, 0x000fc40000000f00ULL, 0x000153f000487802ULL, 0x000fe40000000f00ULL,
0x000008e000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0037ULL,
0xffff331000007947ULL, 0x000fea000383ffffULL, 0x0000001fff4d7424ULL, 0x002fe200078e00ffULL,
0x0001545000487802ULL, 0x000fe20000000f00ULL, 0xffffffffff4e7424ULL, 0x000fe400078e00ffULL,
0x0000084000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e004aULL,
0xffff336000007947ULL, 0x000fea000383ffffULL, 0x0000002f004c7202ULL, 0x002fe20000000f00ULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0x000154c000487802ULL, 0x000fe20000000f00ULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x000007d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e004aULL, 0xffff341000007947ULL, 0x000fea000383ffffULL,
0x0000001fff4d7424ULL, 0x000fe200078e00ffULL, 0xffffffff004e7802ULL, 0x000fe40000000f00ULL,
0x0001552000487802ULL, 0x000fc40000000f00ULL, 0x0000077000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff317224ULL, 0x004fe200078e004aULL, 0x0001558000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x002fc400078e002fULL, 0x0000001fff4d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff4e7424ULL, 0x000fe400078e00ffULL, 0x0000071000007944ULL, 0x000fea0003c00000ULL,
0x0000004a00327202ULL, 0x004fe20000000f00ULL, 0xffff354000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x000155f000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff107424ULL, 0x000fe400078e00ffULL,
0x0000066000007944ULL, 0x002fea0003c00000ULL, 0x0000001b00047202ULL, 0x004fe20000000f00ULL,
0xffffe79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e000dULL,
0xffffffff00107802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001567000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0x000005e000007944ULL, 0x000fea0003c00000ULL, 0x0000001b0d067209ULL, 0x004fe20007810000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0xffffffff00107802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x000156e000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fc400078e00ffULL, 0x0000057000007944ULL, 0x000fea0003c00000ULL,
0x0000001b0a0a7209ULL, 0x004fe20007810000ULL, 0x000000ffff077224ULL, 0x002fe200078e000bULL,
0xffffffff00107802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001575000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x0000001b0b1a7209ULL, 0x004fe20007810000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0xffffffff00107802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000157c000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x0000001b0e047209ULL, 0x004fe20007810000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0xffffffff00107802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001583000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000001b06057209ULL, 0x004fe20007810000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0xffffffff00107802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000158a000087802ULL, 0x000fe20000000f00ULL,
0x0000001fff1b7424ULL, 0x000fc400078e00ffULL, 0x000003b000007944ULL, 0x000fea0003c00000ULL,
0x0000001b0a067209ULL, 0x004fe20007810000ULL, 0x000000ffff077224ULL, 0x002fe200078e001aULL,
0xffffffff00107802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0001591000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff1b7424ULL, 0x000fc400078e00ffULL,
0x0000034000007944ULL, 0x000fea0003c00000ULL, 0xffffe57000007947ULL, 0x000fea000383ffffULL,
0x00000024004b7202ULL, 0x000fe20000000f00ULL, 0x000000ffff4c7224ULL, 0x000fe200078e00ffULL,
0x0001598000487802ULL, 0x000fe20000000f00ULL, 0x00001c1fff4d7424ULL, 0x000fc400078e00ffULL,
0x000000ffff4e7224ULL, 0x000fe400078e0020ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000004a001c7202ULL, 0x004fe20000000f00ULL, 0xffffeb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff4b7224ULL, 0x002fe200078e0026ULL, 0x00000020004e7202ULL, 0x000fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x00015a0000487802ULL, 0x000fe20000000f00ULL,
0x00001c1fff4d7424ULL, 0x000fe400078e00ffULL, 0x0000029000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff4c7224ULL, 0x002fe200078e00ffULL, 0x0000004a001d7202ULL, 0x004fe20000000f00ULL,
0x00001c1fff4d7424ULL, 0x000fe200078e00ffULL, 0x00015a6000487802ULL, 0x000fe20000000f00ULL,
0x000000ffff4e7224ULL, 0x000fe400078e0020ULL, 0x0000023000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff4e7224ULL, 0x002fe200078e0020ULL, 0x0000004a001e7202ULL, 0x004fe20000000f00ULL,
0x000000ffff4c7224ULL, 0x000fe200078e00ffULL, 0x00015ac000487802ULL, 0x000fe20000000f00ULL,
0x00001c1fff4d7424ULL, 0x000fc400078e00ffULL, 0x000001d000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff1f7224ULL, 0x004fe200078e004aULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x018000002f037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000002f00038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff2fff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x800000002f047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002f00037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffea3b014007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000001000007348ULL, 0x000fe80003800000ULL, 0x0c00000c071b7389ULL, 0x0002a200000e001bULL,
0xfffea37008007950ULL, 0x000fea0003c3ffffULL, 0x0000000000497802ULL, 0x000fe20000000f00ULL,
0x0000004e00007348ULL, 0x000fe80003800000ULL, 0x0000004c4b4a7389ULL, 0x0002a200000e004dULL,
0xfffea33048007950ULL, 0x000fea0003c3ffffULL, 0x000000010800780cULL, 0x000fe20003f45070ULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x00000000ff097424ULL, 0x000fd000078e00ffULL,
0x0000000000087806ULL, 0x000fc800050e0100ULL, 0x0000003708377212ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fc800078e0048ULL, 0xfffea2c008007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x000000000001c700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000172ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000001b2ULL, 0x000000000000025fULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000418ULL, 0x00000000000001c8ULL, 0x0000001200000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x0000000100000105ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005e0ULL, 0x00000000000002e8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000029ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008c8ULL, 0x0000000000000090ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000043ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000958ULL, 0x0000000000000650ULL, 0x0000000e00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000100000147ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fa8ULL, 0x0000000000000020ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x7000000b00000163ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000fc8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x0000000900000112ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000fd8ULL, 0x0000000000000020ULL, 0x0000000c00000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x0000000900000124ULL, 0x0000000000000040ULL,
0x0000000000000000ULL, 0x0000000000000ff8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000006dULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001088ULL, 0x0000000000000008ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001090ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000000ULL, 0x00000001000000cfULL, 0x0000000000000042ULL,
0x0000000000000000ULL, 0x00000000000010a0ULL, 0x00000000000001b0ULL, 0x0000000e00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000032ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001280ULL, 0x0000000000015e00ULL, 0xd600001200000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017080ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000057ULL, 0x0000000000000043ULL,
0x0000000000000000ULL, 0x0000000000017090ULL, 0x0000000000000000ULL, 0x0000000e00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000800000099ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017090ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000017510ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001088ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000015ff8ULL, 0x0000000000015ff8ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000017080ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000010ULL, 0x0000000000000014ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000017510ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_256_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin_len = 95728;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
